(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     31622,       1134]*)
(*NotebookOutlinePosition[     45561,       1646]*)
(*  CellTagsIndexPosition[     42510,       1521]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["References", "Chapter",
  CellTags->"c:1"],

Cell[TextData[{
  "[AP91] U. Ascher and L. Petzold, \"Projected implicit Runge-Kutta methods \
for differential algebraic equations\",",
  " ",
  "SIAM J. Numer. Anal., ",
  StyleBox["28",
    FontWeight->"Bold"],
  ", 1991, 1097-1120."
}], "Reference",
  CellTags->"AP91"],

Cell[TextData[{
  "[AP98] U. Ascher and L. Petzold, ",
  StyleBox["Computer Methods for Ordinary Differential Equations and \
Differential-Algebraic Equations",
    FontSlant->"Italic"],
  ", Philadelphia, SIAM Press, 1998."
}], "Reference",
  CellTags->"AP98"],

Cell[TextData[{
  "[ATLAS00] R. C. Whaley, A. Petitet, and J. J. Dongarra, \"Automated \
empirical optimization of software and the ATLAS project\". Available \
electronically from ",
  ButtonBox["http://math-atlas.sourceforge.net/",
    ButtonData:>{
      URL[ "http://math-atlas.sourceforge.net/"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Reference",
  CellTags->"ATALS00"],

Cell[TextData[{
  "[BD83] G. Bader and P. Deuflhard, \"A semi-implicit mid-point rule for \
stiff systems of ordinary differential equations\". Numer. Math, ",
  StyleBox["41",
    FontWeight->"Bold"],
  ", 1983, 373-398."
}], "Reference",
  CellTags->"BD83"],

Cell[TextData[{
  "[BG94] G. Benettin and A. Giorgilli, \"On the Hamiltonian interpolation of \
near to the identity symplectic mappings with application to symplectic \
integration algorithms\". J. Stat. Phys. ",
  StyleBox["74",
    FontWeight->"Bold"],
  ", 1994, 1117-1143."
}], "Reference",
  CellTags->"BG94"],

Cell[TextData[{
  "[BZ65] I.S. Berezin and N.P. Zhidkov, ",
  StyleBox["Computing Methods",
    FontSlant->"Italic"],
  ", Volume 2, Pergamon, 1965."
}], "Reference",
  CellTags->"BZ65"],

Cell[TextData[{
  "[BM02] S. Blanes and P. C.",
  " ",
  "Moan, \"Practical symplectic partitioned Runge Kutta and Runge Kutta Nystr\
\[ODoubleDot]m methods\". J. Comput. Appl. Math. ",
  StyleBox["142",
    FontWeight->"Bold"],
  ", 2002, 313-330."
}], "Reference",
  CellTags->"BM02"],

Cell[TextData[{
  "[BCR99a] S. Blanes, F. Casas and J. Ros, \"Symplectic integration with \
processing: a general study\". SIAM J. Sci. Comput. ",
  StyleBox["21",
    FontWeight->"Bold"],
  ", 1999, 711-727."
}], "Reference",
  CellTags->"BCR99a"],

Cell["\<\
[BCR99b] S. Blanes, F. Casas and J. Ros, \"Extrapolation of \
symplectic integrators\". Report DAMTP NA09, Cambridge University, \
1999.\
\>", "Reference",
  CellTags->"BCR99b"],

Cell[TextData[{
  "[BS89a] P. Bogacki and L. F. Shampine, \"A 3(2) pair of Runge-Kutta \
formulas\". Appl. Math. Letters, ",
  StyleBox["2",
    FontWeight->"Bold"],
  ", 1989, 1-9."
}], "Reference",
  CellTags->"BS89a"],

Cell["\<\
[BS89b] P. Bogacki and L. F. Shampine, \"An efficient Runge-Kutta \
(4, 5) pair\". Report 89-20, Math. Dept. Southern Methodist University, \
Dallas, Texas, 1989.\
\>", "Reference",
  CellTags->"BS89b"],

Cell["\<\
[BGS93] R. W. Brankin, I. Gladwell and L. F. Shampine, \"RKSUITE: A \
Suite of Explicit Runge-Kutta Codes\". In: Contributions to Numerical \
Mathematics, R. P. Agarwal ed., WSSIAA 2. World Scientific, 1993, \
41-53.\
\>", "Reference",
  CellTags->"BGS93"],

Cell[TextData[{
  "[BCP89] K. Brenan, S. Campbell, and L. Petzold, ",
  StyleBox["Numerical Solutions of Initial-Value Problems in \
Differential-Algebraic Equations",
    FontSlant->"Italic"],
  ", New York, Elsevier Science Publishing, 1989."
}], "Reference",
  CellTags->"BCP89"],

Cell[TextData[{
  "[BHP94] P. N. Brown, A. C. Hindmarsh, and L. R. Petzold, \"Using Krylov \
Methods in the Solution of Large-Scale Differential-Algebraic Systems\", SIAM \
J. Sci. Comput., ",
  StyleBox["15",
    FontWeight->"Bold"],
  ", 1994, 1467-1488."
}], "Reference",
  CellTags->"BHP94"],

Cell[TextData[{
  "[BHP98] P. N. Brown, A. C. Hindmarsh, and L. R. Petzold, \"Consistent \
Initial Condition Calculation for Differential-Algebraic Systems\", SIAM J. \
Sci. Comput., ",
  StyleBox["19",
    FontWeight->"Bold"],
  ", 1998, 1495-1512."
}], "Reference",
  CellTags->"BHP98"],

Cell[TextData[{
  "[B87] J. C. Butcher, ",
  StyleBox["The numerical analysis of ordinary differential equations: Runge \
Kutta and general linear methods",
    FontSlant->"Italic"],
  ". John Wiley, Chichester, 1987."
}], "Reference",
  CellTags->"B87"],

Cell[TextData[{
  "[BS64] R. Bulirsch and J. Stoer, \"Fehlerabsch\[ADoubleDot]tzungen und \
Extrapolation mit rationalen Funktionen bei Verfahren vom Richardson-Typus\". \
Numer. Math., ",
  StyleBox["6",
    FontWeight->"Bold"],
  ", 1964, 413-427."
}], "Reference",
  CellTags->"BS64"],

Cell[TextData[{
  "[CIZ97] M. P. Calvo, A. Iserles and A. Zanna, \"Numerical solution of \
isospectral flows\". Math. Comp. ",
  StyleBox["66",
    FontWeight->"Bold"],
  " 220, 1997, 1461-1486."
}], "Reference",
  CellTags->"CIZ97"],

Cell[TextData[{
  "[CIZ99] M. P. Calvo, A. Iserles and A. Zanna, \"Conservative methods for \
the Toda lattice equations\". IMA J. Numer. Anal. ",
  StyleBox["19",
    FontWeight->"Bold"],
  ", 1999, 509-523."
}], "Reference",
  CellTags->"CIZ99"],

Cell[TextData[{
  "[CR91] J. Candy and R. Rozmus, \"A symplectic integration algorithm for \
separable Hamiltonian functions\". J. Comput. Phys. ",
  StyleBox["92",
    FontWeight->"Bold"],
  ", 1991, 230-256."
}], "Reference",
  CellTags->"CR91"],

Cell[TextData[{
  "[CH94] S. D. Cohen and A. C. Hindmarsh, ",
  StyleBox["CVODE User Guide",
    FontSlant->"Italic"],
  ", Lawrence Livermore National Laboratory report UCRL-MA-118618, September \
1994."
}], "Reference",
  CellTags->"CH94"],

Cell[TextData[{
  "[CH96] S. D. Cohen and A. C. Hindmarsh, \"CVODE, a Stiff/Nonstiff ODE \
Solver in C\", Computers in Physics, ",
  StyleBox["10",
    FontWeight->"Bold"],
  ", No. 2, 1996, 138-143."
}], "Reference",
  CellTags->"CH96"],

Cell[TextData[{
  "[C87] G. J. Cooper, \"Stability of Runge-Kutta methods for trajectory \
problems\", IMA J. Numer. Anal. ",
  StyleBox["7",
    FontWeight->"Bold"],
  ", 1987. 1-13."
}], "Reference",
  CellTags->"C87"],

Cell[TextData[{
  "[DP80] J. R. Dormand and P. J. Prince, \"A family of embedded Runge-Kutta \
formulae\". J. Comp. Appl. Math. ",
  StyleBox["6",
    FontWeight->"Bold"],
  ", 1980, 19-26."
}], "Reference",
  CellTags->"DP80"],

Cell[TextData[{
  "[DL01] N. Del Buono and L. Lopez, \"Runge-Kutta type methods based on \
geodesics for systems of ODEs on the Stiefel manifold\", BIT ",
  StyleBox["41",
    FontWeight->"Bold"],
  " (5), 2001, 912-923."
}], "Reference",
  CellTags->"DL01"],

Cell[TextData[{
  "[D83] P. Deuflhard, \"Order and step size control in extrapolation methods\
\". Numer. Math., ",
  StyleBox["41",
    FontWeight->"Bold"],
  ", 1983, 399-422."
}], "Reference",
  CellTags->"D83"],

Cell[TextData[{
  "[D85] P. Deuflhard, \"Recent progress in extrapolation methods for \
ordinary differential equations\". SIAM Rev., ",
  StyleBox["27",
    FontWeight->"Bold"],
  ", 1985, 505-535."
}], "Reference",
  CellTags->"D85"],

Cell["\<\
[DN87] P. Deuflhard and U. Nowak, \"Extrapolation integrators for \
quasilinear implicit ODEs\". In: P. Deuflhard, B. Engquist eds., Large-scale \
scientific computing, Birkh\[ADoubleDot]user, Boston, 1987.\
\>", "Reference",\

  CellTags->"DN87"],

Cell[TextData[{
  "[DHZ87] P. Deuflhard, E. Hairer and J. Zugck, \"One-step and extrapolation \
methods for differential-algebraic systems\". Numer. Math., ",
  StyleBox["51",
    FontWeight->"Bold"],
  ", 1987, 501-516."
}], "Reference",
  CellTags->"DHZ87"],

Cell[TextData[{
  "[DRV94] L. Dieci, R. D. Russel and E. S. Van Vleck, \"Unitary integrators \
and applications to continuous orthonormalization techniques\", SIAM J. Num. \
Anal. ",
  StyleBox["31",
    FontWeight->"Bold"],
  ", 1994, 261-281."
}], "Reference",
  CellTags->"DRV94"],

Cell[TextData[{
  "[DV99] L. Dieci and E. S. Van Vleck, \"Computation of orthonormal factors \
for fundamental solution matrices\", Numer. Math. ",
  StyleBox["83",
    FontWeight->"Bold"],
  ", 1999, 599-620."
}], "Reference",
  CellTags->"DV99"],

Cell[TextData[{
  "[DLP98a] F. Diele, L. Lopez and R. Peluso, \"The Cayley transform in the \
numerical solution of unitary differential systems\". Adv. Comput. Math., ",
  StyleBox["8",
    FontWeight->"Bold"],
  ", 1998, 317-334."
}], "Reference",
  CellTags->"DLP98a"],

Cell[TextData[{
  "[DLP98b] F. Diele, L. Lopez and T. Politi, \"One step semi-explicit \
methods based on the Cayley transform for solving isospectral flows\". J. \
Comput. Appl. Math. ",
  StyleBox["89",
    FontWeight->"Bold"],
  ", 1998, 219-223."
}], "Reference",
  CellTags->"DLP98b"],

Cell[TextData[{
  "[ET92] D. J. D. Earn and S. Tremaine, \"Exact numerical studies of \
Hamiltonian maps: iterating without roundoff error\". Physica D. ",
  StyleBox["56",
    FontWeight->"Bold"],
  ", 1992, 1-22."
}], "Reference",
  CellTags->"ET92"],

Cell[TextData[{
  "[F69] E. Fehlberg, \"Low-order classical Runge-Kutta formulas with step \
size control and their application to heat transfer problems\". NASA \
Technical Report 315, 1969 (extract published in Computing, ",
  StyleBox["6",
    FontWeight->"Bold"],
  ", 1970, 61-71)."
}], "Reference",
  CellTags->"F69"],

Cell[TextData[{
  "[FR90] E. Forest and R. D. Ruth, \"Fourth order symplectic integration\". \
Physica D. ",
  StyleBox["43",
    FontWeight->"Bold"],
  ", 1990, 105-117."
}], "Reference",
  CellTags->"FR90"],

Cell[TextData[{
  "[F92] B. Fornberg, \"Fast generation of weights in finite difference \
formulas,\" ",
  StyleBox["Recent Developments in Numerical Methods and Software for ",
    FontSlant->"Italic"],
  "ODE",
  StyleBox["s",
    FontSlant->"Italic"],
  "/DAE",
  StyleBox["s",
    FontSlant->"Italic"],
  "/PDE",
  StyleBox["s",
    FontSlant->"Italic"],
  " (G.D. Byrne and W. E. Schiesser, eds.), World Scientific, Singapore, \
1992, 97-123"
}], "Reference",
  CellTags->"F92"],

Cell[TextData[{
  "[F98] B. Fornberg, \"Calculation of weights in finite difference \
formulas\", ",
  StyleBox["SIAM Review",
    FontSlant->"Italic"],
  " 40 No. 3, 1998, 685-691. (Available in ",
  ButtonBox["PDF",
    ButtonData:>{
      URL[ "ftp://amath.colorado.edu/pub/fornberg/sirev_cl.pdf"], None},
    ButtonStyle->"Hyperlink"],
  ")"
}], "Reference",
  CellTags->"F98"],

Cell[TextData[{
  "[F96] B. Fornberg,",
  " ",
  StyleBox["A Practical guide to Pseudospectral Methods",
    FontSlant->"Italic"],
  ", Cambridge University Press, Cambridge, U.K., 1996."
}], "Reference",
  CellTags->"F96"],

Cell[TextData[{
  "[G51] S. Gill, \"A process for the step-by-step integration of \
differential equations\". In: an automatic digital computing machine, Proc. \
Cambridge Philos. Soc., ",
  StyleBox["47",
    FontWeight->"Bold"],
  ", 1951, 96-108."
}], "Reference",
  CellTags->"G51"],

Cell[TextData[{
  "[G65] W. B. Gragg, \"On extrapolation algorithms for ordinary initial \
value problems\". SIAM J. Num. Anal. ",
  StyleBox["2",
    FontWeight->"Bold"],
  ", 1965, 384-403."
}], "Reference",
  CellTags->"G65"],

Cell[TextData[{
  "[G\[CapitalOSlash]84] C. W. Gear and O. \[CapitalOSlash]sterby, \"Solving \
ordinary differential equations with discontinuities\". ACM Trans. Math. \
Soft. ",
  StyleBox["10",
    FontWeight->"Bold"],
  ", 1984, 23-44."
}], "Reference",
  CellTags->"G\[CapitalOSlash]84"],

Cell[TextData[{
  "[G91] K. Gustafsson, \"Control theoretic techniques for stepsize selection \
in explicit Runge-Kutta methods\". ACM Trans. Math. Soft., ",
  StyleBox["17",
    FontWeight->"Bold"],
  ", 533-554."
}], "Reference",
  CellTags->"G91"],

Cell[TextData[{
  "[G94] K. Gustafsson, \"Control theoretic techniques for stepsize selection \
in implicit Runge-Kutta methods\". ACM Trans. Math. Soft., ",
  StyleBox["20",
    FontWeight->"Bold"],
  ", 496-517."
}], "Reference",
  CellTags->"G94"],

Cell[TextData[{
  "[GMW81] P. Gill, W. Murray, and M. Wright, ",
  StyleBox["Practical Optimization",
    FontSlant->"Italic"],
  ", Academic Press, Oxford, 1981."
}], "Reference",
  CellTags->"GMW81"],

Cell[TextData[{
  "[GDC91] B. Gladman, M. Duncan, and J. Candy, \"Symplectic integrators for \
long-term integrations in celestial mechanics\". Celest. Mech. ",
  StyleBox["52",
    FontWeight->"Bold"],
  ", 1991, 221-240."
}], "Reference",
  CellTags->"GDC91"],

Cell[TextData[{
  "[GSB87] I. Gladwell, L. F. Shampine and R. W. Brankin, \"Automatic \
selection of the initial step size for an ODE solver\". J. Comp. Appl. Math. \
",
  StyleBox["18",
    FontWeight->"Bold"],
  ", 1987, 175-192."
}], "Reference",
  CellTags->"GSB87"],

Cell[TextData[{
  "[GVL96] G. H. Golub and C. F. Van Loan, ",
  StyleBox["Matrix computations",
    FontSlant->"Italic"],
  ", Johns Hopkins University Press, Baltimore, 3rd edn, 1996."
}], "Reference",
  CellTags->"GVL96"],

Cell[TextData[{
  "[H94] E. Hairer, \"Backward analysis of numerical integrators and \
symplectic methods\". Annals of Numerical Mathematics, ",
  StyleBox["1",
    FontWeight->"Bold"],
  ", 1984, 107-132."
}], "Reference",
  CellTags->"H94"],

Cell[TextData[{
  "[H97] E. Hairer, \"Variable time step integration with symplectic \
methods\". Appl. Numer. Math. ",
  StyleBox["25",
    FontWeight->"Bold"],
  ", 1997, 219-227."
}], "Reference",
  CellTags->"H97"],

Cell[TextData[{
  "[H00] E. Hairer, \"Symmetric projection methods for differential equations \
on manifolds\". BIT. ",
  StyleBox["40",
    FontWeight->"Bold"],
  " (4), 2000, 726-734."
}], "Reference",
  CellTags->"H00"],

Cell[TextData[{
  "[HL97] E. Hairer and Ch. Lubich, \"The life-span of backward error \
analysis for numerical integrators\". Numer. Math. ",
  StyleBox["76",
    FontWeight->"Bold"],
  ", 1997, 441-462. Erratum: http://www.unige.ch/math/folks/hairer."
}], "Reference",
  CellTags->"HL97"],

Cell[TextData[{
  "[HL88a] E. Hairer and Ch. Lubich, \"Extrapolation at stiff differential \
equations\". Numer. Math., ",
  StyleBox["52",
    FontWeight->"Bold"],
  ", 1988, 377-400."
}], "Reference",
  CellTags->"HL88a"],

Cell["\<\
[HL88b] E. Hairer and Ch. Lubich, \"On extrapolation methods for \
stiff and differential-algebraic equations\". Teubner Texte zur Mathematik, \
Band 104, Teubner, Leipzig, 1988, 64-73.\
\>", "Reference",
  CellTags->"HL88b"],

Cell[TextData[{
  "[HO90] E. Hairer and A. Ostermann, \"Dense output for extrapolation \
methods\". Numer. Math., ",
  StyleBox["58",
    FontWeight->"Bold"],
  ", 1990, 419-439."
}], "Reference",
  CellTags->"HO90"],

Cell[TextData[{
  "[HW96] E. Hairer and G. Wanner, ",
  StyleBox["Solving Ordinary Differential Equations II, Stiff and \
Differential-Algebraic Problem",
    FontSlant->"Italic"],
  "s, Springer-Verlag, Berlin,",
  " ",
  "2nd edn., 1996."
}], "Reference",
  CellTags->"HW96"],

Cell[TextData[{
  "[HW99] E. Hairer and G. Wanner, \"Stiff differential equations solved by \
Radau methods\", J. Comp. Appl. Math. ",
  StyleBox["111",
    FontWeight->"Bold"],
  ", 1999, 93-111."
}], "Reference",
  CellTags->"HW99"],

Cell[TextData[{
  "[HLW02] E. Hairer, Ch. Lubich and G. Wanner, ",
  StyleBox["Geometric Numerical Integration. Structure-Preserving Algorithms \
for Ordinary Differential Equations",
    FontSlant->"Italic"],
  ", Springer Ser. Comput. Math. 31, Springer-Verlag, 2002."
}], "Reference",
  CellTags->"HLW02"],

Cell[TextData[{
  "[HNW93] E. Hairer, S. P. N\[OSlash]rsett and G. Wanner, ",
  StyleBox["Solving Ordinary Differential Equations I, Nonstiff Problems",
    FontSlant->"Italic"],
  ", Springer-Verlag, Berlin, 2nd edn., 1993."
}], "Reference",
  CellTags->"HNW93"],

Cell[TextData[{
  "[H97] D. Higham, \"Time-stepping and preserving orthonormality\", BIT ",
  StyleBox["37",
    FontWeight->"Bold"],
  " 1, 1997, 24-36."
}], "Reference",
  CellTags->"H97"],

Cell["\<\
[H89] N. J. Higham, \"Matrix nearness problems and applications\". \
In: M. J. C. Gover and S. Barnett eds., Applications of Matrix Theory. Oxford \
University Press, Oxford, 1989, 1-27.\
\>", "Reference",
  CellTags->"H89"],

Cell[TextData[{
  "[H96] N. J. Higham, ",
  StyleBox["Accuracy and stability of numerical algorithms",
    FontSlant->"Italic"],
  ". SIAM, Philadelphia, 1996."
}], "Reference",
  CellTags->"H96"],

Cell["\<\
[H83] A. C. Hindmarsh, \"Odepack, a systematized collection of ode \
solvers\". In: Scientific Computing, R. S. Stepleman et al. eds., \
North-Holland, Amsterdam, 1983, 55-64.\
\>", "Reference",
  CellTags->"H83"],

Cell[TextData[{
  "[HT99] A Hindmarsh and A. Taylor, ",
  StyleBox["User Documentation for IDA,A Differential-Algebraic Equation \
Solver for Sequential and Parallel Computers, ",
    FontSlant->"Italic"],
  "Lawrence Livermore National Laboratory report",
  StyleBox[", ",
    FontSlant->"Italic"],
  "UCRL-MA-136910, December 1999"
}], "Reference",
  CellTags->"HT99"],

Cell[TextData[{
  "[KL97] W. H. Kahan and R. C. Li, \"Composition constants for raising the \
order of unconventional schemes for ordinary differential equations\". Math. \
Comp. ",
  StyleBox["66",
    FontWeight->"Bold"],
  ", 1997, 1089-1099."
}], "Reference",
  CellTags->"KL97"],

Cell["\<\
[K65] W. H. Kahan, \"Further remarks on reducing truncation \
errors\". Comm.ACM., Vol. 8 No.40., 1965.\
\>", "Reference",
  CellTags->"K65"],

Cell[TextData[{
  "[K93] I. Koren, ",
  StyleBox["Computer arithmetic algorithms",
    FontSlant->"Italic"],
  ". Prentice Hall, New Jersey, 1993."
}], "Reference",
  CellTags->"K93"],

Cell[TextData[{
  "[L87] J. D. Lambert, ",
  StyleBox["Numerical Methods for OrdinaryDifferential Equations",
    FontSlant->"Italic"],
  ". John Wiley, Chichester, 1987."
}], "Reference",
  CellTags->"L87"],

Cell[TextData[{
  "[LAPACK99] E. Anderson, Z. Bai, C. Bischof, S. Blackford, J. Demmel, J. \
Dongarra, J. Du Croz, A. Greenbaum, S. Hammarling, A. McKenney and D. \
Sorenson, ",
  StyleBox["LAPACK Users' Guide",
    FontSlant->"Italic"],
  ". 3rd edn. SIAM, Philadelphia, 1999."
}], "Reference",
  CellTags->"LAPACK99"],

Cell["\<\
[M68] G. Marchuk, \"Some applications of splitting-up methods to \
the solution of mathematical physics problems\", Aplikace Matematiky 13, \
1968, 103-132.\
\>", "Reference",
  CellTags->"M68"],

Cell[TextData[{
  "[MR99] J. E. Marsden and T. Ratiu, ",
  StyleBox["Introduction to mechanics and symmetry",
    FontSlant->"Italic"],
  ". Texts in Applied Mathematics, Vol. 17. 2nd edn. Springer-Verlag, New \
York. 1999."
}], "Reference",
  CellTags->"MR99"],

Cell[TextData[{
  "[M93] R. I. McLachlan, \"Explicit Lie-Poisson integration and the Euler \
equations\", Phys. Rev. Lett. ",
  StyleBox["71",
    FontWeight->"Bold"],
  ", 1993, 3043-3046."
}], "Reference",
  CellTags->"M93"],

Cell[TextData[{
  "[M95a] R. I. McLachlan, \"On the numerical integration of ordinary \
differential equations by symmetric composition methods\". SIAM J. Sci. Comp. \
",
  StyleBox["16",
    FontWeight->"Bold"],
  ", 1995, 151-168."
}], "Reference",
  CellTags->"M95a"],

Cell[TextData[{
  "[M95b] R. I. McLachlan, \"Composition methods in the presence of small \
parameters\". BIT. ",
  StyleBox["35",
    FontWeight->"Bold"],
  ", 1995, 258-268."
}], "Reference",
  CellTags->"M95b"],

Cell[TextData[{
  "[M01] R. I. McLachlan, \"Families of high-order composition methods\". \
Numerical Algorithms. ",
  StyleBox["31",
    FontWeight->"Bold"],
  ", 2002, 233-246."
}], "Reference",
  CellTags->"M01"],

Cell[TextData[{
  "[MA92] R. I. McLachlan and P. Atela, \"The accuracy of symplectic \
integrators\". Nonlinearity. ",
  StyleBox["5",
    FontWeight->"Bold"],
  ", 1992, 541-562."
}], "Reference",
  CellTags->"MA92"],

Cell[TextData[{
  "[MQ02] R. I. McLachlan and G. R. W. Quispel, \"Splitting methods\", Acta \
Numerica ",
  StyleBox["11",
    FontWeight->"Bold"],
  ",",
  " ",
  "2002, 341-434. "
}], "Reference",
  CellTags->"MQ02"],

Cell[TextData[{
  "[MG80] A. Mitchell and D. Griffiths, ",
  StyleBox["The Finite Difference Method in Partial Differential Equations",
    FontSlant->"Italic"],
  ", John Wiley and Sons, New York, 1980."
}], "Reference",
  CellTags->"MG80"],

Cell[TextData[{
  "[M65a] O. M\[OSlash]ller, \"Quasi double-precision in floating point \
addition\". BIT, ",
  StyleBox["5",
    FontWeight->"Bold"],
  ", 1965, 37-50."
}], "Reference",
  CellTags->"M65a"],

Cell[TextData[{
  "[M65b] O. M\[OSlash]ller, \"Note on quasi double-precision\". BIT, ",
  StyleBox["5",
    FontWeight->"Bold"],
  ", 1965, 251-255."
}], "Reference",
  CellTags->"M65b"],

Cell[TextData[{
  "[M97] A. Murua, \"On order conditions for partitioned symplectic \
methods\". SIAM J. Numer. Anal. ",
  StyleBox["34",
    FontWeight->"Bold"],
  " (6), 1997, 2204-2211."
}], "Reference",
  CellTags->"M97"],

Cell[TextData[{
  "[MS99] A. Murua and J. M. Sanz-Serna, \"Order conditions for numerical \
integrators obtained by composing simpler integrators\". Phil. Trans. Royal \
Soc. A ",
  StyleBox["357",
    FontWeight->"Bold"],
  ", 1999, 1079-1100."
}], "Reference",
  CellTags->"MS99"],

Cell[TextData[{
  "[M04] C. B. Moler, ",
  StyleBox["Numerical Computing with MATLAB",
    FontSlant->"Italic"],
  ", SIAM, Philadelphia, 2004."
}], "Reference",
  CellTags->"M04"],

Cell[TextData[{
  "[Na79] T. Y. Na, ",
  StyleBox["Computational Methods in Engineering: Boundary Value Problems",
    FontSlant->"Italic"],
  ", Academic Press, New York, 1979."
}], "Reference",
  CellTags->"Na79"],

Cell[TextData[{
  "[OS92] D. I. Okunbor and R. D. Skeel, \"Explicit canonical methods for \
Hamiltonian systems\". Math. Comp. ",
  StyleBox["59",
    FontWeight->"Bold"],
  ", 1992, 439-455."
}], "Reference",
  CellTags->"OS92"],

Cell["\<\
[O95] H. Olsson, \"Practical implementation of Runge-Kutta methods \
for initial value problems\". Licentiate thesis, Department of Computer \
Science, Lund University, 1995.\
\>", "Reference",
  CellTags->"O95"],

Cell["\<\
[O98] H. Olsson, \"Runge-Kutta solution of initial value problems: \
methods, algorithms and implementation\". PhD Thesis, Department of Computer \
Science, Lund University, 1998.\
\>", "Reference",
  CellTags->"O98"],

Cell[TextData[{
  "[OS00] H. Olsson and G. S\[ODoubleDot]derlind, \"The approximate \
Runge-Kutta computational process\". BIT, ",
  StyleBox["40",
    FontWeight->"Bold"],
  " No. 2, 2000, 351-373."
}], "Reference",
  CellTags->"OS00"],

Cell[TextData[{
  "[P83] L. R. Petzold, \"Automatic selection of methods for solving stiff \
and nonstiff systems of ordinary differential equations\". SIAM J. Sci. Stat. \
Comput. ",
  StyleBox["4",
    FontWeight->"Bold"],
  ", 1983, 136-148."
}], "Reference",
  CellTags->"P83"],

Cell[TextData[{
  "[QSS00] A. Quarteroni, R. Sacco, and F. Saleri, ",
  StyleBox["Numerical Mathematics",
    FontSlant->"Italic"],
  ", Springer-Verlag, New York, 2000."
}], "Reference",
  CellTags->"QSS00"],

Cell[TextData[{
  "[QV94] A. Quarteroni and A. Valli, ",
  StyleBox["Numerical Approximation of Partial Differential Equations",
    FontSlant->"Italic"],
  ", Springer-Verlag, Berlin, 1994."
}], "Reference",
  CellTags->"QV94"],

Cell[TextData[{
  "[QT90] T. Quinn and S. Tremaine, \"Roundoff error in long-term planetary \
orbit integrations\". Astron. J. ",
  StyleBox["99",
    FontWeight->"Bold"],
  " (3), 1990, 1016-1023."
}], "Reference",
  CellTags->"QT90"],

Cell["\<\
[R93] S. Reich, \"Numerical integration of the generalized Euler \
equations\", Tech. Rep. 93-20, 1993, Dept. Comput. Sci., Univ. of British \
Columbia.\
\>", "Reference",
  CellTags->"R93"],

Cell[TextData[{
  "[R99] S. Reich, \"Backward error analysis for numerical integrators\". \
SIAM J. Num. Anal., ",
  StyleBox["36",
    FontWeight->"Bold"],
  ", 1999, 1549-1570."
}], "Reference",
  CellTags->"R99"],

Cell[TextData[{
  "[R98] B. Rubinstein, \"Numerical Solution of Linear Boundary Value \
Problems\", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["MathSource",
    FontSlant->"Italic"],
  " package, ",
  ButtonBox["http://library.wolfram.com/database/MathSource/2127/",
    ButtonData:>{
      URL[ "http://library.wolfram.com/database/MathSource/2127/"], None},
    ButtonStyle->"Hyperlink"]
}], "Reference",
  CellTags->"R98"],

Cell[TextData[{
  "[RM57] R. Richtmeyer and K. Morton, ",
  StyleBox["Difference Methods for Initial Value Problems",
    FontSlant->"Italic"],
  ", Malabar, Krieger Publishing Company, Florida, 1994 (original edition \
1957)."
}], "Reference",
  CellTags->"RM57"],

Cell["\<\
[R87] B. C. Robertson, \"Detecting stiffness with explicit \
Runge-Kutta formulas\". Report 193/87, Dept. Comp. Sci., University of \
Toronto, 1987.\
\>", "Reference",
  CellTags->"R87"],

Cell[TextData[{
  "[SC94] J. M. Sanz-Serna and M. P. Calvo, ",
  StyleBox["Numerical Hamiltonian problems",
    FontSlant->"Italic"],
  ", Applied Mathematics and Mathematical Computation, ",
  StyleBox["7",
    FontWeight->"Bold"],
  ", Chapman and Hall, London, 1994."
}], "Reference",
  CellTags->"SC94"],

Cell[TextData[{
  "[S91] W. Schiesser, ",
  StyleBox["The Numerical Method of Lines",
    FontSlant->"Italic"],
  ", Academic Press,",
  " ",
  "San Diego, 1991."
}], "Reference",
  CellTags->"S91"],

Cell["\<\
[S86] L. F. Shampine. \"Conservation laws and the numerical \
solution of ODEs\", Comp. Maths. Appl. 12B, 1986, 1287-1296.\
\>", "Reference",\

  CellTags->"S86"],

Cell[TextData[{
  "[S87] L. F. Shampine, \"Control of step size and order in extrapolation \
codes\". J. Comp. Appl. Math., ",
  StyleBox["18",
    FontWeight->"Bold"],
  ", 1987, 3-16."
}], "Reference",
  CellTags->"S87"],

Cell[TextData[{
  "[S94] L. F. Shampine, ",
  StyleBox["Numerical solution of ordinary differential equations.",
    FontSlant->"Italic"],
  " Chapman and Hall, New York, 1994."
}], "Reference",
  CellTags->"S94"],

Cell[TextData[{
  "[SB83] L. F. Shampine and L. S. Baca, \"Smoothing the extrapolated \
midpoint rule\". Numer. Math.. ",
  StyleBox["41",
    FontWeight->"Bold"],
  ", 1983, 165-175."
}], "Reference",
  CellTags->"SB83"],

Cell[TextData[{
  "[SG75] L. Shampine and M. Gordon, ",
  StyleBox["Computer Solutions of Ordinary Differential Equations",
    FontSlant->"Italic"],
  ", San Francisco, W.H. Freeman, 1975."
}], "Reference",
  CellTags->"SG75"],

Cell[TextData[{
  "[SGT03] L. Shampine, I Gladwell, and S. Thompson, ",
  StyleBox["Solving ODEs with MATLAB",
    FontSlant->"Italic"],
  ", Cambridge University Press, Cambridge, 2003."
}], "Reference",
  CellTags->"SGT03"],

Cell[TextData[{
  "[SBB83] L. F. Shampine, L. S. Baca and H. J. Bauer, \"Output in \
extrapolation codes\". Comp. and Maths. with Appl. ",
  StyleBox["9",
    FontWeight->"Bold"],
  ", 1983, 245-255."
}], "Reference",
  CellTags->"SBB83"],

Cell["\<\
[SS02] M. Sofroniou and G. Spaletta, \"Increment formulations for \
rounding error reduction in the numerical solution of structured differential \
systems\". Future Generation Computer Systems, Del Buono and Politi eds., \
Elsevier Science, North-Holland, Amsterdam, 2002, 375-383.\
\>", "Reference",
  CellTags->"SS02"],

Cell["\<\
[SS04a] M. Sofroniou and G. Spaletta, \"Derivation of symmetric \
composition constants for symmetric integrators\", to appear in Optimization \
Methods and Software, 2004.\
\>", "Reference",
  CellTags->"SS04a"],

Cell["\<\
[SS04b] M. Sofroniou and G. Spaletta, \"Construction of explicit \
Runge-Kutta pairs with stiffness detection\", Mathematical and Computer \
Modelling, special issue on The Numerical Analysis of Ordinary Differential \
Equations, Elsevier Science, North Holland, Amsterdam, (accepted) 2004.\
\>", \
"Reference",
  CellTags->"SS04b"],

Cell["\<\
[S84] G. Sottas, \"Dynamic adaptive selection between explicit and \
implicit methods when solving ODEs\". Report, Sect. de math, University of \
Gen\[EGrave]ve, 1984.\
\>", "Reference",
  CellTags->"S84"],

Cell[TextData[{
  "[S68] G. Strang, \"On the construction of difference schemes\", SIAM J. \
Num. Anal. ",
  StyleBox["5",
    FontWeight->"Bold"],
  ", 1968, 506-517."
}], "Reference",
  CellTags->"S68"],

Cell[TextData[{
  "[S70] H. J. Stetter, \"Symmetric two-step algorithms for ordinary \
differential equations\". Computing, Vol. ",
  StyleBox["5",
    FontWeight->"Bold"],
  ", 1970, 267-280."
}], "Reference",
  CellTags->"S70"],

Cell[TextData[{
  "[S90] M. Suzuki, \"Fractal decomposition of exponential operators with \
applications to many-body theories and Monte Carlo simulations\", Phys. Lett. \
A ",
  StyleBox["146",
    FontWeight->"Bold"],
  ", 1990, 319-323."
}], "Reference",
  CellTags->"S90"],

Cell["\<\
[T59] H. F. Trotter, \"On the product of semi-group operators\", \
Proc. Am. Math. Soc. 10 ,1959, 545-551.\
\>", "Reference",
  CellTags->"T59"],

Cell[TextData[{
  "[V78] J. H. Verner, Explicit Runge-Kutta methods with estimates of the \
local truncation error, SIAM J. Num. Anal., Vol. ",
  StyleBox["15",
    FontWeight->"Bold"],
  ", 1978, 772-790."
}], "Reference",
  CellTags->"V78"],

Cell["\<\
[V79] E. Vitasek, \"A-stability and numerical solution of evolution \
problems\". IAC `Mauro Picone', Series III, Vol. 186, 1979, 42.\
\>", \
"Reference",
  CellTags->"V79"],

Cell[TextData[{
  "[W76] G.B. Whitham, ",
  StyleBox["Linear and Nonlinear Waves",
    FontSlant->"Italic"],
  ", John Wiley and Sons, New York, 1976."
}], "Reference",
  CellTags->"W76"],

Cell[TextData[{
  "[WH91] J. Wisdom and M. Holman, Symplectic maps for the N-body problem. \
Astron. J. ",
  StyleBox["102",
    FontWeight->"Bold"],
  ", 1991, 1528-1538."
}], "Reference",
  CellTags->"WH91"],

Cell[TextData[{
  "[Y90] H. Yoshida, \"Construction of high order symplectic integrators\". \
Phys. Lett. A. ",
  StyleBox["150",
    FontWeight->"Bold"],
  ", 1990, 262-268."
}], "Reference",
  CellTags->"Y90"],

Cell["\<\
[Z98] A. Zanna, On the numerical solution of isospectral flows, Ph. \
D. Thesis, Cambridge University, 1998.\
\>", "Reference",
  CellTags->"Z98"]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"References",
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[1776, 53, 48, 1, 87, "Chapter",
      CellTags->"c:1"]},
  "AP91"->{
    Cell[1827, 56, 273, 9, 40, "Reference",
      CellTags->"AP91"]},
  "AP98"->{
    Cell[2103, 67, 261, 7, 40, "Reference",
      CellTags->"AP98"]},
  "ATALS00"->{
    Cell[2367, 76, 385, 10, 40, "Reference",
      CellTags->"ATALS00"]},
  "BD83"->{
    Cell[2755, 88, 259, 7, 40, "Reference",
      CellTags->"BD83"]},
  "BG94"->{
    Cell[3017, 97, 315, 8, 40, "Reference",
      CellTags->"BG94"]},
  "BZ65"->{
    Cell[3335, 107, 186, 6, 24, "Reference",
      CellTags->"BZ65"]},
  "BM02"->{
    Cell[3524, 115, 286, 9, 40, "Reference",
      CellTags->"BM02"]},
  "BCR99a"->{
    Cell[3813, 126, 248, 7, 40, "Reference",
      CellTags->"BCR99a"]},
  "BCR99b"->{
    Cell[4064, 135, 187, 5, 40, "Reference",
      CellTags->"BCR99b"]},
  "BS89a"->{
    Cell[4254, 142, 220, 7, 24, "Reference",
      CellTags->"BS89a"]},
  "BS89b"->{
    Cell[4477, 151, 212, 5, 40, "Reference",
      CellTags->"BS89b"]},
  "BGS93"->{
    Cell[4692, 158, 266, 6, 40, "Reference",
      CellTags->"BGS93"]},
  "BCP89"->{
    Cell[4961, 166, 282, 7, 40, "Reference",
      CellTags->"BCP89"]},
  "BHP94"->{
    Cell[5246, 175, 295, 8, 40, "Reference",
      CellTags->"BHP94"]},
  "BHP98"->{
    Cell[5544, 185, 288, 8, 40, "Reference",
      CellTags->"BHP98"]},
  "B87"->{
    Cell[5835, 195, 254, 7, 40, "Reference",
      CellTags->"B87"]},
  "BS64"->{
    Cell[6092, 204, 287, 8, 40, "Reference",
      CellTags->"BS64"]},
  "CIZ97"->{
    Cell[6382, 214, 233, 7, 40, "Reference",
      CellTags->"CIZ97"]},
  "CIZ99"->{
    Cell[6618, 223, 247, 7, 40, "Reference",
      CellTags->"CIZ99"]},
  "CR91"->{
    Cell[6868, 232, 247, 7, 40, "Reference",
      CellTags->"CR91"]},
  "CH94"->{
    Cell[7118, 241, 241, 7, 40, "Reference",
      CellTags->"CH94"]},
  "CH96"->{
    Cell[7362, 250, 237, 7, 40, "Reference",
      CellTags->"CH96"]},
  "C87"->{
    Cell[7602, 259, 220, 7, 40, "Reference",
      CellTags->"C87"]},
  "DP80"->{
    Cell[7825, 268, 227, 7, 40, "Reference",
      CellTags->"DP80"]},
  "DL01"->{
    Cell[8055, 277, 258, 7, 40, "Reference",
      CellTags->"DL01"]},
  "D83"->{
    Cell[8316, 286, 214, 7, 24, "Reference",
      CellTags->"D83"]},
  "D85"->{
    Cell[8533, 295, 235, 7, 40, "Reference",
      CellTags->"D85"]},
  "DN87"->{
    Cell[8771, 304, 257, 6, 40, "Reference",
      CellTags->"DN87"]},
  "DHZ87"->{
    Cell[9031, 312, 259, 7, 40, "Reference",
      CellTags->"DHZ87"]},
  "DRV94"->{
    Cell[9293, 321, 283, 8, 40, "Reference",
      CellTags->"DRV94"]},
  "DV99"->{
    Cell[9579, 331, 247, 7, 40, "Reference",
      CellTags->"DV99"]},
  "DLP98a"->{
    Cell[9829, 340, 271, 7, 40, "Reference",
      CellTags->"DLP98a"]},
  "DLP98b"->{
    Cell[10103, 349, 289, 8, 40, "Reference",
      CellTags->"DLP98b"]},
  "ET92"->{
    Cell[10395, 359, 252, 7, 40, "Reference",
      CellTags->"ET92"]},
  "F69"->{
    Cell[10650, 368, 323, 8, 40, "Reference",
      CellTags->"F69"]},
  "FR90"->{
    Cell[10976, 378, 208, 7, 24, "Reference",
      CellTags->"FR90"]},
  "F92"->{
    Cell[11187, 387, 483, 17, 56, "Reference",
      CellTags->"F92"]},
  "F98"->{
    Cell[11673, 406, 381, 12, 70, "Reference",
      CellTags->"F98"]},
  "F96"->{
    Cell[12057, 420, 223, 7, 70, "Reference",
      CellTags->"F96"]},
  "G51"->{
    Cell[12283, 429, 286, 8, 40, "Reference",
      CellTags->"G51"]},
  "G65"->{
    Cell[12572, 439, 228, 7, 40, "Reference",
      CellTags->"G65"]},
  "G\[CapitalOSlash]84"->{
    Cell[12803, 448, 291, 8, 40, "Reference",
      CellTags->"G\[CapitalOSlash]84"]},
  "G91"->{
    Cell[13097, 458, 250, 7, 40, "Reference",
      CellTags->"G91"]},
  "G94"->{
    Cell[13350, 467, 250, 7, 40, "Reference",
      CellTags->"G94"]},
  "GMW81"->{
    Cell[13603, 476, 201, 6, 24, "Reference",
      CellTags->"GMW81"]},
  "GDC91"->{
    Cell[13807, 484, 261, 7, 40, "Reference",
      CellTags->"GDC91"]},
  "GSB87"->{
    Cell[14071, 493, 270, 8, 40, "Reference",
      CellTags->"GSB87"]},
  "GVL96"->{
    Cell[14344, 503, 223, 6, 40, "Reference",
      CellTags->"GVL96"]},
  "H94"->{
    Cell[14570, 511, 242, 7, 40, "Reference",
      CellTags->"H94"]},
  "H97"->{
    Cell[14815, 520, 218, 7, 40, "Reference",
      CellTags->"H97"],
    Cell[17330, 609, 190, 6, 24, "Reference",
      CellTags->"H97"]},
  "H00"->{
    Cell[15036, 529, 222, 7, 40, "Reference",
      CellTags->"H00"]},
  "HL97"->{
    Cell[15261, 538, 289, 7, 40, "Reference",
      CellTags->"HL97"]},
  "HL88a"->{
    Cell[15553, 547, 223, 7, 40, "Reference",
      CellTags->"HL88a"]},
  "HL88b"->{
    Cell[15779, 556, 235, 5, 40, "Reference",
      CellTags->"HL88b"]},
  "HO90"->{
    Cell[16017, 563, 216, 7, 40, "Reference",
      CellTags->"HO90"]},
  "HW96"->{
    Cell[16236, 572, 277, 9, 40, "Reference",
      CellTags->"HW96"]},
  "HW99"->{
    Cell[16516, 583, 234, 7, 40, "Reference",
      CellTags->"HW99"]},
  "HLW02"->{
    Cell[16753, 592, 308, 7, 40, "Reference",
      CellTags->"HLW02"]},
  "HNW93"->{
    Cell[17064, 601, 263, 6, 40, "Reference",
      CellTags->"HNW93"]},
  "H89"->{
    Cell[17523, 617, 234, 5, 40, "Reference",
      CellTags->"H89"]},
  "H96"->{
    Cell[17760, 624, 196, 6, 24, "Reference",
      CellTags->"H96"]},
  "H83"->{
    Cell[17959, 632, 223, 5, 40, "Reference",
      CellTags->"H83"]},
  "HT99"->{
    Cell[18185, 639, 370, 10, 56, "Reference",
      CellTags->"HT99"]},
  "KL97"->{
    Cell[18558, 651, 283, 8, 40, "Reference",
      CellTags->"KL97"]},
  "K65"->{
    Cell[18844, 661, 151, 4, 24, "Reference",
      CellTags->"K65"]},
  "K93"->{
    Cell[18998, 667, 183, 6, 24, "Reference",
      CellTags->"K93"]},
  "L87"->{
    Cell[19184, 675, 207, 6, 24, "Reference",
      CellTags->"L87"]},
  "LAPACK99"->{
    Cell[19394, 683, 319, 8, 56, "Reference",
      CellTags->"LAPACK99"]},
  "M68"->{
    Cell[19716, 693, 204, 5, 40, "Reference",
      CellTags->"M68"]},
  "MR99"->{
    Cell[19923, 700, 261, 7, 40, "Reference",
      CellTags->"MR99"]},
  "M93"->{
    Cell[20187, 709, 226, 7, 40, "Reference",
      CellTags->"M93"]},
  "M95a"->{
    Cell[20416, 718, 270, 8, 40, "Reference",
      CellTags->"M95a"]},
  "M95b"->{
    Cell[20689, 728, 213, 7, 24, "Reference",
      CellTags->"M95b"]},
  "M01"->{
    Cell[20905, 737, 215, 7, 24, "Reference",
      CellTags->"M01"]},
  "MA92"->{
    Cell[21123, 746, 217, 7, 24, "Reference",
      CellTags->"MA92"]},
  "MQ02"->{
    Cell[21343, 755, 218, 9, 24, "Reference",
      CellTags->"MQ02"]},
  "MG80"->{
    Cell[21564, 766, 241, 6, 40, "Reference",
      CellTags->"MG80"]},
  "M65a"->{
    Cell[21808, 774, 206, 7, 24, "Reference",
      CellTags->"M65a"]},
  "M65b"->{
    Cell[22017, 783, 187, 6, 24, "Reference",
      CellTags->"M65b"]},
  "M97"->{
    Cell[22207, 791, 225, 7, 40, "Reference",
      CellTags->"M97"]},
  "MS99"->{
    Cell[22435, 800, 282, 8, 40, "Reference",
      CellTags->"MS99"]},
  "M04"->{
    Cell[22720, 810, 180, 6, 24, "Reference",
      CellTags->"M04"]},
  "Na79"->{
    Cell[22903, 818, 215, 6, 40, "Reference",
      CellTags->"Na79"]},
  "OS92"->{
    Cell[23121, 826, 229, 7, 40, "Reference",
      CellTags->"OS92"]},
  "O95"->{
    Cell[23353, 835, 222, 5, 40, "Reference",
      CellTags->"O95"]},
  "O98"->{
    Cell[23578, 842, 227, 5, 40, "Reference",
      CellTags->"O98"]},
  "OS00"->{
    Cell[23808, 849, 236, 7, 40, "Reference",
      CellTags->"OS00"]},
  "P83"->{
    Cell[24047, 858, 281, 8, 40, "Reference",
      CellTags->"P83"]},
  "QSS00"->{
    Cell[24331, 868, 208, 6, 24, "Reference",
      CellTags->"QSS00"]},
  "QV94"->{
    Cell[24542, 876, 228, 6, 40, "Reference",
      CellTags->"QV94"]},
  "QT90"->{
    Cell[24773, 884, 235, 7, 40, "Reference",
      CellTags->"QT90"]},
  "R93"->{
    Cell[25011, 893, 200, 5, 40, "Reference",
      CellTags->"R93"]},
  "R99"->{
    Cell[25214, 900, 215, 7, 40, "Reference",
      CellTags->"R99"]},
  "R98"->{
    Cell[25432, 909, 455, 14, 40, "Reference",
      CellTags->"R98"]},
  "RM57"->{
    Cell[25890, 925, 264, 7, 40, "Reference",
      CellTags->"RM57"]},
  "R87"->{
    Cell[26157, 934, 196, 5, 40, "Reference",
      CellTags->"R87"]},
  "SC94"->{
    Cell[26356, 941, 307, 9, 40, "Reference",
      CellTags->"SC94"]},
  "S91"->{
    Cell[26666, 952, 198, 8, 24, "Reference",
      CellTags->"S91"]},
  "S86"->{
    Cell[26867, 962, 172, 5, 40, "Reference",
      CellTags->"S86"]},
  "S87"->{
    Cell[27042, 969, 222, 7, 40, "Reference",
      CellTags->"S87"]},
  "S94"->{
    Cell[27267, 978, 213, 6, 24, "Reference",
      CellTags->"S94"]},
  "SB83"->{
    Cell[27483, 986, 221, 7, 40, "Reference",
      CellTags->"SB83"]},
  "SG75"->{
    Cell[27707, 995, 227, 6, 40, "Reference",
      CellTags->"SG75"]},
  "SGT03"->{
    Cell[27937, 1003, 225, 6, 40, "Reference",
      CellTags->"SGT03"]},
  "SBB83"->{
    Cell[28165, 1011, 238, 7, 40, "Reference",
      CellTags->"SBB83"]},
  "SS02"->{
    Cell[28406, 1020, 331, 6, 56, "Reference",
      CellTags->"SS02"]},
  "SS04a"->{
    Cell[28740, 1028, 222, 5, 40, "Reference",
      CellTags->"SS04a"]},
  "SS04b"->{
    Cell[28965, 1035, 342, 7, 56, "Reference",
      CellTags->"SS04b"]},
  "S84"->{
    Cell[29310, 1044, 215, 5, 40, "Reference",
      CellTags->"S84"]},
  "S68"->{
    Cell[29528, 1051, 204, 7, 24, "Reference",
      CellTags->"S68"]},
  "S70"->{
    Cell[29735, 1060, 229, 7, 40, "Reference",
      CellTags->"S70"]},
  "S90"->{
    Cell[29967, 1069, 276, 8, 40, "Reference",
      CellTags->"S90"]},
  "T59"->{
    Cell[30246, 1079, 154, 4, 24, "Reference",
      CellTags->"T59"]},
  "V78"->{
    Cell[30403, 1085, 242, 7, 40, "Reference",
      CellTags->"V78"]},
  "V79"->{
    Cell[30648, 1094, 183, 5, 40, "Reference",
      CellTags->"V79"]},
  "W76"->{
    Cell[30834, 1101, 187, 6, 24, "Reference",
      CellTags->"W76"]},
  "WH91"->{
    Cell[31024, 1109, 209, 7, 24, "Reference",
      CellTags->"WH91"]},
  "Y90"->{
    Cell[31236, 1118, 211, 7, 24, "Reference",
      CellTags->"Y90"]},
  "Z98"->{
    Cell[31450, 1127, 156, 4, 24, "Reference",
      CellTags->"Z98"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 32357, 1155},
  {"AP91", 32435, 1158},
  {"AP98", 32517, 1161},
  {"ATALS00", 32602, 1164},
  {"BD83", 32688, 1167},
  {"BG94", 32770, 1170},
  {"BZ65", 32852, 1173},
  {"BM02", 32935, 1176},
  {"BCR99a", 33020, 1179},
  {"BCR99b", 33107, 1182},
  {"BS89a", 33193, 1185},
  {"BS89b", 33278, 1188},
  {"BGS93", 33363, 1191},
  {"BCP89", 33448, 1194},
  {"BHP94", 33533, 1197},
  {"BHP98", 33618, 1200},
  {"B87", 33701, 1203},
  {"BS64", 33783, 1206},
  {"CIZ97", 33867, 1209},
  {"CIZ99", 33952, 1212},
  {"CR91", 34036, 1215},
  {"CH94", 34119, 1218},
  {"CH96", 34202, 1221},
  {"C87", 34284, 1224},
  {"DP80", 34366, 1227},
  {"DL01", 34449, 1230},
  {"D83", 34531, 1233},
  {"D85", 34612, 1236},
  {"DN87", 34694, 1239},
  {"DHZ87", 34778, 1242},
  {"DRV94", 34863, 1245},
  {"DV99", 34947, 1248},
  {"DLP98a", 35032, 1251},
  {"DLP98b", 35119, 1254},
  {"ET92", 35205, 1257},
  {"F69", 35288, 1260},
  {"FR90", 35371, 1263},
  {"F92", 35454, 1266},
  {"F98", 35537, 1269},
  {"F96", 35620, 1272},
  {"G51", 35702, 1275},
  {"G65", 35784, 1278},
  {"G\[CapitalOSlash]84", 35882, 1281},
  {"G91", 35980, 1284},
  {"G94", 36062, 1287},
  {"GMW81", 36146, 1290},
  {"GDC91", 36232, 1293},
  {"GSB87", 36318, 1296},
  {"GVL96", 36404, 1299},
  {"H94", 36488, 1302},
  {"H97", 36570, 1305},
  {"H00", 36722, 1310},
  {"HL97", 36805, 1313},
  {"HL88a", 36890, 1316},
  {"HL88b", 36976, 1319},
  {"HO90", 37061, 1322},
  {"HW96", 37145, 1325},
  {"HW99", 37229, 1328},
  {"HLW02", 37314, 1331},
  {"HNW93", 37400, 1334},
  {"H89", 37484, 1337},
  {"H96", 37566, 1340},
  {"H83", 37648, 1343},
  {"HT99", 37731, 1346},
  {"KL97", 37816, 1349},
  {"K65", 37899, 1352},
  {"K93", 37981, 1355},
  {"L87", 38063, 1358},
  {"LAPACK99", 38150, 1361},
  {"M68", 38237, 1364},
  {"MR99", 38320, 1367},
  {"M93", 38403, 1370},
  {"M95a", 38486, 1373},
  {"M95b", 38570, 1376},
  {"M01", 38653, 1379},
  {"MA92", 38736, 1382},
  {"MQ02", 38820, 1385},
  {"MG80", 38904, 1388},
  {"M65a", 38988, 1391},
  {"M65b", 39072, 1394},
  {"M97", 39155, 1397},
  {"MS99", 39238, 1400},
  {"M04", 39321, 1403},
  {"Na79", 39404, 1406},
  {"OS92", 39488, 1409},
  {"O95", 39571, 1412},
  {"O98", 39653, 1415},
  {"OS00", 39736, 1418},
  {"P83", 39819, 1421},
  {"QSS00", 39903, 1424},
  {"QV94", 39988, 1427},
  {"QT90", 40072, 1430},
  {"R93", 40155, 1433},
  {"R99", 40237, 1436},
  {"R98", 40319, 1439},
  {"RM57", 40403, 1442},
  {"R87", 40486, 1445},
  {"SC94", 40569, 1448},
  {"S91", 40652, 1451},
  {"S86", 40734, 1454},
  {"S87", 40816, 1457},
  {"S94", 40898, 1460},
  {"SB83", 40981, 1463},
  {"SG75", 41065, 1466},
  {"SGT03", 41150, 1469},
  {"SBB83", 41237, 1472},
  {"SS02", 41323, 1475},
  {"SS04a", 41409, 1478},
  {"SS04b", 41496, 1481},
  {"S84", 41581, 1484},
  {"S68", 41664, 1487},
  {"S70", 41747, 1490},
  {"S90", 41830, 1493},
  {"T59", 41913, 1496},
  {"V78", 41996, 1499},
  {"V79", 42079, 1502},
  {"W76", 42162, 1505},
  {"WH91", 42246, 1508},
  {"Y90", 42330, 1511},
  {"Z98", 42413, 1514}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 48, 1, 87, "Chapter",
  CellTags->"c:1"],
Cell[1827, 56, 273, 9, 40, "Reference",
  CellTags->"AP91"],
Cell[2103, 67, 261, 7, 40, "Reference",
  CellTags->"AP98"],
Cell[2367, 76, 385, 10, 40, "Reference",
  CellTags->"ATALS00"],
Cell[2755, 88, 259, 7, 40, "Reference",
  CellTags->"BD83"],
Cell[3017, 97, 315, 8, 40, "Reference",
  CellTags->"BG94"],
Cell[3335, 107, 186, 6, 24, "Reference",
  CellTags->"BZ65"],
Cell[3524, 115, 286, 9, 40, "Reference",
  CellTags->"BM02"],
Cell[3813, 126, 248, 7, 40, "Reference",
  CellTags->"BCR99a"],
Cell[4064, 135, 187, 5, 40, "Reference",
  CellTags->"BCR99b"],
Cell[4254, 142, 220, 7, 24, "Reference",
  CellTags->"BS89a"],
Cell[4477, 151, 212, 5, 40, "Reference",
  CellTags->"BS89b"],
Cell[4692, 158, 266, 6, 40, "Reference",
  CellTags->"BGS93"],
Cell[4961, 166, 282, 7, 40, "Reference",
  CellTags->"BCP89"],
Cell[5246, 175, 295, 8, 40, "Reference",
  CellTags->"BHP94"],
Cell[5544, 185, 288, 8, 40, "Reference",
  CellTags->"BHP98"],
Cell[5835, 195, 254, 7, 40, "Reference",
  CellTags->"B87"],
Cell[6092, 204, 287, 8, 40, "Reference",
  CellTags->"BS64"],
Cell[6382, 214, 233, 7, 40, "Reference",
  CellTags->"CIZ97"],
Cell[6618, 223, 247, 7, 40, "Reference",
  CellTags->"CIZ99"],
Cell[6868, 232, 247, 7, 40, "Reference",
  CellTags->"CR91"],
Cell[7118, 241, 241, 7, 40, "Reference",
  CellTags->"CH94"],
Cell[7362, 250, 237, 7, 40, "Reference",
  CellTags->"CH96"],
Cell[7602, 259, 220, 7, 40, "Reference",
  CellTags->"C87"],
Cell[7825, 268, 227, 7, 40, "Reference",
  CellTags->"DP80"],
Cell[8055, 277, 258, 7, 40, "Reference",
  CellTags->"DL01"],
Cell[8316, 286, 214, 7, 24, "Reference",
  CellTags->"D83"],
Cell[8533, 295, 235, 7, 40, "Reference",
  CellTags->"D85"],
Cell[8771, 304, 257, 6, 40, "Reference",
  CellTags->"DN87"],
Cell[9031, 312, 259, 7, 40, "Reference",
  CellTags->"DHZ87"],
Cell[9293, 321, 283, 8, 40, "Reference",
  CellTags->"DRV94"],
Cell[9579, 331, 247, 7, 40, "Reference",
  CellTags->"DV99"],
Cell[9829, 340, 271, 7, 40, "Reference",
  CellTags->"DLP98a"],
Cell[10103, 349, 289, 8, 40, "Reference",
  CellTags->"DLP98b"],
Cell[10395, 359, 252, 7, 40, "Reference",
  CellTags->"ET92"],
Cell[10650, 368, 323, 8, 40, "Reference",
  CellTags->"F69"],
Cell[10976, 378, 208, 7, 24, "Reference",
  CellTags->"FR90"],
Cell[11187, 387, 483, 17, 56, "Reference",
  CellTags->"F92"],
Cell[11673, 406, 381, 12, 70, "Reference",
  CellTags->"F98"],
Cell[12057, 420, 223, 7, 70, "Reference",
  CellTags->"F96"],
Cell[12283, 429, 286, 8, 40, "Reference",
  CellTags->"G51"],
Cell[12572, 439, 228, 7, 40, "Reference",
  CellTags->"G65"],
Cell[12803, 448, 291, 8, 40, "Reference",
  CellTags->"G\[CapitalOSlash]84"],
Cell[13097, 458, 250, 7, 40, "Reference",
  CellTags->"G91"],
Cell[13350, 467, 250, 7, 40, "Reference",
  CellTags->"G94"],
Cell[13603, 476, 201, 6, 24, "Reference",
  CellTags->"GMW81"],
Cell[13807, 484, 261, 7, 40, "Reference",
  CellTags->"GDC91"],
Cell[14071, 493, 270, 8, 40, "Reference",
  CellTags->"GSB87"],
Cell[14344, 503, 223, 6, 40, "Reference",
  CellTags->"GVL96"],
Cell[14570, 511, 242, 7, 40, "Reference",
  CellTags->"H94"],
Cell[14815, 520, 218, 7, 40, "Reference",
  CellTags->"H97"],
Cell[15036, 529, 222, 7, 40, "Reference",
  CellTags->"H00"],
Cell[15261, 538, 289, 7, 40, "Reference",
  CellTags->"HL97"],
Cell[15553, 547, 223, 7, 40, "Reference",
  CellTags->"HL88a"],
Cell[15779, 556, 235, 5, 40, "Reference",
  CellTags->"HL88b"],
Cell[16017, 563, 216, 7, 40, "Reference",
  CellTags->"HO90"],
Cell[16236, 572, 277, 9, 40, "Reference",
  CellTags->"HW96"],
Cell[16516, 583, 234, 7, 40, "Reference",
  CellTags->"HW99"],
Cell[16753, 592, 308, 7, 40, "Reference",
  CellTags->"HLW02"],
Cell[17064, 601, 263, 6, 40, "Reference",
  CellTags->"HNW93"],
Cell[17330, 609, 190, 6, 24, "Reference",
  CellTags->"H97"],
Cell[17523, 617, 234, 5, 40, "Reference",
  CellTags->"H89"],
Cell[17760, 624, 196, 6, 24, "Reference",
  CellTags->"H96"],
Cell[17959, 632, 223, 5, 40, "Reference",
  CellTags->"H83"],
Cell[18185, 639, 370, 10, 56, "Reference",
  CellTags->"HT99"],
Cell[18558, 651, 283, 8, 40, "Reference",
  CellTags->"KL97"],
Cell[18844, 661, 151, 4, 24, "Reference",
  CellTags->"K65"],
Cell[18998, 667, 183, 6, 24, "Reference",
  CellTags->"K93"],
Cell[19184, 675, 207, 6, 24, "Reference",
  CellTags->"L87"],
Cell[19394, 683, 319, 8, 56, "Reference",
  CellTags->"LAPACK99"],
Cell[19716, 693, 204, 5, 40, "Reference",
  CellTags->"M68"],
Cell[19923, 700, 261, 7, 40, "Reference",
  CellTags->"MR99"],
Cell[20187, 709, 226, 7, 40, "Reference",
  CellTags->"M93"],
Cell[20416, 718, 270, 8, 40, "Reference",
  CellTags->"M95a"],
Cell[20689, 728, 213, 7, 24, "Reference",
  CellTags->"M95b"],
Cell[20905, 737, 215, 7, 24, "Reference",
  CellTags->"M01"],
Cell[21123, 746, 217, 7, 24, "Reference",
  CellTags->"MA92"],
Cell[21343, 755, 218, 9, 24, "Reference",
  CellTags->"MQ02"],
Cell[21564, 766, 241, 6, 40, "Reference",
  CellTags->"MG80"],
Cell[21808, 774, 206, 7, 24, "Reference",
  CellTags->"M65a"],
Cell[22017, 783, 187, 6, 24, "Reference",
  CellTags->"M65b"],
Cell[22207, 791, 225, 7, 40, "Reference",
  CellTags->"M97"],
Cell[22435, 800, 282, 8, 40, "Reference",
  CellTags->"MS99"],
Cell[22720, 810, 180, 6, 24, "Reference",
  CellTags->"M04"],
Cell[22903, 818, 215, 6, 40, "Reference",
  CellTags->"Na79"],
Cell[23121, 826, 229, 7, 40, "Reference",
  CellTags->"OS92"],
Cell[23353, 835, 222, 5, 40, "Reference",
  CellTags->"O95"],
Cell[23578, 842, 227, 5, 40, "Reference",
  CellTags->"O98"],
Cell[23808, 849, 236, 7, 40, "Reference",
  CellTags->"OS00"],
Cell[24047, 858, 281, 8, 40, "Reference",
  CellTags->"P83"],
Cell[24331, 868, 208, 6, 24, "Reference",
  CellTags->"QSS00"],
Cell[24542, 876, 228, 6, 40, "Reference",
  CellTags->"QV94"],
Cell[24773, 884, 235, 7, 40, "Reference",
  CellTags->"QT90"],
Cell[25011, 893, 200, 5, 40, "Reference",
  CellTags->"R93"],
Cell[25214, 900, 215, 7, 40, "Reference",
  CellTags->"R99"],
Cell[25432, 909, 455, 14, 40, "Reference",
  CellTags->"R98"],
Cell[25890, 925, 264, 7, 40, "Reference",
  CellTags->"RM57"],
Cell[26157, 934, 196, 5, 40, "Reference",
  CellTags->"R87"],
Cell[26356, 941, 307, 9, 40, "Reference",
  CellTags->"SC94"],
Cell[26666, 952, 198, 8, 24, "Reference",
  CellTags->"S91"],
Cell[26867, 962, 172, 5, 40, "Reference",
  CellTags->"S86"],
Cell[27042, 969, 222, 7, 40, "Reference",
  CellTags->"S87"],
Cell[27267, 978, 213, 6, 24, "Reference",
  CellTags->"S94"],
Cell[27483, 986, 221, 7, 40, "Reference",
  CellTags->"SB83"],
Cell[27707, 995, 227, 6, 40, "Reference",
  CellTags->"SG75"],
Cell[27937, 1003, 225, 6, 40, "Reference",
  CellTags->"SGT03"],
Cell[28165, 1011, 238, 7, 40, "Reference",
  CellTags->"SBB83"],
Cell[28406, 1020, 331, 6, 56, "Reference",
  CellTags->"SS02"],
Cell[28740, 1028, 222, 5, 40, "Reference",
  CellTags->"SS04a"],
Cell[28965, 1035, 342, 7, 56, "Reference",
  CellTags->"SS04b"],
Cell[29310, 1044, 215, 5, 40, "Reference",
  CellTags->"S84"],
Cell[29528, 1051, 204, 7, 24, "Reference",
  CellTags->"S68"],
Cell[29735, 1060, 229, 7, 40, "Reference",
  CellTags->"S70"],
Cell[29967, 1069, 276, 8, 40, "Reference",
  CellTags->"S90"],
Cell[30246, 1079, 154, 4, 24, "Reference",
  CellTags->"T59"],
Cell[30403, 1085, 242, 7, 40, "Reference",
  CellTags->"V78"],
Cell[30648, 1094, 183, 5, 40, "Reference",
  CellTags->"V79"],
Cell[30834, 1101, 187, 6, 24, "Reference",
  CellTags->"W76"],
Cell[31024, 1109, 209, 7, 24, "Reference",
  CellTags->"WH91"],
Cell[31236, 1118, 211, 7, 24, "Reference",
  CellTags->"Y90"],
Cell[31450, 1127, 156, 4, 24, "Reference",
  CellTags->"Z98"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

