(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3122172,      87876]*)
(*NotebookOutlinePosition[   3123343,      87920]*)
(*  CellTagsIndexPosition[   3123216,      87912]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Rigid body solvers", "Chapter"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell[TextData[{
  "The equations of motion for a free rigid body whose center of mass is at \
the origin are given by the following Euler equations (see [",
  ButtonBox["MR99",
    ButtonData:>{"References.nb", "MR99"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"(", GridBox[{
              {\(y\& . \_1\)},
              {\(y\& . \_2\)},
              {\(y\& . \_3\)}
              }], ")"}], " ", "=", " ", 
        RowBox[{
          RowBox[{"(", GridBox[{
                {"0", \(y\_3/I\_3\), \(\(-y\_2\)/I\_2\)},
                {\(\(-y\_3\)/I\_3\), "0", \(y\_1/I\_1\)},
                {\(y\_2/I\_2\), \(\(-y\_1\)/I\_1\), "0"}
                }], ")"}], 
          RowBox[{"(", GridBox[{
                {\(y\_1\)},
                {\(y\_2\)},
                {\(y\_3\)}
                }], ")"}], " "}]}], TraditionalForm]], "DisplayFormula"],

Cell["Two quadratic first integrals of the system are:", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {\(I(y)\), "=", \(y\_1\^2\  + \ y\_2\^2\  + \ y\_3\^2\)},
          {\(H(y)\), 
            "=", \(\(1\/2\) \((y\_1\^2\/I\_1\  + \ 
                  y\_2\^2\/I\_2\  + \(\(\ \)\(y\_3\^2\)\)\/I\_3)\)\)}
          }], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "The first constraint effectively confines the motion from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " to a sphere. The second constraint represents the kinetic energy of the \
system and, in conjunction with the first invariant, effectively confines the \
motion to ellipsoids on the sphere."
}], "Text"],

Cell[TextData[{
  "Numerical experiments for various methods are given in [",
  ButtonBox["HLW02",
    ButtonData:>{"References.nb", "HLW02"},
    ButtonStyle->"Hyperlink"],
  "] and a variety of ",
  StyleBox["NDSolve", "MR"],
  " methods will now be compared."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manifold generation and utility functions", "Section",
  CellTags->"s:2"],

Cell["Load some useful packages.", "Text"],

Cell[BoxData[{
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Needs["\<DifferentialEquations`NDSolveUtilities`\>"];\)\)}], "Input",
  CellLabel->"In[11]:=",
  InitializationCell->True],

Cell["\<\
Define Euler's equations for rigid body motion together with the \
invariants of the system.\
\>", "Text"],

Cell[BoxData[{
    \(\(system\  = \ 
        GetNDSolveProblem["\<RigidBody\>"];\)\), "\[IndentingNewLine]", 
    \(\(eqs\  = \ system["\<System\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(vars\  = \ 
        system["\<DependentVariables\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(time\  = \ system["\<TimeData\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(invariants\  = \ system["\<Invariants\>"[]];\)\)}], "Input",
  CellLabel->"In[13]:=",
  InitializationCell->True],

Cell["\<\
The equations of motion evolve as closed curves on the unit sphere. \
This generates a three-dimensional graphics object to represent the unit \
sphere.\
\>", "Text"],

Cell[BoxData[
    \(\(UnitSphere\  = \ 
        Graphics3D[{EdgeForm[], Sphere[1, 20, 20]}, Boxed \[Rule] False, \ 
          DisplayFunction \[Rule] Identity];\)\)], "Input",
  CellLabel->"In[18]:=",
  InitializationCell->True],

Cell[TextData[{
  "This function superimposes a solution from ",
  StyleBox["NDSolve", "MR"],
  " on a given manifold."
}], "Text"],

Cell[BoxData[
    \(PlotSolutionOnManifold[sol_, vars_, \ time_, manifold_, 
        opts___?OptionQ] := \[IndentingNewLine]Module[{solplot}, \
\[IndentingNewLine]solplot\  = \ 
          ParametricPlot3D[Evaluate[vars\  /. \ sol], time, 
            DisplayFunction \[Rule] Identity, opts, Boxed \[Rule] False, 
            Axes \[Rule] False, 
            PlotPoints \[Rule] 200]; \[IndentingNewLine]Show[solplot, \ 
          manifold, opts, \ 
          DisplayFunction \[Rule] $DisplayFunction]\[IndentingNewLine]]\)], \
"Input",
  CellLabel->"In[19]:=",
  InitializationCell->True],

Cell["This function plots the various solution components.", "Text"],

Cell[BoxData[
    \(\(PlotSolutionComponents[sols_, vars_, \ time_, 
          opts___?OptionQ] := \[IndentingNewLine]Module[{ifuns, \ 
            plotopts}, \[IndentingNewLine]ifuns\  = 
            vars\  /. \ First[sols]; \[IndentingNewLine]Table[
            plotopts\  = \ 
              Sequence[
                PlotLabel \[Rule] 
                  StringForm["\<`1` vs time\>", Part[vars, i]], 
                Frame \[Rule] True, 
                Axes \[Rule] False]; \[IndentingNewLine]Plot[
              Evaluate[Part[ifuns, \ i]], time, opts, 
              Evaluate[plotopts]], {i, \ 
              Length[vars]}]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[20]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method comparison", "Section",
  CellTags->"s:3"],

Cell["\<\
Various integration methods can be used to solve Euler's equations \
and they each have different associated costs and different dynamical \
properties.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Adams multistep method", "Subsection"],

Cell["\<\
Here an Adams method is used to solve the equations of \
motion.\
\>", "Text"],

Cell[BoxData[
    \(\(AdamsSolution\  = \ NDSolve[system, \ Method -> Adams];\)\)], "Input",\

  CellLabel->"In[21]:="],

Cell["\<\
This shows the solution trajectory by superimposing it on the unit \
sphere.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(PlotSolutionOnManifold[AdamsSolution, vars, \ time, \ 
        UnitSphere];\)\)], "Input",
  CellLabel->"In[22]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08024 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0545142 1.1616 -6.10948e-17 1.1616 [
[ 0 0 0 0 ]
[ 1 1.08024 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08024 L
0 1.08024 L
closepath
clip
newpath
.751 .603 .693 r
.49641 .58077 m .4173 .61167 L .42757 .56871 L F
.49641 .58077 m .49333 .62464 L .4173 .61167 L F
.747 .623 .722 r
.50014 .53692 m .49641 .58077 L .42757 .56871 L F
.703 .561 .691 r
.56749 .57971 m .49333 .62464 L .49641 .58077 L F
.703 .585 .72 r
.56234 .53597 m .49641 .58077 L .50014 .53692 L F
.56234 .53597 m .56749 .57971 L .49641 .58077 L F
.703 .561 .691 r
.56749 .57971 m .57174 .6235 L .49333 .62464 L F
.651 .522 .694 r
.63547 .56559 m .57174 .6235 L .56749 .57971 L F
.657 .551 .723 r
.62174 .5233 m .56749 .57971 L .56234 .53597 L F
.62174 .5233 m .63547 .56559 L .56749 .57971 L F
.747 .623 .722 r
.50014 .53692 m .42757 .56871 L .43997 .52609 L F
.74 .642 .75 r
.50445 .49376 m .50014 .53692 L .43997 .52609 L F
.703 .608 .748 r
.55639 .49295 m .50014 .53692 L .50445 .49376 L F
.55639 .49295 m .56234 .53597 L .50014 .53692 L F
.755 .582 .662 r
.49333 .62464 m .40935 .65429 L .4173 .61167 L F
.49333 .62464 m .49094 .66783 L .40935 .65429 L F
.701 .535 .66 r
.57174 .6235 m .49094 .66783 L .49333 .62464 L F
.662 .579 .751 r
.60587 .48212 m .56234 .53597 L .55639 .49295 L F
.60587 .48212 m .62174 .5233 L .56234 .53597 L F
.701 .535 .66 r
.57174 .6235 m .57504 .66664 L .49094 .66783 L F
.643 .492 .662 r
.64685 .60832 m .57504 .66664 L .57174 .6235 L F
.651 .522 .694 r
.63547 .56559 m .64685 .60832 L .57174 .6235 L F
.74 .642 .75 r
.50445 .49376 m .43997 .52609 L .45429 .48451 L F
.732 .66 .779 r
.5093 .45201 m .50445 .49376 L .45429 .48451 L F
.701 .632 .776 r
.5497 .45136 m .50445 .49376 L .5093 .45201 L F
.5497 .45136 m .55639 .49295 L .50445 .49376 L F
.667 .608 .78 r
.58811 .44275 m .55639 .49295 L .5497 .45136 L F
.58811 .44275 m .60587 .48212 L .55639 .49295 L F
.757 .558 .627 r
.49094 .66783 m .40387 .69585 L .40935 .65429 L F
.49094 .66783 m .4893 .70965 L .40387 .69585 L F
.698 .508 .627 r
.57504 .66664 m .4893 .70965 L .49094 .66783 L F
.57504 .66664 m .5773 .70844 L .4893 .70965 L F
.634 .459 .628 r
.65567 .65078 m .5773 .70844 L .57504 .66664 L F
.643 .492 .662 r
.64685 .60832 m .65567 .65078 L .57504 .66664 L F
.799 .653 .7 r
.42757 .56871 m .3494 .58525 L .36631 .54418 L F
.42757 .56871 m .4173 .61167 L .3494 .58525 L F
.788 .668 .731 r
.43997 .52609 m .42757 .56871 L .36631 .54418 L F
.43997 .52609 m .36631 .54418 L .38665 .50414 L F
.776 .682 .76 r
.45429 .48451 m .43997 .52609 L .38665 .50414 L F
.591 .485 .702 r
.69502 .53917 m .64685 .60832 L .63547 .56559 L F
.605 .521 .733 r
.67351 .49967 m .63547 .56559 L .62174 .5233 L F
.67351 .49967 m .69502 .53917 L .63547 .56559 L F
.618 .555 .762 r
.64876 .462 m .62174 .5233 L .60587 .48212 L F
.64876 .462 m .67351 .49967 L .62174 .5233 L F
.808 .635 .667 r
.4173 .61167 m .33626 .62664 L .3494 .58525 L F
.4173 .61167 m .40935 .65429 L .33626 .62664 L F
.776 .682 .76 r
.45429 .48451 m .38665 .50414 L .41008 .4658 L F
.761 .694 .788 r
.47034 .44465 m .45429 .48451 L .41008 .4658 L F
.732 .66 .779 r
.5093 .45201 m .45429 .48451 L .47034 .44465 L F
.575 .447 .668 r
.71292 .57984 m .65567 .65078 L .64685 .60832 L F
.591 .485 .702 r
.69502 .53917 m .71292 .57984 L .64685 .60832 L F
.63 .59 .79 r
.62119 .42681 m .60587 .48212 L .58811 .44275 L F
.62119 .42681 m .64876 .462 L .60587 .48212 L F
.721 .679 .808 r
.51461 .41237 m .5093 .45201 L .47034 .44465 L F
.697 .656 .806 r
.54238 .41192 m .5093 .45201 L .51461 .41237 L F
.54238 .41192 m .5497 .45136 L .5093 .45201 L F
.671 .638 .809 r
.56873 .40588 m .5497 .45136 L .54238 .41192 L F
.56873 .40588 m .58811 .44275 L .5497 .45136 L F
.757 .53 .588 r
.4893 .70965 m .40102 .73562 L .40387 .69585 L F
.4893 .70965 m .48845 .74938 L .40102 .73562 L F
.693 .476 .589 r
.5773 .70844 m .48845 .74938 L .4893 .70965 L F
.5773 .70844 m .57848 .74817 L .48845 .74938 L F
.623 .421 .588 r
.66175 .69228 m .57848 .74817 L .5773 .70844 L F
.634 .459 .628 r
.65567 .65078 m .66175 .69228 L .5773 .70844 L F
.816 .614 .629 r
.40935 .65429 m .3272 .66764 L .33626 .62664 L F
.40935 .65429 m .40387 .69585 L .3272 .66764 L F
.557 .404 .63 r
.72683 .62098 m .66175 .69228 L .65567 .65078 L F
.575 .447 .668 r
.71292 .57984 m .72683 .62098 L .65567 .65078 L F
.761 .694 .788 r
.47034 .44465 m .41008 .4658 L .43619 .42982 L F
.743 .705 .816 r
.48787 .40721 m .47034 .44465 L .43619 .42982 L F
.721 .679 .808 r
.51461 .41237 m .47034 .44465 L .48787 .40721 L F
.643 .626 .818 r
.59126 .39474 m .58811 .44275 L .56873 .40588 L F
.59126 .39474 m .62119 .42681 L .58811 .44275 L F
.83 .723 .747 r
.38665 .50414 m .31789 .50862 L .34487 .47246 L F
.38665 .50414 m .36631 .54418 L .31789 .50862 L F
.809 .73 .777 r
.41008 .4658 m .38665 .50414 L .34487 .47246 L F
.41008 .4658 m .34487 .47246 L .37576 .43893 L F
.787 .734 .804 r
.43619 .42982 m .41008 .4658 L .37576 .43893 L F
.848 .714 .714 r
.36631 .54418 m .29535 .54679 L .31789 .50862 L F
.36631 .54418 m .3494 .58525 L .29535 .54679 L F
.822 .589 .585 r
.40387 .69585 m .32248 .70748 L .3272 .66764 L F
.40387 .69585 m .40102 .73562 L .32248 .70748 L F
.542 .493 .751 r
.71303 .46661 m .69502 .53917 L .67351 .49967 L F
.566 .536 .78 r
.68114 .43399 m .67351 .49967 L .64876 .462 L F
.68114 .43399 m .71303 .46661 L .67351 .49967 L F
.707 .698 .839 r
.5203 .37559 m .51461 .41237 L .48787 .40721 L F
.691 .683 .838 r
.53454 .37535 m .51461 .41237 L .5203 .37559 L F
.53454 .37535 m .54238 .41192 L .51461 .41237 L F
.673 .671 .84 r
.54801 .3722 m .54238 .41192 L .53454 .37535 L F
.54801 .3722 m .56873 .40588 L .54238 .41192 L F
.59 .577 .807 r
.64586 .40476 m .64876 .462 L .62119 .42681 L F
.64586 .40476 m .68114 .43399 L .64876 .462 L F
.755 .496 .541 r
.48845 .74938 m .40094 .77284 L .40102 .73562 L F
.48845 .74938 m .48842 .78627 L .40094 .77284 L F
.686 .439 .543 r
.57848 .74817 m .48842 .78627 L .48845 .74938 L F
.515 .446 .717 r
.74091 .50204 m .71292 .57984 L .69502 .53917 L F
.542 .493 .751 r
.71303 .46661 m .74091 .50204 L .69502 .53917 L F
.686 .439 .543 r
.57848 .74817 m .57851 .78509 L .48842 .78627 L F
.608 .376 .54 r
.6649 .73206 m .57851 .78509 L .57848 .74817 L F
.623 .421 .588 r
.66175 .69228 m .6649 .73206 L .57848 .74817 L F
.535 .356 .584 r
.73643 .66185 m .6649 .73206 L .66175 .69228 L F
.557 .404 .63 r
.72683 .62098 m .73643 .66185 L .66175 .69228 L F
.787 .734 .804 r
.43619 .42982 m .37576 .43893 L .40998 .40864 L F
.761 .736 .83 r
.46458 .39684 m .43619 .42982 L .40998 .40864 L F
.743 .705 .816 r
.48787 .40721 m .43619 .42982 L .46458 .39684 L F
.865 .701 .677 r
.3494 .58525 m .27777 .58629 L .29535 .54679 L F
.3494 .58525 m .33626 .62664 L .27777 .58629 L F
.72 .716 .845 r
.50661 .37289 m .48787 .40721 L .46458 .39684 L F
.707 .698 .839 r
.5203 .37559 m .48787 .40721 L .50661 .37289 L F
.655 .664 .846 r
.55944 .36641 m .56873 .40588 L .54801 .3722 L F
.55944 .36641 m .59126 .39474 L .56873 .40588 L F
.613 .619 .833 r
.60784 .37944 m .62119 .42681 L .59126 .39474 L F
.60784 .37944 m .64586 .40476 L .62119 .42681 L F
.485 .395 .679 r
.76422 .53965 m .72683 .62098 L .71292 .57984 L F
.515 .446 .717 r
.74091 .50204 m .76422 .53965 L .71292 .57984 L F
.761 .736 .83 r
.46458 .39684 m .40998 .40864 L .44691 .38212 L F
.73 .735 .855 r
.49477 .3675 m .46458 .39684 L .44691 .38212 L F
.72 .716 .845 r
.50661 .37289 m .46458 .39684 L .49477 .3675 L F
.88 .683 .632 r
.33626 .62664 m .26561 .62638 L .27777 .58629 L F
.33626 .62664 m .3272 .66764 L .26561 .62638 L F
.636 .661 .857 r
.56774 .35851 m .59126 .39474 L .55944 .36641 L F
.56774 .35851 m .60784 .37944 L .59126 .39474 L F
.825 .556 .531 r
.40102 .73562 m .32235 .74538 L .32248 .70748 L F
.40102 .73562 m .40094 .77284 L .32235 .74538 L F
.45 .336 .632 r
.78241 .57878 m .73643 .66185 L .72683 .62098 L F
.485 .395 .679 r
.76422 .53965 m .78241 .57878 L .72683 .62098 L F
.608 .376 .54 r
.6649 .73206 m .66499 .76936 L .57851 .78509 L F
.508 .297 .528 r
.74142 .70171 m .66499 .76936 L .6649 .73206 L F
.535 .356 .584 r
.73643 .66185 m .74142 .70171 L .6649 .73206 L F
.672 .728 .892 r
.56729 .33016 m .5203 .37559 L .50661 .37289 L F
.56729 .33016 m .53454 .37535 L .5203 .37559 L F
.56729 .33016 m .54801 .3722 L .53454 .37535 L F
.838 .788 .803 r
.37576 .43893 m .31891 .4333 L .35486 .40595 L F
.37576 .43893 m .34487 .47246 L .31891 .4333 L F
.807 .78 .828 r
.40998 .40864 m .37576 .43893 L .35486 .40595 L F
.40998 .40864 m .35486 .40595 L .39438 .38283 L F
.773 .77 .85 r
.44691 .38212 m .40998 .40864 L .39438 .38283 L F
.672 .728 .892 r
.56729 .33016 m .50661 .37289 L .49477 .3675 L F
.749 .452 .481 r
.48842 .78627 m .40374 .80672 L .40094 .77284 L F
.48842 .78627 m .48926 .81954 L .40374 .80672 L F
.674 .391 .486 r
.57851 .78509 m .48926 .81954 L .48842 .78627 L F
.672 .728 .892 r
.56729 .33016 m .55944 .36641 L .54801 .3722 L F
.674 .391 .486 r
.57851 .78509 m .57735 .81842 L .48926 .81954 L F
.587 .32 .479 r
.66499 .76936 m .57735 .81842 L .57851 .78509 L F
.869 .792 .773 r
.34487 .47246 m .28728 .46441 L .31891 .4333 L F
.34487 .47246 m .31789 .50862 L .28728 .46441 L F
.544 .572 .833 r
.65956 .37841 m .68114 .43399 L .64586 .40476 L F
.582 .619 .854 r
.61677 .3613 m .64586 .40476 L .60784 .37944 L F
.61677 .3613 m .65956 .37841 L .64586 .40476 L F
.504 .522 .808 r
.69961 .40027 m .71303 .46661 L .68114 .43399 L F
.544 .572 .833 r
.65956 .37841 m .69961 .40027 L .68114 .43399 L F
.773 .77 .85 r
.44691 .38212 m .39438 .38283 L .43667 .36434 L F
.736 .756 .869 r
.48591 .35989 m .44691 .38212 L .43667 .36434 L F
.73 .735 .855 r
.49477 .3675 m .44691 .38212 L .48591 .35989 L F
.672 .728 .892 r
.56729 .33016 m .49477 .3675 L .48591 .35989 L F
.56729 .33016 m .56774 .35851 L .55944 .36641 L F
.893 .659 .577 r
.3272 .66764 m .25927 .66629 L .26561 .62638 L F
.3272 .66764 m .32248 .70748 L .25927 .66629 L F
.619 .663 .871 r
.57206 .34924 m .60784 .37944 L .56774 .35851 L F
.57206 .34924 m .61677 .3613 L .60784 .37944 L F
.459 .466 .778 r
.7361 .42652 m .74091 .50204 L .71303 .46661 L F
.504 .522 .808 r
.69961 .40027 m .7361 .42652 L .71303 .46661 L F
.898 .792 .736 r
.31789 .50862 m .2607 .49874 L .28728 .46441 L F
.31789 .50862 m .29535 .54679 L .2607 .49874 L F
.672 .728 .892 r
.56729 .33016 m .48591 .35989 L .48091 .35078 L F
.736 .756 .869 r
.48591 .35989 m .43667 .36434 L .48091 .35078 L F
.408 .266 .574 r
.79501 .6187 m .74142 .70171 L .73643 .66185 L F
.45 .336 .632 r
.78241 .57878 m .79501 .6187 L .73643 .66185 L F
.672 .728 .892 r
.56729 .33016 m .57206 .34924 L .56774 .35851 L F
.409 .401 .74 r
.76825 .45673 m .76422 .53965 L .74091 .50204 L F
.459 .466 .778 r
.7361 .42652 m .76825 .45673 L .74091 .50204 L F
.824 .511 .46 r
.40094 .77284 m .32698 .78049 L .32235 .74538 L F
.40094 .77284 m .40374 .80672 L .32698 .78049 L F
.925 .787 .689 r
.29535 .54679 m .23987 .53567 L .2607 .49874 L F
.29535 .54679 m .27777 .58629 L .23987 .53567 L F
.587 .32 .479 r
.66499 .76936 m .66189 .80339 L .57735 .81842 L F
.471 .222 .455 r
.74157 .73974 m .66189 .80339 L .66499 .76936 L F
.508 .297 .528 r
.74142 .70171 m .74157 .73974 L .66499 .76936 L F
.776 .805 .876 r
.43667 .36434 m .39132 .35467 L .43503 .34511 L F
.43667 .36434 m .39438 .38283 L .39132 .35467 L F
.736 .776 .885 r
.48091 .35078 m .43667 .36434 L .43503 .34511 L F
.672 .728 .892 r
.56729 .33016 m .48091 .35078 L .48032 .34103 L F
.736 .776 .885 r
.48091 .35078 m .43503 .34511 L .48032 .34103 L F
.672 .728 .892 r
.56729 .33016 m .57193 .33947 L .57206 .34924 L F
.603 .672 .888 r
.57193 .33947 m .61677 .3613 L .57206 .34924 L F
.552 .628 .881 r
.61696 .34201 m .65956 .37841 L .61677 .3613 L F
.603 .672 .888 r
.57193 .33947 m .61696 .34201 L .61677 .3613 L F
.816 .832 .861 r
.39438 .38283 m .35008 .36964 L .39132 .35467 L F
.39438 .38283 m .35486 .40595 L .35008 .36964 L F
.902 .624 .506 r
.32248 .70748 m .25909 .70517 L .25927 .66629 L F
.32248 .70748 m .32235 .74538 L .25909 .70517 L F
.349 .326 .691 r
.79528 .49037 m .78241 .57878 L .76422 .53965 L F
.409 .401 .74 r
.76825 .45673 m .79528 .49037 L .76422 .53965 L F
.736 .393 .4 r
.48926 .81954 m .40949 .83642 L .40374 .80672 L F
.48926 .81954 m .49098 .8484 L .40949 .83642 L F
.654 .328 .409 r
.57735 .81842 m .49098 .8484 L .48926 .81954 L F
.493 .576 .867 r
.6605 .35012 m .69961 .40027 L .65956 .37841 L F
.552 .628 .881 r
.61696 .34201 m .6605 .35012 L .65956 .37841 L F
.654 .328 .409 r
.57735 .81842 m .57498 .84735 L .49098 .8484 L F
.556 .245 .396 r
.66189 .80339 m .57498 .84735 L .57735 .81842 L F
.672 .728 .892 r
.56729 .33016 m .48032 .34103 L .48424 .33158 L F
.727 .793 .904 r
.48032 .34103 m .44241 .3263 L .48424 .33158 L F
.48032 .34103 m .43503 .34511 L .44241 .3263 L F
.857 .856 .839 r
.35486 .40595 m .31224 .38985 L .35008 .36964 L F
.35486 .40595 m .31891 .4333 L .31224 .38985 L F
.592 .686 .907 r
.56729 .33016 m .61696 .34201 L .57193 .33947 L F
.354 .178 .499 r
.80158 .65861 m .74157 .73974 L .74142 .70171 L F
.408 .266 .574 r
.79501 .6187 m .80158 .65861 L .74142 .70171 L F
.95 .774 .629 r
.27777 .58629 m .2254 .57449 L .23987 .53567 L F
.27777 .58629 m .26561 .62638 L .2254 .57449 L F
.425 .514 .846 r
.70164 .36374 m .7361 .42652 L .69961 .40027 L F
.493 .576 .867 r
.6605 .35012 m .70164 .36374 L .69961 .40027 L F
.766 .837 .906 r
.43503 .34511 m .40165 .32686 L .44241 .3263 L F
.43503 .34511 m .39132 .35467 L .40165 .32686 L F
.672 .728 .892 r
.56729 .33016 m .48424 .33158 L .49237 .32338 L F
.711 .803 .922 r
.48424 .33158 m .45834 .30984 L .49237 .32338 L F
.48424 .33158 m .44241 .3263 L .45834 .30984 L F
.672 .728 .892 r
.56729 .33016 m .54655 .31655 L .55855 .32225 L F
.56729 .33016 m .53247 .31368 L .54655 .31655 L F
.56729 .33016 m .51776 .31394 L .53247 .31368 L F
.56729 .33016 m .50392 .31729 L .51776 .31394 L F
.56729 .33016 m .49237 .32338 L .50392 .31729 L F
.588 .706 .925 r
.55855 .32225 m .60815 .32345 L .56729 .33016 L F
.592 .686 .907 r
.56729 .33016 m .60815 .32345 L .61696 .34201 L F
.897 .877 .808 r
.31891 .4333 m .27869 .41501 L .31224 .38985 L F
.31891 .4333 m .28728 .46441 L .27869 .41501 L F
.524 .647 .911 r
.60815 .32345 m .6605 .35012 L .61696 .34201 L F
.277 .233 .627 r
.81649 .52683 m .79501 .6187 L .78241 .57878 L F
.349 .326 .691 r
.79528 .49037 m .81649 .52683 L .78241 .57878 L F
.813 .447 .364 r
.40374 .80672 m .3365 .81197 L .32698 .78049 L F
.40374 .80672 m .40949 .83642 L .3365 .81197 L F
.687 .805 .938 r
.49237 .32338 m .48134 .2975 L .50392 .31729 L F
.49237 .32338 m .45834 .30984 L .48134 .2975 L F
.343 .438 .814 r
.73944 .38274 m .76825 .45673 L .7361 .42652 L F
.425 .514 .846 r
.70164 .36374 m .73944 .38274 L .7361 .42652 L F
.588 .706 .925 r
.55855 .32225 m .59097 .30754 L .60815 .32345 L F
.592 .731 .941 r
.54655 .31655 m .59097 .30754 L .55855 .32225 L F
.556 .245 .396 r
.66189 .80339 m .65551 .83332 L .57498 .84735 L F
.418 .123 .354 r
.73666 .77511 m .65551 .83332 L .66189 .80339 L F
.471 .222 .455 r
.74157 .73974 m .73666 .77511 L .66189 .80339 L F
.903 .572 .41 r
.32235 .74538 m .26532 .74214 L .25909 .70517 L F
.32235 .74538 m .32698 .78049 L .26532 .74214 L F
.806 .882 .901 r
.39132 .35467 m .36284 .33346 L .40165 .32686 L F
.39132 .35467 m .35008 .36964 L .36284 .33346 L F
.658 .798 .949 r
.50392 .31729 m .50912 .29068 L .51776 .31394 L F
.50392 .31729 m .48134 .2975 L .50912 .29068 L F
.97 .749 .548 r
.26561 .62638 m .21784 .6144 L .2254 .57449 L F
.26561 .62638 m .25927 .66629 L .21784 .6144 L F
.592 .731 .941 r
.54655 .31655 m .56702 .29601 L .59097 .30754 L F
.606 .757 .951 r
.53247 .31368 m .56702 .29601 L .54655 .31655 L F
.936 .892 .762 r
.28728 .46441 m .25031 .44474 L .27869 .41501 L F
.28728 .46441 m .2607 .49874 L .25031 .44474 L F
.438 .593 .908 r
.64803 .32263 m .70164 .36374 L .6605 .35012 L F
.524 .647 .911 r
.60815 .32345 m .64803 .32263 L .6605 .35012 L F
.629 .78 .954 r
.51776 .31394 m .53874 .29017 L .53247 .31368 L F
.51776 .31394 m .50912 .29068 L .53874 .29017 L F
.606 .757 .951 r
.53247 .31368 m .53874 .29017 L .56702 .29601 L F
.282 .065 .396 r
.80176 .69767 m .73666 .77511 L .74157 .73974 L F
.354 .178 .499 r
.80158 .65861 m .80176 .69767 L .74157 .73974 L F
.737 .86 .938 r
.44241 .3263 m .42489 .30231 L .45834 .30984 L F
.44241 .3263 m .40165 .32686 L .42489 .30231 L F
.707 .306 .284 r
.49098 .8484 m .41824 .86113 L .40949 .83642 L F
.49098 .8484 m .49361 .87202 L .41824 .86113 L F
.619 .239 .3 r
.57498 .84735 m .49361 .87202 L .49098 .8484 L F
.504 .677 .943 r
.59097 .30754 m .64803 .32263 L .60815 .32345 L F
.619 .239 .3 r
.57498 .84735 m .57136 .87106 L .49361 .87202 L F
.507 .14 .278 r
.65551 .83332 m .57136 .87106 L .57498 .84735 L F
.185 .115 .539 r
.83123 .56541 m .80158 .65861 L .79501 .6187 L F
.277 .233 .627 r
.81649 .52683 m .83123 .56541 L .79501 .6187 L F
.241 .34 .765 r
.773 .4069 m .79528 .49037 L .76825 .45673 L F
.343 .438 .814 r
.73944 .38274 m .773 .4069 L .76825 .45673 L F
.846 .927 .883 r
.35008 .36964 m .32691 .34619 L .36284 .33346 L F
.35008 .36964 m .31224 .38985 L .32691 .34619 L F
.97 .897 .693 r
.2607 .49874 m .22793 .47852 L .25031 .44474 L F
.2607 .49874 m .23987 .53567 L .22793 .47852 L F
.324 .516 .89 r
.68605 .32793 m .73944 .38274 L .70164 .36374 L F
.438 .593 .908 r
.64803 .32263 m .68605 .32793 L .70164 .36374 L F
.689 .866 .966 r
.45834 .30984 m .45901 .28377 L .48134 .2975 L F
.45834 .30984 m .42489 .30231 L .45901 .28377 L F
.978 .703 .435 r
.25927 .66629 m .21762 .65452 L .21784 .6144 L F
.25927 .66629 m .25909 .70517 L .21762 .65452 L F
.504 .677 .943 r
.59097 .30754 m .62287 .29886 L .64803 .32263 L F
.501 .719 .969 r
.56702 .29601 m .62287 .29886 L .59097 .30754 L F
.782 .35 .222 r
.40949 .83642 m .35094 .83893 L .3365 .81197 L F
.40949 .83642 m .41824 .86113 L .35094 .83893 L F
.886 .491 .273 r
.32698 .78049 m .27809 .77627 L .26532 .74214 L F
.32698 .78049 m .3365 .81197 L .27809 .77627 L F
.761 .92 .942 r
.40165 .32686 m .39278 .30124 L .42489 .30231 L F
.40165 .32686 m .36284 .33346 L .39278 .30124 L F
.507 .14 .278 r
.65551 .83332 m .64582 .85831 L .57136 .87106 L F
.337 0 .206 r
.72657 .80696 m .64582 .85831 L .65551 .83332 L F
.418 .123 .354 r
.73666 .77511 m .72657 .80696 L .65551 .83332 L F
.111 .212 .69 r
.80142 .43584 m .81649 .52683 L .79528 .49037 L F
.241 .34 .765 r
.773 .4069 m .80142 .43584 L .79528 .49037 L F
.384 .625 .948 r
.62287 .29886 m .68605 .32793 L .64803 .32263 L F
.064 0 .414 r
.83893 .60531 m .80176 .69767 L .80158 .65861 L F
.185 .115 .539 r
.83123 .56541 m .83893 .60531 L .80158 .65861 L F
.18 0 .248 r
.79531 .73499 m .72657 .80696 L .73666 .77511 L F
.282 .065 .396 r
.80176 .69767 m .79531 .73499 L .73666 .77511 L F
.626 .849 .985 r
.48134 .2975 m .50055 .27347 L .50912 .29068 L F
.48134 .2975 m .45901 .28377 L .50055 .27347 L F
.882 .966 .843 r
.31224 .38985 m .29481 .365 L .32691 .34619 L F
.31224 .38985 m .27869 .41501 L .29481 .365 L F
.501 .719 .969 r
.56702 .29601 m .58729 .28152 L .62287 .29886 L F
.52 .766 .986 r
.53874 .29017 m .58729 .28152 L .56702 .29601 L F
.992 .881 .589 r
.23987 .53567 m .21233 .51572 L .22793 .47852 L F
.23987 .53567 m .2254 .57449 L .21233 .51572 L F
.565 .813 .992 r
.50912 .29068 m .54497 .27269 L .53874 .29017 L F
.50912 .29068 m .50055 .27347 L .54497 .27269 L F
.52 .766 .986 r
.53874 .29017 m .54497 .27269 L .58729 .28152 L F
.168 .404 .846 r
.72129 .33948 m .773 .4069 L .73944 .38274 L F
.324 .516 .89 r
.68605 .32793 m .72129 .33948 L .73944 .38274 L F
.645 .168 .105 r
.49361 .87202 m .42995 .87999 L .41824 .86113 L F
.49361 .87202 m .49712 .88958 L .42995 .87999 L F
.553 .1 .131 r
.57136 .87106 m .49712 .88958 L .49361 .87202 L F
.57136 .87106 m .5665 .88874 L .49712 .88958 L F
.419 0 .095 r
.64582 .85831 m .5665 .88874 L .57136 .87106 L F
.959 .62 .273 r
.25909 .70517 m .22505 .69389 L .21762 .65452 L F
.25909 .70517 m .26532 .74214 L .22505 .69389 L F
0 .04 .572 r
.82384 .46908 m .83123 .56541 L .81649 .52683 L F
.111 .212 .69 r
.80142 .43584 m .82384 .46908 L .81649 .52683 L F
.67 .924 .973 r
.42489 .30231 m .43744 .27675 L .45901 .28377 L F
.42489 .30231 m .39278 .30124 L .43744 .27675 L F
.77 .974 .919 r
.36284 .33346 m .36283 .307 L .39278 .30124 L F
.36284 .33346 m .32691 .34619 L .36283 .307 L F
.902 .986 .762 r
.27869 .41501 m .26746 .38973 L .29481 .365 L F
.27869 .41501 m .25031 .44474 L .26746 .38973 L F
.384 .625 .948 r
.62287 .29886 m .65352 .2967 L .68605 .32793 L F
.348 .674 .977 r
.58729 .28152 m .65352 .2967 L .62287 .29886 L F
.828 .356 .07 r
.3365 .81197 m .2974 .80663 L .27809 .77627 L F
.3365 .81197 m .35094 .83893 L .2974 .80663 L F
.201 .528 .921 r
.65352 .2967 m .72129 .33948 L .68605 .32793 L F
0 0 .233 r
.83915 .64565 m .79531 .73499 L .80176 .69767 L F
.064 0 .414 r
.83893 .60531 m .83915 .64565 L .80176 .69767 L F
.704 .19 .004 r
.41824 .86113 m .37022 .8605 L .35094 .83893 L F
.41824 .86113 m .42995 .87999 L .37022 .8605 L F
.983 .826 .431 r
.2254 .57449 m .20416 .55554 L .21233 .51572 L F
.2254 .57449 m .21784 .6144 L .20416 .55554 L F
0 .238 .753 r
.75282 .35729 m .80142 .43584 L .773 .4069 L F
.168 .404 .846 r
.72129 .33948 m .75282 .35729 L .773 .4069 L F
.337 0 .206 r
.72657 .80696 m .71129 .83438 L .64582 .85831 L F
.031 0 .031 r
.78208 .76963 m .71129 .83438 L .72657 .80696 L F
.18 0 .248 r
.79531 .73499 m .78208 .76963 L .72657 .80696 L F
.419 0 .095 r
.64582 .85831 m .63283 .87751 L .5665 .88874 L F
.203 0 0 r
.71129 .83438 m .63283 .87751 L .64582 .85831 L F
.545 .884 .987 r
.45901 .28377 m .49224 .26308 L .50055 .27347 L F
.45901 .28377 m .43744 .27675 L .49224 .26308 L F
0 0 .391 r
.83949 .50599 m .83893 .60531 L .83123 .56541 L F
0 .04 .572 r
.82384 .46908 m .83949 .50599 L .83123 .56541 L F
.348 .674 .977 r
.58729 .28152 m .60688 .27377 L .65352 .2967 L F
.357 .738 .987 r
.54497 .27269 m .60688 .27377 L .58729 .28152 L F
.883 .474 .041 r
.26532 .74214 m .24025 .7315 L .22505 .69389 L F
.26532 .74214 m .27809 .77627 L .24025 .7315 L F
.879 .956 .611 r
.25031 .44474 m .24579 .42003 L .26746 .38973 L F
.25031 .44474 m .22793 .47852 L .24579 .42003 L F
.739 .992 .829 r
.32691 .34619 m .33588 .31981 L .36283 .307 L F
.32691 .34619 m .29481 .365 L .33588 .31981 L F
.427 .813 .989 r
.50055 .27347 m .551 .26204 L .54497 .27269 L F
.50055 .27347 m .49224 .26308 L .551 .26204 L F
.357 .738 .987 r
.54497 .27269 m .551 .26204 L .60688 .27377 L F
.594 .945 .913 r
.39278 .30124 m .4172 .27702 L .43744 .27675 L F
.39278 .30124 m .36283 .307 L .4172 .27702 L F
0 0 0 r
.83158 .68545 m .78208 .76963 L .79531 .73499 L F
0 0 .233 r
.83915 .64565 m .83158 .68545 L .79531 .73499 L F
.504 0 0 r
.49712 .88958 m .44454 .89222 L .42995 .87999 L F
.49712 .88958 m .50151 .90029 L .44454 .89222 L F
.414 0 0 r
.5665 .88874 m .50151 .90029 L .49712 .88958 L F
0 .352 .817 r
.68215 .30146 m .75282 .35729 L .72129 .33948 L F
.201 .528 .921 r
.65352 .2967 m .68215 .30146 L .72129 .33948 L F
.911 .702 .202 r
.21784 .6144 m .20393 .59707 L .20416 .55554 L F
.21784 .6144 m .21762 .65452 L .20393 .59707 L F
.414 0 0 r
.5665 .88874 m .56044 .89958 L .50151 .90029 L F
.253 0 0 r
.63283 .87751 m .56044 .89958 L .5665 .88874 L F
0 0 .576 r
.7797 .38121 m .82384 .46908 L .80142 .43584 L F
0 .238 .753 r
.75282 .35729 m .7797 .38121 L .80142 .43584 L F
.09 .55 .907 r
.60688 .27377 m .68215 .30146 L .65352 .2967 L F
.682 .138 0 r
.35094 .83893 m .32308 .83227 L .2974 .80663 L F
.35094 .83893 m .37022 .8605 L .32308 .83227 L F
0 0 .136 r
.84769 .54579 m .83915 .64565 L .83893 .60531 L F
0 0 .391 r
.83949 .50599 m .84769 .54579 L .83893 .60531 L F
.203 0 0 r
.71129 .83438 m .69089 .85652 L .63283 .87751 L F
0 0 0 r
.76209 .80063 m .69089 .85652 L .71129 .83438 L F
.031 0 .031 r
.78208 .76963 m .76209 .80063 L .71129 .83438 L F
.52 0 0 r
.42995 .87999 m .39413 .87586 L .37022 .8605 L F
.42995 .87999 m .44454 .89222 L .39413 .87586 L F
.253 0 0 r
.63283 .87751 m .61668 .89013 L .56044 .89958 L F
0 0 0 r
.69089 .85652 m .61668 .89013 L .63283 .87751 L F
.774 .832 .366 r
.22793 .47852 m .23061 .45536 L .24579 .42003 L F
.22793 .47852 m .21233 .51572 L .23061 .45536 L F
.707 .245 0 r
.27809 .77627 m .26313 .76629 L .24025 .7315 L F
.27809 .77627 m .2974 .80663 L .26313 .76629 L F
.619 .907 .619 r
.29481 .365 m .31278 .33972 L .33588 .31981 L F
.29481 .365 m .26746 .38973 L .31278 .33972 L F
.352 .827 .865 r
.43744 .27675 m .48442 .26021 L .49224 .26308 L F
.43744 .27675 m .4172 .27702 L .48442 .26021 L F
.744 .491 0 r
.21762 .65452 m .21196 .63926 L .20393 .59707 L F
.21762 .65452 m .22505 .69389 L .21196 .63926 L F
.09 .55 .907 r
.60688 .27377 m .62528 .27335 L .68215 .30146 L F
.06 .596 .857 r
.551 .26204 m .62528 .27335 L .60688 .27377 L F
0 0 .302 r
.80103 .41094 m .83949 .50599 L .82384 .46908 L F
0 0 .576 r
.7797 .38121 m .80103 .41094 L .82384 .46908 L F
0 0 0 r
.8161 .72368 m .76209 .80063 L .78208 .76963 L F
.83158 .68545 m .8161 .72368 L .78208 .76963 L F
0 .077 .575 r
.70794 .31339 m .7797 .38121 L .75282 .35729 L F
0 .352 .817 r
.68215 .30146 m .70794 .31339 L .75282 .35729 L F
.403 .836 .696 r
.36283 .307 m .39889 .28503 L .4172 .27702 L F
.36283 .307 m .33588 .31981 L .39889 .28503 L F
0 g
.5 Mabswid
[ ] 0 setdash
.54514 .90004 m
.54764 .89974 L
s
.53824 .90069 m
.54738 .89974 L
s
0 0 .136 r
.84769 .54579 m .84792 .58754 L .83915 .64565 L F
.737 .702 .165 r
.84792 .58754 m .83158 .68545 L .83915 .64565 L F
.151 .689 .832 r
.49224 .26308 m .55668 .25893 L .551 .26204 L F
.49224 .26308 m .48442 .26021 L .55668 .25893 L F
0 g
.53436 .901 m
.54779 .89973 L
s
.06 .596 .857 r
.551 .26204 m .55668 .25893 L .62528 .27335 L F
0 .292 .666 r
.62528 .27335 m .70794 .31339 L .68215 .30146 L F
0 g
.63094 .88367 m
.63452 .88272 L
s
.63096 .88366 m
.63733 .88192 L
s
.402 0 0 r
.37022 .8605 m .35476 .85229 L .32308 .83227 L F
.37022 .8605 m .39413 .87586 L .35476 .85229 L F
0 g
.63087 .88371 m
.6311 .88364 L
s
.213 0 0 r
.50151 .90029 m .46181 .89708 L .44454 .89222 L F
.50151 .90029 m .50672 .90343 L .46181 .89708 L F
.138 0 0 r
.56044 .89958 m .50672 .90343 L .50151 .90029 L F
.56044 .89958 m .55326 .90287 L .50672 .90343 L F
0 0 0 r
.61668 .89013 m .55326 .90287 L .56044 .89958 L F
.21233 .51572 m .22264 .49498 L .23061 .45536 L F
.21233 .51572 m .20416 .55554 L .22264 .49498 L F
.69089 .85652 m .6656 .87253 L .61668 .89013 L F
.76209 .80063 m .73554 .82704 L .69089 .85652 L F
.405 .815 .613 r
.73554 .82704 m .6656 .87253 L .69089 .85652 L F
0 .043 .566 r
.2974 .80663 m .29338 .7972 L .26313 .76629 L F
.2974 .80663 m .32308 .83227 L .29338 .7972 L F
0 g
.49301 .90152 m
.49324 .90152 L
s
0 0 0 r
.26746 .38973 m .29438 .36659 L .31278 .33972 L F
.26746 .38973 m .24579 .42003 L .29438 .36659 L F
0 0 .383 r
.22505 .69389 m .22834 .68096 L .21196 .63926 L F
.22505 .69389 m .24025 .7315 L .22834 .68096 L F
0 g
.48896 .90125 m
.49238 .9014 L
s
0 .399 .703 r
.44454 .89222 m .42233 .88426 L .39413 .87586 L F
.44454 .89222 m .46181 .89708 L .42233 .88426 L F
0 0 .302 r
.80103 .41094 m .81598 .44596 L .83949 .50599 L F
.851 .548 .016 r
.81598 .44596 m .84769 .54579 L .83949 .50599 L F
0 g
.48492 .90091 m
.49192 .90134 L
s
0 0 0 r
.61668 .89013 m .59755 .89544 L .55326 .90287 L F
.289 .78 .726 r
.6656 .87253 m .59755 .89544 L .61668 .89013 L F
0 0 0 r
.8161 .72368 m .79281 .75926 L .76209 .80063 L F
.674 .923 .615 r
.79281 .75926 m .73554 .82704 L .76209 .80063 L F
0 g
.47768 .90014 m
.49301 .90152 L
s
0 .077 .575 r
.70794 .31339 m .73005 .3326 L .7797 .38121 L F
.723 .229 0 r
.73005 .3326 m .80103 .41094 L .7797 .38121 L F
0 g
.47364 .89961 m
.48896 .90125 L
s
.66741 .8715 m
.6678 .87134 L
s
.66694 .87169 m
.66741 .8715 L
s
.875 .877 .441 r
.83987 .63021 m .8161 .72368 L .83158 .68545 L F
.737 .702 .165 r
.84792 .58754 m .83987 .63021 L .83158 .68545 L F
0 0 0 r
.4172 .27702 m .47732 .26545 L .48442 .26021 L F
.4172 .27702 m .39889 .28503 L .47732 .26545 L F
0 g
.46962 .89901 m
.48492 .90091 L
s
.66768 .87131 m
.67148 .86964 L
s
.66719 .87153 m
.66768 .87131 L
s
0 .292 .666 r
.62528 .27335 m .64193 .28076 L .70794 .31339 L F
.321 0 0 r
.55668 .25893 m .64193 .28076 L .62528 .27335 L F
0 g
.46244 .89773 m
.47768 .90014 L
s
0 0 0 r
.33588 .31981 m .38312 .30104 L .39889 .28503 L F
.33588 .31981 m .31278 .33972 L .38312 .30104 L F
0 g
.66761 .87136 m
.67345 .86867 L
s
.66704 .87162 m
.66761 .87136 L
s
0 0 .236 r
.20416 .55554 m .22241 .53794 L .22264 .49498 L F
.20416 .55554 m .20393 .59707 L .22241 .53794 L F
0 g
.45846 .89691 m
.46293 .89771 L
s
.46293 .89771 m
.47364 .89961 L
s
.67332 .86866 m
.67535 .86769 L
s
.6678 .87134 m
.67332 .86866 L
s
.4545 .89601 m
.46273 .89764 L
s
.46273 .89764 m
.46962 .89901 L
s
.607 .037 0 r
.64193 .28076 m .73005 .3326 L .70794 .31339 L F
0 g
.67148 .86964 m
.67332 .86867 L
s
.44746 .89419 m
.44998 .89479 L
s
0 .452 .841 r
.39413 .87586 m .39184 .8659 L .35476 .85229 L F
.39413 .87586 m .42233 .88426 L .39184 .8659 L F
0 .043 .612 r
.24025 .7315 m .25291 .72098 L .22834 .68096 L F
.24025 .7315 m .26313 .76629 L .25291 .72098 L F
0 g
.67345 .86867 m
.67365 .86856 L
s
.211 0 0 r
.48442 .26021 m .56184 .26395 L .55668 .25893 L F
.48442 .26021 m .47732 .26545 L .56184 .26395 L F
0 g
.44357 .89306 m
.45049 .89485 L
s
.45049 .89485 m
.45846 .89691 L
s
.968 .722 .29 r
.82383 .48554 m .84792 .58754 L .84769 .54579 L F
.851 .548 .016 r
.81598 .44596 m .82383 .48554 L .84769 .54579 L F
0 .309 .79 r
.32308 .83227 m .33044 .82322 L .29338 .7972 L F
.32308 .83227 m .35476 .85229 L .33044 .82322 L F
.321 0 0 r
.55668 .25893 m .56184 .26395 L .64193 .28076 L F
0 0 .04 r
.24579 .42003 m .28144 .40003 L .29438 .36659 L F
.24579 .42003 m .23061 .45536 L .28144 .40003 L F
.289 .78 .726 r
.6656 .87253 m .63582 .88165 L .59755 .89544 L F
.569 .939 .858 r
.70282 .84795 m .63582 .88165 L .6656 .87253 L F
0 g
.67535 .86769 m
.67575 .86744 L
s
.405 .815 .613 r
.73554 .82704 m .70282 .84795 L .6656 .87253 L F
0 g
.67332 .86867 m
.6759 .86729 L
s
.6759 .86729 m
.67858 .86586 L
s
.67365 .86856 m
.67591 .86728 L
s
.67591 .86728 m
.68028 .86481 L
s
.67575 .86744 m
.68191 .86373 L
s
.43972 .89183 m
.4503 .89482 L
s
.4503 .89482 m
.4545 .89601 L
s
.17 .677 .904 r
.50672 .90343 m .48149 .89397 L .46181 .89708 L F
0 g
.44998 .89479 m
.46244 .89773 L
s
.17 .677 .904 r
.50672 .90343 m .51267 .8984 L .48149 .89397 L F
.225 .733 .891 r
.55326 .90287 m .51267 .8984 L .50672 .90343 L F
.55326 .90287 m .54505 .89801 L .51267 .8984 L F
.343 .814 .909 r
.59755 .89544 m .54505 .89801 L .55326 .90287 L F
0 g
.67858 .86586 m
.68464 .86174 L
s
.75 .993 .81 r
.76204 .79112 m .70282 .84795 L .73554 .82704 L F
.674 .923 .615 r
.79281 .75926 m .76204 .79112 L .73554 .82704 L F
.923 .96 .642 r
.82343 .67261 m .79281 .75926 L .8161 .72368 L F
.875 .877 .441 r
.83987 .63021 m .82343 .67261 L .8161 .72368 L F
0 g
.68028 .86481 m
.68605 .86059 L
s
.886 .457 .09 r
.74769 .35896 m .81598 .44596 L .80103 .41094 L F
.723 .229 0 r
.73005 .3326 m .74769 .35896 L .80103 .41094 L F
0 g
.68191 .86373 m
.68738 .85941 L
s
.184 .648 .938 r
.46181 .89708 m .45426 .88506 L .42233 .88426 L F
0 g
.42548 .8864 m
.43972 .89183 L
s
.42917 .88795 m
.42929 .888 L
s
.42929 .888 m
.44357 .89306 L
s
.43291 .88942 m
.44746 .89419 L
s
.184 .648 .938 r
.46181 .89708 m .48149 .89397 L .45426 .88506 L F
0 0 .456 r
.20393 .59707 m .23025 .58313 L .22241 .53794 L F
.20393 .59707 m .21196 .63926 L .23025 .58313 L F
.343 .814 .909 r
.59755 .89544 m .57579 .89283 L .54505 .89801 L F
.496 .894 .943 r
.63582 .88165 m .57579 .89283 L .59755 .89544 L F
0 g
.68464 .86174 m
.68956 .85721 L
s
.41899 .88338 m
.42167 .88454 L
s
.42167 .88454 m
.43291 .88942 L
s
.68605 .86059 m
.69065 .85594 L
s
.41905 .88324 m
.42119 .88424 L
s
.4291 .88792 m
.42917 .88795 L
s
.42119 .88424 m
.4291 .88792 L
s
.249 0 0 r
.39889 .28503 m .47119 .27919 L .47732 .26545 L F
.39889 .28503 m .38312 .30104 L .47119 .27919 L F
.126 0 .023 r
.31278 .33972 m .37051 .3251 L .38312 .30104 L F
.31278 .33972 m .29438 .36659 L .37051 .3251 L F
.001 .255 .761 r
.26313 .76629 m .28518 .75808 L .25291 .72098 L F
.26313 .76629 m .29338 .7972 L .28518 .75808 L F
0 g
.68738 .85941 m
.69039 .85605 L
s
.41934 .88334 m
.42135 .88434 L
s
.42135 .88434 m
.42548 .8864 L
s
1 .814 .485 r
.82405 .52873 m .83987 .63021 L .84792 .58754 L F
.968 .722 .29 r
.82383 .48554 m .82405 .52873 L .84792 .58754 L F
.607 .037 0 r
.64193 .28076 m .65628 .29628 L .73005 .3326 L F
.581 .036 0 r
.56184 .26395 m .65628 .29628 L .64193 .28076 L F
.054 0 .285 r
.23061 .45536 m .27463 .43937 L .28144 .40003 L F
.23061 .45536 m .22264 .49498 L .27463 .43937 L F
.148 .502 .909 r
.35476 .85229 m .37347 .84343 L .33044 .82322 L F
.35476 .85229 m .39184 .8659 L .37347 .84343 L F
.777 .286 .055 r
.65628 .29628 m .74769 .35896 L .73005 .3326 L F
0 g
.41832 .883 m
.41899 .88338 L
s
.68956 .85721 m
.69043 .85602 L
s
.252 .635 .961 r
.42233 .88426 m .43352 .8724 L .39184 .8659 L F
0 g
.40588 .87603 m
.41557 .88146 L
s
.41557 .88146 m
.41832 .883 L
s
.41196 .87966 m
.41557 .88146 L
s
.41557 .88146 m
.41934 .88334 L
s
.41544 .88156 m
.41641 .88202 L
s
.41641 .88202 m
.41905 .88324 L
s
.252 .635 .961 r
.42233 .88426 m .45426 .88506 L .43352 .8724 L F
.914 .978 .771 r
.79882 .71352 m .76204 .79112 L .79281 .75926 L F
.923 .96 .642 r
.82343 .67261 m .79882 .71352 L .79281 .75926 L F
0 g
.40258 .87388 m
.41544 .88156 L
s
.69065 .85594 m
.69073 .85582 L
s
.569 .939 .858 r
.70282 .84795 m .66456 .86253 L .63582 .88165 L F
.758 .981 .912 r
.72439 .8182 m .66456 .86253 L .70282 .84795 L F
0 g
.69153 .85477 m
.69166 .85463 L
s
.69039 .85605 m
.69153 .85477 L
s
.69155 .85448 m
.69322 .85218 L
s
.69043 .85602 m
.69155 .85448 L
s
.69154 .85454 m
.69396 .85077 L
s
.69073 .85582 m
.69154 .85454 L
s
.75 .993 .81 r
.76204 .79112 m .72439 .8182 L .70282 .84795 L F
.496 .894 .943 r
.63582 .88165 m .60213 .88326 L .57579 .89283 L F
.638 .938 .963 r
.66456 .86253 m .60213 .88326 L .63582 .88165 L F
0 g
.39936 .87164 m
.41196 .87966 L
s
.69166 .85463 m
.69455 .84942 L
s
.69455 .84942 m
.69461 .84931 L
s
.063 .115 .606 r
.21196 .63926 m .24619 .62924 L .23025 .58313 L F
.21196 .63926 m .22834 .68096 L .24619 .62924 L F
.943 .592 .316 r
.76009 .39211 m .82383 .48554 L .81598 .44596 L F
.886 .457 .09 r
.74769 .35896 m .76009 .39211 L .81598 .44596 L F
.46 0 0 r
.47732 .26545 m .56629 .27752 L .56184 .26395 L F
.47732 .26545 m .47119 .27919 L .56629 .27752 L F
0 g
.39378 .86741 m
.40588 .87603 L
s
.581 .036 0 r
.56184 .26395 m .56629 .27752 L .65628 .29628 L F
0 g
.69322 .85218 m
.69422 .84974 L
s
.69422 .84974 m
.69551 .84658 L
s
.39282 .86648 m
.40258 .87388 L
s
.39278 .86645 m
.39282 .86648 L
s
.18 .413 .851 r
.29338 .7972 m .32442 .79105 L .28518 .75808 L F
.29338 .7972 m .33044 .82322 L .32442 .79105 L F
.442 .784 .998 r
.51267 .8984 m .50315 .88247 L .48149 .89397 L F
.51267 .8984 m .51925 .88478 L .50315 .88247 L F
.474 .818 .998 r
.54505 .89801 m .51925 .88478 L .51267 .8984 L F
0 g
.69396 .85077 m
.69434 .84962 L
s
.69434 .84962 m
.69587 .845 L
s
.474 .818 .998 r
.54505 .89801 m .53599 .88458 L .51925 .88478 L F
.528 .851 .998 r
.57579 .89283 m .53599 .88458 L .54505 .89801 L F
.988 .857 .618 r
.81633 .57439 m .82343 .67261 L .83987 .63021 L F
1 .814 .485 r
.82405 .52873 m .81633 .57439 L .83987 .63021 L F
0 g
.39355 .86696 m
.39936 .87164 L
s
.39344 .86687 m
.39355 .86696 L
s
.435 .753 .994 r
.48149 .89397 m .48921 .87785 L .45426 .88506 L F
.48149 .89397 m .50315 .88247 L .48921 .87785 L F
.877 .963 .85 r
.7665 .75166 m .72439 .8182 L .76204 .79112 L F
.914 .978 .771 r
.79882 .71352 m .7665 .75166 L .76204 .79112 L F
.528 .851 .998 r
.57579 .89283 m .55183 .88188 L .53599 .88458 L F
.591 .874 .993 r
.60213 .88326 m .55183 .88188 L .57579 .89283 L F
0 g
.39257 .86633 m
.39378 .86741 L
s
.39252 .86628 m
.39257 .86633 L
s
.283 0 .258 r
.29438 .36659 m .36162 .35694 L .37051 .3251 L F
.29438 .36659 m .28144 .40003 L .36162 .35694 L F
.192 .053 .451 r
.22264 .49498 m .27444 .48366 L .27463 .43937 L F
.22264 .49498 m .22241 .53794 L .27444 .48366 L F
.341 .627 .958 r
.39184 .8659 m .42138 .85705 L .37347 .84343 L F
0 g
.38286 .85758 m
.39107 .86498 L
s
.39107 .86498 m
.39111 .86501 L
s
.38786 .86237 m
.39101 .86491 L
s
.39101 .86491 m
.39104 .86494 L
s
.39161 .86557 m
.39169 .86563 L
s
.39078 .86493 m
.39161 .86557 L
s
.341 .627 .958 r
.39184 .8659 m .43352 .8724 L .42138 .85705 L F
0 g
.3802 .8548 m
.39078 .86493 L
s
.193 .263 .707 r
.22834 .68096 m .26998 .67486 L .24619 .62924 L F
.22834 .68096 m .25291 .72098 L .26998 .67486 L F
.413 .01 .163 r
.38312 .30104 m .46628 .30159 L .47119 .27919 L F
.38312 .30104 m .37051 .3251 L .46628 .30159 L F
.638 .938 .963 r
.66456 .86253 m .62162 .87009 L .60213 .88326 L F
.732 .933 .955 r
.68074 .83958 m .62162 .87009 L .66456 .86253 L F
.758 .981 .912 r
.72439 .8182 m .68074 .83958 L .66456 .86253 L F
0 g
.69551 .84658 m
.6963 .84034 L
s
.69461 .84931 m
.69612 .84338 L
s
.37764 .85195 m
.38786 .86237 L
s
.84 .436 .277 r
.66776 .31999 m .76009 .39211 L .74769 .35896 L F
.777 .286 .055 r
.65628 .29628 m .66776 .31999 L .74769 .35896 L F
.698 .245 .174 r
.56629 .27752 m .66776 .31999 L .65628 .29628 L F
.45 .727 .985 r
.45426 .88506 m .47875 .87132 L .43352 .8724 L F
.45426 .88506 m .48921 .87785 L .47875 .87132 L F
.951 .669 .466 r
.76663 .4314 m .82405 .52873 L .82383 .48554 L F
.943 .592 .316 r
.76009 .39211 m .76663 .4314 L .82383 .48554 L F
.591 .874 .993 r
.60213 .88326 m .5653 .87692 L .55183 .88188 L F
.649 .882 .983 r
.62162 .87009 m .5653 .87692 L .60213 .88326 L F
0 g
.3733 .84665 m
.38286 .85758 L
s
.318 .531 .903 r
.33044 .82322 m .36955 .81881 L .32442 .79105 L F
.33044 .82322 m .37347 .84343 L .36955 .81881 L F
.958 .873 .71 r
.80064 .6212 m .79882 .71352 L .82343 .67261 L F
.988 .857 .618 r
.81633 .57439 m .80064 .6212 L .82343 .67261 L F
0 g
.37272 .84568 m
.3802 .8548 L
s
.37102 .84361 m
.37272 .84568 L
s
.37327 .84626 m
.37764 .85195 L
s
.37078 .84301 m
.37327 .84626 L
s
.829 .933 .899 r
.72727 .7858 m .68074 .83958 L .72439 .8182 L F
0 g
.69548 .83339 m
.69584 .83646 L
s
.69584 .83646 m
.6963 .84034 L
s
.69607 .83677 m
.69608 .83698 L
s
.69608 .83698 m
.69612 .84338 L
s
.69587 .845 m
.69624 .83858 L
s
.877 .963 .85 r
.7665 .75166 m .72727 .7858 L .72439 .8182 L F
0 g
.69499 .83144 m
.69589 .83656 L
s
.69589 .83656 m
.69624 .83858 L
s
.293 .377 .778 r
.25291 .72098 m .30104 .71853 L .26998 .67486 L F
.25291 .72098 m .28518 .75808 L .30104 .71853 L F
.289 .189 .563 r
.22241 .53794 m .28113 .53168 L .27444 .48366 L F
.22241 .53794 m .23025 .58313 L .28113 .53168 L F
0 g
.36952 .8411 m
.37068 .8428 L
s
.37068 .8428 m
.3733 .84665 L
s
.36522 .83478 m
.36952 .8411 L
s
.58 .157 .203 r
.47119 .27919 m .56987 .29979 L .56629 .27752 L F
.47119 .27919 m .46628 .30159 L .56987 .29979 L F
.48 .707 .969 r
.43352 .8724 m .47282 .8635 L .42138 .85705 L F
.43352 .8724 m .47875 .87132 L .47282 .8635 L F
.698 .245 .174 r
.56629 .27752 m .56987 .29979 L .66776 .31999 L F
0 g
.36922 .84076 m
.37102 .84361 L
s
.36335 .83151 m
.36922 .84076 L
s
.649 .882 .983 r
.62162 .87009 m .5751 .87014 L .5653 .87692 L F
.693 .874 .966 r
.63223 .85443 m .5751 .87014 L .62162 .87009 L F
.732 .933 .955 r
.68074 .83958 m .63223 .85443 L .62162 .87009 L F
.379 .133 .41 r
.28144 .40003 m .35693 .396 L .36162 .35694 L F
.28144 .40003 m .27463 .43937 L .35693 .396 L F
.625 .78 .955 r
.56441 .83889 m .51925 .88478 L .53599 .88458 L F
.56441 .83889 m .50315 .88247 L .51925 .88478 L F
.56441 .83889 m .53599 .88458 L .55183 .88188 L F
.427 .621 .933 r
.37347 .84343 m .41927 .84041 L .36955 .81881 L F
0 g
.36884 .8405 m
.37078 .84301 L
s
.427 .621 .933 r
.37347 .84343 m .42138 .85705 L .41927 .84041 L F
0 g
.36159 .82819 m
.36884 .8405 L
s
.92 .876 .776 r
.77723 .66772 m .7665 .75166 L .79882 .71352 L F
.958 .873 .71 r
.80064 .6212 m .77723 .66772 L .79882 .71352 L F
.625 .78 .955 r
.56441 .83889 m .48921 .87785 L .50315 .88247 L F
.94 .715 .57 r
.76681 .47588 m .81633 .57439 L .82405 .52873 L F
.951 .669 .466 r
.76663 .4314 m .76681 .47588 L .82405 .52873 L F
.625 .78 .955 r
.56441 .83889 m .55183 .88188 L .5653 .87692 L F
.775 .895 .928 r
.68221 .81482 m .63223 .85443 L .68074 .83958 L F
.829 .933 .899 r
.72727 .7858 m .68221 .81482 L .68074 .83958 L F
0 g
.69203 .82356 m
.69455 .83028 L
s
.69455 .83028 m
.69499 .83144 L
s
.69298 .82571 m
.69453 .83048 L
s
.69453 .83048 m
.69548 .83339 L
s
.69438 .82943 m
.69456 .83021 L
s
.69456 .83021 m
.69607 .83677 L
s
.35873 .82214 m
.36522 .83478 L
s
.858 .525 .42 r
.67586 .35163 m .76663 .4314 L .76009 .39211 L F
.84 .436 .277 r
.66776 .31999 m .67586 .35163 L .76009 .39211 L F
0 g
.69095 .82136 m
.69438 .82943 L
s
.501 .171 .339 r
.37051 .3251 m .46281 .33249 L .46628 .30159 L F
.37051 .3251 m .36162 .35694 L .46281 .33249 L F
.625 .78 .955 r
.56441 .83889 m .47875 .87132 L .48921 .87785 L F
.374 .471 .831 r
.28518 .75808 m .33851 .75881 L .30104 .71853 L F
.28518 .75808 m .32442 .79105 L .33851 .75881 L F
0 g
.35729 .8187 m
.36335 .83151 L
s
.625 .78 .955 r
.56441 .83889 m .5653 .87692 L .5751 .87014 L F
.745 .371 .345 r
.56987 .29979 m .67586 .35163 L .66776 .31999 L F
0 g
.68871 .81728 m
.69298 .82571 L
s
.36 .293 .645 r
.23025 .58313 m .29472 .58199 L .28113 .53168 L F
.23025 .58313 m .24619 .62924 L .29472 .58199 L F
.515 .693 .949 r
.42138 .85705 m .47207 .8551 L .41927 .84041 L F
.42138 .85705 m .47282 .8635 L .47207 .8551 L F
.878 .871 .826 r
.74669 .71243 m .72727 .7858 L .7665 .75166 L F
.92 .876 .776 r
.77723 .66772 m .74669 .71243 L .7665 .75166 L F
.625 .78 .955 r
.56441 .83889 m .47282 .8635 L .47875 .87132 L F
0 g
.68729 .81494 m
.69203 .82356 L
s
.625 .78 .955 r
.56441 .83889 m .5751 .87014 L .58023 .86217 L F
.693 .874 .966 r
.63223 .85443 m .58023 .86217 L .5751 .87014 L F
.718 .852 .946 r
.63265 .83772 m .58023 .86217 L .63223 .85443 L F
.775 .895 .928 r
.68221 .81482 m .63265 .83772 L .63223 .85443 L F
.441 .55 .871 r
.32442 .79105 m .38121 .79438 L .33851 .75881 L F
.32442 .79105 m .36955 .81881 L .38121 .79438 L F
0 g
.35291 .8054 m
.35627 .81561 L
s
.35627 .81561 m
.35729 .8187 L
s
.3539 .80895 m
.35623 .81532 L
s
.35623 .81532 m
.35873 .82214 L
s
.35597 .81523 m
.35633 .81606 L
s
.35633 .81606 m
.36159 .82819 L
s
.92 .743 .646 r
.76039 .52432 m .80064 .6212 L .81633 .57439 L F
.94 .715 .57 r
.76681 .47588 m .76039 .52432 L .81633 .57439 L F
0 g
.35267 .80399 m
.35597 .81523 L
s
.35204 .80185 m
.35267 .80399 L
s
.442 .243 .513 r
.27463 .43937 m .35679 .44132 L .35693 .396 L F
.27463 .43937 m .27444 .48366 L .35679 .44132 L F
.625 .78 .955 r
.56441 .83889 m .47207 .8551 L .47282 .8635 L F
.833 .86 .865 r
.70991 .75387 m .68221 .81482 L .72727 .7858 L F
0 g
.68574 .81254 m
.68654 .8139 L
s
.68654 .8139 m
.69095 .82136 L
s
.878 .871 .826 r
.74669 .71243 m .70991 .75387 L .72727 .7858 L F
0 g
.68615 .81341 m
.68871 .81728 L
s
.625 .78 .955 r
.56441 .83889 m .58023 .86217 L .58013 .85376 L F
.718 .852 .946 r
.63265 .83772 m .58013 .85376 L .58023 .86217 L F
0 g
.35283 .80434 m
.3539 .80895 L
s
.35077 .79543 m
.35283 .80434 L
s
.638 .288 .361 r
.46628 .30159 m .57239 .33062 L .56987 .29979 L F
.46628 .30159 m .46281 .33249 L .57239 .33062 L F
.499 .621 .902 r
.36955 .81881 m .42776 .82406 L .38121 .79438 L F
.36955 .81881 m .41927 .84041 L .42776 .82406 L F
.745 .371 .345 r
.56987 .29979 m .57239 .33062 L .67586 .35163 L F
.415 .376 .707 r
.24619 .62924 m .31491 .63294 L .29472 .58199 L F
.24619 .62924 m .26998 .67486 L .31491 .63294 L F
0 g
.68669 .81408 m
.68729 .81494 L
s
.35023 .79185 m
.35291 .8054 L
s
.859 .582 .518 r
.68013 .39064 m .76681 .47588 L .76663 .4314 L F
.858 .525 .42 r
.67586 .35163 m .68013 .39064 L .76663 .4314 L F
0 g
.34981 .78826 m
.35204 .80185 L
s
.784 .845 .898 r
.66805 .79065 m .63265 .83772 L .68221 .81482 L F
.833 .86 .865 r
.70991 .75387 m .66805 .79065 L .68221 .81482 L F
0 g
.68338 .80936 m
.68529 .81208 L
s
.68076 .80561 m
.68338 .80936 L
s
.68347 .80946 m
.68512 .8117 L
s
.67874 .80304 m
.68347 .80946 L
s
.68512 .8117 m
.68574 .81254 L
s
.68529 .81208 m
.68669 .81408 L
s
.68265 .80814 m
.68533 .81217 L
s
.68533 .81217 m
.68615 .81341 L
s
.552 .686 .928 r
.41927 .84041 m .47665 .84695 L .42776 .82406 L F
.41927 .84041 m .47207 .8551 L .47665 .84695 L F
.625 .78 .955 r
.56441 .83889 m .47665 .84695 L .47207 .8551 L F
.56441 .83889 m .58013 .85376 L .5747 .84573 L F
.728 .824 .925 r
.62248 .82159 m .58013 .85376 L .63265 .83772 L F
.62248 .82159 m .5747 .84573 L .58013 .85376 L F
.784 .845 .898 r
.66805 .79065 m .62248 .82159 L .63265 .83772 L F
.551 .277 .453 r
.36162 .35694 m .46098 .37136 L .46281 .33249 L F
.36162 .35694 m .35693 .396 L .46098 .37136 L F
.897 .762 .705 r
.74737 .57524 m .77723 .66772 L .80064 .6212 L F
.92 .743 .646 r
.76039 .52432 m .74737 .57524 L .80064 .6212 L F
0 g
.34934 .78184 m
.35077 .79543 L
s
.67481 .79833 m
.68265 .80814 L
s
.34925 .77827 m
.35023 .79185 L
s
.764 .451 .457 r
.57239 .33062 m .68013 .39064 L .67586 .35163 L F
.459 .447 .757 r
.26998 .67486 m .34113 .68283 L .31491 .63294 L F
.26998 .67486 m .30104 .71853 L .34113 .68283 L F
0 g
.67245 .79565 m
.68076 .80561 L
s
.34927 .77471 m
.34981 .78826 L
s
.625 .78 .955 r
.56441 .83889 m .48621 .83988 L .47665 .84695 L F
.587 .685 .909 r
.42776 .82406 m .47665 .84695 L .48621 .83988 L F
.485 .325 .588 r
.27444 .48366 m .3614 .49161 L .35679 .44132 L F
.27444 .48366 m .28113 .53168 L .3614 .49161 L F
.725 .794 .907 r
.6024 .80771 m .5747 .84573 L .62248 .82159 L F
.6024 .80771 m .56441 .83889 L .5747 .84573 L F
.871 .776 .754 r
.72802 .62697 m .74669 .71243 L .77723 .66772 L F
.897 .762 .705 r
.74737 .57524 m .72802 .62697 L .77723 .66772 L F
.496 .51 .801 r
.30104 .71853 m .37252 .72995 L .34113 .68283 L F
.30104 .71853 m .33851 .75881 L .37252 .72995 L F
0 g
.6689 .79193 m
.67481 .79833 L
s
.66882 .79184 m
.6689 .79193 L
s
.587 .685 .909 r
.42776 .82406 m .48621 .83988 L .44635 .80972 L F
.559 .627 .875 r
.38121 .79438 m .42776 .82406 L .44635 .80972 L F
.852 .623 .59 r
.68025 .43609 m .76039 .52432 L .76681 .47588 L F
.859 .582 .518 r
.68013 .39064 m .68025 .43609 L .76681 .47588 L F
.625 .78 .955 r
.56441 .83889 m .49985 .83461 L .48621 .83988 L F
.62 .691 .895 r
.44635 .80972 m .48621 .83988 L .49985 .83461 L F
.625 .78 .955 r
.56441 .83889 m .5162 .83171 L .49985 .83461 L F
.56441 .83889 m .5336 .83149 L .5162 .83171 L F
.56441 .83889 m .55024 .83397 L .5336 .83149 L F
.714 .766 .893 r
.57427 .79763 m .56441 .83889 L .6024 .80771 L F
.57427 .79763 m .55024 .83397 L .56441 .83889 L F
0 g
.66887 .7919 m
.67245 .79565 L
s
.66881 .79183 m
.66887 .7919 L
s
.772 .795 .871 r
.63898 .76966 m .62248 .82159 L .66805 .79065 L F
.63898 .76966 m .6024 .80771 L .62248 .82159 L F
.529 .569 .839 r
.33851 .75881 m .40801 .77271 L .37252 .72995 L F
0 g
.34925 .77827 m
.34935 .77617 L
s
.34934 .78184 m
.34946 .7757 L
s
.529 .569 .839 r
.33851 .75881 m .38121 .79438 L .40801 .77271 L F
0 g
.34946 .7757 m
.34959 .76839 L
s
.34935 .77617 m
.34993 .7649 L
s
.34927 .77471 m
.35021 .76346 L
s
.35021 .76346 m
.35038 .76144 L
s
.559 .627 .875 r
.38121 .79438 m .44635 .80972 L .40801 .77271 L F
0 g
.35085 .75966 m
.35147 .75533 L
s
.34959 .76839 m
.35085 .75966 L
s
.842 .785 .796 r
.70291 .67777 m .70991 .75387 L .74669 .71243 L F
.871 .776 .754 r
.72802 .62697 m .70291 .67777 L .74669 .71243 L F
.667 .373 .465 r
.46281 .33249 m .57372 .36947 L .57239 .33062 L F
.46281 .33249 m .46098 .37136 L .57372 .36947 L F
.649 .702 .886 r
.47335 .79894 m .49985 .83461 L .5162 .83171 L F
.62 .691 .895 r
.44635 .80972 m .49985 .83461 L .47335 .79894 L F
0 g
.35088 .7596 m
.35223 .75197 L
s
.34993 .7649 m
.35088 .7596 L
s
.764 .451 .457 r
.57239 .33062 m .57372 .36947 L .68013 .39064 L F
.697 .74 .885 r
.54097 .79251 m .55024 .83397 L .57427 .79763 L F
.54097 .79251 m .5336 .83149 L .55024 .83397 L F
0 g
.66786 .79068 m
.66793 .79075 L
s
.81 .792 .835 r
.67289 .72587 m .66805 .79065 L .70991 .75387 L F
.67289 .72587 m .63898 .76966 L .66805 .79065 L F
0 g
.65714 .78005 m
.66781 .79063 L
s
.66781 .79063 m
.66786 .79068 L
s
.66524 .78796 m
.66708 .78996 L
s
.66708 .78996 m
.66708 .78996 L
s
.66653 .78944 m
.66661 .78953 L
s
.66243 .78515 m
.66653 .78944 L
s
.842 .785 .796 r
.70291 .67777 m .67289 .72587 L .70991 .75387 L F
0 g
.35066 .76016 m
.3531 .74866 L
s
.35038 .76144 m
.35066 .76016 L
s
.674 .719 .883 r
.50606 .79297 m .5162 .83171 L .5336 .83149 L F
.649 .702 .886 r
.47335 .79894 m .5162 .83171 L .50606 .79297 L F
.674 .719 .883 r
.50606 .79297 m .5336 .83149 L .54097 .79251 L F
.583 .354 .534 r
.35693 .396 m .46092 .41726 L .46098 .37136 L F
.35693 .396 m .35679 .44132 L .46092 .41726 L F
.517 .391 .647 r
.28113 .53168 m .37074 .5453 L .3614 .49161 L F
.28113 .53168 m .29472 .58199 L .37074 .5453 L F
0 g
.65403 .77717 m
.66524 .78796 L
s
.35147 .75533 m
.35492 .74284 L
s
.65082 .77427 m
.66243 .78515 L
s
.771 .507 .536 r
.57372 .36947 m .68025 .43609 L .68013 .39064 L F
0 g
.35223 .75197 m
.35608 .73968 L
s
.609 .639 .855 r
.40801 .77271 m .44635 .80972 L .47335 .79894 L F
0 g
.3531 .74866 m
.35734 .73656 L
s
.842 .653 .647 r
.67605 .48667 m .74737 .57524 L .76039 .52432 L F
.852 .623 .59 r
.68025 .43609 m .67605 .48667 L .76039 .52432 L F
.75 .751 .853 r
.59758 .75429 m .6024 .80771 L .63898 .76966 L F
.59758 .75429 m .57427 .79763 L .6024 .80771 L F
0 g
.64487 .7691 m
.65714 .78005 L
s
.64481 .76904 m
.64487 .7691 L
s
.35492 .74284 m
.35985 .73114 L
s
.64631 .77045 m
.65403 .77717 L
s
.35608 .73968 m
.36139 .7282 L
s
.543 .447 .696 r
.29472 .58199 m .38457 .60054 L .37074 .5453 L F
.29472 .58199 m .31491 .63294 L .38457 .60054 L F
0 g
.64623 .77038 m
.65082 .77427 L
s
.35734 .73656 m
.36161 .72813 L
s
.36161 .72813 m
.36303 .72534 L
s
.609 .639 .855 r
.40801 .77271 m .47335 .79894 L .44768 .75629 L F
.596 .591 .817 r
.37252 .72995 m .40801 .77271 L .44768 .75629 L F
.652 .658 .843 r
.44768 .75629 m .47335 .79894 L .50606 .79297 L F
0 g
.35985 .73114 m
.36162 .72815 L
s
.722 .713 .842 r
.54813 .74645 m .57427 .79763 L .59758 .75429 L F
.54813 .74645 m .54097 .79251 L .57427 .79763 L F
.829 .677 .694 r
.66755 .54078 m .72802 .62697 L .74737 .57524 L F
.842 .653 .647 r
.67605 .48667 m .66755 .54078 L .74737 .57524 L F
.777 .735 .814 r
.61931 .70522 m .63898 .76966 L .67289 .72587 L F
0 g
.6404 .76545 m
.64304 .76761 L
s
.64304 .76761 m
.64481 .76904 L
s
.64001 .7651 m
.64243 .76715 L
s
.64243 .76715 m
.64623 .77038 L
s
.64132 .76611 m
.64302 .76759 L
s
.64302 .76759 m
.64631 .77045 L
s
.777 .735 .814 r
.61931 .70522 m .59758 .75429 L .63898 .76966 L F
0 g
.63775 .76317 m
.64001 .7651 L
s
.63112 .75791 m
.63133 .75808 L
s
.63133 .75808 m
.6404 .76545 L
s
.604 .412 .595 r
.35679 .44132 m .46272 .46887 L .46092 .41726 L F
.35679 .44132 m .3614 .49161 L .46272 .46887 L F
.684 .435 .54 r
.46098 .37136 m .57376 .41542 L .57372 .36947 L F
.46098 .37136 m .46092 .41726 L .57376 .41542 L F
0 g
.63977 .76488 m
.64132 .76611 L
s
.6273 .75498 m
.63977 .76488 L
s
.563 .497 .739 r
.31491 .63294 m .40246 .65539 L .38457 .60054 L F
.31491 .63294 m .34113 .68283 L .40246 .65539 L F
.771 .507 .536 r
.57372 .36947 m .57376 .41542 L .68025 .43609 L F
.596 .591 .817 r
.37252 .72995 m .44768 .75629 L .42376 .70792 L F
.581 .544 .778 r
.34113 .68283 m .37252 .72995 L .42376 .70792 L F
0 g
.36916 .71646 m
.37008 .71513 L
s
.36362 .72448 m
.36916 .71646 L
s
.36303 .72534 m
.36362 .72448 L
s
.36393 .72423 m
.36809 .71772 L
s
.36139 .7282 m
.36393 .72423 L
s
.36393 .72423 m
.36619 .72038 L
s
.36162 .72815 m
.36393 .72423 L
s
.62341 .75205 m
.63775 .76317 L
s
.689 .682 .839 r
.49619 .74714 m .50606 .79297 L .54097 .79251 L F
.652 .658 .843 r
.44768 .75629 m .50606 .79297 L .49619 .74714 L F
0 g
.36619 .72038 m
.36904 .71679 L
s
.36904 .71679 m
.37386 .7107 L
s
.689 .682 .839 r
.49619 .74714 m .54097 .79251 L .54813 .74645 L F
.581 .544 .778 r
.34113 .68283 m .42376 .70792 L .40246 .65539 L F
.772 .548 .596 r
.57376 .41542 m .67605 .48667 L .68025 .43609 L F
0 g
.36809 .71772 m
.37609 .70835 L
s
.815 .698 .736 r
.65495 .59656 m .70291 .67777 L .72802 .62697 L F
.829 .677 .694 r
.66755 .54078 m .65495 .59656 L .72802 .62697 L F
.798 .717 .776 r
.63868 .65203 m .67289 .72587 L .70291 .67777 L F
.63868 .65203 m .61931 .70522 L .67289 .72587 L F
0 g
.37008 .71513 m
.3784 .70608 L
s
.63089 .75774 m
.63112 .75791 L
s
.61625 .74684 m
.63089 .75774 L
s
.815 .698 .736 r
.65495 .59656 m .63868 .65203 L .70291 .67777 L F
0 g
.37386 .7107 m
.38276 .70224 L
s
.37609 .70835 m
.3853 .70022 L
s
.3784 .70608 m
.38792 .69829 L
s
.65 .617 .803 r
.42376 .70792 m .44768 .75629 L .49619 .74714 L F
0 g
.38276 .70224 m
.39282 .69508 L
s
.739 .688 .802 r
.55484 .69464 m .59758 .75429 L .61931 .70522 L F
0 g
.60044 .73606 m
.6107 .74305 L
s
.6107 .74305 m
.61625 .74684 L
s
.60802 .74111 m
.61103 .74325 L
s
.61103 .74325 m
.62341 .75205 L
s
.61217 .74397 m
.6273 .75498 L
s
.739 .688 .802 r
.55484 .69464 m .54813 .74645 L .59758 .75429 L F
.619 .461 .645 r
.3614 .49161 m .46637 .52451 L .46272 .46887 L F
.3614 .49161 m .37074 .5453 L .46637 .52451 L F
0 g
.3853 .70022 m
.39566 .69342 L
s
.59648 .73352 m
.61164 .74362 L
s
.61164 .74362 m
.61217 .74397 L
s
.59615 .73329 m
.59648 .73352 L
s
.38792 .69829 m
.39857 .69186 L
s
.59743 .73422 m
.60802 .74111 L
s
.5918 .73056 m
.59743 .73422 L
s
.77 .582 .645 r
.57245 .46713 m .66755 .54078 L .67605 .48667 L F
.772 .548 .596 r
.57376 .41542 m .57245 .46713 L .67605 .48667 L F
.693 .482 .597 r
.46092 .41726 m .57245 .46713 L .57376 .41542 L F
.46092 .41726 m .46272 .46887 L .57245 .46713 L F
0 g
.39282 .69508 m
.40396 .6893 L
s
.59711 .73398 m
.60044 .73606 L
s
.58392 .72577 m
.59711 .73398 L
s
.697 .649 .798 r
.48695 .69558 m .49619 .74714 L .54813 .74645 L F
.65 .617 .803 r
.42376 .70792 m .49619 .74714 L .48695 .69558 L F
0 g
.57948 .72316 m
.59615 .73329 L
s
.697 .649 .798 r
.48695 .69558 m .54813 .74645 L .55484 .69464 L F
0 g
.575 .7206 m
.5918 .73056 L
s
.646 .579 .765 r
.40246 .65539 m .42376 .70792 L .48695 .69558 L F
0 g
.40653 .68839 m
.41612 .68497 L
s
.40396 .6893 m
.40653 .68839 L
s
.40664 .68838 m
.41025 .68683 L
s
.39857 .69186 m
.40664 .68838 L
s
.40629 .68839 m
.40707 .68802 L
s
.39566 .69342 m
.40629 .68839 L
s
.40707 .68802 m
.41949 .68407 L
s
.631 .503 .688 r
.37074 .5453 m .47176 .58224 L .46637 .52451 L F
.37074 .5453 m .38457 .60054 L .47176 .58224 L F
0 g
.41025 .68683 m
.42253 .68339 L
s
.42253 .68339 m
.42292 .68328 L
s
.56692 .71616 m
.58392 .72577 L
s
.75 .663 .764 r
.56083 .63878 m .61931 .70522 L .63868 .65203 L F
.56083 .63878 m .55484 .69464 L .61931 .70522 L F
0 g
.56238 .71376 m
.57948 .72316 L
s
.41612 .68497 m
.42217 .68365 L
s
.41949 .68407 m
.4223 .68355 L
s
.55783 .71143 m
.575 .7206 L
s
.765 .611 .687 r
.5698 .52292 m .65495 .59656 L .66755 .54078 L F
.77 .582 .645 r
.57245 .46713 m .5698 .52292 L .66755 .54078 L F
.646 .579 .765 r
.40246 .65539 m .48695 .69558 L .4787 .63996 L F
0 g
.42292 .68328 m
.43649 .68122 L
s
.4223 .68355 m
.43283 .68161 L
s
.42217 .68365 m
.42923 .68211 L
s
.639 .542 .728 r
.38457 .60054 m .40246 .65539 L .4787 .63996 L F
.38457 .60054 m .4787 .63996 L .47176 .58224 L F
0 g
.54966 .70742 m
.56202 .71368 L
s
.56202 .71368 m
.56692 .71616 L
s
.42923 .68211 m
.4432 .68077 L
s
.54551 .70548 m
.56238 .71376 L
s
.54509 .70528 m
.54551 .70548 L
s
.43283 .68161 m
.44703 .68066 L
s
.43649 .68122 m
.4509 .68066 L
s
.54625 .70593 m
.55783 .71143 L
s
.54052 .70322 m
.54625 .70593 L
s
.759 .638 .726 r
.56588 .58084 m .63868 .65203 L .65495 .59656 L F
.56588 .58084 m .56083 .63878 L .63868 .65203 L F
0 g
.4432 .68077 m
.45798 .68093 L
s
.765 .611 .687 r
.5698 .52292 m .56588 .58084 L .65495 .59656 L F
0 g
.54602 .7058 m
.54966 .70742 L
s
.53235 .69971 m
.54602 .7058 L
s
.699 .521 .644 r
.46272 .46887 m .5698 .52292 L .57245 .46713 L F
.46272 .46887 m .46637 .52451 L .5698 .52292 L F
0 g
.44703 .68066 m
.462 .68122 L
s
.5278 .69787 m
.54509 .70528 L
s
.4509 .68066 m
.46607 .68162 L
s
.52327 .69611 m
.54052 .70322 L
s
.701 .618 .761 r
.4787 .63996 m .48695 .69558 L .55484 .69464 L F
0 g
.45798 .68093 m
.47348 .68259 L
s
.462 .68122 m
.47768 .68327 L
s
.46607 .68162 m
.47833 .6835 L
s
.701 .618 .761 r
.4787 .63996 m .55484 .69464 L .56083 .63878 L F
0 g
.47833 .6835 m
.48191 .68405 L
s
.51518 .69318 m
.53235 .69971 L
s
.5107 .69166 m
.5278 .69787 L
s
.50624 .69024 m
.52327 .69611 L
s
.47851 .68356 m
.48961 .68571 L
s
.47348 .68259 m
.47851 .68356 L
s
.47768 .68327 m
.4906 .68605 L
s
.4906 .68605 m
.49395 .68677 L
s
.49832 .68793 m
.51518 .69318 L
s
.48191 .68405 m
.49032 .68604 L
s
.49032 .68604 m
.49832 .68793 L
s
.49395 .68677 m
.5107 .69166 L
s
.48961 .68571 m
.50624 .69024 L
s
.702 .555 .685 r
.46637 .52451 m .56588 .58084 L .5698 .52292 L F
.46637 .52451 m .47176 .58224 L .56588 .58084 L F
.702 .587 .724 r
.47176 .58224 m .4787 .63996 L .56083 .63878 L F
.47176 .58224 m .56083 .63878 L .56588 .58084 L F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[22]:=",
  ImageSize->{266.562, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004:00017a000`40n007h00Ooooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
P?oo53001500L_oo001lool2000G<008D01]ool007Ooo`<00004<00h0300>00HL0001I0PT42@8910
T2001e00J?oo001cool30008>00HL00:T406D01Tool006koo`@0000<<00h0300>00`03P0<00h0300
>00`03P0670000n@8910T22@@90PT42@8910T22@@90PT42@8910T2000e00H_oo001/ool2000?>00J
TDH4/LD?T41Pool006Woo`0D>00`03P0<00h0300>00`03P0<00h0300>00`03P0<01X1F05J0EP1AZA
APVaa@0<T22@@90PT42@8910T22@@90PT42@89Q0G_oo001Xool00`00>00h000:>008J0DJTDH>/LD7
T402V41Lool006Koo`80000D<00h0300>00`03P0<00h0300J0EP1FP5H0EX1F05J0EP1FP5H0EX1A^A
AQ>aa@06T22@@90PV42H89Q0F_oo001Uool20006>00?J0DKTDHG/LD4V41Hool006?oo`<0000F<00h
0300J0EP1FP5H0EX1F05J0EP1FP5H0EX1F05J0EP1FP5H0EX1F05J0DKTDHH/LD01L91V22H@9PPV400
E_oo001Qool4000FJ0D08J9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[
XT^RJj9;XV^RBj9[XT^jjk[;^^^jb`0C/LD00l91`V72@@04V41Dool0063oo`@0000C601X1F05J0EP
1FP5H0EX1F05J0EP1FP5H0EX1F05J0EP1FP5H0D0185:7J9;2;[;4;7500S2@<91`T32@IPPV42H89Q0
D_oo001Nool40002800?J0D8PDX0:J9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;
XV^RBj9[XT^RJj9;XV^RBj9[XT^jjk[;^^^jbk[[^/^jjk[;^^^jbk[[^//03;7500K2HL91`V72@L9Q
`T44V41@ool005goo`<0000?600P01P0801P1FP5H0EX1F05J0EP1FP5H0EX1F0500b1BQfRBa6jb`Ra
a@0;`T72@<91`T32@L90`T6H89Q0V22H@01>ool005_oo`<000DP00QX1A21BP0bXT^RJj9;XV^RBj9[
XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBk[[^/^jjk[;^^^jbk[[
^/^jjk[;^^^jbk[[^/^jjk[;^^^jbk[[^/^jj`Baa@09`T72HL91`V72@L9Q`T72HL9100>H@00309;o
oooo04[oo`00FOoo0`0000/H0200600P01P0800H06P5H0EX1F0501B1BQfRBaVjb`0>`T72@<91`T32
@L90`T72@<91`T32@IPPV400LT_oo`00F?oo0`001b006H5:04FRBj9[XT^RJj9;XV^RBj9[XT^RJj9;
XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;^^^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;
^^^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;^^^jbm=XddS2HL91`V72@L9Q`T72HL91`V72@IQ00980B_oo
001Gool200002B00600P01P0800H02006018200IPDXMXT/J^//03m=7ddSCAm=8`T32@L90`T72@<91
`T32@L90`T40LP19ool005Koo`03000P020000HP00=821R1BP18Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZ
kZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>`jk3S/>^`hk3[[[;^^^jbk[[^/^j
jk[;^^^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;^^^jbm=XddSCJ==8dfSCB<9Q`T72HL91`V72@L9Q`T72
H@2BB?oo001Eool03B00600P01P0800H0200601824P7B0Q81dP801B1BPB:3QjZcP09`hk3[/>>`jk3
S/>^`hk3[/>>016jb`0AddOCB==7ddSCAm=8ddOCB<90`T72@<91`T32@L90`T6i`017ool005?oo`PP
00I82161BPR:3P1:Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>
Z^jZcZ[^Z/jZkZ[>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S[[[^/^jjk[;^^^jbk[[^/^jjk[;
^^^jbk[[ddSCJ==8dfSCB==XddSCJ==8`V72@L9Q`T72HL91`V6i`4Koo`00Dooo00hP01P0800H0200
601824P7B0Q81dP8B0M824P7385:3HX>7Z[>01;3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3
[/>>`jh9^//04]=8ddOCB==7ddSCAm=8ddOCB==7ddS2@<91`T32@L90`T6i`4Goo`00D_oo1R002DP8
285:4HX>04ZZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>
Z^jZcZ[^Z/k3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^^/^jjk[;
^^_CB==XddSCJ==8dfSCB==XddSCJ==8dfSCB<9Q`T72HL910[W0A?oo001Aool04200600P01P08018
1dP8B0M824P7B0Q81dP8B0M824P7185:5HX>7Z[>02g3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^
`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkCB==7ddSCAm=8ddOCB==7ddSCAm=8ddOCB==7ddS2@<91
`T000[W0@ooo001@ool01000800P020034P86XX>04bZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>
Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/k3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>
`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S]`]ddSCJ==8dfSCB==XddSCJ==8dfSCB==XddSCJ==8
`V72@@:i`4;oo`00Cooo014001P080181dP8B0M824P7B0Q81dP8B0M824P7B0Q81f4=01Z:3QjZcP0^
`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jkL3=`=
g0cCB==7ddSCAm=8ddOCB==7ddSCAm=8ddOCB==7ddP3^L11ool004koo`03000P04P800a820=Q3AZ:
3P1=Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZ
kZ[>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkL
;M`=g2gL3M`]ddSCJ==8dfSCB==XddSCJ==8dfSCB==XddSCJ003^L10ool004goo`0C00181dP8B0M8
24P7B0Q81dP8B0M824P7B0Q81f4=H>aQ3F3/H@d06XX>7Z[>0333S/>^`hk3[/>>`jk3S/>^`hk3[/>>
`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[]`<g0gL3=`=g0cL3M`<ddSCAm=8ddOCB==7
ddSCAm=8ddOCB==7hj83^L0oool004coo`8000]820MQ3AZ:3P1?Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZ
kZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>`jk3S/>^`hk3[/>>`jk3S/>^`hk3
[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkL;M`=g2gL3M`]g0gL;M`=g2gCB==XddSC
J==8dfSCB==XddSCJ>>2hj800kW0?_oo001;ool200004`01B0M824P7B0Q81dP8B0M824P7H@ePk64=
H>aQ3F3/H@ePk64=01J:3PBBdAj[D@K44@0/`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3
S/>^`hk3[/>>`jkL3=`=g0cL3M`<g0gL3=`=g0cL3M`<ddSCAm=8ddOCB==7ddSCAm=8hh7SXP>i`3go
o`00B_oo0P0000<00DP8B0P01TP82V4=4hX>05VBlI;AT_6BdI;aT]6BlI;AZg6[DJ]aZe6[LJ]AZg6[
DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]Aa3744L@aa174<L@Aa374
4L@aa174<L@A`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkL;M`=g2gL3M`]g0gL;M`=g2gL
3M`]g0gL;M=8dfSCB==XddSCJ==8hj;SP^>R00>i`3coo`00BOoo0P0001@00@00B0Q81dP8B0M824P7
B0QPk64=H>aQ3F3/H@ePk64=H>aQ3F3/3hX>39;A7Z]A4L@A02?3[/>>`jk3S/>^`hk3[/>>`jk3S/>^
g0cL3M`<g0gL3=`=g0cL3M`<g0gL3=`=g0cL3M`<ddSCAm=8ddOCB>>1hj;SPN>R00>i`3_oo`00B?oo
0P000P011TP83F4=2hX>06>BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdJ]aZe6[LJ]AZg6[
DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DL@aa174<L@Aa374
4L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa373S/>^`hk3[/>>g2gL3M`]g0gL;M`=g2gL
3M`]g0gL;M`=g2gL3M`]g0gL;M=8dfSCB==Xhh;SX^>2hj800kW0>_oo0017ool200005P0100000DP7
B0Q81dP8H>aQ3F3/H@ePk64=H>aQ3F3/H@ePk64=H>aQ3F3/1hX>59;A7Z]A7<@A01[L3=`=g0cL3M`<
g0gL3=`=g0cL3M`<g0gL3=`=g0cL3M`<g0gL3==8ddOSX^>1hj;SPN>R0kW0>Ooo0017ool010000040
0@010dP84F4=0hX>06fBlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;a
T]6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]a
Ze74<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744Mb`
g93L/=`=g2gL3M`]g0gL;M`=g2gL3M`]g0gL;M`=g2gL3M`]g0gL;N>2hj;SP^>Rhh;SXP02^L0iool0
04Koo`0H00000@00004004P8H>aQ3F3/H@ePk64=H>aQ3F3/H@ePk64=H>aQ3F3/H@ePk64=79;A7Z]A
7<@A01cLT=b`g93L/=b@g0gL3=`=g0cL3M`<g0gL3=`=g0cL3M`<g0gL3=`=g0cL3OB:hj;SPN>Rhh7S
XP:i`3Soo`00AOoo00<0000100400P014V4=0W7@07>BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;A
T_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]A
Zg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DL@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@A
a3744L@aa174<L@Aa3744L@aa174<L@Ag;3LT=b`g93L/=b@g;3L3M`]g0gL;M`=g2gL3M`]g0gL;M`=
g2gL3M`]g0gdZ_B:hj;SP^>Rhh;SXP02^L0gool004Coo`0F00000@0000400001H>aQ3F3/H@ePk64=
H>aQ3F3/H@ePk64=H>aQ3F3/H@d4LM0LT]4NZe4La1407mb@g;3LT=b`g93L/=b@g;3LT=`=g0cL3M`<
g0gL3=`=g0cL3M`<g0gL3=`=m8[dZ_B:hj;SPN>Rhh7SX[W003Ooo`00A?oo1@0100<82F4=H@d0364=
1W7@07JBlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6B
dJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[
DL@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Ag;3L
T=b`g93L/=b@g;3LT=b`g93L/=`=g2gL3M`]g0gL;M`=g2gL3M`]g0gdZ_B:m:[dR^>Rhh;SX^>2hj:i
`3Koo`00@ooo01<00@000040000100T82F3/H@ePk64=H>aQ3F3/H@ePk64=H>aQ3@08LM0LT]4NZe4L
a1408=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g0gL3=`=g0cL3M`<g0gL3=`=m8[dZ_B:m:[dR^>R
hh7SX^>1hj8fool004;oo`D00@<82@YQ3@Yad01gT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;a
T]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]a
Ze6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe74<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@a
a174<L@Aa3744L@aa174<L@Aa3744Mb`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=`=g2gL3M`]
g0gL;M`=g2gdR_BZm8[dZ_B:hj;SP^>Rhh;SXP0eool0047oo`0A0040000100000@0920T02F4=H>aQ
3F3/H@ePk64=H>aQ3@0<LM0HT]44Ve<07[?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdk?c/m>cl`K4DaK44@0Qg93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L
/=b@g;3LT=`=g0cL3M`<g0gL3?BZm8[dZ_B:m:[dR^>Rhh7SX^>103Goo`00@Ooo100110P91f4=3W7@
07RBlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AVg>KDi]cVe>KLi]CVg>KDk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAc
a5?4LlACa7?4DlAca5?4LlACa7?4Dl@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Ag;3LT=b`
g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3L3M`]g0gL;OB:m:[dR_BZm8[dZ_B:hj;SP^>R
hh8dool0047oo`0=0040000100T82@0920T02F4=H>aQ3F3/H@d0477@49;A39]C01jcdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o<Aa5<;a1408]b@
g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=`=g0cdZ_B:m:[dR_BZm8[dZ_B:
hj;SPN>R=?oo0010ool4004520T3H@dBLM00NI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI]cVe>KLi]C
Vg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?Ca7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlAC
a7?4DlAca5?4Ll@Aa3744L@aa17L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@
g;3LT=b`m8[dZ_B:m:[dR_BZm8[dZ_B:hj;SP^>R03?oo`00@?oo00X0000100082@0920T02@P900UQ
3AAad0RBdABKD`0N/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c7<AC02?LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L
/=b@mFkdR_BZm8[dZ_B:m:[dR_BZm8[SX^>103?oo`00?ooo0`011PP95W7@07ZBlI;AT_6BdI]cVe>K
Li]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAca5?4
LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg93L/=b@g;3LT=b`g93L
/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/?E>mFkdR_BZm8[dZ_B:m:[dR_BZm8[SX^>2<_oo000oool0
2@0100082@0920T02@P900T82@0FLM0LVe<07[?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clac4D`0Tg=;Ll]cBg?;Ld]b`g93L/=b@g;3LT=b`g93L
/=b@g;3LT=b`g93L/=b@g;3LT?E^mDkeK_B:m:[dR_BZm8[dZ_B:m:[dR^>R<_oo000oool00`0120T8
2@0520T00c1>LM1ad00BLM00O7ZbNY9j/Y]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>K
Li]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4
LlACa7?4DlAca5?4LlACg?;Ld]cbg=;Ll]cBg?;LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L
/?E>mFkeC_E^m8[dZ_B:m:[dR_BZm8[dZ_B:<_oo000nool02P0020T02@P900T82@0920T`;S1>4W7@
1GZB6i]C01jcdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c
/m>clk?C/o<La5<09McBg?;Ld]cbg=;Ll]cBg?;Ld]b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93e
K_E>mFkeC_E^m8[dZ_B:m:[dR_BZm8[dZ_B:037oo`00?_oo1`P90c1>477@085j/WZBN[9jTWZbNY9j
/Y]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4
LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg=;L
l]cBg?;Ld]cbg=;Ll]b@g;3LT=b`g93L/=b@g;3LT=b`g93L/?E>mFkeC_E^mDkeK_B:m:[dR_BZm8[d
Z_B:m:X0<Ooo000mool02`P900T82@0920T02@P9<2h`CS0^<4h03W7@2GZB6i]C01jcdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o<La5<09]cBg?;L
d]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg;3LT=b`g93L/=b@g;3LT=b`g93eK_E>mFkeC_E^mDkeK_B:m:[d
R_BZm8[dZ_B:g40`ool003goo`H82@D`CPaad026N[9jTWZbNY9j/WZBN[9jTWZbNY9j/Y]CVg>KDi]c
Ve>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAc
a5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg=;Ll]cBg?;Ld]cb
g=;Ll]cBg?;Ld]cbg93L/=b@g;3LT=b`g93L/?E>mFkeC_E^mDkeK_E>mFkdR_BZm8[dZ_B:m:[L@33o
o`00?Ooo00/82@0920T02@P9<2h`CS0^<4h`;S1>00Yad0ejTQ^KD`0N/m>clk?C/o>cdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c7<AC02KLd]cbg=;Ll]cBg?;L
d]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg;3LT=b`g93L/=b@mFkeC_E^mDkeK_E>mFkeC_E^m8[dZ_B:m:[d
R]a0<?oo000mool520T6<4h8LM00RgZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/Y]CVg>KDi]c
Ve>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAc
a5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg=;Ll]cBg?;Ld]cb
g=;Ll]cBg?;Ld]cbg=;Ll]cBg?;LT=b`g93L/?E>mFkeC_E^mDkeK_E>mFkeC_E^m8[dZ_B:m:[dR]aP
02ooo`00??oo00`000P900T82@09<4h`;S1><2h`CS0^<4h6LM0ANY8GVe<01I^DVkBKU9^dVi@07K@D
00K4U<Bda9C4]<BDa;@Fa5<09mcBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;L
d]b`g93eK_E>mFkeC_E^mDkeK_E>mFkeC_E^m8[dZ_B:m:[L@00_ool003coo`@82@P`CPAad02?N[9j
TWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[:KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>K
Di]cVe>KLi]CVg>KU9^dViBK]9^DVkBKU9^dViBK];@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd
5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda5?4LlACa7?4
DlAca5?4LlACa7?4DlAca5?4LlACa7?4Dmcbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;L
d]cbg=;Ll]cBg?;eC_E^mDkeK_E>mFkeC_E^mDkeK_E>mFkdR_BZm8[LH00_ool003coo`0<00T82@09
<4h`;S1><2h`CS0^<4h`;S1>0W7@5GZB3Y]C00jK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D7K@D
0174U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BD00_4D`0Vg=;Ll]cBg?;Ld]cbg=;Ll]cB
g?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld_FbmI;eK_E>mFkeC_E^mDkeK_E>mFkeC_E^m8[dZP;L
@2koo`00>ooo00<000P920T02S1>09Aj/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j
/WZBN[9jTWZbVe>KLi]CVg>KDi]cVe>KLi]CVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK
]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd
=;@Da;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4LlACa7?4DlAca5?L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbmI;e/_FBmFkeC_E^mDke
K_E>mFkeC_E^mDkeK_B:g63L@2koo`00>ooo00h00009<4h`;S1><2h`CS0^<4h`;S1><2h`CTVB5WZB
1I]C01NKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D01fd5012a9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDg?;Ld]cbg=;L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBmK;eT_FbmI;eK_E>mFkeC_E^mDke
K_E>mFkeC_E^0ma0;Ooo000kool00`00<4h`CP09<4h2BI80U7ZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j
/WZBN[9jTWZbNY9j/WZBN[9jTWZbViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK
]9^DVkBKU9^dViBK]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd
=;@D]3Bd5;@d]1Bd=;@Da;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<BdeACE==DDg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbmI;e
/_FBmK;eT_E^mDkeK_E>mFkeC_E^mDkeK_E>mNWL@=aP;Ooo000jool03000<4h`;S1><2h`CS0^<4h`
;S1><2h`CP=9TQEjTP:3500KViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D
VkBKU9^dViBK]9^D01fd5013a9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BD
a;C4U<Bda9C4]<BDeCCE5=DdeACE==cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cB
mK;eT_FbmI;e/_FBmFkeC_E^mDkeK_E>mFkeC_E^mLT00]a0;Ooo000jool00`00<4h`CP08<4h4BI80
TGZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBPcB358<dPaBK]9^DVkBKU9^dViBK
]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd
=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@Da;C4U<Bda9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<BdeACE==DDeCCE5=DdeACLl]cBg?;Ld]cbg=;L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbmI;e/_FBmK;eT_FbmI;eK_E>mFkeC_E^mDkeK_E>00;ej@03g63L
@?oo02_oo`00>_oo00X0031><2h`CS0^<4h`;S1><2h`CPE9TQ5jTPJ3500KViBK]9^DVkBKU9^dViBK
]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D01fd5014a9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDeCCE5=DdeACE==DDeCCE5=Ddg=;L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll_FBmK;eT_FbmI;e/_FBmK;eT_E^mDkeK_E>mFkeC_E^mLWe
j@;L@2coo`00>Ooo0P00231>1TVB095jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY:3=8<DPcB3
58<dPaB3=8<DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBK
U9^d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd
5<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]=DDeCCE
5=DdeACE==DDeCCE5=DdeACLl]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;e/_FBmK;eT_FbmI;e/_FBmK;e
T_E^mDkeK_E>mFkeCP03mNT00ma0ooooo`0Zool003Woo`0900001S1><2h`CS0^<4h`;S1>00Q9TPaj
TP^3500JVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU1fd
5015a9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDeCCE
5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=cbg=;Ll]cBg?;Ld]cbg=;Ll_FBmK;eT_FbmI;e/_FBmK;e
T_FbmI;eK_E>mFkeC_E^mLWejOG900;L@2_oo`00>Ooo00<00007<4h01C1>2DVB091j/WZBN[9jTWZb
NY9j/WZBN[9jTX<dPaB3=8<DPcB358<dPaB3=8<DPcB358<dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^d
ViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK];@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d
]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bd
a9C4]<BDa;C4U<Bda9C4]<BDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==cBg?;Ld]cb
g=;Ll]cBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_FBmFkeC_E^mDh4mNT00maPooooo`0Yool003Soo`80
000600H`CS0^<4h`;S1>2TVB27ZB3h<D01ZK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^d
ViBK]9^DVkBKU9^dViBK]9^D7K@D04O4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4
U<Bda9C4]<BDa;C4U<BdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACLl]cBg?;L
d]cbmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI;eK_E>mFkebOGYmLWejMa002_oo`00>?oo00<00007
00L0131>2dVB091j/WZBN[9jTWZbNY:3=8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<DPcB358<dViBK
]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK];@D]3Bd5;@d]1Bd
=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@da9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDeCCE5=DdeACE==DDeCCE5=DdeACE
==DDeCCE5=DdeACE==DDeCCE5=Ddg=;Ll]cBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_E^mDh4
mNT00maPg43oo`0Yool003Soo`0600001`06<4h`;S1>34VB17ZB4h<D01ZK]9^DVkBKU9^dViBK]9^D
VkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D7;AE04W4mLCEa?G4eLCea=G4]<BDa;C4
U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;CE5=DdeACE==DDeCCE5=DdeACE==DDeCCE
5=DdeACE==DDeCCE5=DdeACE==DDmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI;eK_G9mNWe
bOGYmLWL@00Zool003Soo`0300001`07008`CPe9TP1oN[9jTX<dPaB3=8<DPcB358<dPaB3=8<DPcB3
58<dPaB3=8<DPcB358<dPaB3=8<DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBK
U:@fY1JT=Z@FY3JT5[Ae]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7Fd
EKAe]5FdMLCEa?G4eLCea=G4mLCEa?G4eLCea=G4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4
U=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeC@00^gd00oeT_FbmI;e
/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI801OGY00?L@?ooool0:?oo000hool0100600L01S1>3TVB68<D
00nKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dVi@02j@F6kAE04W4mLCEa?G4eLCea=G4mLCEa?G4
eLCea=G4mLCEa?G4eLBda9C4]<BDa;C4U<Bda9C4]<BDa;CE5=DdeACE==DDeCCE5=DdeACE==DDeCCE
5=DdeACE==DDeCCE5=DdeACE==DDkOC]e>gdmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_j?mNWe
bOGYmLWej@0Zool003Ooo`0400001`0700L>BI80P5YDFWB358<dPaB3=8<DPcB358<dPaB3=8<DPcB3
58<dPaB3=8<DPcB358<dPaB3=8<DVkBKU9^dViBK]9^DVkBKU9^dViBT=Z@FY3JT5Z@fY1JT=Z@FY3JT
5Z@fY1JT=Z@FY3JT5[Ae]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7Fd
EKAe]5FdMLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLBda9C4]<BDa;C4
U=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeC@4kO@03_FBmK;eT_Fb
mI;e/_FBmK;eT_FbmI;e/_FBoZl5mNT00maPooooo`0Wool003Ooo`0500001P0700H03P0<BI83FU@G
Pa@01I^DVkBKU9^dVi@05J@F6kAE04[4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4
mLCEa?G4eLCea=G4mLCEeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE
==DDkOC]e>gdkMC]m?FBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_j?oZoebOGYmLWejOG9:Ooo000gool4
00L00`0>BI99TP09BI80PEYDFWAJE5YdPaB3=8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<DPcB358<d
PaB3=8<DPcB35:@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@f
Y1JdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7G4eLCe
a=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCeeEKEM]EFeCCE5=Dd
eACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5007kO@02oFBmK;eT_FbmI;e/_FBmK;eT_Fb
mI800_j_1OGY:Ooo000gool01@0700H01`0600h02TVB1UYD58<D00>;UX^fRiH06J@F6kAE04[4mLCE
a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEeGKEE]EfeEKEM]DD
eCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE=>gDkOC]e>gdkMC]m>gDkOCeT_FbmI;e/_FB
mK;eT_FbmI;e/_j?oZonSoGYmLWejOG9:Ooo000gool300L200h9BI80PeYDFWAJE5YdFUAJM5YDPcB3
58<dPaB3=8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<DRkJ;UX^fRiJ;]Z@FY3JT5Z@fY1JT=Z@FY3JT
5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@F]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7Fd
EKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4
eLCea=G4mLCEa?G4eLCea=G4mMEFeGKEE]EfeEKEM]EFeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE
5=DdeA@02^gd00Oe/_FBmK;eT_FbmI;e/P04oZl4mNTYool003Koo`0400H01`0600L200h8BI88FU@@
Pa@01h^FRkJ;UX^fRiJ;]X^F01ZT5QZdE@1:a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4
mLCEa?G4eLCea=G4mLCEa?GEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeCCE5=DdeACE==DDeCCE5=DdeACE
==DDeCC]e>gdkMC]m>gDkOC]e>gdkMC]m>gDmK;eT_FbmI;e/_FBoZonSoj_oXon[oG9mNWebBWoo`00
=_oo10070P0>1dVB08AJE5YdFUAJM5YDFWAJE5YdFUAJM8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<D
RkJ;UX^fRiJ;]X^FRkJ;UX^fRiJT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@F
Y3JT5Z@fY1JT=[AE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE
]7G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eMEfeEKEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeACE==DDeCCE5=DdeACE==DDeC@=kO@01OFbmI;e/_FBmK801Oj_0oGY
:Ooo000fool00`0600L01P0400h5BI8;FU@;Pa@038^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]QVT5QZd
E@1:a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?GEE]EfeEKE
M]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKE==DDeCCE5=DdeACE==DDkOC]e>gdkMC]m>gDkOC]e>gdkMC]
m>gDkOC]e?FbmI;e/_FBoZonSoj_oXon[oG9mNWebBWoo`00=_oo0`07100>14VB08IJE5YdFUAJM5YD
FWAJE5YdFUAJM5YDFWB358<dPaB3=8<DPcB358<dPaB;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^F
Y3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JdEKAe]5FdMKAE
]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAea=G4mLCEa?G4eLCea=G4mLCE
a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=GEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEE]EfeEKE==DDeCCE5=Dd3ngd00?e/_FBmK801_j_0_GY:Ooo000fool00`0600L01P0400h3BI8>
FU@6Pa@048^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^f6J@F6[AE04[4mLCEa?G4eLCea=G4
mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=GEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKE
M]EFeGKEE]EfeEKEM]EFeGKE5=DdeAC]m>gDkOC]e>gdkMC]m>gDkOC]e>gdkMC]m>gDkOC]e?FbmI;n
[oj?oZonSoj_oXoejOG9:Ooo000fool200L500h2BI80QeYDFWAJE5YdFUAJM5YDFWAJE5YdFUAJM5YD
FWAJE8<dPaB3=8<DRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJT5Z@fY1JT=Z@F
Y3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JdEKAe]5FdMKAE]7FdEKAe]5FdMKAE
]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCE
a?G4eLCea=G4mLCEa?G4eLCeeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEEP0BkO@8oZl00oGYooooo`0Wool003Koo`0300H01`0>00@03P03BI9JE5YD00iJE0:3500ERiJ;
]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^F01RT5QZdE@1:a?G4eLCea=G4mLCE
a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeEKEM^HFiSK]e>gdkMC]m>gDkOC]e>gdkMC]m>gDkOC]e>gdkMC]m?kc
oZonSoj_oXon[oj?oZoebBWoo`00=_oo0P071@0>08UJE5YdFUAJM5YDFWAJE5YdFUAJM5YDFWAJE5Yd
FUAJM5YDRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]Z@FY3JT5Z@f
Y1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=[AE]7FdEKAe]5FdMKAE]7FdEKAe
]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCe
a=G4mLCEa?G4eLCea=G4mLCEa?GEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]Ef
eEKEM]EF00?V=Po]m003o_?n[oj_00Kn[bWoo`00=_oo00<01P0>00h0100>00<@deYDFU@03EYD01Q[
5V<FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiHDY1H5Y5L0F[BG];Nd
UkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]lDGaCO55lDgaAO5=lCEa?G4
eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mMEFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKE
E]EfeEKEM]EFeGKEE]EfeEKV=^HFiSKV5^HfkMC]m>gDkOC]e>gdkMC]m>gDkOC]e>gdkMC]m0;nl`07
oXon[oj?oZonSoj_oXl0:Ooo000fool00`0700h03P0400h0R13CFWAJE5YdFUAJM5YDFWAJE5YdFUAJ
M5YDFWAJE6/fJaI[=X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJT
=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY7NTEjAgY5NTMjAGY7NTEjAgY5Nd]kBG];NdUkBg]9Nd
]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9O5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO4
mLCEa?G4eLCea=G4mLCEa?G4eLCea=GEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKE
M]EFeGKEE]Ef1^Hf3>gd0okc1oj_:Ooo000fool00`0600h03P0300h00`Rc4==JE00<FU@06f/FHaI[
5V<FJaJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]P0:Y1H>Y5L0FKBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGaCO55lDgaAO5=lCEa?G4eLCea=G4mMEFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeEKV=^HFiSKV5^HfiQKV=^gDkOC]e>gdkMC]m>gDkOC]e>gdkM@01?kc
00Kn[oj?oZonSoj_oXlYool003Koo`H03P<@d`25FUAJM5YDFWAJE5YdFUAJM5YDFWAJE6/fJaI[=V/F
JcI[5X^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FY3JT5Z@fY1JT=ZAG
Y7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=mEFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEH02NHf
2^gd1?kc1_j_:Ooo000gool500h00`Rc4=<8/`0:FU@07F/FHaI[5V<FJaIS5V/FRiJ;]X^FRkJ;UX^f
RiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkH06:AG05RdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGeKOEUmFgeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM^HF
iSKV5^HfiQKV=^HFiSKV5^HfkMC]m>gDkOC]e>gdkMC]m0Knl`05oXon[oj?oZonS`0Yool003Ooo`@0
3P@@d`25FUAJM5YDFWAJE5YdFUAJM5YDJcI[5V/fJaI[=V/FJcI[5V/fRiJ;]X^FRkJ;UX^fRiJ;]X^F
RkJ;UX^fRiJ;]X^FRkJ;UX^fRiJCmi?GToNTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAG
Y7NTEjAgY5NTMjAG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
aCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=mFGeKOEUmFgeIOEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEH02nHf1ngd1_kc1Oj_:Ooo000gool400h01A3C
2;<@d`Rc4=<01eYD021[5V<FJaIS5V/FHaI[5V<FJaIS5X^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^f
RiJ;]X^FRkJCei?gTmNCmi?G5jAG05RdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];Nd
UkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeKOE
UmFgeIOE]mFGeKOEUmEfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKV=^HFiSKV5^HfiQKV=^HFiSKV
5^HfiQKV=^gDkOC]e>gdkMC]m0Onl`04oZonSoj_oXlYool003Ooo`@03PD@d`23FWAJE5YdFUAJM5YD
JcI[5V/fJaI[=V/FJcI[5V/fJaI[=X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UY?gTmNCmi?G
ToNCei?gY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEkBg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mEFeGKEE]EfeEKEM]EF
eGKEE]EfeEKEMP0>iSH4kO@8o_<3oZlZool003Ooo`<03P062;<@d`Rc4=<8/a3C1EYD02=[5V<FJaIS
5V/FHaI[5V<FJaIS5V/FHaI[5X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]Y?GToNCei?gTmNCmi?GToNC
ei?g01NTE`1F];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9O5=lDGaCO5
5lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgeIOE]mFGeKOEUmFgeIOE]mFGeKOE
UmFgeIOE]mEFeGKEE]EfeEKEM]EFeGKEE^HfiQKV=^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=^gDkOC]
e0Wnl`03oXon[ooo02Woo`00>?oo0P0>1a3C085JE5YdFUA[=V/FJcI[5V/fJaI[=V/FJcI[5V/fJaI[
=V/FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJCmi?GToNCei?gTmNCmi?GToNCei?gTmNTMjAGY7NTEjAgY5NT
MjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd
]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5
=lDGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOEM]EFeGKEE]EfeEH04NHf0^gd2Okc0_j_
:_oo000hool200h01`Rc4=<8/a3C2;<@d`Rc009JE00UJaIS5V/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS
5V/FRiJ;]X^FRkJ;UX^fRiJ;]Y?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToL05jAG05Fd]kBG];Nd
UkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUlDgaAO5=lDGaCO55lDgaAO5=lDGaCO5
5lDgaAO5=lDGaCO55lDgaAO5=lDGaCOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOE
UmEfeEKEM^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=P0;o_<00oj_ooooo`0Xool0
03Soo`0300h@da3C00H@d`20FUA[=V/FJcI[5V/fJaI[=V/FJcI[5V/fJaI[=V/FJcI[5V/fRiJ;]X^F
RkJ;UY?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAG
Y7NTEjAgY5NTMjAGY7NTEjAgY5NTMkBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
];NdUkBgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCOEUmFgeIOE]mFG
eKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]a?V=P03m_Knlokc00Snl`03oZoooooo02So
o`00>?oo03403Q3C2;<@d`Rc4=<8/a3C2;=[5V<FJaIS5V/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS5V/F
HaJ;]X^FRkJCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCe`0FY5L0E;Bg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGaCO55lDgaAOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFG
eKOEUmhhgQSV=^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=^HFiSKV5P;fmP[nlb_oo`00>?oo00<03Q3C
4=<01Q3C07lb5V/fJaI[=V/FJcI[5V/fJaI[=V/FJcI[5V/fJaI[=V/FJcJCei?gTmNCmi?GToNCei?g
TmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAg
Y5NTMjAGY7NTEjAg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDg
aAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=mFGeKOEUmFgeIOE]mFGeKOEUmFg
eIOE]mFGeKOEUmFgeIOE]mFGeKOEU`04gSP?iSH3m_H9o_<[ool003Soo`0a2;<@d`Rc4=<8/a3C2;<@
d`Rc<QIS5V/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS5V/FHaI[5W>HLkRCei?gTmNCmi?GToNCei?gTmNC
mi?GToNCei?gTmNCmi?GToNCei?gTmL05ZAG05>d]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];Nd
UkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeKOE
UmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFggQSN>=hHgSSN6>HfiQKV=^HFiSKV
5^HfiQKV=^HFiSKV5^Hf00CfmPWnlb_oo`00>Ooo1a3C0c8F07a[5V/fJaI[=V/FJcI[5V/fJaI[=V/F
JcI[5V/fLiQc^7>HLkRCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gY5NTMjAG
Y7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7Ndf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH
]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=RmN;eH_GRmF;eh_ES5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55mFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]`ON>0cV=PGfmPOnl`03
gbkooooo02Woo`00>Ooo00L@d`Rc4=<8/a3C2;<@d`03<QH09f/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS
5V/FLiQc^7>HLkQcV9?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCm`0@Y5L0
EjBHY;RTV:BhY9RT^;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?RmF;eh_ERm
N;eH_GRmF;eh_ERmN;eHaCO55lDgaAO5=lDGaCO55lDgaAO5=mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE
]mFGeKOEUmFgeIOE]mFGeKOEUmhhgQSN>=hHgSSN6=hhgQSV=^HFiSKV5^HfiQKV=^HFiSKV5P06m_H7
o_<00ml^ooooo`0Yool003Woo`0300`@da3C00@@d`@b5P1jJcI[5V/fJaI[=V/FJcI[5V/fJaI[=W>H
LkQcV7>hLiQc^7>HToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCejAgY5NTMjAG
Y7NTEjAgY5NTMjAGY7NTV:BhY9RT^:BHY;RTV:BhY9RT^:BH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH
]?Rdf;Ch]=Rdn;CH]?Rdf;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eHaCO55lDgaAO5=lDG
eKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEU`_N>0SV=POfmPGnl`03gbkooooo
02[oo`00>Ooo00H030Rc4=<8/a3C2;<5<QH09V<FJaIS5V/FHaI[5V<FJaIS5V/FLiQc^7>HLkQcV7>h
LiQc^9?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToL6Y5L0H:BHY;RTV:BhY9RT
^:BHY;RTV:BhY9RT^:BHY;RTV:Bh]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rd
n;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF=FgeIOE]mFGeKOEUmFgeIOE
]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mhHgSSN6=hhgQSN>=hHgSSN6=hhgQSN>>HFiSKV5^HfiQKV
=PSfmPGnl`03gbkooooo02[oo`00>Ooo00<0313C4=<00a3C1S8F07Q[5V/fJaI[=V/FJcI[5V/fLiQc
^7>HLkQcV7>hLiQc^7>HLkRCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCejBhY9RT
^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rd
n;CH]?Rdf;Ch]=Rdn;CH]?Rdf;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERm
N<fHcKS=V=FgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKL>gSP5iSH9m_H3o_<2gbh/ool0
03[oo`0400`@d`Rc4=<7<QH08f/FHaI[5V<FJaIS5V/FLiQc^7>HLkQcV7>hLiQc^7>HLkQcV9?gTmNC
mi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToL00iAH06BT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT
^:BHY;RTV:BhY9RT^:BHY;Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch_ERm
N;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eHcKS=V<fhcIS=^=FGeKOEUmFgeIOE
]mFGeKOEUmFgeIOE]mFGeKOEUmhhgQSN>=hHgSSN6=hhgQSN>=hHgSSN6=hhgQSN>>HFiSKV5P[fmP?n
l`;O;Rcoo`00>_oo00@0313C4=<@d`Pb5P1fJcI[5V/fJaI[=W>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc
^7>HToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCeiAhU5RDN9AHU7RTV:BhY9RT^:BHY;RTV:BhY9RT
^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rd
n;CH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=
^=FGeKOEUmFgeIOE]mFGeKOEUmFgeILAgSP2iSH;m_H01?kcgbkO;]l^;?oo000jool0100<4=<8/a3C
238F01iS5V/FHaI[5W>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkRCei?gTmNCmi?GToNCei?gTmNC
mi?GToL8U5P0HZBHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;Rdf;Ch]=Rdn;CH
]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH
_GRmF;eh_ERmN<fHcKS=V<fhcIS=^<fHcKS=V<fhcISE]mFGeKOEUmFgeIOE]mFGeKON6=hhgQSN>=hH
gSSN6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSP<m_H00okcgbkO;P0]ool003[oo`8030034=<b5S8F00Pb
5P1dJaI[=W>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hTmNCmi?GToNCei?gTmNCmiAHU7RD
F9AhU5RDN9AHU7RDF9AhU5RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;Rd
f;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRm
F;eh_ERmN;eH_GRmF;eh_ES=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHeKOEUmFgeIOE]a?N>003
kcSfm_Kf00WfmP?O;Rgoo`00>_oo0P0<00<8/c8F<QH0238F01Qc^7>HLkQcV7>hLiQc^7>HLkQcV7>h
LiQc^7>HLkQcV7>hLiRCmi?GToNCei?gTmL>U5P0H:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT
^:BHY;RTV:BhY9Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;eH_GRmF;eh_ERm
N;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=
^=FGeKOEUmhhgQSN>=hHgSSN6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSSN60;_>0_fmP?O;Rgoo`00>ooo
00<0338F<QH02C8F02];67>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV9?gTmNCmiAH
U7RDF9AhU5RDN9AHU7RDF9AhU5RDN9AHU7RDF9AhY9RT^:BHY;RTV00:0000?ZBhY9RT^:BHY;Rdf;Ch
]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh
_ERmN;eH_GRmF;ehcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIPBgSP4kcP9m_H0
1>ndgbkO;]l^;Ooo000kool200`:<QH2BaP04G>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^7>H
LkP04iAH1`0000FTV:BhY9RT^:BH00P0001;]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rd
n;CH]?RmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=
^<fHcKS=V<fhcIS=^<fHcKS=V<fheUWFNMhHgSSN6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSSN6=hh00C_
>0WfmP04kkCO;]l^gbh]ool003_oo`80300305<b5S8F00Hb5P0TBcQ;64/hBaQc^7>HLkQcV7>hLiQc
^7>HLkQcV7>hLiQc^7>HLkQl6G`iU5RDN9AHU7RDF9AhU5RDN9AHU7RDF9AhU5RDN9AH100001:T^:BH
Y;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9P50000=;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rd
n;CH]?Rdf;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=
^<fHcKS=V<fhcIS=^<fHcKS=V<fh1=Ii3]hh1^lh1oKf0^nd0]l^;_oo000kool200`00`1C<QHb5P06
<QH4BaP03W>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkP4O1T=U5P30002U5P05ZBHY;RTV:BhY9RT
^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BH]?Rdf;Ch1@00046dn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch
_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;ehcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fh
cIS=^<fHcKS=V<fheUWFNMIIeWWFFMIigQSN>=hHgSSN6=hhgQSN>=hHgSSN6=hh00O_>0OfmP;_]0;O
;Rkoo`00>ooo0P0<0P1C1c8F029;>4/HBcQ;64/hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hO1Ul>G`I
O3Ul6IAhU5RDN9AHU7RDF9AhU5RDN9AHU7RDF080000MU7RDF9AhU5RDN:BHY;RTV:BhY9RT^:BHY;RT
V:BhY9RT^:BHY;RTV:BhY9RT^;CH]?Rdf;Ch]=Rdn0040000;KCH]?Rdf;Ch]=Rdn;CH]?RmF;eh_ERm
N;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=
^<fHcKS=V008eWT:gSP8kcP5m_H3kk@2gbh^ool003coo`80300303<0Dc8F00@b5PM;600:LiQc^7>H
LkQcV7>hLiQc^7>HLkP7O1T9U5P30006U5P07:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RTnJCI
Y?VTfJCi]AVe>KDI]CVe6KDi]AVe>KDI0`0003^e6KDi]AVe>KDI_KVmVKfi_IVm^KfI_GRmF;eh_ERm
N;eH_GRmF;eh_ERmN;eHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHeWWFFMIieUWF
NMIIeWWFFMIieUWN>=hHgSSN6=hhgQSN>=hH00W_>0GfmP;_]0;O;Rooo`00??oo0P0<0P1C1C8F021;
64/hBaQ;>4/HBcQ;64/hLiQc^7>HLkQcV7>hLiQl>G`IO3Ul6G`iO1Ul>G`IO3Ul6IAhU5RDN9AHU7RD
F9Ah0P0002JDF9AhU5RDN9AHU7RDF9AhU5RT^:BHY;RTV:BhY9RT^:BHY;RTfJCiY=VTnJCIY?VTfJCi
Y=Ve>KDI]CVe6KDi]AVe>KDI]CVe6KDi0`0002Je>KDI]CVmVKfi_IVm^KfI_KVmVKfi_IVm^KfI_KVm
F;eh_ERmN;eH_GS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fH3=Ii1]hh2nlh0oKf0nnd
0]l^;ooo000mool0100<03<0D`0c138F24/H00Ic^7>HLkQcV7>hLiP;O1T6U5P2000:U5P07jBHY;RT
V:BhY9RTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnKDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI00<0
000f]AVm^KfI_KVmVKfi_IVm^KfI_KVmVKfi_IVm^KfI_KVmVKficIS=^<fHcKS=V<fhcIS=^<fHcKS=
V<fhcIS=^<fHcKS=V<fheUWFNMIIeWWFFMIieUWFNMIIeWWFFMIieUWFNMhHgSSN6=hh2nlh0oKf0nnd
00?O;_ooool0;_oo000mool00`0<05<0D`0205<2<QH0CT/hBaQ;>4/HBcQ;64/hBaQ;>4/HLkQcV7>h
LiQl>G`IO3Ul6G`iO1Ul>G`IO3Ul6G`iO1Ul>IAHU7RDF9Ah002DN9AHU7RDF9AhU5RDN9AHU7RDF9Ah
U5RTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=Ve>KDI]CVe6KDi]AVe>KDI]CVe6KDi
]AVe>KDI]CVe6@80000@_KVmVKfi_IVm^KfI_KVmVKfi_IVm^KfI_KVmVKfi_IT3aOX03/fHcKS=V<fh
cIS=^<fHcKS=V<fhcIS=^<fHcKP@eWT2gSP=kcP00oKfkkC_]002kk@00ml^ooooo`0^ool003goo`05
00`0<`1C03<0D`02<QH;BaP00g>hLiQl6@0>O1T2U5P2000:U5P09YbJW;ZLVZCiY=VTnJCIY?VTfJCi
Y=VTnJCIY?VTfJCiY=VTnJCIY?Ve6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI_KT20000
<;fI_KVmVKfi_IVm^KfI_KVmVKfi_IVm^KfI_KW5f/GjaM[5n/GJaO[=V<fhcIS=^<fHcKS=V<fhcIS=
^=IIeWWFFMIieUWFNMIIeWWFFMIieUWFNMIIeWWFFMIieUWFN@k_>0G_]003gbkooooo02koo`00?_oo
00<0301C05<00P1C01hb5T/hBaQ;>4/HBcQ;64/hBaQ;>4/HBcQl6G`iO1Ul>G`IO3Ul6G`iO1Ul>G`I
O3Ul6G`iO1Ul>G`IU7P20000<YAHU7RDF9AhU5RDN9AHU7RLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?VT
fJCiY=VTnJCIY?VTfJCiY=VTnJCI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KfI_KT3
00002kfi_IVm^KfI_KVmVKfi_IVm^KfI_KT02/Gj00O=V<fhcIS=^<fHcKS=V00BeWT00nKjkcS_>00;
kcP5kk@aool003koo`0500`0D`0c05<0<`0<BaP00e_jO1Ul6@0?O1T00`00U5RDF004U5P0;ibJW;ZL
VYbjW9ZL^YbJW;ZLVYbjY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?Ve6KDi]AVe>KDI]CVe
6KDi]AVe>KDI]CVe6KDi]AVe>KfI_KVmVKfi_IT00`0002^mVKfi_IVm^KfI_KVmVKfi_IW5n/GJaO[5
f/GjaM[5n/GJaO[5f/GjaM[5n/fHcKS=V=IieUWFNMIIeWWFFMIieUWFNMIIeWWFFMIieUWFNMIIeWWF
F@02i_X<kcP00nohkkC_]003kk@aool003ooo`D0D`1EBcQ;64/hBaQ;>4/HBcQ;64/hBaQ;>5_JFoYl
6G`iO1Ul>G`IO3Ul6G`iO1Ul>G`IO3Ul6G`iO1T007`IU7RDF9AhW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZL
VYbjW9ZTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCi]AVe>KDI]CVe6KDi]AVe>KDI]CVe
6KDi]AVe>KDI_KVmVKfi_IVm^KfI_KT00`0000Jm^KfI_KVmVKfi_IT@aOXBeWT4i_X:kcP2koP4kk@b
ool003ooo`0605<0<`1C03<0D`8H2D/H00AKfU_jFmYKnPel6@80000jO1VLVYbjW9ZL^YbJW;ZLVYbj
W9ZL^YbJW;ZLVYbjW9ZL^YbJY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=Ve>KDI]CVe6KDi
]AVe>KDI]CVe6KDi]AVe>KDI]CVmVKfi_IVm^KfI_KVmVKfi_IT200009[fi_IVm^KfI_KW5f/GjaM[5
n/GJaO[5f/GjaM[5n/GJaO[5f/GjaM[5n/iJcW[FFMIieUWFNMIIeWWFFMIieUWFNMIIeWWFFMIieUT5
i_X9kcP3koP4kk@bool003ooo`D0D`82601GBcQ;64/hBaQ;>4/HBcQ;65_jFmYKnU_JFoYl6G`iO1Ul
>G`IO3Ul6G`iO1Ul>G`IO3T007`iQ9Z4^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjY=VT
nJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?Ve6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVm
^KfI_KVmVKfi_IVm^KfI_KVmVKfi00800003_IVm^LGj00o5nPC>NPgFN@OVnPO_>0C_n0?_]3?oo`00
@?oo00@0<`1C03<0D`<260M;6006FmYKnU_JFoYKfU_j2W`I0P0003j4VXBjQ9Z4^YbJW;ZLVYbjW9ZL
^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCI]CVe6KDi]AVe
>KDI]CVe6KDi]AVe>KDI]CVe6KDi_IVm^KfI_KVmVKfi_IVm^KfI_KVmVKfi0P00026mVLGjaM[5n/GJ
aO[5f/GjaM[5n/GJaO[5f/GjaM[5n/iJcW[>F/ijcU[>N]IIeWWFFMIieUWFNMIIeWWFFMIieUT02>Kj
1^lh1>oh0nnd=?oo0011ool305<30QP0FD/HBcQ;64/hBaQ;>5_JFoYKfU_jFmYKnU_JFoYl6G`iO1Ul
>G`IO3Ul6G`iO1T008BJQ;Z4VXBjQ9Z4^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVZCiY=VT
nJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnKDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6Kfi_IVm
^KfI_KVmVKfi_IVm^KfI_KVmVKfi_IT00P003LGj2<ij2MIi2^Kj1>lh1Noh0nnd=?oo0011ool00`1C
03<0D`040QP5BaP02E_jFmYKnU_JFoYKfU_jFmYKnP07O1T20000H8BjQ9Z4^XBJQ;Z4VXBjW9ZL^YbJ
W;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfKDi]AVe>KDI
]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KfI_KVmVKfi_IVm^KfI_KVmVKfi_IVm^KfI_KW5f/Gj0035n/GJ
aO[5f/GjaM[5n/GJaO[5f/GjaM[>N/iJcW[>F/ijcU[>N/iJcW[>F]IieUWFNMIIeWWFF@_VnP?_>0K_
n0;_]3Goo`00@_oo0`1C108H01A;64/hBaQ;>5_JFoYKfU_jFmYKnU_JFoYKfU_jO1Ul>G`IO3Ul6G`i
0P000424VXBjQ9Z4^XBJQ;Z4VXBjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^ZCIY?VTfJCiY=VT
nJCIY?VTfJCiY=VTnJCIY?Ve6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi_IVm^KfI_KVmVKfi_IVm
^KfI_KVmVKfi_IVm^@C5nP8000W5nPc>NPCFN@gVnP03kcS_n>oh00G_n003kkCooooo03Coo`00@ooo
00<0D`0c0QP0108H0T/H00aKfU_jFmYKnU_JFoYKfU_jFmYKnU_JFoX4O1T0B8BJ0024VXBjQ9Z4^XBJ
Q;Z4VXBjQ9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?VTfJEjYEZUNZEJ
YGZUFZEj]EZeN[EJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZm^[fJ_KZmV[fj_IZm^[fI_KVmVKfi_IVm^KfI
aO[5f/GjaM[5nP80000GaM[5n/GJaO[5f/GjaM[>N/iJcW[>F/ijcU[>N/iJcW[>F/ijcU[>N/iJeWWF
F@0>i_X8koP00nndooooo`0dool004?oo`80D`H2601CBaQKnU_JFoYKfU_jFmYKnU_JFoYKfU_jFmYK
nW`IO3V4VXBj0024^XBJQ;Z4VXBjQ9Z4^XBJQ;Z4VYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZU
NZEJYGZUFZEjYEZUNZEJYGZUFZEjYEZUNZEJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[EJ]GZmV[fj_IZm
^[fJ_KZmV[fj_IZm^[fJ_KZmVP07aOX20005aOX@cWX>i_X00nNkkoS_n006koPgool004Coo`0303<2
608H00@2601LFoYKfU_jFmYKnU_JFoYKfU_jFmYKnU_JFoYKfXBjQ9Z4^XBJ0024VXBjQ9Z4^XBJQ;Z4
VXBjQ9Z4^XBJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YdKWC^M6jEjYEZUNZEJYGZUFZEjYEZUNZEJYGZU
FZEj]EZeN[EJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZm^[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_IZm^[hK_S^n
6lGjaM[5n/GJaO[5fP80000BaO[5f/GjcU[>N/iJcW[>F/ijcU[>N/iJcW[>F/ijcU[>N/iJ0]Kk3>Kj
0^Nk1noh>?oo0015ool70QP0DB]kFmYKnU_JFoYKfU_jFmYKnU_JFoYKfU_jM5]dNhBJQ;X008BjQ9Z4
^XBJQ;Z4VXBjQ9Z4^XBJQ;Z4VYbjW9ZL^YbJW;ZLVYbjW9ZM>idKWC^M6idkWA^UNZEJYGZUFZEjYEZU
NZEJYGZUFZEjYEZeN[EJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_IZm
^P07_S/4aOX200000lGjcW[>NP0=cWX4e_/:i_X3ik/7koPhool004Goo`L2608[F`0;FmYKnU_JFoYK
fU_jFmYKnU_JFoYKfP03M5/20000BhBJQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9Z4^XBJW;ZLVYbjW9ZL^YdK
WC^M6idkWA^M>idKWC^UFZEjYEZUNZEJYGZUFZEjYEZUNZEJYGZUF[Ej]EZeN[EJ]GZeF[Ej]EZeN[EJ
]GZeF[fj_IZm^[fJ_KZmV[fj_IZm^[fJ_KZmV[hk_Q^n>khK_S^n6khk_Q^n>khKaO[5fP0200003/ij
cU[>N/iJcW[>F/ijcU[>N/iJcW[>F/ijcUX5e_/9i_X4ik/6koPiool004Koo`H2601@:g/[Fb]kFmYK
nU_JFoYKfU_jFmYKnU_JM7]dFgAkM5/008BJQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9Z4^XBJQ;Z4VYbjW9ZM
>idKWC^M6idkWA^M>idKWC^M6idkYEZUNZEJYGZUFZEjYEZUNZEJYGZUFZEj]EZeN[EJ]GZeF[Ej]EZe
N[EJ]GZeF[fj_IZm^[fJ_KZmV[fj_IZm^[fJ_KZmVPfn>`;>NP03003>N/ij00[>NPOFn`OVnPGW^`G_
n3[oo`00Aooo1@8H12]K00QKfU_jFmYKnU_JFoYKfU_j17AK05/007AKQ9Z4^XBJQ;Z4VXBjQ9Z4^XBJ
Q;Z4VXBjQ9Z4^YdKWC^M6idkWA^M>idKWC^M6idkWA^M>idKYGZUFZEjYEZUNZEJYGZUFZEjYEZUNZEJ
]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_IZm^[hK_S^n6khk_Q^n>khK
_S^n6khk_Q^n>lIKaW_6Flij003>N/iJcW[>F/ijcU[>N/iJcW[>FP09e_/5i_X6ik/4koP00jmcoooo
o`0hool004Soo`@2601?:g/[Fb]k:e/[Nb]KFoYKfU_jFmYKnU_JM7]dFgAkM5/007AKM7^4VXBjQ9Z4
^XBJQ;Z4VXBjQ9Z4^XBJQ;Z=6hdkWA^M>idKWC^M6idkWA^M>idKWC^M6idkWA^UNZEJYGZUFZEjYEZU
NZEJYGZUFZEj]EZeN[EJ]GZeF[Ej]EZeN[EJ]GZeF[fj_IZm^[fJ_KZmV[fj_IZm^[fJ_KX03;hk1LIk
00?>NP00cWX01lij2]Kk1>Kj1nNk0noh00>_Loooool0>Ooo0019ool40QP6:e/015_jFmYKnU_J1GAK
00<007AKM5/00WAK05B4^XBJQ;Z4VXBjQ9Z4^XBJQ;Z=6hdkSA^=>idKWC^M6idkWA^M>idKWC^M6idk
WA^M>idKYGZUFZEjYEZUNZEJYGZUFZEjYEZUN[EJ]GZeF[Ej]EZeN[EJ]GZeF[Ej_IZm^[fJ_KZmV[fj
_IZm^[fJ_KZmV[hk_Q^n>khK_S^n6khk_Q^n>khK_S_6FlIkaU_6NlIKaW_6Flij003>N/iJcW[>F/ij
cUX<e_/2i_X8ik/2koP00jmcooooo`0jool004[oo`<2601=:e/[Nb]K:g/[Fb]k:e]KnU_JFoYdFgAk
M5]dNgAK001dFgAkM5]dNgAKQ;Z4VXBjQ9Z4^XBJQ;Z=6hdkSA^=>hdKSC^M6idkWA^M>idKWC^M6idk
WA^M>idKWC^UFZEjYEZUNZEJYGZUFZEjYEZUNZEJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZm^[fJ_KZmV[fj
_IZm^[fJ_KZmVP0;_S/:aW/00`00cW[>NP02cWX=e_/:ik/00noh[g?oo`0lool004[oo`030382608H
00P[F`03FoYKfWAK00AdF`8000EdF`1=Q;Z4VXBjQ9Z4^XdKSC^=6hdkSA^=>hdKSC^M6idkWA^M>idK
WC^M6idkWA^M>idKWC^UFZEjYEZUNZEJYGZUFZEjYEZUN[EJ]GZeF[Ej]EZeN[EJ]GZeF[Ej_IZm^[fJ
_KZmV[fj_IZm^[fJ_KZn6khk_Q^n>khK_S^n6khk_Q^n>lIKaW_6FlIkaU_6NlIKaW_6FlIkaU_6N`02
00000liJe__Fn`0;e_/00mMlik_W^`08ik/2[g<mool004_oo`0A058262]K:g/[Fb]k:e/[Nb]K:g/[
FgAkM5]dNgAKM7]dF`020000>gAkM5]dNgAKM7]dFhBjQ9Z4^XdKSC^=6hdkSA^=>hdKSC^=6hdkWA^M
>idKWC^M6idkWA^M>idKWC^M6jEjYEZUNZEJYGZUFZEjYEZUNZEJ]GZeF[Ej]EZeN[EJ]GZeF[Ej_IZm
^[fJ_KZmV[fj_IZm^[fJ_KX02[hk3/Ik00<00=Kke_/02]Kk0mMl2NNk0Zmc?_oo001<ool00`0b:e/[
F`08:e/00e@LM5]dF`02M5/20007M5/0BhdkSA^=>hdKSC^=6hdkSA^=>hdKSC^=6hdkWA^M>idKWC^M
6idkWA^M>idKWC^M6jEjYEZUNZEJYGZUW:FlYIbU_:FL[Ob]g:gl[Mb]o:gL[Ob]g;Gl]Mbeo;GL]Obe
g;Gl]Mbeo;hK_S^n6khk_Q^n>khK_S^n6khkaU_6NlIKaW_6FlIkaU_6NlIKaW_6FlIkaU_6N`02c_`0
0`00e__Fn`08e_/4eg`8ik/00koi[g?oo`0nool004goo`0j0582NB]K:g/[Fb]k:e/[Nb]K:g]D75@l
E1adNgAKM7/007AkM5]dNgAKM7]dFgAkO=alo8dKSC^=6hdkSA^=>hdKSC^=6hdkSA^=>idKWC^M6idk
WA^M>idKWC^M6idkYIbU_:FLYKbUW:FlYIbU_:FLYK`8[O`9]O`3]S`6_S/=aW/5c_`00`00e__Fn`05
e_/6eg`7ik/00koi[g?oo`0oool004koo`030382FB]K00H[F`ED7003M5/007AK00EdF`19O=alo7cL
O?alg8dkSA^=>hdKSC^=6hdkSA^=>hdKSC^M6idkWA^M>idKWC^M6iflWIbM_:FLYKbUW:FlYIbU_:FL
YKbUW:gl[Mb]o:gL[Ob]g:gl[Mbeo;GL]Obeg;Gl]Mbeo;GL]Sbf7;Hl]Qbf?;HL_S^n6khkaU_6NlIK
aW_6FlIkaU_6NlIKaW_6FlIkaU/01/kl0P001MKk1mMl1NNk0[oi00>_Loooool0?ooo001>ool20580
>09i0UT[Nb]K:g/[Fb]kE1aD?5@LE3aD75@l001dNgAKM7]dFgAkM5]lo7cLO?alg7clO=alo8dKSC^=
6hdkSA^=>hdKSC^=6hdkWA^M>idKWC^MW9flWIbM_9fLWKbUW:FlYIbU_:FLYKbUW:FlYI`7[O`8]O`8
]S`<aW/9c_`20002e_/9eg`4ik/2_oT00jmcooooo`10ool004ooo`040580<P9I0UT4:e/6E1`20004
M5/0AgclO=alo7cLO?alg7clO=alo8dKSC^=6hdkSA^=>hdKSC^=6hdkWIbM_9fLWKbMW9flWIbM_9fL
WKbUW:FlYIbU_:FLYKbUW:Fl[Mb]o:gL[Ob]g:gl]Mbeo;GL]Obeg;Gl]Mbeo;HL]Sbf7;Hl]Qbf?;HL
]SbnGKim_Ug6NlIKaW_6FlIkaU_6NlIKaW/02lkl0P002]Ml0^Nk1;oi@ooo001@ool0>01B0UT2N@9I
0WT[Fb]kE1aD?5@LE3aD75@lE1`005@LE3adFgAkO=alo7cLO?alg7clO=alo7cLO?alg8dkSA^=>hdK
SC^=6hdkUEfEOIEMWKbMW9flWIbM_9fLWKbMW9flYIbU_:FLYKbUW:FlYI`6[O`7]O`8]S`5_Wd6aW/=
c_`00mMl003GO009eg`00nNk_oVon@02_oU4ool0057oo`030582F@9I0082F@03:e]D75@L00ED7019
001D75@LE1alg7clO=alo7cLO?alg7clO=alo7cLO?alg7clSA^=>hdKUGfEGIEmUEfEOIEMWKbMW9fl
WIbM_9fLWKbMW:FlYIbU_:FLYKbUW:FlYIb]o:gL[Ob]g:gl]Mbeo;GL]Obeg;Gl]Mbf?;HL]Sbf7;Hl
]Qbf?;iM_WfnGKim_UfnOKiM_Wg6FlIkaU/03<kl0/Lm00?GO000eg`02=Ml1KoiAOoo001Bool0=`1B
0UT2N@9I0WUD75@lE1aD?5@LE3aD75@l001D?5@LE3a/gFcmO=alo7cLO?alg7clO=alo7cLO?alg7cl
UEfEOIEMUGfEGIEmUEfEOIEMUGfMW9flWIbM_9fLWKbMW:FlYIbU_:FLYKbUW:Fl00F]o0Jeo0Jf?0^n
O@c>o0C7?@;GO003003GO=Ml00CGO0;7o@BonDKoo`00Dooo00<0DP9I0UT00P9I00<L7E@LE1`015@L
04L005@LE1aD76cmI=e/oFCMO?alg7clO=alo7cLO?alg7clO=b=OHeMUGfEGIEmUEfEOIEMUGfEGIEm
WIbM_9fLWKbMW9flWIbU_:FLYKbUW:FlYIb]o:gL[Ob]g:gl]Mbeo;GL]Obeg;Gl]Qbf?;HL]Sbf7;im
_UfnOKiM_WfnGKim_UfnOKiM_[fnWKjm00W>o0K7?@;GO08000?GO0?7o@BonDOoo`00E?oo03D0DP9I
0WT2F@9i91dT?E@LE3aD75@lE1`005@LE3a/gFcmK=e/oFcMK?elg7clO=alo7cLO?alg7clSEf=OHeM
SGfEGIEmUEfEOIEMUGfEGIEmWIbM_9fLWKbMW9flWIbU_:FLYKbUW:Fl00B]o0Jeo0Ff?0VnO@Jn_@K>
o0S7?@?GO003003GO<Om00?7o@BonDSoo`00EOoo1@9I00<L7B@M71d00e@L0P0004ID76cmI=e/oFCM
K?eTgFcmI=elo7cLO?alg7clSEf=OHeMSGf=GHemSEfEOIEMUGfEGIEmUEfEOIEMWKbMW9flWIbM_9hN
WSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjf7;Hl]Qbf?;HL_WfnGKim_UfnOKiM_WfnGKjm_Yfn_KjM
_[fnWKjm_Yfn_@?>o0[7?@?GO0030037oLOm00;7o@>onD[oo`00Eooo02`2F@9i0UT2NB@M93dT7B@m
E1aD?000E3a/gFcmK=e/oFcMK?e/gFcmK=e/oGcLO?alg8emSEf=OHeMSGf=GHemSEf=OIEMUGfEGIEm
UEfEOIEMWKbMW9fl4Yhn2;im2kjm3LLm00CGO<Omaod000C7o@:onD_oo`00FOoo0`9I00DL7B@M71dT
7A`M00800012K?eTgFcmI=e/oFCMK?eTgFcmI=e/oFCMSGf=GHemSEf=OHeMSGf=GHemSEf=OHeMUGfE
GIEmUEfEOIEMWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjnOKiM_Wfn
GKjm_Yfn_KjM_[fnWKjm_Yfn_KjM0kKn3<Lm1<Om00D00<Omaog7oKoi04goo`00Fooo02D2F@9i91dT
?B@M93dT7@00K=e/oFcMK?e/gFcmK=e/oFcMK?e/gFcmQIj5_XFNQKj=GHemSEf=OHeMSGf=GHemSEf=
OIEMUGfEG@0HWSh9_[d7]_h8acd4_gh4aod01000aog7oKoiC_oo001Mool01P9I71dT7A`M91dL7@80
000iECiE7VcmI=e/oFCMK?eTgFcmI=f5_XFNQKj5WXFnQIj5_XeMSGf=GHemSEf=OHeMSGfN7YhnWQjN
?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjn_KjM_[fnWKjm00Zf
oPC7?@NoOPG7o@030037oOoo04ooo`00G_oo00DT?B@M93dT7B@m0080000IEAiE?UDNECiE7UDnK=e/
oFcMK?f5WXFnQIj5_XFNQKj5WXFnQIj5_XFNSGf=GHemSEd079hn3KKn2kmn1/Om00<00?ooool0Cooo
001Pool010>J91dL7B@M0P0003AE7UDnEAiE?UDNECiE7UDnEAj5_XFNQKj5WXFnQIj5_XFNQKj5WXFn
QIj5_XFNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7Yhn
WQjN?PffoP^oOP?7o@03Uk/0000005;oo`00H_oo00<3^R@M93d00P0001IE7UDnEAiE?UDNECiE7UDn
EAim_gfOOKmmWgfoOIn5_XFNQKj5WXFnQIj5_QfN?PffoPZoOP;7o@:G^`8005?oo`00Hooo00@3^P>J
0kXL7@80000aECiE7UDnEAiE?UDNECiE7WfoOImm_gfOOKmmWgfoOImm_gfOOKmmWihnWQjN?YhNWSjN
7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSh03;Kn2[mn19Nk0P00
E?oo001Uool06@>J0kX3VUDnEAiE?UDNECiE7UDnEAiE?UDNOKmmWgfoOImm_gfOOKmmWgfoOImm_gfO
01^N?PffoPFoOPBW_P>G^`<005Goo`00Iooo0343^P>J000004Dn?Ai5?SdNAChm7TDn?Aim_gfOOKmm
WgfoOImm_gfOOKmmWgfoOInN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN
7YhnWQjN?P0=]_h8Ykh3Uk/00ooo0000001Gool006Soo`030kX3VP0000800008AAi5?TDNACi57TDn
AAi5?P]eoaJN?PfW?`VW_P:G^ecoo`00Jooo0`0002Hm7TDn?Ai5?SdNAChm7TDnMMmeogGOMOmeggGo
MMmeogGOMOmegihnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7Yhn1iKo1ZLo2JNn00>G
^oooool0GOoo001]ool300001dDnAAi5?TDNACi57TDn00Ieo`Q^?`fN?PfFo`VW_P03CSL00?oo05oo
o`00L?oo0`0001/]?RdN;Ch]7RdnIQm^?fHOKSmV7fhoIQm^?fHOKSmV7gIoMUmfOgIOMWmfGihnWQjN
?YhNWSh01XKo2IKo27ln00=>=oooool0H_oo001bool300001bdN;Ch]7Rdn;Ah]?RdN00E^?`QfO`In
_`N6o`FFo`Mo?P03CSOooooo06Goo`00M?oo100001P]7Rdn;Ah]?RdN;Ch]7WIoMUmfOgIOMWmfGgIo
MUmfOgIOO[mnWgjoOYmn_gjOO[l8Q_l6Oci/ool007Soo`<0000=;E`]O2eL;G`]G2el;E`]O2eL;G`]
G2el;E`027jo25JmL_oo001lool400004ReL;G`]G2el;E`]O2eL?O`eg3gl=M`mo3GL?O`eg3gl=M`m
o7Soo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo
003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?oo
o`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo
003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?oo
o`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo
003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?oo
o`_oo`00oooo2ooo003oool;ool00001\
\>"],
  ImageRangeCache->{{{93.5625, 425.5}, {456, 97.3125}} -> {-0.195801, \
0.25234, 0.00324176, 0.00324176}}]
}, Open  ]],

Cell["\<\
The solution appears visually to give a closed curve on the sphere. \
However, a plot of the error reveals that neither constraint is conserved \
particularly well.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(InvariantErrorPlot[invariants, vars, T, \ AdamsSolution, 
        SymbolStyle \[Rule] {Red, Blue}];\)\)], "Input",
  CellLabel->"In[23]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 0.0238095 3.07487e+06 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .17755 -33 -6.25 ]
[-0.0125 .17755 0 6.25 ]
[-0.0125 .3313 -33 -6.25 ]
[-0.0125 .3313 0 6.25 ]
[-0.0125 .48504 -45 -6.25 ]
[-0.0125 .48504 0 6.25 ]
[-0.0125 .63878 -33 -6.25 ]
[-0.0125 .63878 0 6.25 ]
[-0.0125 .79253 -45 -6.25 ]
[-0.0125 .79253 0 6.25 ]
[-0.0125 .94627 -33 -6.25 ]
[-0.0125 .94627 0 6.25 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .17755 m
.00625 .17755 L
s
gsave
-0.0125 .17755 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
0 .3313 m
.00625 .3313 L
s
gsave
-0.0125 .3313 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
0 .48504 m
.00625 .48504 L
s
gsave
-0.0125 .48504 -45 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
0 .63878 m
.00625 .63878 L
s
gsave
-0.0125 .63878 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
0 .79253 m
.00625 .79253 L
s
gsave
-0.0125 .79253 -45 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
0 .94627 m
.00625 .94627 L
s
gsave
-0.0125 .94627 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-7) show
grestore
.125 Mabswid
0 .05456 m
.00375 .05456 L
s
0 .08531 m
.00375 .08531 L
s
0 .11606 m
.00375 .11606 L
s
0 .1468 m
.00375 .1468 L
s
0 .2083 m
.00375 .2083 L
s
0 .23905 m
.00375 .23905 L
s
0 .2698 m
.00375 .2698 L
s
0 .30055 m
.00375 .30055 L
s
0 .36204 m
.00375 .36204 L
s
0 .39279 m
.00375 .39279 L
s
0 .42354 m
.00375 .42354 L
s
0 .45429 m
.00375 .45429 L
s
0 .51579 m
.00375 .51579 L
s
0 .54654 m
.00375 .54654 L
s
0 .57729 m
.00375 .57729 L
s
0 .60803 m
.00375 .60803 L
s
0 .66953 m
.00375 .66953 L
s
0 .70028 m
.00375 .70028 L
s
0 .73103 m
.00375 .73103 L
s
0 .76178 m
.00375 .76178 L
s
0 .82328 m
.00375 .82328 L
s
0 .85402 m
.00375 .85402 L
s
0 .88477 m
.00375 .88477 L
s
0 .91552 m
.00375 .91552 L
s
0 .97702 m
.00375 .97702 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.17262 .99375 m
.17262 1 L
s
.32143 .99375 m
.32143 1 L
s
.47024 .99375 m
.47024 1 L
s
.61905 .99375 m
.61905 1 L
s
.76786 .99375 m
.76786 1 L
s
.91667 .99375 m
.91667 1 L
s
.125 Mabswid
.05357 .99625 m
.05357 1 L
s
.08333 .99625 m
.08333 1 L
s
.1131 .99625 m
.1131 1 L
s
.14286 .99625 m
.14286 1 L
s
.20238 .99625 m
.20238 1 L
s
.23214 .99625 m
.23214 1 L
s
.2619 .99625 m
.2619 1 L
s
.29167 .99625 m
.29167 1 L
s
.35119 .99625 m
.35119 1 L
s
.38095 .99625 m
.38095 1 L
s
.41071 .99625 m
.41071 1 L
s
.44048 .99625 m
.44048 1 L
s
.5 .99625 m
.5 1 L
s
.52976 .99625 m
.52976 1 L
s
.55952 .99625 m
.55952 1 L
s
.58929 .99625 m
.58929 1 L
s
.64881 .99625 m
.64881 1 L
s
.67857 .99625 m
.67857 1 L
s
.70833 .99625 m
.70833 1 L
s
.7381 .99625 m
.7381 1 L
s
.79762 .99625 m
.79762 1 L
s
.82738 .99625 m
.82738 1 L
s
.85714 .99625 m
.85714 1 L
s
.8869 .99625 m
.8869 1 L
s
.94643 .99625 m
.94643 1 L
s
.97619 .99625 m
.97619 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .17755 m
1 .17755 L
s
.99375 .3313 m
1 .3313 L
s
.99375 .48504 m
1 .48504 L
s
.99375 .63878 m
1 .63878 L
s
.99375 .79253 m
1 .79253 L
s
.99375 .94627 m
1 .94627 L
s
.125 Mabswid
.99625 .05456 m
1 .05456 L
s
.99625 .08531 m
1 .08531 L
s
.99625 .11606 m
1 .11606 L
s
.99625 .1468 m
1 .1468 L
s
.99625 .2083 m
1 .2083 L
s
.99625 .23905 m
1 .23905 L
s
.99625 .2698 m
1 .2698 L
s
.99625 .30055 m
1 .30055 L
s
.99625 .36204 m
1 .36204 L
s
.99625 .39279 m
1 .39279 L
s
.99625 .42354 m
1 .42354 L
s
.99625 .45429 m
1 .45429 L
s
.99625 .51579 m
1 .51579 L
s
.99625 .54654 m
1 .54654 L
s
.99625 .57729 m
1 .57729 L
s
.99625 .60803 m
1 .60803 L
s
.99625 .66953 m
1 .66953 L
s
.99625 .70028 m
1 .70028 L
s
.99625 .73103 m
1 .73103 L
s
.99625 .76178 m
1 .76178 L
s
.99625 .82328 m
1 .82328 L
s
.99625 .85402 m
1 .85402 L
s
.99625 .88477 m
1 .88477 L
s
.99625 .91552 m
1 .91552 L
s
.99625 .97702 m
1 .97702 L
s
.25 Mabswid
1 0 m
1 1 L
s
1 0 0 r
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.02382 .05602 -1.875 0 Mabsadd m
.02382 .05602 0 2.5 Mabsadd L
.02382 .05602 1.875 0 Mabsadd L
.02382 .05602 0 -2.5 Mabsadd L
.02382 .05602 -1.875 0 Mabsadd L closepath F
.02382 .08822 -1.875 0 Mabsadd m
.02382 .08822 0 2.5 Mabsadd L
.02382 .08822 1.875 0 Mabsadd L
.02382 .08822 0 -2.5 Mabsadd L
.02382 .08822 -1.875 0 Mabsadd L closepath F
.02401 .08817 -1.875 0 Mabsadd m
.02401 .08817 0 2.5 Mabsadd L
.02401 .08817 1.875 0 Mabsadd L
.02401 .08817 0 -2.5 Mabsadd L
.02401 .08817 -1.875 0 Mabsadd L closepath F
.02419 .08803 -1.875 0 Mabsadd m
.02419 .08803 0 2.5 Mabsadd L
.02419 .08803 1.875 0 Mabsadd L
.02419 .08803 0 -2.5 Mabsadd L
.02419 .08803 -1.875 0 Mabsadd L closepath F
.02437 .08781 -1.875 0 Mabsadd m
.02437 .08781 0 2.5 Mabsadd L
.02437 .08781 1.875 0 Mabsadd L
.02437 .08781 0 -2.5 Mabsadd L
.02437 .08781 -1.875 0 Mabsadd L closepath F
.02497 .08012 -1.875 0 Mabsadd m
.02497 .08012 0 2.5 Mabsadd L
.02497 .08012 1.875 0 Mabsadd L
.02497 .08012 0 -2.5 Mabsadd L
.02497 .08012 -1.875 0 Mabsadd L closepath F
.02556 .07175 -1.875 0 Mabsadd m
.02556 .07175 0 2.5 Mabsadd L
.02556 .07175 1.875 0 Mabsadd L
.02556 .07175 0 -2.5 Mabsadd L
.02556 .07175 -1.875 0 Mabsadd L closepath F
.02616 .0633 -1.875 0 Mabsadd m
.02616 .0633 0 2.5 Mabsadd L
.02616 .0633 1.875 0 Mabsadd L
.02616 .0633 0 -2.5 Mabsadd L
.02616 .0633 -1.875 0 Mabsadd L closepath F
.02676 .05487 -1.875 0 Mabsadd m
.02676 .05487 0 2.5 Mabsadd L
.02676 .05487 1.875 0 Mabsadd L
.02676 .05487 0 -2.5 Mabsadd L
.02676 .05487 -1.875 0 Mabsadd L closepath F
.02795 .05533 -1.875 0 Mabsadd m
.02795 .05533 0 2.5 Mabsadd L
.02795 .05533 1.875 0 Mabsadd L
.02795 .05533 0 -2.5 Mabsadd L
.02795 .05533 -1.875 0 Mabsadd L closepath F
.02914 .07861 -1.875 0 Mabsadd m
.02914 .07861 0 2.5 Mabsadd L
.02914 .07861 1.875 0 Mabsadd L
.02914 .07861 0 -2.5 Mabsadd L
.02914 .07861 -1.875 0 Mabsadd L closepath F
.03034 .07975 -1.875 0 Mabsadd m
.03034 .07975 0 2.5 Mabsadd L
.03034 .07975 1.875 0 Mabsadd L
.03034 .07975 0 -2.5 Mabsadd L
.03034 .07975 -1.875 0 Mabsadd L closepath F
.03153 .08111 -1.875 0 Mabsadd m
.03153 .08111 0 2.5 Mabsadd L
.03153 .08111 1.875 0 Mabsadd L
.03153 .08111 0 -2.5 Mabsadd L
.03153 .08111 -1.875 0 Mabsadd L closepath F
.03273 .08268 -1.875 0 Mabsadd m
.03273 .08268 0 2.5 Mabsadd L
.03273 .08268 1.875 0 Mabsadd L
.03273 .08268 0 -2.5 Mabsadd L
.03273 .08268 -1.875 0 Mabsadd L closepath F
.03519 .1115 -1.875 0 Mabsadd m
.03519 .1115 0 2.5 Mabsadd L
.03519 .1115 1.875 0 Mabsadd L
.03519 .1115 0 -2.5 Mabsadd L
.03519 .1115 -1.875 0 Mabsadd L closepath F
.03766 .11509 -1.875 0 Mabsadd m
.03766 .11509 0 2.5 Mabsadd L
.03766 .11509 1.875 0 Mabsadd L
.03766 .11509 0 -2.5 Mabsadd L
.03766 .11509 -1.875 0 Mabsadd L closepath F
.04013 .12844 -1.875 0 Mabsadd m
.04013 .12844 0 2.5 Mabsadd L
.04013 .12844 1.875 0 Mabsadd L
.04013 .12844 0 -2.5 Mabsadd L
.04013 .12844 -1.875 0 Mabsadd L closepath F
.0426 .14224 -1.875 0 Mabsadd m
.0426 .14224 0 2.5 Mabsadd L
.0426 .14224 1.875 0 Mabsadd L
.0426 .14224 0 -2.5 Mabsadd L
.0426 .14224 -1.875 0 Mabsadd L closepath F
.04506 .15385 -1.875 0 Mabsadd m
.04506 .15385 0 2.5 Mabsadd L
.04506 .15385 1.875 0 Mabsadd L
.04506 .15385 0 -2.5 Mabsadd L
.04506 .15385 -1.875 0 Mabsadd L closepath F
.04753 .16324 -1.875 0 Mabsadd m
.04753 .16324 0 2.5 Mabsadd L
.04753 .16324 1.875 0 Mabsadd L
.04753 .16324 0 -2.5 Mabsadd L
.04753 .16324 -1.875 0 Mabsadd L closepath F
.05065 .17534 -1.875 0 Mabsadd m
.05065 .17534 0 2.5 Mabsadd L
.05065 .17534 1.875 0 Mabsadd L
.05065 .17534 0 -2.5 Mabsadd L
.05065 .17534 -1.875 0 Mabsadd L closepath F
.05377 .13817 -1.875 0 Mabsadd m
.05377 .13817 0 2.5 Mabsadd L
.05377 .13817 1.875 0 Mabsadd L
.05377 .13817 0 -2.5 Mabsadd L
.05377 .13817 -1.875 0 Mabsadd L closepath F
.05688 .1184 -1.875 0 Mabsadd m
.05688 .1184 0 2.5 Mabsadd L
.05688 .1184 1.875 0 Mabsadd L
.05688 .1184 0 -2.5 Mabsadd L
.05688 .1184 -1.875 0 Mabsadd L closepath F
.06 .10778 -1.875 0 Mabsadd m
.06 .10778 0 2.5 Mabsadd L
.06 .10778 1.875 0 Mabsadd L
.06 .10778 0 -2.5 Mabsadd L
.06 .10778 -1.875 0 Mabsadd L closepath F
.06312 .09983 -1.875 0 Mabsadd m
.06312 .09983 0 2.5 Mabsadd L
.06312 .09983 1.875 0 Mabsadd L
.06312 .09983 0 -2.5 Mabsadd L
.06312 .09983 -1.875 0 Mabsadd L closepath F
.06624 .09285 -1.875 0 Mabsadd m
.06624 .09285 0 2.5 Mabsadd L
.06624 .09285 1.875 0 Mabsadd L
.06624 .09285 0 -2.5 Mabsadd L
.06624 .09285 -1.875 0 Mabsadd L closepath F
.06935 .08742 -1.875 0 Mabsadd m
.06935 .08742 0 2.5 Mabsadd L
.06935 .08742 1.875 0 Mabsadd L
.06935 .08742 0 -2.5 Mabsadd L
.06935 .08742 -1.875 0 Mabsadd L closepath F
.07323 .07551 -1.875 0 Mabsadd m
.07323 .07551 0 2.5 Mabsadd L
.07323 .07551 1.875 0 Mabsadd L
.07323 .07551 0 -2.5 Mabsadd L
.07323 .07551 -1.875 0 Mabsadd L closepath F
.07711 .09427 -1.875 0 Mabsadd m
.07711 .09427 0 2.5 Mabsadd L
.07711 .09427 1.875 0 Mabsadd L
.07711 .09427 0 -2.5 Mabsadd L
.07711 .09427 -1.875 0 Mabsadd L closepath F
.08099 .11111 -1.875 0 Mabsadd m
.08099 .11111 0 2.5 Mabsadd L
.08099 .11111 1.875 0 Mabsadd L
.08099 .11111 0 -2.5 Mabsadd L
.08099 .11111 -1.875 0 Mabsadd L closepath F
.08487 .11923 -1.875 0 Mabsadd m
.08487 .11923 0 2.5 Mabsadd L
.08487 .11923 1.875 0 Mabsadd L
.08487 .11923 0 -2.5 Mabsadd L
.08487 .11923 -1.875 0 Mabsadd L closepath F
.08874 .12255 -1.875 0 Mabsadd m
.08874 .12255 0 2.5 Mabsadd L
.08874 .12255 1.875 0 Mabsadd L
.08874 .12255 0 -2.5 Mabsadd L
.08874 .12255 -1.875 0 Mabsadd L closepath F
.09262 .12495 -1.875 0 Mabsadd m
.09262 .12495 0 2.5 Mabsadd L
.09262 .12495 1.875 0 Mabsadd L
.09262 .12495 0 -2.5 Mabsadd L
.09262 .12495 -1.875 0 Mabsadd L closepath F
.0965 .12605 -1.875 0 Mabsadd m
.0965 .12605 0 2.5 Mabsadd L
.0965 .12605 1.875 0 Mabsadd L
.0965 .12605 0 -2.5 Mabsadd L
.0965 .12605 -1.875 0 Mabsadd L closepath F
.10038 .12631 -1.875 0 Mabsadd m
.10038 .12631 0 2.5 Mabsadd L
.10038 .12631 1.875 0 Mabsadd L
.10038 .12631 0 -2.5 Mabsadd L
.10038 .12631 -1.875 0 Mabsadd L closepath F
.10546 .12542 -1.875 0 Mabsadd m
.10546 .12542 0 2.5 Mabsadd L
.10546 .12542 1.875 0 Mabsadd L
.10546 .12542 0 -2.5 Mabsadd L
.10546 .12542 -1.875 0 Mabsadd L closepath F
.11053 .11848 -1.875 0 Mabsadd m
.11053 .11848 0 2.5 Mabsadd L
.11053 .11848 1.875 0 Mabsadd L
.11053 .11848 0 -2.5 Mabsadd L
.11053 .11848 -1.875 0 Mabsadd L closepath F
.11561 .10871 -1.875 0 Mabsadd m
.11561 .10871 0 2.5 Mabsadd L
.11561 .10871 1.875 0 Mabsadd L
.11561 .10871 0 -2.5 Mabsadd L
.11561 .10871 -1.875 0 Mabsadd L closepath F
.12069 .09869 -1.875 0 Mabsadd m
.12069 .09869 0 2.5 Mabsadd L
.12069 .09869 1.875 0 Mabsadd L
.12069 .09869 0 -2.5 Mabsadd L
.12069 .09869 -1.875 0 Mabsadd L closepath F
.12577 .09194 -1.875 0 Mabsadd m
.12577 .09194 0 2.5 Mabsadd L
.12577 .09194 1.875 0 Mabsadd L
.12577 .09194 0 -2.5 Mabsadd L
.12577 .09194 -1.875 0 Mabsadd L closepath F
.13085 .09163 -1.875 0 Mabsadd m
.13085 .09163 0 2.5 Mabsadd L
.13085 .09163 1.875 0 Mabsadd L
.13085 .09163 0 -2.5 Mabsadd L
.13085 .09163 -1.875 0 Mabsadd L closepath F
.13593 .10113 -1.875 0 Mabsadd m
.13593 .10113 0 2.5 Mabsadd L
.13593 .10113 1.875 0 Mabsadd L
.13593 .10113 0 -2.5 Mabsadd L
.13593 .10113 -1.875 0 Mabsadd L closepath F
.141 .12345 -1.875 0 Mabsadd m
.141 .12345 0 2.5 Mabsadd L
.141 .12345 1.875 0 Mabsadd L
.141 .12345 0 -2.5 Mabsadd L
.141 .12345 -1.875 0 Mabsadd L closepath F
.14608 .16061 -1.875 0 Mabsadd m
.14608 .16061 0 2.5 Mabsadd L
.14608 .16061 1.875 0 Mabsadd L
.14608 .16061 0 -2.5 Mabsadd L
.14608 .16061 -1.875 0 Mabsadd L closepath F
.15116 .21272 -1.875 0 Mabsadd m
.15116 .21272 0 2.5 Mabsadd L
.15116 .21272 1.875 0 Mabsadd L
.15116 .21272 0 -2.5 Mabsadd L
.15116 .21272 -1.875 0 Mabsadd L closepath F
.15624 .27683 -1.875 0 Mabsadd m
.15624 .27683 0 2.5 Mabsadd L
.15624 .27683 1.875 0 Mabsadd L
.15624 .27683 0 -2.5 Mabsadd L
.15624 .27683 -1.875 0 Mabsadd L closepath F
.16132 .34623 -1.875 0 Mabsadd m
.16132 .34623 0 2.5 Mabsadd L
.16132 .34623 1.875 0 Mabsadd L
.16132 .34623 0 -2.5 Mabsadd L
.16132 .34623 -1.875 0 Mabsadd L closepath F
.1664 .41031 -1.875 0 Mabsadd m
.1664 .41031 0 2.5 Mabsadd L
.1664 .41031 1.875 0 Mabsadd L
.1664 .41031 0 -2.5 Mabsadd L
.1664 .41031 -1.875 0 Mabsadd L closepath F
.17148 .45589 -1.875 0 Mabsadd m
.17148 .45589 0 2.5 Mabsadd L
.17148 .45589 1.875 0 Mabsadd L
.17148 .45589 0 -2.5 Mabsadd L
.17148 .45589 -1.875 0 Mabsadd L closepath F
.17555 .43159 -1.875 0 Mabsadd m
.17555 .43159 0 2.5 Mabsadd L
.17555 .43159 1.875 0 Mabsadd L
.17555 .43159 0 -2.5 Mabsadd L
.17555 .43159 -1.875 0 Mabsadd L closepath F
.17962 .4444 -1.875 0 Mabsadd m
.17962 .4444 0 2.5 Mabsadd L
.17962 .4444 1.875 0 Mabsadd L
.17962 .4444 0 -2.5 Mabsadd L
.17962 .4444 -1.875 0 Mabsadd L closepath F
.1837 .4208 -1.875 0 Mabsadd m
.1837 .4208 0 2.5 Mabsadd L
.1837 .4208 1.875 0 Mabsadd L
.1837 .4208 0 -2.5 Mabsadd L
.1837 .4208 -1.875 0 Mabsadd L closepath F
.18777 .40866 -1.875 0 Mabsadd m
.18777 .40866 0 2.5 Mabsadd L
.18777 .40866 1.875 0 Mabsadd L
.18777 .40866 0 -2.5 Mabsadd L
.18777 .40866 -1.875 0 Mabsadd L closepath F
.19185 .38446 -1.875 0 Mabsadd m
.19185 .38446 0 2.5 Mabsadd L
.19185 .38446 1.875 0 Mabsadd L
.19185 .38446 0 -2.5 Mabsadd L
.19185 .38446 -1.875 0 Mabsadd L closepath F
.19592 .36422 -1.875 0 Mabsadd m
.19592 .36422 0 2.5 Mabsadd L
.19592 .36422 1.875 0 Mabsadd L
.19592 .36422 0 -2.5 Mabsadd L
.19592 .36422 -1.875 0 Mabsadd L closepath F
.2 .3416 -1.875 0 Mabsadd m
.2 .3416 0 2.5 Mabsadd L
.2 .3416 1.875 0 Mabsadd L
.2 .3416 0 -2.5 Mabsadd L
.2 .3416 -1.875 0 Mabsadd L closepath F
.20407 .32419 -1.875 0 Mabsadd m
.20407 .32419 0 2.5 Mabsadd L
.20407 .32419 1.875 0 Mabsadd L
.20407 .32419 0 -2.5 Mabsadd L
.20407 .32419 -1.875 0 Mabsadd L closepath F
.20815 .31056 -1.875 0 Mabsadd m
.20815 .31056 0 2.5 Mabsadd L
.20815 .31056 1.875 0 Mabsadd L
.20815 .31056 0 -2.5 Mabsadd L
.20815 .31056 -1.875 0 Mabsadd L closepath F
.21222 .30318 -1.875 0 Mabsadd m
.21222 .30318 0 2.5 Mabsadd L
.21222 .30318 1.875 0 Mabsadd L
.21222 .30318 0 -2.5 Mabsadd L
.21222 .30318 -1.875 0 Mabsadd L closepath F
.21629 .30118 -1.875 0 Mabsadd m
.21629 .30118 0 2.5 Mabsadd L
.21629 .30118 1.875 0 Mabsadd L
.21629 .30118 0 -2.5 Mabsadd L
.21629 .30118 -1.875 0 Mabsadd L closepath F
.22037 .30432 -1.875 0 Mabsadd m
.22037 .30432 0 2.5 Mabsadd L
.22037 .30432 1.875 0 Mabsadd L
.22037 .30432 0 -2.5 Mabsadd L
.22037 .30432 -1.875 0 Mabsadd L closepath F
.22444 .31114 -1.875 0 Mabsadd m
.22444 .31114 0 2.5 Mabsadd L
.22444 .31114 1.875 0 Mabsadd L
.22444 .31114 0 -2.5 Mabsadd L
.22444 .31114 -1.875 0 Mabsadd L closepath F
.22852 .32032 -1.875 0 Mabsadd m
.22852 .32032 0 2.5 Mabsadd L
.22852 .32032 1.875 0 Mabsadd L
.22852 .32032 0 -2.5 Mabsadd L
.22852 .32032 -1.875 0 Mabsadd L closepath F
.23259 .33041 -1.875 0 Mabsadd m
.23259 .33041 0 2.5 Mabsadd L
.23259 .33041 1.875 0 Mabsadd L
.23259 .33041 0 -2.5 Mabsadd L
.23259 .33041 -1.875 0 Mabsadd L closepath F
.23667 .34023 -1.875 0 Mabsadd m
.23667 .34023 0 2.5 Mabsadd L
.23667 .34023 1.875 0 Mabsadd L
.23667 .34023 0 -2.5 Mabsadd L
.23667 .34023 -1.875 0 Mabsadd L closepath F
.24074 .34891 -1.875 0 Mabsadd m
.24074 .34891 0 2.5 Mabsadd L
.24074 .34891 1.875 0 Mabsadd L
.24074 .34891 0 -2.5 Mabsadd L
.24074 .34891 -1.875 0 Mabsadd L closepath F
.24535 .37211 -1.875 0 Mabsadd m
.24535 .37211 0 2.5 Mabsadd L
.24535 .37211 1.875 0 Mabsadd L
.24535 .37211 0 -2.5 Mabsadd L
.24535 .37211 -1.875 0 Mabsadd L closepath F
.24996 .38432 -1.875 0 Mabsadd m
.24996 .38432 0 2.5 Mabsadd L
.24996 .38432 1.875 0 Mabsadd L
.24996 .38432 0 -2.5 Mabsadd L
.24996 .38432 -1.875 0 Mabsadd L closepath F
.25456 .39392 -1.875 0 Mabsadd m
.25456 .39392 0 2.5 Mabsadd L
.25456 .39392 1.875 0 Mabsadd L
.25456 .39392 0 -2.5 Mabsadd L
.25456 .39392 -1.875 0 Mabsadd L closepath F
.25917 .39741 -1.875 0 Mabsadd m
.25917 .39741 0 2.5 Mabsadd L
.25917 .39741 1.875 0 Mabsadd L
.25917 .39741 0 -2.5 Mabsadd L
.25917 .39741 -1.875 0 Mabsadd L closepath F
.26378 .39739 -1.875 0 Mabsadd m
.26378 .39739 0 2.5 Mabsadd L
.26378 .39739 1.875 0 Mabsadd L
.26378 .39739 0 -2.5 Mabsadd L
.26378 .39739 -1.875 0 Mabsadd L closepath F
.26839 .39444 -1.875 0 Mabsadd m
.26839 .39444 0 2.5 Mabsadd L
.26839 .39444 1.875 0 Mabsadd L
.26839 .39444 0 -2.5 Mabsadd L
.26839 .39444 -1.875 0 Mabsadd L closepath F
.27299 .39003 -1.875 0 Mabsadd m
.27299 .39003 0 2.5 Mabsadd L
.27299 .39003 1.875 0 Mabsadd L
.27299 .39003 0 -2.5 Mabsadd L
.27299 .39003 -1.875 0 Mabsadd L closepath F
.2776 .38528 -1.875 0 Mabsadd m
.2776 .38528 0 2.5 Mabsadd L
.2776 .38528 1.875 0 Mabsadd L
.2776 .38528 0 -2.5 Mabsadd L
.2776 .38528 -1.875 0 Mabsadd L closepath F
.28295 .37711 -1.875 0 Mabsadd m
.28295 .37711 0 2.5 Mabsadd L
.28295 .37711 1.875 0 Mabsadd L
.28295 .37711 0 -2.5 Mabsadd L
.28295 .37711 -1.875 0 Mabsadd L closepath F
.28829 .38905 -1.875 0 Mabsadd m
.28829 .38905 0 2.5 Mabsadd L
.28829 .38905 1.875 0 Mabsadd L
.28829 .38905 0 -2.5 Mabsadd L
.28829 .38905 -1.875 0 Mabsadd L closepath F
.29364 .4055 -1.875 0 Mabsadd m
.29364 .4055 0 2.5 Mabsadd L
.29364 .4055 1.875 0 Mabsadd L
.29364 .4055 0 -2.5 Mabsadd L
.29364 .4055 -1.875 0 Mabsadd L closepath F
.29899 .42708 -1.875 0 Mabsadd m
.29899 .42708 0 2.5 Mabsadd L
.29899 .42708 1.875 0 Mabsadd L
.29899 .42708 0 -2.5 Mabsadd L
.29899 .42708 -1.875 0 Mabsadd L closepath F
.30433 .44734 -1.875 0 Mabsadd m
.30433 .44734 0 2.5 Mabsadd L
.30433 .44734 1.875 0 Mabsadd L
.30433 .44734 0 -2.5 Mabsadd L
.30433 .44734 -1.875 0 Mabsadd L closepath F
.30968 .46924 -1.875 0 Mabsadd m
.30968 .46924 0 2.5 Mabsadd L
.30968 .46924 1.875 0 Mabsadd L
.30968 .46924 0 -2.5 Mabsadd L
.30968 .46924 -1.875 0 Mabsadd L closepath F
.31503 .48759 -1.875 0 Mabsadd m
.31503 .48759 0 2.5 Mabsadd L
.31503 .48759 1.875 0 Mabsadd L
.31503 .48759 0 -2.5 Mabsadd L
.31503 .48759 -1.875 0 Mabsadd L closepath F
.32037 .49736 -1.875 0 Mabsadd m
.32037 .49736 0 2.5 Mabsadd L
.32037 .49736 1.875 0 Mabsadd L
.32037 .49736 0 -2.5 Mabsadd L
.32037 .49736 -1.875 0 Mabsadd L closepath F
.32572 .49157 -1.875 0 Mabsadd m
.32572 .49157 0 2.5 Mabsadd L
.32572 .49157 1.875 0 Mabsadd L
.32572 .49157 0 -2.5 Mabsadd L
.32572 .49157 -1.875 0 Mabsadd L closepath F
.33107 .46553 -1.875 0 Mabsadd m
.33107 .46553 0 2.5 Mabsadd L
.33107 .46553 1.875 0 Mabsadd L
.33107 .46553 0 -2.5 Mabsadd L
.33107 .46553 -1.875 0 Mabsadd L closepath F
.33641 .41815 -1.875 0 Mabsadd m
.33641 .41815 0 2.5 Mabsadd L
.33641 .41815 1.875 0 Mabsadd L
.33641 .41815 0 -2.5 Mabsadd L
.33641 .41815 -1.875 0 Mabsadd L closepath F
.34176 .35457 -1.875 0 Mabsadd m
.34176 .35457 0 2.5 Mabsadd L
.34176 .35457 1.875 0 Mabsadd L
.34176 .35457 0 -2.5 Mabsadd L
.34176 .35457 -1.875 0 Mabsadd L closepath F
.34711 .28622 -1.875 0 Mabsadd m
.34711 .28622 0 2.5 Mabsadd L
.34711 .28622 1.875 0 Mabsadd L
.34711 .28622 0 -2.5 Mabsadd L
.34711 .28622 -1.875 0 Mabsadd L closepath F
.35245 .22818 -1.875 0 Mabsadd m
.35245 .22818 0 2.5 Mabsadd L
.35245 .22818 1.875 0 Mabsadd L
.35245 .22818 0 -2.5 Mabsadd L
.35245 .22818 -1.875 0 Mabsadd L closepath F
.3578 .19482 -1.875 0 Mabsadd m
.3578 .19482 0 2.5 Mabsadd L
.3578 .19482 1.875 0 Mabsadd L
.3578 .19482 0 -2.5 Mabsadd L
.3578 .19482 -1.875 0 Mabsadd L closepath F
.36091 .21024 -1.875 0 Mabsadd m
.36091 .21024 0 2.5 Mabsadd L
.36091 .21024 1.875 0 Mabsadd L
.36091 .21024 0 -2.5 Mabsadd L
.36091 .21024 -1.875 0 Mabsadd L closepath F
.36402 .19528 -1.875 0 Mabsadd m
.36402 .19528 0 2.5 Mabsadd L
.36402 .19528 1.875 0 Mabsadd L
.36402 .19528 0 -2.5 Mabsadd L
.36402 .19528 -1.875 0 Mabsadd L closepath F
.36713 .2036 -1.875 0 Mabsadd m
.36713 .2036 0 2.5 Mabsadd L
.36713 .2036 1.875 0 Mabsadd L
.36713 .2036 0 -2.5 Mabsadd L
.36713 .2036 -1.875 0 Mabsadd L closepath F
.37024 .1996 -1.875 0 Mabsadd m
.37024 .1996 0 2.5 Mabsadd L
.37024 .1996 1.875 0 Mabsadd L
.37024 .1996 0 -2.5 Mabsadd L
.37024 .1996 -1.875 0 Mabsadd L closepath F
.37335 .20079 -1.875 0 Mabsadd m
.37335 .20079 0 2.5 Mabsadd L
.37335 .20079 1.875 0 Mabsadd L
.37335 .20079 0 -2.5 Mabsadd L
.37335 .20079 -1.875 0 Mabsadd L closepath F
.37645 .20029 -1.875 0 Mabsadd m
.37645 .20029 0 2.5 Mabsadd L
.37645 .20029 1.875 0 Mabsadd L
.37645 .20029 0 -2.5 Mabsadd L
.37645 .20029 -1.875 0 Mabsadd L closepath F
.37956 .20144 -1.875 0 Mabsadd m
.37956 .20144 0 2.5 Mabsadd L
.37956 .20144 1.875 0 Mabsadd L
.37956 .20144 0 -2.5 Mabsadd L
.37956 .20144 -1.875 0 Mabsadd L closepath F
.38267 .20213 -1.875 0 Mabsadd m
.38267 .20213 0 2.5 Mabsadd L
.38267 .20213 1.875 0 Mabsadd L
.38267 .20213 0 -2.5 Mabsadd L
.38267 .20213 -1.875 0 Mabsadd L closepath F
.38707 .21427 -1.875 0 Mabsadd m
.38707 .21427 0 2.5 Mabsadd L
.38707 .21427 1.875 0 Mabsadd L
.38707 .21427 0 -2.5 Mabsadd L
.38707 .21427 -1.875 0 Mabsadd L closepath F
.39147 .23221 -1.875 0 Mabsadd m
.39147 .23221 0 2.5 Mabsadd L
.39147 .23221 1.875 0 Mabsadd L
.39147 .23221 0 -2.5 Mabsadd L
.39147 .23221 -1.875 0 Mabsadd L closepath F
.39587 .25059 -1.875 0 Mabsadd m
.39587 .25059 0 2.5 Mabsadd L
.39587 .25059 1.875 0 Mabsadd L
.39587 .25059 0 -2.5 Mabsadd L
.39587 .25059 -1.875 0 Mabsadd L closepath F
.40027 .26729 -1.875 0 Mabsadd m
.40027 .26729 0 2.5 Mabsadd L
.40027 .26729 1.875 0 Mabsadd L
.40027 .26729 0 -2.5 Mabsadd L
.40027 .26729 -1.875 0 Mabsadd L closepath F
.40467 .28088 -1.875 0 Mabsadd m
.40467 .28088 0 2.5 Mabsadd L
.40467 .28088 1.875 0 Mabsadd L
.40467 .28088 0 -2.5 Mabsadd L
.40467 .28088 -1.875 0 Mabsadd L closepath F
.40907 .2908 -1.875 0 Mabsadd m
.40907 .2908 0 2.5 Mabsadd L
.40907 .2908 1.875 0 Mabsadd L
.40907 .2908 0 -2.5 Mabsadd L
.40907 .2908 -1.875 0 Mabsadd L closepath F
.41347 .29695 -1.875 0 Mabsadd m
.41347 .29695 0 2.5 Mabsadd L
.41347 .29695 1.875 0 Mabsadd L
.41347 .29695 0 -2.5 Mabsadd L
.41347 .29695 -1.875 0 Mabsadd L closepath F
.41787 .29983 -1.875 0 Mabsadd m
.41787 .29983 0 2.5 Mabsadd L
.41787 .29983 1.875 0 Mabsadd L
.41787 .29983 0 -2.5 Mabsadd L
.41787 .29983 -1.875 0 Mabsadd L closepath F
.42281 .30307 -1.875 0 Mabsadd m
.42281 .30307 0 2.5 Mabsadd L
.42281 .30307 1.875 0 Mabsadd L
.42281 .30307 0 -2.5 Mabsadd L
.42281 .30307 -1.875 0 Mabsadd L closepath F
.42775 .29839 -1.875 0 Mabsadd m
.42775 .29839 0 2.5 Mabsadd L
.42775 .29839 1.875 0 Mabsadd L
.42775 .29839 0 -2.5 Mabsadd L
.42775 .29839 -1.875 0 Mabsadd L closepath F
.43269 .29147 -1.875 0 Mabsadd m
.43269 .29147 0 2.5 Mabsadd L
.43269 .29147 1.875 0 Mabsadd L
.43269 .29147 0 -2.5 Mabsadd L
.43269 .29147 -1.875 0 Mabsadd L closepath F
.43763 .28305 -1.875 0 Mabsadd m
.43763 .28305 0 2.5 Mabsadd L
.43763 .28305 1.875 0 Mabsadd L
.43763 .28305 0 -2.5 Mabsadd L
.43763 .28305 -1.875 0 Mabsadd L closepath F
.44257 .27623 -1.875 0 Mabsadd m
.44257 .27623 0 2.5 Mabsadd L
.44257 .27623 1.875 0 Mabsadd L
.44257 .27623 0 -2.5 Mabsadd L
.44257 .27623 -1.875 0 Mabsadd L closepath F
.44751 .27324 -1.875 0 Mabsadd m
.44751 .27324 0 2.5 Mabsadd L
.44751 .27324 1.875 0 Mabsadd L
.44751 .27324 0 -2.5 Mabsadd L
.44751 .27324 -1.875 0 Mabsadd L closepath F
.45245 .2767 -1.875 0 Mabsadd m
.45245 .2767 0 2.5 Mabsadd L
.45245 .2767 1.875 0 Mabsadd L
.45245 .2767 0 -2.5 Mabsadd L
.45245 .2767 -1.875 0 Mabsadd L closepath F
.45739 .28903 -1.875 0 Mabsadd m
.45739 .28903 0 2.5 Mabsadd L
.45739 .28903 1.875 0 Mabsadd L
.45739 .28903 0 -2.5 Mabsadd L
.45739 .28903 -1.875 0 Mabsadd L closepath F
.46233 .31222 -1.875 0 Mabsadd m
.46233 .31222 0 2.5 Mabsadd L
.46233 .31222 1.875 0 Mabsadd L
.46233 .31222 0 -2.5 Mabsadd L
.46233 .31222 -1.875 0 Mabsadd L closepath F
.46727 .34724 -1.875 0 Mabsadd m
.46727 .34724 0 2.5 Mabsadd L
.46727 .34724 1.875 0 Mabsadd L
.46727 .34724 0 -2.5 Mabsadd L
.46727 .34724 -1.875 0 Mabsadd L closepath F
.47221 .39325 -1.875 0 Mabsadd m
.47221 .39325 0 2.5 Mabsadd L
.47221 .39325 1.875 0 Mabsadd L
.47221 .39325 0 -2.5 Mabsadd L
.47221 .39325 -1.875 0 Mabsadd L closepath F
.47715 .44691 -1.875 0 Mabsadd m
.47715 .44691 0 2.5 Mabsadd L
.47715 .44691 1.875 0 Mabsadd L
.47715 .44691 0 -2.5 Mabsadd L
.47715 .44691 -1.875 0 Mabsadd L closepath F
.48209 .50193 -1.875 0 Mabsadd m
.48209 .50193 0 2.5 Mabsadd L
.48209 .50193 1.875 0 Mabsadd L
.48209 .50193 0 -2.5 Mabsadd L
.48209 .50193 -1.875 0 Mabsadd L closepath F
.48703 .54942 -1.875 0 Mabsadd m
.48703 .54942 0 2.5 Mabsadd L
.48703 .54942 1.875 0 Mabsadd L
.48703 .54942 0 -2.5 Mabsadd L
.48703 .54942 -1.875 0 Mabsadd L closepath F
.49112 .53183 -1.875 0 Mabsadd m
.49112 .53183 0 2.5 Mabsadd L
.49112 .53183 1.875 0 Mabsadd L
.49112 .53183 0 -2.5 Mabsadd L
.49112 .53183 -1.875 0 Mabsadd L closepath F
.49521 .54748 -1.875 0 Mabsadd m
.49521 .54748 0 2.5 Mabsadd L
.49521 .54748 1.875 0 Mabsadd L
.49521 .54748 0 -2.5 Mabsadd L
.49521 .54748 -1.875 0 Mabsadd L closepath F
.49931 .53129 -1.875 0 Mabsadd m
.49931 .53129 0 2.5 Mabsadd L
.49931 .53129 1.875 0 Mabsadd L
.49931 .53129 0 -2.5 Mabsadd L
.49931 .53129 -1.875 0 Mabsadd L closepath F
.5034 .52214 -1.875 0 Mabsadd m
.5034 .52214 0 2.5 Mabsadd L
.5034 .52214 1.875 0 Mabsadd L
.5034 .52214 0 -2.5 Mabsadd L
.5034 .52214 -1.875 0 Mabsadd L closepath F
.50749 .50133 -1.875 0 Mabsadd m
.50749 .50133 0 2.5 Mabsadd L
.50749 .50133 1.875 0 Mabsadd L
.50749 .50133 0 -2.5 Mabsadd L
.50749 .50133 -1.875 0 Mabsadd L closepath F
.51159 .48083 -1.875 0 Mabsadd m
.51159 .48083 0 2.5 Mabsadd L
.51159 .48083 1.875 0 Mabsadd L
.51159 .48083 0 -2.5 Mabsadd L
.51159 .48083 -1.875 0 Mabsadd L closepath F
.51568 .45674 -1.875 0 Mabsadd m
.51568 .45674 0 2.5 Mabsadd L
.51568 .45674 1.875 0 Mabsadd L
.51568 .45674 0 -2.5 Mabsadd L
.51568 .45674 -1.875 0 Mabsadd L closepath F
.51977 .43526 -1.875 0 Mabsadd m
.51977 .43526 0 2.5 Mabsadd L
.51977 .43526 1.875 0 Mabsadd L
.51977 .43526 0 -2.5 Mabsadd L
.51977 .43526 -1.875 0 Mabsadd L closepath F
.52323 .43987 -1.875 0 Mabsadd m
.52323 .43987 0 2.5 Mabsadd L
.52323 .43987 1.875 0 Mabsadd L
.52323 .43987 0 -2.5 Mabsadd L
.52323 .43987 -1.875 0 Mabsadd L closepath F
.52669 .43068 -1.875 0 Mabsadd m
.52669 .43068 0 2.5 Mabsadd L
.52669 .43068 1.875 0 Mabsadd L
.52669 .43068 0 -2.5 Mabsadd L
.52669 .43068 -1.875 0 Mabsadd L closepath F
.53015 .43169 -1.875 0 Mabsadd m
.53015 .43169 0 2.5 Mabsadd L
.53015 .43169 1.875 0 Mabsadd L
.53015 .43169 0 -2.5 Mabsadd L
.53015 .43169 -1.875 0 Mabsadd L closepath F
.53361 .43017 -1.875 0 Mabsadd m
.53361 .43017 0 2.5 Mabsadd L
.53361 .43017 1.875 0 Mabsadd L
.53361 .43017 0 -2.5 Mabsadd L
.53361 .43017 -1.875 0 Mabsadd L closepath F
.53707 .43121 -1.875 0 Mabsadd m
.53707 .43121 0 2.5 Mabsadd L
.53707 .43121 1.875 0 Mabsadd L
.53707 .43121 0 -2.5 Mabsadd L
.53707 .43121 -1.875 0 Mabsadd L closepath F
.54053 .43255 -1.875 0 Mabsadd m
.54053 .43255 0 2.5 Mabsadd L
.54053 .43255 1.875 0 Mabsadd L
.54053 .43255 0 -2.5 Mabsadd L
.54053 .43255 -1.875 0 Mabsadd L closepath F
.54399 .43494 -1.875 0 Mabsadd m
.54399 .43494 0 2.5 Mabsadd L
.54399 .43494 1.875 0 Mabsadd L
.54399 .43494 0 -2.5 Mabsadd L
.54399 .43494 -1.875 0 Mabsadd L closepath F
.54745 .43752 -1.875 0 Mabsadd m
.54745 .43752 0 2.5 Mabsadd L
.54745 .43752 1.875 0 Mabsadd L
.54745 .43752 0 -2.5 Mabsadd L
.54745 .43752 -1.875 0 Mabsadd L closepath F
.55156 .44928 -1.875 0 Mabsadd m
.55156 .44928 0 2.5 Mabsadd L
.55156 .44928 1.875 0 Mabsadd L
.55156 .44928 0 -2.5 Mabsadd L
.55156 .44928 -1.875 0 Mabsadd L closepath F
.55568 .45926 -1.875 0 Mabsadd m
.55568 .45926 0 2.5 Mabsadd L
.55568 .45926 1.875 0 Mabsadd L
.55568 .45926 0 -2.5 Mabsadd L
.55568 .45926 -1.875 0 Mabsadd L closepath F
.55979 .46905 -1.875 0 Mabsadd m
.55979 .46905 0 2.5 Mabsadd L
.55979 .46905 1.875 0 Mabsadd L
.55979 .46905 0 -2.5 Mabsadd L
.55979 .46905 -1.875 0 Mabsadd L closepath F
.56391 .47674 -1.875 0 Mabsadd m
.56391 .47674 0 2.5 Mabsadd L
.56391 .47674 1.875 0 Mabsadd L
.56391 .47674 0 -2.5 Mabsadd L
.56391 .47674 -1.875 0 Mabsadd L closepath F
.56802 .4825 -1.875 0 Mabsadd m
.56802 .4825 0 2.5 Mabsadd L
.56802 .4825 1.875 0 Mabsadd L
.56802 .4825 0 -2.5 Mabsadd L
.56802 .4825 -1.875 0 Mabsadd L closepath F
.57213 .48618 -1.875 0 Mabsadd m
.57213 .48618 0 2.5 Mabsadd L
.57213 .48618 1.875 0 Mabsadd L
.57213 .48618 0 -2.5 Mabsadd L
.57213 .48618 -1.875 0 Mabsadd L closepath F
.57625 .48805 -1.875 0 Mabsadd m
.57625 .48805 0 2.5 Mabsadd L
.57625 .48805 1.875 0 Mabsadd L
.57625 .48805 0 -2.5 Mabsadd L
.57625 .48805 -1.875 0 Mabsadd L closepath F
.58036 .48839 -1.875 0 Mabsadd m
.58036 .48839 0 2.5 Mabsadd L
.58036 .48839 1.875 0 Mabsadd L
.58036 .48839 0 -2.5 Mabsadd L
.58036 .48839 -1.875 0 Mabsadd L closepath F
.58543 .48672 -1.875 0 Mabsadd m
.58543 .48672 0 2.5 Mabsadd L
.58543 .48672 1.875 0 Mabsadd L
.58543 .48672 0 -2.5 Mabsadd L
.58543 .48672 -1.875 0 Mabsadd L closepath F
.5905 .47906 -1.875 0 Mabsadd m
.5905 .47906 0 2.5 Mabsadd L
.5905 .47906 1.875 0 Mabsadd L
.5905 .47906 0 -2.5 Mabsadd L
.5905 .47906 -1.875 0 Mabsadd L closepath F
.59556 .46922 -1.875 0 Mabsadd m
.59556 .46922 0 2.5 Mabsadd L
.59556 .46922 1.875 0 Mabsadd L
.59556 .46922 0 -2.5 Mabsadd L
.59556 .46922 -1.875 0 Mabsadd L closepath F
.60063 .45968 -1.875 0 Mabsadd m
.60063 .45968 0 2.5 Mabsadd L
.60063 .45968 1.875 0 Mabsadd L
.60063 .45968 0 -2.5 Mabsadd L
.60063 .45968 -1.875 0 Mabsadd L closepath F
.6057 .45391 -1.875 0 Mabsadd m
.6057 .45391 0 2.5 Mabsadd L
.6057 .45391 1.875 0 Mabsadd L
.6057 .45391 0 -2.5 Mabsadd L
.6057 .45391 -1.875 0 Mabsadd L closepath F
.61077 .45502 -1.875 0 Mabsadd m
.61077 .45502 0 2.5 Mabsadd L
.61077 .45502 1.875 0 Mabsadd L
.61077 .45502 0 -2.5 Mabsadd L
.61077 .45502 -1.875 0 Mabsadd L closepath F
.61584 .46629 -1.875 0 Mabsadd m
.61584 .46629 0 2.5 Mabsadd L
.61584 .46629 1.875 0 Mabsadd L
.61584 .46629 0 -2.5 Mabsadd L
.61584 .46629 -1.875 0 Mabsadd L closepath F
.6209 .49057 -1.875 0 Mabsadd m
.6209 .49057 0 2.5 Mabsadd L
.6209 .49057 1.875 0 Mabsadd L
.6209 .49057 0 -2.5 Mabsadd L
.6209 .49057 -1.875 0 Mabsadd L closepath F
.62597 .52958 -1.875 0 Mabsadd m
.62597 .52958 0 2.5 Mabsadd L
.62597 .52958 1.875 0 Mabsadd L
.62597 .52958 0 -2.5 Mabsadd L
.62597 .52958 -1.875 0 Mabsadd L closepath F
.63104 .58301 -1.875 0 Mabsadd m
.63104 .58301 0 2.5 Mabsadd L
.63104 .58301 1.875 0 Mabsadd L
.63104 .58301 0 -2.5 Mabsadd L
.63104 .58301 -1.875 0 Mabsadd L closepath F
.63611 .64742 -1.875 0 Mabsadd m
.63611 .64742 0 2.5 Mabsadd L
.63611 .64742 1.875 0 Mabsadd L
.63611 .64742 0 -2.5 Mabsadd L
.63611 .64742 -1.875 0 Mabsadd L closepath F
.64117 .71559 -1.875 0 Mabsadd m
.64117 .71559 0 2.5 Mabsadd L
.64117 .71559 1.875 0 Mabsadd L
.64117 .71559 0 -2.5 Mabsadd L
.64117 .71559 -1.875 0 Mabsadd L closepath F
.64624 .77663 -1.875 0 Mabsadd m
.64624 .77663 0 2.5 Mabsadd L
.64624 .77663 1.875 0 Mabsadd L
.64624 .77663 0 -2.5 Mabsadd L
.64624 .77663 -1.875 0 Mabsadd L closepath F
.65131 .81742 -1.875 0 Mabsadd m
.65131 .81742 0 2.5 Mabsadd L
.65131 .81742 1.875 0 Mabsadd L
.65131 .81742 0 -2.5 Mabsadd L
.65131 .81742 -1.875 0 Mabsadd L closepath F
.65544 .79498 -1.875 0 Mabsadd m
.65544 .79498 0 2.5 Mabsadd L
.65544 .79498 1.875 0 Mabsadd L
.65544 .79498 0 -2.5 Mabsadd L
.65544 .79498 -1.875 0 Mabsadd L closepath F
.65957 .80375 -1.875 0 Mabsadd m
.65957 .80375 0 2.5 Mabsadd L
.65957 .80375 1.875 0 Mabsadd L
.65957 .80375 0 -2.5 Mabsadd L
.65957 .80375 -1.875 0 Mabsadd L closepath F
.6637 .77862 -1.875 0 Mabsadd m
.6637 .77862 0 2.5 Mabsadd L
.6637 .77862 1.875 0 Mabsadd L
.6637 .77862 0 -2.5 Mabsadd L
.6637 .77862 -1.875 0 Mabsadd L closepath F
.66783 .76315 -1.875 0 Mabsadd m
.66783 .76315 0 2.5 Mabsadd L
.66783 .76315 1.875 0 Mabsadd L
.66783 .76315 0 -2.5 Mabsadd L
.66783 .76315 -1.875 0 Mabsadd L closepath F
.67197 .73607 -1.875 0 Mabsadd m
.67197 .73607 0 2.5 Mabsadd L
.67197 .73607 1.875 0 Mabsadd L
.67197 .73607 0 -2.5 Mabsadd L
.67197 .73607 -1.875 0 Mabsadd L closepath F
.6761 .71319 -1.875 0 Mabsadd m
.6761 .71319 0 2.5 Mabsadd L
.6761 .71319 1.875 0 Mabsadd L
.6761 .71319 0 -2.5 Mabsadd L
.6761 .71319 -1.875 0 Mabsadd L closepath F
.68023 .68874 -1.875 0 Mabsadd m
.68023 .68874 0 2.5 Mabsadd L
.68023 .68874 1.875 0 Mabsadd L
.68023 .68874 0 -2.5 Mabsadd L
.68023 .68874 -1.875 0 Mabsadd L closepath F
.68436 .67042 -1.875 0 Mabsadd m
.68436 .67042 0 2.5 Mabsadd L
.68436 .67042 1.875 0 Mabsadd L
.68436 .67042 0 -2.5 Mabsadd L
.68436 .67042 -1.875 0 Mabsadd L closepath F
.68849 .65686 -1.875 0 Mabsadd m
.68849 .65686 0 2.5 Mabsadd L
.68849 .65686 1.875 0 Mabsadd L
.68849 .65686 0 -2.5 Mabsadd L
.68849 .65686 -1.875 0 Mabsadd L closepath F
.69262 .65039 -1.875 0 Mabsadd m
.69262 .65039 0 2.5 Mabsadd L
.69262 .65039 1.875 0 Mabsadd L
.69262 .65039 0 -2.5 Mabsadd L
.69262 .65039 -1.875 0 Mabsadd L closepath F
.69675 .6499 -1.875 0 Mabsadd m
.69675 .6499 0 2.5 Mabsadd L
.69675 .6499 1.875 0 Mabsadd L
.69675 .6499 0 -2.5 Mabsadd L
.69675 .6499 -1.875 0 Mabsadd L closepath F
.70088 .65484 -1.875 0 Mabsadd m
.70088 .65484 0 2.5 Mabsadd L
.70088 .65484 1.875 0 Mabsadd L
.70088 .65484 0 -2.5 Mabsadd L
.70088 .65484 -1.875 0 Mabsadd L closepath F
.70501 .66345 -1.875 0 Mabsadd m
.70501 .66345 0 2.5 Mabsadd L
.70501 .66345 1.875 0 Mabsadd L
.70501 .66345 0 -2.5 Mabsadd L
.70501 .66345 -1.875 0 Mabsadd L closepath F
.70914 .67421 -1.875 0 Mabsadd m
.70914 .67421 0 2.5 Mabsadd L
.70914 .67421 1.875 0 Mabsadd L
.70914 .67421 0 -2.5 Mabsadd L
.70914 .67421 -1.875 0 Mabsadd L closepath F
.71328 .68549 -1.875 0 Mabsadd m
.71328 .68549 0 2.5 Mabsadd L
.71328 .68549 1.875 0 Mabsadd L
.71328 .68549 0 -2.5 Mabsadd L
.71328 .68549 -1.875 0 Mabsadd L closepath F
.71741 .69608 -1.875 0 Mabsadd m
.71741 .69608 0 2.5 Mabsadd L
.71741 .69608 1.875 0 Mabsadd L
.71741 .69608 0 -2.5 Mabsadd L
.71741 .69608 -1.875 0 Mabsadd L closepath F
.72154 .70511 -1.875 0 Mabsadd m
.72154 .70511 0 2.5 Mabsadd L
.72154 .70511 1.875 0 Mabsadd L
.72154 .70511 0 -2.5 Mabsadd L
.72154 .70511 -1.875 0 Mabsadd L closepath F
.7262 .72838 -1.875 0 Mabsadd m
.7262 .72838 0 2.5 Mabsadd L
.7262 .72838 1.875 0 Mabsadd L
.7262 .72838 0 -2.5 Mabsadd L
.7262 .72838 -1.875 0 Mabsadd L closepath F
.73086 .73967 -1.875 0 Mabsadd m
.73086 .73967 0 2.5 Mabsadd L
.73086 .73967 1.875 0 Mabsadd L
.73086 .73967 0 -2.5 Mabsadd L
.73086 .73967 -1.875 0 Mabsadd L closepath F
.73553 .74805 -1.875 0 Mabsadd m
.73553 .74805 0 2.5 Mabsadd L
.73553 .74805 1.875 0 Mabsadd L
.73553 .74805 0 -2.5 Mabsadd L
.73553 .74805 -1.875 0 Mabsadd L closepath F
.74019 .75011 -1.875 0 Mabsadd m
.74019 .75011 0 2.5 Mabsadd L
.74019 .75011 1.875 0 Mabsadd L
.74019 .75011 0 -2.5 Mabsadd L
.74019 .75011 -1.875 0 Mabsadd L closepath F
.74485 .74872 -1.875 0 Mabsadd m
.74485 .74872 0 2.5 Mabsadd L
.74485 .74872 1.875 0 Mabsadd L
.74485 .74872 0 -2.5 Mabsadd L
.74485 .74872 -1.875 0 Mabsadd L closepath F
.74952 .74464 -1.875 0 Mabsadd m
.74952 .74464 0 2.5 Mabsadd L
.74952 .74464 1.875 0 Mabsadd L
.74952 .74464 0 -2.5 Mabsadd L
.74952 .74464 -1.875 0 Mabsadd L closepath F
.75418 .73948 -1.875 0 Mabsadd m
.75418 .73948 0 2.5 Mabsadd L
.75418 .73948 1.875 0 Mabsadd L
.75418 .73948 0 -2.5 Mabsadd L
.75418 .73948 -1.875 0 Mabsadd L closepath F
.75884 .73451 -1.875 0 Mabsadd m
.75884 .73451 0 2.5 Mabsadd L
.75884 .73451 1.875 0 Mabsadd L
.75884 .73451 0 -2.5 Mabsadd L
.75884 .73451 -1.875 0 Mabsadd L closepath F
.76414 .72905 -1.875 0 Mabsadd m
.76414 .72905 0 2.5 Mabsadd L
.76414 .72905 1.875 0 Mabsadd L
.76414 .72905 0 -2.5 Mabsadd L
.76414 .72905 -1.875 0 Mabsadd L closepath F
.76944 .74222 -1.875 0 Mabsadd m
.76944 .74222 0 2.5 Mabsadd L
.76944 .74222 1.875 0 Mabsadd L
.76944 .74222 0 -2.5 Mabsadd L
.76944 .74222 -1.875 0 Mabsadd L closepath F
.77474 .75962 -1.875 0 Mabsadd m
.77474 .75962 0 2.5 Mabsadd L
.77474 .75962 1.875 0 Mabsadd L
.77474 .75962 0 -2.5 Mabsadd L
.77474 .75962 -1.875 0 Mabsadd L closepath F
.78004 .78144 -1.875 0 Mabsadd m
.78004 .78144 0 2.5 Mabsadd L
.78004 .78144 1.875 0 Mabsadd L
.78004 .78144 0 -2.5 Mabsadd L
.78004 .78144 -1.875 0 Mabsadd L closepath F
.78534 .80098 -1.875 0 Mabsadd m
.78534 .80098 0 2.5 Mabsadd L
.78534 .80098 1.875 0 Mabsadd L
.78534 .80098 0 -2.5 Mabsadd L
.78534 .80098 -1.875 0 Mabsadd L closepath F
.79064 .82075 -1.875 0 Mabsadd m
.79064 .82075 0 2.5 Mabsadd L
.79064 .82075 1.875 0 Mabsadd L
.79064 .82075 0 -2.5 Mabsadd L
.79064 .82075 -1.875 0 Mabsadd L closepath F
.79593 .83525 -1.875 0 Mabsadd m
.79593 .83525 0 2.5 Mabsadd L
.79593 .83525 1.875 0 Mabsadd L
.79593 .83525 0 -2.5 Mabsadd L
.79593 .83525 -1.875 0 Mabsadd L closepath F
.80123 .8398 -1.875 0 Mabsadd m
.80123 .8398 0 2.5 Mabsadd L
.80123 .8398 1.875 0 Mabsadd L
.80123 .8398 0 -2.5 Mabsadd L
.80123 .8398 -1.875 0 Mabsadd L closepath F
.80653 .82812 -1.875 0 Mabsadd m
.80653 .82812 0 2.5 Mabsadd L
.80653 .82812 1.875 0 Mabsadd L
.80653 .82812 0 -2.5 Mabsadd L
.80653 .82812 -1.875 0 Mabsadd L closepath F
.81183 .79714 -1.875 0 Mabsadd m
.81183 .79714 0 2.5 Mabsadd L
.81183 .79714 1.875 0 Mabsadd L
.81183 .79714 0 -2.5 Mabsadd L
.81183 .79714 -1.875 0 Mabsadd L closepath F
.81713 .74753 -1.875 0 Mabsadd m
.81713 .74753 0 2.5 Mabsadd L
.81713 .74753 1.875 0 Mabsadd L
.81713 .74753 0 -2.5 Mabsadd L
.81713 .74753 -1.875 0 Mabsadd L closepath F
.82243 .68603 -1.875 0 Mabsadd m
.82243 .68603 0 2.5 Mabsadd L
.82243 .68603 1.875 0 Mabsadd L
.82243 .68603 0 -2.5 Mabsadd L
.82243 .68603 -1.875 0 Mabsadd L closepath F
.82574 .71251 -1.875 0 Mabsadd m
.82574 .71251 0 2.5 Mabsadd L
.82574 .71251 1.875 0 Mabsadd L
.82574 .71251 0 -2.5 Mabsadd L
.82574 .71251 -1.875 0 Mabsadd L closepath F
.82905 .68398 -1.875 0 Mabsadd m
.82905 .68398 0 2.5 Mabsadd L
.82905 .68398 1.875 0 Mabsadd L
.82905 .68398 0 -2.5 Mabsadd L
.82905 .68398 -1.875 0 Mabsadd L closepath F
.83236 .6918 -1.875 0 Mabsadd m
.83236 .6918 0 2.5 Mabsadd L
.83236 .6918 1.875 0 Mabsadd L
.83236 .6918 0 -2.5 Mabsadd L
.83236 .6918 -1.875 0 Mabsadd L closepath F
.83567 .68371 -1.875 0 Mabsadd m
.83567 .68371 0 2.5 Mabsadd L
.83567 .68371 1.875 0 Mabsadd L
.83567 .68371 0 -2.5 Mabsadd L
.83567 .68371 -1.875 0 Mabsadd L closepath F
.83898 .68129 -1.875 0 Mabsadd m
.83898 .68129 0 2.5 Mabsadd L
.83898 .68129 1.875 0 Mabsadd L
.83898 .68129 0 -2.5 Mabsadd L
.83898 .68129 -1.875 0 Mabsadd L closepath F
.84229 .67753 -1.875 0 Mabsadd m
.84229 .67753 0 2.5 Mabsadd L
.84229 .67753 1.875 0 Mabsadd L
.84229 .67753 0 -2.5 Mabsadd L
.84229 .67753 -1.875 0 Mabsadd L closepath F
.8456 .67577 -1.875 0 Mabsadd m
.8456 .67577 0 2.5 Mabsadd L
.8456 .67577 1.875 0 Mabsadd L
.8456 .67577 0 -2.5 Mabsadd L
.8456 .67577 -1.875 0 Mabsadd L closepath F
.84891 .67425 -1.875 0 Mabsadd m
.84891 .67425 0 2.5 Mabsadd L
.84891 .67425 1.875 0 Mabsadd L
.84891 .67425 0 -2.5 Mabsadd L
.84891 .67425 -1.875 0 Mabsadd L closepath F
.85222 .67387 -1.875 0 Mabsadd m
.85222 .67387 0 2.5 Mabsadd L
.85222 .67387 1.875 0 Mabsadd L
.85222 .67387 0 -2.5 Mabsadd L
.85222 .67387 -1.875 0 Mabsadd L closepath F
.85553 .6742 -1.875 0 Mabsadd m
.85553 .6742 0 2.5 Mabsadd L
.85553 .6742 1.875 0 Mabsadd L
.85553 .6742 0 -2.5 Mabsadd L
.85553 .6742 -1.875 0 Mabsadd L closepath F
.85884 .67522 -1.875 0 Mabsadd m
.85884 .67522 0 2.5 Mabsadd L
.85884 .67522 1.875 0 Mabsadd L
.85884 .67522 0 -2.5 Mabsadd L
.85884 .67522 -1.875 0 Mabsadd L closepath F
.86312 .68457 -1.875 0 Mabsadd m
.86312 .68457 0 2.5 Mabsadd L
.86312 .68457 1.875 0 Mabsadd L
.86312 .68457 0 -2.5 Mabsadd L
.86312 .68457 -1.875 0 Mabsadd L closepath F
.86741 .69779 -1.875 0 Mabsadd m
.86741 .69779 0 2.5 Mabsadd L
.86741 .69779 1.875 0 Mabsadd L
.86741 .69779 0 -2.5 Mabsadd L
.86741 .69779 -1.875 0 Mabsadd L closepath F
.87169 .71272 -1.875 0 Mabsadd m
.87169 .71272 0 2.5 Mabsadd L
.87169 .71272 1.875 0 Mabsadd L
.87169 .71272 0 -2.5 Mabsadd L
.87169 .71272 -1.875 0 Mabsadd L closepath F
.87598 .72747 -1.875 0 Mabsadd m
.87598 .72747 0 2.5 Mabsadd L
.87598 .72747 1.875 0 Mabsadd L
.87598 .72747 0 -2.5 Mabsadd L
.87598 .72747 -1.875 0 Mabsadd L closepath F
.88026 .74034 -1.875 0 Mabsadd m
.88026 .74034 0 2.5 Mabsadd L
.88026 .74034 1.875 0 Mabsadd L
.88026 .74034 0 -2.5 Mabsadd L
.88026 .74034 -1.875 0 Mabsadd L closepath F
.88455 .75063 -1.875 0 Mabsadd m
.88455 .75063 0 2.5 Mabsadd L
.88455 .75063 1.875 0 Mabsadd L
.88455 .75063 0 -2.5 Mabsadd L
.88455 .75063 -1.875 0 Mabsadd L closepath F
.88883 .75791 -1.875 0 Mabsadd m
.88883 .75791 0 2.5 Mabsadd L
.88883 .75791 1.875 0 Mabsadd L
.88883 .75791 0 -2.5 Mabsadd L
.88883 .75791 -1.875 0 Mabsadd L closepath F
.89312 .76234 -1.875 0 Mabsadd m
.89312 .76234 0 2.5 Mabsadd L
.89312 .76234 1.875 0 Mabsadd L
.89312 .76234 0 -2.5 Mabsadd L
.89312 .76234 -1.875 0 Mabsadd L closepath F
.89798 .77117 -1.875 0 Mabsadd m
.89798 .77117 0 2.5 Mabsadd L
.89798 .77117 1.875 0 Mabsadd L
.89798 .77117 0 -2.5 Mabsadd L
.89798 .77117 -1.875 0 Mabsadd L closepath F
.90284 .77023 -1.875 0 Mabsadd m
.90284 .77023 0 2.5 Mabsadd L
.90284 .77023 1.875 0 Mabsadd L
.90284 .77023 0 -2.5 Mabsadd L
.90284 .77023 -1.875 0 Mabsadd L closepath F
.9077 .76654 -1.875 0 Mabsadd m
.9077 .76654 0 2.5 Mabsadd L
.9077 .76654 1.875 0 Mabsadd L
.9077 .76654 0 -2.5 Mabsadd L
.9077 .76654 -1.875 0 Mabsadd L closepath F
.91256 .75957 -1.875 0 Mabsadd m
.91256 .75957 0 2.5 Mabsadd L
.91256 .75957 1.875 0 Mabsadd L
.91256 .75957 0 -2.5 Mabsadd L
.91256 .75957 -1.875 0 Mabsadd L closepath F
.91742 .75242 -1.875 0 Mabsadd m
.91742 .75242 0 2.5 Mabsadd L
.91742 .75242 1.875 0 Mabsadd L
.91742 .75242 0 -2.5 Mabsadd L
.91742 .75242 -1.875 0 Mabsadd L closepath F
.92228 .74678 -1.875 0 Mabsadd m
.92228 .74678 0 2.5 Mabsadd L
.92228 .74678 1.875 0 Mabsadd L
.92228 .74678 0 -2.5 Mabsadd L
.92228 .74678 -1.875 0 Mabsadd L closepath F
.92714 .7449 -1.875 0 Mabsadd m
.92714 .7449 0 2.5 Mabsadd L
.92714 .7449 1.875 0 Mabsadd L
.92714 .7449 0 -2.5 Mabsadd L
.92714 .7449 -1.875 0 Mabsadd L closepath F
.932 .74891 -1.875 0 Mabsadd m
.932 .74891 0 2.5 Mabsadd L
.932 .74891 1.875 0 Mabsadd L
.932 .74891 0 -2.5 Mabsadd L
.932 .74891 -1.875 0 Mabsadd L closepath F
.93686 .76084 -1.875 0 Mabsadd m
.93686 .76084 0 2.5 Mabsadd L
.93686 .76084 1.875 0 Mabsadd L
.93686 .76084 0 -2.5 Mabsadd L
.93686 .76084 -1.875 0 Mabsadd L closepath F
.94172 .78233 -1.875 0 Mabsadd m
.94172 .78233 0 2.5 Mabsadd L
.94172 .78233 1.875 0 Mabsadd L
.94172 .78233 0 -2.5 Mabsadd L
.94172 .78233 -1.875 0 Mabsadd L closepath F
.94659 .81404 -1.875 0 Mabsadd m
.94659 .81404 0 2.5 Mabsadd L
.94659 .81404 1.875 0 Mabsadd L
.94659 .81404 0 -2.5 Mabsadd L
.94659 .81404 -1.875 0 Mabsadd L closepath F
.95145 .85509 -1.875 0 Mabsadd m
.95145 .85509 0 2.5 Mabsadd L
.95145 .85509 1.875 0 Mabsadd L
.95145 .85509 0 -2.5 Mabsadd L
.95145 .85509 -1.875 0 Mabsadd L closepath F
.95631 .90243 -1.875 0 Mabsadd m
.95631 .90243 0 2.5 Mabsadd L
.95631 .90243 1.875 0 Mabsadd L
.95631 .90243 0 -2.5 Mabsadd L
.95631 .90243 -1.875 0 Mabsadd L closepath F
.96117 .95057 -1.875 0 Mabsadd m
.96117 .95057 0 2.5 Mabsadd L
.96117 .95057 1.875 0 Mabsadd L
.96117 .95057 0 -2.5 Mabsadd L
.96117 .95057 -1.875 0 Mabsadd L closepath F
.9656 .9562 -1.875 0 Mabsadd m
.9656 .9562 0 2.5 Mabsadd L
.9656 .9562 1.875 0 Mabsadd L
.9656 .9562 0 -2.5 Mabsadd L
.9656 .9562 -1.875 0 Mabsadd L closepath F
.97003 .97619 -1.875 0 Mabsadd m
.97003 .97619 0 2.5 Mabsadd L
.97003 .97619 1.875 0 Mabsadd L
.97003 .97619 0 -2.5 Mabsadd L
.97003 .97619 -1.875 0 Mabsadd L closepath F
.97311 .96191 -1.875 0 Mabsadd m
.97311 .96191 0 2.5 Mabsadd L
.97311 .96191 1.875 0 Mabsadd L
.97311 .96191 0 -2.5 Mabsadd L
.97311 .96191 -1.875 0 Mabsadd L closepath F
.97465 .96864 -1.875 0 Mabsadd m
.97465 .96864 0 2.5 Mabsadd L
.97465 .96864 1.875 0 Mabsadd L
.97465 .96864 0 -2.5 Mabsadd L
.97465 .96864 -1.875 0 Mabsadd L closepath F
.97619 .96215 -1.875 0 Mabsadd m
.97619 .96215 0 2.5 Mabsadd L
.97619 .96215 1.875 0 Mabsadd L
.97619 .96215 0 -2.5 Mabsadd L
.97619 .96215 -1.875 0 Mabsadd L closepath F
0 0 1 r
.02381 .02381 0 2.5 Mabsadd m
.02381 .02381 -0.56518 .7779 Mabsadd L
.02381 .02381 -2.37764 .77254 Mabsadd L
.02381 .02381 -0.91448 -0.29713 Mabsadd L
.02381 .02381 -1.46946 -2.02254 Mabsadd L
.02381 .02381 0 -0.96154 Mabsadd L
.02381 .02381 1.46946 -2.02254 Mabsadd L
.02381 .02381 .91448 -0.29713 Mabsadd L
.02381 .02381 2.37764 .77254 Mabsadd L
.02381 .02381 .56518 .7779 Mabsadd L
.02381 .02381 0 2.5 Mabsadd L closepath F
.02382 .03991 0 2.5 Mabsadd m
.02382 .03991 -0.56518 .7779 Mabsadd L
.02382 .03991 -2.37764 .77254 Mabsadd L
.02382 .03991 -0.91448 -0.29713 Mabsadd L
.02382 .03991 -1.46946 -2.02254 Mabsadd L
.02382 .03991 0 -0.96154 Mabsadd L
.02382 .03991 1.46946 -2.02254 Mabsadd L
.02382 .03991 .91448 -0.29713 Mabsadd L
.02382 .03991 2.37764 .77254 Mabsadd L
.02382 .03991 .56518 .7779 Mabsadd L
.02382 .03991 0 2.5 Mabsadd L closepath F
.02382 .05602 0 2.5 Mabsadd m
.02382 .05602 -0.56518 .7779 Mabsadd L
.02382 .05602 -2.37764 .77254 Mabsadd L
.02382 .05602 -0.91448 -0.29713 Mabsadd L
.02382 .05602 -1.46946 -2.02254 Mabsadd L
.02382 .05602 0 -0.96154 Mabsadd L
.02382 .05602 1.46946 -2.02254 Mabsadd L
.02382 .05602 .91448 -0.29713 Mabsadd L
.02382 .05602 2.37764 .77254 Mabsadd L
.02382 .05602 .56518 .7779 Mabsadd L
.02382 .05602 0 2.5 Mabsadd L closepath F
.02401 .05598 0 2.5 Mabsadd m
.02401 .05598 -0.56518 .7779 Mabsadd L
.02401 .05598 -2.37764 .77254 Mabsadd L
.02401 .05598 -0.91448 -0.29713 Mabsadd L
.02401 .05598 -1.46946 -2.02254 Mabsadd L
.02401 .05598 0 -0.96154 Mabsadd L
.02401 .05598 1.46946 -2.02254 Mabsadd L
.02401 .05598 .91448 -0.29713 Mabsadd L
.02401 .05598 2.37764 .77254 Mabsadd L
.02401 .05598 .56518 .7779 Mabsadd L
.02401 .05598 0 2.5 Mabsadd L closepath F
.02419 .05589 0 2.5 Mabsadd m
.02419 .05589 -0.56518 .7779 Mabsadd L
.02419 .05589 -2.37764 .77254 Mabsadd L
.02419 .05589 -0.91448 -0.29713 Mabsadd L
.02419 .05589 -1.46946 -2.02254 Mabsadd L
.02419 .05589 0 -0.96154 Mabsadd L
.02419 .05589 1.46946 -2.02254 Mabsadd L
.02419 .05589 .91448 -0.29713 Mabsadd L
.02419 .05589 2.37764 .77254 Mabsadd L
.02419 .05589 .56518 .7779 Mabsadd L
.02419 .05589 0 2.5 Mabsadd L closepath F
.02437 .05575 0 2.5 Mabsadd m
.02437 .05575 -0.56518 .7779 Mabsadd L
.02437 .05575 -2.37764 .77254 Mabsadd L
.02437 .05575 -0.91448 -0.29713 Mabsadd L
.02437 .05575 -1.46946 -2.02254 Mabsadd L
.02437 .05575 0 -0.96154 Mabsadd L
.02437 .05575 1.46946 -2.02254 Mabsadd L
.02437 .05575 .91448 -0.29713 Mabsadd L
.02437 .05575 2.37764 .77254 Mabsadd L
.02437 .05575 .56518 .7779 Mabsadd L
.02437 .05575 0 2.5 Mabsadd L closepath F
.02497 .05137 0 2.5 Mabsadd m
.02497 .05137 -0.56518 .7779 Mabsadd L
.02497 .05137 -2.37764 .77254 Mabsadd L
.02497 .05137 -0.91448 -0.29713 Mabsadd L
.02497 .05137 -1.46946 -2.02254 Mabsadd L
.02497 .05137 0 -0.96154 Mabsadd L
.02497 .05137 1.46946 -2.02254 Mabsadd L
.02497 .05137 .91448 -0.29713 Mabsadd L
.02497 .05137 2.37764 .77254 Mabsadd L
.02497 .05137 .56518 .7779 Mabsadd L
.02497 .05137 0 2.5 Mabsadd L closepath F
.02556 .04644 0 2.5 Mabsadd m
.02556 .04644 -0.56518 .7779 Mabsadd L
.02556 .04644 -2.37764 .77254 Mabsadd L
.02556 .04644 -0.91448 -0.29713 Mabsadd L
.02556 .04644 -1.46946 -2.02254 Mabsadd L
.02556 .04644 0 -0.96154 Mabsadd L
.02556 .04644 1.46946 -2.02254 Mabsadd L
.02556 .04644 .91448 -0.29713 Mabsadd L
.02556 .04644 2.37764 .77254 Mabsadd L
.02556 .04644 .56518 .7779 Mabsadd L
.02556 .04644 0 2.5 Mabsadd L closepath F
.02616 .04147 0 2.5 Mabsadd m
.02616 .04147 -0.56518 .7779 Mabsadd L
.02616 .04147 -2.37764 .77254 Mabsadd L
.02616 .04147 -0.91448 -0.29713 Mabsadd L
.02616 .04147 -1.46946 -2.02254 Mabsadd L
.02616 .04147 0 -0.96154 Mabsadd L
.02616 .04147 1.46946 -2.02254 Mabsadd L
.02616 .04147 .91448 -0.29713 Mabsadd L
.02616 .04147 2.37764 .77254 Mabsadd L
.02616 .04147 .56518 .7779 Mabsadd L
.02616 .04147 0 2.5 Mabsadd L closepath F
.02676 .03651 0 2.5 Mabsadd m
.02676 .03651 -0.56518 .7779 Mabsadd L
.02676 .03651 -2.37764 .77254 Mabsadd L
.02676 .03651 -0.91448 -0.29713 Mabsadd L
.02676 .03651 -1.46946 -2.02254 Mabsadd L
.02676 .03651 0 -0.96154 Mabsadd L
.02676 .03651 1.46946 -2.02254 Mabsadd L
.02676 .03651 .91448 -0.29713 Mabsadd L
.02676 .03651 2.37764 .77254 Mabsadd L
.02676 .03651 .56518 .7779 Mabsadd L
.02676 .03651 0 2.5 Mabsadd L closepath F
.02795 .0368 0 2.5 Mabsadd m
.02795 .0368 -0.56518 .7779 Mabsadd L
.02795 .0368 -2.37764 .77254 Mabsadd L
.02795 .0368 -0.91448 -0.29713 Mabsadd L
.02795 .0368 -1.46946 -2.02254 Mabsadd L
.02795 .0368 0 -0.96154 Mabsadd L
.02795 .0368 1.46946 -2.02254 Mabsadd L
.02795 .0368 .91448 -0.29713 Mabsadd L
.02795 .0368 2.37764 .77254 Mabsadd L
.02795 .0368 .56518 .7779 Mabsadd L
.02795 .0368 0 2.5 Mabsadd L closepath F
.02914 .05052 0 2.5 Mabsadd m
.02914 .05052 -0.56518 .7779 Mabsadd L
.02914 .05052 -2.37764 .77254 Mabsadd L
.02914 .05052 -0.91448 -0.29713 Mabsadd L
.02914 .05052 -1.46946 -2.02254 Mabsadd L
.02914 .05052 0 -0.96154 Mabsadd L
.02914 .05052 1.46946 -2.02254 Mabsadd L
.02914 .05052 .91448 -0.29713 Mabsadd L
.02914 .05052 2.37764 .77254 Mabsadd L
.02914 .05052 .56518 .7779 Mabsadd L
.02914 .05052 0 2.5 Mabsadd L closepath F
.03034 .05122 0 2.5 Mabsadd m
.03034 .05122 -0.56518 .7779 Mabsadd L
.03034 .05122 -2.37764 .77254 Mabsadd L
.03034 .05122 -0.91448 -0.29713 Mabsadd L
.03034 .05122 -1.46946 -2.02254 Mabsadd L
.03034 .05122 0 -0.96154 Mabsadd L
.03034 .05122 1.46946 -2.02254 Mabsadd L
.03034 .05122 .91448 -0.29713 Mabsadd L
.03034 .05122 2.37764 .77254 Mabsadd L
.03034 .05122 .56518 .7779 Mabsadd L
.03034 .05122 0 2.5 Mabsadd L closepath F
.03153 .05205 0 2.5 Mabsadd m
.03153 .05205 -0.56518 .7779 Mabsadd L
.03153 .05205 -2.37764 .77254 Mabsadd L
.03153 .05205 -0.91448 -0.29713 Mabsadd L
.03153 .05205 -1.46946 -2.02254 Mabsadd L
.03153 .05205 0 -0.96154 Mabsadd L
.03153 .05205 1.46946 -2.02254 Mabsadd L
.03153 .05205 .91448 -0.29713 Mabsadd L
.03153 .05205 2.37764 .77254 Mabsadd L
.03153 .05205 .56518 .7779 Mabsadd L
.03153 .05205 0 2.5 Mabsadd L closepath F
.03273 .05302 0 2.5 Mabsadd m
.03273 .05302 -0.56518 .7779 Mabsadd L
.03273 .05302 -2.37764 .77254 Mabsadd L
.03273 .05302 -0.91448 -0.29713 Mabsadd L
.03273 .05302 -1.46946 -2.02254 Mabsadd L
.03273 .05302 0 -0.96154 Mabsadd L
.03273 .05302 1.46946 -2.02254 Mabsadd L
.03273 .05302 .91448 -0.29713 Mabsadd L
.03273 .05302 2.37764 .77254 Mabsadd L
.03273 .05302 .56518 .7779 Mabsadd L
.03273 .05302 0 2.5 Mabsadd L closepath F
.03519 .07062 0 2.5 Mabsadd m
.03519 .07062 -0.56518 .7779 Mabsadd L
.03519 .07062 -2.37764 .77254 Mabsadd L
.03519 .07062 -0.91448 -0.29713 Mabsadd L
.03519 .07062 -1.46946 -2.02254 Mabsadd L
.03519 .07062 0 -0.96154 Mabsadd L
.03519 .07062 1.46946 -2.02254 Mabsadd L
.03519 .07062 .91448 -0.29713 Mabsadd L
.03519 .07062 2.37764 .77254 Mabsadd L
.03519 .07062 .56518 .7779 Mabsadd L
.03519 .07062 0 2.5 Mabsadd L closepath F
.03766 .07154 0 2.5 Mabsadd m
.03766 .07154 -0.56518 .7779 Mabsadd L
.03766 .07154 -2.37764 .77254 Mabsadd L
.03766 .07154 -0.91448 -0.29713 Mabsadd L
.03766 .07154 -1.46946 -2.02254 Mabsadd L
.03766 .07154 0 -0.96154 Mabsadd L
.03766 .07154 1.46946 -2.02254 Mabsadd L
.03766 .07154 .91448 -0.29713 Mabsadd L
.03766 .07154 2.37764 .77254 Mabsadd L
.03766 .07154 .56518 .7779 Mabsadd L
.03766 .07154 0 2.5 Mabsadd L closepath F
.04013 .0791 0 2.5 Mabsadd m
.04013 .0791 -0.56518 .7779 Mabsadd L
.04013 .0791 -2.37764 .77254 Mabsadd L
.04013 .0791 -0.91448 -0.29713 Mabsadd L
.04013 .0791 -1.46946 -2.02254 Mabsadd L
.04013 .0791 0 -0.96154 Mabsadd L
.04013 .0791 1.46946 -2.02254 Mabsadd L
.04013 .0791 .91448 -0.29713 Mabsadd L
.04013 .0791 2.37764 .77254 Mabsadd L
.04013 .0791 .56518 .7779 Mabsadd L
.04013 .0791 0 2.5 Mabsadd L closepath F
.0426 .08692 0 2.5 Mabsadd m
.0426 .08692 -0.56518 .7779 Mabsadd L
.0426 .08692 -2.37764 .77254 Mabsadd L
.0426 .08692 -0.91448 -0.29713 Mabsadd L
.0426 .08692 -1.46946 -2.02254 Mabsadd L
.0426 .08692 0 -0.96154 Mabsadd L
.0426 .08692 1.46946 -2.02254 Mabsadd L
.0426 .08692 .91448 -0.29713 Mabsadd L
.0426 .08692 2.37764 .77254 Mabsadd L
.0426 .08692 .56518 .7779 Mabsadd L
.0426 .08692 0 2.5 Mabsadd L closepath F
.04506 .09343 0 2.5 Mabsadd m
.04506 .09343 -0.56518 .7779 Mabsadd L
.04506 .09343 -2.37764 .77254 Mabsadd L
.04506 .09343 -0.91448 -0.29713 Mabsadd L
.04506 .09343 -1.46946 -2.02254 Mabsadd L
.04506 .09343 0 -0.96154 Mabsadd L
.04506 .09343 1.46946 -2.02254 Mabsadd L
.04506 .09343 .91448 -0.29713 Mabsadd L
.04506 .09343 2.37764 .77254 Mabsadd L
.04506 .09343 .56518 .7779 Mabsadd L
.04506 .09343 0 2.5 Mabsadd L closepath F
.04753 .09859 0 2.5 Mabsadd m
.04753 .09859 -0.56518 .7779 Mabsadd L
.04753 .09859 -2.37764 .77254 Mabsadd L
.04753 .09859 -0.91448 -0.29713 Mabsadd L
.04753 .09859 -1.46946 -2.02254 Mabsadd L
.04753 .09859 0 -0.96154 Mabsadd L
.04753 .09859 1.46946 -2.02254 Mabsadd L
.04753 .09859 .91448 -0.29713 Mabsadd L
.04753 .09859 2.37764 .77254 Mabsadd L
.04753 .09859 .56518 .7779 Mabsadd L
.04753 .09859 0 2.5 Mabsadd L closepath F
.05065 .1049 0 2.5 Mabsadd m
.05065 .1049 -0.56518 .7779 Mabsadd L
.05065 .1049 -2.37764 .77254 Mabsadd L
.05065 .1049 -0.91448 -0.29713 Mabsadd L
.05065 .1049 -1.46946 -2.02254 Mabsadd L
.05065 .1049 0 -0.96154 Mabsadd L
.05065 .1049 1.46946 -2.02254 Mabsadd L
.05065 .1049 .91448 -0.29713 Mabsadd L
.05065 .1049 2.37764 .77254 Mabsadd L
.05065 .1049 .56518 .7779 Mabsadd L
.05065 .1049 0 2.5 Mabsadd L closepath F
.05377 .08392 0 2.5 Mabsadd m
.05377 .08392 -0.56518 .7779 Mabsadd L
.05377 .08392 -2.37764 .77254 Mabsadd L
.05377 .08392 -0.91448 -0.29713 Mabsadd L
.05377 .08392 -1.46946 -2.02254 Mabsadd L
.05377 .08392 0 -0.96154 Mabsadd L
.05377 .08392 1.46946 -2.02254 Mabsadd L
.05377 .08392 .91448 -0.29713 Mabsadd L
.05377 .08392 2.37764 .77254 Mabsadd L
.05377 .08392 .56518 .7779 Mabsadd L
.05377 .08392 0 2.5 Mabsadd L closepath F
.05688 .07274 0 2.5 Mabsadd m
.05688 .07274 -0.56518 .7779 Mabsadd L
.05688 .07274 -2.37764 .77254 Mabsadd L
.05688 .07274 -0.91448 -0.29713 Mabsadd L
.05688 .07274 -1.46946 -2.02254 Mabsadd L
.05688 .07274 0 -0.96154 Mabsadd L
.05688 .07274 1.46946 -2.02254 Mabsadd L
.05688 .07274 .91448 -0.29713 Mabsadd L
.05688 .07274 2.37764 .77254 Mabsadd L
.05688 .07274 .56518 .7779 Mabsadd L
.05688 .07274 0 2.5 Mabsadd L closepath F
.06 .06682 0 2.5 Mabsadd m
.06 .06682 -0.56518 .7779 Mabsadd L
.06 .06682 -2.37764 .77254 Mabsadd L
.06 .06682 -0.91448 -0.29713 Mabsadd L
.06 .06682 -1.46946 -2.02254 Mabsadd L
.06 .06682 0 -0.96154 Mabsadd L
.06 .06682 1.46946 -2.02254 Mabsadd L
.06 .06682 .91448 -0.29713 Mabsadd L
.06 .06682 2.37764 .77254 Mabsadd L
.06 .06682 .56518 .7779 Mabsadd L
.06 .06682 0 2.5 Mabsadd L closepath F
.06312 .06238 0 2.5 Mabsadd m
.06312 .06238 -0.56518 .7779 Mabsadd L
.06312 .06238 -2.37764 .77254 Mabsadd L
.06312 .06238 -0.91448 -0.29713 Mabsadd L
.06312 .06238 -1.46946 -2.02254 Mabsadd L
.06312 .06238 0 -0.96154 Mabsadd L
.06312 .06238 1.46946 -2.02254 Mabsadd L
.06312 .06238 .91448 -0.29713 Mabsadd L
.06312 .06238 2.37764 .77254 Mabsadd L
.06312 .06238 .56518 .7779 Mabsadd L
.06312 .06238 0 2.5 Mabsadd L closepath F
.06624 .05862 0 2.5 Mabsadd m
.06624 .05862 -0.56518 .7779 Mabsadd L
.06624 .05862 -2.37764 .77254 Mabsadd L
.06624 .05862 -0.91448 -0.29713 Mabsadd L
.06624 .05862 -1.46946 -2.02254 Mabsadd L
.06624 .05862 0 -0.96154 Mabsadd L
.06624 .05862 1.46946 -2.02254 Mabsadd L
.06624 .05862 .91448 -0.29713 Mabsadd L
.06624 .05862 2.37764 .77254 Mabsadd L
.06624 .05862 .56518 .7779 Mabsadd L
.06624 .05862 0 2.5 Mabsadd L closepath F
.06935 .0558 0 2.5 Mabsadd m
.06935 .0558 -0.56518 .7779 Mabsadd L
.06935 .0558 -2.37764 .77254 Mabsadd L
.06935 .0558 -0.91448 -0.29713 Mabsadd L
.06935 .0558 -1.46946 -2.02254 Mabsadd L
.06935 .0558 0 -0.96154 Mabsadd L
.06935 .0558 1.46946 -2.02254 Mabsadd L
.06935 .0558 .91448 -0.29713 Mabsadd L
.06935 .0558 2.37764 .77254 Mabsadd L
.06935 .0558 .56518 .7779 Mabsadd L
.06935 .0558 0 2.5 Mabsadd L closepath F
.07323 .04994 0 2.5 Mabsadd m
.07323 .04994 -0.56518 .7779 Mabsadd L
.07323 .04994 -2.37764 .77254 Mabsadd L
.07323 .04994 -0.91448 -0.29713 Mabsadd L
.07323 .04994 -1.46946 -2.02254 Mabsadd L
.07323 .04994 0 -0.96154 Mabsadd L
.07323 .04994 1.46946 -2.02254 Mabsadd L
.07323 .04994 .91448 -0.29713 Mabsadd L
.07323 .04994 2.37764 .77254 Mabsadd L
.07323 .04994 .56518 .7779 Mabsadd L
.07323 .04994 0 2.5 Mabsadd L closepath F
.07711 .06053 0 2.5 Mabsadd m
.07711 .06053 -0.56518 .7779 Mabsadd L
.07711 .06053 -2.37764 .77254 Mabsadd L
.07711 .06053 -0.91448 -0.29713 Mabsadd L
.07711 .06053 -1.46946 -2.02254 Mabsadd L
.07711 .06053 0 -0.96154 Mabsadd L
.07711 .06053 1.46946 -2.02254 Mabsadd L
.07711 .06053 .91448 -0.29713 Mabsadd L
.07711 .06053 2.37764 .77254 Mabsadd L
.07711 .06053 .56518 .7779 Mabsadd L
.07711 .06053 0 2.5 Mabsadd L closepath F
.08099 .0699 0 2.5 Mabsadd m
.08099 .0699 -0.56518 .7779 Mabsadd L
.08099 .0699 -2.37764 .77254 Mabsadd L
.08099 .0699 -0.91448 -0.29713 Mabsadd L
.08099 .0699 -1.46946 -2.02254 Mabsadd L
.08099 .0699 0 -0.96154 Mabsadd L
.08099 .0699 1.46946 -2.02254 Mabsadd L
.08099 .0699 .91448 -0.29713 Mabsadd L
.08099 .0699 2.37764 .77254 Mabsadd L
.08099 .0699 .56518 .7779 Mabsadd L
.08099 .0699 0 2.5 Mabsadd L closepath F
.08487 .07428 0 2.5 Mabsadd m
.08487 .07428 -0.56518 .7779 Mabsadd L
.08487 .07428 -2.37764 .77254 Mabsadd L
.08487 .07428 -0.91448 -0.29713 Mabsadd L
.08487 .07428 -1.46946 -2.02254 Mabsadd L
.08487 .07428 0 -0.96154 Mabsadd L
.08487 .07428 1.46946 -2.02254 Mabsadd L
.08487 .07428 .91448 -0.29713 Mabsadd L
.08487 .07428 2.37764 .77254 Mabsadd L
.08487 .07428 .56518 .7779 Mabsadd L
.08487 .07428 0 2.5 Mabsadd L closepath F
.08874 .07602 0 2.5 Mabsadd m
.08874 .07602 -0.56518 .7779 Mabsadd L
.08874 .07602 -2.37764 .77254 Mabsadd L
.08874 .07602 -0.91448 -0.29713 Mabsadd L
.08874 .07602 -1.46946 -2.02254 Mabsadd L
.08874 .07602 0 -0.96154 Mabsadd L
.08874 .07602 1.46946 -2.02254 Mabsadd L
.08874 .07602 .91448 -0.29713 Mabsadd L
.08874 .07602 2.37764 .77254 Mabsadd L
.08874 .07602 .56518 .7779 Mabsadd L
.08874 .07602 0 2.5 Mabsadd L closepath F
.09262 .07711 0 2.5 Mabsadd m
.09262 .07711 -0.56518 .7779 Mabsadd L
.09262 .07711 -2.37764 .77254 Mabsadd L
.09262 .07711 -0.91448 -0.29713 Mabsadd L
.09262 .07711 -1.46946 -2.02254 Mabsadd L
.09262 .07711 0 -0.96154 Mabsadd L
.09262 .07711 1.46946 -2.02254 Mabsadd L
.09262 .07711 .91448 -0.29713 Mabsadd L
.09262 .07711 2.37764 .77254 Mabsadd L
.09262 .07711 .56518 .7779 Mabsadd L
.09262 .07711 0 2.5 Mabsadd L closepath F
.0965 .07745 0 2.5 Mabsadd m
.0965 .07745 -0.56518 .7779 Mabsadd L
.0965 .07745 -2.37764 .77254 Mabsadd L
.0965 .07745 -0.91448 -0.29713 Mabsadd L
.0965 .07745 -1.46946 -2.02254 Mabsadd L
.0965 .07745 0 -0.96154 Mabsadd L
.0965 .07745 1.46946 -2.02254 Mabsadd L
.0965 .07745 .91448 -0.29713 Mabsadd L
.0965 .07745 2.37764 .77254 Mabsadd L
.0965 .07745 .56518 .7779 Mabsadd L
.0965 .07745 0 2.5 Mabsadd L closepath F
.10038 .07726 0 2.5 Mabsadd m
.10038 .07726 -0.56518 .7779 Mabsadd L
.10038 .07726 -2.37764 .77254 Mabsadd L
.10038 .07726 -0.91448 -0.29713 Mabsadd L
.10038 .07726 -1.46946 -2.02254 Mabsadd L
.10038 .07726 0 -0.96154 Mabsadd L
.10038 .07726 1.46946 -2.02254 Mabsadd L
.10038 .07726 .91448 -0.29713 Mabsadd L
.10038 .07726 2.37764 .77254 Mabsadd L
.10038 .07726 .56518 .7779 Mabsadd L
.10038 .07726 0 2.5 Mabsadd L closepath F
.10546 .07375 0 2.5 Mabsadd m
.10546 .07375 -0.56518 .7779 Mabsadd L
.10546 .07375 -2.37764 .77254 Mabsadd L
.10546 .07375 -0.91448 -0.29713 Mabsadd L
.10546 .07375 -1.46946 -2.02254 Mabsadd L
.10546 .07375 0 -0.96154 Mabsadd L
.10546 .07375 1.46946 -2.02254 Mabsadd L
.10546 .07375 .91448 -0.29713 Mabsadd L
.10546 .07375 2.37764 .77254 Mabsadd L
.10546 .07375 .56518 .7779 Mabsadd L
.10546 .07375 0 2.5 Mabsadd L closepath F
.11053 .06672 0 2.5 Mabsadd m
.11053 .06672 -0.56518 .7779 Mabsadd L
.11053 .06672 -2.37764 .77254 Mabsadd L
.11053 .06672 -0.91448 -0.29713 Mabsadd L
.11053 .06672 -1.46946 -2.02254 Mabsadd L
.11053 .06672 0 -0.96154 Mabsadd L
.11053 .06672 1.46946 -2.02254 Mabsadd L
.11053 .06672 .91448 -0.29713 Mabsadd L
.11053 .06672 2.37764 .77254 Mabsadd L
.11053 .06672 .56518 .7779 Mabsadd L
.11053 .06672 0 2.5 Mabsadd L closepath F
.11561 .05785 0 2.5 Mabsadd m
.11561 .05785 -0.56518 .7779 Mabsadd L
.11561 .05785 -2.37764 .77254 Mabsadd L
.11561 .05785 -0.91448 -0.29713 Mabsadd L
.11561 .05785 -1.46946 -2.02254 Mabsadd L
.11561 .05785 0 -0.96154 Mabsadd L
.11561 .05785 1.46946 -2.02254 Mabsadd L
.11561 .05785 .91448 -0.29713 Mabsadd L
.11561 .05785 2.37764 .77254 Mabsadd L
.11561 .05785 .56518 .7779 Mabsadd L
.11561 .05785 0 2.5 Mabsadd L closepath F
.12069 .04908 0 2.5 Mabsadd m
.12069 .04908 -0.56518 .7779 Mabsadd L
.12069 .04908 -2.37764 .77254 Mabsadd L
.12069 .04908 -0.91448 -0.29713 Mabsadd L
.12069 .04908 -1.46946 -2.02254 Mabsadd L
.12069 .04908 0 -0.96154 Mabsadd L
.12069 .04908 1.46946 -2.02254 Mabsadd L
.12069 .04908 .91448 -0.29713 Mabsadd L
.12069 .04908 2.37764 .77254 Mabsadd L
.12069 .04908 .56518 .7779 Mabsadd L
.12069 .04908 0 2.5 Mabsadd L closepath F
.12577 .04233 0 2.5 Mabsadd m
.12577 .04233 -0.56518 .7779 Mabsadd L
.12577 .04233 -2.37764 .77254 Mabsadd L
.12577 .04233 -0.91448 -0.29713 Mabsadd L
.12577 .04233 -1.46946 -2.02254 Mabsadd L
.12577 .04233 0 -0.96154 Mabsadd L
.12577 .04233 1.46946 -2.02254 Mabsadd L
.12577 .04233 .91448 -0.29713 Mabsadd L
.12577 .04233 2.37764 .77254 Mabsadd L
.12577 .04233 .56518 .7779 Mabsadd L
.12577 .04233 0 2.5 Mabsadd L closepath F
.13085 .03958 0 2.5 Mabsadd m
.13085 .03958 -0.56518 .7779 Mabsadd L
.13085 .03958 -2.37764 .77254 Mabsadd L
.13085 .03958 -0.91448 -0.29713 Mabsadd L
.13085 .03958 -1.46946 -2.02254 Mabsadd L
.13085 .03958 0 -0.96154 Mabsadd L
.13085 .03958 1.46946 -2.02254 Mabsadd L
.13085 .03958 .91448 -0.29713 Mabsadd L
.13085 .03958 2.37764 .77254 Mabsadd L
.13085 .03958 .56518 .7779 Mabsadd L
.13085 .03958 0 2.5 Mabsadd L closepath F
.13593 .04283 0 2.5 Mabsadd m
.13593 .04283 -0.56518 .7779 Mabsadd L
.13593 .04283 -2.37764 .77254 Mabsadd L
.13593 .04283 -0.91448 -0.29713 Mabsadd L
.13593 .04283 -1.46946 -2.02254 Mabsadd L
.13593 .04283 0 -0.96154 Mabsadd L
.13593 .04283 1.46946 -2.02254 Mabsadd L
.13593 .04283 .91448 -0.29713 Mabsadd L
.13593 .04283 2.37764 .77254 Mabsadd L
.13593 .04283 .56518 .7779 Mabsadd L
.13593 .04283 0 2.5 Mabsadd L closepath F
.141 .05395 0 2.5 Mabsadd m
.141 .05395 -0.56518 .7779 Mabsadd L
.141 .05395 -2.37764 .77254 Mabsadd L
.141 .05395 -0.91448 -0.29713 Mabsadd L
.141 .05395 -1.46946 -2.02254 Mabsadd L
.141 .05395 0 -0.96154 Mabsadd L
.141 .05395 1.46946 -2.02254 Mabsadd L
.141 .05395 .91448 -0.29713 Mabsadd L
.141 .05395 2.37764 .77254 Mabsadd L
.141 .05395 .56518 .7779 Mabsadd L
.141 .05395 0 2.5 Mabsadd L closepath F
.14608 .07423 0 2.5 Mabsadd m
.14608 .07423 -0.56518 .7779 Mabsadd L
.14608 .07423 -2.37764 .77254 Mabsadd L
.14608 .07423 -0.91448 -0.29713 Mabsadd L
.14608 .07423 -1.46946 -2.02254 Mabsadd L
.14608 .07423 0 -0.96154 Mabsadd L
.14608 .07423 1.46946 -2.02254 Mabsadd L
.14608 .07423 .91448 -0.29713 Mabsadd L
.14608 .07423 2.37764 .77254 Mabsadd L
.14608 .07423 .56518 .7779 Mabsadd L
.14608 .07423 0 2.5 Mabsadd L closepath F
.15116 .10385 0 2.5 Mabsadd m
.15116 .10385 -0.56518 .7779 Mabsadd L
.15116 .10385 -2.37764 .77254 Mabsadd L
.15116 .10385 -0.91448 -0.29713 Mabsadd L
.15116 .10385 -1.46946 -2.02254 Mabsadd L
.15116 .10385 0 -0.96154 Mabsadd L
.15116 .10385 1.46946 -2.02254 Mabsadd L
.15116 .10385 .91448 -0.29713 Mabsadd L
.15116 .10385 2.37764 .77254 Mabsadd L
.15116 .10385 .56518 .7779 Mabsadd L
.15116 .10385 0 2.5 Mabsadd L closepath F
.15624 .14112 0 2.5 Mabsadd m
.15624 .14112 -0.56518 .7779 Mabsadd L
.15624 .14112 -2.37764 .77254 Mabsadd L
.15624 .14112 -0.91448 -0.29713 Mabsadd L
.15624 .14112 -1.46946 -2.02254 Mabsadd L
.15624 .14112 0 -0.96154 Mabsadd L
.15624 .14112 1.46946 -2.02254 Mabsadd L
.15624 .14112 .91448 -0.29713 Mabsadd L
.15624 .14112 2.37764 .77254 Mabsadd L
.15624 .14112 .56518 .7779 Mabsadd L
.15624 .14112 0 2.5 Mabsadd L closepath F
.16132 .18207 0 2.5 Mabsadd m
.16132 .18207 -0.56518 .7779 Mabsadd L
.16132 .18207 -2.37764 .77254 Mabsadd L
.16132 .18207 -0.91448 -0.29713 Mabsadd L
.16132 .18207 -1.46946 -2.02254 Mabsadd L
.16132 .18207 0 -0.96154 Mabsadd L
.16132 .18207 1.46946 -2.02254 Mabsadd L
.16132 .18207 .91448 -0.29713 Mabsadd L
.16132 .18207 2.37764 .77254 Mabsadd L
.16132 .18207 .56518 .7779 Mabsadd L
.16132 .18207 0 2.5 Mabsadd L closepath F
.1664 .22034 0 2.5 Mabsadd m
.1664 .22034 -0.56518 .7779 Mabsadd L
.1664 .22034 -2.37764 .77254 Mabsadd L
.1664 .22034 -0.91448 -0.29713 Mabsadd L
.1664 .22034 -1.46946 -2.02254 Mabsadd L
.1664 .22034 0 -0.96154 Mabsadd L
.1664 .22034 1.46946 -2.02254 Mabsadd L
.1664 .22034 .91448 -0.29713 Mabsadd L
.1664 .22034 2.37764 .77254 Mabsadd L
.1664 .22034 .56518 .7779 Mabsadd L
.1664 .22034 0 2.5 Mabsadd L closepath F
.17148 .24796 0 2.5 Mabsadd m
.17148 .24796 -0.56518 .7779 Mabsadd L
.17148 .24796 -2.37764 .77254 Mabsadd L
.17148 .24796 -0.91448 -0.29713 Mabsadd L
.17148 .24796 -1.46946 -2.02254 Mabsadd L
.17148 .24796 0 -0.96154 Mabsadd L
.17148 .24796 1.46946 -2.02254 Mabsadd L
.17148 .24796 .91448 -0.29713 Mabsadd L
.17148 .24796 2.37764 .77254 Mabsadd L
.17148 .24796 .56518 .7779 Mabsadd L
.17148 .24796 0 2.5 Mabsadd L closepath F
.17555 .2333 0 2.5 Mabsadd m
.17555 .2333 -0.56518 .7779 Mabsadd L
.17555 .2333 -2.37764 .77254 Mabsadd L
.17555 .2333 -0.91448 -0.29713 Mabsadd L
.17555 .2333 -1.46946 -2.02254 Mabsadd L
.17555 .2333 0 -0.96154 Mabsadd L
.17555 .2333 1.46946 -2.02254 Mabsadd L
.17555 .2333 .91448 -0.29713 Mabsadd L
.17555 .2333 2.37764 .77254 Mabsadd L
.17555 .2333 .56518 .7779 Mabsadd L
.17555 .2333 0 2.5 Mabsadd L closepath F
.17962 .24107 0 2.5 Mabsadd m
.17962 .24107 -0.56518 .7779 Mabsadd L
.17962 .24107 -2.37764 .77254 Mabsadd L
.17962 .24107 -0.91448 -0.29713 Mabsadd L
.17962 .24107 -1.46946 -2.02254 Mabsadd L
.17962 .24107 0 -0.96154 Mabsadd L
.17962 .24107 1.46946 -2.02254 Mabsadd L
.17962 .24107 .91448 -0.29713 Mabsadd L
.17962 .24107 2.37764 .77254 Mabsadd L
.17962 .24107 .56518 .7779 Mabsadd L
.17962 .24107 0 2.5 Mabsadd L closepath F
.1837 .22755 0 2.5 Mabsadd m
.1837 .22755 -0.56518 .7779 Mabsadd L
.1837 .22755 -2.37764 .77254 Mabsadd L
.1837 .22755 -0.91448 -0.29713 Mabsadd L
.1837 .22755 -1.46946 -2.02254 Mabsadd L
.1837 .22755 0 -0.96154 Mabsadd L
.1837 .22755 1.46946 -2.02254 Mabsadd L
.1837 .22755 .91448 -0.29713 Mabsadd L
.1837 .22755 2.37764 .77254 Mabsadd L
.1837 .22755 .56518 .7779 Mabsadd L
.1837 .22755 0 2.5 Mabsadd L closepath F
.18777 .22032 0 2.5 Mabsadd m
.18777 .22032 -0.56518 .7779 Mabsadd L
.18777 .22032 -2.37764 .77254 Mabsadd L
.18777 .22032 -0.91448 -0.29713 Mabsadd L
.18777 .22032 -1.46946 -2.02254 Mabsadd L
.18777 .22032 0 -0.96154 Mabsadd L
.18777 .22032 1.46946 -2.02254 Mabsadd L
.18777 .22032 .91448 -0.29713 Mabsadd L
.18777 .22032 2.37764 .77254 Mabsadd L
.18777 .22032 .56518 .7779 Mabsadd L
.18777 .22032 0 2.5 Mabsadd L closepath F
.19185 .20653 0 2.5 Mabsadd m
.19185 .20653 -0.56518 .7779 Mabsadd L
.19185 .20653 -2.37764 .77254 Mabsadd L
.19185 .20653 -0.91448 -0.29713 Mabsadd L
.19185 .20653 -1.46946 -2.02254 Mabsadd L
.19185 .20653 0 -0.96154 Mabsadd L
.19185 .20653 1.46946 -2.02254 Mabsadd L
.19185 .20653 .91448 -0.29713 Mabsadd L
.19185 .20653 2.37764 .77254 Mabsadd L
.19185 .20653 .56518 .7779 Mabsadd L
.19185 .20653 0 2.5 Mabsadd L closepath F
.19592 .19472 0 2.5 Mabsadd m
.19592 .19472 -0.56518 .7779 Mabsadd L
.19592 .19472 -2.37764 .77254 Mabsadd L
.19592 .19472 -0.91448 -0.29713 Mabsadd L
.19592 .19472 -1.46946 -2.02254 Mabsadd L
.19592 .19472 0 -0.96154 Mabsadd L
.19592 .19472 1.46946 -2.02254 Mabsadd L
.19592 .19472 .91448 -0.29713 Mabsadd L
.19592 .19472 2.37764 .77254 Mabsadd L
.19592 .19472 .56518 .7779 Mabsadd L
.19592 .19472 0 2.5 Mabsadd L closepath F
.2 .1819 0 2.5 Mabsadd m
.2 .1819 -0.56518 .7779 Mabsadd L
.2 .1819 -2.37764 .77254 Mabsadd L
.2 .1819 -0.91448 -0.29713 Mabsadd L
.2 .1819 -1.46946 -2.02254 Mabsadd L
.2 .1819 0 -0.96154 Mabsadd L
.2 .1819 1.46946 -2.02254 Mabsadd L
.2 .1819 .91448 -0.29713 Mabsadd L
.2 .1819 2.37764 .77254 Mabsadd L
.2 .1819 .56518 .7779 Mabsadd L
.2 .1819 0 2.5 Mabsadd L closepath F
.20407 .17211 0 2.5 Mabsadd m
.20407 .17211 -0.56518 .7779 Mabsadd L
.20407 .17211 -2.37764 .77254 Mabsadd L
.20407 .17211 -0.91448 -0.29713 Mabsadd L
.20407 .17211 -1.46946 -2.02254 Mabsadd L
.20407 .17211 0 -0.96154 Mabsadd L
.20407 .17211 1.46946 -2.02254 Mabsadd L
.20407 .17211 .91448 -0.29713 Mabsadd L
.20407 .17211 2.37764 .77254 Mabsadd L
.20407 .17211 .56518 .7779 Mabsadd L
.20407 .17211 0 2.5 Mabsadd L closepath F
.20815 .16476 0 2.5 Mabsadd m
.20815 .16476 -0.56518 .7779 Mabsadd L
.20815 .16476 -2.37764 .77254 Mabsadd L
.20815 .16476 -0.91448 -0.29713 Mabsadd L
.20815 .16476 -1.46946 -2.02254 Mabsadd L
.20815 .16476 0 -0.96154 Mabsadd L
.20815 .16476 1.46946 -2.02254 Mabsadd L
.20815 .16476 .91448 -0.29713 Mabsadd L
.20815 .16476 2.37764 .77254 Mabsadd L
.20815 .16476 .56518 .7779 Mabsadd L
.20815 .16476 0 2.5 Mabsadd L closepath F
.21222 .16113 0 2.5 Mabsadd m
.21222 .16113 -0.56518 .7779 Mabsadd L
.21222 .16113 -2.37764 .77254 Mabsadd L
.21222 .16113 -0.91448 -0.29713 Mabsadd L
.21222 .16113 -1.46946 -2.02254 Mabsadd L
.21222 .16113 0 -0.96154 Mabsadd L
.21222 .16113 1.46946 -2.02254 Mabsadd L
.21222 .16113 .91448 -0.29713 Mabsadd L
.21222 .16113 2.37764 .77254 Mabsadd L
.21222 .16113 .56518 .7779 Mabsadd L
.21222 .16113 0 2.5 Mabsadd L closepath F
.21629 .16072 0 2.5 Mabsadd m
.21629 .16072 -0.56518 .7779 Mabsadd L
.21629 .16072 -2.37764 .77254 Mabsadd L
.21629 .16072 -0.91448 -0.29713 Mabsadd L
.21629 .16072 -1.46946 -2.02254 Mabsadd L
.21629 .16072 0 -0.96154 Mabsadd L
.21629 .16072 1.46946 -2.02254 Mabsadd L
.21629 .16072 .91448 -0.29713 Mabsadd L
.21629 .16072 2.37764 .77254 Mabsadd L
.21629 .16072 .56518 .7779 Mabsadd L
.21629 .16072 0 2.5 Mabsadd L closepath F
.22037 .16329 0 2.5 Mabsadd m
.22037 .16329 -0.56518 .7779 Mabsadd L
.22037 .16329 -2.37764 .77254 Mabsadd L
.22037 .16329 -0.91448 -0.29713 Mabsadd L
.22037 .16329 -1.46946 -2.02254 Mabsadd L
.22037 .16329 0 -0.96154 Mabsadd L
.22037 .16329 1.46946 -2.02254 Mabsadd L
.22037 .16329 .91448 -0.29713 Mabsadd L
.22037 .16329 2.37764 .77254 Mabsadd L
.22037 .16329 .56518 .7779 Mabsadd L
.22037 .16329 0 2.5 Mabsadd L closepath F
.22444 .16794 0 2.5 Mabsadd m
.22444 .16794 -0.56518 .7779 Mabsadd L
.22444 .16794 -2.37764 .77254 Mabsadd L
.22444 .16794 -0.91448 -0.29713 Mabsadd L
.22444 .16794 -1.46946 -2.02254 Mabsadd L
.22444 .16794 0 -0.96154 Mabsadd L
.22444 .16794 1.46946 -2.02254 Mabsadd L
.22444 .16794 .91448 -0.29713 Mabsadd L
.22444 .16794 2.37764 .77254 Mabsadd L
.22444 .16794 .56518 .7779 Mabsadd L
.22444 .16794 0 2.5 Mabsadd L closepath F
.22852 .17384 0 2.5 Mabsadd m
.22852 .17384 -0.56518 .7779 Mabsadd L
.22852 .17384 -2.37764 .77254 Mabsadd L
.22852 .17384 -0.91448 -0.29713 Mabsadd L
.22852 .17384 -1.46946 -2.02254 Mabsadd L
.22852 .17384 0 -0.96154 Mabsadd L
.22852 .17384 1.46946 -2.02254 Mabsadd L
.22852 .17384 .91448 -0.29713 Mabsadd L
.22852 .17384 2.37764 .77254 Mabsadd L
.22852 .17384 .56518 .7779 Mabsadd L
.22852 .17384 0 2.5 Mabsadd L closepath F
.23259 .18009 0 2.5 Mabsadd m
.23259 .18009 -0.56518 .7779 Mabsadd L
.23259 .18009 -2.37764 .77254 Mabsadd L
.23259 .18009 -0.91448 -0.29713 Mabsadd L
.23259 .18009 -1.46946 -2.02254 Mabsadd L
.23259 .18009 0 -0.96154 Mabsadd L
.23259 .18009 1.46946 -2.02254 Mabsadd L
.23259 .18009 .91448 -0.29713 Mabsadd L
.23259 .18009 2.37764 .77254 Mabsadd L
.23259 .18009 .56518 .7779 Mabsadd L
.23259 .18009 0 2.5 Mabsadd L closepath F
.23667 .186 0 2.5 Mabsadd m
.23667 .186 -0.56518 .7779 Mabsadd L
.23667 .186 -2.37764 .77254 Mabsadd L
.23667 .186 -0.91448 -0.29713 Mabsadd L
.23667 .186 -1.46946 -2.02254 Mabsadd L
.23667 .186 0 -0.96154 Mabsadd L
.23667 .186 1.46946 -2.02254 Mabsadd L
.23667 .186 .91448 -0.29713 Mabsadd L
.23667 .186 2.37764 .77254 Mabsadd L
.23667 .186 .56518 .7779 Mabsadd L
.23667 .186 0 2.5 Mabsadd L closepath F
.24074 .19105 0 2.5 Mabsadd m
.24074 .19105 -0.56518 .7779 Mabsadd L
.24074 .19105 -2.37764 .77254 Mabsadd L
.24074 .19105 -0.91448 -0.29713 Mabsadd L
.24074 .19105 -1.46946 -2.02254 Mabsadd L
.24074 .19105 0 -0.96154 Mabsadd L
.24074 .19105 1.46946 -2.02254 Mabsadd L
.24074 .19105 .91448 -0.29713 Mabsadd L
.24074 .19105 2.37764 .77254 Mabsadd L
.24074 .19105 .56518 .7779 Mabsadd L
.24074 .19105 0 2.5 Mabsadd L closepath F
.24535 .20441 0 2.5 Mabsadd m
.24535 .20441 -0.56518 .7779 Mabsadd L
.24535 .20441 -2.37764 .77254 Mabsadd L
.24535 .20441 -0.91448 -0.29713 Mabsadd L
.24535 .20441 -1.46946 -2.02254 Mabsadd L
.24535 .20441 0 -0.96154 Mabsadd L
.24535 .20441 1.46946 -2.02254 Mabsadd L
.24535 .20441 .91448 -0.29713 Mabsadd L
.24535 .20441 2.37764 .77254 Mabsadd L
.24535 .20441 .56518 .7779 Mabsadd L
.24535 .20441 0 2.5 Mabsadd L closepath F
.24996 .21067 0 2.5 Mabsadd m
.24996 .21067 -0.56518 .7779 Mabsadd L
.24996 .21067 -2.37764 .77254 Mabsadd L
.24996 .21067 -0.91448 -0.29713 Mabsadd L
.24996 .21067 -1.46946 -2.02254 Mabsadd L
.24996 .21067 0 -0.96154 Mabsadd L
.24996 .21067 1.46946 -2.02254 Mabsadd L
.24996 .21067 .91448 -0.29713 Mabsadd L
.24996 .21067 2.37764 .77254 Mabsadd L
.24996 .21067 .56518 .7779 Mabsadd L
.24996 .21067 0 2.5 Mabsadd L closepath F
.25456 .21518 0 2.5 Mabsadd m
.25456 .21518 -0.56518 .7779 Mabsadd L
.25456 .21518 -2.37764 .77254 Mabsadd L
.25456 .21518 -0.91448 -0.29713 Mabsadd L
.25456 .21518 -1.46946 -2.02254 Mabsadd L
.25456 .21518 0 -0.96154 Mabsadd L
.25456 .21518 1.46946 -2.02254 Mabsadd L
.25456 .21518 .91448 -0.29713 Mabsadd L
.25456 .21518 2.37764 .77254 Mabsadd L
.25456 .21518 .56518 .7779 Mabsadd L
.25456 .21518 0 2.5 Mabsadd L closepath F
.25917 .2159 0 2.5 Mabsadd m
.25917 .2159 -0.56518 .7779 Mabsadd L
.25917 .2159 -2.37764 .77254 Mabsadd L
.25917 .2159 -0.91448 -0.29713 Mabsadd L
.25917 .2159 -1.46946 -2.02254 Mabsadd L
.25917 .2159 0 -0.96154 Mabsadd L
.25917 .2159 1.46946 -2.02254 Mabsadd L
.25917 .2159 .91448 -0.29713 Mabsadd L
.25917 .2159 2.37764 .77254 Mabsadd L
.25917 .2159 .56518 .7779 Mabsadd L
.25917 .2159 0 2.5 Mabsadd L closepath F
.26378 .21446 0 2.5 Mabsadd m
.26378 .21446 -0.56518 .7779 Mabsadd L
.26378 .21446 -2.37764 .77254 Mabsadd L
.26378 .21446 -0.91448 -0.29713 Mabsadd L
.26378 .21446 -1.46946 -2.02254 Mabsadd L
.26378 .21446 0 -0.96154 Mabsadd L
.26378 .21446 1.46946 -2.02254 Mabsadd L
.26378 .21446 .91448 -0.29713 Mabsadd L
.26378 .21446 2.37764 .77254 Mabsadd L
.26378 .21446 .56518 .7779 Mabsadd L
.26378 .21446 0 2.5 Mabsadd L closepath F
.26839 .21131 0 2.5 Mabsadd m
.26839 .21131 -0.56518 .7779 Mabsadd L
.26839 .21131 -2.37764 .77254 Mabsadd L
.26839 .21131 -0.91448 -0.29713 Mabsadd L
.26839 .21131 -1.46946 -2.02254 Mabsadd L
.26839 .21131 0 -0.96154 Mabsadd L
.26839 .21131 1.46946 -2.02254 Mabsadd L
.26839 .21131 .91448 -0.29713 Mabsadd L
.26839 .21131 2.37764 .77254 Mabsadd L
.26839 .21131 .56518 .7779 Mabsadd L
.26839 .21131 0 2.5 Mabsadd L closepath F
.27299 .20732 0 2.5 Mabsadd m
.27299 .20732 -0.56518 .7779 Mabsadd L
.27299 .20732 -2.37764 .77254 Mabsadd L
.27299 .20732 -0.91448 -0.29713 Mabsadd L
.27299 .20732 -1.46946 -2.02254 Mabsadd L
.27299 .20732 0 -0.96154 Mabsadd L
.27299 .20732 1.46946 -2.02254 Mabsadd L
.27299 .20732 .91448 -0.29713 Mabsadd L
.27299 .20732 2.37764 .77254 Mabsadd L
.27299 .20732 .56518 .7779 Mabsadd L
.27299 .20732 0 2.5 Mabsadd L closepath F
.2776 .20317 0 2.5 Mabsadd m
.2776 .20317 -0.56518 .7779 Mabsadd L
.2776 .20317 -2.37764 .77254 Mabsadd L
.2776 .20317 -0.91448 -0.29713 Mabsadd L
.2776 .20317 -1.46946 -2.02254 Mabsadd L
.2776 .20317 0 -0.96154 Mabsadd L
.2776 .20317 1.46946 -2.02254 Mabsadd L
.2776 .20317 .91448 -0.29713 Mabsadd L
.2776 .20317 2.37764 .77254 Mabsadd L
.2776 .20317 .56518 .7779 Mabsadd L
.2776 .20317 0 2.5 Mabsadd L closepath F
.28295 .19563 0 2.5 Mabsadd m
.28295 .19563 -0.56518 .7779 Mabsadd L
.28295 .19563 -2.37764 .77254 Mabsadd L
.28295 .19563 -0.91448 -0.29713 Mabsadd L
.28295 .19563 -1.46946 -2.02254 Mabsadd L
.28295 .19563 0 -0.96154 Mabsadd L
.28295 .19563 1.46946 -2.02254 Mabsadd L
.28295 .19563 .91448 -0.29713 Mabsadd L
.28295 .19563 2.37764 .77254 Mabsadd L
.28295 .19563 .56518 .7779 Mabsadd L
.28295 .19563 0 2.5 Mabsadd L closepath F
.28829 .20444 0 2.5 Mabsadd m
.28829 .20444 -0.56518 .7779 Mabsadd L
.28829 .20444 -2.37764 .77254 Mabsadd L
.28829 .20444 -0.91448 -0.29713 Mabsadd L
.28829 .20444 -1.46946 -2.02254 Mabsadd L
.28829 .20444 0 -0.96154 Mabsadd L
.28829 .20444 1.46946 -2.02254 Mabsadd L
.28829 .20444 .91448 -0.29713 Mabsadd L
.28829 .20444 2.37764 .77254 Mabsadd L
.28829 .20444 .56518 .7779 Mabsadd L
.28829 .20444 0 2.5 Mabsadd L closepath F
.29364 .21584 0 2.5 Mabsadd m
.29364 .21584 -0.56518 .7779 Mabsadd L
.29364 .21584 -2.37764 .77254 Mabsadd L
.29364 .21584 -0.91448 -0.29713 Mabsadd L
.29364 .21584 -1.46946 -2.02254 Mabsadd L
.29364 .21584 0 -0.96154 Mabsadd L
.29364 .21584 1.46946 -2.02254 Mabsadd L
.29364 .21584 .91448 -0.29713 Mabsadd L
.29364 .21584 2.37764 .77254 Mabsadd L
.29364 .21584 .56518 .7779 Mabsadd L
.29364 .21584 0 2.5 Mabsadd L closepath F
.29899 .22999 0 2.5 Mabsadd m
.29899 .22999 -0.56518 .7779 Mabsadd L
.29899 .22999 -2.37764 .77254 Mabsadd L
.29899 .22999 -0.91448 -0.29713 Mabsadd L
.29899 .22999 -1.46946 -2.02254 Mabsadd L
.29899 .22999 0 -0.96154 Mabsadd L
.29899 .22999 1.46946 -2.02254 Mabsadd L
.29899 .22999 .91448 -0.29713 Mabsadd L
.29899 .22999 2.37764 .77254 Mabsadd L
.29899 .22999 .56518 .7779 Mabsadd L
.29899 .22999 0 2.5 Mabsadd L closepath F
.30433 .24238 0 2.5 Mabsadd m
.30433 .24238 -0.56518 .7779 Mabsadd L
.30433 .24238 -2.37764 .77254 Mabsadd L
.30433 .24238 -0.91448 -0.29713 Mabsadd L
.30433 .24238 -1.46946 -2.02254 Mabsadd L
.30433 .24238 0 -0.96154 Mabsadd L
.30433 .24238 1.46946 -2.02254 Mabsadd L
.30433 .24238 .91448 -0.29713 Mabsadd L
.30433 .24238 2.37764 .77254 Mabsadd L
.30433 .24238 .56518 .7779 Mabsadd L
.30433 .24238 0 2.5 Mabsadd L closepath F
.30968 .25578 0 2.5 Mabsadd m
.30968 .25578 -0.56518 .7779 Mabsadd L
.30968 .25578 -2.37764 .77254 Mabsadd L
.30968 .25578 -0.91448 -0.29713 Mabsadd L
.30968 .25578 -1.46946 -2.02254 Mabsadd L
.30968 .25578 0 -0.96154 Mabsadd L
.30968 .25578 1.46946 -2.02254 Mabsadd L
.30968 .25578 .91448 -0.29713 Mabsadd L
.30968 .25578 2.37764 .77254 Mabsadd L
.30968 .25578 .56518 .7779 Mabsadd L
.30968 .25578 0 2.5 Mabsadd L closepath F
.31503 .26739 0 2.5 Mabsadd m
.31503 .26739 -0.56518 .7779 Mabsadd L
.31503 .26739 -2.37764 .77254 Mabsadd L
.31503 .26739 -0.91448 -0.29713 Mabsadd L
.31503 .26739 -1.46946 -2.02254 Mabsadd L
.31503 .26739 0 -0.96154 Mabsadd L
.31503 .26739 1.46946 -2.02254 Mabsadd L
.31503 .26739 .91448 -0.29713 Mabsadd L
.31503 .26739 2.37764 .77254 Mabsadd L
.31503 .26739 .56518 .7779 Mabsadd L
.31503 .26739 0 2.5 Mabsadd L closepath F
.32037 .27404 0 2.5 Mabsadd m
.32037 .27404 -0.56518 .7779 Mabsadd L
.32037 .27404 -2.37764 .77254 Mabsadd L
.32037 .27404 -0.91448 -0.29713 Mabsadd L
.32037 .27404 -1.46946 -2.02254 Mabsadd L
.32037 .27404 0 -0.96154 Mabsadd L
.32037 .27404 1.46946 -2.02254 Mabsadd L
.32037 .27404 .91448 -0.29713 Mabsadd L
.32037 .27404 2.37764 .77254 Mabsadd L
.32037 .27404 .56518 .7779 Mabsadd L
.32037 .27404 0 2.5 Mabsadd L closepath F
.32572 .27163 0 2.5 Mabsadd m
.32572 .27163 -0.56518 .7779 Mabsadd L
.32572 .27163 -2.37764 .77254 Mabsadd L
.32572 .27163 -0.91448 -0.29713 Mabsadd L
.32572 .27163 -1.46946 -2.02254 Mabsadd L
.32572 .27163 0 -0.96154 Mabsadd L
.32572 .27163 1.46946 -2.02254 Mabsadd L
.32572 .27163 .91448 -0.29713 Mabsadd L
.32572 .27163 2.37764 .77254 Mabsadd L
.32572 .27163 .56518 .7779 Mabsadd L
.32572 .27163 0 2.5 Mabsadd L closepath F
.33107 .25723 0 2.5 Mabsadd m
.33107 .25723 -0.56518 .7779 Mabsadd L
.33107 .25723 -2.37764 .77254 Mabsadd L
.33107 .25723 -0.91448 -0.29713 Mabsadd L
.33107 .25723 -1.46946 -2.02254 Mabsadd L
.33107 .25723 0 -0.96154 Mabsadd L
.33107 .25723 1.46946 -2.02254 Mabsadd L
.33107 .25723 .91448 -0.29713 Mabsadd L
.33107 .25723 2.37764 .77254 Mabsadd L
.33107 .25723 .56518 .7779 Mabsadd L
.33107 .25723 0 2.5 Mabsadd L closepath F
.33641 .23023 0 2.5 Mabsadd m
.33641 .23023 -0.56518 .7779 Mabsadd L
.33641 .23023 -2.37764 .77254 Mabsadd L
.33641 .23023 -0.91448 -0.29713 Mabsadd L
.33641 .23023 -1.46946 -2.02254 Mabsadd L
.33641 .23023 0 -0.96154 Mabsadd L
.33641 .23023 1.46946 -2.02254 Mabsadd L
.33641 .23023 .91448 -0.29713 Mabsadd L
.33641 .23023 2.37764 .77254 Mabsadd L
.33641 .23023 .56518 .7779 Mabsadd L
.33641 .23023 0 2.5 Mabsadd L closepath F
.34176 .1937 0 2.5 Mabsadd m
.34176 .1937 -0.56518 .7779 Mabsadd L
.34176 .1937 -2.37764 .77254 Mabsadd L
.34176 .1937 -0.91448 -0.29713 Mabsadd L
.34176 .1937 -1.46946 -2.02254 Mabsadd L
.34176 .1937 0 -0.96154 Mabsadd L
.34176 .1937 1.46946 -2.02254 Mabsadd L
.34176 .1937 .91448 -0.29713 Mabsadd L
.34176 .1937 2.37764 .77254 Mabsadd L
.34176 .1937 .56518 .7779 Mabsadd L
.34176 .1937 0 2.5 Mabsadd L closepath F
.34711 .15455 0 2.5 Mabsadd m
.34711 .15455 -0.56518 .7779 Mabsadd L
.34711 .15455 -2.37764 .77254 Mabsadd L
.34711 .15455 -0.91448 -0.29713 Mabsadd L
.34711 .15455 -1.46946 -2.02254 Mabsadd L
.34711 .15455 0 -0.96154 Mabsadd L
.34711 .15455 1.46946 -2.02254 Mabsadd L
.34711 .15455 .91448 -0.29713 Mabsadd L
.34711 .15455 2.37764 .77254 Mabsadd L
.34711 .15455 .56518 .7779 Mabsadd L
.34711 .15455 0 2.5 Mabsadd L closepath F
.35245 .12182 0 2.5 Mabsadd m
.35245 .12182 -0.56518 .7779 Mabsadd L
.35245 .12182 -2.37764 .77254 Mabsadd L
.35245 .12182 -0.91448 -0.29713 Mabsadd L
.35245 .12182 -1.46946 -2.02254 Mabsadd L
.35245 .12182 0 -0.96154 Mabsadd L
.35245 .12182 1.46946 -2.02254 Mabsadd L
.35245 .12182 .91448 -0.29713 Mabsadd L
.35245 .12182 2.37764 .77254 Mabsadd L
.35245 .12182 .56518 .7779 Mabsadd L
.35245 .12182 0 2.5 Mabsadd L closepath F
.3578 .10397 0 2.5 Mabsadd m
.3578 .10397 -0.56518 .7779 Mabsadd L
.3578 .10397 -2.37764 .77254 Mabsadd L
.3578 .10397 -0.91448 -0.29713 Mabsadd L
.3578 .10397 -1.46946 -2.02254 Mabsadd L
.3578 .10397 0 -0.96154 Mabsadd L
.3578 .10397 1.46946 -2.02254 Mabsadd L
.3578 .10397 .91448 -0.29713 Mabsadd L
.3578 .10397 2.37764 .77254 Mabsadd L
.3578 .10397 .56518 .7779 Mabsadd L
.3578 .10397 0 2.5 Mabsadd L closepath F
.36091 .11254 0 2.5 Mabsadd m
.36091 .11254 -0.56518 .7779 Mabsadd L
.36091 .11254 -2.37764 .77254 Mabsadd L
.36091 .11254 -0.91448 -0.29713 Mabsadd L
.36091 .11254 -1.46946 -2.02254 Mabsadd L
.36091 .11254 0 -0.96154 Mabsadd L
.36091 .11254 1.46946 -2.02254 Mabsadd L
.36091 .11254 .91448 -0.29713 Mabsadd L
.36091 .11254 2.37764 .77254 Mabsadd L
.36091 .11254 .56518 .7779 Mabsadd L
.36091 .11254 0 2.5 Mabsadd L closepath F
.36402 .10448 0 2.5 Mabsadd m
.36402 .10448 -0.56518 .7779 Mabsadd L
.36402 .10448 -2.37764 .77254 Mabsadd L
.36402 .10448 -0.91448 -0.29713 Mabsadd L
.36402 .10448 -1.46946 -2.02254 Mabsadd L
.36402 .10448 0 -0.96154 Mabsadd L
.36402 .10448 1.46946 -2.02254 Mabsadd L
.36402 .10448 .91448 -0.29713 Mabsadd L
.36402 .10448 2.37764 .77254 Mabsadd L
.36402 .10448 .56518 .7779 Mabsadd L
.36402 .10448 0 2.5 Mabsadd L closepath F
.36713 .10901 0 2.5 Mabsadd m
.36713 .10901 -0.56518 .7779 Mabsadd L
.36713 .10901 -2.37764 .77254 Mabsadd L
.36713 .10901 -0.91448 -0.29713 Mabsadd L
.36713 .10901 -1.46946 -2.02254 Mabsadd L
.36713 .10901 0 -0.96154 Mabsadd L
.36713 .10901 1.46946 -2.02254 Mabsadd L
.36713 .10901 .91448 -0.29713 Mabsadd L
.36713 .10901 2.37764 .77254 Mabsadd L
.36713 .10901 .56518 .7779 Mabsadd L
.36713 .10901 0 2.5 Mabsadd L closepath F
.37024 .10695 0 2.5 Mabsadd m
.37024 .10695 -0.56518 .7779 Mabsadd L
.37024 .10695 -2.37764 .77254 Mabsadd L
.37024 .10695 -0.91448 -0.29713 Mabsadd L
.37024 .10695 -1.46946 -2.02254 Mabsadd L
.37024 .10695 0 -0.96154 Mabsadd L
.37024 .10695 1.46946 -2.02254 Mabsadd L
.37024 .10695 .91448 -0.29713 Mabsadd L
.37024 .10695 2.37764 .77254 Mabsadd L
.37024 .10695 .56518 .7779 Mabsadd L
.37024 .10695 0 2.5 Mabsadd L closepath F
.37335 .1076 0 2.5 Mabsadd m
.37335 .1076 -0.56518 .7779 Mabsadd L
.37335 .1076 -2.37764 .77254 Mabsadd L
.37335 .1076 -0.91448 -0.29713 Mabsadd L
.37335 .1076 -1.46946 -2.02254 Mabsadd L
.37335 .1076 0 -0.96154 Mabsadd L
.37335 .1076 1.46946 -2.02254 Mabsadd L
.37335 .1076 .91448 -0.29713 Mabsadd L
.37335 .1076 2.37764 .77254 Mabsadd L
.37335 .1076 .56518 .7779 Mabsadd L
.37335 .1076 0 2.5 Mabsadd L closepath F
.37645 .10747 0 2.5 Mabsadd m
.37645 .10747 -0.56518 .7779 Mabsadd L
.37645 .10747 -2.37764 .77254 Mabsadd L
.37645 .10747 -0.91448 -0.29713 Mabsadd L
.37645 .10747 -1.46946 -2.02254 Mabsadd L
.37645 .10747 0 -0.96154 Mabsadd L
.37645 .10747 1.46946 -2.02254 Mabsadd L
.37645 .10747 .91448 -0.29713 Mabsadd L
.37645 .10747 2.37764 .77254 Mabsadd L
.37645 .10747 .56518 .7779 Mabsadd L
.37645 .10747 0 2.5 Mabsadd L closepath F
.37956 .10817 0 2.5 Mabsadd m
.37956 .10817 -0.56518 .7779 Mabsadd L
.37956 .10817 -2.37764 .77254 Mabsadd L
.37956 .10817 -0.91448 -0.29713 Mabsadd L
.37956 .10817 -1.46946 -2.02254 Mabsadd L
.37956 .10817 0 -0.96154 Mabsadd L
.37956 .10817 1.46946 -2.02254 Mabsadd L
.37956 .10817 .91448 -0.29713 Mabsadd L
.37956 .10817 2.37764 .77254 Mabsadd L
.37956 .10817 .56518 .7779 Mabsadd L
.37956 .10817 0 2.5 Mabsadd L closepath F
.38267 .10866 0 2.5 Mabsadd m
.38267 .10866 -0.56518 .7779 Mabsadd L
.38267 .10866 -2.37764 .77254 Mabsadd L
.38267 .10866 -0.91448 -0.29713 Mabsadd L
.38267 .10866 -1.46946 -2.02254 Mabsadd L
.38267 .10866 0 -0.96154 Mabsadd L
.38267 .10866 1.46946 -2.02254 Mabsadd L
.38267 .10866 .91448 -0.29713 Mabsadd L
.38267 .10866 2.37764 .77254 Mabsadd L
.38267 .10866 .56518 .7779 Mabsadd L
.38267 .10866 0 2.5 Mabsadd L closepath F
.38707 .11685 0 2.5 Mabsadd m
.38707 .11685 -0.56518 .7779 Mabsadd L
.38707 .11685 -2.37764 .77254 Mabsadd L
.38707 .11685 -0.91448 -0.29713 Mabsadd L
.38707 .11685 -1.46946 -2.02254 Mabsadd L
.38707 .11685 0 -0.96154 Mabsadd L
.38707 .11685 1.46946 -2.02254 Mabsadd L
.38707 .11685 .91448 -0.29713 Mabsadd L
.38707 .11685 2.37764 .77254 Mabsadd L
.38707 .11685 .56518 .7779 Mabsadd L
.38707 .11685 0 2.5 Mabsadd L closepath F
.39147 .12809 0 2.5 Mabsadd m
.39147 .12809 -0.56518 .7779 Mabsadd L
.39147 .12809 -2.37764 .77254 Mabsadd L
.39147 .12809 -0.91448 -0.29713 Mabsadd L
.39147 .12809 -1.46946 -2.02254 Mabsadd L
.39147 .12809 0 -0.96154 Mabsadd L
.39147 .12809 1.46946 -2.02254 Mabsadd L
.39147 .12809 .91448 -0.29713 Mabsadd L
.39147 .12809 2.37764 .77254 Mabsadd L
.39147 .12809 .56518 .7779 Mabsadd L
.39147 .12809 0 2.5 Mabsadd L closepath F
.39587 .13932 0 2.5 Mabsadd m
.39587 .13932 -0.56518 .7779 Mabsadd L
.39587 .13932 -2.37764 .77254 Mabsadd L
.39587 .13932 -0.91448 -0.29713 Mabsadd L
.39587 .13932 -1.46946 -2.02254 Mabsadd L
.39587 .13932 0 -0.96154 Mabsadd L
.39587 .13932 1.46946 -2.02254 Mabsadd L
.39587 .13932 .91448 -0.29713 Mabsadd L
.39587 .13932 2.37764 .77254 Mabsadd L
.39587 .13932 .56518 .7779 Mabsadd L
.39587 .13932 0 2.5 Mabsadd L closepath F
.40027 .14911 0 2.5 Mabsadd m
.40027 .14911 -0.56518 .7779 Mabsadd L
.40027 .14911 -2.37764 .77254 Mabsadd L
.40027 .14911 -0.91448 -0.29713 Mabsadd L
.40027 .14911 -1.46946 -2.02254 Mabsadd L
.40027 .14911 0 -0.96154 Mabsadd L
.40027 .14911 1.46946 -2.02254 Mabsadd L
.40027 .14911 .91448 -0.29713 Mabsadd L
.40027 .14911 2.37764 .77254 Mabsadd L
.40027 .14911 .56518 .7779 Mabsadd L
.40027 .14911 0 2.5 Mabsadd L closepath F
.40467 .15678 0 2.5 Mabsadd m
.40467 .15678 -0.56518 .7779 Mabsadd L
.40467 .15678 -2.37764 .77254 Mabsadd L
.40467 .15678 -0.91448 -0.29713 Mabsadd L
.40467 .15678 -1.46946 -2.02254 Mabsadd L
.40467 .15678 0 -0.96154 Mabsadd L
.40467 .15678 1.46946 -2.02254 Mabsadd L
.40467 .15678 .91448 -0.29713 Mabsadd L
.40467 .15678 2.37764 .77254 Mabsadd L
.40467 .15678 .56518 .7779 Mabsadd L
.40467 .15678 0 2.5 Mabsadd L closepath F
.40907 .162 0 2.5 Mabsadd m
.40907 .162 -0.56518 .7779 Mabsadd L
.40907 .162 -2.37764 .77254 Mabsadd L
.40907 .162 -0.91448 -0.29713 Mabsadd L
.40907 .162 -1.46946 -2.02254 Mabsadd L
.40907 .162 0 -0.96154 Mabsadd L
.40907 .162 1.46946 -2.02254 Mabsadd L
.40907 .162 .91448 -0.29713 Mabsadd L
.40907 .162 2.37764 .77254 Mabsadd L
.40907 .162 .56518 .7779 Mabsadd L
.40907 .162 0 2.5 Mabsadd L closepath F
.41347 .16484 0 2.5 Mabsadd m
.41347 .16484 -0.56518 .7779 Mabsadd L
.41347 .16484 -2.37764 .77254 Mabsadd L
.41347 .16484 -0.91448 -0.29713 Mabsadd L
.41347 .16484 -1.46946 -2.02254 Mabsadd L
.41347 .16484 0 -0.96154 Mabsadd L
.41347 .16484 1.46946 -2.02254 Mabsadd L
.41347 .16484 .91448 -0.29713 Mabsadd L
.41347 .16484 2.37764 .77254 Mabsadd L
.41347 .16484 .56518 .7779 Mabsadd L
.41347 .16484 0 2.5 Mabsadd L closepath F
.41787 .16562 0 2.5 Mabsadd m
.41787 .16562 -0.56518 .7779 Mabsadd L
.41787 .16562 -2.37764 .77254 Mabsadd L
.41787 .16562 -0.91448 -0.29713 Mabsadd L
.41787 .16562 -1.46946 -2.02254 Mabsadd L
.41787 .16562 0 -0.96154 Mabsadd L
.41787 .16562 1.46946 -2.02254 Mabsadd L
.41787 .16562 .91448 -0.29713 Mabsadd L
.41787 .16562 2.37764 .77254 Mabsadd L
.41787 .16562 .56518 .7779 Mabsadd L
.41787 .16562 0 2.5 Mabsadd L closepath F
.42281 .16481 0 2.5 Mabsadd m
.42281 .16481 -0.56518 .7779 Mabsadd L
.42281 .16481 -2.37764 .77254 Mabsadd L
.42281 .16481 -0.91448 -0.29713 Mabsadd L
.42281 .16481 -1.46946 -2.02254 Mabsadd L
.42281 .16481 0 -0.96154 Mabsadd L
.42281 .16481 1.46946 -2.02254 Mabsadd L
.42281 .16481 .91448 -0.29713 Mabsadd L
.42281 .16481 2.37764 .77254 Mabsadd L
.42281 .16481 .56518 .7779 Mabsadd L
.42281 .16481 0 2.5 Mabsadd L closepath F
.42775 .15977 0 2.5 Mabsadd m
.42775 .15977 -0.56518 .7779 Mabsadd L
.42775 .15977 -2.37764 .77254 Mabsadd L
.42775 .15977 -0.91448 -0.29713 Mabsadd L
.42775 .15977 -1.46946 -2.02254 Mabsadd L
.42775 .15977 0 -0.96154 Mabsadd L
.42775 .15977 1.46946 -2.02254 Mabsadd L
.42775 .15977 .91448 -0.29713 Mabsadd L
.42775 .15977 2.37764 .77254 Mabsadd L
.42775 .15977 .56518 .7779 Mabsadd L
.42775 .15977 0 2.5 Mabsadd L closepath F
.43269 .15314 0 2.5 Mabsadd m
.43269 .15314 -0.56518 .7779 Mabsadd L
.43269 .15314 -2.37764 .77254 Mabsadd L
.43269 .15314 -0.91448 -0.29713 Mabsadd L
.43269 .15314 -1.46946 -2.02254 Mabsadd L
.43269 .15314 0 -0.96154 Mabsadd L
.43269 .15314 1.46946 -2.02254 Mabsadd L
.43269 .15314 .91448 -0.29713 Mabsadd L
.43269 .15314 2.37764 .77254 Mabsadd L
.43269 .15314 .56518 .7779 Mabsadd L
.43269 .15314 0 2.5 Mabsadd L closepath F
.43763 .14584 0 2.5 Mabsadd m
.43763 .14584 -0.56518 .7779 Mabsadd L
.43763 .14584 -2.37764 .77254 Mabsadd L
.43763 .14584 -0.91448 -0.29713 Mabsadd L
.43763 .14584 -1.46946 -2.02254 Mabsadd L
.43763 .14584 0 -0.96154 Mabsadd L
.43763 .14584 1.46946 -2.02254 Mabsadd L
.43763 .14584 .91448 -0.29713 Mabsadd L
.43763 .14584 2.37764 .77254 Mabsadd L
.43763 .14584 .56518 .7779 Mabsadd L
.43763 .14584 0 2.5 Mabsadd L closepath F
.44257 .13954 0 2.5 Mabsadd m
.44257 .13954 -0.56518 .7779 Mabsadd L
.44257 .13954 -2.37764 .77254 Mabsadd L
.44257 .13954 -0.91448 -0.29713 Mabsadd L
.44257 .13954 -1.46946 -2.02254 Mabsadd L
.44257 .13954 0 -0.96154 Mabsadd L
.44257 .13954 1.46946 -2.02254 Mabsadd L
.44257 .13954 .91448 -0.29713 Mabsadd L
.44257 .13954 2.37764 .77254 Mabsadd L
.44257 .13954 .56518 .7779 Mabsadd L
.44257 .13954 0 2.5 Mabsadd L closepath F
.44751 .13565 0 2.5 Mabsadd m
.44751 .13565 -0.56518 .7779 Mabsadd L
.44751 .13565 -2.37764 .77254 Mabsadd L
.44751 .13565 -0.91448 -0.29713 Mabsadd L
.44751 .13565 -1.46946 -2.02254 Mabsadd L
.44751 .13565 0 -0.96154 Mabsadd L
.44751 .13565 1.46946 -2.02254 Mabsadd L
.44751 .13565 .91448 -0.29713 Mabsadd L
.44751 .13565 2.37764 .77254 Mabsadd L
.44751 .13565 .56518 .7779 Mabsadd L
.44751 .13565 0 2.5 Mabsadd L closepath F
.45245 .1357 0 2.5 Mabsadd m
.45245 .1357 -0.56518 .7779 Mabsadd L
.45245 .1357 -2.37764 .77254 Mabsadd L
.45245 .1357 -0.91448 -0.29713 Mabsadd L
.45245 .1357 -1.46946 -2.02254 Mabsadd L
.45245 .1357 0 -0.96154 Mabsadd L
.45245 .1357 1.46946 -2.02254 Mabsadd L
.45245 .1357 .91448 -0.29713 Mabsadd L
.45245 .1357 2.37764 .77254 Mabsadd L
.45245 .1357 .56518 .7779 Mabsadd L
.45245 .1357 0 2.5 Mabsadd L closepath F
.45739 .14119 0 2.5 Mabsadd m
.45739 .14119 -0.56518 .7779 Mabsadd L
.45739 .14119 -2.37764 .77254 Mabsadd L
.45739 .14119 -0.91448 -0.29713 Mabsadd L
.45739 .14119 -1.46946 -2.02254 Mabsadd L
.45739 .14119 0 -0.96154 Mabsadd L
.45739 .14119 1.46946 -2.02254 Mabsadd L
.45739 .14119 .91448 -0.29713 Mabsadd L
.45739 .14119 2.37764 .77254 Mabsadd L
.45739 .14119 .56518 .7779 Mabsadd L
.45739 .14119 0 2.5 Mabsadd L closepath F
.46233 .15337 0 2.5 Mabsadd m
.46233 .15337 -0.56518 .7779 Mabsadd L
.46233 .15337 -2.37764 .77254 Mabsadd L
.46233 .15337 -0.91448 -0.29713 Mabsadd L
.46233 .15337 -1.46946 -2.02254 Mabsadd L
.46233 .15337 0 -0.96154 Mabsadd L
.46233 .15337 1.46946 -2.02254 Mabsadd L
.46233 .15337 .91448 -0.29713 Mabsadd L
.46233 .15337 2.37764 .77254 Mabsadd L
.46233 .15337 .56518 .7779 Mabsadd L
.46233 .15337 0 2.5 Mabsadd L closepath F
.46727 .17289 0 2.5 Mabsadd m
.46727 .17289 -0.56518 .7779 Mabsadd L
.46727 .17289 -2.37764 .77254 Mabsadd L
.46727 .17289 -0.91448 -0.29713 Mabsadd L
.46727 .17289 -1.46946 -2.02254 Mabsadd L
.46727 .17289 0 -0.96154 Mabsadd L
.46727 .17289 1.46946 -2.02254 Mabsadd L
.46727 .17289 .91448 -0.29713 Mabsadd L
.46727 .17289 2.37764 .77254 Mabsadd L
.46727 .17289 .56518 .7779 Mabsadd L
.46727 .17289 0 2.5 Mabsadd L closepath F
.47221 .19933 0 2.5 Mabsadd m
.47221 .19933 -0.56518 .7779 Mabsadd L
.47221 .19933 -2.37764 .77254 Mabsadd L
.47221 .19933 -0.91448 -0.29713 Mabsadd L
.47221 .19933 -1.46946 -2.02254 Mabsadd L
.47221 .19933 0 -0.96154 Mabsadd L
.47221 .19933 1.46946 -2.02254 Mabsadd L
.47221 .19933 .91448 -0.29713 Mabsadd L
.47221 .19933 2.37764 .77254 Mabsadd L
.47221 .19933 .56518 .7779 Mabsadd L
.47221 .19933 0 2.5 Mabsadd L closepath F
.47715 .23075 0 2.5 Mabsadd m
.47715 .23075 -0.56518 .7779 Mabsadd L
.47715 .23075 -2.37764 .77254 Mabsadd L
.47715 .23075 -0.91448 -0.29713 Mabsadd L
.47715 .23075 -1.46946 -2.02254 Mabsadd L
.47715 .23075 0 -0.96154 Mabsadd L
.47715 .23075 1.46946 -2.02254 Mabsadd L
.47715 .23075 .91448 -0.29713 Mabsadd L
.47715 .23075 2.37764 .77254 Mabsadd L
.47715 .23075 .56518 .7779 Mabsadd L
.47715 .23075 0 2.5 Mabsadd L closepath F
.48209 .2634 0 2.5 Mabsadd m
.48209 .2634 -0.56518 .7779 Mabsadd L
.48209 .2634 -2.37764 .77254 Mabsadd L
.48209 .2634 -0.91448 -0.29713 Mabsadd L
.48209 .2634 -1.46946 -2.02254 Mabsadd L
.48209 .2634 0 -0.96154 Mabsadd L
.48209 .2634 1.46946 -2.02254 Mabsadd L
.48209 .2634 .91448 -0.29713 Mabsadd L
.48209 .2634 2.37764 .77254 Mabsadd L
.48209 .2634 .56518 .7779 Mabsadd L
.48209 .2634 0 2.5 Mabsadd L closepath F
.48703 .29193 0 2.5 Mabsadd m
.48703 .29193 -0.56518 .7779 Mabsadd L
.48703 .29193 -2.37764 .77254 Mabsadd L
.48703 .29193 -0.91448 -0.29713 Mabsadd L
.48703 .29193 -1.46946 -2.02254 Mabsadd L
.48703 .29193 0 -0.96154 Mabsadd L
.48703 .29193 1.46946 -2.02254 Mabsadd L
.48703 .29193 .91448 -0.29713 Mabsadd L
.48703 .29193 2.37764 .77254 Mabsadd L
.48703 .29193 .56518 .7779 Mabsadd L
.48703 .29193 0 2.5 Mabsadd L closepath F
.49112 .28136 0 2.5 Mabsadd m
.49112 .28136 -0.56518 .7779 Mabsadd L
.49112 .28136 -2.37764 .77254 Mabsadd L
.49112 .28136 -0.91448 -0.29713 Mabsadd L
.49112 .28136 -1.46946 -2.02254 Mabsadd L
.49112 .28136 0 -0.96154 Mabsadd L
.49112 .28136 1.46946 -2.02254 Mabsadd L
.49112 .28136 .91448 -0.29713 Mabsadd L
.49112 .28136 2.37764 .77254 Mabsadd L
.49112 .28136 .56518 .7779 Mabsadd L
.49112 .28136 0 2.5 Mabsadd L closepath F
.49521 .29084 0 2.5 Mabsadd m
.49521 .29084 -0.56518 .7779 Mabsadd L
.49521 .29084 -2.37764 .77254 Mabsadd L
.49521 .29084 -0.91448 -0.29713 Mabsadd L
.49521 .29084 -1.46946 -2.02254 Mabsadd L
.49521 .29084 0 -0.96154 Mabsadd L
.49521 .29084 1.46946 -2.02254 Mabsadd L
.49521 .29084 .91448 -0.29713 Mabsadd L
.49521 .29084 2.37764 .77254 Mabsadd L
.49521 .29084 .56518 .7779 Mabsadd L
.49521 .29084 0 2.5 Mabsadd L closepath F
.49931 .28164 0 2.5 Mabsadd m
.49931 .28164 -0.56518 .7779 Mabsadd L
.49931 .28164 -2.37764 .77254 Mabsadd L
.49931 .28164 -0.91448 -0.29713 Mabsadd L
.49931 .28164 -1.46946 -2.02254 Mabsadd L
.49931 .28164 0 -0.96154 Mabsadd L
.49931 .28164 1.46946 -2.02254 Mabsadd L
.49931 .28164 .91448 -0.29713 Mabsadd L
.49931 .28164 2.37764 .77254 Mabsadd L
.49931 .28164 .56518 .7779 Mabsadd L
.49931 .28164 0 2.5 Mabsadd L closepath F
.5034 .27625 0 2.5 Mabsadd m
.5034 .27625 -0.56518 .7779 Mabsadd L
.5034 .27625 -2.37764 .77254 Mabsadd L
.5034 .27625 -0.91448 -0.29713 Mabsadd L
.5034 .27625 -1.46946 -2.02254 Mabsadd L
.5034 .27625 0 -0.96154 Mabsadd L
.5034 .27625 1.46946 -2.02254 Mabsadd L
.5034 .27625 .91448 -0.29713 Mabsadd L
.5034 .27625 2.37764 .77254 Mabsadd L
.5034 .27625 .56518 .7779 Mabsadd L
.5034 .27625 0 2.5 Mabsadd L closepath F
.50749 .26437 0 2.5 Mabsadd m
.50749 .26437 -0.56518 .7779 Mabsadd L
.50749 .26437 -2.37764 .77254 Mabsadd L
.50749 .26437 -0.91448 -0.29713 Mabsadd L
.50749 .26437 -1.46946 -2.02254 Mabsadd L
.50749 .26437 0 -0.96154 Mabsadd L
.50749 .26437 1.46946 -2.02254 Mabsadd L
.50749 .26437 .91448 -0.29713 Mabsadd L
.50749 .26437 2.37764 .77254 Mabsadd L
.50749 .26437 .56518 .7779 Mabsadd L
.50749 .26437 0 2.5 Mabsadd L closepath F
.51159 .25239 0 2.5 Mabsadd m
.51159 .25239 -0.56518 .7779 Mabsadd L
.51159 .25239 -2.37764 .77254 Mabsadd L
.51159 .25239 -0.91448 -0.29713 Mabsadd L
.51159 .25239 -1.46946 -2.02254 Mabsadd L
.51159 .25239 0 -0.96154 Mabsadd L
.51159 .25239 1.46946 -2.02254 Mabsadd L
.51159 .25239 .91448 -0.29713 Mabsadd L
.51159 .25239 2.37764 .77254 Mabsadd L
.51159 .25239 .56518 .7779 Mabsadd L
.51159 .25239 0 2.5 Mabsadd L closepath F
.51568 .23859 0 2.5 Mabsadd m
.51568 .23859 -0.56518 .7779 Mabsadd L
.51568 .23859 -2.37764 .77254 Mabsadd L
.51568 .23859 -0.91448 -0.29713 Mabsadd L
.51568 .23859 -1.46946 -2.02254 Mabsadd L
.51568 .23859 0 -0.96154 Mabsadd L
.51568 .23859 1.46946 -2.02254 Mabsadd L
.51568 .23859 .91448 -0.29713 Mabsadd L
.51568 .23859 2.37764 .77254 Mabsadd L
.51568 .23859 .56518 .7779 Mabsadd L
.51568 .23859 0 2.5 Mabsadd L closepath F
.51977 .22633 0 2.5 Mabsadd m
.51977 .22633 -0.56518 .7779 Mabsadd L
.51977 .22633 -2.37764 .77254 Mabsadd L
.51977 .22633 -0.91448 -0.29713 Mabsadd L
.51977 .22633 -1.46946 -2.02254 Mabsadd L
.51977 .22633 0 -0.96154 Mabsadd L
.51977 .22633 1.46946 -2.02254 Mabsadd L
.51977 .22633 .91448 -0.29713 Mabsadd L
.51977 .22633 2.37764 .77254 Mabsadd L
.51977 .22633 .56518 .7779 Mabsadd L
.51977 .22633 0 2.5 Mabsadd L closepath F
.52323 .22914 0 2.5 Mabsadd m
.52323 .22914 -0.56518 .7779 Mabsadd L
.52323 .22914 -2.37764 .77254 Mabsadd L
.52323 .22914 -0.91448 -0.29713 Mabsadd L
.52323 .22914 -1.46946 -2.02254 Mabsadd L
.52323 .22914 0 -0.96154 Mabsadd L
.52323 .22914 1.46946 -2.02254 Mabsadd L
.52323 .22914 .91448 -0.29713 Mabsadd L
.52323 .22914 2.37764 .77254 Mabsadd L
.52323 .22914 .56518 .7779 Mabsadd L
.52323 .22914 0 2.5 Mabsadd L closepath F
.52669 .22395 0 2.5 Mabsadd m
.52669 .22395 -0.56518 .7779 Mabsadd L
.52669 .22395 -2.37764 .77254 Mabsadd L
.52669 .22395 -0.91448 -0.29713 Mabsadd L
.52669 .22395 -1.46946 -2.02254 Mabsadd L
.52669 .22395 0 -0.96154 Mabsadd L
.52669 .22395 1.46946 -2.02254 Mabsadd L
.52669 .22395 .91448 -0.29713 Mabsadd L
.52669 .22395 2.37764 .77254 Mabsadd L
.52669 .22395 .56518 .7779 Mabsadd L
.52669 .22395 0 2.5 Mabsadd L closepath F
.53015 .2247 0 2.5 Mabsadd m
.53015 .2247 -0.56518 .7779 Mabsadd L
.53015 .2247 -2.37764 .77254 Mabsadd L
.53015 .2247 -0.91448 -0.29713 Mabsadd L
.53015 .2247 -1.46946 -2.02254 Mabsadd L
.53015 .2247 0 -0.96154 Mabsadd L
.53015 .2247 1.46946 -2.02254 Mabsadd L
.53015 .2247 .91448 -0.29713 Mabsadd L
.53015 .2247 2.37764 .77254 Mabsadd L
.53015 .2247 .56518 .7779 Mabsadd L
.53015 .2247 0 2.5 Mabsadd L closepath F
.53361 .22402 0 2.5 Mabsadd m
.53361 .22402 -0.56518 .7779 Mabsadd L
.53361 .22402 -2.37764 .77254 Mabsadd L
.53361 .22402 -0.91448 -0.29713 Mabsadd L
.53361 .22402 -1.46946 -2.02254 Mabsadd L
.53361 .22402 0 -0.96154 Mabsadd L
.53361 .22402 1.46946 -2.02254 Mabsadd L
.53361 .22402 .91448 -0.29713 Mabsadd L
.53361 .22402 2.37764 .77254 Mabsadd L
.53361 .22402 .56518 .7779 Mabsadd L
.53361 .22402 0 2.5 Mabsadd L closepath F
.53707 .22479 0 2.5 Mabsadd m
.53707 .22479 -0.56518 .7779 Mabsadd L
.53707 .22479 -2.37764 .77254 Mabsadd L
.53707 .22479 -0.91448 -0.29713 Mabsadd L
.53707 .22479 -1.46946 -2.02254 Mabsadd L
.53707 .22479 0 -0.96154 Mabsadd L
.53707 .22479 1.46946 -2.02254 Mabsadd L
.53707 .22479 .91448 -0.29713 Mabsadd L
.53707 .22479 2.37764 .77254 Mabsadd L
.53707 .22479 .56518 .7779 Mabsadd L
.53707 .22479 0 2.5 Mabsadd L closepath F
.54053 .22577 0 2.5 Mabsadd m
.54053 .22577 -0.56518 .7779 Mabsadd L
.54053 .22577 -2.37764 .77254 Mabsadd L
.54053 .22577 -0.91448 -0.29713 Mabsadd L
.54053 .22577 -1.46946 -2.02254 Mabsadd L
.54053 .22577 0 -0.96154 Mabsadd L
.54053 .22577 1.46946 -2.02254 Mabsadd L
.54053 .22577 .91448 -0.29713 Mabsadd L
.54053 .22577 2.37764 .77254 Mabsadd L
.54053 .22577 .56518 .7779 Mabsadd L
.54053 .22577 0 2.5 Mabsadd L closepath F
.54399 .22731 0 2.5 Mabsadd m
.54399 .22731 -0.56518 .7779 Mabsadd L
.54399 .22731 -2.37764 .77254 Mabsadd L
.54399 .22731 -0.91448 -0.29713 Mabsadd L
.54399 .22731 -1.46946 -2.02254 Mabsadd L
.54399 .22731 0 -0.96154 Mabsadd L
.54399 .22731 1.46946 -2.02254 Mabsadd L
.54399 .22731 .91448 -0.29713 Mabsadd L
.54399 .22731 2.37764 .77254 Mabsadd L
.54399 .22731 .56518 .7779 Mabsadd L
.54399 .22731 0 2.5 Mabsadd L closepath F
.54745 .22895 0 2.5 Mabsadd m
.54745 .22895 -0.56518 .7779 Mabsadd L
.54745 .22895 -2.37764 .77254 Mabsadd L
.54745 .22895 -0.91448 -0.29713 Mabsadd L
.54745 .22895 -1.46946 -2.02254 Mabsadd L
.54745 .22895 0 -0.96154 Mabsadd L
.54745 .22895 1.46946 -2.02254 Mabsadd L
.54745 .22895 .91448 -0.29713 Mabsadd L
.54745 .22895 2.37764 .77254 Mabsadd L
.54745 .22895 .56518 .7779 Mabsadd L
.54745 .22895 0 2.5 Mabsadd L closepath F
.55156 .23636 0 2.5 Mabsadd m
.55156 .23636 -0.56518 .7779 Mabsadd L
.55156 .23636 -2.37764 .77254 Mabsadd L
.55156 .23636 -0.91448 -0.29713 Mabsadd L
.55156 .23636 -1.46946 -2.02254 Mabsadd L
.55156 .23636 0 -0.96154 Mabsadd L
.55156 .23636 1.46946 -2.02254 Mabsadd L
.55156 .23636 .91448 -0.29713 Mabsadd L
.55156 .23636 2.37764 .77254 Mabsadd L
.55156 .23636 .56518 .7779 Mabsadd L
.55156 .23636 0 2.5 Mabsadd L closepath F
.55568 .24232 0 2.5 Mabsadd m
.55568 .24232 -0.56518 .7779 Mabsadd L
.55568 .24232 -2.37764 .77254 Mabsadd L
.55568 .24232 -0.91448 -0.29713 Mabsadd L
.55568 .24232 -1.46946 -2.02254 Mabsadd L
.55568 .24232 0 -0.96154 Mabsadd L
.55568 .24232 1.46946 -2.02254 Mabsadd L
.55568 .24232 .91448 -0.29713 Mabsadd L
.55568 .24232 2.37764 .77254 Mabsadd L
.55568 .24232 .56518 .7779 Mabsadd L
.55568 .24232 0 2.5 Mabsadd L closepath F
.55979 .24809 0 2.5 Mabsadd m
.55979 .24809 -0.56518 .7779 Mabsadd L
.55979 .24809 -2.37764 .77254 Mabsadd L
.55979 .24809 -0.91448 -0.29713 Mabsadd L
.55979 .24809 -1.46946 -2.02254 Mabsadd L
.55979 .24809 0 -0.96154 Mabsadd L
.55979 .24809 1.46946 -2.02254 Mabsadd L
.55979 .24809 .91448 -0.29713 Mabsadd L
.55979 .24809 2.37764 .77254 Mabsadd L
.55979 .24809 .56518 .7779 Mabsadd L
.55979 .24809 0 2.5 Mabsadd L closepath F
.56391 .25239 0 2.5 Mabsadd m
.56391 .25239 -0.56518 .7779 Mabsadd L
.56391 .25239 -2.37764 .77254 Mabsadd L
.56391 .25239 -0.91448 -0.29713 Mabsadd L
.56391 .25239 -1.46946 -2.02254 Mabsadd L
.56391 .25239 0 -0.96154 Mabsadd L
.56391 .25239 1.46946 -2.02254 Mabsadd L
.56391 .25239 .91448 -0.29713 Mabsadd L
.56391 .25239 2.37764 .77254 Mabsadd L
.56391 .25239 .56518 .7779 Mabsadd L
.56391 .25239 0 2.5 Mabsadd L closepath F
.56802 .25544 0 2.5 Mabsadd m
.56802 .25544 -0.56518 .7779 Mabsadd L
.56802 .25544 -2.37764 .77254 Mabsadd L
.56802 .25544 -0.91448 -0.29713 Mabsadd L
.56802 .25544 -1.46946 -2.02254 Mabsadd L
.56802 .25544 0 -0.96154 Mabsadd L
.56802 .25544 1.46946 -2.02254 Mabsadd L
.56802 .25544 .91448 -0.29713 Mabsadd L
.56802 .25544 2.37764 .77254 Mabsadd L
.56802 .25544 .56518 .7779 Mabsadd L
.56802 .25544 0 2.5 Mabsadd L closepath F
.57213 .25715 0 2.5 Mabsadd m
.57213 .25715 -0.56518 .7779 Mabsadd L
.57213 .25715 -2.37764 .77254 Mabsadd L
.57213 .25715 -0.91448 -0.29713 Mabsadd L
.57213 .25715 -1.46946 -2.02254 Mabsadd L
.57213 .25715 0 -0.96154 Mabsadd L
.57213 .25715 1.46946 -2.02254 Mabsadd L
.57213 .25715 .91448 -0.29713 Mabsadd L
.57213 .25715 2.37764 .77254 Mabsadd L
.57213 .25715 .56518 .7779 Mabsadd L
.57213 .25715 0 2.5 Mabsadd L closepath F
.57625 .25773 0 2.5 Mabsadd m
.57625 .25773 -0.56518 .7779 Mabsadd L
.57625 .25773 -2.37764 .77254 Mabsadd L
.57625 .25773 -0.91448 -0.29713 Mabsadd L
.57625 .25773 -1.46946 -2.02254 Mabsadd L
.57625 .25773 0 -0.96154 Mabsadd L
.57625 .25773 1.46946 -2.02254 Mabsadd L
.57625 .25773 .91448 -0.29713 Mabsadd L
.57625 .25773 2.37764 .77254 Mabsadd L
.57625 .25773 .56518 .7779 Mabsadd L
.57625 .25773 0 2.5 Mabsadd L closepath F
.58036 .25738 0 2.5 Mabsadd m
.58036 .25738 -0.56518 .7779 Mabsadd L
.58036 .25738 -2.37764 .77254 Mabsadd L
.58036 .25738 -0.91448 -0.29713 Mabsadd L
.58036 .25738 -1.46946 -2.02254 Mabsadd L
.58036 .25738 0 -0.96154 Mabsadd L
.58036 .25738 1.46946 -2.02254 Mabsadd L
.58036 .25738 .91448 -0.29713 Mabsadd L
.58036 .25738 2.37764 .77254 Mabsadd L
.58036 .25738 .56518 .7779 Mabsadd L
.58036 .25738 0 2.5 Mabsadd L closepath F
.58543 .25315 0 2.5 Mabsadd m
.58543 .25315 -0.56518 .7779 Mabsadd L
.58543 .25315 -2.37764 .77254 Mabsadd L
.58543 .25315 -0.91448 -0.29713 Mabsadd L
.58543 .25315 -1.46946 -2.02254 Mabsadd L
.58543 .25315 0 -0.96154 Mabsadd L
.58543 .25315 1.46946 -2.02254 Mabsadd L
.58543 .25315 .91448 -0.29713 Mabsadd L
.58543 .25315 2.37764 .77254 Mabsadd L
.58543 .25315 .56518 .7779 Mabsadd L
.58543 .25315 0 2.5 Mabsadd L closepath F
.5905 .24582 0 2.5 Mabsadd m
.5905 .24582 -0.56518 .7779 Mabsadd L
.5905 .24582 -2.37764 .77254 Mabsadd L
.5905 .24582 -0.91448 -0.29713 Mabsadd L
.5905 .24582 -1.46946 -2.02254 Mabsadd L
.5905 .24582 0 -0.96154 Mabsadd L
.5905 .24582 1.46946 -2.02254 Mabsadd L
.5905 .24582 .91448 -0.29713 Mabsadd L
.5905 .24582 2.37764 .77254 Mabsadd L
.5905 .24582 .56518 .7779 Mabsadd L
.5905 .24582 0 2.5 Mabsadd L closepath F
.59556 .23696 0 2.5 Mabsadd m
.59556 .23696 -0.56518 .7779 Mabsadd L
.59556 .23696 -2.37764 .77254 Mabsadd L
.59556 .23696 -0.91448 -0.29713 Mabsadd L
.59556 .23696 -1.46946 -2.02254 Mabsadd L
.59556 .23696 0 -0.96154 Mabsadd L
.59556 .23696 1.46946 -2.02254 Mabsadd L
.59556 .23696 .91448 -0.29713 Mabsadd L
.59556 .23696 2.37764 .77254 Mabsadd L
.59556 .23696 .56518 .7779 Mabsadd L
.59556 .23696 0 2.5 Mabsadd L closepath F
.60063 .22855 0 2.5 Mabsadd m
.60063 .22855 -0.56518 .7779 Mabsadd L
.60063 .22855 -2.37764 .77254 Mabsadd L
.60063 .22855 -0.91448 -0.29713 Mabsadd L
.60063 .22855 -1.46946 -2.02254 Mabsadd L
.60063 .22855 0 -0.96154 Mabsadd L
.60063 .22855 1.46946 -2.02254 Mabsadd L
.60063 .22855 .91448 -0.29713 Mabsadd L
.60063 .22855 2.37764 .77254 Mabsadd L
.60063 .22855 .56518 .7779 Mabsadd L
.60063 .22855 0 2.5 Mabsadd L closepath F
.6057 .22245 0 2.5 Mabsadd m
.6057 .22245 -0.56518 .7779 Mabsadd L
.6057 .22245 -2.37764 .77254 Mabsadd L
.6057 .22245 -0.91448 -0.29713 Mabsadd L
.6057 .22245 -1.46946 -2.02254 Mabsadd L
.6057 .22245 0 -0.96154 Mabsadd L
.6057 .22245 1.46946 -2.02254 Mabsadd L
.6057 .22245 .91448 -0.29713 Mabsadd L
.6057 .22245 2.37764 .77254 Mabsadd L
.6057 .22245 .56518 .7779 Mabsadd L
.6057 .22245 0 2.5 Mabsadd L closepath F
.61077 .22061 0 2.5 Mabsadd m
.61077 .22061 -0.56518 .7779 Mabsadd L
.61077 .22061 -2.37764 .77254 Mabsadd L
.61077 .22061 -0.91448 -0.29713 Mabsadd L
.61077 .22061 -1.46946 -2.02254 Mabsadd L
.61077 .22061 0 -0.96154 Mabsadd L
.61077 .22061 1.46946 -2.02254 Mabsadd L
.61077 .22061 .91448 -0.29713 Mabsadd L
.61077 .22061 2.37764 .77254 Mabsadd L
.61077 .22061 .56518 .7779 Mabsadd L
.61077 .22061 0 2.5 Mabsadd L closepath F
.61584 .22499 0 2.5 Mabsadd m
.61584 .22499 -0.56518 .7779 Mabsadd L
.61584 .22499 -2.37764 .77254 Mabsadd L
.61584 .22499 -0.91448 -0.29713 Mabsadd L
.61584 .22499 -1.46946 -2.02254 Mabsadd L
.61584 .22499 0 -0.96154 Mabsadd L
.61584 .22499 1.46946 -2.02254 Mabsadd L
.61584 .22499 .91448 -0.29713 Mabsadd L
.61584 .22499 2.37764 .77254 Mabsadd L
.61584 .22499 .56518 .7779 Mabsadd L
.61584 .22499 0 2.5 Mabsadd L closepath F
.6209 .23735 0 2.5 Mabsadd m
.6209 .23735 -0.56518 .7779 Mabsadd L
.6209 .23735 -2.37764 .77254 Mabsadd L
.6209 .23735 -0.91448 -0.29713 Mabsadd L
.6209 .23735 -1.46946 -2.02254 Mabsadd L
.6209 .23735 0 -0.96154 Mabsadd L
.6209 .23735 1.46946 -2.02254 Mabsadd L
.6209 .23735 .91448 -0.29713 Mabsadd L
.6209 .23735 2.37764 .77254 Mabsadd L
.6209 .23735 .56518 .7779 Mabsadd L
.6209 .23735 0 2.5 Mabsadd L closepath F
.62597 .25883 0 2.5 Mabsadd m
.62597 .25883 -0.56518 .7779 Mabsadd L
.62597 .25883 -2.37764 .77254 Mabsadd L
.62597 .25883 -0.91448 -0.29713 Mabsadd L
.62597 .25883 -1.46946 -2.02254 Mabsadd L
.62597 .25883 0 -0.96154 Mabsadd L
.62597 .25883 1.46946 -2.02254 Mabsadd L
.62597 .25883 .91448 -0.29713 Mabsadd L
.62597 .25883 2.37764 .77254 Mabsadd L
.62597 .25883 .56518 .7779 Mabsadd L
.62597 .25883 0 2.5 Mabsadd L closepath F
.63104 .28934 0 2.5 Mabsadd m
.63104 .28934 -0.56518 .7779 Mabsadd L
.63104 .28934 -2.37764 .77254 Mabsadd L
.63104 .28934 -0.91448 -0.29713 Mabsadd L
.63104 .28934 -1.46946 -2.02254 Mabsadd L
.63104 .28934 0 -0.96154 Mabsadd L
.63104 .28934 1.46946 -2.02254 Mabsadd L
.63104 .28934 .91448 -0.29713 Mabsadd L
.63104 .28934 2.37764 .77254 Mabsadd L
.63104 .28934 .56518 .7779 Mabsadd L
.63104 .28934 0 2.5 Mabsadd L closepath F
.63611 .32689 0 2.5 Mabsadd m
.63611 .32689 -0.56518 .7779 Mabsadd L
.63611 .32689 -2.37764 .77254 Mabsadd L
.63611 .32689 -0.91448 -0.29713 Mabsadd L
.63611 .32689 -1.46946 -2.02254 Mabsadd L
.63611 .32689 0 -0.96154 Mabsadd L
.63611 .32689 1.46946 -2.02254 Mabsadd L
.63611 .32689 .91448 -0.29713 Mabsadd L
.63611 .32689 2.37764 .77254 Mabsadd L
.63611 .32689 .56518 .7779 Mabsadd L
.63611 .32689 0 2.5 Mabsadd L closepath F
.64117 .3672 0 2.5 Mabsadd m
.64117 .3672 -0.56518 .7779 Mabsadd L
.64117 .3672 -2.37764 .77254 Mabsadd L
.64117 .3672 -0.91448 -0.29713 Mabsadd L
.64117 .3672 -1.46946 -2.02254 Mabsadd L
.64117 .3672 0 -0.96154 Mabsadd L
.64117 .3672 1.46946 -2.02254 Mabsadd L
.64117 .3672 .91448 -0.29713 Mabsadd L
.64117 .3672 2.37764 .77254 Mabsadd L
.64117 .3672 .56518 .7779 Mabsadd L
.64117 .3672 0 2.5 Mabsadd L closepath F
.64624 .40373 0 2.5 Mabsadd m
.64624 .40373 -0.56518 .7779 Mabsadd L
.64624 .40373 -2.37764 .77254 Mabsadd L
.64624 .40373 -0.91448 -0.29713 Mabsadd L
.64624 .40373 -1.46946 -2.02254 Mabsadd L
.64624 .40373 0 -0.96154 Mabsadd L
.64624 .40373 1.46946 -2.02254 Mabsadd L
.64624 .40373 .91448 -0.29713 Mabsadd L
.64624 .40373 2.37764 .77254 Mabsadd L
.64624 .40373 .56518 .7779 Mabsadd L
.64624 .40373 0 2.5 Mabsadd L closepath F
.65131 .42853 0 2.5 Mabsadd m
.65131 .42853 -0.56518 .7779 Mabsadd L
.65131 .42853 -2.37764 .77254 Mabsadd L
.65131 .42853 -0.91448 -0.29713 Mabsadd L
.65131 .42853 -1.46946 -2.02254 Mabsadd L
.65131 .42853 0 -0.96154 Mabsadd L
.65131 .42853 1.46946 -2.02254 Mabsadd L
.65131 .42853 .91448 -0.29713 Mabsadd L
.65131 .42853 2.37764 .77254 Mabsadd L
.65131 .42853 .56518 .7779 Mabsadd L
.65131 .42853 0 2.5 Mabsadd L closepath F
.65544 .41503 0 2.5 Mabsadd m
.65544 .41503 -0.56518 .7779 Mabsadd L
.65544 .41503 -2.37764 .77254 Mabsadd L
.65544 .41503 -0.91448 -0.29713 Mabsadd L
.65544 .41503 -1.46946 -2.02254 Mabsadd L
.65544 .41503 0 -0.96154 Mabsadd L
.65544 .41503 1.46946 -2.02254 Mabsadd L
.65544 .41503 .91448 -0.29713 Mabsadd L
.65544 .41503 2.37764 .77254 Mabsadd L
.65544 .41503 .56518 .7779 Mabsadd L
.65544 .41503 0 2.5 Mabsadd L closepath F
.65957 .42041 0 2.5 Mabsadd m
.65957 .42041 -0.56518 .7779 Mabsadd L
.65957 .42041 -2.37764 .77254 Mabsadd L
.65957 .42041 -0.91448 -0.29713 Mabsadd L
.65957 .42041 -1.46946 -2.02254 Mabsadd L
.65957 .42041 0 -0.96154 Mabsadd L
.65957 .42041 1.46946 -2.02254 Mabsadd L
.65957 .42041 .91448 -0.29713 Mabsadd L
.65957 .42041 2.37764 .77254 Mabsadd L
.65957 .42041 .56518 .7779 Mabsadd L
.65957 .42041 0 2.5 Mabsadd L closepath F
.6637 .40602 0 2.5 Mabsadd m
.6637 .40602 -0.56518 .7779 Mabsadd L
.6637 .40602 -2.37764 .77254 Mabsadd L
.6637 .40602 -0.91448 -0.29713 Mabsadd L
.6637 .40602 -1.46946 -2.02254 Mabsadd L
.6637 .40602 0 -0.96154 Mabsadd L
.6637 .40602 1.46946 -2.02254 Mabsadd L
.6637 .40602 .91448 -0.29713 Mabsadd L
.6637 .40602 2.37764 .77254 Mabsadd L
.6637 .40602 .56518 .7779 Mabsadd L
.6637 .40602 0 2.5 Mabsadd L closepath F
.66783 .39684 0 2.5 Mabsadd m
.66783 .39684 -0.56518 .7779 Mabsadd L
.66783 .39684 -2.37764 .77254 Mabsadd L
.66783 .39684 -0.91448 -0.29713 Mabsadd L
.66783 .39684 -1.46946 -2.02254 Mabsadd L
.66783 .39684 0 -0.96154 Mabsadd L
.66783 .39684 1.46946 -2.02254 Mabsadd L
.66783 .39684 .91448 -0.29713 Mabsadd L
.66783 .39684 2.37764 .77254 Mabsadd L
.66783 .39684 .56518 .7779 Mabsadd L
.66783 .39684 0 2.5 Mabsadd L closepath F
.67197 .3814 0 2.5 Mabsadd m
.67197 .3814 -0.56518 .7779 Mabsadd L
.67197 .3814 -2.37764 .77254 Mabsadd L
.67197 .3814 -0.91448 -0.29713 Mabsadd L
.67197 .3814 -1.46946 -2.02254 Mabsadd L
.67197 .3814 0 -0.96154 Mabsadd L
.67197 .3814 1.46946 -2.02254 Mabsadd L
.67197 .3814 .91448 -0.29713 Mabsadd L
.67197 .3814 2.37764 .77254 Mabsadd L
.67197 .3814 .56518 .7779 Mabsadd L
.67197 .3814 0 2.5 Mabsadd L closepath F
.6761 .36809 0 2.5 Mabsadd m
.6761 .36809 -0.56518 .7779 Mabsadd L
.6761 .36809 -2.37764 .77254 Mabsadd L
.6761 .36809 -0.91448 -0.29713 Mabsadd L
.6761 .36809 -1.46946 -2.02254 Mabsadd L
.6761 .36809 0 -0.96154 Mabsadd L
.6761 .36809 1.46946 -2.02254 Mabsadd L
.6761 .36809 .91448 -0.29713 Mabsadd L
.6761 .36809 2.37764 .77254 Mabsadd L
.6761 .36809 .56518 .7779 Mabsadd L
.6761 .36809 0 2.5 Mabsadd L closepath F
.68023 .35428 0 2.5 Mabsadd m
.68023 .35428 -0.56518 .7779 Mabsadd L
.68023 .35428 -2.37764 .77254 Mabsadd L
.68023 .35428 -0.91448 -0.29713 Mabsadd L
.68023 .35428 -1.46946 -2.02254 Mabsadd L
.68023 .35428 0 -0.96154 Mabsadd L
.68023 .35428 1.46946 -2.02254 Mabsadd L
.68023 .35428 .91448 -0.29713 Mabsadd L
.68023 .35428 2.37764 .77254 Mabsadd L
.68023 .35428 .56518 .7779 Mabsadd L
.68023 .35428 0 2.5 Mabsadd L closepath F
.68436 .34406 0 2.5 Mabsadd m
.68436 .34406 -0.56518 .7779 Mabsadd L
.68436 .34406 -2.37764 .77254 Mabsadd L
.68436 .34406 -0.91448 -0.29713 Mabsadd L
.68436 .34406 -1.46946 -2.02254 Mabsadd L
.68436 .34406 0 -0.96154 Mabsadd L
.68436 .34406 1.46946 -2.02254 Mabsadd L
.68436 .34406 .91448 -0.29713 Mabsadd L
.68436 .34406 2.37764 .77254 Mabsadd L
.68436 .34406 .56518 .7779 Mabsadd L
.68436 .34406 0 2.5 Mabsadd L closepath F
.68849 .33686 0 2.5 Mabsadd m
.68849 .33686 -0.56518 .7779 Mabsadd L
.68849 .33686 -2.37764 .77254 Mabsadd L
.68849 .33686 -0.91448 -0.29713 Mabsadd L
.68849 .33686 -1.46946 -2.02254 Mabsadd L
.68849 .33686 0 -0.96154 Mabsadd L
.68849 .33686 1.46946 -2.02254 Mabsadd L
.68849 .33686 .91448 -0.29713 Mabsadd L
.68849 .33686 2.37764 .77254 Mabsadd L
.68849 .33686 .56518 .7779 Mabsadd L
.68849 .33686 0 2.5 Mabsadd L closepath F
.69262 .33388 0 2.5 Mabsadd m
.69262 .33388 -0.56518 .7779 Mabsadd L
.69262 .33388 -2.37764 .77254 Mabsadd L
.69262 .33388 -0.91448 -0.29713 Mabsadd L
.69262 .33388 -1.46946 -2.02254 Mabsadd L
.69262 .33388 0 -0.96154 Mabsadd L
.69262 .33388 1.46946 -2.02254 Mabsadd L
.69262 .33388 .91448 -0.29713 Mabsadd L
.69262 .33388 2.37764 .77254 Mabsadd L
.69262 .33388 .56518 .7779 Mabsadd L
.69262 .33388 0 2.5 Mabsadd L closepath F
.69675 .33445 0 2.5 Mabsadd m
.69675 .33445 -0.56518 .7779 Mabsadd L
.69675 .33445 -2.37764 .77254 Mabsadd L
.69675 .33445 -0.91448 -0.29713 Mabsadd L
.69675 .33445 -1.46946 -2.02254 Mabsadd L
.69675 .33445 0 -0.96154 Mabsadd L
.69675 .33445 1.46946 -2.02254 Mabsadd L
.69675 .33445 .91448 -0.29713 Mabsadd L
.69675 .33445 2.37764 .77254 Mabsadd L
.69675 .33445 .56518 .7779 Mabsadd L
.69675 .33445 0 2.5 Mabsadd L closepath F
.70088 .33814 0 2.5 Mabsadd m
.70088 .33814 -0.56518 .7779 Mabsadd L
.70088 .33814 -2.37764 .77254 Mabsadd L
.70088 .33814 -0.91448 -0.29713 Mabsadd L
.70088 .33814 -1.46946 -2.02254 Mabsadd L
.70088 .33814 0 -0.96154 Mabsadd L
.70088 .33814 1.46946 -2.02254 Mabsadd L
.70088 .33814 .91448 -0.29713 Mabsadd L
.70088 .33814 2.37764 .77254 Mabsadd L
.70088 .33814 .56518 .7779 Mabsadd L
.70088 .33814 0 2.5 Mabsadd L closepath F
.70501 .34388 0 2.5 Mabsadd m
.70501 .34388 -0.56518 .7779 Mabsadd L
.70501 .34388 -2.37764 .77254 Mabsadd L
.70501 .34388 -0.91448 -0.29713 Mabsadd L
.70501 .34388 -1.46946 -2.02254 Mabsadd L
.70501 .34388 0 -0.96154 Mabsadd L
.70501 .34388 1.46946 -2.02254 Mabsadd L
.70501 .34388 .91448 -0.29713 Mabsadd L
.70501 .34388 2.37764 .77254 Mabsadd L
.70501 .34388 .56518 .7779 Mabsadd L
.70501 .34388 0 2.5 Mabsadd L closepath F
.70914 .3507 0 2.5 Mabsadd m
.70914 .3507 -0.56518 .7779 Mabsadd L
.70914 .3507 -2.37764 .77254 Mabsadd L
.70914 .3507 -0.91448 -0.29713 Mabsadd L
.70914 .3507 -1.46946 -2.02254 Mabsadd L
.70914 .3507 0 -0.96154 Mabsadd L
.70914 .3507 1.46946 -2.02254 Mabsadd L
.70914 .3507 .91448 -0.29713 Mabsadd L
.70914 .3507 2.37764 .77254 Mabsadd L
.70914 .3507 .56518 .7779 Mabsadd L
.70914 .3507 0 2.5 Mabsadd L closepath F
.71328 .35761 0 2.5 Mabsadd m
.71328 .35761 -0.56518 .7779 Mabsadd L
.71328 .35761 -2.37764 .77254 Mabsadd L
.71328 .35761 -0.91448 -0.29713 Mabsadd L
.71328 .35761 -1.46946 -2.02254 Mabsadd L
.71328 .35761 0 -0.96154 Mabsadd L
.71328 .35761 1.46946 -2.02254 Mabsadd L
.71328 .35761 .91448 -0.29713 Mabsadd L
.71328 .35761 2.37764 .77254 Mabsadd L
.71328 .35761 .56518 .7779 Mabsadd L
.71328 .35761 0 2.5 Mabsadd L closepath F
.71741 .36391 0 2.5 Mabsadd m
.71741 .36391 -0.56518 .7779 Mabsadd L
.71741 .36391 -2.37764 .77254 Mabsadd L
.71741 .36391 -0.91448 -0.29713 Mabsadd L
.71741 .36391 -1.46946 -2.02254 Mabsadd L
.71741 .36391 0 -0.96154 Mabsadd L
.71741 .36391 1.46946 -2.02254 Mabsadd L
.71741 .36391 .91448 -0.29713 Mabsadd L
.71741 .36391 2.37764 .77254 Mabsadd L
.71741 .36391 .56518 .7779 Mabsadd L
.71741 .36391 0 2.5 Mabsadd L closepath F
.72154 .3691 0 2.5 Mabsadd m
.72154 .3691 -0.56518 .7779 Mabsadd L
.72154 .3691 -2.37764 .77254 Mabsadd L
.72154 .3691 -0.91448 -0.29713 Mabsadd L
.72154 .3691 -1.46946 -2.02254 Mabsadd L
.72154 .3691 0 -0.96154 Mabsadd L
.72154 .3691 1.46946 -2.02254 Mabsadd L
.72154 .3691 .91448 -0.29713 Mabsadd L
.72154 .3691 2.37764 .77254 Mabsadd L
.72154 .3691 .56518 .7779 Mabsadd L
.72154 .3691 0 2.5 Mabsadd L closepath F
.7262 .38225 0 2.5 Mabsadd m
.7262 .38225 -0.56518 .7779 Mabsadd L
.7262 .38225 -2.37764 .77254 Mabsadd L
.7262 .38225 -0.91448 -0.29713 Mabsadd L
.7262 .38225 -1.46946 -2.02254 Mabsadd L
.7262 .38225 0 -0.96154 Mabsadd L
.7262 .38225 1.46946 -2.02254 Mabsadd L
.7262 .38225 .91448 -0.29713 Mabsadd L
.7262 .38225 2.37764 .77254 Mabsadd L
.7262 .38225 .56518 .7779 Mabsadd L
.7262 .38225 0 2.5 Mabsadd L closepath F
.73086 .38777 0 2.5 Mabsadd m
.73086 .38777 -0.56518 .7779 Mabsadd L
.73086 .38777 -2.37764 .77254 Mabsadd L
.73086 .38777 -0.91448 -0.29713 Mabsadd L
.73086 .38777 -1.46946 -2.02254 Mabsadd L
.73086 .38777 0 -0.96154 Mabsadd L
.73086 .38777 1.46946 -2.02254 Mabsadd L
.73086 .38777 .91448 -0.29713 Mabsadd L
.73086 .38777 2.37764 .77254 Mabsadd L
.73086 .38777 .56518 .7779 Mabsadd L
.73086 .38777 0 2.5 Mabsadd L closepath F
.73553 .39136 0 2.5 Mabsadd m
.73553 .39136 -0.56518 .7779 Mabsadd L
.73553 .39136 -2.37764 .77254 Mabsadd L
.73553 .39136 -0.91448 -0.29713 Mabsadd L
.73553 .39136 -1.46946 -2.02254 Mabsadd L
.73553 .39136 0 -0.96154 Mabsadd L
.73553 .39136 1.46946 -2.02254 Mabsadd L
.73553 .39136 .91448 -0.29713 Mabsadd L
.73553 .39136 2.37764 .77254 Mabsadd L
.73553 .39136 .56518 .7779 Mabsadd L
.73553 .39136 0 2.5 Mabsadd L closepath F
.74019 .39106 0 2.5 Mabsadd m
.74019 .39106 -0.56518 .7779 Mabsadd L
.74019 .39106 -2.37764 .77254 Mabsadd L
.74019 .39106 -0.91448 -0.29713 Mabsadd L
.74019 .39106 -1.46946 -2.02254 Mabsadd L
.74019 .39106 0 -0.96154 Mabsadd L
.74019 .39106 1.46946 -2.02254 Mabsadd L
.74019 .39106 .91448 -0.29713 Mabsadd L
.74019 .39106 2.37764 .77254 Mabsadd L
.74019 .39106 .56518 .7779 Mabsadd L
.74019 .39106 0 2.5 Mabsadd L closepath F
.74485 .38866 0 2.5 Mabsadd m
.74485 .38866 -0.56518 .7779 Mabsadd L
.74485 .38866 -2.37764 .77254 Mabsadd L
.74485 .38866 -0.91448 -0.29713 Mabsadd L
.74485 .38866 -1.46946 -2.02254 Mabsadd L
.74485 .38866 0 -0.96154 Mabsadd L
.74485 .38866 1.46946 -2.02254 Mabsadd L
.74485 .38866 .91448 -0.29713 Mabsadd L
.74485 .38866 2.37764 .77254 Mabsadd L
.74485 .38866 .56518 .7779 Mabsadd L
.74485 .38866 0 2.5 Mabsadd L closepath F
.74952 .38471 0 2.5 Mabsadd m
.74952 .38471 -0.56518 .7779 Mabsadd L
.74952 .38471 -2.37764 .77254 Mabsadd L
.74952 .38471 -0.91448 -0.29713 Mabsadd L
.74952 .38471 -1.46946 -2.02254 Mabsadd L
.74952 .38471 0 -0.96154 Mabsadd L
.74952 .38471 1.46946 -2.02254 Mabsadd L
.74952 .38471 .91448 -0.29713 Mabsadd L
.74952 .38471 2.37764 .77254 Mabsadd L
.74952 .38471 .56518 .7779 Mabsadd L
.74952 .38471 0 2.5 Mabsadd L closepath F
.75418 .38015 0 2.5 Mabsadd m
.75418 .38015 -0.56518 .7779 Mabsadd L
.75418 .38015 -2.37764 .77254 Mabsadd L
.75418 .38015 -0.91448 -0.29713 Mabsadd L
.75418 .38015 -1.46946 -2.02254 Mabsadd L
.75418 .38015 0 -0.96154 Mabsadd L
.75418 .38015 1.46946 -2.02254 Mabsadd L
.75418 .38015 .91448 -0.29713 Mabsadd L
.75418 .38015 2.37764 .77254 Mabsadd L
.75418 .38015 .56518 .7779 Mabsadd L
.75418 .38015 0 2.5 Mabsadd L closepath F
.75884 .37576 0 2.5 Mabsadd m
.75884 .37576 -0.56518 .7779 Mabsadd L
.75884 .37576 -2.37764 .77254 Mabsadd L
.75884 .37576 -0.91448 -0.29713 Mabsadd L
.75884 .37576 -1.46946 -2.02254 Mabsadd L
.75884 .37576 0 -0.96154 Mabsadd L
.75884 .37576 1.46946 -2.02254 Mabsadd L
.75884 .37576 .91448 -0.29713 Mabsadd L
.75884 .37576 2.37764 .77254 Mabsadd L
.75884 .37576 .56518 .7779 Mabsadd L
.75884 .37576 0 2.5 Mabsadd L closepath F
.76414 .37022 0 2.5 Mabsadd m
.76414 .37022 -0.56518 .7779 Mabsadd L
.76414 .37022 -2.37764 .77254 Mabsadd L
.76414 .37022 -0.91448 -0.29713 Mabsadd L
.76414 .37022 -1.46946 -2.02254 Mabsadd L
.76414 .37022 0 -0.96154 Mabsadd L
.76414 .37022 1.46946 -2.02254 Mabsadd L
.76414 .37022 .91448 -0.29713 Mabsadd L
.76414 .37022 2.37764 .77254 Mabsadd L
.76414 .37022 .56518 .7779 Mabsadd L
.76414 .37022 0 2.5 Mabsadd L closepath F
.76944 .37964 0 2.5 Mabsadd m
.76944 .37964 -0.56518 .7779 Mabsadd L
.76944 .37964 -2.37764 .77254 Mabsadd L
.76944 .37964 -0.91448 -0.29713 Mabsadd L
.76944 .37964 -1.46946 -2.02254 Mabsadd L
.76944 .37964 0 -0.96154 Mabsadd L
.76944 .37964 1.46946 -2.02254 Mabsadd L
.76944 .37964 .91448 -0.29713 Mabsadd L
.76944 .37964 2.37764 .77254 Mabsadd L
.76944 .37964 .56518 .7779 Mabsadd L
.76944 .37964 0 2.5 Mabsadd L closepath F
.77474 .39145 0 2.5 Mabsadd m
.77474 .39145 -0.56518 .7779 Mabsadd L
.77474 .39145 -2.37764 .77254 Mabsadd L
.77474 .39145 -0.91448 -0.29713 Mabsadd L
.77474 .39145 -1.46946 -2.02254 Mabsadd L
.77474 .39145 0 -0.96154 Mabsadd L
.77474 .39145 1.46946 -2.02254 Mabsadd L
.77474 .39145 .91448 -0.29713 Mabsadd L
.77474 .39145 2.37764 .77254 Mabsadd L
.77474 .39145 .56518 .7779 Mabsadd L
.77474 .39145 0 2.5 Mabsadd L closepath F
.78004 .40566 0 2.5 Mabsadd m
.78004 .40566 -0.56518 .7779 Mabsadd L
.78004 .40566 -2.37764 .77254 Mabsadd L
.78004 .40566 -0.91448 -0.29713 Mabsadd L
.78004 .40566 -1.46946 -2.02254 Mabsadd L
.78004 .40566 0 -0.96154 Mabsadd L
.78004 .40566 1.46946 -2.02254 Mabsadd L
.78004 .40566 .91448 -0.29713 Mabsadd L
.78004 .40566 2.37764 .77254 Mabsadd L
.78004 .40566 .56518 .7779 Mabsadd L
.78004 .40566 0 2.5 Mabsadd L closepath F
.78534 .41765 0 2.5 Mabsadd m
.78534 .41765 -0.56518 .7779 Mabsadd L
.78534 .41765 -2.37764 .77254 Mabsadd L
.78534 .41765 -0.91448 -0.29713 Mabsadd L
.78534 .41765 -1.46946 -2.02254 Mabsadd L
.78534 .41765 0 -0.96154 Mabsadd L
.78534 .41765 1.46946 -2.02254 Mabsadd L
.78534 .41765 .91448 -0.29713 Mabsadd L
.78534 .41765 2.37764 .77254 Mabsadd L
.78534 .41765 .56518 .7779 Mabsadd L
.78534 .41765 0 2.5 Mabsadd L closepath F
.79064 .42984 0 2.5 Mabsadd m
.79064 .42984 -0.56518 .7779 Mabsadd L
.79064 .42984 -2.37764 .77254 Mabsadd L
.79064 .42984 -0.91448 -0.29713 Mabsadd L
.79064 .42984 -1.46946 -2.02254 Mabsadd L
.79064 .42984 0 -0.96154 Mabsadd L
.79064 .42984 1.46946 -2.02254 Mabsadd L
.79064 .42984 .91448 -0.29713 Mabsadd L
.79064 .42984 2.37764 .77254 Mabsadd L
.79064 .42984 .56518 .7779 Mabsadd L
.79064 .42984 0 2.5 Mabsadd L closepath F
.79593 .43919 0 2.5 Mabsadd m
.79593 .43919 -0.56518 .7779 Mabsadd L
.79593 .43919 -2.37764 .77254 Mabsadd L
.79593 .43919 -0.91448 -0.29713 Mabsadd L
.79593 .43919 -1.46946 -2.02254 Mabsadd L
.79593 .43919 0 -0.96154 Mabsadd L
.79593 .43919 1.46946 -2.02254 Mabsadd L
.79593 .43919 .91448 -0.29713 Mabsadd L
.79593 .43919 2.37764 .77254 Mabsadd L
.79593 .43919 .56518 .7779 Mabsadd L
.79593 .43919 0 2.5 Mabsadd L closepath F
.80123 .44273 0 2.5 Mabsadd m
.80123 .44273 -0.56518 .7779 Mabsadd L
.80123 .44273 -2.37764 .77254 Mabsadd L
.80123 .44273 -0.91448 -0.29713 Mabsadd L
.80123 .44273 -1.46946 -2.02254 Mabsadd L
.80123 .44273 0 -0.96154 Mabsadd L
.80123 .44273 1.46946 -2.02254 Mabsadd L
.80123 .44273 .91448 -0.29713 Mabsadd L
.80123 .44273 2.37764 .77254 Mabsadd L
.80123 .44273 .56518 .7779 Mabsadd L
.80123 .44273 0 2.5 Mabsadd L closepath F
.80653 .43678 0 2.5 Mabsadd m
.80653 .43678 -0.56518 .7779 Mabsadd L
.80653 .43678 -2.37764 .77254 Mabsadd L
.80653 .43678 -0.91448 -0.29713 Mabsadd L
.80653 .43678 -1.46946 -2.02254 Mabsadd L
.80653 .43678 0 -0.96154 Mabsadd L
.80653 .43678 1.46946 -2.02254 Mabsadd L
.80653 .43678 .91448 -0.29713 Mabsadd L
.80653 .43678 2.37764 .77254 Mabsadd L
.80653 .43678 .56518 .7779 Mabsadd L
.80653 .43678 0 2.5 Mabsadd L closepath F
.81183 .41939 0 2.5 Mabsadd m
.81183 .41939 -0.56518 .7779 Mabsadd L
.81183 .41939 -2.37764 .77254 Mabsadd L
.81183 .41939 -0.91448 -0.29713 Mabsadd L
.81183 .41939 -1.46946 -2.02254 Mabsadd L
.81183 .41939 0 -0.96154 Mabsadd L
.81183 .41939 1.46946 -2.02254 Mabsadd L
.81183 .41939 .91448 -0.29713 Mabsadd L
.81183 .41939 2.37764 .77254 Mabsadd L
.81183 .41939 .56518 .7779 Mabsadd L
.81183 .41939 0 2.5 Mabsadd L closepath F
.81713 .391 0 2.5 Mabsadd m
.81713 .391 -0.56518 .7779 Mabsadd L
.81713 .391 -2.37764 .77254 Mabsadd L
.81713 .391 -0.91448 -0.29713 Mabsadd L
.81713 .391 -1.46946 -2.02254 Mabsadd L
.81713 .391 0 -0.96154 Mabsadd L
.81713 .391 1.46946 -2.02254 Mabsadd L
.81713 .391 .91448 -0.29713 Mabsadd L
.81713 .391 2.37764 .77254 Mabsadd L
.81713 .391 .56518 .7779 Mabsadd L
.81713 .391 0 2.5 Mabsadd L closepath F
.82243 .35566 0 2.5 Mabsadd m
.82243 .35566 -0.56518 .7779 Mabsadd L
.82243 .35566 -2.37764 .77254 Mabsadd L
.82243 .35566 -0.91448 -0.29713 Mabsadd L
.82243 .35566 -1.46946 -2.02254 Mabsadd L
.82243 .35566 0 -0.96154 Mabsadd L
.82243 .35566 1.46946 -2.02254 Mabsadd L
.82243 .35566 .91448 -0.29713 Mabsadd L
.82243 .35566 2.37764 .77254 Mabsadd L
.82243 .35566 .56518 .7779 Mabsadd L
.82243 .35566 0 2.5 Mabsadd L closepath F
.82574 .37128 0 2.5 Mabsadd m
.82574 .37128 -0.56518 .7779 Mabsadd L
.82574 .37128 -2.37764 .77254 Mabsadd L
.82574 .37128 -0.91448 -0.29713 Mabsadd L
.82574 .37128 -1.46946 -2.02254 Mabsadd L
.82574 .37128 0 -0.96154 Mabsadd L
.82574 .37128 1.46946 -2.02254 Mabsadd L
.82574 .37128 .91448 -0.29713 Mabsadd L
.82574 .37128 2.37764 .77254 Mabsadd L
.82574 .37128 .56518 .7779 Mabsadd L
.82574 .37128 0 2.5 Mabsadd L closepath F
.82905 .35459 0 2.5 Mabsadd m
.82905 .35459 -0.56518 .7779 Mabsadd L
.82905 .35459 -2.37764 .77254 Mabsadd L
.82905 .35459 -0.91448 -0.29713 Mabsadd L
.82905 .35459 -1.46946 -2.02254 Mabsadd L
.82905 .35459 0 -0.96154 Mabsadd L
.82905 .35459 1.46946 -2.02254 Mabsadd L
.82905 .35459 .91448 -0.29713 Mabsadd L
.82905 .35459 2.37764 .77254 Mabsadd L
.82905 .35459 .56518 .7779 Mabsadd L
.82905 .35459 0 2.5 Mabsadd L closepath F
.83236 .35926 0 2.5 Mabsadd m
.83236 .35926 -0.56518 .7779 Mabsadd L
.83236 .35926 -2.37764 .77254 Mabsadd L
.83236 .35926 -0.91448 -0.29713 Mabsadd L
.83236 .35926 -1.46946 -2.02254 Mabsadd L
.83236 .35926 0 -0.96154 Mabsadd L
.83236 .35926 1.46946 -2.02254 Mabsadd L
.83236 .35926 .91448 -0.29713 Mabsadd L
.83236 .35926 2.37764 .77254 Mabsadd L
.83236 .35926 .56518 .7779 Mabsadd L
.83236 .35926 0 2.5 Mabsadd L closepath F
.83567 .35458 0 2.5 Mabsadd m
.83567 .35458 -0.56518 .7779 Mabsadd L
.83567 .35458 -2.37764 .77254 Mabsadd L
.83567 .35458 -0.91448 -0.29713 Mabsadd L
.83567 .35458 -1.46946 -2.02254 Mabsadd L
.83567 .35458 0 -0.96154 Mabsadd L
.83567 .35458 1.46946 -2.02254 Mabsadd L
.83567 .35458 .91448 -0.29713 Mabsadd L
.83567 .35458 2.37764 .77254 Mabsadd L
.83567 .35458 .56518 .7779 Mabsadd L
.83567 .35458 0 2.5 Mabsadd L closepath F
.83898 .35318 0 2.5 Mabsadd m
.83898 .35318 -0.56518 .7779 Mabsadd L
.83898 .35318 -2.37764 .77254 Mabsadd L
.83898 .35318 -0.91448 -0.29713 Mabsadd L
.83898 .35318 -1.46946 -2.02254 Mabsadd L
.83898 .35318 0 -0.96154 Mabsadd L
.83898 .35318 1.46946 -2.02254 Mabsadd L
.83898 .35318 .91448 -0.29713 Mabsadd L
.83898 .35318 2.37764 .77254 Mabsadd L
.83898 .35318 .56518 .7779 Mabsadd L
.83898 .35318 0 2.5 Mabsadd L closepath F
.84229 .35112 0 2.5 Mabsadd m
.84229 .35112 -0.56518 .7779 Mabsadd L
.84229 .35112 -2.37764 .77254 Mabsadd L
.84229 .35112 -0.91448 -0.29713 Mabsadd L
.84229 .35112 -1.46946 -2.02254 Mabsadd L
.84229 .35112 0 -0.96154 Mabsadd L
.84229 .35112 1.46946 -2.02254 Mabsadd L
.84229 .35112 .91448 -0.29713 Mabsadd L
.84229 .35112 2.37764 .77254 Mabsadd L
.84229 .35112 .56518 .7779 Mabsadd L
.84229 .35112 0 2.5 Mabsadd L closepath F
.8456 .35016 0 2.5 Mabsadd m
.8456 .35016 -0.56518 .7779 Mabsadd L
.8456 .35016 -2.37764 .77254 Mabsadd L
.8456 .35016 -0.91448 -0.29713 Mabsadd L
.8456 .35016 -1.46946 -2.02254 Mabsadd L
.8456 .35016 0 -0.96154 Mabsadd L
.8456 .35016 1.46946 -2.02254 Mabsadd L
.8456 .35016 .91448 -0.29713 Mabsadd L
.8456 .35016 2.37764 .77254 Mabsadd L
.8456 .35016 .56518 .7779 Mabsadd L
.8456 .35016 0 2.5 Mabsadd L closepath F
.84891 .34941 0 2.5 Mabsadd m
.84891 .34941 -0.56518 .7779 Mabsadd L
.84891 .34941 -2.37764 .77254 Mabsadd L
.84891 .34941 -0.91448 -0.29713 Mabsadd L
.84891 .34941 -1.46946 -2.02254 Mabsadd L
.84891 .34941 0 -0.96154 Mabsadd L
.84891 .34941 1.46946 -2.02254 Mabsadd L
.84891 .34941 .91448 -0.29713 Mabsadd L
.84891 .34941 2.37764 .77254 Mabsadd L
.84891 .34941 .56518 .7779 Mabsadd L
.84891 .34941 0 2.5 Mabsadd L closepath F
.85222 .34931 0 2.5 Mabsadd m
.85222 .34931 -0.56518 .7779 Mabsadd L
.85222 .34931 -2.37764 .77254 Mabsadd L
.85222 .34931 -0.91448 -0.29713 Mabsadd L
.85222 .34931 -1.46946 -2.02254 Mabsadd L
.85222 .34931 0 -0.96154 Mabsadd L
.85222 .34931 1.46946 -2.02254 Mabsadd L
.85222 .34931 .91448 -0.29713 Mabsadd L
.85222 .34931 2.37764 .77254 Mabsadd L
.85222 .34931 .56518 .7779 Mabsadd L
.85222 .34931 0 2.5 Mabsadd L closepath F
.85553 .34964 0 2.5 Mabsadd m
.85553 .34964 -0.56518 .7779 Mabsadd L
.85553 .34964 -2.37764 .77254 Mabsadd L
.85553 .34964 -0.91448 -0.29713 Mabsadd L
.85553 .34964 -1.46946 -2.02254 Mabsadd L
.85553 .34964 0 -0.96154 Mabsadd L
.85553 .34964 1.46946 -2.02254 Mabsadd L
.85553 .34964 .91448 -0.29713 Mabsadd L
.85553 .34964 2.37764 .77254 Mabsadd L
.85553 .34964 .56518 .7779 Mabsadd L
.85553 .34964 0 2.5 Mabsadd L closepath F
.85884 .35036 0 2.5 Mabsadd m
.85884 .35036 -0.56518 .7779 Mabsadd L
.85884 .35036 -2.37764 .77254 Mabsadd L
.85884 .35036 -0.91448 -0.29713 Mabsadd L
.85884 .35036 -1.46946 -2.02254 Mabsadd L
.85884 .35036 0 -0.96154 Mabsadd L
.85884 .35036 1.46946 -2.02254 Mabsadd L
.85884 .35036 .91448 -0.29713 Mabsadd L
.85884 .35036 2.37764 .77254 Mabsadd L
.85884 .35036 .56518 .7779 Mabsadd L
.85884 .35036 0 2.5 Mabsadd L closepath F
.86312 .35687 0 2.5 Mabsadd m
.86312 .35687 -0.56518 .7779 Mabsadd L
.86312 .35687 -2.37764 .77254 Mabsadd L
.86312 .35687 -0.91448 -0.29713 Mabsadd L
.86312 .35687 -1.46946 -2.02254 Mabsadd L
.86312 .35687 0 -0.96154 Mabsadd L
.86312 .35687 1.46946 -2.02254 Mabsadd L
.86312 .35687 .91448 -0.29713 Mabsadd L
.86312 .35687 2.37764 .77254 Mabsadd L
.86312 .35687 .56518 .7779 Mabsadd L
.86312 .35687 0 2.5 Mabsadd L closepath F
.86741 .36533 0 2.5 Mabsadd m
.86741 .36533 -0.56518 .7779 Mabsadd L
.86741 .36533 -2.37764 .77254 Mabsadd L
.86741 .36533 -0.91448 -0.29713 Mabsadd L
.86741 .36533 -1.46946 -2.02254 Mabsadd L
.86741 .36533 0 -0.96154 Mabsadd L
.86741 .36533 1.46946 -2.02254 Mabsadd L
.86741 .36533 .91448 -0.29713 Mabsadd L
.86741 .36533 2.37764 .77254 Mabsadd L
.86741 .36533 .56518 .7779 Mabsadd L
.86741 .36533 0 2.5 Mabsadd L closepath F
.87169 .37468 0 2.5 Mabsadd m
.87169 .37468 -0.56518 .7779 Mabsadd L
.87169 .37468 -2.37764 .77254 Mabsadd L
.87169 .37468 -0.91448 -0.29713 Mabsadd L
.87169 .37468 -1.46946 -2.02254 Mabsadd L
.87169 .37468 0 -0.96154 Mabsadd L
.87169 .37468 1.46946 -2.02254 Mabsadd L
.87169 .37468 .91448 -0.29713 Mabsadd L
.87169 .37468 2.37764 .77254 Mabsadd L
.87169 .37468 .56518 .7779 Mabsadd L
.87169 .37468 0 2.5 Mabsadd L closepath F
.87598 .38352 0 2.5 Mabsadd m
.87598 .38352 -0.56518 .7779 Mabsadd L
.87598 .38352 -2.37764 .77254 Mabsadd L
.87598 .38352 -0.91448 -0.29713 Mabsadd L
.87598 .38352 -1.46946 -2.02254 Mabsadd L
.87598 .38352 0 -0.96154 Mabsadd L
.87598 .38352 1.46946 -2.02254 Mabsadd L
.87598 .38352 .91448 -0.29713 Mabsadd L
.87598 .38352 2.37764 .77254 Mabsadd L
.87598 .38352 .56518 .7779 Mabsadd L
.87598 .38352 0 2.5 Mabsadd L closepath F
.88026 .39102 0 2.5 Mabsadd m
.88026 .39102 -0.56518 .7779 Mabsadd L
.88026 .39102 -2.37764 .77254 Mabsadd L
.88026 .39102 -0.91448 -0.29713 Mabsadd L
.88026 .39102 -1.46946 -2.02254 Mabsadd L
.88026 .39102 0 -0.96154 Mabsadd L
.88026 .39102 1.46946 -2.02254 Mabsadd L
.88026 .39102 .91448 -0.29713 Mabsadd L
.88026 .39102 2.37764 .77254 Mabsadd L
.88026 .39102 .56518 .7779 Mabsadd L
.88026 .39102 0 2.5 Mabsadd L closepath F
.88455 .39674 0 2.5 Mabsadd m
.88455 .39674 -0.56518 .7779 Mabsadd L
.88455 .39674 -2.37764 .77254 Mabsadd L
.88455 .39674 -0.91448 -0.29713 Mabsadd L
.88455 .39674 -1.46946 -2.02254 Mabsadd L
.88455 .39674 0 -0.96154 Mabsadd L
.88455 .39674 1.46946 -2.02254 Mabsadd L
.88455 .39674 .91448 -0.29713 Mabsadd L
.88455 .39674 2.37764 .77254 Mabsadd L
.88455 .39674 .56518 .7779 Mabsadd L
.88455 .39674 0 2.5 Mabsadd L closepath F
.88883 .4005 0 2.5 Mabsadd m
.88883 .4005 -0.56518 .7779 Mabsadd L
.88883 .4005 -2.37764 .77254 Mabsadd L
.88883 .4005 -0.91448 -0.29713 Mabsadd L
.88883 .4005 -1.46946 -2.02254 Mabsadd L
.88883 .4005 0 -0.96154 Mabsadd L
.88883 .4005 1.46946 -2.02254 Mabsadd L
.88883 .4005 .91448 -0.29713 Mabsadd L
.88883 .4005 2.37764 .77254 Mabsadd L
.88883 .4005 .56518 .7779 Mabsadd L
.88883 .4005 0 2.5 Mabsadd L closepath F
.89312 .40244 0 2.5 Mabsadd m
.89312 .40244 -0.56518 .7779 Mabsadd L
.89312 .40244 -2.37764 .77254 Mabsadd L
.89312 .40244 -0.91448 -0.29713 Mabsadd L
.89312 .40244 -1.46946 -2.02254 Mabsadd L
.89312 .40244 0 -0.96154 Mabsadd L
.89312 .40244 1.46946 -2.02254 Mabsadd L
.89312 .40244 .91448 -0.29713 Mabsadd L
.89312 .40244 2.37764 .77254 Mabsadd L
.89312 .40244 .56518 .7779 Mabsadd L
.89312 .40244 0 2.5 Mabsadd L closepath F
.89798 .40547 0 2.5 Mabsadd m
.89798 .40547 -0.56518 .7779 Mabsadd L
.89798 .40547 -2.37764 .77254 Mabsadd L
.89798 .40547 -0.91448 -0.29713 Mabsadd L
.89798 .40547 -1.46946 -2.02254 Mabsadd L
.89798 .40547 0 -0.96154 Mabsadd L
.89798 .40547 1.46946 -2.02254 Mabsadd L
.89798 .40547 .91448 -0.29713 Mabsadd L
.89798 .40547 2.37764 .77254 Mabsadd L
.89798 .40547 .56518 .7779 Mabsadd L
.89798 .40547 0 2.5 Mabsadd L closepath F
.90284 .4029 0 2.5 Mabsadd m
.90284 .4029 -0.56518 .7779 Mabsadd L
.90284 .4029 -2.37764 .77254 Mabsadd L
.90284 .4029 -0.91448 -0.29713 Mabsadd L
.90284 .4029 -1.46946 -2.02254 Mabsadd L
.90284 .4029 0 -0.96154 Mabsadd L
.90284 .4029 1.46946 -2.02254 Mabsadd L
.90284 .4029 .91448 -0.29713 Mabsadd L
.90284 .4029 2.37764 .77254 Mabsadd L
.90284 .4029 .56518 .7779 Mabsadd L
.90284 .4029 0 2.5 Mabsadd L closepath F
.9077 .39846 0 2.5 Mabsadd m
.9077 .39846 -0.56518 .7779 Mabsadd L
.9077 .39846 -2.37764 .77254 Mabsadd L
.9077 .39846 -0.91448 -0.29713 Mabsadd L
.9077 .39846 -1.46946 -2.02254 Mabsadd L
.9077 .39846 0 -0.96154 Mabsadd L
.9077 .39846 1.46946 -2.02254 Mabsadd L
.9077 .39846 .91448 -0.29713 Mabsadd L
.9077 .39846 2.37764 .77254 Mabsadd L
.9077 .39846 .56518 .7779 Mabsadd L
.9077 .39846 0 2.5 Mabsadd L closepath F
.91256 .39224 0 2.5 Mabsadd m
.91256 .39224 -0.56518 .7779 Mabsadd L
.91256 .39224 -2.37764 .77254 Mabsadd L
.91256 .39224 -0.91448 -0.29713 Mabsadd L
.91256 .39224 -1.46946 -2.02254 Mabsadd L
.91256 .39224 0 -0.96154 Mabsadd L
.91256 .39224 1.46946 -2.02254 Mabsadd L
.91256 .39224 .91448 -0.29713 Mabsadd L
.91256 .39224 2.37764 .77254 Mabsadd L
.91256 .39224 .56518 .7779 Mabsadd L
.91256 .39224 0 2.5 Mabsadd L closepath F
.91742 .38594 0 2.5 Mabsadd m
.91742 .38594 -0.56518 .7779 Mabsadd L
.91742 .38594 -2.37764 .77254 Mabsadd L
.91742 .38594 -0.91448 -0.29713 Mabsadd L
.91742 .38594 -1.46946 -2.02254 Mabsadd L
.91742 .38594 0 -0.96154 Mabsadd L
.91742 .38594 1.46946 -2.02254 Mabsadd L
.91742 .38594 .91448 -0.29713 Mabsadd L
.91742 .38594 2.37764 .77254 Mabsadd L
.91742 .38594 .56518 .7779 Mabsadd L
.91742 .38594 0 2.5 Mabsadd L closepath F
.92228 .38066 0 2.5 Mabsadd m
.92228 .38066 -0.56518 .7779 Mabsadd L
.92228 .38066 -2.37764 .77254 Mabsadd L
.92228 .38066 -0.91448 -0.29713 Mabsadd L
.92228 .38066 -1.46946 -2.02254 Mabsadd L
.92228 .38066 0 -0.96154 Mabsadd L
.92228 .38066 1.46946 -2.02254 Mabsadd L
.92228 .38066 .91448 -0.29713 Mabsadd L
.92228 .38066 2.37764 .77254 Mabsadd L
.92228 .38066 .56518 .7779 Mabsadd L
.92228 .38066 0 2.5 Mabsadd L closepath F
.92714 .37768 0 2.5 Mabsadd m
.92714 .37768 -0.56518 .7779 Mabsadd L
.92714 .37768 -2.37764 .77254 Mabsadd L
.92714 .37768 -0.91448 -0.29713 Mabsadd L
.92714 .37768 -1.46946 -2.02254 Mabsadd L
.92714 .37768 0 -0.96154 Mabsadd L
.92714 .37768 1.46946 -2.02254 Mabsadd L
.92714 .37768 .91448 -0.29713 Mabsadd L
.92714 .37768 2.37764 .77254 Mabsadd L
.92714 .37768 .56518 .7779 Mabsadd L
.92714 .37768 0 2.5 Mabsadd L closepath F
.932 .37832 0 2.5 Mabsadd m
.932 .37832 -0.56518 .7779 Mabsadd L
.932 .37832 -2.37764 .77254 Mabsadd L
.932 .37832 -0.91448 -0.29713 Mabsadd L
.932 .37832 -1.46946 -2.02254 Mabsadd L
.932 .37832 0 -0.96154 Mabsadd L
.932 .37832 1.46946 -2.02254 Mabsadd L
.932 .37832 .91448 -0.29713 Mabsadd L
.932 .37832 2.37764 .77254 Mabsadd L
.932 .37832 .56518 .7779 Mabsadd L
.932 .37832 0 2.5 Mabsadd L closepath F
.93686 .38381 0 2.5 Mabsadd m
.93686 .38381 -0.56518 .7779 Mabsadd L
.93686 .38381 -2.37764 .77254 Mabsadd L
.93686 .38381 -0.91448 -0.29713 Mabsadd L
.93686 .38381 -1.46946 -2.02254 Mabsadd L
.93686 .38381 0 -0.96154 Mabsadd L
.93686 .38381 1.46946 -2.02254 Mabsadd L
.93686 .38381 .91448 -0.29713 Mabsadd L
.93686 .38381 2.37764 .77254 Mabsadd L
.93686 .38381 .56518 .7779 Mabsadd L
.93686 .38381 0 2.5 Mabsadd L closepath F
.94172 .3952 0 2.5 Mabsadd m
.94172 .3952 -0.56518 .7779 Mabsadd L
.94172 .3952 -2.37764 .77254 Mabsadd L
.94172 .3952 -0.91448 -0.29713 Mabsadd L
.94172 .3952 -1.46946 -2.02254 Mabsadd L
.94172 .3952 0 -0.96154 Mabsadd L
.94172 .3952 1.46946 -2.02254 Mabsadd L
.94172 .3952 .91448 -0.29713 Mabsadd L
.94172 .3952 2.37764 .77254 Mabsadd L
.94172 .3952 .56518 .7779 Mabsadd L
.94172 .3952 0 2.5 Mabsadd L closepath F
.94659 .41294 0 2.5 Mabsadd m
.94659 .41294 -0.56518 .7779 Mabsadd L
.94659 .41294 -2.37764 .77254 Mabsadd L
.94659 .41294 -0.91448 -0.29713 Mabsadd L
.94659 .41294 -1.46946 -2.02254 Mabsadd L
.94659 .41294 0 -0.96154 Mabsadd L
.94659 .41294 1.46946 -2.02254 Mabsadd L
.94659 .41294 .91448 -0.29713 Mabsadd L
.94659 .41294 2.37764 .77254 Mabsadd L
.94659 .41294 .56518 .7779 Mabsadd L
.94659 .41294 0 2.5 Mabsadd L closepath F
.95145 .43658 0 2.5 Mabsadd m
.95145 .43658 -0.56518 .7779 Mabsadd L
.95145 .43658 -2.37764 .77254 Mabsadd L
.95145 .43658 -0.91448 -0.29713 Mabsadd L
.95145 .43658 -1.46946 -2.02254 Mabsadd L
.95145 .43658 0 -0.96154 Mabsadd L
.95145 .43658 1.46946 -2.02254 Mabsadd L
.95145 .43658 .91448 -0.29713 Mabsadd L
.95145 .43658 2.37764 .77254 Mabsadd L
.95145 .43658 .56518 .7779 Mabsadd L
.95145 .43658 0 2.5 Mabsadd L closepath F
.95631 .46434 0 2.5 Mabsadd m
.95631 .46434 -0.56518 .7779 Mabsadd L
.95631 .46434 -2.37764 .77254 Mabsadd L
.95631 .46434 -0.91448 -0.29713 Mabsadd L
.95631 .46434 -1.46946 -2.02254 Mabsadd L
.95631 .46434 0 -0.96154 Mabsadd L
.95631 .46434 1.46946 -2.02254 Mabsadd L
.95631 .46434 .91448 -0.29713 Mabsadd L
.95631 .46434 2.37764 .77254 Mabsadd L
.95631 .46434 .56518 .7779 Mabsadd L
.95631 .46434 0 2.5 Mabsadd L closepath F
.96117 .49295 0 2.5 Mabsadd m
.96117 .49295 -0.56518 .7779 Mabsadd L
.96117 .49295 -2.37764 .77254 Mabsadd L
.96117 .49295 -0.91448 -0.29713 Mabsadd L
.96117 .49295 -1.46946 -2.02254 Mabsadd L
.96117 .49295 0 -0.96154 Mabsadd L
.96117 .49295 1.46946 -2.02254 Mabsadd L
.96117 .49295 .91448 -0.29713 Mabsadd L
.96117 .49295 2.37764 .77254 Mabsadd L
.96117 .49295 .56518 .7779 Mabsadd L
.96117 .49295 0 2.5 Mabsadd L closepath F
.9656 .49638 0 2.5 Mabsadd m
.9656 .49638 -0.56518 .7779 Mabsadd L
.9656 .49638 -2.37764 .77254 Mabsadd L
.9656 .49638 -0.91448 -0.29713 Mabsadd L
.9656 .49638 -1.46946 -2.02254 Mabsadd L
.9656 .49638 0 -0.96154 Mabsadd L
.9656 .49638 1.46946 -2.02254 Mabsadd L
.9656 .49638 .91448 -0.29713 Mabsadd L
.9656 .49638 2.37764 .77254 Mabsadd L
.9656 .49638 .56518 .7779 Mabsadd L
.9656 .49638 0 2.5 Mabsadd L closepath F
.97003 .50853 0 2.5 Mabsadd m
.97003 .50853 -0.56518 .7779 Mabsadd L
.97003 .50853 -2.37764 .77254 Mabsadd L
.97003 .50853 -0.91448 -0.29713 Mabsadd L
.97003 .50853 -1.46946 -2.02254 Mabsadd L
.97003 .50853 0 -0.96154 Mabsadd L
.97003 .50853 1.46946 -2.02254 Mabsadd L
.97003 .50853 .91448 -0.29713 Mabsadd L
.97003 .50853 2.37764 .77254 Mabsadd L
.97003 .50853 .56518 .7779 Mabsadd L
.97003 .50853 0 2.5 Mabsadd L closepath F
.97311 .49997 0 2.5 Mabsadd m
.97311 .49997 -0.56518 .7779 Mabsadd L
.97311 .49997 -2.37764 .77254 Mabsadd L
.97311 .49997 -0.91448 -0.29713 Mabsadd L
.97311 .49997 -1.46946 -2.02254 Mabsadd L
.97311 .49997 0 -0.96154 Mabsadd L
.97311 .49997 1.46946 -2.02254 Mabsadd L
.97311 .49997 .91448 -0.29713 Mabsadd L
.97311 .49997 2.37764 .77254 Mabsadd L
.97311 .49997 .56518 .7779 Mabsadd L
.97311 .49997 0 2.5 Mabsadd L closepath F
.97465 .50395 0 2.5 Mabsadd m
.97465 .50395 -0.56518 .7779 Mabsadd L
.97465 .50395 -2.37764 .77254 Mabsadd L
.97465 .50395 -0.91448 -0.29713 Mabsadd L
.97465 .50395 -1.46946 -2.02254 Mabsadd L
.97465 .50395 0 -0.96154 Mabsadd L
.97465 .50395 1.46946 -2.02254 Mabsadd L
.97465 .50395 .91448 -0.29713 Mabsadd L
.97465 .50395 2.37764 .77254 Mabsadd L
.97465 .50395 .56518 .7779 Mabsadd L
.97465 .50395 0 2.5 Mabsadd L closepath F
.97619 .50013 0 2.5 Mabsadd m
.97619 .50013 -0.56518 .7779 Mabsadd L
.97619 .50013 -2.37764 .77254 Mabsadd L
.97619 .50013 -0.91448 -0.29713 Mabsadd L
.97619 .50013 -1.46946 -2.02254 Mabsadd L
.97619 .50013 0 -0.96154 Mabsadd L
.97619 .50013 1.46946 -2.02254 Mabsadd L
.97619 .50013 .91448 -0.29713 Mabsadd L
.97619 .50013 2.37764 .77254 Mabsadd L
.97619 .50013 .56518 .7779 Mabsadd L
.97619 .50013 0 2.5 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[23]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00=?oo0P008Ooo0`007Ooo10000ooo0P00
6ooo10000_oo0`006_oo10000ooo0P006ooo10000_oo0`006ooo0P001?oo0P004_oo000cool01000
ooooo`008ooo00<00?ooool07?oo00D00?ooooooo`0000;oo`03003ooooo01[oo`03003ooooo00Co
o`03003ooooo01Ooo`03003ooooo00?oo`04003ooooo000Jool00`00ooooo`06ool00`00ooooo`0G
ool01000ooooo`000_oo00@00?ooool0017oo`00<ooo00@00?ooool002?oo`03003ooooo01coo`05
003oooooool00002ool00`00ooooo`0Jool00`00ooooo`04ool00`00ooooo`0Hool00`00ooooo`02
ool01000ooooo`006ooo00<00?ooool01Ooo00<00?ooool06_oo00@00?ooool000;oo`03003ooooo
00ooo`00<ooo00@00?ooool0023oo`<001ooo`05003oooooool00002ool00`00ooooo`0Jool01000
oooooooo0`007?oo00D00?ooooooo`0000;oo`03003ooooo01[oo`04003oooooool3000Kool20003
ool01000ooooo`004Ooo000cool01000ooooo`008?oo00<00?ooool07ooo00D00?ooooooo`0000;o
o`03003ooooo01[oo`05003oooooool0000Oool01000ooooo`000_oo00<00?ooool06ooo00@00?oo
ool001ooo`04003ooooo0002ool00`00ooooo`0?ool003?oo`04003ooooo000Pool00`00ooooo`0M
ool30003ool01000ooooo`006_oo0`000ooo00<00?ooool06_oo00@00?ooool000;oo`04003ooooo
000Jool01000ooooo`000_oo00<00?ooool06_oo00@00?ooool000;oo`04003ooooo000Aool003Co
o`80027oo`@001koo`03003ooooo00;oo`8001goo`04003oooooool4000Jool20004ool2000Lool2
0003ool4000Jool20004ool2000Bool00?ooob7oo`00oooo8Ooo003ooolQool002oooo00007oo`00
;ooo00<00?ooool00ooo00<00?ooool08Ooo00<00?ooool08?oo00<00?ooool08Ooo00<00?ooool0
8?oo00<00?ooool08Ooo00<00?ooool08?oo00<00?ooool04Ooo0@000Ooo000_ool00`00ooooo`3/
ool10001ool002Woo`8000Coo`03003ooooo0>coo`40007oo`00:?oo00@00?ooool000?oo`03003o
oooo00;oo`<07nOoo`40007oo`00:?oo00@00?ooool000?oo`<00005oooh000O01oh003Vool20001
ool002Soo`04003ooooo0003ool01000oooooooo1@0Oi_oo0@000Ooo000Xool01000ooooo`000ooo
00<00?ooool00ooo0`0Oi_oo0@000Ooo000Xool01000ooooo`000ooo00<00?ooool00_oo0`0O5ooo
0P0Oc_oo0@000Ooo000Yool20004ool00`00ooooo`02ool501lDool401o=ool10001ool002ooo`04
003oooooool501l8ool00`0Oooooo`08ool701o<ool10001ool002ooo`04003oooooool601l7ool2
01l9ool201l00ooo01l07`0301o;ool10001ool002ooo`03003ooooo00;oo`D07`Koo`@07`Ooo`D0
7`03ool07`0O0<coo`40007oo`00;ooo0P000_oo1`0O1?oo1@0O1ooo0`0O0_oo1@0ObOoo0P000Ooo
000_ool01000oooooooo1@0O1Ooo1P0O1_oo100O1?oo00<07oooool0b_oo0@000Ooo000_ool00`00
ooooo`02ool3n00201l3ool801l5ool301oBool10001ool002ooo`03003ooooo00?oo`;h00807`;o
o`D07`03oooh000O00807`?oo`@07`Goo`<07l[oo`40007oo`00;ooo00<00?ooool00_oo0_P01@0O
00?oo`0O01l00_oo2P0O1ooo0P0Obooo0@000Ooo000_ool00`00ooooo`03ool3n00201l00ooo01l0
7`0201l2n00:01l5ool501o9ool10001ool002ooo`03003ooooo00;oo`?h00H07`;oo`?h0003ool0
7`0O00D07`Soo`0301oooooo0<Woo`40007oo`00;ooo0P000ooo1OP01P0O0oP01Ooo00<07oooool0
1?oo0_P0cOoo0P000Ooo000_ool01000oooooooo1?P01P0O00?oooP0n0000oP02_oo1?P0cOoo0@00
0Ooo000_ool00`00ooooo`02ool2n003ool301l00ooon03h0005n007ool6n03=ool10001ool002oo
o`03003ooooo00Koo`D07`?h0004oooh0?P0n006ool8n0000ooo01l07`0_ool201l00ooo01ooo`2E
ool10001ool002ooo`03003ooooo00Koo`D07`?h00;oo`03n03ooooo00Koo`Oh0003ool07`0O02oo
o`P07i;oo`40007oo`00;ooo00<00?ooool01Ooo0_P01@0O0_P00_oo0_P01_oo0oP00_oo0_P01@0O
;Ooo2@0OT_oo0@000Ooo000_ool00`00ooooo`04ool4n003ool3n0000ooon03h0002n004ool4n00h
ool801nAool10001ool002ooo`8000Koo`?h00;oo`?h00?oo`Ch00?oo`?h03Ooo`D07`03ool07`0O
00807i3oo`80007oo`00;ooo00<00?ooool01_oo0_P000?oooP0n0000_P00ooo2_P01?oo0_P0<Ooo
0P0O1Ooo100OT?oo0@000Ooo000_ool00`00ooooo`06ool2n002ool2n005ool8n004ool4n00^ool5
01l6ool201n@ool10001ool002ooo`03003ooooo00Goo`Ch00Woo`Oh00Goo`?h03Woo`807i3oo`40
007oo`00;ooo00<00?ooool01_oo0oP000?oooP0ool02?oo1?P01ooo00?h0?ooool0=ooo100O2_oo
100OPOoo0@000Ooo000_ool00`00ooooo`07ool5n00Fool201lgool301l8ool601n0ool10001ool0
02ooo`03003ooooo00Ooo`Gh01Koo`807cOoo`807`Soo`L07h3oo`40007oo`00;ooo00<00?ooool0
1_oo1OP05Ooo1@0O=Ooo1@0O1_oo200OOooo0@000Ooo000_ool20008ool2n016ool00`0Oool07`0:
ool201l6ool401l3ool201mnool20001ool002ooo`03003ooooo00Koo`Ch01Koo`03n03ooooo02co
o`807`[oo`D07`Coo`<07`Coo`807gooo`40007oo`00;ooo00<00?ooool01ooo0oP05_oo0_P03Ooo
100O6ooo1@0O2_oo100O00?oo`0O01l00`0O0ooo100OO_oo0@000Ooo000_ool00`00ooooo`08ool3
n00Dool3n00<ool501lMool00`0Oooooo`09ool:01n6ool10001ool000goo`<000?oo`05003ooooo
ool00006ool40003ool20008ool00`00ooooo`07ool4n00Eool00oP0ooooo`0;ool701lXool601n9
ool10001ool0013oo`07003oooooool00?oo00002Ooo00D00?ooooooo`0000;oo`03003ooooo00Go
o`03003ooooo00Soo`?h02;oo`T07bSoo`L07`Ooo`<07ggoo`40007oo`004?oo00<00?ooool00_oo
00<00?ooool02?oo00D00?ooooooo`0000;oo`03003ooooo00Goo`03003ooooo00Soo`?h027oo`D0
7`;oo`807bcoo`0301oooooo00Soo`807gkoo`40007oo`003Ooo0`001?oo00<00?oo00002Ooo00D0
0?ooooooo`0000;oo`03003ooooo00Goo`<000Woo`;h01Soo`807`Ooo`<07`?oo`@07cGoo`@07gco
o`80007oo`003Ooo00<00?ooool00ooo00D00?ooooooo`0000Soo`05003oooooool00002ool00`00
ooooo`05ool00`00ooooo`0:ool00oP0ooooo`0Fool201l7ool201l5ool401neool10001ool000go
o`03003ooooo00koo`<000?oo`04003ooooo0007ool2000Sool401l5ool501l5ool301ndool10001
ool000goo`@000ooo`03003ooooo00;oo`8000Soo`03003oo`0002Coo`0301oooooo00Coo`<07`Ko
o`@07`Soo`<07`_oo`<07`04oooh0?P0n02Gool10001ool002[oo`<000;oo`03003oo`0002_oo`80
7`Soo`@07`Ooo`807`coo`807`03oooh0?P000Oh01?oo`<07gcoo`40007oo`00;ooo0P00:ooo1@0O
2?oo0`0O1Ooo1@0O2Ooo1@0O2OP04_oo0P0OOOoo0@000Ooo000_ool00`00ool0000Zool301l:ool2
01l5ool501l@ool8n00Aool501mkool10001ool002ooo`<0027oo`;h00Ooo`807`[oo`D07`;oo`P0
7`koo`Sh01?oo`0301oooooo07[oo`80007oo`00;ooo00<00?ooool08?oo0oP01_oo1@0O2_oo2@0O
00Coo`0O01l07`goo`Ch00?oo`?h093oo`40007oo`00;ooo00<00?ooool08Ooo0_P000Coo`0O01l0
7`;oo`<07`_oo`T07`?oo`807`koo`;h00?oo`Ch03;oo`<07e_oo`40007oo`00;ooo00<00?ooool0
8_oo00Ch0?oo01l07`?oo`807`goo`L07`;oo`D07a?oo`;h01ooo`D07`koo`D07e[oo`40007oo`00
;ooo00<00?ooool08ooo2P0O3_oo00<07oooool04ooo0_P09_oo2@0O2_oo1P0OF_oo0@000Ooo000_
ool00`00ooooo`0Uool00`0Oool07`0301lIool201l7ool201l00ooon03h0002n006ool2n00Cool0
0`0Oooooo`05ool:01l;ool701mIool10001ool002ooo`03003ooooo02Ooo`D07aOoo`@07`Coo`D0
7`04oooh0?P0n005ool4n00@ool501l6ool;01l8ool401l2ool201mIool10001ool002ooo`03003o
oooo02Goo`D07a_oo`<07`[oo`03n03ooooo00Goo`?h01;oo`0301oooooo00Koo`<07`Goo`@07`Oo
o`<07`?oo`807eWoo`40007oo`00;ooo0P00:?oo0P0O7?oo0P0O5?oo00?h0?ooool06?oo1@0O1?oo
1@0O1Ooo1@0O00?oo`0O01l00`0OEooo0P000Ooo000_ool00`00ooooo`0Vool501lIool501lBool2
n00Sool501l5ool00`0Oooooo`1Oool10001ool002ooo`03003ooooo02Goo`@07agoo`0301oooooo
017oo`Ch01Woo`807`Woo`@07`;oo`D07eooo`40007oo`00;ooo00<00?ooool09?oo1@0O7_oo00<0
7oooool00_oo0P0O3Ooo0oP06Ooo0P0O2?oo2@0O2?oo0P0OF?oo0@000Ooo000_ool00`00ooooo`15
ool501l2ool00`0Oooooo`0=ool00oP0ooooo`0Fool501l8ool:01l6ool201mHool10001ool002oo
o`03003ooooo04Ooo`P07`goo`;h01;oo`807`Coo`807`coo`L07`Koo`@07eOoo`40007oo`00;ooo
00<00?ooool0B?oo1@0O3_oo1?P02Ooo00?h0?ooool00ooo1@0O00?oo`0O01l00`0O3_oo0P0O2_oo
00<07oooool0E_oo0@000Ooo000_ool2000Tool00oP0ooooo`0Pool601l@ool3n008ool4n020ool2
0001ool002ooo`03003ooooo02;oo`?h02Coo`D07`ooo`;h00Ooo`Gh00[oo`807gGoo`40007oo`00
;ooo00<00?ooool08Ooo1?P08ooo100O1?oo00?h0?ooool02_oo0oP01Ooo1_P01ooo1P0OM?oo0@00
0Ooo000_ool00`00ooooo`0Rool2n00Vool00`0Oooooo`03ool2n00:ool4n004ool4n0001?oon03h
0?P01Ooo1@0OM_oo0@000Ooo000_ool00`00ooooo`1?ool3n00;ool3n004ool4n002ool3n003ool7
01lLool201mGool10001ool002ooo`03003ooooo053oo`03n03ooooo00[oo`Ch00;oo`Ch00;oo`Ch
00Coo`@07agoo`D07eGoo`40007oo`00;ooo00<00?ooool0<?oo0_P0;?oo2OP00ooo0_P00ooo1`0O
7_oo00<07oooool0EOoo0@000Ooo000_ool2000`ool4n00/ool7n025ool20001ool002ooo`03003o
oooo02koo`Kh02coo`Gh08Ooo`40007oo`00;ooo00<00?ooool0;_oo1oP0;?oo0_P02?oo0_P0Oooo
0@000Ooo000_ool00`00ooooo`0]ool8n00eool4n01nool10001ool000goo`@000;oo`05003ooooo
ool00006ool40003ool20008ool00`00ooooo`0^ool2n002ool3n00fool3n01nool10001ool000oo
o`03003ooooo00;oo`03003oo`0000Woo`05003oooooool00002ool00`00ooooo`05ool00`00oooo
o`0]ool3n002ool4n00fool00oP0ooooo`1mool10001ool000ooo`03003ooooo00?oo`03003ooooo
00Soo`05003oooooool00002ool00`00ooooo`05ool00`00ooooo`0/ool4n003ool3n01Oool00`0O
ooooo`1Dool10001ool000ooo`03003ooooo00;oo`03003oo`0000Woo`05003oooooool00002ool0
0`00ooooo`05ool00`00ooooo`0]ool2n004ool4n01Lool501l:ool301m7ool10001ool000ooo`05
003oooooool00003ool00`00ooooo`06ool01@00oooooooo00000_oo00<00?ooool01Ooo0`00=?oo
0oP0G_oo00<07oooool02Ooo1@0OAOoo0P000Ooo000=ool3000>ool30003ool01000ooooo`001ooo
00<00?ooool0;?oo0_P01ooo0oP0JOoo1@0OA_oo0@000Ooo000?ool00`00ooooo`0>ool00`00oooo
o`02ool20008ool2000Tool2n006ool4n005ool4n00dool2n00bool701m5ool10001ool002ooo`80
02?oo`Ch00Koo`?h00Koo`Ch03;oo`Ch037oo`<07`03ool07`0O00807akoo`H07b3oo`40007oo`00
:_oo0`000_oo0P009?oo0oP01ooo00?h0?ooool01Ooo1?P05Ooo0_P07?oo0oP0<?oo100O0ooo0P0O
6ooo2@0O8?oo0@000Ooo000_ool00`00ool0000Tool00oP0ooooo`0?ool2n00Eool4n00Lool00oP0
ooooo`0_ool201l4ool401lHool<01lOool10001ool002ooo`03003oo`0002coo`03n03ooooo01oo
o`?h04goo`@07`Goo`807aOoo`T07`;oo`807aooo`40007oo`00;ooo0`00:ooo0oP08Ooo00?h0?oo
ool0A?oo0P0O1_oo00<07ooo01l01Ooo100O6?oo1@0O0_oo1@0O7Ooo0P000Ooo000_ool00`00oooo
o`0Zool4n009ool2n01Mool201l6ool201l6ool501l8ool301l<ool301l7ool201lNool10001ool0
02ooo`03003ooooo02_oo`;h00Woo`Ch00Ooo`03n03ooooo053oo`D07`Coo`@07`Koo`D07`Koo`<0
7`goo`807`Koo`D07agoo`40007oo`00;ooo00<00?ooool0=ooo0oP01_oo0oP0G?oo00<07oooool0
3ooo1P0O2Ooo1@0O2?oo0P0O2ooo100O3_oo0@000Ooo000_ool00`00ooooo`0Zool2n00<ool2n005
ool4n01Jool201l;ool201l4ool601lEool501l9ool601l=ool10001ool002ooo`03003ooooo02Wo
o`Ch00[oo`Ch00Coo`Ch05Woo`@07`[oo`@07`03ool07`0O00L07aKoo`807`Ooo`P07`goo`40007o
o`00;ooo00<00?ooool0:_oo0oP02ooo0oP00ooo1_P0:Ooo0_P0;ooo00<07oooool02?oo2P0O0_oo
0`0O2?oo0P0O2_oo1@0O1_oo2@0O3?oo0@000Ooo000_ool2000/ool00oP0ooooo`0;ool;n00Xool4
n00/ool201l<ool801l4ool00`0Oooooo`07ool201l=ool301l4ool501l2ool301l;ool20001ool0
02ooo`03003ooooo03Soo`Sh00;oo`03n03ooooo02Soo`?h02coo`807`goo`H07`?oo`D07`Goo`D0
7`[oo`H07`;oo`D07`Coo`0301oooooo00_oo`40007oo`00;ooo00<00?ooool0>Ooo1_P01?oo0_P0
:Ooo00?h0?ooool09_oo0P0O0_oo100O3_oo00<07oooool01ooo0P0O5Ooo2P0O1?oo1@0O2ooo0@00
0Ooo000_ool00`00ooooo`0Uool01?P0oooooooo0_P04?oo00?h0?oon0001?oo1?P0DOoo0P0O0_oo
0`0O6Ooo0P0O5_oo2P0O4ooo0@000Ooo000_ool00`00ooooo`0Tool3n0000ooon03h0002n00Gool3
n01?ool901lGool501lHool601l7ool201l;ool10001ool002ooo`03003ooooo02?oo`Ch00;oo`?h
01Soo`03n03ooooo00Koo`;h04[oo`807`03ool07ooo01[oo`<07aWoo`0301oooooo00Soo`807`_o
o`40007oo`00;ooo00<00?ooool09?oo0_P00_oo0oP08Ooo1?P0B?oo1@0O6ooo0P0O1Ooo00<07ooo
ool06ooo1@0O2_oo0@000Ooo000_ool00`00ooooo`0Wool4n00Jool00oP0ooooo`05ool3n01:ool2
01lKool401l3ool301l[ool10001ool002ooo`8002Soo`Ch01Woo`?h00Ooo`03n03ooooo02Woo`Kh
01Soo`D07acoo`<07`03ool07`0O00<07bWoo`80007oo`00;ooo00<00?ooool09ooo0oP06Ooo1?P0
<_oo1oP06?oo0P0O7ooo0P0O<Ooo0@000Ooo000_ool00`00ooooo`0Vool3n00Kool2n00cool8n00F
ool401lMool801lPool201l:ool10001ool002ooo`03003ooooo02Ooo`;h04ooo`[h03Soo`D07b7o
o`807`[oo`40007oo`00;ooo00<00?ooool0:?oo0_P06ooo0_P0:?oo00?h0?ooool01ooo0oP00ooo
0oP0=ooo200O7Ooo1@0O2Ooo0@000Ooo000_ool00`00ooooo`0Wool3n00Jool4n00Vool3n009ool0
0oP0ooooo`03ool3n00;ool00oP0ooooo`0Zool401l]ool10001ool002ooo`03003ooooo02Koo`03
n03oooP001coo`?h02Ooo`;h00Soo`03n03ooooo00?oo`Ch00[oo`?h05coo`40007oo`00;ooo0P00
9_oo0oP07_oo00?h0?ooool09_oo00?h0?ooool01_oo0oP01Ooo0oP02Ooo1OP0F_oo0P000Ooo000_
ool00`00ooooo`0Vool2n00Uool00oP0ooooo`0Wool4n005ool4n007ool7n01Jool10001ool002oo
o`03003ooooo02Koo`03n03ooooo01koo`03n03ooooo00;oo`;h02[oo`;h00Ooo`?h00Soo`Kh04oo
o`807`Woo`40007oo`00;ooo00<00?ooool0Aooo0_P00_oo0oP0=?oo0oP01_oo0oP000CoooP0n03h
04koo`@07`Soo`40007oo`0000?oo`0000000P000ooo00<00?ooool00_oo0`000ooo00D00?oooooo
o`0000Koo`@000?oo`8000Soo`03003ooooo04Koo`?h00?oo`;h03?oo`Ch00Goo`Ch00;oo`;h053o
o`0301oooooo00Ooo`40007oo`000ooo00<00?ooool02_oo00L00?ooooooo`00ool00009ool01@00
oooooooo00000_oo00<00?ooool01Ooo00<00?ooool0Aooo00?h0?ooool0;Ooo0_P02Ooo1?P01?oo
0oP0Gooo0@000Ooo0003ool00`00ooooo`0:ool00`00ooooo`02ool00`00ooooo`08ool01@00oooo
oooo00000_oo00<00?ooool01Ooo00<00?ooool0M_oo1?P02Ooo1?P00_oo0oP0H?oo0@000Ooo0003
ool00`00ooooo`07ool30004ool00`00ool00009ool01@00oooooooo00000_oo00<00?ooool01Ooo
0`00B?oo0_P000?oooP0ool0:_oo0oP02Ooo2OP01_oo00?h0?ooool0E_oo0P000Ooo0003ool00`00
ooooo`07ool00`00ooooo`03ool01@00oooooooo00002?oo00D00?ooooooo`0000;oo`03003ooooo
00Goo`03003ooooo04Ooo`Kh02_oo`03n03ooooo00Woo`Oh00Koo`?h04koo`<07`Ooo`40007oo`00
00Coo`00000000Woo`03003ooooo00koo`<000?oo`04003ooooo0007ool20019ool5n00hool5n006
ool4n01>ool401l6ool10001ool000?oo`03003ooooo00Ooo`@000ooo`03003ooooo00;oo`8000So
o`8004Woo`Ch02Coo`;h00Coo`;h00ooo`;h00Soo`;h04koo`L07`Coo`40007oo`00:_oo0`000_oo
0P00B_oo0oP08ooo1?P00_oo1?P0JOoo1P0O1?oo0@000Ooo000_ool00`00ool0001:ool00oP0oooo
o`0Sool3n003ool3n01[ool501l3ool10001ool002ooo`03003oo`00077oo`03n03ooooo00?oo`03
n03ooooo06[oo`D07`?oo`40007oo`00;ooo0`00hooo1@0O1?oo0@000Ooo000_ool2001fool2n01^
ool00`0Oooooo`03ool20001ool002ooo`03003ooooo07Coo`Ch07Coo`40007oo`00;ooo00<00?oo
ool0Looo1OP06_oo0_P0F?oo0@000Ooo000_ool00`00ooooo`1bool5n00Jool4n01Gool10001ool0
02ooo`03003ooooo077oo`Kh01_oo`?h05Ooo`40007oo`00;ooo00<00?ooool0L_oo0_P000?oooP0
ool07?oo00?h0?ooool0E_oo0@000Ooo000_ool00`00ooooo`1bool3n01gool10001ool002ooo`80
07;oo`Gh07Goo`80007oo`00;ooo00<00?ooool0L?oo1_P0M_oo0@000Ooo000_ool00`00ooooo`1a
ool2n0000ooon03oo`1fool10001ool002ooo`03003ooooo0>coo`40007oo`00;ooo00<00?ooool0
k?oo0@000Ooo000_ool00`00ooooo`3/ool10001ool002ooo`03003ooooo0>coo`40007oo`00;ooo
0P00UOoo00?h0?ooool0E?oo0P000Ooo000_ool00`00ooooo`2Cool3n01Fool10001ool002ooo`03
003ooooo09;oo`Ch05Koo`40007oo`00;ooo00<00?ooool0Tooo0_P0Eooo0@000Ooo000_ool00`00
ooooo`3/ool10001ool002ooo`03003ooooo0>coo`40007oo`00;ooo00<00?ooool0k?oo0@000Ooo
000_ool00`00ooooo`3/ool10001ool002ooo`800>coo`80007oo`00;ooo00<00?ooool0k?oo0@00
0Ooo000_ool00`00ooooo`3/ool10001ool002ooo`03003ooooo0>coo`40007oo`003Ooo10000_oo
00D00?ooooooo`0000Koo`@000?oo`8000Soo`03003ooooo0>coo`40007oo`003Ooo00<00?ooool0
1?oo00<00?oo00002Ooo00D00?ooooooo`0000;oo`03003ooooo00Goo`03003ooooo0>coo`40007o
o`003_oo00<00?ooool01?oo00<00?ooool02?oo00D00?ooooooo`0000;oo`03003ooooo00Goo`03
003ooooo0>coo`40007oo`003ooo00<00?ooool00_oo00<00?oo00002Ooo00D00?ooooooo`0000;o
o`03003ooooo00Goo`<00>_oo`80007oo`004?oo00@00?ooool000?oo`03003ooooo00Koo`05003o
ooooool00002ool00`00ooooo`05ool00`00ooooo`2Eool00oP0ooooo`0;ool2n017ool10001ool0
00goo`04003ooooo000=ool30003ool01000ooooo`001ooo0P00UOoo0oP02ooo1?P0A_oo0@000Ooo
000>ool2000@ool00`00ooooo`02ool20008ool2002Fool2n00:ool6n015ool10001ool002[oo`<0
00;oo`8009Koo`03n03ooooo00Soo`Oh04Goo`40007oo`00;ooo00<00?oo0000XOoo1_P0AOoo0@00
0Ooo000_ool00`00ool0002Qool2n0000ooon03h0002n014ool10001ool002ooo`<00:3oo`?h00;o
o`?h01ooo`Gh01ooo`80007oo`00;ooo00<00?ooool0Wooo1?P00ooo0oP07Ooo1oP07ooo0@000Ooo
000_ool00`00ooooo`2Pool2n003ool4n00Kool9n00Oool10001ool002ooo`03003ooooo0:Koo`?h
01Soo`ch01ooo`40007oo`00;ooo00<00?ooool0Wooo0_P01Ooo1?P05_oo2?P00_oo1?P07_oo0@00
0Ooo000_ool00`00ooooo`2Nool4n005ool3n00Gool6n004ool3n00Nool10001ool002ooo`03003o
oooo09ooo`?h00Koo`?h01Ooo`Ch00Koo`;h01koo`40007oo`00;ooo00<00?ooool0X?oo00?h0?oo
ool01?oo1?P06?oo0_P01_oo1?P07Ooo0@000Ooo000_ool2002Yool4n00Pool3n00Lool20001ool0
02ooo`03003ooooo09ooo`03n03ooooo00Koo`Ch01Ooo`03n03ooooo00Ooo`;h01goo`40007oo`00
;ooo00<00?ooool0U_oo0_P01_oo0oP02?oo0_P05ooo0oP02?oo0oP07?oo0@000Ooo000_ool00`00
ooooo`2Eool4n004ool4n00Pool4n007ool4n00Lool10001ool002ooo`03003ooooo09Koo`?h00Go
o`;h02;oo`;h00Woo`;h01goo`40007oo`00;ooo00<00?ooool0Uooo00?h0?ooool04Ooo00?h0?oo
ool01_oo00?h0?ooool05ooo0_P07?oo0@000Ooo000_ool00`00ooooo`2Zool3n006ool3n00Gool4
n00Kool10001ool002ooo`8009koo`;h00[oo`Ch00Goo`Ch01Soo`?h01[oo`80007oo`00;ooo00<0
0?ooool0W?oo1?P02_oo0oP01?oo1OP06Ooo0_P06ooo0@000Ooo000_ool00`00ooooo`2Mool3n00:
ool4n002ool7n00Gool4n008ool2n00@ool10001ool002ooo`03003ooooo09koo`03n03ooooo00[o
o`ch00Woo`;h00goo`?h00Ooo`Ch00ooo`40007oo`00;ooo00<00?ooool0Zooo2?P000?oooP0n000
2Ooo1?P03Ooo0oP01Ooo1_P03_oo0@000Ooo000_ool00`00ooooo`2/ool6n00>ool3n00<ool4n004
ool7n00>ool10001ool002ooo`03003ooooo09goo`03n03ooooo00goo`?h00Koo`;h00Woo`03n03o
oooo00coo`Ch00?oo`Ch0003oooh0?P000koo`40007oo`00;ooo00<00?ooool0W?oo0oP05_oo0oP0
6?oo1OP000?oooP0n0000_P000?oooP0n0000_P03Ooo0@000Ooo000_ool2002Lool4n00Gool2n00I
ool7n004ool3n00<ool20001ool002ooo`03003ooooo09coo`;h01Woo`03n03ooooo01Soo`Kh00Go
o`03n03ooooo00coo`40007oo`00;ooo00<00?ooool0Uooo0_P00ooo00?h0?ooool0<ooo1OP05Ooo
0@000Ooo000_ool00`00ooooo`2Fool4n0001?oon03h0?P06Ooo0_P06_oo0oP02?oo00?h0?ooool0
2ooo0@000Ooo00000ooo000000020003ool00`00ooooo`02ool30003ool01@00oooooooo00001_oo
10000ooo0P002?oo00<00?ooool0Uooo1oP06?oo1?P08ooo0oP03?oo0@000Ooo00000ooo003oo`0=
ool01`00oooooooo003oo`0000Woo`05003oooooool00002ool00`00ooooo`05ool00`00ooooo`2H
ool00oP0ooooo`02n00Jool3n00Tool2n00<ool10001ool000;oo`03003ooooo00_oo`03003ooooo
00;oo`03003ooooo00Soo`05003oooooool00002ool00`00ooooo`05ool00`00ooooo`2Iool2n00M
ool00oP0ooooo`04ool00oP0ooooo`0Lool00oP0ooooo`0;ool10001ool000?oo`03003ooooo00Oo
o`<000Coo`03003oo`0000Woo`05003oooooool00002ool00`00ooooo`05ool3002Hool4n00Mool0
0oP0ooooo`03ool2n00Zool20001ool000Coo`03003ooooo00Koo`03003ooooo00?oo`05003ooooo
ool00008ool01@00oooooooo00000_oo00<00?ooool01Ooo00<00?ooool0VOoo0oP07?oo0oP00ooo
0oP0:ooo0@000Ooo00001Ooo003ooooo00002?oo00<00?ooool03_oo0`000ooo00@00?ooool000Oo
o`8009_oo`?h01[oo`Ch00Coo`03n03ooooo02[oo`40007oo`000_oo0P002Ooo10003ooo00<00?oo
ool00_oo0P002?oo0P00V_oo1?P06ooo0_P0<_oo0@000Ooo000Zool30002ool2002Jool3n013ool2
n00;ool10001ool002ooo`03003oo`0009Soo`?h01ooo`03n03ooooo027oo`?h00_oo`40007oo`00
;ooo00<00?oo0000Uooo1?P07_oo0oP08ooo0_P02ooo0@000Ooo000_ool3002Hool2n00Nool4n000
0ooon03h000Qool00oP0ooooo`08ool20001ool002ooo`03003ooooo0;Woo`;h0003oooh0?P000;h
02coo`40007oo`00;ooo00<00?ooool0^ooo1OP0;?oo0@000Ooo000_ool00`00ooooo`2jool5n00]
ool10001ool002ooo`03003ooooo0;_oo`Ch02goo`40007oo`00;ooo00<00?ooool0_?oo0oP0;Ooo
0@000Ooo000_ool00`00ooooo`2mool00oP0ooooo`0Qool00oP0ooooo`08ool10001ool002ooo`03
003ooooo0>3oo`?h00Woo`40007oo`00;ooo0P00h?oo1?P02?oo0P000Ooo000_ool00`00ooooo`3P
ool2n00:ool10001ool002ooo`03003ooooo0>coo`40007oo`00;ooo00<00?ooool0k?oo0@000Ooo
000_ool00`00ooooo`3/ool10001ool002ooo`03003ooooo0>coo`40007oo`00;ooo00<00?ooool0
k?oo0@000Ooo000_ool2003/ool20001ool002ooo`03003ooooo0>coo`40007oo`00;ooo00<00?oo
ool0k?oo0@000Ooo000_ool00`00ooooo`3Qool2n009ool10001ool002ooo`03003ooooo0>3oo`Ch
00Soo`40007oo`00;ooo00<00?ooool0hOoo0oP02?oo0@000Ooo000_ool00`00ooooo`3Rool00oP0
ooooo`07ool10001ool002ooo`800>coo`80007oo`00;ooo00<00?ooool0k?oo0@000Ooo000_ool0
0`00ooooo`3/ool10001ool002ooo`03003ooooo0>coo`40007oo`003_oo0P000ooo00D00?oooooo
o`0000Koo`@000?oo`8000Soo`03003ooooo0>coo`40007oo`003Ooo00@00?ooool000?oo`03003o
o`0000Woo`05003oooooool00002ool00`00ooooo`05ool00`00ooooo`3/ool10001ool0013oo`03
003ooooo00;oo`03003ooooo00Soo`05003oooooool00002ool00`00ooooo`05ool00`00ooooo`3/
ool10001ool000koo`8000Coo`03003oo`0000Woo`05003oooooool00002ool00`00ooooo`05ool0
0`00ooooo`3Sool00oP0ooooo`06ool10001ool0013oo`04003ooooo0003ool00`00ooooo`06ool0
1@00oooooooo00000_oo00<00?ooool01Ooo0`00h_oo0oP01_oo0P000Ooo000=ool01000ooooo`00
3Ooo0`000ooo00@00?ooool000Ooo`03003ooooo0>7oo`Gh00Koo`40007oo`003_oo0P004?oo00<0
0?ooool00_oo0P002?oo0P00hooo1_P01?oo0@000Ooo000_ool2003Tool6n003ool10001ool002[o
o`<000;oo`800>Koo`Ch00?oo`40007oo`00;ooo00<00?oo0000i?oo1?P01?oo0@000Ooo000_ool0
0`00ool0003Tool3n005ool10001ool002ooo`<00>?oo`Ch00Coo`80007oo`00;ooo00<00?ooool0
i?oo0_P01_oo0@000Ooo000_ool00`00ooooo`3/ool10001ool002ooo`03003ooooo0>coo`40007o
o`00;ooo00<00?ooool00ooo00<00?ooool08Ooo00<00?ooool08?oo00<00?ooool08Ooo00<00?oo
ool08?oo00<00?ooool08Ooo00<00?ooool08?oo00<00?ooool04Ooo0@000Ooo000_ooo`0001ool0
0?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo
8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool0
0?ooob7oo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {456.062, 97.3125}} -> {-18.0809, \
5.73654*^-8, 0.140653, 1.36139*^-9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Euler and implicit midpoint methods", "Subsection"],

Cell["\<\
This solves the equations of motion using Euler's method using a \
specified fixed step size.\
\>", "Text"],

Cell[BoxData[
    \(\(EulerSolution\  = \ 
        NDSolve[system, 
          Method \[Rule] {FixedStep, Method \[Rule] ExplicitEuler}, \ 
          StartingStepSize\  \[Rule] \ 1/20];\)\)], "Input",
  CellLabel->"In[24]:="],

Cell["\<\
This solves the equations of motion using the implicit midpoint \
method with a specified fixed step size.\
\>", "Text"],

Cell[BoxData[{
    \(\(\(ImplicitMidpoint\  = \ {"\<FixedStep\>", 
          Method \[Rule] {"\<ImplicitRungeKutta\>", \ "\<Coefficients\>" \
\[Rule] "\<ImplicitRungeKuttaGaussCoefficients\>", \ 
              DifferenceOrder \[Rule] 
                2, "\<ImplicitSolver\>" \[Rule] {FixedPoint, \
"\<AccuracyGoal\>" \[Rule] MachinePrecision, "\<PrecisionGoal\>" \[Rule] 
                    MachinePrecision, "\<IterationSafetyFactor\>" \[Rule] 
                    1}}};\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(IMPSolution\  = \ 
        NDSolve[system, Method \[Rule] ImplicitMidpoint, \ 
          StartingStepSize\  \[Rule] \ 3/10];\)\)}], "Input",
  CellLabel->"In[25]:="],

Cell["\<\
This shows the superimposition on the unit sphere of the numerical \
solution of the equations of motion for Euler's method (left) and the \
implicit midpoint rule (right).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(EulerPlotOnSphere\  = \ 
        PlotSolutionOnManifold[EulerSolution, \ vars, time, UnitSphere, 
          DisplayFunction \[Rule] Identity];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(IMPPlotOnSphere\  = \ 
        PlotSolutionOnManifold[IMPSolution, vars, \ time, UnitSphere, 
          DisplayFunction \[Rule] Identity];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{EulerPlotOnSphere, \ IMPPlotOnSphere}], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input",
  CellLabel->"In[27]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5144 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0122477 0.47619 [
[ 0 0 0 0 ]
[ 1 .5144 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5144 L
0 .5144 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0122477 0.477324 0.502154 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0545142 1.1616 -6.10948e-17 1.1616 [
[ 0 0 0 0 ]
[ 1 1.08024 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08024 L
0 1.08024 L
closepath
clip
newpath
.751 .603 .693 r
.49641 .58077 m .4173 .61167 L .42757 .56871 L F
.49641 .58077 m .49333 .62464 L .4173 .61167 L F
.747 .623 .722 r
.50014 .53692 m .49641 .58077 L .42757 .56871 L F
.703 .561 .691 r
.56749 .57971 m .49333 .62464 L .49641 .58077 L F
.703 .585 .72 r
.56234 .53597 m .49641 .58077 L .50014 .53692 L F
.56234 .53597 m .56749 .57971 L .49641 .58077 L F
.703 .561 .691 r
.56749 .57971 m .57174 .6235 L .49333 .62464 L F
.651 .522 .694 r
.63547 .56559 m .57174 .6235 L .56749 .57971 L F
.657 .551 .723 r
.62174 .5233 m .56749 .57971 L .56234 .53597 L F
.62174 .5233 m .63547 .56559 L .56749 .57971 L F
.747 .623 .722 r
.50014 .53692 m .42757 .56871 L .43997 .52609 L F
.74 .642 .75 r
.50445 .49376 m .50014 .53692 L .43997 .52609 L F
.703 .608 .748 r
.55639 .49295 m .50014 .53692 L .50445 .49376 L F
.55639 .49295 m .56234 .53597 L .50014 .53692 L F
.755 .582 .662 r
.49333 .62464 m .40935 .65429 L .4173 .61167 L F
.49333 .62464 m .49094 .66783 L .40935 .65429 L F
.701 .535 .66 r
.57174 .6235 m .49094 .66783 L .49333 .62464 L F
.662 .579 .751 r
.60587 .48212 m .56234 .53597 L .55639 .49295 L F
.60587 .48212 m .62174 .5233 L .56234 .53597 L F
.701 .535 .66 r
.57174 .6235 m .57504 .66664 L .49094 .66783 L F
.643 .492 .662 r
.64685 .60832 m .57504 .66664 L .57174 .6235 L F
.651 .522 .694 r
.63547 .56559 m .64685 .60832 L .57174 .6235 L F
.74 .642 .75 r
.50445 .49376 m .43997 .52609 L .45429 .48451 L F
.732 .66 .779 r
.5093 .45201 m .50445 .49376 L .45429 .48451 L F
.701 .632 .776 r
.5497 .45136 m .50445 .49376 L .5093 .45201 L F
.5497 .45136 m .55639 .49295 L .50445 .49376 L F
.667 .608 .78 r
.58811 .44275 m .55639 .49295 L .5497 .45136 L F
.58811 .44275 m .60587 .48212 L .55639 .49295 L F
.757 .558 .627 r
.49094 .66783 m .40387 .69585 L .40935 .65429 L F
.49094 .66783 m .4893 .70965 L .40387 .69585 L F
.698 .508 .627 r
.57504 .66664 m .4893 .70965 L .49094 .66783 L F
.57504 .66664 m .5773 .70844 L .4893 .70965 L F
.634 .459 .628 r
.65567 .65078 m .5773 .70844 L .57504 .66664 L F
.643 .492 .662 r
.64685 .60832 m .65567 .65078 L .57504 .66664 L F
.799 .653 .7 r
.42757 .56871 m .3494 .58525 L .36631 .54418 L F
.42757 .56871 m .4173 .61167 L .3494 .58525 L F
.788 .668 .731 r
.43997 .52609 m .42757 .56871 L .36631 .54418 L F
.43997 .52609 m .36631 .54418 L .38665 .50414 L F
.776 .682 .76 r
.45429 .48451 m .43997 .52609 L .38665 .50414 L F
.591 .485 .702 r
.69502 .53917 m .64685 .60832 L .63547 .56559 L F
.605 .521 .733 r
.67351 .49967 m .63547 .56559 L .62174 .5233 L F
.67351 .49967 m .69502 .53917 L .63547 .56559 L F
.618 .555 .762 r
.64876 .462 m .62174 .5233 L .60587 .48212 L F
.64876 .462 m .67351 .49967 L .62174 .5233 L F
.808 .635 .667 r
.4173 .61167 m .33626 .62664 L .3494 .58525 L F
.4173 .61167 m .40935 .65429 L .33626 .62664 L F
.776 .682 .76 r
.45429 .48451 m .38665 .50414 L .41008 .4658 L F
.761 .694 .788 r
.47034 .44465 m .45429 .48451 L .41008 .4658 L F
.732 .66 .779 r
.5093 .45201 m .45429 .48451 L .47034 .44465 L F
.575 .447 .668 r
.71292 .57984 m .65567 .65078 L .64685 .60832 L F
.591 .485 .702 r
.69502 .53917 m .71292 .57984 L .64685 .60832 L F
.63 .59 .79 r
.62119 .42681 m .60587 .48212 L .58811 .44275 L F
.62119 .42681 m .64876 .462 L .60587 .48212 L F
.721 .679 .808 r
.51461 .41237 m .5093 .45201 L .47034 .44465 L F
.697 .656 .806 r
.54238 .41192 m .5093 .45201 L .51461 .41237 L F
.54238 .41192 m .5497 .45136 L .5093 .45201 L F
.671 .638 .809 r
.56873 .40588 m .5497 .45136 L .54238 .41192 L F
.56873 .40588 m .58811 .44275 L .5497 .45136 L F
.757 .53 .588 r
.4893 .70965 m .40102 .73562 L .40387 .69585 L F
.4893 .70965 m .48845 .74938 L .40102 .73562 L F
.693 .476 .589 r
.5773 .70844 m .48845 .74938 L .4893 .70965 L F
.5773 .70844 m .57848 .74817 L .48845 .74938 L F
.623 .421 .588 r
.66175 .69228 m .57848 .74817 L .5773 .70844 L F
.634 .459 .628 r
.65567 .65078 m .66175 .69228 L .5773 .70844 L F
.816 .614 .629 r
.40935 .65429 m .3272 .66764 L .33626 .62664 L F
.40935 .65429 m .40387 .69585 L .3272 .66764 L F
.557 .404 .63 r
.72683 .62098 m .66175 .69228 L .65567 .65078 L F
.575 .447 .668 r
.71292 .57984 m .72683 .62098 L .65567 .65078 L F
.761 .694 .788 r
.47034 .44465 m .41008 .4658 L .43619 .42982 L F
.743 .705 .816 r
.48787 .40721 m .47034 .44465 L .43619 .42982 L F
.721 .679 .808 r
.51461 .41237 m .47034 .44465 L .48787 .40721 L F
.643 .626 .818 r
.59126 .39474 m .58811 .44275 L .56873 .40588 L F
.59126 .39474 m .62119 .42681 L .58811 .44275 L F
.83 .723 .747 r
.38665 .50414 m .31789 .50862 L .34487 .47246 L F
.38665 .50414 m .36631 .54418 L .31789 .50862 L F
.809 .73 .777 r
.41008 .4658 m .38665 .50414 L .34487 .47246 L F
.41008 .4658 m .34487 .47246 L .37576 .43893 L F
.787 .734 .804 r
.43619 .42982 m .41008 .4658 L .37576 .43893 L F
.848 .714 .714 r
.36631 .54418 m .29535 .54679 L .31789 .50862 L F
.36631 .54418 m .3494 .58525 L .29535 .54679 L F
.822 .589 .585 r
.40387 .69585 m .32248 .70748 L .3272 .66764 L F
.40387 .69585 m .40102 .73562 L .32248 .70748 L F
.542 .493 .751 r
.71303 .46661 m .69502 .53917 L .67351 .49967 L F
.566 .536 .78 r
.68114 .43399 m .67351 .49967 L .64876 .462 L F
.68114 .43399 m .71303 .46661 L .67351 .49967 L F
.707 .698 .839 r
.5203 .37559 m .51461 .41237 L .48787 .40721 L F
.691 .683 .838 r
.53454 .37535 m .51461 .41237 L .5203 .37559 L F
.53454 .37535 m .54238 .41192 L .51461 .41237 L F
.673 .671 .84 r
.54801 .3722 m .54238 .41192 L .53454 .37535 L F
.54801 .3722 m .56873 .40588 L .54238 .41192 L F
.59 .577 .807 r
.64586 .40476 m .64876 .462 L .62119 .42681 L F
.64586 .40476 m .68114 .43399 L .64876 .462 L F
.755 .496 .541 r
.48845 .74938 m .40094 .77284 L .40102 .73562 L F
.48845 .74938 m .48842 .78627 L .40094 .77284 L F
.686 .439 .543 r
.57848 .74817 m .48842 .78627 L .48845 .74938 L F
.515 .446 .717 r
.74091 .50204 m .71292 .57984 L .69502 .53917 L F
.542 .493 .751 r
.71303 .46661 m .74091 .50204 L .69502 .53917 L F
.686 .439 .543 r
.57848 .74817 m .57851 .78509 L .48842 .78627 L F
.608 .376 .54 r
.6649 .73206 m .57851 .78509 L .57848 .74817 L F
.623 .421 .588 r
.66175 .69228 m .6649 .73206 L .57848 .74817 L F
.535 .356 .584 r
.73643 .66185 m .6649 .73206 L .66175 .69228 L F
.557 .404 .63 r
.72683 .62098 m .73643 .66185 L .66175 .69228 L F
.787 .734 .804 r
.43619 .42982 m .37576 .43893 L .40998 .40864 L F
.761 .736 .83 r
.46458 .39684 m .43619 .42982 L .40998 .40864 L F
.743 .705 .816 r
.48787 .40721 m .43619 .42982 L .46458 .39684 L F
.865 .701 .677 r
.3494 .58525 m .27777 .58629 L .29535 .54679 L F
.3494 .58525 m .33626 .62664 L .27777 .58629 L F
.72 .716 .845 r
.50661 .37289 m .48787 .40721 L .46458 .39684 L F
.707 .698 .839 r
.5203 .37559 m .48787 .40721 L .50661 .37289 L F
.655 .664 .846 r
.55944 .36641 m .56873 .40588 L .54801 .3722 L F
.55944 .36641 m .59126 .39474 L .56873 .40588 L F
.613 .619 .833 r
.60784 .37944 m .62119 .42681 L .59126 .39474 L F
.60784 .37944 m .64586 .40476 L .62119 .42681 L F
.485 .395 .679 r
.76422 .53965 m .72683 .62098 L .71292 .57984 L F
.515 .446 .717 r
.74091 .50204 m .76422 .53965 L .71292 .57984 L F
.761 .736 .83 r
.46458 .39684 m .40998 .40864 L .44691 .38212 L F
.73 .735 .855 r
.49477 .3675 m .46458 .39684 L .44691 .38212 L F
.72 .716 .845 r
.50661 .37289 m .46458 .39684 L .49477 .3675 L F
.88 .683 .632 r
.33626 .62664 m .26561 .62638 L .27777 .58629 L F
.33626 .62664 m .3272 .66764 L .26561 .62638 L F
.636 .661 .857 r
.56774 .35851 m .59126 .39474 L .55944 .36641 L F
.56774 .35851 m .60784 .37944 L .59126 .39474 L F
.825 .556 .531 r
.40102 .73562 m .32235 .74538 L .32248 .70748 L F
.40102 .73562 m .40094 .77284 L .32235 .74538 L F
.45 .336 .632 r
.78241 .57878 m .73643 .66185 L .72683 .62098 L F
.485 .395 .679 r
.76422 .53965 m .78241 .57878 L .72683 .62098 L F
.608 .376 .54 r
.6649 .73206 m .66499 .76936 L .57851 .78509 L F
.508 .297 .528 r
.74142 .70171 m .66499 .76936 L .6649 .73206 L F
.535 .356 .584 r
.73643 .66185 m .74142 .70171 L .6649 .73206 L F
.672 .728 .892 r
.56729 .33016 m .5203 .37559 L .50661 .37289 L F
.56729 .33016 m .53454 .37535 L .5203 .37559 L F
.56729 .33016 m .54801 .3722 L .53454 .37535 L F
.838 .788 .803 r
.37576 .43893 m .31891 .4333 L .35486 .40595 L F
.37576 .43893 m .34487 .47246 L .31891 .4333 L F
.807 .78 .828 r
.40998 .40864 m .37576 .43893 L .35486 .40595 L F
.40998 .40864 m .35486 .40595 L .39438 .38283 L F
.773 .77 .85 r
.44691 .38212 m .40998 .40864 L .39438 .38283 L F
.672 .728 .892 r
.56729 .33016 m .50661 .37289 L .49477 .3675 L F
.749 .452 .481 r
.48842 .78627 m .40374 .80672 L .40094 .77284 L F
.48842 .78627 m .48926 .81954 L .40374 .80672 L F
.674 .391 .486 r
.57851 .78509 m .48926 .81954 L .48842 .78627 L F
.672 .728 .892 r
.56729 .33016 m .55944 .36641 L .54801 .3722 L F
.674 .391 .486 r
.57851 .78509 m .57735 .81842 L .48926 .81954 L F
.587 .32 .479 r
.66499 .76936 m .57735 .81842 L .57851 .78509 L F
.869 .792 .773 r
.34487 .47246 m .28728 .46441 L .31891 .4333 L F
.34487 .47246 m .31789 .50862 L .28728 .46441 L F
.544 .572 .833 r
.65956 .37841 m .68114 .43399 L .64586 .40476 L F
.582 .619 .854 r
.61677 .3613 m .64586 .40476 L .60784 .37944 L F
.61677 .3613 m .65956 .37841 L .64586 .40476 L F
.504 .522 .808 r
.69961 .40027 m .71303 .46661 L .68114 .43399 L F
.544 .572 .833 r
.65956 .37841 m .69961 .40027 L .68114 .43399 L F
.773 .77 .85 r
.44691 .38212 m .39438 .38283 L .43667 .36434 L F
.736 .756 .869 r
.48591 .35989 m .44691 .38212 L .43667 .36434 L F
.73 .735 .855 r
.49477 .3675 m .44691 .38212 L .48591 .35989 L F
.672 .728 .892 r
.56729 .33016 m .49477 .3675 L .48591 .35989 L F
.56729 .33016 m .56774 .35851 L .55944 .36641 L F
.893 .659 .577 r
.3272 .66764 m .25927 .66629 L .26561 .62638 L F
.3272 .66764 m .32248 .70748 L .25927 .66629 L F
.619 .663 .871 r
.57206 .34924 m .60784 .37944 L .56774 .35851 L F
.57206 .34924 m .61677 .3613 L .60784 .37944 L F
.459 .466 .778 r
.7361 .42652 m .74091 .50204 L .71303 .46661 L F
.504 .522 .808 r
.69961 .40027 m .7361 .42652 L .71303 .46661 L F
.898 .792 .736 r
.31789 .50862 m .2607 .49874 L .28728 .46441 L F
.31789 .50862 m .29535 .54679 L .2607 .49874 L F
.672 .728 .892 r
.56729 .33016 m .48591 .35989 L .48091 .35078 L F
.736 .756 .869 r
.48591 .35989 m .43667 .36434 L .48091 .35078 L F
.408 .266 .574 r
.79501 .6187 m .74142 .70171 L .73643 .66185 L F
.45 .336 .632 r
.78241 .57878 m .79501 .6187 L .73643 .66185 L F
.672 .728 .892 r
.56729 .33016 m .57206 .34924 L .56774 .35851 L F
.409 .401 .74 r
.76825 .45673 m .76422 .53965 L .74091 .50204 L F
.459 .466 .778 r
.7361 .42652 m .76825 .45673 L .74091 .50204 L F
.824 .511 .46 r
.40094 .77284 m .32698 .78049 L .32235 .74538 L F
.40094 .77284 m .40374 .80672 L .32698 .78049 L F
.925 .787 .689 r
.29535 .54679 m .23987 .53567 L .2607 .49874 L F
.29535 .54679 m .27777 .58629 L .23987 .53567 L F
.587 .32 .479 r
.66499 .76936 m .66189 .80339 L .57735 .81842 L F
.471 .222 .455 r
.74157 .73974 m .66189 .80339 L .66499 .76936 L F
.508 .297 .528 r
.74142 .70171 m .74157 .73974 L .66499 .76936 L F
.776 .805 .876 r
.43667 .36434 m .39132 .35467 L .43503 .34511 L F
.43667 .36434 m .39438 .38283 L .39132 .35467 L F
.736 .776 .885 r
.48091 .35078 m .43667 .36434 L .43503 .34511 L F
.672 .728 .892 r
.56729 .33016 m .48091 .35078 L .48032 .34103 L F
.736 .776 .885 r
.48091 .35078 m .43503 .34511 L .48032 .34103 L F
.672 .728 .892 r
.56729 .33016 m .57193 .33947 L .57206 .34924 L F
.603 .672 .888 r
.57193 .33947 m .61677 .3613 L .57206 .34924 L F
.552 .628 .881 r
.61696 .34201 m .65956 .37841 L .61677 .3613 L F
.603 .672 .888 r
.57193 .33947 m .61696 .34201 L .61677 .3613 L F
.816 .832 .861 r
.39438 .38283 m .35008 .36964 L .39132 .35467 L F
.39438 .38283 m .35486 .40595 L .35008 .36964 L F
.902 .624 .506 r
.32248 .70748 m .25909 .70517 L .25927 .66629 L F
.32248 .70748 m .32235 .74538 L .25909 .70517 L F
.349 .326 .691 r
.79528 .49037 m .78241 .57878 L .76422 .53965 L F
.409 .401 .74 r
.76825 .45673 m .79528 .49037 L .76422 .53965 L F
.736 .393 .4 r
.48926 .81954 m .40949 .83642 L .40374 .80672 L F
.48926 .81954 m .49098 .8484 L .40949 .83642 L F
.654 .328 .409 r
.57735 .81842 m .49098 .8484 L .48926 .81954 L F
.493 .576 .867 r
.6605 .35012 m .69961 .40027 L .65956 .37841 L F
.552 .628 .881 r
.61696 .34201 m .6605 .35012 L .65956 .37841 L F
.654 .328 .409 r
.57735 .81842 m .57498 .84735 L .49098 .8484 L F
.556 .245 .396 r
.66189 .80339 m .57498 .84735 L .57735 .81842 L F
.672 .728 .892 r
.56729 .33016 m .48032 .34103 L .48424 .33158 L F
.727 .793 .904 r
.48032 .34103 m .44241 .3263 L .48424 .33158 L F
.48032 .34103 m .43503 .34511 L .44241 .3263 L F
.857 .856 .839 r
.35486 .40595 m .31224 .38985 L .35008 .36964 L F
.35486 .40595 m .31891 .4333 L .31224 .38985 L F
.592 .686 .907 r
.56729 .33016 m .61696 .34201 L .57193 .33947 L F
.354 .178 .499 r
.80158 .65861 m .74157 .73974 L .74142 .70171 L F
.408 .266 .574 r
.79501 .6187 m .80158 .65861 L .74142 .70171 L F
.95 .774 .629 r
.27777 .58629 m .2254 .57449 L .23987 .53567 L F
.27777 .58629 m .26561 .62638 L .2254 .57449 L F
.425 .514 .846 r
.70164 .36374 m .7361 .42652 L .69961 .40027 L F
.493 .576 .867 r
.6605 .35012 m .70164 .36374 L .69961 .40027 L F
.766 .837 .906 r
.43503 .34511 m .40165 .32686 L .44241 .3263 L F
.43503 .34511 m .39132 .35467 L .40165 .32686 L F
.672 .728 .892 r
.56729 .33016 m .48424 .33158 L .49237 .32338 L F
.711 .803 .922 r
.48424 .33158 m .45834 .30984 L .49237 .32338 L F
.48424 .33158 m .44241 .3263 L .45834 .30984 L F
.672 .728 .892 r
.56729 .33016 m .54655 .31655 L .55855 .32225 L F
.56729 .33016 m .53247 .31368 L .54655 .31655 L F
.56729 .33016 m .51776 .31394 L .53247 .31368 L F
.56729 .33016 m .50392 .31729 L .51776 .31394 L F
.56729 .33016 m .49237 .32338 L .50392 .31729 L F
.588 .706 .925 r
.55855 .32225 m .60815 .32345 L .56729 .33016 L F
.592 .686 .907 r
.56729 .33016 m .60815 .32345 L .61696 .34201 L F
.897 .877 .808 r
.31891 .4333 m .27869 .41501 L .31224 .38985 L F
.31891 .4333 m .28728 .46441 L .27869 .41501 L F
.524 .647 .911 r
.60815 .32345 m .6605 .35012 L .61696 .34201 L F
.277 .233 .627 r
.81649 .52683 m .79501 .6187 L .78241 .57878 L F
.349 .326 .691 r
.79528 .49037 m .81649 .52683 L .78241 .57878 L F
.813 .447 .364 r
.40374 .80672 m .3365 .81197 L .32698 .78049 L F
.40374 .80672 m .40949 .83642 L .3365 .81197 L F
.687 .805 .938 r
.49237 .32338 m .48134 .2975 L .50392 .31729 L F
.49237 .32338 m .45834 .30984 L .48134 .2975 L F
.343 .438 .814 r
.73944 .38274 m .76825 .45673 L .7361 .42652 L F
.425 .514 .846 r
.70164 .36374 m .73944 .38274 L .7361 .42652 L F
.588 .706 .925 r
.55855 .32225 m .59097 .30754 L .60815 .32345 L F
.592 .731 .941 r
.54655 .31655 m .59097 .30754 L .55855 .32225 L F
.556 .245 .396 r
.66189 .80339 m .65551 .83332 L .57498 .84735 L F
.418 .123 .354 r
.73666 .77511 m .65551 .83332 L .66189 .80339 L F
.471 .222 .455 r
.74157 .73974 m .73666 .77511 L .66189 .80339 L F
.903 .572 .41 r
.32235 .74538 m .26532 .74214 L .25909 .70517 L F
.32235 .74538 m .32698 .78049 L .26532 .74214 L F
.806 .882 .901 r
.39132 .35467 m .36284 .33346 L .40165 .32686 L F
.39132 .35467 m .35008 .36964 L .36284 .33346 L F
.658 .798 .949 r
.50392 .31729 m .50912 .29068 L .51776 .31394 L F
.50392 .31729 m .48134 .2975 L .50912 .29068 L F
.97 .749 .548 r
.26561 .62638 m .21784 .6144 L .2254 .57449 L F
.26561 .62638 m .25927 .66629 L .21784 .6144 L F
.592 .731 .941 r
.54655 .31655 m .56702 .29601 L .59097 .30754 L F
.606 .757 .951 r
.53247 .31368 m .56702 .29601 L .54655 .31655 L F
.936 .892 .762 r
.28728 .46441 m .25031 .44474 L .27869 .41501 L F
.28728 .46441 m .2607 .49874 L .25031 .44474 L F
.438 .593 .908 r
.64803 .32263 m .70164 .36374 L .6605 .35012 L F
.524 .647 .911 r
.60815 .32345 m .64803 .32263 L .6605 .35012 L F
.629 .78 .954 r
.51776 .31394 m .53874 .29017 L .53247 .31368 L F
.51776 .31394 m .50912 .29068 L .53874 .29017 L F
.606 .757 .951 r
.53247 .31368 m .53874 .29017 L .56702 .29601 L F
.282 .065 .396 r
.80176 .69767 m .73666 .77511 L .74157 .73974 L F
.354 .178 .499 r
.80158 .65861 m .80176 .69767 L .74157 .73974 L F
.737 .86 .938 r
.44241 .3263 m .42489 .30231 L .45834 .30984 L F
.44241 .3263 m .40165 .32686 L .42489 .30231 L F
.707 .306 .284 r
.49098 .8484 m .41824 .86113 L .40949 .83642 L F
.49098 .8484 m .49361 .87202 L .41824 .86113 L F
.619 .239 .3 r
.57498 .84735 m .49361 .87202 L .49098 .8484 L F
.504 .677 .943 r
.59097 .30754 m .64803 .32263 L .60815 .32345 L F
.619 .239 .3 r
.57498 .84735 m .57136 .87106 L .49361 .87202 L F
.507 .14 .278 r
.65551 .83332 m .57136 .87106 L .57498 .84735 L F
.185 .115 .539 r
.83123 .56541 m .80158 .65861 L .79501 .6187 L F
.277 .233 .627 r
.81649 .52683 m .83123 .56541 L .79501 .6187 L F
.241 .34 .765 r
.773 .4069 m .79528 .49037 L .76825 .45673 L F
.343 .438 .814 r
.73944 .38274 m .773 .4069 L .76825 .45673 L F
.846 .927 .883 r
.35008 .36964 m .32691 .34619 L .36284 .33346 L F
.35008 .36964 m .31224 .38985 L .32691 .34619 L F
.97 .897 .693 r
.2607 .49874 m .22793 .47852 L .25031 .44474 L F
.2607 .49874 m .23987 .53567 L .22793 .47852 L F
.324 .516 .89 r
.68605 .32793 m .73944 .38274 L .70164 .36374 L F
.438 .593 .908 r
.64803 .32263 m .68605 .32793 L .70164 .36374 L F
.689 .866 .966 r
.45834 .30984 m .45901 .28377 L .48134 .2975 L F
.45834 .30984 m .42489 .30231 L .45901 .28377 L F
.978 .703 .435 r
.25927 .66629 m .21762 .65452 L .21784 .6144 L F
.25927 .66629 m .25909 .70517 L .21762 .65452 L F
.504 .677 .943 r
.59097 .30754 m .62287 .29886 L .64803 .32263 L F
.501 .719 .969 r
.56702 .29601 m .62287 .29886 L .59097 .30754 L F
.782 .35 .222 r
.40949 .83642 m .35094 .83893 L .3365 .81197 L F
.40949 .83642 m .41824 .86113 L .35094 .83893 L F
.886 .491 .273 r
.32698 .78049 m .27809 .77627 L .26532 .74214 L F
.32698 .78049 m .3365 .81197 L .27809 .77627 L F
.761 .92 .942 r
.40165 .32686 m .39278 .30124 L .42489 .30231 L F
.40165 .32686 m .36284 .33346 L .39278 .30124 L F
.507 .14 .278 r
.65551 .83332 m .64582 .85831 L .57136 .87106 L F
.337 0 .206 r
.72657 .80696 m .64582 .85831 L .65551 .83332 L F
.418 .123 .354 r
.73666 .77511 m .72657 .80696 L .65551 .83332 L F
.111 .212 .69 r
.80142 .43584 m .81649 .52683 L .79528 .49037 L F
.241 .34 .765 r
.773 .4069 m .80142 .43584 L .79528 .49037 L F
.384 .625 .948 r
.62287 .29886 m .68605 .32793 L .64803 .32263 L F
.064 0 .414 r
.83893 .60531 m .80176 .69767 L .80158 .65861 L F
.185 .115 .539 r
.83123 .56541 m .83893 .60531 L .80158 .65861 L F
.18 0 .248 r
.79531 .73499 m .72657 .80696 L .73666 .77511 L F
.282 .065 .396 r
.80176 .69767 m .79531 .73499 L .73666 .77511 L F
.626 .849 .985 r
.48134 .2975 m .50055 .27347 L .50912 .29068 L F
.48134 .2975 m .45901 .28377 L .50055 .27347 L F
.882 .966 .843 r
.31224 .38985 m .29481 .365 L .32691 .34619 L F
.31224 .38985 m .27869 .41501 L .29481 .365 L F
.501 .719 .969 r
.56702 .29601 m .58729 .28152 L .62287 .29886 L F
.52 .766 .986 r
.53874 .29017 m .58729 .28152 L .56702 .29601 L F
.992 .881 .589 r
.23987 .53567 m .21233 .51572 L .22793 .47852 L F
.23987 .53567 m .2254 .57449 L .21233 .51572 L F
.565 .813 .992 r
.50912 .29068 m .54497 .27269 L .53874 .29017 L F
.50912 .29068 m .50055 .27347 L .54497 .27269 L F
.52 .766 .986 r
.53874 .29017 m .54497 .27269 L .58729 .28152 L F
.168 .404 .846 r
.72129 .33948 m .773 .4069 L .73944 .38274 L F
.324 .516 .89 r
.68605 .32793 m .72129 .33948 L .73944 .38274 L F
.645 .168 .105 r
.49361 .87202 m .42995 .87999 L .41824 .86113 L F
.49361 .87202 m .49712 .88958 L .42995 .87999 L F
.553 .1 .131 r
.57136 .87106 m .49712 .88958 L .49361 .87202 L F
.57136 .87106 m .5665 .88874 L .49712 .88958 L F
.419 0 .095 r
.64582 .85831 m .5665 .88874 L .57136 .87106 L F
.959 .62 .273 r
.25909 .70517 m .22505 .69389 L .21762 .65452 L F
.25909 .70517 m .26532 .74214 L .22505 .69389 L F
0 .04 .572 r
.82384 .46908 m .83123 .56541 L .81649 .52683 L F
.111 .212 .69 r
.80142 .43584 m .82384 .46908 L .81649 .52683 L F
.67 .924 .973 r
.42489 .30231 m .43744 .27675 L .45901 .28377 L F
.42489 .30231 m .39278 .30124 L .43744 .27675 L F
.77 .974 .919 r
.36284 .33346 m .36283 .307 L .39278 .30124 L F
.36284 .33346 m .32691 .34619 L .36283 .307 L F
.902 .986 .762 r
.27869 .41501 m .26746 .38973 L .29481 .365 L F
.27869 .41501 m .25031 .44474 L .26746 .38973 L F
.384 .625 .948 r
.62287 .29886 m .65352 .2967 L .68605 .32793 L F
.348 .674 .977 r
.58729 .28152 m .65352 .2967 L .62287 .29886 L F
.828 .356 .07 r
.3365 .81197 m .2974 .80663 L .27809 .77627 L F
.3365 .81197 m .35094 .83893 L .2974 .80663 L F
.201 .528 .921 r
.65352 .2967 m .72129 .33948 L .68605 .32793 L F
0 0 .233 r
.83915 .64565 m .79531 .73499 L .80176 .69767 L F
.064 0 .414 r
.83893 .60531 m .83915 .64565 L .80176 .69767 L F
.704 .19 .004 r
.41824 .86113 m .37022 .8605 L .35094 .83893 L F
.41824 .86113 m .42995 .87999 L .37022 .8605 L F
.983 .826 .431 r
.2254 .57449 m .20416 .55554 L .21233 .51572 L F
.2254 .57449 m .21784 .6144 L .20416 .55554 L F
0 .238 .753 r
.75282 .35729 m .80142 .43584 L .773 .4069 L F
.168 .404 .846 r
.72129 .33948 m .75282 .35729 L .773 .4069 L F
.337 0 .206 r
.72657 .80696 m .71129 .83438 L .64582 .85831 L F
.031 0 .031 r
.78208 .76963 m .71129 .83438 L .72657 .80696 L F
.18 0 .248 r
.79531 .73499 m .78208 .76963 L .72657 .80696 L F
.419 0 .095 r
.64582 .85831 m .63283 .87751 L .5665 .88874 L F
.203 0 0 r
.71129 .83438 m .63283 .87751 L .64582 .85831 L F
.545 .884 .987 r
.45901 .28377 m .49224 .26308 L .50055 .27347 L F
.45901 .28377 m .43744 .27675 L .49224 .26308 L F
0 0 .391 r
.83949 .50599 m .83893 .60531 L .83123 .56541 L F
0 .04 .572 r
.82384 .46908 m .83949 .50599 L .83123 .56541 L F
.348 .674 .977 r
.58729 .28152 m .60688 .27377 L .65352 .2967 L F
.357 .738 .987 r
.54497 .27269 m .60688 .27377 L .58729 .28152 L F
.883 .474 .041 r
.26532 .74214 m .24025 .7315 L .22505 .69389 L F
.26532 .74214 m .27809 .77627 L .24025 .7315 L F
0 g
.5 Mabswid
[ ] 0 setdash
.61248 .90864 m
.62762 .90496 L
s
.59666 .91234 m
.61248 .90864 L
s
.58015 .91595 m
.59666 .91234 L
s
.62762 .90496 m
.6421 .90136 L
s
.56296 .91934 m
.58015 .91595 L
s
.879 .956 .611 r
.25031 .44474 m .24579 .42003 L .26746 .38973 L F
.25031 .44474 m .22793 .47852 L .24579 .42003 L F
.739 .992 .829 r
.32691 .34619 m .33588 .31981 L .36283 .307 L F
.32691 .34619 m .29481 .365 L .33588 .31981 L F
.427 .813 .989 r
.50055 .27347 m .551 .26204 L .54497 .27269 L F
.50055 .27347 m .49224 .26308 L .551 .26204 L F
0 g
.6421 .90136 m
.6559 .89788 L
s
.357 .738 .987 r
.54497 .27269 m .551 .26204 L .60688 .27377 L F
0 g
.54512 .92236 m
.56296 .91934 L
s
.594 .945 .913 r
.39278 .30124 m .4172 .27702 L .43744 .27675 L F
.39278 .30124 m .36283 .307 L .4172 .27702 L F
0 0 0 r
.83158 .68545 m .78208 .76963 L .79531 .73499 L F
0 0 .233 r
.83915 .64565 m .83158 .68545 L .79531 .73499 L F
.504 0 0 r
.49712 .88958 m .44454 .89222 L .42995 .87999 L F
.49712 .88958 m .50151 .90029 L .44454 .89222 L F
.414 0 0 r
.5665 .88874 m .50151 .90029 L .49712 .88958 L F
0 g
.6559 .89788 m
.66902 .89452 L
s
0 .352 .817 r
.68215 .30146 m .75282 .35729 L .72129 .33948 L F
.201 .528 .921 r
.65352 .2967 m .68215 .30146 L .72129 .33948 L F
.911 .702 .202 r
.21784 .6144 m .20393 .59707 L .20416 .55554 L F
.21784 .6144 m .21762 .65452 L .20393 .59707 L F
.414 0 0 r
.5665 .88874 m .56044 .89958 L .50151 .90029 L F
.253 0 0 r
.63283 .87751 m .56044 .89958 L .5665 .88874 L F
0 g
.52668 .92482 m
.54512 .92236 L
s
0 0 .576 r
.7797 .38121 m .82384 .46908 L .80142 .43584 L F
0 .238 .753 r
.75282 .35729 m .7797 .38121 L .80142 .43584 L F
.09 .55 .907 r
.60688 .27377 m .68215 .30146 L .65352 .2967 L F
.682 .138 0 r
.35094 .83893 m .32308 .83227 L .2974 .80663 L F
.35094 .83893 m .37022 .8605 L .32308 .83227 L F
0 g
.66902 .89452 m
.68146 .89128 L
s
.60115 .90345 m
.61553 .9002 L
s
.58614 .9066 m
.60115 .90345 L
s
.50771 .92652 m
.52668 .92482 L
s
.57054 .90955 m
.58614 .9066 L
s
.61553 .9002 m
.62928 .89692 L
s
.55437 .9122 m
.57054 .90955 L
s
0 0 .136 r
.84769 .54579 m .83915 .64565 L .83893 .60531 L F
0 0 .391 r
.83949 .50599 m .84769 .54579 L .83893 .60531 L F
0 g
.62928 .89692 m
.64239 .89365 L
s
.203 0 0 r
.71129 .83438 m .69089 .85652 L .63283 .87751 L F
0 0 0 r
.76209 .80063 m .69089 .85652 L .71129 .83438 L F
.031 0 .031 r
.78208 .76963 m .76209 .80063 L .71129 .83438 L F
0 g
.53768 .91439 m
.55437 .9122 L
s
.52 0 0 r
.42995 .87999 m .39413 .87586 L .37022 .8605 L F
.42995 .87999 m .44454 .89222 L .39413 .87586 L F
0 g
.64239 .89365 m
.65485 .8904 L
s
.48833 .92722 m
.50771 .92652 L
s
.253 0 0 r
.63283 .87751 m .61668 .89013 L .56044 .89958 L F
0 0 0 r
.69089 .85652 m .61668 .89013 L .63283 .87751 L F
0 g
.68146 .89128 m
.69318 .8881 L
s
.774 .832 .366 r
.22793 .47852 m .23061 .45536 L .24579 .42003 L F
.22793 .47852 m .21233 .51572 L .23061 .45536 L F
0 g
.52053 .91596 m
.53768 .91439 L
s
.707 .245 0 r
.27809 .77627 m .26313 .76629 L .24025 .7315 L F
.27809 .77627 m .2974 .80663 L .26313 .76629 L F
0 g
.65485 .8904 m
.66662 .88718 L
s
.619 .907 .619 r
.29481 .365 m .31278 .33972 L .33588 .31981 L F
.29481 .365 m .26746 .38973 L .31278 .33972 L F
0 g
.591 .89817 m
.60459 .89535 L
s
.57685 .90081 m
.591 .89817 L
s
.352 .827 .865 r
.43744 .27675 m .48442 .26021 L .49224 .26308 L F
.43744 .27675 m .4172 .27702 L .48442 .26021 L F
0 g
.60459 .89535 m
.61761 .89241 L
s
.56219 .90316 m
.57685 .90081 L
s
.69318 .8881 m
.70412 .88492 L
s
.50301 .91674 m
.52053 .91596 L
s
.61761 .89241 m
.63003 .88938 L
s
.54706 .90514 m
.56219 .90316 L
s
.744 .491 0 r
.21762 .65452 m .21196 .63926 L .20393 .59707 L F
.21762 .65452 m .22505 .69389 L .21196 .63926 L F
.09 .55 .907 r
.60688 .27377 m .62528 .27335 L .68215 .30146 L F
.06 .596 .857 r
.551 .26204 m .62528 .27335 L .60688 .27377 L F
0 g
.46871 .92669 m
.48833 .92722 L
s
.66662 .88718 m
.67766 .88394 L
s
0 0 .302 r
.80103 .41094 m .83949 .50599 L .82384 .46908 L F
0 0 .576 r
.7797 .38121 m .80103 .41094 L .82384 .46908 L F
0 0 0 r
.8161 .72368 m .76209 .80063 L .78208 .76963 L F
.83158 .68545 m .8161 .72368 L .78208 .76963 L F
0 g
.63003 .88938 m
.6418 .88631 L
s
.53151 .90661 m
.54706 .90514 L
s
0 .077 .575 r
.70794 .31339 m .7797 .38121 L .75282 .35729 L F
0 .352 .817 r
.68215 .30146 m .70794 .31339 L .75282 .35729 L F
0 g
.48526 .91656 m
.50301 .91674 L
s
.403 .836 .696 r
.36283 .307 m .39889 .28503 L .4172 .27702 L F
.36283 .307 m .33588 .31981 L .39889 .28503 L F
0 g
.6418 .88631 m
.65291 .88317 L
s
.51563 .90745 m
.53151 .90661 L
s
.70412 .88492 m
.7142 .88163 L
s
.67766 .88394 m
.68792 .88065 L
s
0 0 .136 r
.84769 .54579 m .84792 .58754 L .83915 .64565 L F
.737 .702 .165 r
.84792 .58754 m .83158 .68545 L .83915 .64565 L F
.151 .689 .832 r
.49224 .26308 m .55668 .25893 L .551 .26204 L F
.49224 .26308 m .48442 .26021 L .55668 .25893 L F
.06 .596 .857 r
.551 .26204 m .55668 .25893 L .62528 .27335 L F
0 g
.44903 .92472 m
.46871 .92669 L
s
0 .292 .666 r
.62528 .27335 m .70794 .31339 L .68215 .30146 L F
0 g
.49952 .9075 m
.51563 .90745 L
s
.402 0 0 r
.37022 .8605 m .35476 .85229 L .32308 .83227 L F
.37022 .8605 m .39413 .87586 L .35476 .85229 L F
.213 0 0 r
.50151 .90029 m .46181 .89708 L .44454 .89222 L F
.50151 .90029 m .50672 .90343 L .46181 .89708 L F
.138 0 0 r
.56044 .89958 m .50672 .90343 L .50151 .90029 L F
0 g
.46741 .91524 m
.48526 .91656 L
s
.138 0 0 r
.56044 .89958 m .55326 .90287 L .50672 .90343 L F
0 0 0 r
.61668 .89013 m .55326 .90287 L .56044 .89958 L F
.21233 .51572 m .22264 .49498 L .23061 .45536 L F
.21233 .51572 m .20416 .55554 L .22264 .49498 L F
.69089 .85652 m .6656 .87253 L .61668 .89013 L F
0 g
.68792 .88065 m
.69732 .87722 L
s
.65291 .88317 m
.66331 .87997 L
s
0 0 0 r
.76209 .80063 m .73554 .82704 L .69089 .85652 L F
.405 .815 .613 r
.73554 .82704 m .6656 .87253 L .69089 .85652 L F
0 g
.7142 .88163 m
.72329 .87811 L
s
.66331 .87997 m
.67295 .87666 L
s
.4833 .90663 m
.49952 .9075 L
s
0 .043 .566 r
.2974 .80663 m .29338 .7972 L .26313 .76629 L F
.2974 .80663 m .32308 .83227 L .29338 .7972 L F
0 g
.42954 .92111 m
.44903 .92472 L
s
0 0 0 r
.26746 .38973 m .29438 .36659 L .31278 .33972 L F
.26746 .38973 m .24579 .42003 L .29438 .36659 L F
0 0 .383 r
.22505 .69389 m .22834 .68096 L .21196 .63926 L F
.22505 .69389 m .24025 .7315 L .22834 .68096 L F
0 g
.44967 .91258 m
.46741 .91524 L
s
0 .399 .703 r
.44454 .89222 m .42233 .88426 L .39413 .87586 L F
.44454 .89222 m .46181 .89708 L .42233 .88426 L F
0 0 .302 r
.80103 .41094 m .81598 .44596 L .83949 .50599 L F
.851 .548 .016 r
.81598 .44596 m .84769 .54579 L .83949 .50599 L F
0 g
.67295 .87666 m
.68174 .87319 L
s
.46712 .90468 m
.4833 .90663 L
s
0 0 0 r
.61668 .89013 m .59755 .89544 L .55326 .90287 L F
.289 .78 .726 r
.6656 .87253 m .59755 .89544 L .61668 .89013 L F
0 g
.69732 .87722 m
.70577 .87355 L
s
0 0 0 r
.8161 .72368 m .79281 .75926 L .76209 .80063 L F
.674 .923 .615 r
.79281 .75926 m .73554 .82704 L .76209 .80063 L F
0 .077 .575 r
.70794 .31339 m .73005 .3326 L .7797 .38121 L F
.723 .229 0 r
.73005 .3326 m .80103 .41094 L .7797 .38121 L F
0 g
.72329 .87811 m
.73127 .87423 L
s
.875 .877 .441 r
.83987 .63021 m .8161 .72368 L .83158 .68545 L F
.737 .702 .165 r
.84792 .58754 m .83987 .63021 L .83158 .68545 L F
0 0 0 r
.4172 .27702 m .47732 .26545 L .48442 .26021 L F
.4172 .27702 m .39889 .28503 L .47732 .26545 L F
0 g
.43224 .90845 m
.44967 .91258 L
s
.41051 .91568 m
.42954 .92111 L
s
.45114 .90153 m
.46712 .90468 L
s
.68174 .87319 m
.6896 .86948 L
s
0 .292 .666 r
.62528 .27335 m .64193 .28076 L .70794 .31339 L F
.321 0 0 r
.55668 .25893 m .64193 .28076 L .62528 .27335 L F
0 0 0 r
.33588 .31981 m .38312 .30104 L .39889 .28503 L F
.33588 .31981 m .31278 .33972 L .38312 .30104 L F
0 0 .236 r
.20416 .55554 m .22241 .53794 L .22264 .49498 L F
.20416 .55554 m .20393 .59707 L .22241 .53794 L F
.607 .037 0 r
.64193 .28076 m .73005 .3326 L .70794 .31339 L F
0 .452 .841 r
.39413 .87586 m .39184 .8659 L .35476 .85229 L F
.39413 .87586 m .42233 .88426 L .39184 .8659 L F
0 g
.43556 .8971 m
.45114 .90153 L
s
.41537 .90274 m
.43224 .90845 L
s
0 .043 .612 r
.24025 .7315 m .25291 .72098 L .22834 .68096 L F
.24025 .7315 m .26313 .76629 L .25291 .72098 L F
.211 0 0 r
.48442 .26021 m .56184 .26395 L .55668 .25893 L F
.48442 .26021 m .47732 .26545 L .56184 .26395 L F
0 g
.39225 .90832 m
.41051 .91568 L
s
.968 .722 .29 r
.82383 .48554 m .84792 .58754 L .84769 .54579 L F
.851 .548 .016 r
.81598 .44596 m .82383 .48554 L .84769 .54579 L F
0 .309 .79 r
.32308 .83227 m .33044 .82322 L .29338 .7972 L F
.32308 .83227 m .35476 .85229 L .33044 .82322 L F
.321 0 0 r
.55668 .25893 m .56184 .26395 L .64193 .28076 L F
0 0 .04 r
.24579 .42003 m .28144 .40003 L .29438 .36659 L F
.24579 .42003 m .23061 .45536 L .28144 .40003 L F
.289 .78 .726 r
.6656 .87253 m .63582 .88165 L .59755 .89544 L F
.569 .939 .858 r
.70282 .84795 m .63582 .88165 L .6656 .87253 L F
.405 .815 .613 r
.73554 .82704 m .70282 .84795 L .6656 .87253 L F
0 g
.6896 .86948 m
.69643 .86545 L
s
.73127 .87423 m
.73796 .86981 L
s
.70577 .87355 m
.71314 .86955 L
s
.71314 .86955 m
.71927 .86507 L
s
.17 .677 .904 r
.50672 .90343 m .48149 .89397 L .46181 .89708 L F
.50672 .90343 m .51267 .8984 L .48149 .89397 L F
.225 .733 .891 r
.55326 .90287 m .51267 .8984 L .50672 .90343 L F
.55326 .90287 m .54505 .89801 L .51267 .8984 L F
.343 .814 .909 r
.59755 .89544 m .54505 .89801 L .55326 .90287 L F
.75 .993 .81 r
.76204 .79112 m .70282 .84795 L .73554 .82704 L F
.674 .923 .615 r
.79281 .75926 m .76204 .79112 L .73554 .82704 L F
.923 .96 .642 r
.82343 .67261 m .79281 .75926 L .8161 .72368 L F
.875 .877 .441 r
.83987 .63021 m .82343 .67261 L .8161 .72368 L F
0 g
.69643 .86545 m
.70212 .861 L
s
.886 .457 .09 r
.74769 .35896 m .81598 .44596 L .80103 .41094 L F
.723 .229 0 r
.73005 .3326 m .74769 .35896 L .80103 .41094 L F
0 g
.39929 .89539 m
.41537 .90274 L
s
.184 .648 .938 r
.46181 .89708 m .45426 .88506 L .42233 .88426 L F
0 g
.42058 .8913 m
.43556 .8971 L
s
.184 .648 .938 r
.46181 .89708 m .48149 .89397 L .45426 .88506 L F
0 0 .456 r
.20393 .59707 m .23025 .58313 L .22241 .53794 L F
.20393 .59707 m .21196 .63926 L .23025 .58313 L F
0 g
.73796 .86981 m
.74316 .8647 L
s
.37507 .89897 m
.39225 .90832 L
s
.343 .814 .909 r
.59755 .89544 m .57579 .89283 L .54505 .89801 L F
.496 .894 .943 r
.63582 .88165 m .57579 .89283 L .59755 .89544 L F
.249 0 0 r
.39889 .28503 m .47119 .27919 L .47732 .26545 L F
.39889 .28503 m .38312 .30104 L .47119 .27919 L F
.126 0 .023 r
.31278 .33972 m .37051 .3251 L .38312 .30104 L F
.31278 .33972 m .29438 .36659 L .37051 .3251 L F
.001 .255 .761 r
.26313 .76629 m .28518 .75808 L .25291 .72098 L F
.26313 .76629 m .29338 .7972 L .28518 .75808 L F
1 .814 .485 r
.82405 .52873 m .83987 .63021 L .84792 .58754 L F
.968 .722 .29 r
.82383 .48554 m .82405 .52873 L .84792 .58754 L F
0 g
.38427 .88639 m
.39929 .89539 L
s
.607 .037 0 r
.64193 .28076 m .65628 .29628 L .73005 .3326 L F
.581 .036 0 r
.56184 .26395 m .65628 .29628 L .64193 .28076 L F
.054 0 .285 r
.23061 .45536 m .27463 .43937 L .28144 .40003 L F
.23061 .45536 m .22264 .49498 L .27463 .43937 L F
.148 .502 .909 r
.35476 .85229 m .37347 .84343 L .33044 .82322 L F
.35476 .85229 m .39184 .8659 L .37347 .84343 L F
.777 .286 .055 r
.65628 .29628 m .74769 .35896 L .73005 .3326 L F
.252 .635 .961 r
.42233 .88426 m .43352 .8724 L .39184 .8659 L F
0 g
.40642 .88408 m
.42058 .8913 L
s
.252 .635 .961 r
.42233 .88426 m .45426 .88506 L .43352 .8724 L F
.914 .978 .771 r
.79882 .71352 m .76204 .79112 L .79281 .75926 L F
.923 .96 .642 r
.82343 .67261 m .79882 .71352 L .79281 .75926 L F
0 g
.35924 .8877 m
.37507 .89897 L
s
.74316 .8647 m
.74663 .8587 L
s
.39328 .87547 m
.40642 .88408 L
s
.569 .939 .858 r
.70282 .84795 m .66456 .86253 L .63582 .88165 L F
.758 .981 .912 r
.72439 .8182 m .66456 .86253 L .70282 .84795 L F
0 g
.70212 .861 m
.70652 .85604 L
s
.71927 .86507 m
.72401 .85999 L
s
.75 .993 .81 r
.76204 .79112 m .72439 .8182 L .70282 .84795 L F
0 g
.72401 .85999 m
.72719 .85417 L
s
.496 .894 .943 r
.63582 .88165 m .60213 .88326 L .57579 .89283 L F
.638 .938 .963 r
.66456 .86253 m .60213 .88326 L .63582 .88165 L F
.063 .115 .606 r
.21196 .63926 m .24619 .62924 L .23025 .58313 L F
.21196 .63926 m .22834 .68096 L .24619 .62924 L F
0 g
.70652 .85604 m
.70948 .85044 L
s
.943 .592 .316 r
.76009 .39211 m .82383 .48554 L .81598 .44596 L F
.886 .457 .09 r
.74769 .35896 m .76009 .39211 L .81598 .44596 L F
0 g
.37055 .87577 m
.38427 .88639 L
s
.46 0 0 r
.47732 .26545 m .56629 .27752 L .56184 .26395 L F
.47732 .26545 m .47119 .27919 L .56629 .27752 L F
.581 .036 0 r
.56184 .26395 m .56629 .27752 L .65628 .29628 L F
.18 .413 .851 r
.29338 .7972 m .32442 .79105 L .28518 .75808 L F
.29338 .7972 m .33044 .82322 L .32442 .79105 L F
.442 .784 .998 r
.51267 .8984 m .50315 .88247 L .48149 .89397 L F
.51267 .8984 m .51925 .88478 L .50315 .88247 L F
.474 .818 .998 r
.54505 .89801 m .51925 .88478 L .51267 .8984 L F
.54505 .89801 m .53599 .88458 L .51925 .88478 L F
.528 .851 .998 r
.57579 .89283 m .53599 .88458 L .54505 .89801 L F
.988 .857 .618 r
.81633 .57439 m .82343 .67261 L .83987 .63021 L F
1 .814 .485 r
.82405 .52873 m .81633 .57439 L .83987 .63021 L F
0 g
.34506 .8746 m
.35924 .8877 L
s
.74663 .8587 m
.74812 .85163 L
s
.72719 .85417 m
.72862 .84748 L
s
.435 .753 .994 r
.48149 .89397 m .48921 .87785 L .45426 .88506 L F
.48149 .89397 m .50315 .88247 L .48921 .87785 L F
.877 .963 .85 r
.7665 .75166 m .72439 .8182 L .76204 .79112 L F
.914 .978 .771 r
.79882 .71352 m .7665 .75166 L .76204 .79112 L F
.528 .851 .998 r
.57579 .89283 m .55183 .88188 L .53599 .88458 L F
.591 .874 .993 r
.60213 .88326 m .55183 .88188 L .57579 .89283 L F
.283 0 .258 r
.29438 .36659 m .36162 .35694 L .37051 .3251 L F
.29438 .36659 m .28144 .40003 L .36162 .35694 L F
0 g
.35836 .86366 m
.37055 .87577 L
s
.192 .053 .451 r
.22264 .49498 m .27444 .48366 L .27463 .43937 L F
.22264 .49498 m .22241 .53794 L .27444 .48366 L F
.341 .627 .958 r
.39184 .8659 m .42138 .85705 L .37347 .84343 L F
.39184 .8659 m .43352 .8724 L .42138 .85705 L F
0 g
.38136 .86554 m
.39328 .87547 L
s
.193 .263 .707 r
.22834 .68096 m .26998 .67486 L .24619 .62924 L F
.22834 .68096 m .25291 .72098 L .26998 .67486 L F
.413 .01 .163 r
.38312 .30104 m .46628 .30159 L .47119 .27919 L F
.38312 .30104 m .37051 .3251 L .46628 .30159 L F
0 g
.37082 .8544 m
.38136 .86554 L
s
.638 .938 .963 r
.66456 .86253 m .62162 .87009 L .60213 .88326 L F
.732 .933 .955 r
.68074 .83958 m .62162 .87009 L .66456 .86253 L F
.758 .981 .912 r
.72439 .8182 m .68074 .83958 L .66456 .86253 L F
0 g
.70948 .85044 m
.71086 .84411 L
s
.84 .436 .277 r
.66776 .31999 m .76009 .39211 L .74769 .35896 L F
.777 .286 .055 r
.65628 .29628 m .66776 .31999 L .74769 .35896 L F
.698 .245 .174 r
.56629 .27752 m .66776 .31999 L .65628 .29628 L F
.45 .727 .985 r
.45426 .88506 m .47875 .87132 L .43352 .8724 L F
.45426 .88506 m .48921 .87785 L .47875 .87132 L F
0 g
.33279 .85985 m
.34506 .8746 L
s
.951 .669 .466 r
.76663 .4314 m .82405 .52873 L .82383 .48554 L F
.943 .592 .316 r
.76009 .39211 m .76663 .4314 L .82383 .48554 L F
.591 .874 .993 r
.60213 .88326 m .5653 .87692 L .55183 .88188 L F
.649 .882 .983 r
.62162 .87009 m .5653 .87692 L .60213 .88326 L F
.318 .531 .903 r
.33044 .82322 m .36955 .81881 L .32442 .79105 L F
.33044 .82322 m .37347 .84343 L .36955 .81881 L F
.958 .873 .71 r
.80064 .6212 m .79882 .71352 L .82343 .67261 L F
.988 .857 .618 r
.81633 .57439 m .80064 .6212 L .82343 .67261 L F
0 g
.72811 .8398 m
.72862 .84748 L
s
.34787 .85025 m
.35836 .86366 L
s
.74744 .84337 m
.74812 .85163 L
s
.829 .933 .899 r
.72727 .7858 m .68074 .83958 L .72439 .8182 L F
0 g
.71052 .83697 m
.71086 .84411 L
s
.877 .963 .85 r
.7665 .75166 m .72727 .7858 L .72439 .8182 L F
.293 .377 .778 r
.25291 .72098 m .30104 .71853 L .26998 .67486 L F
.25291 .72098 m .28518 .75808 L .30104 .71853 L F
.289 .189 .563 r
.22241 .53794 m .28113 .53168 L .27444 .48366 L F
.22241 .53794 m .23025 .58313 L .28113 .53168 L F
.58 .157 .203 r
.47119 .27919 m .56987 .29979 L .56629 .27752 L F
.47119 .27919 m .46628 .30159 L .56987 .29979 L F
0 g
.3226 .84372 m
.33279 .85985 L
s
.48 .707 .969 r
.43352 .8724 m .47282 .8635 L .42138 .85705 L F
.43352 .8724 m .47875 .87132 L .47282 .8635 L F
.698 .245 .174 r
.56629 .27752 m .56987 .29979 L .66776 .31999 L F
0 g
.33922 .83574 m
.34787 .85025 L
s
.649 .882 .983 r
.62162 .87009 m .5751 .87014 L .5653 .87692 L F
.693 .874 .966 r
.63223 .85443 m .5751 .87014 L .62162 .87009 L F
.732 .933 .955 r
.68074 .83958 m .63223 .85443 L .62162 .87009 L F
.379 .133 .41 r
.28144 .40003 m .35693 .396 L .36162 .35694 L F
.28144 .40003 m .27463 .43937 L .35693 .396 L F
.625 .78 .955 r
.56441 .83889 m .51925 .88478 L .53599 .88458 L F
.56441 .83889 m .50315 .88247 L .51925 .88478 L F
.56441 .83889 m .53599 .88458 L .55183 .88188 L F
.427 .621 .933 r
.37347 .84343 m .41927 .84041 L .36955 .81881 L F
0 g
.36184 .84219 m
.37082 .8544 L
s
.427 .621 .933 r
.37347 .84343 m .42138 .85705 L .41927 .84041 L F
0 g
.35453 .82913 m
.36184 .84219 L
s
.92 .876 .776 r
.77723 .66772 m .7665 .75166 L .79882 .71352 L F
.958 .873 .71 r
.80064 .6212 m .77723 .66772 L .79882 .71352 L F
.625 .78 .955 r
.56441 .83889 m .48921 .87785 L .50315 .88247 L F
.94 .715 .57 r
.76681 .47588 m .81633 .57439 L .82405 .52873 L F
.951 .669 .466 r
.76663 .4314 m .76681 .47588 L .82405 .52873 L F
.625 .78 .955 r
.56441 .83889 m .55183 .88188 L .5653 .87692 L F
.775 .895 .928 r
.68221 .81482 m .63223 .85443 L .68074 .83958 L F
.829 .933 .899 r
.72727 .7858 m .68221 .81482 L .68074 .83958 L F
0 g
.72547 .83104 m
.72811 .8398 L
s
.70834 .82896 m
.71052 .83697 L
s
.74744 .84337 m
.74435 .83379 L
s
.858 .525 .42 r
.67586 .35163 m .76663 .4314 L .76009 .39211 L F
.84 .436 .277 r
.66776 .31999 m .67586 .35163 L .76009 .39211 L F
.501 .171 .339 r
.37051 .3251 m .46281 .33249 L .46628 .30159 L F
.37051 .3251 m .36162 .35694 L .46281 .33249 L F
.625 .78 .955 r
.56441 .83889 m .47875 .87132 L .48921 .87785 L F
.374 .471 .831 r
.28518 .75808 m .33851 .75881 L .30104 .71853 L F
.28518 .75808 m .32442 .79105 L .33851 .75881 L F
.625 .78 .955 r
.56441 .83889 m .5653 .87692 L .5751 .87014 L F
0 g
.31461 .82653 m
.3226 .84372 L
s
.33252 .82041 m
.33922 .83574 L
s
.745 .371 .345 r
.56987 .29979 m .67586 .35163 L .66776 .31999 L F
0 g
.70419 .82004 m
.70834 .82896 L
s
.36 .293 .645 r
.23025 .58313 m .29472 .58199 L .28113 .53168 L F
.23025 .58313 m .24619 .62924 L .29472 .58199 L F
.515 .693 .949 r
.42138 .85705 m .47207 .8551 L .41927 .84041 L F
.42138 .85705 m .47282 .8635 L .47207 .8551 L F
.878 .871 .826 r
.74669 .71243 m .72727 .7858 L .7665 .75166 L F
.92 .876 .776 r
.77723 .66772 m .74669 .71243 L .7665 .75166 L F
.625 .78 .955 r
.56441 .83889 m .47282 .8635 L .47875 .87132 L F
.56441 .83889 m .5751 .87014 L .58023 .86217 L F
.693 .874 .966 r
.63223 .85443 m .58023 .86217 L .5751 .87014 L F
.718 .852 .946 r
.63265 .83772 m .58023 .86217 L .63223 .85443 L F
.775 .895 .928 r
.68221 .81482 m .63265 .83772 L .63223 .85443 L F
0 g
.7206 .82116 m
.72547 .83104 L
s
.441 .55 .871 r
.32442 .79105 m .38121 .79438 L .33851 .75881 L F
.32442 .79105 m .36955 .81881 L .38121 .79438 L F
0 g
.34895 .81542 m
.35453 .82913 L
s
.92 .743 .646 r
.76039 .52432 m .80064 .6212 L .81633 .57439 L F
.94 .715 .57 r
.76681 .47588 m .76039 .52432 L .81633 .57439 L F
0 g
.74435 .83379 m
.73868 .82281 L
s
.34514 .80133 m
.34895 .81542 L
s
.32784 .80454 m
.33252 .82041 L
s
.442 .243 .513 r
.27463 .43937 m .35679 .44132 L .35693 .396 L F
.27463 .43937 m .27444 .48366 L .35679 .44132 L F
0 g
.30887 .80863 m
.31461 .82653 L
s
.625 .78 .955 r
.56441 .83889 m .47207 .8551 L .47282 .8635 L F
.833 .86 .865 r
.70991 .75387 m .68221 .81482 L .72727 .7858 L F
.878 .871 .826 r
.74669 .71243 m .70991 .75387 L .72727 .7858 L F
.625 .78 .955 r
.56441 .83889 m .58023 .86217 L .58013 .85376 L F
.718 .852 .946 r
.63265 .83772 m .58013 .85376 L .58023 .86217 L F
.638 .288 .361 r
.46628 .30159 m .57239 .33062 L .56987 .29979 L F
.46628 .30159 m .46281 .33249 L .57239 .33062 L F
.499 .621 .902 r
.36955 .81881 m .42776 .82406 L .38121 .79438 L F
.36955 .81881 m .41927 .84041 L .42776 .82406 L F
.745 .371 .345 r
.56987 .29979 m .57239 .33062 L .67586 .35163 L F
.415 .376 .707 r
.24619 .62924 m .31491 .63294 L .29472 .58199 L F
.24619 .62924 m .26998 .67486 L .31491 .63294 L F
.859 .582 .518 r
.68013 .39064 m .76681 .47588 L .76663 .4314 L F
.858 .525 .42 r
.67586 .35163 m .68013 .39064 L .76663 .4314 L F
.784 .845 .898 r
.66805 .79065 m .63265 .83772 L .68221 .81482 L F
.833 .86 .865 r
.70991 .75387 m .66805 .79065 L .68221 .81482 L F
0 g
.698 .8102 m
.70419 .82004 L
s
.552 .686 .928 r
.41927 .84041 m .47665 .84695 L .42776 .82406 L F
.41927 .84041 m .47207 .8551 L .47665 .84695 L F
0 g
.3431 .78709 m
.34514 .80133 L
s
.71342 .81017 m
.7206 .82116 L
s
.625 .78 .955 r
.56441 .83889 m .47665 .84695 L .47207 .8551 L F
0 g
.32517 .78844 m
.32784 .80454 L
s
.625 .78 .955 r
.56441 .83889 m .58013 .85376 L .5747 .84573 L F
.728 .824 .925 r
.62248 .82159 m .58013 .85376 L .63265 .83772 L F
.62248 .82159 m .5747 .84573 L .58013 .85376 L F
.784 .845 .898 r
.66805 .79065 m .62248 .82159 L .63265 .83772 L F
.551 .277 .453 r
.36162 .35694 m .46098 .37136 L .46281 .33249 L F
.36162 .35694 m .35693 .396 L .46098 .37136 L F
0 g
.30541 .79037 m
.30887 .80863 L
s
.897 .762 .705 r
.74737 .57524 m .77723 .66772 L .80064 .6212 L F
.92 .743 .646 r
.76039 .52432 m .74737 .57524 L .80064 .6212 L F
.764 .451 .457 r
.57239 .33062 m .68013 .39064 L .67586 .35163 L F
0 g
.73868 .82281 m
.73021 .81039 L
s
.459 .447 .757 r
.26998 .67486 m .34113 .68283 L .31491 .63294 L F
.26998 .67486 m .30104 .71853 L .34113 .68283 L F
0 g
.68977 .79951 m
.698 .8102 L
s
.34283 .77296 m
.3431 .78709 L
s
.625 .78 .955 r
.56441 .83889 m .48621 .83988 L .47665 .84695 L F
.587 .685 .909 r
.42776 .82406 m .47665 .84695 L .48621 .83988 L F
.485 .325 .588 r
.27444 .48366 m .3614 .49161 L .35679 .44132 L F
.27444 .48366 m .28113 .53168 L .3614 .49161 L F
.725 .794 .907 r
.6024 .80771 m .5747 .84573 L .62248 .82159 L F
.6024 .80771 m .56441 .83889 L .5747 .84573 L F
0 g
.32445 .7724 m
.32517 .78844 L
s
.30419 .77213 m
.30541 .79037 L
s
.871 .776 .754 r
.72802 .62697 m .74669 .71243 L .77723 .66772 L F
.897 .762 .705 r
.74737 .57524 m .72802 .62697 L .77723 .66772 L F
0 g
.70388 .79811 m
.71342 .81017 L
s
.496 .51 .801 r
.30104 .71853 m .37252 .72995 L .34113 .68283 L F
.30104 .71853 m .33851 .75881 L .37252 .72995 L F
.587 .685 .909 r
.42776 .82406 m .48621 .83988 L .44635 .80972 L F
.559 .627 .875 r
.38121 .79438 m .42776 .82406 L .44635 .80972 L F
.852 .623 .59 r
.68025 .43609 m .76039 .52432 L .76681 .47588 L F
.859 .582 .518 r
.68013 .39064 m .68025 .43609 L .76681 .47588 L F
.625 .78 .955 r
.56441 .83889 m .49985 .83461 L .48621 .83988 L F
.62 .691 .895 r
.44635 .80972 m .48621 .83988 L .49985 .83461 L F
.625 .78 .955 r
.56441 .83889 m .5162 .83171 L .49985 .83461 L F
.56441 .83889 m .5336 .83149 L .5162 .83171 L F
.56441 .83889 m .55024 .83397 L .5336 .83149 L F
.714 .766 .893 r
.57427 .79763 m .56441 .83889 L .6024 .80771 L F
.57427 .79763 m .55024 .83397 L .56441 .83889 L F
.772 .795 .871 r
.63898 .76966 m .62248 .82159 L .66805 .79065 L F
.63898 .76966 m .6024 .80771 L .62248 .82159 L F
.529 .569 .839 r
.33851 .75881 m .40801 .77271 L .37252 .72995 L F
.33851 .75881 m .38121 .79438 L .40801 .77271 L F
0 g
.34283 .77296 m
.34426 .75919 L
s
.559 .627 .875 r
.38121 .79438 m .44635 .80972 L .40801 .77271 L F
0 g
.32445 .7724 m
.32562 .75671 L
s
.842 .785 .796 r
.70291 .67777 m .70991 .75387 L .74669 .71243 L F
.871 .776 .754 r
.72802 .62697 m .70291 .67777 L .74669 .71243 L F
.667 .373 .465 r
.46281 .33249 m .57372 .36947 L .57239 .33062 L F
.46281 .33249 m .46098 .37136 L .57372 .36947 L F
.649 .702 .886 r
.47335 .79894 m .49985 .83461 L .5162 .83171 L F
.62 .691 .895 r
.44635 .80972 m .49985 .83461 L .47335 .79894 L F
.764 .451 .457 r
.57239 .33062 m .57372 .36947 L .68013 .39064 L F
.697 .74 .885 r
.54097 .79251 m .55024 .83397 L .57427 .79763 L F
.54097 .79251 m .5336 .83149 L .55024 .83397 L F
0 g
.66786 .79068 m
.66793 .79075 L
s
.81 .792 .835 r
.67289 .72587 m .66805 .79065 L .70991 .75387 L F
0 g
.67954 .78805 m
.68977 .79951 L
s
.81 .792 .835 r
.67289 .72587 m .63898 .76966 L .66805 .79065 L F
0 g
.65735 .78008 m
.66783 .79065 L
s
.66783 .79065 m
.66786 .79068 L
s
.30419 .77213 m
.3051 .75425 L
s
.842 .785 .796 r
.70291 .67777 m .67289 .72587 L .70991 .75387 L F
.674 .719 .883 r
.50606 .79297 m .5162 .83171 L .5336 .83149 L F
.649 .702 .886 r
.47335 .79894 m .5162 .83171 L .50606 .79297 L F
.674 .719 .883 r
.50606 .79297 m .5336 .83149 L .54097 .79251 L F
.583 .354 .534 r
.35693 .396 m .46092 .41726 L .46098 .37136 L F
.35693 .396 m .35679 .44132 L .46092 .41726 L F
.517 .391 .647 r
.28113 .53168 m .37074 .5453 L .3614 .49161 L F
.28113 .53168 m .29472 .58199 L .37074 .5453 L F
0 g
.34426 .75919 m
.34732 .74599 L
s
.69201 .7851 m
.70388 .79811 L
s
.771 .507 .536 r
.57372 .36947 m .68025 .43609 L .68013 .39064 L F
0 g
.32562 .75671 m
.32862 .74165 L
s
.609 .639 .855 r
.40801 .77271 m .44635 .80972 L .47335 .79894 L F
0 g
.66737 .77597 m
.67954 .78805 L
s
.842 .653 .647 r
.67605 .48667 m .74737 .57524 L .76039 .52432 L F
.852 .623 .59 r
.68025 .43609 m .67605 .48667 L .76039 .52432 L F
.75 .751 .853 r
.59758 .75429 m .6024 .80771 L .63898 .76966 L F
.59758 .75429 m .57427 .79763 L .6024 .80771 L F
0 g
.34732 .74599 m
.35192 .73355 L
s
.6452 .76906 m
.65735 .78008 L
s
.3051 .75425 m
.30803 .73703 L
s
.543 .447 .696 r
.29472 .58199 m .38457 .60054 L .37074 .5453 L F
.29472 .58199 m .31491 .63294 L .38457 .60054 L F
0 g
.32862 .74165 m
.33333 .72744 L
s
.35192 .73355 m
.35797 .72206 L
s
.609 .639 .855 r
.40801 .77271 m .47335 .79894 L .44768 .75629 L F
.596 .591 .817 r
.37252 .72995 m .40801 .77271 L .44768 .75629 L F
0 g
.67793 .77132 m
.69201 .7851 L
s
.652 .658 .843 r
.44768 .75629 m .47335 .79894 L .50606 .79297 L F
0 g
.30803 .73703 m
.31283 .72075 L
s
.722 .713 .842 r
.54813 .74645 m .57427 .79763 L .59758 .75429 L F
.54813 .74645 m .54097 .79251 L .57427 .79763 L F
.829 .677 .694 r
.66755 .54078 m .72802 .62697 L .74737 .57524 L F
.842 .653 .647 r
.67605 .48667 m .66755 .54078 L .74737 .57524 L F
.777 .735 .814 r
.61931 .70522 m .63898 .76966 L .67289 .72587 L F
0 g
.64193 .76636 m
.6452 .76906 L
s
.65342 .76345 m
.66737 .77597 L
s
.777 .735 .814 r
.61931 .70522 m .59758 .75429 L .63898 .76966 L F
0 g
.63653 .7619 m
.64193 .76636 L
s
.63162 .75785 m
.63653 .7619 L
s
.604 .412 .595 r
.35679 .44132 m .46272 .46887 L .46092 .41726 L F
.35679 .44132 m .3614 .49161 L .46272 .46887 L F
.684 .435 .54 r
.46098 .37136 m .57376 .41542 L .57372 .36947 L F
.46098 .37136 m .46092 .41726 L .57376 .41542 L F
.563 .497 .739 r
.31491 .63294 m .40246 .65539 L .38457 .60054 L F
.31491 .63294 m .34113 .68283 L .40246 .65539 L F
0 g
.33333 .72744 m
.33964 .71428 L
s
.771 .507 .536 r
.57372 .36947 m .57376 .41542 L .68025 .43609 L F
.596 .591 .817 r
.37252 .72995 m .44768 .75629 L .42376 .70792 L F
.581 .544 .778 r
.34113 .68283 m .37252 .72995 L .42376 .70792 L F
0 g
.35797 .72206 m
.3654 .71168 L
s
.689 .682 .839 r
.49619 .74714 m .50606 .79297 L .54097 .79251 L F
.652 .658 .843 r
.44768 .75629 m .50606 .79297 L .49619 .74714 L F
.689 .682 .839 r
.49619 .74714 m .54097 .79251 L .54813 .74645 L F
.581 .544 .778 r
.34113 .68283 m .42376 .70792 L .40246 .65539 L F
.772 .548 .596 r
.57376 .41542 m .67605 .48667 L .68025 .43609 L F
.815 .698 .736 r
.65495 .59656 m .70291 .67777 L .72802 .62697 L F
.829 .677 .694 r
.66755 .54078 m .65495 .59656 L .72802 .62697 L F
0 g
.31939 .70566 m
.31283 .72075 L
s
.798 .717 .776 r
.63868 .65203 m .67289 .72587 L .70291 .67777 L F
.63868 .65203 m .61931 .70522 L .67289 .72587 L F
0 g
.33964 .71428 m
.34742 .70234 L
s
.3654 .71168 m
.37411 .70253 L
s
.815 .698 .736 r
.65495 .59656 m .63868 .65203 L .70291 .67777 L F
0 g
.63789 .75072 m
.65342 .76345 L
s
.66188 .75703 m
.67793 .77132 L
s
.65 .617 .803 r
.42376 .70792 m .44768 .75629 L .49619 .74714 L F
0 g
.32757 .69196 m
.31939 .70566 L
s
.37411 .70253 m
.38402 .6947 L
s
.34742 .70234 m
.35658 .69177 L
s
.739 .688 .802 r
.55484 .69464 m .59758 .75429 L .61931 .70522 L F
0 g
.6168 .74665 m
.61748 .74717 L
s
.61748 .74717 m
.63162 .75785 L
s
.739 .688 .802 r
.55484 .69464 m .54813 .74645 L .59758 .75429 L F
.619 .461 .645 r
.3614 .49161 m .46637 .52451 L .46272 .46887 L F
.3614 .49161 m .37074 .5453 L .46637 .52451 L F
0 g
.60095 .73569 m
.6168 .74665 L
s
.62103 .73801 m
.63789 .75072 L
s
.77 .582 .645 r
.57245 .46713 m .66755 .54078 L .67605 .48667 L F
.772 .548 .596 r
.57376 .41542 m .57245 .46713 L .67605 .48667 L F
0 g
.38402 .6947 m
.39503 .68827 L
s
.693 .482 .597 r
.46092 .41726 m .57245 .46713 L .57376 .41542 L F
.46092 .41726 m .46272 .46887 L .57245 .46713 L F
0 g
.35658 .69177 m
.36705 .6827 L
s
.64408 .74249 m
.66188 .75703 L
s
.32757 .69196 m
.33723 .6798 L
s
.58946 .72841 m
.60095 .73569 L
s
.58432 .72516 m
.58946 .72841 L
s
.697 .649 .798 r
.48695 .69558 m .49619 .74714 L .54813 .74645 L F
.65 .617 .803 r
.42376 .70792 m .49619 .74714 L .48695 .69558 L F
.697 .649 .798 r
.48695 .69558 m .54813 .74645 L .55484 .69464 L F
.646 .579 .765 r
.40246 .65539 m .42376 .70792 L .48695 .69558 L F
0 g
.39503 .68827 m
.4071 .68333 L
s
.631 .503 .688 r
.37074 .5453 m .47176 .58224 L .46637 .52451 L F
.37074 .5453 m .38457 .60054 L .47176 .58224 L F
0 g
.36705 .6827 m
.37872 .6752 L
s
.75 .663 .764 r
.56083 .63878 m .61931 .70522 L .63868 .65203 L F
.56083 .63878 m .55484 .69464 L .61931 .70522 L F
0 g
.6031 .72559 m
.62103 .73801 L
s
.56715 .71528 m
.58432 .72516 L
s
.33723 .6798 m
.34827 .66928 L
s
.765 .611 .687 r
.5698 .52292 m .65495 .59656 L .66755 .54078 L F
.77 .582 .645 r
.57245 .46713 m .5698 .52292 L .66755 .54078 L F
.646 .579 .765 r
.40246 .65539 m .48695 .69558 L .4787 .63996 L F
0 g
.4071 .68333 m
.42014 .67991 L
s
.639 .542 .728 r
.38457 .60054 m .40246 .65539 L .4787 .63996 L F
.38457 .60054 m .4787 .63996 L .47176 .58224 L F
0 g
.64408 .74249 m
.62485 .728 L
s
.39152 .66934 m
.37872 .6752 L
s
.42014 .67991 m
.4341 .67803 L
s
.54967 .70624 m
.56715 .71528 L
s
.759 .638 .726 r
.56588 .58084 m .63868 .65203 L .65495 .59656 L F
.56588 .58084 m .56083 .63878 L .63868 .65203 L F
0 g
.58439 .71372 m
.6031 .72559 L
s
.765 .611 .687 r
.5698 .52292 m .56588 .58084 L .65495 .59656 L F
0 g
.36059 .66052 m
.34827 .66928 L
s
.699 .521 .644 r
.46272 .46887 m .5698 .52292 L .57245 .46713 L F
.46272 .46887 m .46637 .52451 L .5698 .52292 L F
0 g
.4341 .67803 m
.44888 .67769 L
s
.53406 .69912 m
.54967 .70624 L
s
.53208 .69822 m
.53406 .69912 L
s
.701 .618 .761 r
.4787 .63996 m .48695 .69558 L .55484 .69464 L F
0 g
.39152 .66934 m
.40538 .66516 L
s
.701 .618 .761 r
.4787 .63996 m .55484 .69464 L .56083 .63878 L F
0 g
.44888 .67769 m
.46442 .67889 L
s
.51461 .69137 m
.53208 .69822 L
s
.46442 .67889 m
.48064 .68161 L
s
.49741 .6858 m
.51461 .69137 L
s
.37413 .6536 m
.36059 .66052 L
s
.56518 .70264 m
.58439 .71372 L
s
.48064 .68161 m
.49741 .6858 L
s
.62485 .728 m
.60452 .7139 L
s
.40538 .66516 m
.42025 .66271 L
s
.702 .555 .685 r
.46637 .52451 m .56588 .58084 L .5698 .52292 L F
.46637 .52451 m .47176 .58224 L .56588 .58084 L F
0 g
.42025 .66271 m
.43607 .66201 L
s
.54575 .69257 m
.56518 .70264 L
s
.702 .587 .724 r
.47176 .58224 m .4787 .63996 L .56083 .63878 L F
0 g
.38882 .64858 m
.37413 .6536 L
s
.702 .587 .724 r
.47176 .58224 m .56083 .63878 L .56588 .58084 L F
0 g
.45276 .66305 m
.43607 .66201 L
s
.60452 .7139 m
.58345 .70049 L
s
.54575 .69257 m
.52634 .68369 L
s
.47024 .66578 m
.45276 .66305 L
s
.40461 .64547 m
.38882 .64858 L
s
.52634 .68369 m
.50717 .67619 L
s
.48841 .67018 m
.47024 .66578 L
s
.50717 .67619 m
.48841 .67018 L
s
.42144 .64429 m
.40461 .64547 L
s
.58345 .70049 m
.56197 .68803 L
s
.43927 .64506 m
.42144 .64429 L
s
.56197 .68803 m
.5404 .6768 L
s
.45805 .64778 m
.43927 .64506 L
s
.5404 .6768 m
.51902 .66701 L
s
.47768 .6524 m
.45805 .64778 L
s
.51902 .66701 m
.49805 .65884 L
s
.49805 .65884 m
.47768 .6524 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0122477 0.97619 0.502154 MathSubStart
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0545142 1.1616 -6.10948e-17 1.1616 [
[ 0 0 0 0 ]
[ 1 1.08024 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08024 L
0 1.08024 L
closepath
clip
newpath
.751 .603 .693 r
.49641 .58077 m .4173 .61167 L .42757 .56871 L F
.49641 .58077 m .49333 .62464 L .4173 .61167 L F
.747 .623 .722 r
.50014 .53692 m .49641 .58077 L .42757 .56871 L F
.703 .561 .691 r
.56749 .57971 m .49333 .62464 L .49641 .58077 L F
.703 .585 .72 r
.56234 .53597 m .49641 .58077 L .50014 .53692 L F
.56234 .53597 m .56749 .57971 L .49641 .58077 L F
.703 .561 .691 r
.56749 .57971 m .57174 .6235 L .49333 .62464 L F
.651 .522 .694 r
.63547 .56559 m .57174 .6235 L .56749 .57971 L F
.657 .551 .723 r
.62174 .5233 m .56749 .57971 L .56234 .53597 L F
.62174 .5233 m .63547 .56559 L .56749 .57971 L F
.747 .623 .722 r
.50014 .53692 m .42757 .56871 L .43997 .52609 L F
.74 .642 .75 r
.50445 .49376 m .50014 .53692 L .43997 .52609 L F
.703 .608 .748 r
.55639 .49295 m .50014 .53692 L .50445 .49376 L F
.55639 .49295 m .56234 .53597 L .50014 .53692 L F
.755 .582 .662 r
.49333 .62464 m .40935 .65429 L .4173 .61167 L F
.49333 .62464 m .49094 .66783 L .40935 .65429 L F
.701 .535 .66 r
.57174 .6235 m .49094 .66783 L .49333 .62464 L F
.662 .579 .751 r
.60587 .48212 m .56234 .53597 L .55639 .49295 L F
.60587 .48212 m .62174 .5233 L .56234 .53597 L F
.701 .535 .66 r
.57174 .6235 m .57504 .66664 L .49094 .66783 L F
.643 .492 .662 r
.64685 .60832 m .57504 .66664 L .57174 .6235 L F
.651 .522 .694 r
.63547 .56559 m .64685 .60832 L .57174 .6235 L F
.74 .642 .75 r
.50445 .49376 m .43997 .52609 L .45429 .48451 L F
.732 .66 .779 r
.5093 .45201 m .50445 .49376 L .45429 .48451 L F
.701 .632 .776 r
.5497 .45136 m .50445 .49376 L .5093 .45201 L F
.5497 .45136 m .55639 .49295 L .50445 .49376 L F
.667 .608 .78 r
.58811 .44275 m .55639 .49295 L .5497 .45136 L F
.58811 .44275 m .60587 .48212 L .55639 .49295 L F
.757 .558 .627 r
.49094 .66783 m .40387 .69585 L .40935 .65429 L F
.49094 .66783 m .4893 .70965 L .40387 .69585 L F
.698 .508 .627 r
.57504 .66664 m .4893 .70965 L .49094 .66783 L F
.57504 .66664 m .5773 .70844 L .4893 .70965 L F
.634 .459 .628 r
.65567 .65078 m .5773 .70844 L .57504 .66664 L F
.643 .492 .662 r
.64685 .60832 m .65567 .65078 L .57504 .66664 L F
.799 .653 .7 r
.42757 .56871 m .3494 .58525 L .36631 .54418 L F
.42757 .56871 m .4173 .61167 L .3494 .58525 L F
.788 .668 .731 r
.43997 .52609 m .42757 .56871 L .36631 .54418 L F
.43997 .52609 m .36631 .54418 L .38665 .50414 L F
.776 .682 .76 r
.45429 .48451 m .43997 .52609 L .38665 .50414 L F
.591 .485 .702 r
.69502 .53917 m .64685 .60832 L .63547 .56559 L F
.605 .521 .733 r
.67351 .49967 m .63547 .56559 L .62174 .5233 L F
.67351 .49967 m .69502 .53917 L .63547 .56559 L F
.618 .555 .762 r
.64876 .462 m .62174 .5233 L .60587 .48212 L F
.64876 .462 m .67351 .49967 L .62174 .5233 L F
.808 .635 .667 r
.4173 .61167 m .33626 .62664 L .3494 .58525 L F
.4173 .61167 m .40935 .65429 L .33626 .62664 L F
.776 .682 .76 r
.45429 .48451 m .38665 .50414 L .41008 .4658 L F
.761 .694 .788 r
.47034 .44465 m .45429 .48451 L .41008 .4658 L F
.732 .66 .779 r
.5093 .45201 m .45429 .48451 L .47034 .44465 L F
.575 .447 .668 r
.71292 .57984 m .65567 .65078 L .64685 .60832 L F
.591 .485 .702 r
.69502 .53917 m .71292 .57984 L .64685 .60832 L F
.63 .59 .79 r
.62119 .42681 m .60587 .48212 L .58811 .44275 L F
.62119 .42681 m .64876 .462 L .60587 .48212 L F
.721 .679 .808 r
.51461 .41237 m .5093 .45201 L .47034 .44465 L F
.697 .656 .806 r
.54238 .41192 m .5093 .45201 L .51461 .41237 L F
.54238 .41192 m .5497 .45136 L .5093 .45201 L F
.671 .638 .809 r
.56873 .40588 m .5497 .45136 L .54238 .41192 L F
.56873 .40588 m .58811 .44275 L .5497 .45136 L F
.757 .53 .588 r
.4893 .70965 m .40102 .73562 L .40387 .69585 L F
.4893 .70965 m .48845 .74938 L .40102 .73562 L F
.693 .476 .589 r
.5773 .70844 m .48845 .74938 L .4893 .70965 L F
.5773 .70844 m .57848 .74817 L .48845 .74938 L F
.623 .421 .588 r
.66175 .69228 m .57848 .74817 L .5773 .70844 L F
.634 .459 .628 r
.65567 .65078 m .66175 .69228 L .5773 .70844 L F
.816 .614 .629 r
.40935 .65429 m .3272 .66764 L .33626 .62664 L F
.40935 .65429 m .40387 .69585 L .3272 .66764 L F
.557 .404 .63 r
.72683 .62098 m .66175 .69228 L .65567 .65078 L F
.575 .447 .668 r
.71292 .57984 m .72683 .62098 L .65567 .65078 L F
.761 .694 .788 r
.47034 .44465 m .41008 .4658 L .43619 .42982 L F
.743 .705 .816 r
.48787 .40721 m .47034 .44465 L .43619 .42982 L F
.721 .679 .808 r
.51461 .41237 m .47034 .44465 L .48787 .40721 L F
.643 .626 .818 r
.59126 .39474 m .58811 .44275 L .56873 .40588 L F
.59126 .39474 m .62119 .42681 L .58811 .44275 L F
.83 .723 .747 r
.38665 .50414 m .31789 .50862 L .34487 .47246 L F
.38665 .50414 m .36631 .54418 L .31789 .50862 L F
.809 .73 .777 r
.41008 .4658 m .38665 .50414 L .34487 .47246 L F
.41008 .4658 m .34487 .47246 L .37576 .43893 L F
.787 .734 .804 r
.43619 .42982 m .41008 .4658 L .37576 .43893 L F
.848 .714 .714 r
.36631 .54418 m .29535 .54679 L .31789 .50862 L F
.36631 .54418 m .3494 .58525 L .29535 .54679 L F
.822 .589 .585 r
.40387 .69585 m .32248 .70748 L .3272 .66764 L F
.40387 .69585 m .40102 .73562 L .32248 .70748 L F
.542 .493 .751 r
.71303 .46661 m .69502 .53917 L .67351 .49967 L F
.566 .536 .78 r
.68114 .43399 m .67351 .49967 L .64876 .462 L F
.68114 .43399 m .71303 .46661 L .67351 .49967 L F
.707 .698 .839 r
.5203 .37559 m .51461 .41237 L .48787 .40721 L F
.691 .683 .838 r
.53454 .37535 m .51461 .41237 L .5203 .37559 L F
.53454 .37535 m .54238 .41192 L .51461 .41237 L F
.673 .671 .84 r
.54801 .3722 m .54238 .41192 L .53454 .37535 L F
.54801 .3722 m .56873 .40588 L .54238 .41192 L F
.59 .577 .807 r
.64586 .40476 m .64876 .462 L .62119 .42681 L F
.64586 .40476 m .68114 .43399 L .64876 .462 L F
.755 .496 .541 r
.48845 .74938 m .40094 .77284 L .40102 .73562 L F
.48845 .74938 m .48842 .78627 L .40094 .77284 L F
.686 .439 .543 r
.57848 .74817 m .48842 .78627 L .48845 .74938 L F
.515 .446 .717 r
.74091 .50204 m .71292 .57984 L .69502 .53917 L F
.542 .493 .751 r
.71303 .46661 m .74091 .50204 L .69502 .53917 L F
.686 .439 .543 r
.57848 .74817 m .57851 .78509 L .48842 .78627 L F
.608 .376 .54 r
.6649 .73206 m .57851 .78509 L .57848 .74817 L F
.623 .421 .588 r
.66175 .69228 m .6649 .73206 L .57848 .74817 L F
.535 .356 .584 r
.73643 .66185 m .6649 .73206 L .66175 .69228 L F
.557 .404 .63 r
.72683 .62098 m .73643 .66185 L .66175 .69228 L F
.787 .734 .804 r
.43619 .42982 m .37576 .43893 L .40998 .40864 L F
.761 .736 .83 r
.46458 .39684 m .43619 .42982 L .40998 .40864 L F
.743 .705 .816 r
.48787 .40721 m .43619 .42982 L .46458 .39684 L F
.865 .701 .677 r
.3494 .58525 m .27777 .58629 L .29535 .54679 L F
.3494 .58525 m .33626 .62664 L .27777 .58629 L F
.72 .716 .845 r
.50661 .37289 m .48787 .40721 L .46458 .39684 L F
.707 .698 .839 r
.5203 .37559 m .48787 .40721 L .50661 .37289 L F
.655 .664 .846 r
.55944 .36641 m .56873 .40588 L .54801 .3722 L F
.55944 .36641 m .59126 .39474 L .56873 .40588 L F
.613 .619 .833 r
.60784 .37944 m .62119 .42681 L .59126 .39474 L F
.60784 .37944 m .64586 .40476 L .62119 .42681 L F
.485 .395 .679 r
.76422 .53965 m .72683 .62098 L .71292 .57984 L F
.515 .446 .717 r
.74091 .50204 m .76422 .53965 L .71292 .57984 L F
.761 .736 .83 r
.46458 .39684 m .40998 .40864 L .44691 .38212 L F
.73 .735 .855 r
.49477 .3675 m .46458 .39684 L .44691 .38212 L F
.72 .716 .845 r
.50661 .37289 m .46458 .39684 L .49477 .3675 L F
.88 .683 .632 r
.33626 .62664 m .26561 .62638 L .27777 .58629 L F
.33626 .62664 m .3272 .66764 L .26561 .62638 L F
.636 .661 .857 r
.56774 .35851 m .59126 .39474 L .55944 .36641 L F
.56774 .35851 m .60784 .37944 L .59126 .39474 L F
.825 .556 .531 r
.40102 .73562 m .32235 .74538 L .32248 .70748 L F
.40102 .73562 m .40094 .77284 L .32235 .74538 L F
.45 .336 .632 r
.78241 .57878 m .73643 .66185 L .72683 .62098 L F
.485 .395 .679 r
.76422 .53965 m .78241 .57878 L .72683 .62098 L F
.608 .376 .54 r
.6649 .73206 m .66499 .76936 L .57851 .78509 L F
.508 .297 .528 r
.74142 .70171 m .66499 .76936 L .6649 .73206 L F
.535 .356 .584 r
.73643 .66185 m .74142 .70171 L .6649 .73206 L F
.672 .728 .892 r
.56729 .33016 m .5203 .37559 L .50661 .37289 L F
.56729 .33016 m .53454 .37535 L .5203 .37559 L F
.56729 .33016 m .54801 .3722 L .53454 .37535 L F
.838 .788 .803 r
.37576 .43893 m .31891 .4333 L .35486 .40595 L F
.37576 .43893 m .34487 .47246 L .31891 .4333 L F
.807 .78 .828 r
.40998 .40864 m .37576 .43893 L .35486 .40595 L F
.40998 .40864 m .35486 .40595 L .39438 .38283 L F
.773 .77 .85 r
.44691 .38212 m .40998 .40864 L .39438 .38283 L F
.672 .728 .892 r
.56729 .33016 m .50661 .37289 L .49477 .3675 L F
.749 .452 .481 r
.48842 .78627 m .40374 .80672 L .40094 .77284 L F
.48842 .78627 m .48926 .81954 L .40374 .80672 L F
.674 .391 .486 r
.57851 .78509 m .48926 .81954 L .48842 .78627 L F
.672 .728 .892 r
.56729 .33016 m .55944 .36641 L .54801 .3722 L F
.674 .391 .486 r
.57851 .78509 m .57735 .81842 L .48926 .81954 L F
.587 .32 .479 r
.66499 .76936 m .57735 .81842 L .57851 .78509 L F
.869 .792 .773 r
.34487 .47246 m .28728 .46441 L .31891 .4333 L F
.34487 .47246 m .31789 .50862 L .28728 .46441 L F
.544 .572 .833 r
.65956 .37841 m .68114 .43399 L .64586 .40476 L F
.582 .619 .854 r
.61677 .3613 m .64586 .40476 L .60784 .37944 L F
.61677 .3613 m .65956 .37841 L .64586 .40476 L F
.504 .522 .808 r
.69961 .40027 m .71303 .46661 L .68114 .43399 L F
.544 .572 .833 r
.65956 .37841 m .69961 .40027 L .68114 .43399 L F
.773 .77 .85 r
.44691 .38212 m .39438 .38283 L .43667 .36434 L F
.736 .756 .869 r
.48591 .35989 m .44691 .38212 L .43667 .36434 L F
.73 .735 .855 r
.49477 .3675 m .44691 .38212 L .48591 .35989 L F
.672 .728 .892 r
.56729 .33016 m .49477 .3675 L .48591 .35989 L F
.56729 .33016 m .56774 .35851 L .55944 .36641 L F
.893 .659 .577 r
.3272 .66764 m .25927 .66629 L .26561 .62638 L F
.3272 .66764 m .32248 .70748 L .25927 .66629 L F
.619 .663 .871 r
.57206 .34924 m .60784 .37944 L .56774 .35851 L F
.57206 .34924 m .61677 .3613 L .60784 .37944 L F
.459 .466 .778 r
.7361 .42652 m .74091 .50204 L .71303 .46661 L F
.504 .522 .808 r
.69961 .40027 m .7361 .42652 L .71303 .46661 L F
.898 .792 .736 r
.31789 .50862 m .2607 .49874 L .28728 .46441 L F
.31789 .50862 m .29535 .54679 L .2607 .49874 L F
.672 .728 .892 r
.56729 .33016 m .48591 .35989 L .48091 .35078 L F
.736 .756 .869 r
.48591 .35989 m .43667 .36434 L .48091 .35078 L F
.408 .266 .574 r
.79501 .6187 m .74142 .70171 L .73643 .66185 L F
.45 .336 .632 r
.78241 .57878 m .79501 .6187 L .73643 .66185 L F
.672 .728 .892 r
.56729 .33016 m .57206 .34924 L .56774 .35851 L F
.409 .401 .74 r
.76825 .45673 m .76422 .53965 L .74091 .50204 L F
.459 .466 .778 r
.7361 .42652 m .76825 .45673 L .74091 .50204 L F
.824 .511 .46 r
.40094 .77284 m .32698 .78049 L .32235 .74538 L F
.40094 .77284 m .40374 .80672 L .32698 .78049 L F
.925 .787 .689 r
.29535 .54679 m .23987 .53567 L .2607 .49874 L F
.29535 .54679 m .27777 .58629 L .23987 .53567 L F
.587 .32 .479 r
.66499 .76936 m .66189 .80339 L .57735 .81842 L F
.471 .222 .455 r
.74157 .73974 m .66189 .80339 L .66499 .76936 L F
.508 .297 .528 r
.74142 .70171 m .74157 .73974 L .66499 .76936 L F
.776 .805 .876 r
.43667 .36434 m .39132 .35467 L .43503 .34511 L F
.43667 .36434 m .39438 .38283 L .39132 .35467 L F
.736 .776 .885 r
.48091 .35078 m .43667 .36434 L .43503 .34511 L F
.672 .728 .892 r
.56729 .33016 m .48091 .35078 L .48032 .34103 L F
.736 .776 .885 r
.48091 .35078 m .43503 .34511 L .48032 .34103 L F
.672 .728 .892 r
.56729 .33016 m .57193 .33947 L .57206 .34924 L F
.603 .672 .888 r
.57193 .33947 m .61677 .3613 L .57206 .34924 L F
.552 .628 .881 r
.61696 .34201 m .65956 .37841 L .61677 .3613 L F
.603 .672 .888 r
.57193 .33947 m .61696 .34201 L .61677 .3613 L F
.816 .832 .861 r
.39438 .38283 m .35008 .36964 L .39132 .35467 L F
.39438 .38283 m .35486 .40595 L .35008 .36964 L F
.902 .624 .506 r
.32248 .70748 m .25909 .70517 L .25927 .66629 L F
.32248 .70748 m .32235 .74538 L .25909 .70517 L F
.349 .326 .691 r
.79528 .49037 m .78241 .57878 L .76422 .53965 L F
.409 .401 .74 r
.76825 .45673 m .79528 .49037 L .76422 .53965 L F
.736 .393 .4 r
.48926 .81954 m .40949 .83642 L .40374 .80672 L F
.48926 .81954 m .49098 .8484 L .40949 .83642 L F
.654 .328 .409 r
.57735 .81842 m .49098 .8484 L .48926 .81954 L F
.493 .576 .867 r
.6605 .35012 m .69961 .40027 L .65956 .37841 L F
.552 .628 .881 r
.61696 .34201 m .6605 .35012 L .65956 .37841 L F
.654 .328 .409 r
.57735 .81842 m .57498 .84735 L .49098 .8484 L F
.556 .245 .396 r
.66189 .80339 m .57498 .84735 L .57735 .81842 L F
.672 .728 .892 r
.56729 .33016 m .48032 .34103 L .48424 .33158 L F
.727 .793 .904 r
.48032 .34103 m .44241 .3263 L .48424 .33158 L F
.48032 .34103 m .43503 .34511 L .44241 .3263 L F
.857 .856 .839 r
.35486 .40595 m .31224 .38985 L .35008 .36964 L F
.35486 .40595 m .31891 .4333 L .31224 .38985 L F
.592 .686 .907 r
.56729 .33016 m .61696 .34201 L .57193 .33947 L F
.354 .178 .499 r
.80158 .65861 m .74157 .73974 L .74142 .70171 L F
.408 .266 .574 r
.79501 .6187 m .80158 .65861 L .74142 .70171 L F
.95 .774 .629 r
.27777 .58629 m .2254 .57449 L .23987 .53567 L F
.27777 .58629 m .26561 .62638 L .2254 .57449 L F
.425 .514 .846 r
.70164 .36374 m .7361 .42652 L .69961 .40027 L F
.493 .576 .867 r
.6605 .35012 m .70164 .36374 L .69961 .40027 L F
.766 .837 .906 r
.43503 .34511 m .40165 .32686 L .44241 .3263 L F
.43503 .34511 m .39132 .35467 L .40165 .32686 L F
.672 .728 .892 r
.56729 .33016 m .48424 .33158 L .49237 .32338 L F
.711 .803 .922 r
.48424 .33158 m .45834 .30984 L .49237 .32338 L F
.48424 .33158 m .44241 .3263 L .45834 .30984 L F
.672 .728 .892 r
.56729 .33016 m .54655 .31655 L .55855 .32225 L F
.56729 .33016 m .53247 .31368 L .54655 .31655 L F
.56729 .33016 m .51776 .31394 L .53247 .31368 L F
.56729 .33016 m .50392 .31729 L .51776 .31394 L F
.56729 .33016 m .49237 .32338 L .50392 .31729 L F
.588 .706 .925 r
.55855 .32225 m .60815 .32345 L .56729 .33016 L F
.592 .686 .907 r
.56729 .33016 m .60815 .32345 L .61696 .34201 L F
.897 .877 .808 r
.31891 .4333 m .27869 .41501 L .31224 .38985 L F
.31891 .4333 m .28728 .46441 L .27869 .41501 L F
.524 .647 .911 r
.60815 .32345 m .6605 .35012 L .61696 .34201 L F
.277 .233 .627 r
.81649 .52683 m .79501 .6187 L .78241 .57878 L F
.349 .326 .691 r
.79528 .49037 m .81649 .52683 L .78241 .57878 L F
.813 .447 .364 r
.40374 .80672 m .3365 .81197 L .32698 .78049 L F
.40374 .80672 m .40949 .83642 L .3365 .81197 L F
.687 .805 .938 r
.49237 .32338 m .48134 .2975 L .50392 .31729 L F
.49237 .32338 m .45834 .30984 L .48134 .2975 L F
.343 .438 .814 r
.73944 .38274 m .76825 .45673 L .7361 .42652 L F
.425 .514 .846 r
.70164 .36374 m .73944 .38274 L .7361 .42652 L F
.588 .706 .925 r
.55855 .32225 m .59097 .30754 L .60815 .32345 L F
.592 .731 .941 r
.54655 .31655 m .59097 .30754 L .55855 .32225 L F
.556 .245 .396 r
.66189 .80339 m .65551 .83332 L .57498 .84735 L F
.418 .123 .354 r
.73666 .77511 m .65551 .83332 L .66189 .80339 L F
.471 .222 .455 r
.74157 .73974 m .73666 .77511 L .66189 .80339 L F
.903 .572 .41 r
.32235 .74538 m .26532 .74214 L .25909 .70517 L F
.32235 .74538 m .32698 .78049 L .26532 .74214 L F
.806 .882 .901 r
.39132 .35467 m .36284 .33346 L .40165 .32686 L F
.39132 .35467 m .35008 .36964 L .36284 .33346 L F
.658 .798 .949 r
.50392 .31729 m .50912 .29068 L .51776 .31394 L F
.50392 .31729 m .48134 .2975 L .50912 .29068 L F
.97 .749 .548 r
.26561 .62638 m .21784 .6144 L .2254 .57449 L F
.26561 .62638 m .25927 .66629 L .21784 .6144 L F
.592 .731 .941 r
.54655 .31655 m .56702 .29601 L .59097 .30754 L F
.606 .757 .951 r
.53247 .31368 m .56702 .29601 L .54655 .31655 L F
.936 .892 .762 r
.28728 .46441 m .25031 .44474 L .27869 .41501 L F
.28728 .46441 m .2607 .49874 L .25031 .44474 L F
.438 .593 .908 r
.64803 .32263 m .70164 .36374 L .6605 .35012 L F
.524 .647 .911 r
.60815 .32345 m .64803 .32263 L .6605 .35012 L F
.629 .78 .954 r
.51776 .31394 m .53874 .29017 L .53247 .31368 L F
.51776 .31394 m .50912 .29068 L .53874 .29017 L F
.606 .757 .951 r
.53247 .31368 m .53874 .29017 L .56702 .29601 L F
.282 .065 .396 r
.80176 .69767 m .73666 .77511 L .74157 .73974 L F
.354 .178 .499 r
.80158 .65861 m .80176 .69767 L .74157 .73974 L F
.737 .86 .938 r
.44241 .3263 m .42489 .30231 L .45834 .30984 L F
.44241 .3263 m .40165 .32686 L .42489 .30231 L F
.707 .306 .284 r
.49098 .8484 m .41824 .86113 L .40949 .83642 L F
.49098 .8484 m .49361 .87202 L .41824 .86113 L F
.619 .239 .3 r
.57498 .84735 m .49361 .87202 L .49098 .8484 L F
.504 .677 .943 r
.59097 .30754 m .64803 .32263 L .60815 .32345 L F
.619 .239 .3 r
.57498 .84735 m .57136 .87106 L .49361 .87202 L F
.507 .14 .278 r
.65551 .83332 m .57136 .87106 L .57498 .84735 L F
.185 .115 .539 r
.83123 .56541 m .80158 .65861 L .79501 .6187 L F
.277 .233 .627 r
.81649 .52683 m .83123 .56541 L .79501 .6187 L F
.241 .34 .765 r
.773 .4069 m .79528 .49037 L .76825 .45673 L F
.343 .438 .814 r
.73944 .38274 m .773 .4069 L .76825 .45673 L F
.846 .927 .883 r
.35008 .36964 m .32691 .34619 L .36284 .33346 L F
.35008 .36964 m .31224 .38985 L .32691 .34619 L F
.97 .897 .693 r
.2607 .49874 m .22793 .47852 L .25031 .44474 L F
.2607 .49874 m .23987 .53567 L .22793 .47852 L F
.324 .516 .89 r
.68605 .32793 m .73944 .38274 L .70164 .36374 L F
.438 .593 .908 r
.64803 .32263 m .68605 .32793 L .70164 .36374 L F
.689 .866 .966 r
.45834 .30984 m .45901 .28377 L .48134 .2975 L F
.45834 .30984 m .42489 .30231 L .45901 .28377 L F
.978 .703 .435 r
.25927 .66629 m .21762 .65452 L .21784 .6144 L F
.25927 .66629 m .25909 .70517 L .21762 .65452 L F
.504 .677 .943 r
.59097 .30754 m .62287 .29886 L .64803 .32263 L F
.501 .719 .969 r
.56702 .29601 m .62287 .29886 L .59097 .30754 L F
.782 .35 .222 r
.40949 .83642 m .35094 .83893 L .3365 .81197 L F
.40949 .83642 m .41824 .86113 L .35094 .83893 L F
.886 .491 .273 r
.32698 .78049 m .27809 .77627 L .26532 .74214 L F
.32698 .78049 m .3365 .81197 L .27809 .77627 L F
.761 .92 .942 r
.40165 .32686 m .39278 .30124 L .42489 .30231 L F
.40165 .32686 m .36284 .33346 L .39278 .30124 L F
.507 .14 .278 r
.65551 .83332 m .64582 .85831 L .57136 .87106 L F
.337 0 .206 r
.72657 .80696 m .64582 .85831 L .65551 .83332 L F
.418 .123 .354 r
.73666 .77511 m .72657 .80696 L .65551 .83332 L F
.111 .212 .69 r
.80142 .43584 m .81649 .52683 L .79528 .49037 L F
.241 .34 .765 r
.773 .4069 m .80142 .43584 L .79528 .49037 L F
.384 .625 .948 r
.62287 .29886 m .68605 .32793 L .64803 .32263 L F
.064 0 .414 r
.83893 .60531 m .80176 .69767 L .80158 .65861 L F
.185 .115 .539 r
.83123 .56541 m .83893 .60531 L .80158 .65861 L F
.18 0 .248 r
.79531 .73499 m .72657 .80696 L .73666 .77511 L F
.282 .065 .396 r
.80176 .69767 m .79531 .73499 L .73666 .77511 L F
.626 .849 .985 r
.48134 .2975 m .50055 .27347 L .50912 .29068 L F
.48134 .2975 m .45901 .28377 L .50055 .27347 L F
.882 .966 .843 r
.31224 .38985 m .29481 .365 L .32691 .34619 L F
.31224 .38985 m .27869 .41501 L .29481 .365 L F
.501 .719 .969 r
.56702 .29601 m .58729 .28152 L .62287 .29886 L F
.52 .766 .986 r
.53874 .29017 m .58729 .28152 L .56702 .29601 L F
.992 .881 .589 r
.23987 .53567 m .21233 .51572 L .22793 .47852 L F
.23987 .53567 m .2254 .57449 L .21233 .51572 L F
.565 .813 .992 r
.50912 .29068 m .54497 .27269 L .53874 .29017 L F
.50912 .29068 m .50055 .27347 L .54497 .27269 L F
.52 .766 .986 r
.53874 .29017 m .54497 .27269 L .58729 .28152 L F
.168 .404 .846 r
.72129 .33948 m .773 .4069 L .73944 .38274 L F
.324 .516 .89 r
.68605 .32793 m .72129 .33948 L .73944 .38274 L F
.645 .168 .105 r
.49361 .87202 m .42995 .87999 L .41824 .86113 L F
.49361 .87202 m .49712 .88958 L .42995 .87999 L F
.553 .1 .131 r
.57136 .87106 m .49712 .88958 L .49361 .87202 L F
.57136 .87106 m .5665 .88874 L .49712 .88958 L F
.419 0 .095 r
.64582 .85831 m .5665 .88874 L .57136 .87106 L F
.959 .62 .273 r
.25909 .70517 m .22505 .69389 L .21762 .65452 L F
.25909 .70517 m .26532 .74214 L .22505 .69389 L F
0 .04 .572 r
.82384 .46908 m .83123 .56541 L .81649 .52683 L F
.111 .212 .69 r
.80142 .43584 m .82384 .46908 L .81649 .52683 L F
.67 .924 .973 r
.42489 .30231 m .43744 .27675 L .45901 .28377 L F
.42489 .30231 m .39278 .30124 L .43744 .27675 L F
.77 .974 .919 r
.36284 .33346 m .36283 .307 L .39278 .30124 L F
.36284 .33346 m .32691 .34619 L .36283 .307 L F
.902 .986 .762 r
.27869 .41501 m .26746 .38973 L .29481 .365 L F
.27869 .41501 m .25031 .44474 L .26746 .38973 L F
.384 .625 .948 r
.62287 .29886 m .65352 .2967 L .68605 .32793 L F
.348 .674 .977 r
.58729 .28152 m .65352 .2967 L .62287 .29886 L F
.828 .356 .07 r
.3365 .81197 m .2974 .80663 L .27809 .77627 L F
.3365 .81197 m .35094 .83893 L .2974 .80663 L F
.201 .528 .921 r
.65352 .2967 m .72129 .33948 L .68605 .32793 L F
0 0 .233 r
.83915 .64565 m .79531 .73499 L .80176 .69767 L F
.064 0 .414 r
.83893 .60531 m .83915 .64565 L .80176 .69767 L F
.704 .19 .004 r
.41824 .86113 m .37022 .8605 L .35094 .83893 L F
.41824 .86113 m .42995 .87999 L .37022 .8605 L F
.983 .826 .431 r
.2254 .57449 m .20416 .55554 L .21233 .51572 L F
.2254 .57449 m .21784 .6144 L .20416 .55554 L F
0 .238 .753 r
.75282 .35729 m .80142 .43584 L .773 .4069 L F
.168 .404 .846 r
.72129 .33948 m .75282 .35729 L .773 .4069 L F
.337 0 .206 r
.72657 .80696 m .71129 .83438 L .64582 .85831 L F
.031 0 .031 r
.78208 .76963 m .71129 .83438 L .72657 .80696 L F
.18 0 .248 r
.79531 .73499 m .78208 .76963 L .72657 .80696 L F
.419 0 .095 r
.64582 .85831 m .63283 .87751 L .5665 .88874 L F
.203 0 0 r
.71129 .83438 m .63283 .87751 L .64582 .85831 L F
.545 .884 .987 r
.45901 .28377 m .49224 .26308 L .50055 .27347 L F
.45901 .28377 m .43744 .27675 L .49224 .26308 L F
0 0 .391 r
.83949 .50599 m .83893 .60531 L .83123 .56541 L F
0 .04 .572 r
.82384 .46908 m .83949 .50599 L .83123 .56541 L F
.348 .674 .977 r
.58729 .28152 m .60688 .27377 L .65352 .2967 L F
.357 .738 .987 r
.54497 .27269 m .60688 .27377 L .58729 .28152 L F
.883 .474 .041 r
.26532 .74214 m .24025 .7315 L .22505 .69389 L F
.26532 .74214 m .27809 .77627 L .24025 .7315 L F
.879 .956 .611 r
.25031 .44474 m .24579 .42003 L .26746 .38973 L F
.25031 .44474 m .22793 .47852 L .24579 .42003 L F
.739 .992 .829 r
.32691 .34619 m .33588 .31981 L .36283 .307 L F
.32691 .34619 m .29481 .365 L .33588 .31981 L F
.427 .813 .989 r
.50055 .27347 m .551 .26204 L .54497 .27269 L F
.50055 .27347 m .49224 .26308 L .551 .26204 L F
.357 .738 .987 r
.54497 .27269 m .551 .26204 L .60688 .27377 L F
.594 .945 .913 r
.39278 .30124 m .4172 .27702 L .43744 .27675 L F
.39278 .30124 m .36283 .307 L .4172 .27702 L F
0 0 0 r
.83158 .68545 m .78208 .76963 L .79531 .73499 L F
0 0 .233 r
.83915 .64565 m .83158 .68545 L .79531 .73499 L F
.504 0 0 r
.49712 .88958 m .44454 .89222 L .42995 .87999 L F
.49712 .88958 m .50151 .90029 L .44454 .89222 L F
.414 0 0 r
.5665 .88874 m .50151 .90029 L .49712 .88958 L F
0 .352 .817 r
.68215 .30146 m .75282 .35729 L .72129 .33948 L F
.201 .528 .921 r
.65352 .2967 m .68215 .30146 L .72129 .33948 L F
.911 .702 .202 r
.21784 .6144 m .20393 .59707 L .20416 .55554 L F
.21784 .6144 m .21762 .65452 L .20393 .59707 L F
.414 0 0 r
.5665 .88874 m .56044 .89958 L .50151 .90029 L F
.253 0 0 r
.63283 .87751 m .56044 .89958 L .5665 .88874 L F
0 0 .576 r
.7797 .38121 m .82384 .46908 L .80142 .43584 L F
0 .238 .753 r
.75282 .35729 m .7797 .38121 L .80142 .43584 L F
.09 .55 .907 r
.60688 .27377 m .68215 .30146 L .65352 .2967 L F
.682 .138 0 r
.35094 .83893 m .32308 .83227 L .2974 .80663 L F
.35094 .83893 m .37022 .8605 L .32308 .83227 L F
0 0 .136 r
.84769 .54579 m .83915 .64565 L .83893 .60531 L F
0 0 .391 r
.83949 .50599 m .84769 .54579 L .83893 .60531 L F
.203 0 0 r
.71129 .83438 m .69089 .85652 L .63283 .87751 L F
0 0 0 r
.76209 .80063 m .69089 .85652 L .71129 .83438 L F
.031 0 .031 r
.78208 .76963 m .76209 .80063 L .71129 .83438 L F
.52 0 0 r
.42995 .87999 m .39413 .87586 L .37022 .8605 L F
.42995 .87999 m .44454 .89222 L .39413 .87586 L F
.253 0 0 r
.63283 .87751 m .61668 .89013 L .56044 .89958 L F
0 0 0 r
.69089 .85652 m .61668 .89013 L .63283 .87751 L F
.774 .832 .366 r
.22793 .47852 m .23061 .45536 L .24579 .42003 L F
.22793 .47852 m .21233 .51572 L .23061 .45536 L F
.707 .245 0 r
.27809 .77627 m .26313 .76629 L .24025 .7315 L F
.27809 .77627 m .2974 .80663 L .26313 .76629 L F
.619 .907 .619 r
.29481 .365 m .31278 .33972 L .33588 .31981 L F
.29481 .365 m .26746 .38973 L .31278 .33972 L F
.352 .827 .865 r
.43744 .27675 m .48442 .26021 L .49224 .26308 L F
.43744 .27675 m .4172 .27702 L .48442 .26021 L F
.744 .491 0 r
.21762 .65452 m .21196 .63926 L .20393 .59707 L F
.21762 .65452 m .22505 .69389 L .21196 .63926 L F
.09 .55 .907 r
.60688 .27377 m .62528 .27335 L .68215 .30146 L F
.06 .596 .857 r
.551 .26204 m .62528 .27335 L .60688 .27377 L F
0 0 .302 r
.80103 .41094 m .83949 .50599 L .82384 .46908 L F
0 0 .576 r
.7797 .38121 m .80103 .41094 L .82384 .46908 L F
0 0 0 r
.8161 .72368 m .76209 .80063 L .78208 .76963 L F
.83158 .68545 m .8161 .72368 L .78208 .76963 L F
0 .077 .575 r
.70794 .31339 m .7797 .38121 L .75282 .35729 L F
0 .352 .817 r
.68215 .30146 m .70794 .31339 L .75282 .35729 L F
.403 .836 .696 r
.36283 .307 m .39889 .28503 L .4172 .27702 L F
.36283 .307 m .33588 .31981 L .39889 .28503 L F
0 g
.5 Mabswid
[ ] 0 setdash
.54616 .89993 m
.54776 .89973 L
s
.5448 .90007 m
.54761 .89974 L
s
.54344 .90021 m
.54749 .89974 L
s
0 0 .136 r
.84769 .54579 m .84792 .58754 L .83915 .64565 L F
.737 .702 .165 r
.84792 .58754 m .83158 .68545 L .83915 .64565 L F
.151 .689 .832 r
.49224 .26308 m .55668 .25893 L .551 .26204 L F
.49224 .26308 m .48442 .26021 L .55668 .25893 L F
.06 .596 .857 r
.551 .26204 m .55668 .25893 L .62528 .27335 L F
0 g
.53153 .9012 m
.54616 .89993 L
s
0 .292 .666 r
.62528 .27335 m .70794 .31339 L .68215 .30146 L F
0 g
.63108 .88365 m
.63314 .8831 L
s
.63089 .88369 m
.63108 .88365 L
s
.63097 .88367 m
.63415 .88282 L
s
.63093 .88368 m
.63097 .88367 L
s
.63095 .88367 m
.63516 .88254 L
s
.402 0 0 r
.37022 .8605 m .35476 .85229 L .32308 .83227 L F
.37022 .8605 m .39413 .87586 L .35476 .85229 L F
.213 0 0 r
.50151 .90029 m .46181 .89708 L .44454 .89222 L F
.50151 .90029 m .50672 .90343 L .46181 .89708 L F
.138 0 0 r
.56044 .89958 m .50672 .90343 L .50151 .90029 L F
.56044 .89958 m .55326 .90287 L .50672 .90343 L F
0 0 0 r
.61668 .89013 m .55326 .90287 L .56044 .89958 L F
.21233 .51572 m .22264 .49498 L .23061 .45536 L F
.21233 .51572 m .20416 .55554 L .22264 .49498 L F
.69089 .85652 m .6656 .87253 L .61668 .89013 L F
.76209 .80063 m .73554 .82704 L .69089 .85652 L F
.405 .815 .613 r
.73554 .82704 m .6656 .87253 L .69089 .85652 L F
0 .043 .566 r
.2974 .80663 m .29338 .7972 L .26313 .76629 L F
.2974 .80663 m .32308 .83227 L .29338 .7972 L F
0 0 0 r
.26746 .38973 m .29438 .36659 L .31278 .33972 L F
.26746 .38973 m .24579 .42003 L .29438 .36659 L F
0 0 .383 r
.22505 .69389 m .22834 .68096 L .21196 .63926 L F
.22505 .69389 m .24025 .7315 L .22834 .68096 L F
0 .399 .703 r
.44454 .89222 m .42233 .88426 L .39413 .87586 L F
.44454 .89222 m .46181 .89708 L .42233 .88426 L F
0 0 .302 r
.80103 .41094 m .81598 .44596 L .83949 .50599 L F
.851 .548 .016 r
.81598 .44596 m .84769 .54579 L .83949 .50599 L F
0 g
.48616 .90102 m
.49201 .90135 L
s
.48472 .90089 m
.49193 .90134 L
s
.48328 .90076 m
.49193 .90134 L
s
0 0 0 r
.61668 .89013 m .59755 .89544 L .55326 .90287 L F
.289 .78 .726 r
.6656 .87253 m .59755 .89544 L .61668 .89013 L F
0 0 0 r
.8161 .72368 m .79281 .75926 L .76209 .80063 L F
.674 .923 .615 r
.79281 .75926 m .73554 .82704 L .76209 .80063 L F
0 .077 .575 r
.70794 .31339 m .73005 .3326 L .7797 .38121 L F
.723 .229 0 r
.73005 .3326 m .80103 .41094 L .7797 .38121 L F
0 g
.47088 .89921 m
.48616 .90102 L
s
.875 .877 .441 r
.83987 .63021 m .8161 .72368 L .83158 .68545 L F
.737 .702 .165 r
.84792 .58754 m .83987 .63021 L .83158 .68545 L F
0 0 0 r
.4172 .27702 m .47732 .26545 L .48442 .26021 L F
.4172 .27702 m .39889 .28503 L .47732 .26545 L F
0 g
.46945 .89898 m
.48472 .90089 L
s
.46803 .89875 m
.48328 .90076 L
s
.66764 .87134 m
.67045 .87013 L
s
.66717 .87154 m
.66764 .87134 L
s
.66767 .87132 m
.67117 .86979 L
s
.66719 .87153 m
.66767 .87132 L
s
.66768 .87131 m
.67188 .86945 L
s
.66718 .87154 m
.66768 .87131 L
s
0 .292 .666 r
.62528 .27335 m .64193 .28076 L .70794 .31339 L F
.321 0 0 r
.55668 .25893 m .64193 .28076 L .62528 .27335 L F
0 0 0 r
.33588 .31981 m .38312 .30104 L .39889 .28503 L F
.33588 .31981 m .31278 .33972 L .38312 .30104 L F
0 0 .236 r
.20416 .55554 m .22241 .53794 L .22264 .49498 L F
.20416 .55554 m .20393 .59707 L .22241 .53794 L F
0 g
.4558 .89632 m
.46275 .89765 L
s
.46275 .89765 m
.47088 .89921 L
s
.45439 .89599 m
.46275 .89765 L
s
.46275 .89765 m
.46945 .89898 L
s
.45299 .89565 m
.46283 .89768 L
s
.46283 .89768 m
.46803 .89875 L
s
.67045 .87013 m
.67323 .86869 L
s
.607 .037 0 r
.64193 .28076 m .73005 .3326 L .70794 .31339 L F
0 g
.67117 .86979 m
.67329 .86867 L
s
.67188 .86945 m
.67337 .86865 L
s
0 .452 .841 r
.39413 .87586 m .39184 .8659 L .35476 .85229 L F
.39413 .87586 m .42233 .88426 L .39184 .8659 L F
0 .043 .612 r
.24025 .7315 m .25291 .72098 L .22834 .68096 L F
.24025 .7315 m .26313 .76629 L .25291 .72098 L F
.211 0 0 r
.48442 .26021 m .56184 .26395 L .55668 .25893 L F
.48442 .26021 m .47732 .26545 L .56184 .26395 L F
.968 .722 .29 r
.82383 .48554 m .84792 .58754 L .84769 .54579 L F
.851 .548 .016 r
.81598 .44596 m .82383 .48554 L .84769 .54579 L F
0 .309 .79 r
.32308 .83227 m .33044 .82322 L .29338 .7972 L F
.32308 .83227 m .35476 .85229 L .33044 .82322 L F
.321 0 0 r
.55668 .25893 m .56184 .26395 L .64193 .28076 L F
0 0 .04 r
.24579 .42003 m .28144 .40003 L .29438 .36659 L F
.24579 .42003 m .23061 .45536 L .28144 .40003 L F
0 g
.44102 .89226 m
.45041 .89484 L
s
.45041 .89484 m
.4558 .89632 L
s
.289 .78 .726 r
.6656 .87253 m .63582 .88165 L .59755 .89544 L F
.569 .939 .858 r
.70282 .84795 m .63582 .88165 L .6656 .87253 L F
.405 .815 .613 r
.73554 .82704 m .70282 .84795 L .6656 .87253 L F
0 g
.67323 .86869 m
.67585 .86733 L
s
.67585 .86733 m
.67767 .8664 L
s
.67329 .86867 m
.67589 .8673 L
s
.67589 .8673 m
.67829 .86603 L
s
.67337 .86865 m
.67591 .86728 L
s
.67591 .86728 m
.67891 .86566 L
s
.43965 .89181 m
.45028 .89482 L
s
.45028 .89482 m
.45439 .89599 L
s
.45008 .8948 m
.45299 .89565 L
s
.67767 .8664 m
.68386 .86234 L
s
.17 .677 .904 r
.50672 .90343 m .48149 .89397 L .46181 .89708 L F
.50672 .90343 m .51267 .8984 L .48149 .89397 L F
.225 .733 .891 r
.55326 .90287 m .51267 .8984 L .50672 .90343 L F
0 g
.67829 .86603 m
.68439 .86194 L
s
.225 .733 .891 r
.55326 .90287 m .54505 .89801 L .51267 .8984 L F
.343 .814 .909 r
.59755 .89544 m .54505 .89801 L .55326 .90287 L F
0 g
.67891 .86566 m
.68491 .86153 L
s
.75 .993 .81 r
.76204 .79112 m .70282 .84795 L .73554 .82704 L F
.674 .923 .615 r
.79281 .75926 m .76204 .79112 L .73554 .82704 L F
.923 .96 .642 r
.82343 .67261 m .79281 .75926 L .8161 .72368 L F
.875 .877 .441 r
.83987 .63021 m .82343 .67261 L .8161 .72368 L F
.886 .457 .09 r
.74769 .35896 m .81598 .44596 L .80103 .41094 L F
.723 .229 0 r
.73005 .3326 m .74769 .35896 L .80103 .41094 L F
.184 .648 .938 r
.46181 .89708 m .45426 .88506 L .42233 .88426 L F
0 g
.42548 .8864 m
.43965 .89181 L
s
.42678 .88696 m
.44102 .89226 L
s
.43829 .89136 m
.45008 .8948 L
s
.184 .648 .938 r
.46181 .89708 m .48149 .89397 L .45426 .88506 L F
0 g
.42418 .88582 m
.43829 .89136 L
s
0 0 .456 r
.20393 .59707 m .23025 .58313 L .22241 .53794 L F
.20393 .59707 m .21196 .63926 L .23025 .58313 L F
0 g
.68386 .86234 m
.68894 .85788 L
s
.343 .814 .909 r
.59755 .89544 m .57579 .89283 L .54505 .89801 L F
.496 .894 .943 r
.63582 .88165 m .57579 .89283 L .59755 .89544 L F
0 g
.68439 .86194 m
.68935 .85744 L
s
.68491 .86153 m
.68976 .85699 L
s
.249 0 0 r
.39889 .28503 m .47119 .27919 L .47732 .26545 L F
.39889 .28503 m .38312 .30104 L .47119 .27919 L F
.126 0 .023 r
.31278 .33972 m .37051 .3251 L .38312 .30104 L F
.31278 .33972 m .29438 .36659 L .37051 .3251 L F
.001 .255 .761 r
.26313 .76629 m .28518 .75808 L .25291 .72098 L F
.26313 .76629 m .29338 .7972 L .28518 .75808 L F
0 g
.41933 .88333 m
.4212 .88424 L
s
.4212 .88424 m
.42678 .88696 L
s
.41933 .88334 m
.42136 .88434 L
s
.42136 .88434 m
.42548 .8864 L
s
1 .814 .485 r
.82405 .52873 m .83987 .63021 L .84792 .58754 L F
.968 .722 .29 r
.82383 .48554 m .82405 .52873 L .84792 .58754 L F
0 g
.41926 .88331 m
.42169 .88455 L
s
.42169 .88455 m
.42418 .88582 L
s
.607 .037 0 r
.64193 .28076 m .65628 .29628 L .73005 .3326 L F
.581 .036 0 r
.56184 .26395 m .65628 .29628 L .64193 .28076 L F
0 g
.68894 .85788 m
.69034 .85608 L
s
.054 0 .285 r
.23061 .45536 m .27463 .43937 L .28144 .40003 L F
.23061 .45536 m .22264 .49498 L .27463 .43937 L F
.148 .502 .909 r
.35476 .85229 m .37347 .84343 L .33044 .82322 L F
.35476 .85229 m .39184 .8659 L .37347 .84343 L F
.777 .286 .055 r
.65628 .29628 m .74769 .35896 L .73005 .3326 L F
0 g
.68935 .85744 m
.69039 .85604 L
s
.68976 .85699 m
.69047 .85599 L
s
.252 .635 .961 r
.42233 .88426 m .43352 .8724 L .39184 .8659 L F
0 g
.41077 .87898 m
.41538 .88134 L
s
.41538 .88134 m
.41926 .88331 L
s
.41199 .87968 m
.41559 .88147 L
s
.41559 .88147 m
.41933 .88334 L
s
.41322 .88037 m
.41585 .88165 L
s
.41585 .88165 m
.41933 .88333 L
s
.252 .635 .961 r
.42233 .88426 m .45426 .88506 L .43352 .8724 L F
.914 .978 .771 r
.79882 .71352 m .76204 .79112 L .79281 .75926 L F
.923 .96 .642 r
.82343 .67261 m .79882 .71352 L .79281 .75926 L F
.569 .939 .858 r
.70282 .84795 m .66456 .86253 L .63582 .88165 L F
.758 .981 .912 r
.72439 .8182 m .66456 .86253 L .70282 .84795 L F
0 g
.69154 .85453 m
.69278 .85294 L
s
.69034 .85608 m
.69154 .85453 L
s
.69154 .8545 m
.69307 .85245 L
s
.69039 .85604 m
.69154 .8545 L
s
.69155 .85448 m
.69335 .85195 L
s
.69047 .85599 m
.69155 .85448 L
s
.75 .993 .81 r
.76204 .79112 m .72439 .8182 L .70282 .84795 L F
0 g
.40058 .8725 m
.41322 .88037 L
s
.496 .894 .943 r
.63582 .88165 m .60213 .88326 L .57579 .89283 L F
.638 .938 .963 r
.66456 .86253 m .60213 .88326 L .63582 .88165 L F
0 g
.39945 .8717 m
.41199 .87968 L
s
.39832 .87089 m
.41077 .87898 L
s
.063 .115 .606 r
.21196 .63926 m .24619 .62924 L .23025 .58313 L F
.21196 .63926 m .22834 .68096 L .24619 .62924 L F
.943 .592 .316 r
.76009 .39211 m .82383 .48554 L .81598 .44596 L F
.886 .457 .09 r
.74769 .35896 m .76009 .39211 L .81598 .44596 L F
.46 0 0 r
.47732 .26545 m .56629 .27752 L .56184 .26395 L F
.47732 .26545 m .47119 .27919 L .56629 .27752 L F
0 g
.69278 .85294 m
.69423 .84973 L
s
.69423 .84973 m
.69526 .84744 L
s
.581 .036 0 r
.56184 .26395 m .56629 .27752 L .65628 .29628 L F
0 g
.69307 .85245 m
.69422 .84974 L
s
.69422 .84974 m
.69542 .84689 L
s
.69335 .85195 m
.69423 .84973 L
s
.69423 .84973 m
.69557 .84634 L
s
.18 .413 .851 r
.29338 .7972 m .32442 .79105 L .28518 .75808 L F
.29338 .7972 m .33044 .82322 L .32442 .79105 L F
.442 .784 .998 r
.51267 .8984 m .50315 .88247 L .48149 .89397 L F
.51267 .8984 m .51925 .88478 L .50315 .88247 L F
.474 .818 .998 r
.54505 .89801 m .51925 .88478 L .51267 .8984 L F
.54505 .89801 m .53599 .88458 L .51925 .88478 L F
.528 .851 .998 r
.57579 .89283 m .53599 .88458 L .54505 .89801 L F
0 g
.39343 .86688 m
.40058 .8725 L
s
.39333 .8668 m
.39343 .86688 L
s
.988 .857 .618 r
.81633 .57439 m .82343 .67261 L .83987 .63021 L F
1 .814 .485 r
.82405 .52873 m .81633 .57439 L .83987 .63021 L F
0 g
.39354 .86695 m
.39945 .8717 L
s
.39343 .86686 m
.39354 .86695 L
s
.3935 .86692 m
.39832 .87089 L
s
.39341 .86685 m
.3935 .86692 L
s
.435 .753 .994 r
.48149 .89397 m .48921 .87785 L .45426 .88506 L F
.48149 .89397 m .50315 .88247 L .48921 .87785 L F
.877 .963 .85 r
.7665 .75166 m .72439 .8182 L .76204 .79112 L F
.914 .978 .771 r
.79882 .71352 m .7665 .75166 L .76204 .79112 L F
.528 .851 .998 r
.57579 .89283 m .55183 .88188 L .53599 .88458 L F
.591 .874 .993 r
.60213 .88326 m .55183 .88188 L .57579 .89283 L F
.283 0 .258 r
.29438 .36659 m .36162 .35694 L .37051 .3251 L F
.29438 .36659 m .28144 .40003 L .36162 .35694 L F
.192 .053 .451 r
.22264 .49498 m .27444 .48366 L .27463 .43937 L F
.22264 .49498 m .22241 .53794 L .27444 .48366 L F
.341 .627 .958 r
.39184 .8659 m .42138 .85705 L .37347 .84343 L F
0 g
.38695 .86154 m
.39087 .86476 L
s
.39087 .86476 m
.39093 .86481 L
s
.38797 .86247 m
.39104 .86494 L
s
.39104 .86494 m
.39107 .86496 L
s
.39124 .86516 m
.39125 .86516 L
s
.389 .86339 m
.39124 .86516 L
s
.341 .627 .958 r
.39184 .8659 m .43352 .8724 L .42138 .85705 L F
.193 .263 .707 r
.22834 .68096 m .26998 .67486 L .24619 .62924 L F
.22834 .68096 m .25291 .72098 L .26998 .67486 L F
.413 .01 .163 r
.38312 .30104 m .46628 .30159 L .47119 .27919 L F
.38312 .30104 m .37051 .3251 L .46628 .30159 L F
0 g
.37867 .85312 m
.389 .86339 L
s
.638 .938 .963 r
.66456 .86253 m .62162 .87009 L .60213 .88326 L F
.732 .933 .955 r
.68074 .83958 m .62162 .87009 L .66456 .86253 L F
.758 .981 .912 r
.72439 .8182 m .68074 .83958 L .66456 .86253 L F
0 g
.69557 .84634 m
.6963 .84009 L
s
.69542 .84689 m
.6963 .84071 L
s
.69526 .84744 m
.69628 .84132 L
s
.37778 .8521 m
.38797 .86247 L
s
.84 .436 .277 r
.66776 .31999 m .76009 .39211 L .74769 .35896 L F
.777 .286 .055 r
.65628 .29628 m .66776 .31999 L .74769 .35896 L F
0 g
.37689 .85108 m
.38695 .86154 L
s
.698 .245 .174 r
.56629 .27752 m .66776 .31999 L .65628 .29628 L F
.45 .727 .985 r
.45426 .88506 m .47875 .87132 L .43352 .8724 L F
.45426 .88506 m .48921 .87785 L .47875 .87132 L F
.951 .669 .466 r
.76663 .4314 m .82405 .52873 L .82383 .48554 L F
.943 .592 .316 r
.76009 .39211 m .76663 .4314 L .82383 .48554 L F
.591 .874 .993 r
.60213 .88326 m .5653 .87692 L .55183 .88188 L F
.649 .882 .983 r
.62162 .87009 m .5653 .87692 L .60213 .88326 L F
.318 .531 .903 r
.33044 .82322 m .36955 .81881 L .32442 .79105 L F
.33044 .82322 m .37347 .84343 L .36955 .81881 L F
.958 .873 .71 r
.80064 .6212 m .79882 .71352 L .82343 .67261 L F
.988 .857 .618 r
.81633 .57439 m .80064 .6212 L .82343 .67261 L F
0 g
.37318 .84616 m
.37867 .85312 L
s
.36975 .84182 m
.3709 .84327 L
s
.3709 .84327 m
.37318 .84616 L
s
.37326 .84624 m
.37778 .8521 L
s
.3708 .84305 m
.37326 .84624 L
s
.829 .933 .899 r
.72727 .7858 m .68074 .83958 L .72439 .8182 L F
0 g
.69543 .83313 m
.69584 .83646 L
s
.69584 .83646 m
.6963 .84009 L
s
.69558 .83382 m
.69586 .83649 L
s
.69586 .83649 m
.6963 .84071 L
s
.69572 .83449 m
.69589 .83656 L
s
.69589 .83656 m
.69628 .84132 L
s
.877 .963 .85 r
.7665 .75166 m .72727 .7858 L .72439 .8182 L F
0 g
.37322 .84621 m
.37689 .85108 L
s
.37071 .84287 m
.37322 .84621 L
s
.36823 .83959 m
.36865 .84014 L
s
.293 .377 .778 r
.25291 .72098 m .30104 .71853 L .26998 .67486 L F
.25291 .72098 m .28518 .75808 L .30104 .71853 L F
.289 .189 .563 r
.22241 .53794 m .28113 .53168 L .27444 .48366 L F
.22241 .53794 m .23025 .58313 L .28113 .53168 L F
.58 .157 .203 r
.47119 .27919 m .56987 .29979 L .56629 .27752 L F
.47119 .27919 m .46628 .30159 L .56987 .29979 L F
.48 .707 .969 r
.43352 .8724 m .47282 .8635 L .42138 .85705 L F
.43352 .8724 m .47875 .87132 L .47282 .8635 L F
.698 .245 .174 r
.56629 .27752 m .56987 .29979 L .66776 .31999 L F
.649 .882 .983 r
.62162 .87009 m .5751 .87014 L .5653 .87692 L F
.693 .874 .966 r
.63223 .85443 m .5751 .87014 L .62162 .87009 L F
.732 .933 .955 r
.68074 .83958 m .63223 .85443 L .62162 .87009 L F
0 g
.36234 .82964 m
.36889 .8404 L
s
.379 .133 .41 r
.28144 .40003 m .35693 .396 L .36162 .35694 L F
.28144 .40003 m .27463 .43937 L .35693 .396 L F
.625 .78 .955 r
.56441 .83889 m .51925 .88478 L .53599 .88458 L F
.56441 .83889 m .50315 .88247 L .51925 .88478 L F
.56441 .83889 m .53599 .88458 L .55183 .88188 L F
.427 .621 .933 r
.37347 .84343 m .41927 .84041 L .36955 .81881 L F
0 g
.36889 .8404 m
.36975 .84182 L
s
.36865 .84014 m
.37071 .84287 L
s
.36899 .84071 m
.3708 .84305 L
s
.427 .621 .933 r
.37347 .84343 m .42138 .85705 L .41927 .84041 L F
0 g
.36173 .82846 m
.36899 .84071 L
s
.36113 .82728 m
.36823 .83959 L
s
.92 .876 .776 r
.77723 .66772 m .7665 .75166 L .79882 .71352 L F
.958 .873 .71 r
.80064 .6212 m .77723 .66772 L .79882 .71352 L F
.625 .78 .955 r
.56441 .83889 m .48921 .87785 L .50315 .88247 L F
.94 .715 .57 r
.76681 .47588 m .81633 .57439 L .82405 .52873 L F
.951 .669 .466 r
.76663 .4314 m .76681 .47588 L .82405 .52873 L F
.625 .78 .955 r
.56441 .83889 m .55183 .88188 L .5653 .87692 L F
.775 .895 .928 r
.68221 .81482 m .63223 .85443 L .68074 .83958 L F
.829 .933 .899 r
.72727 .7858 m .68221 .81482 L .68074 .83958 L F
0 g
.69287 .82545 m
.69454 .83046 L
s
.69454 .83046 m
.69543 .83313 L
s
.69319 .82621 m
.69453 .83049 L
s
.69453 .83049 m
.69558 .83382 L
s
.69349 .82696 m
.69453 .8305 L
s
.69453 .8305 m
.69572 .83449 L
s
.858 .525 .42 r
.67586 .35163 m .76663 .4314 L .76009 .39211 L F
.84 .436 .277 r
.66776 .31999 m .67586 .35163 L .76009 .39211 L F
.501 .171 .339 r
.37051 .3251 m .46281 .33249 L .46628 .30159 L F
.37051 .3251 m .36162 .35694 L .46281 .33249 L F
.625 .78 .955 r
.56441 .83889 m .47875 .87132 L .48921 .87785 L F
.374 .471 .831 r
.28518 .75808 m .33851 .75881 L .30104 .71853 L F
.28518 .75808 m .32442 .79105 L .33851 .75881 L F
.625 .78 .955 r
.56441 .83889 m .5653 .87692 L .5751 .87014 L F
0 g
.68951 .81867 m
.69349 .82696 L
s
.68904 .81785 m
.69319 .82621 L
s
.745 .371 .345 r
.56987 .29979 m .67586 .35163 L .66776 .31999 L F
.36 .293 .645 r
.23025 .58313 m .29472 .58199 L .28113 .53168 L F
.23025 .58313 m .24619 .62924 L .29472 .58199 L F
0 g
.68855 .81701 m
.69287 .82545 L
s
.515 .693 .949 r
.42138 .85705 m .47207 .8551 L .41927 .84041 L F
.42138 .85705 m .47282 .8635 L .47207 .8551 L F
.878 .871 .826 r
.74669 .71243 m .72727 .7858 L .7665 .75166 L F
.92 .876 .776 r
.77723 .66772 m .74669 .71243 L .7665 .75166 L F
.625 .78 .955 r
.56441 .83889 m .47282 .8635 L .47875 .87132 L F
.56441 .83889 m .5751 .87014 L .58023 .86217 L F
.693 .874 .966 r
.63223 .85443 m .58023 .86217 L .5751 .87014 L F
.718 .852 .946 r
.63265 .83772 m .58023 .86217 L .63223 .85443 L F
.775 .895 .928 r
.68221 .81482 m .63265 .83772 L .63223 .85443 L F
.441 .55 .871 r
.32442 .79105 m .38121 .79438 L .33851 .75881 L F
.32442 .79105 m .36955 .81881 L .38121 .79438 L F
0 g
.35565 .81432 m
.35631 .81588 L
s
.35631 .81588 m
.36113 .82728 L
s
.35609 .81556 m
.35634 .81613 L
s
.35634 .81613 m
.36173 .82846 L
s
.35655 .8168 m
.36234 .82964 L
s
.35242 .80348 m
.35634 .81612 L
s
.35634 .81612 m
.35655 .8168 L
s
.92 .743 .646 r
.76039 .52432 m .80064 .6212 L .81633 .57439 L F
.94 .715 .57 r
.76681 .47588 m .76039 .52432 L .81633 .57439 L F
0 g
.35262 .80389 m
.35609 .81556 L
s
.35212 .80222 m
.35262 .80389 L
s
.35276 .80418 m
.35565 .81432 L
s
.35184 .80096 m
.35276 .80418 L
s
.442 .243 .513 r
.27463 .43937 m .35679 .44132 L .35693 .396 L F
.27463 .43937 m .27444 .48366 L .35679 .44132 L F
.625 .78 .955 r
.56441 .83889 m .47207 .8551 L .47282 .8635 L F
.833 .86 .865 r
.70991 .75387 m .68221 .81482 L .72727 .7858 L F
0 g
.68614 .8134 m
.68904 .81785 L
s
.68617 .81344 m
.68951 .81867 L
s
.878 .871 .826 r
.74669 .71243 m .70991 .75387 L .72727 .7858 L F
0 g
.68618 .81345 m
.68855 .81701 L
s
.625 .78 .955 r
.56441 .83889 m .58023 .86217 L .58013 .85376 L F
.718 .852 .946 r
.63265 .83772 m .58013 .85376 L .58023 .86217 L F
.638 .288 .361 r
.46628 .30159 m .57239 .33062 L .56987 .29979 L F
.46628 .30159 m .46281 .33249 L .57239 .33062 L F
.499 .621 .902 r
.36955 .81881 m .42776 .82406 L .38121 .79438 L F
.36955 .81881 m .41927 .84041 L .42776 .82406 L F
.745 .371 .345 r
.56987 .29979 m .57239 .33062 L .67586 .35163 L F
.415 .376 .707 r
.24619 .62924 m .31491 .63294 L .29472 .58199 L F
.24619 .62924 m .26998 .67486 L .31491 .63294 L F
.859 .582 .518 r
.68013 .39064 m .76681 .47588 L .76663 .4314 L F
.858 .525 .42 r
.67586 .35163 m .68013 .39064 L .76663 .4314 L F
0 g
.34999 .78996 m
.35242 .80348 L
s
.34985 .78868 m
.35212 .80222 L
s
.784 .845 .898 r
.66805 .79065 m .63265 .83772 L .68221 .81482 L F
.833 .86 .865 r
.70991 .75387 m .66805 .79065 L .68221 .81482 L F
0 g
.68246 .80787 m
.68533 .81218 L
s
.68533 .81218 m
.68618 .81345 L
s
.68525 .812 m
.68617 .81344 L
s
.68377 .80968 m
.68525 .812 L
s
.6853 .81212 m
.68614 .8134 L
s
.68314 .8088 m
.6853 .81212 L
s
.34972 .78741 m
.35184 .80096 L
s
.552 .686 .928 r
.41927 .84041 m .47665 .84695 L .42776 .82406 L F
.41927 .84041 m .47207 .8551 L .47665 .84695 L F
.625 .78 .955 r
.56441 .83889 m .47665 .84695 L .47207 .8551 L F
.56441 .83889 m .58013 .85376 L .5747 .84573 L F
.728 .824 .925 r
.62248 .82159 m .58013 .85376 L .63265 .83772 L F
.62248 .82159 m .5747 .84573 L .58013 .85376 L F
.784 .845 .898 r
.66805 .79065 m .62248 .82159 L .63265 .83772 L F
.551 .277 .453 r
.36162 .35694 m .46098 .37136 L .46281 .33249 L F
.36162 .35694 m .35693 .396 L .46098 .37136 L F
0 g
.67624 .8 m
.68377 .80968 L
s
.897 .762 .705 r
.74737 .57524 m .77723 .66772 L .80064 .6212 L F
.92 .743 .646 r
.76039 .52432 m .74737 .57524 L .80064 .6212 L F
0 g
.67544 .79906 m
.68314 .8088 L
s
.764 .451 .457 r
.57239 .33062 m .68013 .39064 L .67586 .35163 L F
0 g
.34924 .77642 m
.34999 .78996 L
s
.459 .447 .757 r
.26998 .67486 m .34113 .68283 L .31491 .63294 L F
.26998 .67486 m .30104 .71853 L .34113 .68283 L F
0 g
.34926 .77516 m
.34985 .78868 L
s
.34929 .77391 m
.34972 .78741 L
s
.625 .78 .955 r
.56441 .83889 m .48621 .83988 L .47665 .84695 L F
.587 .685 .909 r
.42776 .82406 m .47665 .84695 L .48621 .83988 L F
.485 .325 .588 r
.27444 .48366 m .3614 .49161 L .35679 .44132 L F
.27444 .48366 m .28113 .53168 L .3614 .49161 L F
.725 .794 .907 r
.6024 .80771 m .5747 .84573 L .62248 .82159 L F
.6024 .80771 m .56441 .83889 L .5747 .84573 L F
0 g
.66844 .79137 m
.67624 .8 L
s
.66839 .79132 m
.66844 .79137 L
s
.871 .776 .754 r
.72802 .62697 m .74669 .71243 L .77723 .66772 L F
.897 .762 .705 r
.74737 .57524 m .72802 .62697 L .77723 .66772 L F
0 g
.66874 .79173 m
.67544 .79906 L
s
.66869 .79168 m
.66874 .79173 L
s
.496 .51 .801 r
.30104 .71853 m .37252 .72995 L .34113 .68283 L F
.30104 .71853 m .33851 .75881 L .37252 .72995 L F
.587 .685 .909 r
.42776 .82406 m .48621 .83988 L .44635 .80972 L F
.559 .627 .875 r
.38121 .79438 m .42776 .82406 L .44635 .80972 L F
.852 .623 .59 r
.68025 .43609 m .76039 .52432 L .76681 .47588 L F
.859 .582 .518 r
.68013 .39064 m .68025 .43609 L .76681 .47588 L F
.625 .78 .955 r
.56441 .83889 m .49985 .83461 L .48621 .83988 L F
.62 .691 .895 r
.44635 .80972 m .48621 .83988 L .49985 .83461 L F
.625 .78 .955 r
.56441 .83889 m .5162 .83171 L .49985 .83461 L F
.56441 .83889 m .5336 .83149 L .5162 .83171 L F
.56441 .83889 m .55024 .83397 L .5336 .83149 L F
.714 .766 .893 r
.57427 .79763 m .56441 .83889 L .6024 .80771 L F
.57427 .79763 m .55024 .83397 L .56441 .83889 L F
.772 .795 .871 r
.63898 .76966 m .62248 .82159 L .66805 .79065 L F
.63898 .76966 m .6024 .80771 L .62248 .82159 L F
.529 .569 .839 r
.33851 .75881 m .40801 .77271 L .37252 .72995 L F
.33851 .75881 m .38121 .79438 L .40801 .77271 L F
0 g
.34924 .77642 m
.35015 .76315 L
s
.34926 .77516 m
.3502 .76336 L
s
.3502 .76336 m
.35031 .76192 L
s
.34929 .77391 m
.35023 .76359 L
s
.35023 .76359 m
.3505 .76069 L
s
.559 .627 .875 r
.38121 .79438 m .44635 .80972 L .40801 .77271 L F
.842 .785 .796 r
.70291 .67777 m .70991 .75387 L .74669 .71243 L F
.871 .776 .754 r
.72802 .62697 m .70291 .67777 L .74669 .71243 L F
.667 .373 .465 r
.46281 .33249 m .57372 .36947 L .57239 .33062 L F
.46281 .33249 m .46098 .37136 L .57372 .36947 L F
.649 .702 .886 r
.47335 .79894 m .49985 .83461 L .5162 .83171 L F
.62 .691 .895 r
.44635 .80972 m .49985 .83461 L .47335 .79894 L F
.764 .451 .457 r
.57239 .33062 m .57372 .36947 L .68013 .39064 L F
.697 .74 .885 r
.54097 .79251 m .55024 .83397 L .57427 .79763 L F
.54097 .79251 m .5336 .83149 L .55024 .83397 L F
0 g
.3508 .75979 m
.35265 .75031 L
s
.35015 .76315 m
.3508 .75979 L
s
.66786 .79068 m
.66793 .79075 L
s
.81 .792 .835 r
.67289 .72587 m .66805 .79065 L .70991 .75387 L F
.67289 .72587 m .63898 .76966 L .66805 .79065 L F
0 g
.65718 .78009 m
.66781 .79063 L
s
.66781 .79063 m
.66786 .79068 L
s
.66699 .78977 m
.66757 .79041 L
s
.66757 .79041 m
.66764 .79049 L
s
.66604 .78878 m
.66729 .79015 L
s
.66729 .79015 m
.66733 .79019 L
s
.3507 .76004 m
.35297 .74914 L
s
.35031 .76192 m
.3507 .76004 L
s
.842 .785 .796 r
.70291 .67777 m .67289 .72587 L .70991 .75387 L F
0 g
.65609 .77907 m
.66699 .78977 L
s
.35056 .7604 m
.35329 .74797 L
s
.3505 .76069 m
.35056 .7604 L
s
.674 .719 .883 r
.50606 .79297 m .5162 .83171 L .5336 .83149 L F
.649 .702 .886 r
.47335 .79894 m .5162 .83171 L .50606 .79297 L F
.674 .719 .883 r
.50606 .79297 m .5336 .83149 L .54097 .79251 L F
.583 .354 .534 r
.35693 .396 m .46092 .41726 L .46098 .37136 L F
.35693 .396 m .35679 .44132 L .46092 .41726 L F
0 g
.65498 .77804 m
.66604 .78878 L
s
.517 .391 .647 r
.28113 .53168 m .37074 .5453 L .3614 .49161 L F
.28113 .53168 m .29472 .58199 L .37074 .5453 L F
.771 .507 .536 r
.57372 .36947 m .68025 .43609 L .68013 .39064 L F
0 g
.35265 .75031 m
.35668 .73815 L
s
.609 .639 .855 r
.40801 .77271 m .44635 .80972 L .47335 .79894 L F
0 g
.35297 .74914 m
.35714 .73705 L
s
.842 .653 .647 r
.67605 .48667 m .74737 .57524 L .76039 .52432 L F
.852 .623 .59 r
.68025 .43609 m .67605 .48667 L .76039 .52432 L F
0 g
.35329 .74797 m
.3576 .73595 L
s
.75 .751 .853 r
.59758 .75429 m .6024 .80771 L .63898 .76966 L F
.59758 .75429 m .57427 .79763 L .6024 .80771 L F
0 g
.6449 .76912 m
.65718 .78009 L
s
.64562 .76981 m
.65609 .77907 L
s
.64368 .76809 m
.64562 .76981 L
s
.64608 .77024 m
.65498 .77804 L
s
.543 .447 .696 r
.29472 .58199 m .38457 .60054 L .37074 .5453 L F
.29472 .58199 m .31491 .63294 L .38457 .60054 L F
0 g
.35668 .73815 m
.36168 .72783 L
s
.36168 .72783 m
.36217 .72681 L
s
.35714 .73705 m
.36163 .72805 L
s
.36163 .72805 m
.36276 .72579 L
s
.3576 .73595 m
.3616 .72819 L
s
.3616 .72819 m
.36336 .72479 L
s
.609 .639 .855 r
.40801 .77271 m .47335 .79894 L .44768 .75629 L F
.596 .591 .817 r
.37252 .72995 m .40801 .77271 L .44768 .75629 L F
.652 .658 .843 r
.44768 .75629 m .47335 .79894 L .50606 .79297 L F
.722 .713 .842 r
.54813 .74645 m .57427 .79763 L .59758 .75429 L F
.54813 .74645 m .54097 .79251 L .57427 .79763 L F
.829 .677 .694 r
.66755 .54078 m .72802 .62697 L .74737 .57524 L F
.842 .653 .647 r
.67605 .48667 m .66755 .54078 L .74737 .57524 L F
.777 .735 .814 r
.61931 .70522 m .63898 .76966 L .67289 .72587 L F
0 g
.64023 .7653 m
.64356 .76799 L
s
.64356 .76799 m
.64368 .76809 L
s
.6404 .76546 m
.64301 .76758 L
s
.64301 .76758 m
.6449 .76912 L
s
.64245 .76705 m
.64329 .76779 L
s
.64329 .76779 m
.64608 .77024 L
s
.777 .735 .814 r
.61931 .70522 m .59758 .75429 L .63898 .76966 L F
0 g
.63128 .75803 m
.6315 .75822 L
s
.6315 .75822 m
.6404 .76546 L
s
.62993 .75699 m
.63006 .75709 L
s
.63006 .75709 m
.64023 .7653 L
s
.64 .76509 m
.64245 .76705 L
s
.62857 .75594 m
.64 .76509 L
s
.604 .412 .595 r
.35679 .44132 m .46272 .46887 L .46092 .41726 L F
.35679 .44132 m .3614 .49161 L .46272 .46887 L F
.684 .435 .54 r
.46098 .37136 m .57376 .41542 L .57372 .36947 L F
.46098 .37136 m .46092 .41726 L .57376 .41542 L F
.563 .497 .739 r
.31491 .63294 m .40246 .65539 L .38457 .60054 L F
.31491 .63294 m .34113 .68283 L .40246 .65539 L F
.771 .507 .536 r
.57372 .36947 m .57376 .41542 L .68025 .43609 L F
.596 .591 .817 r
.37252 .72995 m .44768 .75629 L .42376 .70792 L F
.581 .544 .778 r
.34113 .68283 m .37252 .72995 L .42376 .70792 L F
0 g
.36912 .71657 m
.37045 .71466 L
s
.36351 .72457 m
.36912 .71657 L
s
.36336 .72479 m
.36351 .72457 L
s
.36921 .71633 m
.36973 .71557 L
s
.36369 .72443 m
.36921 .71633 L
s
.36276 .72579 m
.36369 .72443 L
s
.36382 .72432 m
.36902 .71648 L
s
.36217 .72681 m
.36382 .72432 L
s
.689 .682 .839 r
.49619 .74714 m .50606 .79297 L .54097 .79251 L F
.652 .658 .843 r
.44768 .75629 m .50606 .79297 L .49619 .74714 L F
.689 .682 .839 r
.49619 .74714 m .54097 .79251 L .54813 .74645 L F
.581 .544 .778 r
.34113 .68283 m .42376 .70792 L .40246 .65539 L F
.772 .548 .596 r
.57376 .41542 m .67605 .48667 L .68025 .43609 L F
0 g
.36902 .71648 m
.37716 .70728 L
s
.815 .698 .736 r
.65495 .59656 m .70291 .67777 L .72802 .62697 L F
.829 .677 .694 r
.66755 .54078 m .65495 .59656 L .72802 .62697 L F
0 g
.36973 .71557 m
.37799 .70647 L
s
.798 .717 .776 r
.63868 .65203 m .67289 .72587 L .70291 .67777 L F
.63868 .65203 m .61931 .70522 L .67289 .72587 L F
0 g
.63103 .75785 m
.63128 .75803 L
s
.61647 .747 m
.63103 .75785 L
s
.37045 .71466 m
.37883 .70568 L
s
.62983 .75691 m
.62993 .75699 L
s
.815 .698 .736 r
.65495 .59656 m .63868 .65203 L .70291 .67777 L F
0 g
.37716 .70728 m
.3865 .69932 L
s
.37799 .70647 m
.38744 .69864 L
s
.37883 .70568 m
.38838 .69797 L
s
.65 .617 .803 r
.42376 .70792 m .44768 .75629 L .49619 .74714 L F
.739 .688 .802 r
.55484 .69464 m .59758 .75429 L .61931 .70522 L F
0 g
.60074 .73625 m
.61069 .74305 L
s
.61069 .74305 m
.61647 .747 L
s
.61359 .74496 m
.62857 .75594 L
s
.61503 .74597 m
.62983 .75691 L
s
.739 .688 .802 r
.55484 .69464 m .54813 .74645 L .59758 .75429 L F
0 g
.59922 .73526 m
.61088 .74316 L
s
.61088 .74316 m
.61503 .74597 L
s
.619 .461 .645 r
.3614 .49161 m .46637 .52451 L .46272 .46887 L F
.3614 .49161 m .37074 .5453 L .46637 .52451 L F
0 g
.59769 .73427 m
.61119 .74335 L
s
.61119 .74335 m
.61359 .74496 L
s
.3865 .69932 m
.39697 .69269 L
s
.38744 .69864 m
.39801 .69214 L
s
.38838 .69797 m
.39906 .6916 L
s
.77 .582 .645 r
.57245 .46713 m .66755 .54078 L .67605 .48667 L F
.772 .548 .596 r
.57376 .41542 m .57245 .46713 L .67605 .48667 L F
.693 .482 .597 r
.46092 .41726 m .57245 .46713 L .57376 .41542 L F
.46092 .41726 m .46272 .46887 L .57245 .46713 L F
0 g
.59714 .73401 m
.60074 .73625 L
s
.58426 .72597 m
.59714 .73401 L
s
.59691 .73383 m
.59922 .73526 L
s
.58269 .72503 m
.59691 .73383 L
s
.59664 .73363 m
.59769 .73427 L
s
.58111 .72411 m
.59664 .73363 L
s
.697 .649 .798 r
.48695 .69558 m .49619 .74714 L .54813 .74645 L F
.65 .617 .803 r
.42376 .70792 m .49619 .74714 L .48695 .69558 L F
.697 .649 .798 r
.48695 .69558 m .54813 .74645 L .55484 .69464 L F
.646 .579 .765 r
.40246 .65539 m .42376 .70792 L .48695 .69558 L F
0 g
.40667 .68839 m
.41077 .68665 L
s
.39906 .6916 m
.40667 .68839 L
s
.40659 .68839 m
.40963 .68705 L
s
.39801 .69214 m
.40659 .68839 L
s
.40648 .68839 m
.4085 .68747 L
s
.39697 .69269 m
.40648 .68839 L
s
.631 .503 .688 r
.37074 .5453 m .47176 .58224 L .46637 .52451 L F
.37074 .5453 m .38457 .60054 L .47176 .58224 L F
0 g
.4085 .68747 m
.42101 .6837 L
s
.40963 .68705 m
.42223 .68343 L
s
.41077 .68665 m
.42247 .68343 L
s
.42247 .68343 m
.42346 .68316 L
s
.56733 .71638 m
.58426 .72597 L
s
.75 .663 .764 r
.56083 .63878 m .61931 .70522 L .63868 .65203 L F
.56083 .63878 m .55484 .69464 L .61931 .70522 L F
0 g
.56572 .71552 m
.58269 .72503 L
s
.56411 .71466 m
.58111 .72411 L
s
.42101 .6837 m
.42243 .68346 L
s
.765 .611 .687 r
.5698 .52292 m .65495 .59656 L .66755 .54078 L F
.77 .582 .645 r
.57245 .46713 m .5698 .52292 L .66755 .54078 L F
0 g
.42223 .68343 m
.42255 .68338 L
s
.646 .579 .765 r
.40246 .65539 m .48695 .69558 L .4787 .63996 L F
0 g
.42346 .68316 m
.43705 .68116 L
s
.42255 .68338 m
.43574 .68129 L
s
.42243 .68346 m
.43444 .68142 L
s
.639 .542 .728 r
.38457 .60054 m .40246 .65539 L .4787 .63996 L F
.38457 .60054 m .4787 .63996 L .47176 .58224 L F
0 g
.55011 .70763 m
.56197 .71366 L
s
.56197 .71366 m
.56733 .71638 L
s
.54848 .70686 m
.56226 .71378 L
s
.56226 .71378 m
.56572 .71552 L
s
.54686 .7061 m
.56271 .71397 L
s
.56271 .71397 m
.56411 .71466 L
s
.43444 .68142 m
.4487 .68065 L
s
.43574 .68129 m
.45008 .68065 L
s
.43705 .68116 m
.45147 .68067 L
s
.759 .638 .726 r
.56588 .58084 m .63868 .65203 L .65495 .59656 L F
.56588 .58084 m .56083 .63878 L .63868 .65203 L F
.765 .611 .687 r
.5698 .52292 m .56588 .58084 L .65495 .59656 L F
0 g
.54606 .70582 m
.55011 .70763 L
s
.53286 .69992 m
.54606 .70582 L
s
.699 .521 .644 r
.46272 .46887 m .5698 .52292 L .57245 .46713 L F
.46272 .46887 m .46637 .52451 L .5698 .52292 L F
0 g
.54587 .70571 m
.54848 .70686 L
s
.53124 .69925 m
.54587 .70571 L
s
.52962 .69859 m
.54686 .7061 L
s
.4487 .68065 m
.46374 .68138 L
s
.45008 .68065 m
.46519 .68152 L
s
.45147 .68067 m
.46665 .68168 L
s
.701 .618 .761 r
.4787 .63996 m .48695 .69558 L .55484 .69464 L F
0 g
.46374 .68138 m
.47798 .68338 L
s
.46519 .68152 m
.4782 .68346 L
s
.701 .618 .761 r
.4787 .63996 m .55484 .69464 L .56083 .63878 L F
0 g
.4782 .68346 m
.48096 .68387 L
s
.51252 .69227 m
.52962 .69859 L
s
.47798 .68338 m
.47945 .68359 L
s
.51411 .69281 m
.53124 .69925 L
s
.51571 .69336 m
.53286 .69992 L
s
.47838 .68352 m
.48248 .68416 L
s
.46665 .68168 m
.47838 .68352 L
s
.49888 .68808 m
.51571 .69336 L
s
.47945 .68359 m
.49043 .68604 L
s
.49043 .68604 m
.49576 .68724 L
s
.49732 .68765 m
.51411 .69281 L
s
.48096 .68387 m
.49035 .68604 L
s
.49035 .68604 m
.49732 .68765 L
s
.49576 .68724 m
.51252 .69227 L
s
.48248 .68416 m
.49032 .68604 L
s
.49032 .68604 m
.49888 .68808 L
s
.702 .555 .685 r
.46637 .52451 m .56588 .58084 L .5698 .52292 L F
.46637 .52451 m .47176 .58224 L .56588 .58084 L F
.702 .587 .724 r
.47176 .58224 m .4787 .63996 L .56083 .63878 L F
.47176 .58224 m .56083 .63878 L .56588 .58084 L F
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[27]:=",
  ImageSize->{288, 148.125},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000U1000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
@Ooo00@003P0>00h00]`00F@@0=@07Soo`<h00a`00F@@0=@03Woo`00?Ooo0P0000Dh0300>00`03P0
00a`000:T22@@90PT42@8910T22@@90PT41bool01`00>00`03P0<00h030000a`000:T42@8910T22@
@90PT42@8910T20gool003_oo`Dh00AX1@fAAPFaa@F@@003V43ooooo06_oo`Hh00AX1@bAAPJaa@F@
@003V43ooooo03?oo`00>Ooo00/00300>01P1FP5H0EX1F05J0EP1FP500fAAP^aa@03V22H@?oo06So
o`0<000`03P0<01X1F05J0EP1FP5H0EX1F0539563;7500>H@9PPool0<_oo000gool00`00J0EX1@09
J0D>TDH</LD00l91V42H@01Uool2000;J0D=TDH=/LD00l9QV43oo`0aool003Goo`800008801P1FP5
H0EX1F05J0EP1@B1BPjRB`Jjb`Jaa@05`T72@<91V22H@01Qool3000021P0J0EP1FP5H0EX1F05J0D4
PDX>XT/6^//6/LD01<90`T72@9Q0<?oo000bool300038003J0D8PDX08:9;XV^RBj9[XT^RJj9;XV^R
Bj9[XT^RJj9;XV^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;^^_2@L9Q`T72HL91V41Nool300038003J0D8
PDX07j9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^jjk[;^^^jbk[[^/^jjk[;^^^jbk[[^/_2HL91
`V72@L9Q02ooo`00<Ooo0P0000@P01P0800H00b1BPjRB`fjb`07ddOCB<90`T72@<910780Fooo0P00
00@H0200600P00b1BPjRB`fjb`06ddS2@<91`T32@L90;Ooo000`ool00`00800P00028002B0P<PDX0
8j9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;^^^jbm=XddSC
J==8`V72@L9Q0980FOoo00<0020080000R000TP82h5:02>RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^R
Bj9[XT^jjk[;^^^jbk[[^/^jjk[;^^^jbk[[^/^jjm=8dfSCB<9Q`T72HL9102coo`00;ooo00PP01P0
800H04P8B0M824P7285:18X>3Z[>00G3[/>>`jk3S/>^00Rjb`09ddOCB==7ddSCAm=8`T32@KW005Oo
o`07600P01P080181dP8B0L0285:18X>3j[>00G3S/>^`hk3[/>>00Rjb`09ddSCAm=8ddOCB<90`T72
@;W002[oo`00;_oo00<0020080001TP8185:28X>02FZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^
`hk3[/>>`jk3S/>^`hk3[/>>^^^jbk[[^/_CJ==8dfSCB==XddSCJ==8`V6i`01Eool00`00800P0005
B0P4PDX8RPh09Z[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZc/>^`hk3[/>>`jk3S/>^`hk3[[[;
^^^jbk[[ddSCJ==8dfSCB==XddS2HL91^L0Yool002goo`09000H04P8B0M824P7B0Q81dP800f:3PjZ
cP0H`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jkCAm=8ddOCB==7ddSCAm=8ddOCB;W0Dooo00P00200
B0M824P7B0Q81dP83HX>3j[>01K3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S]=8ddOCB==7ddSCAm=8
ddOCB0:i`2Soo`00;?oo00<004P8B0P01TP800=Q3HX>RPh02hX>02NZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZ
kZ[>Z^jZcZ[^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[]`=g2gCB==XddSCJ==8dfSCB==X^L00
DOoo00<004P8B0P01DP800=Q3HX>RPh02hX>02JZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/k3
[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>g2gL3M=XddSCJ==8dfSCB==X0[W09ooo000[ool20000
2DP8B0M824P7B0Q81f4=H>aQ3@0=RPh>Z/h06/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkL3M`<
g0gL3==8ddOCB==7ddSCAn>R^L1?ool02P0000581dP8B0M824P7H@ePk64=3HX>3j[>01S3S/>^`hk3
[/>>`jk3S/>^`hk3[/>>`jk3S/>^g0cL3M`<g0gCAm=8ddOCB==7hj82^L0Vool002[oo`8000030058
24P8009820EQ3@V:3P0]T]6BlI;AT_6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aa174<L@Aa374
4L>^`hk3[/>>`jk3S/>^`hk3[]`=g2gL3M`]g0gL;M=8dfSCB==Xhh;SX[W004goo`0300000@0100=8
20EQ3@V:3P0/T]6BlI;AT_6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe74<L@Aa3744L@a`hk3
[/>>`jk3S/>^`hk3[/>>g2gL3M`]g0gL;M`=dfSCB==XddSSXP:i`2Goo`00:Ooo0P0000/00DP7B0Q8
1f4=H>aQ3F3/H@ePk64=00B:3PVBd@j[D@[44@0B`jk3S/>^`hkL3M`<g0gL3=`=g0cL3M`<ddSCAn>R
hh7SX[W0Booo00`00001001824P7B0QPk64=H>aQ3F3/H@d5RPh8T]4?Ze4:a1404<>>`jk3S/>^g0cL
3M`<g0gL3=`=g0cL3M=7ddSSPN>R0[W09?oo000Yool0100000400DP8264=03VBdI;aT]6BlI;AT_6B
dI;aT]6BlI;AT_6BdI;aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LL@Aa3744L@aa174<L@Aa374
4L@aa174<L@Aa37L3M`]g0gL;M`=g2gL3M`]g0gL;N>2hj;SP^>R^L00B_oo0`0100=8264=H@d01V4=
03RBlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DL@a
a174<L@Aa3744L@aa174<L@Aa3744L@aa17L;M`=g2gL3M`]g0gL;M`=g2gL3N>Rhh;SX[W09?oo000X
ool03@000040064=H>aQ3F3/H@ePk64=H>aQ3G7@00jBd@j[D@k44@0@g;3LT=b`g0cL3M`<g0gL3=`=
g0cL3OB:hj;SPN>R^L18ool03@0100000F3/H@ePk64=H>aQ3F3/H@ePk77@00fBd@n[D@k44@0?g93L
/=b@g0gL3=`=g0cL3M`<g0gL3>>Rhh7SX[W002?oo`00:?oo0`011f4=0g7@03ZBdI;aT]6BlI;AT_6B
dI;aT]6BlI;AT_6BdI;aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LL@Aa3744L@aa174<L@Aa374
4L@aa174<L@Aa37LT=b`g93L/=b@g2gL3M`]g0gL;M`=m:[dR^>Rhh;SXTOoo`<00@0320UQ3F4=00EQ
3@=ad00iT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]a
Ze74<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Ag;3LT=b`g93L/=`=g2gL3M`]g0gL;OB:hj;SP^>R
02?oo`009ooo00T00@0000402F4=H>aQ3F3/H@d01G7@3Y;A3Z]A3/@A017L/=b@g;3LT=b`g93L/=`<
g0gL3=`=m8[dZ_B:hj;SPN>R04Goo`0:0040000100T82F3/H@ePk64=H>`5LM0=T]4?Ze4>a1404=b@
g;3LT=b`g93L/=b@g0gL3=`=g0cdZ_B:hj;SPN>R8_oo000Wool2004220T3H@d7LM00>i;AT_6BdI;a
T]6BlI;AT_6BdI;aVe>KLi]CVg>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?ca5?4LlACa7?4DlAc
a5?4<L@Aa3744L@aa174<Mb@g;3LT=b`g93L/=b@g;3LT=`]g0gdZ_B:m:[dR^>Rhh80AOoo0P010`P9
0f4=1g7@03ZBlI;AT_6BdI;aT]6BlI;AT_6KDi]cVe>KLk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C
/o>cdlAca5?4LlACa7?4DlAca174<L@Aa3744L@aa17L/=b@g;3LT=b`g93L/=b@g;3L3M`]m8[dZ_B:
hj;SPR;oo`009ooo00D00@0920T02F4=00Uad0FBd@VKD`0>/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C
/o>cd`k4D`0Bg;3LT=b`g93L/=b@g;3LT=b`g93L/?B:m:[dR_BZm8[SX^>1A?oo00H00@0920T02@P9
H>`9LM05T]48Ve<03k?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>cl`0>a5<04Mb@g;3LT=b`g93L
/=b@g;3LT=b`g93dZ_B:m:[dR^>Rhh408Ooo000Vool0100120T82@P92g7@03bKDi]cVe>KLi]CVg>K
Di]cVe>KLi]CVg>KDi]c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>cllACa7?4DlAca5?4LlACa7?4
DlAca5?4LlACa7?Ld]cbg93L/=b@g;3LT=b`g93L/=b@mFkeC_BZm8[dZ_B:hj93ool00`0120T82@02
20T;LM00>i]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>c
lk?Ca7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4Dmcbg=;L/=b@g;3LT=b`g93L/=b@g;3eC_BZm8[d
Z_B:hj808Ooo000Vool0100920T02@P92W7@0WZB3I]C00jclk?C/o>cdk?c/m>clk?C/o>cdk?c/m>c
lk?C3/AC01;Ll]cBg?;Ld]b`g93L/=b@g;3LT=b`mDkeK_E>m:[dR_BZm8Y3ool01@0920T02@P9<2h0
2W7@00=jTY]CVe<02i]C00nclk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o<03/AC017Ld]cbg=;L
l]b@g;3LT=b`g93L/=b@mFkeC_BZm8[dZ_B:027oo`009Ooo10P900<`CW7@LM001W7@041j/WZBN[9j
TY]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>cllACa7?4
DlAca5?4LlACa7?4DlAca5?4LlACa7?Ld]cbg=;Ll]cBg?;LT=b`g93L/=b@mFkeC_E^mDkdZ_B:m:[d
RT7oo`@82@8`CPQad00oNY9j/WZBVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>cdk?c/m>clk?C/o>c
dk?c/m>clk?C/o>cdk?c/m?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg=;Ll]cBg;3L
T=b`g93L/?E>mFkeC_BZm8[dZ_B:023oo`009Ooo00D82@0920T`;S1>00Iad0IjTPfKD`0>/o>cdk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cd`k4D`0Cg?;Ld]cbg=;Ll]cBg?;Ld]b`g93L/?E>mFkeC_E^mDkd
Z_B:m:X0@Ooo00H82@0920T`;S1><2h6LM05NY8=Ve<03k?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c
/m>cl`0>a5<04]cBg?;Ld]cbg=;Ll]cBg?;LT=b`g93eK_E>mFkeC_BZm8[dZR3oo`009Ooo0PP90c1>
177@04Ej/WZBN[9jTWZbNY9j/WZBVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>cdk?c/m>clk?C/o>c
dk?c/m>clk?C/o>cdk?ca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LmcBg?;Ld]cbg=;Ll]cBg?;L
d]cbg93eK_E>mFkeC_E^mDkdZ_B:g600@?oo0PP9131>177@04AjTWZbNY9j/WZBN[9jTY]cVe>KLi]C
Vg>KDi]cVe>KLi]CVg>KDi]c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?Ca7?4DlAca5?4LlAC
a7?4DlAca5?4LlACa7?4Dmcbg=;Ll]cBg?;Ld]cbg=;Ll]cBg;3eC_E^mDkeK_E>m:[dR]aP7ooo000T
ool01P0020T`;S1><2h`CP9ad0YjTPVKD`04VkBKU9^dVi@>]1@01lBda9C4]<BDa;C4U<Bd00O4D`0D
g?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll_E>mFkeC_E^mDkeK_E>m:[L@43oo`0620T`;S1><2h`CS0^0W7@
2GZB2I]C00FK]9^DVkBKU9^d00jd5007a9C4]<BDa;C4U<Bda9@01lAC01?Ld]cbg=;Ll]cBg?;Ld]cb
g=;Ll]cBmFkeC_E^mDkeK_E>m:[L@00Oool002Coo`03000`CS1>00<`CP19N[9jTWZbNY9j/WZBN[9j
TWZbNY9j/WZBVg>KDi]cVe>KLi^DVkBKU9^dViBK]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd
5;@da9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9CLl]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;e/_FBmFke
C_E^mDkeK_E>g600?ooo00<0031><4h0131>04QjTWZbNY9j/WZBN[9jTWZbNY9j/WZBVg>KDi]cVe>K
Li^DVkBKU9^dViBK]9^DVkBKU;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]=cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll_FBmK;eC_E^mDkeK_E>g60Oool002Co
o`07<2h`CS0^<4h`;S1>BI802gZB00fKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU00>]1@08lBda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<BdeACE==DDg?;Ld]cbg=;Ll]cBg?;Ld]cbmI;e/_FBmFkeC_E^mDke
K_G9g400?_oo00H`;S1><2h`CS0^<4h2BI8:NY803Y^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVk@>
]1@08/BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDeCCE5=Ddg=;Ll]cBg?;Ld]cbg=;Ll]cBmK;eT_Fb
mDkeK_E>mFkebMa07_oo000Sool00`00<4h`CP03<4h2BI80BGZBN[9jTWZbNY9j/WZBN[9jTX<dPaB3
=9^DVkBKU9^dViBK]9^DVkBKU9^dViBK];@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U=DdeACE==DDeCCLd]cbg=;Ll]cBg?;Ld_FbmI;e/_FBmFkeC_E^mDke
jMa003koo`D`CP=9TP18N[9jTWZbNY9j/WZBN[9jTX<dPaB3=9^DVkBKU9^dViBK]9^DVkBKU9^dViBK
]9^D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<BdeACE
==DDeCCE5=cbg=;Ll]cBg?;Ld]cbmI;e/_FBmK;eC_E^mDkejMa07_oo000Sool01@00<2h`CS0^<4h0
0dVB1gZB1H<D00bK]9^DVkBKU9^dViBK]9^DVkBKU9^dVi@>]1@08lBda9C4]<BDa;C4U<Bda9C4]<BD
a;C4U<BdeACE==DDeCCE5=DdeACLl]cBg?;Ld]cbmI;e/_FBmK;eT_FbmDkeK_G9mNT0?_oo00@`;S1>
<2h`CPA9TPIjTPF3500=VkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVk@03[@D02;4U<Bda9C4]<BDa;C4
U<Bda9C4]<BDa;C4U=DdeACE==DDeCCE5=Ddg=;Ll]cBg?;Ld_FbmI;e/_FBmK;eC_E^mLWejAkoo`00
8_oo00<00007<4h00S1>14VB04MjTWZbNY9j/WZBPcB358<dPaB3=8<DPcBKU9^dViBK]9^DVkBKU9^d
ViBK]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@da9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bd
a9CE==DDeCCE5=DdeACE==DDeCCLd]cbg=;e/_FBmK;eT_FbmI;e/_E>00;ej@03g63ooooo03[oo`04
000`CS1><4h5BI80AWZbNY9j/WZBPcB358<dPaB3=8<DPcBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBK
U;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]=DDeCCE
5=DdeACE==DDeCCE5=cbg=;Ll_FBmK;eT_FbmI;e/_E>0_GY00?LH?ooool06ooo000Rool0100000L`
;S1>1DVB0gZB2H<D00bK]9^DVkBKU9^dViBK]9^DVkBKU9^dVi@>]1@09<Bda9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<BdeACE==DDeCCE5=DdeACE==DDeCCE5?FbmI;e/_FBmK;eT_FbmI;e/_G9mNWL@3coo`03
00L`;S1>00I9TP9jTPZ3500<ViBK]9^DVkBKU9^dViBK]9^DVkBKU9^d3K@D02C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDeCCE5=DdeACE==DDeCCE5=DdeACE=?FBmK;eT_FbmI;e/_FBmK;ebOGYg40M
ool002;oo`0300001c1>00I9TP0nPaB3=8<DPcB358<dPaB3=8<DPcB358<dViBK]9^DVkBKU9^dViBK
]:@FY3JT5Z@fY1JdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMLCEa?G4eLCea=G4mLBDa;C4U<Bda9C4
]<BDeCCE5=DdeACE==DDeCCE5=DdeACE=0;]m008mI;e/_FBmK;eT_FbmI;n[`;ejCcoo`0300L`CTVB
00I9TP0nPcB358<dPaB3=8<DPcB358<dPaB3=8<DVkBKU9^dViBK]9^DVkBKU:@fY1JT=Z@FY3JdEKAe
]5FdMKAE]7FdEKAe]5FdMKAE]7G4eLCea=G4mLCEa?G4eLBda9C4]<BDa;C4U<BdeACE==DDeCCE5=Dd
eACE==DDeCCE50;]m007mK;eT_FbmI;e/_FBoZl00_GY7Ooo000Rool00`0600M9TP06BI800eYDPaB3
5009Pa@019^dViBK]9^D2J@F3KAE02C4mLCEa?G4eLCea=G4mLCEa?G4eLCea=GE==DDeCCE5=DdeACE
==DDeCCE5=DdeAC]m>gDkOCeT_FbmI;e/_FBmK;nSoGYmLTlool00`07BI99TP05BI82FU@;Pa@019^D
VkBKU9^d2J@F3;AE02C4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mMDDeCCE5=DdeACE==DDeCCE5=Dd
eACE=>gDkOC]e?FbmI;e/_FBmK;nSoGYmLTMool002;oo`801`0300i9TTVB00=9TP0oFWAJE8<dPaB3
=8<DPcB358<dPaB3=8<DPcBT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5[Ae]5FdMKAE]7FdEKAe]5Fd
MKAE]7FdEKAea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCeeEKEM]EFeCCE5=DdeACE==DDeCCE5=Dd00C]
m005mI;e/_FBmK;eTP02oZl00oGYooooo`0jool00`0700i9TP04BI80@5YdFUAJM8<DPcB358<dPaB3
=8<DPcB358<dPaBT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=[AE]7FdEKAe]5FdMKAE]7FdEKAe]5Fd
MLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEeGKEE]DdeACE==DDeCCE5=DdeACE==DD1>gd00Ce/_FB
mK;eTP;n[`03mNWooooo01_oo`008Ooo00@01`0600L03PA9TP=JE0V35003RkJ;UX^f00bT5PfdE@0T
a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEeGKEE]EfeEKEM]DDeCCE5=DdeACE==DDkOC]e>gdkMC]m>gD
mK;eT_FboXon[oG9>ooo00<01P0700h014VB15YD2H<D00>;UX^fRiH03:@F3;AE02C4mLCEa?G4eLCe
a=G4mLCEa?G4eLCea=G4mMEFeGKEE]EfeACE==DDeCCE5=DdeAC]m>gDkOC]e>gdkMCe/_FBmK;nSoj_
mLTMool0027oo`801`803P=9TP11FWAJE5YdFUAJM8<DPcB358<dPaB;]X^FRkJ;UX^fRiJT=Z@FY3JT
5Z@fY1JT=Z@FY3JT5Z@fY1JdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMLCEa?G4eLCea=G4mLCEa?G4
eLCea=G4mMEFeGKEE]EfeEKEM]EFeCCE5=DdeACE=007kO@01OFbmI;n[oj_mNT0>ooo0P0704D03TVB
BI99TUYdFUAJM5YDFWAJE8<dPaB3=8<DPcB;UX^fRiJ;]X^FRkJT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@F
Y3JdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eMEfeEKEM]EF
eGKEE]DdeACE==DDeC@01ngd00Ge/_FBoZon[oGY01goo`008Ooo00@01`0600h03P99TPIJE0>35008
RiJ;]X^FRkJ;UX^fRiJ;]PbT5PfdE@0Ta?G4eLCea=G4mLCEa?G4eLCea=G4mLCEeGKEE]EfeEKEM]EF
eGKEE]EfeACE==DDkOC]e>gdkMC]m>gDkOC]e?j_oXon[oj?>ooo00<01P0>00h00TVB1eYD0h<D00R;
]X^FRkJ;UX^fRiJ;]X^F3:@F3;AE02C4mLCEa?G4eLCea=G4mLCEa?G4eLCea=GEM]EFeGKEE]EfeEKE
M]EFeGKE5=DdeAC]m>gDkOC]e>gdkMC]m>gDoZonSoj_oXlMool0027oo`1700L03P0>00i9TUYdFUAJ
M5YDFWAJE5YdRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5[Ae]5Fd
MKAE]7FdEKAe]5FdMKAE]7FdELCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCeeEKEM]EFeGKEE]EfeEKE
M]EFeGKEEP09kO@01?kcoZon[oj_>ooo04H01`0>00i9TUYdFUAJM5YDFWAJE5YdFUB;]X^FRkJ;UX^f
RiJ;]X^FRkJ;UX^fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@f]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe
a=G4mLCEa?G4eLCea=G4mLCEa?G4eLCeeEKEM]EFeGKEE]EfeEKEM]EFeGKEEPW]m004o_?n[oj_oZlM
ool0027oo`0400L03P0>00h8FU@036/FRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UPRT5PBTE`0`];NdUkBg
]9Nd]kBG];NdUkBg]9Nd]lDGaCO55lDgaAO5=lCEa?G4eLCea=G4mLCEeGKEE]EfeEKEM]EFeGKEE]Ef
eEKEM^HFiSK]e>gdkMC]m>gDkOC]e?kcoXon[oj?>ooo00<01P0>00h025YD00a[5V<FRkJ;UX^fRiJ;
]X^FRkJ;UX^fRiH8Y1H5Y5L0;kBG];NdUkBg]9Nd]kBG];NdUkBg]9O5=lDGaCO55lDgaAO4mLCEa?G4
eLCea=GEM]EFeGKEE]EfeEKEM]EFeGKEE]EfiQKV=^gDkOC]e>gdkMC]m>gDo_?nSoj_oXl07Ooo000Q
ool400h0@Q3CFWAJE5YdFUAJM5YDJcI[5X^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJT5Z@fY1JT=ZAGY7NT
EjAgY5NTMjAGY7NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeGKE
E]EfeEKEM]EFeGKEE]EfeEKEMPCV=PG]m0?nl`;n[c_oo`<03P134==JM5YDFWAJE5YdFUA[=V/FJcJ;
UX^fRiJ;]X^FRkJ;UX^fRiJ;]Z@FY3JT5Z@fY5NTMjAGY7NTEjAgY5NTMjAG];NdUkBg]9Nd]kBG];Nd
UkBg]9Nd]lDGaCO55lDgaAO5=lDGaCO55lDgaAOEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEH00nHf1Ngd
0okc0_j_7Ooo000Rool300h00a3CFUAJE003FU@03V/FHaI[5V<FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiH<
Y5L0:kBg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCOEUmFgeIOEM]EF
eGKEE]EfeEKEM]EFiSKV5^HfiQKV=^HFkOC]e>gd00?nl`03oZonSooo03_oo`803P034==JE5YD00=J
E00>JaIS5V/FHaJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UPfTE`0Z]9Nd]kBG];NdUkBg]9Nd]kBG];NdUlDg
aAO5=lDGaCO55lDgaAO5=lDGaCOEUmFgeIOEM]EFeGKEE]EfeEKEM]EFiSKV5^HfiQKV=^HFkOC]e>gd
0okc00?n[oj?ool07?oo000Rool200h24=<0@5YdFUAJM5YDJcI[5V/fJaI[=X^FRkJ;UX^fRiJ;]X^F
RkJCei?gTmNTMjAGY7NTEjAgY5NTMjAGY7NTEjAg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUlDgaAO5=lDG
aCO55lDgaAO5=lDGaCO55mFgeIOE]mFGeKOEE]EfeEKEM]EF2>Hf0^gd0okc0_j_??oo0P0>048@deYd
FUAJM5YDJcI[5V/fJaI[=V/FRkJ;UX^fRiJ;]X^FRkJCei?gTmNTMjAGY7NTEjAgY5NTMjAGY7NTEjAg
Y5Nd]kBG];NdUkBg]9Nd]kBG];NdUkBgaAO5=lDGaCO55lDgaAO5=lDGaCO55mFgeIOE]mFGeKOEE]Ef
eEKEM]EFeGH7iSH2kO@3o_<2oZlMool002;oo`803P032;<@d`Rc009JE00AJaIS5V/FHaI[5V<FJaJ;
UX^fRiJ;]X^FToNCei?gTmNCm`0;Y5L0:[Bg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO5
5lDgaAO5=lDGaCOEUmFgeIOE]mFGeKOEUmEfeEKEM^HFiSKV5^HfiQKV=^HFiSKV5PGnl`03oXoooooo
03[oo`0400h8/a3C2;<2FU@04F/FHaI[5V<FJaIS5V/FRiJ;]X^FRkJ;UY?gTmNCmi?GToL03:AG02Vd
UkBg]9Nd]kBG];NdUkBg]9Nd]kBGaCO55lDgaAO5=lDGaCO55lDgaAO5=mFGeKOEUmFgeIOE]mFGeKOE
E]EfeEKV=^HFiSKV5^HfiQKV=^HF00Gnl`03oXoooooo01_oo`008_oo00<03Q3C4=<00Q3C03iJE6/f
JaI[=V/FJcI[5V/fJaJ;]X^FRkJCei?gTmNCmi?GToNCejAgY5NTMjAGY7NTEjAgY5NTMjAGY7NdUkBg
]9Nd]kBG];NdUkBg]9Nd]kBGaCO55lDgaAO5=lDGaCO55lDgaAO5=mFGeKOEUmFgeIOE]mFGeKOEUmFg
2^Hf00?fm_kco_<00_kc00?n[oooool0>_oo04<03Q3C4=<@deYDJcI[5V/fJaI[=V/FJcI[5X^fRiJ;
]Y?GToNCei?gTmNCmi?GToNTEjAgY5NTMjAGY7NTEjAgY5NTMjAG];NdUkBg]9Nd]kBG];NdUkBg]9Nd
]lDGaCO55lDgaAO5=lDGaCO55lDgeIOE]mFGeKOEUmFgeIOE]mFGeKOEU`09iSH00oKfo_?nl`02o_<0
0oj_ooooo`0Kool002;oo`0I00h@d`Rc4=<8/f/FHaI[5V<FJaIS5V/FHaI[5Y?GToNCei?gTmNCmi?G
ToNCei?gTmL02ZAG02^d]kBG];NdUkBg]9Nd]kBG];NdUkBgaAO5=lDGaCO55lDgaAO5=lDGaCO55mFg
eIOE]mFGeKOEUmFgeIOE]mFGgSSN6>HfiQKV=^HFiSKV5^HfiQKfmP04o_<00kf5ooooo`0jool0600>
2;<@d`RcJaIS5V/FHaI[5V<FJaIS5V/FTmNCmi?GToNCei?gTmNCmi?GToNCe`^TE`0Z]9Nd]kBG];Nd
UkBg]9Nd]kBG];NdUlDgaAO5=lDGaCO55lDgaAO5=lDGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mhHiSKV
5^HfiQKV=^HFiSKV5_Kf1?kc00>mQOooool06ooo000Rool54=<05C8FJcI[5V/fJaI[=V/FJcIcV7>h
TmNCmi?GToNCei?gTmNCmi?GToNTE`0300009ZAGY7NTEjAgY5NTMkBG];NdUkBg]9Nd]kBG];NdUkBg
]9O5=lDGaCO55lDgaAO5=lDGaCO55lDgeIOE]mFGeKOEUmFgeIOE]mFGeKL3gSP6iSH3m_H3o_<00kfU
ooooo`0jool44=<0?c8FJcI[5V/fJaI[=V/FJcIcV7>hTmNCmi?GToNCei?gTmNCmi?GToNCejAgY5NT
MjAGY7NTEjAgY5NTMjAG];NdUkBg]9Nd]kBG];NdUkBg]9O5=lDGaCO55lDgaAO5=lDGaCO55lDgeIOE
]mFGeKOEUmFgeIOE]mFGeKOEU`02gSP6iSH3m_H3o_<00kfUooooo`0Kool002?oo`034=<8/a3C00<b
5P0?JaIS5V/FHaI[5W>HLkQcV9?gTmNCmi?GToNCei?g00@000>TE`D0000ZY9RT^;CH]?Rdf;Ch]=Rd
n;CH]?Rdf;Ch_ERmN;eH_GRmF;eh_ERmN;eH_GSEUmFgeIOE]mFGeKOEUmFgeIOE]mhHgSSN6=hhgQSV
=^HFiSKV5^Hf0oKf0okc?_oo00<8/a3C2;<00S8F01=[5V<FJaIS5V/FLiQc^7>HLkRCei?gTmNCmi?G
ToNCei?gTmNCm`05Y5L0;JBhY9RT^:BHY;RTV;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;eH_GRmF;eh_ERmN;eH
_GRmF;eheIOE]mFGeKOEUmFgeIOE]mFGeKOEUmhhgQSN>=hHiSKV5^HfiQKV=P03m_H3o_<Nool002?o
o`<@d`<b5P0KJaI[=V/FJcIcV7>hLiQc^7>HToNCei?gTmNCm`00ToNCei?gY9RT^:BHY;RTV:BhY9RT
^:BH00D0000K]=Rdn;CH]?Rdf;Ch]=RmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcISE]mFGeKOEUmFgeIOE
]mFG00KN>0?V=PGfmP03o_?O;_oo03goo`8@d`<b5P0lJaI[=V/FJcIcV7>hLiQc^7>HToNCei?gTmNC
mi?GToNCei?gTmNT^:BHY;RTV:BhY9RT^:BHY;RTV:Bh]=Rdn;CH]?Rdf;Ch]=Rdn;CH_GRmF;eh_ERm
N;eH_GRmF;eh_ES=^<fHcKSEUmFgeIOE]mFGeKOEUmFg1Mhh0nHf1OKf00?nlml^ool07Ooo000Sool0
0`0<2;<b5P04<QH02f<FJaIcV7>hLiQc^7>HLkRCei?gTmL00P0000BCmi?GU5RDF0X00004Y;Rdf;Ch
]=P200008[Ch]=Rdn;CH]?RmF;eh_ERmN;eH_GRmF;eh_ERmN<fHcKS=V<fheIOE]mFGeKOEUmhhgQSN
>=hHgSSN6=hhgQSV=^HF1OKf00?nlml^ool0?Ooo00<0313C<QH00c8F011S5V/FLiQc^7>HLkQcV7>h
LiRCmi?GToNCei?gTmNCm`>DF00`Y;RTV:BhY9RT^:BHY;RTV:BhY9Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rm
F;eh_ERmN;eH_GRmF;eh_ERmN<fHcKS=V<fhcISE]mFGeKOEUmFggQSN>=hHgSSN6=hhgQSV=^HF1OKf
00?nlml^ool07Ooo000Tool00a3C<QHb5P03<QH03G>hLiQc^7>HLkQcV7>hLiQc^9?G002CeiAh00@0
000:U5RT^:BHY;RTV:BhY9RT^:BHY;P300000kCh]=Rdn00200005[CH]?Rdf;eh_ERmN;eH_GRmF;eh
_ERmN<fHcKS=V<fhcIS=^<fHeKOEUmFg2Mhh1_Kf0]l^?ooo00<@dc8F<QH00S8F03Yc^7>HLkQcV7>h
LiQc^7>HLkQcV9?gTmNCmiAHU7RDF9AhU5RDN:BHY;RTV:BhY9RT^:BHY;RTV:Bh]=Rdn;CH]?Rdf;Ch
]=Rdn;CH_GRmF;eh_ERmN;eH_GRmF;eh_ES=^<fHcKS=V<fhcIS=^=FGeKOEU`SN>0KfmP;O;Qkoo`00
9?oo1S8F00Y;67>hLiQc^7>HLkQcV7>hLiP000:DF003002DF9AH00BDF0T00007]=Rdn000002df;Ch
]=P00P0001jdn;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=^=hHgSSN6=hhgQSN>=hH
gSSN6=hhkcP5m_H2gbhoool5<QH02T/HLkQcV7>hLiQc^7>HLkQcV7>h2IAH00>T^:BH00001@0002RT
^:BH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch_ERmN;eH_GRmF;eh_ERmN;eHcKS=V<fhcIS=^<fHcKS=V<fhcISN
>=hHgSSN6=hhgQSN>=hHgSS_>0GfmP;O;Qkoo`009?oo00<0338F<QH00c8F011;>4/HLkQcV7>hLiQc
^7>H001l6IAhU5P009AHU7RDF0<00009Y9RT^:BHY;RTV:BhY9RT^:BH00<00006]=P00000002df;Ch
0P00016mF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=^<fH00;FN@ON>0;_>0CfmP03kkCO;_oo
03ooo`0300`b5S8F008b5P0BBcQ;67>hLiQc^7>HLkQcV7>hO1Ul>IAHU7RDF9AhU5RDN9AH0`0000JT
V:BhY9RT^:BHY;P400006[CH]?Rdf;Ch]=Rdn;CH_GRmF;eh_ERmN;eH_GRmF;ehcIS=^<fHcKS=V<fh
cIS=^<fHcKP2eWT6gSP3kcP3m_H00nndgbkoo`0Nool002Coo`0300`0Dc8F008b5P=;6006LiQc^7>H
LkQcV0000g`I00<009AHU5P00P0019AH00^TV:BhY9RT^:BHY;RTV:Bh]=Rdn;CH00H0000K_GRmF000
_ERmN;eH_GRmF;ehcIS=^<fHcKS=V<fhcIS=^<fHeWWFFMIieUWN>=hHgSSN6=hh00C_>0;fmP;_]003
gbkooooo03koo`0400`0<c8F<QH4BaP01G>hLiQc^7>HLkP017`I19AH0P000YAH00^TV:BhY9RT^:BH
Y;RTV:BhY9Rdn;CH00<0000N]=Rdn;CH_GRmF;eh_ERmN;eH_GRmF;eh_ES=^<fHcKS=V<fhcIS=^<fH
cKSFFMIieUWFNMhHgSSN6=hh1>lh0oKf00?_]=l^ool07_oo000Uool205<2<QH09T/HBcQ;64/hLiQc
^7>H001l6G`iO1T009AHU7P009AhU5RDN9AHU7RDF:BhY9RT^:BHY?VTfJCiY=VTnKDI]CVe6KDi]AT0
0;DI]CT500003;fi_IVm^LfHcKS=V<fhcIS=^<fHcKS=V0OFN@;N>0G_>005m_K_]>ndkkCO;P11ool0
4`1C<QHb5T/HBcQ;64/hBaQc^7>HLkQl6G`iO1Ul>G`IU7RDF9Ah0080000@U5RDN9AHY;RTV:BhY9RT
^:CIY?VTfJCiY=Ve>KDI]CT400004[fI_KVmVKfi_IVm^KfI_KVmVLfhcIS=^<fHcKS=V<fhcIS=^0KF
N@;N>0K_>004m_K_]>ndgbhOool002Goo`0400`0<`1C<QH5BaP00g>HO1T00003O1T00`00O1T00007
U5P03jCIY?VTfJCiY=VTnJCIY?VTfKDi]AVe>KDI]CVe6@0200000kfi_IVm^@0400004[fIaO[5f/Gj
cIS=^<fHcKS=V<fheUWFNMIIeWWFFMIieUWFN@K_>0C_]4;oo`0300`0Dc8F00I;6003LkQl6G`I00El
6@03U5P0000000BDF00AY=VTnJCIY?VTfJCiY=VTnJCIY?Ve6KDi]AVe>KDI]CVe6@0200005kfi_IVm
^KfI_KVmVKfiaM[5n/GJcKS=V<fhcIS=^<fHeWWFFMIieUWFNMIIeWT01nlh0nnd8?oo000Vool205<0
9d/hBaQ;>4/HBcQ;67`i001l>G`IO3T007`iO1T009AHU7RDF9AhU5RL^YbJW;ZTfJCiY=VTnJCIY?VT
fJCi]AVe>KDI]CVe6KDi]AVe>@0300001;fi_IT00;fI0P001<Gj00?=^<fHcKP02MIi00?Vn^lhkcP0
0nlh1>nd@ooo0100Dd/hBaQ;>4/HBcQ;64/hO1Ul>G`IO3Ul6G`iO1Ul>@80000GU5RDN9AHW;ZLVYbj
Y=VTnJCIY?VTfJCiY=VTnJCI]CVe6KDi]AVe>KDI]CVmV@0200001[fi_IVm^KfI_KVmV@G5nP03cIS=
^<fH00SFN@03i_[_>>lh00C_>0?_]23oo`009_oo00<0<`1C03<01D/H00EKfP00O1Ul6@00009l6@03
001l6IAH00:DF00HW9ZL^YbJW;ZLVZCiY=VTnJCIY?VTfJCiY=Ve>KDI]CVe6KDi]AVe>KDI_KVmVKfi
0P0001>mV@00aM[5nP00aO[5f/GjaM[5n]IIeWWFFMIieUWFNMIIeWWFF@02i_X4kcP01>ohkkC_]>nd
A?oo00<0D`0cBaP01D/H00=KnW`IO1T017`I0P000YAH01RLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?VT
fJCi]AVe>KDI]CVe6KDi]AVm^KfI_KT200004kfI_KVmVLGjaM[5n/GJaO[5f/GjaM[FNMIIeWWFFMIi
eUWFNMII00?VnPC_>003koS_]>nd027oo`009_oo0`1C02/264/hBaQ;>4/HFoX007`iO1T007`I001l
6G`iW9ZL^YbJW;ZLVYbjW9ZL^YbJY?VTfJCiY=VTnJCIY?Ve6KDi]AVe>KDI]CVe6KDi_IVm^KfI_KVm
V@030002aOX00`00aO[5nP02aOX2cWX6eWT4i_X2kcP2koP3kkA4ool205<0:`8HBcQ;64/hBaQKnU_J
FoYl6G`iO1Ul>G`I001l6IbjW9ZL^YbJW;ZLVYbjW9ZTnJCIY?VTfJCiY=VTnJCI]CVe6KDi]AVe>KDI
]CVmVKfi_IVm^KfI00800003_KW5n/Gj00K5nP;>NPGFN@CVnP?_>0;_n0;_]27oo`009ooo00@0D`0c
0QP2609;6005FoYKfP00FmX00002O1T08P00O1V4VXBjW9ZL^YbJW;ZLVYbjW9ZL^ZCIY?VTfJCiY=VT
nJCI]CVe6KDi]AVe>KDI]CVe6Kfi_IVm^KfI_KVmVLGj0`0000c5nP00aO[5f/ijcU[>N/iJeWWFFMIi
eUT5i_X01>lhkoS_n>oh0^ndA_oo00<0<`8H0QP00d/H00AKfU_jFmYKnPAl6@0P0024^XBJW;ZLVYbj
W9ZL^YbJW;ZLVZCiY=VTnJCIY?VTfJCi]AVe>KDI]CVe6KDi]AVm^KfI_KVmVKfi_IVm^@80000>aM[5
n/GJaO[5f/GjcU[>N/iJcW[FFMIieUWFN@GVnP05kcS_n>ohkoS_]00Rool002Soo`0]05<2608H0QQ;
>5_J001KfU_j001l>G`I0024VXBjQ9Z4^YbJW;ZLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?Ve6KDi]AVe
>KDI]CVe6Kfi_IVm^KfI_KVmVKfi00;5nP030035nP0000<000G>NP;FN@KVnPC_n003kkCooooo04Ko
o`0_05<2608HBcQKfU_jFmYKnU_JFoYl6G`i0024^XBJQ;Z4VYbjW9ZL^YbJW;ZLVYbjW9ZTnJCIY?VT
fJCiY=Ve>KDI]CVe6KDi]AVe>KfI_KVmVKfi_IVm^KfIaOX00005aOX6cWX2eWT6i_X4koPSool002Wo
o`<2600/FmYKnP00FoYKfP00FmX008BJQ;Z4VXBjQ9Z4^YbJW;ZLVYbjW9ZL^YbJYGZUFZEjYEZUNZEJ
YGZeF[Ej]EZeN[EJ]GZmV[fj_IZm^[fJ_K[5f/GjaM[5nP800009aMX00<iJ003>F/ijcU[>N/iJ00KV
nP03ik__n>oh00;_n003003ooooo04Ooo`82600/FmYKnU_JFoYKfU_jFmZ4^XBJ0024VXBjQ9Z4^XBJ
W;ZLVYbjW9ZL^YbJW;ZUFZEjYEZUNZEJYGZUF[Ej]EZeN[EJ]GZeF[fj_IZm^[fJ_KZmV/GjaM[5nP<0
0009aO[>F/ijcU[>N/iJcW[>F/ij00KVnP05ik__n>ohkoP0000Sool002Woo`@2600WFmX005_JFoX0
05_j0024^XBJQ;Z4VXBjQ9Z4^YbJW;ZLVYbjWA^M>idKYGZUFZEjYEZUNZEJ]GZeF[Ej]EZeN[EJ_KZm
V[fj_IZm^[fJ00>n>`;5nP800004cWX00<ij0003cWX2e_/4i_X2ik/4koQ:ool30QP0:2]KFoYKfU_j
FmYKnWAKM7/008BjQ9Z4^XBJQ;Z4VYbjW9ZL^YdKWC^M6idkYEZUNZEJYGZUFZEj]EZeN[EJ]GZeF[Ej
_IZm^[fJ_KZmV[fj0khk0/Gj0P001lij0]Kk1>Kj0^Nk0noh9?oo000Zool30QP0<b]K001KnU_J001K
fP00M5^4^XBJQ;Z4VXBjQ9Z4^YdKWC^M6idkWA^M>jEJYGZUFZEjYEZUN[EJ]GZeF[Ej]EZeN[fJ_KZm
V[fj_IZn>khK_S^n6khk_Q^n>`00cWX00<ijcUX00004e_/3i_X3ik/3koQ<ool20QP2:e/015_jFmYK
nU_J0WAK02`008BJQ;Z4VXBjQ9Z4^YdKWC^M6idkWA^M>idKYGZUFZEjYEZUNZEJ]GZeF[Ej]EZeN[EJ
_KZmV[fj_IZm^[hK_S^n6khk_Q^n>liJ003>F/ijcU[>N/iJ1=Kk0nKj0nNk0^oh9Ooo000[ool20QP0
9R]K001KfU_j001dN`00M7]dFhBjQ9Z4^XBJQ;Z=6hdkWA^M>idKWC^M6idkYEZUNZEJYGZUF[Ej]EZe
N[EJ]GZeF[fj_IZm^[fJ_KX6_S/2aW/300000lije_/00004e_/00nKjik_W^`02ik/2koP00`00oooo
o`1;ool20QP09R]k:e]KnU_JFoYdFgAk001dNhBJQ;Z4VXBjSA^=>idKWC^M6idkWA^M>idKYGZUFZEj
YEZUN[EJ]GZeF[Ej]EZeN[fJ_KZmV[fj_IX6_S/2aW/20002cWX6e_/00nKjik_W^`02ik/00noh003o
o`0Tool002_oo`09058262]K000[Fe_J001dF`0000=dF`0VQ;Z4VXBjSA^=>hdKSC^M6idkWA^M>idK
YGZUFZEjYEZUN[EJ]GZeF[Ej]EZeN[fJ_KZmV[fj_Q^n>khK_S^n6khkaU_6NlIKaW_6F`<00003e_/0
0=Kk00;Fn`GW^`03koR_Looo04goo`03038262]K008[F`05FoYKfWAKM5/00002M5/09HBJQ;Z=6hdk
SA^=>idKWC^M6idkWA^M>jEJYGZUFZEjYEZeN[EJ]GZeF[Ej]EZm^[fJ_KZmV[hk_Q^n>khK_S^n6lIk
aU_6NlIK008000OFn`GW^`03[g?ooooo02Coo`00;?oo02D0DR]K000[Fb]k001dN`00M7]dFgAkM5^=
>hdKSC^=6hdkSA^=>idKWC^M6idkWA^UNZEJYGZUF[Ej]EZeN[EJ]GZmV[fj_IZm^P06_S/5aW/2c_`0
1mKk003FnmKk003FnmMl00GW^`03[g?ooooo04koo`0U058[Nb]K:g/[FgAkM5]dN`00M7]dFgAkSA^=
>hdKSC^=6hdkWA^M>idKWC^M6idkYEZUNZEJYGZeF[Ej]EZeN[EJ_KZmV[fj_IX01[hk1LIk00?>o000
e_/01MKk00?GO>Nkik/00^Nk00>_Loooool09Ooo000]ool0201B0UT002]K001D77AK0003M5/08gcL
O?b=6hdkSA^=>hdKSC^M6idkWA^M>jFLYKbUW:FlYIb]o:gL[Ob]g;Gl]Mbeo;GL]Sbf7;hk_Q^n>lIK
aW_6FlIkaU/00lkl0]Kk00<00=Kk00000]Ml1>Nk00>_Loooool0D?oo00@0<R]K:e/[F`9D7003M5/0
07AK009dF`0RO?alg8dkSA^=>hdKSC^M6idkWA^M>idKYKbUW:FlYIbU_:gL[Ob]g:gl]Mbeo;GL]Obf
7;Hl_Q^n>khKaW_6FlIkaU/4c_`01000e__FnmKk0mMl0nNk00>onOooool09_oo000]ool205806P00
:g/005@lE1`007AKM7]dFgclO=alo8dKSC^=6hdkSA^=>ifLWKbMW9flYIbU_:FLYK`4[O`3]O`5]S`5
aW/5c_`2e_/02000eg`00=Ml003W^koi[g=Cool205806R]k:e]D?5@LE3`007AkM5]lo7cLO?alg8dk
SA^=>hdKSC^MW9flWIbM_9fLYKbUW:FlYI`4[O`3]O`5]S`4aW/6c_`00`00e__GO003eg`00nNk_oVo
n@0Yool002ooo`060002FB]K001D70000U@L025lo7cLO?alg7clO=b=>hdKSC^EGIEmUEfM_9fLWKbU
W:FlYIbU_:gL[Ob]g;Gl]Mbeo;HL]Sbf7;Hl_UfnOKiM_Wd01lkl0mMl00H00=Ml002on@00[g=Eool0
0`1B0UT[F`04E1`08P00O?alg7clO=alo7cLO?b=6hdkUEfEOIEMWKbMW9flWIbU_:FLYKb]g:gl[Mb]
o;GL]Obeg;Hl]Qbf?;HL_WfnGKim2<kl00?GO000eg`00]Ml0koi:_oo000`ool06P000UT005@LE3`0
05@lK=e/oGcLO?alg7clO=bEOIEMUGfEGIEmUEfM_9fLWKbUW:FlYI`3[O`2]O`4]S`4_Wd2_[d4c_`2
acd4eg`200000koiool0001Fool06P1B0UUD?5@LE3aD7000E1a/oFcMO?alg7clO=alo9EMUGfEGIEm
UEfM_9fLWKbMW:FlYI`4[O`2]O`4]S`3_Wd2_[d5c_`2acd01MMl003GO=Mlaod00[oi:ooo000`ool0
:@000UT2F@0071d005@LK?eTgFcmI=elo7cLO?b=GHemSEfEOIEMUGfEGIflWIbM_:FLYKb]g:gl]Mbe
o;HL]Sbf7;Hl_UfnOKiM_[fnWKjm_Yd00/kl1<Lm0]Ml0/Om00D00;oi003oo`0005Ooo`82F@0W91dL
7E@L001D76CMK?eTgFcmO=alo7cLSGf=GIEmUEfEOIEMUGfMW9flYIbU_:gL[Ob]g;Gl]Mbf?;HL]Sbf
7;im_Ufn_KjM_[fnWKjm00;>o0C7?@;GO0040037oKoi_oT/ool0037oo`0E003oo`0093dT7@00K=e/
oFcMK?e/gFcmSEf=OHeMSGf=GHemUEfEOIEM00ZN?P>nO@Jn_@K7?@C7o@03003oo`0000;oo`03003o
oooo05Koo`040UTT?B@M93d200003VcMK?e/gFcmK=f=OHeMSGf=GHemUEfEOIEMUGd:WSh3_Wd6_[d6
acd2aod00`00aofon@0]ool0037oo`0U003ooooo000T7@0091eE7UDnI=e/oFCMQKj5WXFnQIj=OHeM
SGf=GIhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7[jm_Yfn_KjM_[d00kKn0lLm0kmn0lOm00Coo`00ool0
00;oo`03003ooooo05Ooo`0SH00T7A`M91d005DnEAi/oFCMK?f5WXFnQIj5_XeMSGf=GIhnWQjN?YhN
WSjN7YhnWQjN?YhNWSjN7Yhn_Yfn_KjM_[fnW@03]_h3acd3_gh00lOm0000000_ool003;oo`0B003o
o`00oomP000093eE7UDnEAiE?XFNQKj5WXFnQIj5_XFN3Yhn1kKn1Kmn0/Om00=V/ooo00000_oo00@0
0?ooool005_oo`0?H003VR@m001E?UDNECiE7XFnQIj5_XFNQKj5WXFn00jN?PJfoPJoOP;7o@03003o
oooo02koo`00<ooo01l00?oo003oof000003^UDNECiE7UDnOImm_gfOOKmmWgfoWQjN?YhNWSjN7Yhn
WQjN?YhNWSjN7YhnWQjN?P06]_h5_gh2Uk/2ool200001Ooo003ooooo0000GOoo0V0001X3^P00ECiE
7UDnEAim_gfOOKmmWgfoOInN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhN1[Kn1Kmn00>G^`000000
<Ooo000dool01@00ool00000ool00P0000X3VTDnAAi5?WfOOKmmWgfoOImm_`bN?PJfoPBW_P:G^`;o
o`800003ool0000000;oo`03003ooooo063oo`0;0015?TDNACi57WfoOImm_gfOOKmmW`0<WSh6]_h4
Ykh2Uk/2000bool003Coo`0L003oooooool00?oo003oo`>JAChm7TDn?AieogGOMOmeggGoWQjN?YhN
WSjN7YhnWQjN?YhNWSh5Ycl4Ykh00dhgool0000300001?oo00000?oo0`00I?oo0`000195?SdNMOme
ggGoMMmeogGOWSjN7YhnWQjN?YhNWSjN7YhnWQh5Ycl4Ykh00dhGooooo`0eool003Goo`06003ooooo
ool00?oo0`0000A5?TDNACi57PE^?`=fO`:N?PB6o`>Fo`Ao?P03ool0000000T006Woo`04ACi57TDn
AAh6KSl3MWl2WSh4Q_l3U_l4Och00ooo003oo`0gool003Koo`8000;oo`8000;oo`8000<35P0:;Ch]
7WIoMUmfOgIOO[mnWgjoOYl4Q_l3Och;001^ool400002bdn;Ah]?WIOMWmfGgIoOYmn_gjOO[l018Ko
0gln?Ooo000hool20002ool20002ool700000ooo?O`mo005?O`<001gool400000ooo?O`mo004?O`0
0`00ooooo`10ool003[oo`04003oooooool40005ool400000ooo0000000400000ooo000000020039
ool003_oo`D000;oo`X000?oo`@00<goo`00@?oo3`00dOoo003ooolQool00?ooob7oo`00oooo8Ooo
003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?oo
ob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo
003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {378.438, 194.5}} -> {-0.603397, \
1.11694, 0.00734241, 0.00734241}, {{102.625, 264.812}, {373.938, 198.875}} -> \
{-0.49866, 1.00964, 0.00663966, 0.00663966}, {{281, 443.188}, {373.938, \
198.875}} -> {-1.44606, 1.00964, 0.00663966, 0.00663966}}]
}, Open  ]],

Cell["\<\
This shows the components of the numerical solution using Euler's \
method (left) and the implicit midpoint rule (right).\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(EulerSolutionPlots\  = \ 
        PlotSolutionComponents[EulerSolution, \ vars, time, 
          DisplayFunction \[Rule] Identity];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(IMPSolutionPlots\  = \ 
        PlotSolutionComponents[IMPSolution, vars, \ time, 
          DisplayFunction \[Rule] Identity];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(Show[
        GraphicsArray[Transpose[{EulerSolutionPlots, \ IMPSolutionPlots}]], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input",
  CellLabel->"In[30]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .94177 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.022423 0.47619 [
[ 0 0 0 0 ]
[ 1 .94177 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .94177 L
0 .94177 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.022423 0.477324 0.302711 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 -2.06162 2.85082 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .0765 -24 -4.5 ]
[-0.0125 .0765 0 4.5 ]
[-0.0125 .21904 -18 -4.5 ]
[-0.0125 .21904 0 4.5 ]
[-0.0125 .36158 -24 -4.5 ]
[-0.0125 .36158 0 4.5 ]
[-0.0125 .50412 -18 -4.5 ]
[-0.0125 .50412 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -41.0625 0 ]
[.5 .63053 41.0625 10.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .0765 m
.00625 .0765 L
s
[(0.75)] -0.0125 .0765 1 0 Mshowa
0 .21904 m
.00625 .21904 L
s
[(0.8)] -0.0125 .21904 1 0 Mshowa
0 .36158 m
.00625 .36158 L
s
[(0.85)] -0.0125 .36158 1 0 Mshowa
0 .50412 m
.00625 .50412 L
s
[(0.9)] -0.0125 .50412 1 0 Mshowa
.125 Mabswid
0 .10501 m
.00375 .10501 L
s
0 .13352 m
.00375 .13352 L
s
0 .16202 m
.00375 .16202 L
s
0 .19053 m
.00375 .19053 L
s
0 .24755 m
.00375 .24755 L
s
0 .27606 m
.00375 .27606 L
s
0 .30456 m
.00375 .30456 L
s
0 .33307 m
.00375 .33307 L
s
0 .39009 m
.00375 .39009 L
s
0 .4186 m
.00375 .4186 L
s
0 .44711 m
.00375 .44711 L
s
0 .47561 m
.00375 .47561 L
s
0 .04799 m
.00375 .04799 L
s
0 .01948 m
.00375 .01948 L
s
0 .53263 m
.00375 .53263 L
s
0 .56114 m
.00375 .56114 L
s
0 .58965 m
.00375 .58965 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.17262 .61178 m
.17262 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.47024 .61178 m
.47024 .61803 L
s
.61905 .61178 m
.61905 .61803 L
s
.76786 .61178 m
.76786 .61803 L
s
.91667 .61178 m
.91667 .61803 L
s
.125 Mabswid
.05357 .61428 m
.05357 .61803 L
s
.08333 .61428 m
.08333 .61803 L
s
.1131 .61428 m
.1131 .61803 L
s
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.23214 .61428 m
.23214 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.29167 .61428 m
.29167 .61803 L
s
.35119 .61428 m
.35119 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.41071 .61428 m
.41071 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.52976 .61428 m
.52976 .61803 L
s
.55952 .61428 m
.55952 .61803 L
s
.58929 .61428 m
.58929 .61803 L
s
.64881 .61428 m
.64881 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.70833 .61428 m
.70833 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.79762 .61428 m
.79762 .61803 L
s
.82738 .61428 m
.82738 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.8869 .61428 m
.8869 .61803 L
s
.94643 .61428 m
.94643 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .0765 m
1 .0765 L
s
.99375 .21904 m
1 .21904 L
s
.99375 .36158 m
1 .36158 L
s
.99375 .50412 m
1 .50412 L
s
.125 Mabswid
.99625 .10501 m
1 .10501 L
s
.99625 .13352 m
1 .13352 L
s
.99625 .16202 m
1 .16202 L
s
.99625 .19053 m
1 .19053 L
s
.99625 .24755 m
1 .24755 L
s
.99625 .27606 m
1 .27606 L
s
.99625 .30456 m
1 .30456 L
s
.99625 .33307 m
1 .33307 L
s
.99625 .39009 m
1 .39009 L
s
.99625 .4186 m
1 .4186 L
s
.99625 .44711 m
1 .44711 L
s
.99625 .47561 m
1 .47561 L
s
.99625 .04799 m
1 .04799 L
s
.99625 .01948 m
1 .01948 L
s
.99625 .53263 m
1 .53263 L
s
.99625 .56114 m
1 .56114 L
s
.99625 .58965 m
1 .58965 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 13.062 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.125 11.562 moveto
(@) show
81.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.125 11.562 moveto
(D) show
99.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(vs) show
117.125 11.562 moveto
(time) show
141.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .47906 m
.06244 .307 L
.07216 .23909 L
.08255 .17675 L
.08852 .14941 L
.09396 .13138 L
.09658 .12519 L
.09805 .12249 L
.09942 .12048 L
.10061 .11915 L
.10192 .11811 L
.10258 .11773 L
.10329 .1175 L
.10458 .11739 L
.10585 .11769 L
.10656 .11801 L
.10721 .11848 L
.10846 .11962 L
.10965 .1211 L
.1123 .12579 L
.11517 .13287 L
.12042 .15099 L
.12524 .17324 L
.14415 .29681 L
.15401 .36955 L
.15943 .40671 L
.16457 .43791 L
.16935 .46204 L
.17187 .47247 L
.17455 .48165 L
.17679 .48782 L
.17798 .49043 L
.17927 .49275 L
.18045 .49441 L
.18152 .4956 L
.18255 .49638 L
.18364 .49676 L
.18486 .49676 L
.18602 .49636 L
.18706 .49563 L
.18818 .49438 L
.18941 .49256 L
.19071 .49014 L
.19303 .48454 L
.1972 .47029 L
.20177 .44907 L
.21202 .38464 L
.22161 .31189 L
.23061 .24253 L
.24019 .17725 L
Mistroke
.2457 .14695 L
.25069 .1254 L
.25311 .11725 L
.25571 .11013 L
.25691 .10751 L
.25817 .10519 L
.25934 .10345 L
.26044 .10212 L
.26176 .10098 L
.26296 .10039 L
.26426 .10024 L
.26499 .10039 L
.26566 .10062 L
.26679 .10136 L
.26803 .10256 L
.26932 .10426 L
.27054 .10629 L
.27332 .11257 L
.27587 .12023 L
.28161 .14365 L
.28629 .16863 L
.29141 .20112 L
.30171 .2786 L
.31267 .36753 L
.323 .44301 L
.32751 .4697 L
.33228 .49212 L
.33477 .50117 L
.33609 .50516 L
.33751 .50877 L
.33881 .51147 L
.34 .5134 L
.34119 .51484 L
.34232 .51578 L
.34348 .51631 L
.34456 .51629 L
.34575 .51577 L
.34704 .51467 L
.34831 .51303 L
.34965 .51069 L
.35204 .50488 L
.35427 .4977 L
.35634 .48959 L
.36104 .46628 L
.37089 .39939 L
.38142 .31206 L
.39165 .22623 L
.39704 .18528 L
.40274 .14761 L
.40773 .12077 L
Mistroke
.41038 .1091 L
.41322 .09877 L
.41583 .09139 L
.41821 .08641 L
.41936 .08458 L
.42061 .08311 L
.42179 .08219 L
.42289 .08173 L
.42418 .08161 L
.42482 .08175 L
.42554 .08205 L
.4268 .08297 L
.42797 .08432 L
.42936 .08645 L
.43062 .08893 L
.43347 .09624 L
.43592 .10443 L
.43858 .11535 L
.44343 .14021 L
.4531 .20637 L
.46204 .28137 L
.47179 .36834 L
.48231 .45367 L
.48714 .48558 L
.48978 .50024 L
.49223 .51199 L
.49451 .52094 L
.49657 .52759 L
.49887 .53296 L
.50013 .5351 L
.50132 .5366 L
.50245 .53745 L
.50351 .53773 L
.50466 .53758 L
.50591 .53689 L
.50721 .53548 L
.50844 .53349 L
.50955 .53115 L
.51076 .52809 L
.51294 .52125 L
.51527 .51189 L
.51945 .49047 L
.52976 .41613 L
.53909 .33223 L
.54928 .23747 L
.56002 .14986 L
.56445 .12072 L
.56919 .09532 L
.57191 .08376 L
.57439 .0752 L
Mistroke
.57558 .07176 L
.57688 .06859 L
.57923 .06432 L
.58039 .06285 L
.58163 .06175 L
.5828 .06125 L
.58387 .06124 L
.58512 .06167 L
.58583 .06208 L
.58649 .06274 L
.58768 .06415 L
.58898 .06626 L
.59033 .06908 L
.5916 .07231 L
.59398 .07978 L
.59931 .10292 L
.60401 .13037 L
.60897 .16576 L
.61786 .24194 L
.62805 .34056 L
.63771 .43198 L
.64638 .50034 L
.65128 .52943 L
.65362 .54019 L
.65582 .54851 L
.65798 .55461 L
.65919 .55728 L
.66031 .55915 L
.66146 .56045 L
.66272 .56121 L
.66404 .56128 L
.66527 .56069 L
.66658 .55936 L
.66781 .55739 L
.66892 .55499 L
.67013 .55179 L
.67283 .54248 L
.67532 .53134 L
.68015 .50279 L
.68547 .46256 L
.69623 .36149 L
.70703 .25068 L
.7173 .15514 L
.72176 .12031 L
.72651 .08922 L
.72924 .07441 L
.73172 .06307 L
.73403 .05451 L
.73533 .05044 L
.73655 .04714 L
Mistroke
.73783 .04429 L
.73899 .04225 L
.74023 .04063 L
.74092 .03992 L
.74156 .0395 L
.74271 .03904 L
.74377 .03897 L
.74493 .03947 L
.74616 .04056 L
.74739 .04219 L
.74871 .04454 L
.7511 .05034 L
.75395 .05999 L
.75655 .07135 L
.76093 .09553 L
.76572 .12873 L
.77537 .21364 L
.78632 .32806 L
.79665 .43654 L
.80592 .5184 L
.80846 .5363 L
.81115 .55266 L
.81367 .56542 L
.81597 .57451 L
.81711 .57818 L
.81835 .58155 L
.81952 .58403 L
.82061 .58566 L
.82176 .58678 L
.82302 .58735 L
.82366 .58736 L
.82435 .58713 L
.82559 .58613 L
.82668 .58456 L
.82788 .58219 L
.83028 .57548 L
.83251 .56675 L
.83459 .55669 L
.83977 .52349 L
.84448 .4848 L
.85505 .37699 L
.86513 .26343 L
.87582 .15219 L
.88494 .07773 L
.88744 .06188 L
.89013 .04721 L
.89248 .03643 L
.89499 .02738 L
.89633 .02352 L
.89754 .02062 L
Mistroke
.89877 .01821 L
.89991 .01654 L
.90056 .01592 L
.90124 .01529 L
.90192 .01497 L
.90267 .01472 L
.90332 .01476 L
.90402 .01494 L
.90528 .01583 L
.90654 .01732 L
.90725 .01837 L
.9079 .01965 L
.91039 .02572 L
.91265 .03348 L
.91506 .04373 L
.91956 .06882 L
.92378 .09877 L
.93341 .18701 L
.95226 .40291 L
.96174 .5044 L
.96711 .55126 L
.96953 .56877 L
.97211 .58468 L
.97619 .60332 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.022423 0.97619 0.302711 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 -3.62471 4.74416 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .07573 -24 -4.5 ]
[-0.0125 .07573 0 4.5 ]
[-0.0125 .17062 -18 -4.5 ]
[-0.0125 .17062 0 4.5 ]
[-0.0125 .2655 -24 -4.5 ]
[-0.0125 .2655 0 4.5 ]
[-0.0125 .36038 -24 -4.5 ]
[-0.0125 .36038 0 4.5 ]
[-0.0125 .45527 -24 -4.5 ]
[-0.0125 .45527 0 4.5 ]
[-0.0125 .55015 -24 -4.5 ]
[-0.0125 .55015 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -41.0625 0 ]
[.5 .63053 41.0625 10.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07573 m
.00625 .07573 L
s
[(0.78)] -0.0125 .07573 1 0 Mshowa
0 .17062 m
.00625 .17062 L
s
[(0.8)] -0.0125 .17062 1 0 Mshowa
0 .2655 m
.00625 .2655 L
s
[(0.82)] -0.0125 .2655 1 0 Mshowa
0 .36038 m
.00625 .36038 L
s
[(0.84)] -0.0125 .36038 1 0 Mshowa
0 .45527 m
.00625 .45527 L
s
[(0.86)] -0.0125 .45527 1 0 Mshowa
0 .55015 m
.00625 .55015 L
s
[(0.88)] -0.0125 .55015 1 0 Mshowa
.125 Mabswid
0 .09945 m
.00375 .09945 L
s
0 .12317 m
.00375 .12317 L
s
0 .1469 m
.00375 .1469 L
s
0 .19434 m
.00375 .19434 L
s
0 .21806 m
.00375 .21806 L
s
0 .24178 m
.00375 .24178 L
s
0 .28922 m
.00375 .28922 L
s
0 .31294 m
.00375 .31294 L
s
0 .33666 m
.00375 .33666 L
s
0 .3841 m
.00375 .3841 L
s
0 .40782 m
.00375 .40782 L
s
0 .43154 m
.00375 .43154 L
s
0 .47899 m
.00375 .47899 L
s
0 .50271 m
.00375 .50271 L
s
0 .52643 m
.00375 .52643 L
s
0 .05201 m
.00375 .05201 L
s
0 .02829 m
.00375 .02829 L
s
0 .00457 m
.00375 .00457 L
s
0 .57387 m
.00375 .57387 L
s
0 .59759 m
.00375 .59759 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.17262 .61178 m
.17262 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.47024 .61178 m
.47024 .61803 L
s
.61905 .61178 m
.61905 .61803 L
s
.76786 .61178 m
.76786 .61803 L
s
.91667 .61178 m
.91667 .61803 L
s
.125 Mabswid
.05357 .61428 m
.05357 .61803 L
s
.08333 .61428 m
.08333 .61803 L
s
.1131 .61428 m
.1131 .61803 L
s
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.23214 .61428 m
.23214 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.29167 .61428 m
.29167 .61803 L
s
.35119 .61428 m
.35119 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.41071 .61428 m
.41071 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.52976 .61428 m
.52976 .61803 L
s
.55952 .61428 m
.55952 .61803 L
s
.58929 .61428 m
.58929 .61803 L
s
.64881 .61428 m
.64881 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.70833 .61428 m
.70833 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.79762 .61428 m
.79762 .61803 L
s
.82738 .61428 m
.82738 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.8869 .61428 m
.8869 .61803 L
s
.94643 .61428 m
.94643 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .07573 m
1 .07573 L
s
.99375 .17062 m
1 .17062 L
s
.99375 .2655 m
1 .2655 L
s
.99375 .36038 m
1 .36038 L
s
.99375 .45527 m
1 .45527 L
s
.99375 .55015 m
1 .55015 L
s
.125 Mabswid
.99625 .09945 m
1 .09945 L
s
.99625 .12317 m
1 .12317 L
s
.99625 .1469 m
1 .1469 L
s
.99625 .19434 m
1 .19434 L
s
.99625 .21806 m
1 .21806 L
s
.99625 .24178 m
1 .24178 L
s
.99625 .28922 m
1 .28922 L
s
.99625 .31294 m
1 .31294 L
s
.99625 .33666 m
1 .33666 L
s
.99625 .3841 m
1 .3841 L
s
.99625 .40782 m
1 .40782 L
s
.99625 .43154 m
1 .43154 L
s
.99625 .47899 m
1 .47899 L
s
.99625 .50271 m
1 .50271 L
s
.99625 .52643 m
1 .52643 L
s
.99625 .05201 m
1 .05201 L
s
.99625 .02829 m
1 .02829 L
s
.99625 .00457 m
1 .00457 L
s
.99625 .57387 m
1 .57387 L
s
.99625 .59759 m
1 .59759 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 13.062 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.125 11.562 moveto
(@) show
81.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.125 11.562 moveto
(D) show
99.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(vs) show
117.125 11.562 moveto
(time) show
141.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .31436 L
.07216 .20507 L
.08255 .106 L
.08852 .06309 L
.09135 .04718 L
.09396 .03518 L
.09658 .02583 L
.09796 .02204 L
.09942 .01887 L
.10069 .01684 L
.10187 .01555 L
.10318 .01481 L
.10391 .01472 L
.10458 .01482 L
.10586 .01556 L
.10701 .01681 L
.10766 .01775 L
.10835 .01896 L
.10961 .02166 L
.11204 .02872 L
.11428 .03735 L
.11943 .06453 L
.12487 .10358 L
.13406 .18929 L
.14415 .30141 L
.15417 .41543 L
.16366 .50958 L
.1689 .55035 L
.17167 .56762 L
.1746 .58248 L
.17706 .59199 L
.17847 .59614 L
.17978 .59918 L
.18099 .60124 L
.18209 .60251 L
.1833 .60323 L
.18458 .60321 L
.18581 .60244 L
.18651 .60167 L
.18715 .60076 L
.18833 .59858 L
.18958 .59554 L
.19174 .58853 L
.19412 .57831 L
.19939 .5471 L
.20432 .5082 L
.22268 .31275 L
.23168 .21127 L
.24126 .11765 L
Mistroke
.24677 .07511 L
.25177 .04558 L
.25418 .03469 L
.25679 .0255 L
.25798 .02221 L
.25925 .01939 L
.26033 .0175 L
.26151 .01598 L
.26219 .01538 L
.26293 .01494 L
.26363 .01474 L
.26428 .01474 L
.2655 .01522 L
.2668 .01642 L
.26747 .01731 L
.26819 .01848 L
.2695 .02115 L
.27105 .02524 L
.27247 .02985 L
.27745 .05234 L
.27995 .06719 L
.28268 .08597 L
.2931 .1784 L
.30279 .28453 L
.31191 .38931 L
.32156 .48978 L
.3266 .53286 L
.32927 .55218 L
.33214 .56972 L
.33477 .58279 L
.33718 .59203 L
.33833 .59551 L
.33959 .59858 L
.34078 .60078 L
.34188 .60222 L
.3431 .60312 L
.34442 .60328 L
.34567 .60265 L
.34681 .60141 L
.34807 .59931 L
.34946 .59613 L
.3509 .59184 L
.35225 .58697 L
.35757 .55975 L
.36056 .53942 L
.36327 .51802 L
.38343 .30527 L
.39274 .20108 L
.40259 .10731 L
.40774 .06934 L
Mistroke
.41047 .05291 L
.41341 .03837 L
.4161 .028 L
.41856 .02108 L
.41974 .01864 L
.42103 .01665 L
.42225 .01541 L
.42338 .01481 L
.42467 .01479 L
.42532 .01505 L
.42603 .01553 L
.42729 .01691 L
.42846 .0188 L
.42985 .02176 L
.43112 .02516 L
.43396 .03516 L
.43641 .04637 L
.43908 .06114 L
.44392 .09452 L
.45359 .18235 L
.46253 .28047 L
.47229 .39242 L
.4828 .50023 L
.48764 .53991 L
.49027 .55804 L
.49272 .57235 L
.495 .58334 L
.49707 .59132 L
.49817 .59477 L
.49937 .59786 L
.50063 .60037 L
.50182 .60204 L
.50295 .60299 L
.50417 .60332 L
.50532 .60297 L
.50637 .60208 L
.5076 .60036 L
.50829 .59907 L
.50893 .59767 L
.51137 .5906 L
.51394 .58015 L
.51626 .56813 L
.52147 .53326 L
.53081 .44788 L
.53959 .35088 L
.55802 .14883 L
.56307 .10426 L
.56847 .06531 L
.57109 .05008 L
.57357 .03809 L
Mistroke
.57578 .02942 L
.57703 .02537 L
.57821 .02215 L
.57947 .01933 L
.58063 .01734 L
.58187 .01583 L
.58255 .01527 L
.58319 .01491 L
.58434 .01472 L
.58539 .01503 L
.58656 .01592 L
.5878 .0175 L
.5885 .01868 L
.58915 .01994 L
.59061 .02343 L
.59325 .03199 L
.59566 .04221 L
.5982 .05545 L
.60825 .12986 L
.61929 .24252 L
.63014 .36692 L
.64042 .47706 L
.6449 .51755 L
.64965 .55337 L
.65213 .56858 L
.65487 .58233 L
.65736 .59196 L
.65857 .59561 L
.6597 .59838 L
.6608 .60049 L
.66197 .6021 L
.66327 .6031 L
.66445 .60331 L
.66569 .60279 L
.66639 .60217 L
.66703 .60139 L
.66821 .59943 L
.66946 .59663 L
.67166 .58991 L
.67372 .5816 L
.67841 .55568 L
.6835 .51783 L
.68814 .47568 L
.6986 .36341 L
.70858 .24878 L
.71922 .13855 L
.72439 .09463 L
.72925 .06111 L
.73362 .0383 L
.73608 .02872 L
Mistroke
.73727 .02498 L
.73834 .02207 L
.73941 .01967 L
.74056 .0176 L
.74178 .01601 L
.74293 .01509 L
.74401 .01473 L
.74516 .01488 L
.74614 .01545 L
.74722 .01655 L
.74848 .01845 L
.74963 .02078 L
.75224 .02803 L
.75453 .03669 L
.75694 .04806 L
.76181 .07755 L
.76633 .11227 L
.77658 .21169 L
.79534 .42379 L
.80048 .47664 L
.80592 .5251 L
.81056 .55859 L
.81318 .5737 L
.81566 .58528 L
.817 .59037 L
.81845 .59498 L
.81977 .59831 L
.82099 .60064 L
.82231 .60234 L
.82306 .60294 L
.82376 .60325 L
.8245 .60331 L
.82518 .60314 L
.82593 .60269 L
.82671 .60192 L
.82794 .60011 L
.82926 .59736 L
.83164 .59034 L
.83447 .57861 L
.83704 .56483 L
.84201 .53067 L
.8474 .48373 L
.8572 .3804 L
.87665 .16402 L
.88198 .11493 L
.88771 .07151 L
.89049 .0545 L
.89312 .04099 L
.89572 .03034 L
.89807 .02302 L
Mistroke
.89924 .02022 L
.90051 .01784 L
.9017 .01621 L
.9028 .01523 L
.90397 .01475 L
.90525 .01488 L
.90589 .01521 L
.90658 .01575 L
.90783 .01725 L
.909 .01924 L
.91027 .02204 L
.91257 .02882 L
.91482 .03749 L
.91689 .04728 L
.92163 .07563 L
.92685 .11587 L
.93743 .21986 L
.97619 .58708 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.330739 0.477324 0.611027 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 0.302199 0.364039 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02917 -30 -4.5 ]
[-0.0125 .02917 0 4.5 ]
[-0.0125 .12018 -24 -4.5 ]
[-0.0125 .12018 0 4.5 ]
[-0.0125 .21119 -30 -4.5 ]
[-0.0125 .21119 0 4.5 ]
[-0.0125 .3022 -6 -4.5 ]
[-0.0125 .3022 0 4.5 ]
[-0.0125 .39321 -24 -4.5 ]
[-0.0125 .39321 0 4.5 ]
[-0.0125 .48422 -18 -4.5 ]
[-0.0125 .48422 0 4.5 ]
[-0.0125 .57523 -24 -4.5 ]
[-0.0125 .57523 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -41.0625 0 ]
[.5 .63053 41.0625 10.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02917 m
.00625 .02917 L
s
[(-0.75)] -0.0125 .02917 1 0 Mshowa
0 .12018 m
.00625 .12018 L
s
[(-0.5)] -0.0125 .12018 1 0 Mshowa
0 .21119 m
.00625 .21119 L
s
[(-0.25)] -0.0125 .21119 1 0 Mshowa
0 .3022 m
.00625 .3022 L
s
[(0)] -0.0125 .3022 1 0 Mshowa
0 .39321 m
.00625 .39321 L
s
[(0.25)] -0.0125 .39321 1 0 Mshowa
0 .48422 m
.00625 .48422 L
s
[(0.5)] -0.0125 .48422 1 0 Mshowa
0 .57523 m
.00625 .57523 L
s
[(0.75)] -0.0125 .57523 1 0 Mshowa
.125 Mabswid
0 .04737 m
.00375 .04737 L
s
0 .06557 m
.00375 .06557 L
s
0 .08378 m
.00375 .08378 L
s
0 .10198 m
.00375 .10198 L
s
0 .13838 m
.00375 .13838 L
s
0 .15658 m
.00375 .15658 L
s
0 .17479 m
.00375 .17479 L
s
0 .19299 m
.00375 .19299 L
s
0 .22939 m
.00375 .22939 L
s
0 .24759 m
.00375 .24759 L
s
0 .2658 m
.00375 .2658 L
s
0 .284 m
.00375 .284 L
s
0 .3204 m
.00375 .3204 L
s
0 .3386 m
.00375 .3386 L
s
0 .35681 m
.00375 .35681 L
s
0 .37501 m
.00375 .37501 L
s
0 .41141 m
.00375 .41141 L
s
0 .42961 m
.00375 .42961 L
s
0 .44781 m
.00375 .44781 L
s
0 .46602 m
.00375 .46602 L
s
0 .50242 m
.00375 .50242 L
s
0 .52062 m
.00375 .52062 L
s
0 .53882 m
.00375 .53882 L
s
0 .55703 m
.00375 .55703 L
s
0 .01097 m
.00375 .01097 L
s
0 .59343 m
.00375 .59343 L
s
0 .61163 m
.00375 .61163 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.17262 .61178 m
.17262 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.47024 .61178 m
.47024 .61803 L
s
.61905 .61178 m
.61905 .61803 L
s
.76786 .61178 m
.76786 .61803 L
s
.91667 .61178 m
.91667 .61803 L
s
.125 Mabswid
.05357 .61428 m
.05357 .61803 L
s
.08333 .61428 m
.08333 .61803 L
s
.1131 .61428 m
.1131 .61803 L
s
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.23214 .61428 m
.23214 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.29167 .61428 m
.29167 .61803 L
s
.35119 .61428 m
.35119 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.41071 .61428 m
.41071 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.52976 .61428 m
.52976 .61803 L
s
.55952 .61428 m
.55952 .61803 L
s
.58929 .61428 m
.58929 .61803 L
s
.64881 .61428 m
.64881 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.70833 .61428 m
.70833 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.79762 .61428 m
.79762 .61803 L
s
.82738 .61428 m
.82738 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.8869 .61428 m
.8869 .61803 L
s
.94643 .61428 m
.94643 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .02917 m
1 .02917 L
s
.99375 .12018 m
1 .12018 L
s
.99375 .21119 m
1 .21119 L
s
.99375 .3022 m
1 .3022 L
s
.99375 .39321 m
1 .39321 L
s
.99375 .48422 m
1 .48422 L
s
.99375 .57523 m
1 .57523 L
s
.125 Mabswid
.99625 .04737 m
1 .04737 L
s
.99625 .06557 m
1 .06557 L
s
.99625 .08378 m
1 .08378 L
s
.99625 .10198 m
1 .10198 L
s
.99625 .13838 m
1 .13838 L
s
.99625 .15658 m
1 .15658 L
s
.99625 .17479 m
1 .17479 L
s
.99625 .19299 m
1 .19299 L
s
.99625 .22939 m
1 .22939 L
s
.99625 .24759 m
1 .24759 L
s
.99625 .2658 m
1 .2658 L
s
.99625 .284 m
1 .284 L
s
.99625 .3204 m
1 .3204 L
s
.99625 .3386 m
1 .3386 L
s
.99625 .35681 m
1 .35681 L
s
.99625 .37501 m
1 .37501 L
s
.99625 .41141 m
1 .41141 L
s
.99625 .42961 m
1 .42961 L
s
.99625 .44781 m
1 .44781 L
s
.99625 .46602 m
1 .46602 L
s
.99625 .50242 m
1 .50242 L
s
.99625 .52062 m
1 .52062 L
s
.99625 .53882 m
1 .53882 L
s
.99625 .55703 m
1 .55703 L
s
.99625 .01097 m
1 .01097 L
s
.99625 .59343 m
1 .59343 L
s
.99625 .61163 m
1 .61163 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 13.062 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.125 11.562 moveto
(@) show
81.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.125 11.562 moveto
(D) show
99.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(vs) show
117.125 11.562 moveto
(time) show
141.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .3022 m
.04262 .21155 L
.06244 .13275 L
.07286 .10244 L
.08255 .08192 L
.08813 .07355 L
.0932 .06806 L
.096 .06592 L
.09759 .06498 L
.09905 .06429 L
.10033 .06383 L
.10173 .06347 L
.10244 .06333 L
.1032 .06325 L
.10392 .0632 L
.10458 .06321 L
.10587 .0633 L
.10708 .0635 L
.10817 .06378 L
.10935 .0642 L
.11199 .06553 L
.11442 .06723 L
.11887 .07157 L
.12357 .07789 L
.12867 .08678 L
.13344 .09698 L
.14429 .12709 L
.15474 .16486 L
.16464 .20768 L
.1832 .30035 L
.20142 .39318 L
.21179 .44028 L
.22153 .47803 L
.23104 .50773 L
.2413 .53133 L
.24664 .54014 L
.24955 .54394 L
.25226 .54684 L
.25477 .54899 L
.25706 .55051 L
.25836 .55118 L
.2596 .55168 L
.2609 .55208 L
.26163 .55226 L
.26231 .55235 L
.26356 .55247 L
.26475 .55247 L
.26582 .55236 L
.26698 .55213 L
.26824 .55176 L
Mistroke
.26959 .55123 L
.272 .54991 L
.27445 .54807 L
.27676 .54589 L
.28107 .54065 L
.28624 .53229 L
.29099 .52263 L
.30171 .49375 L
.31147 .45899 L
.32057 .41987 L
.34125 .31342 L
.35993 .21256 L
.38021 .12121 L
.39127 .08497 L
.39613 .07245 L
.40149 .06102 L
.40653 .05259 L
.41126 .04666 L
.41387 .0442 L
.41625 .04245 L
.4175 .04173 L
.41887 .04109 L
.41956 .04083 L
.4203 .0406 L
.42098 .04041 L
.42163 .04029 L
.42286 .04013 L
.42352 .04009 L
.42422 .0401 L
.42496 .04014 L
.42566 .04024 L
.42697 .04051 L
.4282 .0409 L
.42933 .04138 L
.43189 .04286 L
.43445 .04487 L
.43728 .04774 L
.44301 .05568 L
.44801 .06496 L
.45341 .07743 L
.46318 .10671 L
.47273 .14353 L
.48319 .19242 L
.50428 .30943 L
.52551 .4274 L
.53555 .47455 L
.54481 .51058 L
.55443 .53973 L
.5595 .55163 L
.56487 .56167 L
Mistroke
.56953 .56829 L
.57177 .57076 L
.57389 .57274 L
.57639 .57452 L
.5775 .57515 L
.57868 .57571 L
.57996 .57617 L
.58114 .57647 L
.58187 .57659 L
.58255 .57666 L
.58382 .57669 L
.58499 .5766 L
.58624 .57639 L
.58741 .57606 L
.58849 .57563 L
.59111 .5742 L
.5936 .57232 L
.59617 .56979 L
.59854 .56692 L
.60392 .55862 L
.60818 .55015 L
.61288 .53887 L
.6224 .5096 L
.6325 .4692 L
.64176 .42422 L
.66262 .30321 L
.68316 .18138 L
.69317 .13035 L
.70226 .09155 L
.71175 .05956 L
.7207 .03741 L
.72562 .02849 L
.73015 .02227 L
.73252 .01978 L
.73513 .0176 L
.73644 .01673 L
.73785 .01597 L
.73918 .01542 L
.74039 .01505 L
.74169 .01481 L
.7429 .01472 L
.744 .01472 L
.74518 .01486 L
.74647 .01516 L
.74712 .01537 L
.74783 .01563 L
.7491 .01622 L
.75027 .0169 L
.75259 .01856 L
.7547 .02052 L
Mistroke
.75943 .02636 L
.76454 .03497 L
.77009 .04716 L
.78017 .07704 L
.78961 .11423 L
.8 .16523 L
.82103 .29246 L
.84206 .42491 L
.8613 .52111 L
.8708 .55505 L
.87582 .56924 L
.88117 .58152 L
.88631 .59069 L
.89096 .59681 L
.89321 .59901 L
.89565 .60091 L
.89676 .60159 L
.89795 .60218 L
.89904 .60262 L
.90006 .60295 L
.90128 .6032 L
.90192 .60327 L
.9026 .60332 L
.90375 .60329 L
.90501 .60312 L
.90614 .60287 L
.90734 .60246 L
.90849 .60194 L
.90953 .60136 L
.91189 .59972 L
.91448 .59731 L
.91969 .59058 L
.92428 .58249 L
.92918 .57157 L
.93802 .54565 L
.94744 .50891 L
.95765 .45846 L
.97619 .34368 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.330739 0.97619 0.611027 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 0.309017 0.458783 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03375 -24 -4.5 ]
[-0.0125 .03375 0 4.5 ]
[-0.0125 .1255 -24 -4.5 ]
[-0.0125 .1255 0 4.5 ]
[-0.0125 .21726 -24 -4.5 ]
[-0.0125 .21726 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .40077 -18 -4.5 ]
[-0.0125 .40077 0 4.5 ]
[-0.0125 .49253 -18 -4.5 ]
[-0.0125 .49253 0 4.5 ]
[-0.0125 .58429 -18 -4.5 ]
[-0.0125 .58429 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -41.0625 0 ]
[.5 .63053 41.0625 10.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .03375 m
.00625 .03375 L
s
[(-0.6)] -0.0125 .03375 1 0 Mshowa
0 .1255 m
.00625 .1255 L
s
[(-0.4)] -0.0125 .1255 1 0 Mshowa
0 .21726 m
.00625 .21726 L
s
[(-0.2)] -0.0125 .21726 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0)] -0.0125 .30902 1 0 Mshowa
0 .40077 m
.00625 .40077 L
s
[(0.2)] -0.0125 .40077 1 0 Mshowa
0 .49253 m
.00625 .49253 L
s
[(0.4)] -0.0125 .49253 1 0 Mshowa
0 .58429 m
.00625 .58429 L
s
[(0.6)] -0.0125 .58429 1 0 Mshowa
.125 Mabswid
0 .05669 m
.00375 .05669 L
s
0 .07963 m
.00375 .07963 L
s
0 .10256 m
.00375 .10256 L
s
0 .14844 m
.00375 .14844 L
s
0 .17138 m
.00375 .17138 L
s
0 .19432 m
.00375 .19432 L
s
0 .2402 m
.00375 .2402 L
s
0 .26314 m
.00375 .26314 L
s
0 .28608 m
.00375 .28608 L
s
0 .33196 m
.00375 .33196 L
s
0 .3549 m
.00375 .3549 L
s
0 .37783 m
.00375 .37783 L
s
0 .42371 m
.00375 .42371 L
s
0 .44665 m
.00375 .44665 L
s
0 .46959 m
.00375 .46959 L
s
0 .51547 m
.00375 .51547 L
s
0 .53841 m
.00375 .53841 L
s
0 .56135 m
.00375 .56135 L
s
0 .01081 m
.00375 .01081 L
s
0 .60723 m
.00375 .60723 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.17262 .61178 m
.17262 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.47024 .61178 m
.47024 .61803 L
s
.61905 .61178 m
.61905 .61803 L
s
.76786 .61178 m
.76786 .61803 L
s
.91667 .61178 m
.91667 .61803 L
s
.125 Mabswid
.05357 .61428 m
.05357 .61803 L
s
.08333 .61428 m
.08333 .61803 L
s
.1131 .61428 m
.1131 .61803 L
s
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.23214 .61428 m
.23214 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.29167 .61428 m
.29167 .61803 L
s
.35119 .61428 m
.35119 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.41071 .61428 m
.41071 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.52976 .61428 m
.52976 .61803 L
s
.55952 .61428 m
.55952 .61803 L
s
.58929 .61428 m
.58929 .61803 L
s
.64881 .61428 m
.64881 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.70833 .61428 m
.70833 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.79762 .61428 m
.79762 .61803 L
s
.82738 .61428 m
.82738 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.8869 .61428 m
.8869 .61803 L
s
.94643 .61428 m
.94643 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .03375 m
1 .03375 L
s
.99375 .1255 m
1 .1255 L
s
.99375 .21726 m
1 .21726 L
s
.99375 .30902 m
1 .30902 L
s
.99375 .40077 m
1 .40077 L
s
.99375 .49253 m
1 .49253 L
s
.99375 .58429 m
1 .58429 L
s
.125 Mabswid
.99625 .05669 m
1 .05669 L
s
.99625 .07963 m
1 .07963 L
s
.99625 .10256 m
1 .10256 L
s
.99625 .14844 m
1 .14844 L
s
.99625 .17138 m
1 .17138 L
s
.99625 .19432 m
1 .19432 L
s
.99625 .2402 m
1 .2402 L
s
.99625 .26314 m
1 .26314 L
s
.99625 .28608 m
1 .28608 L
s
.99625 .33196 m
1 .33196 L
s
.99625 .3549 m
1 .3549 L
s
.99625 .37783 m
1 .37783 L
s
.99625 .42371 m
1 .42371 L
s
.99625 .44665 m
1 .44665 L
s
.99625 .46959 m
1 .46959 L
s
.99625 .51547 m
1 .51547 L
s
.99625 .53841 m
1 .53841 L
s
.99625 .56135 m
1 .56135 L
s
.99625 .01081 m
1 .01081 L
s
.99625 .60723 m
1 .60723 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 13.062 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.125 11.562 moveto
(@) show
81.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.125 11.562 moveto
(D) show
99.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(vs) show
117.125 11.562 moveto
(time) show
141.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.04262 .19597 L
.06244 .09892 L
.07286 .06188 L
.08255 .03693 L
.08813 .02681 L
.09076 .02309 L
.0932 .02027 L
.096 .01773 L
.09748 .0167 L
.09905 .01584 L
.0997 .01556 L
.10041 .0153 L
.10168 .01495 L
.10246 .01481 L
.10319 .01474 L
.10386 .01472 L
.10458 .01474 L
.10523 .01481 L
.10591 .01492 L
.10713 .01524 L
.10845 .01574 L
.10989 .01649 L
.11248 .01834 L
.1149 .02066 L
.11941 .02653 L
.12425 .03506 L
.12989 .04791 L
.13522 .06298 L
.14523 .09872 L
.16513 .19615 L
.18355 .3068 L
.20381 .42815 L
.21373 .47985 L
.22282 .52023 L
.2315 .5516 L
.24099 .57748 L
.24593 .58742 L
.25053 .59451 L
.25307 .59753 L
.25538 .59973 L
.25666 .60072 L
.25805 .60162 L
.25936 .60229 L
.26057 .60276 L
.26182 .6031 L
.26301 .60327 L
.26408 .60332 L
.26525 .60324 L
.26651 .603 L
Mistroke
.26721 .6028 L
.26785 .60258 L
.26909 .60203 L
.27027 .60138 L
.27254 .59973 L
.27463 .59777 L
.27934 .59177 L
.28413 .58342 L
.28938 .57167 L
.29997 .53963 L
.31021 .49844 L
.31952 .45294 L
.34045 .33109 L
.36119 .20525 L
.3703 .15575 L
.38035 .1085 L
.38932 .07399 L
.39897 .04555 L
.4043 .03383 L
.40917 .02555 L
.41383 .01982 L
.41617 .01775 L
.4175 .01681 L
.41873 .0161 L
.41997 .01553 L
.42128 .01509 L
.42259 .01482 L
.42334 .01474 L
.42403 .01472 L
.42529 .01479 L
.42644 .01499 L
.42708 .01516 L
.42777 .01539 L
.42903 .01592 L
.43138 .01733 L
.43389 .01942 L
.43838 .02473 L
.44352 .03323 L
.44834 .04359 L
.45934 .07583 L
.46916 .11448 L
.4795 .16444 L
.498 .27122 L
.51794 .39338 L
.53608 .49003 L
.54615 .53235 L
.55566 .56349 L
.56054 .57599 L
.56571 .58666 L
.5684 .59119 L
Mistroke
.57137 .59534 L
.57388 .59816 L
.5752 .5994 L
.5766 .60053 L
.57802 .60148 L
.5793 .60217 L
.58059 .6027 L
.58181 .60305 L
.58304 .60326 L
.58418 .60332 L
.58543 .60324 L
.58675 .60299 L
.58785 .60265 L
.58904 .60216 L
.59117 .60092 L
.59371 .59887 L
.59603 .59644 L
.60117 .58919 L
.60675 .57833 L
.61691 .55067 L
.62632 .51606 L
.6367 .46849 L
.65771 .34921 L
.6787 .22077 L
.68789 .16934 L
.69794 .11995 L
.70706 .08269 L
.7168 .0517 L
.72219 .03857 L
.72708 .02915 L
.72944 .02544 L
.732 .02205 L
.73443 .01943 L
.73664 .01755 L
.739 .01606 L
.74031 .01548 L
.74154 .01508 L
.74268 .01484 L
.74373 .01473 L
.74489 .01473 L
.74612 .01488 L
.74682 .01504 L
.74747 .01522 L
.74894 .01578 L
.75023 .01645 L
.75159 .01733 L
.75395 .01929 L
.75653 .02207 L
.7618 .02974 L
.76743 .041 L
Mistroke
.77758 .06922 L
.78779 .10771 L
.79888 .16013 L
.81902 .27623 L
.83845 .39522 L
.84877 .4528 L
.85987 .50618 L
.87047 .54693 L
.88018 .57467 L
.88484 .58468 L
.88993 .59315 L
.89226 .59617 L
.89474 .5988 L
.89708 .60073 L
.89921 .60202 L
.90041 .60256 L
.90153 .60293 L
.90276 .60319 L
.90408 .60332 L
.90474 .60331 L
.90546 .60326 L
.90677 .60304 L
.90805 .60266 L
.90923 .60216 L
.91135 .60094 L
.9137 .59907 L
.91615 .59654 L
.91845 .59363 L
.92367 .58509 L
.92846 .57487 L
.93926 .54352 L
.9484 .50818 L
.9569 .46852 L
.97619 .35965 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.639056 0.477324 0.919343 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 0.303937 0.506083 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00029 -24 -4.5 ]
[-0.0125 .00029 0 4.5 ]
[-0.0125 .1015 -24 -4.5 ]
[-0.0125 .1015 0 4.5 ]
[-0.0125 .20272 -24 -4.5 ]
[-0.0125 .20272 0 4.5 ]
[-0.0125 .30394 -6 -4.5 ]
[-0.0125 .30394 0 4.5 ]
[-0.0125 .40515 -18 -4.5 ]
[-0.0125 .40515 0 4.5 ]
[-0.0125 .50637 -18 -4.5 ]
[-0.0125 .50637 0 4.5 ]
[-0.0125 .60759 -18 -4.5 ]
[-0.0125 .60759 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -41.0625 0 ]
[.5 .63053 41.0625 10.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00029 m
.00625 .00029 L
s
[(-0.6)] -0.0125 .00029 1 0 Mshowa
0 .1015 m
.00625 .1015 L
s
[(-0.4)] -0.0125 .1015 1 0 Mshowa
0 .20272 m
.00625 .20272 L
s
[(-0.2)] -0.0125 .20272 1 0 Mshowa
0 .30394 m
.00625 .30394 L
s
[(0)] -0.0125 .30394 1 0 Mshowa
0 .40515 m
.00625 .40515 L
s
[(0.2)] -0.0125 .40515 1 0 Mshowa
0 .50637 m
.00625 .50637 L
s
[(0.4)] -0.0125 .50637 1 0 Mshowa
0 .60759 m
.00625 .60759 L
s
[(0.6)] -0.0125 .60759 1 0 Mshowa
.125 Mabswid
0 .02559 m
.00375 .02559 L
s
0 .0509 m
.00375 .0509 L
s
0 .0762 m
.00375 .0762 L
s
0 .12681 m
.00375 .12681 L
s
0 .15211 m
.00375 .15211 L
s
0 .17742 m
.00375 .17742 L
s
0 .22802 m
.00375 .22802 L
s
0 .25333 m
.00375 .25333 L
s
0 .27863 m
.00375 .27863 L
s
0 .32924 m
.00375 .32924 L
s
0 .35455 m
.00375 .35455 L
s
0 .37985 m
.00375 .37985 L
s
0 .43046 m
.00375 .43046 L
s
0 .45576 m
.00375 .45576 L
s
0 .48107 m
.00375 .48107 L
s
0 .53167 m
.00375 .53167 L
s
0 .55698 m
.00375 .55698 L
s
0 .58228 m
.00375 .58228 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.17262 .61178 m
.17262 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.47024 .61178 m
.47024 .61803 L
s
.61905 .61178 m
.61905 .61803 L
s
.76786 .61178 m
.76786 .61803 L
s
.91667 .61178 m
.91667 .61803 L
s
.125 Mabswid
.05357 .61428 m
.05357 .61803 L
s
.08333 .61428 m
.08333 .61803 L
s
.1131 .61428 m
.1131 .61803 L
s
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.23214 .61428 m
.23214 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.29167 .61428 m
.29167 .61803 L
s
.35119 .61428 m
.35119 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.41071 .61428 m
.41071 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.52976 .61428 m
.52976 .61803 L
s
.55952 .61428 m
.55952 .61803 L
s
.58929 .61428 m
.58929 .61803 L
s
.64881 .61428 m
.64881 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.70833 .61428 m
.70833 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.79762 .61428 m
.79762 .61803 L
s
.82738 .61428 m
.82738 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.8869 .61428 m
.8869 .61803 L
s
.94643 .61428 m
.94643 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .00029 m
1 .00029 L
s
.99375 .1015 m
1 .1015 L
s
.99375 .20272 m
1 .20272 L
s
.99375 .30394 m
1 .30394 L
s
.99375 .40515 m
1 .40515 L
s
.99375 .50637 m
1 .50637 L
s
.99375 .60759 m
1 .60759 L
s
.125 Mabswid
.99625 .02559 m
1 .02559 L
s
.99625 .0509 m
1 .0509 L
s
.99625 .0762 m
1 .0762 L
s
.99625 .12681 m
1 .12681 L
s
.99625 .15211 m
1 .15211 L
s
.99625 .17742 m
1 .17742 L
s
.99625 .22802 m
1 .22802 L
s
.99625 .25333 m
1 .25333 L
s
.99625 .27863 m
1 .27863 L
s
.99625 .32924 m
1 .32924 L
s
.99625 .35455 m
1 .35455 L
s
.99625 .37985 m
1 .37985 L
s
.99625 .43046 m
1 .43046 L
s
.99625 .45576 m
1 .45576 L
s
.99625 .48107 m
1 .48107 L
s
.99625 .53167 m
1 .53167 L
s
.99625 .55698 m
1 .55698 L
s
.99625 .58228 m
1 .58228 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 13.062 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.125 11.562 moveto
(@) show
81.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.125 11.562 moveto
(D) show
99.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(vs) show
117.125 11.562 moveto
(time) show
141.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .53349 m
.02499 .53352 L
.02605 .53341 L
.02729 .53313 L
.02846 .53273 L
.02954 .53226 L
.03053 .53169 L
.03279 .53004 L
.03506 .52788 L
.03756 .52489 L
.04262 .51705 L
.04755 .50717 L
.05285 .49431 L
.06244 .466 L
.10458 .2996 L
.12429 .2166 L
.1458 .1353 L
.15577 .10491 L
.16124 .09117 L
.1664 .08047 L
.17121 .0727 L
.17393 .06931 L
.17642 .06687 L
.17853 .06532 L
.17973 .06464 L
.18084 .06416 L
.18202 .06381 L
.1831 .0636 L
.18434 .0635 L
.18551 .06359 L
.18665 .06382 L
.18788 .06423 L
.18904 .06475 L
.1901 .06534 L
.19257 .06725 L
.19517 .06994 L
.20006 .07691 L
.20542 .08723 L
.21496 .11182 L
.22384 .1406 L
.26289 .30213 L
.2828 .38954 L
.30439 .47574 L
.31449 .50888 L
.32002 .524 L
.32519 .53581 L
.32959 .54386 L
.33185 .54723 L
.33432 .5503 L
.33572 .55174 L
Mistroke
.33701 .55287 L
.33836 .55384 L
.33957 .55455 L
.34077 .55509 L
.34189 .55546 L
.34308 .55566 L
.34437 .5557 L
.34561 .55556 L
.34675 .55529 L
.34806 .55479 L
.3493 .55412 L
.3515 .55247 L
.3539 .55011 L
.35653 .54673 L
.35933 .54233 L
.36434 .53242 L
.37437 .50559 L
.38542 .46736 L
.42568 .29174 L
.46442 .12373 L
.47483 .08808 L
.4845 .06236 L
.48938 .05278 L
.49188 .04887 L
.49459 .04544 L
.49614 .04385 L
.49756 .04265 L
.49892 .04172 L
.49962 .04131 L
.50037 .04099 L
.50166 .04055 L
.50286 .0403 L
.5036 .04027 L
.5043 .04027 L
.50561 .04045 L
.50675 .0408 L
.50797 .04135 L
.50913 .04204 L
.51019 .04278 L
.51265 .04511 L
.51525 .04834 L
.52014 .05651 L
.52549 .06846 L
.53503 .09645 L
.54391 .12873 L
.58292 .30472 L
.60281 .39884 L
.62439 .49264 L
.63447 .52902 L
.63999 .54568 L
Mistroke
.64516 .55869 L
.64956 .56753 L
.65182 .57121 L
.65429 .57454 L
.65568 .57608 L
.65698 .57728 L
.65832 .5783 L
.65954 .57903 L
.66073 .57957 L
.66186 .57992 L
.66305 .58008 L
.66434 .58004 L
.66558 .5798 L
.66671 .57942 L
.66802 .57877 L
.66926 .57794 L
.67146 .57594 L
.67385 .57312 L
.67648 .56915 L
.67927 .56402 L
.68429 .55257 L
.69431 .52208 L
.70536 .47931 L
.74558 .28863 L
.78429 .1067 L
.79468 .06739 L
.80434 .03888 L
.80922 .02825 L
.81172 .02394 L
.81443 .02017 L
.81597 .01844 L
.8174 .01713 L
.81876 .01615 L
.81946 .01572 L
.8202 .01538 L
.82149 .01493 L
.8227 .01472 L
.82344 .01472 L
.82414 .01474 L
.82545 .01503 L
.8267 .01553 L
.8274 .01591 L
.82805 .01632 L
.8305 .01839 L
.83272 .02096 L
.83507 .02444 L
.83996 .03391 L
.84531 .04761 L
.85484 .07931 L
.86371 .11539 L
Mistroke
.90269 .30639 L
.92256 .40747 L
.94413 .50972 L
.95222 .54266 L
.9608 .57186 L
.96812 .59066 L
.97013 .59466 L
.97229 .59834 L
.97619 .60332 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.639056 0.97619 0.919343 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 0.309017 0.64882 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .04949 -24 -4.5 ]
[-0.0125 .04949 0 4.5 ]
[-0.0125 .17925 -24 -4.5 ]
[-0.0125 .17925 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .43878 -18 -4.5 ]
[-0.0125 .43878 0 4.5 ]
[-0.0125 .56854 -18 -4.5 ]
[-0.0125 .56854 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -41.0625 0 ]
[.5 .63053 41.0625 10.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .04949 m
.00625 .04949 L
s
[(-0.4)] -0.0125 .04949 1 0 Mshowa
0 .17925 m
.00625 .17925 L
s
[(-0.2)] -0.0125 .17925 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0)] -0.0125 .30902 1 0 Mshowa
0 .43878 m
.00625 .43878 L
s
[(0.2)] -0.0125 .43878 1 0 Mshowa
0 .56854 m
.00625 .56854 L
s
[(0.4)] -0.0125 .56854 1 0 Mshowa
.125 Mabswid
0 .08193 m
.00375 .08193 L
s
0 .11437 m
.00375 .11437 L
s
0 .14681 m
.00375 .14681 L
s
0 .21169 m
.00375 .21169 L
s
0 .24413 m
.00375 .24413 L
s
0 .27658 m
.00375 .27658 L
s
0 .34146 m
.00375 .34146 L
s
0 .3739 m
.00375 .3739 L
s
0 .40634 m
.00375 .40634 L
s
0 .47122 m
.00375 .47122 L
s
0 .50366 m
.00375 .50366 L
s
0 .5361 m
.00375 .5361 L
s
0 .01705 m
.00375 .01705 L
s
0 .60099 m
.00375 .60099 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.17262 .61178 m
.17262 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.47024 .61178 m
.47024 .61803 L
s
.61905 .61178 m
.61905 .61803 L
s
.76786 .61178 m
.76786 .61803 L
s
.91667 .61178 m
.91667 .61803 L
s
.125 Mabswid
.05357 .61428 m
.05357 .61803 L
s
.08333 .61428 m
.08333 .61803 L
s
.1131 .61428 m
.1131 .61803 L
s
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.23214 .61428 m
.23214 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.29167 .61428 m
.29167 .61803 L
s
.35119 .61428 m
.35119 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.41071 .61428 m
.41071 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.52976 .61428 m
.52976 .61803 L
s
.55952 .61428 m
.55952 .61803 L
s
.58929 .61428 m
.58929 .61803 L
s
.64881 .61428 m
.64881 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.70833 .61428 m
.70833 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.79762 .61428 m
.79762 .61803 L
s
.82738 .61428 m
.82738 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.8869 .61428 m
.8869 .61803 L
s
.94643 .61428 m
.94643 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .04949 m
1 .04949 L
s
.99375 .17925 m
1 .17925 L
s
.99375 .30902 m
1 .30902 L
s
.99375 .43878 m
1 .43878 L
s
.99375 .56854 m
1 .56854 L
s
.125 Mabswid
.99625 .08193 m
1 .08193 L
s
.99625 .11437 m
1 .11437 L
s
.99625 .14681 m
1 .14681 L
s
.99625 .21169 m
1 .21169 L
s
.99625 .24413 m
1 .24413 L
s
.99625 .27658 m
1 .27658 L
s
.99625 .34146 m
1 .34146 L
s
.99625 .3739 m
1 .3739 L
s
.99625 .40634 m
1 .40634 L
s
.99625 .47122 m
1 .47122 L
s
.99625 .50366 m
1 .50366 L
s
.99625 .5361 m
1 .5361 L
s
.99625 .01705 m
1 .01705 L
s
.99625 .60099 m
1 .60099 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.062 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 13.062 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.125 11.562 moveto
(@) show
81.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(T) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.125 11.562 moveto
(D) show
99.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(vs) show
117.125 11.562 moveto
(time) show
141.125 11.562 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60323 L
.02605 .60299 L
.02729 .60253 L
.02846 .60191 L
.03053 .60037 L
.03279 .59807 L
.03527 .5948 L
.0379 .59052 L
.04262 .58074 L
.05205 .55397 L
.06244 .51511 L
.10458 .30516 L
.12562 .19455 L
.14487 .10461 L
.15437 .06842 L
.15939 .0524 L
.16474 .03814 L
.16988 .02741 L
.17454 .02043 L
.17679 .01802 L
.17798 .01701 L
.17923 .01615 L
.18032 .01555 L
.18152 .01509 L
.18262 .01482 L
.18364 .01472 L
.1849 .01478 L
.18554 .01489 L
.18624 .01507 L
.18748 .01555 L
.18865 .01618 L
.19001 .01714 L
.19127 .01824 L
.19409 .02145 L
.19891 .02921 L
.20399 .04036 L
.21285 .0664 L
.22255 .10293 L
.26311 .30445 L
.28184 .40366 L
.30215 .50147 L
.31326 .54542 L
.31814 .56154 L
.3235 .5766 L
.32856 .58796 L
.33329 .59585 L
.3359 .59903 L
.33828 .60118 L
.3396 .60205 L
Mistroke
.3403 .60242 L
.34104 .60274 L
.34175 .60299 L
.34239 .60315 L
.34365 .60331 L
.34486 .60327 L
.34598 .60306 L
.34722 .60265 L
.34854 .60198 L
.34993 .60103 L
.35124 .59991 L
.3537 .59721 L
.35813 .59046 L
.36294 .58047 L
.37377 .54888 L
.38377 .51042 L
.42309 .31423 L
.46089 .12255 L
.47034 .08365 L
.48028 .05041 L
.48548 .03687 L
.48824 .03091 L
.49117 .02554 L
.49388 .02151 L
.49634 .01865 L
.49753 .01754 L
.49882 .01654 L
.50003 .0158 L
.50115 .01529 L
.50241 .0149 L
.5036 .01473 L
.50467 .01473 L
.50584 .01491 L
.5071 .0153 L
.50774 .01558 L
.50845 .01594 L
.51087 .01769 L
.51312 .01999 L
.51555 .0232 L
.51995 .03083 L
.52519 .0429 L
.53072 .05877 L
.5406 .0942 L
.57868 .27968 L
.5999 .39257 L
.61921 .4875 L
.62883 .52818 L
.63927 .56436 L
.64405 .57749 L
.64912 .58866 L
Mistroke
.65345 .59581 L
.65592 .59883 L
.65822 .60098 L
.65947 .60185 L
.66015 .60224 L
.6608 .60256 L
.66205 .60302 L
.66319 .60325 L
.66385 .60331 L
.66455 .60331 L
.66579 .60316 L
.66649 .60298 L
.66714 .60276 L
.66861 .60205 L
.66989 .60121 L
.6711 .60022 L
.67338 .59786 L
.67582 .59458 L
.67848 .59018 L
.68315 .58045 L
.68811 .56743 L
.69701 .538 L
.7165 .4533 L
.73478 .35963 L
.77349 .15767 L
.79355 .07267 L
.80363 .04187 L
.80934 .02916 L
.8121 .02436 L
.81465 .02079 L
.81711 .0181 L
.81836 .01703 L
.81971 .0161 L
.82041 .01571 L
.82105 .01541 L
.82231 .01497 L
.82302 .01482 L
.82379 .01473 L
.82451 .01472 L
.82518 .01476 L
.82649 .01502 L
.82771 .01547 L
.82881 .01604 L
.83 .01683 L
.83267 .01926 L
.83512 .0223 L
.83944 .02945 L
.84417 .0398 L
.85371 .06794 L
.87328 .14884 L
Mistroke
.89421 .25485 L
.91408 .36086 L
.93564 .47014 L
.94572 .51487 L
.9564 .55473 L
.96552 .58055 L
.9707 .5912 L
.97556 .59823 L
.97619 .59893 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[30]:=",
  ImageSize->{288, 271.188},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00013a000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
9_oo0P002ooo0`002?oo10000ooo0P001Ooo10000_oo0`001Ooo10000ooo0P001Ooo10000_oo0`00
1_oo0P001?oo0P00=_oo0P002ooo0`002?oo10000ooo0P001Ooo10000_oo0`001Ooo10000ooo0P00
1Ooo10000_oo0`001ooo0P001?oo0P004Ooo000Uool01000ooooo`003Ooo00<00?ooool01ooo00D0
0?ooooooo`0000;oo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00;oo`03003ooooo00?o
o`04003ooooo0004ool00`00ooooo`06ool00`00ooooo`02ool01000ooooo`000_oo00@00?ooool0
03Coo`04003ooooo000=ool00`00ooooo`07ool01@00oooooooo00000_oo00<00?ooool01?oo00<0
0?ooool01?oo00<00?ooool00_oo00<00?ooool00ooo00@00?ooool000Coo`03003ooooo00Koo`03
003ooooo00?oo`04003ooooo0002ool01000ooooo`004?oo000Uool01000ooooo`003Ooo00<00?oo
ool01ooo00D00?ooooooo`0000;oo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00?oo`03
003ooooo00;oo`04003ooooo0005ool00`00ooooo`05ool00`00ooooo`05ool01000ooooo`000_oo
00<00?ooool0<_oo00@00?ooool000goo`03003ooooo00Ooo`05003oooooool00002ool00`00oooo
o`04ool00`00ooooo`04ool00`00ooooo`03ool00`00ooooo`02ool01000ooooo`001Ooo00<00?oo
ool01Ooo00<00?ooool01_oo00@00?ooool000;oo`03003ooooo00koo`009Ooo00@00?ooool000[o
o`<000[oo`05003oooooool00002ool00`00ooooo`04ool01000oooooooo0`001ooo00D00?oooooo
o`0000;oo`03003ooooo00Coo`04003oooooool30006ool20003ool01000ooooo`00=?oo00@00?oo
ool000[oo`<000[oo`05003oooooool00002ool00`00ooooo`04ool01000oooooooo0`001ooo00D0
0?ooooooo`0000;oo`03003ooooo00Coo`04003oooooool30007ool20003ool01000ooooo`004?oo
000Uool01000ooooo`002_oo00<00?ooool02_oo00D00?ooooooo`0000;oo`03003ooooo00Coo`05
003oooooool0000:ool01000ooooo`000_oo00<00?ooool01Ooo00@00?ooool000[oo`04003ooooo
0002ool00`00ooooo`0bool01000ooooo`002_oo00<00?ooool02_oo00D00?ooooooo`0000;oo`03
003ooooo00Coo`05003oooooool0000:ool01000ooooo`000_oo00<00?ooool01Ooo00@00?ooool0
00_oo`04003ooooo0002ool00`00ooooo`0>ool002Goo`04003ooooo000:ool00`00ooooo`08ool3
0003ool01000ooooo`001?oo0`000ooo00<00?ooool01Ooo00@00?ooool000;oo`04003ooooo0004
ool01000ooooo`000_oo00<00?ooool01Ooo00@00?ooool000;oo`04003ooooo000dool01000oooo
o`002_oo00<00?ooool02?oo0`000ooo00@00?ooool000Coo`<000?oo`03003ooooo00Goo`04003o
oooo0002ool01000ooooo`001?oo00@00?ooool000;oo`03003ooooo00Koo`04003ooooo0002ool0
1000ooooo`004?oo000Vool2000;ool40009ool00`00ooooo`02ool20007ool01000oooooooo1000
1Ooo0P001?oo0P001_oo0P000ooo10001Ooo0P001?oo0P00=_oo0P002ooo10002Ooo00<00?ooool0
0_oo0P001ooo00@00?ooooooo`@000Goo`8000Coo`8000Koo`8000?oo`@000Koo`8000Coo`80017o
o`00oooo8Ooo000UoomO000`oomO000=ool002Goo`03003oo`0000goo`03003ooooo00_oo`03003o
oooo00_oo`03003ooooo00_oo`03003ooooo00_oo`03003ooooo00[oo`8000Ooo`03003ooooo02ko
o`03003oo`0000Koo`8000Goo`03003ooooo00Goo`8000Coo`03003ooooo00Ooo`05003oooooool0
000:ool01000ooooo`002ooo00<00?oo00003?oo0`001_oo00<00?ooool02ooo000Uool00`00oooo
o`1Bool20007ool00`00ooooo`0^ool00`00ooooo`06ool2000=ool2000=ool3000<ool3000=ool2
000=ool20007ool00`00ooooo`0;ool002Goo`03003ooooo057oo`03003oo`0000Ooo`03003ooooo
02koo`03003ooooo00Koo`8000goo`8000goo`03003oo`0000coo`03003oo`0000coo`03003oo`00
00goo`8000Ooo`03003ooooo00_oo`009Ooo00<00?ooool0@_oo0`003?oo00<00?oo00001ooo00<0
0?ooool0;_oo00<00?ooool01Ooo00<00?oo00003Ooo0P003Ooo00<00?oo00003?oo00<00?oo0000
3?oo00<00?oo00003?oo00@00?ooool000Koo`03003ooooo00_oo`003Ooo0P001?oo00<00?ooool0
0ooo00<00?ooool00_oo0`001?oo00<00?ooool0@_oo00<00?oo00003?oo00<00?oo00001ooo00<0
0?ooool05_oo0P001?oo00<00?ooool00ooo00<00?ooool00ooo0P001?oo00<00?ooool01Ooo00@0
0?ooool000coo`03003oo`0000coo`03003oo`0000coo`03003oo`0000coo`03003oo`0000coo`04
003ooooo0006ool00`00ooooo`0;ool000coo`04003ooooo0009ool00`00ooooo`05ool01@00oooo
oooo0000=Ooo0`003?oo00<00?oo00003?oo00@00?ooool000Koo`03003ooooo01Goo`04003ooooo
0009ool00`00ooooo`02ool01000ooooo`000ooo00<00?ooool01Ooo00@00?ooool000_oo`04003o
oooo000<ool00`00ool0000<ool00`00ool0000<ool01000ooooo`002ooo00@00?ooool000Koo`03
003ooooo00_oo`003?oo00@00?ooool000[oo`03003ooooo00Coo`05003oooooool0000eool00`00
ool0000<ool00`00ool0000;ool01@00oooooooo00001_oo00<00?ooool05Ooo00@00?ooool000[o
o`05003oooooool00002ool01@00oooooooo00001ooo00@00?ooool000_oo`04003ooooo000;ool0
1000ooooo`003?oo00<00?oo00003?oo00@00?ooool000_oo`04003ooooo0006ool00`00ooooo`0;
ool000coo`04003ooooo000:ool01000oooooooo0`001?oo00<00?ooool09?oo0P003Ooo00<00?oo
00002ooo00@00?ooool000_oo`05003oooooool00006ool00`00ooooo`0Eool01000ooooo`002_oo
00<00?ooool00_oo0P001?oo00<00?ooool01Ooo00@00?ooool000_oo`04003ooooo000;ool01@00
oooooooo00002ooo00<00?oo00002ooo00D00?ooooooo`0000_oo`04003ooooo0006ool00`00oooo
o`0;ool000coo`04003ooooo000;ool01000ooooo`001_oo00<00?ooool05Ooo0P003Ooo00<00?oo
00003?oo00<00?oo00002ooo00D00?ooooooo`0000[oo`05003oooooool00006ool00`00ooooo`0E
ool01000ooooo`002ooo00@00?ooool000;oo`05003oooooool00006ool01@00oooooooo00002ooo
00@00?ooool000_oo`05003oooooool0000:ool01@00oooooooo00002_oo00D00?ooooooo`0000_o
o`04003ooooo0006ool00`00ooooo`0;ool000coo`04003ooooo0008ool01000ooooo`000_oo00<0
0?ooool01?oo00<00?ooool05Ooo0P003?oo00@00?ooool000coo`03003oo`0000_oo`05003ooooo
ool0000:ool01@00oooooooo00001_oo00<00?ooool05Ooo00@00?ooool000Soo`04003ooooo0002
ool01000ooooo`000ooo00<00?ooool01?oo00D00?ooooooo`0000_oo`04003ooooo000;ool01@00
oooooooo00002_oo00D00?ooooooo`0000[oo`05003oooooool0000:ool00`00ooooo`02ool00`00
ooooo`03ool00`00ooooo`0;ool000goo`8000Woo`@000;oo`@000?oo`03003ooooo00Koo`8000go
o`<000_oo`04003ooooo000;ool01000ooooo`002ooo00D00?ooooooo`0000[oo`05003oooooool0
0006ool00`00ooooo`0Fool20009ool40003ool20004ool00`00ooooo`04ool01@00oooooooo0000
2ooo00@00?ooool000_oo`05003oooooool0000:ool01@00oooooooo00002_oo00D00?ooooooo`00
00[oo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00_oo`009Ooo00<00?ooool01Ooo0`00
3?oo00@00?ooool000_oo`04003ooooo000;ool01@00oooooooo00002_oo00D00?ooooooo`0000[o
o`05003oooooool00006ool00`00ooooo`0^ool00`00ooooo`04ool01@00oooooooo00002ooo00@0
0?ooool000_oo`05003oooooool0000:ool01@00oooooooo00002_oo00D00?ooooooo`0000[oo`03
003ooooo00;oo`03003ooooo00?oo`03003ooooo00_oo`009Ooo00<00?ooool01Ooo00<00?oo0000
3?oo00@00?ooool000_oo`05003oooooool0000:ool01@00oooooooo00002_oo00D00?ooooooo`00
00[oo`05003oooooool00006ool00`00ooooo`0^ool00`00ooooo`04ool01@00oooooooo00002ooo
00D00?ooooooo`0000[oo`05003oooooool0000:ool01@00oooooooo00002_oo00D00?ooooooo`00
00[oo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00_oo`009Ooo00<00?ooool01Ooo00@0
0?ooool000_oo`04003ooooo000;ool01@00oooooooo00002_oo00D00?ooooooo`0000[oo`05003o
ooooool0000:ool00`00ooooo`02ool00`00ooooo`03ool00`00ooooo`0Lool20004ool00`00oooo
o`03ool20004ool00`00ooooo`04ool01@00oooooooo00002ooo00D00?ooooooo`0000[oo`03003o
oooo00;oo`03003ooooo00Ooo`05003oooooool0000:ool01@00oooooooo00002_oo00<00?ooool0
0_oo00<00?ooool00ooo00<00?ooool02ooo000Uool00`00ooooo`05ool01000ooooo`002ooo00@0
0?ooool000_oo`05003oooooool0000:ool01@00oooooooo00002_oo00D00?ooooooo`0000[oo`03
003ooooo00;oo`03003ooooo00?oo`03003ooooo01_oo`04003ooooo0008ool01000ooooo`000ooo
00<00?ooool00ooo00<00?ooool00ooo00<00?ooool02?oo00D00?ooooooo`0000Woo`03003ooooo
00?oo`03003ooooo00Ooo`05003oooooool0000:ool01@00oooooooo00002_oo00<00?ooool00_oo
00<00?ooool00ooo00<00?ooool02ooo000Uool00`00ooooo`04ool01@00oooooooo00002_oo00<0
0?ooool00_oo00<00?ooool02?oo00D00?ooooooo`0000[oo`05003oooooool0000:ool01@00oooo
oooo00002_oo00<00?ooool00_oo00<00?ooool00ooo00<00?ooool06ooo00@00?ooool000Soo`04
003ooooo0003ool00`00ooooo`03ool00`00ooooo`03ool00`00ooooo`07ool00`00ooooo`02ool0
0`00ooooo`07ool00`00ooooo`03ool00`00ooooo`07ool01@00oooooooo00002_oo00<00?ooool0
0_oo00<00?ooool01ooo00<00?ooool00_oo00<00?ooool00ooo00<00?ooool02ooo000Uool00`00
ooooo`04ool01@00oooooooo00002_oo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00_oo
00<00?ooool02?oo00D00?ooooooo`0000[oo`03003ooooo00;oo`03003ooooo00Ooo`03003ooooo
00;oo`03003ooooo00?oo`03003ooooo01_oo`04003ooooo0009ool20004ool00`00ooooo`03ool0
0`00ooooo`03ool00`00ooooo`07ool00`00ooooo`02ool00`00ooooo`07ool00`00ooooo`03ool0
0`00ooooo`07ool01@00oooooooo00002_oo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool0
0ooo00<00?ooool00_oo00<00?ooool02ooo000Uool00`00ooooo`04ool01@00oooooooo00002_oo
00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00_oo00<00?ooool02?oo00D00?ooooooo`00
00[oo`03003ooooo00;oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo
01_oo`04003ooooo0008ool01000ooooo`000ooo00<00?ooool00ooo00<00?ooool00ooo00<00?oo
ool01ooo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00ooo00<00?ooool01ooo00<00?oo
ool00_oo00<00?ooool01ooo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00ooo00<00?oo
ool00_oo00<00?ooool02ooo000Cool20004ool00`00ooooo`03ool20004ool00`00ooooo`04ool0
1@00oooooooo00002_oo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00_oo00<00?ooool0
1ooo00<00?ooool00_oo00<00?ooool02?oo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool0
0_oo00<00?ooool00ooo00<00?ooool06ooo00@00?ooool000Soo`04003ooooo0003ool00`00oooo
o`03ool00`00ooooo`03ool00`00ooooo`07ool00`00ooooo`02ool00`00ooooo`07ool00`00oooo
o`03ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00oooo
o`07ool00`00ooooo`03ool00`00ooooo`02ool00`00ooooo`0;ool001;oo`04003ooooo0008ool0
1000ooooo`000ooo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00_oo
00<00?ooool01ooo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00ooo00<00?ooool01_oo
00<00?ooool00ooo00<00?ooool01_oo00<00?ooool00ooo00<00?ooool00ooo00<00?ooool07?oo
0P002_oo0P001?oo00<00?ooool00ooo00<00?ooool00ooo00<00?ooool01ooo00<00?ooool00_oo
00<00?ooool01ooo00<00?ooool00ooo00<00?ooool01_oo00<00?ooool00ooo00<00?ooool01_oo
00<00?ooool00ooo00<00?ooool01ooo00<00?ooool00ooo00<00?ooool00_oo00<00?ooool02ooo
000Bool01000ooooo`002?oo00@00?ooool000?oo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00Koo`03003ooooo00?oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo00Ooo`03003o
oooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo02koo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00Ooo`03003o
oooo00;oo`03003ooooo00Ooo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003o
oooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00Coo`03003ooooo00;oo`03003o
oooo00_oo`004_oo00@00?ooool000Woo`8000Coo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00Koo`03003ooooo00?oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo00Ooo`03003o
oooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo02koo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00Ooo`03003o
oooo00;oo`03003ooooo00Ooo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003o
oooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00Coo`03003ooooo00;oo`03003o
oooo00_oo`004_oo00@00?ooool000Soo`04003ooooo0003ool00`00ooooo`03ool00`00ooooo`03
ool00`00ooooo`06ool00`00ooooo`04ool00`00ooooo`06ool00`00ooooo`02ool00`00ooooo`07
ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03
ool00`00ooooo`03ool00`00ooooo`0Fool20004ool00`00ooooo`03ool20003ool40003ool00`00
ooooo`03ool00`00ooooo`03ool00`00ooooo`07ool00`00ooooo`03ool00`00ooooo`06ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00
ooooo`06ool00`00ooooo`04ool00`00ooooo`02ool00`00ooooo`0;ool001;oo`04003ooooo0008
ool01000ooooo`000ooo00<00?ooool00ooo00<00?ooool00ooo00<00?ooool01_oo00<00?ooool0
1?oo00<00?ooool01_oo00<00?ooool00ooo00<00?ooool01_oo00<00?ooool00ooo00<00?ooool0
1_oo00<00?ooool00ooo00<00?ooool01_oo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool0
5Ooo00@00?ooool000Soo`04003ooooo0002ool00`00ooooo`04ool00`00ooooo`03ool00`00oooo
o`04ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`04ool00`00oooo
o`05ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00oooo
o`04ool00`00ooooo`02ool00`00ooooo`0;ool001?oo`8000[oo`8000Coo`03003ooooo00?oo`03
003ooooo00?oo`03003ooooo00Koo`03003ooooo00Coo`03003ooooo00Koo`03003ooooo00?oo`03
003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03
003ooooo00Coo`03003ooooo00;oo`03003ooooo01Goo`04003ooooo0008ool01000ooooo`000ooo
00<00?ooool00ooo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01_oo00<00?ooool00ooo
00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool00ooo00<00?ooool01_oo
00<00?ooool00ooo00<00?ooool01_oo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool02ooo
000Uool00`00ooooo`03ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00oooo
o`05ool00`00ooooo`04ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00oooo
o`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`02ool00`00ooooo`0Eool01000oooo
o`002Ooo0P001Ooo00<00?ooool00_oo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01Ooo
00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool00ooo
00<00?ooool01_oo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool00_oo
00<00?ooool02ooo000Uool00`00ooooo`02ool00`00ooooo`05ool00`00ooooo`05ool00`00oooo
o`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00oooo
o`06ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`02ool00`00oooo
o`0Eool01000ooooo`002?oo00@00?ooool000Goo`05003oooooool00005ool00`00ooooo`04ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool0
0`00ooooo`03ool00`00ooooo`06ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool0
1@00oooooooo00003Ooo000Uool00`00ooooo`02ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`02ool00`00
ooooo`0Eool01000ooooo`002?oo00@00?ooool000;oo`04003ooooo0003ool00`00ooooo`03ool0
0`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool0
0`00ooooo`05ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`04ool00`00ooooo`05ool0
0`00ooooo`05ool01@00oooooooo00003Ooo000Uool00`00ooooo`02ool00`00ooooo`05ool00`00
ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00
ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00
ooooo`02ool00`00ooooo`0Fool2000:ool20004ool20004ool00`00ooooo`03ool00`00ooooo`04
ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04
ool00`00ooooo`04ool00`00ooooo`06ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05
ool01@00oooooooo00003Ooo000Uool00`00ooooo`02ool00`00ooooo`05ool00`00ooooo`05ool0
0`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool0
0`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`02ool0
0`00ooooo`0^ool00`00ooooo`03ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool0
0`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool0
0`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool01@00oooooooo00003Ooo000Uool00`00
ooooo`02ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`02ool00`00ooooo`0^ool00`00ooooo`03ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00
ooooo`06ool01@00oooooooo00003Ooo000=ool20004ool00`00ooooo`03ool20003ool30004ool0
1@00oooooooo00002Ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool0
1Ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool0
1?oo00<00?ooool01Ooo00<00?ooool00_oo00<00?ooool05_oo0P001?oo00<00?ooool00ooo0P00
1Ooo00<00?ooool00_oo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool0
1?oo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool0
1?oo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool01_oo00D00?ooooooo`0000goo`003?oo
00@00?ooool000Soo`04003ooooo0005ool01@00oooooooo00000ooo00<00?ooool01ooo00<00?oo
ool01?oo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool01?oo00<00?oo
ool01Ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool01Ooo00<00?oo
ool00_oo00<00?ooool05Ooo00@00?ooool000Soo`04003ooooo0004ool00`00ooooo`02ool00`00
ooooo`03ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool00`00
ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00
ooooo`04ool00`00ooooo`06ool01@00oooooooo00003Ooo000<ool01000ooooo`002?oo00@00?oo
ool000Goo`05003oooooool00003ool00`00ooooo`07ool00`00ooooo`03ool00`00ooooo`06ool0
0`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`06ool01@00oooooooo00005ooo00@00?ooool0
00Soo`05003ooooo003oo`050003ool00`00ooooo`02ool00`00ooooo`05ool00`00ooooo`05ool0
0`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`05ool0
0`00ooooo`04ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`06ool01@00oooooooo0000
3Ooo000<ool01000ooooo`002Ooo0P000ooo0`001?oo00D00?ooooooo`0000Woo`03003ooooo00?o
o`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00Coo`03003ooooo00Go
o`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Koo`05003oooooool0
000Gool01000ooooo`002Ooo0P000_oo00@00?ooool000Coo`03003ooooo00;oo`03003ooooo00Ko
o`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00Co
o`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Ko
o`05003oooooool0000=ool000coo`04003ooooo0008ool01000ooooo`000_oo00<00?ooool01?oo
00D00?ooooooo`0000Woo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo
00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo
00Coo`03003ooooo00Koo`05003oooooool0000Gool01000ooooo`002?oo00@00?ooool000;oo`03
003oo`0000Coo`03003ooooo00;oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03
003ooooo00?oo`03003ooooo00Koo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Coo`03
003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`05003oooooool0000=ool000coo`04003o
oooo0008ool01000ooooo`000_oo00<00?ooool01?oo00D00?ooooooo`0000Woo`03003ooooo00?o
o`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Oo
o`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`05003oooooool0
000Gool01000ooooo`002?oo00@00?ooool000?oo`8000Coo`03003ooooo00;oo`03003ooooo00Ko
o`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Koo`03003ooooo00Co
o`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Ko
o`05003oooooool0000=ool000goo`8000[oo`8000?oo`@000?oo`04003ooooo000;ool00`00oooo
o`02ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00oooo
o`07ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool01@00oooo
oooo00006?oo0P002_oo0P001Ooo00<00?ooool00_oo00<00?ooool00_oo00<00?ooool01_oo00<0
0?ooool00ooo00<00?ooool01_oo00<00?ooool00ooo00<00?ooool01_oo00<00?ooool00ooo00<0
0?ooool01_oo00<00?ooool01?oo00<00?ooool01_oo00<00?ooool00ooo00<00?ooool01_oo00D0
0?ooooooo`0000goo`009Ooo00@00?ooool000_oo`03003ooooo00;oo`03003ooooo00Ooo`03003o
oooo00;oo`03003ooooo00Koo`03003ooooo00?oo`03003ooooo00Ooo`03003ooooo00?oo`03003o
oooo00Koo`03003ooooo00?oo`03003ooooo00Koo`05003oooooool0000`ool00`00ooooo`02ool0
0`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool0
0`00ooooo`03ool00`00ooooo`06ool00`00ooooo`04ool00`00ooooo`06ool00`00ooooo`03ool0
0`00ooooo`07ool01000ooooo`003Ooo000Uool01000ooooo`002ooo00D00?ooooooo`0000[oo`03
003ooooo00;oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo00Ooo`03003ooooo00;oo`03
003ooooo00Ooo`03003ooooo00?oo`03003ooooo00Koo`05003oooooool0000`ool00`00ooooo`02
ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`06
ool00`00ooooo`03ool00`00ooooo`06ool00`00ooooo`03ool00`00ooooo`07ool00`00ooooo`03
ool00`00ooooo`07ool01000ooooo`003Ooo000Uool01000ooooo`002ooo00D00?ooooooo`0000[o
o`03003ooooo00;oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo00Ooo`03003ooooo00;o
o`03003ooooo00Ooo`03003ooooo00?oo`03003ooooo00Koo`05003oooooool0000Hool20004ool0
0`00ooooo`03ool20004ool20004ool01@00oooooooo00002Ooo00<00?ooool00ooo00<00?ooool0
1_oo00<00?ooool00ooo00<00?ooool01_oo00<00?ooool00ooo00<00?ooool01ooo00<00?ooool0
0_oo00<00?ooool01ooo00<00?ooool00ooo00<00?ooool01ooo00@00?ooool000goo`009Ooo00@0
0?ooool000_oo`05003oooooool0000:ool01@00oooooooo00002_oo00<00?ooool00_oo00<00?oo
ool01ooo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00_oo00<00?ooool01ooo00D00?oo
ooooo`0001Ooo`04003ooooo0008ool01000ooooo`000_oo00@00?ooool000?oo`05003oooooool0
0009ool00`00ooooo`03ool00`00ooooo`07ool00`00ooooo`02ool00`00ooooo`06ool00`00oooo
o`03ool00`00ooooo`07ool00`00ooooo`02ool00`00ooooo`07ool00`00ooooo`02ool00`00oooo
o`08ool01000ooooo`003Ooo000Uool00`00ool0000=ool01000ooooo`002_oo00D00?ooooooo`00
00[oo`05003oooooool0000:ool00`00ooooo`02ool00`00ooooo`07ool00`00ooooo`02ool00`00
ooooo`07ool01@00oooooooo00005ooo00@00?ooool000Soo`04003ooooo0002ool01000ooooo`00
0ooo00D00?ooooooo`0000Woo`03003ooooo00?oo`03003ooooo00Ooo`03003ooooo00;oo`03003o
oooo00Ooo`03003ooooo00;oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo00Soo`05003o
ooooool0000:ool01000ooooo`003Ooo000Uool00`00ool0000=ool01000ooooo`002ooo00@00?oo
ool000[oo`05003oooooool0000:ool00`00ooooo`02ool00`00ooooo`07ool00`00ooooo`02ool0
0`00ooooo`08ool01000ooooo`005ooo00@00?ooool000Woo`8000?oo`<000Coo`05003oooooool0
000:ool01@00oooooooo00002_oo00<00?ooool00_oo00<00?ooool01ooo00<00?ooool00_oo00<0
0?ooool01ooo00<00?ooool00_oo00<00?ooool02?oo00D00?ooooooo`0000[oo`04003ooooo000=
ool002Goo`03003oo`0000goo`03003oo`0000coo`04003ooooo000;ool01000ooooo`002ooo00D0
0?ooooooo`0000Woo`03003ooooo00;oo`03003ooooo00Soo`04003ooooo000Gool01000ooooo`00
2?oo00@00?ooool000;oo`03003ooooo00Coo`05003oooooool0000:ool01@00oooooooo00002_oo
00D00?ooooooo`0000[oo`03003ooooo00;oo`03003ooooo00Ooo`03003ooooo00;oo`03003ooooo
00Soo`05003oooooool0000:ool01000ooooo`003Ooo000Cool20004ool00`00ooooo`02ool30004
ool00`00ooooo`0=ool00`00ool0000<ool00`00ool0000<ool01000ooooo`002ooo00D00?oooooo
o`0000[oo`05003oooooool0000:ool01000ooooo`005ooo00@00?ooool000Soo`04003ooooo0002
ool00`00ooooo`04ool01@00oooooooo00002_oo00D00?ooooooo`0000[oo`05003oooooool0000:
ool00`00ooooo`02ool00`00ooooo`07ool00`00ooooo`02ool00`00ooooo`08ool01@00oooooooo
00002_oo00@00?ooool000goo`004_oo00@00?ooool000_oo`05003oooooool0000@ool00`00oooo
o`0;ool00`00ool0000<ool01000ooooo`002ooo00@00?ooool000_oo`05003oooooool0000:ool0
1000ooooo`006?oo0P002_oo0P001?oo0`000ooo00@00?ooool000_oo`05003oooooool0000:ool0
1@00oooooooo00002_oo00D00?ooooooo`0000[oo`03003ooooo00;oo`03003ooooo00Soo`05003o
ooooool0000:ool01000ooooo`003Ooo000Bool01000ooooo`002ooo00D00?ooooooo`0001koo`<0
00coo`03003oo`0000coo`04003ooooo000;ool01@00oooooooo00002_oo00@00?ooool0033oo`04
003ooooo000;ool01@00oooooooo00002_oo00D00?ooooooo`0000[oo`05003oooooool0000;ool0
1000ooooo`002ooo00D00?ooooooo`0000[oo`04003ooooo000=ool001;oo`04003ooooo0009ool3
0003ool00`00ooooo`0Mool2000<ool00`00ool0000<ool01000ooooo`002ooo00@00?ooool000_o
o`04003ooooo000`ool01000ooooo`002ooo00D00?ooooooo`0000_oo`04003ooooo000:ool01@00
oooooooo00002ooo00@00?ooool000_oo`05003oooooool0000:ool01000ooooo`003Ooo000Bool0
1000ooooo`002?oo00@00?ooool000?oo`03003ooooo02coo`8000coo`04003ooooo000;ool01000
ooooo`002ooo00@00?ooool001Soo`8000Coo`03003ooooo00?oo`8000Coo`8000Coo`04003ooooo
000;ool01@00oooooooo00002ooo00@00?ooool000_oo`04003ooooo000;ool01000ooooo`002ooo
00D00?ooooooo`0000[oo`04003ooooo000=ool001;oo`04003ooooo0008ool01000ooooo`000ooo
00<00?ooool0;?oo0P003Ooo0P003?oo00@00?ooool000_oo`04003ooooo000Gool01000ooooo`00
2?oo00@00?ooool000;oo`04003ooooo0003ool01000ooooo`003?oo00@00?ooool000_oo`04003o
oooo000;ool01000ooooo`002ooo00@00?ooool000_oo`05003oooooool0000;ool00`00ool0000=
ool001?oo`8000[oo`8000Coo`03003ooooo03_oo`8000coo`04003ooooo000;ool01000ooooo`00
5ooo00@00?ooool000Soo`04003ooooo0002ool01000ooooo`000ooo00@00?ooool000coo`04003o
oooo000;ool01000ooooo`002ooo00@00?ooool000_oo`04003ooooo000<ool01000ooooo`002ooo
00<00?oo00003Ooo000Uool00`00ooooo`0kool2000<ool01000ooooo`002ooo00@00?ooool001Oo
o`04003ooooo0009ool20004ool20004ool01000ooooo`003?oo00@00?ooool000_oo`04003ooooo
000;ool01000ooooo`002ooo00@00?ooool000coo`03003oo`0000coo`03003oo`0000goo`009Ooo
00<00?ooool0B_oo0P003?oo00@00?ooool001Ooo`04003ooooo0008ool01000ooooo`000_oo00@0
0?ooool000?oo`03003oo`0000goo`03003oo`0000coo`04003ooooo000;ool01000ooooo`002ooo
00@00?ooool000coo`03003oo`0000coo`03003oo`0000goo`009Ooo00<00?ooool0B_oo0P003Ooo
00<00?oo00005ooo00@00?ooool000Soo`04003ooooo0002ool01000ooooo`000ooo00<00?oo0000
3Ooo00<00?oo00003?oo00<00?oo00003Ooo0P003Ooo00<00?oo00003?oo00<00?oo00003?oo00<0
0?oo00003Ooo000Uool00`00ooooo`1:ool2000=ool00`00ool0000Hool2000:ool20004ool20004
ool00`00ool0000=ool3000=ool2000=ool2000=ool2000=ool00`00ool0000<ool00`00ool0000=
ool002Goo`03003ooooo05Woo`03003oo`00033oo`03003oo`0000koo`03003ooooo00coo`8000go
o`8000goo`8000goo`8000ooo`03003ooooo00_oo`009Ooo00<00?oo00000_oo00<00?oo00000_oo
00@00?ooool000;oo`04003ooooo0002ool00`00ool00002ool01000ooooo`000_oo00H00?ooool0
0?oo0002ool01000ooooo`000_oo00@00?ooool000;oo`03003oo`0000;oo`04003ooooo0002ool0
1000ooooo`000_oo00<00?oo00000_oo00@00?ooool000;oo`06003ooooo003oo`000_oo00H00?oo
ool00?oo000`ool00`00ool00002ool01P00ooooo`00ool000;oo`04003ooooo0002ool01P00oooo
o`00ool000;oo`04003ooooo0002ool01000ooooo`000_oo00<00?oo00000_oo00@00?ooool000;o
o`04003ooooo0002ool00`00ool00002ool01000ooooo`000_oo00H00?ooool00?oo0002ool01000
ooooo`000_oo00@00?ooool000;oo`03003oo`0000;oo`03003oo`0000goo`009OooG`00<?ooG`00
3Ooo003ooolQool00?ooob7oo`00=?oo0P001_oo0P002?oo0P00Nooo0P001_oo0P002?oo0P00BOoo
000fool00`00ooooo`03ool00`00ooooo`08ool00`00ooooo`1kool00`00ooooo`03ool00`00oooo
o`08ool00`00ooooo`17ool002koo`<000Coo`03003ooooo00Coo`04003oooooool30004ool00`00
ooooo`0:ool01000oooooooo0`002ooo0P000_oo1P0000?oo`00ool00P000_oo0`00@ooo0`001?oo
00<00?ooool01?oo00@00?ooooooo`<000Coo`03003ooooo00[oo`04003oooooool3000;ool20002
ool600000ooo003oo`020002ool3000Gool002ooo`03003ooooo00;oo`8000Koo`03003ooooo00;o
o`03003ooooo00?oo`03003ooooo00Woo`03003oo`0000Goo`03003ooooo00Ooo`04003ooooo0003
ool02000ooooo`00ool00?oo0002ool00`00ooooo`15ool00`00ooooo`02ool20006ool00`00oooo
o`02ool00`00ooooo`03ool00`00ooooo`09ool00`00ool00005ool00`00ooooo`07ool01000oooo
o`000ooo00P00?ooool00?oo003oo`000_oo00<00?ooool06?oo000_ool00`00ooooo`0:ool00`00
ooooo`02ool00`00ooooo`03ool00`00ooooo`09ool00`00ool00003ool2000:ool00`00ooooo`04
ool02000ooooo`00ool00?oo0002ool30015ool00`00ooooo`0:ool00`00ooooo`02ool00`00oooo
o`03ool00`00ooooo`09ool00`00ool00003ool2000:ool00`00ooooo`04ool02000ooooo`00ool0
0?oo0002ool3000Hool002koo`03003oo`0000_oo`03003ooooo00;oo`03003ooooo00?oo`03003o
oooo00Soo`07003oooooool00?oo00003?oo00<00?ooool01?oo00P00?ooool00?oo003oo`000_oo
00@00?ooool004?oo`03003oo`0000_oo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00So
o`07003oooooool00?oo00003?oo00<00?ooool01?oo00P00?ooool00?oo003oo`000_oo00@00?oo
ool001Ooo`00;Ooo00D00?ooooooo`0000[oo`08003ooooo003oo`00ool000?oo`03003ooooo00Oo
o`8000;oo`8000;oo`<000Soo`@000?oo`8000;oo`800003ool00?oo00?oo`8004?oo`05003ooooo
ool0000:ool02000ooooo`00ool00?oo0003ool00`00ooooo`07ool20002ool20002ool30008ool4
0003ool20002ool200000ooo003oo`03ool2000Hool002goo`800003ool0000000[oo`800003ool0
000000<000;oo`8001goo`03003ooooo05Coo`800003ool0000000[oo`800003ool0000000<000;o
o`8001goo`03003ooooo02Woo`00IOoo00<00?ooool01?oo00<00?ooool0QOoo00<00?ooool01?oo
00<00?ooool08_oo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo
003ooolQool00?ooob7oo`00oooo8Ooo000Yool2000;ool30008ool40003ool20005ool40002ool3
0005ool40003ool20005ool40002ool30006ool20004ool2000cool2000;ool30008ool40003ool2
0005ool40002ool30005ool40003ool20005ool40002ool30007ool20004ool2000Aool002Soo`04
003ooooo000=ool00`00ooooo`07ool01@00oooooooo00000_oo00<00?ooool01?oo00<00?ooool0
1?oo00<00?ooool00_oo00<00?ooool00ooo00@00?ooool000Coo`03003ooooo00Koo`03003ooooo
00;oo`04003ooooo0002ool01000ooooo`00<Ooo00@00?ooool000goo`03003ooooo00Ooo`05003o
ooooool00002ool00`00ooooo`04ool00`00ooooo`04ool00`00ooooo`02ool00`00ooooo`03ool0
1000ooooo`001?oo00<00?ooool01_oo00<00?ooool00ooo00@00?ooool000;oo`04003ooooo000@
ool002Soo`04003ooooo000=ool00`00ooooo`07ool01@00oooooooo00000_oo00<00?ooool01?oo
00<00?ooool01?oo00<00?ooool00ooo00<00?ooool00_oo00@00?ooool000Goo`03003ooooo00Go
o`03003ooooo00Goo`04003ooooo0002ool00`00ooooo`0_ool01000ooooo`003Ooo00<00?ooool0
1ooo00D00?ooooooo`0000;oo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00?oo`03003o
oooo00;oo`04003ooooo0005ool00`00ooooo`05ool00`00ooooo`06ool01000ooooo`000_oo00<0
0?ooool03_oo000Xool01000ooooo`002_oo0`002_oo00D00?ooooooo`0000;oo`03003ooooo00Co
o`04003oooooool30007ool01@00oooooooo00000_oo00<00?ooool01?oo00@00?ooooooo`<000Ko
o`8000?oo`04003ooooo000aool01000ooooo`002_oo0`002_oo00D00?ooooooo`0000;oo`03003o
oooo00Coo`04003oooooool30007ool01@00oooooooo00000_oo00<00?ooool01?oo00@00?oooooo
o`<000Ooo`8000?oo`04003ooooo000@ool002Soo`04003ooooo000:ool00`00ooooo`0:ool01@00
oooooooo00000_oo00<00?ooool01?oo00D00?ooooooo`0000[oo`04003ooooo0002ool00`00oooo
o`05ool01000ooooo`002_oo00@00?ooool000;oo`03003ooooo02ooo`04003ooooo000:ool00`00
ooooo`0:ool01@00oooooooo00000_oo00<00?ooool01?oo00D00?ooooooo`0000[oo`04003ooooo
0002ool00`00ooooo`05ool01000ooooo`002ooo00@00?ooool000;oo`03003ooooo00koo`00:?oo
00@00?ooool000[oo`03003ooooo00Soo`<000?oo`04003ooooo0004ool30003ool00`00ooooo`05
ool01000ooooo`000_oo00@00?ooool000Coo`04003ooooo0002ool00`00ooooo`05ool01000oooo
o`000_oo00@00?ooool0037oo`04003ooooo000:ool00`00ooooo`08ool30003ool01000ooooo`00
1?oo0`000ooo00<00?ooool01Ooo00@00?ooool000;oo`04003ooooo0004ool01000ooooo`000_oo
00<00?ooool01_oo00@00?ooool000;oo`04003ooooo000@ool002Woo`8000_oo`@000Woo`03003o
oooo00;oo`8000Ooo`04003oooooool40005ool20004ool20006ool20003ool40005ool20004ool2
000cool2000;ool40009ool00`00ooooo`02ool20007ool01000oooooooo10001Ooo0P001?oo0P00
1_oo0P000ooo10001_oo0P001?oo0P004Ooo003ooolQool002Sooel002gooel000goo`004?oo0P00
1?oo00<00?ooool00ooo00<00?ooool00_oo0`001?oo00<00?oo00000_oo00<00?oo00000_oo00@0
0?ooool000;oo`04003ooooo0002ool00`00ool00002ool01000ooooo`000_oo00H00?ooool00?oo
0002ool01000ooooo`000_oo00@00?ooool000;oo`03003oo`0000;oo`04003ooooo0002ool01000
ooooo`000_oo00<00?oo00000_oo00@00?ooool000;oo`06003ooooo003oo`000_oo00H00?ooool0
0?oo000]ool00`00ool00002ool01P00ooooo`00ool000;oo`04003ooooo0002ool01P00ooooo`00
ool000;oo`04003ooooo0002ool01000ooooo`000_oo00<00?oo00000_oo00@00?ooool000;oo`04
003ooooo0002ool00`00ool00002ool01000ooooo`000_oo00H00?ooool00?oo0002ool01000oooo
o`000_oo00@00?ooool000;oo`03003oo`0000;oo`03003oo`0000goo`003ooo00@00?ooool000Wo
o`03003ooooo00Goo`05003oooooool00014ool3000Fool00`00ooooo`0Iool20004ool00`00oooo
o`03ool20004ool00`00ooooo`06ool3000Kool3000Kool3000Fool00`00ooooo`0;ool000ooo`04
003ooooo000:ool00`00ooooo`04ool01@00oooooooo0000@ooo0P000_oo00<00?ooool04ooo00<0
0?ooool06?oo00@00?ooool000Soo`04003ooooo0003ool00`00ooooo`05ool01000ooooo`006_oo
00@00?ooool001_oo`04003oo`00000Eool00`00ooooo`0;ool000Woo`@000;oo`04003ooooo000:
ool01000oooooooo0`001?oo00<00?ooool09?oo0P006ooo00D00?ooooooo`0001Goo`03003ooooo
01Soo`04003ooooo0008ool01000ooooo`000ooo00<00?ooool01Ooo00@00?ooool001[oo`05003o
ooooool0000Iool01@00oooooooo00005Ooo00<00?ooool02ooo000?ool01000ooooo`002ooo00@0
0?ooool000Koo`03003ooooo02?oo`800003ool00?oo01Woo`03003ooooo00;oo`03003ooooo01;o
o`03003ooooo01;oo`@000;oo`04003ooooo0008ool30004ool00`00ooooo`05ool01@00oooooooo
00006?oo00<00?ooool00_oo00<00?ooool05ooo00D00?ooooooo`0001Goo`03003ooooo00_oo`00
3ooo00@00?ooool000Soo`04003ooooo0002ool00`00ooooo`04ool00`00ooooo`06ool2000Kool0
1@00oooooooo00006?oo00<00?ooool00ooo00<00?ooool04_oo00<00?ooool06?oo00@00?ooool0
00Soo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00;oo`03003ooooo01Koo`03003ooooo
00;oo`03003ooooo01Ooo`03003ooooo00;oo`03003ooooo01;oo`03003ooooo00_oo`004?oo0P00
2Ooo10000_oo10000ooo00<00?ooool01Ooo10006Ooo00<00?ooool00_oo00<00?ooool05_oo00<0
0?ooool00ooo00<00?ooool04_oo00<00?ooool06?oo00@00?ooool000Soo`03003ooooo00Coo`03
003ooooo00Coo`03003ooooo00;oo`03003ooooo01Koo`03003ooooo00?oo`03003ooooo01Goo`03
003ooooo00?oo`03003ooooo01;oo`03003ooooo00_oo`00:?oo00<00?ooool01?oo00D00?oooooo
o`0001Woo`03003ooooo00?oo`03003ooooo01Coo`03003ooooo00Coo`03003ooooo01;oo`03003o
oooo01Woo`8000[oo`<000?oo`03003ooooo00Coo`03003ooooo00;oo`03003ooooo01Koo`03003o
oooo00?oo`03003ooooo01Goo`03003ooooo00?oo`03003ooooo01;oo`03003ooooo00_oo`00:?oo
00<00?ooool01?oo00<00?ooool00_oo00<00?ooool05_oo00<00?ooool00ooo00<00?ooool05?oo
00<00?ooool01?oo00<00?ooool04_oo00<00?ooool0:ooo00<00?ooool00ooo00<00?ooool01?oo
00<00?ooool05Ooo00<00?ooool00ooo00<00?ooool05Ooo00<00?ooool00ooo00<00?ooool04_oo
00<00?ooool02ooo000Fool20004ool00`00ooooo`02ool30004ool00`00ooooo`03ool00`00oooo
o`03ool00`00ooooo`0Fool00`00ooooo`03ool00`00ooooo`0Dool00`00ooooo`05ool00`00oooo
o`0Aool00`00ooooo`0Iool20004ool00`00ooooo`04ool00`00ooooo`02ool00`00ooooo`03ool0
0`00ooooo`04ool00`00ooooo`0Dool00`00ooooo`05ool00`00ooooo`0Dool00`00ooooo`04ool0
0`00ooooo`0Aool00`00ooooo`0;ool001Goo`04003ooooo000;ool01@00oooooooo00001Ooo00<0
0?ooool00ooo00<00?ooool05Ooo00<00?ooool01?oo00<00?ooool05?oo00<00?ooool01Ooo00<0
0?ooool04Ooo00<00?ooool06?oo00@00?ooool000[oo`03003ooooo00;oo`03003ooooo00?oo`03
003ooooo00Coo`03003ooooo01Coo`03003ooooo00Goo`03003ooooo01?oo`03003ooooo00Goo`03
003ooooo017oo`03003ooooo00_oo`005Ooo00@00?ooool000_oo`05003oooooool00004ool00`00
ooooo`05ool00`00ooooo`0Dool00`00ooooo`04ool00`00ooooo`0Cool00`00ooooo`06ool00`00
ooooo`0Aool00`00ooooo`0Hool01000ooooo`001ooo1@000ooo00<00?ooool00ooo00<00?ooool0
1?oo00<00?ooool05?oo00<00?ooool01Ooo00<00?ooool04ooo00<00?ooool01Ooo00<00?ooool0
4Ooo00<00?ooool02ooo000?ool40002ool01000ooooo`002?oo0`001?oo00<00?ooool00_oo00<0
0?ooool01Ooo00<00?ooool05?oo00<00?ooool01Ooo00<00?ooool04_oo00<00?ooool01_oo00<0
0?ooool04Ooo00<00?ooool04_oo10000_oo00@00?ooool000Ooo`04003ooooo0004ool00`00oooo
o`02ool00`00ooooo`06ool00`00ooooo`0Cool00`00ooooo`05ool00`00ooooo`0Cool00`00oooo
o`05ool00`00ooooo`0Aool00`00ooooo`0;ool001Goo`04003ooooo0008ool00`00ooooo`04ool0
0`00ooooo`02ool00`00ooooo`05ool00`00ooooo`0Dool00`00ooooo`05ool00`00ooooo`0Bool0
0`00ooooo`07ool00`00ooooo`0@ool00`00ooooo`0Hool01000ooooo`002?oo00<00?oo00001?oo
00<00?ooool00_oo00<00?ooool01_oo00<00?ooool04_oo00<00?ooool01ooo00<00?ooool04_oo
00<00?ooool01_oo00<00?ooool04?oo00<00?ooool02ooo000Eool01000ooooo`002?oo00<00?oo
ool01?oo00<00?ooool00_oo00<00?ooool01_oo00<00?ooool04_oo00<00?ooool01_oo00<00?oo
ool04_oo00<00?ooool01ooo00<00?ooool04?oo00<00?ooool06?oo00@00?ooool000Woo`8000Co
o`03003ooooo00;oo`03003ooooo00Koo`03003ooooo01;oo`03003ooooo00Ooo`03003ooooo017o
o`03003ooooo00Ooo`03003ooooo013oo`03003ooooo00_oo`005_oo0P002Ooo10000ooo00<00?oo
ool00_oo00<00?ooool01_oo00<00?ooool04_oo00<00?ooool01_oo00<00?ooool04Ooo00<00?oo
ool02?oo00<00?ooool04?oo00<00?ooool06Ooo0P002ooo00<00?ooool00_oo00<00?ooool00_oo
00<00?ooool01_oo00<00?ooool04_oo00<00?ooool01ooo00<00?ooool04Ooo00<00?ooool01ooo
00<00?ooool04?oo00<00?ooool02ooo000Xool01@00oooooooo00002Ooo00<00?ooool04_oo00<0
0?ooool01ooo00<00?ooool04?oo00<00?ooool02?oo00<00?ooool04?oo00<00?ooool0:ooo00D0
0?ooooooo`0000[oo`03003ooooo017oo`03003ooooo00Ooo`03003ooooo017oo`03003ooooo00Oo
o`03003ooooo013oo`03003ooooo00_oo`004?oo0P001?oo00<00?ooool00_oo10000_oo0`001?oo
00D00?ooooooo`0000Woo`03003ooooo01;oo`03003ooooo00Ooo`03003ooooo013oo`03003ooooo
00Soo`03003ooooo013oo`03003ooooo02_oo`05003oooooool0000:ool00`00ooooo`0@ool00`00
ooooo`08ool00`00ooooo`0Aool00`00ooooo`07ool00`00ooooo`0@ool00`00ooooo`0;ool000oo
o`04003ooooo0008ool00`00ooooo`06ool01@00oooooooo00000ooo00<00?ooool02?oo00<00?oo
ool04?oo00<00?ooool02?oo00<00?ooool04?oo00<00?ooool02?oo00<00?ooool04?oo00<00?oo
ool06Ooo0P001?oo00<00?ooool00_oo10000ooo00D00?ooooooo`0000[oo`03003ooooo013oo`03
003ooooo00Woo`03003ooooo00ooo`03003ooooo00Woo`03003ooooo00ooo`03003ooooo00_oo`00
3ooo00@00?ooool000Woo`03003ooooo00Goo`05003oooooool00003ool00`00ooooo`08ool00`00
ooooo`0@ool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`09ool00`00ooooo`0?ool00`00
ooooo`0Hool01000ooooo`002?oo00<00?ooool01?oo00D00?ooooooo`0000[oo`03003ooooo013o
o`03003ooooo00Woo`03003ooooo00ooo`03003ooooo00Woo`03003ooooo00ooo`03003ooooo00_o
o`002Ooo10000_oo00@00?ooool000[oo`04003oooooool30004ool01@00oooooooo00002_oo00<0
0?ooool04?oo00<00?ooool02?oo00<00?ooool03ooo00<00?ooool02_oo00<00?ooool03ooo00<0
0?ooool06?oo00@00?ooool000Woo`03003ooooo00?oo`05003oooooool0000:ool00`00ooooo`0@
ool00`00ooooo`09ool00`00ooooo`0?ool00`00ooooo`09ool00`00ooooo`0?ool00`00ooooo`0;
ool000ooo`04003ooooo000;ool01000ooooo`001_oo00D00?ooooooo`0000[oo`03003ooooo013o
o`03003ooooo00Woo`03003ooooo00koo`03003ooooo00[oo`03003ooooo00ooo`03003ooooo01;o
o`@000;oo`04003ooooo000:ool00`00ooooo`02ool01000ooooo`003?oo00<00?ooool03ooo00<0
0?ooool02Ooo00<00?ooool03ooo00<00?ooool02Ooo00<00?ooool03ooo00<00?ooool02ooo000?
ool01000ooooo`002?oo00@00?ooool000;oo`03003ooooo00Coo`04003ooooo000<ool00`00oooo
o`0?ool00`00ooooo`09ool00`00ooooo`0>ool00`00ooooo`0:ool00`00ooooo`0?ool00`00oooo
o`0Hool01000ooooo`002ooo00D00?ooooooo`0000;oo`03003ooooo00[oo`03003ooooo00ooo`03
003ooooo00Woo`03003ooooo00ooo`03003ooooo00Woo`03003ooooo00ooo`03003ooooo00_oo`00
4?oo0P002_oo0P000ooo10000ooo00@00?ooool000coo`03003ooooo00koo`03003ooooo00[oo`03
003ooooo00koo`03003ooooo00[oo`03003ooooo00ooo`03003ooooo01Soo`04003ooooo0008ool0
1000ooooo`000ooo00@00?ooool000coo`03003ooooo00koo`03003ooooo00_oo`03003ooooo00ko
o`03003ooooo00Woo`03003ooooo00ooo`03003ooooo00_oo`00:?oo00@00?ooool000coo`03003o
oooo00koo`03003ooooo00[oo`03003ooooo00koo`03003ooooo00[oo`03003ooooo00ooo`03003o
oooo01Woo`8000[oo`8000Coo`04003ooooo000<ool00`00ooooo`0>ool00`00ooooo`0;ool00`00
ooooo`0=ool00`00ooooo`0;ool00`00ooooo`0>ool00`00ooooo`0;ool002Soo`04003ooooo000<
ool00`00ooooo`0>ool00`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`0;ool00`00ooooo`0>
ool00`00ooooo`0[ool01000ooooo`003?oo00<00?ooool03_oo00<00?ooool02ooo00<00?ooool0
3Ooo00<00?ooool02ooo00<00?ooool03_oo00<00?ooool02ooo000Rool20004ool00`00ool0000>
ool00`00ooooo`0=ool00`00ooooo`0:ool00`00ooooo`0=ool00`00ooooo`0<ool00`00ooooo`0>
ool00`00ooooo`0[ool01000ooooo`003?oo00<00?ooool03_oo00<00?ooool02ooo00<00?ooool0
3Ooo00<00?ooool02ooo00<00?ooool03_oo00<00?ooool02ooo000Qool01000ooooo`000ooo00<0
0?oo00003_oo00<00?ooool03?oo00<00?ooool03?oo00<00?ooool03?oo00<00?ooool03?oo00<0
0?ooool03_oo00<00?ooool09Ooo0P001?oo00<00?oo00003_oo00<00?ooool03Ooo00<00?ooool0
2ooo00<00?ooool03Ooo00<00?ooool02ooo00<00?ooool03_oo00<00?ooool02ooo000Qool01000
ooooo`000ooo00<00?oo00003_oo00<00?ooool03?oo00<00?ooool03?oo00<00?ooool03?oo00<0
0?ooool03?oo00<00?ooool03_oo00<00?ooool09?oo00@00?ooool000?oo`03003oo`0000koo`03
003ooooo00goo`03003ooooo00_oo`03003ooooo00goo`03003ooooo00_oo`03003ooooo00koo`03
003ooooo00_oo`008Ooo00@00?ooool000?oo`03003ooooo00koo`03003ooooo00coo`03003ooooo
00coo`03003ooooo00coo`03003ooooo00coo`03003ooooo00koo`03003ooooo02Coo`04003ooooo
0003ool00`00ool0000>ool00`00ooooo`0<ool00`00ooooo`0=ool00`00ooooo`0<ool00`00oooo
o`0<ool00`00ooooo`0=ool00`00ooooo`0;ool0027oo`04003ooooo0003ool00`00ooooo`0>ool0
0`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0>ool0
0`00ooooo`0Tool01000ooooo`000ooo00<00?ooool03_oo00<00?ooool03?oo00<00?ooool03Ooo
00<00?ooool02ooo00<00?ooool03Ooo00<00?ooool03Ooo00<00?ooool02ooo000Qool01000oooo
o`000ooo00<00?ooool03ooo00<00?ooool02ooo00<00?ooool03?oo00<00?ooool03?oo00<00?oo
ool03Ooo00<00?ooool03Ooo00<00?ooool09?oo00@00?ooool000?oo`03003ooooo00koo`03003o
oooo00coo`03003ooooo00goo`03003ooooo00_oo`03003ooooo00goo`03003ooooo00goo`03003o
oooo00_oo`008_oo0P001?oo00<00?ooool03ooo00<00?ooool02_oo00<00?ooool03_oo00<00?oo
ool02_oo00<00?ooool03_oo00<00?ooool02ooo00<00?oo00009_oo00@00?ooool000?oo`03003o
oooo00ooo`03003ooooo00_oo`03003ooooo00goo`03003ooooo00_oo`03003ooooo00goo`03003o
oooo00goo`03003ooooo00_oo`00:?oo00<00?ooool03ooo00<00?ooool02_oo00<00?ooool03_oo
00<00?ooool02_oo00<00?ooool03_oo00<00?ooool02ooo00<00?oo00009ooo0P001?oo00<00?oo
ool03ooo00<00?ooool02ooo00<00?ooool03Ooo00<00?ooool02ooo00<00?ooool03Ooo00<00?oo
ool03Ooo00<00?ooool02ooo000Xool00`00ooooo`0?ool00`00ooooo`0:ool00`00ooooo`0>ool0
0`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`0;ool00`00ool0000]ool00`00ooooo`0?ool0
0`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`0;ool00`00ooooo`0=ool00`00ooooo`0;ool0
0`00ool0000=ool0013oo`8000Coo`03003ooooo00;oo`@000;oo`<000Coo`03003ooooo013oo`03
003ooooo00Woo`03003ooooo00koo`03003ooooo00[oo`03003ooooo00koo`03003ooooo00[oo`04
003ooooo000Kool20004ool00`00ooooo`02ool40003ool00`00ooooo`0?ool00`00ooooo`0:ool0
0`00ooooo`0?ool00`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`0:ool00`00ool0000=ool0
00ooo`04003ooooo0008ool00`00ooooo`06ool01@00oooooooo00004_oo00<00?ooool02Ooo00<0
0?ooool03_oo00<00?ooool02_oo00<00?ooool03_oo00<00?ooool02_oo00@00?ooool001[oo`04
003ooooo0008ool00`00ooooo`04ool00`00ooooo`0?ool00`00ooooo`0:ool00`00ooooo`0?ool0
0`00ooooo`09ool00`00ooooo`0?ool00`00ooooo`0:ool00`00ool0000=ool000ooo`04003ooooo
0009ool00`00ooooo`05ool01@00oooooooo00004_oo00<00?ooool02?oo00<00?ooool03ooo00<0
0?ooool02_oo00<00?ooool03ooo00<00?ooool02Ooo00@00?ooool001[oo`04003ooooo0009ool0
0`00ooooo`03ool00`00ooooo`0?ool00`00ooooo`0:ool00`00ooooo`0?ool00`00ooooo`09ool0
0`00ooooo`0?ool00`00ooooo`09ool01000ooooo`003Ooo000?ool01000ooooo`002_oo00@00?oo
ooooo`<000Coo`03003ooooo013oo`03003ooooo00Soo`03003ooooo013oo`03003ooooo00Soo`03
003ooooo013oo`03003ooooo00Woo`04003ooooo000Jool01000ooooo`002_oo00<00?ooool00_oo
00<00?ooool04?oo00<00?ooool02Ooo00<00?ooool03ooo00<00?ooool02Ooo00<00?ooool03ooo
00<00?ooool02Ooo00@00?ooool000goo`003ooo00@00?ooool000_oo`04003ooooo0006ool00`00
ooooo`0@ool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`08ool00`00ooooo`0@ool00`00
ooooo`09ool01000ooooo`006_oo00@00?ooool000_oo`05003oooooool0000Bool00`00ooooo`09
ool00`00ooooo`0?ool00`00ooooo`09ool00`00ooooo`0?ool00`00ooooo`09ool01000ooooo`00
3Ooo000?ool01000ooooo`002?oo00@00?ooool000;oo`03003ooooo00Coo`03003ooooo017oo`03
003ooooo00Ooo`03003ooooo013oo`03003ooooo00Soo`03003ooooo013oo`03003ooooo00Woo`04
003ooooo000Jool01000ooooo`002?oo00@00?ooool000?oo`03003ooooo013oo`03003ooooo00So
o`03003ooooo013oo`03003ooooo00Woo`03003ooooo013oo`03003ooooo00Soo`04003ooooo000=
ool0013oo`8000[oo`8000?oo`@000?oo`03003ooooo017oo`03003ooooo00Ooo`03003ooooo013o
o`03003ooooo00Soo`03003ooooo013oo`03003ooooo00Soo`05003oooooool0000Kool2000:ool2
0004ool00`00ooooo`0@ool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`09ool00`00oooo
o`0@ool00`00ooooo`08ool01000ooooo`003Ooo000Xool00`00ooooo`0Aool00`00ooooo`06ool0
0`00ooooo`0Aool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`08ool01@00oooooooo0000
;Ooo00<00?ooool04?oo00<00?ooool02?oo00<00?ooool04Ooo00<00?ooool01ooo00<00?ooool0
4Ooo00<00?ooool01ooo00D00?ooooooo`0000goo`005_oo0P001?oo00<00?ooool00_oo0`001?oo
00<00?ooool04Ooo00<00?ooool01_oo00<00?ooool04_oo00<00?ooool01_oo00<00?ooool04_oo
00<00?ooool01ooo00D00?ooooooo`0002goo`03003ooooo017oo`03003ooooo00Ooo`03003ooooo
017oo`03003ooooo00Ooo`03003ooooo017oo`03003ooooo00Ooo`05003oooooool0000=ool001Go
o`04003ooooo000;ool01@00oooooooo00005?oo00<00?ooool01Ooo00<00?ooool04_oo00<00?oo
ool01_oo00<00?ooool04_oo00<00?ooool01ooo00D00?ooooooo`0001_oo`8000Coo`03003ooooo
00Coo`03003ooooo00;oo`03003ooooo017oo`03003ooooo00Ooo`03003ooooo017oo`03003ooooo
00Ooo`03003ooooo017oo`03003ooooo00Ooo`05003oooooool0000=ool001Goo`04003ooooo000;
ool01@00oooooooo00005?oo00<00?ooool01?oo00<00?ooool04ooo00<00?ooool01_oo00<00?oo
ool04_oo00<00?ooool01ooo00D00?ooooooo`0001[oo`04003ooooo000:ool00`00ooooo`02ool0
0`00ooooo`0Aool00`00ooooo`06ool00`00ooooo`0Bool00`00ooooo`07ool00`00ooooo`0Bool0
0`00ooooo`06ool01@00oooooooo00003Ooo000Eool01000ooooo`002?oo0`001?oo00<00?ooool0
4_oo00<00?ooool01?oo00<00?ooool04ooo00<00?ooool01_oo00<00?ooool04_oo00<00?ooool0
1_oo00<00?ooool00_oo00<00?ooool06?oo00@00?ooool000Ooo`D000?oo`03003ooooo017oo`03
003ooooo00Koo`03003ooooo01;oo`03003ooooo00Ooo`03003ooooo01;oo`03003ooooo00Koo`05
003oooooool0000=ool001Goo`04003ooooo0008ool00`00ooooo`04ool00`00ooooo`0Bool00`00
ooooo`04ool00`00ooooo`0Dool00`00ooooo`05ool00`00ooooo`0Cool00`00ooooo`05ool00`00
ooooo`02ool00`00ooooo`0Hool01000ooooo`001ooo00@00?ooool000Coo`03003ooooo017oo`03
003ooooo00Koo`03003ooooo01;oo`03003ooooo00Koo`03003ooooo01?oo`03003ooooo00Koo`05
003oooooool0000=ool001Goo`04003ooooo0008ool00`00ooooo`04ool00`00ooooo`0Bool00`00
ooooo`03ool00`00ooooo`0Eool00`00ooooo`05ool00`00ooooo`0Cool00`00ooooo`05ool00`00
ooooo`02ool00`00ooooo`0Hool01000ooooo`002?oo00<00?oo00001?oo00<00?ooool04_oo00<0
0?ooool01Ooo00<00?ooool04_oo00<00?ooool01_oo00<00?ooool04ooo00<00?ooool01_oo00D0
0?ooooooo`0000goo`005_oo0P002Ooo10000ooo00<00?ooool04_oo00<00?ooool00ooo00<00?oo
ool05Ooo00<00?ooool01Ooo00<00?ooool04ooo00<00?ooool01Ooo00<00?ooool00_oo00<00?oo
ool06?oo00@00?ooool000Woo`8000Coo`03003ooooo01;oo`03003ooooo00Goo`03003ooooo01?o
o`03003ooooo00Goo`03003ooooo01?oo`03003ooooo00Koo`05003oooooool0000=ool002Soo`03
003ooooo01?oo`03003ooooo00;oo`03003ooooo01Koo`03003ooooo00?oo`03003ooooo01Coo`03
003ooooo00Coo`03003ooooo00?oo`03003ooooo01Woo`8000_oo`03003ooooo00;oo`03003ooooo
01;oo`03003ooooo00Coo`03003ooooo01Coo`03003ooooo00Goo`03003ooooo01Coo`03003ooooo
00Coo`03003ooooo00;oo`03003ooooo00_oo`00:?oo00<00?ooool05?oo0P0000?oo`00ool06?oo
00<00?ooool00ooo00<00?ooool05Ooo00<00?ooool00ooo00<00?ooool00ooo00<00?ooool0:ooo
00<00?ooool04ooo00<00?ooool00ooo00<00?ooool05?oo00<00?ooool01?oo00<00?ooool05Ooo
00<00?ooool01?oo00<00?ooool00_oo00<00?ooool02ooo000@ool20004ool00`00ooooo`03ool0
0`00ooooo`02ool30004ool00`00ooooo`0Eool2000Kool01@00oooooooo00006?oo00<00?ooool0
0ooo00<00?ooool00ooo00<00?ooool0:ooo00<00?ooool04ooo00<00?ooool00ooo00<00?ooool0
5Ooo00<00?ooool00ooo00<00?ooool05Ooo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool0
2ooo000?ool01000ooooo`002Ooo00<00?ooool01Ooo00D00?ooooooo`0003Coo`800003ool00?oo
01Woo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo01Woo`8000Coo`03003ooooo00?oo`80
00Coo`03003ooooo01?oo`03003ooooo00;oo`03003ooooo01Koo`03003ooooo00?oo`03003ooooo
01Koo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00_oo`003ooo00@00?ooool000[oo`03
003ooooo00Coo`05003oooooool0000eool3000Jool00`00ooooo`02ool00`00ooooo`03ool00`00
ooooo`0Hool01000ooooo`002?oo00@00?ooool000?oo`03003ooooo01Coo`05003oooooool0000I
ool01@00oooooooo00006Ooo00<00?ooool00_oo00<00?ooool00ooo00<00?ooool02ooo000?ool0
1000ooooo`002_oo00@00?ooooooo`<000Coo`03003ooooo053oo`8000;oo`03003ooooo00Coo`03
003ooooo01Soo`04003ooooo0008ool01000ooooo`000ooo00<00?ooool05?oo00D00?ooooooo`00
01Woo`8000;oo`03003ooooo01Soo`04003ooooo0006ool00`00ooooo`0;ool000ooo`04003ooooo
000;ool01000ooooo`001_oo00<00?ooool0DOoo0`001ooo00<00?ooool06?oo00@00?ooool000So
o`<000Coo`03003ooooo01Coo`@001_oo`<001_oo`@000Koo`03003ooooo00_oo`003ooo00@00?oo
ool000Soo`04003ooooo0002ool00`00ooooo`04ool00`00ool0000=ool00`00ooooo`0;ool00`00
ooooo`0;ool00`00ooooo`0;ool00`00ooooo`0;ool00`00ooooo`0:ool20007ool00`00ooooo`0H
ool01000ooooo`002?oo00<00?ooool01?oo00<00?oo00003Ooo00<00?ooool01Ooo0P001?oo00<0
0?ooool02ooo00<00?ooool02?oo00@00?ooool000goo`03003ooooo00[oo`<000Koo`03003ooooo
00_oo`004?oo0P002Ooo10000_oo10000oooG`006_oo00@00?ooool000Soo`03003ooooo00Cooel0
00goo`00X_oo0P002_oo0`00Kooo003ooolQool003ooo`8000Soo`80083oo`8000Soo`8004Woo`00
=_oo10001Ooo00<00?ooool02?oo00<00?ooool0MOoo10001Ooo00<00?ooool02?oo00<00?ooool0
Aooo000aool30003ool20006ool01000oooooooo0`001?oo00<00?ooool02_oo00@00?ooooooo`<0
00_oo`8000;oo`H00003ool00?oo008000;oo`<0043oo`<000?oo`8000Koo`04003oooooool30004
ool00`00ooooo`0:ool01000oooooooo0`002ooo0P000_oo1P0000?oo`00ool00P000_oo0`005ooo
000bool00`00ooooo`04ool00`00ooooo`03ool00`00ooooo`02ool00`00ooooo`03ool00`00oooo
o`09ool00`00ool00005ool00`00ooooo`07ool01000ooooo`000ooo00P00?ooool00?oo003oo`00
0_oo00<00?ooool0@_oo00<00?ooool01?oo00<00?ooool00ooo00<00?ooool00_oo00<00?ooool0
0ooo00<00?ooool02Ooo00<00?oo00001Ooo00<00?ooool01ooo00@00?ooool000?oo`08003ooooo
003oo`00ool000;oo`03003ooooo01Soo`00<_oo00@00?ooooooo`@000Goo`03003ooooo00;oo`03
003ooooo00?oo`03003ooooo00Woo`03003oo`0000?oo`8000[oo`03003ooooo00Coo`08003ooooo
003oo`00ool000;oo`<004;oo`04003oooooool40005ool00`00ooooo`02ool00`00ooooo`03ool0
0`00ooooo`09ool00`00ool00003ool2000:ool00`00ooooo`04ool02000ooooo`00ool00?oo0002
ool3000Hool0037oo`03003oo`0000_oo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00So
o`07003oooooool00?oo00003?oo00<00?ooool01?oo00P00?ooool00?oo003oo`000_oo00@00?oo
ool0043oo`03003oo`0000_oo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00Soo`07003o
ooooool00?oo00003?oo00<00?ooool01?oo00P00?ooool00?oo003oo`000_oo00@00?ooool001Oo
o`00<?oo00D00?ooooooo`0000[oo`08003ooooo003oo`00ool000?oo`03003ooooo00Ooo`8000;o
o`8000;oo`<000Soo`@000?oo`8000;oo`800003ool00?oo00?oo`80043oo`05003oooooool0000:
ool02000ooooo`00ool00?oo0003ool00`00ooooo`07ool20002ool20002ool30008ool40003ool2
0002ool200000ooo003oo`03ool2000Hool0033oo`800003ool0000000[oo`800003ool0000000<0
00;oo`8001goo`03003ooooo057oo`800003ool0000000[oo`800003ool0000000<000;oo`8001go
o`03003ooooo02Woo`00J?oo00<00?ooool01?oo00<00?ooool0P_oo00<00?ooool01?oo00<00?oo
ool08_oo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool002Koo`8000_oo`<000Soo`@000?oo`8000Goo`@000;o
o`<000Goo`@000?oo`8000Goo`@000;oo`<000Koo`8000Coo`8003Koo`8000_oo`<000Soo`@000?o
o`8000Goo`@000;oo`<000Goo`@000?oo`8000Goo`@000;oo`<000Ooo`8000Coo`80017oo`009Ooo
00@00?ooool000goo`03003ooooo00Ooo`05003oooooool00002ool00`00ooooo`04ool00`00oooo
o`04ool00`00ooooo`02ool00`00ooooo`03ool01000ooooo`001?oo00<00?ooool01_oo00<00?oo
ool00_oo00@00?ooool000;oo`04003ooooo000dool01000ooooo`003Ooo00<00?ooool01ooo00D0
0?ooooooo`0000;oo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00;oo`03003ooooo00?o
o`04003ooooo0004ool00`00ooooo`06ool00`00ooooo`03ool01000ooooo`000_oo00@00?ooool0
013oo`009Ooo00@00?ooool000goo`03003ooooo00Ooo`05003oooooool00002ool00`00ooooo`04
ool00`00ooooo`04ool00`00ooooo`03ool00`00ooooo`02ool01000ooooo`001Ooo00<00?ooool0
1Ooo00<00?ooool01Ooo00@00?ooool000;oo`03003ooooo03;oo`04003ooooo000=ool00`00oooo
o`07ool01@00oooooooo00000_oo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool00ooo00<0
0?ooool00_oo00@00?ooool000Goo`03003ooooo00Goo`03003ooooo00Koo`04003ooooo0002ool0
0`00ooooo`0>ool002Goo`04003ooooo000:ool3000:ool01@00oooooooo00000_oo00<00?ooool0
1?oo00@00?ooooooo`<000Ooo`05003oooooool00002ool00`00ooooo`04ool01000oooooooo0`00
1_oo0P000ooo00@00?ooool003Coo`04003ooooo000:ool3000:ool01@00oooooooo00000_oo00<0
0?ooool01?oo00@00?ooooooo`<000Ooo`05003oooooool00002ool00`00ooooo`04ool01000oooo
oooo0`001ooo0P000ooo00@00?ooool0013oo`009Ooo00@00?ooool000[oo`03003ooooo00[oo`05
003oooooool00002ool00`00ooooo`04ool01@00oooooooo00002_oo00@00?ooool000;oo`03003o
oooo00Goo`04003ooooo000:ool01000ooooo`000_oo00<00?ooool0<_oo00@00?ooool000[oo`03
003ooooo00[oo`05003oooooool00002ool00`00ooooo`04ool01@00oooooooo00002_oo00@00?oo
ool000;oo`03003ooooo00Goo`04003ooooo000;ool01000ooooo`000_oo00<00?ooool03_oo000U
ool01000ooooo`002_oo00<00?ooool02?oo0`000ooo00@00?ooool000Coo`<000?oo`03003ooooo
00Goo`04003ooooo0002ool01000ooooo`001?oo00@00?ooool000;oo`03003ooooo00Goo`04003o
oooo0002ool01000ooooo`00=?oo00@00?ooool000[oo`03003ooooo00Soo`<000?oo`04003ooooo
0004ool30003ool00`00ooooo`05ool01000ooooo`000_oo00@00?ooool000Coo`04003ooooo0002
ool00`00ooooo`06ool01000ooooo`000_oo00@00?ooool0013oo`004ooo0P001?oo00<00?ooool0
0ooo0P001Ooo0P002ooo10002Ooo00<00?ooool00_oo0P001ooo00@00?ooooooo`@000Goo`8000Co
o`8000Koo`8000?oo`@000Goo`8000Coo`8003Koo`8000_oo`@000Woo`03003ooooo00;oo`8000Oo
o`04003oooooool40005ool20004ool20006ool20003ool40006ool20004ool2000Aool001;oo`04
003ooooo0008ool01000ooooo`00o_oo000Bool01000ooooo`002?oo00@00?ooool000?ooel0033o
oel000goo`003?oo10000_oo00@00?ooool000Soo`<000Coo`03003ooooo04[oo`8000ooo`03003o
oooo02koo`03003ooooo00koo`8001coo`8001coo`8000ooo`03003ooooo00_oo`004_oo00@00?oo
ool000Soo`03003ooooo00Coo`03003ooooo04[oo`<000koo`03003ooooo02koo`03003ooooo00go
o`03003oo`0001_oo`@001_oo`03003oo`0000koo`03003ooooo00_oo`004_oo00@00?ooool000So
o`03003ooooo00Coo`03003ooooo04Woo`04003ooooo000>ool00`00ooooo`0Lool20004ool00`00
ooooo`04ool00`00ooooo`02ool00`00ooooo`0<ool01@00oooooooo00006_oo00@00?ooool001[o
o`04003ooooo000>ool00`00ooooo`0;ool001?oo`8000[oo`<000?oo`03003ooooo02_oo`<001_o
o`05003oooooool0000=ool00`00ooooo`0Kool01000ooooo`002_oo00<00?ooool00_oo00<00?oo
ool03?oo00D00?ooooooo`0001[oo`04003ooooo000Jool01@00oooooooo00003Ooo00<00?ooool0
2ooo000Uool00`00ooooo`0[ool01000ooooo`006_oo00D00?ooooooo`0000goo`03003ooooo01_o
o`04003ooooo0007ool50003ool00`00ooooo`0<ool01@00oooooooo00006Ooo00<00?ooool00_oo
00<00?ooool05ooo00D00?ooooooo`0000goo`03003ooooo00_oo`009Ooo00<00?ooool03Ooo0`00
6_oo00D00?ooooooo`0001Woo`03003ooooo00?oo`03003ooooo00[oo`03003ooooo01Goo`@000;o
o`04003ooooo0007ool01000ooooo`001?oo00<00?ooool02ooo00<00?ooool00ooo00<00?ooool0
5_oo00<00?ooool00_oo00<00?ooool05_oo00<00?ooool00ooo00<00?ooool02_oo00<00?ooool0
2ooo000Uool00`00ooooo`0=ool00`00ool0000Jool01@00oooooooo00006Ooo00<00?ooool00ooo
00<00?ooool02_oo00<00?ooool06ooo00@00?ooool000Soo`03003oo`0000Coo`03003ooooo00_o
o`03003ooooo00?oo`03003ooooo01Goo`03003ooooo00?oo`03003ooooo01Koo`03003ooooo00?o
o`03003ooooo00[oo`03003ooooo00_oo`004ooo0P001?oo00<00?ooool01?oo00<00?ooool00_oo
00<00?ooool03?oo00D00?ooooooo`0001Woo`03003ooooo00;oo`03003ooooo01Koo`03003ooooo
00?oo`03003ooooo00[oo`03003ooooo01_oo`04003ooooo0009ool20004ool00`00ooooo`0;ool0
0`00ooooo`03ool00`00ooooo`0Eool00`00ooooo`04ool00`00ooooo`0Eool00`00ooooo`03ool0
0`00ooooo`0:ool00`00ooooo`0;ool001;oo`04003ooooo000:ool00`00ooooo`02ool00`00oooo
o`0<ool01@00oooooooo00006Ooo00<00?ooool00_oo00<00?ooool05Ooo00<00?ooool01?oo00<0
0?ooool02_oo00<00?ooool07?oo0P002ooo00<00?ooool00_oo00<00?ooool02_oo00<00?ooool0
1Ooo00<00?ooool05?oo00<00?ooool01?oo00<00?ooool05Ooo00<00?ooool00ooo00<00?ooool0
2_oo00<00?ooool02ooo000Bool01000ooooo`001ooo1@000ooo00<00?ooool02ooo00<00?ooool0
0ooo00<00?ooool05_oo00<00?ooool00_oo00<00?ooool05Ooo00<00?ooool01?oo00<00?ooool0
2_oo00<00?ooool0;_oo00<00?ooool02_oo00<00?ooool01Ooo00<00?ooool04ooo00<00?ooool0
1Ooo00<00?ooool05?oo00<00?ooool01?oo00<00?ooool02_oo00<00?ooool02ooo000<ool40002
ool01000ooooo`001ooo00@00?ooool000Coo`03003ooooo00_oo`03003ooooo00?oo`03003ooooo
01Goo`03003ooooo00Coo`03003ooooo01Coo`03003ooooo00Coo`03003ooooo00[oo`03003ooooo
02koo`03003ooooo00[oo`03003ooooo00Goo`03003ooooo01?oo`03003ooooo00Goo`03003ooooo
01Coo`03003ooooo00Goo`03003ooooo00Woo`03003ooooo00_oo`004_oo00@00?ooool000Soo`03
003oo`0000Coo`03003ooooo00[oo`03003ooooo00Goo`03003ooooo01Coo`03003ooooo00Coo`03
003ooooo01Coo`03003ooooo00Coo`03003ooooo00[oo`03003ooooo02koo`03003ooooo00[oo`03
003ooooo00Goo`03003ooooo01?oo`03003ooooo00Koo`03003ooooo01?oo`03003ooooo00Goo`03
003ooooo00Woo`03003ooooo00_oo`004_oo00@00?ooool000Woo`8000Coo`03003ooooo00[oo`03
003ooooo00Goo`03003ooooo01Coo`03003ooooo00Coo`03003ooooo01?oo`03003ooooo00Goo`03
003ooooo00[oo`03003ooooo02koo`03003ooooo00[oo`03003ooooo00Koo`03003ooooo01;oo`03
003ooooo00Koo`03003ooooo01?oo`03003ooooo00Goo`03003ooooo00Woo`03003ooooo00_oo`00
4ooo0P002ooo00<00?ooool00_oo00<00?ooool02_oo00<00?ooool01Ooo00<00?ooool05?oo00<0
0?ooool01?oo00<00?ooool04ooo00<00?ooool01_oo00<00?ooool02Ooo00<00?ooool0;_oo00<0
0?ooool02_oo00<00?ooool01_oo00<00?ooool04_oo00<00?ooool01_oo00<00?ooool04_oo00<0
0?ooool01_oo00<00?ooool02Ooo00<00?ooool02ooo000Uool00`00ooooo`09ool00`00ooooo`06
ool00`00ooooo`0Cool00`00ooooo`06ool00`00ooooo`0Bool00`00ooooo`06ool00`00ooooo`09
ool00`00ooooo`0Lool20004ool00`00ooooo`02ool40003ool00`00ooooo`09ool00`00ooooo`07
ool00`00ooooo`0Aool00`00ooooo`07ool00`00ooooo`0Bool00`00ooooo`06ool00`00ooooo`09
ool00`00ooooo`0;ool002Goo`03003ooooo00Woo`03003ooooo00Ooo`03003ooooo01;oo`03003o
oooo00Koo`03003ooooo01;oo`03003ooooo00Koo`03003ooooo00Woo`03003ooooo01_oo`04003o
oooo0008ool00`00ooooo`04ool00`00ooooo`09ool00`00ooooo`07ool00`00ooooo`0Aool00`00
ooooo`08ool00`00ooooo`0Aool00`00ooooo`06ool00`00ooooo`09ool00`00ooooo`0;ool001?o
o`8000Coo`03003ooooo00;oo`@000?oo`03003ooooo00Woo`03003ooooo00Ooo`03003ooooo01;o
o`03003ooooo00Koo`03003ooooo017oo`03003ooooo00Ooo`03003ooooo00Woo`03003ooooo01_o
o`04003ooooo0009ool00`00ooooo`03ool00`00ooooo`09ool00`00ooooo`07ool00`00ooooo`0A
ool00`00ooooo`08ool00`00ooooo`0Aool00`00ooooo`07ool00`00ooooo`08ool00`00ooooo`0;
ool001;oo`04003ooooo0008ool00`00ooooo`04ool00`00ooooo`09ool00`00ooooo`07ool00`00
ooooo`0Bool00`00ooooo`06ool00`00ooooo`0Aool00`00ooooo`08ool00`00ooooo`08ool00`00
ooooo`0Eool40002ool01000ooooo`002_oo00<00?ooool00_oo00<00?ooool02Ooo00<00?ooool0
2?oo00<00?ooool04?oo00<00?ooool02?oo00<00?ooool04?oo00<00?ooool02?oo00<00?ooool0
2?oo00<00?ooool02ooo000Bool01000ooooo`002Ooo00<00?ooool00ooo00<00?ooool02?oo00<0
0?ooool02?oo00<00?ooool04Ooo00<00?ooool02?oo00<00?ooool04?oo00<00?ooool02?oo00<0
0?ooool02?oo00<00?ooool06ooo00@00?ooool000_oo`05003oooooool0000;ool00`00ooooo`08
ool00`00ooooo`0@ool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`08ool00`00ooooo`08
ool00`00ooooo`0;ool000coo`@000;oo`04003ooooo000:ool00`00ooooo`02ool00`00ooooo`08
ool00`00ooooo`08ool00`00ooooo`0Aool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`08
ool00`00ooooo`08ool00`00ooooo`0Kool01000ooooo`002?oo00@00?ooool000?oo`03003ooooo
00Woo`03003ooooo00Soo`03003ooooo013oo`03003ooooo00Woo`03003ooooo00ooo`03003ooooo
00Soo`03003ooooo00Soo`03003ooooo00_oo`004_oo00@00?ooool000_oo`05003oooooool0000:
ool00`00ooooo`08ool00`00ooooo`0Aool00`00ooooo`08ool00`00ooooo`0?ool00`00ooooo`09
ool00`00ooooo`08ool00`00ooooo`0Lool2000:ool20004ool00`00ooooo`08ool00`00ooooo`09
ool00`00ooooo`0?ool00`00ooooo`0:ool00`00ooooo`0?ool00`00ooooo`08ool00`00ooooo`08
ool00`00ooooo`0;ool001;oo`04003ooooo0008ool01000ooooo`000ooo00<00?ooool02?oo00<0
0?ooool02Ooo00<00?ooool04?oo00<00?ooool02?oo00<00?ooool03ooo00<00?ooool02Ooo00<0
0?ooool02?oo00<00?ooool0;_oo00<00?ooool02?oo00<00?ooool02_oo00<00?ooool03_oo00<0
0?ooool02_oo00<00?ooool03ooo00<00?ooool02Ooo00<00?ooool01ooo00<00?ooool02ooo000C
ool2000:ool20004ool00`00ooooo`07ool00`00ooooo`0:ool00`00ooooo`0?ool00`00ooooo`0:
ool00`00ooooo`0>ool00`00ooooo`0:ool00`00ooooo`07ool00`00ooooo`0^ool00`00ooooo`08
ool00`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`0:
ool00`00ooooo`07ool00`00ooooo`0;ool002Goo`03003ooooo00Ooo`03003ooooo00[oo`03003o
oooo00ooo`03003ooooo00[oo`03003ooooo00koo`03003ooooo00[oo`03003ooooo00Ooo`03003o
oooo02koo`03003ooooo00Soo`03003ooooo00[oo`03003ooooo00koo`03003ooooo00_oo`03003o
oooo00goo`03003ooooo00[oo`03003ooooo00Ooo`03003ooooo00_oo`009Ooo00<00?ooool01ooo
00<00?ooool02_oo00<00?ooool03ooo00<00?ooool02_oo00<00?ooool03Ooo00<00?ooool02ooo
00<00?ooool01ooo00<00?ooool0;_oo00<00?ooool02?oo00<00?ooool02_oo00<00?ooool03_oo
00<00?ooool02ooo00<00?ooool03Ooo00<00?ooool02_oo00<00?ooool01ooo00<00?ooool02ooo
000Uool00`00ooooo`07ool00`00ooooo`0:ool00`00ooooo`0?ool00`00ooooo`0:ool00`00oooo
o`0=ool00`00ooooo`0;ool00`00ooooo`07ool00`00ooooo`0^ool00`00ooooo`08ool00`00oooo
o`0:ool00`00ooooo`0>ool00`00ooooo`0;ool00`00ooooo`0=ool00`00ooooo`0:ool00`00oooo
o`07ool00`00ooooo`0;ool001ooo`8000Coo`03003ooooo00Koo`03003ooooo00coo`03003ooooo
00goo`03003ooooo00coo`03003ooooo00coo`03003ooooo00coo`03003ooooo00Koo`03003ooooo
02Soo`8000Coo`03003ooooo00Ooo`03003ooooo00coo`03003ooooo00coo`03003ooooo00coo`03
003ooooo00coo`03003ooooo00coo`03003ooooo00Koo`03003ooooo00_oo`007_oo00@00?ooool0
00?oo`03003ooooo00Koo`03003ooooo00coo`03003ooooo00goo`03003ooooo00coo`03003ooooo
00coo`03003ooooo00coo`03003ooooo00Koo`03003ooooo02Ooo`04003ooooo0003ool00`00oooo
o`07ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0<ool00`00oooo
o`0<ool00`00ooooo`06ool00`00ooooo`0;ool001koo`04003ooooo0003ool00`00ooooo`06ool0
0`00ooooo`0<ool00`00ooooo`0=ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0<ool0
0`00ooooo`06ool00`00ooooo`0Wool01000ooooo`000ooo00<00?ooool01ooo00<00?ooool03?oo
00<00?ooool03?oo00<00?ooool03Ooo00<00?ooool02ooo00<00?ooool03?oo00<00?ooool01_oo
00<00?ooool02ooo000Nool01000ooooo`000ooo00<00?ooool01_oo00<00?ooool03?oo00<00?oo
ool03Ooo00<00?ooool03?oo00<00?ooool02ooo00<00?ooool03Ooo00<00?ooool01_oo00<00?oo
ool09ooo00@00?ooool000?oo`03003ooooo00Ooo`03003ooooo00coo`03003ooooo00coo`03003o
oooo00goo`03003ooooo00_oo`03003ooooo00coo`03003ooooo00Koo`03003ooooo00_oo`007_oo
00@00?ooool000?oo`03003ooooo00Goo`03003ooooo00goo`03003ooooo00coo`03003ooooo00go
o`03003ooooo00_oo`03003ooooo00goo`03003ooooo00Koo`03003ooooo02Ooo`04003ooooo0003
ool00`00ooooo`07ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0=ool00`00ooooo`0;
ool00`00ooooo`0<ool00`00ooooo`06ool00`00ooooo`0;ool001koo`04003ooooo0003ool00`00
ooooo`05ool00`00ooooo`0>ool00`00ooooo`0;ool00`00ooooo`0>ool00`00ooooo`0:ool00`00
ooooo`0>ool00`00ooooo`05ool00`00ooooo`0Wool01000ooooo`000ooo00<00?ooool01_oo00<0
0?ooool03Ooo00<00?ooool03?oo00<00?ooool03Ooo00<00?ooool02_oo00<00?ooool03_oo00<0
0?ooool01Ooo00<00?ooool02ooo000Oool20004ool00`00ooooo`05ool00`00ooooo`0>ool00`00
ooooo`0;ool00`00ooooo`0>ool00`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`05ool00`00
ooooo`0Xool20004ool00`00ooooo`06ool00`00ooooo`0=ool00`00ooooo`0;ool00`00ooooo`0>
ool00`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`05ool00`00ooooo`0;ool002Goo`03003o
oooo00Goo`03003ooooo00koo`03003ooooo00_oo`03003ooooo00koo`03003ooooo00Woo`03003o
oooo00ooo`03003ooooo00Goo`03003ooooo02koo`03003ooooo00Koo`03003ooooo00koo`03003o
oooo00[oo`03003ooooo00koo`03003ooooo00[oo`03003ooooo00koo`03003ooooo00Goo`03003o
oooo00_oo`009Ooo00<00?ooool01?oo00<00?ooool03ooo00<00?ooool02_oo00<00?ooool03ooo
00<00?ooool02Ooo00<00?ooool03ooo00<00?ooool01Ooo00<00?ooool0;_oo00<00?ooool01_oo
00<00?ooool03_oo00<00?ooool02_oo00<00?ooool03ooo00<00?ooool02Ooo00<00?ooool03_oo
00<00?ooool01Ooo00<00?ooool02ooo000Cool20004ool00`00ooooo`02ool40003ool00`00oooo
o`04ool00`00ooooo`0@ool00`00ooooo`09ool00`00ooooo`0@ool00`00ooooo`08ool00`00oooo
o`0?ool00`00ooooo`05ool00`00ooooo`0^ool00`00ooooo`06ool00`00ooooo`0>ool00`00oooo
o`0:ool00`00ooooo`0?ool00`00ooooo`09ool00`00ooooo`0>ool00`00ooooo`05ool00`00oooo
o`0;ool001;oo`04003ooooo0008ool00`00ooooo`04ool00`00ooooo`04ool00`00ooooo`0@ool0
0`00ooooo`09ool00`00ooooo`0@ool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`04ool0
0`00ooooo`0^ool00`00ooooo`05ool00`00ooooo`0?ool00`00ooooo`09ool00`00ooooo`0@ool0
0`00ooooo`09ool00`00ooooo`0?ool00`00ooooo`04ool00`00ooooo`0;ool001;oo`04003ooooo
0009ool00`00ooooo`03ool00`00ooooo`04ool00`00ooooo`0@ool00`00ooooo`09ool00`00oooo
o`0@ool00`00ooooo`08ool00`00ooooo`0@ool00`00ooooo`04ool00`00ooooo`0^ool00`00oooo
o`05ool00`00ooooo`0?ool00`00ooooo`09ool00`00ooooo`0@ool00`00ooooo`09ool00`00oooo
o`0?ool00`00ooooo`04ool00`00ooooo`0;ool001;oo`04003ooooo000:ool00`00ooooo`02ool0
0`00ooooo`03ool00`00ooooo`0Aool00`00ooooo`08ool00`00ooooo`0Aool00`00ooooo`07ool0
0`00ooooo`0Aool00`00ooooo`04ool00`00ooooo`0Lool20004ool00`00ooooo`02ool40003ool0
0`00ooooo`05ool00`00ooooo`0?ool00`00ooooo`09ool00`00ooooo`0@ool00`00ooooo`08ool0
0`00ooooo`0@ool00`00ooooo`04ool00`00ooooo`0;ool001;oo`04003ooooo000;ool01@00oooo
oooo00001Ooo00<00?ooool04_oo00<00?ooool01ooo00<00?ooool04Ooo00<00?ooool01ooo00<0
0?ooool04Ooo00<00?ooool01?oo00<00?ooool06ooo00@00?ooool000Soo`03003ooooo00Coo`03
003ooooo00Goo`03003ooooo00ooo`03003ooooo00Woo`03003ooooo013oo`03003ooooo00Soo`03
003ooooo013oo`03003ooooo00Coo`03003ooooo00_oo`004_oo00@00?ooool000Soo`04003ooooo
0003ool00`00ooooo`03ool00`00ooooo`0Bool00`00ooooo`07ool00`00ooooo`0Bool00`00oooo
o`06ool00`00ooooo`0Aool00`00ooooo`04ool00`00ooooo`0Kool01000ooooo`002Ooo00<00?oo
ool00ooo00<00?ooool01Ooo00<00?ooool04?oo00<00?ooool02?oo00<00?ooool04?oo00<00?oo
ool02?oo00<00?ooool04?oo00<00?ooool01?oo00<00?ooool02ooo000Cool2000:ool20004ool0
0`00ooooo`03ool00`00ooooo`0Bool00`00ooooo`07ool00`00ooooo`0Bool00`00ooooo`06ool0
0`00ooooo`0Bool00`00ooooo`03ool00`00ooooo`0Kool01000ooooo`002_oo00<00?ooool00_oo
00<00?ooool01?oo00<00?ooool04Ooo00<00?ooool01ooo00<00?ooool04_oo00<00?ooool01ooo
00<00?ooool04Ooo00<00?ooool00ooo00<00?ooool02ooo000Uool00`00ooooo`02ool00`00oooo
o`0Cool00`00ooooo`06ool00`00ooooo`0Cool00`00ooooo`05ool00`00ooooo`0Cool00`00oooo
o`03ool00`00ooooo`0Kool01000ooooo`002ooo00D00?ooooooo`0000Koo`03003ooooo017oo`03
003ooooo00Ooo`03003ooooo01;oo`03003ooooo00Ooo`03003ooooo017oo`03003ooooo00?oo`03
003ooooo00_oo`009Ooo00<00?ooool00_oo00<00?ooool05?oo00<00?ooool01Ooo00<00?ooool0
4ooo00<00?ooool01Ooo00<00?ooool04ooo00<00?ooool00ooo00<00?ooool06ooo00@00?ooool0
00Soo`04003ooooo0003ool00`00ooooo`04ool00`00ooooo`0Aool00`00ooooo`07ool00`00oooo
o`0Bool00`00ooooo`07ool00`00ooooo`0Aool00`00ooooo`03ool00`00ooooo`0;ool002Goo`03
003ooooo00;oo`03003ooooo01Coo`03003ooooo00Goo`03003ooooo01Coo`03003ooooo00Coo`03
003ooooo01?oo`03003ooooo00?oo`03003ooooo01coo`8000[oo`8000Coo`03003ooooo00Coo`03
003ooooo01;oo`03003ooooo00Koo`03003ooooo01;oo`03003ooooo00Ooo`03003ooooo017oo`03
003ooooo00?oo`03003ooooo00_oo`004ooo0P001?oo00<00?ooool01?oo00<00?ooool00_oo00<0
0?ooool00_oo00<00?ooool05?oo00<00?ooool01Ooo00<00?ooool05?oo00<00?ooool01?oo00<0
0?ooool05?oo00<00?ooool00_oo00<00?ooool0;_oo00<00?ooool01?oo00<00?ooool04_oo00<0
0?ooool01Ooo00<00?ooool04ooo00<00?ooool01_oo00<00?ooool04_oo00<00?ooool00ooo00<0
0?ooool02ooo000Bool01000ooooo`002_oo00<00?ooool00_oo00<00?ooool00_oo00<00?ooool0
5Ooo00<00?ooool00ooo00<00?ooool05Ooo00<00?ooool01?oo00<00?ooool05?oo00<00?ooool0
0_oo00<00?ooool0;_oo00<00?ooool00ooo00<00?ooool04ooo00<00?ooool01Ooo00<00?ooool0
4ooo00<00?ooool01_oo00<00?ooool04ooo00<00?ooool00_oo00<00?ooool02ooo000Bool01000
ooooo`001ooo1@000ooo00D00?ooooooo`0001Soo`03003ooooo00?oo`03003ooooo01Goo`03003o
oooo00?oo`03003ooooo01Goo`03003ooooo00;oo`03003ooooo02koo`03003ooooo00?oo`03003o
oooo01?oo`03003ooooo00Goo`03003ooooo01?oo`03003ooooo00Koo`03003ooooo01?oo`03003o
oooo00;oo`03003ooooo00_oo`004_oo00@00?ooool000Ooo`04003ooooo0004ool01@00oooooooo
00006?oo00<00?ooool00ooo00<00?ooool05_oo00<00?ooool00_oo00<00?ooool05Ooo00<00?oo
ool00_oo00<00?ooool0;_oo00<00?ooool00ooo00<00?ooool04ooo00<00?ooool01Ooo00<00?oo
ool05?oo00<00?ooool01Ooo00<00?ooool04ooo00<00?ooool00_oo00<00?ooool02ooo000Bool0
1000ooooo`002?oo00<00?oo00001?oo00@00?oo000001[oo`05003oooooool0000Iool00`00oooo
o`02ool00`00ooooo`0Fool01@00oooooooo0000<?oo00<00?ooool00ooo00<00?ooool05?oo00<0
0?ooool01?oo00<00?ooool05?oo00<00?ooool01?oo00<00?ooool05?oo00<00?ooool00_oo00<0
0?ooool02ooo000Bool01000ooooo`002Ooo0P001?oo00<00?ooool06ooo0P000_oo00<00?ooool0
5ooo00D00?ooooooo`0001Woo`05003oooooool0000`ool00`00ooooo`02ool00`00ooooo`0Eool0
0`00ooooo`03ool00`00ooooo`0Eool00`00ooooo`04ool00`00ooooo`0Eool01@00oooooooo0000
3Ooo000Cool2000;ool00`00ooooo`02ool00`00ooooo`0Lool3000Jool01@00oooooooo00006Ooo
00D00?ooooooo`0001koo`8000Coo`03003ooooo00Coo`03003ooooo00;oo`03003ooooo00;oo`03
003ooooo01Goo`03003ooooo00?oo`03003ooooo01Koo`03003ooooo00?oo`03003ooooo01Goo`05
003oooooool0000=ool002Goo`03003ooooo01goo`8001_oo`04003ooooo000Jool01000ooooo`00
7Ooo00@00?ooool000[oo`03003ooooo00;oo`03003ooooo00;oo`03003ooooo01Koo`03003ooooo
00;oo`03003ooooo01Koo`03003ooooo00;oo`03003ooooo01Koo`05003oooooool0000=ool002Go
o`03003ooooo03[oo`@001[oo`04003ooooo000Mool01000ooooo`001ooo1@000ooo00D00?oooooo
o`0001Woo`05003oooooool0000Iool00`00ooooo`02ool00`00ooooo`0Gool01000ooooo`003Ooo
000Uool00`00ooooo`0kool2000Kool01000ooooo`007Ooo00@00?ooool000Ooo`04003ooooo0004
ool01@00oooooooo00006Ooo00D00?ooooooo`0001[oo`04003ooooo000Jool01000ooooo`003Ooo
000Cool20004ool00`00ooooo`03ool20004ool00`00ooooo`1Hool200000ooo003oo`0Lool01000
ooooo`002?oo00<00?oo00001?oo00@00?ooool001_oo`04003ooooo000Jool200000ooo003oo`0J
ool00`00ool0000=ool001;oo`04003ooooo0008ool01000ooooo`000ooo00<00?ooool0FOoo00<0
0?oo00007Ooo00@00?ooool000Woo`8000Coo`04003oo`00000Kool3000Lool3000Kool00`00ool0
000=ool001;oo`04003ooooo0008ool01000ooooo`000oooG`007_oo0P002ooo00<00?ooool00_oo
G`003Ooo000Bool01000ooooo`002?oo0`00oooo000Bool01000ooooo`002?oo00<00?ooool0oooo
000Bool01000ooooo`002?oo00<00?ooool0oooo000Cool2000:ool3000Bool30005ool20008ool2
001kool30005ool20008ool20019ool003Goo`03003ooooo00Coo`03003ooooo00Soo`03003ooooo
07[oo`03003ooooo00Coo`03003ooooo00Soo`03003ooooo04Ooo`00;_oo0`001?oo00<00?ooool0
1?oo00@00?ooooooo`<000Coo`03003ooooo00[oo`04003oooooool3000;ool20002ool600000ooo
003oo`020002ool30013ool30004ool00`00ooooo`04ool01000oooooooo0`001?oo00<00?ooool0
2_oo00@00?ooooooo`<000_oo`8000;oo`H00003ool00?oo008000;oo`<001Ooo`00;ooo00<00?oo
ool00ooo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool00ooo00<00?ooool02Ooo00<00?oo
00001Ooo00<00?ooool01ooo00@00?ooool000?oo`08003ooooo003oo`00ool000;oo`03003ooooo
04Goo`03003ooooo00?oo`03003ooooo00Coo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo
00Woo`03003oo`0000Goo`03003ooooo00Ooo`04003ooooo0003ool02000ooooo`00ool00?oo0002
ool00`00ooooo`0Hool002ooo`03003ooooo00[oo`03003ooooo00;oo`03003ooooo00?oo`03003o
oooo00Woo`03003oo`0000?oo`8000[oo`03003ooooo00Coo`08003ooooo003oo`00ool000;oo`<0
04Goo`03003ooooo00[oo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00Woo`03003oo`00
00?oo`8000[oo`03003ooooo00Coo`08003ooooo003oo`00ool000;oo`<001Soo`00;_oo00<00?oo
00002ooo00<00?ooool00_oo00<00?ooool00ooo00<00?ooool02?oo00L00?ooooooo`00ool0000<
ool00`00ooooo`04ool02000ooooo`00ool00?oo0002ool01000ooooo`00@ooo00<00?oo00002ooo
00<00?ooool00_oo00<00?ooool00ooo00<00?ooool02?oo00L00?ooooooo`00ool0000<ool00`00
ooooo`04ool02000ooooo`00ool00?oo0002ool01000ooooo`005ooo000]ool01@00oooooooo0000
2_oo00P00?ooool00?oo003oo`000ooo00<00?ooool01ooo0P000_oo0P000_oo0`002?oo10000ooo
0P000_oo0P0000?oo`00ool00ooo0P00@ooo00D00?ooooooo`0000[oo`08003ooooo003oo`00ool0
00?oo`03003ooooo00Ooo`8000;oo`8000;oo`<000Soo`@000?oo`8000;oo`800003ool00?oo00?o
o`8001Soo`00;Ooo0P0000?oo`0000002_oo0P0000?oo`0000000`000_oo0P007Ooo00<00?ooool0
E?oo0P0000?oo`0000002_oo0P0000?oo`0000000`000_oo0P007Ooo00<00?ooool0:Ooo001Uool0
0`00ooooo`04ool00`00ooooo`25ool00`00ooooo`04ool00`00ooooo`0Rool00?ooob7oo`00oooo
8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {879.562, 541.875}} -> {-0.598477, \
3.12607, 0.00731988, 0.00731988}, {{102.188, 264.75}, {871.562, 771}} -> \
{-40.4277, 2.26467, 0.354197, 0.00369774}, {{281.062, 443.625}, {871.562, \
771}} -> {-91.1222, 1.69034, 0.354197, 0.00222201}, {{102.188, 264.75}, \
{760.938, 660.438}} -> {-41.5491, 8.68855, 0.35456, 0.028987}, {{281.062, \
443.625}, {760.938, 660.438}} -> {-91.2318, 6.8794, 0.35456, 0.0230008}, \
{{102.188, 264.75}, {650.375, 549.812}} -> {-40.4277, 4.3973, 0.354197, \
0.0208297}, {{281.062, 443.625}, {650.375, 549.812}} -> {-91.1222, 3.42209, \
0.354197, 0.0162473}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Orthogonal projection method", "Subsection"],

Cell[TextData[{
  "Here the ",
  StyleBox["OrthogonalProjection", "MR"],
  " method is used to solve the equations."
}], "Text"],

Cell[BoxData[
    \(\(OPSolution\  = \ 
        NDSolve[system, 
          Method \[Rule] {OrthogonalProjection, Dimensions \[Rule] {3, 1}, 
              Method \[Rule] ExplicitEuler}, 
          StartingStepSize\  \[Rule] \ 1/20];\)\)], "Input",
  CellLabel->"In[33]:="],

Cell["\<\
Only the orthogonal constraint is conserved so the curve is not \
closed.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(PlotSolutionOnManifold[OPSolution, vars, \ time, \ 
        UnitSphere];\)\)], "Input",
  CellLabel->"In[34]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08024 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0545142 1.1616 -6.10948e-17 1.1616 [
[ 0 0 0 0 ]
[ 1 1.08024 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08024 L
0 1.08024 L
closepath
clip
newpath
.751 .603 .693 r
.49641 .58077 m .4173 .61167 L .42757 .56871 L F
.49641 .58077 m .49333 .62464 L .4173 .61167 L F
.747 .623 .722 r
.50014 .53692 m .49641 .58077 L .42757 .56871 L F
.703 .561 .691 r
.56749 .57971 m .49333 .62464 L .49641 .58077 L F
.703 .585 .72 r
.56234 .53597 m .49641 .58077 L .50014 .53692 L F
.56234 .53597 m .56749 .57971 L .49641 .58077 L F
.703 .561 .691 r
.56749 .57971 m .57174 .6235 L .49333 .62464 L F
.651 .522 .694 r
.63547 .56559 m .57174 .6235 L .56749 .57971 L F
.657 .551 .723 r
.62174 .5233 m .56749 .57971 L .56234 .53597 L F
.62174 .5233 m .63547 .56559 L .56749 .57971 L F
.747 .623 .722 r
.50014 .53692 m .42757 .56871 L .43997 .52609 L F
.74 .642 .75 r
.50445 .49376 m .50014 .53692 L .43997 .52609 L F
.703 .608 .748 r
.55639 .49295 m .50014 .53692 L .50445 .49376 L F
.55639 .49295 m .56234 .53597 L .50014 .53692 L F
.755 .582 .662 r
.49333 .62464 m .40935 .65429 L .4173 .61167 L F
.49333 .62464 m .49094 .66783 L .40935 .65429 L F
.701 .535 .66 r
.57174 .6235 m .49094 .66783 L .49333 .62464 L F
.662 .579 .751 r
.60587 .48212 m .56234 .53597 L .55639 .49295 L F
.60587 .48212 m .62174 .5233 L .56234 .53597 L F
.701 .535 .66 r
.57174 .6235 m .57504 .66664 L .49094 .66783 L F
.643 .492 .662 r
.64685 .60832 m .57504 .66664 L .57174 .6235 L F
.651 .522 .694 r
.63547 .56559 m .64685 .60832 L .57174 .6235 L F
.74 .642 .75 r
.50445 .49376 m .43997 .52609 L .45429 .48451 L F
.732 .66 .779 r
.5093 .45201 m .50445 .49376 L .45429 .48451 L F
.701 .632 .776 r
.5497 .45136 m .50445 .49376 L .5093 .45201 L F
.5497 .45136 m .55639 .49295 L .50445 .49376 L F
.667 .608 .78 r
.58811 .44275 m .55639 .49295 L .5497 .45136 L F
.58811 .44275 m .60587 .48212 L .55639 .49295 L F
.757 .558 .627 r
.49094 .66783 m .40387 .69585 L .40935 .65429 L F
.49094 .66783 m .4893 .70965 L .40387 .69585 L F
.698 .508 .627 r
.57504 .66664 m .4893 .70965 L .49094 .66783 L F
.57504 .66664 m .5773 .70844 L .4893 .70965 L F
.634 .459 .628 r
.65567 .65078 m .5773 .70844 L .57504 .66664 L F
.643 .492 .662 r
.64685 .60832 m .65567 .65078 L .57504 .66664 L F
.799 .653 .7 r
.42757 .56871 m .3494 .58525 L .36631 .54418 L F
.42757 .56871 m .4173 .61167 L .3494 .58525 L F
.788 .668 .731 r
.43997 .52609 m .42757 .56871 L .36631 .54418 L F
.43997 .52609 m .36631 .54418 L .38665 .50414 L F
.776 .682 .76 r
.45429 .48451 m .43997 .52609 L .38665 .50414 L F
.591 .485 .702 r
.69502 .53917 m .64685 .60832 L .63547 .56559 L F
.605 .521 .733 r
.67351 .49967 m .63547 .56559 L .62174 .5233 L F
.67351 .49967 m .69502 .53917 L .63547 .56559 L F
.618 .555 .762 r
.64876 .462 m .62174 .5233 L .60587 .48212 L F
.64876 .462 m .67351 .49967 L .62174 .5233 L F
.808 .635 .667 r
.4173 .61167 m .33626 .62664 L .3494 .58525 L F
.4173 .61167 m .40935 .65429 L .33626 .62664 L F
.776 .682 .76 r
.45429 .48451 m .38665 .50414 L .41008 .4658 L F
.761 .694 .788 r
.47034 .44465 m .45429 .48451 L .41008 .4658 L F
.732 .66 .779 r
.5093 .45201 m .45429 .48451 L .47034 .44465 L F
.575 .447 .668 r
.71292 .57984 m .65567 .65078 L .64685 .60832 L F
.591 .485 .702 r
.69502 .53917 m .71292 .57984 L .64685 .60832 L F
.63 .59 .79 r
.62119 .42681 m .60587 .48212 L .58811 .44275 L F
.62119 .42681 m .64876 .462 L .60587 .48212 L F
.721 .679 .808 r
.51461 .41237 m .5093 .45201 L .47034 .44465 L F
.697 .656 .806 r
.54238 .41192 m .5093 .45201 L .51461 .41237 L F
.54238 .41192 m .5497 .45136 L .5093 .45201 L F
.671 .638 .809 r
.56873 .40588 m .5497 .45136 L .54238 .41192 L F
.56873 .40588 m .58811 .44275 L .5497 .45136 L F
.757 .53 .588 r
.4893 .70965 m .40102 .73562 L .40387 .69585 L F
.4893 .70965 m .48845 .74938 L .40102 .73562 L F
.693 .476 .589 r
.5773 .70844 m .48845 .74938 L .4893 .70965 L F
.5773 .70844 m .57848 .74817 L .48845 .74938 L F
.623 .421 .588 r
.66175 .69228 m .57848 .74817 L .5773 .70844 L F
.634 .459 .628 r
.65567 .65078 m .66175 .69228 L .5773 .70844 L F
.816 .614 .629 r
.40935 .65429 m .3272 .66764 L .33626 .62664 L F
.40935 .65429 m .40387 .69585 L .3272 .66764 L F
.557 .404 .63 r
.72683 .62098 m .66175 .69228 L .65567 .65078 L F
.575 .447 .668 r
.71292 .57984 m .72683 .62098 L .65567 .65078 L F
.761 .694 .788 r
.47034 .44465 m .41008 .4658 L .43619 .42982 L F
.743 .705 .816 r
.48787 .40721 m .47034 .44465 L .43619 .42982 L F
.721 .679 .808 r
.51461 .41237 m .47034 .44465 L .48787 .40721 L F
.643 .626 .818 r
.59126 .39474 m .58811 .44275 L .56873 .40588 L F
.59126 .39474 m .62119 .42681 L .58811 .44275 L F
.83 .723 .747 r
.38665 .50414 m .31789 .50862 L .34487 .47246 L F
.38665 .50414 m .36631 .54418 L .31789 .50862 L F
.809 .73 .777 r
.41008 .4658 m .38665 .50414 L .34487 .47246 L F
.41008 .4658 m .34487 .47246 L .37576 .43893 L F
.787 .734 .804 r
.43619 .42982 m .41008 .4658 L .37576 .43893 L F
.848 .714 .714 r
.36631 .54418 m .29535 .54679 L .31789 .50862 L F
.36631 .54418 m .3494 .58525 L .29535 .54679 L F
.822 .589 .585 r
.40387 .69585 m .32248 .70748 L .3272 .66764 L F
.40387 .69585 m .40102 .73562 L .32248 .70748 L F
.542 .493 .751 r
.71303 .46661 m .69502 .53917 L .67351 .49967 L F
.566 .536 .78 r
.68114 .43399 m .67351 .49967 L .64876 .462 L F
.68114 .43399 m .71303 .46661 L .67351 .49967 L F
.707 .698 .839 r
.5203 .37559 m .51461 .41237 L .48787 .40721 L F
.691 .683 .838 r
.53454 .37535 m .51461 .41237 L .5203 .37559 L F
.53454 .37535 m .54238 .41192 L .51461 .41237 L F
.673 .671 .84 r
.54801 .3722 m .54238 .41192 L .53454 .37535 L F
.54801 .3722 m .56873 .40588 L .54238 .41192 L F
.59 .577 .807 r
.64586 .40476 m .64876 .462 L .62119 .42681 L F
.64586 .40476 m .68114 .43399 L .64876 .462 L F
.755 .496 .541 r
.48845 .74938 m .40094 .77284 L .40102 .73562 L F
.48845 .74938 m .48842 .78627 L .40094 .77284 L F
.686 .439 .543 r
.57848 .74817 m .48842 .78627 L .48845 .74938 L F
.515 .446 .717 r
.74091 .50204 m .71292 .57984 L .69502 .53917 L F
.542 .493 .751 r
.71303 .46661 m .74091 .50204 L .69502 .53917 L F
.686 .439 .543 r
.57848 .74817 m .57851 .78509 L .48842 .78627 L F
.608 .376 .54 r
.6649 .73206 m .57851 .78509 L .57848 .74817 L F
.623 .421 .588 r
.66175 .69228 m .6649 .73206 L .57848 .74817 L F
.535 .356 .584 r
.73643 .66185 m .6649 .73206 L .66175 .69228 L F
.557 .404 .63 r
.72683 .62098 m .73643 .66185 L .66175 .69228 L F
.787 .734 .804 r
.43619 .42982 m .37576 .43893 L .40998 .40864 L F
.761 .736 .83 r
.46458 .39684 m .43619 .42982 L .40998 .40864 L F
.743 .705 .816 r
.48787 .40721 m .43619 .42982 L .46458 .39684 L F
.865 .701 .677 r
.3494 .58525 m .27777 .58629 L .29535 .54679 L F
.3494 .58525 m .33626 .62664 L .27777 .58629 L F
.72 .716 .845 r
.50661 .37289 m .48787 .40721 L .46458 .39684 L F
.707 .698 .839 r
.5203 .37559 m .48787 .40721 L .50661 .37289 L F
.655 .664 .846 r
.55944 .36641 m .56873 .40588 L .54801 .3722 L F
.55944 .36641 m .59126 .39474 L .56873 .40588 L F
.613 .619 .833 r
.60784 .37944 m .62119 .42681 L .59126 .39474 L F
.60784 .37944 m .64586 .40476 L .62119 .42681 L F
.485 .395 .679 r
.76422 .53965 m .72683 .62098 L .71292 .57984 L F
.515 .446 .717 r
.74091 .50204 m .76422 .53965 L .71292 .57984 L F
.761 .736 .83 r
.46458 .39684 m .40998 .40864 L .44691 .38212 L F
.73 .735 .855 r
.49477 .3675 m .46458 .39684 L .44691 .38212 L F
.72 .716 .845 r
.50661 .37289 m .46458 .39684 L .49477 .3675 L F
.88 .683 .632 r
.33626 .62664 m .26561 .62638 L .27777 .58629 L F
.33626 .62664 m .3272 .66764 L .26561 .62638 L F
.636 .661 .857 r
.56774 .35851 m .59126 .39474 L .55944 .36641 L F
.56774 .35851 m .60784 .37944 L .59126 .39474 L F
.825 .556 .531 r
.40102 .73562 m .32235 .74538 L .32248 .70748 L F
.40102 .73562 m .40094 .77284 L .32235 .74538 L F
.45 .336 .632 r
.78241 .57878 m .73643 .66185 L .72683 .62098 L F
.485 .395 .679 r
.76422 .53965 m .78241 .57878 L .72683 .62098 L F
.608 .376 .54 r
.6649 .73206 m .66499 .76936 L .57851 .78509 L F
.508 .297 .528 r
.74142 .70171 m .66499 .76936 L .6649 .73206 L F
.535 .356 .584 r
.73643 .66185 m .74142 .70171 L .6649 .73206 L F
.672 .728 .892 r
.56729 .33016 m .5203 .37559 L .50661 .37289 L F
.56729 .33016 m .53454 .37535 L .5203 .37559 L F
.56729 .33016 m .54801 .3722 L .53454 .37535 L F
.838 .788 .803 r
.37576 .43893 m .31891 .4333 L .35486 .40595 L F
.37576 .43893 m .34487 .47246 L .31891 .4333 L F
.807 .78 .828 r
.40998 .40864 m .37576 .43893 L .35486 .40595 L F
.40998 .40864 m .35486 .40595 L .39438 .38283 L F
.773 .77 .85 r
.44691 .38212 m .40998 .40864 L .39438 .38283 L F
.672 .728 .892 r
.56729 .33016 m .50661 .37289 L .49477 .3675 L F
.749 .452 .481 r
.48842 .78627 m .40374 .80672 L .40094 .77284 L F
.48842 .78627 m .48926 .81954 L .40374 .80672 L F
.674 .391 .486 r
.57851 .78509 m .48926 .81954 L .48842 .78627 L F
.672 .728 .892 r
.56729 .33016 m .55944 .36641 L .54801 .3722 L F
.674 .391 .486 r
.57851 .78509 m .57735 .81842 L .48926 .81954 L F
.587 .32 .479 r
.66499 .76936 m .57735 .81842 L .57851 .78509 L F
.869 .792 .773 r
.34487 .47246 m .28728 .46441 L .31891 .4333 L F
.34487 .47246 m .31789 .50862 L .28728 .46441 L F
.544 .572 .833 r
.65956 .37841 m .68114 .43399 L .64586 .40476 L F
.582 .619 .854 r
.61677 .3613 m .64586 .40476 L .60784 .37944 L F
.61677 .3613 m .65956 .37841 L .64586 .40476 L F
.504 .522 .808 r
.69961 .40027 m .71303 .46661 L .68114 .43399 L F
.544 .572 .833 r
.65956 .37841 m .69961 .40027 L .68114 .43399 L F
.773 .77 .85 r
.44691 .38212 m .39438 .38283 L .43667 .36434 L F
.736 .756 .869 r
.48591 .35989 m .44691 .38212 L .43667 .36434 L F
.73 .735 .855 r
.49477 .3675 m .44691 .38212 L .48591 .35989 L F
.672 .728 .892 r
.56729 .33016 m .49477 .3675 L .48591 .35989 L F
.56729 .33016 m .56774 .35851 L .55944 .36641 L F
.893 .659 .577 r
.3272 .66764 m .25927 .66629 L .26561 .62638 L F
.3272 .66764 m .32248 .70748 L .25927 .66629 L F
.619 .663 .871 r
.57206 .34924 m .60784 .37944 L .56774 .35851 L F
.57206 .34924 m .61677 .3613 L .60784 .37944 L F
.459 .466 .778 r
.7361 .42652 m .74091 .50204 L .71303 .46661 L F
.504 .522 .808 r
.69961 .40027 m .7361 .42652 L .71303 .46661 L F
.898 .792 .736 r
.31789 .50862 m .2607 .49874 L .28728 .46441 L F
.31789 .50862 m .29535 .54679 L .2607 .49874 L F
.672 .728 .892 r
.56729 .33016 m .48591 .35989 L .48091 .35078 L F
.736 .756 .869 r
.48591 .35989 m .43667 .36434 L .48091 .35078 L F
.408 .266 .574 r
.79501 .6187 m .74142 .70171 L .73643 .66185 L F
.45 .336 .632 r
.78241 .57878 m .79501 .6187 L .73643 .66185 L F
.672 .728 .892 r
.56729 .33016 m .57206 .34924 L .56774 .35851 L F
.409 .401 .74 r
.76825 .45673 m .76422 .53965 L .74091 .50204 L F
.459 .466 .778 r
.7361 .42652 m .76825 .45673 L .74091 .50204 L F
.824 .511 .46 r
.40094 .77284 m .32698 .78049 L .32235 .74538 L F
.40094 .77284 m .40374 .80672 L .32698 .78049 L F
.925 .787 .689 r
.29535 .54679 m .23987 .53567 L .2607 .49874 L F
.29535 .54679 m .27777 .58629 L .23987 .53567 L F
.587 .32 .479 r
.66499 .76936 m .66189 .80339 L .57735 .81842 L F
.471 .222 .455 r
.74157 .73974 m .66189 .80339 L .66499 .76936 L F
.508 .297 .528 r
.74142 .70171 m .74157 .73974 L .66499 .76936 L F
.776 .805 .876 r
.43667 .36434 m .39132 .35467 L .43503 .34511 L F
.43667 .36434 m .39438 .38283 L .39132 .35467 L F
.736 .776 .885 r
.48091 .35078 m .43667 .36434 L .43503 .34511 L F
.672 .728 .892 r
.56729 .33016 m .48091 .35078 L .48032 .34103 L F
.736 .776 .885 r
.48091 .35078 m .43503 .34511 L .48032 .34103 L F
.672 .728 .892 r
.56729 .33016 m .57193 .33947 L .57206 .34924 L F
.603 .672 .888 r
.57193 .33947 m .61677 .3613 L .57206 .34924 L F
.552 .628 .881 r
.61696 .34201 m .65956 .37841 L .61677 .3613 L F
.603 .672 .888 r
.57193 .33947 m .61696 .34201 L .61677 .3613 L F
.816 .832 .861 r
.39438 .38283 m .35008 .36964 L .39132 .35467 L F
.39438 .38283 m .35486 .40595 L .35008 .36964 L F
.902 .624 .506 r
.32248 .70748 m .25909 .70517 L .25927 .66629 L F
.32248 .70748 m .32235 .74538 L .25909 .70517 L F
.349 .326 .691 r
.79528 .49037 m .78241 .57878 L .76422 .53965 L F
.409 .401 .74 r
.76825 .45673 m .79528 .49037 L .76422 .53965 L F
.736 .393 .4 r
.48926 .81954 m .40949 .83642 L .40374 .80672 L F
.48926 .81954 m .49098 .8484 L .40949 .83642 L F
.654 .328 .409 r
.57735 .81842 m .49098 .8484 L .48926 .81954 L F
.493 .576 .867 r
.6605 .35012 m .69961 .40027 L .65956 .37841 L F
.552 .628 .881 r
.61696 .34201 m .6605 .35012 L .65956 .37841 L F
.654 .328 .409 r
.57735 .81842 m .57498 .84735 L .49098 .8484 L F
.556 .245 .396 r
.66189 .80339 m .57498 .84735 L .57735 .81842 L F
.672 .728 .892 r
.56729 .33016 m .48032 .34103 L .48424 .33158 L F
.727 .793 .904 r
.48032 .34103 m .44241 .3263 L .48424 .33158 L F
.48032 .34103 m .43503 .34511 L .44241 .3263 L F
.857 .856 .839 r
.35486 .40595 m .31224 .38985 L .35008 .36964 L F
.35486 .40595 m .31891 .4333 L .31224 .38985 L F
.592 .686 .907 r
.56729 .33016 m .61696 .34201 L .57193 .33947 L F
.354 .178 .499 r
.80158 .65861 m .74157 .73974 L .74142 .70171 L F
.408 .266 .574 r
.79501 .6187 m .80158 .65861 L .74142 .70171 L F
.95 .774 .629 r
.27777 .58629 m .2254 .57449 L .23987 .53567 L F
.27777 .58629 m .26561 .62638 L .2254 .57449 L F
.425 .514 .846 r
.70164 .36374 m .7361 .42652 L .69961 .40027 L F
.493 .576 .867 r
.6605 .35012 m .70164 .36374 L .69961 .40027 L F
.766 .837 .906 r
.43503 .34511 m .40165 .32686 L .44241 .3263 L F
.43503 .34511 m .39132 .35467 L .40165 .32686 L F
.672 .728 .892 r
.56729 .33016 m .48424 .33158 L .49237 .32338 L F
.711 .803 .922 r
.48424 .33158 m .45834 .30984 L .49237 .32338 L F
.48424 .33158 m .44241 .3263 L .45834 .30984 L F
.672 .728 .892 r
.56729 .33016 m .54655 .31655 L .55855 .32225 L F
.56729 .33016 m .53247 .31368 L .54655 .31655 L F
.56729 .33016 m .51776 .31394 L .53247 .31368 L F
.56729 .33016 m .50392 .31729 L .51776 .31394 L F
.56729 .33016 m .49237 .32338 L .50392 .31729 L F
.588 .706 .925 r
.55855 .32225 m .60815 .32345 L .56729 .33016 L F
.592 .686 .907 r
.56729 .33016 m .60815 .32345 L .61696 .34201 L F
.897 .877 .808 r
.31891 .4333 m .27869 .41501 L .31224 .38985 L F
.31891 .4333 m .28728 .46441 L .27869 .41501 L F
.524 .647 .911 r
.60815 .32345 m .6605 .35012 L .61696 .34201 L F
.277 .233 .627 r
.81649 .52683 m .79501 .6187 L .78241 .57878 L F
.349 .326 .691 r
.79528 .49037 m .81649 .52683 L .78241 .57878 L F
.813 .447 .364 r
.40374 .80672 m .3365 .81197 L .32698 .78049 L F
.40374 .80672 m .40949 .83642 L .3365 .81197 L F
.687 .805 .938 r
.49237 .32338 m .48134 .2975 L .50392 .31729 L F
.49237 .32338 m .45834 .30984 L .48134 .2975 L F
.343 .438 .814 r
.73944 .38274 m .76825 .45673 L .7361 .42652 L F
.425 .514 .846 r
.70164 .36374 m .73944 .38274 L .7361 .42652 L F
.588 .706 .925 r
.55855 .32225 m .59097 .30754 L .60815 .32345 L F
.592 .731 .941 r
.54655 .31655 m .59097 .30754 L .55855 .32225 L F
.556 .245 .396 r
.66189 .80339 m .65551 .83332 L .57498 .84735 L F
.418 .123 .354 r
.73666 .77511 m .65551 .83332 L .66189 .80339 L F
.471 .222 .455 r
.74157 .73974 m .73666 .77511 L .66189 .80339 L F
.903 .572 .41 r
.32235 .74538 m .26532 .74214 L .25909 .70517 L F
.32235 .74538 m .32698 .78049 L .26532 .74214 L F
.806 .882 .901 r
.39132 .35467 m .36284 .33346 L .40165 .32686 L F
.39132 .35467 m .35008 .36964 L .36284 .33346 L F
.658 .798 .949 r
.50392 .31729 m .50912 .29068 L .51776 .31394 L F
.50392 .31729 m .48134 .2975 L .50912 .29068 L F
.97 .749 .548 r
.26561 .62638 m .21784 .6144 L .2254 .57449 L F
.26561 .62638 m .25927 .66629 L .21784 .6144 L F
.592 .731 .941 r
.54655 .31655 m .56702 .29601 L .59097 .30754 L F
.606 .757 .951 r
.53247 .31368 m .56702 .29601 L .54655 .31655 L F
.936 .892 .762 r
.28728 .46441 m .25031 .44474 L .27869 .41501 L F
.28728 .46441 m .2607 .49874 L .25031 .44474 L F
.438 .593 .908 r
.64803 .32263 m .70164 .36374 L .6605 .35012 L F
.524 .647 .911 r
.60815 .32345 m .64803 .32263 L .6605 .35012 L F
.629 .78 .954 r
.51776 .31394 m .53874 .29017 L .53247 .31368 L F
.51776 .31394 m .50912 .29068 L .53874 .29017 L F
.606 .757 .951 r
.53247 .31368 m .53874 .29017 L .56702 .29601 L F
.282 .065 .396 r
.80176 .69767 m .73666 .77511 L .74157 .73974 L F
.354 .178 .499 r
.80158 .65861 m .80176 .69767 L .74157 .73974 L F
.737 .86 .938 r
.44241 .3263 m .42489 .30231 L .45834 .30984 L F
.44241 .3263 m .40165 .32686 L .42489 .30231 L F
.707 .306 .284 r
.49098 .8484 m .41824 .86113 L .40949 .83642 L F
.49098 .8484 m .49361 .87202 L .41824 .86113 L F
.619 .239 .3 r
.57498 .84735 m .49361 .87202 L .49098 .8484 L F
.504 .677 .943 r
.59097 .30754 m .64803 .32263 L .60815 .32345 L F
.619 .239 .3 r
.57498 .84735 m .57136 .87106 L .49361 .87202 L F
.507 .14 .278 r
.65551 .83332 m .57136 .87106 L .57498 .84735 L F
.185 .115 .539 r
.83123 .56541 m .80158 .65861 L .79501 .6187 L F
.277 .233 .627 r
.81649 .52683 m .83123 .56541 L .79501 .6187 L F
.241 .34 .765 r
.773 .4069 m .79528 .49037 L .76825 .45673 L F
.343 .438 .814 r
.73944 .38274 m .773 .4069 L .76825 .45673 L F
.846 .927 .883 r
.35008 .36964 m .32691 .34619 L .36284 .33346 L F
.35008 .36964 m .31224 .38985 L .32691 .34619 L F
.97 .897 .693 r
.2607 .49874 m .22793 .47852 L .25031 .44474 L F
.2607 .49874 m .23987 .53567 L .22793 .47852 L F
.324 .516 .89 r
.68605 .32793 m .73944 .38274 L .70164 .36374 L F
.438 .593 .908 r
.64803 .32263 m .68605 .32793 L .70164 .36374 L F
.689 .866 .966 r
.45834 .30984 m .45901 .28377 L .48134 .2975 L F
.45834 .30984 m .42489 .30231 L .45901 .28377 L F
.978 .703 .435 r
.25927 .66629 m .21762 .65452 L .21784 .6144 L F
.25927 .66629 m .25909 .70517 L .21762 .65452 L F
.504 .677 .943 r
.59097 .30754 m .62287 .29886 L .64803 .32263 L F
.501 .719 .969 r
.56702 .29601 m .62287 .29886 L .59097 .30754 L F
.782 .35 .222 r
.40949 .83642 m .35094 .83893 L .3365 .81197 L F
.40949 .83642 m .41824 .86113 L .35094 .83893 L F
.886 .491 .273 r
.32698 .78049 m .27809 .77627 L .26532 .74214 L F
.32698 .78049 m .3365 .81197 L .27809 .77627 L F
.761 .92 .942 r
.40165 .32686 m .39278 .30124 L .42489 .30231 L F
.40165 .32686 m .36284 .33346 L .39278 .30124 L F
.507 .14 .278 r
.65551 .83332 m .64582 .85831 L .57136 .87106 L F
.337 0 .206 r
.72657 .80696 m .64582 .85831 L .65551 .83332 L F
.418 .123 .354 r
.73666 .77511 m .72657 .80696 L .65551 .83332 L F
.111 .212 .69 r
.80142 .43584 m .81649 .52683 L .79528 .49037 L F
.241 .34 .765 r
.773 .4069 m .80142 .43584 L .79528 .49037 L F
.384 .625 .948 r
.62287 .29886 m .68605 .32793 L .64803 .32263 L F
.064 0 .414 r
.83893 .60531 m .80176 .69767 L .80158 .65861 L F
.185 .115 .539 r
.83123 .56541 m .83893 .60531 L .80158 .65861 L F
.18 0 .248 r
.79531 .73499 m .72657 .80696 L .73666 .77511 L F
.282 .065 .396 r
.80176 .69767 m .79531 .73499 L .73666 .77511 L F
.626 .849 .985 r
.48134 .2975 m .50055 .27347 L .50912 .29068 L F
.48134 .2975 m .45901 .28377 L .50055 .27347 L F
.882 .966 .843 r
.31224 .38985 m .29481 .365 L .32691 .34619 L F
.31224 .38985 m .27869 .41501 L .29481 .365 L F
.501 .719 .969 r
.56702 .29601 m .58729 .28152 L .62287 .29886 L F
.52 .766 .986 r
.53874 .29017 m .58729 .28152 L .56702 .29601 L F
.992 .881 .589 r
.23987 .53567 m .21233 .51572 L .22793 .47852 L F
.23987 .53567 m .2254 .57449 L .21233 .51572 L F
.565 .813 .992 r
.50912 .29068 m .54497 .27269 L .53874 .29017 L F
.50912 .29068 m .50055 .27347 L .54497 .27269 L F
.52 .766 .986 r
.53874 .29017 m .54497 .27269 L .58729 .28152 L F
.168 .404 .846 r
.72129 .33948 m .773 .4069 L .73944 .38274 L F
.324 .516 .89 r
.68605 .32793 m .72129 .33948 L .73944 .38274 L F
.645 .168 .105 r
.49361 .87202 m .42995 .87999 L .41824 .86113 L F
.49361 .87202 m .49712 .88958 L .42995 .87999 L F
.553 .1 .131 r
.57136 .87106 m .49712 .88958 L .49361 .87202 L F
.57136 .87106 m .5665 .88874 L .49712 .88958 L F
.419 0 .095 r
.64582 .85831 m .5665 .88874 L .57136 .87106 L F
.959 .62 .273 r
.25909 .70517 m .22505 .69389 L .21762 .65452 L F
.25909 .70517 m .26532 .74214 L .22505 .69389 L F
0 .04 .572 r
.82384 .46908 m .83123 .56541 L .81649 .52683 L F
.111 .212 .69 r
.80142 .43584 m .82384 .46908 L .81649 .52683 L F
.67 .924 .973 r
.42489 .30231 m .43744 .27675 L .45901 .28377 L F
.42489 .30231 m .39278 .30124 L .43744 .27675 L F
.77 .974 .919 r
.36284 .33346 m .36283 .307 L .39278 .30124 L F
.36284 .33346 m .32691 .34619 L .36283 .307 L F
.902 .986 .762 r
.27869 .41501 m .26746 .38973 L .29481 .365 L F
.27869 .41501 m .25031 .44474 L .26746 .38973 L F
.384 .625 .948 r
.62287 .29886 m .65352 .2967 L .68605 .32793 L F
.348 .674 .977 r
.58729 .28152 m .65352 .2967 L .62287 .29886 L F
.828 .356 .07 r
.3365 .81197 m .2974 .80663 L .27809 .77627 L F
.3365 .81197 m .35094 .83893 L .2974 .80663 L F
.201 .528 .921 r
.65352 .2967 m .72129 .33948 L .68605 .32793 L F
0 0 .233 r
.83915 .64565 m .79531 .73499 L .80176 .69767 L F
.064 0 .414 r
.83893 .60531 m .83915 .64565 L .80176 .69767 L F
.704 .19 .004 r
.41824 .86113 m .37022 .8605 L .35094 .83893 L F
.41824 .86113 m .42995 .87999 L .37022 .8605 L F
.983 .826 .431 r
.2254 .57449 m .20416 .55554 L .21233 .51572 L F
.2254 .57449 m .21784 .6144 L .20416 .55554 L F
0 .238 .753 r
.75282 .35729 m .80142 .43584 L .773 .4069 L F
.168 .404 .846 r
.72129 .33948 m .75282 .35729 L .773 .4069 L F
.337 0 .206 r
.72657 .80696 m .71129 .83438 L .64582 .85831 L F
.031 0 .031 r
.78208 .76963 m .71129 .83438 L .72657 .80696 L F
.18 0 .248 r
.79531 .73499 m .78208 .76963 L .72657 .80696 L F
.419 0 .095 r
.64582 .85831 m .63283 .87751 L .5665 .88874 L F
.203 0 0 r
.71129 .83438 m .63283 .87751 L .64582 .85831 L F
.545 .884 .987 r
.45901 .28377 m .49224 .26308 L .50055 .27347 L F
.45901 .28377 m .43744 .27675 L .49224 .26308 L F
0 0 .391 r
.83949 .50599 m .83893 .60531 L .83123 .56541 L F
0 .04 .572 r
.82384 .46908 m .83949 .50599 L .83123 .56541 L F
.348 .674 .977 r
.58729 .28152 m .60688 .27377 L .65352 .2967 L F
.357 .738 .987 r
.54497 .27269 m .60688 .27377 L .58729 .28152 L F
.883 .474 .041 r
.26532 .74214 m .24025 .7315 L .22505 .69389 L F
.26532 .74214 m .27809 .77627 L .24025 .7315 L F
.879 .956 .611 r
.25031 .44474 m .24579 .42003 L .26746 .38973 L F
.25031 .44474 m .22793 .47852 L .24579 .42003 L F
.739 .992 .829 r
.32691 .34619 m .33588 .31981 L .36283 .307 L F
.32691 .34619 m .29481 .365 L .33588 .31981 L F
.427 .813 .989 r
.50055 .27347 m .551 .26204 L .54497 .27269 L F
.50055 .27347 m .49224 .26308 L .551 .26204 L F
.357 .738 .987 r
.54497 .27269 m .551 .26204 L .60688 .27377 L F
.594 .945 .913 r
.39278 .30124 m .4172 .27702 L .43744 .27675 L F
.39278 .30124 m .36283 .307 L .4172 .27702 L F
0 0 0 r
.83158 .68545 m .78208 .76963 L .79531 .73499 L F
0 0 .233 r
.83915 .64565 m .83158 .68545 L .79531 .73499 L F
.504 0 0 r
.49712 .88958 m .44454 .89222 L .42995 .87999 L F
.49712 .88958 m .50151 .90029 L .44454 .89222 L F
.414 0 0 r
.5665 .88874 m .50151 .90029 L .49712 .88958 L F
0 .352 .817 r
.68215 .30146 m .75282 .35729 L .72129 .33948 L F
.201 .528 .921 r
.65352 .2967 m .68215 .30146 L .72129 .33948 L F
.911 .702 .202 r
.21784 .6144 m .20393 .59707 L .20416 .55554 L F
.21784 .6144 m .21762 .65452 L .20393 .59707 L F
.414 0 0 r
.5665 .88874 m .56044 .89958 L .50151 .90029 L F
.253 0 0 r
.63283 .87751 m .56044 .89958 L .5665 .88874 L F
0 0 .576 r
.7797 .38121 m .82384 .46908 L .80142 .43584 L F
0 .238 .753 r
.75282 .35729 m .7797 .38121 L .80142 .43584 L F
.09 .55 .907 r
.60688 .27377 m .68215 .30146 L .65352 .2967 L F
.682 .138 0 r
.35094 .83893 m .32308 .83227 L .2974 .80663 L F
.35094 .83893 m .37022 .8605 L .32308 .83227 L F
0 0 .136 r
.84769 .54579 m .83915 .64565 L .83893 .60531 L F
0 0 .391 r
.83949 .50599 m .84769 .54579 L .83893 .60531 L F
.203 0 0 r
.71129 .83438 m .69089 .85652 L .63283 .87751 L F
0 0 0 r
.76209 .80063 m .69089 .85652 L .71129 .83438 L F
.031 0 .031 r
.78208 .76963 m .76209 .80063 L .71129 .83438 L F
.52 0 0 r
.42995 .87999 m .39413 .87586 L .37022 .8605 L F
.42995 .87999 m .44454 .89222 L .39413 .87586 L F
.253 0 0 r
.63283 .87751 m .61668 .89013 L .56044 .89958 L F
0 0 0 r
.69089 .85652 m .61668 .89013 L .63283 .87751 L F
.774 .832 .366 r
.22793 .47852 m .23061 .45536 L .24579 .42003 L F
.22793 .47852 m .21233 .51572 L .23061 .45536 L F
.707 .245 0 r
.27809 .77627 m .26313 .76629 L .24025 .7315 L F
.27809 .77627 m .2974 .80663 L .26313 .76629 L F
.619 .907 .619 r
.29481 .365 m .31278 .33972 L .33588 .31981 L F
.29481 .365 m .26746 .38973 L .31278 .33972 L F
.352 .827 .865 r
.43744 .27675 m .48442 .26021 L .49224 .26308 L F
.43744 .27675 m .4172 .27702 L .48442 .26021 L F
.744 .491 0 r
.21762 .65452 m .21196 .63926 L .20393 .59707 L F
.21762 .65452 m .22505 .69389 L .21196 .63926 L F
.09 .55 .907 r
.60688 .27377 m .62528 .27335 L .68215 .30146 L F
.06 .596 .857 r
.551 .26204 m .62528 .27335 L .60688 .27377 L F
0 0 .302 r
.80103 .41094 m .83949 .50599 L .82384 .46908 L F
0 0 .576 r
.7797 .38121 m .80103 .41094 L .82384 .46908 L F
0 0 0 r
.8161 .72368 m .76209 .80063 L .78208 .76963 L F
.83158 .68545 m .8161 .72368 L .78208 .76963 L F
0 .077 .575 r
.70794 .31339 m .7797 .38121 L .75282 .35729 L F
0 .352 .817 r
.68215 .30146 m .70794 .31339 L .75282 .35729 L F
0 g
.5 Mabswid
[ ] 0 setdash
.52495 .90033 m
.52936 .89996 L
s
.49204 .89908 m
.49289 .89907 L
s
.403 .836 .696 r
.36283 .307 m .39889 .28503 L .4172 .27702 L F
.36283 .307 m .33588 .31981 L .39889 .28503 L F
0 g
.66633 .86765 m
.67377 .86521 L
s
.64343 .87802 m
.65026 .87595 L
s
.65026 .87595 m
.65363 .87494 L
s
0 0 .136 r
.84769 .54579 m .84792 .58754 L .83915 .64565 L F
.737 .702 .165 r
.84792 .58754 m .83158 .68545 L .83915 .64565 L F
.151 .689 .832 r
.49224 .26308 m .55668 .25893 L .551 .26204 L F
.49224 .26308 m .48442 .26021 L .55668 .25893 L F
.06 .596 .857 r
.551 .26204 m .55668 .25893 L .62528 .27335 L F
0 g
.69299 .85488 m
.69313 .85482 L
s
0 .292 .666 r
.62528 .27335 m .70794 .31339 L .68215 .30146 L F
.402 0 0 r
.37022 .8605 m .35476 .85229 L .32308 .83227 L F
.37022 .8605 m .39413 .87586 L .35476 .85229 L F
.213 0 0 r
.50151 .90029 m .46181 .89708 L .44454 .89222 L F
.50151 .90029 m .50672 .90343 L .46181 .89708 L F
.138 0 0 r
.56044 .89958 m .50672 .90343 L .50151 .90029 L F
0 g
.65363 .87494 m
.65483 .87454 L
s
.138 0 0 r
.56044 .89958 m .55326 .90287 L .50672 .90343 L F
0 0 0 r
.61668 .89013 m .55326 .90287 L .56044 .89958 L F
.21233 .51572 m .22264 .49498 L .23061 .45536 L F
.21233 .51572 m .20416 .55554 L .22264 .49498 L F
.69089 .85652 m .6656 .87253 L .61668 .89013 L F
.76209 .80063 m .73554 .82704 L .69089 .85652 L F
.405 .815 .613 r
.73554 .82704 m .6656 .87253 L .69089 .85652 L F
0 g
.68217 .86214 m
.6824 .86205 L
s
.68182 .86226 m
.68217 .86214 L
s
.69404 .85448 m
.69615 .85369 L
s
.6939 .85453 m
.69404 .85448 L
s
.69615 .85369 m
.70337 .85049 L
s
0 .043 .566 r
.2974 .80663 m .29338 .7972 L .26313 .76629 L F
.2974 .80663 m .32308 .83227 L .29338 .7972 L F
0 g
.67207 .86844 m
.67209 .86843 L
s
.47845 .89975 m
.48284 .90005 L
s
.68903 .85924 m
.69026 .85872 L
s
.6824 .86205 m
.68903 .85924 L
s
0 0 0 r
.26746 .38973 m .29438 .36659 L .31278 .33972 L F
.26746 .38973 m .24579 .42003 L .29438 .36659 L F
0 0 .383 r
.22505 .69389 m .22834 .68096 L .21196 .63926 L F
.22505 .69389 m .24025 .7315 L .22834 .68096 L F
0 .399 .703 r
.44454 .89222 m .42233 .88426 L .39413 .87586 L F
.44454 .89222 m .46181 .89708 L .42233 .88426 L F
0 0 .302 r
.80103 .41094 m .81598 .44596 L .83949 .50599 L F
.851 .548 .016 r
.81598 .44596 m .84769 .54579 L .83949 .50599 L F
0 g
.43737 .89109 m
.44393 .89245 L
s
.44393 .89245 m
.44807 .8933 L
s
.44807 .8933 m
.44921 .89354 L
s
.43498 .8906 m
.43737 .89109 L
s
0 0 0 r
.61668 .89013 m .59755 .89544 L .55326 .90287 L F
.289 .78 .726 r
.6656 .87253 m .59755 .89544 L .61668 .89013 L F
0 0 0 r
.8161 .72368 m .79281 .75926 L .76209 .80063 L F
.674 .923 .615 r
.79281 .75926 m .73554 .82704 L .76209 .80063 L F
0 g
.67278 .86813 m
.68012 .86493 L
s
.67209 .86843 m
.67278 .86813 L
s
.4442 .89338 m
.4555 .89556 L
s
.4555 .89556 m
.45846 .89613 L
s
.4629 .89765 m
.47845 .89975 L
s
0 .077 .575 r
.70794 .31339 m .73005 .3326 L .7797 .38121 L F
.723 .229 0 r
.73005 .3326 m .80103 .41094 L .7797 .38121 L F
0 g
.69026 .85872 m
.69725 .85514 L
s
.875 .877 .441 r
.83987 .63021 m .8161 .72368 L .83158 .68545 L F
.737 .702 .165 r
.84792 .58754 m .83987 .63021 L .83158 .68545 L F
0 0 0 r
.4172 .27702 m .47732 .26545 L .48442 .26021 L F
.4172 .27702 m .39889 .28503 L .47732 .26545 L F
0 g
.41922 .88587 m
.42975 .88903 L
s
.42975 .88903 m
.43498 .8906 L
s
0 .292 .666 r
.62528 .27335 m .64193 .28076 L .70794 .31339 L F
.321 0 0 r
.55668 .25893 m .64193 .28076 L .62528 .27335 L F
0 0 0 r
.33588 .31981 m .38312 .30104 L .39889 .28503 L F
.33588 .31981 m .31278 .33972 L .38312 .30104 L F
0 g
.68181 .86405 m
.68725 .86119 L
s
.68012 .86493 m
.68181 .86405 L
s
0 0 .236 r
.20416 .55554 m .22241 .53794 L .22264 .49498 L F
.20416 .55554 m .20393 .59707 L .22241 .53794 L F
0 g
.44758 .89438 m
.46149 .89734 L
s
.46149 .89734 m
.4629 .89765 L
s
.42874 .889 m
.4442 .89338 L
s
.607 .037 0 r
.64193 .28076 m .73005 .3326 L .70794 .31339 L F
0 .452 .841 r
.39413 .87586 m .39184 .8659 L .35476 .85229 L F
.39413 .87586 m .42233 .88426 L .39184 .8659 L F
0 .043 .612 r
.24025 .7315 m .25291 .72098 L .22834 .68096 L F
.24025 .7315 m .26313 .76629 L .25291 .72098 L F
0 g
.40405 .87966 m
.41052 .88231 L
s
.41052 .88231 m
.41922 .88587 L
s
.211 0 0 r
.48442 .26021 m .56184 .26395 L .55668 .25893 L F
.48442 .26021 m .47732 .26545 L .56184 .26395 L F
.968 .722 .29 r
.82383 .48554 m .84792 .58754 L .84769 .54579 L F
.851 .548 .016 r
.81598 .44596 m .82383 .48554 L .84769 .54579 L F
0 .309 .79 r
.32308 .83227 m .33044 .82322 L .29338 .7972 L F
.32308 .83227 m .35476 .85229 L .33044 .82322 L F
0 g
.43267 .88986 m
.44632 .894 L
s
.44632 .894 m
.44758 .89438 L
s
.321 0 0 r
.55668 .25893 m .56184 .26395 L .64193 .28076 L F
0 0 .04 r
.24579 .42003 m .28144 .40003 L .29438 .36659 L F
.24579 .42003 m .23061 .45536 L .28144 .40003 L F
.289 .78 .726 r
.6656 .87253 m .63582 .88165 L .59755 .89544 L F
.569 .939 .858 r
.70282 .84795 m .63582 .88165 L .6656 .87253 L F
.405 .815 .613 r
.73554 .82704 m .70282 .84795 L .6656 .87253 L F
0 g
.69725 .85514 m
.70326 .85122 L
s
.68725 .86119 m
.69126 .85851 L
s
.69126 .85851 m
.69338 .8571 L
s
.41383 .88324 m
.41678 .88438 L
s
.41678 .88438 m
.42874 .889 L
s
.17 .677 .904 r
.50672 .90343 m .48149 .89397 L .46181 .89708 L F
.50672 .90343 m .51267 .8984 L .48149 .89397 L F
.225 .733 .891 r
.55326 .90287 m .51267 .8984 L .50672 .90343 L F
.55326 .90287 m .54505 .89801 L .51267 .8984 L F
.343 .814 .909 r
.59755 .89544 m .54505 .89801 L .55326 .90287 L F
.75 .993 .81 r
.76204 .79112 m .70282 .84795 L .73554 .82704 L F
0 g
.70326 .85122 m
.70818 .84686 L
s
.674 .923 .615 r
.79281 .75926 m .76204 .79112 L .73554 .82704 L F
.923 .96 .642 r
.82343 .67261 m .79281 .75926 L .8161 .72368 L F
.875 .877 .441 r
.83987 .63021 m .82343 .67261 L .8161 .72368 L F
.886 .457 .09 r
.74769 .35896 m .81598 .44596 L .80103 .41094 L F
.723 .229 0 r
.73005 .3326 m .74769 .35896 L .80103 .41094 L F
0 g
.41836 .88402 m
.42084 .88504 L
s
.69338 .8571 m
.69839 .8526 L
s
.39968 .87732 m
.40405 .87966 L
s
.38968 .87194 m
.39968 .87732 L
s
.184 .648 .938 r
.46181 .89708 m .45426 .88506 L .42233 .88426 L F
0 g
.42084 .88504 m
.43267 .88986 L
s
.184 .648 .938 r
.46181 .89708 m .48149 .89397 L .45426 .88506 L F
0 0 .456 r
.20393 .59707 m .23025 .58313 L .22241 .53794 L F
.20393 .59707 m .21196 .63926 L .23025 .58313 L F
0 g
.40576 .87914 m
.41383 .88324 L
s
.39969 .87605 m
.40576 .87914 L
s
.343 .814 .909 r
.59755 .89544 m .57579 .89283 L .54505 .89801 L F
.496 .894 .943 r
.63582 .88165 m .57579 .89283 L .59755 .89544 L F
0 g
.70922 .84548 m
.71168 .84221 L
s
.70818 .84686 m
.70922 .84548 L
s
.71168 .84221 m
.71187 .84196 L
s
.249 0 0 r
.39889 .28503 m .47119 .27919 L .47732 .26545 L F
.39889 .28503 m .38312 .30104 L .47119 .27919 L F
.126 0 .023 r
.31278 .33972 m .37051 .3251 L .38312 .30104 L F
.31278 .33972 m .29438 .36659 L .37051 .3251 L F
.001 .255 .761 r
.26313 .76629 m .28518 .75808 L .25291 .72098 L F
.26313 .76629 m .29338 .7972 L .28518 .75808 L F
0 g
.41383 .88162 m
.41836 .88402 L
s
.69839 .8526 m
.70099 .84914 L
s
1 .814 .485 r
.82405 .52873 m .83987 .63021 L .84792 .58754 L F
.968 .722 .29 r
.82383 .48554 m .82405 .52873 L .84792 .58754 L F
.607 .037 0 r
.64193 .28076 m .65628 .29628 L .73005 .3326 L F
.581 .036 0 r
.56184 .26395 m .65628 .29628 L .64193 .28076 L F
.054 0 .285 r
.23061 .45536 m .27463 .43937 L .28144 .40003 L F
.23061 .45536 m .22264 .49498 L .27463 .43937 L F
.148 .502 .909 r
.35476 .85229 m .37347 .84343 L .33044 .82322 L F
.35476 .85229 m .39184 .8659 L .37347 .84343 L F
0 g
.37634 .86273 m
.37819 .86401 L
s
.37819 .86401 m
.38968 .87194 L
s
.777 .286 .055 r
.65628 .29628 m .74769 .35896 L .73005 .3326 L F
.252 .635 .961 r
.42233 .88426 m .43352 .8724 L .39184 .8659 L F
0 g
.38652 .86745 m
.39969 .87605 L
s
.40485 .87685 m
.4058 .87735 L
s
.4058 .87735 m
.41383 .88162 L
s
.252 .635 .961 r
.42233 .88426 m .45426 .88506 L .43352 .8724 L F
.914 .978 .771 r
.79882 .71352 m .76204 .79112 L .79281 .75926 L F
.923 .96 .642 r
.82343 .67261 m .79882 .71352 L .79281 .75926 L F
.569 .939 .858 r
.70282 .84795 m .66456 .86253 L .63582 .88165 L F
.758 .981 .912 r
.72439 .8182 m .66456 .86253 L .70282 .84795 L F
0 g
.70131 .84871 m
.70189 .84795 L
s
.70099 .84914 m
.70131 .84871 L
s
.70189 .84795 m
.70216 .84759 L
s
.75 .993 .81 r
.76204 .79112 m .72439 .8182 L .70282 .84795 L F
0 g
.71187 .84196 m
.71247 .84054 L
s
.71247 .84054 m
.71421 .83642 L
s
.496 .894 .943 r
.63582 .88165 m .60213 .88326 L .57579 .89283 L F
.638 .938 .963 r
.66456 .86253 m .60213 .88326 L .63582 .88165 L F
0 g
.39662 .87126 m
.40485 .87685 L
s
.39234 .86835 m
.39662 .87126 L
s
.063 .115 .606 r
.21196 .63926 m .24619 .62924 L .23025 .58313 L F
.21196 .63926 m .22834 .68096 L .24619 .62924 L F
0 g
.70216 .84759 m
.70456 .84197 L
s
.943 .592 .316 r
.76009 .39211 m .82383 .48554 L .81598 .44596 L F
.886 .457 .09 r
.74769 .35896 m .76009 .39211 L .81598 .44596 L F
0 g
.36877 .85609 m
.37634 .86273 L
s
.36422 .8521 m
.36877 .85609 L
s
.46 0 0 r
.47732 .26545 m .56629 .27752 L .56184 .26395 L F
.47732 .26545 m .47119 .27919 L .56629 .27752 L F
0 g
.37631 .85896 m
.38457 .86582 L
s
.38457 .86582 m
.38652 .86745 L
s
.37453 .85748 m
.37631 .85896 L
s
.581 .036 0 r
.56184 .26395 m .56629 .27752 L .65628 .29628 L F
.18 .413 .851 r
.29338 .7972 m .32442 .79105 L .28518 .75808 L F
.29338 .7972 m .33044 .82322 L .32442 .79105 L F
.442 .784 .998 r
.51267 .8984 m .50315 .88247 L .48149 .89397 L F
.51267 .8984 m .51925 .88478 L .50315 .88247 L F
.474 .818 .998 r
.54505 .89801 m .51925 .88478 L .51267 .8984 L F
.54505 .89801 m .53599 .88458 L .51925 .88478 L F
.528 .851 .998 r
.57579 .89283 m .53599 .88458 L .54505 .89801 L F
.988 .857 .618 r
.81633 .57439 m .82343 .67261 L .83987 .63021 L F
1 .814 .485 r
.82405 .52873 m .81633 .57439 L .83987 .63021 L F
0 g
.38711 .86385 m
.38943 .86584 L
s
.38943 .86584 m
.39234 .86835 L
s
.435 .753 .994 r
.48149 .89397 m .48921 .87785 L .45426 .88506 L F
.48149 .89397 m .50315 .88247 L .48921 .87785 L F
0 g
.70456 .84197 m
.70493 .83941 L
s
.877 .963 .85 r
.7665 .75166 m .72439 .8182 L .76204 .79112 L F
.914 .978 .771 r
.79882 .71352 m .7665 .75166 L .76204 .79112 L F
.528 .851 .998 r
.57579 .89283 m .55183 .88188 L .53599 .88458 L F
.591 .874 .993 r
.60213 .88326 m .55183 .88188 L .57579 .89283 L F
.283 0 .258 r
.29438 .36659 m .36162 .35694 L .37051 .3251 L F
.29438 .36659 m .28144 .40003 L .36162 .35694 L F
.192 .053 .451 r
.22264 .49498 m .27444 .48366 L .27463 .43937 L F
.22264 .49498 m .22241 .53794 L .27444 .48366 L F
.341 .627 .958 r
.39184 .8659 m .42138 .85705 L .37347 .84343 L F
0 g
.36388 .84625 m
.37453 .85748 L
s
.38102 .8586 m
.38234 .85974 L
s
.38234 .85974 m
.38711 .86385 L
s
.341 .627 .958 r
.39184 .8659 m .43352 .8724 L .42138 .85705 L F
.193 .263 .707 r
.22834 .68096 m .26998 .67486 L .24619 .62924 L F
.22834 .68096 m .25291 .72098 L .26998 .67486 L F
.413 .01 .163 r
.38312 .30104 m .46628 .30159 L .47119 .27919 L F
.38312 .30104 m .37051 .3251 L .46628 .30159 L F
.638 .938 .963 r
.66456 .86253 m .62162 .87009 L .60213 .88326 L F
.732 .933 .955 r
.68074 .83958 m .62162 .87009 L .66456 .86253 L F
.758 .981 .912 r
.72439 .8182 m .68074 .83958 L .66456 .86253 L F
0 g
.70493 .83941 m
.70548 .83566 L
s
.71421 .83642 m
.71505 .83013 L
s
.37369 .85059 m
.38102 .8586 L
s
.37104 .84769 m
.37369 .85059 L
s
.84 .436 .277 r
.66776 .31999 m .76009 .39211 L .74769 .35896 L F
.777 .286 .055 r
.65628 .29628 m .66776 .31999 L .74769 .35896 L F
.698 .245 .174 r
.56629 .27752 m .66776 .31999 L .65628 .29628 L F
0 g
.7148 .82782 m
.71505 .83013 L
s
.45 .727 .985 r
.45426 .88506 m .47875 .87132 L .43352 .8724 L F
.45426 .88506 m .48921 .87785 L .47875 .87132 L F
.951 .669 .466 r
.76663 .4314 m .82405 .52873 L .82383 .48554 L F
.943 .592 .316 r
.76009 .39211 m .76663 .4314 L .82383 .48554 L F
.591 .874 .993 r
.60213 .88326 m .5653 .87692 L .55183 .88188 L F
.649 .882 .983 r
.62162 .87009 m .5653 .87692 L .60213 .88326 L F
.318 .531 .903 r
.33044 .82322 m .36955 .81881 L .32442 .79105 L F
.33044 .82322 m .37347 .84343 L .36955 .81881 L F
0 g
.35351 .84016 m
.36422 .8521 L
s
.34433 .82708 m
.35168 .83756 L
s
.35168 .83756 m
.35351 .84016 L
s
.35473 .83393 m
.35981 .84077 L
s
.35981 .84077 m
.36388 .84625 L
s
.958 .873 .71 r
.80064 .6212 m .79882 .71352 L .82343 .67261 L F
.988 .857 .618 r
.81633 .57439 m .80064 .6212 L .82343 .67261 L F
.829 .933 .899 r
.72727 .7858 m .68074 .83958 L .72439 .8182 L F
0 g
.70478 .82859 m
.70512 .83202 L
s
.70512 .83202 m
.70548 .83566 L
s
.71427 .82303 m
.71458 .82581 L
s
.71458 .82581 m
.7148 .82782 L
s
.877 .963 .85 r
.7665 .75166 m .72727 .7858 L .72439 .8182 L F
0 g
.36317 .83665 m
.36741 .8426 L
s
.36741 .8426 m
.37104 .84769 L
s
.36256 .83579 m
.36317 .83665 L
s
.293 .377 .778 r
.25291 .72098 m .30104 .71853 L .26998 .67486 L F
.25291 .72098 m .28518 .75808 L .30104 .71853 L F
.289 .189 .563 r
.22241 .53794 m .28113 .53168 L .27444 .48366 L F
.22241 .53794 m .23025 .58313 L .28113 .53168 L F
0 g
.71363 .82101 m
.71427 .82303 L
s
.58 .157 .203 r
.47119 .27919 m .56987 .29979 L .56629 .27752 L F
.47119 .27919 m .46628 .30159 L .56987 .29979 L F
0 g
.34413 .82671 m
.34433 .82708 L
s
.33682 .81307 m
.34413 .82671 L
s
.48 .707 .969 r
.43352 .8724 m .47282 .8635 L .42138 .85705 L F
.43352 .8724 m .47875 .87132 L .47282 .8635 L F
.698 .245 .174 r
.56629 .27752 m .56987 .29979 L .66776 .31999 L F
0 g
.35317 .83119 m
.35473 .83393 L
s
.34721 .82069 m
.35317 .83119 L
s
.70379 .82537 m
.70478 .82859 L
s
.649 .882 .983 r
.62162 .87009 m .5751 .87014 L .5653 .87692 L F
.693 .874 .966 r
.63223 .85443 m .5751 .87014 L .62162 .87009 L F
.732 .933 .955 r
.68074 .83958 m .63223 .85443 L .62162 .87009 L F
.379 .133 .41 r
.28144 .40003 m .35693 .396 L .36162 .35694 L F
.28144 .40003 m .27463 .43937 L .35693 .396 L F
.625 .78 .955 r
.56441 .83889 m .51925 .88478 L .53599 .88458 L F
.56441 .83889 m .50315 .88247 L .51925 .88478 L F
.56441 .83889 m .53599 .88458 L .55183 .88188 L F
.427 .621 .933 r
.37347 .84343 m .41927 .84041 L .36955 .81881 L F
.37347 .84343 m .42138 .85705 L .41927 .84041 L F
.92 .876 .776 r
.77723 .66772 m .7665 .75166 L .79882 .71352 L F
.958 .873 .71 r
.80064 .6212 m .77723 .66772 L .79882 .71352 L F
0 g
.35568 .82308 m
.36256 .83579 L
s
.625 .78 .955 r
.56441 .83889 m .48921 .87785 L .50315 .88247 L F
.94 .715 .57 r
.76681 .47588 m .81633 .57439 L .82405 .52873 L F
.951 .669 .466 r
.76663 .4314 m .76681 .47588 L .82405 .52873 L F
.625 .78 .955 r
.56441 .83889 m .55183 .88188 L .5653 .87692 L F
.775 .895 .928 r
.68221 .81482 m .63223 .85443 L .68074 .83958 L F
.829 .933 .899 r
.72727 .7858 m .68221 .81482 L .68074 .83958 L F
0 g
.70236 .82072 m
.70379 .82537 L
s
.71174 .81505 m
.71363 .82101 L
s
.858 .525 .42 r
.67586 .35163 m .76663 .4314 L .76009 .39211 L F
.84 .436 .277 r
.66776 .31999 m .67586 .35163 L .76009 .39211 L F
0 g
.33104 .79837 m
.33682 .81307 L
s
.501 .171 .339 r
.37051 .3251 m .46281 .33249 L .46628 .30159 L F
.37051 .3251 m .36162 .35694 L .46281 .33249 L F
0 g
.34137 .80675 m
.34721 .82069 L
s
.625 .78 .955 r
.56441 .83889 m .47875 .87132 L .48921 .87785 L F
.374 .471 .831 r
.28518 .75808 m .33851 .75881 L .30104 .71853 L F
.28518 .75808 m .32442 .79105 L .33851 .75881 L F
0 g
.70737 .80618 m
.71174 .81505 L
s
.625 .78 .955 r
.56441 .83889 m .5653 .87692 L .5751 .87014 L F
0 g
.69813 .81203 m
.70236 .82072 L
s
.745 .371 .345 r
.56987 .29979 m .67586 .35163 L .66776 .31999 L F
.36 .293 .645 r
.23025 .58313 m .29472 .58199 L .28113 .53168 L F
.23025 .58313 m .24619 .62924 L .29472 .58199 L F
.515 .693 .949 r
.42138 .85705 m .47207 .8551 L .41927 .84041 L F
.42138 .85705 m .47282 .8635 L .47207 .8551 L F
.878 .871 .826 r
.74669 .71243 m .72727 .7858 L .7665 .75166 L F
.92 .876 .776 r
.77723 .66772 m .74669 .71243 L .7665 .75166 L F
.625 .78 .955 r
.56441 .83889 m .47282 .8635 L .47875 .87132 L F
.56441 .83889 m .5751 .87014 L .58023 .86217 L F
.693 .874 .966 r
.63223 .85443 m .58023 .86217 L .5751 .87014 L F
.718 .852 .946 r
.63265 .83772 m .58023 .86217 L .63223 .85443 L F
.775 .895 .928 r
.68221 .81482 m .63265 .83772 L .63223 .85443 L F
.441 .55 .871 r
.32442 .79105 m .38121 .79438 L .33851 .75881 L F
0 g
.32702 .78322 m
.32891 .79033 L
s
.441 .55 .871 r
.32442 .79105 m .36955 .81881 L .38121 .79438 L F
0 g
.32958 .79284 m
.33104 .79837 L
s
.32891 .79033 m
.32958 .79284 L
s
.33727 .79236 m
.33823 .79572 L
s
.33823 .79572 m
.34137 .80675 L
s
.35047 .80978 m
.352 .81367 L
s
.352 .81367 m
.35568 .82308 L
s
.92 .743 .646 r
.76039 .52432 m .80064 .6212 L .81633 .57439 L F
.94 .715 .57 r
.76681 .47588 m .76039 .52432 L .81633 .57439 L F
0 g
.34831 .80134 m
.35047 .80978 L
s
.34697 .7961 m
.34831 .80134 L
s
.442 .243 .513 r
.27463 .43937 m .35679 .44132 L .35693 .396 L F
.27463 .43937 m .27444 .48366 L .35679 .44132 L F
.625 .78 .955 r
.56441 .83889 m .47207 .8551 L .47282 .8635 L F
.833 .86 .865 r
.70991 .75387 m .68221 .81482 L .72727 .7858 L F
0 g
.69736 .81082 m
.69813 .81203 L
s
.70716 .80585 m
.70737 .80618 L
s
.878 .871 .826 r
.74669 .71243 m .70991 .75387 L .72727 .7858 L F
.625 .78 .955 r
.56441 .83889 m .58023 .86217 L .58013 .85376 L F
.718 .852 .946 r
.63265 .83772 m .58013 .85376 L .58023 .86217 L F
.638 .288 .361 r
.46628 .30159 m .57239 .33062 L .56987 .29979 L F
.46628 .30159 m .46281 .33249 L .57239 .33062 L F
.499 .621 .902 r
.36955 .81881 m .42776 .82406 L .38121 .79438 L F
.36955 .81881 m .41927 .84041 L .42776 .82406 L F
.745 .371 .345 r
.56987 .29979 m .57239 .33062 L .67586 .35163 L F
.415 .376 .707 r
.24619 .62924 m .31491 .63294 L .29472 .58199 L F
.24619 .62924 m .26998 .67486 L .31491 .63294 L F
0 g
.32476 .7679 m
.32702 .78322 L
s
.33492 .77778 m
.3366 .78819 L
s
.3366 .78819 m
.33727 .79236 L
s
.859 .582 .518 r
.68013 .39064 m .76681 .47588 L .76663 .4314 L F
.858 .525 .42 r
.67586 .35163 m .68013 .39064 L .76663 .4314 L F
.784 .845 .898 r
.66805 .79065 m .63265 .83772 L .68221 .81482 L F
.833 .86 .865 r
.70991 .75387 m .66805 .79065 L .68221 .81482 L F
0 g
.70163 .79721 m
.70716 .80585 L
s
.70112 .79641 m
.70163 .79721 L
s
.69306 .80408 m
.69736 .81082 L
s
.69206 .80252 m
.69306 .80408 L
s
.552 .686 .928 r
.41927 .84041 m .47665 .84695 L .42776 .82406 L F
.41927 .84041 m .47207 .8551 L .47665 .84695 L F
0 g
.34518 .7823 m
.34697 .7961 L
s
.625 .78 .955 r
.56441 .83889 m .47665 .84695 L .47207 .8551 L F
.56441 .83889 m .58013 .85376 L .5747 .84573 L F
.728 .824 .925 r
.62248 .82159 m .58013 .85376 L .63265 .83772 L F
.62248 .82159 m .5747 .84573 L .58013 .85376 L F
.784 .845 .898 r
.66805 .79065 m .62248 .82159 L .63265 .83772 L F
.551 .277 .453 r
.36162 .35694 m .46098 .37136 L .46281 .33249 L F
.36162 .35694 m .35693 .396 L .46098 .37136 L F
0 g
.69297 .7858 m
.70112 .79641 L
s
.897 .762 .705 r
.74737 .57524 m .77723 .66772 L .80064 .6212 L F
.92 .743 .646 r
.76039 .52432 m .74737 .57524 L .80064 .6212 L F
0 g
.68415 .79225 m
.69206 .80252 L
s
.3245 .7609 m
.32476 .7679 L
s
.3242 .75264 m
.3245 .7609 L
s
.33429 .76325 m
.33492 .77778 L
s
.764 .451 .457 r
.57239 .33062 m .68013 .39064 L .67586 .35163 L F
.459 .447 .757 r
.26998 .67486 m .34113 .68283 L .31491 .63294 L F
.26998 .67486 m .30104 .71853 L .34113 .68283 L F
0 g
.3451 .76863 m
.34518 .7823 L
s
.625 .78 .955 r
.56441 .83889 m .48621 .83988 L .47665 .84695 L F
.587 .685 .909 r
.42776 .82406 m .47665 .84695 L .48621 .83988 L F
.485 .325 .588 r
.27444 .48366 m .3614 .49161 L .35679 .44132 L F
.27444 .48366 m .28113 .53168 L .3614 .49161 L F
.725 .794 .907 r
.6024 .80771 m .5747 .84573 L .62248 .82159 L F
.6024 .80771 m .56441 .83889 L .5747 .84573 L F
.871 .776 .754 r
.72802 .62697 m .74669 .71243 L .77723 .66772 L F
.897 .762 .705 r
.74737 .57524 m .72802 .62697 L .77723 .66772 L F
0 g
.33429 .76325 m
.3346 .75896 L
s
.496 .51 .801 r
.30104 .71853 m .37252 .72995 L .34113 .68283 L F
.30104 .71853 m .33851 .75881 L .37252 .72995 L F
0 g
.33506 .75267 m
.33532 .74901 L
s
.33478 .7565 m
.33506 .75267 L
s
.3346 .75896 m
.33478 .7565 L
s
.32432 .75097 m
.32529 .73771 L
s
.3242 .75264 m
.32432 .75097 L
s
.587 .685 .909 r
.42776 .82406 m .48621 .83988 L .44635 .80972 L F
.559 .627 .875 r
.38121 .79438 m .42776 .82406 L .44635 .80972 L F
.852 .623 .59 r
.68025 .43609 m .76039 .52432 L .76681 .47588 L F
.859 .582 .518 r
.68013 .39064 m .68025 .43609 L .76681 .47588 L F
.625 .78 .955 r
.56441 .83889 m .49985 .83461 L .48621 .83988 L F
.62 .691 .895 r
.44635 .80972 m .48621 .83988 L .49985 .83461 L F
.625 .78 .955 r
.56441 .83889 m .5162 .83171 L .49985 .83461 L F
.56441 .83889 m .5336 .83149 L .5162 .83171 L F
.56441 .83889 m .55024 .83397 L .5336 .83149 L F
.714 .766 .893 r
.57427 .79763 m .56441 .83889 L .6024 .80771 L F
.57427 .79763 m .55024 .83397 L .56441 .83889 L F
.772 .795 .871 r
.63898 .76966 m .62248 .82159 L .66805 .79065 L F
.63898 .76966 m .6024 .80771 L .62248 .82159 L F
.529 .569 .839 r
.33851 .75881 m .40801 .77271 L .37252 .72995 L F
.33851 .75881 m .38121 .79438 L .40801 .77271 L F
0 g
.3451 .76863 m
.34589 .76187 L
s
.34615 .75963 m
.34666 .7553 L
s
.34589 .76187 m
.34615 .75963 L
s
.559 .627 .875 r
.38121 .79438 m .44635 .80972 L .40801 .77271 L F
.842 .785 .796 r
.70291 .67777 m .70991 .75387 L .74669 .71243 L F
.871 .776 .754 r
.72802 .62697 m .70291 .67777 L .74669 .71243 L F
.667 .373 .465 r
.46281 .33249 m .57372 .36947 L .57239 .33062 L F
.46281 .33249 m .46098 .37136 L .57372 .36947 L F
.649 .702 .886 r
.47335 .79894 m .49985 .83461 L .5162 .83171 L F
.62 .691 .895 r
.44635 .80972 m .49985 .83461 L .47335 .79894 L F
0 g
.32529 .73771 m
.32796 .72333 L
s
.33532 .74901 m
.33795 .73528 L
s
.764 .451 .457 r
.57239 .33062 m .57372 .36947 L .68013 .39064 L F
.697 .74 .885 r
.54097 .79251 m .55024 .83397 L .57427 .79763 L F
.54097 .79251 m .5336 .83149 L .55024 .83397 L F
0 g
.66786 .79068 m
.66793 .79075 L
s
.81 .792 .835 r
.67289 .72587 m .66805 .79065 L .70991 .75387 L F
0 g
.67442 .78132 m
.67876 .78619 L
s
.67876 .78619 m
.68415 .79225 L
s
.68297 .77444 m
.68847 .78069 L
s
.68847 .78069 m
.69297 .7858 L
s
.81 .792 .835 r
.67289 .72587 m .63898 .76966 L .66805 .79065 L F
0 g
.65726 .77994 m
.66781 .79063 L
s
.66781 .79063 m
.66786 .79068 L
s
.842 .785 .796 r
.70291 .67777 m .67289 .72587 L .70991 .75387 L F
.674 .719 .883 r
.50606 .79297 m .5162 .83171 L .5336 .83149 L F
.649 .702 .886 r
.47335 .79894 m .5162 .83171 L .50606 .79297 L F
.674 .719 .883 r
.50606 .79297 m .5336 .83149 L .54097 .79251 L F
.583 .354 .534 r
.35693 .396 m .46092 .41726 L .46098 .37136 L F
.35693 .396 m .35679 .44132 L .46092 .41726 L F
0 g
.34666 .7553 m
.34979 .74253 L
s
.517 .391 .647 r
.28113 .53168 m .37074 .5453 L .3614 .49161 L F
.28113 .53168 m .29472 .58199 L .37074 .5453 L F
0 g
.66298 .76985 m
.67442 .78132 L
s
.67119 .76247 m
.68297 .77444 L
s
.771 .507 .536 r
.57372 .36947 m .68025 .43609 L .68013 .39064 L F
0 g
.33021 .71588 m
.33209 .70969 L
s
.32796 .72333 m
.33021 .71588 L
s
.33795 .73528 m
.34207 .72226 L
s
.609 .639 .855 r
.40801 .77271 m .44635 .80972 L .47335 .79894 L F
.842 .653 .647 r
.67605 .48667 m .74737 .57524 L .76039 .52432 L F
.852 .623 .59 r
.68025 .43609 m .67605 .48667 L .76039 .52432 L F
0 g
.34979 .74253 m
.35442 .73051 L
s
.75 .751 .853 r
.59758 .75429 m .6024 .80771 L .63898 .76966 L F
.59758 .75429 m .57427 .79763 L .6024 .80771 L F
0 g
.64561 .76931 m
.65726 .77994 L
s
.64504 .76879 m
.64561 .76931 L
s
.33209 .70969 m
.33759 .69696 L
s
.34207 .72226 m
.34763 .71014 L
s
.543 .447 .696 r
.29472 .58199 m .38457 .60054 L .37074 .5453 L F
.29472 .58199 m .31491 .63294 L .38457 .60054 L F
0 g
.35442 .73051 m
.35568 .7282 L
s
.35568 .7282 m
.36047 .71941 L
s
.609 .639 .855 r
.40801 .77271 m .47335 .79894 L .44768 .75629 L F
.596 .591 .817 r
.37252 .72995 m .40801 .77271 L .44768 .75629 L F
.652 .658 .843 r
.44768 .75629 m .47335 .79894 L .50606 .79297 L F
.722 .713 .842 r
.54813 .74645 m .57427 .79763 L .59758 .75429 L F
.54813 .74645 m .54097 .79251 L .57427 .79763 L F
0 g
.33759 .69696 m
.34069 .69162 L
s
.829 .677 .694 r
.66755 .54078 m .72802 .62697 L .74737 .57524 L F
.842 .653 .647 r
.67605 .48667 m .66755 .54078 L .74737 .57524 L F
.777 .735 .814 r
.61931 .70522 m .63898 .76966 L .67289 .72587 L F
0 g
.64048 .76501 m
.64347 .76749 L
s
.64347 .76749 m
.64504 .76879 L
s
.65779 .75006 m
.66153 .75353 L
s
.66153 .75353 m
.67119 .76247 L
s
.64995 .75803 m
.65344 .76119 L
s
.65344 .76119 m
.66298 .76985 L
s
.777 .735 .814 r
.61931 .70522 m .59758 .75429 L .63898 .76966 L F
0 g
.63142 .75749 m
.64048 .76501 L
s
.604 .412 .595 r
.35679 .44132 m .46272 .46887 L .46092 .41726 L F
.35679 .44132 m .3614 .49161 L .46272 .46887 L F
.684 .435 .54 r
.46098 .37136 m .57376 .41542 L .57372 .36947 L F
.46098 .37136 m .46092 .41726 L .57376 .41542 L F
.563 .497 .739 r
.31491 .63294 m .40246 .65539 L .38457 .60054 L F
.31491 .63294 m .34113 .68283 L .40246 .65539 L F
.771 .507 .536 r
.57372 .36947 m .57376 .41542 L .68025 .43609 L F
0 g
.64423 .75326 m
.64995 .75803 L
s
.63553 .74602 m
.64423 .75326 L
s
.65046 .74381 m
.65779 .75006 L
s
.64295 .73741 m
.65046 .74381 L
s
.596 .591 .817 r
.37252 .72995 m .44768 .75629 L .42376 .70792 L F
.581 .544 .778 r
.34113 .68283 m .37252 .72995 L .42376 .70792 L F
0 g
.36675 .71089 m
.36785 .70939 L
s
.36047 .71941 m
.36675 .71089 L
s
.34763 .71014 m
.34896 .70799 L
s
.34069 .69162 m
.34224 .68894 L
s
.689 .682 .839 r
.49619 .74714 m .50606 .79297 L .54097 .79251 L F
.652 .658 .843 r
.44768 .75629 m .50606 .79297 L .49619 .74714 L F
.689 .682 .839 r
.49619 .74714 m .54097 .79251 L .54813 .74645 L F
.581 .544 .778 r
.34113 .68283 m .42376 .70792 L .40246 .65539 L F
0 g
.34224 .68894 m
.34436 .68528 L
s
.34896 .70799 m
.35451 .69907 L
s
.772 .548 .596 r
.57376 .41542 m .67605 .48667 L .68025 .43609 L F
0 g
.34472 .68482 m
.35233 .6748 L
s
.34436 .68528 m
.34472 .68482 L
s
.35451 .69907 m
.36263 .68918 L
s
.815 .698 .736 r
.65495 .59656 m .70291 .67777 L .72802 .62697 L F
.829 .677 .694 r
.66755 .54078 m .65495 .59656 L .72802 .62697 L F
.798 .717 .776 r
.63868 .65203 m .67289 .72587 L .70291 .67777 L F
.63868 .65203 m .61931 .70522 L .67289 .72587 L F
0 g
.61661 .74622 m
.63142 .75749 L
s
.36785 .70939 m
.37649 .70057 L
s
.815 .698 .736 r
.65495 .59656 m .63868 .65203 L .70291 .67777 L F
0 g
.61993 .73405 m
.63553 .74602 L
s
.35233 .6748 m
.3614 .6656 L
s
.36263 .68918 m
.37191 .68055 L
s
.62691 .72474 m
.64295 .73741 L
s
.65 .617 .803 r
.42376 .70792 m .44768 .75629 L .49619 .74714 L F
0 g
.37649 .70057 m
.38628 .69304 L
s
.739 .688 .802 r
.55484 .69464 m .59758 .75429 L .61931 .70522 L F
0 g
.60081 .73522 m
.61122 .74247 L
s
.61122 .74247 m
.61661 .74622 L
s
.739 .688 .802 r
.55484 .69464 m .54813 .74645 L .59758 .75429 L F
.619 .461 .645 r
.3614 .49161 m .46637 .52451 L .46272 .46887 L F
.3614 .49161 m .37074 .5453 L .46637 .52451 L F
0 g
.3614 .6656 m
.37151 .65774 L
s
.37191 .68055 m
.38227 .67327 L
s
.60338 .72234 m
.61824 .73285 L
s
.61824 .73285 m
.61993 .73405 L
s
.38628 .69304 m
.39716 .68687 L
s
.77 .582 .645 r
.57245 .46713 m .66755 .54078 L .67605 .48667 L F
.772 .548 .596 r
.57376 .41542 m .57245 .46713 L .67605 .48667 L F
.693 .482 .597 r
.46092 .41726 m .57245 .46713 L .57376 .41542 L F
.46092 .41726 m .46272 .46887 L .57245 .46713 L F
0 g
.6099 .7123 m
.62029 .7199 L
s
.62029 .7199 m
.62691 .72474 L
s
.37151 .65774 m
.38258 .65129 L
s
.59739 .73304 m
.60081 .73522 L
s
.58426 .72467 m
.59739 .73304 L
s
.38227 .67327 m
.39366 .66744 L
s
.697 .649 .798 r
.48695 .69558 m .49619 .74714 L .54813 .74645 L F
.65 .617 .803 r
.42376 .70792 m .49619 .74714 L .48695 .69558 L F
.697 .649 .798 r
.48695 .69558 m .54813 .74645 L .55484 .69464 L F
.646 .579 .765 r
.40246 .65539 m .42376 .70792 L .48695 .69558 L F
0 g
.40466 .6839 m
.40908 .68215 L
s
.39716 .68687 m
.40466 .6839 L
s
.60215 .72154 m
.60338 .72234 L
s
.58612 .71112 m
.60215 .72154 L
s
.38258 .65129 m
.39459 .64631 L
s
.631 .503 .688 r
.37074 .5453 m .47176 .58224 L .46637 .52451 L F
.37074 .5453 m .38457 .60054 L .47176 .58224 L F
0 g
.39366 .66744 m
.3988 .66563 L
s
.40149 .66468 m
.40602 .66309 L
s
.3988 .66563 m
.40149 .66468 L
s
.60974 .71219 m
.6099 .7123 L
s
.75 .663 .764 r
.56083 .63878 m .61931 .70522 L .63868 .65203 L F
0 g
.60733 .71056 m
.60974 .71219 L
s
.75 .663 .764 r
.56083 .63878 m .55484 .69464 L .61931 .70522 L F
0 g
.59218 .70031 m
.60733 .71056 L
s
.56721 .71477 m
.58426 .72467 L
s
.765 .611 .687 r
.5698 .52292 m .65495 .59656 L .66755 .54078 L F
.77 .582 .645 r
.57245 .46713 m .5698 .52292 L .66755 .54078 L F
.646 .579 .765 r
.40246 .65539 m .48695 .69558 L .4787 .63996 L F
0 g
.40968 .6623 m
.41929 .66023 L
s
.40602 .66309 m
.40968 .6623 L
s
.42091 .67918 m
.42195 .67892 L
s
.40908 .68215 m
.42091 .67918 L
s
.639 .542 .728 r
.38457 .60054 m .40246 .65539 L .4787 .63996 L F
0 g
.39459 .64631 m
.40308 .64403 L
s
.40308 .64403 m
.40749 .64284 L
s
.56841 .70059 m
.58612 .71112 L
s
.42195 .67892 m
.43572 .67719 L
s
.639 .542 .728 r
.38457 .60054 m .4787 .63996 L .47176 .58224 L F
0 g
.54987 .70572 m
.56167 .71188 L
s
.56167 .71188 m
.56721 .71477 L
s
.57401 .68898 m
.59218 .70031 L
s
.40861 .64268 m
.42124 .64088 L
s
.40749 .64284 m
.40861 .64268 L
s
.41929 .66023 m
.43342 .6589 L
s
.759 .638 .726 r
.56588 .58084 m .63868 .65203 L .65495 .59656 L F
.56588 .58084 m .56083 .63878 L .63868 .65203 L F
0 g
.43572 .67719 m
.45031 .67697 L
s
.765 .611 .687 r
.5698 .52292 m .56588 .58084 L .65495 .59656 L F
.699 .521 .644 r
.46272 .46887 m .5698 .52292 L .57245 .46713 L F
.46272 .46887 m .46637 .52451 L .5698 .52292 L F
0 g
.54685 .70433 m
.54987 .70572 L
s
.53247 .6977 m
.54685 .70433 L
s
.55693 .69441 m
.56841 .70059 L
s
.45031 .67697 m
.46564 .67825 L
s
.43342 .6589 m
.44835 .65911 L
s
.701 .618 .761 r
.4787 .63996 m .48695 .69558 L .55484 .69464 L F
0 g
.42124 .64088 m
.4358 .64045 L
s
.701 .618 .761 r
.4787 .63996 m .55484 .69464 L .56083 .63878 L F
0 g
.55563 .6785 m
.56223 .68227 L
s
.56223 .68227 m
.57401 .68898 L
s
.55047 .69094 m
.5549 .69332 L
s
.55519 .69347 m
.55693 .69441 L
s
.51519 .69085 m
.53247 .6977 L
s
.47686 .6802 m
.48164 .68104 L
s
.46564 .67825 m
.47686 .6802 L
s
.53253 .68233 m
.55047 .69094 L
s
.49819 .68526 m
.51519 .69085 L
s
.44835 .65911 m
.46404 .66086 L
s
.48164 .68104 m
.491 .68343 L
s
.491 .68343 m
.49819 .68526 L
s
.4358 .64045 m
.45113 .64154 L
s
.54918 .67519 m
.55563 .6785 L
s
.53725 .66906 m
.54918 .67519 L
s
.51476 .67491 m
.53253 .68233 L
s
.47331 .66271 m
.4804 .66412 L
s
.46404 .66086 m
.47331 .66271 L
s
.45113 .64154 m
.4672 .64417 L
s
.4804 .66412 m
.49166 .66724 L
s
.49166 .66724 m
.49734 .66882 L
s
.49734 .66882 m
.51476 .67491 L
s
.51908 .66082 m
.53725 .66906 L
s
.4672 .64417 m
.47444 .64595 L
s
.47643 .64644 m
.48394 .6483 L
s
.47444 .64595 m
.47643 .64644 L
s
.702 .555 .685 r
.46637 .52451 m .56588 .58084 L .5698 .52292 L F
.46637 .52451 m .47176 .58224 L .56588 .58084 L F
0 g
.50127 .65387 m
.51908 .66082 L
s
.48394 .6483 m
.4853 .64873 L
s
.4853 .64873 m
.50127 .65387 L
s
.702 .587 .724 r
.47176 .58224 m .4787 .63996 L .56083 .63878 L F
.47176 .58224 m .56083 .63878 L .56588 .58084 L F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[34]:=",
  ImageSize->{266.562, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004:00017a000`40n007h00Ooooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
P?oo53001500L_oo001lool2000G<008D01]ool007Ooo`<00004<00h0300>00HL0001I0PT42@8910
T2001e00J?oo001cool30008>00HL00:T406D01Tool006koo`@0000<<00h0300>00`03P0<00h0300
>00`03P0670000n@8910T22@@90PT42@8910T22@@90PT42@8910T2000e00H_oo001/ool2000?>00J
TDH4/LD?T41Pool006Woo`0D>00`03P0<00h0300>00`03P0<00h0300>00`03P0<01X1F05J0EP1AZA
APVaa@0<T22@@90PT42@8910T22@@90PT42@89Q0G_oo001Xool00`00>00h000:>008J0DJTDH>/LD7
T402V41Lool006Koo`80000D<00h0300>00`03P0<00h0300J0EP1FP5H0EX1F05J0EP1FP5H0EX1A^A
AQ>aa@06T22@@90PV42H89Q0F_oo001Uool20006>00?J0DKTDHG/LD4V41Hool006?oo`<0000F<00h
0300J0EP1FP5H0EX1F05J0EP1FP5H0EX1F05J0EP1FP5H0EX1F05J0DKTDHH/LD01L91V22H@9PPV400
E_oo001Qool4000FJ0D08J9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[
XT^RJj9;XV^RBj9[XT^jjk[;^^^jb`0C/LD00l91`V72@@04V41Dool0063oo`@0000C601X1F05J0EP
1FP5H0EX1F05J0EP1FP5H0EX1F05J0EP1FP5H0D0185:7J9;2;[;4;7500S2@<91`T32@IPPV42H89Q0
D_oo001Nool40002800?J0D8PDX0:J9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;
XV^RBj9[XT^RJj9;XV^RBj9[XT^jjk[;^^^jbk[[^/^jjk[;^^^jbk[[^//03;7500K2HL91`V72@L9Q
`T44V41@ool005goo`<0000?600P01P0801P1FP5H0EX1F05J0EP1FP5H0EX1F0500b1BQfRBa6jb`Ra
a@0;`T72@<91`T32@L90`T6H89Q0V22H@01>ool005_oo`<000DP00QX1A21BP0bXT^RJj9;XV^RBj9[
XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBk[[^/^jjk[;^^^jbk[[
^/^jjk[;^^^jbk[[^/^jjk[;^^^jbk[[^/^jj`Baa@09`T72HL91`V72@L9Q`T72HL9100>H@00309;o
oooo04[oo`00FOoo0`0000/H0200600P01P0800H06P5H0EX1F0501B1BQfRBaVjb`0>`T72@<91`T32
@L90`T72@<91`T32@IPPV400LT_oo`00F?oo0`001b006H5:04FRBj9[XT^RJj9;XV^RBj9[XT^RJj9;
XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;XV^RBj9[XT^RJj9;^^^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;
^^^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;^^^jbm=XddS2HL91`V72@L9Q`T72HL91`V72@IQ00980B_oo
001Gool200002B00600P01P0800H02006018200IPDXMXT/J^//03m=7ddSCAm=8`T32@L90`T72@<91
`T32@L90`T40LP19ool005Koo`03000P020000HP00=821R1BP18Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZ
kZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>`jk3S/>^`hk3[[[;^^^jbk[[^/^j
jk[;^^^jbk[[^/^jjk[;^^^jbk[[^/^jjk[;^^^jbm=XddSCJ==8dfSCB<9Q`T72HL91`V72@L9Q`T72
H@2BB?oo001Eool03B00600P01P0800H0200601824P7B0Q81dP801B1BPB:3QjZcP09`hk3[/>>`jk3
S/>^`hk3[/>>016jb`0AddOCB==7ddSCAm=8ddOCB<90`T72@<91`T32@L90`T6i`017ool005?oo`PP
00I82161BPR:3P1:Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>
Z^jZcZ[^Z/jZkZ[>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S[[[^/^jjk[;^^^jbk[[^/^jjk[;
^^^jbk[[ddSCJ==8dfSCB==XddSCJ==8`V72@L9Q`T72HL91`V6i`4Koo`00Dooo00hP01P0800H0200
601824P7B0Q81dP8B0M824P7385:3HX>7Z[>01;3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3
[/>>`jh9^//04]=8ddOCB==7ddSCAm=8ddOCB==7ddS2@<91`T32@L90`T6i`4Goo`00D_oo1R002DP8
285:4HX>04ZZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>
Z^jZcZ[^Z/k3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^^/^jjk[;
^^_CB==XddSCJ==8dfSCB==XddSCJ==8dfSCB<9Q`T72HL910[W0A?oo001Aool04200600P01P08018
1dP8B0M824P7B0Q81dP8B0M824P7185:5HX>7Z[>02g3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^
`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkCB==7ddSCAm=8ddOCB==7ddSCAm=8ddOCB==7ddS2@<91
`T000[W0@ooo001@ool01000800P020034P86XX>04bZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>
Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/k3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>
`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S]`]ddSCJ==8dfSCB==XddSCJ==8dfSCB==XddSCJ==8
`V72@@:i`4;oo`00Cooo014001P080181dP8B0M824P7B0Q81dP8B0M824P7B0Q81f4=01Z:3QjZcP0^
`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jkL3=`=
g0cCB==7ddSCAm=8ddOCB==7ddSCAm=8ddOCB==7ddP3^L11ool004koo`03000P04P800a820=Q3AZ:
3P1=Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZ
kZ[>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkL
;M`=g2gL3M`]ddSCJ==8dfSCB==XddSCJ==8dfSCB==XddSCJ003^L10ool004goo`0C00181dP8B0M8
24P7B0Q81dP8B0M824P7B0Q81f4=H>aQ3F3/H@d06XX>7Z[>0333S/>^`hk3[/>>`jk3S/>^`hk3[/>>
`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[]`<g0gL3=`=g0cL3M`<ddSCAm=8ddOCB==7
ddSCAm=8ddOCB==7hj83^L0oool004coo`8000]820MQ3AZ:3P1?Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZ
kZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>Z^jZcZ[^Z/jZkZ[>`jk3S/>^`hk3[/>>`jk3S/>^`hk3
[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkL;M`=g2gL3M`]g0gL;M`=g2gCB==XddSC
J==8dfSCB==XddSCJ>>2hj800kW0?_oo001;ool200004`01B0M824P7B0Q81dP8B0M824P7H@ePk64=
H>aQ3F3/H@ePk64=01J:3PBBdAj[D@K44@0/`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3
S/>^`hk3[/>>`jkL3=`=g0cL3M`<g0gL3=`=g0cL3M`<ddSCAm=8ddOCB==7ddSCAm=8hh7SXP>i`3go
o`00B_oo0P0000<00DP8B0P01TP82V4=4hX>05VBlI;AT_6BdI;aT]6BlI;AZg6[DJ]aZe6[LJ]AZg6[
DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]Aa3744L@aa174<L@Aa374
4L@aa174<L@A`jk3S/>^`hk3[/>>`jk3S/>^`hk3[/>>`jk3S/>^`hkL;M`=g2gL3M`]g0gL;M`=g2gL
3M`]g0gL;M=8dfSCB==XddSCJ==8hj;SP^>R00>i`3coo`00BOoo0P0001@00@00B0Q81dP8B0M824P7
B0QPk64=H>aQ3F3/H@ePk64=H>aQ3F3/3hX>39;A7Z]A4L@A02?3[/>>`jk3S/>^`hk3[/>>`jk3S/>^
g0cL3M`<g0gL3=`=g0cL3M`<g0gL3=`=g0cL3M`<ddSCAm=8ddOCB>>1hj;SPN>R00>i`3_oo`00B?oo
0P000P011TP83F4=2hX>06>BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdJ]aZe6[LJ]AZg6[
DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DL@aa174<L@Aa374
4L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa373S/>^`hk3[/>>g2gL3M`]g0gL;M`=g2gL
3M`]g0gL;M`=g2gL3M`]g0gL;M=8dfSCB==Xhh;SX^>2hj800kW0>_oo0017ool200005P0100000DP7
B0Q81dP8H>aQ3F3/H@ePk64=H>aQ3F3/H@ePk64=H>aQ3F3/1hX>59;A7Z]A7<@A01[L3=`=g0cL3M`<
g0gL3=`=g0cL3M`<g0gL3=`=g0cL3M`<g0gL3==8ddOSX^>1hj;SPN>R0kW0>Ooo0017ool010000040
0@010dP84F4=0hX>06fBlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;a
T]6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]a
Ze74<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744Mb`
g93L/=`=g2gL3M`]g0gL;M`=g2gL3M`]g0gL;M`=g2gL3M`]g0gL;N>2hj;SP^>Rhh;SXP02^L0iool0
04Koo`0H00000@00004004P8H>aQ3F3/H@ePk64=H>aQ3F3/H@ePk64=H>aQ3F3/H@ePk64=79;A7Z]A
7<@A01cLT=b`g93L/=b@g0gL3=`=g0cL3M`<g0gL3=`=g0cL3M`<g0gL3=`=g0cL3OB:hj;SPN>Rhh7S
XP:i`3Soo`00AOoo00<0000100400P014V4=0W7@07>BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;A
T_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]A
Zg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DL@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@A
a3744L@aa174<L@Aa3744L@aa174<L@Ag;3LT=b`g93L/=b@g;3L3M`]g0gL;M`=g2gL3M`]g0gL;M`=
g2gL3M`]g0gdZ_B:hj;SP^>Rhh;SXP02^L0gool004Coo`0F00000@0000400001H>aQ3F3/H@ePk64=
H>aQ3F3/H@ePk64=H>aQ3F3/H@d4LM0LT]4NZe4La1407mb@g;3LT=b`g93L/=b@g;3LT=`=g0cL3M`<
g0gL3=`=g0cL3M`<g0gL3=`=m8[dZ_B:hj;SPN>Rhh7SX[W003Ooo`00A?oo1@0100<82F4=H@d0364=
1W7@07JBlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6B
dJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[
DL@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Ag;3L
T=b`g93L/=b@g;3LT=b`g93L/=`=g2gL3M`]g0gL;M`=g2gL3M`]g0gdZ_B:m:[dR^>Rhh;SX^>2hj:i
`3Koo`00@ooo01<00@000040000100T82F3/H@ePk64=H>aQ3F3/H@ePk64=H>aQ3@08LM0LT]4NZe4L
a1408=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g0gL3=`=g0cL3M`<g0gL3=`=m8[dZ_B:m:[dR^>R
hh7SX^>1hj8fool004;oo`D00@<82@YQ3@Yad01gT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;a
T]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]a
Ze6[LJ]AZg6[DJ]aZe6[LJ]AZg6[DJ]aZe74<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Aa3744L@a
a174<L@Aa3744L@aa174<L@Aa3744Mb`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=`=g2gL3M`]
g0gL;M`=g2gdR_BZm8[dZ_B:hj;SP^>Rhh;SXP0eool0047oo`0A0040000100000@0920T02F4=H>aQ
3F3/H@ePk64=H>aQ3@0<LM0HT]44Ve<07[?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdk?c/m>cl`K4DaK44@0Qg93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L
/=b@g;3LT=`=g0cL3M`<g0gL3?BZm8[dZ_B:m:[dR^>Rhh7SX^>103Goo`00@Ooo100110P91f4=3W7@
07RBlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI;aT]6BlI;AVg>KDi]cVe>KLi]CVg>KDk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAc
a5?4LlACa7?4DlAca5?4LlACa7?4Dl@aa174<L@Aa3744L@aa174<L@Aa3744L@aa174<L@Ag;3LT=b`
g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3L3M`]g0gL;OB:m:[dR_BZm8[dZ_B:hj;SP^>R
hh8dool0047oo`0=0040000100T82@0920T02F4=H>aQ3F3/H@d0477@49;A39]C01jcdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o<Aa5<;a1408]b@
g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=`=g0cdZ_B:m:[dR_BZm8[dZ_B:
hj;SPN>R=?oo0010ool4004520T3H@dBLM00NI;aT]6BlI;AT_6BdI;aT]6BlI;AT_6BdI]cVe>KLi]C
Vg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?Ca7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlAC
a7?4DlAca5?4Ll@Aa3744L@aa17L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@
g;3LT=b`m8[dZ_B:m:[dR_BZm8[dZ_B:hj;SP^>R03?oo`00@?oo00X0000100082@0920T02@P900UQ
3AAad0RBdABKD`0N/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c7<AC02?LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L
/=b@mFkdR_BZm8[dZ_B:m:[dR_BZm8[SX^>103?oo`00?ooo0`011PP95W7@07ZBlI;AT_6BdI]cVe>K
Li]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAca5?4
LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg93L/=b@g;3LT=b`g93L
/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L/?E>mFkdR_BZm8[dZ_B:m:[dR_BZm8[SX^>2<_oo000oool0
2@0100082@0920T02@P900T82@0FLM0LVe<07[?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clac4D`0Tg=;Ll]cBg?;Ld]b`g93L/=b@g;3LT=b`g93L
/=b@g;3LT=b`g93L/=b@g;3LT?E^mDkeK_B:m:[dR_BZm8[dZ_B:m:[dR^>R<_oo000oool00`0120T8
2@0520T00c1>LM1ad00BLM00O7ZbNY9j/Y]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>K
Li]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4
LlACa7?4DlAca5?4LlACg?;Ld]cbg=;Ll]cBg?;LT=b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93L
/?E>mFkeC_E^m8[dZ_B:m:[dR_BZm8[dZ_B:<_oo000nool02P0020T02@P900T82@0920T`;S1>4W7@
1GZB6i]C01jcdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c
/m>clk?C/o<La5<09McBg?;Ld]cbg=;Ll]cBg?;Ld]b`g93L/=b@g;3LT=b`g93L/=b@g;3LT=b`g93e
K_E>mFkeC_E^m8[dZ_B:m:[dR_BZm8[dZ_B:037oo`00?_oo1`P90c1>477@085j/WZBN[9jTWZbNY9j
/Y]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>c
lk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4
LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg=;L
l]cBg?;Ld]cbg=;Ll]b@g;3LT=b`g93L/=b@g;3LT=b`g93L/?E>mFkeC_E^mDkeK_B:m:[dR_BZm8[d
Z_B:m:X0<Ooo000mool02`P900T82@0920T02@P9<2h`CS0^<4h03W7@2GZB6i]C01jcdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o<La5<09]cBg?;L
d]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg;3LT=b`g93L/=b@g;3LT=b`g93eK_E>mFkeC_E^mDkeK_B:m:[d
R_BZm8[dZ_B:g40`ool003goo`H82@D`CPaad026N[9jTWZbNY9j/WZBN[9jTWZbNY9j/Y]CVg>KDi]c
Ve>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAc
a5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg=;Ll]cBg?;Ld]cb
g=;Ll]cBg?;Ld]cbg93L/=b@g;3LT=b`g93L/?E>mFkeC_E^mDkeK_E>mFkdR_BZm8[dZ_B:m:[L@33o
o`00?Ooo00/82@0920T02@P9<2h`CS0^<4h`;S1>00Yad0ejTQ^KD`0N/m>clk?C/o>cdk?c/m>clk?C
/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c7<AC02KLd]cbg=;Ll]cBg?;L
d]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg;3LT=b`g93L/=b@mFkeC_E^mDkeK_E>mFkeC_E^m8[dZ_B:m:[d
R]a0<?oo000mool520T6<4h8LM00RgZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/Y]CVg>KDi]c
Ve>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>KDk?c/m>clk?C/o>cdk?c
/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdk?c/m>clk?C/o>cdlAca5?4LlACa7?4DlAc
a5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACa7?4DlAca5?4LlACg?;Ld]cbg=;Ll]cBg?;Ld]cb
g=;Ll]cBg?;Ld]cbg=;Ll]cBg?;LT=b`g93L/?E>mFkeC_E^mDkeK_E>mFkeC_E^m8[dZ_B:m:[dR]aP
02ooo`00??oo00`000P900T82@09<4h`;S1><2h`CS0^<4h6LM0ANY8GVe<01I^DVkBKU9^dVi@07K@D
00K4U<Bda9C4]<BDa;@Fa5<09mcBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;L
d]b`g93eK_E>mFkeC_E^mDkeK_E>mFkeC_E^m8[dZ_B:m:[L@00_ool003coo`@82@P`CPAad02?N[9j
TWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[:KDi]cVe>KLi]CVg>KDi]cVe>KLi]CVg>K
Di]cVe>KLi]CVg>KU9^dViBK]9^DVkBKU9^dViBK];@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd
5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda5?4LlACa7?4
DlAca5?4LlACa7?4DlAca5?4LlACa7?4Dmcbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;L
d]cbg=;Ll]cBg?;eC_E^mDkeK_E>mFkeC_E^mDkeK_E>mFkdR_BZm8[LH00_ool003coo`0<00T82@09
<4h`;S1><2h`CS0^<4h`;S1>0W7@5GZB3Y]C00jK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D7K@D
0174U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BD00_4D`0Vg=;Ll]cBg?;Ld]cbg=;Ll]cB
g?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld_FbmI;eK_E>mFkeC_E^mDkeK_E>mFkeC_E^m8[dZP;L
@2koo`00>ooo00<000P920T02S1>09Aj/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j
/WZBN[9jTWZbVe>KLi]CVg>KDi]cVe>KLi]CVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK
]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd
=;@Da;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4LlACa7?4DlAca5?L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbmI;e/_FBmFkeC_E^mDke
K_E>mFkeC_E^mDkeK_B:g63L@2koo`00>ooo00h00009<4h`;S1><2h`CS0^<4h`;S1><2h`CTVB5WZB
1I]C01NKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D01fd5012a9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDg?;Ld]cbg=;L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBmK;eT_FbmI;eK_E>mFkeC_E^mDke
K_E>mFkeC_E^0ma0;Ooo000kool00`00<4h`CP09<4h2BI80U7ZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j
/WZBN[9jTWZbNY9j/WZBN[9jTWZbViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK
]9^DVkBKU9^dViBK]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd
=;@D]3Bd5;@d]1Bd=;@Da;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<BdeACE==DDg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbmI;e
/_FBmK;eT_E^mDkeK_E>mFkeC_E^mDkeK_E>mNWL@=aP;Ooo000jool03000<4h`;S1><2h`CS0^<4h`
;S1><2h`CP=9TQEjTP:3500KViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D
VkBKU9^dViBK]9^D01fd5013a9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BD
a;C4U<Bda9C4]<BDeCCE5=DdeACE==cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll]cB
mK;eT_FbmI;e/_FBmFkeC_E^mDkeK_E>mFkeC_E^mLT00]a0;Ooo000jool00`00<4h`CP08<4h4BI80
TGZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY9j/WZBPcB358<dPaBK]9^DVkBKU9^dViBK
]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBd5;@d]1Bd=;@D]3Bd5;@d]1Bd
=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@Da;C4U<Bda9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<BdeACE==DDeCCE5=DdeACLl]cBg?;Ld]cbg=;L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbmI;e/_FBmK;eT_FbmI;eK_E>mFkeC_E^mDkeK_E>00;ej@03g63L
@?oo02_oo`00>_oo00X0031><2h`CS0^<4h`;S1><2h`CPE9TQ5jTPJ3500KViBK]9^DVkBKU9^dViBK
]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D01fd5014a9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDeCCE5=DdeACE==DDeCCE5=Ddg=;L
l]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;Ll_FBmK;eT_FbmI;e/_FBmK;eT_E^mDkeK_E>mFkeC_E^mLWe
j@;L@2coo`00>Ooo0P00231>1TVB095jTWZbNY9j/WZBN[9jTWZbNY9j/WZBN[9jTWZbNY:3=8<DPcB3
58<dPaB3=8<DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBK
U9^d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd
5<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]=DDeCCE
5=DdeACE==DDeCCE5=DdeACLl]cBg?;Ld]cbg=;Ll]cBg?;Ld]cbg=;e/_FBmK;eT_FbmI;e/_FBmK;e
T_E^mDkeK_E>mFkeCP03mNT00ma0ooooo`0Zool003Woo`0900001S1><2h`CS0^<4h`;S1>00Q9TPaj
TP^3500JVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU1fd
5015a9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDeCCE
5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=cbg=;Ll]cBg?;Ld]cbg=;Ll_FBmK;eT_FbmI;e/_FBmK;e
T_FbmI;eK_E>mFkeC_E^mLWejOG900;L@2_oo`00>Ooo00<00007<4h01C1>2DVB091j/WZBN[9jTWZb
NY9j/WZBN[9jTX<dPaB3=8<DPcB358<dPaB3=8<DPcB358<dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^d
ViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK];@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d
]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bd
a9C4]<BDa;C4U<Bda9C4]<BDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==cBg?;Ld]cb
g=;Ll]cBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_FBmFkeC_E^mDh4mNT00maPooooo`0Yool003Soo`80
000600H`CS0^<4h`;S1>2TVB27ZB3h<D01ZK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^d
ViBK]9^DVkBKU9^dViBK]9^D7K@D04O4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4
U<Bda9C4]<BDa;C4U<BdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACLl]cBg?;L
d]cbmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI;eK_E>mFkebOGYmLWejMa002_oo`00>?oo00<00007
00L0131>2dVB091j/WZBN[9jTWZbNY:3=8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<DPcB358<dViBK
]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK];@D]3Bd5;@d]1Bd
=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@d]1Bd=;@D]3Bd5;@da9C4]<BDa;C4U<Bda9C4
]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDeCCE5=DdeACE==DDeCCE5=DdeACE
==DDeCCE5=DdeACE==DDeCCE5=Ddg=;Ll]cBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_E^mDh4
mNT00maPg43oo`0Yool003Soo`0600001`06<4h`;S1>34VB17ZB4h<D01ZK]9^DVkBKU9^dViBK]9^D
VkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^D7;AE04W4mLCEa?G4eLCea=G4]<BDa;C4
U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;CE5=DdeACE==DDeCCE5=DdeACE==DDeCCE
5=DdeACE==DDeCCE5=DdeACE==DDmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI;eK_G9mNWe
bOGYmLWL@00Zool003Soo`0300001`07008`CPe9TP1oN[9jTX<dPaB3=8<DPcB358<dPaB3=8<DPcB3
58<dPaB3=8<DPcB358<dPaB3=8<DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBK
U:@fY1JT=Z@FY3JT5[Ae]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7Fd
EKAe]5FdMLCEa?G4eLCea=G4mLCEa?G4eLCea=G4]<BDa;C4U<Bda9C4]<BDa;C4U<Bda9C4]<BDa;C4
U=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeC@00^gd00oeT_FbmI;e
/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI801OGY00?L@?ooool0:?oo000hool0100600L01S1>3TVB68<D
00nKU9^dViBK]9^DVkBKU9^dViBK]9^DVkBKU9^dVi@02j@F6kAE04W4mLCEa?G4eLCea=G4mLCEa?G4
eLCea=G4mLCEa?G4eLBda9C4]<BDa;C4U<Bda9C4]<BDa;CE5=DdeACE==DDeCCE5=DdeACE==DDeCCE
5=DdeACE==DDeCCE5=DdeACE==DDkOC]e>gdmI;e/_FBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_j?mNWe
bOGYmLWej@0Zool003Ooo`0400001`0700L>BI80P5YDFWB358<dPaB3=8<DPcB358<dPaB3=8<DPcB3
58<dPaB3=8<DPcB358<dPaB3=8<DVkBKU9^dViBK]9^DVkBKU9^dViBT=Z@FY3JT5Z@fY1JT=Z@FY3JT
5Z@fY1JT=Z@FY3JT5[Ae]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7Fd
EKAe]5FdMLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLBda9C4]<BDa;C4
U=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeC@4kO@03_FBmK;eT_Fb
mI;e/_FBmK;eT_FbmI;e/_FBoZl5mNT00maPooooo`0Wool003Ooo`0500001P0700H03P0<BI83FU@G
Pa@01I^DVkBKU9^dVi@05J@F6kAE04[4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4
mLCEa?G4eLCea=G4mLCEeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE
==DDkOC]e>gdkMC]m?FBmK;eT_FbmI;e/_FBmK;eT_FbmI;e/_j?oZoebOGYmLWejOG9:Ooo000gool4
00L00`0>BI99TP09BI80PEYDFWAJE5YdPaB3=8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<DPcB358<d
PaB3=8<DPcB35:@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@f
Y1JdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7G4eLCe
a=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCeeEKEM]EFeCCE5=Dd
eACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5007kO@02oFBmK;eT_FbmI;e/_FBmK;eT_Fb
mI800_j_1OGY:Ooo000gool01@0700H01`0600h02TVB1UYD58<D00>;UX^fRiH06J@F6kAE04[4mLCE
a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEeGKEE]EfeEKEM]DD
eCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE5=DdeACE=>gDkOC]e>gdkMC]m>gDkOCeT_FbmI;e/_FB
mK;eT_FbmI;e/_j?oZonSoGYmLWejOG9:Ooo000gool300L200h9BI80PeYDFWAJE5YdFUAJM5YDPcB3
58<dPaB3=8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<DRkJ;UX^fRiJ;]Z@FY3JT5Z@fY1JT=Z@FY3JT
5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@F]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7Fd
EKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4
eLCea=G4mLCEa?G4eLCea=G4mMEFeGKEE]EfeEKEM]EFeCCE5=DdeACE==DDeCCE5=DdeACE==DDeCCE
5=DdeA@02^gd00Oe/_FBmK;eT_FbmI;e/P04oZl4mNTYool003Koo`0400H01`0600L200h8BI88FU@@
Pa@01h^FRkJ;UX^fRiJ;]X^F01ZT5QZdE@1:a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4
mLCEa?G4eLCea=G4mLCEa?GEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeCCE5=DdeACE==DDeCCE5=DdeACE
==DDeCC]e>gdkMC]m>gDkOC]e>gdkMC]m>gDmK;eT_FbmI;e/_FBoZonSoj_oXon[oG9mNWebBWoo`00
=_oo10070P0>1dVB08AJE5YdFUAJM5YDFWAJE5YdFUAJM8<DPcB358<dPaB3=8<DPcB358<dPaB3=8<D
RkJ;UX^fRiJ;]X^FRkJ;UX^fRiJT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@F
Y3JT5Z@fY1JT=[AE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE
]7G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eMEfeEKEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeACE==DDeCCE5=DdeACE==DDeC@=kO@01OFbmI;e/_FBmK801Oj_0oGY
:Ooo000fool00`0600L01P0400h5BI8;FU@;Pa@038^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]QVT5QZd
E@1:a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?GEE]EfeEKE
M]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKE==DDeCCE5=DdeACE==DDkOC]e>gdkMC]m>gDkOC]e>gdkMC]
m>gDkOC]e?FbmI;e/_FBoZonSoj_oXon[oG9mNWebBWoo`00=_oo0`07100>14VB08IJE5YdFUAJM5YD
FWAJE5YdFUAJM5YDFWB358<dPaB3=8<DPcB358<dPaB;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^F
Y3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JdEKAe]5FdMKAE
]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAea=G4mLCEa?G4eLCea=G4mLCE
a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=GEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEE]EfeEKE==DDeCCE5=Dd3ngd00?e/_FBmK801_j_0_GY:Ooo000fool00`0600L01P0400h3BI8>
FU@6Pa@048^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^f6J@F6[AE04[4mLCEa?G4eLCea=G4
mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=GEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKE
M]EFeGKEE]EfeEKEM]EFeGKE5=DdeAC]m>gDkOC]e>gdkMC]m>gDkOC]e>gdkMC]m>gDkOC]e?FbmI;n
[oj?oZonSoj_oXoejOG9:Ooo000fool200L500h2BI80QeYDFWAJE5YdFUAJM5YDFWAJE5YdFUAJM5YD
FWAJE8<dPaB3=8<DRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJT5Z@fY1JT=Z@F
Y3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JdEKAe]5FdMKAE]7FdEKAe]5FdMKAE
]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCE
a?G4eLCea=G4mLCEa?G4eLCeeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEEP0BkO@8oZl00oGYooooo`0Wool003Koo`0300H01`0>00@03P03BI9JE5YD00iJE0:3500ERiJ;
]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^F01RT5QZdE@1:a?G4eLCea=G4mLCE
a?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeEKEM^HFiSK]e>gdkMC]m>gDkOC]e>gdkMC]m>gDkOC]e>gdkMC]m?kc
oZonSoj_oXon[oj?oZoebBWoo`00=_oo0P071@0>08UJE5YdFUAJM5YDFWAJE5YdFUAJM5YDFWAJE5Yd
FUAJM5YDRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]Z@FY3JT5Z@f
Y1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=[AE]7FdEKAe]5FdMKAE]7FdEKAe
]5FdMKAE]7FdEKAe]5FdMKAE]7FdEKAe]5FdMKAEa?G4eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCe
a=G4mLCEa?G4eLCea=G4mLCEa?GEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]Ef
eEKEM]EF00?V=Po]m003o_?n[oj_00Kn[bWoo`00=_oo00<01P0>00h0100>00<@deYDFU@03EYD01Q[
5V<FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiHDY1H5Y5L0F[BG];Nd
UkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]lDGaCO55lDgaAO5=lCEa?G4
eLCea=G4mLCEa?G4eLCea=G4mLCEa?G4eLCea=G4mMEFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKE
E]EfeEKEM]EFeGKEE]EfeEKV=^HFiSKV5^HfkMC]m>gDkOC]e>gdkMC]m>gDkOC]e>gdkMC]m0;nl`07
oXon[oj?oZonSoj_oXl0:Ooo000fool00`0700h03P0400h0R13CFWAJE5YdFUAJM5YDFWAJE5YdFUAJ
M5YDFWAJE6/fJaI[=X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJT
=Z@FY3JT5Z@fY1JT=Z@FY3JT5Z@fY1JT=Z@FY7NTEjAgY5NTMjAGY7NTEjAgY5Nd]kBG];NdUkBg]9Nd
]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9O5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO4
mLCEa?G4eLCea=G4mLCEa?G4eLCea=GEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKE
M]EFeGKEE]Ef1^Hf3>gd0okc1oj_:Ooo000fool00`0600h03P0300h00`Rc4==JE00<FU@06f/FHaI[
5V<FJaJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]P0:Y1H>Y5L0FKBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGaCO55lDgaAO5=lCEa?G4eLCea=G4mMEFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeEKV=^HFiSKV5^HfiQKV=^gDkOC]e>gdkMC]m>gDkOC]e>gdkM@01?kc
00Kn[oj?oZonSoj_oXlYool003Koo`H03P<@d`25FUAJM5YDFWAJE5YdFUAJM5YDFWAJE6/fJaI[=V/F
JcI[5X^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FY3JT5Z@fY1JT=ZAG
Y7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=mEFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEH02NHf
2^gd1?kc1_j_:Ooo000gool500h00`Rc4=<8/`0:FU@07F/FHaI[5V<FJaIS5V/FRiJ;]X^FRkJ;UX^f
RiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkH06:AG05RdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGeKOEUmFgeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKEM^HF
iSKV5^HfiQKV=^HFiSKV5^HfkMC]m>gDkOC]e>gdkMC]m0Knl`05oXon[oj?oZonS`0Yool003Ooo`@0
3P@@d`25FUAJM5YDFWAJE5YdFUAJM5YDJcI[5V/fJaI[=V/FJcI[5V/fRiJ;]X^FRkJ;UX^fRiJ;]X^F
RkJ;UX^fRiJ;]X^FRkJ;UX^fRiJCmi?GToNTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAG
Y7NTEjAgY5NTMjAG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
aCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=mFGeKOEUmFgeIOEM]EF
eGKEE]EfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEH02nHf1ngd1_kc1Oj_:Ooo000gool400h01A3C
2;<@d`Rc4=<01eYD021[5V<FJaIS5V/FHaI[5V<FJaIS5X^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UX^f
RiJ;]X^FRkJCei?gTmNCmi?G5jAG05RdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];Nd
UkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeKOE
UmFgeIOE]mFGeKOEUmEfeEKEM]EFeGKEE]EfeEKEM]EFeGKEE]EfeEKV=^HFiSKV5^HfiQKV=^HFiSKV
5^HfiQKV=^gDkOC]e>gdkMC]m0Onl`04oZonSoj_oXlYool003Ooo`@03PD@d`23FWAJE5YdFUAJM5YD
JcI[5V/fJaI[=V/FJcI[5V/fJaI[=X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]X^FRkJ;UY?gTmNCmi?G
ToNCei?gY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEkBg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mEFeGKEE]EfeEKEM]EF
eGKEE]EfeEKEMP0>iSH4kO@8o_<3oZlZool003Ooo`<03P062;<@d`Rc4=<8/a3C1EYD02=[5V<FJaIS
5V/FHaI[5V<FJaIS5V/FHaI[5X^FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJ;]Y?GToNCei?gTmNCmi?GToNC
ei?g01NTE`1F];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9O5=lDGaCO5
5lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgeIOE]mFGeKOEUmFgeIOE]mFGeKOE
UmFgeIOE]mEFeGKEE]EfeEKEM]EFeGKEE^HfiQKV=^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=^gDkOC]
e0Wnl`03oXon[ooo02Woo`00>?oo0P0>1a3C085JE5YdFUA[=V/FJcI[5V/fJaI[=V/FJcI[5V/fJaI[
=V/FRkJ;UX^fRiJ;]X^FRkJ;UX^fRiJCmi?GToNCei?gTmNCmi?GToNCei?gTmNTMjAGY7NTEjAgY5NT
MjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd
]kBG];NdUkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5
=lDGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOEM]EFeGKEE]EfeEH04NHf0^gd2Okc0_j_
:_oo000hool200h01`Rc4=<8/a3C2;<@d`Rc009JE00UJaIS5V/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS
5V/FRiJ;]X^FRkJ;UX^fRiJ;]Y?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToL05jAG05Fd]kBG];Nd
UkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUlDgaAO5=lDGaCO55lDgaAO5=lDGaCO5
5lDgaAO5=lDGaCO55lDgaAO5=lDGaCOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOE
UmEfeEKEM^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=P0;o_<00oj_ooooo`0Xool0
03Soo`0300h@da3C00H@d`20FUA[=V/FJcI[5V/fJaI[=V/FJcI[5V/fJaI[=V/FJcI[5V/fRiJ;]X^F
RkJ;UY?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAG
Y7NTEjAgY5NTMjAGY7NTEjAgY5NTMkBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG
];NdUkBgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCOEUmFgeIOE]mFG
eKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]a?V=P03m_Knlokc00Snl`03oZoooooo02So
o`00>?oo03403Q3C2;<@d`Rc4=<8/a3C2;=[5V<FJaIS5V/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS5V/F
HaJ;]X^FRkJCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCe`0FY5L0E;Bg]9Nd]kBG
];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDG
aCO55lDgaAO5=lDGaCO55lDgaAOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFG
eKOEUmhhgQSV=^HFiSKV5^HfiQKV=^HFiSKV5^HfiQKV=^HFiSKV5P;fmP[nlb_oo`00>?oo00<03Q3C
4=<01Q3C07lb5V/fJaI[=V/FJcI[5V/fJaI[=V/FJcI[5V/fJaI[=V/FJcJCei?gTmNCmi?GToNCei?g
TmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmjAGY7NTEjAgY5NTMjAGY7NTEjAgY5NTMjAGY7NTEjAg
Y5NTMjAGY7NTEjAg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];O55lDg
aAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=mFGeKOEUmFgeIOE]mFGeKOEUmFg
eIOE]mFGeKOEUmFgeIOE]mFGeKOEU`04gSP?iSH3m_H9o_<[ool003Soo`0a2;<@d`Rc4=<8/a3C2;<@
d`Rc<QIS5V/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS5V/FHaI[5W>HLkRCei?gTmNCmi?GToNCei?gTmNC
mi?GToNCei?gTmNCmi?GToNCei?gTmL05ZAG05>d]kBG];NdUkBg]9Nd]kBG];NdUkBg]9Nd]kBG];Nd
UkBg]9Nd]kBG];O55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeKOE
UmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFggQSN>=hHgSSN6>HfiQKV=^HFiSKV
5^HfiQKV=^HFiSKV5^Hf00CfmPWnlb_oo`00>Ooo1a3C0c8F02U[5V/fJaI[=V/FJcI[5V/fJaI[=V/F
JcI[5V/fLiQc^7>HLkRCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?gY5NTMjAG
00h00015Y7NTEjAgY5NTMkCH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;eh
_ERmN;eH_GRmF<DgaAO5=lDGaCO55lDgaAO5=lDGaCO55lDgaAO5=lDGeKOEUmFgeIOE]mFGeKOEUmFg
eIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFg00ON>0cV=PGfmPOnl`03gbkooooo02Woo`00>Ooo00L@d`Rc
4=<8/a3C2;<@d`03<QH09F/FHaI[5V<FJaIS5V/FHaI[5V<FJaIS5V/FLiQc^7>HLkQcV9?gTmNCmi?G
ToNCei?gTmNCmi?GToNCei?gTmNCmi?GToNCei?g00@000jTE`D0001BY;Rdf;Ch]=Rdn;CH]?Rdf;Ch
]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<DgaAO5=lDGaCO55lDg
aAO5=lDGaCOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeION>=hHgSSN6=hh
gQSN>=hHiSKV5^HfiQKV=^HFiSKV5^HfiQH6m_H7o_<00ml^ooooo`0Yool003Woo`0300`@da3C00@@
d`@b5P0RJcI[5V/fJaI[=V/FJcI[5V/fJaI[=W>HLkQcV7>hLiQc^7>HToNCei?gTmNCmi?GToNCei?g
TmNCmi?GToNCei?gTmL200005i?gTmNTMjAGY7NTEjAgY5NTMjAGY7NTEjAgY9RT^:BHY;RTV:BhY9RT
^:BHY;P0100003^df;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH_GRmF;eh_ERmN;eH_GRm
F;eh_ERmN;eH_GRmF;eh_ES5=lDGaCO55lDgaAOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOE
UmFgeIOE]mFG00_N>0SV=POfmPGnl`03gbkooooo02[oo`00>Ooo00H030Rc4=<8/a3C2;<5<QH086<F
JaIS5V/FHaI[5V<FJaIS5V/FLiQc^7>HLkQcV7>hLiQc^9?GToNCei?gTmNCmi?GToNCei?gTmNCmi?G
ToL2000019?GToNCei?g1ZAG01>TV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^;CH]?Rdf003
0000B[CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?RmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh
_ERmN;eH_GRmF;eh_ESE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKON6=hh
gQSN>=hHgSSN6=hhgQSN>=hHgSSV5^HfiQKV=^HFiSH8m_H5o_<00ml^ooooo`0Zool003Woo`0300`@
da3C00<@d`Hb5P0MJaI[=V/FJcI[5V/fJaI[=W>HLkQcV7>hLiQc^7>HLkQcV7>hTmNCmi?GToNCei?g
TmNCmi?GToNCe`0200008Y?gTmNCmi?GToNCejBhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BH
Y;RTV:BhY9RT^:BH]?Rdf;Ch]=Rdn;CH0P0003Fdn;CH]?Rdf;Ch]=Rdn;CH]?Rdf;Ch]=RmN;eH_GRm
F;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GS=V<fhcISE]mFGeKOEUmFgeIOE]mFGeKOE
UmFgeIOE]mFGeKOEUmFg00kN>0GV=PWfmP?nl`;O;Rcoo`00>_oo00@0313C2;<@d`Lb5P0KJaIS5V/F
HaI[5V<FJaIcV7>hLiQc^7>HLkQcV7>hLiQc^7>HToNCei?gTmNCmi?GToNCei?g00800006TmNCmi?G
ToNCei?g0iAH00>T^00000003P0000bTV:BhY9RT^;CH]?Rdf;Ch]=Rdn;CH]?P30000A;Ch]=Rdn;CH
]?Rdf;Ch]=Rdn;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fH
cKSEUmFgeIOE]mFGeKOEUmFgeIOE]mFGeKOEUmFgeION>=hHgSSN6=hhgQSN>=hHgSSN6=hhgQSN>=hH
gSSV5^HfiQH:m_H3o_<2gbh/ool003[oo`0400`@da3C4=<8<QH08f/fJaI[=V/FJcIcV7>hLiQc^7>H
LkQcV7>hLiQc^7>HLkQcV9?gTmNCmi?GToNCei?g002Cmi?GToNCei?gTmNDN9AHU7P00`00012T^:BH
Y;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV0D0000:]=Rdn;CH]?Rdf;Ch]=Rdn;CH]?P20000;kCH
]?Rdf;Ch]=Rdn;CH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fH
cKS=V<fhcIS=^=FGeKOEUmFgeIOE]mFGeKOEUmFgeIL04Mhh0^Hf2oKf00Cnlml^gbkO;Rcoo`00>_oo
00@0313C2;<@d`Pb5P0NHaI[5V<FJaIcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hTmNCmi?GToNC
ei?g002Cmi?GToNCei?g0iAH0P000iAH01FTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BH
Y;RTV:Bh]=P0100000Rdn;CH]?Rdf;Ch]=Rdn;CH0P0003ndn;CH]?Rdf;Ch_ERmN;eH_GRmF;eh_ERm
N;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN<fHcKS=V<fhcIS=^<fHcKS=V<fhcISE]mFGeKOEUmFgeIOE
]mFGeKON6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSP03?Kf00?nlml^gbh0;Ooo000j
ool200`00a3C<QHb5P08<QH07V/FJcIcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^9?GToNC
ei?gTmL009?GToNDF9AhU5RDN080000NU5RDN9AHU7RDF:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:Bh
Y9RT^:BHY;RTV:BhY9RT^;CH]?Rdf;Ch0P0000Rdf;Ch]=Rdn;CH]?Rdf;Ch0P0002Zdf;Ch]=RmN;eH
_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fH
cKS=V=FgeIOE]mFGeKLCgSP00nlhm_KfmP09m_H3gbh]ool003[oo`8030032;<b5S8F00Pb5P0HLkQc
V7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^7>HToNCei?gTmL009?G19AH0P0029AH00FT^:BH
Y;RTV:Bh00L0000>Y;RTV:BhY9RT^:BHY;RTV;Ch]=Rdn;CH]?Rdf0<00013]=Rdn;CH]?Rdf;Ch]=P0
0;CH]?RmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=
^<fHcKS=V<fhcIS=^<fHcKSEUmFgeION>=hHgSSN6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSSN6=hhgQP0
0^lh2oKf0ml^;Ooo000kool00`0<<QHb5P09<QH09d/HLkQcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQc
V7>hLiQc^7>HToNCe`00U5RDN9AHU7RDF000U5RDN9AHU7RDF9AhU5RDN9AHU7RTV00400001jBhY9RT
^:BHY;RTV:Bh00P00009]=Rdn;CH]?Rdf;Ch]=Rdn;CH00800006]?Rdf;Ch]=Rdn;CH0P0002JmN;eH
_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fH
cKS=V<fhcIS=^<fH4]hh1>lh2OKf00C_]=l^gbkO;Rgoo`00>ooo0P0<2S8F0T/H01=c^7>HLkQcV7>h
LiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>hU5P00005U5P00`00U5RDF006U5P400004jBHY;RTV:BhY9RT
^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BH00800009]?Rdf;Ch]=Rdn;CH]?Rdf;Ch00<00005]?Rd
f;Ch]=Rdn0020000=[eH_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF;eh_ES=^<fHcKS=V<fhcIS=
^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^=IIeWWN6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSSN6=hhgQSN
>0C_>0WfmP04kkCO;]l^gbh]ool003_oo`80300305<b5S8F00Hb5P0mBcQ;64/hBaQc^7>HLkQcV7>h
LiQc^7>HLkQcV7>hLiQc^7>HLkQl6G`i002DN9AHU7RDF9Ah002DN9AHU7RDF9AhU5RDN000U7RDF9Ah
U5RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^;CH]?P00`0000Vdn;CH]?Rdf;Ch
]=Rdn;CH]?P00P0000Fdf;Ch]=RmN;eH0080000Q_GRmF;eh_ERmN;eH_GRmF;eh_ERmN;eH_GRmF<fh
cIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fh00CFN@kN>0K_>0OfmP;_]0;O;Rkoo`00
>ooo0P0<00<0Dc8F<QH01S8F14/H00icV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQcV7>h0W`I00<007`I
U5P00iAH00<009AHU5P019AH0P001IAH01RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BH
Y;RTV;Ch]=Rdn;CH]?P400001kCH]?Rdf;Ch]=Rdn;CH0080000g]?RmF;eh_ERmN000_GRmF;eh_ERm
N;eH_GRmF;eh_ERmN;eH_GS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKSFFMIieUWF
NMIIeWWN6=hhgQSN>=hHgSSN6=hhgQSN>=hHgSP01nlh1oKf0^nd0]l^;_oo000kool200`205<7<QH0
A4/hBaQ;>4/HBcQcV7>hLiQc^7>HLkQcV7>hLiQc^7>HLkQl6G`iO1T007`IU7RDF9Ah002DN9AHU7RD
F9AhU5P009AHU7RDF9AhU5RDN9AHU7RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;Rd
f;Ch]=Rdn;CH]?Rdf;Ch]=P200003KCh]=Rdn;CH]?Rdf;Ch002mN;eH_GRmF;eh0080000M_ERmN;eH
_GRmF;eh_ERmN;eH_GRmF<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V008eWT:gSP8
kcP5m_H3kk@2gbh^ool003coo`80300303<0Dc8F00@b5PM;600:LiQc^7>HLkQcV7>hLiQc^7>HLkP3
O1T01P00O1Ul6G`IU5P000FDF08000VDF00MY;RTV:BhY9RT^:BHY;RTV:BhY9RT^:BHY;RTV:CiY=VT
nJCIY?Ve6KDi]AVe>KDI]CVe6KDi]AVe>@0200001[DI]CVe6KDi]AVm^@800005_IVm^KfI_GRmF002
0000;;eh_ERmN;eH_GRmF;eh_ES=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcISFNMII
eWWFFMIieUWFNMIIeWWFFMhhgQSN>=hHgSSN6=hhgQP9kcP5m_H2kk@2gbh_ool003coo`803080D`Db
5P19BaQ;>4/HBcQ;64/hBaQ;>7>HLkQcV7>hLiQc^7>HO3Ul6G`iO1Ul>@00O3Ul6G`i002DN9AHU7RD
F9Ah002DN9AHU7RDF9AhU5RDN9AHU7RDF9AhU5RT^:BHY;RTV:BhY9RT^:BHY;RTfJCiY=VTnJCIY?VT
fJCiY=Ve>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AT00P0000Je>KDI]CVmVKfi_IT200007[fi_IVm^KfI
_KT00;fi_ERmN;eH_GRmF;ehcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V0cFN@KN>0__
>0?fmP?_]0;O;Rooo`00?Ooo00@0300c05<0<`@b5PQ;6006LkQcV7>hLiQc^7>H1G`I00<007`IO1T0
0W`I00<009AHU5P00YAH00<009AHU5P02iAH022TV:BhY9RT^:BHY?VTfJCiY=VTnJCIY?VTfJCiY=VT
nJCIY?Ve6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi0`0000Fm^KfI_KVmVKfi00800004_IVm^KfI
_KT20000:;fI_KVmVKficIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=V<fheUWFNMIIeWWF
FMIieUWFNMIIeWWFFMIieUWFNMhHgSSN6=hh2nlh0oKf0nnd00?O;_ooool0;_oo000mool00`0<05<0
D`0205<2<QH0Cd/hBaQ;>4/HBcQ;64/hBaQ;>4/HLkQcV7>hLiQl>G`IO3Ul6G`iO1T007`IO3Ul6@00
O1Ul>IAHU7P009AhU5RDN9AHU7RDF9AhU5RDN9AHU7RDF9AhU5RTnJCIY?VTfJCiY=VTnJCIY?VTfJCi
Y=VTnJCIY?VTfJCiY=Ve>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi00800005_IVm^KfI
_KVmV@0200001;fi_IVm^KfI0P0000>m^KfIaOX00/Gj00k=V<fhcIS=^<fHcKS=V<fhcIS=^<fHcKS=
V<fh4=Ii0]hh3Nlh00?fm^ndkk@00^nd00?O;_ooool0;_oo000mool01@0<03<0D`0c05<00S8F2d/H
00=c^7>HO1T01W`I00@007`IO1T000Al6@03002DF9AH00^DF00WW9ZL^YbJY?VTfJCiY=VTnJCIY?VT
fJCiY=VTnJCIY?VTfJCiY=VTnKDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVm^KfI0080
000__KVmVKfi_IVm^@00_KVmVKfi_IT00;fI_KW5f/GjaM[5n/GJaO[=V<fhcIS=^<fHcKS=V<fhcIS=
^=IIeWWFFMIieUWFNMIIeWWFFMIieUWFNMIIeWWFFMIieUWFN@0>kcP5kk@00ml^ooooo`0^ool003ko
o`0300`0D`1C0080D`1D<QI;>4/HBcQ;64/hBaQ;>4/HBcQ;64/hO1Ul>G`IO3Ul6G`iO1Ul>@00O3Ul
6G`i001l>G`IO3Ul6@00U5RDN9AHU7RDF9AhU5RDN9AHU7RLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?VT
fJCiY=VTnJCIY?VTfJCiY=VTnJCI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KfI_KVm
VKfi0P0000BmVKfi_IVm^@800003_IVm^KfI008000W5nP07cIS=^<fHcKS=V<fhcIP04]Ii00?Vn^lh
kcP02nlh1Nnd<Ooo000nool01@0<05<0<`1C03<034/H00=KnW`IO1T01G`I00@007`IO1T000Al6@03
001l6IAH00JDF00aW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCi
Y=VTnKDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi_IVm^KfI_KVmVKfi_IT00P0000Bm^KfI
_KVmV@80000T_KVmVLGj0035n/GJaO[5f/GjaM[5n/GJaO[5f/GjcIS=^<fHeWWFFMIieUWFNMIIeWWF
FMIieUWFNMIIeWWFFMIieUWFNMII0^Kj3>lh00?_n>ndkk@00nnd<Ooo000oool505<0GT/hBaQ;>4/H
BcQ;64/hBaQ;>4/HBcQKfU_jO1Ul>G`IO3Ul6G`i001l>G`I001l6G`iO1Ul>@00O3Ul6IAhU5RDN9bJ
W;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnKDI
]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6Kfi_IVm^KfI_KVmVKfi_IVm^@00_KVmVKfi_IVm^@00
0lGj0P002lGj4]Ii1>Kj2^lh0^oh1>nd<_oo000oool01P1C03<0D`0c05<260U;6004FmYKnU_JFoX5
O1T01000O1Ul6@000g`I03h007`IO1Ul6IbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZT
nJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfKDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe
>KfI_KVmVKfi_IVm^KfI_KVmVKfi0P0000BmVKfi_IVm^@80000OaM[5n/GJ0035f/GjaM[5n/GJaO[5
f/GjaM[5n/iJcW[FFMIieUWFNMIIeWWFFMIieUWFNMIIeWWFFMIieUT01NKj2Nlh0noh1>nd<_oo000o
ool505<20QP0Fd/hBaQ;>4/HBcQ;64/hBaQKnU_JFoYKfU_jO1Ul>G`IO3T007`i001l>G`IO3Ul6@00
O1Ul>HBJQ;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^ZCIY?VTfJCiY=VTnJCIY?VTfJCi
Y=VTnJCIY?VTfJCi]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI_KVmVKfi_IVm^KfI_KVmVKfi
_IVm^KfI002mVKfi00?5nP040035n/GjaOX20007aOX4cWX=eWT7i_X7kcP4koP3kk@cool0043oo`04
03<0D`0c05<30QP7BaP01U_JFoYKfU_jFmYKnP9l6@04001l6G`I0003O1T0I000O1Ul6HBJQ;Z4VXBj
W9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCi
Y=Ve>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVmVKfi_IVm^KfI_KVmVKfi_IVm^KfI_KVmV@00
_IW5n/GJaOX00<GjaM[5n/GJaOX00<GjaM[5n/GJaO[>F/ijcU[>N/iJcW[FFMIieUWFNMIIeWWFFMIi
eUWFNMII2>Kj1^lh1>oh0nnd=?oo0011ool305<30QP0FD/HBcQ;64/hBaQ;>5_JFoYKfU_jFmYKnU_J
FoYl6@00O1Ul>@00O3Ul6G`i001l>HBJQ;Z4VXBjQ9Z4^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJ
W;ZLVZCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnKDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI
]CVe6Kfi_IVm^KfI_KVmVKfi_IVm^KfI_KVmVKfi_IT00P000lGj00<00<GjaOX00lGj00@00<GjaO[5
nPS>NPWFN@[VnPC_>0G_n0?_]3Coo`00@Ooo00<0D`0c05<0108H1D/H00YKnU_JFoYKfU_jFmYKnU_J
FoX0009l6@1=001l6G`I001l6HBJQ;Z4VXBjQ9Z4^XBJQ;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZL
VYbjW9ZTnJCIY?VTfJCiY=VTnJCIY?VTfJCiY=VTnJCI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KDI]CVe
6KDi_IVm^KfI_KVmVKfi_IVm^KfI_KVmVKfi_IVm^LGJaOX00<GjaM[5nP0200005lGJaO[5f/Gj0035
n/GJcW[>F/ijcU[>N/iJcW[>F/ijcU[FNMIIeWWFFMIieUT02nKj0nlh1^oh0^nd=Ooo0012ool305<4
0QP0ET/HBcQ;64/hFmYKnU_JFoYKfU_jFmYKnU_J001l6G`i001l>G`I0024VXBjQ9Z4^XBJQ;Z4VXBj
Q9Z4^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZTfJCiY=VTnJCIY?VTfJCiY=VTnJCIY?VTfJCi
]AVe>KDI]CVe6KDi]AVe>KDI]CVe6KDi]AVe>KfI_KVmVKfi_IVm^KfI_KVmVKfi_IVm^KfI_KT4aOX0
0`00aO[5nP02aOX00`00aO[5nP02aOX00`00cW[>NP0:cWX4eWT=i_X00nlhkoS_n005koP00nndoooo
o`0dool004?oo`0305<0<`8H00@2609;600<FmYKnU_JFoYKfU_jFmYKnU_JFoX005_j0P000W`I04d0
08BjQ9Z4^XBJQ;Z4VXBjQ9Z4^XBJW;ZLVYbjW9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjY=VTnJCIY?VT
fJCiY=VUNZEJYGZUFZEjYEZUN[EJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[EJ_KZmV[fj_IZm^[fJ_KZm
VKfi_IVm^KfI_KVmVLGjaM[5n/GJaOX00<GjaM[5n/GJ0080000BaO[5f/ij003>N/iJcW[>F/ijcU[>
N/iJcW[>F/ijcU[FNMII3^Kj2>oh00?_]?ooool0=?oo0013ool205<60QP0Dd/HFoYKfU_jFmYKnU_J
FoYKfU_jFmX005_J001l6G`iQ9X008BJQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9ZL^YbJW;ZLVYbjW9ZL^YbJ
W;ZLVYbjW9ZL^YbJYGZUFZEjYEZUNZEJYGZUFZEjYEZUNZEJYGZUF[Ej]EZeN[EJ]GZeF[Ej]EZeN[EJ
]GZeF[Ej_IZm^[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_IX01lGj0P001<Gj00D00<ijcW[>NP0000c>NPkV
nP03ik__n>oh00K_n3Ooo`00A?oo00<0<`8H0QP0108H06EKnU_JFoYKfU_jFmYKnU_JFoYKfU_j001K
nP00Q;Z4VP00Q9Z4^XBJQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9ZL^YbJW;ZLVYbjW9ZL^YbJW;ZLVYbjWA^M
>idKYGZUFZEjYEZUNZEJYGZUFZEjYEZUNZEJYGZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[EJ]GZeF[fj_IZm
^[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_Q^n>khKaO[5f/GjaM[5n/GJ0035f/GjaM[5nP00cW[>F/ij0080
0009cU[>N/iJcW[>F/ijcU[>N/iJ00;Fn`cVnP;W^`O_n3Soo`00AOoo1`8H054[Ne_JFoYKfU_jFmYK
nU_JFoYKfP00FmX007AKM7/008BjQ9Z4^XBJQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9ZL^YbJW;ZLVYbjW9ZL
^YbJWC^M6idkWA^M>idKYGZUFZEjYEZUNZEJYGZUFZEjYEZUNZEJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZe
N[EJ]GZmV[fj_IZm^[fJ_KZmV[fj_IZm^[fJ_KX01khk1<Gj0P0000C5n/ijcWX000C>NP03003>N/ij
00G>NPCFn`[VnP?W^`O_n3Soo`00AOoo1`8H0R]K00]KfU_jFmYKnU_JFoYKfU_j001KnP00009dF`1C
0024VXBjQ9Z4^XBJQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9ZL^YbJW;ZLVYbjWA^M>idKWC^M6idkWA^M>jEJ
YGZUFZEjYEZUNZEJYGZUFZEjYEZUNZEJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[EJ_KZmV[fj_IZm^[fJ
_KZmV[fj_IZm^[fJ_S^n6khk_Q^n>khK_S^n6khk_Q_5n/GJaOX00<ijcU[>NP0200002LiJcW[>FP00
cU[>N/iJcW[>FP05e_/9i_X4ik/6koPiool004Koo`H2601@:g/[Fb]kFmYKnU_JFoYKfU_jFmX005_J
001dFgAk001dNhBJQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9Z4^XBJQ;Z4VYbjW9ZM>idKWC^M6idkWA^M>idK
WC^M6idkYEZUNZEJYGZUFZEjYEZUNZEJYGZUFZEj]EZeN[EJ]GZeF[Ej]EZeN[EJ]GZeF[fj_IZm^[fJ
_KZmV[fj_IZm^[fJ_KZmVPfn>`;>NP03003>N/ij00;>NP05003>N/ijcWX00003cWX7e_/7i_X5ik/5
koPjool004Ooo`D260@[F`09FmYKnU_JFoYKfU_j001KnP00009dF`1L001dFgAKQ9Z4^XBJQ;Z4VXBj
Q9Z4^XBJQ;Z4VXBjQ9Z4^YdKWC^M6idkWA^M>idKWC^M6idkWA^M>idKYGZUFZEjYEZUNZEJYGZUFZEj
YEZUNZEJ]GZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_IZm^[hK_S^n6khk
_Q^n>khK_S^n6khk_Q^n>lIKaW_6Flij003>N/iJcW[>FP00cU[>N/iJ003>FPWFn`GVnPKW^`C_n003
[g?ooooo03Soo`00B?oo108H04l[Nb]K:g/[Fb]k:e]KnU_JFoYKfP00FmX007AKM7/007AkM5]dNhBJ
Q;Z4VXBjQ9Z4^XBJQ;Z4VXBjQ9Z4^XdKSC^M6idkWA^M>idKWC^M6idkWA^M>idKWC^M6jEjYEZUNZEJ
YGZUFZEjYEZUNZEJYGZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[EJ_KZmV[fj_IZm^[fJ_KZmV[fj_IZm^P0<
_S/5aW/00lij003>NP03cWX01000cW[>NP002]Kk1>Kj1nNk0noh00>_Loooool0>Ooo0019ool40QP6
:e/01U_jFmYKnP00M5/0009dF`03001dFgAK00=dF`1FQ;Z4VXBjQ9Z4^XBJQ;Z4VXBjSA^=>hdKSC^M
6idkWA^M>idKWC^M6idkWA^M>idKWC^M6jEjYEZUNZEJYGZUFZEjYEZUNZEJYGZeF[Ej]EZeN[EJ]GZe
F[Ej]EZeN[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_IZn>khK_S^n6khk_Q^n>khK_S^n6khkaU_6NlIKaW_6
FlIkaU_>NP00cW[>F/ijcUX00<iJe_/000[Fn`;VnPSW^`;_n003[g?ooooo03[oo`00B_oo0`8H04d[
Fb]k:e/[Nb]K:g/[Fe_jFmX007AKM7/007Ak001dNgAKM7]dFgAkM5^4^XBJQ;Z4VXBjQ9Z4^XdKSC^=
6hdkSA^=>idKWC^M6idkWA^M>idKWC^M6idkWA^M>jEJYGZUFZEjYEZUNZEJYGZUFZEjYEZeN[EJ]GZe
F[Ej]EZeN[EJ]GZeF[fj_IZm^[fJ_KZmV[fj_IZm^[fJ00^n>`[6N`03003>N/ij00;>NP03003FnmKk
008000SFn`[W^`03koR_Looo03coo`00B_oo00<0<P8H0QP022]K00MKnU_J001dF`00M5/00007M5/0
DXBjQ9Z4^XBJQ;Z=6hdkSA^=>hdKSC^=6hdkWA^M>idKWC^M6idkWA^M>idKWC^M6idkYEZUNZEJYGZU
FZEjYEZUNZEJYGZeF[Ej]EZeN[EJ]GZeF[Ej]EZeN[fJ_KZmV[fj_IZm^[fJ_KZmV[fj_Q^n>khK_S^n
6khk_Q^n>khK_S_6FlIkaU_6NlIKaW_6FlIkaU_6NlIKaW/00<ijcU[Fn`001=Kk00<00=Kke_/01=Kk
00?GO>Nkik/02>Nk0Zmc?Ooo001;ool0CP1B0QP[Fb]k:e/[Nb]K:g/[Fb]k:e]dN`00M7/007AkM5/0
07AKM7]dFgAkM5]dNgAKQ;Z4VXBjSA^=>hdKSC^=6hdkSA^=>hdKSC^M6idkWA^M>idKWC^M6idkWA^M
>idKYGZUFZEjYEZUNZEJYGZUFZEjYEZeN[EJ]GZeF[Ej]EZeN[EJ]GZmV[fj_IZm^[fJ_KZmV[fj_IZm
^PZn>`k6N`05003FnmKke_/00003e_/00`00e__Fn`02e_/3eg`9ik/2[g<nool004coo`03038[Fb]K
00P[F`03001dF`00009dF`03001dFgAK00IdF`1;SC^=6hdkSA^=>hdKSC^=6hdkSA^=>hdKSC^M6idk
WA^M>idKWC^M6idkWA^M>idKYGZUFZEjYEZUNZFLYKbUW:FlYIb]o:gL[Ob]g:gl[Mb]o:gL]Obeg;Gl
]Mbeo;GL]Obeg;Gl_Q^n>khK_S^n6khk_Q^n>khK_S_6FlIkaU_6NlIKaW_6FlIkaU_6NlIKaW_6FlIk
00;>o0CFn`05003FnmKke_/00002e_/4eg`8ik/00koi[g?oo`0nool004goo`0j0582NB]K:g/[Fb]k
:e/[Nb]K:g/005@l001dNgAK001dFgAkM5]dNgAKM7]dFgAkO=alo8dKSC^=6hdkSA^=>hdKSC^=6hdk
SA^=>idKWC^M6idkWA^M>idKWC^M6idkYIbU_:FLYKbUW:FlYIbU_:FLYK`8[O`9]O`3]S`6_S/=aW/5
c_`3e_/01@00e__FnmKk00001]Ml1nNk00>onJmcool0?ooo001>ool00`0b0UT[F`06:e/01P00E1aD
7000E1`000MdF`19O=alo7cLO?alg8dkSA^=>hdKSC^=6hdkSA^=>hdKSC^M6idkWA^M>idKWC^M6ifl
WIbM_:FLYKbUW:FlYIbU_:FLYKbUW:gl[Mb]o:gL[Ob]g:gl[Mbeo;GL]Obeg;Gl]Mbeo;GL]Sbf7;Hl
]Qbf?;HL_S^n6khkaU_6NlIKaW_6FlIkaU_6NlIKaW_6FlIkaU/01/kl1=Kk0P0000?FnmMl00001MMl
1NNk0[oi00>_Loooool0?ooo001>ool20580>09i0UT[Nb]K:g/[Fb]kE1`005@L001D75@l001dNgAK
M7]dFgAkM5]lo7cLO?alg7clO=alo8dKSC^=6hdkSA^=>hdKSC^=6hdkWA^M>idKWC^MW9flWIbM_9fL
WKbUW:FlYIbU_:FLYKbUW:FlYI`7[O`8]O`8]S`<aW/9c_`4e_/01000egcGO0001MMl1>Nk0[oi00>_
Loooool0@?oo001?ool0101B0382F@9I12]K00AD7000E1`0009D7003001D77AK00=dF`17O?alg7cl
O=alo7cLO?alg7clSA^=>hdKSC^=6hdkSA^=>hdKSC^MW9flWIbM_9fLWKbMW9flWIbM_:FLYKbUW:Fl
YIbU_:FLYKb]g:gl[Mb]o:gL[Obeg;Gl]Mbeo;GL]Obeg;Gl]Qbf?;HL]Sbf7;Hl]Qbf?;iM_WfnGLIk
aU_6NlIKaW_6FlIkaU_6N`0;c_`2e_/2eg`01000egcGO0001=Ml0^Nk1;oi@ooo001@ool0>01B0UT2
N@9I0WT[Fb]kE1aD?000E3`005@l001D?5@LE3adFgAkO=alo7cLO?alg7clO=alo7cLO?alg8dkSA^=
>hdKSC^=6hdkUEfEOIEMWKbMW9flWIbM_9fLWKbMW9flYIbU_:FLYKbUW:FlYI`6[O`7]O`8]S`5_Wd6
aW/=c_`4eg`01@00egcGO=Ml00000mMl00?W^koi_oT00[oiA?oo001Aool00`1B0UT2F@020UT012]K
E1aD75@L0P0000=D7000E1`00e@L04Elg7clO=alo7cLO?alg7clO=alo7cLO?alg7clSA^=>hdKUGfE
GIEmUEfEOIEMWKbMW9flWIbM_9fLWKbMW:FlYIbU_:FLYKbUW:FlYIb]o:gL[Ob]g:gl]Mbeo;GL]Obe
g;Gl]Mbf?;HL]Sbf7;Hl]Qbf?;iM_WfnGKim_UfnOKiM_Wg6FlIkaU/03<kl0/Lm1MMl00@00=Mleg`0
00;GO0FonDGoo`00D_oo03L0DP9I0WT2F@9iE1aD?5@L001D7000E1`005@LE3aD75@lK=e/oGcLO?al
g7clO=alo7cLO?alg7clO=alo9EMUGfEGIEmUEfEOIEMUGfEGIEmWIbM_9fLWKbMW9flWIbU_:FLYKbU
W:FlYIbU_005[O`6]O`6]S`;_Wd<c_`4acd5eg`01000egcGO0000/Om1;oiA_oo001Cool00`1B0UT2
F@020UT00a`ME1aD700200000e@L001D7003E1`0@fcmI=e/oFCMO?alg7clO=alo7cLO?alg7clO=b=
OHeMUGfEGIEmUEfEOIEMUGfEGIEmWIbM_9fLWKbMW9flWIbU_:FLYKbUW:FlYIb]o:gL[Ob]g:gl]Mbe
o;GL]Obeg;Gl]Qbf?;HL]Sbf7;im_UfnOKiM_WfnGKim_UfnOKiM_[fnWKjm00W>o0K7?@GGO005003G
O<Om0037o@04_oU7ool005Coo`080582F@9i0UT2NB@M93eD7080000[E3`005@lE1aD?6cMK?e/gFcm
K=e/oGcLO?alg7clO=alo7cLO?b=GHemSEf=OIEMUGfEGIEmUEfEOIEMUGfMW9flWIbM_9fLWKbMW:Fl
YIbU_:FLYK`01:gl1[Gl1KHl2Kim1[jm1/kl2<Lm1MMl00C7o@00aod000BonDSoo`00EOoo1@9I00@L
7B@M001D708000=D7015K?eTgFcmI=e/oFCMK?eTgGclO=alo7cLO?b=GHemSEf=OHeMSGf=GIEmUEfE
OIEMUGfEGIEmUEfM_9fLWKbMW9flWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?[HL]Sbf7;Hl]Qbn
OKiM_WfnGKim_UfnOKiM_[fnWKjm_Yfn_KjM_[fnWKjm00?>o0[7?@?GO0?7o@030037o@0000:onD[o
o`00Eooo00H2F@9i0UT2NB@M93d2000095@L001D75@lK=e/oFcMK?e/gFcmK=e/oFcMK?elg7clO=b=
OHeMSGf=GHemSEf=OHeMSGfEGIEmUEfEOIEMUGfEGIflWIbM_1:N?PRnO@^n_@g7?@03egc7oLOm00?7
o@040037o@00_oU;ool005Woo`<2F@1971d001`M000L7@00E1a/oFCMK?eTgFcmI=e/oFCMK?eTgFcm
I=f=OHeMSGf=GHemSEf=OHeMSGf=GHemSEfEOIEMUGfEGIEmUEfN?YhNWSjN7YhnWQjN?YhNWSjN7Yhn
WQjN?YhNWSjN7YhnWQjN?YhNWSjN7[im_UfnOKiM_[fnWKjm_Yfn_KjM_[fnWKjm_Yd00kKn3<Lm1lOm
00<00;oi0000C?oo001Kool01@9I0WTT7@0091d00P0001hT?FcMK?e/gFcmK=e/oFcMK?e/gFcmK=e/
oHFNQKj5WXFnSEf=OHeMSGf=GHemSEf=OHeMSGfEGIEmUEdHWSh9_[d7]_h8acd4_gh7aod2001=ool0
05goo`040UTL7@0071d30000>UDNECiE7VcmI=e/oFCMK?eTgFcmI=f5_XFNQKj5WXFnQIj5_XeMSGf=
GHemSEf=OHeMSGfN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN
7YhnWQjn_KjM_[fnWKjm2[Kn1<Lm1kmn1lOm0P00C_oo001Nool082@m91d002@M000T7@00EAiE?UDN
ECiE7UDnK=e/oFcMK?f5WXFnQIj5_XFNQKj5WXFnQIj5_XFNSGf=GHemSEdLWSh=]_h;_gh6aod00fJc
0000001?ool0063oo`030iX001`M0080000e91eE7UDnEAiE?UDNECiE7UDnEAj5_XFNQKj5WXFnQIj5
_XFNQKj5WXFnQIj5_XFNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN
?YhNWSjN7YhnWQjN?P0=]_h;_gh3aod2Uk/00ooo0000001@ool006;oo`80000I93d002@mEAiE?UDN
ECiE7UDnEAiE?UDNOKmmWgfoOImm_gfOQKj5WXFnQIj5_XFNQKh07Ihn3KKn2[mn0/Om0YNk00=V/`00
0000D_oo001Sool40000<b@MEAiE?UDNECiE7UDnEAiE?UDNOKmmWgfoOImm_gfOOKmmWgfoOImm_gfO
WSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?P0<
]_h:_gh4Uk/2001Dool006Goo`<0000FECiE7UDnEAiE?UDNECiE7UDnEAim_gfOOKmmWgfoOImm_gfO
OKmmWgfoOIlKWSh=]_h5_gh4Ykh3Uk/00`00ooooo`1Eool006Ooo`<0000^?Ai5?SdNAChm7TDn?Ai5
?SdNOKmmWgfoOImm_gfOOKmmWgfoOImm_gfOWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN
?YhNWSjN7YhnWQjN?YhNWSh=]_h8Ykh3Uk]Jool006Soo`@00009ACi57TDnAAi5?TDNACi57TDn00]e
oaJN?PfW?`VW_P:G^ecoo`00J_oo0P0002P3VP>j?Ai5?SdNAChm7TDn?Ai5?WGOMOmeggGoMMmeogGO
MOmeggGoMMnN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?YhNWSjN7YhnWQjN?PNFo`JW?`VW_P03Uk_o
oooo05goo`00K?oo100000M5?TDNACi57TDnAAi5?P06MOl8KSl=WSh=U_l9Ykh00dhgooooo`1Oool0
06koo`<000835P0K;Ch]7Rdn;Ah]?VHOKSmV7fhoIQm^?fHOKSmV7fhoIQmfOgIOMWmfGgIoMUnN?YhN
WSjN7Yhn00J6o`VFo`Qo?P03CSOooooo06;oo`00LOoo100000L]7Rdn;Ah]?RdN;Ch]7P05KSl8MWl6
O[l7Q_l5U_l7Och00dhgooooo`1Uool007?oo`D0000H;Ah]?RdN;Ch]7Rdn;AifOgIOMWmfGgIoMUmf
OgIOMWmfGgjoOYmn_gjOO[mnWgjo28Ko1WlnK?oo001hool200003Rel;E`]O2eL;G`]G2el;E`]O2eL
;G`]G2el;E`8O[l8E[ebool007goo`<0000B;E`]O2eL;G`]G2el;E`mo3GL?O`eg3gl=M`mo3GL?O`e
g3glN?oo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;
ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00oooo2ooo003oool;ool00?ooo`_oo`00
oooo2ooo003oool;ool00?ooo`_oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 425.5}, {622.875, 264.188}} -> {-0.195801, \
0.685115, 0.00324176, 0.00324176}}]
}, Open  ]],

Cell["\<\
Plotting the error in the invariants against time, it can be seen \
that the orthogonal projection method conserves only one of the two \
invariants.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(InvariantErrorPlot[invariants, vars, T, \ OPSolution, 
        SymbolStyle \[Rule] {Red, Blue}];\)\)], "Input",
  CellLabel->"In[35]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0297619 0.0238095 25.4225 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -3 -9 ]
[.17262 -0.0125 3 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -6 -9 ]
[.76786 -0.0125 6 0 ]
[.91667 -0.0125 -6 -9 ]
[.91667 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .15092 -30 -4.5 ]
[-0.0125 .15092 0 4.5 ]
[-0.0125 .27803 -24 -4.5 ]
[-0.0125 .27803 0 4.5 ]
[-0.0125 .40515 -30 -4.5 ]
[-0.0125 .40515 0 4.5 ]
[-0.0125 .53226 -24 -4.5 ]
[-0.0125 .53226 0 4.5 ]
[-0.0125 .65937 -30 -4.5 ]
[-0.0125 .65937 0 4.5 ]
[-0.0125 .78649 -24 -4.5 ]
[-0.0125 .78649 0 4.5 ]
[-0.0125 .9136 -30 -4.5 ]
[-0.0125 .9136 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(5)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(10)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(15)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(20)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(25)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(30)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.05357 0 m
.05357 .00375 L
s
.08333 0 m
.08333 .00375 L
s
.1131 0 m
.1131 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.23214 0 m
.23214 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.29167 0 m
.29167 .00375 L
s
.35119 0 m
.35119 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.41071 0 m
.41071 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.52976 0 m
.52976 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.58929 0 m
.58929 .00375 L
s
.64881 0 m
.64881 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.70833 0 m
.70833 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.82738 0 m
.82738 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.8869 0 m
.8869 .00375 L
s
.94643 0 m
.94643 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .15092 m
.00625 .15092 L
s
[(0.005)] -0.0125 .15092 1 0 Mshowa
0 .27803 m
.00625 .27803 L
s
[(0.01)] -0.0125 .27803 1 0 Mshowa
0 .40515 m
.00625 .40515 L
s
[(0.015)] -0.0125 .40515 1 0 Mshowa
0 .53226 m
.00625 .53226 L
s
[(0.02)] -0.0125 .53226 1 0 Mshowa
0 .65937 m
.00625 .65937 L
s
[(0.025)] -0.0125 .65937 1 0 Mshowa
0 .78649 m
.00625 .78649 L
s
[(0.03)] -0.0125 .78649 1 0 Mshowa
0 .9136 m
.00625 .9136 L
s
[(0.035)] -0.0125 .9136 1 0 Mshowa
.125 Mabswid
0 .04923 m
.00375 .04923 L
s
0 .07465 m
.00375 .07465 L
s
0 .10008 m
.00375 .10008 L
s
0 .1255 m
.00375 .1255 L
s
0 .17634 m
.00375 .17634 L
s
0 .20177 m
.00375 .20177 L
s
0 .22719 m
.00375 .22719 L
s
0 .25261 m
.00375 .25261 L
s
0 .30346 m
.00375 .30346 L
s
0 .32888 m
.00375 .32888 L
s
0 .3543 m
.00375 .3543 L
s
0 .37973 m
.00375 .37973 L
s
0 .43057 m
.00375 .43057 L
s
0 .45599 m
.00375 .45599 L
s
0 .48142 m
.00375 .48142 L
s
0 .50684 m
.00375 .50684 L
s
0 .55768 m
.00375 .55768 L
s
0 .58311 m
.00375 .58311 L
s
0 .60853 m
.00375 .60853 L
s
0 .63395 m
.00375 .63395 L
s
0 .6848 m
.00375 .6848 L
s
0 .71022 m
.00375 .71022 L
s
0 .73564 m
.00375 .73564 L
s
0 .76106 m
.00375 .76106 L
s
0 .81191 m
.00375 .81191 L
s
0 .83733 m
.00375 .83733 L
s
0 .86275 m
.00375 .86275 L
s
0 .88818 m
.00375 .88818 L
s
0 .93902 m
.00375 .93902 L
s
0 .96444 m
.00375 .96444 L
s
0 .98987 m
.00375 .98987 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.17262 .99375 m
.17262 1 L
s
.32143 .99375 m
.32143 1 L
s
.47024 .99375 m
.47024 1 L
s
.61905 .99375 m
.61905 1 L
s
.76786 .99375 m
.76786 1 L
s
.91667 .99375 m
.91667 1 L
s
.125 Mabswid
.05357 .99625 m
.05357 1 L
s
.08333 .99625 m
.08333 1 L
s
.1131 .99625 m
.1131 1 L
s
.14286 .99625 m
.14286 1 L
s
.20238 .99625 m
.20238 1 L
s
.23214 .99625 m
.23214 1 L
s
.2619 .99625 m
.2619 1 L
s
.29167 .99625 m
.29167 1 L
s
.35119 .99625 m
.35119 1 L
s
.38095 .99625 m
.38095 1 L
s
.41071 .99625 m
.41071 1 L
s
.44048 .99625 m
.44048 1 L
s
.5 .99625 m
.5 1 L
s
.52976 .99625 m
.52976 1 L
s
.55952 .99625 m
.55952 1 L
s
.58929 .99625 m
.58929 1 L
s
.64881 .99625 m
.64881 1 L
s
.67857 .99625 m
.67857 1 L
s
.70833 .99625 m
.70833 1 L
s
.7381 .99625 m
.7381 1 L
s
.79762 .99625 m
.79762 1 L
s
.82738 .99625 m
.82738 1 L
s
.85714 .99625 m
.85714 1 L
s
.8869 .99625 m
.8869 1 L
s
.94643 .99625 m
.94643 1 L
s
.97619 .99625 m
.97619 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .15092 m
1 .15092 L
s
.99375 .27803 m
1 .27803 L
s
.99375 .40515 m
1 .40515 L
s
.99375 .53226 m
1 .53226 L
s
.99375 .65937 m
1 .65937 L
s
.99375 .78649 m
1 .78649 L
s
.99375 .9136 m
1 .9136 L
s
.125 Mabswid
.99625 .04923 m
1 .04923 L
s
.99625 .07465 m
1 .07465 L
s
.99625 .10008 m
1 .10008 L
s
.99625 .1255 m
1 .1255 L
s
.99625 .17634 m
1 .17634 L
s
.99625 .20177 m
1 .20177 L
s
.99625 .22719 m
1 .22719 L
s
.99625 .25261 m
1 .25261 L
s
.99625 .30346 m
1 .30346 L
s
.99625 .32888 m
1 .32888 L
s
.99625 .3543 m
1 .3543 L
s
.99625 .37973 m
1 .37973 L
s
.99625 .43057 m
1 .43057 L
s
.99625 .45599 m
1 .45599 L
s
.99625 .48142 m
1 .48142 L
s
.99625 .50684 m
1 .50684 L
s
.99625 .55768 m
1 .55768 L
s
.99625 .58311 m
1 .58311 L
s
.99625 .60853 m
1 .60853 L
s
.99625 .63395 m
1 .63395 L
s
.99625 .6848 m
1 .6848 L
s
.99625 .71022 m
1 .71022 L
s
.99625 .73564 m
1 .73564 L
s
.99625 .76106 m
1 .76106 L
s
.99625 .81191 m
1 .81191 L
s
.99625 .83733 m
1 .83733 L
s
.99625 .86275 m
1 .86275 L
s
.99625 .88818 m
1 .88818 L
s
.99625 .93902 m
1 .93902 L
s
.99625 .96444 m
1 .96444 L
s
.99625 .98987 m
1 .98987 L
s
.25 Mabswid
1 0 m
1 1 L
s
1 0 0 r
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.0253 .02381 -1.875 0 Mabsadd m
.0253 .02381 0 2.5 Mabsadd L
.0253 .02381 1.875 0 Mabsadd L
.0253 .02381 0 -2.5 Mabsadd L
.0253 .02381 -1.875 0 Mabsadd L closepath F
.02679 .02381 -1.875 0 Mabsadd m
.02679 .02381 0 2.5 Mabsadd L
.02679 .02381 1.875 0 Mabsadd L
.02679 .02381 0 -2.5 Mabsadd L
.02679 .02381 -1.875 0 Mabsadd L closepath F
.02827 .02381 -1.875 0 Mabsadd m
.02827 .02381 0 2.5 Mabsadd L
.02827 .02381 1.875 0 Mabsadd L
.02827 .02381 0 -2.5 Mabsadd L
.02827 .02381 -1.875 0 Mabsadd L closepath F
.02976 .02381 -1.875 0 Mabsadd m
.02976 .02381 0 2.5 Mabsadd L
.02976 .02381 1.875 0 Mabsadd L
.02976 .02381 0 -2.5 Mabsadd L
.02976 .02381 -1.875 0 Mabsadd L closepath F
.03125 .02381 -1.875 0 Mabsadd m
.03125 .02381 0 2.5 Mabsadd L
.03125 .02381 1.875 0 Mabsadd L
.03125 .02381 0 -2.5 Mabsadd L
.03125 .02381 -1.875 0 Mabsadd L closepath F
.03274 .02381 -1.875 0 Mabsadd m
.03274 .02381 0 2.5 Mabsadd L
.03274 .02381 1.875 0 Mabsadd L
.03274 .02381 0 -2.5 Mabsadd L
.03274 .02381 -1.875 0 Mabsadd L closepath F
.03423 .02381 -1.875 0 Mabsadd m
.03423 .02381 0 2.5 Mabsadd L
.03423 .02381 1.875 0 Mabsadd L
.03423 .02381 0 -2.5 Mabsadd L
.03423 .02381 -1.875 0 Mabsadd L closepath F
.03571 .02381 -1.875 0 Mabsadd m
.03571 .02381 0 2.5 Mabsadd L
.03571 .02381 1.875 0 Mabsadd L
.03571 .02381 0 -2.5 Mabsadd L
.03571 .02381 -1.875 0 Mabsadd L closepath F
.0372 .02381 -1.875 0 Mabsadd m
.0372 .02381 0 2.5 Mabsadd L
.0372 .02381 1.875 0 Mabsadd L
.0372 .02381 0 -2.5 Mabsadd L
.0372 .02381 -1.875 0 Mabsadd L closepath F
.03869 .02381 -1.875 0 Mabsadd m
.03869 .02381 0 2.5 Mabsadd L
.03869 .02381 1.875 0 Mabsadd L
.03869 .02381 0 -2.5 Mabsadd L
.03869 .02381 -1.875 0 Mabsadd L closepath F
.04018 .02381 -1.875 0 Mabsadd m
.04018 .02381 0 2.5 Mabsadd L
.04018 .02381 1.875 0 Mabsadd L
.04018 .02381 0 -2.5 Mabsadd L
.04018 .02381 -1.875 0 Mabsadd L closepath F
.04167 .02381 -1.875 0 Mabsadd m
.04167 .02381 0 2.5 Mabsadd L
.04167 .02381 1.875 0 Mabsadd L
.04167 .02381 0 -2.5 Mabsadd L
.04167 .02381 -1.875 0 Mabsadd L closepath F
.04315 .02381 -1.875 0 Mabsadd m
.04315 .02381 0 2.5 Mabsadd L
.04315 .02381 1.875 0 Mabsadd L
.04315 .02381 0 -2.5 Mabsadd L
.04315 .02381 -1.875 0 Mabsadd L closepath F
.04464 .02381 -1.875 0 Mabsadd m
.04464 .02381 0 2.5 Mabsadd L
.04464 .02381 1.875 0 Mabsadd L
.04464 .02381 0 -2.5 Mabsadd L
.04464 .02381 -1.875 0 Mabsadd L closepath F
.04613 .02381 -1.875 0 Mabsadd m
.04613 .02381 0 2.5 Mabsadd L
.04613 .02381 1.875 0 Mabsadd L
.04613 .02381 0 -2.5 Mabsadd L
.04613 .02381 -1.875 0 Mabsadd L closepath F
.04762 .02381 -1.875 0 Mabsadd m
.04762 .02381 0 2.5 Mabsadd L
.04762 .02381 1.875 0 Mabsadd L
.04762 .02381 0 -2.5 Mabsadd L
.04762 .02381 -1.875 0 Mabsadd L closepath F
.04911 .02381 -1.875 0 Mabsadd m
.04911 .02381 0 2.5 Mabsadd L
.04911 .02381 1.875 0 Mabsadd L
.04911 .02381 0 -2.5 Mabsadd L
.04911 .02381 -1.875 0 Mabsadd L closepath F
.0506 .02381 -1.875 0 Mabsadd m
.0506 .02381 0 2.5 Mabsadd L
.0506 .02381 1.875 0 Mabsadd L
.0506 .02381 0 -2.5 Mabsadd L
.0506 .02381 -1.875 0 Mabsadd L closepath F
.05208 .02381 -1.875 0 Mabsadd m
.05208 .02381 0 2.5 Mabsadd L
.05208 .02381 1.875 0 Mabsadd L
.05208 .02381 0 -2.5 Mabsadd L
.05208 .02381 -1.875 0 Mabsadd L closepath F
.05357 .02381 -1.875 0 Mabsadd m
.05357 .02381 0 2.5 Mabsadd L
.05357 .02381 1.875 0 Mabsadd L
.05357 .02381 0 -2.5 Mabsadd L
.05357 .02381 -1.875 0 Mabsadd L closepath F
.05506 .02381 -1.875 0 Mabsadd m
.05506 .02381 0 2.5 Mabsadd L
.05506 .02381 1.875 0 Mabsadd L
.05506 .02381 0 -2.5 Mabsadd L
.05506 .02381 -1.875 0 Mabsadd L closepath F
.05655 .02381 -1.875 0 Mabsadd m
.05655 .02381 0 2.5 Mabsadd L
.05655 .02381 1.875 0 Mabsadd L
.05655 .02381 0 -2.5 Mabsadd L
.05655 .02381 -1.875 0 Mabsadd L closepath F
.05804 .02381 -1.875 0 Mabsadd m
.05804 .02381 0 2.5 Mabsadd L
.05804 .02381 1.875 0 Mabsadd L
.05804 .02381 0 -2.5 Mabsadd L
.05804 .02381 -1.875 0 Mabsadd L closepath F
.05952 .02381 -1.875 0 Mabsadd m
.05952 .02381 0 2.5 Mabsadd L
.05952 .02381 1.875 0 Mabsadd L
.05952 .02381 0 -2.5 Mabsadd L
.05952 .02381 -1.875 0 Mabsadd L closepath F
.06101 .02381 -1.875 0 Mabsadd m
.06101 .02381 0 2.5 Mabsadd L
.06101 .02381 1.875 0 Mabsadd L
.06101 .02381 0 -2.5 Mabsadd L
.06101 .02381 -1.875 0 Mabsadd L closepath F
.0625 .02381 -1.875 0 Mabsadd m
.0625 .02381 0 2.5 Mabsadd L
.0625 .02381 1.875 0 Mabsadd L
.0625 .02381 0 -2.5 Mabsadd L
.0625 .02381 -1.875 0 Mabsadd L closepath F
.06399 .02381 -1.875 0 Mabsadd m
.06399 .02381 0 2.5 Mabsadd L
.06399 .02381 1.875 0 Mabsadd L
.06399 .02381 0 -2.5 Mabsadd L
.06399 .02381 -1.875 0 Mabsadd L closepath F
.06548 .02381 -1.875 0 Mabsadd m
.06548 .02381 0 2.5 Mabsadd L
.06548 .02381 1.875 0 Mabsadd L
.06548 .02381 0 -2.5 Mabsadd L
.06548 .02381 -1.875 0 Mabsadd L closepath F
.06696 .02381 -1.875 0 Mabsadd m
.06696 .02381 0 2.5 Mabsadd L
.06696 .02381 1.875 0 Mabsadd L
.06696 .02381 0 -2.5 Mabsadd L
.06696 .02381 -1.875 0 Mabsadd L closepath F
.06845 .02381 -1.875 0 Mabsadd m
.06845 .02381 0 2.5 Mabsadd L
.06845 .02381 1.875 0 Mabsadd L
.06845 .02381 0 -2.5 Mabsadd L
.06845 .02381 -1.875 0 Mabsadd L closepath F
.06994 .02381 -1.875 0 Mabsadd m
.06994 .02381 0 2.5 Mabsadd L
.06994 .02381 1.875 0 Mabsadd L
.06994 .02381 0 -2.5 Mabsadd L
.06994 .02381 -1.875 0 Mabsadd L closepath F
.07143 .02381 -1.875 0 Mabsadd m
.07143 .02381 0 2.5 Mabsadd L
.07143 .02381 1.875 0 Mabsadd L
.07143 .02381 0 -2.5 Mabsadd L
.07143 .02381 -1.875 0 Mabsadd L closepath F
.07292 .02381 -1.875 0 Mabsadd m
.07292 .02381 0 2.5 Mabsadd L
.07292 .02381 1.875 0 Mabsadd L
.07292 .02381 0 -2.5 Mabsadd L
.07292 .02381 -1.875 0 Mabsadd L closepath F
.0744 .02381 -1.875 0 Mabsadd m
.0744 .02381 0 2.5 Mabsadd L
.0744 .02381 1.875 0 Mabsadd L
.0744 .02381 0 -2.5 Mabsadd L
.0744 .02381 -1.875 0 Mabsadd L closepath F
.07589 .02381 -1.875 0 Mabsadd m
.07589 .02381 0 2.5 Mabsadd L
.07589 .02381 1.875 0 Mabsadd L
.07589 .02381 0 -2.5 Mabsadd L
.07589 .02381 -1.875 0 Mabsadd L closepath F
.07738 .02381 -1.875 0 Mabsadd m
.07738 .02381 0 2.5 Mabsadd L
.07738 .02381 1.875 0 Mabsadd L
.07738 .02381 0 -2.5 Mabsadd L
.07738 .02381 -1.875 0 Mabsadd L closepath F
.07887 .02381 -1.875 0 Mabsadd m
.07887 .02381 0 2.5 Mabsadd L
.07887 .02381 1.875 0 Mabsadd L
.07887 .02381 0 -2.5 Mabsadd L
.07887 .02381 -1.875 0 Mabsadd L closepath F
.08036 .02381 -1.875 0 Mabsadd m
.08036 .02381 0 2.5 Mabsadd L
.08036 .02381 1.875 0 Mabsadd L
.08036 .02381 0 -2.5 Mabsadd L
.08036 .02381 -1.875 0 Mabsadd L closepath F
.08185 .02381 -1.875 0 Mabsadd m
.08185 .02381 0 2.5 Mabsadd L
.08185 .02381 1.875 0 Mabsadd L
.08185 .02381 0 -2.5 Mabsadd L
.08185 .02381 -1.875 0 Mabsadd L closepath F
.08333 .02381 -1.875 0 Mabsadd m
.08333 .02381 0 2.5 Mabsadd L
.08333 .02381 1.875 0 Mabsadd L
.08333 .02381 0 -2.5 Mabsadd L
.08333 .02381 -1.875 0 Mabsadd L closepath F
.08482 .02381 -1.875 0 Mabsadd m
.08482 .02381 0 2.5 Mabsadd L
.08482 .02381 1.875 0 Mabsadd L
.08482 .02381 0 -2.5 Mabsadd L
.08482 .02381 -1.875 0 Mabsadd L closepath F
.08631 .02381 -1.875 0 Mabsadd m
.08631 .02381 0 2.5 Mabsadd L
.08631 .02381 1.875 0 Mabsadd L
.08631 .02381 0 -2.5 Mabsadd L
.08631 .02381 -1.875 0 Mabsadd L closepath F
.0878 .02381 -1.875 0 Mabsadd m
.0878 .02381 0 2.5 Mabsadd L
.0878 .02381 1.875 0 Mabsadd L
.0878 .02381 0 -2.5 Mabsadd L
.0878 .02381 -1.875 0 Mabsadd L closepath F
.08929 .02381 -1.875 0 Mabsadd m
.08929 .02381 0 2.5 Mabsadd L
.08929 .02381 1.875 0 Mabsadd L
.08929 .02381 0 -2.5 Mabsadd L
.08929 .02381 -1.875 0 Mabsadd L closepath F
.09077 .02381 -1.875 0 Mabsadd m
.09077 .02381 0 2.5 Mabsadd L
.09077 .02381 1.875 0 Mabsadd L
.09077 .02381 0 -2.5 Mabsadd L
.09077 .02381 -1.875 0 Mabsadd L closepath F
.09226 .02381 -1.875 0 Mabsadd m
.09226 .02381 0 2.5 Mabsadd L
.09226 .02381 1.875 0 Mabsadd L
.09226 .02381 0 -2.5 Mabsadd L
.09226 .02381 -1.875 0 Mabsadd L closepath F
.09375 .02381 -1.875 0 Mabsadd m
.09375 .02381 0 2.5 Mabsadd L
.09375 .02381 1.875 0 Mabsadd L
.09375 .02381 0 -2.5 Mabsadd L
.09375 .02381 -1.875 0 Mabsadd L closepath F
.09524 .02381 -1.875 0 Mabsadd m
.09524 .02381 0 2.5 Mabsadd L
.09524 .02381 1.875 0 Mabsadd L
.09524 .02381 0 -2.5 Mabsadd L
.09524 .02381 -1.875 0 Mabsadd L closepath F
.09673 .02381 -1.875 0 Mabsadd m
.09673 .02381 0 2.5 Mabsadd L
.09673 .02381 1.875 0 Mabsadd L
.09673 .02381 0 -2.5 Mabsadd L
.09673 .02381 -1.875 0 Mabsadd L closepath F
.09821 .02381 -1.875 0 Mabsadd m
.09821 .02381 0 2.5 Mabsadd L
.09821 .02381 1.875 0 Mabsadd L
.09821 .02381 0 -2.5 Mabsadd L
.09821 .02381 -1.875 0 Mabsadd L closepath F
.0997 .02381 -1.875 0 Mabsadd m
.0997 .02381 0 2.5 Mabsadd L
.0997 .02381 1.875 0 Mabsadd L
.0997 .02381 0 -2.5 Mabsadd L
.0997 .02381 -1.875 0 Mabsadd L closepath F
.10119 .02381 -1.875 0 Mabsadd m
.10119 .02381 0 2.5 Mabsadd L
.10119 .02381 1.875 0 Mabsadd L
.10119 .02381 0 -2.5 Mabsadd L
.10119 .02381 -1.875 0 Mabsadd L closepath F
.10268 .02381 -1.875 0 Mabsadd m
.10268 .02381 0 2.5 Mabsadd L
.10268 .02381 1.875 0 Mabsadd L
.10268 .02381 0 -2.5 Mabsadd L
.10268 .02381 -1.875 0 Mabsadd L closepath F
.10417 .02381 -1.875 0 Mabsadd m
.10417 .02381 0 2.5 Mabsadd L
.10417 .02381 1.875 0 Mabsadd L
.10417 .02381 0 -2.5 Mabsadd L
.10417 .02381 -1.875 0 Mabsadd L closepath F
.10565 .02381 -1.875 0 Mabsadd m
.10565 .02381 0 2.5 Mabsadd L
.10565 .02381 1.875 0 Mabsadd L
.10565 .02381 0 -2.5 Mabsadd L
.10565 .02381 -1.875 0 Mabsadd L closepath F
.10714 .02381 -1.875 0 Mabsadd m
.10714 .02381 0 2.5 Mabsadd L
.10714 .02381 1.875 0 Mabsadd L
.10714 .02381 0 -2.5 Mabsadd L
.10714 .02381 -1.875 0 Mabsadd L closepath F
.10863 .02381 -1.875 0 Mabsadd m
.10863 .02381 0 2.5 Mabsadd L
.10863 .02381 1.875 0 Mabsadd L
.10863 .02381 0 -2.5 Mabsadd L
.10863 .02381 -1.875 0 Mabsadd L closepath F
.11012 .02381 -1.875 0 Mabsadd m
.11012 .02381 0 2.5 Mabsadd L
.11012 .02381 1.875 0 Mabsadd L
.11012 .02381 0 -2.5 Mabsadd L
.11012 .02381 -1.875 0 Mabsadd L closepath F
.11161 .02381 -1.875 0 Mabsadd m
.11161 .02381 0 2.5 Mabsadd L
.11161 .02381 1.875 0 Mabsadd L
.11161 .02381 0 -2.5 Mabsadd L
.11161 .02381 -1.875 0 Mabsadd L closepath F
.1131 .02381 -1.875 0 Mabsadd m
.1131 .02381 0 2.5 Mabsadd L
.1131 .02381 1.875 0 Mabsadd L
.1131 .02381 0 -2.5 Mabsadd L
.1131 .02381 -1.875 0 Mabsadd L closepath F
.11458 .02381 -1.875 0 Mabsadd m
.11458 .02381 0 2.5 Mabsadd L
.11458 .02381 1.875 0 Mabsadd L
.11458 .02381 0 -2.5 Mabsadd L
.11458 .02381 -1.875 0 Mabsadd L closepath F
.11607 .02381 -1.875 0 Mabsadd m
.11607 .02381 0 2.5 Mabsadd L
.11607 .02381 1.875 0 Mabsadd L
.11607 .02381 0 -2.5 Mabsadd L
.11607 .02381 -1.875 0 Mabsadd L closepath F
.11756 .02381 -1.875 0 Mabsadd m
.11756 .02381 0 2.5 Mabsadd L
.11756 .02381 1.875 0 Mabsadd L
.11756 .02381 0 -2.5 Mabsadd L
.11756 .02381 -1.875 0 Mabsadd L closepath F
.11905 .02381 -1.875 0 Mabsadd m
.11905 .02381 0 2.5 Mabsadd L
.11905 .02381 1.875 0 Mabsadd L
.11905 .02381 0 -2.5 Mabsadd L
.11905 .02381 -1.875 0 Mabsadd L closepath F
.12054 .02381 -1.875 0 Mabsadd m
.12054 .02381 0 2.5 Mabsadd L
.12054 .02381 1.875 0 Mabsadd L
.12054 .02381 0 -2.5 Mabsadd L
.12054 .02381 -1.875 0 Mabsadd L closepath F
.12202 .02381 -1.875 0 Mabsadd m
.12202 .02381 0 2.5 Mabsadd L
.12202 .02381 1.875 0 Mabsadd L
.12202 .02381 0 -2.5 Mabsadd L
.12202 .02381 -1.875 0 Mabsadd L closepath F
.12351 .02381 -1.875 0 Mabsadd m
.12351 .02381 0 2.5 Mabsadd L
.12351 .02381 1.875 0 Mabsadd L
.12351 .02381 0 -2.5 Mabsadd L
.12351 .02381 -1.875 0 Mabsadd L closepath F
.125 .02381 -1.875 0 Mabsadd m
.125 .02381 0 2.5 Mabsadd L
.125 .02381 1.875 0 Mabsadd L
.125 .02381 0 -2.5 Mabsadd L
.125 .02381 -1.875 0 Mabsadd L closepath F
.12649 .02381 -1.875 0 Mabsadd m
.12649 .02381 0 2.5 Mabsadd L
.12649 .02381 1.875 0 Mabsadd L
.12649 .02381 0 -2.5 Mabsadd L
.12649 .02381 -1.875 0 Mabsadd L closepath F
.12798 .02381 -1.875 0 Mabsadd m
.12798 .02381 0 2.5 Mabsadd L
.12798 .02381 1.875 0 Mabsadd L
.12798 .02381 0 -2.5 Mabsadd L
.12798 .02381 -1.875 0 Mabsadd L closepath F
.12946 .02381 -1.875 0 Mabsadd m
.12946 .02381 0 2.5 Mabsadd L
.12946 .02381 1.875 0 Mabsadd L
.12946 .02381 0 -2.5 Mabsadd L
.12946 .02381 -1.875 0 Mabsadd L closepath F
.13095 .02381 -1.875 0 Mabsadd m
.13095 .02381 0 2.5 Mabsadd L
.13095 .02381 1.875 0 Mabsadd L
.13095 .02381 0 -2.5 Mabsadd L
.13095 .02381 -1.875 0 Mabsadd L closepath F
.13244 .02381 -1.875 0 Mabsadd m
.13244 .02381 0 2.5 Mabsadd L
.13244 .02381 1.875 0 Mabsadd L
.13244 .02381 0 -2.5 Mabsadd L
.13244 .02381 -1.875 0 Mabsadd L closepath F
.13393 .02381 -1.875 0 Mabsadd m
.13393 .02381 0 2.5 Mabsadd L
.13393 .02381 1.875 0 Mabsadd L
.13393 .02381 0 -2.5 Mabsadd L
.13393 .02381 -1.875 0 Mabsadd L closepath F
.13542 .02381 -1.875 0 Mabsadd m
.13542 .02381 0 2.5 Mabsadd L
.13542 .02381 1.875 0 Mabsadd L
.13542 .02381 0 -2.5 Mabsadd L
.13542 .02381 -1.875 0 Mabsadd L closepath F
.1369 .02381 -1.875 0 Mabsadd m
.1369 .02381 0 2.5 Mabsadd L
.1369 .02381 1.875 0 Mabsadd L
.1369 .02381 0 -2.5 Mabsadd L
.1369 .02381 -1.875 0 Mabsadd L closepath F
.13839 .02381 -1.875 0 Mabsadd m
.13839 .02381 0 2.5 Mabsadd L
.13839 .02381 1.875 0 Mabsadd L
.13839 .02381 0 -2.5 Mabsadd L
.13839 .02381 -1.875 0 Mabsadd L closepath F
.13988 .02381 -1.875 0 Mabsadd m
.13988 .02381 0 2.5 Mabsadd L
.13988 .02381 1.875 0 Mabsadd L
.13988 .02381 0 -2.5 Mabsadd L
.13988 .02381 -1.875 0 Mabsadd L closepath F
.14137 .02381 -1.875 0 Mabsadd m
.14137 .02381 0 2.5 Mabsadd L
.14137 .02381 1.875 0 Mabsadd L
.14137 .02381 0 -2.5 Mabsadd L
.14137 .02381 -1.875 0 Mabsadd L closepath F
.14286 .02381 -1.875 0 Mabsadd m
.14286 .02381 0 2.5 Mabsadd L
.14286 .02381 1.875 0 Mabsadd L
.14286 .02381 0 -2.5 Mabsadd L
.14286 .02381 -1.875 0 Mabsadd L closepath F
.14435 .02381 -1.875 0 Mabsadd m
.14435 .02381 0 2.5 Mabsadd L
.14435 .02381 1.875 0 Mabsadd L
.14435 .02381 0 -2.5 Mabsadd L
.14435 .02381 -1.875 0 Mabsadd L closepath F
.14583 .02381 -1.875 0 Mabsadd m
.14583 .02381 0 2.5 Mabsadd L
.14583 .02381 1.875 0 Mabsadd L
.14583 .02381 0 -2.5 Mabsadd L
.14583 .02381 -1.875 0 Mabsadd L closepath F
.14732 .02381 -1.875 0 Mabsadd m
.14732 .02381 0 2.5 Mabsadd L
.14732 .02381 1.875 0 Mabsadd L
.14732 .02381 0 -2.5 Mabsadd L
.14732 .02381 -1.875 0 Mabsadd L closepath F
.14881 .02381 -1.875 0 Mabsadd m
.14881 .02381 0 2.5 Mabsadd L
.14881 .02381 1.875 0 Mabsadd L
.14881 .02381 0 -2.5 Mabsadd L
.14881 .02381 -1.875 0 Mabsadd L closepath F
.1503 .02381 -1.875 0 Mabsadd m
.1503 .02381 0 2.5 Mabsadd L
.1503 .02381 1.875 0 Mabsadd L
.1503 .02381 0 -2.5 Mabsadd L
.1503 .02381 -1.875 0 Mabsadd L closepath F
.15179 .02381 -1.875 0 Mabsadd m
.15179 .02381 0 2.5 Mabsadd L
.15179 .02381 1.875 0 Mabsadd L
.15179 .02381 0 -2.5 Mabsadd L
.15179 .02381 -1.875 0 Mabsadd L closepath F
.15327 .02381 -1.875 0 Mabsadd m
.15327 .02381 0 2.5 Mabsadd L
.15327 .02381 1.875 0 Mabsadd L
.15327 .02381 0 -2.5 Mabsadd L
.15327 .02381 -1.875 0 Mabsadd L closepath F
.15476 .02381 -1.875 0 Mabsadd m
.15476 .02381 0 2.5 Mabsadd L
.15476 .02381 1.875 0 Mabsadd L
.15476 .02381 0 -2.5 Mabsadd L
.15476 .02381 -1.875 0 Mabsadd L closepath F
.15625 .02381 -1.875 0 Mabsadd m
.15625 .02381 0 2.5 Mabsadd L
.15625 .02381 1.875 0 Mabsadd L
.15625 .02381 0 -2.5 Mabsadd L
.15625 .02381 -1.875 0 Mabsadd L closepath F
.15774 .02381 -1.875 0 Mabsadd m
.15774 .02381 0 2.5 Mabsadd L
.15774 .02381 1.875 0 Mabsadd L
.15774 .02381 0 -2.5 Mabsadd L
.15774 .02381 -1.875 0 Mabsadd L closepath F
.15923 .02381 -1.875 0 Mabsadd m
.15923 .02381 0 2.5 Mabsadd L
.15923 .02381 1.875 0 Mabsadd L
.15923 .02381 0 -2.5 Mabsadd L
.15923 .02381 -1.875 0 Mabsadd L closepath F
.16071 .02381 -1.875 0 Mabsadd m
.16071 .02381 0 2.5 Mabsadd L
.16071 .02381 1.875 0 Mabsadd L
.16071 .02381 0 -2.5 Mabsadd L
.16071 .02381 -1.875 0 Mabsadd L closepath F
.1622 .02381 -1.875 0 Mabsadd m
.1622 .02381 0 2.5 Mabsadd L
.1622 .02381 1.875 0 Mabsadd L
.1622 .02381 0 -2.5 Mabsadd L
.1622 .02381 -1.875 0 Mabsadd L closepath F
.16369 .02381 -1.875 0 Mabsadd m
.16369 .02381 0 2.5 Mabsadd L
.16369 .02381 1.875 0 Mabsadd L
.16369 .02381 0 -2.5 Mabsadd L
.16369 .02381 -1.875 0 Mabsadd L closepath F
.16518 .02381 -1.875 0 Mabsadd m
.16518 .02381 0 2.5 Mabsadd L
.16518 .02381 1.875 0 Mabsadd L
.16518 .02381 0 -2.5 Mabsadd L
.16518 .02381 -1.875 0 Mabsadd L closepath F
.16667 .02381 -1.875 0 Mabsadd m
.16667 .02381 0 2.5 Mabsadd L
.16667 .02381 1.875 0 Mabsadd L
.16667 .02381 0 -2.5 Mabsadd L
.16667 .02381 -1.875 0 Mabsadd L closepath F
.16815 .02381 -1.875 0 Mabsadd m
.16815 .02381 0 2.5 Mabsadd L
.16815 .02381 1.875 0 Mabsadd L
.16815 .02381 0 -2.5 Mabsadd L
.16815 .02381 -1.875 0 Mabsadd L closepath F
.16964 .02381 -1.875 0 Mabsadd m
.16964 .02381 0 2.5 Mabsadd L
.16964 .02381 1.875 0 Mabsadd L
.16964 .02381 0 -2.5 Mabsadd L
.16964 .02381 -1.875 0 Mabsadd L closepath F
.17113 .02381 -1.875 0 Mabsadd m
.17113 .02381 0 2.5 Mabsadd L
.17113 .02381 1.875 0 Mabsadd L
.17113 .02381 0 -2.5 Mabsadd L
.17113 .02381 -1.875 0 Mabsadd L closepath F
.17262 .02381 -1.875 0 Mabsadd m
.17262 .02381 0 2.5 Mabsadd L
.17262 .02381 1.875 0 Mabsadd L
.17262 .02381 0 -2.5 Mabsadd L
.17262 .02381 -1.875 0 Mabsadd L closepath F
.17411 .02381 -1.875 0 Mabsadd m
.17411 .02381 0 2.5 Mabsadd L
.17411 .02381 1.875 0 Mabsadd L
.17411 .02381 0 -2.5 Mabsadd L
.17411 .02381 -1.875 0 Mabsadd L closepath F
.1756 .02381 -1.875 0 Mabsadd m
.1756 .02381 0 2.5 Mabsadd L
.1756 .02381 1.875 0 Mabsadd L
.1756 .02381 0 -2.5 Mabsadd L
.1756 .02381 -1.875 0 Mabsadd L closepath F
.17708 .02381 -1.875 0 Mabsadd m
.17708 .02381 0 2.5 Mabsadd L
.17708 .02381 1.875 0 Mabsadd L
.17708 .02381 0 -2.5 Mabsadd L
.17708 .02381 -1.875 0 Mabsadd L closepath F
.17857 .02381 -1.875 0 Mabsadd m
.17857 .02381 0 2.5 Mabsadd L
.17857 .02381 1.875 0 Mabsadd L
.17857 .02381 0 -2.5 Mabsadd L
.17857 .02381 -1.875 0 Mabsadd L closepath F
.18006 .02381 -1.875 0 Mabsadd m
.18006 .02381 0 2.5 Mabsadd L
.18006 .02381 1.875 0 Mabsadd L
.18006 .02381 0 -2.5 Mabsadd L
.18006 .02381 -1.875 0 Mabsadd L closepath F
.18155 .02381 -1.875 0 Mabsadd m
.18155 .02381 0 2.5 Mabsadd L
.18155 .02381 1.875 0 Mabsadd L
.18155 .02381 0 -2.5 Mabsadd L
.18155 .02381 -1.875 0 Mabsadd L closepath F
.18304 .02381 -1.875 0 Mabsadd m
.18304 .02381 0 2.5 Mabsadd L
.18304 .02381 1.875 0 Mabsadd L
.18304 .02381 0 -2.5 Mabsadd L
.18304 .02381 -1.875 0 Mabsadd L closepath F
.18452 .02381 -1.875 0 Mabsadd m
.18452 .02381 0 2.5 Mabsadd L
.18452 .02381 1.875 0 Mabsadd L
.18452 .02381 0 -2.5 Mabsadd L
.18452 .02381 -1.875 0 Mabsadd L closepath F
.18601 .02381 -1.875 0 Mabsadd m
.18601 .02381 0 2.5 Mabsadd L
.18601 .02381 1.875 0 Mabsadd L
.18601 .02381 0 -2.5 Mabsadd L
.18601 .02381 -1.875 0 Mabsadd L closepath F
.1875 .02381 -1.875 0 Mabsadd m
.1875 .02381 0 2.5 Mabsadd L
.1875 .02381 1.875 0 Mabsadd L
.1875 .02381 0 -2.5 Mabsadd L
.1875 .02381 -1.875 0 Mabsadd L closepath F
.18899 .02381 -1.875 0 Mabsadd m
.18899 .02381 0 2.5 Mabsadd L
.18899 .02381 1.875 0 Mabsadd L
.18899 .02381 0 -2.5 Mabsadd L
.18899 .02381 -1.875 0 Mabsadd L closepath F
.19048 .02381 -1.875 0 Mabsadd m
.19048 .02381 0 2.5 Mabsadd L
.19048 .02381 1.875 0 Mabsadd L
.19048 .02381 0 -2.5 Mabsadd L
.19048 .02381 -1.875 0 Mabsadd L closepath F
.19196 .02381 -1.875 0 Mabsadd m
.19196 .02381 0 2.5 Mabsadd L
.19196 .02381 1.875 0 Mabsadd L
.19196 .02381 0 -2.5 Mabsadd L
.19196 .02381 -1.875 0 Mabsadd L closepath F
.19345 .02381 -1.875 0 Mabsadd m
.19345 .02381 0 2.5 Mabsadd L
.19345 .02381 1.875 0 Mabsadd L
.19345 .02381 0 -2.5 Mabsadd L
.19345 .02381 -1.875 0 Mabsadd L closepath F
.19494 .02381 -1.875 0 Mabsadd m
.19494 .02381 0 2.5 Mabsadd L
.19494 .02381 1.875 0 Mabsadd L
.19494 .02381 0 -2.5 Mabsadd L
.19494 .02381 -1.875 0 Mabsadd L closepath F
.19643 .02381 -1.875 0 Mabsadd m
.19643 .02381 0 2.5 Mabsadd L
.19643 .02381 1.875 0 Mabsadd L
.19643 .02381 0 -2.5 Mabsadd L
.19643 .02381 -1.875 0 Mabsadd L closepath F
.19792 .02381 -1.875 0 Mabsadd m
.19792 .02381 0 2.5 Mabsadd L
.19792 .02381 1.875 0 Mabsadd L
.19792 .02381 0 -2.5 Mabsadd L
.19792 .02381 -1.875 0 Mabsadd L closepath F
.1994 .02381 -1.875 0 Mabsadd m
.1994 .02381 0 2.5 Mabsadd L
.1994 .02381 1.875 0 Mabsadd L
.1994 .02381 0 -2.5 Mabsadd L
.1994 .02381 -1.875 0 Mabsadd L closepath F
.20089 .02381 -1.875 0 Mabsadd m
.20089 .02381 0 2.5 Mabsadd L
.20089 .02381 1.875 0 Mabsadd L
.20089 .02381 0 -2.5 Mabsadd L
.20089 .02381 -1.875 0 Mabsadd L closepath F
.20238 .02381 -1.875 0 Mabsadd m
.20238 .02381 0 2.5 Mabsadd L
.20238 .02381 1.875 0 Mabsadd L
.20238 .02381 0 -2.5 Mabsadd L
.20238 .02381 -1.875 0 Mabsadd L closepath F
.20387 .02381 -1.875 0 Mabsadd m
.20387 .02381 0 2.5 Mabsadd L
.20387 .02381 1.875 0 Mabsadd L
.20387 .02381 0 -2.5 Mabsadd L
.20387 .02381 -1.875 0 Mabsadd L closepath F
.20536 .02381 -1.875 0 Mabsadd m
.20536 .02381 0 2.5 Mabsadd L
.20536 .02381 1.875 0 Mabsadd L
.20536 .02381 0 -2.5 Mabsadd L
.20536 .02381 -1.875 0 Mabsadd L closepath F
.20685 .02381 -1.875 0 Mabsadd m
.20685 .02381 0 2.5 Mabsadd L
.20685 .02381 1.875 0 Mabsadd L
.20685 .02381 0 -2.5 Mabsadd L
.20685 .02381 -1.875 0 Mabsadd L closepath F
.20833 .02381 -1.875 0 Mabsadd m
.20833 .02381 0 2.5 Mabsadd L
.20833 .02381 1.875 0 Mabsadd L
.20833 .02381 0 -2.5 Mabsadd L
.20833 .02381 -1.875 0 Mabsadd L closepath F
.20982 .02381 -1.875 0 Mabsadd m
.20982 .02381 0 2.5 Mabsadd L
.20982 .02381 1.875 0 Mabsadd L
.20982 .02381 0 -2.5 Mabsadd L
.20982 .02381 -1.875 0 Mabsadd L closepath F
.21131 .02381 -1.875 0 Mabsadd m
.21131 .02381 0 2.5 Mabsadd L
.21131 .02381 1.875 0 Mabsadd L
.21131 .02381 0 -2.5 Mabsadd L
.21131 .02381 -1.875 0 Mabsadd L closepath F
.2128 .02381 -1.875 0 Mabsadd m
.2128 .02381 0 2.5 Mabsadd L
.2128 .02381 1.875 0 Mabsadd L
.2128 .02381 0 -2.5 Mabsadd L
.2128 .02381 -1.875 0 Mabsadd L closepath F
.21429 .02381 -1.875 0 Mabsadd m
.21429 .02381 0 2.5 Mabsadd L
.21429 .02381 1.875 0 Mabsadd L
.21429 .02381 0 -2.5 Mabsadd L
.21429 .02381 -1.875 0 Mabsadd L closepath F
.21577 .02381 -1.875 0 Mabsadd m
.21577 .02381 0 2.5 Mabsadd L
.21577 .02381 1.875 0 Mabsadd L
.21577 .02381 0 -2.5 Mabsadd L
.21577 .02381 -1.875 0 Mabsadd L closepath F
.21726 .02381 -1.875 0 Mabsadd m
.21726 .02381 0 2.5 Mabsadd L
.21726 .02381 1.875 0 Mabsadd L
.21726 .02381 0 -2.5 Mabsadd L
.21726 .02381 -1.875 0 Mabsadd L closepath F
.21875 .02381 -1.875 0 Mabsadd m
.21875 .02381 0 2.5 Mabsadd L
.21875 .02381 1.875 0 Mabsadd L
.21875 .02381 0 -2.5 Mabsadd L
.21875 .02381 -1.875 0 Mabsadd L closepath F
.22024 .02381 -1.875 0 Mabsadd m
.22024 .02381 0 2.5 Mabsadd L
.22024 .02381 1.875 0 Mabsadd L
.22024 .02381 0 -2.5 Mabsadd L
.22024 .02381 -1.875 0 Mabsadd L closepath F
.22173 .02381 -1.875 0 Mabsadd m
.22173 .02381 0 2.5 Mabsadd L
.22173 .02381 1.875 0 Mabsadd L
.22173 .02381 0 -2.5 Mabsadd L
.22173 .02381 -1.875 0 Mabsadd L closepath F
.22321 .02381 -1.875 0 Mabsadd m
.22321 .02381 0 2.5 Mabsadd L
.22321 .02381 1.875 0 Mabsadd L
.22321 .02381 0 -2.5 Mabsadd L
.22321 .02381 -1.875 0 Mabsadd L closepath F
.2247 .02381 -1.875 0 Mabsadd m
.2247 .02381 0 2.5 Mabsadd L
.2247 .02381 1.875 0 Mabsadd L
.2247 .02381 0 -2.5 Mabsadd L
.2247 .02381 -1.875 0 Mabsadd L closepath F
.22619 .02381 -1.875 0 Mabsadd m
.22619 .02381 0 2.5 Mabsadd L
.22619 .02381 1.875 0 Mabsadd L
.22619 .02381 0 -2.5 Mabsadd L
.22619 .02381 -1.875 0 Mabsadd L closepath F
.22768 .02381 -1.875 0 Mabsadd m
.22768 .02381 0 2.5 Mabsadd L
.22768 .02381 1.875 0 Mabsadd L
.22768 .02381 0 -2.5 Mabsadd L
.22768 .02381 -1.875 0 Mabsadd L closepath F
.22917 .02381 -1.875 0 Mabsadd m
.22917 .02381 0 2.5 Mabsadd L
.22917 .02381 1.875 0 Mabsadd L
.22917 .02381 0 -2.5 Mabsadd L
.22917 .02381 -1.875 0 Mabsadd L closepath F
.23065 .02381 -1.875 0 Mabsadd m
.23065 .02381 0 2.5 Mabsadd L
.23065 .02381 1.875 0 Mabsadd L
.23065 .02381 0 -2.5 Mabsadd L
.23065 .02381 -1.875 0 Mabsadd L closepath F
.23214 .02381 -1.875 0 Mabsadd m
.23214 .02381 0 2.5 Mabsadd L
.23214 .02381 1.875 0 Mabsadd L
.23214 .02381 0 -2.5 Mabsadd L
.23214 .02381 -1.875 0 Mabsadd L closepath F
.23363 .02381 -1.875 0 Mabsadd m
.23363 .02381 0 2.5 Mabsadd L
.23363 .02381 1.875 0 Mabsadd L
.23363 .02381 0 -2.5 Mabsadd L
.23363 .02381 -1.875 0 Mabsadd L closepath F
.23512 .02381 -1.875 0 Mabsadd m
.23512 .02381 0 2.5 Mabsadd L
.23512 .02381 1.875 0 Mabsadd L
.23512 .02381 0 -2.5 Mabsadd L
.23512 .02381 -1.875 0 Mabsadd L closepath F
.23661 .02381 -1.875 0 Mabsadd m
.23661 .02381 0 2.5 Mabsadd L
.23661 .02381 1.875 0 Mabsadd L
.23661 .02381 0 -2.5 Mabsadd L
.23661 .02381 -1.875 0 Mabsadd L closepath F
.2381 .02381 -1.875 0 Mabsadd m
.2381 .02381 0 2.5 Mabsadd L
.2381 .02381 1.875 0 Mabsadd L
.2381 .02381 0 -2.5 Mabsadd L
.2381 .02381 -1.875 0 Mabsadd L closepath F
.23958 .02381 -1.875 0 Mabsadd m
.23958 .02381 0 2.5 Mabsadd L
.23958 .02381 1.875 0 Mabsadd L
.23958 .02381 0 -2.5 Mabsadd L
.23958 .02381 -1.875 0 Mabsadd L closepath F
.24107 .02381 -1.875 0 Mabsadd m
.24107 .02381 0 2.5 Mabsadd L
.24107 .02381 1.875 0 Mabsadd L
.24107 .02381 0 -2.5 Mabsadd L
.24107 .02381 -1.875 0 Mabsadd L closepath F
.24256 .02381 -1.875 0 Mabsadd m
.24256 .02381 0 2.5 Mabsadd L
.24256 .02381 1.875 0 Mabsadd L
.24256 .02381 0 -2.5 Mabsadd L
.24256 .02381 -1.875 0 Mabsadd L closepath F
.24405 .02381 -1.875 0 Mabsadd m
.24405 .02381 0 2.5 Mabsadd L
.24405 .02381 1.875 0 Mabsadd L
.24405 .02381 0 -2.5 Mabsadd L
.24405 .02381 -1.875 0 Mabsadd L closepath F
.24554 .02381 -1.875 0 Mabsadd m
.24554 .02381 0 2.5 Mabsadd L
.24554 .02381 1.875 0 Mabsadd L
.24554 .02381 0 -2.5 Mabsadd L
.24554 .02381 -1.875 0 Mabsadd L closepath F
.24702 .02381 -1.875 0 Mabsadd m
.24702 .02381 0 2.5 Mabsadd L
.24702 .02381 1.875 0 Mabsadd L
.24702 .02381 0 -2.5 Mabsadd L
.24702 .02381 -1.875 0 Mabsadd L closepath F
.24851 .02381 -1.875 0 Mabsadd m
.24851 .02381 0 2.5 Mabsadd L
.24851 .02381 1.875 0 Mabsadd L
.24851 .02381 0 -2.5 Mabsadd L
.24851 .02381 -1.875 0 Mabsadd L closepath F
.25 .02381 -1.875 0 Mabsadd m
.25 .02381 0 2.5 Mabsadd L
.25 .02381 1.875 0 Mabsadd L
.25 .02381 0 -2.5 Mabsadd L
.25 .02381 -1.875 0 Mabsadd L closepath F
.25149 .02381 -1.875 0 Mabsadd m
.25149 .02381 0 2.5 Mabsadd L
.25149 .02381 1.875 0 Mabsadd L
.25149 .02381 0 -2.5 Mabsadd L
.25149 .02381 -1.875 0 Mabsadd L closepath F
.25298 .02381 -1.875 0 Mabsadd m
.25298 .02381 0 2.5 Mabsadd L
.25298 .02381 1.875 0 Mabsadd L
.25298 .02381 0 -2.5 Mabsadd L
.25298 .02381 -1.875 0 Mabsadd L closepath F
.25446 .02381 -1.875 0 Mabsadd m
.25446 .02381 0 2.5 Mabsadd L
.25446 .02381 1.875 0 Mabsadd L
.25446 .02381 0 -2.5 Mabsadd L
.25446 .02381 -1.875 0 Mabsadd L closepath F
.25595 .02381 -1.875 0 Mabsadd m
.25595 .02381 0 2.5 Mabsadd L
.25595 .02381 1.875 0 Mabsadd L
.25595 .02381 0 -2.5 Mabsadd L
.25595 .02381 -1.875 0 Mabsadd L closepath F
.25744 .02381 -1.875 0 Mabsadd m
.25744 .02381 0 2.5 Mabsadd L
.25744 .02381 1.875 0 Mabsadd L
.25744 .02381 0 -2.5 Mabsadd L
.25744 .02381 -1.875 0 Mabsadd L closepath F
.25893 .02381 -1.875 0 Mabsadd m
.25893 .02381 0 2.5 Mabsadd L
.25893 .02381 1.875 0 Mabsadd L
.25893 .02381 0 -2.5 Mabsadd L
.25893 .02381 -1.875 0 Mabsadd L closepath F
.26042 .02381 -1.875 0 Mabsadd m
.26042 .02381 0 2.5 Mabsadd L
.26042 .02381 1.875 0 Mabsadd L
.26042 .02381 0 -2.5 Mabsadd L
.26042 .02381 -1.875 0 Mabsadd L closepath F
.2619 .02381 -1.875 0 Mabsadd m
.2619 .02381 0 2.5 Mabsadd L
.2619 .02381 1.875 0 Mabsadd L
.2619 .02381 0 -2.5 Mabsadd L
.2619 .02381 -1.875 0 Mabsadd L closepath F
.26339 .02381 -1.875 0 Mabsadd m
.26339 .02381 0 2.5 Mabsadd L
.26339 .02381 1.875 0 Mabsadd L
.26339 .02381 0 -2.5 Mabsadd L
.26339 .02381 -1.875 0 Mabsadd L closepath F
.26488 .02381 -1.875 0 Mabsadd m
.26488 .02381 0 2.5 Mabsadd L
.26488 .02381 1.875 0 Mabsadd L
.26488 .02381 0 -2.5 Mabsadd L
.26488 .02381 -1.875 0 Mabsadd L closepath F
.26637 .02381 -1.875 0 Mabsadd m
.26637 .02381 0 2.5 Mabsadd L
.26637 .02381 1.875 0 Mabsadd L
.26637 .02381 0 -2.5 Mabsadd L
.26637 .02381 -1.875 0 Mabsadd L closepath F
.26786 .02381 -1.875 0 Mabsadd m
.26786 .02381 0 2.5 Mabsadd L
.26786 .02381 1.875 0 Mabsadd L
.26786 .02381 0 -2.5 Mabsadd L
.26786 .02381 -1.875 0 Mabsadd L closepath F
.26935 .02381 -1.875 0 Mabsadd m
.26935 .02381 0 2.5 Mabsadd L
.26935 .02381 1.875 0 Mabsadd L
.26935 .02381 0 -2.5 Mabsadd L
.26935 .02381 -1.875 0 Mabsadd L closepath F
.27083 .02381 -1.875 0 Mabsadd m
.27083 .02381 0 2.5 Mabsadd L
.27083 .02381 1.875 0 Mabsadd L
.27083 .02381 0 -2.5 Mabsadd L
.27083 .02381 -1.875 0 Mabsadd L closepath F
.27232 .02381 -1.875 0 Mabsadd m
.27232 .02381 0 2.5 Mabsadd L
.27232 .02381 1.875 0 Mabsadd L
.27232 .02381 0 -2.5 Mabsadd L
.27232 .02381 -1.875 0 Mabsadd L closepath F
.27381 .02381 -1.875 0 Mabsadd m
.27381 .02381 0 2.5 Mabsadd L
.27381 .02381 1.875 0 Mabsadd L
.27381 .02381 0 -2.5 Mabsadd L
.27381 .02381 -1.875 0 Mabsadd L closepath F
.2753 .02381 -1.875 0 Mabsadd m
.2753 .02381 0 2.5 Mabsadd L
.2753 .02381 1.875 0 Mabsadd L
.2753 .02381 0 -2.5 Mabsadd L
.2753 .02381 -1.875 0 Mabsadd L closepath F
.27679 .02381 -1.875 0 Mabsadd m
.27679 .02381 0 2.5 Mabsadd L
.27679 .02381 1.875 0 Mabsadd L
.27679 .02381 0 -2.5 Mabsadd L
.27679 .02381 -1.875 0 Mabsadd L closepath F
.27827 .02381 -1.875 0 Mabsadd m
.27827 .02381 0 2.5 Mabsadd L
.27827 .02381 1.875 0 Mabsadd L
.27827 .02381 0 -2.5 Mabsadd L
.27827 .02381 -1.875 0 Mabsadd L closepath F
.27976 .02381 -1.875 0 Mabsadd m
.27976 .02381 0 2.5 Mabsadd L
.27976 .02381 1.875 0 Mabsadd L
.27976 .02381 0 -2.5 Mabsadd L
.27976 .02381 -1.875 0 Mabsadd L closepath F
.28125 .02381 -1.875 0 Mabsadd m
.28125 .02381 0 2.5 Mabsadd L
.28125 .02381 1.875 0 Mabsadd L
.28125 .02381 0 -2.5 Mabsadd L
.28125 .02381 -1.875 0 Mabsadd L closepath F
.28274 .02381 -1.875 0 Mabsadd m
.28274 .02381 0 2.5 Mabsadd L
.28274 .02381 1.875 0 Mabsadd L
.28274 .02381 0 -2.5 Mabsadd L
.28274 .02381 -1.875 0 Mabsadd L closepath F
.28423 .02381 -1.875 0 Mabsadd m
.28423 .02381 0 2.5 Mabsadd L
.28423 .02381 1.875 0 Mabsadd L
.28423 .02381 0 -2.5 Mabsadd L
.28423 .02381 -1.875 0 Mabsadd L closepath F
.28571 .02381 -1.875 0 Mabsadd m
.28571 .02381 0 2.5 Mabsadd L
.28571 .02381 1.875 0 Mabsadd L
.28571 .02381 0 -2.5 Mabsadd L
.28571 .02381 -1.875 0 Mabsadd L closepath F
.2872 .02381 -1.875 0 Mabsadd m
.2872 .02381 0 2.5 Mabsadd L
.2872 .02381 1.875 0 Mabsadd L
.2872 .02381 0 -2.5 Mabsadd L
.2872 .02381 -1.875 0 Mabsadd L closepath F
.28869 .02381 -1.875 0 Mabsadd m
.28869 .02381 0 2.5 Mabsadd L
.28869 .02381 1.875 0 Mabsadd L
.28869 .02381 0 -2.5 Mabsadd L
.28869 .02381 -1.875 0 Mabsadd L closepath F
.29018 .02381 -1.875 0 Mabsadd m
.29018 .02381 0 2.5 Mabsadd L
.29018 .02381 1.875 0 Mabsadd L
.29018 .02381 0 -2.5 Mabsadd L
.29018 .02381 -1.875 0 Mabsadd L closepath F
.29167 .02381 -1.875 0 Mabsadd m
.29167 .02381 0 2.5 Mabsadd L
.29167 .02381 1.875 0 Mabsadd L
.29167 .02381 0 -2.5 Mabsadd L
.29167 .02381 -1.875 0 Mabsadd L closepath F
.29315 .02381 -1.875 0 Mabsadd m
.29315 .02381 0 2.5 Mabsadd L
.29315 .02381 1.875 0 Mabsadd L
.29315 .02381 0 -2.5 Mabsadd L
.29315 .02381 -1.875 0 Mabsadd L closepath F
.29464 .02381 -1.875 0 Mabsadd m
.29464 .02381 0 2.5 Mabsadd L
.29464 .02381 1.875 0 Mabsadd L
.29464 .02381 0 -2.5 Mabsadd L
.29464 .02381 -1.875 0 Mabsadd L closepath F
.29613 .02381 -1.875 0 Mabsadd m
.29613 .02381 0 2.5 Mabsadd L
.29613 .02381 1.875 0 Mabsadd L
.29613 .02381 0 -2.5 Mabsadd L
.29613 .02381 -1.875 0 Mabsadd L closepath F
.29762 .02381 -1.875 0 Mabsadd m
.29762 .02381 0 2.5 Mabsadd L
.29762 .02381 1.875 0 Mabsadd L
.29762 .02381 0 -2.5 Mabsadd L
.29762 .02381 -1.875 0 Mabsadd L closepath F
.29911 .02381 -1.875 0 Mabsadd m
.29911 .02381 0 2.5 Mabsadd L
.29911 .02381 1.875 0 Mabsadd L
.29911 .02381 0 -2.5 Mabsadd L
.29911 .02381 -1.875 0 Mabsadd L closepath F
.3006 .02381 -1.875 0 Mabsadd m
.3006 .02381 0 2.5 Mabsadd L
.3006 .02381 1.875 0 Mabsadd L
.3006 .02381 0 -2.5 Mabsadd L
.3006 .02381 -1.875 0 Mabsadd L closepath F
.30208 .02381 -1.875 0 Mabsadd m
.30208 .02381 0 2.5 Mabsadd L
.30208 .02381 1.875 0 Mabsadd L
.30208 .02381 0 -2.5 Mabsadd L
.30208 .02381 -1.875 0 Mabsadd L closepath F
.30357 .02381 -1.875 0 Mabsadd m
.30357 .02381 0 2.5 Mabsadd L
.30357 .02381 1.875 0 Mabsadd L
.30357 .02381 0 -2.5 Mabsadd L
.30357 .02381 -1.875 0 Mabsadd L closepath F
.30506 .02381 -1.875 0 Mabsadd m
.30506 .02381 0 2.5 Mabsadd L
.30506 .02381 1.875 0 Mabsadd L
.30506 .02381 0 -2.5 Mabsadd L
.30506 .02381 -1.875 0 Mabsadd L closepath F
.30655 .02381 -1.875 0 Mabsadd m
.30655 .02381 0 2.5 Mabsadd L
.30655 .02381 1.875 0 Mabsadd L
.30655 .02381 0 -2.5 Mabsadd L
.30655 .02381 -1.875 0 Mabsadd L closepath F
.30804 .02381 -1.875 0 Mabsadd m
.30804 .02381 0 2.5 Mabsadd L
.30804 .02381 1.875 0 Mabsadd L
.30804 .02381 0 -2.5 Mabsadd L
.30804 .02381 -1.875 0 Mabsadd L closepath F
.30952 .02381 -1.875 0 Mabsadd m
.30952 .02381 0 2.5 Mabsadd L
.30952 .02381 1.875 0 Mabsadd L
.30952 .02381 0 -2.5 Mabsadd L
.30952 .02381 -1.875 0 Mabsadd L closepath F
.31101 .02381 -1.875 0 Mabsadd m
.31101 .02381 0 2.5 Mabsadd L
.31101 .02381 1.875 0 Mabsadd L
.31101 .02381 0 -2.5 Mabsadd L
.31101 .02381 -1.875 0 Mabsadd L closepath F
.3125 .02381 -1.875 0 Mabsadd m
.3125 .02381 0 2.5 Mabsadd L
.3125 .02381 1.875 0 Mabsadd L
.3125 .02381 0 -2.5 Mabsadd L
.3125 .02381 -1.875 0 Mabsadd L closepath F
.31399 .02381 -1.875 0 Mabsadd m
.31399 .02381 0 2.5 Mabsadd L
.31399 .02381 1.875 0 Mabsadd L
.31399 .02381 0 -2.5 Mabsadd L
.31399 .02381 -1.875 0 Mabsadd L closepath F
.31548 .02381 -1.875 0 Mabsadd m
.31548 .02381 0 2.5 Mabsadd L
.31548 .02381 1.875 0 Mabsadd L
.31548 .02381 0 -2.5 Mabsadd L
.31548 .02381 -1.875 0 Mabsadd L closepath F
.31696 .02381 -1.875 0 Mabsadd m
.31696 .02381 0 2.5 Mabsadd L
.31696 .02381 1.875 0 Mabsadd L
.31696 .02381 0 -2.5 Mabsadd L
.31696 .02381 -1.875 0 Mabsadd L closepath F
.31845 .02381 -1.875 0 Mabsadd m
.31845 .02381 0 2.5 Mabsadd L
.31845 .02381 1.875 0 Mabsadd L
.31845 .02381 0 -2.5 Mabsadd L
.31845 .02381 -1.875 0 Mabsadd L closepath F
.31994 .02381 -1.875 0 Mabsadd m
.31994 .02381 0 2.5 Mabsadd L
.31994 .02381 1.875 0 Mabsadd L
.31994 .02381 0 -2.5 Mabsadd L
.31994 .02381 -1.875 0 Mabsadd L closepath F
.32143 .02381 -1.875 0 Mabsadd m
.32143 .02381 0 2.5 Mabsadd L
.32143 .02381 1.875 0 Mabsadd L
.32143 .02381 0 -2.5 Mabsadd L
.32143 .02381 -1.875 0 Mabsadd L closepath F
.32292 .02381 -1.875 0 Mabsadd m
.32292 .02381 0 2.5 Mabsadd L
.32292 .02381 1.875 0 Mabsadd L
.32292 .02381 0 -2.5 Mabsadd L
.32292 .02381 -1.875 0 Mabsadd L closepath F
.3244 .02381 -1.875 0 Mabsadd m
.3244 .02381 0 2.5 Mabsadd L
.3244 .02381 1.875 0 Mabsadd L
.3244 .02381 0 -2.5 Mabsadd L
.3244 .02381 -1.875 0 Mabsadd L closepath F
.32589 .02381 -1.875 0 Mabsadd m
.32589 .02381 0 2.5 Mabsadd L
.32589 .02381 1.875 0 Mabsadd L
.32589 .02381 0 -2.5 Mabsadd L
.32589 .02381 -1.875 0 Mabsadd L closepath F
.32738 .02381 -1.875 0 Mabsadd m
.32738 .02381 0 2.5 Mabsadd L
.32738 .02381 1.875 0 Mabsadd L
.32738 .02381 0 -2.5 Mabsadd L
.32738 .02381 -1.875 0 Mabsadd L closepath F
.32887 .02381 -1.875 0 Mabsadd m
.32887 .02381 0 2.5 Mabsadd L
.32887 .02381 1.875 0 Mabsadd L
.32887 .02381 0 -2.5 Mabsadd L
.32887 .02381 -1.875 0 Mabsadd L closepath F
.33036 .02381 -1.875 0 Mabsadd m
.33036 .02381 0 2.5 Mabsadd L
.33036 .02381 1.875 0 Mabsadd L
.33036 .02381 0 -2.5 Mabsadd L
.33036 .02381 -1.875 0 Mabsadd L closepath F
.33185 .02381 -1.875 0 Mabsadd m
.33185 .02381 0 2.5 Mabsadd L
.33185 .02381 1.875 0 Mabsadd L
.33185 .02381 0 -2.5 Mabsadd L
.33185 .02381 -1.875 0 Mabsadd L closepath F
.33333 .02381 -1.875 0 Mabsadd m
.33333 .02381 0 2.5 Mabsadd L
.33333 .02381 1.875 0 Mabsadd L
.33333 .02381 0 -2.5 Mabsadd L
.33333 .02381 -1.875 0 Mabsadd L closepath F
.33482 .02381 -1.875 0 Mabsadd m
.33482 .02381 0 2.5 Mabsadd L
.33482 .02381 1.875 0 Mabsadd L
.33482 .02381 0 -2.5 Mabsadd L
.33482 .02381 -1.875 0 Mabsadd L closepath F
.33631 .02381 -1.875 0 Mabsadd m
.33631 .02381 0 2.5 Mabsadd L
.33631 .02381 1.875 0 Mabsadd L
.33631 .02381 0 -2.5 Mabsadd L
.33631 .02381 -1.875 0 Mabsadd L closepath F
.3378 .02381 -1.875 0 Mabsadd m
.3378 .02381 0 2.5 Mabsadd L
.3378 .02381 1.875 0 Mabsadd L
.3378 .02381 0 -2.5 Mabsadd L
.3378 .02381 -1.875 0 Mabsadd L closepath F
.33929 .02381 -1.875 0 Mabsadd m
.33929 .02381 0 2.5 Mabsadd L
.33929 .02381 1.875 0 Mabsadd L
.33929 .02381 0 -2.5 Mabsadd L
.33929 .02381 -1.875 0 Mabsadd L closepath F
.34077 .02381 -1.875 0 Mabsadd m
.34077 .02381 0 2.5 Mabsadd L
.34077 .02381 1.875 0 Mabsadd L
.34077 .02381 0 -2.5 Mabsadd L
.34077 .02381 -1.875 0 Mabsadd L closepath F
.34226 .02381 -1.875 0 Mabsadd m
.34226 .02381 0 2.5 Mabsadd L
.34226 .02381 1.875 0 Mabsadd L
.34226 .02381 0 -2.5 Mabsadd L
.34226 .02381 -1.875 0 Mabsadd L closepath F
.34375 .02381 -1.875 0 Mabsadd m
.34375 .02381 0 2.5 Mabsadd L
.34375 .02381 1.875 0 Mabsadd L
.34375 .02381 0 -2.5 Mabsadd L
.34375 .02381 -1.875 0 Mabsadd L closepath F
.34524 .02381 -1.875 0 Mabsadd m
.34524 .02381 0 2.5 Mabsadd L
.34524 .02381 1.875 0 Mabsadd L
.34524 .02381 0 -2.5 Mabsadd L
.34524 .02381 -1.875 0 Mabsadd L closepath F
.34673 .02381 -1.875 0 Mabsadd m
.34673 .02381 0 2.5 Mabsadd L
.34673 .02381 1.875 0 Mabsadd L
.34673 .02381 0 -2.5 Mabsadd L
.34673 .02381 -1.875 0 Mabsadd L closepath F
.34821 .02381 -1.875 0 Mabsadd m
.34821 .02381 0 2.5 Mabsadd L
.34821 .02381 1.875 0 Mabsadd L
.34821 .02381 0 -2.5 Mabsadd L
.34821 .02381 -1.875 0 Mabsadd L closepath F
.3497 .02381 -1.875 0 Mabsadd m
.3497 .02381 0 2.5 Mabsadd L
.3497 .02381 1.875 0 Mabsadd L
.3497 .02381 0 -2.5 Mabsadd L
.3497 .02381 -1.875 0 Mabsadd L closepath F
.35119 .02381 -1.875 0 Mabsadd m
.35119 .02381 0 2.5 Mabsadd L
.35119 .02381 1.875 0 Mabsadd L
.35119 .02381 0 -2.5 Mabsadd L
.35119 .02381 -1.875 0 Mabsadd L closepath F
.35268 .02381 -1.875 0 Mabsadd m
.35268 .02381 0 2.5 Mabsadd L
.35268 .02381 1.875 0 Mabsadd L
.35268 .02381 0 -2.5 Mabsadd L
.35268 .02381 -1.875 0 Mabsadd L closepath F
.35417 .02381 -1.875 0 Mabsadd m
.35417 .02381 0 2.5 Mabsadd L
.35417 .02381 1.875 0 Mabsadd L
.35417 .02381 0 -2.5 Mabsadd L
.35417 .02381 -1.875 0 Mabsadd L closepath F
.35565 .02381 -1.875 0 Mabsadd m
.35565 .02381 0 2.5 Mabsadd L
.35565 .02381 1.875 0 Mabsadd L
.35565 .02381 0 -2.5 Mabsadd L
.35565 .02381 -1.875 0 Mabsadd L closepath F
.35714 .02381 -1.875 0 Mabsadd m
.35714 .02381 0 2.5 Mabsadd L
.35714 .02381 1.875 0 Mabsadd L
.35714 .02381 0 -2.5 Mabsadd L
.35714 .02381 -1.875 0 Mabsadd L closepath F
.35863 .02381 -1.875 0 Mabsadd m
.35863 .02381 0 2.5 Mabsadd L
.35863 .02381 1.875 0 Mabsadd L
.35863 .02381 0 -2.5 Mabsadd L
.35863 .02381 -1.875 0 Mabsadd L closepath F
.36012 .02381 -1.875 0 Mabsadd m
.36012 .02381 0 2.5 Mabsadd L
.36012 .02381 1.875 0 Mabsadd L
.36012 .02381 0 -2.5 Mabsadd L
.36012 .02381 -1.875 0 Mabsadd L closepath F
.36161 .02381 -1.875 0 Mabsadd m
.36161 .02381 0 2.5 Mabsadd L
.36161 .02381 1.875 0 Mabsadd L
.36161 .02381 0 -2.5 Mabsadd L
.36161 .02381 -1.875 0 Mabsadd L closepath F
.3631 .02381 -1.875 0 Mabsadd m
.3631 .02381 0 2.5 Mabsadd L
.3631 .02381 1.875 0 Mabsadd L
.3631 .02381 0 -2.5 Mabsadd L
.3631 .02381 -1.875 0 Mabsadd L closepath F
.36458 .02381 -1.875 0 Mabsadd m
.36458 .02381 0 2.5 Mabsadd L
.36458 .02381 1.875 0 Mabsadd L
.36458 .02381 0 -2.5 Mabsadd L
.36458 .02381 -1.875 0 Mabsadd L closepath F
.36607 .02381 -1.875 0 Mabsadd m
.36607 .02381 0 2.5 Mabsadd L
.36607 .02381 1.875 0 Mabsadd L
.36607 .02381 0 -2.5 Mabsadd L
.36607 .02381 -1.875 0 Mabsadd L closepath F
.36756 .02381 -1.875 0 Mabsadd m
.36756 .02381 0 2.5 Mabsadd L
.36756 .02381 1.875 0 Mabsadd L
.36756 .02381 0 -2.5 Mabsadd L
.36756 .02381 -1.875 0 Mabsadd L closepath F
.36905 .02381 -1.875 0 Mabsadd m
.36905 .02381 0 2.5 Mabsadd L
.36905 .02381 1.875 0 Mabsadd L
.36905 .02381 0 -2.5 Mabsadd L
.36905 .02381 -1.875 0 Mabsadd L closepath F
.37054 .02381 -1.875 0 Mabsadd m
.37054 .02381 0 2.5 Mabsadd L
.37054 .02381 1.875 0 Mabsadd L
.37054 .02381 0 -2.5 Mabsadd L
.37054 .02381 -1.875 0 Mabsadd L closepath F
.37202 .02381 -1.875 0 Mabsadd m
.37202 .02381 0 2.5 Mabsadd L
.37202 .02381 1.875 0 Mabsadd L
.37202 .02381 0 -2.5 Mabsadd L
.37202 .02381 -1.875 0 Mabsadd L closepath F
.37351 .02381 -1.875 0 Mabsadd m
.37351 .02381 0 2.5 Mabsadd L
.37351 .02381 1.875 0 Mabsadd L
.37351 .02381 0 -2.5 Mabsadd L
.37351 .02381 -1.875 0 Mabsadd L closepath F
.375 .02381 -1.875 0 Mabsadd m
.375 .02381 0 2.5 Mabsadd L
.375 .02381 1.875 0 Mabsadd L
.375 .02381 0 -2.5 Mabsadd L
.375 .02381 -1.875 0 Mabsadd L closepath F
.37649 .02381 -1.875 0 Mabsadd m
.37649 .02381 0 2.5 Mabsadd L
.37649 .02381 1.875 0 Mabsadd L
.37649 .02381 0 -2.5 Mabsadd L
.37649 .02381 -1.875 0 Mabsadd L closepath F
.37798 .02381 -1.875 0 Mabsadd m
.37798 .02381 0 2.5 Mabsadd L
.37798 .02381 1.875 0 Mabsadd L
.37798 .02381 0 -2.5 Mabsadd L
.37798 .02381 -1.875 0 Mabsadd L closepath F
.37946 .02381 -1.875 0 Mabsadd m
.37946 .02381 0 2.5 Mabsadd L
.37946 .02381 1.875 0 Mabsadd L
.37946 .02381 0 -2.5 Mabsadd L
.37946 .02381 -1.875 0 Mabsadd L closepath F
.38095 .02381 -1.875 0 Mabsadd m
.38095 .02381 0 2.5 Mabsadd L
.38095 .02381 1.875 0 Mabsadd L
.38095 .02381 0 -2.5 Mabsadd L
.38095 .02381 -1.875 0 Mabsadd L closepath F
.38244 .02381 -1.875 0 Mabsadd m
.38244 .02381 0 2.5 Mabsadd L
.38244 .02381 1.875 0 Mabsadd L
.38244 .02381 0 -2.5 Mabsadd L
.38244 .02381 -1.875 0 Mabsadd L closepath F
.38393 .02381 -1.875 0 Mabsadd m
.38393 .02381 0 2.5 Mabsadd L
.38393 .02381 1.875 0 Mabsadd L
.38393 .02381 0 -2.5 Mabsadd L
.38393 .02381 -1.875 0 Mabsadd L closepath F
.38542 .02381 -1.875 0 Mabsadd m
.38542 .02381 0 2.5 Mabsadd L
.38542 .02381 1.875 0 Mabsadd L
.38542 .02381 0 -2.5 Mabsadd L
.38542 .02381 -1.875 0 Mabsadd L closepath F
.3869 .02381 -1.875 0 Mabsadd m
.3869 .02381 0 2.5 Mabsadd L
.3869 .02381 1.875 0 Mabsadd L
.3869 .02381 0 -2.5 Mabsadd L
.3869 .02381 -1.875 0 Mabsadd L closepath F
.38839 .02381 -1.875 0 Mabsadd m
.38839 .02381 0 2.5 Mabsadd L
.38839 .02381 1.875 0 Mabsadd L
.38839 .02381 0 -2.5 Mabsadd L
.38839 .02381 -1.875 0 Mabsadd L closepath F
.38988 .02381 -1.875 0 Mabsadd m
.38988 .02381 0 2.5 Mabsadd L
.38988 .02381 1.875 0 Mabsadd L
.38988 .02381 0 -2.5 Mabsadd L
.38988 .02381 -1.875 0 Mabsadd L closepath F
.39137 .02381 -1.875 0 Mabsadd m
.39137 .02381 0 2.5 Mabsadd L
.39137 .02381 1.875 0 Mabsadd L
.39137 .02381 0 -2.5 Mabsadd L
.39137 .02381 -1.875 0 Mabsadd L closepath F
.39286 .02381 -1.875 0 Mabsadd m
.39286 .02381 0 2.5 Mabsadd L
.39286 .02381 1.875 0 Mabsadd L
.39286 .02381 0 -2.5 Mabsadd L
.39286 .02381 -1.875 0 Mabsadd L closepath F
.39435 .02381 -1.875 0 Mabsadd m
.39435 .02381 0 2.5 Mabsadd L
.39435 .02381 1.875 0 Mabsadd L
.39435 .02381 0 -2.5 Mabsadd L
.39435 .02381 -1.875 0 Mabsadd L closepath F
.39583 .02381 -1.875 0 Mabsadd m
.39583 .02381 0 2.5 Mabsadd L
.39583 .02381 1.875 0 Mabsadd L
.39583 .02381 0 -2.5 Mabsadd L
.39583 .02381 -1.875 0 Mabsadd L closepath F
.39732 .02381 -1.875 0 Mabsadd m
.39732 .02381 0 2.5 Mabsadd L
.39732 .02381 1.875 0 Mabsadd L
.39732 .02381 0 -2.5 Mabsadd L
.39732 .02381 -1.875 0 Mabsadd L closepath F
.39881 .02381 -1.875 0 Mabsadd m
.39881 .02381 0 2.5 Mabsadd L
.39881 .02381 1.875 0 Mabsadd L
.39881 .02381 0 -2.5 Mabsadd L
.39881 .02381 -1.875 0 Mabsadd L closepath F
.4003 .02381 -1.875 0 Mabsadd m
.4003 .02381 0 2.5 Mabsadd L
.4003 .02381 1.875 0 Mabsadd L
.4003 .02381 0 -2.5 Mabsadd L
.4003 .02381 -1.875 0 Mabsadd L closepath F
.40179 .02381 -1.875 0 Mabsadd m
.40179 .02381 0 2.5 Mabsadd L
.40179 .02381 1.875 0 Mabsadd L
.40179 .02381 0 -2.5 Mabsadd L
.40179 .02381 -1.875 0 Mabsadd L closepath F
.40327 .02381 -1.875 0 Mabsadd m
.40327 .02381 0 2.5 Mabsadd L
.40327 .02381 1.875 0 Mabsadd L
.40327 .02381 0 -2.5 Mabsadd L
.40327 .02381 -1.875 0 Mabsadd L closepath F
.40476 .02381 -1.875 0 Mabsadd m
.40476 .02381 0 2.5 Mabsadd L
.40476 .02381 1.875 0 Mabsadd L
.40476 .02381 0 -2.5 Mabsadd L
.40476 .02381 -1.875 0 Mabsadd L closepath F
.40625 .02381 -1.875 0 Mabsadd m
.40625 .02381 0 2.5 Mabsadd L
.40625 .02381 1.875 0 Mabsadd L
.40625 .02381 0 -2.5 Mabsadd L
.40625 .02381 -1.875 0 Mabsadd L closepath F
.40774 .02381 -1.875 0 Mabsadd m
.40774 .02381 0 2.5 Mabsadd L
.40774 .02381 1.875 0 Mabsadd L
.40774 .02381 0 -2.5 Mabsadd L
.40774 .02381 -1.875 0 Mabsadd L closepath F
.40923 .02381 -1.875 0 Mabsadd m
.40923 .02381 0 2.5 Mabsadd L
.40923 .02381 1.875 0 Mabsadd L
.40923 .02381 0 -2.5 Mabsadd L
.40923 .02381 -1.875 0 Mabsadd L closepath F
.41071 .02381 -1.875 0 Mabsadd m
.41071 .02381 0 2.5 Mabsadd L
.41071 .02381 1.875 0 Mabsadd L
.41071 .02381 0 -2.5 Mabsadd L
.41071 .02381 -1.875 0 Mabsadd L closepath F
.4122 .02381 -1.875 0 Mabsadd m
.4122 .02381 0 2.5 Mabsadd L
.4122 .02381 1.875 0 Mabsadd L
.4122 .02381 0 -2.5 Mabsadd L
.4122 .02381 -1.875 0 Mabsadd L closepath F
.41369 .02381 -1.875 0 Mabsadd m
.41369 .02381 0 2.5 Mabsadd L
.41369 .02381 1.875 0 Mabsadd L
.41369 .02381 0 -2.5 Mabsadd L
.41369 .02381 -1.875 0 Mabsadd L closepath F
.41518 .02381 -1.875 0 Mabsadd m
.41518 .02381 0 2.5 Mabsadd L
.41518 .02381 1.875 0 Mabsadd L
.41518 .02381 0 -2.5 Mabsadd L
.41518 .02381 -1.875 0 Mabsadd L closepath F
.41667 .02381 -1.875 0 Mabsadd m
.41667 .02381 0 2.5 Mabsadd L
.41667 .02381 1.875 0 Mabsadd L
.41667 .02381 0 -2.5 Mabsadd L
.41667 .02381 -1.875 0 Mabsadd L closepath F
.41815 .02381 -1.875 0 Mabsadd m
.41815 .02381 0 2.5 Mabsadd L
.41815 .02381 1.875 0 Mabsadd L
.41815 .02381 0 -2.5 Mabsadd L
.41815 .02381 -1.875 0 Mabsadd L closepath F
.41964 .02381 -1.875 0 Mabsadd m
.41964 .02381 0 2.5 Mabsadd L
.41964 .02381 1.875 0 Mabsadd L
.41964 .02381 0 -2.5 Mabsadd L
.41964 .02381 -1.875 0 Mabsadd L closepath F
.42113 .02381 -1.875 0 Mabsadd m
.42113 .02381 0 2.5 Mabsadd L
.42113 .02381 1.875 0 Mabsadd L
.42113 .02381 0 -2.5 Mabsadd L
.42113 .02381 -1.875 0 Mabsadd L closepath F
.42262 .02381 -1.875 0 Mabsadd m
.42262 .02381 0 2.5 Mabsadd L
.42262 .02381 1.875 0 Mabsadd L
.42262 .02381 0 -2.5 Mabsadd L
.42262 .02381 -1.875 0 Mabsadd L closepath F
.42411 .02381 -1.875 0 Mabsadd m
.42411 .02381 0 2.5 Mabsadd L
.42411 .02381 1.875 0 Mabsadd L
.42411 .02381 0 -2.5 Mabsadd L
.42411 .02381 -1.875 0 Mabsadd L closepath F
.4256 .02381 -1.875 0 Mabsadd m
.4256 .02381 0 2.5 Mabsadd L
.4256 .02381 1.875 0 Mabsadd L
.4256 .02381 0 -2.5 Mabsadd L
.4256 .02381 -1.875 0 Mabsadd L closepath F
.42708 .02381 -1.875 0 Mabsadd m
.42708 .02381 0 2.5 Mabsadd L
.42708 .02381 1.875 0 Mabsadd L
.42708 .02381 0 -2.5 Mabsadd L
.42708 .02381 -1.875 0 Mabsadd L closepath F
.42857 .02381 -1.875 0 Mabsadd m
.42857 .02381 0 2.5 Mabsadd L
.42857 .02381 1.875 0 Mabsadd L
.42857 .02381 0 -2.5 Mabsadd L
.42857 .02381 -1.875 0 Mabsadd L closepath F
.43006 .02381 -1.875 0 Mabsadd m
.43006 .02381 0 2.5 Mabsadd L
.43006 .02381 1.875 0 Mabsadd L
.43006 .02381 0 -2.5 Mabsadd L
.43006 .02381 -1.875 0 Mabsadd L closepath F
.43155 .02381 -1.875 0 Mabsadd m
.43155 .02381 0 2.5 Mabsadd L
.43155 .02381 1.875 0 Mabsadd L
.43155 .02381 0 -2.5 Mabsadd L
.43155 .02381 -1.875 0 Mabsadd L closepath F
.43304 .02381 -1.875 0 Mabsadd m
.43304 .02381 0 2.5 Mabsadd L
.43304 .02381 1.875 0 Mabsadd L
.43304 .02381 0 -2.5 Mabsadd L
.43304 .02381 -1.875 0 Mabsadd L closepath F
.43452 .02381 -1.875 0 Mabsadd m
.43452 .02381 0 2.5 Mabsadd L
.43452 .02381 1.875 0 Mabsadd L
.43452 .02381 0 -2.5 Mabsadd L
.43452 .02381 -1.875 0 Mabsadd L closepath F
.43601 .02381 -1.875 0 Mabsadd m
.43601 .02381 0 2.5 Mabsadd L
.43601 .02381 1.875 0 Mabsadd L
.43601 .02381 0 -2.5 Mabsadd L
.43601 .02381 -1.875 0 Mabsadd L closepath F
.4375 .02381 -1.875 0 Mabsadd m
.4375 .02381 0 2.5 Mabsadd L
.4375 .02381 1.875 0 Mabsadd L
.4375 .02381 0 -2.5 Mabsadd L
.4375 .02381 -1.875 0 Mabsadd L closepath F
.43899 .02381 -1.875 0 Mabsadd m
.43899 .02381 0 2.5 Mabsadd L
.43899 .02381 1.875 0 Mabsadd L
.43899 .02381 0 -2.5 Mabsadd L
.43899 .02381 -1.875 0 Mabsadd L closepath F
.44048 .02381 -1.875 0 Mabsadd m
.44048 .02381 0 2.5 Mabsadd L
.44048 .02381 1.875 0 Mabsadd L
.44048 .02381 0 -2.5 Mabsadd L
.44048 .02381 -1.875 0 Mabsadd L closepath F
.44196 .02381 -1.875 0 Mabsadd m
.44196 .02381 0 2.5 Mabsadd L
.44196 .02381 1.875 0 Mabsadd L
.44196 .02381 0 -2.5 Mabsadd L
.44196 .02381 -1.875 0 Mabsadd L closepath F
.44345 .02381 -1.875 0 Mabsadd m
.44345 .02381 0 2.5 Mabsadd L
.44345 .02381 1.875 0 Mabsadd L
.44345 .02381 0 -2.5 Mabsadd L
.44345 .02381 -1.875 0 Mabsadd L closepath F
.44494 .02381 -1.875 0 Mabsadd m
.44494 .02381 0 2.5 Mabsadd L
.44494 .02381 1.875 0 Mabsadd L
.44494 .02381 0 -2.5 Mabsadd L
.44494 .02381 -1.875 0 Mabsadd L closepath F
.44643 .02381 -1.875 0 Mabsadd m
.44643 .02381 0 2.5 Mabsadd L
.44643 .02381 1.875 0 Mabsadd L
.44643 .02381 0 -2.5 Mabsadd L
.44643 .02381 -1.875 0 Mabsadd L closepath F
.44792 .02381 -1.875 0 Mabsadd m
.44792 .02381 0 2.5 Mabsadd L
.44792 .02381 1.875 0 Mabsadd L
.44792 .02381 0 -2.5 Mabsadd L
.44792 .02381 -1.875 0 Mabsadd L closepath F
.4494 .02381 -1.875 0 Mabsadd m
.4494 .02381 0 2.5 Mabsadd L
.4494 .02381 1.875 0 Mabsadd L
.4494 .02381 0 -2.5 Mabsadd L
.4494 .02381 -1.875 0 Mabsadd L closepath F
.45089 .02381 -1.875 0 Mabsadd m
.45089 .02381 0 2.5 Mabsadd L
.45089 .02381 1.875 0 Mabsadd L
.45089 .02381 0 -2.5 Mabsadd L
.45089 .02381 -1.875 0 Mabsadd L closepath F
.45238 .02381 -1.875 0 Mabsadd m
.45238 .02381 0 2.5 Mabsadd L
.45238 .02381 1.875 0 Mabsadd L
.45238 .02381 0 -2.5 Mabsadd L
.45238 .02381 -1.875 0 Mabsadd L closepath F
.45387 .02381 -1.875 0 Mabsadd m
.45387 .02381 0 2.5 Mabsadd L
.45387 .02381 1.875 0 Mabsadd L
.45387 .02381 0 -2.5 Mabsadd L
.45387 .02381 -1.875 0 Mabsadd L closepath F
.45536 .02381 -1.875 0 Mabsadd m
.45536 .02381 0 2.5 Mabsadd L
.45536 .02381 1.875 0 Mabsadd L
.45536 .02381 0 -2.5 Mabsadd L
.45536 .02381 -1.875 0 Mabsadd L closepath F
.45685 .02381 -1.875 0 Mabsadd m
.45685 .02381 0 2.5 Mabsadd L
.45685 .02381 1.875 0 Mabsadd L
.45685 .02381 0 -2.5 Mabsadd L
.45685 .02381 -1.875 0 Mabsadd L closepath F
.45833 .02381 -1.875 0 Mabsadd m
.45833 .02381 0 2.5 Mabsadd L
.45833 .02381 1.875 0 Mabsadd L
.45833 .02381 0 -2.5 Mabsadd L
.45833 .02381 -1.875 0 Mabsadd L closepath F
.45982 .02381 -1.875 0 Mabsadd m
.45982 .02381 0 2.5 Mabsadd L
.45982 .02381 1.875 0 Mabsadd L
.45982 .02381 0 -2.5 Mabsadd L
.45982 .02381 -1.875 0 Mabsadd L closepath F
.46131 .02381 -1.875 0 Mabsadd m
.46131 .02381 0 2.5 Mabsadd L
.46131 .02381 1.875 0 Mabsadd L
.46131 .02381 0 -2.5 Mabsadd L
.46131 .02381 -1.875 0 Mabsadd L closepath F
.4628 .02381 -1.875 0 Mabsadd m
.4628 .02381 0 2.5 Mabsadd L
.4628 .02381 1.875 0 Mabsadd L
.4628 .02381 0 -2.5 Mabsadd L
.4628 .02381 -1.875 0 Mabsadd L closepath F
.46429 .02381 -1.875 0 Mabsadd m
.46429 .02381 0 2.5 Mabsadd L
.46429 .02381 1.875 0 Mabsadd L
.46429 .02381 0 -2.5 Mabsadd L
.46429 .02381 -1.875 0 Mabsadd L closepath F
.46577 .02381 -1.875 0 Mabsadd m
.46577 .02381 0 2.5 Mabsadd L
.46577 .02381 1.875 0 Mabsadd L
.46577 .02381 0 -2.5 Mabsadd L
.46577 .02381 -1.875 0 Mabsadd L closepath F
.46726 .02381 -1.875 0 Mabsadd m
.46726 .02381 0 2.5 Mabsadd L
.46726 .02381 1.875 0 Mabsadd L
.46726 .02381 0 -2.5 Mabsadd L
.46726 .02381 -1.875 0 Mabsadd L closepath F
.46875 .02381 -1.875 0 Mabsadd m
.46875 .02381 0 2.5 Mabsadd L
.46875 .02381 1.875 0 Mabsadd L
.46875 .02381 0 -2.5 Mabsadd L
.46875 .02381 -1.875 0 Mabsadd L closepath F
.47024 .02381 -1.875 0 Mabsadd m
.47024 .02381 0 2.5 Mabsadd L
.47024 .02381 1.875 0 Mabsadd L
.47024 .02381 0 -2.5 Mabsadd L
.47024 .02381 -1.875 0 Mabsadd L closepath F
.47173 .02381 -1.875 0 Mabsadd m
.47173 .02381 0 2.5 Mabsadd L
.47173 .02381 1.875 0 Mabsadd L
.47173 .02381 0 -2.5 Mabsadd L
.47173 .02381 -1.875 0 Mabsadd L closepath F
.47321 .02381 -1.875 0 Mabsadd m
.47321 .02381 0 2.5 Mabsadd L
.47321 .02381 1.875 0 Mabsadd L
.47321 .02381 0 -2.5 Mabsadd L
.47321 .02381 -1.875 0 Mabsadd L closepath F
.4747 .02381 -1.875 0 Mabsadd m
.4747 .02381 0 2.5 Mabsadd L
.4747 .02381 1.875 0 Mabsadd L
.4747 .02381 0 -2.5 Mabsadd L
.4747 .02381 -1.875 0 Mabsadd L closepath F
.47619 .02381 -1.875 0 Mabsadd m
.47619 .02381 0 2.5 Mabsadd L
.47619 .02381 1.875 0 Mabsadd L
.47619 .02381 0 -2.5 Mabsadd L
.47619 .02381 -1.875 0 Mabsadd L closepath F
.47768 .02381 -1.875 0 Mabsadd m
.47768 .02381 0 2.5 Mabsadd L
.47768 .02381 1.875 0 Mabsadd L
.47768 .02381 0 -2.5 Mabsadd L
.47768 .02381 -1.875 0 Mabsadd L closepath F
.47917 .02381 -1.875 0 Mabsadd m
.47917 .02381 0 2.5 Mabsadd L
.47917 .02381 1.875 0 Mabsadd L
.47917 .02381 0 -2.5 Mabsadd L
.47917 .02381 -1.875 0 Mabsadd L closepath F
.48065 .02381 -1.875 0 Mabsadd m
.48065 .02381 0 2.5 Mabsadd L
.48065 .02381 1.875 0 Mabsadd L
.48065 .02381 0 -2.5 Mabsadd L
.48065 .02381 -1.875 0 Mabsadd L closepath F
.48214 .02381 -1.875 0 Mabsadd m
.48214 .02381 0 2.5 Mabsadd L
.48214 .02381 1.875 0 Mabsadd L
.48214 .02381 0 -2.5 Mabsadd L
.48214 .02381 -1.875 0 Mabsadd L closepath F
.48363 .02381 -1.875 0 Mabsadd m
.48363 .02381 0 2.5 Mabsadd L
.48363 .02381 1.875 0 Mabsadd L
.48363 .02381 0 -2.5 Mabsadd L
.48363 .02381 -1.875 0 Mabsadd L closepath F
.48512 .02381 -1.875 0 Mabsadd m
.48512 .02381 0 2.5 Mabsadd L
.48512 .02381 1.875 0 Mabsadd L
.48512 .02381 0 -2.5 Mabsadd L
.48512 .02381 -1.875 0 Mabsadd L closepath F
.48661 .02381 -1.875 0 Mabsadd m
.48661 .02381 0 2.5 Mabsadd L
.48661 .02381 1.875 0 Mabsadd L
.48661 .02381 0 -2.5 Mabsadd L
.48661 .02381 -1.875 0 Mabsadd L closepath F
.4881 .02381 -1.875 0 Mabsadd m
.4881 .02381 0 2.5 Mabsadd L
.4881 .02381 1.875 0 Mabsadd L
.4881 .02381 0 -2.5 Mabsadd L
.4881 .02381 -1.875 0 Mabsadd L closepath F
.48958 .02381 -1.875 0 Mabsadd m
.48958 .02381 0 2.5 Mabsadd L
.48958 .02381 1.875 0 Mabsadd L
.48958 .02381 0 -2.5 Mabsadd L
.48958 .02381 -1.875 0 Mabsadd L closepath F
.49107 .02381 -1.875 0 Mabsadd m
.49107 .02381 0 2.5 Mabsadd L
.49107 .02381 1.875 0 Mabsadd L
.49107 .02381 0 -2.5 Mabsadd L
.49107 .02381 -1.875 0 Mabsadd L closepath F
.49256 .02381 -1.875 0 Mabsadd m
.49256 .02381 0 2.5 Mabsadd L
.49256 .02381 1.875 0 Mabsadd L
.49256 .02381 0 -2.5 Mabsadd L
.49256 .02381 -1.875 0 Mabsadd L closepath F
.49405 .02381 -1.875 0 Mabsadd m
.49405 .02381 0 2.5 Mabsadd L
.49405 .02381 1.875 0 Mabsadd L
.49405 .02381 0 -2.5 Mabsadd L
.49405 .02381 -1.875 0 Mabsadd L closepath F
.49554 .02381 -1.875 0 Mabsadd m
.49554 .02381 0 2.5 Mabsadd L
.49554 .02381 1.875 0 Mabsadd L
.49554 .02381 0 -2.5 Mabsadd L
.49554 .02381 -1.875 0 Mabsadd L closepath F
.49702 .02381 -1.875 0 Mabsadd m
.49702 .02381 0 2.5 Mabsadd L
.49702 .02381 1.875 0 Mabsadd L
.49702 .02381 0 -2.5 Mabsadd L
.49702 .02381 -1.875 0 Mabsadd L closepath F
.49851 .02381 -1.875 0 Mabsadd m
.49851 .02381 0 2.5 Mabsadd L
.49851 .02381 1.875 0 Mabsadd L
.49851 .02381 0 -2.5 Mabsadd L
.49851 .02381 -1.875 0 Mabsadd L closepath F
.5 .02381 -1.875 0 Mabsadd m
.5 .02381 0 2.5 Mabsadd L
.5 .02381 1.875 0 Mabsadd L
.5 .02381 0 -2.5 Mabsadd L
.5 .02381 -1.875 0 Mabsadd L closepath F
.50149 .02381 -1.875 0 Mabsadd m
.50149 .02381 0 2.5 Mabsadd L
.50149 .02381 1.875 0 Mabsadd L
.50149 .02381 0 -2.5 Mabsadd L
.50149 .02381 -1.875 0 Mabsadd L closepath F
.50298 .02381 -1.875 0 Mabsadd m
.50298 .02381 0 2.5 Mabsadd L
.50298 .02381 1.875 0 Mabsadd L
.50298 .02381 0 -2.5 Mabsadd L
.50298 .02381 -1.875 0 Mabsadd L closepath F
.50446 .02381 -1.875 0 Mabsadd m
.50446 .02381 0 2.5 Mabsadd L
.50446 .02381 1.875 0 Mabsadd L
.50446 .02381 0 -2.5 Mabsadd L
.50446 .02381 -1.875 0 Mabsadd L closepath F
.50595 .02381 -1.875 0 Mabsadd m
.50595 .02381 0 2.5 Mabsadd L
.50595 .02381 1.875 0 Mabsadd L
.50595 .02381 0 -2.5 Mabsadd L
.50595 .02381 -1.875 0 Mabsadd L closepath F
.50744 .02381 -1.875 0 Mabsadd m
.50744 .02381 0 2.5 Mabsadd L
.50744 .02381 1.875 0 Mabsadd L
.50744 .02381 0 -2.5 Mabsadd L
.50744 .02381 -1.875 0 Mabsadd L closepath F
.50893 .02381 -1.875 0 Mabsadd m
.50893 .02381 0 2.5 Mabsadd L
.50893 .02381 1.875 0 Mabsadd L
.50893 .02381 0 -2.5 Mabsadd L
.50893 .02381 -1.875 0 Mabsadd L closepath F
.51042 .02381 -1.875 0 Mabsadd m
.51042 .02381 0 2.5 Mabsadd L
.51042 .02381 1.875 0 Mabsadd L
.51042 .02381 0 -2.5 Mabsadd L
.51042 .02381 -1.875 0 Mabsadd L closepath F
.5119 .02381 -1.875 0 Mabsadd m
.5119 .02381 0 2.5 Mabsadd L
.5119 .02381 1.875 0 Mabsadd L
.5119 .02381 0 -2.5 Mabsadd L
.5119 .02381 -1.875 0 Mabsadd L closepath F
.51339 .02381 -1.875 0 Mabsadd m
.51339 .02381 0 2.5 Mabsadd L
.51339 .02381 1.875 0 Mabsadd L
.51339 .02381 0 -2.5 Mabsadd L
.51339 .02381 -1.875 0 Mabsadd L closepath F
.51488 .02381 -1.875 0 Mabsadd m
.51488 .02381 0 2.5 Mabsadd L
.51488 .02381 1.875 0 Mabsadd L
.51488 .02381 0 -2.5 Mabsadd L
.51488 .02381 -1.875 0 Mabsadd L closepath F
.51637 .02381 -1.875 0 Mabsadd m
.51637 .02381 0 2.5 Mabsadd L
.51637 .02381 1.875 0 Mabsadd L
.51637 .02381 0 -2.5 Mabsadd L
.51637 .02381 -1.875 0 Mabsadd L closepath F
.51786 .02381 -1.875 0 Mabsadd m
.51786 .02381 0 2.5 Mabsadd L
.51786 .02381 1.875 0 Mabsadd L
.51786 .02381 0 -2.5 Mabsadd L
.51786 .02381 -1.875 0 Mabsadd L closepath F
.51935 .02381 -1.875 0 Mabsadd m
.51935 .02381 0 2.5 Mabsadd L
.51935 .02381 1.875 0 Mabsadd L
.51935 .02381 0 -2.5 Mabsadd L
.51935 .02381 -1.875 0 Mabsadd L closepath F
.52083 .02381 -1.875 0 Mabsadd m
.52083 .02381 0 2.5 Mabsadd L
.52083 .02381 1.875 0 Mabsadd L
.52083 .02381 0 -2.5 Mabsadd L
.52083 .02381 -1.875 0 Mabsadd L closepath F
.52232 .02381 -1.875 0 Mabsadd m
.52232 .02381 0 2.5 Mabsadd L
.52232 .02381 1.875 0 Mabsadd L
.52232 .02381 0 -2.5 Mabsadd L
.52232 .02381 -1.875 0 Mabsadd L closepath F
.52381 .02381 -1.875 0 Mabsadd m
.52381 .02381 0 2.5 Mabsadd L
.52381 .02381 1.875 0 Mabsadd L
.52381 .02381 0 -2.5 Mabsadd L
.52381 .02381 -1.875 0 Mabsadd L closepath F
.5253 .02381 -1.875 0 Mabsadd m
.5253 .02381 0 2.5 Mabsadd L
.5253 .02381 1.875 0 Mabsadd L
.5253 .02381 0 -2.5 Mabsadd L
.5253 .02381 -1.875 0 Mabsadd L closepath F
.52679 .02381 -1.875 0 Mabsadd m
.52679 .02381 0 2.5 Mabsadd L
.52679 .02381 1.875 0 Mabsadd L
.52679 .02381 0 -2.5 Mabsadd L
.52679 .02381 -1.875 0 Mabsadd L closepath F
.52827 .02381 -1.875 0 Mabsadd m
.52827 .02381 0 2.5 Mabsadd L
.52827 .02381 1.875 0 Mabsadd L
.52827 .02381 0 -2.5 Mabsadd L
.52827 .02381 -1.875 0 Mabsadd L closepath F
.52976 .02381 -1.875 0 Mabsadd m
.52976 .02381 0 2.5 Mabsadd L
.52976 .02381 1.875 0 Mabsadd L
.52976 .02381 0 -2.5 Mabsadd L
.52976 .02381 -1.875 0 Mabsadd L closepath F
.53125 .02381 -1.875 0 Mabsadd m
.53125 .02381 0 2.5 Mabsadd L
.53125 .02381 1.875 0 Mabsadd L
.53125 .02381 0 -2.5 Mabsadd L
.53125 .02381 -1.875 0 Mabsadd L closepath F
.53274 .02381 -1.875 0 Mabsadd m
.53274 .02381 0 2.5 Mabsadd L
.53274 .02381 1.875 0 Mabsadd L
.53274 .02381 0 -2.5 Mabsadd L
.53274 .02381 -1.875 0 Mabsadd L closepath F
.53423 .02381 -1.875 0 Mabsadd m
.53423 .02381 0 2.5 Mabsadd L
.53423 .02381 1.875 0 Mabsadd L
.53423 .02381 0 -2.5 Mabsadd L
.53423 .02381 -1.875 0 Mabsadd L closepath F
.53571 .02381 -1.875 0 Mabsadd m
.53571 .02381 0 2.5 Mabsadd L
.53571 .02381 1.875 0 Mabsadd L
.53571 .02381 0 -2.5 Mabsadd L
.53571 .02381 -1.875 0 Mabsadd L closepath F
.5372 .02381 -1.875 0 Mabsadd m
.5372 .02381 0 2.5 Mabsadd L
.5372 .02381 1.875 0 Mabsadd L
.5372 .02381 0 -2.5 Mabsadd L
.5372 .02381 -1.875 0 Mabsadd L closepath F
.53869 .02381 -1.875 0 Mabsadd m
.53869 .02381 0 2.5 Mabsadd L
.53869 .02381 1.875 0 Mabsadd L
.53869 .02381 0 -2.5 Mabsadd L
.53869 .02381 -1.875 0 Mabsadd L closepath F
.54018 .02381 -1.875 0 Mabsadd m
.54018 .02381 0 2.5 Mabsadd L
.54018 .02381 1.875 0 Mabsadd L
.54018 .02381 0 -2.5 Mabsadd L
.54018 .02381 -1.875 0 Mabsadd L closepath F
.54167 .02381 -1.875 0 Mabsadd m
.54167 .02381 0 2.5 Mabsadd L
.54167 .02381 1.875 0 Mabsadd L
.54167 .02381 0 -2.5 Mabsadd L
.54167 .02381 -1.875 0 Mabsadd L closepath F
.54315 .02381 -1.875 0 Mabsadd m
.54315 .02381 0 2.5 Mabsadd L
.54315 .02381 1.875 0 Mabsadd L
.54315 .02381 0 -2.5 Mabsadd L
.54315 .02381 -1.875 0 Mabsadd L closepath F
.54464 .02381 -1.875 0 Mabsadd m
.54464 .02381 0 2.5 Mabsadd L
.54464 .02381 1.875 0 Mabsadd L
.54464 .02381 0 -2.5 Mabsadd L
.54464 .02381 -1.875 0 Mabsadd L closepath F
.54613 .02381 -1.875 0 Mabsadd m
.54613 .02381 0 2.5 Mabsadd L
.54613 .02381 1.875 0 Mabsadd L
.54613 .02381 0 -2.5 Mabsadd L
.54613 .02381 -1.875 0 Mabsadd L closepath F
.54762 .02381 -1.875 0 Mabsadd m
.54762 .02381 0 2.5 Mabsadd L
.54762 .02381 1.875 0 Mabsadd L
.54762 .02381 0 -2.5 Mabsadd L
.54762 .02381 -1.875 0 Mabsadd L closepath F
.54911 .02381 -1.875 0 Mabsadd m
.54911 .02381 0 2.5 Mabsadd L
.54911 .02381 1.875 0 Mabsadd L
.54911 .02381 0 -2.5 Mabsadd L
.54911 .02381 -1.875 0 Mabsadd L closepath F
.5506 .02381 -1.875 0 Mabsadd m
.5506 .02381 0 2.5 Mabsadd L
.5506 .02381 1.875 0 Mabsadd L
.5506 .02381 0 -2.5 Mabsadd L
.5506 .02381 -1.875 0 Mabsadd L closepath F
.55208 .02381 -1.875 0 Mabsadd m
.55208 .02381 0 2.5 Mabsadd L
.55208 .02381 1.875 0 Mabsadd L
.55208 .02381 0 -2.5 Mabsadd L
.55208 .02381 -1.875 0 Mabsadd L closepath F
.55357 .02381 -1.875 0 Mabsadd m
.55357 .02381 0 2.5 Mabsadd L
.55357 .02381 1.875 0 Mabsadd L
.55357 .02381 0 -2.5 Mabsadd L
.55357 .02381 -1.875 0 Mabsadd L closepath F
.55506 .02381 -1.875 0 Mabsadd m
.55506 .02381 0 2.5 Mabsadd L
.55506 .02381 1.875 0 Mabsadd L
.55506 .02381 0 -2.5 Mabsadd L
.55506 .02381 -1.875 0 Mabsadd L closepath F
.55655 .02381 -1.875 0 Mabsadd m
.55655 .02381 0 2.5 Mabsadd L
.55655 .02381 1.875 0 Mabsadd L
.55655 .02381 0 -2.5 Mabsadd L
.55655 .02381 -1.875 0 Mabsadd L closepath F
.55804 .02381 -1.875 0 Mabsadd m
.55804 .02381 0 2.5 Mabsadd L
.55804 .02381 1.875 0 Mabsadd L
.55804 .02381 0 -2.5 Mabsadd L
.55804 .02381 -1.875 0 Mabsadd L closepath F
.55952 .02381 -1.875 0 Mabsadd m
.55952 .02381 0 2.5 Mabsadd L
.55952 .02381 1.875 0 Mabsadd L
.55952 .02381 0 -2.5 Mabsadd L
.55952 .02381 -1.875 0 Mabsadd L closepath F
.56101 .02381 -1.875 0 Mabsadd m
.56101 .02381 0 2.5 Mabsadd L
.56101 .02381 1.875 0 Mabsadd L
.56101 .02381 0 -2.5 Mabsadd L
.56101 .02381 -1.875 0 Mabsadd L closepath F
.5625 .02381 -1.875 0 Mabsadd m
.5625 .02381 0 2.5 Mabsadd L
.5625 .02381 1.875 0 Mabsadd L
.5625 .02381 0 -2.5 Mabsadd L
.5625 .02381 -1.875 0 Mabsadd L closepath F
.56399 .02381 -1.875 0 Mabsadd m
.56399 .02381 0 2.5 Mabsadd L
.56399 .02381 1.875 0 Mabsadd L
.56399 .02381 0 -2.5 Mabsadd L
.56399 .02381 -1.875 0 Mabsadd L closepath F
.56548 .02381 -1.875 0 Mabsadd m
.56548 .02381 0 2.5 Mabsadd L
.56548 .02381 1.875 0 Mabsadd L
.56548 .02381 0 -2.5 Mabsadd L
.56548 .02381 -1.875 0 Mabsadd L closepath F
.56696 .02381 -1.875 0 Mabsadd m
.56696 .02381 0 2.5 Mabsadd L
.56696 .02381 1.875 0 Mabsadd L
.56696 .02381 0 -2.5 Mabsadd L
.56696 .02381 -1.875 0 Mabsadd L closepath F
.56845 .02381 -1.875 0 Mabsadd m
.56845 .02381 0 2.5 Mabsadd L
.56845 .02381 1.875 0 Mabsadd L
.56845 .02381 0 -2.5 Mabsadd L
.56845 .02381 -1.875 0 Mabsadd L closepath F
.56994 .02381 -1.875 0 Mabsadd m
.56994 .02381 0 2.5 Mabsadd L
.56994 .02381 1.875 0 Mabsadd L
.56994 .02381 0 -2.5 Mabsadd L
.56994 .02381 -1.875 0 Mabsadd L closepath F
.57143 .02381 -1.875 0 Mabsadd m
.57143 .02381 0 2.5 Mabsadd L
.57143 .02381 1.875 0 Mabsadd L
.57143 .02381 0 -2.5 Mabsadd L
.57143 .02381 -1.875 0 Mabsadd L closepath F
.57292 .02381 -1.875 0 Mabsadd m
.57292 .02381 0 2.5 Mabsadd L
.57292 .02381 1.875 0 Mabsadd L
.57292 .02381 0 -2.5 Mabsadd L
.57292 .02381 -1.875 0 Mabsadd L closepath F
.5744 .02381 -1.875 0 Mabsadd m
.5744 .02381 0 2.5 Mabsadd L
.5744 .02381 1.875 0 Mabsadd L
.5744 .02381 0 -2.5 Mabsadd L
.5744 .02381 -1.875 0 Mabsadd L closepath F
.57589 .02381 -1.875 0 Mabsadd m
.57589 .02381 0 2.5 Mabsadd L
.57589 .02381 1.875 0 Mabsadd L
.57589 .02381 0 -2.5 Mabsadd L
.57589 .02381 -1.875 0 Mabsadd L closepath F
.57738 .02381 -1.875 0 Mabsadd m
.57738 .02381 0 2.5 Mabsadd L
.57738 .02381 1.875 0 Mabsadd L
.57738 .02381 0 -2.5 Mabsadd L
.57738 .02381 -1.875 0 Mabsadd L closepath F
.57887 .02381 -1.875 0 Mabsadd m
.57887 .02381 0 2.5 Mabsadd L
.57887 .02381 1.875 0 Mabsadd L
.57887 .02381 0 -2.5 Mabsadd L
.57887 .02381 -1.875 0 Mabsadd L closepath F
.58036 .02381 -1.875 0 Mabsadd m
.58036 .02381 0 2.5 Mabsadd L
.58036 .02381 1.875 0 Mabsadd L
.58036 .02381 0 -2.5 Mabsadd L
.58036 .02381 -1.875 0 Mabsadd L closepath F
.58185 .02381 -1.875 0 Mabsadd m
.58185 .02381 0 2.5 Mabsadd L
.58185 .02381 1.875 0 Mabsadd L
.58185 .02381 0 -2.5 Mabsadd L
.58185 .02381 -1.875 0 Mabsadd L closepath F
.58333 .02381 -1.875 0 Mabsadd m
.58333 .02381 0 2.5 Mabsadd L
.58333 .02381 1.875 0 Mabsadd L
.58333 .02381 0 -2.5 Mabsadd L
.58333 .02381 -1.875 0 Mabsadd L closepath F
.58482 .02381 -1.875 0 Mabsadd m
.58482 .02381 0 2.5 Mabsadd L
.58482 .02381 1.875 0 Mabsadd L
.58482 .02381 0 -2.5 Mabsadd L
.58482 .02381 -1.875 0 Mabsadd L closepath F
.58631 .02381 -1.875 0 Mabsadd m
.58631 .02381 0 2.5 Mabsadd L
.58631 .02381 1.875 0 Mabsadd L
.58631 .02381 0 -2.5 Mabsadd L
.58631 .02381 -1.875 0 Mabsadd L closepath F
.5878 .02381 -1.875 0 Mabsadd m
.5878 .02381 0 2.5 Mabsadd L
.5878 .02381 1.875 0 Mabsadd L
.5878 .02381 0 -2.5 Mabsadd L
.5878 .02381 -1.875 0 Mabsadd L closepath F
.58929 .02381 -1.875 0 Mabsadd m
.58929 .02381 0 2.5 Mabsadd L
.58929 .02381 1.875 0 Mabsadd L
.58929 .02381 0 -2.5 Mabsadd L
.58929 .02381 -1.875 0 Mabsadd L closepath F
.59077 .02381 -1.875 0 Mabsadd m
.59077 .02381 0 2.5 Mabsadd L
.59077 .02381 1.875 0 Mabsadd L
.59077 .02381 0 -2.5 Mabsadd L
.59077 .02381 -1.875 0 Mabsadd L closepath F
.59226 .02381 -1.875 0 Mabsadd m
.59226 .02381 0 2.5 Mabsadd L
.59226 .02381 1.875 0 Mabsadd L
.59226 .02381 0 -2.5 Mabsadd L
.59226 .02381 -1.875 0 Mabsadd L closepath F
.59375 .02381 -1.875 0 Mabsadd m
.59375 .02381 0 2.5 Mabsadd L
.59375 .02381 1.875 0 Mabsadd L
.59375 .02381 0 -2.5 Mabsadd L
.59375 .02381 -1.875 0 Mabsadd L closepath F
.59524 .02381 -1.875 0 Mabsadd m
.59524 .02381 0 2.5 Mabsadd L
.59524 .02381 1.875 0 Mabsadd L
.59524 .02381 0 -2.5 Mabsadd L
.59524 .02381 -1.875 0 Mabsadd L closepath F
.59673 .02381 -1.875 0 Mabsadd m
.59673 .02381 0 2.5 Mabsadd L
.59673 .02381 1.875 0 Mabsadd L
.59673 .02381 0 -2.5 Mabsadd L
.59673 .02381 -1.875 0 Mabsadd L closepath F
.59821 .02381 -1.875 0 Mabsadd m
.59821 .02381 0 2.5 Mabsadd L
.59821 .02381 1.875 0 Mabsadd L
.59821 .02381 0 -2.5 Mabsadd L
.59821 .02381 -1.875 0 Mabsadd L closepath F
.5997 .02381 -1.875 0 Mabsadd m
.5997 .02381 0 2.5 Mabsadd L
.5997 .02381 1.875 0 Mabsadd L
.5997 .02381 0 -2.5 Mabsadd L
.5997 .02381 -1.875 0 Mabsadd L closepath F
.60119 .02381 -1.875 0 Mabsadd m
.60119 .02381 0 2.5 Mabsadd L
.60119 .02381 1.875 0 Mabsadd L
.60119 .02381 0 -2.5 Mabsadd L
.60119 .02381 -1.875 0 Mabsadd L closepath F
.60268 .02381 -1.875 0 Mabsadd m
.60268 .02381 0 2.5 Mabsadd L
.60268 .02381 1.875 0 Mabsadd L
.60268 .02381 0 -2.5 Mabsadd L
.60268 .02381 -1.875 0 Mabsadd L closepath F
.60417 .02381 -1.875 0 Mabsadd m
.60417 .02381 0 2.5 Mabsadd L
.60417 .02381 1.875 0 Mabsadd L
.60417 .02381 0 -2.5 Mabsadd L
.60417 .02381 -1.875 0 Mabsadd L closepath F
.60565 .02381 -1.875 0 Mabsadd m
.60565 .02381 0 2.5 Mabsadd L
.60565 .02381 1.875 0 Mabsadd L
.60565 .02381 0 -2.5 Mabsadd L
.60565 .02381 -1.875 0 Mabsadd L closepath F
.60714 .02381 -1.875 0 Mabsadd m
.60714 .02381 0 2.5 Mabsadd L
.60714 .02381 1.875 0 Mabsadd L
.60714 .02381 0 -2.5 Mabsadd L
.60714 .02381 -1.875 0 Mabsadd L closepath F
.60863 .02381 -1.875 0 Mabsadd m
.60863 .02381 0 2.5 Mabsadd L
.60863 .02381 1.875 0 Mabsadd L
.60863 .02381 0 -2.5 Mabsadd L
.60863 .02381 -1.875 0 Mabsadd L closepath F
.61012 .02381 -1.875 0 Mabsadd m
.61012 .02381 0 2.5 Mabsadd L
.61012 .02381 1.875 0 Mabsadd L
.61012 .02381 0 -2.5 Mabsadd L
.61012 .02381 -1.875 0 Mabsadd L closepath F
.61161 .02381 -1.875 0 Mabsadd m
.61161 .02381 0 2.5 Mabsadd L
.61161 .02381 1.875 0 Mabsadd L
.61161 .02381 0 -2.5 Mabsadd L
.61161 .02381 -1.875 0 Mabsadd L closepath F
.6131 .02381 -1.875 0 Mabsadd m
.6131 .02381 0 2.5 Mabsadd L
.6131 .02381 1.875 0 Mabsadd L
.6131 .02381 0 -2.5 Mabsadd L
.6131 .02381 -1.875 0 Mabsadd L closepath F
.61458 .02381 -1.875 0 Mabsadd m
.61458 .02381 0 2.5 Mabsadd L
.61458 .02381 1.875 0 Mabsadd L
.61458 .02381 0 -2.5 Mabsadd L
.61458 .02381 -1.875 0 Mabsadd L closepath F
.61607 .02381 -1.875 0 Mabsadd m
.61607 .02381 0 2.5 Mabsadd L
.61607 .02381 1.875 0 Mabsadd L
.61607 .02381 0 -2.5 Mabsadd L
.61607 .02381 -1.875 0 Mabsadd L closepath F
.61756 .02381 -1.875 0 Mabsadd m
.61756 .02381 0 2.5 Mabsadd L
.61756 .02381 1.875 0 Mabsadd L
.61756 .02381 0 -2.5 Mabsadd L
.61756 .02381 -1.875 0 Mabsadd L closepath F
.61905 .02381 -1.875 0 Mabsadd m
.61905 .02381 0 2.5 Mabsadd L
.61905 .02381 1.875 0 Mabsadd L
.61905 .02381 0 -2.5 Mabsadd L
.61905 .02381 -1.875 0 Mabsadd L closepath F
.62054 .02381 -1.875 0 Mabsadd m
.62054 .02381 0 2.5 Mabsadd L
.62054 .02381 1.875 0 Mabsadd L
.62054 .02381 0 -2.5 Mabsadd L
.62054 .02381 -1.875 0 Mabsadd L closepath F
.62202 .02381 -1.875 0 Mabsadd m
.62202 .02381 0 2.5 Mabsadd L
.62202 .02381 1.875 0 Mabsadd L
.62202 .02381 0 -2.5 Mabsadd L
.62202 .02381 -1.875 0 Mabsadd L closepath F
.62351 .02381 -1.875 0 Mabsadd m
.62351 .02381 0 2.5 Mabsadd L
.62351 .02381 1.875 0 Mabsadd L
.62351 .02381 0 -2.5 Mabsadd L
.62351 .02381 -1.875 0 Mabsadd L closepath F
.625 .02381 -1.875 0 Mabsadd m
.625 .02381 0 2.5 Mabsadd L
.625 .02381 1.875 0 Mabsadd L
.625 .02381 0 -2.5 Mabsadd L
.625 .02381 -1.875 0 Mabsadd L closepath F
.62649 .02381 -1.875 0 Mabsadd m
.62649 .02381 0 2.5 Mabsadd L
.62649 .02381 1.875 0 Mabsadd L
.62649 .02381 0 -2.5 Mabsadd L
.62649 .02381 -1.875 0 Mabsadd L closepath F
.62798 .02381 -1.875 0 Mabsadd m
.62798 .02381 0 2.5 Mabsadd L
.62798 .02381 1.875 0 Mabsadd L
.62798 .02381 0 -2.5 Mabsadd L
.62798 .02381 -1.875 0 Mabsadd L closepath F
.62946 .02381 -1.875 0 Mabsadd m
.62946 .02381 0 2.5 Mabsadd L
.62946 .02381 1.875 0 Mabsadd L
.62946 .02381 0 -2.5 Mabsadd L
.62946 .02381 -1.875 0 Mabsadd L closepath F
.63095 .02381 -1.875 0 Mabsadd m
.63095 .02381 0 2.5 Mabsadd L
.63095 .02381 1.875 0 Mabsadd L
.63095 .02381 0 -2.5 Mabsadd L
.63095 .02381 -1.875 0 Mabsadd L closepath F
.63244 .02381 -1.875 0 Mabsadd m
.63244 .02381 0 2.5 Mabsadd L
.63244 .02381 1.875 0 Mabsadd L
.63244 .02381 0 -2.5 Mabsadd L
.63244 .02381 -1.875 0 Mabsadd L closepath F
.63393 .02381 -1.875 0 Mabsadd m
.63393 .02381 0 2.5 Mabsadd L
.63393 .02381 1.875 0 Mabsadd L
.63393 .02381 0 -2.5 Mabsadd L
.63393 .02381 -1.875 0 Mabsadd L closepath F
.63542 .02381 -1.875 0 Mabsadd m
.63542 .02381 0 2.5 Mabsadd L
.63542 .02381 1.875 0 Mabsadd L
.63542 .02381 0 -2.5 Mabsadd L
.63542 .02381 -1.875 0 Mabsadd L closepath F
.6369 .02381 -1.875 0 Mabsadd m
.6369 .02381 0 2.5 Mabsadd L
.6369 .02381 1.875 0 Mabsadd L
.6369 .02381 0 -2.5 Mabsadd L
.6369 .02381 -1.875 0 Mabsadd L closepath F
.63839 .02381 -1.875 0 Mabsadd m
.63839 .02381 0 2.5 Mabsadd L
.63839 .02381 1.875 0 Mabsadd L
.63839 .02381 0 -2.5 Mabsadd L
.63839 .02381 -1.875 0 Mabsadd L closepath F
.63988 .02381 -1.875 0 Mabsadd m
.63988 .02381 0 2.5 Mabsadd L
.63988 .02381 1.875 0 Mabsadd L
.63988 .02381 0 -2.5 Mabsadd L
.63988 .02381 -1.875 0 Mabsadd L closepath F
.64137 .02381 -1.875 0 Mabsadd m
.64137 .02381 0 2.5 Mabsadd L
.64137 .02381 1.875 0 Mabsadd L
.64137 .02381 0 -2.5 Mabsadd L
.64137 .02381 -1.875 0 Mabsadd L closepath F
.64286 .02381 -1.875 0 Mabsadd m
.64286 .02381 0 2.5 Mabsadd L
.64286 .02381 1.875 0 Mabsadd L
.64286 .02381 0 -2.5 Mabsadd L
.64286 .02381 -1.875 0 Mabsadd L closepath F
.64435 .02381 -1.875 0 Mabsadd m
.64435 .02381 0 2.5 Mabsadd L
.64435 .02381 1.875 0 Mabsadd L
.64435 .02381 0 -2.5 Mabsadd L
.64435 .02381 -1.875 0 Mabsadd L closepath F
.64583 .02381 -1.875 0 Mabsadd m
.64583 .02381 0 2.5 Mabsadd L
.64583 .02381 1.875 0 Mabsadd L
.64583 .02381 0 -2.5 Mabsadd L
.64583 .02381 -1.875 0 Mabsadd L closepath F
.64732 .02381 -1.875 0 Mabsadd m
.64732 .02381 0 2.5 Mabsadd L
.64732 .02381 1.875 0 Mabsadd L
.64732 .02381 0 -2.5 Mabsadd L
.64732 .02381 -1.875 0 Mabsadd L closepath F
.64881 .02381 -1.875 0 Mabsadd m
.64881 .02381 0 2.5 Mabsadd L
.64881 .02381 1.875 0 Mabsadd L
.64881 .02381 0 -2.5 Mabsadd L
.64881 .02381 -1.875 0 Mabsadd L closepath F
.6503 .02381 -1.875 0 Mabsadd m
.6503 .02381 0 2.5 Mabsadd L
.6503 .02381 1.875 0 Mabsadd L
.6503 .02381 0 -2.5 Mabsadd L
.6503 .02381 -1.875 0 Mabsadd L closepath F
.65179 .02381 -1.875 0 Mabsadd m
.65179 .02381 0 2.5 Mabsadd L
.65179 .02381 1.875 0 Mabsadd L
.65179 .02381 0 -2.5 Mabsadd L
.65179 .02381 -1.875 0 Mabsadd L closepath F
.65327 .02381 -1.875 0 Mabsadd m
.65327 .02381 0 2.5 Mabsadd L
.65327 .02381 1.875 0 Mabsadd L
.65327 .02381 0 -2.5 Mabsadd L
.65327 .02381 -1.875 0 Mabsadd L closepath F
.65476 .02381 -1.875 0 Mabsadd m
.65476 .02381 0 2.5 Mabsadd L
.65476 .02381 1.875 0 Mabsadd L
.65476 .02381 0 -2.5 Mabsadd L
.65476 .02381 -1.875 0 Mabsadd L closepath F
.65625 .02381 -1.875 0 Mabsadd m
.65625 .02381 0 2.5 Mabsadd L
.65625 .02381 1.875 0 Mabsadd L
.65625 .02381 0 -2.5 Mabsadd L
.65625 .02381 -1.875 0 Mabsadd L closepath F
.65774 .02381 -1.875 0 Mabsadd m
.65774 .02381 0 2.5 Mabsadd L
.65774 .02381 1.875 0 Mabsadd L
.65774 .02381 0 -2.5 Mabsadd L
.65774 .02381 -1.875 0 Mabsadd L closepath F
.65923 .02381 -1.875 0 Mabsadd m
.65923 .02381 0 2.5 Mabsadd L
.65923 .02381 1.875 0 Mabsadd L
.65923 .02381 0 -2.5 Mabsadd L
.65923 .02381 -1.875 0 Mabsadd L closepath F
.66071 .02381 -1.875 0 Mabsadd m
.66071 .02381 0 2.5 Mabsadd L
.66071 .02381 1.875 0 Mabsadd L
.66071 .02381 0 -2.5 Mabsadd L
.66071 .02381 -1.875 0 Mabsadd L closepath F
.6622 .02381 -1.875 0 Mabsadd m
.6622 .02381 0 2.5 Mabsadd L
.6622 .02381 1.875 0 Mabsadd L
.6622 .02381 0 -2.5 Mabsadd L
.6622 .02381 -1.875 0 Mabsadd L closepath F
.66369 .02381 -1.875 0 Mabsadd m
.66369 .02381 0 2.5 Mabsadd L
.66369 .02381 1.875 0 Mabsadd L
.66369 .02381 0 -2.5 Mabsadd L
.66369 .02381 -1.875 0 Mabsadd L closepath F
.66518 .02381 -1.875 0 Mabsadd m
.66518 .02381 0 2.5 Mabsadd L
.66518 .02381 1.875 0 Mabsadd L
.66518 .02381 0 -2.5 Mabsadd L
.66518 .02381 -1.875 0 Mabsadd L closepath F
.66667 .02381 -1.875 0 Mabsadd m
.66667 .02381 0 2.5 Mabsadd L
.66667 .02381 1.875 0 Mabsadd L
.66667 .02381 0 -2.5 Mabsadd L
.66667 .02381 -1.875 0 Mabsadd L closepath F
.66815 .02381 -1.875 0 Mabsadd m
.66815 .02381 0 2.5 Mabsadd L
.66815 .02381 1.875 0 Mabsadd L
.66815 .02381 0 -2.5 Mabsadd L
.66815 .02381 -1.875 0 Mabsadd L closepath F
.66964 .02381 -1.875 0 Mabsadd m
.66964 .02381 0 2.5 Mabsadd L
.66964 .02381 1.875 0 Mabsadd L
.66964 .02381 0 -2.5 Mabsadd L
.66964 .02381 -1.875 0 Mabsadd L closepath F
.67113 .02381 -1.875 0 Mabsadd m
.67113 .02381 0 2.5 Mabsadd L
.67113 .02381 1.875 0 Mabsadd L
.67113 .02381 0 -2.5 Mabsadd L
.67113 .02381 -1.875 0 Mabsadd L closepath F
.67262 .02381 -1.875 0 Mabsadd m
.67262 .02381 0 2.5 Mabsadd L
.67262 .02381 1.875 0 Mabsadd L
.67262 .02381 0 -2.5 Mabsadd L
.67262 .02381 -1.875 0 Mabsadd L closepath F
.67411 .02381 -1.875 0 Mabsadd m
.67411 .02381 0 2.5 Mabsadd L
.67411 .02381 1.875 0 Mabsadd L
.67411 .02381 0 -2.5 Mabsadd L
.67411 .02381 -1.875 0 Mabsadd L closepath F
.6756 .02381 -1.875 0 Mabsadd m
.6756 .02381 0 2.5 Mabsadd L
.6756 .02381 1.875 0 Mabsadd L
.6756 .02381 0 -2.5 Mabsadd L
.6756 .02381 -1.875 0 Mabsadd L closepath F
.67708 .02381 -1.875 0 Mabsadd m
.67708 .02381 0 2.5 Mabsadd L
.67708 .02381 1.875 0 Mabsadd L
.67708 .02381 0 -2.5 Mabsadd L
.67708 .02381 -1.875 0 Mabsadd L closepath F
.67857 .02381 -1.875 0 Mabsadd m
.67857 .02381 0 2.5 Mabsadd L
.67857 .02381 1.875 0 Mabsadd L
.67857 .02381 0 -2.5 Mabsadd L
.67857 .02381 -1.875 0 Mabsadd L closepath F
.68006 .02381 -1.875 0 Mabsadd m
.68006 .02381 0 2.5 Mabsadd L
.68006 .02381 1.875 0 Mabsadd L
.68006 .02381 0 -2.5 Mabsadd L
.68006 .02381 -1.875 0 Mabsadd L closepath F
.68155 .02381 -1.875 0 Mabsadd m
.68155 .02381 0 2.5 Mabsadd L
.68155 .02381 1.875 0 Mabsadd L
.68155 .02381 0 -2.5 Mabsadd L
.68155 .02381 -1.875 0 Mabsadd L closepath F
.68304 .02381 -1.875 0 Mabsadd m
.68304 .02381 0 2.5 Mabsadd L
.68304 .02381 1.875 0 Mabsadd L
.68304 .02381 0 -2.5 Mabsadd L
.68304 .02381 -1.875 0 Mabsadd L closepath F
.68452 .02381 -1.875 0 Mabsadd m
.68452 .02381 0 2.5 Mabsadd L
.68452 .02381 1.875 0 Mabsadd L
.68452 .02381 0 -2.5 Mabsadd L
.68452 .02381 -1.875 0 Mabsadd L closepath F
.68601 .02381 -1.875 0 Mabsadd m
.68601 .02381 0 2.5 Mabsadd L
.68601 .02381 1.875 0 Mabsadd L
.68601 .02381 0 -2.5 Mabsadd L
.68601 .02381 -1.875 0 Mabsadd L closepath F
.6875 .02381 -1.875 0 Mabsadd m
.6875 .02381 0 2.5 Mabsadd L
.6875 .02381 1.875 0 Mabsadd L
.6875 .02381 0 -2.5 Mabsadd L
.6875 .02381 -1.875 0 Mabsadd L closepath F
.68899 .02381 -1.875 0 Mabsadd m
.68899 .02381 0 2.5 Mabsadd L
.68899 .02381 1.875 0 Mabsadd L
.68899 .02381 0 -2.5 Mabsadd L
.68899 .02381 -1.875 0 Mabsadd L closepath F
.69048 .02381 -1.875 0 Mabsadd m
.69048 .02381 0 2.5 Mabsadd L
.69048 .02381 1.875 0 Mabsadd L
.69048 .02381 0 -2.5 Mabsadd L
.69048 .02381 -1.875 0 Mabsadd L closepath F
.69196 .02381 -1.875 0 Mabsadd m
.69196 .02381 0 2.5 Mabsadd L
.69196 .02381 1.875 0 Mabsadd L
.69196 .02381 0 -2.5 Mabsadd L
.69196 .02381 -1.875 0 Mabsadd L closepath F
.69345 .02381 -1.875 0 Mabsadd m
.69345 .02381 0 2.5 Mabsadd L
.69345 .02381 1.875 0 Mabsadd L
.69345 .02381 0 -2.5 Mabsadd L
.69345 .02381 -1.875 0 Mabsadd L closepath F
.69494 .02381 -1.875 0 Mabsadd m
.69494 .02381 0 2.5 Mabsadd L
.69494 .02381 1.875 0 Mabsadd L
.69494 .02381 0 -2.5 Mabsadd L
.69494 .02381 -1.875 0 Mabsadd L closepath F
.69643 .02381 -1.875 0 Mabsadd m
.69643 .02381 0 2.5 Mabsadd L
.69643 .02381 1.875 0 Mabsadd L
.69643 .02381 0 -2.5 Mabsadd L
.69643 .02381 -1.875 0 Mabsadd L closepath F
.69792 .02381 -1.875 0 Mabsadd m
.69792 .02381 0 2.5 Mabsadd L
.69792 .02381 1.875 0 Mabsadd L
.69792 .02381 0 -2.5 Mabsadd L
.69792 .02381 -1.875 0 Mabsadd L closepath F
.6994 .02381 -1.875 0 Mabsadd m
.6994 .02381 0 2.5 Mabsadd L
.6994 .02381 1.875 0 Mabsadd L
.6994 .02381 0 -2.5 Mabsadd L
.6994 .02381 -1.875 0 Mabsadd L closepath F
.70089 .02381 -1.875 0 Mabsadd m
.70089 .02381 0 2.5 Mabsadd L
.70089 .02381 1.875 0 Mabsadd L
.70089 .02381 0 -2.5 Mabsadd L
.70089 .02381 -1.875 0 Mabsadd L closepath F
.70238 .02381 -1.875 0 Mabsadd m
.70238 .02381 0 2.5 Mabsadd L
.70238 .02381 1.875 0 Mabsadd L
.70238 .02381 0 -2.5 Mabsadd L
.70238 .02381 -1.875 0 Mabsadd L closepath F
.70387 .02381 -1.875 0 Mabsadd m
.70387 .02381 0 2.5 Mabsadd L
.70387 .02381 1.875 0 Mabsadd L
.70387 .02381 0 -2.5 Mabsadd L
.70387 .02381 -1.875 0 Mabsadd L closepath F
.70536 .02381 -1.875 0 Mabsadd m
.70536 .02381 0 2.5 Mabsadd L
.70536 .02381 1.875 0 Mabsadd L
.70536 .02381 0 -2.5 Mabsadd L
.70536 .02381 -1.875 0 Mabsadd L closepath F
.70685 .02381 -1.875 0 Mabsadd m
.70685 .02381 0 2.5 Mabsadd L
.70685 .02381 1.875 0 Mabsadd L
.70685 .02381 0 -2.5 Mabsadd L
.70685 .02381 -1.875 0 Mabsadd L closepath F
.70833 .02381 -1.875 0 Mabsadd m
.70833 .02381 0 2.5 Mabsadd L
.70833 .02381 1.875 0 Mabsadd L
.70833 .02381 0 -2.5 Mabsadd L
.70833 .02381 -1.875 0 Mabsadd L closepath F
.70982 .02381 -1.875 0 Mabsadd m
.70982 .02381 0 2.5 Mabsadd L
.70982 .02381 1.875 0 Mabsadd L
.70982 .02381 0 -2.5 Mabsadd L
.70982 .02381 -1.875 0 Mabsadd L closepath F
.71131 .02381 -1.875 0 Mabsadd m
.71131 .02381 0 2.5 Mabsadd L
.71131 .02381 1.875 0 Mabsadd L
.71131 .02381 0 -2.5 Mabsadd L
.71131 .02381 -1.875 0 Mabsadd L closepath F
.7128 .02381 -1.875 0 Mabsadd m
.7128 .02381 0 2.5 Mabsadd L
.7128 .02381 1.875 0 Mabsadd L
.7128 .02381 0 -2.5 Mabsadd L
.7128 .02381 -1.875 0 Mabsadd L closepath F
.71429 .02381 -1.875 0 Mabsadd m
.71429 .02381 0 2.5 Mabsadd L
.71429 .02381 1.875 0 Mabsadd L
.71429 .02381 0 -2.5 Mabsadd L
.71429 .02381 -1.875 0 Mabsadd L closepath F
.71577 .02381 -1.875 0 Mabsadd m
.71577 .02381 0 2.5 Mabsadd L
.71577 .02381 1.875 0 Mabsadd L
.71577 .02381 0 -2.5 Mabsadd L
.71577 .02381 -1.875 0 Mabsadd L closepath F
.71726 .02381 -1.875 0 Mabsadd m
.71726 .02381 0 2.5 Mabsadd L
.71726 .02381 1.875 0 Mabsadd L
.71726 .02381 0 -2.5 Mabsadd L
.71726 .02381 -1.875 0 Mabsadd L closepath F
.71875 .02381 -1.875 0 Mabsadd m
.71875 .02381 0 2.5 Mabsadd L
.71875 .02381 1.875 0 Mabsadd L
.71875 .02381 0 -2.5 Mabsadd L
.71875 .02381 -1.875 0 Mabsadd L closepath F
.72024 .02381 -1.875 0 Mabsadd m
.72024 .02381 0 2.5 Mabsadd L
.72024 .02381 1.875 0 Mabsadd L
.72024 .02381 0 -2.5 Mabsadd L
.72024 .02381 -1.875 0 Mabsadd L closepath F
.72173 .02381 -1.875 0 Mabsadd m
.72173 .02381 0 2.5 Mabsadd L
.72173 .02381 1.875 0 Mabsadd L
.72173 .02381 0 -2.5 Mabsadd L
.72173 .02381 -1.875 0 Mabsadd L closepath F
.72321 .02381 -1.875 0 Mabsadd m
.72321 .02381 0 2.5 Mabsadd L
.72321 .02381 1.875 0 Mabsadd L
.72321 .02381 0 -2.5 Mabsadd L
.72321 .02381 -1.875 0 Mabsadd L closepath F
.7247 .02381 -1.875 0 Mabsadd m
.7247 .02381 0 2.5 Mabsadd L
.7247 .02381 1.875 0 Mabsadd L
.7247 .02381 0 -2.5 Mabsadd L
.7247 .02381 -1.875 0 Mabsadd L closepath F
.72619 .02381 -1.875 0 Mabsadd m
.72619 .02381 0 2.5 Mabsadd L
.72619 .02381 1.875 0 Mabsadd L
.72619 .02381 0 -2.5 Mabsadd L
.72619 .02381 -1.875 0 Mabsadd L closepath F
.72768 .02381 -1.875 0 Mabsadd m
.72768 .02381 0 2.5 Mabsadd L
.72768 .02381 1.875 0 Mabsadd L
.72768 .02381 0 -2.5 Mabsadd L
.72768 .02381 -1.875 0 Mabsadd L closepath F
.72917 .02381 -1.875 0 Mabsadd m
.72917 .02381 0 2.5 Mabsadd L
.72917 .02381 1.875 0 Mabsadd L
.72917 .02381 0 -2.5 Mabsadd L
.72917 .02381 -1.875 0 Mabsadd L closepath F
.73065 .02381 -1.875 0 Mabsadd m
.73065 .02381 0 2.5 Mabsadd L
.73065 .02381 1.875 0 Mabsadd L
.73065 .02381 0 -2.5 Mabsadd L
.73065 .02381 -1.875 0 Mabsadd L closepath F
.73214 .02381 -1.875 0 Mabsadd m
.73214 .02381 0 2.5 Mabsadd L
.73214 .02381 1.875 0 Mabsadd L
.73214 .02381 0 -2.5 Mabsadd L
.73214 .02381 -1.875 0 Mabsadd L closepath F
.73363 .02381 -1.875 0 Mabsadd m
.73363 .02381 0 2.5 Mabsadd L
.73363 .02381 1.875 0 Mabsadd L
.73363 .02381 0 -2.5 Mabsadd L
.73363 .02381 -1.875 0 Mabsadd L closepath F
.73512 .02381 -1.875 0 Mabsadd m
.73512 .02381 0 2.5 Mabsadd L
.73512 .02381 1.875 0 Mabsadd L
.73512 .02381 0 -2.5 Mabsadd L
.73512 .02381 -1.875 0 Mabsadd L closepath F
.73661 .02381 -1.875 0 Mabsadd m
.73661 .02381 0 2.5 Mabsadd L
.73661 .02381 1.875 0 Mabsadd L
.73661 .02381 0 -2.5 Mabsadd L
.73661 .02381 -1.875 0 Mabsadd L closepath F
.7381 .02381 -1.875 0 Mabsadd m
.7381 .02381 0 2.5 Mabsadd L
.7381 .02381 1.875 0 Mabsadd L
.7381 .02381 0 -2.5 Mabsadd L
.7381 .02381 -1.875 0 Mabsadd L closepath F
.73958 .02381 -1.875 0 Mabsadd m
.73958 .02381 0 2.5 Mabsadd L
.73958 .02381 1.875 0 Mabsadd L
.73958 .02381 0 -2.5 Mabsadd L
.73958 .02381 -1.875 0 Mabsadd L closepath F
.74107 .02381 -1.875 0 Mabsadd m
.74107 .02381 0 2.5 Mabsadd L
.74107 .02381 1.875 0 Mabsadd L
.74107 .02381 0 -2.5 Mabsadd L
.74107 .02381 -1.875 0 Mabsadd L closepath F
.74256 .02381 -1.875 0 Mabsadd m
.74256 .02381 0 2.5 Mabsadd L
.74256 .02381 1.875 0 Mabsadd L
.74256 .02381 0 -2.5 Mabsadd L
.74256 .02381 -1.875 0 Mabsadd L closepath F
.74405 .02381 -1.875 0 Mabsadd m
.74405 .02381 0 2.5 Mabsadd L
.74405 .02381 1.875 0 Mabsadd L
.74405 .02381 0 -2.5 Mabsadd L
.74405 .02381 -1.875 0 Mabsadd L closepath F
.74554 .02381 -1.875 0 Mabsadd m
.74554 .02381 0 2.5 Mabsadd L
.74554 .02381 1.875 0 Mabsadd L
.74554 .02381 0 -2.5 Mabsadd L
.74554 .02381 -1.875 0 Mabsadd L closepath F
.74702 .02381 -1.875 0 Mabsadd m
.74702 .02381 0 2.5 Mabsadd L
.74702 .02381 1.875 0 Mabsadd L
.74702 .02381 0 -2.5 Mabsadd L
.74702 .02381 -1.875 0 Mabsadd L closepath F
.74851 .02381 -1.875 0 Mabsadd m
.74851 .02381 0 2.5 Mabsadd L
.74851 .02381 1.875 0 Mabsadd L
.74851 .02381 0 -2.5 Mabsadd L
.74851 .02381 -1.875 0 Mabsadd L closepath F
.75 .02381 -1.875 0 Mabsadd m
.75 .02381 0 2.5 Mabsadd L
.75 .02381 1.875 0 Mabsadd L
.75 .02381 0 -2.5 Mabsadd L
.75 .02381 -1.875 0 Mabsadd L closepath F
.75149 .02381 -1.875 0 Mabsadd m
.75149 .02381 0 2.5 Mabsadd L
.75149 .02381 1.875 0 Mabsadd L
.75149 .02381 0 -2.5 Mabsadd L
.75149 .02381 -1.875 0 Mabsadd L closepath F
.75298 .02381 -1.875 0 Mabsadd m
.75298 .02381 0 2.5 Mabsadd L
.75298 .02381 1.875 0 Mabsadd L
.75298 .02381 0 -2.5 Mabsadd L
.75298 .02381 -1.875 0 Mabsadd L closepath F
.75446 .02381 -1.875 0 Mabsadd m
.75446 .02381 0 2.5 Mabsadd L
.75446 .02381 1.875 0 Mabsadd L
.75446 .02381 0 -2.5 Mabsadd L
.75446 .02381 -1.875 0 Mabsadd L closepath F
.75595 .02381 -1.875 0 Mabsadd m
.75595 .02381 0 2.5 Mabsadd L
.75595 .02381 1.875 0 Mabsadd L
.75595 .02381 0 -2.5 Mabsadd L
.75595 .02381 -1.875 0 Mabsadd L closepath F
.75744 .02381 -1.875 0 Mabsadd m
.75744 .02381 0 2.5 Mabsadd L
.75744 .02381 1.875 0 Mabsadd L
.75744 .02381 0 -2.5 Mabsadd L
.75744 .02381 -1.875 0 Mabsadd L closepath F
.75893 .02381 -1.875 0 Mabsadd m
.75893 .02381 0 2.5 Mabsadd L
.75893 .02381 1.875 0 Mabsadd L
.75893 .02381 0 -2.5 Mabsadd L
.75893 .02381 -1.875 0 Mabsadd L closepath F
.76042 .02381 -1.875 0 Mabsadd m
.76042 .02381 0 2.5 Mabsadd L
.76042 .02381 1.875 0 Mabsadd L
.76042 .02381 0 -2.5 Mabsadd L
.76042 .02381 -1.875 0 Mabsadd L closepath F
.7619 .02381 -1.875 0 Mabsadd m
.7619 .02381 0 2.5 Mabsadd L
.7619 .02381 1.875 0 Mabsadd L
.7619 .02381 0 -2.5 Mabsadd L
.7619 .02381 -1.875 0 Mabsadd L closepath F
.76339 .02381 -1.875 0 Mabsadd m
.76339 .02381 0 2.5 Mabsadd L
.76339 .02381 1.875 0 Mabsadd L
.76339 .02381 0 -2.5 Mabsadd L
.76339 .02381 -1.875 0 Mabsadd L closepath F
.76488 .02381 -1.875 0 Mabsadd m
.76488 .02381 0 2.5 Mabsadd L
.76488 .02381 1.875 0 Mabsadd L
.76488 .02381 0 -2.5 Mabsadd L
.76488 .02381 -1.875 0 Mabsadd L closepath F
.76637 .02381 -1.875 0 Mabsadd m
.76637 .02381 0 2.5 Mabsadd L
.76637 .02381 1.875 0 Mabsadd L
.76637 .02381 0 -2.5 Mabsadd L
.76637 .02381 -1.875 0 Mabsadd L closepath F
.76786 .02381 -1.875 0 Mabsadd m
.76786 .02381 0 2.5 Mabsadd L
.76786 .02381 1.875 0 Mabsadd L
.76786 .02381 0 -2.5 Mabsadd L
.76786 .02381 -1.875 0 Mabsadd L closepath F
.76935 .02381 -1.875 0 Mabsadd m
.76935 .02381 0 2.5 Mabsadd L
.76935 .02381 1.875 0 Mabsadd L
.76935 .02381 0 -2.5 Mabsadd L
.76935 .02381 -1.875 0 Mabsadd L closepath F
.77083 .02381 -1.875 0 Mabsadd m
.77083 .02381 0 2.5 Mabsadd L
.77083 .02381 1.875 0 Mabsadd L
.77083 .02381 0 -2.5 Mabsadd L
.77083 .02381 -1.875 0 Mabsadd L closepath F
.77232 .02381 -1.875 0 Mabsadd m
.77232 .02381 0 2.5 Mabsadd L
.77232 .02381 1.875 0 Mabsadd L
.77232 .02381 0 -2.5 Mabsadd L
.77232 .02381 -1.875 0 Mabsadd L closepath F
.77381 .02381 -1.875 0 Mabsadd m
.77381 .02381 0 2.5 Mabsadd L
.77381 .02381 1.875 0 Mabsadd L
.77381 .02381 0 -2.5 Mabsadd L
.77381 .02381 -1.875 0 Mabsadd L closepath F
.7753 .02381 -1.875 0 Mabsadd m
.7753 .02381 0 2.5 Mabsadd L
.7753 .02381 1.875 0 Mabsadd L
.7753 .02381 0 -2.5 Mabsadd L
.7753 .02381 -1.875 0 Mabsadd L closepath F
.77679 .02381 -1.875 0 Mabsadd m
.77679 .02381 0 2.5 Mabsadd L
.77679 .02381 1.875 0 Mabsadd L
.77679 .02381 0 -2.5 Mabsadd L
.77679 .02381 -1.875 0 Mabsadd L closepath F
.77827 .02381 -1.875 0 Mabsadd m
.77827 .02381 0 2.5 Mabsadd L
.77827 .02381 1.875 0 Mabsadd L
.77827 .02381 0 -2.5 Mabsadd L
.77827 .02381 -1.875 0 Mabsadd L closepath F
.77976 .02381 -1.875 0 Mabsadd m
.77976 .02381 0 2.5 Mabsadd L
.77976 .02381 1.875 0 Mabsadd L
.77976 .02381 0 -2.5 Mabsadd L
.77976 .02381 -1.875 0 Mabsadd L closepath F
.78125 .02381 -1.875 0 Mabsadd m
.78125 .02381 0 2.5 Mabsadd L
.78125 .02381 1.875 0 Mabsadd L
.78125 .02381 0 -2.5 Mabsadd L
.78125 .02381 -1.875 0 Mabsadd L closepath F
.78274 .02381 -1.875 0 Mabsadd m
.78274 .02381 0 2.5 Mabsadd L
.78274 .02381 1.875 0 Mabsadd L
.78274 .02381 0 -2.5 Mabsadd L
.78274 .02381 -1.875 0 Mabsadd L closepath F
.78423 .02381 -1.875 0 Mabsadd m
.78423 .02381 0 2.5 Mabsadd L
.78423 .02381 1.875 0 Mabsadd L
.78423 .02381 0 -2.5 Mabsadd L
.78423 .02381 -1.875 0 Mabsadd L closepath F
.78571 .02381 -1.875 0 Mabsadd m
.78571 .02381 0 2.5 Mabsadd L
.78571 .02381 1.875 0 Mabsadd L
.78571 .02381 0 -2.5 Mabsadd L
.78571 .02381 -1.875 0 Mabsadd L closepath F
.7872 .02381 -1.875 0 Mabsadd m
.7872 .02381 0 2.5 Mabsadd L
.7872 .02381 1.875 0 Mabsadd L
.7872 .02381 0 -2.5 Mabsadd L
.7872 .02381 -1.875 0 Mabsadd L closepath F
.78869 .02381 -1.875 0 Mabsadd m
.78869 .02381 0 2.5 Mabsadd L
.78869 .02381 1.875 0 Mabsadd L
.78869 .02381 0 -2.5 Mabsadd L
.78869 .02381 -1.875 0 Mabsadd L closepath F
.79018 .02381 -1.875 0 Mabsadd m
.79018 .02381 0 2.5 Mabsadd L
.79018 .02381 1.875 0 Mabsadd L
.79018 .02381 0 -2.5 Mabsadd L
.79018 .02381 -1.875 0 Mabsadd L closepath F
.79167 .02381 -1.875 0 Mabsadd m
.79167 .02381 0 2.5 Mabsadd L
.79167 .02381 1.875 0 Mabsadd L
.79167 .02381 0 -2.5 Mabsadd L
.79167 .02381 -1.875 0 Mabsadd L closepath F
.79315 .02381 -1.875 0 Mabsadd m
.79315 .02381 0 2.5 Mabsadd L
.79315 .02381 1.875 0 Mabsadd L
.79315 .02381 0 -2.5 Mabsadd L
.79315 .02381 -1.875 0 Mabsadd L closepath F
.79464 .02381 -1.875 0 Mabsadd m
.79464 .02381 0 2.5 Mabsadd L
.79464 .02381 1.875 0 Mabsadd L
.79464 .02381 0 -2.5 Mabsadd L
.79464 .02381 -1.875 0 Mabsadd L closepath F
.79613 .02381 -1.875 0 Mabsadd m
.79613 .02381 0 2.5 Mabsadd L
.79613 .02381 1.875 0 Mabsadd L
.79613 .02381 0 -2.5 Mabsadd L
.79613 .02381 -1.875 0 Mabsadd L closepath F
.79762 .02381 -1.875 0 Mabsadd m
.79762 .02381 0 2.5 Mabsadd L
.79762 .02381 1.875 0 Mabsadd L
.79762 .02381 0 -2.5 Mabsadd L
.79762 .02381 -1.875 0 Mabsadd L closepath F
.79911 .02381 -1.875 0 Mabsadd m
.79911 .02381 0 2.5 Mabsadd L
.79911 .02381 1.875 0 Mabsadd L
.79911 .02381 0 -2.5 Mabsadd L
.79911 .02381 -1.875 0 Mabsadd L closepath F
.8006 .02381 -1.875 0 Mabsadd m
.8006 .02381 0 2.5 Mabsadd L
.8006 .02381 1.875 0 Mabsadd L
.8006 .02381 0 -2.5 Mabsadd L
.8006 .02381 -1.875 0 Mabsadd L closepath F
.80208 .02381 -1.875 0 Mabsadd m
.80208 .02381 0 2.5 Mabsadd L
.80208 .02381 1.875 0 Mabsadd L
.80208 .02381 0 -2.5 Mabsadd L
.80208 .02381 -1.875 0 Mabsadd L closepath F
.80357 .02381 -1.875 0 Mabsadd m
.80357 .02381 0 2.5 Mabsadd L
.80357 .02381 1.875 0 Mabsadd L
.80357 .02381 0 -2.5 Mabsadd L
.80357 .02381 -1.875 0 Mabsadd L closepath F
.80506 .02381 -1.875 0 Mabsadd m
.80506 .02381 0 2.5 Mabsadd L
.80506 .02381 1.875 0 Mabsadd L
.80506 .02381 0 -2.5 Mabsadd L
.80506 .02381 -1.875 0 Mabsadd L closepath F
.80655 .02381 -1.875 0 Mabsadd m
.80655 .02381 0 2.5 Mabsadd L
.80655 .02381 1.875 0 Mabsadd L
.80655 .02381 0 -2.5 Mabsadd L
.80655 .02381 -1.875 0 Mabsadd L closepath F
.80804 .02381 -1.875 0 Mabsadd m
.80804 .02381 0 2.5 Mabsadd L
.80804 .02381 1.875 0 Mabsadd L
.80804 .02381 0 -2.5 Mabsadd L
.80804 .02381 -1.875 0 Mabsadd L closepath F
.80952 .02381 -1.875 0 Mabsadd m
.80952 .02381 0 2.5 Mabsadd L
.80952 .02381 1.875 0 Mabsadd L
.80952 .02381 0 -2.5 Mabsadd L
.80952 .02381 -1.875 0 Mabsadd L closepath F
.81101 .02381 -1.875 0 Mabsadd m
.81101 .02381 0 2.5 Mabsadd L
.81101 .02381 1.875 0 Mabsadd L
.81101 .02381 0 -2.5 Mabsadd L
.81101 .02381 -1.875 0 Mabsadd L closepath F
.8125 .02381 -1.875 0 Mabsadd m
.8125 .02381 0 2.5 Mabsadd L
.8125 .02381 1.875 0 Mabsadd L
.8125 .02381 0 -2.5 Mabsadd L
.8125 .02381 -1.875 0 Mabsadd L closepath F
.81399 .02381 -1.875 0 Mabsadd m
.81399 .02381 0 2.5 Mabsadd L
.81399 .02381 1.875 0 Mabsadd L
.81399 .02381 0 -2.5 Mabsadd L
.81399 .02381 -1.875 0 Mabsadd L closepath F
.81548 .02381 -1.875 0 Mabsadd m
.81548 .02381 0 2.5 Mabsadd L
.81548 .02381 1.875 0 Mabsadd L
.81548 .02381 0 -2.5 Mabsadd L
.81548 .02381 -1.875 0 Mabsadd L closepath F
.81696 .02381 -1.875 0 Mabsadd m
.81696 .02381 0 2.5 Mabsadd L
.81696 .02381 1.875 0 Mabsadd L
.81696 .02381 0 -2.5 Mabsadd L
.81696 .02381 -1.875 0 Mabsadd L closepath F
.81845 .02381 -1.875 0 Mabsadd m
.81845 .02381 0 2.5 Mabsadd L
.81845 .02381 1.875 0 Mabsadd L
.81845 .02381 0 -2.5 Mabsadd L
.81845 .02381 -1.875 0 Mabsadd L closepath F
.81994 .02381 -1.875 0 Mabsadd m
.81994 .02381 0 2.5 Mabsadd L
.81994 .02381 1.875 0 Mabsadd L
.81994 .02381 0 -2.5 Mabsadd L
.81994 .02381 -1.875 0 Mabsadd L closepath F
.82143 .02381 -1.875 0 Mabsadd m
.82143 .02381 0 2.5 Mabsadd L
.82143 .02381 1.875 0 Mabsadd L
.82143 .02381 0 -2.5 Mabsadd L
.82143 .02381 -1.875 0 Mabsadd L closepath F
.82292 .02381 -1.875 0 Mabsadd m
.82292 .02381 0 2.5 Mabsadd L
.82292 .02381 1.875 0 Mabsadd L
.82292 .02381 0 -2.5 Mabsadd L
.82292 .02381 -1.875 0 Mabsadd L closepath F
.8244 .02381 -1.875 0 Mabsadd m
.8244 .02381 0 2.5 Mabsadd L
.8244 .02381 1.875 0 Mabsadd L
.8244 .02381 0 -2.5 Mabsadd L
.8244 .02381 -1.875 0 Mabsadd L closepath F
.82589 .02381 -1.875 0 Mabsadd m
.82589 .02381 0 2.5 Mabsadd L
.82589 .02381 1.875 0 Mabsadd L
.82589 .02381 0 -2.5 Mabsadd L
.82589 .02381 -1.875 0 Mabsadd L closepath F
.82738 .02381 -1.875 0 Mabsadd m
.82738 .02381 0 2.5 Mabsadd L
.82738 .02381 1.875 0 Mabsadd L
.82738 .02381 0 -2.5 Mabsadd L
.82738 .02381 -1.875 0 Mabsadd L closepath F
.82887 .02381 -1.875 0 Mabsadd m
.82887 .02381 0 2.5 Mabsadd L
.82887 .02381 1.875 0 Mabsadd L
.82887 .02381 0 -2.5 Mabsadd L
.82887 .02381 -1.875 0 Mabsadd L closepath F
.83036 .02381 -1.875 0 Mabsadd m
.83036 .02381 0 2.5 Mabsadd L
.83036 .02381 1.875 0 Mabsadd L
.83036 .02381 0 -2.5 Mabsadd L
.83036 .02381 -1.875 0 Mabsadd L closepath F
.83185 .02381 -1.875 0 Mabsadd m
.83185 .02381 0 2.5 Mabsadd L
.83185 .02381 1.875 0 Mabsadd L
.83185 .02381 0 -2.5 Mabsadd L
.83185 .02381 -1.875 0 Mabsadd L closepath F
.83333 .02381 -1.875 0 Mabsadd m
.83333 .02381 0 2.5 Mabsadd L
.83333 .02381 1.875 0 Mabsadd L
.83333 .02381 0 -2.5 Mabsadd L
.83333 .02381 -1.875 0 Mabsadd L closepath F
.83482 .02381 -1.875 0 Mabsadd m
.83482 .02381 0 2.5 Mabsadd L
.83482 .02381 1.875 0 Mabsadd L
.83482 .02381 0 -2.5 Mabsadd L
.83482 .02381 -1.875 0 Mabsadd L closepath F
.83631 .02381 -1.875 0 Mabsadd m
.83631 .02381 0 2.5 Mabsadd L
.83631 .02381 1.875 0 Mabsadd L
.83631 .02381 0 -2.5 Mabsadd L
.83631 .02381 -1.875 0 Mabsadd L closepath F
.8378 .02381 -1.875 0 Mabsadd m
.8378 .02381 0 2.5 Mabsadd L
.8378 .02381 1.875 0 Mabsadd L
.8378 .02381 0 -2.5 Mabsadd L
.8378 .02381 -1.875 0 Mabsadd L closepath F
.83929 .02381 -1.875 0 Mabsadd m
.83929 .02381 0 2.5 Mabsadd L
.83929 .02381 1.875 0 Mabsadd L
.83929 .02381 0 -2.5 Mabsadd L
.83929 .02381 -1.875 0 Mabsadd L closepath F
.84077 .02381 -1.875 0 Mabsadd m
.84077 .02381 0 2.5 Mabsadd L
.84077 .02381 1.875 0 Mabsadd L
.84077 .02381 0 -2.5 Mabsadd L
.84077 .02381 -1.875 0 Mabsadd L closepath F
.84226 .02381 -1.875 0 Mabsadd m
.84226 .02381 0 2.5 Mabsadd L
.84226 .02381 1.875 0 Mabsadd L
.84226 .02381 0 -2.5 Mabsadd L
.84226 .02381 -1.875 0 Mabsadd L closepath F
.84375 .02381 -1.875 0 Mabsadd m
.84375 .02381 0 2.5 Mabsadd L
.84375 .02381 1.875 0 Mabsadd L
.84375 .02381 0 -2.5 Mabsadd L
.84375 .02381 -1.875 0 Mabsadd L closepath F
.84524 .02381 -1.875 0 Mabsadd m
.84524 .02381 0 2.5 Mabsadd L
.84524 .02381 1.875 0 Mabsadd L
.84524 .02381 0 -2.5 Mabsadd L
.84524 .02381 -1.875 0 Mabsadd L closepath F
.84673 .02381 -1.875 0 Mabsadd m
.84673 .02381 0 2.5 Mabsadd L
.84673 .02381 1.875 0 Mabsadd L
.84673 .02381 0 -2.5 Mabsadd L
.84673 .02381 -1.875 0 Mabsadd L closepath F
.84821 .02381 -1.875 0 Mabsadd m
.84821 .02381 0 2.5 Mabsadd L
.84821 .02381 1.875 0 Mabsadd L
.84821 .02381 0 -2.5 Mabsadd L
.84821 .02381 -1.875 0 Mabsadd L closepath F
.8497 .02381 -1.875 0 Mabsadd m
.8497 .02381 0 2.5 Mabsadd L
.8497 .02381 1.875 0 Mabsadd L
.8497 .02381 0 -2.5 Mabsadd L
.8497 .02381 -1.875 0 Mabsadd L closepath F
.85119 .02381 -1.875 0 Mabsadd m
.85119 .02381 0 2.5 Mabsadd L
.85119 .02381 1.875 0 Mabsadd L
.85119 .02381 0 -2.5 Mabsadd L
.85119 .02381 -1.875 0 Mabsadd L closepath F
.85268 .02381 -1.875 0 Mabsadd m
.85268 .02381 0 2.5 Mabsadd L
.85268 .02381 1.875 0 Mabsadd L
.85268 .02381 0 -2.5 Mabsadd L
.85268 .02381 -1.875 0 Mabsadd L closepath F
.85417 .02381 -1.875 0 Mabsadd m
.85417 .02381 0 2.5 Mabsadd L
.85417 .02381 1.875 0 Mabsadd L
.85417 .02381 0 -2.5 Mabsadd L
.85417 .02381 -1.875 0 Mabsadd L closepath F
.85565 .02381 -1.875 0 Mabsadd m
.85565 .02381 0 2.5 Mabsadd L
.85565 .02381 1.875 0 Mabsadd L
.85565 .02381 0 -2.5 Mabsadd L
.85565 .02381 -1.875 0 Mabsadd L closepath F
.85714 .02381 -1.875 0 Mabsadd m
.85714 .02381 0 2.5 Mabsadd L
.85714 .02381 1.875 0 Mabsadd L
.85714 .02381 0 -2.5 Mabsadd L
.85714 .02381 -1.875 0 Mabsadd L closepath F
.85863 .02381 -1.875 0 Mabsadd m
.85863 .02381 0 2.5 Mabsadd L
.85863 .02381 1.875 0 Mabsadd L
.85863 .02381 0 -2.5 Mabsadd L
.85863 .02381 -1.875 0 Mabsadd L closepath F
.86012 .02381 -1.875 0 Mabsadd m
.86012 .02381 0 2.5 Mabsadd L
.86012 .02381 1.875 0 Mabsadd L
.86012 .02381 0 -2.5 Mabsadd L
.86012 .02381 -1.875 0 Mabsadd L closepath F
.86161 .02381 -1.875 0 Mabsadd m
.86161 .02381 0 2.5 Mabsadd L
.86161 .02381 1.875 0 Mabsadd L
.86161 .02381 0 -2.5 Mabsadd L
.86161 .02381 -1.875 0 Mabsadd L closepath F
.8631 .02381 -1.875 0 Mabsadd m
.8631 .02381 0 2.5 Mabsadd L
.8631 .02381 1.875 0 Mabsadd L
.8631 .02381 0 -2.5 Mabsadd L
.8631 .02381 -1.875 0 Mabsadd L closepath F
.86458 .02381 -1.875 0 Mabsadd m
.86458 .02381 0 2.5 Mabsadd L
.86458 .02381 1.875 0 Mabsadd L
.86458 .02381 0 -2.5 Mabsadd L
.86458 .02381 -1.875 0 Mabsadd L closepath F
.86607 .02381 -1.875 0 Mabsadd m
.86607 .02381 0 2.5 Mabsadd L
.86607 .02381 1.875 0 Mabsadd L
.86607 .02381 0 -2.5 Mabsadd L
.86607 .02381 -1.875 0 Mabsadd L closepath F
.86756 .02381 -1.875 0 Mabsadd m
.86756 .02381 0 2.5 Mabsadd L
.86756 .02381 1.875 0 Mabsadd L
.86756 .02381 0 -2.5 Mabsadd L
.86756 .02381 -1.875 0 Mabsadd L closepath F
.86905 .02381 -1.875 0 Mabsadd m
.86905 .02381 0 2.5 Mabsadd L
.86905 .02381 1.875 0 Mabsadd L
.86905 .02381 0 -2.5 Mabsadd L
.86905 .02381 -1.875 0 Mabsadd L closepath F
.87054 .02381 -1.875 0 Mabsadd m
.87054 .02381 0 2.5 Mabsadd L
.87054 .02381 1.875 0 Mabsadd L
.87054 .02381 0 -2.5 Mabsadd L
.87054 .02381 -1.875 0 Mabsadd L closepath F
.87202 .02381 -1.875 0 Mabsadd m
.87202 .02381 0 2.5 Mabsadd L
.87202 .02381 1.875 0 Mabsadd L
.87202 .02381 0 -2.5 Mabsadd L
.87202 .02381 -1.875 0 Mabsadd L closepath F
.87351 .02381 -1.875 0 Mabsadd m
.87351 .02381 0 2.5 Mabsadd L
.87351 .02381 1.875 0 Mabsadd L
.87351 .02381 0 -2.5 Mabsadd L
.87351 .02381 -1.875 0 Mabsadd L closepath F
.875 .02381 -1.875 0 Mabsadd m
.875 .02381 0 2.5 Mabsadd L
.875 .02381 1.875 0 Mabsadd L
.875 .02381 0 -2.5 Mabsadd L
.875 .02381 -1.875 0 Mabsadd L closepath F
.87649 .02381 -1.875 0 Mabsadd m
.87649 .02381 0 2.5 Mabsadd L
.87649 .02381 1.875 0 Mabsadd L
.87649 .02381 0 -2.5 Mabsadd L
.87649 .02381 -1.875 0 Mabsadd L closepath F
.87798 .02381 -1.875 0 Mabsadd m
.87798 .02381 0 2.5 Mabsadd L
.87798 .02381 1.875 0 Mabsadd L
.87798 .02381 0 -2.5 Mabsadd L
.87798 .02381 -1.875 0 Mabsadd L closepath F
.87946 .02381 -1.875 0 Mabsadd m
.87946 .02381 0 2.5 Mabsadd L
.87946 .02381 1.875 0 Mabsadd L
.87946 .02381 0 -2.5 Mabsadd L
.87946 .02381 -1.875 0 Mabsadd L closepath F
.88095 .02381 -1.875 0 Mabsadd m
.88095 .02381 0 2.5 Mabsadd L
.88095 .02381 1.875 0 Mabsadd L
.88095 .02381 0 -2.5 Mabsadd L
.88095 .02381 -1.875 0 Mabsadd L closepath F
.88244 .02381 -1.875 0 Mabsadd m
.88244 .02381 0 2.5 Mabsadd L
.88244 .02381 1.875 0 Mabsadd L
.88244 .02381 0 -2.5 Mabsadd L
.88244 .02381 -1.875 0 Mabsadd L closepath F
.88393 .02381 -1.875 0 Mabsadd m
.88393 .02381 0 2.5 Mabsadd L
.88393 .02381 1.875 0 Mabsadd L
.88393 .02381 0 -2.5 Mabsadd L
.88393 .02381 -1.875 0 Mabsadd L closepath F
.88542 .02381 -1.875 0 Mabsadd m
.88542 .02381 0 2.5 Mabsadd L
.88542 .02381 1.875 0 Mabsadd L
.88542 .02381 0 -2.5 Mabsadd L
.88542 .02381 -1.875 0 Mabsadd L closepath F
.8869 .02381 -1.875 0 Mabsadd m
.8869 .02381 0 2.5 Mabsadd L
.8869 .02381 1.875 0 Mabsadd L
.8869 .02381 0 -2.5 Mabsadd L
.8869 .02381 -1.875 0 Mabsadd L closepath F
.88839 .02381 -1.875 0 Mabsadd m
.88839 .02381 0 2.5 Mabsadd L
.88839 .02381 1.875 0 Mabsadd L
.88839 .02381 0 -2.5 Mabsadd L
.88839 .02381 -1.875 0 Mabsadd L closepath F
.88988 .02381 -1.875 0 Mabsadd m
.88988 .02381 0 2.5 Mabsadd L
.88988 .02381 1.875 0 Mabsadd L
.88988 .02381 0 -2.5 Mabsadd L
.88988 .02381 -1.875 0 Mabsadd L closepath F
.89137 .02381 -1.875 0 Mabsadd m
.89137 .02381 0 2.5 Mabsadd L
.89137 .02381 1.875 0 Mabsadd L
.89137 .02381 0 -2.5 Mabsadd L
.89137 .02381 -1.875 0 Mabsadd L closepath F
.89286 .02381 -1.875 0 Mabsadd m
.89286 .02381 0 2.5 Mabsadd L
.89286 .02381 1.875 0 Mabsadd L
.89286 .02381 0 -2.5 Mabsadd L
.89286 .02381 -1.875 0 Mabsadd L closepath F
.89435 .02381 -1.875 0 Mabsadd m
.89435 .02381 0 2.5 Mabsadd L
.89435 .02381 1.875 0 Mabsadd L
.89435 .02381 0 -2.5 Mabsadd L
.89435 .02381 -1.875 0 Mabsadd L closepath F
.89583 .02381 -1.875 0 Mabsadd m
.89583 .02381 0 2.5 Mabsadd L
.89583 .02381 1.875 0 Mabsadd L
.89583 .02381 0 -2.5 Mabsadd L
.89583 .02381 -1.875 0 Mabsadd L closepath F
.89732 .02381 -1.875 0 Mabsadd m
.89732 .02381 0 2.5 Mabsadd L
.89732 .02381 1.875 0 Mabsadd L
.89732 .02381 0 -2.5 Mabsadd L
.89732 .02381 -1.875 0 Mabsadd L closepath F
.89881 .02381 -1.875 0 Mabsadd m
.89881 .02381 0 2.5 Mabsadd L
.89881 .02381 1.875 0 Mabsadd L
.89881 .02381 0 -2.5 Mabsadd L
.89881 .02381 -1.875 0 Mabsadd L closepath F
.9003 .02381 -1.875 0 Mabsadd m
.9003 .02381 0 2.5 Mabsadd L
.9003 .02381 1.875 0 Mabsadd L
.9003 .02381 0 -2.5 Mabsadd L
.9003 .02381 -1.875 0 Mabsadd L closepath F
.90179 .02381 -1.875 0 Mabsadd m
.90179 .02381 0 2.5 Mabsadd L
.90179 .02381 1.875 0 Mabsadd L
.90179 .02381 0 -2.5 Mabsadd L
.90179 .02381 -1.875 0 Mabsadd L closepath F
.90327 .02381 -1.875 0 Mabsadd m
.90327 .02381 0 2.5 Mabsadd L
.90327 .02381 1.875 0 Mabsadd L
.90327 .02381 0 -2.5 Mabsadd L
.90327 .02381 -1.875 0 Mabsadd L closepath F
.90476 .02381 -1.875 0 Mabsadd m
.90476 .02381 0 2.5 Mabsadd L
.90476 .02381 1.875 0 Mabsadd L
.90476 .02381 0 -2.5 Mabsadd L
.90476 .02381 -1.875 0 Mabsadd L closepath F
.90625 .02381 -1.875 0 Mabsadd m
.90625 .02381 0 2.5 Mabsadd L
.90625 .02381 1.875 0 Mabsadd L
.90625 .02381 0 -2.5 Mabsadd L
.90625 .02381 -1.875 0 Mabsadd L closepath F
.90774 .02381 -1.875 0 Mabsadd m
.90774 .02381 0 2.5 Mabsadd L
.90774 .02381 1.875 0 Mabsadd L
.90774 .02381 0 -2.5 Mabsadd L
.90774 .02381 -1.875 0 Mabsadd L closepath F
.90923 .02381 -1.875 0 Mabsadd m
.90923 .02381 0 2.5 Mabsadd L
.90923 .02381 1.875 0 Mabsadd L
.90923 .02381 0 -2.5 Mabsadd L
.90923 .02381 -1.875 0 Mabsadd L closepath F
.91071 .02381 -1.875 0 Mabsadd m
.91071 .02381 0 2.5 Mabsadd L
.91071 .02381 1.875 0 Mabsadd L
.91071 .02381 0 -2.5 Mabsadd L
.91071 .02381 -1.875 0 Mabsadd L closepath F
.9122 .02381 -1.875 0 Mabsadd m
.9122 .02381 0 2.5 Mabsadd L
.9122 .02381 1.875 0 Mabsadd L
.9122 .02381 0 -2.5 Mabsadd L
.9122 .02381 -1.875 0 Mabsadd L closepath F
.91369 .02381 -1.875 0 Mabsadd m
.91369 .02381 0 2.5 Mabsadd L
.91369 .02381 1.875 0 Mabsadd L
.91369 .02381 0 -2.5 Mabsadd L
.91369 .02381 -1.875 0 Mabsadd L closepath F
.91518 .02381 -1.875 0 Mabsadd m
.91518 .02381 0 2.5 Mabsadd L
.91518 .02381 1.875 0 Mabsadd L
.91518 .02381 0 -2.5 Mabsadd L
.91518 .02381 -1.875 0 Mabsadd L closepath F
.91667 .02381 -1.875 0 Mabsadd m
.91667 .02381 0 2.5 Mabsadd L
.91667 .02381 1.875 0 Mabsadd L
.91667 .02381 0 -2.5 Mabsadd L
.91667 .02381 -1.875 0 Mabsadd L closepath F
.91815 .02381 -1.875 0 Mabsadd m
.91815 .02381 0 2.5 Mabsadd L
.91815 .02381 1.875 0 Mabsadd L
.91815 .02381 0 -2.5 Mabsadd L
.91815 .02381 -1.875 0 Mabsadd L closepath F
.91964 .02381 -1.875 0 Mabsadd m
.91964 .02381 0 2.5 Mabsadd L
.91964 .02381 1.875 0 Mabsadd L
.91964 .02381 0 -2.5 Mabsadd L
.91964 .02381 -1.875 0 Mabsadd L closepath F
.92113 .02381 -1.875 0 Mabsadd m
.92113 .02381 0 2.5 Mabsadd L
.92113 .02381 1.875 0 Mabsadd L
.92113 .02381 0 -2.5 Mabsadd L
.92113 .02381 -1.875 0 Mabsadd L closepath F
.92262 .02381 -1.875 0 Mabsadd m
.92262 .02381 0 2.5 Mabsadd L
.92262 .02381 1.875 0 Mabsadd L
.92262 .02381 0 -2.5 Mabsadd L
.92262 .02381 -1.875 0 Mabsadd L closepath F
.92411 .02381 -1.875 0 Mabsadd m
.92411 .02381 0 2.5 Mabsadd L
.92411 .02381 1.875 0 Mabsadd L
.92411 .02381 0 -2.5 Mabsadd L
.92411 .02381 -1.875 0 Mabsadd L closepath F
.9256 .02381 -1.875 0 Mabsadd m
.9256 .02381 0 2.5 Mabsadd L
.9256 .02381 1.875 0 Mabsadd L
.9256 .02381 0 -2.5 Mabsadd L
.9256 .02381 -1.875 0 Mabsadd L closepath F
.92708 .02381 -1.875 0 Mabsadd m
.92708 .02381 0 2.5 Mabsadd L
.92708 .02381 1.875 0 Mabsadd L
.92708 .02381 0 -2.5 Mabsadd L
.92708 .02381 -1.875 0 Mabsadd L closepath F
.92857 .02381 -1.875 0 Mabsadd m
.92857 .02381 0 2.5 Mabsadd L
.92857 .02381 1.875 0 Mabsadd L
.92857 .02381 0 -2.5 Mabsadd L
.92857 .02381 -1.875 0 Mabsadd L closepath F
.93006 .02381 -1.875 0 Mabsadd m
.93006 .02381 0 2.5 Mabsadd L
.93006 .02381 1.875 0 Mabsadd L
.93006 .02381 0 -2.5 Mabsadd L
.93006 .02381 -1.875 0 Mabsadd L closepath F
.93155 .02381 -1.875 0 Mabsadd m
.93155 .02381 0 2.5 Mabsadd L
.93155 .02381 1.875 0 Mabsadd L
.93155 .02381 0 -2.5 Mabsadd L
.93155 .02381 -1.875 0 Mabsadd L closepath F
.93304 .02381 -1.875 0 Mabsadd m
.93304 .02381 0 2.5 Mabsadd L
.93304 .02381 1.875 0 Mabsadd L
.93304 .02381 0 -2.5 Mabsadd L
.93304 .02381 -1.875 0 Mabsadd L closepath F
.93452 .02381 -1.875 0 Mabsadd m
.93452 .02381 0 2.5 Mabsadd L
.93452 .02381 1.875 0 Mabsadd L
.93452 .02381 0 -2.5 Mabsadd L
.93452 .02381 -1.875 0 Mabsadd L closepath F
.93601 .02381 -1.875 0 Mabsadd m
.93601 .02381 0 2.5 Mabsadd L
.93601 .02381 1.875 0 Mabsadd L
.93601 .02381 0 -2.5 Mabsadd L
.93601 .02381 -1.875 0 Mabsadd L closepath F
.9375 .02381 -1.875 0 Mabsadd m
.9375 .02381 0 2.5 Mabsadd L
.9375 .02381 1.875 0 Mabsadd L
.9375 .02381 0 -2.5 Mabsadd L
.9375 .02381 -1.875 0 Mabsadd L closepath F
.93899 .02381 -1.875 0 Mabsadd m
.93899 .02381 0 2.5 Mabsadd L
.93899 .02381 1.875 0 Mabsadd L
.93899 .02381 0 -2.5 Mabsadd L
.93899 .02381 -1.875 0 Mabsadd L closepath F
.94048 .02381 -1.875 0 Mabsadd m
.94048 .02381 0 2.5 Mabsadd L
.94048 .02381 1.875 0 Mabsadd L
.94048 .02381 0 -2.5 Mabsadd L
.94048 .02381 -1.875 0 Mabsadd L closepath F
.94196 .02381 -1.875 0 Mabsadd m
.94196 .02381 0 2.5 Mabsadd L
.94196 .02381 1.875 0 Mabsadd L
.94196 .02381 0 -2.5 Mabsadd L
.94196 .02381 -1.875 0 Mabsadd L closepath F
.94345 .02381 -1.875 0 Mabsadd m
.94345 .02381 0 2.5 Mabsadd L
.94345 .02381 1.875 0 Mabsadd L
.94345 .02381 0 -2.5 Mabsadd L
.94345 .02381 -1.875 0 Mabsadd L closepath F
.94494 .02381 -1.875 0 Mabsadd m
.94494 .02381 0 2.5 Mabsadd L
.94494 .02381 1.875 0 Mabsadd L
.94494 .02381 0 -2.5 Mabsadd L
.94494 .02381 -1.875 0 Mabsadd L closepath F
.94643 .02381 -1.875 0 Mabsadd m
.94643 .02381 0 2.5 Mabsadd L
.94643 .02381 1.875 0 Mabsadd L
.94643 .02381 0 -2.5 Mabsadd L
.94643 .02381 -1.875 0 Mabsadd L closepath F
.94792 .02381 -1.875 0 Mabsadd m
.94792 .02381 0 2.5 Mabsadd L
.94792 .02381 1.875 0 Mabsadd L
.94792 .02381 0 -2.5 Mabsadd L
.94792 .02381 -1.875 0 Mabsadd L closepath F
.9494 .02381 -1.875 0 Mabsadd m
.9494 .02381 0 2.5 Mabsadd L
.9494 .02381 1.875 0 Mabsadd L
.9494 .02381 0 -2.5 Mabsadd L
.9494 .02381 -1.875 0 Mabsadd L closepath F
.95089 .02381 -1.875 0 Mabsadd m
.95089 .02381 0 2.5 Mabsadd L
.95089 .02381 1.875 0 Mabsadd L
.95089 .02381 0 -2.5 Mabsadd L
.95089 .02381 -1.875 0 Mabsadd L closepath F
.95238 .02381 -1.875 0 Mabsadd m
.95238 .02381 0 2.5 Mabsadd L
.95238 .02381 1.875 0 Mabsadd L
.95238 .02381 0 -2.5 Mabsadd L
.95238 .02381 -1.875 0 Mabsadd L closepath F
.95387 .02381 -1.875 0 Mabsadd m
.95387 .02381 0 2.5 Mabsadd L
.95387 .02381 1.875 0 Mabsadd L
.95387 .02381 0 -2.5 Mabsadd L
.95387 .02381 -1.875 0 Mabsadd L closepath F
.95536 .02381 -1.875 0 Mabsadd m
.95536 .02381 0 2.5 Mabsadd L
.95536 .02381 1.875 0 Mabsadd L
.95536 .02381 0 -2.5 Mabsadd L
.95536 .02381 -1.875 0 Mabsadd L closepath F
.95685 .02381 -1.875 0 Mabsadd m
.95685 .02381 0 2.5 Mabsadd L
.95685 .02381 1.875 0 Mabsadd L
.95685 .02381 0 -2.5 Mabsadd L
.95685 .02381 -1.875 0 Mabsadd L closepath F
.95833 .02381 -1.875 0 Mabsadd m
.95833 .02381 0 2.5 Mabsadd L
.95833 .02381 1.875 0 Mabsadd L
.95833 .02381 0 -2.5 Mabsadd L
.95833 .02381 -1.875 0 Mabsadd L closepath F
.95982 .02381 -1.875 0 Mabsadd m
.95982 .02381 0 2.5 Mabsadd L
.95982 .02381 1.875 0 Mabsadd L
.95982 .02381 0 -2.5 Mabsadd L
.95982 .02381 -1.875 0 Mabsadd L closepath F
.96131 .02381 -1.875 0 Mabsadd m
.96131 .02381 0 2.5 Mabsadd L
.96131 .02381 1.875 0 Mabsadd L
.96131 .02381 0 -2.5 Mabsadd L
.96131 .02381 -1.875 0 Mabsadd L closepath F
.9628 .02381 -1.875 0 Mabsadd m
.9628 .02381 0 2.5 Mabsadd L
.9628 .02381 1.875 0 Mabsadd L
.9628 .02381 0 -2.5 Mabsadd L
.9628 .02381 -1.875 0 Mabsadd L closepath F
.96429 .02381 -1.875 0 Mabsadd m
.96429 .02381 0 2.5 Mabsadd L
.96429 .02381 1.875 0 Mabsadd L
.96429 .02381 0 -2.5 Mabsadd L
.96429 .02381 -1.875 0 Mabsadd L closepath F
.96577 .02381 -1.875 0 Mabsadd m
.96577 .02381 0 2.5 Mabsadd L
.96577 .02381 1.875 0 Mabsadd L
.96577 .02381 0 -2.5 Mabsadd L
.96577 .02381 -1.875 0 Mabsadd L closepath F
.96726 .02381 -1.875 0 Mabsadd m
.96726 .02381 0 2.5 Mabsadd L
.96726 .02381 1.875 0 Mabsadd L
.96726 .02381 0 -2.5 Mabsadd L
.96726 .02381 -1.875 0 Mabsadd L closepath F
.96875 .02381 -1.875 0 Mabsadd m
.96875 .02381 0 2.5 Mabsadd L
.96875 .02381 1.875 0 Mabsadd L
.96875 .02381 0 -2.5 Mabsadd L
.96875 .02381 -1.875 0 Mabsadd L closepath F
.97024 .02381 -1.875 0 Mabsadd m
.97024 .02381 0 2.5 Mabsadd L
.97024 .02381 1.875 0 Mabsadd L
.97024 .02381 0 -2.5 Mabsadd L
.97024 .02381 -1.875 0 Mabsadd L closepath F
.97173 .02381 -1.875 0 Mabsadd m
.97173 .02381 0 2.5 Mabsadd L
.97173 .02381 1.875 0 Mabsadd L
.97173 .02381 0 -2.5 Mabsadd L
.97173 .02381 -1.875 0 Mabsadd L closepath F
.97321 .02381 -1.875 0 Mabsadd m
.97321 .02381 0 2.5 Mabsadd L
.97321 .02381 1.875 0 Mabsadd L
.97321 .02381 0 -2.5 Mabsadd L
.97321 .02381 -1.875 0 Mabsadd L closepath F
.9747 .02381 -1.875 0 Mabsadd m
.9747 .02381 0 2.5 Mabsadd L
.9747 .02381 1.875 0 Mabsadd L
.9747 .02381 0 -2.5 Mabsadd L
.9747 .02381 -1.875 0 Mabsadd L closepath F
.97545 .02381 -1.875 0 Mabsadd m
.97545 .02381 0 2.5 Mabsadd L
.97545 .02381 1.875 0 Mabsadd L
.97545 .02381 0 -2.5 Mabsadd L
.97545 .02381 -1.875 0 Mabsadd L closepath F
.97619 .02381 -1.875 0 Mabsadd m
.97619 .02381 0 2.5 Mabsadd L
.97619 .02381 1.875 0 Mabsadd L
.97619 .02381 0 -2.5 Mabsadd L
.97619 .02381 -1.875 0 Mabsadd L closepath F
0 0 1 r
.02381 .02381 0 2.5 Mabsadd m
.02381 .02381 -0.56518 .7779 Mabsadd L
.02381 .02381 -2.37764 .77254 Mabsadd L
.02381 .02381 -0.91448 -0.29713 Mabsadd L
.02381 .02381 -1.46946 -2.02254 Mabsadd L
.02381 .02381 0 -0.96154 Mabsadd L
.02381 .02381 1.46946 -2.02254 Mabsadd L
.02381 .02381 .91448 -0.29713 Mabsadd L
.02381 .02381 2.37764 .77254 Mabsadd L
.02381 .02381 .56518 .7779 Mabsadd L
.02381 .02381 0 2.5 Mabsadd L closepath F
.0253 .02534 0 2.5 Mabsadd m
.0253 .02534 -0.56518 .7779 Mabsadd L
.0253 .02534 -2.37764 .77254 Mabsadd L
.0253 .02534 -0.91448 -0.29713 Mabsadd L
.0253 .02534 -1.46946 -2.02254 Mabsadd L
.0253 .02534 0 -0.96154 Mabsadd L
.0253 .02534 1.46946 -2.02254 Mabsadd L
.0253 .02534 .91448 -0.29713 Mabsadd L
.0253 .02534 2.37764 .77254 Mabsadd L
.0253 .02534 .56518 .7779 Mabsadd L
.0253 .02534 0 2.5 Mabsadd L closepath F
.02679 .02686 0 2.5 Mabsadd m
.02679 .02686 -0.56518 .7779 Mabsadd L
.02679 .02686 -2.37764 .77254 Mabsadd L
.02679 .02686 -0.91448 -0.29713 Mabsadd L
.02679 .02686 -1.46946 -2.02254 Mabsadd L
.02679 .02686 0 -0.96154 Mabsadd L
.02679 .02686 1.46946 -2.02254 Mabsadd L
.02679 .02686 .91448 -0.29713 Mabsadd L
.02679 .02686 2.37764 .77254 Mabsadd L
.02679 .02686 .56518 .7779 Mabsadd L
.02679 .02686 0 2.5 Mabsadd L closepath F
.02827 .02839 0 2.5 Mabsadd m
.02827 .02839 -0.56518 .7779 Mabsadd L
.02827 .02839 -2.37764 .77254 Mabsadd L
.02827 .02839 -0.91448 -0.29713 Mabsadd L
.02827 .02839 -1.46946 -2.02254 Mabsadd L
.02827 .02839 0 -0.96154 Mabsadd L
.02827 .02839 1.46946 -2.02254 Mabsadd L
.02827 .02839 .91448 -0.29713 Mabsadd L
.02827 .02839 2.37764 .77254 Mabsadd L
.02827 .02839 .56518 .7779 Mabsadd L
.02827 .02839 0 2.5 Mabsadd L closepath F
.02976 .02992 0 2.5 Mabsadd m
.02976 .02992 -0.56518 .7779 Mabsadd L
.02976 .02992 -2.37764 .77254 Mabsadd L
.02976 .02992 -0.91448 -0.29713 Mabsadd L
.02976 .02992 -1.46946 -2.02254 Mabsadd L
.02976 .02992 0 -0.96154 Mabsadd L
.02976 .02992 1.46946 -2.02254 Mabsadd L
.02976 .02992 .91448 -0.29713 Mabsadd L
.02976 .02992 2.37764 .77254 Mabsadd L
.02976 .02992 .56518 .7779 Mabsadd L
.02976 .02992 0 2.5 Mabsadd L closepath F
.03125 .03145 0 2.5 Mabsadd m
.03125 .03145 -0.56518 .7779 Mabsadd L
.03125 .03145 -2.37764 .77254 Mabsadd L
.03125 .03145 -0.91448 -0.29713 Mabsadd L
.03125 .03145 -1.46946 -2.02254 Mabsadd L
.03125 .03145 0 -0.96154 Mabsadd L
.03125 .03145 1.46946 -2.02254 Mabsadd L
.03125 .03145 .91448 -0.29713 Mabsadd L
.03125 .03145 2.37764 .77254 Mabsadd L
.03125 .03145 .56518 .7779 Mabsadd L
.03125 .03145 0 2.5 Mabsadd L closepath F
.03274 .03297 0 2.5 Mabsadd m
.03274 .03297 -0.56518 .7779 Mabsadd L
.03274 .03297 -2.37764 .77254 Mabsadd L
.03274 .03297 -0.91448 -0.29713 Mabsadd L
.03274 .03297 -1.46946 -2.02254 Mabsadd L
.03274 .03297 0 -0.96154 Mabsadd L
.03274 .03297 1.46946 -2.02254 Mabsadd L
.03274 .03297 .91448 -0.29713 Mabsadd L
.03274 .03297 2.37764 .77254 Mabsadd L
.03274 .03297 .56518 .7779 Mabsadd L
.03274 .03297 0 2.5 Mabsadd L closepath F
.03423 .0345 0 2.5 Mabsadd m
.03423 .0345 -0.56518 .7779 Mabsadd L
.03423 .0345 -2.37764 .77254 Mabsadd L
.03423 .0345 -0.91448 -0.29713 Mabsadd L
.03423 .0345 -1.46946 -2.02254 Mabsadd L
.03423 .0345 0 -0.96154 Mabsadd L
.03423 .0345 1.46946 -2.02254 Mabsadd L
.03423 .0345 .91448 -0.29713 Mabsadd L
.03423 .0345 2.37764 .77254 Mabsadd L
.03423 .0345 .56518 .7779 Mabsadd L
.03423 .0345 0 2.5 Mabsadd L closepath F
.03571 .03603 0 2.5 Mabsadd m
.03571 .03603 -0.56518 .7779 Mabsadd L
.03571 .03603 -2.37764 .77254 Mabsadd L
.03571 .03603 -0.91448 -0.29713 Mabsadd L
.03571 .03603 -1.46946 -2.02254 Mabsadd L
.03571 .03603 0 -0.96154 Mabsadd L
.03571 .03603 1.46946 -2.02254 Mabsadd L
.03571 .03603 .91448 -0.29713 Mabsadd L
.03571 .03603 2.37764 .77254 Mabsadd L
.03571 .03603 .56518 .7779 Mabsadd L
.03571 .03603 0 2.5 Mabsadd L closepath F
.0372 .03756 0 2.5 Mabsadd m
.0372 .03756 -0.56518 .7779 Mabsadd L
.0372 .03756 -2.37764 .77254 Mabsadd L
.0372 .03756 -0.91448 -0.29713 Mabsadd L
.0372 .03756 -1.46946 -2.02254 Mabsadd L
.0372 .03756 0 -0.96154 Mabsadd L
.0372 .03756 1.46946 -2.02254 Mabsadd L
.0372 .03756 .91448 -0.29713 Mabsadd L
.0372 .03756 2.37764 .77254 Mabsadd L
.0372 .03756 .56518 .7779 Mabsadd L
.0372 .03756 0 2.5 Mabsadd L closepath F
.03869 .03909 0 2.5 Mabsadd m
.03869 .03909 -0.56518 .7779 Mabsadd L
.03869 .03909 -2.37764 .77254 Mabsadd L
.03869 .03909 -0.91448 -0.29713 Mabsadd L
.03869 .03909 -1.46946 -2.02254 Mabsadd L
.03869 .03909 0 -0.96154 Mabsadd L
.03869 .03909 1.46946 -2.02254 Mabsadd L
.03869 .03909 .91448 -0.29713 Mabsadd L
.03869 .03909 2.37764 .77254 Mabsadd L
.03869 .03909 .56518 .7779 Mabsadd L
.03869 .03909 0 2.5 Mabsadd L closepath F
.04018 .04061 0 2.5 Mabsadd m
.04018 .04061 -0.56518 .7779 Mabsadd L
.04018 .04061 -2.37764 .77254 Mabsadd L
.04018 .04061 -0.91448 -0.29713 Mabsadd L
.04018 .04061 -1.46946 -2.02254 Mabsadd L
.04018 .04061 0 -0.96154 Mabsadd L
.04018 .04061 1.46946 -2.02254 Mabsadd L
.04018 .04061 .91448 -0.29713 Mabsadd L
.04018 .04061 2.37764 .77254 Mabsadd L
.04018 .04061 .56518 .7779 Mabsadd L
.04018 .04061 0 2.5 Mabsadd L closepath F
.04167 .04214 0 2.5 Mabsadd m
.04167 .04214 -0.56518 .7779 Mabsadd L
.04167 .04214 -2.37764 .77254 Mabsadd L
.04167 .04214 -0.91448 -0.29713 Mabsadd L
.04167 .04214 -1.46946 -2.02254 Mabsadd L
.04167 .04214 0 -0.96154 Mabsadd L
.04167 .04214 1.46946 -2.02254 Mabsadd L
.04167 .04214 .91448 -0.29713 Mabsadd L
.04167 .04214 2.37764 .77254 Mabsadd L
.04167 .04214 .56518 .7779 Mabsadd L
.04167 .04214 0 2.5 Mabsadd L closepath F
.04315 .04367 0 2.5 Mabsadd m
.04315 .04367 -0.56518 .7779 Mabsadd L
.04315 .04367 -2.37764 .77254 Mabsadd L
.04315 .04367 -0.91448 -0.29713 Mabsadd L
.04315 .04367 -1.46946 -2.02254 Mabsadd L
.04315 .04367 0 -0.96154 Mabsadd L
.04315 .04367 1.46946 -2.02254 Mabsadd L
.04315 .04367 .91448 -0.29713 Mabsadd L
.04315 .04367 2.37764 .77254 Mabsadd L
.04315 .04367 .56518 .7779 Mabsadd L
.04315 .04367 0 2.5 Mabsadd L closepath F
.04464 .0452 0 2.5 Mabsadd m
.04464 .0452 -0.56518 .7779 Mabsadd L
.04464 .0452 -2.37764 .77254 Mabsadd L
.04464 .0452 -0.91448 -0.29713 Mabsadd L
.04464 .0452 -1.46946 -2.02254 Mabsadd L
.04464 .0452 0 -0.96154 Mabsadd L
.04464 .0452 1.46946 -2.02254 Mabsadd L
.04464 .0452 .91448 -0.29713 Mabsadd L
.04464 .0452 2.37764 .77254 Mabsadd L
.04464 .0452 .56518 .7779 Mabsadd L
.04464 .0452 0 2.5 Mabsadd L closepath F
.04613 .04673 0 2.5 Mabsadd m
.04613 .04673 -0.56518 .7779 Mabsadd L
.04613 .04673 -2.37764 .77254 Mabsadd L
.04613 .04673 -0.91448 -0.29713 Mabsadd L
.04613 .04673 -1.46946 -2.02254 Mabsadd L
.04613 .04673 0 -0.96154 Mabsadd L
.04613 .04673 1.46946 -2.02254 Mabsadd L
.04613 .04673 .91448 -0.29713 Mabsadd L
.04613 .04673 2.37764 .77254 Mabsadd L
.04613 .04673 .56518 .7779 Mabsadd L
.04613 .04673 0 2.5 Mabsadd L closepath F
.04762 .04825 0 2.5 Mabsadd m
.04762 .04825 -0.56518 .7779 Mabsadd L
.04762 .04825 -2.37764 .77254 Mabsadd L
.04762 .04825 -0.91448 -0.29713 Mabsadd L
.04762 .04825 -1.46946 -2.02254 Mabsadd L
.04762 .04825 0 -0.96154 Mabsadd L
.04762 .04825 1.46946 -2.02254 Mabsadd L
.04762 .04825 .91448 -0.29713 Mabsadd L
.04762 .04825 2.37764 .77254 Mabsadd L
.04762 .04825 .56518 .7779 Mabsadd L
.04762 .04825 0 2.5 Mabsadd L closepath F
.04911 .04978 0 2.5 Mabsadd m
.04911 .04978 -0.56518 .7779 Mabsadd L
.04911 .04978 -2.37764 .77254 Mabsadd L
.04911 .04978 -0.91448 -0.29713 Mabsadd L
.04911 .04978 -1.46946 -2.02254 Mabsadd L
.04911 .04978 0 -0.96154 Mabsadd L
.04911 .04978 1.46946 -2.02254 Mabsadd L
.04911 .04978 .91448 -0.29713 Mabsadd L
.04911 .04978 2.37764 .77254 Mabsadd L
.04911 .04978 .56518 .7779 Mabsadd L
.04911 .04978 0 2.5 Mabsadd L closepath F
.0506 .05131 0 2.5 Mabsadd m
.0506 .05131 -0.56518 .7779 Mabsadd L
.0506 .05131 -2.37764 .77254 Mabsadd L
.0506 .05131 -0.91448 -0.29713 Mabsadd L
.0506 .05131 -1.46946 -2.02254 Mabsadd L
.0506 .05131 0 -0.96154 Mabsadd L
.0506 .05131 1.46946 -2.02254 Mabsadd L
.0506 .05131 .91448 -0.29713 Mabsadd L
.0506 .05131 2.37764 .77254 Mabsadd L
.0506 .05131 .56518 .7779 Mabsadd L
.0506 .05131 0 2.5 Mabsadd L closepath F
.05208 .05284 0 2.5 Mabsadd m
.05208 .05284 -0.56518 .7779 Mabsadd L
.05208 .05284 -2.37764 .77254 Mabsadd L
.05208 .05284 -0.91448 -0.29713 Mabsadd L
.05208 .05284 -1.46946 -2.02254 Mabsadd L
.05208 .05284 0 -0.96154 Mabsadd L
.05208 .05284 1.46946 -2.02254 Mabsadd L
.05208 .05284 .91448 -0.29713 Mabsadd L
.05208 .05284 2.37764 .77254 Mabsadd L
.05208 .05284 .56518 .7779 Mabsadd L
.05208 .05284 0 2.5 Mabsadd L closepath F
.05357 .05437 0 2.5 Mabsadd m
.05357 .05437 -0.56518 .7779 Mabsadd L
.05357 .05437 -2.37764 .77254 Mabsadd L
.05357 .05437 -0.91448 -0.29713 Mabsadd L
.05357 .05437 -1.46946 -2.02254 Mabsadd L
.05357 .05437 0 -0.96154 Mabsadd L
.05357 .05437 1.46946 -2.02254 Mabsadd L
.05357 .05437 .91448 -0.29713 Mabsadd L
.05357 .05437 2.37764 .77254 Mabsadd L
.05357 .05437 .56518 .7779 Mabsadd L
.05357 .05437 0 2.5 Mabsadd L closepath F
.05506 .05589 0 2.5 Mabsadd m
.05506 .05589 -0.56518 .7779 Mabsadd L
.05506 .05589 -2.37764 .77254 Mabsadd L
.05506 .05589 -0.91448 -0.29713 Mabsadd L
.05506 .05589 -1.46946 -2.02254 Mabsadd L
.05506 .05589 0 -0.96154 Mabsadd L
.05506 .05589 1.46946 -2.02254 Mabsadd L
.05506 .05589 .91448 -0.29713 Mabsadd L
.05506 .05589 2.37764 .77254 Mabsadd L
.05506 .05589 .56518 .7779 Mabsadd L
.05506 .05589 0 2.5 Mabsadd L closepath F
.05655 .05742 0 2.5 Mabsadd m
.05655 .05742 -0.56518 .7779 Mabsadd L
.05655 .05742 -2.37764 .77254 Mabsadd L
.05655 .05742 -0.91448 -0.29713 Mabsadd L
.05655 .05742 -1.46946 -2.02254 Mabsadd L
.05655 .05742 0 -0.96154 Mabsadd L
.05655 .05742 1.46946 -2.02254 Mabsadd L
.05655 .05742 .91448 -0.29713 Mabsadd L
.05655 .05742 2.37764 .77254 Mabsadd L
.05655 .05742 .56518 .7779 Mabsadd L
.05655 .05742 0 2.5 Mabsadd L closepath F
.05804 .05895 0 2.5 Mabsadd m
.05804 .05895 -0.56518 .7779 Mabsadd L
.05804 .05895 -2.37764 .77254 Mabsadd L
.05804 .05895 -0.91448 -0.29713 Mabsadd L
.05804 .05895 -1.46946 -2.02254 Mabsadd L
.05804 .05895 0 -0.96154 Mabsadd L
.05804 .05895 1.46946 -2.02254 Mabsadd L
.05804 .05895 .91448 -0.29713 Mabsadd L
.05804 .05895 2.37764 .77254 Mabsadd L
.05804 .05895 .56518 .7779 Mabsadd L
.05804 .05895 0 2.5 Mabsadd L closepath F
.05952 .06048 0 2.5 Mabsadd m
.05952 .06048 -0.56518 .7779 Mabsadd L
.05952 .06048 -2.37764 .77254 Mabsadd L
.05952 .06048 -0.91448 -0.29713 Mabsadd L
.05952 .06048 -1.46946 -2.02254 Mabsadd L
.05952 .06048 0 -0.96154 Mabsadd L
.05952 .06048 1.46946 -2.02254 Mabsadd L
.05952 .06048 .91448 -0.29713 Mabsadd L
.05952 .06048 2.37764 .77254 Mabsadd L
.05952 .06048 .56518 .7779 Mabsadd L
.05952 .06048 0 2.5 Mabsadd L closepath F
.06101 .06201 0 2.5 Mabsadd m
.06101 .06201 -0.56518 .7779 Mabsadd L
.06101 .06201 -2.37764 .77254 Mabsadd L
.06101 .06201 -0.91448 -0.29713 Mabsadd L
.06101 .06201 -1.46946 -2.02254 Mabsadd L
.06101 .06201 0 -0.96154 Mabsadd L
.06101 .06201 1.46946 -2.02254 Mabsadd L
.06101 .06201 .91448 -0.29713 Mabsadd L
.06101 .06201 2.37764 .77254 Mabsadd L
.06101 .06201 .56518 .7779 Mabsadd L
.06101 .06201 0 2.5 Mabsadd L closepath F
.0625 .06353 0 2.5 Mabsadd m
.0625 .06353 -0.56518 .7779 Mabsadd L
.0625 .06353 -2.37764 .77254 Mabsadd L
.0625 .06353 -0.91448 -0.29713 Mabsadd L
.0625 .06353 -1.46946 -2.02254 Mabsadd L
.0625 .06353 0 -0.96154 Mabsadd L
.0625 .06353 1.46946 -2.02254 Mabsadd L
.0625 .06353 .91448 -0.29713 Mabsadd L
.0625 .06353 2.37764 .77254 Mabsadd L
.0625 .06353 .56518 .7779 Mabsadd L
.0625 .06353 0 2.5 Mabsadd L closepath F
.06399 .06506 0 2.5 Mabsadd m
.06399 .06506 -0.56518 .7779 Mabsadd L
.06399 .06506 -2.37764 .77254 Mabsadd L
.06399 .06506 -0.91448 -0.29713 Mabsadd L
.06399 .06506 -1.46946 -2.02254 Mabsadd L
.06399 .06506 0 -0.96154 Mabsadd L
.06399 .06506 1.46946 -2.02254 Mabsadd L
.06399 .06506 .91448 -0.29713 Mabsadd L
.06399 .06506 2.37764 .77254 Mabsadd L
.06399 .06506 .56518 .7779 Mabsadd L
.06399 .06506 0 2.5 Mabsadd L closepath F
.06548 .06659 0 2.5 Mabsadd m
.06548 .06659 -0.56518 .7779 Mabsadd L
.06548 .06659 -2.37764 .77254 Mabsadd L
.06548 .06659 -0.91448 -0.29713 Mabsadd L
.06548 .06659 -1.46946 -2.02254 Mabsadd L
.06548 .06659 0 -0.96154 Mabsadd L
.06548 .06659 1.46946 -2.02254 Mabsadd L
.06548 .06659 .91448 -0.29713 Mabsadd L
.06548 .06659 2.37764 .77254 Mabsadd L
.06548 .06659 .56518 .7779 Mabsadd L
.06548 .06659 0 2.5 Mabsadd L closepath F
.06696 .06812 0 2.5 Mabsadd m
.06696 .06812 -0.56518 .7779 Mabsadd L
.06696 .06812 -2.37764 .77254 Mabsadd L
.06696 .06812 -0.91448 -0.29713 Mabsadd L
.06696 .06812 -1.46946 -2.02254 Mabsadd L
.06696 .06812 0 -0.96154 Mabsadd L
.06696 .06812 1.46946 -2.02254 Mabsadd L
.06696 .06812 .91448 -0.29713 Mabsadd L
.06696 .06812 2.37764 .77254 Mabsadd L
.06696 .06812 .56518 .7779 Mabsadd L
.06696 .06812 0 2.5 Mabsadd L closepath F
.06845 .06965 0 2.5 Mabsadd m
.06845 .06965 -0.56518 .7779 Mabsadd L
.06845 .06965 -2.37764 .77254 Mabsadd L
.06845 .06965 -0.91448 -0.29713 Mabsadd L
.06845 .06965 -1.46946 -2.02254 Mabsadd L
.06845 .06965 0 -0.96154 Mabsadd L
.06845 .06965 1.46946 -2.02254 Mabsadd L
.06845 .06965 .91448 -0.29713 Mabsadd L
.06845 .06965 2.37764 .77254 Mabsadd L
.06845 .06965 .56518 .7779 Mabsadd L
.06845 .06965 0 2.5 Mabsadd L closepath F
.06994 .07118 0 2.5 Mabsadd m
.06994 .07118 -0.56518 .7779 Mabsadd L
.06994 .07118 -2.37764 .77254 Mabsadd L
.06994 .07118 -0.91448 -0.29713 Mabsadd L
.06994 .07118 -1.46946 -2.02254 Mabsadd L
.06994 .07118 0 -0.96154 Mabsadd L
.06994 .07118 1.46946 -2.02254 Mabsadd L
.06994 .07118 .91448 -0.29713 Mabsadd L
.06994 .07118 2.37764 .77254 Mabsadd L
.06994 .07118 .56518 .7779 Mabsadd L
.06994 .07118 0 2.5 Mabsadd L closepath F
.07143 .07271 0 2.5 Mabsadd m
.07143 .07271 -0.56518 .7779 Mabsadd L
.07143 .07271 -2.37764 .77254 Mabsadd L
.07143 .07271 -0.91448 -0.29713 Mabsadd L
.07143 .07271 -1.46946 -2.02254 Mabsadd L
.07143 .07271 0 -0.96154 Mabsadd L
.07143 .07271 1.46946 -2.02254 Mabsadd L
.07143 .07271 .91448 -0.29713 Mabsadd L
.07143 .07271 2.37764 .77254 Mabsadd L
.07143 .07271 .56518 .7779 Mabsadd L
.07143 .07271 0 2.5 Mabsadd L closepath F
.07292 .07423 0 2.5 Mabsadd m
.07292 .07423 -0.56518 .7779 Mabsadd L
.07292 .07423 -2.37764 .77254 Mabsadd L
.07292 .07423 -0.91448 -0.29713 Mabsadd L
.07292 .07423 -1.46946 -2.02254 Mabsadd L
.07292 .07423 0 -0.96154 Mabsadd L
.07292 .07423 1.46946 -2.02254 Mabsadd L
.07292 .07423 .91448 -0.29713 Mabsadd L
.07292 .07423 2.37764 .77254 Mabsadd L
.07292 .07423 .56518 .7779 Mabsadd L
.07292 .07423 0 2.5 Mabsadd L closepath F
.0744 .07576 0 2.5 Mabsadd m
.0744 .07576 -0.56518 .7779 Mabsadd L
.0744 .07576 -2.37764 .77254 Mabsadd L
.0744 .07576 -0.91448 -0.29713 Mabsadd L
.0744 .07576 -1.46946 -2.02254 Mabsadd L
.0744 .07576 0 -0.96154 Mabsadd L
.0744 .07576 1.46946 -2.02254 Mabsadd L
.0744 .07576 .91448 -0.29713 Mabsadd L
.0744 .07576 2.37764 .77254 Mabsadd L
.0744 .07576 .56518 .7779 Mabsadd L
.0744 .07576 0 2.5 Mabsadd L closepath F
.07589 .07729 0 2.5 Mabsadd m
.07589 .07729 -0.56518 .7779 Mabsadd L
.07589 .07729 -2.37764 .77254 Mabsadd L
.07589 .07729 -0.91448 -0.29713 Mabsadd L
.07589 .07729 -1.46946 -2.02254 Mabsadd L
.07589 .07729 0 -0.96154 Mabsadd L
.07589 .07729 1.46946 -2.02254 Mabsadd L
.07589 .07729 .91448 -0.29713 Mabsadd L
.07589 .07729 2.37764 .77254 Mabsadd L
.07589 .07729 .56518 .7779 Mabsadd L
.07589 .07729 0 2.5 Mabsadd L closepath F
.07738 .07882 0 2.5 Mabsadd m
.07738 .07882 -0.56518 .7779 Mabsadd L
.07738 .07882 -2.37764 .77254 Mabsadd L
.07738 .07882 -0.91448 -0.29713 Mabsadd L
.07738 .07882 -1.46946 -2.02254 Mabsadd L
.07738 .07882 0 -0.96154 Mabsadd L
.07738 .07882 1.46946 -2.02254 Mabsadd L
.07738 .07882 .91448 -0.29713 Mabsadd L
.07738 .07882 2.37764 .77254 Mabsadd L
.07738 .07882 .56518 .7779 Mabsadd L
.07738 .07882 0 2.5 Mabsadd L closepath F
.07887 .08035 0 2.5 Mabsadd m
.07887 .08035 -0.56518 .7779 Mabsadd L
.07887 .08035 -2.37764 .77254 Mabsadd L
.07887 .08035 -0.91448 -0.29713 Mabsadd L
.07887 .08035 -1.46946 -2.02254 Mabsadd L
.07887 .08035 0 -0.96154 Mabsadd L
.07887 .08035 1.46946 -2.02254 Mabsadd L
.07887 .08035 .91448 -0.29713 Mabsadd L
.07887 .08035 2.37764 .77254 Mabsadd L
.07887 .08035 .56518 .7779 Mabsadd L
.07887 .08035 0 2.5 Mabsadd L closepath F
.08036 .08188 0 2.5 Mabsadd m
.08036 .08188 -0.56518 .7779 Mabsadd L
.08036 .08188 -2.37764 .77254 Mabsadd L
.08036 .08188 -0.91448 -0.29713 Mabsadd L
.08036 .08188 -1.46946 -2.02254 Mabsadd L
.08036 .08188 0 -0.96154 Mabsadd L
.08036 .08188 1.46946 -2.02254 Mabsadd L
.08036 .08188 .91448 -0.29713 Mabsadd L
.08036 .08188 2.37764 .77254 Mabsadd L
.08036 .08188 .56518 .7779 Mabsadd L
.08036 .08188 0 2.5 Mabsadd L closepath F
.08185 .0834 0 2.5 Mabsadd m
.08185 .0834 -0.56518 .7779 Mabsadd L
.08185 .0834 -2.37764 .77254 Mabsadd L
.08185 .0834 -0.91448 -0.29713 Mabsadd L
.08185 .0834 -1.46946 -2.02254 Mabsadd L
.08185 .0834 0 -0.96154 Mabsadd L
.08185 .0834 1.46946 -2.02254 Mabsadd L
.08185 .0834 .91448 -0.29713 Mabsadd L
.08185 .0834 2.37764 .77254 Mabsadd L
.08185 .0834 .56518 .7779 Mabsadd L
.08185 .0834 0 2.5 Mabsadd L closepath F
.08333 .08493 0 2.5 Mabsadd m
.08333 .08493 -0.56518 .7779 Mabsadd L
.08333 .08493 -2.37764 .77254 Mabsadd L
.08333 .08493 -0.91448 -0.29713 Mabsadd L
.08333 .08493 -1.46946 -2.02254 Mabsadd L
.08333 .08493 0 -0.96154 Mabsadd L
.08333 .08493 1.46946 -2.02254 Mabsadd L
.08333 .08493 .91448 -0.29713 Mabsadd L
.08333 .08493 2.37764 .77254 Mabsadd L
.08333 .08493 .56518 .7779 Mabsadd L
.08333 .08493 0 2.5 Mabsadd L closepath F
.08482 .08646 0 2.5 Mabsadd m
.08482 .08646 -0.56518 .7779 Mabsadd L
.08482 .08646 -2.37764 .77254 Mabsadd L
.08482 .08646 -0.91448 -0.29713 Mabsadd L
.08482 .08646 -1.46946 -2.02254 Mabsadd L
.08482 .08646 0 -0.96154 Mabsadd L
.08482 .08646 1.46946 -2.02254 Mabsadd L
.08482 .08646 .91448 -0.29713 Mabsadd L
.08482 .08646 2.37764 .77254 Mabsadd L
.08482 .08646 .56518 .7779 Mabsadd L
.08482 .08646 0 2.5 Mabsadd L closepath F
.08631 .08799 0 2.5 Mabsadd m
.08631 .08799 -0.56518 .7779 Mabsadd L
.08631 .08799 -2.37764 .77254 Mabsadd L
.08631 .08799 -0.91448 -0.29713 Mabsadd L
.08631 .08799 -1.46946 -2.02254 Mabsadd L
.08631 .08799 0 -0.96154 Mabsadd L
.08631 .08799 1.46946 -2.02254 Mabsadd L
.08631 .08799 .91448 -0.29713 Mabsadd L
.08631 .08799 2.37764 .77254 Mabsadd L
.08631 .08799 .56518 .7779 Mabsadd L
.08631 .08799 0 2.5 Mabsadd L closepath F
.0878 .08952 0 2.5 Mabsadd m
.0878 .08952 -0.56518 .7779 Mabsadd L
.0878 .08952 -2.37764 .77254 Mabsadd L
.0878 .08952 -0.91448 -0.29713 Mabsadd L
.0878 .08952 -1.46946 -2.02254 Mabsadd L
.0878 .08952 0 -0.96154 Mabsadd L
.0878 .08952 1.46946 -2.02254 Mabsadd L
.0878 .08952 .91448 -0.29713 Mabsadd L
.0878 .08952 2.37764 .77254 Mabsadd L
.0878 .08952 .56518 .7779 Mabsadd L
.0878 .08952 0 2.5 Mabsadd L closepath F
.08929 .09105 0 2.5 Mabsadd m
.08929 .09105 -0.56518 .7779 Mabsadd L
.08929 .09105 -2.37764 .77254 Mabsadd L
.08929 .09105 -0.91448 -0.29713 Mabsadd L
.08929 .09105 -1.46946 -2.02254 Mabsadd L
.08929 .09105 0 -0.96154 Mabsadd L
.08929 .09105 1.46946 -2.02254 Mabsadd L
.08929 .09105 .91448 -0.29713 Mabsadd L
.08929 .09105 2.37764 .77254 Mabsadd L
.08929 .09105 .56518 .7779 Mabsadd L
.08929 .09105 0 2.5 Mabsadd L closepath F
.09077 .09258 0 2.5 Mabsadd m
.09077 .09258 -0.56518 .7779 Mabsadd L
.09077 .09258 -2.37764 .77254 Mabsadd L
.09077 .09258 -0.91448 -0.29713 Mabsadd L
.09077 .09258 -1.46946 -2.02254 Mabsadd L
.09077 .09258 0 -0.96154 Mabsadd L
.09077 .09258 1.46946 -2.02254 Mabsadd L
.09077 .09258 .91448 -0.29713 Mabsadd L
.09077 .09258 2.37764 .77254 Mabsadd L
.09077 .09258 .56518 .7779 Mabsadd L
.09077 .09258 0 2.5 Mabsadd L closepath F
.09226 .09411 0 2.5 Mabsadd m
.09226 .09411 -0.56518 .7779 Mabsadd L
.09226 .09411 -2.37764 .77254 Mabsadd L
.09226 .09411 -0.91448 -0.29713 Mabsadd L
.09226 .09411 -1.46946 -2.02254 Mabsadd L
.09226 .09411 0 -0.96154 Mabsadd L
.09226 .09411 1.46946 -2.02254 Mabsadd L
.09226 .09411 .91448 -0.29713 Mabsadd L
.09226 .09411 2.37764 .77254 Mabsadd L
.09226 .09411 .56518 .7779 Mabsadd L
.09226 .09411 0 2.5 Mabsadd L closepath F
.09375 .09563 0 2.5 Mabsadd m
.09375 .09563 -0.56518 .7779 Mabsadd L
.09375 .09563 -2.37764 .77254 Mabsadd L
.09375 .09563 -0.91448 -0.29713 Mabsadd L
.09375 .09563 -1.46946 -2.02254 Mabsadd L
.09375 .09563 0 -0.96154 Mabsadd L
.09375 .09563 1.46946 -2.02254 Mabsadd L
.09375 .09563 .91448 -0.29713 Mabsadd L
.09375 .09563 2.37764 .77254 Mabsadd L
.09375 .09563 .56518 .7779 Mabsadd L
.09375 .09563 0 2.5 Mabsadd L closepath F
.09524 .09716 0 2.5 Mabsadd m
.09524 .09716 -0.56518 .7779 Mabsadd L
.09524 .09716 -2.37764 .77254 Mabsadd L
.09524 .09716 -0.91448 -0.29713 Mabsadd L
.09524 .09716 -1.46946 -2.02254 Mabsadd L
.09524 .09716 0 -0.96154 Mabsadd L
.09524 .09716 1.46946 -2.02254 Mabsadd L
.09524 .09716 .91448 -0.29713 Mabsadd L
.09524 .09716 2.37764 .77254 Mabsadd L
.09524 .09716 .56518 .7779 Mabsadd L
.09524 .09716 0 2.5 Mabsadd L closepath F
.09673 .09869 0 2.5 Mabsadd m
.09673 .09869 -0.56518 .7779 Mabsadd L
.09673 .09869 -2.37764 .77254 Mabsadd L
.09673 .09869 -0.91448 -0.29713 Mabsadd L
.09673 .09869 -1.46946 -2.02254 Mabsadd L
.09673 .09869 0 -0.96154 Mabsadd L
.09673 .09869 1.46946 -2.02254 Mabsadd L
.09673 .09869 .91448 -0.29713 Mabsadd L
.09673 .09869 2.37764 .77254 Mabsadd L
.09673 .09869 .56518 .7779 Mabsadd L
.09673 .09869 0 2.5 Mabsadd L closepath F
.09821 .10022 0 2.5 Mabsadd m
.09821 .10022 -0.56518 .7779 Mabsadd L
.09821 .10022 -2.37764 .77254 Mabsadd L
.09821 .10022 -0.91448 -0.29713 Mabsadd L
.09821 .10022 -1.46946 -2.02254 Mabsadd L
.09821 .10022 0 -0.96154 Mabsadd L
.09821 .10022 1.46946 -2.02254 Mabsadd L
.09821 .10022 .91448 -0.29713 Mabsadd L
.09821 .10022 2.37764 .77254 Mabsadd L
.09821 .10022 .56518 .7779 Mabsadd L
.09821 .10022 0 2.5 Mabsadd L closepath F
.0997 .10175 0 2.5 Mabsadd m
.0997 .10175 -0.56518 .7779 Mabsadd L
.0997 .10175 -2.37764 .77254 Mabsadd L
.0997 .10175 -0.91448 -0.29713 Mabsadd L
.0997 .10175 -1.46946 -2.02254 Mabsadd L
.0997 .10175 0 -0.96154 Mabsadd L
.0997 .10175 1.46946 -2.02254 Mabsadd L
.0997 .10175 .91448 -0.29713 Mabsadd L
.0997 .10175 2.37764 .77254 Mabsadd L
.0997 .10175 .56518 .7779 Mabsadd L
.0997 .10175 0 2.5 Mabsadd L closepath F
.10119 .10328 0 2.5 Mabsadd m
.10119 .10328 -0.56518 .7779 Mabsadd L
.10119 .10328 -2.37764 .77254 Mabsadd L
.10119 .10328 -0.91448 -0.29713 Mabsadd L
.10119 .10328 -1.46946 -2.02254 Mabsadd L
.10119 .10328 0 -0.96154 Mabsadd L
.10119 .10328 1.46946 -2.02254 Mabsadd L
.10119 .10328 .91448 -0.29713 Mabsadd L
.10119 .10328 2.37764 .77254 Mabsadd L
.10119 .10328 .56518 .7779 Mabsadd L
.10119 .10328 0 2.5 Mabsadd L closepath F
.10268 .10481 0 2.5 Mabsadd m
.10268 .10481 -0.56518 .7779 Mabsadd L
.10268 .10481 -2.37764 .77254 Mabsadd L
.10268 .10481 -0.91448 -0.29713 Mabsadd L
.10268 .10481 -1.46946 -2.02254 Mabsadd L
.10268 .10481 0 -0.96154 Mabsadd L
.10268 .10481 1.46946 -2.02254 Mabsadd L
.10268 .10481 .91448 -0.29713 Mabsadd L
.10268 .10481 2.37764 .77254 Mabsadd L
.10268 .10481 .56518 .7779 Mabsadd L
.10268 .10481 0 2.5 Mabsadd L closepath F
.10417 .10633 0 2.5 Mabsadd m
.10417 .10633 -0.56518 .7779 Mabsadd L
.10417 .10633 -2.37764 .77254 Mabsadd L
.10417 .10633 -0.91448 -0.29713 Mabsadd L
.10417 .10633 -1.46946 -2.02254 Mabsadd L
.10417 .10633 0 -0.96154 Mabsadd L
.10417 .10633 1.46946 -2.02254 Mabsadd L
.10417 .10633 .91448 -0.29713 Mabsadd L
.10417 .10633 2.37764 .77254 Mabsadd L
.10417 .10633 .56518 .7779 Mabsadd L
.10417 .10633 0 2.5 Mabsadd L closepath F
.10565 .10786 0 2.5 Mabsadd m
.10565 .10786 -0.56518 .7779 Mabsadd L
.10565 .10786 -2.37764 .77254 Mabsadd L
.10565 .10786 -0.91448 -0.29713 Mabsadd L
.10565 .10786 -1.46946 -2.02254 Mabsadd L
.10565 .10786 0 -0.96154 Mabsadd L
.10565 .10786 1.46946 -2.02254 Mabsadd L
.10565 .10786 .91448 -0.29713 Mabsadd L
.10565 .10786 2.37764 .77254 Mabsadd L
.10565 .10786 .56518 .7779 Mabsadd L
.10565 .10786 0 2.5 Mabsadd L closepath F
.10714 .10939 0 2.5 Mabsadd m
.10714 .10939 -0.56518 .7779 Mabsadd L
.10714 .10939 -2.37764 .77254 Mabsadd L
.10714 .10939 -0.91448 -0.29713 Mabsadd L
.10714 .10939 -1.46946 -2.02254 Mabsadd L
.10714 .10939 0 -0.96154 Mabsadd L
.10714 .10939 1.46946 -2.02254 Mabsadd L
.10714 .10939 .91448 -0.29713 Mabsadd L
.10714 .10939 2.37764 .77254 Mabsadd L
.10714 .10939 .56518 .7779 Mabsadd L
.10714 .10939 0 2.5 Mabsadd L closepath F
.10863 .11092 0 2.5 Mabsadd m
.10863 .11092 -0.56518 .7779 Mabsadd L
.10863 .11092 -2.37764 .77254 Mabsadd L
.10863 .11092 -0.91448 -0.29713 Mabsadd L
.10863 .11092 -1.46946 -2.02254 Mabsadd L
.10863 .11092 0 -0.96154 Mabsadd L
.10863 .11092 1.46946 -2.02254 Mabsadd L
.10863 .11092 .91448 -0.29713 Mabsadd L
.10863 .11092 2.37764 .77254 Mabsadd L
.10863 .11092 .56518 .7779 Mabsadd L
.10863 .11092 0 2.5 Mabsadd L closepath F
.11012 .11245 0 2.5 Mabsadd m
.11012 .11245 -0.56518 .7779 Mabsadd L
.11012 .11245 -2.37764 .77254 Mabsadd L
.11012 .11245 -0.91448 -0.29713 Mabsadd L
.11012 .11245 -1.46946 -2.02254 Mabsadd L
.11012 .11245 0 -0.96154 Mabsadd L
.11012 .11245 1.46946 -2.02254 Mabsadd L
.11012 .11245 .91448 -0.29713 Mabsadd L
.11012 .11245 2.37764 .77254 Mabsadd L
.11012 .11245 .56518 .7779 Mabsadd L
.11012 .11245 0 2.5 Mabsadd L closepath F
.11161 .11398 0 2.5 Mabsadd m
.11161 .11398 -0.56518 .7779 Mabsadd L
.11161 .11398 -2.37764 .77254 Mabsadd L
.11161 .11398 -0.91448 -0.29713 Mabsadd L
.11161 .11398 -1.46946 -2.02254 Mabsadd L
.11161 .11398 0 -0.96154 Mabsadd L
.11161 .11398 1.46946 -2.02254 Mabsadd L
.11161 .11398 .91448 -0.29713 Mabsadd L
.11161 .11398 2.37764 .77254 Mabsadd L
.11161 .11398 .56518 .7779 Mabsadd L
.11161 .11398 0 2.5 Mabsadd L closepath F
.1131 .11551 0 2.5 Mabsadd m
.1131 .11551 -0.56518 .7779 Mabsadd L
.1131 .11551 -2.37764 .77254 Mabsadd L
.1131 .11551 -0.91448 -0.29713 Mabsadd L
.1131 .11551 -1.46946 -2.02254 Mabsadd L
.1131 .11551 0 -0.96154 Mabsadd L
.1131 .11551 1.46946 -2.02254 Mabsadd L
.1131 .11551 .91448 -0.29713 Mabsadd L
.1131 .11551 2.37764 .77254 Mabsadd L
.1131 .11551 .56518 .7779 Mabsadd L
.1131 .11551 0 2.5 Mabsadd L closepath F
.11458 .11704 0 2.5 Mabsadd m
.11458 .11704 -0.56518 .7779 Mabsadd L
.11458 .11704 -2.37764 .77254 Mabsadd L
.11458 .11704 -0.91448 -0.29713 Mabsadd L
.11458 .11704 -1.46946 -2.02254 Mabsadd L
.11458 .11704 0 -0.96154 Mabsadd L
.11458 .11704 1.46946 -2.02254 Mabsadd L
.11458 .11704 .91448 -0.29713 Mabsadd L
.11458 .11704 2.37764 .77254 Mabsadd L
.11458 .11704 .56518 .7779 Mabsadd L
.11458 .11704 0 2.5 Mabsadd L closepath F
.11607 .11856 0 2.5 Mabsadd m
.11607 .11856 -0.56518 .7779 Mabsadd L
.11607 .11856 -2.37764 .77254 Mabsadd L
.11607 .11856 -0.91448 -0.29713 Mabsadd L
.11607 .11856 -1.46946 -2.02254 Mabsadd L
.11607 .11856 0 -0.96154 Mabsadd L
.11607 .11856 1.46946 -2.02254 Mabsadd L
.11607 .11856 .91448 -0.29713 Mabsadd L
.11607 .11856 2.37764 .77254 Mabsadd L
.11607 .11856 .56518 .7779 Mabsadd L
.11607 .11856 0 2.5 Mabsadd L closepath F
.11756 .12009 0 2.5 Mabsadd m
.11756 .12009 -0.56518 .7779 Mabsadd L
.11756 .12009 -2.37764 .77254 Mabsadd L
.11756 .12009 -0.91448 -0.29713 Mabsadd L
.11756 .12009 -1.46946 -2.02254 Mabsadd L
.11756 .12009 0 -0.96154 Mabsadd L
.11756 .12009 1.46946 -2.02254 Mabsadd L
.11756 .12009 .91448 -0.29713 Mabsadd L
.11756 .12009 2.37764 .77254 Mabsadd L
.11756 .12009 .56518 .7779 Mabsadd L
.11756 .12009 0 2.5 Mabsadd L closepath F
.11905 .12162 0 2.5 Mabsadd m
.11905 .12162 -0.56518 .7779 Mabsadd L
.11905 .12162 -2.37764 .77254 Mabsadd L
.11905 .12162 -0.91448 -0.29713 Mabsadd L
.11905 .12162 -1.46946 -2.02254 Mabsadd L
.11905 .12162 0 -0.96154 Mabsadd L
.11905 .12162 1.46946 -2.02254 Mabsadd L
.11905 .12162 .91448 -0.29713 Mabsadd L
.11905 .12162 2.37764 .77254 Mabsadd L
.11905 .12162 .56518 .7779 Mabsadd L
.11905 .12162 0 2.5 Mabsadd L closepath F
.12054 .12315 0 2.5 Mabsadd m
.12054 .12315 -0.56518 .7779 Mabsadd L
.12054 .12315 -2.37764 .77254 Mabsadd L
.12054 .12315 -0.91448 -0.29713 Mabsadd L
.12054 .12315 -1.46946 -2.02254 Mabsadd L
.12054 .12315 0 -0.96154 Mabsadd L
.12054 .12315 1.46946 -2.02254 Mabsadd L
.12054 .12315 .91448 -0.29713 Mabsadd L
.12054 .12315 2.37764 .77254 Mabsadd L
.12054 .12315 .56518 .7779 Mabsadd L
.12054 .12315 0 2.5 Mabsadd L closepath F
.12202 .12468 0 2.5 Mabsadd m
.12202 .12468 -0.56518 .7779 Mabsadd L
.12202 .12468 -2.37764 .77254 Mabsadd L
.12202 .12468 -0.91448 -0.29713 Mabsadd L
.12202 .12468 -1.46946 -2.02254 Mabsadd L
.12202 .12468 0 -0.96154 Mabsadd L
.12202 .12468 1.46946 -2.02254 Mabsadd L
.12202 .12468 .91448 -0.29713 Mabsadd L
.12202 .12468 2.37764 .77254 Mabsadd L
.12202 .12468 .56518 .7779 Mabsadd L
.12202 .12468 0 2.5 Mabsadd L closepath F
.12351 .12621 0 2.5 Mabsadd m
.12351 .12621 -0.56518 .7779 Mabsadd L
.12351 .12621 -2.37764 .77254 Mabsadd L
.12351 .12621 -0.91448 -0.29713 Mabsadd L
.12351 .12621 -1.46946 -2.02254 Mabsadd L
.12351 .12621 0 -0.96154 Mabsadd L
.12351 .12621 1.46946 -2.02254 Mabsadd L
.12351 .12621 .91448 -0.29713 Mabsadd L
.12351 .12621 2.37764 .77254 Mabsadd L
.12351 .12621 .56518 .7779 Mabsadd L
.12351 .12621 0 2.5 Mabsadd L closepath F
.125 .12774 0 2.5 Mabsadd m
.125 .12774 -0.56518 .7779 Mabsadd L
.125 .12774 -2.37764 .77254 Mabsadd L
.125 .12774 -0.91448 -0.29713 Mabsadd L
.125 .12774 -1.46946 -2.02254 Mabsadd L
.125 .12774 0 -0.96154 Mabsadd L
.125 .12774 1.46946 -2.02254 Mabsadd L
.125 .12774 .91448 -0.29713 Mabsadd L
.125 .12774 2.37764 .77254 Mabsadd L
.125 .12774 .56518 .7779 Mabsadd L
.125 .12774 0 2.5 Mabsadd L closepath F
.12649 .12926 0 2.5 Mabsadd m
.12649 .12926 -0.56518 .7779 Mabsadd L
.12649 .12926 -2.37764 .77254 Mabsadd L
.12649 .12926 -0.91448 -0.29713 Mabsadd L
.12649 .12926 -1.46946 -2.02254 Mabsadd L
.12649 .12926 0 -0.96154 Mabsadd L
.12649 .12926 1.46946 -2.02254 Mabsadd L
.12649 .12926 .91448 -0.29713 Mabsadd L
.12649 .12926 2.37764 .77254 Mabsadd L
.12649 .12926 .56518 .7779 Mabsadd L
.12649 .12926 0 2.5 Mabsadd L closepath F
.12798 .13079 0 2.5 Mabsadd m
.12798 .13079 -0.56518 .7779 Mabsadd L
.12798 .13079 -2.37764 .77254 Mabsadd L
.12798 .13079 -0.91448 -0.29713 Mabsadd L
.12798 .13079 -1.46946 -2.02254 Mabsadd L
.12798 .13079 0 -0.96154 Mabsadd L
.12798 .13079 1.46946 -2.02254 Mabsadd L
.12798 .13079 .91448 -0.29713 Mabsadd L
.12798 .13079 2.37764 .77254 Mabsadd L
.12798 .13079 .56518 .7779 Mabsadd L
.12798 .13079 0 2.5 Mabsadd L closepath F
.12946 .13232 0 2.5 Mabsadd m
.12946 .13232 -0.56518 .7779 Mabsadd L
.12946 .13232 -2.37764 .77254 Mabsadd L
.12946 .13232 -0.91448 -0.29713 Mabsadd L
.12946 .13232 -1.46946 -2.02254 Mabsadd L
.12946 .13232 0 -0.96154 Mabsadd L
.12946 .13232 1.46946 -2.02254 Mabsadd L
.12946 .13232 .91448 -0.29713 Mabsadd L
.12946 .13232 2.37764 .77254 Mabsadd L
.12946 .13232 .56518 .7779 Mabsadd L
.12946 .13232 0 2.5 Mabsadd L closepath F
.13095 .13385 0 2.5 Mabsadd m
.13095 .13385 -0.56518 .7779 Mabsadd L
.13095 .13385 -2.37764 .77254 Mabsadd L
.13095 .13385 -0.91448 -0.29713 Mabsadd L
.13095 .13385 -1.46946 -2.02254 Mabsadd L
.13095 .13385 0 -0.96154 Mabsadd L
.13095 .13385 1.46946 -2.02254 Mabsadd L
.13095 .13385 .91448 -0.29713 Mabsadd L
.13095 .13385 2.37764 .77254 Mabsadd L
.13095 .13385 .56518 .7779 Mabsadd L
.13095 .13385 0 2.5 Mabsadd L closepath F
.13244 .13538 0 2.5 Mabsadd m
.13244 .13538 -0.56518 .7779 Mabsadd L
.13244 .13538 -2.37764 .77254 Mabsadd L
.13244 .13538 -0.91448 -0.29713 Mabsadd L
.13244 .13538 -1.46946 -2.02254 Mabsadd L
.13244 .13538 0 -0.96154 Mabsadd L
.13244 .13538 1.46946 -2.02254 Mabsadd L
.13244 .13538 .91448 -0.29713 Mabsadd L
.13244 .13538 2.37764 .77254 Mabsadd L
.13244 .13538 .56518 .7779 Mabsadd L
.13244 .13538 0 2.5 Mabsadd L closepath F
.13393 .13691 0 2.5 Mabsadd m
.13393 .13691 -0.56518 .7779 Mabsadd L
.13393 .13691 -2.37764 .77254 Mabsadd L
.13393 .13691 -0.91448 -0.29713 Mabsadd L
.13393 .13691 -1.46946 -2.02254 Mabsadd L
.13393 .13691 0 -0.96154 Mabsadd L
.13393 .13691 1.46946 -2.02254 Mabsadd L
.13393 .13691 .91448 -0.29713 Mabsadd L
.13393 .13691 2.37764 .77254 Mabsadd L
.13393 .13691 .56518 .7779 Mabsadd L
.13393 .13691 0 2.5 Mabsadd L closepath F
.13542 .13843 0 2.5 Mabsadd m
.13542 .13843 -0.56518 .7779 Mabsadd L
.13542 .13843 -2.37764 .77254 Mabsadd L
.13542 .13843 -0.91448 -0.29713 Mabsadd L
.13542 .13843 -1.46946 -2.02254 Mabsadd L
.13542 .13843 0 -0.96154 Mabsadd L
.13542 .13843 1.46946 -2.02254 Mabsadd L
.13542 .13843 .91448 -0.29713 Mabsadd L
.13542 .13843 2.37764 .77254 Mabsadd L
.13542 .13843 .56518 .7779 Mabsadd L
.13542 .13843 0 2.5 Mabsadd L closepath F
.1369 .13996 0 2.5 Mabsadd m
.1369 .13996 -0.56518 .7779 Mabsadd L
.1369 .13996 -2.37764 .77254 Mabsadd L
.1369 .13996 -0.91448 -0.29713 Mabsadd L
.1369 .13996 -1.46946 -2.02254 Mabsadd L
.1369 .13996 0 -0.96154 Mabsadd L
.1369 .13996 1.46946 -2.02254 Mabsadd L
.1369 .13996 .91448 -0.29713 Mabsadd L
.1369 .13996 2.37764 .77254 Mabsadd L
.1369 .13996 .56518 .7779 Mabsadd L
.1369 .13996 0 2.5 Mabsadd L closepath F
.13839 .14149 0 2.5 Mabsadd m
.13839 .14149 -0.56518 .7779 Mabsadd L
.13839 .14149 -2.37764 .77254 Mabsadd L
.13839 .14149 -0.91448 -0.29713 Mabsadd L
.13839 .14149 -1.46946 -2.02254 Mabsadd L
.13839 .14149 0 -0.96154 Mabsadd L
.13839 .14149 1.46946 -2.02254 Mabsadd L
.13839 .14149 .91448 -0.29713 Mabsadd L
.13839 .14149 2.37764 .77254 Mabsadd L
.13839 .14149 .56518 .7779 Mabsadd L
.13839 .14149 0 2.5 Mabsadd L closepath F
.13988 .14302 0 2.5 Mabsadd m
.13988 .14302 -0.56518 .7779 Mabsadd L
.13988 .14302 -2.37764 .77254 Mabsadd L
.13988 .14302 -0.91448 -0.29713 Mabsadd L
.13988 .14302 -1.46946 -2.02254 Mabsadd L
.13988 .14302 0 -0.96154 Mabsadd L
.13988 .14302 1.46946 -2.02254 Mabsadd L
.13988 .14302 .91448 -0.29713 Mabsadd L
.13988 .14302 2.37764 .77254 Mabsadd L
.13988 .14302 .56518 .7779 Mabsadd L
.13988 .14302 0 2.5 Mabsadd L closepath F
.14137 .14455 0 2.5 Mabsadd m
.14137 .14455 -0.56518 .7779 Mabsadd L
.14137 .14455 -2.37764 .77254 Mabsadd L
.14137 .14455 -0.91448 -0.29713 Mabsadd L
.14137 .14455 -1.46946 -2.02254 Mabsadd L
.14137 .14455 0 -0.96154 Mabsadd L
.14137 .14455 1.46946 -2.02254 Mabsadd L
.14137 .14455 .91448 -0.29713 Mabsadd L
.14137 .14455 2.37764 .77254 Mabsadd L
.14137 .14455 .56518 .7779 Mabsadd L
.14137 .14455 0 2.5 Mabsadd L closepath F
.14286 .14607 0 2.5 Mabsadd m
.14286 .14607 -0.56518 .7779 Mabsadd L
.14286 .14607 -2.37764 .77254 Mabsadd L
.14286 .14607 -0.91448 -0.29713 Mabsadd L
.14286 .14607 -1.46946 -2.02254 Mabsadd L
.14286 .14607 0 -0.96154 Mabsadd L
.14286 .14607 1.46946 -2.02254 Mabsadd L
.14286 .14607 .91448 -0.29713 Mabsadd L
.14286 .14607 2.37764 .77254 Mabsadd L
.14286 .14607 .56518 .7779 Mabsadd L
.14286 .14607 0 2.5 Mabsadd L closepath F
.14435 .1476 0 2.5 Mabsadd m
.14435 .1476 -0.56518 .7779 Mabsadd L
.14435 .1476 -2.37764 .77254 Mabsadd L
.14435 .1476 -0.91448 -0.29713 Mabsadd L
.14435 .1476 -1.46946 -2.02254 Mabsadd L
.14435 .1476 0 -0.96154 Mabsadd L
.14435 .1476 1.46946 -2.02254 Mabsadd L
.14435 .1476 .91448 -0.29713 Mabsadd L
.14435 .1476 2.37764 .77254 Mabsadd L
.14435 .1476 .56518 .7779 Mabsadd L
.14435 .1476 0 2.5 Mabsadd L closepath F
.14583 .14913 0 2.5 Mabsadd m
.14583 .14913 -0.56518 .7779 Mabsadd L
.14583 .14913 -2.37764 .77254 Mabsadd L
.14583 .14913 -0.91448 -0.29713 Mabsadd L
.14583 .14913 -1.46946 -2.02254 Mabsadd L
.14583 .14913 0 -0.96154 Mabsadd L
.14583 .14913 1.46946 -2.02254 Mabsadd L
.14583 .14913 .91448 -0.29713 Mabsadd L
.14583 .14913 2.37764 .77254 Mabsadd L
.14583 .14913 .56518 .7779 Mabsadd L
.14583 .14913 0 2.5 Mabsadd L closepath F
.14732 .15066 0 2.5 Mabsadd m
.14732 .15066 -0.56518 .7779 Mabsadd L
.14732 .15066 -2.37764 .77254 Mabsadd L
.14732 .15066 -0.91448 -0.29713 Mabsadd L
.14732 .15066 -1.46946 -2.02254 Mabsadd L
.14732 .15066 0 -0.96154 Mabsadd L
.14732 .15066 1.46946 -2.02254 Mabsadd L
.14732 .15066 .91448 -0.29713 Mabsadd L
.14732 .15066 2.37764 .77254 Mabsadd L
.14732 .15066 .56518 .7779 Mabsadd L
.14732 .15066 0 2.5 Mabsadd L closepath F
.14881 .15219 0 2.5 Mabsadd m
.14881 .15219 -0.56518 .7779 Mabsadd L
.14881 .15219 -2.37764 .77254 Mabsadd L
.14881 .15219 -0.91448 -0.29713 Mabsadd L
.14881 .15219 -1.46946 -2.02254 Mabsadd L
.14881 .15219 0 -0.96154 Mabsadd L
.14881 .15219 1.46946 -2.02254 Mabsadd L
.14881 .15219 .91448 -0.29713 Mabsadd L
.14881 .15219 2.37764 .77254 Mabsadd L
.14881 .15219 .56518 .7779 Mabsadd L
.14881 .15219 0 2.5 Mabsadd L closepath F
.1503 .15371 0 2.5 Mabsadd m
.1503 .15371 -0.56518 .7779 Mabsadd L
.1503 .15371 -2.37764 .77254 Mabsadd L
.1503 .15371 -0.91448 -0.29713 Mabsadd L
.1503 .15371 -1.46946 -2.02254 Mabsadd L
.1503 .15371 0 -0.96154 Mabsadd L
.1503 .15371 1.46946 -2.02254 Mabsadd L
.1503 .15371 .91448 -0.29713 Mabsadd L
.1503 .15371 2.37764 .77254 Mabsadd L
.1503 .15371 .56518 .7779 Mabsadd L
.1503 .15371 0 2.5 Mabsadd L closepath F
.15179 .15524 0 2.5 Mabsadd m
.15179 .15524 -0.56518 .7779 Mabsadd L
.15179 .15524 -2.37764 .77254 Mabsadd L
.15179 .15524 -0.91448 -0.29713 Mabsadd L
.15179 .15524 -1.46946 -2.02254 Mabsadd L
.15179 .15524 0 -0.96154 Mabsadd L
.15179 .15524 1.46946 -2.02254 Mabsadd L
.15179 .15524 .91448 -0.29713 Mabsadd L
.15179 .15524 2.37764 .77254 Mabsadd L
.15179 .15524 .56518 .7779 Mabsadd L
.15179 .15524 0 2.5 Mabsadd L closepath F
.15327 .15677 0 2.5 Mabsadd m
.15327 .15677 -0.56518 .7779 Mabsadd L
.15327 .15677 -2.37764 .77254 Mabsadd L
.15327 .15677 -0.91448 -0.29713 Mabsadd L
.15327 .15677 -1.46946 -2.02254 Mabsadd L
.15327 .15677 0 -0.96154 Mabsadd L
.15327 .15677 1.46946 -2.02254 Mabsadd L
.15327 .15677 .91448 -0.29713 Mabsadd L
.15327 .15677 2.37764 .77254 Mabsadd L
.15327 .15677 .56518 .7779 Mabsadd L
.15327 .15677 0 2.5 Mabsadd L closepath F
.15476 .1583 0 2.5 Mabsadd m
.15476 .1583 -0.56518 .7779 Mabsadd L
.15476 .1583 -2.37764 .77254 Mabsadd L
.15476 .1583 -0.91448 -0.29713 Mabsadd L
.15476 .1583 -1.46946 -2.02254 Mabsadd L
.15476 .1583 0 -0.96154 Mabsadd L
.15476 .1583 1.46946 -2.02254 Mabsadd L
.15476 .1583 .91448 -0.29713 Mabsadd L
.15476 .1583 2.37764 .77254 Mabsadd L
.15476 .1583 .56518 .7779 Mabsadd L
.15476 .1583 0 2.5 Mabsadd L closepath F
.15625 .15983 0 2.5 Mabsadd m
.15625 .15983 -0.56518 .7779 Mabsadd L
.15625 .15983 -2.37764 .77254 Mabsadd L
.15625 .15983 -0.91448 -0.29713 Mabsadd L
.15625 .15983 -1.46946 -2.02254 Mabsadd L
.15625 .15983 0 -0.96154 Mabsadd L
.15625 .15983 1.46946 -2.02254 Mabsadd L
.15625 .15983 .91448 -0.29713 Mabsadd L
.15625 .15983 2.37764 .77254 Mabsadd L
.15625 .15983 .56518 .7779 Mabsadd L
.15625 .15983 0 2.5 Mabsadd L closepath F
.15774 .16135 0 2.5 Mabsadd m
.15774 .16135 -0.56518 .7779 Mabsadd L
.15774 .16135 -2.37764 .77254 Mabsadd L
.15774 .16135 -0.91448 -0.29713 Mabsadd L
.15774 .16135 -1.46946 -2.02254 Mabsadd L
.15774 .16135 0 -0.96154 Mabsadd L
.15774 .16135 1.46946 -2.02254 Mabsadd L
.15774 .16135 .91448 -0.29713 Mabsadd L
.15774 .16135 2.37764 .77254 Mabsadd L
.15774 .16135 .56518 .7779 Mabsadd L
.15774 .16135 0 2.5 Mabsadd L closepath F
.15923 .16288 0 2.5 Mabsadd m
.15923 .16288 -0.56518 .7779 Mabsadd L
.15923 .16288 -2.37764 .77254 Mabsadd L
.15923 .16288 -0.91448 -0.29713 Mabsadd L
.15923 .16288 -1.46946 -2.02254 Mabsadd L
.15923 .16288 0 -0.96154 Mabsadd L
.15923 .16288 1.46946 -2.02254 Mabsadd L
.15923 .16288 .91448 -0.29713 Mabsadd L
.15923 .16288 2.37764 .77254 Mabsadd L
.15923 .16288 .56518 .7779 Mabsadd L
.15923 .16288 0 2.5 Mabsadd L closepath F
.16071 .16441 0 2.5 Mabsadd m
.16071 .16441 -0.56518 .7779 Mabsadd L
.16071 .16441 -2.37764 .77254 Mabsadd L
.16071 .16441 -0.91448 -0.29713 Mabsadd L
.16071 .16441 -1.46946 -2.02254 Mabsadd L
.16071 .16441 0 -0.96154 Mabsadd L
.16071 .16441 1.46946 -2.02254 Mabsadd L
.16071 .16441 .91448 -0.29713 Mabsadd L
.16071 .16441 2.37764 .77254 Mabsadd L
.16071 .16441 .56518 .7779 Mabsadd L
.16071 .16441 0 2.5 Mabsadd L closepath F
.1622 .16594 0 2.5 Mabsadd m
.1622 .16594 -0.56518 .7779 Mabsadd L
.1622 .16594 -2.37764 .77254 Mabsadd L
.1622 .16594 -0.91448 -0.29713 Mabsadd L
.1622 .16594 -1.46946 -2.02254 Mabsadd L
.1622 .16594 0 -0.96154 Mabsadd L
.1622 .16594 1.46946 -2.02254 Mabsadd L
.1622 .16594 .91448 -0.29713 Mabsadd L
.1622 .16594 2.37764 .77254 Mabsadd L
.1622 .16594 .56518 .7779 Mabsadd L
.1622 .16594 0 2.5 Mabsadd L closepath F
.16369 .16746 0 2.5 Mabsadd m
.16369 .16746 -0.56518 .7779 Mabsadd L
.16369 .16746 -2.37764 .77254 Mabsadd L
.16369 .16746 -0.91448 -0.29713 Mabsadd L
.16369 .16746 -1.46946 -2.02254 Mabsadd L
.16369 .16746 0 -0.96154 Mabsadd L
.16369 .16746 1.46946 -2.02254 Mabsadd L
.16369 .16746 .91448 -0.29713 Mabsadd L
.16369 .16746 2.37764 .77254 Mabsadd L
.16369 .16746 .56518 .7779 Mabsadd L
.16369 .16746 0 2.5 Mabsadd L closepath F
.16518 .16899 0 2.5 Mabsadd m
.16518 .16899 -0.56518 .7779 Mabsadd L
.16518 .16899 -2.37764 .77254 Mabsadd L
.16518 .16899 -0.91448 -0.29713 Mabsadd L
.16518 .16899 -1.46946 -2.02254 Mabsadd L
.16518 .16899 0 -0.96154 Mabsadd L
.16518 .16899 1.46946 -2.02254 Mabsadd L
.16518 .16899 .91448 -0.29713 Mabsadd L
.16518 .16899 2.37764 .77254 Mabsadd L
.16518 .16899 .56518 .7779 Mabsadd L
.16518 .16899 0 2.5 Mabsadd L closepath F
.16667 .17052 0 2.5 Mabsadd m
.16667 .17052 -0.56518 .7779 Mabsadd L
.16667 .17052 -2.37764 .77254 Mabsadd L
.16667 .17052 -0.91448 -0.29713 Mabsadd L
.16667 .17052 -1.46946 -2.02254 Mabsadd L
.16667 .17052 0 -0.96154 Mabsadd L
.16667 .17052 1.46946 -2.02254 Mabsadd L
.16667 .17052 .91448 -0.29713 Mabsadd L
.16667 .17052 2.37764 .77254 Mabsadd L
.16667 .17052 .56518 .7779 Mabsadd L
.16667 .17052 0 2.5 Mabsadd L closepath F
.16815 .17205 0 2.5 Mabsadd m
.16815 .17205 -0.56518 .7779 Mabsadd L
.16815 .17205 -2.37764 .77254 Mabsadd L
.16815 .17205 -0.91448 -0.29713 Mabsadd L
.16815 .17205 -1.46946 -2.02254 Mabsadd L
.16815 .17205 0 -0.96154 Mabsadd L
.16815 .17205 1.46946 -2.02254 Mabsadd L
.16815 .17205 .91448 -0.29713 Mabsadd L
.16815 .17205 2.37764 .77254 Mabsadd L
.16815 .17205 .56518 .7779 Mabsadd L
.16815 .17205 0 2.5 Mabsadd L closepath F
.16964 .17357 0 2.5 Mabsadd m
.16964 .17357 -0.56518 .7779 Mabsadd L
.16964 .17357 -2.37764 .77254 Mabsadd L
.16964 .17357 -0.91448 -0.29713 Mabsadd L
.16964 .17357 -1.46946 -2.02254 Mabsadd L
.16964 .17357 0 -0.96154 Mabsadd L
.16964 .17357 1.46946 -2.02254 Mabsadd L
.16964 .17357 .91448 -0.29713 Mabsadd L
.16964 .17357 2.37764 .77254 Mabsadd L
.16964 .17357 .56518 .7779 Mabsadd L
.16964 .17357 0 2.5 Mabsadd L closepath F
.17113 .1751 0 2.5 Mabsadd m
.17113 .1751 -0.56518 .7779 Mabsadd L
.17113 .1751 -2.37764 .77254 Mabsadd L
.17113 .1751 -0.91448 -0.29713 Mabsadd L
.17113 .1751 -1.46946 -2.02254 Mabsadd L
.17113 .1751 0 -0.96154 Mabsadd L
.17113 .1751 1.46946 -2.02254 Mabsadd L
.17113 .1751 .91448 -0.29713 Mabsadd L
.17113 .1751 2.37764 .77254 Mabsadd L
.17113 .1751 .56518 .7779 Mabsadd L
.17113 .1751 0 2.5 Mabsadd L closepath F
.17262 .17663 0 2.5 Mabsadd m
.17262 .17663 -0.56518 .7779 Mabsadd L
.17262 .17663 -2.37764 .77254 Mabsadd L
.17262 .17663 -0.91448 -0.29713 Mabsadd L
.17262 .17663 -1.46946 -2.02254 Mabsadd L
.17262 .17663 0 -0.96154 Mabsadd L
.17262 .17663 1.46946 -2.02254 Mabsadd L
.17262 .17663 .91448 -0.29713 Mabsadd L
.17262 .17663 2.37764 .77254 Mabsadd L
.17262 .17663 .56518 .7779 Mabsadd L
.17262 .17663 0 2.5 Mabsadd L closepath F
.17411 .17815 0 2.5 Mabsadd m
.17411 .17815 -0.56518 .7779 Mabsadd L
.17411 .17815 -2.37764 .77254 Mabsadd L
.17411 .17815 -0.91448 -0.29713 Mabsadd L
.17411 .17815 -1.46946 -2.02254 Mabsadd L
.17411 .17815 0 -0.96154 Mabsadd L
.17411 .17815 1.46946 -2.02254 Mabsadd L
.17411 .17815 .91448 -0.29713 Mabsadd L
.17411 .17815 2.37764 .77254 Mabsadd L
.17411 .17815 .56518 .7779 Mabsadd L
.17411 .17815 0 2.5 Mabsadd L closepath F
.1756 .17968 0 2.5 Mabsadd m
.1756 .17968 -0.56518 .7779 Mabsadd L
.1756 .17968 -2.37764 .77254 Mabsadd L
.1756 .17968 -0.91448 -0.29713 Mabsadd L
.1756 .17968 -1.46946 -2.02254 Mabsadd L
.1756 .17968 0 -0.96154 Mabsadd L
.1756 .17968 1.46946 -2.02254 Mabsadd L
.1756 .17968 .91448 -0.29713 Mabsadd L
.1756 .17968 2.37764 .77254 Mabsadd L
.1756 .17968 .56518 .7779 Mabsadd L
.1756 .17968 0 2.5 Mabsadd L closepath F
.17708 .18121 0 2.5 Mabsadd m
.17708 .18121 -0.56518 .7779 Mabsadd L
.17708 .18121 -2.37764 .77254 Mabsadd L
.17708 .18121 -0.91448 -0.29713 Mabsadd L
.17708 .18121 -1.46946 -2.02254 Mabsadd L
.17708 .18121 0 -0.96154 Mabsadd L
.17708 .18121 1.46946 -2.02254 Mabsadd L
.17708 .18121 .91448 -0.29713 Mabsadd L
.17708 .18121 2.37764 .77254 Mabsadd L
.17708 .18121 .56518 .7779 Mabsadd L
.17708 .18121 0 2.5 Mabsadd L closepath F
.17857 .18274 0 2.5 Mabsadd m
.17857 .18274 -0.56518 .7779 Mabsadd L
.17857 .18274 -2.37764 .77254 Mabsadd L
.17857 .18274 -0.91448 -0.29713 Mabsadd L
.17857 .18274 -1.46946 -2.02254 Mabsadd L
.17857 .18274 0 -0.96154 Mabsadd L
.17857 .18274 1.46946 -2.02254 Mabsadd L
.17857 .18274 .91448 -0.29713 Mabsadd L
.17857 .18274 2.37764 .77254 Mabsadd L
.17857 .18274 .56518 .7779 Mabsadd L
.17857 .18274 0 2.5 Mabsadd L closepath F
.18006 .18426 0 2.5 Mabsadd m
.18006 .18426 -0.56518 .7779 Mabsadd L
.18006 .18426 -2.37764 .77254 Mabsadd L
.18006 .18426 -0.91448 -0.29713 Mabsadd L
.18006 .18426 -1.46946 -2.02254 Mabsadd L
.18006 .18426 0 -0.96154 Mabsadd L
.18006 .18426 1.46946 -2.02254 Mabsadd L
.18006 .18426 .91448 -0.29713 Mabsadd L
.18006 .18426 2.37764 .77254 Mabsadd L
.18006 .18426 .56518 .7779 Mabsadd L
.18006 .18426 0 2.5 Mabsadd L closepath F
.18155 .18579 0 2.5 Mabsadd m
.18155 .18579 -0.56518 .7779 Mabsadd L
.18155 .18579 -2.37764 .77254 Mabsadd L
.18155 .18579 -0.91448 -0.29713 Mabsadd L
.18155 .18579 -1.46946 -2.02254 Mabsadd L
.18155 .18579 0 -0.96154 Mabsadd L
.18155 .18579 1.46946 -2.02254 Mabsadd L
.18155 .18579 .91448 -0.29713 Mabsadd L
.18155 .18579 2.37764 .77254 Mabsadd L
.18155 .18579 .56518 .7779 Mabsadd L
.18155 .18579 0 2.5 Mabsadd L closepath F
.18304 .18732 0 2.5 Mabsadd m
.18304 .18732 -0.56518 .7779 Mabsadd L
.18304 .18732 -2.37764 .77254 Mabsadd L
.18304 .18732 -0.91448 -0.29713 Mabsadd L
.18304 .18732 -1.46946 -2.02254 Mabsadd L
.18304 .18732 0 -0.96154 Mabsadd L
.18304 .18732 1.46946 -2.02254 Mabsadd L
.18304 .18732 .91448 -0.29713 Mabsadd L
.18304 .18732 2.37764 .77254 Mabsadd L
.18304 .18732 .56518 .7779 Mabsadd L
.18304 .18732 0 2.5 Mabsadd L closepath F
.18452 .18884 0 2.5 Mabsadd m
.18452 .18884 -0.56518 .7779 Mabsadd L
.18452 .18884 -2.37764 .77254 Mabsadd L
.18452 .18884 -0.91448 -0.29713 Mabsadd L
.18452 .18884 -1.46946 -2.02254 Mabsadd L
.18452 .18884 0 -0.96154 Mabsadd L
.18452 .18884 1.46946 -2.02254 Mabsadd L
.18452 .18884 .91448 -0.29713 Mabsadd L
.18452 .18884 2.37764 .77254 Mabsadd L
.18452 .18884 .56518 .7779 Mabsadd L
.18452 .18884 0 2.5 Mabsadd L closepath F
.18601 .19037 0 2.5 Mabsadd m
.18601 .19037 -0.56518 .7779 Mabsadd L
.18601 .19037 -2.37764 .77254 Mabsadd L
.18601 .19037 -0.91448 -0.29713 Mabsadd L
.18601 .19037 -1.46946 -2.02254 Mabsadd L
.18601 .19037 0 -0.96154 Mabsadd L
.18601 .19037 1.46946 -2.02254 Mabsadd L
.18601 .19037 .91448 -0.29713 Mabsadd L
.18601 .19037 2.37764 .77254 Mabsadd L
.18601 .19037 .56518 .7779 Mabsadd L
.18601 .19037 0 2.5 Mabsadd L closepath F
.1875 .1919 0 2.5 Mabsadd m
.1875 .1919 -0.56518 .7779 Mabsadd L
.1875 .1919 -2.37764 .77254 Mabsadd L
.1875 .1919 -0.91448 -0.29713 Mabsadd L
.1875 .1919 -1.46946 -2.02254 Mabsadd L
.1875 .1919 0 -0.96154 Mabsadd L
.1875 .1919 1.46946 -2.02254 Mabsadd L
.1875 .1919 .91448 -0.29713 Mabsadd L
.1875 .1919 2.37764 .77254 Mabsadd L
.1875 .1919 .56518 .7779 Mabsadd L
.1875 .1919 0 2.5 Mabsadd L closepath F
.18899 .19342 0 2.5 Mabsadd m
.18899 .19342 -0.56518 .7779 Mabsadd L
.18899 .19342 -2.37764 .77254 Mabsadd L
.18899 .19342 -0.91448 -0.29713 Mabsadd L
.18899 .19342 -1.46946 -2.02254 Mabsadd L
.18899 .19342 0 -0.96154 Mabsadd L
.18899 .19342 1.46946 -2.02254 Mabsadd L
.18899 .19342 .91448 -0.29713 Mabsadd L
.18899 .19342 2.37764 .77254 Mabsadd L
.18899 .19342 .56518 .7779 Mabsadd L
.18899 .19342 0 2.5 Mabsadd L closepath F
.19048 .19495 0 2.5 Mabsadd m
.19048 .19495 -0.56518 .7779 Mabsadd L
.19048 .19495 -2.37764 .77254 Mabsadd L
.19048 .19495 -0.91448 -0.29713 Mabsadd L
.19048 .19495 -1.46946 -2.02254 Mabsadd L
.19048 .19495 0 -0.96154 Mabsadd L
.19048 .19495 1.46946 -2.02254 Mabsadd L
.19048 .19495 .91448 -0.29713 Mabsadd L
.19048 .19495 2.37764 .77254 Mabsadd L
.19048 .19495 .56518 .7779 Mabsadd L
.19048 .19495 0 2.5 Mabsadd L closepath F
.19196 .19648 0 2.5 Mabsadd m
.19196 .19648 -0.56518 .7779 Mabsadd L
.19196 .19648 -2.37764 .77254 Mabsadd L
.19196 .19648 -0.91448 -0.29713 Mabsadd L
.19196 .19648 -1.46946 -2.02254 Mabsadd L
.19196 .19648 0 -0.96154 Mabsadd L
.19196 .19648 1.46946 -2.02254 Mabsadd L
.19196 .19648 .91448 -0.29713 Mabsadd L
.19196 .19648 2.37764 .77254 Mabsadd L
.19196 .19648 .56518 .7779 Mabsadd L
.19196 .19648 0 2.5 Mabsadd L closepath F
.19345 .198 0 2.5 Mabsadd m
.19345 .198 -0.56518 .7779 Mabsadd L
.19345 .198 -2.37764 .77254 Mabsadd L
.19345 .198 -0.91448 -0.29713 Mabsadd L
.19345 .198 -1.46946 -2.02254 Mabsadd L
.19345 .198 0 -0.96154 Mabsadd L
.19345 .198 1.46946 -2.02254 Mabsadd L
.19345 .198 .91448 -0.29713 Mabsadd L
.19345 .198 2.37764 .77254 Mabsadd L
.19345 .198 .56518 .7779 Mabsadd L
.19345 .198 0 2.5 Mabsadd L closepath F
.19494 .19953 0 2.5 Mabsadd m
.19494 .19953 -0.56518 .7779 Mabsadd L
.19494 .19953 -2.37764 .77254 Mabsadd L
.19494 .19953 -0.91448 -0.29713 Mabsadd L
.19494 .19953 -1.46946 -2.02254 Mabsadd L
.19494 .19953 0 -0.96154 Mabsadd L
.19494 .19953 1.46946 -2.02254 Mabsadd L
.19494 .19953 .91448 -0.29713 Mabsadd L
.19494 .19953 2.37764 .77254 Mabsadd L
.19494 .19953 .56518 .7779 Mabsadd L
.19494 .19953 0 2.5 Mabsadd L closepath F
.19643 .20106 0 2.5 Mabsadd m
.19643 .20106 -0.56518 .7779 Mabsadd L
.19643 .20106 -2.37764 .77254 Mabsadd L
.19643 .20106 -0.91448 -0.29713 Mabsadd L
.19643 .20106 -1.46946 -2.02254 Mabsadd L
.19643 .20106 0 -0.96154 Mabsadd L
.19643 .20106 1.46946 -2.02254 Mabsadd L
.19643 .20106 .91448 -0.29713 Mabsadd L
.19643 .20106 2.37764 .77254 Mabsadd L
.19643 .20106 .56518 .7779 Mabsadd L
.19643 .20106 0 2.5 Mabsadd L closepath F
.19792 .20258 0 2.5 Mabsadd m
.19792 .20258 -0.56518 .7779 Mabsadd L
.19792 .20258 -2.37764 .77254 Mabsadd L
.19792 .20258 -0.91448 -0.29713 Mabsadd L
.19792 .20258 -1.46946 -2.02254 Mabsadd L
.19792 .20258 0 -0.96154 Mabsadd L
.19792 .20258 1.46946 -2.02254 Mabsadd L
.19792 .20258 .91448 -0.29713 Mabsadd L
.19792 .20258 2.37764 .77254 Mabsadd L
.19792 .20258 .56518 .7779 Mabsadd L
.19792 .20258 0 2.5 Mabsadd L closepath F
.1994 .20411 0 2.5 Mabsadd m
.1994 .20411 -0.56518 .7779 Mabsadd L
.1994 .20411 -2.37764 .77254 Mabsadd L
.1994 .20411 -0.91448 -0.29713 Mabsadd L
.1994 .20411 -1.46946 -2.02254 Mabsadd L
.1994 .20411 0 -0.96154 Mabsadd L
.1994 .20411 1.46946 -2.02254 Mabsadd L
.1994 .20411 .91448 -0.29713 Mabsadd L
.1994 .20411 2.37764 .77254 Mabsadd L
.1994 .20411 .56518 .7779 Mabsadd L
.1994 .20411 0 2.5 Mabsadd L closepath F
.20089 .20564 0 2.5 Mabsadd m
.20089 .20564 -0.56518 .7779 Mabsadd L
.20089 .20564 -2.37764 .77254 Mabsadd L
.20089 .20564 -0.91448 -0.29713 Mabsadd L
.20089 .20564 -1.46946 -2.02254 Mabsadd L
.20089 .20564 0 -0.96154 Mabsadd L
.20089 .20564 1.46946 -2.02254 Mabsadd L
.20089 .20564 .91448 -0.29713 Mabsadd L
.20089 .20564 2.37764 .77254 Mabsadd L
.20089 .20564 .56518 .7779 Mabsadd L
.20089 .20564 0 2.5 Mabsadd L closepath F
.20238 .20716 0 2.5 Mabsadd m
.20238 .20716 -0.56518 .7779 Mabsadd L
.20238 .20716 -2.37764 .77254 Mabsadd L
.20238 .20716 -0.91448 -0.29713 Mabsadd L
.20238 .20716 -1.46946 -2.02254 Mabsadd L
.20238 .20716 0 -0.96154 Mabsadd L
.20238 .20716 1.46946 -2.02254 Mabsadd L
.20238 .20716 .91448 -0.29713 Mabsadd L
.20238 .20716 2.37764 .77254 Mabsadd L
.20238 .20716 .56518 .7779 Mabsadd L
.20238 .20716 0 2.5 Mabsadd L closepath F
.20387 .20869 0 2.5 Mabsadd m
.20387 .20869 -0.56518 .7779 Mabsadd L
.20387 .20869 -2.37764 .77254 Mabsadd L
.20387 .20869 -0.91448 -0.29713 Mabsadd L
.20387 .20869 -1.46946 -2.02254 Mabsadd L
.20387 .20869 0 -0.96154 Mabsadd L
.20387 .20869 1.46946 -2.02254 Mabsadd L
.20387 .20869 .91448 -0.29713 Mabsadd L
.20387 .20869 2.37764 .77254 Mabsadd L
.20387 .20869 .56518 .7779 Mabsadd L
.20387 .20869 0 2.5 Mabsadd L closepath F
.20536 .21021 0 2.5 Mabsadd m
.20536 .21021 -0.56518 .7779 Mabsadd L
.20536 .21021 -2.37764 .77254 Mabsadd L
.20536 .21021 -0.91448 -0.29713 Mabsadd L
.20536 .21021 -1.46946 -2.02254 Mabsadd L
.20536 .21021 0 -0.96154 Mabsadd L
.20536 .21021 1.46946 -2.02254 Mabsadd L
.20536 .21021 .91448 -0.29713 Mabsadd L
.20536 .21021 2.37764 .77254 Mabsadd L
.20536 .21021 .56518 .7779 Mabsadd L
.20536 .21021 0 2.5 Mabsadd L closepath F
.20685 .21174 0 2.5 Mabsadd m
.20685 .21174 -0.56518 .7779 Mabsadd L
.20685 .21174 -2.37764 .77254 Mabsadd L
.20685 .21174 -0.91448 -0.29713 Mabsadd L
.20685 .21174 -1.46946 -2.02254 Mabsadd L
.20685 .21174 0 -0.96154 Mabsadd L
.20685 .21174 1.46946 -2.02254 Mabsadd L
.20685 .21174 .91448 -0.29713 Mabsadd L
.20685 .21174 2.37764 .77254 Mabsadd L
.20685 .21174 .56518 .7779 Mabsadd L
.20685 .21174 0 2.5 Mabsadd L closepath F
.20833 .21327 0 2.5 Mabsadd m
.20833 .21327 -0.56518 .7779 Mabsadd L
.20833 .21327 -2.37764 .77254 Mabsadd L
.20833 .21327 -0.91448 -0.29713 Mabsadd L
.20833 .21327 -1.46946 -2.02254 Mabsadd L
.20833 .21327 0 -0.96154 Mabsadd L
.20833 .21327 1.46946 -2.02254 Mabsadd L
.20833 .21327 .91448 -0.29713 Mabsadd L
.20833 .21327 2.37764 .77254 Mabsadd L
.20833 .21327 .56518 .7779 Mabsadd L
.20833 .21327 0 2.5 Mabsadd L closepath F
.20982 .21479 0 2.5 Mabsadd m
.20982 .21479 -0.56518 .7779 Mabsadd L
.20982 .21479 -2.37764 .77254 Mabsadd L
.20982 .21479 -0.91448 -0.29713 Mabsadd L
.20982 .21479 -1.46946 -2.02254 Mabsadd L
.20982 .21479 0 -0.96154 Mabsadd L
.20982 .21479 1.46946 -2.02254 Mabsadd L
.20982 .21479 .91448 -0.29713 Mabsadd L
.20982 .21479 2.37764 .77254 Mabsadd L
.20982 .21479 .56518 .7779 Mabsadd L
.20982 .21479 0 2.5 Mabsadd L closepath F
.21131 .21632 0 2.5 Mabsadd m
.21131 .21632 -0.56518 .7779 Mabsadd L
.21131 .21632 -2.37764 .77254 Mabsadd L
.21131 .21632 -0.91448 -0.29713 Mabsadd L
.21131 .21632 -1.46946 -2.02254 Mabsadd L
.21131 .21632 0 -0.96154 Mabsadd L
.21131 .21632 1.46946 -2.02254 Mabsadd L
.21131 .21632 .91448 -0.29713 Mabsadd L
.21131 .21632 2.37764 .77254 Mabsadd L
.21131 .21632 .56518 .7779 Mabsadd L
.21131 .21632 0 2.5 Mabsadd L closepath F
.2128 .21784 0 2.5 Mabsadd m
.2128 .21784 -0.56518 .7779 Mabsadd L
.2128 .21784 -2.37764 .77254 Mabsadd L
.2128 .21784 -0.91448 -0.29713 Mabsadd L
.2128 .21784 -1.46946 -2.02254 Mabsadd L
.2128 .21784 0 -0.96154 Mabsadd L
.2128 .21784 1.46946 -2.02254 Mabsadd L
.2128 .21784 .91448 -0.29713 Mabsadd L
.2128 .21784 2.37764 .77254 Mabsadd L
.2128 .21784 .56518 .7779 Mabsadd L
.2128 .21784 0 2.5 Mabsadd L closepath F
.21429 .21937 0 2.5 Mabsadd m
.21429 .21937 -0.56518 .7779 Mabsadd L
.21429 .21937 -2.37764 .77254 Mabsadd L
.21429 .21937 -0.91448 -0.29713 Mabsadd L
.21429 .21937 -1.46946 -2.02254 Mabsadd L
.21429 .21937 0 -0.96154 Mabsadd L
.21429 .21937 1.46946 -2.02254 Mabsadd L
.21429 .21937 .91448 -0.29713 Mabsadd L
.21429 .21937 2.37764 .77254 Mabsadd L
.21429 .21937 .56518 .7779 Mabsadd L
.21429 .21937 0 2.5 Mabsadd L closepath F
.21577 .2209 0 2.5 Mabsadd m
.21577 .2209 -0.56518 .7779 Mabsadd L
.21577 .2209 -2.37764 .77254 Mabsadd L
.21577 .2209 -0.91448 -0.29713 Mabsadd L
.21577 .2209 -1.46946 -2.02254 Mabsadd L
.21577 .2209 0 -0.96154 Mabsadd L
.21577 .2209 1.46946 -2.02254 Mabsadd L
.21577 .2209 .91448 -0.29713 Mabsadd L
.21577 .2209 2.37764 .77254 Mabsadd L
.21577 .2209 .56518 .7779 Mabsadd L
.21577 .2209 0 2.5 Mabsadd L closepath F
.21726 .22242 0 2.5 Mabsadd m
.21726 .22242 -0.56518 .7779 Mabsadd L
.21726 .22242 -2.37764 .77254 Mabsadd L
.21726 .22242 -0.91448 -0.29713 Mabsadd L
.21726 .22242 -1.46946 -2.02254 Mabsadd L
.21726 .22242 0 -0.96154 Mabsadd L
.21726 .22242 1.46946 -2.02254 Mabsadd L
.21726 .22242 .91448 -0.29713 Mabsadd L
.21726 .22242 2.37764 .77254 Mabsadd L
.21726 .22242 .56518 .7779 Mabsadd L
.21726 .22242 0 2.5 Mabsadd L closepath F
.21875 .22395 0 2.5 Mabsadd m
.21875 .22395 -0.56518 .7779 Mabsadd L
.21875 .22395 -2.37764 .77254 Mabsadd L
.21875 .22395 -0.91448 -0.29713 Mabsadd L
.21875 .22395 -1.46946 -2.02254 Mabsadd L
.21875 .22395 0 -0.96154 Mabsadd L
.21875 .22395 1.46946 -2.02254 Mabsadd L
.21875 .22395 .91448 -0.29713 Mabsadd L
.21875 .22395 2.37764 .77254 Mabsadd L
.21875 .22395 .56518 .7779 Mabsadd L
.21875 .22395 0 2.5 Mabsadd L closepath F
.22024 .22547 0 2.5 Mabsadd m
.22024 .22547 -0.56518 .7779 Mabsadd L
.22024 .22547 -2.37764 .77254 Mabsadd L
.22024 .22547 -0.91448 -0.29713 Mabsadd L
.22024 .22547 -1.46946 -2.02254 Mabsadd L
.22024 .22547 0 -0.96154 Mabsadd L
.22024 .22547 1.46946 -2.02254 Mabsadd L
.22024 .22547 .91448 -0.29713 Mabsadd L
.22024 .22547 2.37764 .77254 Mabsadd L
.22024 .22547 .56518 .7779 Mabsadd L
.22024 .22547 0 2.5 Mabsadd L closepath F
.22173 .227 0 2.5 Mabsadd m
.22173 .227 -0.56518 .7779 Mabsadd L
.22173 .227 -2.37764 .77254 Mabsadd L
.22173 .227 -0.91448 -0.29713 Mabsadd L
.22173 .227 -1.46946 -2.02254 Mabsadd L
.22173 .227 0 -0.96154 Mabsadd L
.22173 .227 1.46946 -2.02254 Mabsadd L
.22173 .227 .91448 -0.29713 Mabsadd L
.22173 .227 2.37764 .77254 Mabsadd L
.22173 .227 .56518 .7779 Mabsadd L
.22173 .227 0 2.5 Mabsadd L closepath F
.22321 .22852 0 2.5 Mabsadd m
.22321 .22852 -0.56518 .7779 Mabsadd L
.22321 .22852 -2.37764 .77254 Mabsadd L
.22321 .22852 -0.91448 -0.29713 Mabsadd L
.22321 .22852 -1.46946 -2.02254 Mabsadd L
.22321 .22852 0 -0.96154 Mabsadd L
.22321 .22852 1.46946 -2.02254 Mabsadd L
.22321 .22852 .91448 -0.29713 Mabsadd L
.22321 .22852 2.37764 .77254 Mabsadd L
.22321 .22852 .56518 .7779 Mabsadd L
.22321 .22852 0 2.5 Mabsadd L closepath F
.2247 .23005 0 2.5 Mabsadd m
.2247 .23005 -0.56518 .7779 Mabsadd L
.2247 .23005 -2.37764 .77254 Mabsadd L
.2247 .23005 -0.91448 -0.29713 Mabsadd L
.2247 .23005 -1.46946 -2.02254 Mabsadd L
.2247 .23005 0 -0.96154 Mabsadd L
.2247 .23005 1.46946 -2.02254 Mabsadd L
.2247 .23005 .91448 -0.29713 Mabsadd L
.2247 .23005 2.37764 .77254 Mabsadd L
.2247 .23005 .56518 .7779 Mabsadd L
.2247 .23005 0 2.5 Mabsadd L closepath F
.22619 .23157 0 2.5 Mabsadd m
.22619 .23157 -0.56518 .7779 Mabsadd L
.22619 .23157 -2.37764 .77254 Mabsadd L
.22619 .23157 -0.91448 -0.29713 Mabsadd L
.22619 .23157 -1.46946 -2.02254 Mabsadd L
.22619 .23157 0 -0.96154 Mabsadd L
.22619 .23157 1.46946 -2.02254 Mabsadd L
.22619 .23157 .91448 -0.29713 Mabsadd L
.22619 .23157 2.37764 .77254 Mabsadd L
.22619 .23157 .56518 .7779 Mabsadd L
.22619 .23157 0 2.5 Mabsadd L closepath F
.22768 .2331 0 2.5 Mabsadd m
.22768 .2331 -0.56518 .7779 Mabsadd L
.22768 .2331 -2.37764 .77254 Mabsadd L
.22768 .2331 -0.91448 -0.29713 Mabsadd L
.22768 .2331 -1.46946 -2.02254 Mabsadd L
.22768 .2331 0 -0.96154 Mabsadd L
.22768 .2331 1.46946 -2.02254 Mabsadd L
.22768 .2331 .91448 -0.29713 Mabsadd L
.22768 .2331 2.37764 .77254 Mabsadd L
.22768 .2331 .56518 .7779 Mabsadd L
.22768 .2331 0 2.5 Mabsadd L closepath F
.22917 .23463 0 2.5 Mabsadd m
.22917 .23463 -0.56518 .7779 Mabsadd L
.22917 .23463 -2.37764 .77254 Mabsadd L
.22917 .23463 -0.91448 -0.29713 Mabsadd L
.22917 .23463 -1.46946 -2.02254 Mabsadd L
.22917 .23463 0 -0.96154 Mabsadd L
.22917 .23463 1.46946 -2.02254 Mabsadd L
.22917 .23463 .91448 -0.29713 Mabsadd L
.22917 .23463 2.37764 .77254 Mabsadd L
.22917 .23463 .56518 .7779 Mabsadd L
.22917 .23463 0 2.5 Mabsadd L closepath F
.23065 .23615 0 2.5 Mabsadd m
.23065 .23615 -0.56518 .7779 Mabsadd L
.23065 .23615 -2.37764 .77254 Mabsadd L
.23065 .23615 -0.91448 -0.29713 Mabsadd L
.23065 .23615 -1.46946 -2.02254 Mabsadd L
.23065 .23615 0 -0.96154 Mabsadd L
.23065 .23615 1.46946 -2.02254 Mabsadd L
.23065 .23615 .91448 -0.29713 Mabsadd L
.23065 .23615 2.37764 .77254 Mabsadd L
.23065 .23615 .56518 .7779 Mabsadd L
.23065 .23615 0 2.5 Mabsadd L closepath F
.23214 .23768 0 2.5 Mabsadd m
.23214 .23768 -0.56518 .7779 Mabsadd L
.23214 .23768 -2.37764 .77254 Mabsadd L
.23214 .23768 -0.91448 -0.29713 Mabsadd L
.23214 .23768 -1.46946 -2.02254 Mabsadd L
.23214 .23768 0 -0.96154 Mabsadd L
.23214 .23768 1.46946 -2.02254 Mabsadd L
.23214 .23768 .91448 -0.29713 Mabsadd L
.23214 .23768 2.37764 .77254 Mabsadd L
.23214 .23768 .56518 .7779 Mabsadd L
.23214 .23768 0 2.5 Mabsadd L closepath F
.23363 .2392 0 2.5 Mabsadd m
.23363 .2392 -0.56518 .7779 Mabsadd L
.23363 .2392 -2.37764 .77254 Mabsadd L
.23363 .2392 -0.91448 -0.29713 Mabsadd L
.23363 .2392 -1.46946 -2.02254 Mabsadd L
.23363 .2392 0 -0.96154 Mabsadd L
.23363 .2392 1.46946 -2.02254 Mabsadd L
.23363 .2392 .91448 -0.29713 Mabsadd L
.23363 .2392 2.37764 .77254 Mabsadd L
.23363 .2392 .56518 .7779 Mabsadd L
.23363 .2392 0 2.5 Mabsadd L closepath F
.23512 .24073 0 2.5 Mabsadd m
.23512 .24073 -0.56518 .7779 Mabsadd L
.23512 .24073 -2.37764 .77254 Mabsadd L
.23512 .24073 -0.91448 -0.29713 Mabsadd L
.23512 .24073 -1.46946 -2.02254 Mabsadd L
.23512 .24073 0 -0.96154 Mabsadd L
.23512 .24073 1.46946 -2.02254 Mabsadd L
.23512 .24073 .91448 -0.29713 Mabsadd L
.23512 .24073 2.37764 .77254 Mabsadd L
.23512 .24073 .56518 .7779 Mabsadd L
.23512 .24073 0 2.5 Mabsadd L closepath F
.23661 .24225 0 2.5 Mabsadd m
.23661 .24225 -0.56518 .7779 Mabsadd L
.23661 .24225 -2.37764 .77254 Mabsadd L
.23661 .24225 -0.91448 -0.29713 Mabsadd L
.23661 .24225 -1.46946 -2.02254 Mabsadd L
.23661 .24225 0 -0.96154 Mabsadd L
.23661 .24225 1.46946 -2.02254 Mabsadd L
.23661 .24225 .91448 -0.29713 Mabsadd L
.23661 .24225 2.37764 .77254 Mabsadd L
.23661 .24225 .56518 .7779 Mabsadd L
.23661 .24225 0 2.5 Mabsadd L closepath F
.2381 .24378 0 2.5 Mabsadd m
.2381 .24378 -0.56518 .7779 Mabsadd L
.2381 .24378 -2.37764 .77254 Mabsadd L
.2381 .24378 -0.91448 -0.29713 Mabsadd L
.2381 .24378 -1.46946 -2.02254 Mabsadd L
.2381 .24378 0 -0.96154 Mabsadd L
.2381 .24378 1.46946 -2.02254 Mabsadd L
.2381 .24378 .91448 -0.29713 Mabsadd L
.2381 .24378 2.37764 .77254 Mabsadd L
.2381 .24378 .56518 .7779 Mabsadd L
.2381 .24378 0 2.5 Mabsadd L closepath F
.23958 .2453 0 2.5 Mabsadd m
.23958 .2453 -0.56518 .7779 Mabsadd L
.23958 .2453 -2.37764 .77254 Mabsadd L
.23958 .2453 -0.91448 -0.29713 Mabsadd L
.23958 .2453 -1.46946 -2.02254 Mabsadd L
.23958 .2453 0 -0.96154 Mabsadd L
.23958 .2453 1.46946 -2.02254 Mabsadd L
.23958 .2453 .91448 -0.29713 Mabsadd L
.23958 .2453 2.37764 .77254 Mabsadd L
.23958 .2453 .56518 .7779 Mabsadd L
.23958 .2453 0 2.5 Mabsadd L closepath F
.24107 .24683 0 2.5 Mabsadd m
.24107 .24683 -0.56518 .7779 Mabsadd L
.24107 .24683 -2.37764 .77254 Mabsadd L
.24107 .24683 -0.91448 -0.29713 Mabsadd L
.24107 .24683 -1.46946 -2.02254 Mabsadd L
.24107 .24683 0 -0.96154 Mabsadd L
.24107 .24683 1.46946 -2.02254 Mabsadd L
.24107 .24683 .91448 -0.29713 Mabsadd L
.24107 .24683 2.37764 .77254 Mabsadd L
.24107 .24683 .56518 .7779 Mabsadd L
.24107 .24683 0 2.5 Mabsadd L closepath F
.24256 .24835 0 2.5 Mabsadd m
.24256 .24835 -0.56518 .7779 Mabsadd L
.24256 .24835 -2.37764 .77254 Mabsadd L
.24256 .24835 -0.91448 -0.29713 Mabsadd L
.24256 .24835 -1.46946 -2.02254 Mabsadd L
.24256 .24835 0 -0.96154 Mabsadd L
.24256 .24835 1.46946 -2.02254 Mabsadd L
.24256 .24835 .91448 -0.29713 Mabsadd L
.24256 .24835 2.37764 .77254 Mabsadd L
.24256 .24835 .56518 .7779 Mabsadd L
.24256 .24835 0 2.5 Mabsadd L closepath F
.24405 .24988 0 2.5 Mabsadd m
.24405 .24988 -0.56518 .7779 Mabsadd L
.24405 .24988 -2.37764 .77254 Mabsadd L
.24405 .24988 -0.91448 -0.29713 Mabsadd L
.24405 .24988 -1.46946 -2.02254 Mabsadd L
.24405 .24988 0 -0.96154 Mabsadd L
.24405 .24988 1.46946 -2.02254 Mabsadd L
.24405 .24988 .91448 -0.29713 Mabsadd L
.24405 .24988 2.37764 .77254 Mabsadd L
.24405 .24988 .56518 .7779 Mabsadd L
.24405 .24988 0 2.5 Mabsadd L closepath F
.24554 .2514 0 2.5 Mabsadd m
.24554 .2514 -0.56518 .7779 Mabsadd L
.24554 .2514 -2.37764 .77254 Mabsadd L
.24554 .2514 -0.91448 -0.29713 Mabsadd L
.24554 .2514 -1.46946 -2.02254 Mabsadd L
.24554 .2514 0 -0.96154 Mabsadd L
.24554 .2514 1.46946 -2.02254 Mabsadd L
.24554 .2514 .91448 -0.29713 Mabsadd L
.24554 .2514 2.37764 .77254 Mabsadd L
.24554 .2514 .56518 .7779 Mabsadd L
.24554 .2514 0 2.5 Mabsadd L closepath F
.24702 .25292 0 2.5 Mabsadd m
.24702 .25292 -0.56518 .7779 Mabsadd L
.24702 .25292 -2.37764 .77254 Mabsadd L
.24702 .25292 -0.91448 -0.29713 Mabsadd L
.24702 .25292 -1.46946 -2.02254 Mabsadd L
.24702 .25292 0 -0.96154 Mabsadd L
.24702 .25292 1.46946 -2.02254 Mabsadd L
.24702 .25292 .91448 -0.29713 Mabsadd L
.24702 .25292 2.37764 .77254 Mabsadd L
.24702 .25292 .56518 .7779 Mabsadd L
.24702 .25292 0 2.5 Mabsadd L closepath F
.24851 .25445 0 2.5 Mabsadd m
.24851 .25445 -0.56518 .7779 Mabsadd L
.24851 .25445 -2.37764 .77254 Mabsadd L
.24851 .25445 -0.91448 -0.29713 Mabsadd L
.24851 .25445 -1.46946 -2.02254 Mabsadd L
.24851 .25445 0 -0.96154 Mabsadd L
.24851 .25445 1.46946 -2.02254 Mabsadd L
.24851 .25445 .91448 -0.29713 Mabsadd L
.24851 .25445 2.37764 .77254 Mabsadd L
.24851 .25445 .56518 .7779 Mabsadd L
.24851 .25445 0 2.5 Mabsadd L closepath F
.25 .25597 0 2.5 Mabsadd m
.25 .25597 -0.56518 .7779 Mabsadd L
.25 .25597 -2.37764 .77254 Mabsadd L
.25 .25597 -0.91448 -0.29713 Mabsadd L
.25 .25597 -1.46946 -2.02254 Mabsadd L
.25 .25597 0 -0.96154 Mabsadd L
.25 .25597 1.46946 -2.02254 Mabsadd L
.25 .25597 .91448 -0.29713 Mabsadd L
.25 .25597 2.37764 .77254 Mabsadd L
.25 .25597 .56518 .7779 Mabsadd L
.25 .25597 0 2.5 Mabsadd L closepath F
.25149 .2575 0 2.5 Mabsadd m
.25149 .2575 -0.56518 .7779 Mabsadd L
.25149 .2575 -2.37764 .77254 Mabsadd L
.25149 .2575 -0.91448 -0.29713 Mabsadd L
.25149 .2575 -1.46946 -2.02254 Mabsadd L
.25149 .2575 0 -0.96154 Mabsadd L
.25149 .2575 1.46946 -2.02254 Mabsadd L
.25149 .2575 .91448 -0.29713 Mabsadd L
.25149 .2575 2.37764 .77254 Mabsadd L
.25149 .2575 .56518 .7779 Mabsadd L
.25149 .2575 0 2.5 Mabsadd L closepath F
.25298 .25902 0 2.5 Mabsadd m
.25298 .25902 -0.56518 .7779 Mabsadd L
.25298 .25902 -2.37764 .77254 Mabsadd L
.25298 .25902 -0.91448 -0.29713 Mabsadd L
.25298 .25902 -1.46946 -2.02254 Mabsadd L
.25298 .25902 0 -0.96154 Mabsadd L
.25298 .25902 1.46946 -2.02254 Mabsadd L
.25298 .25902 .91448 -0.29713 Mabsadd L
.25298 .25902 2.37764 .77254 Mabsadd L
.25298 .25902 .56518 .7779 Mabsadd L
.25298 .25902 0 2.5 Mabsadd L closepath F
.25446 .26055 0 2.5 Mabsadd m
.25446 .26055 -0.56518 .7779 Mabsadd L
.25446 .26055 -2.37764 .77254 Mabsadd L
.25446 .26055 -0.91448 -0.29713 Mabsadd L
.25446 .26055 -1.46946 -2.02254 Mabsadd L
.25446 .26055 0 -0.96154 Mabsadd L
.25446 .26055 1.46946 -2.02254 Mabsadd L
.25446 .26055 .91448 -0.29713 Mabsadd L
.25446 .26055 2.37764 .77254 Mabsadd L
.25446 .26055 .56518 .7779 Mabsadd L
.25446 .26055 0 2.5 Mabsadd L closepath F
.25595 .26207 0 2.5 Mabsadd m
.25595 .26207 -0.56518 .7779 Mabsadd L
.25595 .26207 -2.37764 .77254 Mabsadd L
.25595 .26207 -0.91448 -0.29713 Mabsadd L
.25595 .26207 -1.46946 -2.02254 Mabsadd L
.25595 .26207 0 -0.96154 Mabsadd L
.25595 .26207 1.46946 -2.02254 Mabsadd L
.25595 .26207 .91448 -0.29713 Mabsadd L
.25595 .26207 2.37764 .77254 Mabsadd L
.25595 .26207 .56518 .7779 Mabsadd L
.25595 .26207 0 2.5 Mabsadd L closepath F
.25744 .26359 0 2.5 Mabsadd m
.25744 .26359 -0.56518 .7779 Mabsadd L
.25744 .26359 -2.37764 .77254 Mabsadd L
.25744 .26359 -0.91448 -0.29713 Mabsadd L
.25744 .26359 -1.46946 -2.02254 Mabsadd L
.25744 .26359 0 -0.96154 Mabsadd L
.25744 .26359 1.46946 -2.02254 Mabsadd L
.25744 .26359 .91448 -0.29713 Mabsadd L
.25744 .26359 2.37764 .77254 Mabsadd L
.25744 .26359 .56518 .7779 Mabsadd L
.25744 .26359 0 2.5 Mabsadd L closepath F
.25893 .26512 0 2.5 Mabsadd m
.25893 .26512 -0.56518 .7779 Mabsadd L
.25893 .26512 -2.37764 .77254 Mabsadd L
.25893 .26512 -0.91448 -0.29713 Mabsadd L
.25893 .26512 -1.46946 -2.02254 Mabsadd L
.25893 .26512 0 -0.96154 Mabsadd L
.25893 .26512 1.46946 -2.02254 Mabsadd L
.25893 .26512 .91448 -0.29713 Mabsadd L
.25893 .26512 2.37764 .77254 Mabsadd L
.25893 .26512 .56518 .7779 Mabsadd L
.25893 .26512 0 2.5 Mabsadd L closepath F
.26042 .26664 0 2.5 Mabsadd m
.26042 .26664 -0.56518 .7779 Mabsadd L
.26042 .26664 -2.37764 .77254 Mabsadd L
.26042 .26664 -0.91448 -0.29713 Mabsadd L
.26042 .26664 -1.46946 -2.02254 Mabsadd L
.26042 .26664 0 -0.96154 Mabsadd L
.26042 .26664 1.46946 -2.02254 Mabsadd L
.26042 .26664 .91448 -0.29713 Mabsadd L
.26042 .26664 2.37764 .77254 Mabsadd L
.26042 .26664 .56518 .7779 Mabsadd L
.26042 .26664 0 2.5 Mabsadd L closepath F
.2619 .26817 0 2.5 Mabsadd m
.2619 .26817 -0.56518 .7779 Mabsadd L
.2619 .26817 -2.37764 .77254 Mabsadd L
.2619 .26817 -0.91448 -0.29713 Mabsadd L
.2619 .26817 -1.46946 -2.02254 Mabsadd L
.2619 .26817 0 -0.96154 Mabsadd L
.2619 .26817 1.46946 -2.02254 Mabsadd L
.2619 .26817 .91448 -0.29713 Mabsadd L
.2619 .26817 2.37764 .77254 Mabsadd L
.2619 .26817 .56518 .7779 Mabsadd L
.2619 .26817 0 2.5 Mabsadd L closepath F
.26339 .26969 0 2.5 Mabsadd m
.26339 .26969 -0.56518 .7779 Mabsadd L
.26339 .26969 -2.37764 .77254 Mabsadd L
.26339 .26969 -0.91448 -0.29713 Mabsadd L
.26339 .26969 -1.46946 -2.02254 Mabsadd L
.26339 .26969 0 -0.96154 Mabsadd L
.26339 .26969 1.46946 -2.02254 Mabsadd L
.26339 .26969 .91448 -0.29713 Mabsadd L
.26339 .26969 2.37764 .77254 Mabsadd L
.26339 .26969 .56518 .7779 Mabsadd L
.26339 .26969 0 2.5 Mabsadd L closepath F
.26488 .27121 0 2.5 Mabsadd m
.26488 .27121 -0.56518 .7779 Mabsadd L
.26488 .27121 -2.37764 .77254 Mabsadd L
.26488 .27121 -0.91448 -0.29713 Mabsadd L
.26488 .27121 -1.46946 -2.02254 Mabsadd L
.26488 .27121 0 -0.96154 Mabsadd L
.26488 .27121 1.46946 -2.02254 Mabsadd L
.26488 .27121 .91448 -0.29713 Mabsadd L
.26488 .27121 2.37764 .77254 Mabsadd L
.26488 .27121 .56518 .7779 Mabsadd L
.26488 .27121 0 2.5 Mabsadd L closepath F
.26637 .27274 0 2.5 Mabsadd m
.26637 .27274 -0.56518 .7779 Mabsadd L
.26637 .27274 -2.37764 .77254 Mabsadd L
.26637 .27274 -0.91448 -0.29713 Mabsadd L
.26637 .27274 -1.46946 -2.02254 Mabsadd L
.26637 .27274 0 -0.96154 Mabsadd L
.26637 .27274 1.46946 -2.02254 Mabsadd L
.26637 .27274 .91448 -0.29713 Mabsadd L
.26637 .27274 2.37764 .77254 Mabsadd L
.26637 .27274 .56518 .7779 Mabsadd L
.26637 .27274 0 2.5 Mabsadd L closepath F
.26786 .27426 0 2.5 Mabsadd m
.26786 .27426 -0.56518 .7779 Mabsadd L
.26786 .27426 -2.37764 .77254 Mabsadd L
.26786 .27426 -0.91448 -0.29713 Mabsadd L
.26786 .27426 -1.46946 -2.02254 Mabsadd L
.26786 .27426 0 -0.96154 Mabsadd L
.26786 .27426 1.46946 -2.02254 Mabsadd L
.26786 .27426 .91448 -0.29713 Mabsadd L
.26786 .27426 2.37764 .77254 Mabsadd L
.26786 .27426 .56518 .7779 Mabsadd L
.26786 .27426 0 2.5 Mabsadd L closepath F
.26935 .27578 0 2.5 Mabsadd m
.26935 .27578 -0.56518 .7779 Mabsadd L
.26935 .27578 -2.37764 .77254 Mabsadd L
.26935 .27578 -0.91448 -0.29713 Mabsadd L
.26935 .27578 -1.46946 -2.02254 Mabsadd L
.26935 .27578 0 -0.96154 Mabsadd L
.26935 .27578 1.46946 -2.02254 Mabsadd L
.26935 .27578 .91448 -0.29713 Mabsadd L
.26935 .27578 2.37764 .77254 Mabsadd L
.26935 .27578 .56518 .7779 Mabsadd L
.26935 .27578 0 2.5 Mabsadd L closepath F
.27083 .27731 0 2.5 Mabsadd m
.27083 .27731 -0.56518 .7779 Mabsadd L
.27083 .27731 -2.37764 .77254 Mabsadd L
.27083 .27731 -0.91448 -0.29713 Mabsadd L
.27083 .27731 -1.46946 -2.02254 Mabsadd L
.27083 .27731 0 -0.96154 Mabsadd L
.27083 .27731 1.46946 -2.02254 Mabsadd L
.27083 .27731 .91448 -0.29713 Mabsadd L
.27083 .27731 2.37764 .77254 Mabsadd L
.27083 .27731 .56518 .7779 Mabsadd L
.27083 .27731 0 2.5 Mabsadd L closepath F
.27232 .27883 0 2.5 Mabsadd m
.27232 .27883 -0.56518 .7779 Mabsadd L
.27232 .27883 -2.37764 .77254 Mabsadd L
.27232 .27883 -0.91448 -0.29713 Mabsadd L
.27232 .27883 -1.46946 -2.02254 Mabsadd L
.27232 .27883 0 -0.96154 Mabsadd L
.27232 .27883 1.46946 -2.02254 Mabsadd L
.27232 .27883 .91448 -0.29713 Mabsadd L
.27232 .27883 2.37764 .77254 Mabsadd L
.27232 .27883 .56518 .7779 Mabsadd L
.27232 .27883 0 2.5 Mabsadd L closepath F
.27381 .28035 0 2.5 Mabsadd m
.27381 .28035 -0.56518 .7779 Mabsadd L
.27381 .28035 -2.37764 .77254 Mabsadd L
.27381 .28035 -0.91448 -0.29713 Mabsadd L
.27381 .28035 -1.46946 -2.02254 Mabsadd L
.27381 .28035 0 -0.96154 Mabsadd L
.27381 .28035 1.46946 -2.02254 Mabsadd L
.27381 .28035 .91448 -0.29713 Mabsadd L
.27381 .28035 2.37764 .77254 Mabsadd L
.27381 .28035 .56518 .7779 Mabsadd L
.27381 .28035 0 2.5 Mabsadd L closepath F
.2753 .28187 0 2.5 Mabsadd m
.2753 .28187 -0.56518 .7779 Mabsadd L
.2753 .28187 -2.37764 .77254 Mabsadd L
.2753 .28187 -0.91448 -0.29713 Mabsadd L
.2753 .28187 -1.46946 -2.02254 Mabsadd L
.2753 .28187 0 -0.96154 Mabsadd L
.2753 .28187 1.46946 -2.02254 Mabsadd L
.2753 .28187 .91448 -0.29713 Mabsadd L
.2753 .28187 2.37764 .77254 Mabsadd L
.2753 .28187 .56518 .7779 Mabsadd L
.2753 .28187 0 2.5 Mabsadd L closepath F
.27679 .2834 0 2.5 Mabsadd m
.27679 .2834 -0.56518 .7779 Mabsadd L
.27679 .2834 -2.37764 .77254 Mabsadd L
.27679 .2834 -0.91448 -0.29713 Mabsadd L
.27679 .2834 -1.46946 -2.02254 Mabsadd L
.27679 .2834 0 -0.96154 Mabsadd L
.27679 .2834 1.46946 -2.02254 Mabsadd L
.27679 .2834 .91448 -0.29713 Mabsadd L
.27679 .2834 2.37764 .77254 Mabsadd L
.27679 .2834 .56518 .7779 Mabsadd L
.27679 .2834 0 2.5 Mabsadd L closepath F
.27827 .28492 0 2.5 Mabsadd m
.27827 .28492 -0.56518 .7779 Mabsadd L
.27827 .28492 -2.37764 .77254 Mabsadd L
.27827 .28492 -0.91448 -0.29713 Mabsadd L
.27827 .28492 -1.46946 -2.02254 Mabsadd L
.27827 .28492 0 -0.96154 Mabsadd L
.27827 .28492 1.46946 -2.02254 Mabsadd L
.27827 .28492 .91448 -0.29713 Mabsadd L
.27827 .28492 2.37764 .77254 Mabsadd L
.27827 .28492 .56518 .7779 Mabsadd L
.27827 .28492 0 2.5 Mabsadd L closepath F
.27976 .28644 0 2.5 Mabsadd m
.27976 .28644 -0.56518 .7779 Mabsadd L
.27976 .28644 -2.37764 .77254 Mabsadd L
.27976 .28644 -0.91448 -0.29713 Mabsadd L
.27976 .28644 -1.46946 -2.02254 Mabsadd L
.27976 .28644 0 -0.96154 Mabsadd L
.27976 .28644 1.46946 -2.02254 Mabsadd L
.27976 .28644 .91448 -0.29713 Mabsadd L
.27976 .28644 2.37764 .77254 Mabsadd L
.27976 .28644 .56518 .7779 Mabsadd L
.27976 .28644 0 2.5 Mabsadd L closepath F
.28125 .28797 0 2.5 Mabsadd m
.28125 .28797 -0.56518 .7779 Mabsadd L
.28125 .28797 -2.37764 .77254 Mabsadd L
.28125 .28797 -0.91448 -0.29713 Mabsadd L
.28125 .28797 -1.46946 -2.02254 Mabsadd L
.28125 .28797 0 -0.96154 Mabsadd L
.28125 .28797 1.46946 -2.02254 Mabsadd L
.28125 .28797 .91448 -0.29713 Mabsadd L
.28125 .28797 2.37764 .77254 Mabsadd L
.28125 .28797 .56518 .7779 Mabsadd L
.28125 .28797 0 2.5 Mabsadd L closepath F
.28274 .28949 0 2.5 Mabsadd m
.28274 .28949 -0.56518 .7779 Mabsadd L
.28274 .28949 -2.37764 .77254 Mabsadd L
.28274 .28949 -0.91448 -0.29713 Mabsadd L
.28274 .28949 -1.46946 -2.02254 Mabsadd L
.28274 .28949 0 -0.96154 Mabsadd L
.28274 .28949 1.46946 -2.02254 Mabsadd L
.28274 .28949 .91448 -0.29713 Mabsadd L
.28274 .28949 2.37764 .77254 Mabsadd L
.28274 .28949 .56518 .7779 Mabsadd L
.28274 .28949 0 2.5 Mabsadd L closepath F
.28423 .29101 0 2.5 Mabsadd m
.28423 .29101 -0.56518 .7779 Mabsadd L
.28423 .29101 -2.37764 .77254 Mabsadd L
.28423 .29101 -0.91448 -0.29713 Mabsadd L
.28423 .29101 -1.46946 -2.02254 Mabsadd L
.28423 .29101 0 -0.96154 Mabsadd L
.28423 .29101 1.46946 -2.02254 Mabsadd L
.28423 .29101 .91448 -0.29713 Mabsadd L
.28423 .29101 2.37764 .77254 Mabsadd L
.28423 .29101 .56518 .7779 Mabsadd L
.28423 .29101 0 2.5 Mabsadd L closepath F
.28571 .29253 0 2.5 Mabsadd m
.28571 .29253 -0.56518 .7779 Mabsadd L
.28571 .29253 -2.37764 .77254 Mabsadd L
.28571 .29253 -0.91448 -0.29713 Mabsadd L
.28571 .29253 -1.46946 -2.02254 Mabsadd L
.28571 .29253 0 -0.96154 Mabsadd L
.28571 .29253 1.46946 -2.02254 Mabsadd L
.28571 .29253 .91448 -0.29713 Mabsadd L
.28571 .29253 2.37764 .77254 Mabsadd L
.28571 .29253 .56518 .7779 Mabsadd L
.28571 .29253 0 2.5 Mabsadd L closepath F
.2872 .29405 0 2.5 Mabsadd m
.2872 .29405 -0.56518 .7779 Mabsadd L
.2872 .29405 -2.37764 .77254 Mabsadd L
.2872 .29405 -0.91448 -0.29713 Mabsadd L
.2872 .29405 -1.46946 -2.02254 Mabsadd L
.2872 .29405 0 -0.96154 Mabsadd L
.2872 .29405 1.46946 -2.02254 Mabsadd L
.2872 .29405 .91448 -0.29713 Mabsadd L
.2872 .29405 2.37764 .77254 Mabsadd L
.2872 .29405 .56518 .7779 Mabsadd L
.2872 .29405 0 2.5 Mabsadd L closepath F
.28869 .29558 0 2.5 Mabsadd m
.28869 .29558 -0.56518 .7779 Mabsadd L
.28869 .29558 -2.37764 .77254 Mabsadd L
.28869 .29558 -0.91448 -0.29713 Mabsadd L
.28869 .29558 -1.46946 -2.02254 Mabsadd L
.28869 .29558 0 -0.96154 Mabsadd L
.28869 .29558 1.46946 -2.02254 Mabsadd L
.28869 .29558 .91448 -0.29713 Mabsadd L
.28869 .29558 2.37764 .77254 Mabsadd L
.28869 .29558 .56518 .7779 Mabsadd L
.28869 .29558 0 2.5 Mabsadd L closepath F
.29018 .2971 0 2.5 Mabsadd m
.29018 .2971 -0.56518 .7779 Mabsadd L
.29018 .2971 -2.37764 .77254 Mabsadd L
.29018 .2971 -0.91448 -0.29713 Mabsadd L
.29018 .2971 -1.46946 -2.02254 Mabsadd L
.29018 .2971 0 -0.96154 Mabsadd L
.29018 .2971 1.46946 -2.02254 Mabsadd L
.29018 .2971 .91448 -0.29713 Mabsadd L
.29018 .2971 2.37764 .77254 Mabsadd L
.29018 .2971 .56518 .7779 Mabsadd L
.29018 .2971 0 2.5 Mabsadd L closepath F
.29167 .29862 0 2.5 Mabsadd m
.29167 .29862 -0.56518 .7779 Mabsadd L
.29167 .29862 -2.37764 .77254 Mabsadd L
.29167 .29862 -0.91448 -0.29713 Mabsadd L
.29167 .29862 -1.46946 -2.02254 Mabsadd L
.29167 .29862 0 -0.96154 Mabsadd L
.29167 .29862 1.46946 -2.02254 Mabsadd L
.29167 .29862 .91448 -0.29713 Mabsadd L
.29167 .29862 2.37764 .77254 Mabsadd L
.29167 .29862 .56518 .7779 Mabsadd L
.29167 .29862 0 2.5 Mabsadd L closepath F
.29315 .30014 0 2.5 Mabsadd m
.29315 .30014 -0.56518 .7779 Mabsadd L
.29315 .30014 -2.37764 .77254 Mabsadd L
.29315 .30014 -0.91448 -0.29713 Mabsadd L
.29315 .30014 -1.46946 -2.02254 Mabsadd L
.29315 .30014 0 -0.96154 Mabsadd L
.29315 .30014 1.46946 -2.02254 Mabsadd L
.29315 .30014 .91448 -0.29713 Mabsadd L
.29315 .30014 2.37764 .77254 Mabsadd L
.29315 .30014 .56518 .7779 Mabsadd L
.29315 .30014 0 2.5 Mabsadd L closepath F
.29464 .30166 0 2.5 Mabsadd m
.29464 .30166 -0.56518 .7779 Mabsadd L
.29464 .30166 -2.37764 .77254 Mabsadd L
.29464 .30166 -0.91448 -0.29713 Mabsadd L
.29464 .30166 -1.46946 -2.02254 Mabsadd L
.29464 .30166 0 -0.96154 Mabsadd L
.29464 .30166 1.46946 -2.02254 Mabsadd L
.29464 .30166 .91448 -0.29713 Mabsadd L
.29464 .30166 2.37764 .77254 Mabsadd L
.29464 .30166 .56518 .7779 Mabsadd L
.29464 .30166 0 2.5 Mabsadd L closepath F
.29613 .30318 0 2.5 Mabsadd m
.29613 .30318 -0.56518 .7779 Mabsadd L
.29613 .30318 -2.37764 .77254 Mabsadd L
.29613 .30318 -0.91448 -0.29713 Mabsadd L
.29613 .30318 -1.46946 -2.02254 Mabsadd L
.29613 .30318 0 -0.96154 Mabsadd L
.29613 .30318 1.46946 -2.02254 Mabsadd L
.29613 .30318 .91448 -0.29713 Mabsadd L
.29613 .30318 2.37764 .77254 Mabsadd L
.29613 .30318 .56518 .7779 Mabsadd L
.29613 .30318 0 2.5 Mabsadd L closepath F
.29762 .30471 0 2.5 Mabsadd m
.29762 .30471 -0.56518 .7779 Mabsadd L
.29762 .30471 -2.37764 .77254 Mabsadd L
.29762 .30471 -0.91448 -0.29713 Mabsadd L
.29762 .30471 -1.46946 -2.02254 Mabsadd L
.29762 .30471 0 -0.96154 Mabsadd L
.29762 .30471 1.46946 -2.02254 Mabsadd L
.29762 .30471 .91448 -0.29713 Mabsadd L
.29762 .30471 2.37764 .77254 Mabsadd L
.29762 .30471 .56518 .7779 Mabsadd L
.29762 .30471 0 2.5 Mabsadd L closepath F
.29911 .30623 0 2.5 Mabsadd m
.29911 .30623 -0.56518 .7779 Mabsadd L
.29911 .30623 -2.37764 .77254 Mabsadd L
.29911 .30623 -0.91448 -0.29713 Mabsadd L
.29911 .30623 -1.46946 -2.02254 Mabsadd L
.29911 .30623 0 -0.96154 Mabsadd L
.29911 .30623 1.46946 -2.02254 Mabsadd L
.29911 .30623 .91448 -0.29713 Mabsadd L
.29911 .30623 2.37764 .77254 Mabsadd L
.29911 .30623 .56518 .7779 Mabsadd L
.29911 .30623 0 2.5 Mabsadd L closepath F
.3006 .30775 0 2.5 Mabsadd m
.3006 .30775 -0.56518 .7779 Mabsadd L
.3006 .30775 -2.37764 .77254 Mabsadd L
.3006 .30775 -0.91448 -0.29713 Mabsadd L
.3006 .30775 -1.46946 -2.02254 Mabsadd L
.3006 .30775 0 -0.96154 Mabsadd L
.3006 .30775 1.46946 -2.02254 Mabsadd L
.3006 .30775 .91448 -0.29713 Mabsadd L
.3006 .30775 2.37764 .77254 Mabsadd L
.3006 .30775 .56518 .7779 Mabsadd L
.3006 .30775 0 2.5 Mabsadd L closepath F
.30208 .30927 0 2.5 Mabsadd m
.30208 .30927 -0.56518 .7779 Mabsadd L
.30208 .30927 -2.37764 .77254 Mabsadd L
.30208 .30927 -0.91448 -0.29713 Mabsadd L
.30208 .30927 -1.46946 -2.02254 Mabsadd L
.30208 .30927 0 -0.96154 Mabsadd L
.30208 .30927 1.46946 -2.02254 Mabsadd L
.30208 .30927 .91448 -0.29713 Mabsadd L
.30208 .30927 2.37764 .77254 Mabsadd L
.30208 .30927 .56518 .7779 Mabsadd L
.30208 .30927 0 2.5 Mabsadd L closepath F
.30357 .31079 0 2.5 Mabsadd m
.30357 .31079 -0.56518 .7779 Mabsadd L
.30357 .31079 -2.37764 .77254 Mabsadd L
.30357 .31079 -0.91448 -0.29713 Mabsadd L
.30357 .31079 -1.46946 -2.02254 Mabsadd L
.30357 .31079 0 -0.96154 Mabsadd L
.30357 .31079 1.46946 -2.02254 Mabsadd L
.30357 .31079 .91448 -0.29713 Mabsadd L
.30357 .31079 2.37764 .77254 Mabsadd L
.30357 .31079 .56518 .7779 Mabsadd L
.30357 .31079 0 2.5 Mabsadd L closepath F
.30506 .31231 0 2.5 Mabsadd m
.30506 .31231 -0.56518 .7779 Mabsadd L
.30506 .31231 -2.37764 .77254 Mabsadd L
.30506 .31231 -0.91448 -0.29713 Mabsadd L
.30506 .31231 -1.46946 -2.02254 Mabsadd L
.30506 .31231 0 -0.96154 Mabsadd L
.30506 .31231 1.46946 -2.02254 Mabsadd L
.30506 .31231 .91448 -0.29713 Mabsadd L
.30506 .31231 2.37764 .77254 Mabsadd L
.30506 .31231 .56518 .7779 Mabsadd L
.30506 .31231 0 2.5 Mabsadd L closepath F
.30655 .31383 0 2.5 Mabsadd m
.30655 .31383 -0.56518 .7779 Mabsadd L
.30655 .31383 -2.37764 .77254 Mabsadd L
.30655 .31383 -0.91448 -0.29713 Mabsadd L
.30655 .31383 -1.46946 -2.02254 Mabsadd L
.30655 .31383 0 -0.96154 Mabsadd L
.30655 .31383 1.46946 -2.02254 Mabsadd L
.30655 .31383 .91448 -0.29713 Mabsadd L
.30655 .31383 2.37764 .77254 Mabsadd L
.30655 .31383 .56518 .7779 Mabsadd L
.30655 .31383 0 2.5 Mabsadd L closepath F
.30804 .31535 0 2.5 Mabsadd m
.30804 .31535 -0.56518 .7779 Mabsadd L
.30804 .31535 -2.37764 .77254 Mabsadd L
.30804 .31535 -0.91448 -0.29713 Mabsadd L
.30804 .31535 -1.46946 -2.02254 Mabsadd L
.30804 .31535 0 -0.96154 Mabsadd L
.30804 .31535 1.46946 -2.02254 Mabsadd L
.30804 .31535 .91448 -0.29713 Mabsadd L
.30804 .31535 2.37764 .77254 Mabsadd L
.30804 .31535 .56518 .7779 Mabsadd L
.30804 .31535 0 2.5 Mabsadd L closepath F
.30952 .31687 0 2.5 Mabsadd m
.30952 .31687 -0.56518 .7779 Mabsadd L
.30952 .31687 -2.37764 .77254 Mabsadd L
.30952 .31687 -0.91448 -0.29713 Mabsadd L
.30952 .31687 -1.46946 -2.02254 Mabsadd L
.30952 .31687 0 -0.96154 Mabsadd L
.30952 .31687 1.46946 -2.02254 Mabsadd L
.30952 .31687 .91448 -0.29713 Mabsadd L
.30952 .31687 2.37764 .77254 Mabsadd L
.30952 .31687 .56518 .7779 Mabsadd L
.30952 .31687 0 2.5 Mabsadd L closepath F
.31101 .31839 0 2.5 Mabsadd m
.31101 .31839 -0.56518 .7779 Mabsadd L
.31101 .31839 -2.37764 .77254 Mabsadd L
.31101 .31839 -0.91448 -0.29713 Mabsadd L
.31101 .31839 -1.46946 -2.02254 Mabsadd L
.31101 .31839 0 -0.96154 Mabsadd L
.31101 .31839 1.46946 -2.02254 Mabsadd L
.31101 .31839 .91448 -0.29713 Mabsadd L
.31101 .31839 2.37764 .77254 Mabsadd L
.31101 .31839 .56518 .7779 Mabsadd L
.31101 .31839 0 2.5 Mabsadd L closepath F
.3125 .31991 0 2.5 Mabsadd m
.3125 .31991 -0.56518 .7779 Mabsadd L
.3125 .31991 -2.37764 .77254 Mabsadd L
.3125 .31991 -0.91448 -0.29713 Mabsadd L
.3125 .31991 -1.46946 -2.02254 Mabsadd L
.3125 .31991 0 -0.96154 Mabsadd L
.3125 .31991 1.46946 -2.02254 Mabsadd L
.3125 .31991 .91448 -0.29713 Mabsadd L
.3125 .31991 2.37764 .77254 Mabsadd L
.3125 .31991 .56518 .7779 Mabsadd L
.3125 .31991 0 2.5 Mabsadd L closepath F
.31399 .32143 0 2.5 Mabsadd m
.31399 .32143 -0.56518 .7779 Mabsadd L
.31399 .32143 -2.37764 .77254 Mabsadd L
.31399 .32143 -0.91448 -0.29713 Mabsadd L
.31399 .32143 -1.46946 -2.02254 Mabsadd L
.31399 .32143 0 -0.96154 Mabsadd L
.31399 .32143 1.46946 -2.02254 Mabsadd L
.31399 .32143 .91448 -0.29713 Mabsadd L
.31399 .32143 2.37764 .77254 Mabsadd L
.31399 .32143 .56518 .7779 Mabsadd L
.31399 .32143 0 2.5 Mabsadd L closepath F
.31548 .32295 0 2.5 Mabsadd m
.31548 .32295 -0.56518 .7779 Mabsadd L
.31548 .32295 -2.37764 .77254 Mabsadd L
.31548 .32295 -0.91448 -0.29713 Mabsadd L
.31548 .32295 -1.46946 -2.02254 Mabsadd L
.31548 .32295 0 -0.96154 Mabsadd L
.31548 .32295 1.46946 -2.02254 Mabsadd L
.31548 .32295 .91448 -0.29713 Mabsadd L
.31548 .32295 2.37764 .77254 Mabsadd L
.31548 .32295 .56518 .7779 Mabsadd L
.31548 .32295 0 2.5 Mabsadd L closepath F
.31696 .32447 0 2.5 Mabsadd m
.31696 .32447 -0.56518 .7779 Mabsadd L
.31696 .32447 -2.37764 .77254 Mabsadd L
.31696 .32447 -0.91448 -0.29713 Mabsadd L
.31696 .32447 -1.46946 -2.02254 Mabsadd L
.31696 .32447 0 -0.96154 Mabsadd L
.31696 .32447 1.46946 -2.02254 Mabsadd L
.31696 .32447 .91448 -0.29713 Mabsadd L
.31696 .32447 2.37764 .77254 Mabsadd L
.31696 .32447 .56518 .7779 Mabsadd L
.31696 .32447 0 2.5 Mabsadd L closepath F
.31845 .32599 0 2.5 Mabsadd m
.31845 .32599 -0.56518 .7779 Mabsadd L
.31845 .32599 -2.37764 .77254 Mabsadd L
.31845 .32599 -0.91448 -0.29713 Mabsadd L
.31845 .32599 -1.46946 -2.02254 Mabsadd L
.31845 .32599 0 -0.96154 Mabsadd L
.31845 .32599 1.46946 -2.02254 Mabsadd L
.31845 .32599 .91448 -0.29713 Mabsadd L
.31845 .32599 2.37764 .77254 Mabsadd L
.31845 .32599 .56518 .7779 Mabsadd L
.31845 .32599 0 2.5 Mabsadd L closepath F
.31994 .32751 0 2.5 Mabsadd m
.31994 .32751 -0.56518 .7779 Mabsadd L
.31994 .32751 -2.37764 .77254 Mabsadd L
.31994 .32751 -0.91448 -0.29713 Mabsadd L
.31994 .32751 -1.46946 -2.02254 Mabsadd L
.31994 .32751 0 -0.96154 Mabsadd L
.31994 .32751 1.46946 -2.02254 Mabsadd L
.31994 .32751 .91448 -0.29713 Mabsadd L
.31994 .32751 2.37764 .77254 Mabsadd L
.31994 .32751 .56518 .7779 Mabsadd L
.31994 .32751 0 2.5 Mabsadd L closepath F
.32143 .32903 0 2.5 Mabsadd m
.32143 .32903 -0.56518 .7779 Mabsadd L
.32143 .32903 -2.37764 .77254 Mabsadd L
.32143 .32903 -0.91448 -0.29713 Mabsadd L
.32143 .32903 -1.46946 -2.02254 Mabsadd L
.32143 .32903 0 -0.96154 Mabsadd L
.32143 .32903 1.46946 -2.02254 Mabsadd L
.32143 .32903 .91448 -0.29713 Mabsadd L
.32143 .32903 2.37764 .77254 Mabsadd L
.32143 .32903 .56518 .7779 Mabsadd L
.32143 .32903 0 2.5 Mabsadd L closepath F
.32292 .33055 0 2.5 Mabsadd m
.32292 .33055 -0.56518 .7779 Mabsadd L
.32292 .33055 -2.37764 .77254 Mabsadd L
.32292 .33055 -0.91448 -0.29713 Mabsadd L
.32292 .33055 -1.46946 -2.02254 Mabsadd L
.32292 .33055 0 -0.96154 Mabsadd L
.32292 .33055 1.46946 -2.02254 Mabsadd L
.32292 .33055 .91448 -0.29713 Mabsadd L
.32292 .33055 2.37764 .77254 Mabsadd L
.32292 .33055 .56518 .7779 Mabsadd L
.32292 .33055 0 2.5 Mabsadd L closepath F
.3244 .33207 0 2.5 Mabsadd m
.3244 .33207 -0.56518 .7779 Mabsadd L
.3244 .33207 -2.37764 .77254 Mabsadd L
.3244 .33207 -0.91448 -0.29713 Mabsadd L
.3244 .33207 -1.46946 -2.02254 Mabsadd L
.3244 .33207 0 -0.96154 Mabsadd L
.3244 .33207 1.46946 -2.02254 Mabsadd L
.3244 .33207 .91448 -0.29713 Mabsadd L
.3244 .33207 2.37764 .77254 Mabsadd L
.3244 .33207 .56518 .7779 Mabsadd L
.3244 .33207 0 2.5 Mabsadd L closepath F
.32589 .33359 0 2.5 Mabsadd m
.32589 .33359 -0.56518 .7779 Mabsadd L
.32589 .33359 -2.37764 .77254 Mabsadd L
.32589 .33359 -0.91448 -0.29713 Mabsadd L
.32589 .33359 -1.46946 -2.02254 Mabsadd L
.32589 .33359 0 -0.96154 Mabsadd L
.32589 .33359 1.46946 -2.02254 Mabsadd L
.32589 .33359 .91448 -0.29713 Mabsadd L
.32589 .33359 2.37764 .77254 Mabsadd L
.32589 .33359 .56518 .7779 Mabsadd L
.32589 .33359 0 2.5 Mabsadd L closepath F
.32738 .33511 0 2.5 Mabsadd m
.32738 .33511 -0.56518 .7779 Mabsadd L
.32738 .33511 -2.37764 .77254 Mabsadd L
.32738 .33511 -0.91448 -0.29713 Mabsadd L
.32738 .33511 -1.46946 -2.02254 Mabsadd L
.32738 .33511 0 -0.96154 Mabsadd L
.32738 .33511 1.46946 -2.02254 Mabsadd L
.32738 .33511 .91448 -0.29713 Mabsadd L
.32738 .33511 2.37764 .77254 Mabsadd L
.32738 .33511 .56518 .7779 Mabsadd L
.32738 .33511 0 2.5 Mabsadd L closepath F
.32887 .33663 0 2.5 Mabsadd m
.32887 .33663 -0.56518 .7779 Mabsadd L
.32887 .33663 -2.37764 .77254 Mabsadd L
.32887 .33663 -0.91448 -0.29713 Mabsadd L
.32887 .33663 -1.46946 -2.02254 Mabsadd L
.32887 .33663 0 -0.96154 Mabsadd L
.32887 .33663 1.46946 -2.02254 Mabsadd L
.32887 .33663 .91448 -0.29713 Mabsadd L
.32887 .33663 2.37764 .77254 Mabsadd L
.32887 .33663 .56518 .7779 Mabsadd L
.32887 .33663 0 2.5 Mabsadd L closepath F
.33036 .33814 0 2.5 Mabsadd m
.33036 .33814 -0.56518 .7779 Mabsadd L
.33036 .33814 -2.37764 .77254 Mabsadd L
.33036 .33814 -0.91448 -0.29713 Mabsadd L
.33036 .33814 -1.46946 -2.02254 Mabsadd L
.33036 .33814 0 -0.96154 Mabsadd L
.33036 .33814 1.46946 -2.02254 Mabsadd L
.33036 .33814 .91448 -0.29713 Mabsadd L
.33036 .33814 2.37764 .77254 Mabsadd L
.33036 .33814 .56518 .7779 Mabsadd L
.33036 .33814 0 2.5 Mabsadd L closepath F
.33185 .33966 0 2.5 Mabsadd m
.33185 .33966 -0.56518 .7779 Mabsadd L
.33185 .33966 -2.37764 .77254 Mabsadd L
.33185 .33966 -0.91448 -0.29713 Mabsadd L
.33185 .33966 -1.46946 -2.02254 Mabsadd L
.33185 .33966 0 -0.96154 Mabsadd L
.33185 .33966 1.46946 -2.02254 Mabsadd L
.33185 .33966 .91448 -0.29713 Mabsadd L
.33185 .33966 2.37764 .77254 Mabsadd L
.33185 .33966 .56518 .7779 Mabsadd L
.33185 .33966 0 2.5 Mabsadd L closepath F
.33333 .34118 0 2.5 Mabsadd m
.33333 .34118 -0.56518 .7779 Mabsadd L
.33333 .34118 -2.37764 .77254 Mabsadd L
.33333 .34118 -0.91448 -0.29713 Mabsadd L
.33333 .34118 -1.46946 -2.02254 Mabsadd L
.33333 .34118 0 -0.96154 Mabsadd L
.33333 .34118 1.46946 -2.02254 Mabsadd L
.33333 .34118 .91448 -0.29713 Mabsadd L
.33333 .34118 2.37764 .77254 Mabsadd L
.33333 .34118 .56518 .7779 Mabsadd L
.33333 .34118 0 2.5 Mabsadd L closepath F
.33482 .3427 0 2.5 Mabsadd m
.33482 .3427 -0.56518 .7779 Mabsadd L
.33482 .3427 -2.37764 .77254 Mabsadd L
.33482 .3427 -0.91448 -0.29713 Mabsadd L
.33482 .3427 -1.46946 -2.02254 Mabsadd L
.33482 .3427 0 -0.96154 Mabsadd L
.33482 .3427 1.46946 -2.02254 Mabsadd L
.33482 .3427 .91448 -0.29713 Mabsadd L
.33482 .3427 2.37764 .77254 Mabsadd L
.33482 .3427 .56518 .7779 Mabsadd L
.33482 .3427 0 2.5 Mabsadd L closepath F
.33631 .34422 0 2.5 Mabsadd m
.33631 .34422 -0.56518 .7779 Mabsadd L
.33631 .34422 -2.37764 .77254 Mabsadd L
.33631 .34422 -0.91448 -0.29713 Mabsadd L
.33631 .34422 -1.46946 -2.02254 Mabsadd L
.33631 .34422 0 -0.96154 Mabsadd L
.33631 .34422 1.46946 -2.02254 Mabsadd L
.33631 .34422 .91448 -0.29713 Mabsadd L
.33631 .34422 2.37764 .77254 Mabsadd L
.33631 .34422 .56518 .7779 Mabsadd L
.33631 .34422 0 2.5 Mabsadd L closepath F
.3378 .34573 0 2.5 Mabsadd m
.3378 .34573 -0.56518 .7779 Mabsadd L
.3378 .34573 -2.37764 .77254 Mabsadd L
.3378 .34573 -0.91448 -0.29713 Mabsadd L
.3378 .34573 -1.46946 -2.02254 Mabsadd L
.3378 .34573 0 -0.96154 Mabsadd L
.3378 .34573 1.46946 -2.02254 Mabsadd L
.3378 .34573 .91448 -0.29713 Mabsadd L
.3378 .34573 2.37764 .77254 Mabsadd L
.3378 .34573 .56518 .7779 Mabsadd L
.3378 .34573 0 2.5 Mabsadd L closepath F
.33929 .34725 0 2.5 Mabsadd m
.33929 .34725 -0.56518 .7779 Mabsadd L
.33929 .34725 -2.37764 .77254 Mabsadd L
.33929 .34725 -0.91448 -0.29713 Mabsadd L
.33929 .34725 -1.46946 -2.02254 Mabsadd L
.33929 .34725 0 -0.96154 Mabsadd L
.33929 .34725 1.46946 -2.02254 Mabsadd L
.33929 .34725 .91448 -0.29713 Mabsadd L
.33929 .34725 2.37764 .77254 Mabsadd L
.33929 .34725 .56518 .7779 Mabsadd L
.33929 .34725 0 2.5 Mabsadd L closepath F
.34077 .34877 0 2.5 Mabsadd m
.34077 .34877 -0.56518 .7779 Mabsadd L
.34077 .34877 -2.37764 .77254 Mabsadd L
.34077 .34877 -0.91448 -0.29713 Mabsadd L
.34077 .34877 -1.46946 -2.02254 Mabsadd L
.34077 .34877 0 -0.96154 Mabsadd L
.34077 .34877 1.46946 -2.02254 Mabsadd L
.34077 .34877 .91448 -0.29713 Mabsadd L
.34077 .34877 2.37764 .77254 Mabsadd L
.34077 .34877 .56518 .7779 Mabsadd L
.34077 .34877 0 2.5 Mabsadd L closepath F
.34226 .35029 0 2.5 Mabsadd m
.34226 .35029 -0.56518 .7779 Mabsadd L
.34226 .35029 -2.37764 .77254 Mabsadd L
.34226 .35029 -0.91448 -0.29713 Mabsadd L
.34226 .35029 -1.46946 -2.02254 Mabsadd L
.34226 .35029 0 -0.96154 Mabsadd L
.34226 .35029 1.46946 -2.02254 Mabsadd L
.34226 .35029 .91448 -0.29713 Mabsadd L
.34226 .35029 2.37764 .77254 Mabsadd L
.34226 .35029 .56518 .7779 Mabsadd L
.34226 .35029 0 2.5 Mabsadd L closepath F
.34375 .35181 0 2.5 Mabsadd m
.34375 .35181 -0.56518 .7779 Mabsadd L
.34375 .35181 -2.37764 .77254 Mabsadd L
.34375 .35181 -0.91448 -0.29713 Mabsadd L
.34375 .35181 -1.46946 -2.02254 Mabsadd L
.34375 .35181 0 -0.96154 Mabsadd L
.34375 .35181 1.46946 -2.02254 Mabsadd L
.34375 .35181 .91448 -0.29713 Mabsadd L
.34375 .35181 2.37764 .77254 Mabsadd L
.34375 .35181 .56518 .7779 Mabsadd L
.34375 .35181 0 2.5 Mabsadd L closepath F
.34524 .35332 0 2.5 Mabsadd m
.34524 .35332 -0.56518 .7779 Mabsadd L
.34524 .35332 -2.37764 .77254 Mabsadd L
.34524 .35332 -0.91448 -0.29713 Mabsadd L
.34524 .35332 -1.46946 -2.02254 Mabsadd L
.34524 .35332 0 -0.96154 Mabsadd L
.34524 .35332 1.46946 -2.02254 Mabsadd L
.34524 .35332 .91448 -0.29713 Mabsadd L
.34524 .35332 2.37764 .77254 Mabsadd L
.34524 .35332 .56518 .7779 Mabsadd L
.34524 .35332 0 2.5 Mabsadd L closepath F
.34673 .35484 0 2.5 Mabsadd m
.34673 .35484 -0.56518 .7779 Mabsadd L
.34673 .35484 -2.37764 .77254 Mabsadd L
.34673 .35484 -0.91448 -0.29713 Mabsadd L
.34673 .35484 -1.46946 -2.02254 Mabsadd L
.34673 .35484 0 -0.96154 Mabsadd L
.34673 .35484 1.46946 -2.02254 Mabsadd L
.34673 .35484 .91448 -0.29713 Mabsadd L
.34673 .35484 2.37764 .77254 Mabsadd L
.34673 .35484 .56518 .7779 Mabsadd L
.34673 .35484 0 2.5 Mabsadd L closepath F
.34821 .35636 0 2.5 Mabsadd m
.34821 .35636 -0.56518 .7779 Mabsadd L
.34821 .35636 -2.37764 .77254 Mabsadd L
.34821 .35636 -0.91448 -0.29713 Mabsadd L
.34821 .35636 -1.46946 -2.02254 Mabsadd L
.34821 .35636 0 -0.96154 Mabsadd L
.34821 .35636 1.46946 -2.02254 Mabsadd L
.34821 .35636 .91448 -0.29713 Mabsadd L
.34821 .35636 2.37764 .77254 Mabsadd L
.34821 .35636 .56518 .7779 Mabsadd L
.34821 .35636 0 2.5 Mabsadd L closepath F
.3497 .35787 0 2.5 Mabsadd m
.3497 .35787 -0.56518 .7779 Mabsadd L
.3497 .35787 -2.37764 .77254 Mabsadd L
.3497 .35787 -0.91448 -0.29713 Mabsadd L
.3497 .35787 -1.46946 -2.02254 Mabsadd L
.3497 .35787 0 -0.96154 Mabsadd L
.3497 .35787 1.46946 -2.02254 Mabsadd L
.3497 .35787 .91448 -0.29713 Mabsadd L
.3497 .35787 2.37764 .77254 Mabsadd L
.3497 .35787 .56518 .7779 Mabsadd L
.3497 .35787 0 2.5 Mabsadd L closepath F
.35119 .35939 0 2.5 Mabsadd m
.35119 .35939 -0.56518 .7779 Mabsadd L
.35119 .35939 -2.37764 .77254 Mabsadd L
.35119 .35939 -0.91448 -0.29713 Mabsadd L
.35119 .35939 -1.46946 -2.02254 Mabsadd L
.35119 .35939 0 -0.96154 Mabsadd L
.35119 .35939 1.46946 -2.02254 Mabsadd L
.35119 .35939 .91448 -0.29713 Mabsadd L
.35119 .35939 2.37764 .77254 Mabsadd L
.35119 .35939 .56518 .7779 Mabsadd L
.35119 .35939 0 2.5 Mabsadd L closepath F
.35268 .36091 0 2.5 Mabsadd m
.35268 .36091 -0.56518 .7779 Mabsadd L
.35268 .36091 -2.37764 .77254 Mabsadd L
.35268 .36091 -0.91448 -0.29713 Mabsadd L
.35268 .36091 -1.46946 -2.02254 Mabsadd L
.35268 .36091 0 -0.96154 Mabsadd L
.35268 .36091 1.46946 -2.02254 Mabsadd L
.35268 .36091 .91448 -0.29713 Mabsadd L
.35268 .36091 2.37764 .77254 Mabsadd L
.35268 .36091 .56518 .7779 Mabsadd L
.35268 .36091 0 2.5 Mabsadd L closepath F
.35417 .36242 0 2.5 Mabsadd m
.35417 .36242 -0.56518 .7779 Mabsadd L
.35417 .36242 -2.37764 .77254 Mabsadd L
.35417 .36242 -0.91448 -0.29713 Mabsadd L
.35417 .36242 -1.46946 -2.02254 Mabsadd L
.35417 .36242 0 -0.96154 Mabsadd L
.35417 .36242 1.46946 -2.02254 Mabsadd L
.35417 .36242 .91448 -0.29713 Mabsadd L
.35417 .36242 2.37764 .77254 Mabsadd L
.35417 .36242 .56518 .7779 Mabsadd L
.35417 .36242 0 2.5 Mabsadd L closepath F
.35565 .36394 0 2.5 Mabsadd m
.35565 .36394 -0.56518 .7779 Mabsadd L
.35565 .36394 -2.37764 .77254 Mabsadd L
.35565 .36394 -0.91448 -0.29713 Mabsadd L
.35565 .36394 -1.46946 -2.02254 Mabsadd L
.35565 .36394 0 -0.96154 Mabsadd L
.35565 .36394 1.46946 -2.02254 Mabsadd L
.35565 .36394 .91448 -0.29713 Mabsadd L
.35565 .36394 2.37764 .77254 Mabsadd L
.35565 .36394 .56518 .7779 Mabsadd L
.35565 .36394 0 2.5 Mabsadd L closepath F
.35714 .36546 0 2.5 Mabsadd m
.35714 .36546 -0.56518 .7779 Mabsadd L
.35714 .36546 -2.37764 .77254 Mabsadd L
.35714 .36546 -0.91448 -0.29713 Mabsadd L
.35714 .36546 -1.46946 -2.02254 Mabsadd L
.35714 .36546 0 -0.96154 Mabsadd L
.35714 .36546 1.46946 -2.02254 Mabsadd L
.35714 .36546 .91448 -0.29713 Mabsadd L
.35714 .36546 2.37764 .77254 Mabsadd L
.35714 .36546 .56518 .7779 Mabsadd L
.35714 .36546 0 2.5 Mabsadd L closepath F
.35863 .36697 0 2.5 Mabsadd m
.35863 .36697 -0.56518 .7779 Mabsadd L
.35863 .36697 -2.37764 .77254 Mabsadd L
.35863 .36697 -0.91448 -0.29713 Mabsadd L
.35863 .36697 -1.46946 -2.02254 Mabsadd L
.35863 .36697 0 -0.96154 Mabsadd L
.35863 .36697 1.46946 -2.02254 Mabsadd L
.35863 .36697 .91448 -0.29713 Mabsadd L
.35863 .36697 2.37764 .77254 Mabsadd L
.35863 .36697 .56518 .7779 Mabsadd L
.35863 .36697 0 2.5 Mabsadd L closepath F
.36012 .36849 0 2.5 Mabsadd m
.36012 .36849 -0.56518 .7779 Mabsadd L
.36012 .36849 -2.37764 .77254 Mabsadd L
.36012 .36849 -0.91448 -0.29713 Mabsadd L
.36012 .36849 -1.46946 -2.02254 Mabsadd L
.36012 .36849 0 -0.96154 Mabsadd L
.36012 .36849 1.46946 -2.02254 Mabsadd L
.36012 .36849 .91448 -0.29713 Mabsadd L
.36012 .36849 2.37764 .77254 Mabsadd L
.36012 .36849 .56518 .7779 Mabsadd L
.36012 .36849 0 2.5 Mabsadd L closepath F
.36161 .37 0 2.5 Mabsadd m
.36161 .37 -0.56518 .7779 Mabsadd L
.36161 .37 -2.37764 .77254 Mabsadd L
.36161 .37 -0.91448 -0.29713 Mabsadd L
.36161 .37 -1.46946 -2.02254 Mabsadd L
.36161 .37 0 -0.96154 Mabsadd L
.36161 .37 1.46946 -2.02254 Mabsadd L
.36161 .37 .91448 -0.29713 Mabsadd L
.36161 .37 2.37764 .77254 Mabsadd L
.36161 .37 .56518 .7779 Mabsadd L
.36161 .37 0 2.5 Mabsadd L closepath F
.3631 .37152 0 2.5 Mabsadd m
.3631 .37152 -0.56518 .7779 Mabsadd L
.3631 .37152 -2.37764 .77254 Mabsadd L
.3631 .37152 -0.91448 -0.29713 Mabsadd L
.3631 .37152 -1.46946 -2.02254 Mabsadd L
.3631 .37152 0 -0.96154 Mabsadd L
.3631 .37152 1.46946 -2.02254 Mabsadd L
.3631 .37152 .91448 -0.29713 Mabsadd L
.3631 .37152 2.37764 .77254 Mabsadd L
.3631 .37152 .56518 .7779 Mabsadd L
.3631 .37152 0 2.5 Mabsadd L closepath F
.36458 .37303 0 2.5 Mabsadd m
.36458 .37303 -0.56518 .7779 Mabsadd L
.36458 .37303 -2.37764 .77254 Mabsadd L
.36458 .37303 -0.91448 -0.29713 Mabsadd L
.36458 .37303 -1.46946 -2.02254 Mabsadd L
.36458 .37303 0 -0.96154 Mabsadd L
.36458 .37303 1.46946 -2.02254 Mabsadd L
.36458 .37303 .91448 -0.29713 Mabsadd L
.36458 .37303 2.37764 .77254 Mabsadd L
.36458 .37303 .56518 .7779 Mabsadd L
.36458 .37303 0 2.5 Mabsadd L closepath F
.36607 .37455 0 2.5 Mabsadd m
.36607 .37455 -0.56518 .7779 Mabsadd L
.36607 .37455 -2.37764 .77254 Mabsadd L
.36607 .37455 -0.91448 -0.29713 Mabsadd L
.36607 .37455 -1.46946 -2.02254 Mabsadd L
.36607 .37455 0 -0.96154 Mabsadd L
.36607 .37455 1.46946 -2.02254 Mabsadd L
.36607 .37455 .91448 -0.29713 Mabsadd L
.36607 .37455 2.37764 .77254 Mabsadd L
.36607 .37455 .56518 .7779 Mabsadd L
.36607 .37455 0 2.5 Mabsadd L closepath F
.36756 .37607 0 2.5 Mabsadd m
.36756 .37607 -0.56518 .7779 Mabsadd L
.36756 .37607 -2.37764 .77254 Mabsadd L
.36756 .37607 -0.91448 -0.29713 Mabsadd L
.36756 .37607 -1.46946 -2.02254 Mabsadd L
.36756 .37607 0 -0.96154 Mabsadd L
.36756 .37607 1.46946 -2.02254 Mabsadd L
.36756 .37607 .91448 -0.29713 Mabsadd L
.36756 .37607 2.37764 .77254 Mabsadd L
.36756 .37607 .56518 .7779 Mabsadd L
.36756 .37607 0 2.5 Mabsadd L closepath F
.36905 .37758 0 2.5 Mabsadd m
.36905 .37758 -0.56518 .7779 Mabsadd L
.36905 .37758 -2.37764 .77254 Mabsadd L
.36905 .37758 -0.91448 -0.29713 Mabsadd L
.36905 .37758 -1.46946 -2.02254 Mabsadd L
.36905 .37758 0 -0.96154 Mabsadd L
.36905 .37758 1.46946 -2.02254 Mabsadd L
.36905 .37758 .91448 -0.29713 Mabsadd L
.36905 .37758 2.37764 .77254 Mabsadd L
.36905 .37758 .56518 .7779 Mabsadd L
.36905 .37758 0 2.5 Mabsadd L closepath F
.37054 .3791 0 2.5 Mabsadd m
.37054 .3791 -0.56518 .7779 Mabsadd L
.37054 .3791 -2.37764 .77254 Mabsadd L
.37054 .3791 -0.91448 -0.29713 Mabsadd L
.37054 .3791 -1.46946 -2.02254 Mabsadd L
.37054 .3791 0 -0.96154 Mabsadd L
.37054 .3791 1.46946 -2.02254 Mabsadd L
.37054 .3791 .91448 -0.29713 Mabsadd L
.37054 .3791 2.37764 .77254 Mabsadd L
.37054 .3791 .56518 .7779 Mabsadd L
.37054 .3791 0 2.5 Mabsadd L closepath F
.37202 .38061 0 2.5 Mabsadd m
.37202 .38061 -0.56518 .7779 Mabsadd L
.37202 .38061 -2.37764 .77254 Mabsadd L
.37202 .38061 -0.91448 -0.29713 Mabsadd L
.37202 .38061 -1.46946 -2.02254 Mabsadd L
.37202 .38061 0 -0.96154 Mabsadd L
.37202 .38061 1.46946 -2.02254 Mabsadd L
.37202 .38061 .91448 -0.29713 Mabsadd L
.37202 .38061 2.37764 .77254 Mabsadd L
.37202 .38061 .56518 .7779 Mabsadd L
.37202 .38061 0 2.5 Mabsadd L closepath F
.37351 .38213 0 2.5 Mabsadd m
.37351 .38213 -0.56518 .7779 Mabsadd L
.37351 .38213 -2.37764 .77254 Mabsadd L
.37351 .38213 -0.91448 -0.29713 Mabsadd L
.37351 .38213 -1.46946 -2.02254 Mabsadd L
.37351 .38213 0 -0.96154 Mabsadd L
.37351 .38213 1.46946 -2.02254 Mabsadd L
.37351 .38213 .91448 -0.29713 Mabsadd L
.37351 .38213 2.37764 .77254 Mabsadd L
.37351 .38213 .56518 .7779 Mabsadd L
.37351 .38213 0 2.5 Mabsadd L closepath F
.375 .38364 0 2.5 Mabsadd m
.375 .38364 -0.56518 .7779 Mabsadd L
.375 .38364 -2.37764 .77254 Mabsadd L
.375 .38364 -0.91448 -0.29713 Mabsadd L
.375 .38364 -1.46946 -2.02254 Mabsadd L
.375 .38364 0 -0.96154 Mabsadd L
.375 .38364 1.46946 -2.02254 Mabsadd L
.375 .38364 .91448 -0.29713 Mabsadd L
.375 .38364 2.37764 .77254 Mabsadd L
.375 .38364 .56518 .7779 Mabsadd L
.375 .38364 0 2.5 Mabsadd L closepath F
.37649 .38515 0 2.5 Mabsadd m
.37649 .38515 -0.56518 .7779 Mabsadd L
.37649 .38515 -2.37764 .77254 Mabsadd L
.37649 .38515 -0.91448 -0.29713 Mabsadd L
.37649 .38515 -1.46946 -2.02254 Mabsadd L
.37649 .38515 0 -0.96154 Mabsadd L
.37649 .38515 1.46946 -2.02254 Mabsadd L
.37649 .38515 .91448 -0.29713 Mabsadd L
.37649 .38515 2.37764 .77254 Mabsadd L
.37649 .38515 .56518 .7779 Mabsadd L
.37649 .38515 0 2.5 Mabsadd L closepath F
.37798 .38667 0 2.5 Mabsadd m
.37798 .38667 -0.56518 .7779 Mabsadd L
.37798 .38667 -2.37764 .77254 Mabsadd L
.37798 .38667 -0.91448 -0.29713 Mabsadd L
.37798 .38667 -1.46946 -2.02254 Mabsadd L
.37798 .38667 0 -0.96154 Mabsadd L
.37798 .38667 1.46946 -2.02254 Mabsadd L
.37798 .38667 .91448 -0.29713 Mabsadd L
.37798 .38667 2.37764 .77254 Mabsadd L
.37798 .38667 .56518 .7779 Mabsadd L
.37798 .38667 0 2.5 Mabsadd L closepath F
.37946 .38818 0 2.5 Mabsadd m
.37946 .38818 -0.56518 .7779 Mabsadd L
.37946 .38818 -2.37764 .77254 Mabsadd L
.37946 .38818 -0.91448 -0.29713 Mabsadd L
.37946 .38818 -1.46946 -2.02254 Mabsadd L
.37946 .38818 0 -0.96154 Mabsadd L
.37946 .38818 1.46946 -2.02254 Mabsadd L
.37946 .38818 .91448 -0.29713 Mabsadd L
.37946 .38818 2.37764 .77254 Mabsadd L
.37946 .38818 .56518 .7779 Mabsadd L
.37946 .38818 0 2.5 Mabsadd L closepath F
.38095 .3897 0 2.5 Mabsadd m
.38095 .3897 -0.56518 .7779 Mabsadd L
.38095 .3897 -2.37764 .77254 Mabsadd L
.38095 .3897 -0.91448 -0.29713 Mabsadd L
.38095 .3897 -1.46946 -2.02254 Mabsadd L
.38095 .3897 0 -0.96154 Mabsadd L
.38095 .3897 1.46946 -2.02254 Mabsadd L
.38095 .3897 .91448 -0.29713 Mabsadd L
.38095 .3897 2.37764 .77254 Mabsadd L
.38095 .3897 .56518 .7779 Mabsadd L
.38095 .3897 0 2.5 Mabsadd L closepath F
.38244 .39121 0 2.5 Mabsadd m
.38244 .39121 -0.56518 .7779 Mabsadd L
.38244 .39121 -2.37764 .77254 Mabsadd L
.38244 .39121 -0.91448 -0.29713 Mabsadd L
.38244 .39121 -1.46946 -2.02254 Mabsadd L
.38244 .39121 0 -0.96154 Mabsadd L
.38244 .39121 1.46946 -2.02254 Mabsadd L
.38244 .39121 .91448 -0.29713 Mabsadd L
.38244 .39121 2.37764 .77254 Mabsadd L
.38244 .39121 .56518 .7779 Mabsadd L
.38244 .39121 0 2.5 Mabsadd L closepath F
.38393 .39273 0 2.5 Mabsadd m
.38393 .39273 -0.56518 .7779 Mabsadd L
.38393 .39273 -2.37764 .77254 Mabsadd L
.38393 .39273 -0.91448 -0.29713 Mabsadd L
.38393 .39273 -1.46946 -2.02254 Mabsadd L
.38393 .39273 0 -0.96154 Mabsadd L
.38393 .39273 1.46946 -2.02254 Mabsadd L
.38393 .39273 .91448 -0.29713 Mabsadd L
.38393 .39273 2.37764 .77254 Mabsadd L
.38393 .39273 .56518 .7779 Mabsadd L
.38393 .39273 0 2.5 Mabsadd L closepath F
.38542 .39424 0 2.5 Mabsadd m
.38542 .39424 -0.56518 .7779 Mabsadd L
.38542 .39424 -2.37764 .77254 Mabsadd L
.38542 .39424 -0.91448 -0.29713 Mabsadd L
.38542 .39424 -1.46946 -2.02254 Mabsadd L
.38542 .39424 0 -0.96154 Mabsadd L
.38542 .39424 1.46946 -2.02254 Mabsadd L
.38542 .39424 .91448 -0.29713 Mabsadd L
.38542 .39424 2.37764 .77254 Mabsadd L
.38542 .39424 .56518 .7779 Mabsadd L
.38542 .39424 0 2.5 Mabsadd L closepath F
.3869 .39575 0 2.5 Mabsadd m
.3869 .39575 -0.56518 .7779 Mabsadd L
.3869 .39575 -2.37764 .77254 Mabsadd L
.3869 .39575 -0.91448 -0.29713 Mabsadd L
.3869 .39575 -1.46946 -2.02254 Mabsadd L
.3869 .39575 0 -0.96154 Mabsadd L
.3869 .39575 1.46946 -2.02254 Mabsadd L
.3869 .39575 .91448 -0.29713 Mabsadd L
.3869 .39575 2.37764 .77254 Mabsadd L
.3869 .39575 .56518 .7779 Mabsadd L
.3869 .39575 0 2.5 Mabsadd L closepath F
.38839 .39727 0 2.5 Mabsadd m
.38839 .39727 -0.56518 .7779 Mabsadd L
.38839 .39727 -2.37764 .77254 Mabsadd L
.38839 .39727 -0.91448 -0.29713 Mabsadd L
.38839 .39727 -1.46946 -2.02254 Mabsadd L
.38839 .39727 0 -0.96154 Mabsadd L
.38839 .39727 1.46946 -2.02254 Mabsadd L
.38839 .39727 .91448 -0.29713 Mabsadd L
.38839 .39727 2.37764 .77254 Mabsadd L
.38839 .39727 .56518 .7779 Mabsadd L
.38839 .39727 0 2.5 Mabsadd L closepath F
.38988 .39878 0 2.5 Mabsadd m
.38988 .39878 -0.56518 .7779 Mabsadd L
.38988 .39878 -2.37764 .77254 Mabsadd L
.38988 .39878 -0.91448 -0.29713 Mabsadd L
.38988 .39878 -1.46946 -2.02254 Mabsadd L
.38988 .39878 0 -0.96154 Mabsadd L
.38988 .39878 1.46946 -2.02254 Mabsadd L
.38988 .39878 .91448 -0.29713 Mabsadd L
.38988 .39878 2.37764 .77254 Mabsadd L
.38988 .39878 .56518 .7779 Mabsadd L
.38988 .39878 0 2.5 Mabsadd L closepath F
.39137 .40029 0 2.5 Mabsadd m
.39137 .40029 -0.56518 .7779 Mabsadd L
.39137 .40029 -2.37764 .77254 Mabsadd L
.39137 .40029 -0.91448 -0.29713 Mabsadd L
.39137 .40029 -1.46946 -2.02254 Mabsadd L
.39137 .40029 0 -0.96154 Mabsadd L
.39137 .40029 1.46946 -2.02254 Mabsadd L
.39137 .40029 .91448 -0.29713 Mabsadd L
.39137 .40029 2.37764 .77254 Mabsadd L
.39137 .40029 .56518 .7779 Mabsadd L
.39137 .40029 0 2.5 Mabsadd L closepath F
.39286 .40181 0 2.5 Mabsadd m
.39286 .40181 -0.56518 .7779 Mabsadd L
.39286 .40181 -2.37764 .77254 Mabsadd L
.39286 .40181 -0.91448 -0.29713 Mabsadd L
.39286 .40181 -1.46946 -2.02254 Mabsadd L
.39286 .40181 0 -0.96154 Mabsadd L
.39286 .40181 1.46946 -2.02254 Mabsadd L
.39286 .40181 .91448 -0.29713 Mabsadd L
.39286 .40181 2.37764 .77254 Mabsadd L
.39286 .40181 .56518 .7779 Mabsadd L
.39286 .40181 0 2.5 Mabsadd L closepath F
.39435 .40332 0 2.5 Mabsadd m
.39435 .40332 -0.56518 .7779 Mabsadd L
.39435 .40332 -2.37764 .77254 Mabsadd L
.39435 .40332 -0.91448 -0.29713 Mabsadd L
.39435 .40332 -1.46946 -2.02254 Mabsadd L
.39435 .40332 0 -0.96154 Mabsadd L
.39435 .40332 1.46946 -2.02254 Mabsadd L
.39435 .40332 .91448 -0.29713 Mabsadd L
.39435 .40332 2.37764 .77254 Mabsadd L
.39435 .40332 .56518 .7779 Mabsadd L
.39435 .40332 0 2.5 Mabsadd L closepath F
.39583 .40483 0 2.5 Mabsadd m
.39583 .40483 -0.56518 .7779 Mabsadd L
.39583 .40483 -2.37764 .77254 Mabsadd L
.39583 .40483 -0.91448 -0.29713 Mabsadd L
.39583 .40483 -1.46946 -2.02254 Mabsadd L
.39583 .40483 0 -0.96154 Mabsadd L
.39583 .40483 1.46946 -2.02254 Mabsadd L
.39583 .40483 .91448 -0.29713 Mabsadd L
.39583 .40483 2.37764 .77254 Mabsadd L
.39583 .40483 .56518 .7779 Mabsadd L
.39583 .40483 0 2.5 Mabsadd L closepath F
.39732 .40634 0 2.5 Mabsadd m
.39732 .40634 -0.56518 .7779 Mabsadd L
.39732 .40634 -2.37764 .77254 Mabsadd L
.39732 .40634 -0.91448 -0.29713 Mabsadd L
.39732 .40634 -1.46946 -2.02254 Mabsadd L
.39732 .40634 0 -0.96154 Mabsadd L
.39732 .40634 1.46946 -2.02254 Mabsadd L
.39732 .40634 .91448 -0.29713 Mabsadd L
.39732 .40634 2.37764 .77254 Mabsadd L
.39732 .40634 .56518 .7779 Mabsadd L
.39732 .40634 0 2.5 Mabsadd L closepath F
.39881 .40786 0 2.5 Mabsadd m
.39881 .40786 -0.56518 .7779 Mabsadd L
.39881 .40786 -2.37764 .77254 Mabsadd L
.39881 .40786 -0.91448 -0.29713 Mabsadd L
.39881 .40786 -1.46946 -2.02254 Mabsadd L
.39881 .40786 0 -0.96154 Mabsadd L
.39881 .40786 1.46946 -2.02254 Mabsadd L
.39881 .40786 .91448 -0.29713 Mabsadd L
.39881 .40786 2.37764 .77254 Mabsadd L
.39881 .40786 .56518 .7779 Mabsadd L
.39881 .40786 0 2.5 Mabsadd L closepath F
.4003 .40937 0 2.5 Mabsadd m
.4003 .40937 -0.56518 .7779 Mabsadd L
.4003 .40937 -2.37764 .77254 Mabsadd L
.4003 .40937 -0.91448 -0.29713 Mabsadd L
.4003 .40937 -1.46946 -2.02254 Mabsadd L
.4003 .40937 0 -0.96154 Mabsadd L
.4003 .40937 1.46946 -2.02254 Mabsadd L
.4003 .40937 .91448 -0.29713 Mabsadd L
.4003 .40937 2.37764 .77254 Mabsadd L
.4003 .40937 .56518 .7779 Mabsadd L
.4003 .40937 0 2.5 Mabsadd L closepath F
.40179 .41088 0 2.5 Mabsadd m
.40179 .41088 -0.56518 .7779 Mabsadd L
.40179 .41088 -2.37764 .77254 Mabsadd L
.40179 .41088 -0.91448 -0.29713 Mabsadd L
.40179 .41088 -1.46946 -2.02254 Mabsadd L
.40179 .41088 0 -0.96154 Mabsadd L
.40179 .41088 1.46946 -2.02254 Mabsadd L
.40179 .41088 .91448 -0.29713 Mabsadd L
.40179 .41088 2.37764 .77254 Mabsadd L
.40179 .41088 .56518 .7779 Mabsadd L
.40179 .41088 0 2.5 Mabsadd L closepath F
.40327 .41239 0 2.5 Mabsadd m
.40327 .41239 -0.56518 .7779 Mabsadd L
.40327 .41239 -2.37764 .77254 Mabsadd L
.40327 .41239 -0.91448 -0.29713 Mabsadd L
.40327 .41239 -1.46946 -2.02254 Mabsadd L
.40327 .41239 0 -0.96154 Mabsadd L
.40327 .41239 1.46946 -2.02254 Mabsadd L
.40327 .41239 .91448 -0.29713 Mabsadd L
.40327 .41239 2.37764 .77254 Mabsadd L
.40327 .41239 .56518 .7779 Mabsadd L
.40327 .41239 0 2.5 Mabsadd L closepath F
.40476 .4139 0 2.5 Mabsadd m
.40476 .4139 -0.56518 .7779 Mabsadd L
.40476 .4139 -2.37764 .77254 Mabsadd L
.40476 .4139 -0.91448 -0.29713 Mabsadd L
.40476 .4139 -1.46946 -2.02254 Mabsadd L
.40476 .4139 0 -0.96154 Mabsadd L
.40476 .4139 1.46946 -2.02254 Mabsadd L
.40476 .4139 .91448 -0.29713 Mabsadd L
.40476 .4139 2.37764 .77254 Mabsadd L
.40476 .4139 .56518 .7779 Mabsadd L
.40476 .4139 0 2.5 Mabsadd L closepath F
.40625 .41542 0 2.5 Mabsadd m
.40625 .41542 -0.56518 .7779 Mabsadd L
.40625 .41542 -2.37764 .77254 Mabsadd L
.40625 .41542 -0.91448 -0.29713 Mabsadd L
.40625 .41542 -1.46946 -2.02254 Mabsadd L
.40625 .41542 0 -0.96154 Mabsadd L
.40625 .41542 1.46946 -2.02254 Mabsadd L
.40625 .41542 .91448 -0.29713 Mabsadd L
.40625 .41542 2.37764 .77254 Mabsadd L
.40625 .41542 .56518 .7779 Mabsadd L
.40625 .41542 0 2.5 Mabsadd L closepath F
.40774 .41693 0 2.5 Mabsadd m
.40774 .41693 -0.56518 .7779 Mabsadd L
.40774 .41693 -2.37764 .77254 Mabsadd L
.40774 .41693 -0.91448 -0.29713 Mabsadd L
.40774 .41693 -1.46946 -2.02254 Mabsadd L
.40774 .41693 0 -0.96154 Mabsadd L
.40774 .41693 1.46946 -2.02254 Mabsadd L
.40774 .41693 .91448 -0.29713 Mabsadd L
.40774 .41693 2.37764 .77254 Mabsadd L
.40774 .41693 .56518 .7779 Mabsadd L
.40774 .41693 0 2.5 Mabsadd L closepath F
.40923 .41844 0 2.5 Mabsadd m
.40923 .41844 -0.56518 .7779 Mabsadd L
.40923 .41844 -2.37764 .77254 Mabsadd L
.40923 .41844 -0.91448 -0.29713 Mabsadd L
.40923 .41844 -1.46946 -2.02254 Mabsadd L
.40923 .41844 0 -0.96154 Mabsadd L
.40923 .41844 1.46946 -2.02254 Mabsadd L
.40923 .41844 .91448 -0.29713 Mabsadd L
.40923 .41844 2.37764 .77254 Mabsadd L
.40923 .41844 .56518 .7779 Mabsadd L
.40923 .41844 0 2.5 Mabsadd L closepath F
.41071 .41995 0 2.5 Mabsadd m
.41071 .41995 -0.56518 .7779 Mabsadd L
.41071 .41995 -2.37764 .77254 Mabsadd L
.41071 .41995 -0.91448 -0.29713 Mabsadd L
.41071 .41995 -1.46946 -2.02254 Mabsadd L
.41071 .41995 0 -0.96154 Mabsadd L
.41071 .41995 1.46946 -2.02254 Mabsadd L
.41071 .41995 .91448 -0.29713 Mabsadd L
.41071 .41995 2.37764 .77254 Mabsadd L
.41071 .41995 .56518 .7779 Mabsadd L
.41071 .41995 0 2.5 Mabsadd L closepath F
.4122 .42146 0 2.5 Mabsadd m
.4122 .42146 -0.56518 .7779 Mabsadd L
.4122 .42146 -2.37764 .77254 Mabsadd L
.4122 .42146 -0.91448 -0.29713 Mabsadd L
.4122 .42146 -1.46946 -2.02254 Mabsadd L
.4122 .42146 0 -0.96154 Mabsadd L
.4122 .42146 1.46946 -2.02254 Mabsadd L
.4122 .42146 .91448 -0.29713 Mabsadd L
.4122 .42146 2.37764 .77254 Mabsadd L
.4122 .42146 .56518 .7779 Mabsadd L
.4122 .42146 0 2.5 Mabsadd L closepath F
.41369 .42297 0 2.5 Mabsadd m
.41369 .42297 -0.56518 .7779 Mabsadd L
.41369 .42297 -2.37764 .77254 Mabsadd L
.41369 .42297 -0.91448 -0.29713 Mabsadd L
.41369 .42297 -1.46946 -2.02254 Mabsadd L
.41369 .42297 0 -0.96154 Mabsadd L
.41369 .42297 1.46946 -2.02254 Mabsadd L
.41369 .42297 .91448 -0.29713 Mabsadd L
.41369 .42297 2.37764 .77254 Mabsadd L
.41369 .42297 .56518 .7779 Mabsadd L
.41369 .42297 0 2.5 Mabsadd L closepath F
.41518 .42448 0 2.5 Mabsadd m
.41518 .42448 -0.56518 .7779 Mabsadd L
.41518 .42448 -2.37764 .77254 Mabsadd L
.41518 .42448 -0.91448 -0.29713 Mabsadd L
.41518 .42448 -1.46946 -2.02254 Mabsadd L
.41518 .42448 0 -0.96154 Mabsadd L
.41518 .42448 1.46946 -2.02254 Mabsadd L
.41518 .42448 .91448 -0.29713 Mabsadd L
.41518 .42448 2.37764 .77254 Mabsadd L
.41518 .42448 .56518 .7779 Mabsadd L
.41518 .42448 0 2.5 Mabsadd L closepath F
.41667 .42599 0 2.5 Mabsadd m
.41667 .42599 -0.56518 .7779 Mabsadd L
.41667 .42599 -2.37764 .77254 Mabsadd L
.41667 .42599 -0.91448 -0.29713 Mabsadd L
.41667 .42599 -1.46946 -2.02254 Mabsadd L
.41667 .42599 0 -0.96154 Mabsadd L
.41667 .42599 1.46946 -2.02254 Mabsadd L
.41667 .42599 .91448 -0.29713 Mabsadd L
.41667 .42599 2.37764 .77254 Mabsadd L
.41667 .42599 .56518 .7779 Mabsadd L
.41667 .42599 0 2.5 Mabsadd L closepath F
.41815 .42751 0 2.5 Mabsadd m
.41815 .42751 -0.56518 .7779 Mabsadd L
.41815 .42751 -2.37764 .77254 Mabsadd L
.41815 .42751 -0.91448 -0.29713 Mabsadd L
.41815 .42751 -1.46946 -2.02254 Mabsadd L
.41815 .42751 0 -0.96154 Mabsadd L
.41815 .42751 1.46946 -2.02254 Mabsadd L
.41815 .42751 .91448 -0.29713 Mabsadd L
.41815 .42751 2.37764 .77254 Mabsadd L
.41815 .42751 .56518 .7779 Mabsadd L
.41815 .42751 0 2.5 Mabsadd L closepath F
.41964 .42902 0 2.5 Mabsadd m
.41964 .42902 -0.56518 .7779 Mabsadd L
.41964 .42902 -2.37764 .77254 Mabsadd L
.41964 .42902 -0.91448 -0.29713 Mabsadd L
.41964 .42902 -1.46946 -2.02254 Mabsadd L
.41964 .42902 0 -0.96154 Mabsadd L
.41964 .42902 1.46946 -2.02254 Mabsadd L
.41964 .42902 .91448 -0.29713 Mabsadd L
.41964 .42902 2.37764 .77254 Mabsadd L
.41964 .42902 .56518 .7779 Mabsadd L
.41964 .42902 0 2.5 Mabsadd L closepath F
.42113 .43053 0 2.5 Mabsadd m
.42113 .43053 -0.56518 .7779 Mabsadd L
.42113 .43053 -2.37764 .77254 Mabsadd L
.42113 .43053 -0.91448 -0.29713 Mabsadd L
.42113 .43053 -1.46946 -2.02254 Mabsadd L
.42113 .43053 0 -0.96154 Mabsadd L
.42113 .43053 1.46946 -2.02254 Mabsadd L
.42113 .43053 .91448 -0.29713 Mabsadd L
.42113 .43053 2.37764 .77254 Mabsadd L
.42113 .43053 .56518 .7779 Mabsadd L
.42113 .43053 0 2.5 Mabsadd L closepath F
.42262 .43204 0 2.5 Mabsadd m
.42262 .43204 -0.56518 .7779 Mabsadd L
.42262 .43204 -2.37764 .77254 Mabsadd L
.42262 .43204 -0.91448 -0.29713 Mabsadd L
.42262 .43204 -1.46946 -2.02254 Mabsadd L
.42262 .43204 0 -0.96154 Mabsadd L
.42262 .43204 1.46946 -2.02254 Mabsadd L
.42262 .43204 .91448 -0.29713 Mabsadd L
.42262 .43204 2.37764 .77254 Mabsadd L
.42262 .43204 .56518 .7779 Mabsadd L
.42262 .43204 0 2.5 Mabsadd L closepath F
.42411 .43355 0 2.5 Mabsadd m
.42411 .43355 -0.56518 .7779 Mabsadd L
.42411 .43355 -2.37764 .77254 Mabsadd L
.42411 .43355 -0.91448 -0.29713 Mabsadd L
.42411 .43355 -1.46946 -2.02254 Mabsadd L
.42411 .43355 0 -0.96154 Mabsadd L
.42411 .43355 1.46946 -2.02254 Mabsadd L
.42411 .43355 .91448 -0.29713 Mabsadd L
.42411 .43355 2.37764 .77254 Mabsadd L
.42411 .43355 .56518 .7779 Mabsadd L
.42411 .43355 0 2.5 Mabsadd L closepath F
.4256 .43506 0 2.5 Mabsadd m
.4256 .43506 -0.56518 .7779 Mabsadd L
.4256 .43506 -2.37764 .77254 Mabsadd L
.4256 .43506 -0.91448 -0.29713 Mabsadd L
.4256 .43506 -1.46946 -2.02254 Mabsadd L
.4256 .43506 0 -0.96154 Mabsadd L
.4256 .43506 1.46946 -2.02254 Mabsadd L
.4256 .43506 .91448 -0.29713 Mabsadd L
.4256 .43506 2.37764 .77254 Mabsadd L
.4256 .43506 .56518 .7779 Mabsadd L
.4256 .43506 0 2.5 Mabsadd L closepath F
.42708 .43656 0 2.5 Mabsadd m
.42708 .43656 -0.56518 .7779 Mabsadd L
.42708 .43656 -2.37764 .77254 Mabsadd L
.42708 .43656 -0.91448 -0.29713 Mabsadd L
.42708 .43656 -1.46946 -2.02254 Mabsadd L
.42708 .43656 0 -0.96154 Mabsadd L
.42708 .43656 1.46946 -2.02254 Mabsadd L
.42708 .43656 .91448 -0.29713 Mabsadd L
.42708 .43656 2.37764 .77254 Mabsadd L
.42708 .43656 .56518 .7779 Mabsadd L
.42708 .43656 0 2.5 Mabsadd L closepath F
.42857 .43807 0 2.5 Mabsadd m
.42857 .43807 -0.56518 .7779 Mabsadd L
.42857 .43807 -2.37764 .77254 Mabsadd L
.42857 .43807 -0.91448 -0.29713 Mabsadd L
.42857 .43807 -1.46946 -2.02254 Mabsadd L
.42857 .43807 0 -0.96154 Mabsadd L
.42857 .43807 1.46946 -2.02254 Mabsadd L
.42857 .43807 .91448 -0.29713 Mabsadd L
.42857 .43807 2.37764 .77254 Mabsadd L
.42857 .43807 .56518 .7779 Mabsadd L
.42857 .43807 0 2.5 Mabsadd L closepath F
.43006 .43958 0 2.5 Mabsadd m
.43006 .43958 -0.56518 .7779 Mabsadd L
.43006 .43958 -2.37764 .77254 Mabsadd L
.43006 .43958 -0.91448 -0.29713 Mabsadd L
.43006 .43958 -1.46946 -2.02254 Mabsadd L
.43006 .43958 0 -0.96154 Mabsadd L
.43006 .43958 1.46946 -2.02254 Mabsadd L
.43006 .43958 .91448 -0.29713 Mabsadd L
.43006 .43958 2.37764 .77254 Mabsadd L
.43006 .43958 .56518 .7779 Mabsadd L
.43006 .43958 0 2.5 Mabsadd L closepath F
.43155 .44109 0 2.5 Mabsadd m
.43155 .44109 -0.56518 .7779 Mabsadd L
.43155 .44109 -2.37764 .77254 Mabsadd L
.43155 .44109 -0.91448 -0.29713 Mabsadd L
.43155 .44109 -1.46946 -2.02254 Mabsadd L
.43155 .44109 0 -0.96154 Mabsadd L
.43155 .44109 1.46946 -2.02254 Mabsadd L
.43155 .44109 .91448 -0.29713 Mabsadd L
.43155 .44109 2.37764 .77254 Mabsadd L
.43155 .44109 .56518 .7779 Mabsadd L
.43155 .44109 0 2.5 Mabsadd L closepath F
.43304 .4426 0 2.5 Mabsadd m
.43304 .4426 -0.56518 .7779 Mabsadd L
.43304 .4426 -2.37764 .77254 Mabsadd L
.43304 .4426 -0.91448 -0.29713 Mabsadd L
.43304 .4426 -1.46946 -2.02254 Mabsadd L
.43304 .4426 0 -0.96154 Mabsadd L
.43304 .4426 1.46946 -2.02254 Mabsadd L
.43304 .4426 .91448 -0.29713 Mabsadd L
.43304 .4426 2.37764 .77254 Mabsadd L
.43304 .4426 .56518 .7779 Mabsadd L
.43304 .4426 0 2.5 Mabsadd L closepath F
.43452 .44411 0 2.5 Mabsadd m
.43452 .44411 -0.56518 .7779 Mabsadd L
.43452 .44411 -2.37764 .77254 Mabsadd L
.43452 .44411 -0.91448 -0.29713 Mabsadd L
.43452 .44411 -1.46946 -2.02254 Mabsadd L
.43452 .44411 0 -0.96154 Mabsadd L
.43452 .44411 1.46946 -2.02254 Mabsadd L
.43452 .44411 .91448 -0.29713 Mabsadd L
.43452 .44411 2.37764 .77254 Mabsadd L
.43452 .44411 .56518 .7779 Mabsadd L
.43452 .44411 0 2.5 Mabsadd L closepath F
.43601 .44562 0 2.5 Mabsadd m
.43601 .44562 -0.56518 .7779 Mabsadd L
.43601 .44562 -2.37764 .77254 Mabsadd L
.43601 .44562 -0.91448 -0.29713 Mabsadd L
.43601 .44562 -1.46946 -2.02254 Mabsadd L
.43601 .44562 0 -0.96154 Mabsadd L
.43601 .44562 1.46946 -2.02254 Mabsadd L
.43601 .44562 .91448 -0.29713 Mabsadd L
.43601 .44562 2.37764 .77254 Mabsadd L
.43601 .44562 .56518 .7779 Mabsadd L
.43601 .44562 0 2.5 Mabsadd L closepath F
.4375 .44713 0 2.5 Mabsadd m
.4375 .44713 -0.56518 .7779 Mabsadd L
.4375 .44713 -2.37764 .77254 Mabsadd L
.4375 .44713 -0.91448 -0.29713 Mabsadd L
.4375 .44713 -1.46946 -2.02254 Mabsadd L
.4375 .44713 0 -0.96154 Mabsadd L
.4375 .44713 1.46946 -2.02254 Mabsadd L
.4375 .44713 .91448 -0.29713 Mabsadd L
.4375 .44713 2.37764 .77254 Mabsadd L
.4375 .44713 .56518 .7779 Mabsadd L
.4375 .44713 0 2.5 Mabsadd L closepath F
.43899 .44864 0 2.5 Mabsadd m
.43899 .44864 -0.56518 .7779 Mabsadd L
.43899 .44864 -2.37764 .77254 Mabsadd L
.43899 .44864 -0.91448 -0.29713 Mabsadd L
.43899 .44864 -1.46946 -2.02254 Mabsadd L
.43899 .44864 0 -0.96154 Mabsadd L
.43899 .44864 1.46946 -2.02254 Mabsadd L
.43899 .44864 .91448 -0.29713 Mabsadd L
.43899 .44864 2.37764 .77254 Mabsadd L
.43899 .44864 .56518 .7779 Mabsadd L
.43899 .44864 0 2.5 Mabsadd L closepath F
.44048 .45014 0 2.5 Mabsadd m
.44048 .45014 -0.56518 .7779 Mabsadd L
.44048 .45014 -2.37764 .77254 Mabsadd L
.44048 .45014 -0.91448 -0.29713 Mabsadd L
.44048 .45014 -1.46946 -2.02254 Mabsadd L
.44048 .45014 0 -0.96154 Mabsadd L
.44048 .45014 1.46946 -2.02254 Mabsadd L
.44048 .45014 .91448 -0.29713 Mabsadd L
.44048 .45014 2.37764 .77254 Mabsadd L
.44048 .45014 .56518 .7779 Mabsadd L
.44048 .45014 0 2.5 Mabsadd L closepath F
.44196 .45165 0 2.5 Mabsadd m
.44196 .45165 -0.56518 .7779 Mabsadd L
.44196 .45165 -2.37764 .77254 Mabsadd L
.44196 .45165 -0.91448 -0.29713 Mabsadd L
.44196 .45165 -1.46946 -2.02254 Mabsadd L
.44196 .45165 0 -0.96154 Mabsadd L
.44196 .45165 1.46946 -2.02254 Mabsadd L
.44196 .45165 .91448 -0.29713 Mabsadd L
.44196 .45165 2.37764 .77254 Mabsadd L
.44196 .45165 .56518 .7779 Mabsadd L
.44196 .45165 0 2.5 Mabsadd L closepath F
.44345 .45316 0 2.5 Mabsadd m
.44345 .45316 -0.56518 .7779 Mabsadd L
.44345 .45316 -2.37764 .77254 Mabsadd L
.44345 .45316 -0.91448 -0.29713 Mabsadd L
.44345 .45316 -1.46946 -2.02254 Mabsadd L
.44345 .45316 0 -0.96154 Mabsadd L
.44345 .45316 1.46946 -2.02254 Mabsadd L
.44345 .45316 .91448 -0.29713 Mabsadd L
.44345 .45316 2.37764 .77254 Mabsadd L
.44345 .45316 .56518 .7779 Mabsadd L
.44345 .45316 0 2.5 Mabsadd L closepath F
.44494 .45467 0 2.5 Mabsadd m
.44494 .45467 -0.56518 .7779 Mabsadd L
.44494 .45467 -2.37764 .77254 Mabsadd L
.44494 .45467 -0.91448 -0.29713 Mabsadd L
.44494 .45467 -1.46946 -2.02254 Mabsadd L
.44494 .45467 0 -0.96154 Mabsadd L
.44494 .45467 1.46946 -2.02254 Mabsadd L
.44494 .45467 .91448 -0.29713 Mabsadd L
.44494 .45467 2.37764 .77254 Mabsadd L
.44494 .45467 .56518 .7779 Mabsadd L
.44494 .45467 0 2.5 Mabsadd L closepath F
.44643 .45617 0 2.5 Mabsadd m
.44643 .45617 -0.56518 .7779 Mabsadd L
.44643 .45617 -2.37764 .77254 Mabsadd L
.44643 .45617 -0.91448 -0.29713 Mabsadd L
.44643 .45617 -1.46946 -2.02254 Mabsadd L
.44643 .45617 0 -0.96154 Mabsadd L
.44643 .45617 1.46946 -2.02254 Mabsadd L
.44643 .45617 .91448 -0.29713 Mabsadd L
.44643 .45617 2.37764 .77254 Mabsadd L
.44643 .45617 .56518 .7779 Mabsadd L
.44643 .45617 0 2.5 Mabsadd L closepath F
.44792 .45768 0 2.5 Mabsadd m
.44792 .45768 -0.56518 .7779 Mabsadd L
.44792 .45768 -2.37764 .77254 Mabsadd L
.44792 .45768 -0.91448 -0.29713 Mabsadd L
.44792 .45768 -1.46946 -2.02254 Mabsadd L
.44792 .45768 0 -0.96154 Mabsadd L
.44792 .45768 1.46946 -2.02254 Mabsadd L
.44792 .45768 .91448 -0.29713 Mabsadd L
.44792 .45768 2.37764 .77254 Mabsadd L
.44792 .45768 .56518 .7779 Mabsadd L
.44792 .45768 0 2.5 Mabsadd L closepath F
.4494 .45919 0 2.5 Mabsadd m
.4494 .45919 -0.56518 .7779 Mabsadd L
.4494 .45919 -2.37764 .77254 Mabsadd L
.4494 .45919 -0.91448 -0.29713 Mabsadd L
.4494 .45919 -1.46946 -2.02254 Mabsadd L
.4494 .45919 0 -0.96154 Mabsadd L
.4494 .45919 1.46946 -2.02254 Mabsadd L
.4494 .45919 .91448 -0.29713 Mabsadd L
.4494 .45919 2.37764 .77254 Mabsadd L
.4494 .45919 .56518 .7779 Mabsadd L
.4494 .45919 0 2.5 Mabsadd L closepath F
.45089 .46069 0 2.5 Mabsadd m
.45089 .46069 -0.56518 .7779 Mabsadd L
.45089 .46069 -2.37764 .77254 Mabsadd L
.45089 .46069 -0.91448 -0.29713 Mabsadd L
.45089 .46069 -1.46946 -2.02254 Mabsadd L
.45089 .46069 0 -0.96154 Mabsadd L
.45089 .46069 1.46946 -2.02254 Mabsadd L
.45089 .46069 .91448 -0.29713 Mabsadd L
.45089 .46069 2.37764 .77254 Mabsadd L
.45089 .46069 .56518 .7779 Mabsadd L
.45089 .46069 0 2.5 Mabsadd L closepath F
.45238 .4622 0 2.5 Mabsadd m
.45238 .4622 -0.56518 .7779 Mabsadd L
.45238 .4622 -2.37764 .77254 Mabsadd L
.45238 .4622 -0.91448 -0.29713 Mabsadd L
.45238 .4622 -1.46946 -2.02254 Mabsadd L
.45238 .4622 0 -0.96154 Mabsadd L
.45238 .4622 1.46946 -2.02254 Mabsadd L
.45238 .4622 .91448 -0.29713 Mabsadd L
.45238 .4622 2.37764 .77254 Mabsadd L
.45238 .4622 .56518 .7779 Mabsadd L
.45238 .4622 0 2.5 Mabsadd L closepath F
.45387 .46371 0 2.5 Mabsadd m
.45387 .46371 -0.56518 .7779 Mabsadd L
.45387 .46371 -2.37764 .77254 Mabsadd L
.45387 .46371 -0.91448 -0.29713 Mabsadd L
.45387 .46371 -1.46946 -2.02254 Mabsadd L
.45387 .46371 0 -0.96154 Mabsadd L
.45387 .46371 1.46946 -2.02254 Mabsadd L
.45387 .46371 .91448 -0.29713 Mabsadd L
.45387 .46371 2.37764 .77254 Mabsadd L
.45387 .46371 .56518 .7779 Mabsadd L
.45387 .46371 0 2.5 Mabsadd L closepath F
.45536 .46521 0 2.5 Mabsadd m
.45536 .46521 -0.56518 .7779 Mabsadd L
.45536 .46521 -2.37764 .77254 Mabsadd L
.45536 .46521 -0.91448 -0.29713 Mabsadd L
.45536 .46521 -1.46946 -2.02254 Mabsadd L
.45536 .46521 0 -0.96154 Mabsadd L
.45536 .46521 1.46946 -2.02254 Mabsadd L
.45536 .46521 .91448 -0.29713 Mabsadd L
.45536 .46521 2.37764 .77254 Mabsadd L
.45536 .46521 .56518 .7779 Mabsadd L
.45536 .46521 0 2.5 Mabsadd L closepath F
.45685 .46672 0 2.5 Mabsadd m
.45685 .46672 -0.56518 .7779 Mabsadd L
.45685 .46672 -2.37764 .77254 Mabsadd L
.45685 .46672 -0.91448 -0.29713 Mabsadd L
.45685 .46672 -1.46946 -2.02254 Mabsadd L
.45685 .46672 0 -0.96154 Mabsadd L
.45685 .46672 1.46946 -2.02254 Mabsadd L
.45685 .46672 .91448 -0.29713 Mabsadd L
.45685 .46672 2.37764 .77254 Mabsadd L
.45685 .46672 .56518 .7779 Mabsadd L
.45685 .46672 0 2.5 Mabsadd L closepath F
.45833 .46823 0 2.5 Mabsadd m
.45833 .46823 -0.56518 .7779 Mabsadd L
.45833 .46823 -2.37764 .77254 Mabsadd L
.45833 .46823 -0.91448 -0.29713 Mabsadd L
.45833 .46823 -1.46946 -2.02254 Mabsadd L
.45833 .46823 0 -0.96154 Mabsadd L
.45833 .46823 1.46946 -2.02254 Mabsadd L
.45833 .46823 .91448 -0.29713 Mabsadd L
.45833 .46823 2.37764 .77254 Mabsadd L
.45833 .46823 .56518 .7779 Mabsadd L
.45833 .46823 0 2.5 Mabsadd L closepath F
.45982 .46973 0 2.5 Mabsadd m
.45982 .46973 -0.56518 .7779 Mabsadd L
.45982 .46973 -2.37764 .77254 Mabsadd L
.45982 .46973 -0.91448 -0.29713 Mabsadd L
.45982 .46973 -1.46946 -2.02254 Mabsadd L
.45982 .46973 0 -0.96154 Mabsadd L
.45982 .46973 1.46946 -2.02254 Mabsadd L
.45982 .46973 .91448 -0.29713 Mabsadd L
.45982 .46973 2.37764 .77254 Mabsadd L
.45982 .46973 .56518 .7779 Mabsadd L
.45982 .46973 0 2.5 Mabsadd L closepath F
.46131 .47124 0 2.5 Mabsadd m
.46131 .47124 -0.56518 .7779 Mabsadd L
.46131 .47124 -2.37764 .77254 Mabsadd L
.46131 .47124 -0.91448 -0.29713 Mabsadd L
.46131 .47124 -1.46946 -2.02254 Mabsadd L
.46131 .47124 0 -0.96154 Mabsadd L
.46131 .47124 1.46946 -2.02254 Mabsadd L
.46131 .47124 .91448 -0.29713 Mabsadd L
.46131 .47124 2.37764 .77254 Mabsadd L
.46131 .47124 .56518 .7779 Mabsadd L
.46131 .47124 0 2.5 Mabsadd L closepath F
.4628 .47274 0 2.5 Mabsadd m
.4628 .47274 -0.56518 .7779 Mabsadd L
.4628 .47274 -2.37764 .77254 Mabsadd L
.4628 .47274 -0.91448 -0.29713 Mabsadd L
.4628 .47274 -1.46946 -2.02254 Mabsadd L
.4628 .47274 0 -0.96154 Mabsadd L
.4628 .47274 1.46946 -2.02254 Mabsadd L
.4628 .47274 .91448 -0.29713 Mabsadd L
.4628 .47274 2.37764 .77254 Mabsadd L
.4628 .47274 .56518 .7779 Mabsadd L
.4628 .47274 0 2.5 Mabsadd L closepath F
.46429 .47425 0 2.5 Mabsadd m
.46429 .47425 -0.56518 .7779 Mabsadd L
.46429 .47425 -2.37764 .77254 Mabsadd L
.46429 .47425 -0.91448 -0.29713 Mabsadd L
.46429 .47425 -1.46946 -2.02254 Mabsadd L
.46429 .47425 0 -0.96154 Mabsadd L
.46429 .47425 1.46946 -2.02254 Mabsadd L
.46429 .47425 .91448 -0.29713 Mabsadd L
.46429 .47425 2.37764 .77254 Mabsadd L
.46429 .47425 .56518 .7779 Mabsadd L
.46429 .47425 0 2.5 Mabsadd L closepath F
.46577 .47575 0 2.5 Mabsadd m
.46577 .47575 -0.56518 .7779 Mabsadd L
.46577 .47575 -2.37764 .77254 Mabsadd L
.46577 .47575 -0.91448 -0.29713 Mabsadd L
.46577 .47575 -1.46946 -2.02254 Mabsadd L
.46577 .47575 0 -0.96154 Mabsadd L
.46577 .47575 1.46946 -2.02254 Mabsadd L
.46577 .47575 .91448 -0.29713 Mabsadd L
.46577 .47575 2.37764 .77254 Mabsadd L
.46577 .47575 .56518 .7779 Mabsadd L
.46577 .47575 0 2.5 Mabsadd L closepath F
.46726 .47726 0 2.5 Mabsadd m
.46726 .47726 -0.56518 .7779 Mabsadd L
.46726 .47726 -2.37764 .77254 Mabsadd L
.46726 .47726 -0.91448 -0.29713 Mabsadd L
.46726 .47726 -1.46946 -2.02254 Mabsadd L
.46726 .47726 0 -0.96154 Mabsadd L
.46726 .47726 1.46946 -2.02254 Mabsadd L
.46726 .47726 .91448 -0.29713 Mabsadd L
.46726 .47726 2.37764 .77254 Mabsadd L
.46726 .47726 .56518 .7779 Mabsadd L
.46726 .47726 0 2.5 Mabsadd L closepath F
.46875 .47876 0 2.5 Mabsadd m
.46875 .47876 -0.56518 .7779 Mabsadd L
.46875 .47876 -2.37764 .77254 Mabsadd L
.46875 .47876 -0.91448 -0.29713 Mabsadd L
.46875 .47876 -1.46946 -2.02254 Mabsadd L
.46875 .47876 0 -0.96154 Mabsadd L
.46875 .47876 1.46946 -2.02254 Mabsadd L
.46875 .47876 .91448 -0.29713 Mabsadd L
.46875 .47876 2.37764 .77254 Mabsadd L
.46875 .47876 .56518 .7779 Mabsadd L
.46875 .47876 0 2.5 Mabsadd L closepath F
.47024 .48027 0 2.5 Mabsadd m
.47024 .48027 -0.56518 .7779 Mabsadd L
.47024 .48027 -2.37764 .77254 Mabsadd L
.47024 .48027 -0.91448 -0.29713 Mabsadd L
.47024 .48027 -1.46946 -2.02254 Mabsadd L
.47024 .48027 0 -0.96154 Mabsadd L
.47024 .48027 1.46946 -2.02254 Mabsadd L
.47024 .48027 .91448 -0.29713 Mabsadd L
.47024 .48027 2.37764 .77254 Mabsadd L
.47024 .48027 .56518 .7779 Mabsadd L
.47024 .48027 0 2.5 Mabsadd L closepath F
.47173 .48177 0 2.5 Mabsadd m
.47173 .48177 -0.56518 .7779 Mabsadd L
.47173 .48177 -2.37764 .77254 Mabsadd L
.47173 .48177 -0.91448 -0.29713 Mabsadd L
.47173 .48177 -1.46946 -2.02254 Mabsadd L
.47173 .48177 0 -0.96154 Mabsadd L
.47173 .48177 1.46946 -2.02254 Mabsadd L
.47173 .48177 .91448 -0.29713 Mabsadd L
.47173 .48177 2.37764 .77254 Mabsadd L
.47173 .48177 .56518 .7779 Mabsadd L
.47173 .48177 0 2.5 Mabsadd L closepath F
.47321 .48327 0 2.5 Mabsadd m
.47321 .48327 -0.56518 .7779 Mabsadd L
.47321 .48327 -2.37764 .77254 Mabsadd L
.47321 .48327 -0.91448 -0.29713 Mabsadd L
.47321 .48327 -1.46946 -2.02254 Mabsadd L
.47321 .48327 0 -0.96154 Mabsadd L
.47321 .48327 1.46946 -2.02254 Mabsadd L
.47321 .48327 .91448 -0.29713 Mabsadd L
.47321 .48327 2.37764 .77254 Mabsadd L
.47321 .48327 .56518 .7779 Mabsadd L
.47321 .48327 0 2.5 Mabsadd L closepath F
.4747 .48478 0 2.5 Mabsadd m
.4747 .48478 -0.56518 .7779 Mabsadd L
.4747 .48478 -2.37764 .77254 Mabsadd L
.4747 .48478 -0.91448 -0.29713 Mabsadd L
.4747 .48478 -1.46946 -2.02254 Mabsadd L
.4747 .48478 0 -0.96154 Mabsadd L
.4747 .48478 1.46946 -2.02254 Mabsadd L
.4747 .48478 .91448 -0.29713 Mabsadd L
.4747 .48478 2.37764 .77254 Mabsadd L
.4747 .48478 .56518 .7779 Mabsadd L
.4747 .48478 0 2.5 Mabsadd L closepath F
.47619 .48628 0 2.5 Mabsadd m
.47619 .48628 -0.56518 .7779 Mabsadd L
.47619 .48628 -2.37764 .77254 Mabsadd L
.47619 .48628 -0.91448 -0.29713 Mabsadd L
.47619 .48628 -1.46946 -2.02254 Mabsadd L
.47619 .48628 0 -0.96154 Mabsadd L
.47619 .48628 1.46946 -2.02254 Mabsadd L
.47619 .48628 .91448 -0.29713 Mabsadd L
.47619 .48628 2.37764 .77254 Mabsadd L
.47619 .48628 .56518 .7779 Mabsadd L
.47619 .48628 0 2.5 Mabsadd L closepath F
.47768 .48778 0 2.5 Mabsadd m
.47768 .48778 -0.56518 .7779 Mabsadd L
.47768 .48778 -2.37764 .77254 Mabsadd L
.47768 .48778 -0.91448 -0.29713 Mabsadd L
.47768 .48778 -1.46946 -2.02254 Mabsadd L
.47768 .48778 0 -0.96154 Mabsadd L
.47768 .48778 1.46946 -2.02254 Mabsadd L
.47768 .48778 .91448 -0.29713 Mabsadd L
.47768 .48778 2.37764 .77254 Mabsadd L
.47768 .48778 .56518 .7779 Mabsadd L
.47768 .48778 0 2.5 Mabsadd L closepath F
.47917 .48929 0 2.5 Mabsadd m
.47917 .48929 -0.56518 .7779 Mabsadd L
.47917 .48929 -2.37764 .77254 Mabsadd L
.47917 .48929 -0.91448 -0.29713 Mabsadd L
.47917 .48929 -1.46946 -2.02254 Mabsadd L
.47917 .48929 0 -0.96154 Mabsadd L
.47917 .48929 1.46946 -2.02254 Mabsadd L
.47917 .48929 .91448 -0.29713 Mabsadd L
.47917 .48929 2.37764 .77254 Mabsadd L
.47917 .48929 .56518 .7779 Mabsadd L
.47917 .48929 0 2.5 Mabsadd L closepath F
.48065 .49079 0 2.5 Mabsadd m
.48065 .49079 -0.56518 .7779 Mabsadd L
.48065 .49079 -2.37764 .77254 Mabsadd L
.48065 .49079 -0.91448 -0.29713 Mabsadd L
.48065 .49079 -1.46946 -2.02254 Mabsadd L
.48065 .49079 0 -0.96154 Mabsadd L
.48065 .49079 1.46946 -2.02254 Mabsadd L
.48065 .49079 .91448 -0.29713 Mabsadd L
.48065 .49079 2.37764 .77254 Mabsadd L
.48065 .49079 .56518 .7779 Mabsadd L
.48065 .49079 0 2.5 Mabsadd L closepath F
.48214 .49229 0 2.5 Mabsadd m
.48214 .49229 -0.56518 .7779 Mabsadd L
.48214 .49229 -2.37764 .77254 Mabsadd L
.48214 .49229 -0.91448 -0.29713 Mabsadd L
.48214 .49229 -1.46946 -2.02254 Mabsadd L
.48214 .49229 0 -0.96154 Mabsadd L
.48214 .49229 1.46946 -2.02254 Mabsadd L
.48214 .49229 .91448 -0.29713 Mabsadd L
.48214 .49229 2.37764 .77254 Mabsadd L
.48214 .49229 .56518 .7779 Mabsadd L
.48214 .49229 0 2.5 Mabsadd L closepath F
.48363 .49379 0 2.5 Mabsadd m
.48363 .49379 -0.56518 .7779 Mabsadd L
.48363 .49379 -2.37764 .77254 Mabsadd L
.48363 .49379 -0.91448 -0.29713 Mabsadd L
.48363 .49379 -1.46946 -2.02254 Mabsadd L
.48363 .49379 0 -0.96154 Mabsadd L
.48363 .49379 1.46946 -2.02254 Mabsadd L
.48363 .49379 .91448 -0.29713 Mabsadd L
.48363 .49379 2.37764 .77254 Mabsadd L
.48363 .49379 .56518 .7779 Mabsadd L
.48363 .49379 0 2.5 Mabsadd L closepath F
.48512 .4953 0 2.5 Mabsadd m
.48512 .4953 -0.56518 .7779 Mabsadd L
.48512 .4953 -2.37764 .77254 Mabsadd L
.48512 .4953 -0.91448 -0.29713 Mabsadd L
.48512 .4953 -1.46946 -2.02254 Mabsadd L
.48512 .4953 0 -0.96154 Mabsadd L
.48512 .4953 1.46946 -2.02254 Mabsadd L
.48512 .4953 .91448 -0.29713 Mabsadd L
.48512 .4953 2.37764 .77254 Mabsadd L
.48512 .4953 .56518 .7779 Mabsadd L
.48512 .4953 0 2.5 Mabsadd L closepath F
.48661 .4968 0 2.5 Mabsadd m
.48661 .4968 -0.56518 .7779 Mabsadd L
.48661 .4968 -2.37764 .77254 Mabsadd L
.48661 .4968 -0.91448 -0.29713 Mabsadd L
.48661 .4968 -1.46946 -2.02254 Mabsadd L
.48661 .4968 0 -0.96154 Mabsadd L
.48661 .4968 1.46946 -2.02254 Mabsadd L
.48661 .4968 .91448 -0.29713 Mabsadd L
.48661 .4968 2.37764 .77254 Mabsadd L
.48661 .4968 .56518 .7779 Mabsadd L
.48661 .4968 0 2.5 Mabsadd L closepath F
.4881 .4983 0 2.5 Mabsadd m
.4881 .4983 -0.56518 .7779 Mabsadd L
.4881 .4983 -2.37764 .77254 Mabsadd L
.4881 .4983 -0.91448 -0.29713 Mabsadd L
.4881 .4983 -1.46946 -2.02254 Mabsadd L
.4881 .4983 0 -0.96154 Mabsadd L
.4881 .4983 1.46946 -2.02254 Mabsadd L
.4881 .4983 .91448 -0.29713 Mabsadd L
.4881 .4983 2.37764 .77254 Mabsadd L
.4881 .4983 .56518 .7779 Mabsadd L
.4881 .4983 0 2.5 Mabsadd L closepath F
.48958 .4998 0 2.5 Mabsadd m
.48958 .4998 -0.56518 .7779 Mabsadd L
.48958 .4998 -2.37764 .77254 Mabsadd L
.48958 .4998 -0.91448 -0.29713 Mabsadd L
.48958 .4998 -1.46946 -2.02254 Mabsadd L
.48958 .4998 0 -0.96154 Mabsadd L
.48958 .4998 1.46946 -2.02254 Mabsadd L
.48958 .4998 .91448 -0.29713 Mabsadd L
.48958 .4998 2.37764 .77254 Mabsadd L
.48958 .4998 .56518 .7779 Mabsadd L
.48958 .4998 0 2.5 Mabsadd L closepath F
.49107 .5013 0 2.5 Mabsadd m
.49107 .5013 -0.56518 .7779 Mabsadd L
.49107 .5013 -2.37764 .77254 Mabsadd L
.49107 .5013 -0.91448 -0.29713 Mabsadd L
.49107 .5013 -1.46946 -2.02254 Mabsadd L
.49107 .5013 0 -0.96154 Mabsadd L
.49107 .5013 1.46946 -2.02254 Mabsadd L
.49107 .5013 .91448 -0.29713 Mabsadd L
.49107 .5013 2.37764 .77254 Mabsadd L
.49107 .5013 .56518 .7779 Mabsadd L
.49107 .5013 0 2.5 Mabsadd L closepath F
.49256 .50281 0 2.5 Mabsadd m
.49256 .50281 -0.56518 .7779 Mabsadd L
.49256 .50281 -2.37764 .77254 Mabsadd L
.49256 .50281 -0.91448 -0.29713 Mabsadd L
.49256 .50281 -1.46946 -2.02254 Mabsadd L
.49256 .50281 0 -0.96154 Mabsadd L
.49256 .50281 1.46946 -2.02254 Mabsadd L
.49256 .50281 .91448 -0.29713 Mabsadd L
.49256 .50281 2.37764 .77254 Mabsadd L
.49256 .50281 .56518 .7779 Mabsadd L
.49256 .50281 0 2.5 Mabsadd L closepath F
.49405 .50431 0 2.5 Mabsadd m
.49405 .50431 -0.56518 .7779 Mabsadd L
.49405 .50431 -2.37764 .77254 Mabsadd L
.49405 .50431 -0.91448 -0.29713 Mabsadd L
.49405 .50431 -1.46946 -2.02254 Mabsadd L
.49405 .50431 0 -0.96154 Mabsadd L
.49405 .50431 1.46946 -2.02254 Mabsadd L
.49405 .50431 .91448 -0.29713 Mabsadd L
.49405 .50431 2.37764 .77254 Mabsadd L
.49405 .50431 .56518 .7779 Mabsadd L
.49405 .50431 0 2.5 Mabsadd L closepath F
.49554 .50581 0 2.5 Mabsadd m
.49554 .50581 -0.56518 .7779 Mabsadd L
.49554 .50581 -2.37764 .77254 Mabsadd L
.49554 .50581 -0.91448 -0.29713 Mabsadd L
.49554 .50581 -1.46946 -2.02254 Mabsadd L
.49554 .50581 0 -0.96154 Mabsadd L
.49554 .50581 1.46946 -2.02254 Mabsadd L
.49554 .50581 .91448 -0.29713 Mabsadd L
.49554 .50581 2.37764 .77254 Mabsadd L
.49554 .50581 .56518 .7779 Mabsadd L
.49554 .50581 0 2.5 Mabsadd L closepath F
.49702 .50731 0 2.5 Mabsadd m
.49702 .50731 -0.56518 .7779 Mabsadd L
.49702 .50731 -2.37764 .77254 Mabsadd L
.49702 .50731 -0.91448 -0.29713 Mabsadd L
.49702 .50731 -1.46946 -2.02254 Mabsadd L
.49702 .50731 0 -0.96154 Mabsadd L
.49702 .50731 1.46946 -2.02254 Mabsadd L
.49702 .50731 .91448 -0.29713 Mabsadd L
.49702 .50731 2.37764 .77254 Mabsadd L
.49702 .50731 .56518 .7779 Mabsadd L
.49702 .50731 0 2.5 Mabsadd L closepath F
.49851 .50881 0 2.5 Mabsadd m
.49851 .50881 -0.56518 .7779 Mabsadd L
.49851 .50881 -2.37764 .77254 Mabsadd L
.49851 .50881 -0.91448 -0.29713 Mabsadd L
.49851 .50881 -1.46946 -2.02254 Mabsadd L
.49851 .50881 0 -0.96154 Mabsadd L
.49851 .50881 1.46946 -2.02254 Mabsadd L
.49851 .50881 .91448 -0.29713 Mabsadd L
.49851 .50881 2.37764 .77254 Mabsadd L
.49851 .50881 .56518 .7779 Mabsadd L
.49851 .50881 0 2.5 Mabsadd L closepath F
.5 .51031 0 2.5 Mabsadd m
.5 .51031 -0.56518 .7779 Mabsadd L
.5 .51031 -2.37764 .77254 Mabsadd L
.5 .51031 -0.91448 -0.29713 Mabsadd L
.5 .51031 -1.46946 -2.02254 Mabsadd L
.5 .51031 0 -0.96154 Mabsadd L
.5 .51031 1.46946 -2.02254 Mabsadd L
.5 .51031 .91448 -0.29713 Mabsadd L
.5 .51031 2.37764 .77254 Mabsadd L
.5 .51031 .56518 .7779 Mabsadd L
.5 .51031 0 2.5 Mabsadd L closepath F
.50149 .51181 0 2.5 Mabsadd m
.50149 .51181 -0.56518 .7779 Mabsadd L
.50149 .51181 -2.37764 .77254 Mabsadd L
.50149 .51181 -0.91448 -0.29713 Mabsadd L
.50149 .51181 -1.46946 -2.02254 Mabsadd L
.50149 .51181 0 -0.96154 Mabsadd L
.50149 .51181 1.46946 -2.02254 Mabsadd L
.50149 .51181 .91448 -0.29713 Mabsadd L
.50149 .51181 2.37764 .77254 Mabsadd L
.50149 .51181 .56518 .7779 Mabsadd L
.50149 .51181 0 2.5 Mabsadd L closepath F
.50298 .51331 0 2.5 Mabsadd m
.50298 .51331 -0.56518 .7779 Mabsadd L
.50298 .51331 -2.37764 .77254 Mabsadd L
.50298 .51331 -0.91448 -0.29713 Mabsadd L
.50298 .51331 -1.46946 -2.02254 Mabsadd L
.50298 .51331 0 -0.96154 Mabsadd L
.50298 .51331 1.46946 -2.02254 Mabsadd L
.50298 .51331 .91448 -0.29713 Mabsadd L
.50298 .51331 2.37764 .77254 Mabsadd L
.50298 .51331 .56518 .7779 Mabsadd L
.50298 .51331 0 2.5 Mabsadd L closepath F
.50446 .51481 0 2.5 Mabsadd m
.50446 .51481 -0.56518 .7779 Mabsadd L
.50446 .51481 -2.37764 .77254 Mabsadd L
.50446 .51481 -0.91448 -0.29713 Mabsadd L
.50446 .51481 -1.46946 -2.02254 Mabsadd L
.50446 .51481 0 -0.96154 Mabsadd L
.50446 .51481 1.46946 -2.02254 Mabsadd L
.50446 .51481 .91448 -0.29713 Mabsadd L
.50446 .51481 2.37764 .77254 Mabsadd L
.50446 .51481 .56518 .7779 Mabsadd L
.50446 .51481 0 2.5 Mabsadd L closepath F
.50595 .51631 0 2.5 Mabsadd m
.50595 .51631 -0.56518 .7779 Mabsadd L
.50595 .51631 -2.37764 .77254 Mabsadd L
.50595 .51631 -0.91448 -0.29713 Mabsadd L
.50595 .51631 -1.46946 -2.02254 Mabsadd L
.50595 .51631 0 -0.96154 Mabsadd L
.50595 .51631 1.46946 -2.02254 Mabsadd L
.50595 .51631 .91448 -0.29713 Mabsadd L
.50595 .51631 2.37764 .77254 Mabsadd L
.50595 .51631 .56518 .7779 Mabsadd L
.50595 .51631 0 2.5 Mabsadd L closepath F
.50744 .51781 0 2.5 Mabsadd m
.50744 .51781 -0.56518 .7779 Mabsadd L
.50744 .51781 -2.37764 .77254 Mabsadd L
.50744 .51781 -0.91448 -0.29713 Mabsadd L
.50744 .51781 -1.46946 -2.02254 Mabsadd L
.50744 .51781 0 -0.96154 Mabsadd L
.50744 .51781 1.46946 -2.02254 Mabsadd L
.50744 .51781 .91448 -0.29713 Mabsadd L
.50744 .51781 2.37764 .77254 Mabsadd L
.50744 .51781 .56518 .7779 Mabsadd L
.50744 .51781 0 2.5 Mabsadd L closepath F
.50893 .5193 0 2.5 Mabsadd m
.50893 .5193 -0.56518 .7779 Mabsadd L
.50893 .5193 -2.37764 .77254 Mabsadd L
.50893 .5193 -0.91448 -0.29713 Mabsadd L
.50893 .5193 -1.46946 -2.02254 Mabsadd L
.50893 .5193 0 -0.96154 Mabsadd L
.50893 .5193 1.46946 -2.02254 Mabsadd L
.50893 .5193 .91448 -0.29713 Mabsadd L
.50893 .5193 2.37764 .77254 Mabsadd L
.50893 .5193 .56518 .7779 Mabsadd L
.50893 .5193 0 2.5 Mabsadd L closepath F
.51042 .5208 0 2.5 Mabsadd m
.51042 .5208 -0.56518 .7779 Mabsadd L
.51042 .5208 -2.37764 .77254 Mabsadd L
.51042 .5208 -0.91448 -0.29713 Mabsadd L
.51042 .5208 -1.46946 -2.02254 Mabsadd L
.51042 .5208 0 -0.96154 Mabsadd L
.51042 .5208 1.46946 -2.02254 Mabsadd L
.51042 .5208 .91448 -0.29713 Mabsadd L
.51042 .5208 2.37764 .77254 Mabsadd L
.51042 .5208 .56518 .7779 Mabsadd L
.51042 .5208 0 2.5 Mabsadd L closepath F
.5119 .5223 0 2.5 Mabsadd m
.5119 .5223 -0.56518 .7779 Mabsadd L
.5119 .5223 -2.37764 .77254 Mabsadd L
.5119 .5223 -0.91448 -0.29713 Mabsadd L
.5119 .5223 -1.46946 -2.02254 Mabsadd L
.5119 .5223 0 -0.96154 Mabsadd L
.5119 .5223 1.46946 -2.02254 Mabsadd L
.5119 .5223 .91448 -0.29713 Mabsadd L
.5119 .5223 2.37764 .77254 Mabsadd L
.5119 .5223 .56518 .7779 Mabsadd L
.5119 .5223 0 2.5 Mabsadd L closepath F
.51339 .5238 0 2.5 Mabsadd m
.51339 .5238 -0.56518 .7779 Mabsadd L
.51339 .5238 -2.37764 .77254 Mabsadd L
.51339 .5238 -0.91448 -0.29713 Mabsadd L
.51339 .5238 -1.46946 -2.02254 Mabsadd L
.51339 .5238 0 -0.96154 Mabsadd L
.51339 .5238 1.46946 -2.02254 Mabsadd L
.51339 .5238 .91448 -0.29713 Mabsadd L
.51339 .5238 2.37764 .77254 Mabsadd L
.51339 .5238 .56518 .7779 Mabsadd L
.51339 .5238 0 2.5 Mabsadd L closepath F
.51488 .5253 0 2.5 Mabsadd m
.51488 .5253 -0.56518 .7779 Mabsadd L
.51488 .5253 -2.37764 .77254 Mabsadd L
.51488 .5253 -0.91448 -0.29713 Mabsadd L
.51488 .5253 -1.46946 -2.02254 Mabsadd L
.51488 .5253 0 -0.96154 Mabsadd L
.51488 .5253 1.46946 -2.02254 Mabsadd L
.51488 .5253 .91448 -0.29713 Mabsadd L
.51488 .5253 2.37764 .77254 Mabsadd L
.51488 .5253 .56518 .7779 Mabsadd L
.51488 .5253 0 2.5 Mabsadd L closepath F
.51637 .5268 0 2.5 Mabsadd m
.51637 .5268 -0.56518 .7779 Mabsadd L
.51637 .5268 -2.37764 .77254 Mabsadd L
.51637 .5268 -0.91448 -0.29713 Mabsadd L
.51637 .5268 -1.46946 -2.02254 Mabsadd L
.51637 .5268 0 -0.96154 Mabsadd L
.51637 .5268 1.46946 -2.02254 Mabsadd L
.51637 .5268 .91448 -0.29713 Mabsadd L
.51637 .5268 2.37764 .77254 Mabsadd L
.51637 .5268 .56518 .7779 Mabsadd L
.51637 .5268 0 2.5 Mabsadd L closepath F
.51786 .52829 0 2.5 Mabsadd m
.51786 .52829 -0.56518 .7779 Mabsadd L
.51786 .52829 -2.37764 .77254 Mabsadd L
.51786 .52829 -0.91448 -0.29713 Mabsadd L
.51786 .52829 -1.46946 -2.02254 Mabsadd L
.51786 .52829 0 -0.96154 Mabsadd L
.51786 .52829 1.46946 -2.02254 Mabsadd L
.51786 .52829 .91448 -0.29713 Mabsadd L
.51786 .52829 2.37764 .77254 Mabsadd L
.51786 .52829 .56518 .7779 Mabsadd L
.51786 .52829 0 2.5 Mabsadd L closepath F
.51935 .52979 0 2.5 Mabsadd m
.51935 .52979 -0.56518 .7779 Mabsadd L
.51935 .52979 -2.37764 .77254 Mabsadd L
.51935 .52979 -0.91448 -0.29713 Mabsadd L
.51935 .52979 -1.46946 -2.02254 Mabsadd L
.51935 .52979 0 -0.96154 Mabsadd L
.51935 .52979 1.46946 -2.02254 Mabsadd L
.51935 .52979 .91448 -0.29713 Mabsadd L
.51935 .52979 2.37764 .77254 Mabsadd L
.51935 .52979 .56518 .7779 Mabsadd L
.51935 .52979 0 2.5 Mabsadd L closepath F
.52083 .53129 0 2.5 Mabsadd m
.52083 .53129 -0.56518 .7779 Mabsadd L
.52083 .53129 -2.37764 .77254 Mabsadd L
.52083 .53129 -0.91448 -0.29713 Mabsadd L
.52083 .53129 -1.46946 -2.02254 Mabsadd L
.52083 .53129 0 -0.96154 Mabsadd L
.52083 .53129 1.46946 -2.02254 Mabsadd L
.52083 .53129 .91448 -0.29713 Mabsadd L
.52083 .53129 2.37764 .77254 Mabsadd L
.52083 .53129 .56518 .7779 Mabsadd L
.52083 .53129 0 2.5 Mabsadd L closepath F
.52232 .53279 0 2.5 Mabsadd m
.52232 .53279 -0.56518 .7779 Mabsadd L
.52232 .53279 -2.37764 .77254 Mabsadd L
.52232 .53279 -0.91448 -0.29713 Mabsadd L
.52232 .53279 -1.46946 -2.02254 Mabsadd L
.52232 .53279 0 -0.96154 Mabsadd L
.52232 .53279 1.46946 -2.02254 Mabsadd L
.52232 .53279 .91448 -0.29713 Mabsadd L
.52232 .53279 2.37764 .77254 Mabsadd L
.52232 .53279 .56518 .7779 Mabsadd L
.52232 .53279 0 2.5 Mabsadd L closepath F
.52381 .53428 0 2.5 Mabsadd m
.52381 .53428 -0.56518 .7779 Mabsadd L
.52381 .53428 -2.37764 .77254 Mabsadd L
.52381 .53428 -0.91448 -0.29713 Mabsadd L
.52381 .53428 -1.46946 -2.02254 Mabsadd L
.52381 .53428 0 -0.96154 Mabsadd L
.52381 .53428 1.46946 -2.02254 Mabsadd L
.52381 .53428 .91448 -0.29713 Mabsadd L
.52381 .53428 2.37764 .77254 Mabsadd L
.52381 .53428 .56518 .7779 Mabsadd L
.52381 .53428 0 2.5 Mabsadd L closepath F
.5253 .53578 0 2.5 Mabsadd m
.5253 .53578 -0.56518 .7779 Mabsadd L
.5253 .53578 -2.37764 .77254 Mabsadd L
.5253 .53578 -0.91448 -0.29713 Mabsadd L
.5253 .53578 -1.46946 -2.02254 Mabsadd L
.5253 .53578 0 -0.96154 Mabsadd L
.5253 .53578 1.46946 -2.02254 Mabsadd L
.5253 .53578 .91448 -0.29713 Mabsadd L
.5253 .53578 2.37764 .77254 Mabsadd L
.5253 .53578 .56518 .7779 Mabsadd L
.5253 .53578 0 2.5 Mabsadd L closepath F
.52679 .53728 0 2.5 Mabsadd m
.52679 .53728 -0.56518 .7779 Mabsadd L
.52679 .53728 -2.37764 .77254 Mabsadd L
.52679 .53728 -0.91448 -0.29713 Mabsadd L
.52679 .53728 -1.46946 -2.02254 Mabsadd L
.52679 .53728 0 -0.96154 Mabsadd L
.52679 .53728 1.46946 -2.02254 Mabsadd L
.52679 .53728 .91448 -0.29713 Mabsadd L
.52679 .53728 2.37764 .77254 Mabsadd L
.52679 .53728 .56518 .7779 Mabsadd L
.52679 .53728 0 2.5 Mabsadd L closepath F
.52827 .53877 0 2.5 Mabsadd m
.52827 .53877 -0.56518 .7779 Mabsadd L
.52827 .53877 -2.37764 .77254 Mabsadd L
.52827 .53877 -0.91448 -0.29713 Mabsadd L
.52827 .53877 -1.46946 -2.02254 Mabsadd L
.52827 .53877 0 -0.96154 Mabsadd L
.52827 .53877 1.46946 -2.02254 Mabsadd L
.52827 .53877 .91448 -0.29713 Mabsadd L
.52827 .53877 2.37764 .77254 Mabsadd L
.52827 .53877 .56518 .7779 Mabsadd L
.52827 .53877 0 2.5 Mabsadd L closepath F
.52976 .54027 0 2.5 Mabsadd m
.52976 .54027 -0.56518 .7779 Mabsadd L
.52976 .54027 -2.37764 .77254 Mabsadd L
.52976 .54027 -0.91448 -0.29713 Mabsadd L
.52976 .54027 -1.46946 -2.02254 Mabsadd L
.52976 .54027 0 -0.96154 Mabsadd L
.52976 .54027 1.46946 -2.02254 Mabsadd L
.52976 .54027 .91448 -0.29713 Mabsadd L
.52976 .54027 2.37764 .77254 Mabsadd L
.52976 .54027 .56518 .7779 Mabsadd L
.52976 .54027 0 2.5 Mabsadd L closepath F
.53125 .54176 0 2.5 Mabsadd m
.53125 .54176 -0.56518 .7779 Mabsadd L
.53125 .54176 -2.37764 .77254 Mabsadd L
.53125 .54176 -0.91448 -0.29713 Mabsadd L
.53125 .54176 -1.46946 -2.02254 Mabsadd L
.53125 .54176 0 -0.96154 Mabsadd L
.53125 .54176 1.46946 -2.02254 Mabsadd L
.53125 .54176 .91448 -0.29713 Mabsadd L
.53125 .54176 2.37764 .77254 Mabsadd L
.53125 .54176 .56518 .7779 Mabsadd L
.53125 .54176 0 2.5 Mabsadd L closepath F
.53274 .54326 0 2.5 Mabsadd m
.53274 .54326 -0.56518 .7779 Mabsadd L
.53274 .54326 -2.37764 .77254 Mabsadd L
.53274 .54326 -0.91448 -0.29713 Mabsadd L
.53274 .54326 -1.46946 -2.02254 Mabsadd L
.53274 .54326 0 -0.96154 Mabsadd L
.53274 .54326 1.46946 -2.02254 Mabsadd L
.53274 .54326 .91448 -0.29713 Mabsadd L
.53274 .54326 2.37764 .77254 Mabsadd L
.53274 .54326 .56518 .7779 Mabsadd L
.53274 .54326 0 2.5 Mabsadd L closepath F
.53423 .54475 0 2.5 Mabsadd m
.53423 .54475 -0.56518 .7779 Mabsadd L
.53423 .54475 -2.37764 .77254 Mabsadd L
.53423 .54475 -0.91448 -0.29713 Mabsadd L
.53423 .54475 -1.46946 -2.02254 Mabsadd L
.53423 .54475 0 -0.96154 Mabsadd L
.53423 .54475 1.46946 -2.02254 Mabsadd L
.53423 .54475 .91448 -0.29713 Mabsadd L
.53423 .54475 2.37764 .77254 Mabsadd L
.53423 .54475 .56518 .7779 Mabsadd L
.53423 .54475 0 2.5 Mabsadd L closepath F
.53571 .54625 0 2.5 Mabsadd m
.53571 .54625 -0.56518 .7779 Mabsadd L
.53571 .54625 -2.37764 .77254 Mabsadd L
.53571 .54625 -0.91448 -0.29713 Mabsadd L
.53571 .54625 -1.46946 -2.02254 Mabsadd L
.53571 .54625 0 -0.96154 Mabsadd L
.53571 .54625 1.46946 -2.02254 Mabsadd L
.53571 .54625 .91448 -0.29713 Mabsadd L
.53571 .54625 2.37764 .77254 Mabsadd L
.53571 .54625 .56518 .7779 Mabsadd L
.53571 .54625 0 2.5 Mabsadd L closepath F
.5372 .54774 0 2.5 Mabsadd m
.5372 .54774 -0.56518 .7779 Mabsadd L
.5372 .54774 -2.37764 .77254 Mabsadd L
.5372 .54774 -0.91448 -0.29713 Mabsadd L
.5372 .54774 -1.46946 -2.02254 Mabsadd L
.5372 .54774 0 -0.96154 Mabsadd L
.5372 .54774 1.46946 -2.02254 Mabsadd L
.5372 .54774 .91448 -0.29713 Mabsadd L
.5372 .54774 2.37764 .77254 Mabsadd L
.5372 .54774 .56518 .7779 Mabsadd L
.5372 .54774 0 2.5 Mabsadd L closepath F
.53869 .54924 0 2.5 Mabsadd m
.53869 .54924 -0.56518 .7779 Mabsadd L
.53869 .54924 -2.37764 .77254 Mabsadd L
.53869 .54924 -0.91448 -0.29713 Mabsadd L
.53869 .54924 -1.46946 -2.02254 Mabsadd L
.53869 .54924 0 -0.96154 Mabsadd L
.53869 .54924 1.46946 -2.02254 Mabsadd L
.53869 .54924 .91448 -0.29713 Mabsadd L
.53869 .54924 2.37764 .77254 Mabsadd L
.53869 .54924 .56518 .7779 Mabsadd L
.53869 .54924 0 2.5 Mabsadd L closepath F
.54018 .55073 0 2.5 Mabsadd m
.54018 .55073 -0.56518 .7779 Mabsadd L
.54018 .55073 -2.37764 .77254 Mabsadd L
.54018 .55073 -0.91448 -0.29713 Mabsadd L
.54018 .55073 -1.46946 -2.02254 Mabsadd L
.54018 .55073 0 -0.96154 Mabsadd L
.54018 .55073 1.46946 -2.02254 Mabsadd L
.54018 .55073 .91448 -0.29713 Mabsadd L
.54018 .55073 2.37764 .77254 Mabsadd L
.54018 .55073 .56518 .7779 Mabsadd L
.54018 .55073 0 2.5 Mabsadd L closepath F
.54167 .55223 0 2.5 Mabsadd m
.54167 .55223 -0.56518 .7779 Mabsadd L
.54167 .55223 -2.37764 .77254 Mabsadd L
.54167 .55223 -0.91448 -0.29713 Mabsadd L
.54167 .55223 -1.46946 -2.02254 Mabsadd L
.54167 .55223 0 -0.96154 Mabsadd L
.54167 .55223 1.46946 -2.02254 Mabsadd L
.54167 .55223 .91448 -0.29713 Mabsadd L
.54167 .55223 2.37764 .77254 Mabsadd L
.54167 .55223 .56518 .7779 Mabsadd L
.54167 .55223 0 2.5 Mabsadd L closepath F
.54315 .55372 0 2.5 Mabsadd m
.54315 .55372 -0.56518 .7779 Mabsadd L
.54315 .55372 -2.37764 .77254 Mabsadd L
.54315 .55372 -0.91448 -0.29713 Mabsadd L
.54315 .55372 -1.46946 -2.02254 Mabsadd L
.54315 .55372 0 -0.96154 Mabsadd L
.54315 .55372 1.46946 -2.02254 Mabsadd L
.54315 .55372 .91448 -0.29713 Mabsadd L
.54315 .55372 2.37764 .77254 Mabsadd L
.54315 .55372 .56518 .7779 Mabsadd L
.54315 .55372 0 2.5 Mabsadd L closepath F
.54464 .55522 0 2.5 Mabsadd m
.54464 .55522 -0.56518 .7779 Mabsadd L
.54464 .55522 -2.37764 .77254 Mabsadd L
.54464 .55522 -0.91448 -0.29713 Mabsadd L
.54464 .55522 -1.46946 -2.02254 Mabsadd L
.54464 .55522 0 -0.96154 Mabsadd L
.54464 .55522 1.46946 -2.02254 Mabsadd L
.54464 .55522 .91448 -0.29713 Mabsadd L
.54464 .55522 2.37764 .77254 Mabsadd L
.54464 .55522 .56518 .7779 Mabsadd L
.54464 .55522 0 2.5 Mabsadd L closepath F
.54613 .55671 0 2.5 Mabsadd m
.54613 .55671 -0.56518 .7779 Mabsadd L
.54613 .55671 -2.37764 .77254 Mabsadd L
.54613 .55671 -0.91448 -0.29713 Mabsadd L
.54613 .55671 -1.46946 -2.02254 Mabsadd L
.54613 .55671 0 -0.96154 Mabsadd L
.54613 .55671 1.46946 -2.02254 Mabsadd L
.54613 .55671 .91448 -0.29713 Mabsadd L
.54613 .55671 2.37764 .77254 Mabsadd L
.54613 .55671 .56518 .7779 Mabsadd L
.54613 .55671 0 2.5 Mabsadd L closepath F
.54762 .5582 0 2.5 Mabsadd m
.54762 .5582 -0.56518 .7779 Mabsadd L
.54762 .5582 -2.37764 .77254 Mabsadd L
.54762 .5582 -0.91448 -0.29713 Mabsadd L
.54762 .5582 -1.46946 -2.02254 Mabsadd L
.54762 .5582 0 -0.96154 Mabsadd L
.54762 .5582 1.46946 -2.02254 Mabsadd L
.54762 .5582 .91448 -0.29713 Mabsadd L
.54762 .5582 2.37764 .77254 Mabsadd L
.54762 .5582 .56518 .7779 Mabsadd L
.54762 .5582 0 2.5 Mabsadd L closepath F
.54911 .5597 0 2.5 Mabsadd m
.54911 .5597 -0.56518 .7779 Mabsadd L
.54911 .5597 -2.37764 .77254 Mabsadd L
.54911 .5597 -0.91448 -0.29713 Mabsadd L
.54911 .5597 -1.46946 -2.02254 Mabsadd L
.54911 .5597 0 -0.96154 Mabsadd L
.54911 .5597 1.46946 -2.02254 Mabsadd L
.54911 .5597 .91448 -0.29713 Mabsadd L
.54911 .5597 2.37764 .77254 Mabsadd L
.54911 .5597 .56518 .7779 Mabsadd L
.54911 .5597 0 2.5 Mabsadd L closepath F
.5506 .56119 0 2.5 Mabsadd m
.5506 .56119 -0.56518 .7779 Mabsadd L
.5506 .56119 -2.37764 .77254 Mabsadd L
.5506 .56119 -0.91448 -0.29713 Mabsadd L
.5506 .56119 -1.46946 -2.02254 Mabsadd L
.5506 .56119 0 -0.96154 Mabsadd L
.5506 .56119 1.46946 -2.02254 Mabsadd L
.5506 .56119 .91448 -0.29713 Mabsadd L
.5506 .56119 2.37764 .77254 Mabsadd L
.5506 .56119 .56518 .7779 Mabsadd L
.5506 .56119 0 2.5 Mabsadd L closepath F
.55208 .56268 0 2.5 Mabsadd m
.55208 .56268 -0.56518 .7779 Mabsadd L
.55208 .56268 -2.37764 .77254 Mabsadd L
.55208 .56268 -0.91448 -0.29713 Mabsadd L
.55208 .56268 -1.46946 -2.02254 Mabsadd L
.55208 .56268 0 -0.96154 Mabsadd L
.55208 .56268 1.46946 -2.02254 Mabsadd L
.55208 .56268 .91448 -0.29713 Mabsadd L
.55208 .56268 2.37764 .77254 Mabsadd L
.55208 .56268 .56518 .7779 Mabsadd L
.55208 .56268 0 2.5 Mabsadd L closepath F
.55357 .56418 0 2.5 Mabsadd m
.55357 .56418 -0.56518 .7779 Mabsadd L
.55357 .56418 -2.37764 .77254 Mabsadd L
.55357 .56418 -0.91448 -0.29713 Mabsadd L
.55357 .56418 -1.46946 -2.02254 Mabsadd L
.55357 .56418 0 -0.96154 Mabsadd L
.55357 .56418 1.46946 -2.02254 Mabsadd L
.55357 .56418 .91448 -0.29713 Mabsadd L
.55357 .56418 2.37764 .77254 Mabsadd L
.55357 .56418 .56518 .7779 Mabsadd L
.55357 .56418 0 2.5 Mabsadd L closepath F
.55506 .56567 0 2.5 Mabsadd m
.55506 .56567 -0.56518 .7779 Mabsadd L
.55506 .56567 -2.37764 .77254 Mabsadd L
.55506 .56567 -0.91448 -0.29713 Mabsadd L
.55506 .56567 -1.46946 -2.02254 Mabsadd L
.55506 .56567 0 -0.96154 Mabsadd L
.55506 .56567 1.46946 -2.02254 Mabsadd L
.55506 .56567 .91448 -0.29713 Mabsadd L
.55506 .56567 2.37764 .77254 Mabsadd L
.55506 .56567 .56518 .7779 Mabsadd L
.55506 .56567 0 2.5 Mabsadd L closepath F
.55655 .56716 0 2.5 Mabsadd m
.55655 .56716 -0.56518 .7779 Mabsadd L
.55655 .56716 -2.37764 .77254 Mabsadd L
.55655 .56716 -0.91448 -0.29713 Mabsadd L
.55655 .56716 -1.46946 -2.02254 Mabsadd L
.55655 .56716 0 -0.96154 Mabsadd L
.55655 .56716 1.46946 -2.02254 Mabsadd L
.55655 .56716 .91448 -0.29713 Mabsadd L
.55655 .56716 2.37764 .77254 Mabsadd L
.55655 .56716 .56518 .7779 Mabsadd L
.55655 .56716 0 2.5 Mabsadd L closepath F
.55804 .56865 0 2.5 Mabsadd m
.55804 .56865 -0.56518 .7779 Mabsadd L
.55804 .56865 -2.37764 .77254 Mabsadd L
.55804 .56865 -0.91448 -0.29713 Mabsadd L
.55804 .56865 -1.46946 -2.02254 Mabsadd L
.55804 .56865 0 -0.96154 Mabsadd L
.55804 .56865 1.46946 -2.02254 Mabsadd L
.55804 .56865 .91448 -0.29713 Mabsadd L
.55804 .56865 2.37764 .77254 Mabsadd L
.55804 .56865 .56518 .7779 Mabsadd L
.55804 .56865 0 2.5 Mabsadd L closepath F
.55952 .57015 0 2.5 Mabsadd m
.55952 .57015 -0.56518 .7779 Mabsadd L
.55952 .57015 -2.37764 .77254 Mabsadd L
.55952 .57015 -0.91448 -0.29713 Mabsadd L
.55952 .57015 -1.46946 -2.02254 Mabsadd L
.55952 .57015 0 -0.96154 Mabsadd L
.55952 .57015 1.46946 -2.02254 Mabsadd L
.55952 .57015 .91448 -0.29713 Mabsadd L
.55952 .57015 2.37764 .77254 Mabsadd L
.55952 .57015 .56518 .7779 Mabsadd L
.55952 .57015 0 2.5 Mabsadd L closepath F
.56101 .57164 0 2.5 Mabsadd m
.56101 .57164 -0.56518 .7779 Mabsadd L
.56101 .57164 -2.37764 .77254 Mabsadd L
.56101 .57164 -0.91448 -0.29713 Mabsadd L
.56101 .57164 -1.46946 -2.02254 Mabsadd L
.56101 .57164 0 -0.96154 Mabsadd L
.56101 .57164 1.46946 -2.02254 Mabsadd L
.56101 .57164 .91448 -0.29713 Mabsadd L
.56101 .57164 2.37764 .77254 Mabsadd L
.56101 .57164 .56518 .7779 Mabsadd L
.56101 .57164 0 2.5 Mabsadd L closepath F
.5625 .57313 0 2.5 Mabsadd m
.5625 .57313 -0.56518 .7779 Mabsadd L
.5625 .57313 -2.37764 .77254 Mabsadd L
.5625 .57313 -0.91448 -0.29713 Mabsadd L
.5625 .57313 -1.46946 -2.02254 Mabsadd L
.5625 .57313 0 -0.96154 Mabsadd L
.5625 .57313 1.46946 -2.02254 Mabsadd L
.5625 .57313 .91448 -0.29713 Mabsadd L
.5625 .57313 2.37764 .77254 Mabsadd L
.5625 .57313 .56518 .7779 Mabsadd L
.5625 .57313 0 2.5 Mabsadd L closepath F
.56399 .57462 0 2.5 Mabsadd m
.56399 .57462 -0.56518 .7779 Mabsadd L
.56399 .57462 -2.37764 .77254 Mabsadd L
.56399 .57462 -0.91448 -0.29713 Mabsadd L
.56399 .57462 -1.46946 -2.02254 Mabsadd L
.56399 .57462 0 -0.96154 Mabsadd L
.56399 .57462 1.46946 -2.02254 Mabsadd L
.56399 .57462 .91448 -0.29713 Mabsadd L
.56399 .57462 2.37764 .77254 Mabsadd L
.56399 .57462 .56518 .7779 Mabsadd L
.56399 .57462 0 2.5 Mabsadd L closepath F
.56548 .57611 0 2.5 Mabsadd m
.56548 .57611 -0.56518 .7779 Mabsadd L
.56548 .57611 -2.37764 .77254 Mabsadd L
.56548 .57611 -0.91448 -0.29713 Mabsadd L
.56548 .57611 -1.46946 -2.02254 Mabsadd L
.56548 .57611 0 -0.96154 Mabsadd L
.56548 .57611 1.46946 -2.02254 Mabsadd L
.56548 .57611 .91448 -0.29713 Mabsadd L
.56548 .57611 2.37764 .77254 Mabsadd L
.56548 .57611 .56518 .7779 Mabsadd L
.56548 .57611 0 2.5 Mabsadd L closepath F
.56696 .5776 0 2.5 Mabsadd m
.56696 .5776 -0.56518 .7779 Mabsadd L
.56696 .5776 -2.37764 .77254 Mabsadd L
.56696 .5776 -0.91448 -0.29713 Mabsadd L
.56696 .5776 -1.46946 -2.02254 Mabsadd L
.56696 .5776 0 -0.96154 Mabsadd L
.56696 .5776 1.46946 -2.02254 Mabsadd L
.56696 .5776 .91448 -0.29713 Mabsadd L
.56696 .5776 2.37764 .77254 Mabsadd L
.56696 .5776 .56518 .7779 Mabsadd L
.56696 .5776 0 2.5 Mabsadd L closepath F
.56845 .57909 0 2.5 Mabsadd m
.56845 .57909 -0.56518 .7779 Mabsadd L
.56845 .57909 -2.37764 .77254 Mabsadd L
.56845 .57909 -0.91448 -0.29713 Mabsadd L
.56845 .57909 -1.46946 -2.02254 Mabsadd L
.56845 .57909 0 -0.96154 Mabsadd L
.56845 .57909 1.46946 -2.02254 Mabsadd L
.56845 .57909 .91448 -0.29713 Mabsadd L
.56845 .57909 2.37764 .77254 Mabsadd L
.56845 .57909 .56518 .7779 Mabsadd L
.56845 .57909 0 2.5 Mabsadd L closepath F
.56994 .58058 0 2.5 Mabsadd m
.56994 .58058 -0.56518 .7779 Mabsadd L
.56994 .58058 -2.37764 .77254 Mabsadd L
.56994 .58058 -0.91448 -0.29713 Mabsadd L
.56994 .58058 -1.46946 -2.02254 Mabsadd L
.56994 .58058 0 -0.96154 Mabsadd L
.56994 .58058 1.46946 -2.02254 Mabsadd L
.56994 .58058 .91448 -0.29713 Mabsadd L
.56994 .58058 2.37764 .77254 Mabsadd L
.56994 .58058 .56518 .7779 Mabsadd L
.56994 .58058 0 2.5 Mabsadd L closepath F
.57143 .58207 0 2.5 Mabsadd m
.57143 .58207 -0.56518 .7779 Mabsadd L
.57143 .58207 -2.37764 .77254 Mabsadd L
.57143 .58207 -0.91448 -0.29713 Mabsadd L
.57143 .58207 -1.46946 -2.02254 Mabsadd L
.57143 .58207 0 -0.96154 Mabsadd L
.57143 .58207 1.46946 -2.02254 Mabsadd L
.57143 .58207 .91448 -0.29713 Mabsadd L
.57143 .58207 2.37764 .77254 Mabsadd L
.57143 .58207 .56518 .7779 Mabsadd L
.57143 .58207 0 2.5 Mabsadd L closepath F
.57292 .58356 0 2.5 Mabsadd m
.57292 .58356 -0.56518 .7779 Mabsadd L
.57292 .58356 -2.37764 .77254 Mabsadd L
.57292 .58356 -0.91448 -0.29713 Mabsadd L
.57292 .58356 -1.46946 -2.02254 Mabsadd L
.57292 .58356 0 -0.96154 Mabsadd L
.57292 .58356 1.46946 -2.02254 Mabsadd L
.57292 .58356 .91448 -0.29713 Mabsadd L
.57292 .58356 2.37764 .77254 Mabsadd L
.57292 .58356 .56518 .7779 Mabsadd L
.57292 .58356 0 2.5 Mabsadd L closepath F
.5744 .58505 0 2.5 Mabsadd m
.5744 .58505 -0.56518 .7779 Mabsadd L
.5744 .58505 -2.37764 .77254 Mabsadd L
.5744 .58505 -0.91448 -0.29713 Mabsadd L
.5744 .58505 -1.46946 -2.02254 Mabsadd L
.5744 .58505 0 -0.96154 Mabsadd L
.5744 .58505 1.46946 -2.02254 Mabsadd L
.5744 .58505 .91448 -0.29713 Mabsadd L
.5744 .58505 2.37764 .77254 Mabsadd L
.5744 .58505 .56518 .7779 Mabsadd L
.5744 .58505 0 2.5 Mabsadd L closepath F
.57589 .58654 0 2.5 Mabsadd m
.57589 .58654 -0.56518 .7779 Mabsadd L
.57589 .58654 -2.37764 .77254 Mabsadd L
.57589 .58654 -0.91448 -0.29713 Mabsadd L
.57589 .58654 -1.46946 -2.02254 Mabsadd L
.57589 .58654 0 -0.96154 Mabsadd L
.57589 .58654 1.46946 -2.02254 Mabsadd L
.57589 .58654 .91448 -0.29713 Mabsadd L
.57589 .58654 2.37764 .77254 Mabsadd L
.57589 .58654 .56518 .7779 Mabsadd L
.57589 .58654 0 2.5 Mabsadd L closepath F
.57738 .58803 0 2.5 Mabsadd m
.57738 .58803 -0.56518 .7779 Mabsadd L
.57738 .58803 -2.37764 .77254 Mabsadd L
.57738 .58803 -0.91448 -0.29713 Mabsadd L
.57738 .58803 -1.46946 -2.02254 Mabsadd L
.57738 .58803 0 -0.96154 Mabsadd L
.57738 .58803 1.46946 -2.02254 Mabsadd L
.57738 .58803 .91448 -0.29713 Mabsadd L
.57738 .58803 2.37764 .77254 Mabsadd L
.57738 .58803 .56518 .7779 Mabsadd L
.57738 .58803 0 2.5 Mabsadd L closepath F
.57887 .58952 0 2.5 Mabsadd m
.57887 .58952 -0.56518 .7779 Mabsadd L
.57887 .58952 -2.37764 .77254 Mabsadd L
.57887 .58952 -0.91448 -0.29713 Mabsadd L
.57887 .58952 -1.46946 -2.02254 Mabsadd L
.57887 .58952 0 -0.96154 Mabsadd L
.57887 .58952 1.46946 -2.02254 Mabsadd L
.57887 .58952 .91448 -0.29713 Mabsadd L
.57887 .58952 2.37764 .77254 Mabsadd L
.57887 .58952 .56518 .7779 Mabsadd L
.57887 .58952 0 2.5 Mabsadd L closepath F
.58036 .59101 0 2.5 Mabsadd m
.58036 .59101 -0.56518 .7779 Mabsadd L
.58036 .59101 -2.37764 .77254 Mabsadd L
.58036 .59101 -0.91448 -0.29713 Mabsadd L
.58036 .59101 -1.46946 -2.02254 Mabsadd L
.58036 .59101 0 -0.96154 Mabsadd L
.58036 .59101 1.46946 -2.02254 Mabsadd L
.58036 .59101 .91448 -0.29713 Mabsadd L
.58036 .59101 2.37764 .77254 Mabsadd L
.58036 .59101 .56518 .7779 Mabsadd L
.58036 .59101 0 2.5 Mabsadd L closepath F
.58185 .5925 0 2.5 Mabsadd m
.58185 .5925 -0.56518 .7779 Mabsadd L
.58185 .5925 -2.37764 .77254 Mabsadd L
.58185 .5925 -0.91448 -0.29713 Mabsadd L
.58185 .5925 -1.46946 -2.02254 Mabsadd L
.58185 .5925 0 -0.96154 Mabsadd L
.58185 .5925 1.46946 -2.02254 Mabsadd L
.58185 .5925 .91448 -0.29713 Mabsadd L
.58185 .5925 2.37764 .77254 Mabsadd L
.58185 .5925 .56518 .7779 Mabsadd L
.58185 .5925 0 2.5 Mabsadd L closepath F
.58333 .59399 0 2.5 Mabsadd m
.58333 .59399 -0.56518 .7779 Mabsadd L
.58333 .59399 -2.37764 .77254 Mabsadd L
.58333 .59399 -0.91448 -0.29713 Mabsadd L
.58333 .59399 -1.46946 -2.02254 Mabsadd L
.58333 .59399 0 -0.96154 Mabsadd L
.58333 .59399 1.46946 -2.02254 Mabsadd L
.58333 .59399 .91448 -0.29713 Mabsadd L
.58333 .59399 2.37764 .77254 Mabsadd L
.58333 .59399 .56518 .7779 Mabsadd L
.58333 .59399 0 2.5 Mabsadd L closepath F
.58482 .59547 0 2.5 Mabsadd m
.58482 .59547 -0.56518 .7779 Mabsadd L
.58482 .59547 -2.37764 .77254 Mabsadd L
.58482 .59547 -0.91448 -0.29713 Mabsadd L
.58482 .59547 -1.46946 -2.02254 Mabsadd L
.58482 .59547 0 -0.96154 Mabsadd L
.58482 .59547 1.46946 -2.02254 Mabsadd L
.58482 .59547 .91448 -0.29713 Mabsadd L
.58482 .59547 2.37764 .77254 Mabsadd L
.58482 .59547 .56518 .7779 Mabsadd L
.58482 .59547 0 2.5 Mabsadd L closepath F
.58631 .59696 0 2.5 Mabsadd m
.58631 .59696 -0.56518 .7779 Mabsadd L
.58631 .59696 -2.37764 .77254 Mabsadd L
.58631 .59696 -0.91448 -0.29713 Mabsadd L
.58631 .59696 -1.46946 -2.02254 Mabsadd L
.58631 .59696 0 -0.96154 Mabsadd L
.58631 .59696 1.46946 -2.02254 Mabsadd L
.58631 .59696 .91448 -0.29713 Mabsadd L
.58631 .59696 2.37764 .77254 Mabsadd L
.58631 .59696 .56518 .7779 Mabsadd L
.58631 .59696 0 2.5 Mabsadd L closepath F
.5878 .59845 0 2.5 Mabsadd m
.5878 .59845 -0.56518 .7779 Mabsadd L
.5878 .59845 -2.37764 .77254 Mabsadd L
.5878 .59845 -0.91448 -0.29713 Mabsadd L
.5878 .59845 -1.46946 -2.02254 Mabsadd L
.5878 .59845 0 -0.96154 Mabsadd L
.5878 .59845 1.46946 -2.02254 Mabsadd L
.5878 .59845 .91448 -0.29713 Mabsadd L
.5878 .59845 2.37764 .77254 Mabsadd L
.5878 .59845 .56518 .7779 Mabsadd L
.5878 .59845 0 2.5 Mabsadd L closepath F
.58929 .59994 0 2.5 Mabsadd m
.58929 .59994 -0.56518 .7779 Mabsadd L
.58929 .59994 -2.37764 .77254 Mabsadd L
.58929 .59994 -0.91448 -0.29713 Mabsadd L
.58929 .59994 -1.46946 -2.02254 Mabsadd L
.58929 .59994 0 -0.96154 Mabsadd L
.58929 .59994 1.46946 -2.02254 Mabsadd L
.58929 .59994 .91448 -0.29713 Mabsadd L
.58929 .59994 2.37764 .77254 Mabsadd L
.58929 .59994 .56518 .7779 Mabsadd L
.58929 .59994 0 2.5 Mabsadd L closepath F
.59077 .60142 0 2.5 Mabsadd m
.59077 .60142 -0.56518 .7779 Mabsadd L
.59077 .60142 -2.37764 .77254 Mabsadd L
.59077 .60142 -0.91448 -0.29713 Mabsadd L
.59077 .60142 -1.46946 -2.02254 Mabsadd L
.59077 .60142 0 -0.96154 Mabsadd L
.59077 .60142 1.46946 -2.02254 Mabsadd L
.59077 .60142 .91448 -0.29713 Mabsadd L
.59077 .60142 2.37764 .77254 Mabsadd L
.59077 .60142 .56518 .7779 Mabsadd L
.59077 .60142 0 2.5 Mabsadd L closepath F
.59226 .60291 0 2.5 Mabsadd m
.59226 .60291 -0.56518 .7779 Mabsadd L
.59226 .60291 -2.37764 .77254 Mabsadd L
.59226 .60291 -0.91448 -0.29713 Mabsadd L
.59226 .60291 -1.46946 -2.02254 Mabsadd L
.59226 .60291 0 -0.96154 Mabsadd L
.59226 .60291 1.46946 -2.02254 Mabsadd L
.59226 .60291 .91448 -0.29713 Mabsadd L
.59226 .60291 2.37764 .77254 Mabsadd L
.59226 .60291 .56518 .7779 Mabsadd L
.59226 .60291 0 2.5 Mabsadd L closepath F
.59375 .6044 0 2.5 Mabsadd m
.59375 .6044 -0.56518 .7779 Mabsadd L
.59375 .6044 -2.37764 .77254 Mabsadd L
.59375 .6044 -0.91448 -0.29713 Mabsadd L
.59375 .6044 -1.46946 -2.02254 Mabsadd L
.59375 .6044 0 -0.96154 Mabsadd L
.59375 .6044 1.46946 -2.02254 Mabsadd L
.59375 .6044 .91448 -0.29713 Mabsadd L
.59375 .6044 2.37764 .77254 Mabsadd L
.59375 .6044 .56518 .7779 Mabsadd L
.59375 .6044 0 2.5 Mabsadd L closepath F
.59524 .60588 0 2.5 Mabsadd m
.59524 .60588 -0.56518 .7779 Mabsadd L
.59524 .60588 -2.37764 .77254 Mabsadd L
.59524 .60588 -0.91448 -0.29713 Mabsadd L
.59524 .60588 -1.46946 -2.02254 Mabsadd L
.59524 .60588 0 -0.96154 Mabsadd L
.59524 .60588 1.46946 -2.02254 Mabsadd L
.59524 .60588 .91448 -0.29713 Mabsadd L
.59524 .60588 2.37764 .77254 Mabsadd L
.59524 .60588 .56518 .7779 Mabsadd L
.59524 .60588 0 2.5 Mabsadd L closepath F
.59673 .60737 0 2.5 Mabsadd m
.59673 .60737 -0.56518 .7779 Mabsadd L
.59673 .60737 -2.37764 .77254 Mabsadd L
.59673 .60737 -0.91448 -0.29713 Mabsadd L
.59673 .60737 -1.46946 -2.02254 Mabsadd L
.59673 .60737 0 -0.96154 Mabsadd L
.59673 .60737 1.46946 -2.02254 Mabsadd L
.59673 .60737 .91448 -0.29713 Mabsadd L
.59673 .60737 2.37764 .77254 Mabsadd L
.59673 .60737 .56518 .7779 Mabsadd L
.59673 .60737 0 2.5 Mabsadd L closepath F
.59821 .60886 0 2.5 Mabsadd m
.59821 .60886 -0.56518 .7779 Mabsadd L
.59821 .60886 -2.37764 .77254 Mabsadd L
.59821 .60886 -0.91448 -0.29713 Mabsadd L
.59821 .60886 -1.46946 -2.02254 Mabsadd L
.59821 .60886 0 -0.96154 Mabsadd L
.59821 .60886 1.46946 -2.02254 Mabsadd L
.59821 .60886 .91448 -0.29713 Mabsadd L
.59821 .60886 2.37764 .77254 Mabsadd L
.59821 .60886 .56518 .7779 Mabsadd L
.59821 .60886 0 2.5 Mabsadd L closepath F
.5997 .61034 0 2.5 Mabsadd m
.5997 .61034 -0.56518 .7779 Mabsadd L
.5997 .61034 -2.37764 .77254 Mabsadd L
.5997 .61034 -0.91448 -0.29713 Mabsadd L
.5997 .61034 -1.46946 -2.02254 Mabsadd L
.5997 .61034 0 -0.96154 Mabsadd L
.5997 .61034 1.46946 -2.02254 Mabsadd L
.5997 .61034 .91448 -0.29713 Mabsadd L
.5997 .61034 2.37764 .77254 Mabsadd L
.5997 .61034 .56518 .7779 Mabsadd L
.5997 .61034 0 2.5 Mabsadd L closepath F
.60119 .61183 0 2.5 Mabsadd m
.60119 .61183 -0.56518 .7779 Mabsadd L
.60119 .61183 -2.37764 .77254 Mabsadd L
.60119 .61183 -0.91448 -0.29713 Mabsadd L
.60119 .61183 -1.46946 -2.02254 Mabsadd L
.60119 .61183 0 -0.96154 Mabsadd L
.60119 .61183 1.46946 -2.02254 Mabsadd L
.60119 .61183 .91448 -0.29713 Mabsadd L
.60119 .61183 2.37764 .77254 Mabsadd L
.60119 .61183 .56518 .7779 Mabsadd L
.60119 .61183 0 2.5 Mabsadd L closepath F
.60268 .61331 0 2.5 Mabsadd m
.60268 .61331 -0.56518 .7779 Mabsadd L
.60268 .61331 -2.37764 .77254 Mabsadd L
.60268 .61331 -0.91448 -0.29713 Mabsadd L
.60268 .61331 -1.46946 -2.02254 Mabsadd L
.60268 .61331 0 -0.96154 Mabsadd L
.60268 .61331 1.46946 -2.02254 Mabsadd L
.60268 .61331 .91448 -0.29713 Mabsadd L
.60268 .61331 2.37764 .77254 Mabsadd L
.60268 .61331 .56518 .7779 Mabsadd L
.60268 .61331 0 2.5 Mabsadd L closepath F
.60417 .6148 0 2.5 Mabsadd m
.60417 .6148 -0.56518 .7779 Mabsadd L
.60417 .6148 -2.37764 .77254 Mabsadd L
.60417 .6148 -0.91448 -0.29713 Mabsadd L
.60417 .6148 -1.46946 -2.02254 Mabsadd L
.60417 .6148 0 -0.96154 Mabsadd L
.60417 .6148 1.46946 -2.02254 Mabsadd L
.60417 .6148 .91448 -0.29713 Mabsadd L
.60417 .6148 2.37764 .77254 Mabsadd L
.60417 .6148 .56518 .7779 Mabsadd L
.60417 .6148 0 2.5 Mabsadd L closepath F
.60565 .61628 0 2.5 Mabsadd m
.60565 .61628 -0.56518 .7779 Mabsadd L
.60565 .61628 -2.37764 .77254 Mabsadd L
.60565 .61628 -0.91448 -0.29713 Mabsadd L
.60565 .61628 -1.46946 -2.02254 Mabsadd L
.60565 .61628 0 -0.96154 Mabsadd L
.60565 .61628 1.46946 -2.02254 Mabsadd L
.60565 .61628 .91448 -0.29713 Mabsadd L
.60565 .61628 2.37764 .77254 Mabsadd L
.60565 .61628 .56518 .7779 Mabsadd L
.60565 .61628 0 2.5 Mabsadd L closepath F
.60714 .61777 0 2.5 Mabsadd m
.60714 .61777 -0.56518 .7779 Mabsadd L
.60714 .61777 -2.37764 .77254 Mabsadd L
.60714 .61777 -0.91448 -0.29713 Mabsadd L
.60714 .61777 -1.46946 -2.02254 Mabsadd L
.60714 .61777 0 -0.96154 Mabsadd L
.60714 .61777 1.46946 -2.02254 Mabsadd L
.60714 .61777 .91448 -0.29713 Mabsadd L
.60714 .61777 2.37764 .77254 Mabsadd L
.60714 .61777 .56518 .7779 Mabsadd L
.60714 .61777 0 2.5 Mabsadd L closepath F
.60863 .61925 0 2.5 Mabsadd m
.60863 .61925 -0.56518 .7779 Mabsadd L
.60863 .61925 -2.37764 .77254 Mabsadd L
.60863 .61925 -0.91448 -0.29713 Mabsadd L
.60863 .61925 -1.46946 -2.02254 Mabsadd L
.60863 .61925 0 -0.96154 Mabsadd L
.60863 .61925 1.46946 -2.02254 Mabsadd L
.60863 .61925 .91448 -0.29713 Mabsadd L
.60863 .61925 2.37764 .77254 Mabsadd L
.60863 .61925 .56518 .7779 Mabsadd L
.60863 .61925 0 2.5 Mabsadd L closepath F
.61012 .62074 0 2.5 Mabsadd m
.61012 .62074 -0.56518 .7779 Mabsadd L
.61012 .62074 -2.37764 .77254 Mabsadd L
.61012 .62074 -0.91448 -0.29713 Mabsadd L
.61012 .62074 -1.46946 -2.02254 Mabsadd L
.61012 .62074 0 -0.96154 Mabsadd L
.61012 .62074 1.46946 -2.02254 Mabsadd L
.61012 .62074 .91448 -0.29713 Mabsadd L
.61012 .62074 2.37764 .77254 Mabsadd L
.61012 .62074 .56518 .7779 Mabsadd L
.61012 .62074 0 2.5 Mabsadd L closepath F
.61161 .62222 0 2.5 Mabsadd m
.61161 .62222 -0.56518 .7779 Mabsadd L
.61161 .62222 -2.37764 .77254 Mabsadd L
.61161 .62222 -0.91448 -0.29713 Mabsadd L
.61161 .62222 -1.46946 -2.02254 Mabsadd L
.61161 .62222 0 -0.96154 Mabsadd L
.61161 .62222 1.46946 -2.02254 Mabsadd L
.61161 .62222 .91448 -0.29713 Mabsadd L
.61161 .62222 2.37764 .77254 Mabsadd L
.61161 .62222 .56518 .7779 Mabsadd L
.61161 .62222 0 2.5 Mabsadd L closepath F
.6131 .6237 0 2.5 Mabsadd m
.6131 .6237 -0.56518 .7779 Mabsadd L
.6131 .6237 -2.37764 .77254 Mabsadd L
.6131 .6237 -0.91448 -0.29713 Mabsadd L
.6131 .6237 -1.46946 -2.02254 Mabsadd L
.6131 .6237 0 -0.96154 Mabsadd L
.6131 .6237 1.46946 -2.02254 Mabsadd L
.6131 .6237 .91448 -0.29713 Mabsadd L
.6131 .6237 2.37764 .77254 Mabsadd L
.6131 .6237 .56518 .7779 Mabsadd L
.6131 .6237 0 2.5 Mabsadd L closepath F
.61458 .62519 0 2.5 Mabsadd m
.61458 .62519 -0.56518 .7779 Mabsadd L
.61458 .62519 -2.37764 .77254 Mabsadd L
.61458 .62519 -0.91448 -0.29713 Mabsadd L
.61458 .62519 -1.46946 -2.02254 Mabsadd L
.61458 .62519 0 -0.96154 Mabsadd L
.61458 .62519 1.46946 -2.02254 Mabsadd L
.61458 .62519 .91448 -0.29713 Mabsadd L
.61458 .62519 2.37764 .77254 Mabsadd L
.61458 .62519 .56518 .7779 Mabsadd L
.61458 .62519 0 2.5 Mabsadd L closepath F
.61607 .62667 0 2.5 Mabsadd m
.61607 .62667 -0.56518 .7779 Mabsadd L
.61607 .62667 -2.37764 .77254 Mabsadd L
.61607 .62667 -0.91448 -0.29713 Mabsadd L
.61607 .62667 -1.46946 -2.02254 Mabsadd L
.61607 .62667 0 -0.96154 Mabsadd L
.61607 .62667 1.46946 -2.02254 Mabsadd L
.61607 .62667 .91448 -0.29713 Mabsadd L
.61607 .62667 2.37764 .77254 Mabsadd L
.61607 .62667 .56518 .7779 Mabsadd L
.61607 .62667 0 2.5 Mabsadd L closepath F
.61756 .62815 0 2.5 Mabsadd m
.61756 .62815 -0.56518 .7779 Mabsadd L
.61756 .62815 -2.37764 .77254 Mabsadd L
.61756 .62815 -0.91448 -0.29713 Mabsadd L
.61756 .62815 -1.46946 -2.02254 Mabsadd L
.61756 .62815 0 -0.96154 Mabsadd L
.61756 .62815 1.46946 -2.02254 Mabsadd L
.61756 .62815 .91448 -0.29713 Mabsadd L
.61756 .62815 2.37764 .77254 Mabsadd L
.61756 .62815 .56518 .7779 Mabsadd L
.61756 .62815 0 2.5 Mabsadd L closepath F
.61905 .62963 0 2.5 Mabsadd m
.61905 .62963 -0.56518 .7779 Mabsadd L
.61905 .62963 -2.37764 .77254 Mabsadd L
.61905 .62963 -0.91448 -0.29713 Mabsadd L
.61905 .62963 -1.46946 -2.02254 Mabsadd L
.61905 .62963 0 -0.96154 Mabsadd L
.61905 .62963 1.46946 -2.02254 Mabsadd L
.61905 .62963 .91448 -0.29713 Mabsadd L
.61905 .62963 2.37764 .77254 Mabsadd L
.61905 .62963 .56518 .7779 Mabsadd L
.61905 .62963 0 2.5 Mabsadd L closepath F
.62054 .63112 0 2.5 Mabsadd m
.62054 .63112 -0.56518 .7779 Mabsadd L
.62054 .63112 -2.37764 .77254 Mabsadd L
.62054 .63112 -0.91448 -0.29713 Mabsadd L
.62054 .63112 -1.46946 -2.02254 Mabsadd L
.62054 .63112 0 -0.96154 Mabsadd L
.62054 .63112 1.46946 -2.02254 Mabsadd L
.62054 .63112 .91448 -0.29713 Mabsadd L
.62054 .63112 2.37764 .77254 Mabsadd L
.62054 .63112 .56518 .7779 Mabsadd L
.62054 .63112 0 2.5 Mabsadd L closepath F
.62202 .6326 0 2.5 Mabsadd m
.62202 .6326 -0.56518 .7779 Mabsadd L
.62202 .6326 -2.37764 .77254 Mabsadd L
.62202 .6326 -0.91448 -0.29713 Mabsadd L
.62202 .6326 -1.46946 -2.02254 Mabsadd L
.62202 .6326 0 -0.96154 Mabsadd L
.62202 .6326 1.46946 -2.02254 Mabsadd L
.62202 .6326 .91448 -0.29713 Mabsadd L
.62202 .6326 2.37764 .77254 Mabsadd L
.62202 .6326 .56518 .7779 Mabsadd L
.62202 .6326 0 2.5 Mabsadd L closepath F
.62351 .63408 0 2.5 Mabsadd m
.62351 .63408 -0.56518 .7779 Mabsadd L
.62351 .63408 -2.37764 .77254 Mabsadd L
.62351 .63408 -0.91448 -0.29713 Mabsadd L
.62351 .63408 -1.46946 -2.02254 Mabsadd L
.62351 .63408 0 -0.96154 Mabsadd L
.62351 .63408 1.46946 -2.02254 Mabsadd L
.62351 .63408 .91448 -0.29713 Mabsadd L
.62351 .63408 2.37764 .77254 Mabsadd L
.62351 .63408 .56518 .7779 Mabsadd L
.62351 .63408 0 2.5 Mabsadd L closepath F
.625 .63556 0 2.5 Mabsadd m
.625 .63556 -0.56518 .7779 Mabsadd L
.625 .63556 -2.37764 .77254 Mabsadd L
.625 .63556 -0.91448 -0.29713 Mabsadd L
.625 .63556 -1.46946 -2.02254 Mabsadd L
.625 .63556 0 -0.96154 Mabsadd L
.625 .63556 1.46946 -2.02254 Mabsadd L
.625 .63556 .91448 -0.29713 Mabsadd L
.625 .63556 2.37764 .77254 Mabsadd L
.625 .63556 .56518 .7779 Mabsadd L
.625 .63556 0 2.5 Mabsadd L closepath F
.62649 .63704 0 2.5 Mabsadd m
.62649 .63704 -0.56518 .7779 Mabsadd L
.62649 .63704 -2.37764 .77254 Mabsadd L
.62649 .63704 -0.91448 -0.29713 Mabsadd L
.62649 .63704 -1.46946 -2.02254 Mabsadd L
.62649 .63704 0 -0.96154 Mabsadd L
.62649 .63704 1.46946 -2.02254 Mabsadd L
.62649 .63704 .91448 -0.29713 Mabsadd L
.62649 .63704 2.37764 .77254 Mabsadd L
.62649 .63704 .56518 .7779 Mabsadd L
.62649 .63704 0 2.5 Mabsadd L closepath F
.62798 .63852 0 2.5 Mabsadd m
.62798 .63852 -0.56518 .7779 Mabsadd L
.62798 .63852 -2.37764 .77254 Mabsadd L
.62798 .63852 -0.91448 -0.29713 Mabsadd L
.62798 .63852 -1.46946 -2.02254 Mabsadd L
.62798 .63852 0 -0.96154 Mabsadd L
.62798 .63852 1.46946 -2.02254 Mabsadd L
.62798 .63852 .91448 -0.29713 Mabsadd L
.62798 .63852 2.37764 .77254 Mabsadd L
.62798 .63852 .56518 .7779 Mabsadd L
.62798 .63852 0 2.5 Mabsadd L closepath F
.62946 .64001 0 2.5 Mabsadd m
.62946 .64001 -0.56518 .7779 Mabsadd L
.62946 .64001 -2.37764 .77254 Mabsadd L
.62946 .64001 -0.91448 -0.29713 Mabsadd L
.62946 .64001 -1.46946 -2.02254 Mabsadd L
.62946 .64001 0 -0.96154 Mabsadd L
.62946 .64001 1.46946 -2.02254 Mabsadd L
.62946 .64001 .91448 -0.29713 Mabsadd L
.62946 .64001 2.37764 .77254 Mabsadd L
.62946 .64001 .56518 .7779 Mabsadd L
.62946 .64001 0 2.5 Mabsadd L closepath F
.63095 .64149 0 2.5 Mabsadd m
.63095 .64149 -0.56518 .7779 Mabsadd L
.63095 .64149 -2.37764 .77254 Mabsadd L
.63095 .64149 -0.91448 -0.29713 Mabsadd L
.63095 .64149 -1.46946 -2.02254 Mabsadd L
.63095 .64149 0 -0.96154 Mabsadd L
.63095 .64149 1.46946 -2.02254 Mabsadd L
.63095 .64149 .91448 -0.29713 Mabsadd L
.63095 .64149 2.37764 .77254 Mabsadd L
.63095 .64149 .56518 .7779 Mabsadd L
.63095 .64149 0 2.5 Mabsadd L closepath F
.63244 .64297 0 2.5 Mabsadd m
.63244 .64297 -0.56518 .7779 Mabsadd L
.63244 .64297 -2.37764 .77254 Mabsadd L
.63244 .64297 -0.91448 -0.29713 Mabsadd L
.63244 .64297 -1.46946 -2.02254 Mabsadd L
.63244 .64297 0 -0.96154 Mabsadd L
.63244 .64297 1.46946 -2.02254 Mabsadd L
.63244 .64297 .91448 -0.29713 Mabsadd L
.63244 .64297 2.37764 .77254 Mabsadd L
.63244 .64297 .56518 .7779 Mabsadd L
.63244 .64297 0 2.5 Mabsadd L closepath F
.63393 .64445 0 2.5 Mabsadd m
.63393 .64445 -0.56518 .7779 Mabsadd L
.63393 .64445 -2.37764 .77254 Mabsadd L
.63393 .64445 -0.91448 -0.29713 Mabsadd L
.63393 .64445 -1.46946 -2.02254 Mabsadd L
.63393 .64445 0 -0.96154 Mabsadd L
.63393 .64445 1.46946 -2.02254 Mabsadd L
.63393 .64445 .91448 -0.29713 Mabsadd L
.63393 .64445 2.37764 .77254 Mabsadd L
.63393 .64445 .56518 .7779 Mabsadd L
.63393 .64445 0 2.5 Mabsadd L closepath F
.63542 .64593 0 2.5 Mabsadd m
.63542 .64593 -0.56518 .7779 Mabsadd L
.63542 .64593 -2.37764 .77254 Mabsadd L
.63542 .64593 -0.91448 -0.29713 Mabsadd L
.63542 .64593 -1.46946 -2.02254 Mabsadd L
.63542 .64593 0 -0.96154 Mabsadd L
.63542 .64593 1.46946 -2.02254 Mabsadd L
.63542 .64593 .91448 -0.29713 Mabsadd L
.63542 .64593 2.37764 .77254 Mabsadd L
.63542 .64593 .56518 .7779 Mabsadd L
.63542 .64593 0 2.5 Mabsadd L closepath F
.6369 .6474 0 2.5 Mabsadd m
.6369 .6474 -0.56518 .7779 Mabsadd L
.6369 .6474 -2.37764 .77254 Mabsadd L
.6369 .6474 -0.91448 -0.29713 Mabsadd L
.6369 .6474 -1.46946 -2.02254 Mabsadd L
.6369 .6474 0 -0.96154 Mabsadd L
.6369 .6474 1.46946 -2.02254 Mabsadd L
.6369 .6474 .91448 -0.29713 Mabsadd L
.6369 .6474 2.37764 .77254 Mabsadd L
.6369 .6474 .56518 .7779 Mabsadd L
.6369 .6474 0 2.5 Mabsadd L closepath F
.63839 .64888 0 2.5 Mabsadd m
.63839 .64888 -0.56518 .7779 Mabsadd L
.63839 .64888 -2.37764 .77254 Mabsadd L
.63839 .64888 -0.91448 -0.29713 Mabsadd L
.63839 .64888 -1.46946 -2.02254 Mabsadd L
.63839 .64888 0 -0.96154 Mabsadd L
.63839 .64888 1.46946 -2.02254 Mabsadd L
.63839 .64888 .91448 -0.29713 Mabsadd L
.63839 .64888 2.37764 .77254 Mabsadd L
.63839 .64888 .56518 .7779 Mabsadd L
.63839 .64888 0 2.5 Mabsadd L closepath F
.63988 .65036 0 2.5 Mabsadd m
.63988 .65036 -0.56518 .7779 Mabsadd L
.63988 .65036 -2.37764 .77254 Mabsadd L
.63988 .65036 -0.91448 -0.29713 Mabsadd L
.63988 .65036 -1.46946 -2.02254 Mabsadd L
.63988 .65036 0 -0.96154 Mabsadd L
.63988 .65036 1.46946 -2.02254 Mabsadd L
.63988 .65036 .91448 -0.29713 Mabsadd L
.63988 .65036 2.37764 .77254 Mabsadd L
.63988 .65036 .56518 .7779 Mabsadd L
.63988 .65036 0 2.5 Mabsadd L closepath F
.64137 .65184 0 2.5 Mabsadd m
.64137 .65184 -0.56518 .7779 Mabsadd L
.64137 .65184 -2.37764 .77254 Mabsadd L
.64137 .65184 -0.91448 -0.29713 Mabsadd L
.64137 .65184 -1.46946 -2.02254 Mabsadd L
.64137 .65184 0 -0.96154 Mabsadd L
.64137 .65184 1.46946 -2.02254 Mabsadd L
.64137 .65184 .91448 -0.29713 Mabsadd L
.64137 .65184 2.37764 .77254 Mabsadd L
.64137 .65184 .56518 .7779 Mabsadd L
.64137 .65184 0 2.5 Mabsadd L closepath F
.64286 .65332 0 2.5 Mabsadd m
.64286 .65332 -0.56518 .7779 Mabsadd L
.64286 .65332 -2.37764 .77254 Mabsadd L
.64286 .65332 -0.91448 -0.29713 Mabsadd L
.64286 .65332 -1.46946 -2.02254 Mabsadd L
.64286 .65332 0 -0.96154 Mabsadd L
.64286 .65332 1.46946 -2.02254 Mabsadd L
.64286 .65332 .91448 -0.29713 Mabsadd L
.64286 .65332 2.37764 .77254 Mabsadd L
.64286 .65332 .56518 .7779 Mabsadd L
.64286 .65332 0 2.5 Mabsadd L closepath F
.64435 .6548 0 2.5 Mabsadd m
.64435 .6548 -0.56518 .7779 Mabsadd L
.64435 .6548 -2.37764 .77254 Mabsadd L
.64435 .6548 -0.91448 -0.29713 Mabsadd L
.64435 .6548 -1.46946 -2.02254 Mabsadd L
.64435 .6548 0 -0.96154 Mabsadd L
.64435 .6548 1.46946 -2.02254 Mabsadd L
.64435 .6548 .91448 -0.29713 Mabsadd L
.64435 .6548 2.37764 .77254 Mabsadd L
.64435 .6548 .56518 .7779 Mabsadd L
.64435 .6548 0 2.5 Mabsadd L closepath F
.64583 .65628 0 2.5 Mabsadd m
.64583 .65628 -0.56518 .7779 Mabsadd L
.64583 .65628 -2.37764 .77254 Mabsadd L
.64583 .65628 -0.91448 -0.29713 Mabsadd L
.64583 .65628 -1.46946 -2.02254 Mabsadd L
.64583 .65628 0 -0.96154 Mabsadd L
.64583 .65628 1.46946 -2.02254 Mabsadd L
.64583 .65628 .91448 -0.29713 Mabsadd L
.64583 .65628 2.37764 .77254 Mabsadd L
.64583 .65628 .56518 .7779 Mabsadd L
.64583 .65628 0 2.5 Mabsadd L closepath F
.64732 .65775 0 2.5 Mabsadd m
.64732 .65775 -0.56518 .7779 Mabsadd L
.64732 .65775 -2.37764 .77254 Mabsadd L
.64732 .65775 -0.91448 -0.29713 Mabsadd L
.64732 .65775 -1.46946 -2.02254 Mabsadd L
.64732 .65775 0 -0.96154 Mabsadd L
.64732 .65775 1.46946 -2.02254 Mabsadd L
.64732 .65775 .91448 -0.29713 Mabsadd L
.64732 .65775 2.37764 .77254 Mabsadd L
.64732 .65775 .56518 .7779 Mabsadd L
.64732 .65775 0 2.5 Mabsadd L closepath F
.64881 .65923 0 2.5 Mabsadd m
.64881 .65923 -0.56518 .7779 Mabsadd L
.64881 .65923 -2.37764 .77254 Mabsadd L
.64881 .65923 -0.91448 -0.29713 Mabsadd L
.64881 .65923 -1.46946 -2.02254 Mabsadd L
.64881 .65923 0 -0.96154 Mabsadd L
.64881 .65923 1.46946 -2.02254 Mabsadd L
.64881 .65923 .91448 -0.29713 Mabsadd L
.64881 .65923 2.37764 .77254 Mabsadd L
.64881 .65923 .56518 .7779 Mabsadd L
.64881 .65923 0 2.5 Mabsadd L closepath F
.6503 .66071 0 2.5 Mabsadd m
.6503 .66071 -0.56518 .7779 Mabsadd L
.6503 .66071 -2.37764 .77254 Mabsadd L
.6503 .66071 -0.91448 -0.29713 Mabsadd L
.6503 .66071 -1.46946 -2.02254 Mabsadd L
.6503 .66071 0 -0.96154 Mabsadd L
.6503 .66071 1.46946 -2.02254 Mabsadd L
.6503 .66071 .91448 -0.29713 Mabsadd L
.6503 .66071 2.37764 .77254 Mabsadd L
.6503 .66071 .56518 .7779 Mabsadd L
.6503 .66071 0 2.5 Mabsadd L closepath F
.65179 .66218 0 2.5 Mabsadd m
.65179 .66218 -0.56518 .7779 Mabsadd L
.65179 .66218 -2.37764 .77254 Mabsadd L
.65179 .66218 -0.91448 -0.29713 Mabsadd L
.65179 .66218 -1.46946 -2.02254 Mabsadd L
.65179 .66218 0 -0.96154 Mabsadd L
.65179 .66218 1.46946 -2.02254 Mabsadd L
.65179 .66218 .91448 -0.29713 Mabsadd L
.65179 .66218 2.37764 .77254 Mabsadd L
.65179 .66218 .56518 .7779 Mabsadd L
.65179 .66218 0 2.5 Mabsadd L closepath F
.65327 .66366 0 2.5 Mabsadd m
.65327 .66366 -0.56518 .7779 Mabsadd L
.65327 .66366 -2.37764 .77254 Mabsadd L
.65327 .66366 -0.91448 -0.29713 Mabsadd L
.65327 .66366 -1.46946 -2.02254 Mabsadd L
.65327 .66366 0 -0.96154 Mabsadd L
.65327 .66366 1.46946 -2.02254 Mabsadd L
.65327 .66366 .91448 -0.29713 Mabsadd L
.65327 .66366 2.37764 .77254 Mabsadd L
.65327 .66366 .56518 .7779 Mabsadd L
.65327 .66366 0 2.5 Mabsadd L closepath F
.65476 .66514 0 2.5 Mabsadd m
.65476 .66514 -0.56518 .7779 Mabsadd L
.65476 .66514 -2.37764 .77254 Mabsadd L
.65476 .66514 -0.91448 -0.29713 Mabsadd L
.65476 .66514 -1.46946 -2.02254 Mabsadd L
.65476 .66514 0 -0.96154 Mabsadd L
.65476 .66514 1.46946 -2.02254 Mabsadd L
.65476 .66514 .91448 -0.29713 Mabsadd L
.65476 .66514 2.37764 .77254 Mabsadd L
.65476 .66514 .56518 .7779 Mabsadd L
.65476 .66514 0 2.5 Mabsadd L closepath F
.65625 .66661 0 2.5 Mabsadd m
.65625 .66661 -0.56518 .7779 Mabsadd L
.65625 .66661 -2.37764 .77254 Mabsadd L
.65625 .66661 -0.91448 -0.29713 Mabsadd L
.65625 .66661 -1.46946 -2.02254 Mabsadd L
.65625 .66661 0 -0.96154 Mabsadd L
.65625 .66661 1.46946 -2.02254 Mabsadd L
.65625 .66661 .91448 -0.29713 Mabsadd L
.65625 .66661 2.37764 .77254 Mabsadd L
.65625 .66661 .56518 .7779 Mabsadd L
.65625 .66661 0 2.5 Mabsadd L closepath F
.65774 .66809 0 2.5 Mabsadd m
.65774 .66809 -0.56518 .7779 Mabsadd L
.65774 .66809 -2.37764 .77254 Mabsadd L
.65774 .66809 -0.91448 -0.29713 Mabsadd L
.65774 .66809 -1.46946 -2.02254 Mabsadd L
.65774 .66809 0 -0.96154 Mabsadd L
.65774 .66809 1.46946 -2.02254 Mabsadd L
.65774 .66809 .91448 -0.29713 Mabsadd L
.65774 .66809 2.37764 .77254 Mabsadd L
.65774 .66809 .56518 .7779 Mabsadd L
.65774 .66809 0 2.5 Mabsadd L closepath F
.65923 .66956 0 2.5 Mabsadd m
.65923 .66956 -0.56518 .7779 Mabsadd L
.65923 .66956 -2.37764 .77254 Mabsadd L
.65923 .66956 -0.91448 -0.29713 Mabsadd L
.65923 .66956 -1.46946 -2.02254 Mabsadd L
.65923 .66956 0 -0.96154 Mabsadd L
.65923 .66956 1.46946 -2.02254 Mabsadd L
.65923 .66956 .91448 -0.29713 Mabsadd L
.65923 .66956 2.37764 .77254 Mabsadd L
.65923 .66956 .56518 .7779 Mabsadd L
.65923 .66956 0 2.5 Mabsadd L closepath F
.66071 .67104 0 2.5 Mabsadd m
.66071 .67104 -0.56518 .7779 Mabsadd L
.66071 .67104 -2.37764 .77254 Mabsadd L
.66071 .67104 -0.91448 -0.29713 Mabsadd L
.66071 .67104 -1.46946 -2.02254 Mabsadd L
.66071 .67104 0 -0.96154 Mabsadd L
.66071 .67104 1.46946 -2.02254 Mabsadd L
.66071 .67104 .91448 -0.29713 Mabsadd L
.66071 .67104 2.37764 .77254 Mabsadd L
.66071 .67104 .56518 .7779 Mabsadd L
.66071 .67104 0 2.5 Mabsadd L closepath F
.6622 .67251 0 2.5 Mabsadd m
.6622 .67251 -0.56518 .7779 Mabsadd L
.6622 .67251 -2.37764 .77254 Mabsadd L
.6622 .67251 -0.91448 -0.29713 Mabsadd L
.6622 .67251 -1.46946 -2.02254 Mabsadd L
.6622 .67251 0 -0.96154 Mabsadd L
.6622 .67251 1.46946 -2.02254 Mabsadd L
.6622 .67251 .91448 -0.29713 Mabsadd L
.6622 .67251 2.37764 .77254 Mabsadd L
.6622 .67251 .56518 .7779 Mabsadd L
.6622 .67251 0 2.5 Mabsadd L closepath F
.66369 .67399 0 2.5 Mabsadd m
.66369 .67399 -0.56518 .7779 Mabsadd L
.66369 .67399 -2.37764 .77254 Mabsadd L
.66369 .67399 -0.91448 -0.29713 Mabsadd L
.66369 .67399 -1.46946 -2.02254 Mabsadd L
.66369 .67399 0 -0.96154 Mabsadd L
.66369 .67399 1.46946 -2.02254 Mabsadd L
.66369 .67399 .91448 -0.29713 Mabsadd L
.66369 .67399 2.37764 .77254 Mabsadd L
.66369 .67399 .56518 .7779 Mabsadd L
.66369 .67399 0 2.5 Mabsadd L closepath F
.66518 .67546 0 2.5 Mabsadd m
.66518 .67546 -0.56518 .7779 Mabsadd L
.66518 .67546 -2.37764 .77254 Mabsadd L
.66518 .67546 -0.91448 -0.29713 Mabsadd L
.66518 .67546 -1.46946 -2.02254 Mabsadd L
.66518 .67546 0 -0.96154 Mabsadd L
.66518 .67546 1.46946 -2.02254 Mabsadd L
.66518 .67546 .91448 -0.29713 Mabsadd L
.66518 .67546 2.37764 .77254 Mabsadd L
.66518 .67546 .56518 .7779 Mabsadd L
.66518 .67546 0 2.5 Mabsadd L closepath F
.66667 .67693 0 2.5 Mabsadd m
.66667 .67693 -0.56518 .7779 Mabsadd L
.66667 .67693 -2.37764 .77254 Mabsadd L
.66667 .67693 -0.91448 -0.29713 Mabsadd L
.66667 .67693 -1.46946 -2.02254 Mabsadd L
.66667 .67693 0 -0.96154 Mabsadd L
.66667 .67693 1.46946 -2.02254 Mabsadd L
.66667 .67693 .91448 -0.29713 Mabsadd L
.66667 .67693 2.37764 .77254 Mabsadd L
.66667 .67693 .56518 .7779 Mabsadd L
.66667 .67693 0 2.5 Mabsadd L closepath F
.66815 .67841 0 2.5 Mabsadd m
.66815 .67841 -0.56518 .7779 Mabsadd L
.66815 .67841 -2.37764 .77254 Mabsadd L
.66815 .67841 -0.91448 -0.29713 Mabsadd L
.66815 .67841 -1.46946 -2.02254 Mabsadd L
.66815 .67841 0 -0.96154 Mabsadd L
.66815 .67841 1.46946 -2.02254 Mabsadd L
.66815 .67841 .91448 -0.29713 Mabsadd L
.66815 .67841 2.37764 .77254 Mabsadd L
.66815 .67841 .56518 .7779 Mabsadd L
.66815 .67841 0 2.5 Mabsadd L closepath F
.66964 .67988 0 2.5 Mabsadd m
.66964 .67988 -0.56518 .7779 Mabsadd L
.66964 .67988 -2.37764 .77254 Mabsadd L
.66964 .67988 -0.91448 -0.29713 Mabsadd L
.66964 .67988 -1.46946 -2.02254 Mabsadd L
.66964 .67988 0 -0.96154 Mabsadd L
.66964 .67988 1.46946 -2.02254 Mabsadd L
.66964 .67988 .91448 -0.29713 Mabsadd L
.66964 .67988 2.37764 .77254 Mabsadd L
.66964 .67988 .56518 .7779 Mabsadd L
.66964 .67988 0 2.5 Mabsadd L closepath F
.67113 .68135 0 2.5 Mabsadd m
.67113 .68135 -0.56518 .7779 Mabsadd L
.67113 .68135 -2.37764 .77254 Mabsadd L
.67113 .68135 -0.91448 -0.29713 Mabsadd L
.67113 .68135 -1.46946 -2.02254 Mabsadd L
.67113 .68135 0 -0.96154 Mabsadd L
.67113 .68135 1.46946 -2.02254 Mabsadd L
.67113 .68135 .91448 -0.29713 Mabsadd L
.67113 .68135 2.37764 .77254 Mabsadd L
.67113 .68135 .56518 .7779 Mabsadd L
.67113 .68135 0 2.5 Mabsadd L closepath F
.67262 .68283 0 2.5 Mabsadd m
.67262 .68283 -0.56518 .7779 Mabsadd L
.67262 .68283 -2.37764 .77254 Mabsadd L
.67262 .68283 -0.91448 -0.29713 Mabsadd L
.67262 .68283 -1.46946 -2.02254 Mabsadd L
.67262 .68283 0 -0.96154 Mabsadd L
.67262 .68283 1.46946 -2.02254 Mabsadd L
.67262 .68283 .91448 -0.29713 Mabsadd L
.67262 .68283 2.37764 .77254 Mabsadd L
.67262 .68283 .56518 .7779 Mabsadd L
.67262 .68283 0 2.5 Mabsadd L closepath F
.67411 .6843 0 2.5 Mabsadd m
.67411 .6843 -0.56518 .7779 Mabsadd L
.67411 .6843 -2.37764 .77254 Mabsadd L
.67411 .6843 -0.91448 -0.29713 Mabsadd L
.67411 .6843 -1.46946 -2.02254 Mabsadd L
.67411 .6843 0 -0.96154 Mabsadd L
.67411 .6843 1.46946 -2.02254 Mabsadd L
.67411 .6843 .91448 -0.29713 Mabsadd L
.67411 .6843 2.37764 .77254 Mabsadd L
.67411 .6843 .56518 .7779 Mabsadd L
.67411 .6843 0 2.5 Mabsadd L closepath F
.6756 .68577 0 2.5 Mabsadd m
.6756 .68577 -0.56518 .7779 Mabsadd L
.6756 .68577 -2.37764 .77254 Mabsadd L
.6756 .68577 -0.91448 -0.29713 Mabsadd L
.6756 .68577 -1.46946 -2.02254 Mabsadd L
.6756 .68577 0 -0.96154 Mabsadd L
.6756 .68577 1.46946 -2.02254 Mabsadd L
.6756 .68577 .91448 -0.29713 Mabsadd L
.6756 .68577 2.37764 .77254 Mabsadd L
.6756 .68577 .56518 .7779 Mabsadd L
.6756 .68577 0 2.5 Mabsadd L closepath F
.67708 .68724 0 2.5 Mabsadd m
.67708 .68724 -0.56518 .7779 Mabsadd L
.67708 .68724 -2.37764 .77254 Mabsadd L
.67708 .68724 -0.91448 -0.29713 Mabsadd L
.67708 .68724 -1.46946 -2.02254 Mabsadd L
.67708 .68724 0 -0.96154 Mabsadd L
.67708 .68724 1.46946 -2.02254 Mabsadd L
.67708 .68724 .91448 -0.29713 Mabsadd L
.67708 .68724 2.37764 .77254 Mabsadd L
.67708 .68724 .56518 .7779 Mabsadd L
.67708 .68724 0 2.5 Mabsadd L closepath F
.67857 .68872 0 2.5 Mabsadd m
.67857 .68872 -0.56518 .7779 Mabsadd L
.67857 .68872 -2.37764 .77254 Mabsadd L
.67857 .68872 -0.91448 -0.29713 Mabsadd L
.67857 .68872 -1.46946 -2.02254 Mabsadd L
.67857 .68872 0 -0.96154 Mabsadd L
.67857 .68872 1.46946 -2.02254 Mabsadd L
.67857 .68872 .91448 -0.29713 Mabsadd L
.67857 .68872 2.37764 .77254 Mabsadd L
.67857 .68872 .56518 .7779 Mabsadd L
.67857 .68872 0 2.5 Mabsadd L closepath F
.68006 .69019 0 2.5 Mabsadd m
.68006 .69019 -0.56518 .7779 Mabsadd L
.68006 .69019 -2.37764 .77254 Mabsadd L
.68006 .69019 -0.91448 -0.29713 Mabsadd L
.68006 .69019 -1.46946 -2.02254 Mabsadd L
.68006 .69019 0 -0.96154 Mabsadd L
.68006 .69019 1.46946 -2.02254 Mabsadd L
.68006 .69019 .91448 -0.29713 Mabsadd L
.68006 .69019 2.37764 .77254 Mabsadd L
.68006 .69019 .56518 .7779 Mabsadd L
.68006 .69019 0 2.5 Mabsadd L closepath F
.68155 .69166 0 2.5 Mabsadd m
.68155 .69166 -0.56518 .7779 Mabsadd L
.68155 .69166 -2.37764 .77254 Mabsadd L
.68155 .69166 -0.91448 -0.29713 Mabsadd L
.68155 .69166 -1.46946 -2.02254 Mabsadd L
.68155 .69166 0 -0.96154 Mabsadd L
.68155 .69166 1.46946 -2.02254 Mabsadd L
.68155 .69166 .91448 -0.29713 Mabsadd L
.68155 .69166 2.37764 .77254 Mabsadd L
.68155 .69166 .56518 .7779 Mabsadd L
.68155 .69166 0 2.5 Mabsadd L closepath F
.68304 .69313 0 2.5 Mabsadd m
.68304 .69313 -0.56518 .7779 Mabsadd L
.68304 .69313 -2.37764 .77254 Mabsadd L
.68304 .69313 -0.91448 -0.29713 Mabsadd L
.68304 .69313 -1.46946 -2.02254 Mabsadd L
.68304 .69313 0 -0.96154 Mabsadd L
.68304 .69313 1.46946 -2.02254 Mabsadd L
.68304 .69313 .91448 -0.29713 Mabsadd L
.68304 .69313 2.37764 .77254 Mabsadd L
.68304 .69313 .56518 .7779 Mabsadd L
.68304 .69313 0 2.5 Mabsadd L closepath F
.68452 .6946 0 2.5 Mabsadd m
.68452 .6946 -0.56518 .7779 Mabsadd L
.68452 .6946 -2.37764 .77254 Mabsadd L
.68452 .6946 -0.91448 -0.29713 Mabsadd L
.68452 .6946 -1.46946 -2.02254 Mabsadd L
.68452 .6946 0 -0.96154 Mabsadd L
.68452 .6946 1.46946 -2.02254 Mabsadd L
.68452 .6946 .91448 -0.29713 Mabsadd L
.68452 .6946 2.37764 .77254 Mabsadd L
.68452 .6946 .56518 .7779 Mabsadd L
.68452 .6946 0 2.5 Mabsadd L closepath F
.68601 .69607 0 2.5 Mabsadd m
.68601 .69607 -0.56518 .7779 Mabsadd L
.68601 .69607 -2.37764 .77254 Mabsadd L
.68601 .69607 -0.91448 -0.29713 Mabsadd L
.68601 .69607 -1.46946 -2.02254 Mabsadd L
.68601 .69607 0 -0.96154 Mabsadd L
.68601 .69607 1.46946 -2.02254 Mabsadd L
.68601 .69607 .91448 -0.29713 Mabsadd L
.68601 .69607 2.37764 .77254 Mabsadd L
.68601 .69607 .56518 .7779 Mabsadd L
.68601 .69607 0 2.5 Mabsadd L closepath F
.6875 .69754 0 2.5 Mabsadd m
.6875 .69754 -0.56518 .7779 Mabsadd L
.6875 .69754 -2.37764 .77254 Mabsadd L
.6875 .69754 -0.91448 -0.29713 Mabsadd L
.6875 .69754 -1.46946 -2.02254 Mabsadd L
.6875 .69754 0 -0.96154 Mabsadd L
.6875 .69754 1.46946 -2.02254 Mabsadd L
.6875 .69754 .91448 -0.29713 Mabsadd L
.6875 .69754 2.37764 .77254 Mabsadd L
.6875 .69754 .56518 .7779 Mabsadd L
.6875 .69754 0 2.5 Mabsadd L closepath F
.68899 .69901 0 2.5 Mabsadd m
.68899 .69901 -0.56518 .7779 Mabsadd L
.68899 .69901 -2.37764 .77254 Mabsadd L
.68899 .69901 -0.91448 -0.29713 Mabsadd L
.68899 .69901 -1.46946 -2.02254 Mabsadd L
.68899 .69901 0 -0.96154 Mabsadd L
.68899 .69901 1.46946 -2.02254 Mabsadd L
.68899 .69901 .91448 -0.29713 Mabsadd L
.68899 .69901 2.37764 .77254 Mabsadd L
.68899 .69901 .56518 .7779 Mabsadd L
.68899 .69901 0 2.5 Mabsadd L closepath F
.69048 .70048 0 2.5 Mabsadd m
.69048 .70048 -0.56518 .7779 Mabsadd L
.69048 .70048 -2.37764 .77254 Mabsadd L
.69048 .70048 -0.91448 -0.29713 Mabsadd L
.69048 .70048 -1.46946 -2.02254 Mabsadd L
.69048 .70048 0 -0.96154 Mabsadd L
.69048 .70048 1.46946 -2.02254 Mabsadd L
.69048 .70048 .91448 -0.29713 Mabsadd L
.69048 .70048 2.37764 .77254 Mabsadd L
.69048 .70048 .56518 .7779 Mabsadd L
.69048 .70048 0 2.5 Mabsadd L closepath F
.69196 .70195 0 2.5 Mabsadd m
.69196 .70195 -0.56518 .7779 Mabsadd L
.69196 .70195 -2.37764 .77254 Mabsadd L
.69196 .70195 -0.91448 -0.29713 Mabsadd L
.69196 .70195 -1.46946 -2.02254 Mabsadd L
.69196 .70195 0 -0.96154 Mabsadd L
.69196 .70195 1.46946 -2.02254 Mabsadd L
.69196 .70195 .91448 -0.29713 Mabsadd L
.69196 .70195 2.37764 .77254 Mabsadd L
.69196 .70195 .56518 .7779 Mabsadd L
.69196 .70195 0 2.5 Mabsadd L closepath F
.69345 .70342 0 2.5 Mabsadd m
.69345 .70342 -0.56518 .7779 Mabsadd L
.69345 .70342 -2.37764 .77254 Mabsadd L
.69345 .70342 -0.91448 -0.29713 Mabsadd L
.69345 .70342 -1.46946 -2.02254 Mabsadd L
.69345 .70342 0 -0.96154 Mabsadd L
.69345 .70342 1.46946 -2.02254 Mabsadd L
.69345 .70342 .91448 -0.29713 Mabsadd L
.69345 .70342 2.37764 .77254 Mabsadd L
.69345 .70342 .56518 .7779 Mabsadd L
.69345 .70342 0 2.5 Mabsadd L closepath F
.69494 .70489 0 2.5 Mabsadd m
.69494 .70489 -0.56518 .7779 Mabsadd L
.69494 .70489 -2.37764 .77254 Mabsadd L
.69494 .70489 -0.91448 -0.29713 Mabsadd L
.69494 .70489 -1.46946 -2.02254 Mabsadd L
.69494 .70489 0 -0.96154 Mabsadd L
.69494 .70489 1.46946 -2.02254 Mabsadd L
.69494 .70489 .91448 -0.29713 Mabsadd L
.69494 .70489 2.37764 .77254 Mabsadd L
.69494 .70489 .56518 .7779 Mabsadd L
.69494 .70489 0 2.5 Mabsadd L closepath F
.69643 .70635 0 2.5 Mabsadd m
.69643 .70635 -0.56518 .7779 Mabsadd L
.69643 .70635 -2.37764 .77254 Mabsadd L
.69643 .70635 -0.91448 -0.29713 Mabsadd L
.69643 .70635 -1.46946 -2.02254 Mabsadd L
.69643 .70635 0 -0.96154 Mabsadd L
.69643 .70635 1.46946 -2.02254 Mabsadd L
.69643 .70635 .91448 -0.29713 Mabsadd L
.69643 .70635 2.37764 .77254 Mabsadd L
.69643 .70635 .56518 .7779 Mabsadd L
.69643 .70635 0 2.5 Mabsadd L closepath F
.69792 .70782 0 2.5 Mabsadd m
.69792 .70782 -0.56518 .7779 Mabsadd L
.69792 .70782 -2.37764 .77254 Mabsadd L
.69792 .70782 -0.91448 -0.29713 Mabsadd L
.69792 .70782 -1.46946 -2.02254 Mabsadd L
.69792 .70782 0 -0.96154 Mabsadd L
.69792 .70782 1.46946 -2.02254 Mabsadd L
.69792 .70782 .91448 -0.29713 Mabsadd L
.69792 .70782 2.37764 .77254 Mabsadd L
.69792 .70782 .56518 .7779 Mabsadd L
.69792 .70782 0 2.5 Mabsadd L closepath F
.6994 .70929 0 2.5 Mabsadd m
.6994 .70929 -0.56518 .7779 Mabsadd L
.6994 .70929 -2.37764 .77254 Mabsadd L
.6994 .70929 -0.91448 -0.29713 Mabsadd L
.6994 .70929 -1.46946 -2.02254 Mabsadd L
.6994 .70929 0 -0.96154 Mabsadd L
.6994 .70929 1.46946 -2.02254 Mabsadd L
.6994 .70929 .91448 -0.29713 Mabsadd L
.6994 .70929 2.37764 .77254 Mabsadd L
.6994 .70929 .56518 .7779 Mabsadd L
.6994 .70929 0 2.5 Mabsadd L closepath F
.70089 .71076 0 2.5 Mabsadd m
.70089 .71076 -0.56518 .7779 Mabsadd L
.70089 .71076 -2.37764 .77254 Mabsadd L
.70089 .71076 -0.91448 -0.29713 Mabsadd L
.70089 .71076 -1.46946 -2.02254 Mabsadd L
.70089 .71076 0 -0.96154 Mabsadd L
.70089 .71076 1.46946 -2.02254 Mabsadd L
.70089 .71076 .91448 -0.29713 Mabsadd L
.70089 .71076 2.37764 .77254 Mabsadd L
.70089 .71076 .56518 .7779 Mabsadd L
.70089 .71076 0 2.5 Mabsadd L closepath F
.70238 .71222 0 2.5 Mabsadd m
.70238 .71222 -0.56518 .7779 Mabsadd L
.70238 .71222 -2.37764 .77254 Mabsadd L
.70238 .71222 -0.91448 -0.29713 Mabsadd L
.70238 .71222 -1.46946 -2.02254 Mabsadd L
.70238 .71222 0 -0.96154 Mabsadd L
.70238 .71222 1.46946 -2.02254 Mabsadd L
.70238 .71222 .91448 -0.29713 Mabsadd L
.70238 .71222 2.37764 .77254 Mabsadd L
.70238 .71222 .56518 .7779 Mabsadd L
.70238 .71222 0 2.5 Mabsadd L closepath F
.70387 .71369 0 2.5 Mabsadd m
.70387 .71369 -0.56518 .7779 Mabsadd L
.70387 .71369 -2.37764 .77254 Mabsadd L
.70387 .71369 -0.91448 -0.29713 Mabsadd L
.70387 .71369 -1.46946 -2.02254 Mabsadd L
.70387 .71369 0 -0.96154 Mabsadd L
.70387 .71369 1.46946 -2.02254 Mabsadd L
.70387 .71369 .91448 -0.29713 Mabsadd L
.70387 .71369 2.37764 .77254 Mabsadd L
.70387 .71369 .56518 .7779 Mabsadd L
.70387 .71369 0 2.5 Mabsadd L closepath F
.70536 .71516 0 2.5 Mabsadd m
.70536 .71516 -0.56518 .7779 Mabsadd L
.70536 .71516 -2.37764 .77254 Mabsadd L
.70536 .71516 -0.91448 -0.29713 Mabsadd L
.70536 .71516 -1.46946 -2.02254 Mabsadd L
.70536 .71516 0 -0.96154 Mabsadd L
.70536 .71516 1.46946 -2.02254 Mabsadd L
.70536 .71516 .91448 -0.29713 Mabsadd L
.70536 .71516 2.37764 .77254 Mabsadd L
.70536 .71516 .56518 .7779 Mabsadd L
.70536 .71516 0 2.5 Mabsadd L closepath F
.70685 .71662 0 2.5 Mabsadd m
.70685 .71662 -0.56518 .7779 Mabsadd L
.70685 .71662 -2.37764 .77254 Mabsadd L
.70685 .71662 -0.91448 -0.29713 Mabsadd L
.70685 .71662 -1.46946 -2.02254 Mabsadd L
.70685 .71662 0 -0.96154 Mabsadd L
.70685 .71662 1.46946 -2.02254 Mabsadd L
.70685 .71662 .91448 -0.29713 Mabsadd L
.70685 .71662 2.37764 .77254 Mabsadd L
.70685 .71662 .56518 .7779 Mabsadd L
.70685 .71662 0 2.5 Mabsadd L closepath F
.70833 .71809 0 2.5 Mabsadd m
.70833 .71809 -0.56518 .7779 Mabsadd L
.70833 .71809 -2.37764 .77254 Mabsadd L
.70833 .71809 -0.91448 -0.29713 Mabsadd L
.70833 .71809 -1.46946 -2.02254 Mabsadd L
.70833 .71809 0 -0.96154 Mabsadd L
.70833 .71809 1.46946 -2.02254 Mabsadd L
.70833 .71809 .91448 -0.29713 Mabsadd L
.70833 .71809 2.37764 .77254 Mabsadd L
.70833 .71809 .56518 .7779 Mabsadd L
.70833 .71809 0 2.5 Mabsadd L closepath F
.70982 .71956 0 2.5 Mabsadd m
.70982 .71956 -0.56518 .7779 Mabsadd L
.70982 .71956 -2.37764 .77254 Mabsadd L
.70982 .71956 -0.91448 -0.29713 Mabsadd L
.70982 .71956 -1.46946 -2.02254 Mabsadd L
.70982 .71956 0 -0.96154 Mabsadd L
.70982 .71956 1.46946 -2.02254 Mabsadd L
.70982 .71956 .91448 -0.29713 Mabsadd L
.70982 .71956 2.37764 .77254 Mabsadd L
.70982 .71956 .56518 .7779 Mabsadd L
.70982 .71956 0 2.5 Mabsadd L closepath F
.71131 .72102 0 2.5 Mabsadd m
.71131 .72102 -0.56518 .7779 Mabsadd L
.71131 .72102 -2.37764 .77254 Mabsadd L
.71131 .72102 -0.91448 -0.29713 Mabsadd L
.71131 .72102 -1.46946 -2.02254 Mabsadd L
.71131 .72102 0 -0.96154 Mabsadd L
.71131 .72102 1.46946 -2.02254 Mabsadd L
.71131 .72102 .91448 -0.29713 Mabsadd L
.71131 .72102 2.37764 .77254 Mabsadd L
.71131 .72102 .56518 .7779 Mabsadd L
.71131 .72102 0 2.5 Mabsadd L closepath F
.7128 .72249 0 2.5 Mabsadd m
.7128 .72249 -0.56518 .7779 Mabsadd L
.7128 .72249 -2.37764 .77254 Mabsadd L
.7128 .72249 -0.91448 -0.29713 Mabsadd L
.7128 .72249 -1.46946 -2.02254 Mabsadd L
.7128 .72249 0 -0.96154 Mabsadd L
.7128 .72249 1.46946 -2.02254 Mabsadd L
.7128 .72249 .91448 -0.29713 Mabsadd L
.7128 .72249 2.37764 .77254 Mabsadd L
.7128 .72249 .56518 .7779 Mabsadd L
.7128 .72249 0 2.5 Mabsadd L closepath F
.71429 .72395 0 2.5 Mabsadd m
.71429 .72395 -0.56518 .7779 Mabsadd L
.71429 .72395 -2.37764 .77254 Mabsadd L
.71429 .72395 -0.91448 -0.29713 Mabsadd L
.71429 .72395 -1.46946 -2.02254 Mabsadd L
.71429 .72395 0 -0.96154 Mabsadd L
.71429 .72395 1.46946 -2.02254 Mabsadd L
.71429 .72395 .91448 -0.29713 Mabsadd L
.71429 .72395 2.37764 .77254 Mabsadd L
.71429 .72395 .56518 .7779 Mabsadd L
.71429 .72395 0 2.5 Mabsadd L closepath F
.71577 .72542 0 2.5 Mabsadd m
.71577 .72542 -0.56518 .7779 Mabsadd L
.71577 .72542 -2.37764 .77254 Mabsadd L
.71577 .72542 -0.91448 -0.29713 Mabsadd L
.71577 .72542 -1.46946 -2.02254 Mabsadd L
.71577 .72542 0 -0.96154 Mabsadd L
.71577 .72542 1.46946 -2.02254 Mabsadd L
.71577 .72542 .91448 -0.29713 Mabsadd L
.71577 .72542 2.37764 .77254 Mabsadd L
.71577 .72542 .56518 .7779 Mabsadd L
.71577 .72542 0 2.5 Mabsadd L closepath F
.71726 .72688 0 2.5 Mabsadd m
.71726 .72688 -0.56518 .7779 Mabsadd L
.71726 .72688 -2.37764 .77254 Mabsadd L
.71726 .72688 -0.91448 -0.29713 Mabsadd L
.71726 .72688 -1.46946 -2.02254 Mabsadd L
.71726 .72688 0 -0.96154 Mabsadd L
.71726 .72688 1.46946 -2.02254 Mabsadd L
.71726 .72688 .91448 -0.29713 Mabsadd L
.71726 .72688 2.37764 .77254 Mabsadd L
.71726 .72688 .56518 .7779 Mabsadd L
.71726 .72688 0 2.5 Mabsadd L closepath F
.71875 .72835 0 2.5 Mabsadd m
.71875 .72835 -0.56518 .7779 Mabsadd L
.71875 .72835 -2.37764 .77254 Mabsadd L
.71875 .72835 -0.91448 -0.29713 Mabsadd L
.71875 .72835 -1.46946 -2.02254 Mabsadd L
.71875 .72835 0 -0.96154 Mabsadd L
.71875 .72835 1.46946 -2.02254 Mabsadd L
.71875 .72835 .91448 -0.29713 Mabsadd L
.71875 .72835 2.37764 .77254 Mabsadd L
.71875 .72835 .56518 .7779 Mabsadd L
.71875 .72835 0 2.5 Mabsadd L closepath F
.72024 .72981 0 2.5 Mabsadd m
.72024 .72981 -0.56518 .7779 Mabsadd L
.72024 .72981 -2.37764 .77254 Mabsadd L
.72024 .72981 -0.91448 -0.29713 Mabsadd L
.72024 .72981 -1.46946 -2.02254 Mabsadd L
.72024 .72981 0 -0.96154 Mabsadd L
.72024 .72981 1.46946 -2.02254 Mabsadd L
.72024 .72981 .91448 -0.29713 Mabsadd L
.72024 .72981 2.37764 .77254 Mabsadd L
.72024 .72981 .56518 .7779 Mabsadd L
.72024 .72981 0 2.5 Mabsadd L closepath F
.72173 .73127 0 2.5 Mabsadd m
.72173 .73127 -0.56518 .7779 Mabsadd L
.72173 .73127 -2.37764 .77254 Mabsadd L
.72173 .73127 -0.91448 -0.29713 Mabsadd L
.72173 .73127 -1.46946 -2.02254 Mabsadd L
.72173 .73127 0 -0.96154 Mabsadd L
.72173 .73127 1.46946 -2.02254 Mabsadd L
.72173 .73127 .91448 -0.29713 Mabsadd L
.72173 .73127 2.37764 .77254 Mabsadd L
.72173 .73127 .56518 .7779 Mabsadd L
.72173 .73127 0 2.5 Mabsadd L closepath F
.72321 .73274 0 2.5 Mabsadd m
.72321 .73274 -0.56518 .7779 Mabsadd L
.72321 .73274 -2.37764 .77254 Mabsadd L
.72321 .73274 -0.91448 -0.29713 Mabsadd L
.72321 .73274 -1.46946 -2.02254 Mabsadd L
.72321 .73274 0 -0.96154 Mabsadd L
.72321 .73274 1.46946 -2.02254 Mabsadd L
.72321 .73274 .91448 -0.29713 Mabsadd L
.72321 .73274 2.37764 .77254 Mabsadd L
.72321 .73274 .56518 .7779 Mabsadd L
.72321 .73274 0 2.5 Mabsadd L closepath F
.7247 .7342 0 2.5 Mabsadd m
.7247 .7342 -0.56518 .7779 Mabsadd L
.7247 .7342 -2.37764 .77254 Mabsadd L
.7247 .7342 -0.91448 -0.29713 Mabsadd L
.7247 .7342 -1.46946 -2.02254 Mabsadd L
.7247 .7342 0 -0.96154 Mabsadd L
.7247 .7342 1.46946 -2.02254 Mabsadd L
.7247 .7342 .91448 -0.29713 Mabsadd L
.7247 .7342 2.37764 .77254 Mabsadd L
.7247 .7342 .56518 .7779 Mabsadd L
.7247 .7342 0 2.5 Mabsadd L closepath F
.72619 .73566 0 2.5 Mabsadd m
.72619 .73566 -0.56518 .7779 Mabsadd L
.72619 .73566 -2.37764 .77254 Mabsadd L
.72619 .73566 -0.91448 -0.29713 Mabsadd L
.72619 .73566 -1.46946 -2.02254 Mabsadd L
.72619 .73566 0 -0.96154 Mabsadd L
.72619 .73566 1.46946 -2.02254 Mabsadd L
.72619 .73566 .91448 -0.29713 Mabsadd L
.72619 .73566 2.37764 .77254 Mabsadd L
.72619 .73566 .56518 .7779 Mabsadd L
.72619 .73566 0 2.5 Mabsadd L closepath F
.72768 .73713 0 2.5 Mabsadd m
.72768 .73713 -0.56518 .7779 Mabsadd L
.72768 .73713 -2.37764 .77254 Mabsadd L
.72768 .73713 -0.91448 -0.29713 Mabsadd L
.72768 .73713 -1.46946 -2.02254 Mabsadd L
.72768 .73713 0 -0.96154 Mabsadd L
.72768 .73713 1.46946 -2.02254 Mabsadd L
.72768 .73713 .91448 -0.29713 Mabsadd L
.72768 .73713 2.37764 .77254 Mabsadd L
.72768 .73713 .56518 .7779 Mabsadd L
.72768 .73713 0 2.5 Mabsadd L closepath F
.72917 .73859 0 2.5 Mabsadd m
.72917 .73859 -0.56518 .7779 Mabsadd L
.72917 .73859 -2.37764 .77254 Mabsadd L
.72917 .73859 -0.91448 -0.29713 Mabsadd L
.72917 .73859 -1.46946 -2.02254 Mabsadd L
.72917 .73859 0 -0.96154 Mabsadd L
.72917 .73859 1.46946 -2.02254 Mabsadd L
.72917 .73859 .91448 -0.29713 Mabsadd L
.72917 .73859 2.37764 .77254 Mabsadd L
.72917 .73859 .56518 .7779 Mabsadd L
.72917 .73859 0 2.5 Mabsadd L closepath F
.73065 .74005 0 2.5 Mabsadd m
.73065 .74005 -0.56518 .7779 Mabsadd L
.73065 .74005 -2.37764 .77254 Mabsadd L
.73065 .74005 -0.91448 -0.29713 Mabsadd L
.73065 .74005 -1.46946 -2.02254 Mabsadd L
.73065 .74005 0 -0.96154 Mabsadd L
.73065 .74005 1.46946 -2.02254 Mabsadd L
.73065 .74005 .91448 -0.29713 Mabsadd L
.73065 .74005 2.37764 .77254 Mabsadd L
.73065 .74005 .56518 .7779 Mabsadd L
.73065 .74005 0 2.5 Mabsadd L closepath F
.73214 .74151 0 2.5 Mabsadd m
.73214 .74151 -0.56518 .7779 Mabsadd L
.73214 .74151 -2.37764 .77254 Mabsadd L
.73214 .74151 -0.91448 -0.29713 Mabsadd L
.73214 .74151 -1.46946 -2.02254 Mabsadd L
.73214 .74151 0 -0.96154 Mabsadd L
.73214 .74151 1.46946 -2.02254 Mabsadd L
.73214 .74151 .91448 -0.29713 Mabsadd L
.73214 .74151 2.37764 .77254 Mabsadd L
.73214 .74151 .56518 .7779 Mabsadd L
.73214 .74151 0 2.5 Mabsadd L closepath F
.73363 .74297 0 2.5 Mabsadd m
.73363 .74297 -0.56518 .7779 Mabsadd L
.73363 .74297 -2.37764 .77254 Mabsadd L
.73363 .74297 -0.91448 -0.29713 Mabsadd L
.73363 .74297 -1.46946 -2.02254 Mabsadd L
.73363 .74297 0 -0.96154 Mabsadd L
.73363 .74297 1.46946 -2.02254 Mabsadd L
.73363 .74297 .91448 -0.29713 Mabsadd L
.73363 .74297 2.37764 .77254 Mabsadd L
.73363 .74297 .56518 .7779 Mabsadd L
.73363 .74297 0 2.5 Mabsadd L closepath F
.73512 .74443 0 2.5 Mabsadd m
.73512 .74443 -0.56518 .7779 Mabsadd L
.73512 .74443 -2.37764 .77254 Mabsadd L
.73512 .74443 -0.91448 -0.29713 Mabsadd L
.73512 .74443 -1.46946 -2.02254 Mabsadd L
.73512 .74443 0 -0.96154 Mabsadd L
.73512 .74443 1.46946 -2.02254 Mabsadd L
.73512 .74443 .91448 -0.29713 Mabsadd L
.73512 .74443 2.37764 .77254 Mabsadd L
.73512 .74443 .56518 .7779 Mabsadd L
.73512 .74443 0 2.5 Mabsadd L closepath F
.73661 .7459 0 2.5 Mabsadd m
.73661 .7459 -0.56518 .7779 Mabsadd L
.73661 .7459 -2.37764 .77254 Mabsadd L
.73661 .7459 -0.91448 -0.29713 Mabsadd L
.73661 .7459 -1.46946 -2.02254 Mabsadd L
.73661 .7459 0 -0.96154 Mabsadd L
.73661 .7459 1.46946 -2.02254 Mabsadd L
.73661 .7459 .91448 -0.29713 Mabsadd L
.73661 .7459 2.37764 .77254 Mabsadd L
.73661 .7459 .56518 .7779 Mabsadd L
.73661 .7459 0 2.5 Mabsadd L closepath F
.7381 .74736 0 2.5 Mabsadd m
.7381 .74736 -0.56518 .7779 Mabsadd L
.7381 .74736 -2.37764 .77254 Mabsadd L
.7381 .74736 -0.91448 -0.29713 Mabsadd L
.7381 .74736 -1.46946 -2.02254 Mabsadd L
.7381 .74736 0 -0.96154 Mabsadd L
.7381 .74736 1.46946 -2.02254 Mabsadd L
.7381 .74736 .91448 -0.29713 Mabsadd L
.7381 .74736 2.37764 .77254 Mabsadd L
.7381 .74736 .56518 .7779 Mabsadd L
.7381 .74736 0 2.5 Mabsadd L closepath F
.73958 .74882 0 2.5 Mabsadd m
.73958 .74882 -0.56518 .7779 Mabsadd L
.73958 .74882 -2.37764 .77254 Mabsadd L
.73958 .74882 -0.91448 -0.29713 Mabsadd L
.73958 .74882 -1.46946 -2.02254 Mabsadd L
.73958 .74882 0 -0.96154 Mabsadd L
.73958 .74882 1.46946 -2.02254 Mabsadd L
.73958 .74882 .91448 -0.29713 Mabsadd L
.73958 .74882 2.37764 .77254 Mabsadd L
.73958 .74882 .56518 .7779 Mabsadd L
.73958 .74882 0 2.5 Mabsadd L closepath F
.74107 .75028 0 2.5 Mabsadd m
.74107 .75028 -0.56518 .7779 Mabsadd L
.74107 .75028 -2.37764 .77254 Mabsadd L
.74107 .75028 -0.91448 -0.29713 Mabsadd L
.74107 .75028 -1.46946 -2.02254 Mabsadd L
.74107 .75028 0 -0.96154 Mabsadd L
.74107 .75028 1.46946 -2.02254 Mabsadd L
.74107 .75028 .91448 -0.29713 Mabsadd L
.74107 .75028 2.37764 .77254 Mabsadd L
.74107 .75028 .56518 .7779 Mabsadd L
.74107 .75028 0 2.5 Mabsadd L closepath F
.74256 .75174 0 2.5 Mabsadd m
.74256 .75174 -0.56518 .7779 Mabsadd L
.74256 .75174 -2.37764 .77254 Mabsadd L
.74256 .75174 -0.91448 -0.29713 Mabsadd L
.74256 .75174 -1.46946 -2.02254 Mabsadd L
.74256 .75174 0 -0.96154 Mabsadd L
.74256 .75174 1.46946 -2.02254 Mabsadd L
.74256 .75174 .91448 -0.29713 Mabsadd L
.74256 .75174 2.37764 .77254 Mabsadd L
.74256 .75174 .56518 .7779 Mabsadd L
.74256 .75174 0 2.5 Mabsadd L closepath F
.74405 .7532 0 2.5 Mabsadd m
.74405 .7532 -0.56518 .7779 Mabsadd L
.74405 .7532 -2.37764 .77254 Mabsadd L
.74405 .7532 -0.91448 -0.29713 Mabsadd L
.74405 .7532 -1.46946 -2.02254 Mabsadd L
.74405 .7532 0 -0.96154 Mabsadd L
.74405 .7532 1.46946 -2.02254 Mabsadd L
.74405 .7532 .91448 -0.29713 Mabsadd L
.74405 .7532 2.37764 .77254 Mabsadd L
.74405 .7532 .56518 .7779 Mabsadd L
.74405 .7532 0 2.5 Mabsadd L closepath F
.74554 .75465 0 2.5 Mabsadd m
.74554 .75465 -0.56518 .7779 Mabsadd L
.74554 .75465 -2.37764 .77254 Mabsadd L
.74554 .75465 -0.91448 -0.29713 Mabsadd L
.74554 .75465 -1.46946 -2.02254 Mabsadd L
.74554 .75465 0 -0.96154 Mabsadd L
.74554 .75465 1.46946 -2.02254 Mabsadd L
.74554 .75465 .91448 -0.29713 Mabsadd L
.74554 .75465 2.37764 .77254 Mabsadd L
.74554 .75465 .56518 .7779 Mabsadd L
.74554 .75465 0 2.5 Mabsadd L closepath F
.74702 .75611 0 2.5 Mabsadd m
.74702 .75611 -0.56518 .7779 Mabsadd L
.74702 .75611 -2.37764 .77254 Mabsadd L
.74702 .75611 -0.91448 -0.29713 Mabsadd L
.74702 .75611 -1.46946 -2.02254 Mabsadd L
.74702 .75611 0 -0.96154 Mabsadd L
.74702 .75611 1.46946 -2.02254 Mabsadd L
.74702 .75611 .91448 -0.29713 Mabsadd L
.74702 .75611 2.37764 .77254 Mabsadd L
.74702 .75611 .56518 .7779 Mabsadd L
.74702 .75611 0 2.5 Mabsadd L closepath F
.74851 .75757 0 2.5 Mabsadd m
.74851 .75757 -0.56518 .7779 Mabsadd L
.74851 .75757 -2.37764 .77254 Mabsadd L
.74851 .75757 -0.91448 -0.29713 Mabsadd L
.74851 .75757 -1.46946 -2.02254 Mabsadd L
.74851 .75757 0 -0.96154 Mabsadd L
.74851 .75757 1.46946 -2.02254 Mabsadd L
.74851 .75757 .91448 -0.29713 Mabsadd L
.74851 .75757 2.37764 .77254 Mabsadd L
.74851 .75757 .56518 .7779 Mabsadd L
.74851 .75757 0 2.5 Mabsadd L closepath F
.75 .75903 0 2.5 Mabsadd m
.75 .75903 -0.56518 .7779 Mabsadd L
.75 .75903 -2.37764 .77254 Mabsadd L
.75 .75903 -0.91448 -0.29713 Mabsadd L
.75 .75903 -1.46946 -2.02254 Mabsadd L
.75 .75903 0 -0.96154 Mabsadd L
.75 .75903 1.46946 -2.02254 Mabsadd L
.75 .75903 .91448 -0.29713 Mabsadd L
.75 .75903 2.37764 .77254 Mabsadd L
.75 .75903 .56518 .7779 Mabsadd L
.75 .75903 0 2.5 Mabsadd L closepath F
.75149 .76049 0 2.5 Mabsadd m
.75149 .76049 -0.56518 .7779 Mabsadd L
.75149 .76049 -2.37764 .77254 Mabsadd L
.75149 .76049 -0.91448 -0.29713 Mabsadd L
.75149 .76049 -1.46946 -2.02254 Mabsadd L
.75149 .76049 0 -0.96154 Mabsadd L
.75149 .76049 1.46946 -2.02254 Mabsadd L
.75149 .76049 .91448 -0.29713 Mabsadd L
.75149 .76049 2.37764 .77254 Mabsadd L
.75149 .76049 .56518 .7779 Mabsadd L
.75149 .76049 0 2.5 Mabsadd L closepath F
.75298 .76195 0 2.5 Mabsadd m
.75298 .76195 -0.56518 .7779 Mabsadd L
.75298 .76195 -2.37764 .77254 Mabsadd L
.75298 .76195 -0.91448 -0.29713 Mabsadd L
.75298 .76195 -1.46946 -2.02254 Mabsadd L
.75298 .76195 0 -0.96154 Mabsadd L
.75298 .76195 1.46946 -2.02254 Mabsadd L
.75298 .76195 .91448 -0.29713 Mabsadd L
.75298 .76195 2.37764 .77254 Mabsadd L
.75298 .76195 .56518 .7779 Mabsadd L
.75298 .76195 0 2.5 Mabsadd L closepath F
.75446 .7634 0 2.5 Mabsadd m
.75446 .7634 -0.56518 .7779 Mabsadd L
.75446 .7634 -2.37764 .77254 Mabsadd L
.75446 .7634 -0.91448 -0.29713 Mabsadd L
.75446 .7634 -1.46946 -2.02254 Mabsadd L
.75446 .7634 0 -0.96154 Mabsadd L
.75446 .7634 1.46946 -2.02254 Mabsadd L
.75446 .7634 .91448 -0.29713 Mabsadd L
.75446 .7634 2.37764 .77254 Mabsadd L
.75446 .7634 .56518 .7779 Mabsadd L
.75446 .7634 0 2.5 Mabsadd L closepath F
.75595 .76486 0 2.5 Mabsadd m
.75595 .76486 -0.56518 .7779 Mabsadd L
.75595 .76486 -2.37764 .77254 Mabsadd L
.75595 .76486 -0.91448 -0.29713 Mabsadd L
.75595 .76486 -1.46946 -2.02254 Mabsadd L
.75595 .76486 0 -0.96154 Mabsadd L
.75595 .76486 1.46946 -2.02254 Mabsadd L
.75595 .76486 .91448 -0.29713 Mabsadd L
.75595 .76486 2.37764 .77254 Mabsadd L
.75595 .76486 .56518 .7779 Mabsadd L
.75595 .76486 0 2.5 Mabsadd L closepath F
.75744 .76632 0 2.5 Mabsadd m
.75744 .76632 -0.56518 .7779 Mabsadd L
.75744 .76632 -2.37764 .77254 Mabsadd L
.75744 .76632 -0.91448 -0.29713 Mabsadd L
.75744 .76632 -1.46946 -2.02254 Mabsadd L
.75744 .76632 0 -0.96154 Mabsadd L
.75744 .76632 1.46946 -2.02254 Mabsadd L
.75744 .76632 .91448 -0.29713 Mabsadd L
.75744 .76632 2.37764 .77254 Mabsadd L
.75744 .76632 .56518 .7779 Mabsadd L
.75744 .76632 0 2.5 Mabsadd L closepath F
.75893 .76777 0 2.5 Mabsadd m
.75893 .76777 -0.56518 .7779 Mabsadd L
.75893 .76777 -2.37764 .77254 Mabsadd L
.75893 .76777 -0.91448 -0.29713 Mabsadd L
.75893 .76777 -1.46946 -2.02254 Mabsadd L
.75893 .76777 0 -0.96154 Mabsadd L
.75893 .76777 1.46946 -2.02254 Mabsadd L
.75893 .76777 .91448 -0.29713 Mabsadd L
.75893 .76777 2.37764 .77254 Mabsadd L
.75893 .76777 .56518 .7779 Mabsadd L
.75893 .76777 0 2.5 Mabsadd L closepath F
.76042 .76923 0 2.5 Mabsadd m
.76042 .76923 -0.56518 .7779 Mabsadd L
.76042 .76923 -2.37764 .77254 Mabsadd L
.76042 .76923 -0.91448 -0.29713 Mabsadd L
.76042 .76923 -1.46946 -2.02254 Mabsadd L
.76042 .76923 0 -0.96154 Mabsadd L
.76042 .76923 1.46946 -2.02254 Mabsadd L
.76042 .76923 .91448 -0.29713 Mabsadd L
.76042 .76923 2.37764 .77254 Mabsadd L
.76042 .76923 .56518 .7779 Mabsadd L
.76042 .76923 0 2.5 Mabsadd L closepath F
.7619 .77069 0 2.5 Mabsadd m
.7619 .77069 -0.56518 .7779 Mabsadd L
.7619 .77069 -2.37764 .77254 Mabsadd L
.7619 .77069 -0.91448 -0.29713 Mabsadd L
.7619 .77069 -1.46946 -2.02254 Mabsadd L
.7619 .77069 0 -0.96154 Mabsadd L
.7619 .77069 1.46946 -2.02254 Mabsadd L
.7619 .77069 .91448 -0.29713 Mabsadd L
.7619 .77069 2.37764 .77254 Mabsadd L
.7619 .77069 .56518 .7779 Mabsadd L
.7619 .77069 0 2.5 Mabsadd L closepath F
.76339 .77214 0 2.5 Mabsadd m
.76339 .77214 -0.56518 .7779 Mabsadd L
.76339 .77214 -2.37764 .77254 Mabsadd L
.76339 .77214 -0.91448 -0.29713 Mabsadd L
.76339 .77214 -1.46946 -2.02254 Mabsadd L
.76339 .77214 0 -0.96154 Mabsadd L
.76339 .77214 1.46946 -2.02254 Mabsadd L
.76339 .77214 .91448 -0.29713 Mabsadd L
.76339 .77214 2.37764 .77254 Mabsadd L
.76339 .77214 .56518 .7779 Mabsadd L
.76339 .77214 0 2.5 Mabsadd L closepath F
.76488 .7736 0 2.5 Mabsadd m
.76488 .7736 -0.56518 .7779 Mabsadd L
.76488 .7736 -2.37764 .77254 Mabsadd L
.76488 .7736 -0.91448 -0.29713 Mabsadd L
.76488 .7736 -1.46946 -2.02254 Mabsadd L
.76488 .7736 0 -0.96154 Mabsadd L
.76488 .7736 1.46946 -2.02254 Mabsadd L
.76488 .7736 .91448 -0.29713 Mabsadd L
.76488 .7736 2.37764 .77254 Mabsadd L
.76488 .7736 .56518 .7779 Mabsadd L
.76488 .7736 0 2.5 Mabsadd L closepath F
.76637 .77505 0 2.5 Mabsadd m
.76637 .77505 -0.56518 .7779 Mabsadd L
.76637 .77505 -2.37764 .77254 Mabsadd L
.76637 .77505 -0.91448 -0.29713 Mabsadd L
.76637 .77505 -1.46946 -2.02254 Mabsadd L
.76637 .77505 0 -0.96154 Mabsadd L
.76637 .77505 1.46946 -2.02254 Mabsadd L
.76637 .77505 .91448 -0.29713 Mabsadd L
.76637 .77505 2.37764 .77254 Mabsadd L
.76637 .77505 .56518 .7779 Mabsadd L
.76637 .77505 0 2.5 Mabsadd L closepath F
.76786 .77651 0 2.5 Mabsadd m
.76786 .77651 -0.56518 .7779 Mabsadd L
.76786 .77651 -2.37764 .77254 Mabsadd L
.76786 .77651 -0.91448 -0.29713 Mabsadd L
.76786 .77651 -1.46946 -2.02254 Mabsadd L
.76786 .77651 0 -0.96154 Mabsadd L
.76786 .77651 1.46946 -2.02254 Mabsadd L
.76786 .77651 .91448 -0.29713 Mabsadd L
.76786 .77651 2.37764 .77254 Mabsadd L
.76786 .77651 .56518 .7779 Mabsadd L
.76786 .77651 0 2.5 Mabsadd L closepath F
.76935 .77796 0 2.5 Mabsadd m
.76935 .77796 -0.56518 .7779 Mabsadd L
.76935 .77796 -2.37764 .77254 Mabsadd L
.76935 .77796 -0.91448 -0.29713 Mabsadd L
.76935 .77796 -1.46946 -2.02254 Mabsadd L
.76935 .77796 0 -0.96154 Mabsadd L
.76935 .77796 1.46946 -2.02254 Mabsadd L
.76935 .77796 .91448 -0.29713 Mabsadd L
.76935 .77796 2.37764 .77254 Mabsadd L
.76935 .77796 .56518 .7779 Mabsadd L
.76935 .77796 0 2.5 Mabsadd L closepath F
.77083 .77942 0 2.5 Mabsadd m
.77083 .77942 -0.56518 .7779 Mabsadd L
.77083 .77942 -2.37764 .77254 Mabsadd L
.77083 .77942 -0.91448 -0.29713 Mabsadd L
.77083 .77942 -1.46946 -2.02254 Mabsadd L
.77083 .77942 0 -0.96154 Mabsadd L
.77083 .77942 1.46946 -2.02254 Mabsadd L
.77083 .77942 .91448 -0.29713 Mabsadd L
.77083 .77942 2.37764 .77254 Mabsadd L
.77083 .77942 .56518 .7779 Mabsadd L
.77083 .77942 0 2.5 Mabsadd L closepath F
.77232 .78087 0 2.5 Mabsadd m
.77232 .78087 -0.56518 .7779 Mabsadd L
.77232 .78087 -2.37764 .77254 Mabsadd L
.77232 .78087 -0.91448 -0.29713 Mabsadd L
.77232 .78087 -1.46946 -2.02254 Mabsadd L
.77232 .78087 0 -0.96154 Mabsadd L
.77232 .78087 1.46946 -2.02254 Mabsadd L
.77232 .78087 .91448 -0.29713 Mabsadd L
.77232 .78087 2.37764 .77254 Mabsadd L
.77232 .78087 .56518 .7779 Mabsadd L
.77232 .78087 0 2.5 Mabsadd L closepath F
.77381 .78232 0 2.5 Mabsadd m
.77381 .78232 -0.56518 .7779 Mabsadd L
.77381 .78232 -2.37764 .77254 Mabsadd L
.77381 .78232 -0.91448 -0.29713 Mabsadd L
.77381 .78232 -1.46946 -2.02254 Mabsadd L
.77381 .78232 0 -0.96154 Mabsadd L
.77381 .78232 1.46946 -2.02254 Mabsadd L
.77381 .78232 .91448 -0.29713 Mabsadd L
.77381 .78232 2.37764 .77254 Mabsadd L
.77381 .78232 .56518 .7779 Mabsadd L
.77381 .78232 0 2.5 Mabsadd L closepath F
.7753 .78378 0 2.5 Mabsadd m
.7753 .78378 -0.56518 .7779 Mabsadd L
.7753 .78378 -2.37764 .77254 Mabsadd L
.7753 .78378 -0.91448 -0.29713 Mabsadd L
.7753 .78378 -1.46946 -2.02254 Mabsadd L
.7753 .78378 0 -0.96154 Mabsadd L
.7753 .78378 1.46946 -2.02254 Mabsadd L
.7753 .78378 .91448 -0.29713 Mabsadd L
.7753 .78378 2.37764 .77254 Mabsadd L
.7753 .78378 .56518 .7779 Mabsadd L
.7753 .78378 0 2.5 Mabsadd L closepath F
.77679 .78523 0 2.5 Mabsadd m
.77679 .78523 -0.56518 .7779 Mabsadd L
.77679 .78523 -2.37764 .77254 Mabsadd L
.77679 .78523 -0.91448 -0.29713 Mabsadd L
.77679 .78523 -1.46946 -2.02254 Mabsadd L
.77679 .78523 0 -0.96154 Mabsadd L
.77679 .78523 1.46946 -2.02254 Mabsadd L
.77679 .78523 .91448 -0.29713 Mabsadd L
.77679 .78523 2.37764 .77254 Mabsadd L
.77679 .78523 .56518 .7779 Mabsadd L
.77679 .78523 0 2.5 Mabsadd L closepath F
.77827 .78668 0 2.5 Mabsadd m
.77827 .78668 -0.56518 .7779 Mabsadd L
.77827 .78668 -2.37764 .77254 Mabsadd L
.77827 .78668 -0.91448 -0.29713 Mabsadd L
.77827 .78668 -1.46946 -2.02254 Mabsadd L
.77827 .78668 0 -0.96154 Mabsadd L
.77827 .78668 1.46946 -2.02254 Mabsadd L
.77827 .78668 .91448 -0.29713 Mabsadd L
.77827 .78668 2.37764 .77254 Mabsadd L
.77827 .78668 .56518 .7779 Mabsadd L
.77827 .78668 0 2.5 Mabsadd L closepath F
.77976 .78813 0 2.5 Mabsadd m
.77976 .78813 -0.56518 .7779 Mabsadd L
.77976 .78813 -2.37764 .77254 Mabsadd L
.77976 .78813 -0.91448 -0.29713 Mabsadd L
.77976 .78813 -1.46946 -2.02254 Mabsadd L
.77976 .78813 0 -0.96154 Mabsadd L
.77976 .78813 1.46946 -2.02254 Mabsadd L
.77976 .78813 .91448 -0.29713 Mabsadd L
.77976 .78813 2.37764 .77254 Mabsadd L
.77976 .78813 .56518 .7779 Mabsadd L
.77976 .78813 0 2.5 Mabsadd L closepath F
.78125 .78959 0 2.5 Mabsadd m
.78125 .78959 -0.56518 .7779 Mabsadd L
.78125 .78959 -2.37764 .77254 Mabsadd L
.78125 .78959 -0.91448 -0.29713 Mabsadd L
.78125 .78959 -1.46946 -2.02254 Mabsadd L
.78125 .78959 0 -0.96154 Mabsadd L
.78125 .78959 1.46946 -2.02254 Mabsadd L
.78125 .78959 .91448 -0.29713 Mabsadd L
.78125 .78959 2.37764 .77254 Mabsadd L
.78125 .78959 .56518 .7779 Mabsadd L
.78125 .78959 0 2.5 Mabsadd L closepath F
.78274 .79104 0 2.5 Mabsadd m
.78274 .79104 -0.56518 .7779 Mabsadd L
.78274 .79104 -2.37764 .77254 Mabsadd L
.78274 .79104 -0.91448 -0.29713 Mabsadd L
.78274 .79104 -1.46946 -2.02254 Mabsadd L
.78274 .79104 0 -0.96154 Mabsadd L
.78274 .79104 1.46946 -2.02254 Mabsadd L
.78274 .79104 .91448 -0.29713 Mabsadd L
.78274 .79104 2.37764 .77254 Mabsadd L
.78274 .79104 .56518 .7779 Mabsadd L
.78274 .79104 0 2.5 Mabsadd L closepath F
.78423 .79249 0 2.5 Mabsadd m
.78423 .79249 -0.56518 .7779 Mabsadd L
.78423 .79249 -2.37764 .77254 Mabsadd L
.78423 .79249 -0.91448 -0.29713 Mabsadd L
.78423 .79249 -1.46946 -2.02254 Mabsadd L
.78423 .79249 0 -0.96154 Mabsadd L
.78423 .79249 1.46946 -2.02254 Mabsadd L
.78423 .79249 .91448 -0.29713 Mabsadd L
.78423 .79249 2.37764 .77254 Mabsadd L
.78423 .79249 .56518 .7779 Mabsadd L
.78423 .79249 0 2.5 Mabsadd L closepath F
.78571 .79394 0 2.5 Mabsadd m
.78571 .79394 -0.56518 .7779 Mabsadd L
.78571 .79394 -2.37764 .77254 Mabsadd L
.78571 .79394 -0.91448 -0.29713 Mabsadd L
.78571 .79394 -1