(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3573998,     224323]*)
(*NotebookOutlinePosition[   3576894,     224415]*)
(*  CellTagsIndexPosition[   3576327,     224395]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SymplecticPartitionedRungeKutta", "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell["\<\
When numerically solving Hamiltonian dynamical systems it is \
advantageous if the numerical method yields a symplectic map.\
\>", "Text"],

Cell["\<\
The phase space of a Hamiltonian system is a symplectic manifold on \
which there exists a natural symplectic structure in the canonically \
conjugate coordinates.\
\>", "BulletedList"],

Cell["\<\
The time evolution of a Hamiltonian system is such that the Poincar\
\[EAcute] integral invariants associated with the symplectic structure are \
preserved.\
\>", "BulletedList"],

Cell["\<\
A symplectic integrator computes exactly, assuming infinite \
precision arithmetic, the evolution of a nearby Hamiltonian, whose phase \
space structure is close to that of the original system.\
\>", "BulletedList"],

Cell["\<\
If the Hamiltonian can be written in separable form, H(p, q) = T(p) \
+ V(q), there exists an efficient class of explicit symplectic numerical \
integration methods.\
\>", "Text"],

Cell[TextData[{
  "An important property of symplectic numerical methods when applied to \
Hamiltonian systems is that a nearby Hamiltonian is approximately conserved \
for exponentially long times (see [",
  ButtonBox["BG94",
    ButtonData:>{"References.nb", "BG94"},
    ButtonStyle->"Hyperlink"],
  "] , [",
  ButtonBox["HL97",
    ButtonData:>{"References.nb", "HL97"},
    ButtonStyle->"Hyperlink"],
  "]  and [",
  ButtonBox["R99",
    ButtonData:>{"References.nb", "R99"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"],

Cell[CellGroupData[{

Cell["Hamiltonian systems", "Subsection"],

Cell["Consider a differential equation", "Text"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dt\  = \ F(t, \ y), \ 
    y(t\_0)\  = \ \(\(y\_0\)\(.\)\)\)], "NumberedEquation",
  CellTags->"ODEEquation"],

Cell[TextData[{
  "A ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  "-degree of freedom Hamiltonian system is a particular instance of (",
  
  CounterBox["NumberedEquation", "ODEEquation"],
  ") with ",
  Cell[BoxData[
      \(TraditionalForm\`y = \((p\_1, \[Ellipsis], p\_d, \(q\_1\) \
\[Ellipsis], q\_d)\)\^T\)]],
  ", where"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dt\  = \ \(J\^\(-1\)\) \(\(\[Del]\ 
            H\)\(.\)\)\)], "NumberedEquation",
  CellTags->"HamiltonianODEEquation"],

Cell[TextData[{
  "Here ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\)]],
  " represents the gradient operator:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Del]\ \
\(\(=\)\(\((\[PartialD]\(\(/\)\(\[PartialD]p\_1\)\), \[Ellipsis], \[PartialD]\
\(\(/\)\(\[PartialD]p\_d\)\), \[PartialD]\(\(/\)\(\[PartialD]q\_1\)\), \
\[Ellipsis] \[PartialD]\(\(/\)\(\[PartialD]q\_d\)\))\)\^T\)\)\)], \
"DisplayFormula"],

Cell[TextData[{
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  " is the skew symmetric matrix:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"J", " ", "=", 
        RowBox[{"(", GridBox[{
              {"0", "I"},
              {\(-I\), "0"}
              }], ")"}]}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`0\)]],
  " are the identity and zero ",
  Cell[BoxData[
      \(TraditionalForm\`d\[Cross]d\)]],
  " matrices."
}], "Text"],

Cell[TextData[{
  "The components of ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are often referred to as position or coordinate variables and the \
components of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " as the momenta."
}], "Text"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is autonomous, ",
  Cell[BoxData[
      \(TraditionalForm\`dH/dt\  = \ 0\)]],
  ". Then ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is a conserved quantity that remains constant along solutions of the \
system. In applications, this usually corresponds to conservation of energy."
}], "Text"],

Cell[TextData[{
  "A numerical method applied to a Hamiltonian system (",
  
  CounterBox["NumberedEquation", "HamiltonianODEEquation"],
  ") is said to be symplectic if it produces a symplectic map. That is, let \
",
  Cell[BoxData[
      \(TraditionalForm\`\((\(p\^*\), \(q\^*\))\)\  = \ \[Psi](p, q)\)]],
  " be a ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "transformation defined in a domain \[CapitalOmega].:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[ForAll] \((p, 
          q)\) \[Element] \[CapitalOmega]\ , \ \(\[Psi]\^\[Prime]T\) 
        J\ \[Psi]\^\[Prime] = \ \(\(\(\[PartialD]\((\(p\^*\), \
\(q\^*\))\)\^T\/\[PartialD]\((p, q)\)\) 
          J \[PartialD]\((\(p\^*\), \(q\^*\))\)\/\[PartialD]\((p, q)\)\)\(=\)\
\(J\)\(\ \)\)\)], "DisplayFormula"],

Cell["where the Jacobian of the transformation is:", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Psi]\^\[Prime]\), "=", " ", 
        RowBox[{\(\[PartialD]\((\(p\^*\), \(q\^*\))\)\/\[PartialD]\((p, 
                  q)\)\), "=", 
          RowBox[{"(", GridBox[{
                {\(\[PartialD]\(p\^*\)\/\[PartialD]p\), \(\[PartialD]\(p\^*\)\
\/\[PartialD]q\)},
                {\(\[PartialD]\(q\^*\)\/\[PartialD]p\), \(\[PartialD]\(q\^*\)\
\/\[PartialD]q\)}
                }], ")"}], " "}]}], TraditionalForm]], "DisplayFormula"],

Cell["\<\
The flow of a Hamiltonian system is depicted below together with \
the projection onto the planes formed by canonically conjugate coordinate and \
momenta pairs. The sum of the oriented areas remains constant as the flow \
evolves in time.\
\>", "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00195608 0.0238095 0.00192467 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.4 0 0 1 k
1 Mabswid
[ ] 0 Mabsdash
.55992 .50315 m
.55964 .50883 L
.55882 .51435 L
.55749 .51968 L
.55566 .52478 L
.55067 .53422 L
.54405 .54245 L
.53603 .54923 L
.52682 .55436 L
.52184 .55622 L
.51664 .55759 L
.51126 .55844 L
.50572 .55872 L
.50018 .55844 L
.49479 .55759 L
.4896 .55622 L
.48462 .55436 L
.47541 .54923 L
.46739 .54245 L
.46077 .53422 L
.45577 .52478 L
.45395 .51968 L
.45262 .51435 L
.45179 .50884 L
.45151 .50315 L
.45179 .49747 L
.45262 .49195 L
.45395 .48663 L
.45577 .48152 L
.46077 .47208 L
.46739 .46386 L
.47541 .45707 L
.48462 .45195 L
.4896 .45008 L
.49479 .44871 L
.50018 .44787 L
.50572 .44758 L
.51126 .44787 L
.51664 .44871 L
.52184 .45008 L
.52682 .45195 L
.53603 .45707 L
.54405 .46386 L
.55067 .47208 L
.55566 .48152 L
.55749 .48663 L
.55882 .49195 L
.55964 .49747 L
.55992 .50315 L
.55992 .50315 L
Mistroke
Mfstroke
.45146 .50378 m
.45196 .52345 L
.45345 .54286 L
.4559 .56199 L
.45929 .58082 L
.4636 .59932 L
.4688 .61746 L
.47486 .63522 L
.48177 .65258 L
.48949 .66951 L
.49801 .686 L
.5073 .70201 L
.51733 .71752 L
.52808 .73251 L
.53953 .74695 L
.55166 .76082 L
.56443 .77409 L
.57782 .78675 L
.59182 .79877 L
.60639 .81012 L
.62151 .82077 L
.63716 .83072 L
.65331 .83992 L
.66994 .84837 L
.68703 .85602 L
.70454 .86287 L
.72246 .86888 L
.74077 .87403 L
.75943 .8783 L
.77842 .88166 L
.79772 .88409 L
.81731 .88557 L
.83716 .88606 L
s
.55992 .50417 m
.56028 .51821 L
.56136 .53207 L
.56312 .54573 L
.56556 .55917 L
.56866 .57237 L
.57239 .58532 L
.57675 .598 L
.58172 .6104 L
.58728 .62249 L
.5934 .63425 L
.60008 .64568 L
.60729 .65676 L
.61503 .66746 L
.62326 .67777 L
.63198 .68767 L
.64116 .69715 L
.6508 .70618 L
.66086 .71476 L
.67134 .72286 L
.68221 .73047 L
.69347 .73757 L
.70508 .74414 L
.71704 .75017 L
.72933 .75563 L
.74193 .76052 L
.75481 .76481 L
.76798 .76849 L
.78139 .77154 L
.79505 .77394 L
.80894 .77567 L
.82302 .77672 L
.83729 .77708 L
s
.89261 .83151 m
.89232 .83708 L
.89148 .8425 L
.89012 .84773 L
.88825 .85274 L
.88314 .86201 L
.87637 .87009 L
.86816 .87675 L
.85874 .88178 L
.85365 .88361 L
.84834 .88496 L
.84283 .88578 L
.83716 .88606 L
s
.89261 .83151 m
.89232 .82593 L
.89148 .82051 L
.89012 .81528 L
.88825 .81027 L
.88314 .801 L
.87637 .79293 L
.86816 .78627 L
.85874 .78124 L
.85365 .7794 L
.84834 .77806 L
.84283 .77723 L
.83716 .77695 L
s
[ 5 ] 0 Mabsdash
.57616 .70851 m
.57184 .71263 L
.56809 .71703 L
.56492 .72165 L
.56233 .72646 L
.56031 .73143 L
.55887 .73652 L
.55801 .74168 L
.55772 .74688 L
.558 .75209 L
.55887 .75725 L
.56031 .76234 L
.56233 .76731 L
.56492 .77212 L
.56809 .77675 L
.57184 .78114 L
.57616 .78526 L
s
[ ] 0 Mabsdash
.65513 .78849 m
.65885 .78429 L
.66207 .77981 L
.6648 .77509 L
.66703 .77018 L
.67001 .75992 L
.671 .74934 L
.67001 .73877 L
.66703 .72851 L
.6648 .7236 L
.66208 .71888 L
.65885 .7144 L
.65513 .7102 L
s
[ 5 ] 0 Mabsdash
.572 .71236 m
.57655 .70783 L
.58138 .7039 L
.58648 .70057 L
.59179 .69785 L
.59727 .69573 L
.60288 .69422 L
.60857 .69332 L
.6143 .69302 L
.62003 .69332 L
.62573 .69422 L
.63133 .69573 L
.63681 .69785 L
.64212 .70057 L
.64722 .7039 L
.65206 .70783 L
.6566 .71236 L
s
[ ] 0 Mabsdash
.65712 .78547 m
.6528 .78986 L
.64819 .79368 L
.64335 .7969 L
.63829 .79954 L
.63308 .80159 L
.62775 .80306 L
.62234 .80394 L
.61688 .80423 L
.61143 .80394 L
.60602 .80306 L
.60068 .80159 L
.59547 .79954 L
.59042 .7969 L
.58557 .79368 L
.58097 .78986 L
.57665 .78547 L
s
.65068 .79271 m
.647 .78955 L
.66356 .77822 L
.65437 .79588 L
.65068 .79271 L
F
.30104 .33916 m
.30104 .96657 L
s
.30104 .95694 m
.30594 .95694 L
.30104 .97619 L
.29615 .95694 L
.30104 .95694 L
F
.30104 .33916 m
.05153 .23005 L
s
.06047 .23396 m
.05848 .23835 L
.0426 .22614 L
.06246 .22956 L
.06047 .23396 L
F
.30104 .33916 m
.96641 .33916 L
s
.95663 .33916 m
.95663 .33435 L
.97619 .33916 L
.95663 .34398 L
.95663 .33916 L
F
.30104 .33916 m
.16243 .06638 L
s
.1668 .07499 m
.16243 .07714 L
.15805 .05777 L
.17117 .07283 L
.1668 .07499 L
F
.10698 .74846 m
.10754 .75963 L
.10916 .77003 L
.11171 .77943 L
.1151 .78763 L
.1192 .7944 L
.12391 .79951 L
.12912 .80273 L
.1347 .80386 L
.14029 .80273 L
.14549 .79951 L
.1502 .7944 L
.15431 .78763 L
.15769 .77944 L
.16025 .77003 L
.16186 .75963 L
.16243 .74846 L
.16186 .7373 L
.16025 .7269 L
.15769 .71749 L
.15431 .70929 L
.1502 .70253 L
.1455 .69742 L
.14029 .69419 L
.1347 .69307 L
.12912 .69419 L
.12391 .69742 L
.1192 .70253 L
.1151 .70929 L
.11171 .71749 L
.10916 .7269 L
.10754 .7373 L
.10698 .74846 L
.10698 .74846 L
s
.67091 .17417 m
.66977 .17969 L
.66649 .18484 L
.6613 .18949 L
.65442 .19355 L
.64609 .19689 L
.63652 .19942 L
.62595 .20101 L
.61461 .20157 L
.60326 .20101 L
.59269 .19942 L
.58313 .19689 L
.57479 .19355 L
.56792 .18949 L
.56273 .18484 L
.55945 .17969 L
.5583 .17417 L
.55945 .16865 L
.56273 .16351 L
.56792 .15885 L
.57479 .1548 L
.58313 .15145 L
.59269 .14893 L
.60326 .14733 L
.61461 .14677 L
.62595 .14733 L
.63652 .14893 L
.64609 .15145 L
.65442 .1548 L
.6613 .15885 L
.66649 .16351 L
.66977 .16865 L
.67091 .17417 L
.67091 .17417 L
s
[ 5 ] 0 Mabsdash
.55806 .74738 m
.55806 .17453 L
s
.67091 .74714 m
.67091 .17429 L
s
[ ] 0 Mabsdash
.60964 .14704 m
.6173 .14704 L
s
.60752 .14704 m
.60752 .14223 L
.62708 .14704 L
.60752 .15186 L
.60752 .14704 L
F
[ 5 ] 0 Mabsdash
.1347 .80386 m
.61987 .80386 L
s
.1347 .69306 m
.61987 .69306 L
s
[ ] 0 Mabsdash
.10719 .75206 m
.10719 .74556 L
s
.10719 .75519 m
.1023 .75519 L
.10719 .73594 L
.11208 .75519 L
.10719 .75519 L
F
gsave
.23898 .95728 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.04728 .2567 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(q) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.18225 .06615 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(q) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.9549 .36063 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.6875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
74.312 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.66932 .78406 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.0625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C) show
71.000 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
74.375 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.11183 .72632 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
71.625 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
76.938 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.70355 .18452 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 36.4375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 23.688 moveto
(\\250) show
76.000 21.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
82.000 23.062 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
87.312 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
( ) show
89.562 21.188 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(dq) show
101.562 24.812 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
106.875 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.6478 .17586 m
.69572 .2028 L
s
.65629 .18063 m
.65387 .18481 L
.63931 .17108 L
.65872 .17646 L
.65629 .18063 L
F
gsave
.59107 .15854 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
71.625 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
76.938 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.03359 .82255 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 36.4375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Math2
%%IncludeFont: Math2
/Math2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 23.688 moveto
(\\250) show
76.000 21.188 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
82.000 23.062 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
87.312 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
( ) show
89.562 21.188 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(dq) show
101.562 24.812 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
106.875 21.188 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08836 .82062 m
.13726 .77443 L
s
.13021 .7811 m
.12682 .77763 L
.14432 .76777 L
.13359 .78457 L
.13021 .7811 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[71]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo000^ool00`00ooooo`3_ool002koo`800?3oo`00;_oo0`002?oo0`00
i?oo000^ool2000:ool00`00ooooo`03003Pool002ooo`8000Woo`05003oooooool0003Qool0033o
o`03003ooooo00Goo`<000?oo`03003ooooo0=ooo`00<Ooo00<00?ooool00ooo00@00?ooool000?o
o`03003ooooo0=ooo`00<Ooo00<00?ooool00ooo00@00?ooool000?oo`03003ooooo0=ooo`00<_oo
00<00?ooool00_oo00@00?ooool000;oo`800>7oo`00<_oo00<00?ooool00_oo00@00?ooool00>Go
o`00<ooo00<00?ooool00_oo0`00iOoo000cool00`00ooooo`3Zool003Coo`03003ooooo0>Woo`00
=?oo00<00?ooool0jOoo000eool00`00ooooo`3Xool003Goo`03003ooooo0>Soo`00=_oo00<00?oo
ool0iooo000fool00`00ooooo`3Wool003Ooo`03003ooooo0>Koo`00=ooo00<00?ooool0i_oo000h
ool00`00ooooo`3Uool003Soo`03003ooooo0>Goo`00>Ooo00<00?ooool0i?oo000iool00`00oooo
o`1bool3001_ool003[oo`03003ooooo06coo`l006Soo`00>_oo00<00?ooool0JOoo0`003ooo0`00
IOoo000kool00`00ooooo`1Uool3000Dool3001Sool003_oo`03003ooooo06Coo`8001Soo`<0067o
o`00??oo00<00?ooool0H_oo00<00?ooool06_oo0P00H?oo000lool00`00ooooo`1Qool2000Cool3
0007ool2001Oool003goo`03003ooooo063oo`03003ooooo01?oo`03003ooooo00Ooo`03003ooooo
05goo`00?Ooo00<00?ooool0H?oo00<00?ooool02?oo0`000ooo0`000_oo00<00?ooool01ooo00<0
0?ooool0GOoo000nool00`00ooooo`1Oool00`00ooooo`09ool00`00ooooo`03ool01P00oooooooo
003oo`D000?oo`03003ooooo05goo`00?_oo00<00?ooool0Gooo00<00?ooool02_oo00D00?oooooo
o`0000Coo`03003ooooo00<000Coo`03003ooooo05goo`00?ooo00<00?ooool0G_oo0P002ooo1@00
0ooo0P000ooo100000?oo`000000Gooo000oool00`00ooooo`1Nool2000;ool01@00oooooooo0000
3?oo0`00Gooo0010ool00`00ooooo`1Mool01000ool000002_oo00<00?oo00002ooo1P002ooo0`00
D?oo0010ool2001Qool30008ool00`00ool00009ool30004ool20009ool20002ool00`00ooooo`1=
ool0047oo`03003ooooo06;oo`<000Koo`03003ooooo00Koo`<000Soo`8000_oo`8004koo`00@Ooo
0P00I_oo3`003Ooo0P002_oo00<00?ooool0C?oo0012ool00`00ooooo`21ool20009ool2001=ool0
04;oo`8005coo`03003ooooo01goo`03003ooooo00koo`8004goo`00@ooo00<00?ooool0F_oo00<0
0?ooool07Ooo00<00?ooool03_oo0P00COoo0013ool2001Kool00`00ooooo`0Mool00`00ooooo`0>
ool2000Pool3000Zool004Coo`03003ooooo05Woo`03003ooooo01goo`03003ooooo00goo`@000Co
o`<001Coo`<000;oo`03003ooooo02Woo`00AOoo00<00?ooool0F?oo00<00?ooool07Ooo00<00?oo
ool03?oo00H00?oo00000?oo0004ool00`00ooooo`03ool3000>ool01@00oooooooo0000:ooo0015
ool00`00ooooo`1Hool00`00ooooo`0Mool00`00ooooo`0;ool00`00ooooo`020002ool01@00oooo
oooo00001_oo00<00?ooool03Ooo00D00?ooooooo`0002_oo`003Ooo1000=Ooo00<00?ooool0Q?oo
00@00?ooooooo`8000?oo`03003ooooo00<000Coo`03003ooooo00Goo`800004ool00?ooool30003
ool00`00ooooo`0Yool000koo`<003Goo`03003ooooo08Coo`04003oooooool20003ool01000oooo
o`000_oo00D00?ooooooo`0000Koo`04003ooooo0002ool01000ooooo`000_oo0P00:ooo000?ool3
000eool00`00ooooo`23ool01000oooooooo0P000ooo00@00?ooool000;oo`05003oooooool00006
ool01000ooooo`000_oo00@00?ooool002ooo`004_oo0P00<ooo00<00?ooool0Pooo00@00?oooooo
o`8000?oo`04003ooooo0002ool00`00ooooo`020006ool01000ooooo`000_oo00@00?ooool002oo
o`005?oo0`00<Ooo00<00?ooool0EOoo00<00?ooool07Ooo00<00?ooool02ooo00<00?ooool00P00
0_oo00D00?ooooooo`0000;oo`03003ooooo00Soo`04003ooooo0002ool01000ooooo`00;ooo000G
ool2000_ool00`00ooooo`1Eool00`00ooooo`0Mool00`00ooooo`0<ool01P00ool00000ool000?o
o`@000coo`<000?oo`<002ooo`006Ooo0P00;_oo00<00?ooool0E?oo00<00?ooool07Ooo00<00?oo
ool03Ooo10005_oo00<00?ooool0<ooo000Kool3000[ool00`00ooooo`1Dool00`00ooooo`0Mool0
0`00ooooo`0>ool2000Gool00`00ooooo`0cool001goo`<002[oo`03003ooooo05?oo`03003ooooo
01goo`03003ooooo00koo`8001Koo`8003Goo`008?oo0P00:?oo00<00?ooool0Dooo00<00?ooool0
7Ooo00<00?ooool03_oo0P00COoo000Bool3000=ool3000Vool00`00ooooo`23ool2001=ool001?o
o`03003oo`0000<000_oo`<002Coo`03003ooooo08Coo`03003ooooo04_oo`004ooo00@00?ooool0
013oo`8002?oo`03003ooooo08?oo`03003ooooo04_oo`004Ooo0`000ooo00<00?ooool03ooo0`00
8?oo00<00?ooool0Pooo0P00C?oo000@ool01000ooooo`001?oo00<00?ooool04?oo0`007ooo00<0
0?ooool0D?oo00<00?ooool07Ooo00<00?ooool04?oo00<00?ooool00P00B?oo000@ool01P00oooo
o`00ool000;oo`03003ooooo01?oo`8001goo`03003ooooo053oo`03003ooooo01goo`03003ooooo
017oo`<004Woo`004?oo00@00?ooool000;oo`8001Soo`<001_oo`03003ooooo04ooo`03003ooooo
01goo`03003ooooo05goo`004?oo00@00?ooool001koo`<001Woo`03003ooooo04ooo`03003ooooo
01goo`03003ooooo05goo`004Ooo0`008Ooo0P006?oo00<00?ooool0C_oo00<00?ooool07Ooo00<0
0?ooool0GOoo000gool3000Eool00`00ooooo`1>ool00`00ooooo`0Mool00`00ooooo`1Mool003Wo
o`<001Coo`03003ooooo0<goo`00??oo0P004_oo00<00?ooool0cOoo000nool3000@ool00`00oooo
o`3<ool0043oo`<000koo`03003ooooo0<coo`00@ooo0P003Ooo00<00?ooool0Booo00<00?ooool0
7Ooo00<00?ooool0GOoo0015ool3000:ool00`00ooooo`1;ool00`00ooooo`0Mool00`00ooooo`1M
ool004Ooo`<000Woo`03003ooooo04[oo`03003ooooo01goo`03003ooooo05goo`00B_oo0P001ooo
00<00?ooool0B_oo00<00?ooool07Ooo00<00?ooool0GOoo001<ool20006ool00`00ooooo`19ool0
0`00ooooo`0Mool00`00ooooo`1Mool004koo`<000?oo`8004[oo`03003ooooo01goo`03003ooooo
05goo`00DOoo0P000_oo00<00?ooool0b?oo001Cool4002kool3000;ool005Gool<000Soo`00E_oo
00<00?ooool0aooo001Fool00`00ooooo`17ool00`00ooooo`0Mool00`00ooooo`1Mool005Koo`03
003ooooo04Ooo`03003ooooo01goo`03003ooooo05goo`00E_oo00<00?ooool0Aooo00<00?ooool0
7Ooo00<00?ooool0GOoo001Fool00`00ooooo`17ool00`00ooooo`0Mool00`00ooooo`1Mool005Ko
o`03003ooooo04Ooo`03003ooooo01goo`03003ooooo05goo`00E_oo00<00?ooool0Aooo00<00?oo
ool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`2kool30009ool005Koo`03003ooooo0;coo`03
003ooooo00?oo`<000;oo`00E_oo00<00?ooool0_?oo00<00?ooool01?oo00<00?ooool00Ooo001F
ool00`00ooooo`2lool30004ool00`00ooooo`01ool005Koo`03003ooooo04Ooo`03003ooooo01go
o`03003ooooo05;oo`04003ooooo0003ool00`00ooooo`01ool005Koo`03003ooooo04Ooo`03003o
oooo01goo`03003ooooo05;oo`04003ooooo0003ool00`00ooooo`01ool005Koo`03003ooooo04Oo
o`03003ooooo01goo`03003ooooo05;oo`04003ooooo0002ool20003ool005Koo`03003ooooo04Oo
o`03003ooooo01goo`03003ooooo05;oo`04003ooooo0007ool005Koo`03003ooooo04Ooo`03003o
oooo01goo`03003ooooo057oo`@000Soo`00E_oo00<00?ooool0Aooo00<00?ooool07Ooo00<00?oo
ool0GOoo001Fool00`00ooooo`37ool005Koo`03003ooooo0<Ooo`00E_oo00<00?ooool0aooo001F
ool00`00ooooo`37ool005Koo`03003ooooo04Ooo`03003ooooo01goo`03003ooooo05goo`00E_oo
00<00?ooool0Aooo00<00?ooool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`17ool00`00oooo
o`0Mool00`00ooooo`1Mool005Koo`03003ooooo04Ooo`03003ooooo01goo`03003ooooo05goo`00
E_oo00<00?ooool0Aooo00<00?ooool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`17ool00`00
ooooo`0Mool00`00ooooo`1Mool005Koo`03003ooooo0<Ooo`00E_oo00<00?ooool0aooo001Fool0
0`00ooooo`37ool005Koo`03003ooooo03Coo`P008_oo`00E_oo00<00?ooool0<_oo0`001ooo0`00
2?oo00<00?ooool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`0`ool2000=ool00`00ooooo`05
ool00`00ooooo`0Mool00`00ooooo`1Mool005Koo`03003ooooo02ooo`03003ooooo00koo`03003o
oooo00Coo`03003ooooo01goo`03003ooooo05goo`00E_oo00<00?ooool0;_oo00<00?ooool04?oo
0P001?oo00<00?ooool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`0]ool00`00ooooo`0Cool0
1@00oooooooo00007ooo00<00?ooool0GOoo001Fool00`00ooooo`0/ool00`00ooooo`0Eool01000
ooooo`007ooo00<00?ooool0GOoo001Fool00`00ooooo`0[ool00`00ooooo`0Gool00`00ooooo`1o
ool005Koo`03003ooooo02[oo`03003ooooo01Soo`03003ooooo07ooo`00E_oo00<00?ooool0:_oo
00<00?ooool06Ooo00<00?ooool0O_oo001Fool00`00ooooo`0Yool00`00ooooo`0Jool00`00oooo
o`1nool005Koo`03003ooooo02Woo`03003ooooo01_oo`03003ooooo01goo`03003ooooo05goo`00
E_oo00<00?ooool0:?oo0P007Ooo00<00?ooool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`0X
ool00`00ooooo`0Lool00`00ooooo`0Mool00`00ooooo`1Mool005Koo`03003ooooo02Soo`03003o
oooo01coo`03003ooooo01goo`03003ooooo05goo`00E_oo00<00?ooool0:?oo00<00?ooool07?oo
00<00?ooool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`0Xool00`00ooooo`0Lool00`00oooo
o`0Mool00`00ooooo`1Mool005Koo`03003ooooo02Soo`03003ooooo01coo`03003ooooo07goo`00
E_oo00<00?ooool0:?oo00<00?ooool07?oo00<00?ooool0OOoo001Fool00`00ooooo`0Xool00`00
ooooo`0Lool00`00ooooo`1mool005Koo`03003ooooo02Soo`8001goo`03003ooooo07goo`00E_oo
00<00?ooool0:?oo0P007Ooo00<00?ooool07Ooo00<00?ooool0GOoo001Fool00`00ooooo`0Xool2
000Lool3000Nool00`00ooooo`1Mool005Koo`03003ooooo02Soo`03003oo`0001_oo`<001koo`03
003ooooo05goo`00E_oo00<00?ooool0:?oo00<00?oo00006_oo00@00?oo000001koo`03003ooooo
05goo`00E_oo00<00?ooool0:Ooo00<00?oo00006Ooo00@00?oo000001koo`03003ooooo05goo`00
E_oo00<00?ooool0:Ooo00@00?ooool001Ooo`03003ooooo008001koo`03003ooooo05goo`00E_oo
00<00?ooool0:Ooo00D00?ooooooo`0001Goo`03003ooooo00;oo`03003ooooo07coo`00E_oo00<0
0?ooool0:Ooo00<00?ooool00_oo00<00?ooool04?oo0P001Ooo00<00?ooool0O?oo001Fool00`00
ooooo`0Yool00`00ooooo`03ool00`00ooooo`0>ool00`00ooooo`05ool00`00ooooo`1lool005Ko
o`03003ooooo02Woo`03003ooooo00Coo`8000goo`03003ooooo00Koo`8007goo`00E_oo00<00?oo
ool0:Ooo00<00?ooool01_oo0`001ooo0`002?oo00<00?oo00007Ooo00<00?ooool0GOoo001Fool0
0`00ooooo`0Yool00`00ooooo`08ool8000;ool00`00ool0000Mool00`00ooooo`1Mool005Koo`03
003ooooo02Woo`03003ooooo01_oo`03003oo`0001goo`03003ooooo05goo`00E_oo00<00?ooool0
:Ooo00<00?ooool06ooo00@00?oo000001coo`03003ooooo05goo`00E_oo00<00?ooool0:Ooo00<0
0?ooool06ooo00@00?ooool001coo`03003ooooo05goo`00E_oo00<00?ooool0:_oo00<00?ooool0
6_oo00@00?ooool001coo`03003ooooo05goo`00E_oo00<00?ooool0:_oo00<00?ooool07Ooo00<0
0?ooool0N_oo001Fool00`00ooooo`0Zool00`00ooooo`0Nool00`00ooooo`1iool005Koo`03003o
oooo02[oo`03003ooooo01koo`03003ooooo07Woo`00E_oo00<00?ooool0:ooo00<00?ooool07Ooo
00<00?ooool0NOoo001Fool00`00ooooo`0[ool00`00ooooo`0Iool01000oooooooo0P006_oo00<0
0?ooool0GOoo001Fool00`00ooooo`0[ool00`00ooooo`0Iool00`00ooooo`02ool00`00ooooo`0H
ool00`00ooooo`1Mool005Koo`03003ooooo02coo`03003ooooo01Soo`03003ooooo00;oo`03003o
oooo01Soo`03003ooooo05goo`00E_oo00<00?ooool0;?oo00<00?ooool06?oo00<00?ooool00_oo
00<00?ooool06?oo00<00?ooool0GOoo001Fool00`00ooooo`0/ool00`00ooooo`0Hool00`00oooo
o`02ool2000Iool00`00ooooo`1Mool005Koo`03003ooooo02coo`03003ooooo01Soo`03003ooooo
00?oo`03003ooooo01Ooo`03003ooooo05goo`00E_oo00<00?ooool0;Ooo00<00?ooool07Ooo00<0
0?ooool0Mooo001Fool00`00ooooo`0]ool00`00ooooo`0Nool00`00ooooo`1fool005Koo`03003o
oooo02goo`03003ooooo01koo`03003ooooo07Koo`00E_oo00<00?ooool0;Ooo00<00?ooool07ooo
00<00?ooool0MOoo001Fool00`00ooooo`0^ool00`00ooooo`0Fool00`00ooooo`05ool2000Fool0
0`00ooooo`1Mool005Koo`03003ooooo02koo`03003ooooo01Koo`03003ooooo00Koo`03003ooooo
01Coo`03003ooooo05goo`00E_oo00<00?ooool0;ooo00<00?ooool05Ooo00<00?ooool01_oo0P00
5Ooo00<00?ooool0GOoo001Fool00`00ooooo`0_ool00`00ooooo`0Eool00`00ooooo`07ool00`00
ooooo`0Cool00`00ooooo`1Mool005Koo`03003ooooo02ooo`03003ooooo01Goo`03003ooooo00So
o`03003ooooo01;oo`03003ooooo05goo`00E_oo00<00?ooool0<?oo00<00?ooool05?oo00<00?oo
ool02?oo00<00?ooool04_oo00<00?ooool0GOoo001Fool00`00ooooo`0`ool00`00ooooo`0Pool0
0`00ooooo`1aool005Koo`03003ooooo037oo`03003ooooo023oo`03003ooooo073oo`00E_oo00<0
0?ooool0<Ooo00<00?ooool08?oo00<00?ooool0L?oo001Fool00`00ooooo`0aool00`00ooooo`0Q
ool00`00ooooo`1_ool005Koo`03003ooooo03;oo`03003ooooo01;oo`03003ooooo00coo`03003o
oooo00koo`03003ooooo05goo`00E_oo00<00?ooool0<_oo00<00?ooool04_oo00<00?ooool03?oo
00<00?ooool03_oo00<00?ooool0GOoo001Fool00`00ooooo`0cool00`00ooooo`0Aool00`00oooo
o`0=ool00`00ooooo`0=ool00`00ooooo`1Mool005Koo`03003ooooo03?oo`03003ooooo017oo`03
003ooooo00koo`03003ooooo00coo`03003ooooo05goo`00E_oo00<00?ooool0<ooo0P004_oo00<0
0?ooool03_oo00<00?ooool03?oo00<00?ooool0GOoo001Fool00`00ooooo`0dool00`00ooooo`0@
ool00`00ooooo`0?ool00`00ooooo`0;ool00`00ooooo`1Mool005Koo`03003ooooo03Coo`8002Co
o`03003ooooo06[oo`00E_oo00<00?ooool0=Ooo00<00?ooool08ooo00<00?ooool0JOoo001Fool0
0`00ooooo`0fool00`00ooooo`0Sool00`00ooooo`1Xool002Koo`H000Coo`H000Coo`H000Coo`H0
00Coo`H000;oo`03003oo`0000D000Coo`H000Coo`H000Coo`H000Coo`H000Coo`H000Coo`H000Co
o`H000Coo`X000Coo`03003ooooo06Ooo`009?oo0P0000?oo`000000;Ooo00<00?ooool0=ooo00<0
0?ooool03Ooo00<00?ooool02Ooo0P002Ooo00<00?ooool01_oo00<00?ooool0GOoo000Sool20004
ool2000[ool00`00ooooo`0gool00`00ooooo`0=ool00`00ooooo`0Cool30007ool00`00ooooo`1M
ool002;oo`03003ooooo00Goo`8002[oo`03003ooooo03Soo`03003ooooo00coo`03003ooooo00Co
o`03003ooooo00goo`<000Koo`03003ooooo05goo`008Ooo0P002?oo0P00:Ooo00<00?ooool0>Ooo
00<00?ooool02ooo00<00?ooool00ooo00<00?ooool04?oo0P001Ooo00<00?ooool0GOoo000Qool0
0`00ooooo`08ool00`00ooooo`0Wool00`00ooooo`0iool2000<ool00`00ooooo`02ool00`00oooo
o`0Cool20003ool00`00ooooo`1Mool0023oo`8000[oo`8002Soo`03003ooooo03[oo`03003ooooo
00[oo`05003oooooool0000Gool20002ool00`00ooooo`1Mool0023oo`03003ooooo00[oo`03003o
oooo02Koo`03003ooooo03_oo`03003ooooo00coo`03003ooooo01Ooo`03003ooooo063oo`008?oo
00<00?ooool02_oo00<00?ooool09_oo00<00?ooool0??oo00<00?ooool02_oo0P006_oo0P00H?oo
000Oool00`00ooooo`0;ool00`00ooooo`0Vool00`00ooooo`0lool00`00ooooo`0:ool00`00oooo
o`0Iool00`00ool0001Oool001ooo`03003ooooo00_oo`03003ooooo02Koo`03003ooooo03goo`03
003ooooo02Goo`800003ool0000005goo`007ooo00<00?ooool02ooo00<00?ooool09_oo00<00?oo
ool0?Ooo00<00?ooool01ooo00<00?ooool07?oo0P000_oo0P00Fooo000Nool00`00ooooo`09ool5
000Wool00`00ooooo`0nool00`00ooooo`06ool00`00ooooo`0Lool20003ool3001Iool001koo`03
003ooooo00[oo`04003ooooo000Wool00`00ooooo`0oool00`00ooooo`05ool00`00ooooo`0Mool0
0`00ooooo`03ool2001Hool001koo`04003oooooool30003ool300001?oo003oo`009ooo00<00?oo
ool0?ooo0P001_oo00<00?ooool07Ooo00<00?ooool01Ooo0P00E_oo000Nool00`00ooooo`02ool0
0`00ooooo`03ool01000oooooooo0P009ooo00<00?ooool0@?oo00<00?ooool01?oo00<00?ooool0
7Ooo00<00?ooool01ooo00<00?ooool0Dooo000Nool20004ool01`00oooooooo003oo`0000;oo`80
02Ooo`03003ooooo047oo`03003ooooo00?oo`03003ooooo01goo`03003ooooo00Soo`8005?oo`00
7_oo0P001?oo1@000_oo0P0000?oo`00ool09_oo00<00?ooool0@_oo00<00?ooool00_oo00<00?oo
ool07Ooo00<00?ooool02_oo0`00D?oo000Mool30004ool01@00oooooooo00001Ooo00<00?ooool0
9Ooo00<00?ooool0@ooo00D00?ooooooo`0001ooo`03003ooooo00coo`<004koo`007_oo00<00?oo
ool01?oo00<00?oo00001_oo00<00?ooool09Ooo00<00?ooool0A?oo00<00?ooool08?oo00<00?oo
ool03ooo0P00C?oo000Nool00`00ooooo`04ool00`00ool00006ool00`00ooooo`0Uool00`00oooo
o`15ool00`00ooooo`0Oool00`00ooooo`0Aool30019ool001koo`8000Koo`03003ooooo00Coo`80
02Ooo`03003ooooo04Koo`03003ooooo01koo`03003ooooo01?oo`D004Goo`007ooo00<00?ooool0
1?oo00<00?ooool01?oo00<00?ooool09_oo00<00?ooool0A_oo0P007_oo00<00?ooool06?oo1@00
@Ooo000Oool00`00ooooo`06ool00`00ooooo`02ool00`00ooooo`0Vool00`00ooooo`17ool00`00
ool0000Lool00`00ooooo`0Lool5000mool0023oo`03003ooooo00?oo`8000Goo`03003ooooo02Ko
o`03003ooooo04Soo`03003oo`0001[oo`03003ooooo027oo`d00003ool00?oo02koo`008?oo00@0
0?ooooooo`@000Goo`03003ooooo02Koo`03003ooooo04Woo`<001Woo`03003ooooo02goo`P002[o
o`008?oo00<00?ooool00_oo0P001_oo00<00?ooool09_oo00<00?ooool0B_oo0P006?oo0P00=_oo
0`00:?oo000Qool01000ooooo`001ooo00<00?ooool09ooo00<00?ooool0C?oo00<00?ooool04ooo
0`00>_oo0P009_oo000Qool30008ool00`00ooooo`0Wool00`00ooooo`1=ool2000Aool4000mool0
0`00ooooo`0Sool0027oo`8000Soo`03003ooooo02Soo`03003ooooo04koo`80013oo`<000ooo`03
003ooooo02goo`03003ooooo02;oo`008?oo10001_oo00<00?ooool0:Ooo00<00?ooool0Cooo0P00
3_oo0P002_oo10000ooo00<00?ooool0;_oo00<00?ooool08Ooo000Oool20002ool20004ool00`00
ooooo`0Zool00`00ooooo`1@ool3000:ool2000;ool20002ool20002ool00`00ooooo`0_ool00`00
ooooo`0Pool001koo`8000Coo`P000Coo`H000Coo`H000Coo`H000Coo`H000;oo`03003oo`0000D0
00Coo`H000Coo`H000Coo`H000Coo`H000Coo`H000Coo`H000Coo`H000Coo`l000coo`03003ooooo
00;oo`04003oo`00000aool00`00ooooo`0Pool001goo`8003Ooo`03003ooooo05?oo`8001Coo`03
003ooooo00Koo`03003ooooo033oo`03003ooooo01ooo`007?oo00<00?ooool0=ooo00<00?ooool0
EOoo00<00?ooool04Ooo00<00?ooool0>Ooo00<00?ooool07ooo000Kool00`00ooooo`0hool00`00
ooooo`1Fool2000Aool00`00ooooo`0jool00`00ooooo`0Nool001[oo`03003ooooo03Woo`03003o
oooo05Ooo`80017oo`03003ooooo00;oo`03003ooooo03Coo`03003ooooo01koo`006Ooo00<00?oo
ool0>_oo00<00?ooool0FOoo00<00?ooool03_oo0P000_oo0P00=_oo00<00?ooool07_oo001Fool0
0`00ooooo`1Jool2000?ool300000ooo003oo`0eool2000Oool000goo`<004Koo`03003ooooo05_o
o`8004[oo`03003ooooo01goo`003?oo0P000_oo00<00?ooool0@ooo00<00?ooool0GOoo00<00?oo
ool0Aooo00<00?ooool07Ooo000@ool20014ool00`00ooooo`1Nool20017ool00`00ooooo`0Mool0
017oo`03003ooooo04;oo`03003ooooo063oo`8004Goo`03003ooooo01goo`004Ooo0P00@ooo00<0
0?ooool0H_oo0P00@_oo00<00?ooool07_oo000Aool20013ool00`00ooooo`1Tool20010ool00`00
ooooo`0Nool0017oo`8004?oo`03003ooooo06Koo`<003goo`03003ooooo01koo`004Ooo0P007ooo
10008?oo00<00?ooool0JOoo0P00>_oo00<00?ooool07ooo000@ool40004ool3000Dool300000ooo
003oo`0Qool00`00ooooo`1[ool3000gool00`00ooooo`0Oool000ooo`06003oo`00003oo`001?oo
00<00?ooool00_oo10003_oo00D00?ooooooo`00027oo`03003ooooo06koo`8003Coo`03003ooooo
023oo`003_oo00<00?ooool00P000_oo00D00?ooooooo`0000Goo`03003ooooo00koo`03003ooooo
00;oo`03003ooooo01koo`03003ooooo073oo`<0037oo`03003ooooo023oo`003Ooo00@00?oooooo
o`8000?oo`03003ooooo00<000Coo`03003ooooo00Goo`800004ool00?ooool300001Ooo003ooooo
00008?oo00<00?ooool0Looo0P00;_oo00<00?ooool08Ooo000=ool01000oooooooo0P000ooo00@0
0?ooool000;oo`03003ooooo00;oo`03003ooooo00?oo`04003ooooo0002ool01000ooooo`000_oo
0P008Ooo00<00?ooool0MOoo1000:Ooo00<00?ooool08_oo000=ool01000oooooooo0P000ooo00@0
0?ooool000;oo`03003oo`0000;oo`03003ooooo00?oo`04003ooooo0002ool01000ooooo`009Ooo
00<00?ooool0NOoo10009?oo00<00?ooool08ooo000=ool01000oooooooo0P000ooo00@00?ooool0
00;oo`03003ooooo008000Koo`04003ooooo0002ool01000ooooo`009Ooo00<00?ooool0OOoo0P00
8Ooo00<00?ooool09?oo000>ool00`00ooooo`020002ool01@00oooooooo00000_oo00<00?ooool0
2?oo00@00?ooool000;oo`04003ooooo000Uool00`00ooooo`1oool5000Jool2000Wool000ooo`06
003oo`00003oo`000ooo10003?oo0`000ooo0`009Ooo00<00?ooool0Pooo30002_oo1@00:Ooo000@
ool4000Fool00`00ooooo`0Yool00`00ooooo`2>ool<000]ool0017oo`8001Ooo`03003ooooo02Wo
o`03003ooooo0<Ooo`004Ooo0P005_oo0P00:ooo00<00?ooool0aooo000Aool20013ool00`00oooo
o`37ool0017oo`8004?oo`03003ooooo0<Ooo`004_oo00<00?ooool0@Ooo00<00?ooool0aooo000B
ool00`00ooooo`11ool00`00ooooo`37ool001;oo`8004;oo`03003ooooo0<Ooo`004ooo00<00?oo
ool00P00?_oo00<00?ooool0aooo000Dool3000oool00`00ooooo`37ool005Koo`03003ooooo0<Oo
o`00E_oo00<00?ooool0aooo001Fool00`00ooooo`37ool005Koo`03003ooooo0<Ooo`00E_oo00<0
0?ooool0aooo001Fool00`00ooooo`37ool005Koo`03003ooooo0<Ooo`00E_oo00<00?ooool0aooo
001Fool00`00ooooo`37ool005Koo`03003ooooo0<Ooo`00E_oo00<00?ooool0aooo001Eool20039
ool004Koo`<000coo`800<Woo`00Aooo00<00?ooool00_oo10001Ooo0P00bOoo0017ool00`00oooo
o`03ool00`00ooooo`06ool00`00ooooo`37ool004Ooo`<000Coo`03003ooooo00Goo`03003ooooo
0<Ooo`00Aooo00@00?ooool000Coo`03003ooooo0<koo`00Aooo00H00?ooool00?oo0002ool00`00
ooooo`3>ool004Ooo`04003ooooo0002ool2003Aool004Ooo`04003ooooo003Eool004Koo`@00=Ko
o`00oooo8Ooo003ooolQool00001\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {632.812, 274.062}} -> {-145.549, \
384.549, 1.78129, 1.81037}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partitioned Runge-Kutta methods", "Subsection"],

Cell[TextData[{
  "It is sometimes possible to integrate certain components of (",
  
  CounterBox["NumberedEquation", "ODEEquation"],
  ") using one Runge-Kutta method and other components using a different \
Runge-Kutta method. The overall ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " stage scheme is called a Partitioned Runge-Kutta method and the free \
parameters are represented by two Butcher tableaux:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{GridBox[{
            {" ", \(a\_11\), "\[CenterEllipsis]", \(a\_\(1  s\)\)},
            {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
              "\[VerticalEllipsis]"},
            {" ", \(a\_s1\), "\[CenterEllipsis]", \(a\_ss\)},
            {" ", \(b\_1\), "\[CenterEllipsis]", \(b\_s\)}
            },
          RowLines->{False, False, True},
          ColumnLines->{True, False}], "      ", GridBox[{
            {" ", \(A\_11\), "\[CenterEllipsis]", \(A\_\(1  s\)\)},
            {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
              "\[VerticalEllipsis]"},
            {" ", \(A\_s1\), "\[CenterEllipsis]", \(A\_ss\)},
            {" ", \(B\_1\), "\[CenterEllipsis]", \(B\_s\)}
            },
          RowLines->{False, False, True},
          ColumnLines->{True, False}]}], TraditionalForm]], "NumberedEquation",\

  CellTags->"PRKTableaux"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symplectic partitioned Runge-Kutta methods", "Subsection"],

Cell["\<\
For general Hamiltonian systems symplectic Runge-Kutta methods are \
necessarily implicit.\
\>", "Text"],

Cell[TextData[{
  "However, for separable Hamiltonians ",
  Cell[BoxData[
      \(TraditionalForm\`H(p, \ q, \ t)\  = \ T(p)\  + \ V(q, \ t)\)]],
  " there exists explicit schemes corresponding to symplectic partitioned \
Runge-Kutta methods."
}], "Text"],

Cell[TextData[{
  "Instead of (",
  
  CounterBox["NumberedEquation", "PRKTableaux"],
  ") the free parameters now take either the form:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{GridBox[{
            {" ", "0", "\[CenterEllipsis]", "0", "0"},
            {" ", \(b\_1\), "0", "\[CenterEllipsis]", "\[VerticalEllipsis]"},
            {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
              "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
            {" ", \(b\_1\), "\[CenterEllipsis]", \(b\_\(s - 1\)\), "0"},
            {" ", \(b\_1\), "\[CenterEllipsis]", \(b\_\(s - 1\)\), \(b\_s\)}
            },
          RowLines->{False, False, False, True},
          ColumnLines->{True, False}], "        ", GridBox[{
            {" ", \(B\_1\), "\[CenterEllipsis]", "0", "0"},
            {" ", \(B\_1\), \(B\_2\), "\[CenterEllipsis]", 
              "\[VerticalEllipsis]"},
            {" ", "\[VerticalEllipsis]", "\[VerticalEllipsis]", 
              "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
            {" ", \(B\_1\), \(B\_2\), "\[CenterEllipsis]", \(B\_s\)},
            {" ", \(B\_1\), \(B\_2\), "\[CenterEllipsis]", \(B\_s\)}
            },
          RowLines->{False, False, False, True},
          ColumnLines->{True, False}], " "}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"SPRKTableaux1"],

Cell["or the form:", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{GridBox[{
            {" ", \(b\_1\), "\[CenterEllipsis]", "0", "0"},
            {" ", \(b\_1\), \(b\_2\), "\[CenterEllipsis]", 
              "\[VerticalEllipsis]"},
            {" ", "\[VerticalEllipsis]", "\[VerticalEllipsis]", 
              "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
            {" ", \(b\_1\), \(b\_2\), "\[CenterEllipsis]", \(b\_s\)},
            {" ", \(b\_1\), \(b\_2\), "\[CenterEllipsis]", \(b\_s\)}
            },
          RowLines->{False, False, False, True},
          ColumnLines->{True, False}], "       ", GridBox[{
            {" ", "0", "\[CenterEllipsis]", "0", "0"},
            {" ", \(B\_1\), "0", "\[CenterEllipsis]", "\[VerticalEllipsis]"},
            {" ", "\[VerticalEllipsis]", "\[DescendingEllipsis]", 
              "\[DescendingEllipsis]", "\[VerticalEllipsis]"},
            {" ", \(B\_1\), "\[CenterEllipsis]", \(B\_\(s - 1\)\), "0"},
            {" ", \(B\_1\), "\[CenterEllipsis]", \(B\_\(s - 1\)\), \(B\_s\)}
            },
          RowLines->{False, False, False, True},
          ColumnLines->{True, False}]}], TraditionalForm]], "NumberedEquation",\

  CellTags->"SPRKTableaux2"],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`2  d\)]],
  " free parameters of (",
  
  CounterBox["NumberedEquation", "SPRKTableaux2"],
  ") are sometimes represented using the shorthand notation ",
  Cell[BoxData[
      \(TraditionalForm\`\([b\_1, \[Ellipsis], 
          b\_s]\) \((B\_1, \[Ellipsis]B\_s)\)\)]],
  "."
}], "Text"],

Cell["\<\
The differential system for a separable Hamiltonian system can be \
written as:\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`dp\_i\/dt = \(f(q, 
          t) = \(-\(\[PartialD]\(V(q, 
                  t)\)\/\[PartialD]q\_i\)\)\), \ \ \ \ dq\_i\/dt = \(g(
          p) = \[PartialD]\(T(p)\)\/\[PartialD]p\_i\), \ \ \ \ i = 
      1, \[Ellipsis], \(\(d\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "In general the force evaluations ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[PartialD]\(V(q, t)\)\)/\[PartialD]q\)]],
  " are computationally dominant and (",
  
  CounterBox["NumberedEquation", "SPRKTableaux2"],
  ") is preferred over (",
  
  CounterBox["NumberedEquation", "SPRKTableaux1"],
  ") since it is possible to save one force evaluation per time step when \
dense output is required."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard algorithm", "Subsection"],

Cell[TextData[{
  "The structure of (",
  
  CounterBox["NumberedEquation", "SPRKTableaux2"],
  ") permits a particularly simple implementation (see for example [",
  ButtonBox["SC94",
    ButtonData:>{"References.nb", "SC94"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"],

Cell[TextData[{
  StyleBox["Algorithm 1",
    FontWeight->"Bold"],
  " (Standard SPRK)"
}], "Text"],

Cell[BoxData[{
    FormBox[\(P\_0 = \ p\_n\), TraditionalForm], "\n", 
    FormBox[
      RowBox[{
        FormBox[\(Q\_1 = \ q\_n\),
          "TraditionalForm"], "\[IndentingNewLine]"}], 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[\(for\ i\  = \ 1, \[Ellipsis], s\), 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[
      RowBox[{
        "\t", \(P\_i = 
          P\_\(i - 1\) + \ \(h\_\(n + 1\)\) \(b\_i\) \(f \((Q\_i, 
                  t\_n + \ \(C\_i\) h\_\(n + 1\))\)\)\)}], 
      TraditionalForm], "\n", 
    FormBox[
      RowBox[{
        FormBox[\(\(\t\)\(Q\_\(i + 1\) = 
            Q\_i + \ \(h\_\(n + 1\)\) \(B\_i\) \(g(P\_i)\)\)\),
          "TraditionalForm"], "\n"}], TraditionalForm], "\[IndentingNewLine]",
   
    FormBox[\(Return\ p\_\(n + 1\) = \(\(P\_s\) 
            and\ q\_\(n + 1\) = \(\(Q\_\(s + 1\)\)\(.\)\)\)\), 
      TraditionalForm]}], "DisplayFormula"],

Cell[TextData[{
  "The time-weights are given by: ",
  Cell[BoxData[
      \(TraditionalForm\`C\_j = \ \[Sum]\+\(i = 1\)\%\(j - 1\)B\_i, \ 
      j\  = \ 1, \[Ellipsis], \(\(s\)\(.\)\)\)]]
}], "Text"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`B\_s = 0\)]],
  " then Algorithm 1 effectively reduces to an ",
  Cell[BoxData[
      \(TraditionalForm\`s - 1\)]],
  " stage scheme since it has the First Same As Last (FSAL) property."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["This loads some useful packages.", "Text"],

Cell[BoxData[{
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Needs["\<DifferentialEquations`NDSolveUtilities`\>"];\)\)}], "Input",
  CellLabel->"In[1]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["The Harmonic oscillator", "Subsubsection"],

Cell["\<\
The Harmonic oscillator is a simple Hamiltonian problem that models \
a material point attached to a spring. For simplicity we consider unit mass \
and spring constant for which the Hamiltonian is given in separable \
form:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        FormBox[\(H(p, q) = \(T(p)\  + \ V(q)\  = \ p\^2/2 + q\^2/2\)\),
          "TraditionalForm"]}], TraditionalForm]], "DisplayFormula"],

Cell["The equations of motion are given by:", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{
          
          FormBox[\(dp\/dt = \(\(-\(\[PartialD]H\/\[PartialD]q\)\) = \(-q\)\)\
\),
            "TraditionalForm"], ",", "    ", 
          FormBox[\(dq\/dt = \(\[PartialD]H\/\[PartialD]p = p\)\),
            "TraditionalForm"], ",", "    ", 
          FormBox[\(q(0) = 1\),
            "TraditionalForm"], ",", "    ", 
          RowBox[{
            FormBox[\(p(0) = 0\),
              "TraditionalForm"], "."}]}]}], 
      TraditionalForm]]]], "NumberedEquation",
  CellTags->"HarmonicOscillator"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input", "Subsubsection"],

Cell[BoxData[{
    \(\(system\  = \ 
        GetNDSolveProblem["\<HarmonicOscillator\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(eqs\  = \ {system["\<System\>"[]], 
          system["\<InitialConditions\>"[]]};\)\), "\[IndentingNewLine]", 
    \(\(vars\  = \ 
        system["\<DependentVariables\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(H\  = \ system["\<Invariants\>"[]];\)\), "\[IndentingNewLine]", 
    \(\(time\  = \ {T, \ 0, \ 100};\)\), "\[IndentingNewLine]", 
    \(\(step\  = \ 1/25;\)\)}], "Input",
  CellLabel->"In[7]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Explicit Euler method", "Subsubsection"],

Cell["\<\
Numerically integrate the equations of motion for the Harmonic \
oscillator using the explicit Euler method.\
\>", "Text"],

Cell[BoxData[
    \(\(solee\  = \ 
        NDSolve[eqs, vars, time, \ Method \[Rule] ExplicitEuler, \ 
          StartingStepSize \[Rule] step, 
          MaxSteps \[Rule] Infinity];\)\)], "Input",
  CellLabel->"In[13]:="],

Cell["\<\
Since the method is dissipative, the trajectory spirals into or \
away from the fixed point at the origin.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot[Evaluate[vars\  /. \ First[solee]], Evaluate[time], 
        PlotPoints \[Rule] 100];\)\)], "Input",
  CellLabel->"In[14]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.514902 0.070057 0.299761 0.0419574 [
[.09456 .28726 -6 -9 ]
[.09456 .28726 6 0 ]
[.23467 .28726 -6 -9 ]
[.23467 .28726 6 0 ]
[.37479 .28726 -6 -9 ]
[.37479 .28726 6 0 ]
[.65502 .28726 -3 -9 ]
[.65502 .28726 3 0 ]
[.79513 .28726 -3 -9 ]
[.79513 .28726 3 0 ]
[.93524 .28726 -3 -9 ]
[.93524 .28726 3 0 ]
[.5024 .04802 -12 -4.5 ]
[.5024 .04802 0 4.5 ]
[.5024 .13193 -12 -4.5 ]
[.5024 .13193 0 4.5 ]
[.5024 .21585 -12 -4.5 ]
[.5024 .21585 0 4.5 ]
[.5024 .38368 -6 -4.5 ]
[.5024 .38368 0 4.5 ]
[.5024 .46759 -6 -4.5 ]
[.5024 .46759 0 4.5 ]
[.5024 .55151 -6 -4.5 ]
[.5024 .55151 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.09456 .29976 m
.09456 .30601 L
s
[(-6)] .09456 .28726 0 1 Mshowa
.23467 .29976 m
.23467 .30601 L
s
[(-4)] .23467 .28726 0 1 Mshowa
.37479 .29976 m
.37479 .30601 L
s
[(-2)] .37479 .28726 0 1 Mshowa
.65502 .29976 m
.65502 .30601 L
s
[(2)] .65502 .28726 0 1 Mshowa
.79513 .29976 m
.79513 .30601 L
s
[(4)] .79513 .28726 0 1 Mshowa
.93524 .29976 m
.93524 .30601 L
s
[(6)] .93524 .28726 0 1 Mshowa
.125 Mabswid
.12959 .29976 m
.12959 .30351 L
s
.16462 .29976 m
.16462 .30351 L
s
.19965 .29976 m
.19965 .30351 L
s
.2697 .29976 m
.2697 .30351 L
s
.30473 .29976 m
.30473 .30351 L
s
.33976 .29976 m
.33976 .30351 L
s
.40982 .29976 m
.40982 .30351 L
s
.44484 .29976 m
.44484 .30351 L
s
.47987 .29976 m
.47987 .30351 L
s
.54993 .29976 m
.54993 .30351 L
s
.58496 .29976 m
.58496 .30351 L
s
.61999 .29976 m
.61999 .30351 L
s
.69004 .29976 m
.69004 .30351 L
s
.72507 .29976 m
.72507 .30351 L
s
.7601 .29976 m
.7601 .30351 L
s
.83016 .29976 m
.83016 .30351 L
s
.86519 .29976 m
.86519 .30351 L
s
.90022 .29976 m
.90022 .30351 L
s
.05953 .29976 m
.05953 .30351 L
s
.0245 .29976 m
.0245 .30351 L
s
.97027 .29976 m
.97027 .30351 L
s
.25 Mabswid
0 .29976 m
1 .29976 L
s
.5149 .04802 m
.52115 .04802 L
s
[(-6)] .5024 .04802 1 0 Mshowa
.5149 .13193 m
.52115 .13193 L
s
[(-4)] .5024 .13193 1 0 Mshowa
.5149 .21585 m
.52115 .21585 L
s
[(-2)] .5024 .21585 1 0 Mshowa
.5149 .38368 m
.52115 .38368 L
s
[(2)] .5024 .38368 1 0 Mshowa
.5149 .46759 m
.52115 .46759 L
s
[(4)] .5024 .46759 1 0 Mshowa
.5149 .55151 m
.52115 .55151 L
s
[(6)] .5024 .55151 1 0 Mshowa
.125 Mabswid
.5149 .069 m
.51865 .069 L
s
.5149 .08997 m
.51865 .08997 L
s
.5149 .11095 m
.51865 .11095 L
s
.5149 .15291 m
.51865 .15291 L
s
.5149 .17389 m
.51865 .17389 L
s
.5149 .19487 m
.51865 .19487 L
s
.5149 .23683 m
.51865 .23683 L
s
.5149 .2578 m
.51865 .2578 L
s
.5149 .27878 m
.51865 .27878 L
s
.5149 .32074 m
.51865 .32074 L
s
.5149 .34172 m
.51865 .34172 L
s
.5149 .3627 m
.51865 .3627 L
s
.5149 .40465 m
.51865 .40465 L
s
.5149 .42563 m
.51865 .42563 L
s
.5149 .44661 m
.51865 .44661 L
s
.5149 .48857 m
.51865 .48857 L
s
.5149 .50955 m
.51865 .50955 L
s
.5149 .53053 m
.51865 .53053 L
s
.5149 .02704 m
.51865 .02704 L
s
.5149 .00606 m
.51865 .00606 L
s
.5149 .57248 m
.51865 .57248 L
s
.5149 .59346 m
.51865 .59346 L
s
.5149 .61444 m
.51865 .61444 L
s
.25 Mabswid
.5149 0 m
.5149 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.58496 .29976 m
.58497 .29851 L
.58492 .29736 L
.5848 .29605 L
.58464 .2948 L
.58442 .29365 L
.58417 .2926 L
.58346 .29022 L
.58249 .28785 L
.58118 .28528 L
.57769 .28026 L
.57326 .27565 L
.56746 .27108 L
.56107 .26723 L
.55453 .26415 L
.54617 .26116 L
.53784 .259 L
.53286 .25805 L
.52824 .25737 L
.52565 .25708 L
.52283 .25682 L
.52153 .25673 L
.52015 .25664 L
.51888 .25658 L
.51767 .25653 L
.51532 .25647 L
.51318 .25645 L
.51087 .25648 L
.50956 .25652 L
.50836 .25656 L
.50636 .25667 L
.50415 .25682 L
.50186 .25701 L
.49972 .25724 L
.49486 .25791 L
.49047 .25869 L
.48093 .26107 L
.47331 .26371 L
.46579 .26712 L
.45941 .27086 L
.4543 .27465 L
.44919 .27951 L
.44695 .28223 L
.44491 .2852 L
.44341 .28786 L
.4421 .29086 L
.44164 .2922 L
.44122 .29364 L
.44089 .29498 L
.44065 .29626 L
Mistroke
.44054 .29698 L
.44045 .29777 L
.44034 .29914 L
.44029 .29992 L
.44029 .30075 L
.44033 .30222 L
.44044 .30359 L
.44062 .30487 L
.44088 .30626 L
.44124 .30775 L
.44234 .31107 L
.44377 .31417 L
.44745 .31978 L
.45208 .32482 L
.45729 .32913 L
.46396 .33342 L
.47199 .33738 L
.48006 .34038 L
.48796 .3426 L
.49227 .34353 L
.49707 .34439 L
.49954 .34475 L
.50219 .34508 L
.50469 .34533 L
.50701 .34552 L
.50925 .34567 L
.51162 .34579 L
.51401 .34585 L
.51537 .34587 L
.51664 .34587 L
.51895 .34585 L
.52104 .34579 L
.52346 .34568 L
.52575 .34553 L
.52996 .34516 L
.53382 .34468 L
.54239 .34318 L
.54682 .34214 L
.5508 .34105 L
.55934 .33809 L
.56633 .33496 L
.57302 .33117 L
.57947 .32648 L
.58453 .32169 L
.58895 .31603 L
.59087 .31273 L
.59227 .30965 L
.59318 .30693 L
.59359 .30536 L
.5939 .30389 L
Mistroke
.59414 .30234 L
.59428 .30092 L
.59432 .30013 L
.59435 .29927 L
.59433 .2977 L
.59424 .29623 L
.59409 .2949 L
.59383 .29337 L
.59352 .29194 L
.59279 .28939 L
.59172 .28667 L
.59028 .28373 L
.58831 .28059 L
.58326 .2745 L
.57732 .26929 L
.57078 .26488 L
.56305 .2608 L
.5537 .25707 L
.54915 .25563 L
.54414 .25429 L
.5397 .25328 L
.5348 .25239 L
.53001 .25169 L
.52555 .25122 L
.52333 .25103 L
.52125 .25089 L
.51908 .25079 L
.5167 .2507 L
.51406 .25066 L
.51156 .25067 L
.50931 .25072 L
.50688 .25081 L
.50423 .25095 L
.50144 .25117 L
.49647 .2517 L
.49131 .25244 L
.4865 .25335 L
.47773 .2555 L
.46879 .25848 L
.45981 .26245 L
.45276 .26649 L
.44616 .2713 L
.44088 .27628 L
.43697 .28108 L
.4335 .287 L
.43221 .29006 L
.43162 .29184 L
.43118 .29347 L
.43088 .29489 L
.43062 .29643 L
Mistroke
.43042 .29806 L
.43032 .29961 L
.43031 .30106 L
.43036 .30259 L
.43046 .30391 L
.43065 .30535 L
.43097 .30713 L
.43138 .30882 L
.43238 .31197 L
.43385 .31531 L
.43588 .31889 L
.4406 .32506 L
.4462 .33043 L
.45321 .33556 L
.46198 .34046 L
.47125 .3444 L
.48051 .34735 L
.48936 .34942 L
.49455 .35034 L
.49948 .35103 L
.50217 .35132 L
.50474 .35155 L
.50709 .35174 L
.50959 .35188 L
.51232 .35198 L
.51484 .35203 L
.51756 .35205 L
.51911 .35202 L
.52057 .352 L
.52318 .3519 L
.52596 .35174 L
.52858 .35156 L
.53095 .35134 L
.53672 .35064 L
.5421 .34978 L
.5525 .34745 L
.56315 .34405 L
.57172 .34041 L
.57996 .3359 L
.58621 .33158 L
.59216 .32638 L
.59493 .32342 L
.59758 .32008 L
.59959 .31705 L
.60141 .31374 L
.60283 .3104 L
.60383 .30733 L
.60419 .30583 L
.60451 .3042 L
.60474 .30266 L
Mistroke
.60489 .30124 L
.60497 .29958 L
.60497 .2978 L
.60489 .29612 L
.60474 .29459 L
.60445 .2928 L
.60403 .29085 L
.60298 .28735 L
.60147 .28373 L
.59941 .27996 L
.59457 .27345 L
.58867 .26764 L
.58224 .26273 L
.57412 .25787 L
.56454 .25345 L
.55541 .25023 L
.54641 .2478 L
.54114 .2467 L
.53607 .24582 L
.53012 .24504 L
.52466 .24452 L
.52194 .24434 L
.51902 .2442 L
.51625 .24412 L
.51372 .24409 L
.51076 .2441 L
.50908 .24414 L
.50753 .24418 L
.50469 .24431 L
.50167 .24451 L
.49882 .24474 L
.49575 .24505 L
.49025 .24579 L
.48381 .24691 L
.47802 .24817 L
.46876 .25078 L
.4592 .25432 L
.45003 .25872 L
.44235 .26342 L
.43499 .26919 L
.42845 .27605 L
.42598 .27937 L
.42377 .28299 L
.42218 .28619 L
.42083 .28969 L
.4203 .29144 L
.41986 .29311 L
.41955 .29462 L
.41929 .29627 L
.41912 .29784 L
Mistroke
.419 .29951 L
.41898 .30109 L
.41902 .30252 L
.41914 .30435 L
.41935 .30604 L
.41969 .30788 L
.42014 .30983 L
.42114 .31308 L
.42262 .3166 L
.42447 .32012 L
.42693 .32386 L
.43249 .33039 L
.4392 .3363 L
.44646 .34131 L
.45532 .34612 L
.46619 .35065 L
.47201 .35259 L
.47854 .35441 L
.48443 .35576 L
.49087 .35696 L
.49721 .35787 L
.50305 .35846 L
.50589 .35868 L
.50898 .35886 L
.51191 .35897 L
.51461 .35903 L
.51777 .35905 L
.52072 .359 L
.52395 .35889 L
.52577 .35881 L
.52742 .35871 L
.53073 .35846 L
.53433 .35811 L
.54082 .35729 L
.54759 .35613 L
.5536 .35482 L
.56652 .35109 L
.5776 .34666 L
.58706 .34171 L
.59505 .33637 L
.60254 .32991 L
.60577 .32643 L
.60882 .32257 L
.61107 .31914 L
.61312 .31532 L
.61476 .31143 L
.61533 .3097 L
.61586 .30779 L
.61627 .3061 L
.6166 .30427 L
Mistroke
.61685 .30233 L
.61699 .30051 L
.61705 .29876 L
.61702 .29684 L
.61688 .29503 L
.61667 .29336 L
.61642 .2917 L
.61609 .2902 L
.61518 .28685 L
.61383 .28331 L
.61198 .27948 L
.60696 .27199 L
.60089 .26545 L
.59404 .25976 L
.58463 .25368 L
.5749 .24882 L
.56252 .24412 L
.55608 .24221 L
.54983 .24067 L
.54381 .23943 L
.53818 .2385 L
.53182 .23767 L
.52845 .23733 L
.52488 .23705 L
.52161 .23686 L
.51811 .23672 L
.5148 .23664 L
.51179 .23664 L
.50825 .2367 L
.50625 .23675 L
.5044 .23684 L
.50105 .23703 L
.49745 .2373 L
.49163 .23792 L
.48622 .23867 L
.4742 .241 L
.4679 .24263 L
.46207 .24439 L
.45165 .24827 L
.441 .25341 L
.43234 .25876 L
.4237 .26564 L
.41701 .27272 L
.41447 .27607 L
.41216 .27971 L
.41045 .28292 L
.40892 .28641 L
.40765 .29023 L
.40721 .29195 L
.4068 .29383 L
Mistroke
.40662 .29498 L
.40645 .29604 L
.40625 .29815 L
.40616 .30006 L
.40615 .3021 L
.40624 .30399 L
.40645 .30605 L
.4068 .3082 L
.40721 .3102 L
.40822 .31375 L
.40965 .31752 L
.41181 .32187 L
.41433 .32589 L
.42017 .33313 L
.42707 .33958 L
.4345 .34507 L
.44376 .35053 L
.45468 .35556 L
.46671 .35979 L
.47842 .36284 L
.48512 .36419 L
.49259 .36535 L
.49605 .36578 L
.49975 .36617 L
.50301 .36645 L
.50647 .36668 L
.51 .36684 L
.51325 .36694 L
.51676 .36699 L
.51875 .36697 L
.5206 .36695 L
.52397 .36685 L
.52703 .36672 L
.53055 .36651 L
.53388 .36623 L
.54 .36558 L
.54559 .36479 L
.55797 .36239 L
.57016 .35904 L
.58246 .35449 L
.59313 .34936 L
.60195 .34401 L
.61095 .33705 L
.6151 .33311 L
.61902 .32872 L
.62227 .32435 L
.62478 .32028 L
.62689 .31607 L
.62843 .31207 L
.6296 .30804 L
Mistroke
.63004 .30589 L
.63039 .30358 L
.63053 .30241 L
.63062 .30114 L
.63072 .29883 L
.63069 .29658 L
.63054 .29449 L
.63031 .29256 L
.63003 .29075 L
.62961 .28877 L
.62905 .28664 L
.62759 .28234 L
.62584 .27844 L
.62089 .27036 L
.61361 .262 L
.60403 .25395 L
.59349 .24724 L
.58179 .24149 L
.56778 .23633 L
.56097 .23435 L
.55354 .23254 L
.54695 .23123 L
.53974 .23006 L
.53265 .22921 L
.52926 .22889 L
.52609 .22865 L
.52292 .22846 L
.51946 .2283 L
.51639 .22822 L
.51312 .22819 L
.50928 .22821 L
.50711 .22825 L
.50512 .22832 L
.50146 .22848 L
.4976 .22874 L
.49095 .22936 L
.48372 .23029 L
.47631 .23154 L
.46841 .23321 L
.45461 .23711 L
.44204 .24188 L
.43134 .24708 L
.42096 .2535 L
.41111 .26142 L
.40685 .2657 L
.4028 .27048 L
.39975 .27482 L
.39702 .27957 L
.39487 .28427 L
.39339 .28861 L
Mistroke
.39284 .29072 L
.39234 .29302 L
.39198 .2952 L
.39176 .29722 L
.39161 .29957 L
.39157 .30178 L
.39166 .30419 L
.39179 .30555 L
.39192 .30679 L
.39211 .30808 L
.39231 .30927 L
.39289 .31196 L
.39435 .31683 L
.39625 .32143 L
.39851 .32567 L
.40517 .33502 L
.41369 .34355 L
.42495 .35193 L
.43639 .35843 L
.44823 .36367 L
.46232 .36844 L
.47845 .3723 L
.48688 .37375 L
.49138 .37437 L
.49621 .37492 L
.50045 .3753 L
.50271 .37546 L
.50514 .37563 L
.50738 .37574 L
.50943 .37583 L
.51345 .37594 L
.51759 .37598 L
.52143 .37595 L
.52564 .37583 L
.528 .37571 L
.53013 .3756 L
.53403 .37532 L
.53824 .37495 L
.54581 .37407 L
.55329 .3729 L
.56118 .37136 L
.57494 .3678 L
.59029 .36233 L
.6031 .35627 L
.61502 .34897 L
.62604 .34 L
.63443 .33073 L
.6377 .32602 L
.64027 .3216 L
.64225 .31736 L
Mistroke
.64399 .31264 L
.64469 .31016 L
.64522 .30784 L
.64567 .30538 L
.64586 .30401 L
.64601 .30274 L
.64618 .30041 L
.64622 .29787 L
.64615 .29563 L
.64598 .29327 L
.6457 .29115 L
.64535 .28917 L
.64429 .28469 L
.64348 .28218 L
.64244 .27945 L
.64018 .27455 L
.63449 .26562 L
.6256 .25578 L
.61537 .24738 L
.60344 .23989 L
.58882 .23289 L
.57361 .22744 L
.56597 .22529 L
.55866 .22353 L
.55129 .22207 L
.54448 .22094 L
.53679 .21995 L
.53248 .21951 L
.52847 .21919 L
.52455 .21895 L
.52039 .21876 L
.5162 .21863 L
.51382 .21861 L
.51158 .2186 L
.50755 .21865 L
.50386 .21876 L
.49961 .21895 L
.49558 .21921 L
.49132 .21957 L
.48674 .22005 L
.4785 .22114 L
.4706 .22251 L
.46345 .22401 L
.44775 .22832 L
.43226 .23414 L
.41999 .24013 L
.4096 .24646 L
.39957 .25416 L
.39057 .26316 L
.38669 .26804 L
Mistroke
.38316 .27339 L
.38059 .27812 L
.37838 .28334 L
.37738 .28628 L
.37663 .28899 L
.376 .29177 L
.37555 .29437 L
.3754 .29576 L
.37523 .29724 L
.37514 .29888 L
.37507 .30038 L
.37507 .30195 L
.37511 .30365 L
.37521 .30525 L
.37535 .30673 L
.37568 .30919 L
.37615 .31184 L
.37672 .31432 L
.37737 .31659 L
.37938 .32208 L
.38183 .32721 L
.38832 .3371 L
.39774 .34725 L
.40922 .35645 L
.42188 .3642 L
.43459 .37031 L
.44958 .37589 L
.46721 .38068 L
.47646 .38256 L
.48684 .38418 L
.49587 .38517 L
.50098 .38559 L
.50565 .38587 L
.51002 .38606 L
.51478 .38617 L
.51928 .38618 L
.52344 .38611 L
.52777 .38598 L
.53233 .38575 L
.5362 .38547 L
.54043 .38511 L
.54981 .38404 L
.55842 .38269 L
.57366 .37946 L
.5892 .3749 L
.60641 .36808 L
.62105 .36034 L
.63266 .35244 L
.64337 .34298 L
.65169 .33316 L
Mistroke
.65757 .32346 L
.66011 .31773 L
.66184 .31241 L
.66256 .30944 L
.6629 .30787 L
.66316 .30619 L
.66338 .30473 L
.66355 .30311 L
.66377 .30025 L
.66379 .29881 L
.66381 .29724 L
.66374 .2956 L
.66367 .29407 L
.66338 .29134 L
.66294 .28841 L
.66221 .28499 L
.66132 .28177 L
.65915 .2758 L
.65642 .27023 L
.65341 .26517 L
.6447 .2542 L
.63508 .2452 L
.6228 .23633 L
.60953 .22886 L
.59613 .22289 L
.57916 .21708 L
.56971 .21454 L
.55934 .21225 L
.54912 .21049 L
.53969 .20927 L
.53509 .2088 L
.53009 .20838 L
.52534 .20809 L
.52096 .20791 L
.51603 .20778 L
.51136 .20773 L
.50716 .20778 L
.50259 .20791 L
.49764 .20814 L
.49239 .20847 L
.48792 .20885 L
.48301 .20937 L
.47436 .21051 L
.46516 .21208 L
.44897 .21577 L
.43064 .22156 L
.41289 .22922 L
.39924 .23689 L
.38614 .24637 L
.37496 .25707 L
Mistroke
.37039 .26265 L
.36669 .26795 L
.36388 .27278 L
.36126 .2782 L
.35921 .28374 L
.35837 .28657 L
.3576 .28968 L
.35728 .29142 L
.35699 .29303 L
.3568 .29458 L
.3566 .29623 L
.35639 .29938 L
.35636 .30224 L
.35638 .30399 L
.35649 .3056 L
.35663 .30736 L
.35686 .30922 L
.35734 .31235 L
.35809 .31576 L
.35995 .3218 L
.36265 .32818 L
.36935 .33936 L
.37378 .34504 L
.37918 .35087 L
.39053 .36073 L
.40497 .37032 L
.42324 .37949 L
.4407 .38603 L
.4504 .38893 L
.46094 .39154 L
.47045 .39349 L
.48107 .3952 L
.49088 .39637 L
.49526 .39679 L
.5001 .39715 L
.50541 .39745 L
.50832 .39758 L
.51104 .39765 L
.51591 .39774 L
.52115 .39774 L
.52408 .39768 L
.52728 .39761 L
.53029 .39747 L
.53308 .39735 L
.53834 .397 L
.54392 .39653 L
.55393 .39539 L
.56321 .39397 L
.57335 .39203 L
.5838 .38956 L
Mistroke
.60128 .38424 L
.61631 .37827 L
.63122 .3708 L
.64579 .36146 L
.65879 .35055 L
.66874 .33935 L
.67563 .32869 L
.6786 .32248 L
.68076 .31665 L
.68165 .31361 L
.68243 .31032 L
.68299 .3072 L
.68338 .30433 L
.68366 .30098 L
.68371 .29908 L
.68375 .29731 L
.68363 .29408 L
.68349 .29227 L
.68331 .29063 L
.68278 .28706 L
.68212 .28379 L
.68119 .28022 L
.67997 .27646 L
.67738 .27021 L
.67376 .26347 L
.6647 .251 L
.65359 .23992 L
.64167 .23075 L
.62681 .22173 L
.60862 .21325 L
.58738 .20589 L
.56797 .20107 L
.5565 .19898 L
.54553 .19744 L
.54042 .19687 L
.53492 .19637 L
.53014 .19603 L
.52495 .19573 L
.52176 .19561 L
.51882 .19551 L
.51303 .19542 L
.50776 .19544 L
.50218 .19557 L
.49673 .19579 L
.4909 .19614 L
.48541 .19658 L
.48041 .19709 L
.46831 .19867 L
.457 .20062 L
.43789 .20512 L
Mistroke
.42105 .21048 L
.40376 .21759 L
.387 .22646 L
.37111 .23744 L
.35881 .2486 L
.34806 .26184 L
.34384 .26883 L
.34015 .27667 L
.3388 .28029 L
.3377 .28373 L
.33687 .28688 L
.33618 .29024 L
.33588 .29198 L
.33563 .29391 L
.3353 .2973 L
.33517 .29922 L
.33513 .30128 L
.33513 .30322 L
.33519 .30501 L
.33543 .3084 L
.33584 .31154 L
.33646 .31498 L
.33731 .31864 L
.33942 .32537 L
.34199 .33139 L
.34943 .34406 L
.35414 .35023 L
.36009 .35678 L
.37255 .36786 L
.38586 .37712 L
.4037 .38687 L
.42512 .39566 L
.43525 .39899 L
.44667 .40215 L
.45696 .40454 L
.4683 .4067 L
.47983 .4084 L
.48493 .40902 L
.49055 .4096 L
.49555 .41 L
.50091 .41035 L
.50658 .41064 L
.51188 .4108 L
.51517 .41084 L
.51821 .41087 L
.52155 .41086 L
.52508 .4108 L
.53101 .41061 L
.53438 .41047 L
.53752 .41028 L
Mistroke
.54869 .4094 L
.55492 .40872 L
.56058 .40798 L
.584 .40376 L
.5968 .40055 L
.60831 .39707 L
.62827 .38949 L
.64767 .37982 L
.66505 .36843 L
.67863 .35676 L
.69066 .34287 L
.69546 .33551 L
.69975 .32723 L
.70136 .32341 L
.70269 .31977 L
.7046 .31288 L
.70536 .30899 L
.70587 .30538 L
.70607 .30349 L
.70623 .30141 L
.70631 .29923 L
.70635 .29719 L
.70624 .29371 L
.70593 .29005 L
.70552 .28693 L
.70493 .28352 L
.70408 .27985 L
.70294 .27596 L
.70035 .269 L
.69681 .26168 L
.69216 .25411 L
.68168 .24106 L
.66741 .22798 L
.64847 .21504 L
.62963 .20529 L
.60721 .19651 L
.59566 .19291 L
.58435 .18994 L
.57311 .18748 L
.56234 .18553 L
.55164 .18398 L
.53992 .18274 L
.53354 .18224 L
.52678 .18184 L
.521 .1816 L
.51464 .18147 L
.51118 .18146 L
.5079 .18147 L
.50176 .18159 L
.49515 .18184 L
Mistroke
.49143 .18203 L
.488 .18225 L
.47604 .18331 L
.47005 .18402 L
.46349 .18492 L
.44137 .18902 L
.42931 .19198 L
.4186 .19513 L
.39829 .20247 L
.3812 .21034 L
.36375 .2205 L
.34754 .23266 L
.33492 .24499 L
.32532 .25738 L
.32092 .2647 L
.31716 .27261 L
.31461 .27948 L
.31348 .28342 L
.31263 .28712 L
.3122 .28918 L
.31187 .29143 L
.31136 .29552 L
.31109 .29952 L
.31106 .30322 L
.31123 .30721 L
.3114 .30948 L
.31167 .31161 L
.31235 .31589 L
.31336 .32048 L
.31558 .32784 L
.31883 .3356 L
.32675 .34923 L
.33289 .35727 L
.33956 .36462 L
.35426 .37757 L
.3727 .38996 L
.39205 .40002 L
.41553 .40936 L
.42915 .41361 L
.44254 .41707 L
.45435 .41962 L
.46751 .42189 L
.47968 .42351 L
.4911 .42461 L
.49815 .4251 L
.5048 .42545 L
.51079 .42565 L
.51728 .42573 L
.52066 .42575 L
.52438 .42569 L
Mistroke
.52826 .42563 L
.53187 .4255 L
.53833 .42522 L
.54523 .42478 L
.55176 .42422 L
.55776 .42359 L
.57123 .42183 L
.58293 .41981 L
.59514 .41726 L
.61559 .41177 L
.63691 .40424 L
.6592 .39397 L
.67817 .38262 L
.6931 .37125 L
.70688 .35775 L
.71856 .34207 L
.72358 .33293 L
.72714 .32445 L
.72956 .31639 L
.73057 .31181 L
.73127 .30757 L
.73169 .30385 L
.73192 .29975 L
.73193 .29546 L
.73174 .29145 L
.73135 .28729 L
.73103 .28519 L
.73067 .28288 L
.72979 .2788 L
.72877 .27499 L
.72585 .26647 L
.72162 .25743 L
.71109 .24143 L
.6984 .22757 L
.68448 .21577 L
.66682 .20398 L
.64595 .19309 L
.62457 .1844 L
.59924 .17664 L
.58426 .17312 L
.57007 .17046 L
.55742 .1686 L
.54331 .16707 L
.53614 .16651 L
.53218 .16624 L
.5284 .16606 L
.52107 .16577 L
.51436 .16563 L
.50768 .16562 L
.50163 .16573 L
Mistroke
.49465 .16595 L
.48809 .16627 L
.48201 .1667 L
.47644 .16717 L
.46393 .16853 L
.45141 .17034 L
.43788 .17283 L
.41146 .17936 L
.38527 .18839 L
.36248 .19882 L
.34397 .2096 L
.32629 .2227 L
.31022 .23834 L
.30294 .24743 L
.2971 .25623 L
.29265 .26455 L
.28936 .27231 L
.28655 .28106 L
.28548 .28569 L
.285 .28824 L
.28464 .29059 L
.28413 .29494 L
.28393 .29723 L
.28382 .29965 L
.28376 .30373 L
.28396 .30822 L
.28435 .31221 L
.28496 .31649 L
.28571 .32053 L
.28661 .32419 L
.2894 .3329 L
.29345 .34225 L
.29831 .35092 L
.30364 .35878 L
.31634 .37355 L
.33032 .38608 L
.34918 .39936 L
.36935 .4105 L
.39205 .42035 L
.41902 .42923 L
.43333 .4329 L
.44908 .43618 L
.46427 .4387 L
.47106 .43961 L
.47832 .44044 L
.48506 .44108 L
.49252 .44168 L
.49933 .44209 L
.50573 .44235 L
.51327 .44254 L
Mistroke
.52018 .44261 L
.52816 .44252 L
.53574 .44228 L
.54228 .44195 L
.54923 .44151 L
.55577 .44097 L
.56168 .44036 L
.58947 .43636 L
.60293 .43366 L
.61736 .43011 L
.64527 .42131 L
.66925 .41123 L
.68968 .40029 L
.71104 .38568 L
.72754 .37093 L
.73535 .36227 L
.74273 .3525 L
.74821 .3437 L
.75307 .33399 L
.75653 .32478 L
.75775 .32071 L
.75889 .31623 L
.75972 .31196 L
.7603 .30797 L
.76075 .30375 L
.761 .29923 L
.761 .29662 L
.76099 .2942 L
.76086 .29155 L
.76065 .28875 L
.76008 .28404 L
.75968 .28136 L
.75917 .27887 L
.75694 .27001 L
.75526 .26508 L
.75348 .2606 L
.7435 .24209 L
.73605 .232 L
.72803 .22296 L
.71071 .20729 L
.68877 .19212 L
.66304 .17862 L
.63684 .16813 L
.60573 .15894 L
.5893 .15531 L
.57083 .15213 L
.56233 .15096 L
.55422 .15 L
.5468 .14927 L
.53889 .14865 L
Mistroke
.53479 .14839 L
.53025 .14816 L
.52225 .14785 L
.51774 .14772 L
.51288 .14768 L
.50829 .14766 L
.50408 .1477 L
.49648 .14786 L
.48942 .14815 L
.4817 .1486 L
.47347 .14922 L
.45676 .151 L
.44179 .15322 L
.41189 .15939 L
.39733 .16332 L
.38184 .16829 L
.3556 .17872 L
.33364 .18989 L
.31051 .20487 L
.28958 .2229 L
.28164 .23143 L
.27407 .24107 L
.26835 .24975 L
.26313 .25933 L
.25902 .26905 L
.25751 .27335 L
.25611 .27809 L
.25422 .28683 L
.25349 .29163 L
.25306 .29611 L
.25293 .29869 L
.25284 .30149 L
.25292 .30659 L
.25324 .31154 L
.25374 .31611 L
.25457 .32104 L
.25579 .32645 L
.25921 .33731 L
.2638 .34791 L
.2691 .35743 L
.28469 .37803 L
.3034 .39582 L
.32472 .41125 L
.34962 .4252 L
.37466 .43614 L
.40605 .44651 L
.42116 .45043 L
.43755 .45393 L
.45196 .45647 L
.46805 .45866 L
Mistroke
.47518 .45947 L
.48286 .46017 L
.49009 .4607 L
.4968 .46113 L
.50524 .46148 L
.50969 .4616 L
.51443 .46169 L
.52238 .46171 L
.53116 .46159 L
.53895 .46135 L
.54732 .46092 L
.5552 .46036 L
.56241 .45976 L
.57929 .45783 L
.59443 .45555 L
.62749 .4485 L
.65662 .43974 L
.6824 .42961 L
.70988 .41562 L
.73238 .40089 L
.75352 .38294 L
.76327 .3725 L
.77135 .36222 L
.7775 .35295 L
.78307 .3426 L
.78725 .3329 L
.79012 .32399 L
.79145 .31885 L
.792 .31614 L
.79256 .31327 L
.793 .31019 L
.79338 .30735 L
.79382 .30177 L
.79395 .29665 L
.79387 .29187 L
.79351 .28663 L
.79279 .28103 L
.79183 .27582 L
.79072 .27103 L
.78739 .26026 L
.78342 .25089 L
.7783 .2411 L
.767 .22464 L
.75127 .2074 L
.72949 .18926 L
.70517 .17371 L
.68065 .16138 L
.65136 .14987 L
.61717 .13991 L
.59715 .13555 L
Mistroke
.57852 .13238 L
.56079 .1301 L
.5507 .1291 L
.54136 .12837 L
.53313 .1279 L
.52406 .12754 L
.51458 .12734 L
.50571 .1273 L
.49648 .12745 L
.49182 .12762 L
.48668 .12782 L
.47762 .12834 L
.46913 .12897 L
.45016 .13093 L
.43959 .13238 L
.42997 .13392 L
.39644 .141 L
.38018 .1455 L
.36289 .15107 L
.33425 .16252 L
.30631 .17693 L
.28285 .1924 L
.26428 .20786 L
.24665 .22683 L
.23871 .23774 L
.23236 .24823 L
.22751 .25812 L
.22388 .26729 L
.22088 .27762 L
.21963 .28336 L
.21871 .28883 L
.21807 .29475 L
.2178 .30012 L
.21772 .3031 L
.21781 .30633 L
.21813 .31217 L
.21869 .31767 L
.21963 .32345 L
.22071 .32837 L
.22214 .33375 L
.22631 .34582 L
.23235 .35853 L
.2472 .38069 L
.26711 .40177 L
.28962 .41972 L
.31848 .43736 L
.35329 .45338 L
.38639 .46472 L
.41945 .47303 L
.43908 .47671 L
Mistroke
.4574 .47941 L
.46795 .48065 L
.47783 .48158 L
.48819 .48235 L
.4936 .48268 L
.49956 .48295 L
.50952 .48326 L
.51498 .48338 L
.52009 .4834 L
.52922 .48336 L
.53903 .4831 L
.54451 .48286 L
.55049 .48256 L
.56133 .48181 L
.57183 .48086 L
.58152 .47979 L
.59901 .47739 L
.61803 .47399 L
.65535 .46492 L
.68706 .4543 L
.71879 .44041 L
.74588 .42514 L
.76795 .40947 L
.78875 .39072 L
.79859 .3798 L
.80674 .36912 L
.81333 .35891 L
.81936 .34757 L
.82376 .33715 L
.82696 .32725 L
.82851 .32108 L
.82967 .31541 L
.83059 .30908 L
.83089 .30558 L
.83116 .30225 L
.83127 .29905 L
.83132 .29564 L
.83112 .28949 L
.83088 .28573 L
.83046 .28219 L
.82946 .27558 L
.8283 .26978 L
.82672 .26368 L
.82301 .25284 L
.81793 .24131 L
.8109 .2289 L
.7933 .20569 L
.77193 .18515 L
.74916 .16816 L
.72085 .15154 L
Mistroke
.68637 .13597 L
.64622 .12253 L
.60959 .11385 L
.588 .11012 L
.56736 .10744 L
.55775 .10645 L
.54743 .1056 L
.53765 .105 L
.52873 .10461 L
.51822 .1043 L
.51228 .10423 L
.5068 .1042 L
.49673 .10432 L
.48607 .10467 L
.47589 .10519 L
.46497 .10595 L
.44537 .10787 L
.43351 .10941 L
.42234 .11111 L
.40167 .11492 L
.36609 .12368 L
.33476 .13398 L
.30269 .14759 L
.27168 .16452 L
.24246 .18535 L
.21992 .20646 L
.2004 .23144 L
.19281 .2446 L
.18625 .25936 L
.18391 .26616 L
.18204 .27263 L
.1806 .27854 L
.17944 .28485 L
.17901 .28812 L
.17856 .29173 L
.17812 .2981 L
.17796 .30169 L
.17801 .30555 L
.17807 .3092 L
.17831 .31254 L
.17885 .31858 L
.17968 .32418 L
.1809 .33031 L
.18253 .33682 L
.1869 .35006 L
.19222 .36189 L
.20673 .38549 L
.22727 .40914 L
.24885 .42795 L
.27647 .44686 L
Mistroke
.31034 .46482 L
.35086 .48096 L
.3718 .48753 L
.39232 .49298 L
.41273 .49744 L
.4323 .50097 L
.45119 .50362 L
.47182 .50584 L
.48307 .50669 L
.48923 .50707 L
.49498 .50736 L
.50517 .50774 L
.51635 .50797 L
.52201 .50798 L
.52816 .50797 L
.53931 .50774 L
.55016 .50729 L
.56015 .50671 L
.57092 .50592 L
.58273 .50479 L
.6064 .50175 L
.6269 .49829 L
.64531 .49445 L
.68537 .48363 L
.72027 .47095 L
.75101 .4567 L
.78325 .4377 L
.8088 .41843 L
.83352 .39412 L
.84295 .38233 L
.85167 .36954 L
.85798 .35822 L
.8638 .34559 L
.86786 .33391 L
.87073 .32291 L
.87198 .31618 L
.87289 .3098 L
.87341 .30405 L
.87364 .29779 L
.87358 .29098 L
.87315 .28375 L
.87246 .27758 L
.87131 .27079 L
.86983 .26417 L
.8682 .25802 L
.86336 .2442 L
.85713 .23094 L
.84902 .21704 L
.83023 .19277 L
.80894 .17201 L
Mistroke
.77919 .14972 L
.74174 .12832 L
.70192 .1112 L
.66205 .09835 L
.6213 .0888 L
.59766 .0847 L
.57567 .08184 L
.56569 .08078 L
.555 .07985 L
.54323 .07907 L
.53228 .07855 L
.52104 .07818 L
.51046 .07802 L
.50095 .07808 L
.49068 .07827 L
.47849 .0787 L
.46716 .07934 L
.45476 .08029 L
.44155 .08158 L
.41482 .08509 L
.39089 .08928 L
.34621 .10011 L
.30632 .11346 L
.27077 .12897 L
.23532 .14885 L
.20308 .17239 L
.1779 .1967 L
.15914 .22099 L
.14626 .2443 L
.14098 .2575 L
.13866 .26454 L
.13665 .2721 L
.13514 .2794 L
.13412 .28605 L
.13334 .29275 L
.13295 .29908 L
.13289 .30584 L
.13317 .31308 L
.13373 .31993 L
.13459 .32616 L
.13598 .33344 L
.13791 .34133 L
.14253 .35559 L
.14904 .37028 L
.15773 .38559 L
.17772 .4121 L
.20081 .43487 L
.22635 .45474 L
.25839 .47452 L
.29718 .49317 L
Mistroke
.33908 .50856 L
.38079 .51996 L
.40571 .52521 L
.42887 .52906 L
.44187 .53082 L
.45608 .53244 L
.46949 .53368 L
.4821 .53462 L
.4943 .53526 L
.50746 .53569 L
.51496 .53582 L
.52209 .53586 L
.52849 .53586 L
.53547 .53573 L
.54294 .53557 L
.5497 .5353 L
.56482 .5345 L
.57879 .53346 L
.59188 .53223 L
.61686 .52906 L
.63951 .52531 L
.68907 .5139 L
.7311 .50037 L
.77288 .48262 L
.80861 .46301 L
.83752 .44295 L
.86664 .4171 L
.87965 .40259 L
.89167 .38663 L
.90061 .3723 L
.90862 .35611 L
.91431 .34112 L
.91818 .32686 L
.91958 .31961 L
.92071 .31184 L
.92142 .30449 L
.92168 .2978 L
.92159 .28991 L
.92143 .28547 L
.92105 .28138 L
.9202 .27386 L
.91886 .26593 L
.91712 .25834 L
.91481 .25024 L
.90958 .23572 L
.9014 .21873 L
.89211 .20355 L
.87185 .17783 L
.84427 .15154 L
.81326 .12876 L
Mistroke
.78061 .10973 L
.7421 .09188 L
.69681 .07578 L
.67492 .06951 L
.65115 .0638 L
.6284 .05918 L
.60731 .05572 L
.58174 .05242 L
.56753 .05103 L
.55402 .04999 L
.54148 .04922 L
.52987 .04873 L
.5171 .04844 L
.50354 .04838 L
.48993 .04856 L
.48228 .04877 L
.47529 .04904 L
.46175 .04976 L
.44892 .05072 L
.42044 .0537 L
.40448 .05589 L
.38979 .05826 L
.3384 .06934 L
.31059 .07731 L
.28585 .08568 L
.24299 .10369 L
.20203 .12605 L
.16956 .14871 L
.14332 .1718 L
.11954 .19902 L
.10026 .22993 L
.09297 .2462 L
.08975 .25524 L
.08724 .26378 L
.08533 .27169 L
.08387 .27896 L
.08273 .28708 L
.08234 .29134 L
.08199 .29584 L
.08177 .30042 L
.08175 .30459 L
.08175 .30939 L
.08202 .31393 L
.08266 .322 L
.08324 .32655 L
.08384 .33074 L
.08556 .33953 L
.08803 .34916 L
.09486 .36844 L
.10293 .38515 L
Mistroke
.11182 .40015 L
.1375 .43252 L
.16772 .46048 L
.20174 .48475 L
.24316 .5078 L
.28476 .52579 L
.33684 .54287 L
.36193 .54924 L
.38905 .55499 L
.41298 .55908 L
.43962 .56269 L
.45144 .56394 L
.46416 .56506 L
.47613 .56594 L
.48722 .56658 L
.50119 .56712 L
.50857 .56733 L
.5164 .56741 L
.52956 .56745 L
.54406 .56722 L
.55693 .56674 L
.57076 .56597 L
.58378 .56505 L
.59567 .56401 L
.62362 .56071 L
.64869 .55686 L
.70334 .54502 L
.75145 .53035 L
.79391 .51343 L
.8392 .4901 L
.87615 .46559 L
.91078 .43576 L
.92672 .41845 L
.93994 .40144 L
.94991 .38601 L
.95898 .36882 L
.96565 .3529 L
.97036 .33796 L
.9724 .32959 L
.97387 .32169 L
.97506 .31299 L
.97561 .3081 L
.97587 .30359 L
.97619 .29504 L
.97608 .29019 L
.97597 .28568 L
.97523 .27656 L
.97459 .27146 L
.97388 .26683 L
.97233 .25883 L
Mistroke
.97034 .25039 L
.96555 .23535 L
.95896 .21933 L
.94976 .20201 L
.92869 .17199 L
.90375 .14533 L
.86899 .11672 L
.82448 .08868 L
.77672 .06577 L
.72819 .04797 L
.67681 .03387 L
.62803 .02432 L
.60024 .02044 L
.58549 .01877 L
.56982 .0173 L
.556 .01631 L
.54078 .0155 L
.52691 .01501 L
.51395 .01472 L
.49863 .01472 L
.4909 .01483 L
.48237 .01504 L
.46732 .01563 L
.45323 .01641 L
.43672 .01765 L
.42167 .01912 L
.38806 .02348 L
.36102 .02808 L
.33203 .03421 L
.27578 .04988 L
.22749 .068 L
.18017 .09102 L
.14018 .11591 L
.10834 .1409 L
.07765 .17182 L
.06366 .18966 L
.05233 .20681 L
.04355 .22305 L
.03683 .23811 L
.03108 .25511 L
.02871 .26385 L
.02663 .27356 L
.02516 .28312 L
.0246 .28838 L
.02417 .29333 L
.02381 .30217 L
.02386 .31172 L
.02409 .31677 L
.02451 .3223 L
.02518 .32807 L
Mistroke
.0259 .33344 L
.02768 .34304 L
.03019 .35327 L
.03693 .37335 L
.04535 .39208 L
.06669 .42612 L
.09347 .45707 L
.1299 .48876 L
.17493 .5187 L
.22301 .54326 L
.27234 .56277 L
.32069 .57746 L
.34843 .58426 L
.3795 .5905 L
.40957 .5953 L
.43765 .59876 L
.45342 .60024 L
.47015 .6015 L
.48702 .60246 L
.49663 .60282 L
.5056 .6031 L
.52189 .60332 L
.53676 .60321 L
.54498 .6031 L
.55391 .60279 L
.57014 .60209 L
.58454 .60123 L
.60039 .59994 L
.63225 .59643 L
.66145 .59215 L
.68843 .58714 L
.75158 .5714 L
.80609 .55262 L
.86117 .52752 L
.91256 .49642 L
.946 .47049 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[14]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00OTooo00<00?ooool0
R_oo002Cool2002;ool009?oo`03003ooooo08[oo`00Tooo00<00?ooool0R_oo0020oolQ001oool0
07Coo``001?oo`03003ooooo00_oo`d007;oo`00KOoo1`007ooo00<00?ooool06?oo1000K_oo001Y
ool4000Vool2000Mool6001Xool006?oo`H002[oo`03003ooooo02;oo`L0067oo`00G_oo1@00<?oo
00<00?ooool0:Ooo1@00G?oo001Kool3000eool00`00ooooo`0^ool4001Hool005Ooo`@0037oo`80
00Goo`03003ooooo03;oo`<005Goo`00E?oo0`00=?oo00@00?ooool000Coo`03003ooooo03Goo`@0
057oo`00DOoo0`00=ooo2`00>Ooo0`00C_oo001>ool3000[oolB0005ool00`00ooooo`0>000^ool3
001;ool004_oo`<002Soo`H000ooo`03003ooooo00Goo`03003ooooo00koo`H002_oo`8004Woo`00
B?oo0`008_oo2@005Ooo00<00?ooool01Ooo00<00?ooool05?oo1`009_oo0`00A_oo0016ool2000P
ool5000Oool30004ool00`00ooooo`0Kool6000Sool30013ool004?oo`<001koo`@002_oo`03003o
oooo027oo`L001ooo`80047oo`00@?oo0`007Ooo1000;ooo0P00:Ooo1@007?oo0P00?ooo000nool2
000Mool3000cool00`00ooooo`0]ool3000Kool2000mool003coo`8001goo`8003Koo`03003ooooo
033oo`<001[oo`8003_oo`00>_oo0P007?oo0`00:Ooo7@00:?oo0P006_oo0P00>Ooo000hool2000J
ool4000Sool9000?ool00`00ooooo`0;ool7000Sool3000Iool2000gool003Koo`8001Woo`<0023o
o`L001Soo`03003ooooo01;oo`L001ooo`<001Soo`8003Goo`00=?oo0P006Ooo0P007Ooo1P007ooo
0P006_oo1@007Ooo0P006?oo0P00<ooo000cool00`00ooooo`0Fool3000Kool4000Uool00`00oooo
o`0Nool4000Kool3000Gool2000aool0037oo`8001Koo`<001[oo`@002Woo`03003ooooo02;oo`@0
01[oo`8001Ooo`8002ooo`00<?oo00<00?ooool05?oo0P006Ooo1000;Ooo00<00?ooool09_oo0`00
6Ooo0P005ooo00<00?ooool0;?oo000^ool2000Eool2000Hool3000[ool9000Yool4000Gool2000F
ool2000/ool002coo`8001Goo`8001Soo`8001ooo`l000Koo`03003ooooo00l001koo`@001Goo`80
01Koo`03003ooooo02Woo`00:ooo00<00?ooool05?oo00<00?ooool05Ooo0`006Ooo20005Ooo0P00
4?oo1P007?oo10004ooo0P005Ooo0P00:Ooo000Yool2000Eool2000Eool3000Hool4000Mool00`00
ooooo`0Eool5000Kool2000Cool2000Eool2000Wool002Soo`03003ooooo01?oo`8001Coo`<001Oo
o`@0027oo`03003ooooo01[oo`@001Woo`8001?oo`8001Goo`03003ooooo02Coo`009ooo00<00?oo
ool04ooo00<00?ooool04_oo0P005ooo0`009Ooo00<00?ooool07_oo10005ooo0P004ooo0P005?oo
00<00?ooool08ooo000Uool2000Dool2000Bool3000Fool3000Rool00`00ooooo`03ool00`00oooo
o`0Rool3000Fool2000Cool2000Cool2000Sool002Coo`03003ooooo01?oo`03003ooooo013oo`80
01Koo`<001cooaT001koo`@001Coo`8001?oo`8001?oo`03003ooooo023oo`008ooo00<00?ooool0
4_oo0P004Ooo0P005Ooo0`006?oo1`001_oo1@001?oo0`001ooo2`005ooo10004_oo0P004ooo00<0
0?ooool04Ooo00<00?ooool07ooo000Qool2000Cool2000Aool2000Dool3000Gool40008ool40000
1Ooo003ooooo00001Ooo00<00?ooool04_oo1@005_oo0P004_oo0P004_oo0P004_oo00<00?ooool0
7_oo000Pool00`00ooooo`0Bool00`00ooooo`0@ool00`00ooooo`0Bool2000Eool5000Bool00`00
ool00005ool00`00ooooo`0Gool3000Eool2000Bool2000Bool00`00ooooo`0@ool2000Nool001oo
o`03003ooooo017oo`80017oo`8001?oo`8001;oo`D001Soo`8000Goo`03003ooooo01[oo`@001?o
o`8001;oo`80017oo`03003ooooo017oo`03003ooooo01_oo`007_oo00<00?ooool04?oo0P004Ooo
0P004ooo0P004Ooo0`007_oo00<00?ooool00ooo00<00?ooool07_oo10004Ooo0P004_oo0P004?oo
0P004_oo00<00?ooool06_oo000Mool00`00ooooo`0@ool00`00ooooo`0@ool00`00ooooo`0Aool2
000Aool2000IoolI000Jool4000?ool2000Bool00`00ooooo`0?ool00`00ooooo`0@ool00`00oooo
o`0Iool001coo`03003ooooo013oo`03003ooooo013oo`03003ooooo013oo`80013oo`<001;oo`T0
00koo`8000Woo`P001Koo`8000ooo`80017oo`03003ooooo00ooo`03003ooooo013oo`03003ooooo
01Soo`006ooo00<00?ooool04?oo00<00?ooool03ooo0P004Ooo0P003ooo0`004Ooo10005ooo00<0
0?ooool04?oo1@004ooo0P003ooo0P004?oo00<00?ooool03ooo00<00?ooool04?oo00<00?ooool0
5ooo000Jool00`00ooooo`0@ool00`00ooooo`0?ool00`00ooooo`0?ool2000?ool2000@ool4000K
ool00`00ooooo`0Eool4000Aool2000?ool00`00ooooo`0>ool00`00ooooo`0?ool00`00ooooo`0?
ool00`00ooooo`0Gool001Woo`03003ooooo013oo`03003ooooo00ooo`03003ooooo00koo`8000ko
o`<000ooo`<001ooo`03003ooooo01Woo`<0013oo`<000goo`8000ooo`80013oo`03003ooooo00oo
o`03003ooooo01Koo`006?oo00<00?ooool04?oo00<00?ooool03_oo0P004?oo00<00?ooool03?oo
0P004?oo0P005_oo5P005Ooo0`004?oo0P003Ooo0P003ooo00<00?ooool03_oo00<00?ooool03ooo
00<00?ooool05Ooo000Gool00`00ooooo`0@ool00`00ooooo`0>ool00`00ooooo`0>ool2000=ool2
000?ool3000@ool8000<ool00`00ooooo`07ool8000@ool3000?ool2000=ool00`00ooooo`0=ool0
0`00ooooo`0>ool00`00ooooo`0?ool00`00ooooo`0Dool001Koo`03003ooooo013oo`03003ooooo
00koo`03003ooooo00koo`03003ooooo00_oo`8000ooo`80013oo`<001Coo`80013oo`@000ooo`80
00ooo`8000coo`8000koo`03003ooooo00koo`03003ooooo00ooo`03003ooooo01?oo`005Ooo00<0
0?ooool04?oo00<00?ooool03_oo00<00?ooool03Ooo0P003Ooo00<00?ooool03Ooo0P003_oo1000
5ooo00<00?ooool04ooo10003Ooo0`003_oo0P003?oo00<00?ooool03?oo00<00?ooool03_oo00<0
0?ooool03ooo00<00?ooool04_oo000Dool00`00ooooo`0@ool00`00ooooo`0>ool00`00ooooo`0=
ool00`00ooooo`0;ool2000=ool3000<ool4000Kool00`00ooooo`0Gool4000<ool2000>ool00`00
ooooo`0:ool00`00ooooo`0<ool00`00ooooo`0>ool00`00ooooo`0>ool00`00ooooo`0Bool001Co
o`03003ooooo00ooo`03003ooooo00koo`03003ooooo00coo`8000goo`03003ooooo00_oo`8000_o
o`@001;ooaX0017oo`<000_oo`8000goo`03003ooooo00[oo`8000goo`8000koo`03003ooooo00oo
o`03003ooooo017oo`004ooo00<00?ooool04?oo00<00?ooool03Ooo00<00?ooool03?oo00<00?oo
ool03?oo00<00?ooool02_oo0P002_oo0`004_oo10003Ooo00<00?ooool02_oo1P003_oo0P002ooo
0P003?oo0P003?oo00<00?ooool03?oo00<00?ooool03?oo00<00?ooool03ooo00<00?ooool04?oo
000Bool00`00ooooo`0@ool00`00ooooo`0=ool00`00ooooo`0<ool00`00ooooo`0;ool2000;ool2
000:ool2000@ool5000Aool00`00ooooo`0@ool3000=ool2000;ool2000<ool00`00ooooo`0:ool0
0`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0?ool00`00ooooo`0?ool0017oo`03003ooooo
013oo`03003ooooo00goo`03003ooooo00coo`03003ooooo00_oo`03003ooooo00Woo`8000[oo`80
00coo`H001Koo`8001Coo`<000coo`8000_oo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo
00coo`03003ooooo00coo`03003ooooo00koo`03003ooooo00ooo`004Ooo00<00?ooool03ooo00<0
0?ooool03Ooo00<00?ooool03?oo00<00?ooool02ooo00<00?ooool02Ooo00<00?ooool02Ooo00<0
0?ooool02_oo0P003_oo6@003_oo10002_oo0P002_oo0P002ooo00<00?ooool02_oo0P003Ooo00<0
0?ooool02ooo00<00?ooool03ooo00<00?ooool03_oo000@ool00`00ooooo`0?ool00`00ooooo`0=
ool00`00ooooo`0<ool00`00ooooo`0:ool2000:ool2000:ool2000;ool2000;ool5000>ool00`00
ooooo`08ool6000<ool30009ool2000:ool00`00ooooo`09ool2000<ool00`00ooooo`0:ool00`00
ooooo`0<ool00`00ooooo`0?ool00`00ooooo`0=ool0013oo`03003ooooo00koo`03003ooooo00go
o`03003ooooo00coo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo00Woo`03003ooooo00Wo
o`8000Woo`@001?oo`03003ooooo00koo`<000coo`8000Woo`8000Woo`8000_oo`03003ooooo00[o
o`03003ooooo00[oo`03003ooooo00coo`03003ooooo00koo`03003ooooo00goo`003ooo00<00?oo
ool03ooo00<00?ooool03?oo00<00?ooool03?oo00<00?ooool02_oo00<00?ooool02Ooo00<00?oo
ool02?oo0P002_oo0P002Ooo0P003ooo4@002ooo0`002ooo0P002Ooo0P002Ooo00<00?ooool02Ooo
00<00?ooool02_oo00<00?ooool02_oo00<00?ooool03?oo00<00?ooool03_oo00<00?ooool03?oo
000>ool00`00ooooo`0?ool00`00ooooo`0=ool00`00ooooo`0;ool00`00ooooo`0:ool00`00oooo
o`08ool2000:ool00`00ooooo`08ool20008ool30009ool90007ool00`00ooooo`06ool60008ool3
000:ool20009ool20008ool00`00ooooo`09ool00`00ooooo`09ool00`00ooooo`0;ool00`00oooo
o`0;ool00`00ooooo`0>ool00`00ooooo`0<ool000koo`03003ooooo00ooo`03003ooooo00coo`03
003ooooo00_oo`03003ooooo00[oo`03003ooooo00Soo`03003ooooo00Soo`8000Woo`8000Soo`80
00Soo`@000Woo`03003ooooo00Coo`<000coo`<000Soo`<000Woo`8000Woo`03003ooooo00Koo`80
00[oo`03003ooooo00Woo`03003ooooo00[oo`03003ooooo00coo`03003ooooo00koo`03003ooooo
00_oo`003Ooo00<00?ooool03ooo00<00?ooool03?oo00<00?ooool02ooo00<00?ooool02_oo00<0
0?ooool02?oo00<00?ooool01ooo0P002Ooo0P001ooo0`002?oo0P001_oo10000ooo3@003?oo1000
1ooo0P002Ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool02_oo00<0
0?ooool02_oo00<00?ooool03?oo00<00?ooool03Ooo00<00?ooool02ooo000<ool00`00ooooo`0?
ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`07
ool00`00ooooo`08ool00`00ooooo`05ool20008ool30009ool60002ool00`00ooooo`02ool00`00
ooooo`03ool6000:ool30006ool20008ool20008ool00`00ooooo`07ool00`00ooooo`07ool00`00
ooooo`0:ool00`00ooooo`09ool00`00ooooo`0<ool00`00ooooo`0=ool00`00ooooo`0;ool000co
o`03003ooooo00ooo`03003ooooo00coo`03003ooooo00_oo`03003ooooo00Woo`03003ooooo00So
o`03003ooooo00Ooo`03003ooooo00Ooo`8000Ooo`03003ooooo00Koo`8000Woo`<000Goo`04003o
oooo0004ool00`00ooooo`09ool40009ool20006ool20008ool00`00ooooo`06ool00`00ooooo`07
ool00`00ooooo`07ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0<ool00`00ooooo`0=
ool00`00ooooo`0:ool000_oo`03003ooooo00ooo`03003ooooo00coo`03003ooooo00_oo`03003o
oooo00Woo`03003ooooo00Soo`03003ooooo00Ooo`03003ooooo00Koo`8000Soo`03003ooooo00Co
o`<000Ooo`@000Kooa8000Soo`<000Soo`03003ooooo00Goo`8000Ooo`03003ooooo00Koo`03003o
oooo00Ooo`03003ooooo00Ooo`03003ooooo00Woo`03003ooooo00Woo`03003ooooo00coo`03003o
oooo00goo`03003ooooo00[oo`002ooo00<00?ooool03_oo00<00?ooool03Ooo00<00?ooool02_oo
00<00?ooool02Ooo00<00?ooool02?oo00<00?ooool02?oo00<00?ooool01Ooo00<00?ooool01_oo
0P001Ooo0P002?oo0P001Ooo1@002_oo00<00?ooool01Ooo10001ooo10001Ooo0P001ooo00<00?oo
ool01Ooo00<00?ooool01_oo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool02?oo00<00?oo
ool02_oo00<00?ooool03?oo00<00?ooool03Ooo00<00?ooool02Ooo000:ool00`00ooooo`0?ool0
0`00ooooo`0<ool00`00ooooo`0;ool00`00ooooo`09ool00`00ooooo`07ool00`00ooooo`08ool0
0`00ooooo`05ool00`00ooooo`06ool00`00ooooo`04ool00`00ooooo`05ool30004ool3000:ool9
0008ool40007ool20005ool20006ool20006ool00`00ooooo`05ool00`00ooooo`08ool00`00oooo
o`06ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0;ool00`00ooooo`0=ool00`00oooo
o`09ool000[oo`03003ooooo00koo`03003ooooo00goo`03003ooooo00[oo`03003ooooo00Woo`03
003ooooo00Soo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo00Goo`03003ooooo00?oo`80
00Koo`8000Goo`8000Woo`@000Goo`04003oooooool70005ool20007ool20005ool00`00ooooo`05
ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`07ool00`00ooooo`07ool00`00ooooo`08
ool00`00ooooo`0:ool00`00ooooo`0;ool00`00ooooo`0=ool00`00ooooo`09ool000[oo`03003o
oooo00koo`03003ooooo00coo`03003ooooo00_oo`03003ooooo00Soo`03003ooooo00Soo`03003o
oooo00Ooo`03003ooooo00Koo`03003ooooo00Goo`03003ooooo00?oo`03003ooooo00Coo`8000Go
o`8000Koo`D000Ooo`@000Woo`@000?oo`<000Koo`8000Coo`8000Koo`03003ooooo00Coo`03003o
oooo00Goo`03003ooooo00Ooo`03003ooooo00Ooo`03003ooooo00Soo`03003ooooo00[oo`03003o
oooo00_oo`03003ooooo00goo`03003ooooo00Soo`002_oo00<00?ooool03Ooo00<00?ooool03Ooo
00<00?ooool02_oo00<00?ooool02Ooo00<00?ooool02?oo00<00?ooool01_oo00<00?ooool01_oo
00<00?ooool01Ooo00<00?ooool00ooo00<00?ooool01?oo00<00?ooool00ooo0P001_oo0P001Ooo
1`000_oo00<00?oo00001P001_oo0P001?oo0`001Ooo00<00?ooool00ooo00<00?ooool01?oo00<0
0?ooool01?oo00<00?ooool01Ooo00<00?ooool01ooo00<00?ooool01_oo00<00?ooool02?oo00<0
0?ooool02_oo00<00?ooool02ooo00<00?ooool03Ooo00<00?ooool02?oo0009ool00`00ooooo`0>
ool00`00ooooo`0<ool00`00ooooo`0;ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`06
ool00`00ooooo`06ool00`00ooooo`05ool00`00ooooo`03ool00`00ooooo`03ool20004ool20005
ool30002ool50005ool80005ool40004ool20005ool20004ool00`00ooooo`03ool00`00ooooo`04
ool00`00ooooo`04ool00`00ooooo`04ool00`00ooooo`07ool00`00ooooo`07ool00`00ooooo`08
ool00`00ooooo`09ool00`00ooooo`0<ool00`00ooooo`0=ool00`00ooooo`07ool000Woo`03003o
oooo00koo`03003ooooo00coo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo00Ooo`03003o
oooo00Ooo`03003ooooo00Goo`03003ooooo00Goo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00?oo`03003ooooo00?oo`8000?oo`8000Goo`D000Coo`04003oooooool60003ool30003ool2
0005ool00`00ooooo`02ool00`00ooooo`03ool00`00ooooo`04ool00`00ooooo`04ool00`00oooo
o`04ool00`00ooooo`07ool00`00ooooo`06ool00`00ooooo`08ool00`00ooooo`0:ool00`00oooo
o`0;ool00`00ooooo`0=ool00`00ooooo`07ool000Woo`03003ooooo00koo`03003ooooo00_oo`03
003ooooo00_oo`03003ooooo00Soo`03003ooooo00Soo`03003ooooo00Koo`03003ooooo00Goo`03
003ooooo00Koo`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03
003ooooo00;oo`03003ooooo00?oo`8000?oo``000Coo`<000?oo`8000?oo`8000Coo`03003ooooo
00;oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo
00Koo`03003ooooo00Ooo`03003ooooo00Soo`03003ooooo00Woo`03003ooooo00_oo`03003ooooo
00goo`03003ooooo00Ooo`002Ooo00<00?ooool03_oo00<00?ooool02ooo00<00?ooool02_oo00<0
0?ooool02Ooo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01Ooo00<00?ooool01Ooo00<0
0?ooool00ooo00<00?ooool00ooo00<00?ooool00_oo00<00?ooool00ooo00@00?ooooooo`8000?o
o`<00003ool00000008000Koo`03003ooooo00?oo`D000;oo`8000?oo`8000?oo`03003ooooo00;o
o`03003ooooo00;oo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00Coo`03003ooooo00Go
o`03003ooooo00Koo`03003ooooo00Koo`03003ooooo00Soo`03003ooooo00Woo`03003ooooo00_o
o`03003ooooo00goo`03003ooooo00Ooo`002?oo00<00?ooool03_oo00@00?ooooooo`8000Woo`03
003ooooo00[oo`03003ooooo00Soo`03003ooooo00?oo`03003ooooo00;oo`03003ooooo00Koo`03
003ooooo00Goo`03003ooooo00Goo`03003ooooo00?oo`03003oo`0000@000Coo`03003ooooo00;o
o`8000;oo`8000;oo`<00004ool00000000:ool00`00ooooo`08ool20002ool20003ool01@00oooo
oooo00001?oo00<00?ooool00_oo00@00?ooooooo`@000Coo`03003ooooo00?oo`03003ooooo00Go
o`03003ooooo00Koo`03003ooooo00Koo`03003oo`0000Woo`03003ooooo00Woo`03003ooooo00[o
o`03003ooooo00;oo`8000Woo`03003ooooo00Ooo`002?oo00<00?ooool03_oo00@00?ooool000;o
o`03003ooooo00Koo`03003ooooo00[oo`03003ooooo00Soo`03003ooooo00?oo`05003oooooool0
0009ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`03ool01000ooooo`000_oo00<00?oo
ool00_oo00<00?ooool00_oo00D00?ooooooo`0000?oo`03003ooooo008000goo`03003ooooo00[o
o`05003oooooool00003ool01@00oooooooo00001?oo00<00?ooool00_oo00H00?ooool00?oo0005
ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`07ool20009ool00`00
ooooo`09ool00`00ooooo`0;ool01000ooooo`000_oo00<00?ooool01ooo00<00?ooool01_oo0007
ool00`00ooooo`0>ool01@00oooooooo00000_oo00<00?ooool01Ooo00<00?ooool02ooo00<00?oo
ool02?oo00<00?ooool01@000_oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01?oo00<0
0?ooool01?oo00L00?ooooooo`00ool00003ool00`00ooooo`02ool01@00oooooooo00000ooo00@0
0?ooool000ooo`03003ooooo00_oo`8000;oo`05003oooooool00003ool20003ool01@00oooooooo
00000ooo00<00?oo00001Ooo00<00?ooool00ooo00<00?ooool01Ooo00<00?ooool01_oo00<00?oo
ool01?oo1@002?oo00<00?ooool02Ooo00<00?ooool02ooo00@00?ooool000;oo`03003ooooo00Oo
o`03003ooooo00Koo`001ooo00<00?ooool03?oo10000_oo0`002?oo00<00?ooool02_oo00<00?oo
ool01ooo100000Goo`00ooooo`0000?oo`03003ooooo00Koo`03003ooooo00Goo`03003ooooo00Co
o`04003oooooool40004ool01@00oooooooo00001?oo00<00?ooool00_oo00@00?ooool000;oo`03
003ooooo00koo`03003ooooo00goo`800003ool0000000;oo`05003oooooool00003ool00`00oooo
o`02ool01000oooooooo0P001Ooo00<00?ooool00ooo00<00?ooool01Ooo00<00?ooool01_oo00<0
0?ooool01?oo00@00?oo000000Woo`03003ooooo00Woo`03003ooooo00_oo`03003ooooo00<000[o
o`03003ooooo00Koo`001ooo00<00?ooool03_oo00D00?ooooooo`0000[oo`03003ooooo00[oo`03
003ooooo00Soo`03003ooooo00;oo`03003oo`0000;oo`03003ooooo00Ooo`03003ooooo00Goo`03
003ooooo00?oo`03003ooooo00?oo`03003ooooo00?oo`03003oo`0000;oo`03003ooooo00;oo`05
003oooooool00002ool01000ooooo`004Ooo0P003ooo00@00?ooool000;oo`03003ooooo00;oo`05
003oooooool00003ool00`00ooooo`02ool20005ool00`00ooooo`03ool00`00ooooo`05ool00`00
ooooo`05ool00`00ooooo`05ool00`00ool00009ool00`00ooooo`0:ool00`00ooooo`0:ool01000
ooooo`003?oo00<00?ooool01_oo0007ool00`00ooooo`0>ool01@00oooooooo00002_oo00<00?oo
ool02_oo00<00?ooool02?oo00<00?ooool00ooo0P000_oo00<00?ooool01_oo00<00?ooool01Ooo
00<00?ooool01?oo00<00?ooool00ooo00<00?ooool00_oo0P0000Goo`00ooooo`0000?oo`05003o
ooooool00002ool01000ooooo`004_oo00<00?ooool03ooo00@00?ooool000;oo`05003oooooool0
0004ool01000oooooooo0P000_oo0P001Ooo00<00?ooool00ooo00<00?ooool01Ooo00<00?ooool0
1Ooo00<00?ooool01_oo0P002_oo00<00?ooool02Ooo00<00?ooool02ooo00<00?oo00003?oo00<0
0?ooool01_oo0007ool00`00ooooo`0>ool00`00ooooo`02ool30006ool00`00ooooo`0:ool00`00
ooooo`09ool00`00ooooo`04ool01000ooooo`002?oo00<00?ooool01Ooo00<00?ooool01?oo00<0
0?ooool00ooo00<00?ooool00_oo0`000_oo00D00?ooooooo`0000?oo`07003oooooool00?oo0000
4ooo00<00?ooool04?oo00@00?ooool000;oo`05003oooooool00003ool01P00oooooooo003oo`80
0003ool00?oo00Coo`03003ooooo00Coo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Oo
o`03003ooooo00Soo`03003ooooo00Woo`03003ooooo00_oo`03003ooooo00<000Woo`03003ooooo
00Koo`001ooo00<00?ooool03_oo00<00?ooool02ooo00<00?ooool02_oo00<00?ooool02?oo00<0
0?ooool02?oo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool00ooo00<0
0?ooool00ooo00D00?ooooooo`0000Coo`04003ooooo0003ool01000ooooo`004ooo00<00?ooool0
4Ooo00H00?oo00000?oo0003ool01@00oooooooo00001?oo00<00?ooool00_oo00<00?ooool00_oo
00<00?ooool01?oo00<00?ooool01?oo00<00?ooool01_oo00<00?ooool01_oo00<00?ooool02?oo
00<00?ooool02Ooo00<00?ooool02ooo00<00?ooool03?oo00<00?ooool01_oo0007ool00`00oooo
o`0=ool00`00ooooo`0<ool00`00ooooo`0:ool00`00ooooo`08ool00`00ooooo`07ool00`00oooo
o`06ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`03ool00`00ooooo`03ool01@00oooo
oooo00000ooo0P000_oo00<00?ooool00P0000?oo`00ool04ooo00<00?ooool04Ooo00@00?ooool0
00;oo`04003ooooo0003ool00`00ooooo`02ool00`00ooooo`02ool00`00ooooo`02ool20005ool0
0`00ooooo`04ool00`00ooooo`06ool00`00ooooo`06ool00`00ooooo`08ool00`00ooooo`09ool0
0`00ooooo`0;ool00`00ooooo`0<ool00`00ooooo`06ool000Ooo`03003ooooo00goo`03003ooooo
00coo`03003ooooo00[oo`03003ooooo00Soo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo
00Goo`03003ooooo00Coo`03003ooooo00?oo`03003ooooo00;oo`03003ooooo00;oo`05003ooooo
ool00003ool01000ooooo`000_oo00<00?ooool04_oo00<00?ooool04Ooo00@00?ooool000;oo`04
003ooooo0003ool00`00ooooo`02ool00`00ooooo`02ool00`00ooooo`03ool00`00ooooo`03ool0
0`00ooooo`04ool00`00ooooo`06ool00`00ooooo`06ool00`00ooooo`08ool00`00ooooo`09ool0
0`00ooooo`0;ool00`00ooooo`0<ool00`00ooooo`06ool00?l00200007oo`001ooo00<00?ooool0
1ooo00<00?ooool00ooo00D00?ooooooo`0000Woo`8000Soo`05003oooooool00005ool00`00oooo
o`02ool00`00ooooo`02ool00`00ooooo`02ool00`00ooooo`02ool01@00oooooooo00001Ooo00<0
0?oo00001_oo0P001?oo00<00?ooool00_oo00<00?ooool00_oo00@00?ooooooo`8000;oo`04003o
oooo0002ool20009ool00`00ooooo`07ool00`00ooooo`07ool00`00ooooo`07ool01000ooooo`00
0_oo00<00?ooool00P000_oo00<00?ooool00_oo00<00?oo00000_oo00<00?ooool00ooo0P001?oo
00<00?ooool00_oo00<00?oo00001ooo0P002?oo00<00?ooool02?oo00<00?ooool01ooo00<00?oo
00001ooo00<00?ooool00ooo00D00?ooooooo`0000Woo`8000Soo`001ooo00<00?ooool03Ooo00D0
0?ooooooo`0000[oo`03003ooooo00[oo`03003ooooo00Soo`03003ooooo00;oo`03003ooooo00;o
o`03003ooooo00Koo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00?oo`03003ooooo00;o
o`03003ooooo00;oo`05003oooooool00003ool01000ooooo`000_oo00<00?ooool04_oo00<00?oo
ool05?oo00@00?ooool000;oo`05003oooooool00004ool00`00ool00002ool00`00ooooo`03ool0
0`00ooooo`03ool00`00ooooo`04ool00`00ooooo`06ool00`00ooooo`06ool00`00ooooo`08ool0
0`00ooooo`09ool00`00ooooo`0;ool01@00oooooooo00002_oo00<00?ooool01_oo0007ool00`00
ooooo`0=ool00`00ooooo`0<ool00`00ooooo`0:ool00`00ooooo`08ool00`00ooooo`07ool00`00
ooooo`06ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`03ool00`00ooooo`02ool00`00
ooooo`02ool01@00oooooooo00000ooo00@00?ooool000;oo`03003ooooo01;oo`03003ooooo01?o
o`03003ooooo008000;oo`05003oooooool00003ool20004ool00`00ooooo`02ool00`00ooooo`04
ool00`00ooooo`04ool00`00ooooo`06ool00`00ooooo`06ool00`00ooooo`08ool00`00ooooo`09
ool00`00ooooo`0;ool00`00ooooo`0<ool00`00ooooo`06ool000Ooo`03003ooooo00goo`03003o
oooo00coo`03003ooooo00[oo`03003ooooo00Soo`03003ooooo00Ooo`03003ooooo00Koo`03003o
oooo00Goo`03003ooooo00Coo`03003ooooo00?oo`03003ooooo00?oo`05003oooooool00004ool0
1000ooooo`000ooo00<00?oo00005?oo00<00?ooool04ooo00@00?ooool000?oo`05003oooooool0
0003ool00`00ooooo`02ool00`00ooooo`03ool00`00ooooo`04ool00`00ooooo`04ool00`00oooo
o`05ool00`00ooooo`07ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`0:ool00`00oooo
o`0=ool00`00ooooo`06ool000Ooo`03003ooooo00goo`03003ooooo00coo`03003ooooo00[oo`03
003ooooo00Soo`03003ooooo00Soo`03003ooooo00Goo`03003ooooo00Goo`03003ooooo00Coo`03
003ooooo00?oo`03003ooooo00?oo`03003ooooo00;oo`05003oooooool00003ool01000ooooo`00
0_oo00<00?ooool04Ooo00<00?ooool04_oo00D00?ooooooo`0000;oo`05003oooooool00004ool0
0`00ooooo`02ool00`00ooooo`03ool00`00ooooo`04ool00`00ooooo`04ool00`00ooooo`05ool0
0`00ooooo`07ool00`00ooooo`07ool00`00ooooo`09ool00`00ooooo`0;ool00`00ooooo`0=ool0
0`00ooooo`06ool000Ooo`03003ooooo00koo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo
00Soo`03003ooooo00Soo`03003ooooo00Koo`03003ooooo00Goo`03003ooooo00?oo`03003ooooo
00?oo`03003ooooo00?oo`03003ooooo00;oo`05003oooooool00003ool01@00oooooooo00000_oo
00<00?ooool04?oo0P004ooo00@00?ooool000?oo`05003oooooool00004ool00`00ooooo`02ool0
0`00ooooo`03ool00`00ooooo`03ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`06ool0
0`00ooooo`08ool00`00ooooo`09ool00`00ooooo`0;ool00`00ooooo`0=ool00`00ooooo`06ool0
00Ooo`03003ooooo00koo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo
00Ooo`03003ooooo00Koo`03003ooooo00Goo`03003ooooo00?oo`03003ooooo00Coo`03003ooooo
00;oo`03003ooooo00;oo`03003ooooo00;oo`05003oooooool00002ool01000ooooo`004_oo00<0
0?ooool04Ooo00@00?ooool000?oo`05003oooooool00004ool00`00ooooo`02ool00`00ooooo`03
ool00`00ooooo`04ool00`00ooooo`04ool00`00ooooo`06ool00`00ooooo`06ool00`00ooooo`08
ool00`00ooooo`09ool00`00ooooo`0;ool00`00ooooo`0=ool00`00ooooo`06ool000Ooo`03003o
oooo00koo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo00Ooo`03003o
oooo00Koo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00?oo`03003ooooo00?oo`03003o
oooo00;oo`05003oooooool00004ool01000ooooo`000_oo00<00?ooool03ooo00<00?ooool03ooo
0P000_oo00D00?ooooooo`0000Coo`05003oooooool00004ool00`00ooooo`04ool00`00ooooo`03
ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`07ool00`00ooooo`08ool00`00ooooo`09
ool00`00ooooo`0;ool00`00ooooo`0=ool00`00ooooo`06ool000Ooo`03003ooooo00koo`03003o
oooo00_oo`03003ooooo00_oo`03003ooooo00Soo`03003ooooo00Ooo`03003ooooo00Ooo`03003o
oooo00Coo`03003ooooo00Goo`03003ooooo00?oo`03003ooooo00?oo`03003ooooo00;oo`05003o
ooooool00004ool00`00ooooo`0200000ooo0000000?ool00`00ooooo`0=ool20003ool01@00oooo
oooo00001?oo00D00?ooooooo`0000Goo`03003ooooo00?oo`03003ooooo00Coo`03003ooooo00Co
o`03003ooooo00Koo`03003ooooo00Koo`03003ooooo00Woo`03003ooooo00Soo`03003ooooo00co
o`03003ooooo00coo`03003ooooo00Ooo`001ooo00<00?ooool03_oo00<00?ooool03?oo00<00?oo
ool02_oo00<00?ooool02?oo00<00?ooool02?oo00<00?ooool01_oo00<00?ooool01Ooo00<00?oo
ool01?oo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool00ooo00D00?ooooooo`0000Coo`05
003oooooool00002ool2000=ool00`00ooooo`0;ool20004ool01@00oooooooo00001?oo00D00?oo
ooooo`0000Goo`03003ooooo00?oo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Goo`03
003ooooo00Ooo`03003ooooo00Soo`03003ooooo00Woo`03003ooooo00coo`03003ooooo00coo`03
003ooooo00Ooo`001ooo00<00?ooool03_oo00<00?ooool03?oo00<00?ooool02_oo00<00?ooool0
2?oo00<00?ooool02?oo00<00?ooool01_oo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool0
0ooo00<00?ooool00ooo00<00?ooool00ooo00D00?ooooooo`0000Coo`05003oooooool00003ool2
000;ool00`00ooooo`09ool20004ool20002ool20004ool00`00ooooo`02ool00`00ooooo`02ool0
0`00ooooo`04ool00`00ooooo`04ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`07ool0
0`00ooooo`08ool00`00ooooo`09ool00`00ooooo`0;ool00`00ooooo`0=ool00`00ooooo`07ool0
00Soo`03003ooooo00goo`03003ooooo00coo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo
00Ooo`03003ooooo00Ooo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo
00?oo`03003ooooo00;oo`03003ooooo00;oo`03003ooooo00;oo`8000;oo`<000;oo`<000Soo`80
00Soo`8000Coo`8000?oo`03003ooooo00;oo`8000Coo`03003ooooo00?oo`03003ooooo00?oo`03
003ooooo00Goo`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Ooo`03003ooooo00Soo`03
003ooooo00[oo`03003ooooo00_oo`03003ooooo00goo`03003ooooo00Ooo`002?oo00<00?ooool0
3Ooo00<00?ooool03?oo00<00?ooool02_oo00<00?ooool02Ooo00<00?ooool02?oo00<00?ooool0
1_oo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01?oo00<00?ooool00ooo00<00?ooool0
0_oo00<00?ooool00_oo0P001?oo00<00?ooool00_oo0P000ooo1`0000Coo`00ooooo`L000?oo`<0
00?oo`8000Coo`03003ooooo00;oo`8000Goo`03003ooooo00?oo`03003ooooo00Goo`03003ooooo
00Coo`03003ooooo00Koo`03003ooooo00Ooo`03003ooooo00Soo`03003ooooo00Woo`03003ooooo
00coo`03003ooooo00coo`03003ooooo00Soo`002?oo00<00?ooool03_oo00<00?ooool03?oo00<0
0?ooool02_oo00<00?ooool02Ooo00<00?ooool01ooo00<00?ooool01_oo00<00?ooool01Ooo00<0
0?ooool01Ooo00<00?ooool01?oo00<00?ooool01?oo00<00?ooool00_oo0P001?oo0P000ooo0P00
1?oo0`001ooo1@001_oo0`001?oo0P001Ooo00<00?ooool00_oo00<00?ooool00ooo0P001Ooo00<0
0?ooool01Ooo00<00?ooool01?oo00<00?ooool01_oo00<00?ooool01ooo00<00?ooool02?oo00<0
0?ooool02_oo00<00?ooool02ooo00<00?ooool03Ooo00<00?ooool02?oo0009ool00`00ooooo`0=
ool00`00ooooo`0<ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`06
ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`04ool00`00ooooo`04ool00`00ooooo`03
ool20004ool20003ool20005oolB0003ool40005ool20004ool00`00ooooo`03ool00`00ooooo`04
ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`08ool00`00ooooo`08
ool00`00ooooo`09ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`09ool000Woo`03003o
oooo00goo`03003ooooo00goo`03003ooooo00[oo`03003ooooo00Woo`03003ooooo00Ooo`03003o
oooo00Ooo`03003ooooo00Goo`03003ooooo00Goo`03003ooooo00Coo`03003ooooo00Coo`03003o
oooo00Coo`8000Coo`8000?oo`H000Ooo`03003ooooo00Soo`8000Goo`@000Goo`03003ooooo00?o
o`03003ooooo00Coo`03003ooooo00Goo`03003ooooo00Goo`03003ooooo00Goo`03003ooooo00So
o`03003ooooo00Soo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00goo`03003ooooo00Wo
o`002Ooo00<00?ooool03_oo00<00?ooool03?oo00<00?ooool02_oo00<00?ooool02Ooo00<00?oo
ool02?oo00<00?ooool01ooo00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01?oo0P001Ooo
00<00?ooool01Ooo00<00?ooool00ooo0P001ooo4P001?oo0`001_oo0`001Ooo00<00?ooool01?oo
00<00?ooool01Ooo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool02?oo00<00?ooool02?oo
00<00?ooool02Ooo00<00?ooool03?oo00<00?ooool03Ooo00<00?ooool02Ooo0009ool00`00oooo
o`0>ool00`00ooooo`0=ool00`00ooooo`0:ool00`00ooooo`09ool00`00ooooo`08ool00`00oooo
o`07ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`05ool00`00ooooo`03ool20006ool2
0005ool50009ool20009ool40006ool30006ool20006ool00`00ooooo`04ool20007ool00`00oooo
o`06ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`0:ool00`00ooooo`0<ool00`00oooo
o`0<ool00`00ooooo`0:ool000[oo`03003ooooo00koo`03003ooooo00coo`03003ooooo00_oo`03
003ooooo00Soo`03003ooooo00Soo`03003ooooo00Ooo`03003ooooo00Koo`03003ooooo00Goo`80
00Koo`03003ooooo00Coo`8000Koo`8000Soo`L000;oo`03003ooooo00;oo`H000Soo`8000Ooo`80
00Koo`8000Koo`03003ooooo00Koo`03003ooooo00Koo`03003ooooo00Soo`03003ooooo00Woo`03
003ooooo00Woo`03003ooooo00coo`03003ooooo00goo`03003ooooo00[oo`002_oo00<00?ooool0
3_oo00<00?ooool03Ooo00<00?ooool02_oo00<00?ooool02Ooo00<00?ooool02?oo00<00?ooool0
1ooo00<00?ooool01_oo00<00?ooool01_oo00<00?ooool01?oo0P001_oo0P001_oo1@002_oo1`00
2ooo0`001_oo0`001ooo00<00?ooool01Ooo00<00?ooool01_oo00<00?ooool01ooo00<00?ooool0
1ooo00<00?ooool02Ooo00<00?ooool02_oo00<00?ooool03?oo00<00?ooool03?oo00<00?ooool0
2ooo000:ool00`00ooooo`0>ool00`00ooooo`0=ool00`00ooooo`0;ool00`00ooooo`09ool00`00
ooooo`08ool00`00ooooo`06ool00`00ooooo`07ool00`00ooooo`06ool00`00ooooo`05ool20006
ool30008ool30009ool00`00ooooo`07ool60007ool20008ool20006ool20008ool00`00ooooo`07
ool00`00ooooo`07ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`0<ool00`00ooooo`0=
ool00`00ooooo`0;ool000[oo`03003ooooo00ooo`03003ooooo00coo`03003ooooo00_oo`03003o
oooo00[oo`03003ooooo00Ooo`03003ooooo00Ooo`03003ooooo00Ooo`03003ooooo00Koo`03003o
oooo00Koo`8000Ooo`@000Oooa<000[oo`<000Soo`8000Koo`8000Soo`8000Woo`03003ooooo00Oo
o`03003ooooo00Woo`03003ooooo00_oo`03003ooooo00_oo`03003ooooo00goo`03003ooooo00co
o`002ooo00<00?ooool03_oo00<00?ooool03Ooo00<00?ooool02ooo00<00?ooool02Ooo00<00?oo
ool02?oo00<00?ooool01ooo00<00?ooool01ooo00<00?ooool01_oo0P002?oo0`002?oo0P001_oo
00<00?ooool01Ooo00<00?ooool03?oo1@002?oo0`001ooo00<00?ooool01ooo00<00?ooool01ooo
0P002_oo00<00?ooool02?oo00<00?ooool02ooo00<00?ooool03?oo00<00?ooool03Ooo00<00?oo
ool03?oo000;ool00`00ooooo`0?ool00`00ooooo`0<ool00`00ooooo`0;ool00`00ooooo`0:ool0
0`00ooooo`08ool00`00ooooo`07ool20008ool20008ool20009ool20008ool50002ool00`00oooo
o`04ool30009ool3000;ool20008ool20009ool00`00ooooo`07ool00`00ooooo`09ool00`00oooo
o`08ool00`00ooooo`0;ool00`00ooooo`0<ool00`00ooooo`0=ool00`00ooooo`0=ool000coo`03
003ooooo00koo`03003ooooo00goo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00Soo`03
003ooooo00Soo`03003ooooo00Ooo`8000Soo`<000Soo`<000[ooaD000_oo`<000Soo`8000Woo`80
00Woo`03003ooooo00Woo`03003ooooo00Woo`03003ooooo00[oo`03003ooooo00coo`03003ooooo
00koo`03003ooooo00goo`003?oo00<00?ooool03ooo00<00?ooool03Ooo00<00?ooool02ooo00<0
0?ooool02_oo00<00?ooool02?oo0P002Ooo0P002Ooo0P002Ooo0P002Ooo0`002ooo00<00?ooool0
0_oo00<00?ooool04?oo10002Ooo0P002Ooo0P002Ooo0P002_oo0P002ooo00<00?ooool02_oo00<0
0?ooool03?oo00<00?ooool03_oo00<00?ooool03_oo000=ool00`00ooooo`0>ool00`00ooooo`0=
ool00`00ooooo`0<ool00`00ooooo`09ool00`00ooooo`0:ool00`00ooooo`08ool00`00ooooo`08
ool20009ool2000:ool60002ool01000ooooo`001?oo00<00?ooool02_oo1P002_oo0`002Ooo0P00
2_oo00<00?ooool02Ooo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool03Ooo00<00?ooool0
3_oo00<00?ooool03_oo000>ool00`00ooooo`0>ool00`00ooooo`0=ool00`00ooooo`0<ool00`00
ooooo`09ool00`00ooooo`0:ool00`00ooooo`08ool2000:ool20009ool2000>oolG000=ool3000:
ool2000:ool2000;ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0=ool00`00ooooo`0>
ool00`00ooooo`0?ool000koo`03003ooooo00ooo`03003ooooo00goo`03003ooooo00_oo`03003o
oooo00[oo`03003ooooo00[oo`8000[oo`03003ooooo00Woo`8000Woo`<001Goo`03003ooooo01?o
o`@000_oo`8000[oo`8000coo`03003ooooo00[oo`03003ooooo00[oo`03003ooooo00koo`03003o
oooo00goo`03003ooooo013oo`003ooo00<00?ooool03ooo00<00?ooool03Ooo00<00?ooool02ooo
00<00?ooool02_oo00<00?ooool02ooo00<00?ooool02?oo0P002ooo0P002_oo1`003_oo0P003ooo
1@003?oo0`002_oo0P003?oo0P003?oo00<00?ooool02_oo00<00?ooool03_oo00<00?ooool03Ooo
00<00?ooool04Ooo000?ool00`00ooooo`0@ool00`00ooooo`0<ool00`00ooooo`0<ool00`00oooo
o`0:ool2000<ool2000:ool2000;ool2000?ool50009ool00`00ooooo`0:ool4000>ool3000;ool2
000=ool00`00ooooo`0;ool00`00ooooo`0:ool00`00ooooo`0>ool00`00ooooo`0=ool00`00oooo
o`0Bool0013oo`03003ooooo00ooo`03003ooooo00goo`03003ooooo00coo`03003ooooo00_oo`03
003ooooo00_oo`03003ooooo00Woo`8000_oo`<0017ooaH000ooo`<000coo`8000koo`03003ooooo
00_oo`03003ooooo00[oo`03003ooooo00koo`03003ooooo00koo`03003ooooo01;oo`004Ooo00<0
0?ooool03ooo00<00?ooool03Ooo00<00?ooool03?oo00<00?ooool02ooo00<00?ooool02ooo0P00
2ooo0P003?oo10005_oo00<00?ooool05_oo0`003Ooo0P003_oo0P003?oo0P003?oo00<00?ooool0
3_oo00<00?ooool03_oo00<00?ooool04ooo000Aool00`00ooooo`0@ool00`00ooooo`0=ool00`00
ooooo`0<ool00`00ooooo`0;ool2000=ool2000;ool2000>ool4000Bool00`00ooooo`0Cool3000>
ool2000>ool2000<ool2000=ool00`00ooooo`0>ool00`00ooooo`0>ool00`00ooooo`0Dool001;o
o`03003ooooo013oo`03003ooooo00goo`03003ooooo00coo`8000goo`03003ooooo00coo`8000_o
o`<000ooo`L000_oo`03003ooooo00coo`L000ooo`8000koo`8000coo`8000koo`03003ooooo00ko
o`03003ooooo00koo`03003ooooo01Goo`004_oo00<00?ooool04?oo00<00?ooool03_oo00<00?oo
ool03Ooo00<00?ooool02ooo0P003_oo0P003?oo10004_oo6P004ooo0`003_oo0P003Ooo00<00?oo
ool03Ooo00<00?ooool03_oo00<00?ooool03_oo00<00?ooool05_oo000Cool00`00ooooo`0@ool0
0`00ooooo`0>ool00`00ooooo`0=ool00`00ooooo`0<ool00`00ooooo`0=ool2000>ool4000Iool0
0`00ooooo`0Mool2000?ool2000=ool2000>ool2000?ool2000Aool00`00ooooo`0Fool001Coo`03
003ooooo013oo`03003ooooo00koo`03003ooooo00goo`8000goo`8000ooo`80013oo`@001Goo`03
003ooooo01Woo`@000ooo`8000koo`03003ooooo00goo`03003ooooo00koo`03003ooooo013oo`03
003ooooo01Ooo`005Ooo00<00?ooool04?oo00<00?ooool03_oo00<00?ooool03_oo00<00?ooool0
3?oo0P003ooo0`004Ooo1@004?oo00<00?ooool04Ooo20003ooo10003ooo00<00?ooool03Ooo00<0
0?ooool03_oo00<00?ooool04?oo00<00?ooool06?oo000Fool00`00ooooo`0@ool00`00ooooo`0>
ool00`00ooooo`0>ool2000>ool2000@ool3000Cool5000;ool00`00ooooo`0=ool4000Dool3000A
ool2000?ool00`00ooooo`0>ool00`00ooooo`0@ool00`00ooooo`0Iool001Ooo`03003ooooo013o
o`03003ooooo00koo`80013oo`8000koo`80017oo`<001Gooa/001Goo`<001;oo`8000ooo`80013o
o`03003ooooo013oo`03003ooooo01[oo`006?oo00<00?ooool04?oo0P004?oo00<00?ooool03ooo
00<00?ooool03Ooo0`004Ooo0P007_oo0P008Ooo0P004ooo0P003ooo0P004?oo0P004_oo00<00?oo
ool06ooo000Iool00`00ooooo`0Aool00`00ooooo`0>ool00`00ooooo`0?ool2000@ool2000Aool2
000Lool00`00ooooo`0Lool4000Cool2000?ool2000Aool00`00ooooo`0@ool2000Nool001[oo`03
003ooooo017oo`03003ooooo00koo`80017oo`80013oo`<0013oo`@001Soo`03003ooooo01Ooo`D0
01Goo`8000ooo`80017oo`8001;oo`03003ooooo01koo`006ooo00<00?ooool04Ooo00<00?ooool0
3ooo00<00?ooool04?oo00<00?ooool04?oo0P004_oo2@003ooo00<00?ooool04_oo1@005ooo0`00
3ooo0P004_oo00<00?ooool04Ooo00<00?ooool07ooo000Lool00`00ooooo`0Aool00`00ooooo`0?
ool2000Aool2000Bool2000Iool:0005ool00`00ooooo`08ool:000Hool4000@ool2000Bool2000C
ool00`00ooooo`0Pool001goo`03003ooooo017oo`80017oo`80017oo`8001;oo`80023ooa4001oo
o`<001;oo`8001?oo`03003ooooo01;oo`03003ooooo027oo`007_oo00<00?ooool04_oo00<00?oo
ool04?oo0P004Ooo0P004_oo10006Ooo1@001?oo0`008ooo10004ooo0P004ooo0P005?oo00<00?oo
ool08_oo000Oool00`00ooooo`0Bool00`00ooooo`0Aool2000Aool3000Cool5000Dool01000oooo
o`001Ooo00<00?ooool07_oo1@005?oo0`004ooo0P005?oo0P005?oo00<00?ooool03_oo000Pool2
000Cool2000Cool00`00ooooo`0Aool2000Fool5000@ool00`00ool00005ool00`00ooooo`0Hool6
000Gool2000Eool00`00ooooo`0Cool00`00ooooo`0Cool00`00ooooo`0?ool002;oo`03003ooooo
01;oo`03003ooooo017oo`8001?oo`<001Soo`H000_oo`8000Goo`03003ooooo01?oo`D001[oo`<0
01Goo`8001Coo`8001Coo`8001;oo`008ooo00<00?ooool04_oo0P004ooo0P005?oo0`006ooo2P00
0_oo00<00?ooool00ooo00<00?ooool02Ooo2P007Ooo0P005_oo0P005?oo0P005Ooo00<00?ooool0
4_oo000Tool00`00ooooo`0Cool00`00ooooo`0Bool2000Eool3000RoolD000Tool3000Fool2000E
ool00`00ooooo`0Dool00`00ooooo`0Cool002Goo`03003ooooo01?oo`8001Coo`8001Koo`<002Oo
o`8002[oo`@001Ooo`8001Goo`8001Koo`03003ooooo01Coo`009_oo0P005Ooo00<00?ooool04ooo
0P005ooo0`009?oo00<00?ooool09Ooo10006?oo0`005_oo00<00?ooool05?oo0P005ooo000Xool0
0`00ooooo`0Cool2000Eool2000Hool4000Pool00`00ooooo`0Pool5000Jool2000Gool2000Fool0
0`00ooooo`0Gool002Woo`8001Goo`8001Goo`<001Woo`H001[oo`03003ooooo01[oo`H001goo`80
01Ooo`8001Ooo`03003ooooo01Soo`00:ooo00<00?ooool05?oo00<00?ooool05Ooo0`007?oo1P00
5?oo00<00?ooool05?oo1P008?oo0`005ooo0P005ooo0P006ooo000/ool00`00ooooo`0Dool2000H
ool3000Oool:000:ool00`00ooooo`0<ool8000Sool3000Hool2000Gool2000Mool002goo`8001Ko
o`8001Woo`<002KooaT002Soo`<001Woo`8001Soo`03003ooooo01goo`00;ooo00<00?ooool05Ooo
0P006_oo1000;?oo00<00?ooool0<Ooo0`006_oo0P006?oo0P008?oo000`ool2000Gool2000Lool4
000Xool00`00ooooo`0]ool4000Kool2000Hool2000Rool003;oo`03003ooooo01Koo`<001goo`@0
02Coo`03003ooooo02Soo`D001coo`<001Woo`03003ooooo02;oo`00<ooo0P006Ooo0P007ooo1000
8?oo00<00?ooool09?oo10007_oo0`006_oo0P009Ooo000eool2000Iool3000Pool5000Kool00`00
ooooo`0Nool6000Oool3000Kool2000Wool003Ooo`8001[oo`<002;oo`D001Koo`8001Soo`L002;o
o`<001coo`8002Woo`00>Ooo0P006ooo0`009?oo2`002ooo00<00?ooool03_oo2@009_oo0`007Ooo
0P00:ooo000kool2000Lool3000/oolL000/ool3000Nool2000]ool003goo`8001goo`<003Coo`03
003ooooo03Soo`8001ooo`8002ooo`00?ooo0`007Ooo0`00:_oo0P001Ooo00<00?ooool0=Ooo0`00
7ooo0P00<Ooo0012ool2000Nool4000Uool01000ooooo`001?oo00<00?ooool0<Ooo10008?oo0P00
<ooo0014ool2000Pool5000Pool01000ooooo`001?oo0`00;?oo1@008_oo0P00=Ooo0016ool3000R
ool6000Jool30005ool00`00ooooo`0Wool5000Tool3000gool004Woo`8002Koo`@001Koo`03003o
oooo00Goo`03003ooooo023oo`L002Koo`<003[oo`00Booo0P00:?oo1@004Ooo00<00?ooool01Ooo
00<00?ooool06?oo2000:Ooo1000?Ooo001=ool3000Zool=0005ool30004ool00`00ooooo`0?ool9
000^ool30011ool0053oo`@003?ooah003Coo`<004Coo`00E?oo0`00??oo0P00@Ooo0`00Aooo001G
ool4000hool00`00ooooo`0lool4001:ool005_oo`<003Goo`03003ooooo03Soo`@004koo`00G_oo
1000<Ooo00<00?ooool0=Ooo0`00D_oo001Rool5000/ool00`00ooooo`0aool4001Eool006Ooo`@0
02Soo`03003ooooo02_oo`H005Woo`00Jooo1P008_oo0P009?oo2000Gooo001aool8000Jool00`00
ooooo`0Kool8001Wool007Woo`/000ooo`03003ooooo01Coo`L006ooo`00Q?oo9P00M_oo002Cool0
0`00ooooo`2:ool009?oo`03003ooooo08[oo`00Tooo0P00Rooo002Cool00`00ooooo`2:ool00001
\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {318.5, 97.3125}} -> {-11.1006, \
-0.661375, 0.0498589, 0.0832502}}]
}, Open  ]],

Cell["\<\
A dissipative method typically exhibits linear error growth in the \
value of the Hamiltonian.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(InvariantErrorPlot[H, \ vars, \ T, \ solee, \ 
        SymbolStyle \[Rule] Green];\)\)], "Input",
  CellLabel->"In[15]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00953907 0.0238095 0.0358868 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21459 -0.0125 -6 -9 ]
[.21459 -0.0125 6 0 ]
[.40537 -0.0125 -6 -9 ]
[.40537 -0.0125 6 0 ]
[.59615 -0.0125 -6 -9 ]
[.59615 -0.0125 6 0 ]
[.78694 -0.0125 -6 -9 ]
[.78694 -0.0125 6 0 ]
[.97772 -0.0125 -9 -9 ]
[.97772 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .20324 -6 -4.5 ]
[-0.0125 .20324 0 4.5 ]
[-0.0125 .38268 -12 -4.5 ]
[-0.0125 .38268 0 4.5 ]
[-0.0125 .56211 -12 -4.5 ]
[-0.0125 .56211 0 4.5 ]
[-0.0125 .74155 -12 -4.5 ]
[-0.0125 .74155 0 4.5 ]
[-0.0125 .92098 -12 -4.5 ]
[-0.0125 .92098 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21459 0 m
.21459 .00625 L
s
[(20)] .21459 -0.0125 0 1 Mshowa
.40537 0 m
.40537 .00625 L
s
[(40)] .40537 -0.0125 0 1 Mshowa
.59615 0 m
.59615 .00625 L
s
[(60)] .59615 -0.0125 0 1 Mshowa
.78694 0 m
.78694 .00625 L
s
[(80)] .78694 -0.0125 0 1 Mshowa
.97772 0 m
.97772 .00625 L
s
[(100)] .97772 -0.0125 0 1 Mshowa
.125 Mabswid
.0715 0 m
.0715 .00375 L
s
.1192 0 m
.1192 .00375 L
s
.1669 0 m
.1669 .00375 L
s
.26229 0 m
.26229 .00375 L
s
.30998 0 m
.30998 .00375 L
s
.35768 0 m
.35768 .00375 L
s
.45307 0 m
.45307 .00375 L
s
.50076 0 m
.50076 .00375 L
s
.54846 0 m
.54846 .00375 L
s
.64385 0 m
.64385 .00375 L
s
.69154 0 m
.69154 .00375 L
s
.73924 0 m
.73924 .00375 L
s
.83463 0 m
.83463 .00375 L
s
.88233 0 m
.88233 .00375 L
s
.93002 0 m
.93002 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .20324 m
.00625 .20324 L
s
[(5)] -0.0125 .20324 1 0 Mshowa
0 .38268 m
.00625 .38268 L
s
[(10)] -0.0125 .38268 1 0 Mshowa
0 .56211 m
.00625 .56211 L
s
[(15)] -0.0125 .56211 1 0 Mshowa
0 .74155 m
.00625 .74155 L
s
[(20)] -0.0125 .74155 1 0 Mshowa
0 .92098 m
.00625 .92098 L
s
[(25)] -0.0125 .92098 1 0 Mshowa
.125 Mabswid
0 .0597 m
.00375 .0597 L
s
0 .09558 m
.00375 .09558 L
s
0 .13147 m
.00375 .13147 L
s
0 .16736 m
.00375 .16736 L
s
0 .23913 m
.00375 .23913 L
s
0 .27502 m
.00375 .27502 L
s
0 .3109 m
.00375 .3109 L
s
0 .34679 m
.00375 .34679 L
s
0 .41856 m
.00375 .41856 L
s
0 .45445 m
.00375 .45445 L
s
0 .49034 m
.00375 .49034 L
s
0 .52622 m
.00375 .52622 L
s
0 .598 m
.00375 .598 L
s
0 .63388 m
.00375 .63388 L
s
0 .66977 m
.00375 .66977 L
s
0 .70566 m
.00375 .70566 L
s
0 .77743 m
.00375 .77743 L
s
0 .81332 m
.00375 .81332 L
s
0 .84921 m
.00375 .84921 L
s
0 .88509 m
.00375 .88509 L
s
0 .95687 m
.00375 .95687 L
s
0 .99275 m
.00375 .99275 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21459 .99375 m
.21459 1 L
s
.40537 .99375 m
.40537 1 L
s
.59615 .99375 m
.59615 1 L
s
.78694 .99375 m
.78694 1 L
s
.97772 .99375 m
.97772 1 L
s
.125 Mabswid
.0715 .99625 m
.0715 1 L
s
.1192 .99625 m
.1192 1 L
s
.1669 .99625 m
.1669 1 L
s
.26229 .99625 m
.26229 1 L
s
.30998 .99625 m
.30998 1 L
s
.35768 .99625 m
.35768 1 L
s
.45307 .99625 m
.45307 1 L
s
.50076 .99625 m
.50076 1 L
s
.54846 .99625 m
.54846 1 L
s
.64385 .99625 m
.64385 1 L
s
.69154 .99625 m
.69154 1 L
s
.73924 .99625 m
.73924 1 L
s
.83463 .99625 m
.83463 1 L
s
.88233 .99625 m
.88233 1 L
s
.93002 .99625 m
.93002 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .20324 m
1 .20324 L
s
.99375 .38268 m
1 .38268 L
s
.99375 .56211 m
1 .56211 L
s
.99375 .74155 m
1 .74155 L
s
.99375 .92098 m
1 .92098 L
s
.125 Mabswid
.99625 .0597 m
1 .0597 L
s
.99625 .09558 m
1 .09558 L
s
.99625 .13147 m
1 .13147 L
s
.99625 .16736 m
1 .16736 L
s
.99625 .23913 m
1 .23913 L
s
.99625 .27502 m
1 .27502 L
s
.99625 .3109 m
1 .3109 L
s
.99625 .34679 m
1 .34679 L
s
.99625 .41856 m
1 .41856 L
s
.99625 .45445 m
1 .45445 L
s
.99625 .49034 m
1 .49034 L
s
.99625 .52622 m
1 .52622 L
s
.99625 .598 m
1 .598 L
s
.99625 .63388 m
1 .63388 L
s
.99625 .66977 m
1 .66977 L
s
.99625 .70566 m
1 .70566 L
s
.99625 .77743 m
1 .77743 L
s
.99625 .81332 m
1 .81332 L
s
.99625 .84921 m
1 .84921 L
s
.99625 .88509 m
1 .88509 L
s
.99625 .95687 m
1 .95687 L
s
.99625 .99275 m
1 .99275 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 1 0 r
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.02686 .02404 -1.875 0 Mabsadd m
.02686 .02404 0 2.5 Mabsadd L
.02686 .02404 1.875 0 Mabsadd L
.02686 .02404 0 -2.5 Mabsadd L
.02686 .02404 -1.875 0 Mabsadd L closepath F
.02991 .02427 -1.875 0 Mabsadd m
.02991 .02427 0 2.5 Mabsadd L
.02991 .02427 1.875 0 Mabsadd L
.02991 .02427 0 -2.5 Mabsadd L
.02991 .02427 -1.875 0 Mabsadd L closepath F
.03297 .02451 -1.875 0 Mabsadd m
.03297 .02451 0 2.5 Mabsadd L
.03297 .02451 1.875 0 Mabsadd L
.03297 .02451 0 -2.5 Mabsadd L
.03297 .02451 -1.875 0 Mabsadd L closepath F
.03602 .02475 -1.875 0 Mabsadd m
.03602 .02475 0 2.5 Mabsadd L
.03602 .02475 1.875 0 Mabsadd L
.03602 .02475 0 -2.5 Mabsadd L
.03602 .02475 -1.875 0 Mabsadd L closepath F
.03907 .02499 -1.875 0 Mabsadd m
.03907 .02499 0 2.5 Mabsadd L
.03907 .02499 1.875 0 Mabsadd L
.03907 .02499 0 -2.5 Mabsadd L
.03907 .02499 -1.875 0 Mabsadd L closepath F
.04212 .02524 -1.875 0 Mabsadd m
.04212 .02524 0 2.5 Mabsadd L
.04212 .02524 1.875 0 Mabsadd L
.04212 .02524 0 -2.5 Mabsadd L
.04212 .02524 -1.875 0 Mabsadd L closepath F
.04518 .02549 -1.875 0 Mabsadd m
.04518 .02549 0 2.5 Mabsadd L
.04518 .02549 1.875 0 Mabsadd L
.04518 .02549 0 -2.5 Mabsadd L
.04518 .02549 -1.875 0 Mabsadd L closepath F
.04823 .02574 -1.875 0 Mabsadd m
.04823 .02574 0 2.5 Mabsadd L
.04823 .02574 1.875 0 Mabsadd L
.04823 .02574 0 -2.5 Mabsadd L
.04823 .02574 -1.875 0 Mabsadd L closepath F
.05128 .026 -1.875 0 Mabsadd m
.05128 .026 0 2.5 Mabsadd L
.05128 .026 1.875 0 Mabsadd L
.05128 .026 0 -2.5 Mabsadd L
.05128 .026 -1.875 0 Mabsadd L closepath F
.05433 .02626 -1.875 0 Mabsadd m
.05433 .02626 0 2.5 Mabsadd L
.05433 .02626 1.875 0 Mabsadd L
.05433 .02626 0 -2.5 Mabsadd L
.05433 .02626 -1.875 0 Mabsadd L closepath F
.05739 .02652 -1.875 0 Mabsadd m
.05739 .02652 0 2.5 Mabsadd L
.05739 .02652 1.875 0 Mabsadd L
.05739 .02652 0 -2.5 Mabsadd L
.05739 .02652 -1.875 0 Mabsadd L closepath F
.06044 .02679 -1.875 0 Mabsadd m
.06044 .02679 0 2.5 Mabsadd L
.06044 .02679 1.875 0 Mabsadd L
.06044 .02679 0 -2.5 Mabsadd L
.06044 .02679 -1.875 0 Mabsadd L closepath F
.06349 .02706 -1.875 0 Mabsadd m
.06349 .02706 0 2.5 Mabsadd L
.06349 .02706 1.875 0 Mabsadd L
.06349 .02706 0 -2.5 Mabsadd L
.06349 .02706 -1.875 0 Mabsadd L closepath F
.06654 .02733 -1.875 0 Mabsadd m
.06654 .02733 0 2.5 Mabsadd L
.06654 .02733 1.875 0 Mabsadd L
.06654 .02733 0 -2.5 Mabsadd L
.06654 .02733 -1.875 0 Mabsadd L closepath F
.0696 .0276 -1.875 0 Mabsadd m
.0696 .0276 0 2.5 Mabsadd L
.0696 .0276 1.875 0 Mabsadd L
.0696 .0276 0 -2.5 Mabsadd L
.0696 .0276 -1.875 0 Mabsadd L closepath F
.07265 .02788 -1.875 0 Mabsadd m
.07265 .02788 0 2.5 Mabsadd L
.07265 .02788 1.875 0 Mabsadd L
.07265 .02788 0 -2.5 Mabsadd L
.07265 .02788 -1.875 0 Mabsadd L closepath F
.0757 .02817 -1.875 0 Mabsadd m
.0757 .02817 0 2.5 Mabsadd L
.0757 .02817 1.875 0 Mabsadd L
.0757 .02817 0 -2.5 Mabsadd L
.0757 .02817 -1.875 0 Mabsadd L closepath F
.07875 .02845 -1.875 0 Mabsadd m
.07875 .02845 0 2.5 Mabsadd L
.07875 .02845 1.875 0 Mabsadd L
.07875 .02845 0 -2.5 Mabsadd L
.07875 .02845 -1.875 0 Mabsadd L closepath F
.08181 .02875 -1.875 0 Mabsadd m
.08181 .02875 0 2.5 Mabsadd L
.08181 .02875 1.875 0 Mabsadd L
.08181 .02875 0 -2.5 Mabsadd L
.08181 .02875 -1.875 0 Mabsadd L closepath F
.08486 .02904 -1.875 0 Mabsadd m
.08486 .02904 0 2.5 Mabsadd L
.08486 .02904 1.875 0 Mabsadd L
.08486 .02904 0 -2.5 Mabsadd L
.08486 .02904 -1.875 0 Mabsadd L closepath F
.08791 .02934 -1.875 0 Mabsadd m
.08791 .02934 0 2.5 Mabsadd L
.08791 .02934 1.875 0 Mabsadd L
.08791 .02934 0 -2.5 Mabsadd L
.08791 .02934 -1.875 0 Mabsadd L closepath F
.09096 .02964 -1.875 0 Mabsadd m
.09096 .02964 0 2.5 Mabsadd L
.09096 .02964 1.875 0 Mabsadd L
.09096 .02964 0 -2.5 Mabsadd L
.09096 .02964 -1.875 0 Mabsadd L closepath F
.09402 .02995 -1.875 0 Mabsadd m
.09402 .02995 0 2.5 Mabsadd L
.09402 .02995 1.875 0 Mabsadd L
.09402 .02995 0 -2.5 Mabsadd L
.09402 .02995 -1.875 0 Mabsadd L closepath F
.09707 .03026 -1.875 0 Mabsadd m
.09707 .03026 0 2.5 Mabsadd L
.09707 .03026 1.875 0 Mabsadd L
.09707 .03026 0 -2.5 Mabsadd L
.09707 .03026 -1.875 0 Mabsadd L closepath F
.10012 .03057 -1.875 0 Mabsadd m
.10012 .03057 0 2.5 Mabsadd L
.10012 .03057 1.875 0 Mabsadd L
.10012 .03057 0 -2.5 Mabsadd L
.10012 .03057 -1.875 0 Mabsadd L closepath F
.10317 .03089 -1.875 0 Mabsadd m
.10317 .03089 0 2.5 Mabsadd L
.10317 .03089 1.875 0 Mabsadd L
.10317 .03089 0 -2.5 Mabsadd L
.10317 .03089 -1.875 0 Mabsadd L closepath F
.10623 .03121 -1.875 0 Mabsadd m
.10623 .03121 0 2.5 Mabsadd L
.10623 .03121 1.875 0 Mabsadd L
.10623 .03121 0 -2.5 Mabsadd L
.10623 .03121 -1.875 0 Mabsadd L closepath F
.10928 .03154 -1.875 0 Mabsadd m
.10928 .03154 0 2.5 Mabsadd L
.10928 .03154 1.875 0 Mabsadd L
.10928 .03154 0 -2.5 Mabsadd L
.10928 .03154 -1.875 0 Mabsadd L closepath F
.11233 .03187 -1.875 0 Mabsadd m
.11233 .03187 0 2.5 Mabsadd L
.11233 .03187 1.875 0 Mabsadd L
.11233 .03187 0 -2.5 Mabsadd L
.11233 .03187 -1.875 0 Mabsadd L closepath F
.11538 .0322 -1.875 0 Mabsadd m
.11538 .0322 0 2.5 Mabsadd L
.11538 .0322 1.875 0 Mabsadd L
.11538 .0322 0 -2.5 Mabsadd L
.11538 .0322 -1.875 0 Mabsadd L closepath F
.11844 .03254 -1.875 0 Mabsadd m
.11844 .03254 0 2.5 Mabsadd L
.11844 .03254 1.875 0 Mabsadd L
.11844 .03254 0 -2.5 Mabsadd L
.11844 .03254 -1.875 0 Mabsadd L closepath F
.12149 .03288 -1.875 0 Mabsadd m
.12149 .03288 0 2.5 Mabsadd L
.12149 .03288 1.875 0 Mabsadd L
.12149 .03288 0 -2.5 Mabsadd L
.12149 .03288 -1.875 0 Mabsadd L closepath F
.12454 .03323 -1.875 0 Mabsadd m
.12454 .03323 0 2.5 Mabsadd L
.12454 .03323 1.875 0 Mabsadd L
.12454 .03323 0 -2.5 Mabsadd L
.12454 .03323 -1.875 0 Mabsadd L closepath F
.12759 .03358 -1.875 0 Mabsadd m
.12759 .03358 0 2.5 Mabsadd L
.12759 .03358 1.875 0 Mabsadd L
.12759 .03358 0 -2.5 Mabsadd L
.12759 .03358 -1.875 0 Mabsadd L closepath F
.13065 .03394 -1.875 0 Mabsadd m
.13065 .03394 0 2.5 Mabsadd L
.13065 .03394 1.875 0 Mabsadd L
.13065 .03394 0 -2.5 Mabsadd L
.13065 .03394 -1.875 0 Mabsadd L closepath F
.1337 .0343 -1.875 0 Mabsadd m
.1337 .0343 0 2.5 Mabsadd L
.1337 .0343 1.875 0 Mabsadd L
.1337 .0343 0 -2.5 Mabsadd L
.1337 .0343 -1.875 0 Mabsadd L closepath F
.13675 .03467 -1.875 0 Mabsadd m
.13675 .03467 0 2.5 Mabsadd L
.13675 .03467 1.875 0 Mabsadd L
.13675 .03467 0 -2.5 Mabsadd L
.13675 .03467 -1.875 0 Mabsadd L closepath F
.1398 .03504 -1.875 0 Mabsadd m
.1398 .03504 0 2.5 Mabsadd L
.1398 .03504 1.875 0 Mabsadd L
.1398 .03504 0 -2.5 Mabsadd L
.1398 .03504 -1.875 0 Mabsadd L closepath F
.14286 .03541 -1.875 0 Mabsadd m
.14286 .03541 0 2.5 Mabsadd L
.14286 .03541 1.875 0 Mabsadd L
.14286 .03541 0 -2.5 Mabsadd L
.14286 .03541 -1.875 0 Mabsadd L closepath F
.14591 .03579 -1.875 0 Mabsadd m
.14591 .03579 0 2.5 Mabsadd L
.14591 .03579 1.875 0 Mabsadd L
.14591 .03579 0 -2.5 Mabsadd L
.14591 .03579 -1.875 0 Mabsadd L closepath F
.14896 .03618 -1.875 0 Mabsadd m
.14896 .03618 0 2.5 Mabsadd L
.14896 .03618 1.875 0 Mabsadd L
.14896 .03618 0 -2.5 Mabsadd L
.14896 .03618 -1.875 0 Mabsadd L closepath F
.15201 .03657 -1.875 0 Mabsadd m
.15201 .03657 0 2.5 Mabsadd L
.15201 .03657 1.875 0 Mabsadd L
.15201 .03657 0 -2.5 Mabsadd L
.15201 .03657 -1.875 0 Mabsadd L closepath F
.15507 .03697 -1.875 0 Mabsadd m
.15507 .03697 0 2.5 Mabsadd L
.15507 .03697 1.875 0 Mabsadd L
.15507 .03697 0 -2.5 Mabsadd L
.15507 .03697 -1.875 0 Mabsadd L closepath F
.15812 .03737 -1.875 0 Mabsadd m
.15812 .03737 0 2.5 Mabsadd L
.15812 .03737 1.875 0 Mabsadd L
.15812 .03737 0 -2.5 Mabsadd L
.15812 .03737 -1.875 0 Mabsadd L closepath F
.16117 .03777 -1.875 0 Mabsadd m
.16117 .03777 0 2.5 Mabsadd L
.16117 .03777 1.875 0 Mabsadd L
.16117 .03777 0 -2.5 Mabsadd L
.16117 .03777 -1.875 0 Mabsadd L closepath F
.16422 .03818 -1.875 0 Mabsadd m
.16422 .03818 0 2.5 Mabsadd L
.16422 .03818 1.875 0 Mabsadd L
.16422 .03818 0 -2.5 Mabsadd L
.16422 .03818 -1.875 0 Mabsadd L closepath F
.16728 .0386 -1.875 0 Mabsadd m
.16728 .0386 0 2.5 Mabsadd L
.16728 .0386 1.875 0 Mabsadd L
.16728 .0386 0 -2.5 Mabsadd L
.16728 .0386 -1.875 0 Mabsadd L closepath F
.17033 .03902 -1.875 0 Mabsadd m
.17033 .03902 0 2.5 Mabsadd L
.17033 .03902 1.875 0 Mabsadd L
.17033 .03902 0 -2.5 Mabsadd L
.17033 .03902 -1.875 0 Mabsadd L closepath F
.17338 .03945 -1.875 0 Mabsadd m
.17338 .03945 0 2.5 Mabsadd L
.17338 .03945 1.875 0 Mabsadd L
.17338 .03945 0 -2.5 Mabsadd L
.17338 .03945 -1.875 0 Mabsadd L closepath F
.17643 .03988 -1.875 0 Mabsadd m
.17643 .03988 0 2.5 Mabsadd L
.17643 .03988 1.875 0 Mabsadd L
.17643 .03988 0 -2.5 Mabsadd L
.17643 .03988 -1.875 0 Mabsadd L closepath F
.17949 .04032 -1.875 0 Mabsadd m
.17949 .04032 0 2.5 Mabsadd L
.17949 .04032 1.875 0 Mabsadd L
.17949 .04032 0 -2.5 Mabsadd L
.17949 .04032 -1.875 0 Mabsadd L closepath F
.18254 .04076 -1.875 0 Mabsadd m
.18254 .04076 0 2.5 Mabsadd L
.18254 .04076 1.875 0 Mabsadd L
.18254 .04076 0 -2.5 Mabsadd L
.18254 .04076 -1.875 0 Mabsadd L closepath F
.18559 .04121 -1.875 0 Mabsadd m
.18559 .04121 0 2.5 Mabsadd L
.18559 .04121 1.875 0 Mabsadd L
.18559 .04121 0 -2.5 Mabsadd L
.18559 .04121 -1.875 0 Mabsadd L closepath F
.18864 .04166 -1.875 0 Mabsadd m
.18864 .04166 0 2.5 Mabsadd L
.18864 .04166 1.875 0 Mabsadd L
.18864 .04166 0 -2.5 Mabsadd L
.18864 .04166 -1.875 0 Mabsadd L closepath F
.1917 .04212 -1.875 0 Mabsadd m
.1917 .04212 0 2.5 Mabsadd L
.1917 .04212 1.875 0 Mabsadd L
.1917 .04212 0 -2.5 Mabsadd L
.1917 .04212 -1.875 0 Mabsadd L closepath F
.19475 .04259 -1.875 0 Mabsadd m
.19475 .04259 0 2.5 Mabsadd L
.19475 .04259 1.875 0 Mabsadd L
.19475 .04259 0 -2.5 Mabsadd L
.19475 .04259 -1.875 0 Mabsadd L closepath F
.1978 .04306 -1.875 0 Mabsadd m
.1978 .04306 0 2.5 Mabsadd L
.1978 .04306 1.875 0 Mabsadd L
.1978 .04306 0 -2.5 Mabsadd L
.1978 .04306 -1.875 0 Mabsadd L closepath F
.20085 .04354 -1.875 0 Mabsadd m
.20085 .04354 0 2.5 Mabsadd L
.20085 .04354 1.875 0 Mabsadd L
.20085 .04354 0 -2.5 Mabsadd L
.20085 .04354 -1.875 0 Mabsadd L closepath F
.20391 .04403 -1.875 0 Mabsadd m
.20391 .04403 0 2.5 Mabsadd L
.20391 .04403 1.875 0 Mabsadd L
.20391 .04403 0 -2.5 Mabsadd L
.20391 .04403 -1.875 0 Mabsadd L closepath F
.20696 .04452 -1.875 0 Mabsadd m
.20696 .04452 0 2.5 Mabsadd L
.20696 .04452 1.875 0 Mabsadd L
.20696 .04452 0 -2.5 Mabsadd L
.20696 .04452 -1.875 0 Mabsadd L closepath F
.21001 .04502 -1.875 0 Mabsadd m
.21001 .04502 0 2.5 Mabsadd L
.21001 .04502 1.875 0 Mabsadd L
.21001 .04502 0 -2.5 Mabsadd L
.21001 .04502 -1.875 0 Mabsadd L closepath F
.21306 .04552 -1.875 0 Mabsadd m
.21306 .04552 0 2.5 Mabsadd L
.21306 .04552 1.875 0 Mabsadd L
.21306 .04552 0 -2.5 Mabsadd L
.21306 .04552 -1.875 0 Mabsadd L closepath F
.21612 .04603 -1.875 0 Mabsadd m
.21612 .04603 0 2.5 Mabsadd L
.21612 .04603 1.875 0 Mabsadd L
.21612 .04603 0 -2.5 Mabsadd L
.21612 .04603 -1.875 0 Mabsadd L closepath F
.21917 .04655 -1.875 0 Mabsadd m
.21917 .04655 0 2.5 Mabsadd L
.21917 .04655 1.875 0 Mabsadd L
.21917 .04655 0 -2.5 Mabsadd L
.21917 .04655 -1.875 0 Mabsadd L closepath F
.22222 .04707 -1.875 0 Mabsadd m
.22222 .04707 0 2.5 Mabsadd L
.22222 .04707 1.875 0 Mabsadd L
.22222 .04707 0 -2.5 Mabsadd L
.22222 .04707 -1.875 0 Mabsadd L closepath F
.22527 .0476 -1.875 0 Mabsadd m
.22527 .0476 0 2.5 Mabsadd L
.22527 .0476 1.875 0 Mabsadd L
.22527 .0476 0 -2.5 Mabsadd L
.22527 .0476 -1.875 0 Mabsadd L closepath F
.22833 .04814 -1.875 0 Mabsadd m
.22833 .04814 0 2.5 Mabsadd L
.22833 .04814 1.875 0 Mabsadd L
.22833 .04814 0 -2.5 Mabsadd L
.22833 .04814 -1.875 0 Mabsadd L closepath F
.23138 .04868 -1.875 0 Mabsadd m
.23138 .04868 0 2.5 Mabsadd L
.23138 .04868 1.875 0 Mabsadd L
.23138 .04868 0 -2.5 Mabsadd L
.23138 .04868 -1.875 0 Mabsadd L closepath F
.23443 .04923 -1.875 0 Mabsadd m
.23443 .04923 0 2.5 Mabsadd L
.23443 .04923 1.875 0 Mabsadd L
.23443 .04923 0 -2.5 Mabsadd L
.23443 .04923 -1.875 0 Mabsadd L closepath F
.23748 .04979 -1.875 0 Mabsadd m
.23748 .04979 0 2.5 Mabsadd L
.23748 .04979 1.875 0 Mabsadd L
.23748 .04979 0 -2.5 Mabsadd L
.23748 .04979 -1.875 0 Mabsadd L closepath F
.24054 .05036 -1.875 0 Mabsadd m
.24054 .05036 0 2.5 Mabsadd L
.24054 .05036 1.875 0 Mabsadd L
.24054 .05036 0 -2.5 Mabsadd L
.24054 .05036 -1.875 0 Mabsadd L closepath F
.24359 .05093 -1.875 0 Mabsadd m
.24359 .05093 0 2.5 Mabsadd L
.24359 .05093 1.875 0 Mabsadd L
.24359 .05093 0 -2.5 Mabsadd L
.24359 .05093 -1.875 0 Mabsadd L closepath F
.24664 .05151 -1.875 0 Mabsadd m
.24664 .05151 0 2.5 Mabsadd L
.24664 .05151 1.875 0 Mabsadd L
.24664 .05151 0 -2.5 Mabsadd L
.24664 .05151 -1.875 0 Mabsadd L closepath F
.24969 .0521 -1.875 0 Mabsadd m
.24969 .0521 0 2.5 Mabsadd L
.24969 .0521 1.875 0 Mabsadd L
.24969 .0521 0 -2.5 Mabsadd L
.24969 .0521 -1.875 0 Mabsadd L closepath F
.25275 .05269 -1.875 0 Mabsadd m
.25275 .05269 0 2.5 Mabsadd L
.25275 .05269 1.875 0 Mabsadd L
.25275 .05269 0 -2.5 Mabsadd L
.25275 .05269 -1.875 0 Mabsadd L closepath F
.2558 .0533 -1.875 0 Mabsadd m
.2558 .0533 0 2.5 Mabsadd L
.2558 .0533 1.875 0 Mabsadd L
.2558 .0533 0 -2.5 Mabsadd L
.2558 .0533 -1.875 0 Mabsadd L closepath F
.25885 .05391 -1.875 0 Mabsadd m
.25885 .05391 0 2.5 Mabsadd L
.25885 .05391 1.875 0 Mabsadd L
.25885 .05391 0 -2.5 Mabsadd L
.25885 .05391 -1.875 0 Mabsadd L closepath F
.2619 .05452 -1.875 0 Mabsadd m
.2619 .05452 0 2.5 Mabsadd L
.2619 .05452 1.875 0 Mabsadd L
.2619 .05452 0 -2.5 Mabsadd L
.2619 .05452 -1.875 0 Mabsadd L closepath F
.26496 .05515 -1.875 0 Mabsadd m
.26496 .05515 0 2.5 Mabsadd L
.26496 .05515 1.875 0 Mabsadd L
.26496 .05515 0 -2.5 Mabsadd L
.26496 .05515 -1.875 0 Mabsadd L closepath F
.26801 .05579 -1.875 0 Mabsadd m
.26801 .05579 0 2.5 Mabsadd L
.26801 .05579 1.875 0 Mabsadd L
.26801 .05579 0 -2.5 Mabsadd L
.26801 .05579 -1.875 0 Mabsadd L closepath F
.27106 .05643 -1.875 0 Mabsadd m
.27106 .05643 0 2.5 Mabsadd L
.27106 .05643 1.875 0 Mabsadd L
.27106 .05643 0 -2.5 Mabsadd L
.27106 .05643 -1.875 0 Mabsadd L closepath F
.27411 .05708 -1.875 0 Mabsadd m
.27411 .05708 0 2.5 Mabsadd L
.27411 .05708 1.875 0 Mabsadd L
.27411 .05708 0 -2.5 Mabsadd L
.27411 .05708 -1.875 0 Mabsadd L closepath F
.27717 .05774 -1.875 0 Mabsadd m
.27717 .05774 0 2.5 Mabsadd L
.27717 .05774 1.875 0 Mabsadd L
.27717 .05774 0 -2.5 Mabsadd L
.27717 .05774 -1.875 0 Mabsadd L closepath F
.28022 .05841 -1.875 0 Mabsadd m
.28022 .05841 0 2.5 Mabsadd L
.28022 .05841 1.875 0 Mabsadd L
.28022 .05841 0 -2.5 Mabsadd L
.28022 .05841 -1.875 0 Mabsadd L closepath F
.28327 .05908 -1.875 0 Mabsadd m
.28327 .05908 0 2.5 Mabsadd L
.28327 .05908 1.875 0 Mabsadd L
.28327 .05908 0 -2.5 Mabsadd L
.28327 .05908 -1.875 0 Mabsadd L closepath F
.28632 .05977 -1.875 0 Mabsadd m
.28632 .05977 0 2.5 Mabsadd L
.28632 .05977 1.875 0 Mabsadd L
.28632 .05977 0 -2.5 Mabsadd L
.28632 .05977 -1.875 0 Mabsadd L closepath F
.28938 .06046 -1.875 0 Mabsadd m
.28938 .06046 0 2.5 Mabsadd L
.28938 .06046 1.875 0 Mabsadd L
.28938 .06046 0 -2.5 Mabsadd L
.28938 .06046 -1.875 0 Mabsadd L closepath F
.29243 .06116 -1.875 0 Mabsadd m
.29243 .06116 0 2.5 Mabsadd L
.29243 .06116 1.875 0 Mabsadd L
.29243 .06116 0 -2.5 Mabsadd L
.29243 .06116 -1.875 0 Mabsadd L closepath F
.29548 .06188 -1.875 0 Mabsadd m
.29548 .06188 0 2.5 Mabsadd L
.29548 .06188 1.875 0 Mabsadd L
.29548 .06188 0 -2.5 Mabsadd L
.29548 .06188 -1.875 0 Mabsadd L closepath F
.29853 .0626 -1.875 0 Mabsadd m
.29853 .0626 0 2.5 Mabsadd L
.29853 .0626 1.875 0 Mabsadd L
.29853 .0626 0 -2.5 Mabsadd L
.29853 .0626 -1.875 0 Mabsadd L closepath F
.30159 .06333 -1.875 0 Mabsadd m
.30159 .06333 0 2.5 Mabsadd L
.30159 .06333 1.875 0 Mabsadd L
.30159 .06333 0 -2.5 Mabsadd L
.30159 .06333 -1.875 0 Mabsadd L closepath F
.30464 .06407 -1.875 0 Mabsadd m
.30464 .06407 0 2.5 Mabsadd L
.30464 .06407 1.875 0 Mabsadd L
.30464 .06407 0 -2.5 Mabsadd L
.30464 .06407 -1.875 0 Mabsadd L closepath F
.30769 .06482 -1.875 0 Mabsadd m
.30769 .06482 0 2.5 Mabsadd L
.30769 .06482 1.875 0 Mabsadd L
.30769 .06482 0 -2.5 Mabsadd L
.30769 .06482 -1.875 0 Mabsadd L closepath F
.31074 .06557 -1.875 0 Mabsadd m
.31074 .06557 0 2.5 Mabsadd L
.31074 .06557 1.875 0 Mabsadd L
.31074 .06557 0 -2.5 Mabsadd L
.31074 .06557 -1.875 0 Mabsadd L closepath F
.3138 .06634 -1.875 0 Mabsadd m
.3138 .06634 0 2.5 Mabsadd L
.3138 .06634 1.875 0 Mabsadd L
.3138 .06634 0 -2.5 Mabsadd L
.3138 .06634 -1.875 0 Mabsadd L closepath F
.31685 .06712 -1.875 0 Mabsadd m
.31685 .06712 0 2.5 Mabsadd L
.31685 .06712 1.875 0 Mabsadd L
.31685 .06712 0 -2.5 Mabsadd L
.31685 .06712 -1.875 0 Mabsadd L closepath F
.3199 .06791 -1.875 0 Mabsadd m
.3199 .06791 0 2.5 Mabsadd L
.3199 .06791 1.875 0 Mabsadd L
.3199 .06791 0 -2.5 Mabsadd L
.3199 .06791 -1.875 0 Mabsadd L closepath F
.32295 .06871 -1.875 0 Mabsadd m
.32295 .06871 0 2.5 Mabsadd L
.32295 .06871 1.875 0 Mabsadd L
.32295 .06871 0 -2.5 Mabsadd L
.32295 .06871 -1.875 0 Mabsadd L closepath F
.32601 .06952 -1.875 0 Mabsadd m
.32601 .06952 0 2.5 Mabsadd L
.32601 .06952 1.875 0 Mabsadd L
.32601 .06952 0 -2.5 Mabsadd L
.32601 .06952 -1.875 0 Mabsadd L closepath F
.32906 .07034 -1.875 0 Mabsadd m
.32906 .07034 0 2.5 Mabsadd L
.32906 .07034 1.875 0 Mabsadd L
.32906 .07034 0 -2.5 Mabsadd L
.32906 .07034 -1.875 0 Mabsadd L closepath F
.33211 .07117 -1.875 0 Mabsadd m
.33211 .07117 0 2.5 Mabsadd L
.33211 .07117 1.875 0 Mabsadd L
.33211 .07117 0 -2.5 Mabsadd L
.33211 .07117 -1.875 0 Mabsadd L closepath F
.33516 .07201 -1.875 0 Mabsadd m
.33516 .07201 0 2.5 Mabsadd L
.33516 .07201 1.875 0 Mabsadd L
.33516 .07201 0 -2.5 Mabsadd L
.33516 .07201 -1.875 0 Mabsadd L closepath F
.33822 .07286 -1.875 0 Mabsadd m
.33822 .07286 0 2.5 Mabsadd L
.33822 .07286 1.875 0 Mabsadd L
.33822 .07286 0 -2.5 Mabsadd L
.33822 .07286 -1.875 0 Mabsadd L closepath F
.34127 .07372 -1.875 0 Mabsadd m
.34127 .07372 0 2.5 Mabsadd L
.34127 .07372 1.875 0 Mabsadd L
.34127 .07372 0 -2.5 Mabsadd L
.34127 .07372 -1.875 0 Mabsadd L closepath F
.34432 .07459 -1.875 0 Mabsadd m
.34432 .07459 0 2.5 Mabsadd L
.34432 .07459 1.875 0 Mabsadd L
.34432 .07459 0 -2.5 Mabsadd L
.34432 .07459 -1.875 0 Mabsadd L closepath F
.34737 .07548 -1.875 0 Mabsadd m
.34737 .07548 0 2.5 Mabsadd L
.34737 .07548 1.875 0 Mabsadd L
.34737 .07548 0 -2.5 Mabsadd L
.34737 .07548 -1.875 0 Mabsadd L closepath F
.35043 .07637 -1.875 0 Mabsadd m
.35043 .07637 0 2.5 Mabsadd L
.35043 .07637 1.875 0 Mabsadd L
.35043 .07637 0 -2.5 Mabsadd L
.35043 .07637 -1.875 0 Mabsadd L closepath F
.35348 .07728 -1.875 0 Mabsadd m
.35348 .07728 0 2.5 Mabsadd L
.35348 .07728 1.875 0 Mabsadd L
.35348 .07728 0 -2.5 Mabsadd L
.35348 .07728 -1.875 0 Mabsadd L closepath F
.35653 .0782 -1.875 0 Mabsadd m
.35653 .0782 0 2.5 Mabsadd L
.35653 .0782 1.875 0 Mabsadd L
.35653 .0782 0 -2.5 Mabsadd L
.35653 .0782 -1.875 0 Mabsadd L closepath F
.35958 .07913 -1.875 0 Mabsadd m
.35958 .07913 0 2.5 Mabsadd L
.35958 .07913 1.875 0 Mabsadd L
.35958 .07913 0 -2.5 Mabsadd L
.35958 .07913 -1.875 0 Mabsadd L closepath F
.36264 .08008 -1.875 0 Mabsadd m
.36264 .08008 0 2.5 Mabsadd L
.36264 .08008 1.875 0 Mabsadd L
.36264 .08008 0 -2.5 Mabsadd L
.36264 .08008 -1.875 0 Mabsadd L closepath F
.36569 .08103 -1.875 0 Mabsadd m
.36569 .08103 0 2.5 Mabsadd L
.36569 .08103 1.875 0 Mabsadd L
.36569 .08103 0 -2.5 Mabsadd L
.36569 .08103 -1.875 0 Mabsadd L closepath F
.36874 .082 -1.875 0 Mabsadd m
.36874 .082 0 2.5 Mabsadd L
.36874 .082 1.875 0 Mabsadd L
.36874 .082 0 -2.5 Mabsadd L
.36874 .082 -1.875 0 Mabsadd L closepath F
.37179 .08298 -1.875 0 Mabsadd m
.37179 .08298 0 2.5 Mabsadd L
.37179 .08298 1.875 0 Mabsadd L
.37179 .08298 0 -2.5 Mabsadd L
.37179 .08298 -1.875 0 Mabsadd L closepath F
.37485 .08397 -1.875 0 Mabsadd m
.37485 .08397 0 2.5 Mabsadd L
.37485 .08397 1.875 0 Mabsadd L
.37485 .08397 0 -2.5 Mabsadd L
.37485 .08397 -1.875 0 Mabsadd L closepath F
.3779 .08498 -1.875 0 Mabsadd m
.3779 .08498 0 2.5 Mabsadd L
.3779 .08498 1.875 0 Mabsadd L
.3779 .08498 0 -2.5 Mabsadd L
.3779 .08498 -1.875 0 Mabsadd L closepath F
.38095 .08599 -1.875 0 Mabsadd m
.38095 .08599 0 2.5 Mabsadd L
.38095 .08599 1.875 0 Mabsadd L
.38095 .08599 0 -2.5 Mabsadd L
.38095 .08599 -1.875 0 Mabsadd L closepath F
.384 .08703 -1.875 0 Mabsadd m
.384 .08703 0 2.5 Mabsadd L
.384 .08703 1.875 0 Mabsadd L
.384 .08703 0 -2.5 Mabsadd L
.384 .08703 -1.875 0 Mabsadd L closepath F
.38706 .08807 -1.875 0 Mabsadd m
.38706 .08807 0 2.5 Mabsadd L
.38706 .08807 1.875 0 Mabsadd L
.38706 .08807 0 -2.5 Mabsadd L
.38706 .08807 -1.875 0 Mabsadd L closepath F
.39011 .08913 -1.875 0 Mabsadd m
.39011 .08913 0 2.5 Mabsadd L
.39011 .08913 1.875 0 Mabsadd L
.39011 .08913 0 -2.5 Mabsadd L
.39011 .08913 -1.875 0 Mabsadd L closepath F
.39316 .0902 -1.875 0 Mabsadd m
.39316 .0902 0 2.5 Mabsadd L
.39316 .0902 1.875 0 Mabsadd L
.39316 .0902 0 -2.5 Mabsadd L
.39316 .0902 -1.875 0 Mabsadd L closepath F
.39621 .09129 -1.875 0 Mabsadd m
.39621 .09129 0 2.5 Mabsadd L
.39621 .09129 1.875 0 Mabsadd L
.39621 .09129 0 -2.5 Mabsadd L
.39621 .09129 -1.875 0 Mabsadd L closepath F
.39927 .09239 -1.875 0 Mabsadd m
.39927 .09239 0 2.5 Mabsadd L
.39927 .09239 1.875 0 Mabsadd L
.39927 .09239 0 -2.5 Mabsadd L
.39927 .09239 -1.875 0 Mabsadd L closepath F
.40232 .0935 -1.875 0 Mabsadd m
.40232 .0935 0 2.5 Mabsadd L
.40232 .0935 1.875 0 Mabsadd L
.40232 .0935 0 -2.5 Mabsadd L
.40232 .0935 -1.875 0 Mabsadd L closepath F
.40537 .09463 -1.875 0 Mabsadd m
.40537 .09463 0 2.5 Mabsadd L
.40537 .09463 1.875 0 Mabsadd L
.40537 .09463 0 -2.5 Mabsadd L
.40537 .09463 -1.875 0 Mabsadd L closepath F
.40842 .09577 -1.875 0 Mabsadd m
.40842 .09577 0 2.5 Mabsadd L
.40842 .09577 1.875 0 Mabsadd L
.40842 .09577 0 -2.5 Mabsadd L
.40842 .09577 -1.875 0 Mabsadd L closepath F
.41148 .09693 -1.875 0 Mabsadd m
.41148 .09693 0 2.5 Mabsadd L
.41148 .09693 1.875 0 Mabsadd L
.41148 .09693 0 -2.5 Mabsadd L
.41148 .09693 -1.875 0 Mabsadd L closepath F
.41453 .0981 -1.875 0 Mabsadd m
.41453 .0981 0 2.5 Mabsadd L
.41453 .0981 1.875 0 Mabsadd L
.41453 .0981 0 -2.5 Mabsadd L
.41453 .0981 -1.875 0 Mabsadd L closepath F
.41758 .09929 -1.875 0 Mabsadd m
.41758 .09929 0 2.5 Mabsadd L
.41758 .09929 1.875 0 Mabsadd L
.41758 .09929 0 -2.5 Mabsadd L
.41758 .09929 -1.875 0 Mabsadd L closepath F
.42063 .10049 -1.875 0 Mabsadd m
.42063 .10049 0 2.5 Mabsadd L
.42063 .10049 1.875 0 Mabsadd L
.42063 .10049 0 -2.5 Mabsadd L
.42063 .10049 -1.875 0 Mabsadd L closepath F
.42369 .10171 -1.875 0 Mabsadd m
.42369 .10171 0 2.5 Mabsadd L
.42369 .10171 1.875 0 Mabsadd L
.42369 .10171 0 -2.5 Mabsadd L
.42369 .10171 -1.875 0 Mabsadd L closepath F
.42674 .10294 -1.875 0 Mabsadd m
.42674 .10294 0 2.5 Mabsadd L
.42674 .10294 1.875 0 Mabsadd L
.42674 .10294 0 -2.5 Mabsadd L
.42674 .10294 -1.875 0 Mabsadd L closepath F
.42979 .10419 -1.875 0 Mabsadd m
.42979 .10419 0 2.5 Mabsadd L
.42979 .10419 1.875 0 Mabsadd L
.42979 .10419 0 -2.5 Mabsadd L
.42979 .10419 -1.875 0 Mabsadd L closepath F
.43284 .10546 -1.875 0 Mabsadd m
.43284 .10546 0 2.5 Mabsadd L
.43284 .10546 1.875 0 Mabsadd L
.43284 .10546 0 -2.5 Mabsadd L
.43284 .10546 -1.875 0 Mabsadd L closepath F
.4359 .10674 -1.875 0 Mabsadd m
.4359 .10674 0 2.5 Mabsadd L
.4359 .10674 1.875 0 Mabsadd L
.4359 .10674 0 -2.5 Mabsadd L
.4359 .10674 -1.875 0 Mabsadd L closepath F
.43895 .10804 -1.875 0 Mabsadd m
.43895 .10804 0 2.5 Mabsadd L
.43895 .10804 1.875 0 Mabsadd L
.43895 .10804 0 -2.5 Mabsadd L
.43895 .10804 -1.875 0 Mabsadd L closepath F
.442 .10935 -1.875 0 Mabsadd m
.442 .10935 0 2.5 Mabsadd L
.442 .10935 1.875 0 Mabsadd L
.442 .10935 0 -2.5 Mabsadd L
.442 .10935 -1.875 0 Mabsadd L closepath F
.44505 .11068 -1.875 0 Mabsadd m
.44505 .11068 0 2.5 Mabsadd L
.44505 .11068 1.875 0 Mabsadd L
.44505 .11068 0 -2.5 Mabsadd L
.44505 .11068 -1.875 0 Mabsadd L closepath F
.44811 .11203 -1.875 0 Mabsadd m
.44811 .11203 0 2.5 Mabsadd L
.44811 .11203 1.875 0 Mabsadd L
.44811 .11203 0 -2.5 Mabsadd L
.44811 .11203 -1.875 0 Mabsadd L closepath F
.45116 .1134 -1.875 0 Mabsadd m
.45116 .1134 0 2.5 Mabsadd L
.45116 .1134 1.875 0 Mabsadd L
.45116 .1134 0 -2.5 Mabsadd L
.45116 .1134 -1.875 0 Mabsadd L closepath F
.45421 .11478 -1.875 0 Mabsadd m
.45421 .11478 0 2.5 Mabsadd L
.45421 .11478 1.875 0 Mabsadd L
.45421 .11478 0 -2.5 Mabsadd L
.45421 .11478 -1.875 0 Mabsadd L closepath F
.45726 .11618 -1.875 0 Mabsadd m
.45726 .11618 0 2.5 Mabsadd L
.45726 .11618 1.875 0 Mabsadd L
.45726 .11618 0 -2.5 Mabsadd L
.45726 .11618 -1.875 0 Mabsadd L closepath F
.46032 .1176 -1.875 0 Mabsadd m
.46032 .1176 0 2.5 Mabsadd L
.46032 .1176 1.875 0 Mabsadd L
.46032 .1176 0 -2.5 Mabsadd L
.46032 .1176 -1.875 0 Mabsadd L closepath F
.46337 .11904 -1.875 0 Mabsadd m
.46337 .11904 0 2.5 Mabsadd L
.46337 .11904 1.875 0 Mabsadd L
.46337 .11904 0 -2.5 Mabsadd L
.46337 .11904 -1.875 0 Mabsadd L closepath F
.46642 .1205 -1.875 0 Mabsadd m
.46642 .1205 0 2.5 Mabsadd L
.46642 .1205 1.875 0 Mabsadd L
.46642 .1205 0 -2.5 Mabsadd L
.46642 .1205 -1.875 0 Mabsadd L closepath F
.46947 .12198 -1.875 0 Mabsadd m
.46947 .12198 0 2.5 Mabsadd L
.46947 .12198 1.875 0 Mabsadd L
.46947 .12198 0 -2.5 Mabsadd L
.46947 .12198 -1.875 0 Mabsadd L closepath F
.47253 .12347 -1.875 0 Mabsadd m
.47253 .12347 0 2.5 Mabsadd L
.47253 .12347 1.875 0 Mabsadd L
.47253 .12347 0 -2.5 Mabsadd L
.47253 .12347 -1.875 0 Mabsadd L closepath F
.47558 .12498 -1.875 0 Mabsadd m
.47558 .12498 0 2.5 Mabsadd L
.47558 .12498 1.875 0 Mabsadd L
.47558 .12498 0 -2.5 Mabsadd L
.47558 .12498 -1.875 0 Mabsadd L closepath F
.47863 .12652 -1.875 0 Mabsadd m
.47863 .12652 0 2.5 Mabsadd L
.47863 .12652 1.875 0 Mabsadd L
.47863 .12652 0 -2.5 Mabsadd L
.47863 .12652 -1.875 0 Mabsadd L closepath F
.48168 .12807 -1.875 0 Mabsadd m
.48168 .12807 0 2.5 Mabsadd L
.48168 .12807 1.875 0 Mabsadd L
.48168 .12807 0 -2.5 Mabsadd L
.48168 .12807 -1.875 0 Mabsadd L closepath F
.48474 .12964 -1.875 0 Mabsadd m
.48474 .12964 0 2.5 Mabsadd L
.48474 .12964 1.875 0 Mabsadd L
.48474 .12964 0 -2.5 Mabsadd L
.48474 .12964 -1.875 0 Mabsadd L closepath F
.48779 .13124 -1.875 0 Mabsadd m
.48779 .13124 0 2.5 Mabsadd L
.48779 .13124 1.875 0 Mabsadd L
.48779 .13124 0 -2.5 Mabsadd L
.48779 .13124 -1.875 0 Mabsadd L closepath F
.49084 .13285 -1.875 0 Mabsadd m
.49084 .13285 0 2.5 Mabsadd L
.49084 .13285 1.875 0 Mabsadd L
.49084 .13285 0 -2.5 Mabsadd L
.49084 .13285 -1.875 0 Mabsadd L closepath F
.49389 .13448 -1.875 0 Mabsadd m
.49389 .13448 0 2.5 Mabsadd L
.49389 .13448 1.875 0 Mabsadd L
.49389 .13448 0 -2.5 Mabsadd L
.49389 .13448 -1.875 0 Mabsadd L closepath F
.49695 .13614 -1.875 0 Mabsadd m
.49695 .13614 0 2.5 Mabsadd L
.49695 .13614 1.875 0 Mabsadd L
.49695 .13614 0 -2.5 Mabsadd L
.49695 .13614 -1.875 0 Mabsadd L closepath F
.5 .13782 -1.875 0 Mabsadd m
.5 .13782 0 2.5 Mabsadd L
.5 .13782 1.875 0 Mabsadd L
.5 .13782 0 -2.5 Mabsadd L
.5 .13782 -1.875 0 Mabsadd L closepath F
.50305 .13951 -1.875 0 Mabsadd m
.50305 .13951 0 2.5 Mabsadd L
.50305 .13951 1.875 0 Mabsadd L
.50305 .13951 0 -2.5 Mabsadd L
.50305 .13951 -1.875 0 Mabsadd L closepath F
.50611 .14124 -1.875 0 Mabsadd m
.50611 .14124 0 2.5 Mabsadd L
.50611 .14124 1.875 0 Mabsadd L
.50611 .14124 0 -2.5 Mabsadd L
.50611 .14124 -1.875 0 Mabsadd L closepath F
.50916 .14298 -1.875 0 Mabsadd m
.50916 .14298 0 2.5 Mabsadd L
.50916 .14298 1.875 0 Mabsadd L
.50916 .14298 0 -2.5 Mabsadd L
.50916 .14298 -1.875 0 Mabsadd L closepath F
.51221 .14474 -1.875 0 Mabsadd m
.51221 .14474 0 2.5 Mabsadd L
.51221 .14474 1.875 0 Mabsadd L
.51221 .14474 0 -2.5 Mabsadd L
.51221 .14474 -1.875 0 Mabsadd L closepath F
.51526 .14653 -1.875 0 Mabsadd m
.51526 .14653 0 2.5 Mabsadd L
.51526 .14653 1.875 0 Mabsadd L
.51526 .14653 0 -2.5 Mabsadd L
.51526 .14653 -1.875 0 Mabsadd L closepath F
.51832 .14834 -1.875 0 Mabsadd m
.51832 .14834 0 2.5 Mabsadd L
.51832 .14834 1.875 0 Mabsadd L
.51832 .14834 0 -2.5 Mabsadd L
.51832 .14834 -1.875 0 Mabsadd L closepath F
.52137 .15017 -1.875 0 Mabsadd m
.52137 .15017 0 2.5 Mabsadd L
.52137 .15017 1.875 0 Mabsadd L
.52137 .15017 0 -2.5 Mabsadd L
.52137 .15017 -1.875 0 Mabsadd L closepath F
.52442 .15203 -1.875 0 Mabsadd m
.52442 .15203 0 2.5 Mabsadd L
.52442 .15203 1.875 0 Mabsadd L
.52442 .15203 0 -2.5 Mabsadd L
.52442 .15203 -1.875 0 Mabsadd L closepath F
.52747 .15391 -1.875 0 Mabsadd m
.52747 .15391 0 2.5 Mabsadd L
.52747 .15391 1.875 0 Mabsadd L
.52747 .15391 0 -2.5 Mabsadd L
.52747 .15391 -1.875 0 Mabsadd L closepath F
.53053 .15582 -1.875 0 Mabsadd m
.53053 .15582 0 2.5 Mabsadd L
.53053 .15582 1.875 0 Mabsadd L
.53053 .15582 0 -2.5 Mabsadd L
.53053 .15582 -1.875 0 Mabsadd L closepath F
.53358 .15775 -1.875 0 Mabsadd m
.53358 .15775 0 2.5 Mabsadd L
.53358 .15775 1.875 0 Mabsadd L
.53358 .15775 0 -2.5 Mabsadd L
.53358 .15775 -1.875 0 Mabsadd L closepath F
.53663 .1597 -1.875 0 Mabsadd m
.53663 .1597 0 2.5 Mabsadd L
.53663 .1597 1.875 0 Mabsadd L
.53663 .1597 0 -2.5 Mabsadd L
.53663 .1597 -1.875 0 Mabsadd L closepath F
.53968 .16168 -1.875 0 Mabsadd m
.53968 .16168 0 2.5 Mabsadd L
.53968 .16168 1.875 0 Mabsadd L
.53968 .16168 0 -2.5 Mabsadd L
.53968 .16168 -1.875 0 Mabsadd L closepath F
.54274 .16369 -1.875 0 Mabsadd m
.54274 .16369 0 2.5 Mabsadd L
.54274 .16369 1.875 0 Mabsadd L
.54274 .16369 0 -2.5 Mabsadd L
.54274 .16369 -1.875 0 Mabsadd L closepath F
.54579 .16572 -1.875 0 Mabsadd m
.54579 .16572 0 2.5 Mabsadd L
.54579 .16572 1.875 0 Mabsadd L
.54579 .16572 0 -2.5 Mabsadd L
.54579 .16572 -1.875 0 Mabsadd L closepath F
.54884 .16778 -1.875 0 Mabsadd m
.54884 .16778 0 2.5 Mabsadd L
.54884 .16778 1.875 0 Mabsadd L
.54884 .16778 0 -2.5 Mabsadd L
.54884 .16778 -1.875 0 Mabsadd L closepath F
.55189 .16986 -1.875 0 Mabsadd m
.55189 .16986 0 2.5 Mabsadd L
.55189 .16986 1.875 0 Mabsadd L
.55189 .16986 0 -2.5 Mabsadd L
.55189 .16986 -1.875 0 Mabsadd L closepath F
.55495 .17197 -1.875 0 Mabsadd m
.55495 .17197 0 2.5 Mabsadd L
.55495 .17197 1.875 0 Mabsadd L
.55495 .17197 0 -2.5 Mabsadd L
.55495 .17197 -1.875 0 Mabsadd L closepath F
.558 .17411 -1.875 0 Mabsadd m
.558 .17411 0 2.5 Mabsadd L
.558 .17411 1.875 0 Mabsadd L
.558 .17411 0 -2.5 Mabsadd L
.558 .17411 -1.875 0 Mabsadd L closepath F
.56105 .17628 -1.875 0 Mabsadd m
.56105 .17628 0 2.5 Mabsadd L
.56105 .17628 1.875 0 Mabsadd L
.56105 .17628 0 -2.5 Mabsadd L
.56105 .17628 -1.875 0 Mabsadd L closepath F
.5641 .17847 -1.875 0 Mabsadd m
.5641 .17847 0 2.5 Mabsadd L
.5641 .17847 1.875 0 Mabsadd L
.5641 .17847 0 -2.5 Mabsadd L
.5641 .17847 -1.875 0 Mabsadd L closepath F
.56716 .18069 -1.875 0 Mabsadd m
.56716 .18069 0 2.5 Mabsadd L
.56716 .18069 1.875 0 Mabsadd L
.56716 .18069 0 -2.5 Mabsadd L
.56716 .18069 -1.875 0 Mabsadd L closepath F
.57021 .18294 -1.875 0 Mabsadd m
.57021 .18294 0 2.5 Mabsadd L
.57021 .18294 1.875 0 Mabsadd L
.57021 .18294 0 -2.5 Mabsadd L
.57021 .18294 -1.875 0 Mabsadd L closepath F
.57326 .18522 -1.875 0 Mabsadd m
.57326 .18522 0 2.5 Mabsadd L
.57326 .18522 1.875 0 Mabsadd L
.57326 .18522 0 -2.5 Mabsadd L
.57326 .18522 -1.875 0 Mabsadd L closepath F
.57631 .18753 -1.875 0 Mabsadd m
.57631 .18753 0 2.5 Mabsadd L
.57631 .18753 1.875 0 Mabsadd L
.57631 .18753 0 -2.5 Mabsadd L
.57631 .18753 -1.875 0 Mabsadd L closepath F
.57937 .18987 -1.875 0 Mabsadd m
.57937 .18987 0 2.5 Mabsadd L
.57937 .18987 1.875 0 Mabsadd L
.57937 .18987 0 -2.5 Mabsadd L
.57937 .18987 -1.875 0 Mabsadd L closepath F
.58242 .19224 -1.875 0 Mabsadd m
.58242 .19224 0 2.5 Mabsadd L
.58242 .19224 1.875 0 Mabsadd L
.58242 .19224 0 -2.5 Mabsadd L
.58242 .19224 -1.875 0 Mabsadd L closepath F
.58547 .19464 -1.875 0 Mabsadd m
.58547 .19464 0 2.5 Mabsadd L
.58547 .19464 1.875 0 Mabsadd L
.58547 .19464 0 -2.5 Mabsadd L
.58547 .19464 -1.875 0 Mabsadd L closepath F
.58852 .19707 -1.875 0 Mabsadd m
.58852 .19707 0 2.5 Mabsadd L
.58852 .19707 1.875 0 Mabsadd L
.58852 .19707 0 -2.5 Mabsadd L
.58852 .19707 -1.875 0 Mabsadd L closepath F
.59158 .19953 -1.875 0 Mabsadd m
.59158 .19953 0 2.5 Mabsadd L
.59158 .19953 1.875 0 Mabsadd L
.59158 .19953 0 -2.5 Mabsadd L
.59158 .19953 -1.875 0 Mabsadd L closepath F
.59463 .20202 -1.875 0 Mabsadd m
.59463 .20202 0 2.5 Mabsadd L
.59463 .20202 1.875 0 Mabsadd L
.59463 .20202 0 -2.5 Mabsadd L
.59463 .20202 -1.875 0 Mabsadd L closepath F
.59768 .20455 -1.875 0 Mabsadd m
.59768 .20455 0 2.5 Mabsadd L
.59768 .20455 1.875 0 Mabsadd L
.59768 .20455 0 -2.5 Mabsadd L
.59768 .20455 -1.875 0 Mabsadd L closepath F
.60073 .2071 -1.875 0 Mabsadd m
.60073 .2071 0 2.5 Mabsadd L
.60073 .2071 1.875 0 Mabsadd L
.60073 .2071 0 -2.5 Mabsadd L
.60073 .2071 -1.875 0 Mabsadd L closepath F
.60379 .20969 -1.875 0 Mabsadd m
.60379 .20969 0 2.5 Mabsadd L
.60379 .20969 1.875 0 Mabsadd L
.60379 .20969 0 -2.5 Mabsadd L
.60379 .20969 -1.875 0 Mabsadd L closepath F
.60684 .21232 -1.875 0 Mabsadd m
.60684 .21232 0 2.5 Mabsadd L
.60684 .21232 1.875 0 Mabsadd L
.60684 .21232 0 -2.5 Mabsadd L
.60684 .21232 -1.875 0 Mabsadd L closepath F
.60989 .21498 -1.875 0 Mabsadd m
.60989 .21498 0 2.5 Mabsadd L
.60989 .21498 1.875 0 Mabsadd L
.60989 .21498 0 -2.5 Mabsadd L
.60989 .21498 -1.875 0 Mabsadd L closepath F
.61294 .21767 -1.875 0 Mabsadd m
.61294 .21767 0 2.5 Mabsadd L
.61294 .21767 1.875 0 Mabsadd L
.61294 .21767 0 -2.5 Mabsadd L
.61294 .21767 -1.875 0 Mabsadd L closepath F
.616 .22039 -1.875 0 Mabsadd m
.616 .22039 0 2.5 Mabsadd L
.616 .22039 1.875 0 Mabsadd L
.616 .22039 0 -2.5 Mabsadd L
.616 .22039 -1.875 0 Mabsadd L closepath F
.61905 .22315 -1.875 0 Mabsadd m
.61905 .22315 0 2.5 Mabsadd L
.61905 .22315 1.875 0 Mabsadd L
.61905 .22315 0 -2.5 Mabsadd L
.61905 .22315 -1.875 0 Mabsadd L closepath F
.6221 .22595 -1.875 0 Mabsadd m
.6221 .22595 0 2.5 Mabsadd L
.6221 .22595 1.875 0 Mabsadd L
.6221 .22595 0 -2.5 Mabsadd L
.6221 .22595 -1.875 0 Mabsadd L closepath F
.62515 .22878 -1.875 0 Mabsadd m
.62515 .22878 0 2.5 Mabsadd L
.62515 .22878 1.875 0 Mabsadd L
.62515 .22878 0 -2.5 Mabsadd L
.62515 .22878 -1.875 0 Mabsadd L closepath F
.62821 .23165 -1.875 0 Mabsadd m
.62821 .23165 0 2.5 Mabsadd L
.62821 .23165 1.875 0 Mabsadd L
.62821 .23165 0 -2.5 Mabsadd L
.62821 .23165 -1.875 0 Mabsadd L closepath F
.63126 .23456 -1.875 0 Mabsadd m
.63126 .23456 0 2.5 Mabsadd L
.63126 .23456 1.875 0 Mabsadd L
.63126 .23456 0 -2.5 Mabsadd L
.63126 .23456 -1.875 0 Mabsadd L closepath F
.63431 .2375 -1.875 0 Mabsadd m
.63431 .2375 0 2.5 Mabsadd L
.63431 .2375 1.875 0 Mabsadd L
.63431 .2375 0 -2.5 Mabsadd L
.63431 .2375 -1.875 0 Mabsadd L closepath F
.63736 .24049 -1.875 0 Mabsadd m
.63736 .24049 0 2.5 Mabsadd L
.63736 .24049 1.875 0 Mabsadd L
.63736 .24049 0 -2.5 Mabsadd L
.63736 .24049 -1.875 0 Mabsadd L closepath F
.64042 .24351 -1.875 0 Mabsadd m
.64042 .24351 0 2.5 Mabsadd L
.64042 .24351 1.875 0 Mabsadd L
.64042 .24351 0 -2.5 Mabsadd L
.64042 .24351 -1.875 0 Mabsadd L closepath F
.64347 .24656 -1.875 0 Mabsadd m
.64347 .24656 0 2.5 Mabsadd L
.64347 .24656 1.875 0 Mabsadd L
.64347 .24656 0 -2.5 Mabsadd L
.64347 .24656 -1.875 0 Mabsadd L closepath F
.64652 .24966 -1.875 0 Mabsadd m
.64652 .24966 0 2.5 Mabsadd L
.64652 .24966 1.875 0 Mabsadd L
.64652 .24966 0 -2.5 Mabsadd L
.64652 .24966 -1.875 0 Mabsadd L closepath F
.64957 .2528 -1.875 0 Mabsadd m
.64957 .2528 0 2.5 Mabsadd L
.64957 .2528 1.875 0 Mabsadd L
.64957 .2528 0 -2.5 Mabsadd L
.64957 .2528 -1.875 0 Mabsadd L closepath F
.65263 .25598 -1.875 0 Mabsadd m
.65263 .25598 0 2.5 Mabsadd L
.65263 .25598 1.875 0 Mabsadd L
.65263 .25598 0 -2.5 Mabsadd L
.65263 .25598 -1.875 0 Mabsadd L closepath F
.65568 .2592 -1.875 0 Mabsadd m
.65568 .2592 0 2.5 Mabsadd L
.65568 .2592 1.875 0 Mabsadd L
.65568 .2592 0 -2.5 Mabsadd L
.65568 .2592 -1.875 0 Mabsadd L closepath F
.65873 .26246 -1.875 0 Mabsadd m
.65873 .26246 0 2.5 Mabsadd L
.65873 .26246 1.875 0 Mabsadd L
.65873 .26246 0 -2.5 Mabsadd L
.65873 .26246 -1.875 0 Mabsadd L closepath F
.66178 .26576 -1.875 0 Mabsadd m
.66178 .26576 0 2.5 Mabsadd L
.66178 .26576 1.875 0 Mabsadd L
.66178 .26576 0 -2.5 Mabsadd L
.66178 .26576 -1.875 0 Mabsadd L closepath F
.66484 .26911 -1.875 0 Mabsadd m
.66484 .26911 0 2.5 Mabsadd L
.66484 .26911 1.875 0 Mabsadd L
.66484 .26911 0 -2.5 Mabsadd L
.66484 .26911 -1.875 0 Mabsadd L closepath F
.66789 .2725 -1.875 0 Mabsadd m
.66789 .2725 0 2.5 Mabsadd L
.66789 .2725 1.875 0 Mabsadd L
.66789 .2725 0 -2.5 Mabsadd L
.66789 .2725 -1.875 0 Mabsadd L closepath F
.67094 .27593 -1.875 0 Mabsadd m
.67094 .27593 0 2.5 Mabsadd L
.67094 .27593 1.875 0 Mabsadd L
.67094 .27593 0 -2.5 Mabsadd L
.67094 .27593 -1.875 0 Mabsadd L closepath F
.67399 .2794 -1.875 0 Mabsadd m
.67399 .2794 0 2.5 Mabsadd L
.67399 .2794 1.875 0 Mabsadd L
.67399 .2794 0 -2.5 Mabsadd L
.67399 .2794 -1.875 0 Mabsadd L closepath F
.67705 .28293 -1.875 0 Mabsadd m
.67705 .28293 0 2.5 Mabsadd L
.67705 .28293 1.875 0 Mabsadd L
.67705 .28293 0 -2.5 Mabsadd L
.67705 .28293 -1.875 0 Mabsadd L closepath F
.6801 .28649 -1.875 0 Mabsadd m
.6801 .28649 0 2.5 Mabsadd L
.6801 .28649 1.875 0 Mabsadd L
.6801 .28649 0 -2.5 Mabsadd L
.6801 .28649 -1.875 0 Mabsadd L closepath F
.68315 .2901 -1.875 0 Mabsadd m
.68315 .2901 0 2.5 Mabsadd L
.68315 .2901 1.875 0 Mabsadd L
.68315 .2901 0 -2.5 Mabsadd L
.68315 .2901 -1.875 0 Mabsadd L closepath F
.6862 .29376 -1.875 0 Mabsadd m
.6862 .29376 0 2.5 Mabsadd L
.6862 .29376 1.875 0 Mabsadd L
.6862 .29376 0 -2.5 Mabsadd L
.6862 .29376 -1.875 0 Mabsadd L closepath F
.68926 .29747 -1.875 0 Mabsadd m
.68926 .29747 0 2.5 Mabsadd L
.68926 .29747 1.875 0 Mabsadd L
.68926 .29747 0 -2.5 Mabsadd L
.68926 .29747 -1.875 0 Mabsadd L closepath F
.69231 .30122 -1.875 0 Mabsadd m
.69231 .30122 0 2.5 Mabsadd L
.69231 .30122 1.875 0 Mabsadd L
.69231 .30122 0 -2.5 Mabsadd L
.69231 .30122 -1.875 0 Mabsadd L closepath F
.69536 .30502 -1.875 0 Mabsadd m
.69536 .30502 0 2.5 Mabsadd L
.69536 .30502 1.875 0 Mabsadd L
.69536 .30502 0 -2.5 Mabsadd L
.69536 .30502 -1.875 0 Mabsadd L closepath F
.69841 .30887 -1.875 0 Mabsadd m
.69841 .30887 0 2.5 Mabsadd L
.69841 .30887 1.875 0 Mabsadd L
.69841 .30887 0 -2.5 Mabsadd L
.69841 .30887 -1.875 0 Mabsadd L closepath F
.70147 .31278 -1.875 0 Mabsadd m
.70147 .31278 0 2.5 Mabsadd L
.70147 .31278 1.875 0 Mabsadd L
.70147 .31278 0 -2.5 Mabsadd L
.70147 .31278 -1.875 0 Mabsadd L closepath F
.70452 .31673 -1.875 0 Mabsadd m
.70452 .31673 0 2.5 Mabsadd L
.70452 .31673 1.875 0 Mabsadd L
.70452 .31673 0 -2.5 Mabsadd L
.70452 .31673 -1.875 0 Mabsadd L closepath F
.70757 .32073 -1.875 0 Mabsadd m
.70757 .32073 0 2.5 Mabsadd L
.70757 .32073 1.875 0 Mabsadd L
.70757 .32073 0 -2.5 Mabsadd L
.70757 .32073 -1.875 0 Mabsadd L closepath F
.71062 .32478 -1.875 0 Mabsadd m
.71062 .32478 0 2.5 Mabsadd L
.71062 .32478 1.875 0 Mabsadd L
.71062 .32478 0 -2.5 Mabsadd L
.71062 .32478 -1.875 0 Mabsadd L closepath F
.71368 .32888 -1.875 0 Mabsadd m
.71368 .32888 0 2.5 Mabsadd L
.71368 .32888 1.875 0 Mabsadd L
.71368 .32888 0 -2.5 Mabsadd L
.71368 .32888 -1.875 0 Mabsadd L closepath F
.71673 .33304 -1.875 0 Mabsadd m
.71673 .33304 0 2.5 Mabsadd L
.71673 .33304 1.875 0 Mabsadd L
.71673 .33304 0 -2.5 Mabsadd L
.71673 .33304 -1.875 0 Mabsadd L closepath F
.71978 .33725 -1.875 0 Mabsadd m
.71978 .33725 0 2.5 Mabsadd L
.71978 .33725 1.875 0 Mabsadd L
.71978 .33725 0 -2.5 Mabsadd L
.71978 .33725 -1.875 0 Mabsadd L closepath F
.72283 .34152 -1.875 0 Mabsadd m
.72283 .34152 0 2.5 Mabsadd L
.72283 .34152 1.875 0 Mabsadd L
.72283 .34152 0 -2.5 Mabsadd L
.72283 .34152 -1.875 0 Mabsadd L closepath F
.72589 .34584 -1.875 0 Mabsadd m
.72589 .34584 0 2.5 Mabsadd L
.72589 .34584 1.875 0 Mabsadd L
.72589 .34584 0 -2.5 Mabsadd L
.72589 .34584 -1.875 0 Mabsadd L closepath F
.72894 .35022 -1.875 0 Mabsadd m
.72894 .35022 0 2.5 Mabsadd L
.72894 .35022 1.875 0 Mabsadd L
.72894 .35022 0 -2.5 Mabsadd L
.72894 .35022 -1.875 0 Mabsadd L closepath F
.73199 .35465 -1.875 0 Mabsadd m
.73199 .35465 0 2.5 Mabsadd L
.73199 .35465 1.875 0 Mabsadd L
.73199 .35465 0 -2.5 Mabsadd L
.73199 .35465 -1.875 0 Mabsadd L closepath F
.73504 .35914 -1.875 0 Mabsadd m
.73504 .35914 0 2.5 Mabsadd L
.73504 .35914 1.875 0 Mabsadd L
.73504 .35914 0 -2.5 Mabsadd L
.73504 .35914 -1.875 0 Mabsadd L closepath F
.7381 .36369 -1.875 0 Mabsadd m
.7381 .36369 0 2.5 Mabsadd L
.7381 .36369 1.875 0 Mabsadd L
.7381 .36369 0 -2.5 Mabsadd L
.7381 .36369 -1.875 0 Mabsadd L closepath F
.74115 .36829 -1.875 0 Mabsadd m
.74115 .36829 0 2.5 Mabsadd L
.74115 .36829 1.875 0 Mabsadd L
.74115 .36829 0 -2.5 Mabsadd L
.74115 .36829 -1.875 0 Mabsadd L closepath F
.7442 .37296 -1.875 0 Mabsadd m
.7442 .37296 0 2.5 Mabsadd L
.7442 .37296 1.875 0 Mabsadd L
.7442 .37296 0 -2.5 Mabsadd L
.7442 .37296 -1.875 0 Mabsadd L closepath F
.74725 .37768 -1.875 0 Mabsadd m
.74725 .37768 0 2.5 Mabsadd L
.74725 .37768 1.875 0 Mabsadd L
.74725 .37768 0 -2.5 Mabsadd L
.74725 .37768 -1.875 0 Mabsadd L closepath F
.75031 .38247 -1.875 0 Mabsadd m
.75031 .38247 0 2.5 Mabsadd L
.75031 .38247 1.875 0 Mabsadd L
.75031 .38247 0 -2.5 Mabsadd L
.75031 .38247 -1.875 0 Mabsadd L closepath F
.75336 .38732 -1.875 0 Mabsadd m
.75336 .38732 0 2.5 Mabsadd L
.75336 .38732 1.875 0 Mabsadd L
.75336 .38732 0 -2.5 Mabsadd L
.75336 .38732 -1.875 0 Mabsadd L closepath F
.75641 .39223 -1.875 0 Mabsadd m
.75641 .39223 0 2.5 Mabsadd L
.75641 .39223 1.875 0 Mabsadd L
.75641 .39223 0 -2.5 Mabsadd L
.75641 .39223 -1.875 0 Mabsadd L closepath F
.75946 .3972 -1.875 0 Mabsadd m
.75946 .3972 0 2.5 Mabsadd L
.75946 .3972 1.875 0 Mabsadd L
.75946 .3972 0 -2.5 Mabsadd L
.75946 .3972 -1.875 0 Mabsadd L closepath F
.76252 .40224 -1.875 0 Mabsadd m
.76252 .40224 0 2.5 Mabsadd L
.76252 .40224 1.875 0 Mabsadd L
.76252 .40224 0 -2.5 Mabsadd L
.76252 .40224 -1.875 0 Mabsadd L closepath F
.76557 .40734 -1.875 0 Mabsadd m
.76557 .40734 0 2.5 Mabsadd L
.76557 .40734 1.875 0 Mabsadd L
.76557 .40734 0 -2.5 Mabsadd L
.76557 .40734 -1.875 0 Mabsadd L closepath F
.76862 .41251 -1.875 0 Mabsadd m
.76862 .41251 0 2.5 Mabsadd L
.76862 .41251 1.875 0 Mabsadd L
.76862 .41251 0 -2.5 Mabsadd L
.76862 .41251 -1.875 0 Mabsadd L closepath F
.77167 .41774 -1.875 0 Mabsadd m
.77167 .41774 0 2.5 Mabsadd L
.77167 .41774 1.875 0 Mabsadd L
.77167 .41774 0 -2.5 Mabsadd L
.77167 .41774 -1.875 0 Mabsadd L closepath F
.77473 .42304 -1.875 0 Mabsadd m
.77473 .42304 0 2.5 Mabsadd L
.77473 .42304 1.875 0 Mabsadd L
.77473 .42304 0 -2.5 Mabsadd L
.77473 .42304 -1.875 0 Mabsadd L closepath F
.77778 .42841 -1.875 0 Mabsadd m
.77778 .42841 0 2.5 Mabsadd L
.77778 .42841 1.875 0 Mabsadd L
.77778 .42841 0 -2.5 Mabsadd L
.77778 .42841 -1.875 0 Mabsadd L closepath F
.78083 .43385 -1.875 0 Mabsadd m
.78083 .43385 0 2.5 Mabsadd L
.78083 .43385 1.875 0 Mabsadd L
.78083 .43385 0 -2.5 Mabsadd L
.78083 .43385 -1.875 0 Mabsadd L closepath F
.78388 .43936 -1.875 0 Mabsadd m
.78388 .43936 0 2.5 Mabsadd L
.78388 .43936 1.875 0 Mabsadd L
.78388 .43936 0 -2.5 Mabsadd L
.78388 .43936 -1.875 0 Mabsadd L closepath F
.78694 .44494 -1.875 0 Mabsadd m
.78694 .44494 0 2.5 Mabsadd L
.78694 .44494 1.875 0 Mabsadd L
.78694 .44494 0 -2.5 Mabsadd L
.78694 .44494 -1.875 0 Mabsadd L closepath F
.78999 .45059 -1.875 0 Mabsadd m
.78999 .45059 0 2.5 Mabsadd L
.78999 .45059 1.875 0 Mabsadd L
.78999 .45059 0 -2.5 Mabsadd L
.78999 .45059 -1.875 0 Mabsadd L closepath F
.79304 .45631 -1.875 0 Mabsadd m
.79304 .45631 0 2.5 Mabsadd L
.79304 .45631 1.875 0 Mabsadd L
.79304 .45631 0 -2.5 Mabsadd L
.79304 .45631 -1.875 0 Mabsadd L closepath F
.79609 .46211 -1.875 0 Mabsadd m
.79609 .46211 0 2.5 Mabsadd L
.79609 .46211 1.875 0 Mabsadd L
.79609 .46211 0 -2.5 Mabsadd L
.79609 .46211 -1.875 0 Mabsadd L closepath F
.79915 .46799 -1.875 0 Mabsadd m
.79915 .46799 0 2.5 Mabsadd L
.79915 .46799 1.875 0 Mabsadd L
.79915 .46799 0 -2.5 Mabsadd L
.79915 .46799 -1.875 0 Mabsadd L closepath F
.8022 .47393 -1.875 0 Mabsadd m
.8022 .47393 0 2.5 Mabsadd L
.8022 .47393 1.875 0 Mabsadd L
.8022 .47393 0 -2.5 Mabsadd L
.8022 .47393 -1.875 0 Mabsadd L closepath F
.80525 .47996 -1.875 0 Mabsadd m
.80525 .47996 0 2.5 Mabsadd L
.80525 .47996 1.875 0 Mabsadd L
.80525 .47996 0 -2.5 Mabsadd L
.80525 .47996 -1.875 0 Mabsadd L closepath F
.8083 .48606 -1.875 0 Mabsadd m
.8083 .48606 0 2.5 Mabsadd L
.8083 .48606 1.875 0 Mabsadd L
.8083 .48606 0 -2.5 Mabsadd L
.8083 .48606 -1.875 0 Mabsadd L closepath F
.81136 .49224 -1.875 0 Mabsadd m
.81136 .49224 0 2.5 Mabsadd L
.81136 .49224 1.875 0 Mabsadd L
.81136 .49224 0 -2.5 Mabsadd L
.81136 .49224 -1.875 0 Mabsadd L closepath F
.81441 .4985 -1.875 0 Mabsadd m
.81441 .4985 0 2.5 Mabsadd L
.81441 .4985 1.875 0 Mabsadd L
.81441 .4985 0 -2.5 Mabsadd L
.81441 .4985 -1.875 0 Mabsadd L closepath F
.81746 .50484 -1.875 0 Mabsadd m
.81746 .50484 0 2.5 Mabsadd L
.81746 .50484 1.875 0 Mabsadd L
.81746 .50484 0 -2.5 Mabsadd L
.81746 .50484 -1.875 0 Mabsadd L closepath F
.82051 .51127 -1.875 0 Mabsadd m
.82051 .51127 0 2.5 Mabsadd L
.82051 .51127 1.875 0 Mabsadd L
.82051 .51127 0 -2.5 Mabsadd L
.82051 .51127 -1.875 0 Mabsadd L closepath F
.82357 .51777 -1.875 0 Mabsadd m
.82357 .51777 0 2.5 Mabsadd L
.82357 .51777 1.875 0 Mabsadd L
.82357 .51777 0 -2.5 Mabsadd L
.82357 .51777 -1.875 0 Mabsadd L closepath F
.82662 .52436 -1.875 0 Mabsadd m
.82662 .52436 0 2.5 Mabsadd L
.82662 .52436 1.875 0 Mabsadd L
.82662 .52436 0 -2.5 Mabsadd L
.82662 .52436 -1.875 0 Mabsadd L closepath F
.82967 .53104 -1.875 0 Mabsadd m
.82967 .53104 0 2.5 Mabsadd L
.82967 .53104 1.875 0 Mabsadd L
.82967 .53104 0 -2.5 Mabsadd L
.82967 .53104 -1.875 0 Mabsadd L closepath F
.83272 .5378 -1.875 0 Mabsadd m
.83272 .5378 0 2.5 Mabsadd L
.83272 .5378 1.875 0 Mabsadd L
.83272 .5378 0 -2.5 Mabsadd L
.83272 .5378 -1.875 0 Mabsadd L closepath F
.83578 .54464 -1.875 0 Mabsadd m
.83578 .54464 0 2.5 Mabsadd L
.83578 .54464 1.875 0 Mabsadd L
.83578 .54464 0 -2.5 Mabsadd L
.83578 .54464 -1.875 0 Mabsadd L closepath F
.83883 .55158 -1.875 0 Mabsadd m
.83883 .55158 0 2.5 Mabsadd L
.83883 .55158 1.875 0 Mabsadd L
.83883 .55158 0 -2.5 Mabsadd L
.83883 .55158 -1.875 0 Mabsadd L closepath F
.84188 .5586 -1.875 0 Mabsadd m
.84188 .5586 0 2.5 Mabsadd L
.84188 .5586 1.875 0 Mabsadd L
.84188 .5586 0 -2.5 Mabsadd L
.84188 .5586 -1.875 0 Mabsadd L closepath F
.84493 .56572 -1.875 0 Mabsadd m
.84493 .56572 0 2.5 Mabsadd L
.84493 .56572 1.875 0 Mabsadd L
.84493 .56572 0 -2.5 Mabsadd L
.84493 .56572 -1.875 0 Mabsadd L closepath F
.84799 .57292 -1.875 0 Mabsadd m
.84799 .57292 0 2.5 Mabsadd L
.84799 .57292 1.875 0 Mabsadd L
.84799 .57292 0 -2.5 Mabsadd L
.84799 .57292 -1.875 0 Mabsadd L closepath F
.85104 .58022 -1.875 0 Mabsadd m
.85104 .58022 0 2.5 Mabsadd L
.85104 .58022 1.875 0 Mabsadd L
.85104 .58022 0 -2.5 Mabsadd L
.85104 .58022 -1.875 0 Mabsadd L closepath F
.85409 .58762 -1.875 0 Mabsadd m
.85409 .58762 0 2.5 Mabsadd L
.85409 .58762 1.875 0 Mabsadd L
.85409 .58762 0 -2.5 Mabsadd L
.85409 .58762 -1.875 0 Mabsadd L closepath F
.85714 .5951 -1.875 0 Mabsadd m
.85714 .5951 0 2.5 Mabsadd L
.85714 .5951 1.875 0 Mabsadd L
.85714 .5951 0 -2.5 Mabsadd L
.85714 .5951 -1.875 0 Mabsadd L closepath F
.8602 .60269 -1.875 0 Mabsadd m
.8602 .60269 0 2.5 Mabsadd L
.8602 .60269 1.875 0 Mabsadd L
.8602 .60269 0 -2.5 Mabsadd L
.8602 .60269 -1.875 0 Mabsadd L closepath F
.86325 .61037 -1.875 0 Mabsadd m
.86325 .61037 0 2.5 Mabsadd L
.86325 .61037 1.875 0 Mabsadd L
.86325 .61037 0 -2.5 Mabsadd L
.86325 .61037 -1.875 0 Mabsadd L closepath F
.8663 .61815 -1.875 0 Mabsadd m
.8663 .61815 0 2.5 Mabsadd L
.8663 .61815 1.875 0 Mabsadd L
.8663 .61815 0 -2.5 Mabsadd L
.8663 .61815 -1.875 0 Mabsadd L closepath F
.86935 .62603 -1.875 0 Mabsadd m
.86935 .62603 0 2.5 Mabsadd L
.86935 .62603 1.875 0 Mabsadd L
.86935 .62603 0 -2.5 Mabsadd L
.86935 .62603 -1.875 0 Mabsadd L closepath F
.87241 .63402 -1.875 0 Mabsadd m
.87241 .63402 0 2.5 Mabsadd L
.87241 .63402 1.875 0 Mabsadd L
.87241 .63402 0 -2.5 Mabsadd L
.87241 .63402 -1.875 0 Mabsadd L closepath F
.87546 .6421 -1.875 0 Mabsadd m
.87546 .6421 0 2.5 Mabsadd L
.87546 .6421 1.875 0 Mabsadd L
.87546 .6421 0 -2.5 Mabsadd L
.87546 .6421 -1.875 0 Mabsadd L closepath F
.87851 .65029 -1.875 0 Mabsadd m
.87851 .65029 0 2.5 Mabsadd L
.87851 .65029 1.875 0 Mabsadd L
.87851 .65029 0 -2.5 Mabsadd L
.87851 .65029 -1.875 0 Mabsadd L closepath F
.88156 .65859 -1.875 0 Mabsadd m
.88156 .65859 0 2.5 Mabsadd L
.88156 .65859 1.875 0 Mabsadd L
.88156 .65859 0 -2.5 Mabsadd L
.88156 .65859 -1.875 0 Mabsadd L closepath F
.88462 .66699 -1.875 0 Mabsadd m
.88462 .66699 0 2.5 Mabsadd L
.88462 .66699 1.875 0 Mabsadd L
.88462 .66699 0 -2.5 Mabsadd L
.88462 .66699 -1.875 0 Mabsadd L closepath F
.88767 .6755 -1.875 0 Mabsadd m
.88767 .6755 0 2.5 Mabsadd L
.88767 .6755 1.875 0 Mabsadd L
.88767 .6755 0 -2.5 Mabsadd L
.88767 .6755 -1.875 0 Mabsadd L closepath F
.89072 .68412 -1.875 0 Mabsadd m
.89072 .68412 0 2.5 Mabsadd L
.89072 .68412 1.875 0 Mabsadd L
.89072 .68412 0 -2.5 Mabsadd L
.89072 .68412 -1.875 0 Mabsadd L closepath F
.89377 .69285 -1.875 0 Mabsadd m
.89377 .69285 0 2.5 Mabsadd L
.89377 .69285 1.875 0 Mabsadd L
.89377 .69285 0 -2.5 Mabsadd L
.89377 .69285 -1.875 0 Mabsadd L closepath F
.89683 .70169 -1.875 0 Mabsadd m
.89683 .70169 0 2.5 Mabsadd L
.89683 .70169 1.875 0 Mabsadd L
.89683 .70169 0 -2.5 Mabsadd L
.89683 .70169 -1.875 0 Mabsadd L closepath F
.89988 .71065 -1.875 0 Mabsadd m
.89988 .71065 0 2.5 Mabsadd L
.89988 .71065 1.875 0 Mabsadd L
.89988 .71065 0 -2.5 Mabsadd L
.89988 .71065 -1.875 0 Mabsadd L closepath F
.90293 .71972 -1.875 0 Mabsadd m
.90293 .71972 0 2.5 Mabsadd L
.90293 .71972 1.875 0 Mabsadd L
.90293 .71972 0 -2.5 Mabsadd L
.90293 .71972 -1.875 0 Mabsadd L closepath F
.90598 .72891 -1.875 0 Mabsadd m
.90598 .72891 0 2.5 Mabsadd L
.90598 .72891 1.875 0 Mabsadd L
.90598 .72891 0 -2.5 Mabsadd L
.90598 .72891 -1.875 0 Mabsadd L closepath F
.90904 .73821 -1.875 0 Mabsadd m
.90904 .73821 0 2.5 Mabsadd L
.90904 .73821 1.875 0 Mabsadd L
.90904 .73821 0 -2.5 Mabsadd L
.90904 .73821 -1.875 0 Mabsadd L closepath F
.91209 .74764 -1.875 0 Mabsadd m
.91209 .74764 0 2.5 Mabsadd L
.91209 .74764 1.875 0 Mabsadd L
.91209 .74764 0 -2.5 Mabsadd L
.91209 .74764 -1.875 0 Mabsadd L closepath F
.91514 .75719 -1.875 0 Mabsadd m
.91514 .75719 0 2.5 Mabsadd L
.91514 .75719 1.875 0 Mabsadd L
.91514 .75719 0 -2.5 Mabsadd L
.91514 .75719 -1.875 0 Mabsadd L closepath F
.91819 .76686 -1.875 0 Mabsadd m
.91819 .76686 0 2.5 Mabsadd L
.91819 .76686 1.875 0 Mabsadd L
.91819 .76686 0 -2.5 Mabsadd L
.91819 .76686 -1.875 0 Mabsadd L closepath F
.92125 .77666 -1.875 0 Mabsadd m
.92125 .77666 0 2.5 Mabsadd L
.92125 .77666 1.875 0 Mabsadd L
.92125 .77666 0 -2.5 Mabsadd L
.92125 .77666 -1.875 0 Mabsadd L closepath F
.9243 .78658 -1.875 0 Mabsadd m
.9243 .78658 0 2.5 Mabsadd L
.9243 .78658 1.875 0 Mabsadd L
.9243 .78658 0 -2.5 Mabsadd L
.9243 .78658 -1.875 0 Mabsadd L closepath F
.92735 .79663 -1.875 0 Mabsadd m
.92735 .79663 0 2.5 Mabsadd L
.92735 .79663 1.875 0 Mabsadd L
.92735 .79663 0 -2.5 Mabsadd L
.92735 .79663 -1.875 0 Mabsadd L closepath F
.9304 .8068 -1.875 0 Mabsadd m
.9304 .8068 0 2.5 Mabsadd L
.9304 .8068 1.875 0 Mabsadd L
.9304 .8068 0 -2.5 Mabsadd L
.9304 .8068 -1.875 0 Mabsadd L closepath F
.93346 .81711 -1.875 0 Mabsadd m
.93346 .81711 0 2.5 Mabsadd L
.93346 .81711 1.875 0 Mabsadd L
.93346 .81711 0 -2.5 Mabsadd L
.93346 .81711 -1.875 0 Mabsadd L closepath F
.93651 .82756 -1.875 0 Mabsadd m
.93651 .82756 0 2.5 Mabsadd L
.93651 .82756 1.875 0 Mabsadd L
.93651 .82756 0 -2.5 Mabsadd L
.93651 .82756 -1.875 0 Mabsadd L closepath F
.93956 .83813 -1.875 0 Mabsadd m
.93956 .83813 0 2.5 Mabsadd L
.93956 .83813 1.875 0 Mabsadd L
.93956 .83813 0 -2.5 Mabsadd L
.93956 .83813 -1.875 0 Mabsadd L closepath F
.94261 .84885 -1.875 0 Mabsadd m
.94261 .84885 0 2.5 Mabsadd L
.94261 .84885 1.875 0 Mabsadd L
.94261 .84885 0 -2.5 Mabsadd L
.94261 .84885 -1.875 0 Mabsadd L closepath F
.94567 .8597 -1.875 0 Mabsadd m
.94567 .8597 0 2.5 Mabsadd L
.94567 .8597 1.875 0 Mabsadd L
.94567 .8597 0 -2.5 Mabsadd L
.94567 .8597 -1.875 0 Mabsadd L closepath F
.94872 .87069 -1.875 0 Mabsadd m
.94872 .87069 0 2.5 Mabsadd L
.94872 .87069 1.875 0 Mabsadd L
.94872 .87069 0 -2.5 Mabsadd L
.94872 .87069 -1.875 0 Mabsadd L closepath F
.95177 .88182 -1.875 0 Mabsadd m
.95177 .88182 0 2.5 Mabsadd L
.95177 .88182 1.875 0 Mabsadd L
.95177 .88182 0 -2.5 Mabsadd L
.95177 .88182 -1.875 0 Mabsadd L closepath F
.95482 .89309 -1.875 0 Mabsadd m
.95482 .89309 0 2.5 Mabsadd L
.95482 .89309 1.875 0 Mabsadd L
.95482 .89309 0 -2.5 Mabsadd L
.95482 .89309 -1.875 0 Mabsadd L closepath F
.95788 .90451 -1.875 0 Mabsadd m
.95788 .90451 0 2.5 Mabsadd L
.95788 .90451 1.875 0 Mabsadd L
.95788 .90451 0 -2.5 Mabsadd L
.95788 .90451 -1.875 0 Mabsadd L closepath F
.96093 .91608 -1.875 0 Mabsadd m
.96093 .91608 0 2.5 Mabsadd L
.96093 .91608 1.875 0 Mabsadd L
.96093 .91608 0 -2.5 Mabsadd L
.96093 .91608 -1.875 0 Mabsadd L closepath F
.96398 .9278 -1.875 0 Mabsadd m
.96398 .9278 0 2.5 Mabsadd L
.96398 .9278 1.875 0 Mabsadd L
.96398 .9278 0 -2.5 Mabsadd L
.96398 .9278 -1.875 0 Mabsadd L closepath F
.96703 .93967 -1.875 0 Mabsadd m
.96703 .93967 0 2.5 Mabsadd L
.96703 .93967 1.875 0 Mabsadd L
.96703 .93967 0 -2.5 Mabsadd L
.96703 .93967 -1.875 0 Mabsadd L closepath F
.97009 .95168 -1.875 0 Mabsadd m
.97009 .95168 0 2.5 Mabsadd L
.97009 .95168 1.875 0 Mabsadd L
.97009 .95168 0 -2.5 Mabsadd L
.97009 .95168 -1.875 0 Mabsadd L closepath F
.97314 .96386 -1.875 0 Mabsadd m
.97314 .96386 0 2.5 Mabsadd L
.97314 .96386 1.875 0 Mabsadd L
.97314 .96386 0 -2.5 Mabsadd L
.97314 .96386 -1.875 0 Mabsadd L closepath F
.97619 .97619 -1.875 0 Mabsadd m
.97619 .97619 0 2.5 Mabsadd L
.97619 .97619 1.875 0 Mabsadd L
.97619 .97619 0 -2.5 Mabsadd L
.97619 .97619 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`005?oo0P00;_oo10000ooo0P00;?oo00<0
0?ooool00_oo0P00:ooo0P001?oo0P00:ooo0P001?oo0P00:?oo10000ooo0P001?oo0P000ooo000C
ool01000ooooo`00;Ooo00<00?ooool00ooo00@00?ooool002_oo`05003oooooool00002ool00`00
ooooo`0Wool01000ooooo`000_oo00@00?ooool002Woo`04003ooooo0002ool01000ooooo`00:Ooo
00D00?ooooooo`0000;oo`04003ooooo0002ool10001ool1ool001?oo`04003ooooo000^ool00`00
ooooo`02ool01000ooooo`00:?oo1@000_oo00@00?ooool002Woo`04003ooooo0002ool01000oooo
o`00:Ooo00@00?ooool000;oo`04003ooooo000Yool01@00oooooooo00000_oo00@00?ooool000;o
o`40007oo`7oo`004ooo00@00?ooool002ooo`05003oooooool00002ool00`00ooooo`0Vool01000
ooooo`000ooo00@00?ooool002Woo`<000?oo`04003ooooo000Zool20003ool01000ooooo`00:Ooo
00D00?ooooooo`0000;oo`04003ooooo0002ool10001ool1ool001?oo`04003ooooo000`ool01000
ooooo`000_oo00<00?ooool09ooo00<00?oo00000ooo00@00?ooool002Woo`03003ooooo00?oo`04
003ooooo000Yool01000ooooo`000_oo00@00?ooool002Woo`05003oooooool00002ool01000oooo
o`000_oo0@000Ooo0Ooo000Cool01000ooooo`00;Ooo00@00?ooool000;oo`04003ooooo000Zool2
0003ool01000ooooo`00:Ooo00<00?ooool00ooo00@00?ooool002Woo`04003ooooo0002ool01000
ooooo`009ooo0`000ooo00@00?ooool000;oo`04003ooooo0002ool001Coo`8002ooo`8000Coo`80
02coo`03003ooooo00;oo`8002_oo`<000?oo`8002_oo`8000Coo`8002[oo`03003ooooo00;oo`80
00Coo`8000?oo`00oooo8Ooo003ooolQool00?ooob7oo`003oooo`003P001?oo000?ool00`00oooo
o`03ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00oooo
o`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00oooo
o`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00oooo
o`09ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00ooooo`0:ool00`00oooo
o`0:ool00`00ooooo`02ool00`00ooooo`02ool000ooo`03003ooooo00?oo`03003ooooo037oo`03
003ooooo033oo`03003ooooo033oo`03003ooooo033oo`03003ooooo037oo`03003ooooo00;oo`03
003ooooo00;oo`003ooo00<00?ooool0oooo2_oo00<00?ooool00_oo0008ool20005ool00`00oooo
o`3oool:ool00`00ooooo`02ool000Ooo`04003ooooo0004ool00`00ooooo`02ool;1n3lool00`00
ooooo`02ool000Ooo`04003ooooo0004ool300000ooo1n07h00E1n3`ool20004ool000Ooo`04003o
oooo0004ool00`00ooooo`02oolO1n3Xool00`00ooooo`02ool000Ooo`04003ooooo0004ool00`00
ooooo`03oolU1n3Qool00`00ooooo`02ool000Ooo`04003ooooo0004ool00`00ooooo`0=oolS1n3I
ool00`00ooooo`02ool000Soo`8000Goo`03003ooooo01Sooah7h=?oo`03003ooooo00;oo`003ooo
00<00?ooool08Ooo6`OPcOoo00<00?ooool00_oo000?ool00`00ooooo`0XoolI1n38ool00`00oooo
o`02ool000ooo`03003ooooo033ooaH7h<?oo`03003ooooo00;oo`003ooo00<00?ooool0=_oo5@OP
__oo00<00?ooool00_oo000?ool00`00ooooo`0loolC1n2jool00`00ooooo`02ool000ooo`8004;o
oa87h;Goo`8000Coo`003ooo00<00?ooool0A_oo4@OP/_oo00<00?ooool00_oo000?ool00`00oooo
o`1;ool?1n2_ool00`00ooooo`02ool000ooo`03003ooooo04ooo`l7h:_oo`03003ooooo00;oo`00
3ooo00<00?ooool0Dooo3POPZ?oo00<00?ooool00_oo000?ool00`00ooooo`1Gool=1n2Uool00`00
ooooo`02ool000ooo`03003ooooo05[oo`d7h:;oo`03003ooooo00;oo`003ooo00<00?ooool0GOoo
3@OPWooo00<00?ooool00_oo000?ool00`00ooooo`1Qool;1n2Mool00`00ooooo`02ool000ooo`03
003ooooo06Coo`/7h9[oo`03003ooooo00;oo`003ooo0P00Iooo2`OPUooo0P001?oo000?ool00`00
ooooo`1Zool:1n2Eool00`00ooooo`02ool000ooo`03003ooooo06coo`X7h9?oo`03003ooooo00;o
o`003ooo00<00?ooool0Kooo2@OPTOoo00<00?ooool00_oo000?ool00`00ooooo`1aool91n2?ool0
0`00ooooo`02ool000ooo`03003ooooo07Coo`P7h8goo`03003ooooo00;oo`003ooo00<00?ooool0
M_oo20OPRooo00<00?ooool00_oo000?ool00`00ooooo`1hool81n29ool00`00ooooo`02ool000oo
o`03003ooooo07[oo`T7h8Koo`03003ooooo00;oo`003ooo0P00OOoo20OPQ?oo0P001?oo000?ool0
0`00ooooo`1nool81n23ool00`00ooooo`02ool000ooo`03003ooooo083oo`L7h8;oo`03003ooooo
00;oo`003ooo00<00?ooool0P_oo1`OPP?oo00<00?ooool00_oo000?ool00`00ooooo`24ool71n1n
ool00`00ooooo`02ool000ooo`03003ooooo08Koo`H7h7goo`03003ooooo00;oo`003ooo00<00?oo
ool0Qooo1`OPNooo00<00?ooool00_oo000?ool00`00ooooo`29ool71n1iool00`00ooooo`02ool0
00ooo`03003ooooo08[oo`L7h7Soo`03003ooooo00;oo`003ooo00<00?ooool0S?oo1POPMooo00<0
0?ooool00_oo000?ool2002?ool61n1dool20004ool000ooo`03003ooooo08ooo`H7h7Coo`03003o
oooo00;oo`003ooo00<00?ooool0TOoo1@OPLooo00<00?ooool00_oo000?ool00`00ooooo`2Bool6
1n1aool00`00ooooo`02ool000ooo`03003ooooo09Coo`D7h73oo`03003ooooo00;oo`003ooo00<0
0?ooool0UOoo1@OPKooo00<00?ooool00_oo000?ool00`00ooooo`2Fool61n1]ool00`00ooooo`02
ool000Ooo`<000Goo`03003ooooo09Ooo`H7h6coo`03003ooooo00;oo`002_oo00<00?ooool00_oo
00<00?ooool0V?oo1POPJooo00<00?ooool00_oo000:ool00`00ooooo`02ool3002Jool51n1Yool2
0004ool000Ooo`<000Goo`03003ooooo09coo`D7h6Soo`03003ooooo00;oo`001ooo00<00?ooool0
1Ooo00<00?ooool0WOoo1@OPIooo00<00?ooool00_oo0007ool00`00ooooo`05ool00`00ooooo`2N
ool51n1Vool00`00ooooo`02ool000Ooo`@000Coo`03003ooooo09ooo`D7h6Goo`03003ooooo00;o
o`003ooo00<00?ooool0X?oo1@OPI?oo00<00?ooool00_oo000?ool00`00ooooo`2Qool51n1Sool0
0`00ooooo`02ool000ooo`03003ooooo0:;oo`D7h6;oo`03003ooooo00;oo`003ooo00<00?ooool0
Xooo1@OPHOoo00<00?ooool00_oo000?ool00`00ooooo`2Uool41n1Pool00`00ooooo`02ool000oo
o`800:Koo`D7h5koo`8000Coo`003ooo00<00?ooool0Y_oo1POPGOoo00<00?ooool00_oo000?ool0
0`00ooooo`2Xool41n1Mool00`00ooooo`02ool000ooo`03003ooooo0:Woo`@7h5coo`03003ooooo
00;oo`003ooo00<00?ooool0ZOoo1@OPFooo00<00?ooool00_oo000?ool00`00ooooo`2Zool51n1J
ool00`00ooooo`02ool000ooo`03003ooooo0:_oo`D7h5Woo`03003ooooo00;oo`003ooo00<00?oo
ool0[Ooo10OPF?oo00<00?ooool00_oo000?ool00`00ooooo`2^ool41n1Gool00`00ooooo`02ool0
00ooo`03003ooooo0:koo`D7h5Koo`03003ooooo00;oo`003ooo0P00/?oo1@OPE?oo0P001?oo000?
ool00`00ooooo`2`ool51n1Dool00`00ooooo`02ool000ooo`03003ooooo0;7oo`@7h5Coo`03003o
oooo00;oo`003ooo00<00?ooool0/_oo10OPDooo00<00?ooool00_oo000?ool00`00ooooo`2bool5
1n1Bool00`00ooooo`02ool000ooo`03003ooooo0;?oo`D7h57oo`03003ooooo00;oo`003ooo00<0
0?ooool0]?oo1@OPD?oo00<00?ooool00_oo000?ool00`00ooooo`2eool51n1?ool00`00ooooo`02
ool000ooo`03003ooooo0;Koo`@7h4ooo`03003ooooo00;oo`003ooo0P00^?oo10OPCOoo0P001?oo
000?ool00`00ooooo`2gool51n1=ool00`00ooooo`02ool000ooo`03003ooooo0;Soo`@7h4goo`03
003ooooo00;oo`003ooo00<00?ooool0^Ooo10OPC?oo00<00?ooool00_oo000?ool00`00ooooo`2j
ool41n1;ool00`00ooooo`02ool000ooo`03003ooooo0;_oo`<7h4_oo`03003ooooo00;oo`003ooo
00<00?ooool0_?oo0`OPB_oo00<00?ooool00_oo000?ool00`00ooooo`2lool41n19ool00`00oooo
o`02ool000ooo`03003ooooo0;goo`@7h4Soo`03003ooooo00;oo`003ooo00<00?ooool0_Ooo1@OP
Aooo00<00?ooool00_oo000?ool2002oool51n15ool20004ool000ooo`03003ooooo0;ooo`@7h4Ko
o`03003ooooo00;oo`003ooo00<00?ooool0`?oo0`OPA_oo00<00?ooool00_oo000?ool00`00oooo
o`30ool41n15ool00`00ooooo`02ool000ooo`03003ooooo0<7oo`@7h4Coo`03003ooooo00;oo`00
3ooo00<00?ooool0`Ooo1@OP@ooo00<00?ooool00_oo000?ool00`00ooooo`32ool41n13ool00`00
ooooo`02ool000ooo`03003ooooo0<?oo`@7h4;oo`03003ooooo00;oo`0000?oo`0000000P000ooo
0P001Ooo00<00?ooool0a?oo0`OP@_oo00<00?ooool00_oo0003ool01@00oooooooo00000_oo00<0
0?ooool00_oo00<00?ooool0aOoo0`OP@Ooo00<00?ooool00_oo0003ool01@00oooooooo00000_oo
00<00?ooool00_oo0`00aOoo10OP?ooo0P001?oo0003ool01@00oooooooo00000_oo00<00?ooool0
0_oo00<00?ooool0aOoo10OP@?oo00<00?ooool00_oo0003ool01@00oooooooo00000_oo00<00?oo
ool00_oo00<00?ooool0a_oo10OP?ooo00<00?ooool00_oo00001?oo000000000ooo00@00?ooool0
00Coo`03003ooooo0<Ooo`@7h3koo`03003ooooo00;oo`000ooo00<00?ooool00_oo0P001Ooo00<0
0?ooool0aooo1@OP?Ooo00<00?ooool00_oo000?ool00`00ooooo`38ool41n0mool00`00ooooo`02
ool000ooo`03003ooooo0<Woo`<7h3goo`03003ooooo00;oo`003ooo00<00?ooool0b_oo0`OP??oo
00<00?ooool00_oo000?ool00`00ooooo`39ool41n0lool00`00ooooo`02ool000ooo`800<_oo`@7
h3[oo`8000Coo`003ooo00<00?ooool0booo10OP>_oo00<00?ooool00_oo000?ool00`00ooooo`3;
ool51n0iool00`00ooooo`02ool000ooo`03003ooooo0<coo`@7h3Woo`03003ooooo00;oo`003ooo
00<00?ooool0cOoo0`OP>Ooo00<00?ooool00_oo000?ool00`00ooooo`3>ool31n0hool00`00oooo
o`02ool000ooo`03003ooooo0<koo`<7h3Soo`03003ooooo00;oo`003ooo00<00?ooool0c_oo10OP
=ooo00<00?ooool00_oo000?ool00`00ooooo`3?ool41n0fool00`00ooooo`02ool000ooo`03003o
oooo0<ooo`@7h3Koo`03003ooooo00;oo`003ooo0P00dOoo10OP=?oo0P001?oo000?ool00`00oooo
o`3Aool41n0dool00`00ooooo`02ool000ooo`03003ooooo0=7oo`@7h3Coo`03003ooooo00;oo`00
3ooo00<00?ooool0d_oo0`OP=?oo00<00?ooool00_oo000?ool00`00ooooo`3Bool31n0dool00`00
ooooo`02ool000ooo`03003ooooo0=;oo`@7h3?oo`03003ooooo00;oo`003ooo00<00?ooool0dooo
10OP<_oo00<00?ooool00_oo000?ool00`00ooooo`3Cool41n0bool00`00ooooo`02ool000ooo`03
003ooooo0=Coo`@7h37oo`03003ooooo00;oo`003ooo00<00?ooool0eOoo0`OP<Ooo00<00?ooool0
0_oo000?ool2003Fool41n0_ool20004ool000ooo`03003ooooo0=Koo`@7h2ooo`03003ooooo00;o
o`003ooo00<00?ooool0e_oo10OP;ooo00<00?ooool00_oo000?ool00`00ooooo`3Gool31n0_ool0
0`00ooooo`02ool000ooo`03003ooooo0=Soo`87h2ooo`03003ooooo00;oo`003ooo00<00?ooool0
eooo10OP;_oo00<00?ooool00_oo000?ool00`00ooooo`3Hool41n0]ool00`00ooooo`02ool000oo
o`03003ooooo0=Soo`@7h2goo`03003ooooo00;oo`003ooo00<00?ooool0fOoo10OP;?oo00<00?oo
ool00_oo000?ool2003Jool41n0[ool20004ool000ooo`03003ooooo0=[oo`@7h2_oo`03003ooooo
00;oo`003ooo00<00?ooool0f_oo10OP:ooo00<00?ooool00_oo000?ool00`00ooooo`3Kool31n0[
ool00`00ooooo`02ool000ooo`03003ooooo0=coo`87h2_oo`03003ooooo00;oo`003ooo00<00?oo
ool0fooo10OP:_oo00<00?ooool00_oo000?ool00`00ooooo`3Lool31n0Zool00`00ooooo`02ool0
00ooo`03003ooooo0=coo`@7h2Woo`03003ooooo00;oo`0000?oo`0000000P000_oo0`001Ooo00<0
0?ooool0gOoo10OP:?oo00<00?ooool00_oo0003ool00`00ooooo`04ool00`00ooooo`02ool00`00
ooooo`3Mool41n0Xool00`00ooooo`02ool000?oo`03003ooooo00Coo`03003ooooo00;oo`<00=ko
o`@7h2Koo`8000Coo`000ooo00@00?ooooooo`<000Goo`03003ooooo0=koo`@7h2Ooo`03003ooooo
00;oo`000ooo00D00?ooooooo`0000Ooo`03003ooooo0=ooo`@7h2Koo`03003ooooo00;oo`0000Co
o`00000000?oo`03003ooooo00Goo`03003ooooo0=ooo`@7h2Koo`03003ooooo00;oo`000ooo00@0
0?ooooooo`@000Coo`03003ooooo0>3oo`<7h2Koo`03003ooooo00;oo`003ooo00<00?ooool0h?oo
0`OP9_oo00<00?ooool00_oo000?ool00`00ooooo`3Qool31n0Uool00`00ooooo`02ool000ooo`03
003ooooo0>3oo`@7h2Goo`03003ooooo00;oo`003ooo00<00?ooool0hOoo10OP9?oo00<00?ooool0
0_oo000?ool00`00ooooo`3Qool41n0Tool00`00ooooo`02ool000ooo`800>?oo`@7h2;oo`8000Co
o`003ooo00<00?ooool0h_oo10OP8ooo00<00?ooool00_oo000?ool00`00ooooo`3Sool41n0Rool0
0`00ooooo`02ool000ooo`03003ooooo0>?oo`@7h2;oo`03003ooooo00;oo`003ooo00<00?ooool0
i?oo0`OP8_oo00<00?ooool00_oo000?ool00`00ooooo`3Tool31n0Rool00`00ooooo`02ool000oo
o`03003ooooo0>Goo`87h2;oo`03003ooooo00;oo`003ooo00<00?ooool0iOoo0`OP8Ooo00<00?oo
ool00_oo000?ool00`00ooooo`3Vool21n0Qool00`00ooooo`02ool000ooo`800>Koo`@7h1ooo`80
00Coo`003ooo00<00?ooool0i_oo0`OP8?oo00<00?ooool00_oo000?ool00`00ooooo`3Vool41n0O
ool00`00ooooo`02ool000ooo`03003ooooo0>Ooo`<7h1ooo`03003ooooo00;oo`003ooo00<00?oo
ool0j?oo0`OP7_oo00<00?ooool00_oo000?ool00`00ooooo`3Wool41n0Nool00`00ooooo`02ool0
00ooo`03003ooooo0>Soo`@7h1goo`03003ooooo00;oo`003ooo00<00?ooool0j?oo10OP7Ooo00<0
0?ooool00_oo000?ool00`00ooooo`3Yool21n0Nool00`00ooooo`02ool000ooo`03003ooooo0>Wo
o`<7h1goo`03003ooooo00;oo`003ooo0P00jooo0POP7?oo0P001?oo000?ool00`00ooooo`3Yool4
1n0Lool00`00ooooo`02ool000ooo`03003ooooo0>[oo`<7h1coo`03003ooooo00;oo`003ooo00<0
0?ooool0jooo0`OP6ooo00<00?ooool00_oo000?ool00`00ooooo`3Zool41n0Kool00`00ooooo`02
ool000ooo`03003ooooo0>_oo`@7h1[oo`03003ooooo00;oo`003ooo00<00?ooool0jooo10OP6_oo
00<00?ooool00_oo000?ool00`00ooooo`3/ool31n0Jool00`00ooooo`02ool000ooo`03003ooooo
0>coo`@7h1Woo`03003ooooo00;oo`003ooo0P00k_oo0`OP6?oo0P001?oo000?ool00`00ooooo`3^
ool21n0Iool00`00ooooo`02ool000ooo`03003ooooo0>goo`<7h1Woo`03003ooooo00;oo`003ooo
00<00?ooool0k_oo0POP6Ooo00<00?ooool00_oo000?ool00`00ooooo`3^ool31n0Hool00`00oooo
o`02ool000ooo`03003ooooo0>ooo`87h1Soo`03003ooooo00;oo`003ooo00<00?ooool0kooo0`OP
5ooo00<00?ooool00_oo000?ool00`00ooooo`3^ool41n0Gool00`00ooooo`02ool00003ool00000
008000?oo`8000Goo`03003ooooo0>ooo`<7h1Ooo`03003ooooo00;oo`0000?oo`00ool01?oo00@0
0?ooool000Coo`03003ooooo0>ooo`@7h1Koo`03003ooooo00;oo`000_oo00<00?ooool00_oo00@0
0?ooool000Coo`<00?3oo`<7h1Goo`8000Coo`000ooo00D00?ooooooo`0000;oo`03003ooooo00;o
o`03003ooooo0?7oo`<7h1Goo`03003ooooo00;oo`001?oo00@00?ooool000;oo`03003ooooo00;o
o`03003ooooo0?3oo`@7h1Goo`03003ooooo00;oo`0000Goo`00ooooo`0000;oo`04003ooooo0004
ool00`00ooooo`3aool31n0Eool00`00ooooo`02ool000;oo`8000Coo`8000Goo`03003ooooo0?7o
o`@7h1Coo`03003ooooo00;oo`003ooo00<00?ooool0l_oo0`OP5?oo00<00?ooool00_oo000?ool0
0`00ooooo`3cool21n0Dool00`00ooooo`02ool000ooo`03003ooooo0?;oo`<7h1Coo`03003ooooo
00;oo`003ooo00<00?ooool0looo0POP5?oo00<00?ooool00_oo000?ool00`00ooooo`3bool41n0C
ool00`00ooooo`02ool000ooo`800?Coo`<7h1;oo`8000Coo`003ooo00<00?ooool0m?oo0POP4ooo
00<00?ooool00_oo000?ool00`00ooooo`3cool41n0Bool00`00ooooo`02ool000ooo`03003ooooo
0?Coo`<7h1;oo`03003ooooo00;oo`003ooo00<00?ooool0mOoo0`OP4Ooo00<00?ooool00_oo000?
ool00`00ooooo`3dool41n0Aool00`00ooooo`02ool000ooo`03003ooooo0?Goo`<7h17oo`03003o
oooo00;oo`003ooo00<00?ooool0m_oo0`OP4?oo00<00?ooool00_oo000?ool00`00ooooo`3eool4
1n0@ool00`00ooooo`02ool000ooo`800?Ooo`<7h0ooo`8000Coo`003ooo00<00?ooool0m_oo0`OP
4?oo00<00?ooool00_oo000?ool00`00ooooo`3gool21n0@ool00`00ooooo`02ool000ooo`03003o
oooo0?Soo`031n3ooooo00koo`03003ooooo00;oo`003ooo00<00?ooool0mooo0`OP3ooo00<00?oo
ool00_oo000?ool00`00ooooo`3hool21n0?ool00`00ooooo`02ool000ooo`03003ooooo0?Soo`87
h0ooo`03003ooooo00;oo`003ooo00<00?ooool0mooo10OP3_oo00<00?ooool00_oo000?ool00`00
ooooo`3hool31n0>ool00`00ooooo`02ool000ooo`03003ooooo0?Woo`<7h0goo`03003ooooo00;o
o`003ooo0P00nOoo10OP3?oo0P001?oo000?ool00`00ooooo`3iool31n0=ool00`00ooooo`02ool0
00ooo`03003ooooo0?[oo`<7h0coo`03003ooooo00;oo`003ooo00<00?ooool0nOoo10OP3?oo00<0
0?ooool00_oo000?ool00`00ooooo`3jool31n0<ool00`00ooooo`02ool000ooo`03003ooooo0?_o
o`<7h0_oo`03003ooooo00;oo`003ooo00<00?ooool0n_oo10OP2ooo00<00?ooool00_oo000?ool0
0`00ooooo`3kool31n0;ool00`00ooooo`02ool000ooo`03003ooooo0?coo`87h0_oo`03003ooooo
00;oo`003ooo00<00?ooool0nooo0`OP2ooo00<00?ooool00_oo000?ool2003mool21n0:ool20004
ool000ooo`03003ooooo0?coo`<7h0[oo`03003ooooo00;oo`003ooo00<00?ooool0nooo10OP2_oo
00<00?ooool00_oo000?ool00`00ooooo`3lool31n0:ool00`00ooooo`02ool000ooo`03003ooooo
0?goo`<7h0Woo`03003ooooo00;oo`003ooo00<00?ooool0o?oo10OP2Ooo00<00?ooool00_oo000?
ool00`00ooooo`3mool31n09ool00`00ooooo`02ool00003ool00000008000;oo`<000Goo`03003o
oooo0?koo`<7h0Soo`03003ooooo00;oo`0000?oo`00ool01ooo00<00?ooool00_oo00<00?ooool0
oOoo10OP2?oo00<00?ooool00_oo0002ool00`00ooooo`05ool00`00ooooo`02ool3003nool21n08
ool20004ool000?oo`04003oooooool30005ool00`00ooooo`3oool21n08ool00`00ooooo`02ool0
00Coo`04003ooooo0007ool00`00ooooo`3nool41n07ool00`00ooooo`02ool00005ool00?ooool0
0002ool00`00ooooo`05ool00`00ooooo`3oool31n07ool00`00ooooo`02ool000;oo`8000?oo`@0
00Coo`03003ooooo0?ooo`7oo`87h0Ooo`03003ooooo00;oo`003ooo00<00?ooool0oooo10OP1_oo
00<00?ooool00_oo000?ool00`00ooooo`3oool1ool31n06ool00`00ooooo`02ool000ooo`03003o
oooo0?ooo`;oo`031n3ooooo00Goo`03003ooooo00;oo`003ooo00<00?ooool0oooo0_oo0POP1_oo
00<00?ooool00_oo000?ool00`00ooooo`3oool1ool31n06ool00`00ooooo`02ool000ooo`800?oo
o`?oo`87h0Goo`8000Coo`003ooo00<00?ooool0oooo0_oo0`OP1Ooo00<00?ooool00_oo000?ool0
0`00ooooo`3oool1ool41n05ool00`00ooooo`02ool000ooo`03003ooooo0?ooo`;oo`87h0Koo`03
003ooooo00;oo`003ooo00<00?ooool0oooo0ooo0POP1Ooo00<00?ooool00_oo000?ool00`00oooo
o`3oool2ool41n04ool00`00ooooo`02ool000ooo`03003ooooo0?ooo`?oo`<7h0Coo`03003ooooo
00;oo`003ooo00<00?ooool0oooo1?oo00<7h?ooool00ooo00<00?ooool00_oo000?ool00`00oooo
o`3oool:ool00`00ooooo`02ool000ooo`03003ooooo0?ooo`[oo`03003ooooo00;oo`003ooo0P00
1?oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool0
2Ooo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool0
2Ooo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool0
2Ooo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool02_oo00<00?ooool0
2_oo00@00?ooooooo`8000Coo`003oooo`003P001?oo003ooolQool00?ooob7oo`00oooo8Ooo0000
\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {743.5, 384.75}} -> {-37.7103, \
29.673, 0.390255, 0.103734}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symplectic method", "Subsubsection"],

Cell["\<\
Numerically integrate the equations of motion for the Harmonic \
oscillator using a symplectic partitioned Runge-Kutta method.\
\>", "Text"],

Cell[BoxData[
    \(\(sol\  = \ 
        NDSolve[eqs, vars, time, \ 
          Method \[Rule] {"\<SymplecticPartitionedRungeKutta\>", \ \
"\<DifferenceOrder\>" \[Rule] 
                2, \ "\<PositionVariables\>" \[Rule] {Y\_1[T]}}, \ 
          StartingStepSize \[Rule] step, \ 
          MaxSteps \[Rule] Infinity];\)\)], "Input",
  CellLabel->"In[35]:="],

Cell["The solution is now a closed curve.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot[Evaluate[vars\  /. \ First[sol]], 
        Evaluate[time]];\)\)], "Input",
  CellLabel->"In[36]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.309016 0.294362 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -12 -9 ]
[.2619 .29652 12 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .01465 -12 -4.5 ]
[.4875 .01465 0 4.5 ]
[.4875 .16184 -24 -4.5 ]
[.4875 .16184 0 4.5 ]
[.4875 .4562 -18 -4.5 ]
[.4875 .4562 0 4.5 ]
[.4875 .60338 -6 -4.5 ]
[.4875 .60338 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-0.5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(0.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01465 m
.50625 .01465 L
s
[(-1)] .4875 .01465 1 0 Mshowa
.5 .16184 m
.50625 .16184 L
s
[(-0.5)] .4875 .16184 1 0 Mshowa
.5 .4562 m
.50625 .4562 L
s
[(0.5)] .4875 .4562 1 0 Mshowa
.5 .60338 m
.50625 .60338 L
s
[(1)] .4875 .60338 1 0 Mshowa
.125 Mabswid
.5 .04409 m
.50375 .04409 L
s
.5 .07353 m
.50375 .07353 L
s
.5 .10296 m
.50375 .10296 L
s
.5 .1324 m
.50375 .1324 L
s
.5 .19127 m
.50375 .19127 L
s
.5 .22071 m
.50375 .22071 L
s
.5 .25014 m
.50375 .25014 L
s
.5 .27958 m
.50375 .27958 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36789 m
.50375 .36789 L
s
.5 .39732 m
.50375 .39732 L
s
.5 .42676 m
.50375 .42676 L
s
.5 .48563 m
.50375 .48563 L
s
.5 .51507 m
.50375 .51507 L
s
.5 .54451 m
.50375 .54451 L
s
.5 .57394 m
.50375 .57394 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.97619 .30902 m
.97257 .27278 L
.96302 .24027 L
.94475 .20385 L
.92061 .17104 L
.89267 .14252 L
.86238 .11809 L
.82489 .09385 L
.77987 .07091 L
.73043 .05147 L
.68094 .03679 L
.61901 .02405 L
.56036 .01709 L
.49852 .01472 L
.46346 .01558 L
.43108 .01781 L
.37273 .02542 L
.31274 .03842 L
.28326 .04697 L
.25321 .05732 L
.20271 .07911 L
.15394 .10685 L
.10816 .14178 L
.07591 .17516 L
.06129 .19458 L
.04957 .21353 L
.03299 .25151 L
.02514 .28705 L
.02429 .32218 L
.03081 .35928 L
.04235 .39034 L
.06131 .4235 L
.08855 .45718 L
.12545 .49076 L
.16684 .51929 L
.20977 .54234 L
.26325 .56437 L
.31561 .58036 L
.34586 .58747 L
.37945 .59373 L
.44196 .60112 L
.50152 .60332 L
.56453 .6006 L
.61747 .59422 L
.67394 .58298 L
.70674 .57414 L
.7368 .56435 L
.78983 .54253 L
.8411 .51437 L
.8889 .47885 L
Mistroke
.92274 .44449 L
.93798 .42453 L
.95007 .40515 L
.96713 .36614 L
.97499 .32987 L
.9753 .29106 L
.9718 .26914 L
.96615 .2489 L
.95771 .22783 L
.94786 .20903 L
.91845 .16855 L
.88584 .13654 L
.8432 .105 L
.79678 .07886 L
.74927 .05826 L
.7213 .04842 L
.69006 .03917 L
.63112 .02609 L
.59585 .02074 L
.55817 .01692 L
.52569 .01514 L
.49008 .01478 L
.45218 .0162 L
.41804 .01911 L
.37918 .02434 L
.34331 .0311 L
.28197 .04737 L
.24921 .05883 L
.22043 .07077 L
.17207 .09562 L
.1315 .12262 L
.09997 .14936 L
.07141 .18075 L
.04769 .21699 L
.03872 .23596 L
.03122 .25729 L
.02431 .29556 L
.02523 .33174 L
.03272 .36569 L
.04746 .40062 L
.06545 .42937 L
.0906 .45932 L
.12377 .48943 L
.16561 .51855 L
.21048 .54268 L
.25522 .56146 L
.31246 .57953 L
.34268 .5868 L
.3768 .5933 L
.43868 .60087 L
Mistroke
.49762 .60332 L
.53326 .6026 L
.56695 .6004 L
.62914 .59229 L
.66294 .58555 L
.69349 .57793 L
.75909 .55595 L
.81152 .5316 L
.85551 .50482 L
.88993 .47794 L
.92119 .44632 L
.9477 .40928 L
.95787 .38987 L
.96649 .36813 L
.9751 .32888 L
.97539 .29191 L
.96755 .25321 L
.96046 .234 L
.95025 .2132 L
.92626 .17782 L
.89714 .14663 L
.85542 .11315 L
.81071 .086 L
.75547 .06065 L
.72264 .04886 L
.6916 .03959 L
.63597 .02697 L
.57428 .01832 L
.51592 .01488 L
.46061 .01572 L
.39678 .02171 L
.3396 .03191 L
.27976 .04808 L
.22097 .07053 L
.17646 .09308 L
.13993 .11643 L
.10324 .14628 L
.07437 .17705 L
.05326 .20712 L
.03865 .23612 L
.02827 .26884 L
.02387 .3042 L
.02703 .3432 L
.03248 .36493 L
.03979 .38461 L
.05887 .41986 L
.08661 .4551 L
.11782 .48458 L
.15184 .5098 L
.19413 .53458 L
Mistroke
.24445 .55735 L
.29813 .57557 L
.33022 .58398 L
.36111 .59052 L
.42517 .59966 L
.46187 .60237 L
.49566 .60331 L
.5556 .60131 L
.62 .59382 L
.67876 .58179 L
.73065 .56649 L
.7911 .54192 L
.84195 .51384 L
.88165 .48502 L
.91748 .45058 L
.94737 .40985 L
.95854 .38839 L
.96771 .3643 L
.97293 .34341 L
.97581 .32081 L
.97594 .29942 L
.97386 .27995 L
.96367 .24196 L
.95549 .22318 L
.94414 .20287 L
.91838 .16847 L
.88787 .13828 L
.84487 .10608 L
.79931 .08012 L
.74348 .05609 L
.71048 .04502 L
.67934 .03638 L
.62386 .02484 L
.56252 .01726 L
.5047 .01473 L
.45002 .01634 L
.38713 .0231 L
.33089 .0339 L
.27218 .05058 L
.21459 .07343 L
.16863 .09766 L
.12461 .12794 L
.08961 .15974 L
.06341 .19151 L
.04377 .22471 L
.03165 .25583 L
.02456 .29253 L
.02473 .3273 L
.03255 .36513 L
.0493 .40402 L
Mistroke
.07029 .43584 L
.10003 .46873 L
.13942 .50124 L
.18918 .53198 L
.2424 .55654 L
.29526 .57473 L
.34791 .5879 L
.40613 .59754 L
.45706 .60212 L
.51379 .6032 L
.57435 .59971 L
.63818 .59066 L
.69607 .57721 L
.74621 .56093 L
.79054 .54219 L
.82844 .52211 L
.86878 .49521 L
.90045 .46827 L
.92827 .43768 L
.94894 .40715 L
.96459 .37358 L
.97415 .33621 L
.97586 .29805 L
.97043 .26337 L
.95596 .22415 L
.93437 .18842 L
.908 .15726 L
.87836 .13032 L
.84051 .10329 L
.79476 .07787 L
.74425 .05638 L
.71603 .04674 L
.68521 .03789 L
.62617 .02523 L
.57003 .01791 L
.53758 .01563 L
.50268 .01472 L
.43988 .01707 L
.40193 .02102 L
.36665 .02649 L
.33563 .0328 L
.30284 .04112 L
.24543 .0603 L
.19598 .0825 L
.14752 .11114 L
.10322 .1463 L
.08443 .16532 L
.06665 .18701 L
.05343 .20684 L
.04195 .22856 L
Mistroke
.03331 .25053 L
.02785 .27076 L
.02382 .31069 L
.02863 .35079 L
.04083 .387 L
.06257 .42532 L
.0767 .44382 L
.09457 .46338 L
.12991 .49421 L
.17455 .52386 L
.22236 .54812 L
.27004 .56673 L
.3233 .58231 L
.37577 .59313 L
.43524 .60058 L
.50047 .60332 L
.56519 .60055 L
.59734 .5971 L
.63198 .59179 L
.69145 .57849 L
.74375 .56184 L
.79306 .54098 L
.83538 .51794 L
.86978 .49445 L
.90151 .46725 L
.93014 .43528 L
.95067 .40408 L
.96615 .36912 L
.97502 .32964 L
.97619 .30915 L
.97483 .28683 L
.96536 .24661 L
.94761 .20859 L
.92391 .17495 L
.8872 .13771 L
.84662 .10722 L
.79205 .07656 L
.73432 .05281 L
.67927 .03636 L
.61801 .02389 L
.56396 .01738 L
.50376 .01472 L
.4388 .01715 L
.40282 .02091 L
.37056 .02579 L
.30977 .03922 L
.25548 .05648 L
.20823 .07643 L
.1621 .10165 L
.12372 .12865 L
Mistroke
.0935 .15573 L
.06466 .18975 L
.0516 .20995 L
.04165 .22921 L
.02908 .26537 L
.02386 .30468 L
.02461 .32609 L
.02753 .34573 L
.03317 .36709 L
.04188 .38932 L
.06274 .42556 L
.07793 .44529 L
.09423 .46304 L
.12909 .49358 L
.16767 .51979 L
.21807 .54619 L
.26881 .56631 L
.31629 .58054 L
.37132 .59237 L
.43084 .6002 L
.4878 .60322 L
.54098 .60223 L
.58934 .59809 L
.64133 .59006 L
.69415 .57775 L
.74504 .56136 L
.79548 .53981 L
.83861 .51595 L
.87349 .49159 L
.90864 .46011 L
.92442 .44247 L
.93896 .4231 L
.95958 .38606 L
.9714 .35066 L
.97614 .31348 L
.97258 .27287 L
.96094 .23512 L
.9431 .20122 L
.91902 .1692 L
.89198 .1419 L
.85502 .11288 L
.81511 .08837 L
.76635 .06506 L
.71004 .04489 L
.65881 .03156 L
.60016 .0213 L
.53515 .01552 L
.49834 .01472 L
.46481 .01552 L
.40027 .02124 L
Mistroke
.34089 .03163 L
.29241 .04415 L
.24189 .06169 L
.19323 .08392 L
.15206 .10809 L
.12025 .13145 L
.09119 .15809 L
.06495 .18936 L
.04636 .21952 L
.0323 .25369 L
.0247 .29104 L
.02466 .32657 L
.03062 .35862 L
.04487 .39557 L
.05627 .41581 L
.06885 .43395 L
.097 .46579 L
.13343 .49687 L
.17502 .52413 L
.22629 .54984 L
.27957 .56989 L
.33233 .58447 L
.3871 .59493 L
.4381 .60082 L
.49785 .60332 L
.55407 .60142 L
.61494 .59462 L
.677 .58223 L
.72741 .56759 L
.77903 .5475 L
.82956 .52145 L
.87664 .4891 L
.91353 .45494 L
.94012 .42137 L
.95868 .3881 L
.97118 .3516 L
.97587 .31987 L
.97457 .28479 L
.96569 .24754 L
.94762 .20861 L
.92278 .17359 L
.89379 .14354 L
.85927 .11586 L
.82268 .09259 L
.77803 .07009 L
.72596 .04996 L
.67281 .03478 L
.62033 .02427 L
.57182 .01808 L
.51847 .01494 L
Mistroke
.4565 .01594 L
.40062 .02119 L
.3379 .03229 L
.28127 .0476 L
.23226 .06564 L
.19032 .08545 L
.14868 .11034 L
.11016 .14001 L
.07817 .17246 L
.06416 .19046 L
.05158 .20999 L
.03444 .24719 L
.02578 .28226 L
.02393 .30245 L
.02443 .32406 L
.0318 .3627 L
.04035 .38592 L
.05119 .40738 L
.07845 .4459 L
.11008 .47796 L
.1522 .51004 L
.20348 .5393 L
.25725 .56221 L
.31163 .57931 L
.36406 .59107 L
.42684 .59983 L
.48771 .60322 L
.55346 .60146 L
.58984 .59803 L
.62233 .59344 L
.68379 .58052 L
.73852 .56374 L
.79755 .53879 L
.84591 .51128 L
.89138 .47666 L
.91256 .45599 L
.9296 .43598 L
.9524 .40088 L
.96142 .38174 L
.96869 .36105 L
.97542 .32579 L
.97481 .28664 L
.96723 .2522 L
.95179 .21602 L
.9305 .18323 L
.90556 .15478 L
.87009 .12382 L
.83161 .0978 L
.78393 .07275 L
.72767 .05053 L
Mistroke
.69745 .04121 L
.66362 .03263 L
.63299 .02642 L
.59994 .02127 L
.53608 .01556 L
.47665 .01507 L
.42003 .01889 L
.36934 .02601 L
.3128 .03841 L
.26192 .05414 L
.21801 .07187 L
.18038 .09086 L
.14319 .11412 L
.10802 .14191 L
.07853 .17204 L
.05632 .20214 L
.03722 .23967 L
.02696 .27522 L
.02382 .3107 L
.02833 .34949 L
.04184 .38923 L
.06227 .42488 L
.09113 .45988 L
.12965 .49401 L
.16843 .52026 L
.2167 .54557 L
.27407 .56808 L
.30838 .57844 L
.34085 .5864 L
.37174 .59244 L
.40612 .59754 L
.46992 .60273 L
.53524 .60251 L
.5939 .59754 L
.62586 .59285 L
.65975 .58626 L
.71877 .57042 L
.77062 .55117 L
.82062 .52661 L
.85878 .50253 L
.89521 .47319 L
.9265 .4399 L
.94942 .40631 L
.96412 .37486 L
.97359 .33975 L
.97602 .3011 L
.97412 .2816 L
.9696 .26022 L
.95549 .22318 L
.93531 .18971 L
Mistroke
.91022 .15957 L
.87795 .12999 L
.8068 .08394 L
.76064 .06271 L
.71428 .04619 L
.66031 .03189 L
.60001 .02128 L
.539 .0157 L
.50398 .01472 L
.4712 .01525 L
.40568 .02054 L
.36963 .02596 L
.33738 .03241 L
.28211 .04733 L
.22589 .06836 L
.17756 .09245 L
.13765 .11806 L
.09484 .15438 L
.07724 .17356 L
.06317 .19185 L
.04241 .22757 L
.03453 .24693 L
.02854 .26765 L
.02495 .28864 L
.02382 .31122 L
.02887 .3518 L
.0364 .37625 L
.04658 .39893 L
.05819 .41881 L
.07337 .43975 L
.1047 .47311 L
.14022 .50182 L
.18542 .52996 L
.24042 .55575 L
.26999 .56671 L
.30366 .57714 L
.33437 .58494 L
.368 .59179 L
.40199 .59702 L
.43328 .60042 L
.49512 .6033 L
.55728 .60118 L
.61365 .59481 L
.67361 .58306 L
.70273 .57531 L
.73367 .56545 L
.78282 .54579 L
.83076 .52074 L
.87074 .49371 L
.90223 .46655 L
Mistroke
.93057 .43471 L
.95123 .40306 L
.96689 .36689 L
.97532 .32685 L
.97483 .28682 L
.97127 .2668 L
.96483 .24512 L
.94705 .20765 L
.92342 .17436 L
.89286 .1427 L
.85832 .11518 L
.82257 .09252 L
.78063 .07125 L
.73085 .05161 L
.68176 .037 L
.6263 .02525 L
.56309 .01731 L
.53014 .0153 L
.49405 .01474 L
.42856 .01804 L
.3661 .02659 L
.31031 .03907 L
.27755 .0488 L
.2479 .05934 L
.19611 .08243 L
.14647 .11185 L
.10114 .14825 L
.07132 .18087 L
.04662 .21901 L
.0375 .23895 L
.03027 .2607 L
.02401 .30052 L
.02652 .34039 L
.03692 .37761 L
.05276 .41008 L
.0767 .44383 L
.10807 .47617 L
.14245 .5034 L
.18586 .5302 L
.23714 .55442 L
.28592 .5719 L
.33398 .58485 L
.38901 .59521 L
.44951 .60166 L
.48442 .60316 L
.51665 .60314 L
.55194 .60156 L
.58895 .59814 L
.64983 .58837 L
.68331 .58064 L
Mistroke
.71368 .57203 L
.76737 .55255 L
.81241 .53113 L
.85883 .50249 L
.89659 .47192 L
.92661 .43977 L
.95189 .40184 L
.96129 .38205 L
.9689 .3603 L
.97584 .32026 L
.97423 .28235 L
.96401 .24288 L
.9485 .21013 L
.9246 .17579 L
.88743 .1379 L
.84595 .10678 L
.79006 .07561 L
.73053 .0515 L
.67086 .03431 L
.61286 .0231 L
.58176 .01908 L
.5471 .01616 L
.51064 .01479 L
.47643 .01507 L
.41458 .01949 L
.38057 .02412 L
.35028 .02964 L
.29329 .04389 L
.24273 .06136 L
.18849 .08642 L
.14412 .11347 L
.10247 .14699 L
.08292 .167 L
.06739 .18603 L
.04619 .21985 L
.03114 .25759 L
.02448 .29338 L
.02475 .3275 L
.03309 .36684 L
.04837 .40231 L
.07321 .43955 L
.08883 .45747 L
.10835 .47642 L
.14445 .50479 L
.18823 .53147 L
.22974 .55133 L
.2789 .56967 L
.3356 .58522 L
.36862 .5919 L
.39924 .59665 L
Mistroke
.45997 .60228 L
.51792 .60311 L
.57204 .59993 L
.6283 .59243 L
.67489 .58275 L
.72395 .56874 L
.77344 .54996 L
.82206 .5258 L
.86289 .49958 L
.89536 .47306 L
.92765 .43847 L
.95085 .40375 L
.96543 .37123 L
.9743 .33521 L
.97568 .29535 L
.97306 .27534 L
.96767 .25358 L
.95172 .21589 L
.92972 .18221 L
.90083 .15013 L
.86774 .12204 L
.83321 .09877 L
.79239 .07673 L
.74374 .05619 L
.69546 .04065 L
.64067 .02785 L
.57785 .01867 L
.51261 .01482 L
.47966 .01498 L
.44378 .01677 L
.38106 .02404 L
.32468 .03539 L
.29154 .04441 L
.26139 .05433 L
.20843 .07633 L
.15728 .10469 L
.10998 .14016 L
.0785 .17207 L
.05177 .20965 L
.04158 .22936 L
.03317 .25094 L
.02474 .29064 L
.02508 .33051 L
.03346 .36796 L
.04754 .40076 L
.0697 .43507 L
.09912 .46786 L
.13185 .49569 L
.17356 .52328 L
.22331 .54854 L
Mistroke
.27086 .56701 L
.31803 .58098 L
.37228 .59254 L
.43231 .60033 L
.46694 .60261 L
.49904 .60332 L
.53429 .60256 L
.57142 .59999 L
.6327 .59166 L
.66657 .58473 L
.69744 .57683 L
.75216 .55867 L
.79846 .53834 L
.84658 .51084 L
.88623 .48116 L
.92109 .44644 L
.94568 .41267 L
.95629 .3932 L
.96527 .37169 L
.97475 .33187 L
.97557 .29405 L
.96792 .25439 L
.95455 .2213 L
.93287 .18637 L
.91627 .1661 L
.89827 .14769 L
.85889 .11558 L
.80899 .08509 L
.74718 .05747 L
.68799 .03862 L
.65663 .03109 L
.62114 .0244 L
.55681 .01682 L
.49544 .01473 L
.4367 .01733 L
.37508 .02502 L
.31891 .03683 L
.27031 .05121 L
.2169 .07237 L
.16473 .10002 L
.12187 .13013 L
.08857 .16084 L
.06095 .19507 L
.04182 .22883 L
.02864 .26722 L
.0249 .28914 L
.02381 .30925 L
.02834 .34953 L
.03485 .37202 L
.04338 .39252 L
Mistroke
.06512 .42891 L
.08057 .44837 L
.09652 .46533 L
.13037 .49456 L
.17202 .52238 L
.21191 .54335 L
.2596 .56306 L
.31495 .58019 L
.34737 .58779 L
.37759 .59343 L
.43778 .6008 L
.49566 .60331 L
.54984 .6017 L
.60656 .59586 L
.65379 .58755 L
.70391 .57497 L
.75473 .55767 L
.80518 .53494 L
.848 .50991 L
.88253 .48429 L
.91722 .45087 L
.94297 .41701 L
.96 .3851 L
.97167 .34947 L
.97619 .30986 L
.97518 .28986 L
.97154 .26801 L
.95869 .22996 L
.93946 .19567 L
.91332 .16286 L
.88265 .13384 L
.81126 .08629 L
.7645 .06429 L
.71762 .04724 L
.66292 .03247 L
.60201 .02155 L
.53902 .0157 L
.48062 .01496 L
.41686 .01923 L
.3853 .02338 L
.35138 .02942 L
.29596 .0431 L
.24031 .06233 L
.19204 .08454 L
.15242 .10785 L
.10861 .14138 L
.07563 .17551 L
.06144 .19435 L
.04836 .21574 L
.03761 .23868 L
Mistroke
.03031 .26057 L
.0259 .28147 L
.02397 .30145 L
.02628 .33896 L
.03738 .37878 L
.04754 .40077 L
.05941 .42067 L
.08786 .45643 L
.12606 .49123 L
.16475 .51802 L
.21288 .54381 L
.2705 .56688 L
.30496 .5775 L
.33745 .58564 L
.36853 .59188 L
.40299 .59715 L
.46686 .60261 L
.52657 .60286 L
.59189 .59779 L
.62415 .59314 L
.65821 .5866 L
.71743 .57085 L
.76968 .55158 L
.81986 .52704 L
.85817 .50296 L
.89462 .47373 L
.92632 .44014 L
.9494 .40635 L
.96418 .3747 L
.97363 .33952 L
.976 .30063 L
.97404 .28105 L
.96945 .25967 L
.95519 .22258 L
.93495 .18922 L
.90816 .15742 L
.87714 .12934 L
.80579 .08341 L
.75944 .06223 L
.7131 .04583 L
.65918 .03164 L
.59921 .02117 L
.54323 .01593 L
.48126 .01494 L
.41691 .01923 L
.35834 .02804 L
.30541 .04041 L
.25964 .05496 L
.21032 .07543 L
.16785 .09813 L
Mistroke
.12693 .12612 L
.09026 .15906 L
.06492 .1894 L
.0438 .22465 L
.02941 .264 L
.0252 .28652 L
.02382 .30724 L
.02787 .34737 L
.03989 .38485 L
.05803 .41857 L
.08005 .44777 L
.11171 .47938 L
.14719 .50668 L
.22244 .54816 L
.27056 .5669 L
.31772 .5809 L
.37172 .59244 L
.42381 .59953 L
.48203 .60311 L
.54471 .60202 L
.60958 .59542 L
.6691 .58414 L
.72011 .56999 L
.77211 .55054 L
.81014 .53234 L
.84841 .50963 L
.91223 .45635 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[36]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40n007h00OSooo00<00?ooool0
S_oo002?ool00`00ooooo`2>ool008Koo`@000Goo`03003ooooo08koo`00R?oo00<00?ooool01?oo
00<00?ooool0S_oo001ooolR001oool007Gooa@000Koo`03003ooooo00Gooa@007Goo`00KOoo3P00
3Ooo00<00?ooool01?oo00<00?ooool04_oo3P00K_oo001Wool;000Dool30006ool00`00ooooo`0K
ool;001Xool006;oo`T001goo`03003ooooo00Coo`03003ooooo027oo`T006Coo`00G_oo1`00:_oo
00<00?ooool09ooo2000Gooo001Jool7000^ool00`00ooooo`0/ool7001Kool005Koo`L003;oo`03
003ooooo033oo`L005Ooo`00Dooo1P00=_oo0P00=Ooo1P00E?oo001?ool7000iool00`00ooooo`0g
ool6001Aool004coo`H003goo`03003ooooo03[oo`H004koo`00B_oo1@00@?oo00<00?ooool0?_oo
1@00Booo0017ool50013ool00`00ooooo`10ool60018ool004Coo`D004Koo`03003ooooo04?oo`D0
04Koo`00@_oo1@00B?oo00<00?ooool0A_oo1000A?oo0010ool5001:ool00`00ooooo`18ool40012
ool003koo`@004goo`03003ooooo04[oo`D003ooo`00??oo1000Cooo0P00C_oo1000?Ooo000jool4
001Aool00`00ooooo`1?ool4000kool003Soo`@005?oo`03003ooooo057oo`@003Woo`00=_oo1000
EOoo00<00?ooool0Dooo1000=ooo000dool4001Gool00`00ooooo`1Eool4000eool003;oo`@005Wo
o`03003ooooo05Ooo`<003Coo`00<Ooo0`00Fooo00<00?ooool0FOoo0`00<_oo000_ool3001Mool0
0`00ooooo`1Jool4000`ool002goo`<005ooo`8005goo`@002koo`00;?oo0`00H?oo00<00?ooool0
GOoo1000;Ooo000Zool3001Rool00`00ooooo`1Oool3000/ool002Woo`<006?oo`03003ooooo067o
o`<002[oo`00:?oo0`00I?oo00<00?ooool0H_oo0`00:Ooo000Vool3001Vool00`00ooooo`1Tool3
000Wool002Goo`<006Ooo`03003ooooo06Goo`<002Koo`009?oo0`00J?oo00<00?ooool0I_oo0`00
9Ooo000Sool2001Zool00`00ooooo`1Xool2000Tool0027oo`<006_oo`8006[oo`<002;oo`008?oo
0`00K?oo00<00?ooool0J_oo0`008Ooo000Oool2001^ool00`00ooooo`1[ool3000Pool001koo`80
06ooo`03003ooooo06goo`8001ooo`007Ooo0P00L?oo00<00?ooool0K_oo0P007_oo000Lool2001a
ool00`00ooooo`1_ool2000Mool001_oo`8005koo`8000Coo`03003ooooo00;oo`<000Koo`03003o
oooo073oo`8001coo`006_oo0P00G_oo00@00?ooool000_oo`03003ooooo00?oo`03003ooooo077o
o`8001_oo`006Ooo0P00Gooo00@00?ooool000_oo`03003ooooo00?oo`<007;oo`8001[oo`006?oo
0P00F_oo10000_oo00@00?ooool000Soo`<000Koo`03003ooooo07?oo`8001Woo`005ooo0P00HOoo
00@00?ooool000Soo`03003ooooo00Koo`03003ooooo07Coo`8001Soo`005_oo0`00HOoo00@00?oo
ool000Soo`03003ooooo00Koo`03003ooooo07Goo`8001Ooo`005Ooo0`00Hooo0P002Ooo10001Ooo
00<00?ooool0MOoo0`005_oo000Eool2001hool00`00ooooo`1fool2000Fool001Coo`8007Woo`03
003ooooo07Ooo`8001Goo`004ooo0P00N_oo00<00?ooool0N?oo0P005?oo000Cool2001jool2001i
ool2000Dool001;oo`8007_oo`03003ooooo07Woo`8001?oo`004Ooo0P00O?oo00<00?ooool0N_oo
0P004_oo000Aool2001lool00`00ooooo`1kool2000Aool0013oo`8007goo`03003ooooo07_oo`80
017oo`003ooo0P00O_oo00<00?ooool0O?oo0P004?oo000?ool2001nool00`00ooooo`1lool2000@
ool000koo`8007ooo`03003ooooo07goo`8000ooo`003_oo0P00Oooo00<00?ooool0OOoo0P003ooo
000=ool20020ool2001oool2000>ool000goo`80083oo`03003ooooo07koo`8000koo`003?oo0P00
POoo00<00?ooool0Oooo0P003Ooo000<ool20021ool00`00ooooo`1oool2000=ool000_oo`8008;o
o`03003ooooo083oo`8000coo`002ooo0P00P_oo00<00?ooool0P?oo0P003?oo000:ool20023ool0
0`00ooooo`21ool2000;ool000[oo`8008?oo`03003ooooo087oo`8000_oo`002_oo00<00?ooool0
P_oo0P00P_oo0P002ooo0009ool20024ool00`00ooooo`22ool2000:ool000Woo`8008Coo`03003o
oooo08;oo`8000[oo`002Ooo0P00Q?oo00<00?ooool0P_oo0P002_oo0009ool00`00ooooo`23ool0
0`00ooooo`23ool20009ool000Soo`8008Goo`03003ooooo08?oo`8000Woo`002?oo1000>ooo0P00
1?oo00<00?ooool00_oo0`00>_oo00<00?ooool0>_oo0P001?oo00<00?ooool00_oo0`00>ooo1000
1ooo0008ool3000kool01000ooooo`002ooo00<00?ooool0=ooo00<00?ooool0>Ooo00@00?ooool0
00_oo`03003ooooo03Soo`<000Soo`002?oo0`00>ooo00@00?ooool000_oo`03003ooooo03Ooo`03
003ooooo03Woo`04003ooooo000;ool00`00ooooo`0hool30008ool000;oo`@000;oo`03003oo`00
03Goo`@000;oo`04003ooooo0008ool3000jool2000jool01000ooooo`002?oo0`00??oo0P002?oo
0007ool200000ooo003oo`0jool01000ooooo`002?oo00<00?ooool0>_oo00<00?ooool0>Ooo00@0
0?ooool000Soo`03003ooooo03coo`8000Soo`001ooo1000>ooo00@00?ooool000Soo`03003ooooo
03[oo`03003ooooo03Woo`04003ooooo0008ool00`00ooooo`0kool30008ool000Ooo`800003ool0
0?oo03_oo`8000Woo`@003Woo`03003ooooo03[oo`8000Woo`@003_oo`8000Soo`001ooo0P00Q_oo
00<00?ooool0Q?oo0P002?oo0007ool20026ool00`00ooooo`24ool20008ool000Ooo`8008Koo`03
003ooooo08Coo`8000Soo`001ooo0P00Q_oo00<00?ooool0Q?oo0P002?oo003o000P0001ool000Oo
o`8000coo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00_oo`03003ooooo00[oo`03003o
oooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003o
oooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003o
oooo00_oo`03003ooooo00[oo`03003ooooo00_oo`03003ooooo00[oo`03003ooooo00[oo`8000So
o`001ooo0P00@_oo00<00?ooool0@Ooo00<00?ooool0@Ooo00<00?ooool0@?oo0P002?oo0007ool2
0026ool00`00ooooo`24ool20008ool000Ooo`8008Koo`03003ooooo08Coo`8000Soo`001ooo0P00
Q_oo00<00?ooool0Q?oo0P002?oo0007ool20026ool00`00ooooo`24ool20008ool000Ooo`8008Ko
o`03003ooooo08Coo`8000Soo`001ooo0P00Q_oo0P00QOoo00<00?ooool01ooo0008ool20025ool0
0`00ooooo`23ool20009ool000Soo`8008Goo`03003ooooo08?oo`8000Woo`002?oo0P00QOoo00<0
0?ooool0Pooo0P002Ooo0008ool20025ool00`00ooooo`23ool20009ool000Soo`8008Goo`03003o
oooo08?oo`8000Woo`002Ooo0P00Q?oo00<00?ooool0P_oo0P002_oo0009ool20024ool00`00oooo
o`22ool2000:ool000Woo`8008Coo`03003ooooo08;oo`8000[oo`002_oo00<00?ooool0P_oo0P00
Pooo00<00?ooool02Ooo000:ool20023ool00`00ooooo`21ool2000;ool000[oo`8008?oo`03003o
oooo087oo`8000_oo`002ooo0P00P_oo00<00?ooool0P?oo0P003?oo000;ool20022ool00`00oooo
o`20ool2000<ool000coo`03003ooooo083oo`03003ooooo07ooo`<000coo`003?oo0P00POoo00<0
0?ooool0Oooo0P003Ooo000=ool00`00ooooo`1oool00`00ooooo`1nool3000=ool000goo`80083o
o`8007ooo`8000koo`003_oo00<00?ooool0O_oo00<00?ooool0OOoo0`003_oo000>ool2001oool0
0`00ooooo`1mool2000?ool000ooo`03003ooooo07goo`03003ooooo07goo`8000ooo`003ooo0P00
O_oo00<00?ooool0O?oo0P004?oo000@ool2001mool00`00ooooo`1lool00`00ooooo`0?ool0013o
o`8007goo`03003ooooo07_oo`80017oo`004Ooo0P00O?oo00<00?ooool0N_oo0P004_oo000Bool2
001kool00`00ooooo`1iool2000Cool001?oo`03003ooooo07Woo`8007[oo`03003ooooo01;oo`00
4ooo0P00N_oo00<00?ooool0N?oo0P005?oo000Dool2001iool00`00ooooo`1gool2000Eool001Go
o`8007Soo`03003ooooo07Koo`8001Koo`005_oo00<00?ooool0M_oo00<00?ooool0M_oo0P005_oo
000Fool2001gool00`00ooooo`1eool2000Gool001Ooo`8006;oo`8000Coo`03003ooooo00;oo`<0
00Koo`03003ooooo07Coo`8001Soo`006?oo0P00H?oo00@00?ooool000_oo`03003ooooo00?oo`03
003ooooo07?oo`8001Woo`006Ooo0P00Gooo00@00?ooool000_oo`03003ooooo00?oo`<007;oo`80
01[oo`006_oo0P00G_oo00@00?ooool000Soo`<000Koo`03003ooooo077oo`8001_oo`006ooo0P00
GOoo00@00?ooool000Soo`03003ooooo00Koo`03003ooooo073oo`8001coo`007?oo0P00G?oo00@0
0?ooool000Soo`03003ooooo00Koo`03003ooooo06ooo`8001goo`007Ooo0P00G?oo0P002Ooo1000
1Ooo00<00?ooool0K_oo0P007_oo000Nool2001_ool00`00ooooo`1]ool2000Oool001ooo`8006ko
o`03003ooooo06_oo`<0023oo`008?oo0`00K?oo00<00?ooool0J_oo0`008Ooo000Qool3001[ool2
001Zool3000Rool002?oo`8006[oo`03003ooooo06Ooo`<002Coo`009?oo0P00JOoo00<00?ooool0
I_oo0`009Ooo000Uool3001Wool00`00ooooo`1Uool3000Vool002Koo`<006Koo`03003ooooo06Co
o`<002Ooo`009ooo0`00IOoo00<00?ooool0H_oo0`00:Ooo000Yool3001Sool00`00ooooo`1Qool3
000Zool002_oo`8006;oo`03003ooooo05ooo`<002coo`00;?oo0`00H?oo00<00?ooool0G_oo0`00
;Ooo000]ool4001Nool2001Mool4000^ool002ooo`@005coo`03003ooooo05[oo`@0033oo`00<?oo
1@00F_oo00<00?ooool0FOoo0`00<_oo000bool4001Iool00`00ooooo`1Gool4000cool003Coo`@0
05Ooo`03003ooooo05Goo`@003Goo`00=_oo1000EOoo00<00?ooool0Dooo1000=ooo000hool4001C
ool00`00ooooo`1Aool4000iool003[oo`@0057oo`03003ooooo04ooo`@003_oo`00??oo1000Cooo
0P00C_oo1000?Ooo000nool4001=ool00`00ooooo`1:ool5000oool0043oo`@004_oo`03003ooooo
04Soo`D0047oo`00@ooo1000B?oo00<00?ooool0A_oo1000A?oo0015ool40016ool00`00ooooo`13
ool50016ool004Soo`@004?oo`03003ooooo047oo`@004Woo`00B_oo1@00@?oo00<00?ooool0?Ooo
1P00Booo001<ool7000lool00`00ooooo`0jool6001>ool004ooo`L003Woo`03003ooooo03Ooo`H0
057oo`00D_oo2000=Ooo0P00=?oo1`00E?oo001Fool7000bool00`00ooooo`0_ool8001Gool005[o
o`L002koo`03003ooooo02_oo`P005_oo`00G_oo2000:Ooo00<00?ooool09ooo2000Gooo001Rool9
000Tool00`00ooooo`0Qool:001Sool006Ooo`/001goo`03003ooooo01[oo``006Soo`00KOoo3@00
3?oo10001Ooo00<00?ooool04Ooo3`00K_oo001doolC00000ooo003oo`05ool00`00ooooo`03oolF
001eool007goob@007ooo`00R?oo00<00?ooool01?oo00<00?ooool0S_oo0028ool00`00ooooo`04
ool00`00ooooo`2>ool008Koo`<000Koo`03003ooooo08koo`00R?oo00<00?ooool01?oo00<00?oo
ool0S_oo0000\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {348.5, 127.312}} -> {-1.60766, \
0.159657, 0.00736193, 0.0119094}}]
}, Open  ]],

Cell["\<\
In contrast to dissipative methods, symplectic integrators yield an \
error in the Hamiltonian that remains bounded.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(InvariantErrorPlot[H, \ vars, T, \ sol, \ 
        SymbolStyle \[Rule] Blue];\)\)], "Input",
  CellLabel->"In[37]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00953907 0.0238095 4761.93 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21459 -0.0125 -6 -9 ]
[.21459 -0.0125 6 0 ]
[.40537 -0.0125 -6 -9 ]
[.40537 -0.0125 6 0 ]
[.59615 -0.0125 -6 -9 ]
[.59615 -0.0125 6 0 ]
[.78694 -0.0125 -6 -9 ]
[.78694 -0.0125 6 0 ]
[.97772 -0.0125 -9 -9 ]
[.97772 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .26191 -42 -4.5 ]
[-0.0125 .26191 0 4.5 ]
[-0.0125 .5 -36 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7381 -42 -4.5 ]
[-0.0125 .7381 0 4.5 ]
[-0.0125 .9762 -36 -4.5 ]
[-0.0125 .9762 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21459 0 m
.21459 .00625 L
s
[(20)] .21459 -0.0125 0 1 Mshowa
.40537 0 m
.40537 .00625 L
s
[(40)] .40537 -0.0125 0 1 Mshowa
.59615 0 m
.59615 .00625 L
s
[(60)] .59615 -0.0125 0 1 Mshowa
.78694 0 m
.78694 .00625 L
s
[(80)] .78694 -0.0125 0 1 Mshowa
.97772 0 m
.97772 .00625 L
s
[(100)] .97772 -0.0125 0 1 Mshowa
.125 Mabswid
.0715 0 m
.0715 .00375 L
s
.1192 0 m
.1192 .00375 L
s
.1669 0 m
.1669 .00375 L
s
.26229 0 m
.26229 .00375 L
s
.30998 0 m
.30998 .00375 L
s
.35768 0 m
.35768 .00375 L
s
.45307 0 m
.45307 .00375 L
s
.50076 0 m
.50076 .00375 L
s
.54846 0 m
.54846 .00375 L
s
.64385 0 m
.64385 .00375 L
s
.69154 0 m
.69154 .00375 L
s
.73924 0 m
.73924 .00375 L
s
.83463 0 m
.83463 .00375 L
s
.88233 0 m
.88233 .00375 L
s
.93002 0 m
.93002 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .26191 m
.00625 .26191 L
s
[(0.00005)] -0.0125 .26191 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0.0001)] -0.0125 .5 1 0 Mshowa
0 .7381 m
.00625 .7381 L
s
[(0.00015)] -0.0125 .7381 1 0 Mshowa
0 .9762 m
.00625 .9762 L
s
[(0.0002)] -0.0125 .9762 1 0 Mshowa
.125 Mabswid
0 .07143 m
.00375 .07143 L
s
0 .11905 m
.00375 .11905 L
s
0 .16667 m
.00375 .16667 L
s
0 .21429 m
.00375 .21429 L
s
0 .30953 m
.00375 .30953 L
s
0 .35714 m
.00375 .35714 L
s
0 .40476 m
.00375 .40476 L
s
0 .45238 m
.00375 .45238 L
s
0 .54762 m
.00375 .54762 L
s
0 .59524 m
.00375 .59524 L
s
0 .64286 m
.00375 .64286 L
s
0 .69048 m
.00375 .69048 L
s
0 .78572 m
.00375 .78572 L
s
0 .83334 m
.00375 .83334 L
s
0 .88096 m
.00375 .88096 L
s
0 .92858 m
.00375 .92858 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21459 .99375 m
.21459 1 L
s
.40537 .99375 m
.40537 1 L
s
.59615 .99375 m
.59615 1 L
s
.78694 .99375 m
.78694 1 L
s
.97772 .99375 m
.97772 1 L
s
.125 Mabswid
.0715 .99625 m
.0715 1 L
s
.1192 .99625 m
.1192 1 L
s
.1669 .99625 m
.1669 1 L
s
.26229 .99625 m
.26229 1 L
s
.30998 .99625 m
.30998 1 L
s
.35768 .99625 m
.35768 1 L
s
.45307 .99625 m
.45307 1 L
s
.50076 .99625 m
.50076 1 L
s
.54846 .99625 m
.54846 1 L
s
.64385 .99625 m
.64385 1 L
s
.69154 .99625 m
.69154 1 L
s
.73924 .99625 m
.73924 1 L
s
.83463 .99625 m
.83463 1 L
s
.88233 .99625 m
.88233 1 L
s
.93002 .99625 m
.93002 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .26191 m
1 .26191 L
s
.99375 .5 m
1 .5 L
s
.99375 .7381 m
1 .7381 L
s
.99375 .9762 m
1 .9762 L
s
.125 Mabswid
.99625 .07143 m
1 .07143 L
s
.99625 .11905 m
1 .11905 L
s
.99625 .16667 m
1 .16667 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .30953 m
1 .30953 L
s
.99625 .35714 m
1 .35714 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .45238 m
1 .45238 L
s
.99625 .54762 m
1 .54762 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .64286 m
1 .64286 L
s
.99625 .69048 m
1 .69048 L
s
.99625 .78572 m
1 .78572 L
s
.99625 .83334 m
1 .83334 L
s
.99625 .88096 m
1 .88096 L
s
.99625 .92858 m
1 .92858 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 1 r
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.02686 .11806 -1.875 0 Mabsadd m
.02686 .11806 0 2.5 Mabsadd L
.02686 .11806 1.875 0 Mabsadd L
.02686 .11806 0 -2.5 Mabsadd L
.02686 .11806 -1.875 0 Mabsadd L closepath F
.02991 .36351 -1.875 0 Mabsadd m
.02991 .36351 0 2.5 Mabsadd L
.02991 .36351 1.875 0 Mabsadd L
.02991 .36351 0 -2.5 Mabsadd L
.02991 .36351 -1.875 0 Mabsadd L closepath F
.03297 .66299 -1.875 0 Mabsadd m
.03297 .66299 0 2.5 Mabsadd L
.03297 .66299 1.875 0 Mabsadd L
.03297 .66299 0 -2.5 Mabsadd L
.03297 .66299 -1.875 0 Mabsadd L closepath F
.03602 .89795 -1.875 0 Mabsadd m
.03602 .89795 0 2.5 Mabsadd L
.03602 .89795 1.875 0 Mabsadd L
.03602 .89795 0 -2.5 Mabsadd L
.03602 .89795 -1.875 0 Mabsadd L closepath F
.03907 .97538 -1.875 0 Mabsadd m
.03907 .97538 0 2.5 Mabsadd L
.03907 .97538 1.875 0 Mabsadd L
.03907 .97538 0 -2.5 Mabsadd L
.03907 .97538 -1.875 0 Mabsadd L closepath F
.04212 .86463 -1.875 0 Mabsadd m
.04212 .86463 0 2.5 Mabsadd L
.04212 .86463 1.875 0 Mabsadd L
.04212 .86463 0 -2.5 Mabsadd L
.04212 .86463 -1.875 0 Mabsadd L closepath F
.04518 .60953 -1.875 0 Mabsadd m
.04518 .60953 0 2.5 Mabsadd L
.04518 .60953 1.875 0 Mabsadd L
.04518 .60953 0 -2.5 Mabsadd L
.04518 .60953 -1.875 0 Mabsadd L closepath F
.04823 .31108 -1.875 0 Mabsadd m
.04823 .31108 0 2.5 Mabsadd L
.04823 .31108 1.875 0 Mabsadd L
.04823 .31108 0 -2.5 Mabsadd L
.04823 .31108 -1.875 0 Mabsadd L closepath F
.05128 .08742 -1.875 0 Mabsadd m
.05128 .08742 0 2.5 Mabsadd L
.05128 .08742 1.875 0 Mabsadd L
.05128 .08742 0 -2.5 Mabsadd L
.05128 .08742 -1.875 0 Mabsadd L closepath F
.05433 .02708 -1.875 0 Mabsadd m
.05433 .02708 0 2.5 Mabsadd L
.05433 .02708 1.875 0 Mabsadd L
.05433 .02708 0 -2.5 Mabsadd L
.05433 .02708 -1.875 0 Mabsadd L closepath F
.05739 .15395 -1.875 0 Mabsadd m
.05739 .15395 0 2.5 Mabsadd L
.05739 .15395 1.875 0 Mabsadd L
.05739 .15395 0 -2.5 Mabsadd L
.05739 .15395 -1.875 0 Mabsadd L closepath F
.06044 .41781 -1.875 0 Mabsadd m
.06044 .41781 0 2.5 Mabsadd L
.06044 .41781 1.875 0 Mabsadd L
.06044 .41781 0 -2.5 Mabsadd L
.06044 .41781 -1.875 0 Mabsadd L closepath F
.06349 .71421 -1.875 0 Mabsadd m
.06349 .71421 0 2.5 Mabsadd L
.06349 .71421 1.875 0 Mabsadd L
.06349 .71421 0 -2.5 Mabsadd L
.06349 .71421 -1.875 0 Mabsadd L closepath F
.06654 .92581 -1.875 0 Mabsadd m
.06654 .92581 0 2.5 Mabsadd L
.06654 .92581 1.875 0 Mabsadd L
.06654 .92581 0 -2.5 Mabsadd L
.06654 .92581 -1.875 0 Mabsadd L closepath F
.0696 .96885 -1.875 0 Mabsadd m
.0696 .96885 0 2.5 Mabsadd L
.0696 .96885 1.875 0 Mabsadd L
.0696 .96885 0 -2.5 Mabsadd L
.0696 .96885 -1.875 0 Mabsadd L closepath F
.07265 .82629 -1.875 0 Mabsadd m
.07265 .82629 0 2.5 Mabsadd L
.07265 .82629 1.875 0 Mabsadd L
.07265 .82629 0 -2.5 Mabsadd L
.07265 .82629 -1.875 0 Mabsadd L closepath F
.0757 .55457 -1.875 0 Mabsadd m
.0757 .55457 0 2.5 Mabsadd L
.0757 .55457 1.875 0 Mabsadd L
.0757 .55457 0 -2.5 Mabsadd L
.0757 .55457 -1.875 0 Mabsadd L closepath F
.07875 .26125 -1.875 0 Mabsadd m
.07875 .26125 0 2.5 Mabsadd L
.07875 .26125 1.875 0 Mabsadd L
.07875 .26125 0 -2.5 Mabsadd L
.07875 .26125 -1.875 0 Mabsadd L closepath F
.08181 .06244 -1.875 0 Mabsadd m
.08181 .06244 0 2.5 Mabsadd L
.08181 .06244 1.875 0 Mabsadd L
.08181 .06244 0 -2.5 Mabsadd L
.08181 .06244 -1.875 0 Mabsadd L closepath F
.08486 .03684 -1.875 0 Mabsadd m
.08486 .03684 0 2.5 Mabsadd L
.08486 .03684 1.875 0 Mabsadd L
.08486 .03684 0 -2.5 Mabsadd L
.08486 .03684 -1.875 0 Mabsadd L closepath F
.08791 .19459 -1.875 0 Mabsadd m
.08791 .19459 0 2.5 Mabsadd L
.08791 .19459 1.875 0 Mabsadd L
.08791 .19459 0 -2.5 Mabsadd L
.08791 .19459 -1.875 0 Mabsadd L closepath F
.09096 .47324 -1.875 0 Mabsadd m
.09096 .47324 0 2.5 Mabsadd L
.09096 .47324 1.875 0 Mabsadd L
.09096 .47324 0 -2.5 Mabsadd L
.09096 .47324 -1.875 0 Mabsadd L closepath F
.09402 .76249 -1.875 0 Mabsadd m
.09402 .76249 0 2.5 Mabsadd L
.09402 .76249 1.875 0 Mabsadd L
.09402 .76249 0 -2.5 Mabsadd L
.09402 .76249 -1.875 0 Mabsadd L closepath F
.09707 .94782 -1.875 0 Mabsadd m
.09707 .94782 0 2.5 Mabsadd L
.09707 .94782 1.875 0 Mabsadd L
.09707 .94782 0 -2.5 Mabsadd L
.09707 .94782 -1.875 0 Mabsadd L closepath F
.10012 .95589 -1.875 0 Mabsadd m
.10012 .95589 0 2.5 Mabsadd L
.10012 .95589 1.875 0 Mabsadd L
.10012 .95589 0 -2.5 Mabsadd L
.10012 .95589 -1.875 0 Mabsadd L closepath F
.10317 .78348 -1.875 0 Mabsadd m
.10317 .78348 0 2.5 Mabsadd L
.10317 .78348 1.875 0 Mabsadd L
.10317 .78348 0 -2.5 Mabsadd L
.10317 .78348 -1.875 0 Mabsadd L closepath F
.10623 .49886 -1.875 0 Mabsadd m
.10623 .49886 0 2.5 Mabsadd L
.10623 .49886 1.875 0 Mabsadd L
.10623 .49886 0 -2.5 Mabsadd L
.10623 .49886 -1.875 0 Mabsadd L closepath F
.10928 .21469 -1.875 0 Mabsadd m
.10928 .21469 0 2.5 Mabsadd L
.10928 .21469 1.875 0 Mabsadd L
.10928 .21469 0 -2.5 Mabsadd L
.10928 .21469 -1.875 0 Mabsadd L closepath F
.11233 .04347 -1.875 0 Mabsadd m
.11233 .04347 0 2.5 Mabsadd L
.11233 .04347 1.875 0 Mabsadd L
.11233 .04347 0 -2.5 Mabsadd L
.11233 .04347 -1.875 0 Mabsadd L closepath F
.11538 .05296 -1.875 0 Mabsadd m
.11538 .05296 0 2.5 Mabsadd L
.11538 .05296 1.875 0 Mabsadd L
.11538 .05296 0 -2.5 Mabsadd L
.11538 .05296 -1.875 0 Mabsadd L closepath F
.11844 .23942 -1.875 0 Mabsadd m
.11844 .23942 0 2.5 Mabsadd L
.11844 .23942 1.875 0 Mabsadd L
.11844 .23942 0 -2.5 Mabsadd L
.11844 .23942 -1.875 0 Mabsadd L closepath F
.12149 .52904 -1.875 0 Mabsadd m
.12149 .52904 0 2.5 Mabsadd L
.12149 .52904 1.875 0 Mabsadd L
.12149 .52904 0 -2.5 Mabsadd L
.12149 .52904 -1.875 0 Mabsadd L closepath F
.12454 .80716 -1.875 0 Mabsadd m
.12454 .80716 0 2.5 Mabsadd L
.12454 .80716 1.875 0 Mabsadd L
.12454 .80716 0 -2.5 Mabsadd L
.12454 .80716 -1.875 0 Mabsadd L closepath F
.12759 .96369 -1.875 0 Mabsadd m
.12759 .96369 0 2.5 Mabsadd L
.12759 .96369 1.875 0 Mabsadd L
.12759 .96369 0 -2.5 Mabsadd L
.12759 .96369 -1.875 0 Mabsadd L closepath F
.13065 .93666 -1.875 0 Mabsadd m
.13065 .93666 0 2.5 Mabsadd L
.13065 .93666 1.875 0 Mabsadd L
.13065 .93666 0 -2.5 Mabsadd L
.13065 .93666 -1.875 0 Mabsadd L closepath F
.1337 .73678 -1.875 0 Mabsadd m
.1337 .73678 0 2.5 Mabsadd L
.1337 .73678 1.875 0 Mabsadd L
.1337 .73678 0 -2.5 Mabsadd L
.1337 .73678 -1.875 0 Mabsadd L closepath F
.13675 .44317 -1.875 0 Mabsadd m
.13675 .44317 0 2.5 Mabsadd L
.13675 .44317 1.875 0 Mabsadd L
.13675 .44317 0 -2.5 Mabsadd L
.13675 .44317 -1.875 0 Mabsadd L closepath F
.1398 .17205 -1.875 0 Mabsadd m
.1398 .17205 0 2.5 Mabsadd L
.1398 .17205 1.875 0 Mabsadd L
.1398 .17205 0 -2.5 Mabsadd L
.1398 .17205 -1.875 0 Mabsadd L closepath F
.14286 .03076 -1.875 0 Mabsadd m
.14286 .03076 0 2.5 Mabsadd L
.14286 .03076 1.875 0 Mabsadd L
.14286 .03076 0 -2.5 Mabsadd L
.14286 .03076 -1.875 0 Mabsadd L closepath F
.14591 .07522 -1.875 0 Mabsadd m
.14591 .07522 0 2.5 Mabsadd L
.14591 .07522 1.875 0 Mabsadd L
.14591 .07522 0 -2.5 Mabsadd L
.14591 .07522 -1.875 0 Mabsadd L closepath F
.14896 .28784 -1.875 0 Mabsadd m
.14896 .28784 0 2.5 Mabsadd L
.14896 .28784 1.875 0 Mabsadd L
.14896 .28784 0 -2.5 Mabsadd L
.14896 .28784 -1.875 0 Mabsadd L closepath F
.15201 .58444 -1.875 0 Mabsadd m
.15201 .58444 0 2.5 Mabsadd L
.15201 .58444 1.875 0 Mabsadd L
.15201 .58444 0 -2.5 Mabsadd L
.15201 .58444 -1.875 0 Mabsadd L closepath F
.15507 .84762 -1.875 0 Mabsadd m
.15507 .84762 0 2.5 Mabsadd L
.15507 .84762 1.875 0 Mabsadd L
.15507 .84762 0 -2.5 Mabsadd L
.15507 .84762 -1.875 0 Mabsadd L closepath F
.15812 .97319 -1.875 0 Mabsadd m
.15812 .97319 0 2.5 Mabsadd L
.15812 .97319 1.875 0 Mabsadd L
.15812 .97319 0 -2.5 Mabsadd L
.15812 .97319 -1.875 0 Mabsadd L closepath F
.16117 .91145 -1.875 0 Mabsadd m
.16117 .91145 0 2.5 Mabsadd L
.16117 .91145 1.875 0 Mabsadd L
.16117 .91145 0 -2.5 Mabsadd L
.16117 .91145 -1.875 0 Mabsadd L closepath F
.16422 .68683 -1.875 0 Mabsadd m
.16422 .68683 0 2.5 Mabsadd L
.16422 .68683 1.875 0 Mabsadd L
.16422 .68683 0 -2.5 Mabsadd L
.16422 .68683 -1.875 0 Mabsadd L closepath F
.16728 .38826 -1.875 0 Mabsadd m
.16728 .38826 0 2.5 Mabsadd L
.16728 .38826 1.875 0 Mabsadd L
.16728 .38826 0 -2.5 Mabsadd L
.16728 .38826 -1.875 0 Mabsadd L closepath F
.17033 .13392 -1.875 0 Mabsadd m
.17033 .13392 0 2.5 Mabsadd L
.17033 .13392 1.875 0 Mabsadd L
.17033 .13392 0 -2.5 Mabsadd L
.17033 .13392 -1.875 0 Mabsadd L closepath F
.17338 .0245 -1.875 0 Mabsadd m
.17338 .0245 0 2.5 Mabsadd L
.17338 .0245 1.875 0 Mabsadd L
.17338 .0245 0 -2.5 Mabsadd L
.17338 .0245 -1.875 0 Mabsadd L closepath F
.17643 .10331 -1.875 0 Mabsadd m
.17643 .10331 0 2.5 Mabsadd L
.17643 .10331 1.875 0 Mabsadd L
.17643 .10331 0 -2.5 Mabsadd L
.17643 .10331 -1.875 0 Mabsadd L closepath F
.17949 .33916 -1.875 0 Mabsadd m
.17949 .33916 0 2.5 Mabsadd L
.17949 .33916 1.875 0 Mabsadd L
.17949 .33916 0 -2.5 Mabsadd L
.17949 .33916 -1.875 0 Mabsadd L closepath F
.18254 .63868 -1.875 0 Mabsadd m
.18254 .63868 0 2.5 Mabsadd L
.18254 .63868 1.875 0 Mabsadd L
.18254 .63868 0 -2.5 Mabsadd L
.18254 .63868 -1.875 0 Mabsadd L closepath F
.18559 .8833 -1.875 0 Mabsadd m
.18559 .8833 0 2.5 Mabsadd L
.18559 .8833 1.875 0 Mabsadd L
.18559 .8833 0 -2.5 Mabsadd L
.18559 .8833 -1.875 0 Mabsadd L closepath F
.18864 .97619 -1.875 0 Mabsadd m
.18864 .97619 0 2.5 Mabsadd L
.18864 .97619 1.875 0 Mabsadd L
.18864 .97619 0 -2.5 Mabsadd L
.18864 .97619 -1.875 0 Mabsadd L closepath F
.1917 .88058 -1.875 0 Mabsadd m
.1917 .88058 0 2.5 Mabsadd L
.1917 .88058 1.875 0 Mabsadd L
.1917 .88058 0 -2.5 Mabsadd L
.1917 .88058 -1.875 0 Mabsadd L closepath F
.19475 .63431 -1.875 0 Mabsadd m
.19475 .63431 0 2.5 Mabsadd L
.19475 .63431 1.875 0 Mabsadd L
.19475 .63431 0 -2.5 Mabsadd L
.19475 .63431 -1.875 0 Mabsadd L closepath F
.1978 .33488 -1.875 0 Mabsadd m
.1978 .33488 0 2.5 Mabsadd L
.1978 .33488 1.875 0 Mabsadd L
.1978 .33488 0 -2.5 Mabsadd L
.1978 .33488 -1.875 0 Mabsadd L closepath F
.20085 .10081 -1.875 0 Mabsadd m
.20085 .10081 0 2.5 Mabsadd L
.20085 .10081 1.875 0 Mabsadd L
.20085 .10081 0 -2.5 Mabsadd L
.20085 .10081 -1.875 0 Mabsadd L closepath F
.20391 .02477 -1.875 0 Mabsadd m
.20391 .02477 0 2.5 Mabsadd L
.20391 .02477 1.875 0 Mabsadd L
.20391 .02477 0 -2.5 Mabsadd L
.20391 .02477 -1.875 0 Mabsadd L closepath F
.20696 .13685 -1.875 0 Mabsadd m
.20696 .13685 0 2.5 Mabsadd L
.20696 .13685 1.875 0 Mabsadd L
.20696 .13685 0 -2.5 Mabsadd L
.20696 .13685 -1.875 0 Mabsadd L closepath F
.21001 .39269 -1.875 0 Mabsadd m
.21001 .39269 0 2.5 Mabsadd L
.21001 .39269 1.875 0 Mabsadd L
.21001 .39269 0 -2.5 Mabsadd L
.21001 .39269 -1.875 0 Mabsadd L closepath F
.21306 .69101 -1.875 0 Mabsadd m
.21306 .69101 0 2.5 Mabsadd L
.21306 .69101 1.875 0 Mabsadd L
.21306 .69101 0 -2.5 Mabsadd L
.21306 .69101 -1.875 0 Mabsadd L closepath F
.21612 .91372 -1.875 0 Mabsadd m
.21612 .91372 0 2.5 Mabsadd L
.21612 .91372 1.875 0 Mabsadd L
.21612 .91372 0 -2.5 Mabsadd L
.21612 .91372 -1.875 0 Mabsadd L closepath F
.21917 .97265 -1.875 0 Mabsadd m
.21917 .97265 0 2.5 Mabsadd L
.21917 .97265 1.875 0 Mabsadd L
.21917 .97265 0 -2.5 Mabsadd L
.21917 .97265 -1.875 0 Mabsadd L closepath F
.22222 .84449 -1.875 0 Mabsadd m
.22222 .84449 0 2.5 Mabsadd L
.22222 .84449 1.875 0 Mabsadd L
.22222 .84449 0 -2.5 Mabsadd L
.22222 .84449 -1.875 0 Mabsadd L closepath F
.22527 .57995 -1.875 0 Mabsadd m
.22527 .57995 0 2.5 Mabsadd L
.22527 .57995 1.875 0 Mabsadd L
.22527 .57995 0 -2.5 Mabsadd L
.22527 .57995 -1.875 0 Mabsadd L closepath F
.22833 .28376 -1.875 0 Mabsadd m
.22833 .28376 0 2.5 Mabsadd L
.22833 .28376 1.875 0 Mabsadd L
.22833 .28376 0 -2.5 Mabsadd L
.22833 .28376 -1.875 0 Mabsadd L closepath F
.23138 .07318 -1.875 0 Mabsadd m
.23138 .07318 0 2.5 Mabsadd L
.23138 .07318 1.875 0 Mabsadd L
.23138 .07318 0 -2.5 Mabsadd L
.23138 .07318 -1.875 0 Mabsadd L closepath F
.23443 .03156 -1.875 0 Mabsadd m
.23443 .03156 0 2.5 Mabsadd L
.23443 .03156 1.875 0 Mabsadd L
.23443 .03156 0 -2.5 Mabsadd L
.23443 .03156 -1.875 0 Mabsadd L closepath F
.23748 .17537 -1.875 0 Mabsadd m
.23748 .17537 0 2.5 Mabsadd L
.23748 .17537 1.875 0 Mabsadd L
.23748 .17537 0 -2.5 Mabsadd L
.23748 .17537 -1.875 0 Mabsadd L closepath F
.24054 .4477 -1.875 0 Mabsadd m
.24054 .4477 0 2.5 Mabsadd L
.24054 .4477 1.875 0 Mabsadd L
.24054 .4477 0 -2.5 Mabsadd L
.24054 .4477 -1.875 0 Mabsadd L closepath F
.24359 .74073 -1.875 0 Mabsadd m
.24359 .74073 0 2.5 Mabsadd L
.24359 .74073 1.875 0 Mabsadd L
.24359 .74073 0 -2.5 Mabsadd L
.24359 .74073 -1.875 0 Mabsadd L closepath F
.24664 .93846 -1.875 0 Mabsadd m
.24664 .93846 0 2.5 Mabsadd L
.24664 .93846 1.875 0 Mabsadd L
.24664 .93846 0 -2.5 Mabsadd L
.24664 .93846 -1.875 0 Mabsadd L closepath F
.24969 .96263 -1.875 0 Mabsadd m
.24969 .96263 0 2.5 Mabsadd L
.24969 .96263 1.875 0 Mabsadd L
.24969 .96263 0 -2.5 Mabsadd L
.24969 .96263 -1.875 0 Mabsadd L closepath F
.25275 .80366 -1.875 0 Mabsadd m
.25275 .80366 0 2.5 Mabsadd L
.25275 .80366 1.875 0 Mabsadd L
.25275 .80366 0 -2.5 Mabsadd L
.25275 .80366 -1.875 0 Mabsadd L closepath F
.2558 .52449 -1.875 0 Mabsadd m
.2558 .52449 0 2.5 Mabsadd L
.2558 .52449 1.875 0 Mabsadd L
.2558 .52449 0 -2.5 Mabsadd L
.2558 .52449 -1.875 0 Mabsadd L closepath F
.25885 .23562 -1.875 0 Mabsadd m
.25885 .23562 0 2.5 Mabsadd L
.25885 .23562 1.875 0 Mabsadd L
.25885 .23562 0 -2.5 Mabsadd L
.25885 .23562 -1.875 0 Mabsadd L closepath F
.2619 .05141 -1.875 0 Mabsadd m
.2619 .05141 0 2.5 Mabsadd L
.2619 .05141 1.875 0 Mabsadd L
.2619 .05141 0 -2.5 Mabsadd L
.2619 .05141 -1.875 0 Mabsadd L closepath F
.26496 .04478 -1.875 0 Mabsadd m
.26496 .04478 0 2.5 Mabsadd L
.26496 .04478 1.875 0 Mabsadd L
.26496 .04478 0 -2.5 Mabsadd L
.26496 .04478 -1.875 0 Mabsadd L closepath F
.26801 .21835 -1.875 0 Mabsadd m
.26801 .21835 0 2.5 Mabsadd L
.26801 .21835 1.875 0 Mabsadd L
.26801 .21835 0 -2.5 Mabsadd L
.26801 .21835 -1.875 0 Mabsadd L closepath F
.27106 .50342 -1.875 0 Mabsadd m
.27106 .50342 0 2.5 Mabsadd L
.27106 .50342 1.875 0 Mabsadd L
.27106 .50342 0 -2.5 Mabsadd L
.27106 .50342 -1.875 0 Mabsadd L closepath F
.27411 .78713 -1.875 0 Mabsadd m
.27411 .78713 0 2.5 Mabsadd L
.27411 .78713 1.875 0 Mabsadd L
.27411 .78713 0 -2.5 Mabsadd L
.27411 .78713 -1.875 0 Mabsadd L closepath F
.27717 .95718 -1.875 0 Mabsadd m
.27717 .95718 0 2.5 Mabsadd L
.27717 .95718 1.875 0 Mabsadd L
.27717 .95718 0 -2.5 Mabsadd L
.27717 .95718 -1.875 0 Mabsadd L closepath F
.28022 .94625 -1.875 0 Mabsadd m
.28022 .94625 0 2.5 Mabsadd L
.28022 .94625 1.875 0 Mabsadd L
.28022 .94625 0 -2.5 Mabsadd L
.28022 .94625 -1.875 0 Mabsadd L closepath F
.28327 .75867 -1.875 0 Mabsadd m
.28327 .75867 0 2.5 Mabsadd L
.28327 .75867 1.875 0 Mabsadd L
.28327 .75867 0 -2.5 Mabsadd L
.28327 .75867 -1.875 0 Mabsadd L closepath F
.28632 .46869 -1.875 0 Mabsadd m
.28632 .46869 0 2.5 Mabsadd L
.28632 .46869 1.875 0 Mabsadd L
.28632 .46869 0 -2.5 Mabsadd L
.28632 .46869 -1.875 0 Mabsadd L closepath F
.28938 .19111 -1.875 0 Mabsadd m
.28938 .19111 0 2.5 Mabsadd L
.28938 .19111 1.875 0 Mabsadd L
.28938 .19111 0 -2.5 Mabsadd L
.28938 .19111 -1.875 0 Mabsadd L closepath F
.29243 .0358 -1.875 0 Mabsadd m
.29243 .0358 0 2.5 Mabsadd L
.29243 .0358 1.875 0 Mabsadd L
.29243 .0358 0 -2.5 Mabsadd L
.29243 .0358 -1.875 0 Mabsadd L closepath F
.29548 .06426 -1.875 0 Mabsadd m
.29548 .06426 0 2.5 Mabsadd L
.29548 .06426 1.875 0 Mabsadd L
.29548 .06426 0 -2.5 Mabsadd L
.29548 .06426 -1.875 0 Mabsadd L closepath F
.29853 .2652 -1.875 0 Mabsadd m
.29853 .2652 0 2.5 Mabsadd L
.29853 .2652 1.875 0 Mabsadd L
.29853 .2652 0 -2.5 Mabsadd L
.29853 .2652 -1.875 0 Mabsadd L closepath F
.30159 .5591 -1.875 0 Mabsadd m
.30159 .5591 0 2.5 Mabsadd L
.30159 .5591 1.875 0 Mabsadd L
.30159 .5591 0 -2.5 Mabsadd L
.30159 .5591 -1.875 0 Mabsadd L closepath F
.30464 .8296 -1.875 0 Mabsadd m
.30464 .8296 0 2.5 Mabsadd L
.30464 .8296 1.875 0 Mabsadd L
.30464 .8296 0 -2.5 Mabsadd L
.30464 .8296 -1.875 0 Mabsadd L closepath F
.30769 .96963 -1.875 0 Mabsadd m
.30769 .96963 0 2.5 Mabsadd L
.30769 .96963 1.875 0 Mabsadd L
.30769 .96963 0 -2.5 Mabsadd L
.30769 .96963 -1.875 0 Mabsadd L closepath F
.31074 .92375 -1.875 0 Mabsadd m
.31074 .92375 0 2.5 Mabsadd L
.31074 .92375 1.875 0 Mabsadd L
.31074 .92375 0 -2.5 Mabsadd L
.31074 .92375 -1.875 0 Mabsadd L closepath F
.3138 .71013 -1.875 0 Mabsadd m
.3138 .71013 0 2.5 Mabsadd L
.3138 .71013 1.875 0 Mabsadd L
.3138 .71013 0 -2.5 Mabsadd L
.3138 .71013 -1.875 0 Mabsadd L closepath F
.31685 .41333 -1.875 0 Mabsadd m
.31685 .41333 0 2.5 Mabsadd L
.31685 .41333 1.875 0 Mabsadd L
.31685 .41333 0 -2.5 Mabsadd L
.31685 .41333 -1.875 0 Mabsadd L closepath F
.3199 .15084 -1.875 0 Mabsadd m
.3199 .15084 0 2.5 Mabsadd L
.3199 .15084 1.875 0 Mabsadd L
.3199 .15084 0 -2.5 Mabsadd L
.3199 .15084 -1.875 0 Mabsadd L closepath F
.32295 .02657 -1.875 0 Mabsadd m
.32295 .02657 0 2.5 Mabsadd L
.32295 .02657 1.875 0 Mabsadd L
.32295 .02657 0 -2.5 Mabsadd L
.32295 .02657 -1.875 0 Mabsadd L closepath F
.32601 .08971 -1.875 0 Mabsadd m
.32601 .08971 0 2.5 Mabsadd L
.32601 .08971 1.875 0 Mabsadd L
.32601 .08971 0 -2.5 Mabsadd L
.32601 .08971 -1.875 0 Mabsadd L closepath F
.32906 .31527 -1.875 0 Mabsadd m
.32906 .31527 0 2.5 Mabsadd L
.32906 .31527 1.875 0 Mabsadd L
.32906 .31527 0 -2.5 Mabsadd L
.32906 .31527 -1.875 0 Mabsadd L closepath F
.33211 .61396 -1.875 0 Mabsadd m
.33211 .61396 0 2.5 Mabsadd L
.33211 .61396 1.875 0 Mabsadd L
.33211 .61396 0 -2.5 Mabsadd L
.33211 .61396 -1.875 0 Mabsadd L closepath F
.33516 .86754 -1.875 0 Mabsadd m
.33516 .86754 0 2.5 Mabsadd L
.33516 .86754 1.875 0 Mabsadd L
.33516 .86754 0 -2.5 Mabsadd L
.33516 .86754 -1.875 0 Mabsadd L closepath F
.33822 .97562 -1.875 0 Mabsadd m
.33822 .97562 0 2.5 Mabsadd L
.33822 .97562 1.875 0 Mabsadd L
.33822 .97562 0 -2.5 Mabsadd L
.33822 .97562 -1.875 0 Mabsadd L closepath F
.34127 .89543 -1.875 0 Mabsadd m
.34127 .89543 0 2.5 Mabsadd L
.34127 .89543 1.875 0 Mabsadd L
.34127 .89543 0 -2.5 Mabsadd L
.34127 .89543 -1.875 0 Mabsadd L closepath F
.34432 .6587 -1.875 0 Mabsadd m
.34432 .6587 0 2.5 Mabsadd L
.34432 .6587 1.875 0 Mabsadd L
.34432 .6587 0 -2.5 Mabsadd L
.34432 .6587 -1.875 0 Mabsadd L closepath F
.34737 .35915 -1.875 0 Mabsadd m
.34737 .35915 0 2.5 Mabsadd L
.34737 .35915 1.875 0 Mabsadd L
.34737 .35915 0 -2.5 Mabsadd L
.34737 .35915 -1.875 0 Mabsadd L closepath F
.35043 .11536 -1.875 0 Mabsadd m
.35043 .11536 0 2.5 Mabsadd L
.35043 .11536 1.875 0 Mabsadd L
.35043 .11536 0 -2.5 Mabsadd L
.35043 .11536 -1.875 0 Mabsadd L closepath F
.35348 .02383 -1.875 0 Mabsadd m
.35348 .02383 0 2.5 Mabsadd L
.35348 .02383 1.875 0 Mabsadd L
.35348 .02383 0 -2.5 Mabsadd L
.35348 .02383 -1.875 0 Mabsadd L closepath F
.35653 .1208 -1.875 0 Mabsadd m
.35653 .1208 0 2.5 Mabsadd L
.35653 .1208 1.875 0 Mabsadd L
.35653 .1208 0 -2.5 Mabsadd L
.35653 .1208 -1.875 0 Mabsadd L closepath F
.35958 .36788 -1.875 0 Mabsadd m
.35958 .36788 0 2.5 Mabsadd L
.35958 .36788 1.875 0 Mabsadd L
.35958 .36788 0 -2.5 Mabsadd L
.35958 .36788 -1.875 0 Mabsadd L closepath F
.36264 .66726 -1.875 0 Mabsadd m
.36264 .66726 0 2.5 Mabsadd L
.36264 .66726 1.875 0 Mabsadd L
.36264 .66726 0 -2.5 Mabsadd L
.36264 .66726 -1.875 0 Mabsadd L closepath F
.36569 .90043 -1.875 0 Mabsadd m
.36569 .90043 0 2.5 Mabsadd L
.36569 .90043 1.875 0 Mabsadd L
.36569 .90043 0 -2.5 Mabsadd L
.36569 .90043 -1.875 0 Mabsadd L closepath F
.36874 .97509 -1.875 0 Mabsadd m
.36874 .97509 0 2.5 Mabsadd L
.36874 .97509 1.875 0 Mabsadd L
.36874 .97509 0 -2.5 Mabsadd L
.36874 .97509 -1.875 0 Mabsadd L closepath F
.37179 .86168 -1.875 0 Mabsadd m
.37179 .86168 0 2.5 Mabsadd L
.37179 .86168 1.875 0 Mabsadd L
.37179 .86168 0 -2.5 Mabsadd L
.37179 .86168 -1.875 0 Mabsadd L closepath F
.37485 .60509 -1.875 0 Mabsadd m
.37485 .60509 0 2.5 Mabsadd L
.37485 .60509 1.875 0 Mabsadd L
.37485 .60509 0 -2.5 Mabsadd L
.37485 .60509 -1.875 0 Mabsadd L closepath F
.3779 .30691 -1.875 0 Mabsadd m
.3779 .30691 0 2.5 Mabsadd L
.3779 .30691 1.875 0 Mabsadd L
.3779 .30691 0 -2.5 Mabsadd L
.3779 .30691 -1.875 0 Mabsadd L closepath F
.38095 .08516 -1.875 0 Mabsadd m
.38095 .08516 0 2.5 Mabsadd L
.38095 .08516 1.875 0 Mabsadd L
.38095 .08516 0 -2.5 Mabsadd L
.38095 .08516 -1.875 0 Mabsadd L closepath F
.384 .02763 -1.875 0 Mabsadd m
.384 .02763 0 2.5 Mabsadd L
.384 .02763 1.875 0 Mabsadd L
.384 .02763 0 -2.5 Mabsadd L
.384 .02763 -1.875 0 Mabsadd L closepath F
.38706 .1571 -1.875 0 Mabsadd m
.38706 .1571 0 2.5 Mabsadd L
.38706 .1571 1.875 0 Mabsadd L
.38706 .1571 0 -2.5 Mabsadd L
.38706 .1571 -1.875 0 Mabsadd L closepath F
.39011 .4223 -1.875 0 Mabsadd m
.39011 .4223 0 2.5 Mabsadd L
.39011 .4223 1.875 0 Mabsadd L
.39011 .4223 0 -2.5 Mabsadd L
.39011 .4223 -1.875 0 Mabsadd L closepath F
.39316 .71827 -1.875 0 Mabsadd m
.39316 .71827 0 2.5 Mabsadd L
.39316 .71827 1.875 0 Mabsadd L
.39316 .71827 0 -2.5 Mabsadd L
.39316 .71827 -1.875 0 Mabsadd L closepath F
.39621 .92783 -1.875 0 Mabsadd m
.39621 .92783 0 2.5 Mabsadd L
.39621 .92783 1.875 0 Mabsadd L
.39621 .92783 0 -2.5 Mabsadd L
.39621 .92783 -1.875 0 Mabsadd L closepath F
.39927 .96803 -1.875 0 Mabsadd m
.39927 .96803 0 2.5 Mabsadd L
.39927 .96803 1.875 0 Mabsadd L
.39927 .96803 0 -2.5 Mabsadd L
.39927 .96803 -1.875 0 Mabsadd L closepath F
.40232 .82296 -1.875 0 Mabsadd m
.40232 .82296 0 2.5 Mabsadd L
.40232 .82296 1.875 0 Mabsadd L
.40232 .82296 0 -2.5 Mabsadd L
.40232 .82296 -1.875 0 Mabsadd L closepath F
.40537 .55004 -1.875 0 Mabsadd m
.40537 .55004 0 2.5 Mabsadd L
.40537 .55004 1.875 0 Mabsadd L
.40537 .55004 0 -2.5 Mabsadd L
.40537 .55004 -1.875 0 Mabsadd L closepath F
.40842 .25732 -1.875 0 Mabsadd m
.40842 .25732 0 2.5 Mabsadd L
.40842 .25732 1.875 0 Mabsadd L
.40842 .25732 0 -2.5 Mabsadd L
.40842 .25732 -1.875 0 Mabsadd L closepath F
.41148 .06066 -1.875 0 Mabsadd m
.41148 .06066 0 2.5 Mabsadd L
.41148 .06066 1.875 0 Mabsadd L
.41148 .06066 0 -2.5 Mabsadd L
.41148 .06066 -1.875 0 Mabsadd L closepath F
.41453 .03792 -1.875 0 Mabsadd m
.41453 .03792 0 2.5 Mabsadd L
.41453 .03792 1.875 0 Mabsadd L
.41453 .03792 0 -2.5 Mabsadd L
.41453 .03792 -1.875 0 Mabsadd L closepath F
.41758 .1981 -1.875 0 Mabsadd m
.41758 .1981 0 2.5 Mabsadd L
.41758 .1981 1.875 0 Mabsadd L
.41758 .1981 0 -2.5 Mabsadd L
.41758 .1981 -1.875 0 Mabsadd L closepath F
.42063 .47779 -1.875 0 Mabsadd m
.42063 .47779 0 2.5 Mabsadd L
.42063 .47779 1.875 0 Mabsadd L
.42063 .47779 0 -2.5 Mabsadd L
.42063 .47779 -1.875 0 Mabsadd L closepath F
.42369 .76628 -1.875 0 Mabsadd m
.42369 .76628 0 2.5 Mabsadd L
.42369 .76628 1.875 0 Mabsadd L
.42369 .76628 0 -2.5 Mabsadd L
.42369 .76628 -1.875 0 Mabsadd L closepath F
.42674 .94935 -1.875 0 Mabsadd m
.42674 .94935 0 2.5 Mabsadd L
.42674 .94935 1.875 0 Mabsadd L
.42674 .94935 0 -2.5 Mabsadd L
.42674 .94935 -1.875 0 Mabsadd L closepath F
.42979 .95455 -1.875 0 Mabsadd m
.42979 .95455 0 2.5 Mabsadd L
.42979 .95455 1.875 0 Mabsadd L
.42979 .95455 0 -2.5 Mabsadd L
.42979 .95455 -1.875 0 Mabsadd L closepath F
.43284 .77981 -1.875 0 Mabsadd m
.43284 .77981 0 2.5 Mabsadd L
.43284 .77981 1.875 0 Mabsadd L
.43284 .77981 0 -2.5 Mabsadd L
.43284 .77981 -1.875 0 Mabsadd L closepath F
.4359 .49431 -1.875 0 Mabsadd m
.4359 .49431 0 2.5 Mabsadd L
.4359 .49431 1.875 0 Mabsadd L
.4359 .49431 0 -2.5 Mabsadd L
.4359 .49431 -1.875 0 Mabsadd L closepath F
.43895 .21106 -1.875 0 Mabsadd m
.43895 .21106 0 2.5 Mabsadd L
.43895 .21106 1.875 0 Mabsadd L
.43895 .21106 0 -2.5 Mabsadd L
.43895 .21106 -1.875 0 Mabsadd L closepath F
.442 .04219 -1.875 0 Mabsadd m
.442 .04219 0 2.5 Mabsadd L
.442 .04219 1.875 0 Mabsadd L
.442 .04219 0 -2.5 Mabsadd L
.442 .04219 -1.875 0 Mabsadd L closepath F
.44505 .05455 -1.875 0 Mabsadd m
.44505 .05455 0 2.5 Mabsadd L
.44505 .05455 1.875 0 Mabsadd L
.44505 .05455 0 -2.5 Mabsadd L
.44505 .05455 -1.875 0 Mabsadd L closepath F
.44811 .24325 -1.875 0 Mabsadd m
.44811 .24325 0 2.5 Mabsadd L
.44811 .24325 1.875 0 Mabsadd L
.44811 .24325 0 -2.5 Mabsadd L
.44811 .24325 -1.875 0 Mabsadd L closepath F
.45116 .53359 -1.875 0 Mabsadd m
.45116 .53359 0 2.5 Mabsadd L
.45116 .53359 1.875 0 Mabsadd L
.45116 .53359 0 -2.5 Mabsadd L
.45116 .53359 -1.875 0 Mabsadd L closepath F
.45421 .81063 -1.875 0 Mabsadd m
.45421 .81063 0 2.5 Mabsadd L
.45421 .81063 1.875 0 Mabsadd L
.45421 .81063 0 -2.5 Mabsadd L
.45421 .81063 -1.875 0 Mabsadd L closepath F
.45726 .96471 -1.875 0 Mabsadd m
.45726 .96471 0 2.5 Mabsadd L
.45726 .96471 1.875 0 Mabsadd L
.45726 .96471 0 -2.5 Mabsadd L
.45726 .96471 -1.875 0 Mabsadd L closepath F
.46032 .93483 -1.875 0 Mabsadd m
.46032 .93483 0 2.5 Mabsadd L
.46032 .93483 1.875 0 Mabsadd L
.46032 .93483 0 -2.5 Mabsadd L
.46032 .93483 -1.875 0 Mabsadd L closepath F
.46337 .73282 -1.875 0 Mabsadd m
.46337 .73282 0 2.5 Mabsadd L
.46337 .73282 1.875 0 Mabsadd L
.46337 .73282 0 -2.5 Mabsadd L
.46337 .73282 -1.875 0 Mabsadd L closepath F
.46642 .43865 -1.875 0 Mabsadd m
.46642 .43865 0 2.5 Mabsadd L
.46642 .43865 1.875 0 Mabsadd L
.46642 .43865 0 -2.5 Mabsadd L
.46642 .43865 -1.875 0 Mabsadd L closepath F
.46947 .16877 -1.875 0 Mabsadd m
.46947 .16877 0 2.5 Mabsadd L
.46947 .16877 1.875 0 Mabsadd L
.46947 .16877 0 -2.5 Mabsadd L
.46947 .16877 -1.875 0 Mabsadd L closepath F
.47253 .03001 -1.875 0 Mabsadd m
.47253 .03001 0 2.5 Mabsadd L
.47253 .03001 1.875 0 Mabsadd L
.47253 .03001 0 -2.5 Mabsadd L
.47253 .03001 -1.875 0 Mabsadd L closepath F
.47558 .0773 -1.875 0 Mabsadd m
.47558 .0773 0 2.5 Mabsadd L
.47558 .0773 1.875 0 Mabsadd L
.47558 .0773 0 -2.5 Mabsadd L
.47558 .0773 -1.875 0 Mabsadd L closepath F
.47863 .29192 -1.875 0 Mabsadd m
.47863 .29192 0 2.5 Mabsadd L
.47863 .29192 1.875 0 Mabsadd L
.47863 .29192 0 -2.5 Mabsadd L
.47863 .29192 -1.875 0 Mabsadd L closepath F
.48168 .58892 -1.875 0 Mabsadd m
.48168 .58892 0 2.5 Mabsadd L
.48168 .58892 1.875 0 Mabsadd L
.48168 .58892 0 -2.5 Mabsadd L
.48168 .58892 -1.875 0 Mabsadd L closepath F
.48474 .85071 -1.875 0 Mabsadd m
.48474 .85071 0 2.5 Mabsadd L
.48474 .85071 1.875 0 Mabsadd L
.48474 .85071 0 -2.5 Mabsadd L
.48474 .85071 -1.875 0 Mabsadd L closepath F
.48779 .97368 -1.875 0 Mabsadd m
.48779 .97368 0 2.5 Mabsadd L
.48779 .97368 1.875 0 Mabsadd L
.48779 .97368 0 -2.5 Mabsadd L
.48779 .97368 -1.875 0 Mabsadd L closepath F
.49084 .90913 -1.875 0 Mabsadd m
.49084 .90913 0 2.5 Mabsadd L
.49084 .90913 1.875 0 Mabsadd L
.49084 .90913 0 -2.5 Mabsadd L
.49084 .90913 -1.875 0 Mabsadd L closepath F
.49389 .68263 -1.875 0 Mabsadd m
.49389 .68263 0 2.5 Mabsadd L
.49389 .68263 1.875 0 Mabsadd L
.49389 .68263 0 -2.5 Mabsadd L
.49389 .68263 -1.875 0 Mabsadd L closepath F
.49695 .38383 -1.875 0 Mabsadd m
.49695 .38383 0 2.5 Mabsadd L
.49695 .38383 1.875 0 Mabsadd L
.49695 .38383 0 -2.5 Mabsadd L
.49695 .38383 -1.875 0 Mabsadd L closepath F
.5 .13102 -1.875 0 Mabsadd m
.5 .13102 0 2.5 Mabsadd L
.5 .13102 1.875 0 Mabsadd L
.5 .13102 0 -2.5 Mabsadd L
.5 .13102 -1.875 0 Mabsadd L closepath F
.50305 .02428 -1.875 0 Mabsadd m
.50305 .02428 0 2.5 Mabsadd L
.50305 .02428 1.875 0 Mabsadd L
.50305 .02428 0 -2.5 Mabsadd L
.50305 .02428 -1.875 0 Mabsadd L closepath F
.50611 .10585 -1.875 0 Mabsadd m
.50611 .10585 0 2.5 Mabsadd L
.50611 .10585 1.875 0 Mabsadd L
.50611 .10585 0 -2.5 Mabsadd L
.50611 .10585 -1.875 0 Mabsadd L closepath F
.50916 .34346 -1.875 0 Mabsadd m
.50916 .34346 0 2.5 Mabsadd L
.50916 .34346 1.875 0 Mabsadd L
.50916 .34346 0 -2.5 Mabsadd L
.50916 .34346 -1.875 0 Mabsadd L closepath F
.51221 .64303 -1.875 0 Mabsadd m
.51221 .64303 0 2.5 Mabsadd L
.51221 .64303 1.875 0 Mabsadd L
.51221 .64303 0 -2.5 Mabsadd L
.51221 .64303 -1.875 0 Mabsadd L closepath F
.51526 .88599 -1.875 0 Mabsadd m
.51526 .88599 0 2.5 Mabsadd L
.51526 .88599 1.875 0 Mabsadd L
.51526 .88599 0 -2.5 Mabsadd L
.51526 .88599 -1.875 0 Mabsadd L closepath F
.51832 .97615 -1.875 0 Mabsadd m
.51832 .97615 0 2.5 Mabsadd L
.51832 .97615 1.875 0 Mabsadd L
.51832 .97615 0 -2.5 Mabsadd L
.51832 .97615 -1.875 0 Mabsadd L closepath F
.52137 .87782 -1.875 0 Mabsadd m
.52137 .87782 0 2.5 Mabsadd L
.52137 .87782 1.875 0 Mabsadd L
.52137 .87782 0 -2.5 Mabsadd L
.52137 .87782 -1.875 0 Mabsadd L closepath F
.52442 .62993 -1.875 0 Mabsadd m
.52442 .62993 0 2.5 Mabsadd L
.52442 .62993 1.875 0 Mabsadd L
.52442 .62993 0 -2.5 Mabsadd L
.52442 .62993 -1.875 0 Mabsadd L closepath F
.52747 .33061 -1.875 0 Mabsadd m
.52747 .33061 0 2.5 Mabsadd L
.52747 .33061 1.875 0 Mabsadd L
.52747 .33061 0 -2.5 Mabsadd L
.52747 .33061 -1.875 0 Mabsadd L closepath F
.53053 .09834 -1.875 0 Mabsadd m
.53053 .09834 0 2.5 Mabsadd L
.53053 .09834 1.875 0 Mabsadd L
.53053 .09834 0 -2.5 Mabsadd L
.53053 .09834 -1.875 0 Mabsadd L closepath F
.53358 .02508 -1.875 0 Mabsadd m
.53358 .02508 0 2.5 Mabsadd L
.53358 .02508 1.875 0 Mabsadd L
.53358 .02508 0 -2.5 Mabsadd L
.53358 .02508 -1.875 0 Mabsadd L closepath F
.53663 .13981 -1.875 0 Mabsadd m
.53663 .13981 0 2.5 Mabsadd L
.53663 .13981 1.875 0 Mabsadd L
.53663 .13981 0 -2.5 Mabsadd L
.53663 .13981 -1.875 0 Mabsadd L closepath F
.53968 .39714 -1.875 0 Mabsadd m
.53968 .39714 0 2.5 Mabsadd L
.53968 .39714 1.875 0 Mabsadd L
.53968 .39714 0 -2.5 Mabsadd L
.53968 .39714 -1.875 0 Mabsadd L closepath F
.54274 .69518 -1.875 0 Mabsadd m
.54274 .69518 0 2.5 Mabsadd L
.54274 .69518 1.875 0 Mabsadd L
.54274 .69518 0 -2.5 Mabsadd L
.54274 .69518 -1.875 0 Mabsadd L closepath F
.54579 .91596 -1.875 0 Mabsadd m
.54579 .91596 0 2.5 Mabsadd L
.54579 .91596 1.875 0 Mabsadd L
.54579 .91596 0 -2.5 Mabsadd L
.54579 .91596 -1.875 0 Mabsadd L closepath F
.54884 .97208 -1.875 0 Mabsadd m
.54884 .97208 0 2.5 Mabsadd L
.54884 .97208 1.875 0 Mabsadd L
.54884 .97208 0 -2.5 Mabsadd L
.54884 .97208 -1.875 0 Mabsadd L closepath F
.55189 .84132 -1.875 0 Mabsadd m
.55189 .84132 0 2.5 Mabsadd L
.55189 .84132 1.875 0 Mabsadd L
.55189 .84132 0 -2.5 Mabsadd L
.55189 .84132 -1.875 0 Mabsadd L closepath F
.55495 .57545 -1.875 0 Mabsadd m
.55495 .57545 0 2.5 Mabsadd L
.55495 .57545 1.875 0 Mabsadd L
.55495 .57545 0 -2.5 Mabsadd L
.55495 .57545 -1.875 0 Mabsadd L closepath F
.558 .27971 -1.875 0 Mabsadd m
.558 .27971 0 2.5 Mabsadd L
.558 .27971 1.875 0 Mabsadd L
.558 .27971 0 -2.5 Mabsadd L
.558 .27971 -1.875 0 Mabsadd L closepath F
.56105 .07118 -1.875 0 Mabsadd m
.56105 .07118 0 2.5 Mabsadd L
.56105 .07118 1.875 0 Mabsadd L
.56105 .07118 0 -2.5 Mabsadd L
.56105 .07118 -1.875 0 Mabsadd L closepath F
.5641 .0324 -1.875 0 Mabsadd m
.5641 .0324 0 2.5 Mabsadd L
.5641 .0324 1.875 0 Mabsadd L
.5641 .0324 0 -2.5 Mabsadd L
.5641 .0324 -1.875 0 Mabsadd L closepath F
.56716 .17872 -1.875 0 Mabsadd m
.56716 .17872 0 2.5 Mabsadd L
.56716 .17872 1.875 0 Mabsadd L
.56716 .17872 0 -2.5 Mabsadd L
.56716 .17872 -1.875 0 Mabsadd L closepath F
.57021 .45223 -1.875 0 Mabsadd m
.57021 .45223 0 2.5 Mabsadd L
.57021 .45223 1.875 0 Mabsadd L
.57021 .45223 0 -2.5 Mabsadd L
.57021 .45223 -1.875 0 Mabsadd L closepath F
.57326 .74465 -1.875 0 Mabsadd m
.57326 .74465 0 2.5 Mabsadd L
.57326 .74465 1.875 0 Mabsadd L
.57326 .74465 0 -2.5 Mabsadd L
.57326 .74465 -1.875 0 Mabsadd L closepath F
.57631 .94022 -1.875 0 Mabsadd m
.57631 .94022 0 2.5 Mabsadd L
.57631 .94022 1.875 0 Mabsadd L
.57631 .94022 0 -2.5 Mabsadd L
.57631 .94022 -1.875 0 Mabsadd L closepath F
.57937 .96153 -1.875 0 Mabsadd m
.57937 .96153 0 2.5 Mabsadd L
.57937 .96153 1.875 0 Mabsadd L
.57937 .96153 0 -2.5 Mabsadd L
.57937 .96153 -1.875 0 Mabsadd L closepath F
.58242 .80014 -1.875 0 Mabsadd m
.58242 .80014 0 2.5 Mabsadd L
.58242 .80014 1.875 0 Mabsadd L
.58242 .80014 0 -2.5 Mabsadd L
.58242 .80014 -1.875 0 Mabsadd L closepath F
.58547 .51994 -1.875 0 Mabsadd m
.58547 .51994 0 2.5 Mabsadd L
.58547 .51994 1.875 0 Mabsadd L
.58547 .51994 0 -2.5 Mabsadd L
.58547 .51994 -1.875 0 Mabsadd L closepath F
.58852 .23184 -1.875 0 Mabsadd m
.58852 .23184 0 2.5 Mabsadd L
.58852 .23184 1.875 0 Mabsadd L
.58852 .23184 0 -2.5 Mabsadd L
.58852 .23184 -1.875 0 Mabsadd L closepath F
.59158 .0499 -1.875 0 Mabsadd m
.59158 .0499 0 2.5 Mabsadd L
.59158 .0499 1.875 0 Mabsadd L
.59158 .0499 0 -2.5 Mabsadd L
.59158 .0499 -1.875 0 Mabsadd L closepath F
.59463 .04614 -1.875 0 Mabsadd m
.59463 .04614 0 2.5 Mabsadd L
.59463 .04614 1.875 0 Mabsadd L
.59463 .04614 0 -2.5 Mabsadd L
.59463 .04614 -1.875 0 Mabsadd L closepath F
.59768 .22204 -1.875 0 Mabsadd m
.59768 .22204 0 2.5 Mabsadd L
.59768 .22204 1.875 0 Mabsadd L
.59768 .22204 0 -2.5 Mabsadd L
.59768 .22204 -1.875 0 Mabsadd L closepath F
.60073 .50798 -1.875 0 Mabsadd m
.60073 .50798 0 2.5 Mabsadd L
.60073 .50798 1.875 0 Mabsadd L
.60073 .50798 0 -2.5 Mabsadd L
.60073 .50798 -1.875 0 Mabsadd L closepath F
.60379 .79076 -1.875 0 Mabsadd m
.60379 .79076 0 2.5 Mabsadd L
.60379 .79076 1.875 0 Mabsadd L
.60379 .79076 0 -2.5 Mabsadd L
.60379 .79076 -1.875 0 Mabsadd L closepath F
.60684 .95844 -1.875 0 Mabsadd m
.60684 .95844 0 2.5 Mabsadd L
.60684 .95844 1.875 0 Mabsadd L
.60684 .95844 0 -2.5 Mabsadd L
.60684 .95844 -1.875 0 Mabsadd L closepath F
.60989 .94464 -1.875 0 Mabsadd m
.60989 .94464 0 2.5 Mabsadd L
.60989 .94464 1.875 0 Mabsadd L
.60989 .94464 0 -2.5 Mabsadd L
.60989 .94464 -1.875 0 Mabsadd L closepath F
.61294 .75483 -1.875 0 Mabsadd m
.61294 .75483 0 2.5 Mabsadd L
.61294 .75483 1.875 0 Mabsadd L
.61294 .75483 0 -2.5 Mabsadd L
.61294 .75483 -1.875 0 Mabsadd L closepath F
.616 .46415 -1.875 0 Mabsadd m
.616 .46415 0 2.5 Mabsadd L
.616 .46415 1.875 0 Mabsadd L
.616 .46415 0 -2.5 Mabsadd L
.616 .46415 -1.875 0 Mabsadd L closepath F
.61905 .18765 -1.875 0 Mabsadd m
.61905 .18765 0 2.5 Mabsadd L
.61905 .18765 1.875 0 Mabsadd L
.61905 .18765 0 -2.5 Mabsadd L
.61905 .18765 -1.875 0 Mabsadd L closepath F
.6221 .03481 -1.875 0 Mabsadd m
.6221 .03481 0 2.5 Mabsadd L
.6221 .03481 1.875 0 Mabsadd L
.6221 .03481 0 -2.5 Mabsadd L
.6221 .03481 -1.875 0 Mabsadd L closepath F
.62515 .06611 -1.875 0 Mabsadd m
.62515 .06611 0 2.5 Mabsadd L
.62515 .06611 1.875 0 Mabsadd L
.62515 .06611 0 -2.5 Mabsadd L
.62515 .06611 -1.875 0 Mabsadd L closepath F
.62821 .26918 -1.875 0 Mabsadd m
.62821 .26918 0 2.5 Mabsadd L
.62821 .26918 1.875 0 Mabsadd L
.62821 .26918 0 -2.5 Mabsadd L
.62821 .26918 -1.875 0 Mabsadd L closepath F
.63126 .56362 -1.875 0 Mabsadd m
.63126 .56362 0 2.5 Mabsadd L
.63126 .56362 1.875 0 Mabsadd L
.63126 .56362 0 -2.5 Mabsadd L
.63126 .56362 -1.875 0 Mabsadd L closepath F
.63431 .83287 -1.875 0 Mabsadd m
.63431 .83287 0 2.5 Mabsadd L
.63431 .83287 1.875 0 Mabsadd L
.63431 .83287 0 -2.5 Mabsadd L
.63431 .83287 -1.875 0 Mabsadd L closepath F
.63736 .97036 -1.875 0 Mabsadd m
.63736 .97036 0 2.5 Mabsadd L
.63736 .97036 1.875 0 Mabsadd L
.63736 .97036 0 -2.5 Mabsadd L
.63736 .97036 -1.875 0 Mabsadd L closepath F
.64042 .92165 -1.875 0 Mabsadd m
.64042 .92165 0 2.5 Mabsadd L
.64042 .92165 1.875 0 Mabsadd L
.64042 .92165 0 -2.5 Mabsadd L
.64042 .92165 -1.875 0 Mabsadd L closepath F
.64347 .70603 -1.875 0 Mabsadd m
.64347 .70603 0 2.5 Mabsadd L
.64347 .70603 1.875 0 Mabsadd L
.64347 .70603 0 -2.5 Mabsadd L
.64347 .70603 -1.875 0 Mabsadd L closepath F
.64652 .40885 -1.875 0 Mabsadd m
.64652 .40885 0 2.5 Mabsadd L
.64652 .40885 1.875 0 Mabsadd L
.64652 .40885 0 -2.5 Mabsadd L
.64652 .40885 -1.875 0 Mabsadd L closepath F
.64957 .14775 -1.875 0 Mabsadd m
.64957 .14775 0 2.5 Mabsadd L
.64957 .14775 1.875 0 Mabsadd L
.64957 .14775 0 -2.5 Mabsadd L
.64957 .14775 -1.875 0 Mabsadd L closepath F
.65263 .0261 -1.875 0 Mabsadd m
.65263 .0261 0 2.5 Mabsadd L
.65263 .0261 1.875 0 Mabsadd L
.65263 .0261 0 -2.5 Mabsadd L
.65263 .0261 -1.875 0 Mabsadd L closepath F
.65568 .09204 -1.875 0 Mabsadd m
.65568 .09204 0 2.5 Mabsadd L
.65568 .09204 1.875 0 Mabsadd L
.65568 .09204 0 -2.5 Mabsadd L
.65568 .09204 -1.875 0 Mabsadd L closepath F
.65873 .31948 -1.875 0 Mabsadd m
.65873 .31948 0 2.5 Mabsadd L
.65873 .31948 1.875 0 Mabsadd L
.65873 .31948 0 -2.5 Mabsadd L
.65873 .31948 -1.875 0 Mabsadd L closepath F
.66178 .61838 -1.875 0 Mabsadd m
.66178 .61838 0 2.5 Mabsadd L
.66178 .61838 1.875 0 Mabsadd L
.66178 .61838 0 -2.5 Mabsadd L
.66178 .61838 -1.875 0 Mabsadd L closepath F
.66484 .87042 -1.875 0 Mabsadd m
.66484 .87042 0 2.5 Mabsadd L
.66484 .87042 1.875 0 Mabsadd L
.66484 .87042 0 -2.5 Mabsadd L
.66484 .87042 -1.875 0 Mabsadd L closepath F
.66789 .97582 -1.875 0 Mabsadd m
.66789 .97582 0 2.5 Mabsadd L
.66789 .97582 1.875 0 Mabsadd L
.66789 .97582 0 -2.5 Mabsadd L
.66789 .97582 -1.875 0 Mabsadd L closepath F
.67094 .89287 -1.875 0 Mabsadd m
.67094 .89287 0 2.5 Mabsadd L
.67094 .89287 1.875 0 Mabsadd L
.67094 .89287 0 -2.5 Mabsadd L
.67094 .89287 -1.875 0 Mabsadd L closepath F
.67399 .6544 -1.875 0 Mabsadd m
.67399 .6544 0 2.5 Mabsadd L
.67399 .6544 1.875 0 Mabsadd L
.67399 .6544 0 -2.5 Mabsadd L
.67399 .6544 -1.875 0 Mabsadd L closepath F
.67705 .3548 -1.875 0 Mabsadd m
.67705 .3548 0 2.5 Mabsadd L
.67705 .3548 1.875 0 Mabsadd L
.67705 .3548 0 -2.5 Mabsadd L
.67705 .3548 -1.875 0 Mabsadd L closepath F
.6801 .11269 -1.875 0 Mabsadd m
.6801 .11269 0 2.5 Mabsadd L
.6801 .11269 1.875 0 Mabsadd L
.6801 .11269 0 -2.5 Mabsadd L
.6801 .11269 -1.875 0 Mabsadd L closepath F
.68315 .0239 -1.875 0 Mabsadd m
.68315 .0239 0 2.5 Mabsadd L
.68315 .0239 1.875 0 Mabsadd L
.68315 .0239 0 -2.5 Mabsadd L
.68315 .0239 -1.875 0 Mabsadd L closepath F
.6862 .12358 -1.875 0 Mabsadd m
.6862 .12358 0 2.5 Mabsadd L
.6862 .12358 1.875 0 Mabsadd L
.6862 .12358 0 -2.5 Mabsadd L
.6862 .12358 -1.875 0 Mabsadd L closepath F
.68926 .37227 -1.875 0 Mabsadd m
.68926 .37227 0 2.5 Mabsadd L
.68926 .37227 1.875 0 Mabsadd L
.68926 .37227 0 -2.5 Mabsadd L
.68926 .37227 -1.875 0 Mabsadd L closepath F
.69231 .67152 -1.875 0 Mabsadd m
.69231 .67152 0 2.5 Mabsadd L
.69231 .67152 1.875 0 Mabsadd L
.69231 .67152 0 -2.5 Mabsadd L
.69231 .67152 -1.875 0 Mabsadd L closepath F
.69536 .90288 -1.875 0 Mabsadd m
.69536 .90288 0 2.5 Mabsadd L
.69536 .90288 1.875 0 Mabsadd L
.69536 .90288 0 -2.5 Mabsadd L
.69536 .90288 -1.875 0 Mabsadd L closepath F
.69841 .97476 -1.875 0 Mabsadd m
.69841 .97476 0 2.5 Mabsadd L
.69841 .97476 1.875 0 Mabsadd L
.69841 .97476 0 -2.5 Mabsadd L
.69841 .97476 -1.875 0 Mabsadd L closepath F
.70147 .8587 -1.875 0 Mabsadd m
.70147 .8587 0 2.5 Mabsadd L
.70147 .8587 1.875 0 Mabsadd L
.70147 .8587 0 -2.5 Mabsadd L
.70147 .8587 -1.875 0 Mabsadd L closepath F
.70452 .60064 -1.875 0 Mabsadd m
.70452 .60064 0 2.5 Mabsadd L
.70452 .60064 1.875 0 Mabsadd L
.70452 .60064 0 -2.5 Mabsadd L
.70452 .60064 -1.875 0 Mabsadd L closepath F
.70757 .30275 -1.875 0 Mabsadd m
.70757 .30275 0 2.5 Mabsadd L
.70757 .30275 1.875 0 Mabsadd L
.70757 .30275 0 -2.5 Mabsadd L
.70757 .30275 -1.875 0 Mabsadd L closepath F
.71062 .08294 -1.875 0 Mabsadd m
.71062 .08294 0 2.5 Mabsadd L
.71062 .08294 1.875 0 Mabsadd L
.71062 .08294 0 -2.5 Mabsadd L
.71062 .08294 -1.875 0 Mabsadd L closepath F
.71368 .02823 -1.875 0 Mabsadd m
.71368 .02823 0 2.5 Mabsadd L
.71368 .02823 1.875 0 Mabsadd L
.71368 .02823 0 -2.5 Mabsadd L
.71368 .02823 -1.875 0 Mabsadd L closepath F
.71673 .16028 -1.875 0 Mabsadd m
.71673 .16028 0 2.5 Mabsadd L
.71673 .16028 1.875 0 Mabsadd L
.71673 .16028 0 -2.5 Mabsadd L
.71673 .16028 -1.875 0 Mabsadd L closepath F
.71978 .4268 -1.875 0 Mabsadd m
.71978 .4268 0 2.5 Mabsadd L
.71978 .4268 1.875 0 Mabsadd L
.71978 .4268 0 -2.5 Mabsadd L
.71978 .4268 -1.875 0 Mabsadd L closepath F
.72283 .72231 -1.875 0 Mabsadd m
.72283 .72231 0 2.5 Mabsadd L
.72283 .72231 1.875 0 Mabsadd L
.72283 .72231 0 -2.5 Mabsadd L
.72283 .72231 -1.875 0 Mabsadd L closepath F
.72589 .92981 -1.875 0 Mabsadd m
.72589 .92981 0 2.5 Mabsadd L
.72589 .92981 1.875 0 Mabsadd L
.72589 .92981 0 -2.5 Mabsadd L
.72589 .92981 -1.875 0 Mabsadd L closepath F
.72894 .96717 -1.875 0 Mabsadd m
.72894 .96717 0 2.5 Mabsadd L
.72894 .96717 1.875 0 Mabsadd L
.72894 .96717 0 -2.5 Mabsadd L
.72894 .96717 -1.875 0 Mabsadd L closepath F
.73199 .8196 -1.875 0 Mabsadd m
.73199 .8196 0 2.5 Mabsadd L
.73199 .8196 1.875 0 Mabsadd L
.73199 .8196 0 -2.5 Mabsadd L
.73199 .8196 -1.875 0 Mabsadd L closepath F
.73504 .54551 -1.875 0 Mabsadd m
.73504 .54551 0 2.5 Mabsadd L
.73504 .54551 1.875 0 Mabsadd L
.73504 .54551 0 -2.5 Mabsadd L
.73504 .54551 -1.875 0 Mabsadd L closepath F
.7381 .25341 -1.875 0 Mabsadd m
.7381 .25341 0 2.5 Mabsadd L
.7381 .25341 1.875 0 Mabsadd L
.7381 .25341 0 -2.5 Mabsadd L
.7381 .25341 -1.875 0 Mabsadd L closepath F
.74115 .05892 -1.875 0 Mabsadd m
.74115 .05892 0 2.5 Mabsadd L
.74115 .05892 1.875 0 Mabsadd L
.74115 .05892 0 -2.5 Mabsadd L
.74115 .05892 -1.875 0 Mabsadd L closepath F
.7442 .03904 -1.875 0 Mabsadd m
.7442 .03904 0 2.5 Mabsadd L
.7442 .03904 1.875 0 Mabsadd L
.7442 .03904 0 -2.5 Mabsadd L
.7442 .03904 -1.875 0 Mabsadd L closepath F
.74725 .20164 -1.875 0 Mabsadd m
.74725 .20164 0 2.5 Mabsadd L
.74725 .20164 1.875 0 Mabsadd L
.74725 .20164 0 -2.5 Mabsadd L
.74725 .20164 -1.875 0 Mabsadd L closepath F
.75031 .48235 -1.875 0 Mabsadd m
.75031 .48235 0 2.5 Mabsadd L
.75031 .48235 1.875 0 Mabsadd L
.75031 .48235 0 -2.5 Mabsadd L
.75031 .48235 -1.875 0 Mabsadd L closepath F
.75336 .77004 -1.875 0 Mabsadd m
.75336 .77004 0 2.5 Mabsadd L
.75336 .77004 1.875 0 Mabsadd L
.75336 .77004 0 -2.5 Mabsadd L
.75336 .77004 -1.875 0 Mabsadd L closepath F
.75641 .95084 -1.875 0 Mabsadd m
.75641 .95084 0 2.5 Mabsadd L
.75641 .95084 1.875 0 Mabsadd L
.75641 .95084 0 -2.5 Mabsadd L
.75641 .95084 -1.875 0 Mabsadd L closepath F
.75946 .95317 -1.875 0 Mabsadd m
.75946 .95317 0 2.5 Mabsadd L
.75946 .95317 1.875 0 Mabsadd L
.75946 .95317 0 -2.5 Mabsadd L
.75946 .95317 -1.875 0 Mabsadd L closepath F
.76252 .77611 -1.875 0 Mabsadd m
.76252 .77611 0 2.5 Mabsadd L
.76252 .77611 1.875 0 Mabsadd L
.76252 .77611 0 -2.5 Mabsadd L
.76252 .77611 -1.875 0 Mabsadd L closepath F
.76557 .48975 -1.875 0 Mabsadd m
.76557 .48975 0 2.5 Mabsadd L
.76557 .48975 1.875 0 Mabsadd L
.76557 .48975 0 -2.5 Mabsadd L
.76557 .48975 -1.875 0 Mabsadd L closepath F
.76862 .20745 -1.875 0 Mabsadd m
.76862 .20745 0 2.5 Mabsadd L
.76862 .20745 1.875 0 Mabsadd L
.76862 .20745 0 -2.5 Mabsadd L
.76862 .20745 -1.875 0 Mabsadd L closepath F
.77167 .04096 -1.875 0 Mabsadd m
.77167 .04096 0 2.5 Mabsadd L
.77167 .04096 1.875 0 Mabsadd L
.77167 .04096 0 -2.5 Mabsadd L
.77167 .04096 -1.875 0 Mabsadd L closepath F
.77473 .05618 -1.875 0 Mabsadd m
.77473 .05618 0 2.5 Mabsadd L
.77473 .05618 1.875 0 Mabsadd L
.77473 .05618 0 -2.5 Mabsadd L
.77473 .05618 -1.875 0 Mabsadd L closepath F
.77778 .2471 -1.875 0 Mabsadd m
.77778 .2471 0 2.5 Mabsadd L
.77778 .2471 1.875 0 Mabsadd L
.77778 .2471 0 -2.5 Mabsadd L
.77778 .2471 -1.875 0 Mabsadd L closepath F
.78083 .53813 -1.875 0 Mabsadd m
.78083 .53813 0 2.5 Mabsadd L
.78083 .53813 1.875 0 Mabsadd L
.78083 .53813 0 -2.5 Mabsadd L
.78083 .53813 -1.875 0 Mabsadd L closepath F
.78388 .81407 -1.875 0 Mabsadd m
.78388 .81407 0 2.5 Mabsadd L
.78388 .81407 1.875 0 Mabsadd L
.78388 .81407 0 -2.5 Mabsadd L
.78388 .81407 -1.875 0 Mabsadd L closepath F
.78694 .96568 -1.875 0 Mabsadd m
.78694 .96568 0 2.5 Mabsadd L
.78694 .96568 1.875 0 Mabsadd L
.78694 .96568 0 -2.5 Mabsadd L
.78694 .96568 -1.875 0 Mabsadd L closepath F
.78999 .93295 -1.875 0 Mabsadd m
.78999 .93295 0 2.5 Mabsadd L
.78999 .93295 1.875 0 Mabsadd L
.78999 .93295 0 -2.5 Mabsadd L
.78999 .93295 -1.875 0 Mabsadd L closepath F
.79304 .72883 -1.875 0 Mabsadd m
.79304 .72883 0 2.5 Mabsadd L
.79304 .72883 1.875 0 Mabsadd L
.79304 .72883 0 -2.5 Mabsadd L
.79304 .72883 -1.875 0 Mabsadd L closepath F
.79609 .43413 -1.875 0 Mabsadd m
.79609 .43413 0 2.5 Mabsadd L
.79609 .43413 1.875 0 Mabsadd L
.79609 .43413 0 -2.5 Mabsadd L
.79609 .43413 -1.875 0 Mabsadd L closepath F
.79915 .16551 -1.875 0 Mabsadd m
.79915 .16551 0 2.5 Mabsadd L
.79915 .16551 1.875 0 Mabsadd L
.79915 .16551 0 -2.5 Mabsadd L
.79915 .16551 -1.875 0 Mabsadd L closepath F
.8022 .0293 -1.875 0 Mabsadd m
.8022 .0293 0 2.5 Mabsadd L
.8022 .0293 1.875 0 Mabsadd L
.8022 .0293 0 -2.5 Mabsadd L
.8022 .0293 -1.875 0 Mabsadd L closepath F
.80525 .07942 -1.875 0 Mabsadd m
.80525 .07942 0 2.5 Mabsadd L
.80525 .07942 1.875 0 Mabsadd L
.80525 .07942 0 -2.5 Mabsadd L
.80525 .07942 -1.875 0 Mabsadd L closepath F
.8083 .29603 -1.875 0 Mabsadd m
.8083 .29603 0 2.5 Mabsadd L
.8083 .29603 1.875 0 Mabsadd L
.8083 .29603 0 -2.5 Mabsadd L
.8083 .29603 -1.875 0 Mabsadd L closepath F
.81136 .59339 -1.875 0 Mabsadd m
.81136 .59339 0 2.5 Mabsadd L
.81136 .59339 1.875 0 Mabsadd L
.81136 .59339 0 -2.5 Mabsadd L
.81136 .59339 -1.875 0 Mabsadd L closepath F
.81441 .85378 -1.875 0 Mabsadd m
.81441 .85378 0 2.5 Mabsadd L
.81441 .85378 1.875 0 Mabsadd L
.81441 .85378 0 -2.5 Mabsadd L
.81441 .85378 -1.875 0 Mabsadd L closepath F
.81746 .97412 -1.875 0 Mabsadd m
.81746 .97412 0 2.5 Mabsadd L
.81746 .97412 1.875 0 Mabsadd L
.81746 .97412 0 -2.5 Mabsadd L
.81746 .97412 -1.875 0 Mabsadd L closepath F
.82051 .90678 -1.875 0 Mabsadd m
.82051 .90678 0 2.5 Mabsadd L
.82051 .90678 1.875 0 Mabsadd L
.82051 .90678 0 -2.5 Mabsadd L
.82051 .90678 -1.875 0 Mabsadd L closepath F
.82357 .67841 -1.875 0 Mabsadd m
.82357 .67841 0 2.5 Mabsadd L
.82357 .67841 1.875 0 Mabsadd L
.82357 .67841 0 -2.5 Mabsadd L
.82357 .67841 -1.875 0 Mabsadd L closepath F
.82662 .37942 -1.875 0 Mabsadd m
.82662 .37942 0 2.5 Mabsadd L
.82662 .37942 1.875 0 Mabsadd L
.82662 .37942 0 -2.5 Mabsadd L
.82662 .37942 -1.875 0 Mabsadd L closepath F
.82967 .12816 -1.875 0 Mabsadd m
.82967 .12816 0 2.5 Mabsadd L
.82967 .12816 1.875 0 Mabsadd L
.82967 .12816 0 -2.5 Mabsadd L
.82967 .12816 -1.875 0 Mabsadd L closepath F
.83272 .0241 -1.875 0 Mabsadd m
.83272 .0241 0 2.5 Mabsadd L
.83272 .0241 1.875 0 Mabsadd L
.83272 .0241 0 -2.5 Mabsadd L
.83272 .0241 -1.875 0 Mabsadd L closepath F
.83578 .10843 -1.875 0 Mabsadd m
.83578 .10843 0 2.5 Mabsadd L
.83578 .10843 1.875 0 Mabsadd L
.83578 .10843 0 -2.5 Mabsadd L
.83578 .10843 -1.875 0 Mabsadd L closepath F
.83883 .34777 -1.875 0 Mabsadd m
.83883 .34777 0 2.5 Mabsadd L
.83883 .34777 1.875 0 Mabsadd L
.83883 .34777 0 -2.5 Mabsadd L
.83883 .34777 -1.875 0 Mabsadd L closepath F
.84188 .64737 -1.875 0 Mabsadd m
.84188 .64737 0 2.5 Mabsadd L
.84188 .64737 1.875 0 Mabsadd L
.84188 .64737 0 -2.5 Mabsadd L
.84188 .64737 -1.875 0 Mabsadd L closepath F
.84493 .88864 -1.875 0 Mabsadd m
.84493 .88864 0 2.5 Mabsadd L
.84493 .88864 1.875 0 Mabsadd L
.84493 .88864 0 -2.5 Mabsadd L
.84493 .88864 -1.875 0 Mabsadd L closepath F
.84799 .97606 -1.875 0 Mabsadd m
.84799 .97606 0 2.5 Mabsadd L
.84799 .97606 1.875 0 Mabsadd L
.84799 .97606 0 -2.5 Mabsadd L
.84799 .97606 -1.875 0 Mabsadd L closepath F
.85104 .87503 -1.875 0 Mabsadd m
.85104 .87503 0 2.5 Mabsadd L
.85104 .87503 1.875 0 Mabsadd L
.85104 .87503 0 -2.5 Mabsadd L
.85104 .87503 -1.875 0 Mabsadd L closepath F
.85409 .62554 -1.875 0 Mabsadd m
.85409 .62554 0 2.5 Mabsadd L
.85409 .62554 1.875 0 Mabsadd L
.85409 .62554 0 -2.5 Mabsadd L
.85409 .62554 -1.875 0 Mabsadd L closepath F
.85714 .32636 -1.875 0 Mabsadd m
.85714 .32636 0 2.5 Mabsadd L
.85714 .32636 1.875 0 Mabsadd L
.85714 .32636 0 -2.5 Mabsadd L
.85714 .32636 -1.875 0 Mabsadd L closepath F
.8602 .09591 -1.875 0 Mabsadd m
.8602 .09591 0 2.5 Mabsadd L
.8602 .09591 1.875 0 Mabsadd L
.8602 .09591 0 -2.5 Mabsadd L
.8602 .09591 -1.875 0 Mabsadd L closepath F
.86325 .02543 -1.875 0 Mabsadd m
.86325 .02543 0 2.5 Mabsadd L
.86325 .02543 1.875 0 Mabsadd L
.86325 .02543 0 -2.5 Mabsadd L
.86325 .02543 -1.875 0 Mabsadd L closepath F
.8663 .14281 -1.875 0 Mabsadd m
.8663 .14281 0 2.5 Mabsadd L
.8663 .14281 1.875 0 Mabsadd L
.8663 .14281 0 -2.5 Mabsadd L
.8663 .14281 -1.875 0 Mabsadd L closepath F
.86935 .40159 -1.875 0 Mabsadd m
.86935 .40159 0 2.5 Mabsadd L
.86935 .40159 1.875 0 Mabsadd L
.86935 .40159 0 -2.5 Mabsadd L
.86935 .40159 -1.875 0 Mabsadd L closepath F
.87241 .69933 -1.875 0 Mabsadd m
.87241 .69933 0 2.5 Mabsadd L
.87241 .69933 1.875 0 Mabsadd L
.87241 .69933 0 -2.5 Mabsadd L
.87241 .69933 -1.875 0 Mabsadd L closepath F
.87546 .91816 -1.875 0 Mabsadd m
.87546 .91816 0 2.5 Mabsadd L
.87546 .91816 1.875 0 Mabsadd L
.87546 .91816 0 -2.5 Mabsadd L
.87546 .91816 -1.875 0 Mabsadd L closepath F
.87851 .97146 -1.875 0 Mabsadd m
.87851 .97146 0 2.5 Mabsadd L
.87851 .97146 1.875 0 Mabsadd L
.87851 .97146 0 -2.5 Mabsadd L
.87851 .97146 -1.875 0 Mabsadd L closepath F
.88156 .83813 -1.875 0 Mabsadd m
.88156 .83813 0 2.5 Mabsadd L
.88156 .83813 1.875 0 Mabsadd L
.88156 .83813 0 -2.5 Mabsadd L
.88156 .83813 -1.875 0 Mabsadd L closepath F
.88462 .57095 -1.875 0 Mabsadd m
.88462 .57095 0 2.5 Mabsadd L
.88462 .57095 1.875 0 Mabsadd L
.88462 .57095 0 -2.5 Mabsadd L
.88462 .57095 -1.875 0 Mabsadd L closepath F
.88767 .27568 -1.875 0 Mabsadd m
.88767 .27568 0 2.5 Mabsadd L
.88767 .27568 1.875 0 Mabsadd L
.88767 .27568 0 -2.5 Mabsadd L
.88767 .27568 -1.875 0 Mabsadd L closepath F
.89072 .06922 -1.875 0 Mabsadd m
.89072 .06922 0 2.5 Mabsadd L
.89072 .06922 1.875 0 Mabsadd L
.89072 .06922 0 -2.5 Mabsadd L
.89072 .06922 -1.875 0 Mabsadd L closepath F
.89377 .03328 -1.875 0 Mabsadd m
.89377 .03328 0 2.5 Mabsadd L
.89377 .03328 1.875 0 Mabsadd L
.89377 .03328 0 -2.5 Mabsadd L
.89377 .03328 -1.875 0 Mabsadd L closepath F
.89683 .1821 -1.875 0 Mabsadd m
.89683 .1821 0 2.5 Mabsadd L
.89683 .1821 1.875 0 Mabsadd L
.89683 .1821 0 -2.5 Mabsadd L
.89683 .1821 -1.875 0 Mabsadd L closepath F
.89988 .45677 -1.875 0 Mabsadd m
.89988 .45677 0 2.5 Mabsadd L
.89988 .45677 1.875 0 Mabsadd L
.89988 .45677 0 -2.5 Mabsadd L
.89988 .45677 -1.875 0 Mabsadd L closepath F
.90293 .74855 -1.875 0 Mabsadd m
.90293 .74855 0 2.5 Mabsadd L
.90293 .74855 1.875 0 Mabsadd L
.90293 .74855 0 -2.5 Mabsadd L
.90293 .74855 -1.875 0 Mabsadd L closepath F
.90598 .94194 -1.875 0 Mabsadd m
.90598 .94194 0 2.5 Mabsadd L
.90598 .94194 1.875 0 Mabsadd L
.90598 .94194 0 -2.5 Mabsadd L
.90598 .94194 -1.875 0 Mabsadd L closepath F
.90904 .96039 -1.875 0 Mabsadd m
.90904 .96039 0 2.5 Mabsadd L
.90904 .96039 1.875 0 Mabsadd L
.90904 .96039 0 -2.5 Mabsadd L
.90904 .96039 -1.875 0 Mabsadd L closepath F
.91209 .79659 -1.875 0 Mabsadd m
.91209 .79659 0 2.5 Mabsadd L
.91209 .79659 1.875 0 Mabsadd L
.91209 .79659 0 -2.5 Mabsadd L
.91209 .79659 -1.875 0 Mabsadd L closepath F
.91514 .51538 -1.875 0 Mabsadd m
.91514 .51538 0 2.5 Mabsadd L
.91514 .51538 1.875 0 Mabsadd L
.91514 .51538 0 -2.5 Mabsadd L
.91514 .51538 -1.875 0 Mabsadd L closepath F
.91819 .22809 -1.875 0 Mabsadd m
.91819 .22809 0 2.5 Mabsadd L
.91819 .22809 1.875 0 Mabsadd L
.91819 .22809 0 -2.5 Mabsadd L
.91819 .22809 -1.875 0 Mabsadd L closepath F
.92125 .04844 -1.875 0 Mabsadd m
.92125 .04844 0 2.5 Mabsadd L
.92125 .04844 1.875 0 Mabsadd L
.92125 .04844 0 -2.5 Mabsadd L
.92125 .04844 -1.875 0 Mabsadd L closepath F
.9243 .04754 -1.875 0 Mabsadd m
.9243 .04754 0 2.5 Mabsadd L
.9243 .04754 1.875 0 Mabsadd L
.9243 .04754 0 -2.5 Mabsadd L
.9243 .04754 -1.875 0 Mabsadd L closepath F
.92735 .22576 -1.875 0 Mabsadd m
.92735 .22576 0 2.5 Mabsadd L
.92735 .22576 1.875 0 Mabsadd L
.92735 .22576 0 -2.5 Mabsadd L
.92735 .22576 -1.875 0 Mabsadd L closepath F
.9304 .51253 -1.875 0 Mabsadd m
.9304 .51253 0 2.5 Mabsadd L
.9304 .51253 1.875 0 Mabsadd L
.9304 .51253 0 -2.5 Mabsadd L
.9304 .51253 -1.875 0 Mabsadd L closepath F
.93346 .79435 -1.875 0 Mabsadd m
.93346 .79435 0 2.5 Mabsadd L
.93346 .79435 1.875 0 Mabsadd L
.93346 .79435 0 -2.5 Mabsadd L
.93346 .79435 -1.875 0 Mabsadd L closepath F
.93651 .95965 -1.875 0 Mabsadd m
.93651 .95965 0 2.5 Mabsadd L
.93651 .95965 1.875 0 Mabsadd L
.93651 .95965 0 -2.5 Mabsadd L
.93651 .95965 -1.875 0 Mabsadd L closepath F
.93956 .94299 -1.875 0 Mabsadd m
.93956 .94299 0 2.5 Mabsadd L
.93956 .94299 1.875 0 Mabsadd L
.93956 .94299 0 -2.5 Mabsadd L
.93956 .94299 -1.875 0 Mabsadd L closepath F
.94261 .75097 -1.875 0 Mabsadd m
.94261 .75097 0 2.5 Mabsadd L
.94261 .75097 1.875 0 Mabsadd L
.94261 .75097 0 -2.5 Mabsadd L
.94261 .75097 -1.875 0 Mabsadd L closepath F
.94567 .4596 -1.875 0 Mabsadd m
.94567 .4596 0 2.5 Mabsadd L
.94567 .4596 1.875 0 Mabsadd L
.94567 .4596 0 -2.5 Mabsadd L
.94567 .4596 -1.875 0 Mabsadd L closepath F
.94872 .18423 -1.875 0 Mabsadd m
.94872 .18423 0 2.5 Mabsadd L
.94872 .18423 1.875 0 Mabsadd L
.94872 .18423 0 -2.5 Mabsadd L
.94872 .18423 -1.875 0 Mabsadd L closepath F
.95177 .03386 -1.875 0 Mabsadd m
.95177 .03386 0 2.5 Mabsadd L
.95177 .03386 1.875 0 Mabsadd L
.95177 .03386 0 -2.5 Mabsadd L
.95177 .03386 -1.875 0 Mabsadd L closepath F
.95482 .06801 -1.875 0 Mabsadd m
.95482 .06801 0 2.5 Mabsadd L
.95482 .06801 1.875 0 Mabsadd L
.95482 .06801 0 -2.5 Mabsadd L
.95482 .06801 -1.875 0 Mabsadd L closepath F
.95788 .27317 -1.875 0 Mabsadd m
.95788 .27317 0 2.5 Mabsadd L
.95788 .27317 1.875 0 Mabsadd L
.95788 .27317 0 -2.5 Mabsadd L
.95788 .27317 -1.875 0 Mabsadd L closepath F
.96093 .56813 -1.875 0 Mabsadd m
.96093 .56813 0 2.5 Mabsadd L
.96093 .56813 1.875 0 Mabsadd L
.96093 .56813 0 -2.5 Mabsadd L
.96093 .56813 -1.875 0 Mabsadd L closepath F
.96398 .83612 -1.875 0 Mabsadd m
.96398 .83612 0 2.5 Mabsadd L
.96398 .83612 1.875 0 Mabsadd L
.96398 .83612 0 -2.5 Mabsadd L
.96398 .83612 -1.875 0 Mabsadd L closepath F
.96703 .97105 -1.875 0 Mabsadd m
.96703 .97105 0 2.5 Mabsadd L
.96703 .97105 1.875 0 Mabsadd L
.96703 .97105 0 -2.5 Mabsadd L
.96703 .97105 -1.875 0 Mabsadd L closepath F
.97009 .91951 -1.875 0 Mabsadd m
.97009 .91951 0 2.5 Mabsadd L
.97009 .91951 1.875 0 Mabsadd L
.97009 .91951 0 -2.5 Mabsadd L
.97009 .91951 -1.875 0 Mabsadd L closepath F
.97314 .70191 -1.875 0 Mabsadd m
.97314 .70191 0 2.5 Mabsadd L
.97314 .70191 1.875 0 Mabsadd L
.97314 .70191 0 -2.5 Mabsadd L
.97314 .70191 -1.875 0 Mabsadd L closepath F
.97619 .40438 -1.875 0 Mabsadd m
.97619 .40438 0 2.5 Mabsadd L
.97619 .40438 1.875 0 Mabsadd L
.97619 .40438 0 -2.5 Mabsadd L
.97619 .40438 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[37]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00<Ooo0P00:?oo10000ooo0P009_oo00<0
0?ooool00_oo0P009_oo0P001?oo0P009Ooo0P001?oo0P008_oo10000ooo0P001?oo0P000ooo000`
ool01000ooooo`009ooo00<00?ooool00ooo00@00?ooool002Goo`05003oooooool00002ool00`00
ooooo`0Rool01000ooooo`000_oo00@00?ooool002?oo`04003ooooo0002ool01000ooooo`008ooo
00D00?ooooooo`0000;oo`04003ooooo0002ool10001ool1ool0033oo`04003ooooo000Xool00`00
ooooo`02ool01000ooooo`008_oo1@000_oo00@00?ooool002Coo`04003ooooo0002ool01000oooo
o`008ooo00@00?ooool000;oo`04003ooooo000Sool01@00oooooooo00000_oo00@00?ooool000;o
o`40007oo`7oo`00<?oo00@00?ooool002Woo`05003oooooool00002ool00`00ooooo`0Pool01000
ooooo`000ooo00@00?ooool002Coo`<000?oo`04003ooooo000Tool20003ool01000ooooo`008ooo
00D00?ooooooo`0000;oo`04003ooooo0002ool10001ool1ool0033oo`04003ooooo000Zool01000
ooooo`000_oo00<00?ooool08Ooo00<00?oo00000ooo00@00?ooool002Coo`03003ooooo00?oo`04
003ooooo000Sool01000ooooo`000_oo00@00?ooool002?oo`05003oooooool00002ool01000oooo
o`000_oo0@000Ooo0Ooo000`ool01000ooooo`009ooo00@00?ooool000;oo`04003ooooo000Tool2
0003ool01000ooooo`009?oo00<00?ooool00ooo00@00?ooool002?oo`04003ooooo0002ool01000
ooooo`008Ooo0`000ooo00@00?ooool000;oo`04003ooooo0002ool0037oo`8002Woo`8000Coo`80
02Koo`03003ooooo00;oo`8002Koo`<000?oo`8002Goo`8000Coo`8002Coo`03003ooooo00;oo`80
00Coo`8000?oo`00oooo8Ooo003ooolQool00?ooob7oo`00;?ool0001?oo000/ool00`00ooooo`03
ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`08
ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`09
ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`09
ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`09
ool00`00ooooo`02ool00`00ooooo`02ool002coo`03003ooooo0>coo`03003ooooo00;oo`009_oo
0P001?oo00<00?ooool0k?oo00<00?ooool00_oo000Uool01000ooooo`000ooo00<00?ooool00_oo
0P0O8ooo00<07oooool01?oo00<07oooool08Ooo00<07oooool08?oo00<07oooool01Ooo00<07ooo
ool08?oo00<07oooool08Ooo00<07oooool01?oo00<07oooool07_oo00<00?ooool00_oo000Uool0
1000ooooo`000ooo0`0000?oo`0O01l00P0O1Ooo00<07oooool06Ooo0`0O1?oo0`0O6_oo00<07ooo
ool01?oo0`0O1?oo0P0O5?oo00<07oooool00ooo0`0O1Ooo0`0O6Ooo0P0O1Ooo0`0O1_oo00<07ooo
ool04_oo00<07oooool00ooo0`0O1?oo0`0O7Ooo0`001?oo000Uool01000ooooo`000ooo00<00?oo
ool00_oo0`0O1?oo0`0O4ooo0P0O1?oo100O0ooo100O1?oo0P0O4ooo0`0O1?oo100O0ooo100O4_oo
0`0O0ooo100O1?oo100O1Ooo00<07oooool04?oo100O0ooo100O1Ooo0P0O4ooo0`0O0ooo100O0ooo
100O1Ooo00<07oooool02ooo00<07oooool02Ooo00<00?ooool00_oo000Uool01000ooooo`000ooo
00<00?ooool00ooo00<07oooool01?oo0P0O1_oo00<07oooool02Ooo0`0O1Ooo0P0O1Ooo0P0O1?oo
100O2ooo0P0O1_oo0P0O1Ooo0P0O1Ooo0`0O1Ooo00<07oooool02Ooo100O1?oo0P0O1_oo0P0O1Ooo
0`0O2ooo0P0O1Ooo0`0O1?oo0P0O1Ooo0`0O4_oo100O1?oo0P0O1Ooo0P0O1_oo0P0O2ooo0`0O2_oo
00<00?ooool00_oo000Uool01000ooooo`000ooo00<00?ooool02_oo00<07oooool01?oo0`0O2ooo
0P0O4ooo0`0O2_oo100O1Ooo00<07oooool03?oo00<07oooool00ooo0`0O1Ooo00<07oooool00ooo
0P0O4ooo100O2_oo100O1Ooo00<07oooool02ooo0P0O1Ooo0P0O1Ooo00<07oooool01?oo0P0O4ooo
0`0O2_oo100O2_oo00<00?ooool00_oo000Vool20004ool00`00ooooo`0@ool401l3ool201l7ool0
0`0Oooooo`0Bool00`0Oooooo`04ool201l4ool301lIool401l4ool301lJool201l6ool00`0Ooooo
o`03ool301lIool401l4ool201lKool00`0Oooooo`0:ool201l;ool00`00ooooo`02ool002coo`03
003ooooo017oo`807`?oo`@07b7oo`@07`Coo`0301oooooo01Woo`807`Coo`@07b7oo`<07`Goo`03
01oooooo01Woo`<07`?oo`<07b7oo`<07a7oo`03003ooooo00;oo`00;?oo00<00?ooool05ooo0`0O
8Ooo100O9ooo0`0O8?oo100O8_oo00<07oooool00ooo00<07oooool07ooo1@0O4?oo00<00?ooool0
0_oo000/ool00`00ooooo`0Gool401lOool401lYool201lPool301lRool00`0Oooooo`04ool201lQ
ool401l@ool00`00ooooo`02ool002coo`03003ooooo017oo`0301oooooo00Coo`<07b3oo`<07b7o
o`807`Goo`<07b7oo`0301oooooo023oo`<07`Coo`@07b7oo`807a7oo`03003ooooo00;oo`00;?oo
00<00?ooool04?oo0`0O1_oo00<07oooool08?oo00<07oooool01?oo0P0O6Ooo0`0O1_oo0P0O:Ooo
00<07oooool05ooo100O1Ooo0`0O=?oo00<00?ooool00_oo000/ool00`00ooooo`0?ool401l_ool4
01lIool201lRool00`0Oooooo`0<ool201lIool201l7ool00`0Oooooo`0Hool201l=ool201l:ool0
0`00ooooo`02ool002coo`03003ooooo013oo`807`koo`0301oooooo017oo`807`goo`<07a[oo`03
01oooooo01ooo`<07`coo`<07ccoo`@07`_oo`@07`Woo`03003ooooo00;oo`00;?oo0P008?oo0`0O
4Ooo100O3Ooo00<07oooool09ooo0P0O4Ooo100O3Ooo00<07oooool0:?oo00<07oooool04Ooo0`0O
3?oo0`0O2?oo0P001?oo000/ool00`00ooooo`0Nool401lBool301lfool401lAool201lSool00`0O
ooooo`0Cool201lCool00`0Oooooo`0<ool00`0Oooooo`08ool00`00ooooo`02ool002coo`03003o
oooo00[oo`0301oooooo01;oo`807aCoo`0301oooooo01ooo`807aGoo`<07cGoo`<07a?oo`<07bgo
o`03003ooooo00;oo`00;?oo00<00?ooool02Ooo0`0O?_oo0P0O2_oo100O5Ooo00<07oooool0:?oo
00<07oooool02?oo100O5?oo00<07oooool0;?oo00<00?ooool00_oo000/ool00`00ooooo`08ool4
01lmool401l:ool301loool301l:ool201lRool00`0Oooooo`0Oool00`00ooooo`02ool002coo`03
003ooooo00Woo`807b;oo`0301oooooo01[oo`<07`_oo`0301oooooo023oo`807a_oo`@07bkoo`80
7b3oo`03003ooooo00;oo`00;?oo00<00?ooool09ooo0P0O0ooo0`0O7?oo00<07oooool0;?oo100O
6ooo0P0O;_oo0`0O8?oo00<00?ooool00_oo000/ool00`00ooooo`0Vool301l2ool401m6ool201l4
ool301m7ool00`0Oooooo`02ool00`0Oooooo`0Oool00`00ooooo`02ool002coo`03003ooooo02Oo
o`807`?oo`807dKoo`@07`Coo`0301oooooo027oo`0301oooooo027oo`<07bGoo`03003ooooo00;o
o`00;?oo00<00?ooool01?oo00<07oooool08Ooo00<07oooool09Ooo0P0O8ooo0`0O9ooo0P0O8_oo
100O9Ooo00<00?ooool00_oo000/ool00`00ooooo`03ool301m9ool401lSool00`0Oooooo`0Uool3
01lSool201lVool00`00ooooo`02ool002coo`8000?oo`@07d[oo`@07d_oo`<07dWoo`8000Coo`00
;?oo00<00?ooool00ooo0P0OC?oo0`0OBooo100O7ooo0P0O:?oo00<00?ooool00_oo000/ool00`00
ooooo`0Vool00`0Oooooo`0Yool00`0Oooooo`0Oool201lZool301lNool401lWool00`00ooooo`02
ool002coo`03003ooooo02Goo`<07`Koo`807d?oo`@07b[oo`0301oooooo01koo`<07bOoo`03003o
oooo00;oo`00;?oo00<00?ooool09?oo100O1Ooo100O@ooo0`0O1_oo00<07oooool0@ooo00<07ooo
ool01_oo00<07oooool07Ooo00<00?ooool00_oo000/ool00`00ooooo`0Uool201l7ool301m4ool0
0`0Oooooo`04ool301m<ool301lNool00`00ooooo`02ool002coo`03003ooooo02ooo`0301oooooo
01Soo`0301oooooo033oo`807aSoo`807c7oo`@07akoo`03003ooooo00;oo`00;?oo00<00?ooool0
2ooo00<07oooool0>ooo0`0O<Ooo00<07oooool05_oo100O<Ooo0P0O7ooo00<00?ooool00_oo000/
ool00`00ooooo`0:ool301lkool401l=ool201llool301mBool00`00ooooo`02ool002coo`03003o
oooo00Woo`@07ccoo`807`goo`@07ccoo`0301oooooo00coo`807d?oo`03003ooooo00;oo`00;?oo
00<00?ooool02_oo0P0OCOoo0`0OB_oo100O4Ooo0P0O;ooo00<00?ooool00_oo000/ool00`00oooo
o`0Oool00`0Oooooo`0hool00`0Oooooo`0?ool201liool301l@ool401l^ool00`00ooooo`02ool0
02coo`8001ooo`<07aGoo`0301oooooo03;oo`@07cWoo`0301oooooo013oo`<07bgoo`8000Coo`00
;?oo00<00?ooool07Ooo100O5?oo0`0O=?oo0`0O5Ooo0P0O=_oo00<07oooool0;Ooo00<00?ooool0
0_oo000/ool00`00ooooo`0Nool201lDool401leool00`0Oooooo`0Cool401m;ool201l<ool00`0O
ooooo`09ool00`00ooooo`02ool002coo`03003ooooo03Goo`807dgoo`<07`[oo`0301oooooo03go
o`@07`[oo`807`_oo`03003ooooo00;oo`00;?oo00<00?ooool0@_oo00<07oooool0@?oo00<07ooo
ool02?oo0`0O?ooo0`0O2Ooo0`0O2ooo00<00?ooool00_oo000/ool00`00ooooo`0Bool00`0Ooooo
o`0/ool301m;ool401m0ool00`0Oooooo`09ool201l;ool00`00ooooo`02ool002coo`03003ooooo
017oo`<07bkoo`807acoo`807bkoo`807akoo`0301oooooo03Woo`03003ooooo00;oo`00;?oo00<0
0?ooool04_oo0P0O;_oo00<07oooool06_oo100OC?oo0P0O>ooo00<00?ooool00_oo000/ool00`00
ooooo`0Bool00`0Oooooo`1;ool301m;ool301l3ool201lfool00`00ooooo`02ool002coo`03003o
oooo01Soo`0301oooooo04Koo`0401ooooooool201m8ool201l2ool401leool00`00ooooo`02ool0
02coo`03003ooooo01Ooo`807bCoo`0301oooooo02Coo`@07dcoo`<07cGoo`03003ooooo00;oo`00
;?oo0P005ooo0`0O8ooo0`0O9_oo0`0O9?oo00<07oooool09_oo00<07oooool0<ooo0P001?oo000/
ool00`00ooooo`0Gool201lRool401lWool00`0Oooooo`0Rool301m<ool00`0Oooooo`0?ool00`00
ooooo`02ool002coo`03003ooooo03coo`807dcoo`@07dWoo`807`03ool07`0O013oo`03003ooooo
00;oo`00;?oo00<00?ooool0>ooo00<07oooool0Booo100OBOoo1P0O4?oo00<00?ooool00_oo000/
ool00`00ooooo`0Jool00`0Oooooo`0Mool301m;ool401m;ool401lAool00`00ooooo`02ool002co
o`03003ooooo01Woo`<07agoo`@07b_oo`0301oooooo01koo`<07dcoo`0301oooooo017oo`03003o
oooo00;oo`00;?oo00<00?ooool06?oo100O7_oo0P0O:ooo0`0O8?oo00<07oooool0:_oo00<07ooo
ool0<_oo00<00?ooool00_oo000/ool00`00ooooo`0Iool201m;ool401m<ool301lcool00`00oooo
o`02ool002coo`03003ooooo06Ooo`807dCoo`0301oooooo00Goo`@07c?oo`03003ooooo00;oo`00
0_oo0P001?oo00<00?ooool00ooo0P001?oo0P001?oo0P001?oo0P000ooo0`001?oo00<00?ooool0
G_oo0P0OC?oo0`0O1ooo0P0O=?oo00<00?ooool00_oo00001Ooo003ooooo00002?oo00@00?ooool0
00;oo`04003ooooo0002ool01000ooooo`000_oo00@00?ooool000Goo`05003oooooool0000Aool2
01m<ool401m<ool201lmool00`00ooooo`02ool00005ool00?ooool00008ool01000ooooo`000_oo
00@00?ooool000;oo`04003ooooo0002ool01000ooooo`001Ooo00@00?ooooooo`<000koo`@07c;o
o`807aSoo`<07c;oo`0301oooooo01Ooo`0301oooooo03[oo`<000Coo`0000Goo`00ooooo`0000So
o`04003ooooo0002ool01000ooooo`000_oo00@00?ooool000;oo`04003ooooo0002ool30004ool0
0`00ooooo`0?ool301laool401lHool00`0Oooooo`0`ool301m=ool00`0Oooooo`07ool00`00oooo
o`02ool00005ool00?ooool00008ool01000ooooo`000_oo00@00?ooool000;oo`04003ooooo0002
ool01000ooooo`000_oo00<00?ooool01?oo00<00?ooool04?oo00<07oooool0<Ooo0`0OB_oo100O
??oo00<07oooool03Ooo0`0O2?oo00<00?ooool00_oo00001Ooo003ooooo00002?oo00@00?ooool0
00;oo`04003ooooo0002ool01000ooooo`000_oo00@00?ooool000;oo`03003ooooo00Coo`03003o
oooo04Goo`0301oooooo03[oo`0301oooooo00goo`807ccoo`<07`goo`@07`Soo`03003ooooo00;o
o`000_oo0P002_oo0P001?oo0P001?oo0P001?oo0P000ooo10000ooo00<00?ooool0<ooo0P0OC?oo
0`0OBooo100O3_oo0P0O2Ooo00<00?ooool00_oo000/ool00`00ooooo`0Pool201l@ool401m<ool2
01m<ool201lJool00`00ooooo`02ool002coo`03003ooooo01ooo`@07a3oo`<07cWoo`807a7oo`03
01oooooo06Ooo`03003ooooo00;oo`00;?oo00<00?ooool08?oo0`0O4Ooo00<07oooool0=ooo0`0O
C?oo0P0O;Ooo00<00?ooool00_oo000/ool00`00ooooo`0Qool00`0Oooooo`1;ool201leool00`0O
ooooo`0Cool401l/ool00`00ooooo`02ool002coo`03003ooooo05Soo`0301oooooo01Goo`0301oo
oooo03;oo`<07aGoo`<07bcoo`03003ooooo00;oo`00;?oo00<00?ooool02Ooo00<07oooool0Booo
0P0OBooo100O5_oo00<07oooool0:ooo00<00?ooool00_oo000/ool00`00ooooo`08ool301m1ool0
0`0Oooooo`07ool301m<ool201m5ool00`00ooooo`02ool002coo`8000Soo`@07d3oo`<07`Woo`80
7d7oo`0301oooooo04koo`8000Coo`00;?oo00<00?ooool02?oo0P0O@?oo100OC?oo0P0OD?oo00<0
0?ooool00_oo000/ool00`00ooooo`1;ool201m<ool301l^ool00`0Oooooo`0Oool00`00ooooo`02
ool002coo`03003ooooo07_oo`0301oooooo01coo`0301oooooo02coo`<07b3oo`03003ooooo00;o
o`00;?oo00<00?ooool0;Ooo00<07oooool0B_oo0`0OBooo100O8?oo00<00?ooool00_oo000/ool0
0`00ooooo`0Xool0100Ooooooooo0P0OBooo100OC?oo0P0O8Ooo00<00?ooool00_oo000/ool00`00
ooooo`0Wool301l01?oo01l07`0OBOoo00<07oooool00P0OL?oo00<00?ooool00_oo000/ool00`00
ooooo`0Vool401l2ool201m8ool301m<ool00`0Oooooo`0Tool00`00ooooo`02ool002coo`03003o
oooo02Ooo`807dcoo`@07dcoo`807bGoo`03003ooooo00;oo`00;?oo00<00?ooool0M_oo0P0O9_oo
0P0O9?oo0`0O9Ooo00<00?ooool00_oo000/ool00`00ooooo`1?ool201m<ool401lTool00`0Ooooo
o`0Tool00`00ooooo`02ool002coo`8000Goo`807dSoo`@07dcoo`<07d[oo`8000Coo`00;?oo00<0
0?ooool00ooo0`0OBOoo1@0OBooo00<07oooool0B_oo00<00?ooool00_oo000/ool00`00ooooo`04
ool201m:ool501m=ool00`0Oooooo`17ool00`00ooooo`02ool002coo`03003ooooo00Goo`0301oo
oooo04[oo`<07dcoo`<07dSoo`03003ooooo00;oo`00;?oo00<00?ooool0Dooo00<07oooool0B_oo
100O7_oo00<07oooool09ooo00<00?ooool00_oo000/ool00`00ooooo`1cool201l/ool201lNool3
01lXool00`00ooooo`02ool002coo`03003ooooo02Coo`807dcoo`@07dcoo`807bSoo`03003ooooo
00;oo`00;?oo00<00?ooool08ooo100O2?oo0P0O@_oo0`0OC?oo00<07oooool09ooo00<00?ooool0
0_oo000/ool00`00ooooo`0Tool301l7ool301m3ool00`0Oooooo`06ool201m]ool00`00ooooo`02
ool002coo`03003ooooo02Goo`0301oooooo00Ooo`807d_oo`@07dgoo`0301oooooo01coo`03003o
oooo00;oo`00;?oo00<00?ooool0<?oo00<07oooool0B_oo0`0OC?oo0`0O5_oo0P0O1Ooo00<00?oo
ool00_oo000/ool2001oool00`0Oooooo`0Fool201lbool401lEool401l3ool20004ool002coo`03
003ooooo04Soo`807dcoo`<07c?oo`807aOoo`<07`Coo`03003ooooo00;oo`00;?oo00<00?ooool0
2ooo0P0O>_oo100OC?oo0P0OCOoo00<07oooool00ooo00<00?ooool00_oo000/ool00`00ooooo`0:
ool401ljool301l?ool00`0Oooooo`0kool00`0Oooooo`1Aool00`00ooooo`02ool002coo`03003o
oooo00_oo`<07c_oo`0301oooooo00goo`<07dgoo`0301oooooo043oo`03003ooooo00;oo`00;?oo
00<00?ooool03?oo00<07oooool0Booo0P0OC?oo0`0O@Ooo00<00?ooool00_oo000/ool00`00oooo
o`1Jool00`0Oooooo`1:ool401l?ool201l`ool00`00ooooo`02ool002coo`03003ooooo06coo`80
7c[oo`807`ooo`@07booo`03003ooooo00;oo`00;?oo00<00?ooool07Ooo0P0OC?oo100OBooo0`0O
;ooo00<00?ooool00_oo000/ool00`00ooooo`0Lool401lGool00`0Oooooo`0bool301m<ool00`0O
ooooo`0^ool00`00ooooo`02ool002coo`03003ooooo01goo`<07aKoo`<07cCoo`0301oooooo01Go
o`0301oooooo06Coo`03003ooooo00;oo`00;?oo00<00?ooool07_oo00<07oooool05?oo100OC?oo
0P0OCOoo00<07oooool05Ooo00<00?ooool00_oo000/ool2000gool201m<ool301m<ool301l8ool2
01l;ool20004ool002coo`03003ooooo08Goo`0301oooooo00Ooo`807d7oo`@07`Ooo`@07`_oo`03
003ooooo00;oo`00;?oo00<00?ooool0@_oo00<07oooool0BOoo100O@Ooo0P0O2Ooo0`0O2ooo00<0
0?ooool00_oo000/ool00`00ooooo`0Cool00`0Oooooo`0[ool301m;ool301m=ool00`0Oooooo`0:
ool00`00ooooo`02ool002coo`03003ooooo01;oo`<07b_oo`@07akoo`0301oooooo02_oo`0301oo
oooo05Woo`03003ooooo00;oo`00;?oo00<00?ooool04Ooo100O;?oo0P0O7_oo0`0OC?oo00<07ooo
ool0>Ooo00<00?ooool00_oo000/ool00`00ooooo`0Bool201m<ool401m;ool301ljool00`00oooo
o`02ool002coo`03003ooooo067oo`807d_oo`@07`;oo`0301oooooo03Goo`03003ooooo00;oo`00
;?oo00<00?ooool0IOoo00<07oooool0Aooo0P0O0_oo0`0O=_oo00<00?ooool00_oo0008ool20004
ool00`00ooooo`03ool20004ool20004ool20003ool40003ool00`00ooooo`0Gool00`0Oooooo`1:
ool301m;ool401lfool00`00ooooo`02ool000Ooo`04003ooooo0008ool01000ooooo`000_oo00@0
0?ooool000;oo`04003ooooo0004ool00`00ooooo`02ool00`00ooooo`0Fool301lUool00`0Ooooo
o`0Rool401m<ool201lgool00`00ooooo`02ool000Ooo`04003ooooo0008ool01000ooooo`000_oo
00@00?ooool000;oo`04003ooooo0004ool00`00ooooo`02ool3000Eool401lTool301lTool201lW
ool00`0Oooooo`1Jool30004ool000Ooo`04003ooooo0008ool01000ooooo`000_oo00@00?ooool0
00;oo`04003ooooo0004ool00`00ooooo`02ool00`00ooooo`0Fool201lTool401m<ool301m<ool0
0`0Oooooo`0>ool00`00ooooo`02ool000Ooo`04003ooooo0008ool01000ooooo`000_oo00@00?oo
ool000;oo`04003ooooo0004ool00`00ooooo`02ool00`00ooooo`0mool201m<ool401m9ool00`0O
ool07`0201l?ool00`00ooooo`02ool000Ooo`04003ooooo0008ool01000ooooo`000_oo00@00?oo
ool000;oo`04003ooooo0002ool30004ool00`00ooooo`29ool00`0Oooooo`0201m9ool601l?ool0
0`00ooooo`02ool000Soo`8000[oo`8000Coo`8000Coo`8000Goo`03003ooooo00;oo`03003ooooo
03[oo`0301oooooo04_oo`<07d_oo`<07`03ool07`0O013oo`03003ooooo00;oo`00;?oo00<00?oo
ool06_oo00<07oooool07Ooo0P0OBooo100OC?oo0P0O4ooo00<00?ooool00_oo000/ool00`00oooo
o`0Jool201lMool301l]ool00`0Oooooo`0Lool201mRool00`00ooooo`02ool002coo`03003ooooo
01Woo`<07akoo`0301oooooo02_oo`<07h7oo`03003ooooo00;oo`00;?oo00<00?ooool06_oo00<0
7oooool0B_oo100OC?oo0P0O<ooo00<00?ooool00_oo000/ool00`00ooooo`1Xool201m3ool00`0O
ooooo`06ool301lcool00`00ooooo`02ool002coo`03003ooooo05koo`0301oooooo04_oo`<07`So
o`807c?oo`03003ooooo00;oo`00;?oo0P004Ooo00<07oooool0B_oo0`0OBooo100O2Ooo00<07ooo
ool0<?oo0P001?oo000/ool00`00ooooo`0?ool201m;ool401m<ool201lnool00`00ooooo`02ool0
02coo`03003ooooo00koo`<07c?oo`807aOoo`807hgoo`03003ooooo00;oo`00;?oo00<00?ooool0
3ooo0P0O<_oo100OC?oo0P0OEooo00<00?ooool00_oo000/ool00`00ooooo`14ool301m;ool401lj
ool00`0Oooooo`0?ool00`0Oooooo`07ool00`00ooooo`02ool002coo`03003ooooo04Goo`0301oo
oooo03[oo`0301oooooo00koo`<07cWoo`<07`ooo`<07`Soo`03003ooooo00;oo`00;?oo00<00?oo
ool0POoo0`0O4?oo00<07oooool0=ooo100O4?oo0P0O2?oo00<00?ooool00_oo000/ool00`00oooo
o`0bool201m<ool401m;ool201lAool00`0Oooooo`07ool00`00ooooo`02ool002coo`03003ooooo
027oo`807`koo`@07dcoo`807fWoo`03003ooooo00;oo`00;?oo00<00?ooool08?oo100O3_oo0`0O
>_oo0P0ONooo00<00?ooool00_oo000/ool00`00ooooo`0Qool301l?ool00`0Oooooo`0hool401m<
ool201l/ool00`00ooooo`02ool002coo`03003ooooo02;oo`0301oooooo04[oo`<07c?oo`0301oo
oooo01Goo`@07b_oo`03003ooooo00;oo`00;?oo0P00LOoo00<07oooool0<_oo0P0O5ooo0`0O:_oo
0P001?oo000/ool00`00ooooo`1Fool201m<ool301lHool00`0Oooooo`0Zool00`00ooooo`02ool0
02coo`03003ooooo00Ooo`807dcoo`@07dcoo`0301oooooo04Coo`03003ooooo00;oo`00;?oo00<0
0?ooool01_oo100O@_oo0P0O2?oo0`0OTooo00<00?ooool00_oo000/ool00`00ooooo`07ool301m1
ool401l8ool00`0Oooooo`10ool201m@ool00`00ooooo`02ool002coo`03003ooooo00Soo`0301oo
oooo047oo`<07d[oo`@07bcoo`0301oooooo023oo`03003ooooo00;oo`00;?oo00<00?ooool0COoo
00<07oooool0:_oo00<07oooool07Ooo0`0O:ooo0`0O8Ooo00<00?ooool00_oo000/ool00`00oooo
o`0/ool00`0Oooooo`1;ool201lOool00`0Oooooo`0Yool401lQool00`00ooooo`02ool002coo`03
003ooooo02_oo`<07d_oo`<07dcoo`807b;oo`03003ooooo00;oo`00;?oo00<00?ooool0:?oo1P0O
C?oo00<07oooool0Kooo00<00?ooool00_oo000/ool00`00ooooo`0Wool601m:ool201mcool00`00
ooooo`02ool002coo`8002Woo`<07d_oo`<07dcoo`807bCoo`8000Coo`00;?oo00<00?ooool0:Ooo
00<07oooool0Booo0P0O9Ooo00<07oooool08ooo100O9?oo00<00?ooool00_oo000/ool00`00oooo
o`1@ool00`0Oooooo`0Uool00`0Oooooo`0Rool301lUool301lTool00`00ooooo`02ool002coo`03
003ooooo00Goo`0301oooooo04Ooo`807d_oo`@07bKoo`0301oooooo02?oo`03003ooooo00;oo`00
;?oo00<00?ooool01?oo0`0OAooo0`0O0ooo00<07oooool0A_oo0P0OCOoo00<00?ooool00_oo000/
ool00`00ooooo`03ool401m8ool201l2ool301m<ool00`0Oooooo`17ool00`00ooooo`02ool002co
o`03003ooooo00Coo`807dcoo`@07dcoo`807dSoo`03003ooooo00;oo`00;?oo00<00?ooool0Dooo
0P0OC?oo0`0O7_oo00<07oooool09ooo00<00?ooool00_oo000/ool00`00ooooo`1cool00`0Ooooo
o`0/ool00`0Oooooo`0Lool301lXool00`00ooooo`02ool002coo`03003ooooo02Goo`0301oooooo
04[oo`<07d_oo`@07bSoo`03003ooooo00;oo`00;?oo00<00?ooool09?oo0P0O2_oo00<07oooool0
?_oo100OC?oo0P0O:Ooo00<00?ooool00_oo000/ool2000Tool301l9ool301m0ool201l;ool00`0O
ooooo`1Yool20004ool002coo`03003ooooo02Coo`807`Soo`@07dcoo`<07dcoo`0301oooooo01co
o`03003ooooo00;oo`00;?oo00<00?ooool0;ooo0P0OC?oo100OBooo0`0O5_oo00<07oooool01?oo
00<00?ooool00_oo000/ool00`00ooooo`1nool201lFool201leool201lEool301l5ool00`00oooo
o`02ool002coo`03003ooooo04Ooo`807dcoo`@07cCoo`0301oooooo01Goo`807`Goo`03003ooooo
00;oo`00;?oo00<00?ooool03?oo0P0O>?oo100OC?oo0`0OC?oo00<07oooool01?oo00<00?ooool0
0_oo000/ool00`00ooooo`0;ool301liool301l@ool201lkool00`0Oooooo`0@ool00`0Oooooo`0o
ool00`00ooooo`02ool002coo`03003ooooo00coo`807c[oo`0301oooooo00koo`@07dcoo`<07d3o
o`03003ooooo00;oo`00;?oo00<00?ooool03Ooo00<07oooool0B_oo0`0OBooo100O3_oo00<07ooo
ool0;ooo00<00?ooool00_oo000/ool00`00ooooo`1Kool00`0Oooooo`0=ool201llool201l?ool2
01l`ool00`00ooooo`02ool000;oo`8000Coo`03003ooooo00?oo`8000Coo`8000Coo`8000?oo`@0
00;oo`<000Coo`03003ooooo01coo`807dcoo`@07d_oo`<07c3oo`03003ooooo00;oo`0000Goo`00
ooooo`0000Soo`04003ooooo0002ool01000ooooo`000_oo00@00?ooool000Coo`03003ooooo00Co
o`05003oooooool0000Mool401lHool201lbool301m<ool00`0Oooooo`0_ool00`00ooooo`02ool0
0005ool00?ooool00008ool01000ooooo`000_oo00@00?ooool000;oo`04003ooooo0004ool00`00
ooooo`04ool01000oooooooo0`007?oo0`0O5ooo0`0O<ooo00<07oooool05_oo0P0OHooo0`001?oo
00001Ooo003ooooo00002?oo00@00?ooool000;oo`04003ooooo0002ool01000ooooo`001?oo00@0
0?ooooooo`<000Coo`03003ooooo01goo`0301oooooo01Ooo`807d_oo`@07dcoo`807`Soo`0301oo
oooo00_oo`03003ooooo00;oo`0000Goo`00ooooo`0000Soo`04003ooooo0002ool01000ooooo`00
0_oo00@00?ooool000Coo`05003oooooool00006ool00`00ooooo`0hool00`0Oooooo`1:ool301l8
ool00`0Oooooo`10ool401l6ool301l<ool00`00ooooo`02ool00005ool00?ooool00008ool01000
ooooo`000_oo00@00?ooool000;oo`04003ooooo0002ool30003ool00`00ooooo`04ool00`00oooo
o`11ool00`0Oooooo`12ool00`0Oooooo`06ool201m3ool301l5ool401l<ool00`00ooooo`02ool0
00;oo`8000[oo`8000Coo`8000Coo`8000Goo`04003oooooool40003ool00`00ooooo`0Dool00`0O
ooooo`0Yool301m;ool301m4ool00`0Oooooo`05ool201l=ool00`00ooooo`02ool002coo`03003o
oooo01?oo`<07bWoo`@07aooo`0301oooooo02[oo`807e_oo`03003ooooo00;oo`00;?oo00<00?oo
ool04_oo100O:_oo0P0O7ooo0`0OC?oo0P0O>_oo00<00?ooool00_oo000/ool00`00ooooo`0Cool2
01m=ool201m;ool501lhool00`00ooooo`02ool002coo`03003ooooo06;oo`0401oooooo01m:ool5
01lgool00`00ooooo`02ool002coo`03003ooooo01Koo`0301oooooo04_oo`<07d[oo`@07cOoo`03
003ooooo00;oo`00;?oo00<00?ooool05Ooo0`0O9_oo0P0O8ooo100OBooo0P0O>?oo00<00?ooool0
0_oo000/ool2000Eool401lUool401lSool201lWool00`0Oooooo`1Kool20004ool002coo`03003o
oooo01Goo`807bOoo`<07d_oo`<07dSoo`0401ooooooool201l?ool00`00ooooo`02ool002coo`03
003ooooo03ooo`0301oooooo04Koo`0301oooooo00;oo`807dOoo`<07`03ool07`0O00807`koo`03
003ooooo00;oo`00;?oo00<00?ooool0>Ooo0P0OC?oo0`0O0ooo00<07oooool0AOoo100O0_oo0`0O
3_oo00<00?ooool00_oo000/ool00`00ooooo`0Jool201lLool401m:ool401m<ool201l4ool00`0O
ooooo`0=ool00`00ooooo`02ool002coo`03003ooooo01Woo`@07acoo`<07bgoo`807acoo`807boo
o`0301oooooo037oo`03003ooooo00;oo`00;?oo00<00?ooool06_oo0`0O7Ooo00<07oooool0:ooo
100OBooo0`0O<_oo00<00?ooool00_oo000/ool00`00ooooo`0Kool00`0Oooooo`0oool00`0Ooooo
o`09ool301loool201l9ool401lbool00`00ooooo`02ool002coo`03003ooooo00ooo`0301oooooo
04[oo`<07`_oo`0301oooooo03goo`@07`Woo`807c?oo`03003ooooo00;oo`00;?oo00<00?ooool0
3_oo0`0O=Ooo00<07oooool04_oo100OC?oo0`0O?_oo00<00?ooool00_oo000/ool00`00ooooo`0=
ool401ldool301lDool201lfool201lFool00`0Oooooo`0mool00`00ooooo`02ool002coo`8000oo
o`807cCoo`@07d_oo`@07cWoo`0301oooooo00ooo`807`Ooo`8000Coo`00;?oo00<00?ooool0AOoo
0P0O>Ooo0P0O4_oo0`0O>?oo0P0O4?oo100O1ooo00<00?ooool00_oo000/ool00`00ooooo`0Rool0
0`0Oooooo`0=ool00`0Oooooo`1:ool401lBool00`0Oooooo`0fool301lAool301l7ool00`00oooo
o`02ool002coo`03003ooooo02;oo`807`goo`<07cgoo`0301oooooo00coo`<07dcoo`807a;oo`03
01oooooo00Koo`03003ooooo00;oo`00;?oo00<00?ooool08Ooo0`0O3_oo0P0O??oo0`0O3_oo00<0
7oooool0>ooo0P0O:ooo00<00?ooool00_oo000/ool00`00ooooo`0Rool00`0Oooooo`0=ool00`0O
ooooo`0jool401laool201lHool301l[ool00`00ooooo`02ool002coo`03003ooooo00Soo`0301oo
oooo04[oo`807aWoo`807c7oo`@07aSoo`807b_oo`03003ooooo00;oo`00;?oo00<00?ooool01ooo
0P0OA?oo00<07oooool01?oo100OC?oo0`0O6Ooo00<07oooool0:Ooo00<00?ooool00_oo000/ool0
0`00ooooo`06ool301m3ool301l6ool301m3ool201l8ool00`0Oooooo`14ool00`00ooooo`02ool0
02coo`03003ooooo00Ooo`807d;oo`@07`Ooo`0301oooooo047oo`@07bWoo`807b?oo`03003ooooo
00;oo`00;?oo00<00?ooool0:ooo00<07oooool07_oo0P0O:ooo0P0O8?oo0`0O:?oo100O8_oo00<0
0?ooool00_oo000/ool00`00ooooo`0Yool401m;ool401lPool00`0Oooooo`0Xool301lRool00`00
ooooo`02ool002coo`8002Woo`D07d[oo`D07d_oo`807b;oo`8000Coo`00;?oo00<00?ooool0:Ooo
0`0OB_oo1@0O8_oo00<07oooool09_oo0`0O8ooo00<00?ooool00_oo000/ool00`00ooooo`06ool0
0`0Oooooo`0Qool00`0Oooooo`0Qool201lWool201lTool201lVool401lSool00`00ooooo`02ool0
02coo`03003ooooo00Goo`<07dGoo`@07`?oo`807dKoo`<07bOoo`807bCoo`03003ooooo00;oo`00
;?oo00<00?ooool01?oo100OA_oo0`0O0_oo100OA_oo00<07oooool00_oo0P0O7Ooo00<07oooool0
:?oo00<00?ooool00_oo000/ool00`00ooooo`05ool201m8ool00`0Oooooo`02ool301lKool00`0O
ooooo`0/ool401lKool301lYool00`00ooooo`02ool002coo`03003ooooo02?oo`807`coo`0301oo
oooo027oo`0301oooooo01Woo`<07bkoo`<07a[oo`@07bWoo`03003ooooo00;oo`00;?oo00<00?oo
ool08_oo100O2_oo0`0O?ooo0P0O2ooo0P0O8_oo00<07oooool06_oo0P0O3?oo00<07oooool05?oo
00<07oooool01?oo00<00?ooool00_oo000/ool00`00ooooo`0Sool301l9ool401lEool00`0Ooooo
o`0Wool00`0Oooooo`09ool301lDool201lfool301lDool301l5ool00`00ooooo`02ool002coo`03
003ooooo00coo`807aKoo`0301oooooo00Woo`807aGoo`807a?oo`0301oooooo023oo`807a?oo`@0
7cCoo`@07a?oo`@07`Goo`03003ooooo00;oo`00;?oo00<00?ooool02ooo100O=ooo0`0O4_oo0`0O
8_oo00<07oooool04_oo0`0O4_oo00<07oooool08?oo0P0O5Ooo0P0O1_oo00<00?ooool00_oo000/
ool2000=ool301lhool201lAool401l=ool00`0Oooooo`0Xool00`0Oooooo`0@ool301l=ool201l`
ool20004ool002coo`03003ooooo00goo`0301oooooo00coo`807aWoo`807b;oo`807`goo`<07a[o
o`0301oooooo023oo`807`coo`@07c3oo`03003ooooo00;oo`00;?oo00<00?ooool06ooo0`0O6?oo
100O;ooo100O6Ooo0`0O1_oo00<07oooool06?oo00<07oooool03?oo0`0O6Ooo00<07oooool01Ooo
00<07oooool03?oo00<00?ooool00_oo000/ool00`00ooooo`0Eool00`0Oooooo`04ool201lIool3
01l5ool201lYool201lIool401l5ool301lYool00`0Oooooo`0Gool301l6ool201l=ool00`00oooo
o`02ool002coo`03003ooooo01Coo`807`Ooo`0301oooooo01Soo`0301oooooo00?oo`@07b3oo`80
7b;oo`807`Goo`@07b3oo`807b;oo`807`Goo`<07`goo`03003ooooo00;oo`00;?oo00<00?ooool0
4ooo0`0O:Ooo0`0O7ooo100O:Ooo0P0O8?oo100O8Ooo00<07oooool01Ooo00<07oooool03?oo00<0
0?ooool00_oo000/ool00`00ooooo`0Dool301lXool201lQool401lRool00`0Oooooo`02ool201lR
ool301lRool00`0Oooooo`04ool00`0Oooooo`0<ool00`00ooooo`02ool002coo`03003ooooo01?o
o`@07`Coo`807a_oo`807`Coo`<07b;oo`<07`Coo`0301oooooo01[oo`807`?oo`@07b;oo`0301oo
oooo00Coo`0301oooooo01Woo`<07`Coo`<07`goo`03003ooooo00;oo`00;?oo00<00?ooool03_oo
00<07oooool00ooo0P0O1?oo100O6Ooo100O1?oo0P0O1_oo00<07oooool04ooo00<07oooool01?oo
00<07oooool00ooo0P0O6_oo0`0O1?oo0`0O6_oo0P0O3?oo0`0O6Ooo100O0ooo100O3Ooo00<00?oo
ool00_oo0008ool20004ool00`00ooooo`03ool20004ool20004ool20003ool40003ool00`00oooo
o`0=ool301l;ool301l5ool00`0Oooooo`0<ool00`0Oooooo`03ool301l;ool301lCool301l:ool3
01l6ool00`0Oooooo`0:ool201l6ool201l5ool00`0Oooooo`04ool00`0Oooooo`0Aool401l:ool4
01l5ool00`0Oooooo`0;ool201l5ool201l5ool201l5ool201l7ool00`00ooooo`02ool000Ooo`04
003ooooo0008ool01000ooooo`000_oo00@00?ooool000;oo`04003ooooo0002ool00`00ooooo`04
ool00`00ooooo`06ool201l4ool401l<ool00`0Oooooo`03ool301l5ool00`0Oooooo`04ool301l5
ool00`0Oooooo`09ool401l4ool201l5ool201l5ool401l;ool00`0Oooooo`04ool301l4ool201l4
ool401lBool301l5ool201l5ool201l5ool301l;ool201l5ool301l5ool201l4ool401lAool401l6
ool00`00ooooo`02ool000Ooo`04003ooooo0008ool01000ooooo`000_oo00@00?ooool000;oo`04
003ooooo0003ool00`00ooooo`03ool30005ool401l4ool201lBool401l4ool301l4ool401lBool2
01l4ool401l3ool401l5ool201lBool401l3ool401l4ool301lCool201l4ool401l3ool401l5ool0
0`0Oooooo`0@ool401l4ool301l5ool301lBool301l4ool30004ool000Ooo`04003ooooo0008ool0
1000ooooo`000_oo00@00?ooool000;oo`04003ooooo0004ool00`00ooooo`02ool00`00ooooo`06
ool301lIool201l6ool201l5ool201lJool301l4ool301lJool201l5ool301l5ool00`0Oooooo`0B
ool00`0Oooooo`04ool301l4ool301lIool201l6ool201l6ool00`0Oooooo`0Bool00`0Oooooo`05
ool00`00ooooo`02ool000Ooo`04003ooooo0008ool01000ooooo`000_oo00@00?ooool000;oo`04
003ooooo0005ool01@00oooooooo00002Ooo00<07oooool08?oo00<07oooool08Ooo00<07oooool0
1?oo00<07oooool08Ooo00<07oooool08Ooo00<07oooool01?oo00<07oooool08Ooo00<07oooool0
8Ooo00<00?ooool00_oo0007ool01000ooooo`002?oo00@00?ooool000;oo`04003ooooo0002ool0
1000ooooo`000_oo00@00?ooool000?oo`03003ooooo0>coo`03003ooooo00;oo`002?oo0P002_oo
0P001?oo0P001?oo0P001?oo0P001?oo00<00?ooool0k?oo00<00?ooool00_oo000/ool00`00oooo
o`03ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`09ool00`00oooo
o`08ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`08ool00`00oooo
o`09ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`08ool00`00ooooo`08ool00`00oooo
o`09ool00`00ooooo`08ool00`00ooooo`08ool00`00ooooo`09ool00`00ooooo`08ool00`00oooo
o`09ool00`00ooooo`02ool00`00ooooo`02ool002cooo0000Coo`00oooo8Ooo003ooolQool00?oo
ob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo
003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?oo
ob7oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {773.5, 414.75}} -> {-55.216, \
0.00026065, 0.439864, 8.81132*^-7}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rounding error reduction", "Section",
  CellTags->"s:2"],

Cell[TextData[{
  "In certain cases, Lattice symplectic methods exist and can avoid step by \
step roundoff accumulation, but such an approach is not always possible ",
  "[",
  ButtonBox["ET92",
    ButtonData:>{"References.nb", "ET92"},
    ButtonStyle->"Hyperlink"],
  "]",
  "."
}], "Text"],

Cell["\<\
Consider the previous example where the combination of step size \
and order of the method is now chosen such that the error in the Hamiltonian \
is around the order of unit roundoff in IEEE double precision \
arithmetic.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(solnoca\  = \ 
        NDSolve[eqs, vars, time, \ 
          Method \[Rule] {"\<SymplecticPartitionedRungeKutta\>", \ \
"\<DifferenceOrder\>" \[Rule] 
                10, \ "\<PositionVariables\>" \[Rule] {Y\_1[T]}}, \ 
          StartingStepSize \[Rule] step, \ 
          MaxSteps \[Rule] Infinity, "\<CompensatedSummation\>" \[Rule] 
            False];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(InvariantErrorPlot[H, \ vars, T, \ solnoca, \ 
        SymbolStyle \[Rule] Blue];\)\)}], "Input",
  CellLabel->"In[38]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00953907 0.0238095 5.36143e+14 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21459 -0.0125 -6 -9 ]
[.21459 -0.0125 6 0 ]
[.40537 -0.0125 -6 -9 ]
[.40537 -0.0125 6 0 ]
[.59615 -0.0125 -6 -9 ]
[.59615 -0.0125 6 0 ]
[.78694 -0.0125 -6 -9 ]
[.78694 -0.0125 6 0 ]
[.97772 -0.0125 -9 -9 ]
[.97772 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .15785 -49.5 -6.25 ]
[-0.0125 .15785 0 6.25 ]
[-0.0125 .29188 -37.5 -6.25 ]
[-0.0125 .29188 0 6.25 ]
[-0.0125 .42592 -49.5 -6.25 ]
[-0.0125 .42592 0 6.25 ]
[-0.0125 .55995 -37.5 -6.25 ]
[-0.0125 .55995 0 6.25 ]
[-0.0125 .69399 -55.5 -6.25 ]
[-0.0125 .69399 0 6.25 ]
[-0.0125 .82802 -49.5 -6.25 ]
[-0.0125 .82802 0 6.25 ]
[-0.0125 .96206 -55.5 -6.25 ]
[-0.0125 .96206 0 6.25 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21459 0 m
.21459 .00625 L
s
[(20)] .21459 -0.0125 0 1 Mshowa
.40537 0 m
.40537 .00625 L
s
[(40)] .40537 -0.0125 0 1 Mshowa
.59615 0 m
.59615 .00625 L
s
[(60)] .59615 -0.0125 0 1 Mshowa
.78694 0 m
.78694 .00625 L
s
[(80)] .78694 -0.0125 0 1 Mshowa
.97772 0 m
.97772 .00625 L
s
[(100)] .97772 -0.0125 0 1 Mshowa
.125 Mabswid
.0715 0 m
.0715 .00375 L
s
.1192 0 m
.1192 .00375 L
s
.1669 0 m
.1669 .00375 L
s
.26229 0 m
.26229 .00375 L
s
.30998 0 m
.30998 .00375 L
s
.35768 0 m
.35768 .00375 L
s
.45307 0 m
.45307 .00375 L
s
.50076 0 m
.50076 .00375 L
s
.54846 0 m
.54846 .00375 L
s
.64385 0 m
.64385 .00375 L
s
.69154 0 m
.69154 .00375 L
s
.73924 0 m
.73924 .00375 L
s
.83463 0 m
.83463 .00375 L
s
.88233 0 m
.88233 .00375 L
s
.93002 0 m
.93002 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .15785 m
.00625 .15785 L
s
gsave
-0.0125 .15785 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .29188 m
.00625 .29188 L
s
gsave
-0.0125 .29188 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .42592 m
.00625 .42592 L
s
gsave
-0.0125 .42592 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(7.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-16) show
grestore
0 .55995 m
.00625 .55995 L
s
gsave
-0.0125 .55995 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-15) show
grestore
0 .69399 m
.00625 .69399 L
s
gsave
-0.0125 .69399 -55.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.25) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-15) show
grestore
0 .82802 m
.00625 .82802 L
s
gsave
-0.0125 .82802 -49.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-15) show
grestore
0 .96206 m
.00625 .96206 L
s
gsave
-0.0125 .96206 -55.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1.75) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-15) show
grestore
.125 Mabswid
0 .05062 m
.00375 .05062 L
s
0 .07742 m
.00375 .07742 L
s
0 .10423 m
.00375 .10423 L
s
0 .13104 m
.00375 .13104 L
s
0 .18465 m
.00375 .18465 L
s
0 .21146 m
.00375 .21146 L
s
0 .23827 m
.00375 .23827 L
s
0 .26507 m
.00375 .26507 L
s
0 .31869 m
.00375 .31869 L
s
0 .3455 m
.00375 .3455 L
s
0 .3723 m
.00375 .3723 L
s
0 .39911 m
.00375 .39911 L
s
0 .45272 m
.00375 .45272 L
s
0 .47953 m
.00375 .47953 L
s
0 .50634 m
.00375 .50634 L
s
0 .53315 m
.00375 .53315 L
s
0 .58676 m
.00375 .58676 L
s
0 .61357 m
.00375 .61357 L
s
0 .64037 m
.00375 .64037 L
s
0 .66718 m
.00375 .66718 L
s
0 .7208 m
.00375 .7208 L
s
0 .7476 m
.00375 .7476 L
s
0 .77441 m
.00375 .77441 L
s
0 .80122 m
.00375 .80122 L
s
0 .85483 m
.00375 .85483 L
s
0 .88164 m
.00375 .88164 L
s
0 .90845 m
.00375 .90845 L
s
0 .93525 m
.00375 .93525 L
s
0 .98887 m
.00375 .98887 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21459 .99375 m
.21459 1 L
s
.40537 .99375 m
.40537 1 L
s
.59615 .99375 m
.59615 1 L
s
.78694 .99375 m
.78694 1 L
s
.97772 .99375 m
.97772 1 L
s
.125 Mabswid
.0715 .99625 m
.0715 1 L
s
.1192 .99625 m
.1192 1 L
s
.1669 .99625 m
.1669 1 L
s
.26229 .99625 m
.26229 1 L
s
.30998 .99625 m
.30998 1 L
s
.35768 .99625 m
.35768 1 L
s
.45307 .99625 m
.45307 1 L
s
.50076 .99625 m
.50076 1 L
s
.54846 .99625 m
.54846 1 L
s
.64385 .99625 m
.64385 1 L
s
.69154 .99625 m
.69154 1 L
s
.73924 .99625 m
.73924 1 L
s
.83463 .99625 m
.83463 1 L
s
.88233 .99625 m
.88233 1 L
s
.93002 .99625 m
.93002 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .15785 m
1 .15785 L
s
.99375 .29188 m
1 .29188 L
s
.99375 .42592 m
1 .42592 L
s
.99375 .55995 m
1 .55995 L
s
.99375 .69399 m
1 .69399 L
s
.99375 .82802 m
1 .82802 L
s
.99375 .96206 m
1 .96206 L
s
.125 Mabswid
.99625 .05062 m
1 .05062 L
s
.99625 .07742 m
1 .07742 L
s
.99625 .10423 m
1 .10423 L
s
.99625 .13104 m
1 .13104 L
s
.99625 .18465 m
1 .18465 L
s
.99625 .21146 m
1 .21146 L
s
.99625 .23827 m
1 .23827 L
s
.99625 .26507 m
1 .26507 L
s
.99625 .31869 m
1 .31869 L
s
.99625 .3455 m
1 .3455 L
s
.99625 .3723 m
1 .3723 L
s
.99625 .39911 m
1 .39911 L
s
.99625 .45272 m
1 .45272 L
s
.99625 .47953 m
1 .47953 L
s
.99625 .50634 m
1 .50634 L
s
.99625 .53315 m
1 .53315 L
s
.99625 .58676 m
1 .58676 L
s
.99625 .61357 m
1 .61357 L
s
.99625 .64037 m
1 .64037 L
s
.99625 .66718 m
1 .66718 L
s
.99625 .7208 m
1 .7208 L
s
.99625 .7476 m
1 .7476 L
s
.99625 .77441 m
1 .77441 L
s
.99625 .80122 m
1 .80122 L
s
.99625 .85483 m
1 .85483 L
s
.99625 .88164 m
1 .88164 L
s
.99625 .90845 m
1 .90845 L
s
.99625 .93525 m
1 .93525 L
s
.99625 .98887 m
1 .98887 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 1 r
.0001 w
.02381 .02381 -1.875 0 Mabsadd m
.02381 .02381 0 2.5 Mabsadd L
.02381 .02381 1.875 0 Mabsadd L
.02381 .02381 0 -2.5 Mabsadd L
.02381 .02381 -1.875 0 Mabsadd L closepath F
.02686 .14286 -1.875 0 Mabsadd m
.02686 .14286 0 2.5 Mabsadd L
.02686 .14286 1.875 0 Mabsadd L
.02686 .14286 0 -2.5 Mabsadd L
.02686 .14286 -1.875 0 Mabsadd L closepath F
.02991 .05357 -1.875 0 Mabsadd m
.02991 .05357 0 2.5 Mabsadd L
.02991 .05357 1.875 0 Mabsadd L
.02991 .05357 0 -2.5 Mabsadd L
.02991 .05357 -1.875 0 Mabsadd L closepath F
.03297 .08333 -1.875 0 Mabsadd m
.03297 .08333 0 2.5 Mabsadd L
.03297 .08333 1.875 0 Mabsadd L
.03297 .08333 0 -2.5 Mabsadd L
.03297 .08333 -1.875 0 Mabsadd L closepath F
.03602 .05357 -1.875 0 Mabsadd m
.03602 .05357 0 2.5 Mabsadd L
.03602 .05357 1.875 0 Mabsadd L
.03602 .05357 0 -2.5 Mabsadd L
.03602 .05357 -1.875 0 Mabsadd L closepath F
.03907 .05357 -1.875 0 Mabsadd m
.03907 .05357 0 2.5 Mabsadd L
.03907 .05357 1.875 0 Mabsadd L
.03907 .05357 0 -2.5 Mabsadd L
.03907 .05357 -1.875 0 Mabsadd L closepath F
.04212 .05357 -1.875 0 Mabsadd m
.04212 .05357 0 2.5 Mabsadd L
.04212 .05357 1.875 0 Mabsadd L
.04212 .05357 0 -2.5 Mabsadd L
.04212 .05357 -1.875 0 Mabsadd L closepath F
.04518 .08333 -1.875 0 Mabsadd m
.04518 .08333 0 2.5 Mabsadd L
.04518 .08333 1.875 0 Mabsadd L
.04518 .08333 0 -2.5 Mabsadd L
.04518 .08333 -1.875 0 Mabsadd L closepath F
.04823 .02381 -1.875 0 Mabsadd m
.04823 .02381 0 2.5 Mabsadd L
.04823 .02381 1.875 0 Mabsadd L
.04823 .02381 0 -2.5 Mabsadd L
.04823 .02381 -1.875 0 Mabsadd L closepath F
.05128 .05357 -1.875 0 Mabsadd m
.05128 .05357 0 2.5 Mabsadd L
.05128 .05357 1.875 0 Mabsadd L
.05128 .05357 0 -2.5 Mabsadd L
.05128 .05357 -1.875 0 Mabsadd L closepath F
.05433 .14286 -1.875 0 Mabsadd m
.05433 .14286 0 2.5 Mabsadd L
.05433 .14286 1.875 0 Mabsadd L
.05433 .14286 0 -2.5 Mabsadd L
.05433 .14286 -1.875 0 Mabsadd L closepath F
.05739 .1131 -1.875 0 Mabsadd m
.05739 .1131 0 2.5 Mabsadd L
.05739 .1131 1.875 0 Mabsadd L
.05739 .1131 0 -2.5 Mabsadd L
.05739 .1131 -1.875 0 Mabsadd L closepath F
.06044 .20238 -1.875 0 Mabsadd m
.06044 .20238 0 2.5 Mabsadd L
.06044 .20238 1.875 0 Mabsadd L
.06044 .20238 0 -2.5 Mabsadd L
.06044 .20238 -1.875 0 Mabsadd L closepath F
.06349 .08333 -1.875 0 Mabsadd m
.06349 .08333 0 2.5 Mabsadd L
.06349 .08333 1.875 0 Mabsadd L
.06349 .08333 0 -2.5 Mabsadd L
.06349 .08333 -1.875 0 Mabsadd L closepath F
.06654 .1131 -1.875 0 Mabsadd m
.06654 .1131 0 2.5 Mabsadd L
.06654 .1131 1.875 0 Mabsadd L
.06654 .1131 0 -2.5 Mabsadd L
.06654 .1131 -1.875 0 Mabsadd L closepath F
.0696 .05357 -1.875 0 Mabsadd m
.0696 .05357 0 2.5 Mabsadd L
.0696 .05357 1.875 0 Mabsadd L
.0696 .05357 0 -2.5 Mabsadd L
.0696 .05357 -1.875 0 Mabsadd L closepath F
.07265 .02381 -1.875 0 Mabsadd m
.07265 .02381 0 2.5 Mabsadd L
.07265 .02381 1.875 0 Mabsadd L
.07265 .02381 0 -2.5 Mabsadd L
.07265 .02381 -1.875 0 Mabsadd L closepath F
.0757 .08333 -1.875 0 Mabsadd m
.0757 .08333 0 2.5 Mabsadd L
.0757 .08333 1.875 0 Mabsadd L
.0757 .08333 0 -2.5 Mabsadd L
.0757 .08333 -1.875 0 Mabsadd L closepath F
.07875 .08333 -1.875 0 Mabsadd m
.07875 .08333 0 2.5 Mabsadd L
.07875 .08333 1.875 0 Mabsadd L
.07875 .08333 0 -2.5 Mabsadd L
.07875 .08333 -1.875 0 Mabsadd L closepath F
.08181 .08333 -1.875 0 Mabsadd m
.08181 .08333 0 2.5 Mabsadd L
.08181 .08333 1.875 0 Mabsadd L
.08181 .08333 0 -2.5 Mabsadd L
.08181 .08333 -1.875 0 Mabsadd L closepath F
.08486 .02381 -1.875 0 Mabsadd m
.08486 .02381 0 2.5 Mabsadd L
.08486 .02381 1.875 0 Mabsadd L
.08486 .02381 0 -2.5 Mabsadd L
.08486 .02381 -1.875 0 Mabsadd L closepath F
.08791 .14286 -1.875 0 Mabsadd m
.08791 .14286 0 2.5 Mabsadd L
.08791 .14286 1.875 0 Mabsadd L
.08791 .14286 0 -2.5 Mabsadd L
.08791 .14286 -1.875 0 Mabsadd L closepath F
.09096 .14286 -1.875 0 Mabsadd m
.09096 .14286 0 2.5 Mabsadd L
.09096 .14286 1.875 0 Mabsadd L
.09096 .14286 0 -2.5 Mabsadd L
.09096 .14286 -1.875 0 Mabsadd L closepath F
.09402 .08333 -1.875 0 Mabsadd m
.09402 .08333 0 2.5 Mabsadd L
.09402 .08333 1.875 0 Mabsadd L
.09402 .08333 0 -2.5 Mabsadd L
.09402 .08333 -1.875 0 Mabsadd L closepath F
.09707 .02381 -1.875 0 Mabsadd m
.09707 .02381 0 2.5 Mabsadd L
.09707 .02381 1.875 0 Mabsadd L
.09707 .02381 0 -2.5 Mabsadd L
.09707 .02381 -1.875 0 Mabsadd L closepath F
.10012 .08333 -1.875 0 Mabsadd m
.10012 .08333 0 2.5 Mabsadd L
.10012 .08333 1.875 0 Mabsadd L
.10012 .08333 0 -2.5 Mabsadd L
.10012 .08333 -1.875 0 Mabsadd L closepath F
.10317 .20238 -1.875 0 Mabsadd m
.10317 .20238 0 2.5 Mabsadd L
.10317 .20238 1.875 0 Mabsadd L
.10317 .20238 0 -2.5 Mabsadd L
.10317 .20238 -1.875 0 Mabsadd L closepath F
.10623 .20238 -1.875 0 Mabsadd m
.10623 .20238 0 2.5 Mabsadd L
.10623 .20238 1.875 0 Mabsadd L
.10623 .20238 0 -2.5 Mabsadd L
.10623 .20238 -1.875 0 Mabsadd L closepath F
.10928 .17262 -1.875 0 Mabsadd m
.10928 .17262 0 2.5 Mabsadd L
.10928 .17262 1.875 0 Mabsadd L
.10928 .17262 0 -2.5 Mabsadd L
.10928 .17262 -1.875 0 Mabsadd L closepath F
.11233 .23214 -1.875 0 Mabsadd m
.11233 .23214 0 2.5 Mabsadd L
.11233 .23214 1.875 0 Mabsadd L
.11233 .23214 0 -2.5 Mabsadd L
.11233 .23214 -1.875 0 Mabsadd L closepath F
.11538 .23214 -1.875 0 Mabsadd m
.11538 .23214 0 2.5 Mabsadd L
.11538 .23214 1.875 0 Mabsadd L
.11538 .23214 0 -2.5 Mabsadd L
.11538 .23214 -1.875 0 Mabsadd L closepath F
.11844 .2619 -1.875 0 Mabsadd m
.11844 .2619 0 2.5 Mabsadd L
.11844 .2619 1.875 0 Mabsadd L
.11844 .2619 0 -2.5 Mabsadd L
.11844 .2619 -1.875 0 Mabsadd L closepath F
.12149 .2619 -1.875 0 Mabsadd m
.12149 .2619 0 2.5 Mabsadd L
.12149 .2619 1.875 0 Mabsadd L
.12149 .2619 0 -2.5 Mabsadd L
.12149 .2619 -1.875 0 Mabsadd L closepath F
.12454 .35119 -1.875 0 Mabsadd m
.12454 .35119 0 2.5 Mabsadd L
.12454 .35119 1.875 0 Mabsadd L
.12454 .35119 0 -2.5 Mabsadd L
.12454 .35119 -1.875 0 Mabsadd L closepath F
.12759 .29167 -1.875 0 Mabsadd m
.12759 .29167 0 2.5 Mabsadd L
.12759 .29167 1.875 0 Mabsadd L
.12759 .29167 0 -2.5 Mabsadd L
.12759 .29167 -1.875 0 Mabsadd L closepath F
.13065 .20238 -1.875 0 Mabsadd m
.13065 .20238 0 2.5 Mabsadd L
.13065 .20238 1.875 0 Mabsadd L
.13065 .20238 0 -2.5 Mabsadd L
.13065 .20238 -1.875 0 Mabsadd L closepath F
.1337 .20238 -1.875 0 Mabsadd m
.1337 .20238 0 2.5 Mabsadd L
.1337 .20238 1.875 0 Mabsadd L
.1337 .20238 0 -2.5 Mabsadd L
.1337 .20238 -1.875 0 Mabsadd L closepath F
.13675 .2619 -1.875 0 Mabsadd m
.13675 .2619 0 2.5 Mabsadd L
.13675 .2619 1.875 0 Mabsadd L
.13675 .2619 0 -2.5 Mabsadd L
.13675 .2619 -1.875 0 Mabsadd L closepath F
.1398 .20238 -1.875 0 Mabsadd m
.1398 .20238 0 2.5 Mabsadd L
.1398 .20238 1.875 0 Mabsadd L
.1398 .20238 0 -2.5 Mabsadd L
.1398 .20238 -1.875 0 Mabsadd L closepath F
.14286 .17262 -1.875 0 Mabsadd m
.14286 .17262 0 2.5 Mabsadd L
.14286 .17262 1.875 0 Mabsadd L
.14286 .17262 0 -2.5 Mabsadd L
.14286 .17262 -1.875 0 Mabsadd L closepath F
.14591 .20238 -1.875 0 Mabsadd m
.14591 .20238 0 2.5 Mabsadd L
.14591 .20238 1.875 0 Mabsadd L
.14591 .20238 0 -2.5 Mabsadd L
.14591 .20238 -1.875 0 Mabsadd L closepath F
.14896 .23214 -1.875 0 Mabsadd m
.14896 .23214 0 2.5 Mabsadd L
.14896 .23214 1.875 0 Mabsadd L
.14896 .23214 0 -2.5 Mabsadd L
.14896 .23214 -1.875 0 Mabsadd L closepath F
.15201 .23214 -1.875 0 Mabsadd m
.15201 .23214 0 2.5 Mabsadd L
.15201 .23214 1.875 0 Mabsadd L
.15201 .23214 0 -2.5 Mabsadd L
.15201 .23214 -1.875 0 Mabsadd L closepath F
.15507 .23214 -1.875 0 Mabsadd m
.15507 .23214 0 2.5 Mabsadd L
.15507 .23214 1.875 0 Mabsadd L
.15507 .23214 0 -2.5 Mabsadd L
.15507 .23214 -1.875 0 Mabsadd L closepath F
.15812 .23214 -1.875 0 Mabsadd m
.15812 .23214 0 2.5 Mabsadd L
.15812 .23214 1.875 0 Mabsadd L
.15812 .23214 0 -2.5 Mabsadd L
.15812 .23214 -1.875 0 Mabsadd L closepath F
.16117 .20238 -1.875 0 Mabsadd m
.16117 .20238 0 2.5 Mabsadd L
.16117 .20238 1.875 0 Mabsadd L
.16117 .20238 0 -2.5 Mabsadd L
.16117 .20238 -1.875 0 Mabsadd L closepath F
.16422 .1131 -1.875 0 Mabsadd m
.16422 .1131 0 2.5 Mabsadd L
.16422 .1131 1.875 0 Mabsadd L
.16422 .1131 0 -2.5 Mabsadd L
.16422 .1131 -1.875 0 Mabsadd L closepath F
.16728 .08333 -1.875 0 Mabsadd m
.16728 .08333 0 2.5 Mabsadd L
.16728 .08333 1.875 0 Mabsadd L
.16728 .08333 0 -2.5 Mabsadd L
.16728 .08333 -1.875 0 Mabsadd L closepath F
.17033 .1131 -1.875 0 Mabsadd m
.17033 .1131 0 2.5 Mabsadd L
.17033 .1131 1.875 0 Mabsadd L
.17033 .1131 0 -2.5 Mabsadd L
.17033 .1131 -1.875 0 Mabsadd L closepath F
.17338 .08333 -1.875 0 Mabsadd m
.17338 .08333 0 2.5 Mabsadd L
.17338 .08333 1.875 0 Mabsadd L
.17338 .08333 0 -2.5 Mabsadd L
.17338 .08333 -1.875 0 Mabsadd L closepath F
.17643 .1131 -1.875 0 Mabsadd m
.17643 .1131 0 2.5 Mabsadd L
.17643 .1131 1.875 0 Mabsadd L
.17643 .1131 0 -2.5 Mabsadd L
.17643 .1131 -1.875 0 Mabsadd L closepath F
.17949 .14286 -1.875 0 Mabsadd m
.17949 .14286 0 2.5 Mabsadd L
.17949 .14286 1.875 0 Mabsadd L
.17949 .14286 0 -2.5 Mabsadd L
.17949 .14286 -1.875 0 Mabsadd L closepath F
.18254 .08333 -1.875 0 Mabsadd m
.18254 .08333 0 2.5 Mabsadd L
.18254 .08333 1.875 0 Mabsadd L
.18254 .08333 0 -2.5 Mabsadd L
.18254 .08333 -1.875 0 Mabsadd L closepath F
.18559 .08333 -1.875 0 Mabsadd m
.18559 .08333 0 2.5 Mabsadd L
.18559 .08333 1.875 0 Mabsadd L
.18559 .08333 0 -2.5 Mabsadd L
.18559 .08333 -1.875 0 Mabsadd L closepath F
.18864 .1131 -1.875 0 Mabsadd m
.18864 .1131 0 2.5 Mabsadd L
.18864 .1131 1.875 0 Mabsadd L
.18864 .1131 0 -2.5 Mabsadd L
.18864 .1131 -1.875 0 Mabsadd L closepath F
.1917 .1131 -1.875 0 Mabsadd m
.1917 .1131 0 2.5 Mabsadd L
.1917 .1131 1.875 0 Mabsadd L
.1917 .1131 0 -2.5 Mabsadd L
.1917 .1131 -1.875 0 Mabsadd L closepath F
.19475 .1131 -1.875 0 Mabsadd m
.19475 .1131 0 2.5 Mabsadd L
.19475 .1131 1.875 0 Mabsadd L
.19475 .1131 0 -2.5 Mabsadd L
.19475 .1131 -1.875 0 Mabsadd L closepath F
.1978 .14286 -1.875 0 Mabsadd m
.1978 .14286 0 2.5 Mabsadd L
.1978 .14286 1.875 0 Mabsadd L
.1978 .14286 0 -2.5 Mabsadd L
.1978 .14286 -1.875 0 Mabsadd L closepath F
.20085 .1131 -1.875 0 Mabsadd m
.20085 .1131 0 2.5 Mabsadd L
.20085 .1131 1.875 0 Mabsadd L
.20085 .1131 0 -2.5 Mabsadd L
.20085 .1131 -1.875 0 Mabsadd L closepath F
.20391 .08333 -1.875 0 Mabsadd m
.20391 .08333 0 2.5 Mabsadd L
.20391 .08333 1.875 0 Mabsadd L
.20391 .08333 0 -2.5 Mabsadd L
.20391 .08333 -1.875 0 Mabsadd L closepath F
.20696 .17262 -1.875 0 Mabsadd m
.20696 .17262 0 2.5 Mabsadd L
.20696 .17262 1.875 0 Mabsadd L
.20696 .17262 0 -2.5 Mabsadd L
.20696 .17262 -1.875 0 Mabsadd L closepath F
.21001 .14286 -1.875 0 Mabsadd m
.21001 .14286 0 2.5 Mabsadd L
.21001 .14286 1.875 0 Mabsadd L
.21001 .14286 0 -2.5 Mabsadd L
.21001 .14286 -1.875 0 Mabsadd L closepath F
.21306 .17262 -1.875 0 Mabsadd m
.21306 .17262 0 2.5 Mabsadd L
.21306 .17262 1.875 0 Mabsadd L
.21306 .17262 0 -2.5 Mabsadd L
.21306 .17262 -1.875 0 Mabsadd L closepath F
.21612 .1131 -1.875 0 Mabsadd m
.21612 .1131 0 2.5 Mabsadd L
.21612 .1131 1.875 0 Mabsadd L
.21612 .1131 0 -2.5 Mabsadd L
.21612 .1131 -1.875 0 Mabsadd L closepath F
.21917 .14286 -1.875 0 Mabsadd m
.21917 .14286 0 2.5 Mabsadd L
.21917 .14286 1.875 0 Mabsadd L
.21917 .14286 0 -2.5 Mabsadd L
.21917 .14286 -1.875 0 Mabsadd L closepath F
.22222 .08333 -1.875 0 Mabsadd m
.22222 .08333 0 2.5 Mabsadd L
.22222 .08333 1.875 0 Mabsadd L
.22222 .08333 0 -2.5 Mabsadd L
.22222 .08333 -1.875 0 Mabsadd L closepath F
.22527 .20238 -1.875 0 Mabsadd m
.22527 .20238 0 2.5 Mabsadd L
.22527 .20238 1.875 0 Mabsadd L
.22527 .20238 0 -2.5 Mabsadd L
.22527 .20238 -1.875 0 Mabsadd L closepath F
.22833 .20238 -1.875 0 Mabsadd m
.22833 .20238 0 2.5 Mabsadd L
.22833 .20238 1.875 0 Mabsadd L
.22833 .20238 0 -2.5 Mabsadd L
.22833 .20238 -1.875 0 Mabsadd L closepath F
.23138 .20238 -1.875 0 Mabsadd m
.23138 .20238 0 2.5 Mabsadd L
.23138 .20238 1.875 0 Mabsadd L
.23138 .20238 0 -2.5 Mabsadd L
.23138 .20238 -1.875 0 Mabsadd L closepath F
.23443 .29167 -1.875 0 Mabsadd m
.23443 .29167 0 2.5 Mabsadd L
.23443 .29167 1.875 0 Mabsadd L
.23443 .29167 0 -2.5 Mabsadd L
.23443 .29167 -1.875 0 Mabsadd L closepath F
.23748 .20238 -1.875 0 Mabsadd m
.23748 .20238 0 2.5 Mabsadd L
.23748 .20238 1.875 0 Mabsadd L
.23748 .20238 0 -2.5 Mabsadd L
.23748 .20238 -1.875 0 Mabsadd L closepath F
.24054 .20238 -1.875 0 Mabsadd m
.24054 .20238 0 2.5 Mabsadd L
.24054 .20238 1.875 0 Mabsadd L
.24054 .20238 0 -2.5 Mabsadd L
.24054 .20238 -1.875 0 Mabsadd L closepath F
.24359 .20238 -1.875 0 Mabsadd m
.24359 .20238 0 2.5 Mabsadd L
.24359 .20238 1.875 0 Mabsadd L
.24359 .20238 0 -2.5 Mabsadd L
.24359 .20238 -1.875 0 Mabsadd L closepath F
.24664 .20238 -1.875 0 Mabsadd m
.24664 .20238 0 2.5 Mabsadd L
.24664 .20238 1.875 0 Mabsadd L
.24664 .20238 0 -2.5 Mabsadd L
.24664 .20238 -1.875 0 Mabsadd L closepath F
.24969 .14286 -1.875 0 Mabsadd m
.24969 .14286 0 2.5 Mabsadd L
.24969 .14286 1.875 0 Mabsadd L
.24969 .14286 0 -2.5 Mabsadd L
.24969 .14286 -1.875 0 Mabsadd L closepath F
.25275 .1131 -1.875 0 Mabsadd m
.25275 .1131 0 2.5 Mabsadd L
.25275 .1131 1.875 0 Mabsadd L
.25275 .1131 0 -2.5 Mabsadd L
.25275 .1131 -1.875 0 Mabsadd L closepath F
.2558 .08333 -1.875 0 Mabsadd m
.2558 .08333 0 2.5 Mabsadd L
.2558 .08333 1.875 0 Mabsadd L
.2558 .08333 0 -2.5 Mabsadd L
.2558 .08333 -1.875 0 Mabsadd L closepath F
.25885 .1131 -1.875 0 Mabsadd m
.25885 .1131 0 2.5 Mabsadd L
.25885 .1131 1.875 0 Mabsadd L
.25885 .1131 0 -2.5 Mabsadd L
.25885 .1131 -1.875 0 Mabsadd L closepath F
.2619 .14286 -1.875 0 Mabsadd m
.2619 .14286 0 2.5 Mabsadd L
.2619 .14286 1.875 0 Mabsadd L
.2619 .14286 0 -2.5 Mabsadd L
.2619 .14286 -1.875 0 Mabsadd L closepath F
.26496 .20238 -1.875 0 Mabsadd m
.26496 .20238 0 2.5 Mabsadd L
.26496 .20238 1.875 0 Mabsadd L
.26496 .20238 0 -2.5 Mabsadd L
.26496 .20238 -1.875 0 Mabsadd L closepath F
.26801 .20238 -1.875 0 Mabsadd m
.26801 .20238 0 2.5 Mabsadd L
.26801 .20238 1.875 0 Mabsadd L
.26801 .20238 0 -2.5 Mabsadd L
.26801 .20238 -1.875 0 Mabsadd L closepath F
.27106 .2619 -1.875 0 Mabsadd m
.27106 .2619 0 2.5 Mabsadd L
.27106 .2619 1.875 0 Mabsadd L
.27106 .2619 0 -2.5 Mabsadd L
.27106 .2619 -1.875 0 Mabsadd L closepath F
.27411 .20238 -1.875 0 Mabsadd m
.27411 .20238 0 2.5 Mabsadd L
.27411 .20238 1.875 0 Mabsadd L
.27411 .20238 0 -2.5 Mabsadd L
.27411 .20238 -1.875 0 Mabsadd L closepath F
.27717 .14286 -1.875 0 Mabsadd m
.27717 .14286 0 2.5 Mabsadd L
.27717 .14286 1.875 0 Mabsadd L
.27717 .14286 0 -2.5 Mabsadd L
.27717 .14286 -1.875 0 Mabsadd L closepath F
.28022 .17262 -1.875 0 Mabsadd m
.28022 .17262 0 2.5 Mabsadd L
.28022 .17262 1.875 0 Mabsadd L
.28022 .17262 0 -2.5 Mabsadd L
.28022 .17262 -1.875 0 Mabsadd L closepath F
.28327 .20238 -1.875 0 Mabsadd m
.28327 .20238 0 2.5 Mabsadd L
.28327 .20238 1.875 0 Mabsadd L
.28327 .20238 0 -2.5 Mabsadd L
.28327 .20238 -1.875 0 Mabsadd L closepath F
.28632 .14286 -1.875 0 Mabsadd m
.28632 .14286 0 2.5 Mabsadd L
.28632 .14286 1.875 0 Mabsadd L
.28632 .14286 0 -2.5 Mabsadd L
.28632 .14286 -1.875 0 Mabsadd L closepath F
.28938 .08333 -1.875 0 Mabsadd m
.28938 .08333 0 2.5 Mabsadd L
.28938 .08333 1.875 0 Mabsadd L
.28938 .08333 0 -2.5 Mabsadd L
.28938 .08333 -1.875 0 Mabsadd L closepath F
.29243 .08333 -1.875 0 Mabsadd m
.29243 .08333 0 2.5 Mabsadd L
.29243 .08333 1.875 0 Mabsadd L
.29243 .08333 0 -2.5 Mabsadd L
.29243 .08333 -1.875 0 Mabsadd L closepath F
.29548 .08333 -1.875 0 Mabsadd m
.29548 .08333 0 2.5 Mabsadd L
.29548 .08333 1.875 0 Mabsadd L
.29548 .08333 0 -2.5 Mabsadd L
.29548 .08333 -1.875 0 Mabsadd L closepath F
.29853 .02381 -1.875 0 Mabsadd m
.29853 .02381 0 2.5 Mabsadd L
.29853 .02381 1.875 0 Mabsadd L
.29853 .02381 0 -2.5 Mabsadd L
.29853 .02381 -1.875 0 Mabsadd L closepath F
.30159 .14286 -1.875 0 Mabsadd m
.30159 .14286 0 2.5 Mabsadd L
.30159 .14286 1.875 0 Mabsadd L
.30159 .14286 0 -2.5 Mabsadd L
.30159 .14286 -1.875 0 Mabsadd L closepath F
.30464 .08333 -1.875 0 Mabsadd m
.30464 .08333 0 2.5 Mabsadd L
.30464 .08333 1.875 0 Mabsadd L
.30464 .08333 0 -2.5 Mabsadd L
.30464 .08333 -1.875 0 Mabsadd L closepath F
.30769 .14286 -1.875 0 Mabsadd m
.30769 .14286 0 2.5 Mabsadd L
.30769 .14286 1.875 0 Mabsadd L
.30769 .14286 0 -2.5 Mabsadd L
.30769 .14286 -1.875 0 Mabsadd L closepath F
.31074 .14286 -1.875 0 Mabsadd m
.31074 .14286 0 2.5 Mabsadd L
.31074 .14286 1.875 0 Mabsadd L
.31074 .14286 0 -2.5 Mabsadd L
.31074 .14286 -1.875 0 Mabsadd L closepath F
.3138 .14286 -1.875 0 Mabsadd m
.3138 .14286 0 2.5 Mabsadd L
.3138 .14286 1.875 0 Mabsadd L
.3138 .14286 0 -2.5 Mabsadd L
.3138 .14286 -1.875 0 Mabsadd L closepath F
.31685 .32143 -1.875 0 Mabsadd m
.31685 .32143 0 2.5 Mabsadd L
.31685 .32143 1.875 0 Mabsadd L
.31685 .32143 0 -2.5 Mabsadd L
.31685 .32143 -1.875 0 Mabsadd L closepath F
.3199 .32143 -1.875 0 Mabsadd m
.3199 .32143 0 2.5 Mabsadd L
.3199 .32143 1.875 0 Mabsadd L
.3199 .32143 0 -2.5 Mabsadd L
.3199 .32143 -1.875 0 Mabsadd L closepath F
.32295 .38095 -1.875 0 Mabsadd m
.32295 .38095 0 2.5 Mabsadd L
.32295 .38095 1.875 0 Mabsadd L
.32295 .38095 0 -2.5 Mabsadd L
.32295 .38095 -1.875 0 Mabsadd L closepath F
.32601 .38095 -1.875 0 Mabsadd m
.32601 .38095 0 2.5 Mabsadd L
.32601 .38095 1.875 0 Mabsadd L
.32601 .38095 0 -2.5 Mabsadd L
.32601 .38095 -1.875 0 Mabsadd L closepath F
.32906 .32143 -1.875 0 Mabsadd m
.32906 .32143 0 2.5 Mabsadd L
.32906 .32143 1.875 0 Mabsadd L
.32906 .32143 0 -2.5 Mabsadd L
.32906 .32143 -1.875 0 Mabsadd L closepath F
.33211 .38095 -1.875 0 Mabsadd m
.33211 .38095 0 2.5 Mabsadd L
.33211 .38095 1.875 0 Mabsadd L
.33211 .38095 0 -2.5 Mabsadd L
.33211 .38095 -1.875 0 Mabsadd L closepath F
.33516 .38095 -1.875 0 Mabsadd m
.33516 .38095 0 2.5 Mabsadd L
.33516 .38095 1.875 0 Mabsadd L
.33516 .38095 0 -2.5 Mabsadd L
.33516 .38095 -1.875 0 Mabsadd L closepath F
.33822 .38095 -1.875 0 Mabsadd m
.33822 .38095 0 2.5 Mabsadd L
.33822 .38095 1.875 0 Mabsadd L
.33822 .38095 0 -2.5 Mabsadd L
.33822 .38095 -1.875 0 Mabsadd L closepath F
.34127 .5 -1.875 0 Mabsadd m
.34127 .5 0 2.5 Mabsadd L
.34127 .5 1.875 0 Mabsadd L
.34127 .5 0 -2.5 Mabsadd L
.34127 .5 -1.875 0 Mabsadd L closepath F
.34432 .44048 -1.875 0 Mabsadd m
.34432 .44048 0 2.5 Mabsadd L
.34432 .44048 1.875 0 Mabsadd L
.34432 .44048 0 -2.5 Mabsadd L
.34432 .44048 -1.875 0 Mabsadd L closepath F
.34737 .55952 -1.875 0 Mabsadd m
.34737 .55952 0 2.5 Mabsadd L
.34737 .55952 1.875 0 Mabsadd L
.34737 .55952 0 -2.5 Mabsadd L
.34737 .55952 -1.875 0 Mabsadd L closepath F
.35043 .55952 -1.875 0 Mabsadd m
.35043 .55952 0 2.5 Mabsadd L
.35043 .55952 1.875 0 Mabsadd L
.35043 .55952 0 -2.5 Mabsadd L
.35043 .55952 -1.875 0 Mabsadd L closepath F
.35348 .55952 -1.875 0 Mabsadd m
.35348 .55952 0 2.5 Mabsadd L
.35348 .55952 1.875 0 Mabsadd L
.35348 .55952 0 -2.5 Mabsadd L
.35348 .55952 -1.875 0 Mabsadd L closepath F
.35653 .55952 -1.875 0 Mabsadd m
.35653 .55952 0 2.5 Mabsadd L
.35653 .55952 1.875 0 Mabsadd L
.35653 .55952 0 -2.5 Mabsadd L
.35653 .55952 -1.875 0 Mabsadd L closepath F
.35958 .5 -1.875 0 Mabsadd m
.35958 .5 0 2.5 Mabsadd L
.35958 .5 1.875 0 Mabsadd L
.35958 .5 0 -2.5 Mabsadd L
.35958 .5 -1.875 0 Mabsadd L closepath F
.36264 .5 -1.875 0 Mabsadd m
.36264 .5 0 2.5 Mabsadd L
.36264 .5 1.875 0 Mabsadd L
.36264 .5 0 -2.5 Mabsadd L
.36264 .5 -1.875 0 Mabsadd L closepath F
.36569 .55952 -1.875 0 Mabsadd m
.36569 .55952 0 2.5 Mabsadd L
.36569 .55952 1.875 0 Mabsadd L
.36569 .55952 0 -2.5 Mabsadd L
.36569 .55952 -1.875 0 Mabsadd L closepath F
.36874 .55952 -1.875 0 Mabsadd m
.36874 .55952 0 2.5 Mabsadd L
.36874 .55952 1.875 0 Mabsadd L
.36874 .55952 0 -2.5 Mabsadd L
.36874 .55952 -1.875 0 Mabsadd L closepath F
.37179 .55952 -1.875 0 Mabsadd m
.37179 .55952 0 2.5 Mabsadd L
.37179 .55952 1.875 0 Mabsadd L
.37179 .55952 0 -2.5 Mabsadd L
.37179 .55952 -1.875 0 Mabsadd L closepath F
.37485 .61905 -1.875 0 Mabsadd m
.37485 .61905 0 2.5 Mabsadd L
.37485 .61905 1.875 0 Mabsadd L
.37485 .61905 0 -2.5 Mabsadd L
.37485 .61905 -1.875 0 Mabsadd L closepath F
.3779 .55952 -1.875 0 Mabsadd m
.3779 .55952 0 2.5 Mabsadd L
.3779 .55952 1.875 0 Mabsadd L
.3779 .55952 0 -2.5 Mabsadd L
.3779 .55952 -1.875 0 Mabsadd L closepath F
.38095 .5 -1.875 0 Mabsadd m
.38095 .5 0 2.5 Mabsadd L
.38095 .5 1.875 0 Mabsadd L
.38095 .5 0 -2.5 Mabsadd L
.38095 .5 -1.875 0 Mabsadd L closepath F
.384 .5 -1.875 0 Mabsadd m
.384 .5 0 2.5 Mabsadd L
.384 .5 1.875 0 Mabsadd L
.384 .5 0 -2.5 Mabsadd L
.384 .5 -1.875 0 Mabsadd L closepath F
.38706 .61905 -1.875 0 Mabsadd m
.38706 .61905 0 2.5 Mabsadd L
.38706 .61905 1.875 0 Mabsadd L
.38706 .61905 0 -2.5 Mabsadd L
.38706 .61905 -1.875 0 Mabsadd L closepath F
.39011 .61905 -1.875 0 Mabsadd m
.39011 .61905 0 2.5 Mabsadd L
.39011 .61905 1.875 0 Mabsadd L
.39011 .61905 0 -2.5 Mabsadd L
.39011 .61905 -1.875 0 Mabsadd L closepath F
.39316 .67857 -1.875 0 Mabsadd m
.39316 .67857 0 2.5 Mabsadd L
.39316 .67857 1.875 0 Mabsadd L
.39316 .67857 0 -2.5 Mabsadd L
.39316 .67857 -1.875 0 Mabsadd L closepath F
.39621 .67857 -1.875 0 Mabsadd m
.39621 .67857 0 2.5 Mabsadd L
.39621 .67857 1.875 0 Mabsadd L
.39621 .67857 0 -2.5 Mabsadd L
.39621 .67857 -1.875 0 Mabsadd L closepath F
.39927 .67857 -1.875 0 Mabsadd m
.39927 .67857 0 2.5 Mabsadd L
.39927 .67857 1.875 0 Mabsadd L
.39927 .67857 0 -2.5 Mabsadd L
.39927 .67857 -1.875 0 Mabsadd L closepath F
.40232 .61905 -1.875 0 Mabsadd m
.40232 .61905 0 2.5 Mabsadd L
.40232 .61905 1.875 0 Mabsadd L
.40232 .61905 0 -2.5 Mabsadd L
.40232 .61905 -1.875 0 Mabsadd L closepath F
.40537 .61905 -1.875 0 Mabsadd m
.40537 .61905 0 2.5 Mabsadd L
.40537 .61905 1.875 0 Mabsadd L
.40537 .61905 0 -2.5 Mabsadd L
.40537 .61905 -1.875 0 Mabsadd L closepath F
.40842 .5 -1.875 0 Mabsadd m
.40842 .5 0 2.5 Mabsadd L
.40842 .5 1.875 0 Mabsadd L
.40842 .5 0 -2.5 Mabsadd L
.40842 .5 -1.875 0 Mabsadd L closepath F
.41148 .61905 -1.875 0 Mabsadd m
.41148 .61905 0 2.5 Mabsadd L
.41148 .61905 1.875 0 Mabsadd L
.41148 .61905 0 -2.5 Mabsadd L
.41148 .61905 -1.875 0 Mabsadd L closepath F
.41453 .55952 -1.875 0 Mabsadd m
.41453 .55952 0 2.5 Mabsadd L
.41453 .55952 1.875 0 Mabsadd L
.41453 .55952 0 -2.5 Mabsadd L
.41453 .55952 -1.875 0 Mabsadd L closepath F
.41758 .55952 -1.875 0 Mabsadd m
.41758 .55952 0 2.5 Mabsadd L
.41758 .55952 1.875 0 Mabsadd L
.41758 .55952 0 -2.5 Mabsadd L
.41758 .55952 -1.875 0 Mabsadd L closepath F
.42063 .5 -1.875 0 Mabsadd m
.42063 .5 0 2.5 Mabsadd L
.42063 .5 1.875 0 Mabsadd L
.42063 .5 0 -2.5 Mabsadd L
.42063 .5 -1.875 0 Mabsadd L closepath F
.42369 .44048 -1.875 0 Mabsadd m
.42369 .44048 0 2.5 Mabsadd L
.42369 .44048 1.875 0 Mabsadd L
.42369 .44048 0 -2.5 Mabsadd L
.42369 .44048 -1.875 0 Mabsadd L closepath F
.42674 .38095 -1.875 0 Mabsadd m
.42674 .38095 0 2.5 Mabsadd L
.42674 .38095 1.875 0 Mabsadd L
.42674 .38095 0 -2.5 Mabsadd L
.42674 .38095 -1.875 0 Mabsadd L closepath F
.42979 .5 -1.875 0 Mabsadd m
.42979 .5 0 2.5 Mabsadd L
.42979 .5 1.875 0 Mabsadd L
.42979 .5 0 -2.5 Mabsadd L
.42979 .5 -1.875 0 Mabsadd L closepath F
.43284 .44048 -1.875 0 Mabsadd m
.43284 .44048 0 2.5 Mabsadd L
.43284 .44048 1.875 0 Mabsadd L
.43284 .44048 0 -2.5 Mabsadd L
.43284 .44048 -1.875 0 Mabsadd L closepath F
.4359 .38095 -1.875 0 Mabsadd m
.4359 .38095 0 2.5 Mabsadd L
.4359 .38095 1.875 0 Mabsadd L
.4359 .38095 0 -2.5 Mabsadd L
.4359 .38095 -1.875 0 Mabsadd L closepath F
.43895 .32143 -1.875 0 Mabsadd m
.43895 .32143 0 2.5 Mabsadd L
.43895 .32143 1.875 0 Mabsadd L
.43895 .32143 0 -2.5 Mabsadd L
.43895 .32143 -1.875 0 Mabsadd L closepath F
.442 .32143 -1.875 0 Mabsadd m
.442 .32143 0 2.5 Mabsadd L
.442 .32143 1.875 0 Mabsadd L
.442 .32143 0 -2.5 Mabsadd L
.442 .32143 -1.875 0 Mabsadd L closepath F
.44505 .32143 -1.875 0 Mabsadd m
.44505 .32143 0 2.5 Mabsadd L
.44505 .32143 1.875 0 Mabsadd L
.44505 .32143 0 -2.5 Mabsadd L
.44505 .32143 -1.875 0 Mabsadd L closepath F
.44811 .2619 -1.875 0 Mabsadd m
.44811 .2619 0 2.5 Mabsadd L
.44811 .2619 1.875 0 Mabsadd L
.44811 .2619 0 -2.5 Mabsadd L
.44811 .2619 -1.875 0 Mabsadd L closepath F
.45116 .2619 -1.875 0 Mabsadd m
.45116 .2619 0 2.5 Mabsadd L
.45116 .2619 1.875 0 Mabsadd L
.45116 .2619 0 -2.5 Mabsadd L
.45116 .2619 -1.875 0 Mabsadd L closepath F
.45421 .2619 -1.875 0 Mabsadd m
.45421 .2619 0 2.5 Mabsadd L
.45421 .2619 1.875 0 Mabsadd L
.45421 .2619 0 -2.5 Mabsadd L
.45421 .2619 -1.875 0 Mabsadd L closepath F
.45726 .2619 -1.875 0 Mabsadd m
.45726 .2619 0 2.5 Mabsadd L
.45726 .2619 1.875 0 Mabsadd L
.45726 .2619 0 -2.5 Mabsadd L
.45726 .2619 -1.875 0 Mabsadd L closepath F
.46032 .32143 -1.875 0 Mabsadd m
.46032 .32143 0 2.5 Mabsadd L
.46032 .32143 1.875 0 Mabsadd L
.46032 .32143 0 -2.5 Mabsadd L
.46032 .32143 -1.875 0 Mabsadd L closepath F
.46337 .38095 -1.875 0 Mabsadd m
.46337 .38095 0 2.5 Mabsadd L
.46337 .38095 1.875 0 Mabsadd L
.46337 .38095 0 -2.5 Mabsadd L
.46337 .38095 -1.875 0 Mabsadd L closepath F
.46642 .32143 -1.875 0 Mabsadd m
.46642 .32143 0 2.5 Mabsadd L
.46642 .32143 1.875 0 Mabsadd L
.46642 .32143 0 -2.5 Mabsadd L
.46642 .32143 -1.875 0 Mabsadd L closepath F
.46947 .2619 -1.875 0 Mabsadd m
.46947 .2619 0 2.5 Mabsadd L
.46947 .2619 1.875 0 Mabsadd L
.46947 .2619 0 -2.5 Mabsadd L
.46947 .2619 -1.875 0 Mabsadd L closepath F
.47253 .2619 -1.875 0 Mabsadd m
.47253 .2619 0 2.5 Mabsadd L
.47253 .2619 1.875 0 Mabsadd L
.47253 .2619 0 -2.5 Mabsadd L
.47253 .2619 -1.875 0 Mabsadd L closepath F
.47558 .32143 -1.875 0 Mabsadd m
.47558 .32143 0 2.5 Mabsadd L
.47558 .32143 1.875 0 Mabsadd L
.47558 .32143 0 -2.5 Mabsadd L
.47558 .32143 -1.875 0 Mabsadd L closepath F
.47863 .38095 -1.875 0 Mabsadd m
.47863 .38095 0 2.5 Mabsadd L
.47863 .38095 1.875 0 Mabsadd L
.47863 .38095 0 -2.5 Mabsadd L
.47863 .38095 -1.875 0 Mabsadd L closepath F
.48168 .38095 -1.875 0 Mabsadd m
.48168 .38095 0 2.5 Mabsadd L
.48168 .38095 1.875 0 Mabsadd L
.48168 .38095 0 -2.5 Mabsadd L
.48168 .38095 -1.875 0 Mabsadd L closepath F
.48474 .44048 -1.875 0 Mabsadd m
.48474 .44048 0 2.5 Mabsadd L
.48474 .44048 1.875 0 Mabsadd L
.48474 .44048 0 -2.5 Mabsadd L
.48474 .44048 -1.875 0 Mabsadd L closepath F
.48779 .44048 -1.875 0 Mabsadd m
.48779 .44048 0 2.5 Mabsadd L
.48779 .44048 1.875 0 Mabsadd L
.48779 .44048 0 -2.5 Mabsadd L
.48779 .44048 -1.875 0 Mabsadd L closepath F
.49084 .5 -1.875 0 Mabsadd m
.49084 .5 0 2.5 Mabsadd L
.49084 .5 1.875 0 Mabsadd L
.49084 .5 0 -2.5 Mabsadd L
.49084 .5 -1.875 0 Mabsadd L closepath F
.49389 .44048 -1.875 0 Mabsadd m
.49389 .44048 0 2.5 Mabsadd L
.49389 .44048 1.875 0 Mabsadd L
.49389 .44048 0 -2.5 Mabsadd L
.49389 .44048 -1.875 0 Mabsadd L closepath F
.49695 .5 -1.875 0 Mabsadd m
.49695 .5 0 2.5 Mabsadd L
.49695 .5 1.875 0 Mabsadd L
.49695 .5 0 -2.5 Mabsadd L
.49695 .5 -1.875 0 Mabsadd L closepath F
.5 .5 -1.875 0 Mabsadd m
.5 .5 0 2.5 Mabsadd L
.5 .5 1.875 0 Mabsadd L
.5 .5 0 -2.5 Mabsadd L
.5 .5 -1.875 0 Mabsadd L closepath F
.50305 .38095 -1.875 0 Mabsadd m
.50305 .38095 0 2.5 Mabsadd L
.50305 .38095 1.875 0 Mabsadd L
.50305 .38095 0 -2.5 Mabsadd L
.50305 .38095 -1.875 0 Mabsadd L closepath F
.50611 .38095 -1.875 0 Mabsadd m
.50611 .38095 0 2.5 Mabsadd L
.50611 .38095 1.875 0 Mabsadd L
.50611 .38095 0 -2.5 Mabsadd L
.50611 .38095 -1.875 0 Mabsadd L closepath F
.50916 .38095 -1.875 0 Mabsadd m
.50916 .38095 0 2.5 Mabsadd L
.50916 .38095 1.875 0 Mabsadd L
.50916 .38095 0 -2.5 Mabsadd L
.50916 .38095 -1.875 0 Mabsadd L closepath F
.51221 .44048 -1.875 0 Mabsadd m
.51221 .44048 0 2.5 Mabsadd L
.51221 .44048 1.875 0 Mabsadd L
.51221 .44048 0 -2.5 Mabsadd L
.51221 .44048 -1.875 0 Mabsadd L closepath F
.51526 .44048 -1.875 0 Mabsadd m
.51526 .44048 0 2.5 Mabsadd L
.51526 .44048 1.875 0 Mabsadd L
.51526 .44048 0 -2.5 Mabsadd L
.51526 .44048 -1.875 0 Mabsadd L closepath F
.51832 .44048 -1.875 0 Mabsadd m
.51832 .44048 0 2.5 Mabsadd L
.51832 .44048 1.875 0 Mabsadd L
.51832 .44048 0 -2.5 Mabsadd L
.51832 .44048 -1.875 0 Mabsadd L closepath F
.52137 .44048 -1.875 0 Mabsadd m
.52137 .44048 0 2.5 Mabsadd L
.52137 .44048 1.875 0 Mabsadd L
.52137 .44048 0 -2.5 Mabsadd L
.52137 .44048 -1.875 0 Mabsadd L closepath F
.52442 .5 -1.875 0 Mabsadd m
.52442 .5 0 2.5 Mabsadd L
.52442 .5 1.875 0 Mabsadd L
.52442 .5 0 -2.5 Mabsadd L
.52442 .5 -1.875 0 Mabsadd L closepath F
.52747 .61905 -1.875 0 Mabsadd m
.52747 .61905 0 2.5 Mabsadd L
.52747 .61905 1.875 0 Mabsadd L
.52747 .61905 0 -2.5 Mabsadd L
.52747 .61905 -1.875 0 Mabsadd L closepath F
.53053 .67857 -1.875 0 Mabsadd m
.53053 .67857 0 2.5 Mabsadd L
.53053 .67857 1.875 0 Mabsadd L
.53053 .67857 0 -2.5 Mabsadd L
.53053 .67857 -1.875 0 Mabsadd L closepath F
.53358 .67857 -1.875 0 Mabsadd m
.53358 .67857 0 2.5 Mabsadd L
.53358 .67857 1.875 0 Mabsadd L
.53358 .67857 0 -2.5 Mabsadd L
.53358 .67857 -1.875 0 Mabsadd L closepath F
.53663 .67857 -1.875 0 Mabsadd m
.53663 .67857 0 2.5 Mabsadd L
.53663 .67857 1.875 0 Mabsadd L
.53663 .67857 0 -2.5 Mabsadd L
.53663 .67857 -1.875 0 Mabsadd L closepath F
.53968 .67857 -1.875 0 Mabsadd m
.53968 .67857 0 2.5 Mabsadd L
.53968 .67857 1.875 0 Mabsadd L
.53968 .67857 0 -2.5 Mabsadd L
.53968 .67857 -1.875 0 Mabsadd L closepath F
.54274 .55952 -1.875 0 Mabsadd m
.54274 .55952 0 2.5 Mabsadd L
.54274 .55952 1.875 0 Mabsadd L
.54274 .55952 0 -2.5 Mabsadd L
.54274 .55952 -1.875 0 Mabsadd L closepath F
.54579 .5 -1.875 0 Mabsadd m
.54579 .5 0 2.5 Mabsadd L
.54579 .5 1.875 0 Mabsadd L
.54579 .5 0 -2.5 Mabsadd L
.54579 .5 -1.875 0 Mabsadd L closepath F
.54884 .5 -1.875 0 Mabsadd m
.54884 .5 0 2.5 Mabsadd L
.54884 .5 1.875 0 Mabsadd L
.54884 .5 0 -2.5 Mabsadd L
.54884 .5 -1.875 0 Mabsadd L closepath F
.55189 .5 -1.875 0 Mabsadd m
.55189 .5 0 2.5 Mabsadd L
.55189 .5 1.875 0 Mabsadd L
.55189 .5 0 -2.5 Mabsadd L
.55189 .5 -1.875 0 Mabsadd L closepath F
.55495 .5 -1.875 0 Mabsadd m
.55495 .5 0 2.5 Mabsadd L
.55495 .5 1.875 0 Mabsadd L
.55495 .5 0 -2.5 Mabsadd L
.55495 .5 -1.875 0 Mabsadd L closepath F
.558 .5 -1.875 0 Mabsadd m
.558 .5 0 2.5 Mabsadd L
.558 .5 1.875 0 Mabsadd L
.558 .5 0 -2.5 Mabsadd L
.558 .5 -1.875 0 Mabsadd L closepath F
.56105 .5 -1.875 0 Mabsadd m
.56105 .5 0 2.5 Mabsadd L
.56105 .5 1.875 0 Mabsadd L
.56105 .5 0 -2.5 Mabsadd L
.56105 .5 -1.875 0 Mabsadd L closepath F
.5641 .44048 -1.875 0 Mabsadd m
.5641 .44048 0 2.5 Mabsadd L
.5641 .44048 1.875 0 Mabsadd L
.5641 .44048 0 -2.5 Mabsadd L
.5641 .44048 -1.875 0 Mabsadd L closepath F
.56716 .44048 -1.875 0 Mabsadd m
.56716 .44048 0 2.5 Mabsadd L
.56716 .44048 1.875 0 Mabsadd L
.56716 .44048 0 -2.5 Mabsadd L
.56716 .44048 -1.875 0 Mabsadd L closepath F
.57021 .5 -1.875 0 Mabsadd m
.57021 .5 0 2.5 Mabsadd L
.57021 .5 1.875 0 Mabsadd L
.57021 .5 0 -2.5 Mabsadd L
.57021 .5 -1.875 0 Mabsadd L closepath F
.57326 .5 -1.875 0 Mabsadd m
.57326 .5 0 2.5 Mabsadd L
.57326 .5 1.875 0 Mabsadd L
.57326 .5 0 -2.5 Mabsadd L
.57326 .5 -1.875 0 Mabsadd L closepath F
.57631 .55952 -1.875 0 Mabsadd m
.57631 .55952 0 2.5 Mabsadd L
.57631 .55952 1.875 0 Mabsadd L
.57631 .55952 0 -2.5 Mabsadd L
.57631 .55952 -1.875 0 Mabsadd L closepath F
.57937 .55952 -1.875 0 Mabsadd m
.57937 .55952 0 2.5 Mabsadd L
.57937 .55952 1.875 0 Mabsadd L
.57937 .55952 0 -2.5 Mabsadd L
.57937 .55952 -1.875 0 Mabsadd L closepath F
.58242 .55952 -1.875 0 Mabsadd m
.58242 .55952 0 2.5 Mabsadd L
.58242 .55952 1.875 0 Mabsadd L
.58242 .55952 0 -2.5 Mabsadd L
.58242 .55952 -1.875 0 Mabsadd L closepath F
.58547 .55952 -1.875 0 Mabsadd m
.58547 .55952 0 2.5 Mabsadd L
.58547 .55952 1.875 0 Mabsadd L
.58547 .55952 0 -2.5 Mabsadd L
.58547 .55952 -1.875 0 Mabsadd L closepath F
.58852 .44048 -1.875 0 Mabsadd m
.58852 .44048 0 2.5 Mabsadd L
.58852 .44048 1.875 0 Mabsadd L
.58852 .44048 0 -2.5 Mabsadd L
.58852 .44048 -1.875 0 Mabsadd L closepath F
.59158 .44048 -1.875 0 Mabsadd m
.59158 .44048 0 2.5 Mabsadd L
.59158 .44048 1.875 0 Mabsadd L
.59158 .44048 0 -2.5 Mabsadd L
.59158 .44048 -1.875 0 Mabsadd L closepath F
.59463 .44048 -1.875 0 Mabsadd m
.59463 .44048 0 2.5 Mabsadd L
.59463 .44048 1.875 0 Mabsadd L
.59463 .44048 0 -2.5 Mabsadd L
.59463 .44048 -1.875 0 Mabsadd L closepath F
.59768 .5 -1.875 0 Mabsadd m
.59768 .5 0 2.5 Mabsadd L
.59768 .5 1.875 0 Mabsadd L
.59768 .5 0 -2.5 Mabsadd L
.59768 .5 -1.875 0 Mabsadd L closepath F
.60073 .5 -1.875 0 Mabsadd m
.60073 .5 0 2.5 Mabsadd L
.60073 .5 1.875 0 Mabsadd L
.60073 .5 0 -2.5 Mabsadd L
.60073 .5 -1.875 0 Mabsadd L closepath F
.60379 .55952 -1.875 0 Mabsadd m
.60379 .55952 0 2.5 Mabsadd L
.60379 .55952 1.875 0 Mabsadd L
.60379 .55952 0 -2.5 Mabsadd L
.60379 .55952 -1.875 0 Mabsadd L closepath F
.60684 .5 -1.875 0 Mabsadd m
.60684 .5 0 2.5 Mabsadd L
.60684 .5 1.875 0 Mabsadd L
.60684 .5 0 -2.5 Mabsadd L
.60684 .5 -1.875 0 Mabsadd L closepath F
.60989 .5 -1.875 0 Mabsadd m
.60989 .5 0 2.5 Mabsadd L
.60989 .5 1.875 0 Mabsadd L
.60989 .5 0 -2.5 Mabsadd L
.60989 .5 -1.875 0 Mabsadd L closepath F
.61294 .55952 -1.875 0 Mabsadd m
.61294 .55952 0 2.5 Mabsadd L
.61294 .55952 1.875 0 Mabsadd L
.61294 .55952 0 -2.5 Mabsadd L
.61294 .55952 -1.875 0 Mabsadd L closepath F
.616 .5 -1.875 0 Mabsadd m
.616 .5 0 2.5 Mabsadd L
.616 .5 1.875 0 Mabsadd L
.616 .5 0 -2.5 Mabsadd L
.616 .5 -1.875 0 Mabsadd L closepath F
.61905 .5 -1.875 0 Mabsadd m
.61905 .5 0 2.5 Mabsadd L
.61905 .5 1.875 0 Mabsadd L
.61905 .5 0 -2.5 Mabsadd L
.61905 .5 -1.875 0 Mabsadd L closepath F
.6221 .55952 -1.875 0 Mabsadd m
.6221 .55952 0 2.5 Mabsadd L
.6221 .55952 1.875 0 Mabsadd L
.6221 .55952 0 -2.5 Mabsadd L
.6221 .55952 -1.875 0 Mabsadd L closepath F
.62515 .61905 -1.875 0 Mabsadd m
.62515 .61905 0 2.5 Mabsadd L
.62515 .61905 1.875 0 Mabsadd L
.62515 .61905 0 -2.5 Mabsadd L
.62515 .61905 -1.875 0 Mabsadd L closepath F
.62821 .61905 -1.875 0 Mabsadd m
.62821 .61905 0 2.5 Mabsadd L
.62821 .61905 1.875 0 Mabsadd L
.62821 .61905 0 -2.5 Mabsadd L
.62821 .61905 -1.875 0 Mabsadd L closepath F
.63126 .61905 -1.875 0 Mabsadd m
.63126 .61905 0 2.5 Mabsadd L
.63126 .61905 1.875 0 Mabsadd L
.63126 .61905 0 -2.5 Mabsadd L
.63126 .61905 -1.875 0 Mabsadd L closepath F
.63431 .61905 -1.875 0 Mabsadd m
.63431 .61905 0 2.5 Mabsadd L
.63431 .61905 1.875 0 Mabsadd L
.63431 .61905 0 -2.5 Mabsadd L
.63431 .61905 -1.875 0 Mabsadd L closepath F
.63736 .55952 -1.875 0 Mabsadd m
.63736 .55952 0 2.5 Mabsadd L
.63736 .55952 1.875 0 Mabsadd L
.63736 .55952 0 -2.5 Mabsadd L
.63736 .55952 -1.875 0 Mabsadd L closepath F
.64042 .61905 -1.875 0 Mabsadd m
.64042 .61905 0 2.5 Mabsadd L
.64042 .61905 1.875 0 Mabsadd L
.64042 .61905 0 -2.5 Mabsadd L
.64042 .61905 -1.875 0 Mabsadd L closepath F
.64347 .61905 -1.875 0 Mabsadd m
.64347 .61905 0 2.5 Mabsadd L
.64347 .61905 1.875 0 Mabsadd L
.64347 .61905 0 -2.5 Mabsadd L
.64347 .61905 -1.875 0 Mabsadd L closepath F
.64652 .61905 -1.875 0 Mabsadd m
.64652 .61905 0 2.5 Mabsadd L
.64652 .61905 1.875 0 Mabsadd L
.64652 .61905 0 -2.5 Mabsadd L
.64652 .61905 -1.875 0 Mabsadd L closepath F
.64957 .55952 -1.875 0 Mabsadd m
.64957 .55952 0 2.5 Mabsadd L
.64957 .55952 1.875 0 Mabsadd L
.64957 .55952 0 -2.5 Mabsadd L
.64957 .55952 -1.875 0 Mabsadd L closepath F
.65263 .5 -1.875 0 Mabsadd m
.65263 .5 0 2.5 Mabsadd L
.65263 .5 1.875 0 Mabsadd L
.65263 .5 0 -2.5 Mabsadd L
.65263 .5 -1.875 0 Mabsadd L closepath F
.65568 .5 -1.875 0 Mabsadd m
.65568 .5 0 2.5 Mabsadd L
.65568 .5 1.875 0 Mabsadd L
.65568 .5 0 -2.5 Mabsadd L
.65568 .5 -1.875 0 Mabsadd L closepath F
.65873 .55952 -1.875 0 Mabsadd m
.65873 .55952 0 2.5 Mabsadd L
.65873 .55952 1.875 0 Mabsadd L
.65873 .55952 0 -2.5 Mabsadd L
.65873 .55952 -1.875 0 Mabsadd L closepath F
.66178 .55952 -1.875 0 Mabsadd m
.66178 .55952 0 2.5 Mabsadd L
.66178 .55952 1.875 0 Mabsadd L
.66178 .55952 0 -2.5 Mabsadd L
.66178 .55952 -1.875 0 Mabsadd L closepath F
.66484 .61905 -1.875 0 Mabsadd m
.66484 .61905 0 2.5 Mabsadd L
.66484 .61905 1.875 0 Mabsadd L
.66484 .61905 0 -2.5 Mabsadd L
.66484 .61905 -1.875 0 Mabsadd L closepath F
.66789 .55952 -1.875 0 Mabsadd m
.66789 .55952 0 2.5 Mabsadd L
.66789 .55952 1.875 0 Mabsadd L
.66789 .55952 0 -2.5 Mabsadd L
.66789 .55952 -1.875 0 Mabsadd L closepath F
.67094 .55952 -1.875 0 Mabsadd m
.67094 .55952 0 2.5 Mabsadd L
.67094 .55952 1.875 0 Mabsadd L
.67094 .55952 0 -2.5 Mabsadd L
.67094 .55952 -1.875 0 Mabsadd L closepath F
.67399 .55952 -1.875 0 Mabsadd m
.67399 .55952 0 2.5 Mabsadd L
.67399 .55952 1.875 0 Mabsadd L
.67399 .55952 0 -2.5 Mabsadd L
.67399 .55952 -1.875 0 Mabsadd L closepath F
.67705 .5 -1.875 0 Mabsadd m
.67705 .5 0 2.5 Mabsadd L
.67705 .5 1.875 0 Mabsadd L
.67705 .5 0 -2.5 Mabsadd L
.67705 .5 -1.875 0 Mabsadd L closepath F
.6801 .5 -1.875 0 Mabsadd m
.6801 .5 0 2.5 Mabsadd L
.6801 .5 1.875 0 Mabsadd L
.6801 .5 0 -2.5 Mabsadd L
.6801 .5 -1.875 0 Mabsadd L closepath F
.68315 .38095 -1.875 0 Mabsadd m
.68315 .38095 0 2.5 Mabsadd L
.68315 .38095 1.875 0 Mabsadd L
.68315 .38095 0 -2.5 Mabsadd L
.68315 .38095 -1.875 0 Mabsadd L closepath F
.6862 .38095 -1.875 0 Mabsadd m
.6862 .38095 0 2.5 Mabsadd L
.6862 .38095 1.875 0 Mabsadd L
.6862 .38095 0 -2.5 Mabsadd L
.6862 .38095 -1.875 0 Mabsadd L closepath F
.68926 .44048 -1.875 0 Mabsadd m
.68926 .44048 0 2.5 Mabsadd L
.68926 .44048 1.875 0 Mabsadd L
.68926 .44048 0 -2.5 Mabsadd L
.68926 .44048 -1.875 0 Mabsadd L closepath F
.69231 .38095 -1.875 0 Mabsadd m
.69231 .38095 0 2.5 Mabsadd L
.69231 .38095 1.875 0 Mabsadd L
.69231 .38095 0 -2.5 Mabsadd L
.69231 .38095 -1.875 0 Mabsadd L closepath F
.69536 .38095 -1.875 0 Mabsadd m
.69536 .38095 0 2.5 Mabsadd L
.69536 .38095 1.875 0 Mabsadd L
.69536 .38095 0 -2.5 Mabsadd L
.69536 .38095 -1.875 0 Mabsadd L closepath F
.69841 .38095 -1.875 0 Mabsadd m
.69841 .38095 0 2.5 Mabsadd L
.69841 .38095 1.875 0 Mabsadd L
.69841 .38095 0 -2.5 Mabsadd L
.69841 .38095 -1.875 0 Mabsadd L closepath F
.70147 .32143 -1.875 0 Mabsadd m
.70147 .32143 0 2.5 Mabsadd L
.70147 .32143 1.875 0 Mabsadd L
.70147 .32143 0 -2.5 Mabsadd L
.70147 .32143 -1.875 0 Mabsadd L closepath F
.70452 .32143 -1.875 0 Mabsadd m
.70452 .32143 0 2.5 Mabsadd L
.70452 .32143 1.875 0 Mabsadd L
.70452 .32143 0 -2.5 Mabsadd L
.70452 .32143 -1.875 0 Mabsadd L closepath F
.70757 .32143 -1.875 0 Mabsadd m
.70757 .32143 0 2.5 Mabsadd L
.70757 .32143 1.875 0 Mabsadd L
.70757 .32143 0 -2.5 Mabsadd L
.70757 .32143 -1.875 0 Mabsadd L closepath F
.71062 .32143 -1.875 0 Mabsadd m
.71062 .32143 0 2.5 Mabsadd L
.71062 .32143 1.875 0 Mabsadd L
.71062 .32143 0 -2.5 Mabsadd L
.71062 .32143 -1.875 0 Mabsadd L closepath F
.71368 .32143 -1.875 0 Mabsadd m
.71368 .32143 0 2.5 Mabsadd L
.71368 .32143 1.875 0 Mabsadd L
.71368 .32143 0 -2.5 Mabsadd L
.71368 .32143 -1.875 0 Mabsadd L closepath F
.71673 .32143 -1.875 0 Mabsadd m
.71673 .32143 0 2.5 Mabsadd L
.71673 .32143 1.875 0 Mabsadd L
.71673 .32143 0 -2.5 Mabsadd L
.71673 .32143 -1.875 0 Mabsadd L closepath F
.71978 .44048 -1.875 0 Mabsadd m
.71978 .44048 0 2.5 Mabsadd L
.71978 .44048 1.875 0 Mabsadd L
.71978 .44048 0 -2.5 Mabsadd L
.71978 .44048 -1.875 0 Mabsadd L closepath F
.72283 .5 -1.875 0 Mabsadd m
.72283 .5 0 2.5 Mabsadd L
.72283 .5 1.875 0 Mabsadd L
.72283 .5 0 -2.5 Mabsadd L
.72283 .5 -1.875 0 Mabsadd L closepath F
.72589 .55952 -1.875 0 Mabsadd m
.72589 .55952 0 2.5 Mabsadd L
.72589 .55952 1.875 0 Mabsadd L
.72589 .55952 0 -2.5 Mabsadd L
.72589 .55952 -1.875 0 Mabsadd L closepath F
.72894 .61905 -1.875 0 Mabsadd m
.72894 .61905 0 2.5 Mabsadd L
.72894 .61905 1.875 0 Mabsadd L
.72894 .61905 0 -2.5 Mabsadd L
.72894 .61905 -1.875 0 Mabsadd L closepath F
.73199 .61905 -1.875 0 Mabsadd m
.73199 .61905 0 2.5 Mabsadd L
.73199 .61905 1.875 0 Mabsadd L
.73199 .61905 0 -2.5 Mabsadd L
.73199 .61905 -1.875 0 Mabsadd L closepath F
.73504 .67857 -1.875 0 Mabsadd m
.73504 .67857 0 2.5 Mabsadd L
.73504 .67857 1.875 0 Mabsadd L
.73504 .67857 0 -2.5 Mabsadd L
.73504 .67857 -1.875 0 Mabsadd L closepath F
.7381 .7381 -1.875 0 Mabsadd m
.7381 .7381 0 2.5 Mabsadd L
.7381 .7381 1.875 0 Mabsadd L
.7381 .7381 0 -2.5 Mabsadd L
.7381 .7381 -1.875 0 Mabsadd L closepath F
.74115 .79762 -1.875 0 Mabsadd m
.74115 .79762 0 2.5 Mabsadd L
.74115 .79762 1.875 0 Mabsadd L
.74115 .79762 0 -2.5 Mabsadd L
.74115 .79762 -1.875 0 Mabsadd L closepath F
.7442 .91667 -1.875 0 Mabsadd m
.7442 .91667 0 2.5 Mabsadd L
.7442 .91667 1.875 0 Mabsadd L
.7442 .91667 0 -2.5 Mabsadd L
.7442 .91667 -1.875 0 Mabsadd L closepath F
.74725 .97619 -1.875 0 Mabsadd m
.74725 .97619 0 2.5 Mabsadd L
.74725 .97619 1.875 0 Mabsadd L
.74725 .97619 0 -2.5 Mabsadd L
.74725 .97619 -1.875 0 Mabsadd L closepath F
.75031 .85714 -1.875 0 Mabsadd m
.75031 .85714 0 2.5 Mabsadd L
.75031 .85714 1.875 0 Mabsadd L
.75031 .85714 0 -2.5 Mabsadd L
.75031 .85714 -1.875 0 Mabsadd L closepath F
.75336 .85714 -1.875 0 Mabsadd m
.75336 .85714 0 2.5 Mabsadd L
.75336 .85714 1.875 0 Mabsadd L
.75336 .85714 0 -2.5 Mabsadd L
.75336 .85714 -1.875 0 Mabsadd L closepath F
.75641 .85714 -1.875 0 Mabsadd m
.75641 .85714 0 2.5 Mabsadd L
.75641 .85714 1.875 0 Mabsadd L
.75641 .85714 0 -2.5 Mabsadd L
.75641 .85714 -1.875 0 Mabsadd L closepath F
.75946 .91667 -1.875 0 Mabsadd m
.75946 .91667 0 2.5 Mabsadd L
.75946 .91667 1.875 0 Mabsadd L
.75946 .91667 0 -2.5 Mabsadd L
.75946 .91667 -1.875 0 Mabsadd L closepath F
.76252 .85714 -1.875 0 Mabsadd m
.76252 .85714 0 2.5 Mabsadd L
.76252 .85714 1.875 0 Mabsadd L
.76252 .85714 0 -2.5 Mabsadd L
.76252 .85714 -1.875 0 Mabsadd L closepath F
.76557 .7381 -1.875 0 Mabsadd m
.76557 .7381 0 2.5 Mabsadd L
.76557 .7381 1.875 0 Mabsadd L
.76557 .7381 0 -2.5 Mabsadd L
.76557 .7381 -1.875 0 Mabsadd L closepath F
.76862 .67857 -1.875 0 Mabsadd m
.76862 .67857 0 2.5 Mabsadd L
.76862 .67857 1.875 0 Mabsadd L
.76862 .67857 0 -2.5 Mabsadd L
.76862 .67857 -1.875 0 Mabsadd L closepath F
.77167 .67857 -1.875 0 Mabsadd m
.77167 .67857 0 2.5 Mabsadd L
.77167 .67857 1.875 0 Mabsadd L
.77167 .67857 0 -2.5 Mabsadd L
.77167 .67857 -1.875 0 Mabsadd L closepath F
.77473 .67857 -1.875 0 Mabsadd m
.77473 .67857 0 2.5 Mabsadd L
.77473 .67857 1.875 0 Mabsadd L
.77473 .67857 0 -2.5 Mabsadd L
.77473 .67857 -1.875 0 Mabsadd L closepath F
.77778 .61905 -1.875 0 Mabsadd m
.77778 .61905 0 2.5 Mabsadd L
.77778 .61905 1.875 0 Mabsadd L
.77778 .61905 0 -2.5 Mabsadd L
.77778 .61905 -1.875 0 Mabsadd L closepath F
.78083 .67857 -1.875 0 Mabsadd m
.78083 .67857 0 2.5 Mabsadd L
.78083 .67857 1.875 0 Mabsadd L
.78083 .67857 0 -2.5 Mabsadd L
.78083 .67857 -1.875 0 Mabsadd L closepath F
.78388 .79762 -1.875 0 Mabsadd m
.78388 .79762 0 2.5 Mabsadd L
.78388 .79762 1.875 0 Mabsadd L
.78388 .79762 0 -2.5 Mabsadd L
.78388 .79762 -1.875 0 Mabsadd L closepath F
.78694 .85714 -1.875 0 Mabsadd m
.78694 .85714 0 2.5 Mabsadd L
.78694 .85714 1.875 0 Mabsadd L
.78694 .85714 0 -2.5 Mabsadd L
.78694 .85714 -1.875 0 Mabsadd L closepath F
.78999 .85714 -1.875 0 Mabsadd m
.78999 .85714 0 2.5 Mabsadd L
.78999 .85714 1.875 0 Mabsadd L
.78999 .85714 0 -2.5 Mabsadd L
.78999 .85714 -1.875 0 Mabsadd L closepath F
.79304 .85714 -1.875 0 Mabsadd m
.79304 .85714 0 2.5 Mabsadd L
.79304 .85714 1.875 0 Mabsadd L
.79304 .85714 0 -2.5 Mabsadd L
.79304 .85714 -1.875 0 Mabsadd L closepath F
.79609 .79762 -1.875 0 Mabsadd m
.79609 .79762 0 2.5 Mabsadd L
.79609 .79762 1.875 0 Mabsadd L
.79609 .79762 0 -2.5 Mabsadd L
.79609 .79762 -1.875 0 Mabsadd L closepath F
.79915 .85714 -1.875 0 Mabsadd m
.79915 .85714 0 2.5 Mabsadd L
.79915 .85714 1.875 0 Mabsadd L
.79915 .85714 0 -2.5 Mabsadd L
.79915 .85714 -1.875 0 Mabsadd L closepath F
.8022 .85714 -1.875 0 Mabsadd m
.8022 .85714 0 2.5 Mabsadd L
.8022 .85714 1.875 0 Mabsadd L
.8022 .85714 0 -2.5 Mabsadd L
.8022 .85714 -1.875 0 Mabsadd L closepath F
.80525 .79762 -1.875 0 Mabsadd m
.80525 .79762 0 2.5 Mabsadd L
.80525 .79762 1.875 0 Mabsadd L
.80525 .79762 0 -2.5 Mabsadd L
.80525 .79762 -1.875 0 Mabsadd L closepath F
.8083 .79762 -1.875 0 Mabsadd m
.8083 .79762 0 2.5 Mabsadd L
.8083 .79762 1.875 0 Mabsadd L
.8083 .79762 0 -2.5 Mabsadd L
.8083 .79762 -1.875 0 Mabsadd L closepath F
.81136 .79762 -1.875 0 Mabsadd m
.81136 .79762 0 2.5 Mabsadd L
.81136 .79762 1.875 0 Mabsadd L
.81136 .79762 0 -2.5 Mabsadd L
.81136 .79762 -1.875 0 Mabsadd L closepath F
.81441 .7381 -1.875 0 Mabsadd m
.81441 .7381 0 2.5 Mabsadd L
.81441 .7381 1.875 0 Mabsadd L
.81441 .7381 0 -2.5 Mabsadd L
.81441 .7381 -1.875 0 Mabsadd L closepath F
.81746 .67857 -1.875 0 Mabsadd m
.81746 .67857 0 2.5 Mabsadd L
.81746 .67857 1.875 0 Mabsadd L
.81746 .67857 0 -2.5 Mabsadd L
.81746 .67857 -1.875 0 Mabsadd L closepath F
.82051 .67857 -1.875 0 Mabsadd m
.82051 .67857 0 2.5 Mabsadd L
.82051 .67857 1.875 0 Mabsadd L
.82051 .67857 0 -2.5 Mabsadd L
.82051 .67857 -1.875 0 Mabsadd L closepath F
.82357 .67857 -1.875 0 Mabsadd m
.82357 .67857 0 2.5 Mabsadd L
.82357 .67857 1.875 0 Mabsadd L
.82357 .67857 0 -2.5 Mabsadd L
.82357 .67857 -1.875 0 Mabsadd L closepath F
.82662 .7381 -1.875 0 Mabsadd m
.82662 .7381 0 2.5 Mabsadd L
.82662 .7381 1.875 0 Mabsadd L
.82662 .7381 0 -2.5 Mabsadd L
.82662 .7381 -1.875 0 Mabsadd L closepath F
.82967 .61905 -1.875 0 Mabsadd m
.82967 .61905 0 2.5 Mabsadd L
.82967 .61905 1.875 0 Mabsadd L
.82967 .61905 0 -2.5 Mabsadd L
.82967 .61905 -1.875 0 Mabsadd L closepath F
.83272 .67857 -1.875 0 Mabsadd m
.83272 .67857 0 2.5 Mabsadd L
.83272 .67857 1.875 0 Mabsadd L
.83272 .67857 0 -2.5 Mabsadd L
.83272 .67857 -1.875 0 Mabsadd L closepath F
.83578 .67857 -1.875 0 Mabsadd m
.83578 .67857 0 2.5 Mabsadd L
.83578 .67857 1.875 0 Mabsadd L
.83578 .67857 0 -2.5 Mabsadd L
.83578 .67857 -1.875 0 Mabsadd L closepath F
.83883 .7381 -1.875 0 Mabsadd m
.83883 .7381 0 2.5 Mabsadd L
.83883 .7381 1.875 0 Mabsadd L
.83883 .7381 0 -2.5 Mabsadd L
.83883 .7381 -1.875 0 Mabsadd L closepath F
.84188 .7381 -1.875 0 Mabsadd m
.84188 .7381 0 2.5 Mabsadd L
.84188 .7381 1.875 0 Mabsadd L
.84188 .7381 0 -2.5 Mabsadd L
.84188 .7381 -1.875 0 Mabsadd L closepath F
.84493 .67857 -1.875 0 Mabsadd m
.84493 .67857 0 2.5 Mabsadd L
.84493 .67857 1.875 0 Mabsadd L
.84493 .67857 0 -2.5 Mabsadd L
.84493 .67857 -1.875 0 Mabsadd L closepath F
.84799 .7381 -1.875 0 Mabsadd m
.84799 .7381 0 2.5 Mabsadd L
.84799 .7381 1.875 0 Mabsadd L
.84799 .7381 0 -2.5 Mabsadd L
.84799 .7381 -1.875 0 Mabsadd L closepath F
.85104 .7381 -1.875 0 Mabsadd m
.85104 .7381 0 2.5 Mabsadd L
.85104 .7381 1.875 0 Mabsadd L
.85104 .7381 0 -2.5 Mabsadd L
.85104 .7381 -1.875 0 Mabsadd L closepath F
.85409 .7381 -1.875 0 Mabsadd m
.85409 .7381 0 2.5 Mabsadd L
.85409 .7381 1.875 0 Mabsadd L
.85409 .7381 0 -2.5 Mabsadd L
.85409 .7381 -1.875 0 Mabsadd L closepath F
.85714 .67857 -1.875 0 Mabsadd m
.85714 .67857 0 2.5 Mabsadd L
.85714 .67857 1.875 0 Mabsadd L
.85714 .67857 0 -2.5 Mabsadd L
.85714 .67857 -1.875 0 Mabsadd L closepath F
.8602 .67857 -1.875 0 Mabsadd m
.8602 .67857 0 2.5 Mabsadd L
.8602 .67857 1.875 0 Mabsadd L
.8602 .67857 0 -2.5 Mabsadd L
.8602 .67857 -1.875 0 Mabsadd L closepath F
.86325 .67857 -1.875 0 Mabsadd m
.86325 .67857 0 2.5 Mabsadd L
.86325 .67857 1.875 0 Mabsadd L
.86325 .67857 0 -2.5 Mabsadd L
.86325 .67857 -1.875 0 Mabsadd L closepath F
.8663 .61905 -1.875 0 Mabsadd m
.8663 .61905 0 2.5 Mabsadd L
.8663 .61905 1.875 0 Mabsadd L
.8663 .61905 0 -2.5 Mabsadd L
.8663 .61905 -1.875 0 Mabsadd L closepath F
.86935 .61905 -1.875 0 Mabsadd m
.86935 .61905 0 2.5 Mabsadd L
.86935 .61905 1.875 0 Mabsadd L
.86935 .61905 0 -2.5 Mabsadd L
.86935 .61905 -1.875 0 Mabsadd L closepath F
.87241 .61905 -1.875 0 Mabsadd m
.87241 .61905 0 2.5 Mabsadd L
.87241 .61905 1.875 0 Mabsadd L
.87241 .61905 0 -2.5 Mabsadd L
.87241 .61905 -1.875 0 Mabsadd L closepath F
.87546 .55952 -1.875 0 Mabsadd m
.87546 .55952 0 2.5 Mabsadd L
.87546 .55952 1.875 0 Mabsadd L
.87546 .55952 0 -2.5 Mabsadd L
.87546 .55952 -1.875 0 Mabsadd L closepath F
.87851 .67857 -1.875 0 Mabsadd m
.87851 .67857 0 2.5 Mabsadd L
.87851 .67857 1.875 0 Mabsadd L
.87851 .67857 0 -2.5 Mabsadd L
.87851 .67857 -1.875 0 Mabsadd L closepath F
.88156 .67857 -1.875 0 Mabsadd m
.88156 .67857 0 2.5 Mabsadd L
.88156 .67857 1.875 0 Mabsadd L
.88156 .67857 0 -2.5 Mabsadd L
.88156 .67857 -1.875 0 Mabsadd L closepath F
.88462 .79762 -1.875 0 Mabsadd m
.88462 .79762 0 2.5 Mabsadd L
.88462 .79762 1.875 0 Mabsadd L
.88462 .79762 0 -2.5 Mabsadd L
.88462 .79762 -1.875 0 Mabsadd L closepath F
.88767 .79762 -1.875 0 Mabsadd m
.88767 .79762 0 2.5 Mabsadd L
.88767 .79762 1.875 0 Mabsadd L
.88767 .79762 0 -2.5 Mabsadd L
.88767 .79762 -1.875 0 Mabsadd L closepath F
.89072 .7381 -1.875 0 Mabsadd m
.89072 .7381 0 2.5 Mabsadd L
.89072 .7381 1.875 0 Mabsadd L
.89072 .7381 0 -2.5 Mabsadd L
.89072 .7381 -1.875 0 Mabsadd L closepath F
.89377 .7381 -1.875 0 Mabsadd m
.89377 .7381 0 2.5 Mabsadd L
.89377 .7381 1.875 0 Mabsadd L
.89377 .7381 0 -2.5 Mabsadd L
.89377 .7381 -1.875 0 Mabsadd L closepath F
.89683 .61905 -1.875 0 Mabsadd m
.89683 .61905 0 2.5 Mabsadd L
.89683 .61905 1.875 0 Mabsadd L
.89683 .61905 0 -2.5 Mabsadd L
.89683 .61905 -1.875 0 Mabsadd L closepath F
.89988 .7381 -1.875 0 Mabsadd m
.89988 .7381 0 2.5 Mabsadd L
.89988 .7381 1.875 0 Mabsadd L
.89988 .7381 0 -2.5 Mabsadd L
.89988 .7381 -1.875 0 Mabsadd L closepath F
.90293 .79762 -1.875 0 Mabsadd m
.90293 .79762 0 2.5 Mabsadd L
.90293 .79762 1.875 0 Mabsadd L
.90293 .79762 0 -2.5 Mabsadd L
.90293 .79762 -1.875 0 Mabsadd L closepath F
.90598 .79762 -1.875 0 Mabsadd m
.90598 .79762 0 2.5 Mabsadd L
.90598 .79762 1.875 0 Mabsadd L
.90598 .79762 0 -2.5 Mabsadd L
.90598 .79762 -1.875 0 Mabsadd L closepath F
.90904 .7381 -1.875 0 Mabsadd m
.90904 .7381 0 2.5 Mabsadd L
.90904 .7381 1.875 0 Mabsadd L
.90904 .7381 0 -2.5 Mabsadd L
.90904 .7381 -1.875 0 Mabsadd L closepath F
.91209 .67857 -1.875 0 Mabsadd m
.91209 .67857 0 2.5 Mabsadd L
.91209 .67857 1.875 0 Mabsadd L
.91209 .67857 0 -2.5 Mabsadd L
.91209 .67857 -1.875 0 Mabsadd L closepath F
.91514 .7381 -1.875 0 Mabsadd m
.91514 .7381 0 2.5 Mabsadd L
.91514 .7381 1.875 0 Mabsadd L
.91514 .7381 0 -2.5 Mabsadd L
.91514 .7381 -1.875 0 Mabsadd L closepath F
.91819 .7381 -1.875 0 Mabsadd m
.91819 .7381 0 2.5 Mabsadd L
.91819 .7381 1.875 0 Mabsadd L
.91819 .7381 0 -2.5 Mabsadd L
.91819 .7381 -1.875 0 Mabsadd L closepath F
.92125 .7381 -1.875 0 Mabsadd m
.92125 .7381 0 2.5 Mabsadd L
.92125 .7381 1.875 0 Mabsadd L
.92125 .7381 0 -2.5 Mabsadd L
.92125 .7381 -1.875 0 Mabsadd L closepath F
.9243 .67857 -1.875 0 Mabsadd m
.9243 .67857 0 2.5 Mabsadd L
.9243 .67857 1.875 0 Mabsadd L
.9243 .67857 0 -2.5 Mabsadd L
.9243 .67857 -1.875 0 Mabsadd L closepath F
.92735 .7381 -1.875 0 Mabsadd m
.92735 .7381 0 2.5 Mabsadd L
.92735 .7381 1.875 0 Mabsadd L
.92735 .7381 0 -2.5 Mabsadd L
.92735 .7381 -1.875 0 Mabsadd L closepath F
.9304 .79762 -1.875 0 Mabsadd m
.9304 .79762 0 2.5 Mabsadd L
.9304 .79762 1.875 0 Mabsadd L
.9304 .79762 0 -2.5 Mabsadd L
.9304 .79762 -1.875 0 Mabsadd L closepath F
.93346 .85714 -1.875 0 Mabsadd m
.93346 .85714 0 2.5 Mabsadd L
.93346 .85714 1.875 0 Mabsadd L
.93346 .85714 0 -2.5 Mabsadd L
.93346 .85714 -1.875 0 Mabsadd L closepath F
.93651 .85714 -1.875 0 Mabsadd m
.93651 .85714 0 2.5 Mabsadd L
.93651 .85714 1.875 0 Mabsadd L
.93651 .85714 0 -2.5 Mabsadd L
.93651 .85714 -1.875 0 Mabsadd L closepath F
.93956 .85714 -1.875 0 Mabsadd m
.93956 .85714 0 2.5 Mabsadd L
.93956 .85714 1.875 0 Mabsadd L
.93956 .85714 0 -2.5 Mabsadd L
.93956 .85714 -1.875 0 Mabsadd L closepath F
.94261 .85714 -1.875 0 Mabsadd m
.94261 .85714 0 2.5 Mabsadd L
.94261 .85714 1.875 0 Mabsadd L
.94261 .85714 0 -2.5 Mabsadd L
.94261 .85714 -1.875 0 Mabsadd L closepath F
.94567 .85714 -1.875 0 Mabsadd m
.94567 .85714 0 2.5 Mabsadd L
.94567 .85714 1.875 0 Mabsadd L
.94567 .85714 0 -2.5 Mabsadd L
.94567 .85714 -1.875 0 Mabsadd L closepath F
.94872 .79762 -1.875 0 Mabsadd m
.94872 .79762 0 2.5 Mabsadd L
.94872 .79762 1.875 0 Mabsadd L
.94872 .79762 0 -2.5 Mabsadd L
.94872 .79762 -1.875 0 Mabsadd L closepath F
.95177 .79762 -1.875 0 Mabsadd m
.95177 .79762 0 2.5 Mabsadd L
.95177 .79762 1.875 0 Mabsadd L
.95177 .79762 0 -2.5 Mabsadd L
.95177 .79762 -1.875 0 Mabsadd L closepath F
.95482 .7381 -1.875 0 Mabsadd m
.95482 .7381 0 2.5 Mabsadd L
.95482 .7381 1.875 0 Mabsadd L
.95482 .7381 0 -2.5 Mabsadd L
.95482 .7381 -1.875 0 Mabsadd L closepath F
.95788 .7381 -1.875 0 Mabsadd m
.95788 .7381 0 2.5 Mabsadd L
.95788 .7381 1.875 0 Mabsadd L
.95788 .7381 0 -2.5 Mabsadd L
.95788 .7381 -1.875 0 Mabsadd L closepath F
.96093 .67857 -1.875 0 Mabsadd m
.96093 .67857 0 2.5 Mabsadd L
.96093 .67857 1.875 0 Mabsadd L
.96093 .67857 0 -2.5 Mabsadd L
.96093 .67857 -1.875 0 Mabsadd L closepath F
.96398 .67857 -1.875 0 Mabsadd m
.96398 .67857 0 2.5 Mabsadd L
.96398 .67857 1.875 0 Mabsadd L
.96398 .67857 0 -2.5 Mabsadd L
.96398 .67857 -1.875 0 Mabsadd L closepath F
.96703 .7381 -1.875 0 Mabsadd m
.96703 .7381 0 2.5 Mabsadd L
.96703 .7381 1.875 0 Mabsadd L
.96703 .7381 0 -2.5 Mabsadd L
.96703 .7381 -1.875 0 Mabsadd L closepath F
.97009 .67857 -1.875 0 Mabsadd m
.97009 .67857 0 2.5 Mabsadd L
.97009 .67857 1.875 0 Mabsadd L
.97009 .67857 0 -2.5 Mabsadd L
.97009 .67857 -1.875 0 Mabsadd L closepath F
.97314 .67857 -1.875 0 Mabsadd m
.97314 .67857 0 2.5 Mabsadd L
.97314 .67857 1.875 0 Mabsadd L
.97314 .67857 0 -2.5 Mabsadd L
.97314 .67857 -1.875 0 Mabsadd L closepath F
.97619 .67857 -1.875 0 Mabsadd m
.97619 .67857 0 2.5 Mabsadd L
.97619 .67857 1.875 0 Mabsadd L
.97619 .67857 0 -2.5 Mabsadd L
.97619 .67857 -1.875 0 Mabsadd L closepath F
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[38]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo000nool2000Uool40003ool2000Tool00`00oooo
o`02ool2000Sool20004ool2000Sool20004ool2000Oool40003ool20004ool20003ool003goo`04
003ooooo000Tool00`00ooooo`03ool01000ooooo`008ooo00D00?ooooooo`0000;oo`03003ooooo
01ooo`04003ooooo0002ool01000ooooo`008Ooo00@00?ooool000;oo`04003ooooo000Pool01@00
oooooooo00000_oo00@00?ooool000;oo`40007oo`7oo`00?Ooo00@00?ooool002Goo`03003ooooo
00;oo`04003ooooo000Pool50002ool01000ooooo`008Ooo00@00?ooool000;oo`04003ooooo000Q
ool01000ooooo`000_oo00@00?ooool0023oo`05003oooooool00002ool01000ooooo`000_oo0@00
0Ooo0Ooo000mool01000ooooo`009_oo00D00?ooooooo`0000;oo`03003ooooo01koo`04003ooooo
0003ool01000ooooo`008Ooo0`000ooo00@00?ooool002;oo`8000?oo`04003ooooo000Pool01@00
oooooooo00000_oo00@00?ooool000;oo`40007oo`7oo`00?Ooo00@00?ooool002Ooo`04003ooooo
0002ool00`00ooooo`0Oool00`00ool00003ool01000ooooo`008Ooo00<00?ooool00ooo00@00?oo
ool0027oo`04003ooooo0002ool01000ooooo`008?oo00D00?ooooooo`0000;oo`04003ooooo0002
ool10001ool1ool003goo`04003ooooo000Tool01000ooooo`000_oo00@00?ooool002;oo`8000?o
o`04003ooooo000Qool00`00ooooo`03ool01000ooooo`008Ooo00@00?ooool000;oo`04003ooooo
000Nool30003ool01000ooooo`000_oo00@00?ooool000;oo`00?_oo0P009_oo0P001?oo0P009?oo
00<00?ooool00_oo0P008ooo0`000ooo0P008ooo0P001?oo0P008Ooo00<00?ooool00_oo0P001?oo
0P000ooo003ooolQool00?ooob7oo`00oooo8Ooo000joooR0004ool003[oo`03003ooooo00;oo`03
003ooooo02Soo`03003ooooo02Soo`03003ooooo02Soo`03003ooooo02Soo`03003ooooo02Soo`03
003ooooo00;oo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000cool20005
ool00`00ooooo`02ool00`0Oooooo`03ool00`0Oooooo`02ool0100Oooooo`0O0_oo00<07oooool0
:_oo00<07oooool0Vooo00<00?ooool00_oo000bool01000ooooo`001?oo00@00?ooooooo`<07`?o
o`<07`;oo`P07b_oo`<07icoo`03003ooooo00;oo`00<_oo00@00?ooool000Coo`800003ool07`0O
00807`;oo`@07`03ool07`0O00L07b[oo`@07i[oo`<000Coo`00<_oo00@00?ooool000Coo`04003o
ooooool201l4ool201l3ool201l01?oo01l07ooo0P0O:ooo0P0OWOoo00<00?ooool00_oo000bool0
1000ooooo`001?oo00<00?ooool0g_oo00<00?ooool00_oo000bool01000ooooo`001?oo00<00?oo
ool0g_oo00<00?ooool00_oo000cool20005ool00`00ooooo`3Nool00`00ooooo`02ool003[oo`03
003ooooo00Coo`<07`03ool07ooo00;oo`0301oooooo0<ooo`03003ooooo00;oo`00>_oo0P001?oo
1`0O0_oo0P0Ocooo0P001?oo000jool00`00ooooo`02ool801l01?oo01l07`0Od?oo00<00?ooool0
0_oo000jool00`00ooooo`03ool601l3ool00`0Oooooo`3?ool00`00ooooo`02ool003[oo`03003o
oooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00oooo
o`3Nool00`00ooooo`02ool003[oo`8000Coo`807`03ool07`0O00;oo`807`05ool07`0O01ooo`03
01l>ool601l2ool201l2ool201l5ool201l6ool501nKool20004ool003[oo`03003ooooo00;ooa<0
7`coo`L07`03ool07`0O00H07`?oo`@07`Coo`L07i_oo`03003ooooo00;oo`00>_oo00<00?ooool0
0ooo1P0O00?oo`0O01l02@0O3Ooo1P0O0_oo0`0O00Coo`0O01l07`Coo`<07`Goo`H07i_oo`03003o
oooo00;oo`00>_oo00<00?ooool01?oo00@07oooool07`?oo`0301oooooo00807`;oo`807`koo`04
01ooo`0Oool201l3ool01@0Ooooooooo01l01_oo00<07oooool01Ooo0P0O00?oo`0Oool0Vooo00<0
0?ooool00_oo000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003o
oooo00;oo`00>_oo0P002ooo00<07ooo01l05Ooo0`0O0_oo100O0_oo00<07oooool01_oo0P0OYOoo
0P001?oo000jool00`00ooooo`09ool501lCool>01l6ool401nUool00`00ooooo`02ool003[oo`03
003ooooo00Soo`H07a;oo`l07`Goo`D07jGoo`03003ooooo00;oo`00>_oo00<00?ooool02Ooo100O
5?oo100O00?oo`0O01l00`0O00?oo`0O01l01ooo0`0OY_oo00<00?ooool00_oo000jool00`00oooo
o`3Nool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo0P00g_oo0P00
1?oo000jool00`00ooooo`03ool00`0Oooooo`03ool00`0Oooooo`05ool00`0Oooooo`0Aool01@0O
oooooooo01l00_oo00<07ooo01l01_oo00@07oooool07`;oo`0301ooo`0O00?oo`<07i[oo`03003o
oooo00;oo`00>_oo00<00?ooool00_oo0`0O0ooo0`0O1Ooo0`0O4Ooo0`0O00?oo`0O01l01P0O1?oo
2`0O00?oo`0O01l00`0OVOoo00<00?ooool00_oo0007ool40003ool00`00ooooo`02ool30003ool0
1@00oooooooo00001_oo10000ooo0P003Ooo00@00?ooooooo`@07`;oo`@07`Coo`@07a3oo`d07`?o
oa807iWoo`03003ooooo00;oo`001ooo00<00?ooool03?oo00L00?ooooooo`00ool00009ool01@00
oooooooo00000_oo00<00?ooool02_oo00<00?ooool00_oo0P0O1?oo0P0O1_oo0P0O4_oo0P0O0_oo
0P0O00?oo`0O01l00P0O1Ooo0P0O00Coo`0O01ooo`@07`;oo`@07i[oo`03003ooooo00;oo`002?oo
00<00?ooool02ooo00<00?ooool00_oo00<00?ooool02?oo00D00?ooooooo`0000;oo`03003ooooo
00[oo`03003ooooo0=koo`03003ooooo00;oo`002Ooo00<00?ooool01ooo0`001?oo00<00?oo0000
2Ooo00D00?ooooooo`0000;oo`03003ooooo00[oo`800=goo`<000Coo`002_oo00<00?ooool01_oo
00<00?ooool00ooo00D00?ooooooo`0000Soo`05003oooooool00002ool00`00ooooo`0:ool00`00
ooooo`3Nool00`00ooooo`02ool000Ooo`04003ooooo0008ool00`00ooooo`0>ool30003ool01000
ooooo`001ooo0`000_oo0P005Ooo0P0O1_oo0P0O3?oo100O3Ooo0P0OXOoo00<00?ooool00_oo0008
ool20009ool4000?ool00`00ooooo`02ool20009ool01`00oooooooo003oo`0001?oo`@07`Coo`@0
7`[oo`H07`_oo`@07j3oo`03003ooooo00;oo`00<?oo0`000ooo00@00?ooooooo`<001Coo`<07`Go
o`<07`_oo`D07`coo`<07j3oo`03003ooooo00;oo`00=_oo00D00?ooooooo`0001Ooo`0301oooooo
00Goo`0301oooooo00_oo`0301ooo`0O00koo`0301oooooo09ooo`03003ooooo00;oo`00=Ooo0P00
0ooo0P00g_oo0P001?oo000fool01000oooooooo0`00g_oo00<00?ooool00_oo000jool00`00oooo
o`3Nool00`00ooooo`02ool003[oo`03003ooooo00[oo`0301oooooo00Koo`<07`?oo`H07`03ool0
7`0O00goo`H07`;oo`@07`03ool07ooo0:3oo`03003ooooo00;oo`00>_oo00<00?ooool02Ooo0`0O
1_oo1@0O00?oo`0O01l02@0O2ooo400OX?oo00<00?ooool00_oo000jool00`00ooooo`0:ool201l7
ool401l2ool601l01?oo01l07`0O3?oo1`0O00?oo`0O01l01@0OX?oo00<00?ooool00_oo000jool2
000;ool00`0Oooooo`07ool201l4ool301l01Ooo01oooooo01l03Ooo1P0O0ooo0`0O00?oo`0Oool0
Wooo0P001?oo000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003o
oooo00;oo`00>_oo00<00?ooool05_oo0P0O1_oo0`0O_Ooo00<00?ooool00_oo000jool00`00oooo
o`0Eool401l4ool501nlool00`00ooooo`02ool003[oo`03003ooooo01Coo`D07`?oo`H07kcoo`03
003ooooo00;oo`00>_oo0P005_oo0`0O1Ooo100O_?oo0P001?oo000jool00`00ooooo`3Nool00`00
ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?oo
ool00_oo000jool00`00ooooo`0Gool201l2ool201lLool201lVool701mfool00`00ooooo`02ool0
03[oo`03003ooooo01Koo`L07a_oo`@07bCoo`T07gGoo`03003ooooo00;oo`00>_oo0P006?oo0`0O
00?oo`0O01l07?oo0`0O9Ooo200OM?oo0P001?oo000jool00`00ooooo`0Gool201l3ool00`0Ooooo
o`0Kool00`0Oooooo`0Tool401l00ooo01l07`1fool00`00ooooo`02ool003[oo`03003ooooo0=ko
o`03003ooooo00;oo`004ooo0`000ooo00D00?ooooooo`0000Koo`@000?oo`8000goo`03003ooooo
0=koo`03003ooooo00;oo`005_oo00L00?ooooooo`00ool00009ool01@00oooooooo00000_oo00<0
0?ooool02_oo00<00?ooool0g_oo00<00?ooool00_oo000Fool00`00ooooo`02ool00`00ooooo`08
ool01@00oooooooo00000_oo00<00?ooool02_oo00<00?ooool06Ooo00<07oooool05Ooo00<07ooo
ool0Z_oo00<00?ooool00_oo000Cool30004ool00`00ool00009ool01@00oooooooo00000_oo00<0
0?ooool02_oo0P006Ooo0`0O5Ooo0`0OZOoo0`001?oo000Cool00`00ooooo`03ool01@00oooooooo
00002?oo00D00?ooooooo`0000;oo`03003ooooo00[oo`03003ooooo01Woo`807aKoo`807j_oo`03
003ooooo00;oo`004ooo00<00?ooool03_oo0`000ooo00@00?ooool000Ooo`<000;oo`8001[oo`03
01oooooo01Goo`0301oooooo0:[oo`03003ooooo00;oo`004ooo10003ooo00<00?ooool00_oo0P00
2Ooo00L00?ooooooo`00ool0003Nool00`00ooooo`02ool0033oo`<000?oo`04003oooooool3003N
ool00`00ooooo`02ool003Koo`05003oooooool00016ool201l00ooo01ooo`0Fool301l2ool01@0O
ool07ooo01l0<Ooo1@0O?ooo00<00?ooool00_oo000eool20003ool20014ool601lFool;01l`ool6
01lmool20004ool003Koo`04003oooooool30012ool701lEool<01l_ool701lnool00`00ooooo`02
ool003[oo`03003ooooo04?oo`D07aOoo`<07`03ool07`0O00@07c7oo`D07cooo`03003ooooo00;o
o`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00ooooo`02ool0
03[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo0P006Ooo0P0O`ooo0P001?oo000jool00`00
ooooo`0Gool401o3ool00`00ooooo`02ool003[oo`03003ooooo01Soo`<07l?oo`03003ooooo00;o
o`00>_oo00<00?ooool06Ooo00<07oooool0`_oo00<00?ooool00_oo000jool00`00ooooo`3Nool0
0`00ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo0P00g_oo0P001?oo000j
ool00`00ooooo`15ool501lBool401l4ool201l01?oo01l07`0O0ooo0`0O9Ooo1P0O@ooo00<00?oo
ool00_oo000jool00`00ooooo`14ool701l@ool601l2ool801l00ooo01l07`0301lSool801m2ool0
0`00ooooo`02ool003[oo`03003ooooo04Goo`H07a7oo`D07`?oo`L07`;oo`@07bCoo`L07d;oo`03
003ooooo00;oo`00>_oo00<00?ooool0AOoo1@0O4ooo00<07ooo01l01Ooo00<07oooool00P0O1?oo
0P0O9_oo1@0O@ooo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`80
0=koo`8000Coo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00
ooooo`02ool000Soo`03003ooooo00?oo`03003ooooo00;oo`<000?oo`05003oooooool00006ool4
0003ool2000=ool00`00ooooo`3Nool00`00ooooo`02ool000Soo`03003ooooo00_oo`07003ooooo
ool00?oo00002Ooo00D00?ooooooo`0000;oo`03003ooooo00[oo`03003ooooo0=koo`03003ooooo
00;oo`002Ooo00<00?ooool02_oo00<00?ooool00_oo00<00?ooool02?oo00D00?ooooooo`0000;o
o`03003ooooo00[oo`03003ooooo0=koo`03003ooooo00;oo`002Ooo00<00?ooool01ooo0`001?oo
00<00?oo00002Ooo00D00?ooooooo`0000;oo`03003ooooo00[oo`800=goo`<000Coo`002_oo00<0
0?ooool01_oo00<00?ooool00ooo00D00?ooooooo`0000Soo`05003oooooool00002ool00`00oooo
o`0:ool00`00ooooo`3Nool00`00ooooo`02ool000Ooo`04003ooooo0008ool00`00ooooo`0>ool3
0003ool01000ooooo`001ooo0`000_oo0P00Booo00<07oooool03ooo00<07ooo01l02ooo00<07ooo
01l00ooo0`0O2Ooo00<07oooool00_oo0P0O5Ooo00<07oooool01?oo00<07oooool0??oo00<00?oo
ool00_oo0007ool40008ool4000?ool00`00ooooo`02ool20009ool01`00oooooooo003oo`0004Wo
o`<07`ooo`D07`Woo`D07`03ool07`0O00<07`Ooo`<07`;oo`@07a?oo`<07`Coo`807ckoo`03003o
oooo00;oo`00<?oo0`000ooo00@00?ooooooo`<004Soo`@07`koo`H07`Soo``07`Koo`@07`03ool0
7`0O00<07a;oo`@07`?oo`<07ckoo`03003ooooo00;oo`00=_oo00D00?ooooooo`0004_oo`807a3o
o`@07`[oo`@07`;oo`@07`Soo`807`?oo`<07aCoo`807`Goo`807ckoo`03003ooooo00;oo`00=Ooo
0P000ooo0P00g_oo0P001?oo000fool01000oooooooo0`00g_oo00<00?ooool00_oo000jool00`00
ooooo`3Nool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?oo
ool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`800=koo`80
00Coo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00ooooo`02
ool003[oo`03003ooooo04Woo`0301oooooo00;oo`0401ooooooool201l5ool01@0Oool07ooo01l0
3Ooo0`0O1Ooo00@07oooooooo`D07`03ool07`0O00Coo`H07`Koo`807`Coo`807`Soo`0301oooooo
03coo`03003ooooo00;oo`00>_oo00<00?ooool0BOoo0P0O0_oo0`0O0_oo0`0O0ooo1`0O2ooo1@0O
0ooo0`0O0_oo200O0ooo200O1Ooo0`0O0_oo100O1_oo0`0O?Ooo00<00?ooool00_oo000jool00`00
ooooo`18ool301l00ooo01l07`0201l00ooo01l07`0201l2ool801l:ool601l2ool401l00ooo01l0
7`0701l2ool901l4ool401l00ooo01l07`0301l5ool401lmool00`00ooooo`02ool003[oo`8004[o
o`0401ooooooool201l3ool201l4ool401l00ooo01ooo`0;ool401l4ool201l3ool801l3ool701l6
ool201l3ool301l7ool201lmool20004ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo
00<00?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`03
003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool2003N
ool20004ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?oo
ool00_oo000Cool40002ool01@00oooooooo00001_oo10000ooo0P003Ooo00<00?ooool0g_oo00<0
0?ooool00_oo000Eool00`00ooooo`02ool00`00ool00009ool01@00oooooooo00000_oo00<00?oo
ool02_oo00<00?ooool0g_oo00<00?ooool00_oo000Eool00`00ooooo`03ool00`00ooooo`08ool0
1@00oooooooo00000_oo00<00?ooool02_oo00<00?ooool0B_oo2@0O1_oo0`0O6_oo0P0O1Ooo100O
0ooo00<07ooo01l00`0O00Coo`0O01ooo`L07`[oo`807b3oo`807a_oo`03003ooooo00;oo`005Ooo
00<00?ooool00_oo00<00?oo00002Ooo00D00?ooooooo`0000;oo`03003ooooo00[oo`8004[oo`/0
7`Coo`D07aSoo`@07`?oo`H07`03ool07`0O01407`Soo`@07akoo`<07aWoo`<000Coo`005Ooo00D0
0?ooooooo`0000?oo`03003ooooo00Koo`05003oooooool00002ool00`00ooooo`0:ool00`00oooo
o`1:ool:01l5ool401lIool301l4ool501l2ool601l00ooo01l07`0901l9ool301lOool201lKool0
0`00ooooo`02ool001?oo`<000koo`<000?oo`04003ooooo0007ool30002ool2001<ool301l01Ooo
01l07ooo01l01ooo0P0O6ooo00<07oooool01?oo0`0O0ooo00H07oooool07ooo01l2ool01@0Ooooo
o`0Oool0100O2ooo00<07oooool07ooo00<07oooool06Ooo00<00?ooool00_oo000Eool00`00oooo
o`0>ool00`00ooooo`02ool20009ool01`00oooooooo003oo`000=koo`03003ooooo00;oo`00<?oo
0`000ooo00L00?ooooooo`00ool0003Nool00`00ooooo`02ool003Koo`04003oooooool2003Oool0
0`00ooooo`02ool003Goo`8000?oo`800=koo`8000Coo`00=_oo00@00?ooooooo`<00=koo`03003o
oooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00oooo
o`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool0
0_oo000jool2001Bool0100Oooooo`0O0_oo0`0O6Ooo00<07oooool04ooo0`0O00?oo`0O01l00ooo
00<07oooool03?oo00<07oooool02?oo00<07oooool02?oo00<07oooool01Ooo0`0O1?oo00<07ooo
ool05?oo0P001?oo000jool00`00ooooo`1@ool;01lGool301lCool801l01?oo01l07`0O3?oo0`0O
2?oo0P0O2Ooo0`0O1_oo100O0_oo0`0O5_oo00<00?ooool00_oo000jool00`00ooooo`1?ool<01lF
ool401lBool=01l;ool401l7ool301l8ool401l5ool501l00ooo01l07`0201lFool00`00ooooo`02
ool003[oo`03003ooooo053oo`807`04ool07`0Oool401lHool201lDool701l2ool201l=ool201l9
ool201l9ool201l7ool301l3ool201lGool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003o
oooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool2003Nool20004ool003[oo`03
003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00
ooooo`3Nool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?oo
ool0g_oo00<00?ooool00_oo000jool2003Nool20004ool003[oo`03003ooooo0=koo`03003ooooo
00;oo`00>_oo00<00?ooool0E?oo100O6ooo100O:_oo0P0O1_oo100O1ooo200O00Goo`0O01l07ooo
00<07`Goo`807`03ool07ooo00Koo`D07`Goo`03003ooooo00;oo`0000?oo`0000000P000ooo00<0
0?ooool00_oo10000_oo0`000ooo00D00?ooooooo`0000Koo`@000?oo`8000goo`03003ooooo05?o
o`D07a[oo`H07bSoo`@07`Coo`H07`Gooa807`?oo`H07`Goo`L07`Coo`03003ooooo00;oo`000ooo
00<00?ooool01ooo00<00?ooool01_oo00L00?ooooooo`00ool00009ool01@00oooooooo00000_oo
00<00?ooool02_oo00<00?ooool0E?oo100O6ooo1@0O:Ooo0`0O1Ooo1@0O1_oo4@0O1?oo1@0O1_oo
1P0O1?oo00<00?ooool00_oo0003ool00`00ooooo`08ool00`00ooooo`05ool00`00ooooo`02ool0
0`00ooooo`08ool01@00oooooooo00000_oo00<00?ooool02_oo00<00?ooool0EOoo0`0O7?oo0`0O
:ooo00<07oooool01Ooo0`0O1ooo0`0O00Koo`0O01ooo`0Oool301l2ool201l6ool00`0Oool07`08
ool0100Oool07`0O1Ooo00<00?ooool00_oo0003ool00`00ooooo`09ool01000oooooooo0`001?oo
00<00?oo00002Ooo00D00?ooooooo`0000;oo`03003ooooo00[oo`800=goo`<000Coo`000ooo00<0
0?ooool02_oo00@00?ooool000Goo`05003oooooool00008ool01@00oooooooo00000_oo00<00?oo
ool02_oo00<00?ooool0g_oo00<00?ooool00_oo00001?oo000000002Ooo00@00?ooool000;oo`03
003ooooo00koo`<000?oo`04003ooooo0007ool30002ool2003Oool00`00ooooo`02ool000?oo`03
003ooooo00Soo`8000?oo`@000ooo`03003ooooo00;oo`8000Woo`07003oooooool00?oo0000g_oo
00<00?ooool00_oo000`ool30003ool01`00oooooooo003oo`000=koo`03003ooooo00;oo`00=_oo
00@00?ooooooo`800=ooo`03003ooooo00;oo`00=Ooo0P000ooo00<00?ooool0g_oo00<00?ooool0
0_oo000fool01000oooooooo0`00gOoo0P001?oo000jool00`00ooooo`3Nool00`00ooooo`02ool0
03[oo`03003ooooo0:;oo`807`Coo`807`Woo`807`03ool07`0O00H07`Koo`X07`Coo`D07`Ooo`03
003ooooo00;oo`00>_oo00<00?ooool0XOoo100O0_oo100O1ooo3@0O1?oo300O0_oo1`0O1_oo00<0
0?ooool00_oo000jool00`00ooooo`2Rool301l3ool301l8ool<01l5ool;01l3ool601l6ool00`00
ooooo`02ool003[oo`03003ooooo0:?oo`0301oooooo00?oo`0301oooooo00Soo`0501oooooo01oo
o`0501l7ool301l00ooo01l07`0301l5ool201l00ooo01ooo`06ool00`00ooooo`02ool003[oo`80
0=koo`8000Coo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00
ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?oo
ool00_oo000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`800=koo`8000Coo`00>_oo00<0
0?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`03003o
oooo0:?oo`0301oooooo00Ooo`0501oooooo01ooo`0201l@ool01@0Ooooooooo01l01Ooo00@07ooo
ooooo`807`[oo`03003ooooo00;oo`00>_oo00<00?ooool0X_oo0`0O1ooo2@0O3_oo0`0O00Coo`0O
01l07`?oo`<07`03ool07`0O00807`Woo`03003ooooo00;oo`00>_oo00<00?ooool0XOoo100O1_oo
2P0O3Ooo200O0_oo2@0O2Ooo00<00?ooool00_oo000jool2002Sool201l8ool201l00ooo01l07`03
01l?ool201l2ool201l4ool201l2ool301l9ool20004ool003[oo`03003ooooo0=koo`03003ooooo
00;oo`001ooo10000ooo00<00?ooool00_oo0`000ooo00D00?ooooooo`0000Koo`@000?oo`8000go
o`03003ooooo0=koo`03003ooooo00;oo`002Ooo00<00?ooool02_oo00L00?ooooooo`00ool00009
ool01@00oooooooo00000_oo00<00?ooool02_oo00<00?ooool0g_oo00<00?ooool00_oo0009ool0
0`00ooooo`0:ool00`00ooooo`02ool00`00ooooo`08ool01@00oooooooo00000_oo00<00?ooool0
2_oo00<00?ooool0g_oo00<00?ooool00_oo0009ool00`00ooooo`07ool30004ool00`00ool00009
ool01@00oooooooo00000_oo00<00?ooool02_oo00<00?ooool0g_oo00<00?ooool00_oo0009ool0
0`00ooooo`07ool00`00ooooo`03ool01@00oooooooo00002?oo00D00?ooooooo`0000;oo`03003o
oooo00[oo`800=goo`<000Coo`001ooo0`002Ooo00<00?ooool03_oo0`000ooo00@00?ooool000co
o`03003ooooo0=koo`03003ooooo00;oo`002Ooo00<00?ooool01ooo10003ooo00<00?ooool00_oo
0P002?oo0`000_oo0P00gooo00<00?ooool00_oo000fool01`00oooooooo003oo`000=koo`03003o
oooo00;oo`00<?oo0`000ooo00L00?ooooooo`00ool0003Nool00`00ooooo`02ool003Koo`04003o
ooooool2002Vool401l4ool501lLool401l<ool00`00ooooo`02ool003Goo`8000?oo`800:Goo`H0
7`;oo`L07a[oo`H07`[oo`8000Coo`00=_oo00@00?ooooooo`<00:Goo`D07`?oo`H07a_oo`D07`_o
o`03003ooooo00;oo`00>_oo00<00?ooool0YOoo100O1Ooo100O7Ooo0`0O3?oo00<00?ooool00_oo
000jool00`00ooooo`3Nool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00
>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool2003Nool20004ool003[oo`03003ooooo0=ko
o`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<00?ooool00_oo000jool00`00ooooo`3Nool0
0`00ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo00<00?ooool0g_oo00<0
0?ooool00_oo000jool2002Uool0100Oooooo`0O=Ooo0P001?oo000jool00`00ooooo`2Sool301l0
0ooo01l07`0eool00`00ooooo`02ool003[oo`03003ooooo0:;oo`L07cGoo`03003ooooo00;oo`00
>_oo00<00?ooool0Xooo0P0O0_oo00<07oooool0=?oo00<00?ooool00_oo000jool00`00ooooo`3N
ool00`00ooooo`02ool003[oo`03003ooooo0=koo`03003ooooo00;oo`00>_oo0P00g_oo0P001?oo
000jool00`00ooooo`3Nool00`00ooooo`02ool00003ool00000008000?oo`03003ooooo00?oo`03
003ooooo00;oo`<000?oo`05003oooooool00006ool40003ool2000=ool00`00ooooo`3Nool00`00
ooooo`02ool000?oo`03003ooooo00Soo`03003ooooo00Goo`07003oooooool00?oo00002Ooo00D0
0?ooooooo`0000;oo`03003ooooo00[oo`03003ooooo0=koo`03003ooooo00;oo`000ooo00<00?oo
ool02Ooo00<00?ooool01?oo00<00?ooool00_oo00<00?ooool02?oo00D00?ooooooo`0000;oo`03
003ooooo00[oo`03003ooooo0=koo`03003ooooo00;oo`000ooo00<00?ooool02Ooo00@00?oooooo
o`<000Coo`03003oo`0000Woo`05003oooooool00002ool00`00ooooo`0:ool00`00ooooo`3Nool0
0`00ooooo`02ool000?oo`03003ooooo00[oo`04003ooooo0005ool01@00oooooooo00002?oo00D0
0?ooooooo`0000;oo`03003ooooo00[oo`800=goo`<000Coo`0000Coo`00000000Woo`04003ooooo
0002ool00`00ooooo`0>ool30003ool01000ooooo`003?oo00<00?ooool0YOoo00<07oooool0=_oo
00<00?ooool00_oo0003ool00`00ooooo`07ool40002ool4000?ool00`00ooooo`02ool20008ool3
0002ool2002Uool301lgool00`00ooooo`02ool003Koo`07003oooooool00?oo0000Xooo100O=ooo
00<00?ooool00_oo000`ool30003ool01`00oooooooo003oo`000:Coo`807cSoo`03003ooooo00;o
o`00=_oo00@00?ooooooo`800=ooo`03003ooooo00;oo`00=Ooo0P000ooo0P00g_oo0P001?oo000f
ool01000oooooooo0`000_oo00<00?ooool02?oo00<00?ooool02?oo00<00?ooool01ooo00<00?oo
ool02?oo00<00?ooool02?oo00<00?ooool01ooo00<00?ooool02?oo00<00?ooool02?oo00<00?oo
ool02?oo00<00?ooool01ooo00<00?ooool02?oo00<00?ooool02?oo00<00?ooool01ooo00<00?oo
ool02?oo00<00?ooool02?oo00<00?ooool02?oo00<00?ooool01ooo00<00?ooool02?oo00<00?oo
ool02?oo00<00?ooool02?oo00<00?ooool00_oo00<00?ooool00_oo000joooR0004ool00?ooob7o
o`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003o
oolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7o
o`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003o
oolQool00?ooob7oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {511.062, 152.312}} -> {-64.6336, \
6.5966*^-16, 0.466552, 8.3009*^-18}}]
}, Open  ]],

Cell["\<\
There is a curious drift in the error in the Hamiltonian that is \
actually a numerical artifact of floating point arithmetic.\
\>", "Text"],

Cell["\<\
This phenomenon can have an impact on long time integrations.\
\>", \
"Text"],

Cell[TextData[{
  "This section describes the formulation used by ",
  StyleBox["SymplecticPartitionedRungeKutta", "MR"],
  " in order to reduce the effect of such errors."
}], "Text"],

Cell["\<\
There are two types of errors in integrating a flow numerically, \
those along the flow and those transverse to the flow. In contrast to \
dissipative systems, the rounding errors in Hamiltonian systems that are \
transverse to the flow are not damped asymptotically.\
\>", "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0029216 0.0238095 0.00291978 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.4 0 0 1 k
1 Mabswid
[ ] 0 Mabsdash
.23085 .3953 m
.23043 .40392 L
.2292 .41229 L
.22721 .42037 L
.22449 .42812 L
.21702 .44244 L
.20714 .45491 L
.19515 .46521 L
.1814 .47298 L
.17396 .47582 L
.1662 .47789 L
.15817 .47917 L
.14989 .47961 L
.14161 .47917 L
.13357 .47789 L
.12581 .47582 L
.11838 .47298 L
.10462 .46521 L
.09264 .45491 L
.08275 .44244 L
.07529 .42812 L
.07257 .42037 L
.07057 .41229 L
.06935 .40392 L
.06893 .3953 L
.06935 .38668 L
.07057 .37831 L
.07257 .37023 L
.07529 .36249 L
.08275 .34817 L
.09264 .33569 L
.10462 .3254 L
.11837 .31762 L
.12581 .31479 L
.13357 .31271 L
.14161 .31143 L
.14989 .311 L
.15817 .31143 L
.1662 .31271 L
.17396 .31479 L
.1814 .31762 L
.19515 .3254 L
.20714 .33569 L
.21702 .34817 L
.22449 .36249 L
.22721 .37023 L
.2292 .37831 L
.23043 .38668 L
.23085 .3953 L
.23085 .3953 L
Mistroke
Mfstroke
.06885 .39625 m
.0696 .42609 L
.07182 .45554 L
.07548 .48457 L
.08055 .51313 L
.08698 .54118 L
.09475 .56871 L
.1038 .59565 L
.11412 .62199 L
.12565 .64768 L
.13838 .67268 L
.15225 .69697 L
.16723 .7205 L
.18329 .74324 L
.20039 .76515 L
.2185 .78619 L
.23758 .80633 L
.25758 .82553 L
.27849 .84376 L
.30025 .86098 L
.32284 .87715 L
.34621 .89223 L
.37033 .90619 L
.39517 .919 L
.42069 .93062 L
.44685 .941 L
.47362 .95012 L
.50095 .95793 L
.52883 .96441 L
.55719 .96951 L
.58603 .9732 L
.61528 .97544 L
.64493 .97619 L
s
.23085 .39684 m
.23139 .41815 L
.23299 .43917 L
.23562 .45989 L
.23927 .48028 L
.24389 .50031 L
.24947 .51996 L
.25599 .5392 L
.26341 .558 L
.2717 .57633 L
.28085 .59419 L
.29083 .61152 L
.3016 .62832 L
.31315 .64456 L
.32545 .6602 L
.33847 .67522 L
.35219 .6896 L
.36658 .7033 L
.38161 .71632 L
.39726 .72861 L
.4135 .74015 L
.43031 .75092 L
.44766 .76089 L
.46552 .77003 L
.48387 .77833 L
.50269 .78574 L
.52193 .79225 L
.54159 .79783 L
.56164 .80245 L
.58204 .80609 L
.60277 .80872 L
.62381 .81032 L
.64513 .81086 L
s
.72774 .89343 m
.72732 .90189 L
.72606 .91011 L
.72402 .91804 L
.72123 .92564 L
.7136 .9397 L
.70349 .95195 L
.69123 .96206 L
.67716 .96969 L
.66955 .97247 L
.66162 .97451 L
.65339 .97576 L
.64493 .97619 L
s
.72774 .89342 m
.72732 .88496 L
.72606 .87674 L
.72402 .86881 L
.72123 .86121 L
.7136 .84715 L
.70349 .8349 L
.69123 .8248 L
.67716 .81716 L
.66955 .81438 L
.66162 .81234 L
.65339 .81109 L
.64493 .81066 L
s
.4793 .1476 m
.47888 .15622 L
.47765 .16459 L
.47566 .17267 L
.47293 .18042 L
.46547 .19474 L
.45558 .20721 L
.4436 .21751 L
.42985 .22528 L
.42241 .22811 L
.41465 .23019 L
.40661 .23147 L
.39834 .2319 L
.39006 .23147 L
.38202 .23019 L
.37426 .22811 L
.36682 .22528 L
.35307 .21751 L
.34109 .20721 L
.3312 .19474 L
.32374 .18042 L
.32102 .17267 L
.31902 .16459 L
.31779 .15622 L
.31738 .1476 L
.31779 .13898 L
.31902 .13061 L
.32102 .12253 L
.32374 .11479 L
.3312 .10047 L
.34109 .08799 L
.35307 .0777 L
.36682 .06992 L
.37426 .06709 L
.38202 .06501 L
.39006 .06373 L
.39834 .0633 L
.40661 .06373 L
.41465 .06501 L
.42241 .06709 L
.42985 .06992 L
.4436 .0777 L
.45558 .08799 L
.46547 .10047 L
.47293 .11479 L
.47566 .12253 L
.47765 .13061 L
.47888 .13898 L
.4793 .1476 L
.4793 .1476 L
Mistroke
Mfstroke
.31729 .14796 m
.31804 .1778 L
.32027 .20725 L
.32393 .23627 L
.329 .26483 L
.33543 .29289 L
.34319 .32041 L
.35225 .34736 L
.36256 .3737 L
.3741 .39938 L
.38682 .42439 L
.40069 .44868 L
.41568 .47221 L
.43174 .49494 L
.44884 .51685 L
.46695 .5379 L
.48602 .55804 L
.50603 .57724 L
.52693 .59547 L
.5487 .61268 L
.57128 .62885 L
.59466 .64394 L
.61878 .6579 L
.64362 .67071 L
.66914 .68232 L
.6953 .69271 L
.72207 .70182 L
.7494 .70964 L
.77727 .71612 L
.80564 .72121 L
.83447 .72491 L
.86373 .72714 L
.89337 .7279 L
s
.4793 .14914 m
.47984 .17045 L
.48143 .19147 L
.48407 .21219 L
.48771 .23258 L
.49234 .25261 L
.49792 .27226 L
.50443 .29149 L
.51185 .31029 L
.52015 .32863 L
.5293 .34649 L
.53927 .36382 L
.55005 .38062 L
.5616 .39685 L
.5739 .41249 L
.58692 .42752 L
.60064 .4419 L
.61502 .4556 L
.63006 .46862 L
.64571 .48091 L
.66195 .49245 L
.67876 .50322 L
.69611 .51319 L
.71397 .52233 L
.73232 .53062 L
.75113 .53804 L
.77038 .54454 L
.79004 .55012 L
.81009 .55475 L
.83049 .55839 L
.85122 .56102 L
.87226 .56262 L
.89358 .56316 L
s
.97619 .64573 m
.97576 .65419 L
.97451 .66241 L
.97247 .67034 L
.96968 .67794 L
.96205 .692 L
.95194 .70425 L
.93968 .71435 L
.92561 .72199 L
.918 .72477 L
.91007 .72681 L
.90184 .72806 L
.89337 .72849 L
s
.97619 .64572 m
.97576 .63726 L
.97451 .62904 L
.97247 .62111 L
.96968 .61351 L
.96205 .59945 L
.95194 .5872 L
.93968 .57709 L
.92561 .56946 L
.918 .56668 L
.91007 .56464 L
.90184 .56339 L
.89337 .56296 L
s
.46222 .35546 m
.46189 .36824 L
.46093 .38085 L
.45935 .39327 L
.45717 .4055 L
.4544 .41751 L
.45105 .42929 L
.44714 .44083 L
.44269 .45211 L
.43772 .4631 L
.43223 .47381 L
.42625 .48421 L
.41979 .49428 L
.41286 .50402 L
.40548 .5134 L
.39768 .52241 L
.38945 .53103 L
.38082 .53925 L
.37181 .54705 L
.36242 .55442 L
.35268 .56135 L
.3426 .56781 L
.3322 .57378 L
.32148 .57927 L
.31048 .58424 L
.2992 .58869 L
.28765 .59259 L
.27586 .59594 L
.26384 .59871 L
.25161 .60089 L
.23917 .60247 L
.22656 .60343 L
.21377 .60375 L
s
.46222 .37006 m
.45491 .37006 L
.46222 .34086 L
.46952 .37006 L
.46222 .37006 L
F
.48466 .39684 m
.49179 .41799 L
.50061 .43854 L
.51098 .45837 L
.52279 .47738 L
.53592 .49547 L
.55023 .51253 L
.5656 .52845 L
.58191 .54315 L
.59904 .5565 L
.61687 .56841 L
.63525 .57878 L
.65409 .58749 L
.67324 .59445 L
.69258 .59955 L
.712 .60268 L
.73137 .60375 L
s
.71676 .60375 m
.71676 .59645 L
.74598 .60375 L
.71676 .61105 L
.71676 .60375 L
F
gsave
.10415 .38002 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.1875 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
70.375 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(H) show
76.500 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
78.625 15.000 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
83.938 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.35979 .126 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.4375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 16.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 16.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
64.812 8.500 moveto
(`) show
70.375 20.250 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(H) show
76.500 20.250 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
78.625 20.250 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(h) show
83.938 16.688 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.34226 .50557 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.0625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
67.625 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
71.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5497 .54937 -61 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.75 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
67.625 15.000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
73.875 13.125 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[103]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40n007h00Ooooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00
oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00oooo8Ooo003ooolQ
ool00?ooob7oo`00oooo8Ooo001/ool=002Wool006[oo`<000_oo`<00:Goo`00J?oo0`003ooo0`00
Xooo001Vool3000Cool3002Qool006Goo`8001Ooo`800:3oo`00Hooo0P006ooo00<00?ooool0WOoo
001Rool2000Mool00`00ooooo`2Lool0067oo`03003ooooo01koo`03003ooooo09_oo`00H?oo00<0
0?ooool08?oo00<00?ooool0V_oo001Pool00`00ooooo`0Qool00`00ooooo`2Iool005ooo`03003o
oooo02?oo`03003ooooo09Soo`00G_oo00<00?ooool09?oo0P00VOoo001Mool2000Wool00`00oooo
o`2Gool005goo`03003ooooo02Koo`8009Soo`00G?oo00<00?ooool0:?oo00<00?ooool0U_oo001L
ool00`00ooooo`0Xool00`00ooooo`2Fool005coo`03003ooooo02Woo`03003ooooo09Goo`00G?oo
00<00?ooool0:Ooo00<00?ooool0UOoo001Kool2000[ool2002Fool005_oo`03003ooooo01Soo`03
003ooooo013oo`03003ooooo09Coo`00Fooo00<00?ooool06Ooo00<00?ooool03ooo00<00?ooool0
U?oo001Kool00`00ooooo`0<ool00`00ooooo`03ool300000ooo0000000400000ooo0000000<ool0
0`00ooooo`2Dool005_oo`03003ooooo00goo`03003ooooo00?oo`05003oooooool00003ool00`00
ool0000=ool00`00ooooo`2Dool005_oo`03003ooooo00goo`03003ooooo00?oo`05003oooooool0
0003ool00`00ool0000=ool00`00ooooo`2Dool005_oo`03003ooooo00coo`<000Coo`D000?oo`<0
00goo`03003ooooo09Coo`00Fooo00<00?ooool02ooo00D00?oo003oo`0000?oo`05003oooooool0
0003ool00`00ooooo`0=ool00`00ooooo`2Dool005_oo`03003ooooo00_oo`07003ooooo003oo`00
ool00`0000Coo`00000000;oo`03003ooooo00goo`03003ooooo09Coo`00Fooo00<00?ooool02ooo
00H00?ooool00?oo000Jool00`00ooooo`2Dool005_oo`03003ooooo00coo`05003oo`00ool0000J
ool00`00ooooo`2Dool005_oo`03003ooooo00_oo`04003ooooo0002ool00`00ooooo`0Gool00`00
ooooo`2Dool005_oo`8000ooo`03003ooooo01Woo`8009Koo`00Fooo0P004?oo00<00?ooool06?oo
0P00U_oo001Kool2000Zool3002Fool005_oo`8000koo`04003ooooo000Hool01000ool00000UOoo
001Kool00`00ool0000>ool2000Hool20002ool00`00ooooo`2Cool005_oo`04003oo`00000=ool2
000Hool01@00oooooooo0000UOoo001Kool01000ooooo`009_oo0P000ooo00<00?ooool0Tooo001K
ool01@00oooooooo00009Ooo00<00?ooool00_oo00<00?ooool0Tooo001Kool01000oooooooo0P00
8ooo00<00?ooool00ooo00<00?ooool0Tooo001Kool00`00ooooo`02ool00`00ooooo`0Pool20005
ool00`00ooooo`2Cool005_oo`03003ooooo00;oo`80027oo`03003ooooo00Coo`03003ooooo09?o
o`00Fooo00<00?ooool00ooo00<00?ooool07_oo00<00?ooool01Ooo00<00?ooool0Tooo001Kool0
0`00ooooo`04ool2000Mool00`00ooooo`06ool00`00ooooo`2Cool005_oo`03003ooooo00Goo`80
01_oo`03003ooooo00Ooo`03003ooooo09?oo`00Fooo00<00?ooool01ooo0P005ooo0P002_oo00<0
0?ooool0Tooo001Kool20009ool3000Cool3000;ool2002Dool005coo`03003ooooo00Woo`<000oo
o`<000koo`03003ooooo09;oo`00G?oo00<00?ooool02ooo0`002ooo0`004?oo00<00?ooool0T_oo
001Lool00`00ooooo`0=ool=000Bool00`00ooooo`2Bool005coo`03003ooooo02coo`03003ooooo
09;oo`00G?oo00<00?ooool0;Ooo00<00?ooool0TOoo001Lool00`00ooooo`0]ool00`00ooooo`2A
ool005goo`03003ooooo02coo`03003ooooo097oo`00GOoo00<00?ooool0;Ooo00<00?ooool0T?oo
001Mool00`00ooooo`0]ool00`00ooooo`2@ool005goo`03003ooooo02goo`03003ooooo093oo`00
G_oo00<00?ooool0;?oo00<00?ooool0T?oo001Nool00`00ooooo`0/ool2002Aool005koo`03003o
oooo02goo`03003ooooo08ooo`00G_oo00<00?ooool0;Ooo00<00?ooool0Sooo001Nool2000^ool0
0`00ooooo`2?ool005ooo`03003ooooo02coo`03003ooooo08ooo`00Gooo00<00?ooool0;Ooo00<0
0?ooool0S_oo001Oool00`00ooooo`0]ool00`00ooooo`2>ool005ooo`8002ooo`03003ooooo08go
o`00H?oo00<00?ooool0;Ooo00<00?ooool0SOoo001Pool00`00ooooo`0]ool00`00ooooo`2=ool0
063oo`03003ooooo02koo`03003ooooo08coo`00HOoo00<00?ooool0;Ooo00<00?ooool0S?oo001Q
ool00`00ooooo`0]ool00`00ooooo`2<ool0067oo`03003ooooo02koo`03003ooooo08_oo`009Ooo
3000<?oo00<00?ooool0;_oo00<00?ooool0Rooo000Sool3000:ool3000_ool00`00ooooo`0^ool0
0`00ooooo`2:ool0027oo`80013oo`<002coo`03003ooooo02koo`03003ooooo08[oo`007ooo0P00
5?oo0`00:_oo00<00?ooool0;ooo00<00?ooool0ROoo000Nool00`00ooooo`0Fool2000Zool00`00
ooooo`0^ool00`00ooooo`29ool001coo`8001_oo`03003ooooo02Ooo`03003ooooo02ooo`03003o
oooo08Soo`006ooo0P007Ooo00<00?ooool09_oo0P00<?oo00<00?ooool0R?oo000Jool00`00oooo
o`0Nool00`00ooooo`0Vool00`00ooooo`0_ool00`00ooooo`27ool001Woo`03003ooooo023oo`03
003ooooo02Goo`03003ooooo02ooo`03003ooooo08Ooo`006?oo00<00?ooool08_oo00<00?ooool0
9Ooo00<00?ooool07?oo00<00?ooool04?oo00<00?ooool0Q_oo000Gool00`00ooooo`0Tool00`00
ooooo`0Tool00`00ooooo`0Lool00`00ooooo`0@ool00`00ooooo`26ool001Ooo`03003ooooo02Co
o`03003ooooo02Coo`03003ooooo01coo`03003ooooo017oo`03003ooooo08Goo`005_oo00<00?oo
ool09_oo00<00?ooool09?oo00<00?ooool06ooo00<00?ooool04Ooo00<00?ooool0QOoo000Fool0
0`00ooooo`0Vool00`00ooooo`0Tool00`00ooooo`0Jool3000Cool00`00ooooo`24ool001Goo`03
003ooooo02Soo`03003ooooo02?oo`8001_oo`<001?oo`03003ooooo08Coo`005Ooo00<00?ooool0
:?oo00<00?ooool09?oo00<00?ooool06Ooo0`005?oo00<00?ooool0Pooo000Dool2000Zool2000U
ool00`00ooooo`0Iool3000Eool00`00ooooo`22ool001Coo`03003ooooo02[oo`03003ooooo02Co
o`03003ooooo01Ooo`@001Goo`03003ooooo08;oo`005?oo00<00?ooool0:_oo00<00?ooool09?oo
00<00?ooool06Ooo00<00?ooool05Ooo00<00?ooool0POoo000Dool00`00ooooo`0Zool00`00oooo
o`0Tool00`00ooooo`0Iool00`00ooooo`0Eool00`00ooooo`21ool001?oo`8002coo`8002Koo`03
003ooooo01Soo`03003ooooo01Koo`03003ooooo083oo`004ooo00<00?ooool05ooo00<00?ooool0
4_oo00<00?ooool09?oo00<00?ooool06?oo00<00?ooool05ooo00<00?ooool0Oooo000Cool00`00
ooooo`0:ool00`00ooooo`0;ool00`00ooooo`0Aool00`00ooooo`0Uool00`00ooooo`0Fool00`00
ooooo`0Iool00`00ooooo`1nool001?oo`03003ooooo00_oo`03003ooooo00?oo`<00003ool00000
00@00003ool0000000koo`03003ooooo02Goo`03003ooooo01Koo`03003ooooo01[oo`03003ooooo
07goo`004ooo00<00?ooool02ooo00<00?ooool01?oo00D00?ooooooo`0000?oo`03003oo`0000oo
o`03003ooooo02Koo`03003ooooo01Goo`03003ooooo00Goo`03003ooooo01?oo`03003ooooo07co
o`004ooo00<00?ooool02_oo0`001Ooo00D00?ooooooo`0000?oo`03003oo`0000ooo`03003ooooo
02Koo`03003ooooo01Goo`03003ooooo00Goo`03003ooooo01Coo`03003ooooo07_oo`004ooo00<0
0?ooool02Ooo00D00?oo003oo`0000Coo`D000?oo`<000ooo`03003ooooo02Koo`8001Koo`03003o
oooo00Koo`03003ooooo01?oo`03003ooooo07_oo`004ooo00<00?ooool02Ooo00H00?ooool00?oo
0003ool01@00oooooooo00000ooo00<00?ooool03ooo00<00?ooool09ooo00<00?ooool05?oo00<0
0?ooool01_oo00<00?ooool05?oo00<00?ooool0N_oo000Cool2000:ool01P00ooooo`00ool000;o
o`<00004ool000000002ool00`00ooooo`0>ool2000Zool00`00ooooo`0Cool00`00ooooo`06ool0
0`00ooooo`0Dool00`00ooooo`1jool001?oo`8000_oo`05003oo`00ool0000Lool2000Zool00`00
ooooo`0Bool00`00ooooo`08ool00`00ooooo`0Dool00`00ooooo`1iool001?oo`8000[oo`04003o
oooo0002ool00`00ooooo`0Iool2000[ool00`00ooooo`0Aool00`00ooooo`08ool00`00ooooo`0E
ool00`00ooooo`1hool001?oo`8000goo`03003ooooo01coo`8002_oo`8001;oo`03003ooooo00So
o`03003ooooo01Koo`03003ooooo07Ooo`004ooo0`003Ooo00<00?ooool06_oo0`00;?oo00<00?oo
ool03ooo0P002ooo00<00?ooool05_oo00<00?ooool0M_oo000Cool00`00ool0000Zool00`00ool0
000/ool2000@ool00`00ooooo`0:ool00`00ooooo`0Gool00`00ooooo`1eool001?oo`04003oo`00
000Xool200000ooo003oo`0/ool00`00ooooo`0>ool00`00ooooo`0:ool00`00ooooo`0Hool00`00
ooooo`1dool001?oo`04003ooooo000Xool01000ooooo`00;_oo00<00?ooool03Ooo00<00?ooool0
2ooo00<00?ooool06?oo00<00?ooool0Looo000Cool00`00ooooo`02000Vool20002ool00`00oooo
o`0/ool00`00ooooo`0<ool00`00ooooo`0<ool00`00ooooo`0Iool00`00ooooo`1bool001?oo`80
00;oo`03003ooooo02Coo`05003oooooool0000_ool00`00ooooo`0;ool00`00ooooo`0<ool2000K
ool00`00ooooo`1aool001Coo`05003oooooool0000Tool00`00ooooo`02ool00`00ooooo`0]ool2
000<ool00`00ooooo`0=ool00`00ooooo`0Jool00`00ooooo`1`ool001Coo`04003oooooool2000R
ool20004ool00`00ooooo`0^ool00`00ooooo`09ool00`00ooooo`0>ool2000Lool00`00ooooo`1_
ool001Coo`03003ooooo00;oo`03003ooooo023oo`03003ooooo00Coo`03003ooooo02goo`8000[o
o`03003ooooo00ooo`03003ooooo01_oo`03003ooooo06koo`005?oo00<00?ooool00ooo00<00?oo
ool07_oo00<00?ooool01Ooo00<00?ooool0;_oo00<00?ooool01ooo00<00?ooool04?oo0P007Ooo
00<00?ooool0KOoo000Dool00`00ooooo`04ool2000Mool00`00ooooo`06ool00`00ooooo`0_ool0
0`00ooooo`06ool00`00ooooo`0Aool00`00ooooo`0Lool00`00ooooo`1/ool001Coo`03003ooooo
00Goo`8001_oo`03003ooooo00Ooo`03003ooooo02ooo`03003ooooo00Goo`03003ooooo01?oo`03
003ooooo01coo`03003ooooo06_oo`005?oo00<00?ooool01ooo00<00?ooool05_oo0P002_oo00<0
0?ooool0<?oo00<00?ooool01?oo00<00?ooool04ooo00<00?ooool07Ooo00<00?ooool0J_oo000D
ool00`00ooooo`08ool2000Dool3000;ool2000aool20004ool00`00ooooo`0Eool00`00ooooo`0M
ool00`00ooooo`1Yool001Goo`03003ooooo00Woo`80013oo`<000koo`03003ooooo033oo`03003o
oooo00;oo`03003ooooo01Koo`03003ooooo01goo`8006Woo`005Ooo00<00?ooool02ooo0`002_oo
0`004Ooo00<00?ooool0<?oo0P000_oo00<00?ooool05ooo00<00?ooool07_oo0P00J?oo000Eool0
0`00ooooo`0=ool<000Cool00`00ooooo`0aool01000ooooo`006_oo00<00?ooool07_oo0P00Iooo
000Eool00`00ooooo`0/ool00`00ooooo`0bool2000Lool00`00ooooo`0Oool00`00ooooo`1Tool0
01Goo`03003ooooo02coo`03003ooooo03;oo`03003ooooo01_oo`03003ooooo023oo`8006Coo`00
5Ooo00<00?ooool0;?oo0P00<ooo0P007Ooo00<00?ooool08?oo0P00Hooo000Eool2000^ool00`00
ooooo`0`ool01000ool000007?oo00<00?ooool08_oo00<00?ooool0H?oo000Fool00`00ooooo`0/
ool00`00ooooo`0_ool01@00oooooooo00007Ooo00<00?ooool08_oo0P00H?oo000Fool00`00oooo
o`0/ool00`00ooooo`0_ool00`00ooooo`02ool00`00ooooo`0Kool00`00ooooo`0Sool2001Nool0
01Koo`03003ooooo02coo`03003ooooo02koo`03003ooooo00Coo`03003ooooo01[oo`8002Koo`03
003ooooo05_oo`005_oo0P00;_oo00<00?ooool0;?oo00<00?ooool01Ooo0P007?oo0P009_oo0P00
Fooo000Gool00`00ooooo`0/ool00`00ooooo`0/ool00`00ooooo`06ool00`00ooooo`0Kool00`00
ooooo`0Vool2001Iool001Ooo`03003ooooo02coo`03003ooooo023oo`03003ooooo00Soo`03003o
oooo00Soo`03003ooooo01_oo`03003ooooo02Ooo`8005Ooo`005ooo00<00?ooool0;Ooo00<00?oo
ool07ooo00<00?ooool01ooo00<00?ooool02_oo00<00?ooool06ooo0P00:Ooo0P00EOoo000Gool0
0`00ooooo`0]ool00`00ooooo`0Kool300000ooo003oo`07ool00`00ooooo`0<ool00`00ooooo`0K
ool2000Zool3001Bool001Ooo`03003ooooo02goo`03003ooooo01[oo`04003oooooool20007ool0
0`00ooooo`0>ool00`00ooooo`0Kool2000[ool3001@ool001Ooo`8002ooo`03003ooooo01Woo`03
003ooooo00;oo`03003ooooo00Coo`03003ooooo013oo`03003ooooo01coo`03003ooooo02[oo`<0
04koo`006?oo00<00?ooool0;Ooo00<00?ooool06Ooo10001ooo00<00?ooool04_oo00<00?ooool0
7?oo0P00;?oo0`00C?oo000Hool00`00ooooo`0^ool00`00ooooo`0Iool00`00ooooo`06ool00`00
ooooo`0Dool00`00ooooo`0Lool2000^ool2001:ool001Soo`03003ooooo02koo`03003ooooo01[o
o`<000Coo`03003ooooo01Koo`03003ooooo01coo`8002ooo`<004Ooo`006?oo00<00?ooool0;_oo
00<00?ooool08?oo00<00?ooool06?oo00<00?ooool07Ooo00<00?ooool0;ooo0`00A?oo000Hool0
0`00ooooo`0_ool00`00ooooo`0Nool00`00ooooo`0Jool00`00ooooo`0Mool00`00ooooo`0aool4
0010ool001Woo`03003ooooo02koo`03003ooooo01goo`03003ooooo01_oo`8001ooo`03003ooooo
03Coo`@003coo`006Ooo00<00?ooool0;_oo00<00?ooool07?oo00<00?ooool07Ooo00<00?ooool0
7_oo00<00?ooool0=ooo0`00>Ooo000Iool2000`ool00`00ooooo`0Jool00`00ooooo`0Oool00`00
ooooo`0Hool00`00ooooo`03ool00`00ooooo`0iool5000dool001[oo`03003ooooo02koo`03003o
oooo01Soo`8002?oo`03003ooooo01Soo`03003ooooo00?oo`8003goo`L002koo`006_oo00<00?oo
ool0;_oo00<00?ooool05_oo0P009_oo00<00?ooool05_oo0`001_oo00<00?ooool0@?oo4`007?oo
000Kool00`00ooooo`0^ool00`00ooooo`0Cool2000Yool2000Eool01000ool000001ooo0P00Dooo
1@005ooo000Kool00`00ooooo`0^ool00`00ooooo`0Aool2000/ool2000@ool300001_oo003oo`00
ool000Soo`03003ooooo05Coo`<001Goo`006ooo00<00?ooool0;ooo00<00?ooool03ooo00<00?oo
ool0;_oo00<00?ooool03?oo00<00?ooool00_oo00<00?ooool00P002Ooo0P00E_oo0`004ooo000L
ool00`00ooooo`0^ool00`00ooooo`0=ool2000bool00`00ooooo`0;ool00`00ooooo`02ool01P00
ooooo`00ool000[oo`8005Koo`8001;oo`007?oo00<00?ooool0;ooo00<00?ooool02_oo0P00=Ooo
00<00?ooool02_oo10001?oo00<00?ooool03?oo0P00E_oo0P004?oo000Lool00`00ooooo`0_ool0
0`00ooooo`06ool4000hool2000;ool00`00ooooo`0Eool2001Eool2000?ool001coo`03003ooooo
033oo`03003ooooo00?oo`<003coo`8000_oo`<001Koo`<005Coo`03003ooooo00coo`007Ooo00<0
0?ooool0;ooo00@00?ooooooo`80047oo`03003ooooo02Coo`<005;oo`03003ooooo00_oo`007Ooo
00<00?ooool0<?oo0`00A?oo00<00?ooool09_oo0`00Cooo0P003?oo000Mool00`00ooooo`0Zool8
0016ool00`00ooooo`0Xool2001>ool00`00ooooo`0:ool001koo`03003ooooo02;oo`L000Ooo`03
003ooooo04Goo`8002[oo`d004;oo`03003ooooo00Woo`007_oo00<00?ooool07?oo1P003ooo00<0
0?ooool0AOoo0P00<Ooo2@00?_oo0P002_oo000Nool2000bool00`00ooooo`17ool00`00ooooo`0^
ool50013ool00`00ooooo`08ool001ooo`03003ooooo037oo`03003ooooo04Ooo`03003ooooo07Go
o`8000Woo`007ooo00<00?ooool0<_oo00<00?ooool0Aooo00<00?ooool0MOoo00<00?ooool01ooo
000Pool00`00ooooo`0aool00`00ooooo`18ool2001eool20008ool0023oo`03003ooooo03;oo`03
003ooooo04Soo`8007Goo`03003ooooo00Koo`008?oo0P00<ooo00<00?ooool0B_oo00<00?ooool0
L_oo00<00?ooool01_oo000Qool00`00ooooo`0bool00`00ooooo`1:ool2001bool00`00ooooo`06
ool002;oo`03003ooooo03;oo`03003ooooo04[oo`80077oo`8000Ooo`008_oo00<00?ooool0<_oo
0P00COoo0P00L?oo00<00?ooool01Ooo000Sool00`00ooooo`0bool00`00ooooo`1=ool2001^ool0
0`00ooooo`05ool002?oo`8003Coo`03003ooooo04goo`<006coo`03003ooooo00Goo`009?oo00<0
0?ooool0<ooo00<00?ooool0C_oo0P00Jooo00<00?ooool01Ooo000Tool00`00ooooo`0cool2001A
ool2001Yool00`00ooooo`05ool002Goo`03003ooooo03?oo`8005;oo`8006Ooo`03003ooooo00Go
o`009Ooo00<00?ooool0=?oo00<00?ooool0DOoo0`00IOoo00<00?ooool01Ooo000Uool2000fool0
0`00ooooo`1Bool2001Sool00`00ooooo`06ool002Koo`03003ooooo03Goo`03003ooooo05?oo`80
067oo`03003ooooo00Koo`009_oo00<00?ooool0=_oo00<00?ooool0E?oo0P00Gooo00<00?ooool0
1_oo000Wool00`00ooooo`0fool00`00ooooo`1Dool3001Mool00`00ooooo`06ool002Ooo`03003o
oooo03Ooo`03003ooooo05Koo`<005Woo`8000Soo`009ooo0P00>Ooo00<00?ooool0Eooo0`00Eooo
00<00?ooool01ooo000Xool00`00ooooo`0hool00`00ooooo`1Iool3001Cool20009ool002Woo`03
003ooooo03Soo`03003ooooo05_oo`80057oo`03003ooooo00Soo`00:Ooo00<00?ooool0>Ooo00<0
0?ooool0G?oo0P00C_oo0P002_oo000Zool00`00ooooo`0iool00`00ooooo`1Mool3001;ool00`00
ooooo`09ool002[oo`8003_oo`03003ooooo05ooo`<004Ooo`03003ooooo00[oo`00:ooo00<00?oo
ool0>_oo00<00?ooool0H?oo0`00A?oo0P003?oo000/ool00`00ooooo`0jool00`00ooooo`1Rool4
0010ool00`00ooooo`0;ool002coo`03003ooooo03_oo`03003ooooo06Coo`D003_oo`03003ooooo
00coo`00;Ooo00<00?ooool0>ooo00<00?ooool0Iooo1@00=Ooo0P003ooo000^ool00`00ooooo`0k
ool00`00ooooo`1Zool5000`ool2000@ool002koo`03003ooooo03coo`03003ooooo06goo`L002So
o`8001;oo`00;ooo00<00?ooool0??oo0P00Looo1`008?oo0`004ooo000`ool00`00ooooo`0lool2
001hool5000Jool3000Eool0033oo`8003koo`8007_ooa`001Ooo`00<Ooo00<00?ooool0?_oo00<0
0?ooool0Rooo0P007_oo000bool00`00ooooo`0nool2002[ool003;oo`80043oo`800:[oo`00<ooo
00<00?ooool0@?oo00<00?ooool0Yooo000dool00`00ooooo`10ool2002Wool003Goo`03003ooooo
047oo`800:Goo`00=_oo00<00?ooool0@_oo00<00?ooool0X_oo000fool20014ool2002Rool003Oo
o`03003ooooo04Coo`800:3oo`00>?oo00<00?ooool0AOoo0P00W_oo000iool00`00ooooo`16ool2
002Lool003[oo`03003ooooo04Ooo`8009[oo`00>ooo00<00?ooool0B?oo0P00V?oo000kool2001;
ool2002Fool003coo`03003ooooo04_oo`8009Coo`00?Ooo00<00?ooool0C?oo0`00TOoo000nool0
0`00ooooo`1>ool3002>ool003ooo`03003ooooo053oo`8008coo`00@?oo00<00?ooool0DOoo1@00
Qooo0011ool00`00ooooo`1Dool50023ool004;oo`03003ooooo05Soo`<0083oo`00@ooo00<00?oo
ool0F_oo1@00Nooo0014ool00`00ooooo`1Mool6001fool004Goo`03003ooooo06;ooa<006?oo`00
A_oo00<00?ooool0Looo1P00G_oo0017ool00`00ooooo`1gool3001Lool004Soo`03003ooooo07So
o`<005[oo`00BOoo00<00?ooool0NOoo0P00FOoo001:ool00`00ooooo`1jool00`00ooooo`1Fool0
04_oo`03003ooooo07[oo`03003ooooo05Goo`00C?oo00<00?ooool0N_oo00<00?ooool0E?oo001=
ool00`00ooooo`1jool00`00ooooo`1Cool004koo`03003ooooo07Woo`8005Coo`00Cooo00<00?oo
ool0NOoo00<00?ooool0D_oo001@ool2001jool00`00ooooo`1Aool0057oo`8007Woo`8005;oo`00
Dooo0P00N?oo00<00?ooool0D?oo001Dool2001gool2001Aool005Koo`03003ooooo07Goo`03003o
oooo04ooo`00Eooo0P00MOoo0P00D?oo001Iool00`00ooooo`1cool00`00ooooo`1>ool005[oo`80
07?oo`8004ooo`00G?oo00<00?ooool0LOoo00<00?ooool0COoo001Mool2001aool00`00ooooo`1=
ool005koo`80073oo`03003ooooo04goo`00H?oo0P00K_oo00<00?ooool0COoo001Qool2001]ool0
0`00ooooo`1=ool006?oo`8006_oo`03003ooooo04goo`00I?oo0P00J_oo00<00?ooool0COoo001V
ool2001Xool00`00ooooo`1=ool006Soo`8006Koo`03003ooooo04goo`00JOoo0`00I?oo00<00?oo
ool0COoo001/ool2001Rool00`00ooooo`1=ool006koo`8005ooo`8004ooo`00L?oo0`00G?oo00<0
0?ooool0C_oo001bool2001Jool2001@ool007Coo`8005Soo`03003ooooo04ooo`00M_oo0P00EOoo
0P00DOoo001gool3001Cool00`00ooooo`1@ool007[oo`<004ooo`8005;oo`00O?oo0`00COoo00<0
0?ooool0DOoo001oool30019ool00`00ooooo`1Bool008;oo`@004Coo`8005Coo`00Q_oo1000@?oo
00<00?ooool0Dooo0029ool5000kool00`00ooooo`1Dool008goo`D003Koo`03003ooooo05Goo`00
TOoo1@00<Ooo00<00?ooool0E_oo002Eool5000[ool2001Iool009Woo`D002Goo`<005[oo`00WOoo
1`007Ooo0`00G?oo002ToolA0007ool6001Nool00;Goo`P006?oo`00oooo8Ooo003ooolQool00?oo
ob7oo`00oooo8Ooo003ooolQool00?ooob7oo`00\
\>"],
  ImageRangeCache->{{{93.5625, 452.312}, {428.562, 69.8125}} -> {-97.4485, \
58.5229, 1.19262, 1.19336}}],

Cell["\<\
Many numerical methods for ordinary differential equations involve \
computations of the form:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y\_\(n + 1\) = \ y\_n\  + \ \[Delta]\_n\)]]], "Text"],

Cell[TextData[{
  "where the increments ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Delta]\_n\)\)\)]],
  " are usually smaller in magnitude than the approximations ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(y\_n\)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`e(x)\)]],
  " denote the exponent and ",
  Cell[BoxData[
      \(TraditionalForm\`m(x)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1\  > \ m(x)\  \[GreaterEqual] \ 1/\[Beta]\)]],
  ", the mantissa of a number ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " in precision ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " radix ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\)]],
  " arithmetic: ",
  Cell[BoxData[
      \(TraditionalForm\`x\  = \ \(m(x)\)\[Cross]\[Beta]\^\(e(x)\)\)]],
  "."
}], "Text"],

Cell["Then we can write:", "Text"],

Cell[BoxData[
    \(TraditionalForm\`y\_n = \(\(m(y\_n)\)\ \[Cross]\ \[Beta]\^\(e(y\_n)\) = 
        y\_n\%h + 
          y\_n\%l\[Cross]\[Beta]\^\(e(\[Delta]\_n)\)\)\)], "DisplayFormula"],

Cell["and", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[\(\[Delta]\_n\),
          "TraditionalForm"], "=", 
        RowBox[{\(\(m(\[Delta]\_n)\)\ \[Cross]\[Beta]\^\(e(\[Delta]\_n)\)\), 
          "=", " ", 
          RowBox[{
            FormBox[\(\[Delta]\_n\%h\),
              "TraditionalForm"], "+", "  ", 
            RowBox[{
              FormBox[\(\[Delta]\_n\%l\),
                "TraditionalForm"], 
              "\[Cross]", \(\[Beta]\^\(e(y\_n) - p\)\)}]}]}]}], 
      TraditionalForm]], "DisplayFormula"],

Cell["\<\
Aligning according to exponents these quantities can be represented \
pictorially as:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[GridBox[{
            {
              "           ", \(\(\ \ \ \ \ \ \)\(y\_n\%l\)\(\ \ \ \ \ \)\), \
\(\(y\_n\%h\)\(\ \)\)},
            {\(\(\[Delta]\_n\%l\)\(\ \)\), \(\(\ \ \ \ \ \)\(\[Delta]\_n\%h\)\
\(\ \ \ \)\), "           "}
            },
          RowLines->True,
          ColumnLines->True]], TraditionalForm]], "DisplayFormula"],

Cell["\<\
where numbers on the left have a smaller scale than numbers on the \
right.\
\>", "Text"],

Cell[TextData[{
  "We are interested in an efficient way of computing the quantities ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta]\_n\%l\)]],
  " that effectively represent the radix ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\)]],
  " digits discarded due to the difference in the exponents of ",
  Cell[BoxData[
      \(TraditionalForm\`y\_n\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Delta]\_n\)\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Compensated summation", "Subsection"],

Cell[TextData[{
  "The basic motivation for compensated summation is to simulate ",
  Cell[BoxData[
      \(TraditionalForm\`2  n\)]],
  " bit addition using only ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " bit arithmetic."
}], "Text"],

Cell[CellGroupData[{

Cell["Example", "Subsubsection"],

Cell["\<\
This repeatedly adds a fixed amount to a starting value. Cumulative \
roundoff error has a significant influence on the result.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(reps\  = \ 10\^6;\)\), "\[IndentingNewLine]", 
    \(\(base\  = \ 0. ;\)\), "\[IndentingNewLine]", 
    \(\(inc\  = \ 0.1;\)\), "\[IndentingNewLine]", 
    \(\(Do[base\  = \ base\  + \ inc, {reps}];\)\), "\[IndentingNewLine]", 
    \(InputForm[base]\)}], "Input",
  CellLabel->"In[19]:="],

Cell["100000.00000133288", "Output",
  CellLabel->"Out[23]//InputForm="]
}, Open  ]],

Cell["\<\
In many applications the increment may vary and the number of \
operations is not known in advance.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithm", "Subsubsection"],

Cell[TextData[{
  "Compensated summation (see for example [",
  ButtonBox["B87",
    ButtonData:>{"References.nb", "B87"},
    ButtonStyle->"Hyperlink"],
  "] and ",
  "[",
  ButtonBox["H96",
    ButtonData:>{"References.nb", "H96"},
    ButtonStyle->"Hyperlink"],
  "]",
  ") computes the rounding error along with the sum so that:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y\_\(n + 1\) = 
      y\_n + h\ \(f(y\_n)\)\)], "DisplayFormula"],

Cell["is replaced by:", "Text"],

Cell[TextData[{
  StyleBox["Algorithm 2",
    FontWeight->"Bold"],
  " (Compensated Summation)"
}], "Text"],

Cell[BoxData[{
    \(TraditionalForm\`yerr = 0\), "\n", 
    \(TraditionalForm\`for\ i\  = \ 1, \[Ellipsis], 
    N\), "\[IndentingNewLine]", 
    \(TraditionalForm\`\t\[CapitalDelta]y\_n = 
      h\ \(f(y\_n)\) + yerr\), "\n", 
    \(TraditionalForm\`\ty\_\(n + 1\) = y\_n + \[CapitalDelta]y\_n\), "\n", 
    \(TraditionalForm\`\t
    yerr = \((y\_n - 
            y\_\(n + 1\))\)\  + \ \[CapitalDelta]y\_n\)}], "DisplayFormula"],

Cell["The algorithm is carried out componentwise for vectors.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsubsection"],

Cell[TextData[{
  "The function ",
  StyleBox["CompensatedAdd", "MR"],
  " (in the ",
  StyleBox["Developer`", "MR"],
  " context) implements the algorithm for compensated summation."
}], "Text"],

Cell["\<\
By repeatedly feeding back the rounding error from one sum into the \
next, the effect of rounding errors is significantly reduced.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(err\  = \ 0. ;\)\), "\[IndentingNewLine]", 
    \(\(base\  = \ 0. ;\)\), "\[IndentingNewLine]", 
    \(\(inc\  = \ 0.1;\)\), "\[IndentingNewLine]", 
    \(\(Do[\[IndentingNewLine]{base, 
            err}\  = \ \[IndentingNewLine]Developer`CompensatedAdd[base\ , 
            inc, err], \[IndentingNewLine]{reps}];\)\), \
"\[IndentingNewLine]", 
    \(InputForm[base]\)}], "Input",
  CellLabel->"In[24]:="],

Cell["100000.", "Output",
  CellLabel->"Out[28]//InputForm="]
}, Open  ]],

Cell[TextData[{
  "An undocumented option ",
  StyleBox["CompensatedSummation", "MR"],
  " controls whether built-in integration methods in ",
  StyleBox["NDSolve", "MR"],
  " use compensated summation."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["An alternative algorithm", "Subsection"],

Cell["\<\
There are various ways that compensated summation can be \
used.\
\>", "Text"],

Cell["\<\
One way is to compute the error in every addition update in the \
main loop in Algorithm 1.\
\>", "Text"],

Cell[TextData[{
  "An alternative algorithm, which we propose because of its more general \
applicability, together with reduced arithmetic cost, is given below. The \
essential ingredients are the increments ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]P\_i = P\_i - p\_n\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]Q\_i = Q\_i - q\_n\)]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Algorithm 3",
    FontWeight->"Bold"],
  " (Increment SPRK)"
}], "Text"],

Cell[BoxData[{
    FormBox[\(\[CapitalDelta]P\_0 = \ 0\), TraditionalForm], "\n", 
    FormBox[
      RowBox[{
        FormBox[\(\[CapitalDelta]Q\_1 = \ 0\),
          "TraditionalForm"], "\[IndentingNewLine]"}], 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[\(for\ i\  = \ 1, \[Ellipsis], s\), 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[
      RowBox[{
        "\t", \(\[CapitalDelta]P\_i = \[CapitalDelta]P\_\(i - 1\) + \ \
\(h\_\(n + 1\)\) \(b\_i\) \(f \((q\_n + \[CapitalDelta]Q\_i, 
                  t\_n + \ \(C\_i\) h\_\(n + 1\))\)\)\)}], 
      TraditionalForm], "\n", 
    FormBox[
      RowBox[{
        FormBox[\(\(\t\)\(\[CapitalDelta]Q\_\(i + 1\) = \[CapitalDelta]Q\_i + \
\ \(h\_\(n + 1\)\) \(B\_i\) \(g(p\_n + \[CapitalDelta]P\_i)\)\)\),
          "TraditionalForm"], "\n"}], TraditionalForm], "\[IndentingNewLine]",
   
    FormBox[\(Return\ \[CapitalDelta]p\_\(n + 1\) = \(\(\[CapitalDelta]P\_s\) 
            and\ \[CapitalDelta]q\_\(n + 1\) = \(\(\[CapitalDelta]Q\_\(s + 
                  1\)\)\(.\)\)\)\), TraditionalForm]}], "DisplayFormula"],

Cell[TextData[{
  "The desired values ",
  Cell[BoxData[
      \(TraditionalForm\`p\_\(n + 1\) = 
        p\_n + \[CapitalDelta]p\_\(n + 1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\_\(n + 1\) = 
        q\_n + \[CapitalDelta]q\_\(n + 1\)\)]],
  " are obtained using compensated summation."
}], "Text"],

Cell["\<\
Compensated summation could also be used in every addition update \
in the main loop of Algorithm 3, but our experiments have shown that this \
adds a non-negligible overhead for a relatively small gain in accuracy.\
\>", \
"Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical examples", "Subsection"],

Cell[CellGroupData[{

Cell["Rounding error model", "Subsubsection"],

Cell[TextData[{
  "The amount of expected roundoff error in the relative error of the \
Hamiltonian for the harmonic oscillator (",
  
  CounterBox["NumberedEquation", "HarmonicOscillator"],
  ") will now be quantified. A probabilistic average case analysis is \
considered in preference to a worst case upper bound."
}], "Text"],

Cell[TextData[{
  "For a one-dimensional random walk with equal probability of a deviation, \
the expected absolute distance after N steps is O(",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\@\(\(\ \)\(n\)\)\)\()\)\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "The relative error for a floating point operation +, -, *, /",
  " ",
  "using IEEE round to nearest mode satisfies the following bound [",
  ButtonBox["K93",
    ButtonData:>{"References.nb", "K93"},
    ButtonStyle->"Hyperlink"],
  "]:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Epsilon]\_round\), " ", "\[LessEqual]", 
        " ", \(1/2\ \[Beta]\^\(\(-p\) + 1\)\), " ", "\[TildeTilde]", " ", 
        FormBox[\(1.11022\[Cross]10\^\(-16\)\),
          "TraditionalForm"]}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "where the base ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta] = 2\)]],
  " is used for representing floating point numbers on our machine and p=53 \
for IEEE double precision."
}], "Text"],

Cell[TextData[{
  "Therefore the roundoff error after ",
  StyleBox["n",
    FontSlant->"Italic"],
  " steps is expected to be approximately:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`k\ \[Epsilon]\ \@n\)], "DisplayFormula"],

Cell[TextData[{
  "for some constant ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  "."
}], "Text"],

Cell[TextData[{
  "In the examples that follow a constant step size of 1/25 is used and the \
integration is performed over the interval [0, 80000] for a total of ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]10\^6\)]],
  " integration steps. The error in the Hamiltonian is sampled every 200 \
integration steps."
}], "Text"],

Cell["\<\
The 8th order 15 stage (FSAL) method D of Yoshida is used. Similar \
results have been obtained for the 6th order 7 stage (FSAL) method A of \
Yoshida with the same number of integration steps and a step size of 1/160.\
\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Without compensated summation", "Subsubsection"],

Cell[TextData[{
  "The relative error in the Hamiltonian is displayed below for the standard \
formulation in Algorithm 1 (green) and for the increment formulation in \
Algorithm 3 (red) for the Harmonic oscillator (",
  
  CounterBox["NumberedEquation", "HarmonicOscillator"],
  ")."
}], "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.373189 0.00433577 0.0147151 0.00434192 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.25 Mabswid
[ ] 0 Mabsdash
.21472 .12055 m
.21472 .12543 L
s
[(0)] .20009 .08582 -1 -1 Mshowa
.40044 .12055 m
.40044 .12543 L
s
[(20000)] .33378 .08582 -1 -1 Mshowa
.58617 .12055 m
.58617 .12543 L
s
[(40000)] .51951 .08582 -1 -1 Mshowa
.7719 .12055 m
.7719 .12543 L
s
[(60000)] .70524 .08582 -1 -1 Mshowa
.95762 .12055 m
.95762 .12543 L
s
[(80000)] .89096 .08582 -1 -1 Mshowa
.125 Mabswid
.26115 .12055 m
.26115 .12348 L
s
.30759 .12055 m
.30759 .12348 L
s
.35402 .12055 m
.35402 .12348 L
s
.44688 .12055 m
.44688 .12348 L
s
.49331 .12055 m
.49331 .12348 L
s
.53974 .12055 m
.53974 .12348 L
s
.6326 .12055 m
.6326 .12348 L
s
.67903 .12055 m
.67903 .12348 L
s
.72546 .12055 m
.72546 .12348 L
s
.81833 .12055 m
.81833 .12348 L
s
.86476 .12055 m
.86476 .12348 L
s
.91119 .12055 m
.91119 .12348 L
s
.25 Mabswid
.19615 .12055 m
.97619 .12055 L
s
.19615 .13205 m
.20103 .13205 L
s
[(0)] .16364 .11984 -1 -1 Mshowa
.19615 .23782 m
.20103 .23782 L
s
[(1)] .02381 .21937 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .21937 -1 -1 Mshowa
P
[(10)] .07584 .21937 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .24216 -1 -1 Mshowa
P
.19615 .3436 m
.20103 .3436 L
s
[(2)] .02381 .32515 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .32515 -1 -1 Mshowa
P
[(10)] .07584 .32515 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .34794 -1 -1 Mshowa
P
.19615 .44938 m
.20103 .44938 L
s
[(3)] .02381 .43093 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .43093 -1 -1 Mshowa
P
[(10)] .07584 .43093 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .45373 -1 -1 Mshowa
P
.19615 .55517 m
.20103 .55517 L
s
[(4)] .02381 .53671 -1 -1 Mshowa
p
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10 scalefont setfont
[(\\264)] .04982 .53671 -1 -1 Mshowa
P
[(10)] .07584 .53671 -1 -1 Mshowa
p
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.5 scalefont setfont
[(-13)] .12787 .55951 -1 -1 Mshowa
P
.125 Mabswid
.19615 .1532 m
.19908 .1532 L
s
.19615 .17435 m
.19908 .17435 L
s
.19615 .19551 m
.19908 .19551 L
s
.19615 .21667 m
.19908 .21667 L
s
.19615 .25898 m
.19908 .25898 L
s
.19615 .28013 m
.19908 .28013 L
s
.19615 .3013 m
.19908 .3013 L
s
.19615 .32245 m
.19908 .32245 L
s
.19615 .36476 m
.19908 .36476 L
s
.19615 .38592 m
.19908 .38592 L
s
.19615 .40708 m
.19908 .40708 L
s
.19615 .42823 m
.19908 .42823 L
s
.19615 .47055 m
.19908 .47055 L
s
.19615 .4917 m
.19908 .4917 L
s
.19615 .51286 m
.19908 .51286 L
s
.19615 .53401 m
.19908 .53401 L
s
.19615 .57633 m
.19908 .57633 L
s
.19615 .59748 m
.19908 .59748 L
s
.25 Mabswid
.19615 .12055 m
.19615 .60332 L
s
.21472 .59843 m
.21472 .60332 L
s
.40044 .59843 m
.40044 .60332 L
s
.58617 .59843 m
.58617 .60332 L
s
.7719 .59843 m
.7719 .60332 L
s
.95762 .59843 m
.95762 .60332 L
s
.125 Mabswid
.26115 .60039 m
.26115 .60332 L
s
.30759 .60039 m
.30759 .60332 L
s
.35402 .60039 m
.35402 .60332 L
s
.44688 .60039 m
.44688 .60332 L
s
.49331 .60039 m
.49331 .60332 L
s
.53974 .60039 m
.53974 .60332 L
s
.6326 .60039 m
.6326 .60332 L
s
.67903 .60039 m
.67903 .60332 L
s
.72546 .60039 m
.72546 .60332 L
s
.81833 .60039 m
.81833 .60332 L
s
.86476 .60039 m
.86476 .60332 L
s
.91119 .60039 m
.91119 .60332 L
s
.25 Mabswid
.19615 .60332 m
.97619 .60332 L
s
.97132 .13205 m
.97619 .13205 L
s
.97132 .23782 m
.97619 .23782 L
s
.97132 .3436 m
.97619 .3436 L
s
.97132 .44938 m
.97619 .44938 L
s
.97132 .55517 m
.97619 .55517 L
s
.125 Mabswid
.97327 .1532 m
.97619 .1532 L
s
.97327 .17435 m
.97619 .17435 L
s
.97327 .19551 m
.97619 .19551 L
s
.97327 .21667 m
.97619 .21667 L
s
.97327 .25898 m
.97619 .25898 L
s
.97327 .28013 m
.97619 .28013 L
s
.97327 .3013 m
.97619 .3013 L
s
.97327 .32245 m
.97619 .32245 L
s
.97327 .36476 m
.97619 .36476 L
s
.97327 .38592 m
.97619 .38592 L
s
.97327 .40708 m
.97619 .40708 L
s
.97327 .42823 m
.97619 .42823 L
s
.97327 .47055 m
.97619 .47055 L
s
.97327 .4917 m
.97619 .4917 L
s
.97327 .51286 m
.97619 .51286 L
s
.97327 .53401 m
.97619 .53401 L
s
.97327 .57633 m
.97619 .57633 L
s
.97327 .59748 m
.97619 .59748 L
s
.25 Mabswid
.97619 .12055 m
.97619 .60332 L
s
1 0 1 0 k
1.43926 Mabswid
.21472 .13205 m
.21472 .13205 L
s
.21479 .13415 m
.21479 .13415 L
s
.21487 .13275 m
.21487 .13275 L
s
.21495 .13509 m
.21495 .13509 L
s
.21502 .13979 m
.21502 .13979 L
s
.2151 .14214 m
.2151 .14214 L
s
.21517 .13956 m
.21517 .13956 L
s
.21525 .13861 m
.21525 .13861 L
s
.21532 .14355 m
.21532 .14355 L
s
.2154 .14731 m
.2154 .14731 L
s
.21547 .14614 m
.21547 .14614 L
s
.21554 .14355 m
.21554 .14355 L
s
.21561 .14167 m
.21561 .14167 L
s
.21569 .1405 m
.21569 .1405 L
s
.21576 .14238 m
.21576 .14238 L
s
.21584 .14402 m
.21584 .14402 L
s
.21591 .13415 m
.21591 .13415 L
s
.21599 .13651 m
.21599 .13651 L
s
.21606 .14073 m
.21606 .14073 L
s
.21613 .14848 m
.21613 .14848 L
s
.21621 .14531 m
.21621 .14531 L
s
.21629 .1432 m
.21629 .1432 L
s
.21636 .15013 m
.21636 .15013 L
s
.21643 .14848 m
.21643 .14848 L
s
.21651 .14519 m
.21651 .14519 L
s
.21658 .14132 m
.21658 .14132 L
s
.21666 .13861 m
.21666 .13861 L
s
.21673 .14097 m
.21673 .14097 L
s
.21681 .14684 m
.21681 .14684 L
s
.21688 .14672 m
.21688 .14672 L
s
.21695 .14943 m
.21695 .14943 L
s
.21703 .15095 m
.21703 .15095 L
s
.21711 .15447 m
.21711 .15447 L
s
.21717 .15753 m
.21717 .15753 L
s
.21725 .1681 m
.21725 .1681 L
s
.21732 .16903 m
.21732 .16903 L
s
.2174 .16657 m
.2174 .16657 L
s
.21747 .17127 m
.21747 .17127 L
s
.21755 .17138 m
.21755 .17138 L
s
.21762 .16951 m
.21762 .16951 L
s
.21769 .17068 m
.21769 .17068 L
s
.21776 .17291 m
.21776 .17291 L
s
.21784 .16986 m
.21784 .16986 L
s
.21792 .17045 m
.21792 .17045 L
s
.21799 .16927 m
.21799 .16927 L
s
.21807 .1728 m
.21807 .1728 L
s
.21814 .17373 m
.21814 .17373 L
s
.21822 .1762 m
.21822 .1762 L
s
.21829 .18113 m
.21829 .18113 L
s
.21837 .18301 m
.21837 .18301 L
s
.21844 .18419 m
.21844 .18419 L
s
.21851 .18583 m
.21851 .18583 L
s
.21858 .1789 m
.21858 .1789 L
s
.21866 .17009 m
.21866 .17009 L
s
.21874 .17608 m
.21874 .17608 L
s
.21881 .17138 m
.21881 .17138 L
s
.21888 .16798 m
.21888 .16798 L
s
.21896 .1661 m
.21896 .1661 L
s
.21903 .16786 m
.21903 .16786 L
s
.21911 .16692 m
.21911 .16692 L
s
.21918 .17127 m
.21918 .17127 L
s
.21926 .16986 m
.21926 .16986 L
s
.21933 .1587 m
.21933 .1587 L
s
.2194 .16528 m
.2194 .16528 L
s
.21947 .16586 m
.21947 .16586 L
s
.21955 .16716 m
.21955 .16716 L
s
.21963 .16599 m
.21963 .16599 L
s
.2197 .16704 m
.2197 .16704 L
s
.21978 .16046 m
.21978 .16046 L
s
.21985 .16187 m
.21985 .16187 L
s
.21993 .16539 m
.21993 .16539 L
s
.22 .16445 m
.22 .16445 L
s
.22008 .16939 m
.22008 .16939 L
s
.22014 .16974 m
.22014 .16974 L
s
.22022 .17549 m
.22022 .17549 L
s
.22029 .17632 m
.22029 .17632 L
s
.22037 .17644 m
.22037 .17644 L
s
.22044 .17502 m
.22044 .17502 L
s
.22052 .17726 m
.22052 .17726 L
s
.22059 .17244 m
.22059 .17244 L
s
.22067 .16798 m
.22067 .16798 L
s
.22074 .16939 m
.22074 .16939 L
s
.22082 .16986 m
.22082 .16986 L
s
.22089 .16763 m
.22089 .16763 L
s
.22096 .1688 m
.22096 .1688 L
s
.22103 .16998 m
.22103 .16998 L
s
.22111 .16634 m
.22111 .16634 L
s
.22119 .16469 m
.22119 .16469 L
s
.22126 .16317 m
.22126 .16317 L
s
.22134 .16504 m
.22134 .16504 L
s
.22141 .15811 m
.22141 .15811 L
s
.22149 .16422 m
.22149 .16422 L
s
.22156 .1661 m
.22156 .1661 L
s
.22164 .16328 m
.22164 .16328 L
s
.22171 .16058 m
.22171 .16058 L
s
.22178 .15624 m
.22178 .15624 L
s
.22185 .15365 m
.22185 .15365 L
s
.22193 .15177 m
.22193 .15177 L
s
.222 .16387 m
.222 .16387 L
s
.22208 .16281 m
.22208 .16281 L
s
.22215 .1681 m
.22215 .1681 L
s
.22223 .16481 m
.22223 .16481 L
s
.2223 .16258 m
.2223 .16258 L
s
.22238 .16704 m
.22238 .16704 L
s
.22245 .16399 m
.22245 .16399 L
s
.22252 .16328 m
.22252 .16328 L
s
.22259 .15976 m
.22259 .15976 L
s
.22267 .16563 m
.22267 .16563 L
s
.22275 .16669 m
.22275 .16669 L
s
.22282 .16751 m
.22282 .16751 L
s
.2229 .15976 m
.2229 .15976 L
s
.22297 .16375 m
.22297 .16375 L
s
.22305 .16681 m
.22305 .16681 L
s
.22312 .16739 m
.22312 .16739 L
s
.2232 .16998 m
.2232 .16998 L
s
.22327 .17385 m
.22327 .17385 L
s
.22334 .18043 m
.22334 .18043 L
s
.22341 .17726 m
.22341 .17726 L
s
.22349 .1728 m
.22349 .1728 L
s
.22356 .17127 m
.22356 .17127 L
s
.22364 .17256 m
.22364 .17256 L
s
.22371 .17115 m
.22371 .17115 L
s
.22379 .16634 m
.22379 .16634 L
s
.22386 .15929 m
.22386 .15929 L
s
.22394 .15342 m
.22394 .15342 L
s
.22401 .15612 m
.22401 .15612 L
s
.22409 .15318 m
.22409 .15318 L
s
.22416 .15189 m
.22416 .15189 L
s
.22423 .14919 m
.22423 .14919 L
s
.22431 .15001 m
.22431 .15001 L
s
.22438 .15271 m
.22438 .15271 L
s
.22446 .152 m
.22446 .152 L
s
.22453 .15118 m
.22453 .15118 L
s
.22461 .15694 m
.22461 .15694 L
s
.22468 .15154 m
.22468 .15154 L
s
.22475 .1526 m
.22475 .1526 L
s
.22483 .14731 m
.22483 .14731 L
s
.22491 .14919 m
.22491 .14919 L
s
.22497 .15271 m
.22497 .15271 L
s
.22505 .15154 m
.22505 .15154 L
s
.22512 .1533 m
.22512 .1533 L
s
.2252 .15236 m
.2252 .15236 L
s
.22527 .1486 m
.22527 .1486 L
s
.22535 .14661 m
.22535 .14661 L
s
.22542 .14519 m
.22542 .14519 L
s
.22549 .14661 m
.22549 .14661 L
s
.22557 .15036 m
.22557 .15036 L
s
.22565 .1513 m
.22565 .1513 L
s
.22572 .14778 m
.22572 .14778 L
s
.22579 .15048 m
.22579 .15048 L
s
.22587 .14978 m
.22587 .14978 L
s
.22594 .14943 m
.22594 .14943 L
s
.22602 .14402 m
.22602 .14402 L
s
.22609 .14496 m
.22609 .14496 L
s
.22617 .14108 m
.22617 .14108 L
s
.22624 .14238 m
.22624 .14238 L
s
.22631 .14602 m
.22631 .14602 L
s
.22638 .14661 m
.22638 .14661 L
s
.22646 .15494 m
.22646 .15494 L
s
.22654 .14919 m
.22654 .14919 L
s
.22661 .14848 m
.22661 .14848 L
s
.22668 .14754 m
.22668 .14754 L
s
.22676 .1486 m
.22676 .1486 L
s
.22683 .15048 m
.22683 .15048 L
s
.22691 .15342 m
.22691 .15342 L
s
.22698 .14907 m
.22698 .14907 L
s
.22706 .15741 m
.22706 .15741 L
s
.22713 .15365 m
.22713 .15365 L
s
.2272 .15365 m
.2272 .15365 L
s
.22728 .15295 m
.22728 .15295 L
s
.22735 .14907 m
.22735 .14907 L
s
.22743 .15189 m
.22743 .15189 L
s
.2275 .15541 m
.2275 .15541 L
s
.22758 .15823 m
.22758 .15823 L
s
.22765 .15682 m
.22765 .15682 L
s
.22773 .16082 m
.22773 .16082 L
s
.2278 .15953 m
.2278 .15953 L
s
.22788 .15764 m
.22788 .15764 L
s
.22794 .15365 m
.22794 .15365 L
s
.22802 .15882 m
.22802 .15882 L
s
.22809 .15624 m
.22809 .15624 L
s
.22817 .15624 m
.22817 .15624 L
s
.22824 .16093 m
.22824 .16093 L
s
.22832 .15811 m
.22832 .15811 L
s
.22839 .1607 m
.22839 .1607 L
s
.22847 .15647 m
.22847 .15647 L
s
.22854 .15717 m
.22854 .15717 L
s
.22862 .158 m
.22862 .158 L
s
.22869 .16716 m
.22869 .16716 L
s
.22876 .16352 m
.22876 .16352 L
s
.22883 .16516 m
.22883 .16516 L
s
.22891 .16551 m
.22891 .16551 L
s
.22899 .16868 m
.22899 .16868 L
s
.22906 .17456 m
.22906 .17456 L
s
.22914 .17479 m
.22914 .17479 L
s
.22921 .16963 m
.22921 .16963 L
s
.22929 .16622 m
.22929 .16622 L
s
.22936 .15882 m
.22936 .15882 L
s
.22944 .16187 m
.22944 .16187 L
s
.22951 .15988 m
.22951 .15988 L
s
.22958 .16128 m
.22958 .16128 L
s
.22965 .16563 m
.22965 .16563 L
s
.22973 .16939 m
.22973 .16939 L
s
.2298 .17209 m
.2298 .17209 L
s
.22988 .17232 m
.22988 .17232 L
s
.22995 .16821 m
.22995 .16821 L
s
.23003 .17232 m
.23003 .17232 L
s
.2301 .16774 m
.2301 .16774 L
s
.23018 .16927 m
.23018 .16927 L
s
.23025 .17385 m
.23025 .17385 L
s
.23032 .17479 m
.23032 .17479 L
s
.23039 .17009 m
.23039 .17009 L
s
.23047 .16986 m
.23047 .16986 L
s
.23055 .16798 m
.23055 .16798 L
s
.23062 .17232 m
.23062 .17232 L
s
.2307 .17045 m
.2307 .17045 L
s
.23077 .17385 m
.23077 .17385 L
s
.23085 .17526 m
.23085 .17526 L
s
.23092 .17432 m
.23092 .17432 L
s
.231 .17327 m
.231 .17327 L
s
.23107 .17174 m
.23107 .17174 L
s
.23114 .17644 m
.23114 .17644 L
s
.23121 .17784 m
.23121 .17784 L
s
.23129 .17667 m
.23129 .17667 L
s
.23136 .1735 m
.23136 .1735 L
s
.23144 .17432 m
.23144 .17432 L
s
.23151 .17655 m
.23151 .17655 L
s
.23159 .17608 m
.23159 .17608 L
s
.23166 .18113 m
.23166 .18113 L
s
.23174 .17714 m
.23174 .17714 L
s
.23181 .17831 m
.23181 .17831 L
s
.23189 .17913 m
.23189 .17913 L
s
.23196 .17973 m
.23196 .17973 L
s
.23203 .17632 m
.23203 .17632 L
s
.23211 .17362 m
.23211 .17362 L
s
.23218 .17327 m
.23218 .17327 L
s
.23226 .18066 m
.23226 .18066 L
s
.23233 .1809 m
.23233 .1809 L
s
.23241 .17961 m
.23241 .17961 L
s
.23248 .17561 m
.23248 .17561 L
s
.23256 .17397 m
.23256 .17397 L
s
.23263 .17385 m
.23263 .17385 L
s
.23271 .17714 m
.23271 .17714 L
s
.23277 .17596 m
.23277 .17596 L
s
.23285 .17479 m
.23285 .17479 L
s
.23292 .17549 m
.23292 .17549 L
s
.233 .17913 m
.233 .17913 L
s
.23307 .18137 m
.23307 .18137 L
s
.23315 .18148 m
.23315 .18148 L
s
.23322 .18043 m
.23322 .18043 L
s
.23329 .18818 m
.23329 .18818 L
s
.23337 .18372 m
.23337 .18372 L
s
.23345 .17855 m
.23345 .17855 L
s
.23352 .17937 m
.23352 .17937 L
s
.23359 .18419 m
.23359 .18419 L
s
.23367 .189 m
.23367 .189 L
s
.23374 .18912 m
.23374 .18912 L
s
.23382 .18348 m
.23382 .18348 L
s
.23389 .18148 m
.23389 .18148 L
s
.23397 .17702 m
.23397 .17702 L
s
.23404 .1782 m
.23404 .1782 L
s
.23411 .18325 m
.23411 .18325 L
s
.23419 .18701 m
.23419 .18701 L
s
.23427 .1863 m
.23427 .1863 L
s
.23434 .18512 m
.23434 .18512 L
s
.23441 .17996 m
.23441 .17996 L
s
.23448 .17549 m
.23448 .17549 L
s
.23456 .17796 m
.23456 .17796 L
s
.23463 .17679 m
.23463 .17679 L
s
.23471 .17456 m
.23471 .17456 L
s
.23478 .17573 m
.23478 .17573 L
s
.23486 .17843 m
.23486 .17843 L
s
.23493 .17878 m
.23493 .17878 L
s
.235 .17761 m
.235 .17761 L
s
.23508 .18372 m
.23508 .18372 L
s
.23515 .18489 m
.23515 .18489 L
s
.23523 .1903 m
.23523 .1903 L
s
.2353 .19382 m
.2353 .19382 L
s
.23538 .19006 m
.23538 .19006 L
s
.23545 .18748 m
.23545 .18748 L
s
.23553 .18876 m
.23553 .18876 L
s
.2356 .19182 m
.2356 .19182 L
s
.23568 .18677 m
.23568 .18677 L
s
.23574 .18759 m
.23574 .18759 L
s
.23582 .18865 m
.23582 .18865 L
s
.2359 .19287 m
.2359 .19287 L
s
.23597 .19452 m
.23597 .19452 L
s
.23604 .19711 m
.23604 .19711 L
s
.23612 .20204 m
.23612 .20204 L
s
.23619 .19546 m
.23619 .19546 L
s
.23627 .1937 m
.23627 .1937 L
s
.23634 .1944 m
.23634 .1944 L
s
.23642 .18935 m
.23642 .18935 L
s
.23649 .18348 m
.23649 .18348 L
s
.23656 .17878 m
.23656 .17878 L
s
.23663 .18384 m
.23663 .18384 L
s
.23671 .18125 m
.23671 .18125 L
s
.23679 .18078 m
.23679 .18078 L
s
.23686 .18372 m
.23686 .18372 L
s
.23694 .18125 m
.23694 .18125 L
s
.23701 .18031 m
.23701 .18031 L
s
.23709 .18372 m
.23709 .18372 L
s
.23716 .17843 m
.23716 .17843 L
s
.23724 .18008 m
.23724 .18008 L
s
.23731 .17925 m
.23731 .17925 L
s
.23738 .18043 m
.23738 .18043 L
s
.23745 .17878 m
.23745 .17878 L
s
.23753 .1762 m
.23753 .1762 L
s
.2376 .17479 m
.2376 .17479 L
s
.23768 .17502 m
.23768 .17502 L
s
.23775 .17538 m
.23775 .17538 L
s
.23783 .17315 m
.23783 .17315 L
s
.2379 .1708 m
.2379 .1708 L
s
.23798 .17009 m
.23798 .17009 L
s
.23805 .1708 m
.23805 .1708 L
s
.23813 .17291 m
.23813 .17291 L
s
.23819 .16986 m
.23819 .16986 L
s
.23827 .1722 m
.23827 .1722 L
s
.23835 .1728 m
.23835 .1728 L
s
.23842 .17855 m
.23842 .17855 L
s
.2385 .17948 m
.2385 .17948 L
s
.23857 .18348 m
.23857 .18348 L
s
.23865 .17784 m
.23865 .17784 L
s
.23872 .17197 m
.23872 .17197 L
s
.2388 .16317 m
.2388 .16317 L
s
.23887 .16175 m
.23887 .16175 L
s
.23894 .15694 m
.23894 .15694 L
s
.23901 .1621 m
.23901 .1621 L
s
.23909 .15976 m
.23909 .15976 L
s
.23916 .15694 m
.23916 .15694 L
s
.23924 .15905 m
.23924 .15905 L
s
.23931 .15953 m
.23931 .15953 L
s
.23939 .16164 m
.23939 .16164 L
s
.23946 .15612 m
.23946 .15612 L
s
.23954 .15682 m
.23954 .15682 L
s
.23961 .16305 m
.23961 .16305 L
s
.23969 .15717 m
.23969 .15717 L
s
.23976 .15905 m
.23976 .15905 L
s
.23983 .15671 m
.23983 .15671 L
s
.23991 .15835 m
.23991 .15835 L
s
.23998 .16035 m
.23998 .16035 L
s
.24006 .1661 m
.24006 .1661 L
s
.24013 .16622 m
.24013 .16622 L
s
.24021 .16469 m
.24021 .16469 L
s
.24028 .16187 m
.24028 .16187 L
s
.24036 .17103 m
.24036 .17103 L
s
.24043 .16634 m
.24043 .16634 L
s
.24051 .16892 m
.24051 .16892 L
s
.24057 .16856 m
.24057 .16856 L
s
.24065 .16599 m
.24065 .16599 L
s
.24072 .16927 m
.24072 .16927 L
s
.2408 .17021 m
.2408 .17021 L
s
.24087 .17479 m
.24087 .17479 L
s
.24095 .1722 m
.24095 .1722 L
s
.24102 .16599 m
.24102 .16599 L
s
.2411 .16399 m
.2411 .16399 L
s
.24117 .17127 m
.24117 .17127 L
s
.24125 .16998 m
.24125 .16998 L
s
.24132 .17773 m
.24132 .17773 L
s
.24139 .17843 m
.24139 .17843 L
s
.24147 .1708 m
.24147 .1708 L
s
.24154 .17573 m
.24154 .17573 L
s
.24162 .17327 m
.24162 .17327 L
s
.24169 .17197 m
.24169 .17197 L
s
.24177 .1735 m
.24177 .1735 L
s
.24184 .1735 m
.24184 .1735 L
s
.24191 .17103 m
.24191 .17103 L
s
.24199 .17491 m
.24199 .17491 L
s
.24207 .17244 m
.24207 .17244 L
s
.24214 .17092 m
.24214 .17092 L
s
.24221 .16986 m
.24221 .16986 L
s
.24228 .16058 m
.24228 .16058 L
s
.24236 .16281 m
.24236 .16281 L
s
.24243 .15835 m
.24243 .15835 L
s
.24251 .15717 m
.24251 .15717 L
s
.24258 .15941 m
.24258 .15941 L
s
.24266 .16117 m
.24266 .16117 L
s
.24273 .15964 m
.24273 .15964 L
s
.24281 .16023 m
.24281 .16023 L
s
.24288 .15529 m
.24288 .15529 L
s
.24296 .15506 m
.24296 .15506 L
s
.24303 .1621 m
.24303 .1621 L
s
.2431 .16469 m
.2431 .16469 L
s
.24318 .1614 m
.24318 .1614 L
s
.24325 .15976 m
.24325 .15976 L
s
.24333 .15517 m
.24333 .15517 L
s
.2434 .15753 m
.2434 .15753 L
s
.24348 .15377 m
.24348 .15377 L
s
.24354 .15471 m
.24354 .15471 L
s
.24362 .1526 m
.24362 .1526 L
s
.2437 .14872 m
.2437 .14872 L
s
.24377 .14684 m
.24377 .14684 L
s
.24384 .14308 m
.24384 .14308 L
s
.24392 .13933 m
.24392 .13933 L
s
.24399 .13791 m
.24399 .13791 L
s
.24407 .14273 m
.24407 .14273 L
s
.24414 .14343 m
.24414 .14343 L
s
.24422 .14402 m
.24422 .14402 L
s
.24429 .15729 m
.24429 .15729 L
s
.24436 .16305 m
.24436 .16305 L
s
.24444 .16856 m
.24444 .16856 L
s
.24452 .16222 m
.24452 .16222 L
s
.24459 .16258 m
.24459 .16258 L
s
.24466 .16798 m
.24466 .16798 L
s
.24474 .16939 m
.24474 .16939 L
s
.24481 .17068 m
.24481 .17068 L
s
.24489 .16375 m
.24489 .16375 L
s
.24496 .16317 m
.24496 .16317 L
s
.24504 .16457 m
.24504 .16457 L
s
.24511 .16915 m
.24511 .16915 L
s
.24518 .16504 m
.24518 .16504 L
s
.24525 .16246 m
.24525 .16246 L
s
.24533 .16093 m
.24533 .16093 L
s
.2454 .1614 m
.2454 .1614 L
s
.24548 .1614 m
.24548 .1614 L
s
.24555 .16117 m
.24555 .16117 L
s
.24563 .15706 m
.24563 .15706 L
s
.2457 .15858 m
.2457 .15858 L
s
.24578 .15753 m
.24578 .15753 L
s
.24585 .16234 m
.24585 .16234 L
s
.24593 .16516 m
.24593 .16516 L
s
.24599 .17056 m
.24599 .17056 L
s
.24607 .17855 m
.24607 .17855 L
s
.24615 .17456 m
.24615 .17456 L
s
.24622 .17549 m
.24622 .17549 L
s
.2463 .17362 m
.2463 .17362 L
s
.24637 .17573 m
.24637 .17573 L
s
.24645 .1715 m
.24645 .1715 L
s
.24652 .17467 m
.24652 .17467 L
s
.2466 .17185 m
.2466 .17185 L
s
.24667 .17362 m
.24667 .17362 L
s
.24674 .17256 m
.24674 .17256 L
s
.24681 .16892 m
.24681 .16892 L
s
.24689 .16774 m
.24689 .16774 L
s
.24696 .17103 m
.24696 .17103 L
s
.24704 .17502 m
.24704 .17502 L
s
.24711 .17549 m
.24711 .17549 L
s
.24719 .18078 m
.24719 .18078 L
s
.24726 .17667 m
.24726 .17667 L
s
.24734 .17444 m
.24734 .17444 L
s
.24741 .17103 m
.24741 .17103 L
s
.24749 .17009 m
.24749 .17009 L
s
.24756 .17385 m
.24756 .17385 L
s
.24763 .17467 m
.24763 .17467 L
s
.24771 .17691 m
.24771 .17691 L
s
.24778 .17479 m
.24778 .17479 L
s
.24786 .17033 m
.24786 .17033 L
s
.24793 .16551 m
.24793 .16551 L
s
.24801 .16187 m
.24801 .16187 L
s
.24808 .15905 m
.24808 .15905 L
s
.24816 .15917 m
.24816 .15917 L
s
.24823 .15917 m
.24823 .15917 L
s
.24831 .16293 m
.24831 .16293 L
s
.24837 .15471 m
.24837 .15471 L
s
.24845 .15154 m
.24845 .15154 L
s
.24852 .15424 m
.24852 .15424 L
s
.2486 .15389 m
.2486 .15389 L
s
.24867 .14966 m
.24867 .14966 L
s
.24875 .14637 m
.24875 .14637 L
s
.24882 .14437 m
.24882 .14437 L
s
.2489 .1405 m
.2489 .1405 L
s
.24897 .13615 m
.24897 .13615 L
s
.24905 .14015 m
.24905 .14015 L
s
.24912 .14202 m
.24912 .14202 L
s
.24919 .13686 m
.24919 .13686 L
s
.24927 .13333 m
.24927 .13333 L
s
.24934 .14437 m
.24934 .14437 L
s
.24942 .14543 m
.24942 .14543 L
s
.24949 .14637 m
.24949 .14637 L
s
.24957 .1425 m
.24957 .1425 L
s
.24964 .13886 m
.24964 .13886 L
s
.24972 .14355 m
.24972 .14355 L
s
.24979 .14085 m
.24979 .14085 L
s
.24987 .14202 m
.24987 .14202 L
s
.24994 .14531 m
.24994 .14531 L
s
.25001 .14579 m
.25001 .14579 L
s
.25008 .14919 m
.25008 .14919 L
s
.25016 .14614 m
.25016 .14614 L
s
.25023 .14661 m
.25023 .14661 L
s
.25031 .14425 m
.25031 .14425 L
s
.25038 .14684 m
.25038 .14684 L
s
.25046 .14179 m
.25046 .14179 L
s
.25053 .13733 m
.25053 .13733 L
s
.25061 .13733 m
.25061 .13733 L
s
.25068 .14143 m
.25068 .14143 L
s
.25076 .13803 m
.25076 .13803 L
s
.25083 .13651 m
.25083 .13651 L
s
.2509 .13838 m
.2509 .13838 L
s
.25098 .13909 m
.25098 .13909 L
s
.25105 .1419 m
.25105 .1419 L
s
.25113 .14449 m
.25113 .14449 L
s
.2512 .14226 m
.2512 .14226 L
s
.25128 .13933 m
.25128 .13933 L
s
.25135 .13803 m
.25135 .13803 L
s
.25143 .13462 m
.25143 .13462 L
s
.2515 .13228 m
.2515 .13228 L
s
.25157 .13251 m
.25157 .13251 L
s
.25164 .1412 m
.25164 .1412 L
s
.25172 .14472 m
.25172 .14472 L
s
.25179 .14355 m
.25179 .14355 L
s
.25187 .13838 m
.25187 .13838 L
s
.25194 .13439 m
.25194 .13439 L
s
.25202 .13298 m
.25202 .13298 L
s
.25209 .13627 m
.25209 .13627 L
s
.25216 .13768 m
.25216 .13768 L
s
.25224 .13604 m
.25224 .13604 L
s
.25232 .13933 m
.25232 .13933 L
s
.25239 .13533 m
.25239 .13533 L
s
.25246 .13415 m
.25246 .13415 L
s
.25254 .13275 m
.25254 .13275 L
s
.25261 .13733 m
.25261 .13733 L
s
.25269 .13991 m
.25269 .13991 L
s
.25276 .14073 m
.25276 .14073 L
s
.25284 .14519 m
.25284 .14519 L
s
.25291 .13674 m
.25291 .13674 L
s
.25298 .13439 m
.25298 .13439 L
s
.25306 .13462 m
.25306 .13462 L
s
.25313 .13392 m
.25313 .13392 L
s
.2532 .13768 m
.2532 .13768 L
s
.25328 .13533 m
.25328 .13533 L
s
.25335 .13439 m
.25335 .13439 L
s
.25343 .13744 m
.25343 .13744 L
s
.2535 .13439 m
.2535 .13439 L
s
.25358 .13557 m
.25358 .13557 L
s
.25365 .14238 m
.25365 .14238 L
s
.25373 .1419 m
.25373 .1419 L
s
.25379 .13861 m
.25379 .13861 L
s
.25387 .14167 m
.25387 .14167 L
s
.25395 .13886 m
.25395 .13886 L
s
.25402 .13486 m
.25402 .13486 L
s
.2541 .13251 m
.2541 .13251 L
s
.25417 .13838 m
.25417 .13838 L
s
.25425 .13744 m
.25425 .13744 L
s
.25432 .13627 m
.25432 .13627 L
s
.2544 .13815 m
.2544 .13815 L
s
.25447 .13979 m
.25447 .13979 L
s
.25454 .13744 m
.25454 .13744 L
s
.25461 .13815 m
.25461 .13815 L
s
.25469 .13838 m
.25469 .13838 L
s
.25477 .13909 m
.25477 .13909 L
s
.25484 .14519 m
.25484 .14519 L
s
.25491 .14496 m
.25491 .14496 L
s
.25499 .14825 m
.25499 .14825 L
s
.25506 .14379 m
.25506 .14379 L
s
.25514 .15412 m
.25514 .15412 L
s
.25521 .156 m
.25521 .156 L
s
.25529 .15224 m
.25529 .15224 L
s
.25536 .15036 m
.25536 .15036 L
s
.25543 .14637 m
.25543 .14637 L
s
.25551 .14731 m
.25551 .14731 L
s
.25558 .1419 m
.25558 .1419 L
s
.25566 .13721 m
.25566 .13721 L
s
.25573 .13439 m
.25573 .13439 L
s
.25581 .13651 m
.25581 .13651 L
s
.25588 .13345 m
.25588 .13345 L
s
.25596 .14073 m
.25596 .14073 L
s
.25603 .14332 m
.25603 .14332 L
s
.25611 .14684 m
.25611 .14684 L
s
.25617 .14919 m
.25617 .14919 L
s
.25625 .14872 m
.25625 .14872 L
s
.25632 .14825 m
.25632 .14825 L
s
.2564 .14449 m
.2564 .14449 L
s
.25647 .14472 m
.25647 .14472 L
s
.25655 .14285 m
.25655 .14285 L
s
.25662 .13486 m
.25662 .13486 L
s
.2567 .13462 m
.2567 .13462 L
s
.25677 .14073 m
.25677 .14073 L
s
.25685 .14297 m
.25685 .14297 L
s
.25692 .13921 m
.25692 .13921 L
s
.25699 .14085 m
.25699 .14085 L
s
.25707 .13791 m
.25707 .13791 L
s
.25714 .1358 m
.25714 .1358 L
s
.25722 .13604 m
.25722 .13604 L
s
.25729 .13968 m
.25729 .13968 L
s
.25737 .14261 m
.25737 .14261 L
s
.25744 .14179 m
.25744 .14179 L
s
.25752 .13604 m
.25752 .13604 L
s
.25759 .13228 m
.25759 .13228 L
s
.25767 .13474 m
.25767 .13474 L
s
.25774 .13756 m
.25774 .13756 L
s
.25781 .13521 m
.25781 .13521 L
s
.25788 .13275 m
.25788 .13275 L
s
.25796 .13779 m
.25796 .13779 L
s
.25803 .13921 m
.25803 .13921 L
s
.25811 .13497 m
.25811 .13497 L
s
.25818 .13803 m
.25818 .13803 L
s
.25826 .13497 m
.25826 .13497 L
s
.25833 .13979 m
.25833 .13979 L
s
.25841 .13968 m
.25841 .13968 L
s
.25848 .13933 m
.25848 .13933 L
s
.25856 .13721 m
.25856 .13721 L
s
.25863 .13968 m
.25863 .13968 L
s
.2587 .13791 m
.2587 .13791 L
s
.25878 .13345 m
.25878 .13345 L
s
.25885 .13886 m
.25885 .13886 L
s
.25893 .14143 m
.25893 .14143 L
s
.259 .15013 m
.259 .15013 L
s
.25908 .14731 m
.25908 .14731 L
s
.25915 .15224 m
.25915 .15224 L
s
.25923 .15013 m
.25923 .15013 L
s
.2593 .15506 m
.2593 .15506 L
s
.25937 .15435 m
.25937 .15435 L
s
.25944 .15154 m
.25944 .15154 L
s
.25952 .15412 m
.25952 .15412 L
s
.25959 .15858 m
.25959 .15858 L
s
.25967 .15248 m
.25967 .15248 L
s
.25974 .15671 m
.25974 .15671 L
s
.25982 .15318 m
.25982 .15318 L
s
.25989 .15083 m
.25989 .15083 L
s
.25997 .14707 m
.25997 .14707 L
s
.26004 .1405 m
.26004 .1405 L
s
.26012 .13744 m
.26012 .13744 L
s
.26019 .13298 m
.26019 .13298 L
s
.26026 .13545 m
.26026 .13545 L
s
.26034 .13592 m
.26034 .13592 L
s
.26041 .13651 m
.26041 .13651 L
s
.26049 .1385 m
.26049 .1385 L
s
.26056 .14026 m
.26056 .14026 L
s
.26064 .14507 m
.26064 .14507 L
s
.26071 .14202 m
.26071 .14202 L
s
.26078 .14696 m
.26078 .14696 L
s
.26086 .14848 m
.26086 .14848 L
s
.26094 .14754 m
.26094 .14754 L
s
.261 .14167 m
.261 .14167 L
s
.26108 .13651 m
.26108 .13651 L
s
.26115 .14202 m
.26115 .14202 L
s
.26123 .13651 m
.26123 .13651 L
s
.2613 .13768 m
.2613 .13768 L
s
.26138 .14097 m
.26138 .14097 L
s
.26145 .1405 m
.26145 .1405 L
s
.26153 .13486 m
.26153 .13486 L
s
.2616 .13369 m
.2616 .13369 L
s
.26167 .13909 m
.26167 .13909 L
s
.26175 .13815 m
.26175 .13815 L
s
.26182 .14026 m
.26182 .14026 L
s
.2619 .14308 m
.2619 .14308 L
s
.26197 .14202 m
.26197 .14202 L
s
.26205 .14297 m
.26205 .14297 L
s
.26212 .14707 m
.26212 .14707 L
s
.2622 .14696 m
.2622 .14696 L
s
.26227 .14425 m
.26227 .14425 L
s
.26234 .14402 m
.26234 .14402 L
s
.26241 .13486 m
.26241 .13486 L
s
.26249 .13392 m
.26249 .13392 L
s
.26257 .13275 m
.26257 .13275 L
s
.26264 .13345 m
.26264 .13345 L
s
.26271 .13944 m
.26271 .13944 L
s
.26279 .14073 m
.26279 .14073 L
s
.26286 .14003 m
.26286 .14003 L
s
.26294 .14379 m
.26294 .14379 L
s
.26301 .14778 m
.26301 .14778 L
s
.26309 .15271 m
.26309 .15271 L
s
.26316 .15377 m
.26316 .15377 L
s
.26323 .15988 m
.26323 .15988 L
s
.26331 .15612 m
.26331 .15612 L
s
.26338 .15189 m
.26338 .15189 L
s
.26346 .14872 m
.26346 .14872 L
s
.26353 .14579 m
.26353 .14579 L
s
.26361 .15189 m
.26361 .15189 L
s
.26368 .15295 m
.26368 .15295 L
s
.26376 .15823 m
.26376 .15823 L
s
.26383 .15553 m
.26383 .15553 L
s
.26391 .15377 m
.26391 .15377 L
s
.26397 .14731 m
.26397 .14731 L
s
.26405 .14836 m
.26405 .14836 L
s
.26412 .14379 m
.26412 .14379 L
s
.2642 .14367 m
.2642 .14367 L
s
.26427 .14719 m
.26427 .14719 L
s
.26435 .15001 m
.26435 .15001 L
s
.26442 .1425 m
.26442 .1425 L
s
.2645 .13815 m
.2645 .13815 L
s
.26457 .13721 m
.26457 .13721 L
s
.26465 .13345 m
.26465 .13345 L
s
.26472 .13615 m
.26472 .13615 L
s
.26479 .13956 m
.26479 .13956 L
s
.26487 .1338 m
.26487 .1338 L
s
.26494 .13251 m
.26494 .13251 L
s
.26502 .13392 m
.26502 .13392 L
s
.26509 .13427 m
.26509 .13427 L
s
.26517 .13333 m
.26517 .13333 L
s
.26524 .13404 m
.26524 .13404 L
s
.26532 .1358 m
.26532 .1358 L
s
.26539 .13404 m
.26539 .13404 L
s
.26547 .13509 m
.26547 .13509 L
s
.26554 .13533 m
.26554 .13533 L
s
.26561 .13216 m
.26561 .13216 L
s
.26568 .13298 m
.26568 .13298 L
s
.26576 .13791 m
.26576 .13791 L
s
.26583 .13979 m
.26583 .13979 L
s
.26591 .14402 m
.26591 .14402 L
s
.26598 .13462 m
.26598 .13462 L
s
.26606 .13627 m
.26606 .13627 L
s
.26613 .13651 m
.26613 .13651 L
s
.26621 .13275 m
.26621 .13275 L
s
.26628 .13604 m
.26628 .13604 L
s
.26636 .13627 m
.26636 .13627 L
s
.26643 .13662 m
.26643 .13662 L
s
.2665 .13557 m
.2665 .13557 L
s
.26658 .13486 m
.26658 .13486 L
s
.26665 .13521 m
.26665 .13521 L
s
.26673 .13815 m
.26673 .13815 L
s
.2668 .13733 m
.2668 .13733 L
s
.26688 .13897 m
.26688 .13897 L
s
.26695 .13886 m
.26695 .13886 L
s
.26703 .1419 m
.26703 .1419 L
s
.2671 .14097 m
.2671 .14097 L
s
.26717 .14073 m
.26717 .14073 L
s
.26724 .14273 m
.26724 .14273 L
s
.26732 .14543 m
.26732 .14543 L
s
.26739 .14285 m
.26739 .14285 L
s
.26747 .13744 m
.26747 .13744 L
s
.26754 .14449 m
.26754 .14449 L
s
.26762 .14989 m
.26762 .14989 L
s
.26769 .14308 m
.26769 .14308 L
s
.26777 .14167 m
.26777 .14167 L
s
.26784 .14614 m
.26784 .14614 L
s
.26792 .14519 m
.26792 .14519 L
s
.26799 .14379 m
.26799 .14379 L
s
.26806 .14132 m
.26806 .14132 L
s
.26814 .14061 m
.26814 .14061 L
s
.26821 .14073 m
.26821 .14073 L
s
.26829 .1358 m
.26829 .1358 L
s
.26836 .13486 m
.26836 .13486 L
s
.26844 .13604 m
.26844 .13604 L
s
.26851 .13439 m
.26851 .13439 L
s
.26858 .13392 m
.26858 .13392 L
s
.26866 .13415 m
.26866 .13415 L
s
.26874 .13251 m
.26874 .13251 L
s
.2688 .13533 m
.2688 .13533 L
s
.26888 .13674 m
.26888 .13674 L
s
.26895 .13944 m
.26895 .13944 L
s
.26903 .13263 m
.26903 .13263 L
s
.2691 .1412 m
.2691 .1412 L
s
.26918 .1419 m
.26918 .1419 L
s
.26925 .13861 m
.26925 .13861 L
s
.26933 .13486 m
.26933 .13486 L
s
.2694 .13557 m
.2694 .13557 L
s
.26948 .13815 m
.26948 .13815 L
s
.26956 .13298 m
.26956 .13298 L
s
.26962 .13439 m
.26962 .13439 L
s
.2697 .13439 m
.2697 .13439 L
s
.26977 .13956 m
.26977 .13956 L
s
.26985 .13298 m
.26985 .13298 L
s
.26992 .13474 m
.26992 .13474 L
s
.27 .1358 m
.27 .1358 L
s
.27007 .13216 m
.27007 .13216 L
s
.27014 .13627 m
.27014 .13627 L
s
.27021 .13721 m
.27021 .13721 L
s
.27029 .13933 m
.27029 .13933 L
s
.27037 .13345 m
.27037 .13345 L
s
.27044 .13886 m
.27044 .13886 L
s
.27051 .13838 m
.27051 .13838 L
s
.27059 .1513 m
.27059 .1513 L
s
.27066 .14543 m
.27066 .14543 L
s
.27074 .14261 m
.27074 .14261 L
s
.27081 .14567 m
.27081 .14567 L
s
.27089 .14567 m
.27089 .14567 L
s
.27096 .14238 m
.27096 .14238 L
s
.27103 .14073 m
.27103 .14073 L
s
.27111 .13768 m
.27111 .13768 L
s
.27119 .1419 m
.27119 .1419 L
s
.27126 .13791 m
.27126 .13791 L
s
.27133 .13275 m
.27133 .13275 L
s
.27141 .13509 m
.27141 .13509 L
s
.27148 .13521 m
.27148 .13521 L
s
.27156 .13228 m
.27156 .13228 L
s
.27163 .13216 m
.27163 .13216 L
s
.27171 .13205 m
.27171 .13205 L
s
.27177 .13651 m
.27177 .13651 L
s
.27185 .1405 m
.27185 .1405 L
s
.27192 .14872 m
.27192 .14872 L
s
.272 .15295 m
.272 .15295 L
s
.27207 .16023 m
.27207 .16023 L
s
.27215 .16187 m
.27215 .16187 L
s
.27222 .16704 m
.27222 .16704 L
s
.2723 .16774 m
.2723 .16774 L
s
.27237 .17596 m
.27237 .17596 L
s
.27245 .17878 m
.27245 .17878 L
s
.27252 .17925 m
.27252 .17925 L
s
.27259 .17761 m
.27259 .17761 L
s
.27267 .17973 m
.27267 .17973 L
s
.27274 .17714 m
.27274 .17714 L
s
.27282 .17925 m
.27282 .17925 L
s
.27289 .18137 m
.27289 .18137 L
s
.27297 .17831 m
.27297 .17831 L
s
.27304 .17761 m
.27304 .17761 L
s
.27312 .17127 m
.27312 .17127 L
s
.27319 .16915 m
.27319 .16915 L
s
.27327 .17362 m
.27327 .17362 L
s
.27334 .16892 m
.27334 .16892 L
s
.27341 .17174 m
.27341 .17174 L
s
.27348 .17948 m
.27348 .17948 L
s
.27356 .17973 m
.27356 .17973 L
s
.27363 .17902 m
.27363 .17902 L
s
.27371 .17738 m
.27371 .17738 L
s
.27378 .17784 m
.27378 .17784 L
s
.27386 .17691 m
.27386 .17691 L
s
.27393 .17784 m
.27393 .17784 L
s
.27401 .18395 m
.27401 .18395 L
s
.27408 .18395 m
.27408 .18395 L
s
.27416 .18277 m
.27416 .18277 L
s
.27423 .17948 m
.27423 .17948 L
s
.2743 .17902 m
.2743 .17902 L
s
.27438 .17855 m
.27438 .17855 L
s
.27445 .17973 m
.27445 .17973 L
s
.27453 .18066 m
.27453 .18066 L
s
.2746 .17925 m
.2746 .17925 L
s
.27468 .17479 m
.27468 .17479 L
s
.27475 .17338 m
.27475 .17338 L
s
.27483 .16915 m
.27483 .16915 L
s
.2749 .16399 m
.2749 .16399 L
s
.27497 .16422 m
.27497 .16422 L
s
.27504 .15905 m
.27504 .15905 L
s
.27512 .16093 m
.27512 .16093 L
s
.27519 .15929 m
.27519 .15929 L
s
.27527 .15647 m
.27527 .15647 L
s
.27534 .15858 m
.27534 .15858 L
s
.27542 .16375 m
.27542 .16375 L
s
.27549 .16234 m
.27549 .16234 L
s
.27557 .16375 m
.27557 .16375 L
s
.27564 .16187 m
.27564 .16187 L
s
.27572 .1621 m
.27572 .1621 L
s
.27579 .15788 m
.27579 .15788 L
s
.27586 .156 m
.27586 .156 L
s
.27594 .15248 m
.27594 .15248 L
s
.27601 .15929 m
.27601 .15929 L
s
.27609 .15811 m
.27609 .15811 L
s
.27616 .156 m
.27616 .156 L
s
.27624 .15717 m
.27624 .15717 L
s
.27631 .15811 m
.27631 .15811 L
s
.27639 .16234 m
.27639 .16234 L
s
.27646 .16375 m
.27646 .16375 L
s
.27654 .15953 m
.27654 .15953 L
s
.2766 .16727 m
.2766 .16727 L
s
.27668 .17596 m
.27668 .17596 L
s
.27675 .1762 m
.27675 .1762 L
s
.27683 .18254 m
.27683 .18254 L
s
.2769 .18372 m
.2769 .18372 L
s
.27698 .18207 m
.27698 .18207 L
s
.27705 .18301 m
.27705 .18301 L
s
.27713 .18325 m
.27713 .18325 L
s
.2772 .18771 m
.2772 .18771 L
s
.27728 .18865 m
.27728 .18865 L
s
.27736 .19569 m
.27736 .19569 L
s
.27742 .19476 m
.27742 .19476 L
s
.2775 .19405 m
.2775 .19405 L
s
.27757 .19358 m
.27757 .19358 L
s
.27765 .191 m
.27765 .191 L
s
.27772 .18559 m
.27772 .18559 L
s
.2778 .18748 m
.2778 .18748 L
s
.27787 .18912 m
.27787 .18912 L
s
.27794 .19287 m
.27794 .19287 L
s
.27802 .19429 m
.27802 .19429 L
s
.2781 .2011 m
.2781 .2011 L
s
.27817 .20063 m
.27817 .20063 L
s
.27824 .19804 m
.27824 .19804 L
s
.27831 .19311 m
.27831 .19311 L
s
.27839 .19452 m
.27839 .19452 L
s
.27846 .19452 m
.27846 .19452 L
s
.27854 .19546 m
.27854 .19546 L
s
.27861 .1964 m
.27861 .1964 L
s
.27869 .19311 m
.27869 .19311 L
s
.27876 .19287 m
.27876 .19287 L
s
.27883 .19264 m
.27883 .19264 L
s
.27891 .1863 m
.27891 .1863 L
s
.27899 .1863 m
.27899 .1863 L
s
.27906 .18748 m
.27906 .18748 L
s
.27913 .18512 m
.27913 .18512 L
s
.27921 .18841 m
.27921 .18841 L
s
.27928 .18724 m
.27928 .18724 L
s
.27936 .18748 m
.27936 .18748 L
s
.27943 .19311 m
.27943 .19311 L
s
.27951 .18606 m
.27951 .18606 L
s
.27957 .19287 m
.27957 .19287 L
s
.27965 .19194 m
.27965 .19194 L
s
.27973 .19358 m
.27973 .19358 L
s
.2798 .19217 m
.2798 .19217 L
s
.27987 .1924 m
.27987 .1924 L
s
.27995 .1917 m
.27995 .1917 L
s
.28002 .18701 m
.28002 .18701 L
s
.2801 .18301 m
.2801 .18301 L
s
.28017 .17784 m
.28017 .17784 L
s
.28025 .17244 m
.28025 .17244 L
s
.28032 .17197 m
.28032 .17197 L
s
.28039 .17056 m
.28039 .17056 L
s
.28047 .17056 m
.28047 .17056 L
s
.28054 .17338 m
.28054 .17338 L
s
.28062 .17056 m
.28062 .17056 L
s
.28069 .17973 m
.28069 .17973 L
s
.28077 .17761 m
.28077 .17761 L
s
.28084 .17831 m
.28084 .17831 L
s
.28092 .1802 m
.28092 .1802 L
s
.28099 .18559 m
.28099 .18559 L
s
.28107 .18277 m
.28107 .18277 L
s
.28114 .18466 m
.28114 .18466 L
s
.28121 .18512 m
.28121 .18512 L
s
.28128 .18536 m
.28128 .18536 L
s
.28136 .17902 m
.28136 .17902 L
s
.28144 .17573 m
.28144 .17573 L
s
.28151 .17573 m
.28151 .17573 L
s
.28158 .17573 m
.28158 .17573 L
s
.28166 .1762 m
.28166 .1762 L
s
.28173 .17644 m
.28173 .17644 L
s
.28181 .17925 m
.28181 .17925 L
s
.28188 .17925 m
.28188 .17925 L
s
.28196 .1816 m
.28196 .1816 L
s
.28203 .18277 m
.28203 .18277 L
s
.2821 .18184 m
.2821 .18184 L
s
.28218 .18043 m
.28218 .18043 L
s
.28225 .18489 m
.28225 .18489 L
s
.28233 .18606 m
.28233 .18606 L
s
.2824 .18724 m
.2824 .18724 L
s
.28248 .18254 m
.28248 .18254 L
s
.28255 .17808 m
.28255 .17808 L
s
.28263 .1762 m
.28263 .1762 L
s
.2827 .17573 m
.2827 .17573 L
s
.28277 .17244 m
.28277 .17244 L
s
.28284 .17315 m
.28284 .17315 L
s
.28292 .16727 m
.28292 .16727 L
s
.28299 .16492 m
.28299 .16492 L
s
.28307 .1722 m
.28307 .1722 L
s
.28314 .17714 m
.28314 .17714 L
s
.28322 .18066 m
.28322 .18066 L
s
.28329 .18207 m
.28329 .18207 L
s
.28337 .17456 m
.28337 .17456 L
s
.28344 .17738 m
.28344 .17738 L
s
.28352 .1762 m
.28352 .1762 L
s
.28359 .18301 m
.28359 .18301 L
s
.28366 .17714 m
.28366 .17714 L
s
.28374 .1715 m
.28374 .1715 L
s
.28381 .16915 m
.28381 .16915 L
s
.28389 .16915 m
.28389 .16915 L
s
.28396 .16963 m
.28396 .16963 L
s
.28404 .1722 m
.28404 .1722 L
s
.28411 .16821 m
.28411 .16821 L
s
.28419 .17596 m
.28419 .17596 L
s
.28426 .17784 m
.28426 .17784 L
s
.28434 .18372 m
.28434 .18372 L
s
.28441 .18395 m
.28441 .18395 L
s
.28448 .17878 m
.28448 .17878 L
s
.28455 .17526 m
.28455 .17526 L
s
.28463 .17549 m
.28463 .17549 L
s
.2847 .1809 m
.2847 .1809 L
s
.28478 .18137 m
.28478 .18137 L
s
.28485 .18419 m
.28485 .18419 L
s
.28493 .18888 m
.28493 .18888 L
s
.285 .191 m
.285 .191 L
s
.28508 .19217 m
.28508 .19217 L
s
.28516 .1964 m
.28516 .1964 L
s
.28522 .19593 m
.28522 .19593 L
s
.2853 .19287 m
.2853 .19287 L
s
.28537 .19499 m
.28537 .19499 L
s
.28545 .19006 m
.28545 .19006 L
s
.28552 .19123 m
.28552 .19123 L
s
.2856 .1924 m
.2856 .1924 L
s
.28567 .18559 m
.28567 .18559 L
s
.28574 .1863 m
.28574 .1863 L
s
.28582 .18748 m
.28582 .18748 L
s
.2859 .1802 m
.2859 .1802 L
s
.28597 .17549 m
.28597 .17549 L
s
.28604 .16539 m
.28604 .16539 L
s
.28611 .16352 m
.28611 .16352 L
s
.28619 .15835 m
.28619 .15835 L
s
.28626 .16422 m
.28626 .16422 L
s
.28634 .1661 m
.28634 .1661 L
s
.28641 .16774 m
.28641 .16774 L
s
.28649 .16516 m
.28649 .16516 L
s
.28656 .16751 m
.28656 .16751 L
s
.28664 .17362 m
.28664 .17362 L
s
.28672 .17573 m
.28672 .17573 L
s
.28679 .18043 m
.28679 .18043 L
s
.28686 .17738 m
.28686 .17738 L
s
.28693 .18372 m
.28693 .18372 L
s
.28701 .18724 m
.28701 .18724 L
s
.28708 .18137 m
.28708 .18137 L
s
.28716 .18137 m
.28716 .18137 L
s
.28723 .17855 m
.28723 .17855 L
s
.28731 .18442 m
.28731 .18442 L
s
.28738 .18771 m
.28738 .18771 L
s
.28745 .18113 m
.28745 .18113 L
s
.28753 .1816 m
.28753 .1816 L
s
.2876 .18419 m
.2876 .18419 L
s
.28767 .18865 m
.28767 .18865 L
s
.28775 .18888 m
.28775 .18888 L
s
.28782 .18865 m
.28782 .18865 L
s
.2879 .19194 m
.2879 .19194 L
s
.28797 .19264 m
.28797 .19264 L
s
.28805 .19711 m
.28805 .19711 L
s
.28812 .2018 m
.28812 .2018 L
s
.28819 .20509 m
.28819 .20509 L
s
.28827 .21214 m
.28827 .21214 L
s
.28835 .21613 m
.28835 .21613 L
s
.28842 .21801 m
.28842 .21801 L
s
.28849 .21801 m
.28849 .21801 L
s
.28857 .21965 m
.28857 .21965 L
s
.28864 .21542 m
.28864 .21542 L
s
.28872 .20979 m
.28872 .20979 L
s
.28879 .21002 m
.28879 .21002 L
s
.28887 .20603 m
.28887 .20603 L
s
.28894 .21261 m
.28894 .21261 L
s
.28901 .20979 m
.28901 .20979 L
s
.28908 .21284 m
.28908 .21284 L
s
.28916 .21284 m
.28916 .21284 L
s
.28924 .21613 m
.28924 .21613 L
s
.28931 .21026 m
.28931 .21026 L
s
.28938 .21167 m
.28938 .21167 L
s
.28946 .20861 m
.28946 .20861 L
s
.28953 .20486 m
.28953 .20486 L
s
.28961 .19898 m
.28961 .19898 L
s
.28968 .19711 m
.28968 .19711 L
s
.28976 .19616 m
.28976 .19616 L
s
.28983 .19687 m
.28983 .19687 L
s
.2899 .19968 m
.2899 .19968 L
s
.28998 .20462 m
.28998 .20462 L
s
.29005 .19711 m
.29005 .19711 L
s
.29013 .19804 m
.29013 .19804 L
s
.2902 .20885 m
.2902 .20885 L
s
.29028 .21026 m
.29028 .21026 L
s
.29035 .20744 m
.29035 .20744 L
s
.29043 .21073 m
.29043 .21073 L
s
.2905 .2105 m
.2905 .2105 L
s
.29057 .21073 m
.29057 .21073 L
s
.29064 .2065 m
.29064 .2065 L
s
.29072 .20157 m
.29072 .20157 L
s
.29079 .20157 m
.29079 .20157 L
s
.29087 .20697 m
.29087 .20697 L
s
.29094 .20345 m
.29094 .20345 L
s
.29102 .20392 m
.29102 .20392 L
s
.29109 .20908 m
.29109 .20908 L
s
.29117 .21261 m
.29117 .21261 L
s
.29124 .21449 m
.29124 .21449 L
s
.29132 .21496 m
.29132 .21496 L
s
.29139 .21707 m
.29139 .21707 L
s
.29146 .21378 m
.29146 .21378 L
s
.29154 .21895 m
.29154 .21895 L
s
.29161 .2213 m
.29161 .2213 L
s
.29169 .22693 m
.29169 .22693 L
s
.29176 .22364 m
.29176 .22364 L
s
.29184 .22271 m
.29184 .22271 L
s
.29191 .21895 m
.29191 .21895 L
s
.29199 .22459 m
.29199 .22459 L
s
.29206 .2267 m
.29206 .2267 L
s
.29214 .22106 m
.29214 .22106 L
s
.29221 .22999 m
.29221 .22999 L
s
.29228 .22834 m
.29228 .22834 L
s
.29235 .23257 m
.29235 .23257 L
s
.29243 .2368 m
.29243 .2368 L
s
.2925 .2368 m
.2925 .2368 L
s
.29258 .23703 m
.29258 .23703 L
s
.29265 .2469 m
.29265 .2469 L
s
.29273 .2415 m
.29273 .2415 L
s
.2928 .23516 m
.2928 .23516 L
s
.29288 .2408 m
.29288 .2408 L
s
.29296 .23727 m
.29296 .23727 L
s
.29302 .23868 m
.29302 .23868 L
s
.2931 .23187 m
.2931 .23187 L
s
.29317 .22506 m
.29317 .22506 L
s
.29325 .22834 m
.29325 .22834 L
s
.29332 .22459 m
.29332 .22459 L
s
.2934 .21778 m
.2934 .21778 L
s
.29347 .21425 m
.29347 .21425 L
s
.29355 .21918 m
.29355 .21918 L
s
.29362 .21683 m
.29362 .21683 L
s
.2937 .22224 m
.2937 .22224 L
s
.29377 .21707 m
.29377 .21707 L
s
.29384 .21731 m
.29384 .21731 L
s
.29391 .21942 m
.29391 .21942 L
s
.29399 .22012 m
.29399 .22012 L
s
.29406 .21778 m
.29406 .21778 L
s
.29414 .22482 m
.29414 .22482 L
s
.29421 .22693 m
.29421 .22693 L
s
.29429 .22623 m
.29429 .22623 L
s
.29436 .22552 m
.29436 .22552 L
s
.29444 .22482 m
.29444 .22482 L
s
.29452 .23117 m
.29452 .23117 L
s
.29459 .22999 m
.29459 .22999 L
s
.29466 .22506 m
.29466 .22506 L
s
.29473 .22012 m
.29473 .22012 L
s
.29481 .22294 m
.29481 .22294 L
s
.29488 .22177 m
.29488 .22177 L
s
.29496 .21731 m
.29496 .21731 L
s
.29503 .21636 m
.29503 .21636 L
s
.29511 .21284 m
.29511 .21284 L
s
.29518 .21519 m
.29518 .21519 L
s
.29526 .22247 m
.29526 .22247 L
s
.29533 .22529 m
.29533 .22529 L
s
.2954 .22341 m
.2954 .22341 L
s
.29547 .22506 m
.29547 .22506 L
s
.29555 .2213 m
.29555 .2213 L
s
.29562 .21778 m
.29562 .21778 L
s
.2957 .22341 m
.2957 .22341 L
s
.29577 .22741 m
.29577 .22741 L
s
.29585 .2267 m
.29585 .2267 L
s
.29592 .22412 m
.29592 .22412 L
s
.29599 .22083 m
.29599 .22083 L
s
.29607 .21237 m
.29607 .21237 L
s
.29615 .20462 m
.29615 .20462 L
s
.29622 .20157 m
.29622 .20157 L
s
.29629 .20415 m
.29629 .20415 L
s
.29637 .19264 m
.29637 .19264 L
s
.29644 .19358 m
.29644 .19358 L
s
.29652 .18654 m
.29652 .18654 L
s
.29659 .19147 m
.29659 .19147 L
s
.29667 .18912 m
.29667 .18912 L
s
.29674 .18888 m
.29674 .18888 L
s
.29681 .18865 m
.29681 .18865 L
s
.29689 .1816 m
.29689 .1816 L
s
.29697 .18466 m
.29697 .18466 L
s
.29704 .18489 m
.29704 .18489 L
s
.29711 .1823 m
.29711 .1823 L
s
.29718 .17948 m
.29718 .17948 L
s
.29726 .18536 m
.29726 .18536 L
s
.29733 .18066 m
.29733 .18066 L
s
.29741 .18277 m
.29741 .18277 L
s
.29748 .18372 m
.29748 .18372 L
s
.29756 .17925 m
.29756 .17925 L
s
.29763 .17573 m
.29763 .17573 L
s
.2977 .16352 m
.2977 .16352 L
s
.29778 .16986 m
.29778 .16986 L
s
.29785 .16845 m
.29785 .16845 L
s
.29793 .16516 m
.29793 .16516 L
s
.298 .16539 m
.298 .16539 L
s
.29808 .16586 m
.29808 .16586 L
s
.29815 .16399 m
.29815 .16399 L
s
.29823 .16492 m
.29823 .16492 L
s
.2983 .16845 m
.2983 .16845 L
s
.29837 .16704 m
.29837 .16704 L
s
.29844 .16492 m
.29844 .16492 L
s
.29852 .16328 m
.29852 .16328 L
s
.2986 .15811 m
.2986 .15811 L
s
.29867 .15905 m
.29867 .15905 L
s
.29874 .16469 m
.29874 .16469 L
s
.29882 .16704 m
.29882 .16704 L
s
.29889 .16634 m
.29889 .16634 L
s
.29897 .1715 m
.29897 .1715 L
s
.29904 .17878 m
.29904 .17878 L
s
.29912 .17549 m
.29912 .17549 L
s
.29919 .17409 m
.29919 .17409 L
s
.29926 .17925 m
.29926 .17925 L
s
.29934 .1816 m
.29934 .1816 L
s
.29941 .18325 m
.29941 .18325 L
s
.29949 .18606 m
.29949 .18606 L
s
.29956 .18841 m
.29956 .18841 L
s
.29964 .18654 m
.29964 .18654 L
s
.29971 .18748 m
.29971 .18748 L
s
.29979 .18113 m
.29979 .18113 L
s
.29986 .18512 m
.29986 .18512 L
s
.29994 .18888 m
.29994 .18888 L
s
.30001 .18865 m
.30001 .18865 L
s
.30008 .19194 m
.30008 .19194 L
s
.30015 .19664 m
.30015 .19664 L
s
.30023 .19476 m
.30023 .19476 L
s
.3003 .19311 m
.3003 .19311 L
s
.30038 .19499 m
.30038 .19499 L
s
.30045 .19476 m
.30045 .19476 L
s
.30053 .19711 m
.30053 .19711 L
s
.3006 .20016 m
.3006 .20016 L
s
.30068 .20674 m
.30068 .20674 L
s
.30076 .20345 m
.30076 .20345 L
s
.30082 .20321 m
.30082 .20321 L
s
.3009 .20532 m
.3009 .20532 L
s
.30097 .20556 m
.30097 .20556 L
s
.30105 .20086 m
.30105 .20086 L
s
.30112 .20063 m
.30112 .20063 L
s
.3012 .20345 m
.3012 .20345 L
s
.30127 .20932 m
.30127 .20932 L
s
.30135 .21801 m
.30135 .21801 L
s
.30142 .22317 m
.30142 .22317 L
s
.3015 .22224 m
.3015 .22224 L
s
.30157 .22271 m
.30157 .22271 L
s
.30164 .22388 m
.30164 .22388 L
s
.30171 .22153 m
.30171 .22153 L
s
.30179 .222 m
.30179 .222 L
s
.30186 .22482 m
.30186 .22482 L
s
.30194 .22788 m
.30194 .22788 L
s
.30201 .23117 m
.30201 .23117 L
s
.30209 .23374 m
.30209 .23374 L
s
.30216 .23257 m
.30216 .23257 L
s
.30224 .24009 m
.30224 .24009 L
s
.30232 .23539 m
.30232 .23539 L
s
.30239 .23539 m
.30239 .23539 L
s
.30246 .23516 m
.30246 .23516 L
s
.30253 .22764 m
.30253 .22764 L
s
.30261 .22106 m
.30261 .22106 L
s
.30268 .22435 m
.30268 .22435 L
s
.30276 .2213 m
.30276 .2213 L
s
.30283 .22412 m
.30283 .22412 L
s
.30291 .22741 m
.30291 .22741 L
s
.30298 .22811 m
.30298 .22811 L
s
.30306 .22975 m
.30306 .22975 L
s
.30313 .2213 m
.30313 .2213 L
s
.3032 .22083 m
.3032 .22083 L
s
.30327 .21824 m
.30327 .21824 L
s
.30335 .21284 m
.30335 .21284 L
s
.30342 .21284 m
.30342 .21284 L
s
.3035 .21824 m
.3035 .21824 L
s
.30357 .21472 m
.30357 .21472 L
s
.30365 .21143 m
.30365 .21143 L
s
.30372 .2119 m
.30372 .2119 L
s
.3038 .21378 m
.3038 .21378 L
s
.30388 .21731 m
.30388 .21731 L
s
.30395 .22106 m
.30395 .22106 L
s
.30402 .222 m
.30402 .222 L
s
.30409 .21519 m
.30409 .21519 L
s
.30417 .21143 m
.30417 .21143 L
s
.30424 .20861 m
.30424 .20861 L
s
.30432 .22106 m
.30432 .22106 L
s
.30439 .22247 m
.30439 .22247 L
s
.30447 .22599 m
.30447 .22599 L
s
.30454 .22693 m
.30454 .22693 L
s
.30461 .22952 m
.30461 .22952 L
s
.30469 .22764 m
.30469 .22764 L
s
.30477 .22975 m
.30477 .22975 L
s
.30484 .22811 m
.30484 .22811 L
s
.30491 .22858 m
.30491 .22858 L
s
.30498 .23234 m
.30498 .23234 L
s
.30506 .22858 m
.30506 .22858 L
s
.30513 .22834 m
.30513 .22834 L
s
.30521 .22576 m
.30521 .22576 L
s
.30528 .22928 m
.30528 .22928 L
s
.30536 .22741 m
.30536 .22741 L
s
.30543 .22388 m
.30543 .22388 L
s
.30551 .22459 m
.30551 .22459 L
s
.30559 .22952 m
.30559 .22952 L
s
.30565 .22623 m
.30565 .22623 L
s
.30573 .21895 m
.30573 .21895 L
s
.3058 .21284 m
.3058 .21284 L
s
.30588 .21425 m
.30588 .21425 L
s
.30595 .21331 m
.30595 .21331 L
s
.30603 .21214 m
.30603 .21214 L
s
.3061 .21848 m
.3061 .21848 L
s
.30617 .2206 m
.30617 .2206 L
s
.30624 .21895 m
.30624 .21895 L
s
.30632 .21989 m
.30632 .21989 L
s
.3064 .21778 m
.3064 .21778 L
s
.30647 .22294 m
.30647 .22294 L
s
.30654 .21824 m
.30654 .21824 L
s
.30662 .21378 m
.30662 .21378 L
s
.30669 .21214 m
.30669 .21214 L
s
.30677 .21731 m
.30677 .21731 L
s
.30684 .21143 m
.30684 .21143 L
s
.30692 .21237 m
.30692 .21237 L
s
.30699 .21331 m
.30699 .21331 L
s
.30706 .20861 m
.30706 .20861 L
s
.30714 .20626 m
.30714 .20626 L
s
.30722 .20626 m
.30722 .20626 L
s
.30729 .20603 m
.30729 .20603 L
s
.30736 .20603 m
.30736 .20603 L
s
.30744 .21002 m
.30744 .21002 L
s
.30751 .21472 m
.30751 .21472 L
s
.30759 .21707 m
.30759 .21707 L
s
.30766 .21683 m
.30766 .21683 L
s
.30774 .21284 m
.30774 .21284 L
s
.30781 .20768 m
.30781 .20768 L
s
.30788 .21002 m
.30788 .21002 L
s
.30795 .2105 m
.30795 .2105 L
s
.30803 .21778 m
.30803 .21778 L
s
.3081 .22012 m
.3081 .22012 L
s
.30818 .21731 m
.30818 .21731 L
s
.30825 .21918 m
.30825 .21918 L
s
.30833 .21707 m
.30833 .21707 L
s
.3084 .22764 m
.3084 .22764 L
s
.30848 .22529 m
.30848 .22529 L
s
.30856 .22388 m
.30856 .22388 L
s
.30862 .2213 m
.30862 .2213 L
s
.3087 .21848 m
.3087 .21848 L
s
.30877 .21801 m
.30877 .21801 L
s
.30885 .21824 m
.30885 .21824 L
s
.30892 .21683 m
.30892 .21683 L
s
.309 .21942 m
.309 .21942 L
s
.30907 .2206 m
.30907 .2206 L
s
.30915 .2166 m
.30915 .2166 L
s
.30922 .21472 m
.30922 .21472 L
s
.3093 .21754 m
.3093 .21754 L
s
.30937 .22317 m
.30937 .22317 L
s
.30944 .21895 m
.30944 .21895 L
s
.30951 .2166 m
.30951 .2166 L
s
.30959 .21589 m
.30959 .21589 L
s
.30966 .21449 m
.30966 .21449 L
s
.30974 .21472 m
.30974 .21472 L
s
.30981 .21331 m
.30981 .21331 L
s
.30989 .21307 m
.30989 .21307 L
s
.30996 .2105 m
.30996 .2105 L
s
.31004 .21519 m
.31004 .21519 L
s
.31012 .21425 m
.31012 .21425 L
s
.31019 .21542 m
.31019 .21542 L
s
.31026 .20579 m
.31026 .20579 L
s
.31033 .20509 m
.31033 .20509 L
s
.31041 .20227 m
.31041 .20227 L
s
.31048 .19616 m
.31048 .19616 L
s
.31056 .20674 m
.31056 .20674 L
s
.31063 .20861 m
.31063 .20861 L
s
.31071 .20979 m
.31071 .20979 L
s
.31078 .2119 m
.31078 .2119 L
s
.31086 .21519 m
.31086 .21519 L
s
.31093 .21378 m
.31093 .21378 L
s
.311 .21449 m
.311 .21449 L
s
.31107 .21942 m
.31107 .21942 L
s
.31115 .21378 m
.31115 .21378 L
s
.31122 .21425 m
.31122 .21425 L
s
.3113 .21425 m
.3113 .21425 L
s
.31137 .21378 m
.31137 .21378 L
s
.31145 .21683 m
.31145 .21683 L
s
.31152 .21895 m
.31152 .21895 L
s
.3116 .22012 m
.3116 .22012 L
s
.31168 .22693 m
.31168 .22693 L
s
.31175 .22576 m
.31175 .22576 L
s
.31182 .22811 m
.31182 .22811 L
s
.31189 .22788 m
.31189 .22788 L
s
.31197 .22788 m
.31197 .22788 L
s
.31204 .23045 m
.31204 .23045 L
s
.31212 .22529 m
.31212 .22529 L
s
.31219 .22858 m
.31219 .22858 L
s
.31227 .22482 m
.31227 .22482 L
s
.31234 .22388 m
.31234 .22388 L
s
.31242 .22435 m
.31242 .22435 L
s
.31249 .22459 m
.31249 .22459 L
s
.31257 .22693 m
.31257 .22693 L
s
.31264 .2213 m
.31264 .2213 L
s
.31271 .21942 m
.31271 .21942 L
s
.31278 .22271 m
.31278 .22271 L
s
.31286 .22764 m
.31286 .22764 L
s
.31293 .22905 m
.31293 .22905 L
s
.31301 .22952 m
.31301 .22952 L
s
.31308 .22999 m
.31308 .22999 L
s
.31316 .23281 m
.31316 .23281 L
s
.31323 .23374 m
.31323 .23374 L
s
.31331 .2307 m
.31331 .2307 L
s
.31339 .23304 m
.31339 .23304 L
s
.31345 .23821 m
.31345 .23821 L
s
.31353 .2422 m
.31353 .2422 L
s
.3136 .24103 m
.3136 .24103 L
s
.31368 .24314 m
.31368 .24314 L
s
.31375 .24127 m
.31375 .24127 L
s
.31383 .25019 m
.31383 .25019 L
s
.3139 .25489 m
.3139 .25489 L
s
.31397 .26499 m
.31397 .26499 L
s
.31405 .26404 m
.31405 .26404 L
s
.31413 .26404 m
.31413 .26404 L
s
.3142 .26311 m
.3142 .26311 L
s
.31427 .25559 m
.31427 .25559 L
s
.31434 .25723 m
.31434 .25723 L
s
.31442 .257 m
.31442 .257 L
s
.31449 .25583 m
.31449 .25583 L
s
.31457 .25536 m
.31457 .25536 L
s
.31464 .25865 m
.31464 .25865 L
s
.31472 .25653 m
.31472 .25653 L
s
.31479 .25301 m
.31479 .25301 L
s
.31486 .25512 m
.31486 .25512 L
s
.31494 .25606 m
.31494 .25606 L
s
.31502 .25676 m
.31502 .25676 L
s
.31509 .25676 m
.31509 .25676 L
s
.31516 .25277 m
.31516 .25277 L
s
.31524 .25183 m
.31524 .25183 L
s
.31531 .25442 m
.31531 .25442 L
s
.31539 .2469 m
.31539 .2469 L
s
.31546 .24361 m
.31546 .24361 L
s
.31554 .24009 m
.31554 .24009 L
s
.31561 .23633 m
.31561 .23633 L
s
.31568 .23656 m
.31568 .23656 L
s
.31576 .24173 m
.31576 .24173 L
s
.31584 .24455 m
.31584 .24455 L
s
.3159 .24361 m
.3159 .24361 L
s
.31598 .24573 m
.31598 .24573 L
s
.31605 .24995 m
.31605 .24995 L
s
.31613 .25324 m
.31613 .25324 L
s
.3162 .24666 m
.3162 .24666 L
s
.31628 .24808 m
.31628 .24808 L
s
.31636 .24032 m
.31636 .24032 L
s
.31642 .24549 m
.31642 .24549 L
s
.3165 .24455 m
.3165 .24455 L
s
.31657 .24666 m
.31657 .24666 L
s
.31665 .24432 m
.31665 .24432 L
s
.31672 .24596 m
.31672 .24596 L
s
.3168 .24549 m
.3168 .24549 L
s
.31687 .24244 m
.31687 .24244 L
s
.31695 .24103 m
.31695 .24103 L
s
.31702 .23985 m
.31702 .23985 L
s
.3171 .24808 m
.3171 .24808 L
s
.31717 .24761 m
.31717 .24761 L
s
.31724 .24573 m
.31724 .24573 L
s
.31731 .24573 m
.31731 .24573 L
s
.31739 .24948 m
.31739 .24948 L
s
.31747 .24526 m
.31747 .24526 L
s
.31754 .24432 m
.31754 .24432 L
s
.31761 .24103 m
.31761 .24103 L
s
.31769 .24032 m
.31769 .24032 L
s
.31776 .23798 m
.31776 .23798 L
s
.31784 .24009 m
.31784 .24009 L
s
.31792 .23938 m
.31792 .23938 L
s
.31799 .23445 m
.31799 .23445 L
s
.31806 .23422 m
.31806 .23422 L
s
.31813 .23563 m
.31813 .23563 L
s
.31821 .23492 m
.31821 .23492 L
s
.31828 .22717 m
.31828 .22717 L
s
.31836 .22811 m
.31836 .22811 L
s
.31843 .22388 m
.31843 .22388 L
s
.31851 .2267 m
.31851 .2267 L
s
.31858 .23022 m
.31858 .23022 L
s
.31866 .2267 m
.31866 .2267 L
s
.31873 .22764 m
.31873 .22764 L
s
.31881 .22364 m
.31881 .22364 L
s
.31887 .23022 m
.31887 .23022 L
s
.31895 .23281 m
.31895 .23281 L
s
.31902 .23398 m
.31902 .23398 L
s
.3191 .23422 m
.3191 .23422 L
s
.31917 .23516 m
.31917 .23516 L
s
.31925 .23586 m
.31925 .23586 L
s
.31932 .22693 m
.31932 .22693 L
s
.3194 .22975 m
.3194 .22975 L
s
.31948 .23633 m
.31948 .23633 L
s
.31955 .23351 m
.31955 .23351 L
s
.31962 .23609 m
.31962 .23609 L
s
.31969 .23045 m
.31969 .23045 L
s
.31977 .22928 m
.31977 .22928 L
s
.31984 .23022 m
.31984 .23022 L
s
.31992 .23469 m
.31992 .23469 L
s
.31999 .22975 m
.31999 .22975 L
s
.32007 .23045 m
.32007 .23045 L
s
.32014 .23093 m
.32014 .23093 L
s
.32022 .22858 m
.32022 .22858 L
s
.32029 .22741 m
.32029 .22741 L
s
.32037 .22881 m
.32037 .22881 L
s
.32044 .22834 m
.32044 .22834 L
s
.32051 .23163 m
.32051 .23163 L
s
.32058 .22412 m
.32058 .22412 L
s
.32066 .22881 m
.32066 .22881 L
s
.32073 .22459 m
.32073 .22459 L
s
.32081 .21683 m
.32081 .21683 L
s
.32088 .21683 m
.32088 .21683 L
s
.32096 .22482 m
.32096 .22482 L
s
.32103 .23022 m
.32103 .23022 L
s
.32111 .22858 m
.32111 .22858 L
s
.32119 .23045 m
.32119 .23045 L
s
.32125 .22788 m
.32125 .22788 L
s
.32133 .23163 m
.32133 .23163 L
s
.3214 .23845 m
.3214 .23845 L
s
.32148 .2368 m
.32148 .2368 L
s
.32155 .2408 m
.32155 .2408 L
s
.32163 .24643 m
.32163 .24643 L
s
.3217 .2422 m
.3217 .2422 L
s
.32178 .23821 m
.32178 .23821 L
s
.32185 .23891 m
.32185 .23891 L
s
.32193 .2314 m
.32193 .2314 L
s
.322 .23868 m
.322 .23868 L
s
.32207 .23633 m
.32207 .23633 L
s
.32214 .23422 m
.32214 .23422 L
s
.32222 .23398 m
.32222 .23398 L
s
.32229 .23656 m
.32229 .23656 L
s
.32237 .23351 m
.32237 .23351 L
s
.32244 .24055 m
.32244 .24055 L
s
.32252 .24384 m
.32252 .24384 L
s
.32259 .24127 m
.32259 .24127 L
s
.32267 .2408 m
.32267 .2408 L
s
.32274 .23703 m
.32274 .23703 L
s
.32282 .23234 m
.32282 .23234 L
s
.32289 .22952 m
.32289 .22952 L
s
.32296 .22482 m
.32296 .22482 L
s
.32304 .23093 m
.32304 .23093 L
s
.32311 .22905 m
.32311 .22905 L
s
.32319 .23422 m
.32319 .23422 L
s
.32326 .23868 m
.32326 .23868 L
s
.32334 .23257 m
.32334 .23257 L
s
.32341 .22177 m
.32341 .22177 L
s
.32348 .21683 m
.32348 .21683 L
s
.32356 .21636 m
.32356 .21636 L
s
.32364 .21378 m
.32364 .21378 L
s
.3237 .21472 m
.3237 .21472 L
s
.32378 .21519 m
.32378 .21519 L
s
.32385 .21613 m
.32385 .21613 L
s
.32393 .21425 m
.32393 .21425 L
s
.324 .21542 m
.324 .21542 L
s
.32408 .2206 m
.32408 .2206 L
s
.32416 .21871 m
.32416 .21871 L
s
.32422 .21707 m
.32422 .21707 L
s
.3243 .21636 m
.3243 .21636 L
s
.32437 .20838 m
.32437 .20838 L
s
.32445 .21355 m
.32445 .21355 L
s
.32452 .21895 m
.32452 .21895 L
s
.3246 .21989 m
.3246 .21989 L
s
.32467 .21965 m
.32467 .21965 L
s
.32475 .22623 m
.32475 .22623 L
s
.32482 .22388 m
.32482 .22388 L
s
.3249 .22153 m
.3249 .22153 L
s
.32497 .22482 m
.32497 .22482 L
s
.32504 .22599 m
.32504 .22599 L
s
.32511 .23163 m
.32511 .23163 L
s
.32519 .23398 m
.32519 .23398 L
s
.32527 .23093 m
.32527 .23093 L
s
.32534 .22646 m
.32534 .22646 L
s
.32541 .22858 m
.32541 .22858 L
s
.32549 .23821 m
.32549 .23821 L
s
.32556 .23633 m
.32556 .23633 L
s
.32564 .23774 m
.32564 .23774 L
s
.32572 .23985 m
.32572 .23985 L
s
.32579 .24103 m
.32579 .24103 L
s
.32586 .23962 m
.32586 .23962 L
s
.32593 .24267 m
.32593 .24267 L
s
.32601 .24784 m
.32601 .24784 L
s
.32608 .25254 m
.32608 .25254 L
s
.32616 .25065 m
.32616 .25065 L
s
.32623 .25065 m
.32623 .25065 L
s
.32631 .25277 m
.32631 .25277 L
s
.32638 .25465 m
.32638 .25465 L
s
.32646 .25371 m
.32646 .25371 L
s
.32653 .25489 m
.32653 .25489 L
s
.32661 .25207 m
.32661 .25207 L
s
.32667 .25653 m
.32667 .25653 L
s
.32675 .26052 m
.32675 .26052 L
s
.32682 .25347 m
.32682 .25347 L
s
.3269 .25653 m
.3269 .25653 L
s
.32697 .25371 m
.32697 .25371 L
s
.32705 .25583 m
.32705 .25583 L
s
.32712 .2523 m
.32712 .2523 L
s
.3272 .25489 m
.3272 .25489 L
s
.32728 .25418 m
.32728 .25418 L
s
.32735 .25254 m
.32735 .25254 L
s
.32742 .25042 m
.32742 .25042 L
s
.32749 .24432 m
.32749 .24432 L
s
.32757 .24737 m
.32757 .24737 L
s
.32764 .2415 m
.32764 .2415 L
s
.32772 .23891 m
.32772 .23891 L
s
.32779 .2415 m
.32779 .2415 L
s
.32787 .25042 m
.32787 .25042 L
s
.32794 .24314 m
.32794 .24314 L
s
.32802 .24502 m
.32802 .24502 L
s
.32809 .2408 m
.32809 .2408 L
s
.32817 .25137 m
.32817 .25137 L
s
.32824 .25113 m
.32824 .25113 L
s
.32831 .2509 m
.32831 .2509 L
s
.32838 .25254 m
.32838 .25254 L
s
.32846 .25065 m
.32846 .25065 L
s
.32853 .2516 m
.32853 .2516 L
s
.32861 .24761 m
.32861 .24761 L
s
.32868 .25065 m
.32868 .25065 L
s
.32876 .25676 m
.32876 .25676 L
s
.32884 .26311 m
.32884 .26311 L
s
.32891 .25771 m
.32891 .25771 L
s
.32899 .26099 m
.32899 .26099 L
s
.32905 .26357 m
.32905 .26357 L
s
.32913 .25865 m
.32913 .25865 L
s
.3292 .26123 m
.3292 .26123 L
s
.32928 .2671 m
.32928 .2671 L
s
.32935 .26639 m
.32935 .26639 L
s
.32943 .26522 m
.32943 .26522 L
s
.3295 .26381 m
.3295 .26381 L
s
.32958 .26381 m
.32958 .26381 L
s
.32965 .26052 m
.32965 .26052 L
s
.32973 .26475 m
.32973 .26475 L
s
.3298 .26499 m
.3298 .26499 L
s
.32987 .26804 m
.32987 .26804 L
s
.32994 .26804 m
.32994 .26804 L
s
.33002 .26546 m
.33002 .26546 L
s
.33009 .2671 m
.33009 .2671 L
s
.33017 .26264 m
.33017 .26264 L
s
.33024 .26123 m
.33024 .26123 L
s
.33032 .25958 m
.33032 .25958 L
s
.33039 .25771 m
.33039 .25771 L
s
.33047 .25606 m
.33047 .25606 L
s
.33055 .25394 m
.33055 .25394 L
s
.33062 .25254 m
.33062 .25254 L
s
.33069 .25019 m
.33069 .25019 L
s
.33076 .24808 m
.33076 .24808 L
s
.33084 .24855 m
.33084 .24855 L
s
.33091 .24713 m
.33091 .24713 L
s
.33099 .24761 m
.33099 .24761 L
s
.33106 .24314 m
.33106 .24314 L
s
.33114 .23915 m
.33114 .23915 L
s
.33121 .24103 m
.33121 .24103 L
s
.33128 .23798 m
.33128 .23798 L
s
.33136 .24244 m
.33136 .24244 L
s
.33144 .24314 m
.33144 .24314 L
s
.3315 .24878 m
.3315 .24878 L
s
.33158 .24479 m
.33158 .24479 L
s
.33165 .24596 m
.33165 .24596 L
s
.33173 .24408 m
.33173 .24408 L
s
.3318 .24713 m
.3318 .24713 L
s
.33188 .24032 m
.33188 .24032 L
s
.33196 .23445 m
.33196 .23445 L
s
.33202 .23798 m
.33202 .23798 L
s
.3321 .23915 m
.3321 .23915 L
s
.33218 .23445 m
.33218 .23445 L
s
.33225 .22905 m
.33225 .22905 L
s
.33232 .23751 m
.33232 .23751 L
s
.3324 .23703 m
.3324 .23703 L
s
.33247 .2321 m
.33247 .2321 L
s
.33255 .23398 m
.33255 .23398 L
s
.33262 .23539 m
.33262 .23539 L
s
.3327 .23374 m
.3327 .23374 L
s
.33277 .23656 m
.33277 .23656 L
s
.33284 .23985 m
.33284 .23985 L
s
.33291 .24197 m
.33291 .24197 L
s
.33299 .24573 m
.33299 .24573 L
s
.33307 .2422 m
.33307 .2422 L
s
.33314 .24808 m
.33314 .24808 L
s
.33321 .24855 m
.33321 .24855 L
s
.33329 .24713 m
.33329 .24713 L
s
.33336 .24925 m
.33336 .24925 L
s
.33344 .25606 m
.33344 .25606 L
s
.33352 .257 m
.33352 .257 L
s
.33359 .25207 m
.33359 .25207 L
s
.33366 .24878 m
.33366 .24878 L
s
.33373 .25019 m
.33373 .25019 L
s
.33381 .25629 m
.33381 .25629 L
s
.33388 .26452 m
.33388 .26452 L
s
.33396 .26311 m
.33396 .26311 L
s
.33403 .25818 m
.33403 .25818 L
s
.33411 .26075 m
.33411 .26075 L
s
.33418 .25771 m
.33418 .25771 L
s
.33426 .25818 m
.33426 .25818 L
s
.33433 .26217 m
.33433 .26217 L
s
.33441 .25935 m
.33441 .25935 L
s
.33447 .26193 m
.33447 .26193 L
s
.33455 .26357 m
.33455 .26357 L
s
.33462 .26733 m
.33462 .26733 L
s
.3347 .26945 m
.3347 .26945 L
s
.33477 .27344 m
.33477 .27344 L
s
.33485 .27626 m
.33485 .27626 L
s
.33492 .27461 m
.33492 .27461 L
s
.335 .27861 m
.335 .27861 L
s
.33508 .27885 m
.33508 .27885 L
s
.33515 .27673 m
.33515 .27673 L
s
.33522 .28119 m
.33522 .28119 L
s
.33529 .28706 m
.33529 .28706 L
s
.33537 .2873 m
.33537 .2873 L
s
.33544 .29059 m
.33544 .29059 L
s
.33552 .28331 m
.33552 .28331 L
s
.33559 .29152 m
.33559 .29152 L
s
.33567 .292 m
.33567 .292 L
s
.33574 .28941 m
.33574 .28941 L
s
.33582 .28988 m
.33582 .28988 L
s
.33589 .29012 m
.33589 .29012 L
s
.33597 .29434 m
.33597 .29434 L
s
.33604 .29152 m
.33604 .29152 L
s
.33611 .29434 m
.33611 .29434 L
s
.33618 .29458 m
.33618 .29458 L
s
.33626 .29035 m
.33626 .29035 L
s
.33633 .29059 m
.33633 .29059 L
s
.33641 .288 m
.33641 .288 L
s
.33648 .28918 m
.33648 .28918 L
s
.33656 .292 m
.33656 .292 L
s
.33664 .28895 m
.33664 .28895 L
s
.33671 .28706 m
.33671 .28706 L
s
.33679 .28871 m
.33679 .28871 L
s
.33685 .29294 m
.33685 .29294 L
s
.33693 .29317 m
.33693 .29317 L
s
.337 .29975 m
.337 .29975 L
s
.33708 .29834 m
.33708 .29834 L
s
.33715 .2974 m
.33715 .2974 L
s
.33723 .3021 m
.33723 .3021 L
s
.3373 .30092 m
.3373 .30092 L
s
.33738 .29505 m
.33738 .29505 L
s
.33745 .29646 m
.33745 .29646 L
s
.33753 .29434 m
.33753 .29434 L
s
.3376 .28683 m
.3376 .28683 L
s
.33767 .29059 m
.33767 .29059 L
s
.33774 .28706 m
.33774 .28706 L
s
.33782 .28706 m
.33782 .28706 L
s
.33789 .2873 m
.33789 .2873 L
s
.33797 .28848 m
.33797 .28848 L
s
.33804 .29481 m
.33804 .29481 L
s
.33812 .29434 m
.33812 .29434 L
s
.33819 .29881 m
.33819 .29881 L
s
.33827 .30187 m
.33827 .30187 L
s
.33835 .30398 m
.33835 .30398 L
s
.33842 .2967 m
.33842 .2967 L
s
.33849 .29152 m
.33849 .29152 L
s
.33856 .28895 m
.33856 .28895 L
s
.33864 .28659 m
.33864 .28659 L
s
.33871 .28941 m
.33871 .28941 L
s
.33879 .29247 m
.33879 .29247 L
s
.33886 .29035 m
.33886 .29035 L
s
.33894 .29224 m
.33894 .29224 L
s
.33901 .29224 m
.33901 .29224 L
s
.33909 .29505 m
.33909 .29505 L
s
.33916 .29364 m
.33916 .29364 L
s
.33924 .29106 m
.33924 .29106 L
s
.3393 .28918 m
.3393 .28918 L
s
.33938 .29552 m
.33938 .29552 L
s
.33945 .30069 m
.33945 .30069 L
s
.33953 .30421 m
.33953 .30421 L
s
.3396 .30304 m
.3396 .30304 L
s
.33968 .30539 m
.33968 .30539 L
s
.33976 .31126 m
.33976 .31126 L
s
.33982 .31384 m
.33982 .31384 L
s
.3399 .31149 m
.3399 .31149 L
s
.33998 .31337 m
.33998 .31337 L
s
.34005 .30844 m
.34005 .30844 L
s
.34012 .30069 m
.34012 .30069 L
s
.3402 .30868 m
.3402 .30868 L
s
.34027 .30891 m
.34027 .30891 L
s
.34035 .30069 m
.34035 .30069 L
s
.34042 .30304 m
.34042 .30304 L
s
.3405 .30726 m
.3405 .30726 L
s
.34057 .30633 m
.34057 .30633 L
s
.34064 .30468 m
.34064 .30468 L
s
.34072 .3068 m
.34072 .3068 L
s
.3408 .30515 m
.3408 .30515 L
s
.34087 .30351 m
.34087 .30351 L
s
.34094 .31055 m
.34094 .31055 L
s
.34101 .31361 m
.34101 .31361 L
s
.34109 .3169 m
.34109 .3169 L
s
.34116 .31666 m
.34116 .31666 L
s
.34124 .3183 m
.34124 .3183 L
s
.34132 .31948 m
.34132 .31948 L
s
.34139 .31572 m
.34139 .31572 L
s
.34146 .31149 m
.34146 .31149 L
s
.34153 .31619 m
.34153 .31619 L
s
.34161 .31008 m
.34161 .31008 L
s
.34168 .30962 m
.34168 .30962 L
s
.34176 .31008 m
.34176 .31008 L
s
.34183 .30773 m
.34183 .30773 L
s
.34191 .30398 m
.34191 .30398 L
s
.34198 .30351 m
.34198 .30351 L
s
.34206 .30351 m
.34206 .30351 L
s
.34213 .30491 m
.34213 .30491 L
s
.34221 .3075 m
.34221 .3075 L
s
.34227 .30938 m
.34227 .30938 L
s
.34235 .30022 m
.34235 .30022 L
s
.34243 .30022 m
.34243 .30022 L
s
.3425 .29787 m
.3425 .29787 L
s
.34257 .29364 m
.34257 .29364 L
s
.34265 .28636 m
.34265 .28636 L
s
.34272 .28566 m
.34272 .28566 L
s
.3428 .29716 m
.3428 .29716 L
s
.34288 .30116 m
.34288 .30116 L
s
.34295 .30162 m
.34295 .30162 L
s
.34302 .30327 m
.34302 .30327 L
s
.34309 .3122 m
.34309 .3122 L
s
.34317 .31948 m
.34317 .31948 L
s
.34324 .32042 m
.34324 .32042 L
s
.34332 .3129 m
.34332 .3129 L
s
.34339 .31619 m
.34339 .31619 L
s
.34347 .31854 m
.34347 .31854 L
s
.34354 .31736 m
.34354 .31736 L
s
.34362 .31196 m
.34362 .31196 L
s
.34369 .31807 m
.34369 .31807 L
s
.34377 .30797 m
.34377 .30797 L
s
.34384 .30962 m
.34384 .30962 L
s
.34391 .30962 m
.34391 .30962 L
s
.34398 .31384 m
.34398 .31384 L
s
.34406 .31525 m
.34406 .31525 L
s
.34413 .31478 m
.34413 .31478 L
s
.34421 .31055 m
.34421 .31055 L
s
.34428 .31643 m
.34428 .31643 L
s
.34436 .3169 m
.34436 .3169 L
s
.34444 .31995 m
.34444 .31995 L
s
.34451 .32042 m
.34451 .32042 L
s
.34459 .32371 m
.34459 .32371 L
s
.34465 .31572 m
.34465 .31572 L
s
.34473 .31478 m
.34473 .31478 L
s
.3448 .31244 m
.3448 .31244 L
s
.34488 .30938 m
.34488 .30938 L
s
.34495 .30773 m
.34495 .30773 L
s
.34503 .30327 m
.34503 .30327 L
s
.3451 .30915 m
.3451 .30915 L
s
.34518 .30656 m
.34518 .30656 L
s
.34525 .30938 m
.34525 .30938 L
s
.34533 .30868 m
.34533 .30868 L
s
.3454 .30962 m
.3454 .30962 L
s
.34547 .30797 m
.34547 .30797 L
s
.34554 .31525 m
.34554 .31525 L
s
.34562 .31408 m
.34562 .31408 L
s
.34569 .31454 m
.34569 .31454 L
s
.34577 .31102 m
.34577 .31102 L
s
.34584 .31314 m
.34584 .31314 L
s
.34592 .30844 m
.34592 .30844 L
s
.346 .30421 m
.346 .30421 L
s
.34607 .30586 m
.34607 .30586 L
s
.34615 .30398 m
.34615 .30398 L
s
.34622 .30398 m
.34622 .30398 L
s
.34629 .30139 m
.34629 .30139 L
s
.34636 .29458 m
.34636 .29458 L
s
.34644 .29481 m
.34644 .29481 L
s
.34651 .29905 m
.34651 .29905 L
s
.34659 .29716 m
.34659 .29716 L
s
.34666 .28871 m
.34666 .28871 L
s
.34674 .29106 m
.34674 .29106 L
s
.34681 .29434 m
.34681 .29434 L
s
.34689 .28495 m
.34689 .28495 L
s
.34696 .28401 m
.34696 .28401 L
s
.34704 .2819 m
.34704 .2819 L
s
.3471 .28354 m
.3471 .28354 L
s
.34718 .28307 m
.34718 .28307 L
s
.34725 .28213 m
.34725 .28213 L
s
.34733 .28519 m
.34733 .28519 L
s
.3474 .28237 m
.3474 .28237 L
s
.34748 .27838 m
.34748 .27838 L
s
.34756 .27814 m
.34756 .27814 L
s
.34763 .28237 m
.34763 .28237 L
s
.34771 .28566 m
.34771 .28566 L
s
.34778 .28448 m
.34778 .28448 L
s
.34785 .28401 m
.34785 .28401 L
s
.34792 .28683 m
.34792 .28683 L
s
.348 .28613 m
.348 .28613 L
s
.34807 .29411 m
.34807 .29411 L
s
.34815 .29646 m
.34815 .29646 L
s
.34822 .29505 m
.34822 .29505 L
s
.3483 .29576 m
.3483 .29576 L
s
.34837 .29458 m
.34837 .29458 L
s
.34844 .30162 m
.34844 .30162 L
s
.34852 .30398 m
.34852 .30398 L
s
.3486 .30374 m
.3486 .30374 L
s
.34867 .29928 m
.34867 .29928 L
s
.34874 .29434 m
.34874 .29434 L
s
.34881 .29552 m
.34881 .29552 L
s
.34889 .2927 m
.34889 .2927 L
s
.34896 .28988 m
.34896 .28988 L
s
.34904 .28753 m
.34904 .28753 L
s
.34912 .3028 m
.34912 .3028 L
s
.34919 .30985 m
.34919 .30985 L
s
.34926 .30891 m
.34926 .30891 L
s
.34934 .30304 m
.34934 .30304 L
s
.34942 .30092 m
.34942 .30092 L
s
.34948 .30491 m
.34948 .30491 L
s
.34956 .30187 m
.34956 .30187 L
s
.34963 .2981 m
.34963 .2981 L
s
.34971 .29623 m
.34971 .29623 L
s
.34978 .29905 m
.34978 .29905 L
s
.34986 .29998 m
.34986 .29998 L
s
.34993 .29529 m
.34993 .29529 L
s
.35001 .29693 m
.35001 .29693 L
s
.35007 .29388 m
.35007 .29388 L
s
.35015 .29364 m
.35015 .29364 L
s
.35023 .29082 m
.35023 .29082 L
s
.3503 .29552 m
.3503 .29552 L
s
.35037 .30116 m
.35037 .30116 L
s
.35045 .2974 m
.35045 .2974 L
s
.35052 .29505 m
.35052 .29505 L
s
.3506 .2981 m
.3506 .2981 L
s
.35068 .28941 m
.35068 .28941 L
s
.35075 .28659 m
.35075 .28659 L
s
.35082 .29152 m
.35082 .29152 L
s
.35089 .288 m
.35089 .288 L
s
.35097 .27743 m
.35097 .27743 L
s
.35105 .28895 m
.35105 .28895 L
s
.35112 .28424 m
.35112 .28424 L
s
.35119 .28706 m
.35119 .28706 L
s
.35127 .28636 m
.35127 .28636 L
s
.35134 .28495 m
.35134 .28495 L
s
.35142 .28378 m
.35142 .28378 L
s
.35149 .28613 m
.35149 .28613 L
s
.35157 .28824 m
.35157 .28824 L
s
.35164 .29294 m
.35164 .29294 L
s
.35171 .28965 m
.35171 .28965 L
s
.35178 .28378 m
.35178 .28378 L
s
.35186 .28167 m
.35186 .28167 L
s
.35193 .27603 m
.35193 .27603 L
s
.35201 .27814 m
.35201 .27814 L
s
.35208 .27861 m
.35208 .27861 L
s
.35216 .27509 m
.35216 .27509 L
s
.35224 .27579 m
.35224 .27579 L
s
.35231 .27673 m
.35231 .27673 L
s
.35239 .27414 m
.35239 .27414 L
s
.35245 .2779 m
.35245 .2779 L
s
.35253 .27767 m
.35253 .27767 L
s
.3526 .27603 m
.3526 .27603 L
s
.35268 .2678 m
.35268 .2678 L
s
.35275 .2678 m
.35275 .2678 L
s
.35283 .26616 m
.35283 .26616 L
s
.3529 .26334 m
.3529 .26334 L
s
.35298 .2624 m
.35298 .2624 L
s
.35305 .25606 m
.35305 .25606 L
s
.35313 .2523 m
.35313 .2523 L
s
.3532 .25489 m
.3532 .25489 L
s
.35327 .26029 m
.35327 .26029 L
s
.35334 .25371 m
.35334 .25371 L
s
.35342 .25277 m
.35342 .25277 L
s
.35349 .25277 m
.35349 .25277 L
s
.35357 .25137 m
.35357 .25137 L
s
.35364 .25301 m
.35364 .25301 L
s
.35372 .25818 m
.35372 .25818 L
s
.3538 .25888 m
.3538 .25888 L
s
.35387 .26123 m
.35387 .26123 L
s
.35395 .26099 m
.35395 .26099 L
s
.35402 .26804 m
.35402 .26804 L
s
.35409 .27109 m
.35409 .27109 L
s
.35416 .26851 m
.35416 .26851 L
s
.35424 .26921 m
.35424 .26921 L
s
.35431 .26945 m
.35431 .26945 L
s
.35439 .26569 m
.35439 .26569 L
s
.35446 .27673 m
.35446 .27673 L
s
.35454 .27978 m
.35454 .27978 L
s
.35461 .28401 m
.35461 .28401 L
s
.35469 .28378 m
.35469 .28378 L
s
.35476 .28683 m
.35476 .28683 L
s
.35484 .28566 m
.35484 .28566 L
s
.3549 .28613 m
.3549 .28613 L
s
.35498 .27767 m
.35498 .27767 L
s
.35505 .2819 m
.35505 .2819 L
s
.35513 .28683 m
.35513 .28683 L
s
.3552 .27743 m
.3552 .27743 L
s
.35528 .2725 m
.35528 .2725 L
s
.35536 .27133 m
.35536 .27133 L
s
.35543 .26921 m
.35543 .26921 L
s
.35551 .27673 m
.35551 .27673 L
s
.35558 .27509 m
.35558 .27509 L
s
.35565 .27157 m
.35565 .27157 L
s
.35572 .2718 m
.35572 .2718 L
s
.3558 .27297 m
.3558 .27297 L
s
.35587 .27203 m
.35587 .27203 L
s
.35595 .27908 m
.35595 .27908 L
s
.35602 .28049 m
.35602 .28049 L
s
.3561 .27414 m
.3561 .27414 L
s
.35617 .27978 m
.35617 .27978 L
s
.35625 .27767 m
.35625 .27767 L
s
.35632 .27321 m
.35632 .27321 L
s
.3564 .28002 m
.3564 .28002 L
s
.35647 .27814 m
.35647 .27814 L
s
.35654 .27391 m
.35654 .27391 L
s
.35661 .27509 m
.35661 .27509 L
s
.35669 .2772 m
.35669 .2772 L
s
.35676 .28002 m
.35676 .28002 L
s
.35684 .27649 m
.35684 .27649 L
s
.35692 .26757 m
.35692 .26757 L
s
.35699 .27368 m
.35699 .27368 L
s
.35706 .27509 m
.35706 .27509 L
s
.35714 .27556 m
.35714 .27556 L
s
.35722 .27015 m
.35722 .27015 L
s
.35729 .27109 m
.35729 .27109 L
s
.35736 .26733 m
.35736 .26733 L
s
.35743 .26945 m
.35743 .26945 L
s
.35751 .26639 m
.35751 .26639 L
s
.35758 .27062 m
.35758 .27062 L
s
.35766 .27274 m
.35766 .27274 L
s
.35773 .27227 m
.35773 .27227 L
s
.35781 .26851 m
.35781 .26851 L
s
.35788 .27344 m
.35788 .27344 L
s
.35796 .28049 m
.35796 .28049 L
s
.35803 .28378 m
.35803 .28378 L
s
.3581 .28049 m
.3581 .28049 L
s
.35817 .28753 m
.35817 .28753 L
s
.35825 .28448 m
.35825 .28448 L
s
.35832 .27978 m
.35832 .27978 L
s
.3584 .28401 m
.3584 .28401 L
s
.35848 .28659 m
.35848 .28659 L
s
.35855 .28378 m
.35855 .28378 L
s
.35862 .28471 m
.35862 .28471 L
s
.35869 .28495 m
.35869 .28495 L
s
.35877 .27885 m
.35877 .27885 L
s
.35885 .2819 m
.35885 .2819 L
s
.35892 .28519 m
.35892 .28519 L
s
.35899 .28941 m
.35899 .28941 L
s
.35907 .29152 m
.35907 .29152 L
s
.35914 .29552 m
.35914 .29552 L
s
.35922 .29481 m
.35922 .29481 L
s
.35929 .29858 m
.35929 .29858 L
s
.35937 .30257 m
.35937 .30257 L
s
.35944 .30116 m
.35944 .30116 L
s
.35951 .30257 m
.35951 .30257 L
s
.35959 .30187 m
.35959 .30187 L
s
.35967 .30444 m
.35967 .30444 L
s
.35973 .30327 m
.35973 .30327 L
s
.35981 .29834 m
.35981 .29834 L
s
.35988 .2974 m
.35988 .2974 L
s
.35996 .2981 m
.35996 .2981 L
s
.36004 .29998 m
.36004 .29998 L
s
.36011 .29858 m
.36011 .29858 L
s
.36019 .30562 m
.36019 .30562 L
s
.36026 .30468 m
.36026 .30468 L
s
.36033 .29693 m
.36033 .29693 L
s
.3604 .29763 m
.3604 .29763 L
s
.36048 .30351 m
.36048 .30351 L
s
.36055 .30327 m
.36055 .30327 L
s
.36063 .29458 m
.36063 .29458 L
s
.3607 .30069 m
.3607 .30069 L
s
.36078 .29834 m
.36078 .29834 L
s
.36085 .29975 m
.36085 .29975 L
s
.36093 .30234 m
.36093 .30234 L
s
.361 .30116 m
.361 .30116 L
s
.36107 .30045 m
.36107 .30045 L
s
.36114 .30609 m
.36114 .30609 L
s
.36122 .30797 m
.36122 .30797 L
s
.3613 .30891 m
.3613 .30891 L
s
.36137 .3075 m
.36137 .3075 L
s
.36144 .3122 m
.36144 .3122 L
s
.36152 .31149 m
.36152 .31149 L
s
.3616 .3176 m
.3616 .3176 L
s
.36167 .32112 m
.36167 .32112 L
s
.36175 .31925 m
.36175 .31925 L
s
.36182 .32254 m
.36182 .32254 L
s
.36189 .327 m
.36189 .327 L
s
.36196 .32582 m
.36196 .32582 L
s
.36204 .32864 m
.36204 .32864 L
s
.36211 .32347 m
.36211 .32347 L
s
.36219 .31948 m
.36219 .31948 L
s
.36226 .3129 m
.36226 .3129 L
s
.36234 .32089 m
.36234 .32089 L
s
.36241 .3183 m
.36241 .3183 L
s
.36249 .31736 m
.36249 .31736 L
s
.36256 .31337 m
.36256 .31337 L
s
.36264 .31172 m
.36264 .31172 L
s
.3627 .31854 m
.3627 .31854 L
s
.36278 .32488 m
.36278 .32488 L
s
.36285 .32324 m
.36285 .32324 L
s
.36293 .3223 m
.36293 .3223 L
s
.363 .31972 m
.363 .31972 L
s
.36308 .31807 m
.36308 .31807 L
s
.36316 .31807 m
.36316 .31807 L
s
.36323 .32136 m
.36323 .32136 L
s
.36331 .32511 m
.36331 .32511 L
s
.36338 .32464 m
.36338 .32464 L
s
.36345 .32606 m
.36345 .32606 L
s
.36352 .323 m
.36352 .323 L
s
.3636 .32464 m
.3636 .32464 L
s
.36367 .32746 m
.36367 .32746 L
s
.36375 .32418 m
.36375 .32418 L
s
.36382 .32676 m
.36382 .32676 L
s
.3639 .32558 m
.3639 .32558 L
s
.36397 .33005 m
.36397 .33005 L
s
.36405 .33264 m
.36405 .33264 L
s
.36412 .33968 m
.36412 .33968 L
s
.3642 .33428 m
.3642 .33428 L
s
.36427 .33874 m
.36427 .33874 L
s
.36434 .3324 m
.36434 .3324 L
s
.36441 .33146 m
.36441 .33146 L
s
.36449 .32958 m
.36449 .32958 L
s
.36456 .33192 m
.36456 .33192 L
s
.36464 .33592 m
.36464 .33592 L
s
.36472 .33498 m
.36472 .33498 L
s
.36479 .33451 m
.36479 .33451 L
s
.36487 .33287 m
.36487 .33287 L
s
.36494 .33075 m
.36494 .33075 L
s
.36502 .33099 m
.36502 .33099 L
s
.36509 .33428 m
.36509 .33428 L
s
.36516 .33122 m
.36516 .33122 L
s
.36523 .33639 m
.36523 .33639 L
s
.36531 .33827 m
.36531 .33827 L
s
.36538 .3385 m
.36538 .3385 L
s
.36546 .33428 m
.36546 .33428 L
s
.36553 .33451 m
.36553 .33451 L
s
.36561 .33803 m
.36561 .33803 L
s
.36568 .34062 m
.36568 .34062 L
s
.36576 .34179 m
.36576 .34179 L
s
.36583 .34062 m
.36583 .34062 L
s
.3659 .34109 m
.3659 .34109 L
s
.36597 .34438 m
.36597 .34438 L
s
.36605 .3432 m
.36605 .3432 L
s
.36612 .34531 m
.36612 .34531 L
s
.3662 .34649 m
.3662 .34649 L
s
.36628 .35683 m
.36628 .35683 L
s
.36635 .35847 m
.36635 .35847 L
s
.36642 .35588 m
.36642 .35588 L
s
.3665 .3573 m
.3665 .3573 L
s
.36658 .35965 m
.36658 .35965 L
s
.36665 .36387 m
.36665 .36387 L
s
.36672 .36528 m
.36672 .36528 L
s
.36679 .36763 m
.36679 .36763 L
s
.36687 .37233 m
.36687 .37233 L
s
.36694 .37303 m
.36694 .37303 L
s
.36702 .3681 m
.36702 .3681 L
s
.36709 .37209 m
.36709 .37209 L
s
.36717 .37045 m
.36717 .37045 L
s
.36724 .37444 m
.36724 .37444 L
s
.36731 .37186 m
.36731 .37186 L
s
.36739 .37139 m
.36739 .37139 L
s
.36747 .36387 m
.36747 .36387 L
s
.36753 .36434 m
.36753 .36434 L
s
.36761 .35541 m
.36761 .35541 L
s
.36768 .35777 m
.36768 .35777 L
s
.36776 .35894 m
.36776 .35894 L
s
.36784 .36105 m
.36784 .36105 L
s
.36791 .36293 m
.36791 .36293 L
s
.36799 .36293 m
.36799 .36293 L
s
.36806 .36458 m
.36806 .36458 L
s
.36813 .36646 m
.36813 .36646 L
s
.36821 .36059 m
.36821 .36059 L
s
.36828 .35612 m
.36828 .35612 L
s
.36835 .35941 m
.36835 .35941 L
s
.36843 .36035 m
.36843 .36035 L
s
.3685 .36176 m
.3685 .36176 L
s
.36858 .36669 m
.36858 .36669 L
s
.36865 .35988 m
.36865 .35988 L
s
.36873 .36341 m
.36873 .36341 L
s
.3688 .36317 m
.3688 .36317 L
s
.36887 .36364 m
.36887 .36364 L
s
.36894 .36669 m
.36894 .36669 L
s
.36902 .36716 m
.36902 .36716 L
s
.3691 .36411 m
.3691 .36411 L
s
.36917 .36293 m
.36917 .36293 L
s
.36924 .37022 m
.36924 .37022 L
s
.36932 .36458 m
.36932 .36458 L
s
.3694 .36622 m
.3694 .36622 L
s
.36947 .37303 m
.36947 .37303 L
s
.36955 .38079 m
.36955 .38079 L
s
.36962 .38149 m
.36962 .38149 L
s
.36969 .37984 m
.36969 .37984 L
s
.36976 .37656 m
.36976 .37656 L
s
.36984 .37656 m
.36984 .37656 L
s
.36992 .37937 m
.36992 .37937 L
s
.36999 .38149 m
.36999 .38149 L
s
.37006 .38289 m
.37006 .38289 L
s
.37014 .37961 m
.37014 .37961 L
s
.37021 .37773 m
.37021 .37773 L
s
.37029 .37397 m
.37029 .37397 L
s
.37036 .37303 m
.37036 .37303 L
s
.37044 .37961 m
.37044 .37961 L
s
.3705 .37984 m
.3705 .37984 L
s
.37058 .37585 m
.37058 .37585 L
s
.37065 .37632 m
.37065 .37632 L
s
.37073 .36833 m
.37073 .36833 L
s
.3708 .37303 m
.3708 .37303 L
s
.37088 .37022 m
.37088 .37022 L
s
.37096 .36974 m
.37096 .36974 L
s
.37103 .37045 m
.37103 .37045 L
s
.37111 .37538 m
.37111 .37538 L
s
.37118 .38361 m
.37118 .38361 L
s
.37125 .38478 m
.37125 .38478 L
s
.37132 .38525 m
.37132 .38525 L
s
.3714 .38172 m
.3714 .38172 L
s
.37147 .37984 m
.37147 .37984 L
s
.37155 .38079 m
.37155 .38079 L
s
.37162 .38149 m
.37162 .38149 L
s
.3717 .38289 m
.3717 .38289 L
s
.37177 .38243 m
.37177 .38243 L
s
.37185 .37351 m
.37185 .37351 L
s
.37192 .36693 m
.37192 .36693 L
s
.372 .36951 m
.372 .36951 L
s
.37207 .36833 m
.37207 .36833 L
s
.37214 .37585 m
.37214 .37585 L
s
.37221 .37843 m
.37221 .37843 L
s
.37229 .37585 m
.37229 .37585 L
s
.37236 .37256 m
.37236 .37256 L
s
.37244 .36458 m
.37244 .36458 L
s
.37252 .3688 m
.37252 .3688 L
s
.37259 .36293 m
.37259 .36293 L
s
.37267 .35988 m
.37267 .35988 L
s
.37274 .35284 m
.37274 .35284 L
s
.37282 .34673 m
.37282 .34673 L
s
.37289 .35307 m
.37289 .35307 L
s
.37296 .35259 m
.37296 .35259 L
s
.37303 .35095 m
.37303 .35095 L
s
.37311 .35002 m
.37311 .35002 L
s
.37318 .3472 m
.37318 .3472 L
s
.37326 .34531 m
.37326 .34531 L
s
.37333 .34297 m
.37333 .34297 L
s
.37341 .34274 m
.37341 .34274 L
s
.37348 .34367 m
.37348 .34367 L
s
.37356 .34391 m
.37356 .34391 L
s
.37363 .33874 m
.37363 .33874 L
s
.3737 .3371 m
.3737 .3371 L
s
.37377 .33616 m
.37377 .33616 L
s
.37385 .33639 m
.37385 .33639 L
s
.37392 .33334 m
.37392 .33334 L
s
.374 .33451 m
.374 .33451 L
s
.37408 .33545 m
.37408 .33545 L
s
.37415 .33733 m
.37415 .33733 L
s
.37422 .34414 m
.37422 .34414 L
s
.3743 .34461 m
.3743 .34461 L
s
.37438 .34038 m
.37438 .34038 L
s
.37445 .34766 m
.37445 .34766 L
s
.37452 .35142 m
.37452 .35142 L
s
.37459 .35495 m
.37459 .35495 L
s
.37467 .35683 m
.37467 .35683 L
s
.37474 .35518 m
.37474 .35518 L
s
.37482 .35565 m
.37482 .35565 L
s
.37489 .35213 m
.37489 .35213 L
s
.37497 .35331 m
.37497 .35331 L
s
.37504 .3472 m
.37504 .3472 L
s
.37512 .34344 m
.37512 .34344 L
s
.37519 .34555 m
.37519 .34555 L
s
.37527 .35236 m
.37527 .35236 L
s
.37533 .35424 m
.37533 .35424 L
s
.37541 .35189 m
.37541 .35189 L
s
.37548 .34813 m
.37548 .34813 L
s
.37556 .3486 m
.37556 .3486 L
s
.37564 .35307 m
.37564 .35307 L
s
.37571 .35307 m
.37571 .35307 L
s
.37579 .35448 m
.37579 .35448 L
s
.37586 .35448 m
.37586 .35448 L
s
.37593 .35565 m
.37593 .35565 L
s
.37601 .35002 m
.37601 .35002 L
s
.37608 .3479 m
.37608 .3479 L
s
.37615 .34555 m
.37615 .34555 L
s
.37623 .34602 m
.37623 .34602 L
s
.3763 .34555 m
.3763 .34555 L
s
.37638 .34367 m
.37638 .34367 L
s
.37645 .34203 m
.37645 .34203 L
s
.37653 .34109 m
.37653 .34109 L
s
.3766 .33921 m
.3766 .33921 L
s
.37667 .33592 m
.37667 .33592 L
s
.37675 .34038 m
.37675 .34038 L
s
.37683 .34391 m
.37683 .34391 L
s
.3769 .34884 m
.3769 .34884 L
s
.37697 .34602 m
.37697 .34602 L
s
.37704 .3479 m
.37704 .3479 L
s
.37712 .35119 m
.37712 .35119 L
s
.3772 .35823 m
.3772 .35823 L
s
.37727 .35424 m
.37727 .35424 L
s
.37735 .35213 m
.37735 .35213 L
s
.37742 .35189 m
.37742 .35189 L
s
.37749 .3486 m
.37749 .3486 L
s
.37756 .3472 m
.37756 .3472 L
s
.37764 .35541 m
.37764 .35541 L
s
.37772 .35753 m
.37772 .35753 L
s
.37779 .35659 m
.37779 .35659 L
s
.37786 .35588 m
.37786 .35588 L
s
.37794 .36059 m
.37794 .36059 L
s
.37801 .36551 m
.37801 .36551 L
s
.37809 .36505 m
.37809 .36505 L
s
.37816 .36411 m
.37816 .36411 L
s
.37824 .35753 m
.37824 .35753 L
s
.3783 .36223 m
.3783 .36223 L
s
.37838 .36622 m
.37838 .36622 L
s
.37846 .36035 m
.37846 .36035 L
s
.37853 .36458 m
.37853 .36458 L
s
.3786 .36059 m
.3786 .36059 L
s
.37868 .35941 m
.37868 .35941 L
s
.37876 .36481 m
.37876 .36481 L
s
.37883 .36646 m
.37883 .36646 L
s
.37891 .36763 m
.37891 .36763 L
s
.37898 .36998 m
.37898 .36998 L
s
.37905 .37538 m
.37905 .37538 L
s
.37912 .37656 m
.37912 .37656 L
s
.3792 .38736 m
.3792 .38736 L
s
.37927 .38877 m
.37927 .38877 L
s
.37935 .39441 m
.37935 .39441 L
s
.37942 .39488 m
.37942 .39488 L
s
.3795 .39488 m
.3795 .39488 L
s
.37957 .39652 m
.37957 .39652 L
s
.37965 .40333 m
.37965 .40333 L
s
.37972 .39934 m
.37972 .39934 L
s
.3798 .40099 m
.3798 .40099 L
s
.37987 .39699 m
.37987 .39699 L
s
.37994 .39464 m
.37994 .39464 L
s
.38001 .39299 m
.38001 .39299 L
s
.38009 .38807 m
.38009 .38807 L
s
.38016 .3883 m
.38016 .3883 L
s
.38024 .38689 m
.38024 .38689 L
s
.38032 .39582 m
.38032 .39582 L
s
.38039 .39605 m
.38039 .39605 L
s
.38047 .3991 m
.38047 .3991 L
s
.38054 .40169 m
.38054 .40169 L
s
.38062 .40028 m
.38062 .40028 L
s
.38069 .39957 m
.38069 .39957 L
s
.38076 .39934 m
.38076 .39934 L
s
.38083 .39887 m
.38083 .39887 L
s
.38091 .39182 m
.38091 .39182 L
s
.38098 .39299 m
.38098 .39299 L
s
.38106 .38689 m
.38106 .38689 L
s
.38113 .38783 m
.38113 .38783 L
s
.38121 .38924 m
.38121 .38924 L
s
.38128 .39018 m
.38128 .39018 L
s
.38136 .38384 m
.38136 .38384 L
s
.38143 .38172 m
.38143 .38172 L
s
.3815 .38266 m
.3815 .38266 L
s
.38157 .38172 m
.38157 .38172 L
s
.38165 .37773 m
.38165 .37773 L
s
.38172 .37961 m
.38172 .37961 L
s
.3818 .38431 m
.3818 .38431 L
s
.38188 .38595 m
.38188 .38595 L
s
.38195 .39042 m
.38195 .39042 L
s
.38202 .39253 m
.38202 .39253 L
s
.3821 .39182 m
.3821 .39182 L
s
.38218 .39441 m
.38218 .39441 L
s
.38225 .39699 m
.38225 .39699 L
s
.38232 .40263 m
.38232 .40263 L
s
.38239 .40474 m
.38239 .40474 L
s
.38247 .39863 m
.38247 .39863 L
s
.38254 .39558 m
.38254 .39558 L
s
.38262 .3977 m
.38262 .3977 L
s
.38269 .40028 m
.38269 .40028 L
s
.38277 .4031 m
.38277 .4031 L
s
.38284 .40145 m
.38284 .40145 L
s
.38292 .39206 m
.38292 .39206 L
s
.38299 .39065 m
.38299 .39065 L
s
.38307 .38431 m
.38307 .38431 L
s
.38313 .38571 m
.38313 .38571 L
s
.38321 .38571 m
.38321 .38571 L
s
.38328 .38947 m
.38328 .38947 L
s
.38336 .39417 m
.38336 .39417 L
s
.38344 .39253 m
.38344 .39253 L
s
.38351 .39042 m
.38351 .39042 L
s
.38359 .38618 m
.38359 .38618 L
s
.38366 .38361 m
.38366 .38361 L
s
.38373 .38196 m
.38373 .38196 L
s
.38381 .37679 m
.38381 .37679 L
s
.38388 .37632 m
.38388 .37632 L
s
.38395 .38289 m
.38395 .38289 L
s
.38403 .37397 m
.38403 .37397 L
s
.3841 .37397 m
.3841 .37397 L
s
.38418 .36927 m
.38418 .36927 L
s
.38425 .37092 m
.38425 .37092 L
s
.38433 .37092 m
.38433 .37092 L
s
.3844 .36857 m
.3844 .36857 L
s
.38447 .36035 m
.38447 .36035 L
s
.38455 .36598 m
.38455 .36598 L
s
.38463 .36481 m
.38463 .36481 L
s
.3847 .36317 m
.3847 .36317 L
s
.38477 .3688 m
.38477 .3688 L
s
.38484 .37186 m
.38484 .37186 L
s
.38492 .37397 m
.38492 .37397 L
s
.385 .37115 m
.385 .37115 L
s
.38507 .37209 m
.38507 .37209 L
s
.38515 .37632 m
.38515 .37632 L
s
.38522 .37491 m
.38522 .37491 L
s
.38529 .37632 m
.38529 .37632 L
s
.38536 .37303 m
.38536 .37303 L
s
.38544 .37468 m
.38544 .37468 L
s
.38552 .37656 m
.38552 .37656 L
s
.38559 .37984 m
.38559 .37984 L
s
.38566 .38713 m
.38566 .38713 L
s
.38574 .39346 m
.38574 .39346 L
s
.38581 .38172 m
.38581 .38172 L
s
.38589 .38595 m
.38589 .38595 L
s
.38596 .39276 m
.38596 .39276 L
s
.38604 .39535 m
.38604 .39535 L
s
.3861 .39535 m
.3861 .39535 L
s
.38618 .39323 m
.38618 .39323 L
s
.38626 .39558 m
.38626 .39558 L
s
.38633 .39723 m
.38633 .39723 L
s
.3864 .39605 m
.3864 .39605 L
s
.38648 .39441 m
.38648 .39441 L
s
.38656 .39417 m
.38656 .39417 L
s
.38663 .39582 m
.38663 .39582 L
s
.38671 .40263 m
.38671 .40263 L
s
.38678 .39793 m
.38678 .39793 L
s
.38685 .3984 m
.38685 .3984 L
s
.38692 .3984 m
.38692 .3984 L
s
.387 .39981 m
.387 .39981 L
s
.38708 .39582 m
.38708 .39582 L
s
.38715 .39323 m
.38715 .39323 L
s
.38722 .39253 m
.38722 .39253 L
s
.3873 .39817 m
.3873 .39817 L
s
.38737 .39981 m
.38737 .39981 L
s
.38745 .39934 m
.38745 .39934 L
s
.38752 .39652 m
.38752 .39652 L
s
.3876 .39206 m
.3876 .39206 L
s
.38767 .38947 m
.38767 .38947 L
s
.38774 .39323 m
.38774 .39323 L
s
.38781 .39394 m
.38781 .39394 L
s
.38789 .38877 m
.38789 .38877 L
s
.38796 .39018 m
.38796 .39018 L
s
.38804 .39276 m
.38804 .39276 L
s
.38812 .39464 m
.38812 .39464 L
s
.38819 .38783 m
.38819 .38783 L
s
.38827 .39042 m
.38827 .39042 L
s
.38834 .39182 m
.38834 .39182 L
s
.38842 .38994 m
.38842 .38994 L
s
.38849 .38713 m
.38849 .38713 L
s
.38856 .38525 m
.38856 .38525 L
s
.38863 .38525 m
.38863 .38525 L
s
.38871 .37937 m
.38871 .37937 L
s
.38878 .37303 m
.38878 .37303 L
s
.38886 .37538 m
.38886 .37538 L
s
.38893 .37491 m
.38893 .37491 L
s
.38901 .37843 m
.38901 .37843 L
s
.38908 .37491 m
.38908 .37491 L
s
.38916 .37656 m
.38916 .37656 L
s
.38923 .3775 m
.38923 .3775 L
s
.3893 .37585 m
.3893 .37585 L
s
.38937 .37209 m
.38937 .37209 L
s
.38945 .37561 m
.38945 .37561 L
s
.38952 .37656 m
.38952 .37656 L
s
.3896 .37115 m
.3896 .37115 L
s
.38968 .36622 m
.38968 .36622 L
s
.38975 .36434 m
.38975 .36434 L
s
.38983 .36927 m
.38983 .36927 L
s
.3899 .36481 m
.3899 .36481 L
s
.38998 .36833 m
.38998 .36833 L
s
.39005 .36716 m
.39005 .36716 L
s
.39012 .37045 m
.39012 .37045 L
s
.39019 .37374 m
.39019 .37374 L
s
.39027 .37656 m
.39027 .37656 L
s
.39034 .37279 m
.39034 .37279 L
s
.39042 .37351 m
.39042 .37351 L
s
.39049 .36857 m
.39049 .36857 L
s
.39057 .3688 m
.39057 .3688 L
s
.39064 .37351 m
.39064 .37351 L
s
.39072 .36646 m
.39072 .36646 L
s
.39079 .36269 m
.39079 .36269 L
s
.39087 .36059 m
.39087 .36059 L
s
.39093 .36317 m
.39093 .36317 L
s
.39101 .36269 m
.39101 .36269 L
s
.39108 .35471 m
.39108 .35471 L
s
.39116 .3573 m
.39116 .3573 L
s
.39124 .36082 m
.39124 .36082 L
s
.39131 .35636 m
.39131 .35636 L
s
.39139 .35636 m
.39139 .35636 L
s
.39146 .36434 m
.39146 .36434 L
s
.39154 .36341 m
.39154 .36341 L
s
.39161 .36364 m
.39161 .36364 L
s
.39169 .36693 m
.39169 .36693 L
s
.39175 .37115 m
.39175 .37115 L
s
.39183 .37374 m
.39183 .37374 L
s
.3919 .37703 m
.3919 .37703 L
s
.39198 .37585 m
.39198 .37585 L
s
.39205 .3688 m
.39205 .3688 L
s
.39213 .37022 m
.39213 .37022 L
s
.3922 .36833 m
.3922 .36833 L
s
.39227 .37022 m
.39227 .37022 L
s
.39235 .36693 m
.39235 .36693 L
s
.39243 .37468 m
.39243 .37468 L
s
.3925 .3688 m
.3925 .3688 L
s
.39257 .36622 m
.39257 .36622 L
s
.39264 .36833 m
.39264 .36833 L
s
.39272 .37186 m
.39272 .37186 L
s
.3928 .37421 m
.3928 .37421 L
s
.39287 .3789 m
.39287 .3789 L
s
.39295 .38219 m
.39295 .38219 L
s
.39302 .37561 m
.39302 .37561 L
s
.39309 .37351 m
.39309 .37351 L
s
.39317 .37186 m
.39317 .37186 L
s
.39325 .37468 m
.39325 .37468 L
s
.39332 .37843 m
.39332 .37843 L
s
.39339 .37397 m
.39339 .37397 L
s
.39346 .36974 m
.39346 .36974 L
s
.39354 .37327 m
.39354 .37327 L
s
.39361 .37092 m
.39361 .37092 L
s
.39369 .37374 m
.39369 .37374 L
s
.39376 .36998 m
.39376 .36998 L
s
.39384 .37233 m
.39384 .37233 L
s
.39391 .37585 m
.39391 .37585 L
s
.39398 .37773 m
.39398 .37773 L
s
.39406 .38055 m
.39406 .38055 L
s
.39413 .38243 m
.39413 .38243 L
s
.3942 .38478 m
.3942 .38478 L
s
.39428 .37914 m
.39428 .37914 L
s
.39436 .37656 m
.39436 .37656 L
s
.39443 .37491 m
.39443 .37491 L
s
.39451 .37632 m
.39451 .37632 L
s
.39458 .37444 m
.39458 .37444 L
s
.39466 .38289 m
.39466 .38289 L
s
.39472 .38266 m
.39472 .38266 L
s
.3948 .38431 m
.3948 .38431 L
s
.39488 .38571 m
.39488 .38571 L
s
.39495 .37984 m
.39495 .37984 L
s
.39502 .3782 m
.39502 .3782 L
s
.3951 .37468 m
.3951 .37468 L
s
.39517 .36551 m
.39517 .36551 L
s
.39525 .37092 m
.39525 .37092 L
s
.39532 .36669 m
.39532 .36669 L
s
.3954 .36481 m
.3954 .36481 L
s
.39547 .36317 m
.39547 .36317 L
s
.39554 .36716 m
.39554 .36716 L
s
.39561 .36622 m
.39561 .36622 L
s
.39569 .36551 m
.39569 .36551 L
s
.39577 .36693 m
.39577 .36693 L
s
.39584 .36505 m
.39584 .36505 L
s
.39592 .36646 m
.39592 .36646 L
s
.39599 .35917 m
.39599 .35917 L
s
.39607 .36269 m
.39607 .36269 L
s
.39614 .36411 m
.39614 .36411 L
s
.39622 .35189 m
.39622 .35189 L
s
.39629 .3587 m
.39629 .3587 L
s
.39636 .36059 m
.39636 .36059 L
s
.39643 .36269 m
.39643 .36269 L
s
.39651 .35894 m
.39651 .35894 L
s
.39658 .35941 m
.39658 .35941 L
s
.39666 .35894 m
.39666 .35894 L
s
.39673 .36998 m
.39673 .36998 L
s
.39681 .37186 m
.39681 .37186 L
s
.39688 .37092 m
.39688 .37092 L
s
.39696 .36387 m
.39696 .36387 L
s
.39703 .36974 m
.39703 .36974 L
s
.3971 .36505 m
.3971 .36505 L
s
.39717 .36974 m
.39717 .36974 L
s
.39725 .37421 m
.39725 .37421 L
s
.39732 .3674 m
.39732 .3674 L
s
.3974 .358 m
.3974 .358 L
s
.39748 .36364 m
.39748 .36364 L
s
.39755 .36223 m
.39755 .36223 L
s
.39763 .3681 m
.39763 .3681 L
s
.3977 .37209 m
.3977 .37209 L
s
.39778 .37162 m
.39778 .37162 L
s
.39785 .36598 m
.39785 .36598 L
s
.39792 .37374 m
.39792 .37374 L
s
.39799 .37491 m
.39799 .37491 L
s
.39807 .37444 m
.39807 .37444 L
s
.39814 .37303 m
.39814 .37303 L
s
.39822 .37632 m
.39822 .37632 L
s
.39829 .37186 m
.39829 .37186 L
s
.39837 .37162 m
.39837 .37162 L
s
.39844 .37209 m
.39844 .37209 L
s
.39852 .37186 m
.39852 .37186 L
s
.39859 .36622 m
.39859 .36622 L
s
.39867 .36857 m
.39867 .36857 L
s
.39874 .37022 m
.39874 .37022 L
s
.39881 .36082 m
.39881 .36082 L
s
.39888 .36598 m
.39888 .36598 L
s
.39896 .36598 m
.39896 .36598 L
s
.39904 .36364 m
.39904 .36364 L
s
.39911 .36833 m
.39911 .36833 L
s
.39919 .36998 m
.39919 .36998 L
s
.39926 .36152 m
.39926 .36152 L
s
.39934 .358 m
.39934 .358 L
s
.39941 .35588 m
.39941 .35588 L
s
.39949 .35965 m
.39949 .35965 L
s
.39955 .36105 m
.39955 .36105 L
s
.39963 .35941 m
.39963 .35941 L
s
.3997 .35988 m
.3997 .35988 L
s
.39978 .36293 m
.39978 .36293 L
s
.39985 .36833 m
.39985 .36833 L
s
.39993 .36763 m
.39993 .36763 L
s
.4 .36505 m
.4 .36505 L
s
.40008 .3688 m
.40008 .3688 L
s
.40015 .36035 m
.40015 .36035 L
s
.40023 .36951 m
.40023 .36951 L
s
.4003 .36974 m
.4003 .36974 L
s
.40037 .36693 m
.40037 .36693 L
s
.40044 .36575 m
.40044 .36575 L
s
.40052 .35847 m
.40052 .35847 L
s
.4006 .36105 m
.4006 .36105 L
s
.40067 .35659 m
.40067 .35659 L
s
.40075 .35095 m
.40075 .35095 L
s
.40082 .36293 m
.40082 .36293 L
s
.40089 .36293 m
.40089 .36293 L
s
.40097 .36458 m
.40097 .36458 L
s
.40105 .36269 m
.40105 .36269 L
s
.40112 .36152 m
.40112 .36152 L
s
.40119 .36176 m
.40119 .36176 L
s
.40126 .36293 m
.40126 .36293 L
s
.40134 .36152 m
.40134 .36152 L
s
.40141 .36269 m
.40141 .36269 L
s
.40149 .36857 m
.40149 .36857 L
s
.40156 .37139 m
.40156 .37139 L
s
.40164 .37515 m
.40164 .37515 L
s
.40171 .37397 m
.40171 .37397 L
s
.40179 .36458 m
.40179 .36458 L
s
.40186 .36528 m
.40186 .36528 L
s
.40193 .36059 m
.40193 .36059 L
s
.402 .36035 m
.402 .36035 L
s
.40208 .35471 m
.40208 .35471 L
s
.40216 .35284 m
.40216 .35284 L
s
.40223 .35259 m
.40223 .35259 L
s
.40231 .35189 m
.40231 .35189 L
s
.40238 .35236 m
.40238 .35236 L
s
.40246 .35072 m
.40246 .35072 L
s
.40252 .35002 m
.40252 .35002 L
s
.4026 .34813 m
.4026 .34813 L
s
.40268 .34978 m
.40268 .34978 L
s
.40275 .35213 m
.40275 .35213 L
s
.40282 .34907 m
.40282 .34907 L
s
.4029 .35166 m
.4029 .35166 L
s
.40297 .35894 m
.40297 .35894 L
s
.40305 .36176 m
.40305 .36176 L
s
.40312 .35588 m
.40312 .35588 L
s
.4032 .35048 m
.4032 .35048 L
s
.40327 .35002 m
.40327 .35002 L
s
.40334 .34391 m
.40334 .34391 L
s
.40342 .34485 m
.40342 .34485 L
s
.4035 .33968 m
.4035 .33968 L
s
.40357 .33897 m
.40357 .33897 L
s
.40364 .34485 m
.40364 .34485 L
s
.40372 .34531 m
.40372 .34531 L
s
.40379 .34696 m
.40379 .34696 L
s
.40387 .3472 m
.40387 .3472 L
s
.40394 .35401 m
.40394 .35401 L
s
.40402 .35424 m
.40402 .35424 L
s
.40409 .35236 m
.40409 .35236 L
s
.40416 .34485 m
.40416 .34485 L
s
.40423 .34249 m
.40423 .34249 L
s
.40431 .34132 m
.40431 .34132 L
s
.40438 .34226 m
.40438 .34226 L
s
.40446 .34226 m
.40446 .34226 L
s
.40453 .34156 m
.40453 .34156 L
s
.40461 .33803 m
.40461 .33803 L
s
.40468 .33545 m
.40468 .33545 L
s
.40476 .33945 m
.40476 .33945 L
s
.40483 .33827 m
.40483 .33827 L
s
.4049 .33686 m
.4049 .33686 L
s
.40497 .33592 m
.40497 .33592 L
s
.40505 .34297 m
.40505 .34297 L
s
.40513 .34578 m
.40513 .34578 L
s
.4052 .34367 m
.4052 .34367 L
s
.40528 .35048 m
.40528 .35048 L
s
.40535 .35025 m
.40535 .35025 L
s
.40543 .3486 m
.40543 .3486 L
s
.4055 .34766 m
.4055 .34766 L
s
.40558 .34297 m
.40558 .34297 L
s
.40565 .34414 m
.40565 .34414 L
s
.40572 .34367 m
.40572 .34367 L
s
.40579 .3385 m
.40579 .3385 L
s
.40587 .34109 m
.40587 .34109 L
s
.40594 .34391 m
.40594 .34391 L
s
.40602 .34226 m
.40602 .34226 L
s
.40609 .34414 m
.40609 .34414 L
s
.40617 .34391 m
.40617 .34391 L
s
.40624 .34766 m
.40624 .34766 L
s
.40632 .34955 m
.40632 .34955 L
s
.40639 .34626 m
.40639 .34626 L
s
.40647 .34602 m
.40647 .34602 L
s
.40654 .35612 m
.40654 .35612 L
s
.40661 .35072 m
.40661 .35072 L
s
.40668 .35471 m
.40668 .35471 L
s
.40676 .35518 m
.40676 .35518 L
s
.40684 .35565 m
.40684 .35565 L
s
.40691 .35401 m
.40691 .35401 L
s
.40699 .34884 m
.40699 .34884 L
s
.40706 .35189 m
.40706 .35189 L
s
.40714 .34931 m
.40714 .34931 L
s
.40721 .35471 m
.40721 .35471 L
s
.40729 .34766 m
.40729 .34766 L
s
.40735 .33874 m
.40735 .33874 L
s
.40743 .34179 m
.40743 .34179 L
s
.4075 .3472 m
.4075 .3472 L
s
.40758 .34673 m
.40758 .34673 L
s
.40765 .34884 m
.40765 .34884 L
s
.40773 .35213 m
.40773 .35213 L
s
.4078 .35777 m
.4078 .35777 L
s
.40788 .35612 m
.40788 .35612 L
s
.40795 .35988 m
.40795 .35988 L
s
.40803 .36598 m
.40803 .36598 L
s
.4081 .37022 m
.4081 .37022 L
s
.40817 .36716 m
.40817 .36716 L
s
.40824 .36551 m
.40824 .36551 L
s
.40832 .36974 m
.40832 .36974 L
s
.4084 .36364 m
.4084 .36364 L
s
.40847 .36833 m
.40847 .36833 L
s
.40855 .37069 m
.40855 .37069 L
s
.40862 .36646 m
.40862 .36646 L
s
.4087 .37233 m
.4087 .37233 L
s
.40877 .36904 m
.40877 .36904 L
s
.40885 .37303 m
.40885 .37303 L
s
.40892 .37374 m
.40892 .37374 L
s
.40899 .3688 m
.40899 .3688 L
s
.40906 .36387 m
.40906 .36387 L
s
.40914 .37351 m
.40914 .37351 L
s
.40921 .37327 m
.40921 .37327 L
s
.40929 .37303 m
.40929 .37303 L
s
.40936 .38219 m
.40936 .38219 L
s
.40944 .37914 m
.40944 .37914 L
s
.40951 .38243 m
.40951 .38243 L
s
.40959 .37937 m
.40959 .37937 L
s
.40966 .37444 m
.40966 .37444 L
s
.40973 .37351 m
.40973 .37351 L
s
.4098 .36927 m
.4098 .36927 L
s
.40988 .36833 m
.40988 .36833 L
s
.40996 .37115 m
.40996 .37115 L
s
.41003 .3782 m
.41003 .3782 L
s
.41011 .37491 m
.41011 .37491 L
s
.41018 .38125 m
.41018 .38125 L
s
.41026 .38266 m
.41026 .38266 L
s
.41033 .38618 m
.41033 .38618 L
s
.41041 .38595 m
.41041 .38595 L
s
.41048 .3876 m
.41048 .3876 L
s
.41055 .38548 m
.41055 .38548 L
s
.41062 .38289 m
.41062 .38289 L
s
.4107 .37303 m
.4107 .37303 L
s
.41077 .37538 m
.41077 .37538 L
s
.41085 .37279 m
.41085 .37279 L
s
.41092 .37444 m
.41092 .37444 L
s
.411 .3681 m
.411 .3681 L
s
.41107 .36411 m
.41107 .36411 L
s
.41114 .36481 m
.41114 .36481 L
s
.41122 .36551 m
.41122 .36551 L
s
.4113 .36857 m
.4113 .36857 L
s
.41137 .36833 m
.41137 .36833 L
s
.41144 .36763 m
.41144 .36763 L
s
.41152 .36341 m
.41152 .36341 L
s
.41159 .36317 m
.41159 .36317 L
s
.41167 .36505 m
.41167 .36505 L
s
.41174 .36152 m
.41174 .36152 L
s
.41182 .36505 m
.41182 .36505 L
s
.41189 .3587 m
.41189 .3587 L
s
.41196 .35777 m
.41196 .35777 L
s
.41204 .35636 m
.41204 .35636 L
s
.41212 .35847 m
.41212 .35847 L
s
.41218 .36082 m
.41218 .36082 L
s
.41226 .36246 m
.41226 .36246 L
s
.41233 .36082 m
.41233 .36082 L
s
.41241 .35941 m
.41241 .35941 L
s
.41248 .35777 m
.41248 .35777 L
s
.41256 .36246 m
.41256 .36246 L
s
.41263 .36269 m
.41263 .36269 L
s
.4127 .36082 m
.4127 .36082 L
s
.41277 .36763 m
.41277 .36763 L
s
.41285 .37022 m
.41285 .37022 L
s
.41293 .36693 m
.41293 .36693 L
s
.413 .36763 m
.413 .36763 L
s
.41308 .36317 m
.41308 .36317 L
s
.41315 .36082 m
.41315 .36082 L
s
.41323 .36411 m
.41323 .36411 L
s
.4133 .35988 m
.4133 .35988 L
s
.41338 .36223 m
.41338 .36223 L
s
.41345 .36598 m
.41345 .36598 L
s
.41352 .36223 m
.41352 .36223 L
s
.41359 .36176 m
.41359 .36176 L
s
.41367 .36293 m
.41367 .36293 L
s
.41375 .36387 m
.41375 .36387 L
s
.41382 .36246 m
.41382 .36246 L
s
.41389 .35988 m
.41389 .35988 L
s
.41397 .36152 m
.41397 .36152 L
s
.41404 .36035 m
.41404 .36035 L
s
.41412 .35448 m
.41412 .35448 L
s
.41419 .35307 m
.41419 .35307 L
s
.41427 .35284 m
.41427 .35284 L
s
.41434 .34156 m
.41434 .34156 L
s
.41441 .3385 m
.41441 .3385 L
s
.41448 .3331 m
.41448 .3331 L
s
.41456 .3284 m
.41456 .3284 L
s
.41464 .33287 m
.41464 .33287 L
s
.41471 .33357 m
.41471 .33357 L
s
.41479 .32958 m
.41479 .32958 L
s
.41486 .33827 m
.41486 .33827 L
s
.41494 .33498 m
.41494 .33498 L
s
.41501 .33287 m
.41501 .33287 L
s
.41509 .33475 m
.41509 .33475 L
s
.41515 .3371 m
.41515 .3371 L
s
.41523 .33945 m
.41523 .33945 L
s
.4153 .3385 m
.4153 .3385 L
s
.41538 .33992 m
.41538 .33992 L
s
.41545 .34249 m
.41545 .34249 L
s
.41553 .34203 m
.41553 .34203 L
s
.4156 .3432 m
.4156 .3432 L
s
.41568 .3378 m
.41568 .3378 L
s
.41575 .3371 m
.41575 .3371 L
s
.41583 .3371 m
.41583 .3371 L
s
.4159 .33052 m
.4159 .33052 L
s
.41597 .32864 m
.41597 .32864 L
s
.41604 .33099 m
.41604 .33099 L
s
.41612 .3284 m
.41612 .3284 L
s
.4162 .32347 m
.4162 .32347 L
s
.41627 .31995 m
.41627 .31995 L
s
.41635 .31666 m
.41635 .31666 L
s
.41642 .31549 m
.41642 .31549 L
s
.4165 .30962 m
.4165 .30962 L
s
.41657 .30726 m
.41657 .30726 L
s
.41665 .3021 m
.41665 .3021 L
s
.41672 .30092 m
.41672 .30092 L
s
.41679 .30985 m
.41679 .30985 L
s
.41686 .31172 m
.41686 .31172 L
s
.41694 .31172 m
.41694 .31172 L
s
.41701 .30985 m
.41701 .30985 L
s
.41709 .31008 m
.41709 .31008 L
s
.41716 .31337 m
.41716 .31337 L
s
.41724 .31196 m
.41724 .31196 L
s
.41731 .31619 m
.41731 .31619 L
s
.41739 .30891 m
.41739 .30891 L
s
.41746 .31079 m
.41746 .31079 L
s
.41753 .30868 m
.41753 .30868 L
s
.4176 .3122 m
.4176 .3122 L
s
.41768 .31361 m
.41768 .31361 L
s
.41776 .30891 m
.41776 .30891 L
s
.41783 .3075 m
.41783 .3075 L
s
.41791 .30162 m
.41791 .30162 L
s
.41798 .29881 m
.41798 .29881 L
s
.41806 .29411 m
.41806 .29411 L
s
.41813 .28706 m
.41813 .28706 L
s
.41821 .28918 m
.41821 .28918 L
s
.41828 .28777 m
.41828 .28777 L
s
.41835 .29177 m
.41835 .29177 L
s
.41842 .28706 m
.41842 .28706 L
s
.4185 .28331 m
.4185 .28331 L
s
.41857 .27838 m
.41857 .27838 L
s
.41865 .27908 m
.41865 .27908 L
s
.41872 .27509 m
.41872 .27509 L
s
.4188 .27203 m
.4188 .27203 L
s
.41887 .27109 m
.41887 .27109 L
s
.41895 .27157 m
.41895 .27157 L
s
.41902 .27297 m
.41902 .27297 L
s
.4191 .27203 m
.4191 .27203 L
s
.41917 .25982 m
.41917 .25982 L
s
.41924 .26147 m
.41924 .26147 L
s
.41932 .26052 m
.41932 .26052 L
s
.41939 .25841 m
.41939 .25841 L
s
.41947 .25935 m
.41947 .25935 L
s
.41954 .25676 m
.41954 .25676 L
s
.41962 .2516 m
.41962 .2516 L
s
.41969 .257 m
.41969 .257 L
s
.41976 .26123 m
.41976 .26123 L
s
.41984 .26452 m
.41984 .26452 L
s
.41992 .27062 m
.41992 .27062 L
s
.41998 .26875 m
.41998 .26875 L
s
.42006 .2678 m
.42006 .2678 L
s
.42013 .26992 m
.42013 .26992 L
s
.42021 .26357 m
.42021 .26357 L
s
.42028 .26217 m
.42028 .26217 L
s
.42036 .27062 m
.42036 .27062 L
s
.42043 .27015 m
.42043 .27015 L
s
.4205 .26733 m
.4205 .26733 L
s
.42058 .25935 m
.42058 .25935 L
s
.42066 .25301 m
.42066 .25301 L
s
.42073 .24948 m
.42073 .24948 L
s
.4208 .25301 m
.4208 .25301 L
s
.42088 .24972 m
.42088 .24972 L
s
.42095 .24596 m
.42095 .24596 L
s
.42103 .24972 m
.42103 .24972 L
s
.4211 .2523 m
.4211 .2523 L
s
.42118 .25207 m
.42118 .25207 L
s
.42125 .25183 m
.42125 .25183 L
s
.42132 .24878 m
.42132 .24878 L
s
.42139 .24173 m
.42139 .24173 L
s
.42147 .24337 m
.42147 .24337 L
s
.42155 .23962 m
.42155 .23962 L
s
.42162 .24337 m
.42162 .24337 L
s
.42169 .24291 m
.42169 .24291 L
s
.42177 .2509 m
.42177 .2509 L
s
.42184 .25771 m
.42184 .25771 L
s
.42192 .26123 m
.42192 .26123 L
s
.42199 .26499 m
.42199 .26499 L
s
.42207 .26898 m
.42207 .26898 L
s
.42214 .26757 m
.42214 .26757 L
s
.42221 .26968 m
.42221 .26968 L
s
.42229 .2678 m
.42229 .2678 L
s
.42236 .26616 m
.42236 .26616 L
s
.42244 .26569 m
.42244 .26569 L
s
.42251 .26898 m
.42251 .26898 L
s
.42259 .2718 m
.42259 .2718 L
s
.42266 .26311 m
.42266 .26311 L
s
.42274 .25888 m
.42274 .25888 L
s
.42281 .26686 m
.42281 .26686 L
s
.42289 .26686 m
.42289 .26686 L
s
.42295 .26029 m
.42295 .26029 L
s
.42303 .25254 m
.42303 .25254 L
s
.4231 .2509 m
.4231 .2509 L
s
.42318 .24337 m
.42318 .24337 L
s
.42325 .23798 m
.42325 .23798 L
s
.42333 .24055 m
.42333 .24055 L
s
.4234 .23539 m
.4234 .23539 L
s
.42348 .23374 m
.42348 .23374 L
s
.42355 .23516 m
.42355 .23516 L
s
.42363 .23539 m
.42363 .23539 L
s
.4237 .2368 m
.4237 .2368 L
s
.42377 .2408 m
.42377 .2408 L
s
.42384 .23492 m
.42384 .23492 L
s
.42392 .23351 m
.42392 .23351 L
s
.424 .23257 m
.424 .23257 L
s
.42407 .23163 m
.42407 .23163 L
s
.42415 .23703 m
.42415 .23703 L
s
.42422 .23422 m
.42422 .23422 L
s
.4243 .23351 m
.4243 .23351 L
s
.42437 .22529 m
.42437 .22529 L
s
.42445 .22741 m
.42445 .22741 L
s
.42452 .22271 m
.42452 .22271 L
s
.42459 .21965 m
.42459 .21965 L
s
.42466 .22012 m
.42466 .22012 L
s
.42474 .22552 m
.42474 .22552 L
s
.42481 .22364 m
.42481 .22364 L
s
.42489 .21824 m
.42489 .21824 L
s
.42496 .22271 m
.42496 .22271 L
s
.42504 .22153 m
.42504 .22153 L
s
.42511 .21989 m
.42511 .21989 L
s
.42519 .22247 m
.42519 .22247 L
s
.42526 .22083 m
.42526 .22083 L
s
.42533 .22224 m
.42533 .22224 L
s
.4254 .2213 m
.4254 .2213 L
s
.42548 .22599 m
.42548 .22599 L
s
.42556 .22459 m
.42556 .22459 L
s
.42563 .22341 m
.42563 .22341 L
s
.42571 .2321 m
.42571 .2321 L
s
.42578 .23327 m
.42578 .23327 L
s
.42586 .24173 m
.42586 .24173 L
s
.42593 .24197 m
.42593 .24197 L
s
.42601 .24384 m
.42601 .24384 L
s
.42608 .23962 m
.42608 .23962 L
s
.42615 .24314 m
.42615 .24314 L
s
.42622 .24361 m
.42622 .24361 L
s
.4263 .24408 m
.4263 .24408 L
s
.42637 .24337 m
.42637 .24337 L
s
.42645 .24526 m
.42645 .24526 L
s
.42652 .24761 m
.42652 .24761 L
s
.4266 .24549 m
.4266 .24549 L
s
.42667 .24948 m
.42667 .24948 L
s
.42675 .24808 m
.42675 .24808 L
s
.42682 .24808 m
.42682 .24808 L
s
.4269 .25065 m
.4269 .25065 L
s
.42697 .25277 m
.42697 .25277 L
s
.42704 .25301 m
.42704 .25301 L
s
.42712 .24713 m
.42712 .24713 L
s
.42719 .24901 m
.42719 .24901 L
s
.42727 .24643 m
.42727 .24643 L
s
.42734 .24995 m
.42734 .24995 L
s
.42742 .24855 m
.42742 .24855 L
s
.42749 .25207 m
.42749 .25207 L
s
.42757 .25277 m
.42757 .25277 L
s
.42764 .25512 m
.42764 .25512 L
s
.42772 .25277 m
.42772 .25277 L
s
.42778 .25347 m
.42778 .25347 L
s
.42786 .25606 m
.42786 .25606 L
s
.42793 .257 m
.42793 .257 L
s
.42801 .26217 m
.42801 .26217 L
s
.42808 .26404 m
.42808 .26404 L
s
.42816 .2617 m
.42816 .2617 L
s
.42823 .26311 m
.42823 .26311 L
s
.4283 .257 m
.4283 .257 L
s
.42838 .26075 m
.42838 .26075 L
s
.42846 .2678 m
.42846 .2678 L
s
.42853 .26404 m
.42853 .26404 L
s
.4286 .26123 m
.4286 .26123 L
s
.42868 .26075 m
.42868 .26075 L
s
.42875 .25935 m
.42875 .25935 L
s
.42883 .25935 m
.42883 .25935 L
s
.4289 .26334 m
.4289 .26334 L
s
.42898 .25794 m
.42898 .25794 L
s
.42905 .26546 m
.42905 .26546 L
s
.42912 .27085 m
.42912 .27085 L
s
.4292 .27085 m
.4292 .27085 L
s
.42928 .26546 m
.42928 .26546 L
s
.42935 .26733 m
.42935 .26733 L
s
.42942 .26264 m
.42942 .26264 L
s
.42949 .25536 m
.42949 .25536 L
s
.42957 .25301 m
.42957 .25301 L
s
.42964 .24713 m
.42964 .24713 L
s
.42972 .2469 m
.42972 .2469 L
s
.42979 .25371 m
.42979 .25371 L
s
.42987 .26005 m
.42987 .26005 L
s
.42994 .25888 m
.42994 .25888 L
s
.43001 .25418 m
.43001 .25418 L
s
.43009 .25137 m
.43009 .25137 L
s
.43017 .2516 m
.43017 .2516 L
s
.43024 .24784 m
.43024 .24784 L
s
.43031 .24925 m
.43031 .24925 L
s
.43039 .25042 m
.43039 .25042 L
s
.43046 .24901 m
.43046 .24901 L
s
.43054 .25301 m
.43054 .25301 L
s
.43061 .25019 m
.43061 .25019 L
s
.43069 .2523 m
.43069 .2523 L
s
.43075 .2523 m
.43075 .2523 L
s
.43083 .25559 m
.43083 .25559 L
s
.43091 .25629 m
.43091 .25629 L
s
.43098 .24948 m
.43098 .24948 L
s
.43105 .25254 m
.43105 .25254 L
s
.43113 .25982 m
.43113 .25982 L
s
.4312 .25747 m
.4312 .25747 L
s
.43128 .257 m
.43128 .257 L
s
.43135 .25113 m
.43135 .25113 L
s
.43143 .25512 m
.43143 .25512 L
s
.4315 .25042 m
.4315 .25042 L
s
.43157 .24972 m
.43157 .24972 L
s
.43164 .25042 m
.43164 .25042 L
s
.43172 .24103 m
.43172 .24103 L
s
.4318 .24197 m
.4318 .24197 L
s
.43187 .2408 m
.43187 .2408 L
s
.43195 .24127 m
.43195 .24127 L
s
.43202 .2368 m
.43202 .2368 L
s
.4321 .2368 m
.4321 .2368 L
s
.43217 .23845 m
.43217 .23845 L
s
.43225 .24479 m
.43225 .24479 L
s
.43232 .24596 m
.43232 .24596 L
s
.43239 .24761 m
.43239 .24761 L
s
.43246 .25418 m
.43246 .25418 L
s
.43254 .25042 m
.43254 .25042 L
s
.43261 .25207 m
.43261 .25207 L
s
.43269 .2523 m
.43269 .2523 L
s
.43276 .25606 m
.43276 .25606 L
s
.43284 .25277 m
.43284 .25277 L
s
.43291 .24972 m
.43291 .24972 L
s
.43299 .24713 m
.43299 .24713 L
s
.43306 .24901 m
.43306 .24901 L
s
.43314 .2509 m
.43314 .2509 L
s
.4332 .25042 m
.4332 .25042 L
s
.43328 .25371 m
.43328 .25371 L
s
.43336 .25653 m
.43336 .25653 L
s
.43343 .24737 m
.43343 .24737 L
s
.43351 .24479 m
.43351 .24479 L
s
.43358 .24009 m
.43358 .24009 L
s
.43366 .24314 m
.43366 .24314 L
s
.43373 .24173 m
.43373 .24173 L
s
.43381 .2415 m
.43381 .2415 L
s
.43388 .24643 m
.43388 .24643 L
s
.43395 .2469 m
.43395 .2469 L
s
.43402 .24384 m
.43402 .24384 L
s
.4341 .24972 m
.4341 .24972 L
s
.43417 .24291 m
.43417 .24291 L
s
.43425 .23985 m
.43425 .23985 L
s
.43432 .23492 m
.43432 .23492 L
s
.4344 .23422 m
.4344 .23422 L
s
.43447 .22811 m
.43447 .22811 L
s
.43455 .22506 m
.43455 .22506 L
s
.43462 .22858 m
.43462 .22858 L
s
.4347 .22599 m
.4347 .22599 L
s
.43477 .22271 m
.43477 .22271 L
s
.43484 .22247 m
.43484 .22247 L
s
.43492 .2307 m
.43492 .2307 L
s
.43499 .23492 m
.43499 .23492 L
s
.43507 .23539 m
.43507 .23539 L
s
.43514 .23821 m
.43514 .23821 L
s
.43522 .23045 m
.43522 .23045 L
s
.43529 .22764 m
.43529 .22764 L
s
.43537 .22552 m
.43537 .22552 L
s
.43544 .22741 m
.43544 .22741 L
s
.43552 .22552 m
.43552 .22552 L
s
.43558 .22364 m
.43558 .22364 L
s
.43566 .22153 m
.43566 .22153 L
s
.43573 .22153 m
.43573 .22153 L
s
.43581 .21965 m
.43581 .21965 L
s
.43588 .22177 m
.43588 .22177 L
s
.43596 .22106 m
.43596 .22106 L
s
.43603 .21496 m
.43603 .21496 L
s
.43611 .21378 m
.43611 .21378 L
s
.43618 .21848 m
.43618 .21848 L
s
.43626 .21965 m
.43626 .21965 L
s
.43633 .22341 m
.43633 .22341 L
s
.4364 .22153 m
.4364 .22153 L
s
.43648 .22317 m
.43648 .22317 L
s
.43655 .22928 m
.43655 .22928 L
s
.43663 .22788 m
.43663 .22788 L
s
.4367 .22177 m
.4367 .22177 L
s
.43678 .21731 m
.43678 .21731 L
s
.43685 .22341 m
.43685 .22341 L
s
.43692 .22693 m
.43692 .22693 L
s
.437 .22576 m
.437 .22576 L
s
.43708 .22364 m
.43708 .22364 L
s
.43715 .22599 m
.43715 .22599 L
s
.43722 .22623 m
.43722 .22623 L
s
.43729 .22646 m
.43729 .22646 L
s
.43737 .22364 m
.43737 .22364 L
s
.43744 .2213 m
.43744 .2213 L
s
.43752 .22153 m
.43752 .22153 L
s
.43759 .21402 m
.43759 .21402 L
s
.43767 .21472 m
.43767 .21472 L
s
.43774 .21965 m
.43774 .21965 L
s
.43782 .21801 m
.43782 .21801 L
s
.43789 .21472 m
.43789 .21472 L
s
.43797 .21355 m
.43797 .21355 L
s
.43804 .21731 m
.43804 .21731 L
s
.43811 .21683 m
.43811 .21683 L
s
.43819 .21778 m
.43819 .21778 L
s
.43826 .2206 m
.43826 .2206 L
s
.43834 .22341 m
.43834 .22341 L
s
.43841 .22224 m
.43841 .22224 L
s
.43849 .22153 m
.43849 .22153 L
s
.43855 .21613 m
.43855 .21613 L
s
.43863 .21613 m
.43863 .21613 L
s
.43871 .21636 m
.43871 .21636 L
s
.43878 .21425 m
.43878 .21425 L
s
.43885 .20415 m
.43885 .20415 L
s
.43893 .20579 m
.43893 .20579 L
s
.439 .20486 m
.439 .20486 L
s
.43908 .20016 m
.43908 .20016 L
s
.43915 .19311 m
.43915 .19311 L
s
.43923 .191 m
.43923 .191 L
s
.4393 .19429 m
.4393 .19429 L
s
.43937 .1924 m
.43937 .1924 L
s
.43945 .19358 m
.43945 .19358 L
s
.43953 .19053 m
.43953 .19053 L
s
.4396 .19287 m
.4396 .19287 L
s
.43967 .19804 m
.43967 .19804 L
s
.43975 .19922 m
.43975 .19922 L
s
.43982 .2011 m
.43982 .2011 L
s
.4399 .2018 m
.4399 .2018 L
s
.43997 .20532 m
.43997 .20532 L
s
.44005 .20979 m
.44005 .20979 L
s
.44012 .2112 m
.44012 .2112 L
s
.44019 .20955 m
.44019 .20955 L
s
.44026 .21402 m
.44026 .21402 L
s
.44034 .2166 m
.44034 .2166 L
s
.44041 .21096 m
.44041 .21096 L
s
.44049 .21378 m
.44049 .21378 L
s
.44056 .21989 m
.44056 .21989 L
s
.44064 .21731 m
.44064 .21731 L
s
.44071 .21284 m
.44071 .21284 L
s
.44079 .2119 m
.44079 .2119 L
s
.44086 .20439 m
.44086 .20439 L
s
.44094 .20791 m
.44094 .20791 L
s
.441 .20227 m
.441 .20227 L
s
.44108 .20297 m
.44108 .20297 L
s
.44116 .19992 m
.44116 .19992 L
s
.44123 .19992 m
.44123 .19992 L
s
.44131 .19593 m
.44131 .19593 L
s
.44138 .1964 m
.44138 .1964 L
s
.44146 .19335 m
.44146 .19335 L
s
.44153 .19217 m
.44153 .19217 L
s
.44161 .19123 m
.44161 .19123 L
s
.44168 .19217 m
.44168 .19217 L
s
.44175 .19194 m
.44175 .19194 L
s
.44182 .19616 m
.44182 .19616 L
s
.4419 .19898 m
.4419 .19898 L
s
.44197 .1964 m
.44197 .1964 L
s
.44205 .19522 m
.44205 .19522 L
s
.44212 .19217 m
.44212 .19217 L
s
.4422 .19311 m
.4422 .19311 L
s
.44227 .18748 m
.44227 .18748 L
s
.44235 .1903 m
.44235 .1903 L
s
.44242 .19123 m
.44242 .19123 L
s
.4425 .18654 m
.4425 .18654 L
s
.44257 .18395 m
.44257 .18395 L
s
.44264 .1863 m
.44264 .1863 L
s
.44272 .18512 m
.44272 .18512 L
s
.44279 .18748 m
.44279 .18748 L
s
.44287 .18254 m
.44287 .18254 L
s
.44294 .18325 m
.44294 .18325 L
s
.44302 .18184 m
.44302 .18184 L
s
.44309 .18395 m
.44309 .18395 L
s
.44317 .18137 m
.44317 .18137 L
s
.44324 .18794 m
.44324 .18794 L
s
.44332 .18654 m
.44332 .18654 L
s
.44338 .18983 m
.44338 .18983 L
s
.44346 .18794 m
.44346 .18794 L
s
.44353 .19546 m
.44353 .19546 L
s
.44361 .19522 m
.44361 .19522 L
s
.44368 .19476 m
.44368 .19476 L
s
.44376 .1917 m
.44376 .1917 L
s
.44383 .19264 m
.44383 .19264 L
s
.44391 .19522 m
.44391 .19522 L
s
.44398 .19452 m
.44398 .19452 L
s
.44406 .19711 m
.44406 .19711 L
s
.44413 .19875 m
.44413 .19875 L
s
.4442 .19711 m
.4442 .19711 L
s
.44428 .19804 m
.44428 .19804 L
s
.44435 .19123 m
.44435 .19123 L
s
.44443 .1917 m
.44443 .1917 L
s
.4445 .19405 m
.4445 .19405 L
s
.44458 .20768 m
.44458 .20768 L
s
.44465 .20556 m
.44465 .20556 L
s
.44473 .20838 m
.44473 .20838 L
s
.4448 .20439 m
.4448 .20439 L
s
.44488 .20861 m
.44488 .20861 L
s
.44495 .20297 m
.44495 .20297 L
s
.44502 .20768 m
.44502 .20768 L
s
.44509 .2065 m
.44509 .2065 L
s
.44517 .20932 m
.44517 .20932 L
s
.44524 .20415 m
.44524 .20415 L
s
.44532 .21167 m
.44532 .21167 L
s
.44539 .21355 m
.44539 .21355 L
s
.44547 .21143 m
.44547 .21143 L
s
.44554 .20932 m
.44554 .20932 L
s
.44562 .21237 m
.44562 .21237 L
s
.44569 .21096 m
.44569 .21096 L
s
.44577 .21707 m
.44577 .21707 L
s
.44584 .2213 m
.44584 .2213 L
s
.44591 .21542 m
.44591 .21542 L
s
.44599 .21519 m
.44599 .21519 L
s
.44606 .21731 m
.44606 .21731 L
s
.44614 .22247 m
.44614 .22247 L
s
.44621 .22764 m
.44621 .22764 L
s
.44629 .22928 m
.44629 .22928 L
s
.44636 .23234 m
.44636 .23234 L
s
.44644 .23304 m
.44644 .23304 L
s
.44651 .22975 m
.44651 .22975 L
s
.44658 .22459 m
.44658 .22459 L
s
.44665 .22083 m
.44665 .22083 L
s
.44673 .22741 m
.44673 .22741 L
s
.4468 .22811 m
.4468 .22811 L
s
.44688 .21942 m
.44688 .21942 L
s
.44695 .22083 m
.44695 .22083 L
s
.44703 .22435 m
.44703 .22435 L
s
.4471 .2307 m
.4471 .2307 L
s
.44717 .2267 m
.44717 .2267 L
s
.44725 .22693 m
.44725 .22693 L
s
.44733 .23234 m
.44733 .23234 L
s
.4474 .22764 m
.4474 .22764 L
s
.44747 .23022 m
.44747 .23022 L
s
.44755 .22529 m
.44755 .22529 L
s
.44762 .22341 m
.44762 .22341 L
s
.4477 .21683 m
.4477 .21683 L
s
.44777 .21801 m
.44777 .21801 L
s
.44785 .222 m
.44785 .222 L
s
.44792 .22576 m
.44792 .22576 L
s
.44799 .22083 m
.44799 .22083 L
s
.44807 .21589 m
.44807 .21589 L
s
.44815 .21167 m
.44815 .21167 L
s
.44821 .21284 m
.44821 .21284 L
s
.44829 .21871 m
.44829 .21871 L
s
.44836 .21895 m
.44836 .21895 L
s
.44844 .22153 m
.44844 .22153 L
s
.44851 .21449 m
.44851 .21449 L
s
.44859 .22083 m
.44859 .22083 L
s
.44866 .22271 m
.44866 .22271 L
s
.44874 .21871 m
.44874 .21871 L
s
.4488 .21683 m
.4488 .21683 L
s
.44888 .21683 m
.44888 .21683 L
s
.44896 .21965 m
.44896 .21965 L
s
.44903 .21143 m
.44903 .21143 L
s
.44911 .21307 m
.44911 .21307 L
s
.44918 .21284 m
.44918 .21284 L
s
.44926 .21355 m
.44926 .21355 L
s
.44933 .2166 m
.44933 .2166 L
s
.44941 .21871 m
.44941 .21871 L
s
.44948 .21355 m
.44948 .21355 L
s
.44955 .20885 m
.44955 .20885 L
s
.44962 .20532 m
.44962 .20532 L
s
.4497 .20674 m
.4497 .20674 L
s
.44978 .21096 m
.44978 .21096 L
s
.44985 .21002 m
.44985 .21002 L
s
.44992 .2166 m
.44992 .2166 L
s
.45 .21378 m
.45 .21378 L
s
.45007 .21519 m
.45007 .21519 L
s
.45015 .21472 m
.45015 .21472 L
s
.45022 .21378 m
.45022 .21378 L
s
.4503 .21331 m
.4503 .21331 L
s
.45037 .20979 m
.45037 .20979 L
s
.45044 .20392 m
.45044 .20392 L
s
.45052 .20063 m
.45052 .20063 L
s
.45059 .20157 m
.45059 .20157 L
s
.45067 .20392 m
.45067 .20392 L
s
.45074 .20486 m
.45074 .20486 L
s
.45082 .19922 m
.45082 .19922 L
s
.45089 .19358 m
.45089 .19358 L
s
.45097 .19358 m
.45097 .19358 L
s
.45104 .19382 m
.45104 .19382 L
s
.45112 .19311 m
.45112 .19311 L
s
.45118 .18748 m
.45118 .18748 L
s
.45126 .19123 m
.45126 .19123 L
s
.45133 .18794 m
.45133 .18794 L
s
.45141 .18724 m
.45141 .18724 L
s
.45148 .18419 m
.45148 .18419 L
s
.45156 .17948 m
.45156 .17948 L
s
.45163 .17925 m
.45163 .17925 L
s
.45171 .1816 m
.45171 .1816 L
s
.45178 .17948 m
.45178 .17948 L
s
.45186 .17385 m
.45186 .17385 L
s
.45193 .17385 m
.45193 .17385 L
s
.452 .18489 m
.452 .18489 L
s
.45208 .17902 m
.45208 .17902 L
s
.45215 .1823 m
.45215 .1823 L
s
.45223 .18559 m
.45223 .18559 L
s
.4523 .17948 m
.4523 .17948 L
s
.45238 .18277 m
.45238 .18277 L
s
.45245 .17948 m
.45245 .17948 L
s
.45253 .18043 m
.45253 .18043 L
s
.4526 .17644 m
.4526 .17644 L
s
.45268 .17855 m
.45268 .17855 L
s
.45275 .17667 m
.45275 .17667 L
s
.45282 .17338 m
.45282 .17338 L
s
.45289 .17644 m
.45289 .17644 L
s
.45297 .16939 m
.45297 .16939 L
s
.45304 .1715 m
.45304 .1715 L
s
.45312 .17784 m
.45312 .17784 L
s
.45319 .17315 m
.45319 .17315 L
s
.45327 .17127 m
.45327 .17127 L
s
.45334 .16986 m
.45334 .16986 L
s
.45342 .16422 m
.45342 .16422 L
s
.45349 .16704 m
.45349 .16704 L
s
.45357 .16281 m
.45357 .16281 L
s
.45364 .16422 m
.45364 .16422 L
s
.45371 .16375 m
.45371 .16375 L
s
.45379 .16634 m
.45379 .16634 L
s
.45386 .16586 m
.45386 .16586 L
s
.45394 .16492 m
.45394 .16492 L
s
.45401 .16399 m
.45401 .16399 L
s
.45409 .1607 m
.45409 .1607 L
s
.45416 .15976 m
.45416 .15976 L
s
.45424 .16258 m
.45424 .16258 L
s
.45431 .16634 m
.45431 .16634 L
s
.45438 .16634 m
.45438 .16634 L
s
.45445 .16469 m
.45445 .16469 L
s
.45453 .16492 m
.45453 .16492 L
s
.4546 .16821 m
.4546 .16821 L
s
.45468 .16563 m
.45468 .16563 L
s
.45475 .16963 m
.45475 .16963 L
s
.45483 .16634 m
.45483 .16634 L
s
.4549 .16634 m
.4549 .16634 L
s
.45497 .17197 m
.45497 .17197 L
s
.45505 .17667 m
.45505 .17667 L
s
.45513 .18184 m
.45513 .18184 L
s
.4552 .18489 m
.4552 .18489 L
s
.45527 .18348 m
.45527 .18348 L
s
.45535 .18701 m
.45535 .18701 L
s
.45542 .19405 m
.45542 .19405 L
s
.4555 .18771 m
.4555 .18771 L
s
.45557 .18301 m
.45557 .18301 L
s
.45565 .18301 m
.45565 .18301 L
s
.45572 .18113 m
.45572 .18113 L
s
.45579 .17549 m
.45579 .17549 L
s
.45587 .17878 m
.45587 .17878 L
s
.45595 .17902 m
.45595 .17902 L
s
.45601 .17973 m
.45601 .17973 L
s
.45609 .17291 m
.45609 .17291 L
s
.45616 .17127 m
.45616 .17127 L
s
.45624 .17432 m
.45624 .17432 L
s
.45631 .17103 m
.45631 .17103 L
s
.45639 .16821 m
.45639 .16821 L
s
.45646 .16915 m
.45646 .16915 L
s
.45654 .16845 m
.45654 .16845 L
s
.4566 .16868 m
.4566 .16868 L
s
.45668 .17338 m
.45668 .17338 L
s
.45676 .17855 m
.45676 .17855 L
s
.45683 .1802 m
.45683 .1802 L
s
.45691 .17738 m
.45691 .17738 L
s
.45698 .17127 m
.45698 .17127 L
s
.45706 .17362 m
.45706 .17362 L
s
.45713 .17784 m
.45713 .17784 L
s
.45721 .18043 m
.45721 .18043 L
s
.45728 .18419 m
.45728 .18419 L
s
.45735 .18701 m
.45735 .18701 L
s
.45742 .18137 m
.45742 .18137 L
s
.4575 .18301 m
.4575 .18301 L
s
.45758 .18395 m
.45758 .18395 L
s
.45765 .18066 m
.45765 .18066 L
s
.45772 .18184 m
.45772 .18184 L
s
.4578 .18325 m
.4578 .18325 L
s
.45787 .17925 m
.45787 .17925 L
s
.45795 .18184 m
.45795 .18184 L
s
.45802 .17573 m
.45802 .17573 L
s
.4581 .17291 m
.4581 .17291 L
s
.45817 .18254 m
.45817 .18254 L
s
.45824 .18419 m
.45824 .18419 L
s
.45832 .17902 m
.45832 .17902 L
s
.45839 .17315 m
.45839 .17315 L
s
.45847 .16986 m
.45847 .16986 L
s
.45854 .16328 m
.45854 .16328 L
s
.45862 .15036 m
.45862 .15036 L
s
.45869 .15248 m
.45869 .15248 L
s
.45877 .14825 m
.45877 .14825 L
s
.45884 .14661 m
.45884 .14661 L
s
.45892 .14143 m
.45892 .14143 L
s
.45898 .14308 m
.45898 .14308 L
s
.45906 .13439 m
.45906 .13439 L
s
.45913 .1358 m
.45913 .1358 L
s
.45921 .13697 m
.45921 .13697 L
s
.45928 .13933 m
.45928 .13933 L
s
.45936 .14402 m
.45936 .14402 L
s
.45943 .14754 m
.45943 .14754 L
s
.45951 .14895 m
.45951 .14895 L
s
.45958 .14943 m
.45958 .14943 L
s
.45966 .152 m
.45966 .152 L
s
.45973 .14496 m
.45973 .14496 L
s
.4598 .14825 m
.4598 .14825 L
s
.45988 .15435 m
.45988 .15435 L
s
.45995 .14848 m
.45995 .14848 L
s
.46003 .14801 m
.46003 .14801 L
s
.4601 .1412 m
.4601 .1412 L
s
.46018 .14285 m
.46018 .14285 L
s
.46025 .13838 m
.46025 .13838 L
s
.46033 .14519 m
.46033 .14519 L
s
.4604 .14614 m
.4604 .14614 L
s
.46048 .14332 m
.46048 .14332 L
s
.46055 .13697 m
.46055 .13697 L
s
.46062 .13533 m
.46062 .13533 L
s
.46069 .13205 m
.46069 .13205 L
s
.46077 .1358 m
.46077 .1358 L
s
.46084 .13791 m
.46084 .13791 L
s
.46092 .13686 m
.46092 .13686 L
s
.46099 .13392 m
.46099 .13392 L
s
.46107 .13298 m
.46107 .13298 L
s
.46114 .13533 m
.46114 .13533 L
s
.46122 .13651 m
.46122 .13651 L
s
.46129 .14297 m
.46129 .14297 L
s
.46137 .14484 m
.46137 .14484 L
s
.46144 .14778 m
.46144 .14778 L
s
.46151 .14696 m
.46151 .14696 L
s
.46159 .14367 m
.46159 .14367 L
s
.46166 .14332 m
.46166 .14332 L
s
.46174 .14437 m
.46174 .14437 L
s
.46181 .14954 m
.46181 .14954 L
s
.46189 .14661 m
.46189 .14661 L
s
.46196 .14966 m
.46196 .14966 L
s
.46204 .14567 m
.46204 .14567 L
s
.46211 .14226 m
.46211 .14226 L
s
.46218 .14684 m
.46218 .14684 L
s
.46225 .14332 m
.46225 .14332 L
s
.46233 .1486 m
.46233 .1486 L
s
.4624 .14085 m
.4624 .14085 L
s
.46248 .13756 m
.46248 .13756 L
s
.46255 .14143 m
.46255 .14143 L
s
.46263 .14343 m
.46263 .14343 L
s
.4627 .1419 m
.4627 .1419 L
s
.46278 .14202 m
.46278 .14202 L
s
.46285 .14437 m
.46285 .14437 L
s
.46293 .14661 m
.46293 .14661 L
s
.463 .15224 m
.463 .15224 L
s
.46307 .1513 m
.46307 .1513 L
s
.46315 .15318 m
.46315 .15318 L
s
.46322 .15612 m
.46322 .15612 L
s
.4633 .154 m
.4633 .154 L
s
.46337 .14637 m
.46337 .14637 L
s
.46345 .14919 m
.46345 .14919 L
s
.46352 .14261 m
.46352 .14261 L
s
.46359 .13944 m
.46359 .13944 L
s
.46367 .14097 m
.46367 .14097 L
s
.46375 .14261 m
.46375 .14261 L
s
.46381 .13674 m
.46381 .13674 L
s
.46389 .13991 m
.46389 .13991 L
s
.46396 .13322 m
.46396 .13322 L
s
.46404 .13298 m
.46404 .13298 L
s
.46411 .14343 m
.46411 .14343 L
s
.46419 .14003 m
.46419 .14003 L
s
.46426 .14238 m
.46426 .14238 L
s
.46434 .14637 m
.46434 .14637 L
s
.46441 .14143 m
.46441 .14143 L
s
.46449 .14355 m
.46449 .14355 L
s
.46457 .14472 m
.46457 .14472 L
s
.46463 .14461 m
.46463 .14461 L
s
.46471 .14285 m
.46471 .14285 L
s
.46478 .14554 m
.46478 .14554 L
s
.46486 .14661 m
.46486 .14661 L
s
.46493 .1506 m
.46493 .1506 L
s
.46501 .15013 m
.46501 .15013 L
s
.46508 .15165 m
.46508 .15165 L
s
.46515 .15624 m
.46515 .15624 L
s
.46522 .15671 m
.46522 .15671 L
s
.4653 .16117 m
.4653 .16117 L
s
.46538 .16539 m
.46538 .16539 L
s
.46545 .16258 m
.46545 .16258 L
s
.46552 .15941 m
.46552 .15941 L
s
.4656 .16328 m
.4656 .16328 L
s
.46567 .16492 m
.46567 .16492 L
s
.46575 .16622 m
.46575 .16622 L
s
.46582 .16246 m
.46582 .16246 L
s
.4659 .16469 m
.4659 .16469 L
s
.46597 .16963 m
.46597 .16963 L
s
.46604 .17397 m
.46604 .17397 L
s
.46612 .17549 m
.46612 .17549 L
s
.4662 .18395 m
.4662 .18395 L
s
.46627 .18559 m
.46627 .18559 L
s
.46634 .18477 m
.46634 .18477 L
s
.46642 .18865 m
.46642 .18865 L
s
.46649 .17479 m
.46649 .17479 L
s
.46657 .17925 m
.46657 .17925 L
s
.46664 .18043 m
.46664 .18043 L
s
.46672 .1836 m
.46672 .1836 L
s
.46678 .18219 m
.46678 .18219 L
s
.46686 .1762 m
.46686 .1762 L
s
.46693 .17925 m
.46693 .17925 L
s
.46701 .18043 m
.46701 .18043 L
s
.46708 .18055 m
.46708 .18055 L
s
.46716 .18277 m
.46716 .18277 L
s
.46723 .17784 m
.46723 .17784 L
s
.46731 .18066 m
.46731 .18066 L
s
.46738 .17902 m
.46738 .17902 L
s
.46746 .17655 m
.46746 .17655 L
s
.46753 .17409 m
.46753 .17409 L
s
.4676 .17561 m
.4676 .17561 L
s
.46768 .17973 m
.46768 .17973 L
s
.46775 .18677 m
.46775 .18677 L
s
.46783 .18642 m
.46783 .18642 L
s
.4679 .18783 m
.4679 .18783 L
s
.46798 .1816 m
.46798 .1816 L
s
.46805 .18654 m
.46805 .18654 L
s
.46813 .18372 m
.46813 .18372 L
s
.4682 .1782 m
.4682 .1782 L
s
.46828 .18148 m
.46828 .18148 L
s
.46835 .1823 m
.46835 .1823 L
s
.46842 .17644 m
.46842 .17644 L
s
.46849 .17973 m
.46849 .17973 L
s
.46857 .18325 m
.46857 .18325 L
s
.46864 .18594 m
.46864 .18594 L
s
.46872 .18794 m
.46872 .18794 L
s
.46879 .1843 m
.46879 .1843 L
s
.46887 .18736 m
.46887 .18736 L
s
.46894 .18031 m
.46894 .18031 L
s
.46902 .18195 m
.46902 .18195 L
s
.46909 .18277 m
.46909 .18277 L
s
.46917 .19053 m
.46917 .19053 L
s
.46924 .18994 m
.46924 .18994 L
s
.46931 .18724 m
.46931 .18724 L
s
.46939 .18548 m
.46939 .18548 L
s
.46946 .17726 m
.46946 .17726 L
s
.46954 .18184 m
.46954 .18184 L
s
.46961 .17973 m
.46961 .17973 L
s
.46969 .18113 m
.46969 .18113 L
s
.46976 .17761 m
.46976 .17761 L
s
.46984 .17691 m
.46984 .17691 L
s
.46991 .18254 m
.46991 .18254 L
s
.46998 .18148 m
.46998 .18148 L
s
.47005 .18923 m
.47005 .18923 L
s
.47013 .18876 m
.47013 .18876 L
s
.4702 .19276 m
.4702 .19276 L
s
.47028 .19676 m
.47028 .19676 L
s
.47035 .19875 m
.47035 .19875 L
s
.47043 .20016 m
.47043 .20016 L
s
.4705 .19933 m
.4705 .19933 L
s
.47058 .19287 m
.47058 .19287 L
s
.47065 .19569 m
.47065 .19569 L
s
.47073 .19804 m
.47073 .19804 L
s
.4708 .19616 m
.4708 .19616 L
s
.47087 .19711 m
.47087 .19711 L
s
.47095 .19429 m
.47095 .19429 L
s
.47102 .19335 m
.47102 .19335 L
s
.4711 .19499 m
.4711 .19499 L
s
.47117 .19604 m
.47117 .19604 L
s
.47125 .20861 m
.47125 .20861 L
s
.47132 .21026 m
.47132 .21026 L
s
.4714 .20908 m
.4714 .20908 L
s
.47147 .21731 m
.47147 .21731 L
s
.47155 .22165 m
.47155 .22165 L
s
.47162 .22506 m
.47162 .22506 L
s
.47169 .23045 m
.47169 .23045 L
s
.47176 .23551 m
.47176 .23551 L
s
.47184 .24396 m
.47184 .24396 L
s
.47191 .24455 m
.47191 .24455 L
s
.47199 .24725 m
.47199 .24725 L
s
.47206 .24549 m
.47206 .24549 L
s
.47214 .24467 m
.47214 .24467 L
s
.47221 .24995 m
.47221 .24995 L
s
.47229 .2496 m
.47229 .2496 L
s
.47237 .24843 m
.47237 .24843 L
s
.47243 .24666 m
.47243 .24666 L
s
.47251 .24326 m
.47251 .24326 L
s
.47258 .23727 m
.47258 .23727 L
s
.47266 .24009 m
.47266 .24009 L
s
.47273 .23868 m
.47273 .23868 L
s
.47281 .24103 m
.47281 .24103 L
s
.47288 .24549 m
.47288 .24549 L
s
.47295 .24537 m
.47295 .24537 L
s
.47303 .24995 m
.47303 .24995 L
s
.47311 .25347 m
.47311 .25347 L
s
.47318 .25347 m
.47318 .25347 L
s
.47325 .2617 m
.47325 .2617 L
s
.47332 .2671 m
.47332 .2671 L
s
.4734 .27074 m
.4734 .27074 L
s
.47347 .2678 m
.47347 .2678 L
s
.47355 .2745 m
.47355 .2745 L
s
.47362 .27908 m
.47362 .27908 L
s
.4737 .28002 m
.4737 .28002 L
s
.47377 .28413 m
.47377 .28413 L
s
.47384 .28636 m
.47384 .28636 L
s
.47392 .28331 m
.47392 .28331 L
s
.474 .27967 m
.474 .27967 L
s
.47407 .28037 m
.47407 .28037 L
s
.47414 .28296 m
.47414 .28296 L
s
.47422 .28788 m
.47422 .28788 L
s
.47429 .28495 m
.47429 .28495 L
s
.47437 .28777 m
.47437 .28777 L
s
.47444 .2873 m
.47444 .2873 L
s
.47452 .28765 m
.47452 .28765 L
s
.47459 .29235 m
.47459 .29235 L
s
.47466 .28213 m
.47466 .28213 L
s
.47474 .27838 m
.47474 .27838 L
s
.47481 .27802 m
.47481 .27802 L
s
.47488 .27485 m
.47488 .27485 L
s
.47496 .27227 m
.47496 .27227 L
s
.47503 .26616 m
.47503 .26616 L
s
.47511 .26628 m
.47511 .26628 L
s
.47518 .26863 m
.47518 .26863 L
s
.47526 .26123 m
.47526 .26123 L
s
.47533 .25723 m
.47533 .25723 L
s
.4754 .26487 m
.4754 .26487 L
s
.47548 .26099 m
.47548 .26099 L
s
.47555 .26205 m
.47555 .26205 L
s
.47563 .25794 m
.47563 .25794 L
s
.4757 .25876 m
.4757 .25876 L
s
.47578 .25865 m
.47578 .25865 L
s
.47585 .26135 m
.47585 .26135 L
s
.47593 .25489 m
.47593 .25489 L
s
.476 .25489 m
.476 .25489 L
s
.47608 .26264 m
.47608 .26264 L
s
.47615 .26147 m
.47615 .26147 L
s
.47622 .26816 m
.47622 .26816 L
s
.47629 .26863 m
.47629 .26863 L
s
.47637 .27062 m
.47637 .27062 L
s
.47645 .27133 m
.47645 .27133 L
s
.47652 .2718 m
.47652 .2718 L
s
.47659 .27356 m
.47659 .27356 L
s
.47667 .27003 m
.47667 .27003 L
s
.47674 .26828 m
.47674 .26828 L
s
.47682 .2705 m
.47682 .2705 L
s
.47689 .27274 m
.47689 .27274 L
s
.47697 .28202 m
.47697 .28202 L
s
.47704 .28589 m
.47704 .28589 L
s
.47711 .28706 m
.47711 .28706 L
s
.47719 .28542 m
.47719 .28542 L
s
.47726 .28378 m
.47726 .28378 L
s
.47734 .27896 m
.47734 .27896 L
s
.47741 .27579 m
.47741 .27579 L
s
.47749 .27731 m
.47749 .27731 L
s
.47756 .28025 m
.47756 .28025 L
s
.47764 .27743 m
.47764 .27743 L
s
.47771 .27814 m
.47771 .27814 L
s
.47778 .2671 m
.47778 .2671 L
s
.47785 .27274 m
.47785 .27274 L
s
.47793 .27344 m
.47793 .27344 L
s
.478 .27285 m
.478 .27285 L
s
.47808 .27474 m
.47808 .27474 L
s
.47815 .27274 m
.47815 .27274 L
s
.47823 .27603 m
.47823 .27603 L
s
.4783 .27685 m
.4783 .27685 L
s
.47838 .27603 m
.47838 .27603 L
s
.47845 .27474 m
.47845 .27474 L
s
.47853 .27485 m
.47853 .27485 L
s
.4786 .26616 m
.4786 .26616 L
s
.47867 .26322 m
.47867 .26322 L
s
.47875 .27015 m
.47875 .27015 L
s
.47882 .26616 m
.47882 .26616 L
s
.4789 .26017 m
.4789 .26017 L
s
.47897 .25512 m
.47897 .25512 L
s
.47905 .25501 m
.47905 .25501 L
s
.47912 .26111 m
.47912 .26111 L
s
.4792 .26675 m
.4792 .26675 L
s
.47927 .26193 m
.47927 .26193 L
s
.47935 .26393 m
.47935 .26393 L
s
.47942 .25641 m
.47942 .25641 L
s
.47949 .25723 m
.47949 .25723 L
s
.47956 .25524 m
.47956 .25524 L
s
.47964 .25254 m
.47964 .25254 L
s
.47971 .24925 m
.47971 .24925 L
s
.47979 .25207 m
.47979 .25207 L
s
.47986 .2469 m
.47986 .2469 L
s
.47994 .24561 m
.47994 .24561 L
s
.48001 .2503 m
.48001 .2503 L
s
.48009 .24737 m
.48009 .24737 L
s
.48017 .24596 m
.48017 .24596 L
s
.48023 .23845 m
.48023 .23845 L
s
.48031 .24103 m
.48031 .24103 L
s
.48038 .23997 m
.48038 .23997 L
s
.48046 .23845 m
.48046 .23845 L
s
.48053 .24479 m
.48053 .24479 L
s
.48061 .24502 m
.48061 .24502 L
s
.48068 .24843 m
.48068 .24843 L
s
.48075 .24537 m
.48075 .24537 L
s
.48083 .2469 m
.48083 .2469 L
s
.48091 .25172 m
.48091 .25172 L
s
.48098 .25665 m
.48098 .25665 L
s
.48105 .26475 m
.48105 .26475 L
s
.48112 .26264 m
.48112 .26264 L
s
.4812 .26334 m
.4812 .26334 L
s
.48127 .25489 m
.48127 .25489 L
s
.48135 .25207 m
.48135 .25207 L
s
.48142 .25019 m
.48142 .25019 L
s
.4815 .25019 m
.4815 .25019 L
s
.48157 .25324 m
.48157 .25324 L
s
.48165 .25688 m
.48165 .25688 L
s
.48173 .25771 m
.48173 .25771 L
s
.4818 .25465 m
.4818 .25465 L
s
.48187 .25641 m
.48187 .25641 L
s
.48194 .25771 m
.48194 .25771 L
s
.48202 .25665 m
.48202 .25665 L
s
.48209 .25065 m
.48209 .25065 L
s
.48217 .25324 m
.48217 .25324 L
s
.48224 .26005 m
.48224 .26005 L
s
.48232 .26193 m
.48232 .26193 L
s
.48239 .26346 m
.48239 .26346 L
s
.48246 .25641 m
.48246 .25641 L
s
.48254 .26087 m
.48254 .26087 L
s
.48261 .257 m
.48261 .257 L
s
.48268 .2624 m
.48268 .2624 L
s
.48276 .26123 m
.48276 .26123 L
s
.48283 .25982 m
.48283 .25982 L
s
.48291 .25641 m
.48291 .25641 L
s
.48298 .26052 m
.48298 .26052 L
s
.48306 .25993 m
.48306 .25993 L
s
.48313 .25982 m
.48313 .25982 L
s
.4832 .25806 m
.4832 .25806 L
s
.48328 .26604 m
.48328 .26604 L
s
.48336 .26487 m
.48336 .26487 L
s
.48343 .26299 m
.48343 .26299 L
s
.4835 .26522 m
.4835 .26522 L
s
.48358 .26522 m
.48358 .26522 L
s
.48365 .26264 m
.48365 .26264 L
s
.48373 .26616 m
.48373 .26616 L
s
.4838 .26992 m
.4838 .26992 L
s
.48388 .26992 m
.48388 .26992 L
s
.48395 .27239 m
.48395 .27239 L
s
.48402 .27062 m
.48402 .27062 L
s
.48409 .26546 m
.48409 .26546 L
s
.48417 .26416 m
.48417 .26416 L
s
.48425 .26921 m
.48425 .26921 L
s
.48432 .27556 m
.48432 .27556 L
s
.48439 .27743 m
.48439 .27743 L
s
.48447 .27767 m
.48447 .27767 L
s
.48454 .28119 m
.48454 .28119 L
s
.48462 .27896 m
.48462 .27896 L
s
.48469 .27838 m
.48469 .27838 L
s
.48477 .28131 m
.48477 .28131 L
s
.48484 .28272 m
.48484 .28272 L
s
.48491 .28296 m
.48491 .28296 L
s
.48499 .27626 m
.48499 .27626 L
s
.48506 .27556 m
.48506 .27556 L
s
.48514 .27438 m
.48514 .27438 L
s
.48521 .27403 m
.48521 .27403 L
s
.48529 .27521 m
.48529 .27521 L
s
.48536 .27638 m
.48536 .27638 L
s
.48544 .26992 m
.48544 .26992 L
s
.48551 .27274 m
.48551 .27274 L
s
.48558 .27027 m
.48558 .27027 L
s
.48565 .26299 m
.48565 .26299 L
s
.48573 .26452 m
.48573 .26452 L
s
.4858 .26487 m
.4858 .26487 L
s
.48588 .26475 m
.48588 .26475 L
s
.48595 .26569 m
.48595 .26569 L
s
.48603 .26005 m
.48603 .26005 L
s
.4861 .25865 m
.4861 .25865 L
s
.48618 .24843 m
.48618 .24843 L
s
.48625 .24666 m
.48625 .24666 L
s
.48633 .24337 m
.48633 .24337 L
s
.4864 .24573 m
.4864 .24573 L
s
.48647 .23786 m
.48647 .23786 L
s
.48655 .24337 m
.48655 .24337 L
s
.48662 .24373 m
.48662 .24373 L
s
.4867 .24666 m
.4867 .24666 L
s
.48677 .24737 m
.48677 .24737 L
s
.48685 .25477 m
.48685 .25477 L
s
.48692 .257 m
.48692 .257 L
s
.487 .25301 m
.487 .25301 L
s
.48707 .26052 m
.48707 .26052 L
s
.48715 .26123 m
.48715 .26123 L
s
.48722 .25583 m
.48722 .25583 L
s
.48729 .25383 m
.48729 .25383 L
s
.48736 .2503 m
.48736 .2503 L
s
.48744 .24773 m
.48744 .24773 L
s
.48751 .24713 m
.48751 .24713 L
s
.48759 .25113 m
.48759 .25113 L
s
.48766 .24831 m
.48766 .24831 L
s
.48774 .24561 m
.48774 .24561 L
s
.48781 .2415 m
.48781 .2415 L
s
.48789 .24408 m
.48789 .24408 L
s
.48797 .23891 m
.48797 .23891 L
s
.48803 .23809 m
.48803 .23809 L
s
.48811 .2388 m
.48811 .2388 L
s
.48818 .24514 m
.48818 .24514 L
s
.48826 .23422 m
.48826 .23422 L
s
.48833 .23351 m
.48833 .23351 L
s
.48841 .23422 m
.48841 .23422 L
s
.48848 .23633 m
.48848 .23633 L
s
.48856 .23516 m
.48856 .23516 L
s
.48863 .22788 m
.48863 .22788 L
s
.48871 .22776 m
.48871 .22776 L
s
.48878 .22341 m
.48878 .22341 L
s
.48885 .22928 m
.48885 .22928 L
s
.48892 .22541 m
.48892 .22541 L
s
.489 .22776 m
.489 .22776 L
s
.48907 .22717 m
.48907 .22717 L
s
.48915 .22646 m
.48915 .22646 L
s
.48922 .22646 m
.48922 .22646 L
s
.4893 .22459 m
.4893 .22459 L
s
.48937 .22658 m
.48937 .22658 L
s
.48945 .22741 m
.48945 .22741 L
s
.48953 .2348 m
.48953 .2348 L
s
.4896 .23045 m
.4896 .23045 L
s
.48967 .23281 m
.48967 .23281 L
s
.48974 .23187 m
.48974 .23187 L
s
.48982 .2341 m
.48982 .2341 L
s
.48989 .23539 m
.48989 .23539 L
s
.48997 .23234 m
.48997 .23234 L
s
.49004 .23187 m
.49004 .23187 L
s
.49012 .2321 m
.49012 .2321 L
s
.49019 .23656 m
.49019 .23656 L
s
.49027 .2314 m
.49027 .2314 L
s
.49034 .23563 m
.49034 .23563 L
s
.49041 .23938 m
.49041 .23938 L
s
.49048 .23316 m
.49048 .23316 L
s
.49056 .23551 m
.49056 .23551 L
s
.49063 .24561 m
.49063 .24561 L
s
.49071 .2469 m
.49071 .2469 L
s
.49078 .24455 m
.49078 .24455 L
s
.49086 .24173 m
.49086 .24173 L
s
.49093 .24138 m
.49093 .24138 L
s
.491 .23927 m
.491 .23927 L
s
.49108 .23845 m
.49108 .23845 L
s
.49116 .2415 m
.49116 .2415 L
s
.49123 .23691 m
.49123 .23691 L
s
.4913 .2368 m
.4913 .2368 L
s
.49138 .23856 m
.49138 .23856 L
s
.49145 .2368 m
.49145 .2368 L
s
.49153 .23703 m
.49153 .23703 L
s
.4916 .24055 m
.4916 .24055 L
s
.49168 .23985 m
.49168 .23985 L
s
.49175 .23422 m
.49175 .23422 L
s
.49182 .23938 m
.49182 .23938 L
s
.4919 .23245 m
.4919 .23245 L
s
.49198 .23962 m
.49198 .23962 L
s
.49205 .24209 m
.49205 .24209 L
s
.49212 .24561 m
.49212 .24561 L
s
.49219 .24291 m
.49219 .24291 L
s
.49227 .24643 m
.49227 .24643 L
s
.49234 .24009 m
.49234 .24009 L
s
.49242 .24349 m
.49242 .24349 L
s
.49249 .23997 m
.49249 .23997 L
s
.49257 .24197 m
.49257 .24197 L
s
.49264 .24232 m
.49264 .24232 L
s
.49271 .24067 m
.49271 .24067 L
s
.49279 .24291 m
.49279 .24291 L
s
.49286 .24831 m
.49286 .24831 L
s
.49294 .24737 m
.49294 .24737 L
s
.49301 .25054 m
.49301 .25054 L
s
.49309 .25148 m
.49309 .25148 L
s
.49316 .24878 m
.49316 .24878 L
s
.49324 .25019 m
.49324 .25019 L
s
.49331 .24831 m
.49331 .24831 L
s
.49338 .24843 m
.49338 .24843 L
s
.49345 .25583 m
.49345 .25583 L
s
.49353 .25125 m
.49353 .25125 L
s
.49361 .25195 m
.49361 .25195 L
s
.49368 .24678 m
.49368 .24678 L
s
.49375 .24444 m
.49375 .24444 L
s
.49383 .24396 m
.49383 .24396 L
s
.4939 .24596 m
.4939 .24596 L
s
.49398 .24596 m
.49398 .24596 L
s
.49405 .2523 m
.49405 .2523 L
s
.49413 .25489 m
.49413 .25489 L
s
.4942 .26428 m
.4942 .26428 L
s
.49427 .26229 m
.49427 .26229 L
s
.49435 .26428 m
.49435 .26428 L
s
.49442 .26593 m
.49442 .26593 L
s
.4945 .26534 m
.4945 .26534 L
s
.49457 .26217 m
.49457 .26217 L
s
.49465 .2604 m
.49465 .2604 L
s
.49472 .26029 m
.49472 .26029 L
s
.4948 .25911 m
.4948 .25911 L
s
.49487 .26804 m
.49487 .26804 L
s
.49495 .27097 m
.49495 .27097 L
s
.49502 .26675 m
.49502 .26675 L
s
.49509 .26816 m
.49509 .26816 L
s
.49516 .26863 m
.49516 .26863 L
s
.49524 .26439 m
.49524 .26439 L
s
.49531 .25771 m
.49531 .25771 L
s
.49539 .25783 m
.49539 .25783 L
s
.49546 .26052 m
.49546 .26052 L
s
.49554 .26499 m
.49554 .26499 L
s
.49561 .26511 m
.49561 .26511 L
s
.49569 .25606 m
.49569 .25606 L
s
.49577 .25371 m
.49577 .25371 L
s
.49583 .25113 m
.49583 .25113 L
s
.49591 .25242 m
.49591 .25242 L
s
.49598 .24608 m
.49598 .24608 L
s
.49606 .25336 m
.49606 .25336 L
s
.49613 .2509 m
.49613 .2509 L
s
.49621 .25653 m
.49621 .25653 L
s
.49628 .25207 m
.49628 .25207 L
s
.49636 .25723 m
.49636 .25723 L
s
.49643 .26123 m
.49643 .26123 L
s
.49651 .27062 m
.49651 .27062 L
s
.49658 .27591 m
.49658 .27591 L
s
.49665 .27485 m
.49665 .27485 L
s
.49672 .27661 m
.49672 .27661 L
s
.4968 .28131 m
.4968 .28131 L
s
.49687 .28519 m
.49687 .28519 L
s
.49695 .27414 m
.49695 .27414 L
s
.49702 .27157 m
.49702 .27157 L
s
.4971 .27391 m
.4971 .27391 L
s
.49717 .27309 m
.49717 .27309 L
s
.49725 .26757 m
.49725 .26757 L
s
.49733 .26287 m
.49733 .26287 L
s
.4974 .26299 m
.4974 .26299 L
s
.49747 .26404 m
.49747 .26404 L
s
.49754 .25512 m
.49754 .25512 L
s
.49762 .25853 m
.49762 .25853 L
s
.49769 .26264 m
.49769 .26264 L
s
.49777 .25841 m
.49777 .25841 L
s
.49784 .25301 m
.49784 .25301 L
s
.49792 .25019 m
.49792 .25019 L
s
.49799 .25442 m
.49799 .25442 L
s
.49807 .2617 m
.49807 .2617 L
s
.49814 .25747 m
.49814 .25747 L
s
.49821 .26616 m
.49821 .26616 L
s
.49828 .26334 m
.49828 .26334 L
s
.49836 .26663 m
.49836 .26663 L
s
.49843 .26804 m
.49843 .26804 L
s
.49851 .26804 m
.49851 .26804 L
s
.49858 .26557 m
.49858 .26557 L
s
.49866 .26968 m
.49866 .26968 L
s
.49873 .26698 m
.49873 .26698 L
s
.49881 .27015 m
.49881 .27015 L
s
.49889 .27074 m
.49889 .27074 L
s
.49896 .26828 m
.49896 .26828 L
s
.49903 .27121 m
.49903 .27121 L
s
.4991 .2725 m
.4991 .2725 L
s
.49918 .2718 m
.49918 .2718 L
s
.49925 .27802 m
.49925 .27802 L
s
.49933 .28319 m
.49933 .28319 L
s
.4994 .28601 m
.4994 .28601 L
s
.49948 .29294 m
.49948 .29294 L
s
.49955 .30257 m
.49955 .30257 L
s
.49962 .30421 m
.49962 .30421 L
s
.4997 .30386 m
.4997 .30386 L
s
.49978 .29893 m
.49978 .29893 L
s
.49985 .3021 m
.49985 .3021 L
s
.49992 .30903 m
.49992 .30903 L
s
.49999 .30468 m
.49999 .30468 L
s
.50007 .3028 m
.50007 .3028 L
s
.50014 .30621 m
.50014 .30621 L
s
.50022 .31161 m
.50022 .31161 L
s
.50029 .31184 m
.50029 .31184 L
s
.50037 .31948 m
.50037 .31948 L
s
.50044 .32042 m
.50044 .32042 L
s
.50052 .327 m
.50052 .327 L
s
.5006 .32511 m
.5006 .32511 L
s
.50066 .32864 m
.50066 .32864 L
s
.50074 .32993 m
.50074 .32993 L
s
.50081 .32688 m
.50081 .32688 L
s
.50089 .32312 m
.50089 .32312 L
s
.50096 .32441 m
.50096 .32441 L
s
.50104 .32394 m
.50104 .32394 L
s
.50111 .32828 m
.50111 .32828 L
s
.50118 .32418 m
.50118 .32418 L
s
.50125 .32418 m
.50125 .32418 L
s
.50133 .33264 m
.50133 .33264 L
s
.50141 .3277 m
.50141 .3277 L
s
.50148 .32629 m
.50148 .32629 L
s
.50155 .32206 m
.50155 .32206 L
s
.50163 .32511 m
.50163 .32511 L
s
.5017 .32089 m
.5017 .32089 L
s
.50178 .32124 m
.50178 .32124 L
s
.50185 .32206 m
.50185 .32206 L
s
.50193 .32347 m
.50193 .32347 L
s
.502 .32136 m
.502 .32136 L
s
.50207 .32347 m
.50207 .32347 L
s
.50215 .32089 m
.50215 .32089 L
s
.50223 .32476 m
.50223 .32476 L
s
.5023 .33486 m
.5023 .33486 L
s
.50237 .33698 m
.50237 .33698 L
s
.50245 .33733 m
.50245 .33733 L
s
.50252 .33346 m
.50252 .33346 L
s
.5026 .33568 m
.5026 .33568 L
s
.50267 .33521 m
.50267 .33521 L
s
.50275 .3385 m
.50275 .3385 L
s
.50282 .33792 m
.50282 .33792 L
s
.50289 .33005 m
.50289 .33005 L
s
.50296 .33275 m
.50296 .33275 L
s
.50304 .3351 m
.50304 .3351 L
s
.50311 .33005 m
.50311 .33005 L
s
.50319 .33322 m
.50319 .33322 L
s
.50326 .3277 m
.50326 .3277 L
s
.50334 .33357 m
.50334 .33357 L
s
.50341 .33475 m
.50341 .33475 L
s
.50349 .33428 m
.50349 .33428 L
s
.50357 .33733 m
.50357 .33733 L
s
.50363 .33545 m
.50363 .33545 L
s
.50371 .33451 m
.50371 .33451 L
s
.50378 .33334 m
.50378 .33334 L
s
.50386 .33146 m
.50386 .33146 L
s
.50393 .3284 m
.50393 .3284 L
s
.50401 .33017 m
.50401 .33017 L
s
.50408 .33592 m
.50408 .33592 L
s
.50416 .3351 m
.50416 .3351 L
s
.50423 .33463 m
.50423 .33463 L
s
.50431 .32923 m
.50431 .32923 L
s
.50438 .33909 m
.50438 .33909 L
s
.50445 .33968 m
.50445 .33968 L
s
.50452 .33686 m
.50452 .33686 L
s
.5046 .33909 m
.5046 .33909 L
s
.50467 .33756 m
.50467 .33756 L
s
.50475 .33745 m
.50475 .33745 L
s
.50482 .33792 m
.50482 .33792 L
s
.5049 .33252 m
.5049 .33252 L
s
.50497 .33428 m
.50497 .33428 L
s
.50505 .33663 m
.50505 .33663 L
s
.50513 .32864 m
.50513 .32864 L
s
.5052 .33381 m
.5052 .33381 L
s
.50527 .33169 m
.50527 .33169 L
s
.50534 .33005 m
.50534 .33005 L
s
.50542 .33157 m
.50542 .33157 L
s
.50549 .32899 m
.50549 .32899 L
s
.50557 .3331 m
.50557 .3331 L
s
.50564 .33756 m
.50564 .33756 L
s
.50572 .34003 m
.50572 .34003 L
s
.50579 .34461 m
.50579 .34461 L
s
.50587 .34626 m
.50587 .34626 L
s
.50594 .34156 m
.50594 .34156 L
s
.50602 .34262 m
.50602 .34262 L
s
.50608 .34755 m
.50608 .34755 L
s
.50616 .35084 m
.50616 .35084 L
s
.50623 .35331 m
.50623 .35331 L
s
.50631 .35765 m
.50631 .35765 L
s
.50638 .36176 m
.50638 .36176 L
s
.50646 .36152 m
.50646 .36152 L
s
.50653 .36211 m
.50653 .36211 L
s
.50661 .35471 m
.50661 .35471 L
s
.50669 .35965 m
.50669 .35965 L
s
.50676 .35965 m
.50676 .35965 L
s
.50683 .3573 m
.50683 .3573 L
s
.5069 .36293 m
.5069 .36293 L
s
.50698 .35518 m
.50698 .35518 L
s
.50705 .35765 m
.50705 .35765 L
s
.50713 .35154 m
.50713 .35154 L
s
.5072 .35037 m
.5072 .35037 L
s
.50728 .35331 m
.50728 .35331 L
s
.50735 .35331 m
.50735 .35331 L
s
.50743 .35331 m
.50743 .35331 L
s
.5075 .35401 m
.5075 .35401 L
s
.50758 .35565 m
.50758 .35565 L
s
.50765 .35718 m
.50765 .35718 L
s
.50772 .356 m
.50772 .356 L
s
.50779 .35495 m
.50779 .35495 L
s
.50787 .36187 m
.50787 .36187 L
s
.50794 .36129 m
.50794 .36129 L
s
.50802 .35917 m
.50802 .35917 L
s
.50809 .35882 m
.50809 .35882 L
s
.50817 .34766 m
.50817 .34766 L
s
.50824 .34496 m
.50824 .34496 L
s
.50832 .34813 m
.50832 .34813 L
s
.5084 .34508 m
.5084 .34508 L
s
.50846 .3459 m
.50846 .3459 L
s
.50854 .35518 m
.50854 .35518 L
s
.50861 .35659 m
.50861 .35659 L
s
.50869 .35448 m
.50869 .35448 L
s
.50876 .35565 m
.50876 .35565 L
s
.50884 .35952 m
.50884 .35952 L
s
.50891 .35131 m
.50891 .35131 L
s
.50899 .34978 m
.50899 .34978 L
s
.50906 .34673 m
.50906 .34673 L
s
.50914 .35048 m
.50914 .35048 L
s
.50921 .34943 m
.50921 .34943 L
s
.50928 .35424 m
.50928 .35424 L
s
.50935 .36423 m
.50935 .36423 L
s
.50943 .37139 m
.50943 .37139 L
s
.5095 .36845 m
.5095 .36845 L
s
.50958 .36387 m
.50958 .36387 L
s
.50965 .36751 m
.50965 .36751 L
s
.50973 .36951 m
.50973 .36951 L
s
.5098 .3674 m
.5098 .3674 L
s
.50987 .3681 m
.50987 .3681 L
s
.50995 .37033 m
.50995 .37033 L
s
.51003 .37397 m
.51003 .37397 L
s
.5101 .37914 m
.5101 .37914 L
s
.51017 .37937 m
.51017 .37937 L
s
.51025 .37961 m
.51025 .37961 L
s
.51032 .37691 m
.51032 .37691 L
s
.5104 .37186 m
.5104 .37186 L
s
.51047 .37303 m
.51047 .37303 L
s
.51055 .37033 m
.51055 .37033 L
s
.51062 .36716 m
.51062 .36716 L
s
.51069 .37221 m
.51069 .37221 L
s
.51077 .37585 m
.51077 .37585 L
s
.51085 .37726 m
.51085 .37726 L
s
.51091 .37585 m
.51091 .37585 L
s
.51099 .3775 m
.51099 .3775 L
s
.51106 .3775 m
.51106 .3775 L
s
.51114 .37855 m
.51114 .37855 L
s
.51121 .3762 m
.51121 .3762 L
s
.51129 .38219 m
.51129 .38219 L
s
.51137 .38478 m
.51137 .38478 L
s
.51143 .389 m
.51143 .389 L
s
.51151 .38313 m
.51151 .38313 L
s
.51158 .38149 m
.51158 .38149 L
s
.51166 .38501 m
.51166 .38501 L
s
.51173 .38196 m
.51173 .38196 L
s
.51181 .37937 m
.51181 .37937 L
s
.51188 .37726 m
.51188 .37726 L
s
.51196 .37632 m
.51196 .37632 L
s
.51203 .37456 m
.51203 .37456 L
s
.51211 .37608 m
.51211 .37608 L
s
.51218 .37597 m
.51218 .37597 L
s
.51225 .36869 m
.51225 .36869 L
s
.51232 .37186 m
.51232 .37186 L
s
.5124 .36892 m
.5124 .36892 L
s
.51248 .36575 m
.51248 .36575 L
s
.51255 .36246 m
.51255 .36246 L
s
.51262 .36493 m
.51262 .36493 L
s
.5127 .36763 m
.5127 .36763 L
s
.51277 .37291 m
.51277 .37291 L
s
.51285 .37972 m
.51285 .37972 L
s
.51293 .38219 m
.51293 .38219 L
s
.513 .3809 m
.513 .3809 L
s
.51307 .38736 m
.51307 .38736 L
s
.51314 .38947 m
.51314 .38947 L
s
.51322 .38607 m
.51322 .38607 L
s
.51329 .3876 m
.51329 .3876 L
s
.51337 .38678 m
.51337 .38678 L
s
.51344 .38407 m
.51344 .38407 L
s
.51352 .38266 m
.51352 .38266 L
s
.51359 .38043 m
.51359 .38043 L
s
.51367 .37092 m
.51367 .37092 L
s
.51374 .37186 m
.51374 .37186 L
s
.51382 .37339 m
.51382 .37339 L
s
.51388 .36915 m
.51388 .36915 L
s
.51396 .37374 m
.51396 .37374 L
s
.51403 .36974 m
.51403 .36974 L
s
.51411 .37843 m
.51411 .37843 L
s
.51418 .37867 m
.51418 .37867 L
s
.51426 .37573 m
.51426 .37573 L
s
.51433 .37561 m
.51433 .37561 L
s
.51441 .37362 m
.51441 .37362 L
s
.51449 .37115 m
.51449 .37115 L
s
.51456 .36763 m
.51456 .36763 L
s
.51463 .36152 m
.51463 .36152 L
s
.5147 .36305 m
.5147 .36305 L
s
.51478 .35941 m
.51478 .35941 L
s
.51485 .35753 m
.51485 .35753 L
s
.51493 .36458 m
.51493 .36458 L
s
.515 .36376 m
.515 .36376 L
s
.51508 .36458 m
.51508 .36458 L
s
.51515 .36423 m
.51515 .36423 L
s
.51523 .36681 m
.51523 .36681 L
s
.5153 .36469 m
.5153 .36469 L
s
.51538 .36904 m
.51538 .36904 L
s
.51545 .37197 m
.51545 .37197 L
s
.51552 .37715 m
.51552 .37715 L
s
.51559 .37937 m
.51559 .37937 L
s
.51567 .38137 m
.51567 .38137 L
s
.51574 .38008 m
.51574 .38008 L
s
.51582 .38161 m
.51582 .38161 L
s
.51589 .38513 m
.51589 .38513 L
s
.51597 .38501 m
.51597 .38501 L
s
.51604 .38079 m
.51604 .38079 L
s
.51612 .38043 m
.51612 .38043 L
s
.5162 .3856 m
.5162 .3856 L
s
.51626 .37997 m
.51626 .37997 L
s
.51634 .37738 m
.51634 .37738 L
s
.51641 .37479 m
.51641 .37479 L
s
.51649 .38266 m
.51649 .38266 L
s
.51656 .38254 m
.51656 .38254 L
s
.51664 .3856 m
.51664 .3856 L
s
.51671 .39511 m
.51671 .39511 L
s
.51679 .39488 m
.51679 .39488 L
s
.51686 .40145 m
.51686 .40145 L
s
.51694 .39793 m
.51694 .39793 L
s
.51701 .39699 m
.51701 .39699 L
s
.51708 .3984 m
.51708 .3984 L
s
.51715 .39863 m
.51715 .39863 L
s
.51723 .39371 m
.51723 .39371 L
s
.5173 .39687 m
.5173 .39687 L
s
.51738 .40157 m
.51738 .40157 L
s
.51745 .40474 m
.51745 .40474 L
s
.51753 .3977 m
.51753 .3977 L
s
.5176 .40486 m
.5176 .40486 L
s
.51767 .40627 m
.51767 .40627 L
s
.51775 .4132 m
.51775 .4132 L
s
.51783 .4132 m
.51783 .4132 L
s
.5179 .40827 m
.5179 .40827 L
s
.51797 .40897 m
.51797 .40897 L
s
.51805 .40662 m
.51805 .40662 L
s
.51812 .40991 m
.51812 .40991 L
s
.5182 .41073 m
.5182 .41073 L
s
.51827 .41191 m
.51827 .41191 L
s
.51835 .40239 m
.51835 .40239 L
s
.51842 .40274 m
.51842 .40274 L
s
.51849 .40662 m
.51849 .40662 L
s
.51857 .40498 m
.51857 .40498 L
s
.51865 .39957 m
.51865 .39957 L
s
.51871 .39699 m
.51871 .39699 L
s
.51879 .39981 m
.51879 .39981 L
s
.51886 .39617 m
.51886 .39617 L
s
.51894 .39852 m
.51894 .39852 L
s
.51901 .40404 m
.51901 .40404 L
s
.51909 .39969 m
.51909 .39969 L
s
.51917 .40486 m
.51917 .40486 L
s
.51923 .40463 m
.51923 .40463 L
s
.51931 .41273 m
.51931 .41273 L
s
.51939 .40768 m
.51939 .40768 L
s
.51946 .41038 m
.51946 .41038 L
s
.51953 .41202 m
.51953 .41202 L
s
.51961 .41062 m
.51961 .41062 L
s
.51968 .41249 m
.51968 .41249 L
s
.51976 .41496 m
.51976 .41496 L
s
.51983 .41402 m
.51983 .41402 L
s
.51991 .41848 m
.51991 .41848 L
s
.51998 .41801 m
.51998 .41801 L
s
.52005 .41578 m
.52005 .41578 L
s
.52012 .41942 m
.52012 .41942 L
s
.5202 .42095 m
.5202 .42095 L
s
.52028 .42823 m
.52028 .42823 L
s
.52035 .42259 m
.52035 .42259 L
s
.52042 .42154 m
.52042 .42154 L
s
.5205 .41473 m
.5205 .41473 L
s
.52057 .41273 m
.52057 .41273 L
s
.52065 .41343 m
.52065 .41343 L
s
.52073 .41449 m
.52073 .41449 L
s
.5208 .41743 m
.5208 .41743 L
s
.52087 .42059 m
.52087 .42059 L
s
.52094 .42341 m
.52094 .42341 L
s
.52102 .42166 m
.52102 .42166 L
s
.52109 .4193 m
.52109 .4193 L
s
.52117 .41743 m
.52117 .41743 L
s
.52124 .41884 m
.52124 .41884 L
s
.52132 .41813 m
.52132 .41813 L
s
.52139 .41813 m
.52139 .41813 L
s
.52147 .42294 m
.52147 .42294 L
s
.52154 .42059 m
.52154 .42059 L
s
.52162 .4152 m
.52162 .4152 L
s
.52168 .41366 m
.52168 .41366 L
s
.52176 .41484 m
.52176 .41484 L
s
.52183 .41426 m
.52183 .41426 L
s
.52191 .4078 m
.52191 .4078 L
s
.52198 .40451 m
.52198 .40451 L
s
.52206 .40404 m
.52206 .40404 L
s
.52213 .40756 m
.52213 .40756 L
s
.52221 .4051 m
.52221 .4051 L
s
.52229 .40885 m
.52229 .40885 L
s
.52236 .41202 m
.52236 .41202 L
s
.52243 .41919 m
.52243 .41919 L
s
.5225 .42471 m
.5225 .42471 L
s
.52258 .41977 m
.52258 .41977 L
s
.52265 .41132 m
.52265 .41132 L
s
.52273 .41249 m
.52273 .41249 L
s
.5228 .4092 m
.5228 .4092 L
s
.52288 .40662 m
.52288 .40662 L
s
.52295 .40756 m
.52295 .40756 L
s
.52303 .40498 m
.52303 .40498 L
s
.5231 .40709 m
.5231 .40709 L
s
.52318 .40674 m
.52318 .40674 L
s
.52325 .40662 m
.52325 .40662 L
s
.52332 .40709 m
.52332 .40709 L
s
.52339 .40791 m
.52339 .40791 L
s
.52347 .40498 m
.52347 .40498 L
s
.52354 .40192 m
.52354 .40192 L
s
.52362 .40028 m
.52362 .40028 L
s
.52369 .40075 m
.52369 .40075 L
s
.52377 .40286 m
.52377 .40286 L
s
.52385 .39922 m
.52385 .39922 L
s
.52392 .40568 m
.52392 .40568 L
s
.524 .41109 m
.524 .41109 L
s
.52406 .41273 m
.52406 .41273 L
s
.52414 .41167 m
.52414 .41167 L
s
.52421 .4159 m
.52421 .4159 L
s
.52429 .41778 m
.52429 .41778 L
s
.52436 .41766 m
.52436 .41766 L
s
.52444 .41977 m
.52444 .41977 L
s
.52451 .41731 m
.52451 .41731 L
s
.52459 .41672 m
.52459 .41672 L
s
.52466 .41801 m
.52466 .41801 L
s
.52474 .4152 m
.52474 .4152 L
s
.52481 .40838 m
.52481 .40838 L
s
.52488 .40932 m
.52488 .40932 L
s
.52495 .40662 m
.52495 .40662 L
s
.52503 .40615 m
.52503 .40615 L
s
.5251 .40827 m
.5251 .40827 L
s
.52518 .41755 m
.52518 .41755 L
s
.52525 .41531 m
.52525 .41531 L
s
.52533 .41414 m
.52533 .41414 L
s
.5254 .41578 m
.5254 .41578 L
s
.52548 .40862 m
.52548 .40862 L
s
.52556 .40368 m
.52556 .40368 L
s
.52563 .39969 m
.52563 .39969 L
s
.5257 .39992 m
.5257 .39992 L
s
.52577 .39488 m
.52577 .39488 L
s
.52585 .39981 m
.52585 .39981 L
s
.52592 .40192 m
.52592 .40192 L
s
.526 .39746 m
.526 .39746 L
s
.52607 .40004 m
.52607 .40004 L
s
.52615 .39535 m
.52615 .39535 L
s
.52622 .38536 m
.52622 .38536 L
s
.52629 .38289 m
.52629 .38289 L
s
.52637 .38642 m
.52637 .38642 L
s
.52645 .38935 m
.52645 .38935 L
s
.52651 .39476 m
.52651 .39476 L
s
.52659 .39406 m
.52659 .39406 L
s
.52666 .39182 m
.52666 .39182 L
s
.52674 .39206 m
.52674 .39206 L
s
.52681 .38982 m
.52681 .38982 L
s
.52689 .39535 m
.52689 .39535 L
s
.52697 .3984 m
.52697 .3984 L
s
.52703 .39441 m
.52703 .39441 L
s
.52711 .39264 m
.52711 .39264 L
s
.52719 .3883 m
.52719 .3883 L
s
.52726 .38266 m
.52726 .38266 L
s
.52733 .38396 m
.52733 .38396 L
s
.52741 .38431 m
.52741 .38431 L
s
.52748 .38665 m
.52748 .38665 L
s
.52756 .38266 m
.52756 .38266 L
s
.52763 .38254 m
.52763 .38254 L
s
.52771 .37961 m
.52771 .37961 L
s
.52778 .37386 m
.52778 .37386 L
s
.52785 .37561 m
.52785 .37561 L
s
.52792 .37291 m
.52792 .37291 L
s
.528 .37209 m
.528 .37209 L
s
.52808 .37409 m
.52808 .37409 L
s
.52815 .37444 m
.52815 .37444 L
s
.52822 .37151 m
.52822 .37151 L
s
.5283 .37162 m
.5283 .37162 L
s
.52837 .36998 m
.52837 .36998 L
s
.52845 .37468 m
.52845 .37468 L
s
.52853 .3775 m
.52853 .3775 L
s
.5286 .38032 m
.5286 .38032 L
s
.52867 .37256 m
.52867 .37256 L
s
.52874 .36705 m
.52874 .36705 L
s
.52882 .37186 m
.52882 .37186 L
s
.52889 .36775 m
.52889 .36775 L
s
.52897 .3708 m
.52897 .3708 L
s
.52904 .3654 m
.52904 .3654 L
s
.52912 .36915 m
.52912 .36915 L
s
.52919 .35905 m
.52919 .35905 L
s
.52927 .35541 m
.52927 .35541 L
s
.52934 .35588 m
.52934 .35588 L
s
.52942 .35331 m
.52942 .35331 L
s
.52948 .35648 m
.52948 .35648 L
s
.52956 .35541 m
.52956 .35541 L
s
.52963 .35788 m
.52963 .35788 L
s
.52971 .35753 m
.52971 .35753 L
s
.52978 .3573 m
.52978 .3573 L
s
.52986 .36411 m
.52986 .36411 L
s
.52993 .37585 m
.52993 .37585 L
s
.53001 .37843 m
.53001 .37843 L
s
.53009 .38231 m
.53009 .38231 L
s
.53016 .37526 m
.53016 .37526 L
s
.53023 .37773 m
.53023 .37773 L
s
.5303 .37433 m
.5303 .37433 L
s
.53038 .37397 m
.53038 .37397 L
s
.53045 .36293 m
.53045 .36293 L
s
.53053 .35588 m
.53053 .35588 L
s
.5306 .35401 m
.5306 .35401 L
s
.53068 .35518 m
.53068 .35518 L
s
.53075 .35401 m
.53075 .35401 L
s
.53083 .35612 m
.53083 .35612 L
s
.5309 .35659 m
.5309 .35659 L
s
.53098 .358 m
.53098 .358 L
s
.53105 .35976 m
.53105 .35976 L
s
.53112 .36246 m
.53112 .36246 L
s
.53119 .36105 m
.53119 .36105 L
s
.53127 .35929 m
.53127 .35929 L
s
.53134 .35988 m
.53134 .35988 L
s
.53142 .358 m
.53142 .358 L
s
.53149 .35189 m
.53149 .35189 L
s
.53157 .35471 m
.53157 .35471 L
s
.53165 .35072 m
.53165 .35072 L
s
.53172 .34696 m
.53172 .34696 L
s
.5318 .34755 m
.5318 .34755 L
s
.53186 .34895 m
.53186 .34895 L
s
.53194 .35013 m
.53194 .35013 L
s
.53201 .35483 m
.53201 .35483 L
s
.53209 .34602 m
.53209 .34602 L
s
.53216 .34262 m
.53216 .34262 L
s
.53224 .34262 m
.53224 .34262 L
s
.53231 .33733 m
.53231 .33733 L
s
.53239 .33968 m
.53239 .33968 L
s
.53246 .3432 m
.53246 .3432 L
s
.53254 .33651 m
.53254 .33651 L
s
.53261 .33216 m
.53261 .33216 L
s
.53268 .33346 m
.53268 .33346 L
s
.53275 .33181 m
.53275 .33181 L
s
.53283 .33369 m
.53283 .33369 L
s
.5329 .32746 m
.5329 .32746 L
s
.53298 .31818 m
.53298 .31818 L
s
.53305 .32265 m
.53305 .32265 L
s
.53313 .32606 m
.53313 .32606 L
s
.5332 .32453 m
.5332 .32453 L
s
.53328 .32171 m
.53328 .32171 L
s
.53336 .31713 m
.53336 .31713 L
s
.53343 .3203 m
.53343 .3203 L
s
.5335 .32265 m
.5335 .32265 L
s
.53357 .31995 m
.53357 .31995 L
s
.53365 .31443 m
.53365 .31443 L
s
.53372 .31466 m
.53372 .31466 L
s
.5338 .31572 m
.5338 .31572 L
s
.53387 .32324 m
.53387 .32324 L
s
.53395 .31643 m
.53395 .31643 L
s
.53402 .31901 m
.53402 .31901 L
s
.5341 .31713 m
.5341 .31713 L
s
.53417 .31267 m
.53417 .31267 L
s
.53425 .30832 m
.53425 .30832 L
s
.53431 .30762 m
.53431 .30762 L
s
.53439 .30069 m
.53439 .30069 L
s
.53446 .30491 m
.53446 .30491 L
s
.53454 .30421 m
.53454 .30421 L
s
.53461 .31349 m
.53461 .31349 L
s
.53469 .3122 m
.53469 .3122 L
s
.53477 .31431 m
.53477 .31431 L
s
.53483 .31232 m
.53483 .31232 L
s
.53491 .31361 m
.53491 .31361 L
s
.53499 .3129 m
.53499 .3129 L
s
.53506 .31372 m
.53506 .31372 L
s
.53513 .31032 m
.53513 .31032 L
s
.53521 .31279 m
.53521 .31279 L
s
.53528 .31361 m
.53528 .31361 L
s
.53536 .31055 m
.53536 .31055 L
s
.53543 .31408 m
.53543 .31408 L
s
.53551 .323 m
.53551 .323 L
s
.53558 .323 m
.53558 .323 L
s
.53565 .32018 m
.53565 .32018 L
s
.53573 .31725 m
.53573 .31725 L
s
.53581 .31748 m
.53581 .31748 L
s
.53588 .31384 m
.53588 .31384 L
s
.53595 .3122 m
.53595 .3122 L
s
.53602 .3102 m
.53602 .3102 L
s
.5361 .30844 m
.5361 .30844 L
s
.53617 .3149 m
.53617 .3149 L
s
.53625 .3129 m
.53625 .3129 L
s
.53633 .3122 m
.53633 .3122 L
s
.5364 .31044 m
.5364 .31044 L
s
.53647 .31384 m
.53647 .31384 L
s
.53654 .31596 m
.53654 .31596 L
s
.53662 .31619 m
.53662 .31619 L
s
.53669 .31948 m
.53669 .31948 L
s
.53677 .32007 m
.53677 .32007 L
s
.53684 .32136 m
.53684 .32136 L
s
.53692 .32007 m
.53692 .32007 L
s
.53699 .31748 m
.53699 .31748 L
s
.53707 .31501 m
.53707 .31501 L
s
.53714 .31172 m
.53714 .31172 L
s
.53722 .31079 m
.53722 .31079 L
s
.53728 .31267 m
.53728 .31267 L
s
.53736 .30926 m
.53736 .30926 L
s
.53744 .30891 m
.53744 .30891 L
s
.53751 .31361 m
.53751 .31361 L
s
.53758 .31795 m
.53758 .31795 L
s
.53766 .3129 m
.53766 .3129 L
s
.53773 .31783 m
.53773 .31783 L
s
.53781 .32124 m
.53781 .32124 L
s
.53789 .32206 m
.53789 .32206 L
s
.53796 .31877 m
.53796 .31877 L
s
.53803 .31901 m
.53803 .31901 L
s
.5381 .32124 m
.5381 .32124 L
s
.53818 .31431 m
.53818 .31431 L
s
.53825 .32018 m
.53825 .32018 L
s
.53833 .321 m
.53833 .321 L
s
.5384 .31525 m
.5384 .31525 L
s
.53848 .31372 m
.53848 .31372 L
s
.53855 .30973 m
.53855 .30973 L
s
.53863 .31419 m
.53863 .31419 L
s
.5387 .3129 m
.5387 .3129 L
s
.53878 .31279 m
.53878 .31279 L
s
.53885 .30703 m
.53885 .30703 L
s
.53892 .30327 m
.53892 .30327 L
s
.53899 .30421 m
.53899 .30421 L
s
.53907 .30398 m
.53907 .30398 L
s
.53914 .30409 m
.53914 .30409 L
s
.53922 .30398 m
.53922 .30398 L
s
.53929 .30187 m
.53929 .30187 L
s
.53937 .30151 m
.53937 .30151 L
s
.53945 .30022 m
.53945 .30022 L
s
.53952 .29306 m
.53952 .29306 L
s
.5396 .28706 m
.5396 .28706 L
s
.53966 .29152 m
.53966 .29152 L
s
.53974 .29141 m
.53974 .29141 L
s
.53981 .28671 m
.53981 .28671 L
s
.53989 .2873 m
.53989 .2873 L
s
.53996 .29552 m
.53996 .29552 L
s
.54004 .29317 m
.54004 .29317 L
s
.54011 .29881 m
.54011 .29881 L
s
.54019 .28906 m
.54019 .28906 L
s
.54026 .28718 m
.54026 .28718 L
s
.54034 .28542 m
.54034 .28542 L
s
.54041 .29458 m
.54041 .29458 L
s
.54048 .29364 m
.54048 .29364 L
s
.54055 .29247 m
.54055 .29247 L
s
.54063 .30069 m
.54063 .30069 L
s
.5407 .2974 m
.5407 .2974 L
s
.54078 .29564 m
.54078 .29564 L
s
.54085 .29 m
.54085 .29 L
s
.54093 .2927 m
.54093 .2927 L
s
.54101 .29481 m
.54101 .29481 L
s
.54108 .29881 m
.54108 .29881 L
s
.54116 .29728 m
.54116 .29728 L
s
.54123 .29434 m
.54123 .29434 L
s
.5413 .29646 m
.5413 .29646 L
s
.54137 .30269 m
.54137 .30269 L
s
.54145 .29858 m
.54145 .29858 L
s
.54152 .29822 m
.54152 .29822 L
s
.5416 .30151 m
.5416 .30151 L
s
.54167 .30092 m
.54167 .30092 L
s
.54175 .30245 m
.54175 .30245 L
s
.54182 .30162 m
.54182 .30162 L
s
.5419 .30656 m
.5419 .30656 L
s
.54197 .30562 m
.54197 .30562 L
s
.54205 .3122 m
.54205 .3122 L
s
.54211 .31244 m
.54211 .31244 L
s
.54219 .31678 m
.54219 .31678 L
s
.54226 .31525 m
.54226 .31525 L
s
.54234 .31244 m
.54234 .31244 L
s
.54241 .31126 m
.54241 .31126 L
s
.54249 .3075 m
.54249 .3075 L
s
.54257 .3082 m
.54257 .3082 L
s
.54264 .30668 m
.54264 .30668 L
s
.54272 .31149 m
.54272 .31149 L
s
.54279 .30726 m
.54279 .30726 L
s
.54286 .30844 m
.54286 .30844 L
s
.54293 .30703 m
.54293 .30703 L
s
.54301 .30598 m
.54301 .30598 L
s
.54308 .30915 m
.54308 .30915 L
s
.54316 .31149 m
.54316 .31149 L
s
.54323 .31478 m
.54323 .31478 L
s
.54331 .31901 m
.54331 .31901 L
s
.54338 .31279 m
.54338 .31279 L
s
.54345 .3122 m
.54345 .3122 L
s
.54353 .3169 m
.54353 .3169 L
s
.54361 .32594 m
.54361 .32594 L
s
.54368 .33028 m
.54368 .33028 L
s
.54375 .33064 m
.54375 .33064 L
s
.54382 .33945 m
.54382 .33945 L
s
.5439 .33933 m
.5439 .33933 L
s
.54397 .3331 m
.54397 .3331 L
s
.54405 .33616 m
.54405 .33616 L
s
.54413 .33815 m
.54413 .33815 L
s
.5442 .33956 m
.5442 .33956 L
s
.54427 .3405 m
.54427 .3405 L
s
.54435 .34309 m
.54435 .34309 L
s
.54443 .34473 m
.54443 .34473 L
s
.54449 .3412 m
.54449 .3412 L
s
.54457 .34038 m
.54457 .34038 L
s
.54464 .34003 m
.54464 .34003 L
s
.54472 .34297 m
.54472 .34297 L
s
.54479 .3412 m
.54479 .3412 L
s
.54487 .34684 m
.54487 .34684 L
s
.54494 .34403 m
.54494 .34403 L
s
.54502 .34543 m
.54502 .34543 L
s
.54508 .33639 m
.54508 .33639 L
s
.54516 .3385 m
.54516 .3385 L
s
.54524 .34109 m
.54524 .34109 L
s
.54531 .34062 m
.54531 .34062 L
s
.54538 .34062 m
.54538 .34062 L
s
.54546 .33581 m
.54546 .33581 L
s
.54553 .34097 m
.54553 .34097 L
s
.54561 .35002 m
.54561 .35002 L
s
.54569 .35413 m
.54569 .35413 L
s
.54576 .35683 m
.54576 .35683 L
s
.54583 .35483 m
.54583 .35483 L
s
.5459 .35259 m
.5459 .35259 L
s
.54598 .34931 m
.54598 .34931 L
s
.54606 .35025 m
.54606 .35025 L
s
.54613 .3506 m
.54613 .3506 L
s
.5462 .35495 m
.5462 .35495 L
s
.54628 .35413 m
.54628 .35413 L
s
.54635 .35319 m
.54635 .35319 L
s
.54643 .35072 m
.54643 .35072 L
s
.5465 .35189 m
.5465 .35189 L
s
.54658 .35213 m
.54658 .35213 L
s
.54665 .34895 m
.54665 .34895 L
s
.54672 .34837 m
.54672 .34837 L
s
.54679 .34602 m
.54679 .34602 L
s
.54687 .35401 m
.54687 .35401 L
s
.54694 .3553 m
.54694 .3553 L
s
.54702 .35424 m
.54702 .35424 L
s
.54709 .35671 m
.54709 .35671 L
s
.54717 .36152 m
.54717 .36152 L
s
.54725 .36364 m
.54725 .36364 L
s
.54732 .36658 m
.54732 .36658 L
s
.5474 .36012 m
.5474 .36012 L
s
.54746 .35952 m
.54746 .35952 L
s
.54754 .35718 m
.54754 .35718 L
s
.54761 .35636 m
.54761 .35636 L
s
.54769 .35718 m
.54769 .35718 L
s
.54776 .35436 m
.54776 .35436 L
s
.54784 .35648 m
.54784 .35648 L
s
.54791 .35436 m
.54791 .35436 L
s
.54799 .35483 m
.54799 .35483 L
s
.54806 .34743 m
.54806 .34743 L
s
.54814 .35072 m
.54814 .35072 L
s
.54821 .34567 m
.54821 .34567 L
s
.54828 .34743 m
.54828 .34743 L
s
.54835 .34766 m
.54835 .34766 L
s
.54843 .34249 m
.54843 .34249 L
s
.5485 .33815 m
.5485 .33815 L
s
.54858 .33885 m
.54858 .33885 L
s
.54865 .34015 m
.54865 .34015 L
s
.54873 .34485 m
.54873 .34485 L
s
.54881 .34167 m
.54881 .34167 L
s
.54888 .34179 m
.54888 .34179 L
s
.54896 .34356 m
.54896 .34356 L
s
.54903 .34156 m
.54903 .34156 L
s
.5491 .34179 m
.5491 .34179 L
s
.54917 .33803 m
.54917 .33803 L
s
.54925 .34649 m
.54925 .34649 L
s
.54932 .34884 m
.54932 .34884 L
s
.5494 .34907 m
.5494 .34907 L
s
.54947 .34778 m
.54947 .34778 L
s
.54955 .35259 m
.54955 .35259 L
s
.54962 .35189 m
.54962 .35189 L
s
.5497 .34391 m
.5497 .34391 L
s
.54977 .34508 m
.54977 .34508 L
s
.54985 .34285 m
.54985 .34285 L
s
.54991 .3405 m
.54991 .3405 L
s
.54999 .33686 m
.54999 .33686 L
s
.55006 .34249 m
.55006 .34249 L
s
.55014 .3385 m
.55014 .3385 L
s
.55021 .33686 m
.55021 .33686 L
s
.55029 .33275 m
.55029 .33275 L
s
.55037 .32758 m
.55037 .32758 L
s
.55044 .32828 m
.55044 .32828 L
s
.55052 .32618 m
.55052 .32618 L
s
.55059 .32899 m
.55059 .32899 L
s
.55066 .32982 m
.55066 .32982 L
s
.55073 .32571 m
.55073 .32571 L
s
.55081 .3324 m
.55081 .3324 L
s
.55088 .33099 m
.55088 .33099 L
s
.55096 .33017 m
.55096 .33017 L
s
.55103 .32993 m
.55103 .32993 L
s
.55111 .33017 m
.55111 .33017 L
s
.55118 .32558 m
.55118 .32558 L
s
.55126 .3223 m
.55126 .3223 L
s
.55133 .32182 m
.55133 .32182 L
s
.55141 .32324 m
.55141 .32324 L
s
.55148 .3196 m
.55148 .3196 L
s
.55155 .32089 m
.55155 .32089 L
s
.55162 .32347 m
.55162 .32347 L
s
.5517 .32394 m
.5517 .32394 L
s
.55177 .32758 m
.55177 .32758 L
s
.55185 .32875 m
.55185 .32875 L
s
.55193 .33146 m
.55193 .33146 L
s
.552 .33087 m
.552 .33087 L
s
.55207 .33334 m
.55207 .33334 L
s
.55215 .32641 m
.55215 .32641 L
s
.55223 .32735 m
.55223 .32735 L
s
.5523 .32629 m
.5523 .32629 L
s
.55237 .32982 m
.55237 .32982 L
s
.55244 .32911 m
.55244 .32911 L
s
.55252 .33216 m
.55252 .33216 L
s
.55259 .33028 m
.55259 .33028 L
s
.55267 .32089 m
.55267 .32089 L
s
.55274 .33146 m
.55274 .33146 L
s
.55282 .33028 m
.55282 .33028 L
s
.55289 .33122 m
.55289 .33122 L
s
.55297 .33228 m
.55297 .33228 L
s
.55304 .33275 m
.55304 .33275 L
s
.55311 .33216 m
.55311 .33216 L
s
.55318 .33557 m
.55318 .33557 L
s
.55326 .33357 m
.55326 .33357 L
s
.55333 .33369 m
.55333 .33369 L
s
.55341 .3371 m
.55341 .3371 L
s
.55349 .33334 m
.55349 .33334 L
s
.55356 .33346 m
.55356 .33346 L
s
.55363 .33369 m
.55363 .33369 L
s
.5537 .33521 m
.5537 .33521 L
s
.55378 .3371 m
.55378 .3371 L
s
.55386 .33827 m
.55386 .33827 L
s
.55393 .33463 m
.55393 .33463 L
s
.554 .33192 m
.554 .33192 L
s
.55408 .33428 m
.55408 .33428 L
s
.55415 .33628 m
.55415 .33628 L
s
.55423 .32982 m
.55423 .32982 L
s
.5543 .32887 m
.5543 .32887 L
s
.55438 .32664 m
.55438 .32664 L
s
.55445 .32688 m
.55445 .32688 L
s
.55452 .323 m
.55452 .323 L
s
.5546 .3183 m
.5546 .3183 L
s
.55468 .32018 m
.55468 .32018 L
s
.55474 .31596 m
.55474 .31596 L
s
.55482 .31172 m
.55482 .31172 L
s
.55489 .31865 m
.55489 .31865 L
s
.55497 .31736 m
.55497 .31736 L
s
.55505 .30891 m
.55505 .30891 L
s
.55512 .30985 m
.55512 .30985 L
s
.5552 .31126 m
.5552 .31126 L
s
.55527 .29998 m
.55527 .29998 L
s
.55534 .30045 m
.55534 .30045 L
s
.55541 .29893 m
.55541 .29893 L
s
.55549 .29881 m
.55549 .29881 L
s
.55556 .2967 m
.55556 .2967 L
s
.55564 .29623 m
.55564 .29623 L
s
.55571 .29552 m
.55571 .29552 L
s
.55579 .2967 m
.55579 .2967 L
s
.55586 .29763 m
.55586 .29763 L
s
.55594 .29012 m
.55594 .29012 L
s
.55601 .29658 m
.55601 .29658 L
s
.55608 .29282 m
.55608 .29282 L
s
.55615 .28495 m
.55615 .28495 L
s
.55623 .27309 m
.55623 .27309 L
s
.55631 .2671 m
.55631 .2671 L
s
.55638 .26793 m
.55638 .26793 L
s
.55645 .27192 m
.55645 .27192 L
s
.55653 .27003 m
.55653 .27003 L
s
.55661 .26369 m
.55661 .26369 L
s
.55668 .25911 m
.55668 .25911 L
s
.55676 .26816 m
.55676 .26816 L
s
.55683 .26581 m
.55683 .26581 L
s
.5569 .26252 m
.5569 .26252 L
s
.55697 .26311 m
.55697 .26311 L
s
.55705 .26522 m
.55705 .26522 L
s
.55712 .26945 m
.55712 .26945 L
s
.5572 .26698 m
.5572 .26698 L
s
.55727 .26828 m
.55727 .26828 L
s
.55735 .26898 m
.55735 .26898 L
s
.55742 .2718 m
.55742 .2718 L
s
.5575 .27673 m
.5575 .27673 L
s
.55757 .27168 m
.55757 .27168 L
s
.55765 .2745 m
.55765 .2745 L
s
.55771 .27297 m
.55771 .27297 L
s
.55779 .27521 m
.55779 .27521 L
s
.55786 .26968 m
.55786 .26968 L
s
.55794 .27438 m
.55794 .27438 L
s
.55801 .27978 m
.55801 .27978 L
s
.55809 .27826 m
.55809 .27826 L
s
.55817 .27767 m
.55817 .27767 L
s
.55824 .2745 m
.55824 .2745 L
s
.55832 .27097 m
.55832 .27097 L
s
.55839 .2691 m
.55839 .2691 L
s
.55846 .27368 m
.55846 .27368 L
s
.55853 .27321 m
.55853 .27321 L
s
.55861 .27755 m
.55861 .27755 L
s
.55868 .28002 m
.55868 .28002 L
s
.55876 .27873 m
.55876 .27873 L
s
.55883 .27626 m
.55883 .27626 L
s
.55891 .27344 m
.55891 .27344 L
s
.55898 .2725 m
.55898 .2725 L
s
.55906 .27157 m
.55906 .27157 L
s
.55913 .27015 m
.55913 .27015 L
s
.55921 .27109 m
.55921 .27109 L
s
.55928 .26593 m
.55928 .26593 L
s
.55935 .26569 m
.55935 .26569 L
s
.55942 .26499 m
.55942 .26499 L
s
.5595 .26005 m
.5595 .26005 L
s
.55957 .25723 m
.55957 .25723 L
s
.55965 .26581 m
.55965 .26581 L
s
.55973 .25841 m
.55973 .25841 L
s
.5598 .26111 m
.5598 .26111 L
s
.55988 .25935 m
.55988 .25935 L
s
.55995 .26252 m
.55995 .26252 L
s
.56003 .26745 m
.56003 .26745 L
s
.5601 .27414 m
.5601 .27414 L
s
.56017 .27661 m
.56017 .27661 L
s
.56024 .27368 m
.56024 .27368 L
s
.56032 .26475 m
.56032 .26475 L
s
.56039 .27203 m
.56039 .27203 L
s
.56047 .26945 m
.56047 .26945 L
s
.56054 .26616 m
.56054 .26616 L
s
.56062 .27157 m
.56062 .27157 L
s
.56069 .26933 m
.56069 .26933 L
s
.56077 .2678 m
.56077 .2678 L
s
.56084 .26768 m
.56084 .26768 L
s
.56091 .26452 m
.56091 .26452 L
s
.56098 .26311 m
.56098 .26311 L
s
.56106 .27157 m
.56106 .27157 L
s
.56113 .2725 m
.56113 .2725 L
s
.56121 .26616 m
.56121 .26616 L
s
.56129 .26499 m
.56129 .26499 L
s
.56136 .26452 m
.56136 .26452 L
s
.56143 .2624 m
.56143 .2624 L
s
.56151 .26404 m
.56151 .26404 L
s
.56159 .26593 m
.56159 .26593 L
s
.56166 .26839 m
.56166 .26839 L
s
.56173 .26921 m
.56173 .26921 L
s
.5618 .26733 m
.5618 .26733 L
s
.56188 .26499 m
.56188 .26499 L
s
.56195 .257 m
.56195 .257 L
s
.56203 .25406 m
.56203 .25406 L
s
.5621 .25865 m
.5621 .25865 L
s
.56218 .26322 m
.56218 .26322 L
s
.56225 .26733 m
.56225 .26733 L
s
.56232 .26651 m
.56232 .26651 L
s
.5624 .26229 m
.5624 .26229 L
s
.56248 .25818 m
.56248 .25818 L
s
.56254 .26464 m
.56254 .26464 L
s
.56262 .26135 m
.56262 .26135 L
s
.56269 .26464 m
.56269 .26464 L
s
.56277 .26123 m
.56277 .26123 L
s
.56285 .2597 m
.56285 .2597 L
s
.56292 .26475 m
.56292 .26475 L
s
.563 .2597 m
.563 .2597 L
s
.56307 .25865 m
.56307 .25865 L
s
.56314 .25418 m
.56314 .25418 L
s
.56322 .25665 m
.56322 .25665 L
s
.56329 .25771 m
.56329 .25771 L
s
.56336 .25688 m
.56336 .25688 L
s
.56344 .26428 m
.56344 .26428 L
s
.56351 .26264 m
.56351 .26264 L
s
.56359 .2718 m
.56359 .2718 L
s
.56366 .26921 m
.56366 .26921 L
s
.56374 .26663 m
.56374 .26663 L
s
.56381 .26428 m
.56381 .26428 L
s
.56388 .26804 m
.56388 .26804 L
s
.56395 .26428 m
.56395 .26428 L
s
.56403 .26593 m
.56403 .26593 L
s
.56411 .25794 m
.56411 .25794 L
s
.56418 .25465 m
.56418 .25465 L
s
.56425 .2523 m
.56425 .2523 L
s
.56433 .24972 m
.56433 .24972 L
s
.56441 .25254 m
.56441 .25254 L
s
.56448 .25465 m
.56448 .25465 L
s
.56456 .25735 m
.56456 .25735 L
s
.56463 .26111 m
.56463 .26111 L
s
.5647 .25653 m
.5647 .25653 L
s
.56477 .25347 m
.56477 .25347 L
s
.56485 .25289 m
.56485 .25289 L
s
.56493 .24808 m
.56493 .24808 L
s
.565 .25077 m
.565 .25077 L
s
.56507 .25301 m
.56507 .25301 L
s
.56515 .25113 m
.56515 .25113 L
s
.56522 .24866 m
.56522 .24866 L
s
.5653 .25688 m
.5653 .25688 L
s
.56537 .26005 m
.56537 .26005 L
s
.56545 .26182 m
.56545 .26182 L
s
.56551 .25641 m
.56551 .25641 L
s
.56559 .2617 m
.56559 .2617 L
s
.56566 .26217 m
.56566 .26217 L
s
.56574 .25853 m
.56574 .25853 L
s
.56581 .25747 m
.56581 .25747 L
s
.56589 .26757 m
.56589 .26757 L
s
.56597 .26569 m
.56597 .26569 L
s
.56604 .26357 m
.56604 .26357 L
s
.56612 .26381 m
.56612 .26381 L
s
.56619 .26639 m
.56619 .26639 L
s
.56626 .26075 m
.56626 .26075 L
s
.56633 .26581 m
.56633 .26581 L
s
.56641 .27003 m
.56641 .27003 L
s
.56648 .27391 m
.56648 .27391 L
s
.56656 .27074 m
.56656 .27074 L
s
.56663 .26264 m
.56663 .26264 L
s
.56671 .25876 m
.56671 .25876 L
s
.56678 .26005 m
.56678 .26005 L
s
.56686 .26686 m
.56686 .26686 L
s
.56693 .26639 m
.56693 .26639 L
s
.56701 .26393 m
.56701 .26393 L
s
.56708 .27027 m
.56708 .27027 L
s
.56715 .27614 m
.56715 .27614 L
s
.56722 .27062 m
.56722 .27062 L
s
.5673 .27332 m
.5673 .27332 L
s
.56737 .26898 m
.56737 .26898 L
s
.56745 .27227 m
.56745 .27227 L
s
.56753 .27509 m
.56753 .27509 L
s
.5676 .27039 m
.5676 .27039 L
s
.56768 .27414 m
.56768 .27414 L
s
.56775 .26957 m
.56775 .26957 L
s
.56783 .27379 m
.56783 .27379 L
s
.5679 .27814 m
.5679 .27814 L
s
.56797 .27778 m
.56797 .27778 L
s
.56804 .27168 m
.56804 .27168 L
s
.56812 .27532 m
.56812 .27532 L
s
.56819 .27673 m
.56819 .27673 L
s
.56827 .27778 m
.56827 .27778 L
s
.56834 .27755 m
.56834 .27755 L
s
.56842 .28167 m
.56842 .28167 L
s
.56849 .27661 m
.56849 .27661 L
s
.56857 .2819 m
.56857 .2819 L
s
.56864 .28718 m
.56864 .28718 L
s
.56871 .27978 m
.56871 .27978 L
s
.56878 .28072 m
.56878 .28072 L
s
.56886 .27978 m
.56886 .27978 L
s
.56893 .28249 m
.56893 .28249 L
s
.56901 .28167 m
.56901 .28167 L
s
.56909 .28142 m
.56909 .28142 L
s
.56916 .29012 m
.56916 .29012 L
s
.56923 .28542 m
.56923 .28542 L
s
.56931 .28167 m
.56931 .28167 L
s
.56939 .28237 m
.56939 .28237 L
s
.56946 .28202 m
.56946 .28202 L
s
.56953 .27967 m
.56953 .27967 L
s
.5696 .28072 m
.5696 .28072 L
s
.56968 .28072 m
.56968 .28072 L
s
.56975 .28167 m
.56975 .28167 L
s
.56983 .2806 m
.56983 .2806 L
s
.5699 .27685 m
.5699 .27685 L
s
.56998 .27614 m
.56998 .27614 L
s
.57005 .2671 m
.57005 .2671 L
s
.57013 .27544 m
.57013 .27544 L
s
.5702 .2718 m
.5702 .2718 L
s
.57028 .27062 m
.57028 .27062 L
s
.57034 .26875 m
.57034 .26875 L
s
.57042 .26522 m
.57042 .26522 L
s
.57049 .2705 m
.57049 .2705 L
s
.57057 .27227 m
.57057 .27227 L
s
.57065 .26945 m
.57065 .26945 L
s
.57072 .26921 m
.57072 .26921 L
s
.5708 .26921 m
.5708 .26921 L
s
.57087 .27003 m
.57087 .27003 L
s
.57094 .27379 m
.57094 .27379 L
s
.57102 .27414 m
.57102 .27414 L
s
.57109 .28072 m
.57109 .28072 L
s
.57116 .27826 m
.57116 .27826 L
s
.57124 .28342 m
.57124 .28342 L
s
.57131 .2799 m
.57131 .2799 L
s
.57139 .28471 m
.57139 .28471 L
s
.57146 .29517 m
.57146 .29517 L
s
.57154 .292 m
.57154 .292 L
s
.57161 .29787 m
.57161 .29787 L
s
.57168 .29634 m
.57168 .29634 L
s
.57176 .30022 m
.57176 .30022 L
s
.57184 .30198 m
.57184 .30198 L
s
.57191 .30691 m
.57191 .30691 L
s
.57198 .30656 m
.57198 .30656 L
s
.57205 .31208 m
.57205 .31208 L
s
.57213 .31279 m
.57213 .31279 L
s
.57221 .31267 m
.57221 .31267 L
s
.57228 .31501 m
.57228 .31501 L
s
.57236 .31196 m
.57236 .31196 L
s
.57243 .31995 m
.57243 .31995 L
s
.5725 .31783 m
.5725 .31783 L
s
.57257 .32124 m
.57257 .32124 L
s
.57265 .3169 m
.57265 .3169 L
s
.57273 .31772 m
.57273 .31772 L
s
.5728 .31372 m
.5728 .31372 L
s
.57287 .31772 m
.57287 .31772 L
s
.57295 .31549 m
.57295 .31549 L
s
.57302 .32054 m
.57302 .32054 L
s
.5731 .32723 m
.5731 .32723 L
s
.57317 .32641 m
.57317 .32641 L
s
.57325 .32606 m
.57325 .32606 L
s
.57331 .31666 m
.57331 .31666 L
s
.57339 .31454 m
.57339 .31454 L
s
.57347 .32112 m
.57347 .32112 L
s
.57354 .32042 m
.57354 .32042 L
s
.57361 .32089 m
.57361 .32089 L
s
.57369 .325 m
.57369 .325 L
s
.57377 .32159 m
.57377 .32159 L
s
.57384 .31901 m
.57384 .31901 L
s
.57392 .32112 m
.57392 .32112 L
s
.57399 .32182 m
.57399 .32182 L
s
.57406 .3176 m
.57406 .3176 L
s
.57413 .31561 m
.57413 .31561 L
s
.57421 .30962 m
.57421 .30962 L
s
.57428 .31783 m
.57428 .31783 L
s
.57436 .32112 m
.57436 .32112 L
s
.57443 .31678 m
.57443 .31678 L
s
.57451 .31525 m
.57451 .31525 L
s
.57458 .31314 m
.57458 .31314 L
s
.57466 .30468 m
.57466 .30468 L
s
.57473 .30773 m
.57473 .30773 L
s
.57481 .30398 m
.57481 .30398 L
s
.57488 .29881 m
.57488 .29881 L
s
.57495 .29411 m
.57495 .29411 L
s
.57502 .29129 m
.57502 .29129 L
s
.5751 .28577 m
.5751 .28577 L
s
.57517 .2893 m
.57517 .2893 L
s
.57525 .28941 m
.57525 .28941 L
s
.57533 .29399 m
.57533 .29399 L
s
.5754 .29306 m
.5754 .29306 L
s
.57548 .29587 m
.57548 .29587 L
s
.57555 .30198 m
.57555 .30198 L
s
.57563 .30374 m
.57563 .30374 L
s
.5757 .30668 m
.5757 .30668 L
s
.57577 .3109 m
.57577 .3109 L
s
.57584 .31478 m
.57584 .31478 L
s
.57592 .31279 m
.57592 .31279 L
s
.57599 .30855 m
.57599 .30855 L
s
.57607 .30257 m
.57607 .30257 L
s
.57614 .2981 m
.57614 .2981 L
s
.57622 .29399 m
.57622 .29399 L
s
.57629 .29693 m
.57629 .29693 L
s
.57637 .29775 m
.57637 .29775 L
s
.57644 .30234 m
.57644 .30234 L
s
.57651 .30316 m
.57651 .30316 L
s
.57658 .30621 m
.57658 .30621 L
s
.57666 .30374 m
.57666 .30374 L
s
.57673 .30269 m
.57673 .30269 L
s
.57681 .29752 m
.57681 .29752 L
s
.57689 .30222 m
.57689 .30222 L
s
.57696 .3068 m
.57696 .3068 L
s
.57704 .3095 m
.57704 .3095 L
s
.57711 .30962 m
.57711 .30962 L
s
.57719 .30762 m
.57719 .30762 L
s
.57726 .30327 m
.57726 .30327 L
s
.57733 .30386 m
.57733 .30386 L
s
.5774 .30644 m
.5774 .30644 L
s
.57748 .30633 m
.57748 .30633 L
s
.57755 .29611 m
.57755 .29611 L
s
.57763 .30057 m
.57763 .30057 L
s
.5777 .30515 m
.5777 .30515 L
s
.57778 .30903 m
.57778 .30903 L
s
.57785 .31384 m
.57785 .31384 L
s
.57793 .31925 m
.57793 .31925 L
s
.578 .31865 m
.578 .31865 L
s
.57808 .31772 m
.57808 .31772 L
s
.57814 .31536 m
.57814 .31536 L
s
.57822 .31044 m
.57822 .31044 L
s
.57829 .3068 m
.57829 .3068 L
s
.57837 .30327 m
.57837 .30327 L
s
.57845 .30022 m
.57845 .30022 L
s
.57852 .2927 m
.57852 .2927 L
s
.5786 .292 m
.5786 .292 L
s
.57867 .29446 m
.57867 .29446 L
s
.57874 .29787 m
.57874 .29787 L
s
.57882 .29364 m
.57882 .29364 L
s
.5789 .28788 m
.5789 .28788 L
s
.57896 .29224 m
.57896 .29224 L
s
.57904 .29247 m
.57904 .29247 L
s
.57911 .29634 m
.57911 .29634 L
s
.57919 .29552 m
.57919 .29552 L
s
.57926 .29728 m
.57926 .29728 L
s
.57934 .29775 m
.57934 .29775 L
s
.57941 .30515 m
.57941 .30515 L
s
.57948 .30726 m
.57948 .30726 L
s
.57956 .30586 m
.57956 .30586 L
s
.57964 .30903 m
.57964 .30903 L
s
.57971 .30491 m
.57971 .30491 L
s
.57978 .30339 m
.57978 .30339 L
s
.57985 .29716 m
.57985 .29716 L
s
.57993 .30045 m
.57993 .30045 L
s
.58001 .29446 m
.58001 .29446 L
s
.58008 .29822 m
.58008 .29822 L
s
.58016 .30069 m
.58016 .30069 L
s
.58023 .30398 m
.58023 .30398 L
s
.5803 .30421 m
.5803 .30421 L
s
.58038 .30633 m
.58038 .30633 L
s
.58045 .3028 m
.58045 .3028 L
s
.58053 .30245 m
.58053 .30245 L
s
.5806 .30162 m
.5806 .30162 L
s
.58067 .30633 m
.58067 .30633 L
s
.58075 .30633 m
.58075 .30633 L
s
.58082 .30738 m
.58082 .30738 L
s
.5809 .30269 m
.5809 .30269 L
s
.58097 .30726 m
.58097 .30726 L
s
.58105 .30468 m
.58105 .30468 L
s
.58111 .30398 m
.58111 .30398 L
s
.58119 .31114 m
.58119 .31114 L
s
.58127 .31549 m
.58127 .31549 L
s
.58134 .3129 m
.58134 .3129 L
s
.58141 .31419 m
.58141 .31419 L
s
.58149 .3109 m
.58149 .3109 L
s
.58157 .30762 m
.58157 .30762 L
s
.58164 .30844 m
.58164 .30844 L
s
.58172 .31137 m
.58172 .31137 L
s
.58179 .30644 m
.58179 .30644 L
s
.58187 .30269 m
.58187 .30269 L
s
.58193 .30234 m
.58193 .30234 L
s
.58201 .30304 m
.58201 .30304 L
s
.58209 .30269 m
.58209 .30269 L
s
.58216 .30797 m
.58216 .30797 L
s
.58223 .30844 m
.58223 .30844 L
s
.58231 .30915 m
.58231 .30915 L
s
.58238 .30162 m
.58238 .30162 L
s
.58246 .30069 m
.58246 .30069 L
s
.58253 .29529 m
.58253 .29529 L
s
.58261 .2967 m
.58261 .2967 L
s
.58268 .29787 m
.58268 .29787 L
s
.58275 .30069 m
.58275 .30069 L
s
.58282 .30116 m
.58282 .30116 L
s
.5829 .29423 m
.5829 .29423 L
s
.58297 .29141 m
.58297 .29141 L
s
.58305 .30116 m
.58305 .30116 L
s
.58313 .29952 m
.58313 .29952 L
s
.5832 .30257 m
.5832 .30257 L
s
.58328 .3001 m
.58328 .3001 L
s
.58335 .29928 m
.58335 .29928 L
s
.58343 .30092 m
.58343 .30092 L
s
.5835 .29998 m
.5835 .29998 L
s
.58357 .29834 m
.58357 .29834 L
s
.58364 .29905 m
.58364 .29905 L
s
.58372 .29798 m
.58372 .29798 L
s
.58379 .29317 m
.58379 .29317 L
s
.58387 .29082 m
.58387 .29082 L
s
.58394 .28859 m
.58394 .28859 L
s
.58402 .29623 m
.58402 .29623 L
s
.58409 .2927 m
.58409 .2927 L
s
.58417 .28977 m
.58417 .28977 L
s
.58424 .29376 m
.58424 .29376 L
s
.58431 .29035 m
.58431 .29035 L
s
.58438 .29317 m
.58438 .29317 L
s
.58446 .29082 m
.58446 .29082 L
s
.58453 .28777 m
.58453 .28777 L
s
.58461 .29082 m
.58461 .29082 L
s
.58469 .29611 m
.58469 .29611 L
s
.58476 .28953 m
.58476 .28953 L
s
.58484 .28824 m
.58484 .28824 L
s
.58491 .28589 m
.58491 .28589 L
s
.58499 .28354 m
.58499 .28354 L
s
.58506 .28871 m
.58506 .28871 L
s
.58513 .29035 m
.58513 .29035 L
s
.5852 .29998 m
.5852 .29998 L
s
.58528 .29905 m
.58528 .29905 L
s
.58535 .30151 m
.58535 .30151 L
s
.58543 .30234 m
.58543 .30234 L
s
.5855 .30527 m
.5855 .30527 L
s
.58558 .30398 m
.58558 .30398 L
s
.58565 .30562 m
.58565 .30562 L
s
.58573 .30562 m
.58573 .30562 L
s
.5858 .3028 m
.5858 .3028 L
s
.58588 .30162 m
.58588 .30162 L
s
.58594 .29881 m
.58594 .29881 L
s
.58602 .30551 m
.58602 .30551 L
s
.58609 .30116 m
.58609 .30116 L
s
.58617 .31008 m
.58617 .31008 L
s
.58625 .31055 m
.58625 .31055 L
s
.58632 .30609 m
.58632 .30609 L
s
.5864 .30069 m
.5864 .30069 L
s
.58647 .30162 m
.58647 .30162 L
s
.58655 .29998 m
.58655 .29998 L
s
.58662 .29975 m
.58662 .29975 L
s
.5867 .29998 m
.5867 .29998 L
s
.58676 .30327 m
.58676 .30327 L
s
.58684 .30656 m
.58684 .30656 L
s
.58691 .30269 m
.58691 .30269 L
s
.58699 .31196 m
.58699 .31196 L
s
.58706 .30633 m
.58706 .30633 L
s
.58714 .31314 m
.58714 .31314 L
s
.58721 .3122 m
.58721 .3122 L
s
.58728 .30997 m
.58728 .30997 L
s
.58736 .31361 m
.58736 .31361 L
s
.58744 .31384 m
.58744 .31384 L
s
.58751 .31032 m
.58751 .31032 L
s
.58758 .30456 m
.58758 .30456 L
s
.58765 .30468 m
.58765 .30468 L
s
.58773 .30162 m
.58773 .30162 L
s
.58781 .30398 m
.58781 .30398 L
s
.58788 .29905 m
.58788 .29905 L
s
.58796 .2994 m
.58796 .2994 L
s
.58803 .30304 m
.58803 .30304 L
s
.5881 .30726 m
.5881 .30726 L
s
.58818 .30985 m
.58818 .30985 L
s
.58826 .30703 m
.58826 .30703 L
s
.58833 .30174 m
.58833 .30174 L
s
.5884 .31008 m
.5884 .31008 L
s
.58847 .31102 m
.58847 .31102 L
s
.58855 .30997 m
.58855 .30997 L
s
.58862 .31631 m
.58862 .31631 L
s
.5887 .31666 m
.5887 .31666 L
s
.58877 .32429 m
.58877 .32429 L
s
.58885 .32594 m
.58885 .32594 L
s
.58892 .3324 m
.58892 .3324 L
s
.58899 .33428 m
.58899 .33428 L
s
.58907 .33087 m
.58907 .33087 L
s
.58914 .3324 m
.58914 .3324 L
s
.58921 .33428 m
.58921 .33428 L
s
.58929 .3324 m
.58929 .3324 L
s
.58937 .33604 m
.58937 .33604 L
s
.58944 .34015 m
.58944 .34015 L
s
.58952 .3432 m
.58952 .3432 L
s
.58959 .35177 m
.58959 .35177 L
s
.58967 .34449 m
.58967 .34449 L
s
.58973 .34461 m
.58973 .34461 L
s
.58981 .34766 m
.58981 .34766 L
s
.58989 .34555 m
.58989 .34555 L
s
.58996 .34931 m
.58996 .34931 L
s
.59003 .35213 m
.59003 .35213 L
s
.59011 .35142 m
.59011 .35142 L
s
.59018 .35694 m
.59018 .35694 L
s
.59026 .35823 m
.59026 .35823 L
s
.59033 .3499 m
.59033 .3499 L
s
.59041 .35248 m
.59041 .35248 L
s
.59048 .35037 m
.59048 .35037 L
s
.59055 .35553 m
.59055 .35553 L
s
.59063 .35894 m
.59063 .35894 L
s
.5907 .36505 m
.5907 .36505 L
s
.59078 .36293 m
.59078 .36293 L
s
.59085 .36481 m
.59085 .36481 L
s
.59093 .37256 m
.59093 .37256 L
s
.591 .37726 m
.591 .37726 L
s
.59108 .37468 m
.59108 .37468 L
s
.59115 .38102 m
.59115 .38102 L
s
.59123 .38548 m
.59123 .38548 L
s
.5913 .38301 m
.5913 .38301 L
s
.59137 .38384 m
.59137 .38384 L
s
.59144 .38219 m
.59144 .38219 L
s
.59152 .38971 m
.59152 .38971 L
s
.59159 .39229 m
.59159 .39229 L
s
.59167 .39077 m
.59167 .39077 L
s
.59174 .39147 m
.59174 .39147 L
s
.59182 .38865 m
.59182 .38865 L
s
.59189 .38877 m
.59189 .38877 L
s
.59197 .38431 m
.59197 .38431 L
s
.59204 .38196 m
.59204 .38196 L
s
.59211 .37832 m
.59211 .37832 L
s
.59218 .37867 m
.59218 .37867 L
s
.59226 .3876 m
.59226 .3876 L
s
.59234 .39488 m
.59234 .39488 L
s
.59241 .40052 m
.59241 .40052 L
s
.59249 .39981 m
.59249 .39981 L
s
.59256 .3964 m
.59256 .3964 L
s
.59264 .39617 m
.59264 .39617 L
s
.59271 .39488 m
.59271 .39488 L
s
.59279 .39217 m
.59279 .39217 L
s
.59286 .39171 m
.59286 .39171 L
s
.59293 .39593 m
.59293 .39593 L
s
.593 .39981 m
.593 .39981 L
s
.59308 .40004 m
.59308 .40004 L
s
.59315 .40052 m
.59315 .40052 L
s
.59323 .39628 m
.59323 .39628 L
s
.5933 .389 m
.5933 .389 L
s
.59338 .39535 m
.59338 .39535 L
s
.59345 .39264 m
.59345 .39264 L
s
.59353 .39406 m
.59353 .39406 L
s
.5936 .39147 m
.5936 .39147 L
s
.59368 .38419 m
.59368 .38419 L
s
.59375 .38372 m
.59375 .38372 L
s
.59382 .38501 m
.59382 .38501 L
s
.59389 .38337 m
.59389 .38337 L
s
.59397 .38407 m
.59397 .38407 L
s
.59405 .38207 m
.59405 .38207 L
s
.59412 .38713 m
.59412 .38713 L
s
.5942 .39194 m
.5942 .39194 L
s
.59427 .39406 m
.59427 .39406 L
s
.59435 .39675 m
.59435 .39675 L
s
.59442 .39429 m
.59442 .39429 L
s
.5945 .39124 m
.5945 .39124 L
s
.59456 .39417 m
.59456 .39417 L
s
.59464 .39805 m
.59464 .39805 L
s
.59471 .40122 m
.59471 .40122 L
s
.59479 .40004 m
.59479 .40004 L
s
.59486 .40321 m
.59486 .40321 L
s
.59494 .40145 m
.59494 .40145 L
s
.59501 .39899 m
.59501 .39899 L
s
.59509 .39124 m
.59509 .39124 L
s
.59516 .39394 m
.59516 .39394 L
s
.59524 .39299 m
.59524 .39299 L
s
.59531 .39217 m
.59531 .39217 L
s
.59538 .39605 m
.59538 .39605 L
s
.59545 .39723 m
.59545 .39723 L
s
.59553 .39089 m
.59553 .39089 L
s
.59561 .39089 m
.59561 .39089 L
s
.59568 .39124 m
.59568 .39124 L
s
.59576 .38689 m
.59576 .38689 L
s
.59583 .38865 m
.59583 .38865 L
s
.5959 .38982 m
.5959 .38982 L
s
.59598 .39499 m
.59598 .39499 L
s
.59606 .39476 m
.59606 .39476 L
s
.59613 .39793 m
.59613 .39793 L
s
.5962 .40227 m
.5962 .40227 L
s
.59627 .40803 m
.59627 .40803 L
s
.59635 .41038 m
.59635 .41038 L
s
.59642 .40638 m
.59642 .40638 L
s
.5965 .40427 m
.5965 .40427 L
s
.59657 .39723 m
.59657 .39723 L
s
.59665 .39406 m
.59665 .39406 L
s
.59672 .38689 m
.59672 .38689 L
s
.5968 .38043 m
.5968 .38043 L
s
.59687 .38137 m
.59687 .38137 L
s
.59694 .3775 m
.59694 .3775 L
s
.59701 .37703 m
.59701 .37703 L
s
.59709 .38172 m
.59709 .38172 L
s
.59717 .37867 m
.59717 .37867 L
s
.59724 .37984 m
.59724 .37984 L
s
.59732 .389 m
.59732 .389 L
s
.59739 .39124 m
.59739 .39124 L
s
.59747 .39488 m
.59747 .39488 L
s
.59753 .39746 m
.59753 .39746 L
s
.59761 .39605 m
.59761 .39605 L
s
.59769 .39558 m
.59769 .39558 L
s
.59776 .40321 m
.59776 .40321 L
s
.59783 .39711 m
.59783 .39711 L
s
.59791 .39957 m
.59791 .39957 L
s
.59798 .39758 m
.59798 .39758 L
s
.59806 .39323 m
.59806 .39323 L
s
.59813 .39112 m
.59813 .39112 L
s
.59821 .39488 m
.59821 .39488 L
s
.59828 .39453 m
.59828 .39453 L
s
.59835 .39511 m
.59835 .39511 L
s
.59843 .39394 m
.59843 .39394 L
s
.59851 .39546 m
.59851 .39546 L
s
.59858 .3964 m
.59858 .3964 L
s
.59865 .39346 m
.59865 .39346 L
s
.59873 .39699 m
.59873 .39699 L
s
.5988 .39593 m
.5988 .39593 L
s
.59888 .39758 m
.59888 .39758 L
s
.59895 .39429 m
.59895 .39429 L
s
.59903 .39453 m
.59903 .39453 L
s
.5991 .39593 m
.5991 .39593 L
s
.59917 .39464 m
.59917 .39464 L
s
.59924 .39253 m
.59924 .39253 L
s
.59932 .39699 m
.59932 .39699 L
s
.59939 .39887 m
.59939 .39887 L
s
.59947 .39899 m
.59947 .39899 L
s
.59954 .40192 m
.59954 .40192 L
s
.59962 .40603 m
.59962 .40603 L
s
.59969 .40521 m
.59969 .40521 L
s
.59977 .41073 m
.59977 .41073 L
s
.59984 .40979 m
.59984 .40979 L
s
.59991 .40967 m
.59991 .40967 L
s
.59998 .41743 m
.59998 .41743 L
s
.60006 .41695 m
.60006 .41695 L
s
.60014 .41848 m
.60014 .41848 L
s
.60021 .42388 m
.60021 .42388 L
s
.60029 .42705 m
.60029 .42705 L
s
.60036 .42541 m
.60036 .42541 L
s
.60044 .428 m
.60044 .428 L
s
.60051 .42095 m
.60051 .42095 L
s
.60059 .42506 m
.60059 .42506 L
s
.60066 .41695 m
.60066 .41695 L
s
.60073 .41907 m
.60073 .41907 L
s
.6008 .41825 m
.6008 .41825 L
s
.60088 .41426 m
.60088 .41426 L
s
.60095 .41284 m
.60095 .41284 L
s
.60103 .41155 m
.60103 .41155 L
s
.6011 .41085 m
.6011 .41085 L
s
.60118 .41226 m
.60118 .41226 L
s
.60125 .41743 m
.60125 .41743 L
s
.60133 .4166 m
.60133 .4166 L
s
.6014 .42341 m
.6014 .42341 L
s
.60148 .42001 m
.60148 .42001 L
s
.60155 .41355 m
.60155 .41355 L
s
.60162 .42154 m
.60162 .42154 L
s
.60169 .42705 m
.60169 .42705 L
s
.60177 .42765 m
.60177 .42765 L
s
.60185 .42471 m
.60185 .42471 L
s
.60192 .42283 m
.60192 .42283 L
s
.602 .42658 m
.602 .42658 L
s
.60207 .4334 m
.60207 .4334 L
s
.60215 .43668 m
.60215 .43668 L
s
.60222 .43668 m
.60222 .43668 L
s
.6023 .43528 m
.6023 .43528 L
s
.60236 .43622 m
.60236 .43622 L
s
.60244 .4442 m
.60244 .4442 L
s
.60251 .4381 m
.60251 .4381 L
s
.60259 .42847 m
.60259 .42847 L
s
.60266 .428 m
.60266 .428 L
s
.60274 .42353 m
.60274 .42353 L
s
.60281 .42729 m
.60281 .42729 L
s
.60289 .43081 m
.60289 .43081 L
s
.60296 .4294 m
.60296 .4294 L
s
.60304 .43493 m
.60304 .43493 L
s
.60311 .43046 m
.60311 .43046 L
s
.60318 .43293 m
.60318 .43293 L
s
.60325 .42964 m
.60325 .42964 L
s
.60333 .42917 m
.60333 .42917 L
s
.60341 .42024 m
.60341 .42024 L
s
.60348 .42518 m
.60348 .42518 L
s
.60356 .42376 m
.60356 .42376 L
s
.60363 .42318 m
.60363 .42318 L
s
.60371 .42083 m
.60371 .42083 L
s
.60378 .42224 m
.60378 .42224 L
s
.60386 .42365 m
.60386 .42365 L
s
.60393 .41966 m
.60393 .41966 L
s
.604 .41331 m
.604 .41331 L
s
.60407 .41848 m
.60407 .41848 L
s
.60415 .42177 m
.60415 .42177 L
s
.60422 .42166 m
.60422 .42166 L
s
.6043 .42729 m
.6043 .42729 L
s
.60437 .42635 m
.60437 .42635 L
s
.60445 .4193 m
.60445 .4193 L
s
.60452 .4193 m
.60452 .4193 L
s
.6046 .42788 m
.6046 .42788 L
s
.60467 .42694 m
.60467 .42694 L
s
.60474 .41942 m
.60474 .41942 L
s
.60481 .42119 m
.60481 .42119 L
s
.60489 .42166 m
.60489 .42166 L
s
.60497 .42729 m
.60497 .42729 L
s
.60504 .424 m
.60504 .424 L
s
.60512 .424 m
.60512 .424 L
s
.60519 .4193 m
.60519 .4193 L
s
.60527 .4186 m
.60527 .4186 L
s
.60534 .4112 m
.60534 .4112 L
s
.60542 .41296 m
.60542 .41296 L
s
.60549 .41214 m
.60549 .41214 L
s
.60556 .41002 m
.60556 .41002 L
s
.60563 .41261 m
.60563 .41261 L
s
.60571 .41402 m
.60571 .41402 L
s
.60578 .41191 m
.60578 .41191 L
s
.60586 .41062 m
.60586 .41062 L
s
.60593 .41531 m
.60593 .41531 L
s
.60601 .42142 m
.60601 .42142 L
s
.60608 .428 m
.60608 .428 L
s
.60615 .42682 m
.60615 .42682 L
s
.60623 .43034 m
.60623 .43034 L
s
.60631 .42753 m
.60631 .42753 L
s
.60638 .42612 m
.60638 .42612 L
s
.60645 .42776 m
.60645 .42776 L
s
.60653 .42448 m
.60653 .42448 L
s
.6066 .42612 m
.6066 .42612 L
s
.60668 .42753 m
.60668 .42753 L
s
.60675 .43081 m
.60675 .43081 L
s
.60683 .43927 m
.60683 .43927 L
s
.6069 .4368 m
.6069 .4368 L
s
.60697 .43657 m
.60697 .43657 L
s
.60705 .43633 m
.60705 .43633 L
s
.60713 .43822 m
.60713 .43822 L
s
.60719 .43633 m
.60719 .43633 L
s
.60727 .4368 m
.60727 .4368 L
s
.60734 .44174 m
.60734 .44174 L
s
.60742 .43551 m
.60742 .43551 L
s
.60749 .43528 m
.60749 .43528 L
s
.60757 .44585 m
.60757 .44585 L
s
.60764 .4482 m
.60764 .4482 L
s
.60771 .4395 m
.60771 .4395 L
s
.60778 .43786 m
.60778 .43786 L
s
.60786 .43386 m
.60786 .43386 L
s
.60794 .4287 m
.60794 .4287 L
s
.60801 .42259 m
.60801 .42259 L
s
.60809 .42318 m
.60809 .42318 L
s
.60816 .41719 m
.60816 .41719 L
s
.60824 .41391 m
.60824 .41391 L
s
.60831 .40991 m
.60831 .40991 L
s
.60839 .41155 m
.60839 .41155 L
s
.60846 .40603 m
.60846 .40603 L
s
.60853 .40674 m
.60853 .40674 L
s
.6086 .40838 m
.6086 .40838 L
s
.60868 .41331 m
.60868 .41331 L
s
.60876 .41155 m
.60876 .41155 L
s
.60883 .41109 m
.60883 .41109 L
s
.6089 .41684 m
.6089 .41684 L
s
.60898 .41813 m
.60898 .41813 L
s
.60905 .41391 m
.60905 .41391 L
s
.60913 .41343 m
.60913 .41343 L
s
.6092 .41672 m
.6092 .41672 L
s
.60928 .4166 m
.60928 .4166 L
s
.60935 .41414 m
.60935 .41414 L
s
.60942 .41226 m
.60942 .41226 L
s
.60949 .41391 m
.60949 .41391 L
s
.60957 .41378 m
.60957 .41378 L
s
.60965 .40838 m
.60965 .40838 L
s
.60972 .41179 m
.60972 .41179 L
s
.6098 .4112 m
.6098 .4112 L
s
.60987 .40791 m
.60987 .40791 L
s
.60995 .41249 m
.60995 .41249 L
s
.61002 .41273 m
.61002 .41273 L
s
.6101 .41402 m
.6101 .41402 L
s
.61016 .40991 m
.61016 .40991 L
s
.61024 .42024 m
.61024 .42024 L
s
.61031 .42119 m
.61031 .42119 L
s
.61039 .4186 m
.61039 .4186 L
s
.61046 .41062 m
.61046 .41062 L
s
.61054 .41402 m
.61054 .41402 L
s
.61061 .41214 m
.61061 .41214 L
s
.61069 .41461 m
.61069 .41461 L
s
.61076 .41438 m
.61076 .41438 L
s
.61084 .4159 m
.61084 .4159 L
s
.61091 .41543 m
.61091 .41543 L
s
.61098 .41402 m
.61098 .41402 L
s
.61105 .41261 m
.61105 .41261 L
s
.61113 .41085 m
.61113 .41085 L
s
.61121 .41355 m
.61121 .41355 L
s
.61128 .41002 m
.61128 .41002 L
s
.61136 .40909 m
.61136 .40909 L
s
.61143 .41179 m
.61143 .41179 L
s
.61151 .41202 m
.61151 .41202 L
s
.61158 .4159 m
.61158 .4159 L
s
.61166 .4213 m
.61166 .4213 L
s
.61173 .41907 m
.61173 .41907 L
s
.6118 .42248 m
.6118 .42248 L
s
.61187 .42095 m
.61187 .42095 L
s
.61195 .40932 m
.61195 .40932 L
s
.61202 .41085 m
.61202 .41085 L
s
.6121 .41132 m
.6121 .41132 L
s
.61217 .41261 m
.61217 .41261 L
s
.61225 .41226 m
.61225 .41226 L
s
.61232 .40909 m
.61232 .40909 L
s
.6124 .41438 m
.6124 .41438 L
s
.61247 .41743 m
.61247 .41743 L
s
.61254 .41942 m
.61254 .41942 L
s
.61261 .41391 m
.61261 .41391 L
s
.61269 .41366 m
.61269 .41366 L
s
.61277 .41085 m
.61277 .41085 L
s
.61284 .41109 m
.61284 .41109 L
s
.61292 .41249 m
.61292 .41249 L
s
.61299 .42189 m
.61299 .42189 L
s
.61307 .41977 m
.61307 .41977 L
s
.61314 .42259 m
.61314 .42259 L
s
.61322 .42201 m
.61322 .42201 L
s
.61329 .41954 m
.61329 .41954 L
s
.61336 .41977 m
.61336 .41977 L
s
.61343 .42212 m
.61343 .42212 L
s
.61351 .42388 m
.61351 .42388 L
s
.61358 .42154 m
.61358 .42154 L
s
.61366 .41919 m
.61366 .41919 L
s
.61373 .41684 m
.61373 .41684 L
s
.61381 .42259 m
.61381 .42259 L
s
.61388 .4274 m
.61388 .4274 L
s
.61396 .43046 m
.61396 .43046 L
s
.61403 .43152 m
.61403 .43152 L
s
.61411 .43094 m
.61411 .43094 L
s
.61418 .43034 m
.61418 .43034 L
s
.61425 .4233 m
.61425 .4233 L
s
.61433 .42694 m
.61433 .42694 L
s
.6144 .4267 m
.6144 .4267 L
s
.61448 .42765 m
.61448 .42765 L
s
.61455 .4253 m
.61455 .4253 L
s
.61463 .42729 m
.61463 .42729 L
s
.6147 .4287 m
.6147 .4287 L
s
.61477 .42894 m
.61477 .42894 L
s
.61485 .43328 m
.61485 .43328 L
s
.61493 .43504 m
.61493 .43504 L
s
.61499 .43493 m
.61499 .43493 L
s
.61507 .43281 m
.61507 .43281 L
s
.61514 .43094 m
.61514 .43094 L
s
.61522 .43563 m
.61522 .43563 L
s
.61529 .43598 m
.61529 .43598 L
s
.61537 .4334 m
.61537 .4334 L
s
.61544 .43304 m
.61544 .43304 L
s
.61551 .43105 m
.61551 .43105 L
s
.61559 .43222 m
.61559 .43222 L
s
.61567 .43058 m
.61567 .43058 L
s
.61574 .43293 m
.61574 .43293 L
s
.61581 .43563 m
.61581 .43563 L
s
.61589 .43022 m
.61589 .43022 L
s
.61596 .43469 m
.61596 .43469 L
s
.61604 .43762 m
.61604 .43762 L
s
.61611 .43575 m
.61611 .43575 L
s
.61619 .4354 m
.61619 .4354 L
s
.61626 .43246 m
.61626 .43246 L
s
.61633 .43622 m
.61633 .43622 L
s
.6164 .44056 m
.6164 .44056 L
s
.61648 .44326 m
.61648 .44326 L
s
.61656 .44044 m
.61656 .44044 L
s
.61663 .44115 m
.61663 .44115 L
s
.6167 .43833 m
.6167 .43833 L
s
.61678 .43986 m
.61678 .43986 L
s
.61685 .44056 m
.61685 .44056 L
s
.61693 .44103 m
.61693 .44103 L
s
.617 .43081 m
.617 .43081 L
s
.61708 .42717 m
.61708 .42717 L
s
.61715 .42682 m
.61715 .42682 L
s
.61722 .42448 m
.61722 .42448 L
s
.6173 .4287 m
.6173 .4287 L
s
.61737 .42236 m
.61737 .42236 L
s
.61745 .41907 m
.61745 .41907 L
s
.61752 .42036 m
.61752 .42036 L
s
.6176 .42012 m
.6176 .42012 L
s
.61767 .42506 m
.61767 .42506 L
s
.61775 .42682 m
.61775 .42682 L
s
.61782 .42894 m
.61782 .42894 L
s
.6179 .43504 m
.6179 .43504 L
s
.61796 .43857 m
.61796 .43857 L
s
.61804 .43481 m
.61804 .43481 L
s
.61811 .43715 m
.61811 .43715 L
s
.61819 .4334 m
.61819 .4334 L
s
.61826 .43246 m
.61826 .43246 L
s
.61834 .43798 m
.61834 .43798 L
s
.61841 .43986 m
.61841 .43986 L
s
.61849 .43493 m
.61849 .43493 L
s
.61856 .4388 m
.61856 .4388 L
s
.61864 .43727 m
.61864 .43727 L
s
.61871 .4388 m
.61871 .4388 L
s
.61878 .44091 m
.61878 .44091 L
s
.61885 .4442 m
.61885 .4442 L
s
.61893 .45124 m
.61893 .45124 L
s
.61901 .45089 m
.61901 .45089 L
s
.61908 .45066 m
.61908 .45066 L
s
.61916 .45149 m
.61916 .45149 L
s
.61923 .459 m
.61923 .459 L
s
.61931 .46323 m
.61931 .46323 L
s
.61938 .46699 m
.61938 .46699 L
s
.61946 .4664 m
.61946 .4664 L
s
.61953 .46617 m
.61953 .46617 L
s
.6196 .46815 m
.6196 .46815 L
s
.61967 .46699 m
.61967 .46699 L
s
.61975 .46535 m
.61975 .46535 L
s
.61982 .4738 m
.61982 .4738 L
s
.6199 .47861 m
.6199 .47861 L
s
.61997 .47544 m
.61997 .47544 L
s
.62005 .47368 m
.62005 .47368 L
s
.62012 .47145 m
.62012 .47145 L
s
.6202 .47169 m
.6202 .47169 L
s
.62027 .47145 m
.62027 .47145 L
s
.62034 .4671 m
.62034 .4671 L
s
.62041 .46852 m
.62041 .46852 L
s
.62049 .47063 m
.62049 .47063 L
s
.62057 .46863 m
.62057 .46863 L
s
.62064 .4671 m
.62064 .4671 L
s
.62072 .4671 m
.62072 .4671 L
s
.62079 .47169 m
.62079 .47169 L
s
.62087 .47603 m
.62087 .47603 L
s
.62094 .47156 m
.62094 .47156 L
s
.62102 .47426 m
.62102 .47426 L
s
.62109 .47286 m
.62109 .47286 L
s
.62116 .4698 m
.62116 .4698 L
s
.62123 .46675 m
.62123 .46675 L
s
.62131 .4637 m
.62131 .4637 L
s
.62138 .46229 m
.62138 .46229 L
s
.62146 .4678 m
.62146 .4678 L
s
.62153 .47016 m
.62153 .47016 L
s
.62161 .46088 m
.62161 .46088 L
s
.62168 .46217 m
.62168 .46217 L
s
.62176 .45572 m
.62176 .45572 L
s
.62183 .45935 m
.62183 .45935 L
s
.62191 .46088 m
.62191 .46088 L
s
.62198 .4637 m
.62198 .4637 L
s
.62205 .45618 m
.62205 .45618 L
s
.62213 .45478 m
.62213 .45478 L
s
.6222 .45184 m
.6222 .45184 L
s
.62228 .4442 m
.62228 .4442 L
s
.62235 .45137 m
.62235 .45137 L
s
.62243 .45712 m
.62243 .45712 L
s
.6225 .45782 m
.6225 .45782 L
s
.62258 .45418 m
.62258 .45418 L
s
.62265 .45289 m
.62265 .45289 L
s
.62273 .45054 m
.62273 .45054 L
s
.62279 .459 m
.62279 .459 L
s
.62287 .45759 m
.62287 .45759 L
s
.62294 .46194 m
.62294 .46194 L
s
.62302 .46252 m
.62302 .46252 L
s
.62309 .45982 m
.62309 .45982 L
s
.62317 .46617 m
.62317 .46617 L
s
.62324 .46416 m
.62324 .46416 L
s
.62331 .46875 m
.62331 .46875 L
s
.62339 .47403 m
.62339 .47403 L
s
.62347 .48119 m
.62347 .48119 L
s
.62354 .48672 m
.62354 .48672 L
s
.62361 .48824 m
.62361 .48824 L
s
.62369 .48977 m
.62369 .48977 L
s
.62376 .48977 m
.62376 .48977 L
s
.62384 .49106 m
.62384 .49106 L
s
.62391 .50093 m
.62391 .50093 L
s
.62399 .50703 m
.62399 .50703 L
s
.62406 .50386 m
.62406 .50386 L
s
.62413 .49799 m
.62413 .49799 L
s
.62421 .49611 m
.62421 .49611 L
s
.62429 .49987 m
.62429 .49987 L
s
.62436 .49705 m
.62436 .49705 L
s
.62443 .49728 m
.62443 .49728 L
s
.6245 .49917 m
.6245 .49917 L
s
.62458 .49576 m
.62458 .49576 L
s
.62465 .49917 m
.62465 .49917 L
s
.62473 .50104 m
.62473 .50104 L
s
.6248 .50069 m
.6248 .50069 L
s
.62488 .49611 m
.62488 .49611 L
s
.62495 .48989 m
.62495 .48989 L
s
.62502 .49376 m
.62502 .49376 L
s
.6251 .49635 m
.6251 .49635 L
s
.62518 .49752 m
.62518 .49752 L
s
.62525 .49553 m
.62525 .49553 L
s
.62532 .49787 m
.62532 .49787 L
s
.6254 .4947 m
.6254 .4947 L
s
.62547 .49283 m
.62547 .49283 L
s
.62555 .49752 m
.62555 .49752 L
s
.62562 .49412 m
.62562 .49412 L
s
.6257 .49071 m
.6257 .49071 L
s
.62576 .49024 m
.62576 .49024 L
s
.62584 .49658 m
.62584 .49658 L
s
.62592 .48672 m
.62592 .48672 L
s
.62599 .49106 m
.62599 .49106 L
s
.62606 .49682 m
.62606 .49682 L
s
.62614 .50116 m
.62614 .50116 L
s
.62621 .49728 m
.62621 .49728 L
s
.62629 .49893 m
.62629 .49893 L
s
.62636 .49752 m
.62636 .49752 L
s
.62644 .50492 m
.62644 .50492 L
s
.62651 .50715 m
.62651 .50715 L
s
.62658 .50903 m
.62658 .50903 L
s
.62665 .50293 m
.62665 .50293 L
s
.62673 .5041 m
.62673 .5041 L
s
.62681 .49447 m
.62681 .49447 L
s
.62688 .49423 m
.62688 .49423 L
s
.62696 .49905 m
.62696 .49905 L
s
.62703 .49822 m
.62703 .49822 L
s
.62711 .5014 m
.62711 .5014 L
s
.62718 .49952 m
.62718 .49952 L
s
.62726 .49646 m
.62726 .49646 L
s
.62733 .49164 m
.62733 .49164 L
s
.6274 .4954 m
.6274 .4954 L
s
.62747 .49728 m
.62747 .49728 L
s
.62755 .49329 m
.62755 .49329 L
s
.62762 .48848 m
.62762 .48848 L
s
.6277 .48437 m
.6277 .48437 L
s
.62777 .48155 m
.62777 .48155 L
s
.62785 .4859 m
.62785 .4859 L
s
.62792 .48566 m
.62792 .48566 L
s
.628 .48801 m
.628 .48801 L
s
.62807 .49071 m
.62807 .49071 L
s
.62815 .49482 m
.62815 .49482 L
s
.62821 .49329 m
.62821 .49329 L
s
.62829 .49376 m
.62829 .49376 L
s
.62837 .49365 m
.62837 .49365 L
s
.62844 .49047 m
.62844 .49047 L
s
.62852 .4947 m
.62852 .4947 L
s
.62859 .49752 m
.62859 .49752 L
s
.62867 .49752 m
.62867 .49752 L
s
.62874 .49976 m
.62874 .49976 L
s
.62882 .49857 m
.62882 .49857 L
s
.62889 .50222 m
.62889 .50222 L
s
.62896 .5021 m
.62896 .5021 L
s
.62903 .50151 m
.62903 .50151 L
s
.62911 .50246 m
.62911 .50246 L
s
.62918 .49952 m
.62918 .49952 L
s
.62926 .49588 m
.62926 .49588 L
s
.62933 .496 m
.62933 .496 L
s
.62941 .49905 m
.62941 .49905 L
s
.62948 .49553 m
.62948 .49553 L
s
.62956 .49365 m
.62956 .49365 L
s
.62963 .48613 m
.62963 .48613 L
s
.62971 .4832 m
.62971 .4832 L
s
.62978 .48155 m
.62978 .48155 L
s
.62985 .4832 m
.62985 .4832 L
s
.62993 .48143 m
.62993 .48143 L
s
.63 .4799 m
.63 .4799 L
s
.63008 .48777 m
.63008 .48777 L
s
.63015 .47814 m
.63015 .47814 L
s
.63023 .47568 m
.63023 .47568 L
s
.6303 .47415 m
.6303 .47415 L
s
.63038 .48531 m
.63038 .48531 L
s
.63045 .48119 m
.63045 .48119 L
s
.63053 .48355 m
.63053 .48355 L
s
.63059 .48014 m
.63059 .48014 L
s
.63067 .48495 m
.63067 .48495 L
s
.63074 .48084 m
.63074 .48084 L
s
.63082 .48155 m
.63082 .48155 L
s
.63089 .48331 m
.63089 .48331 L
s
.63097 .48884 m
.63097 .48884 L
s
.63104 .48343 m
.63104 .48343 L
s
.63112 .48543 m
.63112 .48543 L
s
.63119 .48143 m
.63119 .48143 L
s
.63127 .47509 m
.63127 .47509 L
s
.63134 .47344 m
.63134 .47344 L
s
.63141 .47568 m
.63141 .47568 L
s
.63149 .4738 m
.63149 .4738 L
s
.63156 .4772 m
.63156 .4772 L
s
.63164 .47709 m
.63164 .47709 L
s
.63171 .4846 m
.63171 .4846 L
s
.63179 .48072 m
.63179 .48072 L
s
.63186 .4859 m
.63186 .4859 L
s
.63193 .47826 m
.63193 .47826 L
s
.63201 .47333 m
.63201 .47333 L
s
.63209 .4772 m
.63209 .4772 L
s
.63216 .47274 m
.63216 .47274 L
s
.63223 .46934 m
.63223 .46934 L
s
.6323 .47228 m
.6323 .47228 L
s
.63238 .47239 m
.63238 .47239 L
s
.63245 .47344 m
.63245 .47344 L
s
.63253 .47627 m
.63253 .47627 L
s
.6326 .47263 m
.6326 .47263 L
s
.63268 .46311 m
.63268 .46311 L
s
.63275 .461 m
.63275 .461 L
s
.63283 .45877 m
.63283 .45877 L
s
.6329 .4617 m
.6329 .4617 L
s
.63298 .45853 m
.63298 .45853 L
s
.63305 .46064 m
.63305 .46064 L
s
.63312 .45971 m
.63312 .45971 L
s
.6332 .46299 m
.6332 .46299 L
s
.63327 .45572 m
.63327 .45572 L
s
.63335 .45747 m
.63335 .45747 L
s
.63342 .45513 m
.63342 .45513 L
s
.6335 .45677 m
.6335 .45677 L
s
.63356 .46252 m
.63356 .46252 L
s
.63364 .46088 m
.63364 .46088 L
s
.63372 .46029 m
.63372 .46029 L
s
.63379 .46346 m
.63379 .46346 L
s
.63386 .46488 m
.63386 .46488 L
s
.63394 .46535 m
.63394 .46535 L
s
.63401 .46652 m
.63401 .46652 L
s
.63409 .46288 m
.63409 .46288 L
s
.63416 .46675 m
.63416 .46675 L
s
.63424 .46241 m
.63424 .46241 L
s
.63431 .46558 m
.63431 .46558 L
s
.63438 .4637 m
.63438 .4637 L
s
.63446 .46488 m
.63446 .46488 L
s
.63454 .46346 m
.63454 .46346 L
s
.63461 .46053 m
.63461 .46053 L
s
.63468 .46252 m
.63468 .46252 L
s
.63476 .4684 m
.63476 .4684 L
s
.63483 .46605 m
.63483 .46605 L
s
.63491 .46135 m
.63491 .46135 L
s
.63498 .45572 m
.63498 .45572 L
s
.63506 .46241 m
.63506 .46241 L
s
.63513 .45888 m
.63513 .45888 L
s
.6352 .46252 m
.6352 .46252 L
s
.63527 .46393 m
.63527 .46393 L
s
.63535 .46804 m
.63535 .46804 L
s
.63542 .46769 m
.63542 .46769 L
s
.6355 .4684 m
.6355 .4684 L
s
.63557 .46957 m
.63557 .46957 L
s
.63565 .4745 m
.63565 .4745 L
s
.63572 .47027 m
.63572 .47027 L
s
.6358 .46863 m
.6358 .46863 L
s
.63587 .47086 m
.63587 .47086 L
s
.63595 .46581 m
.63595 .46581 L
s
.63601 .45653 m
.63601 .45653 L
s
.63609 .459 m
.63609 .459 L
s
.63617 .45688 m
.63617 .45688 L
s
.63624 .45641 m
.63624 .45641 L
s
.63632 .45548 m
.63632 .45548 L
s
.63639 .45747 m
.63639 .45747 L
s
.63647 .45618 m
.63647 .45618 L
s
.63654 .45489 m
.63654 .45489 L
s
.63662 .44961 m
.63662 .44961 L
s
.63669 .44855 m
.63669 .44855 L
s
.63676 .45184 m
.63676 .45184 L
s
.63683 .44972 m
.63683 .44972 L
s
.63691 .45043 m
.63691 .45043 L
s
.63698 .45043 m
.63698 .45043 L
s
.63706 .44443 m
.63706 .44443 L
s
.63713 .44585 m
.63713 .44585 L
s
.63721 .44396 m
.63721 .44396 L
s
.63728 .4395 m
.63728 .4395 L
s
.63736 .4395 m
.63736 .4395 L
s
.63743 .4375 m
.63743 .4375 L
s
.63751 .44408 m
.63751 .44408 L
s
.63758 .44749 m
.63758 .44749 L
s
.63765 .45466 m
.63765 .45466 L
s
.63773 .45525 m
.63773 .45525 L
s
.6378 .45266 m
.6378 .45266 L
s
.63788 .44937 m
.63788 .44937 L
s
.63795 .45172 m
.63795 .45172 L
s
.63803 .44808 m
.63803 .44808 L
s
.6381 .44585 m
.6381 .44585 L
s
.63818 .44021 m
.63818 .44021 L
s
.63825 .44115 m
.63825 .44115 L
s
.63833 .44103 m
.63833 .44103 L
s
.63839 .43775 m
.63839 .43775 L
s
.63847 .44396 m
.63847 .44396 L
s
.63854 .44772 m
.63854 .44772 L
s
.63862 .44491 m
.63862 .44491 L
s
.63869 .44326 m
.63869 .44326 L
s
.63877 .44068 m
.63877 .44068 L
s
.63884 .44021 m
.63884 .44021 L
s
.63892 .43563 m
.63892 .43563 L
s
.63899 .43375 m
.63899 .43375 L
s
.63907 .43586 m
.63907 .43586 L
s
.63914 .43117 m
.63914 .43117 L
s
.63921 .43304 m
.63921 .43304 L
s
.63929 .43328 m
.63929 .43328 L
s
.63936 .43386 m
.63936 .43386 L
s
.63944 .43269 m
.63944 .43269 L
s
.63951 .43551 m
.63951 .43551 L
s
.63959 .43246 m
.63959 .43246 L
s
.63966 .43516 m
.63966 .43516 L
s
.63973 .43164 m
.63973 .43164 L
s
.63981 .4287 m
.63981 .4287 L
s
.63989 .42471 m
.63989 .42471 L
s
.63996 .42976 m
.63996 .42976 L
s
.64003 .43022 m
.64003 .43022 L
s
.6401 .42588 m
.6401 .42588 L
s
.64018 .42635 m
.64018 .42635 L
s
.64025 .42224 m
.64025 .42224 L
s
.64033 .41942 m
.64033 .41942 L
s
.6404 .42166 m
.6404 .42166 L
s
.64048 .4152 m
.64048 .4152 L
s
.64055 .41613 m
.64055 .41613 L
s
.64063 .42095 m
.64063 .42095 L
s
.6407 .42236 m
.6407 .42236 L
s
.64078 .41884 m
.64078 .41884 L
s
.64085 .42623 m
.64085 .42623 L
s
.64092 .424 m
.64092 .424 L
s
.641 .42154 m
.641 .42154 L
s
.64107 .42494 m
.64107 .42494 L
s
.64115 .42823 m
.64115 .42823 L
s
.64122 .43094 m
.64122 .43094 L
s
.6413 .428 m
.6413 .428 L
s
.64137 .42858 m
.64137 .42858 L
s
.64145 .42858 m
.64145 .42858 L
s
.64152 .43094 m
.64152 .43094 L
s
.64159 .43058 m
.64159 .43058 L
s
.64166 .43528 m
.64166 .43528 L
s
.64174 .4361 m
.64174 .4361 L
s
.64181 .43692 m
.64181 .43692 L
s
.64189 .44162 m
.64189 .44162 L
s
.64196 .44139 m
.64196 .44139 L
s
.64204 .44044 m
.64204 .44044 L
s
.64211 .44209 m
.64211 .44209 L
s
.64218 .4381 m
.64218 .4381 L
s
.64226 .43645 m
.64226 .43645 L
s
.64234 .43845 m
.64234 .43845 L
s
.64241 .43775 m
.64241 .43775 L
s
.64248 .43586 m
.64248 .43586 L
s
.64256 .43715 m
.64256 .43715 L
s
.64263 .43575 m
.64263 .43575 L
s
.64271 .4341 m
.64271 .4341 L
s
.64278 .43446 m
.64278 .43446 L
s
.64286 .4381 m
.64286 .4381 L
s
.64293 .4354 m
.64293 .4354 L
s
.643 .44068 m
.643 .44068 L
s
.64308 .43351 m
.64308 .43351 L
s
.64316 .43094 m
.64316 .43094 L
s
.64322 .43328 m
.64322 .43328 L
s
.6433 .43187 m
.6433 .43187 L
s
.64337 .43668 m
.64337 .43668 L
s
.64345 .43269 m
.64345 .43269 L
s
.64352 .43293 m
.64352 .43293 L
s
.6436 .42729 m
.6436 .42729 L
s
.64367 .42647 m
.64367 .42647 L
s
.64375 .42835 m
.64375 .42835 L
s
.64381 .42658 m
.64381 .42658 L
s
.64389 .42788 m
.64389 .42788 L
s
.64397 .43058 m
.64397 .43058 L
s
.64404 .4253 m
.64404 .4253 L
s
.64412 .43187 m
.64412 .43187 L
s
.64419 .428 m
.64419 .428 L
s
.64427 .42448 m
.64427 .42448 L
s
.64434 .42694 m
.64434 .42694 L
s
.64442 .43105 m
.64442 .43105 L
s
.64449 .42929 m
.64449 .42929 L
s
.64456 .42976 m
.64456 .42976 L
s
.64463 .43094 m
.64463 .43094 L
s
.64471 .42494 m
.64471 .42494 L
s
.64479 .42776 m
.64479 .42776 L
s
.64486 .43058 m
.64486 .43058 L
s
.64493 .43481 m
.64493 .43481 L
s
.64501 .43269 m
.64501 .43269 L
s
.64508 .4287 m
.64508 .4287 L
s
.64516 .43011 m
.64516 .43011 L
s
.64523 .43304 m
.64523 .43304 L
s
.64531 .43211 m
.64531 .43211 L
s
.64538 .43176 m
.64538 .43176 L
s
.64545 .43586 m
.64545 .43586 L
s
.64553 .42459 m
.64553 .42459 L
s
.6456 .42541 m
.6456 .42541 L
s
.64568 .42847 m
.64568 .42847 L
s
.64575 .43434 m
.64575 .43434 L
s
.64583 .43199 m
.64583 .43199 L
s
.6459 .43199 m
.6459 .43199 L
s
.64598 .42823 m
.64598 .42823 L
s
.64605 .42964 m
.64605 .42964 L
s
.64613 .43398 m
.64613 .43398 L
s
.64619 .4314 m
.64619 .4314 L
s
.64627 .43762 m
.64627 .43762 L
s
.64634 .43034 m
.64634 .43034 L
s
.64642 .43434 m
.64642 .43434 L
s
.64649 .43775 m
.64649 .43775 L
s
.64657 .43563 m
.64657 .43563 L
s
.64664 .4354 m
.64664 .4354 L
s
.64672 .42705 m
.64672 .42705 L
s
.64679 .42119 m
.64679 .42119 L
s
.64687 .42212 m
.64687 .42212 L
s
.64694 .42271 m
.64694 .42271 L
s
.64701 .42341 m
.64701 .42341 L
s
.64709 .42353 m
.64709 .42353 L
s
.64716 .42294 m
.64716 .42294 L
s
.64724 .41743 m
.64724 .41743 L
s
.64731 .41261 m
.64731 .41261 L
s
.64739 .41226 m
.64739 .41226 L
s
.64746 .41155 m
.64746 .41155 L
s
.64754 .41449 m
.64754 .41449 L
s
.64761 .41907 m
.64761 .41907 L
s
.64769 .41273 m
.64769 .41273 L
s
.64776 .4179 m
.64776 .4179 L
s
.64783 .41825 m
.64783 .41825 L
s
.6479 .42001 m
.6479 .42001 L
s
.64798 .42072 m
.64798 .42072 L
s
.64805 .42036 m
.64805 .42036 L
s
.64813 .42212 m
.64813 .42212 L
s
.6482 .42072 m
.6482 .42072 L
s
.64828 .42119 m
.64828 .42119 L
s
.64835 .42236 m
.64835 .42236 L
s
.64843 .42177 m
.64843 .42177 L
s
.6485 .42236 m
.6485 .42236 L
s
.64858 .41719 m
.64858 .41719 L
s
.64865 .41731 m
.64865 .41731 L
s
.64872 .42765 m
.64872 .42765 L
s
.6488 .42812 m
.6488 .42812 L
s
.64887 .4314 m
.64887 .4314 L
s
.64895 .4334 m
.64895 .4334 L
s
.64902 .4314 m
.64902 .4314 L
s
.6491 .43715 m
.6491 .43715 L
s
.64917 .43386 m
.64917 .43386 L
s
.64925 .43117 m
.64925 .43117 L
s
.64932 .42847 m
.64932 .42847 L
s
.64939 .42905 m
.64939 .42905 L
s
.64946 .42765 m
.64946 .42765 L
s
.64954 .43575 m
.64954 .43575 L
s
.64961 .43434 m
.64961 .43434 L
s
.64969 .43105 m
.64969 .43105 L
s
.64976 .43469 m
.64976 .43469 L
s
.64984 .43986 m
.64984 .43986 L
s
.64991 .43645 m
.64991 .43645 L
s
.64998 .4395 m
.64998 .4395 L
s
.65006 .4381 m
.65006 .4381 L
s
.65014 .43633 m
.65014 .43633 L
s
.65021 .43904 m
.65021 .43904 L
s
.65028 .4375 m
.65028 .4375 L
s
.65036 .43234 m
.65036 .43234 L
s
.65043 .43293 m
.65043 .43293 L
s
.65051 .43222 m
.65051 .43222 L
s
.65058 .43081 m
.65058 .43081 L
s
.65066 .43715 m
.65066 .43715 L
s
.65073 .44232 m
.65073 .44232 L
s
.6508 .44232 m
.6508 .44232 L
s
.65088 .44373 m
.65088 .44373 L
s
.65096 .43598 m
.65096 .43598 L
s
.65102 .43563 m
.65102 .43563 L
s
.6511 .4368 m
.6511 .4368 L
s
.65117 .43516 m
.65117 .43516 L
s
.65125 .43833 m
.65125 .43833 L
s
.65132 .44068 m
.65132 .44068 L
s
.6514 .44303 m
.6514 .44303 L
s
.65147 .44174 m
.65147 .44174 L
s
.65155 .43645 m
.65155 .43645 L
s
.65161 .43927 m
.65161 .43927 L
s
.65169 .44091 m
.65169 .44091 L
s
.65177 .44491 m
.65177 .44491 L
s
.65184 .44232 m
.65184 .44232 L
s
.65192 .43398 m
.65192 .43398 L
s
.65199 .43739 m
.65199 .43739 L
s
.65207 .43316 m
.65207 .43316 L
s
.65214 .43034 m
.65214 .43034 L
s
.65222 .43117 m
.65222 .43117 L
s
.65229 .42847 m
.65229 .42847 L
s
.65236 .42694 m
.65236 .42694 L
s
.65243 .42612 m
.65243 .42612 L
s
.65251 .42952 m
.65251 .42952 L
s
.65259 .43187 m
.65259 .43187 L
s
.65266 .43363 m
.65266 .43363 L
s
.65273 .43293 m
.65273 .43293 L
s
.65281 .43058 m
.65281 .43058 L
s
.65288 .42858 m
.65288 .42858 L
s
.65296 .43069 m
.65296 .43069 L
s
.65303 .43692 m
.65303 .43692 L
s
.65311 .43762 m
.65311 .43762 L
s
.65318 .4381 m
.65318 .4381 L
s
.65325 .44032 m
.65325 .44032 L
s
.65333 .44725 m
.65333 .44725 L
s
.6534 .44538 m
.6534 .44538 L
s
.65348 .44714 m
.65348 .44714 L
s
.65355 .44479 m
.65355 .44479 L
s
.65363 .44396 m
.65363 .44396 L
s
.6537 .44596 m
.6537 .44596 L
s
.65378 .43857 m
.65378 .43857 L
s
.65385 .43739 m
.65385 .43739 L
s
.65393 .43704 m
.65393 .43704 L
s
.65399 .43293 m
.65399 .43293 L
s
.65407 .44021 m
.65407 .44021 L
s
.65414 .44186 m
.65414 .44186 L
s
.65422 .44655 m
.65422 .44655 L
s
.65429 .45442 m
.65429 .45442 L
s
.65437 .45842 m
.65437 .45842 L
s
.65444 .45959 m
.65444 .45959 L
s
.65452 .45525 m
.65452 .45525 L
s
.65459 .45313 m
.65459 .45313 L
s
.65467 .45289 m
.65467 .45289 L
s
.65474 .45525 m
.65474 .45525 L
s
.65481 .44855 m
.65481 .44855 L
s
.65489 .44514 m
.65489 .44514 L
s
.65496 .44702 m
.65496 .44702 L
s
.65504 .45019 m
.65504 .45019 L
s
.65511 .45782 m
.65511 .45782 L
s
.65519 .45101 m
.65519 .45101 L
s
.65526 .44832 m
.65526 .44832 L
s
.65534 .44984 m
.65534 .44984 L
s
.65541 .45113 m
.65541 .45113 L
s
.65549 .4536 m
.65549 .4536 L
s
.65556 .45665 m
.65556 .45665 L
s
.65563 .46699 m
.65563 .46699 L
s
.6557 .4671 m
.6557 .4671 L
s
.65578 .46875 m
.65578 .46875 L
s
.65585 .47027 m
.65585 .47027 L
s
.65593 .47121 m
.65593 .47121 L
s
.656 .47638 m
.656 .47638 L
s
.65608 .47967 m
.65608 .47967 L
s
.65615 .47145 m
.65615 .47145 L
s
.65623 .47192 m
.65623 .47192 L
s
.6563 .48049 m
.6563 .48049 L
s
.65638 .48096 m
.65638 .48096 L
s
.65645 .47791 m
.65645 .47791 L
s
.65652 .48178 m
.65652 .48178 L
s
.6566 .4859 m
.6566 .4859 L
s
.65667 .47967 m
.65667 .47967 L
s
.65675 .47791 m
.65675 .47791 L
s
.65682 .47756 m
.65682 .47756 L
s
.6569 .4799 m
.6569 .4799 L
s
.65697 .48273 m
.65697 .48273 L
s
.65705 .48601 m
.65705 .48601 L
s
.65712 .48108 m
.65712 .48108 L
s
.65719 .48061 m
.65719 .48061 L
s
.65726 .47709 m
.65726 .47709 L
s
.65734 .47344 m
.65734 .47344 L
s
.65741 .46992 m
.65741 .46992 L
s
.65749 .47098 m
.65749 .47098 L
s
.65756 .46957 m
.65756 .46957 L
s
.65764 .46558 m
.65764 .46558 L
s
.65771 .4684 m
.65771 .4684 L
s
.65779 .46828 m
.65779 .46828 L
s
.65786 .46922 m
.65786 .46922 L
s
.65794 .4644 m
.65794 .4644 L
s
.65801 .46757 m
.65801 .46757 L
s
.65808 .47462 m
.65808 .47462 L
s
.65816 .47403 m
.65816 .47403 L
s
.65823 .47615 m
.65823 .47615 L
s
.65831 .4758 m
.65831 .4758 L
s
.65838 .47509 m
.65838 .47509 L
s
.65846 .47744 m
.65846 .47744 L
s
.65853 .48495 m
.65853 .48495 L
s
.6586 .48824 m
.6586 .48824 L
s
.65868 .49129 m
.65868 .49129 L
s
.65876 .48683 m
.65876 .48683 L
s
.65882 .48719 m
.65882 .48719 L
s
.6589 .49353 m
.6589 .49353 L
s
.65897 .49423 m
.65897 .49423 L
s
.65905 .49188 m
.65905 .49188 L
s
.65912 .49259 m
.65912 .49259 L
s
.6592 .49505 m
.6592 .49505 L
s
.65927 .49024 m
.65927 .49024 L
s
.65935 .49212 m
.65935 .49212 L
s
.65942 .48648 m
.65942 .48648 L
s
.6595 .4893 m
.6595 .4893 L
s
.65958 .48859 m
.65958 .48859 L
s
.65964 .48754 m
.65964 .48754 L
s
.65972 .49658 m
.65972 .49658 L
s
.65979 .49611 m
.65979 .49611 L
s
.65987 .49787 m
.65987 .49787 L
s
.65994 .49717 m
.65994 .49717 L
s
.66002 .49905 m
.66002 .49905 L
s
.66009 .49987 m
.66009 .49987 L
s
.66016 .49869 m
.66016 .49869 L
s
.66023 .49635 m
.66023 .49635 L
s
.66031 .48765 m
.66031 .48765 L
s
.66039 .48072 m
.66039 .48072 L
s
.66046 .48049 m
.66046 .48049 L
s
.66053 .48261 m
.66053 .48261 L
s
.66061 .47944 m
.66061 .47944 L
s
.66068 .48296 m
.66068 .48296 L
s
.66076 .4799 m
.66076 .4799 L
s
.66083 .47473 m
.66083 .47473 L
s
.66091 .46699 m
.66091 .46699 L
s
.66098 .46746 m
.66098 .46746 L
s
.66105 .46887 m
.66105 .46887 L
s
.66113 .47051 m
.66113 .47051 L
s
.66121 .46416 m
.66121 .46416 L
s
.66128 .46194 m
.66128 .46194 L
s
.66135 .45501 m
.66135 .45501 L
s
.66143 .45289 m
.66143 .45289 L
s
.6615 .44972 m
.6615 .44972 L
s
.66158 .45043 m
.66158 .45043 L
s
.66165 .44725 m
.66165 .44725 L
s
.66173 .4388 m
.66173 .4388 L
s
.66179 .44303 m
.66179 .44303 L
s
.66187 .44561 m
.66187 .44561 L
s
.66194 .44855 m
.66194 .44855 L
s
.66202 .45572 m
.66202 .45572 L
s
.66209 .45489 m
.66209 .45489 L
s
.66217 .46064 m
.66217 .46064 L
s
.66224 .46217 m
.66224 .46217 L
s
.66232 .45853 m
.66232 .45853 L
s
.66239 .45912 m
.66239 .45912 L
s
.66247 .4583 m
.66247 .4583 L
s
.66254 .45242 m
.66254 .45242 L
s
.66261 .44491 m
.66261 .44491 L
s
.66269 .4381 m
.66269 .4381 L
s
.66276 .43633 m
.66276 .43633 L
s
.66284 .44115 m
.66284 .44115 L
s
.66291 .43892 m
.66291 .43892 L
s
.66299 .44808 m
.66299 .44808 L
s
.66306 .44068 m
.66306 .44068 L
s
.66314 .43798 m
.66314 .43798 L
s
.66321 .44115 m
.66321 .44115 L
s
.66329 .43997 m
.66329 .43997 L
s
.66336 .43857 m
.66336 .43857 L
s
.66343 .43622 m
.66343 .43622 L
s
.6635 .44056 m
.6635 .44056 L
s
.66358 .44115 m
.66358 .44115 L
s
.66365 .43868 m
.66365 .43868 L
s
.66373 .43246 m
.66373 .43246 L
s
.6638 .43069 m
.6638 .43069 L
s
.66388 .42729 m
.66388 .42729 L
s
.66395 .42623 m
.66395 .42623 L
s
.66403 .42541 m
.66403 .42541 L
s
.6641 .42623 m
.6641 .42623 L
s
.66418 .41755 m
.66418 .41755 L
s
.66425 .41907 m
.66425 .41907 L
s
.66432 .4193 m
.66432 .4193 L
s
.6644 .41378 m
.6644 .41378 L
s
.66447 .40991 m
.66447 .40991 L
s
.66455 .40263 m
.66455 .40263 L
s
.66462 .40592 m
.66462 .40592 L
s
.6647 .39969 m
.6647 .39969 L
s
.66477 .39957 m
.66477 .39957 L
s
.66485 .39593 m
.66485 .39593 L
s
.66492 .3991 m
.66492 .3991 L
s
.66499 .40239 m
.66499 .40239 L
s
.66506 .41014 m
.66506 .41014 L
s
.66514 .41179 m
.66514 .41179 L
s
.66521 .41155 m
.66521 .41155 L
s
.66529 .40944 m
.66529 .40944 L
s
.66536 .40416 m
.66536 .40416 L
s
.66544 .39817 m
.66544 .39817 L
s
.66551 .39945 m
.66551 .39945 L
s
.66559 .39875 m
.66559 .39875 L
s
.66566 .39382 m
.66566 .39382 L
s
.66574 .39464 m
.66574 .39464 L
s
.66581 .39229 m
.66581 .39229 L
s
.66588 .39441 m
.66588 .39441 L
s
.66596 .39394 m
.66596 .39394 L
s
.66603 .39605 m
.66603 .39605 L
s
.66611 .39065 m
.66611 .39065 L
s
.66618 .39042 m
.66618 .39042 L
s
.66626 .38654 m
.66626 .38654 L
s
.66633 .38642 m
.66633 .38642 L
s
.66641 .39171 m
.66641 .39171 L
s
.66648 .38783 m
.66648 .38783 L
s
.66656 .38783 m
.66656 .38783 L
s
.66663 .38842 m
.66663 .38842 L
s
.6667 .39135 m
.6667 .39135 L
s
.66677 .391 m
.66677 .391 L
s
.66685 .3883 m
.66685 .3883 L
s
.66692 .38994 m
.66692 .38994 L
s
.667 .39182 m
.667 .39182 L
s
.66707 .39417 m
.66707 .39417 L
s
.66715 .3903 m
.66715 .3903 L
s
.66722 .38971 m
.66722 .38971 L
s
.6673 .38912 m
.6673 .38912 L
s
.66738 .38125 m
.66738 .38125 L
s
.66744 .38231 m
.66744 .38231 L
s
.66752 .38454 m
.66752 .38454 L
s
.66759 .38842 m
.66759 .38842 L
s
.66767 .38313 m
.66767 .38313 L
s
.66774 .389 m
.66774 .389 L
s
.66782 .39229 m
.66782 .39229 L
s
.66789 .3957 m
.66789 .3957 L
s
.66796 .40063 m
.66796 .40063 L
s
.66804 .40216 m
.66804 .40216 L
s
.66812 .39664 m
.66812 .39664 L
s
.66819 .39441 m
.66819 .39441 L
s
.66826 .38877 m
.66826 .38877 L
s
.66833 .38219 m
.66833 .38219 L
s
.66841 .38384 m
.66841 .38384 L
s
.66848 .3876 m
.66848 .3876 L
s
.66856 .38982 m
.66856 .38982 L
s
.66863 .39288 m
.66863 .39288 L
s
.66871 .39135 m
.66871 .39135 L
s
.66878 .38924 m
.66878 .38924 L
s
.66885 .38994 m
.66885 .38994 L
s
.66893 .38665 m
.66893 .38665 L
s
.66901 .38489 m
.66901 .38489 L
s
.66908 .38172 m
.66908 .38172 L
s
.66915 .37914 m
.66915 .37914 L
s
.66923 .38008 m
.66923 .38008 L
s
.6693 .38079 m
.6693 .38079 L
s
.66938 .38971 m
.66938 .38971 L
s
.66945 .38795 m
.66945 .38795 L
s
.66953 .38301 m
.66953 .38301 L
s
.6696 .37597 m
.6696 .37597 L
s
.66967 .37397 m
.66967 .37397 L
s
.66975 .37374 m
.66975 .37374 L
s
.66982 .37279 m
.66982 .37279 L
s
.66989 .37162 m
.66989 .37162 L
s
.66997 .36951 m
.66997 .36951 L
s
.67004 .37351 m
.67004 .37351 L
s
.67012 .3782 m
.67012 .3782 L
s
.67019 .3775 m
.67019 .3775 L
s
.67027 .3802 m
.67027 .3802 L
s
.67034 .38149 m
.67034 .38149 L
s
.67041 .37503 m
.67041 .37503 L
s
.67049 .37503 m
.67049 .37503 L
s
.67056 .37773 m
.67056 .37773 L
s
.67064 .37374 m
.67064 .37374 L
s
.67071 .37726 m
.67071 .37726 L
s
.67079 .37585 m
.67079 .37585 L
s
.67086 .37515 m
.67086 .37515 L
s
.67094 .37104 m
.67094 .37104 L
s
.67101 .37339 m
.67101 .37339 L
s
.67109 .37256 m
.67109 .37256 L
s
.67116 .3701 m
.67116 .3701 L
s
.67123 .36223 m
.67123 .36223 L
s
.6713 .35694 m
.6713 .35694 L
s
.67138 .358 m
.67138 .358 L
s
.67146 .35483 m
.67146 .35483 L
s
.67153 .35048 m
.67153 .35048 L
s
.6716 .35295 m
.6716 .35295 L
s
.67168 .34849 m
.67168 .34849 L
s
.67175 .34978 m
.67175 .34978 L
s
.67183 .35259 m
.67183 .35259 L
s
.6719 .35588 m
.6719 .35588 L
s
.67198 .35929 m
.67198 .35929 L
s
.67205 .35553 m
.67205 .35553 L
s
.67212 .35683 m
.67212 .35683 L
s
.6722 .36211 m
.6722 .36211 L
s
.67227 .35917 m
.67227 .35917 L
s
.67235 .36234 m
.67235 .36234 L
s
.67242 .36152 m
.67242 .36152 L
s
.6725 .35988 m
.6725 .35988 L
s
.67257 .35377 m
.67257 .35377 L
s
.67265 .35624 m
.67265 .35624 L
s
.67272 .36258 m
.67272 .36258 L
s
.67279 .36059 m
.67279 .36059 L
s
.67286 .36094 m
.67286 .36094 L
s
.67294 .3486 m
.67294 .3486 L
s
.67301 .34696 m
.67301 .34696 L
s
.67309 .34955 m
.67309 .34955 L
s
.67316 .34931 m
.67316 .34931 L
s
.67324 .34543 m
.67324 .34543 L
s
.67331 .35224 m
.67331 .35224 L
s
.67339 .34849 m
.67339 .34849 L
s
.67346 .34743 m
.67346 .34743 L
s
.67354 .35025 m
.67354 .35025 L
s
.67361 .34849 m
.67361 .34849 L
s
.67368 .34626 m
.67368 .34626 L
s
.67376 .35624 m
.67376 .35624 L
s
.67383 .35659 m
.67383 .35659 L
s
.67391 .35354 m
.67391 .35354 L
s
.67398 .35307 m
.67398 .35307 L
s
.67406 .35307 m
.67406 .35307 L
s
.67413 .35037 m
.67413 .35037 L
s
.67421 .34285 m
.67421 .34285 L
s
.67428 .34743 m
.67428 .34743 L
s
.67436 .3499 m
.67436 .3499 L
s
.67443 .35166 m
.67443 .35166 L
s
.6745 .35166 m
.6745 .35166 L
s
.67457 .35319 m
.67457 .35319 L
s
.67465 .35025 m
.67465 .35025 L
s
.67472 .34837 m
.67472 .34837 L
s
.6748 .34673 m
.6748 .34673 L
s
.67487 .35706 m
.67487 .35706 L
s
.67495 .35718 m
.67495 .35718 L
s
.67502 .35847 m
.67502 .35847 L
s
.6751 .36094 m
.6751 .36094 L
s
.67518 .35882 m
.67518 .35882 L
s
.67524 .36129 m
.67524 .36129 L
s
.67532 .35777 m
.67532 .35777 L
s
.67539 .35471 m
.67539 .35471 L
s
.67547 .35259 m
.67547 .35259 L
s
.67554 .35565 m
.67554 .35565 L
s
.67562 .35741 m
.67562 .35741 L
s
.67569 .35565 m
.67569 .35565 L
s
.67576 .35894 m
.67576 .35894 L
s
.67584 .35271 m
.67584 .35271 L
s
.67592 .35284 m
.67592 .35284 L
s
.67599 .34955 m
.67599 .34955 L
s
.67606 .35095 m
.67606 .35095 L
s
.67613 .34813 m
.67613 .34813 L
s
.67621 .35588 m
.67621 .35588 L
s
.67628 .35518 m
.67628 .35518 L
s
.67636 .35307 m
.67636 .35307 L
s
.67643 .35119 m
.67643 .35119 L
s
.67651 .35354 m
.67651 .35354 L
s
.67658 .35553 m
.67658 .35553 L
s
.67666 .35037 m
.67666 .35037 L
s
.67674 .35002 m
.67674 .35002 L
s
.67681 .35084 m
.67681 .35084 L
s
.67688 .35013 m
.67688 .35013 L
s
.67695 .35119 m
.67695 .35119 L
s
.67703 .35048 m
.67703 .35048 L
s
.6771 .34649 m
.6771 .34649 L
s
.67718 .34661 m
.67718 .34661 L
s
.67725 .34778 m
.67725 .34778 L
s
.67733 .35037 m
.67733 .35037 L
s
.6774 .3479 m
.6774 .3479 L
s
.67747 .34931 m
.67747 .34931 L
s
.67755 .34778 m
.67755 .34778 L
s
.67762 .35107 m
.67762 .35107 L
s
.67769 .35048 m
.67769 .35048 L
s
.67777 .35119 m
.67777 .35119 L
s
.67784 .35072 m
.67784 .35072 L
s
.67792 .34802 m
.67792 .34802 L
s
.67799 .34438 m
.67799 .34438 L
s
.67807 .34438 m
.67807 .34438 L
s
.67814 .33651 m
.67814 .33651 L
s
.67821 .33968 m
.67821 .33968 L
s
.67829 .3398 m
.67829 .3398 L
s
.67837 .34262 m
.67837 .34262 L
s
.67844 .33897 m
.67844 .33897 L
s
.67851 .34109 m
.67851 .34109 L
s
.67859 .33933 m
.67859 .33933 L
s
.67866 .34249 m
.67866 .34249 L
s
.67874 .34097 m
.67874 .34097 L
s
.67881 .3432 m
.67881 .3432 L
s
.67889 .3472 m
.67889 .3472 L
s
.67896 .34755 m
.67896 .34755 L
s
.67903 .35002 m
.67903 .35002 L
s
.6791 .34708 m
.6791 .34708 L
s
.67918 .35013 m
.67918 .35013 L
s
.67926 .34919 m
.67926 .34919 L
s
.67933 .35236 m
.67933 .35236 L
s
.6794 .3486 m
.6794 .3486 L
s
.67948 .34274 m
.67948 .34274 L
s
.67955 .33498 m
.67955 .33498 L
s
.67963 .3284 m
.67963 .3284 L
s
.6797 .33275 m
.6797 .33275 L
s
.67978 .32558 m
.67978 .32558 L
s
.67985 .33017 m
.67985 .33017 L
s
.67992 .32793 m
.67992 .32793 L
s
.68 .3324 m
.68 .3324 L
s
.68007 .33216 m
.68007 .33216 L
s
.68015 .33463 m
.68015 .33463 L
s
.68022 .33451 m
.68022 .33451 L
s
.6803 .3378 m
.6803 .3378 L
s
.68037 .33498 m
.68037 .33498 L
s
.68045 .33005 m
.68045 .33005 L
s
.68052 .3331 m
.68052 .3331 L
s
.68059 .33216 m
.68059 .33216 L
s
.68066 .33052 m
.68066 .33052 L
s
.68074 .32359 m
.68074 .32359 L
s
.68081 .32535 m
.68081 .32535 L
s
.68089 .32324 m
.68089 .32324 L
s
.68096 .32735 m
.68096 .32735 L
s
.68104 .32511 m
.68104 .32511 L
s
.68111 .33052 m
.68111 .33052 L
s
.68119 .32746 m
.68119 .32746 L
s
.68126 .32993 m
.68126 .32993 L
s
.68134 .32476 m
.68134 .32476 L
s
.68141 .32723 m
.68141 .32723 L
s
.68148 .32653 m
.68148 .32653 L
s
.68156 .31948 m
.68156 .31948 L
s
.68163 .31172 m
.68163 .31172 L
s
.68171 .31208 m
.68171 .31208 L
s
.68178 .30891 m
.68178 .30891 L
s
.68186 .30915 m
.68186 .30915 L
s
.68193 .30915 m
.68193 .30915 L
s
.68201 .31255 m
.68201 .31255 L
s
.68208 .30868 m
.68208 .30868 L
s
.68216 .3095 m
.68216 .3095 L
s
.68223 .30386 m
.68223 .30386 L
s
.6823 .3082 m
.6823 .3082 L
s
.68237 .30292 m
.68237 .30292 L
s
.68245 .2994 m
.68245 .2994 L
s
.68252 .29505 m
.68252 .29505 L
s
.6826 .29587 m
.6826 .29587 L
s
.68267 .30609 m
.68267 .30609 L
s
.68275 .30656 m
.68275 .30656 L
s
.68282 .31196 m
.68282 .31196 L
s
.6829 .31055 m
.6829 .31055 L
s
.68298 .30938 m
.68298 .30938 L
s
.68304 .29963 m
.68304 .29963 L
s
.68312 .29798 m
.68312 .29798 L
s
.68319 .29681 m
.68319 .29681 L
s
.68327 .29505 m
.68327 .29505 L
s
.68334 .29493 m
.68334 .29493 L
s
.68342 .29998 m
.68342 .29998 L
s
.68349 .31102 m
.68349 .31102 L
s
.68357 .30915 m
.68357 .30915 L
s
.68364 .31666 m
.68364 .31666 L
s
.68372 .31631 m
.68372 .31631 L
s
.68379 .3183 m
.68379 .3183 L
s
.68386 .3109 m
.68386 .3109 L
s
.68393 .31561 m
.68393 .31561 L
s
.68401 .30926 m
.68401 .30926 L
s
.68408 .31302 m
.68408 .31302 L
s
.68416 .31114 m
.68416 .31114 L
s
.68423 .31172 m
.68423 .31172 L
s
.68431 .31408 m
.68431 .31408 L
s
.68438 .31501 m
.68438 .31501 L
s
.68446 .31326 m
.68446 .31326 L
s
.68454 .3102 m
.68454 .3102 L
s
.68461 .30808 m
.68461 .30808 L
s
.68468 .31736 m
.68468 .31736 L
s
.68475 .32347 m
.68475 .32347 L
s
.68483 .33052 m
.68483 .33052 L
s
.6849 .33216 m
.6849 .33216 L
s
.68498 .33416 m
.68498 .33416 L
s
.68505 .34015 m
.68505 .34015 L
s
.68513 .34367 m
.68513 .34367 L
s
.6852 .33604 m
.6852 .33604 L
s
.68528 .33639 m
.68528 .33639 L
s
.68535 .33933 m
.68535 .33933 L
s
.68542 .35107 m
.68542 .35107 L
s
.68549 .34696 m
.68549 .34696 L
s
.68557 .35025 m
.68557 .35025 L
s
.68564 .3587 m
.68564 .3587 L
s
.68572 .36458 m
.68572 .36458 L
s
.68579 .36658 m
.68579 .36658 L
s
.68587 .36411 m
.68587 .36411 L
s
.68594 .36669 m
.68594 .36669 L
s
.68601 .36927 m
.68601 .36927 L
s
.68609 .36446 m
.68609 .36446 L
s
.68617 .35753 m
.68617 .35753 L
s
.68624 .35284 m
.68624 .35284 L
s
.68631 .34813 m
.68631 .34813 L
s
.68639 .35002 m
.68639 .35002 L
s
.68646 .35048 m
.68646 .35048 L
s
.68654 .34872 m
.68654 .34872 L
s
.68661 .35331 m
.68661 .35331 L
s
.68669 .34473 m
.68669 .34473 L
s
.68676 .34109 m
.68676 .34109 L
s
.68683 .34414 m
.68683 .34414 L
s
.68691 .34461 m
.68691 .34461 L
s
.68699 .34473 m
.68699 .34473 L
s
.68706 .34696 m
.68706 .34696 L
s
.68713 .35201 m
.68713 .35201 L
s
.6872 .35741 m
.6872 .35741 L
s
.68728 .35823 m
.68728 .35823 L
s
.68735 .36341 m
.68735 .36341 L
s
.68743 .36505 m
.68743 .36505 L
s
.6875 .36904 m
.6875 .36904 L
s
.68758 .36798 m
.68758 .36798 L
s
.68765 .37479 m
.68765 .37479 L
s
.68772 .37972 m
.68772 .37972 L
s
.6878 .37773 m
.6878 .37773 L
s
.68787 .38466 m
.68787 .38466 L
s
.68795 .38595 m
.68795 .38595 L
s
.68802 .38266 m
.68802 .38266 L
s
.6881 .38407 m
.6881 .38407 L
s
.68817 .37867 m
.68817 .37867 L
s
.68825 .38008 m
.68825 .38008 L
s
.68832 .38055 m
.68832 .38055 L
s
.68839 .37867 m
.68839 .37867 L
s
.68846 .37656 m
.68846 .37656 L
s
.68854 .37997 m
.68854 .37997 L
s
.68862 .38079 m
.68862 .38079 L
s
.68869 .38125 m
.68869 .38125 L
s
.68876 .38137 m
.68876 .38137 L
s
.68884 .38443 m
.68884 .38443 L
s
.68891 .38748 m
.68891 .38748 L
s
.68899 .38466 m
.68899 .38466 L
s
.68906 .38665 m
.68906 .38665 L
s
.68914 .39065 m
.68914 .39065 L
s
.68921 .39464 m
.68921 .39464 L
s
.68928 .39699 m
.68928 .39699 L
s
.68936 .39899 m
.68936 .39899 L
s
.68943 .39992 m
.68943 .39992 L
s
.68951 .39887 m
.68951 .39887 L
s
.68958 .39605 m
.68958 .39605 L
s
.68966 .38795 m
.68966 .38795 L
s
.68973 .38689 m
.68973 .38689 L
s
.68981 .38525 m
.68981 .38525 L
s
.68988 .38889 m
.68988 .38889 L
s
.68996 .38853 m
.68996 .38853 L
s
.69003 .38689 m
.69003 .38689 L
s
.6901 .38853 m
.6901 .38853 L
s
.69017 .39147 m
.69017 .39147 L
s
.69025 .39593 m
.69025 .39593 L
s
.69032 .39299 m
.69032 .39299 L
s
.6904 .39018 m
.6904 .39018 L
s
.69047 .38783 m
.69047 .38783 L
s
.69055 .38689 m
.69055 .38689 L
s
.69062 .38407 m
.69062 .38407 L
s
.6907 .38525 m
.6907 .38525 L
s
.69078 .38289 m
.69078 .38289 L
s
.69084 .38618 m
.69084 .38618 L
s
.69092 .38161 m
.69092 .38161 L
s
.69099 .37832 m
.69099 .37832 L
s
.69107 .37351 m
.69107 .37351 L
s
.69114 .37057 m
.69114 .37057 L
s
.69122 .36822 m
.69122 .36822 L
s
.69129 .36705 m
.69129 .36705 L
s
.69137 .37162 m
.69137 .37162 L
s
.69144 .37139 m
.69144 .37139 L
s
.69152 .3674 m
.69152 .3674 L
s
.69159 .37256 m
.69159 .37256 L
s
.69166 .37069 m
.69166 .37069 L
s
.69173 .36951 m
.69173 .36951 L
s
.69181 .37256 m
.69181 .37256 L
s
.69188 .37256 m
.69188 .37256 L
s
.69196 .37726 m
.69196 .37726 L
s
.69203 .37797 m
.69203 .37797 L
s
.69211 .37303 m
.69211 .37303 L
s
.69218 .37303 m
.69218 .37303 L
s
.69226 .37045 m
.69226 .37045 L
s
.69234 .37069 m
.69234 .37069 L
s
.69241 .36633 m
.69241 .36633 L
s
.69248 .37022 m
.69248 .37022 L
s
.69255 .36693 m
.69255 .36693 L
s
.69263 .36693 m
.69263 .36693 L
s
.6927 .36329 m
.6927 .36329 L
s
.69278 .37197 m
.69278 .37197 L
s
.69285 .37139 m
.69285 .37139 L
s
.69293 .37221 m
.69293 .37221 L
s
.693 .37468 m
.693 .37468 L
s
.69308 .3775 m
.69308 .3775 L
s
.69315 .37679 m
.69315 .37679 L
s
.69322 .37656 m
.69322 .37656 L
s
.69329 .37808 m
.69329 .37808 L
s
.69337 .37832 m
.69337 .37832 L
s
.69344 .37421 m
.69344 .37421 L
s
.69352 .3789 m
.69352 .3789 L
s
.69359 .38595 m
.69359 .38595 L
s
.69367 .3802 m
.69367 .3802 L
s
.69374 .37867 m
.69374 .37867 L
s
.69382 .37668 m
.69382 .37668 L
s
.6939 .37668 m
.6939 .37668 L
s
.69397 .38161 m
.69397 .38161 L
s
.69404 .38689 m
.69404 .38689 L
s
.69411 .38266 m
.69411 .38266 L
s
.69419 .38254 m
.69419 .38254 L
s
.69426 .37738 m
.69426 .37738 L
s
.69434 .37374 m
.69434 .37374 L
s
.69441 .37797 m
.69441 .37797 L
s
.69449 .37209 m
.69449 .37209 L
s
.69456 .36728 m
.69456 .36728 L
s
.69463 .36658 m
.69463 .36658 L
s
.69471 .36211 m
.69471 .36211 L
s
.69479 .36105 m
.69479 .36105 L
s
.69486 .36141 m
.69486 .36141 L
s
.69493 .3553 m
.69493 .3553 L
s
.695 .35683 m
.695 .35683 L
s
.69508 .35812 m
.69508 .35812 L
s
.69515 .35636 m
.69515 .35636 L
s
.69523 .35259 m
.69523 .35259 L
s
.6953 .35331 m
.6953 .35331 L
s
.69538 .35177 m
.69538 .35177 L
s
.69545 .35683 m
.69545 .35683 L
s
.69553 .36411 m
.69553 .36411 L
s
.69561 .36458 m
.69561 .36458 L
s
.69567 .35366 m
.69567 .35366 L
s
.69575 .35812 m
.69575 .35812 L
s
.69582 .34766 m
.69582 .34766 L
s
.6959 .36141 m
.6959 .36141 L
s
.69597 .36399 m
.69597 .36399 L
s
.69605 .36341 m
.69605 .36341 L
s
.69612 .36152 m
.69612 .36152 L
s
.69619 .36012 m
.69619 .36012 L
s
.69626 .36152 m
.69626 .36152 L
s
.69634 .36693 m
.69634 .36693 L
s
.69642 .37315 m
.69642 .37315 L
s
.69649 .37303 m
.69649 .37303 L
s
.69656 .37339 m
.69656 .37339 L
s
.69664 .36658 m
.69664 .36658 L
s
.69671 .37479 m
.69671 .37479 L
s
.69679 .37773 m
.69679 .37773 L
s
.69686 .37984 m
.69686 .37984 L
s
.69694 .37855 m
.69694 .37855 L
s
.69701 .37797 m
.69701 .37797 L
s
.69708 .38125 m
.69708 .38125 L
s
.69716 .38865 m
.69716 .38865 L
s
.69724 .38536 m
.69724 .38536 L
s
.69731 .38278 m
.69731 .38278 L
s
.69738 .39229 m
.69738 .39229 L
s
.69746 .38361 m
.69746 .38361 L
s
.69753 .38361 m
.69753 .38361 L
s
.69761 .38396 m
.69761 .38396 L
s
.69768 .3809 m
.69768 .3809 L
s
.69776 .38466 m
.69776 .38466 L
s
.69783 .38618 m
.69783 .38618 L
s
.6979 .38889 m
.6979 .38889 L
s
.69797 .39042 m
.69797 .39042 L
s
.69805 .39299 m
.69805 .39299 L
s
.69812 .39311 m
.69812 .39311 L
s
.6982 .39453 m
.6982 .39453 L
s
.69827 .39429 m
.69827 .39429 L
s
.69835 .39288 m
.69835 .39288 L
s
.69842 .39335 m
.69842 .39335 L
s
.6985 .38947 m
.6985 .38947 L
s
.69858 .38807 m
.69858 .38807 L
s
.69864 .39687 m
.69864 .39687 L
s
.69872 .39089 m
.69872 .39089 L
s
.69879 .38513 m
.69879 .38513 L
s
.69887 .38396 m
.69887 .38396 L
s
.69894 .38219 m
.69894 .38219 L
s
.69902 .38466 m
.69902 .38466 L
s
.69909 .38454 m
.69909 .38454 L
s
.69917 .38478 m
.69917 .38478 L
s
.69924 .38642 m
.69924 .38642 L
s
.69932 .39042 m
.69932 .39042 L
s
.69939 .3802 m
.69939 .3802 L
s
.69946 .37515 m
.69946 .37515 L
s
.69953 .37679 m
.69953 .37679 L
s
.69961 .37879 m
.69961 .37879 L
s
.69968 .3775 m
.69968 .3775 L
s
.69976 .37327 m
.69976 .37327 L
s
.69983 .37115 m
.69983 .37115 L
s
.69991 .37279 m
.69991 .37279 L
s
.69998 .37115 m
.69998 .37115 L
s
.70006 .37045 m
.70006 .37045 L
s
.70014 .3688 m
.70014 .3688 L
s
.70021 .36681 m
.70021 .36681 L
s
.70028 .36575 m
.70028 .36575 L
s
.70035 .36974 m
.70035 .36974 L
s
.70043 .37397 m
.70043 .37397 L
s
.7005 .37679 m
.7005 .37679 L
s
.70058 .38161 m
.70058 .38161 L
s
.70065 .37033 m
.70065 .37033 L
s
.70073 .36469 m
.70073 .36469 L
s
.7008 .36223 m
.7008 .36223 L
s
.70088 .35753 m
.70088 .35753 L
s
.70095 .36646 m
.70095 .36646 L
s
.70103 .36798 m
.70103 .36798 L
s
.70109 .36528 m
.70109 .36528 L
s
.70117 .35952 m
.70117 .35952 L
s
.70124 .36152 m
.70124 .36152 L
s
.70132 .36293 m
.70132 .36293 L
s
.70139 .36563 m
.70139 .36563 L
s
.70147 .36622 m
.70147 .36622 L
s
.70154 .36446 m
.70154 .36446 L
s
.70162 .36364 m
.70162 .36364 L
s
.7017 .36469 m
.7017 .36469 L
s
.70177 .36281 m
.70177 .36281 L
s
.70184 .35812 m
.70184 .35812 L
s
.70191 .35777 m
.70191 .35777 L
s
.70199 .35965 m
.70199 .35965 L
s
.70206 .35683 m
.70206 .35683 L
s
.70214 .35765 m
.70214 .35765 L
s
.70221 .35917 m
.70221 .35917 L
s
.70229 .36187 m
.70229 .36187 L
s
.70236 .36258 m
.70236 .36258 L
s
.70244 .36763 m
.70244 .36763 L
s
.70251 .36693 m
.70251 .36693 L
s
.70259 .35612 m
.70259 .35612 L
s
.70266 .36012 m
.70266 .36012 L
s
.70273 .36082 m
.70273 .36082 L
s
.7028 .35354 m
.7028 .35354 L
s
.70288 .35224 m
.70288 .35224 L
s
.70295 .35154 m
.70295 .35154 L
s
.70303 .34907 m
.70303 .34907 L
s
.7031 .35213 m
.7031 .35213 L
s
.70318 .34966 m
.70318 .34966 L
s
.70325 .34649 m
.70325 .34649 L
s
.70333 .34508 m
.70333 .34508 L
s
.70341 .34391 m
.70341 .34391 L
s
.70347 .34015 m
.70347 .34015 L
s
.70355 .34849 m
.70355 .34849 L
s
.70362 .35718 m
.70362 .35718 L
s
.7037 .36352 m
.7037 .36352 L
s
.70377 .37022 m
.70377 .37022 L
s
.70385 .36481 m
.70385 .36481 L
s
.70392 .36399 m
.70392 .36399 L
s
.704 .35965 m
.704 .35965 L
s
.70407 .35377 m
.70407 .35377 L
s
.70415 .35894 m
.70415 .35894 L
s
.70422 .36387 m
.70422 .36387 L
s
.70429 .36575 m
.70429 .36575 L
s
.70436 .36293 m
.70436 .36293 L
s
.70444 .36681 m
.70444 .36681 L
s
.70451 .36317 m
.70451 .36317 L
s
.70459 .36423 m
.70459 .36423 L
s
.70466 .35636 m
.70466 .35636 L
s
.70474 .35636 m
.70474 .35636 L
s
.70481 .36094 m
.70481 .36094 L
s
.70488 .35236 m
.70488 .35236 L
s
.70496 .35541 m
.70496 .35541 L
s
.70504 .35671 m
.70504 .35671 L
s
.70511 .35941 m
.70511 .35941 L
s
.70518 .35765 m
.70518 .35765 L
s
.70526 .35905 m
.70526 .35905 L
s
.70533 .35683 m
.70533 .35683 L
s
.70541 .36129 m
.70541 .36129 L
s
.70548 .36187 m
.70548 .36187 L
s
.70556 .35354 m
.70556 .35354 L
s
.70563 .35401 m
.70563 .35401 L
s
.7057 .35588 m
.7057 .35588 L
s
.70578 .36129 m
.70578 .36129 L
s
.70586 .36223 m
.70586 .36223 L
s
.70592 .36927 m
.70592 .36927 L
s
.706 .36716 m
.706 .36716 L
s
.70607 .3661 m
.70607 .3661 L
s
.70615 .36728 m
.70615 .36728 L
s
.70622 .36658 m
.70622 .36658 L
s
.7063 .36633 m
.7063 .36633 L
s
.70638 .37351 m
.70638 .37351 L
s
.70644 .37468 m
.70644 .37468 L
s
.70652 .37351 m
.70652 .37351 L
s
.70659 .36646 m
.70659 .36646 L
s
.70667 .36117 m
.70667 .36117 L
s
.70674 .36669 m
.70674 .36669 L
s
.70682 .36423 m
.70682 .36423 L
s
.70689 .36598 m
.70689 .36598 L
s
.70697 .3654 m
.70697 .3654 L
s
.70704 .36705 m
.70704 .36705 L
s
.70712 .35965 m
.70712 .35965 L
s
.70719 .35694 m
.70719 .35694 L
s
.70726 .35107 m
.70726 .35107 L
s
.70733 .35201 m
.70733 .35201 L
s
.70741 .35048 m
.70741 .35048 L
s
.70749 .35259 m
.70749 .35259 L
s
.70756 .34931 m
.70756 .34931 L
s
.70763 .34673 m
.70763 .34673 L
s
.70771 .34614 m
.70771 .34614 L
s
.70778 .3472 m
.70778 .3472 L
s
.70786 .35201 m
.70786 .35201 L
s
.70794 .35084 m
.70794 .35084 L
s
.70801 .35753 m
.70801 .35753 L
s
.70808 .35518 m
.70808 .35518 L
s
.70815 .35401 m
.70815 .35401 L
s
.70823 .34837 m
.70823 .34837 L
s
.7083 .34567 m
.7083 .34567 L
s
.70838 .3371 m
.70838 .3371 L
s
.70845 .34062 m
.70845 .34062 L
s
.70853 .34766 m
.70853 .34766 L
s
.7086 .34062 m
.7086 .34062 L
s
.70868 .33933 m
.70868 .33933 L
s
.70875 .33616 m
.70875 .33616 L
s
.70883 .33404 m
.70883 .33404 L
s
.70889 .3452 m
.70889 .3452 L
s
.70897 .34038 m
.70897 .34038 L
s
.70904 .33921 m
.70904 .33921 L
s
.70912 .33897 m
.70912 .33897 L
s
.70919 .34109 m
.70919 .34109 L
s
.70927 .34578 m
.70927 .34578 L
s
.70934 .34485 m
.70934 .34485 L
s
.70942 .35154 m
.70942 .35154 L
s
.7095 .35236 m
.7095 .35236 L
s
.70957 .34943 m
.70957 .34943 L
s
.70964 .34485 m
.70964 .34485 L
s
.70971 .35072 m
.70971 .35072 L
s
.70979 .34226 m
.70979 .34226 L
s
.70986 .34485 m
.70986 .34485 L
s
.70994 .33451 m
.70994 .33451 L
s
.71001 .33087 m
.71001 .33087 L
s
.71009 .33334 m
.71009 .33334 L
s
.71016 .3351 m
.71016 .3351 L
s
.71024 .33299 m
.71024 .33299 L
s
.71031 .33287 m
.71031 .33287 L
s
.71039 .32911 m
.71039 .32911 L
s
.71046 .32735 m
.71046 .32735 L
s
.71053 .32982 m
.71053 .32982 L
s
.7106 .32511 m
.7106 .32511 L
s
.71068 .32606 m
.71068 .32606 L
s
.71075 .33005 m
.71075 .33005 L
s
.71083 .33157 m
.71083 .33157 L
s
.7109 .32653 m
.7109 .32653 L
s
.71098 .3297 m
.71098 .3297 L
s
.71105 .33862 m
.71105 .33862 L
s
.71113 .33921 m
.71113 .33921 L
s
.71121 .34085 m
.71121 .34085 L
s
.71127 .33404 m
.71127 .33404 L
s
.71135 .33439 m
.71135 .33439 L
s
.71142 .34167 m
.71142 .34167 L
s
.7115 .34414 m
.7115 .34414 L
s
.71157 .34543 m
.71157 .34543 L
s
.71165 .34802 m
.71165 .34802 L
s
.71172 .34015 m
.71172 .34015 L
s
.7118 .34085 m
.7118 .34085 L
s
.71187 .34426 m
.71187 .34426 L
s
.71195 .34555 m
.71195 .34555 L
s
.71202 .35342 m
.71202 .35342 L
s
.71209 .35777 m
.71209 .35777 L
s
.71216 .35389 m
.71216 .35389 L
s
.71224 .35448 m
.71224 .35448 L
s
.71231 .3553 m
.71231 .3553 L
s
.71239 .36223 m
.71239 .36223 L
s
.71246 .36763 m
.71246 .36763 L
s
.71254 .36399 m
.71254 .36399 L
s
.71261 .3607 m
.71261 .3607 L
s
.71268 .35929 m
.71268 .35929 L
s
.71276 .36317 m
.71276 .36317 L
s
.71284 .36927 m
.71284 .36927 L
s
.71291 .37162 m
.71291 .37162 L
s
.71298 .36857 m
.71298 .36857 L
s
.71306 .37045 m
.71306 .37045 L
s
.71313 .37444 m
.71313 .37444 L
s
.71321 .37668 m
.71321 .37668 L
s
.71328 .3708 m
.71328 .3708 L
s
.71336 .37022 m
.71336 .37022 L
s
.71343 .36962 m
.71343 .36962 L
s
.7135 .37244 m
.7135 .37244 L
s
.71358 .36951 m
.71358 .36951 L
s
.71366 .3688 m
.71366 .3688 L
s
.71372 .37409 m
.71372 .37409 L
s
.7138 .37561 m
.7138 .37561 L
s
.71387 .37468 m
.71387 .37468 L
s
.71395 .37033 m
.71395 .37033 L
s
.71402 .36869 m
.71402 .36869 L
s
.7141 .36962 m
.7141 .36962 L
s
.71418 .37186 m
.71418 .37186 L
s
.71424 .36728 m
.71424 .36728 L
s
.71432 .37608 m
.71432 .37608 L
s
.71439 .37585 m
.71439 .37585 L
s
.71447 .37162 m
.71447 .37162 L
s
.71454 .37585 m
.71454 .37585 L
s
.71462 .37268 m
.71462 .37268 L
s
.71469 .38043 m
.71469 .38043 L
s
.71477 .38478 m
.71477 .38478 L
s
.71484 .38935 m
.71484 .38935 L
s
.71492 .39171 m
.71492 .39171 L
s
.71499 .38008 m
.71499 .38008 L
s
.71506 .38419 m
.71506 .38419 L
s
.71513 .38243 m
.71513 .38243 L
s
.71521 .38079 m
.71521 .38079 L
s
.71529 .38219 m
.71529 .38219 L
s
.71536 .37867 m
.71536 .37867 L
s
.71543 .37632 m
.71543 .37632 L
s
.71551 .38008 m
.71551 .38008 L
s
.71558 .3809 m
.71558 .3809 L
s
.71566 .38243 m
.71566 .38243 L
s
.71574 .37832 m
.71574 .37832 L
s
.71581 .37479 m
.71581 .37479 L
s
.71588 .3789 m
.71588 .3789 L
s
.71595 .37491 m
.71595 .37491 L
s
.71603 .37961 m
.71603 .37961 L
s
.7161 .37468 m
.7161 .37468 L
s
.71618 .36904 m
.71618 .36904 L
s
.71625 .36716 m
.71625 .36716 L
s
.71633 .36152 m
.71633 .36152 L
s
.7164 .35765 m
.7164 .35765 L
s
.71648 .36211 m
.71648 .36211 L
s
.71655 .36059 m
.71655 .36059 L
s
.71663 .36187 m
.71663 .36187 L
s
.71669 .36329 m
.71669 .36329 L
s
.71677 .36211 m
.71677 .36211 L
s
.71684 .36152 m
.71684 .36152 L
s
.71692 .36317 m
.71692 .36317 L
s
.71699 .36892 m
.71699 .36892 L
s
.71707 .37022 m
.71707 .37022 L
s
.71714 .37421 m
.71714 .37421 L
s
.71722 .37679 m
.71722 .37679 L
s
.7173 .37209 m
.7173 .37209 L
s
.71737 .37632 m
.71737 .37632 L
s
.71744 .36998 m
.71744 .36998 L
s
.71751 .37221 m
.71751 .37221 L
s
.71759 .37162 m
.71759 .37162 L
s
.71766 .37456 m
.71766 .37456 L
s
.71774 .37561 m
.71774 .37561 L
s
.71781 .37374 m
.71781 .37374 L
s
.71789 .36845 m
.71789 .36845 L
s
.71796 .3661 m
.71796 .3661 L
s
.71804 .36446 m
.71804 .36446 L
s
.71811 .36199 m
.71811 .36199 L
s
.71819 .36434 m
.71819 .36434 L
s
.71826 .36376 m
.71826 .36376 L
s
.71833 .36281 m
.71833 .36281 L
s
.7184 .36927 m
.7184 .36927 L
s
.71848 .37279 m
.71848 .37279 L
s
.71855 .37691 m
.71855 .37691 L
s
.71863 .38102 m
.71863 .38102 L
s
.7187 .39299 m
.7187 .39299 L
s
.71878 .39276 m
.71878 .39276 L
s
.71886 .38525 m
.71886 .38525 L
s
.71893 .38454 m
.71893 .38454 L
s
.71901 .38783 m
.71901 .38783 L
s
.71907 .37984 m
.71907 .37984 L
s
.71915 .37949 m
.71915 .37949 L
s
.71922 .36857 m
.71922 .36857 L
s
.7193 .37479 m
.7193 .37479 L
s
.71937 .3701 m
.71937 .3701 L
s
.71945 .37127 m
.71945 .37127 L
s
.71952 .3708 m
.71952 .3708 L
s
.7196 .37045 m
.7196 .37045 L
s
.71967 .37022 m
.71967 .37022 L
s
.71975 .36962 m
.71975 .36962 L
s
.71982 .37022 m
.71982 .37022 L
s
.71989 .37433 m
.71989 .37433 L
s
.71996 .37444 m
.71996 .37444 L
s
.72004 .37315 m
.72004 .37315 L
s
.72011 .36998 m
.72011 .36998 L
s
.72019 .36763 m
.72019 .36763 L
s
.72026 .36012 m
.72026 .36012 L
s
.72034 .36035 m
.72034 .36035 L
s
.72041 .35905 m
.72041 .35905 L
s
.72049 .36281 m
.72049 .36281 L
s
.72057 .35952 m
.72057 .35952 L
s
.72064 .35788 m
.72064 .35788 L
s
.72071 .3553 m
.72071 .3553 L
s
.72078 .35553 m
.72078 .35553 L
s
.72086 .35072 m
.72086 .35072 L
s
.72093 .35259 m
.72093 .35259 L
s
.72101 .34907 m
.72101 .34907 L
s
.72108 .34708 m
.72108 .34708 L
s
.72116 .34485 m
.72116 .34485 L
s
.72123 .33956 m
.72123 .33956 L
s
.7213 .34027 m
.7213 .34027 L
s
.72138 .34332 m
.72138 .34332 L
s
.72146 .3351 m
.72146 .3351 L
s
.72152 .33428 m
.72152 .33428 L
s
.7216 .33721 m
.7216 .33721 L
s
.72167 .34226 m
.72167 .34226 L
s
.72175 .34673 m
.72175 .34673 L
s
.72182 .34344 m
.72182 .34344 L
s
.7219 .34426 m
.7219 .34426 L
s
.72198 .34614 m
.72198 .34614 L
s
.72204 .33803 m
.72204 .33803 L
s
.72212 .33686 m
.72212 .33686 L
s
.7222 .33568 m
.7222 .33568 L
s
.72227 .35002 m
.72227 .35002 L
s
.72234 .35224 m
.72234 .35224 L
s
.72242 .35248 m
.72242 .35248 L
s
.72249 .35295 m
.72249 .35295 L
s
.72257 .35189 m
.72257 .35189 L
s
.72264 .35048 m
.72264 .35048 L
s
.72272 .34943 m
.72272 .34943 L
s
.72279 .35541 m
.72279 .35541 L
s
.72286 .35588 m
.72286 .35588 L
s
.72293 .35142 m
.72293 .35142 L
s
.72301 .3573 m
.72301 .3573 L
s
.72309 .35553 m
.72309 .35553 L
s
.72316 .35894 m
.72316 .35894 L
s
.72323 .35401 m
.72323 .35401 L
s
.72331 .35166 m
.72331 .35166 L
s
.72338 .35612 m
.72338 .35612 L
s
.72346 .35671 m
.72346 .35671 L
s
.72354 .35624 m
.72354 .35624 L
s
.72361 .35659 m
.72361 .35659 L
s
.72368 .35952 m
.72368 .35952 L
s
.72375 .35882 m
.72375 .35882 L
s
.72383 .35506 m
.72383 .35506 L
s
.7239 .35952 m
.7239 .35952 L
s
.72398 .3573 m
.72398 .3573 L
s
.72405 .36035 m
.72405 .36035 L
s
.72413 .35777 m
.72413 .35777 L
s
.7242 .36633 m
.7242 .36633 L
s
.72428 .37279 m
.72428 .37279 L
s
.72435 .36987 m
.72435 .36987 L
s
.72443 .37561 m
.72443 .37561 L
s
.72449 .37972 m
.72449 .37972 L
s
.72457 .38642 m
.72457 .38642 L
s
.72464 .3802 m
.72464 .3802 L
s
.72472 .37679 m
.72472 .37679 L
s
.72479 .3755 m
.72479 .3755 L
s
.72487 .37115 m
.72487 .37115 L
s
.72494 .36998 m
.72494 .36998 L
s
.72502 .36763 m
.72502 .36763 L
s
.7251 .36423 m
.7251 .36423 L
s
.72517 .36035 m
.72517 .36035 L
s
.72524 .36411 m
.72524 .36411 L
s
.72531 .35965 m
.72531 .35965 L
s
.72539 .35271 m
.72539 .35271 L
s
.72546 .35436 m
.72546 .35436 L
s
.72554 .36082 m
.72554 .36082 L
s
.72561 .36833 m
.72561 .36833 L
s
.72569 .36434 m
.72569 .36434 L
s
.72576 .36469 m
.72576 .36469 L
s
.72584 .35859 m
.72584 .35859 L
s
.72591 .36352 m
.72591 .36352 L
s
.72599 .36269 m
.72599 .36269 L
s
.72606 .36234 m
.72606 .36234 L
s
.72613 .36869 m
.72613 .36869 L
s
.7262 .37057 m
.7262 .37057 L
s
.72628 .36246 m
.72628 .36246 L
s
.72635 .35929 m
.72635 .35929 L
s
.72643 .35636 m
.72643 .35636 L
s
.7265 .35377 m
.7265 .35377 L
s
.72658 .35002 m
.72658 .35002 L
s
.72666 .3459 m
.72666 .3459 L
s
.72673 .34966 m
.72673 .34966 L
s
.72681 .34661 m
.72681 .34661 L
s
.72687 .34766 m
.72687 .34766 L
s
.72695 .34684 m
.72695 .34684 L
s
.72702 .34543 m
.72702 .34543 L
s
.7271 .3432 m
.7271 .3432 L
s
.72717 .34473 m
.72717 .34473 L
s
.72725 .34097 m
.72725 .34097 L
s
.72732 .34203 m
.72732 .34203 L
s
.7274 .33874 m
.7274 .33874 L
s
.72747 .33827 m
.72747 .33827 L
s
.72755 .33921 m
.72755 .33921 L
s
.72762 .33992 m
.72762 .33992 L
s
.72769 .33475 m
.72769 .33475 L
s
.72776 .33169 m
.72776 .33169 L
s
.72784 .33545 m
.72784 .33545 L
s
.72791 .33545 m
.72791 .33545 L
s
.72799 .3378 m
.72799 .3378 L
s
.72806 .34179 m
.72806 .34179 L
s
.72814 .34461 m
.72814 .34461 L
s
.72821 .33545 m
.72821 .33545 L
s
.72829 .33639 m
.72829 .33639 L
s
.72837 .33216 m
.72837 .33216 L
s
.72844 .33287 m
.72844 .33287 L
s
.72851 .33357 m
.72851 .33357 L
s
.72858 .3324 m
.72858 .3324 L
s
.72866 .32875 m
.72866 .32875 L
s
.72873 .31865 m
.72873 .31865 L
s
.72881 .31901 m
.72881 .31901 L
s
.72888 .3169 m
.72888 .3169 L
s
.72896 .31795 m
.72896 .31795 L
s
.72903 .323 m
.72903 .323 L
s
.72911 .32547 m
.72911 .32547 L
s
.72918 .33169 m
.72918 .33169 L
s
.72926 .32793 m
.72926 .32793 L
s
.72932 .32406 m
.72932 .32406 L
s
.7294 .32558 m
.7294 .32558 L
s
.72947 .32464 m
.72947 .32464 L
s
.72955 .32664 m
.72955 .32664 L
s
.72962 .32464 m
.72962 .32464 L
s
.7297 .32289 m
.7297 .32289 L
s
.72978 .32206 m
.72978 .32206 L
s
.72984 .31584 m
.72984 .31584 L
s
.72992 .3088 m
.72992 .3088 L
s
.73 .3095 m
.73 .3095 L
s
.73007 .3095 m
.73007 .3095 L
s
.73014 .30997 m
.73014 .30997 L
s
.73022 .30668 m
.73022 .30668 L
s
.73029 .3075 m
.73029 .3075 L
s
.73037 .30762 m
.73037 .30762 L
s
.73044 .3102 m
.73044 .3102 L
s
.73052 .31267 m
.73052 .31267 L
s
.73059 .30726 m
.73059 .30726 L
s
.73066 .30621 m
.73066 .30621 L
s
.73074 .3068 m
.73074 .3068 L
s
.73082 .3028 m
.73082 .3028 L
s
.73089 .30316 m
.73089 .30316 L
s
.73096 .30491 m
.73096 .30491 L
s
.73103 .30962 m
.73103 .30962 L
s
.73111 .31172 m
.73111 .31172 L
s
.73118 .30997 m
.73118 .30997 L
s
.73126 .30316 m
.73126 .30316 L
s
.73134 .29858 m
.73134 .29858 L
s
.73141 .2981 m
.73141 .2981 L
s
.73148 .3122 m
.73148 .3122 L
s
.73155 .3122 m
.73155 .3122 L
s
.73163 .30574 m
.73163 .30574 L
s
.7317 .31079 m
.7317 .31079 L
s
.73178 .31279 m
.73178 .31279 L
s
.73185 .30598 m
.73185 .30598 L
s
.73193 .31184 m
.73193 .31184 L
s
.732 .30539 m
.732 .30539 L
s
.73208 .30468 m
.73208 .30468 L
s
.73215 .30022 m
.73215 .30022 L
s
.73223 .29905 m
.73223 .29905 L
s
.73229 .30187 m
.73229 .30187 L
s
.73237 .29576 m
.73237 .29576 L
s
.73245 .29352 m
.73245 .29352 L
s
.73252 .28742 m
.73252 .28742 L
s
.73259 .28155 m
.73259 .28155 L
s
.73267 .28131 m
.73267 .28131 L
s
.73274 .28284 m
.73274 .28284 L
s
.73282 .27955 m
.73282 .27955 L
s
.7329 .27673 m
.7329 .27673 L
s
.73297 .2779 m
.73297 .2779 L
s
.73304 .27885 m
.73304 .27885 L
s
.73311 .27673 m
.73311 .27673 L
s
.73319 .27297 m
.73319 .27297 L
s
.73326 .27109 m
.73326 .27109 L
s
.73334 .26686 m
.73334 .26686 L
s
.73341 .27168 m
.73341 .27168 L
s
.73349 .27074 m
.73349 .27074 L
s
.73356 .27673 m
.73356 .27673 L
s
.73364 .27567 m
.73364 .27567 L
s
.73371 .27696 m
.73371 .27696 L
s
.73379 .2799 m
.73379 .2799 L
s
.73386 .2819 m
.73386 .2819 L
s
.73393 .28683 m
.73393 .28683 L
s
.734 .28848 m
.734 .28848 L
s
.73408 .29 m
.73408 .29 L
s
.73415 .29658 m
.73415 .29658 L
s
.73423 .30034 m
.73423 .30034 L
s
.7343 .30316 m
.7343 .30316 L
s
.73438 .30327 m
.73438 .30327 L
s
.73446 .30362 m
.73446 .30362 L
s
.73453 .30069 m
.73453 .30069 L
s
.73461 .29658 m
.73461 .29658 L
s
.73467 .29094 m
.73467 .29094 L
s
.73475 .29881 m
.73475 .29881 L
s
.73482 .29763 m
.73482 .29763 L
s
.7349 .29564 m
.7349 .29564 L
s
.73497 .29681 m
.73497 .29681 L
s
.73505 .29987 m
.73505 .29987 L
s
.73512 .29787 m
.73512 .29787 L
s
.7352 .29846 m
.7352 .29846 L
s
.73527 .30104 m
.73527 .30104 L
s
.73535 .31478 m
.73535 .31478 L
s
.73542 .31525 m
.73542 .31525 L
s
.73549 .3129 m
.73549 .3129 L
s
.73556 .30609 m
.73556 .30609 L
s
.73564 .30187 m
.73564 .30187 L
s
.73571 .3075 m
.73571 .3075 L
s
.73579 .3102 m
.73579 .3102 L
s
.73586 .31654 m
.73586 .31654 L
s
.73594 .31431 m
.73594 .31431 L
s
.73602 .31326 m
.73602 .31326 L
s
.73609 .31478 m
.73609 .31478 L
s
.73617 .3169 m
.73617 .3169 L
s
.73624 .31666 m
.73624 .31666 L
s
.73631 .32418 m
.73631 .32418 L
s
.73638 .32746 m
.73638 .32746 L
s
.73646 .32629 m
.73646 .32629 L
s
.73653 .32359 m
.73653 .32359 L
s
.73661 .32077 m
.73661 .32077 L
s
.73668 .31807 m
.73668 .31807 L
s
.73676 .31079 m
.73676 .31079 L
s
.73683 .3176 m
.73683 .3176 L
s
.73691 .32159 m
.73691 .32159 L
s
.73698 .32242 m
.73698 .32242 L
s
.73706 .32488 m
.73706 .32488 L
s
.73712 .32206 m
.73712 .32206 L
s
.7372 .32194 m
.7372 .32194 L
s
.73727 .31596 m
.73727 .31596 L
s
.73735 .31725 m
.73735 .31725 L
s
.73742 .31244 m
.73742 .31244 L
s
.7375 .31783 m
.7375 .31783 L
s
.73758 .31372 m
.73758 .31372 L
s
.73765 .3176 m
.73765 .3176 L
s
.73773 .31854 m
.73773 .31854 L
s
.7378 .31842 m
.7378 .31842 L
s
.73787 .31608 m
.73787 .31608 L
s
.73794 .31161 m
.73794 .31161 L
s
.73802 .31279 m
.73802 .31279 L
s
.73809 .31854 m
.73809 .31854 L
s
.73817 .31172 m
.73817 .31172 L
s
.73824 .30551 m
.73824 .30551 L
s
.73832 .30644 m
.73832 .30644 L
s
.73839 .30891 m
.73839 .30891 L
s
.73846 .30868 m
.73846 .30868 L
s
.73854 .31184 m
.73854 .31184 L
s
.73862 .31384 m
.73862 .31384 L
s
.73869 .31901 m
.73869 .31901 L
s
.73876 .31596 m
.73876 .31596 L
s
.73883 .31501 m
.73883 .31501 L
s
.73891 .31067 m
.73891 .31067 L
s
.73898 .31302 m
.73898 .31302 L
s
.73906 .3068 m
.73906 .3068 L
s
.73914 .30738 m
.73914 .30738 L
s
.73921 .29963 m
.73921 .29963 L
s
.73928 .3021 m
.73928 .3021 L
s
.73936 .30409 m
.73936 .30409 L
s
.73944 .30234 m
.73944 .30234 L
s
.73951 .30633 m
.73951 .30633 L
s
.73958 .30726 m
.73958 .30726 L
s
.73965 .30456 m
.73965 .30456 L
s
.73973 .31055 m
.73973 .31055 L
s
.7398 .31349 m
.7398 .31349 L
s
.73988 .31396 m
.73988 .31396 L
s
.73995 .31631 m
.73995 .31631 L
s
.74003 .31619 m
.74003 .31619 L
s
.74009 .31114 m
.74009 .31114 L
s
.74017 .30938 m
.74017 .30938 L
s
.74025 .30726 m
.74025 .30726 L
s
.74032 .3109 m
.74032 .3109 L
s
.74039 .31279 m
.74039 .31279 L
s
.74047 .31619 m
.74047 .31619 L
s
.74054 .31678 m
.74054 .31678 L
s
.74062 .31736 m
.74062 .31736 L
s
.7407 .31619 m
.7407 .31619 L
s
.74077 .31631 m
.74077 .31631 L
s
.74084 .31302 m
.74084 .31302 L
s
.74091 .31337 m
.74091 .31337 L
s
.74099 .31631 m
.74099 .31631 L
s
.74107 .3223 m
.74107 .3223 L
s
.74114 .32265 m
.74114 .32265 L
s
.74121 .31936 m
.74121 .31936 L
s
.74129 .32664 m
.74129 .32664 L
s
.74136 .32394 m
.74136 .32394 L
s
.74144 .31936 m
.74144 .31936 L
s
.74151 .31854 m
.74151 .31854 L
s
.74159 .31877 m
.74159 .31877 L
s
.74166 .32254 m
.74166 .32254 L
s
.74173 .32535 m
.74173 .32535 L
s
.7418 .32464 m
.7418 .32464 L
s
.74188 .32664 m
.74188 .32664 L
s
.74195 .32899 m
.74195 .32899 L
s
.74203 .32571 m
.74203 .32571 L
s
.7421 .32242 m
.7421 .32242 L
s
.74218 .32147 m
.74218 .32147 L
s
.74226 .31678 m
.74226 .31678 L
s
.74233 .31326 m
.74233 .31326 L
s
.74241 .30598 m
.74241 .30598 L
s
.74248 .30116 m
.74248 .30116 L
s
.74255 .29646 m
.74255 .29646 L
s
.74262 .29141 m
.74262 .29141 L
s
.7427 .29388 m
.7427 .29388 L
s
.74277 .29294 m
.74277 .29294 L
s
.74285 .29434 m
.74285 .29434 L
s
.74292 .29481 m
.74292 .29481 L
s
.743 .2927 m
.743 .2927 L
s
.74307 .29505 m
.74307 .29505 L
s
.74315 .28918 m
.74315 .28918 L
s
.74322 .28941 m
.74322 .28941 L
s
.74329 .28495 m
.74329 .28495 L
s
.74336 .2819 m
.74336 .2819 L
s
.74344 .28213 m
.74344 .28213 L
s
.74351 .28389 m
.74351 .28389 L
s
.74359 .28953 m
.74359 .28953 L
s
.74366 .29047 m
.74366 .29047 L
s
.74374 .28918 m
.74374 .28918 L
s
.74382 .28636 m
.74382 .28636 L
s
.74389 .28812 m
.74389 .28812 L
s
.74397 .29094 m
.74397 .29094 L
s
.74404 .29352 m
.74404 .29352 L
s
.74411 .28566 m
.74411 .28566 L
s
.74418 .28613 m
.74418 .28613 L
s
.74426 .28307 m
.74426 .28307 L
s
.74433 .2819 m
.74433 .2819 L
s
.74441 .28142 m
.74441 .28142 L
s
.74448 .28319 m
.74448 .28319 L
s
.74456 .28378 m
.74456 .28378 L
s
.74463 .28131 m
.74463 .28131 L
s
.74471 .28272 m
.74471 .28272 L
s
.74478 .2806 m
.74478 .2806 L
s
.74486 .28284 m
.74486 .28284 L
s
.74492 .27849 m
.74492 .27849 L
s
.745 .27955 m
.745 .27955 L
s
.74507 .28272 m
.74507 .28272 L
s
.74515 .28777 m
.74515 .28777 L
s
.74522 .29505 m
.74522 .29505 L
s
.7453 .30351 m
.7453 .30351 L
s
.74538 .30609 m
.74538 .30609 L
s
.74545 .30292 m
.74545 .30292 L
s
.74553 .29952 m
.74553 .29952 L
s
.7456 .29446 m
.7456 .29446 L
s
.74567 .30174 m
.74567 .30174 L
s
.74574 .29987 m
.74574 .29987 L
s
.74582 .30656 m
.74582 .30656 L
s
.74589 .31208 m
.74589 .31208 L
s
.74597 .31161 m
.74597 .31161 L
s
.74604 .31067 m
.74604 .31067 L
s
.74612 .31431 m
.74612 .31431 L
s
.74619 .3203 m
.74619 .3203 L
s
.74627 .32089 m
.74627 .32089 L
s
.74634 .32136 m
.74634 .32136 L
s
.74642 .327 m
.74642 .327 L
s
.74649 .3223 m
.74649 .3223 L
s
.74656 .32594 m
.74656 .32594 L
s
.74663 .33075 m
.74663 .33075 L
s
.74671 .3311 m
.74671 .3311 L
s
.74678 .32629 m
.74678 .32629 L
s
.74686 .32159 m
.74686 .32159 L
s
.74694 .32136 m
.74694 .32136 L
s
.74701 .32136 m
.74701 .32136 L
s
.74708 .32042 m
.74708 .32042 L
s
.74716 .32711 m
.74716 .32711 L
s
.74724 .32758 m
.74724 .32758 L
s
.74731 .32629 m
.74731 .32629 L
s
.74738 .32476 m
.74738 .32476 L
s
.74745 .32676 m
.74745 .32676 L
s
.74753 .32558 m
.74753 .32558 L
s
.7476 .32182 m
.7476 .32182 L
s
.74768 .31854 m
.74768 .31854 L
s
.74775 .32089 m
.74775 .32089 L
s
.74783 .32618 m
.74783 .32618 L
s
.7479 .32371 m
.7479 .32371 L
s
.74798 .3277 m
.74798 .3277 L
s
.74805 .32265 m
.74805 .32265 L
s
.74812 .323 m
.74812 .323 L
s
.74819 .32606 m
.74819 .32606 L
s
.74827 .31525 m
.74827 .31525 L
s
.74834 .31619 m
.74834 .31619 L
s
.74842 .30962 m
.74842 .30962 L
s
.7485 .30926 m
.7485 .30926 L
s
.74857 .30527 m
.74857 .30527 L
s
.74864 .30985 m
.74864 .30985 L
s
.74871 .30269 m
.74871 .30269 L
s
.74879 .30116 m
.74879 .30116 L
s
.74887 .30762 m
.74887 .30762 L
s
.74894 .31149 m
.74894 .31149 L
s
.74901 .31701 m
.74901 .31701 L
s
.74909 .31267 m
.74909 .31267 L
s
.74916 .31361 m
.74916 .31361 L
s
.74924 .31384 m
.74924 .31384 L
s
.74931 .31244 m
.74931 .31244 L
s
.74939 .31208 m
.74939 .31208 L
s
.74946 .31525 m
.74946 .31525 L
s
.74953 .31572 m
.74953 .31572 L
s
.74961 .31561 m
.74961 .31561 L
s
.74969 .3129 m
.74969 .3129 L
s
.74975 .31431 m
.74975 .31431 L
s
.74983 .30891 m
.74983 .30891 L
s
.7499 .31102 m
.7499 .31102 L
s
.74998 .3196 m
.74998 .3196 L
s
.75006 .32171 m
.75006 .32171 L
s
.75013 .32606 m
.75013 .32606 L
s
.75021 .32429 m
.75021 .32429 L
s
.75028 .3331 m
.75028 .3331 L
s
.75035 .33639 m
.75035 .33639 L
s
.75042 .33992 m
.75042 .33992 L
s
.7505 .34191 m
.7505 .34191 L
s
.75057 .34226 m
.75057 .34226 L
s
.75065 .34367 m
.75065 .34367 L
s
.75072 .34449 m
.75072 .34449 L
s
.7508 .34379 m
.7508 .34379 L
s
.75087 .34661 m
.75087 .34661 L
s
.75095 .35107 m
.75095 .35107 L
s
.75102 .35741 m
.75102 .35741 L
s
.75109 .35741 m
.75109 .35741 L
s
.75116 .36269 m
.75116 .36269 L
s
.75124 .36187 m
.75124 .36187 L
s
.75132 .35565 m
.75132 .35565 L
s
.75139 .35541 m
.75139 .35541 L
s
.75146 .35236 m
.75146 .35236 L
s
.75154 .35965 m
.75154 .35965 L
s
.75162 .36434 m
.75162 .36434 L
s
.75169 .36411 m
.75169 .36411 L
s
.75177 .35976 m
.75177 .35976 L
s
.75184 .36317 m
.75184 .36317 L
s
.75191 .36987 m
.75191 .36987 L
s
.75198 .36927 m
.75198 .36927 L
s
.75206 .37022 m
.75206 .37022 L
s
.75213 .37291 m
.75213 .37291 L
s
.75221 .37374 m
.75221 .37374 L
s
.75228 .37209 m
.75228 .37209 L
s
.75236 .36622 m
.75236 .36622 L
s
.75243 .35905 m
.75243 .35905 L
s
.75251 .36223 m
.75251 .36223 L
s
.75258 .36469 m
.75258 .36469 L
s
.75266 .36716 m
.75266 .36716 L
s
.75272 .37104 m
.75272 .37104 L
s
.7528 .37221 m
.7528 .37221 L
s
.75287 .37421 m
.75287 .37421 L
s
.75295 .37573 m
.75295 .37573 L
s
.75302 .37421 m
.75302 .37421 L
s
.7531 .37315 m
.7531 .37315 L
s
.75318 .37867 m
.75318 .37867 L
s
.75325 .37949 m
.75325 .37949 L
s
.75333 .38501 m
.75333 .38501 L
s
.7534 .38513 m
.7534 .38513 L
s
.75347 .38678 m
.75347 .38678 L
s
.75354 .38583 m
.75354 .38583 L
s
.75362 .38924 m
.75362 .38924 L
s
.75369 .39417 m
.75369 .39417 L
s
.75377 .39558 m
.75377 .39558 L
s
.75384 .39394 m
.75384 .39394 L
s
.75392 .39276 m
.75392 .39276 L
s
.75399 .39664 m
.75399 .39664 L
s
.75407 .39863 m
.75407 .39863 L
s
.75414 .39981 m
.75414 .39981 L
s
.75422 .39957 m
.75422 .39957 L
s
.75429 .39981 m
.75429 .39981 L
s
.75436 .40145 m
.75436 .40145 L
s
.75443 .41085 m
.75443 .41085 L
s
.75451 .41578 m
.75451 .41578 L
s
.75458 .41719 m
.75458 .41719 L
s
.75466 .41672 m
.75466 .41672 L
s
.75474 .42412 m
.75474 .42412 L
s
.75481 .42506 m
.75481 .42506 L
s
.75489 .41884 m
.75489 .41884 L
s
.75496 .41449 m
.75496 .41449 L
s
.75504 .4152 m
.75504 .4152 L
s
.75511 .41555 m
.75511 .41555 L
s
.75518 .42518 m
.75518 .42518 L
s
.75525 .43011 m
.75525 .43011 L
s
.75533 .43715 m
.75533 .43715 L
s
.7554 .43586 m
.7554 .43586 L
s
.75548 .43798 m
.75548 .43798 L
s
.75555 .44009 m
.75555 .44009 L
s
.75563 .43704 m
.75563 .43704 L
s
.7557 .44303 m
.7557 .44303 L
s
.75578 .44408 m
.75578 .44408 L
s
.75585 .44526 m
.75585 .44526 L
s
.75592 .44479 m
.75592 .44479 L
s
.75599 .44608 m
.75599 .44608 L
s
.75607 .44725 m
.75607 .44725 L
s
.75614 .44749 m
.75614 .44749 L
s
.75622 .44585 m
.75622 .44585 L
s
.7563 .44538 m
.7563 .44538 L
s
.75637 .44279 m
.75637 .44279 L
s
.75644 .44737 m
.75644 .44737 L
s
.75652 .44443 m
.75652 .44443 L
s
.7566 .45231 m
.7566 .45231 L
s
.75667 .45677 m
.75667 .45677 L
s
.75674 .45525 m
.75674 .45525 L
s
.75681 .45371 m
.75681 .45371 L
s
.75689 .44678 m
.75689 .44678 L
s
.75696 .4469 m
.75696 .4469 L
s
.75704 .4435 m
.75704 .4435 L
s
.75711 .4462 m
.75711 .4462 L
s
.75719 .44503 m
.75719 .44503 L
s
.75726 .44256 m
.75726 .44256 L
s
.75733 .44408 m
.75733 .44408 L
s
.75741 .4375 m
.75741 .4375 L
s
.75749 .44396 m
.75749 .44396 L
s
.75755 .44068 m
.75755 .44068 L
s
.75763 .43974 m
.75763 .43974 L
s
.7577 .44186 m
.7577 .44186 L
s
.75778 .44585 m
.75778 .44585 L
s
.75786 .44232 m
.75786 .44232 L
s
.75793 .44068 m
.75793 .44068 L
s
.75801 .44221 m
.75801 .44221 L
s
.75808 .44232 m
.75808 .44232 L
s
.75815 .43892 m
.75815 .43892 L
s
.75823 .44268 m
.75823 .44268 L
s
.7583 .44068 m
.7583 .44068 L
s
.75837 .43762 m
.75837 .43762 L
s
.75845 .44127 m
.75845 .44127 L
s
.75852 .43129 m
.75852 .43129 L
s
.7586 .42682 m
.7586 .42682 L
s
.75867 .43504 m
.75867 .43504 L
s
.75875 .43504 m
.75875 .43504 L
s
.75882 .4388 m
.75882 .4388 L
s
.75889 .43927 m
.75889 .43927 L
s
.75896 .44221 m
.75896 .44221 L
s
.75904 .44139 m
.75904 .44139 L
s
.75912 .43845 m
.75912 .43845 L
s
.75919 .4368 m
.75919 .4368 L
s
.75926 .44162 m
.75926 .44162 L
s
.75934 .4334 m
.75934 .4334 L
s
.75942 .44209 m
.75942 .44209 L
s
.75949 .44338 m
.75949 .44338 L
s
.75957 .4489 m
.75957 .4489 L
s
.75964 .45043 m
.75964 .45043 L
s
.75971 .45043 m
.75971 .45043 L
s
.75978 .45478 m
.75978 .45478 L
s
.75986 .45019 m
.75986 .45019 L
s
.75994 .46006 m
.75994 .46006 L
s
.76001 .46205 m
.76001 .46205 L
s
.76008 .46299 m
.76008 .46299 L
s
.76016 .4644 m
.76016 .4644 L
s
.76023 .46769 m
.76023 .46769 L
s
.76031 .46194 m
.76031 .46194 L
s
.76038 .46323 m
.76038 .46323 L
s
.76046 .46264 m
.76046 .46264 L
s
.76052 .46264 m
.76052 .46264 L
s
.7606 .46252 m
.7606 .46252 L
s
.76067 .46558 m
.76067 .46558 L
s
.76075 .4738 m
.76075 .4738 L
s
.76082 .47004 m
.76082 .47004 L
s
.7609 .46182 m
.7609 .46182 L
s
.76098 .46581 m
.76098 .46581 L
s
.76105 .46288 m
.76105 .46288 L
s
.76113 .459 m
.76113 .459 L
s
.7612 .46064 m
.7612 .46064 L
s
.76127 .46006 m
.76127 .46006 L
s
.76134 .45089 m
.76134 .45089 L
s
.76142 .45806 m
.76142 .45806 L
s
.76149 .45395 m
.76149 .45395 L
s
.76157 .45759 m
.76157 .45759 L
s
.76164 .45124 m
.76164 .45124 L
s
.76172 .45266 m
.76172 .45266 L
s
.76179 .4543 m
.76179 .4543 L
s
.76187 .45536 m
.76187 .45536 L
s
.76194 .45712 m
.76194 .45712 L
s
.76202 .4577 m
.76202 .4577 L
s
.76209 .45947 m
.76209 .45947 L
s
.76216 .45525 m
.76216 .45525 L
s
.76223 .45665 m
.76223 .45665 L
s
.76231 .44996 m
.76231 .44996 L
s
.76238 .44655 m
.76238 .44655 L
s
.76246 .45254 m
.76246 .45254 L
s
.76254 .45806 m
.76254 .45806 L
s
.76261 .45572 m
.76261 .45572 L
s
.76269 .45865 m
.76269 .45865 L
s
.76276 .45572 m
.76276 .45572 L
s
.76284 .45595 m
.76284 .45595 L
s
.76291 .46252 m
.76291 .46252 L
s
.76298 .46628 m
.76298 .46628 L
s
.76305 .46699 m
.76305 .46699 L
s
.76313 .46922 m
.76313 .46922 L
s
.7632 .47908 m
.7632 .47908 L
s
.76328 .4792 m
.76328 .4792 L
s
.76335 .47544 m
.76335 .47544 L
s
.76343 .47485 m
.76343 .47485 L
s
.7635 .47473 m
.7635 .47473 L
s
.76358 .48014 m
.76358 .48014 L
s
.76365 .47932 m
.76365 .47932 L
s
.76372 .47697 m
.76372 .47697 L
s
.76379 .47251 m
.76379 .47251 L
s
.76387 .4738 m
.76387 .4738 L
s
.76394 .46652 m
.76394 .46652 L
s
.76402 .46523 m
.76402 .46523 L
s
.7641 .47403 m
.7641 .47403 L
s
.76417 .47627 m
.76417 .47627 L
s
.76424 .48296 m
.76424 .48296 L
s
.76432 .48483 m
.76432 .48483 L
s
.7644 .48695 m
.7644 .48695 L
s
.76447 .4893 m
.76447 .4893 L
s
.76454 .48777 m
.76454 .48777 L
s
.76461 .49012 m
.76461 .49012 L
s
.76469 .49388 m
.76469 .49388 L
s
.76476 .48884 m
.76476 .48884 L
s
.76484 .48378 m
.76484 .48378 L
s
.76491 .48226 m
.76491 .48226 L
s
.76499 .48273 m
.76499 .48273 L
s
.76506 .48636 m
.76506 .48636 L
s
.76514 .48812 m
.76514 .48812 L
s
.76521 .48413 m
.76521 .48413 L
s
.76529 .47908 m
.76529 .47908 L
s
.76535 .48084 m
.76535 .48084 L
s
.76543 .47415 m
.76543 .47415 L
s
.7655 .47228 m
.7655 .47228 L
s
.76558 .46699 m
.76558 .46699 L
s
.76566 .46346 m
.76566 .46346 L
s
.76573 .45982 m
.76573 .45982 L
s
.76581 .45407 m
.76581 .45407 L
s
.76588 .459 m
.76588 .459 L
s
.76595 .45196 m
.76595 .45196 L
s
.76603 .45184 m
.76603 .45184 L
s
.7661 .45453 m
.7661 .45453 L
s
.76617 .46252 m
.76617 .46252 L
s
.76625 .46053 m
.76625 .46053 L
s
.76632 .46593 m
.76632 .46593 L
s
.7664 .46393 m
.7664 .46393 L
s
.76647 .46288 m
.76647 .46288 L
s
.76655 .45842 m
.76655 .45842 L
s
.76662 .45089 m
.76662 .45089 L
s
.76669 .4489 m
.76669 .4489 L
s
.76677 .45478 m
.76677 .45478 L
s
.76685 .46241 m
.76685 .46241 L
s
.76692 .45723 m
.76692 .45723 L
s
.76699 .44984 m
.76699 .44984 L
s
.76706 .45066 m
.76706 .45066 L
s
.76714 .45525 m
.76714 .45525 L
s
.76722 .45641 m
.76722 .45641 L
s
.76729 .44937 m
.76729 .44937 L
s
.76737 .44972 m
.76737 .44972 L
s
.76744 .44632 m
.76744 .44632 L
s
.76751 .4435 m
.76751 .4435 L
s
.76758 .43822 m
.76758 .43822 L
s
.76766 .44373 m
.76766 .44373 L
s
.76774 .43152 m
.76774 .43152 L
s
.76781 .43211 m
.76781 .43211 L
s
.76788 .42964 m
.76788 .42964 L
s
.76796 .43551 m
.76796 .43551 L
s
.76803 .43293 m
.76803 .43293 L
s
.76811 .43633 m
.76811 .43633 L
s
.76818 .43386 m
.76818 .43386 L
s
.76826 .43269 m
.76826 .43269 L
s
.76832 .43375 m
.76832 .43375 L
s
.7684 .43551 m
.7684 .43551 L
s
.76847 .43528 m
.76847 .43528 L
s
.76855 .42835 m
.76855 .42835 L
s
.76862 .42987 m
.76862 .42987 L
s
.7687 .43386 m
.7687 .43386 L
s
.76878 .43386 m
.76878 .43386 L
s
.76885 .43164 m
.76885 .43164 L
s
.76893 .4388 m
.76893 .4388 L
s
.769 .44279 m
.769 .44279 L
s
.76907 .44468 m
.76907 .44468 L
s
.76914 .44491 m
.76914 .44491 L
s
.76922 .45207 m
.76922 .45207 L
s
.76929 .45266 m
.76929 .45266 L
s
.76937 .44021 m
.76937 .44021 L
s
.76944 .43833 m
.76944 .43833 L
s
.76952 .4368 m
.76952 .4368 L
s
.76959 .43386 m
.76959 .43386 L
s
.76967 .43199 m
.76967 .43199 L
s
.76974 .42788 m
.76974 .42788 L
s
.76982 .43293 m
.76982 .43293 L
s
.76989 .43363 m
.76989 .43363 L
s
.76996 .42353 m
.76996 .42353 L
s
.77003 .42236 m
.77003 .42236 L
s
.77011 .42248 m
.77011 .42248 L
s
.77018 .42259 m
.77018 .42259 L
s
.77026 .42424 m
.77026 .42424 L
s
.77034 .42107 m
.77034 .42107 L
s
.77041 .42518 m
.77041 .42518 L
s
.77049 .42541 m
.77049 .42541 L
s
.77056 .42658 m
.77056 .42658 L
s
.77064 .42588 m
.77064 .42588 L
s
.77071 .42506 m
.77071 .42506 L
s
.77078 .42424 m
.77078 .42424 L
s
.77085 .426 m
.77085 .426 L
s
.77093 .42283 m
.77093 .42283 L
s
.771 .43058 m
.771 .43058 L
s
.77108 .42964 m
.77108 .42964 L
s
.77115 .42976 m
.77115 .42976 L
s
.77123 .43011 m
.77123 .43011 L
s
.7713 .42847 m
.7713 .42847 L
s
.77138 .42459 m
.77138 .42459 L
s
.77145 .42964 m
.77145 .42964 L
s
.77152 .42658 m
.77152 .42658 L
s
.77159 .42694 m
.77159 .42694 L
s
.77167 .42436 m
.77167 .42436 L
s
.77174 .43316 m
.77174 .43316 L
s
.77182 .43187 m
.77182 .43187 L
s
.7719 .42448 m
.7719 .42448 L
s
.77197 .42236 m
.77197 .42236 L
s
.77205 .42776 m
.77205 .42776 L
s
.77212 .42917 m
.77212 .42917 L
s
.7722 .43422 m
.7722 .43422 L
s
.77227 .43152 m
.77227 .43152 L
s
.77234 .43117 m
.77234 .43117 L
s
.77241 .43234 m
.77241 .43234 L
s
.77249 .43351 m
.77249 .43351 L
s
.77256 .44021 m
.77256 .44021 L
s
.77264 .44432 m
.77264 .44432 L
s
.77271 .44456 m
.77271 .44456 L
s
.77279 .44432 m
.77279 .44432 L
s
.77286 .44396 m
.77286 .44396 L
s
.77294 .43857 m
.77294 .43857 L
s
.77301 .44209 m
.77301 .44209 L
s
.77309 .44244 m
.77309 .44244 L
s
.77315 .44044 m
.77315 .44044 L
s
.77323 .43762 m
.77323 .43762 L
s
.7733 .44361 m
.7733 .44361 L
s
.77338 .4455 m
.77338 .4455 L
s
.77346 .44643 m
.77346 .44643 L
s
.77353 .46029 m
.77353 .46029 L
s
.77361 .46217 m
.77361 .46217 L
s
.77368 .45971 m
.77368 .45971 L
s
.77375 .45677 m
.77375 .45677 L
s
.77383 .45641 m
.77383 .45641 L
s
.77391 .45254 m
.77391 .45254 L
s
.77397 .45478 m
.77397 .45478 L
s
.77405 .45289 m
.77405 .45289 L
s
.77412 .45324 m
.77412 .45324 L
s
.7742 .45501 m
.7742 .45501 L
s
.77427 .45242 m
.77427 .45242 L
s
.77435 .45618 m
.77435 .45618 L
s
.77442 .45935 m
.77442 .45935 L
s
.77449 .4617 m
.77449 .4617 L
s
.77457 .46511 m
.77457 .46511 L
s
.77465 .45688 m
.77465 .45688 L
s
.77472 .4664 m
.77472 .4664 L
s
.77479 .46558 m
.77479 .46558 L
s
.77486 .46029 m
.77486 .46029 L
s
.77494 .4543 m
.77494 .4543 L
s
.77502 .45513 m
.77502 .45513 L
s
.77509 .45407 m
.77509 .45407 L
s
.77517 .44984 m
.77517 .44984 L
s
.77524 .45031 m
.77524 .45031 L
s
.77531 .45008 m
.77531 .45008 L
s
.77538 .45525 m
.77538 .45525 L
s
.77546 .45759 m
.77546 .45759 L
s
.77554 .45313 m
.77554 .45313 L
s
.77561 .44585 m
.77561 .44585 L
s
.77568 .45242 m
.77568 .45242 L
s
.77576 .45113 m
.77576 .45113 L
s
.77583 .4556 m
.77583 .4556 L
s
.77591 .45818 m
.77591 .45818 L
s
.77598 .45501 m
.77598 .45501 L
s
.77606 .45489 m
.77606 .45489 L
s
.77612 .45782 m
.77612 .45782 L
s
.7762 .45759 m
.7762 .45759 L
s
.77628 .45383 m
.77628 .45383 L
s
.77635 .45149 m
.77635 .45149 L
s
.77642 .44643 m
.77642 .44643 L
s
.7765 .45254 m
.7765 .45254 L
s
.77658 .45525 m
.77658 .45525 L
s
.77665 .44961 m
.77665 .44961 L
s
.77673 .44937 m
.77673 .44937 L
s
.7768 .44585 m
.7768 .44585 L
s
.77688 .45124 m
.77688 .45124 L
s
.77694 .45572 m
.77694 .45572 L
s
.77702 .45383 m
.77702 .45383 L
s
.7771 .45548 m
.7771 .45548 L
s
.77717 .44996 m
.77717 .44996 L
s
.77724 .44443 m
.77724 .44443 L
s
.77732 .44796 m
.77732 .44796 L
s
.77739 .45313 m
.77739 .45313 L
s
.77747 .44996 m
.77747 .44996 L
s
.77754 .45019 m
.77754 .45019 L
s
.77762 .45688 m
.77762 .45688 L
s
.77769 .45971 m
.77769 .45971 L
s
.77776 .46135 m
.77776 .46135 L
s
.77783 .46017 m
.77783 .46017 L
s
.77791 .46558 m
.77791 .46558 L
s
.77798 .46875 m
.77798 .46875 L
s
.77806 .46664 m
.77806 .46664 L
s
.77814 .4678 m
.77814 .4678 L
s
.77821 .47791 m
.77821 .47791 L
s
.77829 .48096 m
.77829 .48096 L
s
.77836 .48096 m
.77836 .48096 L
s
.77844 .47756 m
.77844 .47756 L
s
.77851 .47473 m
.77851 .47473 L
s
.77858 .47544 m
.77858 .47544 L
s
.77865 .47673 m
.77865 .47673 L
s
.77873 .46558 m
.77873 .46558 L
s
.7788 .46323 m
.7788 .46323 L
s
.77888 .4657 m
.77888 .4657 L
s
.77895 .46746 m
.77895 .46746 L
s
.77903 .46875 m
.77903 .46875 L
s
.7791 .47051 m
.7791 .47051 L
s
.77918 .4637 m
.77918 .4637 L
s
.77925 .46628 m
.77925 .46628 L
s
.77932 .46205 m
.77932 .46205 L
s
.77939 .45453 m
.77939 .45453 L
s
.77947 .45606 m
.77947 .45606 L
s
.77954 .45818 m
.77954 .45818 L
s
.77962 .45982 m
.77962 .45982 L
s
.7797 .45395 m
.7797 .45395 L
s
.77977 .45031 m
.77977 .45031 L
s
.77985 .44772 m
.77985 .44772 L
s
.77992 .44209 m
.77992 .44209 L
s
.78 .45054 m
.78 .45054 L
s
.78007 .45395 m
.78007 .45395 L
s
.78014 .45124 m
.78014 .45124 L
s
.78021 .45254 m
.78021 .45254 L
s
.78029 .4455 m
.78029 .4455 L
s
.78036 .4435 m
.78036 .4435 L
s
.78044 .44326 m
.78044 .44326 L
s
.78051 .43986 m
.78051 .43986 L
s
.78059 .44197 m
.78059 .44197 L
s
.78066 .44032 m
.78066 .44032 L
s
.78074 .4381 m
.78074 .4381 L
s
.78081 .4442 m
.78081 .4442 L
s
.78089 .44268 m
.78089 .44268 L
s
.78095 .44103 m
.78095 .44103 L
s
.78103 .43386 m
.78103 .43386 L
s
.7811 .43434 m
.7811 .43434 L
s
.78118 .424 m
.78118 .424 L
s
.78126 .42201 m
.78126 .42201 L
s
.78133 .41837 m
.78133 .41837 L
s
.78141 .41825 m
.78141 .41825 L
s
.78148 .4193 m
.78148 .4193 L
s
.78156 .4193 m
.78156 .4193 L
s
.78163 .4186 m
.78163 .4186 L
s
.78171 .4132 m
.78171 .4132 L
s
.78177 .41366 m
.78177 .41366 L
s
.78185 .41813 m
.78185 .41813 L
s
.78192 .41438 m
.78192 .41438 L
s
.782 .41602 m
.782 .41602 L
s
.78207 .41402 m
.78207 .41402 L
s
.78215 .41402 m
.78215 .41402 L
s
.78222 .41426 m
.78222 .41426 L
s
.78229 .41625 m
.78229 .41625 L
s
.78237 .41872 m
.78237 .41872 L
s
.78245 .41637 m
.78245 .41637 L
s
.78252 .41366 m
.78252 .41366 L
s
.78259 .41672 m
.78259 .41672 L
s
.78266 .41602 m
.78266 .41602 L
s
.78274 .41214 m
.78274 .41214 L
s
.78282 .41743 m
.78282 .41743 L
s
.78289 .41848 m
.78289 .41848 L
s
.78297 .41731 m
.78297 .41731 L
s
.78304 .42565 m
.78304 .42565 L
s
.78311 .42212 m
.78311 .42212 L
s
.78319 .42541 m
.78319 .42541 L
s
.78327 .42259 m
.78327 .42259 L
s
.78334 .41884 m
.78334 .41884 L
s
.78341 .41602 m
.78341 .41602 L
s
.78348 .41414 m
.78348 .41414 L
s
.78356 .41602 m
.78356 .41602 L
s
.78363 .41179 m
.78363 .41179 L
s
.78371 .41813 m
.78371 .41813 L
s
.78378 .41648 m
.78378 .41648 L
s
.78386 .41766 m
.78386 .41766 L
s
.78392 .4193 m
.78392 .4193 L
s
.78401 .42212 m
.78401 .42212 L
s
.78408 .42448 m
.78408 .42448 L
s
.78415 .42376 m
.78415 .42376 L
s
.78422 .42541 m
.78422 .42541 L
s
.7843 .43868 m
.7843 .43868 L
s
.78438 .43962 m
.78438 .43962 L
s
.78445 .44808 m
.78445 .44808 L
s
.78453 .44902 m
.78453 .44902 L
s
.7846 .44396 m
.7846 .44396 L
s
.78468 .44678 m
.78468 .44678 L
s
.78474 .44408 m
.78474 .44408 L
s
.78482 .44678 m
.78482 .44678 L
s
.7849 .45077 m
.7849 .45077 L
s
.78497 .44855 m
.78497 .44855 L
s
.78504 .44491 m
.78504 .44491 L
s
.78512 .44479 m
.78512 .44479 L
s
.78519 .44714 m
.78519 .44714 L
s
.78527 .44961 m
.78527 .44961 L
s
.78534 .44996 m
.78534 .44996 L
s
.78542 .45066 m
.78542 .45066 L
s
.78549 .45231 m
.78549 .45231 L
s
.78556 .45548 m
.78556 .45548 L
s
.78564 .46017 m
.78564 .46017 L
s
.78571 .46416 m
.78571 .46416 L
s
.78579 .46416 m
.78579 .46416 L
s
.78586 .47051 m
.78586 .47051 L
s
.78594 .47309 m
.78594 .47309 L
s
.78601 .47544 m
.78601 .47544 L
s
.78609 .47251 m
.78609 .47251 L
s
.78616 .48002 m
.78616 .48002 L
s
.78624 .47873 m
.78624 .47873 L
s
.78631 .47861 m
.78631 .47861 L
s
.78638 .47744 m
.78638 .47744 L
s
.78645 .47603 m
.78645 .47603 L
s
.78653 .48108 m
.78653 .48108 L
s
.7866 .48214 m
.7866 .48214 L
s
.78668 .48049 m
.78668 .48049 L
s
.78675 .48014 m
.78675 .48014 L
s
.78683 .48131 m
.78683 .48131 L
s
.7869 .47204 m
.7869 .47204 L
s
.78698 .46969 m
.78698 .46969 L
s
.78705 .46945 m
.78705 .46945 L
s
.78712 .46722 m
.78712 .46722 L
s
.78719 .46159 m
.78719 .46159 L
s
.78727 .46664 m
.78727 .46664 L
s
.78734 .46969 m
.78734 .46969 L
s
.78742 .46652 m
.78742 .46652 L
s
.7875 .46241 m
.7875 .46241 L
s
.78757 .45888 m
.78757 .45888 L
s
.78765 .46652 m
.78765 .46652 L
s
.78772 .46757 m
.78772 .46757 L
s
.7878 .46241 m
.7878 .46241 L
s
.78787 .45924 m
.78787 .45924 L
s
.78794 .46628 m
.78794 .46628 L
s
.78801 .46252 m
.78801 .46252 L
s
.78809 .46628 m
.78809 .46628 L
s
.78816 .46699 m
.78816 .46699 L
s
.78824 .46488 m
.78824 .46488 L
s
.78831 .46135 m
.78831 .46135 L
s
.78839 .45618 m
.78839 .45618 L
s
.78846 .45818 m
.78846 .45818 L
s
.78854 .46499 m
.78854 .46499 L
s
.78861 .46722 m
.78861 .46722 L
s
.78869 .46628 m
.78869 .46628 L
s
.78876 .4678 m
.78876 .4678 L
s
.78883 .46815 m
.78883 .46815 L
s
.7889 .46182 m
.7889 .46182 L
s
.78898 .45888 m
.78898 .45888 L
s
.78906 .46535 m
.78906 .46535 L
s
.78913 .46135 m
.78913 .46135 L
s
.78921 .45618 m
.78921 .45618 L
s
.78928 .4543 m
.78928 .4543 L
s
.78936 .44749 m
.78936 .44749 L
s
.78943 .44256 m
.78943 .44256 L
s
.78951 .44091 m
.78951 .44091 L
s
.78957 .44585 m
.78957 .44585 L
s
.78965 .44115 m
.78965 .44115 L
s
.78972 .43598 m
.78972 .43598 L
s
.7898 .43386 m
.7898 .43386 L
s
.78987 .43129 m
.78987 .43129 L
s
.78995 .43551 m
.78995 .43551 L
s
.79002 .43246 m
.79002 .43246 L
s
.7901 .43575 m
.7901 .43575 L
s
.79017 .43645 m
.79017 .43645 L
s
.79025 .43692 m
.79025 .43692 L
s
.79032 .44221 m
.79032 .44221 L
s
.79039 .43997 m
.79039 .43997 L
s
.79046 .44021 m
.79046 .44021 L
s
.79054 .44115 m
.79054 .44115 L
s
.79062 .44361 m
.79062 .44361 L
s
.79069 .4361 m
.79069 .4361 L
s
.79077 .43081 m
.79077 .43081 L
s
.79084 .42894 m
.79084 .42894 L
s
.79091 .426 m
.79091 .426 L
s
.79099 .42541 m
.79099 .42541 L
s
.79107 .428 m
.79107 .428 L
s
.79114 .42765 m
.79114 .42765 L
s
.79121 .42835 m
.79121 .42835 L
s
.79128 .42448 m
.79128 .42448 L
s
.79136 .42576 m
.79136 .42576 L
s
.79143 .424 m
.79143 .424 L
s
.79151 .43504 m
.79151 .43504 L
s
.79158 .4341 m
.79158 .4341 L
s
.79166 .42776 m
.79166 .42776 L
s
.79173 .42518 m
.79173 .42518 L
s
.79181 .42929 m
.79181 .42929 L
s
.79188 .42635 m
.79188 .42635 L
s
.79195 .42365 m
.79195 .42365 L
s
.79202 .42001 m
.79202 .42001 L
s
.7921 .42306 m
.7921 .42306 L
s
.79218 .42506 m
.79218 .42506 L
s
.79225 .42024 m
.79225 .42024 L
s
.79233 .42212 m
.79233 .42212 L
s
.7924 .42072 m
.7924 .42072 L
s
.79248 .42107 m
.79248 .42107 L
s
.79254 .41919 m
.79254 .41919 L
s
.79262 .41355 m
.79262 .41355 L
s
.7927 .41097 m
.7927 .41097 L
s
.79277 .40897 m
.79277 .40897 L
s
.79284 .41378 m
.79284 .41378 L
s
.79292 .41331 m
.79292 .41331 L
s
.79299 .41625 m
.79299 .41625 L
s
.79307 .42154 m
.79307 .42154 L
s
.79314 .42095 m
.79314 .42095 L
s
.79322 .426 m
.79322 .426 L
s
.79329 .42506 m
.79329 .42506 L
s
.79336 .42788 m
.79336 .42788 L
s
.79344 .42119 m
.79344 .42119 L
s
.79352 .42987 m
.79352 .42987 L
s
.79359 .42448 m
.79359 .42448 L
s
.79366 .4193 m
.79366 .4193 L
s
.79374 .41414 m
.79374 .41414 L
s
.79381 .41109 m
.79381 .41109 L
s
.79389 .41202 m
.79389 .41202 L
s
.79396 .41014 m
.79396 .41014 L
s
.79404 .40239 m
.79404 .40239 L
s
.79411 .41085 m
.79411 .41085 L
s
.79418 .41414 m
.79418 .41414 L
s
.79425 .41167 m
.79425 .41167 L
s
.79433 .41167 m
.79433 .41167 L
s
.7944 .41496 m
.7944 .41496 L
s
.79448 .41648 m
.79448 .41648 L
s
.79455 .41625 m
.79455 .41625 L
s
.79463 .41578 m
.79463 .41578 L
s
.7947 .4159 m
.7947 .4159 L
s
.79478 .41461 m
.79478 .41461 L
s
.79485 .42635 m
.79485 .42635 L
s
.79492 .42388 m
.79492 .42388 L
s
.79499 .42236 m
.79499 .42236 L
s
.79507 .42271 m
.79507 .42271 L
s
.79515 .41966 m
.79515 .41966 L
s
.79522 .4233 m
.79522 .4233 L
s
.7953 .42553 m
.7953 .42553 L
s
.79537 .42847 m
.79537 .42847 L
s
.79545 .43058 m
.79545 .43058 L
s
.79552 .42705 m
.79552 .42705 L
s
.7956 .426 m
.7956 .426 L
s
.79567 .42765 m
.79567 .42765 L
s
.79574 .42647 m
.79574 .42647 L
s
.79581 .42224 m
.79581 .42224 L
s
.79589 .42565 m
.79589 .42565 L
s
.79596 .4274 m
.79596 .4274 L
s
.79604 .42729 m
.79604 .42729 L
s
.79611 .4287 m
.79611 .4287 L
s
.79619 .42929 m
.79619 .42929 L
s
.79626 .428 m
.79626 .428 L
s
.79634 .42541 m
.79634 .42541 L
s
.79641 .4253 m
.79641 .4253 L
s
.79649 .41884 m
.79649 .41884 L
s
.79656 .42294 m
.79656 .42294 L
s
.79663 .42424 m
.79663 .42424 L
s
.7967 .4152 m
.7967 .4152 L
s
.79678 .41366 m
.79678 .41366 L
s
.79686 .41261 m
.79686 .41261 L
s
.79693 .41191 m
.79693 .41191 L
s
.79701 .4078 m
.79701 .4078 L
s
.79708 .40392 m
.79708 .40392 L
s
.79716 .40627 m
.79716 .40627 L
s
.79723 .4031 m
.79723 .4031 L
s
.79731 .40721 m
.79731 .40721 L
s
.79737 .40545 m
.79737 .40545 L
s
.79745 .4031 m
.79745 .4031 L
s
.79752 .40368 m
.79752 .40368 L
s
.7976 .40016 m
.7976 .40016 L
s
.79767 .40356 m
.79767 .40356 L
s
.79775 .40169 m
.79775 .40169 L
s
.79782 .39957 m
.79782 .39957 L
s
.7979 .40099 m
.7979 .40099 L
s
.79797 .40451 m
.79797 .40451 L
s
.79805 .39945 m
.79805 .39945 L
s
.79812 .40052 m
.79812 .40052 L
s
.79819 .40521 m
.79819 .40521 L
s
.79826 .40956 m
.79826 .40956 L
s
.79834 .41002 m
.79834 .41002 L
s
.79842 .40685 m
.79842 .40685 L
s
.79849 .40991 m
.79849 .40991 L
s
.79857 .40556 m
.79857 .40556 L
s
.79864 .41226 m
.79864 .41226 L
s
.79872 .41155 m
.79872 .41155 L
s
.79879 .41637 m
.79879 .41637 L
s
.79887 .41484 m
.79887 .41484 L
s
.79894 .41672 m
.79894 .41672 L
s
.79901 .42142 m
.79901 .42142 L
s
.79908 .426 m
.79908 .426 L
s
.79916 .42682 m
.79916 .42682 L
s
.79923 .43281 m
.79923 .43281 L
s
.79931 .42658 m
.79931 .42658 L
s
.79938 .42353 m
.79938 .42353 L
s
.79946 .41766 m
.79946 .41766 L
s
.79953 .42024 m
.79953 .42024 L
s
.79961 .41343 m
.79961 .41343 L
s
.79968 .41426 m
.79968 .41426 L
s
.79975 .41473 m
.79975 .41473 L
s
.79982 .41402 m
.79982 .41402 L
s
.7999 .41508 m
.7999 .41508 L
s
.79998 .40697 m
.79998 .40697 L
s
.80005 .40216 m
.80005 .40216 L
s
.80013 .39863 m
.80013 .39863 L
s
.8002 .39735 m
.8002 .39735 L
s
.80028 .40356 m
.80028 .40356 L
s
.80035 .39875 m
.80035 .39875 L
s
.80043 .39723 m
.80043 .39723 L
s
.8005 .39323 m
.8005 .39323 L
s
.80057 .3903 m
.80057 .3903 L
s
.80064 .39323 m
.80064 .39323 L
s
.80072 .39264 m
.80072 .39264 L
s
.80079 .39323 m
.80079 .39323 L
s
.80087 .39264 m
.80087 .39264 L
s
.80094 .38583 m
.80094 .38583 L
s
.80102 .39276 m
.80102 .39276 L
s
.80109 .39652 m
.80109 .39652 L
s
.80116 .39605 m
.80116 .39605 L
s
.80124 .40122 m
.80124 .40122 L
s
.80132 .40416 m
.80132 .40416 L
s
.80139 .40498 m
.80139 .40498 L
s
.80146 .40979 m
.80146 .40979 L
s
.80154 .40944 m
.80154 .40944 L
s
.80161 .4078 m
.80161 .4078 L
s
.80169 .41461 m
.80169 .41461 L
s
.80176 .41531 m
.80176 .41531 L
s
.80184 .41202 m
.80184 .41202 L
s
.80191 .41249 m
.80191 .41249 L
s
.80198 .40909 m
.80198 .40909 L
s
.80206 .40615 m
.80206 .40615 L
s
.80214 .39758 m
.80214 .39758 L
s
.8022 .4011 m
.8022 .4011 L
s
.80228 .3964 m
.80228 .3964 L
s
.80235 .39793 m
.80235 .39793 L
s
.80243 .39863 m
.80243 .39863 L
s
.8025 .3991 m
.8025 .3991 L
s
.80258 .39628 m
.80258 .39628 L
s
.80265 .39346 m
.80265 .39346 L
s
.80272 .39711 m
.80272 .39711 L
s
.80279 .39723 m
.80279 .39723 L
s
.80287 .39288 m
.80287 .39288 L
s
.80295 .39417 m
.80295 .39417 L
s
.80302 .39464 m
.80302 .39464 L
s
.8031 .39969 m
.8031 .39969 L
s
.80317 .39077 m
.80317 .39077 L
s
.80325 .39065 m
.80325 .39065 L
s
.80332 .38877 m
.80332 .38877 L
s
.8034 .38571 m
.8034 .38571 L
s
.80347 .37949 m
.80347 .37949 L
s
.80354 .37608 m
.80354 .37608 L
s
.80361 .37914 m
.80361 .37914 L
s
.80369 .38548 m
.80369 .38548 L
s
.80377 .37867 m
.80377 .37867 L
s
.80384 .38079 m
.80384 .38079 L
s
.80391 .38384 m
.80391 .38384 L
s
.80399 .38795 m
.80399 .38795 L
s
.80406 .38713 m
.80406 .38713 L
s
.80414 .38924 m
.80414 .38924 L
s
.80421 .38384 m
.80421 .38384 L
s
.80429 .38618 m
.80429 .38618 L
s
.80436 .39182 m
.80436 .39182 L
s
.80443 .38736 m
.80443 .38736 L
s
.8045 .3863 m
.8045 .3863 L
s
.80458 .38924 m
.80458 .38924 L
s
.80466 .38771 m
.80466 .38771 L
s
.80473 .39159 m
.80473 .39159 L
s
.80481 .39675 m
.80481 .39675 L
s
.80488 .40381 m
.80488 .40381 L
s
.80496 .40533 m
.80496 .40533 L
s
.80503 .40615 m
.80503 .40615 L
s
.80511 .40474 m
.80511 .40474 L
s
.80517 .40463 m
.80517 .40463 L
s
.80525 .40545 m
.80525 .40545 L
s
.80532 .40897 m
.80532 .40897 L
s
.8054 .40674 m
.8054 .40674 L
s
.80547 .4092 m
.80547 .4092 L
s
.80555 .4092 m
.80555 .4092 L
s
.80562 .4078 m
.80562 .4078 L
s
.8057 .40827 m
.8057 .40827 L
s
.80577 .40204 m
.80577 .40204 L
s
.80585 .40356 m
.80585 .40356 L
s
.80592 .40321 m
.80592 .40321 L
s
.80599 .39934 m
.80599 .39934 L
s
.80606 .40063 m
.80606 .40063 L
s
.80614 .40709 m
.80614 .40709 L
s
.80622 .40838 m
.80622 .40838 L
s
.80629 .41167 m
.80629 .41167 L
s
.80637 .41813 m
.80637 .41813 L
s
.80644 .4132 m
.80644 .4132 L
s
.80652 .42024 m
.80652 .42024 L
s
.80659 .41461 m
.80659 .41461 L
s
.80667 .41825 m
.80667 .41825 L
s
.80674 .42001 m
.80674 .42001 L
s
.80681 .42283 m
.80681 .42283 L
s
.80688 .42341 m
.80688 .42341 L
s
.80696 .42776 m
.80696 .42776 L
s
.80703 .42271 m
.80703 .42271 L
s
.80711 .41837 m
.80711 .41837 L
s
.80718 .41508 m
.80718 .41508 L
s
.80726 .42189 m
.80726 .42189 L
s
.80733 .42541 m
.80733 .42541 L
s
.80741 .42682 m
.80741 .42682 L
s
.80748 .43293 m
.80748 .43293 L
s
.80755 .43586 m
.80755 .43586 L
s
.80762 .43375 m
.80762 .43375 L
s
.8077 .43328 m
.8077 .43328 L
s
.80778 .43398 m
.80778 .43398 L
s
.80785 .42905 m
.80785 .42905 L
s
.80793 .4253 m
.80793 .4253 L
s
.808 .43022 m
.808 .43022 L
s
.80808 .42658 m
.80808 .42658 L
s
.80815 .428 m
.80815 .428 L
s
.80823 .43211 m
.80823 .43211 L
s
.8083 .43034 m
.8083 .43034 L
s
.80837 .42376 m
.80837 .42376 L
s
.80844 .42095 m
.80844 .42095 L
s
.80852 .42376 m
.80852 .42376 L
s
.80859 .42553 m
.80859 .42553 L
s
.80867 .42201 m
.80867 .42201 L
s
.80874 .42318 m
.80874 .42318 L
s
.80882 .42189 m
.80882 .42189 L
s
.80889 .42095 m
.80889 .42095 L
s
.80897 .41954 m
.80897 .41954 L
s
.80904 .42154 m
.80904 .42154 L
s
.80912 .42353 m
.80912 .42353 L
s
.80919 .4314 m
.80919 .4314 L
s
.80926 .42353 m
.80926 .42353 L
s
.80934 .43034 m
.80934 .43034 L
s
.80941 .4334 m
.80941 .4334 L
s
.80949 .43129 m
.80949 .43129 L
s
.80956 .43234 m
.80956 .43234 L
s
.80964 .43129 m
.80964 .43129 L
s
.80971 .43739 m
.80971 .43739 L
s
.80978 .43528 m
.80978 .43528 L
s
.80986 .43598 m
.80986 .43598 L
s
.80994 .43258 m
.80994 .43258 L
s
.81 .42576 m
.81 .42576 L
s
.81008 .42717 m
.81008 .42717 L
s
.81015 .42459 m
.81015 .42459 L
s
.81023 .42494 m
.81023 .42494 L
s
.8103 .42847 m
.8103 .42847 L
s
.81038 .43269 m
.81038 .43269 L
s
.81045 .43152 m
.81045 .43152 L
s
.81052 .43293 m
.81052 .43293 L
s
.8106 .42847 m
.8106 .42847 L
s
.81068 .42072 m
.81068 .42072 L
s
.81075 .41813 m
.81075 .41813 L
s
.81082 .4132 m
.81082 .4132 L
s
.8109 .41766 m
.8109 .41766 L
s
.81097 .42072 m
.81097 .42072 L
s
.81105 .42107 m
.81105 .42107 L
s
.81112 .41625 m
.81112 .41625 L
s
.8112 .41391 m
.8112 .41391 L
s
.81127 .41378 m
.81127 .41378 L
s
.81134 .41813 m
.81134 .41813 L
s
.81141 .42048 m
.81141 .42048 L
s
.81149 .42024 m
.81149 .42024 L
s
.81157 .41872 m
.81157 .41872 L
s
.81164 .4159 m
.81164 .4159 L
s
.81171 .40791 m
.81171 .40791 L
s
.81179 .40944 m
.81179 .40944 L
s
.81186 .40685 m
.81186 .40685 L
s
.81194 .40416 m
.81194 .40416 L
s
.81201 .40615 m
.81201 .40615 L
s
.81209 .4051 m
.81209 .4051 L
s
.81216 .40592 m
.81216 .40592 L
s
.81223 .40533 m
.81223 .40533 L
s
.81231 .39241 m
.81231 .39241 L
s
.81239 .38971 m
.81239 .38971 L
s
.81246 .38959 m
.81246 .38959 L
s
.81253 .38114 m
.81253 .38114 L
s
.81261 .38254 m
.81261 .38254 L
s
.81268 .38678 m
.81268 .38678 L
s
.81276 .38713 m
.81276 .38713 L
s
.81283 .38513 m
.81283 .38513 L
s
.81291 .38454 m
.81291 .38454 L
s
.81297 .38689 m
.81297 .38689 L
s
.81305 .38853 m
.81305 .38853 L
s
.81312 .38337 m
.81312 .38337 L
s
.8132 .38865 m
.8132 .38865 L
s
.81327 .38924 m
.81327 .38924 L
s
.81335 .38489 m
.81335 .38489 L
s
.81342 .38337 m
.81342 .38337 L
s
.8135 .38994 m
.8135 .38994 L
s
.81357 .38842 m
.81357 .38842 L
s
.81365 .38971 m
.81365 .38971 L
s
.81372 .38689 m
.81372 .38689 L
s
.81379 .39441 m
.81379 .39441 L
s
.81386 .38994 m
.81386 .38994 L
s
.81394 .39652 m
.81394 .39652 L
s
.81402 .39617 m
.81402 .39617 L
s
.81409 .39863 m
.81409 .39863 L
s
.81417 .40404 m
.81417 .40404 L
s
.81424 .40368 m
.81424 .40368 L
s
.81432 .39863 m
.81432 .39863 L
s
.81439 .39535 m
.81439 .39535 L
s
.81447 .40099 m
.81447 .40099 L
s
.81454 .40134 m
.81454 .40134 L
s
.81461 .39535 m
.81461 .39535 L
s
.81468 .39323 m
.81468 .39323 L
s
.81476 .39582 m
.81476 .39582 L
s
.81483 .39359 m
.81483 .39359 L
s
.81491 .39311 m
.81491 .39311 L
s
.81498 .39699 m
.81498 .39699 L
s
.81506 .3984 m
.81506 .3984 L
s
.81513 .39464 m
.81513 .39464 L
s
.81521 .39171 m
.81521 .39171 L
s
.81528 .39346 m
.81528 .39346 L
s
.81536 .39934 m
.81536 .39934 L
s
.81542 .39957 m
.81542 .39957 L
s
.8155 .40627 m
.8155 .40627 L
s
.81558 .40474 m
.81558 .40474 L
s
.81565 .40979 m
.81565 .40979 L
s
.81573 .4085 m
.81573 .4085 L
s
.8158 .4152 m
.8158 .4152 L
s
.81588 .41296 m
.81588 .41296 L
s
.81595 .41155 m
.81595 .41155 L
s
.81603 .41002 m
.81603 .41002 L
s
.8161 .4078 m
.8161 .4078 L
s
.81617 .41038 m
.81617 .41038 L
s
.81624 .41602 m
.81624 .41602 L
s
.81632 .41308 m
.81632 .41308 L
s
.81639 .41578 m
.81639 .41578 L
s
.81647 .40967 m
.81647 .40967 L
s
.81654 .41496 m
.81654 .41496 L
s
.81662 .41238 m
.81662 .41238 L
s
.81669 .40709 m
.81669 .40709 L
s
.81677 .4152 m
.81677 .4152 L
s
.81684 .40368 m
.81684 .40368 L
s
.81692 .40991 m
.81692 .40991 L
s
.81699 .41073 m
.81699 .41073 L
s
.81706 .41343 m
.81706 .41343 L
s
.81714 .41355 m
.81714 .41355 L
s
.81721 .40815 m
.81721 .40815 L
s
.81729 .41202 m
.81729 .41202 L
s
.81736 .41073 m
.81736 .41073 L
s
.81744 .40897 m
.81744 .40897 L
s
.81751 .40697 m
.81751 .40697 L
s
.81759 .40122 m
.81759 .40122 L
s
.81766 .40404 m
.81766 .40404 L
s
.81774 .40321 m
.81774 .40321 L
s
.8178 .40568 m
.8178 .40568 L
s
.81788 .40897 m
.81788 .40897 L
s
.81795 .40803 m
.81795 .40803 L
s
.81803 .41014 m
.81803 .41014 L
s
.8181 .4011 m
.8181 .4011 L
s
.81818 .39453 m
.81818 .39453 L
s
.81825 .40263 m
.81825 .40263 L
s
.81833 .39464 m
.81833 .39464 L
s
.8184 .39758 m
.8184 .39758 L
s
.81848 .40075 m
.81848 .40075 L
s
.81855 .40239 m
.81855 .40239 L
s
.81862 .39957 m
.81862 .39957 L
s
.8187 .39182 m
.8187 .39182 L
s
.81877 .3883 m
.81877 .3883 L
s
.81885 .39299 m
.81885 .39299 L
s
.81892 .39511 m
.81892 .39511 L
s
.819 .39299 m
.819 .39299 L
s
.81907 .39124 m
.81907 .39124 L
s
.81914 .38748 m
.81914 .38748 L
s
.81922 .3856 m
.81922 .3856 L
s
.8193 .38701 m
.8193 .38701 L
s
.81937 .38642 m
.81937 .38642 L
s
.81944 .3883 m
.81944 .3883 L
s
.81951 .38959 m
.81951 .38959 L
s
.81959 .38971 m
.81959 .38971 L
s
.81966 .3876 m
.81966 .3876 L
s
.81974 .38384 m
.81974 .38384 L
s
.81981 .37997 m
.81981 .37997 L
s
.81989 .38219 m
.81989 .38219 L
s
.81996 .3708 m
.81996 .3708 L
s
.82003 .37256 m
.82003 .37256 L
s
.82011 .3762 m
.82011 .3762 L
s
.82019 .3775 m
.82019 .3775 L
s
.82026 .37315 m
.82026 .37315 L
s
.82033 .36845 m
.82033 .36845 L
s
.82041 .36892 m
.82041 .36892 L
s
.82048 .36399 m
.82048 .36399 L
s
.82056 .36317 m
.82056 .36317 L
s
.82063 .36234 m
.82063 .36234 L
s
.82071 .35941 m
.82071 .35941 L
s
.82077 .35859 m
.82077 .35859 L
s
.82085 .35483 m
.82085 .35483 L
s
.82093 .35095 m
.82093 .35095 L
s
.821 .3573 m
.821 .3573 L
s
.82107 .35965 m
.82107 .35965 L
s
.82115 .35905 m
.82115 .35905 L
s
.82122 .36329 m
.82122 .36329 L
s
.8213 .35319 m
.8213 .35319 L
s
.82137 .35142 m
.82137 .35142 L
s
.82145 .35259 m
.82145 .35259 L
s
.82152 .35072 m
.82152 .35072 L
s
.82159 .34226 m
.82159 .34226 L
s
.82166 .33768 m
.82166 .33768 L
s
.82174 .34003 m
.82174 .34003 L
s
.82182 .33404 m
.82182 .33404 L
s
.82189 .33381 m
.82189 .33381 L
s
.82197 .33604 m
.82197 .33604 L
s
.82204 .33968 m
.82204 .33968 L
s
.82212 .34449 m
.82212 .34449 L
s
.82219 .34508 m
.82219 .34508 L
s
.82227 .34249 m
.82227 .34249 L
s
.82234 .34414 m
.82234 .34414 L
s
.82241 .34578 m
.82241 .34578 L
s
.82248 .3398 m
.82248 .3398 L
s
.82256 .34344 m
.82256 .34344 L
s
.82263 .34391 m
.82263 .34391 L
s
.82271 .33945 m
.82271 .33945 L
s
.82278 .33885 m
.82278 .33885 L
s
.82286 .34531 m
.82286 .34531 L
s
.82293 .34567 m
.82293 .34567 L
s
.82301 .35048 m
.82301 .35048 L
s
.82308 .35002 m
.82308 .35002 L
s
.82316 .35259 m
.82316 .35259 L
s
.82322 .35424 m
.82322 .35424 L
s
.8233 .35072 m
.8233 .35072 L
s
.82338 .34813 m
.82338 .34813 L
s
.82345 .35048 m
.82345 .35048 L
s
.82353 .35259 m
.82353 .35259 L
s
.8236 .35424 m
.8236 .35424 L
s
.82368 .35459 m
.82368 .35459 L
s
.82375 .3553 m
.82375 .3553 L
s
.82383 .35636 m
.82383 .35636 L
s
.8239 .3607 m
.8239 .3607 L
s
.82397 .35917 m
.82397 .35917 L
s
.82404 .36035 m
.82404 .36035 L
s
.82412 .35952 m
.82412 .35952 L
s
.82419 .36012 m
.82419 .36012 L
s
.82427 .36035 m
.82427 .36035 L
s
.82434 .36012 m
.82434 .36012 L
s
.82442 .35588 m
.82442 .35588 L
s
.82449 .35965 m
.82449 .35965 L
s
.82457 .35259 m
.82457 .35259 L
s
.82464 .34555 m
.82464 .34555 L
s
.82472 .34872 m
.82472 .34872 L
s
.82479 .34813 m
.82479 .34813 L
s
.82486 .34708 m
.82486 .34708 L
s
.82494 .35307 m
.82494 .35307 L
s
.82501 .35905 m
.82501 .35905 L
s
.82509 .35648 m
.82509 .35648 L
s
.82516 .35025 m
.82516 .35025 L
s
.82524 .35013 m
.82524 .35013 L
s
.82531 .35224 m
.82531 .35224 L
s
.82539 .35284 m
.82539 .35284 L
s
.82546 .34638 m
.82546 .34638 L
s
.82554 .34496 m
.82554 .34496 L
s
.8256 .34496 m
.8256 .34496 L
s
.82568 .34907 m
.82568 .34907 L
s
.82575 .34297 m
.82575 .34297 L
s
.82583 .34391 m
.82583 .34391 L
s
.8259 .34626 m
.8259 .34626 L
s
.82598 .33533 m
.82598 .33533 L
s
.82605 .33815 m
.82605 .33815 L
s
.82613 .33357 m
.82613 .33357 L
s
.8262 .33146 m
.8262 .33146 L
s
.82628 .33157 m
.82628 .33157 L
s
.82635 .33334 m
.82635 .33334 L
s
.82642 .33475 m
.82642 .33475 L
s
.8265 .33545 m
.8265 .33545 L
s
.82657 .33628 m
.82657 .33628 L
s
.82665 .3432 m
.82665 .3432 L
s
.82672 .34332 m
.82672 .34332 L
s
.8268 .33838 m
.8268 .33838 L
s
.82687 .33592 m
.82687 .33592 L
s
.82694 .33264 m
.82694 .33264 L
s
.82702 .33005 m
.82702 .33005 L
s
.8271 .33264 m
.8271 .33264 L
s
.82717 .33264 m
.82717 .33264 L
s
.82724 .3378 m
.82724 .3378 L
s
.82731 .34132 m
.82731 .34132 L
s
.82739 .33498 m
.82739 .33498 L
s
.82746 .32993 m
.82746 .32993 L
s
.82754 .33017 m
.82754 .33017 L
s
.82761 .33334 m
.82761 .33334 L
s
.82769 .32946 m
.82769 .32946 L
s
.82776 .32993 m
.82776 .32993 L
s
.82784 .32535 m
.82784 .32535 L
s
.82791 .32182 m
.82791 .32182 L
s
.82799 .32018 m
.82799 .32018 L
s
.82806 .31596 m
.82806 .31596 L
s
.82813 .32112 m
.82813 .32112 L
s
.82821 .32124 m
.82821 .32124 L
s
.82828 .31501 m
.82828 .31501 L
s
.82836 .31561 m
.82836 .31561 L
s
.82843 .31713 m
.82843 .31713 L
s
.82851 .31783 m
.82851 .31783 L
s
.82857 .32254 m
.82857 .32254 L
s
.82865 .32711 m
.82865 .32711 L
s
.82873 .33075 m
.82873 .33075 L
s
.8288 .33275 m
.8288 .33275 L
s
.82887 .33099 m
.82887 .33099 L
s
.82895 .33568 m
.82895 .33568 L
s
.82902 .3351 m
.82902 .3351 L
s
.8291 .32793 m
.8291 .32793 L
s
.82917 .33052 m
.82917 .33052 L
s
.82925 .33533 m
.82925 .33533 L
s
.82932 .33404 m
.82932 .33404 L
s
.82939 .33545 m
.82939 .33545 L
s
.82947 .33439 m
.82947 .33439 L
s
.82955 .33075 m
.82955 .33075 L
s
.82962 .32982 m
.82962 .32982 L
s
.82969 .33581 m
.82969 .33581 L
s
.82977 .34778 m
.82977 .34778 L
s
.82984 .34743 m
.82984 .34743 L
s
.82992 .35259 m
.82992 .35259 L
s
.82999 .35777 m
.82999 .35777 L
s
.83007 .35612 m
.83007 .35612 L
s
.83014 .35588 m
.83014 .35588 L
s
.83021 .35565 m
.83021 .35565 L
s
.83028 .35401 m
.83028 .35401 L
s
.83036 .35471 m
.83036 .35471 L
s
.83043 .35495 m
.83043 .35495 L
s
.83051 .35119 m
.83051 .35119 L
s
.83058 .35354 m
.83058 .35354 L
s
.83066 .35084 m
.83066 .35084 L
s
.83073 .34931 m
.83073 .34931 L
s
.83081 .34214 m
.83081 .34214 L
s
.83088 .34027 m
.83088 .34027 L
s
.83096 .33686 m
.83096 .33686 L
s
.83102 .33698 m
.83102 .33698 L
s
.8311 .33874 m
.8311 .33874 L
s
.83118 .34274 m
.83118 .34274 L
s
.83125 .34907 m
.83125 .34907 L
s
.83133 .35588 m
.83133 .35588 L
s
.8314 .35823 m
.8314 .35823 L
s
.83148 .35894 m
.83148 .35894 L
s
.83155 .36094 m
.83155 .36094 L
s
.83163 .35624 m
.83163 .35624 L
s
.8317 .35741 m
.8317 .35741 L
s
.83177 .36 m
.83177 .36 L
s
.83184 .36376 m
.83184 .36376 L
s
.83192 .36481 m
.83192 .36481 L
s
.83199 .35541 m
.83199 .35541 L
s
.83207 .35142 m
.83207 .35142 L
s
.83214 .34696 m
.83214 .34696 L
s
.83222 .35025 m
.83222 .35025 L
s
.83229 .35366 m
.83229 .35366 L
s
.83237 .34802 m
.83237 .34802 L
s
.83244 .35025 m
.83244 .35025 L
s
.83252 .35694 m
.83252 .35694 L
s
.83259 .35284 m
.83259 .35284 L
s
.83266 .35941 m
.83266 .35941 L
s
.83274 .35823 m
.83274 .35823 L
s
.83281 .35788 m
.83281 .35788 L
s
.83289 .36469 m
.83289 .36469 L
s
.83296 .36293 m
.83296 .36293 L
s
.83304 .36364 m
.83304 .36364 L
s
.83311 .36669 m
.83311 .36669 L
s
.83319 .37045 m
.83319 .37045 L
s
.83326 .36987 m
.83326 .36987 L
s
.83334 .36845 m
.83334 .36845 L
s
.8334 .37538 m
.8334 .37538 L
s
.83348 .37832 m
.83348 .37832 L
s
.83355 .37937 m
.83355 .37937 L
s
.83363 .38008 m
.83363 .38008 L
s
.8337 .37797 m
.8337 .37797 L
s
.83378 .37561 m
.83378 .37561 L
s
.83385 .38043 m
.83385 .38043 L
s
.83393 .37902 m
.83393 .37902 L
s
.834 .37668 m
.834 .37668 L
s
.83408 .38032 m
.83408 .38032 L
s
.83415 .37679 m
.83415 .37679 L
s
.83422 .37643 m
.83422 .37643 L
s
.8343 .37668 m
.8343 .37668 L
s
.83437 .38337 m
.83437 .38337 L
s
.83445 .38654 m
.83445 .38654 L
s
.83452 .3883 m
.83452 .3883 L
s
.8346 .38654 m
.8346 .38654 L
s
.83467 .38924 m
.83467 .38924 L
s
.83475 .39112 m
.83475 .39112 L
s
.83482 .38947 m
.83482 .38947 L
s
.8349 .38571 m
.8349 .38571 L
s
.83497 .39042 m
.83497 .39042 L
s
.83504 .39382 m
.83504 .39382 L
s
.83511 .391 m
.83511 .391 L
s
.83519 .39135 m
.83519 .39135 L
s
.83526 .38912 m
.83526 .38912 L
s
.83534 .39394 m
.83534 .39394 L
s
.83541 .39276 m
.83541 .39276 L
s
.83549 .39241 m
.83549 .39241 L
s
.83556 .39206 m
.83556 .39206 L
s
.83564 .39065 m
.83564 .39065 L
s
.83571 .3863 m
.83571 .3863 L
s
.83579 .38301 m
.83579 .38301 L
s
.83586 .38454 m
.83586 .38454 L
s
.83593 .38771 m
.83593 .38771 L
s
.83601 .38536 m
.83601 .38536 L
s
.83608 .38678 m
.83608 .38678 L
s
.83616 .38689 m
.83616 .38689 L
s
.83623 .38689 m
.83623 .38689 L
s
.83631 .3876 m
.83631 .3876 L
s
.83638 .38771 m
.83638 .38771 L
s
.83646 .38384 m
.83646 .38384 L
s
.83653 .37997 m
.83653 .37997 L
s
.8366 .37808 m
.8366 .37808 L
s
.83667 .37279 m
.83667 .37279 L
s
.83675 .37867 m
.83675 .37867 L
s
.83682 .38125 m
.83682 .38125 L
s
.8369 .37608 m
.8369 .37608 L
s
.83697 .37632 m
.83697 .37632 L
s
.83705 .3775 m
.83705 .3775 L
s
.83712 .37643 m
.83712 .37643 L
s
.83719 .37773 m
.83719 .37773 L
s
.83727 .38971 m
.83727 .38971 L
s
.83735 .39382 m
.83735 .39382 L
s
.83742 .39558 m
.83742 .39558 L
s
.83749 .39406 m
.83749 .39406 L
s
.83757 .39346 m
.83757 .39346 L
s
.83764 .39112 m
.83764 .39112 L
s
.83772 .39182 m
.83772 .39182 L
s
.83779 .38947 m
.83779 .38947 L
s
.83787 .3883 m
.83787 .3883 L
s
.83794 .38454 m
.83794 .38454 L
s
.83801 .38161 m
.83801 .38161 L
s
.83808 .38795 m
.83808 .38795 L
s
.83816 .38489 m
.83816 .38489 L
s
.83823 .38654 m
.83823 .38654 L
s
.83831 .37984 m
.83831 .37984 L
s
.83838 .37867 m
.83838 .37867 L
s
.83846 .3789 m
.83846 .3789 L
s
.83853 .37843 m
.83853 .37843 L
s
.83861 .38289 m
.83861 .38289 L
s
.83868 .38196 m
.83868 .38196 L
s
.83876 .38266 m
.83876 .38266 L
s
.83882 .38713 m
.83882 .38713 L
s
.8389 .38947 m
.8389 .38947 L
s
.83898 .38665 m
.83898 .38665 L
s
.83905 .39135 m
.83905 .39135 L
s
.83913 .39159 m
.83913 .39159 L
s
.8392 .40216 m
.8392 .40216 L
s
.83928 .40451 m
.83928 .40451 L
s
.83935 .4011 m
.83935 .4011 L
s
.83943 .40568 m
.83943 .40568 L
s
.8395 .40556 m
.8395 .40556 L
s
.83957 .40052 m
.83957 .40052 L
s
.83964 .39253 m
.83964 .39253 L
s
.83972 .39229 m
.83972 .39229 L
s
.8398 .39006 m
.8398 .39006 L
s
.83987 .39276 m
.83987 .39276 L
s
.83994 .39441 m
.83994 .39441 L
s
.84002 .3977 m
.84002 .3977 L
s
.84009 .40333 m
.84009 .40333 L
s
.84017 .40239 m
.84017 .40239 L
s
.84024 .39887 m
.84024 .39887 L
s
.84032 .3984 m
.84032 .3984 L
s
.84039 .39441 m
.84039 .39441 L
s
.84046 .38795 m
.84046 .38795 L
s
.84054 .39159 m
.84054 .39159 L
s
.84061 .3876 m
.84061 .3876 L
s
.84069 .38301 m
.84069 .38301 L
s
.84076 .37949 m
.84076 .37949 L
s
.84084 .38079 m
.84084 .38079 L
s
.84091 .38337 m
.84091 .38337 L
s
.84099 .37703 m
.84099 .37703 L
s
.84106 .37656 m
.84106 .37656 L
s
.84114 .37925 m
.84114 .37925 L
s
.8412 .37937 m
.8412 .37937 L
s
.84128 .37386 m
.84128 .37386 L
s
.84135 .37104 m
.84135 .37104 L
s
.84143 .36211 m
.84143 .36211 L
s
.8415 .36258 m
.8415 .36258 L
s
.84158 .3573 m
.84158 .3573 L
s
.84165 .35753 m
.84165 .35753 L
s
.84173 .36129 m
.84173 .36129 L
s
.8418 .3607 m
.8418 .3607 L
s
.84188 .36481 m
.84188 .36481 L
s
.84195 .36646 m
.84195 .36646 L
s
.84202 .36904 m
.84202 .36904 L
s
.8421 .37374 m
.8421 .37374 L
s
.84217 .37351 m
.84217 .37351 L
s
.84225 .3762 m
.84225 .3762 L
s
.84232 .37386 m
.84232 .37386 L
s
.8424 .37479 m
.8424 .37479 L
s
.84247 .37503 m
.84247 .37503 L
s
.84255 .37022 m
.84255 .37022 L
s
.84262 .3674 m
.84262 .3674 L
s
.8427 .36587 m
.8427 .36587 L
s
.84277 .36281 m
.84277 .36281 L
s
.84284 .36469 m
.84284 .36469 L
s
.84291 .36246 m
.84291 .36246 L
s
.84299 .36317 m
.84299 .36317 L
s
.84306 .36681 m
.84306 .36681 L
s
.84314 .36646 m
.84314 .36646 L
s
.84321 .36352 m
.84321 .36352 L
s
.84329 .36059 m
.84329 .36059 L
s
.84336 .36728 m
.84336 .36728 L
s
.84344 .3674 m
.84344 .3674 L
s
.84351 .36575 m
.84351 .36575 L
s
.84359 .37057 m
.84359 .37057 L
s
.84366 .36763 m
.84366 .36763 L
s
.84373 .35753 m
.84373 .35753 L
s
.84381 .36281 m
.84381 .36281 L
s
.84388 .36622 m
.84388 .36622 L
s
.84396 .36505 m
.84396 .36505 L
s
.84403 .36387 m
.84403 .36387 L
s
.84411 .36211 m
.84411 .36211 L
s
.84418 .36176 m
.84418 .36176 L
s
.84426 .35965 m
.84426 .35965 L
s
.84433 .36399 m
.84433 .36399 L
s
.8444 .36341 m
.8444 .36341 L
s
.84447 .36434 m
.84447 .36434 L
s
.84455 .35706 m
.84455 .35706 L
s
.84462 .36693 m
.84462 .36693 L
s
.8447 .36047 m
.8447 .36047 L
s
.84477 .36551 m
.84477 .36551 L
s
.84485 .36117 m
.84485 .36117 L
s
.84492 .36317 m
.84492 .36317 L
s
.84499 .36493 m
.84499 .36493 L
s
.84507 .36892 m
.84507 .36892 L
s
.84515 .37433 m
.84515 .37433 L
s
.84522 .3708 m
.84522 .3708 L
s
.84529 .36775 m
.84529 .36775 L
s
.84537 .36927 m
.84537 .36927 L
s
.84544 .37444 m
.84544 .37444 L
s
.84552 .3762 m
.84552 .3762 L
s
.84559 .37268 m
.84559 .37268 L
s
.84567 .37397 m
.84567 .37397 L
s
.84574 .37479 m
.84574 .37479 L
s
.84581 .37879 m
.84581 .37879 L
s
.84589 .37867 m
.84589 .37867 L
s
.84597 .37503 m
.84597 .37503 L
s
.84603 .37491 m
.84603 .37491 L
s
.84611 .38137 m
.84611 .38137 L
s
.84618 .38008 m
.84618 .38008 L
s
.84626 .38207 m
.84626 .38207 L
s
.84633 .38396 m
.84633 .38396 L
s
.84641 .38172 m
.84641 .38172 L
s
.84648 .38924 m
.84648 .38924 L
s
.84656 .38618 m
.84656 .38618 L
s
.84662 .38571 m
.84662 .38571 L
s
.8467 .37925 m
.8467 .37925 L
s
.84678 .38149 m
.84678 .38149 L
s
.84685 .37691 m
.84685 .37691 L
s
.84693 .3775 m
.84693 .3775 L
s
.847 .36915 m
.847 .36915 L
s
.84708 .37069 m
.84708 .37069 L
s
.84715 .37397 m
.84715 .37397 L
s
.84723 .37162 m
.84723 .37162 L
s
.8473 .37045 m
.8473 .37045 L
s
.84737 .37127 m
.84737 .37127 L
s
.84744 .37374 m
.84744 .37374 L
s
.84752 .3708 m
.84752 .3708 L
s
.8476 .37608 m
.8476 .37608 L
s
.84767 .37643 m
.84767 .37643 L
s
.84774 .37703 m
.84774 .37703 L
s
.84782 .37256 m
.84782 .37256 L
s
.84789 .37162 m
.84789 .37162 L
s
.84797 .3688 m
.84797 .3688 L
s
.84804 .37843 m
.84804 .37843 L
s
.84812 .37397 m
.84812 .37397 L
s
.84819 .38172 m
.84819 .38172 L
s
.84826 .38114 m
.84826 .38114 L
s
.84834 .38231 m
.84834 .38231 L
s
.84841 .37761 m
.84841 .37761 L
s
.84849 .37855 m
.84849 .37855 L
s
.84856 .37855 m
.84856 .37855 L
s
.84864 .3755 m
.84864 .3755 L
s
.84871 .38266 m
.84871 .38266 L
s
.84879 .38525 m
.84879 .38525 L
s
.84886 .38478 m
.84886 .38478 L
s
.84894 .38289 m
.84894 .38289 L
s
.849 .37902 m
.849 .37902 L
s
.84908 .38665 m
.84908 .38665 L
s
.84915 .38959 m
.84915 .38959 L
s
.84923 .38478 m
.84923 .38478 L
s
.8493 .38571 m
.8493 .38571 L
s
.84938 .38583 m
.84938 .38583 L
s
.84945 .38771 m
.84945 .38771 L
s
.84953 .38595 m
.84953 .38595 L
s
.8496 .38982 m
.8496 .38982 L
s
.84968 .39711 m
.84968 .39711 L
s
.84975 .39089 m
.84975 .39089 L
s
.84982 .39699 m
.84982 .39699 L
s
.8499 .39628 m
.8499 .39628 L
s
.84997 .40204 m
.84997 .40204 L
s
.85005 .4004 m
.85005 .4004 L
s
.85012 .40873 m
.85012 .40873 L
s
.8502 .40862 m
.8502 .40862 L
s
.85027 .4078 m
.85027 .4078 L
s
.85035 .40909 m
.85035 .40909 L
s
.85042 .40709 m
.85042 .40709 L
s
.8505 .41014 m
.8505 .41014 L
s
.85057 .40545 m
.85057 .40545 L
s
.85064 .40827 m
.85064 .40827 L
s
.85071 .41402 m
.85071 .41402 L
s
.85079 .4092 m
.85079 .4092 L
s
.85086 .40099 m
.85086 .40099 L
s
.85094 .40381 m
.85094 .40381 L
s
.85101 .4085 m
.85101 .4085 L
s
.85109 .40932 m
.85109 .40932 L
s
.85116 .41226 m
.85116 .41226 L
s
.85124 .41555 m
.85124 .41555 L
s
.85131 .41837 m
.85131 .41837 L
s
.85139 .41837 m
.85139 .41837 L
s
.85146 .41602 m
.85146 .41602 L
s
.85153 .41578 m
.85153 .41578 L
s
.85161 .41308 m
.85161 .41308 L
s
.85168 .41038 m
.85168 .41038 L
s
.85176 .41062 m
.85176 .41062 L
s
.85183 .41026 m
.85183 .41026 L
s
.85191 .4078 m
.85191 .4078 L
s
.85198 .40685 m
.85198 .40685 L
s
.85206 .40451 m
.85206 .40451 L
s
.85213 .40004 m
.85213 .40004 L
s
.8522 .40803 m
.8522 .40803 L
s
.85227 .40157 m
.85227 .40157 L
s
.85235 .40286 m
.85235 .40286 L
s
.85242 .39664 m
.85242 .39664 L
s
.8525 .39957 m
.8525 .39957 L
s
.85257 .40321 m
.85257 .40321 L
s
.85265 .40099 m
.85265 .40099 L
s
.85272 .40263 m
.85272 .40263 L
s
.8528 .39699 m
.8528 .39699 L
s
.85287 .40028 m
.85287 .40028 L
s
.85295 .39793 m
.85295 .39793 L
s
.85302 .39863 m
.85302 .39863 L
s
.85309 .39323 m
.85309 .39323 L
s
.85317 .39159 m
.85317 .39159 L
s
.85324 .39065 m
.85324 .39065 L
s
.85332 .38783 m
.85332 .38783 L
s
.85339 .38924 m
.85339 .38924 L
s
.85347 .38713 m
.85347 .38713 L
s
.85354 .38454 m
.85354 .38454 L
s
.85361 .39159 m
.85361 .39159 L
s
.85369 .38231 m
.85369 .38231 L
s
.85377 .37797 m
.85377 .37797 L
s
.85383 .38548 m
.85383 .38548 L
s
.85391 .38536 m
.85391 .38536 L
s
.85398 .389 m
.85398 .389 L
s
.85406 .38853 m
.85406 .38853 L
s
.85413 .39159 m
.85413 .39159 L
s
.85421 .39264 m
.85421 .39264 L
s
.85428 .39546 m
.85428 .39546 L
s
.85436 .39323 m
.85436 .39323 L
s
.85443 .39981 m
.85443 .39981 L
s
.85451 .39699 m
.85451 .39699 L
s
.85459 .3957 m
.85459 .3957 L
s
.85465 .3977 m
.85465 .3977 L
s
.85473 .39899 m
.85473 .39899 L
s
.8548 .39922 m
.8548 .39922 L
s
.85488 .40016 m
.85488 .40016 L
s
.85495 .40697 m
.85495 .40697 L
s
.85503 .40944 m
.85503 .40944 L
s
.8551 .41014 m
.8551 .41014 L
s
.85517 .41837 m
.85517 .41837 L
s
.85524 .42353 m
.85524 .42353 L
s
.85532 .42588 m
.85532 .42588 L
s
.8554 .42412 m
.8554 .42412 L
s
.85547 .42647 m
.85547 .42647 L
s
.85554 .42765 m
.85554 .42765 L
s
.85562 .42812 m
.85562 .42812 L
s
.85569 .42694 m
.85569 .42694 L
s
.85577 .42095 m
.85577 .42095 L
s
.85584 .41848 m
.85584 .41848 L
s
.85592 .41954 m
.85592 .41954 L
s
.85599 .41907 m
.85599 .41907 L
s
.85606 .41155 m
.85606 .41155 L
s
.85614 .41132 m
.85614 .41132 L
s
.85622 .41473 m
.85622 .41473 L
s
.85629 .41238 m
.85629 .41238 L
s
.85636 .41038 m
.85636 .41038 L
s
.85644 .41002 m
.85644 .41002 L
s
.85651 .40733 m
.85651 .40733 L
s
.85659 .41155 m
.85659 .41155 L
s
.85666 .41343 m
.85666 .41343 L
s
.85674 .40873 m
.85674 .40873 L
s
.8568 .40556 m
.8568 .40556 L
s
.85688 .40122 m
.85688 .40122 L
s
.85695 .39992 m
.85695 .39992 L
s
.85703 .40274 m
.85703 .40274 L
s
.8571 .40404 m
.8571 .40404 L
s
.85718 .40427 m
.85718 .40427 L
s
.85725 .4078 m
.85725 .4078 L
s
.85733 .40709 m
.85733 .40709 L
s
.8574 .4112 m
.8574 .4112 L
s
.85748 .41508 m
.85748 .41508 L
s
.85755 .41813 m
.85755 .41813 L
s
.85762 .41884 m
.85762 .41884 L
s
.8577 .41813 m
.8577 .41813 L
s
.85777 .42024 m
.85777 .42024 L
s
.85785 .41801 m
.85785 .41801 L
s
.85792 .42177 m
.85792 .42177 L
s
.858 .42201 m
.858 .42201 L
s
.85807 .41695 m
.85807 .41695 L
s
.85815 .42236 m
.85815 .42236 L
s
.85822 .42436 m
.85822 .42436 L
s
.8583 .42142 m
.8583 .42142 L
s
.85837 .41837 m
.85837 .41837 L
s
.85844 .41391 m
.85844 .41391 L
s
.85851 .41637 m
.85851 .41637 L
s
.85859 .41684 m
.85859 .41684 L
s
.85866 .41743 m
.85866 .41743 L
s
.85874 .4193 m
.85874 .4193 L
s
.85881 .41755 m
.85881 .41755 L
s
.85889 .41954 m
.85889 .41954 L
s
.85896 .4152 m
.85896 .4152 L
s
.85904 .42483 m
.85904 .42483 L
s
.85911 .42823 m
.85911 .42823 L
s
.85919 .43034 m
.85919 .43034 L
s
.85926 .43481 m
.85926 .43481 L
s
.85933 .43927 m
.85933 .43927 L
s
.85941 .43469 m
.85941 .43469 L
s
.85948 .43422 m
.85948 .43422 L
s
.85956 .43446 m
.85956 .43446 L
s
.85963 .42952 m
.85963 .42952 L
s
.85971 .42917 m
.85971 .42917 L
s
.85978 .43622 m
.85978 .43622 L
s
.85986 .4361 m
.85986 .4361 L
s
.85993 .43915 m
.85993 .43915 L
s
.86 .43551 m
.86 .43551 L
s
.86007 .43692 m
.86007 .43692 L
s
.86015 .43363 m
.86015 .43363 L
s
.86022 .42905 m
.86022 .42905 L
s
.8603 .42999 m
.8603 .42999 L
s
.86037 .42917 m
.86037 .42917 L
s
.86045 .42318 m
.86045 .42318 L
s
.86052 .42483 m
.86052 .42483 L
s
.8606 .426 m
.8606 .426 L
s
.86067 .42917 m
.86067 .42917 L
s
.86075 .42635 m
.86075 .42635 L
s
.86082 .42635 m
.86082 .42635 L
s
.86089 .42612 m
.86089 .42612 L
s
.86097 .42917 m
.86097 .42917 L
s
.86104 .43129 m
.86104 .43129 L
s
.86112 .42506 m
.86112 .42506 L
s
.86119 .42753 m
.86119 .42753 L
s
.86127 .42729 m
.86127 .42729 L
s
.86134 .43034 m
.86134 .43034 L
s
.86142 .43187 m
.86142 .43187 L
s
.86149 .43176 m
.86149 .43176 L
s
.86157 .42894 m
.86157 .42894 L
s
.86164 .42753 m
.86164 .42753 L
s
.86171 .42424 m
.86171 .42424 L
s
.86178 .42376 m
.86178 .42376 L
s
.86186 .42388 m
.86186 .42388 L
s
.86193 .42541 m
.86193 .42541 L
s
.86201 .42541 m
.86201 .42541 L
s
.86208 .43222 m
.86208 .43222 L
s
.86216 .43857 m
.86216 .43857 L
s
.86223 .43715 m
.86223 .43715 L
s
.86231 .44221 m
.86231 .44221 L
s
.86239 .43622 m
.86239 .43622 L
s
.86245 .43269 m
.86245 .43269 L
s
.86253 .43434 m
.86253 .43434 L
s
.8626 .43645 m
.8626 .43645 L
s
.86268 .4375 m
.86268 .4375 L
s
.86275 .44079 m
.86275 .44079 L
s
.86283 .44197 m
.86283 .44197 L
s
.8629 .44456 m
.8629 .44456 L
s
.86297 .44772 m
.86297 .44772 L
s
.86305 .44737 m
.86305 .44737 L
s
.86313 .45124 m
.86313 .45124 L
s
.8632 .44772 m
.8632 .44772 L
s
.86327 .45101 m
.86327 .45101 L
s
.86334 .45196 m
.86334 .45196 L
s
.86342 .45947 m
.86342 .45947 L
s
.86349 .45348 m
.86349 .45348 L
s
.86357 .46346 m
.86357 .46346 L
s
.86364 .459 m
.86364 .459 L
s
.86372 .4577 m
.86372 .4577 L
s
.86379 .4556 m
.86379 .4556 L
s
.86386 .45336 m
.86386 .45336 L
s
.86394 .45665 m
.86394 .45665 L
s
.86402 .45313 m
.86402 .45313 L
s
.86409 .45501 m
.86409 .45501 L
s
.86416 .45595 m
.86416 .45595 L
s
.86424 .45806 m
.86424 .45806 L
s
.86431 .45971 m
.86431 .45971 L
s
.86439 .45782 m
.86439 .45782 L
s
.86446 .46076 m
.86446 .46076 L
s
.86454 .45853 m
.86454 .45853 L
s
.86461 .46111 m
.86461 .46111 L
s
.86468 .46323 m
.86468 .46323 L
s
.86476 .46276 m
.86476 .46276 L
s
.86483 .45077 m
.86483 .45077 L
s
.8649 .45453 m
.8649 .45453 L
s
.86498 .46029 m
.86498 .46029 L
s
.86505 .46194 m
.86505 .46194 L
s
.86513 .46804 m
.86513 .46804 L
s
.8652 .47438 m
.8652 .47438 L
s
.86528 .48061 m
.86528 .48061 L
s
.86535 .48084 m
.86535 .48084 L
s
.86542 .47638 m
.86542 .47638 L
s
.8655 .47156 m
.8655 .47156 L
s
.86557 .4698 m
.86557 .4698 L
s
.86565 .47109 m
.86565 .47109 L
s
.86572 .47145 m
.86572 .47145 L
s
.8658 .4785 m
.8658 .4785 L
s
.86587 .48355 m
.86587 .48355 L
s
.86595 .48037 m
.86595 .48037 L
s
.86602 .48261 m
.86602 .48261 L
s
.8661 .48355 m
.8661 .48355 L
s
.86617 .47756 m
.86617 .47756 L
s
.86624 .47955 m
.86624 .47955 L
s
.86631 .48402 m
.86631 .48402 L
s
.86639 .48343 m
.86639 .48343 L
s
.86647 .48061 m
.86647 .48061 L
s
.86654 .47673 m
.86654 .47673 L
s
.86661 .47802 m
.86661 .47802 L
s
.86669 .47544 m
.86669 .47544 L
s
.86676 .47756 m
.86676 .47756 L
s
.86684 .48084 m
.86684 .48084 L
s
.86691 .48072 m
.86691 .48072 L
s
.86699 .47521 m
.86699 .47521 L
s
.86706 .47662 m
.86706 .47662 L
s
.86713 .47556 m
.86713 .47556 L
s
.86721 .47779 m
.86721 .47779 L
s
.86728 .47709 m
.86728 .47709 L
s
.86736 .48037 m
.86736 .48037 L
s
.86743 .48166 m
.86743 .48166 L
s
.86751 .48108 m
.86751 .48108 L
s
.86758 .47897 m
.86758 .47897 L
s
.86766 .4785 m
.86766 .4785 L
s
.86773 .47391 m
.86773 .47391 L
s
.8678 .46992 m
.8678 .46992 L
s
.86787 .47051 m
.86787 .47051 L
s
.86795 .46687 m
.86795 .46687 L
s
.86802 .46722 m
.86802 .46722 L
s
.8681 .46652 m
.8681 .46652 L
s
.86817 .46217 m
.86817 .46217 L
s
.86825 .46076 m
.86825 .46076 L
s
.86832 .45606 m
.86832 .45606 L
s
.8684 .46264 m
.8684 .46264 L
s
.86847 .46029 m
.86847 .46029 L
s
.86855 .45747 m
.86855 .45747 L
s
.86862 .46346 m
.86862 .46346 L
s
.86869 .46523 m
.86869 .46523 L
s
.86877 .46088 m
.86877 .46088 L
s
.86884 .46182 m
.86884 .46182 L
s
.86892 .45478 m
.86892 .45478 L
s
.86899 .45313 m
.86899 .45313 L
s
.86907 .45489 m
.86907 .45489 L
s
.86914 .45101 m
.86914 .45101 L
s
.86922 .45478 m
.86922 .45478 L
s
.86929 .45172 m
.86929 .45172 L
s
.86937 .4489 m
.86937 .4489 L
s
.86944 .45101 m
.86944 .45101 L
s
.86951 .45266 m
.86951 .45266 L
s
.86958 .45336 m
.86958 .45336 L
s
.86966 .44737 m
.86966 .44737 L
s
.86973 .45971 m
.86973 .45971 L
s
.86981 .46135 m
.86981 .46135 L
s
.86988 .4644 m
.86988 .4644 L
s
.86996 .46217 m
.86996 .46217 L
s
.87003 .46605 m
.87003 .46605 L
s
.87011 .46346 m
.87011 .46346 L
s
.87019 .46828 m
.87019 .46828 L
s
.87025 .47098 m
.87025 .47098 L
s
.87033 .46652 m
.87033 .46652 L
s
.8704 .4644 m
.8704 .4644 L
s
.87048 .46229 m
.87048 .46229 L
s
.87055 .45935 m
.87055 .45935 L
s
.87063 .45723 m
.87063 .45723 L
s
.8707 .46135 m
.8707 .46135 L
s
.87077 .46535 m
.87077 .46535 L
s
.87085 .4637 m
.87085 .4637 L
s
.87093 .461 m
.87093 .461 L
s
.871 .46605 m
.871 .46605 L
s
.87107 .46511 m
.87107 .46511 L
s
.87114 .46546 m
.87114 .46546 L
s
.87122 .4617 m
.87122 .4617 L
s
.87129 .46393 m
.87129 .46393 L
s
.87137 .45453 m
.87137 .45453 L
s
.87144 .45313 m
.87144 .45313 L
s
.87152 .45336 m
.87152 .45336 L
s
.87159 .45912 m
.87159 .45912 L
s
.87167 .45877 m
.87167 .45877 L
s
.87175 .46053 m
.87175 .46053 L
s
.87182 .46147 m
.87182 .46147 L
s
.87189 .45971 m
.87189 .45971 L
s
.87196 .45606 m
.87196 .45606 L
s
.87204 .45595 m
.87204 .45595 L
s
.87211 .45572 m
.87211 .45572 L
s
.87219 .45348 m
.87219 .45348 L
s
.87226 .45935 m
.87226 .45935 L
s
.87234 .45994 m
.87234 .45994 L
s
.87241 .46205 m
.87241 .46205 L
s
.87248 .4617 m
.87248 .4617 L
s
.87256 .46123 m
.87256 .46123 L
s
.87263 .46299 m
.87263 .46299 L
s
.8727 .459 m
.8727 .459 L
s
.87278 .45782 m
.87278 .45782 L
s
.87285 .45618 m
.87285 .45618 L
s
.87293 .46299 m
.87293 .46299 L
s
.873 .46064 m
.873 .46064 L
s
.87308 .45806 m
.87308 .45806 L
s
.87315 .4583 m
.87315 .4583 L
s
.87322 .46006 m
.87322 .46006 L
s
.8733 .46276 m
.8733 .46276 L
s
.87338 .45606 m
.87338 .45606 L
s
.87345 .45712 m
.87345 .45712 L
s
.87352 .45196 m
.87352 .45196 L
s
.8736 .45324 m
.8736 .45324 L
s
.87367 .45313 m
.87367 .45313 L
s
.87375 .45677 m
.87375 .45677 L
s
.87382 .46323 m
.87382 .46323 L
s
.8739 .46699 m
.8739 .46699 L
s
.87397 .46428 m
.87397 .46428 L
s
.87404 .46499 m
.87404 .46499 L
s
.87411 .46875 m
.87411 .46875 L
s
.87419 .47263 m
.87419 .47263 L
s
.87427 .47169 m
.87427 .47169 L
s
.87434 .47051 m
.87434 .47051 L
s
.87441 .4738 m
.87441 .4738 L
s
.87449 .47826 m
.87449 .47826 L
s
.87456 .4799 m
.87456 .4799 L
s
.87464 .47544 m
.87464 .47544 L
s
.87471 .47533 m
.87471 .47533 L
s
.87479 .4745 m
.87479 .4745 L
s
.87486 .47228 m
.87486 .47228 L
s
.87493 .47169 m
.87493 .47169 L
s
.87501 .46945 m
.87501 .46945 L
s
.87508 .46769 m
.87508 .46769 L
s
.87516 .46898 m
.87516 .46898 L
s
.87523 .46393 m
.87523 .46393 L
s
.87531 .46006 m
.87531 .46006 L
s
.87538 .4617 m
.87538 .4617 L
s
.87546 .46463 m
.87546 .46463 L
s
.87553 .45794 m
.87553 .45794 L
s
.8756 .457 m
.8756 .457 L
s
.87567 .45595 m
.87567 .45595 L
s
.87575 .45124 m
.87575 .45124 L
s
.87582 .44749 m
.87582 .44749 L
s
.8759 .44749 m
.8759 .44749 L
s
.87597 .45266 m
.87597 .45266 L
s
.87605 .45723 m
.87605 .45723 L
s
.87612 .45525 m
.87612 .45525 L
s
.8762 .45324 m
.8762 .45324 L
s
.87627 .45336 m
.87627 .45336 L
s
.87635 .45489 m
.87635 .45489 L
s
.87642 .45735 m
.87642 .45735 L
s
.87649 .46017 m
.87649 .46017 L
s
.87657 .46757 m
.87657 .46757 L
s
.87664 .46887 m
.87664 .46887 L
s
.87672 .47309 m
.87672 .47309 L
s
.87679 .47415 m
.87679 .47415 L
s
.87687 .4745 m
.87687 .4745 L
s
.87694 .46969 m
.87694 .46969 L
s
.87702 .4644 m
.87702 .4644 L
s
.87709 .46076 m
.87709 .46076 L
s
.87717 .4583 m
.87717 .4583 L
s
.87724 .45572 m
.87724 .45572 L
s
.87731 .45677 m
.87731 .45677 L
s
.87738 .45077 m
.87738 .45077 L
s
.87746 .45383 m
.87746 .45383 L
s
.87753 .45324 m
.87753 .45324 L
s
.87761 .44984 m
.87761 .44984 L
s
.87768 .44538 m
.87768 .44538 L
s
.87776 .44585 m
.87776 .44585 L
s
.87783 .45008 m
.87783 .45008 L
s
.87791 .44596 m
.87791 .44596 L
s
.87799 .44021 m
.87799 .44021 L
s
.87805 .44162 m
.87805 .44162 L
s
.87813 .43786 m
.87813 .43786 L
s
.8782 .43775 m
.8782 .43775 L
s
.87828 .44314 m
.87828 .44314 L
s
.87835 .44585 m
.87835 .44585 L
s
.87843 .4536 m
.87843 .4536 L
s
.8785 .45525 m
.8785 .45525 L
s
.87858 .45478 m
.87858 .45478 L
s
.87865 .45101 m
.87865 .45101 L
s
.87873 .44902 m
.87873 .44902 L
s
.8788 .44491 m
.8788 .44491 L
s
.87887 .44937 m
.87887 .44937 L
s
.87894 .45501 m
.87894 .45501 L
s
.87902 .45149 m
.87902 .45149 L
s
.87909 .45336 m
.87909 .45336 L
s
.87917 .45266 m
.87917 .45266 L
s
.87924 .45196 m
.87924 .45196 L
s
.87932 .44961 m
.87932 .44961 L
s
.87939 .45595 m
.87939 .45595 L
s
.87947 .45407 m
.87947 .45407 L
s
.87955 .45219 m
.87955 .45219 L
s
.87962 .44961 m
.87962 .44961 L
s
.87969 .44737 m
.87969 .44737 L
s
.87976 .44996 m
.87976 .44996 L
s
.87984 .44867 m
.87984 .44867 L
s
.87991 .44702 m
.87991 .44702 L
s
.87999 .45066 m
.87999 .45066 L
s
.88006 .45101 m
.88006 .45101 L
s
.88014 .45383 m
.88014 .45383 L
s
.88021 .45735 m
.88021 .45735 L
s
.88029 .44937 m
.88029 .44937 L
s
.88036 .45054 m
.88036 .45054 L
s
.88043 .45653 m
.88043 .45653 L
s
.8805 .4583 m
.8805 .4583 L
s
.88058 .46159 m
.88058 .46159 L
s
.88065 .45618 m
.88065 .45618 L
s
.88073 .46523 m
.88073 .46523 L
s
.8808 .46722 m
.8808 .46722 L
s
.88088 .4698 m
.88088 .4698 L
s
.88095 .4738 m
.88095 .4738 L
s
.88102 .48471 m
.88102 .48471 L
s
.8811 .48707 m
.8811 .48707 L
s
.88118 .48812 m
.88118 .48812 L
s
.88125 .48648 m
.88125 .48648 L
s
.88132 .49 m
.88132 .49 L
s
.8814 .49047 m
.8814 .49047 L
s
.88147 .49071 m
.88147 .49071 L
s
.88155 .49329 m
.88155 .49329 L
s
.88162 .48789 m
.88162 .48789 L
s
.8817 .48119 m
.8817 .48119 L
s
.88177 .47533 m
.88177 .47533 L
s
.88184 .48014 m
.88184 .48014 L
s
.88192 .47955 m
.88192 .47955 L
s
.882 .48343 m
.882 .48343 L
s
.88207 .48284 m
.88207 .48284 L
s
.88214 .494 m
.88214 .494 L
s
.88221 .49857 m
.88221 .49857 L
s
.88229 .49811 m
.88229 .49811 L
s
.88236 .49682 m
.88236 .49682 L
s
.88244 .49283 m
.88244 .49283 L
s
.88251 .48518 m
.88251 .48518 L
s
.88259 .48483 m
.88259 .48483 L
s
.88266 .48625 m
.88266 .48625 L
s
.88273 .47638 m
.88273 .47638 L
s
.88281 .47767 m
.88281 .47767 L
s
.88288 .47662 m
.88288 .47662 L
s
.88296 .47591 m
.88296 .47591 L
s
.88303 .47873 m
.88303 .47873 L
s
.88311 .47861 m
.88311 .47861 L
s
.88318 .48084 m
.88318 .48084 L
s
.88326 .48695 m
.88326 .48695 L
s
.88333 .4832 m
.88333 .4832 L
s
.8834 .4839 m
.8834 .4839 L
s
.88347 .48331 m
.88347 .48331 L
s
.88355 .47638 m
.88355 .47638 L
s
.88363 .47744 m
.88363 .47744 L
s
.8837 .47897 m
.8837 .47897 L
s
.88377 .47979 m
.88377 .47979 L
s
.88385 .48695 m
.88385 .48695 L
s
.88392 .48859 m
.88392 .48859 L
s
.884 .48695 m
.884 .48695 L
s
.88407 .48578 m
.88407 .48578 L
s
.88415 .48355 m
.88415 .48355 L
s
.88422 .47685 m
.88422 .47685 L
s
.88429 .47109 m
.88429 .47109 L
s
.88437 .47204 m
.88437 .47204 L
s
.88444 .47321 m
.88444 .47321 L
s
.88452 .47627 m
.88452 .47627 L
s
.88459 .47673 m
.88459 .47673 L
s
.88467 .4792 m
.88467 .4792 L
s
.88474 .47544 m
.88474 .47544 L
s
.88482 .4832 m
.88482 .4832 L
s
.88489 .48742 m
.88489 .48742 L
s
.88497 .49059 m
.88497 .49059 L
s
.88504 .49259 m
.88504 .49259 L
s
.88511 .48919 m
.88511 .48919 L
s
.88518 .49588 m
.88518 .49588 L
s
.88526 .49388 m
.88526 .49388 L
s
.88533 .4893 m
.88533 .4893 L
s
.88541 .49353 m
.88541 .49353 L
s
.88548 .48977 m
.88548 .48977 L
s
.88556 .48178 m
.88556 .48178 L
s
.88563 .47944 m
.88563 .47944 L
s
.88571 .47438 m
.88571 .47438 L
s
.88579 .47263 m
.88579 .47263 L
s
.88585 .4691 m
.88585 .4691 L
s
.88593 .46734 m
.88593 .46734 L
s
.886 .46393 m
.886 .46393 L
s
.88608 .46992 m
.88608 .46992 L
s
.88615 .46945 m
.88615 .46945 L
s
.88623 .47556 m
.88623 .47556 L
s
.8863 .47286 m
.8863 .47286 L
s
.88638 .47216 m
.88638 .47216 L
s
.88645 .47756 m
.88645 .47756 L
s
.88653 .47591 m
.88653 .47591 L
s
.8866 .48471 m
.8866 .48471 L
s
.88667 .48683 m
.88667 .48683 L
s
.88674 .48518 m
.88674 .48518 L
s
.88682 .48273 m
.88682 .48273 L
s
.88689 .47897 m
.88689 .47897 L
s
.88697 .48273 m
.88697 .48273 L
s
.88704 .48695 m
.88704 .48695 L
s
.88712 .48625 m
.88712 .48625 L
s
.88719 .47685 m
.88719 .47685 L
s
.88727 .48084 m
.88727 .48084 L
s
.88735 .48273 m
.88735 .48273 L
s
.88742 .48518 m
.88742 .48518 L
s
.88749 .49082 m
.88749 .49082 L
s
.88756 .49283 m
.88756 .49283 L
s
.88764 .48848 m
.88764 .48848 L
s
.88771 .49 m
.88771 .49 L
s
.88779 .48824 m
.88779 .48824 L
s
.88786 .48518 m
.88786 .48518 L
s
.88794 .48155 m
.88794 .48155 L
s
.88801 .48108 m
.88801 .48108 L
s
.88809 .48131 m
.88809 .48131 L
s
.88816 .48343 m
.88816 .48343 L
s
.88824 .48966 m
.88824 .48966 L
s
.8883 .48812 m
.8883 .48812 L
s
.88838 .48789 m
.88838 .48789 L
s
.88845 .48543 m
.88845 .48543 L
s
.88853 .48707 m
.88853 .48707 L
s
.8886 .4859 m
.8886 .4859 L
s
.88868 .48919 m
.88868 .48919 L
s
.88875 .49236 m
.88875 .49236 L
s
.88883 .49071 m
.88883 .49071 L
s
.88891 .48812 m
.88891 .48812 L
s
.88898 .48296 m
.88898 .48296 L
s
.88905 .48566 m
.88905 .48566 L
s
.88912 .48402 m
.88912 .48402 L
s
.8892 .49224 m
.8892 .49224 L
s
.88927 .49224 m
.88927 .49224 L
s
.88935 .49224 m
.88935 .49224 L
s
.88942 .49705 m
.88942 .49705 L
s
.8895 .4974 m
.8895 .4974 L
s
.88957 .49164 m
.88957 .49164 L
s
.88964 .48977 m
.88964 .48977 L
s
.88972 .48648 m
.88972 .48648 L
s
.8898 .48554 m
.8898 .48554 L
s
.88987 .48754 m
.88987 .48754 L
s
.88994 .49129 m
.88994 .49129 L
s
.89001 .49458 m
.89001 .49458 L
s
.89009 .49611 m
.89009 .49611 L
s
.89016 .49341 m
.89016 .49341 L
s
.89024 .49176 m
.89024 .49176 L
s
.89031 .48672 m
.89031 .48672 L
s
.89039 .48777 m
.89039 .48777 L
s
.89046 .49 m
.89046 .49 L
s
.89054 .49236 m
.89054 .49236 L
s
.89062 .49106 m
.89062 .49106 L
s
.89068 .49118 m
.89068 .49118 L
s
.89076 .49388 m
.89076 .49388 L
s
.89083 .50186 m
.89083 .50186 L
s
.89091 .5048 m
.89091 .5048 L
s
.89098 .50011 m
.89098 .50011 L
s
.89106 .50633 m
.89106 .50633 L
s
.89113 .50163 m
.89113 .50163 L
s
.89121 .50128 m
.89121 .50128 L
s
.89127 .5048 m
.89127 .5048 L
s
.89135 .5048 m
.89135 .5048 L
s
.89143 .49952 m
.89143 .49952 L
s
.8915 .49294 m
.8915 .49294 L
s
.89157 .4859 m
.89157 .4859 L
s
.89165 .4873 m
.89165 .4873 L
s
.89172 .48636 m
.89172 .48636 L
s
.8918 .48613 m
.8918 .48613 L
s
.89187 .48977 m
.89187 .48977 L
s
.89195 .48777 m
.89195 .48777 L
s
.89202 .49188 m
.89202 .49188 L
s
.89209 .49283 m
.89209 .49283 L
s
.89217 .49717 m
.89217 .49717 L
s
.89225 .49576 m
.89225 .49576 L
s
.89232 .49447 m
.89232 .49447 L
s
.89239 .49353 m
.89239 .49353 L
s
.89247 .494 m
.89247 .494 L
s
.89254 .49529 m
.89254 .49529 L
s
.89262 .50433 m
.89262 .50433 L
s
.89269 .50363 m
.89269 .50363 L
s
.89277 .5061 m
.89277 .5061 L
s
.89284 .49564 m
.89284 .49564 L
s
.89291 .49164 m
.89291 .49164 L
s
.89298 .49 m
.89298 .49 L
s
.89306 .49106 m
.89306 .49106 L
s
.89313 .49576 m
.89313 .49576 L
s
.89321 .49 m
.89321 .49 L
s
.89328 .49435 m
.89328 .49435 L
s
.89336 .4994 m
.89336 .4994 L
s
.89343 .5055 m
.89343 .5055 L
s
.89351 .49893 m
.89351 .49893 L
s
.89359 .50246 m
.89359 .50246 L
s
.89365 .50257 m
.89365 .50257 L
s
.89373 .4994 m
.89373 .4994 L
s
.8938 .49376 m
.8938 .49376 L
s
.89388 .48872 m
.89388 .48872 L
s
.89395 .48942 m
.89395 .48942 L
s
.89403 .4866 m
.89403 .4866 L
s
.8941 .48378 m
.8941 .48378 L
s
.89418 .48131 m
.89418 .48131 L
s
.89425 .47802 m
.89425 .47802 L
s
.89433 .47709 m
.89433 .47709 L
s
.8944 .4799 m
.8944 .4799 L
s
.89447 .47591 m
.89447 .47591 L
s
.89454 .47591 m
.89454 .47591 L
s
.89462 .47615 m
.89462 .47615 L
s
.89469 .46934 m
.89469 .46934 L
s
.89477 .47239 m
.89477 .47239 L
s
.89484 .4738 m
.89484 .4738 L
s
.89492 .48143 m
.89492 .48143 L
s
.89499 .48061 m
.89499 .48061 L
s
.89507 .48084 m
.89507 .48084 L
s
.89515 .48178 m
.89515 .48178 L
s
.89522 .48789 m
.89522 .48789 L
s
.89529 .49024 m
.89529 .49024 L
s
.89536 .49365 m
.89536 .49365 L
s
.89544 .49224 m
.89544 .49224 L
s
.89551 .49388 m
.89551 .49388 L
s
.89559 .49764 m
.89559 .49764 L
s
.89566 .49012 m
.89566 .49012 L
s
.89574 .49752 m
.89574 .49752 L
s
.89581 .4947 m
.89581 .4947 L
s
.89589 .4947 m
.89589 .4947 L
s
.89596 .49893 m
.89596 .49893 L
s
.89604 .50034 m
.89604 .50034 L
s
.8961 .49882 m
.8961 .49882 L
s
.89618 .49353 m
.89618 .49353 L
s
.89625 .49458 m
.89625 .49458 L
s
.89633 .48483 m
.89633 .48483 L
s
.8964 .48954 m
.8964 .48954 L
s
.89648 .49318 m
.89648 .49318 L
s
.89655 .49071 m
.89655 .49071 L
s
.89663 .49752 m
.89663 .49752 L
s
.89671 .50293 m
.89671 .50293 L
s
.89678 .51114 m
.89678 .51114 L
s
.89685 .51467 m
.89685 .51467 L
s
.89692 .51114 m
.89692 .51114 L
s
.897 .51678 m
.897 .51678 L
s
.89707 .51467 m
.89707 .51467 L
s
.89715 .51302 m
.89715 .51302 L
s
.89722 .51502 m
.89722 .51502 L
s
.8973 .50962 m
.8973 .50962 L
s
.89737 .50692 m
.89737 .50692 L
s
.89745 .50715 m
.89745 .50715 L
s
.89752 .50903 m
.89752 .50903 L
s
.8976 .50927 m
.8976 .50927 L
s
.89767 .51349 m
.89767 .51349 L
s
.89774 .5075 m
.89774 .5075 L
s
.89781 .50692 m
.89781 .50692 L
s
.89789 .5082 m
.89789 .5082 L
s
.89796 .50222 m
.89796 .50222 L
s
.89804 .5061 m
.89804 .5061 L
s
.89811 .50257 m
.89811 .50257 L
s
.89819 .50492 m
.89819 .50492 L
s
.89826 .50727 m
.89826 .50727 L
s
.89834 .50575 m
.89834 .50575 L
s
.89842 .50962 m
.89842 .50962 L
s
.89848 .5149 m
.89848 .5149 L
s
.89856 .51984 m
.89856 .51984 L
s
.89863 .51714 m
.89863 .51714 L
s
.89871 .5223 m
.89871 .5223 L
s
.89878 .51807 m
.89878 .51807 L
s
.89886 .51737 m
.89886 .51737 L
s
.89893 .51467 m
.89893 .51467 L
s
.89901 .51408 m
.89901 .51408 L
s
.89908 .51513 m
.89908 .51513 L
s
.89916 .51443 m
.89916 .51443 L
s
.89923 .51995 m
.89923 .51995 L
s
.8993 .5122 m
.8993 .5122 L
s
.89937 .50939 m
.89937 .50939 L
s
.89945 .50738 m
.89945 .50738 L
s
.89952 .51244 m
.89952 .51244 L
s
.8996 .51572 m
.8996 .51572 L
s
.89967 .51737 m
.89967 .51737 L
s
.89975 .51502 m
.89975 .51502 L
s
.89982 .52325 m
.89982 .52325 L
s
.89989 .52301 m
.89989 .52301 L
s
.89997 .51513 m
.89997 .51513 L
s
.90005 .51972 m
.90005 .51972 L
s
.90012 .51901 m
.90012 .51901 L
s
.90019 .52007 m
.90019 .52007 L
s
.90027 .51702 m
.90027 .51702 L
s
.90034 .52136 m
.90034 .52136 L
s
.90042 .52124 m
.90042 .52124 L
s
.90049 .52266 m
.90049 .52266 L
s
.90057 .51502 m
.90057 .51502 L
s
.90064 .52077 m
.90064 .52077 L
s
.90071 .5169 m
.90071 .5169 L
s
.90079 .51667 m
.90079 .51667 L
s
.90086 .51326 m
.90086 .51326 L
s
.90093 .51044 m
.90093 .51044 L
s
.90101 .5142 m
.90101 .5142 L
s
.90108 .51244 m
.90108 .51244 L
s
.90116 .50997 m
.90116 .50997 L
s
.90123 .51079 m
.90123 .51079 L
s
.90131 .5095 m
.90131 .5095 L
s
.90139 .50774 m
.90139 .50774 L
s
.90145 .50069 m
.90145 .50069 L
s
.90153 .49494 m
.90153 .49494 L
s
.9016 .50316 m
.9016 .50316 L
s
.90168 .49987 m
.90168 .49987 L
s
.90175 .50504 m
.90175 .50504 L
s
.90183 .50622 m
.90183 .50622 L
s
.9019 .51173 m
.9019 .51173 L
s
.90198 .51925 m
.90198 .51925 L
s
.90205 .5162 m
.90205 .5162 L
s
.90213 .52171 m
.90213 .52171 L
s
.9022 .51843 m
.9022 .51843 L
s
.90227 .51937 m
.90227 .51937 L
s
.90234 .5149 m
.90234 .5149 L
s
.90242 .51196 m
.90242 .51196 L
s
.9025 .5082 m
.9025 .5082 L
s
.90257 .51091 m
.90257 .51091 L
s
.90264 .50832 m
.90264 .50832 L
s
.90272 .50515 m
.90272 .50515 L
s
.90279 .50304 m
.90279 .50304 L
s
.90287 .50304 m
.90287 .50304 L
s
.90295 .50468 m
.90295 .50468 L
s
.90302 .50669 m
.90302 .50669 L
s
.90309 .50915 m
.90309 .50915 L
s
.90316 .51819 m
.90316 .51819 L
s
.90324 .51784 m
.90324 .51784 L
s
.90331 .51256 m
.90331 .51256 L
s
.90339 .51208 m
.90339 .51208 L
s
.90346 .50774 m
.90346 .50774 L
s
.90354 .51056 m
.90354 .51056 L
s
.90361 .51513 m
.90361 .51513 L
s
.90369 .51208 m
.90369 .51208 L
s
.90376 .51302 m
.90376 .51302 L
s
.90384 .51056 m
.90384 .51056 L
s
.9039 .51256 m
.9039 .51256 L
s
.90398 .51056 m
.90398 .51056 L
s
.90405 .51267 m
.90405 .51267 L
s
.90413 .51725 m
.90413 .51725 L
s
.9042 .52348 m
.9042 .52348 L
s
.90428 .52523 m
.90428 .52523 L
s
.90435 .52794 m
.90435 .52794 L
s
.90443 .52759 m
.90443 .52759 L
s
.90451 .53029 m
.90451 .53029 L
s
.90458 .53545 m
.90458 .53545 L
s
.90465 .5425 m
.90465 .5425 L
s
.90472 .54438 m
.90472 .54438 L
s
.9048 .54438 m
.9048 .54438 L
s
.90487 .55225 m
.90487 .55225 L
s
.90495 .55389 m
.90495 .55389 L
s
.90502 .55436 m
.90502 .55436 L
s
.9051 .5499 m
.9051 .5499 L
s
.90517 .5526 m
.90517 .5526 L
s
.90525 .55413 m
.90525 .55413 L
s
.90532 .55624 m
.90532 .55624 L
s
.9054 .54802 m
.9054 .54802 L
s
.90547 .54027 m
.90547 .54027 L
s
.90554 .53909 m
.90554 .53909 L
s
.90561 .54238 m
.90561 .54238 L
s
.90569 .54333 m
.90569 .54333 L
s
.90576 .55014 m
.90576 .55014 L
s
.90584 .54415 m
.90584 .54415 L
s
.90591 .5425 m
.90591 .5425 L
s
.90599 .54191 m
.90599 .54191 L
s
.90606 .54273 m
.90606 .54273 L
s
.90614 .53698 m
.90614 .53698 L
s
.90622 .53933 m
.90622 .53933 L
s
.90628 .53545 m
.90628 .53545 L
s
.90636 .53733 m
.90636 .53733 L
s
.90643 .54191 m
.90643 .54191 L
s
.90651 .54144 m
.90651 .54144 L
s
.90658 .53487 m
.90658 .53487 L
s
.90666 .53651 m
.90666 .53651 L
s
.90673 .53381 m
.90673 .53381 L
s
.90681 .53733 m
.90681 .53733 L
s
.90688 .54238 m
.90688 .54238 L
s
.90696 .53816 m
.90696 .53816 L
s
.90703 .54132 m
.90703 .54132 L
s
.9071 .53557 m
.9071 .53557 L
s
.90717 .54261 m
.90717 .54261 L
s
.90725 .54191 m
.90725 .54191 L
s
.90732 .54179 m
.90732 .54179 L
s
.9074 .53969 m
.9074 .53969 L
s
.90747 .53111 m
.90747 .53111 L
s
.90755 .5297 m
.90755 .5297 L
s
.90762 .52829 m
.90762 .52829 L
s
.90769 .53064 m
.90769 .53064 L
s
.90777 .52888 m
.90777 .52888 L
s
.90785 .52923 m
.90785 .52923 L
s
.90792 .52947 m
.90792 .52947 L
s
.90799 .53064 m
.90799 .53064 L
s
.90807 .52441 m
.90807 .52441 L
s
.90814 .52336 m
.90814 .52336 L
s
.90822 .52348 m
.90822 .52348 L
s
.90829 .52336 m
.90829 .52336 L
s
.90837 .52841 m
.90837 .52841 L
s
.90844 .52371 m
.90844 .52371 L
s
.90851 .52406 m
.90851 .52406 L
s
.90859 .52218 m
.90859 .52218 L
s
.90867 .52594 m
.90867 .52594 L
s
.90873 .52383 m
.90873 .52383 L
s
.90881 .52278 m
.90881 .52278 L
s
.90888 .52523 m
.90888 .52523 L
s
.90896 .52677 m
.90896 .52677 L
s
.90903 .53099 m
.90903 .53099 L
s
.90911 .53017 m
.90911 .53017 L
s
.90919 .52994 m
.90919 .52994 L
s
.90925 .52935 m
.90925 .52935 L
s
.90933 .54039 m
.90933 .54039 L
s
.9094 .54226 m
.9094 .54226 L
s
.90948 .54638 m
.90948 .54638 L
s
.90955 .55014 m
.90955 .55014 L
s
.90963 .5546 m
.90963 .5546 L
s
.9097 .55319 m
.9097 .55319 L
s
.90978 .55119 m
.90978 .55119 L
s
.90985 .54837 m
.90985 .54837 L
s
.90993 .54203 m
.90993 .54203 L
s
.91 .54051 m
.91 .54051 L
s
.91007 .53334 m
.91007 .53334 L
s
.91014 .54074 m
.91014 .54074 L
s
.91022 .54074 m
.91022 .54074 L
s
.9103 .5438 m
.9103 .5438 L
s
.91037 .54415 m
.91037 .54415 L
s
.91044 .54191 m
.91044 .54191 L
s
.91052 .54309 m
.91052 .54309 L
s
.91059 .54884 m
.91059 .54884 L
s
.91067 .54966 m
.91067 .54966 L
s
.91075 .54954 m
.91075 .54954 L
s
.91082 .54979 m
.91082 .54979 L
s
.91089 .54638 m
.91089 .54638 L
s
.91096 .54285 m
.91096 .54285 L
s
.91104 .53898 m
.91104 .53898 L
s
.91111 .53839 m
.91111 .53839 L
s
.91119 .53604 m
.91119 .53604 L
s
.91126 .53839 m
.91126 .53839 L
s
.91134 .52958 m
.91134 .52958 L
s
.91141 .53428 m
.91141 .53428 L
s
.91149 .53698 m
.91149 .53698 L
s
.91156 .53757 m
.91156 .53757 L
s
.91164 .53522 m
.91164 .53522 L
s
.9117 .53005 m
.9117 .53005 L
s
.91178 .52453 m
.91178 .52453 L
s
.91185 .5257 m
.91185 .5257 L
s
.91193 .52453 m
.91193 .52453 L
s
.912 .52806 m
.912 .52806 L
s
.91208 .52899 m
.91208 .52899 L
s
.91215 .52759 m
.91215 .52759 L
s
.91223 .5263 m
.91223 .5263 L
s
.91231 .52253 m
.91231 .52253 L
s
.91238 .51796 m
.91238 .51796 L
s
.91245 .52817 m
.91245 .52817 L
s
.91252 .53111 m
.91252 .53111 L
s
.9126 .53146 m
.9126 .53146 L
s
.91267 .52911 m
.91267 .52911 L
s
.91275 .53111 m
.91275 .53111 L
s
.91282 .54004 m
.91282 .54004 L
s
.9129 .53557 m
.9129 .53557 L
s
.91297 .53886 m
.91297 .53886 L
s
.91305 .5465 m
.91305 .5465 L
s
.91312 .54814 m
.91312 .54814 L
s
.9132 .54344 m
.9132 .54344 L
s
.91327 .54426 m
.91327 .54426 L
s
.91334 .54755 m
.91334 .54755 L
s
.91341 .54861 m
.91341 .54861 L
s
.91349 .54943 m
.91349 .54943 L
s
.91356 .55061 m
.91356 .55061 L
s
.91364 .54825 m
.91364 .54825 L
s
.91371 .5452 m
.91371 .5452 L
s
.91379 .54966 m
.91379 .54966 L
s
.91387 .54872 m
.91387 .54872 L
s
.91394 .54931 m
.91394 .54931 L
s
.91402 .55049 m
.91402 .55049 L
s
.91408 .54954 m
.91408 .54954 L
s
.91416 .55354 m
.91416 .55354 L
s
.91423 .55166 m
.91423 .55166 L
s
.91431 .55037 m
.91431 .55037 L
s
.91438 .54685 m
.91438 .54685 L
s
.91446 .55096 m
.91446 .55096 L
s
.91453 .55037 m
.91453 .55037 L
s
.91461 .55425 m
.91461 .55425 L
s
.91468 .55789 m
.91468 .55789 L
s
.91476 .55483 m
.91476 .55483 L
s
.91483 .55742 m
.91483 .55742 L
s
.9149 .55953 m
.9149 .55953 L
s
.91497 .55518 m
.91497 .55518 L
s
.91505 .54872 m
.91505 .54872 L
s
.91512 .54273 m
.91512 .54273 L
s
.9152 .53733 m
.9152 .53733 L
s
.91527 .53111 m
.91527 .53111 L
s
.91535 .53111 m
.91535 .53111 L
s
.91542 .52735 m
.91542 .52735 L
s
.9155 .53428 m
.9155 .53428 L
s
.91558 .52852 m
.91558 .52852 L
s
.91565 .53041 m
.91565 .53041 L
s
.91572 .53792 m
.91572 .53792 L
s
.91579 .53557 m
.91579 .53557 L
s
.91587 .53487 m
.91587 .53487 L
s
.91594 .53099 m
.91594 .53099 L
s
.91602 .53334 m
.91602 .53334 L
s
.91609 .53275 m
.91609 .53275 L
s
.91617 .53169 m
.91617 .53169 L
s
.91624 .53522 m
.91624 .53522 L
s
.91631 .53745 m
.91631 .53745 L
s
.91639 .53909 m
.91639 .53909 L
s
.91647 .53522 m
.91647 .53522 L
s
.91653 .53134 m
.91653 .53134 L
s
.91661 .52782 m
.91661 .52782 L
s
.91668 .52594 m
.91668 .52594 L
s
.91676 .52806 m
.91676 .52806 L
s
.91683 .52476 m
.91683 .52476 L
s
.91691 .51937 m
.91691 .51937 L
s
.91699 .51749 m
.91699 .51749 L
s
.91705 .51972 m
.91705 .51972 L
s
.91713 .51361 m
.91713 .51361 L
s
.91721 .51396 m
.91721 .51396 L
s
.91728 .51572 m
.91728 .51572 L
s
.91735 .50867 m
.91735 .50867 L
s
.91743 .51196 m
.91743 .51196 L
s
.9175 .51667 m
.9175 .51667 L
s
.91758 .51678 m
.91758 .51678 L
s
.91765 .52183 m
.91765 .52183 L
s
.91773 .5243 m
.91773 .5243 L
s
.9178 .52101 m
.9178 .52101 L
s
.91787 .52253 m
.91787 .52253 L
s
.91794 .52136 m
.91794 .52136 L
s
.91802 .52101 m
.91802 .52101 L
s
.9181 .52289 m
.9181 .52289 L
s
.91817 .52171 m
.91817 .52171 L
s
.91824 .51349 m
.91824 .51349 L
s
.91832 .50598 m
.91832 .50598 L
s
.91839 .51021 m
.91839 .51021 L
s
.91847 .5048 m
.91847 .5048 L
s
.91855 .50879 m
.91855 .50879 L
s
.91862 .50797 m
.91862 .50797 L
s
.91869 .50903 m
.91869 .50903 L
s
.91876 .50351 m
.91876 .50351 L
s
.91884 .50116 m
.91884 .50116 L
s
.91891 .50445 m
.91891 .50445 L
s
.91899 .5041 m
.91899 .5041 L
s
.91906 .51021 m
.91906 .51021 L
s
.91914 .5156 m
.91914 .5156 L
s
.91921 .51443 m
.91921 .51443 L
s
.91929 .51843 m
.91929 .51843 L
s
.91936 .51608 m
.91936 .51608 L
s
.91944 .51761 m
.91944 .51761 L
s
.9195 .52371 m
.9195 .52371 L
s
.91958 .52852 m
.91958 .52852 L
s
.91965 .52782 m
.91965 .52782 L
s
.91973 .53299 m
.91973 .53299 L
s
.9198 .53146 m
.9198 .53146 L
s
.91988 .52712 m
.91988 .52712 L
s
.91995 .52242 m
.91995 .52242 L
s
.92003 .5263 m
.92003 .5263 L
s
.92011 .53358 m
.92011 .53358 L
s
.92018 .53064 m
.92018 .53064 L
s
.92025 .53041 m
.92025 .53041 L
s
.92032 .53064 m
.92032 .53064 L
s
.9204 .53099 m
.9204 .53099 L
s
.92047 .5378 m
.92047 .5378 L
s
.92055 .53921 m
.92055 .53921 L
s
.92062 .53792 m
.92062 .53792 L
s
.9207 .54027 m
.9207 .54027 L
s
.92077 .53981 m
.92077 .53981 L
s
.92085 .53698 m
.92085 .53698 L
s
.92092 .53722 m
.92092 .53722 L
s
.921 .53134 m
.921 .53134 L
s
.92107 .53346 m
.92107 .53346 L
s
.92114 .53111 m
.92114 .53111 L
s
.92121 .53005 m
.92121 .53005 L
s
.92129 .52817 m
.92129 .52817 L
s
.92136 .52724 m
.92136 .52724 L
s
.92144 .52735 m
.92144 .52735 L
s
.92151 .52806 m
.92151 .52806 L
s
.92159 .53005 m
.92159 .53005 L
s
.92167 .53393 m
.92167 .53393 L
s
.92174 .53216 m
.92174 .53216 L
s
.92182 .53499 m
.92182 .53499 L
s
.92188 .53393 m
.92188 .53393 L
s
.92196 .53475 m
.92196 .53475 L
s
.92203 .53698 m
.92203 .53698 L
s
.92211 .53839 m
.92211 .53839 L
s
.92218 .54144 m
.92218 .54144 L
s
.92226 .53804 m
.92226 .53804 L
s
.92233 .5351 m
.92233 .5351 L
s
.92241 .5351 m
.92241 .5351 L
s
.92248 .53181 m
.92248 .53181 L
s
.92256 .53181 m
.92256 .53181 L
s
.92263 .52923 m
.92263 .52923 L
s
.9227 .53628 m
.9227 .53628 L
s
.92277 .54156 m
.92277 .54156 L
s
.92285 .54063 m
.92285 .54063 L
s
.92292 .5425 m
.92292 .5425 L
s
.923 .54238 m
.923 .54238 L
s
.92307 .53862 m
.92307 .53862 L
s
.92315 .54415 m
.92315 .54415 L
s
.92322 .53698 m
.92322 .53698 L
s
.9233 .5351 m
.9233 .5351 L
s
.92338 .53651 m
.92338 .53651 L
s
.92345 .53827 m
.92345 .53827 L
s
.92352 .54039 m
.92352 .54039 L
s
.92359 .53851 m
.92359 .53851 L
s
.92367 .53874 m
.92367 .53874 L
s
.92374 .54051 m
.92374 .54051 L
s
.92382 .53663 m
.92382 .53663 L
s
.92389 .53417 m
.92389 .53417 L
s
.92397 .53428 m
.92397 .53428 L
s
.92404 .5344 m
.92404 .5344 L
s
.92412 .53334 m
.92412 .53334 L
s
.92419 .53064 m
.92419 .53064 L
s
.92427 .53534 m
.92427 .53534 L
s
.92433 .53158 m
.92433 .53158 L
s
.92441 .53041 m
.92441 .53041 L
s
.92448 .52935 m
.92448 .52935 L
s
.92456 .53169 m
.92456 .53169 L
s
.92463 .53181 m
.92463 .53181 L
s
.92471 .52594 m
.92471 .52594 L
s
.92479 .52124 m
.92479 .52124 L
s
.92485 .52371 m
.92485 .52371 L
s
.92493 .52512 m
.92493 .52512 L
s
.92501 .52418 m
.92501 .52418 L
s
.92508 .52958 m
.92508 .52958 L
s
.92515 .53687 m
.92515 .53687 L
s
.92523 .54168 m
.92523 .54168 L
s
.9253 .5445 m
.9253 .5445 L
s
.92538 .54074 m
.92538 .54074 L
s
.92545 .53346 m
.92545 .53346 L
s
.92553 .5351 m
.92553 .5351 L
s
.9256 .53534 m
.9256 .53534 L
s
.92567 .53323 m
.92567 .53323 L
s
.92575 .53839 m
.92575 .53839 L
s
.92583 .54368 m
.92583 .54368 L
s
.9259 .53981 m
.9259 .53981 L
s
.92597 .54109 m
.92597 .54109 L
s
.92604 .54074 m
.92604 .54074 L
s
.92612 .53675 m
.92612 .53675 L
s
.92619 .54051 m
.92619 .54051 L
s
.92627 .53675 m
.92627 .53675 L
s
.92635 .53816 m
.92635 .53816 L
s
.92642 .53687 m
.92642 .53687 L
s
.92649 .53475 m
.92649 .53475 L
s
.92656 .54261 m
.92656 .54261 L
s
.92664 .54779 m
.92664 .54779 L
s
.92671 .54767 m
.92671 .54767 L
s
.92679 .55014 m
.92679 .55014 L
s
.92686 .55719 m
.92686 .55719 L
s
.92694 .556 m
.92694 .556 L
s
.92701 .55647 m
.92701 .55647 L
s
.92709 .55929 m
.92709 .55929 L
s
.92716 .55719 m
.92716 .55719 L
s
.92724 .55413 m
.92724 .55413 L
s
.9273 .54919 m
.9273 .54919 L
s
.92738 .55166 m
.92738 .55166 L
s
.92746 .55143 m
.92746 .55143 L
s
.92753 .5519 m
.92753 .5519 L
s
.9276 .54931 m
.9276 .54931 L
s
.92768 .55271 m
.92768 .55271 L
s
.92775 .54544 m
.92775 .54544 L
s
.92783 .55131 m
.92783 .55131 L
s
.92791 .55331 m
.92791 .55331 L
s
.92798 .55354 m
.92798 .55354 L
s
.92805 .5519 m
.92805 .5519 L
s
.92812 .55271 m
.92812 .55271 L
s
.9282 .54708 m
.9282 .54708 L
s
.92827 .54685 m
.92827 .54685 L
s
.92835 .54743 m
.92835 .54743 L
s
.92842 .54109 m
.92842 .54109 L
s
.9285 .54344 m
.9285 .54344 L
s
.92857 .54333 m
.92857 .54333 L
s
.92865 .54168 m
.92865 .54168 L
s
.92872 .54097 m
.92872 .54097 L
s
.9288 .54473 m
.9288 .54473 L
s
.92887 .54708 m
.92887 .54708 L
s
.92894 .54673 m
.92894 .54673 L
s
.92901 .54614 m
.92901 .54614 L
s
.92909 .54497 m
.92909 .54497 L
s
.92916 .54438 m
.92916 .54438 L
s
.92924 .54368 m
.92924 .54368 L
s
.92931 .54261 m
.92931 .54261 L
s
.92939 .54626 m
.92939 .54626 L
s
.92947 .54849 m
.92947 .54849 L
s
.92954 .55554 m
.92954 .55554 L
s
.92962 .55413 m
.92962 .55413 L
s
.92968 .55507 m
.92968 .55507 L
s
.92976 .55225 m
.92976 .55225 L
s
.92983 .55859 m
.92983 .55859 L
s
.92991 .55448 m
.92991 .55448 L
s
.92998 .55672 m
.92998 .55672 L
s
.93006 .55917 m
.93006 .55917 L
s
.93013 .55953 m
.93013 .55953 L
s
.93021 .56223 m
.93021 .56223 L
s
.93028 .56059 m
.93028 .56059 L
s
.93036 .56235 m
.93036 .56235 L
s
.93043 .56247 m
.93043 .56247 L
s
.9305 .56235 m
.9305 .56235 L
s
.93057 .56305 m
.93057 .56305 L
s
.93065 .57069 m
.93065 .57069 L
s
.93072 .57009 m
.93072 .57009 L
s
.9308 .57022 m
.9308 .57022 L
s
.93087 .56575 m
.93087 .56575 L
s
.93095 .56881 m
.93095 .56881 L
s
.93103 .57057 m
.93103 .57057 L
s
.9311 .56811 m
.9311 .56811 L
s
.93118 .56634 m
.93118 .56634 L
s
.93125 .56634 m
.93125 .56634 L
s
.93132 .56364 m
.93132 .56364 L
s
.93139 .56564 m
.93139 .56564 L
s
.93147 .562 m
.93147 .562 L
s
.93154 .558 m
.93154 .558 L
s
.93162 .558 m
.93162 .558 L
s
.93169 .55307 m
.93169 .55307 L
s
.93177 .54673 m
.93177 .54673 L
s
.93184 .54872 m
.93184 .54872 L
s
.93192 .54837 m
.93192 .54837 L
s
.93199 .55084 m
.93199 .55084 L
s
.93207 .55201 m
.93207 .55201 L
s
.93213 .55131 m
.93213 .55131 L
s
.93221 .55283 m
.93221 .55283 L
s
.93228 .5553 m
.93228 .5553 L
s
.93236 .5526 m
.93236 .5526 L
s
.93243 .54861 m
.93243 .54861 L
s
.93251 .54273 m
.93251 .54273 L
s
.93259 .55061 m
.93259 .55061 L
s
.93266 .55096 m
.93266 .55096 L
s
.93274 .55295 m
.93274 .55295 L
s
.93281 .54602 m
.93281 .54602 L
s
.93288 .54544 m
.93288 .54544 L
s
.93295 .54215 m
.93295 .54215 L
s
.93303 .53839 m
.93303 .53839 L
s
.9331 .53898 m
.9331 .53898 L
s
.93318 .53851 m
.93318 .53851 L
s
.93325 .54179 m
.93325 .54179 L
s
.93333 .53698 m
.93333 .53698 L
s
.9334 .53981 m
.9334 .53981 L
s
.93347 .54121 m
.93347 .54121 L
s
.93355 .54168 m
.93355 .54168 L
s
.93363 .54121 m
.93363 .54121 L
s
.9337 .53205 m
.9337 .53205 L
s
.93377 .53687 m
.93377 .53687 L
s
.93384 .5364 m
.93384 .5364 L
s
.93392 .53076 m
.93392 .53076 L
s
.93399 .5257 m
.93399 .5257 L
s
.93407 .527 m
.93407 .527 L
s
.93415 .52582 m
.93415 .52582 L
s
.93422 .52665 m
.93422 .52665 L
s
.93429 .52054 m
.93429 .52054 L
s
.93437 .51455 m
.93437 .51455 L
s
.93445 .50997 m
.93445 .50997 L
s
.93452 .5082 m
.93452 .5082 L
s
.93459 .51044 m
.93459 .51044 L
s
.93466 .50832 m
.93466 .50832 L
s
.93474 .51443 m
.93474 .51443 L
s
.93481 .51314 m
.93481 .51314 L
s
.93489 .51912 m
.93489 .51912 L
s
.93496 .51901 m
.93496 .51901 L
s
.93504 .52077 m
.93504 .52077 L
s
.9351 .51608 m
.9351 .51608 L
s
.93518 .5257 m
.93518 .5257 L
s
.93526 .52712 m
.93526 .52712 L
s
.93533 .53311 m
.93533 .53311 L
s
.9354 .53463 m
.9354 .53463 L
s
.93548 .53745 m
.93548 .53745 L
s
.93555 .54016 m
.93555 .54016 L
s
.93563 .54614 m
.93563 .54614 L
s
.93571 .55061 m
.93571 .55061 L
s
.93578 .55037 m
.93578 .55037 L
s
.93585 .56388 m
.93585 .56388 L
s
.93592 .56787 m
.93592 .56787 L
s
.936 .56705 m
.936 .56705 L
s
.93608 .56729 m
.93608 .56729 L
s
.93615 .56928 m
.93615 .56928 L
s
.93622 .57457 m
.93622 .57457 L
s
.9363 .57069 m
.9363 .57069 L
s
.93637 .57092 m
.93637 .57092 L
s
.93645 .57503 m
.93645 .57503 L
s
.93652 .58008 m
.93652 .58008 L
s
.9366 .5856 m
.9366 .5856 L
s
.93667 .58713 m
.93667 .58713 L
s
.93674 .58665 m
.93674 .58665 L
s
.93681 .59183 m
.93681 .59183 L
s
.93689 .58889 m
.93689 .58889 L
s
.93696 .5883 m
.93696 .5883 L
s
.93704 .58748 m
.93704 .58748 L
s
.93711 .58866 m
.93711 .58866 L
s
.93719 .58348 m
.93719 .58348 L
s
.93727 .57609 m
.93727 .57609 L
s
.93734 .57468 m
.93734 .57468 L
s
.93742 .5721 m
.93742 .5721 L
s
.93749 .56435 m
.93749 .56435 L
s
.93756 .56634 m
.93756 .56634 L
s
.93763 .57151 m
.93763 .57151 L
s
.93771 .57045 m
.93771 .57045 L
s
.93778 .57292 m
.93778 .57292 L
s
.93786 .57398 m
.93786 .57398 L
s
.93793 .57186 m
.93793 .57186 L
s
.93801 .57034 m
.93801 .57034 L
s
.93808 .56963 m
.93808 .56963 L
s
.93816 .57009 m
.93816 .57009 L
s
.93823 .5748 m
.93823 .5748 L
s
.9383 .57679 m
.9383 .57679 L
s
.93837 .57762 m
.93837 .57762 L
s
.93845 .58278 m
.93845 .58278 L
s
.93852 .58549 m
.93852 .58549 L
s
.9386 .58266 m
.9386 .58266 L
s
.93867 .58208 m
.93867 .58208 L
s
.93875 .58067 m
.93875 .58067 L
s
.93883 .57268 m
.93883 .57268 L
s
.9389 .5721 m
.9389 .5721 L
s
.93898 .57104 m
.93898 .57104 L
s
.93905 .57339 m
.93905 .57339 L
s
.93912 .57151 m
.93912 .57151 L
s
.93919 .56211 m
.93919 .56211 L
s
.93927 .55953 m
.93927 .55953 L
s
.93934 .55295 m
.93934 .55295 L
s
.93942 .55425 m
.93942 .55425 L
s
.93949 .55495 m
.93949 .55495 L
s
.93957 .55448 m
.93957 .55448 L
s
.93964 .55589 m
.93964 .55589 L
s
.93972 .54979 m
.93972 .54979 L
s
.93979 .54814 m
.93979 .54814 L
s
.93987 .55507 m
.93987 .55507 L
s
.93993 .55389 m
.93993 .55389 L
s
.94001 .5553 m
.94001 .5553 L
s
.94008 .56153 m
.94008 .56153 L
s
.94016 .56575 m
.94016 .56575 L
s
.94023 .56564 m
.94023 .56564 L
s
.94031 .56951 m
.94031 .56951 L
s
.94039 .57303 m
.94039 .57303 L
s
.94046 .57386 m
.94046 .57386 L
s
.94054 .57832 m
.94054 .57832 L
s
.94061 .58079 m
.94061 .58079 L
s
.94068 .58137 m
.94068 .58137 L
s
.94075 .57973 m
.94075 .57973 L
s
.94083 .57609 m
.94083 .57609 L
s
.9409 .56904 m
.9409 .56904 L
s
.94098 .56411 m
.94098 .56411 L
s
.94105 .55953 m
.94105 .55953 L
s
.94113 .56165 m
.94113 .56165 L
s
.9412 .56399 m
.9412 .56399 L
s
.94128 .56916 m
.94128 .56916 L
s
.94135 .56834 m
.94135 .56834 L
s
.94143 .57057 m
.94143 .57057 L
s
.9415 .57727 m
.9415 .57727 L
s
.94157 .57973 m
.94157 .57973 L
s
.94164 .57644 m
.94164 .57644 L
s
.94172 .58032 m
.94172 .58032 L
s
.94179 .57903 m
.94179 .57903 L
s
.94187 .58091 m
.94187 .58091 L
s
.94195 .58114 m
.94195 .58114 L
s
.94202 .58642 m
.94202 .58642 L
s
.94209 .59136 m
.94209 .59136 L
s
.94217 .58513 m
.94217 .58513 L
s
.94225 .5849 m
.94225 .5849 L
s
.94232 .58373 m
.94232 .58373 L
s
.94239 .57527 m
.94239 .57527 L
s
.94246 .57691 m
.94246 .57691 L
s
.94254 .5748 m
.94254 .5748 L
s
.94261 .57774 m
.94261 .57774 L
s
.94269 .57667 m
.94269 .57667 L
s
.94276 .57327 m
.94276 .57327 L
s
.94284 .5647 m
.94284 .5647 L
s
.94291 .56646 m
.94291 .56646 L
s
.94299 .56106 m
.94299 .56106 L
s
.94306 .56411 m
.94306 .56411 L
s
.94313 .56188 m
.94313 .56188 L
s
.9432 .56376 m
.9432 .56376 L
s
.94328 .55789 m
.94328 .55789 L
s
.94335 .5553 m
.94335 .5553 L
s
.94343 .5573 m
.94343 .5573 L
s
.94351 .55859 m
.94351 .55859 L
s
.94358 .56024 m
.94358 .56024 L
s
.94365 .5573 m
.94365 .5573 L
s
.94372 .56775 m
.94372 .56775 L
s
.9438 .57363 m
.9438 .57363 L
s
.94388 .57081 m
.94388 .57081 L
s
.94395 .57104 m
.94395 .57104 L
s
.94402 .56353 m
.94402 .56353 L
s
.9441 .55871 m
.9441 .55871 L
s
.94417 .55847 m
.94417 .55847 L
s
.94425 .56036 m
.94425 .56036 L
s
.94432 .56036 m
.94432 .56036 L
s
.9444 .55929 m
.9444 .55929 L
s
.94447 .55565 m
.94447 .55565 L
s
.94454 .55448 m
.94454 .55448 L
s
.94462 .55448 m
.94462 .55448 L
s
.9447 .55131 m
.9447 .55131 L
s
.94476 .55037 m
.94476 .55037 L
s
.94484 .55108 m
.94484 .55108 L
s
.94491 .55518 m
.94491 .55518 L
s
.94499 .55483 m
.94499 .55483 L
s
.94507 .55859 m
.94507 .55859 L
s
.94514 .55742 m
.94514 .55742 L
s
.94522 .56036 m
.94522 .56036 L
s
.94529 .55565 m
.94529 .55565 L
s
.94536 .56247 m
.94536 .56247 L
s
.94543 .56235 m
.94543 .56235 L
s
.94551 .56024 m
.94551 .56024 L
s
.94558 .56118 m
.94558 .56118 L
s
.94566 .55507 m
.94566 .55507 L
s
.94573 .55906 m
.94573 .55906 L
s
.94581 .56411 m
.94581 .56411 L
s
.94588 .56223 m
.94588 .56223 L
s
.94596 .55824 m
.94596 .55824 L
s
.94603 .56071 m
.94603 .56071 L
s
.9461 .55742 m
.9461 .55742 L
s
.94617 .55507 m
.94617 .55507 L
s
.94625 .55624 m
.94625 .55624 L
s
.94633 .55871 m
.94633 .55871 L
s
.9464 .56176 m
.9464 .56176 L
s
.94647 .5647 m
.94647 .5647 L
s
.94655 .56622 m
.94655 .56622 L
s
.94663 .56305 m
.94663 .56305 L
s
.9467 .55483 m
.9467 .55483 L
s
.94678 .55319 m
.94678 .55319 L
s
.94685 .5546 m
.94685 .5546 L
s
.94692 .5452 m
.94692 .5452 L
s
.94699 .54673 m
.94699 .54673 L
s
.94707 .54321 m
.94707 .54321 L
s
.94714 .54297 m
.94714 .54297 L
s
.94722 .53957 m
.94722 .53957 L
s
.94729 .54004 m
.94729 .54004 L
s
.94737 .53698 m
.94737 .53698 L
s
.94744 .54191 m
.94744 .54191 L
s
.94752 .53615 m
.94752 .53615 L
s
.94759 .52947 m
.94759 .52947 L
s
.94767 .53158 m
.94767 .53158 L
s
.94773 .53545 m
.94773 .53545 L
s
.94781 .53123 m
.94781 .53123 L
s
.94788 .53158 m
.94788 .53158 L
s
.94796 .53158 m
.94796 .53158 L
s
.94803 .52677 m
.94803 .52677 L
s
.94811 .52124 m
.94811 .52124 L
s
.94819 .53263 m
.94819 .53263 L
s
.94826 .53334 m
.94826 .53334 L
s
.94834 .5337 m
.94834 .5337 L
s
.94841 .53334 m
.94841 .53334 L
s
.94848 .54097 m
.94848 .54097 L
s
.94855 .53944 m
.94855 .53944 L
s
.94863 .54156 m
.94863 .54156 L
s
.9487 .53393 m
.9487 .53393 L
s
.94878 .53698 m
.94878 .53698 L
s
.94885 .53757 m
.94885 .53757 L
s
.94893 .53323 m
.94893 .53323 L
s
.949 .53134 m
.949 .53134 L
s
.94908 .52641 m
.94908 .52641 L
s
.94915 .52747 m
.94915 .52747 L
s
.94923 .53111 m
.94923 .53111 L
s
.9493 .53134 m
.9493 .53134 L
s
.94937 .52876 m
.94937 .52876 L
s
.94944 .51937 m
.94944 .51937 L
s
.94952 .52171 m
.94952 .52171 L
s
.94959 .51725 m
.94959 .51725 L
s
.94967 .51585 m
.94967 .51585 L
s
.94975 .52183 m
.94975 .52183 L
s
.94982 .51737 m
.94982 .51737 L
s
.9499 .52077 m
.9499 .52077 L
s
.94997 .52042 m
.94997 .52042 L
s
.95005 .51667 m
.95005 .51667 L
s
.95012 .50727 m
.95012 .50727 L
s
.95019 .50433 m
.95019 .50433 L
s
.95026 .49846 m
.95026 .49846 L
s
.95034 .49247 m
.95034 .49247 L
s
.95041 .49752 m
.95041 .49752 L
s
.95049 .49929 m
.95049 .49929 L
s
.95056 .50222 m
.95056 .50222 L
s
.95064 .50433 m
.95064 .50433 L
s
.95071 .49917 m
.95071 .49917 L
s
.95079 .50234 m
.95079 .50234 L
s
.95086 .5061 m
.95086 .5061 L
s
.95093 .50539 m
.95093 .50539 L
s
.951 .50915 m
.951 .50915 L
s
.95108 .50575 m
.95108 .50575 L
s
.95115 .51091 m
.95115 .51091 L
s
.95123 .51725 m
.95123 .51725 L
s
.95131 .52042 m
.95131 .52042 L
s
.95138 .51995 m
.95138 .51995 L
s
.95145 .52253 m
.95145 .52253 L
s
.95153 .51714 m
.95153 .51714 L
s
.9516 .51525 m
.9516 .51525 L
s
.95168 .51655 m
.95168 .51655 L
s
.95175 .51725 m
.95175 .51725 L
s
.95182 .51161 m
.95182 .51161 L
s
.9519 .51232 m
.9519 .51232 L
s
.95197 .5095 m
.95197 .5095 L
s
.95205 .51044 m
.95205 .51044 L
s
.95212 .5142 m
.95212 .5142 L
s
.9522 .51714 m
.9522 .51714 L
s
.95227 .51843 m
.95227 .51843 L
s
.95234 .51596 m
.95234 .51596 L
s
.95242 .5196 m
.95242 .5196 L
s
.9525 .51678 m
.9525 .51678 L
s
.95256 .51901 m
.95256 .51901 L
s
.95264 .52218 m
.95264 .52218 L
s
.95271 .51984 m
.95271 .51984 L
s
.95279 .51373 m
.95279 .51373 L
s
.95287 .51443 m
.95287 .51443 L
s
.95294 .51549 m
.95294 .51549 L
s
.95302 .51338 m
.95302 .51338 L
s
.95309 .51009 m
.95309 .51009 L
s
.95316 .51784 m
.95316 .51784 L
s
.95324 .52476 m
.95324 .52476 L
s
.95331 .52923 m
.95331 .52923 L
s
.95338 .5358 m
.95338 .5358 L
s
.95346 .53933 m
.95346 .53933 L
s
.95353 .52994 m
.95353 .52994 L
s
.95361 .52724 m
.95361 .52724 L
s
.95368 .52007 m
.95368 .52007 L
s
.95376 .52077 m
.95376 .52077 L
s
.95383 .52183 m
.95383 .52183 L
s
.9539 .52019 m
.9539 .52019 L
s
.95397 .51843 m
.95397 .51843 L
s
.95405 .51596 m
.95405 .51596 L
s
.95413 .51126 m
.95413 .51126 L
s
.9542 .51021 m
.9542 .51021 L
s
.95427 .50433 m
.95427 .50433 L
s
.95435 .50527 m
.95435 .50527 L
s
.95443 .50974 m
.95443 .50974 L
s
.9545 .51349 m
.9545 .51349 L
s
.95458 .51443 m
.95458 .51443 L
s
.95465 .51608 m
.95465 .51608 L
s
.95472 .51443 m
.95472 .51443 L
s
.95479 .5142 m
.95479 .5142 L
s
.95487 .51667 m
.95487 .51667 L
s
.95495 .52195 m
.95495 .52195 L
s
.95502 .51819 m
.95502 .51819 L
s
.95509 .51373 m
.95509 .51373 L
s
.95517 .51714 m
.95517 .51714 L
s
.95524 .51608 m
.95524 .51608 L
s
.95532 .5162 m
.95532 .5162 L
s
.95539 .51326 m
.95539 .51326 L
s
.95547 .50598 m
.95547 .50598 L
s
.95553 .5055 m
.95553 .5055 L
s
.95561 .50832 m
.95561 .50832 L
s
.95568 .5041 m
.95568 .5041 L
s
.95576 .50762 m
.95576 .50762 L
s
.95583 .50903 m
.95583 .50903 L
s
.95591 .50457 m
.95591 .50457 L
s
.95599 .49917 m
.95599 .49917 L
s
.95606 .50669 m
.95606 .50669 L
s
.95614 .50527 m
.95614 .50527 L
s
.95621 .50974 m
.95621 .50974 L
s
.95628 .51173 m
.95628 .51173 L
s
.95635 .51021 m
.95635 .51021 L
s
.95643 .50879 m
.95643 .50879 L
s
.9565 .49917 m
.9565 .49917 L
s
.95658 .50386 m
.95658 .50386 L
s
.95665 .5021 m
.95665 .5021 L
s
.95673 .50104 m
.95673 .50104 L
s
.9568 .49553 m
.9568 .49553 L
s
.95688 .49247 m
.95688 .49247 L
s
.95695 .49458 m
.95695 .49458 L
s
.95703 .4994 m
.95703 .4994 L
s
.9571 .50539 m
.9571 .50539 L
s
.95717 .50515 m
.95717 .50515 L
s
.95724 .5048 m
.95724 .5048 L
s
.95732 .50492 m
.95732 .50492 L
s
.95739 .5014 m
.95739 .5014 L
s
.95747 .50069 m
.95747 .50069 L
s
.95755 .49646 m
.95755 .49646 L
s
.95762 .4954 m
.95762 .4954 L
s
0 1 1 0 k
.21472 .13205 m
.21472 .13205 L
s
.21479 .13322 m
.21479 .13322 L
s
.21487 .13275 m
.21487 .13275 L
s
.21495 .13205 m
.21495 .13205 L
s
.21502 .13322 m
.21502 .13322 L
s
.2151 .13415 m
.2151 .13415 L
s
.21517 .13439 m
.21517 .13439 L
s
.21525 .13369 m
.21525 .13369 L
s
.21532 .13415 m
.21532 .13415 L
s
.2154 .13486 m
.2154 .13486 L
s
.21547 .13369 m
.21547 .13369 L
s
.21554 .13509 m
.21554 .13509 L
s
.21561 .13533 m
.21561 .13533 L
s
.21569 .13533 m
.21569 .13533 L
s
.21576 .13651 m
.21576 .13651 L
s
.21584 .13768 m
.21584 .13768 L
s
.21591 .13721 m
.21591 .13721 L
s
.21599 .13815 m
.21599 .13815 L
s
.21606 .13791 m
.21606 .13791 L
s
.21613 .13768 m
.21613 .13768 L
s
.21621 .13909 m
.21621 .13909 L
s
.21629 .13721 m
.21629 .13721 L
s
.21636 .13768 m
.21636 .13768 L
s
.21643 .13627 m
.21643 .13627 L
s
.21651 .13674 m
.21651 .13674 L
s
.21658 .13768 m
.21658 .13768 L
s
.21666 .13721 m
.21666 .13721 L
s
.21673 .13838 m
.21673 .13838 L
s
.21681 .13721 m
.21681 .13721 L
s
.21688 .13909 m
.21688 .13909 L
s
.21695 .13627 m
.21695 .13627 L
s
.21703 .13768 m
.21703 .13768 L
s
.21711 .13627 m
.21711 .13627 L
s
.21717 .13815 m
.21717 .13815 L
s
.21725 .13791 m
.21725 .13791 L
s
.21732 .13768 m
.21732 .13768 L
s
.2174 .13768 m
.2174 .13768 L
s
.21747 .13909 m
.21747 .13909 L
s
.21755 .13861 m
.21755 .13861 L
s
.21762 .13791 m
.21762 .13791 L
s
.21769 .13933 m
.21769 .13933 L
s
.21776 .13956 m
.21776 .13956 L
s
.21784 .14097 m
.21784 .14097 L
s
.21792 .13956 m
.21792 .13956 L
s
.21799 .1405 m
.21799 .1405 L
s
.21807 .13956 m
.21807 .13956 L
s
.21814 .13909 m
.21814 .13909 L
s
.21822 .13956 m
.21822 .13956 L
s
.21829 .1405 m
.21829 .1405 L
s
.21837 .13956 m
.21837 .13956 L
s
.21844 .13956 m
.21844 .13956 L
s
.21851 .13861 m
.21851 .13861 L
s
.21858 .13815 m
.21858 .13815 L
s
.21866 .14073 m
.21866 .14073 L
s
.21874 .13956 m
.21874 .13956 L
s
.21881 .14026 m
.21881 .14026 L
s
.21888 .14003 m
.21888 .14003 L
s
.21896 .14073 m
.21896 .14073 L
s
.21903 .14026 m
.21903 .14026 L
s
.21911 .1405 m
.21911 .1405 L
s
.21918 .14003 m
.21918 .14003 L
s
.21926 .13909 m
.21926 .13909 L
s
.21933 .1405 m
.21933 .1405 L
s
.2194 .13861 m
.2194 .13861 L
s
.21947 .14003 m
.21947 .14003 L
s
.21955 .13674 m
.21955 .13674 L
s
.21963 .13744 m
.21963 .13744 L
s
.2197 .13627 m
.2197 .13627 L
s
.21978 .13768 m
.21978 .13768 L
s
.21985 .13768 m
.21985 .13768 L
s
.21993 .13815 m
.21993 .13815 L
s
.22 .13721 m
.22 .13721 L
s
.22008 .13533 m
.22008 .13533 L
s
.22014 .13697 m
.22014 .13697 L
s
.22022 .13791 m
.22022 .13791 L
s
.22029 .13933 m
.22029 .13933 L
s
.22037 .13979 m
.22037 .13979 L
s
.22044 .1412 m
.22044 .1412 L
s
.22052 .13956 m
.22052 .13956 L
s
.22059 .13933 m
.22059 .13933 L
s
.22067 .13815 m
.22067 .13815 L
s
.22074 .13861 m
.22074 .13861 L
s
.22082 .14003 m
.22082 .14003 L
s
.22089 .14026 m
.22089 .14026 L
s
.22096 .14332 m
.22096 .14332 L
s
.22103 .14214 m
.22103 .14214 L
s
.22111 .14238 m
.22111 .14238 L
s
.22119 .14167 m
.22119 .14167 L
s
.22126 .14167 m
.22126 .14167 L
s
.22134 .14167 m
.22134 .14167 L
s
.22141 .13956 m
.22141 .13956 L
s
.22149 .13791 m
.22149 .13791 L
s
.22156 .13791 m
.22156 .13791 L
s
.22164 .13909 m
.22164 .13909 L
s
.22171 .13768 m
.22171 .13768 L
s
.22178 .13815 m
.22178 .13815 L
s
.22185 .13697 m
.22185 .13697 L
s
.22193 .13861 m
.22193 .13861 L
s
.222 .13838 m
.222 .13838 L
s
.22208 .13861 m
.22208 .13861 L
s
.22215 .13861 m
.22215 .13861 L
s
.22223 .13956 m
.22223 .13956 L
s
.2223 .14003 m
.2223 .14003 L
s
.22238 .14214 m
.22238 .14214 L
s
.22245 .14308 m
.22245 .14308 L
s
.22252 .14379 m
.22252 .14379 L
s
.22259 .14496 m
.22259 .14496 L
s
.22267 .14402 m
.22267 .14402 L
s
.22275 .14402 m
.22275 .14402 L
s
.22282 .14355 m
.22282 .14355 L
s
.2229 .14379 m
.2229 .14379 L
s
.22297 .14402 m
.22297 .14402 L
s
.22305 .14519 m
.22305 .14519 L
s
.22312 .14472 m
.22312 .14472 L
s
.2232 .14402 m
.2232 .14402 L
s
.22327 .14379 m
.22327 .14379 L
s
.22334 .14332 m
.22334 .14332 L
s
.22341 .14379 m
.22341 .14379 L
s
.22349 .14379 m
.22349 .14379 L
s
.22356 .14402 m
.22356 .14402 L
s
.22364 .14449 m
.22364 .14449 L
s
.22371 .14402 m
.22371 .14402 L
s
.22379 .14238 m
.22379 .14238 L
s
.22386 .14167 m
.22386 .14167 L
s
.22394 .14167 m
.22394 .14167 L
s
.22401 .14026 m
.22401 .14026 L
s
.22409 .14003 m
.22409 .14003 L
s
.22416 .13979 m
.22416 .13979 L
s
.22423 .14026 m
.22423 .14026 L
s
.22431 .13886 m
.22431 .13886 L
s
.22438 .14073 m
.22438 .14073 L
s
.22446 .13861 m
.22446 .13861 L
s
.22453 .13861 m
.22453 .13861 L
s
.22461 .13627 m
.22461 .13627 L
s
.22468 .13697 m
.22468 .13697 L
s
.22475 .13744 m
.22475 .13744 L
s
.22483 .13627 m
.22483 .13627 L
s
.22491 .1358 m
.22491 .1358 L
s
.22497 .13604 m
.22497 .13604 L
s
.22505 .13744 m
.22505 .13744 L
s
.22512 .13697 m
.22512 .13697 L
s
.2252 .13791 m
.2252 .13791 L
s
.22527 .13697 m
.22527 .13697 L
s
.22535 .13909 m
.22535 .13909 L
s
.22542 .13861 m
.22542 .13861 L
s
.22549 .13791 m
.22549 .13791 L
s
.22557 .13721 m
.22557 .13721 L
s
.22565 .13768 m
.22565 .13768 L
s
.22572 .13861 m
.22572 .13861 L
s
.22579 .13768 m
.22579 .13768 L
s
.22587 .13815 m
.22587 .13815 L
s
.22594 .13744 m
.22594 .13744 L
s
.22602 .13651 m
.22602 .13651 L
s
.22609 .13557 m
.22609 .13557 L
s
.22617 .13604 m
.22617 .13604 L
s
.22624 .13509 m
.22624 .13509 L
s
.22631 .1358 m
.22631 .1358 L
s
.22638 .13721 m
.22638 .13721 L
s
.22646 .13674 m
.22646 .13674 L
s
.22654 .1358 m
.22654 .1358 L
s
.22661 .13557 m
.22661 .13557 L
s
.22668 .13604 m
.22668 .13604 L
s
.22676 .13439 m
.22676 .13439 L
s
.22683 .1358 m
.22683 .1358 L
s
.22691 .13486 m
.22691 .13486 L
s
.22698 .13674 m
.22698 .13674 L
s
.22706 .13697 m
.22706 .13697 L
s
.22713 .13815 m
.22713 .13815 L
s
.2272 .13768 m
.2272 .13768 L
s
.22728 .13909 m
.22728 .13909 L
s
.22735 .14073 m
.22735 .14073 L
s
.22743 .13933 m
.22743 .13933 L
s
.2275 .14097 m
.2275 .14097 L
s
.22758 .1405 m
.22758 .1405 L
s
.22765 .1412 m
.22765 .1412 L
s
.22773 .13933 m
.22773 .13933 L
s
.2278 .13909 m
.2278 .13909 L
s
.22788 .13838 m
.22788 .13838 L
s
.22794 .13979 m
.22794 .13979 L
s
.22802 .13815 m
.22802 .13815 L
s
.22809 .13744 m
.22809 .13744 L
s
.22817 .13768 m
.22817 .13768 L
s
.22824 .13674 m
.22824 .13674 L
s
.22832 .13861 m
.22832 .13861 L
s
.22839 .13768 m
.22839 .13768 L
s
.22847 .13697 m
.22847 .13697 L
s
.22854 .13651 m
.22854 .13651 L
s
.22862 .13744 m
.22862 .13744 L
s
.22869 .13651 m
.22869 .13651 L
s
.22876 .1358 m
.22876 .1358 L
s
.22883 .13627 m
.22883 .13627 L
s
.22891 .13486 m
.22891 .13486 L
s
.22899 .13415 m
.22899 .13415 L
s
.22906 .13322 m
.22906 .13322 L
s
.22914 .13298 m
.22914 .13298 L
s
.22921 .13357 m
.22921 .13357 L
s
.22929 .13251 m
.22929 .13251 L
s
.22936 .13263 m
.22936 .13263 L
s
.22944 .13228 m
.22944 .13228 L
s
.22951 .13369 m
.22951 .13369 L
s
.22958 .13462 m
.22958 .13462 L
s
.22965 .13369 m
.22965 .13369 L
s
.22973 .1338 m
.22973 .1338 L
s
.2298 .13322 m
.2298 .13322 L
s
.22988 .13345 m
.22988 .13345 L
s
.22995 .13263 m
.22995 .13263 L
s
.23003 .13263 m
.23003 .13263 L
s
.2301 .13298 m
.2301 .13298 L
s
.23018 .13251 m
.23018 .13251 L
s
.23025 .13298 m
.23025 .13298 L
s
.23032 .13228 m
.23032 .13228 L
s
.23039 .13251 m
.23039 .13251 L
s
.23047 .13369 m
.23047 .13369 L
s
.23055 .13345 m
.23055 .13345 L
s
.23062 .13486 m
.23062 .13486 L
s
.2307 .13439 m
.2307 .13439 L
s
.23077 .13533 m
.23077 .13533 L
s
.23085 .13439 m
.23085 .13439 L
s
.23092 .13298 m
.23092 .13298 L
s
.231 .13298 m
.231 .13298 L
s
.23107 .13251 m
.23107 .13251 L
s
.23114 .13228 m
.23114 .13228 L
s
.23121 .13251 m
.23121 .13251 L
s
.23129 .13251 m
.23129 .13251 L
s
.23136 .13263 m
.23136 .13263 L
s
.23144 .13205 m
.23144 .13205 L
s
.23151 .13275 m
.23151 .13275 L
s
.23159 .13205 m
.23159 .13205 L
s
.23166 .13216 m
.23166 .13216 L
s
.23174 .13298 m
.23174 .13298 L
s
.23181 .13251 m
.23181 .13251 L
s
.23189 .13228 m
.23189 .13228 L
s
.23196 .1324 m
.23196 .1324 L
s
.23203 .13345 m
.23203 .13345 L
s
.23211 .13263 m
.23211 .13263 L
s
.23218 .13333 m
.23218 .13333 L
s
.23226 .13228 m
.23226 .13228 L
s
.23233 .13345 m
.23233 .13345 L
s
.23241 .1338 m
.23241 .1338 L
s
.23248 .13263 m
.23248 .13263 L
s
.23256 .13205 m
.23256 .13205 L
s
.23263 .13205 m
.23263 .13205 L
s
.23271 .13345 m
.23271 .13345 L
s
.23277 .13392 m
.23277 .13392 L
s
.23285 .13415 m
.23285 .13415 L
s
.23292 .13462 m
.23292 .13462 L
s
.233 .1358 m
.233 .1358 L
s
.23307 .13815 m
.23307 .13815 L
s
.23315 .13815 m
.23315 .13815 L
s
.23322 .13979 m
.23322 .13979 L
s
.23329 .13744 m
.23329 .13744 L
s
.23337 .13933 m
.23337 .13933 L
s
.23345 .13861 m
.23345 .13861 L
s
.23352 .1405 m
.23352 .1405 L
s
.23359 .14003 m
.23359 .14003 L
s
.23367 .13909 m
.23367 .13909 L
s
.23374 .14097 m
.23374 .14097 L
s
.23382 .14073 m
.23382 .14073 L
s
.23389 .14355 m
.23389 .14355 L
s
.23397 .14261 m
.23397 .14261 L
s
.23404 .14402 m
.23404 .14402 L
s
.23411 .14308 m
.23411 .14308 L
s
.23419 .14332 m
.23419 .14332 L
s
.23427 .1419 m
.23427 .1419 L
s
.23434 .14097 m
.23434 .14097 L
s
.23441 .14097 m
.23441 .14097 L
s
.23448 .13956 m
.23448 .13956 L
s
.23456 .1405 m
.23456 .1405 L
s
.23463 .13886 m
.23463 .13886 L
s
.23471 .13979 m
.23471 .13979 L
s
.23478 .13979 m
.23478 .13979 L
s
.23486 .14003 m
.23486 .14003 L
s
.23493 .14026 m
.23493 .14026 L
s
.235 .14238 m
.235 .14238 L
s
.23508 .14261 m
.23508 .14261 L
s
.23515 .14143 m
.23515 .14143 L
s
.23523 .14003 m
.23523 .14003 L
s
.2353 .13956 m
.2353 .13956 L
s
.23538 .13909 m
.23538 .13909 L
s
.23545 .13791 m
.23545 .13791 L
s
.23553 .14003 m
.23553 .14003 L
s
.2356 .14026 m
.2356 .14026 L
s
.23568 .1405 m
.23568 .1405 L
s
.23574 .14073 m
.23574 .14073 L
s
.23582 .13933 m
.23582 .13933 L
s
.2359 .13886 m
.2359 .13886 L
s
.23597 .13768 m
.23597 .13768 L
s
.23604 .13791 m
.23604 .13791 L
s
.23612 .13533 m
.23612 .13533 L
s
.23619 .1358 m
.23619 .1358 L
s
.23627 .13604 m
.23627 .13604 L
s
.23634 .13861 m
.23634 .13861 L
s
.23642 .13933 m
.23642 .13933 L
s
.23649 .14003 m
.23649 .14003 L
s
.23656 .13886 m
.23656 .13886 L
s
.23663 .13886 m
.23663 .13886 L
s
.23671 .13815 m
.23671 .13815 L
s
.23679 .13979 m
.23679 .13979 L
s
.23686 .13933 m
.23686 .13933 L
s
.23694 .13861 m
.23694 .13861 L
s
.23701 .13886 m
.23701 .13886 L
s
.23709 .13838 m
.23709 .13838 L
s
.23716 .13979 m
.23716 .13979 L
s
.23724 .13768 m
.23724 .13768 L
s
.23731 .13791 m
.23731 .13791 L
s
.23738 .13909 m
.23738 .13909 L
s
.23745 .13909 m
.23745 .13909 L
s
.23753 .1412 m
.23753 .1412 L
s
.2376 .14167 m
.2376 .14167 L
s
.23768 .1419 m
.23768 .1419 L
s
.23775 .14238 m
.23775 .14238 L
s
.23783 .14332 m
.23783 .14332 L
s
.2379 .14238 m
.2379 .14238 L
s
.23798 .14379 m
.23798 .14379 L
s
.23805 .14308 m
.23805 .14308 L
s
.23813 .14355 m
.23813 .14355 L
s
.23819 .14425 m
.23819 .14425 L
s
.23827 .14214 m
.23827 .14214 L
s
.23835 .14332 m
.23835 .14332 L
s
.23842 .1405 m
.23842 .1405 L
s
.2385 .1419 m
.2385 .1419 L
s
.23857 .14003 m
.23857 .14003 L
s
.23865 .13979 m
.23865 .13979 L
s
.23872 .13886 m
.23872 .13886 L
s
.2388 .13933 m
.2388 .13933 L
s
.23887 .13768 m
.23887 .13768 L
s
.23894 .13791 m
.23894 .13791 L
s
.23901 .13861 m
.23901 .13861 L
s
.23909 .14003 m
.23909 .14003 L
s
.23916 .13909 m
.23916 .13909 L
s
.23924 .13909 m
.23924 .13909 L
s
.23931 .1405 m
.23931 .1405 L
s
.23939 .14026 m
.23939 .14026 L
s
.23946 .14167 m
.23946 .14167 L
s
.23954 .13956 m
.23954 .13956 L
s
.23961 .13933 m
.23961 .13933 L
s
.23969 .14003 m
.23969 .14003 L
s
.23976 .14167 m
.23976 .14167 L
s
.23983 .14261 m
.23983 .14261 L
s
.23991 .1419 m
.23991 .1419 L
s
.23998 .14097 m
.23998 .14097 L
s
.24006 .14073 m
.24006 .14073 L
s
.24013 .14143 m
.24013 .14143 L
s
.24021 .13933 m
.24021 .13933 L
s
.24028 .14073 m
.24028 .14073 L
s
.24036 .1405 m
.24036 .1405 L
s
.24043 .14073 m
.24043 .14073 L
s
.24051 .14003 m
.24051 .14003 L
s
.24057 .14143 m
.24057 .14143 L
s
.24065 .13909 m
.24065 .13909 L
s
.24072 .13791 m
.24072 .13791 L
s
.2408 .13768 m
.2408 .13768 L
s
.24087 .13721 m
.24087 .13721 L
s
.24095 .13674 m
.24095 .13674 L
s
.24102 .13557 m
.24102 .13557 L
s
.2411 .13768 m
.2411 .13768 L
s
.24117 .13557 m
.24117 .13557 L
s
.24125 .13604 m
.24125 .13604 L
s
.24132 .13509 m
.24132 .13509 L
s
.24139 .13415 m
.24139 .13415 L
s
.24147 .13509 m
.24147 .13509 L
s
.24154 .13345 m
.24154 .13345 L
s
.24162 .13298 m
.24162 .13298 L
s
.24169 .1324 m
.24169 .1324 L
s
.24177 .13392 m
.24177 .13392 L
s
.24184 .13298 m
.24184 .13298 L
s
.24191 .13228 m
.24191 .13228 L
s
.24199 .13228 m
.24199 .13228 L
s
.24207 .13251 m
.24207 .13251 L
s
.24214 .13439 m
.24214 .13439 L
s
.24221 .13251 m
.24221 .13251 L
s
.24228 .13228 m
.24228 .13228 L
s
.24236 .13205 m
.24236 .13205 L
s
.24243 .1331 m
.24243 .1331 L
s
.24251 .1324 m
.24251 .1324 L
s
.24258 .13228 m
.24258 .13228 L
s
.24266 .1324 m
.24266 .1324 L
s
.24273 .13251 m
.24273 .13251 L
s
.24281 .13322 m
.24281 .13322 L
s
.24288 .13205 m
.24288 .13205 L
s
.24296 .13228 m
.24296 .13228 L
s
.24303 .13251 m
.24303 .13251 L
s
.2431 .13251 m
.2431 .13251 L
s
.24318 .13228 m
.24318 .13228 L
s
.24325 .13322 m
.24325 .13322 L
s
.24333 .13439 m
.24333 .13439 L
s
.2434 .1324 m
.2434 .1324 L
s
.24348 .13205 m
.24348 .13205 L
s
.24354 .13298 m
.24354 .13298 L
s
.24362 .13275 m
.24362 .13275 L
s
.2437 .13275 m
.2437 .13275 L
s
.24377 .13228 m
.24377 .13228 L
s
.24384 .13251 m
.24384 .13251 L
s
.24392 .13287 m
.24392 .13287 L
s
.24399 .13228 m
.24399 .13228 L
s
.24407 .13415 m
.24407 .13415 L
s
.24414 .13298 m
.24414 .13298 L
s
.24422 .13462 m
.24422 .13462 L
s
.24429 .13369 m
.24429 .13369 L
s
.24436 .13533 m
.24436 .13533 L
s
.24444 .13415 m
.24444 .13415 L
s
.24452 .13345 m
.24452 .13345 L
s
.24459 .13298 m
.24459 .13298 L
s
.24466 .13345 m
.24466 .13345 L
s
.24474 .13439 m
.24474 .13439 L
s
.24481 .13439 m
.24481 .13439 L
s
.24489 .13604 m
.24489 .13604 L
s
.24496 .13415 m
.24496 .13415 L
s
.24504 .13439 m
.24504 .13439 L
s
.24511 .13345 m
.24511 .13345 L
s
.24518 .13392 m
.24518 .13392 L
s
.24525 .13462 m
.24525 .13462 L
s
.24533 .13462 m
.24533 .13462 L
s
.2454 .1358 m
.2454 .1358 L
s
.24548 .13697 m
.24548 .13697 L
s
.24555 .13815 m
.24555 .13815 L
s
.24563 .13933 m
.24563 .13933 L
s
.2457 .13886 m
.2457 .13886 L
s
.24578 .13815 m
.24578 .13815 L
s
.24585 .14026 m
.24585 .14026 L
s
.24593 .13861 m
.24593 .13861 L
s
.24599 .13956 m
.24599 .13956 L
s
.24607 .14026 m
.24607 .14026 L
s
.24615 .1412 m
.24615 .1412 L
s
.24622 .14073 m
.24622 .14073 L
s
.2463 .14003 m
.2463 .14003 L
s
.24637 .13979 m
.24637 .13979 L
s
.24645 .14003 m
.24645 .14003 L
s
.24652 .14026 m
.24652 .14026 L
s
.2466 .14167 m
.2466 .14167 L
s
.24667 .14261 m
.24667 .14261 L
s
.24674 .1405 m
.24674 .1405 L
s
.24681 .14214 m
.24681 .14214 L
s
.24689 .14003 m
.24689 .14003 L
s
.24696 .13956 m
.24696 .13956 L
s
.24704 .13861 m
.24704 .13861 L
s
.24711 .13909 m
.24711 .13909 L
s
.24719 .13956 m
.24719 .13956 L
s
.24726 .13909 m
.24726 .13909 L
s
.24734 .13933 m
.24734 .13933 L
s
.24741 .13791 m
.24741 .13791 L
s
.24749 .13979 m
.24749 .13979 L
s
.24756 .13651 m
.24756 .13651 L
s
.24763 .13651 m
.24763 .13651 L
s
.24771 .1358 m
.24771 .1358 L
s
.24778 .13627 m
.24778 .13627 L
s
.24786 .13486 m
.24786 .13486 L
s
.24793 .13439 m
.24793 .13439 L
s
.24801 .13439 m
.24801 .13439 L
s
.24808 .13439 m
.24808 .13439 L
s
.24816 .13486 m
.24816 .13486 L
s
.24823 .13415 m
.24823 .13415 L
s
.24831 .13627 m
.24831 .13627 L
s
.24837 .13439 m
.24837 .13439 L
s
.24845 .13509 m
.24845 .13509 L
s
.24852 .1358 m
.24852 .1358 L
s
.2486 .13768 m
.2486 .13768 L
s
.24867 .13861 m
.24867 .13861 L
s
.24875 .13956 m
.24875 .13956 L
s
.24882 .1405 m
.24882 .1405 L
s
.2489 .14073 m
.2489 .14073 L
s
.24897 .14143 m
.24897 .14143 L
s
.24905 .14003 m
.24905 .14003 L
s
.24912 .14073 m
.24912 .14073 L
s
.24919 .14026 m
.24919 .14026 L
s
.24927 .1412 m
.24927 .1412 L
s
.24934 .13979 m
.24934 .13979 L
s
.24942 .13886 m
.24942 .13886 L
s
.24949 .14026 m
.24949 .14026 L
s
.24957 .13956 m
.24957 .13956 L
s
.24964 .13886 m
.24964 .13886 L
s
.24972 .13838 m
.24972 .13838 L
s
.24979 .13956 m
.24979 .13956 L
s
.24987 .13791 m
.24987 .13791 L
s
.24994 .13933 m
.24994 .13933 L
s
.25001 .14003 m
.25001 .14003 L
s
.25008 .1412 m
.25008 .1412 L
s
.25016 .1419 m
.25016 .1419 L
s
.25023 .14355 m
.25023 .14355 L
s
.25031 .14285 m
.25031 .14285 L
s
.25038 .14332 m
.25038 .14332 L
s
.25046 .14472 m
.25046 .14472 L
s
.25053 .14449 m
.25053 .14449 L
s
.25061 .14449 m
.25061 .14449 L
s
.25068 .14425 m
.25068 .14425 L
s
.25076 .14637 m
.25076 .14637 L
s
.25083 .14567 m
.25083 .14567 L
s
.2509 .14684 m
.2509 .14684 L
s
.25098 .1459 m
.25098 .1459 L
s
.25105 .14614 m
.25105 .14614 L
s
.25113 .14684 m
.25113 .14684 L
s
.2512 .14684 m
.2512 .14684 L
s
.25128 .14848 m
.25128 .14848 L
s
.25135 .14731 m
.25135 .14731 L
s
.25143 .14801 m
.25143 .14801 L
s
.2515 .14707 m
.2515 .14707 L
s
.25157 .14989 m
.25157 .14989 L
s
.25164 .15083 m
.25164 .15083 L
s
.25172 .15154 m
.25172 .15154 L
s
.25179 .15036 m
.25179 .15036 L
s
.25187 .15177 m
.25187 .15177 L
s
.25194 .15177 m
.25194 .15177 L
s
.25202 .15271 m
.25202 .15271 L
s
.25209 .15342 m
.25209 .15342 L
s
.25216 .15271 m
.25216 .15271 L
s
.25224 .15412 m
.25224 .15412 L
s
.25232 .15224 m
.25232 .15224 L
s
.25239 .15389 m
.25239 .15389 L
s
.25246 .15389 m
.25246 .15389 L
s
.25254 .15482 m
.25254 .15482 L
s
.25261 .15459 m
.25261 .15459 L
s
.25269 .15576 m
.25269 .15576 L
s
.25276 .15624 m
.25276 .15624 L
s
.25284 .15576 m
.25284 .15576 L
s
.25291 .15694 m
.25291 .15694 L
s
.25298 .15811 m
.25298 .15811 L
s
.25306 .15788 m
.25306 .15788 L
s
.25313 .15694 m
.25313 .15694 L
s
.2532 .15741 m
.2532 .15741 L
s
.25328 .15741 m
.25328 .15741 L
s
.25335 .15741 m
.25335 .15741 L
s
.25343 .15694 m
.25343 .15694 L
s
.2535 .15694 m
.2535 .15694 L
s
.25358 .15717 m
.25358 .15717 L
s
.25365 .15671 m
.25365 .15671 L
s
.25373 .15741 m
.25373 .15741 L
s
.25379 .15811 m
.25379 .15811 L
s
.25387 .15811 m
.25387 .15811 L
s
.25395 .15811 m
.25395 .15811 L
s
.25402 .15788 m
.25402 .15788 L
s
.2541 .15671 m
.2541 .15671 L
s
.25417 .15624 m
.25417 .15624 L
s
.25425 .15576 m
.25425 .15576 L
s
.25432 .156 m
.25432 .156 L
s
.2544 .15647 m
.2544 .15647 L
s
.25447 .15576 m
.25447 .15576 L
s
.25454 .156 m
.25454 .156 L
s
.25461 .156 m
.25461 .156 L
s
.25469 .15576 m
.25469 .15576 L
s
.25477 .15412 m
.25477 .15412 L
s
.25484 .15342 m
.25484 .15342 L
s
.25491 .15435 m
.25491 .15435 L
s
.25499 .15435 m
.25499 .15435 L
s
.25506 .15435 m
.25506 .15435 L
s
.25514 .15412 m
.25514 .15412 L
s
.25521 .152 m
.25521 .152 L
s
.25529 .1513 m
.25529 .1513 L
s
.25536 .15083 m
.25536 .15083 L
s
.25543 .1506 m
.25543 .1506 L
s
.25551 .15224 m
.25551 .15224 L
s
.25558 .1506 m
.25558 .1506 L
s
.25566 .15271 m
.25566 .15271 L
s
.25573 .1513 m
.25573 .1513 L
s
.25581 .15154 m
.25581 .15154 L
s
.25588 .15177 m
.25588 .15177 L
s
.25596 .15177 m
.25596 .15177 L
s
.25603 .15154 m
.25603 .15154 L
s
.25611 .14989 m
.25611 .14989 L
s
.25617 .15036 m
.25617 .15036 L
s
.25625 .14943 m
.25625 .14943 L
s
.25632 .15013 m
.25632 .15013 L
s
.2564 .14895 m
.2564 .14895 L
s
.25647 .14943 m
.25647 .14943 L
s
.25655 .14801 m
.25655 .14801 L
s
.25662 .14754 m
.25662 .14754 L
s
.2567 .14825 m
.2567 .14825 L
s
.25677 .14707 m
.25677 .14707 L
s
.25685 .14684 m
.25685 .14684 L
s
.25692 .14778 m
.25692 .14778 L
s
.25699 .14848 m
.25699 .14848 L
s
.25707 .14778 m
.25707 .14778 L
s
.25714 .14943 m
.25714 .14943 L
s
.25722 .14895 m
.25722 .14895 L
s
.25729 .14989 m
.25729 .14989 L
s
.25737 .15013 m
.25737 .15013 L
s
.25744 .15036 m
.25744 .15036 L
s
.25752 .14989 m
.25752 .14989 L
s
.25759 .14848 m
.25759 .14848 L
s
.25767 .14848 m
.25767 .14848 L
s
.25774 .14801 m
.25774 .14801 L
s
.25781 .14872 m
.25781 .14872 L
s
.25788 .14801 m
.25788 .14801 L
s
.25796 .14895 m
.25796 .14895 L
s
.25803 .15013 m
.25803 .15013 L
s
.25811 .1513 m
.25811 .1513 L
s
.25818 .15342 m
.25818 .15342 L
s
.25826 .15482 m
.25826 .15482 L
s
.25833 .156 m
.25833 .156 L
s
.25841 .15529 m
.25841 .15529 L
s
.25848 .15553 m
.25848 .15553 L
s
.25856 .15576 m
.25856 .15576 L
s
.25863 .15717 m
.25863 .15717 L
s
.2587 .15671 m
.2587 .15671 L
s
.25878 .15788 m
.25878 .15788 L
s
.25885 .15788 m
.25885 .15788 L
s
.25893 .15788 m
.25893 .15788 L
s
.259 .15694 m
.259 .15694 L
s
.25908 .15788 m
.25908 .15788 L
s
.25915 .15764 m
.25915 .15764 L
s
.25923 .15671 m
.25923 .15671 L
s
.2593 .15835 m
.2593 .15835 L
s
.25937 .15788 m
.25937 .15788 L
s
.25944 .15882 m
.25944 .15882 L
s
.25952 .15835 m
.25952 .15835 L
s
.25959 .15882 m
.25959 .15882 L
s
.25967 .15929 m
.25967 .15929 L
s
.25974 .15858 m
.25974 .15858 L
s
.25982 .15788 m
.25982 .15788 L
s
.25989 .15976 m
.25989 .15976 L
s
.25997 .15929 m
.25997 .15929 L
s
.26004 .15905 m
.26004 .15905 L
s
.26012 .15905 m
.26012 .15905 L
s
.26019 .15788 m
.26019 .15788 L
s
.26026 .15741 m
.26026 .15741 L
s
.26034 .15717 m
.26034 .15717 L
s
.26041 .15905 m
.26041 .15905 L
s
.26049 .15694 m
.26049 .15694 L
s
.26056 .15741 m
.26056 .15741 L
s
.26064 .15835 m
.26064 .15835 L
s
.26071 .15811 m
.26071 .15811 L
s
.26078 .15811 m
.26078 .15811 L
s
.26086 .15835 m
.26086 .15835 L
s
.26094 .16023 m
.26094 .16023 L
s
.261 .15953 m
.261 .15953 L
s
.26108 .16234 m
.26108 .16234 L
s
.26115 .16093 m
.26115 .16093 L
s
.26123 .16187 m
.26123 .16187 L
s
.2613 .16164 m
.2613 .16164 L
s
.26138 .16164 m
.26138 .16164 L
s
.26145 .16305 m
.26145 .16305 L
s
.26153 .16375 m
.26153 .16375 L
s
.2616 .16422 m
.2616 .16422 L
s
.26167 .16281 m
.26167 .16281 L
s
.26175 .16399 m
.26175 .16399 L
s
.26182 .16352 m
.26182 .16352 L
s
.2619 .16399 m
.2619 .16399 L
s
.26197 .16234 m
.26197 .16234 L
s
.26205 .16375 m
.26205 .16375 L
s
.26212 .16399 m
.26212 .16399 L
s
.2622 .16586 m
.2622 .16586 L
s
.26227 .16516 m
.26227 .16516 L
s
.26234 .16539 m
.26234 .16539 L
s
.26241 .16563 m
.26241 .16563 L
s
.26249 .16469 m
.26249 .16469 L
s
.26257 .1661 m
.26257 .1661 L
s
.26264 .16539 m
.26264 .16539 L
s
.26271 .16821 m
.26271 .16821 L
s
.26279 .16422 m
.26279 .16422 L
s
.26286 .16492 m
.26286 .16492 L
s
.26294 .16563 m
.26294 .16563 L
s
.26301 .1661 m
.26301 .1661 L
s
.26309 .1661 m
.26309 .1661 L
s
.26316 .16774 m
.26316 .16774 L
s
.26323 .16774 m
.26323 .16774 L
s
.26331 .16727 m
.26331 .16727 L
s
.26338 .16821 m
.26338 .16821 L
s
.26346 .16657 m
.26346 .16657 L
s
.26353 .16798 m
.26353 .16798 L
s
.26361 .16821 m
.26361 .16821 L
s
.26368 .16868 m
.26368 .16868 L
s
.26376 .16821 m
.26376 .16821 L
s
.26383 .16986 m
.26383 .16986 L
s
.26391 .16868 m
.26391 .16868 L
s
.26397 .16798 m
.26397 .16798 L
s
.26405 .16939 m
.26405 .16939 L
s
.26412 .16845 m
.26412 .16845 L
s
.2642 .16892 m
.2642 .16892 L
s
.26427 .16892 m
.26427 .16892 L
s
.26435 .17033 m
.26435 .17033 L
s
.26442 .17127 m
.26442 .17127 L
s
.2645 .17009 m
.2645 .17009 L
s
.26457 .17033 m
.26457 .17033 L
s
.26465 .16986 m
.26465 .16986 L
s
.26472 .16939 m
.26472 .16939 L
s
.26479 .16915 m
.26479 .16915 L
s
.26487 .16915 m
.26487 .16915 L
s
.26494 .16868 m
.26494 .16868 L
s
.26502 .16774 m
.26502 .16774 L
s
.26509 .16751 m
.26509 .16751 L
s
.26517 .16798 m
.26517 .16798 L
s
.26524 .16727 m
.26524 .16727 L
s
.26532 .16915 m
.26532 .16915 L
s
.26539 .16821 m
.26539 .16821 L
s
.26547 .16751 m
.26547 .16751 L
s
.26554 .16774 m
.26554 .16774 L
s
.26561 .16657 m
.26561 .16657 L
s
.26568 .16751 m
.26568 .16751 L
s
.26576 .1661 m
.26576 .1661 L
s
.26583 .1661 m
.26583 .1661 L
s
.26591 .1661 m
.26591 .1661 L
s
.26598 .16563 m
.26598 .16563 L
s
.26606 .16422 m
.26606 .16422 L
s
.26613 .16399 m
.26613 .16399 L
s
.26621 .16305 m
.26621 .16305 L
s
.26628 .16352 m
.26628 .16352 L
s
.26636 .16375 m
.26636 .16375 L
s
.26643 .16399 m
.26643 .16399 L
s
.2665 .16375 m
.2665 .16375 L
s
.26658 .16352 m
.26658 .16352 L
s
.26665 .16469 m
.26665 .16469 L
s
.26673 .16399 m
.26673 .16399 L
s
.2668 .16445 m
.2668 .16445 L
s
.26688 .16539 m
.26688 .16539 L
s
.26695 .16422 m
.26695 .16422 L
s
.26703 .16586 m
.26703 .16586 L
s
.2671 .16798 m
.2671 .16798 L
s
.26717 .16774 m
.26717 .16774 L
s
.26724 .16681 m
.26724 .16681 L
s
.26732 .16681 m
.26732 .16681 L
s
.26739 .16586 m
.26739 .16586 L
s
.26747 .16634 m
.26747 .16634 L
s
.26754 .16563 m
.26754 .16563 L
s
.26762 .16586 m
.26762 .16586 L
s
.26769 .16563 m
.26769 .16563 L
s
.26777 .16657 m
.26777 .16657 L
s
.26784 .16704 m
.26784 .16704 L
s
.26792 .16634 m
.26792 .16634 L
s
.26799 .16586 m
.26799 .16586 L
s
.26806 .16492 m
.26806 .16492 L
s
.26814 .16516 m
.26814 .16516 L
s
.26821 .16399 m
.26821 .16399 L
s
.26829 .16586 m
.26829 .16586 L
s
.26836 .16469 m
.26836 .16469 L
s
.26844 .16634 m
.26844 .16634 L
s
.26851 .16445 m
.26851 .16445 L
s
.26858 .16492 m
.26858 .16492 L
s
.26866 .16516 m
.26866 .16516 L
s
.26874 .16516 m
.26874 .16516 L
s
.2688 .16681 m
.2688 .16681 L
s
.26888 .16422 m
.26888 .16422 L
s
.26895 .16422 m
.26895 .16422 L
s
.26903 .16352 m
.26903 .16352 L
s
.2691 .16445 m
.2691 .16445 L
s
.26918 .16234 m
.26918 .16234 L
s
.26925 .16164 m
.26925 .16164 L
s
.26933 .16093 m
.26933 .16093 L
s
.2694 .16046 m
.2694 .16046 L
s
.26948 .15835 m
.26948 .15835 L
s
.26956 .15929 m
.26956 .15929 L
s
.26962 .15788 m
.26962 .15788 L
s
.2697 .15459 m
.2697 .15459 L
s
.26977 .15624 m
.26977 .15624 L
s
.26985 .15459 m
.26985 .15459 L
s
.26992 .15482 m
.26992 .15482 L
s
.27 .15295 m
.27 .15295 L
s
.27007 .15412 m
.27007 .15412 L
s
.27014 .15295 m
.27014 .15295 L
s
.27021 .15224 m
.27021 .15224 L
s
.27029 .15154 m
.27029 .15154 L
s
.27037 .15271 m
.27037 .15271 L
s
.27044 .15224 m
.27044 .15224 L
s
.27051 .15107 m
.27051 .15107 L
s
.27059 .152 m
.27059 .152 L
s
.27066 .1506 m
.27066 .1506 L
s
.27074 .15013 m
.27074 .15013 L
s
.27081 .14848 m
.27081 .14848 L
s
.27089 .14989 m
.27089 .14989 L
s
.27096 .14895 m
.27096 .14895 L
s
.27103 .14919 m
.27103 .14919 L
s
.27111 .15013 m
.27111 .15013 L
s
.27119 .14943 m
.27119 .14943 L
s
.27126 .14848 m
.27126 .14848 L
s
.27133 .14919 m
.27133 .14919 L
s
.27141 .15036 m
.27141 .15036 L
s
.27148 .15036 m
.27148 .15036 L
s
.27156 .1513 m
.27156 .1513 L
s
.27163 .15177 m
.27163 .15177 L
s
.27171 .15248 m
.27171 .15248 L
s
.27177 .15271 m
.27177 .15271 L
s
.27185 .15342 m
.27185 .15342 L
s
.27192 .15318 m
.27192 .15318 L
s
.272 .15224 m
.272 .15224 L
s
.27207 .15248 m
.27207 .15248 L
s
.27215 .15318 m
.27215 .15318 L
s
.27222 .15482 m
.27222 .15482 L
s
.2723 .152 m
.2723 .152 L
s
.27237 .15412 m
.27237 .15412 L
s
.27245 .15224 m
.27245 .15224 L
s
.27252 .15318 m
.27252 .15318 L
s
.27259 .15295 m
.27259 .15295 L
s
.27267 .15271 m
.27267 .15271 L
s
.27274 .1506 m
.27274 .1506 L
s
.27282 .1513 m
.27282 .1513 L
s
.27289 .15083 m
.27289 .15083 L
s
.27297 .15248 m
.27297 .15248 L
s
.27304 .152 m
.27304 .152 L
s
.27312 .15154 m
.27312 .15154 L
s
.27319 .152 m
.27319 .152 L
s
.27327 .152 m
.27327 .152 L
s
.27334 .15224 m
.27334 .15224 L
s
.27341 .15248 m
.27341 .15248 L
s
.27348 .152 m
.27348 .152 L
s
.27356 .15435 m
.27356 .15435 L
s
.27363 .15482 m
.27363 .15482 L
s
.27371 .15482 m
.27371 .15482 L
s
.27378 .15342 m
.27378 .15342 L
s
.27386 .15248 m
.27386 .15248 L
s
.27393 .152 m
.27393 .152 L
s
.27401 .1506 m
.27401 .1506 L
s
.27408 .14943 m
.27408 .14943 L
s
.27416 .14943 m
.27416 .14943 L
s
.27423 .15036 m
.27423 .15036 L
s
.2743 .15013 m
.2743 .15013 L
s
.27438 .1513 m
.27438 .1513 L
s
.27445 .14989 m
.27445 .14989 L
s
.27453 .15036 m
.27453 .15036 L
s
.2746 .14989 m
.2746 .14989 L
s
.27468 .14989 m
.27468 .14989 L
s
.27475 .15013 m
.27475 .15013 L
s
.27483 .14919 m
.27483 .14919 L
s
.2749 .14919 m
.2749 .14919 L
s
.27497 .1506 m
.27497 .1506 L
s
.27504 .15013 m
.27504 .15013 L
s
.27512 .15083 m
.27512 .15083 L
s
.27519 .1513 m
.27519 .1513 L
s
.27527 .152 m
.27527 .152 L
s
.27534 .15435 m
.27534 .15435 L
s
.27542 .15506 m
.27542 .15506 L
s
.27549 .15389 m
.27549 .15389 L
s
.27557 .15224 m
.27557 .15224 L
s
.27564 .15154 m
.27564 .15154 L
s
.27572 .15036 m
.27572 .15036 L
s
.27579 .14943 m
.27579 .14943 L
s
.27586 .14825 m
.27586 .14825 L
s
.27594 .14661 m
.27594 .14661 L
s
.27601 .14661 m
.27601 .14661 L
s
.27609 .14778 m
.27609 .14778 L
s
.27616 .14778 m
.27616 .14778 L
s
.27624 .14754 m
.27624 .14754 L
s
.27631 .14848 m
.27631 .14848 L
s
.27639 .14637 m
.27639 .14637 L
s
.27646 .14754 m
.27646 .14754 L
s
.27654 .14567 m
.27654 .14567 L
s
.2766 .14707 m
.2766 .14707 L
s
.27668 .14661 m
.27668 .14661 L
s
.27675 .14614 m
.27675 .14614 L
s
.27683 .14661 m
.27683 .14661 L
s
.2769 .14496 m
.2769 .14496 L
s
.27698 .14684 m
.27698 .14684 L
s
.27705 .14496 m
.27705 .14496 L
s
.27713 .14567 m
.27713 .14567 L
s
.2772 .14567 m
.2772 .14567 L
s
.27728 .14519 m
.27728 .14519 L
s
.27736 .14449 m
.27736 .14449 L
s
.27742 .14355 m
.27742 .14355 L
s
.2775 .14238 m
.2775 .14238 L
s
.27757 .14332 m
.27757 .14332 L
s
.27765 .14355 m
.27765 .14355 L
s
.27772 .14308 m
.27772 .14308 L
s
.2778 .14402 m
.2778 .14402 L
s
.27787 .14261 m
.27787 .14261 L
s
.27794 .14143 m
.27794 .14143 L
s
.27802 .14214 m
.27802 .14214 L
s
.2781 .14402 m
.2781 .14402 L
s
.27817 .14402 m
.27817 .14402 L
s
.27824 .14402 m
.27824 .14402 L
s
.27831 .14425 m
.27831 .14425 L
s
.27839 .14214 m
.27839 .14214 L
s
.27846 .14238 m
.27846 .14238 L
s
.27854 .1419 m
.27854 .1419 L
s
.27861 .14285 m
.27861 .14285 L
s
.27869 .14214 m
.27869 .14214 L
s
.27876 .14238 m
.27876 .14238 L
s
.27883 .13933 m
.27883 .13933 L
s
.27891 .14026 m
.27891 .14026 L
s
.27899 .13979 m
.27899 .13979 L
s
.27906 .14097 m
.27906 .14097 L
s
.27913 .14073 m
.27913 .14073 L
s
.27921 .14003 m
.27921 .14003 L
s
.27928 .14073 m
.27928 .14073 L
s
.27936 .13956 m
.27936 .13956 L
s
.27943 .14073 m
.27943 .14073 L
s
.27951 .14026 m
.27951 .14026 L
s
.27957 .14026 m
.27957 .14026 L
s
.27965 .14214 m
.27965 .14214 L
s
.27973 .14355 m
.27973 .14355 L
s
.2798 .14425 m
.2798 .14425 L
s
.27987 .14379 m
.27987 .14379 L
s
.27995 .14614 m
.27995 .14614 L
s
.28002 .14707 m
.28002 .14707 L
s
.2801 .14848 m
.2801 .14848 L
s
.28017 .14801 m
.28017 .14801 L
s
.28025 .14919 m
.28025 .14919 L
s
.28032 .14919 m
.28032 .14919 L
s
.28039 .15036 m
.28039 .15036 L
s
.28047 .14919 m
.28047 .14919 L
s
.28054 .14848 m
.28054 .14848 L
s
.28062 .14895 m
.28062 .14895 L
s
.28069 .14848 m
.28069 .14848 L
s
.28077 .14943 m
.28077 .14943 L
s
.28084 .14825 m
.28084 .14825 L
s
.28092 .14943 m
.28092 .14943 L
s
.28099 .14872 m
.28099 .14872 L
s
.28107 .15013 m
.28107 .15013 L
s
.28114 .14966 m
.28114 .14966 L
s
.28121 .1513 m
.28121 .1513 L
s
.28128 .15154 m
.28128 .15154 L
s
.28136 .15107 m
.28136 .15107 L
s
.28144 .15083 m
.28144 .15083 L
s
.28151 .1513 m
.28151 .1513 L
s
.28158 .152 m
.28158 .152 L
s
.28166 .14989 m
.28166 .14989 L
s
.28173 .1506 m
.28173 .1506 L
s
.28181 .1506 m
.28181 .1506 L
s
.28188 .1506 m
.28188 .1506 L
s
.28196 .15107 m
.28196 .15107 L
s
.28203 .1513 m
.28203 .1513 L
s
.2821 .1506 m
.2821 .1506 L
s
.28218 .1513 m
.28218 .1513 L
s
.28225 .14943 m
.28225 .14943 L
s
.28233 .14895 m
.28233 .14895 L
s
.2824 .1513 m
.2824 .1513 L
s
.28248 .1506 m
.28248 .1506 L
s
.28255 .15036 m
.28255 .15036 L
s
.28263 .1513 m
.28263 .1513 L
s
.2827 .15389 m
.2827 .15389 L
s
.28277 .15389 m
.28277 .15389 L
s
.28284 .15435 m
.28284 .15435 L
s
.28292 .15318 m
.28292 .15318 L
s
.28299 .15506 m
.28299 .15506 L
s
.28307 .156 m
.28307 .156 L
s
.28314 .15671 m
.28314 .15671 L
s
.28322 .15647 m
.28322 .15647 L
s
.28329 .15624 m
.28329 .15624 L
s
.28337 .15671 m
.28337 .15671 L
s
.28344 .15412 m
.28344 .15412 L
s
.28352 .15389 m
.28352 .15389 L
s
.28359 .15365 m
.28359 .15365 L
s
.28366 .15553 m
.28366 .15553 L
s
.28374 .15553 m
.28374 .15553 L
s
.28381 .15553 m
.28381 .15553 L
s
.28389 .156 m
.28389 .156 L
s
.28396 .15576 m
.28396 .15576 L
s
.28404 .15553 m
.28404 .15553 L
s
.28411 .15553 m
.28411 .15553 L
s
.28419 .15506 m
.28419 .15506 L
s
.28426 .15295 m
.28426 .15295 L
s
.28434 .15365 m
.28434 .15365 L
s
.28441 .15435 m
.28441 .15435 L
s
.28448 .15459 m
.28448 .15459 L
s
.28455 .15318 m
.28455 .15318 L
s
.28463 .15248 m
.28463 .15248 L
s
.2847 .15224 m
.2847 .15224 L
s
.28478 .15224 m
.28478 .15224 L
s
.28485 .15318 m
.28485 .15318 L
s
.28493 .15271 m
.28493 .15271 L
s
.285 .15435 m
.285 .15435 L
s
.28508 .15318 m
.28508 .15318 L
s
.28516 .15342 m
.28516 .15342 L
s
.28522 .15295 m
.28522 .15295 L
s
.2853 .15482 m
.2853 .15482 L
s
.28537 .15459 m
.28537 .15459 L
s
.28545 .15506 m
.28545 .15506 L
s
.28552 .15506 m
.28552 .15506 L
s
.2856 .156 m
.2856 .156 L
s
.28567 .15788 m
.28567 .15788 L
s
.28574 .15764 m
.28574 .15764 L
s
.28582 .15976 m
.28582 .15976 L
s
.2859 .1607 m
.2859 .1607 L
s
.28597 .16117 m
.28597 .16117 L
s
.28604 .15976 m
.28604 .15976 L
s
.28611 .15858 m
.28611 .15858 L
s
.28619 .15835 m
.28619 .15835 L
s
.28626 .15811 m
.28626 .15811 L
s
.28634 .15717 m
.28634 .15717 L
s
.28641 .156 m
.28641 .156 L
s
.28649 .15694 m
.28649 .15694 L
s
.28656 .15553 m
.28656 .15553 L
s
.28664 .156 m
.28664 .156 L
s
.28672 .15553 m
.28672 .15553 L
s
.28679 .15671 m
.28679 .15671 L
s
.28686 .15576 m
.28686 .15576 L
s
.28693 .15694 m
.28693 .15694 L
s
.28701 .15741 m
.28701 .15741 L
s
.28708 .156 m
.28708 .156 L
s
.28716 .15694 m
.28716 .15694 L
s
.28723 .15647 m
.28723 .15647 L
s
.28731 .15694 m
.28731 .15694 L
s
.28738 .15624 m
.28738 .15624 L
s
.28745 .15671 m
.28745 .15671 L
s
.28753 .15647 m
.28753 .15647 L
s
.2876 .15717 m
.2876 .15717 L
s
.28767 .15694 m
.28767 .15694 L
s
.28775 .15717 m
.28775 .15717 L
s
.28782 .156 m
.28782 .156 L
s
.2879 .15553 m
.2879 .15553 L
s
.28797 .15506 m
.28797 .15506 L
s
.28805 .15435 m
.28805 .15435 L
s
.28812 .15506 m
.28812 .15506 L
s
.28819 .15342 m
.28819 .15342 L
s
.28827 .15482 m
.28827 .15482 L
s
.28835 .15459 m
.28835 .15459 L
s
.28842 .15412 m
.28842 .15412 L
s
.28849 .15389 m
.28849 .15389 L
s
.28857 .15412 m
.28857 .15412 L
s
.28864 .15506 m
.28864 .15506 L
s
.28872 .15482 m
.28872 .15482 L
s
.28879 .15576 m
.28879 .15576 L
s
.28887 .15506 m
.28887 .15506 L
s
.28894 .15529 m
.28894 .15529 L
s
.28901 .15482 m
.28901 .15482 L
s
.28908 .15529 m
.28908 .15529 L
s
.28916 .15506 m
.28916 .15506 L
s
.28924 .15553 m
.28924 .15553 L
s
.28931 .15412 m
.28931 .15412 L
s
.28938 .15482 m
.28938 .15482 L
s
.28946 .15624 m
.28946 .15624 L
s
.28953 .15647 m
.28953 .15647 L
s
.28961 .15671 m
.28961 .15671 L
s
.28968 .156 m
.28968 .156 L
s
.28976 .15576 m
.28976 .15576 L
s
.28983 .156 m
.28983 .156 L
s
.2899 .15529 m
.2899 .15529 L
s
.28998 .15529 m
.28998 .15529 L
s
.29005 .15506 m
.29005 .15506 L
s
.29013 .15506 m
.29013 .15506 L
s
.2902 .15553 m
.2902 .15553 L
s
.29028 .15435 m
.29028 .15435 L
s
.29035 .15389 m
.29035 .15389 L
s
.29043 .15576 m
.29043 .15576 L
s
.2905 .15553 m
.2905 .15553 L
s
.29057 .15741 m
.29057 .15741 L
s
.29064 .156 m
.29064 .156 L
s
.29072 .15788 m
.29072 .15788 L
s
.29079 .15953 m
.29079 .15953 L
s
.29087 .15953 m
.29087 .15953 L
s
.29094 .15741 m
.29094 .15741 L
s
.29102 .15764 m
.29102 .15764 L
s
.29109 .15671 m
.29109 .15671 L
s
.29117 .15764 m
.29117 .15764 L
s
.29124 .15671 m
.29124 .15671 L
s
.29132 .15576 m
.29132 .15576 L
s
.29139 .15576 m
.29139 .15576 L
s
.29146 .15506 m
.29146 .15506 L
s
.29154 .15576 m
.29154 .15576 L
s
.29161 .15459 m
.29161 .15459 L
s
.29169 .15412 m
.29169 .15412 L
s
.29176 .15271 m
.29176 .15271 L
s
.29184 .15295 m
.29184 .15295 L
s
.29191 .15389 m
.29191 .15389 L
s
.29199 .15459 m
.29199 .15459 L
s
.29206 .15671 m
.29206 .15671 L
s
.29214 .15647 m
.29214 .15647 L
s
.29221 .15717 m
.29221 .15717 L
s
.29228 .156 m
.29228 .156 L
s
.29235 .15741 m
.29235 .15741 L
s
.29243 .15506 m
.29243 .15506 L
s
.2925 .15435 m
.2925 .15435 L
s
.29258 .15295 m
.29258 .15295 L
s
.29265 .15271 m
.29265 .15271 L
s
.29273 .15177 m
.29273 .15177 L
s
.2928 .15036 m
.2928 .15036 L
s
.29288 .15036 m
.29288 .15036 L
s
.29296 .14966 m
.29296 .14966 L
s
.29302 .14989 m
.29302 .14989 L
s
.2931 .14943 m
.2931 .14943 L
s
.29317 .14943 m
.29317 .14943 L
s
.29325 .14895 m
.29325 .14895 L
s
.29332 .14989 m
.29332 .14989 L
s
.2934 .14943 m
.2934 .14943 L
s
.29347 .14919 m
.29347 .14919 L
s
.29355 .14825 m
.29355 .14825 L
s
.29362 .14872 m
.29362 .14872 L
s
.2937 .14801 m
.2937 .14801 L
s
.29377 .14731 m
.29377 .14731 L
s
.29384 .14943 m
.29384 .14943 L
s
.29391 .15083 m
.29391 .15083 L
s
.29399 .1513 m
.29399 .1513 L
s
.29406 .14989 m
.29406 .14989 L
s
.29414 .14848 m
.29414 .14848 L
s
.29421 .14707 m
.29421 .14707 L
s
.29429 .14731 m
.29429 .14731 L
s
.29436 .14731 m
.29436 .14731 L
s
.29444 .14731 m
.29444 .14731 L
s
.29452 .14895 m
.29452 .14895 L
s
.29459 .14754 m
.29459 .14754 L
s
.29466 .14825 m
.29466 .14825 L
s
.29473 .14731 m
.29473 .14731 L
s
.29481 .14684 m
.29481 .14684 L
s
.29488 .14661 m
.29488 .14661 L
s
.29496 .14707 m
.29496 .14707 L
s
.29503 .14895 m
.29503 .14895 L
s
.29511 .15036 m
.29511 .15036 L
s
.29518 .15107 m
.29518 .15107 L
s
.29526 .1513 m
.29526 .1513 L
s
.29533 .15154 m
.29533 .15154 L
s
.2954 .14943 m
.2954 .14943 L
s
.29547 .15036 m
.29547 .15036 L
s
.29555 .14966 m
.29555 .14966 L
s
.29562 .14989 m
.29562 .14989 L
s
.2957 .14825 m
.2957 .14825 L
s
.29577 .14754 m
.29577 .14754 L
s
.29585 .14614 m
.29585 .14614 L
s
.29592 .14661 m
.29592 .14661 L
s
.29599 .1459 m
.29599 .1459 L
s
.29607 .14472 m
.29607 .14472 L
s
.29615 .14614 m
.29615 .14614 L
s
.29622 .14614 m
.29622 .14614 L
s
.29629 .14684 m
.29629 .14684 L
s
.29637 .14519 m
.29637 .14519 L
s
.29644 .14661 m
.29644 .14661 L
s
.29652 .14567 m
.29652 .14567 L
s
.29659 .14472 m
.29659 .14472 L
s
.29667 .14614 m
.29667 .14614 L
s
.29674 .14614 m
.29674 .14614 L
s
.29681 .14637 m
.29681 .14637 L
s
.29689 .14614 m
.29689 .14614 L
s
.29697 .14778 m
.29697 .14778 L
s
.29704 .14567 m
.29704 .14567 L
s
.29711 .14567 m
.29711 .14567 L
s
.29718 .14496 m
.29718 .14496 L
s
.29726 .1459 m
.29726 .1459 L
s
.29733 .14614 m
.29733 .14614 L
s
.29741 .14543 m
.29741 .14543 L
s
.29748 .14496 m
.29748 .14496 L
s
.29756 .14472 m
.29756 .14472 L
s
.29763 .14496 m
.29763 .14496 L
s
.2977 .14543 m
.2977 .14543 L
s
.29778 .14731 m
.29778 .14731 L
s
.29785 .14567 m
.29785 .14567 L
s
.29793 .14496 m
.29793 .14496 L
s
.298 .14614 m
.298 .14614 L
s
.29808 .14825 m
.29808 .14825 L
s
.29815 .14801 m
.29815 .14801 L
s
.29823 .14848 m
.29823 .14848 L
s
.2983 .14943 m
.2983 .14943 L
s
.29837 .14919 m
.29837 .14919 L
s
.29844 .14895 m
.29844 .14895 L
s
.29852 .14825 m
.29852 .14825 L
s
.2986 .14848 m
.2986 .14848 L
s
.29867 .14707 m
.29867 .14707 L
s
.29874 .14731 m
.29874 .14731 L
s
.29882 .14614 m
.29882 .14614 L
s
.29889 .14637 m
.29889 .14637 L
s
.29897 .14449 m
.29897 .14449 L
s
.29904 .14567 m
.29904 .14567 L
s
.29912 .14519 m
.29912 .14519 L
s
.29919 .14519 m
.29919 .14519 L
s
.29926 .1459 m
.29926 .1459 L
s
.29934 .1459 m
.29934 .1459 L
s
.29941 .14684 m
.29941 .14684 L
s
.29949 .14543 m
.29949 .14543 L
s
.29956 .14614 m
.29956 .14614 L
s
.29964 .14519 m
.29964 .14519 L
s
.29971 .14661 m
.29971 .14661 L
s
.29979 .14614 m
.29979 .14614 L
s
.29986 .14731 m
.29986 .14731 L
s
.29994 .14754 m
.29994 .14754 L
s
.30001 .14684 m
.30001 .14684 L
s
.30008 .14825 m
.30008 .14825 L
s
.30015 .14848 m
.30015 .14848 L
s
.30023 .14943 m
.30023 .14943 L
s
.3003 .15013 m
.3003 .15013 L
s
.30038 .15271 m
.30038 .15271 L
s
.30045 .15224 m
.30045 .15224 L
s
.30053 .15248 m
.30053 .15248 L
s
.3006 .152 m
.3006 .152 L
s
.30068 .15224 m
.30068 .15224 L
s
.30076 .15224 m
.30076 .15224 L
s
.30082 .15154 m
.30082 .15154 L
s
.3009 .15389 m
.3009 .15389 L
s
.30097 .15083 m
.30097 .15083 L
s
.30105 .15013 m
.30105 .15013 L
s
.30112 .14966 m
.30112 .14966 L
s
.3012 .15107 m
.3012 .15107 L
s
.30127 .14895 m
.30127 .14895 L
s
.30135 .15013 m
.30135 .15013 L
s
.30142 .15013 m
.30142 .15013 L
s
.3015 .1513 m
.3015 .1513 L
s
.30157 .15342 m
.30157 .15342 L
s
.30164 .1513 m
.30164 .1513 L
s
.30171 .15177 m
.30171 .15177 L
s
.30179 .15036 m
.30179 .15036 L
s
.30186 .15154 m
.30186 .15154 L
s
.30194 .15083 m
.30194 .15083 L
s
.30201 .15224 m
.30201 .15224 L
s
.30209 .15154 m
.30209 .15154 L
s
.30216 .15154 m
.30216 .15154 L
s
.30224 .15177 m
.30224 .15177 L
s
.30232 .15177 m
.30232 .15177 L
s
.30239 .15295 m
.30239 .15295 L
s
.30246 .15295 m
.30246 .15295 L
s
.30253 .15271 m
.30253 .15271 L
s
.30261 .15248 m
.30261 .15248 L
s
.30268 .15295 m
.30268 .15295 L
s
.30276 .15318 m
.30276 .15318 L
s
.30283 .15318 m
.30283 .15318 L
s
.30291 .15224 m
.30291 .15224 L
s
.30298 .15342 m
.30298 .15342 L
s
.30306 .15224 m
.30306 .15224 L
s
.30313 .15177 m
.30313 .15177 L
s
.3032 .15177 m
.3032 .15177 L
s
.30327 .152 m
.30327 .152 L
s
.30335 .15295 m
.30335 .15295 L
s
.30342 .15459 m
.30342 .15459 L
s
.3035 .15529 m
.3035 .15529 L
s
.30357 .15482 m
.30357 .15482 L
s
.30365 .15459 m
.30365 .15459 L
s
.30372 .15412 m
.30372 .15412 L
s
.3038 .15482 m
.3038 .15482 L
s
.30388 .156 m
.30388 .156 L
s
.30395 .15694 m
.30395 .15694 L
s
.30402 .15624 m
.30402 .15624 L
s
.30409 .15671 m
.30409 .15671 L
s
.30417 .15717 m
.30417 .15717 L
s
.30424 .156 m
.30424 .156 L
s
.30432 .15647 m
.30432 .15647 L
s
.30439 .15647 m
.30439 .15647 L
s
.30447 .15694 m
.30447 .15694 L
s
.30454 .15576 m
.30454 .15576 L
s
.30461 .156 m
.30461 .156 L
s
.30469 .15671 m
.30469 .15671 L
s
.30477 .15647 m
.30477 .15647 L
s
.30484 .15717 m
.30484 .15717 L
s
.30491 .15647 m
.30491 .15647 L
s
.30498 .156 m
.30498 .156 L
s
.30506 .15529 m
.30506 .15529 L
s
.30513 .15741 m
.30513 .15741 L
s
.30521 .15741 m
.30521 .15741 L
s
.30528 .15717 m
.30528 .15717 L
s
.30536 .156 m
.30536 .156 L
s
.30543 .15529 m
.30543 .15529 L
s
.30551 .15647 m
.30551 .15647 L
s
.30559 .15647 m
.30559 .15647 L
s
.30565 .15717 m
.30565 .15717 L
s
.30573 .15459 m
.30573 .15459 L
s
.3058 .15647 m
.3058 .15647 L
s
.30588 .15529 m
.30588 .15529 L
s
.30595 .15482 m
.30595 .15482 L
s
.30603 .15435 m
.30603 .15435 L
s
.3061 .15389 m
.3061 .15389 L
s
.30617 .15506 m
.30617 .15506 L
s
.30624 .15412 m
.30624 .15412 L
s
.30632 .15389 m
.30632 .15389 L
s
.3064 .15506 m
.3064 .15506 L
s
.30647 .15576 m
.30647 .15576 L
s
.30654 .15647 m
.30654 .15647 L
s
.30662 .15647 m
.30662 .15647 L
s
.30669 .15624 m
.30669 .15624 L
s
.30677 .156 m
.30677 .156 L
s
.30684 .15553 m
.30684 .15553 L
s
.30692 .15412 m
.30692 .15412 L
s
.30699 .15295 m
.30699 .15295 L
s
.30706 .15365 m
.30706 .15365 L
s
.30714 .15435 m
.30714 .15435 L
s
.30722 .15506 m
.30722 .15506 L
s
.30729 .15576 m
.30729 .15576 L
s
.30736 .15365 m
.30736 .15365 L
s
.30744 .15435 m
.30744 .15435 L
s
.30751 .15459 m
.30751 .15459 L
s
.30759 .15624 m
.30759 .15624 L
s
.30766 .15624 m
.30766 .15624 L
s
.30774 .15717 m
.30774 .15717 L
s
.30781 .15694 m
.30781 .15694 L
s
.30788 .15741 m
.30788 .15741 L
s
.30795 .15694 m
.30795 .15694 L
s
.30803 .15741 m
.30803 .15741 L
s
.3081 .15835 m
.3081 .15835 L
s
.30818 .15741 m
.30818 .15741 L
s
.30825 .15835 m
.30825 .15835 L
s
.30833 .15858 m
.30833 .15858 L
s
.3084 .15999 m
.3084 .15999 L
s
.30848 .1614 m
.30848 .1614 L
s
.30856 .1614 m
.30856 .1614 L
s
.30862 .1614 m
.30862 .1614 L
s
.3087 .15999 m
.3087 .15999 L
s
.30877 .16023 m
.30877 .16023 L
s
.30885 .15999 m
.30885 .15999 L
s
.30892 .1621 m
.30892 .1621 L
s
.309 .16046 m
.309 .16046 L
s
.30907 .15953 m
.30907 .15953 L
s
.30915 .15835 m
.30915 .15835 L
s
.30922 .15882 m
.30922 .15882 L
s
.3093 .15953 m
.3093 .15953 L
s
.30937 .15882 m
.30937 .15882 L
s
.30944 .15953 m
.30944 .15953 L
s
.30951 .15953 m
.30951 .15953 L
s
.30959 .15905 m
.30959 .15905 L
s
.30966 .15694 m
.30966 .15694 L
s
.30974 .15788 m
.30974 .15788 L
s
.30981 .15717 m
.30981 .15717 L
s
.30989 .15788 m
.30989 .15788 L
s
.30996 .15764 m
.30996 .15764 L
s
.31004 .15529 m
.31004 .15529 L
s
.31012 .15482 m
.31012 .15482 L
s
.31019 .156 m
.31019 .156 L
s
.31026 .15624 m
.31026 .15624 L
s
.31033 .15647 m
.31033 .15647 L
s
.31041 .15741 m
.31041 .15741 L
s
.31048 .15929 m
.31048 .15929 L
s
.31056 .16046 m
.31056 .16046 L
s
.31063 .15953 m
.31063 .15953 L
s
.31071 .16258 m
.31071 .16258 L
s
.31078 .16234 m
.31078 .16234 L
s
.31086 .16258 m
.31086 .16258 L
s
.31093 .16281 m
.31093 .16281 L
s
.311 .16328 m
.311 .16328 L
s
.31107 .16258 m
.31107 .16258 L
s
.31115 .16258 m
.31115 .16258 L
s
.31122 .16445 m
.31122 .16445 L
s
.3113 .16399 m
.3113 .16399 L
s
.31137 .16516 m
.31137 .16516 L
s
.31145 .16586 m
.31145 .16586 L
s
.31152 .16539 m
.31152 .16539 L
s
.3116 .16586 m
.3116 .16586 L
s
.31168 .16586 m
.31168 .16586 L
s
.31175 .16422 m
.31175 .16422 L
s
.31182 .16352 m
.31182 .16352 L
s
.31189 .16305 m
.31189 .16305 L
s
.31197 .16305 m
.31197 .16305 L
s
.31204 .16539 m
.31204 .16539 L
s
.31212 .16422 m
.31212 .16422 L
s
.31219 .16539 m
.31219 .16539 L
s
.31227 .16563 m
.31227 .16563 L
s
.31234 .16634 m
.31234 .16634 L
s
.31242 .16586 m
.31242 .16586 L
s
.31249 .16492 m
.31249 .16492 L
s
.31257 .16586 m
.31257 .16586 L
s
.31264 .16563 m
.31264 .16563 L
s
.31271 .16586 m
.31271 .16586 L
s
.31278 .16681 m
.31278 .16681 L
s
.31286 .16727 m
.31286 .16727 L
s
.31293 .16704 m
.31293 .16704 L
s
.31301 .16939 m
.31301 .16939 L
s
.31308 .16821 m
.31308 .16821 L
s
.31316 .16986 m
.31316 .16986 L
s
.31323 .17009 m
.31323 .17009 L
s
.31331 .16963 m
.31331 .16963 L
s
.31339 .1715 m
.31339 .1715 L
s
.31345 .17174 m
.31345 .17174 L
s
.31353 .17197 m
.31353 .17197 L
s
.3136 .17362 m
.3136 .17362 L
s
.31368 .17385 m
.31368 .17385 L
s
.31375 .17291 m
.31375 .17291 L
s
.31383 .17385 m
.31383 .17385 L
s
.3139 .17291 m
.3139 .17291 L
s
.31397 .17338 m
.31397 .17338 L
s
.31405 .17174 m
.31405 .17174 L
s
.31413 .17315 m
.31413 .17315 L
s
.3142 .17338 m
.3142 .17338 L
s
.31427 .17432 m
.31427 .17432 L
s
.31434 .17409 m
.31434 .17409 L
s
.31442 .17197 m
.31442 .17197 L
s
.31449 .17432 m
.31449 .17432 L
s
.31457 .17291 m
.31457 .17291 L
s
.31464 .17362 m
.31464 .17362 L
s
.31472 .17338 m
.31472 .17338 L
s
.31479 .17338 m
.31479 .17338 L
s
.31486 .17479 m
.31486 .17479 L
s
.31494 .17479 m
.31494 .17479 L
s
.31502 .17526 m
.31502 .17526 L
s
.31509 .1762 m
.31509 .1762 L
s
.31516 .17644 m
.31516 .17644 L
s
.31524 .1762 m
.31524 .1762 L
s
.31531 .17573 m
.31531 .17573 L
s
.31539 .17502 m
.31539 .17502 L
s
.31546 .17667 m
.31546 .17667 L
s
.31554 .1762 m
.31554 .1762 L
s
.31561 .17714 m
.31561 .17714 L
s
.31568 .17691 m
.31568 .17691 L
s
.31576 .17808 m
.31576 .17808 L
s
.31584 .17831 m
.31584 .17831 L
s
.3159 .17644 m
.3159 .17644 L
s
.31598 .17644 m
.31598 .17644 L
s
.31605 .17479 m
.31605 .17479 L
s
.31613 .17549 m
.31613 .17549 L
s
.3162 .17315 m
.3162 .17315 L
s
.31628 .17244 m
.31628 .17244 L
s
.31636 .17291 m
.31636 .17291 L
s
.31642 .17244 m
.31642 .17244 L
s
.3165 .17197 m
.3165 .17197 L
s
.31657 .17267 m
.31657 .17267 L
s
.31665 .17291 m
.31665 .17291 L
s
.31672 .17338 m
.31672 .17338 L
s
.3168 .17432 m
.3168 .17432 L
s
.31687 .17409 m
.31687 .17409 L
s
.31695 .17338 m
.31695 .17338 L
s
.31702 .17197 m
.31702 .17197 L
s
.3171 .17362 m
.3171 .17362 L
s
.31717 .17291 m
.31717 .17291 L
s
.31724 .17267 m
.31724 .17267 L
s
.31731 .17267 m
.31731 .17267 L
s
.31739 .17244 m
.31739 .17244 L
s
.31747 .17291 m
.31747 .17291 L
s
.31754 .17385 m
.31754 .17385 L
s
.31761 .17338 m
.31761 .17338 L
s
.31769 .17267 m
.31769 .17267 L
s
.31776 .17315 m
.31776 .17315 L
s
.31784 .1722 m
.31784 .1722 L
s
.31792 .17315 m
.31792 .17315 L
s
.31799 .17267 m
.31799 .17267 L
s
.31806 .17385 m
.31806 .17385 L
s
.31813 .17338 m
.31813 .17338 L
s
.31821 .17479 m
.31821 .17479 L
s
.31828 .17479 m
.31828 .17479 L
s
.31836 .17479 m
.31836 .17479 L
s
.31843 .17573 m
.31843 .17573 L
s
.31851 .17596 m
.31851 .17596 L
s
.31858 .17738 m
.31858 .17738 L
s
.31866 .17526 m
.31866 .17526 L
s
.31873 .17573 m
.31873 .17573 L
s
.31881 .17338 m
.31881 .17338 L
s
.31887 .17385 m
.31887 .17385 L
s
.31895 .17291 m
.31895 .17291 L
s
.31902 .17432 m
.31902 .17432 L
s
.3191 .17526 m
.3191 .17526 L
s
.31917 .17549 m
.31917 .17549 L
s
.31925 .17409 m
.31925 .17409 L
s
.31932 .1722 m
.31932 .1722 L
s
.3194 .17338 m
.3194 .17338 L
s
.31948 .17291 m
.31948 .17291 L
s
.31955 .17456 m
.31955 .17456 L
s
.31962 .17432 m
.31962 .17432 L
s
.31969 .17526 m
.31969 .17526 L
s
.31977 .17385 m
.31977 .17385 L
s
.31984 .17456 m
.31984 .17456 L
s
.31992 .17479 m
.31992 .17479 L
s
.31999 .17596 m
.31999 .17596 L
s
.32007 .17761 m
.32007 .17761 L
s
.32014 .17573 m
.32014 .17573 L
s
.32022 .17549 m
.32022 .17549 L
s
.32029 .17432 m
.32029 .17432 L
s
.32037 .17502 m
.32037 .17502 L
s
.32044 .17526 m
.32044 .17526 L
s
.32051 .17502 m
.32051 .17502 L
s
.32058 .17526 m
.32058 .17526 L
s
.32066 .17549 m
.32066 .17549 L
s
.32073 .17596 m
.32073 .17596 L
s
.32081 .17573 m
.32081 .17573 L
s
.32088 .17691 m
.32088 .17691 L
s
.32096 .17761 m
.32096 .17761 L
s
.32103 .17738 m
.32103 .17738 L
s
.32111 .17902 m
.32111 .17902 L
s
.32119 .1809 m
.32119 .1809 L
s
.32125 .17948 m
.32125 .17948 L
s
.32133 .1809 m
.32133 .1809 L
s
.3214 .1809 m
.3214 .1809 L
s
.32148 .18137 m
.32148 .18137 L
s
.32155 .18066 m
.32155 .18066 L
s
.32163 .1809 m
.32163 .1809 L
s
.3217 .18277 m
.3217 .18277 L
s
.32178 .1809 m
.32178 .1809 L
s
.32185 .18301 m
.32185 .18301 L
s
.32193 .18277 m
.32193 .18277 L
s
.322 .18419 m
.322 .18419 L
s
.32207 .18348 m
.32207 .18348 L
s
.32214 .18395 m
.32214 .18395 L
s
.32222 .18372 m
.32222 .18372 L
s
.32229 .18277 m
.32229 .18277 L
s
.32237 .18419 m
.32237 .18419 L
s
.32244 .1823 m
.32244 .1823 L
s
.32252 .18254 m
.32252 .18254 L
s
.32259 .18113 m
.32259 .18113 L
s
.32267 .18372 m
.32267 .18372 L
s
.32274 .18137 m
.32274 .18137 L
s
.32282 .18113 m
.32282 .18113 L
s
.32289 .1809 m
.32289 .1809 L
s
.32296 .1816 m
.32296 .1816 L
s
.32304 .18184 m
.32304 .18184 L
s
.32311 .18277 m
.32311 .18277 L
s
.32319 .18325 m
.32319 .18325 L
s
.32326 .1823 m
.32326 .1823 L
s
.32334 .18419 m
.32334 .18419 L
s
.32341 .18395 m
.32341 .18395 L
s
.32348 .18442 m
.32348 .18442 L
s
.32356 .18348 m
.32356 .18348 L
s
.32364 .18372 m
.32364 .18372 L
s
.3237 .18348 m
.3237 .18348 L
s
.32378 .18301 m
.32378 .18301 L
s
.32385 .18348 m
.32385 .18348 L
s
.32393 .18372 m
.32393 .18372 L
s
.324 .18395 m
.324 .18395 L
s
.32408 .18395 m
.32408 .18395 L
s
.32416 .18466 m
.32416 .18466 L
s
.32422 .18395 m
.32422 .18395 L
s
.3243 .18442 m
.3243 .18442 L
s
.32437 .18583 m
.32437 .18583 L
s
.32445 .18583 m
.32445 .18583 L
s
.32452 .18466 m
.32452 .18466 L
s
.3246 .18395 m
.3246 .18395 L
s
.32467 .18466 m
.32467 .18466 L
s
.32475 .18536 m
.32475 .18536 L
s
.32482 .18654 m
.32482 .18654 L
s
.3249 .18654 m
.3249 .18654 L
s
.32497 .18748 m
.32497 .18748 L
s
.32504 .18771 m
.32504 .18771 L
s
.32511 .18888 m
.32511 .18888 L
s
.32519 .18724 m
.32519 .18724 L
s
.32527 .18748 m
.32527 .18748 L
s
.32534 .18701 m
.32534 .18701 L
s
.32541 .18841 m
.32541 .18841 L
s
.32549 .18748 m
.32549 .18748 L
s
.32556 .18748 m
.32556 .18748 L
s
.32564 .18748 m
.32564 .18748 L
s
.32572 .18677 m
.32572 .18677 L
s
.32579 .18701 m
.32579 .18701 L
s
.32586 .18536 m
.32586 .18536 L
s
.32593 .18489 m
.32593 .18489 L
s
.32601 .18466 m
.32601 .18466 L
s
.32608 .18559 m
.32608 .18559 L
s
.32616 .18536 m
.32616 .18536 L
s
.32623 .1823 m
.32623 .1823 L
s
.32631 .18395 m
.32631 .18395 L
s
.32638 .18348 m
.32638 .18348 L
s
.32646 .18512 m
.32646 .18512 L
s
.32653 .18512 m
.32653 .18512 L
s
.32661 .18536 m
.32661 .18536 L
s
.32667 .18348 m
.32667 .18348 L
s
.32675 .18606 m
.32675 .18606 L
s
.32682 .18466 m
.32682 .18466 L
s
.3269 .18559 m
.3269 .18559 L
s
.32697 .18395 m
.32697 .18395 L
s
.32705 .18466 m
.32705 .18466 L
s
.32712 .1823 m
.32712 .1823 L
s
.3272 .18207 m
.3272 .18207 L
s
.32728 .1823 m
.32728 .1823 L
s
.32735 .17973 m
.32735 .17973 L
s
.32742 .17925 m
.32742 .17925 L
s
.32749 .17784 m
.32749 .17784 L
s
.32757 .17948 m
.32757 .17948 L
s
.32764 .17902 m
.32764 .17902 L
s
.32772 .17878 m
.32772 .17878 L
s
.32779 .17855 m
.32779 .17855 L
s
.32787 .17784 m
.32787 .17784 L
s
.32794 .17855 m
.32794 .17855 L
s
.32802 .17738 m
.32802 .17738 L
s
.32809 .17808 m
.32809 .17808 L
s
.32817 .17925 m
.32817 .17925 L
s
.32824 .18207 m
.32824 .18207 L
s
.32831 .1816 m
.32831 .1816 L
s
.32838 .1809 m
.32838 .1809 L
s
.32846 .17996 m
.32846 .17996 L
s
.32853 .18043 m
.32853 .18043 L
s
.32861 .18184 m
.32861 .18184 L
s
.32868 .18489 m
.32868 .18489 L
s
.32876 .18701 m
.32876 .18701 L
s
.32884 .18701 m
.32884 .18701 L
s
.32891 .18794 m
.32891 .18794 L
s
.32899 .18559 m
.32899 .18559 L
s
.32905 .18536 m
.32905 .18536 L
s
.32913 .18277 m
.32913 .18277 L
s
.3292 .18419 m
.3292 .18419 L
s
.32928 .18489 m
.32928 .18489 L
s
.32935 .18442 m
.32935 .18442 L
s
.32943 .18301 m
.32943 .18301 L
s
.3295 .18137 m
.3295 .18137 L
s
.32958 .1823 m
.32958 .1823 L
s
.32965 .17996 m
.32965 .17996 L
s
.32973 .1802 m
.32973 .1802 L
s
.3298 .17925 m
.3298 .17925 L
s
.32987 .17831 m
.32987 .17831 L
s
.32994 .17667 m
.32994 .17667 L
s
.33002 .17667 m
.33002 .17667 L
s
.33009 .17549 m
.33009 .17549 L
s
.33017 .17667 m
.33017 .17667 L
s
.33024 .17784 m
.33024 .17784 L
s
.33032 .17761 m
.33032 .17761 L
s
.33039 .17808 m
.33039 .17808 L
s
.33047 .17738 m
.33047 .17738 L
s
.33055 .17808 m
.33055 .17808 L
s
.33062 .17808 m
.33062 .17808 L
s
.33069 .17878 m
.33069 .17878 L
s
.33076 .17691 m
.33076 .17691 L
s
.33084 .17667 m
.33084 .17667 L
s
.33091 .17714 m
.33091 .17714 L
s
.33099 .17691 m
.33099 .17691 L
s
.33106 .17855 m
.33106 .17855 L
s
.33114 .17831 m
.33114 .17831 L
s
.33121 .17925 m
.33121 .17925 L
s
.33128 .17831 m
.33128 .17831 L
s
.33136 .17808 m
.33136 .17808 L
s
.33144 .17644 m
.33144 .17644 L
s
.3315 .17878 m
.3315 .17878 L
s
.33158 .17831 m
.33158 .17831 L
s
.33165 .17784 m
.33165 .17784 L
s
.33173 .17761 m
.33173 .17761 L
s
.3318 .17902 m
.3318 .17902 L
s
.33188 .17973 m
.33188 .17973 L
s
.33196 .17925 m
.33196 .17925 L
s
.33202 .17902 m
.33202 .17902 L
s
.3321 .17573 m
.3321 .17573 L
s
.33218 .17596 m
.33218 .17596 L
s
.33225 .17526 m
.33225 .17526 L
s
.33232 .17338 m
.33232 .17338 L
s
.3324 .17127 m
.3324 .17127 L
s
.33247 .17056 m
.33247 .17056 L
s
.33255 .17174 m
.33255 .17174 L
s
.33262 .17267 m
.33262 .17267 L
s
.3327 .1722 m
.3327 .1722 L
s
.33277 .17197 m
.33277 .17197 L
s
.33284 .17267 m
.33284 .17267 L
s
.33291 .17174 m
.33291 .17174 L
s
.33299 .17315 m
.33299 .17315 L
s
.33307 .17174 m
.33307 .17174 L
s
.33314 .1722 m
.33314 .1722 L
s
.33321 .17127 m
.33321 .17127 L
s
.33329 .17174 m
.33329 .17174 L
s
.33336 .17338 m
.33336 .17338 L
s
.33344 .17174 m
.33344 .17174 L
s
.33352 .17338 m
.33352 .17338 L
s
.33359 .17385 m
.33359 .17385 L
s
.33366 .17526 m
.33366 .17526 L
s
.33373 .1715 m
.33373 .1715 L
s
.33381 .17174 m
.33381 .17174 L
s
.33388 .1715 m
.33388 .1715 L
s
.33396 .17409 m
.33396 .17409 L
s
.33403 .17315 m
.33403 .17315 L
s
.33411 .17432 m
.33411 .17432 L
s
.33418 .17315 m
.33418 .17315 L
s
.33426 .17432 m
.33426 .17432 L
s
.33433 .17385 m
.33433 .17385 L
s
.33441 .17244 m
.33441 .17244 L
s
.33447 .17197 m
.33447 .17197 L
s
.33455 .17103 m
.33455 .17103 L
s
.33462 .17103 m
.33462 .17103 L
s
.3347 .1708 m
.3347 .1708 L
s
.33477 .16986 m
.33477 .16986 L
s
.33485 .16798 m
.33485 .16798 L
s
.33492 .16751 m
.33492 .16751 L
s
.335 .16868 m
.335 .16868 L
s
.33508 .16774 m
.33508 .16774 L
s
.33515 .16798 m
.33515 .16798 L
s
.33522 .16845 m
.33522 .16845 L
s
.33529 .16892 m
.33529 .16892 L
s
.33537 .16892 m
.33537 .16892 L
s
.33544 .16963 m
.33544 .16963 L
s
.33552 .16821 m
.33552 .16821 L
s
.33559 .16868 m
.33559 .16868 L
s
.33567 .17009 m
.33567 .17009 L
s
.33574 .17174 m
.33574 .17174 L
s
.33582 .1708 m
.33582 .1708 L
s
.33589 .17197 m
.33589 .17197 L
s
.33597 .17315 m
.33597 .17315 L
s
.33604 .17338 m
.33604 .17338 L
s
.33611 .17291 m
.33611 .17291 L
s
.33618 .1722 m
.33618 .1722 L
s
.33626 .17244 m
.33626 .17244 L
s
.33633 .17127 m
.33633 .17127 L
s
.33641 .17009 m
.33641 .17009 L
s
.33648 .16963 m
.33648 .16963 L
s
.33656 .16915 m
.33656 .16915 L
s
.33664 .16939 m
.33664 .16939 L
s
.33671 .17056 m
.33671 .17056 L
s
.33679 .16868 m
.33679 .16868 L
s
.33685 .16704 m
.33685 .16704 L
s
.33693 .16492 m
.33693 .16492 L
s
.337 .16399 m
.337 .16399 L
s
.33708 .16657 m
.33708 .16657 L
s
.33715 .16586 m
.33715 .16586 L
s
.33723 .16704 m
.33723 .16704 L
s
.3373 .16563 m
.3373 .16563 L
s
.33738 .1661 m
.33738 .1661 L
s
.33745 .16634 m
.33745 .16634 L
s
.33753 .16774 m
.33753 .16774 L
s
.3376 .16868 m
.3376 .16868 L
s
.33767 .16774 m
.33767 .16774 L
s
.33774 .16868 m
.33774 .16868 L
s
.33782 .16915 m
.33782 .16915 L
s
.33789 .17103 m
.33789 .17103 L
s
.33797 .17127 m
.33797 .17127 L
s
.33804 .17291 m
.33804 .17291 L
s
.33812 .17362 m
.33812 .17362 L
s
.33819 .1722 m
.33819 .1722 L
s
.33827 .17267 m
.33827 .17267 L
s
.33835 .17244 m
.33835 .17244 L
s
.33842 .17338 m
.33842 .17338 L
s
.33849 .17432 m
.33849 .17432 L
s
.33856 .17644 m
.33856 .17644 L
s
.33864 .17479 m
.33864 .17479 L
s
.33871 .17526 m
.33871 .17526 L
s
.33879 .17409 m
.33879 .17409 L
s
.33886 .17385 m
.33886 .17385 L
s
.33894 .17103 m
.33894 .17103 L
s
.33901 .1708 m
.33901 .1708 L
s
.33909 .17127 m
.33909 .17127 L
s
.33916 .16963 m
.33916 .16963 L
s
.33924 .16963 m
.33924 .16963 L
s
.3393 .17127 m
.3393 .17127 L
s
.33938 .17291 m
.33938 .17291 L
s
.33945 .17174 m
.33945 .17174 L
s
.33953 .17197 m
.33953 .17197 L
s
.3396 .17103 m
.3396 .17103 L
s
.33968 .17362 m
.33968 .17362 L
s
.33976 .17174 m
.33976 .17174 L
s
.33982 .17291 m
.33982 .17291 L
s
.3399 .1715 m
.3399 .1715 L
s
.33998 .17009 m
.33998 .17009 L
s
.34005 .16915 m
.34005 .16915 L
s
.34012 .16681 m
.34012 .16681 L
s
.3402 .16751 m
.3402 .16751 L
s
.34027 .16751 m
.34027 .16751 L
s
.34035 .16657 m
.34035 .16657 L
s
.34042 .16563 m
.34042 .16563 L
s
.3405 .16634 m
.3405 .16634 L
s
.34057 .16539 m
.34057 .16539 L
s
.34064 .16634 m
.34064 .16634 L
s
.34072 .16727 m
.34072 .16727 L
s
.3408 .16539 m
.3408 .16539 L
s
.34087 .16469 m
.34087 .16469 L
s
.34094 .16305 m
.34094 .16305 L
s
.34101 .16399 m
.34101 .16399 L
s
.34109 .16539 m
.34109 .16539 L
s
.34116 .16774 m
.34116 .16774 L
s
.34124 .16634 m
.34124 .16634 L
s
.34132 .16681 m
.34132 .16681 L
s
.34139 .16634 m
.34139 .16634 L
s
.34146 .16634 m
.34146 .16634 L
s
.34153 .16798 m
.34153 .16798 L
s
.34161 .16821 m
.34161 .16821 L
s
.34168 .16963 m
.34168 .16963 L
s
.34176 .16727 m
.34176 .16727 L
s
.34183 .16821 m
.34183 .16821 L
s
.34191 .16704 m
.34191 .16704 L
s
.34198 .16681 m
.34198 .16681 L
s
.34206 .1661 m
.34206 .1661 L
s
.34213 .16492 m
.34213 .16492 L
s
.34221 .16399 m
.34221 .16399 L
s
.34227 .16445 m
.34227 .16445 L
s
.34235 .16657 m
.34235 .16657 L
s
.34243 .16563 m
.34243 .16563 L
s
.3425 .16492 m
.3425 .16492 L
s
.34257 .16399 m
.34257 .16399 L
s
.34265 .16539 m
.34265 .16539 L
s
.34272 .16328 m
.34272 .16328 L
s
.3428 .16422 m
.3428 .16422 L
s
.34288 .16399 m
.34288 .16399 L
s
.34295 .16586 m
.34295 .16586 L
s
.34302 .16586 m
.34302 .16586 L
s
.34309 .16422 m
.34309 .16422 L
s
.34317 .1661 m
.34317 .1661 L
s
.34324 .16586 m
.34324 .16586 L
s
.34332 .16798 m
.34332 .16798 L
s
.34339 .16727 m
.34339 .16727 L
s
.34347 .16586 m
.34347 .16586 L
s
.34354 .16492 m
.34354 .16492 L
s
.34362 .16586 m
.34362 .16586 L
s
.34369 .16563 m
.34369 .16563 L
s
.34377 .16634 m
.34377 .16634 L
s
.34384 .16798 m
.34384 .16798 L
s
.34391 .16892 m
.34391 .16892 L
s
.34398 .17033 m
.34398 .17033 L
s
.34406 .16915 m
.34406 .16915 L
s
.34413 .17056 m
.34413 .17056 L
s
.34421 .17197 m
.34421 .17197 L
s
.34428 .17267 m
.34428 .17267 L
s
.34436 .1708 m
.34436 .1708 L
s
.34444 .17267 m
.34444 .17267 L
s
.34451 .17127 m
.34451 .17127 L
s
.34459 .1715 m
.34459 .1715 L
s
.34465 .17291 m
.34465 .17291 L
s
.34473 .1722 m
.34473 .1722 L
s
.3448 .17127 m
.3448 .17127 L
s
.34488 .16845 m
.34488 .16845 L
s
.34495 .1708 m
.34495 .1708 L
s
.34503 .17009 m
.34503 .17009 L
s
.3451 .17033 m
.3451 .17033 L
s
.34518 .16939 m
.34518 .16939 L
s
.34525 .16986 m
.34525 .16986 L
s
.34533 .16892 m
.34533 .16892 L
s
.3454 .16963 m
.3454 .16963 L
s
.34547 .17056 m
.34547 .17056 L
s
.34554 .17009 m
.34554 .17009 L
s
.34562 .16915 m
.34562 .16915 L
s
.34569 .16939 m
.34569 .16939 L
s
.34577 .16963 m
.34577 .16963 L
s
.34584 .16845 m
.34584 .16845 L
s
.34592 .17009 m
.34592 .17009 L
s
.346 .17009 m
.346 .17009 L
s
.34607 .17056 m
.34607 .17056 L
s
.34615 .17127 m
.34615 .17127 L
s
.34622 .1708 m
.34622 .1708 L
s
.34629 .17174 m
.34629 .17174 L
s
.34636 .1722 m
.34636 .1722 L
s
.34644 .17244 m
.34644 .17244 L
s
.34651 .17315 m
.34651 .17315 L
s
.34659 .17385 m
.34659 .17385 L
s
.34666 .17291 m
.34666 .17291 L
s
.34674 .17291 m
.34674 .17291 L
s
.34681 .1715 m
.34681 .1715 L
s
.34689 .17174 m
.34689 .17174 L
s
.34696 .17291 m
.34696 .17291 L
s
.34704 .17338 m
.34704 .17338 L
s
.3471 .17432 m
.3471 .17432 L
s
.34718 .17385 m
.34718 .17385 L
s
.34725 .17362 m
.34725 .17362 L
s
.34733 .17338 m
.34733 .17338 L
s
.3474 .17456 m
.3474 .17456 L
s
.34748 .17549 m
.34748 .17549 L
s
.34756 .17596 m
.34756 .17596 L
s
.34763 .17596 m
.34763 .17596 L
s
.34771 .17432 m
.34771 .17432 L
s
.34778 .17526 m
.34778 .17526 L
s
.34785 .17432 m
.34785 .17432 L
s
.34792 .17502 m
.34792 .17502 L
s
.348 .17479 m
.348 .17479 L
s
.34807 .17549 m
.34807 .17549 L
s
.34815 .17409 m
.34815 .17409 L
s
.34822 .17573 m
.34822 .17573 L
s
.3483 .17479 m
.3483 .17479 L
s
.34837 .17479 m
.34837 .17479 L
s
.34844 .17385 m
.34844 .17385 L
s
.34852 .17291 m
.34852 .17291 L
s
.3486 .17291 m
.3486 .17291 L
s
.34867 .17338 m
.34867 .17338 L
s
.34874 .17385 m
.34874 .17385 L
s
.34881 .17456 m
.34881 .17456 L
s
.34889 .17526 m
.34889 .17526 L
s
.34896 .17338 m
.34896 .17338 L
s
.34904 .17362 m
.34904 .17362 L
s
.34912 .1722 m
.34912 .1722 L
s
.34919 .17267 m
.34919 .17267 L
s
.34926 .17385 m
.34926 .17385 L
s
.34934 .17338 m
.34934 .17338 L
s
.34942 .17197 m
.34942 .17197 L
s
.34948 .1715 m
.34948 .1715 L
s
.34956 .17127 m
.34956 .17127 L
s
.34963 .17174 m
.34963 .17174 L
s
.34971 .17267 m
.34971 .17267 L
s
.34978 .17174 m
.34978 .17174 L
s
.34986 .17197 m
.34986 .17197 L
s
.34993 .17197 m
.34993 .17197 L
s
.35001 .17291 m
.35001 .17291 L
s
.35007 .17291 m
.35007 .17291 L
s
.35015 .17174 m
.35015 .17174 L
s
.35023 .1715 m
.35023 .1715 L
s
.3503 .17033 m
.3503 .17033 L
s
.35037 .17009 m
.35037 .17009 L
s
.35045 .17127 m
.35045 .17127 L
s
.35052 .1715 m
.35052 .1715 L
s
.3506 .17127 m
.3506 .17127 L
s
.35068 .17197 m
.35068 .17197 L
s
.35075 .1708 m
.35075 .1708 L
s
.35082 .17009 m
.35082 .17009 L
s
.35089 .17009 m
.35089 .17009 L
s
.35097 .17056 m
.35097 .17056 L
s
.35105 .16986 m
.35105 .16986 L
s
.35112 .17056 m
.35112 .17056 L
s
.35119 .1715 m
.35119 .1715 L
s
.35127 .17103 m
.35127 .17103 L
s
.35134 .17197 m
.35134 .17197 L
s
.35142 .17103 m
.35142 .17103 L
s
.35149 .1715 m
.35149 .1715 L
s
.35157 .17197 m
.35157 .17197 L
s
.35164 .17362 m
.35164 .17362 L
s
.35171 .17291 m
.35171 .17291 L
s
.35178 .17315 m
.35178 .17315 L
s
.35186 .17244 m
.35186 .17244 L
s
.35193 .17056 m
.35193 .17056 L
s
.35201 .1715 m
.35201 .1715 L
s
.35208 .1715 m
.35208 .1715 L
s
.35216 .1722 m
.35216 .1722 L
s
.35224 .17267 m
.35224 .17267 L
s
.35231 .17362 m
.35231 .17362 L
s
.35239 .17291 m
.35239 .17291 L
s
.35245 .17338 m
.35245 .17338 L
s
.35253 .17456 m
.35253 .17456 L
s
.3526 .17362 m
.3526 .17362 L
s
.35268 .17526 m
.35268 .17526 L
s
.35275 .17502 m
.35275 .17502 L
s
.35283 .17479 m
.35283 .17479 L
s
.3529 .17362 m
.3529 .17362 L
s
.35298 .17338 m
.35298 .17338 L
s
.35305 .17409 m
.35305 .17409 L
s
.35313 .17714 m
.35313 .17714 L
s
.3532 .17667 m
.3532 .17667 L
s
.35327 .17596 m
.35327 .17596 L
s
.35334 .17456 m
.35334 .17456 L
s
.35342 .17456 m
.35342 .17456 L
s
.35349 .17573 m
.35349 .17573 L
s
.35357 .17479 m
.35357 .17479 L
s
.35364 .17596 m
.35364 .17596 L
s
.35372 .17432 m
.35372 .17432 L
s
.3538 .17456 m
.3538 .17456 L
s
.35387 .17385 m
.35387 .17385 L
s
.35395 .17573 m
.35395 .17573 L
s
.35402 .17526 m
.35402 .17526 L
s
.35409 .17738 m
.35409 .17738 L
s
.35416 .17738 m
.35416 .17738 L
s
.35424 .17667 m
.35424 .17667 L
s
.35431 .17714 m
.35431 .17714 L
s
.35439 .17596 m
.35439 .17596 L
s
.35446 .17761 m
.35446 .17761 L
s
.35454 .17573 m
.35454 .17573 L
s
.35461 .17761 m
.35461 .17761 L
s
.35469 .17714 m
.35469 .17714 L
s
.35476 .17808 m
.35476 .17808 L
s
.35484 .17714 m
.35484 .17714 L
s
.3549 .17808 m
.3549 .17808 L
s
.35498 .17761 m
.35498 .17761 L
s
.35505 .17644 m
.35505 .17644 L
s
.35513 .1762 m
.35513 .1762 L
s
.3552 .17667 m
.3552 .17667 L
s
.35528 .17948 m
.35528 .17948 L
s
.35536 .17738 m
.35536 .17738 L
s
.35543 .17878 m
.35543 .17878 L
s
.35551 .17902 m
.35551 .17902 L
s
.35558 .17973 m
.35558 .17973 L
s
.35565 .17996 m
.35565 .17996 L
s
.35572 .17948 m
.35572 .17948 L
s
.3558 .17761 m
.3558 .17761 L
s
.35587 .17691 m
.35587 .17691 L
s
.35595 .17761 m
.35595 .17761 L
s
.35602 .17667 m
.35602 .17667 L
s
.3561 .17878 m
.3561 .17878 L
s
.35617 .17691 m
.35617 .17691 L
s
.35625 .17808 m
.35625 .17808 L
s
.35632 .17738 m
.35632 .17738 L
s
.3564 .17925 m
.3564 .17925 L
s
.35647 .17855 m
.35647 .17855 L
s
.35654 .17902 m
.35654 .17902 L
s
.35661 .17973 m
.35661 .17973 L
s
.35669 .17948 m
.35669 .17948 L
s
.35676 .1809 m
.35676 .1809 L
s
.35684 .17973 m
.35684 .17973 L
s
.35692 .18066 m
.35692 .18066 L
s
.35699 .17973 m
.35699 .17973 L
s
.35706 .1802 m
.35706 .1802 L
s
.35714 .17925 m
.35714 .17925 L
s
.35722 .18043 m
.35722 .18043 L
s
.35729 .18184 m
.35729 .18184 L
s
.35736 .18066 m
.35736 .18066 L
s
.35743 .18137 m
.35743 .18137 L
s
.35751 .17996 m
.35751 .17996 L
s
.35758 .18113 m
.35758 .18113 L
s
.35766 .1816 m
.35766 .1816 L
s
.35773 .18043 m
.35773 .18043 L
s
.35781 .17996 m
.35781 .17996 L
s
.35788 .1823 m
.35788 .1823 L
s
.35796 .1809 m
.35796 .1809 L
s
.35803 .18137 m
.35803 .18137 L
s
.3581 .18113 m
.3581 .18113 L
s
.35817 .18137 m
.35817 .18137 L
s
.35825 .17902 m
.35825 .17902 L
s
.35832 .17808 m
.35832 .17808 L
s
.3584 .1802 m
.3584 .1802 L
s
.35848 .18043 m
.35848 .18043 L
s
.35855 .18066 m
.35855 .18066 L
s
.35862 .1809 m
.35862 .1809 L
s
.35869 .18254 m
.35869 .18254 L
s
.35877 .18184 m
.35877 .18184 L
s
.35885 .1809 m
.35885 .1809 L
s
.35892 .17996 m
.35892 .17996 L
s
.35899 .18043 m
.35899 .18043 L
s
.35907 .18137 m
.35907 .18137 L
s
.35914 .18184 m
.35914 .18184 L
s
.35922 .18419 m
.35922 .18419 L
s
.35929 .18372 m
.35929 .18372 L
s
.35937 .18348 m
.35937 .18348 L
s
.35944 .18207 m
.35944 .18207 L
s
.35951 .1816 m
.35951 .1816 L
s
.35959 .17878 m
.35959 .17878 L
s
.35967 .17948 m
.35967 .17948 L
s
.35973 .17948 m
.35973 .17948 L
s
.35981 .17996 m
.35981 .17996 L
s
.35988 .1809 m
.35988 .1809 L
s
.35996 .18113 m
.35996 .18113 L
s
.36004 .1823 m
.36004 .1823 L
s
.36011 .1823 m
.36011 .1823 L
s
.36019 .18348 m
.36019 .18348 L
s
.36026 .1823 m
.36026 .1823 L
s
.36033 .18207 m
.36033 .18207 L
s
.3604 .1823 m
.3604 .1823 L
s
.36048 .18184 m
.36048 .18184 L
s
.36055 .18207 m
.36055 .18207 L
s
.36063 .1809 m
.36063 .1809 L
s
.3607 .18277 m
.3607 .18277 L
s
.36078 .18348 m
.36078 .18348 L
s
.36085 .18559 m
.36085 .18559 L
s
.36093 .18559 m
.36093 .18559 L
s
.361 .18771 m
.361 .18771 L
s
.36107 .18818 m
.36107 .18818 L
s
.36114 .18865 m
.36114 .18865 L
s
.36122 .18677 m
.36122 .18677 L
s
.3613 .18701 m
.3613 .18701 L
s
.36137 .18654 m
.36137 .18654 L
s
.36144 .18724 m
.36144 .18724 L
s
.36152 .1863 m
.36152 .1863 L
s
.3616 .18536 m
.3616 .18536 L
s
.36167 .18654 m
.36167 .18654 L
s
.36175 .18583 m
.36175 .18583 L
s
.36182 .18583 m
.36182 .18583 L
s
.36189 .18419 m
.36189 .18419 L
s
.36196 .18818 m
.36196 .18818 L
s
.36204 .18865 m
.36204 .18865 L
s
.36211 .18958 m
.36211 .18958 L
s
.36219 .1903 m
.36219 .1903 L
s
.36226 .18935 m
.36226 .18935 L
s
.36234 .19123 m
.36234 .19123 L
s
.36241 .19076 m
.36241 .19076 L
s
.36249 .19287 m
.36249 .19287 L
s
.36256 .19194 m
.36256 .19194 L
s
.36264 .1924 m
.36264 .1924 L
s
.3627 .1917 m
.3627 .1917 L
s
.36278 .19147 m
.36278 .19147 L
s
.36285 .1917 m
.36285 .1917 L
s
.36293 .19147 m
.36293 .19147 L
s
.363 .19217 m
.363 .19217 L
s
.36308 .1917 m
.36308 .1917 L
s
.36316 .19194 m
.36316 .19194 L
s
.36323 .19053 m
.36323 .19053 L
s
.36331 .19335 m
.36331 .19335 L
s
.36338 .19217 m
.36338 .19217 L
s
.36345 .1924 m
.36345 .1924 L
s
.36352 .19147 m
.36352 .19147 L
s
.3636 .19217 m
.3636 .19217 L
s
.36367 .1924 m
.36367 .1924 L
s
.36375 .1903 m
.36375 .1903 L
s
.36382 .19053 m
.36382 .19053 L
s
.3639 .1903 m
.3639 .1903 L
s
.36397 .191 m
.36397 .191 L
s
.36405 .1903 m
.36405 .1903 L
s
.36412 .18983 m
.36412 .18983 L
s
.3642 .18794 m
.3642 .18794 L
s
.36427 .18841 m
.36427 .18841 L
s
.36434 .18654 m
.36434 .18654 L
s
.36441 .18559 m
.36441 .18559 L
s
.36449 .18701 m
.36449 .18701 L
s
.36456 .18935 m
.36456 .18935 L
s
.36464 .18794 m
.36464 .18794 L
s
.36472 .18701 m
.36472 .18701 L
s
.36479 .18841 m
.36479 .18841 L
s
.36487 .18794 m
.36487 .18794 L
s
.36494 .18912 m
.36494 .18912 L
s
.36502 .18958 m
.36502 .18958 L
s
.36509 .18935 m
.36509 .18935 L
s
.36516 .18701 m
.36516 .18701 L
s
.36523 .18724 m
.36523 .18724 L
s
.36531 .18489 m
.36531 .18489 L
s
.36538 .18442 m
.36538 .18442 L
s
.36546 .18583 m
.36546 .18583 L
s
.36553 .18512 m
.36553 .18512 L
s
.36561 .18701 m
.36561 .18701 L
s
.36568 .18536 m
.36568 .18536 L
s
.36576 .18583 m
.36576 .18583 L
s
.36583 .18583 m
.36583 .18583 L
s
.3659 .18794 m
.3659 .18794 L
s
.36597 .18724 m
.36597 .18724 L
s
.36605 .18724 m
.36605 .18724 L
s
.36612 .18654 m
.36612 .18654 L
s
.3662 .18818 m
.3662 .18818 L
s
.36628 .18701 m
.36628 .18701 L
s
.36635 .18677 m
.36635 .18677 L
s
.36642 .1863 m
.36642 .1863 L
s
.3665 .18536 m
.3665 .18536 L
s
.36658 .18677 m
.36658 .18677 L
s
.36665 .18583 m
.36665 .18583 L
s
.36672 .18512 m
.36672 .18512 L
s
.36679 .18419 m
.36679 .18419 L
s
.36687 .18606 m
.36687 .18606 L
s
.36694 .18865 m
.36694 .18865 L
s
.36702 .18958 m
.36702 .18958 L
s
.36709 .19006 m
.36709 .19006 L
s
.36717 .18865 m
.36717 .18865 L
s
.36724 .18935 m
.36724 .18935 L
s
.36731 .18724 m
.36731 .18724 L
s
.36739 .18841 m
.36739 .18841 L
s
.36747 .18654 m
.36747 .18654 L
s
.36753 .18748 m
.36753 .18748 L
s
.36761 .18748 m
.36761 .18748 L
s
.36768 .18794 m
.36768 .18794 L
s
.36776 .18841 m
.36776 .18841 L
s
.36784 .18958 m
.36784 .18958 L
s
.36791 .18983 m
.36791 .18983 L
s
.36799 .1903 m
.36799 .1903 L
s
.36806 .18912 m
.36806 .18912 L
s
.36813 .18771 m
.36813 .18771 L
s
.36821 .18912 m
.36821 .18912 L
s
.36828 .1903 m
.36828 .1903 L
s
.36835 .18958 m
.36835 .18958 L
s
.36843 .18912 m
.36843 .18912 L
s
.3685 .18888 m
.3685 .18888 L
s
.36858 .18935 m
.36858 .18935 L
s
.36865 .1903 m
.36865 .1903 L
s
.36873 .18935 m
.36873 .18935 L
s
.3688 .18958 m
.3688 .18958 L
s
.36887 .1903 m
.36887 .1903 L
s
.36894 .18888 m
.36894 .18888 L
s
.36902 .18841 m
.36902 .18841 L
s
.3691 .18771 m
.3691 .18771 L
s
.36917 .19006 m
.36917 .19006 L
s
.36924 .18958 m
.36924 .18958 L
s
.36932 .1903 m
.36932 .1903 L
s
.3694 .19006 m
.3694 .19006 L
s
.36947 .18958 m
.36947 .18958 L
s
.36955 .1903 m
.36955 .1903 L
s
.36962 .18958 m
.36962 .18958 L
s
.36969 .19053 m
.36969 .19053 L
s
.36976 .18935 m
.36976 .18935 L
s
.36984 .18865 m
.36984 .18865 L
s
.36992 .18888 m
.36992 .18888 L
s
.36999 .19006 m
.36999 .19006 L
s
.37006 .19053 m
.37006 .19053 L
s
.37014 .19264 m
.37014 .19264 L
s
.37021 .19429 m
.37021 .19429 L
s
.37029 .19382 m
.37029 .19382 L
s
.37036 .19452 m
.37036 .19452 L
s
.37044 .19311 m
.37044 .19311 L
s
.3705 .19522 m
.3705 .19522 L
s
.37058 .19499 m
.37058 .19499 L
s
.37065 .19546 m
.37065 .19546 L
s
.37073 .19546 m
.37073 .19546 L
s
.3708 .19593 m
.3708 .19593 L
s
.37088 .19546 m
.37088 .19546 L
s
.37096 .19664 m
.37096 .19664 L
s
.37103 .19687 m
.37103 .19687 L
s
.37111 .19616 m
.37111 .19616 L
s
.37118 .19569 m
.37118 .19569 L
s
.37125 .19546 m
.37125 .19546 L
s
.37132 .19758 m
.37132 .19758 L
s
.3714 .19664 m
.3714 .19664 L
s
.37147 .1964 m
.37147 .1964 L
s
.37155 .19711 m
.37155 .19711 L
s
.37162 .19804 m
.37162 .19804 L
s
.3717 .19781 m
.3717 .19781 L
s
.37177 .19828 m
.37177 .19828 L
s
.37185 .19851 m
.37185 .19851 L
s
.37192 .19875 m
.37192 .19875 L
s
.372 .19804 m
.372 .19804 L
s
.37207 .1964 m
.37207 .1964 L
s
.37214 .19804 m
.37214 .19804 L
s
.37221 .19664 m
.37221 .19664 L
s
.37229 .19781 m
.37229 .19781 L
s
.37236 .19781 m
.37236 .19781 L
s
.37244 .19851 m
.37244 .19851 L
s
.37252 .19922 m
.37252 .19922 L
s
.37259 .2004 m
.37259 .2004 L
s
.37267 .19968 m
.37267 .19968 L
s
.37274 .19875 m
.37274 .19875 L
s
.37282 .19828 m
.37282 .19828 L
s
.37289 .19711 m
.37289 .19711 L
s
.37296 .19804 m
.37296 .19804 L
s
.37303 .19734 m
.37303 .19734 L
s
.37311 .19781 m
.37311 .19781 L
s
.37318 .19616 m
.37318 .19616 L
s
.37326 .19687 m
.37326 .19687 L
s
.37333 .19429 m
.37333 .19429 L
s
.37341 .19476 m
.37341 .19476 L
s
.37348 .19522 m
.37348 .19522 L
s
.37356 .19522 m
.37356 .19522 L
s
.37363 .19476 m
.37363 .19476 L
s
.3737 .19335 m
.3737 .19335 L
s
.37377 .19452 m
.37377 .19452 L
s
.37385 .19405 m
.37385 .19405 L
s
.37392 .19452 m
.37392 .19452 L
s
.374 .19358 m
.374 .19358 L
s
.37408 .19429 m
.37408 .19429 L
s
.37415 .19522 m
.37415 .19522 L
s
.37422 .19569 m
.37422 .19569 L
s
.3743 .19593 m
.3743 .19593 L
s
.37438 .19569 m
.37438 .19569 L
s
.37445 .19593 m
.37445 .19593 L
s
.37452 .19522 m
.37452 .19522 L
s
.37459 .19546 m
.37459 .19546 L
s
.37467 .19522 m
.37467 .19522 L
s
.37474 .19593 m
.37474 .19593 L
s
.37482 .19499 m
.37482 .19499 L
s
.37489 .19452 m
.37489 .19452 L
s
.37497 .19452 m
.37497 .19452 L
s
.37504 .19499 m
.37504 .19499 L
s
.37512 .1964 m
.37512 .1964 L
s
.37519 .19499 m
.37519 .19499 L
s
.37527 .19664 m
.37527 .19664 L
s
.37533 .19734 m
.37533 .19734 L
s
.37541 .19851 m
.37541 .19851 L
s
.37548 .19828 m
.37548 .19828 L
s
.37556 .19898 m
.37556 .19898 L
s
.37564 .19828 m
.37564 .19828 L
s
.37571 .19734 m
.37571 .19734 L
s
.37579 .19687 m
.37579 .19687 L
s
.37586 .19616 m
.37586 .19616 L
s
.37593 .19734 m
.37593 .19734 L
s
.37601 .19758 m
.37601 .19758 L
s
.37608 .19758 m
.37608 .19758 L
s
.37615 .19711 m
.37615 .19711 L
s
.37623 .19781 m
.37623 .19781 L
s
.3763 .1964 m
.3763 .1964 L
s
.37638 .19664 m
.37638 .19664 L
s
.37645 .19687 m
.37645 .19687 L
s
.37653 .19734 m
.37653 .19734 L
s
.3766 .19734 m
.3766 .19734 L
s
.37667 .1964 m
.37667 .1964 L
s
.37675 .19664 m
.37675 .19664 L
s
.37683 .19546 m
.37683 .19546 L
s
.3769 .19616 m
.3769 .19616 L
s
.37697 .19593 m
.37697 .19593 L
s
.37704 .19664 m
.37704 .19664 L
s
.37712 .19711 m
.37712 .19711 L
s
.3772 .19734 m
.3772 .19734 L
s
.37727 .1964 m
.37727 .1964 L
s
.37735 .19616 m
.37735 .19616 L
s
.37742 .19569 m
.37742 .19569 L
s
.37749 .19546 m
.37749 .19546 L
s
.37756 .19593 m
.37756 .19593 L
s
.37764 .19522 m
.37764 .19522 L
s
.37772 .19593 m
.37772 .19593 L
s
.37779 .1964 m
.37779 .1964 L
s
.37786 .19616 m
.37786 .19616 L
s
.37794 .19546 m
.37794 .19546 L
s
.37801 .1964 m
.37801 .1964 L
s
.37809 .19828 m
.37809 .19828 L
s
.37816 .19922 m
.37816 .19922 L
s
.37824 .2004 m
.37824 .2004 L
s
.3783 .20016 m
.3783 .20016 L
s
.37838 .20133 m
.37838 .20133 L
s
.37846 .20086 m
.37846 .20086 L
s
.37853 .20274 m
.37853 .20274 L
s
.3786 .20274 m
.3786 .20274 L
s
.37868 .2018 m
.37868 .2018 L
s
.37876 .20227 m
.37876 .20227 L
s
.37883 .20016 m
.37883 .20016 L
s
.37891 .19922 m
.37891 .19922 L
s
.37898 .20016 m
.37898 .20016 L
s
.37905 .20227 m
.37905 .20227 L
s
.37912 .20321 m
.37912 .20321 L
s
.3792 .20321 m
.3792 .20321 L
s
.37927 .2011 m
.37927 .2011 L
s
.37935 .20157 m
.37935 .20157 L
s
.37942 .19992 m
.37942 .19992 L
s
.3795 .20204 m
.3795 .20204 L
s
.37957 .20157 m
.37957 .20157 L
s
.37965 .2018 m
.37965 .2018 L
s
.37972 .20274 m
.37972 .20274 L
s
.3798 .2025 m
.3798 .2025 L
s
.37987 .2004 m
.37987 .2004 L
s
.37994 .2025 m
.37994 .2025 L
s
.38001 .2018 m
.38001 .2018 L
s
.38009 .20204 m
.38009 .20204 L
s
.38016 .20392 m
.38016 .20392 L
s
.38024 .20063 m
.38024 .20063 L
s
.38032 .20157 m
.38032 .20157 L
s
.38039 .2011 m
.38039 .2011 L
s
.38047 .2011 m
.38047 .2011 L
s
.38054 .20204 m
.38054 .20204 L
s
.38062 .20297 m
.38062 .20297 L
s
.38069 .2018 m
.38069 .2018 L
s
.38076 .19898 m
.38076 .19898 L
s
.38083 .20086 m
.38083 .20086 L
s
.38091 .19945 m
.38091 .19945 L
s
.38098 .2004 m
.38098 .2004 L
s
.38106 .20133 m
.38106 .20133 L
s
.38113 .20016 m
.38113 .20016 L
s
.38121 .19968 m
.38121 .19968 L
s
.38128 .2011 m
.38128 .2011 L
s
.38136 .20016 m
.38136 .20016 L
s
.38143 .20016 m
.38143 .20016 L
s
.3815 .20086 m
.3815 .20086 L
s
.38157 .19851 m
.38157 .19851 L
s
.38165 .19758 m
.38165 .19758 L
s
.38172 .19476 m
.38172 .19476 L
s
.3818 .19452 m
.3818 .19452 L
s
.38188 .19311 m
.38188 .19311 L
s
.38195 .19452 m
.38195 .19452 L
s
.38202 .19569 m
.38202 .19569 L
s
.3821 .19499 m
.3821 .19499 L
s
.38218 .19499 m
.38218 .19499 L
s
.38225 .19499 m
.38225 .19499 L
s
.38232 .19593 m
.38232 .19593 L
s
.38239 .19452 m
.38239 .19452 L
s
.38247 .19593 m
.38247 .19593 L
s
.38254 .1964 m
.38254 .1964 L
s
.38262 .19781 m
.38262 .19781 L
s
.38269 .19875 m
.38269 .19875 L
s
.38277 .19875 m
.38277 .19875 L
s
.38284 .19804 m
.38284 .19804 L
s
.38292 .19734 m
.38292 .19734 L
s
.38299 .19687 m
.38299 .19687 L
s
.38307 .1964 m
.38307 .1964 L
s
.38313 .19734 m
.38313 .19734 L
s
.38321 .19687 m
.38321 .19687 L
s
.38328 .19687 m
.38328 .19687 L
s
.38336 .19664 m
.38336 .19664 L
s
.38344 .19781 m
.38344 .19781 L
s
.38351 .19546 m
.38351 .19546 L
s
.38359 .19664 m
.38359 .19664 L
s
.38366 .19452 m
.38366 .19452 L
s
.38373 .19569 m
.38373 .19569 L
s
.38381 .19522 m
.38381 .19522 L
s
.38388 .19569 m
.38388 .19569 L
s
.38395 .19522 m
.38395 .19522 L
s
.38403 .19476 m
.38403 .19476 L
s
.3841 .1964 m
.3841 .1964 L
s
.38418 .19546 m
.38418 .19546 L
s
.38425 .1964 m
.38425 .1964 L
s
.38433 .19687 m
.38433 .19687 L
s
.3844 .19828 m
.3844 .19828 L
s
.38447 .19804 m
.38447 .19804 L
s
.38455 .19781 m
.38455 .19781 L
s
.38463 .19875 m
.38463 .19875 L
s
.3847 .19851 m
.3847 .19851 L
s
.38477 .19968 m
.38477 .19968 L
s
.38484 .19992 m
.38484 .19992 L
s
.38492 .19992 m
.38492 .19992 L
s
.385 .19828 m
.385 .19828 L
s
.38507 .19898 m
.38507 .19898 L
s
.38515 .19781 m
.38515 .19781 L
s
.38522 .19828 m
.38522 .19828 L
s
.38529 .19922 m
.38529 .19922 L
s
.38536 .19781 m
.38536 .19781 L
s
.38544 .1964 m
.38544 .1964 L
s
.38552 .19616 m
.38552 .19616 L
s
.38559 .19804 m
.38559 .19804 L
s
.38566 .19616 m
.38566 .19616 L
s
.38574 .19828 m
.38574 .19828 L
s
.38581 .19875 m
.38581 .19875 L
s
.38589 .19992 m
.38589 .19992 L
s
.38596 .19875 m
.38596 .19875 L
s
.38604 .19875 m
.38604 .19875 L
s
.3861 .19968 m
.3861 .19968 L
s
.38618 .19945 m
.38618 .19945 L
s
.38626 .19992 m
.38626 .19992 L
s
.38633 .19992 m
.38633 .19992 L
s
.3864 .19922 m
.3864 .19922 L
s
.38648 .19522 m
.38648 .19522 L
s
.38656 .19593 m
.38656 .19593 L
s
.38663 .19546 m
.38663 .19546 L
s
.38671 .19546 m
.38671 .19546 L
s
.38678 .19546 m
.38678 .19546 L
s
.38685 .19616 m
.38685 .19616 L
s
.38692 .1964 m
.38692 .1964 L
s
.387 .1964 m
.387 .1964 L
s
.38708 .19734 m
.38708 .19734 L
s
.38715 .19522 m
.38715 .19522 L
s
.38722 .19664 m
.38722 .19664 L
s
.3873 .19546 m
.3873 .19546 L
s
.38737 .19616 m
.38737 .19616 L
s
.38745 .19546 m
.38745 .19546 L
s
.38752 .19522 m
.38752 .19522 L
s
.3876 .1964 m
.3876 .1964 L
s
.38767 .19734 m
.38767 .19734 L
s
.38774 .19711 m
.38774 .19711 L
s
.38781 .19664 m
.38781 .19664 L
s
.38789 .19687 m
.38789 .19687 L
s
.38796 .1964 m
.38796 .1964 L
s
.38804 .19664 m
.38804 .19664 L
s
.38812 .19358 m
.38812 .19358 L
s
.38819 .19429 m
.38819 .19429 L
s
.38827 .19358 m
.38827 .19358 L
s
.38834 .19405 m
.38834 .19405 L
s
.38842 .19499 m
.38842 .19499 L
s
.38849 .19546 m
.38849 .19546 L
s
.38856 .19522 m
.38856 .19522 L
s
.38863 .19382 m
.38863 .19382 L
s
.38871 .19429 m
.38871 .19429 L
s
.38878 .19311 m
.38878 .19311 L
s
.38886 .19311 m
.38886 .19311 L
s
.38893 .19429 m
.38893 .19429 L
s
.38901 .19758 m
.38901 .19758 L
s
.38908 .19851 m
.38908 .19851 L
s
.38916 .19968 m
.38916 .19968 L
s
.38923 .19968 m
.38923 .19968 L
s
.3893 .19875 m
.3893 .19875 L
s
.38937 .19898 m
.38937 .19898 L
s
.38945 .19945 m
.38945 .19945 L
s
.38952 .2004 m
.38952 .2004 L
s
.3896 .19851 m
.3896 .19851 L
s
.38968 .19734 m
.38968 .19734 L
s
.38975 .19546 m
.38975 .19546 L
s
.38983 .1964 m
.38983 .1964 L
s
.3899 .19569 m
.3899 .19569 L
s
.38998 .19569 m
.38998 .19569 L
s
.39005 .19452 m
.39005 .19452 L
s
.39012 .19452 m
.39012 .19452 L
s
.39019 .19687 m
.39019 .19687 L
s
.39027 .19593 m
.39027 .19593 L
s
.39034 .19546 m
.39034 .19546 L
s
.39042 .19522 m
.39042 .19522 L
s
.39049 .19828 m
.39049 .19828 L
s
.39057 .19593 m
.39057 .19593 L
s
.39064 .19546 m
.39064 .19546 L
s
.39072 .19429 m
.39072 .19429 L
s
.39079 .19546 m
.39079 .19546 L
s
.39087 .1964 m
.39087 .1964 L
s
.39093 .19781 m
.39093 .19781 L
s
.39101 .19804 m
.39101 .19804 L
s
.39108 .19734 m
.39108 .19734 L
s
.39116 .19569 m
.39116 .19569 L
s
.39124 .19452 m
.39124 .19452 L
s
.39131 .19522 m
.39131 .19522 L
s
.39139 .19476 m
.39139 .19476 L
s
.39146 .19522 m
.39146 .19522 L
s
.39154 .19452 m
.39154 .19452 L
s
.39161 .19499 m
.39161 .19499 L
s
.39169 .19311 m
.39169 .19311 L
s
.39175 .19405 m
.39175 .19405 L
s
.39183 .19358 m
.39183 .19358 L
s
.3919 .19217 m
.3919 .19217 L
s
.39198 .19264 m
.39198 .19264 L
s
.39205 .1917 m
.39205 .1917 L
s
.39213 .1924 m
.39213 .1924 L
s
.3922 .1917 m
.3922 .1917 L
s
.39227 .19123 m
.39227 .19123 L
s
.39235 .18983 m
.39235 .18983 L
s
.39243 .19123 m
.39243 .19123 L
s
.3925 .18958 m
.3925 .18958 L
s
.39257 .18983 m
.39257 .18983 L
s
.39264 .18958 m
.39264 .18958 L
s
.39272 .19006 m
.39272 .19006 L
s
.3928 .1917 m
.3928 .1917 L
s
.39287 .19076 m
.39287 .19076 L
s
.39295 .19358 m
.39295 .19358 L
s
.39302 .19311 m
.39302 .19311 L
s
.39309 .19429 m
.39309 .19429 L
s
.39317 .19452 m
.39317 .19452 L
s
.39325 .19452 m
.39325 .19452 L
s
.39332 .19429 m
.39332 .19429 L
s
.39339 .19405 m
.39339 .19405 L
s
.39346 .19569 m
.39346 .19569 L
s
.39354 .19546 m
.39354 .19546 L
s
.39361 .19616 m
.39361 .19616 L
s
.39369 .19664 m
.39369 .19664 L
s
.39376 .19664 m
.39376 .19664 L
s
.39384 .19546 m
.39384 .19546 L
s
.39391 .19616 m
.39391 .19616 L
s
.39398 .19546 m
.39398 .19546 L
s
.39406 .19452 m
.39406 .19452 L
s
.39413 .19405 m
.39413 .19405 L
s
.3942 .19311 m
.3942 .19311 L
s
.39428 .19335 m
.39428 .19335 L
s
.39436 .19358 m
.39436 .19358 L
s
.39443 .19335 m
.39443 .19335 L
s
.39451 .1924 m
.39451 .1924 L
s
.39458 .19264 m
.39458 .19264 L
s
.39466 .19217 m
.39466 .19217 L
s
.39472 .19194 m
.39472 .19194 L
s
.3948 .19264 m
.3948 .19264 L
s
.39488 .19287 m
.39488 .19287 L
s
.39495 .19429 m
.39495 .19429 L
s
.39502 .19287 m
.39502 .19287 L
s
.3951 .19382 m
.3951 .19382 L
s
.39517 .19382 m
.39517 .19382 L
s
.39525 .19311 m
.39525 .19311 L
s
.39532 .19264 m
.39532 .19264 L
s
.3954 .19522 m
.3954 .19522 L
s
.39547 .19476 m
.39547 .19476 L
s
.39554 .19452 m
.39554 .19452 L
s
.39561 .19358 m
.39561 .19358 L
s
.39569 .19335 m
.39569 .19335 L
s
.39577 .19476 m
.39577 .19476 L
s
.39584 .19358 m
.39584 .19358 L
s
.39592 .19522 m
.39592 .19522 L
s
.39599 .19358 m
.39599 .19358 L
s
.39607 .19311 m
.39607 .19311 L
s
.39614 .19335 m
.39614 .19335 L
s
.39622 .19452 m
.39622 .19452 L
s
.39629 .1924 m
.39629 .1924 L
s
.39636 .19335 m
.39636 .19335 L
s
.39643 .19194 m
.39643 .19194 L
s
.39651 .19147 m
.39651 .19147 L
s
.39658 .19194 m
.39658 .19194 L
s
.39666 .19147 m
.39666 .19147 L
s
.39673 .191 m
.39673 .191 L
s
.39681 .19076 m
.39681 .19076 L
s
.39688 .1917 m
.39688 .1917 L
s
.39696 .1903 m
.39696 .1903 L
s
.39703 .18983 m
.39703 .18983 L
s
.3971 .1903 m
.3971 .1903 L
s
.39717 .19076 m
.39717 .19076 L
s
.39725 .19076 m
.39725 .19076 L
s
.39732 .19287 m
.39732 .19287 L
s
.3974 .1924 m
.3974 .1924 L
s
.39748 .19147 m
.39748 .19147 L
s
.39755 .19311 m
.39755 .19311 L
s
.39763 .19147 m
.39763 .19147 L
s
.3977 .1917 m
.3977 .1917 L
s
.39778 .19053 m
.39778 .19053 L
s
.39785 .1917 m
.39785 .1917 L
s
.39792 .18983 m
.39792 .18983 L
s
.39799 .18935 m
.39799 .18935 L
s
.39807 .18888 m
.39807 .18888 L
s
.39814 .18912 m
.39814 .18912 L
s
.39822 .18771 m
.39822 .18771 L
s
.39829 .18724 m
.39829 .18724 L
s
.39837 .18748 m
.39837 .18748 L
s
.39844 .18654 m
.39844 .18654 L
s
.39852 .18677 m
.39852 .18677 L
s
.39859 .18466 m
.39859 .18466 L
s
.39867 .18536 m
.39867 .18536 L
s
.39874 .18512 m
.39874 .18512 L
s
.39881 .18536 m
.39881 .18536 L
s
.39888 .18583 m
.39888 .18583 L
s
.39896 .18771 m
.39896 .18771 L
s
.39904 .18794 m
.39904 .18794 L
s
.39911 .1863 m
.39911 .1863 L
s
.39919 .18536 m
.39919 .18536 L
s
.39926 .18583 m
.39926 .18583 L
s
.39934 .18701 m
.39934 .18701 L
s
.39941 .18489 m
.39941 .18489 L
s
.39949 .18466 m
.39949 .18466 L
s
.39955 .18325 m
.39955 .18325 L
s
.39963 .18348 m
.39963 .18348 L
s
.3997 .18372 m
.3997 .18372 L
s
.39978 .18512 m
.39978 .18512 L
s
.39985 .18489 m
.39985 .18489 L
s
.39993 .18395 m
.39993 .18395 L
s
.4 .18419 m
.4 .18419 L
s
.40008 .18254 m
.40008 .18254 L
s
.40015 .18301 m
.40015 .18301 L
s
.40023 .18184 m
.40023 .18184 L
s
.4003 .18184 m
.4003 .18184 L
s
.40037 .18137 m
.40037 .18137 L
s
.40044 .18043 m
.40044 .18043 L
s
.40052 .18043 m
.40052 .18043 L
s
.4006 .1809 m
.4006 .1809 L
s
.40067 .18254 m
.40067 .18254 L
s
.40075 .18301 m
.40075 .18301 L
s
.40082 .18512 m
.40082 .18512 L
s
.40089 .18277 m
.40089 .18277 L
s
.40097 .18301 m
.40097 .18301 L
s
.40105 .1823 m
.40105 .1823 L
s
.40112 .18184 m
.40112 .18184 L
s
.40119 .1809 m
.40119 .1809 L
s
.40126 .17996 m
.40126 .17996 L
s
.40134 .18066 m
.40134 .18066 L
s
.40141 .17996 m
.40141 .17996 L
s
.40149 .17902 m
.40149 .17902 L
s
.40156 .17831 m
.40156 .17831 L
s
.40164 .1802 m
.40164 .1802 L
s
.40171 .17996 m
.40171 .17996 L
s
.40179 .18066 m
.40179 .18066 L
s
.40186 .17902 m
.40186 .17902 L
s
.40193 .17948 m
.40193 .17948 L
s
.402 .17831 m
.402 .17831 L
s
.40208 .18043 m
.40208 .18043 L
s
.40216 .17925 m
.40216 .17925 L
s
.40223 .17831 m
.40223 .17831 L
s
.40231 .17996 m
.40231 .17996 L
s
.40238 .17948 m
.40238 .17948 L
s
.40246 .17878 m
.40246 .17878 L
s
.40252 .17691 m
.40252 .17691 L
s
.4026 .17738 m
.4026 .17738 L
s
.40268 .1762 m
.40268 .1762 L
s
.40275 .17644 m
.40275 .17644 L
s
.40282 .17596 m
.40282 .17596 L
s
.4029 .1762 m
.4029 .1762 L
s
.40297 .17784 m
.40297 .17784 L
s
.40305 .17644 m
.40305 .17644 L
s
.40312 .17738 m
.40312 .17738 L
s
.4032 .1762 m
.4032 .1762 L
s
.40327 .17714 m
.40327 .17714 L
s
.40334 .17526 m
.40334 .17526 L
s
.40342 .17573 m
.40342 .17573 L
s
.4035 .17479 m
.4035 .17479 L
s
.40357 .17526 m
.40357 .17526 L
s
.40364 .17573 m
.40364 .17573 L
s
.40372 .17738 m
.40372 .17738 L
s
.40379 .17714 m
.40379 .17714 L
s
.40387 .17714 m
.40387 .17714 L
s
.40394 .17714 m
.40394 .17714 L
s
.40402 .17691 m
.40402 .17691 L
s
.40409 .17784 m
.40409 .17784 L
s
.40416 .17691 m
.40416 .17691 L
s
.40423 .17644 m
.40423 .17644 L
s
.40431 .17526 m
.40431 .17526 L
s
.40438 .17644 m
.40438 .17644 L
s
.40446 .17761 m
.40446 .17761 L
s
.40453 .17738 m
.40453 .17738 L
s
.40461 .17831 m
.40461 .17831 L
s
.40468 .17831 m
.40468 .17831 L
s
.40476 .17855 m
.40476 .17855 L
s
.40483 .17831 m
.40483 .17831 L
s
.4049 .17831 m
.4049 .17831 L
s
.40497 .17784 m
.40497 .17784 L
s
.40505 .17996 m
.40505 .17996 L
s
.40513 .18043 m
.40513 .18043 L
s
.4052 .17996 m
.4052 .17996 L
s
.40528 .17948 m
.40528 .17948 L
s
.40535 .17948 m
.40535 .17948 L
s
.40543 .17996 m
.40543 .17996 L
s
.4055 .17996 m
.4055 .17996 L
s
.40558 .1823 m
.40558 .1823 L
s
.40565 .18137 m
.40565 .18137 L
s
.40572 .18254 m
.40572 .18254 L
s
.40579 .18113 m
.40579 .18113 L
s
.40587 .18137 m
.40587 .18137 L
s
.40594 .17973 m
.40594 .17973 L
s
.40602 .17996 m
.40602 .17996 L
s
.40609 .18043 m
.40609 .18043 L
s
.40617 .1809 m
.40617 .1809 L
s
.40624 .18207 m
.40624 .18207 L
s
.40632 .1809 m
.40632 .1809 L
s
.40639 .18043 m
.40639 .18043 L
s
.40647 .18066 m
.40647 .18066 L
s
.40654 .18113 m
.40654 .18113 L
s
.40661 .18137 m
.40661 .18137 L
s
.40668 .1816 m
.40668 .1816 L
s
.40676 .17996 m
.40676 .17996 L
s
.40684 .1809 m
.40684 .1809 L
s
.40691 .18113 m
.40691 .18113 L
s
.40699 .17973 m
.40699 .17973 L
s
.40706 .1802 m
.40706 .1802 L
s
.40714 .17996 m
.40714 .17996 L
s
.40721 .17831 m
.40721 .17831 L
s
.40729 .17691 m
.40729 .17691 L
s
.40735 .17714 m
.40735 .17714 L
s
.40743 .17738 m
.40743 .17738 L
s
.4075 .17761 m
.4075 .17761 L
s
.40758 .17808 m
.40758 .17808 L
s
.40765 .17996 m
.40765 .17996 L
s
.40773 .17902 m
.40773 .17902 L
s
.4078 .17808 m
.4078 .17808 L
s
.40788 .18043 m
.40788 .18043 L
s
.40795 .1802 m
.40795 .1802 L
s
.40803 .18137 m
.40803 .18137 L
s
.4081 .18184 m
.4081 .18184 L
s
.40817 .18512 m
.40817 .18512 L
s
.40824 .18372 m
.40824 .18372 L
s
.40832 .18372 m
.40832 .18372 L
s
.4084 .18348 m
.4084 .18348 L
s
.40847 .18489 m
.40847 .18489 L
s
.40855 .18606 m
.40855 .18606 L
s
.40862 .18677 m
.40862 .18677 L
s
.4087 .18771 m
.4087 .18771 L
s
.40877 .18583 m
.40877 .18583 L
s
.40885 .18583 m
.40885 .18583 L
s
.40892 .18512 m
.40892 .18512 L
s
.40899 .18536 m
.40899 .18536 L
s
.40906 .18372 m
.40906 .18372 L
s
.40914 .18325 m
.40914 .18325 L
s
.40921 .18254 m
.40921 .18254 L
s
.40929 .18372 m
.40929 .18372 L
s
.40936 .18372 m
.40936 .18372 L
s
.40944 .18301 m
.40944 .18301 L
s
.40951 .18419 m
.40951 .18419 L
s
.40959 .18325 m
.40959 .18325 L
s
.40966 .18419 m
.40966 .18419 L
s
.40973 .18348 m
.40973 .18348 L
s
.4098 .18442 m
.4098 .18442 L
s
.40988 .18254 m
.40988 .18254 L
s
.40996 .1823 m
.40996 .1823 L
s
.41003 .18325 m
.41003 .18325 L
s
.41011 .18325 m
.41011 .18325 L
s
.41018 .18184 m
.41018 .18184 L
s
.41026 .1823 m
.41026 .1823 L
s
.41033 .18325 m
.41033 .18325 L
s
.41041 .18325 m
.41041 .18325 L
s
.41048 .18466 m
.41048 .18466 L
s
.41055 .18184 m
.41055 .18184 L
s
.41062 .18325 m
.41062 .18325 L
s
.4107 .18301 m
.4107 .18301 L
s
.41077 .1823 m
.41077 .1823 L
s
.41085 .18254 m
.41085 .18254 L
s
.41092 .18372 m
.41092 .18372 L
s
.411 .1823 m
.411 .1823 L
s
.41107 .18113 m
.41107 .18113 L
s
.41114 .18254 m
.41114 .18254 L
s
.41122 .1816 m
.41122 .1816 L
s
.4113 .1816 m
.4113 .1816 L
s
.41137 .1802 m
.41137 .1802 L
s
.41144 .18277 m
.41144 .18277 L
s
.41152 .18207 m
.41152 .18207 L
s
.41159 .18277 m
.41159 .18277 L
s
.41167 .18184 m
.41167 .18184 L
s
.41174 .18113 m
.41174 .18113 L
s
.41182 .18254 m
.41182 .18254 L
s
.41189 .1816 m
.41189 .1816 L
s
.41196 .18113 m
.41196 .18113 L
s
.41204 .18277 m
.41204 .18277 L
s
.41212 .18137 m
.41212 .18137 L
s
.41218 .1816 m
.41218 .1816 L
s
.41226 .18137 m
.41226 .18137 L
s
.41233 .18277 m
.41233 .18277 L
s
.41241 .18325 m
.41241 .18325 L
s
.41248 .18301 m
.41248 .18301 L
s
.41256 .18325 m
.41256 .18325 L
s
.41263 .18372 m
.41263 .18372 L
s
.4127 .18277 m
.4127 .18277 L
s
.41277 .18348 m
.41277 .18348 L
s
.41285 .18254 m
.41285 .18254 L
s
.41293 .18466 m
.41293 .18466 L
s
.413 .18348 m
.413 .18348 L
s
.41308 .18559 m
.41308 .18559 L
s
.41315 .18419 m
.41315 .18419 L
s
.41323 .18419 m
.41323 .18419 L
s
.4133 .18325 m
.4133 .18325 L
s
.41338 .1823 m
.41338 .1823 L
s
.41345 .1823 m
.41345 .1823 L
s
.41352 .1823 m
.41352 .1823 L
s
.41359 .18301 m
.41359 .18301 L
s
.41367 .18301 m
.41367 .18301 L
s
.41375 .18395 m
.41375 .18395 L
s
.41382 .18348 m
.41382 .18348 L
s
.41389 .18254 m
.41389 .18254 L
s
.41397 .18137 m
.41397 .18137 L
s
.41404 .18137 m
.41404 .18137 L
s
.41412 .18184 m
.41412 .18184 L
s
.41419 .18043 m
.41419 .18043 L
s
.41427 .1809 m
.41427 .1809 L
s
.41434 .17948 m
.41434 .17948 L
s
.41441 .17902 m
.41441 .17902 L
s
.41448 .17831 m
.41448 .17831 L
s
.41456 .17948 m
.41456 .17948 L
s
.41464 .17855 m
.41464 .17855 L
s
.41471 .17831 m
.41471 .17831 L
s
.41479 .17761 m
.41479 .17761 L
s
.41486 .17714 m
.41486 .17714 L
s
.41494 .17691 m
.41494 .17691 L
s
.41501 .17667 m
.41501 .17667 L
s
.41509 .17596 m
.41509 .17596 L
s
.41515 .17385 m
.41515 .17385 L
s
.41523 .17338 m
.41523 .17338 L
s
.4153 .17033 m
.4153 .17033 L
s
.41538 .17103 m
.41538 .17103 L
s
.41545 .17174 m
.41545 .17174 L
s
.41553 .1715 m
.41553 .1715 L
s
.4156 .16939 m
.4156 .16939 L
s
.41568 .16986 m
.41568 .16986 L
s
.41575 .16845 m
.41575 .16845 L
s
.41583 .16892 m
.41583 .16892 L
s
.4159 .17009 m
.4159 .17009 L
s
.41597 .17009 m
.41597 .17009 L
s
.41604 .17033 m
.41604 .17033 L
s
.41612 .16868 m
.41612 .16868 L
s
.4162 .17033 m
.4162 .17033 L
s
.41627 .16915 m
.41627 .16915 L
s
.41635 .16845 m
.41635 .16845 L
s
.41642 .16821 m
.41642 .16821 L
s
.4165 .16892 m
.4165 .16892 L
s
.41657 .17009 m
.41657 .17009 L
s
.41665 .17056 m
.41665 .17056 L
s
.41672 .17127 m
.41672 .17127 L
s
.41679 .17056 m
.41679 .17056 L
s
.41686 .17127 m
.41686 .17127 L
s
.41694 .1708 m
.41694 .1708 L
s
.41701 .17033 m
.41701 .17033 L
s
.41709 .16915 m
.41709 .16915 L
s
.41716 .16845 m
.41716 .16845 L
s
.41724 .16821 m
.41724 .16821 L
s
.41731 .16704 m
.41731 .16704 L
s
.41739 .16586 m
.41739 .16586 L
s
.41746 .16634 m
.41746 .16634 L
s
.41753 .16704 m
.41753 .16704 L
s
.4176 .16704 m
.4176 .16704 L
s
.41768 .16586 m
.41768 .16586 L
s
.41776 .16469 m
.41776 .16469 L
s
.41783 .16821 m
.41783 .16821 L
s
.41791 .16681 m
.41791 .16681 L
s
.41798 .17009 m
.41798 .17009 L
s
.41806 .16868 m
.41806 .16868 L
s
.41813 .16774 m
.41813 .16774 L
s
.41821 .16727 m
.41821 .16727 L
s
.41828 .16868 m
.41828 .16868 L
s
.41835 .16986 m
.41835 .16986 L
s
.41842 .16868 m
.41842 .16868 L
s
.4185 .16892 m
.4185 .16892 L
s
.41857 .16939 m
.41857 .16939 L
s
.41865 .17009 m
.41865 .17009 L
s
.41872 .16963 m
.41872 .16963 L
s
.4188 .17033 m
.4188 .17033 L
s
.41887 .16963 m
.41887 .16963 L
s
.41895 .17056 m
.41895 .17056 L
s
.41902 .17103 m
.41902 .17103 L
s
.4191 .17197 m
.4191 .17197 L
s
.41917 .17315 m
.41917 .17315 L
s
.41924 .1722 m
.41924 .1722 L
s
.41932 .1722 m
.41932 .1722 L
s
.41939 .17009 m
.41939 .17009 L
s
.41947 .17056 m
.41947 .17056 L
s
.41954 .16939 m
.41954 .16939 L
s
.41962 .16892 m
.41962 .16892 L
s
.41969 .16963 m
.41969 .16963 L
s
.41976 .1708 m
.41976 .1708 L
s
.41984 .17056 m
.41984 .17056 L
s
.41992 .16986 m
.41992 .16986 L
s
.41998 .16892 m
.41998 .16892 L
s
.42006 .16798 m
.42006 .16798 L
s
.42013 .16845 m
.42013 .16845 L
s
.42021 .16727 m
.42021 .16727 L
s
.42028 .16821 m
.42028 .16821 L
s
.42036 .16798 m
.42036 .16798 L
s
.42043 .16939 m
.42043 .16939 L
s
.4205 .16939 m
.4205 .16939 L
s
.42058 .16963 m
.42058 .16963 L
s
.42066 .1708 m
.42066 .1708 L
s
.42073 .16939 m
.42073 .16939 L
s
.4208 .16963 m
.4208 .16963 L
s
.42088 .16939 m
.42088 .16939 L
s
.42095 .16939 m
.42095 .16939 L
s
.42103 .16821 m
.42103 .16821 L
s
.4211 .16986 m
.4211 .16986 L
s
.42118 .17103 m
.42118 .17103 L
s
.42125 .17197 m
.42125 .17197 L
s
.42132 .17174 m
.42132 .17174 L
s
.42139 .17009 m
.42139 .17009 L
s
.42147 .17103 m
.42147 .17103 L
s
.42155 .17009 m
.42155 .17009 L
s
.42162 .17103 m
.42162 .17103 L
s
.42169 .1708 m
.42169 .1708 L
s
.42177 .17244 m
.42177 .17244 L
s
.42184 .17456 m
.42184 .17456 L
s
.42192 .17409 m
.42192 .17409 L
s
.42199 .17291 m
.42199 .17291 L
s
.42207 .17432 m
.42207 .17432 L
s
.42214 .17338 m
.42214 .17338 L
s
.42221 .17174 m
.42221 .17174 L
s
.42229 .17197 m
.42229 .17197 L
s
.42236 .17174 m
.42236 .17174 L
s
.42244 .17267 m
.42244 .17267 L
s
.42251 .17127 m
.42251 .17127 L
s
.42259 .1722 m
.42259 .1722 L
s
.42266 .17197 m
.42266 .17197 L
s
.42274 .17009 m
.42274 .17009 L
s
.42281 .17009 m
.42281 .17009 L
s
.42289 .16915 m
.42289 .16915 L
s
.42295 .16963 m
.42295 .16963 L
s
.42303 .16774 m
.42303 .16774 L
s
.4231 .16774 m
.4231 .16774 L
s
.42318 .16657 m
.42318 .16657 L
s
.42325 .16774 m
.42325 .16774 L
s
.42333 .16681 m
.42333 .16681 L
s
.4234 .16657 m
.4234 .16657 L
s
.42348 .16727 m
.42348 .16727 L
s
.42355 .16821 m
.42355 .16821 L
s
.42363 .16821 m
.42363 .16821 L
s
.4237 .16845 m
.4237 .16845 L
s
.42377 .16915 m
.42377 .16915 L
s
.42384 .17033 m
.42384 .17033 L
s
.42392 .17197 m
.42392 .17197 L
s
.424 .17033 m
.424 .17033 L
s
.42407 .1708 m
.42407 .1708 L
s
.42415 .17033 m
.42415 .17033 L
s
.42422 .17056 m
.42422 .17056 L
s
.4243 .1708 m
.4243 .1708 L
s
.42437 .1715 m
.42437 .1715 L
s
.42445 .17127 m
.42445 .17127 L
s
.42452 .17244 m
.42452 .17244 L
s
.42459 .17338 m
.42459 .17338 L
s
.42466 .17174 m
.42466 .17174 L
s
.42474 .17315 m
.42474 .17315 L
s
.42481 .17315 m
.42481 .17315 L
s
.42489 .17338 m
.42489 .17338 L
s
.42496 .17338 m
.42496 .17338 L
s
.42504 .17526 m
.42504 .17526 L
s
.42511 .17596 m
.42511 .17596 L
s
.42519 .17784 m
.42519 .17784 L
s
.42526 .17808 m
.42526 .17808 L
s
.42533 .17784 m
.42533 .17784 L
s
.4254 .17784 m
.4254 .17784 L
s
.42548 .17714 m
.42548 .17714 L
s
.42556 .17808 m
.42556 .17808 L
s
.42563 .17738 m
.42563 .17738 L
s
.42571 .17761 m
.42571 .17761 L
s
.42578 .1762 m
.42578 .1762 L
s
.42586 .1762 m
.42586 .1762 L
s
.42593 .17691 m
.42593 .17691 L
s
.42601 .1762 m
.42601 .1762 L
s
.42608 .17573 m
.42608 .17573 L
s
.42615 .17644 m
.42615 .17644 L
s
.42622 .17902 m
.42622 .17902 L
s
.4263 .17808 m
.4263 .17808 L
s
.42637 .17831 m
.42637 .17831 L
s
.42645 .17644 m
.42645 .17644 L
s
.42652 .17644 m
.42652 .17644 L
s
.4266 .17691 m
.4266 .17691 L
s
.42667 .17784 m
.42667 .17784 L
s
.42675 .17667 m
.42675 .17667 L
s
.42682 .17479 m
.42682 .17479 L
s
.4269 .17502 m
.4269 .17502 L
s
.42697 .17573 m
.42697 .17573 L
s
.42704 .17691 m
.42704 .17691 L
s
.42712 .17738 m
.42712 .17738 L
s
.42719 .17667 m
.42719 .17667 L
s
.42727 .1762 m
.42727 .1762 L
s
.42734 .17644 m
.42734 .17644 L
s
.42742 .17573 m
.42742 .17573 L
s
.42749 .17644 m
.42749 .17644 L
s
.42757 .17432 m
.42757 .17432 L
s
.42764 .1762 m
.42764 .1762 L
s
.42772 .17667 m
.42772 .17667 L
s
.42778 .17573 m
.42778 .17573 L
s
.42786 .17549 m
.42786 .17549 L
s
.42793 .17432 m
.42793 .17432 L
s
.42801 .17573 m
.42801 .17573 L
s
.42808 .17502 m
.42808 .17502 L
s
.42816 .1762 m
.42816 .1762 L
s
.42823 .17409 m
.42823 .17409 L
s
.4283 .17385 m
.4283 .17385 L
s
.42838 .17338 m
.42838 .17338 L
s
.42846 .17291 m
.42846 .17291 L
s
.42853 .1722 m
.42853 .1722 L
s
.4286 .17291 m
.4286 .17291 L
s
.42868 .17291 m
.42868 .17291 L
s
.42875 .17174 m
.42875 .17174 L
s
.42883 .17338 m
.42883 .17338 L
s
.4289 .17267 m
.4289 .17267 L
s
.42898 .17362 m
.42898 .17362 L
s
.42905 .17197 m
.42905 .17197 L
s
.42912 .1722 m
.42912 .1722 L
s
.4292 .1722 m
.4292 .1722 L
s
.42928 .17244 m
.42928 .17244 L
s
.42935 .1722 m
.42935 .1722 L
s
.42942 .1715 m
.42942 .1715 L
s
.42949 .17267 m
.42949 .17267 L
s
.42957 .1722 m
.42957 .1722 L
s
.42964 .17127 m
.42964 .17127 L
s
.42972 .17197 m
.42972 .17197 L
s
.42979 .17244 m
.42979 .17244 L
s
.42987 .16963 m
.42987 .16963 L
s
.42994 .16939 m
.42994 .16939 L
s
.43001 .17056 m
.43001 .17056 L
s
.43009 .17103 m
.43009 .17103 L
s
.43017 .17197 m
.43017 .17197 L
s
.43024 .17103 m
.43024 .17103 L
s
.43031 .17432 m
.43031 .17432 L
s
.43039 .17385 m
.43039 .17385 L
s
.43046 .17502 m
.43046 .17502 L
s
.43054 .17479 m
.43054 .17479 L
s
.43061 .17526 m
.43061 .17526 L
s
.43069 .17549 m
.43069 .17549 L
s
.43075 .17549 m
.43075 .17549 L
s
.43083 .17526 m
.43083 .17526 L
s
.43091 .17549 m
.43091 .17549 L
s
.43098 .17502 m
.43098 .17502 L
s
.43105 .17456 m
.43105 .17456 L
s
.43113 .17502 m
.43113 .17502 L
s
.4312 .17267 m
.4312 .17267 L
s
.43128 .17197 m
.43128 .17197 L
s
.43135 .17103 m
.43135 .17103 L
s
.43143 .17197 m
.43143 .17197 L
s
.4315 .1708 m
.4315 .1708 L
s
.43157 .17267 m
.43157 .17267 L
s
.43164 .17197 m
.43164 .17197 L
s
.43172 .17267 m
.43172 .17267 L
s
.4318 .17244 m
.4318 .17244 L
s
.43187 .1715 m
.43187 .1715 L
s
.43195 .17291 m
.43195 .17291 L
s
.43202 .17244 m
.43202 .17244 L
s
.4321 .17315 m
.4321 .17315 L
s
.43217 .17362 m
.43217 .17362 L
s
.43225 .17409 m
.43225 .17409 L
s
.43232 .17338 m
.43232 .17338 L
s
.43239 .17338 m
.43239 .17338 L
s
.43246 .17338 m
.43246 .17338 L
s
.43254 .17197 m
.43254 .17197 L
s
.43261 .17385 m
.43261 .17385 L
s
.43269 .17267 m
.43269 .17267 L
s
.43276 .17362 m
.43276 .17362 L
s
.43284 .17362 m
.43284 .17362 L
s
.43291 .17549 m
.43291 .17549 L
s
.43299 .17432 m
.43299 .17432 L
s
.43306 .17432 m
.43306 .17432 L
s
.43314 .17456 m
.43314 .17456 L
s
.4332 .17409 m
.4332 .17409 L
s
.43328 .17385 m
.43328 .17385 L
s
.43336 .17338 m
.43336 .17338 L
s
.43343 .17409 m
.43343 .17409 L
s
.43351 .17456 m
.43351 .17456 L
s
.43358 .17526 m
.43358 .17526 L
s
.43366 .17362 m
.43366 .17362 L
s
.43373 .17502 m
.43373 .17502 L
s
.43381 .17456 m
.43381 .17456 L
s
.43388 .17526 m
.43388 .17526 L
s
.43395 .17409 m
.43395 .17409 L
s
.43402 .17573 m
.43402 .17573 L
s
.4341 .17644 m
.4341 .17644 L
s
.43417 .17573 m
.43417 .17573 L
s
.43425 .17691 m
.43425 .17691 L
s
.43432 .1762 m
.43432 .1762 L
s
.4344 .17526 m
.4344 .17526 L
s
.43447 .17432 m
.43447 .17432 L
s
.43455 .17573 m
.43455 .17573 L
s
.43462 .17456 m
.43462 .17456 L
s
.4347 .17409 m
.4347 .17409 L
s
.43477 .17385 m
.43477 .17385 L
s
.43484 .17291 m
.43484 .17291 L
s
.43492 .17385 m
.43492 .17385 L
s
.43499 .17432 m
.43499 .17432 L
s
.43507 .17432 m
.43507 .17432 L
s
.43514 .17479 m
.43514 .17479 L
s
.43522 .17526 m
.43522 .17526 L
s
.43529 .17385 m
.43529 .17385 L
s
.43537 .17479 m
.43537 .17479 L
s
.43544 .17127 m
.43544 .17127 L
s
.43552 .1708 m
.43552 .1708 L
s
.43558 .17056 m
.43558 .17056 L
s
.43566 .1708 m
.43566 .1708 L
s
.43573 .17174 m
.43573 .17174 L
s
.43581 .17127 m
.43581 .17127 L
s
.43588 .17033 m
.43588 .17033 L
s
.43596 .16915 m
.43596 .16915 L
s
.43603 .16963 m
.43603 .16963 L
s
.43611 .16915 m
.43611 .16915 L
s
.43618 .16963 m
.43618 .16963 L
s
.43626 .16892 m
.43626 .16892 L
s
.43633 .16845 m
.43633 .16845 L
s
.4364 .16939 m
.4364 .16939 L
s
.43648 .16963 m
.43648 .16963 L
s
.43655 .16868 m
.43655 .16868 L
s
.43663 .16681 m
.43663 .16681 L
s
.4367 .16939 m
.4367 .16939 L
s
.43678 .16986 m
.43678 .16986 L
s
.43685 .17033 m
.43685 .17033 L
s
.43692 .16986 m
.43692 .16986 L
s
.437 .17127 m
.437 .17127 L
s
.43708 .16963 m
.43708 .16963 L
s
.43715 .16986 m
.43715 .16986 L
s
.43722 .16939 m
.43722 .16939 L
s
.43729 .17056 m
.43729 .17056 L
s
.43737 .17056 m
.43737 .17056 L
s
.43744 .17056 m
.43744 .17056 L
s
.43752 .16986 m
.43752 .16986 L
s
.43759 .16892 m
.43759 .16892 L
s
.43767 .16963 m
.43767 .16963 L
s
.43774 .16892 m
.43774 .16892 L
s
.43782 .17056 m
.43782 .17056 L
s
.43789 .16963 m
.43789 .16963 L
s
.43797 .17103 m
.43797 .17103 L
s
.43804 .17009 m
.43804 .17009 L
s
.43811 .1708 m
.43811 .1708 L
s
.43819 .17033 m
.43819 .17033 L
s
.43826 .16915 m
.43826 .16915 L
s
.43834 .16657 m
.43834 .16657 L
s
.43841 .16563 m
.43841 .16563 L
s
.43849 .1661 m
.43849 .1661 L
s
.43855 .16492 m
.43855 .16492 L
s
.43863 .16657 m
.43863 .16657 L
s
.43871 .16681 m
.43871 .16681 L
s
.43878 .16751 m
.43878 .16751 L
s
.43885 .16751 m
.43885 .16751 L
s
.43893 .16727 m
.43893 .16727 L
s
.439 .16681 m
.439 .16681 L
s
.43908 .16634 m
.43908 .16634 L
s
.43915 .16751 m
.43915 .16751 L
s
.43923 .16516 m
.43923 .16516 L
s
.4393 .16516 m
.4393 .16516 L
s
.43937 .16469 m
.43937 .16469 L
s
.43945 .16399 m
.43945 .16399 L
s
.43953 .16422 m
.43953 .16422 L
s
.4396 .1621 m
.4396 .1621 L
s
.43967 .1621 m
.43967 .1621 L
s
.43975 .16399 m
.43975 .16399 L
s
.43982 .16492 m
.43982 .16492 L
s
.4399 .16492 m
.4399 .16492 L
s
.43997 .16539 m
.43997 .16539 L
s
.44005 .16352 m
.44005 .16352 L
s
.44012 .16375 m
.44012 .16375 L
s
.44019 .16516 m
.44019 .16516 L
s
.44026 .16563 m
.44026 .16563 L
s
.44034 .16492 m
.44034 .16492 L
s
.44041 .16469 m
.44041 .16469 L
s
.44049 .16422 m
.44049 .16422 L
s
.44056 .16445 m
.44056 .16445 L
s
.44064 .16445 m
.44064 .16445 L
s
.44071 .16375 m
.44071 .16375 L
s
.44079 .16539 m
.44079 .16539 L
s
.44086 .16305 m
.44086 .16305 L
s
.44094 .16375 m
.44094 .16375 L
s
.441 .16281 m
.441 .16281 L
s
.44108 .16164 m
.44108 .16164 L
s
.44116 .16093 m
.44116 .16093 L
s
.44123 .15976 m
.44123 .15976 L
s
.44131 .15953 m
.44131 .15953 L
s
.44138 .15811 m
.44138 .15811 L
s
.44146 .15764 m
.44146 .15764 L
s
.44153 .15835 m
.44153 .15835 L
s
.44161 .15953 m
.44161 .15953 L
s
.44168 .15905 m
.44168 .15905 L
s
.44175 .16023 m
.44175 .16023 L
s
.44182 .16046 m
.44182 .16046 L
s
.4419 .16187 m
.4419 .16187 L
s
.44197 .16117 m
.44197 .16117 L
s
.44205 .16258 m
.44205 .16258 L
s
.44212 .16305 m
.44212 .16305 L
s
.4422 .16399 m
.4422 .16399 L
s
.44227 .16445 m
.44227 .16445 L
s
.44235 .16422 m
.44235 .16422 L
s
.44242 .16516 m
.44242 .16516 L
s
.4425 .16539 m
.4425 .16539 L
s
.44257 .16516 m
.44257 .16516 L
s
.44264 .16375 m
.44264 .16375 L
s
.44272 .16445 m
.44272 .16445 L
s
.44279 .1621 m
.44279 .1621 L
s
.44287 .16375 m
.44287 .16375 L
s
.44294 .16563 m
.44294 .16563 L
s
.44302 .16492 m
.44302 .16492 L
s
.44309 .16586 m
.44309 .16586 L
s
.44317 .16516 m
.44317 .16516 L
s
.44324 .16445 m
.44324 .16445 L
s
.44332 .16281 m
.44332 .16281 L
s
.44338 .16375 m
.44338 .16375 L
s
.44346 .16516 m
.44346 .16516 L
s
.44353 .1661 m
.44353 .1661 L
s
.44361 .16563 m
.44361 .16563 L
s
.44368 .1661 m
.44368 .1661 L
s
.44376 .16634 m
.44376 .16634 L
s
.44383 .16539 m
.44383 .16539 L
s
.44391 .16586 m
.44391 .16586 L
s
.44398 .16586 m
.44398 .16586 L
s
.44406 .16774 m
.44406 .16774 L
s
.44413 .16681 m
.44413 .16681 L
s
.4442 .16774 m
.4442 .16774 L
s
.44428 .16657 m
.44428 .16657 L
s
.44435 .16845 m
.44435 .16845 L
s
.44443 .16774 m
.44443 .16774 L
s
.4445 .16657 m
.4445 .16657 L
s
.44458 .16868 m
.44458 .16868 L
s
.44465 .16821 m
.44465 .16821 L
s
.44473 .16751 m
.44473 .16751 L
s
.4448 .16704 m
.4448 .16704 L
s
.44488 .16774 m
.44488 .16774 L
s
.44495 .16704 m
.44495 .16704 L
s
.44502 .16657 m
.44502 .16657 L
s
.44509 .16469 m
.44509 .16469 L
s
.44517 .16492 m
.44517 .16492 L
s
.44524 .16375 m
.44524 .16375 L
s
.44532 .16492 m
.44532 .16492 L
s
.44539 .16657 m
.44539 .16657 L
s
.44547 .16821 m
.44547 .16821 L
s
.44554 .16915 m
.44554 .16915 L
s
.44562 .16915 m
.44562 .16915 L
s
.44569 .1708 m
.44569 .1708 L
s
.44577 .17103 m
.44577 .17103 L
s
.44584 .1715 m
.44584 .1715 L
s
.44591 .17127 m
.44591 .17127 L
s
.44599 .17338 m
.44599 .17338 L
s
.44606 .17291 m
.44606 .17291 L
s
.44614 .1722 m
.44614 .1722 L
s
.44621 .17127 m
.44621 .17127 L
s
.44629 .17033 m
.44629 .17033 L
s
.44636 .1708 m
.44636 .1708 L
s
.44644 .17127 m
.44644 .17127 L
s
.44651 .17103 m
.44651 .17103 L
s
.44658 .17033 m
.44658 .17033 L
s
.44665 .17244 m
.44665 .17244 L
s
.44673 .17338 m
.44673 .17338 L
s
.4468 .17267 m
.4468 .17267 L
s
.44688 .17573 m
.44688 .17573 L
s
.44695 .1762 m
.44695 .1762 L
s
.44703 .17479 m
.44703 .17479 L
s
.4471 .17409 m
.4471 .17409 L
s
.44717 .17573 m
.44717 .17573 L
s
.44725 .17502 m
.44725 .17502 L
s
.44733 .17573 m
.44733 .17573 L
s
.4474 .17549 m
.4474 .17549 L
s
.44747 .17479 m
.44747 .17479 L
s
.44755 .17315 m
.44755 .17315 L
s
.44762 .17432 m
.44762 .17432 L
s
.4477 .17338 m
.4477 .17338 L
s
.44777 .17338 m
.44777 .17338 L
s
.44785 .17526 m
.44785 .17526 L
s
.44792 .17409 m
.44792 .17409 L
s
.44799 .17549 m
.44799 .17549 L
s
.44807 .17456 m
.44807 .17456 L
s
.44815 .17526 m
.44815 .17526 L
s
.44821 .17409 m
.44821 .17409 L
s
.44829 .17385 m
.44829 .17385 L
s
.44836 .17362 m
.44836 .17362 L
s
.44844 .17502 m
.44844 .17502 L
s
.44851 .17667 m
.44851 .17667 L
s
.44859 .17714 m
.44859 .17714 L
s
.44866 .17714 m
.44866 .17714 L
s
.44874 .17784 m
.44874 .17784 L
s
.4488 .17761 m
.4488 .17761 L
s
.44888 .17738 m
.44888 .17738 L
s
.44896 .17831 m
.44896 .17831 L
s
.44903 .17784 m
.44903 .17784 L
s
.44911 .17902 m
.44911 .17902 L
s
.44918 .17714 m
.44918 .17714 L
s
.44926 .17714 m
.44926 .17714 L
s
.44933 .17738 m
.44933 .17738 L
s
.44941 .17667 m
.44941 .17667 L
s
.44948 .1762 m
.44948 .1762 L
s
.44955 .17644 m
.44955 .17644 L
s
.44962 .17714 m
.44962 .17714 L
s
.4497 .17738 m
.4497 .17738 L
s
.44978 .17761 m
.44978 .17761 L
s
.44985 .17573 m
.44985 .17573 L
s
.44992 .17526 m
.44992 .17526 L
s
.45 .17362 m
.45 .17362 L
s
.45007 .17291 m
.45007 .17291 L
s
.45015 .17362 m
.45015 .17362 L
s
.45022 .17385 m
.45022 .17385 L
s
.4503 .17409 m
.4503 .17409 L
s
.45037 .17338 m
.45037 .17338 L
s
.45044 .17244 m
.45044 .17244 L
s
.45052 .17056 m
.45052 .17056 L
s
.45059 .17127 m
.45059 .17127 L
s
.45067 .17056 m
.45067 .17056 L
s
.45074 .17033 m
.45074 .17033 L
s
.45082 .16986 m
.45082 .16986 L
s
.45089 .16821 m
.45089 .16821 L
s
.45097 .16704 m
.45097 .16704 L
s
.45104 .16563 m
.45104 .16563 L
s
.45112 .16539 m
.45112 .16539 L
s
.45118 .16469 m
.45118 .16469 L
s
.45126 .16657 m
.45126 .16657 L
s
.45133 .16492 m
.45133 .16492 L
s
.45141 .16681 m
.45141 .16681 L
s
.45148 .16681 m
.45148 .16681 L
s
.45156 .16798 m
.45156 .16798 L
s
.45163 .16915 m
.45163 .16915 L
s
.45171 .17009 m
.45171 .17009 L
s
.45178 .16939 m
.45178 .16939 L
s
.45186 .17009 m
.45186 .17009 L
s
.45193 .17103 m
.45193 .17103 L
s
.452 .16915 m
.452 .16915 L
s
.45208 .17056 m
.45208 .17056 L
s
.45215 .16821 m
.45215 .16821 L
s
.45223 .17009 m
.45223 .17009 L
s
.4523 .17033 m
.4523 .17033 L
s
.45238 .17056 m
.45238 .17056 L
s
.45245 .17056 m
.45245 .17056 L
s
.45253 .16892 m
.45253 .16892 L
s
.4526 .16798 m
.4526 .16798 L
s
.45268 .16868 m
.45268 .16868 L
s
.45275 .16939 m
.45275 .16939 L
s
.45282 .16963 m
.45282 .16963 L
s
.45289 .17103 m
.45289 .17103 L
s
.45297 .17127 m
.45297 .17127 L
s
.45304 .17174 m
.45304 .17174 L
s
.45312 .17174 m
.45312 .17174 L
s
.45319 .17103 m
.45319 .17103 L
s
.45327 .1715 m
.45327 .1715 L
s
.45334 .17267 m
.45334 .17267 L
s
.45342 .17315 m
.45342 .17315 L
s
.45349 .17103 m
.45349 .17103 L
s
.45357 .17197 m
.45357 .17197 L
s
.45364 .17174 m
.45364 .17174 L
s
.45371 .17009 m
.45371 .17009 L
s
.45379 .16845 m
.45379 .16845 L
s
.45386 .16892 m
.45386 .16892 L
s
.45394 .16821 m
.45394 .16821 L
s
.45401 .16798 m
.45401 .16798 L
s
.45409 .16821 m
.45409 .16821 L
s
.45416 .16727 m
.45416 .16727 L
s
.45424 .1661 m
.45424 .1661 L
s
.45431 .16634 m
.45431 .16634 L
s
.45438 .16586 m
.45438 .16586 L
s
.45445 .16399 m
.45445 .16399 L
s
.45453 .16539 m
.45453 .16539 L
s
.4546 .16492 m
.4546 .16492 L
s
.45468 .16727 m
.45468 .16727 L
s
.45475 .16774 m
.45475 .16774 L
s
.45483 .17009 m
.45483 .17009 L
s
.4549 .17103 m
.4549 .17103 L
s
.45497 .17009 m
.45497 .17009 L
s
.45505 .17174 m
.45505 .17174 L
s
.45513 .1708 m
.45513 .1708 L
s
.4552 .17127 m
.4552 .17127 L
s
.45527 .17103 m
.45527 .17103 L
s
.45535 .17009 m
.45535 .17009 L
s
.45542 .16892 m
.45542 .16892 L
s
.4555 .16892 m
.4555 .16892 L
s
.45557 .16845 m
.45557 .16845 L
s
.45565 .16892 m
.45565 .16892 L
s
.45572 .16963 m
.45572 .16963 L
s
.45579 .17103 m
.45579 .17103 L
s
.45587 .17291 m
.45587 .17291 L
s
.45595 .1708 m
.45595 .1708 L
s
.45601 .17174 m
.45601 .17174 L
s
.45609 .17127 m
.45609 .17127 L
s
.45616 .17174 m
.45616 .17174 L
s
.45624 .17033 m
.45624 .17033 L
s
.45631 .17127 m
.45631 .17127 L
s
.45639 .1715 m
.45639 .1715 L
s
.45646 .17174 m
.45646 .17174 L
s
.45654 .1715 m
.45654 .1715 L
s
.4566 .17197 m
.4566 .17197 L
s
.45668 .17244 m
.45668 .17244 L
s
.45676 .1708 m
.45676 .1708 L
s
.45683 .17103 m
.45683 .17103 L
s
.45691 .16915 m
.45691 .16915 L
s
.45698 .17009 m
.45698 .17009 L
s
.45706 .16915 m
.45706 .16915 L
s
.45713 .16892 m
.45713 .16892 L
s
.45721 .16963 m
.45721 .16963 L
s
.45728 .16986 m
.45728 .16986 L
s
.45735 .17009 m
.45735 .17009 L
s
.45742 .16892 m
.45742 .16892 L
s
.4575 .17127 m
.4575 .17127 L
s
.45758 .17056 m
.45758 .17056 L
s
.45765 .1708 m
.45765 .1708 L
s
.45772 .17056 m
.45772 .17056 L
s
.4578 .17127 m
.4578 .17127 L
s
.45787 .16986 m
.45787 .16986 L
s
.45795 .16939 m
.45795 .16939 L
s
.45802 .17056 m
.45802 .17056 L
s
.4581 .16915 m
.4581 .16915 L
s
.45817 .17009 m
.45817 .17009 L
s
.45824 .16915 m
.45824 .16915 L
s
.45832 .16845 m
.45832 .16845 L
s
.45839 .16821 m
.45839 .16821 L
s
.45847 .16892 m
.45847 .16892 L
s
.45854 .16751 m
.45854 .16751 L
s
.45862 .16634 m
.45862 .16634 L
s
.45869 .16516 m
.45869 .16516 L
s
.45877 .16657 m
.45877 .16657 L
s
.45884 .16774 m
.45884 .16774 L
s
.45892 .16939 m
.45892 .16939 L
s
.45898 .16868 m
.45898 .16868 L
s
.45906 .16986 m
.45906 .16986 L
s
.45913 .17056 m
.45913 .17056 L
s
.45921 .16774 m
.45921 .16774 L
s
.45928 .1708 m
.45928 .1708 L
s
.45936 .16868 m
.45936 .16868 L
s
.45943 .17127 m
.45943 .17127 L
s
.45951 .1722 m
.45951 .1722 L
s
.45958 .17385 m
.45958 .17385 L
s
.45966 .17456 m
.45966 .17456 L
s
.45973 .17502 m
.45973 .17502 L
s
.4598 .17573 m
.4598 .17573 L
s
.45988 .17691 m
.45988 .17691 L
s
.45995 .17808 m
.45995 .17808 L
s
.46003 .17691 m
.46003 .17691 L
s
.4601 .1762 m
.4601 .1762 L
s
.46018 .17549 m
.46018 .17549 L
s
.46025 .17714 m
.46025 .17714 L
s
.46033 .17667 m
.46033 .17667 L
s
.4604 .17596 m
.4604 .17596 L
s
.46048 .17691 m
.46048 .17691 L
s
.46055 .17714 m
.46055 .17714 L
s
.46062 .17691 m
.46062 .17691 L
s
.46069 .17714 m
.46069 .17714 L
s
.46077 .17996 m
.46077 .17996 L
s
.46084 .17925 m
.46084 .17925 L
s
.46092 .17925 m
.46092 .17925 L
s
.46099 .17761 m
.46099 .17761 L
s
.46107 .17831 m
.46107 .17831 L
s
.46114 .17996 m
.46114 .17996 L
s
.46122 .1802 m
.46122 .1802 L
s
.46129 .18043 m
.46129 .18043 L
s
.46137 .18137 m
.46137 .18137 L
s
.46144 .18254 m
.46144 .18254 L
s
.46151 .18184 m
.46151 .18184 L
s
.46159 .18184 m
.46159 .18184 L
s
.46166 .17973 m
.46166 .17973 L
s
.46174 .17973 m
.46174 .17973 L
s
.46181 .17761 m
.46181 .17761 L
s
.46189 .17667 m
.46189 .17667 L
s
.46196 .17573 m
.46196 .17573 L
s
.46204 .17714 m
.46204 .17714 L
s
.46211 .17691 m
.46211 .17691 L
s
.46218 .17691 m
.46218 .17691 L
s
.46225 .17761 m
.46225 .17761 L
s
.46233 .17456 m
.46233 .17456 L
s
.4624 .17502 m
.4624 .17502 L
s
.46248 .17338 m
.46248 .17338 L
s
.46255 .17362 m
.46255 .17362 L
s
.46263 .1722 m
.46263 .1722 L
s
.4627 .17315 m
.4627 .17315 L
s
.46278 .17244 m
.46278 .17244 L
s
.46285 .17291 m
.46285 .17291 L
s
.46293 .17362 m
.46293 .17362 L
s
.463 .17409 m
.463 .17409 L
s
.46307 .17315 m
.46307 .17315 L
s
.46315 .1708 m
.46315 .1708 L
s
.46322 .17127 m
.46322 .17127 L
s
.4633 .16915 m
.4633 .16915 L
s
.46337 .16868 m
.46337 .16868 L
s
.46345 .16892 m
.46345 .16892 L
s
.46352 .16892 m
.46352 .16892 L
s
.46359 .16868 m
.46359 .16868 L
s
.46367 .16963 m
.46367 .16963 L
s
.46375 .1715 m
.46375 .1715 L
s
.46381 .1708 m
.46381 .1708 L
s
.46389 .17127 m
.46389 .17127 L
s
.46396 .17127 m
.46396 .17127 L
s
.46404 .17127 m
.46404 .17127 L
s
.46411 .17033 m
.46411 .17033 L
s
.46419 .17127 m
.46419 .17127 L
s
.46426 .17056 m
.46426 .17056 L
s
.46434 .16915 m
.46434 .16915 L
s
.46441 .16986 m
.46441 .16986 L
s
.46449 .16915 m
.46449 .16915 L
s
.46457 .16845 m
.46457 .16845 L
s
.46463 .16727 m
.46463 .16727 L
s
.46471 .16774 m
.46471 .16774 L
s
.46478 .16704 m
.46478 .16704 L
s
.46486 .16798 m
.46486 .16798 L
s
.46493 .16774 m
.46493 .16774 L
s
.46501 .16915 m
.46501 .16915 L
s
.46508 .16845 m
.46508 .16845 L
s
.46515 .17056 m
.46515 .17056 L
s
.46522 .17009 m
.46522 .17009 L
s
.4653 .17056 m
.4653 .17056 L
s
.46538 .16892 m
.46538 .16892 L
s
.46545 .16868 m
.46545 .16868 L
s
.46552 .16868 m
.46552 .16868 L
s
.4656 .16821 m
.4656 .16821 L
s
.46567 .16845 m
.46567 .16845 L
s
.46575 .16868 m
.46575 .16868 L
s
.46582 .16963 m
.46582 .16963 L
s
.4659 .16774 m
.4659 .16774 L
s
.46597 .16821 m
.46597 .16821 L
s
.46604 .16774 m
.46604 .16774 L
s
.46612 .16821 m
.46612 .16821 L
s
.4662 .16845 m
.4662 .16845 L
s
.46627 .16727 m
.46627 .16727 L
s
.46634 .16821 m
.46634 .16821 L
s
.46642 .16798 m
.46642 .16798 L
s
.46649 .16868 m
.46649 .16868 L
s
.46657 .16634 m
.46657 .16634 L
s
.46664 .16774 m
.46664 .16774 L
s
.46672 .16704 m
.46672 .16704 L
s
.46678 .16727 m
.46678 .16727 L
s
.46686 .16774 m
.46686 .16774 L
s
.46693 .16727 m
.46693 .16727 L
s
.46701 .16798 m
.46701 .16798 L
s
.46708 .16751 m
.46708 .16751 L
s
.46716 .16774 m
.46716 .16774 L
s
.46723 .16845 m
.46723 .16845 L
s
.46731 .17009 m
.46731 .17009 L
s
.46738 .16915 m
.46738 .16915 L
s
.46746 .16963 m
.46746 .16963 L
s
.46753 .16774 m
.46753 .16774 L
s
.4676 .16986 m
.4676 .16986 L
s
.46768 .16892 m
.46768 .16892 L
s
.46775 .16845 m
.46775 .16845 L
s
.46783 .16986 m
.46783 .16986 L
s
.4679 .16845 m
.4679 .16845 L
s
.46798 .16986 m
.46798 .16986 L
s
.46805 .16939 m
.46805 .16939 L
s
.46813 .17009 m
.46813 .17009 L
s
.4682 .16845 m
.4682 .16845 L
s
.46828 .16963 m
.46828 .16963 L
s
.46835 .16963 m
.46835 .16963 L
s
.46842 .1715 m
.46842 .1715 L
s
.46849 .1715 m
.46849 .1715 L
s
.46857 .16986 m
.46857 .16986 L
s
.46864 .1715 m
.46864 .1715 L
s
.46872 .17174 m
.46872 .17174 L
s
.46879 .1715 m
.46879 .1715 L
s
.46887 .17056 m
.46887 .17056 L
s
.46894 .17197 m
.46894 .17197 L
s
.46902 .17056 m
.46902 .17056 L
s
.46909 .1708 m
.46909 .1708 L
s
.46917 .17056 m
.46917 .17056 L
s
.46924 .17197 m
.46924 .17197 L
s
.46931 .17244 m
.46931 .17244 L
s
.46939 .17197 m
.46939 .17197 L
s
.46946 .17056 m
.46946 .17056 L
s
.46954 .16963 m
.46954 .16963 L
s
.46961 .17103 m
.46961 .17103 L
s
.46969 .16963 m
.46969 .16963 L
s
.46976 .16986 m
.46976 .16986 L
s
.46984 .17009 m
.46984 .17009 L
s
.46991 .16986 m
.46991 .16986 L
s
.46998 .16774 m
.46998 .16774 L
s
.47005 .16774 m
.47005 .16774 L
s
.47013 .16681 m
.47013 .16681 L
s
.4702 .16634 m
.4702 .16634 L
s
.47028 .1661 m
.47028 .1661 L
s
.47035 .16539 m
.47035 .16539 L
s
.47043 .1661 m
.47043 .1661 L
s
.4705 .16516 m
.4705 .16516 L
s
.47058 .16422 m
.47058 .16422 L
s
.47065 .16352 m
.47065 .16352 L
s
.47073 .16399 m
.47073 .16399 L
s
.4708 .16516 m
.4708 .16516 L
s
.47087 .16352 m
.47087 .16352 L
s
.47095 .16281 m
.47095 .16281 L
s
.47102 .1621 m
.47102 .1621 L
s
.4711 .16399 m
.4711 .16399 L
s
.47117 .16305 m
.47117 .16305 L
s
.47125 .16281 m
.47125 .16281 L
s
.47132 .16164 m
.47132 .16164 L
s
.4714 .16281 m
.4714 .16281 L
s
.47147 .16046 m
.47147 .16046 L
s
.47155 .16281 m
.47155 .16281 L
s
.47162 .1621 m
.47162 .1621 L
s
.47169 .16492 m
.47169 .16492 L
s
.47176 .16539 m
.47176 .16539 L
s
.47184 .16634 m
.47184 .16634 L
s
.47191 .1661 m
.47191 .1661 L
s
.47199 .16634 m
.47199 .16634 L
s
.47206 .16774 m
.47206 .16774 L
s
.47214 .16586 m
.47214 .16586 L
s
.47221 .16774 m
.47221 .16774 L
s
.47229 .16634 m
.47229 .16634 L
s
.47237 .16704 m
.47237 .16704 L
s
.47243 .16681 m
.47243 .16681 L
s
.47251 .16727 m
.47251 .16727 L
s
.47258 .16727 m
.47258 .16727 L
s
.47266 .1661 m
.47266 .1661 L
s
.47273 .16774 m
.47273 .16774 L
s
.47281 .16774 m
.47281 .16774 L
s
.47288 .16821 m
.47288 .16821 L
s
.47295 .16657 m
.47295 .16657 L
s
.47303 .16774 m
.47303 .16774 L
s
.47311 .16586 m
.47311 .16586 L
s
.47318 .16704 m
.47318 .16704 L
s
.47325 .16751 m
.47325 .16751 L
s
.47332 .16704 m
.47332 .16704 L
s
.4734 .16657 m
.4734 .16657 L
s
.47347 .16774 m
.47347 .16774 L
s
.47355 .17033 m
.47355 .17033 L
s
.47362 .1722 m
.47362 .1722 L
s
.4737 .17409 m
.4737 .17409 L
s
.47377 .17315 m
.47377 .17315 L
s
.47384 .17385 m
.47384 .17385 L
s
.47392 .17197 m
.47392 .17197 L
s
.474 .1715 m
.474 .1715 L
s
.47407 .17127 m
.47407 .17127 L
s
.47414 .16963 m
.47414 .16963 L
s
.47422 .17009 m
.47422 .17009 L
s
.47429 .16915 m
.47429 .16915 L
s
.47437 .17103 m
.47437 .17103 L
s
.47444 .17009 m
.47444 .17009 L
s
.47452 .17127 m
.47452 .17127 L
s
.47459 .17009 m
.47459 .17009 L
s
.47466 .16939 m
.47466 .16939 L
s
.47474 .17056 m
.47474 .17056 L
s
.47481 .17103 m
.47481 .17103 L
s
.47488 .17009 m
.47488 .17009 L
s
.47496 .17056 m
.47496 .17056 L
s
.47503 .17174 m
.47503 .17174 L
s
.47511 .17127 m
.47511 .17127 L
s
.47518 .17127 m
.47518 .17127 L
s
.47526 .17033 m
.47526 .17033 L
s
.47533 .17315 m
.47533 .17315 L
s
.4754 .17127 m
.4754 .17127 L
s
.47548 .1715 m
.47548 .1715 L
s
.47555 .1722 m
.47555 .1722 L
s
.47563 .17174 m
.47563 .17174 L
s
.4757 .16963 m
.4757 .16963 L
s
.47578 .16963 m
.47578 .16963 L
s
.47585 .17197 m
.47585 .17197 L
s
.47593 .1722 m
.47593 .1722 L
s
.476 .17338 m
.476 .17338 L
s
.47608 .17174 m
.47608 .17174 L
s
.47615 .17174 m
.47615 .17174 L
s
.47622 .17056 m
.47622 .17056 L
s
.47629 .1715 m
.47629 .1715 L
s
.47637 .1708 m
.47637 .1708 L
s
.47645 .1715 m
.47645 .1715 L
s
.47652 .16986 m
.47652 .16986 L
s
.47659 .17009 m
.47659 .17009 L
s
.47667 .17244 m
.47667 .17244 L
s
.47674 .17033 m
.47674 .17033 L
s
.47682 .17174 m
.47682 .17174 L
s
.47689 .17009 m
.47689 .17009 L
s
.47697 .17174 m
.47697 .17174 L
s
.47704 .17197 m
.47704 .17197 L
s
.47711 .17197 m
.47711 .17197 L
s
.47719 .17009 m
.47719 .17009 L
s
.47726 .16986 m
.47726 .16986 L
s
.47734 .17056 m
.47734 .17056 L
s
.47741 .17033 m
.47741 .17033 L
s
.47749 .16939 m
.47749 .16939 L
s
.47756 .16845 m
.47756 .16845 L
s
.47764 .16986 m
.47764 .16986 L
s
.47771 .16798 m
.47771 .16798 L
s
.47778 .1715 m
.47778 .1715 L
s
.47785 .1708 m
.47785 .1708 L
s
.47793 .17103 m
.47793 .17103 L
s
.478 .16868 m
.478 .16868 L
s
.47808 .17056 m
.47808 .17056 L
s
.47815 .1722 m
.47815 .1722 L
s
.47823 .17056 m
.47823 .17056 L
s
.4783 .17009 m
.4783 .17009 L
s
.47838 .16821 m
.47838 .16821 L
s
.47845 .16681 m
.47845 .16681 L
s
.47853 .16704 m
.47853 .16704 L
s
.4786 .16657 m
.4786 .16657 L
s
.47867 .16563 m
.47867 .16563 L
s
.47875 .16657 m
.47875 .16657 L
s
.47882 .16751 m
.47882 .16751 L
s
.4789 .16727 m
.4789 .16727 L
s
.47897 .16539 m
.47897 .16539 L
s
.47905 .16492 m
.47905 .16492 L
s
.47912 .16681 m
.47912 .16681 L
s
.4792 .16492 m
.4792 .16492 L
s
.47927 .16422 m
.47927 .16422 L
s
.47935 .16516 m
.47935 .16516 L
s
.47942 .1661 m
.47942 .1661 L
s
.47949 .16563 m
.47949 .16563 L
s
.47956 .16727 m
.47956 .16727 L
s
.47964 .16563 m
.47964 .16563 L
s
.47971 .16469 m
.47971 .16469 L
s
.47979 .16375 m
.47979 .16375 L
s
.47986 .16539 m
.47986 .16539 L
s
.47994 .16445 m
.47994 .16445 L
s
.48001 .1621 m
.48001 .1621 L
s
.48009 .16305 m
.48009 .16305 L
s
.48017 .16328 m
.48017 .16328 L
s
.48023 .1621 m
.48023 .1621 L
s
.48031 .16117 m
.48031 .16117 L
s
.48038 .16234 m
.48038 .16234 L
s
.48046 .1614 m
.48046 .1614 L
s
.48053 .16117 m
.48053 .16117 L
s
.48061 .16187 m
.48061 .16187 L
s
.48068 .1607 m
.48068 .1607 L
s
.48075 .15976 m
.48075 .15976 L
s
.48083 .15953 m
.48083 .15953 L
s
.48091 .15788 m
.48091 .15788 L
s
.48098 .15788 m
.48098 .15788 L
s
.48105 .15953 m
.48105 .15953 L
s
.48112 .15929 m
.48112 .15929 L
s
.4812 .15929 m
.4812 .15929 L
s
.48127 .15905 m
.48127 .15905 L
s
.48135 .15764 m
.48135 .15764 L
s
.48142 .15835 m
.48142 .15835 L
s
.4815 .15741 m
.4815 .15741 L
s
.48157 .15764 m
.48157 .15764 L
s
.48165 .15764 m
.48165 .15764 L
s
.48173 .156 m
.48173 .156 L
s
.4818 .15506 m
.4818 .15506 L
s
.48187 .15741 m
.48187 .15741 L
s
.48194 .15764 m
.48194 .15764 L
s
.48202 .15882 m
.48202 .15882 L
s
.48209 .15882 m
.48209 .15882 L
s
.48217 .15764 m
.48217 .15764 L
s
.48224 .15858 m
.48224 .15858 L
s
.48232 .15788 m
.48232 .15788 L
s
.48239 .15741 m
.48239 .15741 L
s
.48246 .15764 m
.48246 .15764 L
s
.48254 .15905 m
.48254 .15905 L
s
.48261 .15858 m
.48261 .15858 L
s
.48268 .16023 m
.48268 .16023 L
s
.48276 .16023 m
.48276 .16023 L
s
.48283 .15929 m
.48283 .15929 L
s
.48291 .15999 m
.48291 .15999 L
s
.48298 .16117 m
.48298 .16117 L
s
.48306 .16046 m
.48306 .16046 L
s
.48313 .15858 m
.48313 .15858 L
s
.4832 .15976 m
.4832 .15976 L
s
.48328 .15858 m
.48328 .15858 L
s
.48336 .15858 m
.48336 .15858 L
s
.48343 .15788 m
.48343 .15788 L
s
.4835 .15858 m
.4835 .15858 L
s
.48358 .15741 m
.48358 .15741 L
s
.48365 .15788 m
.48365 .15788 L
s
.48373 .15835 m
.48373 .15835 L
s
.4838 .15976 m
.4838 .15976 L
s
.48388 .16187 m
.48388 .16187 L
s
.48395 .1621 m
.48395 .1621 L
s
.48402 .16469 m
.48402 .16469 L
s
.48409 .16422 m
.48409 .16422 L
s
.48417 .16399 m
.48417 .16399 L
s
.48425 .16399 m
.48425 .16399 L
s
.48432 .16445 m
.48432 .16445 L
s
.48439 .16399 m
.48439 .16399 L
s
.48447 .16375 m
.48447 .16375 L
s
.48454 .16399 m
.48454 .16399 L
s
.48462 .16399 m
.48462 .16399 L
s
.48469 .1661 m
.48469 .1661 L
s
.48477 .16563 m
.48477 .16563 L
s
.48484 .16492 m
.48484 .16492 L
s
.48491 .16586 m
.48491 .16586 L
s
.48499 .16751 m
.48499 .16751 L
s
.48506 .16516 m
.48506 .16516 L
s
.48514 .16586 m
.48514 .16586 L
s
.48521 .16445 m
.48521 .16445 L
s
.48529 .16234 m
.48529 .16234 L
s
.48536 .15953 m
.48536 .15953 L
s
.48544 .15882 m
.48544 .15882 L
s
.48551 .15999 m
.48551 .15999 L
s
.48558 .15858 m
.48558 .15858 L
s
.48565 .15976 m
.48565 .15976 L
s
.48573 .15811 m
.48573 .15811 L
s
.4858 .15976 m
.4858 .15976 L
s
.48588 .15929 m
.48588 .15929 L
s
.48595 .15929 m
.48595 .15929 L
s
.48603 .15929 m
.48603 .15929 L
s
.4861 .15953 m
.4861 .15953 L
s
.48618 .15999 m
.48618 .15999 L
s
.48625 .15835 m
.48625 .15835 L
s
.48633 .15999 m
.48633 .15999 L
s
.4864 .15999 m
.4864 .15999 L
s
.48647 .15929 m
.48647 .15929 L
s
.48655 .15811 m
.48655 .15811 L
s
.48662 .15835 m
.48662 .15835 L
s
.4867 .15671 m
.4867 .15671 L
s
.48677 .15835 m
.48677 .15835 L
s
.48685 .15929 m
.48685 .15929 L
s
.48692 .15976 m
.48692 .15976 L
s
.487 .1614 m
.487 .1614 L
s
.48707 .1607 m
.48707 .1607 L
s
.48715 .1621 m
.48715 .1621 L
s
.48722 .16352 m
.48722 .16352 L
s
.48729 .16469 m
.48729 .16469 L
s
.48736 .16164 m
.48736 .16164 L
s
.48744 .16305 m
.48744 .16305 L
s
.48751 .16117 m
.48751 .16117 L
s
.48759 .16164 m
.48759 .16164 L
s
.48766 .16187 m
.48766 .16187 L
s
.48774 .16281 m
.48774 .16281 L
s
.48781 .16305 m
.48781 .16305 L
s
.48789 .16234 m
.48789 .16234 L
s
.48797 .16305 m
.48797 .16305 L
s
.48803 .16281 m
.48803 .16281 L
s
.48811 .16187 m
.48811 .16187 L
s
.48818 .16187 m
.48818 .16187 L
s
.48826 .16117 m
.48826 .16117 L
s
.48833 .1614 m
.48833 .1614 L
s
.48841 .16117 m
.48841 .16117 L
s
.48848 .16187 m
.48848 .16187 L
s
.48856 .16117 m
.48856 .16117 L
s
.48863 .16164 m
.48863 .16164 L
s
.48871 .15882 m
.48871 .15882 L
s
.48878 .15999 m
.48878 .15999 L
s
.48885 .15671 m
.48885 .15671 L
s
.48892 .15741 m
.48892 .15741 L
s
.489 .15576 m
.489 .15576 L
s
.48907 .15647 m
.48907 .15647 L
s
.48915 .15741 m
.48915 .15741 L
s
.48922 .15717 m
.48922 .15717 L
s
.4893 .15764 m
.4893 .15764 L
s
.48937 .15553 m
.48937 .15553 L
s
.48945 .15624 m
.48945 .15624 L
s
.48953 .15459 m
.48953 .15459 L
s
.4896 .15482 m
.4896 .15482 L
s
.48967 .15342 m
.48967 .15342 L
s
.48974 .15389 m
.48974 .15389 L
s
.48982 .15271 m
.48982 .15271 L
s
.48989 .15083 m
.48989 .15083 L
s
.48997 .14895 m
.48997 .14895 L
s
.49004 .14943 m
.49004 .14943 L
s
.49012 .14895 m
.49012 .14895 L
s
.49019 .14872 m
.49019 .14872 L
s
.49027 .14872 m
.49027 .14872 L
s
.49034 .14943 m
.49034 .14943 L
s
.49041 .14966 m
.49041 .14966 L
s
.49048 .14919 m
.49048 .14919 L
s
.49056 .14989 m
.49056 .14989 L
s
.49063 .15013 m
.49063 .15013 L
s
.49071 .15013 m
.49071 .15013 L
s
.49078 .14872 m
.49078 .14872 L
s
.49086 .14895 m
.49086 .14895 L
s
.49093 .14989 m
.49093 .14989 L
s
.491 .15036 m
.491 .15036 L
s
.49108 .14943 m
.49108 .14943 L
s
.49116 .14825 m
.49116 .14825 L
s
.49123 .14825 m
.49123 .14825 L
s
.4913 .14707 m
.4913 .14707 L
s
.49138 .14707 m
.49138 .14707 L
s
.49145 .14778 m
.49145 .14778 L
s
.49153 .14614 m
.49153 .14614 L
s
.4916 .1459 m
.4916 .1459 L
s
.49168 .14614 m
.49168 .14614 L
s
.49175 .1459 m
.49175 .1459 L
s
.49182 .14496 m
.49182 .14496 L
s
.4919 .14519 m
.4919 .14519 L
s
.49198 .14472 m
.49198 .14472 L
s
.49205 .14355 m
.49205 .14355 L
s
.49212 .14167 m
.49212 .14167 L
s
.49219 .14167 m
.49219 .14167 L
s
.49227 .14026 m
.49227 .14026 L
s
.49234 .14003 m
.49234 .14003 L
s
.49242 .1405 m
.49242 .1405 L
s
.49249 .13956 m
.49249 .13956 L
s
.49257 .14026 m
.49257 .14026 L
s
.49264 .13861 m
.49264 .13861 L
s
.49271 .1405 m
.49271 .1405 L
s
.49279 .1405 m
.49279 .1405 L
s
.49286 .14073 m
.49286 .14073 L
s
.49294 .14073 m
.49294 .14073 L
s
.49301 .14097 m
.49301 .14097 L
s
.49309 .14097 m
.49309 .14097 L
s
.49316 .1412 m
.49316 .1412 L
s
.49324 .14097 m
.49324 .14097 L
s
.49331 .1419 m
.49331 .1419 L
s
.49338 .14379 m
.49338 .14379 L
s
.49345 .14402 m
.49345 .14402 L
s
.49353 .14308 m
.49353 .14308 L
s
.49361 .14285 m
.49361 .14285 L
s
.49368 .14332 m
.49368 .14332 L
s
.49375 .14332 m
.49375 .14332 L
s
.49383 .14425 m
.49383 .14425 L
s
.4939 .14308 m
.4939 .14308 L
s
.49398 .14425 m
.49398 .14425 L
s
.49405 .14425 m
.49405 .14425 L
s
.49413 .14472 m
.49413 .14472 L
s
.4942 .14567 m
.4942 .14567 L
s
.49427 .14496 m
.49427 .14496 L
s
.49435 .14567 m
.49435 .14567 L
s
.49442 .14543 m
.49442 .14543 L
s
.4945 .14825 m
.4945 .14825 L
s
.49457 .14661 m
.49457 .14661 L
s
.49465 .14731 m
.49465 .14731 L
s
.49472 .14707 m
.49472 .14707 L
s
.4948 .14848 m
.4948 .14848 L
s
.49487 .14872 m
.49487 .14872 L
s
.49495 .14707 m
.49495 .14707 L
s
.49502 .14801 m
.49502 .14801 L
s
.49509 .14661 m
.49509 .14661 L
s
.49516 .15036 m
.49516 .15036 L
s
.49524 .15013 m
.49524 .15013 L
s
.49531 .15224 m
.49531 .15224 L
s
.49539 .15318 m
.49539 .15318 L
s
.49546 .15365 m
.49546 .15365 L
s
.49554 .15271 m
.49554 .15271 L
s
.49561 .15365 m
.49561 .15365 L
s
.49569 .15342 m
.49569 .15342 L
s
.49577 .152 m
.49577 .152 L
s
.49583 .15365 m
.49583 .15365 L
s
.49591 .15224 m
.49591 .15224 L
s
.49598 .152 m
.49598 .152 L
s
.49606 .15013 m
.49606 .15013 L
s
.49613 .15107 m
.49613 .15107 L
s
.49621 .15013 m
.49621 .15013 L
s
.49628 .15083 m
.49628 .15083 L
s
.49636 .15036 m
.49636 .15036 L
s
.49643 .14989 m
.49643 .14989 L
s
.49651 .1513 m
.49651 .1513 L
s
.49658 .14966 m
.49658 .14966 L
s
.49665 .1506 m
.49665 .1506 L
s
.49672 .15013 m
.49672 .15013 L
s
.4968 .1506 m
.4968 .1506 L
s
.49687 .14943 m
.49687 .14943 L
s
.49695 .14895 m
.49695 .14895 L
s
.49702 .14872 m
.49702 .14872 L
s
.4971 .14943 m
.4971 .14943 L
s
.49717 .14943 m
.49717 .14943 L
s
.49725 .14989 m
.49725 .14989 L
s
.49733 .15271 m
.49733 .15271 L
s
.4974 .1513 m
.4974 .1513 L
s
.49747 .15224 m
.49747 .15224 L
s
.49754 .14966 m
.49754 .14966 L
s
.49762 .15083 m
.49762 .15083 L
s
.49769 .14989 m
.49769 .14989 L
s
.49777 .14989 m
.49777 .14989 L
s
.49784 .14848 m
.49784 .14848 L
s
.49792 .14895 m
.49792 .14895 L
s
.49799 .14754 m
.49799 .14754 L
s
.49807 .14731 m
.49807 .14731 L
s
.49814 .14637 m
.49814 .14637 L
s
.49821 .14661 m
.49821 .14661 L
s
.49828 .14825 m
.49828 .14825 L
s
.49836 .1459 m
.49836 .1459 L
s
.49843 .14707 m
.49843 .14707 L
s
.49851 .14496 m
.49851 .14496 L
s
.49858 .14449 m
.49858 .14449 L
s
.49866 .14472 m
.49866 .14472 L
s
.49873 .14543 m
.49873 .14543 L
s
.49881 .14472 m
.49881 .14472 L
s
.49889 .14543 m
.49889 .14543 L
s
.49896 .14661 m
.49896 .14661 L
s
.49903 .14567 m
.49903 .14567 L
s
.4991 .14661 m
.4991 .14661 L
s
.49918 .14637 m
.49918 .14637 L
s
.49925 .14825 m
.49925 .14825 L
s
.49933 .14778 m
.49933 .14778 L
s
.4994 .15013 m
.4994 .15013 L
s
.49948 .15107 m
.49948 .15107 L
s
.49955 .15365 m
.49955 .15365 L
s
.49962 .15389 m
.49962 .15389 L
s
.4997 .15271 m
.4997 .15271 L
s
.49978 .15295 m
.49978 .15295 L
s
.49985 .152 m
.49985 .152 L
s
.49992 .15459 m
.49992 .15459 L
s
.49999 .15224 m
.49999 .15224 L
s
.50007 .15318 m
.50007 .15318 L
s
.50014 .15248 m
.50014 .15248 L
s
.50022 .15318 m
.50022 .15318 L
s
.50029 .15342 m
.50029 .15342 L
s
.50037 .15318 m
.50037 .15318 L
s
.50044 .15389 m
.50044 .15389 L
s
.50052 .15342 m
.50052 .15342 L
s
.5006 .15295 m
.5006 .15295 L
s
.50066 .15224 m
.50066 .15224 L
s
.50074 .15365 m
.50074 .15365 L
s
.50081 .15365 m
.50081 .15365 L
s
.50089 .15459 m
.50089 .15459 L
s
.50096 .15177 m
.50096 .15177 L
s
.50104 .15013 m
.50104 .15013 L
s
.50111 .14872 m
.50111 .14872 L
s
.50118 .14943 m
.50118 .14943 L
s
.50125 .15036 m
.50125 .15036 L
s
.50133 .15013 m
.50133 .15013 L
s
.50141 .15083 m
.50141 .15083 L
s
.50148 .14989 m
.50148 .14989 L
s
.50155 .1506 m
.50155 .1506 L
s
.50163 .15036 m
.50163 .15036 L
s
.5017 .15154 m
.5017 .15154 L
s
.50178 .14872 m
.50178 .14872 L
s
.50185 .14919 m
.50185 .14919 L
s
.50193 .14778 m
.50193 .14778 L
s
.502 .14848 m
.502 .14848 L
s
.50207 .14707 m
.50207 .14707 L
s
.50215 .14661 m
.50215 .14661 L
s
.50223 .14778 m
.50223 .14778 L
s
.5023 .14731 m
.5023 .14731 L
s
.50237 .14919 m
.50237 .14919 L
s
.50245 .14778 m
.50245 .14778 L
s
.50252 .14825 m
.50252 .14825 L
s
.5026 .14754 m
.5026 .14754 L
s
.50267 .14731 m
.50267 .14731 L
s
.50275 .1459 m
.50275 .1459 L
s
.50282 .14637 m
.50282 .14637 L
s
.50289 .14449 m
.50289 .14449 L
s
.50296 .1459 m
.50296 .1459 L
s
.50304 .14519 m
.50304 .14519 L
s
.50311 .14449 m
.50311 .14449 L
s
.50319 .14472 m
.50319 .14472 L
s
.50326 .14214 m
.50326 .14214 L
s
.50334 .14214 m
.50334 .14214 L
s
.50341 .1405 m
.50341 .1405 L
s
.50349 .14167 m
.50349 .14167 L
s
.50357 .1405 m
.50357 .1405 L
s
.50363 .1412 m
.50363 .1412 L
s
.50371 .14285 m
.50371 .14285 L
s
.50378 .14214 m
.50378 .14214 L
s
.50386 .14285 m
.50386 .14285 L
s
.50393 .13933 m
.50393 .13933 L
s
.50401 .14026 m
.50401 .14026 L
s
.50408 .14003 m
.50408 .14003 L
s
.50416 .1412 m
.50416 .1412 L
s
.50423 .14167 m
.50423 .14167 L
s
.50431 .14143 m
.50431 .14143 L
s
.50438 .14097 m
.50438 .14097 L
s
.50445 .1405 m
.50445 .1405 L
s
.50452 .14261 m
.50452 .14261 L
s
.5046 .14238 m
.5046 .14238 L
s
.50467 .1419 m
.50467 .1419 L
s
.50475 .1419 m
.50475 .1419 L
s
.50482 .14332 m
.50482 .14332 L
s
.5049 .14167 m
.5049 .14167 L
s
.50497 .14214 m
.50497 .14214 L
s
.50505 .14003 m
.50505 .14003 L
s
.50513 .13979 m
.50513 .13979 L
s
.5052 .13838 m
.5052 .13838 L
s
.50527 .13768 m
.50527 .13768 L
s
.50534 .13815 m
.50534 .13815 L
s
.50542 .13956 m
.50542 .13956 L
s
.50549 .1405 m
.50549 .1405 L
s
.50557 .13861 m
.50557 .13861 L
s
.50564 .13886 m
.50564 .13886 L
s
.50572 .13886 m
.50572 .13886 L
s
.50579 .13721 m
.50579 .13721 L
s
.50587 .13627 m
.50587 .13627 L
s
.50594 .13557 m
.50594 .13557 L
s
.50602 .13462 m
.50602 .13462 L
s
.50608 .13392 m
.50608 .13392 L
s
.50616 .13462 m
.50616 .13462 L
s
.50623 .13533 m
.50623 .13533 L
s
.50631 .13768 m
.50631 .13768 L
s
.50638 .13838 m
.50638 .13838 L
s
.50646 .14026 m
.50646 .14026 L
s
.50653 .14003 m
.50653 .14003 L
s
.50661 .13909 m
.50661 .13909 L
s
.50669 .13721 m
.50669 .13721 L
s
.50676 .13886 m
.50676 .13886 L
s
.50683 .13956 m
.50683 .13956 L
s
.5069 .13838 m
.5069 .13838 L
s
.50698 .13721 m
.50698 .13721 L
s
.50705 .13674 m
.50705 .13674 L
s
.50713 .13744 m
.50713 .13744 L
s
.5072 .13627 m
.5072 .13627 L
s
.50728 .13768 m
.50728 .13768 L
s
.50735 .1358 m
.50735 .1358 L
s
.50743 .1358 m
.50743 .1358 L
s
.5075 .13533 m
.5075 .13533 L
s
.50758 .13533 m
.50758 .13533 L
s
.50765 .13604 m
.50765 .13604 L
s
.50772 .13392 m
.50772 .13392 L
s
.50779 .13322 m
.50779 .13322 L
s
.50787 .13322 m
.50787 .13322 L
s
.50794 .13369 m
.50794 .13369 L
s
.50802 .13251 m
.50802 .13251 L
s
.50809 .13439 m
.50809 .13439 L
s
.50817 .13533 m
.50817 .13533 L
s
.50824 .13604 m
.50824 .13604 L
s
.50832 .13486 m
.50832 .13486 L
s
.5084 .13439 m
.5084 .13439 L
s
.50846 .13345 m
.50846 .13345 L
s
.50854 .13462 m
.50854 .13462 L
s
.50861 .13604 m
.50861 .13604 L
s
.50869 .13721 m
.50869 .13721 L
s
.50876 .1358 m
.50876 .1358 L
s
.50884 .13392 m
.50884 .13392 L
s
.50891 .13462 m
.50891 .13462 L
s
.50899 .13369 m
.50899 .13369 L
s
.50906 .13415 m
.50906 .13415 L
s
.50914 .13345 m
.50914 .13345 L
s
.50921 .13345 m
.50921 .13345 L
s
.50928 .13345 m
.50928 .13345 L
s
.50935 .13345 m
.50935 .13345 L
s
.50943 .1324 m
.50943 .1324 L
s
.5095 .13415 m
.5095 .13415 L
s
.50958 .13744 m
.50958 .13744 L
s
.50965 .13768 m
.50965 .13768 L
s
.50973 .13533 m
.50973 .13533 L
s
.5098 .13345 m
.5098 .13345 L
s
.50987 .13369 m
.50987 .13369 L
s
.50995 .13345 m
.50995 .13345 L
s
.51003 .13369 m
.51003 .13369 L
s
.5101 .13439 m
.5101 .13439 L
s
.51017 .13345 m
.51017 .13345 L
s
.51025 .13439 m
.51025 .13439 L
s
.51032 .13369 m
.51032 .13369 L
s
.5104 .13509 m
.5104 .13509 L
s
.51047 .13557 m
.51047 .13557 L
s
.51055 .13557 m
.51055 .13557 L
s
.51062 .13486 m
.51062 .13486 L
s
.51069 .1358 m
.51069 .1358 L
s
.51077 .13533 m
.51077 .13533 L
s
.51085 .1358 m
.51085 .1358 L
s
.51091 .13674 m
.51091 .13674 L
s
.51099 .13604 m
.51099 .13604 L
s
.51106 .13651 m
.51106 .13651 L
s
.51114 .13604 m
.51114 .13604 L
s
.51121 .13721 m
.51121 .13721 L
s
.51129 .13815 m
.51129 .13815 L
s
.51137 .14026 m
.51137 .14026 L
s
.51143 .13909 m
.51143 .13909 L
s
.51151 .1419 m
.51151 .1419 L
s
.51158 .14214 m
.51158 .14214 L
s
.51166 .14214 m
.51166 .14214 L
s
.51173 .1412 m
.51173 .1412 L
s
.51181 .14238 m
.51181 .14238 L
s
.51188 .14425 m
.51188 .14425 L
s
.51196 .14308 m
.51196 .14308 L
s
.51203 .14543 m
.51203 .14543 L
s
.51211 .14567 m
.51211 .14567 L
s
.51218 .14614 m
.51218 .14614 L
s
.51225 .14684 m
.51225 .14684 L
s
.51232 .14707 m
.51232 .14707 L
s
.5124 .14661 m
.5124 .14661 L
s
.51248 .14731 m
.51248 .14731 L
s
.51255 .14848 m
.51255 .14848 L
s
.51262 .14778 m
.51262 .14778 L
s
.5127 .14614 m
.5127 .14614 L
s
.51277 .14778 m
.51277 .14778 L
s
.51285 .14943 m
.51285 .14943 L
s
.51293 .14966 m
.51293 .14966 L
s
.513 .15224 m
.513 .15224 L
s
.51307 .15224 m
.51307 .15224 L
s
.51314 .15177 m
.51314 .15177 L
s
.51322 .15036 m
.51322 .15036 L
s
.51329 .15036 m
.51329 .15036 L
s
.51337 .15177 m
.51337 .15177 L
s
.51344 .15013 m
.51344 .15013 L
s
.51352 .14989 m
.51352 .14989 L
s
.51359 .14848 m
.51359 .14848 L
s
.51367 .14848 m
.51367 .14848 L
s
.51374 .14919 m
.51374 .14919 L
s
.51382 .14848 m
.51382 .14848 L
s
.51388 .14754 m
.51388 .14754 L
s
.51396 .14754 m
.51396 .14754 L
s
.51403 .14848 m
.51403 .14848 L
s
.51411 .14731 m
.51411 .14731 L
s
.51418 .14661 m
.51418 .14661 L
s
.51426 .1459 m
.51426 .1459 L
s
.51433 .1459 m
.51433 .1459 L
s
.51441 .14379 m
.51441 .14379 L
s
.51449 .14379 m
.51449 .14379 L
s
.51456 .14261 m
.51456 .14261 L
s
.51463 .14425 m
.51463 .14425 L
s
.5147 .14567 m
.5147 .14567 L
s
.51478 .1459 m
.51478 .1459 L
s
.51485 .14614 m
.51485 .14614 L
s
.51493 .14519 m
.51493 .14519 L
s
.515 .14661 m
.515 .14661 L
s
.51508 .14801 m
.51508 .14801 L
s
.51515 .14754 m
.51515 .14754 L
s
.51523 .14848 m
.51523 .14848 L
s
.5153 .14895 m
.5153 .14895 L
s
.51538 .14567 m
.51538 .14567 L
s
.51545 .14519 m
.51545 .14519 L
s
.51552 .14543 m
.51552 .14543 L
s
.51559 .14567 m
.51559 .14567 L
s
.51567 .14661 m
.51567 .14661 L
s
.51574 .14637 m
.51574 .14637 L
s
.51582 .14778 m
.51582 .14778 L
s
.51589 .14707 m
.51589 .14707 L
s
.51597 .14543 m
.51597 .14543 L
s
.51604 .14449 m
.51604 .14449 L
s
.51612 .14567 m
.51612 .14567 L
s
.5162 .14496 m
.5162 .14496 L
s
.51626 .14496 m
.51626 .14496 L
s
.51634 .14519 m
.51634 .14519 L
s
.51641 .14661 m
.51641 .14661 L
s
.51649 .14707 m
.51649 .14707 L
s
.51656 .14661 m
.51656 .14661 L
s
.51664 .14707 m
.51664 .14707 L
s
.51671 .14684 m
.51671 .14684 L
s
.51679 .14707 m
.51679 .14707 L
s
.51686 .14825 m
.51686 .14825 L
s
.51694 .14989 m
.51694 .14989 L
s
.51701 .14872 m
.51701 .14872 L
s
.51708 .14943 m
.51708 .14943 L
s
.51715 .14825 m
.51715 .14825 L
s
.51723 .14989 m
.51723 .14989 L
s
.5173 .14895 m
.5173 .14895 L
s
.51738 .14943 m
.51738 .14943 L
s
.51745 .14895 m
.51745 .14895 L
s
.51753 .14848 m
.51753 .14848 L
s
.5176 .15083 m
.5176 .15083 L
s
.51767 .15013 m
.51767 .15013 L
s
.51775 .15224 m
.51775 .15224 L
s
.51783 .14989 m
.51783 .14989 L
s
.5179 .1513 m
.5179 .1513 L
s
.51797 .15036 m
.51797 .15036 L
s
.51805 .14966 m
.51805 .14966 L
s
.51812 .15083 m
.51812 .15083 L
s
.5182 .14895 m
.5182 .14895 L
s
.51827 .15013 m
.51827 .15013 L
s
.51835 .15036 m
.51835 .15036 L
s
.51842 .15224 m
.51842 .15224 L
s
.51849 .15013 m
.51849 .15013 L
s
.51857 .15013 m
.51857 .15013 L
s
.51865 .14989 m
.51865 .14989 L
s
.51871 .15083 m
.51871 .15083 L
s
.51879 .15154 m
.51879 .15154 L
s
.51886 .14895 m
.51886 .14895 L
s
.51894 .14895 m
.51894 .14895 L
s
.51901 .14801 m
.51901 .14801 L
s
.51909 .14989 m
.51909 .14989 L
s
.51917 .14801 m
.51917 .14801 L
s
.51923 .14872 m
.51923 .14872 L
s
.51931 .14731 m
.51931 .14731 L
s
.51939 .14919 m
.51939 .14919 L
s
.51946 .14731 m
.51946 .14731 L
s
.51953 .14661 m
.51953 .14661 L
s
.51961 .14496 m
.51961 .14496 L
s
.51968 .14355 m
.51968 .14355 L
s
.51976 .14425 m
.51976 .14425 L
s
.51983 .14519 m
.51983 .14519 L
s
.51991 .14519 m
.51991 .14519 L
s
.51998 .14472 m
.51998 .14472 L
s
.52005 .14754 m
.52005 .14754 L
s
.52012 .14567 m
.52012 .14567 L
s
.5202 .14754 m
.5202 .14754 L
s
.52028 .14614 m
.52028 .14614 L
s
.52035 .14825 m
.52035 .14825 L
s
.52042 .14848 m
.52042 .14848 L
s
.5205 .14825 m
.5205 .14825 L
s
.52057 .14966 m
.52057 .14966 L
s
.52065 .14966 m
.52065 .14966 L
s
.52073 .14943 m
.52073 .14943 L
s
.5208 .14778 m
.5208 .14778 L
s
.52087 .14848 m
.52087 .14848 L
s
.52094 .14778 m
.52094 .14778 L
s
.52102 .14943 m
.52102 .14943 L
s
.52109 .14754 m
.52109 .14754 L
s
.52117 .14801 m
.52117 .14801 L
s
.52124 .14614 m
.52124 .14614 L
s
.52132 .14637 m
.52132 .14637 L
s
.52139 .14661 m
.52139 .14661 L
s
.52147 .1459 m
.52147 .1459 L
s
.52154 .14731 m
.52154 .14731 L
s
.52162 .14684 m
.52162 .14684 L
s
.52168 .14825 m
.52168 .14825 L
s
.52176 .14848 m
.52176 .14848 L
s
.52183 .14943 m
.52183 .14943 L
s
.52191 .14895 m
.52191 .14895 L
s
.52198 .15036 m
.52198 .15036 L
s
.52206 .14989 m
.52206 .14989 L
s
.52213 .1506 m
.52213 .1506 L
s
.52221 .15224 m
.52221 .15224 L
s
.52229 .15154 m
.52229 .15154 L
s
.52236 .15435 m
.52236 .15435 L
s
.52243 .15365 m
.52243 .15365 L
s
.5225 .15435 m
.5225 .15435 L
s
.52258 .15482 m
.52258 .15482 L
s
.52265 .15506 m
.52265 .15506 L
s
.52273 .15318 m
.52273 .15318 L
s
.5228 .15271 m
.5228 .15271 L
s
.52288 .15365 m
.52288 .15365 L
s
.52295 .15295 m
.52295 .15295 L
s
.52303 .15342 m
.52303 .15342 L
s
.5231 .152 m
.5231 .152 L
s
.52318 .15459 m
.52318 .15459 L
s
.52325 .15459 m
.52325 .15459 L
s
.52332 .156 m
.52332 .156 L
s
.52339 .15576 m
.52339 .15576 L
s
.52347 .15671 m
.52347 .15671 L
s
.52354 .15858 m
.52354 .15858 L
s
.52362 .15717 m
.52362 .15717 L
s
.52369 .15811 m
.52369 .15811 L
s
.52377 .15647 m
.52377 .15647 L
s
.52385 .15694 m
.52385 .15694 L
s
.52392 .15576 m
.52392 .15576 L
s
.524 .15624 m
.524 .15624 L
s
.52406 .15576 m
.52406 .15576 L
s
.52414 .15647 m
.52414 .15647 L
s
.52421 .15553 m
.52421 .15553 L
s
.52429 .15435 m
.52429 .15435 L
s
.52436 .15412 m
.52436 .15412 L
s
.52444 .15506 m
.52444 .15506 L
s
.52451 .15553 m
.52451 .15553 L
s
.52459 .15529 m
.52459 .15529 L
s
.52466 .15764 m
.52466 .15764 L
s
.52474 .15576 m
.52474 .15576 L
s
.52481 .15741 m
.52481 .15741 L
s
.52488 .15647 m
.52488 .15647 L
s
.52495 .15671 m
.52495 .15671 L
s
.52503 .15694 m
.52503 .15694 L
s
.5251 .15764 m
.5251 .15764 L
s
.52518 .15647 m
.52518 .15647 L
s
.52525 .15671 m
.52525 .15671 L
s
.52533 .15671 m
.52533 .15671 L
s
.5254 .15835 m
.5254 .15835 L
s
.52548 .15905 m
.52548 .15905 L
s
.52556 .15764 m
.52556 .15764 L
s
.52563 .15858 m
.52563 .15858 L
s
.5257 .15764 m
.5257 .15764 L
s
.52577 .15647 m
.52577 .15647 L
s
.52585 .15788 m
.52585 .15788 L
s
.52592 .15764 m
.52592 .15764 L
s
.526 .15835 m
.526 .15835 L
s
.52607 .15835 m
.52607 .15835 L
s
.52615 .15788 m
.52615 .15788 L
s
.52622 .15741 m
.52622 .15741 L
s
.52629 .15717 m
.52629 .15717 L
s
.52637 .15576 m
.52637 .15576 L
s
.52645 .15624 m
.52645 .15624 L
s
.52651 .15482 m
.52651 .15482 L
s
.52659 .15576 m
.52659 .15576 L
s
.52666 .15671 m
.52666 .15671 L
s
.52674 .15624 m
.52674 .15624 L
s
.52681 .15553 m
.52681 .15553 L
s
.52689 .15435 m
.52689 .15435 L
s
.52697 .15506 m
.52697 .15506 L
s
.52703 .15435 m
.52703 .15435 L
s
.52711 .15553 m
.52711 .15553 L
s
.52719 .15506 m
.52719 .15506 L
s
.52726 .15624 m
.52726 .15624 L
s
.52733 .15717 m
.52733 .15717 L
s
.52741 .15835 m
.52741 .15835 L
s
.52748 .15717 m
.52748 .15717 L
s
.52756 .15788 m
.52756 .15788 L
s
.52763 .15811 m
.52763 .15811 L
s
.52771 .15835 m
.52771 .15835 L
s
.52778 .15788 m
.52778 .15788 L
s
.52785 .15671 m
.52785 .15671 L
s
.52792 .15694 m
.52792 .15694 L
s
.528 .15741 m
.528 .15741 L
s
.52808 .15717 m
.52808 .15717 L
s
.52815 .15553 m
.52815 .15553 L
s
.52822 .15835 m
.52822 .15835 L
s
.5283 .15882 m
.5283 .15882 L
s
.52837 .16117 m
.52837 .16117 L
s
.52845 .16023 m
.52845 .16023 L
s
.52853 .16023 m
.52853 .16023 L
s
.5286 .16046 m
.5286 .16046 L
s
.52867 .16023 m
.52867 .16023 L
s
.52874 .1607 m
.52874 .1607 L
s
.52882 .15929 m
.52882 .15929 L
s
.52889 .1607 m
.52889 .1607 L
s
.52897 .16046 m
.52897 .16046 L
s
.52904 .16164 m
.52904 .16164 L
s
.52912 .16258 m
.52912 .16258 L
s
.52919 .1621 m
.52919 .1621 L
s
.52927 .16164 m
.52927 .16164 L
s
.52934 .16093 m
.52934 .16093 L
s
.52942 .16234 m
.52942 .16234 L
s
.52948 .1614 m
.52948 .1614 L
s
.52956 .16093 m
.52956 .16093 L
s
.52963 .1607 m
.52963 .1607 L
s
.52971 .16258 m
.52971 .16258 L
s
.52978 .15882 m
.52978 .15882 L
s
.52986 .16023 m
.52986 .16023 L
s
.52993 .15976 m
.52993 .15976 L
s
.53001 .15976 m
.53001 .15976 L
s
.53009 .15976 m
.53009 .15976 L
s
.53016 .16023 m
.53016 .16023 L
s
.53023 .1621 m
.53023 .1621 L
s
.5303 .16234 m
.5303 .16234 L
s
.53038 .16305 m
.53038 .16305 L
s
.53045 .16093 m
.53045 .16093 L
s
.53053 .1614 m
.53053 .1614 L
s
.5306 .15976 m
.5306 .15976 L
s
.53068 .15953 m
.53068 .15953 L
s
.53075 .15929 m
.53075 .15929 L
s
.53083 .15882 m
.53083 .15882 L
s
.5309 .15811 m
.5309 .15811 L
s
.53098 .15741 m
.53098 .15741 L
s
.53105 .15694 m
.53105 .15694 L
s
.53112 .15694 m
.53112 .15694 L
s
.53119 .15811 m
.53119 .15811 L
s
.53127 .156 m
.53127 .156 L
s
.53134 .15624 m
.53134 .15624 L
s
.53142 .15671 m
.53142 .15671 L
s
.53149 .15835 m
.53149 .15835 L
s
.53157 .15858 m
.53157 .15858 L
s
.53165 .15882 m
.53165 .15882 L
s
.53172 .15835 m
.53172 .15835 L
s
.5318 .15788 m
.5318 .15788 L
s
.53186 .15788 m
.53186 .15788 L
s
.53194 .15694 m
.53194 .15694 L
s
.53201 .15788 m
.53201 .15788 L
s
.53209 .15717 m
.53209 .15717 L
s
.53216 .15788 m
.53216 .15788 L
s
.53224 .15553 m
.53224 .15553 L
s
.53231 .15576 m
.53231 .15576 L
s
.53239 .15647 m
.53239 .15647 L
s
.53246 .15624 m
.53246 .15624 L
s
.53254 .15647 m
.53254 .15647 L
s
.53261 .15694 m
.53261 .15694 L
s
.53268 .15624 m
.53268 .15624 L
s
.53275 .15506 m
.53275 .15506 L
s
.53283 .15576 m
.53283 .15576 L
s
.5329 .15435 m
.5329 .15435 L
s
.53298 .15576 m
.53298 .15576 L
s
.53305 .15435 m
.53305 .15435 L
s
.53313 .15224 m
.53313 .15224 L
s
.5332 .15365 m
.5332 .15365 L
s
.53328 .15412 m
.53328 .15412 L
s
.53336 .15412 m
.53336 .15412 L
s
.53343 .15271 m
.53343 .15271 L
s
.5335 .15271 m
.5335 .15271 L
s
.53357 .152 m
.53357 .152 L
s
.53365 .152 m
.53365 .152 L
s
.53372 .1513 m
.53372 .1513 L
s
.5338 .15248 m
.5338 .15248 L
s
.53387 .15248 m
.53387 .15248 L
s
.53395 .15318 m
.53395 .15318 L
s
.53402 .15318 m
.53402 .15318 L
s
.5341 .15177 m
.5341 .15177 L
s
.53417 .15083 m
.53417 .15083 L
s
.53425 .14966 m
.53425 .14966 L
s
.53431 .15107 m
.53431 .15107 L
s
.53439 .15036 m
.53439 .15036 L
s
.53446 .15013 m
.53446 .15013 L
s
.53454 .14919 m
.53454 .14919 L
s
.53461 .1513 m
.53461 .1513 L
s
.53469 .15224 m
.53469 .15224 L
s
.53477 .152 m
.53477 .152 L
s
.53483 .15224 m
.53483 .15224 L
s
.53491 .15365 m
.53491 .15365 L
s
.53499 .15365 m
.53499 .15365 L
s
.53506 .15459 m
.53506 .15459 L
s
.53513 .15647 m
.53513 .15647 L
s
.53521 .15435 m
.53521 .15435 L
s
.53528 .15624 m
.53528 .15624 L
s
.53536 .15529 m
.53536 .15529 L
s
.53543 .15624 m
.53543 .15624 L
s
.53551 .15459 m
.53551 .15459 L
s
.53558 .15553 m
.53558 .15553 L
s
.53565 .15647 m
.53565 .15647 L
s
.53573 .15694 m
.53573 .15694 L
s
.53581 .15858 m
.53581 .15858 L
s
.53588 .15647 m
.53588 .15647 L
s
.53595 .15717 m
.53595 .15717 L
s
.53602 .15647 m
.53602 .15647 L
s
.5361 .15717 m
.5361 .15717 L
s
.53617 .15671 m
.53617 .15671 L
s
.53625 .15764 m
.53625 .15764 L
s
.53633 .15741 m
.53633 .15741 L
s
.5364 .15811 m
.5364 .15811 L
s
.53647 .15788 m
.53647 .15788 L
s
.53654 .15671 m
.53654 .15671 L
s
.53662 .15671 m
.53662 .15671 L
s
.53669 .15671 m
.53669 .15671 L
s
.53677 .15741 m
.53677 .15741 L
s
.53684 .15624 m
.53684 .15624 L
s
.53692 .15694 m
.53692 .15694 L
s
.53699 .15624 m
.53699 .15624 L
s
.53707 .15482 m
.53707 .15482 L
s
.53714 .152 m
.53714 .152 L
s
.53722 .152 m
.53722 .152 L
s
.53728 .15248 m
.53728 .15248 L
s
.53736 .15248 m
.53736 .15248 L
s
.53744 .15506 m
.53744 .15506 L
s
.53751 .15459 m
.53751 .15459 L
s
.53758 .15482 m
.53758 .15482 L
s
.53766 .15553 m
.53766 .15553 L
s
.53773 .15694 m
.53773 .15694 L
s
.53781 .15717 m
.53781 .15717 L
s
.53789 .15788 m
.53789 .15788 L
s
.53796 .15553 m
.53796 .15553 L
s
.53803 .156 m
.53803 .156 L
s
.5381 .15576 m
.5381 .15576 L
s
.53818 .15553 m
.53818 .15553 L
s
.53825 .15553 m
.53825 .15553 L
s
.53833 .15412 m
.53833 .15412 L
s
.5384 .15506 m
.5384 .15506 L
s
.53848 .15318 m
.53848 .15318 L
s
.53855 .15459 m
.53855 .15459 L
s
.53863 .15459 m
.53863 .15459 L
s
.5387 .15412 m
.5387 .15412 L
s
.53878 .15248 m
.53878 .15248 L
s
.53885 .15318 m
.53885 .15318 L
s
.53892 .15295 m
.53892 .15295 L
s
.53899 .15177 m
.53899 .15177 L
s
.53907 .15271 m
.53907 .15271 L
s
.53914 .15224 m
.53914 .15224 L
s
.53922 .15295 m
.53922 .15295 L
s
.53929 .152 m
.53929 .152 L
s
.53937 .15177 m
.53937 .15177 L
s
.53945 .15154 m
.53945 .15154 L
s
.53952 .1513 m
.53952 .1513 L
s
.5396 .15154 m
.5396 .15154 L
s
.53966 .152 m
.53966 .152 L
s
.53974 .15154 m
.53974 .15154 L
s
.53981 .15083 m
.53981 .15083 L
s
.53989 .1506 m
.53989 .1506 L
s
.53996 .14825 m
.53996 .14825 L
s
.54004 .14943 m
.54004 .14943 L
s
.54011 .14848 m
.54011 .14848 L
s
.54019 .14943 m
.54019 .14943 L
s
.54026 .14989 m
.54026 .14989 L
s
.54034 .15036 m
.54034 .15036 L
s
.54041 .14943 m
.54041 .14943 L
s
.54048 .14943 m
.54048 .14943 L
s
.54055 .14872 m
.54055 .14872 L
s
.54063 .14848 m
.54063 .14848 L
s
.5407 .14943 m
.5407 .14943 L
s
.54078 .14614 m
.54078 .14614 L
s
.54085 .14567 m
.54085 .14567 L
s
.54093 .1459 m
.54093 .1459 L
s
.54101 .14825 m
.54101 .14825 L
s
.54108 .14801 m
.54108 .14801 L
s
.54116 .14754 m
.54116 .14754 L
s
.54123 .1459 m
.54123 .1459 L
s
.5413 .14614 m
.5413 .14614 L
s
.54137 .14637 m
.54137 .14637 L
s
.54145 .14543 m
.54145 .14543 L
s
.54152 .14543 m
.54152 .14543 L
s
.5416 .14519 m
.5416 .14519 L
s
.54167 .1459 m
.54167 .1459 L
s
.54175 .14567 m
.54175 .14567 L
s
.54182 .14614 m
.54182 .14614 L
s
.5419 .14496 m
.5419 .14496 L
s
.54197 .14379 m
.54197 .14379 L
s
.54205 .14285 m
.54205 .14285 L
s
.54211 .14261 m
.54211 .14261 L
s
.54219 .14238 m
.54219 .14238 L
s
.54226 .14238 m
.54226 .14238 L
s
.54234 .14402 m
.54234 .14402 L
s
.54241 .14238 m
.54241 .14238 L
s
.54249 .14425 m
.54249 .14425 L
s
.54257 .14332 m
.54257 .14332 L
s
.54264 .14449 m
.54264 .14449 L
s
.54272 .14472 m
.54272 .14472 L
s
.54279 .14519 m
.54279 .14519 L
s
.54286 .14614 m
.54286 .14614 L
s
.54293 .14519 m
.54293 .14519 L
s
.54301 .14519 m
.54301 .14519 L
s
.54308 .14496 m
.54308 .14496 L
s
.54316 .14519 m
.54316 .14519 L
s
.54323 .14614 m
.54323 .14614 L
s
.54331 .14543 m
.54331 .14543 L
s
.54338 .14402 m
.54338 .14402 L
s
.54345 .14567 m
.54345 .14567 L
s
.54353 .14707 m
.54353 .14707 L
s
.54361 .14754 m
.54361 .14754 L
s
.54368 .14661 m
.54368 .14661 L
s
.54375 .14614 m
.54375 .14614 L
s
.54382 .14567 m
.54382 .14567 L
s
.5439 .14496 m
.5439 .14496 L
s
.54397 .14543 m
.54397 .14543 L
s
.54405 .14543 m
.54405 .14543 L
s
.54413 .14543 m
.54413 .14543 L
s
.5442 .14472 m
.5442 .14472 L
s
.54427 .14637 m
.54427 .14637 L
s
.54435 .14567 m
.54435 .14567 L
s
.54443 .14449 m
.54443 .14449 L
s
.54449 .1459 m
.54449 .1459 L
s
.54457 .14661 m
.54457 .14661 L
s
.54464 .14684 m
.54464 .14684 L
s
.54472 .14496 m
.54472 .14496 L
s
.54479 .14661 m
.54479 .14661 L
s
.54487 .14567 m
.54487 .14567 L
s
.54494 .14754 m
.54494 .14754 L
s
.54502 .14895 m
.54502 .14895 L
s
.54508 .15036 m
.54508 .15036 L
s
.54516 .15036 m
.54516 .15036 L
s
.54524 .15083 m
.54524 .15083 L
s
.54531 .15271 m
.54531 .15271 L
s
.54538 .15083 m
.54538 .15083 L
s
.54546 .15154 m
.54546 .15154 L
s
.54553 .15107 m
.54553 .15107 L
s
.54561 .1513 m
.54561 .1513 L
s
.54569 .15083 m
.54569 .15083 L
s
.54576 .14989 m
.54576 .14989 L
s
.54583 .14966 m
.54583 .14966 L
s
.5459 .15083 m
.5459 .15083 L
s
.54598 .15036 m
.54598 .15036 L
s
.54606 .15013 m
.54606 .15013 L
s
.54613 .14943 m
.54613 .14943 L
s
.5462 .14919 m
.5462 .14919 L
s
.54628 .15036 m
.54628 .15036 L
s
.54635 .15083 m
.54635 .15083 L
s
.54643 .15248 m
.54643 .15248 L
s
.5465 .15224 m
.5465 .15224 L
s
.54658 .15248 m
.54658 .15248 L
s
.54665 .14872 m
.54665 .14872 L
s
.54672 .1506 m
.54672 .1506 L
s
.54679 .14895 m
.54679 .14895 L
s
.54687 .14731 m
.54687 .14731 L
s
.54694 .14801 m
.54694 .14801 L
s
.54702 .14707 m
.54702 .14707 L
s
.54709 .14848 m
.54709 .14848 L
s
.54717 .14801 m
.54717 .14801 L
s
.54725 .1506 m
.54725 .1506 L
s
.54732 .14825 m
.54732 .14825 L
s
.5474 .14989 m
.5474 .14989 L
s
.54746 .14989 m
.54746 .14989 L
s
.54754 .15107 m
.54754 .15107 L
s
.54761 .15013 m
.54761 .15013 L
s
.54769 .15036 m
.54769 .15036 L
s
.54776 .15224 m
.54776 .15224 L
s
.54784 .15154 m
.54784 .15154 L
s
.54791 .1513 m
.54791 .1513 L
s
.54799 .15083 m
.54799 .15083 L
s
.54806 .1506 m
.54806 .1506 L
s
.54814 .1506 m
.54814 .1506 L
s
.54821 .152 m
.54821 .152 L
s
.54828 .1506 m
.54828 .1506 L
s
.54835 .1513 m
.54835 .1513 L
s
.54843 .15083 m
.54843 .15083 L
s
.5485 .15036 m
.5485 .15036 L
s
.54858 .15107 m
.54858 .15107 L
s
.54865 .14943 m
.54865 .14943 L
s
.54873 .14989 m
.54873 .14989 L
s
.54881 .14872 m
.54881 .14872 L
s
.54888 .15013 m
.54888 .15013 L
s
.54896 .15177 m
.54896 .15177 L
s
.54903 .15013 m
.54903 .15013 L
s
.5491 .14989 m
.5491 .14989 L
s
.54917 .14895 m
.54917 .14895 L
s
.54925 .14966 m
.54925 .14966 L
s
.54932 .14895 m
.54932 .14895 L
s
.5494 .14943 m
.5494 .14943 L
s
.54947 .14825 m
.54947 .14825 L
s
.54955 .1506 m
.54955 .1506 L
s
.54962 .1506 m
.54962 .1506 L
s
.5497 .15154 m
.5497 .15154 L
s
.54977 .15318 m
.54977 .15318 L
s
.54985 .15224 m
.54985 .15224 L
s
.54991 .15083 m
.54991 .15083 L
s
.54999 .15177 m
.54999 .15177 L
s
.55006 .15412 m
.55006 .15412 L
s
.55014 .15365 m
.55014 .15365 L
s
.55021 .15482 m
.55021 .15482 L
s
.55029 .15342 m
.55029 .15342 L
s
.55037 .15459 m
.55037 .15459 L
s
.55044 .15365 m
.55044 .15365 L
s
.55052 .15576 m
.55052 .15576 L
s
.55059 .15412 m
.55059 .15412 L
s
.55066 .15553 m
.55066 .15553 L
s
.55073 .156 m
.55073 .156 L
s
.55081 .15506 m
.55081 .15506 L
s
.55088 .15647 m
.55088 .15647 L
s
.55096 .15553 m
.55096 .15553 L
s
.55103 .15553 m
.55103 .15553 L
s
.55111 .15365 m
.55111 .15365 L
s
.55118 .15435 m
.55118 .15435 L
s
.55126 .15389 m
.55126 .15389 L
s
.55133 .15482 m
.55133 .15482 L
s
.55141 .15389 m
.55141 .15389 L
s
.55148 .15224 m
.55148 .15224 L
s
.55155 .152 m
.55155 .152 L
s
.55162 .1506 m
.55162 .1506 L
s
.5517 .152 m
.5517 .152 L
s
.55177 .15365 m
.55177 .15365 L
s
.55185 .15248 m
.55185 .15248 L
s
.55193 .14966 m
.55193 .14966 L
s
.552 .15013 m
.552 .15013 L
s
.55207 .15013 m
.55207 .15013 L
s
.55215 .1506 m
.55215 .1506 L
s
.55223 .15013 m
.55223 .15013 L
s
.5523 .14943 m
.5523 .14943 L
s
.55237 .14895 m
.55237 .14895 L
s
.55244 .14661 m
.55244 .14661 L
s
.55252 .14825 m
.55252 .14825 L
s
.55259 .14731 m
.55259 .14731 L
s
.55267 .14989 m
.55267 .14989 L
s
.55274 .14943 m
.55274 .14943 L
s
.55282 .14895 m
.55282 .14895 L
s
.55289 .14895 m
.55289 .14895 L
s
.55297 .14989 m
.55297 .14989 L
s
.55304 .15154 m
.55304 .15154 L
s
.55311 .15083 m
.55311 .15083 L
s
.55318 .15036 m
.55318 .15036 L
s
.55326 .1506 m
.55326 .1506 L
s
.55333 .15107 m
.55333 .15107 L
s
.55341 .15107 m
.55341 .15107 L
s
.55349 .152 m
.55349 .152 L
s
.55356 .15271 m
.55356 .15271 L
s
.55363 .15248 m
.55363 .15248 L
s
.5537 .1506 m
.5537 .1506 L
s
.55378 .15107 m
.55378 .15107 L
s
.55386 .15013 m
.55386 .15013 L
s
.55393 .15013 m
.55393 .15013 L
s
.554 .14943 m
.554 .14943 L
s
.55408 .14895 m
.55408 .14895 L
s
.55415 .14895 m
.55415 .14895 L
s
.55423 .14966 m
.55423 .14966 L
s
.5543 .14989 m
.5543 .14989 L
s
.55438 .15083 m
.55438 .15083 L
s
.55445 .15177 m
.55445 .15177 L
s
.55452 .14966 m
.55452 .14966 L
s
.5546 .15013 m
.5546 .15013 L
s
.55468 .14848 m
.55468 .14848 L
s
.55474 .14919 m
.55474 .14919 L
s
.55482 .14919 m
.55482 .14919 L
s
.55489 .14848 m
.55489 .14848 L
s
.55497 .14919 m
.55497 .14919 L
s
.55505 .14966 m
.55505 .14966 L
s
.55512 .15036 m
.55512 .15036 L
s
.5552 .14801 m
.5552 .14801 L
s
.55527 .14966 m
.55527 .14966 L
s
.55534 .14943 m
.55534 .14943 L
s
.55541 .14919 m
.55541 .14919 L
s
.55549 .14943 m
.55549 .14943 L
s
.55556 .14989 m
.55556 .14989 L
s
.55564 .15013 m
.55564 .15013 L
s
.55571 .14895 m
.55571 .14895 L
s
.55579 .14966 m
.55579 .14966 L
s
.55586 .14801 m
.55586 .14801 L
s
.55594 .14848 m
.55594 .14848 L
s
.55601 .14801 m
.55601 .14801 L
s
.55608 .14872 m
.55608 .14872 L
s
.55615 .14754 m
.55615 .14754 L
s
.55623 .14754 m
.55623 .14754 L
s
.55631 .14661 m
.55631 .14661 L
s
.55638 .14661 m
.55638 .14661 L
s
.55645 .14661 m
.55645 .14661 L
s
.55653 .1459 m
.55653 .1459 L
s
.55661 .14567 m
.55661 .14567 L
s
.55668 .14519 m
.55668 .14519 L
s
.55676 .14637 m
.55676 .14637 L
s
.55683 .14543 m
.55683 .14543 L
s
.5569 .14754 m
.5569 .14754 L
s
.55697 .14707 m
.55697 .14707 L
s
.55705 .14731 m
.55705 .14731 L
s
.55712 .14637 m
.55712 .14637 L
s
.5572 .14496 m
.5572 .14496 L
s
.55727 .14472 m
.55727 .14472 L
s
.55735 .14355 m
.55735 .14355 L
s
.55742 .14308 m
.55742 .14308 L
s
.5575 .14261 m
.5575 .14261 L
s
.55757 .14543 m
.55757 .14543 L
s
.55765 .14496 m
.55765 .14496 L
s
.55771 .1459 m
.55771 .1459 L
s
.55779 .14614 m
.55779 .14614 L
s
.55786 .14614 m
.55786 .14614 L
s
.55794 .14543 m
.55794 .14543 L
s
.55801 .14496 m
.55801 .14496 L
s
.55809 .14472 m
.55809 .14472 L
s
.55817 .14614 m
.55817 .14614 L
s
.55824 .14707 m
.55824 .14707 L
s
.55832 .14825 m
.55832 .14825 L
s
.55839 .14919 m
.55839 .14919 L
s
.55846 .14943 m
.55846 .14943 L
s
.55853 .1506 m
.55853 .1506 L
s
.55861 .15083 m
.55861 .15083 L
s
.55868 .15224 m
.55868 .15224 L
s
.55876 .1513 m
.55876 .1513 L
s
.55883 .14989 m
.55883 .14989 L
s
.55891 .15083 m
.55891 .15083 L
s
.55898 .14989 m
.55898 .14989 L
s
.55906 .15036 m
.55906 .15036 L
s
.55913 .15013 m
.55913 .15013 L
s
.55921 .14966 m
.55921 .14966 L
s
.55928 .14895 m
.55928 .14895 L
s
.55935 .15013 m
.55935 .15013 L
s
.55942 .14872 m
.55942 .14872 L
s
.5595 .14989 m
.5595 .14989 L
s
.55957 .15036 m
.55957 .15036 L
s
.55965 .15036 m
.55965 .15036 L
s
.55973 .15083 m
.55973 .15083 L
s
.5598 .14895 m
.5598 .14895 L
s
.55988 .14943 m
.55988 .14943 L
s
.55995 .14707 m
.55995 .14707 L
s
.56003 .14754 m
.56003 .14754 L
s
.5601 .1459 m
.5601 .1459 L
s
.56017 .14731 m
.56017 .14731 L
s
.56024 .14754 m
.56024 .14754 L
s
.56032 .14801 m
.56032 .14801 L
s
.56039 .14707 m
.56039 .14707 L
s
.56047 .14684 m
.56047 .14684 L
s
.56054 .14801 m
.56054 .14801 L
s
.56062 .14872 m
.56062 .14872 L
s
.56069 .14989 m
.56069 .14989 L
s
.56077 .14872 m
.56077 .14872 L
s
.56084 .14989 m
.56084 .14989 L
s
.56091 .14872 m
.56091 .14872 L
s
.56098 .14848 m
.56098 .14848 L
s
.56106 .14707 m
.56106 .14707 L
s
.56113 .14661 m
.56113 .14661 L
s
.56121 .14519 m
.56121 .14519 L
s
.56129 .14519 m
.56129 .14519 L
s
.56136 .14519 m
.56136 .14519 L
s
.56143 .14285 m
.56143 .14285 L
s
.56151 .14285 m
.56151 .14285 L
s
.56159 .14143 m
.56159 .14143 L
s
.56166 .14238 m
.56166 .14238 L
s
.56173 .14097 m
.56173 .14097 L
s
.5618 .14214 m
.5618 .14214 L
s
.56188 .14003 m
.56188 .14003 L
s
.56195 .14026 m
.56195 .14026 L
s
.56203 .13956 m
.56203 .13956 L
s
.5621 .1412 m
.5621 .1412 L
s
.56218 .14238 m
.56218 .14238 L
s
.56225 .1419 m
.56225 .1419 L
s
.56232 .14355 m
.56232 .14355 L
s
.5624 .1419 m
.5624 .1419 L
s
.56248 .14238 m
.56248 .14238 L
s
.56254 .1419 m
.56254 .1419 L
s
.56262 .14214 m
.56262 .14214 L
s
.56269 .14214 m
.56269 .14214 L
s
.56277 .14261 m
.56277 .14261 L
s
.56285 .14285 m
.56285 .14285 L
s
.56292 .14355 m
.56292 .14355 L
s
.563 .14379 m
.563 .14379 L
s
.56307 .14355 m
.56307 .14355 L
s
.56314 .14449 m
.56314 .14449 L
s
.56322 .14402 m
.56322 .14402 L
s
.56329 .14472 m
.56329 .14472 L
s
.56336 .14402 m
.56336 .14402 L
s
.56344 .14355 m
.56344 .14355 L
s
.56351 .14261 m
.56351 .14261 L
s
.56359 .14332 m
.56359 .14332 L
s
.56366 .14379 m
.56366 .14379 L
s
.56374 .14238 m
.56374 .14238 L
s
.56381 .14332 m
.56381 .14332 L
s
.56388 .14285 m
.56388 .14285 L
s
.56395 .14425 m
.56395 .14425 L
s
.56403 .14567 m
.56403 .14567 L
s
.56411 .14567 m
.56411 .14567 L
s
.56418 .14402 m
.56418 .14402 L
s
.56425 .14402 m
.56425 .14402 L
s
.56433 .14308 m
.56433 .14308 L
s
.56441 .14238 m
.56441 .14238 L
s
.56448 .14425 m
.56448 .14425 L
s
.56456 .14379 m
.56456 .14379 L
s
.56463 .14379 m
.56463 .14379 L
s
.5647 .14308 m
.5647 .14308 L
s
.56477 .14355 m
.56477 .14355 L
s
.56485 .14097 m
.56485 .14097 L
s
.56493 .14143 m
.56493 .14143 L
s
.565 .1412 m
.565 .1412 L
s
.56507 .14285 m
.56507 .14285 L
s
.56515 .14379 m
.56515 .14379 L
s
.56522 .14214 m
.56522 .14214 L
s
.5653 .14097 m
.5653 .14097 L
s
.56537 .14214 m
.56537 .14214 L
s
.56545 .14355 m
.56545 .14355 L
s
.56551 .14238 m
.56551 .14238 L
s
.56559 .14449 m
.56559 .14449 L
s
.56566 .14355 m
.56566 .14355 L
s
.56574 .14355 m
.56574 .14355 L
s
.56581 .14285 m
.56581 .14285 L
s
.56589 .14214 m
.56589 .14214 L
s
.56597 .1419 m
.56597 .1419 L
s
.56604 .14003 m
.56604 .14003 L
s
.56612 .14097 m
.56612 .14097 L
s
.56619 .14026 m
.56619 .14026 L
s
.56626 .1405 m
.56626 .1405 L
s
.56633 .1412 m
.56633 .1412 L
s
.56641 .1412 m
.56641 .1412 L
s
.56648 .1405 m
.56648 .1405 L
s
.56656 .14167 m
.56656 .14167 L
s
.56663 .14308 m
.56663 .14308 L
s
.56671 .14379 m
.56671 .14379 L
s
.56678 .14472 m
.56678 .14472 L
s
.56686 .14543 m
.56686 .14543 L
s
.56693 .14519 m
.56693 .14519 L
s
.56701 .14308 m
.56701 .14308 L
s
.56708 .14238 m
.56708 .14238 L
s
.56715 .14167 m
.56715 .14167 L
s
.56722 .14143 m
.56722 .14143 L
s
.5673 .13933 m
.5673 .13933 L
s
.56737 .13933 m
.56737 .13933 L
s
.56745 .13815 m
.56745 .13815 L
s
.56753 .13815 m
.56753 .13815 L
s
.5676 .13791 m
.5676 .13791 L
s
.56768 .13861 m
.56768 .13861 L
s
.56775 .13861 m
.56775 .13861 L
s
.56783 .13768 m
.56783 .13768 L
s
.5679 .13933 m
.5679 .13933 L
s
.56797 .13861 m
.56797 .13861 L
s
.56804 .13815 m
.56804 .13815 L
s
.56812 .13768 m
.56812 .13768 L
s
.56819 .13861 m
.56819 .13861 L
s
.56827 .13791 m
.56827 .13791 L
s
.56834 .13956 m
.56834 .13956 L
s
.56842 .14097 m
.56842 .14097 L
s
.56849 .14026 m
.56849 .14026 L
s
.56857 .14143 m
.56857 .14143 L
s
.56864 .14003 m
.56864 .14003 L
s
.56871 .1405 m
.56871 .1405 L
s
.56878 .14003 m
.56878 .14003 L
s
.56886 .14332 m
.56886 .14332 L
s
.56893 .14238 m
.56893 .14238 L
s
.56901 .14261 m
.56901 .14261 L
s
.56909 .14167 m
.56909 .14167 L
s
.56916 .1419 m
.56916 .1419 L
s
.56923 .14167 m
.56923 .14167 L
s
.56931 .1412 m
.56931 .1412 L
s
.56939 .14097 m
.56939 .14097 L
s
.56946 .14026 m
.56946 .14026 L
s
.56953 .14097 m
.56953 .14097 L
s
.5696 .14167 m
.5696 .14167 L
s
.56968 .14214 m
.56968 .14214 L
s
.56975 .1419 m
.56975 .1419 L
s
.56983 .14285 m
.56983 .14285 L
s
.5699 .14261 m
.5699 .14261 L
s
.56998 .14238 m
.56998 .14238 L
s
.57005 .14143 m
.57005 .14143 L
s
.57013 .14214 m
.57013 .14214 L
s
.5702 .14238 m
.5702 .14238 L
s
.57028 .1412 m
.57028 .1412 L
s
.57034 .14261 m
.57034 .14261 L
s
.57042 .14238 m
.57042 .14238 L
s
.57049 .14379 m
.57049 .14379 L
s
.57057 .14355 m
.57057 .14355 L
s
.57065 .14402 m
.57065 .14402 L
s
.57072 .14472 m
.57072 .14472 L
s
.5708 .14567 m
.5708 .14567 L
s
.57087 .14684 m
.57087 .14684 L
s
.57094 .14637 m
.57094 .14637 L
s
.57102 .14801 m
.57102 .14801 L
s
.57109 .14731 m
.57109 .14731 L
s
.57116 .14778 m
.57116 .14778 L
s
.57124 .14637 m
.57124 .14637 L
s
.57131 .14778 m
.57131 .14778 L
s
.57139 .14801 m
.57139 .14801 L
s
.57146 .14895 m
.57146 .14895 L
s
.57154 .14731 m
.57154 .14731 L
s
.57161 .14614 m
.57161 .14614 L
s
.57168 .1459 m
.57168 .1459 L
s
.57176 .14614 m
.57176 .14614 L
s
.57184 .14707 m
.57184 .14707 L
s
.57191 .14637 m
.57191 .14637 L
s
.57198 .14778 m
.57198 .14778 L
s
.57205 .14754 m
.57205 .14754 L
s
.57213 .14614 m
.57213 .14614 L
s
.57221 .14496 m
.57221 .14496 L
s
.57228 .14425 m
.57228 .14425 L
s
.57236 .14379 m
.57236 .14379 L
s
.57243 .14261 m
.57243 .14261 L
s
.5725 .14285 m
.5725 .14285 L
s
.57257 .1405 m
.57257 .1405 L
s
.57265 .1419 m
.57265 .1419 L
s
.57273 .14097 m
.57273 .14097 L
s
.5728 .14402 m
.5728 .14402 L
s
.57287 .14261 m
.57287 .14261 L
s
.57295 .14379 m
.57295 .14379 L
s
.57302 .14379 m
.57302 .14379 L
s
.5731 .14238 m
.5731 .14238 L
s
.57317 .14379 m
.57317 .14379 L
s
.57325 .1419 m
.57325 .1419 L
s
.57331 .14332 m
.57331 .14332 L
s
.57339 .14261 m
.57339 .14261 L
s
.57347 .14261 m
.57347 .14261 L
s
.57354 .1419 m
.57354 .1419 L
s
.57361 .14238 m
.57361 .14238 L
s
.57369 .14238 m
.57369 .14238 L
s
.57377 .14332 m
.57377 .14332 L
s
.57384 .14238 m
.57384 .14238 L
s
.57392 .14332 m
.57392 .14332 L
s
.57399 .14308 m
.57399 .14308 L
s
.57406 .14332 m
.57406 .14332 L
s
.57413 .14402 m
.57413 .14402 L
s
.57421 .14332 m
.57421 .14332 L
s
.57428 .1459 m
.57428 .1459 L
s
.57436 .14496 m
.57436 .14496 L
s
.57443 .14567 m
.57443 .14567 L
s
.57451 .14543 m
.57451 .14543 L
s
.57458 .14425 m
.57458 .14425 L
s
.57466 .14425 m
.57466 .14425 L
s
.57473 .14496 m
.57473 .14496 L
s
.57481 .14402 m
.57481 .14402 L
s
.57488 .14355 m
.57488 .14355 L
s
.57495 .14402 m
.57495 .14402 L
s
.57502 .14402 m
.57502 .14402 L
s
.5751 .14143 m
.5751 .14143 L
s
.57517 .13933 m
.57517 .13933 L
s
.57525 .1405 m
.57525 .1405 L
s
.57533 .14097 m
.57533 .14097 L
s
.5754 .14285 m
.5754 .14285 L
s
.57548 .1419 m
.57548 .1419 L
s
.57555 .1419 m
.57555 .1419 L
s
.57563 .14214 m
.57563 .14214 L
s
.5757 .14143 m
.5757 .14143 L
s
.57577 .1412 m
.57577 .1412 L
s
.57584 .14003 m
.57584 .14003 L
s
.57592 .1412 m
.57592 .1412 L
s
.57599 .14003 m
.57599 .14003 L
s
.57607 .14097 m
.57607 .14097 L
s
.57614 .14073 m
.57614 .14073 L
s
.57622 .14143 m
.57622 .14143 L
s
.57629 .13956 m
.57629 .13956 L
s
.57637 .14026 m
.57637 .14026 L
s
.57644 .13933 m
.57644 .13933 L
s
.57651 .13956 m
.57651 .13956 L
s
.57658 .13886 m
.57658 .13886 L
s
.57666 .13838 m
.57666 .13838 L
s
.57673 .13979 m
.57673 .13979 L
s
.57681 .13791 m
.57681 .13791 L
s
.57689 .13861 m
.57689 .13861 L
s
.57696 .13815 m
.57696 .13815 L
s
.57704 .14003 m
.57704 .14003 L
s
.57711 .13956 m
.57711 .13956 L
s
.57719 .13838 m
.57719 .13838 L
s
.57726 .13886 m
.57726 .13886 L
s
.57733 .13886 m
.57733 .13886 L
s
.5774 .1412 m
.5774 .1412 L
s
.57748 .14097 m
.57748 .14097 L
s
.57755 .14097 m
.57755 .14097 L
s
.57763 .14003 m
.57763 .14003 L
s
.5777 .14214 m
.5777 .14214 L
s
.57778 .14238 m
.57778 .14238 L
s
.57785 .14285 m
.57785 .14285 L
s
.57793 .14355 m
.57793 .14355 L
s
.578 .14214 m
.578 .14214 L
s
.57808 .14355 m
.57808 .14355 L
s
.57814 .14449 m
.57814 .14449 L
s
.57822 .14425 m
.57822 .14425 L
s
.57829 .14355 m
.57829 .14355 L
s
.57837 .14355 m
.57837 .14355 L
s
.57845 .14379 m
.57845 .14379 L
s
.57852 .14543 m
.57852 .14543 L
s
.5786 .1459 m
.5786 .1459 L
s
.57867 .14684 m
.57867 .14684 L
s
.57874 .14567 m
.57874 .14567 L
s
.57882 .14801 m
.57882 .14801 L
s
.5789 .15013 m
.5789 .15013 L
s
.57896 .14778 m
.57896 .14778 L
s
.57904 .14895 m
.57904 .14895 L
s
.57911 .14778 m
.57911 .14778 L
s
.57919 .14848 m
.57919 .14848 L
s
.57926 .14707 m
.57926 .14707 L
s
.57934 .14872 m
.57934 .14872 L
s
.57941 .14801 m
.57941 .14801 L
s
.57948 .14919 m
.57948 .14919 L
s
.57956 .14966 m
.57956 .14966 L
s
.57964 .14661 m
.57964 .14661 L
s
.57971 .14707 m
.57971 .14707 L
s
.57978 .14778 m
.57978 .14778 L
s
.57985 .14684 m
.57985 .14684 L
s
.57993 .14661 m
.57993 .14661 L
s
.58001 .14731 m
.58001 .14731 L
s
.58008 .14707 m
.58008 .14707 L
s
.58016 .14848 m
.58016 .14848 L
s
.58023 .14895 m
.58023 .14895 L
s
.5803 .14872 m
.5803 .14872 L
s
.58038 .14848 m
.58038 .14848 L
s
.58045 .14707 m
.58045 .14707 L
s
.58053 .14801 m
.58053 .14801 L
s
.5806 .14661 m
.5806 .14661 L
s
.58067 .14801 m
.58067 .14801 L
s
.58075 .14567 m
.58075 .14567 L
s
.58082 .14778 m
.58082 .14778 L
s
.5809 .14778 m
.5809 .14778 L
s
.58097 .14943 m
.58097 .14943 L
s
.58105 .14754 m
.58105 .14754 L
s
.58111 .14707 m
.58111 .14707 L
s
.58119 .14661 m
.58119 .14661 L
s
.58127 .14707 m
.58127 .14707 L
s
.58134 .14707 m
.58134 .14707 L
s
.58141 .14754 m
.58141 .14754 L
s
.58149 .14919 m
.58149 .14919 L
s
.58157 .14943 m
.58157 .14943 L
s
.58164 .14989 m
.58164 .14989 L
s
.58172 .14989 m
.58172 .14989 L
s
.58179 .15224 m
.58179 .15224 L
s
.58187 .15248 m
.58187 .15248 L
s
.58193 .152 m
.58193 .152 L
s
.58201 .15177 m
.58201 .15177 L
s
.58209 .1513 m
.58209 .1513 L
s
.58216 .15224 m
.58216 .15224 L
s
.58223 .15177 m
.58223 .15177 L
s
.58231 .15342 m
.58231 .15342 L
s
.58238 .15295 m
.58238 .15295 L
s
.58246 .15318 m
.58246 .15318 L
s
.58253 .15271 m
.58253 .15271 L
s
.58261 .15177 m
.58261 .15177 L
s
.58268 .1513 m
.58268 .1513 L
s
.58275 .15459 m
.58275 .15459 L
s
.58282 .15529 m
.58282 .15529 L
s
.5829 .15459 m
.5829 .15459 L
s
.58297 .15506 m
.58297 .15506 L
s
.58305 .15412 m
.58305 .15412 L
s
.58313 .15412 m
.58313 .15412 L
s
.5832 .15271 m
.5832 .15271 L
s
.58328 .15412 m
.58328 .15412 L
s
.58335 .15271 m
.58335 .15271 L
s
.58343 .15435 m
.58343 .15435 L
s
.5835 .15459 m
.5835 .15459 L
s
.58357 .15647 m
.58357 .15647 L
s
.58364 .15647 m
.58364 .15647 L
s
.58372 .15694 m
.58372 .15694 L
s
.58379 .15529 m
.58379 .15529 L
s
.58387 .15671 m
.58387 .15671 L
s
.58394 .15717 m
.58394 .15717 L
s
.58402 .15553 m
.58402 .15553 L
s
.58409 .15553 m
.58409 .15553 L
s
.58417 .15506 m
.58417 .15506 L
s
.58424 .15553 m
.58424 .15553 L
s
.58431 .15435 m
.58431 .15435 L
s
.58438 .15506 m
.58438 .15506 L
s
.58446 .15506 m
.58446 .15506 L
s
.58453 .15482 m
.58453 .15482 L
s
.58461 .15576 m
.58461 .15576 L
s
.58469 .15435 m
.58469 .15435 L
s
.58476 .15482 m
.58476 .15482 L
s
.58484 .15389 m
.58484 .15389 L
s
.58491 .15389 m
.58491 .15389 L
s
.58499 .15271 m
.58499 .15271 L
s
.58506 .15529 m
.58506 .15529 L
s
.58513 .15624 m
.58513 .15624 L
s
.5852 .15365 m
.5852 .15365 L
s
.58528 .15459 m
.58528 .15459 L
s
.58535 .15412 m
.58535 .15412 L
s
.58543 .15529 m
.58543 .15529 L
s
.5855 .15624 m
.5855 .15624 L
s
.58558 .15741 m
.58558 .15741 L
s
.58565 .15576 m
.58565 .15576 L
s
.58573 .15671 m
.58573 .15671 L
s
.5858 .15576 m
.5858 .15576 L
s
.58588 .156 m
.58588 .156 L
s
.58594 .15647 m
.58594 .15647 L
s
.58602 .15741 m
.58602 .15741 L
s
.58609 .15788 m
.58609 .15788 L
s
.58617 .15811 m
.58617 .15811 L
s
.58625 .15835 m
.58625 .15835 L
s
.58632 .15694 m
.58632 .15694 L
s
.5864 .15741 m
.5864 .15741 L
s
.58647 .15576 m
.58647 .15576 L
s
.58655 .15553 m
.58655 .15553 L
s
.58662 .15412 m
.58662 .15412 L
s
.5867 .15506 m
.5867 .15506 L
s
.58676 .15412 m
.58676 .15412 L
s
.58684 .15342 m
.58684 .15342 L
s
.58691 .15459 m
.58691 .15459 L
s
.58699 .15318 m
.58699 .15318 L
s
.58706 .15459 m
.58706 .15459 L
s
.58714 .15248 m
.58714 .15248 L
s
.58721 .15154 m
.58721 .15154 L
s
.58728 .1506 m
.58728 .1506 L
s
.58736 .15177 m
.58736 .15177 L
s
.58744 .15271 m
.58744 .15271 L
s
.58751 .15248 m
.58751 .15248 L
s
.58758 .15107 m
.58758 .15107 L
s
.58765 .15224 m
.58765 .15224 L
s
.58773 .1506 m
.58773 .1506 L
s
.58781 .15083 m
.58781 .15083 L
s
.58788 .15224 m
.58788 .15224 L
s
.58796 .15271 m
.58796 .15271 L
s
.58803 .15389 m
.58803 .15389 L
s
.5881 .15318 m
.5881 .15318 L
s
.58818 .15318 m
.58818 .15318 L
s
.58826 .15412 m
.58826 .15412 L
s
.58833 .15318 m
.58833 .15318 L
s
.5884 .15459 m
.5884 .15459 L
s
.58847 .15435 m
.58847 .15435 L
s
.58855 .15553 m
.58855 .15553 L
s
.58862 .15459 m
.58862 .15459 L
s
.5887 .156 m
.5887 .156 L
s
.58877 .15459 m
.58877 .15459 L
s
.58885 .15647 m
.58885 .15647 L
s
.58892 .15365 m
.58892 .15365 L
s
.58899 .15389 m
.58899 .15389 L
s
.58907 .15389 m
.58907 .15389 L
s
.58914 .15529 m
.58914 .15529 L
s
.58921 .156 m
.58921 .156 L
s
.58929 .15553 m
.58929 .15553 L
s
.58937 .15694 m
.58937 .15694 L
s
.58944 .15576 m
.58944 .15576 L
s
.58952 .156 m
.58952 .156 L
s
.58959 .15647 m
.58959 .15647 L
s
.58967 .15976 m
.58967 .15976 L
s
.58973 .15953 m
.58973 .15953 L
s
.58981 .15953 m
.58981 .15953 L
s
.58989 .15835 m
.58989 .15835 L
s
.58996 .15835 m
.58996 .15835 L
s
.59003 .15858 m
.59003 .15858 L
s
.59011 .15835 m
.59011 .15835 L
s
.59018 .15929 m
.59018 .15929 L
s
.59026 .15929 m
.59026 .15929 L
s
.59033 .15999 m
.59033 .15999 L
s
.59041 .15976 m
.59041 .15976 L
s
.59048 .15976 m
.59048 .15976 L
s
.59055 .15976 m
.59055 .15976 L
s
.59063 .16093 m
.59063 .16093 L
s
.5907 .16023 m
.5907 .16023 L
s
.59078 .16023 m
.59078 .16023 L
s
.59085 .16046 m
.59085 .16046 L
s
.59093 .15929 m
.59093 .15929 L
s
.591 .15953 m
.591 .15953 L
s
.59108 .15764 m
.59108 .15764 L
s
.59115 .15788 m
.59115 .15788 L
s
.59123 .16023 m
.59123 .16023 L
s
.5913 .16187 m
.5913 .16187 L
s
.59137 .16023 m
.59137 .16023 L
s
.59144 .15905 m
.59144 .15905 L
s
.59152 .15999 m
.59152 .15999 L
s
.59159 .16023 m
.59159 .16023 L
s
.59167 .15976 m
.59167 .15976 L
s
.59174 .15929 m
.59174 .15929 L
s
.59182 .15999 m
.59182 .15999 L
s
.59189 .15858 m
.59189 .15858 L
s
.59197 .16023 m
.59197 .16023 L
s
.59204 .15882 m
.59204 .15882 L
s
.59211 .15858 m
.59211 .15858 L
s
.59218 .15741 m
.59218 .15741 L
s
.59226 .15741 m
.59226 .15741 L
s
.59234 .15741 m
.59234 .15741 L
s
.59241 .15694 m
.59241 .15694 L
s
.59249 .15647 m
.59249 .15647 L
s
.59256 .156 m
.59256 .156 L
s
.59264 .15576 m
.59264 .15576 L
s
.59271 .15435 m
.59271 .15435 L
s
.59279 .15342 m
.59279 .15342 L
s
.59286 .15224 m
.59286 .15224 L
s
.59293 .15248 m
.59293 .15248 L
s
.593 .15412 m
.593 .15412 L
s
.59308 .15435 m
.59308 .15435 L
s
.59315 .15271 m
.59315 .15271 L
s
.59323 .15224 m
.59323 .15224 L
s
.5933 .152 m
.5933 .152 L
s
.59338 .15177 m
.59338 .15177 L
s
.59345 .15083 m
.59345 .15083 L
s
.59353 .15107 m
.59353 .15107 L
s
.5936 .15271 m
.5936 .15271 L
s
.59368 .15342 m
.59368 .15342 L
s
.59375 .15107 m
.59375 .15107 L
s
.59382 .14966 m
.59382 .14966 L
s
.59389 .14943 m
.59389 .14943 L
s
.59397 .15013 m
.59397 .15013 L
s
.59405 .14989 m
.59405 .14989 L
s
.59412 .1506 m
.59412 .1506 L
s
.5942 .14848 m
.5942 .14848 L
s
.59427 .1506 m
.59427 .1506 L
s
.59435 .14825 m
.59435 .14825 L
s
.59442 .14919 m
.59442 .14919 L
s
.5945 .15036 m
.5945 .15036 L
s
.59456 .15177 m
.59456 .15177 L
s
.59464 .1506 m
.59464 .1506 L
s
.59471 .1513 m
.59471 .1513 L
s
.59479 .1506 m
.59479 .1506 L
s
.59486 .14848 m
.59486 .14848 L
s
.59494 .14848 m
.59494 .14848 L
s
.59501 .14825 m
.59501 .14825 L
s
.59509 .14919 m
.59509 .14919 L
s
.59516 .14754 m
.59516 .14754 L
s
.59524 .14754 m
.59524 .14754 L
s
.59531 .14661 m
.59531 .14661 L
s
.59538 .14519 m
.59538 .14519 L
s
.59545 .14567 m
.59545 .14567 L
s
.59553 .14402 m
.59553 .14402 L
s
.59561 .14543 m
.59561 .14543 L
s
.59568 .14519 m
.59568 .14519 L
s
.59576 .14449 m
.59576 .14449 L
s
.59583 .14308 m
.59583 .14308 L
s
.5959 .14355 m
.5959 .14355 L
s
.59598 .14238 m
.59598 .14238 L
s
.59606 .14379 m
.59606 .14379 L
s
.59613 .14355 m
.59613 .14355 L
s
.5962 .14661 m
.5962 .14661 L
s
.59627 .14754 m
.59627 .14754 L
s
.59635 .14848 m
.59635 .14848 L
s
.59642 .14661 m
.59642 .14661 L
s
.5965 .14801 m
.5965 .14801 L
s
.59657 .14801 m
.59657 .14801 L
s
.59665 .14801 m
.59665 .14801 L
s
.59672 .14989 m
.59672 .14989 L
s
.5968 .14895 m
.5968 .14895 L
s
.59687 .1513 m
.59687 .1513 L
s
.59694 .15013 m
.59694 .15013 L
s
.59701 .15083 m
.59701 .15083 L
s
.59709 .15224 m
.59709 .15224 L
s
.59717 .15248 m
.59717 .15248 L
s
.59724 .15295 m
.59724 .15295 L
s
.59732 .15271 m
.59732 .15271 L
s
.59739 .15224 m
.59739 .15224 L
s
.59747 .15083 m
.59747 .15083 L
s
.59753 .15365 m
.59753 .15365 L
s
.59761 .15482 m
.59761 .15482 L
s
.59769 .15529 m
.59769 .15529 L
s
.59776 .15529 m
.59776 .15529 L
s
.59783 .15694 m
.59783 .15694 L
s
.59791 .15576 m
.59791 .15576 L
s
.59798 .15647 m
.59798 .15647 L
s
.59806 .15811 m
.59806 .15811 L
s
.59813 .15717 m
.59813 .15717 L
s
.59821 .15835 m
.59821 .15835 L
s
.59828 .15764 m
.59828 .15764 L
s
.59835 .16023 m
.59835 .16023 L
s
.59843 .16046 m
.59843 .16046 L
s
.59851 .15976 m
.59851 .15976 L
s
.59858 .15788 m
.59858 .15788 L
s
.59865 .15835 m
.59865 .15835 L
s
.59873 .15929 m
.59873 .15929 L
s
.5988 .15976 m
.5988 .15976 L
s
.59888 .15999 m
.59888 .15999 L
s
.59895 .15929 m
.59895 .15929 L
s
.59903 .15999 m
.59903 .15999 L
s
.5991 .15811 m
.5991 .15811 L
s
.59917 .15953 m
.59917 .15953 L
s
.59924 .15835 m
.59924 .15835 L
s
.59932 .15741 m
.59932 .15741 L
s
.59939 .15389 m
.59939 .15389 L
s
.59947 .15435 m
.59947 .15435 L
s
.59954 .15435 m
.59954 .15435 L
s
.59962 .15529 m
.59962 .15529 L
s
.59969 .15647 m
.59969 .15647 L
s
.59977 .15694 m
.59977 .15694 L
s
.59984 .15671 m
.59984 .15671 L
s
.59991 .15624 m
.59991 .15624 L
s
.59998 .15576 m
.59998 .15576 L
s
.60006 .15529 m
.60006 .15529 L
s
.60014 .15576 m
.60014 .15576 L
s
.60021 .15553 m
.60021 .15553 L
s
.60029 .15412 m
.60029 .15412 L
s
.60036 .15459 m
.60036 .15459 L
s
.60044 .15459 m
.60044 .15459 L
s
.60051 .15671 m
.60051 .15671 L
s
.60059 .15647 m
.60059 .15647 L
s
.60066 .15811 m
.60066 .15811 L
s
.60073 .15717 m
.60073 .15717 L
s
.6008 .15529 m
.6008 .15529 L
s
.60088 .15412 m
.60088 .15412 L
s
.60095 .15412 m
.60095 .15412 L
s
.60103 .15412 m
.60103 .15412 L
s
.6011 .15389 m
.6011 .15389 L
s
.60118 .15389 m
.60118 .15389 L
s
.60125 .15248 m
.60125 .15248 L
s
.60133 .15342 m
.60133 .15342 L
s
.6014 .15271 m
.6014 .15271 L
s
.60148 .15389 m
.60148 .15389 L
s
.60155 .15083 m
.60155 .15083 L
s
.60162 .15107 m
.60162 .15107 L
s
.60169 .14966 m
.60169 .14966 L
s
.60177 .15107 m
.60177 .15107 L
s
.60185 .15083 m
.60185 .15083 L
s
.60192 .15154 m
.60192 .15154 L
s
.602 .15177 m
.602 .15177 L
s
.60207 .1513 m
.60207 .1513 L
s
.60215 .152 m
.60215 .152 L
s
.60222 .15107 m
.60222 .15107 L
s
.6023 .15083 m
.6023 .15083 L
s
.60236 .15013 m
.60236 .15013 L
s
.60244 .1506 m
.60244 .1506 L
s
.60251 .1513 m
.60251 .1513 L
s
.60259 .15154 m
.60259 .15154 L
s
.60266 .15177 m
.60266 .15177 L
s
.60274 .15107 m
.60274 .15107 L
s
.60281 .15107 m
.60281 .15107 L
s
.60289 .15083 m
.60289 .15083 L
s
.60296 .15177 m
.60296 .15177 L
s
.60304 .15013 m
.60304 .15013 L
s
.60311 .15177 m
.60311 .15177 L
s
.60318 .15271 m
.60318 .15271 L
s
.60325 .15482 m
.60325 .15482 L
s
.60333 .15365 m
.60333 .15365 L
s
.60341 .15318 m
.60341 .15318 L
s
.60348 .15365 m
.60348 .15365 L
s
.60356 .15365 m
.60356 .15365 L
s
.60363 .15482 m
.60363 .15482 L
s
.60371 .15365 m
.60371 .15365 L
s
.60378 .15459 m
.60378 .15459 L
s
.60386 .1506 m
.60386 .1506 L
s
.60393 .152 m
.60393 .152 L
s
.604 .14989 m
.604 .14989 L
s
.60407 .15154 m
.60407 .15154 L
s
.60415 .14943 m
.60415 .14943 L
s
.60422 .14895 m
.60422 .14895 L
s
.6043 .15036 m
.6043 .15036 L
s
.60437 .14943 m
.60437 .14943 L
s
.60445 .1513 m
.60445 .1513 L
s
.60452 .15013 m
.60452 .15013 L
s
.6046 .15036 m
.6046 .15036 L
s
.60467 .15036 m
.60467 .15036 L
s
.60474 .14943 m
.60474 .14943 L
s
.60481 .15083 m
.60481 .15083 L
s
.60489 .14989 m
.60489 .14989 L
s
.60497 .14778 m
.60497 .14778 L
s
.60504 .14801 m
.60504 .14801 L
s
.60512 .14778 m
.60512 .14778 L
s
.60519 .14778 m
.60519 .14778 L
s
.60527 .14848 m
.60527 .14848 L
s
.60534 .14801 m
.60534 .14801 L
s
.60542 .14848 m
.60542 .14848 L
s
.60549 .14895 m
.60549 .14895 L
s
.60556 .15083 m
.60556 .15083 L
s
.60563 .14966 m
.60563 .14966 L
s
.60571 .14943 m
.60571 .14943 L
s
.60578 .14801 m
.60578 .14801 L
s
.60586 .15013 m
.60586 .15013 L
s
.60593 .14943 m
.60593 .14943 L
s
.60601 .14943 m
.60601 .14943 L
s
.60608 .14943 m
.60608 .14943 L
s
.60615 .15013 m
.60615 .15013 L
s
.60623 .14943 m
.60623 .14943 L
s
.60631 .14801 m
.60631 .14801 L
s
.60638 .14919 m
.60638 .14919 L
s
.60645 .14661 m
.60645 .14661 L
s
.60653 .14731 m
.60653 .14731 L
s
.6066 .14661 m
.6066 .14661 L
s
.60668 .14707 m
.60668 .14707 L
s
.60675 .14754 m
.60675 .14754 L
s
.60683 .1459 m
.60683 .1459 L
s
.6069 .14754 m
.6069 .14754 L
s
.60697 .14707 m
.60697 .14707 L
s
.60705 .14919 m
.60705 .14919 L
s
.60713 .14707 m
.60713 .14707 L
s
.60719 .14801 m
.60719 .14801 L
s
.60727 .14684 m
.60727 .14684 L
s
.60734 .14778 m
.60734 .14778 L
s
.60742 .14848 m
.60742 .14848 L
s
.60749 .14872 m
.60749 .14872 L
s
.60757 .14872 m
.60757 .14872 L
s
.60764 .14848 m
.60764 .14848 L
s
.60771 .14943 m
.60771 .14943 L
s
.60778 .14778 m
.60778 .14778 L
s
.60786 .14707 m
.60786 .14707 L
s
.60794 .14661 m
.60794 .14661 L
s
.60801 .14731 m
.60801 .14731 L
s
.60809 .14496 m
.60809 .14496 L
s
.60816 .14449 m
.60816 .14449 L
s
.60824 .14425 m
.60824 .14425 L
s
.60831 .14402 m
.60831 .14402 L
s
.60839 .14425 m
.60839 .14425 L
s
.60846 .14332 m
.60846 .14332 L
s
.60853 .14425 m
.60853 .14425 L
s
.6086 .14308 m
.6086 .14308 L
s
.60868 .14472 m
.60868 .14472 L
s
.60876 .14449 m
.60876 .14449 L
s
.60883 .14496 m
.60883 .14496 L
s
.6089 .14472 m
.6089 .14472 L
s
.60898 .14614 m
.60898 .14614 L
s
.60905 .14661 m
.60905 .14661 L
s
.60913 .14661 m
.60913 .14661 L
s
.6092 .14707 m
.6092 .14707 L
s
.60928 .14684 m
.60928 .14684 L
s
.60935 .14661 m
.60935 .14661 L
s
.60942 .14637 m
.60942 .14637 L
s
.60949 .14754 m
.60949 .14754 L
s
.60957 .14614 m
.60957 .14614 L
s
.60965 .14801 m
.60965 .14801 L
s
.60972 .14731 m
.60972 .14731 L
s
.6098 .14895 m
.6098 .14895 L
s
.60987 .14825 m
.60987 .14825 L
s
.60995 .14825 m
.60995 .14825 L
s
.61002 .15177 m
.61002 .15177 L
s
.6101 .15177 m
.6101 .15177 L
s
.61016 .15271 m
.61016 .15271 L
s
.61024 .15224 m
.61024 .15224 L
s
.61031 .15295 m
.61031 .15295 L
s
.61039 .15083 m
.61039 .15083 L
s
.61046 .15271 m
.61046 .15271 L
s
.61054 .1513 m
.61054 .1513 L
s
.61061 .152 m
.61061 .152 L
s
.61069 .15271 m
.61069 .15271 L
s
.61076 .15224 m
.61076 .15224 L
s
.61084 .15295 m
.61084 .15295 L
s
.61091 .15224 m
.61091 .15224 L
s
.61098 .15412 m
.61098 .15412 L
s
.61105 .15576 m
.61105 .15576 L
s
.61113 .15647 m
.61113 .15647 L
s
.61121 .15576 m
.61121 .15576 L
s
.61128 .15671 m
.61128 .15671 L
s
.61136 .15694 m
.61136 .15694 L
s
.61143 .15788 m
.61143 .15788 L
s
.61151 .15882 m
.61151 .15882 L
s
.61158 .15835 m
.61158 .15835 L
s
.61166 .15788 m
.61166 .15788 L
s
.61173 .15694 m
.61173 .15694 L
s
.6118 .15624 m
.6118 .15624 L
s
.61187 .15553 m
.61187 .15553 L
s
.61195 .15717 m
.61195 .15717 L
s
.61202 .15624 m
.61202 .15624 L
s
.6121 .15741 m
.6121 .15741 L
s
.61217 .15788 m
.61217 .15788 L
s
.61225 .16023 m
.61225 .16023 L
s
.61232 .15835 m
.61232 .15835 L
s
.6124 .15882 m
.6124 .15882 L
s
.61247 .15905 m
.61247 .15905 L
s
.61254 .15717 m
.61254 .15717 L
s
.61261 .15529 m
.61261 .15529 L
s
.61269 .156 m
.61269 .156 L
s
.61277 .15717 m
.61277 .15717 L
s
.61284 .15482 m
.61284 .15482 L
s
.61292 .15482 m
.61292 .15482 L
s
.61299 .15529 m
.61299 .15529 L
s
.61307 .15717 m
.61307 .15717 L
s
.61314 .15671 m
.61314 .15671 L
s
.61322 .15553 m
.61322 .15553 L
s
.61329 .15694 m
.61329 .15694 L
s
.61336 .15764 m
.61336 .15764 L
s
.61343 .15858 m
.61343 .15858 L
s
.61351 .15929 m
.61351 .15929 L
s
.61358 .15999 m
.61358 .15999 L
s
.61366 .15835 m
.61366 .15835 L
s
.61373 .15764 m
.61373 .15764 L
s
.61381 .15694 m
.61381 .15694 L
s
.61388 .15624 m
.61388 .15624 L
s
.61396 .156 m
.61396 .156 L
s
.61403 .15717 m
.61403 .15717 L
s
.61411 .15835 m
.61411 .15835 L
s
.61418 .15788 m
.61418 .15788 L
s
.61425 .15882 m
.61425 .15882 L
s
.61433 .15788 m
.61433 .15788 L
s
.6144 .15929 m
.6144 .15929 L
s
.61448 .15929 m
.61448 .15929 L
s
.61455 .15999 m
.61455 .15999 L
s
.61463 .16023 m
.61463 .16023 L
s
.6147 .15976 m
.6147 .15976 L
s
.61477 .16164 m
.61477 .16164 L
s
.61485 .16023 m
.61485 .16023 L
s
.61493 .16093 m
.61493 .16093 L
s
.61499 .16023 m
.61499 .16023 L
s
.61507 .1614 m
.61507 .1614 L
s
.61514 .16046 m
.61514 .16046 L
s
.61522 .16305 m
.61522 .16305 L
s
.61529 .1621 m
.61529 .1621 L
s
.61537 .16375 m
.61537 .16375 L
s
.61544 .16258 m
.61544 .16258 L
s
.61551 .16164 m
.61551 .16164 L
s
.61559 .16234 m
.61559 .16234 L
s
.61567 .16164 m
.61567 .16164 L
s
.61574 .16258 m
.61574 .16258 L
s
.61581 .16093 m
.61581 .16093 L
s
.61589 .16187 m
.61589 .16187 L
s
.61596 .16187 m
.61596 .16187 L
s
.61604 .16234 m
.61604 .16234 L
s
.61611 .16305 m
.61611 .16305 L
s
.61619 .16258 m
.61619 .16258 L
s
.61626 .16164 m
.61626 .16164 L
s
.61633 .16258 m
.61633 .16258 L
s
.6164 .16328 m
.6164 .16328 L
s
.61648 .16234 m
.61648 .16234 L
s
.61656 .16281 m
.61656 .16281 L
s
.61663 .16258 m
.61663 .16258 L
s
.6167 .16258 m
.6167 .16258 L
s
.61678 .16164 m
.61678 .16164 L
s
.61685 .16281 m
.61685 .16281 L
s
.61693 .16375 m
.61693 .16375 L
s
.617 .16445 m
.617 .16445 L
s
.61708 .16516 m
.61708 .16516 L
s
.61715 .16469 m
.61715 .16469 L
s
.61722 .16469 m
.61722 .16469 L
s
.6173 .16422 m
.6173 .16422 L
s
.61737 .16516 m
.61737 .16516 L
s
.61745 .16445 m
.61745 .16445 L
s
.61752 .16586 m
.61752 .16586 L
s
.6176 .16563 m
.6176 .16563 L
s
.61767 .16586 m
.61767 .16586 L
s
.61775 .16399 m
.61775 .16399 L
s
.61782 .16305 m
.61782 .16305 L
s
.6179 .16187 m
.6179 .16187 L
s
.61796 .16117 m
.61796 .16117 L
s
.61804 .1621 m
.61804 .1621 L
s
.61811 .1621 m
.61811 .1621 L
s
.61819 .16305 m
.61819 .16305 L
s
.61826 .1621 m
.61826 .1621 L
s
.61834 .16187 m
.61834 .16187 L
s
.61841 .16117 m
.61841 .16117 L
s
.61849 .16164 m
.61849 .16164 L
s
.61856 .1614 m
.61856 .1614 L
s
.61864 .1621 m
.61864 .1621 L
s
.61871 .16352 m
.61871 .16352 L
s
.61878 .16445 m
.61878 .16445 L
s
.61885 .1661 m
.61885 .1661 L
s
.61893 .16516 m
.61893 .16516 L
s
.61901 .1661 m
.61901 .1661 L
s
.61908 .16563 m
.61908 .16563 L
s
.61916 .16704 m
.61916 .16704 L
s
.61923 .16469 m
.61923 .16469 L
s
.61931 .16586 m
.61931 .16586 L
s
.61938 .16375 m
.61938 .16375 L
s
.61946 .16352 m
.61946 .16352 L
s
.61953 .16305 m
.61953 .16305 L
s
.6196 .1621 m
.6196 .1621 L
s
.61967 .16258 m
.61967 .16258 L
s
.61975 .16164 m
.61975 .16164 L
s
.61982 .16328 m
.61982 .16328 L
s
.6199 .16281 m
.6199 .16281 L
s
.61997 .16352 m
.61997 .16352 L
s
.62005 .16234 m
.62005 .16234 L
s
.62012 .16164 m
.62012 .16164 L
s
.6202 .16093 m
.6202 .16093 L
s
.62027 .16117 m
.62027 .16117 L
s
.62034 .16093 m
.62034 .16093 L
s
.62041 .16046 m
.62041 .16046 L
s
.62049 .16117 m
.62049 .16117 L
s
.62057 .1607 m
.62057 .1607 L
s
.62064 .1614 m
.62064 .1614 L
s
.62072 .16093 m
.62072 .16093 L
s
.62079 .16093 m
.62079 .16093 L
s
.62087 .16023 m
.62087 .16023 L
s
.62094 .15905 m
.62094 .15905 L
s
.62102 .15929 m
.62102 .15929 L
s
.62109 .15835 m
.62109 .15835 L
s
.62116 .15905 m
.62116 .15905 L
s
.62123 .15835 m
.62123 .15835 L
s
.62131 .15999 m
.62131 .15999 L
s
.62138 .15976 m
.62138 .15976 L
s
.62146 .15999 m
.62146 .15999 L
s
.62153 .15905 m
.62153 .15905 L
s
.62161 .16046 m
.62161 .16046 L
s
.62168 .16093 m
.62168 .16093 L
s
.62176 .1607 m
.62176 .1607 L
s
.62183 .16117 m
.62183 .16117 L
s
.62191 .16234 m
.62191 .16234 L
s
.62198 .16305 m
.62198 .16305 L
s
.62205 .16258 m
.62205 .16258 L
s
.62213 .16352 m
.62213 .16352 L
s
.6222 .16258 m
.6222 .16258 L
s
.62228 .16422 m
.62228 .16422 L
s
.62235 .16445 m
.62235 .16445 L
s
.62243 .16375 m
.62243 .16375 L
s
.6225 .16328 m
.6225 .16328 L
s
.62258 .16422 m
.62258 .16422 L
s
.62265 .16516 m
.62265 .16516 L
s
.62273 .1661 m
.62273 .1661 L
s
.62279 .16681 m
.62279 .16681 L
s
.62287 .16681 m
.62287 .16681 L
s
.62294 .16868 m
.62294 .16868 L
s
.62302 .16774 m
.62302 .16774 L
s
.62309 .16892 m
.62309 .16892 L
s
.62317 .16798 m
.62317 .16798 L
s
.62324 .16845 m
.62324 .16845 L
s
.62331 .16915 m
.62331 .16915 L
s
.62339 .17009 m
.62339 .17009 L
s
.62347 .17056 m
.62347 .17056 L
s
.62354 .17009 m
.62354 .17009 L
s
.62361 .1715 m
.62361 .1715 L
s
.62369 .17033 m
.62369 .17033 L
s
.62376 .17056 m
.62376 .17056 L
s
.62384 .16963 m
.62384 .16963 L
s
.62391 .16986 m
.62391 .16986 L
s
.62399 .16892 m
.62399 .16892 L
s
.62406 .16868 m
.62406 .16868 L
s
.62413 .16845 m
.62413 .16845 L
s
.62421 .17009 m
.62421 .17009 L
s
.62429 .16939 m
.62429 .16939 L
s
.62436 .16963 m
.62436 .16963 L
s
.62443 .16963 m
.62443 .16963 L
s
.6245 .16821 m
.6245 .16821 L
s
.62458 .17033 m
.62458 .17033 L
s
.62465 .16963 m
.62465 .16963 L
s
.62473 .1708 m
.62473 .1708 L
s
.6248 .16939 m
.6248 .16939 L
s
.62488 .17291 m
.62488 .17291 L
s
.62495 .17315 m
.62495 .17315 L
s
.62502 .17267 m
.62502 .17267 L
s
.6251 .17409 m
.6251 .17409 L
s
.62518 .17409 m
.62518 .17409 L
s
.62525 .1762 m
.62525 .1762 L
s
.62532 .17691 m
.62532 .17691 L
s
.6254 .17878 m
.6254 .17878 L
s
.62547 .17925 m
.62547 .17925 L
s
.62555 .18066 m
.62555 .18066 L
s
.62562 .17644 m
.62562 .17644 L
s
.6257 .17855 m
.6257 .17855 L
s
.62576 .17761 m
.62576 .17761 L
s
.62584 .17714 m
.62584 .17714 L
s
.62592 .17667 m
.62592 .17667 L
s
.62599 .17573 m
.62599 .17573 L
s
.62606 .17667 m
.62606 .17667 L
s
.62614 .17549 m
.62614 .17549 L
s
.62621 .17738 m
.62621 .17738 L
s
.62629 .17479 m
.62629 .17479 L
s
.62636 .17526 m
.62636 .17526 L
s
.62644 .17338 m
.62644 .17338 L
s
.62651 .17456 m
.62651 .17456 L
s
.62658 .17549 m
.62658 .17549 L
s
.62665 .17644 m
.62665 .17644 L
s
.62673 .17573 m
.62673 .17573 L
s
.62681 .17549 m
.62681 .17549 L
s
.62688 .17385 m
.62688 .17385 L
s
.62696 .17409 m
.62696 .17409 L
s
.62703 .17456 m
.62703 .17456 L
s
.62711 .17362 m
.62711 .17362 L
s
.62718 .17502 m
.62718 .17502 L
s
.62726 .17526 m
.62726 .17526 L
s
.62733 .17596 m
.62733 .17596 L
s
.6274 .17432 m
.6274 .17432 L
s
.62747 .17456 m
.62747 .17456 L
s
.62755 .17291 m
.62755 .17291 L
s
.62762 .1722 m
.62762 .1722 L
s
.6277 .17197 m
.6277 .17197 L
s
.62777 .17127 m
.62777 .17127 L
s
.62785 .17432 m
.62785 .17432 L
s
.62792 .17385 m
.62792 .17385 L
s
.628 .17456 m
.628 .17456 L
s
.62807 .17409 m
.62807 .17409 L
s
.62815 .17362 m
.62815 .17362 L
s
.62821 .17244 m
.62821 .17244 L
s
.62829 .17291 m
.62829 .17291 L
s
.62837 .17432 m
.62837 .17432 L
s
.62844 .1762 m
.62844 .1762 L
s
.62852 .17691 m
.62852 .17691 L
s
.62859 .17432 m
.62859 .17432 L
s
.62867 .17432 m
.62867 .17432 L
s
.62874 .17244 m
.62874 .17244 L
s
.62882 .17338 m
.62882 .17338 L
s
.62889 .17244 m
.62889 .17244 L
s
.62896 .1715 m
.62896 .1715 L
s
.62903 .1715 m
.62903 .1715 L
s
.62911 .17244 m
.62911 .17244 L
s
.62918 .17244 m
.62918 .17244 L
s
.62926 .17291 m
.62926 .17291 L
s
.62933 .1722 m
.62933 .1722 L
s
.62941 .1722 m
.62941 .1722 L
s
.62948 .17267 m
.62948 .17267 L
s
.62956 .16963 m
.62956 .16963 L
s
.62963 .17244 m
.62963 .17244 L
s
.62971 .17103 m
.62971 .17103 L
s
.62978 .17267 m
.62978 .17267 L
s
.62985 .17244 m
.62985 .17244 L
s
.62993 .17103 m
.62993 .17103 L
s
.63 .17244 m
.63 .17244 L
s
.63008 .17432 m
.63008 .17432 L
s
.63015 .17338 m
.63015 .17338 L
s
.63023 .17291 m
.63023 .17291 L
s
.6303 .17432 m
.6303 .17432 L
s
.63038 .17338 m
.63038 .17338 L
s
.63045 .17479 m
.63045 .17479 L
s
.63053 .17502 m
.63053 .17502 L
s
.63059 .1762 m
.63059 .1762 L
s
.63067 .17714 m
.63067 .17714 L
s
.63074 .17855 m
.63074 .17855 L
s
.63082 .17831 m
.63082 .17831 L
s
.63089 .1762 m
.63089 .1762 L
s
.63097 .1762 m
.63097 .1762 L
s
.63104 .17738 m
.63104 .17738 L
s
.63112 .17784 m
.63112 .17784 L
s
.63119 .17831 m
.63119 .17831 L
s
.63127 .17855 m
.63127 .17855 L
s
.63134 .17878 m
.63134 .17878 L
s
.63141 .17784 m
.63141 .17784 L
s
.63149 .17878 m
.63149 .17878 L
s
.63156 .17902 m
.63156 .17902 L
s
.63164 .18043 m
.63164 .18043 L
s
.63171 .17878 m
.63171 .17878 L
s
.63179 .1802 m
.63179 .1802 L
s
.63186 .17948 m
.63186 .17948 L
s
.63193 .1809 m
.63193 .1809 L
s
.63201 .18137 m
.63201 .18137 L
s
.63209 .18254 m
.63209 .18254 L
s
.63216 .18184 m
.63216 .18184 L
s
.63223 .1809 m
.63223 .1809 L
s
.6323 .18066 m
.6323 .18066 L
s
.63238 .17996 m
.63238 .17996 L
s
.63245 .18113 m
.63245 .18113 L
s
.63253 .1823 m
.63253 .1823 L
s
.6326 .18419 m
.6326 .18419 L
s
.63268 .18348 m
.63268 .18348 L
s
.63275 .18583 m
.63275 .18583 L
s
.63283 .18536 m
.63283 .18536 L
s
.6329 .18536 m
.6329 .18536 L
s
.63298 .18325 m
.63298 .18325 L
s
.63305 .18372 m
.63305 .18372 L
s
.63312 .18442 m
.63312 .18442 L
s
.6332 .18419 m
.6332 .18419 L
s
.63327 .18419 m
.63327 .18419 L
s
.63335 .18395 m
.63335 .18395 L
s
.63342 .18419 m
.63342 .18419 L
s
.6335 .18137 m
.6335 .18137 L
s
.63356 .18325 m
.63356 .18325 L
s
.63364 .18301 m
.63364 .18301 L
s
.63372 .18512 m
.63372 .18512 L
s
.63379 .18372 m
.63379 .18372 L
s
.63386 .18325 m
.63386 .18325 L
s
.63394 .18348 m
.63394 .18348 L
s
.63401 .18372 m
.63401 .18372 L
s
.63409 .18348 m
.63409 .18348 L
s
.63416 .1823 m
.63416 .1823 L
s
.63424 .18395 m
.63424 .18395 L
s
.63431 .18254 m
.63431 .18254 L
s
.63438 .18254 m
.63438 .18254 L
s
.63446 .18301 m
.63446 .18301 L
s
.63454 .18277 m
.63454 .18277 L
s
.63461 .18277 m
.63461 .18277 L
s
.63468 .1823 m
.63468 .1823 L
s
.63476 .18277 m
.63476 .18277 L
s
.63483 .1823 m
.63483 .1823 L
s
.63491 .18254 m
.63491 .18254 L
s
.63498 .18301 m
.63498 .18301 L
s
.63506 .18442 m
.63506 .18442 L
s
.63513 .18489 m
.63513 .18489 L
s
.6352 .18559 m
.6352 .18559 L
s
.63527 .18583 m
.63527 .18583 L
s
.63535 .18606 m
.63535 .18606 L
s
.63542 .18559 m
.63542 .18559 L
s
.6355 .18419 m
.6355 .18419 L
s
.63557 .18254 m
.63557 .18254 L
s
.63565 .1823 m
.63565 .1823 L
s
.63572 .1823 m
.63572 .1823 L
s
.6358 .18325 m
.6358 .18325 L
s
.63587 .18395 m
.63587 .18395 L
s
.63595 .18277 m
.63595 .18277 L
s
.63601 .18419 m
.63601 .18419 L
s
.63609 .18184 m
.63609 .18184 L
s
.63617 .18184 m
.63617 .18184 L
s
.63624 .18277 m
.63624 .18277 L
s
.63632 .18254 m
.63632 .18254 L
s
.63639 .18442 m
.63639 .18442 L
s
.63647 .18419 m
.63647 .18419 L
s
.63654 .18395 m
.63654 .18395 L
s
.63662 .18395 m
.63662 .18395 L
s
.63669 .18536 m
.63669 .18536 L
s
.63676 .18489 m
.63676 .18489 L
s
.63683 .18724 m
.63683 .18724 L
s
.63691 .18559 m
.63691 .18559 L
s
.63698 .18489 m
.63698 .18489 L
s
.63706 .18536 m
.63706 .18536 L
s
.63713 .18677 m
.63713 .18677 L
s
.63721 .18748 m
.63721 .18748 L
s
.63728 .18865 m
.63728 .18865 L
s
.63736 .18794 m
.63736 .18794 L
s
.63743 .18677 m
.63743 .18677 L
s
.63751 .18701 m
.63751 .18701 L
s
.63758 .18654 m
.63758 .18654 L
s
.63765 .18677 m
.63765 .18677 L
s
.63773 .18559 m
.63773 .18559 L
s
.6378 .18583 m
.6378 .18583 L
s
.63788 .18606 m
.63788 .18606 L
s
.63795 .18536 m
.63795 .18536 L
s
.63803 .18559 m
.63803 .18559 L
s
.6381 .18771 m
.6381 .18771 L
s
.63818 .18818 m
.63818 .18818 L
s
.63825 .18771 m
.63825 .18771 L
s
.63833 .18865 m
.63833 .18865 L
s
.63839 .18794 m
.63839 .18794 L
s
.63847 .18818 m
.63847 .18818 L
s
.63854 .18841 m
.63854 .18841 L
s
.63862 .18654 m
.63862 .18654 L
s
.63869 .18536 m
.63869 .18536 L
s
.63877 .18372 m
.63877 .18372 L
s
.63884 .18512 m
.63884 .18512 L
s
.63892 .18512 m
.63892 .18512 L
s
.63899 .18583 m
.63899 .18583 L
s
.63907 .18512 m
.63907 .18512 L
s
.63914 .18583 m
.63914 .18583 L
s
.63921 .18794 m
.63921 .18794 L
s
.63929 .18818 m
.63929 .18818 L
s
.63936 .18865 m
.63936 .18865 L
s
.63944 .18841 m
.63944 .18841 L
s
.63951 .18724 m
.63951 .18724 L
s
.63959 .18559 m
.63959 .18559 L
s
.63966 .18536 m
.63966 .18536 L
s
.63973 .18466 m
.63973 .18466 L
s
.63981 .18395 m
.63981 .18395 L
s
.63989 .18348 m
.63989 .18348 L
s
.63996 .18325 m
.63996 .18325 L
s
.64003 .18419 m
.64003 .18419 L
s
.6401 .18325 m
.6401 .18325 L
s
.64018 .18395 m
.64018 .18395 L
s
.64025 .18419 m
.64025 .18419 L
s
.64033 .18419 m
.64033 .18419 L
s
.6404 .18677 m
.6404 .18677 L
s
.64048 .18794 m
.64048 .18794 L
s
.64055 .18865 m
.64055 .18865 L
s
.64063 .18958 m
.64063 .18958 L
s
.6407 .18818 m
.6407 .18818 L
s
.64078 .18912 m
.64078 .18912 L
s
.64085 .18794 m
.64085 .18794 L
s
.64092 .18771 m
.64092 .18771 L
s
.641 .18701 m
.641 .18701 L
s
.64107 .18583 m
.64107 .18583 L
s
.64115 .18606 m
.64115 .18606 L
s
.64122 .1863 m
.64122 .1863 L
s
.6413 .18701 m
.6413 .18701 L
s
.64137 .18536 m
.64137 .18536 L
s
.64145 .18606 m
.64145 .18606 L
s
.64152 .18559 m
.64152 .18559 L
s
.64159 .18724 m
.64159 .18724 L
s
.64166 .18606 m
.64166 .18606 L
s
.64174 .18677 m
.64174 .18677 L
s
.64181 .18559 m
.64181 .18559 L
s
.64189 .18466 m
.64189 .18466 L
s
.64196 .18419 m
.64196 .18419 L
s
.64204 .18559 m
.64204 .18559 L
s
.64211 .18489 m
.64211 .18489 L
s
.64218 .18348 m
.64218 .18348 L
s
.64226 .18348 m
.64226 .18348 L
s
.64234 .1823 m
.64234 .1823 L
s
.64241 .18277 m
.64241 .18277 L
s
.64248 .18254 m
.64248 .18254 L
s
.64256 .18207 m
.64256 .18207 L
s
.64263 .18277 m
.64263 .18277 L
s
.64271 .18395 m
.64271 .18395 L
s
.64278 .18466 m
.64278 .18466 L
s
.64286 .18512 m
.64286 .18512 L
s
.64293 .18536 m
.64293 .18536 L
s
.643 .18277 m
.643 .18277 L
s
.64308 .1823 m
.64308 .1823 L
s
.64316 .18066 m
.64316 .18066 L
s
.64322 .1809 m
.64322 .1809 L
s
.6433 .18184 m
.6433 .18184 L
s
.64337 .1823 m
.64337 .1823 L
s
.64345 .17948 m
.64345 .17948 L
s
.64352 .17878 m
.64352 .17878 L
s
.6436 .17925 m
.6436 .17925 L
s
.64367 .17996 m
.64367 .17996 L
s
.64375 .18137 m
.64375 .18137 L
s
.64381 .1809 m
.64381 .1809 L
s
.64389 .1823 m
.64389 .1823 L
s
.64397 .18066 m
.64397 .18066 L
s
.64404 .1823 m
.64404 .1823 L
s
.64412 .18043 m
.64412 .18043 L
s
.64419 .1809 m
.64419 .1809 L
s
.64427 .17878 m
.64427 .17878 L
s
.64434 .17855 m
.64434 .17855 L
s
.64442 .17925 m
.64442 .17925 L
s
.64449 .17902 m
.64449 .17902 L
s
.64456 .1809 m
.64456 .1809 L
s
.64463 .17973 m
.64463 .17973 L
s
.64471 .1802 m
.64471 .1802 L
s
.64479 .17878 m
.64479 .17878 L
s
.64486 .17996 m
.64486 .17996 L
s
.64493 .17808 m
.64493 .17808 L
s
.64501 .17902 m
.64501 .17902 L
s
.64508 .17714 m
.64508 .17714 L
s
.64516 .17738 m
.64516 .17738 L
s
.64523 .17667 m
.64523 .17667 L
s
.64531 .17479 m
.64531 .17479 L
s
.64538 .17549 m
.64538 .17549 L
s
.64545 .17573 m
.64545 .17573 L
s
.64553 .1762 m
.64553 .1762 L
s
.6456 .1762 m
.6456 .1762 L
s
.64568 .17714 m
.64568 .17714 L
s
.64575 .17738 m
.64575 .17738 L
s
.64583 .17878 m
.64583 .17878 L
s
.6459 .18137 m
.6459 .18137 L
s
.64598 .18207 m
.64598 .18207 L
s
.64605 .18419 m
.64605 .18419 L
s
.64613 .18277 m
.64613 .18277 L
s
.64619 .18207 m
.64619 .18207 L
s
.64627 .18207 m
.64627 .18207 L
s
.64634 .18325 m
.64634 .18325 L
s
.64642 .18301 m
.64642 .18301 L
s
.64649 .18348 m
.64649 .18348 L
s
.64657 .18325 m
.64657 .18325 L
s
.64664 .18512 m
.64664 .18512 L
s
.64672 .18442 m
.64672 .18442 L
s
.64679 .18466 m
.64679 .18466 L
s
.64687 .18606 m
.64687 .18606 L
s
.64694 .18442 m
.64694 .18442 L
s
.64701 .18395 m
.64701 .18395 L
s
.64709 .18277 m
.64709 .18277 L
s
.64716 .18395 m
.64716 .18395 L
s
.64724 .18277 m
.64724 .18277 L
s
.64731 .18442 m
.64731 .18442 L
s
.64739 .18489 m
.64739 .18489 L
s
.64746 .18559 m
.64746 .18559 L
s
.64754 .18512 m
.64754 .18512 L
s
.64761 .18466 m
.64761 .18466 L
s
.64769 .18701 m
.64769 .18701 L
s
.64776 .18677 m
.64776 .18677 L
s
.64783 .18958 m
.64783 .18958 L
s
.6479 .19006 m
.6479 .19006 L
s
.64798 .19053 m
.64798 .19053 L
s
.64805 .19006 m
.64805 .19006 L
s
.64813 .18888 m
.64813 .18888 L
s
.6482 .18818 m
.6482 .18818 L
s
.64828 .18888 m
.64828 .18888 L
s
.64835 .18748 m
.64835 .18748 L
s
.64843 .18606 m
.64843 .18606 L
s
.6485 .18841 m
.6485 .18841 L
s
.64858 .18748 m
.64858 .18748 L
s
.64865 .18771 m
.64865 .18771 L
s
.64872 .18771 m
.64872 .18771 L
s
.6488 .18794 m
.6488 .18794 L
s
.64887 .18983 m
.64887 .18983 L
s
.64895 .18888 m
.64895 .18888 L
s
.64902 .18841 m
.64902 .18841 L
s
.6491 .18935 m
.6491 .18935 L
s
.64917 .18983 m
.64917 .18983 L
s
.64925 .18865 m
.64925 .18865 L
s
.64932 .191 m
.64932 .191 L
s
.64939 .191 m
.64939 .191 L
s
.64946 .19264 m
.64946 .19264 L
s
.64954 .1924 m
.64954 .1924 L
s
.64961 .19335 m
.64961 .19335 L
s
.64969 .19264 m
.64969 .19264 L
s
.64976 .19264 m
.64976 .19264 L
s
.64984 .19358 m
.64984 .19358 L
s
.64991 .19217 m
.64991 .19217 L
s
.64998 .19358 m
.64998 .19358 L
s
.65006 .19217 m
.65006 .19217 L
s
.65014 .19287 m
.65014 .19287 L
s
.65021 .19147 m
.65021 .19147 L
s
.65028 .19287 m
.65028 .19287 L
s
.65036 .19264 m
.65036 .19264 L
s
.65043 .19452 m
.65043 .19452 L
s
.65051 .19476 m
.65051 .19476 L
s
.65058 .19546 m
.65058 .19546 L
s
.65066 .19499 m
.65066 .19499 L
s
.65073 .19711 m
.65073 .19711 L
s
.6508 .1964 m
.6508 .1964 L
s
.65088 .19546 m
.65088 .19546 L
s
.65096 .19711 m
.65096 .19711 L
s
.65102 .1964 m
.65102 .1964 L
s
.6511 .19616 m
.6511 .19616 L
s
.65117 .19616 m
.65117 .19616 L
s
.65125 .19734 m
.65125 .19734 L
s
.65132 .1964 m
.65132 .1964 L
s
.6514 .19569 m
.6514 .19569 L
s
.65147 .19711 m
.65147 .19711 L
s
.65155 .19711 m
.65155 .19711 L
s
.65161 .19734 m
.65161 .19734 L
s
.65169 .19687 m
.65169 .19687 L
s
.65177 .19711 m
.65177 .19711 L
s
.65184 .19758 m
.65184 .19758 L
s
.65192 .19593 m
.65192 .19593 L
s
.65199 .19452 m
.65199 .19452 L
s
.65207 .19499 m
.65207 .19499 L
s
.65214 .19405 m
.65214 .19405 L
s
.65222 .19382 m
.65222 .19382 L
s
.65229 .19429 m
.65229 .19429 L
s
.65236 .19264 m
.65236 .19264 L
s
.65243 .19335 m
.65243 .19335 L
s
.65251 .19405 m
.65251 .19405 L
s
.65259 .19499 m
.65259 .19499 L
s
.65266 .19546 m
.65266 .19546 L
s
.65273 .19758 m
.65273 .19758 L
s
.65281 .19546 m
.65281 .19546 L
s
.65288 .19616 m
.65288 .19616 L
s
.65296 .19499 m
.65296 .19499 L
s
.65303 .19429 m
.65303 .19429 L
s
.65311 .19358 m
.65311 .19358 L
s
.65318 .19287 m
.65318 .19287 L
s
.65325 .19311 m
.65325 .19311 L
s
.65333 .1917 m
.65333 .1917 L
s
.6534 .19287 m
.6534 .19287 L
s
.65348 .19311 m
.65348 .19311 L
s
.65355 .19476 m
.65355 .19476 L
s
.65363 .19522 m
.65363 .19522 L
s
.6537 .19593 m
.6537 .19593 L
s
.65378 .19522 m
.65378 .19522 L
s
.65385 .19522 m
.65385 .19522 L
s
.65393 .19593 m
.65393 .19593 L
s
.65399 .19569 m
.65399 .19569 L
s
.65407 .1964 m
.65407 .1964 L
s
.65414 .19569 m
.65414 .19569 L
s
.65422 .19593 m
.65422 .19593 L
s
.65429 .19452 m
.65429 .19452 L
s
.65437 .19452 m
.65437 .19452 L
s
.65444 .19335 m
.65444 .19335 L
s
.65452 .1964 m
.65452 .1964 L
s
.65459 .1964 m
.65459 .1964 L
s
.65467 .19711 m
.65467 .19711 L
s
.65474 .19546 m
.65474 .19546 L
s
.65481 .19499 m
.65481 .19499 L
s
.65489 .1964 m
.65489 .1964 L
s
.65496 .19711 m
.65496 .19711 L
s
.65504 .19758 m
.65504 .19758 L
s
.65511 .1964 m
.65511 .1964 L
s
.65519 .19687 m
.65519 .19687 L
s
.65526 .19593 m
.65526 .19593 L
s
.65534 .19476 m
.65534 .19476 L
s
.65541 .19522 m
.65541 .19522 L
s
.65549 .19452 m
.65549 .19452 L
s
.65556 .19335 m
.65556 .19335 L
s
.65563 .19217 m
.65563 .19217 L
s
.6557 .19452 m
.6557 .19452 L
s
.65578 .19358 m
.65578 .19358 L
s
.65585 .19358 m
.65585 .19358 L
s
.65593 .19287 m
.65593 .19287 L
s
.656 .19499 m
.656 .19499 L
s
.65608 .19335 m
.65608 .19335 L
s
.65615 .19452 m
.65615 .19452 L
s
.65623 .19405 m
.65623 .19405 L
s
.6563 .19405 m
.6563 .19405 L
s
.65638 .19452 m
.65638 .19452 L
s
.65645 .19452 m
.65645 .19452 L
s
.65652 .1964 m
.65652 .1964 L
s
.6566 .19593 m
.6566 .19593 L
s
.65667 .19804 m
.65667 .19804 L
s
.65675 .19758 m
.65675 .19758 L
s
.65682 .19851 m
.65682 .19851 L
s
.6569 .19687 m
.6569 .19687 L
s
.65697 .19804 m
.65697 .19804 L
s
.65705 .19851 m
.65705 .19851 L
s
.65712 .19758 m
.65712 .19758 L
s
.65719 .19593 m
.65719 .19593 L
s
.65726 .19593 m
.65726 .19593 L
s
.65734 .19499 m
.65734 .19499 L
s
.65741 .19452 m
.65741 .19452 L
s
.65749 .19569 m
.65749 .19569 L
s
.65756 .19499 m
.65756 .19499 L
s
.65764 .19499 m
.65764 .19499 L
s
.65771 .19499 m
.65771 .19499 L
s
.65779 .19476 m
.65779 .19476 L
s
.65786 .19452 m
.65786 .19452 L
s
.65794 .19429 m
.65794 .19429 L
s
.65801 .19382 m
.65801 .19382 L
s
.65808 .19358 m
.65808 .19358 L
s
.65816 .19546 m
.65816 .19546 L
s
.65823 .19405 m
.65823 .19405 L
s
.65831 .19358 m
.65831 .19358 L
s
.65838 .19311 m
.65838 .19311 L
s
.65846 .1924 m
.65846 .1924 L
s
.65853 .19123 m
.65853 .19123 L
s
.6586 .19147 m
.6586 .19147 L
s
.65868 .19006 m
.65868 .19006 L
s
.65876 .18935 m
.65876 .18935 L
s
.65882 .19006 m
.65882 .19006 L
s
.6589 .18818 m
.6589 .18818 L
s
.65897 .18724 m
.65897 .18724 L
s
.65905 .18606 m
.65905 .18606 L
s
.65912 .18912 m
.65912 .18912 L
s
.6592 .1863 m
.6592 .1863 L
s
.65927 .18794 m
.65927 .18794 L
s
.65935 .18794 m
.65935 .18794 L
s
.65942 .18818 m
.65942 .18818 L
s
.6595 .18654 m
.6595 .18654 L
s
.65958 .18536 m
.65958 .18536 L
s
.65964 .18536 m
.65964 .18536 L
s
.65972 .18536 m
.65972 .18536 L
s
.65979 .18748 m
.65979 .18748 L
s
.65987 .18654 m
.65987 .18654 L
s
.65994 .18794 m
.65994 .18794 L
s
.66002 .18536 m
.66002 .18536 L
s
.66009 .1863 m
.66009 .1863 L
s
.66016 .18606 m
.66016 .18606 L
s
.66023 .18606 m
.66023 .18606 L
s
.66031 .18701 m
.66031 .18701 L
s
.66039 .18724 m
.66039 .18724 L
s
.66046 .18677 m
.66046 .18677 L
s
.66053 .18489 m
.66053 .18489 L
s
.66061 .18466 m
.66061 .18466 L
s
.66068 .18372 m
.66068 .18372 L
s
.66076 .18372 m
.66076 .18372 L
s
.66083 .18466 m
.66083 .18466 L
s
.66091 .18489 m
.66091 .18489 L
s
.66098 .18489 m
.66098 .18489 L
s
.66105 .18419 m
.66105 .18419 L
s
.66113 .18536 m
.66113 .18536 L
s
.66121 .18724 m
.66121 .18724 L
s
.66128 .18724 m
.66128 .18724 L
s
.66135 .18583 m
.66135 .18583 L
s
.66143 .18489 m
.66143 .18489 L
s
.6615 .18325 m
.6615 .18325 L
s
.66158 .18301 m
.66158 .18301 L
s
.66165 .18325 m
.66165 .18325 L
s
.66173 .18442 m
.66173 .18442 L
s
.66179 .18395 m
.66179 .18395 L
s
.66187 .18419 m
.66187 .18419 L
s
.66194 .18466 m
.66194 .18466 L
s
.66202 .18466 m
.66202 .18466 L
s
.66209 .18559 m
.66209 .18559 L
s
.66217 .1863 m
.66217 .1863 L
s
.66224 .18559 m
.66224 .18559 L
s
.66232 .18512 m
.66232 .18512 L
s
.66239 .18677 m
.66239 .18677 L
s
.66247 .1863 m
.66247 .1863 L
s
.66254 .18583 m
.66254 .18583 L
s
.66261 .18606 m
.66261 .18606 L
s
.66269 .18536 m
.66269 .18536 L
s
.66276 .18771 m
.66276 .18771 L
s
.66284 .18724 m
.66284 .18724 L
s
.66291 .18818 m
.66291 .18818 L
s
.66299 .18771 m
.66299 .18771 L
s
.66306 .18888 m
.66306 .18888 L
s
.66314 .18771 m
.66314 .18771 L
s
.66321 .18888 m
.66321 .18888 L
s
.66329 .18888 m
.66329 .18888 L
s
.66336 .18958 m
.66336 .18958 L
s
.66343 .18935 m
.66343 .18935 L
s
.6635 .18818 m
.6635 .18818 L
s
.66358 .18748 m
.66358 .18748 L
s
.66365 .18748 m
.66365 .18748 L
s
.66373 .18794 m
.66373 .18794 L
s
.6638 .18677 m
.6638 .18677 L
s
.66388 .18701 m
.66388 .18701 L
s
.66395 .18654 m
.66395 .18654 L
s
.66403 .18748 m
.66403 .18748 L
s
.6641 .18748 m
.6641 .18748 L
s
.66418 .18771 m
.66418 .18771 L
s
.66425 .18818 m
.66425 .18818 L
s
.66432 .18841 m
.66432 .18841 L
s
.6644 .191 m
.6644 .191 L
s
.66447 .18935 m
.66447 .18935 L
s
.66455 .18983 m
.66455 .18983 L
s
.66462 .18794 m
.66462 .18794 L
s
.6647 .18888 m
.6647 .18888 L
s
.66477 .18958 m
.66477 .18958 L
s
.66485 .1903 m
.66485 .1903 L
s
.66492 .1903 m
.66492 .1903 L
s
.66499 .19076 m
.66499 .19076 L
s
.66506 .18983 m
.66506 .18983 L
s
.66514 .19053 m
.66514 .19053 L
s
.66521 .19147 m
.66521 .19147 L
s
.66529 .19123 m
.66529 .19123 L
s
.66536 .19217 m
.66536 .19217 L
s
.66544 .19076 m
.66544 .19076 L
s
.66551 .1917 m
.66551 .1917 L
s
.66559 .191 m
.66559 .191 L
s
.66566 .19311 m
.66566 .19311 L
s
.66574 .19405 m
.66574 .19405 L
s
.66581 .19335 m
.66581 .19335 L
s
.66588 .19311 m
.66588 .19311 L
s
.66596 .19217 m
.66596 .19217 L
s
.66603 .19287 m
.66603 .19287 L
s
.66611 .19335 m
.66611 .19335 L
s
.66618 .19429 m
.66618 .19429 L
s
.66626 .19264 m
.66626 .19264 L
s
.66633 .19429 m
.66633 .19429 L
s
.66641 .19429 m
.66641 .19429 L
s
.66648 .19476 m
.66648 .19476 L
s
.66656 .19546 m
.66656 .19546 L
s
.66663 .19664 m
.66663 .19664 L
s
.6667 .19499 m
.6667 .19499 L
s
.66677 .19546 m
.66677 .19546 L
s
.66685 .19522 m
.66685 .19522 L
s
.66692 .19476 m
.66692 .19476 L
s
.667 .19616 m
.667 .19616 L
s
.66707 .19499 m
.66707 .19499 L
s
.66715 .19522 m
.66715 .19522 L
s
.66722 .19499 m
.66722 .19499 L
s
.6673 .19546 m
.6673 .19546 L
s
.66738 .19711 m
.66738 .19711 L
s
.66744 .19781 m
.66744 .19781 L
s
.66752 .19758 m
.66752 .19758 L
s
.66759 .19781 m
.66759 .19781 L
s
.66767 .19828 m
.66767 .19828 L
s
.66774 .19734 m
.66774 .19734 L
s
.66782 .19734 m
.66782 .19734 L
s
.66789 .19711 m
.66789 .19711 L
s
.66796 .19898 m
.66796 .19898 L
s
.66804 .19968 m
.66804 .19968 L
s
.66812 .19992 m
.66812 .19992 L
s
.66819 .20063 m
.66819 .20063 L
s
.66826 .20133 m
.66826 .20133 L
s
.66833 .20063 m
.66833 .20063 L
s
.66841 .20016 m
.66841 .20016 L
s
.66848 .20227 m
.66848 .20227 L
s
.66856 .20157 m
.66856 .20157 L
s
.66863 .2018 m
.66863 .2018 L
s
.66871 .19992 m
.66871 .19992 L
s
.66878 .2011 m
.66878 .2011 L
s
.66885 .2025 m
.66885 .2025 L
s
.66893 .20345 m
.66893 .20345 L
s
.66901 .2025 m
.66901 .2025 L
s
.66908 .20345 m
.66908 .20345 L
s
.66915 .2025 m
.66915 .2025 L
s
.66923 .20227 m
.66923 .20227 L
s
.6693 .20204 m
.6693 .20204 L
s
.66938 .20086 m
.66938 .20086 L
s
.66945 .20157 m
.66945 .20157 L
s
.66953 .2011 m
.66953 .2011 L
s
.6696 .20063 m
.6696 .20063 L
s
.66967 .2011 m
.66967 .2011 L
s
.66975 .20133 m
.66975 .20133 L
s
.66982 .20086 m
.66982 .20086 L
s
.66989 .20086 m
.66989 .20086 L
s
.66997 .20297 m
.66997 .20297 L
s
.67004 .20086 m
.67004 .20086 L
s
.67012 .2025 m
.67012 .2025 L
s
.67019 .2025 m
.67019 .2025 L
s
.67027 .20274 m
.67027 .20274 L
s
.67034 .20133 m
.67034 .20133 L
s
.67041 .20439 m
.67041 .20439 L
s
.67049 .20368 m
.67049 .20368 L
s
.67056 .20462 m
.67056 .20462 L
s
.67064 .20297 m
.67064 .20297 L
s
.67071 .20345 m
.67071 .20345 L
s
.67079 .20439 m
.67079 .20439 L
s
.67086 .2011 m
.67086 .2011 L
s
.67094 .20157 m
.67094 .20157 L
s
.67101 .20297 m
.67101 .20297 L
s
.67109 .20462 m
.67109 .20462 L
s
.67116 .20486 m
.67116 .20486 L
s
.67123 .20674 m
.67123 .20674 L
s
.6713 .20768 m
.6713 .20768 L
s
.67138 .20674 m
.67138 .20674 L
s
.67146 .20697 m
.67146 .20697 L
s
.67153 .2065 m
.67153 .2065 L
s
.6716 .20768 m
.6716 .20768 L
s
.67168 .20838 m
.67168 .20838 L
s
.67175 .20885 m
.67175 .20885 L
s
.67183 .20814 m
.67183 .20814 L
s
.6719 .2112 m
.6719 .2112 L
s
.67198 .20885 m
.67198 .20885 L
s
.67205 .20861 m
.67205 .20861 L
s
.67212 .20861 m
.67212 .20861 L
s
.6722 .20768 m
.6722 .20768 L
s
.67227 .2065 m
.67227 .2065 L
s
.67235 .20626 m
.67235 .20626 L
s
.67242 .20415 m
.67242 .20415 L
s
.6725 .20439 m
.6725 .20439 L
s
.67257 .20509 m
.67257 .20509 L
s
.67265 .20321 m
.67265 .20321 L
s
.67272 .20368 m
.67272 .20368 L
s
.67279 .20133 m
.67279 .20133 L
s
.67286 .20227 m
.67286 .20227 L
s
.67294 .20297 m
.67294 .20297 L
s
.67301 .20297 m
.67301 .20297 L
s
.67309 .20274 m
.67309 .20274 L
s
.67316 .20345 m
.67316 .20345 L
s
.67324 .20415 m
.67324 .20415 L
s
.67331 .20345 m
.67331 .20345 L
s
.67339 .20439 m
.67339 .20439 L
s
.67346 .2025 m
.67346 .2025 L
s
.67354 .20204 m
.67354 .20204 L
s
.67361 .20204 m
.67361 .20204 L
s
.67368 .20321 m
.67368 .20321 L
s
.67376 .20345 m
.67376 .20345 L
s
.67383 .20462 m
.67383 .20462 L
s
.67391 .20532 m
.67391 .20532 L
s
.67398 .2065 m
.67398 .2065 L
s
.67406 .20509 m
.67406 .20509 L
s
.67413 .20556 m
.67413 .20556 L
s
.67421 .20744 m
.67421 .20744 L
s
.67428 .20532 m
.67428 .20532 L
s
.67436 .20626 m
.67436 .20626 L
s
.67443 .20674 m
.67443 .20674 L
s
.6745 .20768 m
.6745 .20768 L
s
.67457 .20908 m
.67457 .20908 L
s
.67465 .20885 m
.67465 .20885 L
s
.67472 .20955 m
.67472 .20955 L
s
.6748 .20885 m
.6748 .20885 L
s
.67487 .21026 m
.67487 .21026 L
s
.67495 .20861 m
.67495 .20861 L
s
.67502 .20814 m
.67502 .20814 L
s
.6751 .20814 m
.6751 .20814 L
s
.67518 .20674 m
.67518 .20674 L
s
.67524 .20556 m
.67524 .20556 L
s
.67532 .20674 m
.67532 .20674 L
s
.67539 .20744 m
.67539 .20744 L
s
.67547 .20674 m
.67547 .20674 L
s
.67554 .20674 m
.67554 .20674 L
s
.67562 .20885 m
.67562 .20885 L
s
.67569 .20932 m
.67569 .20932 L
s
.67576 .20838 m
.67576 .20838 L
s
.67584 .20744 m
.67584 .20744 L
s
.67592 .20814 m
.67592 .20814 L
s
.67599 .20932 m
.67599 .20932 L
s
.67606 .20838 m
.67606 .20838 L
s
.67613 .20979 m
.67613 .20979 L
s
.67621 .20955 m
.67621 .20955 L
s
.67628 .21002 m
.67628 .21002 L
s
.67636 .20861 m
.67636 .20861 L
s
.67643 .20674 m
.67643 .20674 L
s
.67651 .20721 m
.67651 .20721 L
s
.67658 .20768 m
.67658 .20768 L
s
.67666 .20721 m
.67666 .20721 L
s
.67674 .20532 m
.67674 .20532 L
s
.67681 .20768 m
.67681 .20768 L
s
.67688 .20697 m
.67688 .20697 L
s
.67695 .20674 m
.67695 .20674 L
s
.67703 .20814 m
.67703 .20814 L
s
.6771 .20744 m
.6771 .20744 L
s
.67718 .20768 m
.67718 .20768 L
s
.67725 .20579 m
.67725 .20579 L
s
.67733 .20721 m
.67733 .20721 L
s
.6774 .20674 m
.6774 .20674 L
s
.67747 .20744 m
.67747 .20744 L
s
.67755 .20603 m
.67755 .20603 L
s
.67762 .20721 m
.67762 .20721 L
s
.67769 .20532 m
.67769 .20532 L
s
.67777 .20579 m
.67777 .20579 L
s
.67784 .20509 m
.67784 .20509 L
s
.67792 .20579 m
.67792 .20579 L
s
.67799 .20674 m
.67799 .20674 L
s
.67807 .20603 m
.67807 .20603 L
s
.67814 .20721 m
.67814 .20721 L
s
.67821 .20744 m
.67821 .20744 L
s
.67829 .20744 m
.67829 .20744 L
s
.67837 .20697 m
.67837 .20697 L
s
.67844 .20768 m
.67844 .20768 L
s
.67851 .20721 m
.67851 .20721 L
s
.67859 .20814 m
.67859 .20814 L
s
.67866 .20885 m
.67866 .20885 L
s
.67874 .20908 m
.67874 .20908 L
s
.67881 .20979 m
.67881 .20979 L
s
.67889 .21073 m
.67889 .21073 L
s
.67896 .21214 m
.67896 .21214 L
s
.67903 .21096 m
.67903 .21096 L
s
.6791 .21002 m
.6791 .21002 L
s
.67918 .20955 m
.67918 .20955 L
s
.67926 .21237 m
.67926 .21237 L
s
.67933 .21284 m
.67933 .21284 L
s
.6794 .2119 m
.6794 .2119 L
s
.67948 .20979 m
.67948 .20979 L
s
.67955 .21096 m
.67955 .21096 L
s
.67963 .21143 m
.67963 .21143 L
s
.6797 .21073 m
.6797 .21073 L
s
.67978 .21073 m
.67978 .21073 L
s
.67985 .21073 m
.67985 .21073 L
s
.67992 .21167 m
.67992 .21167 L
s
.68 .21143 m
.68 .21143 L
s
.68007 .21355 m
.68007 .21355 L
s
.68015 .21519 m
.68015 .21519 L
s
.68022 .21542 m
.68022 .21542 L
s
.6803 .21613 m
.6803 .21613 L
s
.68037 .21636 m
.68037 .21636 L
s
.68045 .21754 m
.68045 .21754 L
s
.68052 .21707 m
.68052 .21707 L
s
.68059 .21589 m
.68059 .21589 L
s
.68066 .21589 m
.68066 .21589 L
s
.68074 .21566 m
.68074 .21566 L
s
.68081 .21449 m
.68081 .21449 L
s
.68089 .21519 m
.68089 .21519 L
s
.68096 .21425 m
.68096 .21425 L
s
.68104 .21542 m
.68104 .21542 L
s
.68111 .21613 m
.68111 .21613 L
s
.68119 .21589 m
.68119 .21589 L
s
.68126 .21496 m
.68126 .21496 L
s
.68134 .21519 m
.68134 .21519 L
s
.68141 .21519 m
.68141 .21519 L
s
.68148 .21402 m
.68148 .21402 L
s
.68156 .21589 m
.68156 .21589 L
s
.68163 .21472 m
.68163 .21472 L
s
.68171 .21425 m
.68171 .21425 L
s
.68178 .21613 m
.68178 .21613 L
s
.68186 .21778 m
.68186 .21778 L
s
.68193 .21778 m
.68193 .21778 L
s
.68201 .21918 m
.68201 .21918 L
s
.68208 .21895 m
.68208 .21895 L
s
.68216 .21942 m
.68216 .21942 L
s
.68223 .22036 m
.68223 .22036 L
s
.6823 .21965 m
.6823 .21965 L
s
.68237 .21895 m
.68237 .21895 L
s
.68245 .21965 m
.68245 .21965 L
s
.68252 .2213 m
.68252 .2213 L
s
.6826 .222 m
.6826 .222 L
s
.68267 .22177 m
.68267 .22177 L
s
.68275 .222 m
.68275 .222 L
s
.68282 .22271 m
.68282 .22271 L
s
.6829 .22341 m
.6829 .22341 L
s
.68298 .2213 m
.68298 .2213 L
s
.68304 .22271 m
.68304 .22271 L
s
.68312 .2213 m
.68312 .2213 L
s
.68319 .22388 m
.68319 .22388 L
s
.68327 .22341 m
.68327 .22341 L
s
.68334 .22412 m
.68334 .22412 L
s
.68342 .22459 m
.68342 .22459 L
s
.68349 .22271 m
.68349 .22271 L
s
.68357 .22506 m
.68357 .22506 L
s
.68364 .22599 m
.68364 .22599 L
s
.68372 .22623 m
.68372 .22623 L
s
.68379 .22506 m
.68379 .22506 L
s
.68386 .22693 m
.68386 .22693 L
s
.68393 .22623 m
.68393 .22623 L
s
.68401 .22858 m
.68401 .22858 L
s
.68408 .22693 m
.68408 .22693 L
s
.68416 .22717 m
.68416 .22717 L
s
.68423 .22646 m
.68423 .22646 L
s
.68431 .22506 m
.68431 .22506 L
s
.68438 .2267 m
.68438 .2267 L
s
.68446 .22576 m
.68446 .22576 L
s
.68454 .22741 m
.68454 .22741 L
s
.68461 .22599 m
.68461 .22599 L
s
.68468 .22693 m
.68468 .22693 L
s
.68475 .22623 m
.68475 .22623 L
s
.68483 .22646 m
.68483 .22646 L
s
.6849 .22552 m
.6849 .22552 L
s
.68498 .22599 m
.68498 .22599 L
s
.68505 .22646 m
.68505 .22646 L
s
.68513 .22717 m
.68513 .22717 L
s
.6852 .22599 m
.6852 .22599 L
s
.68528 .22623 m
.68528 .22623 L
s
.68535 .22717 m
.68535 .22717 L
s
.68542 .22811 m
.68542 .22811 L
s
.68549 .22788 m
.68549 .22788 L
s
.68557 .22623 m
.68557 .22623 L
s
.68564 .22788 m
.68564 .22788 L
s
.68572 .22717 m
.68572 .22717 L
s
.68579 .22764 m
.68579 .22764 L
s
.68587 .22928 m
.68587 .22928 L
s
.68594 .22999 m
.68594 .22999 L
s
.68601 .2321 m
.68601 .2321 L
s
.68609 .23093 m
.68609 .23093 L
s
.68617 .2321 m
.68617 .2321 L
s
.68624 .2314 m
.68624 .2314 L
s
.68631 .2307 m
.68631 .2307 L
s
.68639 .23093 m
.68639 .23093 L
s
.68646 .23093 m
.68646 .23093 L
s
.68654 .23022 m
.68654 .23022 L
s
.68661 .23093 m
.68661 .23093 L
s
.68669 .23234 m
.68669 .23234 L
s
.68676 .23093 m
.68676 .23093 L
s
.68683 .2314 m
.68683 .2314 L
s
.68691 .23093 m
.68691 .23093 L
s
.68699 .23351 m
.68699 .23351 L
s
.68706 .23257 m
.68706 .23257 L
s
.68713 .23374 m
.68713 .23374 L
s
.6872 .23093 m
.6872 .23093 L
s
.68728 .23022 m
.68728 .23022 L
s
.68735 .23022 m
.68735 .23022 L
s
.68743 .22834 m
.68743 .22834 L
s
.6875 .22811 m
.6875 .22811 L
s
.68758 .22646 m
.68758 .22646 L
s
.68765 .22693 m
.68765 .22693 L
s
.68772 .2267 m
.68772 .2267 L
s
.6878 .22693 m
.6878 .22693 L
s
.68787 .22599 m
.68787 .22599 L
s
.68795 .2267 m
.68795 .2267 L
s
.68802 .22576 m
.68802 .22576 L
s
.6881 .22576 m
.6881 .22576 L
s
.68817 .22623 m
.68817 .22623 L
s
.68825 .22623 m
.68825 .22623 L
s
.68832 .22717 m
.68832 .22717 L
s
.68839 .22741 m
.68839 .22741 L
s
.68846 .22576 m
.68846 .22576 L
s
.68854 .22412 m
.68854 .22412 L
s
.68862 .22435 m
.68862 .22435 L
s
.68869 .22459 m
.68869 .22459 L
s
.68876 .22599 m
.68876 .22599 L
s
.68884 .22623 m
.68884 .22623 L
s
.68891 .22552 m
.68891 .22552 L
s
.68899 .22506 m
.68899 .22506 L
s
.68906 .2267 m
.68906 .2267 L
s
.68914 .22788 m
.68914 .22788 L
s
.68921 .22717 m
.68921 .22717 L
s
.68928 .22788 m
.68928 .22788 L
s
.68936 .22834 m
.68936 .22834 L
s
.68943 .22764 m
.68943 .22764 L
s
.68951 .22576 m
.68951 .22576 L
s
.68958 .22552 m
.68958 .22552 L
s
.68966 .22576 m
.68966 .22576 L
s
.68973 .2267 m
.68973 .2267 L
s
.68981 .22623 m
.68981 .22623 L
s
.68988 .22717 m
.68988 .22717 L
s
.68996 .22905 m
.68996 .22905 L
s
.69003 .23022 m
.69003 .23022 L
s
.6901 .23187 m
.6901 .23187 L
s
.69017 .23327 m
.69017 .23327 L
s
.69025 .23351 m
.69025 .23351 L
s
.69032 .23351 m
.69032 .23351 L
s
.6904 .23539 m
.6904 .23539 L
s
.69047 .23351 m
.69047 .23351 L
s
.69055 .23492 m
.69055 .23492 L
s
.69062 .23492 m
.69062 .23492 L
s
.6907 .23422 m
.6907 .23422 L
s
.69078 .23398 m
.69078 .23398 L
s
.69084 .23234 m
.69084 .23234 L
s
.69092 .23281 m
.69092 .23281 L
s
.69099 .23187 m
.69099 .23187 L
s
.69107 .23234 m
.69107 .23234 L
s
.69114 .23045 m
.69114 .23045 L
s
.69122 .23351 m
.69122 .23351 L
s
.69129 .23327 m
.69129 .23327 L
s
.69137 .23327 m
.69137 .23327 L
s
.69144 .23422 m
.69144 .23422 L
s
.69152 .23422 m
.69152 .23422 L
s
.69159 .23304 m
.69159 .23304 L
s
.69166 .23398 m
.69166 .23398 L
s
.69173 .23492 m
.69173 .23492 L
s
.69181 .23563 m
.69181 .23563 L
s
.69188 .23656 m
.69188 .23656 L
s
.69196 .23633 m
.69196 .23633 L
s
.69203 .23609 m
.69203 .23609 L
s
.69211 .23539 m
.69211 .23539 L
s
.69218 .23492 m
.69218 .23492 L
s
.69226 .23633 m
.69226 .23633 L
s
.69234 .23563 m
.69234 .23563 L
s
.69241 .23422 m
.69241 .23422 L
s
.69248 .23304 m
.69248 .23304 L
s
.69255 .23398 m
.69255 .23398 L
s
.69263 .23351 m
.69263 .23351 L
s
.6927 .23539 m
.6927 .23539 L
s
.69278 .23374 m
.69278 .23374 L
s
.69285 .23539 m
.69285 .23539 L
s
.69293 .23492 m
.69293 .23492 L
s
.693 .23539 m
.693 .23539 L
s
.69308 .23539 m
.69308 .23539 L
s
.69315 .23469 m
.69315 .23469 L
s
.69322 .23469 m
.69322 .23469 L
s
.69329 .23327 m
.69329 .23327 L
s
.69337 .23516 m
.69337 .23516 L
s
.69344 .23398 m
.69344 .23398 L
s
.69352 .23422 m
.69352 .23422 L
s
.69359 .23492 m
.69359 .23492 L
s
.69367 .23516 m
.69367 .23516 L
s
.69374 .23398 m
.69374 .23398 L
s
.69382 .23351 m
.69382 .23351 L
s
.6939 .23703 m
.6939 .23703 L
s
.69397 .23656 m
.69397 .23656 L
s
.69404 .23798 m
.69404 .23798 L
s
.69411 .23609 m
.69411 .23609 L
s
.69419 .23633 m
.69419 .23633 L
s
.69426 .23492 m
.69426 .23492 L
s
.69434 .23586 m
.69434 .23586 L
s
.69441 .23469 m
.69441 .23469 L
s
.69449 .23374 m
.69449 .23374 L
s
.69456 .23304 m
.69456 .23304 L
s
.69463 .23304 m
.69463 .23304 L
s
.69471 .23187 m
.69471 .23187 L
s
.69479 .2314 m
.69479 .2314 L
s
.69486 .23281 m
.69486 .23281 L
s
.69493 .23234 m
.69493 .23234 L
s
.695 .23304 m
.695 .23304 L
s
.69508 .2307 m
.69508 .2307 L
s
.69515 .22811 m
.69515 .22811 L
s
.69523 .22693 m
.69523 .22693 L
s
.6953 .22764 m
.6953 .22764 L
s
.69538 .22552 m
.69538 .22552 L
s
.69545 .22599 m
.69545 .22599 L
s
.69553 .22506 m
.69553 .22506 L
s
.69561 .22412 m
.69561 .22412 L
s
.69567 .22294 m
.69567 .22294 L
s
.69575 .22106 m
.69575 .22106 L
s
.69582 .22224 m
.69582 .22224 L
s
.6959 .22083 m
.6959 .22083 L
s
.69597 .2213 m
.69597 .2213 L
s
.69605 .22036 m
.69605 .22036 L
s
.69612 .222 m
.69612 .222 L
s
.69619 .222 m
.69619 .222 L
s
.69626 .22317 m
.69626 .22317 L
s
.69634 .22364 m
.69634 .22364 L
s
.69642 .22271 m
.69642 .22271 L
s
.69649 .22459 m
.69649 .22459 L
s
.69656 .22459 m
.69656 .22459 L
s
.69664 .22552 m
.69664 .22552 L
s
.69671 .22506 m
.69671 .22506 L
s
.69679 .22741 m
.69679 .22741 L
s
.69686 .22834 m
.69686 .22834 L
s
.69694 .23093 m
.69694 .23093 L
s
.69701 .23163 m
.69701 .23163 L
s
.69708 .2321 m
.69708 .2321 L
s
.69716 .2321 m
.69716 .2321 L
s
.69724 .22975 m
.69724 .22975 L
s
.69731 .23045 m
.69731 .23045 L
s
.69738 .2307 m
.69738 .2307 L
s
.69746 .23163 m
.69746 .23163 L
s
.69753 .2321 m
.69753 .2321 L
s
.69761 .23327 m
.69761 .23327 L
s
.69768 .23163 m
.69768 .23163 L
s
.69776 .2321 m
.69776 .2321 L
s
.69783 .23163 m
.69783 .23163 L
s
.6979 .23163 m
.6979 .23163 L
s
.69797 .2314 m
.69797 .2314 L
s
.69805 .22952 m
.69805 .22952 L
s
.69812 .23045 m
.69812 .23045 L
s
.6982 .22858 m
.6982 .22858 L
s
.69827 .2267 m
.69827 .2267 L
s
.69835 .22529 m
.69835 .22529 L
s
.69842 .22623 m
.69842 .22623 L
s
.6985 .22552 m
.6985 .22552 L
s
.69858 .22623 m
.69858 .22623 L
s
.69864 .22741 m
.69864 .22741 L
s
.69872 .22623 m
.69872 .22623 L
s
.69879 .22717 m
.69879 .22717 L
s
.69887 .22529 m
.69887 .22529 L
s
.69894 .22459 m
.69894 .22459 L
s
.69902 .22294 m
.69902 .22294 L
s
.69909 .22435 m
.69909 .22435 L
s
.69917 .22364 m
.69917 .22364 L
s
.69924 .22412 m
.69924 .22412 L
s
.69932 .22364 m
.69932 .22364 L
s
.69939 .22364 m
.69939 .22364 L
s
.69946 .22294 m
.69946 .22294 L
s
.69953 .22388 m
.69953 .22388 L
s
.69961 .22435 m
.69961 .22435 L
s
.69968 .22388 m
.69968 .22388 L
s
.69976 .22412 m
.69976 .22412 L
s
.69983 .22294 m
.69983 .22294 L
s
.69991 .22412 m
.69991 .22412 L
s
.69998 .222 m
.69998 .222 L
s
.70006 .22224 m
.70006 .22224 L
s
.70014 .22271 m
.70014 .22271 L
s
.70021 .22599 m
.70021 .22599 L
s
.70028 .22482 m
.70028 .22482 L
s
.70035 .22552 m
.70035 .22552 L
s
.70043 .22552 m
.70043 .22552 L
s
.7005 .22529 m
.7005 .22529 L
s
.70058 .22764 m
.70058 .22764 L
s
.70065 .22693 m
.70065 .22693 L
s
.70073 .22834 m
.70073 .22834 L
s
.7008 .22811 m
.7008 .22811 L
s
.70088 .22858 m
.70088 .22858 L
s
.70095 .22834 m
.70095 .22834 L
s
.70103 .22764 m
.70103 .22764 L
s
.70109 .22858 m
.70109 .22858 L
s
.70117 .22834 m
.70117 .22834 L
s
.70124 .22952 m
.70124 .22952 L
s
.70132 .22858 m
.70132 .22858 L
s
.70139 .22811 m
.70139 .22811 L
s
.70147 .22741 m
.70147 .22741 L
s
.70154 .22952 m
.70154 .22952 L
s
.70162 .22975 m
.70162 .22975 L
s
.7017 .22975 m
.7017 .22975 L
s
.70177 .22928 m
.70177 .22928 L
s
.70184 .22952 m
.70184 .22952 L
s
.70191 .22999 m
.70191 .22999 L
s
.70199 .22952 m
.70199 .22952 L
s
.70206 .23022 m
.70206 .23022 L
s
.70214 .22905 m
.70214 .22905 L
s
.70221 .22905 m
.70221 .22905 L
s
.70229 .22834 m
.70229 .22834 L
s
.70236 .23022 m
.70236 .23022 L
s
.70244 .22905 m
.70244 .22905 L
s
.70251 .2307 m
.70251 .2307 L
s
.70259 .23022 m
.70259 .23022 L
s
.70266 .22975 m
.70266 .22975 L
s
.70273 .22834 m
.70273 .22834 L
s
.7028 .22693 m
.7028 .22693 L
s
.70288 .22693 m
.70288 .22693 L
s
.70295 .22529 m
.70295 .22529 L
s
.70303 .2267 m
.70303 .2267 L
s
.7031 .22459 m
.7031 .22459 L
s
.70318 .22412 m
.70318 .22412 L
s
.70325 .22364 m
.70325 .22364 L
s
.70333 .22364 m
.70333 .22364 L
s
.70341 .22412 m
.70341 .22412 L
s
.70347 .22317 m
.70347 .22317 L
s
.70355 .22271 m
.70355 .22271 L
s
.70362 .22177 m
.70362 .22177 L
s
.7037 .22294 m
.7037 .22294 L
s
.70377 .22271 m
.70377 .22271 L
s
.70385 .222 m
.70385 .222 L
s
.70392 .22317 m
.70392 .22317 L
s
.704 .22435 m
.704 .22435 L
s
.70407 .22224 m
.70407 .22224 L
s
.70415 .2213 m
.70415 .2213 L
s
.70422 .22083 m
.70422 .22083 L
s
.70429 .22177 m
.70429 .22177 L
s
.70436 .2213 m
.70436 .2213 L
s
.70444 .22177 m
.70444 .22177 L
s
.70451 .22247 m
.70451 .22247 L
s
.70459 .22294 m
.70459 .22294 L
s
.70466 .22482 m
.70466 .22482 L
s
.70474 .22294 m
.70474 .22294 L
s
.70481 .22317 m
.70481 .22317 L
s
.70488 .22506 m
.70488 .22506 L
s
.70496 .22599 m
.70496 .22599 L
s
.70504 .22459 m
.70504 .22459 L
s
.70511 .22341 m
.70511 .22341 L
s
.70518 .22294 m
.70518 .22294 L
s
.70526 .22224 m
.70526 .22224 L
s
.70533 .22224 m
.70533 .22224 L
s
.70541 .22083 m
.70541 .22083 L
s
.70548 .22177 m
.70548 .22177 L
s
.70556 .22012 m
.70556 .22012 L
s
.70563 .2213 m
.70563 .2213 L
s
.7057 .22153 m
.7057 .22153 L
s
.70578 .22177 m
.70578 .22177 L
s
.70586 .222 m
.70586 .222 L
s
.70592 .22317 m
.70592 .22317 L
s
.706 .22294 m
.706 .22294 L
s
.70607 .22247 m
.70607 .22247 L
s
.70615 .22364 m
.70615 .22364 L
s
.70622 .22341 m
.70622 .22341 L
s
.7063 .22388 m
.7063 .22388 L
s
.70638 .22083 m
.70638 .22083 L
s
.70644 .22294 m
.70644 .22294 L
s
.70652 .22271 m
.70652 .22271 L
s
.70659 .22317 m
.70659 .22317 L
s
.70667 .22224 m
.70667 .22224 L
s
.70674 .2213 m
.70674 .2213 L
s
.70682 .2206 m
.70682 .2206 L
s
.70689 .2206 m
.70689 .2206 L
s
.70697 .22106 m
.70697 .22106 L
s
.70704 .222 m
.70704 .222 L
s
.70712 .22506 m
.70712 .22506 L
s
.70719 .22341 m
.70719 .22341 L
s
.70726 .22271 m
.70726 .22271 L
s
.70733 .22271 m
.70733 .22271 L
s
.70741 .22247 m
.70741 .22247 L
s
.70749 .2213 m
.70749 .2213 L
s
.70756 .21895 m
.70756 .21895 L
s
.70763 .21871 m
.70763 .21871 L
s
.70771 .21566 m
.70771 .21566 L
s
.70778 .21801 m
.70778 .21801 L
s
.70786 .21613 m
.70786 .21613 L
s
.70794 .21778 m
.70794 .21778 L
s
.70801 .21707 m
.70801 .21707 L
s
.70808 .2166 m
.70808 .2166 L
s
.70815 .2166 m
.70815 .2166 L
s
.70823 .21636 m
.70823 .21636 L
s
.7083 .21496 m
.7083 .21496 L
s
.70838 .21472 m
.70838 .21472 L
s
.70845 .21472 m
.70845 .21472 L
s
.70853 .21496 m
.70853 .21496 L
s
.7086 .21519 m
.7086 .21519 L
s
.70868 .21449 m
.70868 .21449 L
s
.70875 .21496 m
.70875 .21496 L
s
.70883 .21496 m
.70883 .21496 L
s
.70889 .21519 m
.70889 .21519 L
s
.70897 .21754 m
.70897 .21754 L
s
.70904 .21589 m
.70904 .21589 L
s
.70912 .21636 m
.70912 .21636 L
s
.70919 .21707 m
.70919 .21707 L
s
.70927 .21731 m
.70927 .21731 L
s
.70934 .21683 m
.70934 .21683 L
s
.70942 .21754 m
.70942 .21754 L
s
.7095 .21683 m
.7095 .21683 L
s
.70957 .21731 m
.70957 .21731 L
s
.70964 .21707 m
.70964 .21707 L
s
.70971 .21754 m
.70971 .21754 L
s
.70979 .21801 m
.70979 .21801 L
s
.70986 .21707 m
.70986 .21707 L
s
.70994 .21824 m
.70994 .21824 L
s
.71001 .21918 m
.71001 .21918 L
s
.71009 .21871 m
.71009 .21871 L
s
.71016 .21801 m
.71016 .21801 L
s
.71024 .21942 m
.71024 .21942 L
s
.71031 .21918 m
.71031 .21918 L
s
.71039 .21965 m
.71039 .21965 L
s
.71046 .21918 m
.71046 .21918 L
s
.71053 .21824 m
.71053 .21824 L
s
.7106 .21895 m
.7106 .21895 L
s
.71068 .21848 m
.71068 .21848 L
s
.71075 .21918 m
.71075 .21918 L
s
.71083 .21754 m
.71083 .21754 L
s
.7109 .21754 m
.7109 .21754 L
s
.71098 .21778 m
.71098 .21778 L
s
.71105 .21942 m
.71105 .21942 L
s
.71113 .21918 m
.71113 .21918 L
s
.71121 .2213 m
.71121 .2213 L
s
.71127 .22294 m
.71127 .22294 L
s
.71135 .22153 m
.71135 .22153 L
s
.71142 .22083 m
.71142 .22083 L
s
.7115 .2213 m
.7115 .2213 L
s
.71157 .22177 m
.71157 .22177 L
s
.71165 .22106 m
.71165 .22106 L
s
.71172 .22294 m
.71172 .22294 L
s
.7118 .22271 m
.7118 .22271 L
s
.71187 .22364 m
.71187 .22364 L
s
.71195 .22247 m
.71195 .22247 L
s
.71202 .22224 m
.71202 .22224 L
s
.71209 .22106 m
.71209 .22106 L
s
.71216 .2213 m
.71216 .2213 L
s
.71224 .22177 m
.71224 .22177 L
s
.71231 .22294 m
.71231 .22294 L
s
.71239 .22364 m
.71239 .22364 L
s
.71246 .2213 m
.71246 .2213 L
s
.71254 .22294 m
.71254 .22294 L
s
.71261 .22317 m
.71261 .22317 L
s
.71268 .22341 m
.71268 .22341 L
s
.71276 .22435 m
.71276 .22435 L
s
.71284 .22599 m
.71284 .22599 L
s
.71291 .22741 m
.71291 .22741 L
s
.71298 .22788 m
.71298 .22788 L
s
.71306 .2267 m
.71306 .2267 L
s
.71313 .22482 m
.71313 .22482 L
s
.71321 .22576 m
.71321 .22576 L
s
.71328 .22435 m
.71328 .22435 L
s
.71336 .22435 m
.71336 .22435 L
s
.71343 .22529 m
.71343 .22529 L
s
.7135 .22529 m
.7135 .22529 L
s
.71358 .22529 m
.71358 .22529 L
s
.71366 .22529 m
.71366 .22529 L
s
.71372 .22388 m
.71372 .22388 L
s
.7138 .22623 m
.7138 .22623 L
s
.71387 .22693 m
.71387 .22693 L
s
.71395 .2267 m
.71395 .2267 L
s
.71402 .22576 m
.71402 .22576 L
s
.7141 .22552 m
.7141 .22552 L
s
.71418 .2267 m
.71418 .2267 L
s
.71424 .22599 m
.71424 .22599 L
s
.71432 .22693 m
.71432 .22693 L
s
.71439 .22623 m
.71439 .22623 L
s
.71447 .22599 m
.71447 .22599 L
s
.71454 .22412 m
.71454 .22412 L
s
.71462 .22459 m
.71462 .22459 L
s
.71469 .22435 m
.71469 .22435 L
s
.71477 .22388 m
.71477 .22388 L
s
.71484 .22317 m
.71484 .22317 L
s
.71492 .22271 m
.71492 .22271 L
s
.71499 .22224 m
.71499 .22224 L
s
.71506 .22247 m
.71506 .22247 L
s
.71513 .22341 m
.71513 .22341 L
s
.71521 .22177 m
.71521 .22177 L
s
.71529 .22271 m
.71529 .22271 L
s
.71536 .22224 m
.71536 .22224 L
s
.71543 .22177 m
.71543 .22177 L
s
.71551 .22153 m
.71551 .22153 L
s
.71558 .22106 m
.71558 .22106 L
s
.71566 .22177 m
.71566 .22177 L
s
.71574 .22036 m
.71574 .22036 L
s
.71581 .2206 m
.71581 .2206 L
s
.71588 .2166 m
.71588 .2166 L
s
.71595 .21778 m
.71595 .21778 L
s
.71603 .21942 m
.71603 .21942 L
s
.7161 .21942 m
.7161 .21942 L
s
.71618 .21754 m
.71618 .21754 L
s
.71625 .21848 m
.71625 .21848 L
s
.71633 .21801 m
.71633 .21801 L
s
.7164 .21683 m
.7164 .21683 L
s
.71648 .21542 m
.71648 .21542 L
s
.71655 .21542 m
.71655 .21542 L
s
.71663 .21472 m
.71663 .21472 L
s
.71669 .21284 m
.71669 .21284 L
s
.71677 .21378 m
.71677 .21378 L
s
.71684 .21284 m
.71684 .21284 L
s
.71692 .21378 m
.71692 .21378 L
s
.71699 .21284 m
.71699 .21284 L
s
.71707 .21355 m
.71707 .21355 L
s
.71714 .21402 m
.71714 .21402 L
s
.71722 .21378 m
.71722 .21378 L
s
.7173 .21613 m
.7173 .21613 L
s
.71737 .21355 m
.71737 .21355 L
s
.71744 .21378 m
.71744 .21378 L
s
.71751 .21496 m
.71751 .21496 L
s
.71759 .21613 m
.71759 .21613 L
s
.71766 .21425 m
.71766 .21425 L
s
.71774 .21378 m
.71774 .21378 L
s
.71781 .21331 m
.71781 .21331 L
s
.71789 .21214 m
.71789 .21214 L
s
.71796 .21143 m
.71796 .21143 L
s
.71804 .21026 m
.71804 .21026 L
s
.71811 .21073 m
.71811 .21073 L
s
.71819 .20885 m
.71819 .20885 L
s
.71826 .20885 m
.71826 .20885 L
s
.71833 .20744 m
.71833 .20744 L
s
.7184 .20697 m
.7184 .20697 L
s
.71848 .2065 m
.71848 .2065 L
s
.71855 .20556 m
.71855 .20556 L
s
.71863 .20674 m
.71863 .20674 L
s
.7187 .20697 m
.7187 .20697 L
s
.71878 .20791 m
.71878 .20791 L
s
.71886 .20556 m
.71886 .20556 L
s
.71893 .20674 m
.71893 .20674 L
s
.71901 .20744 m
.71901 .20744 L
s
.71907 .20814 m
.71907 .20814 L
s
.71915 .2065 m
.71915 .2065 L
s
.71922 .20791 m
.71922 .20791 L
s
.7193 .20626 m
.7193 .20626 L
s
.71937 .20768 m
.71937 .20768 L
s
.71945 .20768 m
.71945 .20768 L
s
.71952 .20861 m
.71952 .20861 L
s
.7196 .20908 m
.7196 .20908 L
s
.71967 .20744 m
.71967 .20744 L
s
.71975 .21002 m
.71975 .21002 L
s
.71982 .20979 m
.71982 .20979 L
s
.71989 .21073 m
.71989 .21073 L
s
.71996 .2105 m
.71996 .2105 L
s
.72004 .2112 m
.72004 .2112 L
s
.72011 .20979 m
.72011 .20979 L
s
.72019 .20885 m
.72019 .20885 L
s
.72026 .20955 m
.72026 .20955 L
s
.72034 .20885 m
.72034 .20885 L
s
.72041 .20932 m
.72041 .20932 L
s
.72049 .20768 m
.72049 .20768 L
s
.72057 .20932 m
.72057 .20932 L
s
.72064 .20908 m
.72064 .20908 L
s
.72071 .21026 m
.72071 .21026 L
s
.72078 .20979 m
.72078 .20979 L
s
.72086 .21073 m
.72086 .21073 L
s
.72093 .21002 m
.72093 .21002 L
s
.72101 .21002 m
.72101 .21002 L
s
.72108 .20791 m
.72108 .20791 L
s
.72116 .20744 m
.72116 .20744 L
s
.72123 .20861 m
.72123 .20861 L
s
.7213 .20791 m
.7213 .20791 L
s
.72138 .20838 m
.72138 .20838 L
s
.72146 .20885 m
.72146 .20885 L
s
.72152 .2112 m
.72152 .2112 L
s
.7216 .20814 m
.7216 .20814 L
s
.72167 .20885 m
.72167 .20885 L
s
.72175 .21026 m
.72175 .21026 L
s
.72182 .21096 m
.72182 .21096 L
s
.7219 .21026 m
.7219 .21026 L
s
.72198 .20768 m
.72198 .20768 L
s
.72204 .20885 m
.72204 .20885 L
s
.72212 .20955 m
.72212 .20955 L
s
.7222 .20908 m
.7222 .20908 L
s
.72227 .20955 m
.72227 .20955 L
s
.72234 .21167 m
.72234 .21167 L
s
.72242 .20932 m
.72242 .20932 L
s
.72249 .20932 m
.72249 .20932 L
s
.72257 .20979 m
.72257 .20979 L
s
.72264 .21143 m
.72264 .21143 L
s
.72272 .2119 m
.72272 .2119 L
s
.72279 .21073 m
.72279 .21073 L
s
.72286 .21214 m
.72286 .21214 L
s
.72293 .21331 m
.72293 .21331 L
s
.72301 .21496 m
.72301 .21496 L
s
.72309 .21519 m
.72309 .21519 L
s
.72316 .21425 m
.72316 .21425 L
s
.72323 .21472 m
.72323 .21472 L
s
.72331 .21542 m
.72331 .21542 L
s
.72338 .21472 m
.72338 .21472 L
s
.72346 .21331 m
.72346 .21331 L
s
.72354 .21331 m
.72354 .21331 L
s
.72361 .21331 m
.72361 .21331 L
s
.72368 .21378 m
.72368 .21378 L
s
.72375 .21355 m
.72375 .21355 L
s
.72383 .21237 m
.72383 .21237 L
s
.7239 .21237 m
.7239 .21237 L
s
.72398 .2119 m
.72398 .2119 L
s
.72405 .21143 m
.72405 .21143 L
s
.72413 .21378 m
.72413 .21378 L
s
.7242 .2119 m
.7242 .2119 L
s
.72428 .21261 m
.72428 .21261 L
s
.72435 .21378 m
.72435 .21378 L
s
.72443 .21378 m
.72443 .21378 L
s
.72449 .21402 m
.72449 .21402 L
s
.72457 .21307 m
.72457 .21307 L
s
.72464 .21542 m
.72464 .21542 L
s
.72472 .21566 m
.72472 .21566 L
s
.72479 .21496 m
.72479 .21496 L
s
.72487 .21307 m
.72487 .21307 L
s
.72494 .21378 m
.72494 .21378 L
s
.72502 .21378 m
.72502 .21378 L
s
.7251 .21425 m
.7251 .21425 L
s
.72517 .21425 m
.72517 .21425 L
s
.72524 .21355 m
.72524 .21355 L
s
.72531 .21519 m
.72531 .21519 L
s
.72539 .21284 m
.72539 .21284 L
s
.72546 .21378 m
.72546 .21378 L
s
.72554 .21307 m
.72554 .21307 L
s
.72561 .21237 m
.72561 .21237 L
s
.72569 .21284 m
.72569 .21284 L
s
.72576 .21237 m
.72576 .21237 L
s
.72584 .21378 m
.72584 .21378 L
s
.72591 .21331 m
.72591 .21331 L
s
.72599 .21237 m
.72599 .21237 L
s
.72606 .21096 m
.72606 .21096 L
s
.72613 .2119 m
.72613 .2119 L
s
.7262 .21096 m
.7262 .21096 L
s
.72628 .21237 m
.72628 .21237 L
s
.72635 .21214 m
.72635 .21214 L
s
.72643 .21284 m
.72643 .21284 L
s
.7265 .21237 m
.7265 .21237 L
s
.72658 .21237 m
.72658 .21237 L
s
.72666 .21167 m
.72666 .21167 L
s
.72673 .21096 m
.72673 .21096 L
s
.72681 .21096 m
.72681 .21096 L
s
.72687 .20955 m
.72687 .20955 L
s
.72695 .20885 m
.72695 .20885 L
s
.72702 .20838 m
.72702 .20838 L
s
.7271 .20908 m
.7271 .20908 L
s
.72717 .20579 m
.72717 .20579 L
s
.72725 .20674 m
.72725 .20674 L
s
.72732 .20486 m
.72732 .20486 L
s
.7274 .2065 m
.7274 .2065 L
s
.72747 .20579 m
.72747 .20579 L
s
.72755 .20579 m
.72755 .20579 L
s
.72762 .20768 m
.72762 .20768 L
s
.72769 .20814 m
.72769 .20814 L
s
.72776 .20814 m
.72776 .20814 L
s
.72784 .20674 m
.72784 .20674 L
s
.72791 .20697 m
.72791 .20697 L
s
.72799 .20486 m
.72799 .20486 L
s
.72806 .20345 m
.72806 .20345 L
s
.72814 .20392 m
.72814 .20392 L
s
.72821 .20439 m
.72821 .20439 L
s
.72829 .20626 m
.72829 .20626 L
s
.72837 .20674 m
.72837 .20674 L
s
.72844 .20908 m
.72844 .20908 L
s
.72851 .20814 m
.72851 .20814 L
s
.72858 .20861 m
.72858 .20861 L
s
.72866 .20721 m
.72866 .20721 L
s
.72873 .20885 m
.72873 .20885 L
s
.72881 .20838 m
.72881 .20838 L
s
.72888 .20885 m
.72888 .20885 L
s
.72896 .20861 m
.72896 .20861 L
s
.72903 .20932 m
.72903 .20932 L
s
.72911 .20908 m
.72911 .20908 L
s
.72918 .20979 m
.72918 .20979 L
s
.72926 .2105 m
.72926 .2105 L
s
.72932 .20814 m
.72932 .20814 L
s
.7294 .20979 m
.7294 .20979 L
s
.72947 .20838 m
.72947 .20838 L
s
.72955 .20979 m
.72955 .20979 L
s
.72962 .20955 m
.72962 .20955 L
s
.7297 .21002