(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    186546,       4685]*)
(*NotebookOutlinePosition[    189683,       4780]*)
(*  CellTagsIndexPosition[    189202,       4760]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["NDSolve`StateData", "Chapter"],

Cell[CellGroupData[{

Cell["Creating NDSolve`StateData Objects", "Section",
  CellTags->"c:1"],

Cell[CellGroupData[{

Cell["ProcessEquations", "Subsection",
  CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"}],

Cell[TextData[{
  "The first stage of any solution using ",
  StyleBox["NDSolve", "MR"],
  " is processing the equations specified into a form that can be efficiently \
accessed by the actual integration algorithms. This stage minimally involves \
determining the differential order of each variable, making substitutions \
needed to get a first-order system, solving for the time derivatives of the \
functions in terms of the functions, and forming the result into a ",
  StyleBox["NumericalFunction", "MR"],
  " object. If you want to save the time of repeating this process for the \
same set of equations or if you want more control over the numerical \
integration process, the processing stage can be executed separately with ",
  StyleBox["NDSolve`ProcessEquations", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NDSolve`ProcessEquations",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["eqn",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox[
                          FormBox["eqn",
                            "TextForm"],
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], 
                        StyleBox["1",
                          FontWeight->"Plain",
                          FontSlant->"Plain",
                          FontTracking->"Plain",
                          FontVariations->{"Underline"->False,
                          "Outline"->False,
                          "Shadow"->False,
                          "StrikeThrough"->False,
                          "Masked"->False,
                          "CompatibilityType"->0,
                          "RotationAngle"->0}]], ",", " ", 
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], 
                        StyleBox["2",
                          FontWeight->"Plain",
                          FontSlant->"Plain",
                          FontTracking->"Plain",
                          FontVariations->{"Underline"->False,
                          "Outline"->False,
                          "Shadow"->False,
                          "StrikeThrough"->False,
                          "Masked"->False,
                          "CompatibilityType"->0,
                          "RotationAngle"->0}]], ",", " ", "..."}], "}"}],
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["t",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR",
                FontSlant->"Italic"]}], Cell[TextData[{
              "process the differential equations ",
              Cell[BoxData[
                  StyleBox[
                    RowBox[{"{", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["eqn",
                            "MR",
                            FontSlant->"Italic"], "1"], ",", " ", 
                        SubscriptBox[
                          StyleBox[
                            FormBox["eqn",
                              "TextForm"],
                            "MR",
                            FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                      "}"}],
                    "MR"]]],
              "for the functions ",
              Cell[BoxData[
                  StyleBox[
                    RowBox[{"{", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["u",
                            "MR",
                            FontSlant->"Italic"], 
                          StyleBox["1",
                            FontWeight->"Plain",
                            FontSlant->"Plain",
                            FontTracking->"Plain",
                            FontVariations->{"Underline"->False,
                            "Outline"->False,
                            "Shadow"->False,
                            "StrikeThrough"->False,
                            "Masked"->False,
                            "CompatibilityType"->0,
                            "RotationAngle"->0}]], ",", " ", 
                        SubscriptBox[
                          StyleBox["u",
                            "MR",
                            FontSlant->"Italic"], 
                          StyleBox["2",
                            FontWeight->"Plain",
                            FontSlant->"Plain",
                            FontTracking->"Plain",
                            FontVariations->{"Underline"->False,
                            "Outline"->False,
                            "Shadow"->False,
                            "StrikeThrough"->False,
                            "Masked"->False,
                            "CompatibilityType"->0,
                            "RotationAngle"->0}]], ",", " ", "..."}], "}"}],
                    "MR",
                    FontSlant->"Italic"]]],
              "into a normal form; return a list of ",
              StyleBox["NDSolve`StateData", "MR"],
              
              " objects containing the solution and data associated with each \
solution for the time derivatives of the functions in terms of the functions; \
",
              StyleBox["t", "TI"],
              " may be specified in a list with a range of values as in ",
              StyleBox["NDSolve", "MR"]
            }], "Text"]},
          {
            RowBox[{
              StyleBox["NDSolve`ProcessEquations",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["eqn",
                          "MR",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox[
                          FormBox["eqn",
                            "TextForm"],
                          "MR",
                          FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                    "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], 
                        StyleBox["1",
                          FontWeight->"Plain",
                          FontSlant->"Plain",
                          FontTracking->"Plain",
                          FontVariations->{"Underline"->False,
                          "Outline"->False,
                          "Shadow"->False,
                          "StrikeThrough"->False,
                          "Masked"->False,
                          "CompatibilityType"->0,
                          "RotationAngle"->0}]], ",", " ", 
                      SubscriptBox[
                        StyleBox["u",
                          "MR",
                          FontSlant->"Italic"], 
                        StyleBox["2",
                          FontWeight->"Plain",
                          FontSlant->"Plain",
                          FontTracking->"Plain",
                          FontVariations->{"Underline"->False,
                          "Outline"->False,
                          "Shadow"->False,
                          "StrikeThrough"->False,
                          "Masked"->False,
                          "CompatibilityType"->0,
                          "RotationAngle"->0}]], ",", " ", "..."}], "}"}],
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["x",
                        "MR",
                        FontSlant->"Italic"], "1"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          "MR",
                          FontSlant->"Italic"], "1"], 
                      StyleBox["min",
                        "MR",
                        FontSlant->"Italic"]}], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          "MR",
                          FontSlant->"Italic"], "1"], 
                      StyleBox["max",
                        "MR",
                        FontSlant->"Italic"]}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                RowBox[{
                  StyleBox["{",
                    "MR"], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["x",
                        "MR",
                        FontSlant->"Italic"], "2"], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          "MR",
                          FontSlant->"Italic"], "2"], 
                      StyleBox["min",
                        "MR",
                        FontSlant->"Italic"]}], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          "MR",
                          FontSlant->"Italic"], "2"], 
                      StyleBox["max",
                        "MR",
                        FontSlant->"Italic"]}]}], 
                  StyleBox["}",
                    "MR",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  "MR",
                  FontSlant->"Italic"], 
                StyleBox["...",
                  "MR",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR",
                FontSlant->"Italic"]}], Cell[TextData[{
              "process the partial differential equations ",
              Cell[BoxData[
                  StyleBox[
                    RowBox[{"{", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["eqn",
                            "MR",
                            FontSlant->"Italic"], "1"], ",", " ", 
                        SubscriptBox[
                          StyleBox[
                            FormBox["eqn",
                              "TextForm"],
                            "MR",
                            FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                      "}"}],
                    "MR"]]],
              "for the functions ",
              Cell[BoxData[
                  StyleBox[
                    RowBox[{"{", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["u",
                            "MR",
                            FontSlant->"Italic"], "1"], ",", " ", 
                        SubscriptBox[
                          StyleBox["u",
                            "MR",
                            FontSlant->"Italic"], "2"], ",", " ", "..."}], 
                      "}"}],
                    "MR",
                    FontSlant->"Italic"]]],
              "into a normal form; return a list of ",
              StyleBox["NDSolve`StateData", "MR"],
              
              " objects containing the solution and data associated with each \
solution for the time derivatives of the functions in terms of the functions; \
if ",
              Cell[BoxData[
                  \(TraditionalForm\`x\_j\)]],
              
              " is the temporal variable, it need not be specified with the \
boundaries ",
              Cell[BoxData[
                  RowBox[{
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          "MR",
                          FontSlant->"Italic"], "j"], 
                      StyleBox["min",
                        "MR",
                        FontSlant->"Italic"]}], 
                    StyleBox[",",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          "MR",
                          FontSlant->"Italic"], "j"], 
                      StyleBox["max",
                        "MR",
                        FontSlant->"Italic"]}]}]]]
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Processing equations for ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Caption"],

Cell[TextData[{
  "This creates a list of two ",
  StyleBox["NDSolve`StateData", "MR"],
  " objects because there are two possible solutions for the ",
  StyleBox["y",
    FontSlant->"Italic"],
  "' in terms of ",
  StyleBox["y",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`ProcessEquations[{\(y'\)[x]^2\  \[Equal] \ y[x]\  + \ x, \ 
        y[0]\  \[Equal] \ 1}, y, x]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"NDSolve`StateData", "[", 
            
            InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
              
              SequenceForm[ "<", 0.0, ">"],
              Editable->False], "]"}],
          False,
          Editable->False], ",", 
        TagBox[
          RowBox[{"NDSolve`StateData", "[", 
            
            InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
              
              SequenceForm[ "<", 0.0, ">"],
              Editable->False], "]"}],
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[1]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reinitialize", "Subsection",
  CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"}],

Cell["\<\
It is not uncommon that the solution to a more sophisticated \
problem involves solving the same differential equation repeatedly, but with \
different initial conditions. In some cases, processing equations may be as \
time-consuming as numerically integrating the differential equations. In \
these situations, it is a significant advantage to be able to simply give new \
initial values.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NDSolve`Reinitialize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["state",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["conditions",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "assuming the equations and variables are the same as the ones \
used to create the ",
              StyleBox["NDSolve`StateData", "MR"],
              " object state, form a list of new ",
              StyleBox["NDSolve`StateData", "MR"],
              
              " objects, one for each of the possible solutions for the \
initial values of the functions of the equations ",
              StyleBox["conditions", "TI"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["Reusing processed equations.", "Caption"],

Cell[TextData[{
  "This creates an ",
  StyleBox["NDSolve`StateData", "MR"],
  " object for the harmonic oscillator."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(state\  = \ 
      First[NDSolve`ProcessEquations[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ 
            x[0]\  \[Equal] \ 0, \ \(x'\)[0]\  \[Equal] \ 1}, x, 
          t]]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"NDSolve`StateData", "[", 
        InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
          SequenceForm[ "<", 0.0, ">"],
          Editable->False], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  "This creates three new ",
  StyleBox["NDSolve`StateData", "MR"],
  " objects, each with a different initial condition."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newstate\  = \ 
      NDSolve`Reinitialize[
        state, \ {x[1]^3\  \[Equal] \ 1, \ \(x'\)[1]\  \[Equal] \ 
            0}]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          RowBox[{"NDSolve`StateData", "[", 
            
            InterpretationBox[\("<"\[InvisibleSpace]1.`\[InvisibleSpace]">"\),
              
              SequenceForm[ "<", 1.0, ">"],
              Editable->False], "]"}],
          False,
          Editable->False], ",", 
        TagBox[
          RowBox[{"NDSolve`StateData", "[", 
            
            InterpretationBox[\("<"\[InvisibleSpace]1.`\[InvisibleSpace]">"\),
              
              SequenceForm[ "<", 1.0, ">"],
              Editable->False], "]"}],
          False,
          Editable->False], ",", 
        TagBox[
          RowBox[{"NDSolve`StateData", "[", 
            
            InterpretationBox[\("<"\[InvisibleSpace]1.`\[InvisibleSpace]">"\),
              
              SequenceForm[ "<", 1.0, ">"],
              Editable->False], "]"}],
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["NDSolve`Reinitialize", "MR"],
  " may save computation time when you need to solve the same differential \
equation for many different initial conditions, as you might in a shooting \
method for boundary value problems."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iterating Solutions", "Section",
  CellTags->{"c:4", "b:13", "ndsg:5.1"}],

Cell[TextData[{
  "One important use of ",
  StyleBox["NDSolve`StateData", "MR"],
  " objects is to have more control of the integration. For some problems, it \
is appropriate to check the solution and start over or change parameters \
depending on certain conditions."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NDSolve`Iterate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(state, \ t\),
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "compute the solution of the differential equation in a ",
              StyleBox["NDSolve`StateData", "MR"],
              " object that has been assigned as the value of the variable ",
              StyleBox["state",
                FontSlant->"Italic"],
              " from the current time up to time ",
              StyleBox["t", "MR",
                FontSlant->"Italic"]
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["Iterating solutions to differential equations. ", "Caption"],

Cell[TextData[{
  "This creates an ",
  StyleBox["NDSolve`StateData", "MR"],
  " object that contains the information needed to solve the equation for an \
oscillator with a varying coefficient using an explicit Runge-Kutta method."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(state\  = \ 
      First[NDSolve`ProcessEquations[{\(x''\)[
                  t]\  + \ \((1\  + \ 4\ UnitStep[Sin[t]])\) 
                  x[t]\  \[Equal] \ 0, \ 
            x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, x, t, \ 
          Method \[Rule] "\<ExplicitRungeKutta\>"]]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"NDSolve`StateData", "[", 
        InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
          SequenceForm[ "<", 0.0, ">"],
          Editable->False], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "Note that when you use ",
  StyleBox["NDSolve`ProcessEquations", "MR"],
  ", you do not need to give the range of the ",
  StyleBox["t",
    FontSlant->"Italic"],
  " variable explicitly because that information is not needed to set up the \
equations in a form ready to solve. (For PDEs, you do have to give the ranges \
of all spatial variables, however, since that information is essential for \
determining an appropriate discretization.)"
}], "Text"],

Cell[TextData[{
  "This computes the solution out to time ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = 1."
}], "MathCaption"],

Cell[BoxData[
    \(NDSolve`Iterate[state, \ 1]\)], "Input",
  CellLabel->"In[5]:="],

Cell[TextData[{
  StyleBox["NDSolve`Iterate", "MR"],
  " does not return a value because it modifies the ",
  StyleBox["NDSolve`StateData", "MR"],
  " object assigned to the variable state. Thus, the command affects the \
value of the variable in a manner similar to setting parts of a list, as \
described in ",
  ButtonBox["Section 2.4.2",
    ButtonData:>{"2.4.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  " of ",
  StyleBox["The",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Book",
    FontSlant->"Italic"],
  ". You can see that the value of ",
  StyleBox["state",
    FontSlant->"Italic"],
  " has changed since it now displays the current time to which it is \
integrated."
}], "Text"],

Cell[TextData[{
  "The output form of ",
  StyleBox["state", "Text",
    FontSlant->"Italic"],
  " shows the range of times over which the solution has been integrated."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(state\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"NDSolve`StateData", "[", 
        InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]","\
\[InvisibleSpace]1.`\[InvisibleSpace]">"\),
          SequenceForm[ "<", 0.0, ",", 1.0, ">"],
          Editable->False], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "If you want to integrate further, you can call ",
  StyleBox["NDSolve`Iterate", "MR"],
  " again, but with a larger value for time. "
}], "Text"],

Cell[TextData[{
  "This computes the solution out to time ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = 3."
}], "MathCaption"],

Cell[BoxData[
    \(NDSolve`Iterate[state, \ 3]\)], "Input",
  CellLabel->"In[7]:="],

Cell["\<\
You can specify a time that is earlier than the first current time, \
in which case the integration proceeds backwards with respect to time.\
\>", \
"Text"],

Cell[TextData[{
  "This computes the solution from the initial condition backwards to ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = -",
  StyleBox["Pi/2",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(NDSolve`Iterate[state, \ \(-Pi\)/2]\)], "Input",
  CellLabel->"In[8]:="],

Cell[TextData[{
  StyleBox["NDSolve`Iterate", "MR"],
  StyleBox[" allows you to specify intermediate times at which to stop.", 
    "MathCaption"],
  " ",
  StyleBox["This can be useful, for example, to avoid discontinuities.", 
    "MathCaption"],
  " ",
  StyleBox["Typically, this strategy is more effective with so-called \
one-step methods, such as the explicit Runge-Kutta method used in this \
example.", "MathCaption"],
  " ",
  StyleBox["However, it generally works with the default ", "MathCaption"],
  StyleBox["NDSolve", "MR"],
  StyleBox[" method as well.", "MathCaption"]
}], "Text"],

Cell[TextData[{
  "This computes the solution out to ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = 10\[Pi], making sure that the solution does not have problems with the \
points of discontinuity in the coefficients at ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = \[Pi], 2 \[Pi], ...."
}], "MathCaption"],

Cell[BoxData[
    \(NDSolve`Iterate[state, \[Pi]\ Range[10]]\)], "Input",
  CellLabel->"In[9]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting Solution Functions", "Section",
  CellTags->{"c:5", "b:14", "ndsg:5.2"}],

Cell[TextData[{
  "Once you have integrated a system up to a certain time, typically you want \
to be able to look at the current solution values and to generate an \
approximate function representing the solution computed so far. The command  \
",
  StyleBox["NDSolve`ProcessSolutions", "MR"],
  " allows you to do both."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NDSolve`ProcessSolutions",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["state",
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "give the solutions that have been computed in ",
              StyleBox["state",
                FontSlant->"Italic"],
              " as a list of rules with ",
              StyleBox["InterpolatingFunction", "MR"],
              " objects"
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Getting solutions as ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects. "
}], "Caption"],

Cell[TextData[{
  "This extracts the solution computed in the previous section as an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ NDSolve`ProcessSolutions[state]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"x", "\[Rule]", 
        TagBox[\(InterpolatingFunction[{{\(-1.5707963267948966`\), 
                31.41592653589793`}}, "<>"]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell["This plots the solution.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[
        Evaluate[x[t]\  /. \ sol], {t, \(-Pi\)/2, \ 10\ Pi}];\)\)], "Input",
  CellLabel->"In[11]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.069161 0.0288716 0.283696 0.143385 [
[.21352 .2712 -3 -9 ]
[.21352 .2712 3 0 ]
[.35788 .2712 -6 -9 ]
[.35788 .2712 6 0 ]
[.50224 .2712 -6 -9 ]
[.50224 .2712 6 0 ]
[.64659 .2712 -6 -9 ]
[.64659 .2712 6 0 ]
[.79095 .2712 -6 -9 ]
[.79095 .2712 6 0 ]
[.93531 .2712 -6 -9 ]
[.93531 .2712 6 0 ]
[.05666 .14031 -12 -4.5 ]
[.05666 .14031 0 4.5 ]
[.05666 .42708 -6 -4.5 ]
[.05666 .42708 0 4.5 ]
[.05666 .57047 -6 -4.5 ]
[.05666 .57047 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21352 .2837 m
.21352 .28995 L
s
[(5)] .21352 .2712 0 1 Mshowa
.35788 .2837 m
.35788 .28995 L
s
[(10)] .35788 .2712 0 1 Mshowa
.50224 .2837 m
.50224 .28995 L
s
[(15)] .50224 .2712 0 1 Mshowa
.64659 .2837 m
.64659 .28995 L
s
[(20)] .64659 .2712 0 1 Mshowa
.79095 .2837 m
.79095 .28995 L
s
[(25)] .79095 .2712 0 1 Mshowa
.93531 .2837 m
.93531 .28995 L
s
[(30)] .93531 .2712 0 1 Mshowa
.125 Mabswid
.09803 .2837 m
.09803 .28745 L
s
.1269 .2837 m
.1269 .28745 L
s
.15578 .2837 m
.15578 .28745 L
s
.18465 .2837 m
.18465 .28745 L
s
.24239 .2837 m
.24239 .28745 L
s
.27126 .2837 m
.27126 .28745 L
s
.30013 .2837 m
.30013 .28745 L
s
.32901 .2837 m
.32901 .28745 L
s
.38675 .2837 m
.38675 .28745 L
s
.41562 .2837 m
.41562 .28745 L
s
.44449 .2837 m
.44449 .28745 L
s
.47336 .2837 m
.47336 .28745 L
s
.53111 .2837 m
.53111 .28745 L
s
.55998 .2837 m
.55998 .28745 L
s
.58885 .2837 m
.58885 .28745 L
s
.61772 .2837 m
.61772 .28745 L
s
.67547 .2837 m
.67547 .28745 L
s
.70434 .2837 m
.70434 .28745 L
s
.73321 .2837 m
.73321 .28745 L
s
.76208 .2837 m
.76208 .28745 L
s
.81982 .2837 m
.81982 .28745 L
s
.8487 .2837 m
.8487 .28745 L
s
.87757 .2837 m
.87757 .28745 L
s
.90644 .2837 m
.90644 .28745 L
s
.04029 .2837 m
.04029 .28745 L
s
.01142 .2837 m
.01142 .28745 L
s
.96418 .2837 m
.96418 .28745 L
s
.99305 .2837 m
.99305 .28745 L
s
.25 Mabswid
0 .2837 m
1 .2837 L
s
.06916 .14031 m
.07541 .14031 L
s
[(-1)] .05666 .14031 1 0 Mshowa
.06916 .42708 m
.07541 .42708 L
s
[(1)] .05666 .42708 1 0 Mshowa
.06916 .57047 m
.07541 .57047 L
s
[(2)] .05666 .57047 1 0 Mshowa
.125 Mabswid
.06916 .0256 m
.07291 .0256 L
s
.06916 .05428 m
.07291 .05428 L
s
.06916 .08296 m
.07291 .08296 L
s
.06916 .11163 m
.07291 .11163 L
s
.06916 .16899 m
.07291 .16899 L
s
.06916 .19766 m
.07291 .19766 L
s
.06916 .22634 m
.07291 .22634 L
s
.06916 .25502 m
.07291 .25502 L
s
.06916 .31237 m
.07291 .31237 L
s
.06916 .34105 m
.07291 .34105 L
s
.06916 .36973 m
.07291 .36973 L
s
.06916 .3984 m
.07291 .3984 L
s
.06916 .45576 m
.07291 .45576 L
s
.06916 .48443 m
.07291 .48443 L
s
.06916 .51311 m
.07291 .51311 L
s
.06916 .54179 m
.07291 .54179 L
s
.06916 .59914 m
.07291 .59914 L
s
.25 Mabswid
.06916 0 m
.06916 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .2837 m
.03279 .32756 L
.04262 .37063 L
.04758 .38884 L
.05288 .40489 L
.05546 .41123 L
.05789 .41629 L
.06024 .42029 L
.06244 .42322 L
.06371 .42453 L
.06487 .4255 L
.06616 .42631 L
.06687 .42663 L
.06754 .42686 L
.06819 .427 L
.06888 .42707 L
.07013 .42668 L
.07089 .4258 L
.07161 .42451 L
.07225 .42299 L
.07295 .42095 L
.07412 .41663 L
.07541 .41063 L
.078 .39477 L
.08265 .35571 L
.09412 .23288 L
.09913 .18593 L
.10196 .16546 L
.10331 .15764 L
.10458 .15154 L
.10569 .14725 L
.10689 .14375 L
.10754 .14236 L
.10822 .14128 L
.10944 .14035 L
.11071 .14073 L
.1119 .14235 L
.11321 .14549 L
.11394 .14787 L
.1146 .15041 L
.11694 .16213 L
.11948 .17933 L
.12409 .22026 L
.13405 .32786 L
.13933 .37847 L
.1423 .40047 L
.1437 .40882 L
.145 .41524 L
.14622 .42004 L
.14752 .42381 L
Mistroke
.14827 .42533 L
.14897 .42633 L
.15027 .42708 L
.15152 .42642 L
.15268 .42464 L
.15394 .42139 L
.15527 .41653 L
.15764 .40443 L
.15986 .38948 L
.16488 .35039 L
.17569 .26105 L
.18592 .17921 L
.1957 .11301 L
.20122 .0838 L
.20385 .07237 L
.20632 .06325 L
.20855 .05637 L
.2106 .05127 L
.21288 .04698 L
.21407 .04531 L
.21532 .04399 L
.21647 .04319 L
.21769 .04275 L
.21885 .04273 L
.21989 .04305 L
.22113 .04382 L
.22182 .04445 L
.22246 .04516 L
.22488 .04888 L
.22614 .05147 L
.22734 .05433 L
.22957 .06074 L
.2346 .07998 L
.23895 .10161 L
.24368 .12982 L
.25441 .21101 L
.26434 .31742 L
.26896 .36412 L
.27139 .3849 L
.27395 .40292 L
.2762 .41492 L
.27747 .41997 L
.27866 .42349 L
.27975 .42569 L
.28075 .4268 L
.2819 .42703 L
.28298 .42621 L
.28417 .42416 L
.28547 .42053 L
.28684 .41524 L
Mistroke
.28812 .40896 L
.2904 .39472 L
.29286 .37557 L
.30357 .26447 L
.30847 .21323 L
.31116 .18895 L
.31369 .16981 L
.31513 .1608 L
.31669 .1528 L
.31811 .14717 L
.31941 .14345 L
.32064 .14125 L
.32134 .14057 L
.32199 .14032 L
.32331 .14092 L
.32405 .14191 L
.32472 .14322 L
.32597 .14664 L
.32729 .15167 L
.32967 .16413 L
.33222 .18203 L
.33504 .20636 L
.34482 .3104 L
.35425 .41122 L
.36418 .50256 L
.36938 .54075 L
.37213 .55765 L
.37506 .57295 L
.37777 .58442 L
.38023 .59255 L
.38142 .59567 L
.38271 .59846 L
.38392 .60052 L
.38504 .60192 L
.3863 .60292 L
.38749 .60332 L
.38855 .60321 L
.38972 .60259 L
.39098 .60134 L
.39169 .60037 L
.39233 .59933 L
.39474 .59401 L
.39699 .58711 L
.39942 .57759 L
.40382 .55512 L
.40906 .52021 L
.41458 .475 L
.42446 .37795 L
.43398 .27401 L
.43921 .21839 L
Mistroke
.44178 .19442 L
.44416 .17541 L
.44635 .16109 L
.44751 .1549 L
.44876 .1494 L
.45002 .14517 L
.45119 .14238 L
.45188 .14129 L
.45253 .14062 L
.45376 .14037 L
.45481 .14119 L
.45593 .14309 L
.45699 .14585 L
.45794 .14915 L
.46029 .16035 L
.46251 .17463 L
.47137 .25834 L
.48088 .35966 L
.48368 .38405 L
.48633 .40284 L
.48871 .41546 L
.49006 .42063 L
.49131 .42409 L
.49246 .42613 L
.49355 .42701 L
.49474 .42681 L
.49603 .42523 L
.4973 .42227 L
.49794 .42027 L
.49865 .4177 L
.50105 .40596 L
.50366 .3884 L
.50604 .36871 L
.51137 .31522 L
.52098 .21215 L
.53181 .12164 L
.53668 .0879 L
.54204 .05722 L
.54446 .04587 L
.54706 .03554 L
.5493 .02822 L
.55175 .02201 L
.55318 .01925 L
.55451 .01727 L
.55578 .0159 L
.55649 .01536 L
.55713 .01501 L
.55834 .01472 L
.55966 .01493 L
.5609 .01565 L
Mistroke
.56204 .01674 L
.56311 .01815 L
.56426 .02006 L
.56632 .02455 L
.56878 .03161 L
.57102 .03963 L
.57588 .06207 L
.58049 .08909 L
.60043 .25198 L
.6093 .33428 L
.61396 .37598 L
.6165 .39564 L
.61886 .41006 L
.62012 .41607 L
.62127 .42043 L
.62254 .42401 L
.62324 .4254 L
.62389 .42633 L
.62505 .42707 L
.62611 .42674 L
.62727 .42526 L
.62851 .42245 L
.62958 .41896 L
.63073 .41418 L
.63282 .40294 L
.63529 .38558 L
.63755 .36645 L
.64825 .25331 L
.65296 .20533 L
.65547 .18367 L
.65817 .16452 L
.65937 .15759 L
.66065 .15148 L
.66173 .14728 L
.66293 .1438 L
.66404 .1416 L
.66524 .14043 L
.66637 .14046 L
.6674 .14144 L
.66866 .14386 L
.66982 .14728 L
.6711 .1523 L
.67245 .15901 L
.67472 .17332 L
.67722 .193 L
.68805 .30575 L
.6932 .35896 L
.69551 .37947 L
.69797 .39796 L
.69925 .406 L
Mistroke
.70046 .41247 L
.70156 .41737 L
.70273 .4215 L
.70403 .42478 L
.70522 .42698 L
.70792 .43105 L
.70905 .43236 L
.71025 .43352 L
.71139 .43438 L
.71243 .43495 L
.71365 .43538 L
.71434 .4355 L
.71497 .43553 L
.71614 .4354 L
.71738 .435 L
.71867 .43428 L
.71985 .43336 L
.72114 .43206 L
.7225 .43038 L
.7248 .4268 L
.72731 .42185 L
.73298 .40688 L
.73826 .38869 L
.757 .30104 L
.77731 .19934 L
.78271 .17734 L
.78843 .15812 L
.79078 .15159 L
.7933 .14555 L
.79405 .14398 L
.79475 .14257 L
.79538 .1415 L
.79607 .14072 L
.79673 .14035 L
.79742 .14037 L
.79867 .14144 L
.79933 .14255 L
.80003 .14413 L
.80129 .14798 L
.80264 .15355 L
.80412 .16129 L
.80677 .1791 L
.80924 .19969 L
.81882 .30024 L
.82385 .35304 L
.82649 .37715 L
.8293 .39842 L
.83175 .41259 L
.83315 .41861 L
.83446 .42283 L
Mistroke
.83565 .42544 L
.83675 .42676 L
.83802 .42701 L
.83922 .42597 L
.84039 .42378 L
.84144 .4208 L
.84267 .41622 L
.84382 .41081 L
.84809 .38234 L
.85275 .33929 L
.85779 .28483 L
.86237 .23495 L
.86728 .18836 L
.8701 .16742 L
.87267 .15312 L
.87391 .14805 L
.87456 .14587 L
.87526 .14395 L
.87653 .14147 L
.87771 .1404 L
.879 .14061 L
.88019 .14206 L
.88149 .14503 L
.88215 .14706 L
.88287 .14969 L
.88538 .16207 L
.88772 .17634 L
.89877 .25168 L
.90839 .32147 L
.91883 .39224 L
.92362 .42049 L
.92869 .44632 L
.93344 .46598 L
.93779 .47966 L
.94012 .48519 L
.94234 .48923 L
.94355 .49093 L
.94468 .49218 L
.94591 .49319 L
.94723 .49384 L
.94838 .49405 L
.94962 .4939 L
.95079 .49341 L
.95187 .49265 L
.95284 .49171 L
.95391 .49041 L
.95607 .48692 L
.9587 .48114 L
.96109 .47445 L
.96648 .4547 L
Mistroke
.97619 .40468 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o503oool0
0`000000oooo0?ooo`3o0?ooo`X0oooo000D0?ooo`030000003oool0oooo0?l0oooo2P3oool001@0
oooo00<000000?ooo`3oool0o`3oool:0?ooo`00503oool00`000000oooo0?ooo`3o0?ooo`X0oooo
000D0?ooo`030000003oool0oooo08P0oooo0`00001n0?ooo`00503oool00`000000oooo0?ooo`27
0?ooo`80000000<0oooo0000003oool0O@3oool001@0oooo00<000000?ooo`3oool0Q`3oool01000
0000oooo0?ooo`00001n0?ooo`00503oool2000008P0oooo00D000000?ooo`3oool0oooo0000001m
0?ooo`00503oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0N`3oool001@0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo07X0oooo000D0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`1j0?ooo`00503oool00`000000oooo0?ooo`250?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0NP3oool001@0oooo00<000000?ooo`3oool09`3oool3
000005/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1j0?ooo`00503oool00`00
0000oooo0?ooo`0V0?ooo`040000003oool0oooo000005/0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`1i0?ooo`00503oool00`000000oooo0?ooo`0U0?ooo`040000003oool0oooo
0?ooo`800000FP3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07T0oooo000D0?oo
o`8000009P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05L0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`1i0?ooo`00503oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo07P0oooo000D0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
N03oool001@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo05H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1h0?ooo`00503oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0EP3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo07P0oooo000D0?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0N03oool001@0oooo00<000000?ooo`3oool08`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`1h0?ooo`00503oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo07L0oooo
000D0?ooo`8000008`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo05@0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`1g0?ooo`00503oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo07L0oooo000D0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0M`3oool001@0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo05<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1g0?ooo`00
503oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
D`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo07L0oooo000D0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1B0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0M`3oool001@0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`1f0?ooo`00503oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
07H0oooo000D0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`1B0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0MP3oool001@0oooo
0P00000R0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0D03oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo07H0oooo000D0?ooo`030000003oool0oooo0240oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0MP3oool001@0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1f
0?ooo`00503oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0D03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo07H0oooo000D0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1?0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0MP3oool001@0oooo00<000000?ooo`3oool0
803oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`1e0?ooo`002`3oool4000000D0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`1e0?ooo`003@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0M@3oool000d0oooo00<000000?ooo`3oool0103oool20000
00T0oooo0P00000F0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04`3oool20000
02<0oooo0P00000D0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool20000
02<0oooo0`00000E0?ooo`8000008`3oool000D0oooo100000040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0000000F0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0000000S0?ooo`<000004`3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo0P00000S0?ooo`030000003oool0000001@0
oooo00<000000?ooo`0000008`3oool000d0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0000001D0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool000000280oooo00@000000?ooo`3oool000004`3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo0180oooo00@000000?ooo`3oool000008P3oool00`00
0000oooo0000000D0?ooo`040000003oool0000000000280oooo000;0?ooo`<000001P3oool00`00
0000oooo0?ooo`070?ooo`040000003oool0oooo000001@0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0A0?ooo`040000003oool0oooo00000240oooo00@000000?ooo`3oool00000
4`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0180oooo00@000000?ooo`3oool0
00008@3oool010000000oooo0?ooo`00000D0?ooo`040000003oool0oooo00000280oooo000=0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000D
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`00
000Q0?ooo`050000003oool0oooo0?ooo`0000004P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo0180oooo00@000000?ooo`3oool000008@3oool01@000000oooo0?ooo`3oool00000
01<0oooo00@000000?ooo`3oool000008P3oool001@0oooo00<000000?ooo`3oool01P3oool01@00
0000oooo0?ooo`3oool0000001@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0@
0?ooo`050000003oool0oooo0?ooo`0000008@3oool01@000000oooo0?ooo`3oool000000180oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`040000003oool0oooo00000240
oooo00D000000?ooo`3oool0oooo0000000C0?ooo`040000003oool0oooo00000280oooo000D0?oo
o`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo0000000D0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0403oool01@000000oooo0?ooo`3oool000000240oooo00D0
00000?ooo`3oool0oooo0000000B0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
4@3oool010000000oooo0?ooo`00000Q0?ooo`050000003oool0oooo0?ooo`0000004P3oool01@00
0000oooo0?ooo`3oool000000280oooo000D0?ooo`030000003oool0oooo00H0oooo00D000000?oo
o`3oool0oooo0000000D0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0403oool0
1@000000oooo0?ooo`3oool000000240oooo00D000000?ooo`3oool0oooo0000000B0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0403oool01@000000oooo0?ooo`3oool000000200
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`050000003oool0oooo0?oo
o`0000008P3oool001@0oooo0P0000070?ooo`050000003oool0oooo0?ooo`0000004`3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo0100oooo00D000000?ooo`3oool0oooo0000000Q
0?ooo`050000003oool0oooo0?ooo`0000004@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0403oool01@000000oooo0?ooo`3oool000000280oooo
000D0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03`3oool01@000000oooo0?oo
o`3oool000000200oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool07`3oool001@0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0O0?ooo`00503oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01l0oooo000D0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07`3oool001@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0O0?ooo`00503oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0L0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo01h0oooo000D0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool07P3oool001@0oooo0P0000060?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01h0oooo000D0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool07P3oool001@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0N0?ooo`00503oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo01h0oooo000D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool07P3o
ool001@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0N0?ooo`00503oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo01d0oooo000D0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool07@3oool001@0oooo0P0000050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01d0oooo
000D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool07@3oool001@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0M0?ooo`00503oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo01d0oooo000D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool07@3oool001@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0L0?ooo`00503o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`050?ooo`<00000303oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00L0oooo100000030?ooo`8000004`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0080oooo100000020?ooo`@000005`3oool00`000000oooo0?ooo`050?ooo`@0000000<0
oooo0000003oool00P0000060?ooo`030000003oool0oooo01H0oooo1@0000020?ooo`<000000`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103o
ool2000000@0oooo0P00000@0?ooo`00503oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
000000<0oooo00@000000?ooo`3oool000004P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0F0?ooo`800000203oool010000000oooo0?ooo`00000<0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000l0oooo000D0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`00
00000`3oool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool01P3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0D0?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3oool00000
303oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`0=0?ooo`00503oool2000000@0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo0`00000<0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo000000030?ooo`040000
003oool0oooo00000180oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`04
0000003oool0oooo0?ooo`@000005`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
008000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01@0oooo00D000000?oo
o`3oool0oooo000000030?ooo`<000000`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0103oool2000000<0oooo00@000000?ooo`3oool000003`3o
ool001@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0203oool2000000<0oooo00@000000?ooo`3oool000004P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0203oool010000000oooo
0000000000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`0=0?ooo`00503oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`<000000`3oool01000
0000oooo0?ooo`00000A0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool0oooo0`00
00030?ooo`040000003oool0oooo000001L0oooo00<000000?ooo`3oool01@3oool01@000000oooo
0?ooo`000000oooo008000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000003`3oool001@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool4
000000`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`800000103oool2
00000180oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`040000003oool0
oooo0?ooo`@000005`3oool00`000000oooo0?ooo`060?ooo`8000000P3oool010000000oooo0000
000000070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool00P0000030?ooo`@00000
0P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
0`3oool2000000@0oooo0P00000@0?ooo`00503oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo01/0oooo000D0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool06`3oool0
01@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0K0?ooo`00503oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo01/0oooo003o0000020000000@3oool000<0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo000000070?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0
oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000070?ooo`8000001`3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001P3oool2000000L0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`030000003oool00000
00D0oooo00<000000?ooo`3oool0103oool2000000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0040oooo00070?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000001D0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000001T0oooo00<00000
0?ooo`3oool0203oool2000000/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool04@3oool000L0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01X0oooo00080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0J0?ooo`00
203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
6P3oool000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo01X0oooo00080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0J0?ooo`00203oool00`000000oooo0?ooo`090?ooo`8000000`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0I0?ooo`00203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool06@3oool000T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo01T0oooo00090?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0I0?ooo`002@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool06@3oool000T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01T0oooo00090?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0I0?ooo`00
2P3oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0603oool000X0oooo
00<000000?ooo`3oool01`3oool200000080oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0603oool000X0oooo00<0
00000?ooo`3oool01`3oool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01P0oooo000:0?ooo`030000003o
ool0oooo00L0oooo00D000000?ooo`3oool0oooo0000000>0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0H0?ooo`002`3oool00`000000oooo0?oo
o`060?ooo`050000003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0603oool000/0oooo00<000000?ooo`3oool01P3o
ool01@000000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo01P0oooo000;0?ooo`030000003oool0oooo00H0oooo00D0
00000?ooo`3oool0oooo0000000>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0H0?ooo`002`3oool00`000000oooo0?ooo`060?ooo`050000003o
ool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool05`3oool000`0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?oo
o`3oool0000000h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01L0oooo000<0?ooo`030000003oool0oooo00D0oooo0P0000000`3oool000000?oo
o`0?0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0G0?ooo`00303oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo00000100oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01L0oooo000<
0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000403oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool000`0oooo00<00000
0?ooo`3oool01@3oool010000000oooo0?ooo`00000@0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0G0?ooo`003@3oool00`000000oooo0?ooo`04
0?ooo`040000003oool0oooo00000100oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo01H0oooo000=0?ooo`030000003oool0oooo00@0oooo00@00000
0?ooo`3oool00000403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool05P3oool000d0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000A
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0F
0?ooo`003@3oool00`000000oooo0?ooo`040?ooo`030000003oool000000180oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01H0oooo000>0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000004P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool05P3oool000h0oooo00<000000?ooo`3oool0
0`3oool300000180oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00l0
oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01H0oooo000?0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`0000004P3oool01@000000oooo0?ooo`3oool00000
0200oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool000000200oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`003`3oool00`000000oooo0?ooo`020?oo
o`8000004`3oool01@000000oooo0?ooo`3oool000000200oooo00D000000?ooo`3oool0oooo0000
000B0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool01@000000oooo0?oo
o`3oool000000240oooo00D000000?ooo`3oool0oooo0000000B0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0603oool01@000000oooo0?ooo`3oool0000001D0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`060?ooo`00403oool010000000oooo0?ooo`3oool20000
01<0oooo00D000000?ooo`3oool0oooo0000000Q0?ooo`040000003oool0oooo00000180oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`050000003oool0oooo0?ooo`000000
8@3oool010000000oooo0?ooo`00000C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool06@3oool010000000oooo0?ooo`00000F0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool01P3oool00100oooo00@000000?ooo`3oool0oooo0P00000C0?ooo`040000003oool0oooo
00000280oooo00@000000?ooo`3oool000004P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0140oooo00@000000?ooo`3oool000008@3oool010000000oooo0?ooo`00000C0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool06P3oool010000000oooo0?ooo`00000F0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00100oooo00@000000?ooo`3o
ool0oooo0P00000C0?ooo`040000003oool0oooo00000280oooo00@000000?ooo`3oool000004P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo00@000000?ooo`3oool00000
8@3oool010000000oooo0?ooo`00000D0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool06P3oool010000000oooo0?ooo`00000F0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool01`3oool000/0oooo100000020?ooo`030000003oool0oooo00800000503oool00`000000
oooo0000000R0?ooo`040000003oool0oooo00000180oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0000002<0oooo00<000000?ooo`000000503oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo01/0oooo00@000000?ooo`3oool000005P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo000=0?ooo`030000003oool0oooo
0080oooo00@000000?ooo`0000000000503oool00`000000oooo0000000S0?ooo`8000004`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo0P00000S0?ooo`<00000503oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo01`0oooo0P00000G0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool01`3oool000d0oooo00<000000?ooo`3oool00`3oool30000
01D0oooo00<000000?ooo`3oool08P3oool2000001@0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo0280oooo0P00000F0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool07@3oool2000001P0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`070?ooo`003@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04l0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo0080
0000>@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo000=0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo0500oooo1000000j0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
1`3oool000/0oooo0`0000060?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`2>0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3o
ool000d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1?0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00L0oooo000D0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`2?0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool001@0
oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo08l0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`00503oool00`000000oooo
0?ooo`1?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0S`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00P0oooo000D0?ooo`800000D03oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`00503oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0T@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo000D0?oo
o`030000003oool0oooo0500oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2A0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool001@0oooo00<000000?ooo`3o
ool0D03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0940oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`090?ooo`00503oool00`000000oooo0?ooo`1@0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00X0oooo000D0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3o
ool001@0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo0980oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`00503oool00`00
0000oooo0?ooo`1@0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0TP3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo000D0?ooo`800000D@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0;0?ooo`00503oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo
000D0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`2E0?ooo`040000003oool0oooo000000h0oooo000D0?ooo`030000003oool0oooo0540oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`2F0?ooo`8000003`3oool001@0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0:L0oooo000D0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`2W0?oo
o`00503oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0Y`3oool001@0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0:L0oooo000D0?ooo`800000D`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0:P0oooo000D0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`2X0?ooo`00503oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0Z03oool001@0oooo00<000000?ooo`3oool0DP3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0:P0oooo000D0?ooo`030000003oool0oooo0580oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`2X0?ooo`00503oool00`000000oooo0?oo
o`1B0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0Z@3oool001@0oooo00<00000
0?ooo`3oool0D`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0:T0oooo000D0?oo
o`030000003oool0oooo05<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`2Y0?oo
o`00503oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0Z@3oool001@0oooo0P00001D0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
Z@3oool001@0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0:X0oooo000D0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`2Z0?ooo`00503oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0ZP3oool001@0oooo00<000000?ooo`3oool0D`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0:X0oooo000D0?ooo`030000003oool0oooo05<0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2Z0?ooo`002`3oool4000000D0oooo00<0
00000?ooo`3oool0D`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0:X0oooo000;
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0:/0oooo000<0?ooo`030000003oool0oooo00D0oooo0P00001E0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0Z`3oool000d0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0Z`3oool000h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1D0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0Z`3oool000/0oooo00@000000?ooo`3oool00000
1@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
Z`3oool000`0oooo0P0000060?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`2[0?ooo`00503oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0Z`3oool001@0oooo00<000000?ooo`3oool0EP3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0:/0oooo000D0?ooo`030000003oool0oooo05H0
oooo00D000000?ooo`3oool0oooo0000002^0?ooo`00503oool2000005L0oooo0P0000000`3oool0
00000?ooo`2^0?ooo`00503oool00`000000oooo0?ooo`1G0?ooo`<00000[`3oool001@0oooo00<0
00000?ooo`3oool0o`3oool:0?ooo`00503oool00`000000oooo0?ooo`3o0?ooo`X0oooo000D0?oo
o`030000003oool0oooo0?l0oooo2P3oool001@0oooo00<000000?ooo`3oool0o`3oool:0?ooo`00
\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-2.43842, -1.97858, \
0.120983, 0.0243607}}]
}, Open  ]],

Cell[TextData[{
  "Just as when using ",
  StyleBox["NDSolve", "MR"],
  " directly, there will be a rule for each function you specified in the \
second argument to ",
  StyleBox["NDSolve`ProcessEquations", "MR"],
  ".",
  " ",
  "Only the specified components of the solutions are saved in such a way \
that an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object can be created."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["NDSolve`ProcessSolutions",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(state, \ dir\),
                "TI"], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              
              "give the solutions that have been most recently computed in \
direction ",
              StyleBox["dir",
                FontSlant->"Italic"],
              " in ",
              StyleBox["state",
                FontSlant->"Italic"],
              
              " as a list of rules with values for both the functions and \
their derivatives"
            }], "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["Obtaining the current solution values.", "Caption"],

Cell["\<\
This gives the current solution values and derivatives in the \
forward direction.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ NDSolve`ProcessSolutions[state, "\<Forward\>"]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(x[31.41592653589793`] \[Rule] 0.8437552919847564`\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "[", "31.41592653589793`", "]"}], 
          "\[Rule]", \(-1.2001604116282758`\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "31.41592653589793`", "]"}], 
          "\[Rule]", \(-0.8437552919847564`\)}]}], "}"}]], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "The choices you can give for the direction ",
  StyleBox["dir",
    FontSlant->"Italic"],
  " are ",
  StyleBox["\"Forward\"", "MR"],
  " and ",
  StyleBox["\"Backward\"", "MR"],
  ", which refer to the integration forward and backward from the initial \
condition. "
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["Forward",
              "MR"], 
            Cell["\<\
integration in the direction of increasing values of \
the temporal variable \
\>", "Text"]},
          {
            StyleBox["Backward",
              "MR"], 
            Cell["\<\
integration in the direction of decreasing values of \
the temporal variables\
\>", "Text"]},
          {
            StyleBox["Active",
              "MR"], 
            Cell["\<\
integration in the direction that is currently being \
integrated; typically, this value should only be called from method \
initialization that is used during an active integration\
\>", "Text"]}
          }], TextForm]], "DefinitionBox",
  CellTags->"Integration directions"],

Cell["Integration direction specifications. ", "Caption"],

Cell[TextData[{
  "The output given by ",
  StyleBox["NDSolve`ProcessSolution", "MR"],
  " is always given in terms of the dependent variables, either at a specific \
value of the independent variable, or interpolated over all of the saved \
values. This means that when a partial differential equation is being \
integrated, you will get results representing the dependent variables over \
the spatial variables."
}], "Text"],

Cell[TextData[{
  "This computes the solution to the heat equation from time ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = -1/4 to ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = 2."
}], "MathCaption"],

Cell[BoxData[{
    \(\(state\  = \ 
        First[NDSolve`ProcessEquations[{D[u[t, x], t]\  \[Equal] \ 
                D[u[t, x], x, x], u[0, x]\  \[Equal] \ Cos[\[Pi]/2\ x], \ 
              u[t, 0]\  \[Equal] \ 1\ , \ u[t, \ 1]\  \[Equal] \ 0}, u, 
            t, {x, 0, 1}]];\)\), "\[IndentingNewLine]", 
    \(NDSolve`Iterate[state, \ {\(-1\)/4, 2}]\)}], "Input",
  CellLabel->"In[13]:="],

Cell[TextData[{
  "This gives the solution at ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = 2."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`ProcessSolutions[state, \ "\<Forward\>"]\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(u[2.`, x]\), "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False], "[", "x", "]"}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(2.`, x\), "]"}], "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False], "[", "x", "]"}]}]}], "}"}]], "Output",
  CellLabel->"Out[15]="]
}, Open  ]],

Cell[TextData[{
  "The solution is given as an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object that interpolates over the spatial variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "This gives the solution at ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = -1/4."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`ProcessSolutions[state, \ "\<Backward\>"]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    \(NDSolve::"eerr" \(\(:\)\(\ \)\) 
      "Warning: Scaled local spatial error estimate of 638.6378240455119` at \
t = \!\(\(-0.25`\)\) in the direction of independent variable x is much \
greater than prescribed error tolerance. Grid spacing with 15 points may be \
too large to achieve the desired accuracy or precision. A singularity may \
have formed or you may want to specify a smaller grid spacing using the \
MaxStepSize or MinPoints options."\)], "Message",
  CellLabel->"From In[16]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(u[\(-0.25`\), x]\), "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False], "[", "x", "]"}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["u", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(\(-0.25`\), x\), "]"}], 
          "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False], "[", "x", "]"}]}]}], "}"}]], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
  "When you process the current solution for partial differential equations, \
the ",
  ButtonBox["spatial error estimate",
    ButtonData:>{"PDE.nb", "Spatial Error Estimates"},
    ButtonStyle->"Hyperlink"],
  " is checked. (It is not generally checked except when solutions are \
produced because doing so would be quite time consuming.) Since it is \
excessive, the ",
  StyleBox["NDSolve::eerr", "MR"],
  " message is issued. The typical association of the word \"backward\" with \
the heat equation as implying instability should gives a clue to what is \
wrong in this example. "
}], "Text"],

Cell[TextData[{
  "Here is a plot of the solution at ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = 1/4"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[Evaluate[u[\(-0.25\), \ x]\  /. \ %], {x, 0, 1}];\)\)], "Input",
  CellLabel->"In[17]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.302133 8.9382e-107 [
[.21429 .28963 -9 -9 ]
[.21429 .28963 9 0 ]
[.40476 .28963 -9 -9 ]
[.40476 .28963 9 0 ]
[.59524 .28963 -9 -9 ]
[.59524 .28963 9 0 ]
[.78571 .28963 -9 -9 ]
[.78571 .28963 9 0 ]
[.97619 .28963 -3 -9 ]
[.97619 .28963 3 0 ]
[.01131 .03399 -43.5 -6.25 ]
[.01131 .03399 0 6.25 ]
[.01131 .12337 -43.5 -6.25 ]
[.01131 .12337 0 6.25 ]
[.01131 .21275 -43.5 -6.25 ]
[.01131 .21275 0 6.25 ]
[.01131 .39151 -37.5 -6.25 ]
[.01131 .39151 0 6.25 ]
[.01131 .4809 -37.5 -6.25 ]
[.01131 .4809 0 6.25 ]
[.01131 .57028 -37.5 -6.25 ]
[.01131 .57028 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30213 m
.21429 .30838 L
s
[(0.2)] .21429 .28963 0 1 Mshowa
.40476 .30213 m
.40476 .30838 L
s
[(0.4)] .40476 .28963 0 1 Mshowa
.59524 .30213 m
.59524 .30838 L
s
[(0.6)] .59524 .28963 0 1 Mshowa
.78571 .30213 m
.78571 .30838 L
s
[(0.8)] .78571 .28963 0 1 Mshowa
.97619 .30213 m
.97619 .30838 L
s
[(1)] .97619 .28963 0 1 Mshowa
.125 Mabswid
.07143 .30213 m
.07143 .30588 L
s
.11905 .30213 m
.11905 .30588 L
s
.16667 .30213 m
.16667 .30588 L
s
.2619 .30213 m
.2619 .30588 L
s
.30952 .30213 m
.30952 .30588 L
s
.35714 .30213 m
.35714 .30588 L
s
.45238 .30213 m
.45238 .30588 L
s
.5 .30213 m
.5 .30588 L
s
.54762 .30213 m
.54762 .30588 L
s
.64286 .30213 m
.64286 .30588 L
s
.69048 .30213 m
.69048 .30588 L
s
.7381 .30213 m
.7381 .30588 L
s
.83333 .30213 m
.83333 .30588 L
s
.88095 .30213 m
.88095 .30588 L
s
.92857 .30213 m
.92857 .30588 L
s
.25 Mabswid
0 .30213 m
1 .30213 L
s
.02381 .03399 m
.03006 .03399 L
s
gsave
.01131 .03399 -43.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(105) show
grestore
.02381 .12337 m
.03006 .12337 L
s
gsave
.01131 .12337 -43.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(105) show
grestore
.02381 .21275 m
.03006 .21275 L
s
gsave
.01131 .21275 -43.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(105) show
grestore
.02381 .39151 m
.03006 .39151 L
s
gsave
.01131 .39151 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(105) show
grestore
.02381 .4809 m
.03006 .4809 L
s
gsave
.01131 .4809 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(105) show
grestore
.02381 .57028 m
.03006 .57028 L
s
gsave
.01131 .57028 -37.5 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(105) show
grestore
.125 Mabswid
.02381 .05186 m
.02756 .05186 L
s
.02381 .06974 m
.02756 .06974 L
s
.02381 .08762 m
.02756 .08762 L
s
.02381 .10549 m
.02756 .10549 L
s
.02381 .14125 m
.02756 .14125 L
s
.02381 .15912 m
.02756 .15912 L
s
.02381 .177 m
.02756 .177 L
s
.02381 .19487 m
.02756 .19487 L
s
.02381 .23063 m
.02756 .23063 L
s
.02381 .2485 m
.02756 .2485 L
s
.02381 .26638 m
.02756 .26638 L
s
.02381 .28426 m
.02756 .28426 L
s
.02381 .32001 m
.02756 .32001 L
s
.02381 .33789 m
.02756 .33789 L
s
.02381 .35576 m
.02756 .35576 L
s
.02381 .37364 m
.02756 .37364 L
s
.02381 .40939 m
.02756 .40939 L
s
.02381 .42727 m
.02756 .42727 L
s
.02381 .44514 m
.02756 .44514 L
s
.02381 .46302 m
.02756 .46302 L
s
.02381 .49877 m
.02756 .49877 L
s
.02381 .51665 m
.02756 .51665 L
s
.02381 .53453 m
.02756 .53453 L
s
.02381 .5524 m
.02756 .5524 L
s
.02381 .01611 m
.02756 .01611 L
s
.02381 .58816 m
.02756 .58816 L
s
.02381 .60603 m
.02756 .60603 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30213 m
.02605 .3172 L
.02846 .33066 L
.03053 .34022 L
.03279 .34859 L
.03416 .35274 L
.03543 .35595 L
.03662 .35846 L
.03793 .36068 L
.03911 .3622 L
.04021 .36325 L
.04137 .36399 L
.04262 .36437 L
.04393 .36433 L
.04516 .36392 L
.04586 .36353 L
.0465 .36307 L
.04793 .36174 L
.04917 .36024 L
.05052 .35828 L
.05297 .35394 L
.05791 .34255 L
.06244 .32971 L
.08253 .26323 L
.09317 .2322 L
.09903 .21865 L
.10458 .20867 L
.10706 .20519 L
.1097 .20218 L
.11107 .2009 L
.11259 .19972 L
.11398 .19884 L
.11526 .19822 L
.11644 .1978 L
.11768 .19751 L
.11892 .19739 L
.11963 .1974 L
.12029 .19745 L
.12148 .19766 L
.12257 .19797 L
.12382 .19849 L
.125 .19913 L
.12731 .20079 L
.12976 .20313 L
.13415 .20877 L
.13887 .21679 L
.14407 .22775 L
.16351 .28354 L
.18441 .35269 L
.19454 .38203 L
Mistroke
.19989 .39499 L
.20558 .40626 L
.2084 .41075 L
.21106 .41425 L
.21344 .41677 L
.21467 .41782 L
.21601 .41878 L
.21728 .4195 L
.21847 .41999 L
.21971 .42034 L
.22042 .42045 L
.22105 .4205 L
.22219 .42047 L
.22343 .42025 L
.2246 .41986 L
.22568 .41935 L
.22687 .41863 L
.22811 .41691 L
.22917 .41227 L
.23033 .40704 L
.23534 .38277 L
.24439 .33347 L
.265 .21497 L
.27512 .16547 L
.28008 .14569 L
.28465 .13083 L
.28717 .12417 L
.28993 .11821 L
.29271 .11373 L
.29422 .11193 L
.2949 .11129 L
.29564 .1107 L
.29693 .11566 L
.29816 .12216 L
.30045 .13514 L
.30562 .16777 L
.32498 .31682 L
.33527 .39903 L
.34637 .47697 L
.3515 .50641 L
.35691 .53143 L
.35915 .53973 L
.36153 .54719 L
.36224 .5491 L
.36291 .55078 L
.36415 .55206 L
.36532 .54568 L
.36659 .53834 L
.3856 .38739 L
.40506 .19891 L
Mistroke
.41539 .1095 L
.42108 .06849 L
.42649 .03684 L
.42894 .02515 L
.43029 .01951 L
.43157 .01472 L
.43229 .0149 L
.43307 .01904 L
.43444 .02671 L
.43711 .04331 L
.44682 .1195 L
.46586 .31273 L
.48581 .51071 L
.49066 .54882 L
.49586 .58277 L
.49739 .59125 L
.49884 .59859 L
.50014 .60332 L
.50088 .59993 L
.50156 .59664 L
.50688 .56585 L
.51652 .49055 L
.52556 .40333 L
.54617 .18635 L
.55601 .09506 L
.56137 .05368 L
.56399 .03624 L
.56513 .02926 L
.56636 .02213 L
.56751 .01595 L
.56856 .01518 L
.56957 .01898 L
.57064 .02335 L
.57521 .04589 L
.58487 .11153 L
.60469 .29318 L
.62278 .4619 L
.62756 .49932 L
.63008 .51715 L
.63277 .53448 L
.6341 .54239 L
.63535 .5494 L
.63647 .55224 L
.63769 .5493 L
.64224 .53471 L
.64754 .51129 L
.65314 .48004 L
.66314 .41115 L
.68306 .25181 L
.69175 .18603 L
Mistroke
.69633 .15497 L
.70118 .12577 L
.70238 .11925 L
.70367 .11256 L
.70441 .11074 L
.70509 .11128 L
.70641 .11263 L
.70889 .11611 L
.71124 .12056 L
.71578 .13209 L
.72075 .14874 L
.7316 .1972 L
.74168 .25228 L
.76047 .36061 L
.76562 .38758 L
.76843 .40128 L
.7698 .40765 L
.77106 .41327 L
.77221 .41793 L
.7733 .41874 L
.77445 .41942 L
.7757 .41998 L
.77698 .42034 L
.77763 .42045 L
.77835 .4205 L
.77961 .42045 L
.7808 .42022 L
.78205 .4198 L
.78276 .41948 L
.78341 .41913 L
.78617 .41712 L
.78855 .41471 L
.7911 .41147 L
.79691 .40167 L
.8022 .39018 L
.82237 .33075 L
.84316 .26238 L
.85229 .23662 L
.85713 .22503 L
.86234 .21455 L
.86738 .2066 L
.86977 .20365 L
.87198 .2014 L
.8742 .19965 L
.87547 .19886 L
.87662 .1983 L
.87771 .19788 L
.87875 .19761 L
.87984 .19743 L
.88101 .19739 L
Mistroke
.88225 .1975 L
.8834 .19775 L
.88467 .19819 L
.88603 .19884 L
.88745 .19974 L
.8888 .20079 L
.89132 .20326 L
.89586 .20935 L
.90079 .21828 L
.91021 .24128 L
.9206 .27346 L
.93157 .31057 L
.93637 .32607 L
.94161 .34128 L
.94554 .35084 L
.94769 .35522 L
.94973 .35867 L
.95084 .36026 L
.95205 .36171 L
.95305 .36269 L
.95415 .36353 L
.95519 .36407 L
.95629 .36437 L
.95731 .36438 L
.95826 .36415 L
.95937 .36356 L
.96058 .36254 L
.96172 .36116 L
.96278 .35953 L
.96478 .35545 L
.96691 .34957 L
.96918 .34139 L
.97132 .33179 L
.97619 .30213 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00;P3oool00`000000oooo0?ooo`3_0?ooo`00;P3oool00`000000oooo
0?ooo`3_0?ooo`00;P3oool00`000000oooo0?ooo`3_0?ooo`00;P3oool00`000000oooo0?ooo`3_
0?ooo`00;P3oool2000006<0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`1Y0?oo
o`00203oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`@000000`3oool20000
0140oooo00<000000?ooo`3oool0H@3oool200000200oooo00<000000?ooo`3oool0J@3oool000L0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000050?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0640oooo0P00000P
0?ooo`800000JP3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0640oooo0P00000O0?ooo`030000003oool0000006X0oooo00000`3oool00000000000020000
00<0oooo0P0000040?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00h0oooo0`00001P0?ooo`030000003oool0000001l0oooo00<00000
0?ooo`000000JP3oool000X0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo0600oooo00<000000?ooo`0000007`3oool010000000oooo0?ooo`00001Y0?ooo`001`3o
ool010000000oooo0?ooo`0000090?ooo`<000000`3oool010000000oooo0?ooo`0000020?ooo`<0
00000`3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool0H03oool01000
0000oooo0?ooo`00000N0?ooo`040000003oool0oooo000006T0oooo00080?ooo`800000303oool0
0`000000oooo0?ooo`020?ooo`800000103oool01`000000oooo0?ooo`3oool000000?ooo`000000
103oool00`000000oooo0000001R0?ooo`040000003oool0oooo000001h0oooo00@000000?ooo`3o
ool00000J@3oool00240oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00<00000
0?ooo`000000HP3oool010000000oooo0?ooo`00000M0?ooo`050000003oool0oooo0?ooo`000000
J@3oool00240oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo0P0000020?ooo`80
0000H@3oool010000000oooo0?ooo`00000M0?ooo`050000003oool0oooo0?ooo`000000J@3oool0
0200oooo0P0000030?ooo`030000003oool000000080oooo00D000000?ooo`3oool0oooo0000001Q
0?ooo`050000003oool0oooo0?ooo`0000007@3oool01@000000oooo0?ooo`3oool0000006T0oooo
000Q0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo0`0000000`3oool00000
0?ooo`1P0?ooo`050000003oool0oooo0?ooo`0000007@3oool01@000000oooo0?ooo`3oool00000
06T0oooo000^0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0IP3oool002h0oooo
0P00001P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo06H0oooo000^0?ooo`030000003oool0oooo05l0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0IP3oool002h0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1V
0?ooo`00;P3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06H0oooo000^0?ooo`03
0000003oool0oooo05l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0IP3oool002h0oooo0P00001P0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo06H0oooo000^0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0IP3o
ool002h0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1U0?ooo`00;P3oool00`00
0000oooo0?ooo`1N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo06D0oooo000^0?ooo`800000G`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`1U0?ooo`001`3oool400000080oooo00D000000?ooo`3oool0oooo000000020?ooo`@0
00000`3oool200000140oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool0A`3oool000L0oooo00<000000?ooo`3oool0
103oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo03l0oooo0P00000M0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0A`3oool000P0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo03l0oooo0P00000M0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01X0oooo00<000000?ooo`00
0000B03oool000030?ooo`000000000000800000103oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0
oooo0`00000o0?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool06P3oool00`000000
oooo000000180?ooo`002P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0?P3oool010000000oooo0?ooo`00000K0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01X0oooo00@00000
0?ooo`3oool00000A`3oool000L0oooo00@000000?ooo`3oool000002@3oool3000000<0oooo00@0
00000?ooo`3oool000000P3oool3000000<0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`03
0000003oool0oooo03d0oooo00D000000?ooo`3oool0oooo0000000K0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
01T0oooo00D000000?ooo`3oool0oooo000000160?ooo`00203oool2000000`0oooo00<000000?oo
o`3oool00P3oool2000000@0oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00<0
00000?ooo`000000?`3oool01@000000oooo0?ooo`3oool0000001/0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
6@3oool01@000000oooo0?ooo`3oool0000004H0oooo000Q0?ooo`070000003oool0oooo0?ooo`00
0000oooo000000040?ooo`030000003oool0000003l0oooo00D000000?ooo`3oool0oooo0000000K
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo01T0oooo00D000000?ooo`3oool0oooo000000160?ooo`008@3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000P3oool200000080oooo0P00000m0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0@`3oool00200oooo0P0000030?ooo`030000003o
ool000000080oooo00D000000?ooo`3oool0oooo0000000n0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0@`3oool00240oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`3oool3000000030?ooo`000000oooo03d0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`130?ooo`00;P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0@`3oool002h0oooo0P00000l0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0@`3oool002h0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0480oooo000^0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`120?ooo`00;P3oool00`000000oooo0?ooo`0k0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0@P3oool002h0oooo00<000000?ooo`3oool0>`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0480oooo000^0?ooo`800000>`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0480oooo000^0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`120?ooo`00;P3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0@@3oool002h0oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0440oooo
000^0?ooo`800000>P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0440oooo0007
0?ooo`@000000P3oool01@000000oooo0?ooo`3oool000000080oooo100000030?ooo`8000004@3o
ool00`000000oooo0?ooo`0C0?ooo`D000008@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo0240oooo1000000L0?ooo`002@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01l0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0O0?ooo`800000103oool00`000000oooo0?oo
o`0I0?ooo`002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0603o
ool000030?ooo`000000000000800000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0oooo0`00
000A0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0H0?ooo`002@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0G0?ooo`001`3oool3000000X0oooo0`0000030?ooo`040000003oool0oooo00000080oooo
0`0000030?ooo`040000003oool0oooo0?ooo`8000000P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`00
2@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`070000
003oool0oooo0?ooo`000000oooo000000040?ooo`030000003oool000000140oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo000Q0?ooo`07
0000003oool0oooo0?ooo`000000oooo000000040?ooo`030000003oool000000140oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo000Q0?oo
o`070000003oool0oooo0?ooo`000000oooo000000020?ooo`8000000P3oool2000000l0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01H0oooo000P
0?ooo`8000000`3oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000403o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool05@3o
ool00240oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool3000000030?ooo`00
0000oooo00l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo01D0oooo000^0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01D0oooo000^0?ooo`8000003P3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0503oool002h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0503oool002h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0503oool002h0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00D0oooo0P00
00040?ooo`030000003oool0oooo0080oooo100000020?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0303oool2000000<0oooo0P0000060?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`040?ooo`800000103oool00`000000oooo0000
00030?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`040000003oool0oooo0?ooo`800000
103oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00X0oooo100000050?ooo`00;P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000080?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000050?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool000000080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`00
00060?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`040?ooo`00;P3oool2000000d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
0?ooo`020?ooo`D000001P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo
00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo000000020?ooo`030000003oool0oooo
00H0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool002h0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000002P3oool0
1@000000oooo0?ooo`3oool0000000l0oooo00<000000?ooo`3oool02P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001@3oool00`00
0000oooo0?ooo`03000000d0oooo00<000000?ooo`3oool03P3oool00`000000oooo000000020?oo
o`030000003oool0oooo00L0oooo0P0000060?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`040?ooo`00;P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000;0?oo
o`030000003oool000000100oooo00<000000?ooo`3oool02P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0000
000?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`0000000P3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00@0oooo000^0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000P0oooo
00H000000?ooo`3oool000000?ooo`00000@0?ooo`030000003oool0oooo00X0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`040?ooo`8000001`3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0000
000?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`0000000P3oool00`000000oooo0?oo
o`060?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`080?ooo`<000001P3oool002h0oooo0P00000;0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool00`3oool2000000X0oooo0P0000020?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool02`3oool2000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0103oool2000000L0oooo00<0
00000?ooo`3oool00`00000<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00P00
000:0?ooo`8000001@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0103oool002h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04@3oool002h0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool0403oool002h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool0403oool002P0oooon000000002h0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo0P00
000:0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`050000
003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo0000
00/0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`060?ooo`040000003oool0
oooo000000/0oooo00<000000?ooo`0000002@3oool00`000000oooo0?ooo`050?ooo`040000003o
ool0oooo000000/0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool2000000X0oooo00<000000?ooo`3o
ool0103oool002h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo00h0oooo00@000000?ooo`3oool000003P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`0000004@3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool002h0oooo0P0000090?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00D0oooo000^0?ooo`8000002@3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`00;P3oool2
000000T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool01@3oool002h0oooo0P0000080?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00D0oooo000^0?ooo`800000203oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`00;P3oool2000000L0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01P3oool002h0oooo0`0000060?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo000^
0?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool002h0oooo00<000000?oo
o`0000001@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`060?ooo`00;P3oool00`000000oooo000000040?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00L0oooo000^0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0N0?ooo`050000003oool0oooo0?ooo`0000002@3oool002h0
oooo0P0000000`3oool000000?ooo`020?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool07P3oool010000000oooo0?ooo`00000:0?ooo`00;P3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000008P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0O0?ooo`@000002P3oool002h0oooo00@000000?oo
o`3oool0oooo0P00000S0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0200oooo0P00000;0?ooo`00;P3oool00`00
0000oooo0?ooo`0V0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo02d0oooo000^0?ooo`8000009`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0^0?ooo`001`3oool400000080oooo00D000000?ooo`3oool0oooo000000020?ooo`@0
00000`3oool200000140oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0^0?ooo`00
2@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool09`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0^0?ooo`002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool09`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`0_0?ooo`002@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0
oooo0`00000X0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo02l0oooo00090?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0<03oool000L0
oooo0`00000:0?ooo`<000000`3oool010000000oooo0?ooo`0000020?ooo`<000000`3oool01000
0000oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0`
0?ooo`002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo0P0000040?oo
o`070000003oool0oooo0?ooo`000000oooo000000040?ooo`030000003oool0000002/0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0<@3oool00240oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo
00<000000?ooo`000000;03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0a0?ooo`008@3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000P3oool200000080oooo0P00000/0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0380
oooo000P0?ooo`8000000`3oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000;@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00D000000?ooo`3o
ool0oooo0000000e0?ooo`008@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?oo
o`<0000000<0oooo0000003oool0;@3oool4000001/0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo1@00000e0?ooo`00;P3oool00`000000
oooo0?ooo`1;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`1B0?ooo`00;P3oool2000004`0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0580oooo000^0?ooo`030000003oool0oooo04/0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0580oooo000^
0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo0580oooo000^0?ooo`030000003oool0oooo04`0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0580oooo000^0?ooo`03
0000003oool0oooo04`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0580oooo000^0?ooo`800000C@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0D`3oool002h0oooo00<000000?ooo`3oool0C03o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0D`3o
ool002h0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0D`3oool002h0oooo00<000000?ooo`3oool0C03oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0D`3oool002h0
oooo0P00001>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`1C0?ooo`001`3oool400000080oooo00D000000?ooo`3oool0oooo000000020?ooo`@0
00000`3oool200000140oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0D`3oool000L0oooo00<000000?ooo`3oool0
103oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo05@0oooo00080?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`1D0?ooo`002@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0
oooo0`00001=0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`1D0?ooo`002P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0C@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0E03oool000L0oooo00@000000?ooo`3oool000002@3oool3000000<0oooo00@000000?oo
o`3oool000000P3oool3000000<0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`030000003o
ool0oooo04d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo05@0oooo00080?ooo`800000303oool00`000000oooo0?ooo`020?ooo`800000103oool0
1`000000oooo0?ooo`3oool000000?ooo`000000103oool00`000000oooo0000001?0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1D0?ooo`008@3o
ool01`000000oooo0?ooo`3oool000000?ooo`000000103oool00`000000oooo0000001@0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1D0?ooo`00
8@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool200000080oooo0P00001?0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1E0?oo
o`00803oool2000000<0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0500oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
05D0oooo000Q0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0oooo0`0000000`3o
ool000000?ooo`1?0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`1E0?ooo`00;P3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1E0?ooo`00;P3oool2000004l0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05D0oooo
000^0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06P3oool01@000000oooo0?oo
o`3oool0000005P0oooo000^0?ooo`030000003oool0oooo04l0oooo00@000000?ooo`3oool00000
703oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo00D000000?ooo`3oool0
oooo0000001H0?ooo`00;P3oool00`000000oooo0?ooo`1?0?ooo`040000003oool0oooo000001`0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?ooo`040000003oool0oooo0000
05P0oooo000^0?ooo`030000003oool0oooo04l0oooo00@000000?ooo`3oool000007@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`000000F@3oool002h0
oooo0P00001@0?ooo`040000003oool0oooo000001d0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0000005T0oooo000^0?ooo`030000003oool0oooo0500
oooo00<000000?ooo`0000007@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`000000F@3oool002h0oooo00<000000?ooo`3oool0D03oool2000001h0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0K0?ooo`800000FP3oool002h0oooo00<0
00000?ooo`3oool0D03oool2000001h0oooo00D000000?ooo`3oool0oooo0000000O0?ooo`030000
003oool0oooo05P0oooo000^0?ooo`800000DP3oool00`000000oooo0?ooo`0L0?ooo`050000003o
ool0oooo0?ooo`0000007`3oool00`000000oooo0?ooo`1H0?ooo`00203oool2000000<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`@000000`3oool200000140oooo00<000000?ooo`3oool0
L03oool01@000000oooo0?ooo`3oool0000007X0oooo00070?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`1`0?ooo`050000003oool0oooo0?ooo`000000NP3oool0
00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0700oooo00D00000
0?ooo`3oool0oooo0000001j0?ooo`00203oool2000000@0oooo00<000000?ooo`0000001@3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool03P3oool300000740oooo00@0
00000?ooo`3oool00000NP3oool000X0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo0740oooo00@000000?ooo`3oool00000NP3oool000L0oooo00@000000?ooo`3o
ool000002@3oool3000000<0oooo00@000000?ooo`3oool000000P3oool3000000<0oooo00@00000
0?ooo`3oool0oooo0P0000020?ooo`030000003oool0oooo0740oooo00@000000?ooo`3oool00000
NP3oool000P0oooo0P00000<0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`070000003o
ool0oooo0?ooo`000000oooo000000040?ooo`030000003oool0000007<0oooo00@000000?ooo`3o
ool00000NP3oool00240oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00<00000
0?ooo`000000L`3oool00`000000oooo0000001k0?ooo`008@3oool01`000000oooo0?ooo`3oool0
00000?ooo`0000000P3oool200000080oooo0P00001c0?ooo`800000N`3oool00200oooo0P000003
0?ooo`030000003oool000000080oooo00D000000?ooo`3oool0oooo0000001d0?ooo`800000N`3o
ool00240oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool3000000030?ooo`00
0000oooo07<0oooo0P00001k0?ooo`00;P3oool00`000000oooo0?ooo`1b0?ooo`800000N`3oool0
02h0oooo0P00001c0?ooo`030000003oool0oooo07X0oooo000^0?ooo`030000003oool0oooo0>l0
oooo000^0?ooo`030000003oool0oooo0>l0oooo000^0?ooo`030000003oool0oooo0>l0oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-0.198587, -3.94189*^31, \
0.00426339, 4.54271*^29}}]
}, Open  ]],

Cell["\<\
The plot of the solution shows that instability is indeed the \
problem. \
\>", "Text"],

Cell[TextData[{
  "Even though the heat equation example is simple enough to know that the \
solution backward in time is problematic, using ",
  StyleBox["NDSolve`Iterate", "MR"],
  " and ",
  StyleBox["NDSolve`ProcessSolutions", "MR"],
  " to monitor the solution of a PDE can be used to save computing a solution \
which turns out not to be as accurate as desired. Another simple form of \
monitoring follows."
}], "Text"],

Cell["\<\
Entering the following commands generates a sequence of plots \
showing the solution of a generalization of the sine-Gordon equation as it is \
being computed. \
\>", "MathCaption"],

Cell[BoxData[{
    \(\(L\  = \(-10\);\)\), "\[IndentingNewLine]", 
    \(\(state\  = \ 
        First[NDSolve`ProcessEquations[{D[u[t, x, y], t, t]\  \[Equal] \ 
                D[u[t, x, y], x, x]\  + \ D[u[t, x, y], y, y]\  - \ 
                  Sin[u[t, x, y]], \[IndentingNewLine]u[0, x, y]\  \[Equal] \ 
                Exp[\(-\((x\^2 + y\^2)\)\)], \ \(\(Derivative[1, 0, 0]\)[u]\)[
                  0, x, y]\  \[Equal] \ 
                0, \[IndentingNewLine]u[t, \(-L\), y]\  \[Equal] \ 
                u[t, L, \ y], \ u[t, x, \(-L\)]\  \[Equal] \ u[t, x, L]}, u, 
            t, {x, \(-L\), L}, \ {y, \(-L\), L}, \ 
            Method \[Rule] {"\<MethodOfLines\>", \ \
"\<SpatialDiscretization\>" \[Rule] {"\<TensorProductGrid\>", \ \
"\<DifferenceOrder\>" -> "\<Pseudospectral\>"}}]];\)\), \
"\[IndentingNewLine]", 
    \(Do[\[IndentingNewLine]NDSolve`Iterate[
        state, \ \[Tau]]; \[IndentingNewLine]Plot3D[
        Evaluate[
          u[\[Tau], \ x, \ y]\  /. \ 
            NDSolve`ProcessSolutions[state, \ "\<Forward\>"]], {x, \(-L\), 
          L}, {y, \(-L\), L}, \ PlotRange \[Rule] {\(-1\)/4, 1/4}, \ 
        PlotPoints \[Rule] 47], \[IndentingNewLine]{\[Tau], \ 0. , \ 
        20. }]\)}], "Input",
  CellLabel->"In[18]:="],

Cell[TextData[{
  "When you monitor a solution in this way, it is usually possible to \
interrupt the computation if you see that the solution found is sufficient. \
You can still use the ",
  StyleBox["NDSolve`StateData", "MR"],
  " object to get the solutions that have been computed."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`StateData Methods", "Section",
  CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"}],

Cell[TextData[{
  "An ",
  StyleBox["NDSolve`StateData", "MR"],
  " object contains a lot of information, but it is arranged in a manner \
which makes it easy to iterate solutions, and not in a manner which makes it \
easy to understand where the information is kept. However, sometimes you will \
want to get information from the state data object: for this reason several \
method functions have been defined to make accessing the information easy."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"TemporalVariable\"[]", "MR"]
            }]], 
            Cell["\<\
give the independent variable that the dependent \
variables (functions) depend on\
\>"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"DependentVariables\"[]", "MR"]
            }]], 
            Cell["\<\
give a list of the dependent variables (functions) to \
be solved for\
\>", "Text"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"VariableDimensions\"[]", "MR"]
            }]], 
            Cell["\<\
give the dimensions of each of the dependent variables \
(functions)\
\>"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"VariablePositions\"[]", "MR"]
            }]], 
            Cell["\<\
give the positions in the solution vector for each of \
the dependent variables\
\>", "Text"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"VariableTransformation\"[]", "MR"]
            }]], 
            Cell["\<\
give the transformation of variables from the original \
problem variables to the working variables\
\>"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"NumericalFunction\"[]", "MR"]
            }]], Cell[TextData[{
              "give the ",
              StyleBox["NumericalFunction", "MR"],
              
              " object used to evaluate the derivatives of the solution \
vector with respect to the temporal variable"
            }]]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"ProcessExpression\"[", "MR"],
              StyleBox["args", "MR",
                FontSlant->"Italic"],
              StyleBox[", ", "MR"],
              StyleBox["expr", "MR",
                FontSlant->"Italic"],
              StyleBox[", ", "MR"],
              StyleBox["dims", "MR",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              "process the expression ",
              StyleBox["expr", "MR",
                FontSlant->"Italic"],
              " using the same variable transformations that ",
              StyleBox["NDSolve", "MR"],
              " used to generate ",
              StyleBox["state",
                FontSlant->"Italic"],
              " to give a ",
              StyleBox["NumericalFunction", "MR"],
              " object for numerically evaluating ",
              StyleBox["expr", "MR",
                FontSlant->"Italic"],
              "; ",
              StyleBox["args", "MR",
                FontSlant->"Italic"],
              
              " is the arguments for the numerical function and should either \
be ",
              StyleBox["All", "MR"],
              
              " or a list of arguments that are dependent variables of the \
system; ",
              StyleBox["dims", "MR",
                FontSlant->"Italic"],
              " should be ",
              StyleBox["Automatic", "MR"],
              
              " or an explicit list giving the expected dimensions of the \
numerical function result"
            }]]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"SystemSize\"[]", "MR"]
            }]], 
            Cell["\<\
give the effective number of first-order ordinary \
differential equations being solved\
\>"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"MaxSteps\"[]", "MR"]
            }]], 
            Cell["\<\
give the maximum number of steps allowed for iterating \
the differential equations\
\>", "Text"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"WorkingPrecision\"[]", "MR"]
            }]], Cell[
            "give the working precision used to solve the equations", 
              "Text"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"Norm\"[]", "MR"]
            }]], Cell[TextData[{
              "the ",
              ButtonBox["scaled norm",
                ButtonData:>{"VectorNorm.nb", None},
                ButtonStyle->"Hyperlink"],
              " to use for guaging error"
            }]]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "General method functions for an ",
  StyleBox["NDSolve`StateData", "MR"],
  " object ",
  StyleBox["state", "TI"],
  "."
}], "Caption"],

Cell[TextData[{
  "Much of the available information depends on the current solution values. \
Each ",
  StyleBox["NDSolve`StateData", "MR"],
  " object keeps solution information for solutions in both the forward and \
backward direction. At the initial condition these are the same, but once the \
problem has been iterated in either direction, these will be different."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"CurrentTime\"[", "MR"],
              StyleBox["dir",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              
              "give the current value of the temporal variable in the \
integration direction ",
              StyleBox["dir", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"SolutionVector\"[", "MR"],
              StyleBox["dir",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              
              "give the current value of the solution vector in the \
integration direction ",
              StyleBox["dir", "TI"]
            }], "Text"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"SolutionDerivativeVector\"[", "MR"],
              StyleBox["dir",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              
              "give the current value of the derivative with respect to the \
temporal variable of the solution vector in the integration direction ",
              StyleBox["dir", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"TimeStep\"[", "MR"],
              StyleBox["dir",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              
              "give the time step size for the next step in the integration \
direction ",
              StyleBox["dir", "TI"]
            }], "Text"]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"TimeStepsUsed\"[", "MR"],
              StyleBox["dir",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              
              "give the number of time steps used to get to the current time \
in the integration direction ",
              StyleBox["dir", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["state",
                FontSlant->"Italic"],
              StyleBox["@\"MethodData\"[", "MR"],
              StyleBox["dir",
                FontSlant->"Italic"],
              StyleBox["]", "MR"]
            }]], Cell[TextData[{
              
              "give the method data object used in the integration direction \
",
              StyleBox["dir", "TI"]
            }]]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Directional method functions for an ",
  StyleBox["NDSolve`StateData", "MR"],
  " object ",
  StyleBox["state", "TI"],
  "."
}], "Caption"],

Cell[TextData[{
  "If the direction argument is omitted, the functions will return a list \
with the data for both directions (a list with a single element at the \
initial condition).",
  " ",
  "Otherwise, the direction can be ",
  StyleBox["Forward", "MR"],
  ", ",
  StyleBox["Backward", "MR"],
  ", or ",
  StyleBox["Active", "MR"],
  " as ",
  ButtonBox["specified",
    ButtonData:>"Integration directions",
    ButtonStyle->"Hyperlink"],
  " in the previous section."
}], "Text"],

Cell[TextData[{
  "Here is an ",
  StyleBox["NDSolve`StateData", "MR"],
  " object for a solution of the nonlinear Schrodinger equation that has been \
computed up to ",
  StyleBox["t",
    FontSlant->"Italic"],
  " = 1."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(state\  = \ 
        First[NDSolve`ProcessEquations[{I\ D[u[t, x], t]\  \[Equal] \ 
                D[u[t, x], x, x]\  + \ Abs[u[t, x]]^2\ \ u[t, x], \ 
              u[0, x]\  \[Equal] \ Sech[x]\ Exp[\[Pi]\ I\ x], \ 
              u[t, \(-15\)]\  \[Equal] \ u[t, 15]}, u, t, {x, \(-15\), 15}, \ 
            Method \[Rule] StiffnessSwitching]];\)\), "\[IndentingNewLine]", 
    \(\(NDSolve`Iterate[state, \ 1];\)\), "\[IndentingNewLine]", 
    \(state\)}], "Input",
  CellLabel->"In[21]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"NDSolve`StateData", "[", 
        InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]","\
\[InvisibleSpace]1.`\[InvisibleSpace]">"\),
          SequenceForm[ "<", 0.0, ",", 1.0, ">"],
          Editable->False], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[23]="]
}, Open  ]],

Cell["\<\
\[OpenCurlyDoubleQuote]Current\[CloseCurlyDoubleQuote] refers to \
the most recent point reached in the integration. \
\>", "Text"],

Cell["\<\
This gives the current time in both the forward and backward \
directions.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(state@"\<CurrentTime\>"[]\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    \({0.`, 1.`}\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell["\<\
This gives the size of the system of ordinary differential \
equations being solved.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(state@"\<SystemSize\>"[]\)], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    \(400\)], "Output",
  CellLabel->"Out[25]="]
}, Open  ]],

Cell[TextData[{
  "The method functions are relatively low-level hooks into the data \
structure, they do little processing on the data returned to you. Thus, \
unlike ",
  StyleBox["NDSolve`ProcessSolutions", "MR"],
  ", the solutions given are simply vectors of data points relating to the \
system of ordinary differential equations ",
  StyleBox["NDSolve", "MR"],
  " is solving."
}], "Text"],

Cell["\<\
This makes a plot of the modulus of current solution in the forward \
direction.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Abs[state@SolutionVector["\<Forward\>"]]];\)\)], "Input",
  CellLabel->"In[26]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00238095 0.0147151 0.714149 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -9 -9 ]
[.5 .00222 9 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.01131 .15754 -18 -4.5 ]
[.01131 .15754 0 4.5 ]
[.01131 .30037 -18 -4.5 ]
[.01131 .30037 0 4.5 ]
[.01131 .4432 -18 -4.5 ]
[.01131 .4432 0 4.5 ]
[.01131 .58603 -18 -4.5 ]
[.01131 .58603 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(100)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(200)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(300)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(400)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .15754 m
.03006 .15754 L
s
[(0.2)] .01131 .15754 1 0 Mshowa
.02381 .30037 m
.03006 .30037 L
s
[(0.4)] .01131 .30037 1 0 Mshowa
.02381 .4432 m
.03006 .4432 L
s
[(0.6)] .01131 .4432 1 0 Mshowa
.02381 .58603 m
.03006 .58603 L
s
[(0.8)] .01131 .58603 1 0 Mshowa
.125 Mabswid
.02381 .05042 m
.02756 .05042 L
s
.02381 .08613 m
.02756 .08613 L
s
.02381 .12184 m
.02756 .12184 L
s
.02381 .19325 m
.02756 .19325 L
s
.02381 .22896 m
.02756 .22896 L
s
.02381 .26467 m
.02756 .26467 L
s
.02381 .33608 m
.02756 .33608 L
s
.02381 .37179 m
.02756 .37179 L
s
.02381 .4075 m
.02756 .4075 L
s
.02381 .47891 m
.02756 .47891 L
s
.02381 .51462 m
.02756 .51462 L
s
.02381 .55033 m
.02756 .55033 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02619 .01534 Mdot
.02857 .01533 Mdot
.03095 .01534 Mdot
.03333 .01538 Mdot
.03571 .01546 Mdot
.0381 .01557 Mdot
.04048 .01571 Mdot
.04286 .01588 Mdot
.04524 .01605 Mdot
.04762 .01623 Mdot
.05 .01641 Mdot
.05238 .01658 Mdot
.05476 .01675 Mdot
.05714 .01689 Mdot
.05952 .01701 Mdot
.0619 .0171 Mdot
.06429 .01716 Mdot
.06667 .01718 Mdot
.06905 .01716 Mdot
.07143 .01709 Mdot
.07381 .01698 Mdot
.07619 .01682 Mdot
.07857 .01662 Mdot
.08095 .01639 Mdot
.08333 .01616 Mdot
.08571 .016 Mdot
.0881 .01598 Mdot
.09048 .01619 Mdot
.09286 .0166 Mdot
.09524 .01715 Mdot
.09762 .01779 Mdot
.1 .0185 Mdot
.10238 .01925 Mdot
.10476 .02004 Mdot
.10714 .02084 Mdot
.10952 .02165 Mdot
.1119 .02246 Mdot
.11429 .02324 Mdot
.11667 .02399 Mdot
.11905 .02468 Mdot
.12143 .02532 Mdot
.12381 .02587 Mdot
.12619 .02633 Mdot
.12857 .02667 Mdot
.13095 .02689 Mdot
.13333 .02696 Mdot
.13571 .02688 Mdot
.1381 .02661 Mdot
.14048 .02616 Mdot
.14286 .0255 Mdot
.14524 .02462 Mdot
.14762 .02351 Mdot
.15 .02214 Mdot
.15238 .02052 Mdot
.15476 .01862 Mdot
.15714 .01646 Mdot
.15952 .01561 Mdot
.1619 .01833 Mdot
.16429 .02143 Mdot
.16667 .02487 Mdot
.16905 .02864 Mdot
.17143 .03275 Mdot
.17381 .03721 Mdot
.17619 .04203 Mdot
.17857 .0472 Mdot
.18095 .05274 Mdot
.18333 .05864 Mdot
.18571 .06491 Mdot
.1881 .07155 Mdot
.19048 .07856 Mdot
.19286 .08595 Mdot
.19524 .09372 Mdot
.19762 .10187 Mdot
.2 .11039 Mdot
.20238 .1193 Mdot
.20476 .12859 Mdot
.20714 .13825 Mdot
.20952 .14829 Mdot
.2119 .15869 Mdot
.21429 .16945 Mdot
.21667 .18058 Mdot
.21905 .19206 Mdot
.22143 .2039 Mdot
.22381 .21609 Mdot
.22619 .22864 Mdot
.22857 .24152 Mdot
.23095 .25474 Mdot
.23333 .26827 Mdot
.23571 .28209 Mdot
.2381 .29618 Mdot
.24048 .31052 Mdot
.24286 .32506 Mdot
.24524 .33979 Mdot
.24762 .35467 Mdot
.25 .36967 Mdot
.25238 .38475 Mdot
.25476 .39988 Mdot
.25714 .415 Mdot
.25952 .43007 Mdot
.2619 .44502 Mdot
.26429 .45977 Mdot
.26667 .47425 Mdot
.26905 .48838 Mdot
.27143 .50207 Mdot
.27381 .51522 Mdot
.27619 .52776 Mdot
.27857 .5396 Mdot
.28095 .55067 Mdot
.28333 .56087 Mdot
.28571 .57014 Mdot
.2881 .5784 Mdot
.29048 .58559 Mdot
.29286 .59163 Mdot
.29524 .59647 Mdot
.29762 .60005 Mdot
.3 .60234 Mdot
.30238 .60332 Mdot
.30476 .60296 Mdot
.30714 .60129 Mdot
.30952 .5983 Mdot
.3119 .59405 Mdot
.31429 .58856 Mdot
.31667 .5819 Mdot
.31905 .57412 Mdot
.32143 .56529 Mdot
.32381 .55549 Mdot
.32619 .5448 Mdot
.32857 .53329 Mdot
.33095 .52106 Mdot
.33333 .50818 Mdot
.33571 .49475 Mdot
.3381 .48086 Mdot
.34048 .46657 Mdot
.34286 .45197 Mdot
.34524 .43714 Mdot
.34762 .42215 Mdot
.35 .40706 Mdot
.35238 .39192 Mdot
.35476 .3768 Mdot
.35714 .36175 Mdot
.35952 .3468 Mdot
.3619 .332 Mdot
.36429 .31737 Mdot
.36667 .30296 Mdot
.36905 .28879 Mdot
.37143 .27488 Mdot
.37381 .26125 Mdot
.37619 .24792 Mdot
.37857 .23491 Mdot
.38095 .22222 Mdot
.38333 .20987 Mdot
.38571 .19786 Mdot
.3881 .1862 Mdot
.39048 .17491 Mdot
.39286 .16398 Mdot
.39524 .15341 Mdot
.39762 .14322 Mdot
.4 .13339 Mdot
.40238 .12395 Mdot
.40476 .11487 Mdot
.40714 .10618 Mdot
.40952 .09786 Mdot
.4119 .08992 Mdot
.41429 .08236 Mdot
.41667 .07517 Mdot
.41905 .06835 Mdot
.42143 .06191 Mdot
.42381 .05584 Mdot
.42619 .05014 Mdot
.42857 .0448 Mdot
.43095 .03981 Mdot
.43333 .03519 Mdot
.43571 .03091 Mdot
.4381 .02698 Mdot
.44048 .02339 Mdot
.44286 .02012 Mdot
.44524 .01719 Mdot
.44762 .01504 Mdot
.45 .01723 Mdot
.45238 .01927 Mdot
.45476 .02102 Mdot
.45714 .02251 Mdot
.45952 .02374 Mdot
.4619 .02474 Mdot
.46429 .0255 Mdot
.46667 .02605 Mdot
.46905 .02641 Mdot
.47143 .02658 Mdot
.47381 .02658 Mdot
.47619 .02644 Mdot
.47857 .02615 Mdot
.48095 .02575 Mdot
.48333 .02525 Mdot
.48571 .02466 Mdot
.4881 .024 Mdot
.49048 .02329 Mdot
.49286 .02253 Mdot
.49524 .02175 Mdot
.49762 .02095 Mdot
.5 .02015 Mdot
.50238 .01936 Mdot
.50476 .01859 Mdot
.50714 .01786 Mdot
.50952 .01717 Mdot
.5119 .01654 Mdot
.51429 .016 Mdot
.51667 .0156 Mdot
.51905 .01546 Mdot
.52143 .0156 Mdot
.52381 .01585 Mdot
.52619 .01611 Mdot
.52857 .01634 Mdot
.53095 .01652 Mdot
.53333 .01665 Mdot
.53571 .01672 Mdot
.5381 .01675 Mdot
.54048 .01674 Mdot
.54286 .01669 Mdot
.54524 .0166 Mdot
.54762 .01648 Mdot
.55 .01634 Mdot
.55238 .01618 Mdot
.55476 .01601 Mdot
.55714 .01583 Mdot
.55952 .01565 Mdot
.5619 .01547 Mdot
.56429 .01531 Mdot
.56667 .01518 Mdot
.56905 .01508 Mdot
.57143 .01503 Mdot
.57381 .01504 Mdot
.57619 .01509 Mdot
.57857 .01514 Mdot
.58095 .01519 Mdot
.58333 .01523 Mdot
.58571 .01525 Mdot
.5881 .01526 Mdot
.59048 .01525 Mdot
.59286 .01523 Mdot
.59524 .0152 Mdot
.59762 .01516 Mdot
.6 .01511 Mdot
.60238 .01506 Mdot
.60476 .01501 Mdot
.60714 .01495 Mdot
.60952 .01491 Mdot
.6119 .01487 Mdot
.61429 .01485 Mdot
.61667 .01484 Mdot
.61905 .01485 Mdot
.62143 .01487 Mdot
.62381 .01488 Mdot
.62619 .01489 Mdot
.62857 .01489 Mdot
.63095 .01489 Mdot
.63333 .01489 Mdot
.63571 .01488 Mdot
.6381 .01487 Mdot
.64048 .01485 Mdot
.64286 .01483 Mdot
.64524 .01481 Mdot
.64762 .0148 Mdot
.65 .01478 Mdot
.65238 .01477 Mdot
.65476 .01477 Mdot
.65714 .01477 Mdot
.65952 .01478 Mdot
.6619 .01478 Mdot
.66429 .01478 Mdot
.66667 .01478 Mdot
.66905 .01478 Mdot
.67143 .01478 Mdot
.67381 .01477 Mdot
.67619 .01477 Mdot
.67857 .01476 Mdot
.68095 .01475 Mdot
.68333 .01475 Mdot
.68571 .01474 Mdot
.6881 .01474 Mdot
.69048 .01474 Mdot
.69286 .01474 Mdot
.69524 .01474 Mdot
.69762 .01474 Mdot
.7 .01474 Mdot
.70238 .01474 Mdot
.70476 .01474 Mdot
.70714 .01474 Mdot
.70952 .01474 Mdot
.7119 .01473 Mdot
.71429 .01473 Mdot
.71667 .01473 Mdot
.71905 .01473 Mdot
.72143 .01473 Mdot
.72381 .01473 Mdot
.72619 .01473 Mdot
.72857 .01473 Mdot
.73095 .01473 Mdot
.73333 .01473 Mdot
.73571 .01473 Mdot
.7381 .01473 Mdot
.74048 .01473 Mdot
.74286 .01472 Mdot
.74524 .01472 Mdot
.74762 .01472 Mdot
.75 .01472 Mdot
.75238 .01472 Mdot
.75476 .01472 Mdot
.75714 .01472 Mdot
.75952 .01472 Mdot
.7619 .01472 Mdot
.76429 .01472 Mdot
.76667 .01472 Mdot
.76905 .01472 Mdot
.77143 .01472 Mdot
.77381 .01472 Mdot
.77619 .01472 Mdot
.77857 .01472 Mdot
.78095 .01472 Mdot
.78333 .01472 Mdot
.78571 .01472 Mdot
.7881 .01472 Mdot
.79048 .01472 Mdot
.79286 .01472 Mdot
.79524 .01472 Mdot
.79762 .01472 Mdot
.8 .01472 Mdot
.80238 .01472 Mdot
.80476 .01472 Mdot
.80714 .01472 Mdot
.80952 .01472 Mdot
.8119 .01472 Mdot
.81429 .01472 Mdot
.81667 .01472 Mdot
.81905 .01472 Mdot
.82143 .01472 Mdot
.82381 .01472 Mdot
.82619 .01472 Mdot
.82857 .01472 Mdot
.83095 .01472 Mdot
.83333 .01472 Mdot
.83571 .01472 Mdot
.8381 .01472 Mdot
.84048 .01472 Mdot
.84286 .01472 Mdot
.84524 .01472 Mdot
.84762 .01472 Mdot
.85 .01472 Mdot
.85238 .01473 Mdot
.85476 .01473 Mdot
.85714 .01473 Mdot
.85952 .01474 Mdot
.8619 .01474 Mdot
.86429 .01474 Mdot
.86667 .01475 Mdot
.86905 .01475 Mdot
.87143 .01475 Mdot
.87381 .01475 Mdot
.87619 .01475 Mdot
.87857 .01475 Mdot
.88095 .01476 Mdot
.88333 .01475 Mdot
.88571 .01476 Mdot
.8881 .01476 Mdot
.89048 .01476 Mdot
.89286 .01477 Mdot
.89524 .01478 Mdot
.89762 .01479 Mdot
.9 .01481 Mdot
.90238 .01482 Mdot
.90476 .01483 Mdot
.90714 .01485 Mdot
.90952 .01486 Mdot
.9119 .01487 Mdot
.91429 .01488 Mdot
.91667 .01489 Mdot
.91905 .0149 Mdot
.92143 .0149 Mdot
.92381 .0149 Mdot
.92619 .0149 Mdot
.92857 .0149 Mdot
.93095 .0149 Mdot
.93333 .01491 Mdot
.93571 .01493 Mdot
.9381 .01495 Mdot
.94048 .01498 Mdot
.94286 .01502 Mdot
.94524 .01507 Mdot
.94762 .01512 Mdot
.95 .01517 Mdot
.95238 .01522 Mdot
.95476 .01527 Mdot
.95714 .01531 Mdot
.95952 .01535 Mdot
.9619 .01538 Mdot
.96429 .0154 Mdot
.96667 .01541 Mdot
.96905 .01541 Mdot
.97143 .0154 Mdot
.97381 .01538 Mdot
.97619 .01536 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[26]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00C@3oool4000000<0oooo0P0000040?ooo`800000
<@3oool4000000<0oooo0P0000040?ooo`800000<P3oool2000000@0oooo0P0000040?ooo`800000
=03oool00`000000oooo0?ooo`020?ooo`800000103oool2000000<0oooo001?0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
00000300oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000003<0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo
00000080oooo0@0000010?ooo`40oooo001?0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000003<0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo02h0oooo1@000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool004l0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool0<03oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`0_0?ooo`8000000`3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo00000300oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo001?0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo0340oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0340oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
001=0?ooo`<000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000300
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000300oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000380oooo0P0000030?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool001D0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`02
0?ooo`800000103oool200000380oooo0P0000040?ooo`800000103oool200000380oooo0P000004
0?ooo`800000103oool2000003@0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P000003
0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0
oooo2@3oool001D0oooo00<000000?ooo`3oool0[@3oooli00000280oooo000>0?ooool000004000
00030?ooo`005@3ooolH00000080oooo00<000000?ooo`3oool0103oool6000000`0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`D000002@3ooold00000080oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0000000H000000T0oooo000E0?ooo`030000003oool0oooo
0180oooo1`0000030?ooo`H0000000<0oooo000000000000603oool00`000000oooo0?ooo`0]0?oo
o`8000000P3oool400000080oooo2@00000m0?ooo`030000003oool0oooo03h0oooo00<000000?oo
o`3oool01`3oool001D0oooo00<000000?ooo`3oool05@3oool;000000<0oooo0P0000170?ooo`<0
00000`3oool;000008/0oooo000E0?ooo`030000003oool0oooo01T0oooo1@0000060?ooo`800000
A@3oool3000000L0oooo1000002?0?ooo`005@3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo04<0oooo0P00002K0?ooo`005@3oool00`000000oooo0?ooo`0U0?ooo`800000@`3oool3
000009/0oooo000E0?ooo`030000003oool0oooo02D0oooo0P0000140?ooo`030000003oool0oooo
09X0oooo000E0?ooo`030000003oool0oooo02H0oooo0P0000110?ooo`800000W@3oool001D0oooo
00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0o0?ooo`800000W@3oool001D0oooo0P00
000X0?ooo`800000@@3oool00`000000oooo0?ooo`2K0?ooo`005@3oool00`000000oooo0?ooo`0W
0?ooo`800000?`3oool2000009h0oooo000E0?ooo`030000003oool0oooo02P0oooo00<000000?oo
o`3oool0?03oool3000009h0oooo000E0?ooo`030000003oool0oooo02P0oooo0P00000n0?ooo`03
0000003oool0oooo09d0oooo000E0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
>`3oool2000009l0oooo000E0?ooo`030000003oool0oooo02T0oooo0P00000m0?ooo`030000003o
ool0oooo09d0oooo000E0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0>@3oool2
00000:00oooo000E0?ooo`030000003oool0oooo02T0oooo0P00000l0?ooo`030000003oool0oooo
09h0oooo000E0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0>@3oool200000:00
oooo000E0?ooo`800000:`3oool2000003/0oooo00<000000?ooo`3oool0WP3oool001D0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`0g0?ooo`800000X@3oool001D0oooo00<00000
0?ooo`3oool0:`3oool2000003T0oooo00<000000?ooo`3oool0W`3oool001D0oooo00<000000?oo
o`3oool0;03oool00`000000oooo0?ooo`0e0?ooo`800000XP3oool001D0oooo00<000000?ooo`3o
ool0:`3oool2000003P0oooo00<000000?ooo`3oool0X03oool001D0oooo00<000000?ooo`3oool0
;03oool00`000000oooo0?ooo`0e0?ooo`800000XP3oool001D0oooo00<000000?ooo`3oool0;03o
ool2000003L0oooo00<000000?ooo`3oool0X03oool001D0oooo00<000000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`0c0?ooo`800000X`3oool001D0oooo00<000000?ooo`3oool0I03oool00`00
0000oooo0?ooo`2Q0?ooo`005@3oool00`000000oooo0?ooo`0/0?ooo`800000fP3oool001D0oooo
0P00000^0?ooo`030000003oool0oooo0380oooo0P00002T0?ooo`005@3oool00`000000oooo0?oo
o`0]0?ooo`800000=03oool00`000000oooo0?ooo`2R0?ooo`005@3oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo0340oooo0P00002T0?ooo`005@3oool00`000000oooo0?ooo`1S0?oo
o`030000003oool0oooo0:80oooo000E0?ooo`030000003oool0oooo02h0oooo0P00003H0?ooo`00
5@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo02l0oooo0P00002U0?ooo`005@3o
ool00`000000oooo0?ooo`0^0?ooo`800000<P3oool00`000000oooo0?ooo`2S0?ooo`000P3oool2
000000@0oooo00<000000?ooo`3oool00P3oool4000000@0oooo00<000000?ooo`3oool0;`3oool0
0`000000oooo0?ooo`3F0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0H03oool200000:H0oooo00001@3oool000000?ooo`3oool0
000000T0oooo00<000000?ooo`3oool0103oool3000002l0oooo0P00000`0?ooo`030000003oool0
oooo0:@0oooo00001@3oool000000?ooo`3oool0000000X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0=D0oooo00001@3oool000000?ooo`3oool0
000000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1P0?ooo`800000YP3oool0
00050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0300oooo0P00000_0?ooo`030000003oool0oooo0:@0oooo00020?ooo`8000002P3oool2
000000D0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`3D0?ooo`005@3oool00`00
0000oooo0?ooo`1O0?ooo`800000Y`3oool001D0oooo00<000000?ooo`3oool0<03oool2000002h0
oooo00<000000?ooo`3oool0Y@3oool001D0oooo00<000000?ooo`3oool0<@3oool00`000000oooo
0?ooo`3D0?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`800000Z03oool001D0oooo00<00000
0?ooo`3oool0<@3oool2000002`0oooo00<000000?ooo`3oool0YP3oool001D0oooo0P00000c0?oo
o`030000003oool0oooo0=<0oooo000E0?ooo`030000003oool0oooo05h0oooo0P00002X0?ooo`00
5@3oool00`000000oooo0?ooo`0b0?ooo`800000:`3oool00`000000oooo0?ooo`2V0?ooo`005@3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0=80oooo000E0?ooo`030000003oool0
oooo05d0oooo0P00002Y0?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo
0:L0oooo000E0?ooo`030000003oool0oooo0380oooo0P00003D0?ooo`005@3oool00`000000oooo
0?ooo`0c0?ooo`030000003oool0oooo02L0oooo0P00002Y0?ooo`005@3oool00`000000oooo0?oo
o`1N0?ooo`030000003oool0oooo0:L0oooo000E0?ooo`030000003oool0oooo03<0oooo0P00003C
0?ooo`005@3oool2000003D0oooo00<000000?ooo`3oool0d@3oool001D0oooo00<000000?ooo`3o
ool0G03oool200000:X0oooo000E0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0
Z03oool001D0oooo00<000000?ooo`3oool0<`3oool200000=<0oooo000E0?ooo`030000003oool0
oooo03@0oooo00<000000?ooo`3oool0903oool200000:/0oooo000E0?ooo`030000003oool0oooo
05`0oooo00<000000?ooo`3oool0Z@3oool001D0oooo00<000000?ooo`3oool0=03oool200000=80
oooo000E0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0d03oool001D0oooo00<0
00000?ooo`3oool0F`3oool200000:/0oooo000E0?ooo`800000G@3oool00`000000oooo0?ooo`2Y
0?ooo`005@3oool00`000000oooo0?ooo`0e0?ooo`800000d@3oool001D0oooo00<000000?ooo`3o
ool0=P3oool00`000000oooo0?ooo`3?0?ooo`005@3oool00`000000oooo0?ooo`1J0?ooo`800000
[03oool001D0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`2Z0?ooo`005@3oool0
0`000000oooo0?ooo`0e0?ooo`800000d@3oool001D0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0P0?ooo`800000[@3oool001D0oooo00<000000?ooo`3oool0FP3oool00`000000
oooo0?ooo`2[0?ooo`000P3oool2000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo03H0oooo0P00003@0?ooo`0000D0oooo0000003oool0oooo
0000000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0=`3oool00`000000oooo
0?ooo`3>0?ooo`0000D0oooo0000003oool0oooo000000070?ooo`D00000103oool3000005T0oooo
0P00002]0?ooo`0000D0oooo0000003oool0oooo000000070?ooo`040000003oool0oooo000000D0
oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`2[0?ooo`0000D0oooo0000003oool0
oooo000000080?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0=`3oool200000<l0
oooo00001@3oool000000?ooo`3oool0000000T0oooo0P0000050?ooo`030000003oool0oooo03P0
oooo00<000000?ooo`3oool0c@3oool00080oooo0P00000;0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0F03oool200000:h0oooo000E0?ooo`030000003oool0oooo05T0oooo00<0
00000?ooo`3oool0[03oool001D0oooo00<000000?ooo`3oool0=`3oool200000<l0oooo000E0?oo
o`030000003oool0oooo03P0oooo00<000000?ooo`3oool0c@3oool001D0oooo00<000000?ooo`3o
ool0E`3oool200000:l0oooo000E0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool0
[@3oool001D0oooo0P00000i0?ooo`800000cP3oool001D0oooo00<000000?ooo`3oool0>@3oool0
0`000000oooo0?ooo`3<0?ooo`005@3oool00`000000oooo0?ooo`1G0?ooo`800000[`3oool001D0
oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`2]0?ooo`005@3oool00`000000oooo
0?ooo`0i0?ooo`800000c@3oool001D0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`3;0?ooo`005@3oool00`000000oooo0?ooo`1F0?ooo`800000/03oool001D0oooo00<000000?oo
o`3oool0E`3oool00`000000oooo0?ooo`2^0?ooo`005@3oool00`000000oooo0?ooo`0i0?ooo`80
0000c@3oool001D0oooo0P00000k0?ooo`030000003oool0oooo0</0oooo000E0?ooo`030000003o
ool0oooo05D0oooo0P00002a0?ooo`005@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0
oooo0:l0oooo000E0?ooo`030000003oool0oooo03X0oooo0P00003<0?ooo`005@3oool00`000000
oooo0?ooo`0k0?ooo`030000003oool0oooo0<X0oooo000E0?ooo`030000003oool0oooo05D0oooo
0P00002a0?ooo`005@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0:l0oooo000E
0?ooo`030000003oool0oooo03/0oooo0P00003;0?ooo`005@3oool00`000000oooo0?ooo`0l0?oo
o`030000003oool0oooo0<T0oooo000E0?ooo`030000003oool0oooo05@0oooo0P00002b0?ooo`00
5@3oool2000005H0oooo00<000000?ooo`3oool0/03oool001D0oooo00<000000?ooo`3oool0>`3o
ool200000</0oooo000E0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0b@3oool0
01D0oooo00<000000?ooo`3oool0E03oool200000;80oooo000E0?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool0/03oool001D0oooo00<000000?ooo`3oool0?03oool200000<X0oooo
000E0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0b03oool00080oooo0P000004
0?ooo`030000003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo05<0oooo0P00002c
0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool0E03oool00`000000oooo0?ooo`2a0?ooo`0000D0oooo0000003oool0oooo0000
00080?ooo`040000003oool0oooo000000@0oooo0`00000l0?ooo`800000bP3oool000050?ooo`00
0000oooo0?ooo`000000203oool3000000D0oooo00<000000?ooo`3oool0?@3oool00`000000oooo
0?ooo`380?ooo`0000D0oooo0000003oool0oooo000000080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0DP3oool200000;@0oooo00001@3oool000000?ooo`3oool0000000P0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0;80oooo
00020?ooo`8000002P3oool3000000@0oooo00<000000?ooo`3oool0?@3oool200000<T0oooo000E
0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0a`3oool001D0oooo00<000000?oo
o`3oool0DP3oool200000;@0oooo000E0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3o
ool0/P3oool001D0oooo00<000000?ooo`3oool0?P3oool200000<P0oooo000E0?ooo`030000003o
ool0oooo03l0oooo00<000000?ooo`3oool0aP3oool001D0oooo0P00001B0?ooo`800000]@3oool0
01D0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`2c0?ooo`005@3oool00`000000
oooo0?ooo`0n0?ooo`800000b03oool001D0oooo00<000000?ooo`3oool0?`3oool00`000000oooo
0?ooo`360?ooo`005@3oool00`000000oooo0?ooo`1@0?ooo`800000]P3oool001D0oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`2d0?ooo`005@3oool00`000000oooo0?ooo`0o0?oo
o`800000a`3oool001D0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0=0?ooo`80
0000]P3oool001D0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`2d0?ooo`005@3o
ool00`000000oooo0?ooo`100?ooo`800000aP3oool001D0oooo0P0000120?ooo`030000003oool0
oooo0<@0oooo000E0?ooo`030000003oool0oooo04l0oooo0P00002g0?ooo`005@3oool00`000000
oooo0?ooo`1@0?ooo`030000003oool0oooo0;D0oooo000E0?ooo`030000003oool0oooo0400oooo
0P0000360?ooo`005@3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00X0oooo0P00
002h0?ooo`005@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo0;H0oooo000E0?oo
o`030000003oool0oooo0440oooo0P0000350?ooo`005@3oool00`000000oooo0?ooo`120?ooo`03
0000003oool0oooo00T0oooo0P00002h0?ooo`005@3oool00`000000oooo0?ooo`1?0?ooo`030000
003oool0oooo0;H0oooo000E0?ooo`800000@`3oool200000<@0oooo000E0?ooo`030000003oool0
oooo04<0oooo00<000000?ooo`3oool01`3oool200000;T0oooo000E0?ooo`030000003oool0oooo
04h0oooo00<000000?ooo`3oool0]`3oool001D0oooo00<000000?ooo`3oool0@P3oool200000<@0
oooo000E0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool01`3oool200000;T0oooo
000E0?ooo`030000003oool0oooo04<0oooo0P0000090?ooo`030000003oool0oooo0;L0oooo000E
0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool01@3oool200000;X0oooo000E0?oo
o`030000003oool0oooo04@0oooo0P0000070?ooo`030000003oool0oooo0;P0oooo00020?ooo`80
0000103oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`150?ooo`03
0000003oool0oooo00<0oooo0P00002k0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0A03oool2000000H0oooo00<000000?oo
o`3oool0^@3oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`000004
0?ooo`<00000A@3oool00`000000oooo0?ooo`030?ooo`800000^`3oool000050?ooo`000000oooo
0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0A@3oool2000000D0oooo00<00000
0?ooo`3oool0^@3oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo04D0oooo0P0000030?ooo`800000_03oool000050?ooo`000000
oooo0?ooo`000000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo04H0oooo
0P000000103oool0000000000000002l0?ooo`000P3oool2000000X0oooo0P0000050?ooo`030000
003oool0oooo04L0oooo1000002m0?ooo`005@3oool00`000000oooo0?ooo`180?ooo`<00000_@3o
ool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?oo
o`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 358.75}, {221.125, 0}} -> {-33.3079, -0.0694641, \
1.55867, 0.00519655}}]
}, Open  ]],

Cell[TextData[{
  "This plot does not show the correspondence with the x-grid values \
correctly. To get the correspondence with the spatial grid correctly, you \
must use ",
  StyleBox["NDSolve`ProcessSolutions", "MR"],
  ". "
}], "Text"],

Cell["\<\
There is a tremendous amount of control provided by these methods, \
but an exhaustive set of examples is beyond the scope of this \
documentation.\
\>", "Text"],

Cell[TextData[{
  "One of the most important uses of the information from an ",
  StyleBox["NDSolve`StateData", "MR"],
  " object is to initialize integration methods. Examples are shown in the \
section describing ",
  ButtonBox["The Method Plug-in Framework",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "DifferentialEquations"}, 
        "Plug-ins.nb"], "c:1"},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StateData",
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[1837, 57, 72, 1, 66, "Section",
      CellTags->"c:1"]},
  "c:2"->{
    Cell[1934, 62, 83, 1, 40, "Subsection",
      CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"}]},
  "b:12.0"->{
    Cell[1934, 62, 83, 1, 40, "Subsection",
      CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"}]},
  "ndsg:5.0.0"->{
    Cell[1934, 62, 83, 1, 40, "Subsection",
      CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"}]},
  "c:3"->{
    Cell[17826, 489, 79, 1, 70, "Subsection",
      CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"}]},
  "b:12.1"->{
    Cell[17826, 489, 79, 1, 70, "Subsection",
      CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"}]},
  "ndsg:5.0.1"->{
    Cell[17826, 489, 79, 1, 70, "Subsection",
      CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"}]},
  "c:4"->{
    Cell[21811, 621, 79, 1, 70, "Section",
      CellTags->{"c:4", "b:13", "ndsg:5.1"}]},
  "b:13"->{
    Cell[21811, 621, 79, 1, 70, "Section",
      CellTags->{"c:4", "b:13", "ndsg:5.1"}]},
  "ndsg:5.1"->{
    Cell[21811, 621, 79, 1, 70, "Section",
      CellTags->{"c:4", "b:13", "ndsg:5.1"}]},
  "c:5"->{
    Cell[27962, 832, 86, 1, 70, "Section",
      CellTags->{"c:5", "b:14", "ndsg:5.2"}],
    Cell[148899, 3511, 101, 1, 70, "Section",
      CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"}]},
  "b:14"->{
    Cell[27962, 832, 86, 1, 70, "Section",
      CellTags->{"c:5", "b:14", "ndsg:5.2"}],
    Cell[148899, 3511, 101, 1, 70, "Section",
      CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"}]},
  "ndsg:5.2"->{
    Cell[27962, 832, 86, 1, 70, "Section",
      CellTags->{"c:5", "b:14", "ndsg:5.2"}],
    Cell[148899, 3511, 101, 1, 70, "Section",
      CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"}]},
  "Integration directions"->{
    Cell[90588, 2200, 765, 25, 70, "DefinitionBox",
      CellTags->"Integration directions"]},
  "statemethods"->{
    Cell[148899, 3511, 101, 1, 70, "Section",
      CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 187252, 4705},
  {"c:2", 187329, 4708},
  {"b:12.0", 187438, 4711},
  {"ndsg:5.0.0", 187551, 4714},
  {"c:3", 187657, 4717},
  {"b:12.1", 187768, 4720},
  {"ndsg:5.0.1", 187883, 4723},
  {"c:4", 187991, 4726},
  {"b:13", 188093, 4729},
  {"ndsg:5.1", 188199, 4732},
  {"c:5", 188300, 4735},
  {"b:14", 188510, 4740},
  {"ndsg:5.2", 188724, 4745},
  {"Integration directions", 188952, 4750},
  {"statemethods", 189068, 4753}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 36, 0, 95, "Chapter"],

Cell[CellGroupData[{
Cell[1837, 57, 72, 1, 66, "Section",
  CellTags->"c:1"],

Cell[CellGroupData[{
Cell[1934, 62, 83, 1, 40, "Subsection",
  CellTags->{"c:2", "b:12.0", "ndsg:5.0.0"}],
Cell[2020, 65, 799, 14, 120, "Text"],
Cell[2822, 81, 13697, 354, 246, "DefinitionBox"],
Cell[16522, 437, 96, 4, 70, "Caption"],
Cell[16621, 443, 280, 10, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[16926, 457, 160, 3, 70, "Input"],
Cell[17089, 462, 688, 21, 70, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17826, 489, 79, 1, 70, "Subsection",
  CellTags->{"c:3", "b:12.1", "ndsg:5.0.1"}],
Cell[17908, 492, 414, 7, 70, "Text"],
Cell[18325, 501, 1044, 30, 70, "DefinitionBox"],
Cell[19372, 533, 47, 0, 70, "Caption"],
Cell[19422, 535, 136, 4, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[19583, 543, 228, 5, 70, "Input"],
Cell[19814, 550, 288, 8, 70, "Output"]
}, Open  ]],
Cell[20117, 561, 157, 4, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[20299, 569, 183, 5, 70, "Input"],
Cell[20485, 576, 990, 30, 70, "Output"]
}, Open  ]],
Cell[21490, 609, 272, 6, 70, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21811, 621, 79, 1, 70, "Section",
  CellTags->{"c:4", "b:13", "ndsg:5.1"}],
Cell[21893, 624, 282, 6, 70, "Text"],
Cell[22178, 632, 781, 21, 70, "DefinitionBox"],
Cell[22962, 655, 66, 0, 70, "Caption"],
Cell[23031, 657, 251, 5, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[23307, 666, 343, 7, 70, "Input"],
Cell[23653, 675, 288, 8, 70, "Output"]
}, Open  ]],
Cell[23956, 686, 474, 10, 70, "Text"],
Cell[24433, 698, 131, 5, 70, "MathCaption"],
Cell[24567, 705, 84, 2, 70, "Input"],
Cell[24654, 709, 755, 24, 70, "Text"],
Cell[25412, 735, 188, 5, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[25625, 744, 62, 2, 70, "Input"],
Cell[25690, 748, 340, 9, 70, "Output"]
}, Open  ]],
Cell[26045, 760, 164, 4, 70, "Text"],
Cell[26212, 766, 131, 5, 70, "MathCaption"],
Cell[26346, 773, 84, 2, 70, "Input"],
Cell[26433, 777, 166, 4, 70, "Text"],
Cell[26602, 783, 210, 8, 70, "MathCaption"],
Cell[26815, 793, 92, 2, 70, "Input"],
Cell[26910, 797, 597, 15, 70, "Text"],
Cell[27510, 814, 315, 9, 70, "MathCaption"],
Cell[27828, 825, 97, 2, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27962, 832, 86, 1, 70, "Section",
  CellTags->{"c:5", "b:14", "ndsg:5.2"}],
Cell[28051, 835, 334, 7, 70, "Text"],
Cell[28388, 844, 645, 19, 70, "DefinitionBox"],
Cell[29036, 865, 115, 4, 70, "Caption"],
Cell[29154, 871, 162, 4, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[29341, 879, 99, 2, 70, "Input"],
Cell[29443, 883, 267, 7, 70, "Output"]
}, Open  ]],
Cell[29725, 893, 47, 0, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[29797, 897, 129, 3, 70, "Input"],
Cell[29929, 902, 58265, 1214, 70, 8825, 598, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[88209, 2119, 397, 12, 70, "Text"],
Cell[88609, 2133, 772, 24, 70, "DefinitionBox"],
Cell[89384, 2159, 57, 0, 70, "Caption"],
Cell[89444, 2161, 113, 3, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[89582, 2168, 114, 2, 70, "Input"],
Cell[89699, 2172, 573, 13, 70, "Output"]
}, Open  ]],
Cell[90287, 2188, 298, 10, 70, "Text"],
Cell[90588, 2200, 765, 25, 70, "DefinitionBox",
  CellTags->"Integration directions"],
Cell[91356, 2227, 57, 0, 70, "Caption"],
Cell[91416, 2229, 426, 8, 70, "Text"],
Cell[91845, 2239, 209, 8, 70, "MathCaption"],
Cell[92057, 2249, 393, 7, 70, "Input"],
Cell[92453, 2258, 119, 5, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[92597, 2267, 106, 2, 70, "Input"],
Cell[92706, 2271, 661, 18, 70, "Output"]
}, Open  ]],
Cell[93382, 2292, 210, 7, 70, "Text"],
Cell[93595, 2301, 122, 5, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[93742, 2310, 107, 2, 70, "Input"],
Cell[93852, 2314, 513, 8, 70, "Message"],
Cell[94368, 2324, 686, 19, 70, "Output"]
}, Open  ]],
Cell[95069, 2346, 614, 13, 70, "Text"],
Cell[95686, 2361, 127, 5, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[95838, 2370, 116, 2, 70, "Input"],
Cell[95957, 2374, 50614, 1076, 70, 8666, 553, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[146586, 3453, 97, 3, 70, "Text"],
Cell[146686, 3458, 425, 9, 70, "Text"],
Cell[147114, 3469, 191, 4, 70, "MathCaption"],
Cell[147308, 3475, 1252, 23, 70, "Input"],
Cell[148563, 3500, 299, 6, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[148899, 3511, 101, 1, 70, "Section",
  CellTags->{"c:5", "b:14", "ndsg:5.2", "statemethods"}],
Cell[149003, 3514, 463, 8, 70, "Text"],
Cell[149469, 3524, 4831, 139, 70, "DefinitionBox"],
Cell[154303, 3665, 154, 6, 70, "Caption"],
Cell[154460, 3673, 384, 7, 70, "Text"],
Cell[154847, 3682, 2846, 80, 70, "DefinitionBox"],
Cell[157696, 3764, 158, 6, 70, "Caption"],
Cell[157857, 3772, 487, 16, 70, "Text"],
Cell[158347, 3790, 240, 8, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[158612, 3802, 514, 9, 70, "Input"],
Cell[159129, 3813, 341, 9, 70, "Output"]
}, Open  ]],
Cell[159485, 3825, 141, 3, 70, "Text"],
Cell[159629, 3830, 105, 3, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[159759, 3837, 83, 2, 70, "Input"],
Cell[159845, 3841, 69, 2, 70, "Output"]
}, Open  ]],
Cell[159929, 3846, 115, 3, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[160069, 3853, 82, 2, 70, "Input"],
Cell[160154, 3857, 62, 2, 70, "Output"]
}, Open  ]],
Cell[160231, 3862, 396, 9, 70, "Text"],
Cell[160630, 3873, 111, 3, 70, "MathCaption"],

Cell[CellGroupData[{
Cell[160766, 3880, 113, 2, 70, "Input"],
Cell[160882, 3884, 24703, 768, 70, 10019, 582, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[185600, 4655, 239, 6, 70, "Text"],
Cell[185842, 4663, 171, 4, 70, "Text"],
Cell[186016, 4669, 502, 12, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

