(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    103780,       3720]*)
(*NotebookOutlinePosition[    105051,       3768]*)
(*  CellTagsIndexPosition[    104905,       3759]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["StiffnessSwitching", "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"s:1"],

Cell[TextData[{
  "The basic idea behind the ",
  StyleBox["StiffnessSwitching", "MR"],
  " method is to provide an automatic means of switching between a nonstiff \
and a stiff solver."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["StiffnessTest", "MR"],
  " option",
  " ",
  "(described within ",
  ButtonBox["StiffnessTest",
    ButtonData:>{"StiffnessTest.nb", None},
    ButtonStyle->"Hyperlink"],
  ") provides a useful means of detecting when a problem appears to be \
stiff."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["StiffnessSwitching", "MR"],
  " method traps any failure code generated by ",
  StyleBox["StiffnessTest", "MR"],
  " and switches to an alternative solver."
}], "Text"],

Cell[TextData[{
  StyleBox["Extrapolation", "MR"],
  " provides a powerful technique for computing highly accurate solutions \
using dynamic order and step size selection (see ",
  ButtonBox["Extrapolation",
    ButtonData:>{"Extrapolation.nb", None},
    ButtonStyle->"Hyperlink"],
  " for more details) and are therefore used as the default choice in ",
  StyleBox["StiffnessSwitching", "MR"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
  CellTags->"s:2"],

Cell["This loads some useful packages.", "MathCaption"],

Cell[BoxData[{
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Needs["\<DifferentialEquations`NDSolveUtilities`\>"];\)\)}], "Input",
  CellLabel->"In[3]:=",
  InitializationCell->True],

Cell[TextData[{
  "This selects a stiff problem and specifies a longer integration time \
interval than the default specified by ",
  StyleBox["NDSolveProblem", "MR"],
  "."
}], "MathCaption"],

Cell[BoxData[{
    \(\(system\  = \ 
        GetNDSolveProblem["\<VanderPol\>"];\)\), "\[IndentingNewLine]", 
    \(\(time\  = \ {T, \ 0, \ 10};\)\)}], "Input",
  CellLabel->"In[5]:="],

Cell[TextData[{
  "The default ",
  StyleBox["Extrapolation", "MR"],
  " base method is not appropriate for stiff problems and gives up quite \
quickly."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[system, time, Method \[Rule] Extrapolation]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndstf"\), \(\(:\)\(\ \)\), "\<\"At \\!\\(T\\) == \
\\!\\(0.016098761837576865`\\), system appears to be stiff. Methods \
Automatic, BDF or StiffnessSwitching may be more appropriate. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::ndstf\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[7]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.016098761837576865`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 0.016098761837576865`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "Instead of giving up, the ",
  StyleBox["StiffnessSwitching", "MR"],
  " method continues the integration with a stiff solver."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[system, time, Method \[Rule] StiffnessSwitching]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["StiffnessSwitching", "MR"],
  " method uses a pair of extrapolation methods as the default. The nonstiff \
solver uses the ",
  StyleBox["ExplicitModifiedMidpoint", "MR"],
  " base method, and the stiff solver uses the ",
  StyleBox["LinearlyImplicitEuler", "MR"],
  " base method."
}], "Text"],

Cell[TextData[{
  "For small values of the ",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " tolerances, it is sometimes be preferable to use an explicit Runge-Kutta \
method for the nonstiff solver."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["ExplicitRungeKutta", "MR"],
  " method eventually gives up when the problem is considered to be stiff."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[system, time, Method \[Rule] ExplicitRungeKutta, 
      AccuracyGoal \[Rule] 5, PrecisionGoal \[Rule] 5]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndstf"\), \(\(:\)\(\ \)\), "\<\"At \\!\\(T\\) == \
\\!\\(4.352222101400029`\\), system appears to be stiff. Methods Automatic, \
BDF or StiffnessSwitching may be more appropriate. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"NDSolve::ndstf\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[9]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 4.352222101400029`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 4.352222101400029`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
  "This sets the ",
  StyleBox["ExplicitRungeKutta", "MR"],
  " method as a submethod of ",
  StyleBox["StiffnessSwitching", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = \ 
      NDSolve[system, time, 
        Method \[Rule] {StiffnessSwitching, \ 
            Method \[Rule] {ExplicitRungeKutta, \ Automatic}}, \ 
        AccuracyGoal \[Rule] 5, PrecisionGoal \[Rule] 5]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 10.`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "A switch to the stiff solver occurs at ",
  Cell[BoxData[
      \(TraditionalForm\`T\  \[TildeTilde] \ 4.35\)]],
  " and a plot of the step sizes used shows that the stiff solver takes much \
larger steps."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StepDataPlot[sol]\)], "Input",
  CellLabel->"In[11]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0953484 0.0136074 16.4896 [
[.21451 .00111 -3 -9 ]
[.21451 .00111 3 0 ]
[.4052 .00111 -3 -9 ]
[.4052 .00111 3 0 ]
[.5959 .00111 -3 -9 ]
[.5959 .00111 3 0 ]
[.7866 .00111 -3 -9 ]
[.7866 .00111 3 0 ]
[.97729 .00111 -6 -9 ]
[.97729 .00111 6 0 ]
[.01131 .09606 -30 -4.5 ]
[.01131 .09606 0 4.5 ]
[.01131 .1785 -24 -4.5 ]
[.01131 .1785 0 4.5 ]
[.01131 .26095 -30 -4.5 ]
[.01131 .26095 0 4.5 ]
[.01131 .3434 -24 -4.5 ]
[.01131 .3434 0 4.5 ]
[.01131 .42585 -30 -4.5 ]
[.01131 .42585 0 4.5 ]
[.01131 .5083 -24 -4.5 ]
[.01131 .5083 0 4.5 ]
[.01131 .59074 -30 -4.5 ]
[.01131 .59074 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21451 .01361 m
.21451 .01986 L
s
[(2)] .21451 .00111 0 1 Mshowa
.4052 .01361 m
.4052 .01986 L
s
[(4)] .4052 .00111 0 1 Mshowa
.5959 .01361 m
.5959 .01986 L
s
[(6)] .5959 .00111 0 1 Mshowa
.7866 .01361 m
.7866 .01986 L
s
[(8)] .7866 .00111 0 1 Mshowa
.97729 .01361 m
.97729 .01986 L
s
[(10)] .97729 .00111 0 1 Mshowa
.125 Mabswid
.07148 .01361 m
.07148 .01736 L
s
.11916 .01361 m
.11916 .01736 L
s
.16683 .01361 m
.16683 .01736 L
s
.26218 .01361 m
.26218 .01736 L
s
.30985 .01361 m
.30985 .01736 L
s
.35753 .01361 m
.35753 .01736 L
s
.45288 .01361 m
.45288 .01736 L
s
.50055 .01361 m
.50055 .01736 L
s
.54823 .01361 m
.54823 .01736 L
s
.64357 .01361 m
.64357 .01736 L
s
.69125 .01361 m
.69125 .01736 L
s
.73892 .01361 m
.73892 .01736 L
s
.83427 .01361 m
.83427 .01736 L
s
.88194 .01361 m
.88194 .01736 L
s
.92962 .01361 m
.92962 .01736 L
s
.25 Mabswid
0 .01361 m
1 .01361 L
s
.02381 .09606 m
.03006 .09606 L
s
[(0.005)] .01131 .09606 1 0 Mshowa
.02381 .1785 m
.03006 .1785 L
s
[(0.01)] .01131 .1785 1 0 Mshowa
.02381 .26095 m
.03006 .26095 L
s
[(0.015)] .01131 .26095 1 0 Mshowa
.02381 .3434 m
.03006 .3434 L
s
[(0.02)] .01131 .3434 1 0 Mshowa
.02381 .42585 m
.03006 .42585 L
s
[(0.025)] .01131 .42585 1 0 Mshowa
.02381 .5083 m
.03006 .5083 L
s
[(0.03)] .01131 .5083 1 0 Mshowa
.02381 .59074 m
.03006 .59074 L
s
[(0.035)] .01131 .59074 1 0 Mshowa
.125 Mabswid
.02381 .0301 m
.02756 .0301 L
s
.02381 .04659 m
.02756 .04659 L
s
.02381 .06308 m
.02756 .06308 L
s
.02381 .07957 m
.02756 .07957 L
s
.02381 .11255 m
.02756 .11255 L
s
.02381 .12903 m
.02756 .12903 L
s
.02381 .14552 m
.02756 .14552 L
s
.02381 .16201 m
.02756 .16201 L
s
.02381 .19499 m
.02756 .19499 L
s
.02381 .21148 m
.02756 .21148 L
s
.02381 .22797 m
.02756 .22797 L
s
.02381 .24446 m
.02756 .24446 L
s
.02381 .27744 m
.02756 .27744 L
s
.02381 .29393 m
.02756 .29393 L
s
.02381 .31042 m
.02756 .31042 L
s
.02381 .32691 m
.02756 .32691 L
s
.02381 .35989 m
.02756 .35989 L
s
.02381 .37638 m
.02756 .37638 L
s
.02381 .39287 m
.02756 .39287 L
s
.02381 .40936 m
.02756 .40936 L
s
.02381 .44234 m
.02756 .44234 L
s
.02381 .45883 m
.02756 .45883 L
s
.02381 .47532 m
.02756 .47532 L
s
.02381 .49181 m
.02756 .49181 L
s
.02381 .52479 m
.02756 .52479 L
s
.02381 .54128 m
.02756 .54128 L
s
.02381 .55776 m
.02756 .55776 L
s
.02381 .57425 m
.02756 .57425 L
s
.02381 .60723 m
.02756 .60723 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01949 m
.02384 .01913 L
.02388 .01933 L
.02391 .01934 L
.02394 .01954 L
.02398 .01971 L
.02401 .01997 L
.02405 .02024 L
.02409 .02058 L
.02413 .02096 L
.02417 .02139 L
.02421 .02189 L
.02426 .02245 L
.02431 .0231 L
.02437 .02385 L
.02443 .02471 L
.02449 .02573 L
.02456 .02692 L
.02464 .02836 L
.02472 .0301 L
.02482 .03226 L
.02493 .03505 L
.02505 .03895 L
.0252 .04751 L
.02539 .04455 L
.02557 .0482 L
.02577 .04829 L
.02597 .05012 L
.02618 .0506 L
.0264 .05156 L
.02662 .05201 L
.02684 .05255 L
.02706 .05288 L
.02729 .05321 L
.02752 .05344 L
.02775 .05364 L
.02798 .05379 L
.02822 .05393 L
.02845 .05403 L
.02868 .05412 L
.02892 .05419 L
.02915 .05426 L
.02939 .05431 L
.02962 .05436 L
.02986 .0544 L
.03009 .05444 L
.03033 .05448 L
.03057 .05451 L
.0308 .05454 L
.03104 .05457 L
Mistroke
.03128 .0546 L
.03151 .05462 L
.03175 .05465 L
.03199 .05467 L
.03222 .0547 L
.03246 .05472 L
.0327 .05475 L
.03294 .05477 L
.03318 .0548 L
.03341 .05482 L
.03365 .05485 L
.03389 .05487 L
.03413 .05489 L
.03437 .05492 L
.03461 .05494 L
.03485 .05497 L
.03509 .05499 L
.03532 .05502 L
.03556 .05504 L
.0358 .05507 L
.03604 .05509 L
.03628 .05511 L
.03652 .05514 L
.03676 .05516 L
.037 .05519 L
.03724 .05521 L
.03748 .05524 L
.03773 .05526 L
.03797 .05529 L
.03821 .05531 L
.03845 .05534 L
.03869 .05536 L
.03893 .05539 L
.03917 .05542 L
.03941 .05544 L
.03966 .05547 L
.0399 .05549 L
.04014 .05552 L
.04038 .05554 L
.04063 .05557 L
.04087 .0556 L
.04111 .05562 L
.04135 .05565 L
.0416 .05567 L
.04184 .0557 L
.04208 .05573 L
.04233 .05575 L
.04257 .05578 L
.04281 .05581 L
.04306 .05583 L
Mistroke
.0433 .05586 L
.04355 .05589 L
.04379 .05591 L
.04404 .05594 L
.04428 .05597 L
.04453 .056 L
.04477 .05602 L
.04502 .05605 L
.04526 .05608 L
.04551 .05611 L
.04575 .05613 L
.046 .05616 L
.04624 .05619 L
.04649 .05622 L
.04674 .05625 L
.04698 .05628 L
.04723 .0563 L
.04748 .05633 L
.04772 .05636 L
.04797 .05639 L
.04822 .05642 L
.04847 .05645 L
.04871 .05648 L
.04896 .05651 L
.04921 .05653 L
.04946 .05656 L
.04971 .05659 L
.04996 .05662 L
.0502 .05665 L
.05045 .05668 L
.0507 .05671 L
.05095 .05674 L
.0512 .05677 L
.05145 .0568 L
.0517 .05683 L
.05195 .05686 L
.0522 .05689 L
.05245 .05693 L
.0527 .05696 L
.05295 .05699 L
.0532 .05702 L
.05345 .05705 L
.05371 .05708 L
.05396 .05711 L
.05421 .05714 L
.05446 .05718 L
.05471 .05721 L
.05496 .05724 L
.05522 .05727 L
.05547 .05731 L
Mistroke
.05572 .05734 L
.05597 .05737 L
.05623 .0574 L
.05648 .05744 L
.05673 .05747 L
.05699 .0575 L
.05724 .05754 L
.0575 .05757 L
.05775 .0576 L
.058 .05764 L
.05826 .05767 L
.05851 .05771 L
.05877 .05774 L
.05902 .05777 L
.05928 .05781 L
.05953 .05784 L
.05979 .05788 L
.06005 .05791 L
.0603 .05795 L
.06056 .05799 L
.06082 .05802 L
.06107 .05806 L
.06133 .05809 L
.06159 .05813 L
.06184 .05817 L
.0621 .0582 L
.06236 .05824 L
.06262 .05828 L
.06288 .05831 L
.06313 .05835 L
.06339 .05839 L
.06365 .05843 L
.06391 .05847 L
.06417 .0585 L
.06443 .05854 L
.06469 .05858 L
.06495 .05862 L
.06521 .05866 L
.06547 .0587 L
.06573 .05874 L
.06599 .05878 L
.06625 .05882 L
.06652 .05886 L
.06678 .0589 L
.06704 .05894 L
.0673 .05898 L
.06756 .05902 L
.06783 .05906 L
.06809 .05911 L
.06835 .05915 L
Mistroke
.06862 .05919 L
.06888 .05923 L
.06914 .05928 L
.06941 .05932 L
.06967 .05936 L
.06994 .05941 L
.0702 .05945 L
.07047 .05949 L
.07073 .05954 L
.071 .05958 L
.07126 .05963 L
.07153 .05967 L
.07179 .05972 L
.07206 .05977 L
.07233 .05981 L
.0726 .05986 L
.07286 .05991 L
.07313 .05996 L
.0734 .06 L
.07367 .06005 L
.07394 .0601 L
.0742 .06015 L
.07447 .0602 L
.07474 .06025 L
.07501 .0603 L
.07528 .06035 L
.07555 .0604 L
.07582 .06045 L
.07609 .06051 L
.07637 .06056 L
.07664 .06061 L
.07691 .06066 L
.07718 .06072 L
.07745 .06077 L
.07773 .06083 L
.078 .06088 L
.07827 .06094 L
.07855 .061 L
.07882 .06105 L
.07909 .06111 L
.07937 .06117 L
.07964 .06123 L
.07992 .06129 L
.0802 .06135 L
.08047 .06141 L
.08075 .06147 L
.08102 .06153 L
.0813 .0616 L
.08158 .06166 L
.08186 .06172 L
Mistroke
.08213 .06179 L
.08241 .06186 L
.08269 .06192 L
.08297 .06199 L
.08325 .06206 L
.08353 .06213 L
.08381 .0622 L
.08409 .06227 L
.08437 .06234 L
.08466 .06242 L
.08494 .06249 L
.08522 .06257 L
.0855 .06264 L
.08579 .06272 L
.08607 .0628 L
.08636 .06288 L
.08664 .06297 L
.08693 .06305 L
.08721 .06313 L
.0875 .06322 L
.08779 .06331 L
.08807 .0634 L
.08836 .06349 L
.08865 .06359 L
.08894 .06368 L
.08923 .06378 L
.08952 .06388 L
.08981 .06399 L
.0901 .06409 L
.09039 .0642 L
.09068 .06431 L
.09098 .06443 L
.09127 .06454 L
.09157 .06466 L
.09186 .06479 L
.09216 .06492 L
.09245 .06505 L
.09275 .06519 L
.09305 .06534 L
.09335 .06548 L
.09365 .06564 L
.09395 .0658 L
.09425 .06597 L
.09455 .06615 L
.09486 .06634 L
.09516 .06653 L
.09547 .06674 L
.09578 .06696 L
.09609 .06719 L
.0964 .06744 L
Mistroke
.09671 .06771 L
.09702 .068 L
.09733 .06831 L
.09765 .06864 L
.09797 .06901 L
.09829 .06941 L
.09861 .06986 L
.09894 .07036 L
.09926 .07091 L
.0996 .07155 L
.09993 .07228 L
.10027 .07313 L
.10061 .07414 L
.10096 .0754 L
.10132 .07708 L
.10169 .07974 L
.10207 .08654 L
.10249 .08292 L
.10289 .07376 L
.10324 .06893 L
.10356 .06268 L
.10385 .05747 L
.1041 .05251 L
.10432 .04843 L
.10453 .04573 L
.10471 .03296 L
.10482 .03055 L
.10492 .0289 L
.10501 .02565 L
.10508 .02356 L
.10514 .02279 L
.10519 .02251 L
.10524 .02286 L
.10529 .02134 L
.10534 .02295 L
.10539 .02047 L
.10543 .02086 L
.10547 .01922 L
.10551 .0194 L
.10554 .01889 L
.10557 .01881 L
.1056 .01859 L
.10563 .01849 L
.10566 .01837 L
.10569 .01829 L
.10571 .01822 L
.10574 .01817 L
.10577 .01813 L
.10579 .0181 L
.10582 .01807 L
Mistroke
.10584 .01806 L
.10587 .01805 L
.1059 .01805 L
.10592 .01806 L
.10595 .01808 L
.10597 .01811 L
.106 .01817 L
.10603 .01837 L
.10605 .01854 L
.10608 .01876 L
.10611 .01899 L
.10614 .01926 L
.10617 .01954 L
.10621 .01986 L
.10625 .02021 L
.10628 .0206 L
.10632 .02104 L
.10637 .02152 L
.10641 .02207 L
.10646 .02269 L
.10651 .02341 L
.10657 .02422 L
.10663 .02517 L
.1067 .02629 L
.10677 .02762 L
.10685 .02922 L
.10694 .03119 L
.10705 .03368 L
.10716 .03702 L
.1073 .0424 L
.10746 .04694 L
.10766 .04548 L
.10784 .04863 L
.10804 .04885 L
.10825 .05043 L
.10846 .0509 L
.10868 .05174 L
.1089 .05216 L
.10912 .05263 L
.10934 .05293 L
.10957 .05322 L
.1098 .05343 L
.11003 .05361 L
.11026 .05375 L
.11049 .05387 L
.11073 .05396 L
.11096 .05404 L
.11119 .05411 L
.11143 .05417 L
.11166 .05422 L
Mistroke
.1119 .05426 L
.11213 .0543 L
.11237 .05434 L
.1126 .05437 L
.11284 .0544 L
.11308 .05443 L
.11331 .05446 L
.11355 .05449 L
.11378 .05451 L
.11402 .05454 L
.11426 .05457 L
.11449 .05459 L
.11473 .05461 L
.11497 .05464 L
.11521 .05466 L
.11544 .05469 L
.11568 .05471 L
.11592 .05473 L
.11616 .05476 L
.11639 .05478 L
.11663 .05481 L
.11687 .05483 L
.11711 .05485 L
.11735 .05488 L
.11759 .0549 L
.11782 .05493 L
.11806 .05495 L
.1183 .05497 L
.11854 .055 L
.11878 .05502 L
.11902 .05505 L
.11926 .05507 L
.1195 .0551 L
.11974 .05512 L
.11998 .05515 L
.12022 .05517 L
.12046 .0552 L
.1207 .05522 L
.12094 .05525 L
.12118 .05527 L
.12142 .0553 L
.12166 .05532 L
.12191 .05535 L
.12215 .05537 L
.12239 .0554 L
.12263 .05542 L
.12287 .05545 L
.12311 .05547 L
.12336 .0555 L
.1236 .05552 L
Mistroke
.12384 .05555 L
.12408 .05558 L
.12433 .0556 L
.12457 .05563 L
.12481 .05566 L
.12505 .05568 L
.1253 .05571 L
.12554 .05573 L
.12578 .05576 L
.12603 .05579 L
.12627 .05581 L
.12652 .05584 L
.12676 .05587 L
.12701 .05589 L
.12725 .05592 L
.12749 .05595 L
.12774 .05598 L
.12798 .056 L
.12823 .05603 L
.12847 .05606 L
.12872 .05609 L
.12897 .05611 L
.12921 .05614 L
.12946 .05617 L
.1297 .0562 L
.12995 .05623 L
.1302 .05625 L
.13044 .05628 L
.13069 .05631 L
.13094 .05634 L
.13118 .05637 L
.13143 .0564 L
.13168 .05643 L
.13193 .05645 L
.13217 .05648 L
.13242 .05651 L
.13267 .05654 L
.13292 .05657 L
.13317 .0566 L
.13341 .05663 L
.13366 .05666 L
.13391 .05669 L
.13416 .05672 L
.13441 .05675 L
.13466 .05678 L
.13491 .05681 L
.13516 .05684 L
.13541 .05687 L
.13566 .0569 L
.13591 .05693 L
Mistroke
.13616 .05696 L
.13641 .057 L
.13666 .05703 L
.13691 .05706 L
.13717 .05709 L
.13742 .05712 L
.13767 .05715 L
.13792 .05719 L
.13817 .05722 L
.13842 .05725 L
.13868 .05728 L
.13893 .05731 L
.13918 .05735 L
.13943 .05738 L
.13969 .05741 L
.13994 .05745 L
.14019 .05748 L
.14045 .05751 L
.1407 .05755 L
.14096 .05758 L
.14121 .05761 L
.14146 .05765 L
.14172 .05768 L
.14197 .05771 L
.14223 .05775 L
.14248 .05778 L
.14274 .05782 L
.143 .05785 L
.14325 .05789 L
.14351 .05792 L
.14376 .05796 L
.14402 .058 L
.14428 .05803 L
.14453 .05807 L
.14479 .0581 L
.14505 .05814 L
.14531 .05818 L
.14556 .05821 L
.14582 .05825 L
.14608 .05829 L
.14634 .05832 L
.1466 .05836 L
.14686 .0584 L
.14711 .05844 L
.14737 .05848 L
.14763 .05851 L
.14789 .05855 L
.14815 .05859 L
.14841 .05863 L
.14867 .05867 L
Mistroke
.14893 .05871 L
.14919 .05875 L
.14946 .05879 L
.14972 .05883 L
.14998 .05887 L
.15024 .05891 L
.1505 .05895 L
.15076 .05899 L
.15103 .05903 L
.15129 .05907 L
.15155 .05912 L
.15181 .05916 L
.15208 .0592 L
.15234 .05924 L
.15261 .05929 L
.15287 .05933 L
.15313 .05937 L
.1534 .05942 L
.15366 .05946 L
.15393 .05951 L
.15419 .05955 L
.15446 .0596 L
.15473 .05964 L
.15499 .05969 L
.15526 .05973 L
.15553 .05978 L
.15579 .05983 L
.15606 .05987 L
.15633 .05992 L
.15659 .05997 L
.15686 .06002 L
.15713 .06007 L
.1574 .06011 L
.15767 .06016 L
.15794 .06021 L
.15821 .06026 L
.15848 .06031 L
.15875 .06036 L
.15902 .06042 L
.15929 .06047 L
.15956 .06052 L
.15983 .06057 L
.1601 .06063 L
.16037 .06068 L
.16065 .06073 L
.16092 .06079 L
.16119 .06084 L
.16146 .0609 L
.16174 .06096 L
.16201 .06101 L
Mistroke
.16229 .06107 L
.16256 .06113 L
.16284 .06119 L
.16311 .06124 L
.16339 .0613 L
.16366 .06137 L
.16394 .06143 L
.16421 .06149 L
.16449 .06155 L
.16477 .06161 L
.16505 .06168 L
.16532 .06174 L
.1656 .06181 L
.16588 .06187 L
.16616 .06194 L
.16644 .06201 L
.16672 .06208 L
.167 .06215 L
.16728 .06222 L
.16756 .06229 L
.16784 .06236 L
.16812 .06244 L
.16841 .06251 L
.16869 .06259 L
.16897 .06267 L
.16926 .06274 L
.16954 .06282 L
.16983 .06291 L
.17011 .06299 L
.1704 .06307 L
.17068 .06316 L
.17097 .06325 L
.17126 .06333 L
.17154 .06343 L
.17183 .06352 L
.17212 .06361 L
.17241 .06371 L
.1727 .06381 L
.17299 .06391 L
.17328 .06401 L
.17357 .06412 L
.17386 .06423 L
.17416 .06434 L
.17445 .06446 L
.17474 .06458 L
.17504 .0647 L
.17533 .06482 L
.17563 .06496 L
.17593 .06509 L
.17622 .06523 L
Mistroke
.17652 .06538 L
.17682 .06553 L
.17712 .06568 L
.17742 .06585 L
.17773 .06602 L
.17803 .0662 L
.17833 .06639 L
.17864 .06659 L
.17894 .0668 L
.17925 .06702 L
.17956 .06726 L
.17987 .06751 L
.18018 .06778 L
.1805 .06808 L
.18081 .06839 L
.18113 .06874 L
.18145 .06911 L
.18177 .06953 L
.18209 .06999 L
.18242 .0705 L
.18275 .07108 L
.18308 .07173 L
.18341 .07249 L
.18375 .07338 L
.1841 .07445 L
.18445 .0758 L
.18481 .07766 L
.18518 .08085 L
.18557 .0924 L
.18603 .07733 L
.1864 .07374 L
.18674 .0666 L
.18705 .06131 L
.18732 .05581 L
.18757 .05118 L
.18779 .04734 L
.18798 .04134 L
.18814 .03235 L
.18825 .03089 L
.18835 .02902 L
.18844 .02412 L
.1885 .02393 L
.18856 .02264 L
.18861 .02347 L
.18867 .02163 L
.18872 .02248 L
.18877 .02157 L
.18881 .02204 L
.18886 .02039 L
.1889 .02001 L
Mistroke
.18894 .01946 L
.18897 .01918 L
.189 .01889 L
.18903 .0187 L
.18906 .01854 L
.18909 .01842 L
.18912 .01832 L
.18915 .01825 L
.18917 .01819 L
.1892 .01815 L
.18923 .01812 L
.18925 .0181 L
.18928 .01809 L
.1893 .01809 L
.18933 .0181 L
.18936 .01812 L
.18938 .01815 L
.18941 .01833 L
.18944 .01849 L
.18946 .0187 L
.18949 .01892 L
.18952 .01918 L
.18956 .01946 L
.18959 .01976 L
.18963 .02011 L
.18966 .02048 L
.1897 .0209 L
.18975 .02137 L
.18979 .0219 L
.18984 .0225 L
.18989 .02318 L
.18995 .02397 L
.19001 .02488 L
.19007 .02594 L
.19014 .0272 L
.19022 .02871 L
.19031 .03056 L
.19041 .03287 L
.19052 .0359 L
.19065 .04037 L
.1908 .05338 L
.19103 .04294 L
.1912 .05053 L
.19141 .048 L
.19161 .0511 L
.19183 .05065 L
.19204 .05199 L
.19227 .05209 L
.19249 .05273 L
.19271 .05293 L
Mistroke
.19294 .05326 L
.19317 .05343 L
.1934 .05363 L
.19363 .05375 L
.19386 .05388 L
.1941 .05397 L
.19433 .05405 L
.19456 .05411 L
.1948 .05417 L
.19503 .05422 L
.19527 .05426 L
.1955 .0543 L
.19574 .05434 L
.19597 .05437 L
.19621 .0544 L
.19645 .05443 L
.19668 .05446 L
.19692 .05449 L
.19715 .05451 L
.19739 .05454 L
.19763 .05456 L
.19786 .05459 L
.1981 .05461 L
.19834 .05464 L
.19858 .05466 L
.19881 .05468 L
.19905 .05471 L
.19929 .05473 L
.19953 .05476 L
.19976 .05478 L
.2 .0548 L
.20024 .05483 L
.20048 .05485 L
.20072 .05488 L
.20096 .0549 L
.20119 .05492 L
.20143 .05495 L
.20167 .05497 L
.20191 .055 L
.20215 .05502 L
.20239 .05505 L
.20263 .05507 L
.20287 .05509 L
.20311 .05512 L
.20335 .05514 L
.20359 .05517 L
.20383 .05519 L
.20407 .05522 L
.20431 .05524 L
.20455 .05527 L
Mistroke
.20479 .05529 L
.20503 .05532 L
.20528 .05534 L
.20552 .05537 L
.20576 .05539 L
.206 .05542 L
.20624 .05545 L
.20648 .05547 L
.20673 .0555 L
.20697 .05552 L
.20721 .05555 L
.20745 .05557 L
.2077 .0556 L
.20794 .05563 L
.20818 .05565 L
.20842 .05568 L
.20867 .05571 L
.20891 .05573 L
.20915 .05576 L
.2094 .05579 L
.20964 .05581 L
.20989 .05584 L
.21013 .05587 L
.21037 .05589 L
.21062 .05592 L
.21086 .05595 L
.21111 .05597 L
.21135 .056 L
.2116 .05603 L
.21184 .05606 L
.21209 .05608 L
.21234 .05611 L
.21258 .05614 L
.21283 .05617 L
.21307 .0562 L
.21332 .05622 L
.21357 .05625 L
.21381 .05628 L
.21406 .05631 L
.21431 .05634 L
.21455 .05637 L
.2148 .05639 L
.21505 .05642 L
.2153 .05645 L
.21554 .05648 L
.21579 .05651 L
.21604 .05654 L
.21629 .05657 L
.21654 .0566 L
.21678 .05663 L
Mistroke
.21703 .05666 L
.21728 .05669 L
.21753 .05672 L
.21778 .05675 L
.21803 .05678 L
.21828 .05681 L
.21853 .05684 L
.21878 .05687 L
.21903 .0569 L
.21928 .05693 L
.21953 .05696 L
.21978 .05699 L
.22003 .05702 L
.22028 .05706 L
.22053 .05709 L
.22079 .05712 L
.22104 .05715 L
.22129 .05718 L
.22154 .05721 L
.22179 .05725 L
.22205 .05728 L
.2223 .05731 L
.22255 .05734 L
.2228 .05738 L
.22306 .05741 L
.22331 .05744 L
.22356 .05748 L
.22382 .05751 L
.22407 .05754 L
.22432 .05758 L
.22458 .05761 L
.22483 .05764 L
.22509 .05768 L
.22534 .05771 L
.2256 .05775 L
.22585 .05778 L
.22611 .05782 L
.22636 .05785 L
.22662 .05789 L
.22688 .05792 L
.22713 .05796 L
.22739 .05799 L
.22765 .05803 L
.2279 .05806 L
.22816 .0581 L
.22842 .05814 L
.22867 .05817 L
.22893 .05821 L
.22919 .05825 L
.22945 .05828 L
Mistroke
.22971 .05832 L
.22996 .05836 L
.23022 .0584 L
.23048 .05843 L
.23074 .05847 L
.231 .05851 L
.23126 .05855 L
.23152 .05859 L
.23178 .05863 L
.23204 .05867 L
.2323 .05871 L
.23256 .05874 L
.23282 .05878 L
.23308 .05882 L
.23335 .05887 L
.23361 .05891 L
.23387 .05895 L
.23413 .05899 L
.23439 .05903 L
.23466 .05907 L
.23492 .05911 L
.23518 .05915 L
.23545 .0592 L
.23571 .05924 L
.23597 .05928 L
.23624 .05933 L
.2365 .05937 L
.23677 .05941 L
.23703 .05946 L
.2373 .0595 L
.23756 .05955 L
.23783 .05959 L
.23809 .05964 L
.23836 .05968 L
.23863 .05973 L
.23889 .05978 L
.23916 .05982 L
.23943 .05987 L
.23969 .05992 L
.23996 .05996 L
.24023 .06001 L
.2405 .06006 L
.24077 .06011 L
.24104 .06016 L
.24131 .06021 L
.24157 .06026 L
.24184 .06031 L
.24211 .06036 L
.24239 .06041 L
.24266 .06046 L
Mistroke
.24293 .06052 L
.2432 .06057 L
.24347 .06062 L
.24374 .06067 L
.24401 .06073 L
.24429 .06078 L
.24456 .06084 L
.24483 .06089 L
.24511 .06095 L
.24538 .06101 L
.24565 .06106 L
.24593 .06112 L
.2462 .06118 L
.24648 .06124 L
.24675 .0613 L
.24703 .06136 L
.2473 .06142 L
.24758 .06148 L
.24786 .06154 L
.24814 .06161 L
.24841 .06167 L
.24869 .06174 L
.24897 .0618 L
.24925 .06187 L
.24953 .06193 L
.24981 .062 L
.25009 .06207 L
.25037 .06214 L
.25065 .06221 L
.25093 .06228 L
.25121 .06236 L
.25149 .06243 L
.25177 .0625 L
.25206 .06258 L
.25234 .06266 L
.25262 .06274 L
.25291 .06282 L
.25319 .0629 L
.25348 .06298 L
.25376 .06306 L
.25405 .06315 L
.25433 .06324 L
.25462 .06333 L
.25491 .06342 L
.2552 .06351 L
.25549 .0636 L
.25577 .0637 L
.25606 .0638 L
.25635 .0639 L
.25665 .064 L
Mistroke
.25694 .06411 L
.25723 .06422 L
.25752 .06433 L
.25781 .06445 L
.25811 .06456 L
.2584 .06469 L
.2587 .06481 L
.25899 .06494 L
.25929 .06508 L
.25959 .06522 L
.25989 .06536 L
.26019 .06551 L
.26049 .06567 L
.26079 .06583 L
.26109 .066 L
.26139 .06618 L
.2617 .06637 L
.262 .06657 L
.26231 .06678 L
.26262 .067 L
.26292 .06724 L
.26323 .06749 L
.26355 .06776 L
.26386 .06805 L
.26417 .06836 L
.26449 .0687 L
.26481 .06908 L
.26513 .06949 L
.26545 .06994 L
.26578 .07045 L
.26611 .07102 L
.26644 .07167 L
.26678 .07242 L
.26712 .07329 L
.26746 .07434 L
.26781 .07566 L
.26817 .07746 L
.26854 .08044 L
.26893 .08978 L
.26937 .07918 L
.26975 .0737 L
.27009 .06741 L
.2704 .0618 L
.27068 .05641 L
.27093 .05167 L
.27115 .04773 L
.27135 .04563 L
.27153 .0334 L
.27165 .03124 L
.27175 .02945 L
Mistroke
.27184 .02383 L
.2719 .02376 L
.27196 .02259 L
.27201 .02335 L
.27207 .02153 L
.27211 .0228 L
.27217 .02133 L
.27221 .02106 L
.27225 .01974 L
.27229 .01958 L
.27232 .01913 L
.27236 .01894 L
.27239 .01871 L
.27242 .01857 L
.27244 .01844 L
.27247 .01834 L
.2725 .01826 L
.27253 .0182 L
.27255 .01815 L
.27258 .01812 L
.27261 .01809 L
.27263 .01807 L
.27266 .01806 L
.27268 .01807 L
.27271 .01807 L
.27274 .01809 L
.27276 .01812 L
.27279 .01821 L
.27281 .0184 L
.27284 .01858 L
.27287 .0188 L
.2729 .01904 L
.27293 .0193 L
.27296 .01959 L
.273 .01992 L
.27304 .02028 L
.27307 .02067 L
.27312 .02112 L
.27316 .02161 L
.2732 .02217 L
.27325 .02281 L
.27331 .02353 L
.27336 .02437 L
.27343 .02535 L
.2735 .0265 L
.27357 .02787 L
.27365 .02952 L
.27374 .03157 L
.27385 .03417 L
.27397 .03771 L
Mistroke
.27411 .04392 L
.27428 .04577 L
.27447 .04641 L
.27466 .04837 L
.27486 .04925 L
.27506 .0504 L
.27528 .05108 L
.27549 .05177 L
.27571 .05225 L
.27594 .05267 L
.27616 .05298 L
.27639 .05325 L
.27662 .05346 L
.27685 .05363 L
.27708 .05377 L
.27731 .05388 L
.27755 .05397 L
.27778 .05405 L
.27801 .05412 L
.27825 .05418 L
.27848 .05423 L
.27872 .05427 L
.27895 .05431 L
.27919 .05434 L
.27942 .05438 L
.27966 .05441 L
.2799 .05444 L
.28013 .05447 L
.28037 .05449 L
.2806 .05452 L
.28084 .05454 L
.28108 .05457 L
.28132 .05459 L
.28155 .05462 L
.28179 .05464 L
.28203 .05467 L
.28226 .05469 L
.2825 .05471 L
.28274 .05474 L
.28298 .05476 L
.28321 .05479 L
.28345 .05481 L
.28369 .05483 L
.28393 .05486 L
.28417 .05488 L
.28441 .05491 L
.28465 .05493 L
.28488 .05495 L
.28512 .05498 L
.28536 .055 L
Mistroke
.2856 .05503 L
.28584 .05505 L
.28608 .05508 L
.28632 .0551 L
.28656 .05513 L
.2868 .05515 L
.28704 .05517 L
.28728 .0552 L
.28752 .05522 L
.28776 .05525 L
.288 .05527 L
.28824 .0553 L
.28849 .05532 L
.28873 .05535 L
.28897 .05538 L
.28921 .0554 L
.28945 .05543 L
.28969 .05545 L
.28994 .05548 L
.29018 .0555 L
.29042 .05553 L
.29066 .05555 L
.2909 .05558 L
.29115 .05561 L
.29139 .05563 L
.29163 .05566 L
.29188 .05569 L
.29212 .05571 L
.29236 .05574 L
.29261 .05576 L
.29285 .05579 L
.29309 .05582 L
.29334 .05585 L
.29358 .05587 L
.29383 .0559 L
.29407 .05593 L
.29432 .05595 L
.29456 .05598 L
.29481 .05601 L
.29505 .05604 L
.2953 .05606 L
.29554 .05609 L
.29579 .05612 L
.29603 .05615 L
.29628 .05617 L
.29653 .0562 L
.29677 .05623 L
.29702 .05626 L
.29727 .05629 L
.29751 .05632 L
Mistroke
.29776 .05634 L
.29801 .05637 L
.29825 .0564 L
.2985 .05643 L
.29875 .05646 L
.299 .05649 L
.29924 .05652 L
.29949 .05655 L
.29974 .05658 L
.29999 .05661 L
.30024 .05664 L
.30049 .05667 L
.30074 .0567 L
.30098 .05673 L
.30123 .05676 L
.30148 .05679 L
.30173 .05682 L
.30198 .05685 L
.30223 .05688 L
.30248 .05691 L
.30273 .05694 L
.30298 .05697 L
.30323 .057 L
.30349 .05703 L
.30374 .05706 L
.30399 .05709 L
.30424 .05713 L
.30449 .05716 L
.30474 .05719 L
.30499 .05722 L
.30525 .05725 L
.3055 .05729 L
.30575 .05732 L
.306 .05735 L
.30626 .05738 L
.30651 .05742 L
.30676 .05745 L
.30702 .05748 L
.30727 .05752 L
.30753 .05755 L
.30778 .05758 L
.30803 .05762 L
.30829 .05765 L
.30854 .05769 L
.3088 .05772 L
.30905 .05775 L
.30931 .05779 L
.30956 .05782 L
.30982 .05786 L
.31008 .05789 L
Mistroke
.31033 .05793 L
.31059 .05796 L
.31084 .058 L
.3111 .05804 L
.31136 .05807 L
.31161 .05811 L
.31187 .05815 L
.31213 .05818 L
.31239 .05822 L
.31265 .05826 L
.3129 .05829 L
.31316 .05833 L
.31342 .05837 L
.31368 .05841 L
.31394 .05844 L
.3142 .05848 L
.31446 .05852 L
.31472 .05856 L
.31498 .0586 L
.31524 .05864 L
.3155 .05868 L
.31576 .05871 L
.31602 .05875 L
.31628 .05879 L
.31654 .05883 L
.3168 .05888 L
.31706 .05892 L
.31733 .05896 L
.31759 .059 L
.31785 .05904 L
.31811 .05908 L
.31838 .05912 L
.31864 .05917 L
.3189 .05921 L
.31917 .05925 L
.31943 .05929 L
.31969 .05934 L
.31996 .05938 L
.32022 .05942 L
.32049 .05947 L
.32075 .05951 L
.32102 .05956 L
.32129 .0596 L
.32155 .05965 L
.32182 .05969 L
.32208 .05974 L
.32235 .05979 L
.32262 .05983 L
.32288 .05988 L
.32315 .05993 L
Mistroke
.32342 .05998 L
.32369 .06002 L
.32396 .06007 L
.32423 .06012 L
.32449 .06017 L
.32476 .06022 L
.32503 .06027 L
.3253 .06032 L
.32557 .06037 L
.32584 .06042 L
.32611 .06048 L
.32639 .06053 L
.32666 .06058 L
.32693 .06063 L
.3272 .06069 L
.32747 .06074 L
.32775 .0608 L
.32802 .06085 L
.32829 .06091 L
.32856 .06096 L
.32884 .06102 L
.32911 .06108 L
.32939 .06114 L
.32966 .06119 L
.32994 .06125 L
.33021 .06131 L
.33049 .06137 L
.33076 .06144 L
.33104 .0615 L
.33132 .06156 L
.3316 .06162 L
.33187 .06169 L
.33215 .06175 L
.33243 .06182 L
.33271 .06188 L
.33299 .06195 L
.33327 .06202 L
.33355 .06209 L
.33383 .06216 L
.33411 .06223 L
.33439 .0623 L
.33467 .06237 L
.33495 .06245 L
.33524 .06252 L
.33552 .0626 L
.3358 .06268 L
.33608 .06276 L
.33637 .06284 L
.33665 .06292 L
.33694 .063 L
Mistroke
.33722 .06309 L
.33751 .06317 L
.3378 .06326 L
.33808 .06335 L
.33837 .06344 L
.33866 .06353 L
.33895 .06363 L
.33924 .06372 L
.33953 .06382 L
.33982 .06393 L
.34011 .06403 L
.3404 .06414 L
.34069 .06425 L
.34099 .06436 L
.34128 .06448 L
.34157 .06459 L
.34187 .06472 L
.34216 .06484 L
.34246 .06498 L
.34276 .06511 L
.34305 .06525 L
.34335 .0654 L
.34365 .06555 L
.34395 .06571 L
.34425 .06587 L
.34456 .06605 L
.34486 .06623 L
.34516 .06642 L
.34547 .06662 L
.34578 .06683 L
.34608 .06706 L
.34639 .0673 L
.3467 .06755 L
.34702 .06783 L
.34733 .06812 L
.34764 .06844 L
.34796 .06879 L
.34828 .06918 L
.3486 .0696 L
.34893 .07006 L
.34925 .07058 L
.34958 .07117 L
.34991 .07184 L
.35025 .07262 L
.35059 .07353 L
.35094 .07464 L
.35129 .07604 L
.35165 .07803 L
.35202 .08162 L
.35242 .10193 L
Mistroke
.35293 .0734 L
.35327 .07437 L
.35363 .06491 L
.35392 .05469 L
.35416 .05306 L
.35439 .04829 L
.35459 .04581 L
.35478 .04027 L
.35493 .03195 L
.35504 .03066 L
.35513 .02884 L
.35522 .02416 L
.35528 .02392 L
.35534 .02264 L
.35539 .02347 L
.35545 .02164 L
.3555 .02244 L
.35555 .0216 L
.3556 .02198 L
.35564 .02044 L
.35568 .02 L
.35572 .01947 L
.35575 .01918 L
.35579 .0189 L
.35582 .01871 L
.35585 .01854 L
.35588 .01842 L
.3559 .01832 L
.35593 .01825 L
.35596 .01819 L
.35598 .01815 L
.35601 .01812 L
.35604 .0181 L
.35606 .01809 L
.35609 .01809 L
.35611 .0181 L
.35614 .01812 L
.35617 .01815 L
.35619 .01832 L
.35622 .01849 L
.35625 .01869 L
.35628 .01892 L
.35631 .01917 L
.35634 .01945 L
.35637 .01975 L
.35641 .02009 L
.35645 .02047 L
.35649 .02089 L
.35653 .02136 L
.35657 .02189 L
Mistroke
.35662 .02248 L
.35667 .02316 L
.35673 .02394 L
.35679 .02484 L
.35685 .0259 L
.35692 .02715 L
.357 .02866 L
.35709 .03049 L
.35719 .03279 L
.3573 .03579 L
.35743 .04019 L
.35758 .05629 L
.35783 .04216 L
.35799 .05142 L
.35821 .04778 L
.35841 .05144 L
.35863 .05062 L
.35884 .05214 L
.35906 .05211 L
.35929 .0528 L
.35951 .05295 L
.35974 .0533 L
.35997 .05345 L
.3602 .05365 L
.36043 .05377 L
.36066 .05389 L
.3609 .05398 L
.36113 .05406 L
.36136 .05412 L
.3616 .05418 L
.36183 .05422 L
.36207 .05427 L
.3623 .05431 L
.36254 .05434 L
.36277 .05437 L
.36301 .05441 L
.36325 .05443 L
.36348 .05446 L
.36372 .05449 L
.36395 .05451 L
.36419 .05454 L
.36443 .05456 L
.36466 .05459 L
.3649 .05461 L
.36514 .05464 L
.36538 .05466 L
.36561 .05469 L
.36585 .05471 L
.36609 .05473 L
.36633 .05476 L
Mistroke
.36656 .05478 L
.3668 .05481 L
.36704 .05483 L
.36728 .05485 L
.36752 .05488 L
.36776 .0549 L
.36799 .05493 L
.36823 .05495 L
.36847 .05497 L
.36871 .055 L
.36895 .05502 L
.36919 .05505 L
.36943 .05507 L
.36967 .0551 L
.36991 .05512 L
.37015 .05515 L
.37039 .05517 L
.37063 .05519 L
.37087 .05522 L
.37111 .05524 L
.37135 .05527 L
.37159 .05529 L
.37183 .05532 L
.37208 .05535 L
.37232 .05537 L
.37256 .0554 L
.3728 .05542 L
.37304 .05545 L
.37328 .05547 L
.37353 .0555 L
.37377 .05552 L
.37401 .05555 L
.37425 .05558 L
.3745 .0556 L
.37474 .05563 L
.37498 .05565 L
.37522 .05568 L
.37547 .05571 L
.37571 .05573 L
.37595 .05576 L
.3762 .05579 L
.37644 .05581 L
.37669 .05584 L
.37693 .05587 L
.37717 .05589 L
.37742 .05592 L
.37766 .05595 L
.37791 .05598 L
.37815 .056 L
.3784 .05603 L
Mistroke
.37864 .05606 L
.37889 .05609 L
.37914 .05611 L
.37938 .05614 L
.37963 .05617 L
.37987 .0562 L
.38012 .05623 L
.38037 .05625 L
.38061 .05628 L
.38086 .05631 L
.38111 .05634 L
.38135 .05637 L
.3816 .0564 L
.38185 .05643 L
.3821 .05645 L
.38234 .05648 L
.38259 .05651 L
.38284 .05654 L
.38309 .05657 L
.38334 .0566 L
.38358 .05663 L
.38383 .05666 L
.38408 .05669 L
.38433 .05672 L
.38458 .05675 L
.38483 .05678 L
.38508 .05681 L
.38533 .05684 L
.38558 .05687 L
.38583 .0569 L
.38608 .05693 L
.38633 .05696 L
.38658 .057 L
.38683 .05703 L
.38708 .05706 L
.38733 .05709 L
.38759 .05712 L
.38784 .05715 L
.38809 .05718 L
.38834 .05722 L
.38859 .05725 L
.38885 .05728 L
.3891 .05731 L
.38935 .05735 L
.3896 .05738 L
.38986 .05741 L
.39011 .05744 L
.39036 .05748 L
.39062 .05751 L
.39087 .05754 L
Mistroke
.39113 .05758 L
.39138 .05761 L
.39163 .05765 L
.39189 .05768 L
.39214 .05771 L
.3924 .05775 L
.39265 .05778 L
.39291 .05782 L
.39316 .05785 L
.39342 .05789 L
.39368 .05792 L
.39393 .05796 L
.39419 .05799 L
.39445 .05803 L
.3947 .05807 L
.39496 .0581 L
.39522 .05814 L
.39547 .05817 L
.39573 .05821 L
.39599 .05825 L
.39625 .05829 L
.39651 .05832 L
.39677 .05836 L
.39702 .0584 L
.39728 .05844 L
.39754 .05847 L
.3978 .05851 L
.39806 .05855 L
.39832 .05859 L
.39858 .05863 L
.39884 .05867 L
.3991 .05871 L
.39936 .05875 L
.39962 .05879 L
.39989 .05883 L
.40015 .05887 L
.40041 .05891 L
.40067 .05895 L
.40093 .05899 L
.4012 .05903 L
.40146 .05907 L
.40172 .05912 L
.40198 .05916 L
.40225 .0592 L
.40251 .05924 L
.40277 .05929 L
.40304 .05933 L
.4033 .05937 L
.40357 .05942 L
.40383 .05946 L
Mistroke
.4041 .0595 L
.40436 .05955 L
.40463 .05959 L
.40489 .05964 L
.40516 .05969 L
.40543 .05973 L
.40569 .05978 L
.40596 .05983 L
.40623 .05987 L
.4065 .05992 L
.40676 .05997 L
.40703 .06002 L
.4073 .06006 L
.40757 .06011 L
.40784 .06016 L
.40811 .06021 L
.40838 .06026 L
.40865 .06031 L
.40892 .06036 L
.40919 .06041 L
.40946 .06047 L
.40973 .06052 L
.41 .06057 L
.41027 .06062 L
.41054 .06068 L
.41081 .06073 L
.41109 .06079 L
.41136 .06084 L
.41163 .0609 L
.41191 .06095 L
.41218 .06101 L
.41245 .06107 L
.41273 .06113 L
.413 .06118 L
.41328 .06124 L
.41355 .0613 L
.41383 .06136 L
.41411 .06142 L
.41438 .06149 L
.41466 .06155 L
.41494 .06161 L
.41521 .06168 L
.41549 .06174 L
.41577 .06181 L
.41605 .06187 L
.41633 .06194 L
.41661 .06201 L
.41689 .06208 L
.41717 .06215 L
.41745 .06222 L
Mistroke
.41773 .06229 L
.41801 .06236 L
.41829 .06243 L
.41858 .06251 L
.41886 .06259 L
.41914 .06266 L
.41943 .06274 L
.41971 .06282 L
.41999 .0629 L
.42028 .06299 L
.42056 .06307 L
.42085 .06316 L
.42114 .06324 L
.42142 .06333 L
.42171 .06342 L
.422 .06352 L
.42229 .06361 L
.42258 .06371 L
.42287 .06381 L
.42316 .06391 L
.42345 .06401 L
.42374 .06412 L
.42403 .06423 L
.42432 .06434 L
.42462 .06445 L
.42491 .06457 L
.42521 .06469 L
.4255 .06482 L
.4258 .06495 L
.42609 .06509 L
.42639 .06523 L
.42669 .06537 L
.42699 .06552 L
.42729 .06568 L
.42759 .06584 L
.42789 .06601 L
.4282 .06619 L
.4285 .06638 L
.42881 .06658 L
.42911 .06679 L
.42942 .06702 L
.42973 .06725 L
.43004 .06751 L
.43035 .06778 L
.43066 .06807 L
.43098 .06838 L
.4313 .06873 L
.43161 .0691 L
.43193 .06952 L
.43226 .06997 L
Mistroke
.43258 .07048 L
.43291 .07106 L
.43325 .07172 L
.43358 .07247 L
.43392 .07335 L
.43427 .07442 L
.43462 .07576 L
.43498 .0776 L
.43535 .08072 L
.43574 .09151 L
.43619 .07789 L
.43656 .07372 L
.43691 .06684 L
.43721 .06145 L
.43749 .05599 L
.43774 .05133 L
.43795 .04746 L
.43815 .04193 L
.43831 .03261 L
.43842 .03102 L
.43852 .02911 L
.43861 .02417 L
.43867 .024 L
.43873 .02266 L
.43879 .01856 L
.43882 .0155 L
.43883 .0155 L
.43884 .01636 L
.43885 .02037 L
.43889 .0152 L
.4389 .01513 L
.43891 .01585 L
.43892 .01912 L
.43896 .02347 L
.43901 .03071 L
.43911 .01483 L
.43912 .01482 L
.43913 .01537 L
.43914 .01792 L
.43916 .02111 L
.4392 .02551 L
.43927 .03447 L
.43939 .0498 L
.4396 .05357 L
.43983 .14295 L
.44058 .28382 L
.44214 .38008 L
.44426 .40371 L
.44652 .40271 L
.44877 .3937 L
Mistroke
.45097 .38244 L
.4531 .3708 L
.45516 .35938 L
.45716 .34833 L
.4591 .33769 L
.46097 .32747 L
.46279 .31765 L
.46455 .30822 L
.46625 .29915 L
.4679 .29045 L
.4695 .28208 L
.47105 .27403 L
.47256 .2663 L
.47402 .25887 L
.47544 .25172 L
.47682 .24485 L
.47815 .23823 L
.47945 .23187 L
.48071 .22575 L
.48194 .21986 L
.48313 .21419 L
.48429 .20873 L
.48542 .20347 L
.48652 .1984 L
.48759 .19352 L
.48863 .18882 L
.48964 .18428 L
.49063 .17991 L
.49159 .1757 L
.49253 .17164 L
.49344 .16772 L
.49433 .16394 L
.4952 .16029 L
.49605 .15677 L
.49688 .15337 L
.49769 .15009 L
.49847 .14693 L
.49925 .14387 L
.5 .14091 L
.50073 .13806 L
.50145 .1353 L
.50216 .13264 L
.50285 .13006 L
.50352 .12757 L
.50418 .12516 L
.50482 .12284 L
.50546 .12059 L
.50607 .11841 L
.50668 .1163 L
.50727 .11427 L
Mistroke
.50786 .1123 L
.50843 .11039 L
.50899 .10854 L
.50954 .10676 L
.51007 .10503 L
.5106 .10335 L
.51112 .10173 L
.51163 .1413 L
.51237 .27307 L
.51387 .42734 L
.51626 .60332 L
.51967 .0688 L
.51999 .0688 L
.52031 .08884 L
.52074 .15074 L
.52154 .03925 L
.52169 .03925 L
.52183 .05623 L
.52208 .10502 L
.52261 .03034 L
.52271 .03034 L
.5228 .03822 L
.52295 .07405 L
.52329 .0249 L
.52336 .0249 L
.52343 .03033 L
.52352 .05466 L
.52376 .09089 L
.52421 .05628 L
.52445 .05628 L
.5247 .04291 L
.52487 .04291 L
.52504 .05076 L
.52525 .0459 L
.52544 .05113 L
.52566 .04761 L
.52585 .04673 L
.52605 .01474 L
.52605 .01472 L
.52606 .01524 L
.52607 .01762 L
.52609 .02063 L
.52613 .02494 L
.5262 .03037 L
.52629 .03834 L
.52644 .05925 L
.5267 .05784 L
.52696 .12277 L
.52759 .27512 L
.5291 .35968 L
Mistroke
.5311 .38407 L
.53324 .38379 L
.53538 .37548 L
.53748 .36492 L
.53951 .35398 L
.54148 .34322 L
.54338 .33281 L
.54523 .32279 L
.54702 .31316 L
.54875 .3039 L
.55043 .29501 L
.55205 .28646 L
.55363 .27825 L
.55516 .27035 L
.55665 .26276 L
.55809 .25547 L
.55948 .24845 L
.56084 .2417 L
.56216 .2352 L
.56344 .22896 L
.56469 .22294 L
.5659 .21716 L
.56708 .21159 L
.56822 .20622 L
.56933 .20105 L
.57042 .19608 L
.57147 .19128 L
.5725 .18666 L
.5735 .1822 L
.57448 .17791 L
.57543 .17377 L
.57635 .16977 L
.57726 .16592 L
.57814 .1622 L
.579 .15862 L
.57983 .15516 L
.58065 .15181 L
.58145 .14859 L
.58223 .14547 L
.58299 .14246 L
.58374 .13955 L
.58447 .13675 L
.58518 .13403 L
.58588 .13141 L
.58656 .12888 L
.58722 .12643 L
.58788 .12406 L
.58851 .12177 L
.58914 .11955 L
.58975 .11741 L
Mistroke
.59035 .11534 L
.59094 .11333 L
.59152 .11139 L
.59208 .10951 L
.59264 .1077 L
.59318 .10594 L
.59372 .10423 L
.59424 .10258 L
.59475 .10098 L
.59526 .14023 L
.59599 .27182 L
.59748 .42211 L
.59985 .59219 L
.60319 .06782 L
.60351 .06782 L
.60382 .08665 L
.60424 .14677 L
.60501 .03909 L
.60516 .03909 L
.60531 .05441 L
.60554 .10269 L
.60606 .02984 L
.60615 .02984 L
.60624 .03749 L
.60638 .07225 L
.60672 .02465 L
.60679 .02465 L
.60685 .02997 L
.60694 .05379 L
.60718 .08933 L
.60761 .05581 L
.60786 .05581 L
.6081 .04262 L
.60827 .04262 L
.60844 .05042 L
.60865 .04571 L
.60884 .05144 L
.60906 .04729 L
.60925 .04682 L
.60944 .01474 L
.60945 .01472 L
.60946 .01524 L
.60946 .01761 L
.60949 .02062 L
.60953 .02492 L
.60959 .03036 L
.60969 .03834 L
.60983 .05932 L
.6101 .05828 L
.61036 .12147 L
Mistroke
.61098 .282 L
.61253 .36239 L
.61455 .38475 L
.61669 .38377 L
.61884 .37524 L
.62093 .36463 L
.62296 .35367 L
.62492 .34292 L
.62683 .33252 L
.62867 .32251 L
.63046 .31289 L
.63219 .30364 L
.63386 .29476 L
.63549 .28622 L
.63707 .27802 L
.6386 .27013 L
.64008 .26255 L
.64152 .25526 L
.64292 .24825 L
.64427 .24151 L
.64559 .23502 L
.64687 .22878 L
.64811 .22278 L
.64932 .217 L
.6505 .21143 L
.65164 .20607 L
.65276 .20091 L
.65384 .19594 L
.65489 .19115 L
.65592 .18653 L
.65692 .18208 L
.65789 .17779 L
.65884 .17365 L
.65977 .16966 L
.66067 .16581 L
.66155 .1621 L
.66241 .15852 L
.66325 .15506 L
.66407 .15172 L
.66487 .1485 L
.66565 .14538 L
.66641 .14238 L
.66715 .13947 L
.66788 .13667 L
.66859 .13396 L
.66929 .13134 L
.66997 .12881 L
.67063 .12636 L
.67129 .12399 L
.67192 .1217 L
Mistroke
.67255 .11949 L
.67316 .11735 L
.67376 .11528 L
.67435 .11327 L
.67493 .11134 L
.67549 .10946 L
.67604 .10764 L
.67659 .10589 L
.67712 .10418 L
.67765 .10254 L
.67816 .10094 L
.67867 .14016 L
.6794 .27175 L
.68089 .4218 L
.68325 .59153 L
.68659 .06776 L
.6869 .06776 L
.68722 .08652 L
.68764 .14654 L
.68841 .03906 L
.68856 .03906 L
.6887 .0543 L
.68894 .10255 L
.68945 .02981 L
.68955 .02981 L
.68964 .03745 L
.68978 .07214 L
.69012 .02463 L
.69018 .02463 L
.69024 .02995 L
.69034 .05374 L
.69057 .08924 L
.69101 .05578 L
.69125 .05578 L
.69149 .04261 L
.69166 .04261 L
.69183 .0504 L
.69204 .0457 L
.69223 .05146 L
.69245 .04728 L
.69264 .04683 L
.69283 .01473 L
.69284 .01472 L
.69285 .01524 L
.69286 .01761 L
.69288 .02061 L
.69292 .02492 L
.69299 .03035 L
.69308 .03834 L
.69323 .05933 L
Mistroke
.69349 .05831 L
.69375 .1214 L
.69437 .28249 L
.69593 .36258 L
.69794 .3848 L
.70009 .38377 L
.70223 .37522 L
.70432 .36461 L
.70635 .35365 L
.70832 .3429 L
.71022 .3325 L
.71207 .32249 L
.71385 .31287 L
.71558 .30362 L
.71726 .29474 L
.71888 .28621 L
.72046 .278 L
.72199 .27012 L
.72347 .26254 L
.72491 .25525 L
.72631 .24824 L
.72767 .2415 L
.72898 .23501 L
.73026 .22877 L
.73151 .22277 L
.73272 .21699 L
.73389 .21142 L
.73504 .20606 L
.73615 .2009 L
.73723 .19593 L
.73829 .19114 L
.73931 .18652 L
.74031 .18207 L
.74129 .17778 L
.74224 .17364 L
.74316 .16966 L
.74407 .16581 L
.74495 .16209 L
.7458 .15851 L
.74664 .15505 L
.74746 .15171 L
.74826 .14849 L
.74904 .14538 L
.7498 .14237 L
.75054 .13947 L
.75127 .13666 L
.75198 .13395 L
.75268 .13133 L
.75336 .1288 L
.75403 .12635 L
Mistroke
.75468 .12399 L
.75532 .1217 L
.75594 .11949 L
.75655 .11734 L
.75715 .11527 L
.75774 .11327 L
.75832 .11133 L
.75888 .10946 L
.75944 .10764 L
.75998 .10588 L
.76051 .10418 L
.76104 .10253 L
.76155 .10094 L
.76206 .14016 L
.76279 .27174 L
.76428 .42177 L
.76664 .59148 L
.76998 .06776 L
.7703 .06776 L
.77061 .08651 L
.77103 .14652 L
.7718 .03906 L
.77195 .03906 L
.77209 .0543 L
.77233 .10254 L
.77284 .02981 L
.77294 .02981 L
.77303 .03744 L
.77317 .07214 L
.77351 .02463 L
.77357 .02463 L
.77364 .02995 L
.77373 .05373 L
.77396 .08924 L
.7744 .05578 L
.77464 .05578 L
.77489 .04261 L
.77505 .04261 L
.77522 .0504 L
.77543 .0457 L
.77562 .05146 L
.77584 .04728 L
.77603 .04683 L
.77623 .01473 L
.77623 .01472 L
.77624 .01524 L
.77625 .01761 L
.77627 .02061 L
.77631 .02492 L
.77638 .03035 L
Mistroke
.77647 .03834 L
.77662 .05933 L
.77688 .05831 L
.77714 .12139 L
.77776 .28253 L
.77932 .36259 L
.78134 .3848 L
.78348 .38377 L
.78562 .37522 L
.78771 .3646 L
.78974 .35365 L
.79171 .3429 L
.79361 .3325 L
.79546 .32249 L
.79724 .31287 L
.79897 .30362 L
.80065 .29474 L
.80228 .2862 L
.80385 .278 L
.80538 .27012 L
.80687 .26254 L
.8083 .25525 L
.8097 .24824 L
.81106 .2415 L
.81238 .23501 L
.81366 .22877 L
.8149 .22276 L
.81611 .21698 L
.81729 .21142 L
.81843 .20606 L
.81954 .2009 L
.82063 .19593 L
.82168 .19114 L
.82271 .18652 L
.82371 .18207 L
.82468 .17778 L
.82563 .17364 L
.82655 .16965 L
.82746 .16581 L
.82834 .16209 L
.8292 .15851 L
.83003 .15505 L
.83085 .15171 L
.83165 .14849 L
.83243 .14538 L
.83319 .14237 L
.83394 .13947 L
.83466 .13666 L
.83538 .13395 L
.83607 .13133 L
Mistroke
.83675 .1288 L
.83742 .12635 L
.83807 .12399 L
.83871 .1217 L
.83933 .11948 L
.83995 .11734 L
.84055 .11527 L
.84113 .11327 L
.84171 .11133 L
.84228 .10946 L
.84283 .10764 L
.84337 .10588 L
.84391 .10418 L
.84443 .10253 L
.84494 .10093 L
.84545 .14016 L
.84618 .27174 L
.84767 .42177 L
.85003 .59148 L
.85338 .06776 L
.85369 .06776 L
.854 .08651 L
.85442 .14652 L
.85519 .03906 L
.85534 .03906 L
.85549 .0543 L
.85572 .10254 L
.85624 .02981 L
.85633 .02981 L
.85642 .03744 L
.85656 .07214 L
.8569 .02463 L
.85696 .02463 L
.85703 .02995 L
.85712 .05373 L
.85735 .08924 L
.85779 .05578 L
.85803 .05578 L
.85828 .04261 L
.85845 .04261 L
.85861 .0504 L
.85883 .0457 L
.85901 .05146 L
.85923 .04728 L
.85943 .04683 L
.85962 .01473 L
.85962 .01472 L
.85963 .01524 L
.85964 .01761 L
.85966 .02061 L
Mistroke
.8597 .02492 L
.85977 .03035 L
.85987 .03834 L
.86001 .05933 L
.86027 .05831 L
.86053 .12139 L
.86115 .28253 L
.86271 .36259 L
.86473 .3848 L
.86687 .38377 L
.86901 .37522 L
.87111 .3646 L
.87314 .35365 L
.8751 .3429 L
.87701 .3325 L
.87885 .32249 L
.88064 .31287 L
.88237 .30362 L
.88404 .29474 L
.88567 .2862 L
.88724 .278 L
.88877 .27012 L
.89026 .26254 L
.8917 .25525 L
.89309 .24824 L
.89445 .2415 L
.89577 .23501 L
.89705 .22877 L
.89829 .22276 L
.8995 .21698 L
.90068 .21142 L
.90182 .20606 L
.90293 .2009 L
.90402 .19593 L
.90507 .19114 L
.9061 .18652 L
.9071 .18207 L
.90807 .17778 L
.90902 .17364 L
.90995 .16965 L
.91085 .16581 L
.91173 .16209 L
.91259 .15851 L
.91343 .15505 L
.91424 .15171 L
.91504 .14849 L
.91582 .14538 L
.91658 .14237 L
.91733 .13947 L
.91806 .13666 L
Mistroke
.91877 .13395 L
.91946 .13133 L
.92014 .1288 L
.92081 .12635 L
.92146 .12399 L
.9221 .1217 L
.92273 .11948 L
.92334 .11734 L
.92394 .11527 L
.92453 .11327 L
.9251 .11133 L
.92567 .10946 L
.92622 .10764 L
.92676 .10588 L
.9273 .10418 L
.92782 .10253 L
.92834 .10093 L
.92884 .14016 L
.92957 .27174 L
.93107 .42177 L
.93343 .59148 L
.93677 .06776 L
.93708 .06776 L
.93739 .08651 L
.93781 .14652 L
.93858 .03906 L
.93873 .03906 L
.93888 .0543 L
.93911 .10254 L
.93963 .02981 L
.93972 .02981 L
.93981 .03744 L
.93995 .07214 L
.94029 .02463 L
.94035 .02463 L
.94042 .02995 L
.94051 .05373 L
.94074 .08924 L
.94118 .05578 L
.94143 .05578 L
.94167 .04261 L
.94184 .04261 L
.94201 .0504 L
.94222 .0457 L
.9424 .05146 L
.94262 .04728 L
.94282 .04683 L
.94301 .01473 L
.94302 .01472 L
.94302 .01524 L
Mistroke
.94303 .01761 L
.94305 .02061 L
.9431 .02492 L
.94316 .03035 L
.94326 .03834 L
.9434 .05933 L
.94366 .05831 L
.94392 .12139 L
.94455 .28253 L
.9461 .36259 L
.94812 .3848 L
.95027 .38377 L
.95241 .37522 L
.9545 .3646 L
.95653 .35365 L
.95849 .3429 L
.9604 .3325 L
.96224 .32249 L
.96403 .31287 L
.96576 .30362 L
.96743 .29474 L
.96906 .2862 L
.97064 .278 L
.97217 .27012 L
.97365 .26254 L
.97509 .20433 L
.97619 .20433 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00D03oool4
00000300oooo00<000000?ooo`3oool0;@3oool200000300oooo0P00000/0?ooo`@000000`3oool2
000000<0oooo001@0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0;03oool01000
0000oooo0?ooo`00000^0?ooo`040000003oool0oooo000002d0oooo00D000000?ooo`3oool0oooo
000000020?ooo`4000000@3oool10?ooo`00D@3oool00`000000oooo0?ooo`0]0?ooo`D00000;@3o
ool010000000oooo0?ooo`00000^0?ooo`040000003oool0oooo000002d0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`4000000@3oool10?ooo`00DP3oool00`000000oooo0?ooo`0/0?ooo`04
0000003oool0oooo000002h0oooo0`00000`0?ooo`800000;P3oool01@000000oooo0?ooo`3oool0
00000080oooo0@0000010?ooo`40oooo001C0?ooo`030000003oool0oooo02`0oooo00<000000?oo
o`000000;P3oool00`000000oooo0?ooo`0_0?ooo`040000003oool0oooo000002d0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`4000000@3oool10?ooo`00D03oool010000000oooo0?ooo`00
000_0?ooo`800000;P3oool00`000000oooo0?ooo`0_0?ooo`040000003oool0oooo000002/0oooo
0`0000030?ooo`040000003oool0oooo00000080oooo001A0?ooo`800000<@3oool00`000000oooo
0?ooo`0]0?ooo`<00000;`3oool2000002h0oooo00<000000?ooo`3oool00P3oool2000000<0oooo
000Q0?ooo`030000003oool0oooo0?`0oooo000Q0?ooo`030000003oool0oooo0?`0oooo000Q0?oo
o`030000003oool0oooo0?`0oooo000Q0?ooo`030000003oool0oooo0?`0oooo000K0?ooool00000
1@0000010?ooo`008@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00D0
00000?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0:0?ooo`040000003oool00000000000P0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3o
ool00000303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool02@3oool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3oool2
000000/0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`050000003o
ool0oooo0?ooo`000000203oool00`000000oooo0?ooo`040?ooo`008@3oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04P3oool2000001@0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo0P00
000D0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000000l0oooo000Q
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B
0?ooo`800000503oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000D
0?ooo`8000003`3oool00240oooo0P00000C0?ooo`030000003oool0oooo0180oooo0P00000D0?oo
o`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo0P00000D0?oo
o`8000004`3oool2000001@0oooo0P00000D0?ooo`8000003`3oool00240oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo00<000000?ooo`3o
ool04P3oool2000001@0oooo0P00000D0?ooo`800000503oool2000001<0oooo0P00000D0?ooo`80
0000503oool2000000l0oooo000Q0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
4P3oool2000001@0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000D0?ooo`800000
503oool2000001<0oooo0`00000C0?ooo`800000503oool2000001<0oooo0`00000?0?ooo`008@3o
ool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0180oooo0P00000D0?ooo`800000503o
ool2000001<0oooo0P00000D0?ooo`800000503oool2000001<0oooo0`00000C0?ooo`800000503o
ool2000001<0oooo0`00000?0?ooo`008@3oool2000001<0oooo0P00000C0?ooo`800000503oool2
000001@0oooo0P00000C0?ooo`800000503oool2000001@0oooo0P00000C0?ooo`<000004`3oool2
000001@0oooo0P00000C0?ooo`<000003`3oool00240oooo00<000000?ooo`3oool04P3oool20000
01<0oooo0P00000D0?ooo`800000503oool2000001<0oooo0P00000D0?ooo`800000503oool20000
01<0oooo0`00000C0?ooo`800000503oool2000001<0oooo0`00000?0?ooo`008@3oool500000100
oooo1@00000@0?ooo`H00000403oool600000100oooo1@00000@0?ooo`800000503oool2000001@0
oooo0P00000C0?ooo`<000004`3oool2000001@0oooo0P00000C0?ooo`<000003`3oool00240oooo
00@000000?ooo`3oool0oooo2@0000080?ooo`030000003oool0oooo0080oooo200000080?ooo`03
0000003oool0oooo0080oooo2@0000080?ooo`030000003oool0oooo0080oooo2@0000080?ooo`03
0000003oool0oooo0080oooo200000080?ooo`800000503oool2000001@0oooo0P00000C0?ooo`<0
00004`3oool2000001@0oooo0P00000C0?ooo`<000003`3oool00240oooo0P00000:0?ooo`D00000
0`3oool00`000000oooo0?ooo`0:0?ooo`H000000`3oool00`000000oooo0?ooo`0:0?ooo`H00000
0`3oool00`000000oooo0?ooo`0:0?ooo`D000000`3oool00`000000oooo0?ooo`0:0?ooo`H00000
0`3oool2000001@0oooo0P00000D0?ooo`8000004`3oool3000001<0oooo0P00000D0?ooo`800000
4`3oool3000000l0oooo000Q0?ooo`030000003oool0oooo00d0oooo0`0000000`3oool000000?oo
o`0@0?ooo`<0000000<0oooo0000003oool0403oool3000000030?ooo`000000oooo00l0oooo0`00
00000`3oool000000?ooo`0@0?ooo`<0000000<0oooo000000000000503oool2000001@0oooo0P00
000C0?ooo`<000004`3oool2000001@0oooo0P00000C0?ooo`<000003`3oool00240oooo00<00000
0?ooo`3oool0403oool2000001<0oooo0`00000C0?ooo`<000004P3oool3000001<0oooo1000000D
0?ooo`8000004`3oool3000001<0oooo0`00000C0?ooo`8000004`3oool3000001<0oooo0`00000?
0?ooo`008@3oool00`000000oooo0?ooo`0@0?ooo`800000503oool2000001@0oooo0P00000C0?oo
o`800000503oool3000001@0oooo0P00000C0?ooo`<000004`3oool3000001<0oooo0P00000C0?oo
o`<000004`3oool3000000l0oooo000Q0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0`00000D0?ooo`80
00004`3oool3000001<0oooo0`00000C0?ooo`8000004`3oool3000001<0oooo0`00000?0?ooo`00
8@3oool200000180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`800000
503oool00`000000oooo0?ooo`0C0?ooo`800000503oool2000001<0oooo0`00000C0?ooo`<00000
4`3oool2000001<0oooo0`00000C0?ooo`<000003`3oool00240oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0C0?ooo`800000503oool2000001<0oooo0`00000C0?ooo`<000004`3o
ool2000001<0oooo0`00000C0?ooo`<000003`3oool00080oooo0P0000040?ooo`030000003oool0
oooo00<0oooo0P0000040?ooo`8000000`3oool3000000D0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0C0?ooo`800000503oool2000001<0oooo0`00000C0?ooo`<000004`3oool2
000001<0oooo0`00000C0?ooo`<000003`3oool000050?ooo`000000oooo0?ooo`000000203oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
4`3oool2000001@0oooo0P00000C0?ooo`<000004`3oool3000001<0oooo0P00000C0?ooo`<00000
4`3oool3000000l0oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0080oooo0P00001C0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool04P3oool2000001<0oooo0`00000C0?oo
o`<000004`3oool2000001<0oooo0`00000C0?ooo`<000003`3oool000050?ooo`000000oooo0?oo
o`000000203oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0`00
00050?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`0B0?ooo`8000004@3oool00`000000oooo0000000200000140oooo00<000000?ooo`0000000P00
000@0?ooo`030000003oool0oooo008000004@3oool00`000000oooo0000000200000140oooo00<0
00000?ooo`0000000P00000?0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo008000004@3oool00`000000oooo0000000200000140oooo00<000000?ooo`00
00000P00000@0?ooo`030000003oool0oooo008000004@3oool00`000000oooo0000000200000140
oooo00<000000?ooo`0000000P00000?0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`02
00000140oooo00<000000?ooo`0000000P00000@0?ooo`80000000@0oooo0000003oool00000403o
ool00`000000oooo0?ooo`0200000140oooo00<000000?ooo`0000000P00000@0?ooo`80000000@0
oooo0000003oool000003`3oool00080oooo0P00000:0?ooo`800000103oool2000000<0oooo1000
00040?ooo`800000JP3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00800000403o
ool2000000040?ooo`000000000000000100oooo0P000000103oool000000?ooo`00000@0?ooo`03
0000003oool0oooo00800000403oool2000000040?ooo`000000000000000100oooo0P000000103o
ool000000?ooo`00000?0?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo
00h0oooo0P0000020?ooo`800000403oool2000000040?ooo`000000000000000100oooo0P000000
103oool000000?ooo`00000?0?ooo`8000000P3oool200000100oooo0P000000103oool000000000
0000000@0?ooo`80000000@0oooo0000003oool000003`3oool00240oooo00<000000?ooo`3oool0
J@3oool00`000000oooo0?ooo`0>0?ooo`8000000P3oool200000100oooo0P000000103oool00000
00000000000?0?ooo`070000003oool000000?ooo`000000oooo0000000?0?ooo`8000000P3oool2
00000100oooo0P000000103oool0000000000000000?0?ooo`070000003oool000000?ooo`000000
oooo0000000?0?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00h0oooo
00@000000?ooo`000000oooo0P00000?0?ooo`040000003oool000000?ooo`<000003`3oool01`00
0000oooo0000003oool000000?ooo`0000003`3oool010000000oooo0000003oool2000000l0oooo
00@000000?ooo`000000oooo0`00000?0?ooo`070000003oool000000?ooo`000000oooo0000000?
0?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00d0oooo0P0000000`3o
ool000000?ooo`02000000l0oooo00@000000?ooo`000000oooo0`00000?0?ooo`070000003oool0
00000?ooo`000000oooo0000000>0?ooo`050000003oool0oooo0000003oool00P00000?0?ooo`04
0000003oool000000?ooo`<000003`3oool01`000000oooo0000003oool000000?ooo`0000003`3o
ool00240oooo0P00001Z0?ooo`030000003oool0oooo00d0oooo00D000000?ooo`3oool000000?oo
o`02000000l0oooo00@000000?ooo`000000oooo0`00000>0?ooo`80000000H0oooo0000003oool0
00000?ooo`00000>0?ooo`050000003oool0oooo0000003oool00P00000?0?ooo`040000003oool0
00000?ooo`<000003P3oool2000000060?ooo`000000oooo0000003oool000003`3oool00240oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0=0?ooo`050000003oool0oooo0000003o
ool00P00000?0?ooo`040000003oool000000?ooo`<000003P3oool020000000oooo0?ooo`000000
oooo0000003oool000003P3oool01@000000oooo0?ooo`000000oooo008000003`3oool010000000
oooo0000003oool3000000h0oooo00P000000?ooo`3oool000000?ooo`000000oooo000000l0oooo
000Q0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool03@3oool01@000000oooo0?oo
o`000000oooo008000003P3oool01@000000oooo0?ooo`000000oooo00<000003P3oool020000000
oooo0?ooo`000000oooo0000003oool000003P3oool01@000000oooo0?ooo`000000oooo00800000
3P3oool01@000000oooo0?ooo`000000oooo00<000003P3oool020000000oooo0?ooo`000000oooo
0000003oool000003`3oool00240oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0<
0?ooo`060000003oool0oooo0?ooo`000000oooo0P00000>0?ooo`050000003oool0oooo0000003o
ool00`00000>0?ooo`080000003oool0oooo0000003oool000000?ooo`00000=0?ooo`060000003o
ool0oooo0?ooo`000000oooo0P00000>0?ooo`050000003oool0oooo0000003oool00`00000>0?oo
o`080000003oool0oooo0000003oool000000?ooo`00000?0?ooo`008@3oool2000006X0oooo00<0
00000?ooo`3oool0303oool01P000000oooo0?ooo`3oool000000?ooo`8000003P3oool01@000000
oooo0?ooo`000000oooo00<000003P3oool020000000oooo0?ooo`000000oooo0000003oool00000
3@3oool01P000000oooo0?ooo`3oool000000?ooo`8000003P3oool01@000000oooo0?ooo`000000
oooo00<000003P3oool020000000oooo0?ooo`000000oooo0000003oool000003`3oool00240oooo
00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0<0?ooo`060000003oool0oooo0?ooo`00
0000oooo0P00000>0?ooo`080000003oool0oooo0000003oool000000?ooo`00000=0?ooo`090000
003oool0oooo0?ooo`000000oooo0000003oool0000000d0oooo00H000000?ooo`3oool0oooo0000
003oool2000000h0oooo00P000000?ooo`3oool000000?ooo`000000oooo000000d0oooo00T00000
0?ooo`3oool0oooo0000003oool000000?ooo`0000003`3oool00240oooo00<000000?ooo`3oool0
J@3oool00`000000oooo0?ooo`0<0?ooo`060000003oool0oooo0?ooo`000000oooo0P00000=0?oo
o`090000003oool0oooo0?ooo`000000oooo0000003oool0000000d0oooo00T000000?ooo`3oool0
oooo0000003oool000000?ooo`0000003@3oool01P000000oooo0?ooo`3oool000000?ooo`800000
3@3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo0000000=0?ooo`090000003oool0
oooo0?ooo`000000oooo0000003oool0000000l0oooo000Q0?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`040000003oool00000000000d0
oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000003@3oool02@000000oooo0?oo
o`3oool000000?ooo`000000oooo0000000<0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`00000000003@3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo0000000=0?ooo`09
0000003oool0oooo0?ooo`000000oooo0000003oool0000000l0oooo000Q0?ooo`800000JP3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00@000000?ooo`00000000003@3o
ool02@000000oooo0?ooo`3oool000000?ooo`000000oooo0000000<0?ooo`030000003oool0oooo
0080oooo00D000000?ooo`000000oooo0000000<0?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`00000000003@3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo0000000<0?oo
o`030000003oool0oooo0080oooo00D000000?ooo`000000oooo0000000?0?ooo`008@3oool00`00
0000oooo0?ooo`1Y0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool01000
0000oooo00000000000=0?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000`0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000`0oooo00<000000?oo
o`3oool00P3oool010000000oooo00000000000=0?ooo`090000003oool0oooo0?ooo`000000oooo
0000003oool0000000`0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool00000
00l0oooo00080?ooo`800000103oool00`000000oooo0?ooo`030?ooo`8000000`3oool4000000@0
oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080
oooo00@000000?ooo`0000000000303oool00`000000oooo0?ooo`020?ooo`050000003oool00000
0?ooo`000000303oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`000000303o
ool00`000000oooo0?ooo`020?ooo`040000003oool00000000000`0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0000003oool0000000`0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0000003oool0000000l0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06T0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`040000003oool00000000000`0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0000003oool0000000`0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0000003oool0000000/0oooo00<000000?ooo`3oool00`3oool010000000
oooo00000000000<0?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo0000000<
0?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000oooo0000000?0?ooo`001`3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
0`3oool2000006X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`040000
003oool00000000000`0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool00000
00`0oooo00<000000?ooo`3oool00P3oool01@000000oooo0000003oool0000000/0oooo00<00000
0?ooo`3oool00`3oool010000000oooo00000000000<0?ooo`030000003oool0oooo0080oooo00D0
00000?ooo`000000oooo0000000<0?ooo`030000003oool0oooo0080oooo00D000000?ooo`000000
oooo0000000?0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool00`3oool010000000oooo00000000000<0?ooo`030000003oool0
oooo0080oooo00D000000?ooo`000000oooo0000000;0?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`000000oooo0000000;0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`000000
0000303oool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000002`3oool00`00
0000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000003`3oool000L0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0J@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00<0oooo00@0
00000?ooo`00000000002`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`00
00002`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000002`3oool00`00
0000oooo0?ooo`030?ooo`040000003oool00000000000/0oooo00<000000?ooo`3oool00`3oool0
1@000000oooo0000003oool0000000/0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000
003oool0000000l0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000P3oool3000000D0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00<0oooo00@000000?ooo`00000000002`3oool00`000000oooo0?ooo`030?oo
o`050000003oool000000?ooo`0000002`3oool00`000000oooo0?ooo`030?ooo`050000003oool0
00000?ooo`0000002`3oool00`000000oooo0?ooo`030?ooo`040000003oool00000000000/0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000/0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0000003oool0000000l0oooo00080?ooo`8000002P3oool2000000D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0103oool010000000oooo00000000000;0?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`000000oooo0000000;0?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`000000oooo0000000:0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`0000000000
2`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000002`3oool00`000000
oooo0?ooo`030?ooo`050000003oool000000?ooo`0000003`3oool00240oooo0P00001Z0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool010000000oooo00000000000;0?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo0000000:0?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`000000oooo0000000:0?ooo`030000003oool0oooo00@0oooo00@0
00000?ooo`00000000002`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`00
00002P3oool00`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`0000003`3oool00240
oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0
oooo00D000000?ooo`000000oooo000000090?ooo`030000003oool0oooo00@0oooo00D000000?oo
o`000000oooo0000000:0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo0000
000:0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`00000000002`3oool00`000000oooo
0?ooo`030?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo0?ooo`040?ooo`05
0000003oool000000?ooo`0000003`3oool00240oooo00<000000?ooo`3oool0J@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000090?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo0000000:0?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`000000oooo0000000:0?ooo`030000003oool0oooo00@0oooo00D0
00000?ooo`000000oooo000000090?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000
oooo0000000:0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000070?oo
o`030000003oool0oooo00D0oooo000Q0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`0000002@3oool00`00
0000oooo0?ooo`040?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo0?ooo`04
0?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo0?ooo`040?ooo`050000003o
ool000000?ooo`0000002@3oool00`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`00
00002P3oool00`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`0000001`3oool00`00
0000oooo0?ooo`050?ooo`008@3oool2000006X0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`050?ooo`050000003oool000000?ooo`0000002@3oool00`000000oooo0?ooo`040?oo
o`050000003oool000000?ooo`0000002P3oool00`000000oooo0?ooo`040?ooo`050000003oool0
00000?ooo`0000002@3oool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`000000
2@3oool00`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`0000002P3oool00`000000
oooo0?ooo`040?ooo`050000003oool000000?ooo`0000001`3oool00`000000oooo0?ooo`050?oo
o`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01@3oool01@000000oooo0000003oool0000000T0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0000003oool0000000T0oooo00<000000?ooo`3oool01@3oool01@000000oooo0000003o
ool0000000T0oooo00<000000?ooo`3oool01@3oool01@000000oooo0000003oool0000000T0oooo
00<000000?ooo`3oool0103oool01@000000oooo0000003oool0000000T0oooo00<000000?ooo`3o
ool01@3oool01@000000oooo0000003oool0000000L0oooo00<000000?ooo`3oool01@3oool00240
oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0
oooo00D000000?ooo`000000oooo000000090?ooo`030000003oool0oooo00@0oooo00D000000?oo
o`000000oooo000000090?ooo`030000003oool0oooo00D0oooo00D000000?ooo`000000oooo0000
00090?ooo`030000003oool0oooo00D0oooo00D000000?ooo`000000oooo000000080?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`000000oooo000000090?ooo`030000003oool0oooo00D0
oooo00D000000?ooo`000000oooo000000070?ooo`030000003oool0oooo00D0oooo000Q0?ooo`03
0000003oool0oooo06T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`05
0000003oool000000?ooo`000000203oool00`000000oooo0?ooo`050?ooo`050000003oool00000
0?ooo`0000002@3oool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`0000002@3o
ool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`000000203oool00`000000oooo
0?ooo`050?ooo`050000003oool000000?ooo`0000002@3oool00`000000oooo0?ooo`050?ooo`05
0000003oool000000?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`008@3oool2000006X0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`050000003oool000000?oo
o`000000203oool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`0000002@3oool0
0`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`000000203oool00`000000oooo0?oo
o`060?ooo`050000003oool000000?ooo`000000203oool00`000000oooo0?ooo`050?ooo`050000
003oool000000?ooo`0000002@3oool00`000000oooo0?ooo`050?ooo`050000003oool000000?oo
o`0000001`3oool00`000000oooo0?ooo`050?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool01@000000oooo0000003oool00000
00P0oooo00<000000?ooo`3oool01@3oool01@000000oooo0000003oool0000000T0oooo00<00000
0?ooo`3oool01@3oool01@000000oooo0000003oool0000000P0oooo00<000000?ooo`3oool01P3o
ool01@000000oooo0000003oool0000000P0oooo00<000000?ooo`3oool01@3oool01@000000oooo
0000003oool0000000T0oooo00<000000?ooo`3oool01@3oool01@000000oooo0000003oool00000
00L0oooo00<000000?ooo`3oool01@3oool00240oooo00<000000?ooo`3oool0J@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00D000000?ooo`000000oooo000000080?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`000000oooo000000080?ooo`030000003oool0
oooo00H0oooo00D000000?ooo`000000oooo000000080?ooo`030000003oool0oooo00H0oooo00D0
00000?ooo`000000oooo000000080?ooo`030000003oool0oooo00D0oooo00D000000?ooo`000000
oooo000000080?ooo`030000003oool0oooo00H0oooo00D000000?ooo`000000oooo000000070?oo
o`030000003oool0oooo00D0oooo000Q0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`060?ooo`050000003oool000000?ooo`0000001`3oool00`00
0000oooo0?ooo`060?ooo`050000003oool000000?ooo`000000203oool00`000000oooo0?ooo`06
0?ooo`050000003oool000000?ooo`000000203oool00`000000oooo0?ooo`060?ooo`050000003o
ool000000?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`050000003oool000000?ooo`00
0000203oool00`000000oooo0?ooo`060?ooo`050000003oool000000?ooo`0000001`3oool00`00
0000oooo0?ooo`050?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01`3oool01@000000oooo0000003oool0000000L0oooo00<000000?oo
o`3oool01P3oool01@000000oooo0000003oool0000000P0oooo00<000000?ooo`3oool01P3oool0
1@000000oooo0000003oool0000000P0oooo00<000000?ooo`3oool01P3oool01@000000oooo0000
003oool0000000L0oooo00<000000?ooo`3oool01P3oool01@000000oooo0000003oool0000000P0
oooo00<000000?ooo`3oool01P3oool01@000000oooo0000003oool0000000L0oooo00<000000?oo
o`3oool01@3oool00240oooo0P00001Z0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool01@000000oooo0000003oool0000000L0oooo00<000000?ooo`3oool01P3oool01@00
0000oooo0000003oool0000000P0oooo00<000000?ooo`3oool01P3oool01@000000oooo0000003o
ool0000000L0oooo00<000000?ooo`3oool01`3oool01@000000oooo0000003oool0000000L0oooo
00<000000?ooo`3oool01P3oool01@000000oooo0000003oool0000000P0oooo00<000000?ooo`3o
ool01P3oool01@000000oooo0000003oool0000000L0oooo00<000000?ooo`3oool01@3oool00240
oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo00D000000?ooo`000000oooo000000070?ooo`030000003oool0oooo00H0oooo00D000000?oo
o`000000oooo000000080?ooo`030000003oool0oooo00H0oooo00D000000?ooo`000000oooo0000
00070?ooo`030000003oool0oooo00L0oooo00D000000?ooo`000000oooo000000070?ooo`030000
003oool0oooo00H0oooo00D000000?ooo`000000oooo000000080?ooo`030000003oool0oooo00H0
oooo00D000000?ooo`000000oooo000000070?ooo`030000003oool0oooo00D0oooo00020?ooo`80
0000103oool00`000000oooo0?ooo`030?ooo`8000000`3oool400000080oooo0`0000050?ooo`03
0000003oool0oooo06T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`05
0000003oool000000?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`050000003oool00000
0?ooo`0000001`3oool00`000000oooo0?ooo`070?ooo`050000003oool000000?ooo`0000001`3o
ool00`000000oooo0?ooo`070?ooo`050000003oool000000?ooo`0000001`3oool00`000000oooo
0?ooo`060?ooo`050000003oool000000?ooo`0000001`3oool00`000000oooo0?ooo`070?ooo`05
0000003oool000000?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`0000D0oooo0000003o
ool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`050000003oool000000?ooo`0000001P3oool00`000000oooo0?oo
o`070?ooo`050000003oool000000?ooo`0000001`3oool00`000000oooo0?ooo`070?ooo`050000
003oool000000?ooo`0000001`3oool00`000000oooo0?ooo`070?ooo`050000003oool000000?oo
o`0000001P3oool00`000000oooo0?ooo`070?ooo`050000003oool000000?ooo`0000001`3oool0
0`000000oooo0?ooo`070?ooo`050000003oool000000?ooo`0000001`3oool00`000000oooo0?oo
o`050?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`800000JP3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000oooo000000060?ooo`03
0000003oool0oooo00L0oooo00D000000?ooo`000000oooo000000070?ooo`030000003oool0oooo
00L0oooo00D000000?ooo`000000oooo000000070?ooo`030000003oool0oooo00L0oooo00D00000
0?ooo`000000oooo000000060?ooo`030000003oool0oooo00L0oooo00D000000?ooo`000000oooo
000000070?ooo`030000003oool0oooo00L0oooo00D000000?ooo`000000oooo000000070?ooo`03
0000003oool0oooo00D0oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3o
ool00000103oool010000000oooo0?ooo`3oool3000000D0oooo00<000000?ooo`3oool0J@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000oooo0000
00060?ooo`030000003oool0oooo00L0oooo00D000000?ooo`000000oooo000000060?ooo`030000
003oool0oooo00P0oooo00D000000?ooo`000000oooo000000060?ooo`030000003oool0oooo00P0
oooo00D000000?ooo`000000oooo000000060?ooo`030000003oool0oooo00L0oooo00D000000?oo
o`000000oooo000000060?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000oooo0000
00060?ooo`030000003oool0oooo00H0oooo00001@3oool000000?ooo`3oool0000000P0oooo00@0
00000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3o
ool0J@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`00
0000oooo000000060?ooo`030000003oool0oooo00L0oooo00D000000?ooo`000000oooo00000006
0?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000oooo000000060?ooo`030000003o
ool0oooo00P0oooo00D000000?ooo`000000oooo000000060?ooo`030000003oool0oooo00L0oooo
00D000000?ooo`000000oooo000000060?ooo`030000003oool0oooo00P0oooo00D000000?ooo`00
0000oooo000000060?ooo`030000003oool0oooo00H0oooo00001@3oool000000?ooo`3oool00000
00P0oooo00@000000?ooo`3oool000000P3oool3000000<0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool0
1@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool0203oool01@000000oooo0000
003oool0000000H0oooo00<000000?ooo`3oool0203oool01@000000oooo0000003oool0000000H0
oooo00<000000?ooo`3oool0203oool01@000000oooo0000003oool0000000D0oooo00<000000?oo
o`3oool0203oool01@000000oooo0000003oool0000000H0oooo00<000000?ooo`3oool0203oool0
1@000000oooo0000003oool0000000H0oooo00<000000?ooo`3oool01P3oool00080oooo0P00000:
0?ooo`8000001@3oool010000000oooo0?ooo`3oool4000000@0oooo0P00001Z0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0203oool01@000000oooo0000003oool0000000D0oooo
00<000000?ooo`3oool0203oool01@000000oooo0000003oool0000000H0oooo00<000000?ooo`3o
ool0203oool01@000000oooo0000003oool0000000H0oooo00<000000?ooo`3oool0203oool01@00
0000oooo0000003oool0000000D0oooo00<000000?ooo`3oool0203oool01@000000oooo0000003o
ool0000000H0oooo00<000000?ooo`3oool0203oool01@000000oooo0000003oool0000000H0oooo
00<000000?ooo`3oool01P3oool00240oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000oooo000000050?ooo`030000
003oool0oooo00P0oooo00D000000?ooo`000000oooo000000060?ooo`030000003oool0oooo00P0
oooo00D000000?ooo`000000oooo000000050?ooo`030000003oool0oooo00T0oooo00D000000?oo
o`000000oooo000000050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000oooo0000
00060?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000oooo000000050?ooo`030000
003oool0oooo00L0oooo000Q0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`080?ooo`050000003oool000000?ooo`0000001@3oool00`000000oooo
0?ooo`080?ooo`050000003oool000000?ooo`0000001P3oool00`000000oooo0?ooo`080?ooo`05
0000003oool000000?ooo`0000001@3oool00`000000oooo0?ooo`090?ooo`050000003oool00000
0?ooo`0000001@3oool00`000000oooo0?ooo`080?ooo`050000003oool000000?ooo`0000001P3o
ool00`000000oooo0?ooo`080?ooo`050000003oool000000?ooo`0000001@3oool00`000000oooo
0?ooo`070?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02@3oool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool0
203oool01@000000oooo0000003oool0000000H0oooo00<000000?ooo`3oool0203oool01@000000
oooo0000003oool0000000D0oooo00<000000?ooo`3oool02@3oool01@000000oooo0000003oool0
000000D0oooo00<000000?ooo`3oool0203oool01@000000oooo0000003oool0000000H0oooo00<0
00000?ooo`3oool0203oool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool0
1`3oool00240oooo0P00001Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3o
ool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool0203oool01@000000oooo
0000003oool0000000D0oooo00<000000?ooo`3oool02@3oool01@000000oooo0000003oool00000
00D0oooo00<000000?ooo`3oool02@3oool01@000000oooo0000003oool0000000D0oooo00<00000
0?ooo`3oool0203oool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool02@3o
ool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool01`3oool00240oooo00<0
00000?ooo`3oool0J@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00D0
00000?ooo`000000oooo000000050?ooo`030000003oool0oooo00P0oooo00D000000?ooo`000000
oooo000000050?ooo`030000003oool0oooo00T0oooo00D000000?ooo`000000oooo000000050?oo
o`030000003oool0oooo00T0oooo00D000000?ooo`000000oooo000000050?ooo`030000003oool0
oooo00P0oooo00D000000?ooo`000000oooo000000050?ooo`030000003oool0oooo00T0oooo00D0
00000?ooo`000000oooo000000050?ooo`030000003oool0oooo00L0oooo000Q0?ooo`030000003o
ool0oooo06T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`050000003o
ool000000?ooo`000000103oool00`000000oooo0?ooo`090?ooo`050000003oool000000?ooo`00
00001@3oool00`000000oooo0?ooo`090?ooo`050000003oool000000?ooo`000000103oool00`00
0000oooo0?ooo`0:0?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0?ooo`09
0?ooo`050000003oool000000?ooo`0000001@3oool00`000000oooo0?ooo`090?ooo`050000003o
ool000000?ooo`0000001@3oool00`000000oooo0?ooo`070?ooo`008@3oool00`000000oooo0?oo
o`1Y0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool01@000000oooo0000
003oool0000000@0oooo00<000000?ooo`3oool02@3oool01@000000oooo0000003oool0000000D0
oooo00<000000?ooo`3oool02@3oool01@000000oooo0000003oool0000000@0oooo00<000000?oo
o`3oool02P3oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool02@3oool0
1@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool02@3oool01@000000oooo0000
003oool0000000D0oooo00<000000?ooo`3oool01`3oool00240oooo00<000000?ooo`3oool0J@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00D000000?ooo`000000oooo
000000040?ooo`030000003oool0oooo00T0oooo00D000000?ooo`000000oooo000000040?ooo`03
0000003oool0oooo00X0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo
00X0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00T0oooo00D00000
0?ooo`000000oooo000000040?ooo`030000003oool0oooo00X0oooo00D000000?ooo`000000oooo
000000040?ooo`030000003oool0oooo00P0oooo000Q0?ooo`800000JP3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00X0oooo00D000000?ooo`000000oooo000000040?ooo`030000
003oool0oooo00T0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00X0
oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00X0oooo00D000000?oo
o`000000oooo000000040?ooo`030000003oool0oooo00T0oooo00D000000?ooo`000000oooo0000
00040?ooo`030000003oool0oooo00X0oooo00D000000?ooo`000000oooo000000040?ooo`030000
003oool0oooo00P0oooo000Q0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0:0?ooo`050000003oool000000?ooo`000000103oool00`000000oooo
0?ooo`090?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0?ooo`0:0?ooo`05
0000003oool000000?ooo`000000103oool00`000000oooo0?ooo`0:0?ooo`050000003oool00000
0?ooo`000000103oool00`000000oooo0?ooo`090?ooo`050000003oool000000?ooo`000000103o
ool00`000000oooo0?ooo`0:0?ooo`050000003oool000000?ooo`000000103oool00`000000oooo
0?ooo`080?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool02P3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool0
2P3oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool02P3oool01@000000
oooo0000003oool0000000@0oooo00<000000?ooo`3oool02P3oool01@000000oooo0000003oool0
000000<0oooo00<000000?ooo`3oool02P3oool01@000000oooo0000003oool0000000@0oooo00<0
00000?ooo`3oool02P3oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool0
203oool00240oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00/0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000`0oooo00D000000?ooo`00
0000oooo000000040?ooo`030000003oool0oooo00X0oooo00D000000?ooo`000000oooo00000003
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000`0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00P0oooo
000Q0?ooo`800000JP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00D0
00000?ooo`000000oooo000000030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`000000
0P3oool010000000oooo0?ooo`00000=0?ooo`050000003oool000000?ooo`0000000`3oool00`00
0000oooo0?ooo`0;0?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003@3oool01@000000oooo0000
003oool0000000<0oooo00<000000?ooo`3oool02@3oool00240oooo00<000000?ooo`3oool0J@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0oooo00X0oooo0P0000030?ooo`040000003oool0oooo000000d0
oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000003@3oool200000080oooo00D000000?oo
o`3oool0oooo0000000<0?ooo`8000000`3oool010000000oooo0?ooo`00000=0?ooo`8000000P3o
ool01@000000oooo0?ooo`3oool0000000/0oooo00080?ooo`800000103oool00`000000oooo0?oo
o`030?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00/0oooo00D000000?ooo`000000oooo000000030?ooo`030000
003oool0oooo00X0oooo0P0000030?ooo`040000003oool0oooo000000d0oooo0P0000020?ooo`05
0000003oool0oooo0?ooo`0000003@3oool200000080oooo00D000000?ooo`3oool0oooo0000000<
0?ooo`8000000`3oool010000000oooo0?ooo`00000=0?ooo`8000000P3oool01@000000oooo0?oo
o`3oool0000000/0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0;0?ooo`8000000P3oool010000000oooo0?ooo`00000=0?oo
o`8000000`3oool010000000oooo0?ooo`00000=0?ooo`8000000P3oool01@000000oooo0?ooo`3o
ool0000000d0oooo0P0000020?ooo`040000003oool0oooo000000d0oooo0P0000030?ooo`040000
003oool0oooo000000d0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000002`3oool000L0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0
oooo00@0oooo0P00001Z0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool2
00000080oooo00@000000?ooo`3oool000003@3oool2000000<0oooo00@000000?ooo`3oool00000
3@3oool200000080oooo00D000000?ooo`3oool0oooo0000000=0?ooo`8000000P3oool010000000
oooo0?ooo`00000=0?ooo`8000000`3oool010000000oooo0?ooo`00000=0?ooo`8000000P3oool0
1@000000oooo0?ooo`3oool0000000/0oooo00070?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06T0oooo
00D000000?ooo`3oool0oooo0000000>0?ooo`8000000P3oool010000000oooo0?ooo`00000=0?oo
o`8000000`3oool010000000oooo0?ooo`00000=0?ooo`8000000P3oool01@000000oooo0?ooo`3o
ool0000000d0oooo0P0000020?ooo`040000003oool0oooo000000d0oooo0P0000030?ooo`040000
003oool0oooo000000d0oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000002`3oool000L0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000050?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0J@3oool01@000000oooo0?ooo`3oool0000000h0oooo0P00
00020?ooo`040000003oool0oooo000000h0oooo00L000000?ooo`3oool0oooo0000003oool00000
00h0oooo0P0000020?ooo`040000003oool0oooo000000h0oooo0P0000020?ooo`040000003oool0
oooo000000h0oooo00L000000?ooo`3oool0oooo0000003oool0000000h0oooo0P0000020?ooo`04
0000003oool0oooo000000`0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo06T0oooo00D0
00000?ooo`3oool0oooo0000000>0?ooo`8000000P3oool010000000oooo0?ooo`00000>0?ooo`07
0000003oool0oooo0?ooo`000000oooo0000000>0?ooo`8000000P3oool010000000oooo0?ooo`00
000>0?ooo`8000000P3oool010000000oooo0?ooo`00000>0?ooo`070000003oool0oooo0?ooo`00
0000oooo0000000>0?ooo`8000000P3oool010000000oooo0?ooo`00000<0?ooo`00203oool20000
00X0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`1Y0?ooo`050000003oool0oooo
0?ooo`0000003P3oool200000080oooo00@000000?ooo`3oool000003P3oool01`000000oooo0?oo
o`3oool000000?ooo`0000003P3oool200000080oooo00@000000?ooo`3oool000003P3oool20000
0080oooo00@000000?ooo`3oool000003P3oool01`000000oooo0?ooo`3oool000000?ooo`000000
3P3oool200000080oooo00@000000?ooo`3oool00000303oool00240oooo0P00001Z0?ooo`050000
003oool0oooo0?ooo`0000003P3oool200000080oooo00<000000?ooo`0000003`3oool01`000000
oooo0?ooo`3oool000000?ooo`0000003P3oool200000080oooo00@000000?ooo`3oool000003P3o
ool200000080oooo00<000000?ooo`0000003`3oool01`000000oooo0?ooo`3oool000000?ooo`00
00003P3oool200000080oooo00@000000?ooo`3oool00000303oool00240oooo00<000000?ooo`3o
ool0J@3oool010000000oooo0?ooo`00000?0?ooo`8000000P3oool00`000000oooo0000000?0?oo
o`070000003oool0oooo0?ooo`000000oooo0000000>0?ooo`8000000P3oool010000000oooo0?oo
o`00000>0?ooo`8000000P3oool00`000000oooo0000000?0?ooo`070000003oool0oooo0?ooo`00
0000oooo0000000>0?ooo`8000000P3oool010000000oooo0?ooo`00000<0?ooo`008@3oool00`00
0000oooo0?ooo`1Y0?ooo`040000003oool0oooo000000l0oooo0P0000020?ooo`030000003oool0
000000l0oooo00L000000?ooo`3oool0oooo0000003oool0000000h0oooo0P0000020?ooo`040000
003oool0oooo000000h0oooo0P0000020?ooo`030000003oool0000000l0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000h0oooo0P0000020?ooo`040000003oool0oooo000000`0oooo000Q
0?ooo`030000003oool0oooo06T0oooo00@000000?ooo`3oool000003`3oool2000000<0oooo0P00
000?0?ooo`040000003oool0oooo0?ooo`8000003`3oool2000000<0oooo0P00000?0?ooo`800000
0`3oool2000000l0oooo00@000000?ooo`3oool0oooo0P00000?0?ooo`8000000`3oool2000000d0
oooo000Q0?ooo`800000JP3oool010000000oooo0?ooo`00000?0?ooo`8000000`3oool2000000l0
oooo00@000000?ooo`3oool0oooo0P00000?0?ooo`8000000`3oool2000000l0oooo0P0000030?oo
o`8000003`3oool010000000oooo0?ooo`3oool2000000l0oooo0P0000030?ooo`8000003@3oool0
0240oooo00<000000?ooo`3oool0J@3oool010000000oooo0?ooo`00000?0?ooo`8000000`3oool0
0`000000oooo0?ooo`0>0?ooo`040000003oool0oooo0?ooo`8000003`3oool2000000<0oooo00<0
00000?ooo`3oool03P3oool2000000<0oooo00<000000?ooo`3oool03P3oool010000000oooo0?oo
o`3oool2000000l0oooo0P0000030?ooo`030000003oool0oooo00`0oooo000Q0?ooo`030000003o
ool0oooo06T0oooo00@000000?ooo`3oool000003`3oool2000000<0oooo00<000000?ooo`3oool0
3P3oool010000000oooo0?ooo`3oool2000000l0oooo0P0000030?ooo`030000003oool0oooo00h0
oooo0P0000030?ooo`030000003oool0oooo00h0oooo00@000000?ooo`3oool0oooo0P00000?0?oo
o`8000000`3oool00`000000oooo0?ooo`0<0?ooo`008@3oool00`000000oooo0?ooo`1Y0?ooo`03
0000003oool000000100oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000D0?ooo`80
0000503oool00`000000oooo0?ooo`0B0?ooo`8000004P3oool00240oooo0P00001[0?ooo`800000
403oool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000
003oool0oooo0180oooo0P00000B0?ooo`008@3oool00`000000oooo0?ooo`1Z0?ooo`800000403o
ool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000003o
ool0oooo0180oooo0P00000B0?ooo`008@3oool00`000000oooo0?ooo`1Z0?ooo`800000403oool2
000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0
oooo0180oooo0P00000B0?ooo`008@3oool00`000000oooo0?ooo`1Z0?ooo`800000403oool20000
01@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0oooo
0180oooo0P00000B0?ooo`008@3oool2000007d0oooo0P00000D0?ooo`030000003oool0oooo0180
oooo0P00000D0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`8000004P3oool00240oooo
00<000000?ooo`3oool0O03oool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo
0P00000D0?ooo`030000003oool0oooo0180oooo0P00000B0?ooo`008@3oool00`000000oooo0?oo
o`1l0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo00<0
00000?ooo`3oool04P3oool200000180oooo00020?ooo`800000103oool00`000000oooo0?ooo`03
0?ooo`8000000`3oool400000080oooo0`0000050?ooo`030000003oool0oooo07`0oooo0P00000D
0?ooo`030000003oool0oooo0180oooo0P00000D0?ooo`800000503oool00`000000oooo0?ooo`0B
0?ooo`8000004P3oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1l0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo00<0
00000?ooo`3oool04P3oool200000180oooo00001@3oool000000?ooo`3oool0000000P0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo
0P00001m0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo
00<000000?ooo`3oool04P3oool200000180oooo00001@3oool000000?ooo`3oool0000000P0oooo
00@000000?ooo`3oool00000103oool010000000oooo0?ooo`3oool3000000D0oooo00<000000?oo
o`3oool0O03oool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D0?oo
o`030000003oool0oooo0180oooo0P00000B0?ooo`0000D0oooo0000003oool0oooo000000080?oo
o`040000003oool0oooo000000D0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?oo
o`1l0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo00<0
00000?ooo`3oool04P3oool200000180oooo00001@3oool000000?ooo`3oool0000000P0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0O03oool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0
oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000B0?ooo`000P3oool2000000X0oooo
0P0000040?ooo`8000000`3oool4000000@0oooo0P00001m0?ooo`800000503oool00`000000oooo
0?ooo`0B0?ooo`800000503oool2000001@0oooo00<000000?ooo`3oool04P3oool200000180oooo
000Q0?ooo`030000003oool0oooo07`0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00
000D0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`8000004P3oool00240oooo00<00000
0?ooo`3oool0O03oool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D
0?ooo`030000003oool0oooo0180oooo0P00000B0?ooo`008@3oool00`000000oooo0?ooo`1l0?oo
o`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo00<000000?oo
o`3oool04P3oool200000180oooo000Q0?ooo`800000O@3oool2000001@0oooo00<000000?ooo`3o
ool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000B0?ooo`00
8@3oool00`000000oooo0?ooo`1l0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000
503oool2000001@0oooo00<000000?ooo`3oool04P3oool200000180oooo000Q0?ooo`030000003o
ool0oooo07`0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000D0?ooo`800000503o
ool00`000000oooo0?ooo`0B0?ooo`8000004P3oool00240oooo00<000000?ooo`3oool0O03oool2
000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0
oooo0180oooo0P00000B0?ooo`008@3oool00`000000oooo0?ooo`1l0?ooo`800000503oool00`00
0000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo00<000000?ooo`3oool04P3oool20000
0180oooo000Q0?ooo`800000O@3oool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0
oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000B0?ooo`008@3oool00`000000oooo
0?ooo`1l0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000503oool2000001@0oooo
00<000000?ooo`3oool04P3oool200000180oooo000Q0?ooo`030000003oool0oooo07`0oooo0P00
000D0?ooo`030000003oool0oooo0180oooo0P00000D0?ooo`800000503oool00`000000oooo0?oo
o`0B0?ooo`8000004P3oool00240oooo00<000000?ooo`3oool0O03oool2000001@0oooo00<00000
0?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000B
0?ooo`008@3oool2000007d0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000D0?oo
o`800000503oool00`000000oooo0?ooo`0B0?ooo`8000004P3oool00240oooo00<000000?ooo`3o
ool0O03oool2000001@0oooo00<000000?ooo`3oool04P3oool2000001@0oooo0P00000D0?ooo`03
0000003oool0oooo0180oooo0P00000B0?ooo`00203oool2000000@0oooo00<000000?ooo`3oool0
0`3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo07`0oooo0P00000D0?ooo`030000
003oool0oooo0180oooo0P00000D0?ooo`800000503oool00`000000oooo0?ooo`0B0?ooo`800000
4P3oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0O03oool2000001@0oooo00<000000?oo
o`3oool04P3oool2000001@0oooo0P00000D0?ooo`030000003oool0oooo0180oooo0P00000B0?oo
o`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool00P3oool2000007d0oooo0P00000D0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0403oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00030?ooo`8000001@3oool00`000000oooo0?ooo`1l0?ooo`800000503oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo0100oooo00070?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07d0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo
00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00080?ooo`8000002P3oool2000000@0
oooo0P0000050?ooo`800000OP3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0403oool00240oooo00<000000?ooo`3oool0O@3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool00240oooo00<0
00000?ooo`3oool0O@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0403oool00240oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool00240oooo00<000000?oo
o`3oool0O@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0403oool00240oooo0P00001n0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0@0?ooo`008@3oool00`000000oooo0?ooo`1m0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`008@3o
ool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0@0?ooo`008@3oool00`000000oooo0?ooo`1m0?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`008@3oool20000
07h0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
0100oooo000Q0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo000Q0?ooo`030000003oool0oooo07d0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo
000Q0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo0100oooo000Q0?ooo`800000OP3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool00240oooo00<000000?oo
o`3oool0O@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0403oool00240oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool00080oooo0P0000040?ooo`030000
003oool0oooo00<0oooo0P0000040?ooo`8000000`3oool3000000D0oooo00<000000?ooo`3oool0
O@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
403oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1m0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?oo
o`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`800000OP3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool000050?ooo`000000oooo
0?ooo`000000203oool010000000oooo0?ooo`0000030?ooo`8000000`3oool3000000D0oooo00<0
00000?ooo`3oool0O@3oool00`000000oooo0?ooo`1l0?ooo`0000D0oooo0000003oool0oooo0000
00080?ooo`040000003oool0oooo000000D0oooo00@000000?ooo`3oool000001`3oool00`000000
oooo0?ooo`1m0?ooo`030000003oool0oooo07`0oooo00001@3oool000000?ooo`3oool0000000P0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`1l0?ooo`000P3oool20000
00X0oooo0P0000040?ooo`8000000`3oool4000000@0oooo0P00003m0?ooo`008@3oool00`000000
oooo0?ooo`3l0?ooo`008@3oool00`000000oooo0?ooo`3l0?ooo`008@3oool00`000000oooo0?oo
o`3l0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.34204, -0.00374986, \
0.0403632, 0.000233393}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
  CellTags->"s:3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["Method",
              "MR"], 
            StyleBox[\({Automatic, Automatic}\),
              
              "MR"], \(specifies\ the\ methods\ to\ use\ for\ the\ nonstiff\ \
and\ stiff\ solvers\ respectively\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of the method ",
  StyleBox["StiffnessSwitching", "MR"],
  ". "
}], "Caption"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for X",
ScreenRectangle->{{0, 1600}, {0, 1200}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Brackets",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StiffnessSwitching",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:1"->{
    Cell[1776, 53, 56, 1, 95, "Chapter",
      CellTags->"c:1"]},
  "s:1"->{
    Cell[1857, 58, 50, 1, 66, "Section",
      CellTags->"s:1"]},
  "s:2"->{
    Cell[3074, 104, 46, 1, 66, "Section",
      CellTags->"s:2"]},
  "s:3"->{
    Cell[103088, 3695, 52, 1, 66, "Section",
      CellTags->"s:3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:1", 104578, 3743},
  {"s:1", 104655, 3746},
  {"s:2", 104732, 3749},
  {"s:3", 104810, 3752}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 56, 1, 95, "Chapter",
  CellTags->"c:1"],

Cell[CellGroupData[{
Cell[1857, 58, 50, 1, 66, "Section",
  CellTags->"s:1"],
Cell[1910, 61, 198, 5, 40, "Text"],
Cell[2111, 68, 301, 11, 40, "Text"],
Cell[2415, 81, 206, 6, 40, "Text"],
Cell[2624, 89, 413, 10, 56, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3074, 104, 46, 1, 66, "Section",
  CellTags->"s:2"],
Cell[3123, 107, 55, 0, 40, "MathCaption"],
Cell[3181, 109, 236, 5, 42, "Input",
  InitializationCell->True],
Cell[3420, 116, 192, 5, 56, "MathCaption"],
Cell[3615, 123, 184, 4, 42, "Input"],
Cell[3802, 129, 172, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[3999, 138, 108, 2, 26, "Input"],
Cell[4110, 142, 416, 7, 44, "Message"],
Cell[4529, 151, 647, 19, 41, "Output"]
}, Open  ]],
Cell[5191, 173, 165, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[5381, 181, 113, 2, 26, "Input"],
Cell[5497, 185, 545, 15, 41, "Output"]
}, Open  ]],
Cell[6057, 203, 332, 9, 56, "Text"],
Cell[6392, 214, 249, 7, 40, "Text"],
Cell[6644, 223, 160, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[6829, 231, 169, 3, 42, "Input"],
Cell[7001, 236, 413, 7, 44, "Message"],
Cell[7417, 245, 641, 19, 41, "Output"]
}, Open  ]],
Cell[8073, 267, 172, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[8270, 277, 267, 6, 58, "Input"],
Cell[8540, 285, 546, 15, 41, "Output"]
}, Open  ]],
Cell[9101, 303, 244, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[9370, 313, 75, 2, 26, "Input"],
Cell[9448, 317, 93433, 3366, 184, 42310, 2730, "GraphicsData", "PostScript", \
"Graphics"],
Cell[102884, 3685, 155, 4, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[103088, 3695, 52, 1, 66, "Section",
  CellTags->"s:3"],
Cell[103143, 3698, 501, 12, 80, "DefinitionBox3Col"],
Cell[103647, 3712, 105, 4, 16, "Caption"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

