(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10413,        349]*)
(*NotebookOutlinePosition[     11688,        396]*)
(*  CellTagsIndexPosition[     11540,        387]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["StiffnessTest", "Chapter"],

Cell[CellGroupData[{

Cell["Overview", "Section",
  CellTags->"s:1"],

Cell[TextData[{
  "The methods ",
  StyleBox["DoubleStep", "MR"],
  ", ",
  StyleBox["Extrapolation", "MR"],
  ", and ",
  StyleBox["ExplicitRungeKutta", "MR"],
  " have the option ",
  StyleBox["StiffnessTest", "MR"],
  ", which can be used to identify whether the method applied with the \
specified ",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " tolerances to a given problem is stiff."
}], "Text"],

Cell[TextData[{
  "A convenient way of detecting stiffness is to directly estimate the \
dominant eigenvalue of the Jacobian ",
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  " of the problem (see [",
  ButtonBox["S84",
    ButtonData:>{"References.nb", "S84"},
    ButtonStyle->"Hyperlink"],
  "] and [",
  ButtonBox["R87",
    ButtonData:>{"References.nb", "R87"},
    ButtonStyle->"Hyperlink"],
  "])."
}], "Text"],

Cell["\<\
Such an estimate is often available as a byproduct of the numerical \
integration and so it is reasonably inexpensive.\
\>", "Text"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " denotes an approximation to the eigenvector corresponding to dominant \
eigenvalue of the Jacobian, with ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]v\
\[RightDoubleBracketingBar]\)]],
  " sufficiently small, then by the mean value theorem a good approximation \
to the leading eigenvalue is:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Lambda]\& \[Tilde] \), "=", 
        FormBox[\(\[LeftDoubleBracketingBar]f(t, \ y\  + \ v)\  - \ 
                  f(t, \ y)\[RightDoubleBracketingBar]\/\
\[LeftDoubleBracketingBar]v\[RightDoubleBracketingBar]\),
          "TraditionalForm"]}], TraditionalForm]], "DisplayFormula"],

Cell["\<\
Richardson's extrapolation provides a sequence of refinements that \
yield a quantity of this form as do certain explicit Runge-Kutta \
methods.\
\>", "Text"],

Cell["\<\
Let LSB denote the linear stability boundary\[LongDash]the \
intersection of the linear stability region with the negative real \
axis.\
\>", "Text"],

Cell[TextData[{
  "The product",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`h\ \ \(\[Lambda]\& \[Tilde] \)\)]],
  " gives an estimate that can be compared to the linear stability boundary \
of a method in order to detect stiffness."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(|\)\(h\ \ \(\[Lambda]\& \[Tilde] \)\)\(|\)\(\ \)\(\
\(\[LessEqual]\)\(\(|\)\(\ \)\(LSB\)\(|\)\)\)\)\)], "NumberedEquation",
  CellTags->"StiffnessTest"],

Cell[TextData[{
  "The method option ",
  StyleBox["StiffnessTest", "MR"],
  " itself accepts a number of options that are now illustrated."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section",
  CellTags->"s:2"],

Cell[TextData[{
  "The default values for the stiffness test implement a weak form of ",
  "(",
  
  CounterBox["NumberedEquation", "StiffnessTest"],
  ")",
  " where the test incorporates a safety factor and is allowed to fail a \
specified number of times."
}], "Text"],

Cell["\<\
The reason for this is that some problems can be only mildly stiff \
in a certain region and an explicit integration method may still be \
efficient.\
\>", "Text"],

Cell["\<\
This loads a package with some predefined examples and selects one \
of the examples.\
\>", "Text"],

Cell[BoxData[
    \(\(Needs["\<DifferentialEquations`NDSolveProblems`\>"];\)\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \(\(system\  = \ GetNDSolveProblem["\<VanderPol\>"];\)\)], "Input",
  CellLabel->"In[34]:="],

Cell[TextData[{
  "The problem is integrated successfully with the given method and the \
default option settings for ",
  StyleBox["StiffnessTest", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[system, \ 
      Method\  \[Rule] \ "\<ExplicitRungeKutta\>"]\)], "Input",
  CellLabel->"In[35]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 2.5`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              TagBox[\(InterpolatingFunction[{{0.`, 2.5`}}, "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[35]="]
}, Open  ]],

Cell["\<\
A longer integration is aborted and a message is issued when the \
stiffness test condition is not satisfied.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[system, \ {T, \ 0, \ 10}, \ 
      Method\  \[Rule] \ "\<ExplicitRungeKutta\>"]\)], "Input",
  CellLabel->"In[36]:="],

Cell[BoxData[
    \(NDSolve::"ndstf" \(\(:\)\(\ \)\) 
      "At \!\(T\) == \!\(5.204811749183198`\), system appears to be stiff. \
Methods Automatic, BDF or StiffnessSwitching may be more appropriate."\)], \
"Message",
  CellLabel->"From In[36]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 5.204811749183198`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 5.204811749183198`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[36]="]
}, Open  ]],

Cell["\<\
Using a unit safety factor and specifying that only one stiffness \
failure is allowed effectively gives a strict test. The specification uses \
the nested method option syntax.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[system, 
      Method\  \[Rule] \ {"\<ExplicitRungeKutta\>", \ 
          StiffnessTest \[Rule] {True, \ "\<MaxStiffnessTestFailures\>"\  \
\[Rule] \ 1, \ "\<StiffnessTestSafetyFactor\>" \[Rule] 1}\ }]\)], "Input",
  CellLabel->"In[37]:="],

Cell[BoxData[
    \(NDSolve::"ndstf" \(\(:\)\(\ \)\) 
      "At \!\(T\) == \!\(1.706187411666783`\), system appears to be stiff. \
Methods Automatic, BDF or StiffnessSwitching may be more appropriate."\)], \
"Message",
  CellLabel->"From In[37]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{\(Y\_1[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 1.706187411666783`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}], ",", 
          RowBox[{\(Y\_2[T]\), "\[Rule]", 
            RowBox[{
              
              TagBox[\(InterpolatingFunction[{{0.`, 1.706187411666783`}}, 
                  "<>"]\),
                False,
                Editable->False], "[", "T", "]"}]}]}], "}"}], "}"}]], "Output",\

  CellLabel->"Out[37]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option summary", "Section",
  CellTags->"s:3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["MaxStiffnessTestFailures",
              "MR"], 
            StyleBox["3",
              "MR"], Cell[TextData[{
              
              "Specifies the maximum number of times that the stiffness test \
",
              "(",
              
              CounterBox["NumberedEquation", "StiffnessTest"],
              ")",
              " is allowed to fail."
            }], "Text"]},
          {
            StyleBox["StiffnessTestSafetyFactor",
              "MR"], 
            FractionBox[
              StyleBox["9",
                "MR"], "10"], 
            RowBox[{
            "Specifies", " ", "the", " ", "safety", " ", "factor", " ", "to", 
              " ", "use", " ", "in", " ", "the", " ", "left", " ", "hand", 
              " ", "side", " ", "of", " ", "the", " ", "stiffness", " ", 
              "test", " ", 
              RowBox[{
                RowBox[{"(", 
                  CounterBox["NumberedEquation", "StiffnessTest"], ")"}], 
                "."}]}]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell["Options of the method option StiffnessTest. ", "Caption"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1280}, {0, 1002}},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StiffnessTest",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "s:1"->{
    Cell[1833, 57, 46, 1, 61, "Section",
      CellTags->"s:1"]},
  "StiffnessTest"->{
    Cell[4220, 140, 193, 3, 39, "NumberedEquation",
      CellTags->"StiffnessTest"]},
  "s:2"->{
    Cell[4605, 154, 46, 1, 61, "Section",
      CellTags->"s:2"]},
  "s:3"->{
    Cell[8987, 306, 52, 1, 61, "Section",
      CellTags->"s:3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"s:1", 11185, 371},
  {"StiffnessTest", 11272, 374},
  {"s:2", 11370, 377},
  {"s:3", 11448, 380}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 32, 0, 88, "Chapter"],

Cell[CellGroupData[{
Cell[1833, 57, 46, 1, 61, "Section",
  CellTags->"s:1"],
Cell[1882, 60, 441, 15, 56, "Text"],
Cell[2326, 77, 420, 14, 40, "Text"],
Cell[2749, 93, 142, 3, 24, "Text"],
Cell[2894, 98, 408, 11, 40, "Text"],
Cell[3305, 111, 327, 6, 47, "DisplayFormula"],
Cell[3635, 119, 168, 4, 40, "Text"],
Cell[3806, 125, 159, 4, 24, "Text"],
Cell[3968, 131, 249, 7, 44, "Text"],
Cell[4220, 140, 193, 3, 39, "NumberedEquation",
  CellTags->"StiffnessTest"],
Cell[4416, 145, 152, 4, 24, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4605, 154, 46, 1, 61, "Section",
  CellTags->"s:2"],
Cell[4654, 157, 271, 8, 35, "Text"],
Cell[4928, 167, 173, 4, 35, "Text"],
Cell[5104, 173, 109, 3, 21, "Text"],
Cell[5216, 178, 114, 2, 24, "Input"],
Cell[5333, 182, 110, 2, 24, "Input"],
Cell[5446, 186, 173, 5, 24, "Text"],

Cell[CellGroupData[{
Cell[5644, 195, 127, 3, 24, "Input"],
Cell[5774, 200, 546, 15, 41, "Output"]
}, Open  ]],
Cell[6335, 218, 133, 3, 24, "Text"],

Cell[CellGroupData[{
Cell[6493, 225, 145, 3, 26, "Input"],
Cell[6641, 230, 248, 5, 33, "Message"],
Cell[6892, 237, 642, 19, 41, "Output"]
}, Open  ]],
Cell[7549, 259, 201, 4, 40, "Text"],

Cell[CellGroupData[{
Cell[7775, 267, 267, 5, 58, "Input"],
Cell[8045, 274, 248, 5, 33, "Message"],
Cell[8296, 281, 642, 19, 41, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8987, 306, 52, 1, 61, "Section",
  CellTags->"s:3"],
Cell[9042, 309, 1277, 34, 122, "DefinitionBox3Col"],
Cell[10322, 345, 63, 0, 15, "Caption"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

