(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22803,        727]*)
(*NotebookOutlinePosition[     23944,        768]*)
(*  CellTagsIndexPosition[     23825,        760]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Norms in NDSolve", "Chapter"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " uses norms of error estimates to determine when solutions satisfy error \
tolerances.  In nearly all cases a norm which has been weighted, or scaled, \
such that it is less than 1 if error tolerances have been satisfied and \
greater than one if error tolerances are not satisfied.  One significant \
advantage of such a scaled norm is that a given method can be written without \
explicit reference to tolerances:  the satisfaction of tolerances however \
specified is found by comparing the scaled norm to 1, thus simplifying the \
code required for checking error estimates within methods."
}], "Text"],

Cell[TextData[{
  "Suppose that ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " is vector and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is a reference vector to compute weights with (typically ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " is an approximate solution vector).  Then the scaled vector, ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  " to which the norm is applied has components:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`w\_i = 
      v\_i\/\(t\_a + t\_r\ u\_i\)\)], "NumberedEquation",
  CellTags->"scaling"],

Cell[TextData[{
  "where absolute and relative tolerances, ",
  Cell[BoxData[
      \(TraditionalForm\`t\_a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\_r\)]],
  " are derived respectively from the ",
  StyleBox["AccuracyGoal->ag", "MR"],
  " and ",
  StyleBox["PrecisionGoal->pg", "MR"],
  " options by  ",
  Cell[BoxData[
      \(TraditionalForm\`t\_a\  = \ 10\^\(-ag\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\_r\  = \ 10\^\(-pg\)\)]],
  ".  "
}], "Text"],

Cell[TextData[{
  "The actual norm used is determined by the setting for the ",
  StyleBox["NormFunction", "MR"],
  " option given to ",
  StyleBox["NDSolve", "MR"],
  ".  "
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["NormFunction",
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell["\<\
A function to use to compute norms of error estimates in NDSolve.\
\>", "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell["NormFunction option to NDSolve.", "Caption"],

Cell[TextData[{
  "The setting for the  ",
  StyleBox["NormFunction", "MR"],
  " option can be any function which returns a scalar for a vector argument \
and satisfies the properties of a norm.  If you specify a function that does \
not satisfy the required properties of a norm, NDSolve will almost surely run \
into problems and give an answer, if any, which is incorrect.  "
}], "Text"],

Cell[TextData[{
  "The default value of ",
  StyleBox["Automatic", "MR"],
  " means that NDSolve may use different norms for different methods.  Most \
methods use an infinity-norm, but the IDA method for ",
  ButtonBox["DAE",
    ButtonData:>{"DAE.nb", None},
    ButtonStyle->"Hyperlink"],
  "s uses a 2-norm  because that helps maintain smoothness in the merit \
function for finding roots of the residual.   ",
  "It is strongly recommended that you use ",
  ButtonBox["Norm",
    ButtonStyle->"RefGuideLink"],
  " with a particular value of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ".  For this reason, you can also use the shorthand ",
  StyleBox["NormFunction->p", "MR"],
  " in place of ",
  StyleBox["NormFunction->(Norm[#, ", "MR"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(p\)\(]\)\), "/", 
          SuperscriptBox[
            RowBox[{
              StyleBox["Length",
                "MR"], "[", "#", "]"}], \(1/p\)]}], TraditionalForm]]],
  StyleBox["&).  ", "MR"],
  "The most commonly used implementations for p = 1, p = 2, and p = \
\[Infinity] have been specially optimized for speed."
}], "Text"],

Cell["\<\
This compares the overall error for computing the solution to the simple \
harmonic oscillator over 100 cycles with different norms specified.  \
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      First[\((1\  - \ x[100\ \[Pi]])\)\  /. \ 
            NDSolve[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ 
                x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, \ 
              x, \ {t, 0, 100\ \[Pi]}, \ Method \[Rule] ExplicitRungeKutta, \ 
              NormFunction \[Rule] #]] &, \ {1, \ 
        2, \ \[Infinity]}]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({8.447183419413307`*^-8, 7.374100352564028`*^-8, 
      5.727682927947342`*^-8}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell[TextData[{
  "The reason that error decreases with increasing ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " is because the norms are normalized by  multiplying with ",
  Cell[BoxData[
      \(TraditionalForm\`1/n\^\(1/p\)\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is the length of the vector.  This is often important in NDSolve because \
in many cases, an attempt is being made to check the approximation to a \
function, where more points should give a better approximation, or less \
error."
}], "Text"],

Cell[TextData[{
  "Consider a ",
  ButtonBox["finite difference",
    ButtonData:>{"PDE.nb", "b:7.1.0"},
    ButtonStyle->"Hyperlink"],
  " approximation to the first derivative of a periodic function ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " given by ",
  Cell[BoxData[
      \(TraditionalForm\`\(u\_i\%'\)\  = \ \(u\_\(i + 1\)\  - \ u\_i\)\/\(\(\ \
\)\(h\)\)\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`u\_i\  = \ u(x\_i)\)]],
  " on a grid with uniform spacing ",
  Cell[BoxData[
      \(TraditionalForm\`h\  = \ x\_\(i + 1\) - \ x\_i\)]],
  ".  In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", this can easily be computed using ",
  ButtonBox["ListCorrelate",
    ButtonStyle->"RefGuideLink"],
  ".  "
}], "Text"],

Cell["\<\
This computes the error of the first derivative approximation for the cosine \
function on a grid with 16 points covering the interval [0, 2\[Pi]]\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h\  = \ 2  \[Pi]/16. ;\)\), "\[IndentingNewLine]", 
    \(\(grid\  = \ h\ Range[16];\)\), "\[IndentingNewLine]", 
    \(err16\  = \ 
      Sin[grid]\  - \ 
        ListCorrelate[{1, \(-1\)}/h, \ Cos[grid], \ {1, 1}]\)}], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({\(-0.16932384605030953`\), \(-0.11903049272323196`\), \
\(-0.05061582589314606`\), 0.025504641595567312`, 0.0977422586015072`, 
      0.15509950277114803`, 0.188844253624376`, 0.193839178740714`, 
      0.16932384605030942`, 0.11903049272323096`, 
      0.05061582589314717`, \(-0.025504641595566313`\), \
\(-0.09774225860150798`\), \(-0.1550995027711488`\), \
\(-0.18884425362437562`\), \(-0.19383917874071413`\)}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["\<\
This computes the error of the first derivative approximation for the cosine \
function on a grid with 32 points covering the interval [0, 2\[Pi]]\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h\  = \ 2  \[Pi]/32. ;\)\), "\[IndentingNewLine]", 
    \(\(grid\  = \ h\ Range[32];\)\), "\[IndentingNewLine]", 
    \(err32\  = \ 
      Sin[grid]\  - \ 
        ListCorrelate[{1, \(-1\)}/h, \ Cos[grid], \ {1, 1}]\)}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({\(-0.09472827213888085`\), \(-0.08795642657727393`\), \
\(-0.07780446486883275`\), \(-0.06466252120873017`\), \(-0.04903563312173598`\
\), \(-0.031524333153372885`\), \(-0.012801570740975432`\), 
      0.006413148855794248`, 0.025381414738570696`, 0.043374287087006635`, 
      0.05970030990726649`, 0.07373208329811132`, 0.08493037407723936`, 
      0.09286483821008079`, 0.09723055868970995`, 0.09785976332641878`, 
      0.09472827213888074`, 0.08795642657727226`, 0.0778044648688343`, 
      0.0646625212087315`, 0.04903563312173265`, 0.031524333153373885`, 
      0.012801570740976653`, \(-0.006413148855793138`\), \
\(-0.02538141473856992`\), \(-0.043374287087008745`\), \
\(-0.05970030990726605`\), \(-0.07373208329811187`\), \(-0.08493037407724024`\
\), \(-0.0928648382100804`\), \(-0.09723055868970917`\), \
\(-0.09785976332641891`\)}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["\<\
It is quite apparent that the pointwise error is significantly less with a \
larger number of points.\
\>", "Text"],

Cell["\<\
The 2 norms of the vectors are of the same order of magnitude\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Norm[err16, 2], \ Norm[err32, 2]}\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({0.5529854533912648`, 0.392278712275836`}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "The reason the norms of the vectors are comparable is because the number \
of components in the vector has increased, so the usual linear algebra norm \
does not properly reflect the convergence.  Normalizing by multiplying by ",
  Cell[BoxData[
      \(TraditionalForm\`1/n\^\(1/p\)\)]],
  "reflects the convergence in the function space properly."
}], "Text"],

Cell["\<\
The normalized 2 norms of the vectors reflect the convergence to the actual \
function. Since the approximation is first order, doubling the number of grid \
points should approximately halve the error.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Norm[err16, 2]/Sqrt[16], \ Norm[err32, 2]/Sqrt[32]}\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({0.1382463633478162`, 0.06934573439134255`}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
Note that if you specify a function an option value, and you intend to use it \
for PDE or function approximation solutions, you should be sure to include a \
proper normalization in the function.\
\>", "Text"],

Cell[CellGroupData[{

Cell["ScaledVectorNorm", "Section",
  CellTags->{"s:2", "svn"}],

Cell[TextData[{
  "Methods which have error control need to determine whether a step \
satisfies local error tolerances or not.  To simplify the process of checking \
this,  a utility function ScaledVectorNorm does the scaling (",
  ButtonBox["1",
    ButtonData:>"scaling",
    ButtonStyle->"Hyperlink"],
  ") and computes the norm.  The table below includes the formulas for \
specific values of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " for reference."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox["ScaledVectorNorm",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["p",
                    "TI"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      StyleBox[\(t\_r\),
                        "TI"], 
                      StyleBox[",",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox[\(t\_a\),
                        "TI"]}], 
                    StyleBox["}",
                      "MR"]}]}], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["v",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["u",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "Compute the normalized p-norm of the vector ",
              StyleBox["v", "TI"],
              " scaling using scaling  (",
              ButtonBox["1",
                ButtonData:>"scaling",
                ButtonStyle->"Hyperlink"],
              ") with reference vector ",
              StyleBox["u", "TI"],
              " and relative and absolute tolerances ",
              Cell[BoxData[
                  \(TraditionalForm\`t\_a\ and\ t\_r\)]],
              "."
            }], "Text"]},
          {
            RowBox[{
              RowBox[{
                StyleBox["ScaledVectorNorm",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["fun",
                    "TI"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      StyleBox[\(t\_r\),
                        "TI"], 
                      StyleBox[",",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox[\(t\_a\),
                        "TI"]}], 
                    StyleBox["}",
                      "MR"]}]}], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["v",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["u",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "Compute the norm of  the vector ",
              StyleBox["v", "TI"],
              " using scaling  (",
              ButtonBox["1",
                ButtonData:>"scaling",
                ButtonStyle->"Hyperlink"],
              ") with reference vector ",
              StyleBox["u", "TI"],
              " and relative and absolute tolerances ",
              Cell[BoxData[
                  \(TraditionalForm\`t\_a\ and\ t\_r\)]],
              " and the norm function ",
              StyleBox["fun", "TI"],
              "."
            }], "Text"]},
          {
            RowBox[{
              RowBox[{
                StyleBox["ScaledVectorNorm",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["2",
                    "MR"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      StyleBox[\(t\_r\),
                        "TI"], 
                      StyleBox[",",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox[\(t\_a\),
                        "TI"]}], 
                    StyleBox["}",
                      "MR"]}]}], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["v",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["u",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "Compute ",
              Cell[BoxData[
                  \(TraditionalForm\`\@\(\(1\/n\) \(\[Sum]\+\(i = 1\)\%n v\_i\
\/\(t\_a + t\_r\ u\_i\)\)\)\)]],
              "where",
              StyleBox[" n", "TI"],
              " is the length of vectors  ",
              StyleBox["v", "TI"],
              " and",
              StyleBox[" u", "TI"],
              "."
            }], "Text"]},
          {
            RowBox[{
              RowBox[{
                StyleBox["ScaledVectorNorm",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["\[Infinity]",
                    "MR"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox[" ",
                    "MR"], 
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      StyleBox[\(t\_r\),
                        "TI"], 
                      StyleBox[",",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox[\(t\_a\),
                        "TI"]}], 
                    StyleBox["}",
                      "MR"]}]}], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["v",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox["u",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], Cell[TextData[{
              "Compute  ",
              Cell[BoxData[
                  \(TraditionalForm\`max(v\_i\/\(t\_a + t\_r\ u\_i\))\)]],
              " , 1 \[LessEqual]",
              StyleBox[" ", "TI"],
              "i \[LessEqual] ",
              StyleBox["n", "TI"],
              " where ",
              StyleBox["n", "TI"],
              " is the length of vectors  ",
              StyleBox["v", "TI"],
              " and",
              StyleBox[" u", "TI"],
              "."
            }], "Text"]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.45, 0.55}}],

Cell["ScaledVectorNorm. ", "Caption"],

Cell["\<\
This sets up a scaled vector norm object with the default machine precision \
tolerances used in NDSolve.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(svn\  = \ 
      NDSolve`ScaledVectorNorm[
        2, \ {10. \^\(-8\), \ 10. \^\(-8\)}]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm[2, {1.`*^-8, 1.`*^-8}]\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell["\<\
This applies the scaled norm object with a sample error and solution \
reference vector.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(svn[{9. \ 10. \^\(-9\), \ 10. \^\(-8\)}, \ {2. , 1. }]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \(0.412310562561766`\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell["\<\
Because of the absolute tolerance term, the value comes out reasonably even \
if some of the components of the reference solution are zero.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(svn[{9. \ 10. \^\(-9\), \ 10. \^\(-8\), \ 2\ 10\^\(-8\)}, \ {1. , 
        0. , \ 0. }]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(1.3168776202315333`\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "When setting up a method for NDSolve, you can get the appropriate ",
  StyleBox["ScaledVectorNorm", "MR"],
  " object to use using the ",
  StyleBox["\"Norm\"", "MR"],
  " ",
  ButtonBox["method function",
    ButtonData:>{"StateData.nb", "statemethods"},
    ButtonStyle->"Hyperlink"],
  " of the",
  StyleBox[" ", "MR"],
  StyleBox[ButtonBox["NDSolve`StateData",
    ButtonData:>{"StateData.nb", None},
    ButtonStyle->"Hyperlink"], "MR"],
  "  object."
}], "Text"],

Cell["Here is an NDSolve`StateData object.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(state\  = \ 
      First[NDSolve`ProcessEquations[{\(x''\)[t]\  + \ x[t]\  \[Equal] \ 0, \ 
            x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, x, 
          t]]\)], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"NDSolve`StateData", "[", 
        InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
          SequenceForm[ "<", 0.0, ">"],
          Editable->False], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell["\<\
This gets the appropriate scaled norm to use from the state data.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(svn\  = \ state@"\<Norm\>"[]\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm[\[Infinity], {1.0536712127723497`*^-8, 
        1.0536712127723497`*^-8}, NDSolve]\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["\<\
This applies it to a sample error vector using the initial condition as \
reference vector.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(svn[{10. \^\(-9\), \ 10. \^\(-8\)}, \ 
      state@"\<SolutionVector\>"["\<Forward\>"]]\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \(0.9490626562425165`\)], "Output",
  CellLabel->"Out[15]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 967}},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{650, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Norm and ScaledVectorNorm",
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "scaling"->{
    Cell[2915, 83, 125, 3, 47, "NumberedEquation",
      CellTags->"scaling"]},
  "s:2"->{
    Cell[11788, 351, 63, 1, 65, "Section",
      CellTags->{"s:2", "svn"}]},
  "svn"->{
    Cell[11788, 351, 63, 1, 65, "Section",
      CellTags->{"s:2", "svn"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"scaling", 23544, 747},
  {"s:2", 23635, 750},
  {"svn", 23723, 753}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 87, "Chapter"],
Cell[1814, 55, 654, 10, 93, "Text"],
Cell[2471, 67, 441, 14, 42, "Text"],
Cell[2915, 83, 125, 3, 47, "NumberedEquation",
  CellTags->"scaling"],
Cell[3043, 88, 491, 18, 42, "Text"],
Cell[3537, 108, 185, 6, 25, "Text"],
Cell[3725, 116, 473, 12, 86, "DefinitionBox3Col"],
Cell[4201, 130, 50, 0, 17, "Caption"],
Cell[4254, 132, 390, 7, 59, "Text"],
Cell[4647, 141, 1138, 30, 110, "Text"],
Cell[5788, 173, 175, 3, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[5988, 180, 397, 8, 69, "Input"],
Cell[6388, 190, 137, 3, 27, "Output"]
}, Open  ]],
Cell[6540, 196, 549, 14, 59, "Text"],
Cell[7092, 212, 759, 25, 64, "Text"],
Cell[7854, 239, 177, 3, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[8056, 246, 276, 6, 69, "Input"],
Cell[8335, 254, 473, 8, 65, "Output"]
}, Open  ]],
Cell[8823, 265, 177, 3, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[9025, 272, 276, 6, 69, "Input"],
Cell[9304, 280, 902, 14, 103, "Output"]
}, Open  ]],
Cell[10221, 297, 125, 3, 25, "Text"],
Cell[10349, 302, 92, 2, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[10466, 308, 91, 2, 29, "Input"],
Cell[10560, 312, 99, 2, 27, "Output"]
}, Open  ]],
Cell[10674, 317, 380, 7, 59, "Text"],
Cell[11057, 326, 233, 4, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[11315, 334, 109, 2, 29, "Input"],
Cell[11427, 338, 101, 2, 27, "Output"]
}, Open  ]],
Cell[11543, 343, 220, 4, 42, "Text"],

Cell[CellGroupData[{
Cell[11788, 351, 63, 1, 65, "Section",
  CellTags->{"s:2", "svn"}],
Cell[11854, 354, 480, 12, 59, "Text"],
Cell[12337, 368, 7292, 230, 252, "DefinitionBox"],
Cell[19632, 600, 37, 0, 17, "Caption"],
Cell[19672, 602, 136, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[19833, 609, 145, 4, 30, "Input"],
Cell[19981, 615, 106, 2, 27, "Output"]
}, Open  ]],
Cell[20102, 620, 119, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[20246, 627, 112, 2, 30, "Input"],
Cell[20361, 631, 77, 2, 27, "Output"]
}, Open  ]],
Cell[20453, 636, 170, 3, 58, "MathCaption"],

Cell[CellGroupData[{
Cell[20648, 643, 145, 3, 30, "Input"],
Cell[20796, 648, 78, 2, 27, "Output"]
}, Open  ]],
Cell[20889, 653, 487, 15, 42, "Text"],
Cell[21379, 670, 59, 0, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[21463, 674, 229, 5, 49, "Input"],
Cell[21695, 681, 289, 8, 27, "Output"]
}, Open  ]],
Cell[21999, 692, 96, 2, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[22120, 698, 86, 2, 29, "Input"],
Cell[22209, 702, 166, 3, 27, "Output"]
}, Open  ]],
Cell[22390, 708, 122, 3, 41, "MathCaption"],

Cell[CellGroupData[{
Cell[22537, 715, 145, 3, 30, "Input"],
Cell[22685, 720, 78, 2, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

