(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   5854680,     219736]*)
(*NotebookOutlinePosition[   5861154,     219929]*)
(*  CellTagsIndexPosition[   5859962,     219890]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["DiscreteMath`GraphPlot", "Chapter"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"introduction", "i:2"}],

Cell[TextData[{
  StyleBox["DiscreteMath`GraphPlot",
    FontFamily->"Courier"],
  " provides functions for aesthetic straight-edge drawing of graphs. \
Algorithms implemented include the spring model (also known as spring \
embedding), the spring-electrical model, high-dimensional embedding, radial \
drawing, and layered drawing methods. The package also contains a number of \
functions useful for graph theory applications."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  StyleBox["GraphPlot",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  StyleBox["MaximalBipartiteMatching",
                    "MR"], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["GraphPlot3D",
                    "MR"], TraditionalForm]]], 
            StyleBox["MaximalIndependentVertexSet",
              "MR"]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["GraphCoordinates",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  StyleBox["MaximalIndependentEdgeSet",
                    "MR"], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["GraphCoordinates3D",
                    "MR"], TraditionalForm]]], 
            StyleBox["MinCut",
              "MR"]},
          {
            StyleBox["TreePlot",
              "MR"], 
            StyleBox["StrongComponents",
              "MR"]},
          {
            StyleBox["GraphDistance",
              "MR"], 
            StyleBox["VertexList",
              "MR"]},
          {
            StyleBox["PseudoDiameter",
              "MR"], " "}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False}],

Cell[TextData[{
  StyleBox["Functions in the ", "SR"],
  StyleBox["GraphPlot", "MR"],
  StyleBox[" package.", "SR"]
}], "Caption",
  CellTags->"S5.18.1"],

Cell[TextData[{
  "The package is designed to work efficiently for very large graphs. In this \
package, a graph is represented by its adjacency matrix. Graphs from the ",
  StyleBox["Combinatorica",
    FontSlant->"Italic"],
  " package are also supported, as are graphs specified by a rule list."
}], "Text"],

Cell["This loads the package.", "Text"],

Cell[BoxData[
    \(\(<< DiscreteMath`GraphPlot`;\)\)], "Input",
  CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell["Graph Theory Notations", "Subsection",
  CellTags->"i:1"],

Cell[TextData[{
  "A graph ",
  Cell[BoxData[
      \(TraditionalForm\`G\  = \ {V, \ E}\)]],
  " consists of a set of vertices (also called nodes) ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " and a set of edges ",
  Cell[BoxData[
      \(TraditionalForm\`E\)]],
  ". Two vertices ",
  Cell[BoxData[
      \(TraditionalForm\`u\ and\ v\)]],
  " form an edge of the graph if ",
  Cell[BoxData[
      \(TraditionalForm\`{u, \ v}\  \[Element] \ \(\(E\)\(.\)\)\)]]
}], "Text"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`{u, \ v} \[Element] \ E\)]],
  " implies that ",
  Cell[BoxData[
      \(TraditionalForm\`{v, \ u}\  \[Element] \ E\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is an undirected graph. Otherwise it is a directed graph. The former can \
be drawn using line segments, while the latter can be drawn with arrows. In \
an undirected graph, it is often convenient to denote that an edge exists \
between ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  " with the notation ",
  Cell[BoxData[
      \(TraditionalForm\`u\  \[LeftRightArrow] v\)]],
  "."
}], "Text"],

Cell["For example, this is a directed graph.", "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00007 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500251 0.4671 0.500017 0.4671 [
[ 0 0 0 0 ]
[ 1 1.00007 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.96685 .30265 m
.70439 .03623 L
s
% Start of user PostScript
0.99892458 -0.42253673 0.43703331 -0.99291403 MAarrowhead1
% End of user PostScript
.96685 .30265 m
.66895 .33341 L
s
% Start of user PostScript
0.99892458 -0.42253673 0.36116622 -0.35668338 MAarrowhead1
% End of user PostScript
.70439 .03623 m
.30317 .03315 L
s
% Start of user PostScript
0.43703331 -0.99291403 -0.4219323 -0.9994947 MAarrowhead1
% End of user PostScript
.70439 .03623 m
.66895 .33341 L
s
% Start of user PostScript
0.43703331 -0.99291403 0.36116622 -0.35668338 MAarrowhead1
% End of user PostScript
.30317 .03315 m
.03647 .29548 L
s
% Start of user PostScript
-0.4219323 -0.9994947 -0.99289728 -0.43789529 MAarrowhead1
% End of user PostScript
.30317 .03315 m
.3337 .33072 L
s
% Start of user PostScript
-0.4219323 -0.9994947 -0.35657271 -0.36244618 MAarrowhead1
% End of user PostScript
.03647 .29548 m
.03315 .69679 L
s
% Start of user PostScript
-0.99289728 -0.43789529 -1. 0.4212729 MAarrowhead1
% End of user PostScript
.03647 .29548 m
.3337 .33072 L
s
% Start of user PostScript
-0.99289728 -0.43789529 -0.35657271 -0.36244618 MAarrowhead1
% End of user PostScript
.03315 .69679 m
.2956 .96349 L
s
% Start of user PostScript
-1. 0.4212729 -0.43812247 0.99223335 MAarrowhead1
% End of user PostScript
.03315 .69679 m
.33057 .66656 L
s
% Start of user PostScript
-1. 0.4212729 -0.36326308 0.3565577 MAarrowhead1
% End of user PostScript
.2956 .96349 m
.69745 .96692 L
s
% Start of user PostScript
-0.43812247 0.99223335 0.42217002 0.99957039 MAarrowhead1
% End of user PostScript
.2956 .96349 m
.33057 .66656 L
s
% Start of user PostScript
-0.43812247 0.99223335 -0.36326308 0.3565577 MAarrowhead1
% End of user PostScript
.69745 .96692 m
.96395 .70429 L
s
% Start of user PostScript
0.42217002 0.99957039 0.99271022 0.43731993 MAarrowhead1
% End of user PostScript
.69745 .96692 m
.66682 .66911 L
s
% Start of user PostScript
0.42217002 0.99957039 0.35659681 0.36201169 MAarrowhead1
% End of user PostScript
.96395 .70429 m
.96685 .30265 L
s
% Start of user PostScript
0.99271022 0.43731993 0.99892458 -0.42253673 MAarrowhead1
% End of user PostScript
.96395 .70429 m
.66682 .66911 L
s
% Start of user PostScript
0.99271022 0.43731993 0.35659681 0.36201169 MAarrowhead1
% End of user PostScript
.66895 .33341 m
.33057 .66656 L
s
% Start of user PostScript
0.36116622 -0.35668338 -0.36326308 0.3565577 MAarrowhead1
% End of user PostScript
.66682 .66911 m
.3337 .33072 L
s
% Start of user PostScript
0.35659681 0.36201169 -0.35657271 -0.36244618 MAarrowhead1
% End of user PostScript
.96685 .30265 m
.96685 .30265 .00934 0 365.73 arc
F
.70439 .03623 m
.70439 .03623 .00934 0 365.73 arc
F
.30317 .03315 m
.30317 .03315 .00934 0 365.73 arc
F
.03647 .29548 m
.03647 .29548 .00934 0 365.73 arc
F
.03315 .69679 m
.03315 .69679 .00934 0 365.73 arc
F
.2956 .96349 m
.2956 .96349 .00934 0 365.73 arc
F
.69745 .96692 m
.69745 .96692 .00934 0 365.73 arc
F
.96395 .70429 m
.96395 .70429 .00934 0 365.73 arc
F
.66895 .33341 m
.66895 .33341 .00934 0 365.73 arc
F
.3337 .33072 m
.3337 .33072 .00934 0 365.73 arc
F
.33057 .66656 m
.33057 .66656 .00934 0 365.73 arc
F
.66682 .66911 m
.66682 .66911 .00934 0 365.73 arc
F
0 0 m
1 0 L
1 1.00007 L
0 1.00007 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[200]:=",
  ImageSize->{287.938, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O00017b000`400?l00000o`00003oo`3ooolP
0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP
0?ooo`00H`3oool300000;T0oooo001E0?ooo`@000001@3oool800000;T0oooo001E0?oooa400000
HP3oool4000005<0oooo001D0?oooc`00000>03oool4000005<0oooo001E0?oooa400000:P3oooll
000005<0oooo001D0?ooo`@00000103oool:00000680oooo1@00001B0?ooo`00D`3oool010000000
oooo0?ooo`0000090?ooo`H00000HP3oool600000540oooo001B0?ooo`050000003oool0oooo0?oo
o`0000003@3oool2000006@0oooo00<000000?ooo`0000000`00001?0?ooo`00D@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool01@00001>0?ooo`00
D03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo06l0oooo00@000000?ooo`3oool0
oooo1P00001<0?ooo`00C`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo
00@000000?ooo`3oool0oooo1`00001;0?ooo`00CP3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo06l0oooo00<000000?ooo`3oool00P3oool8000004T0oooo001=0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`020?ooo`T00000B03o
ool004`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1_0?ooo`030000003oool0
oooo00<0oooo1`0000190?ooo`00B`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
06l0oooo00<000000?ooo`3oool00`3oool6000004X0oooo001:0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`040?ooo`@0000000<0oooo0000003o
ool0B03oool004T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`1^0?ooo`030000
003oool0oooo00D0oooo0`0000030?ooo`030000003oool0oooo04H0oooo00180?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0A@3oool004L0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`1]0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0A03oool0
04H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool0@`3oool004D0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`1]0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0@P3oool004@0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0@@3oool004<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`1]0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0@03oool00480oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0?`3oool00440oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`1/0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool0?P3oool00400oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0?@3oool003l0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1/0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0?03oool003h0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0>`3o
ool003d0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0>P3oool003`0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`1[0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0>@3oool003/0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0>03oool003X0oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`1[0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=`3oool003T0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool0=P3oool003P0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`1Z
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0=@3oool003L0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool0=03oool003H0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`1Z0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0<`3oool003D0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
<P3oool003@0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1Y0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool0<@3oool003<0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0<03oool0
0380oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool0;`3oool00300oooo0P00000X0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0^0?ooo`00;`3oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool09`3oool00`000000oooo
0?ooo`0]0?ooo`00;P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo06P0oooo00<0
00000?ooo`3oool09`3oool00`000000oooo0?ooo`0]0?ooo`00;@3oool00`000000oooo0?ooo`0Z
0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0/
0?ooo`00;03oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo06P0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`0[0?ooo`00:`3oool00`000000oooo0?ooo`0/0?ooo`03
0000003oool0oooo06P0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0Z0?ooo`00
:P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0
:`3oool00`000000oooo0?ooo`0Y0?ooo`00:@3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo06H0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0X0?ooo`00:03oool0
0`000000oooo0?ooo`0`0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`0W0?ooo`009`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
06H0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0V0?ooo`009P3oool00`000000
oooo0?ooo`0b0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0<03oool00`000000
oooo0?ooo`0U0?ooo`009@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo06H0oooo
00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0T0?ooo`00903oool00`000000oooo0?oo
o`0d0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?oo
o`0S0?ooo`008`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo06H0oooo00<00000
0?ooo`3oool0<`3oool00`000000oooo0?ooo`0R0?ooo`008P3oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo06H0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0Q0?oo
o`008@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3o
ool0=P3oool00`000000oooo0?ooo`0P0?ooo`00803oool00`000000oooo0?ooo`0i0?ooo`030000
003oool0oooo06@0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0O0?ooo`007`3o
ool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`0N0?ooo`007P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0
oooo06@0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0M0?ooo`007@3oool00`00
0000oooo0?ooo`0l0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0>P3oool00`00
0000oooo0?ooo`0L0?ooo`00703oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo06@0
oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0K0?ooo`006`3oool00`000000oooo
0?ooo`0n0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0?03oool00`000000oooo
0?ooo`0J0?ooo`006P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo06<0oooo00<0
00000?ooo`3oool0?P3oool00`000000oooo0?ooo`0I0?ooo`006@3oool00`000000oooo0?ooo`10
0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0H
0?ooo`00603oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo06<0oooo00<000000?oo
o`3oool0@03oool00`000000oooo0?ooo`0G0?ooo`005`3oool00`000000oooo0?ooo`130?ooo`03
0000003oool0oooo0680oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0F0?ooo`00
4P3oool01@000000oooo0?ooo`3oool0000004H0oooo00<000000?ooo`3oool0HP3oool00`000000
oooo0?ooo`120?ooo`030000003oool0oooo01D0oooo000A0?ooo`<0000000<0oooo0000003oool0
AP3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
503oool00140oooo100000180?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0A03o
ool00`000000oooo0?ooo`0C0?ooo`00403oool6000004L0oooo00<000000?ooo`3oool0HP3oool0
0`000000oooo0?ooo`150?ooo`030000003oool0oooo0180oooo000?0?ooo`P00000AP3oool00`00
0000oooo0?ooo`1Q0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool04@3oool000l0
oooo2@0000150?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`0@0?ooo`003P3oool9000004H0oooo00<000000?ooo`3oool0H@3oool00`000000oooo
0?ooo`190?ooo`030000003oool0oooo00l0oooo000=0?ooo`P00000B03oool00`000000oooo0?oo
o`1Q0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool03P3oool000d0oooo1P00001;
0?ooo`@00000G`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00d0oooo000<0?oo
o`D00000B@3oool8000005`0oooo2000001:0?ooo`030000003oool0oooo00`0oooo000;0?ooo`@0
0000B`3oool8000005`0oooo2000001;0?ooo`030000003oool0oooo00/0oooo00080?ooo`D00000
CP3oool7000005`0oooo1`00001=0?ooo`030000003oool0oooo00X0oooo00070?ooo`P00000C03o
ool6000005d0oooo1`00001>0?ooo`030000003oool0oooo00T0oooo00080?ooo`D000000P3oool8
000004D0oooo1@00001M0?ooo`H00000C`3oool4000000P0oooo00080?ooo`@000002`3oool90000
03`0oooo1@00001M0?ooo`H00000C@3oool7000000L0oooo000:0?ooo`030000003oool0oooo01<0
oooo2000000d0?ooo`D00000G@3oool5000004@0oooo2P0000020?ooo`D000001`3oool000X0oooo
00<000000?ooo`3oool06`3oool9000002`0oooo1000001M0?ooo`D00000>`3oool9000000`0oooo
100000080?ooo`002P3oool00`000000oooo0?ooo`0T0?ooo`P00000603oool2000000X0oooo1000
001N0?ooo`@00000<@3oool:000001H0oooo0`0000080?ooo`002P3oool00`000000oooo0?ooo`0/
0?ooo`T000003`3oool5000000L0oooo1000001N0?ooo`<000002P3oool2000001`0oooo2P00000P
0?ooo`<00000203oool000X0oooo00<000000?ooo`3oool0=@3oool8000000L0oooo1`0000060?oo
o`800000G`3oool3000000L0oooo1@00000C0?ooo`T00000:P3oool3000000P0oooo000:0?ooo`03
0000003oool0oooo03d0oooo4@0000030?ooo`800000G`3oool2000000D0oooo200000090?ooo`X0
0000<P3oool4000000P0oooo000:0?ooo`030000003oool0oooo04@0oooo4000001N0?ooo`800000
0`3ooolC000003`0oooo100000080?ooo`002P3oool00`000000oooo0?ooo`140?oooa400000G03o
oolA000004@0oooo1@0000070?ooo`002P3oool00`000000oooo0?ooo`140?ooo`/0000000<0oooo
0000000000000`00001K0?oooa800000A03oool5000000L0oooo000:0?ooo`030000003oool0oooo
04@0oooo100000080?ooo`L00000F@3oool5000000030?ooo`000000000000X00000@`3oool60000
00L0oooo000:0?ooo`030000003oool0oooo05@0oooo1000001H0?ooo`@000002P3oool4000004<0
oooo1P0000070?ooo`002P3oool00`000000oooo0?ooo`1D0?ooo`H00000E@3oool00`000000oooo
0?ooo`1C0?ooo`H000001`3oool000X0oooo00<000000?ooo`3oool0E@3oool6000005<0oooo00<0
00000?ooo`3oool0E03oool7000000H0oooo000:0?ooo`030000003oool0oooo05H0oooo1`00001@
0?ooo`030000003oool0oooo05@0oooo200000060?ooo`002P3oool00`000000oooo0?ooo`1F0?oo
o`T00000C@3oool00`000000oooo0?ooo`1E0?ooo`P000001P3oool000X0oooo00<000000?ooo`3o
ool0E`3oool9000004/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`070?ooo`00
2P3oool00`000000oooo0?ooo`1H0?ooo`L00000B`3oool00`000000oooo0?ooo`1K0?ooo`030000
003oool0oooo00L0oooo000:0?ooo`030000003oool0oooo05P0oooo1P00001;0?ooo`030000003o
ool0oooo05`0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0F@3oool5
000004X0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`070?ooo`002P3oool00`00
0000oooo0?ooo`1I0?ooo`<000000P3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo
05h0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0FP3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0G`3oool00`000000
oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo0480oooo
00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?oo
o`1Q0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?oo
o`070?ooo`002P3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo03h0oooo00<00000
0?ooo`3oool0HP3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1S0?oo
o`030000003oool0oooo03`0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`070?oo
o`002P3oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0I03oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1U0?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`070?ooo`002P3o
ool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0IP3o
ool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0
oooo03@0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`070?ooo`002P3oool00`00
0000oooo0?ooo`1X0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0J03oool00`00
0000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo
0?ooo`1Z0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0JP3oool00`000000oooo
0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo02d0oooo00<0
00000?ooo`3oool0J`3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1[
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`07
0?ooo`002P3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo02T0oooo00<000000?oo
o`3oool0K@3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1]0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`070?ooo`00
2P3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
K`3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1_0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`070?ooo`002P3oool0
0`000000oooo0?ooo`1`0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0L@3oool0
0`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000
oooo0?ooo`1b0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0L`3oool00`000000
oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?oo
o`1d0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?oo
o`070?ooo`002P3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0MP3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1f0?oo
o`030000003oool0oooo01D0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`070?oo
o`002P3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0N03oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1h0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`070?ooo`002P3o
ool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0NP3o
ool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`070?ooo`002P3oool00`00
0000oooo0?ooo`1k0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0O03oool00`00
0000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo
0?ooo`1m0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0OP3oool00`000000oooo
0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0O`3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1o
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`07
0?ooo`002P3oool00`000000oooo0?ooo`200?ooo`050000003oool0oooo0?ooo`000000P`3oool0
0`000000oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`220?ooo`030000003oool00000
08@0oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool0PP3oool2000008D0
oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool0P@3oool010000000oooo
0?ooo`0000240?ooo`030000003oool0oooo00L0oooo00090?ooo`030000003oool0oooo0800oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`200?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`1o0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo07h0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo07d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1m0?oo
o`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000
003oool0oooo07/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1k0?ooo`030000
003oool0oooo00P0oooo00090?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0
oooo07T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1i0?ooo`030000003oool0
oooo00P0oooo00090?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`1h0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo07L0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo00P0
oooo00090?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`1f0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo07D0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo00P0oooo0009
0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1d
0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo07<0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo00P0oooo00090?ooo`03
0000003oool0oooo0780oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`1b0?ooo`03
0000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo0740oooo00<000000?ooo`3oool0
803oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003o
ool0oooo0700oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`1`0?ooo`030000003o
ool0oooo00P0oooo00090?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`1_0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
06h0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo
00P0oooo00090?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0:03oool00`000000
oooo0?ooo`1]0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo06`0oooo
00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo00P0oooo
00090?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`1[0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo06X0oooo00<00000
0?ooo`3oool0;P3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00P0oooo00090?oo
o`030000003oool0oooo06T0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`1Z0?oo
o`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3o
ool0<@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000
003oool0oooo06L0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`1X0?ooo`030000
003oool0oooo00P0oooo00090?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0=@3o
ool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0
oooo06D0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0
oooo00P0oooo00090?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0>@3oool00`00
0000oooo0?ooo`1U0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo00P0
oooo00090?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0?@3oool00`000000oooo
0?ooo`1S0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo0640oooo00<0
00000?ooo`3oool0?`3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00P0oooo0009
0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`1Q
0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo05X0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo0600oooo00<000000?oo
o`3oool0203oool000T0oooo00<000000?ooo`3oool0F@3oool300000080oooo00<000000?ooo`3o
ool0A@3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000
003oool0oooo05T0oooo1@0000190?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0
203oool000T0oooo00<000000?ooo`3oool0F03oool6000004X0oooo00<000000?ooo`3oool0G@3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1H0?ooo`L00000BP3oool0
0`000000oooo0?ooo`1L0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0oooo
05L0oooo2@00001:0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0203oool000T0
oooo00<000000?ooo`3oool0EP3oool9000004`0oooo00<000000?ooo`3oool0FP3oool00`000000
oooo0?ooo`080?ooo`001P3oool8000005@0oooo1`00001?0?ooo`030000003oool0oooo05T0oooo
00<000000?ooo`3oool0203oool000H0oooo2000001C0?ooo`H00000DP3oool00`000000oooo0?oo
o`1H0?ooo`030000003oool0oooo00P0oooo00060?ooo`L00000D`3oool6000005@0oooo00<00000
0?ooo`3oool0E`3oool00`000000oooo0?ooo`080?ooo`001`3oool6000005<0oooo1000001G0?oo
o`030000003oool0oooo05H0oooo00<000000?ooo`3oool0203oool000L0oooo1P0000130?ooo`@0
00002@3oool6000005T0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`080?ooo`00
1`3oool6000004<0oooo2`0000020?ooo`@00000G03oool4000000T0oooo100000160?ooo`030000
003oool0oooo00P0oooo00070?ooo`D00000A03ooolA000005/0oooo1P0000000`3oool000000000
0009000004H0oooo00<000000?ooo`3oool0203oool000L0oooo1@0000130?oooa800000G03ooolA
000004H0oooo00<000000?ooo`3oool0203oool000P0oooo1000000h0?ooo`/0000000<0oooo0000
00000000200000020?ooo`@00000G@3ooolA000004H0oooo00<000000?ooo`3oool0203oool000P0
oooo0`00000^0?ooo`/00000303oool7000000H0oooo0P00001P0?ooo`8000000`3ooolA000003l0
oooo00<000000?ooo`3oool0203oool000P0oooo0`00000T0?ooo`X000005`3oool5000000P0oooo
0`00001O0?ooo`8000001@3oool8000000L0oooo2000000g0?ooo`030000003oool0oooo00P0oooo
00080?ooo`<000006@3oool;00000240oooo0P00000:0?ooo`@00000GP3oool4000000L0oooo1@00
000?0?ooo`T00000;P3oool00`000000oooo0?ooo`080?ooo`002@3oool2000000h0oooo2`00000h
0?ooo`@00000GP3oool4000000X0oooo0P00000H0?ooo`P000009P3oool00`000000oooo0?ooo`08
0?ooo`001`3oool4000000@0oooo2P0000130?ooo`@00000GP3oool4000002`0oooo2@00000M0?oo
o`030000003oool0oooo00P0oooo00060?ooo`T00000C03oool5000005h0oooo1@00000d0?ooo`P0
00005@3oool00`000000oooo0?ooo`080?ooo`001`3oool5000004l0oooo1@00001N0?ooo`D00000
?03oool9000000X0oooo100000090?ooo`001`3oool5000004h0oooo1P00001N0?ooo`D00000A@3o
ool8000000030?ooo`000000000000@00000203oool000`0oooo00<000000?ooo`3oool0B`3oool7
000005d0oooo1P00001<0?ooo`L00000203oool000d0oooo00<000000?ooo`3oool0BP3oool70000
05`0oooo1`00001>0?ooo`D00000203oool000h0oooo00<000000?ooo`3oool0B03oool8000005`0
oooo2000001;0?ooo`H000002@3oool000l0oooo00<000000?ooo`3oool0A`3oool8000005`0oooo
200000190?ooo`D00000303oool00100oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?oo
o`1N0?ooo`@00000B`3oool6000000d0oooo000A0?ooo`030000003oool0oooo04P0oooo00<00000
0?ooo`3oool0HP3oool00`000000oooo0?ooo`160?ooo`P000003@3oool00180oooo00<000000?oo
o`3oool0A`3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo04@0oooo2@00000>0?oo
o`004`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo0680oooo00<000000?ooo`3o
ool0@`3oool9000000l0oooo000D0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0
HP3oool00`000000oooo0?ooo`140?ooo`P000003`3oool001D0oooo00<000000?ooo`3oool0A03o
ool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo04D0oooo1P00000@0?ooo`005P3oool0
0`000000oooo0?ooo`130?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0AP3oool4
00000140oooo000G0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0H`3oool00`00
0000oooo0?ooo`150?ooo`030000003oool00000008000004@3oool001P0oooo00<000000?ooo`3o
ool0@03oool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo04@0oooo00D000000?ooo`3o
ool0oooo0000000B0?ooo`006@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0E0?ooo`006P3oool00`000000oooo
0?ooo`0n0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0@@3oool00`000000oooo
0?ooo`0F0?ooo`006`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo06@0oooo00<0
00000?ooo`3oool0@03oool00`000000oooo0?ooo`0G0?ooo`00703oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0H
0?ooo`00703oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo06@0oooo00<000000?oo
o`3oool0?P3oool00`000000oooo0?ooo`0I0?ooo`007@3oool00`000000oooo0?ooo`0k0?ooo`03
0000003oool0oooo06@0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0J0?ooo`00
7P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0
?03oool00`000000oooo0?ooo`0K0?ooo`007`3oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo06D0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0L0?ooo`00803oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0>P3oool0
0`000000oooo0?ooo`0M0?ooo`008@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
06D0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0N0?ooo`008P3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0O0?ooo`008`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo06H0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0P0?ooo`00903oool00`000000oooo0?oo
o`0c0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`0Q0?ooo`009@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo06H0oooo00<00000
0?ooo`3oool0=03oool00`000000oooo0?ooo`0R0?ooo`009P3oool00`000000oooo0?ooo`0a0?oo
o`030000003oool0oooo06H0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0S0?oo
o`009`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`0T0?ooo`00:03oool00`000000oooo0?ooo`0^0?ooo`030000
003oool0oooo06L0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0U0?ooo`00:@3o
ool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0<03o
ool00`000000oooo0?ooo`0V0?ooo`00:P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0
oooo06L0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0W0?ooo`00:`3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0;P3oool00`00
0000oooo0?ooo`0X0?ooo`00;03oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0Y0?ooo`00;@3oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`0Z0?ooo`00;P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo06P0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0[0?ooo`00;`3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0/
0?ooo`00<03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo06T0oooo00<000000?oo
o`3oool09`3oool2000002l0oooo000a0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool0J@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02l0oooo000b0?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo0300oooo000c0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0J@3o
ool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0340oooo000d0?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo0380oooo000e0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0JP3oool00`00
0000oooo0?ooo`0Q0?ooo`030000003oool0oooo03<0oooo000f0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo03@0
oooo000g0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0JP3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo03D0oooo000h0?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool0J`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo03H0oooo000i
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo03L0oooo000j0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool0J`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo03P0oooo000k0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo03T0oooo000l0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
J`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo000m0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo03/0oooo000n0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0J`3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03`0oooo000o0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
03d0oooo00100?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0K@3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo03h0oooo00110?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03l0oooo
00110?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo0400oooo00120?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0K@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0440oooo00130?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0480oooo00140?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0K@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04<0oooo00150?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo04@0oooo00160?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0K@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo04D0oooo00170?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0AP3oool004P0oooo00@000000?ooo`3oool0oooo0`000006
0?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`17
0?ooo`00B@3oool00`000000oooo00000003000000H0oooo00<000000?ooo`3oool0K`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo04P0oooo001:0?ooo`H000001@3oool00`000000
oooo0?ooo`1_0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0B@3oool004T0oooo
1`0000050?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`1:0?ooo`00B03oool9000000@0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo04/0oooo00190?ooo`P00000103oool00`000000oooo0?ooo`1_
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0C03oool004/0oooo1`0000030?oo
o`030000003oool0oooo06l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1=0?oo
o`00C03oool6000000<0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo04h0oooo001>0?ooo`D0000000<0oooo0000003oool0L@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo04l0oooo001?0?ooo`@0000000<0oooo0000003oool0H`3o
ool2000000d0oooo00D000000?ooo`3oool0oooo0000001B0?ooo`00D@3oool5000006<0oooo1P00
00090?ooo`040000003oool0oooo000005<0oooo001B0?ooo`D00000HP3oool:000000<0oooo1@00
001D0?ooo`00DP3oooll000002/0oooo4@00001E0?ooo`00DP3oool5000003L0oooo?000001E0?oo
o`00DP3oool4000006<0oooo4@00001E0?ooo`00^@3oool8000000D0oooo0`00001F0?ooo`00^@3o
ool3000006<0oooo003o0?ooob00oooo003o0?ooob00oooo003o0?ooob00oooo003o0?ooob00oooo
003o0?ooob00oooo003o0?ooob00oooo0000\
\>"],
  ImageRangeCache->{{{124, 410.938}, {348, 61.0625}} -> {-1.99631, -0.614852, \
0.0074617, 0.0074617}}],

Cell["Here is a undirected graph.", "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00007 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500251 0.4671 0.500017 0.4671 [
[ 0 0 0 0 ]
[ 1 1.00007 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.96685 .30265 m
.70439 .03623 L
s
.96685 .30265 m
.66895 .33341 L
s
.70439 .03623 m
.30317 .03315 L
s
.70439 .03623 m
.66895 .33341 L
s
.30317 .03315 m
.03647 .29548 L
s
.30317 .03315 m
.3337 .33072 L
s
.03647 .29548 m
.03315 .69679 L
s
.03647 .29548 m
.3337 .33072 L
s
.03315 .69679 m
.2956 .96349 L
s
.03315 .69679 m
.33057 .66656 L
s
.2956 .96349 m
.69745 .96692 L
s
.2956 .96349 m
.33057 .66656 L
s
.69745 .96692 m
.96395 .70429 L
s
.69745 .96692 m
.66682 .66911 L
s
.96395 .70429 m
.96685 .30265 L
s
.96395 .70429 m
.66682 .66911 L
s
.66895 .33341 m
.33057 .66656 L
s
.66682 .66911 m
.3337 .33072 L
s
.96685 .30265 m
.96685 .30265 .00934 0 365.73 arc
F
.70439 .03623 m
.70439 .03623 .00934 0 365.73 arc
F
.30317 .03315 m
.30317 .03315 .00934 0 365.73 arc
F
.03647 .29548 m
.03647 .29548 .00934 0 365.73 arc
F
.03315 .69679 m
.03315 .69679 .00934 0 365.73 arc
F
.2956 .96349 m
.2956 .96349 .00934 0 365.73 arc
F
.69745 .96692 m
.69745 .96692 .00934 0 365.73 arc
F
.96395 .70429 m
.96395 .70429 .00934 0 365.73 arc
F
.66895 .33341 m
.66895 .33341 .00934 0 365.73 arc
F
.3337 .33072 m
.3337 .33072 .00934 0 365.73 arc
F
.33057 .66656 m
.33057 .66656 .00934 0 365.73 arc
F
.66682 .66911 m
.66682 .66911 .00934 0 365.73 arc
F
0 0 m
1 0 L
1 1.00007 L
0 1.00007 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[199]:=",
  ImageSize->{287.938, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O00017b000`400?l00000o`00003oo`3ooolP
0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP
0?ooo`00o`3ooolP0?ooo`00E@3oool400000<H0oooo001E0?ooo`@00000K`3oool4000005<0oooo
001D0?oooc`00000>03oool4000005<0oooo001E0?ooo`@00000=`3oooll000005<0oooo001D0?oo
o`@00000L03oool4000005<0oooo001C0?ooo`040000003oool0oooo00000740oooo0`0000000`3o
ool000000?ooo`1A0?ooo`00DP3oool01@000000oooo0?ooo`3oool0000007<0oooo00@000000?oo
o`3oool00000D@3oool00540oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1_0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0CP3oool00500oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0C@3oool004l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1_0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0C03oool004h0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0B`3o
ool004d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0BP3oool004`0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`1_0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0B@3oool004/0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0B03oool004X0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`1_0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0A`3oool004T0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0AP3oool004P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1^
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0A@3oool004L0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0A03oool004H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1]0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0@`3oool004D0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
@P3oool004@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1]0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0@@3oool004<0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`1]0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0@03oool0
0480oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0?`3oool00440oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`1/0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0?P3oool00400oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0?@3oool003l0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`1/0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0?03oool003h0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0>`3oool003d0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1[0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0>P3oool003`0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool0>@3oool003/0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1[0?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0>03oool003X0oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=`3o
ool003T0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool0=P3oool003P0oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`1Z0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0=@3oool003L0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool0=03oool003H0oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`1Z0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0<`3oool003D0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo0240oooo00<0
00000?ooo`3oool0<P3oool003@0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1Y
0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0<@3oool003<0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0<03oool00380oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1X0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0;`3oool00300oooo0P00000X0?ooo`030000
003oool0oooo06P0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0^0?ooo`00;`3o
ool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0]0?ooo`00;P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0
oooo06P0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0]0?ooo`00;@3oool00`00
0000oooo0?ooo`0Z0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0:03oool00`00
0000oooo0?ooo`0/0?ooo`00;03oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0[0?ooo`00:`3oool00`000000oooo
0?ooo`0/0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`0Z0?ooo`00:P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo06L0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`0Y0?ooo`00:@3oool00`000000oooo0?ooo`0_
0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0X
0?ooo`00:03oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo06H0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`0W0?ooo`009`3oool00`000000oooo0?ooo`0a0?ooo`03
0000003oool0oooo06H0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0V0?ooo`00
9P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0
<03oool00`000000oooo0?ooo`0U0?ooo`009@3oool00`000000oooo0?ooo`0c0?ooo`030000003o
ool0oooo06H0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0T0?ooo`00903oool0
0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0<P3oool0
0`000000oooo0?ooo`0S0?ooo`008`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
06H0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0R0?ooo`008P3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0Q0?ooo`008@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo06@0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0P0?ooo`00803oool00`000000oooo0?oo
o`0i0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?oo
o`0O0?ooo`007`3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo06@0oooo00<00000
0?ooo`3oool0>03oool00`000000oooo0?ooo`0N0?ooo`007P3oool00`000000oooo0?ooo`0k0?oo
o`030000003oool0oooo06@0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0M0?oo
o`007@3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0L0?ooo`00703oool00`000000oooo0?ooo`0m0?ooo`030000
003oool0oooo06@0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0K0?ooo`006`3o
ool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0?03o
ool00`000000oooo0?ooo`0J0?ooo`006P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0
oooo06<0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0I0?ooo`006@3oool00`00
0000oooo0?ooo`100?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0?`3oool00`00
0000oooo0?ooo`0H0?ooo`00603oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0G0?ooo`005`3oool00`000000oooo
0?ooo`130?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0@@3oool00`000000oooo
0?ooo`0F0?ooo`005P3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0680oooo00<0
00000?ooo`3oool0@P3oool00`000000oooo0?ooo`0E0?ooo`005@3oool00`000000oooo0?ooo`15
0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0D
0?ooo`00503oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo0680oooo00<000000?oo
o`3oool0A03oool00`000000oooo0?ooo`0C0?ooo`004`3oool00`000000oooo0?ooo`170?ooo`03
0000003oool0oooo0680oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0B0?ooo`00
4P3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0
A`3oool00`000000oooo0?ooo`0A0?ooo`004@3oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo0640oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`00403oool0
0`000000oooo0?ooo`1:0?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0B@3oool0
0`000000oooo0?ooo`0?0?ooo`003`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo
0640oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`0>0?ooo`003P3oool00`000000
oooo0?ooo`1=0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0B`3oool00`000000
oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0600oooo
00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0<0?ooo`00303oool00`000000oooo0?oo
o`1?0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?oo
o`0;0?ooo`00203oool400000580oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`1>
0?ooo`030000003oool0oooo00X0oooo00070?ooo`P00000C`3oool00`000000oooo0?ooo`1O0?oo
o`030000003oool0oooo0500oooo00<000000?ooo`3oool02@3oool000P0oooo1@0000020?ooo`P0
0000A`3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo0500oooo100000080?ooo`00
203oool4000000/0oooo2@00000n0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool0
CP3oool7000000L0oooo000:0?ooo`030000003oool0oooo01<0oooo2000000f0?ooo`030000003o
ool0oooo05l0oooo00<000000?ooo`3oool0A03oool:00000080oooo1@0000070?ooo`002P3oool0
0`000000oooo0?ooo`0K0?ooo`T00000;@3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0
oooo03/0oooo2@00000<0?ooo`@00000203oool000X0oooo00<000000?ooo`3oool0903oool80000
02D0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`0a0?ooo`X000005`3oool00`00
0000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`0/0?ooo`T000007@3oool00`000000
oooo0?ooo`1N0?ooo`030000003oool0oooo02L0oooo2P00000Q0?ooo`030000003oool0oooo00L0
oooo000:0?ooo`030000003oool0oooo03D0oooo2000000E0?ooo`030000003oool0oooo05h0oooo
00<000000?ooo`3oool07P3oool9000002/0oooo00<000000?ooo`3oool01`3oool000X0oooo00<0
00000?ooo`3oool0?@3oool9000000`0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?oo
o`0E0?ooo`X00000=03oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`16
0?ooo`P000000P3oool4000005h0oooo00<000000?ooo`3oool0303oool9000003h0oooo00<00000
0?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0CP3oool7000005`0oooo0`0000030?oo
o`X00000A`3oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`1@0?ooo`D0
0000F`3oool700000540oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0
D03oool5000005/0oooo1@00001C0?ooo`030000003oool0oooo00L0oooo000:0?ooo`030000003o
ool0oooo05D0oooo00<000000?ooo`3oool0F03oool4000005@0oooo00<000000?ooo`3oool01`3o
ool000X0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0
oooo05H0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0E`3oool00`00
0000oooo0?ooo`1D0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool01`3oool000X0
oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo05P0
oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0F@3oool00`000000oooo
0?ooo`1@0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool01`3oool000X0oooo00<0
00000?ooo`3oool0FP3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo05X0oooo00<0
00000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`1<
0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?oo
o`3oool0G03oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo05`0oooo00<000000?oo
o`3oool01`3oool000X0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`180?ooo`03
0000003oool0oooo05d0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0
GP3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0
1`3oool000X0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`140?ooo`030000003o
ool0oooo05l0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0H03oool0
0`000000oooo0?ooo`120?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool01`3oool0
00X0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo
0640oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0HP3oool00`000000
oooo0?ooo`0n0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool01`3oool000X0oooo
00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo06<0oooo
00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool01`3oool000X0oooo00<00000
0?ooo`3oool0I@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo06D0oooo00<00000
0?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0IP3oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo06H0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3o
ool0I`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3o
ool01`3oool000X0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo06P0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0J@3o
ool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool01`3o
ool000X0oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo06X0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0JP3oool00`00
0000oooo0?ooo`0]0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool01`3oool000X0
oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo06`0
oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0K03oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool01`3oool000X0oooo00<0
00000?ooo`3oool0K@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo06h0oooo00<0
00000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?oo
o`3oool0K`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0700oooo00<000000?oo
o`3oool01`3oool000X0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`0Q0?ooo`03
0000003oool0oooo0740oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0
L@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0
1`3oool000X0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo07<0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0L`3oool0
0`000000oooo0?ooo`0K0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool01`3oool0
00X0oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
07D0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0M@3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool01`3oool000X0oooo
00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo07L0oooo
00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool01`3oool000X0oooo00<00000
0?ooo`3oool0N03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo07T0oooo00<00000
0?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo07X0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3o
ool0NP3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo07/0oooo00<000000?ooo`3o
ool01`3oool000X0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo07`0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0O03o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool01`3o
ool000X0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo07h0oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0OP3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool01`3oool000X0
oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0800
oooo00<000000?ooo`3oool01`3oool000X0oooo00<000000?ooo`3oool0P03oool01@000000oooo
0?ooo`3oool0000008<0oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool0
PP3oool00`000000oooo000000240?ooo`030000003oool0oooo00L0oooo00090?ooo`030000003o
ool0oooo0880oooo0P0000250?ooo`030000003oool0oooo00L0oooo00090?ooo`030000003oool0
oooo0840oooo00@000000?ooo`3oool00000Q03oool00`000000oooo0?ooo`070?ooo`002@3oool0
0`000000oooo0?ooo`200?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0P03oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1o0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`1n0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0OP3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`1l0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`1k0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0N`3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1j0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0N@3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1h0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`080?ooo`002@3o
ool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0M`3o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`080?ooo`002@3oool00`00
0000oooo0?ooo`1e0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0M@3oool00`00
0000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1d0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0L`3oool00`000000oooo
0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool0LP3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1a
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool0L03oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1_0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`080?ooo`00
2@3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
KP3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1]0?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`080?ooo`002@3oool0
0`000000oooo0?ooo`1/0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0K03oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo
02`0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`1Z0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0JP3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`1X0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?oo
o`080?ooo`002@3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo03<0oooo00<00000
0?ooo`3oool0J03oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1V0?oo
o`030000003oool0oooo03D0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`080?oo
o`002@3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3o
ool0IP3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1T0?ooo`030000
003oool0oooo03T0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`080?ooo`002@3o
ool00`000000oooo0?ooo`1S0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0I03o
ool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`080?ooo`002@3oool00`00
0000oooo0?ooo`1Q0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0HP3oool00`00
0000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo0440
oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo
0?ooo`1O0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0H03oool00`000000oooo
0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0G`3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1M
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo04T0oooo00<000000?oo
o`3oool0G@3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1K0?ooo`03
0000003oool0oooo04/0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`080?ooo`00
2@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0
F`3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1I0?ooo`030000003o
ool0oooo04l0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`080?ooo`002@3oool0
0`000000oooo0?ooo`1H0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0F@3oool0
0`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo
05<0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000
oooo0?ooo`1F0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E`3oool00`000000
oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05L0oooo
00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?oo
o`1A0?ooo`@00000F`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo00P0oooo0009
0?ooo`030000003oool0oooo0540oooo1000001L0?ooo`@00000D`3oool00`000000oooo0?ooo`08
0?ooo`002@3oool00`000000oooo0?ooo`1=0?ooo`P00000F`3oool600000580oooo00<000000?oo
o`3oool0203oool000T0oooo00<000000?ooo`3oool0@`3oool:000000<0oooo1@00001L0?ooo`L0
0000D03oool00`000000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0h0?ooo`/00000
3@3oool4000005d0oooo100000030?ooo`P00000B03oool00`000000oooo0?ooo`080?ooo`002@3o
ool00`000000oooo0?ooo`0]0?ooo`/000006P3oool00`000000oooo0?ooo`1N0?ooo`030000003o
ool0oooo00X0oooo2@00000o0?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003oool0
oooo02<0oooo2P00000U0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool04`3oool8
000003L0oooo00<000000?ooo`3oool0203oool000T0oooo00<000000?ooo`3oool0603oool;0000
02h0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`0K0?ooo`T00000;P3oool00`00
0000oooo0?ooo`080?ooo`002@3oool00`000000oooo0?ooo`0=0?ooo`/00000>@3oool00`000000
oooo0?ooo`1P0?ooo`030000003oool0oooo02<0oooo2000000V0?ooo`030000003oool0oooo00P0
oooo00070?ooo`@00000103oool:000004@0oooo00<000000?ooo`3oool0H03oool00`000000oooo
0?ooo`0[0?ooo`T000007@3oool00`000000oooo0?ooo`080?ooo`001P3oool9000004h0oooo00<0
00000?ooo`3oool0H03oool00`000000oooo0?ooo`0d0?ooo`P000005@3oool00`000000oooo0?oo
o`080?ooo`001`3oool500000540oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0l
0?ooo`T000002P3oool4000000T0oooo00070?ooo`D00000D@3oool00`000000oooo0?ooo`1P0?oo
o`030000003oool0oooo04D0oooo200000000`3oool0000000000004000000P0oooo000<0?ooo`03
0000003oool0oooo04h0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`1=0?ooo`L0
0000203oool000d0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1P0?ooo`030000
003oool0oooo04l0oooo1@0000080?ooo`003P3oool00`000000oooo0?ooo`1;0?ooo`030000003o
ool0oooo0640oooo00<000000?ooo`3oool0C`3oool010000000oooo0000000000090?ooo`003`3o
ool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0CP3o
ool00`000000oooo0?ooo`0;0?ooo`00403oool00`000000oooo0?ooo`190?ooo`030000003oool0
oooo0640oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0<0?ooo`004@3oool00`00
0000oooo0?ooo`180?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0B`3oool00`00
0000oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo0680
oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0B@3oool00`000000oooo
0?ooo`0?0?ooo`00503oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo0680oooo00<0
00000?ooo`3oool0B03oool00`000000oooo0?ooo`0@0?ooo`005@3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0A
0?ooo`005P3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo0680oooo00<000000?oo
o`3oool0AP3oool00`000000oooo0?ooo`0B0?ooo`005`3oool00`000000oooo0?ooo`110?ooo`03
0000003oool0oooo06<0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0C0?ooo`00
603oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0
A03oool00`000000oooo0?ooo`0D0?ooo`006@3oool00`000000oooo0?ooo`0o0?ooo`030000003o
ool0oooo06<0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0E0?ooo`006P3oool0
0`000000oooo0?ooo`0n0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0@@3oool0
0`000000oooo0?ooo`0F0?ooo`006`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo
06@0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0G0?ooo`00703oool00`000000
oooo0?ooo`0l0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0?`3oool00`000000
oooo0?ooo`0H0?ooo`00703oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo06@0oooo
00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0I0?ooo`007@3oool00`000000oooo0?oo
o`0k0?ooo`030000003oool0oooo06@0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?oo
o`0J0?ooo`007P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo06D0oooo00<00000
0?ooo`3oool0?03oool00`000000oooo0?ooo`0K0?ooo`007`3oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo06D0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0L0?oo
o`00803oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3o
ool0>P3oool00`000000oooo0?ooo`0M0?ooo`008@3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo06D0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0N0?ooo`008P3o
ool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`0O0?ooo`008`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0
oooo06H0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0P0?ooo`00903oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0=@3oool00`00
0000oooo0?ooo`0Q0?ooo`009@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo06H0
oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0R0?ooo`009P3oool00`000000oooo
0?ooo`0a0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`0S0?ooo`009`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo06L0oooo00<0
00000?ooo`3oool0<P3oool00`000000oooo0?ooo`0T0?ooo`00:03oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0U
0?ooo`00:@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo06L0oooo00<000000?oo
o`3oool0<03oool00`000000oooo0?ooo`0V0?ooo`00:P3oool00`000000oooo0?ooo`0/0?ooo`03
0000003oool0oooo06L0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0W0?ooo`00
:`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0
;P3oool00`000000oooo0?ooo`0X0?ooo`00;03oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo06P0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0Y0?ooo`00;@3oool0
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0:`3oool0
0`000000oooo0?ooo`0Z0?ooo`00;P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo
06P0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0[0?ooo`00;`3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0:@3oool00`000000
oooo0?ooo`0/0?ooo`00<03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool09`3oool2000002l0oooo000a0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool0J@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02l0oooo000b
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo0300oooo000c0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool0J@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0340oooo000d0?ooo`03
0000003oool0oooo0240oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo0380oooo000e0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
JP3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo03<0oooo000f0?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo03@0oooo000g0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0JP3oool0
0`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03D0oooo000h0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
03H0oooo000i0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0J`3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo03L0oooo000j0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo03P0oooo
000k0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo03T0oooo000l0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0J`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo03X0oooo000m0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo03/0oooo000n0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0J`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03`0oooo000o0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo03d0oooo00100?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0K@3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03h0oooo00110?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo03l0oooo00110?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0K@3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo0400oooo00120?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0440
oooo00130?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0K@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0480oooo00140?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool0K@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04<0oooo0015
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo04@0oooo00160?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0K@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo04D0oooo00170?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo04H0oooo00180?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
K`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04L0oooo00190?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo04P0oooo001:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0K`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo04T0oooo001;0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
04X0oooo001<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0K`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo04/0oooo001=0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo04`0oooo
001>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo04d0oooo001?0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0K`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04h0oooo001@0?oo
o`050000003oool0oooo0?ooo`000000LP3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo04l0oooo001A0?ooo`040000003oool0oooo000007<0oooo00D000000?ooo`3oool0oooo0000
001B0?ooo`00DP3oool400000780oooo00@000000?ooo`3oool00000D`3oool005<0oooo1000001_
0?ooo`D00000E03oool00580oooo?000000h0?ooo`@00000E@3oool00580oooo1@00000g0?oooc`0
0000E@3oool00580oooo1000001`0?ooo`@00000E@3oool00<H0oooo0`00001F0?ooo`00o`3ooolP
0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP
0?ooo`00o`3ooolP0?ooo`00\
\>"],
  ImageRangeCache->{{{124, 410.938}, {666.188, 379.25}} -> {-1.99631, \
1.75937, 0.0074617, 0.0074617}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphs and Matrices", "Subsection"],

Cell["\<\
In this package, a graph can be represented by one of three data \
structures.\
\>", "Text"],

Cell[TextData[{
  "A graph can be represented by a rule list. For example, ",
  Cell[BoxData[
      \(TraditionalForm\`{1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1, 
        3 \[Rule] 4}\)]],
  " represents the following directed graph."
}], "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .40444 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.611258 0.587448 0.20224 0.587448 [
[.9761 .02138 -3 -4.5 ]
[.9761 .02138 3 4.5 ]
[.97619 .39481 -3 -4.5 ]
[.97619 .39481 3 4.5 ]
[.53048 .21988 -3 -4.5 ]
[.53048 .21988 3 4.5 ]
[.02381 .21986 -3 -4.5 ]
[.02381 .21986 3 4.5 ]
[ 0 0 0 0 ]
[ 1 .40444 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.94673 .00963 m
.94682 .39481 L
s
% Start of user PostScript
0.57106918 -0.32787658 0.57121636 0.32781338 MAarrowhead1
% End of user PostScript
.94682 .39481 m
.53048 .20226 L
s
% Start of user PostScript
0.57121636 0.32781338 -0.1374979 0.000033180004 MAarrowhead1
% End of user PostScript
.53048 .20226 m
.94673 .00963 L
s
% Start of user PostScript
-0.1374979 0.000033180004 0.57106918 -0.32787658 MAarrowhead1
% End of user PostScript
.53048 .20226 m
.02381 .20224 L
s
% Start of user PostScript
-0.1374979 0.000033180004 -1. 0.0000076205381 MAarrowhead1
% End of user PostScript
[(1)] .9761 .02138 0 0 Mshowa
[(2)] .97619 .39481 0 0 Mshowa
[(3)] .53048 .21988 0 0 Mshowa
[(4)] .02381 .21986 0 0 Mshowa
0 0 m
1 0 L
1 .40444 L
0 .40444 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[35]:=",
  ImageSize->{288, 116.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000M2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3oool<0?ooo`<000004P3oool00?l0oooo1`3o
ool8000000D0oooo100000090?ooo`00o`3oool20?ooo`X000000P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00P0oooo003n0?ooo``000000`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00P0oooo003n0?ooo`/00000103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo003o0?ooo`P000001P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo003o0?ooo`L000001`3oool00`000000oooo0?ooo`030?ooo`<000002P3o
ool00?d0oooo0P0000000`3oool0000000000003000000P0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`080?ooo`00n`3oool2000000<0oooo0`00000:0?ooo`030000003oool0oooo
0100oooo003i0?ooo`8000001P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0100
oooo003g0?ooo`800000503oool00`000000oooo0?ooo`0@0?ooo`00m@3oool2000001H0oooo00<0
00000?ooo`3oool0403oool00?80oooo0`00000H0?ooo`030000003oool0oooo0100oooo003`0?oo
o`8000006`3oool00`000000oooo0?ooo`0@0?ooo`00kP3oool2000001d0oooo00<000000?ooo`3o
ool0403oool00>`0oooo0P00000O0?ooo`030000003oool0oooo0100oooo003Z0?ooo`8000008@3o
ool00`000000oooo0?ooo`0@0?ooo`00j03oool2000002<0oooo00<000000?ooo`3oool0403oool0
0>D0oooo0`00000U0?ooo`030000003oool0oooo0100oooo003S0?ooo`800000:03oool00`000000
oooo0?ooo`0@0?ooo`00h@3oool2000002X0oooo00<000000?ooo`3oool0403oool00=l0oooo0P00
000/0?ooo`030000003oool0oooo0100oooo003M0?ooo`800000;P3oool00`000000oooo0?ooo`0@
0?ooo`00f`3oool200000300oooo00<000000?ooo`3oool0403oool00=P0oooo0`00000b0?ooo`03
0000003oool0oooo0100oooo003F0?ooo`800000=@3oool00`000000oooo0?ooo`0@0?ooo`00e03o
ool2000003L0oooo00<000000?ooo`3oool0403oool00=80oooo0P00000i0?ooo`030000003oool0
oooo0100oooo003@0?ooo`800000>`3oool00`000000oooo0?ooo`0@0?ooo`00cP3oool2000003d0
oooo00<000000?ooo`3oool0403oool00</0oooo0`00000o0?ooo`030000003oool0oooo0100oooo
00390?ooo`800000@P3oool00`000000oooo0?ooo`0@0?ooo`00a`3oool2000004@0oooo00<00000
0?ooo`3oool0403oool00<D0oooo0P0000160?ooo`030000003oool0oooo0100oooo00330?ooo`80
0000B03oool00`000000oooo0?ooo`0@0?ooo`00`@3oool2000004X0oooo00<000000?ooo`3oool0
403oool00;h0oooo0`00001<0?ooo`030000003oool0oooo0100oooo002l0?ooo`800000C`3oool0
0`000000oooo0?ooo`0@0?ooo`00^P3oool200000540oooo00<000000?ooo`3oool0403oool00;P0
oooo0P00001C0?ooo`030000003oool0oooo0100oooo002f0?ooo`800000E@3oool00`000000oooo
0?ooo`0@0?ooo`00]03oool2000005L0oooo00<000000?ooo`3oool0403oool00;40oooo0`00001I
0?ooo`030000003oool0oooo0100oooo002_0?ooo`800000G03oool00`000000oooo0?ooo`0@0?oo
o`00[@3oool2000005h0oooo00<000000?ooo`3oool0403oool00:/0oooo0P00001P0?ooo`030000
003oool0oooo0100oooo002Y0?ooo`800000HP3oool00`000000oooo0?ooo`0@0?ooo`00Y`3oool2
000006@0oooo00<000000?ooo`3oool0403oool00:@0oooo0`00001V0?ooo`030000003oool0oooo
0100oooo002R0?ooo`800000J@3oool00`000000oooo0?ooo`0@0?ooo`005P3oool2000008P0oooo
0P00001[0?ooo`030000003oool0oooo0100oooo000B0?ooo`H00000QP3oool2000006d0oooo00<0
00000?ooo`3oool0403oool000l0oooo2@0000240?ooo`800000K`3oool00`000000oooo0?ooo`0@
0?ooo`002`3oool=00000880oooo0P00001a0?ooo`030000003oool0oooo0100oooo00090?oooi80
0000LP3oool00`000000oooo0?ooo`0@0?ooo`00303oool<00000840oooo1P00001^0?ooo`030000
003oool0oooo0100oooo000@0?ooo`P00000PP3oool:000006T0oooo00<000000?ooo`3oool0403o
ool000T0oooo00<000000?ooo`3oool02@3oool3000007l0oooo0P0000030?ooo`/00000IP3oool0
0`000000oooo0?ooo`0@0?ooo`002@3oool00`000000oooo0?ooo`2:0?ooo`040000003oool0oooo
000000<0oooo2P00001V0?ooo`030000003oool0oooo0100oooo00060?ooo`D00000SP3oool00`00
0000oooo0?ooo`020?ooo`P00000I`3oool00`000000oooo0?ooo`0@0?ooo`001P3oool010000000
oooo0?ooo`00002=0?ooo`8000001P3oool8000006H0oooo00<000000?ooo`3oool0403oool000L0
oooo00<000000?ooo`000000S`3oool00`000000oooo0?ooo`040?ooo`D000000P3oool2000006@0
oooo00<000000?ooo`3oool0403oool000P0oooo0P00002<0?ooo`040000003oool0oooo000000P0
oooo0`0000040?ooo`800000HP3oool00`000000oooo0?ooo`0@0?ooo`002@3oool00`000000oooo
0?ooo`2;0?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`800000H03oool00`000000oooo
0?ooo`0@0?ooo`00[@3oool2000005h0oooo00<000000?ooo`3oool0403oool00:l0oooo0P00001L
0?ooo`030000003oool0oooo0100oooo002a0?ooo`<00000F@3oool00`000000oooo0?ooo`0@0?oo
o`00]03oool2000005L0oooo00<000000?ooo`3oool0403oool00;H0oooo0P00001E0?ooo`030000
003oool0oooo0100oooo002h0?ooo`800000D`3oool00`000000oooo0?ooo`0@0?ooo`00^P3oool2
00000540oooo00<000000?ooo`3oool0403oool00;`0oooo0P00001?0?ooo`030000003oool0oooo
0100oooo002n0?ooo`<00000C03oool00`000000oooo0?ooo`0@0?ooo`00`@3oool2000004X0oooo
00<000000?ooo`3oool0403oool00<<0oooo0P0000180?ooo`030000003oool0oooo0100oooo0035
0?ooo`800000AP3oool00`000000oooo0?ooo`0@0?ooo`00a`3oool2000004@0oooo00<000000?oo
o`3oool0403oool00<T0oooo0P0000120?ooo`030000003oool0oooo0100oooo003;0?ooo`<00000
?`3oool00`000000oooo0?ooo`0@0?ooo`00cP3oool2000003d0oooo00<000000?ooo`3oool0403o
ool00=00oooo0P00000k0?ooo`030000003oool0oooo0100oooo003B0?ooo`800000>@3oool00`00
0000oooo0?ooo`0@0?ooo`00e03oool2000003L0oooo00<000000?ooo`3oool0403oool00=H0oooo
0P00000e0?ooo`030000003oool0oooo0100oooo003H0?ooo`<00000<P3oool00`000000oooo0?oo
o`0@0?ooo`00f`3oool200000300oooo00<000000?ooo`3oool0403oool00=d0oooo0P00000^0?oo
o`030000003oool0oooo0100oooo003O0?ooo`800000;03oool00`000000oooo0?ooo`0@0?ooo`00
h@3oool2000002X0oooo00<000000?ooo`3oool0403oool00><0oooo0P00000X0?ooo`030000003o
ool0oooo0100oooo003U0?ooo`<000009@3oool00`000000oooo0?ooo`0@0?ooo`00j03oool20000
02<0oooo00<000000?ooo`3oool0403oool00>X0oooo0P00000Q0?ooo`030000003oool0oooo0100
oooo003/0?ooo`8000007`3oool00`000000oooo0?ooo`0@0?ooo`00kP3oool2000001T0oooo2000
000?0?ooo`00l03oool2000001L0oooo2000000?0?ooo`00lP3oool3000001D0oooo1`00000?0?oo
o`00m@3oool2000001<0oooo1P00000@0?ooo`00m`3oool200000140oooo1P00000@0?ooo`00n@3o
ool2000000l0oooo1P00000@0?ooo`00n`3oool2000000h0oooo1@00000@0?ooo`00o@3oool20000
00`0oooo1@00000@0?ooo`00o`3oool3000000T0oooo1000000A0?ooo`00o`3oool30?ooo`800000
203oool300000140oooo003o0?ooo`D0oooo0P0000060?ooo`<000004@3oool00?l0oooo1`3oool2
000000@0oooo0`00000A0?ooo`00o`3oool90?ooo`8000000P3oool2000000D0oooo100000090?oo
o`00o`3oool;0?ooo`80000000<0oooo0000003oool0103oool00`000000oooo0?ooo`0:0?ooo`00
o`3oool=0?ooo`8000001P3oool00`000000oooo0?ooo`090?ooo`00o`3ooolF0?ooo`030000003o
ool0oooo00P0oooo003o0?oooaL0oooo00<000000?ooo`3oool01`3oool00?l0oooo503oool01000
0000oooo0?ooo`0000090?ooo`00o`3ooolE0?ooo`8000002P3oool00001\
\>"],
  ImageRangeCache->{{{124, 411}, {268.813, 153.375}} -> {-1.80996, 0.584907, \
0.00605822, 0.00605822}}],

Cell[TextData[{
  "A graph can also be represented by its adjacency matrix. Let ",
  Cell[BoxData[
      \(TraditionalForm\`G\  = \ {V, \ E}\)]],
  " be a directed graph. Assuming that the vertices are indices from ",
  Cell[BoxData[
      \(TraditionalForm\`1\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", that is, ",
  Cell[BoxData[
      \(TraditionalForm\`V\  = \ {1, \ 2, \  ... , \ n}\)]],
  ", then the adjacency matrix of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is an ",
  Cell[BoxData[
      \(TraditionalForm\`n\ \[Times]\ n\)]],
  " matrix, with entries ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["a", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "=", " ", "1"}], 
        TraditionalForm]]],
  " if ",
  Cell[BoxData[
      \(TraditionalForm\`{i, \ j}\  \[Element] \ E\)]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["a", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "=", " ", "0"}], 
        TraditionalForm]]],
  " otherwise. For example, the following adjacency matrix represent the same \
directed graph as above."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", GridBox[{
            {"0", "1", "0", "0"},
            {"0", "0", "1", "0"},
            {"1", "0", "0", "1"},
            {"0", "0", "0", "0"}
            }], ")"}], TraditionalForm]], "DisplayMath"],

Cell[TextData[{
  "An undirected graph, on the other hand, is represented by a symmetric \
adjacency matrix. The matrix entries ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["a", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "=", " ", 
          RowBox[{
            SubscriptBox["a", 
              StyleBox[
                RowBox[{"j", 
                  StyleBox["i",
                    FontSlant->"Italic"]}]]], "=", " ", "1"}]}], 
        TraditionalForm]]],
  " if ",
  Cell[BoxData[
      \(TraditionalForm\`{i, \ j}\  \[Element] \ E\)]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["a", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "=", " ", "0"}], 
        TraditionalForm]]],
  " otherwise. For example, this adjacency matrix represents the undirected \
graph that follows it."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{"(", GridBox[{
            {"0", "1", "1", "0"},
            {"1", "0", "1", "0"},
            {"1", "1", "0", "1"},
            {"0", "0", "1", "0"}
            }], ")"}], TraditionalForm]], "DisplayMath"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .40444 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.611258 0.587448 0.20224 0.587448 [
[.9761 .02138 -3 -4.5 ]
[.9761 .02138 3 4.5 ]
[.97619 .39481 -3 -4.5 ]
[.97619 .39481 3 4.5 ]
[.53048 .21988 -3 -4.5 ]
[.53048 .21988 3 4.5 ]
[.02381 .21986 -3 -4.5 ]
[.02381 .21986 3 4.5 ]
[ 0 0 0 0 ]
[ 1 .40444 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.94673 .00963 m
.94682 .39481 L
s
.94682 .39481 m
.53048 .20226 L
s
.53048 .20226 m
.94673 .00963 L
s
.53048 .20226 m
.02381 .20224 L
s
[(1)] .9761 .02138 0 0 Mshowa
[(2)] .97619 .39481 0 0 Mshowa
[(3)] .53048 .21988 0 0 Mshowa
[(4)] .02381 .21986 0 0 Mshowa
0 0 m
1 0 L
1 .40444 L
0 .40444 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[36]:=",
  ImageSize->{288, 116.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000M2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3oool=0?ooo`8000004P3oool00?l0oooo2`3o
ool2000000030?ooo`000000oooo00@0oooo100000090?ooo`00o`3oool90?ooo`8000000`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo003o0?ooo`L0oooo0P0000050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00?l0oooo1@3oool2000000L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`00o`3oool30?ooo`800000
2@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo003o0?ooo`<000002`3o
ool00`000000oooo0?ooo`030?ooo`<000002P3oool00?d0oooo0P00000>0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0203oool00?/0oooo0P00000@0?ooo`030000003oool0oooo
0100oooo003i0?ooo`8000004P3oool00`000000oooo0?ooo`0@0?ooo`00m`3oool2000001@0oooo
00<000000?ooo`3oool0403oool00?D0oooo0P00000F0?ooo`030000003oool0oooo0100oooo003b
0?ooo`<00000603oool00`000000oooo0?ooo`0@0?ooo`00l03oool2000001/0oooo00<000000?oo
o`3oool0403oool00>h0oooo0P00000M0?ooo`030000003oool0oooo0100oooo003/0?ooo`800000
7`3oool00`000000oooo0?ooo`0@0?ooo`00jP3oool200000240oooo00<000000?ooo`3oool0403o
ool00>P0oooo0P00000S0?ooo`030000003oool0oooo0100oooo003U0?ooo`<000009@3oool00`00
0000oooo0?ooo`0@0?ooo`00h`3oool2000002P0oooo00<000000?ooo`3oool0403oool00>40oooo
0P00000Z0?ooo`030000003oool0oooo0100oooo003O0?ooo`800000;03oool00`000000oooo0?oo
o`0@0?ooo`00g@3oool2000002h0oooo00<000000?ooo`3oool0403oool00=/0oooo0P00000`0?oo
o`030000003oool0oooo0100oooo003H0?ooo`<00000<P3oool00`000000oooo0?ooo`0@0?ooo`00
eP3oool2000003D0oooo00<000000?ooo`3oool0403oool00=@0oooo0P00000g0?ooo`030000003o
ool0oooo0100oooo003B0?ooo`800000>@3oool00`000000oooo0?ooo`0@0?ooo`00d03oool20000
03/0oooo00<000000?ooo`3oool0403oool00<h0oooo0P00000m0?ooo`030000003oool0oooo0100
oooo003;0?ooo`<00000?`3oool00`000000oooo0?ooo`0@0?ooo`00b@3oool200000480oooo00<0
00000?ooo`3oool0403oool00<L0oooo0P0000140?ooo`030000003oool0oooo0100oooo00350?oo
o`800000AP3oool00`000000oooo0?ooo`0@0?ooo`00``3oool2000004P0oooo00<000000?ooo`3o
ool0403oool00<40oooo0P00001:0?ooo`030000003oool0oooo0100oooo002n0?ooo`<00000C03o
ool00`000000oooo0?ooo`0@0?ooo`00_03oool2000004l0oooo00<000000?ooo`3oool0403oool0
0;X0oooo0P00001A0?ooo`030000003oool0oooo0100oooo002h0?ooo`800000D`3oool00`000000
oooo0?ooo`0@0?ooo`00]P3oool2000005D0oooo00<000000?ooo`3oool0403oool00;@0oooo0P00
001G0?ooo`030000003oool0oooo0100oooo002a0?ooo`<00000F@3oool00`000000oooo0?ooo`0@
0?ooo`00[`3oool2000005`0oooo00<000000?ooo`3oool0403oool00:d0oooo0P00001N0?ooo`03
0000003oool0oooo0100oooo002[0?ooo`800000H03oool00`000000oooo0?ooo`0@0?ooo`00Z@3o
ool200000680oooo00<000000?ooo`3oool0403oool00:L0oooo0P00001T0?ooo`030000003oool0
oooo0100oooo002T0?ooo`<00000IP3oool00`000000oooo0?ooo`0@0?ooo`00XP3oool2000006T0
oooo00<000000?ooo`3oool0403oool00:00oooo0P00001[0?ooo`030000003oool0oooo0100oooo
002N0?ooo`800000K@3oool00`000000oooo0?ooo`0@0?ooo`00W03oool2000006l0oooo00<00000
0?ooo`3oool0403oool009X0oooo0P00001a0?ooo`030000003oool0oooo0100oooo00090?oooi40
0000L`3oool00`000000oooo0?ooo`0@0?ooo`00VP3oool200000740oooo00<000000?ooo`3oool0
403oool009`0oooo0P00001_0?ooo`030000003oool0oooo0100oooo00090?ooo`030000003oool0
oooo08/0oooo0P0000050?ooo`800000K@3oool00`000000oooo0?ooo`0@0?ooo`002@3oool00`00
0000oooo0?ooo`2:0?ooo`040000003oool0oooo000000H0oooo0P00001[0?ooo`030000003oool0
oooo0100oooo00060?ooo`D00000SP3oool00`000000oooo0?ooo`060?ooo`800000J@3oool00`00
0000oooo0?ooo`0@0?ooo`001P3oool010000000oooo0?ooo`00002=0?ooo`8000002`3oool30000
06H0oooo00<000000?ooo`3oool0403oool000L0oooo00<000000?ooo`000000S`3oool00`000000
oooo0?ooo`0;0?ooo`800000I03oool00`000000oooo0?ooo`0@0?ooo`00203oool2000008`0oooo
00@000000?ooo`3oool000003`3oool200000680oooo00<000000?ooo`3oool0403oool000T0oooo
00<000000?ooo`3oool0R`3oool200000180oooo0P00001P0?ooo`030000003oool0oooo0100oooo
002]0?ooo`800000GP3oool00`000000oooo0?ooo`0@0?ooo`00[`3oool2000005`0oooo00<00000
0?ooo`3oool0403oool00;40oooo0`00001I0?ooo`030000003oool0oooo0100oooo002d0?ooo`80
0000E`3oool00`000000oooo0?ooo`0@0?ooo`00]P3oool2000005D0oooo00<000000?ooo`3oool0
403oool00;P0oooo0P00001C0?ooo`030000003oool0oooo0100oooo002j0?ooo`800000D@3oool0
0`000000oooo0?ooo`0@0?ooo`00_03oool2000004l0oooo00<000000?ooo`3oool0403oool00;h0
oooo0`00001<0?ooo`030000003oool0oooo0100oooo00310?ooo`800000BP3oool00`000000oooo
0?ooo`0@0?ooo`00``3oool2000004P0oooo00<000000?ooo`3oool0403oool00<D0oooo0P000016
0?ooo`030000003oool0oooo0100oooo00370?ooo`800000A03oool00`000000oooo0?ooo`0@0?oo
o`00b@3oool200000480oooo00<000000?ooo`3oool0403oool00</0oooo0`00000o0?ooo`030000
003oool0oooo0100oooo003>0?ooo`800000?@3oool00`000000oooo0?ooo`0@0?ooo`00d03oool2
000003/0oooo00<000000?ooo`3oool0403oool00=80oooo0P00000i0?ooo`030000003oool0oooo
0100oooo003D0?ooo`800000=`3oool00`000000oooo0?ooo`0@0?ooo`00eP3oool2000003D0oooo
00<000000?ooo`3oool0403oool00=P0oooo0`00000b0?ooo`030000003oool0oooo0100oooo003K
0?ooo`800000<03oool00`000000oooo0?ooo`0@0?ooo`00g@3oool2000002h0oooo00<000000?oo
o`3oool0403oool00=l0oooo0P00000/0?ooo`030000003oool0oooo0100oooo003Q0?ooo`800000
:P3oool00`000000oooo0?ooo`0@0?ooo`00h`3oool2000002P0oooo00<000000?ooo`3oool0403o
ool00>D0oooo0`00000U0?ooo`030000003oool0oooo0100oooo003X0?ooo`8000008`3oool00`00
0000oooo0?ooo`0@0?ooo`00jP3oool200000240oooo00<000000?ooo`3oool0403oool00>`0oooo
0P00000O0?ooo`030000003oool0oooo0100oooo003^0?ooo`8000007@3oool00`000000oooo0?oo
o`0@0?ooo`00l03oool2000001/0oooo00<000000?ooo`3oool0403oool00?80oooo0`00000H0?oo
o`030000003oool0oooo0100oooo003e0?ooo`8000005P3oool00`000000oooo0?ooo`0@0?ooo`00
m`3oool2000001@0oooo00<000000?ooo`3oool0403oool00?T0oooo0P00000B0?ooo`030000003o
ool0oooo0100oooo003k0?ooo`800000403oool00`000000oooo0?ooo`0@0?ooo`00o@3oool20000
00h0oooo00<000000?ooo`3oool0403oool00?l0oooo0`00000;0?ooo`030000003oool0oooo0100
oooo003o0?ooo`<0oooo0P0000090?ooo`030000003oool0oooo0100oooo003o0?ooo`D0oooo0P00
00070?ooo`030000003oool0oooo0100oooo003o0?ooo`L0oooo0P0000050?ooo`030000003oool0
oooo0100oooo003o0?ooo`T0oooo0P0000030?ooo`030000003oool0oooo00<0oooo100000090?oo
o`00o`3oool;0?ooo`80000000<0oooo0000003oool0103oool00`000000oooo0?ooo`0:0?ooo`00
o`3oool=0?ooo`8000001P3oool00`000000oooo0?ooo`090?ooo`00o`3ooolF0?ooo`030000003o
ool0oooo00P0oooo003o0?oooaL0oooo00<000000?ooo`3oool01`3oool00?l0oooo503oool01000
0000oooo0?ooo`0000090?ooo`00o`3ooolE0?ooo`8000002P3oool00001\
\>"],
  ImageRangeCache->{{{124, 411}, {602.125, 486.688}} -> {-1.80996, 2.60419, \
0.00605822, 0.00605822}}]
}, Open  ]],

Cell[TextData[{
  "Because of the zero entries in an adjacency matrix, it is often convenient \
to represent the matrix using a ",
  StyleBox["SparseArray", "MR"],
  ". For example, the previous matrix can be written as the following sparse \
array."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SparseArray[{{1, 2} \[Rule] 1, {2, 3} \[Rule] 1, {2, 4} \[Rule] 
          1, {3, 2} \[Rule] 1, {3, 4} \[Rule] 1, {4, 2} \[Rule] 
          1, {4, 3} \[Rule] 1}, {4, 4}]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    TagBox[
      TagBox[\(SparseArray["\<<\>"\[InvisibleSpace]7\[InvisibleSpace]"\<>\>", \
{4, 4}]\),
        False,
        Editable->False],
      (Short[ #, 1000]&)]], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  "A bipartite graph, also called a bigraph, is a special graph in which the \
vertices can be decomposed into two sets, ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " and ",
  StyleBox["C",
    FontSlant->"Italic"],
  ", such that no edges exist between vertices within ",
  StyleBox["R,",
    FontSlant->"Italic"],
  " and no edges exist between vertices within ",
  StyleBox["C",
    FontSlant->"Italic"],
  ". Assuming that there are ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " vertices in ",
  StyleBox["R",
    FontSlant->"Italic"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " vertices in ",
  StyleBox["C",
    FontSlant->"Italic"],
  ", a bipartite graph can be represented by an ",
  Cell[BoxData[
      \(TraditionalForm\`m\[Times]n\)]],
  " matrix with all entries zero except ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["a", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "\[NotEqual]", " ", "0"}], 
        TraditionalForm]]],
  " if ",
  Cell[BoxData[
      \(TraditionalForm\`i \[Element] \ R\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`j \[Element] \ C\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`{i, j}\)]],
  " forms an edge."
}], "Text"],

Cell[TextData[{
  "Sometimes a graph will have attributes associated with the vertices and \
edges. Weights are one such attribute. Edge weights can be included in the \
adjacency matrix by making ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["a", 
          StyleBox["ij",
            FontSlant->"Italic"]], TraditionalForm]]],
  " contain the weight for the edge ",
  Cell[BoxData[
      \(TraditionalForm\`\(\({i, \ j}\)\(.\)\)\)]],
  " Vertex weights cannot be easily included in the adjacency matrix. \
However, a separate vector of length ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(V\)\(|\)\)\)]],
  " can be used to contain the vertex weights."
}], "Text"],

Cell[TextData[{
  "Finally, graphs from the ",
  StyleBox["Combinatorica",
    FontSlant->"Italic"],
  " package are also supported."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphPlot/GraphPlot3D", "Section",
  CellTags->{"graphplot", "i:3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GraphPlot",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(g, \ options\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            Cell["\<\
calculates a visually appealing two-dimensional layout \
and plots the graph using this layout\
\>", "Text"]},
          {
            RowBox[{
              RowBox[{
                StyleBox["GraphPlot3D",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["g",
                    "TI"], ",", " ", 
                  StyleBox["options",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  "MR"]}], " "}], 
            Cell["\<\
calculates a visually appealing three-dimensional \
layout and plots the graph using this layout\
\>", "Text"]}
          }], TextForm]], "DefinitionBox"],

Cell["Graph drawing functions.", "Caption"],

Cell["This plots a graph specified by a rule list.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[{1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 4, 4 \[Rule] 5, 
          5 \[Rule] 6, 6 \[Rule] 7, 7 \[Rule] 8, 8 \[Rule] 1, 1 \[Rule] 9, 
          2 \[Rule] 9, 3 \[Rule] 10, 4 \[Rule] 10, 6 \[Rule] 11, 
          5 \[Rule] 11, 7 \[Rule] 12, 8 \[Rule] 12}, 
        EdgeStyleFunction \[Rule] \((Arrow[{#1, #2}] &)\)];\)\)], "Input",
  CellLabel->"In[3]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0005 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.499785 0.47649 0.500188 0.47649 [
[ 0 0 0 0 ]
[ 1 1.0005 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.5 Mabswid
[ ] 0 setdash
.92954 .70588 m
.69062 .93684 L
s
% Start of user PostScript
0.9019258 0.43169169 0.40049851 0.91638768 MAarrowhead1
% End of user PostScript
.92954 .70588 m
.96016 .97668 L
s
% Start of user PostScript
0.9019258 0.43169169 0.96617457 1. MAarrowhead1
% End of user PostScript
.69062 .93684 m
.29472 .92945 L
s
% Start of user PostScript
0.40049851 0.91638768 -0.43036642 0.90087461 MAarrowhead1
% End of user PostScript
.69062 .93684 m
.96016 .97668 L
s
% Start of user PostScript
0.40049851 0.91638768 0.96617457 1. MAarrowhead1
% End of user PostScript
.29472 .92945 m
.06349 .69042 L
s
% Start of user PostScript
-0.43036642 0.90087461 -0.91563581 0.39922878 MAarrowhead1
% End of user PostScript
.29472 .92945 m
.02381 .96003 L
s
% Start of user PostScript
-0.43036642 0.90087461 -0.99891958 0.9650612 MAarrowhead1
% End of user PostScript
.06349 .69042 m
.07024 .29456 L
s
% Start of user PostScript
-0.91563581 0.39922878 -0.90146722 -0.43154132 MAarrowhead1
% End of user PostScript
.06349 .69042 m
.02381 .96003 L
s
% Start of user PostScript
-0.91563581 0.39922878 -0.99891958 0.9650612 MAarrowhead1
% End of user PostScript
.07024 .29456 m
.30899 .06375 L
s
% Start of user PostScript
-0.90146722 -0.43154132 -0.40041922 -0.91593345 MAarrowhead1
% End of user PostScript
.07024 .29456 m
.03954 .02382 L
s
% Start of user PostScript
-0.90146722 -0.43154132 -0.96591643 -0.99974098 MAarrowhead1
% End of user PostScript
.30899 .06375 m
.70524 .07086 L
s
% Start of user PostScript
-0.40041922 -0.91593345 0.43118898 -0.90102472 MAarrowhead1
% End of user PostScript
.30899 .06375 m
.03954 .02382 L
s
% Start of user PostScript
-0.40041922 -0.91593345 -0.96591643 -0.99974098 MAarrowhead1
% End of user PostScript
.70524 .07086 m
.93639 .31015 L
s
% Start of user PostScript
0.43118898 -0.90102472 0.91629606 -0.39882096 MAarrowhead1
% End of user PostScript
.70524 .07086 m
.97619 .04053 L
s
% Start of user PostScript
0.43118898 -0.90102472 0.99982274 -0.96468297 MAarrowhead1
% End of user PostScript
.93639 .31015 m
.92954 .70588 L
s
% Start of user PostScript
0.91629606 -0.39882096 0.9019258 0.43169169 MAarrowhead1
% End of user PostScript
.93639 .31015 m
.97619 .04053 L
s
% Start of user PostScript
0.91629606 -0.39882096 0.99982274 -0.96468297 MAarrowhead1
% End of user PostScript
.008 w
.92954 .70588 Mdot
.69062 .93684 Mdot
.29472 .92945 Mdot
.06349 .69042 Mdot
.07024 .29456 Mdot
.30899 .06375 Mdot
.70524 .07086 Mdot
.93639 .31015 Mdot
.96016 .97668 Mdot
.02381 .96003 Mdot
.03954 .02382 Mdot
.97619 .04053 Mdot
0 0 m
1 0 L
1 1.0005 L
0 1.0005 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{287.813, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O00017b000`400?l00000o`00003oo`3ooolP
0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`00o`3ooolP0?ooo`004`3oool8
00000?l0oooo1@3oool000X0oooo4@00003o0?ooo`D0oooo000;0?ooo`030000003oool0000000`0
0000o`3oool60?ooo`002`3oool200000080oooo3@00003o0?ooo`@0oooo000;0?ooo`800000103o
ool900000080oooo1P00003W0?ooo`@000004P3oool000X0oooo0`0000060?ooo`L00000203oool6
00000>40oooo2`00000;0?ooo`002P3oool4000000L0oooo1000000?0?ooo`L00000fP3oool@0000
00H0oooo000:0?ooo`@000002@3oool2000001H0oooo1P00003D0?ooo`d0000000<0oooo00000000
00001P3oool000X0oooo1000000W0?ooo`L00000aP3ooolB00000080oooo0P0000070?ooo`002P3o
ool5000002d0oooo1P00002h0?ooo`P00000203oool7000000D0oooo0P0000070?ooo`002P3oool5
000003<0oooo1P00002Y0?ooo`T00000403oool4000000P0oooo0`0000060?ooo`002P3oool60000
03P0oooo1`00001/0?ooo`800000:`3oool9000001T0oooo0P0000090?ooo`@000001P3oool000X0
oooo1P00000o0?ooo`H000000`3oool200000640oooo1P00000O0?ooo`P00000;@3oool4000000H0
oooo00090?ooo`L00000A@3ooolP000004H0oooo2P00000B0?ooo`T00000=@3oool4000000H0oooo
00090?ooo`P00000A@3oool2000001d0oooo>@00000=0?ooo`h000001P3oool8000003d0oooo1@00
00060?ooo`002@3oool8000004<0oooo1000001F0?ooob400000A@3oool5000000H0oooo00090?oo
o`D00000A03oool5000006@0oooo3@0000020?ooo`800000A`3oool6000000H0oooo000=0?ooo`03
0000003oool0oooo0400oooo1P00001U0?ooo`P000002@3oool00`000000oooo0?ooo`140?ooo`H0
00001P3oool000d0oooo00<000000?ooo`3oool0?P3oool8000006D0oooo0`00000?0?ooo`030000
003oool0oooo04<0oooo1`0000050?ooo`003@3oool00`000000oooo0?ooo`0l0?ooo`T00000N@3o
ool00`000000oooo0?ooo`110?ooo`P000001@3oool000d0oooo00<000000?ooo`3oool0>`3oool9
000007/0oooo00<000000?ooo`3oool0@03oool8000000D0oooo000=0?ooo`030000003oool0oooo
03`0oooo2000001l0?ooo`030000003oool0oooo0480oooo1@0000050?ooo`003@3oool00`000000
oooo0?ooo`0m0?ooo`H00000OP3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00L0
oooo000>0?ooo`030000003oool0oooo03d0oooo100000200?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool01`3oool000h0oooo00<000000?ooo`3oool0?03oool00`000000oooo0000
000200000840oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`080?ooo`003P3oool0
0`000000oooo0?ooo`0k0?ooo`050000003oool0oooo0?ooo`000000P`3oool00`000000oooo0?oo
o`0m0?ooo`030000003oool0oooo00P0oooo000>0?ooo`030000003oool0oooo03X0oooo00<00000
0?ooo`3oool0Q`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo00P0oooo000>0?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`0l0?oo
o`030000003oool0oooo00P0oooo000>0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool0RP3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo00P0oooo000>0?ooo`030000
003oool0oooo03H0oooo0P00002>0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0
203oool000h0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`2?0?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool0203oool000h0oooo00<000000?ooo`3oool0=03oool0
0`000000oooo0?ooo`2A0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool02@3oool0
00l0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool02@3oool000l0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`2E0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool02@3oool000l0oooo
00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo03@0oooo
00<000000?ooo`3oool02@3oool000l0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?oo
o`2I0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool02@3oool000l0oooo00<00000
0?ooo`3oool0;P3oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool02@3oool000l0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2M0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool02@3oool000l0oooo00<000000?ooo`3o
ool0;03oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3o
ool02P3oool000l0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`2Q0?ooo`030000
003oool0oooo02h0oooo00<000000?ooo`3oool02P3oool000l0oooo00<000000?ooo`3oool0:P3o
ool00`000000oooo0?ooo`2S0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool02P3o
ool00100oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`2U0?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool02P3oool00100oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`2W0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool02P3oool00100
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2Y0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool02P3oool00100oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`2[0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool02P3oool00100oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool02P3oool00100oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`2_
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool02`3oool00100oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool02`3oool00100oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2c0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool02`3oool00140oooo00<000000?ooo`3oool0
7`3oool00`000000oooo0?ooo`2e0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
2`3oool00140oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2f0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool02`3oool00140oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`2h0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool02`3oool0
0140oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`2j0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool02`3oool00140oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`2l0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0303oool00140oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`2n0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool0303oool00140oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`300?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0303oool00140oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`320?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0303oool00140oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`340?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0303oool00180oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool0303oool00180oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`380?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0303oool00180oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool03@3o
ool00180oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`3<0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool03@3oool00180oooo00<000000?ooo`3oool0403oool20000
0=00oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0=0?ooo`004P3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0=40oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0=<0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0=D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0=0?ooo`004P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0=L0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0=0?ooo`004`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo0=T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?oo
o`004`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0=/0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0=d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`004`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0=l0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0>40oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00h0oooo000C0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0h`3oool00`00
0000oooo0?ooo`03000000L0oooo00<000000?ooo`3oool03P3oool001<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`3T0?ooo`030000003oool0000000<000001`3oool00`000000
oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0>H0oooo
1P0000050?ooo`030000003oool0oooo00l0oooo000D0?ooo`050000003oool0oooo0?ooo`000000
j03oool7000000D0oooo00<000000?ooo`3oool03`3oool001@0oooo00@000000?ooo`3oool00000
j03oool9000000@0oooo00<000000?ooo`3oool03`3oool001@0oooo00<000000?ooo`000000jP3o
ool8000000@0oooo00<000000?ooo`3oool03`3oool001@0oooo0P00003]0?ooo`L000000`3oool0
0`000000oooo0?ooo`0?0?ooo`004`3oool200000>l0oooo1P0000030?ooo`030000003oool0oooo
00l0oooo000D0?ooo`030000003oool0oooo0>l0oooo1@0000020?ooo`030000003oool0oooo00l0
oooo000C0?ooo`800000lP3oool4000000030?ooo`000000oooo0140oooo000C0?ooo`<00000l`3o
ool400000180oooo000C0?ooo`<00000m03oool300000180oooo000C0?ooo`<00000mP3oool00`00
0000oooo0?ooo`0@0?ooo`004P3oool400000?H0oooo00<000000?ooo`3oool0403oool00180oooo
1000003f0?ooo`030000003oool0oooo0100oooo000B0?ooo`D00000m@3oool00`000000oooo0?oo
o`0@0?ooo`004@3oool600000?D0oooo00<000000?ooo`3oool0403oool00140oooo1P00003e0?oo
o`030000003oool0oooo0100oooo000A0?ooo`H00000m@3oool00`000000oooo0?ooo`0@0?ooo`00
4@3oool700000?@0oooo00<000000?ooo`3oool0403oool00100oooo2000003d0?ooo`030000003o
ool0oooo0100oooo000@0?ooo`P00000m03oool00`000000oooo0?ooo`0@0?ooo`00503oool00`00
0000oooo0?ooo`3e0?ooo`030000003oool0oooo0100oooo000D0?ooo`030000003oool0oooo0?D0
oooo00<000000?ooo`3oool0403oool001@0oooo00<000000?ooo`3oool0m@3oool00`000000oooo
0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0100oooo000D
0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0403oool001@0oooo00<000000?oo
o`3oool0m@3oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`3e0?ooo`03
0000003oool0oooo0100oooo000D0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0
403oool001@0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0@0?ooo`00503oool0
0`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0100oooo000D0?ooo`030000003oool0oooo
0?D0oooo00<000000?ooo`3oool0403oool001@0oooo00<000000?ooo`3oool0m@3oool00`000000
oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0100oooo
000D0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0403oool001<0oooo00<00000
0?ooo`3oool0mP3oool00`000000oooo0?ooo`0@0?ooo`004`3oool00`000000oooo0?ooo`3f0?oo
o`030000003oool0oooo0100oooo000C0?ooo`030000003oool0oooo0?H0oooo00<000000?ooo`3o
ool0403oool001<0oooo00<000000?ooo`3oool0mP3oool00`000000oooo0?ooo`0@0?ooo`004`3o
ool00`000000oooo0?ooo`3f0?ooo`030000003oool0oooo0100oooo000C0?ooo`030000003oool0
oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`00
0000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140
oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<0
00000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e
0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?oo
o`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`00
4`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003o
ool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool0
0`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo
0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo
00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?oo
o`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<00000
0?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?oo
o`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000
003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3o
ool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0
oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0
oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo
0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<0
00000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A
0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`03
0000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0
m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003o
ool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool0
01<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000
oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo
00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?oo
o`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?oo
o`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3o
ool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000
003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3o
ool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`00
0000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0
oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo
0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C
0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04@3oool001<0oooo00<000000?oo
o`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`3e0?ooo`03
0000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool0
4@3oool001<0oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0A0?ooo`004`3oool0
0`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo
0?D0oooo00<000000?ooo`3oool04@3oool00180oooo00<000000?ooo`3oool0mP3oool00`000000
oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`3f0?ooo`030000003oool0oooo0140oooo
000B0?ooo`030000003oool0oooo0?H0oooo00<000000?ooo`3oool04@3oool00180oooo00<00000
0?ooo`3oool0mP3oool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`3e0?oo
o`030000003oool0oooo0180oooo000B0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3o
ool04P3oool00180oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0B0?ooo`004P3o
ool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0180oooo000B0?ooo`030000003oool0
oooo0?D0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0m@3oool00`00
0000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0180
oooo000B0?ooo`030000003oool0oooo0?D0oooo00<000000?ooo`3oool04P3oool00180oooo00<0
00000?ooo`3oool0m@3oool00`000000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`3e
0?ooo`030000003oool0oooo0180oooo000B0?ooo`030000003oool0oooo0?D0oooo00<000000?oo
o`3oool04P3oool00180oooo00<000000?ooo`3oool0m@3oool00`000000oooo0?ooo`0B0?ooo`00
4P3oool00`000000oooo0?ooo`3e0?ooo`030000003oool0oooo0180oooo000B0?ooo`030000003o
ool0oooo0?D0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0lP3oool8
00000100oooo000B0?ooo`030000003oool0oooo0?80oooo2000000@0?ooo`004P3oool00`000000
oooo0?ooo`3b0?ooo`L000004@3oool00180oooo00<000000?ooo`3oool0l`3oool600000140oooo
000B0?ooo`030000003oool0oooo0?<0oooo1P00000A0?ooo`004P3oool00`000000oooo0?ooo`3c
0?ooo`H000004@3oool00180oooo00<000000?ooo`3oool0l`3oool500000180oooo000B0?ooo`03
0000003oool0oooo0?<0oooo1@00000B0?ooo`004P3oool00`000000oooo0?ooo`3d0?ooo`@00000
4P3oool00140oooo0P00003f0?ooo`<000004`3oool00180oooo00<000000?ooo`3oool0m03oool3
000001<0oooo000B0?ooo`<00000m03oool3000001<0oooo000B0?ooo`D00000l`3oool2000001<0
oooo000B0?ooo`030000003oool0000000<00000lP3oool00`000000oooo0?ooo`0B0?ooo`004@3o
ool00`000000oooo0?ooo`0600000>l0oooo0P00000D0?ooo`004@3oool010000000oooo0?ooo`3o
ool700000>d0oooo0P00000D0?ooo`004@3oool010000000oooo0?ooo`3oool900000>X0oooo00<0
00000?ooo`000000503oool00140oooo00<000000?ooo`3oool00P3oool900000>P0oooo00@00000
0?ooo`3oool00000503oool00140oooo00<000000?ooo`3oool00`3oool700000>P0oooo00D00000
0?ooo`3oool0oooo0000000D0?ooo`004@3oool00`000000oooo0?ooo`030?ooo`H00000j03oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0140oooo000@0?ooo`030000003oool0oooo
00D0oooo1@00003W0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04@3oool00100
oooo00<000000?ooo`3oool01@3oool300000080oooo00<000000?ooo`3oool0h`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0140oooo000@0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3Q0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool04@3oool00100oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`3O0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04@3oool00100oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`3M0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool04@3oool00100oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`3K0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool04@3oool00100oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`3I0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool04@3oool000l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`3H0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool000l0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`3F0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403o
ool000l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`3D0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0403oool000l0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`3A0?ooo`8000004@3oool00`000000oooo0?ooo`0@0?ooo`003`3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo0<l0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0@0?ooo`003`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0<d0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?ooo`003P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo0</0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`0@0?ooo`003P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0<T0oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0@0?ooo`003P3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo0<L0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0@0?oo
o`003P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0<D0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0?0?ooo`003P3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo0<<0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0?0?ooo`003P3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0<40oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0?0?ooo`003@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo0;l0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0?0?ooo`003@3oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo0;d0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0?0?ooo`003@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0;/0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0?0?ooo`003@3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo0;T0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0?0?ooo`003@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0;L0oooo00<0
00000?ooo`3oool07P3oool00`000000oooo0?ooo`0?0?ooo`003@3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0?
0?ooo`003@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0;<0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0>0?ooo`00303oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo0;40oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0>0?ooo`00
303oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`0>0?ooo`00303oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo0:d0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0>0?ooo`00303oool0
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0>0?ooo`00303oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
0:T0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0>0?ooo`00303oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool09`3oool00`000000
oooo0?ooo`0>0?ooo`002`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0:D0oooo
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0>0?ooo`002`3oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`0>0?ooo`002`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0:40oooo00<00000
0?ooo`3oool0:`3oool00`000000oooo0?ooo`0=0?ooo`002`3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo09l0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0=0?oo
o`002`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo09d0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`0=0?ooo`002`3oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo09/0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0=0?ooo`002`3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool0;`3o
ool00`000000oooo0?ooo`0=0?ooo`002P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0
oooo09L0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0=0?ooo`002P3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`0=0?ooo`002P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo09@0
oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0=0?ooo`002P3oool00`000000oooo
0?ooo`0g0?ooo`030000003oool0oooo0980oooo00<000000?ooo`3oool0=03oool00`000000oooo
0?ooo`0<0?ooo`002P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo08l0oooo0P00
000g0?ooo`030000003oool0oooo00`0oooo000:0?ooo`030000003oool0oooo03T0oooo00<00000
0?ooo`3oool0S@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00`0oooo00090?oo
o`030000003oool0oooo03/0oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo00`0oooo00090?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3o
ool0R@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo00`0oooo00090?ooo`030000
003oool0oooo03d0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo00`0oooo00090?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0P03o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0303o
ool000T0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`1n0?ooo`<000000P3oool0
0`000000oooo0?ooo`0l0?ooo`030000003oool0oooo00`0oooo00090?ooo`030000003oool0oooo
0400oooo00<000000?ooo`3oool0O@3oool5000003l0oooo00<000000?ooo`3oool0303oool000P0
oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1k0?ooo`H00000@03oool00`000000
oooo0?ooo`0;0?ooo`001@3oool4000004D0oooo00<000000?ooo`3oool0NP3oool7000003l0oooo
00<000000?ooo`3oool02`3oool000D0oooo200000120?ooo`030000003oool0oooo07P0oooo2@00
000n0?ooo`030000003oool0oooo00/0oooo00050?ooo`P00000@`3oool00`000000oooo0?ooo`1g
0?ooo`P00000?`3oool00`000000oooo0?ooo`0;0?ooo`001@3oool7000004D0oooo00<000000?oo
o`3oool0303oool3000006H0oooo1`0000110?ooo`030000003oool0oooo00/0oooo00050?ooo`L0
0000AP3oool00`000000oooo0?ooo`060?ooo`P00000I@3oool6000004<0oooo00<000000?ooo`3o
ool02`3oool000D0oooo1P0000180?ooo`040000003oool0oooo0?ooo``00000I@3oool4000004D0
oooo1@0000090?ooo`001@3oool6000004D0oooo8@00001F0?ooo`@00000@`3oool8000000T0oooo
00050?ooo`D00000?@3oool9000000@0oooo00<000000?ooo`0000003000000>0?ooocT000007@3o
ool2000004D0oooo200000090?ooo`001P3oool4000003D0oooo2000000C0?ooo`T00000A`3ooolP
000004D0oooo1`0000090?ooo`001P3oool4000002`0oooo2@00000N0?ooo`H00000H`3oool01000
0000oooo0?ooo`3oool6000003l0oooo1P00000:0?ooo`001P3oool3000000X0oooo0P00000H0?oo
o`T00000:`3oool2000006d0oooo1`00000h0?ooo`H000002P3oool000H0oooo0`0000070?ooo`D0
0000403oool800000:X0oooo1P00000c0?ooo`D000002P3oool000H0oooo0P0000050?ooo`P00000
1`3oool900000;P0oooo1P00000]0?ooo`D000002P3oool000H0oooo0P0000030?oooa400000a`3o
ool7000002H0oooo1@00000:0?ooo`001P3oool00`000000oooo0000000=00000=@0oooo1P00000E
0?ooo`8000002P3oool4000000X0oooo00060?oooa000000fP3oool7000000h0oooo100000080?oo
o`@000002P3oool000L0oooo00<000000?ooo`3oool03000003Q0?ooo`H00000203oool6000000L0
oooo0`00000:0?ooo`004P3oool400000>L0oooo1P0000020?ooo`T00000103oool2000000/0oooo
003o0?ooo`@0oooo3@0000020?ooo`8000002`3oool00?l0oooo1@3oool@000000/0oooo003o0?oo
o`D0oooo4000000;0?ooo`00o`3oool50?ooo`P000004`3oool00?l0oooo803oool00?l0oooo803o
ool00?l0oooo803oool00?l0oooo803oool00?l0oooo803oool00001\
\>"],
  ImageRangeCache->{{{81, 367.813}, {679.313, 392.375}} -> {-1.64171, \
1.82158, 0.0073178, 0.0073178}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  " and ",
  StyleBox["GraphPlot3D", "MR"],
  " work with disconnected graphs. The individual components are laid out in \
a visually appealing way."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(n = 129;\)\), "\[IndentingNewLine]", 
    \(\(GraphPlot[Table[i \[Rule] Mod[i^2, n], {i, 0, n - 1}]];\)\)}], "Input",\

  CellLabel->"In[4]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .69596 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.138306 0.0233744 -0.178463 0.0233744 [
[ 0 0 0 0 ]
[ 1 .69596 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.13804 .24519 m
.13819 .29302 L
s
.13819 .29302 m
.16704 .34262 L
s
.93561 .64867 m
.91741 .61704 L
s
.91741 .61704 m
.87291 .61694 L
s
.16704 .34262 m
.10967 .34282 L
s
.49536 .55865 m
.46146 .58031 L
s
.46146 .58031 m
.42343 .63905 L
s
.65461 .07385 m
.63124 .07385 L
s
.63124 .07385 m
.65461 .07385 L
s
.63259 .36552 m
.64912 .33689 L
s
.64912 .33689 m
.63259 .30826 L
s
.572 .5393 m
.61391 .56244 L
s
.61391 .56244 m
.67135 .56135 L
s
.87291 .61694 m
.85075 .57838 L
s
.16934 .51654 m
.0989 .5201 L
s
.0989 .5201 m
.06749 .58257 L
s
.61137 .64418 m
.64356 .6116 L
s
.64356 .6116 m
.61391 .56244 L
s
.34973 .25632 m
.36812 .28776 L
s
.36812 .28776 m
.41262 .28752 L
s
.35296 .63797 m
.31977 .57661 L
s
.31977 .57661 m
.3578 .51786 L
s
.03281 .56201 m
.06749 .58257 L
s
.06749 .58257 m
.10728 .64039 L
s
.41262 .28752 m
.43512 .32591 L
s
.10967 .34282 m
.13819 .29302 L
s
.21464 .65405 m
.1777 .63681 L
s
.1777 .63681 m
.20914 .57435 L
s
.85481 .50826 m
.87306 .53986 L
s
.87306 .53986 m
.91757 .53997 L
s
.07323 .65968 m
.10728 .64039 L
s
.10728 .64039 m
.1777 .63681 L
s
.32981 .67506 m
.35296 .63797 L
s
.91297 .31617 m
.89503 .34653 L
s
.89503 .34653 m
.87766 .31578 L
s
.71229 .53662 m
.67135 .56135 L
s
.67135 .56135 m
.64356 .6116 L
s
.31688 .65551 m
.35296 .63797 L
s
.4131 .36455 m
.36859 .3648 L
s
.36859 .3648 m
.34611 .32639 L
s
.42343 .63905 m
.35296 .63797 L
s
.17808 .67635 m
.1777 .63681 L
s
.08879 .10258 m
.12067 .08404 L
s
.12067 .08404 m
.13827 .0535 L
s
.16482 .47755 m
.16934 .51654 L
s
.03546 .60657 m
.06749 .58257 L
s
.97619 .57863 m
.93974 .57855 L
s
.93974 .57855 m
.91741 .61704 L
s
.20914 .57435 m
.16934 .51654 L
s
.67689 .64296 m
.64356 .6116 L
s
.47158 .32568 m
.43512 .32591 L
s
.43512 .32591 m
.4131 .36455 L
s
.46437 .50142 m
.42824 .519 L
s
.42824 .519 m
.46146 .58031 L
s
.5701 .57564 m
.61391 .56244 L
s
.58301 .33689 m
.63259 .30826 L
s
.63259 .30826 m
.64912 .33689 L
s
.49421 .60324 m
.46146 .58031 L
s
.1879 .10239 m
.15595 .084 L
s
.15595 .084 m
.12067 .08404 L
s
.3578 .51786 m
.42824 .519 L
s
.17082 .26096 m
.13819 .29302 L
s
.97484 .13692 m
.94178 .13692 L
s
.35013 .09722 m
.39061 .07385 L
s
.13826 .01657 m
.13827 .0535 L
s
.13827 .0535 m
.15595 .084 L
s
.33674 .47961 m
.3578 .51786 L
s
.20856 .36637 m
.16704 .34262 L
s
.81426 .57837 m
.85075 .57838 L
s
.85075 .57838 m
.87306 .53986 L
s
.68218 .33689 m
.64912 .33689 L
s
.94514 .29804 m
.91297 .31617 L
s
.06198 .50286 m
.0989 .5201 L
s
.87766 .31578 m
.91297 .31617 L
s
.24378 .59496 m
.20914 .57435 L
s
.28703 .55367 m
.31977 .57661 L
s
.06557 .33061 m
.10967 .34282 L
s
.34611 .32639 m
.36812 .28776 L
s
.42029 .67792 m
.42343 .63905 L
s
.11177 .67938 m
.10728 .64039 L
s
.93583 .50838 m
.91757 .53997 L
s
.91757 .53997 m
.93974 .57855 L
s
.71566 .57289 m
.67135 .56135 L
s
.458 .65709 m
.42343 .63905 L
s
.30967 .32663 m
.34611 .32639 L
s
.06833 .36691 m
.10967 .34282 L
s
.18909 .47751 m
.16934 .51654 L
s
.43151 .39599 m
.4131 .36455 L
s
.27612 .57567 m
.31977 .57661 L
s
.24117 .55035 m
.20914 .57435 L
s
.84587 .29697 m
.87766 .31578 L
s
.07482 .48361 m
.0989 .5201 L
s
.4514 .48191 m
.42824 .519 L
s
.61606 .27963 m
.63259 .30826 L
s
.21102 .33009 m
.16704 .34262 L
s
.32324 .49982 m
.3578 .51786 L
s
.39061 .0271 m
.39061 .07385 L
s
.81563 .13692 m
.84868 .13692 L
s
.10534 .26119 m
.13819 .29302 L
s
.36095 .47901 m
.3578 .51786 L
s
.50513 .58123 m
.46146 .58031 L
s
.68218 .27963 m
.63259 .30826 L
s
.67798 .07385 m
.65461 .07385 L
s
.60176 .51833 m
.61391 .56244 L
s
.42751 .47943 m
.42824 .519 L
s
.25281 .57203 m
.20914 .57435 L
s
.20337 .49724 m
.16934 .51654 L
s
.44451 .67729 m
.42343 .63905 L
s
.35057 .39648 m
.36859 .3648 L
s
.3537 .67754 m
.35296 .63797 L
s
.68177 .5168 m
.67135 .56135 L
s
.89472 .38343 m
.89503 .34653 L
s
.0875 .67939 m
.10728 .64039 L
s
.2018 .67329 m
.1777 .63681 L
s
.09854 .38716 m
.10967 .34282 L
s
.43066 .25583 m
.41262 .28752 L
s
.02381 .58493 m
.06749 .58257 L
s
.28585 .59825 m
.31977 .57661 L
s
.64442 .65944 m
.64356 .6116 L
s
.09853 .48057 m
.0989 .5201 L
s
.85464 .64851 m
.87291 .61694 L
s
.66565 .36552 m
.64912 .33689 L
s
.60786 .07385 m
.63124 .07385 L
s
.17853 .38691 m
.16704 .34262 L
s
.4311 .09722 m
.39061 .07385 L
s
.008 w
.76908 .07385 Mdot
.39061 .07385 Mdot
.13804 .24519 Mdot
.13819 .29302 Mdot
.93561 .64867 Mdot
.91741 .61704 Mdot
.16704 .34262 Mdot
.49536 .55865 Mdot
.46146 .58031 Mdot
.65461 .07385 Mdot
.63124 .07385 Mdot
.63259 .36552 Mdot
.64912 .33689 Mdot
.572 .5393 Mdot
.61391 .56244 Mdot
.87291 .61694 Mdot
.16934 .51654 Mdot
.0989 .5201 Mdot
.61137 .64418 Mdot
.64356 .6116 Mdot
.34973 .25632 Mdot
.36812 .28776 Mdot
.35296 .63797 Mdot
.31977 .57661 Mdot
.03281 .56201 Mdot
.06749 .58257 Mdot
.41262 .28752 Mdot
.10967 .34282 Mdot
.21464 .65405 Mdot
.1777 .63681 Mdot
.85481 .50826 Mdot
.87306 .53986 Mdot
.07323 .65968 Mdot
.10728 .64039 Mdot
.32981 .67506 Mdot
.91297 .31617 Mdot
.89503 .34653 Mdot
.71229 .53662 Mdot
.67135 .56135 Mdot
.31688 .65551 Mdot
.4131 .36455 Mdot
.36859 .3648 Mdot
.42343 .63905 Mdot
.17808 .67635 Mdot
.08879 .10258 Mdot
.12067 .08404 Mdot
.16482 .47755 Mdot
.03546 .60657 Mdot
.97619 .57863 Mdot
.93974 .57855 Mdot
.20914 .57435 Mdot
.67689 .64296 Mdot
.47158 .32568 Mdot
.43512 .32591 Mdot
.46437 .50142 Mdot
.42824 .519 Mdot
.5701 .57564 Mdot
.58301 .33689 Mdot
.63259 .30826 Mdot
.49421 .60324 Mdot
.1879 .10239 Mdot
.15595 .084 Mdot
.3578 .51786 Mdot
.17082 .26096 Mdot
.97484 .13692 Mdot
.94178 .13692 Mdot
.84868 .13692 Mdot
.35013 .09722 Mdot
.13826 .01657 Mdot
.13827 .0535 Mdot
.33674 .47961 Mdot
.20856 .36637 Mdot
.81426 .57837 Mdot
.85075 .57838 Mdot
.68218 .33689 Mdot
.94514 .29804 Mdot
.06198 .50286 Mdot
.87766 .31578 Mdot
.24378 .59496 Mdot
.28703 .55367 Mdot
.06557 .33061 Mdot
.34611 .32639 Mdot
.42029 .67792 Mdot
.11177 .67938 Mdot
.93583 .50838 Mdot
.91757 .53997 Mdot
.71566 .57289 Mdot
.458 .65709 Mdot
.30967 .32663 Mdot
.06833 .36691 Mdot
.18909 .47751 Mdot
.43151 .39599 Mdot
.27612 .57567 Mdot
.24117 .55035 Mdot
.84587 .29697 Mdot
.07482 .48361 Mdot
.4514 .48191 Mdot
.61606 .27963 Mdot
.21102 .33009 Mdot
.32324 .49982 Mdot
.39061 .0271 Mdot
.81563 .13692 Mdot
.10534 .26119 Mdot
.36095 .47901 Mdot
.50513 .58123 Mdot
.68218 .27963 Mdot
.67798 .07385 Mdot
.60176 .51833 Mdot
.42751 .47943 Mdot
.25281 .57203 Mdot
.20337 .49724 Mdot
.44451 .67729 Mdot
.35057 .39648 Mdot
.3537 .67754 Mdot
.68177 .5168 Mdot
.89472 .38343 Mdot
.0875 .67939 Mdot
.2018 .67329 Mdot
.09854 .38716 Mdot
.43066 .25583 Mdot
.02381 .58493 Mdot
.28585 .59825 Mdot
.64442 .65944 Mdot
.09853 .48057 Mdot
.85464 .64851 Mdot
.66565 .36552 Mdot
.60786 .07385 Mdot
.17853 .38691 Mdot
.4311 .09722 Mdot
0 0 m
1 0 L
1 .69596 L
0 .69596 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{288, 200.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000b2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`009`3oool200000?L0oooo000W
0?ooo`800000m`3oool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<000000?ooo`3o
ool0mP3oool002L0oooo00<000000?ooo`3oool0A@3oool200000:l0oooo000W0?ooo`030000003o
ool0oooo04H0oooo00<000000?ooo`3oool0[@3oool002L0oooo00<000000?ooo`3oool0AP3oool0
0`000000oooo0?ooo`2]0?ooo`009`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo
0:d0oooo000W0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0[@3oool002L0oooo
00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`2]0?ooo`009`3oool00`000000oooo0?oo
o`160?ooo`030000003oool0oooo0:d0oooo000W0?ooo`800000A`3oool00`000000oooo0?ooo`2]
0?ooo`009P3oool00`000000oooo000000170?ooo`030000003oool0oooo0:d0oooo000V0?ooo`03
0000003oool0000004L0oooo00<000000?ooo`3oool0[@3oool002D0oooo00D000000?ooo`3oool0
oooo000000160?ooo`030000003oool0oooo0:d0oooo000U0?ooo`050000003oool0oooo0?ooo`00
0000AP3oool00`000000oooo0?ooo`2]0?ooo`00903oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo04<0oooo00<000000?ooo`3oool0[@3oool002@0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`120?ooo`800000?03ooolF000001P0oooo0P0000130?ooo`008`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0400oooo1@00000k0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0@@3oool002<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0n0?ooo`8000001@3oool00`000000oooo0?ooo`2Z0?ooo`008P3oool<000003`0
oooo0P0000080?ooo`800000ZP3oool00200oooo0P0000000`3oool000000?ooo`080?ooo`800000
>P3oool00`000000oooo0?ooo`0:0?ooo`800000Z03oool001l0oooo00<000000?ooo`3oool03@3o
ool2000003H0oooo0P00000?0?ooo`030000003oool0oooo0:D0oooo000M0?ooo`8000004P3oool2
00000380oooo0P00000B0?ooo`800000Y@3oool001`0oooo00<000000?ooo`3oool0503oool20000
02h0oooo0P00000F0?ooo`800000X`3oool001T0oooo0`00000I0?ooo`800000;@3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo0:40oooo000I0?ooo`8000006`3oool00`000000oooo
0?ooo`3W0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00j@3oool;000001T0
oooo2`0000080?ooo`00jP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`009`3oool200000?L0oooo000W0?ooo`800000m`3o
ool002L0oooo00<000000?ooo`3oool0mP3oool002L0oooo00<000000?ooo`3oool0>@3oool20000
01H0oooo0P00002S0?ooo`009`3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`000000X`3oool001d0oooo0P0000080?ooo`030000003oool0oooo00H0oooo
0P00000c0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0X`3oool001h0oooo0P00
00070?ooo`030000003oool0oooo00H0oooo0P00000c0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0Y03oool00200oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`2T
0?ooo`008@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0=@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0:D0oooo000R0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool2000003T0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`2U0?ooo`008`3oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03H0
oooo0P00000A0?ooo`800000F`3oool002@0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`0k0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0=`3oool00`000000
oooo0?ooo`0=0?ooo`80000000<0oooo0000003oool0FP3oool002D0oooo00D000000?ooo`000000
oooo0000000n0?ooo`<000001@3oool7000003X0oooo00<000000?ooo`3oool02`3oool2000005l0
oooo000V0?ooo`<00000@03oool7000000H0oooo0P00000j0?ooo`030000003oool0oooo00P0oooo
0P00001Q0?ooo`009`3oool2000003l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0h0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0H@3oool002H0oooo00<00000
0?ooo`000000?`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03P0oooo00<00000
0?ooo`3oool0103oool2000003D0oooo0P00000K0?ooo`800000403oool002H0oooo00<000000?oo
o`000000?P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03T0oooo00@000000?oo
o`3oool0oooo0P00000h0?ooo`<000006@3oool200000100oooo000U0?ooo`050000003oool0oooo
0?ooo`000000?@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03P0oooo00@00000
0?ooo`0000000000?@3oool00`000000oooo0?ooo`0D0?ooo`8000004P3oool002D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0>03oool200000400oooo0P00000B0?ooo`800000503oool002@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0=P3oool400000440oooo00<000000?ooo`3oool03@3oool2000001H0oooo000T0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo03D0oooo00D000000?ooo`3oool0oooo000000120?ooo`@00000203oool30000
01P0oooo000S0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0=`3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo0380oooo0P0000050?ooo`030000003oool0oooo0440
oooo3000000I0?ooo`008P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0`0?ooo`8000001`3oool00`000000oooo
0?ooo`120?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool06@3oool00280oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0X0?ooo`800000203oool3000001L0oooo3000
000U0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo01T0oooo000B0?ooo`8000003@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00`0oooo0P00000J0?ooo``00000603oool2000000T0oooo00<00000
0?ooo`3oool08@3oool2000000/0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo01X0oooo000C0?ooo`800000303oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00T0oooo1000000V0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool0;03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0440oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0J0?ooo`005@3oool4000000L0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`040?ooo`@00000:P3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo02P0oooo1000000?0?ooo`800000203oool2000003T0oooo00D000000?ooo`3o
ool0oooo0000000M0?ooo`006@3oool4000000<0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`04000002l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0Z0?ooo`03
0000003oool0oooo0100oooo2`00000j0?ooo`030000003oool0000001h0oooo000M0?oooaD00000
<`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03`0oooo0P0000140?ooo`030000
003oool0000001h0oooo000M0?ooo`@000003`3oool3000003<0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0m0?ooo`030000003oool0000004@0oooo0P00000N0?ooo`006`3oool2
00000080oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0200000340oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0l0?ooo`040000003oool0oooo000004@0oooo0P00
000N0?ooo`006@3oool2000000<0oooo00<000000?ooo`3oool0403oool01@000000oooo0?ooo`3o
ool000000340oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0m0?ooo`050000003o
ool0oooo0?ooo`000000@`3oool00`000000oooo0?ooo`0M0?ooo`00603oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3oool2000002l0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0@@3oool00`000000oooo0?ooo`0M0?ooo`005P3oool2000000H0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`040?ooo`800000;P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`10
0?ooo`030000003oool0oooo01d0oooo000D0?ooo`800000203oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00H0oooo0P00000/0?ooo`<000002P3oool3000003`0oooo0`0000060?oo
o`<00000@03oool00`000000oooo0?ooo`0M0?ooo`004`3oool2000000P0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`060?ooo`800000;03oool>000003h0oooo00<000000?ooo`3o
ool01P3oool200000400oooo00<000000?ooo`3oool07@3oool001@0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
:@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0
7@3oool001d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0c0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`0M0?ooo`007@3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`250?ooo`030000003oool0oooo01d0oooo000L0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
08D0oooo00<000000?ooo`3oool07@3oool001`0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0P`3oool2000001l0
oooo000K0?ooo`8000005@3oool200000380oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`240?ooo`030000003oool0oooo01d0oooo000L0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool0;`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0:<0oooo001T
0?ooo`800000503oool300000:<0oooo001T0?ooo`8000005@3oool200000:<0oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo000K0?ooo`8000004@3oool2000000D0oooo0P00000Y0?ooo`8000001@3o
ool200000140oooo0P00002T0?ooo`005@3oool2000000D0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`030?ooo`800000:@3oool2000000D0oooo0P00000A0?ooo`800000103oool2
000009h0oooo000E0?ooo`8000001@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool00`3oool2000009h0oooo000F0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0W@3oool001H0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`2N0?ooo`005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo00D0
00000?ooo`3oool0oooo000000050?ooo`8000009`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0100oooo00D000000?ooo`3oool0oooo0000002Q0?ooo`00603oool01@000000oooo
0?ooo`3oool0000001<0oooo00@000000?ooo`3oool000001@3oool200000240oooo0P0000050?oo
o`040000003oool0oooo000001<0oooo00D000000?ooo`3oool0oooo000000050?ooo`800000VP3o
ool00140oooo0P0000050?ooo`050000003oool0oooo0?ooo`0000004`3oool00`000000oooo0000
00040?ooo`800000903oool2000000D0oooo00<000000?ooo`0000004`3oool010000000oooo0?oo
o`0000060?ooo`800000VP3oool00180oooo0`0000040?ooo`040000003oool0oooo000001<0oooo
00<000000?ooo`0000000P3oool2000002P0oooo0P0000030?ooo`030000003oool0000001<0oooo
00@000000?ooo`3oool00000103oool200000700oooo0P00000E0?ooo`8000004`3oool001D0oooo
0P0000030?ooo`030000003oool0000001<0oooo0P0000000`3oool000000000000/0?ooo`800000
0P3oool2000001<0oooo00<000000?ooo`0000000`3oool2000007<0oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0A0?ooo`005`3oool200000080oooo0P00000C0?ooo`<00000<03o
ool4000001<0oooo0P0000020?ooo`800000MP3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo0180oooo000I0?ooo`@000002@3oool<000003<0oooo2`00000:0?ooo`@00000;P3oool2
000001@0oooo0P00000b0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool04P3oool0
01/0oooo2`00000;0?ooo`030000003oool0oooo0340oooo00<000000?ooo`000000203oool<0000
0300oooo0P00000E0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0C0?ooo`00703oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0340
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0
oooo000K0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0;`3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0c0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0503oool001/0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0;P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`006P3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01P3oool2000002`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0E0?ooo`006P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0S0?oo
o`8000002@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0:P3oool2000000/0oooo0`00000G0?ooo`006@3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`060?ooo`80
0000;P3oool>000001P0oooo000I0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo02@0oooo0P0000070?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0103oool2000002l0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0E0?ooo`00603oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo00/0oooo0P00000J0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool09@3o
ool2000000H0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`800000<@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01D0oooo000H0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`8000003@3oool0
0`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02L0oooo0P0000040?ooo`030000003oool0
oooo00l0oooo00D000000?ooo`3oool0oooo0000000b0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0503oool001L0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo02P0oooo0P0000020?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool00P00000b0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool0
01L0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`070?ooo`8000003`3oool20000
00T0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0:0?ooo`8000007P3oool20000
00030?ooo`000000oooo00h0oooo0`00000d0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool04`3oool000T0oooo0P00000;0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`080?ooo`<00000803ooolD000003<0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0C0?ooo`002P3oool2000000X0oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo0P0000050?ooo`030000
003oool0oooo0280oooo00<000000?ooo`3oool01@3oool200000200oooo0`0000000`3oool00000
0000000=0?ooo`8000000P3oool4000002l0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0B0?ooo`00303oool2000000L0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?oo
o`02000001P0oooo00D000000?ooo`3oool0oooo0000000U0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0703oool4000000D0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`050?ooo`@00000:P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo
000>0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08`3oool3000000@0oooo2000
000?0?ooo`80000000<0oooo0000003oool09@3oool010000000oooo0?ooo`3oool2000001`0oooo
0`00000:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool3000002H0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0A0?ooo`003`3oool2000000<0oooo00<0
00000?ooo`3oool09@3oool6000000L0oooo00<000000?ooo`3oool00P3oool?000002H0oooo00@0
00000?ooo`00000000006`3oool3000000d0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo01P0oooo0P0000090?ooo`8000005`3oool200000180oooo
000A0?ooo`80000000<0oooo0000003oool09P3oool300000100oooo00<000000?ooo`3oool0203o
ool00`000000oooo0000000V0?ooo`L000001P3oool200000140oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02T0oooo3000000H0?ooo``000001`3o
ool000H0oooo0P0000050?ooo`L000009`3oool010000000oooo0?ooo`3oool2000001L0oooo0P00
00020?ooo`030000003oool0oooo02@0oooo0`0000040?ooo`P000008@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00D0oooo00070?ooo`H000001@3oool3000002H0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool08`3oool00`000000oooo0?ooo`02000002`0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0e0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool04@3oool0
0100oooo0P0000020?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01@3oool20000
0180oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool01`3oool3000000d0
oooo0P0000080?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo0180oooo000>0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo
0`00000:0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01P3oool2000002X0oooo
00D000000?ooo`3oool0oooo0000000k0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool04`3oool000`0oooo0P0000080?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0W0?ooo`050000003oool0oooo0?ooo`000000?03oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo000;0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool02`3oool2000002P0oooo00<000000?ooo`000000?@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00090?ooo`8000003@3oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`000000?P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo01@0oooo000:0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool0=`3oool2000003l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0E
0?ooo`006@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02L0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`0f0?ooo`<00000?`3oool2000000d0oooo00<000000?oo
o`3oool05@3oool001T0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0=P3oool01@000000oooo0000003oool00000
03l0oooo3P00000H0?ooo`006P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0f0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0;0?ooo`8000005`3oool001/0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0=@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01D0oooo000K0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo03H0oooo00D000000?ooo`3oool0oooo000000040?ooo`800000>@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo01@0oooo000L0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03H0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`007@3oool00`000000oooo
0?ooo`0B0?ooo`<00000;`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03@0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`007@3oool3000000T0oooo3000
000_0?oooaH00000=`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0<`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo000N
0?ooo`/000002P3oool4000002/0oooo1000000C0?ooo`<00000<P3oool3000000L0oooo00<00000
0?ooo`3oool01P3oool2000003<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0B
0?ooo`00703oool3000001@0oooo0P0000020?ooo`<000009P3oool200000080oooo0P00000C0?oo
o`80000000<0oooo000000000000<@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
0180oooo000J0?ooo`80000000<0oooo000000000000503oool00`000000oooo000000040?ooo`80
00008P3oool2000000<0oooo00<000000?ooo`0000004`3oool00`000000oooo000000020?ooo`80
0000>03oool00`000000oooo0?ooo`0i0?ooo`8000005@3oool2000001<0oooo000H0?ooo`800000
0`3oool00`000000oooo0000000C0?ooo`040000003oool0oooo000000D0oooo0`00000M0?ooo`80
0000103oool010000000oooo0?ooo`00000C0?ooo`030000003oool0000000@0oooo0P00000f0?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0A0?oo
o`005P3oool2000000@0oooo00@000000?ooo`3oool000004`3oool010000000oooo0?ooo`000007
0?ooo`030000003oool0oooo01T0oooo0P0000060?ooo`040000003oool0oooo000001<0oooo00@0
00000?ooo`3oool000001@3oool2000003@0oooo00<000000?ooo`3oool0I@3oool001@0oooo0P00
00060?ooo`040000003oool0oooo000001<0oooo00D000000?ooo`3oool0oooo0000000S0?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000B0?ooo`050000003oool0oooo
0?ooo`0000001P3oool00`000000oooo0?ooo`0b0?ooo`800000IP3oool001D0oooo00<000000?oo
o`3oool00`3oool01@000000oooo0?ooo`3oool0000001<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0V0?ooo`050000003oool0oooo0?ooo`0000004P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0I03oool001/0oooo00D00000
0?ooo`3oool0oooo0000000C0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`2P0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo09l0oooo000J0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`030?ooo`8000008`3oool2000000D0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo09l0oooo000H0?ooo`8000001@3oool200000140
oooo0P0000060?ooo`030000003oool0oooo0240oooo0P0000040?ooo`8000004P3oool2000000@0
oooo0P00002P0?ooo`006@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0WP3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {332.188, 132.813}} -> {-18.0527, 27.4691, \
0.149339, 0.149339}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  " and ",
  StyleBox["GraphPlot3D", "MR"],
  " are designed to work with very large graphs. This plots a graph defined \
by a matrix from a structural engineering application. An image of the actual \
application can be seen at the following URL:\n",
  ButtonBox["http://math.nist.gov/MatrixMarket/data/Harwell-Boeing/dwt/dwt_\
1005.html",
    ButtonData:>{
      URL[ 
      "http://math.nist.gov/MatrixMarket/data/Harwell-Boeing/dwt/dwt_1005.\
html"], None},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[BoxData[
    \(\(a = 
        Import["\<LinearAlgebraExamples/Data/dwt_1005.psa\>", \
"\<HarwellBoeing\>"];\)\)], "Input",
  CellLabel->"In[6]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot3D[a];\)\)], "Input",
  CellLabel->"In[7]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .7122 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.1684e-19 1.04899 -0.117176 1.04899 [
[ 0 0 0 0 ]
[ 1 .7122 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0191 .25742 m
0 .37802 L
s
0 .37802 m
.39745 .7122 L
s
.39745 .7122 m
.40125 .60303 L
s
.40125 .60303 m
.0191 .25742 L
s
.69423 0 m
.98425 .433 L
s
.98425 .433 m
1 .54835 L
s
1 .54835 m
.70153 .12619 L
s
.70153 .12619 m
.69423 0 L
s
.0191 .25742 m
0 .37802 L
s
0 .37802 m
.70153 .12619 L
s
.70153 .12619 m
.69423 0 L
s
.69423 0 m
.0191 .25742 L
s
.40125 .60303 m
.98425 .433 L
s
.98425 .433 m
1 .54835 L
s
1 .54835 m
.39745 .7122 L
s
.39745 .7122 m
.40125 .60303 L
s
0 0 m
1 0 L
1 .7122 L
0 .7122 L
closepath
clip
newpath
.01 w
.45901 .6663 Mdot
.5 Mabswid
.45901 .6663 m
.46339 .66703 L
s
.45901 .6663 m
.45585 .66653 L
s
.45901 .6663 m
.46015 .6697 L
s
.46089 .66115 m
.45901 .6663 L
s
.46014 .65511 m
.45901 .6663 L
s
.01 w
.46014 .65511 Mdot
.5 Mabswid
.46014 .65511 m
.46089 .66115 L
s
.4624 .64848 m
.46014 .65511 L
s
.46204 .64168 m
.46014 .65511 L
s
.01 w
.46339 .66703 Mdot
.5 Mabswid
.46339 .66703 m
.46652 .65984 L
s
.46089 .66115 m
.46339 .66703 L
s
.01 w
.45585 .66653 Mdot
.5 Mabswid
.45585 .66653 m
.4579 .65918 L
s
.46089 .66115 m
.45585 .66653 L
s
.01 w
.46204 .64168 Mdot
.5 Mabswid
.46204 .64168 m
.4624 .64848 L
s
.46432 .63483 m
.46204 .64168 L
s
.46456 .62742 m
.46204 .64168 L
s
.01 w
.46015 .6697 Mdot
.5 Mabswid
.46015 .6697 m
.46235 .66707 L
s
.46186 .66399 m
.46015 .6697 L
s
.46089 .66115 m
.46015 .6697 L
s
.01 w
.46089 .66115 Mdot
.5 Mabswid
.46089 .66115 m
.46652 .65984 L
s
.46089 .66115 m
.4579 .65918 L
s
.46089 .66115 m
.46186 .66399 L
s
.46377 .65346 m
.46089 .66115 L
s
.4624 .64848 m
.46089 .66115 L
s
.01 w
.4624 .64848 Mdot
.5 Mabswid
.4624 .64848 m
.46377 .65346 L
s
.46544 .63987 m
.4624 .64848 L
s
.46432 .63483 m
.4624 .64848 L
s
.01 w
.46456 .62742 Mdot
.5 Mabswid
.46456 .62742 m
.46432 .63483 L
s
.46654 .6217 m
.46456 .62742 L
s
.46818 .61267 m
.46456 .62742 L
s
.01 w
.46432 .63483 Mdot
.5 Mabswid
.46432 .63483 m
.46544 .63987 L
s
.46758 .62468 m
.46432 .63483 L
s
.46654 .6217 m
.46432 .63483 L
s
.01 w
.46652 .65984 Mdot
.5 Mabswid
.46652 .65984 m
.47195 .65033 L
s
.46377 .65346 m
.46652 .65984 L
s
.01 w
.46186 .66399 Mdot
.5 Mabswid
.46186 .66399 m
.46235 .66707 L
s
.46441 .6575 m
.46186 .66399 L
s
.46377 .65346 m
.46186 .66399 L
s
.01 w
.4579 .65918 Mdot
.5 Mabswid
.4579 .65918 m
.45971 .64936 L
s
.46377 .65346 m
.4579 .65918 L
s
.01 w
.46654 .6217 Mdot
.5 Mabswid
.46654 .6217 m
.46758 .62468 L
s
.47019 .60926 m
.46654 .6217 L
s
.46818 .61267 m
.46654 .6217 L
s
.01 w
.46235 .66707 Mdot
.5 Mabswid
.46495 .66074 m
.46235 .66707 L
s
.46441 .6575 m
.46235 .66707 L
s
.01 w
.46377 .65346 Mdot
.5 Mabswid
.46377 .65346 m
.47195 .65033 L
s
.46377 .65346 m
.45971 .64936 L
s
.46377 .65346 m
.46441 .6575 L
s
.4674 .64362 m
.46377 .65346 L
s
.46544 .63987 m
.46377 .65346 L
s
.01 w
.46544 .63987 Mdot
.5 Mabswid
.46544 .63987 m
.4674 .64362 L
s
.46892 .62912 m
.46544 .63987 L
s
.46758 .62468 m
.46544 .63987 L
s
.01 w
.46818 .61267 Mdot
.5 Mabswid
.46818 .61267 m
.47019 .60926 L
s
.47292 .596 m
.46818 .61267 L
s
.01 w
.46758 .62468 Mdot
.5 Mabswid
.46758 .62468 m
.46892 .62912 L
s
.47149 .61187 m
.46758 .62468 L
s
.47019 .60926 m
.46758 .62468 L
s
.01 w
.46441 .6575 Mdot
.5 Mabswid
.46441 .6575 m
.46495 .66074 L
s
.46745 .64929 m
.46441 .6575 L
s
.4674 .64362 m
.46441 .6575 L
s
.01 w
.47195 .65033 Mdot
.5 Mabswid
.47195 .65033 m
.48162 .63816 L
s
.4674 .64362 m
.47195 .65033 L
s
.01 w
.45971 .64936 Mdot
.5 Mabswid
.45971 .64936 m
.4593 .63629 L
s
.4674 .64362 m
.45971 .64936 L
s
.01 w
.47019 .60926 Mdot
.5 Mabswid
.47019 .60926 m
.47149 .61187 L
s
.475 .59314 m
.47019 .60926 L
s
.47292 .596 m
.47019 .60926 L
s
.01 w
.46495 .66074 Mdot
.5 Mabswid
.46784 .65362 m
.46495 .66074 L
s
.46745 .64929 m
.46495 .66074 L
s
.01 w
.4674 .64362 Mdot
.5 Mabswid
.4674 .64362 m
.48162 .63816 L
s
.4674 .64362 m
.4593 .63629 L
s
.4674 .64362 m
.46745 .64929 L
s
.4712 .63219 m
.4674 .64362 L
s
.46892 .62912 m
.4674 .64362 L
s
.01 w
.46892 .62912 Mdot
.5 Mabswid
.46892 .62912 m
.4712 .63219 L
s
.47228 .61757 m
.46892 .62912 L
s
.47149 .61187 m
.46892 .62912 L
s
.01 w
.47292 .596 Mdot
.5 Mabswid
.47292 .596 m
.475 .59314 L
s
.47886 .5749 m
.47292 .596 L
s
.01 w
.46745 .64929 Mdot
.5 Mabswid
.46745 .64929 m
.46784 .65362 L
s
.47029 .64243 m
.46745 .64929 L
s
.4712 .63219 m
.46745 .64929 L
s
.01 w
.47149 .61187 Mdot
.5 Mabswid
.47149 .61187 m
.47228 .61757 L
s
.47567 .59927 m
.47149 .61187 L
s
.475 .59314 m
.47149 .61187 L
s
.01 w
.46784 .65362 Mdot
.5 Mabswid
.47094 .64559 m
.46784 .65362 L
s
.47029 .64243 m
.46784 .65362 L
s
.01 w
.47228 .61757 Mdot
.5 Mabswid
.47228 .61757 m
.4712 .63219 L
s
.47528 .61289 m
.47228 .61757 L
s
.47567 .59927 m
.47228 .61757 L
s
.01 w
.475 .59314 Mdot
.5 Mabswid
.475 .59314 m
.47567 .59927 L
s
.48066 .57444 m
.475 .59314 L
s
.47886 .5749 m
.475 .59314 L
s
.01 w
.48162 .63816 Mdot
.5 Mabswid
.48162 .63816 m
.48593 .6278 L
s
.48162 .63816 m
.50054 .62736 L
s
.4712 .63219 m
.48162 .63816 L
s
.01 w
.4712 .63219 Mdot
.5 Mabswid
.4712 .63219 m
.48593 .6278 L
s
.4712 .63219 m
.46246 .62583 L
s
.4712 .63219 m
.4593 .63629 L
s
.4712 .63219 m
.47029 .64243 L
s
.47334 .62872 m
.4712 .63219 L
s
.47528 .61289 m
.4712 .63219 L
s
.01 w
.4593 .63629 Mdot
.5 Mabswid
.4593 .63629 m
.46246 .62583 L
s
.4593 .63629 m
.44971 .62313 L
s
.01 w
.47029 .64243 Mdot
.5 Mabswid
.47029 .64243 m
.47094 .64559 L
s
.47348 .63429 m
.47029 .64243 L
s
.47334 .62872 m
.47029 .64243 L
s
.01 w
.47567 .59927 Mdot
.5 Mabswid
.47567 .59927 m
.47528 .61289 L
s
.4792 .59094 m
.47567 .59927 L
s
.48066 .57444 m
.47567 .59927 L
s
.01 w
.47886 .5749 Mdot
.5 Mabswid
.47886 .5749 m
.48066 .57444 L
s
.48633 .5467 m
.47886 .5749 L
s
.01 w
.47094 .64559 Mdot
.5 Mabswid
.47423 .63642 m
.47094 .64559 L
s
.47348 .63429 m
.47094 .64559 L
s
.01 w
.47334 .62872 Mdot
.5 Mabswid
.47334 .62872 m
.48593 .6278 L
s
.47334 .62872 m
.46246 .62583 L
s
.47334 .62872 m
.47348 .63429 L
s
.47669 .61897 m
.47334 .62872 L
s
.47528 .61289 m
.47334 .62872 L
s
.01 w
.47528 .61289 Mdot
.5 Mabswid
.47528 .61289 m
.47669 .61897 L
s
.47942 .60165 m
.47528 .61289 L
s
.4792 .59094 m
.47528 .61289 L
s
.01 w
.48593 .6278 Mdot
.5 Mabswid
.48593 .6278 m
.50306 .61636 L
s
.50054 .62736 m
.48593 .6278 L
s
.47669 .61897 m
.48593 .6278 L
s
.01 w
.47348 .63429 Mdot
.5 Mabswid
.47348 .63429 m
.47423 .63642 L
s
.477 .62425 m
.47348 .63429 L
s
.47669 .61897 m
.47348 .63429 L
s
.01 w
.46246 .62583 Mdot
.5 Mabswid
.46246 .62583 m
.4544 .61227 L
s
.44971 .62313 m
.46246 .62583 L
s
.47669 .61897 m
.46246 .62583 L
s
.01 w
.50054 .62736 Mdot
.5 Mabswid
.50054 .62736 m
.50306 .61636 L
s
.50054 .62736 m
.52386 .61764 L
s
.01 w
.48066 .57444 Mdot
.5 Mabswid
.48066 .57444 m
.4792 .59094 L
s
.48363 .56973 m
.48066 .57444 L
s
.48633 .5467 m
.48066 .57444 L
s
.48621 .55258 m
.48066 .57444 L
s
.01 w
.4792 .59094 Mdot
.5 Mabswid
.4792 .59094 m
.47942 .60165 L
s
.4825 .58434 m
.4792 .59094 L
s
.48363 .56973 m
.4792 .59094 L
s
.01 w
.47423 .63642 Mdot
.5 Mabswid
.47756 .62673 m
.47423 .63642 L
s
.477 .62425 m
.47423 .63642 L
s
.01 w
.44971 .62313 Mdot
.5 Mabswid
.44971 .62313 m
.4544 .61227 L
s
.44971 .62313 m
.43459 .61021 L
s
.01 w
.47669 .61897 Mdot
.5 Mabswid
.47669 .61897 m
.50306 .61636 L
s
.47669 .61897 m
.4544 .61227 L
s
.47669 .61897 m
.477 .62425 L
s
.48095 .60665 m
.47669 .61897 L
s
.47942 .60165 m
.47669 .61897 L
s
.01 w
.47942 .60165 Mdot
.5 Mabswid
.47942 .60165 m
.48095 .60665 L
s
.48376 .58945 m
.47942 .60165 L
s
.4825 .58434 m
.47942 .60165 L
s
.01 w
.477 .62425 Mdot
.5 Mabswid
.477 .62425 m
.47756 .62673 L
s
.48036 .61562 m
.477 .62425 L
s
.48095 .60665 m
.477 .62425 L
s
.01 w
.48633 .5467 Mdot
.5 Mabswid
.48621 .55258 m
.48633 .5467 L
s
.49419 .51271 m
.48633 .5467 L
s
.49241 .52541 m
.48633 .5467 L
s
.01 w
.50306 .61636 Mdot
.5 Mabswid
.52386 .61764 m
.50306 .61636 L
s
.48095 .60665 m
.50306 .61636 L
s
.53475 .60628 m
.50306 .61636 L
s
.51514 .60642 m
.50306 .61636 L
s
.01 w
.48363 .56973 Mdot
.5 Mabswid
.48363 .56973 m
.4825 .58434 L
s
.48557 .56863 m
.48363 .56973 L
s
.48621 .55258 m
.48363 .56973 L
s
.4888 .54892 m
.48363 .56973 L
s
.01 w
.52386 .61764 Mdot
.5 Mabswid
.52386 .61764 m
.5518 .61084 L
s
.53475 .60628 m
.52386 .61764 L
s
.01 w
.48621 .55258 Mdot
.5 Mabswid
.4888 .54892 m
.48621 .55258 L
s
.49241 .52541 m
.48621 .55258 L
s
.01 w
.47756 .62673 Mdot
.5 Mabswid
.48078 .61517 m
.47756 .62673 L
s
.48036 .61562 m
.47756 .62673 L
s
.01 w
.4825 .58434 Mdot
.5 Mabswid
.4825 .58434 m
.48376 .58945 L
s
.48588 .57815 m
.4825 .58434 L
s
.48557 .56863 m
.4825 .58434 L
s
.01 w
.4544 .61227 Mdot
.5 Mabswid
.43459 .61021 m
.4544 .61227 L
s
.48095 .60665 m
.4544 .61227 L
s
.44903 .60083 m
.4544 .61227 L
s
.43085 .59757 m
.4544 .61227 L
s
.01 w
.48095 .60665 Mdot
.5 Mabswid
.48095 .60665 m
.48036 .61562 L
s
.48376 .58945 m
.48095 .60665 L
s
.50898 .61198 m
.48095 .60665 L
s
.51514 .60642 m
.48095 .60665 L
s
.5099 .59382 m
.48095 .60665 L
s
.45423 .60745 m
.48095 .60665 L
s
.44903 .60083 m
.48095 .60665 L
s
.45829 .58938 m
.48095 .60665 L
s
.01 w
.43459 .61021 Mdot
.5 Mabswid
.43459 .61021 m
.41293 .59927 L
s
.43085 .59757 m
.43459 .61021 L
s
.01 w
.48557 .56863 Mdot
.5 Mabswid
.48557 .56863 m
.48588 .57815 L
s
.48847 .56289 m
.48557 .56863 L
s
.4888 .54892 m
.48557 .56863 L
s
.01 w
.51514 .60642 Mdot
.5 Mabswid
.51514 .60642 m
.53828 .60987 L
s
.51514 .60642 m
.53475 .60628 L
s
.51514 .60642 m
.53728 .59412 L
s
.51514 .60642 m
.50898 .61198 L
s
.5099 .59382 m
.51514 .60642 L
s
.01 w
.48036 .61562 Mdot
.5 Mabswid
.48036 .61562 m
.48078 .61517 L
s
.50942 .61537 m
.48036 .61562 L
s
.50898 .61198 m
.48036 .61562 L
s
.45339 .61078 m
.48036 .61562 L
s
.45423 .60745 m
.48036 .61562 L
s
.01 w
.5518 .61084 Mdot
.5 Mabswid
.5518 .61084 m
.58044 .60555 L
s
.56447 .60211 m
.5518 .61084 L
s
.53475 .60628 m
.5518 .61084 L
s
.01 w
.50898 .61198 Mdot
.5 Mabswid
.50898 .61198 m
.48078 .61517 L
s
.50898 .61198 m
.53771 .61301 L
s
.50898 .61198 m
.53828 .60987 L
s
.50898 .61198 m
.53475 .60628 L
s
.50898 .61198 m
.50942 .61537 L
s
.01 w
.53475 .60628 Mdot
.5 Mabswid
.53475 .60628 m
.56504 .60677 L
s
.53475 .60628 m
.56447 .60211 L
s
.53475 .60628 m
.56298 .59349 L
s
.53475 .60628 m
.53828 .60987 L
s
.53728 .59412 m
.53475 .60628 L
s
.5099 .59382 m
.53475 .60628 L
s
.01 w
.48078 .61517 Mdot
.5 Mabswid
.50942 .61537 m
.48078 .61517 L
s
.45339 .61078 m
.48078 .61517 L
s
.45423 .60745 m
.48078 .61517 L
s
.01 w
.50942 .61537 Mdot
.5 Mabswid
.50942 .61537 m
.53771 .61301 L
s
.50942 .61537 m
.53828 .60987 L
s
.01 w
.48376 .58945 Mdot
.5 Mabswid
.48588 .57815 m
.48376 .58945 L
s
.5099 .59382 m
.48376 .58945 L
s
.51102 .58027 m
.48376 .58945 L
s
.45829 .58938 m
.48376 .58945 L
s
.46182 .57595 m
.48376 .58945 L
s
.01 w
.4888 .54892 Mdot
.5 Mabswid
.4888 .54892 m
.48847 .56289 L
s
.49097 .54783 m
.4888 .54892 L
s
.49241 .52541 m
.4888 .54892 L
s
.49451 .52386 m
.4888 .54892 L
s
.01 w
.5099 .59382 Mdot
.5 Mabswid
.5099 .59382 m
.48588 .57815 L
s
.5099 .59382 m
.53728 .59412 L
s
.5099 .59382 m
.53622 .58241 L
s
.51102 .58027 m
.5099 .59382 L
s
.01 w
.53828 .60987 Mdot
.5 Mabswid
.53828 .60987 m
.56607 .6097 L
s
.53828 .60987 m
.56504 .60677 L
s
.53828 .60987 m
.56447 .60211 L
s
.53828 .60987 m
.53771 .61301 L
s
.01 w
.53771 .61301 Mdot
.5 Mabswid
.53771 .61301 m
.56607 .6097 L
s
.53771 .61301 m
.56504 .60677 L
s
.01 w
.49419 .51271 Mdot
.5 Mabswid
.49241 .52541 m
.49419 .51271 L
s
.50121 .48205 m
.49419 .51271 L
s
.49921 .49389 m
.49419 .51271 L
s
.01 w
.49241 .52541 Mdot
.5 Mabswid
.49451 .52386 m
.49241 .52541 L
s
.49921 .49389 m
.49241 .52541 L
s
.4991 .49977 m
.49241 .52541 L
s
.01 w
.44903 .60083 Mdot
.5 Mabswid
.44903 .60083 m
.45423 .60745 L
s
.45829 .58938 m
.44903 .60083 L
s
.42762 .60076 m
.44903 .60083 L
s
.43085 .59757 m
.44903 .60083 L
s
.43307 .58526 m
.44903 .60083 L
s
.01 w
.45423 .60745 Mdot
.5 Mabswid
.45423 .60745 m
.45339 .61078 L
s
.42753 .604 m
.45423 .60745 L
s
.42762 .60076 m
.45423 .60745 L
s
.43085 .59757 m
.45423 .60745 L
s
.01 w
.53728 .59412 Mdot
.5 Mabswid
.53728 .59412 m
.56447 .60211 L
s
.53728 .59412 m
.56298 .59349 L
s
.53728 .59412 m
.56214 .58333 L
s
.53622 .58241 m
.53728 .59412 L
s
.51102 .58027 m
.53728 .59412 L
s
.01 w
.45339 .61078 Mdot
.5 Mabswid
.42753 .604 m
.45339 .61078 L
s
.42762 .60076 m
.45339 .61078 L
s
.01 w
.48588 .57815 Mdot
.5 Mabswid
.48847 .56289 m
.48588 .57815 L
s
.51102 .58027 m
.48588 .57815 L
s
.51164 .56625 m
.48588 .57815 L
s
.45829 .58938 m
.48588 .57815 L
s
.46182 .57595 m
.48588 .57815 L
s
.46588 .56213 m
.48588 .57815 L
s
.01 w
.51102 .58027 Mdot
.5 Mabswid
.51102 .58027 m
.48847 .56289 L
s
.51102 .58027 m
.53622 .58241 L
s
.51102 .58027 m
.53538 .56938 L
s
.51164 .56625 m
.51102 .58027 L
s
.01 w
.58044 .60555 Mdot
.5 Mabswid
.58044 .60555 m
.60893 .59963 L
s
.59192 .59806 m
.58044 .60555 L
s
.56447 .60211 m
.58044 .60555 L
s
.01 w
.45829 .58938 Mdot
.5 Mabswid
.46182 .57595 m
.45829 .58938 L
s
.43085 .59757 m
.45829 .58938 L
s
.43307 .58526 m
.45829 .58938 L
s
.43799 .57393 m
.45829 .58938 L
s
.01 w
.56447 .60211 Mdot
.5 Mabswid
.56447 .60211 m
.59274 .60237 L
s
.56447 .60211 m
.59192 .59806 L
s
.56447 .60211 m
.59002 .59086 L
s
.56447 .60211 m
.56504 .60677 L
s
.56298 .59349 m
.56447 .60211 L
s
.01 w
.56504 .60677 Mdot
.5 Mabswid
.56504 .60677 m
.59341 .60534 L
s
.56504 .60677 m
.59274 .60237 L
s
.56504 .60677 m
.59192 .59806 L
s
.56504 .60677 m
.56607 .6097 L
s
.01 w
.56607 .6097 Mdot
.5 Mabswid
.56607 .6097 m
.59341 .60534 L
s
.56607 .6097 m
.59274 .60237 L
s
.01 w
.53622 .58241 Mdot
.5 Mabswid
.53622 .58241 m
.56298 .59349 L
s
.53622 .58241 m
.56214 .58333 L
s
.53622 .58241 m
.56073 .57323 L
s
.53538 .56938 m
.53622 .58241 L
s
.51164 .56625 m
.53622 .58241 L
s
.01 w
.56298 .59349 Mdot
.5 Mabswid
.56298 .59349 m
.59192 .59806 L
s
.56298 .59349 m
.59002 .59086 L
s
.56298 .59349 m
.58828 .58309 L
s
.56214 .58333 m
.56298 .59349 L
s
.01 w
.43085 .59757 Mdot
.5 Mabswid
.43085 .59757 m
.41293 .59927 L
s
.43085 .59757 m
.42762 .60076 L
s
.43307 .58526 m
.43085 .59757 L
s
.40396 .59353 m
.43085 .59757 L
s
.40561 .58892 m
.43085 .59757 L
s
.40986 .58064 m
.43085 .59757 L
s
.01 w
.48847 .56289 Mdot
.5 Mabswid
.49097 .54783 m
.48847 .56289 L
s
.51164 .56625 m
.48847 .56289 L
s
.51137 .54838 m
.48847 .56289 L
s
.46182 .57595 m
.48847 .56289 L
s
.46588 .56213 m
.48847 .56289 L
s
.47224 .54474 m
.48847 .56289 L
s
.01 w
.51164 .56625 Mdot
.5 Mabswid
.51164 .56625 m
.49097 .54783 L
s
.51164 .56625 m
.53538 .56938 L
s
.51164 .56625 m
.53422 .55555 L
s
.51137 .54838 m
.51164 .56625 L
s
.01 w
.46182 .57595 Mdot
.5 Mabswid
.46588 .56213 m
.46182 .57595 L
s
.43307 .58526 m
.46182 .57595 L
s
.43799 .57393 m
.46182 .57595 L
s
.44311 .56121 m
.46182 .57595 L
s
.01 w
.41293 .59927 Mdot
.5 Mabswid
.41293 .59927 m
.38937 .58968 L
s
.40561 .58892 m
.41293 .59927 L
s
.01 w
.53538 .56938 Mdot
.5 Mabswid
.53538 .56938 m
.56214 .58333 L
s
.53538 .56938 m
.56073 .57323 L
s
.53538 .56938 m
.55771 .56285 L
s
.53422 .55555 m
.53538 .56938 L
s
.51137 .54838 m
.53538 .56938 L
s
.01 w
.56214 .58333 Mdot
.5 Mabswid
.56214 .58333 m
.59002 .59086 L
s
.56214 .58333 m
.58828 .58309 L
s
.56214 .58333 m
.58662 .57551 L
s
.56073 .57323 m
.56214 .58333 L
s
.01 w
.42762 .60076 Mdot
.5 Mabswid
.42762 .60076 m
.42753 .604 L
s
.40236 .59637 m
.42762 .60076 L
s
.40396 .59353 m
.42762 .60076 L
s
.40561 .58892 m
.42762 .60076 L
s
.01 w
.42753 .604 Mdot
.5 Mabswid
.40236 .59637 m
.42753 .604 L
s
.40396 .59353 m
.42753 .604 L
s
.01 w
.59341 .60534 Mdot
.5 Mabswid
.59341 .60534 m
.62028 .59991 L
s
.59341 .60534 m
.6196 .59698 L
s
.59274 .60237 m
.59341 .60534 L
s
.01 w
.59274 .60237 Mdot
.5 Mabswid
.59274 .60237 m
.62028 .59991 L
s
.59274 .60237 m
.6196 .59698 L
s
.59274 .60237 m
.61898 .59289 L
s
.59192 .59806 m
.59274 .60237 L
s
.01 w
.59192 .59806 Mdot
.5 Mabswid
.59192 .59806 m
.60893 .59963 L
s
.59192 .59806 m
.6196 .59698 L
s
.59192 .59806 m
.61898 .59289 L
s
.59192 .59806 m
.61646 .58695 L
s
.59002 .59086 m
.59192 .59806 L
s
.01 w
.49097 .54783 Mdot
.5 Mabswid
.49451 .52386 m
.49097 .54783 L
s
.49565 .52464 m
.49097 .54783 L
s
.51137 .54838 m
.49097 .54783 L
s
.46588 .56213 m
.49097 .54783 L
s
.47224 .54474 m
.49097 .54783 L
s
.01 w
.43307 .58526 Mdot
.5 Mabswid
.43799 .57393 m
.43307 .58526 L
s
.40561 .58892 m
.43307 .58526 L
s
.40986 .58064 m
.43307 .58526 L
s
.41406 .57072 m
.43307 .58526 L
s
.01 w
.46588 .56213 Mdot
.5 Mabswid
.47224 .54474 m
.46588 .56213 L
s
.43799 .57393 m
.46588 .56213 L
s
.44311 .56121 m
.46588 .56213 L
s
.44879 .54779 m
.46588 .56213 L
s
.01 w
.49451 .52386 Mdot
.5 Mabswid
.49565 .52464 m
.49451 .52386 L
s
.4991 .49977 m
.49451 .52386 L
s
.50064 .49849 m
.49451 .52386 L
s
.01 w
.56073 .57323 Mdot
.5 Mabswid
.56073 .57323 m
.58828 .58309 L
s
.56073 .57323 m
.58662 .57551 L
s
.56073 .57323 m
.58613 .57174 L
s
.55771 .56285 m
.56073 .57323 L
s
.53422 .55555 m
.56073 .57323 L
s
.01 w
.60893 .59963 Mdot
.5 Mabswid
.60893 .59963 m
.63824 .59186 L
s
.61898 .59289 m
.60893 .59963 L
s
.01 w
.59002 .59086 Mdot
.5 Mabswid
.59002 .59086 m
.61898 .59289 L
s
.59002 .59086 m
.61646 .58695 L
s
.59002 .59086 m
.61424 .58078 L
s
.58828 .58309 m
.59002 .59086 L
s
.01 w
.51137 .54838 Mdot
.5 Mabswid
.51137 .54838 m
.52171 .52942 L
s
.51137 .54838 m
.51015 .52622 L
s
.51137 .54838 m
.49565 .52464 L
s
.51137 .54838 m
.53422 .55555 L
s
.01 w
.53422 .55555 Mdot
.5 Mabswid
.53422 .55555 m
.53636 .53764 L
s
.53422 .55555 m
.52171 .52942 L
s
.53422 .55555 m
.55771 .56285 L
s
.01 w
.49921 .49389 Mdot
.5 Mabswid
.49921 .49389 m
.50121 .48205 L
s
.4991 .49977 m
.49921 .49389 L
s
.50569 .46548 m
.49921 .49389 L
s
.50497 .47297 m
.49921 .49389 L
s
.01 w
.55771 .56285 Mdot
.5 Mabswid
.55771 .56285 m
.53636 .53764 L
s
.55771 .56285 m
.58662 .57551 L
s
.55771 .56285 m
.58613 .57174 L
s
.01 w
.58828 .58309 Mdot
.5 Mabswid
.58828 .58309 m
.61646 .58695 L
s
.58828 .58309 m
.61424 .58078 L
s
.58828 .58309 m
.61294 .57566 L
s
.58662 .57551 m
.58828 .58309 L
s
.01 w
.43799 .57393 Mdot
.5 Mabswid
.44311 .56121 m
.43799 .57393 L
s
.40986 .58064 m
.43799 .57393 L
s
.41406 .57072 m
.43799 .57393 L
s
.41867 .56092 m
.43799 .57393 L
s
.01 w
.50121 .48205 Mdot
.5 Mabswid
.50758 .45477 m
.50121 .48205 L
s
.50569 .46548 m
.50121 .48205 L
s
.01 w
.58662 .57551 Mdot
.5 Mabswid
.58662 .57551 m
.61424 .58078 L
s
.58662 .57551 m
.61294 .57566 L
s
.58662 .57551 m
.61247 .57288 L
s
.58613 .57174 m
.58662 .57551 L
s
.01 w
.47224 .54474 Mdot
.5 Mabswid
.47224 .54474 m
.46966 .52456 L
s
.47224 .54474 m
.48124 .52356 L
s
.47224 .54474 m
.49565 .52464 L
s
.44311 .56121 m
.47224 .54474 L
s
.44879 .54779 m
.47224 .54474 L
s
.01 w
.58613 .57174 Mdot
.5 Mabswid
.58613 .57174 m
.61294 .57566 L
s
.58613 .57174 m
.61247 .57288 L
s
.01 w
.62028 .59991 Mdot
.5 Mabswid
.62028 .59991 m
.64641 .59332 L
s
.62028 .59991 m
.6453 .59049 L
s
.6196 .59698 m
.62028 .59991 L
s
.01 w
.44311 .56121 Mdot
.5 Mabswid
.44879 .54779 m
.44311 .56121 L
s
.41406 .57072 m
.44311 .56121 L
s
.41867 .56092 m
.44311 .56121 L
s
.42488 .55109 m
.44311 .56121 L
s
.01 w
.6196 .59698 Mdot
.5 Mabswid
.6196 .59698 m
.64641 .59332 L
s
.6196 .59698 m
.6453 .59049 L
s
.6196 .59698 m
.64549 .58618 L
s
.61898 .59289 m
.6196 .59698 L
s
.01 w
.53636 .53764 Mdot
.5 Mabswid
.52171 .52942 m
.53636 .53764 L
s
.5229 .50614 m
.53636 .53764 L
s
.01 w
.61898 .59289 Mdot
.5 Mabswid
.61898 .59289 m
.63824 .59186 L
s
.61898 .59289 m
.6453 .59049 L
s
.61898 .59289 m
.64549 .58618 L
s
.61898 .59289 m
.64168 .5813 L
s
.61646 .58695 m
.61898 .59289 L
s
.01 w
.40561 .58892 Mdot
.5 Mabswid
.40561 .58892 m
.38937 .58968 L
s
.40561 .58892 m
.40396 .59353 L
s
.40986 .58064 m
.40561 .58892 L
s
.38026 .58495 m
.40561 .58892 L
s
.38219 .58072 m
.40561 .58892 L
s
.38633 .57389 m
.40561 .58892 L
s
.01 w
.4991 .49977 Mdot
.5 Mabswid
.50064 .49849 m
.4991 .49977 L
s
.50497 .47297 m
.4991 .49977 L
s
.50514 .47772 m
.4991 .49977 L
s
.01 w
.51015 .52622 Mdot
.5 Mabswid
.51015 .52622 m
.52171 .52942 L
s
.51142 .50279 m
.51015 .52622 L
s
.49565 .52464 m
.51015 .52622 L
s
.01 w
.40396 .59353 Mdot
.5 Mabswid
.40396 .59353 m
.40236 .59637 L
s
.37876 .58781 m
.40396 .59353 L
s
.38026 .58495 m
.40396 .59353 L
s
.38219 .58072 m
.40396 .59353 L
s
.01 w
.40236 .59637 Mdot
.5 Mabswid
.37876 .58781 m
.40236 .59637 L
s
.38026 .58495 m
.40236 .59637 L
s
.01 w
.52171 .52942 Mdot
.5 Mabswid
.5229 .50614 m
.52171 .52942 L
s
.51142 .50279 m
.52171 .52942 L
s
.01 w
.61646 .58695 Mdot
.5 Mabswid
.61646 .58695 m
.64549 .58618 L
s
.61646 .58695 m
.64168 .5813 L
s
.61646 .58695 m
.63959 .57622 L
s
.61424 .58078 m
.61646 .58695 L
s
.01 w
.49565 .52464 Mdot
.5 Mabswid
.49565 .52464 m
.51142 .50279 L
s
.49565 .52464 m
.48124 .52356 L
s
.49565 .52464 m
.48942 .50069 L
s
.50064 .49849 m
.49565 .52464 L
s
.01 w
.40986 .58064 Mdot
.5 Mabswid
.41406 .57072 m
.40986 .58064 L
s
.38219 .58072 m
.40986 .58064 L
s
.38633 .57389 m
.40986 .58064 L
s
.39045 .56648 m
.40986 .58064 L
s
.01 w
.61424 .58078 Mdot
.5 Mabswid
.61424 .58078 m
.64168 .5813 L
s
.61424 .58078 m
.63959 .57622 L
s
.61424 .58078 m
.63806 .57205 L
s
.61294 .57566 m
.61424 .58078 L
s
.01 w
.44879 .54779 Mdot
.5 Mabswid
.44879 .54779 m
.45334 .52999 L
s
.44879 .54779 m
.46966 .52456 L
s
.41867 .56092 m
.44879 .54779 L
s
.42488 .55109 m
.44879 .54779 L
s
.01 w
.61294 .57566 Mdot
.5 Mabswid
.61294 .57566 m
.63959 .57622 L
s
.61294 .57566 m
.63806 .57205 L
s
.61294 .57566 m
.63762 .56976 L
s
.61247 .57288 m
.61294 .57566 L
s
.01 w
.38937 .58968 Mdot
.5 Mabswid
.38937 .58968 m
.36593 .57954 L
s
.38219 .58072 m
.38937 .58968 L
s
.01 w
.48124 .52356 Mdot
.5 Mabswid
.48124 .52356 m
.46966 .52456 L
s
.48942 .50069 m
.48124 .52356 L
s
.01 w
.61247 .57288 Mdot
.5 Mabswid
.61247 .57288 m
.63806 .57205 L
s
.61247 .57288 m
.63762 .56976 L
s
.01 w
.63824 .59186 Mdot
.5 Mabswid
.63824 .59186 m
.6701 .58073 L
s
.64549 .58618 m
.63824 .59186 L
s
.01 w
.41406 .57072 Mdot
.5 Mabswid
.41867 .56092 m
.41406 .57072 L
s
.38633 .57389 m
.41406 .57072 L
s
.39045 .56648 m
.41406 .57072 L
s
.39438 .5592 m
.41406 .57072 L
s
.01 w
.46966 .52456 Mdot
.5 Mabswid
.46966 .52456 m
.45334 .52999 L
s
.47773 .50189 m
.46966 .52456 L
s
.48942 .50069 m
.46966 .52456 L
s
.01 w
.41867 .56092 Mdot
.5 Mabswid
.42488 .55109 m
.41867 .56092 L
s
.39045 .56648 m
.41867 .56092 L
s
.39438 .5592 m
.41867 .56092 L
s
.39592 .55553 m
.41867 .56092 L
s
.01 w
.64641 .59332 Mdot
.5 Mabswid
.64641 .59332 m
.67156 .58533 L
s
.64641 .59332 m
.67015 .58278 L
s
.6453 .59049 m
.64641 .59332 L
s
.01 w
.45334 .52999 Mdot
.5 Mabswid
.47773 .50189 m
.45334 .52999 L
s
.42488 .55109 m
.45334 .52999 L
s
.01 w
.6453 .59049 Mdot
.5 Mabswid
.6453 .59049 m
.67156 .58533 L
s
.6453 .59049 m
.67015 .58278 L
s
.6453 .59049 m
.66819 .57853 L
s
.64549 .58618 m
.6453 .59049 L
s
.01 w
.42488 .55109 Mdot
.5 Mabswid
.39438 .5592 m
.42488 .55109 L
s
.39592 .55553 m
.42488 .55109 L
s
.01 w
.50064 .49849 Mdot
.5 Mabswid
.50064 .49849 m
.51142 .50279 L
s
.50064 .49849 m
.51465 .47754 L
s
.50064 .49849 m
.48942 .50069 L
s
.50064 .49849 m
.49676 .4758 L
s
.50514 .47772 m
.50064 .49849 L
s
.01 w
.64549 .58618 Mdot
.5 Mabswid
.64549 .58618 m
.6701 .58073 L
s
.64549 .58618 m
.67015 .58278 L
s
.64549 .58618 m
.66819 .57853 L
s
.64549 .58618 m
.66591 .57376 L
s
.64168 .5813 m
.64549 .58618 L
s
.01 w
.50569 .46548 Mdot
.5 Mabswid
.50569 .46548 m
.50758 .45477 L
s
.50497 .47297 m
.50569 .46548 L
s
.51158 .44039 m
.50569 .46548 L
s
.51108 .44645 m
.50569 .46548 L
s
.01 w
.5229 .50614 Mdot
.5 Mabswid
.51142 .50279 m
.5229 .50614 L
s
.5195 .47834 m
.5229 .50614 L
s
.51465 .47754 m
.5229 .50614 L
s
.01 w
.64168 .5813 Mdot
.5 Mabswid
.64168 .5813 m
.66819 .57853 L
s
.64168 .5813 m
.66591 .57376 L
s
.64168 .5813 m
.66361 .5691 L
s
.63959 .57622 m
.64168 .5813 L
s
.01 w
.51142 .50279 Mdot
.5 Mabswid
.5195 .47834 m
.51142 .50279 L
s
.51465 .47754 m
.51142 .50279 L
s
.50514 .47772 m
.51142 .50279 L
s
.01 w
.63959 .57622 Mdot
.5 Mabswid
.63959 .57622 m
.66591 .57376 L
s
.63959 .57622 m
.66361 .5691 L
s
.63959 .57622 m
.6619 .56531 L
s
.63806 .57205 m
.63959 .57622 L
s
.01 w
.50758 .45477 Mdot
.5 Mabswid
.51318 .43092 m
.50758 .45477 L
s
.51158 .44039 m
.50758 .45477 L
s
.01 w
.63762 .56976 Mdot
.5 Mabswid
.63762 .56976 m
.6619 .56531 L
s
.63762 .56976 m
.66113 .56314 L
s
.63762 .56976 m
.63806 .57205 L
s
.01 w
.63806 .57205 Mdot
.5 Mabswid
.63806 .57205 m
.66361 .5691 L
s
.63806 .57205 m
.6619 .56531 L
s
.63806 .57205 m
.66113 .56314 L
s
.01 w
.48942 .50069 Mdot
.5 Mabswid
.48942 .50069 m
.47773 .50189 L
s
.49211 .47565 m
.48942 .50069 L
s
.49676 .4758 m
.48942 .50069 L
s
.50514 .47772 m
.48942 .50069 L
s
.01 w
.37876 .58781 Mdot
.5 Mabswid
.38026 .58495 m
.37876 .58781 L
s
.35628 .57823 m
.37876 .58781 L
s
.35785 .57545 m
.37876 .58781 L
s
.01 w
.38026 .58495 Mdot
.5 Mabswid
.38219 .58072 m
.38026 .58495 L
s
.35628 .57823 m
.38026 .58495 L
s
.35785 .57545 m
.38026 .58495 L
s
.35968 .57144 m
.38026 .58495 L
s
.01 w
.38219 .58072 Mdot
.5 Mabswid
.38219 .58072 m
.36593 .57954 L
s
.38633 .57389 m
.38219 .58072 L
s
.35785 .57545 m
.38219 .58072 L
s
.35968 .57144 m
.38219 .58072 L
s
.36393 .56593 m
.38219 .58072 L
s
.01 w
.50497 .47297 Mdot
.5 Mabswid
.50514 .47772 m
.50497 .47297 L
s
.51108 .44645 m
.50497 .47297 L
s
.51086 .45207 m
.50497 .47297 L
s
.01 w
.38633 .57389 Mdot
.5 Mabswid
.39045 .56648 m
.38633 .57389 L
s
.35968 .57144 m
.38633 .57389 L
s
.36393 .56593 m
.38633 .57389 L
s
.36786 .56019 m
.38633 .57389 L
s
.01 w
.47773 .50189 Mdot
.5 Mabswid
.49211 .47565 m
.47773 .50189 L
s
.49676 .4758 m
.47773 .50189 L
s
.01 w
.39045 .56648 Mdot
.5 Mabswid
.39438 .5592 m
.39045 .56648 L
s
.36393 .56593 m
.39045 .56648 L
s
.36786 .56019 m
.39045 .56648 L
s
.3706 .5553 m
.39045 .56648 L
s
.01 w
.39438 .5592 Mdot
.5 Mabswid
.39592 .55553 m
.39438 .5592 L
s
.36786 .56019 m
.39438 .5592 L
s
.3706 .5553 m
.39438 .5592 L
s
.37164 .55267 m
.39438 .5592 L
s
.01 w
.39592 .55553 Mdot
.5 Mabswid
.3706 .5553 m
.39592 .55553 L
s
.37164 .55267 m
.39592 .55553 L
s
.01 w
.6701 .58073 Mdot
.5 Mabswid
.6701 .58073 m
.7018 .5692 L
s
.69057 .57003 m
.6701 .58073 L
s
.66819 .57853 m
.6701 .58073 L
s
.01 w
.36593 .57954 Mdot
.5 Mabswid
.36593 .57954 m
.34262 .56723 L
s
.35968 .57144 m
.36593 .57954 L
s
.01 w
.67156 .58533 Mdot
.5 Mabswid
.67156 .58533 m
.69562 .57561 L
s
.67156 .58533 m
.69396 .57304 L
s
.67015 .58278 m
.67156 .58533 L
s
.01 w
.67015 .58278 Mdot
.5 Mabswid
.67015 .58278 m
.69562 .57561 L
s
.67015 .58278 m
.69396 .57304 L
s
.67015 .58278 m
.69057 .57003 L
s
.66819 .57853 m
.67015 .58278 L
s
.01 w
.50514 .47772 Mdot
.5 Mabswid
.50514 .47772 m
.51465 .47754 L
s
.50514 .47772 m
.5188 .4513 L
s
.50514 .47772 m
.49676 .4758 L
s
.50514 .47772 m
.50413 .44981 L
s
.51086 .45207 m
.50514 .47772 L
s
.01 w
.66819 .57853 Mdot
.5 Mabswid
.66819 .57853 m
.69396 .57304 L
s
.66819 .57853 m
.69057 .57003 L
s
.66819 .57853 m
.68898 .56433 L
s
.66591 .57376 m
.66819 .57853 L
s
.01 w
.66591 .57376 Mdot
.5 Mabswid
.66591 .57376 m
.69057 .57003 L
s
.66591 .57376 m
.68898 .56433 L
s
.66591 .57376 m
.68621 .55948 L
s
.66361 .5691 m
.66591 .57376 L
s
.01 w
.66361 .5691 Mdot
.5 Mabswid
.66361 .5691 m
.68898 .56433 L
s
.66361 .5691 m
.68621 .55948 L
s
.66361 .5691 m
.68389 .55556 L
s
.6619 .56531 m
.66361 .5691 L
s
.01 w
.66113 .56314 Mdot
.5 Mabswid
.66113 .56314 m
.68389 .55556 L
s
.66113 .56314 m
.68286 .5534 L
s
.66113 .56314 m
.6619 .56531 L
s
.01 w
.6619 .56531 Mdot
.5 Mabswid
.6619 .56531 m
.68621 .55948 L
s
.6619 .56531 m
.68389 .55556 L
s
.6619 .56531 m
.68286 .5534 L
s
.01 w
.51465 .47754 Mdot
.5 Mabswid
.51465 .47754 m
.5195 .47834 L
s
.52333 .45171 m
.51465 .47754 L
s
.5188 .4513 m
.51465 .47754 L
s
.51086 .45207 m
.51465 .47754 L
s
.01 w
.5195 .47834 Mdot
.5 Mabswid
.52333 .45171 m
.5195 .47834 L
s
.5188 .4513 m
.5195 .47834 L
s
.01 w
.49676 .4758 Mdot
.5 Mabswid
.49676 .4758 m
.49211 .47565 L
s
.49981 .44932 m
.49676 .4758 L
s
.50413 .44981 m
.49676 .4758 L
s
.51086 .45207 m
.49676 .4758 L
s
.01 w
.49211 .47565 Mdot
.5 Mabswid
.49981 .44932 m
.49211 .47565 L
s
.50413 .44981 m
.49211 .47565 L
s
.01 w
.51158 .44039 Mdot
.5 Mabswid
.51158 .44039 m
.51318 .43092 L
s
.51108 .44645 m
.51158 .44039 L
s
.51689 .41878 m
.51158 .44039 L
s
.51638 .42423 m
.51158 .44039 L
s
.01 w
.51318 .43092 Mdot
.5 Mabswid
.51812 .41077 m
.51318 .43092 L
s
.51689 .41878 m
.51318 .43092 L
s
.01 w
.35628 .57823 Mdot
.5 Mabswid
.35785 .57545 m
.35628 .57823 L
s
.33522 .56763 m
.35628 .57823 L
s
.3372 .56498 m
.35628 .57823 L
s
.01 w
.35785 .57545 Mdot
.5 Mabswid
.35968 .57144 m
.35785 .57545 L
s
.33522 .56763 m
.35785 .57545 L
s
.3372 .56498 m
.35785 .57545 L
s
.33852 .56062 m
.35785 .57545 L
s
.01 w
.35968 .57144 Mdot
.5 Mabswid
.35968 .57144 m
.34262 .56723 L
s
.36393 .56593 m
.35968 .57144 L
s
.3372 .56498 m
.35968 .57144 L
s
.33852 .56062 m
.35968 .57144 L
s
.3435 .55641 m
.35968 .57144 L
s
.01 w
.36393 .56593 Mdot
.5 Mabswid
.36786 .56019 m
.36393 .56593 L
s
.33852 .56062 m
.36393 .56593 L
s
.3435 .55641 m
.36393 .56593 L
s
.34694 .55174 m
.36393 .56593 L
s
.01 w
.36786 .56019 Mdot
.5 Mabswid
.3706 .5553 m
.36786 .56019 L
s
.3435 .55641 m
.36786 .56019 L
s
.34694 .55174 m
.36786 .56019 L
s
.34947 .54788 m
.36786 .56019 L
s
.01 w
.51108 .44645 Mdot
.5 Mabswid
.51086 .45207 m
.51108 .44645 L
s
.51638 .42423 m
.51108 .44645 L
s
.51758 .42297 m
.51108 .44645 L
s
.01 w
.3706 .5553 Mdot
.5 Mabswid
.37164 .55267 m
.3706 .5553 L
s
.34694 .55174 m
.3706 .5553 L
s
.34947 .54788 m
.3706 .5553 L
s
.35031 .54561 m
.3706 .5553 L
s
.01 w
.37164 .55267 Mdot
.5 Mabswid
.34947 .54788 m
.37164 .55267 L
s
.35031 .54561 m
.37164 .55267 L
s
.01 w
.69057 .57003 Mdot
.5 Mabswid
.69057 .57003 m
.7018 .5692 L
s
.69057 .57003 m
.71687 .56206 L
s
.69057 .57003 m
.71434 .5587 L
s
.69057 .57003 m
.71084 .553 L
s
.69057 .57003 m
.69396 .57304 L
s
.68898 .56433 m
.69057 .57003 L
s
.01 w
.69562 .57561 Mdot
.5 Mabswid
.69562 .57561 m
.71888 .56454 L
s
.69562 .57561 m
.71687 .56206 L
s
.69396 .57304 m
.69562 .57561 L
s
.01 w
.69396 .57304 Mdot
.5 Mabswid
.69396 .57304 m
.71888 .56454 L
s
.69396 .57304 m
.71687 .56206 L
s
.69396 .57304 m
.71434 .5587 L
s
.01 w
.68898 .56433 Mdot
.5 Mabswid
.68898 .56433 m
.71434 .5587 L
s
.68898 .56433 m
.71084 .553 L
s
.68898 .56433 m
.70702 .54733 L
s
.68621 .55948 m
.68898 .56433 L
s
.01 w
.68286 .5534 Mdot
.5 Mabswid
.68286 .5534 m
.70368 .54282 L
s
.68286 .5534 m
.7021 .54042 L
s
.68286 .5534 m
.68389 .55556 L
s
.01 w
.68621 .55948 Mdot
.5 Mabswid
.68621 .55948 m
.71084 .553 L
s
.68621 .55948 m
.70702 .54733 L
s
.68621 .55948 m
.70368 .54282 L
s
.68389 .55556 m
.68621 .55948 L
s
.01 w
.68389 .55556 Mdot
.5 Mabswid
.68389 .55556 m
.70702 .54733 L
s
.68389 .55556 m
.70368 .54282 L
s
.68389 .55556 m
.7021 .54042 L
s
.01 w
.7018 .5692 Mdot
.5 Mabswid
.7287 .55678 m
.7018 .5692 L
s
.71434 .5587 m
.7018 .5692 L
s
.01 w
.51086 .45207 Mdot
.5 Mabswid
.51086 .45207 m
.5188 .4513 L
s
.51086 .45207 m
.52484 .42566 L
s
.51086 .45207 m
.50413 .44981 L
s
.51086 .45207 m
.50967 .42407 L
s
.51758 .42297 m
.51086 .45207 L
s
.01 w
.52333 .45171 Mdot
.5 Mabswid
.5188 .4513 m
.52333 .45171 L
s
.53246 .4245 m
.52333 .45171 L
s
.52484 .42566 m
.52333 .45171 L
s
.01 w
.5188 .4513 Mdot
.5 Mabswid
.53246 .4245 m
.5188 .4513 L
s
.52484 .42566 m
.5188 .4513 L
s
.51758 .42297 m
.5188 .4513 L
s
.01 w
.34262 .56723 Mdot
.5 Mabswid
.31867 .55112 m
.34262 .56723 L
s
.33852 .56062 m
.34262 .56723 L
s
.01 w
.50413 .44981 Mdot
.5 Mabswid
.50413 .44981 m
.49981 .44932 L
s
.5031 .42144 m
.50413 .44981 L
s
.50967 .42407 m
.50413 .44981 L
s
.51758 .42297 m
.50413 .44981 L
s
.01 w
.49981 .44932 Mdot
.5 Mabswid
.5031 .42144 m
.49981 .44932 L
s
.50967 .42407 m
.49981 .44932 L
s
.01 w
.51812 .41077 Mdot
.5 Mabswid
.51689 .41878 m
.51812 .41077 L
s
.52238 .39419 m
.51812 .41077 L
s
.5212 .40184 m
.51812 .41077 L
s
.01 w
.51689 .41878 Mdot
.5 Mabswid
.51638 .42423 m
.51689 .41878 L
s
.5212 .40184 m
.51689 .41878 L
s
.52188 .40331 m
.51689 .41878 L
s
.01 w
.33522 .56763 Mdot
.5 Mabswid
.3372 .56498 m
.33522 .56763 L
s
.31593 .55571 m
.33522 .56763 L
s
.31809 .55339 m
.33522 .56763 L
s
.01 w
.3372 .56498 Mdot
.5 Mabswid
.33852 .56062 m
.3372 .56498 L
s
.31593 .55571 m
.3372 .56498 L
s
.31809 .55339 m
.3372 .56498 L
s
.32136 .54944 m
.3372 .56498 L
s
.01 w
.35031 .54561 Mdot
.5 Mabswid
.35031 .54561 m
.34947 .54788 L
s
.33111 .53741 m
.35031 .54561 L
s
.33205 .53534 m
.35031 .54561 L
s
.01 w
.3435 .55641 Mdot
.5 Mabswid
.3435 .55641 m
.33852 .56062 L
s
.34694 .55174 m
.3435 .55641 L
s
.32136 .54944 m
.3435 .55641 L
s
.32497 .54508 m
.3435 .55641 L
s
.3285 .54085 m
.3435 .55641 L
s
.01 w
.34694 .55174 Mdot
.5 Mabswid
.34947 .54788 m
.34694 .55174 L
s
.32497 .54508 m
.34694 .55174 L
s
.3285 .54085 m
.34694 .55174 L
s
.33111 .53741 m
.34694 .55174 L
s
.01 w
.34947 .54788 Mdot
.5 Mabswid
.3285 .54085 m
.34947 .54788 L
s
.33111 .53741 m
.34947 .54788 L
s
.33205 .53534 m
.34947 .54788 L
s
.01 w
.33852 .56062 Mdot
.5 Mabswid
.33852 .56062 m
.31867 .55112 L
s
.31809 .55339 m
.33852 .56062 L
s
.32136 .54944 m
.33852 .56062 L
s
.32497 .54508 m
.33852 .56062 L
s
.01 w
.51638 .42423 Mdot
.5 Mabswid
.51758 .42297 m
.51638 .42423 L
s
.52188 .40331 m
.51638 .42423 L
s
.52121 .4072 m
.51638 .42423 L
s
.01 w
.71434 .5587 Mdot
.5 Mabswid
.71434 .5587 m
.7287 .55678 L
s
.71434 .5587 m
.73921 .54966 L
s
.71434 .5587 m
.73684 .54588 L
s
.71434 .5587 m
.73164 .53973 L
s
.71434 .5587 m
.71687 .56206 L
s
.71084 .553 m
.71434 .5587 L
s
.01 w
.71888 .56454 Mdot
.5 Mabswid
.71888 .56454 m
.74102 .55224 L
s
.71888 .56454 m
.73921 .54966 L
s
.71687 .56206 m
.71888 .56454 L
s
.01 w
.71687 .56206 Mdot
.5 Mabswid
.71687 .56206 m
.74102 .55224 L
s
.71687 .56206 m
.73921 .54966 L
s
.71687 .56206 m
.73684 .54588 L
s
.01 w
.71084 .553 Mdot
.5 Mabswid
.71084 .553 m
.73684 .54588 L
s
.71084 .553 m
.73164 .53973 L
s
.71084 .553 m
.72595 .53322 L
s
.70702 .54733 m
.71084 .553 L
s
.01 w
.7021 .54042 Mdot
.5 Mabswid
.7021 .54042 m
.72048 .52685 L
s
.7021 .54042 m
.71782 .52372 L
s
.7021 .54042 m
.70368 .54282 L
s
.01 w
.70702 .54733 Mdot
.5 Mabswid
.70702 .54733 m
.73164 .53973 L
s
.70702 .54733 m
.72595 .53322 L
s
.70702 .54733 m
.72048 .52685 L
s
.70368 .54282 m
.70702 .54733 L
s
.01 w
.70368 .54282 Mdot
.5 Mabswid
.70368 .54282 m
.72595 .53322 L
s
.70368 .54282 m
.72048 .52685 L
s
.70368 .54282 m
.71782 .52372 L
s
.01 w
.7287 .55678 Mdot
.5 Mabswid
.75349 .54332 m
.7287 .55678 L
s
.73684 .54588 m
.7287 .55678 L
s
.01 w
.52484 .42566 Mdot
.5 Mabswid
.52484 .42566 m
.53694 .4003 L
s
.52484 .42566 m
.53246 .4245 L
s
.53889 .40178 m
.52484 .42566 L
s
.51758 .42297 m
.52484 .42566 L
s
.52188 .40331 m
.52484 .42566 L
s
.52121 .4072 m
.52484 .42566 L
s
.01 w
.51758 .42297 Mdot
.5 Mabswid
.51758 .42297 m
.53694 .4003 L
s
.51758 .42297 m
.50964 .39742 L
s
.51758 .42297 m
.53889 .40178 L
s
.51758 .42297 m
.50967 .42407 L
s
.51758 .42297 m
.50725 .39846 L
s
.52188 .40331 m
.51758 .42297 L
s
.52121 .4072 m
.51758 .42297 L
s
.01 w
.53246 .4245 Mdot
.5 Mabswid
.53246 .4245 m
.53694 .4003 L
s
.53246 .4245 m
.54847 .40408 L
s
.53889 .40178 m
.53246 .4245 L
s
.01 w
.50967 .42407 Mdot
.5 Mabswid
.50967 .42407 m
.50964 .39742 L
s
.50967 .42407 m
.5031 .42144 L
s
.50725 .39846 m
.50967 .42407 L
s
.52188 .40331 m
.50967 .42407 L
s
.52121 .4072 m
.50967 .42407 L
s
.01 w
.5212 .40184 Mdot
.5 Mabswid
.5212 .40184 m
.52238 .39419 L
s
.52188 .40331 m
.5212 .40184 L
s
.52496 .38849 m
.5212 .40184 L
s
.52469 .39159 m
.5212 .40184 L
s
.01 w
.52238 .39419 Mdot
.5 Mabswid
.52594 .38076 m
.52238 .39419 L
s
.52496 .38849 m
.52238 .39419 L
s
.01 w
.5031 .42144 Mdot
.5 Mabswid
.5031 .42144 m
.50964 .39742 L
s
.5031 .42144 m
.49715 .39868 L
s
.50725 .39846 m
.5031 .42144 L
s
.01 w
.31867 .55112 Mdot
.5 Mabswid
.29546 .53444 m
.31867 .55112 L
s
.32136 .54944 m
.31867 .55112 L
s
.30509 .53735 m
.31867 .55112 L
s
.01 w
.33205 .53534 Mdot
.5 Mabswid
.33205 .53534 m
.33111 .53741 L
s
.31591 .52417 m
.33205 .53534 L
s
.31716 .52215 m
.33205 .53534 L
s
.01 w
.33111 .53741 Mdot
.5 Mabswid
.33111 .53741 m
.3285 .54085 L
s
.31267 .52765 m
.33111 .53741 L
s
.31591 .52417 m
.33111 .53741 L
s
.31716 .52215 m
.33111 .53741 L
s
.01 w
.31593 .55571 Mdot
.5 Mabswid
.31809 .55339 m
.31593 .55571 L
s
.29851 .54218 m
.31593 .55571 L
s
.30108 .53993 m
.31593 .55571 L
s
.01 w
.3285 .54085 Mdot
.5 Mabswid
.3285 .54085 m
.32497 .54508 L
s
.30858 .532 m
.3285 .54085 L
s
.31267 .52765 m
.3285 .54085 L
s
.31591 .52417 m
.3285 .54085 L
s
.01 w
.32497 .54508 Mdot
.5 Mabswid
.32497 .54508 m
.32136 .54944 L
s
.30509 .53735 m
.32497 .54508 L
s
.30858 .532 m
.32497 .54508 L
s
.31267 .52765 m
.32497 .54508 L
s
.01 w
.32136 .54944 Mdot
.5 Mabswid
.32136 .54944 m
.31809 .55339 L
s
.30108 .53993 m
.32136 .54944 L
s
.30509 .53735 m
.32136 .54944 L
s
.30858 .532 m
.32136 .54944 L
s
.01 w
.31809 .55339 Mdot
.5 Mabswid
.29851 .54218 m
.31809 .55339 L
s
.30108 .53993 m
.31809 .55339 L
s
.30509 .53735 m
.31809 .55339 L
s
.01 w
.73684 .54588 Mdot
.5 Mabswid
.73684 .54588 m
.75349 .54332 L
s
.73684 .54588 m
.76062 .53605 L
s
.73684 .54588 m
.75825 .53197 L
s
.73684 .54588 m
.75131 .52512 L
s
.73684 .54588 m
.73921 .54966 L
s
.73164 .53973 m
.73684 .54588 L
s
.01 w
.73164 .53973 Mdot
.5 Mabswid
.73164 .53973 m
.75825 .53197 L
s
.73164 .53973 m
.75131 .52512 L
s
.73164 .53973 m
.74245 .51756 L
s
.72595 .53322 m
.73164 .53973 L
s
.01 w
.71782 .52372 Mdot
.5 Mabswid
.71782 .52372 m
.73443 .50958 L
s
.71782 .52372 m
.72723 .50034 L
s
.71782 .52372 m
.72048 .52685 L
s
.01 w
.73921 .54966 Mdot
.5 Mabswid
.73921 .54966 m
.76164 .53914 L
s
.73921 .54966 m
.76062 .53605 L
s
.73921 .54966 m
.75825 .53197 L
s
.73921 .54966 m
.74102 .55224 L
s
.01 w
.72595 .53322 Mdot
.5 Mabswid
.72595 .53322 m
.75131 .52512 L
s
.72595 .53322 m
.74245 .51756 L
s
.72595 .53322 m
.73443 .50958 L
s
.72048 .52685 m
.72595 .53322 L
s
.01 w
.74102 .55224 Mdot
.5 Mabswid
.74102 .55224 m
.76164 .53914 L
s
.74102 .55224 m
.76062 .53605 L
s
.01 w
.72048 .52685 Mdot
.5 Mabswid
.72048 .52685 m
.74245 .51756 L
s
.72048 .52685 m
.73443 .50958 L
s
.72048 .52685 m
.72723 .50034 L
s
.01 w
.52121 .4072 Mdot
.5 Mabswid
.52121 .4072 m
.53694 .4003 L
s
.52121 .4072 m
.50964 .39742 L
s
.52121 .4072 m
.54206 .39901 L
s
.52121 .4072 m
.53889 .40178 L
s
.52121 .4072 m
.50483 .39498 L
s
.52121 .4072 m
.5228 .39977 L
s
.52121 .4072 m
.50725 .39846 L
s
.52121 .4072 m
.52188 .40331 L
s
.52469 .39159 m
.52121 .4072 L
s
.52453 .39337 m
.52121 .4072 L
s
.01 w
.52188 .40331 Mdot
.5 Mabswid
.52188 .40331 m
.53694 .4003 L
s
.52188 .40331 m
.53671 .38488 L
s
.52188 .40331 m
.53734 .38734 L
s
.52188 .40331 m
.50964 .39742 L
s
.52188 .40331 m
.51619 .38267 L
s
.52188 .40331 m
.51484 .38495 L
s
.52188 .40331 m
.53889 .40178 L
s
.52188 .40331 m
.50725 .39846 L
s
.52496 .38849 m
.52188 .40331 L
s
.52469 .39159 m
.52188 .40331 L
s
.52453 .39337 m
.52188 .40331 L
s
.01 w
.75349 .54332 Mdot
.5 Mabswid
.77845 .5291 m
.75349 .54332 L
s
.75825 .53197 m
.75349 .54332 L
s
.01 w
.5228 .39977 Mdot
.5 Mabswid
.5228 .39977 m
.54206 .39901 L
s
.5228 .39977 m
.53889 .40178 L
s
.5228 .39977 m
.50483 .39498 L
s
.50725 .39846 m
.5228 .39977 L
s
.01 w
.54847 .40408 Mdot
.5 Mabswid
.54847 .40408 m
.55614 .38977 L
s
.54847 .40408 m
.53694 .4003 L
s
.55921 .39315 m
.54847 .40408 L
s
.53889 .40178 m
.54847 .40408 L
s
.5618 .39606 m
.54847 .40408 L
s
.01 w
.54206 .39901 Mdot
.5 Mabswid
.54206 .39901 m
.56073 .39296 L
s
.55921 .39315 m
.54206 .39901 L
s
.53889 .40178 m
.54206 .39901 L
s
.01 w
.53889 .40178 Mdot
.5 Mabswid
.53889 .40178 m
.55614 .38977 L
s
.53889 .40178 m
.53694 .4003 L
s
.53889 .40178 m
.55243 .38572 L
s
.53889 .40178 m
.53734 .38734 L
s
.53889 .40178 m
.56073 .39296 L
s
.53889 .40178 m
.55921 .39315 L
s
.55362 .38744 m
.53889 .40178 L
s
.5382 .38807 m
.53889 .40178 L
s
.5618 .39606 m
.53889 .40178 L
s
.52469 .39159 m
.53889 .40178 L
s
.52453 .39337 m
.53889 .40178 L
s
.01 w
.53694 .4003 Mdot
.5 Mabswid
.53694 .4003 m
.55614 .38977 L
s
.5507 .38285 m
.53694 .4003 L
s
.55243 .38572 m
.53694 .4003 L
s
.53671 .38488 m
.53694 .4003 L
s
.53734 .38734 m
.53694 .4003 L
s
.55921 .39315 m
.53694 .4003 L
s
.55362 .38744 m
.53694 .4003 L
s
.5382 .38807 m
.53694 .4003 L
s
.52496 .38849 m
.53694 .4003 L
s
.52469 .39159 m
.53694 .4003 L
s
.52453 .39337 m
.53694 .4003 L
s
.01 w
.52594 .38076 Mdot
.5 Mabswid
.52496 .38849 m
.52594 .38076 L
s
.5285 .37299 m
.52594 .38076 L
s
.52809 .37617 m
.52594 .38076 L
s
.01 w
.50483 .39498 Mdot
.5 Mabswid
.50725 .39846 m
.50483 .39498 L
s
.49035 .38564 m
.50483 .39498 L
s
.49228 .3863 m
.50483 .39498 L
s
.01 w
.50725 .39846 Mdot
.5 Mabswid
.50725 .39846 m
.50964 .39742 L
s
.50725 .39846 m
.51484 .38495 L
s
.50725 .39846 m
.4966 .38363 L
s
.50725 .39846 m
.50189 .38045 L
s
.50725 .39846 m
.49715 .39868 L
s
.51411 .38551 m
.50725 .39846 L
s
.49035 .38564 m
.50725 .39846 L
s
.49228 .3863 m
.50725 .39846 L
s
.50011 .3819 m
.50725 .39846 L
s
.48866 .38852 m
.50725 .39846 L
s
.52469 .39159 m
.50725 .39846 L
s
.52453 .39337 m
.50725 .39846 L
s
.01 w
.49715 .39868 Mdot
.5 Mabswid
.49715 .39868 m
.50964 .39742 L
s
.49715 .39868 m
.4966 .38363 L
s
.49228 .3863 m
.49715 .39868 L
s
.48866 .38852 m
.49715 .39868 L
s
.01 w
.50964 .39742 Mdot
.5 Mabswid
.51619 .38267 m
.50964 .39742 L
s
.51484 .38495 m
.50964 .39742 L
s
.4966 .38363 m
.50964 .39742 L
s
.50439 .37802 m
.50964 .39742 L
s
.50189 .38045 m
.50964 .39742 L
s
.51411 .38551 m
.50964 .39742 L
s
.49228 .3863 m
.50964 .39742 L
s
.50011 .3819 m
.50964 .39742 L
s
.52496 .38849 m
.50964 .39742 L
s
.52469 .39159 m
.50964 .39742 L
s
.52453 .39337 m
.50964 .39742 L
s
.01 w
.52496 .38849 Mdot
.5 Mabswid
.52496 .38849 m
.53671 .38488 L
s
.52496 .38849 m
.53734 .38734 L
s
.52496 .38849 m
.51619 .38267 L
s
.52496 .38849 m
.51484 .38495 L
s
.52469 .39159 m
.52496 .38849 L
s
.5285 .37299 m
.52496 .38849 L
s
.52809 .37617 m
.52496 .38849 L
s
.52782 .37875 m
.52496 .38849 L
s
.01 w
.31716 .52215 Mdot
.5 Mabswid
.31716 .52215 m
.31591 .52417 L
s
.30425 .50829 m
.31716 .52215 L
s
.30628 .50617 m
.31716 .52215 L
s
.01 w
.30509 .53735 Mdot
.5 Mabswid
.30509 .53735 m
.29546 .53444 L
s
.30509 .53735 m
.30108 .53993 L
s
.30858 .532 m
.30509 .53735 L
s
.28564 .52527 m
.30509 .53735 L
s
.28915 .52221 m
.30509 .53735 L
s
.29436 .51711 m
.30509 .53735 L
s
.01 w
.52469 .39159 Mdot
.5 Mabswid
.52469 .39159 m
.53671 .38488 L
s
.52469 .39159 m
.53734 .38734 L
s
.52469 .39159 m
.51619 .38267 L
s
.52469 .39159 m
.51484 .38495 L
s
.52469 .39159 m
.5382 .38807 L
s
.52469 .39159 m
.51411 .38551 L
s
.52453 .39337 m
.52469 .39159 L
s
.52809 .37617 m
.52469 .39159 L
s
.52782 .37875 m
.52469 .39159 L
s
.52768 .38016 m
.52469 .39159 L
s
.01 w
.31591 .52417 Mdot
.5 Mabswid
.31591 .52417 m
.31267 .52765 L
s
.29982 .5122 m
.31591 .52417 L
s
.30425 .50829 m
.31591 .52417 L
s
.30628 .50617 m
.31591 .52417 L
s
.01 w
.52453 .39337 Mdot
.5 Mabswid
.52453 .39337 m
.53734 .38734 L
s
.52453 .39337 m
.51484 .38495 L
s
.52453 .39337 m
.5382 .38807 L
s
.52453 .39337 m
.51411 .38551 L
s
.52782 .37875 m
.52453 .39337 L
s
.52768 .38016 m
.52453 .39337 L
s
.01 w
.56073 .39296 Mdot
.5 Mabswid
.56073 .39296 m
.57674 .38446 L
s
.56073 .39296 m
.57799 .3854 L
s
.55921 .39315 m
.56073 .39296 L
s
.01 w
.31267 .52765 Mdot
.5 Mabswid
.31267 .52765 m
.30858 .532 L
s
.29436 .51711 m
.31267 .52765 L
s
.29982 .5122 m
.31267 .52765 L
s
.30425 .50829 m
.31267 .52765 L
s
.01 w
.5618 .39606 Mdot
.5 Mabswid
.5618 .39606 m
.55614 .38977 L
s
.5618 .39606 m
.57759 .39197 L
s
.5618 .39606 m
.57799 .3854 L
s
.5618 .39606 m
.55921 .39315 L
s
.01 w
.30858 .532 Mdot
.5 Mabswid
.28915 .52221 m
.30858 .532 L
s
.29436 .51711 m
.30858 .532 L
s
.29982 .5122 m
.30858 .532 L
s
.01 w
.73443 .50958 Mdot
.5 Mabswid
.73443 .50958 m
.75707 .50122 L
s
.73443 .50958 m
.74581 .49154 L
s
.73443 .50958 m
.73438 .481 L
s
.73443 .50958 m
.74245 .51756 L
s
.72723 .50034 m
.73443 .50958 L
s
.01 w
.30108 .53993 Mdot
.5 Mabswid
.30108 .53993 m
.29851 .54218 L
s
.28298 .52746 m
.30108 .53993 L
s
.28564 .52527 m
.30108 .53993 L
s
.28915 .52221 m
.30108 .53993 L
s
.01 w
.29851 .54218 Mdot
.5 Mabswid
.28298 .52746 m
.29851 .54218 L
s
.28564 .52527 m
.29851 .54218 L
s
.01 w
.74245 .51756 Mdot
.5 Mabswid
.74245 .51756 m
.76738 .50996 L
s
.74245 .51756 m
.75707 .50122 L
s
.74245 .51756 m
.74581 .49154 L
s
.74245 .51756 m
.75131 .52512 L
s
.01 w
.75825 .53197 Mdot
.5 Mabswid
.75825 .53197 m
.77845 .5291 L
s
.75825 .53197 m
.77899 .52244 L
s
.75825 .53197 m
.78175 .51648 L
s
.75825 .53197 m
.76738 .50996 L
s
.75825 .53197 m
.76062 .53605 L
s
.75131 .52512 m
.75825 .53197 L
s
.01 w
.75131 .52512 Mdot
.5 Mabswid
.75131 .52512 m
.78175 .51648 L
s
.75131 .52512 m
.76738 .50996 L
s
.75131 .52512 m
.75707 .50122 L
s
.01 w
.72723 .50034 Mdot
.5 Mabswid
.72723 .50034 m
.71733 .46948 L
s
.72723 .50034 m
.74581 .49154 L
s
.72723 .50034 m
.73438 .481 L
s
.01 w
.76062 .53605 Mdot
.5 Mabswid
.76062 .53605 m
.78087 .52482 L
s
.76062 .53605 m
.77899 .52244 L
s
.76062 .53605 m
.78175 .51648 L
s
.76062 .53605 m
.76164 .53914 L
s
.01 w
.55921 .39315 Mdot
.5 Mabswid
.55921 .39315 m
.57702 .38351 L
s
.55921 .39315 m
.55614 .38977 L
s
.55921 .39315 m
.55243 .38572 L
s
.55921 .39315 m
.57759 .39197 L
s
.55921 .39315 m
.57674 .38446 L
s
.55921 .39315 m
.57799 .3854 L
s
.55362 .38744 m
.55921 .39315 L
s
.01 w
.76164 .53914 Mdot
.5 Mabswid
.76164 .53914 m
.78087 .52482 L
s
.76164 .53914 m
.77899 .52244 L
s
.01 w
.53734 .38734 Mdot
.5 Mabswid
.53734 .38734 m
.55614 .38977 L
s
.53734 .38734 m
.5507 .38285 L
s
.53734 .38734 m
.55243 .38572 L
s
.53734 .38734 m
.53671 .38488 L
s
.54232 .37371 m
.53734 .38734 L
s
.54348 .37611 m
.53734 .38734 L
s
.55362 .38744 m
.53734 .38734 L
s
.5382 .38807 m
.53734 .38734 L
s
.544 .37751 m
.53734 .38734 L
s
.52809 .37617 m
.53734 .38734 L
s
.52782 .37875 m
.53734 .38734 L
s
.52768 .38016 m
.53734 .38734 L
s
.01 w
.29546 .53444 Mdot
.5 Mabswid
.27723 .51765 m
.29546 .53444 L
s
.28915 .52221 m
.29546 .53444 L
s
.01 w
.53671 .38488 Mdot
.5 Mabswid
.53671 .38488 m
.55614 .38977 L
s
.53671 .38488 m
.5507 .38285 L
s
.53671 .38488 m
.55243 .38572 L
s
.54077 .37055 m
.53671 .38488 L
s
.54232 .37371 m
.53671 .38488 L
s
.54348 .37611 m
.53671 .38488 L
s
.5285 .37299 m
.53671 .38488 L
s
.52809 .37617 m
.53671 .38488 L
s
.52782 .37875 m
.53671 .38488 L
s
.01 w
.55614 .38977 Mdot
.5 Mabswid
.55614 .38977 m
.57702 .38351 L
s
.55614 .38977 m
.55976 .37504 L
s
.55614 .38977 m
.56155 .37704 L
s
.5507 .38285 m
.55614 .38977 L
s
.55243 .38572 m
.55614 .38977 L
s
.57759 .39197 m
.55614 .38977 L
s
.57799 .3854 m
.55614 .38977 L
s
.55362 .38744 m
.55614 .38977 L
s
.01 w
.5382 .38807 Mdot
.5 Mabswid
.5382 .38807 m
.55243 .38572 L
s
.5382 .38807 m
.54348 .37611 L
s
.5382 .38807 m
.55362 .38744 L
s
.544 .37751 m
.5382 .38807 L
s
.52782 .37875 m
.5382 .38807 L
s
.52768 .38016 m
.5382 .38807 L
s
.01 w
.51484 .38495 Mdot
.5 Mabswid
.51484 .38495 m
.51619 .38267 L
s
.4966 .38363 m
.51484 .38495 L
s
.50439 .37802 m
.51484 .38495 L
s
.50189 .38045 m
.51484 .38495 L
s
.51615 .37094 m
.51484 .38495 L
s
.51439 .37306 m
.51484 .38495 L
s
.51411 .38551 m
.51484 .38495 L
s
.50011 .3819 m
.51484 .38495 L
s
.5136 .37432 m
.51484 .38495 L
s
.52809 .37617 m
.51484 .38495 L
s
.52782 .37875 m
.51484 .38495 L
s
.52768 .38016 m
.51484 .38495 L
s
.01 w
.77845 .5291 Mdot
.5 Mabswid
.80661 .51539 m
.77845 .5291 L
s
.78175 .51648 m
.77845 .5291 L
s
.01 w
.51619 .38267 Mdot
.5 Mabswid
.4966 .38363 m
.51619 .38267 L
s
.50439 .37802 m
.51619 .38267 L
s
.50189 .38045 m
.51619 .38267 L
s
.51841 .3682 m
.51619 .38267 L
s
.51615 .37094 m
.51619 .38267 L
s
.51439 .37306 m
.51619 .38267 L
s
.5285 .37299 m
.51619 .38267 L
s
.52809 .37617 m
.51619 .38267 L
s
.52782 .37875 m
.51619 .38267 L
s
.01 w
.57759 .39197 Mdot
.5 Mabswid
.57759 .39197 m
.57702 .38351 L
s
.60669 .39411 m
.57759 .39197 L
s
.57799 .3854 m
.57759 .39197 L
s
.01 w
.55362 .38744 Mdot
.5 Mabswid
.55362 .38744 m
.57702 .38351 L
s
.55362 .38744 m
.56155 .37704 L
s
.55362 .38744 m
.55243 .38572 L
s
.55362 .38744 m
.54348 .37611 L
s
.55362 .38744 m
.57799 .3854 L
s
.55362 .38744 m
.56099 .37837 L
s
.544 .37751 m
.55362 .38744 L
s
.01 w
.49035 .38564 Mdot
.5 Mabswid
.47972 .37444 m
.49035 .38564 L
s
.49228 .3863 m
.49035 .38564 L
s
.47913 .37549 m
.49035 .38564 L
s
.01 w
.51411 .38551 Mdot
.5 Mabswid
.51411 .38551 m
.50189 .38045 L
s
.51411 .38551 m
.51439 .37306 L
s
.50011 .3819 m
.51411 .38551 L
s
.5136 .37432 m
.51411 .38551 L
s
.52782 .37875 m
.51411 .38551 L
s
.52768 .38016 m
.51411 .38551 L
s
.01 w
.48866 .38852 Mdot
.5 Mabswid
.48866 .38852 m
.4966 .38363 L
s
.48866 .38852 m
.47643 .38177 L
s
.48866 .38852 m
.49228 .3863 L
s
.48866 .38852 m
.47913 .37549 L
s
.01 w
.55243 .38572 Mdot
.5 Mabswid
.55243 .38572 m
.57702 .38351 L
s
.55243 .38572 m
.55976 .37504 L
s
.55243 .38572 m
.56155 .37704 L
s
.55243 .38572 m
.5507 .38285 L
s
.54232 .37371 m
.55243 .38572 L
s
.54348 .37611 m
.55243 .38572 L
s
.57799 .3854 m
.55243 .38572 L
s
.56099 .37837 m
.55243 .38572 L
s
.544 .37751 m
.55243 .38572 L
s
.01 w
.5507 .38285 Mdot
.5 Mabswid
.5507 .38285 m
.57702 .38351 L
s
.5507 .38285 m
.55976 .37504 L
s
.5507 .38285 m
.56155 .37704 L
s
.54077 .37055 m
.5507 .38285 L
s
.54232 .37371 m
.5507 .38285 L
s
.54348 .37611 m
.5507 .38285 L
s
.01 w
.49228 .3863 Mdot
.5 Mabswid
.49228 .3863 m
.4966 .38363 L
s
.49228 .3863 m
.48084 .37386 L
s
.49228 .3863 m
.50189 .38045 L
s
.49228 .3863 m
.47643 .38177 L
s
.49228 .3863 m
.47972 .37444 L
s
.47913 .37549 m
.49228 .3863 L
s
.50011 .3819 m
.49228 .3863 L
s
.01 w
.57674 .38446 Mdot
.5 Mabswid
.58425 .37376 m
.57674 .38446 L
s
.57799 .3854 m
.57674 .38446 L
s
.59212 .37743 m
.57674 .38446 L
s
.01 w
.4966 .38363 Mdot
.5 Mabswid
.48084 .37386 m
.4966 .38363 L
s
.50439 .37802 m
.4966 .38363 L
s
.50189 .38045 m
.4966 .38363 L
s
.49942 .36888 m
.4966 .38363 L
s
.49725 .37048 m
.4966 .38363 L
s
.47643 .38177 m
.4966 .38363 L
s
.47913 .37549 m
.4966 .38363 L
s
.50011 .3819 m
.4966 .38363 L
s
.01 w
.52809 .37617 Mdot
.5 Mabswid
.52809 .37617 m
.54077 .37055 L
s
.52809 .37617 m
.54232 .37371 L
s
.52809 .37617 m
.54348 .37611 L
s
.52809 .37617 m
.51841 .3682 L
s
.52809 .37617 m
.51615 .37094 L
s
.52809 .37617 m
.51439 .37306 L
s
.52809 .37617 m
.5285 .37299 L
s
.52782 .37875 m
.52809 .37617 L
s
.53129 .36249 m
.52809 .37617 L
s
.53124 .36388 m
.52809 .37617 L
s
.5312 .36542 m
.52809 .37617 L
s
.01 w
.5285 .37299 Mdot
.5 Mabswid
.5285 .37299 m
.54077 .37055 L
s
.5285 .37299 m
.54232 .37371 L
s
.5285 .37299 m
.51841 .3682 L
s
.5285 .37299 m
.51615 .37094 L
s
.5285 .37299 m
.53135 .36029 L
s
.53129 .36249 m
.5285 .37299 L
s
.53124 .36388 m
.5285 .37299 L
s
.01 w
.52782 .37875 Mdot
.5 Mabswid
.52782 .37875 m
.54232 .37371 L
s
.52782 .37875 m
.54348 .37611 L
s
.52782 .37875 m
.51615 .37094 L
s
.52782 .37875 m
.51439 .37306 L
s
.52782 .37875 m
.544 .37751 L
s
.52782 .37875 m
.5136 .37432 L
s
.52768 .38016 m
.52782 .37875 L
s
.53124 .36388 m
.52782 .37875 L
s
.5312 .36542 m
.52782 .37875 L
s
.53118 .36639 m
.52782 .37875 L
s
.01 w
.52768 .38016 Mdot
.5 Mabswid
.52768 .38016 m
.54348 .37611 L
s
.52768 .38016 m
.51439 .37306 L
s
.52768 .38016 m
.544 .37751 L
s
.52768 .38016 m
.5136 .37432 L
s
.5312 .36542 m
.52768 .38016 L
s
.53118 .36639 m
.52768 .38016 L
s
.01 w
.71733 .46948 Mdot
.5 Mabswid
.71779 .4549 m
.71733 .46948 L
s
.69511 .43963 m
.71733 .46948 L
s
.73438 .481 m
.71733 .46948 L
s
.01 w
.50011 .3819 Mdot
.5 Mabswid
.50011 .3819 m
.48084 .37386 L
s
.50011 .3819 m
.50189 .38045 L
s
.50011 .3819 m
.49725 .37048 L
s
.50011 .3819 m
.51439 .37306 L
s
.50011 .3819 m
.47913 .37549 L
s
.49749 .37189 m
.50011 .3819 L
s
.5136 .37432 m
.50011 .3819 L
s
.01 w
.50189 .38045 Mdot
.5 Mabswid
.50189 .38045 m
.48084 .37386 L
s
.50189 .38045 m
.50439 .37802 L
s
.49942 .36888 m
.50189 .38045 L
s
.49725 .37048 m
.50189 .38045 L
s
.51615 .37094 m
.50189 .38045 L
s
.51439 .37306 m
.50189 .38045 L
s
.47913 .37549 m
.50189 .38045 L
s
.49749 .37189 m
.50189 .38045 L
s
.5136 .37432 m
.50189 .38045 L
s
.01 w
.50439 .37802 Mdot
.5 Mabswid
.50439 .37802 m
.48084 .37386 L
s
.49942 .36888 m
.50439 .37802 L
s
.49725 .37048 m
.50439 .37802 L
s
.51841 .3682 m
.50439 .37802 L
s
.51615 .37094 m
.50439 .37802 L
s
.51439 .37306 m
.50439 .37802 L
s
.01 w
.57799 .3854 Mdot
.5 Mabswid
.57799 .3854 m
.57702 .38351 L
s
.57799 .3854 m
.56155 .37704 L
s
.57799 .3854 m
.60669 .39411 L
s
.57799 .3854 m
.61119 .3902 L
s
.57799 .3854 m
.58425 .37376 L
s
.56099 .37837 m
.57799 .3854 L
s
.6111 .3843 m
.57799 .3854 L
s
.5881 .37542 m
.57799 .3854 L
s
.59212 .37743 m
.57799 .3854 L
s
.57208 .3714 m
.57799 .3854 L
s
.57271 .3729 m
.57799 .3854 L
s
.01 w
.57702 .38351 Mdot
.5 Mabswid
.55976 .37504 m
.57702 .38351 L
s
.56155 .37704 m
.57702 .38351 L
s
.60669 .39411 m
.57702 .38351 L
s
.61119 .3902 m
.57702 .38351 L
s
.56099 .37837 m
.57702 .38351 L
s
.6111 .3843 m
.57702 .38351 L
s
.5881 .37542 m
.57702 .38351 L
s
.59212 .37743 m
.57702 .38351 L
s
.57143 .36859 m
.57702 .38351 L
s
.57208 .3714 m
.57702 .38351 L
s
.57271 .3729 m
.57702 .38351 L
s
.01 w
.73438 .481 Mdot
.5 Mabswid
.73438 .481 m
.71779 .4549 L
s
.73438 .481 m
.75615 .475 L
s
.73438 .481 m
.74015 .46219 L
s
.73438 .481 m
.74581 .49154 L
s
.01 w
.54348 .37611 Mdot
.5 Mabswid
.54348 .37611 m
.55976 .37504 L
s
.54348 .37611 m
.56155 .37704 L
s
.54348 .37611 m
.54232 .37371 L
s
.56099 .37837 m
.54348 .37611 L
s
.544 .37751 m
.54348 .37611 L
s
.55165 .36597 m
.54348 .37611 L
s
.55286 .36795 m
.54348 .37611 L
s
.55346 .36909 m
.54348 .37611 L
s
.53124 .36388 m
.54348 .37611 L
s
.5312 .36542 m
.54348 .37611 L
s
.53118 .36639 m
.54348 .37611 L
s
.01 w
.30628 .50617 Mdot
.5 Mabswid
.30628 .50617 m
.30425 .50829 L
s
.29696 .48961 m
.30628 .50617 L
s
.30028 .48696 m
.30628 .50617 L
s
.01 w
.544 .37751 Mdot
.5 Mabswid
.544 .37751 m
.56155 .37704 L
s
.544 .37751 m
.56099 .37837 L
s
.55286 .36795 m
.544 .37751 L
s
.55346 .36909 m
.544 .37751 L
s
.5312 .36542 m
.544 .37751 L
s
.53118 .36639 m
.544 .37751 L
s
.01 w
.60669 .39411 Mdot
.5 Mabswid
.60669 .39411 m
.64031 .4048 L
s
.60669 .39411 m
.64169 .40185 L
s
.61119 .3902 m
.60669 .39411 L
s
.01 w
.61496 .37011 Mdot
.5 Mabswid
.61496 .37011 m
.6414 .3782 L
s
.61934 .3762 m
.61496 .37011 L
s
.59072 .36485 m
.61496 .37011 L
s
.59539 .37039 m
.61496 .37011 L
s
.01 w
.54232 .37371 Mdot
.5 Mabswid
.54232 .37371 m
.55976 .37504 L
s
.54232 .37371 m
.56155 .37704 L
s
.54232 .37371 m
.54077 .37055 L
s
.54956 .36378 m
.54232 .37371 L
s
.55165 .36597 m
.54232 .37371 L
s
.55286 .36795 m
.54232 .37371 L
s
.53129 .36249 m
.54232 .37371 L
s
.53124 .36388 m
.54232 .37371 L
s
.5312 .36542 m
.54232 .37371 L
s
.01 w
.74581 .49154 Mdot
.5 Mabswid
.74581 .49154 m
.76921 .48448 L
s
.74581 .49154 m
.75615 .475 L
s
.74581 .49154 m
.74015 .46219 L
s
.74581 .49154 m
.75707 .50122 L
s
.01 w
.54077 .37055 Mdot
.5 Mabswid
.54077 .37055 m
.55976 .37504 L
s
.53135 .36029 m
.54077 .37055 L
s
.54956 .36378 m
.54077 .37055 L
s
.55165 .36597 m
.54077 .37055 L
s
.53129 .36249 m
.54077 .37055 L
s
.53124 .36388 m
.54077 .37055 L
s
.01 w
.6414 .3782 Mdot
.5 Mabswid
.6414 .3782 m
.67114 .38872 L
s
.6484 .38462 m
.6414 .3782 L
s
.61934 .3762 m
.6414 .3782 L
s
.01 w
.30425 .50829 Mdot
.5 Mabswid
.30425 .50829 m
.29982 .5122 L
s
.28975 .49492 m
.30425 .50829 L
s
.29696 .48961 m
.30425 .50829 L
s
.30028 .48696 m
.30425 .50829 L
s
.01 w
.56155 .37704 Mdot
.5 Mabswid
.56155 .37704 m
.55976 .37504 L
s
.56099 .37837 m
.56155 .37704 L
s
.5881 .37542 m
.56155 .37704 L
s
.57143 .36859 m
.56155 .37704 L
s
.57208 .3714 m
.56155 .37704 L
s
.57271 .3729 m
.56155 .37704 L
s
.55165 .36597 m
.56155 .37704 L
s
.55286 .36795 m
.56155 .37704 L
s
.55346 .36909 m
.56155 .37704 L
s
.01 w
.75707 .50122 Mdot
.5 Mabswid
.75707 .50122 m
.78261 .49327 L
s
.75707 .50122 m
.76921 .48448 L
s
.75707 .50122 m
.75615 .475 L
s
.75707 .50122 m
.76738 .50996 L
s
.01 w
.56099 .37837 Mdot
.5 Mabswid
.57208 .3714 m
.56099 .37837 L
s
.57271 .3729 m
.56099 .37837 L
s
.55286 .36795 m
.56099 .37837 L
s
.55346 .36909 m
.56099 .37837 L
s
.01 w
.55976 .37504 Mdot
.5 Mabswid
.5881 .37542 m
.55976 .37504 L
s
.57143 .36859 m
.55976 .37504 L
s
.57208 .3714 m
.55976 .37504 L
s
.54956 .36378 m
.55976 .37504 L
s
.55165 .36597 m
.55976 .37504 L
s
.55286 .36795 m
.55976 .37504 L
s
.01 w
.59072 .36485 Mdot
.5 Mabswid
.59539 .37039 m
.59072 .36485 L
s
.56891 .36183 m
.59072 .36485 L
s
.57143 .36859 m
.59072 .36485 L
s
.01 w
.76738 .50996 Mdot
.5 Mabswid
.76738 .50996 m
.7925 .50502 L
s
.76738 .50996 m
.78261 .49327 L
s
.76738 .50996 m
.76921 .48448 L
s
.76738 .50996 m
.78175 .51648 L
s
.01 w
.29982 .5122 Mdot
.5 Mabswid
.29982 .5122 m
.29436 .51711 L
s
.28221 .50045 m
.29982 .5122 L
s
.28975 .49492 m
.29982 .5122 L
s
.29696 .48961 m
.29982 .5122 L
s
.01 w
.29436 .51711 Mdot
.5 Mabswid
.29436 .51711 m
.28915 .52221 L
s
.27525 .5058 m
.29436 .51711 L
s
.28221 .50045 m
.29436 .51711 L
s
.28975 .49492 m
.29436 .51711 L
s
.01 w
.28915 .52221 Mdot
.5 Mabswid
.28915 .52221 m
.27723 .51765 L
s
.28915 .52221 m
.28564 .52527 L
s
.27181 .50929 m
.28915 .52221 L
s
.27525 .5058 m
.28915 .52221 L
s
.28221 .50045 m
.28915 .52221 L
s
.01 w
.47643 .38177 Mdot
.5 Mabswid
.47643 .38177 m
.48084 .37386 L
s
.45036 .37881 m
.47643 .38177 L
s
.47913 .37549 m
.47643 .38177 L
s
.01 w
.67114 .38872 Mdot
.5 Mabswid
.67114 .38872 m
.70406 .40163 L
s
.67929 .39595 m
.67114 .38872 L
s
.6484 .38462 m
.67114 .38872 L
s
.01 w
.51841 .3682 Mdot
.5 Mabswid
.51841 .3682 m
.49942 .36888 L
s
.51615 .37094 m
.51841 .3682 L
s
.53135 .36029 m
.51841 .3682 L
s
.51306 .36006 m
.51841 .3682 L
s
.51085 .3618 m
.51841 .3682 L
s
.53129 .36249 m
.51841 .3682 L
s
.53124 .36388 m
.51841 .3682 L
s
.01 w
.51615 .37094 Mdot
.5 Mabswid
.51615 .37094 m
.49942 .36888 L
s
.51615 .37094 m
.49725 .37048 L
s
.51439 .37306 m
.51615 .37094 L
s
.51306 .36006 m
.51615 .37094 L
s
.51085 .3618 m
.51615 .37094 L
s
.50954 .36352 m
.51615 .37094 L
s
.53129 .36249 m
.51615 .37094 L
s
.53124 .36388 m
.51615 .37094 L
s
.5312 .36542 m
.51615 .37094 L
s
.01 w
.51439 .37306 Mdot
.5 Mabswid
.51439 .37306 m
.49942 .36888 L
s
.51439 .37306 m
.49725 .37048 L
s
.49749 .37189 m
.51439 .37306 L
s
.5136 .37432 m
.51439 .37306 L
s
.51085 .3618 m
.51439 .37306 L
s
.50954 .36352 m
.51439 .37306 L
s
.50887 .36449 m
.51439 .37306 L
s
.53124 .36388 m
.51439 .37306 L
s
.5312 .36542 m
.51439 .37306 L
s
.53118 .36639 m
.51439 .37306 L
s
.01 w
.78175 .51648 Mdot
.5 Mabswid
.78175 .51648 m
.8168 .50205 L
s
.78175 .51648 m
.80661 .51539 L
s
.78175 .51648 m
.79674 .50669 L
s
.78175 .51648 m
.7925 .50502 L
s
.78175 .51648 m
.78261 .49327 L
s
.78175 .51648 m
.77899 .52244 L
s
.01 w
.28564 .52527 Mdot
.5 Mabswid
.28564 .52527 m
.28298 .52746 L
s
.26924 .51162 m
.28564 .52527 L
s
.27181 .50929 m
.28564 .52527 L
s
.27525 .5058 m
.28564 .52527 L
s
.01 w
.5136 .37432 Mdot
.5 Mabswid
.5136 .37432 m
.49725 .37048 L
s
.5136 .37432 m
.49749 .37189 L
s
.50954 .36352 m
.5136 .37432 L
s
.50887 .36449 m
.5136 .37432 L
s
.5312 .36542 m
.5136 .37432 L
s
.53118 .36639 m
.5136 .37432 L
s
.01 w
.56891 .36183 Mdot
.5 Mabswid
.57143 .36859 m
.56891 .36183 L
s
.54956 .36378 m
.56891 .36183 L
s
.55165 .36597 m
.56891 .36183 L
s
.01 w
.61934 .3762 Mdot
.5 Mabswid
.61934 .3762 m
.6484 .38462 L
s
.61998 .38142 m
.61934 .3762 L
s
.59539 .37039 m
.61934 .3762 L
s
.5881 .37542 m
.61934 .3762 L
s
.01 w
.77899 .52244 Mdot
.5 Mabswid
.77899 .52244 m
.79747 .51013 L
s
.77899 .52244 m
.79674 .50669 L
s
.77899 .52244 m
.7925 .50502 L
s
.77899 .52244 m
.78087 .52482 L
s
.01 w
.28298 .52746 Mdot
.5 Mabswid
.26924 .51162 m
.28298 .52746 L
s
.27181 .50929 m
.28298 .52746 L
s
.01 w
.6484 .38462 Mdot
.5 Mabswid
.6484 .38462 m
.67929 .39595 L
s
.64848 .39074 m
.6484 .38462 L
s
.61998 .38142 m
.6484 .38462 L
s
.01 w
.59539 .37039 Mdot
.5 Mabswid
.5881 .37542 m
.59539 .37039 L
s
.57143 .36859 m
.59539 .37039 L
s
.57208 .3714 m
.59539 .37039 L
s
.01 w
.69511 .43963 Mdot
.5 Mabswid
.69511 .43963 m
.71779 .4549 L
s
.69776 .43041 m
.69511 .43963 L
s
.66955 .41915 m
.69511 .43963 L
s
.6712 .41566 m
.69511 .43963 L
s
.01 w
.64031 .4048 Mdot
.5 Mabswid
.64031 .4048 m
.66955 .41915 L
s
.64031 .4048 m
.6712 .41566 L
s
.64169 .40185 m
.64031 .4048 L
s
.61119 .3902 m
.64031 .4048 L
s
.01 w
.47972 .37444 Mdot
.5 Mabswid
.47913 .37549 m
.47972 .37444 L
s
.47801 .36282 m
.47972 .37444 L
s
.47001 .36525 m
.47972 .37444 L
s
.01 w
.70406 .40163 Mdot
.5 Mabswid
.70406 .40163 m
.74109 .41669 L
s
.71297 .40985 m
.70406 .40163 L
s
.67929 .39595 m
.70406 .40163 L
s
.01 w
.78087 .52482 Mdot
.5 Mabswid
.78087 .52482 m
.79747 .51013 L
s
.78087 .52482 m
.79674 .50669 L
s
.01 w
.61119 .3902 Mdot
.5 Mabswid
.61119 .3902 m
.64169 .40185 L
s
.64687 .39717 m
.61119 .3902 L
s
.6111 .3843 m
.61119 .3902 L
s
.5881 .37542 m
.61119 .3902 L
s
.59212 .37743 m
.61119 .3902 L
s
.01 w
.67929 .39595 Mdot
.5 Mabswid
.67929 .39595 m
.71297 .40985 L
s
.68051 .40307 m
.67929 .39595 L
s
.64848 .39074 m
.67929 .39595 L
s
.01 w
.71779 .4549 Mdot
.5 Mabswid
.72129 .44553 m
.71779 .4549 L
s
.69776 .43041 m
.71779 .4549 L
s
.74015 .46219 m
.71779 .4549 L
s
.01 w
.66955 .41915 Mdot
.5 Mabswid
.66955 .41915 m
.69776 .43041 L
s
.6712 .41566 m
.66955 .41915 L
s
.64169 .40185 m
.66955 .41915 L
s
.01 w
.80661 .51539 Mdot
.5 Mabswid
.80661 .51539 m
.8168 .50205 L
s
.83904 .50495 m
.80661 .51539 L
s
.01 w
.61998 .38142 Mdot
.5 Mabswid
.61998 .38142 m
.64848 .39074 L
s
.6111 .3843 m
.61998 .38142 L
s
.5881 .37542 m
.61998 .38142 L
s
.59212 .37743 m
.61998 .38142 L
s
.01 w
.57143 .36859 Mdot
.5 Mabswid
.57143 .36859 m
.58177 .36674 L
s
.57143 .36859 m
.56315 .3624 L
s
.57143 .36859 m
.56531 .36322 L
s
.57143 .36859 m
.5881 .37542 L
s
.57208 .3714 m
.57143 .36859 L
s
.54956 .36378 m
.57143 .36859 L
s
.55165 .36597 m
.57143 .36859 L
s
.55286 .36795 m
.57143 .36859 L
s
.01 w
.64169 .40185 Mdot
.5 Mabswid
.64169 .40185 m
.6712 .41566 L
s
.67662 .40968 m
.64169 .40185 L
s
.64687 .39717 m
.64169 .40185 L
s
.6111 .3843 m
.64169 .40185 L
s
.01 w
.49942 .36888 Mdot
.5 Mabswid
.49942 .36888 m
.48084 .37386 L
s
.49725 .37048 m
.49942 .36888 L
s
.47411 .36407 m
.49942 .36888 L
s
.49107 .36045 m
.49942 .36888 L
s
.49026 .36315 m
.49942 .36888 L
s
.51306 .36006 m
.49942 .36888 L
s
.51085 .3618 m
.49942 .36888 L
s
.50954 .36352 m
.49942 .36888 L
s
.01 w
.54956 .36378 Mdot
.5 Mabswid
.54956 .36378 m
.56315 .3624 L
s
.54956 .36378 m
.54416 .35693 L
s
.54956 .36378 m
.54642 .35774 L
s
.54956 .36378 m
.53135 .36029 L
s
.55165 .36597 m
.54956 .36378 L
s
.53129 .36249 m
.54956 .36378 L
s
.53124 .36388 m
.54956 .36378 L
s
.01 w
.64848 .39074 Mdot
.5 Mabswid
.64848 .39074 m
.68051 .40307 L
s
.64687 .39717 m
.64848 .39074 L
s
.6111 .3843 m
.64848 .39074 L
s
.01 w
.49749 .37189 Mdot
.5 Mabswid
.49749 .37189 m
.48084 .37386 L
s
.49749 .37189 m
.49725 .37048 L
s
.49749 .37189 m
.47913 .37549 L
s
.49026 .36315 m
.49749 .37189 L
s
.48955 .36452 m
.49749 .37189 L
s
.50954 .36352 m
.49749 .37189 L
s
.50887 .36449 m
.49749 .37189 L
s
.01 w
.49725 .37048 Mdot
.5 Mabswid
.49725 .37048 m
.48084 .37386 L
s
.47913 .37549 m
.49725 .37048 L
s
.47411 .36407 m
.49725 .37048 L
s
.49107 .36045 m
.49725 .37048 L
s
.49026 .36315 m
.49725 .37048 L
s
.48955 .36452 m
.49725 .37048 L
s
.51085 .3618 m
.49725 .37048 L
s
.50954 .36352 m
.49725 .37048 L
s
.50887 .36449 m
.49725 .37048 L
s
.01 w
.58425 .37376 Mdot
.5 Mabswid
.58425 .37376 m
.58312 .36156 L
s
.58425 .37376 m
.58351 .36601 L
s
.59212 .37743 m
.58425 .37376 L
s
.01 w
.74109 .41669 Mdot
.5 Mabswid
.74109 .41669 m
.78416 .43326 L
s
.74876 .4266 m
.74109 .41669 L
s
.71297 .40985 m
.74109 .41669 L
s
.01 w
.53135 .36029 Mdot
.5 Mabswid
.53135 .36029 m
.54416 .35693 L
s
.53135 .36029 m
.52178 .35462 L
s
.53403 .35082 m
.53135 .36029 L
s
.51306 .36006 m
.53135 .36029 L
s
.53129 .36249 m
.53135 .36029 L
s
.01 w
.5881 .37542 Mdot
.5 Mabswid
.5881 .37542 m
.58177 .36674 L
s
.5881 .37542 m
.56315 .3624 L
s
.5881 .37542 m
.56531 .36322 L
s
.5881 .37542 m
.61407 .38088 L
s
.5881 .37542 m
.58351 .36601 L
s
.5881 .37542 m
.6111 .3843 L
s
.59212 .37743 m
.5881 .37542 L
s
.57208 .3714 m
.5881 .37542 L
s
.57271 .3729 m
.5881 .37542 L
s
.01 w
.57208 .3714 Mdot
.5 Mabswid
.57208 .3714 m
.58177 .36674 L
s
.57208 .3714 m
.56315 .3624 L
s
.57208 .3714 m
.56531 .36322 L
s
.57208 .3714 m
.58351 .36601 L
s
.57208 .3714 m
.56502 .36355 L
s
.57208 .3714 m
.59212 .37743 L
s
.57271 .3729 m
.57208 .3714 L
s
.55165 .36597 m
.57208 .3714 L
s
.55286 .36795 m
.57208 .3714 L
s
.55346 .36909 m
.57208 .3714 L
s
.01 w
.55165 .36597 Mdot
.5 Mabswid
.55165 .36597 m
.56315 .3624 L
s
.55165 .36597 m
.56531 .36322 L
s
.55165 .36597 m
.54416 .35693 L
s
.55165 .36597 m
.54642 .35774 L
s
.55165 .36597 m
.54808 .35837 L
s
.55286 .36795 m
.55165 .36597 L
s
.53129 .36249 m
.55165 .36597 L
s
.53124 .36388 m
.55165 .36597 L
s
.5312 .36542 m
.55165 .36597 L
s
.01 w
.71297 .40985 Mdot
.5 Mabswid
.71297 .40985 m
.74876 .4266 L
s
.71092 .41687 m
.71297 .40985 L
s
.68051 .40307 m
.71297 .40985 L
s
.01 w
.47913 .37549 Mdot
.5 Mabswid
.47913 .37549 m
.48084 .37386 L
s
.47913 .37549 m
.45036 .37881 L
s
.47913 .37549 m
.44811 .37426 L
s
.47801 .36282 m
.47913 .37549 L
s
.45071 .36862 m
.47913 .37549 L
s
.47411 .36407 m
.47913 .37549 L
s
.47001 .36525 m
.47913 .37549 L
s
.49026 .36315 m
.47913 .37549 L
s
.48955 .36452 m
.47913 .37549 L
s
.01 w
.59212 .37743 Mdot
.5 Mabswid
.59212 .37743 m
.58177 .36674 L
s
.59212 .37743 m
.61407 .38088 L
s
.59212 .37743 m
.58312 .36156 L
s
.59212 .37743 m
.58351 .36601 L
s
.59212 .37743 m
.6111 .3843 L
s
.57271 .3729 m
.59212 .37743 L
s
.01 w
.6712 .41566 Mdot
.5 Mabswid
.6712 .41566 m
.69776 .43041 L
s
.70028 .42036 m
.6712 .41566 L
s
.67662 .40968 m
.6712 .41566 L
s
.64687 .39717 m
.6712 .41566 L
s
.01 w
.57271 .3729 Mdot
.5 Mabswid
.57271 .3729 m
.58177 .36674 L
s
.57271 .3729 m
.56531 .36322 L
s
.57271 .3729 m
.58351 .36601 L
s
.57271 .3729 m
.56502 .36355 L
s
.55286 .36795 m
.57271 .3729 L
s
.55346 .36909 m
.57271 .3729 L
s
.01 w
.55286 .36795 Mdot
.5 Mabswid
.55286 .36795 m
.56315 .3624 L
s
.55286 .36795 m
.56531 .36322 L
s
.55286 .36795 m
.54642 .35774 L
s
.55286 .36795 m
.54808 .35837 L
s
.55286 .36795 m
.56502 .36355 L
s
.55286 .36795 m
.54881 .35896 L
s
.55346 .36909 m
.55286 .36795 L
s
.53124 .36388 m
.55286 .36795 L
s
.5312 .36542 m
.55286 .36795 L
s
.53118 .36639 m
.55286 .36795 L
s
.01 w
.53129 .36249 Mdot
.5 Mabswid
.53129 .36249 m
.54416 .35693 L
s
.53129 .36249 m
.54642 .35774 L
s
.53129 .36249 m
.52178 .35462 L
s
.53129 .36249 m
.52005 .35504 L
s
.53129 .36249 m
.53403 .35082 L
s
.53129 .36249 m
.53431 .35142 L
s
.53129 .36249 m
.51306 .36006 L
s
.53129 .36249 m
.51085 .3618 L
s
.53124 .36388 m
.53129 .36249 L
s
.01 w
.27723 .51765 Mdot
.5 Mabswid
.26165 .50016 m
.27723 .51765 L
s
.27525 .5058 m
.27723 .51765 L
s
.01 w
.48084 .37386 Mdot
.5 Mabswid
.45036 .37881 m
.48084 .37386 L
s
.44811 .37426 m
.48084 .37386 L
s
.45071 .36862 m
.48084 .37386 L
s
.47411 .36407 m
.48084 .37386 L
s
.47001 .36525 m
.48084 .37386 L
s
.49107 .36045 m
.48084 .37386 L
s
.49026 .36315 m
.48084 .37386 L
s
.48955 .36452 m
.48084 .37386 L
s
.01 w
.68051 .40307 Mdot
.5 Mabswid
.68051 .40307 m
.71092 .41687 L
s
.67662 .40968 m
.68051 .40307 L
s
.64687 .39717 m
.68051 .40307 L
s
.01 w
.6111 .3843 Mdot
.5 Mabswid
.6111 .3843 m
.58177 .36674 L
s
.6111 .3843 m
.6447 .39283 L
s
.6111 .3843 m
.61407 .38088 L
s
.6111 .3843 m
.58351 .36601 L
s
.6111 .3843 m
.64687 .39717 L
s
.01 w
.55346 .36909 Mdot
.5 Mabswid
.55346 .36909 m
.56531 .36322 L
s
.55346 .36909 m
.54808 .35837 L
s
.55346 .36909 m
.56502 .36355 L
s
.55346 .36909 m
.54881 .35896 L
s
.5312 .36542 m
.55346 .36909 L
s
.53118 .36639 m
.55346 .36909 L
s
.01 w
.88916 .45817 Mdot
.5 Mabswid
.88916 .45817 m
.91145 .46492 L
s
.88916 .45817 m
.89988 .46374 L
s
.88916 .45817 m
.87809 .45948 L
s
.86141 .45198 m
.88916 .45817 L
s
.01 w
.53124 .36388 Mdot
.5 Mabswid
.53124 .36388 m
.54416 .35693 L
s
.53124 .36388 m
.54642 .35774 L
s
.53124 .36388 m
.54808 .35837 L
s
.53124 .36388 m
.52178 .35462 L
s
.53124 .36388 m
.52005 .35504 L
s
.53124 .36388 m
.51878 .35535 L
s
.53124 .36388 m
.53403 .35082 L
s
.53124 .36388 m
.53431 .35142 L
s
.53124 .36388 m
.53448 .35246 L
s
.53124 .36388 m
.51306 .36006 L
s
.53124 .36388 m
.51085 .3618 L
s
.53124 .36388 m
.50954 .36352 L
s
.5312 .36542 m
.53124 .36388 L
s
.01 w
.49397 .35435 Mdot
.5 Mabswid
.49397 .35435 m
.47212 .3527 L
s
.49107 .36045 m
.49397 .35435 L
s
.51306 .36006 m
.49397 .35435 L
s
.51085 .3618 m
.49397 .35435 L
s
.01 w
.86141 .45198 Mdot
.5 Mabswid
.86141 .45198 m
.87809 .45948 L
s
.86141 .45198 m
.84972 .45427 L
s
.827 .44443 m
.86141 .45198 L
s
.01 w
.91145 .46492 Mdot
.5 Mabswid
.91145 .46492 m
.92853 .47398 L
s
.91145 .46492 m
.91433 .47219 L
s
.89988 .46374 m
.91145 .46492 L
s
.01 w
.51306 .36006 Mdot
.5 Mabswid
.51306 .36006 m
.50244 .35627 L
s
.51306 .36006 m
.52178 .35462 L
s
.51306 .36006 m
.52005 .35504 L
s
.51306 .36006 m
.49107 .36045 L
s
.51085 .3618 m
.51306 .36006 L
s
.01 w
.69776 .43041 Mdot
.5 Mabswid
.69776 .43041 m
.72129 .44553 L
s
.72533 .43624 m
.69776 .43041 L
s
.70028 .42036 m
.69776 .43041 L
s
.67662 .40968 m
.69776 .43041 L
s
.01 w
.5312 .36542 Mdot
.5 Mabswid
.5312 .36542 m
.54642 .35774 L
s
.5312 .36542 m
.54808 .35837 L
s
.5312 .36542 m
.52005 .35504 L
s
.5312 .36542 m
.51878 .35535 L
s
.5312 .36542 m
.54881 .35896 L
s
.5312 .36542 m
.51823 .35584 L
s
.5312 .36542 m
.53431 .35142 L
s
.5312 .36542 m
.53448 .35246 L
s
.5312 .36542 m
.53458 .35311 L
s
.5312 .36542 m
.51085 .3618 L
s
.5312 .36542 m
.50954 .36352 L
s
.5312 .36542 m
.50887 .36449 L
s
.53118 .36639 m
.5312 .36542 L
s
.01 w
.827 .44443 Mdot
.5 Mabswid
.827 .44443 m
.84972 .45427 L
s
.827 .44443 m
.8162 .44877 L
s
.78416 .43326 m
.827 .44443 L
s
.01 w
.78416 .43326 Mdot
.5 Mabswid
.78416 .43326 m
.8162 .44877 L
s
.78351 .43983 m
.78416 .43326 L
s
.74876 .4266 m
.78416 .43326 L
s
.01 w
.89988 .46374 Mdot
.5 Mabswid
.89988 .46374 m
.91433 .47219 L
s
.89988 .46374 m
.89455 .46943 L
s
.87809 .45948 m
.89988 .46374 L
s
.01 w
.64687 .39717 Mdot
.5 Mabswid
.64687 .39717 m
.67513 .40473 L
s
.64687 .39717 m
.6447 .39283 L
s
.64687 .39717 m
.61407 .38088 L
s
.64687 .39717 m
.67662 .40968 L
s
.01 w
.53118 .36639 Mdot
.5 Mabswid
.53118 .36639 m
.54808 .35837 L
s
.53118 .36639 m
.51878 .35535 L
s
.53118 .36639 m
.54881 .35896 L
s
.53118 .36639 m
.51823 .35584 L
s
.53118 .36639 m
.53448 .35246 L
s
.53118 .36639 m
.53458 .35311 L
s
.53118 .36639 m
.50954 .36352 L
s
.53118 .36639 m
.50887 .36449 L
s
.01 w
.51085 .3618 Mdot
.5 Mabswid
.51085 .3618 m
.50244 .35627 L
s
.51085 .3618 m
.50054 .3567 L
s
.51085 .3618 m
.52178 .35462 L
s
.51085 .3618 m
.52005 .35504 L
s
.51085 .3618 m
.51878 .35535 L
s
.51085 .3618 m
.49107 .36045 L
s
.51085 .3618 m
.49026 .36315 L
s
.50954 .36352 m
.51085 .3618 L
s
.01 w
.87809 .45948 Mdot
.5 Mabswid
.87809 .45948 m
.89455 .46943 L
s
.87809 .45948 m
.87111 .46544 L
s
.84972 .45427 m
.87809 .45948 L
s
.01 w
.72129 .44553 Mdot
.5 Mabswid
.72533 .43624 m
.72129 .44553 L
s
.74015 .46219 m
.72129 .44553 L
s
.01 w
.74876 .4266 Mdot
.5 Mabswid
.74876 .4266 m
.78351 .43983 L
s
.74876 .4266 m
.76656 .44355 L
s
.7343 .43147 m
.74876 .4266 L
s
.71092 .41687 m
.74876 .4266 L
s
.01 w
.47212 .3527 Mdot
.5 Mabswid
.47212 .3527 m
.44758 .35317 L
s
.46715 .35737 m
.47212 .3527 L
s
.49107 .36045 m
.47212 .3527 L
s
.01 w
.71092 .41687 Mdot
.5 Mabswid
.71092 .41687 m
.7343 .43147 L
s
.70028 .42036 m
.71092 .41687 L
s
.67662 .40968 m
.71092 .41687 L
s
.01 w
.92853 .47398 Mdot
.5 Mabswid
.92853 .47398 m
.94205 .48339 L
s
.92853 .47398 m
.92779 .48187 L
s
.91433 .47219 m
.92853 .47398 L
s
.01 w
.50954 .36352 Mdot
.5 Mabswid
.50954 .36352 m
.50244 .35627 L
s
.50954 .36352 m
.50054 .3567 L
s
.50954 .36352 m
.52005 .35504 L
s
.50954 .36352 m
.51878 .35535 L
s
.50954 .36352 m
.50107 .35709 L
s
.50954 .36352 m
.51823 .35584 L
s
.50954 .36352 m
.49107 .36045 L
s
.50954 .36352 m
.49026 .36315 L
s
.50954 .36352 m
.48955 .36452 L
s
.50887 .36449 m
.50954 .36352 L
s
.01 w
.84972 .45427 Mdot
.5 Mabswid
.84972 .45427 m
.87111 .46544 L
s
.84972 .45427 m
.84575 .46264 L
s
.8162 .44877 m
.84972 .45427 L
s
.01 w
.74015 .46219 Mdot
.5 Mabswid
.74015 .46219 m
.76481 .45868 L
s
.74015 .46219 m
.75083 .44922 L
s
.74015 .46219 m
.72533 .43624 L
s
.74015 .46219 m
.75615 .475 L
s
.01 w
.50887 .36449 Mdot
.5 Mabswid
.50887 .36449 m
.50054 .3567 L
s
.50887 .36449 m
.51878 .35535 L
s
.50887 .36449 m
.50107 .35709 L
s
.50887 .36449 m
.51823 .35584 L
s
.50887 .36449 m
.49026 .36315 L
s
.50887 .36449 m
.48955 .36452 L
s
.01 w
.67662 .40968 Mdot
.5 Mabswid
.67662 .40968 m
.7029 .41692 L
s
.67662 .40968 m
.67513 .40473 L
s
.67662 .40968 m
.6447 .39283 L
s
.67662 .40968 m
.70028 .42036 L
s
.01 w
.91433 .47219 Mdot
.5 Mabswid
.91433 .47219 m
.92779 .48187 L
s
.91433 .47219 m
.90862 .48017 L
s
.89455 .46943 m
.91433 .47219 L
s
.01 w
.49107 .36045 Mdot
.5 Mabswid
.49107 .36045 m
.48469 .35705 L
s
.49107 .36045 m
.50244 .35627 L
s
.49107 .36045 m
.50054 .3567 L
s
.49107 .36045 m
.46715 .35737 L
s
.49107 .36045 m
.47411 .36407 L
s
.49026 .36315 m
.49107 .36045 L
s
.01 w
.75615 .475 Mdot
.5 Mabswid
.75615 .475 m
.77985 .468 L
s
.75615 .475 m
.76481 .45868 L
s
.75615 .475 m
.75083 .44922 L
s
.75615 .475 m
.76921 .48448 L
s
.01 w
.78351 .43983 Mdot
.5 Mabswid
.78351 .43983 m
.8162 .44877 L
s
.78351 .43983 m
.79732 .45204 L
s
.76656 .44355 m
.78351 .43983 L
s
.01 w
.7925 .50502 Mdot
.5 Mabswid
.7925 .50502 m
.8168 .50205 L
s
.7925 .50502 m
.8099 .48496 L
s
.7925 .50502 m
.79674 .50669 L
s
.78261 .49327 m
.7925 .50502 L
s
.01 w
.56315 .3624 Mdot
.5 Mabswid
.56315 .3624 m
.56608 .35342 L
s
.56315 .3624 m
.58177 .36674 L
s
.56315 .3624 m
.55822 .35452 L
s
.56315 .3624 m
.56074 .35484 L
s
.56531 .36322 m
.56315 .3624 L
s
.54416 .35693 m
.56315 .3624 L
s
.54642 .35774 m
.56315 .3624 L
s
.54808 .35837 m
.56315 .3624 L
s
.01 w
.61407 .38088 Mdot
.5 Mabswid
.61407 .38088 m
.58177 .36674 L
s
.61407 .38088 m
.64511 .39038 L
s
.61407 .38088 m
.6447 .39283 L
s
.61407 .38088 m
.61221 .37612 L
s
.58351 .36601 m
.61407 .38088 L
s
.01 w
.8162 .44877 Mdot
.5 Mabswid
.8162 .44877 m
.84575 .46264 L
s
.8162 .44877 m
.82361 .46319 L
s
.79732 .45204 m
.8162 .44877 L
s
.01 w
.89455 .46943 Mdot
.5 Mabswid
.89455 .46943 m
.90862 .48017 L
s
.89455 .46943 m
.88693 .47745 L
s
.87111 .46544 m
.89455 .46943 L
s
.01 w
.54416 .35693 Mdot
.5 Mabswid
.54416 .35693 m
.54623 .34817 L
s
.54416 .35693 m
.55822 .35452 L
s
.54642 .35774 m
.54416 .35693 L
s
.53403 .35082 m
.54416 .35693 L
s
.53431 .35142 m
.54416 .35693 L
s
.01 w
.45036 .37881 Mdot
.5 Mabswid
.45036 .37881 m
.41685 .38328 L
s
.45036 .37881 m
.41695 .38027 L
s
.44811 .37426 m
.45036 .37881 L
s
.01 w
.30028 .48696 Mdot
.5 Mabswid
.30028 .48696 m
.29696 .48961 L
s
.2928 .47014 m
.30028 .48696 L
s
.30286 .46227 m
.30028 .48696 L
s
.01 w
.49026 .36315 Mdot
.5 Mabswid
.49026 .36315 m
.48469 .35705 L
s
.49026 .36315 m
.50244 .35627 L
s
.49026 .36315 m
.50054 .3567 L
s
.49026 .36315 m
.48359 .35599 L
s
.49026 .36315 m
.50107 .35709 L
s
.49026 .36315 m
.46715 .35737 L
s
.49026 .36315 m
.47411 .36407 L
s
.49026 .36315 m
.47001 .36525 L
s
.48955 .36452 m
.49026 .36315 L
s
.01 w
.83904 .50495 Mdot
.5 Mabswid
.83904 .50495 m
.8168 .50205 L
s
.83904 .50495 m
.84986 .49566 L
s
.8738 .49675 m
.83904 .50495 L
s
.01 w
.46715 .35737 Mdot
.5 Mabswid
.46715 .35737 m
.44758 .35317 L
s
.46715 .35737 m
.44293 .35861 L
s
.47411 .36407 m
.46715 .35737 L
s
.01 w
.76921 .48448 Mdot
.5 Mabswid
.76921 .48448 m
.793 .47416 L
s
.76921 .48448 m
.77985 .468 L
s
.76921 .48448 m
.76481 .45868 L
s
.76921 .48448 m
.78261 .49327 L
s
.01 w
.56531 .36322 Mdot
.5 Mabswid
.56531 .36322 m
.56608 .35342 L
s
.56531 .36322 m
.58177 .36674 L
s
.56531 .36322 m
.55822 .35452 L
s
.56531 .36322 m
.56074 .35484 L
s
.54642 .35774 m
.56531 .36322 L
s
.54808 .35837 m
.56531 .36322 L
s
.58351 .36601 m
.56531 .36322 L
s
.56252 .35476 m
.56531 .36322 L
s
.56502 .36355 m
.56531 .36322 L
s
.54881 .35896 m
.56531 .36322 L
s
.01 w
.87111 .46544 Mdot
.5 Mabswid
.87111 .46544 m
.88693 .47745 L
s
.87111 .46544 m
.8663 .4736 L
s
.84575 .46264 m
.87111 .46544 L
s
.01 w
.70028 .42036 Mdot
.5 Mabswid
.70028 .42036 m
.7029 .41692 L
s
.70028 .42036 m
.67513 .40473 L
s
.70028 .42036 m
.7343 .43147 L
s
.70028 .42036 m
.72533 .43624 L
s
.01 w
.29696 .48961 Mdot
.5 Mabswid
.29696 .48961 m
.28975 .49492 L
s
.28255 .47667 m
.29696 .48961 L
s
.2928 .47014 m
.29696 .48961 L
s
.30286 .46227 m
.29696 .48961 L
s
.01 w
.94205 .48339 Mdot
.5 Mabswid
.94205 .48339 m
.95155 .492 L
s
.94205 .48339 m
.93929 .4911 L
s
.92779 .48187 m
.94205 .48339 L
s
.01 w
.44758 .35317 Mdot
.5 Mabswid
.44758 .35317 m
.42082 .35642 L
s
.44293 .35861 m
.44758 .35317 L
s
.01 w
.48955 .36452 Mdot
.5 Mabswid
.48955 .36452 m
.48469 .35705 L
s
.48955 .36452 m
.50054 .3567 L
s
.48955 .36452 m
.48359 .35599 L
s
.48955 .36452 m
.50107 .35709 L
s
.48955 .36452 m
.47411 .36407 L
s
.48955 .36452 m
.47001 .36525 L
s
.01 w
.6447 .39283 Mdot
.5 Mabswid
.6447 .39283 m
.67557 .40241 L
s
.6447 .39283 m
.67513 .40473 L
s
.6447 .39283 m
.64511 .39038 L
s
.61221 .37612 m
.6447 .39283 L
s
.01 w
.56502 .36355 Mdot
.5 Mabswid
.56502 .36355 m
.58177 .36674 L
s
.56502 .36355 m
.56074 .35484 L
s
.56502 .36355 m
.54808 .35837 L
s
.56502 .36355 m
.58351 .36601 L
s
.56502 .36355 m
.56252 .35476 L
s
.54881 .35896 m
.56502 .36355 L
s
.01 w
.47801 .36282 Mdot
.5 Mabswid
.47801 .36282 m
.48508 .35145 L
s
.48359 .35599 m
.47801 .36282 L
s
.47001 .36525 m
.47801 .36282 L
s
.01 w
.28975 .49492 Mdot
.5 Mabswid
.28975 .49492 m
.28221 .50045 L
s
.27175 .48271 m
.28975 .49492 L
s
.28255 .47667 m
.28975 .49492 L
s
.2928 .47014 m
.28975 .49492 L
s
.01 w
.52178 .35462 Mdot
.5 Mabswid
.52178 .35462 m
.52524 .34602 L
s
.52178 .35462 m
.5112 .34973 L
s
.52178 .35462 m
.50244 .35627 L
s
.52005 .35504 m
.52178 .35462 L
s
.53403 .35082 m
.52178 .35462 L
s
.53431 .35142 m
.52178 .35462 L
s
.01 w
.7343 .43147 Mdot
.5 Mabswid
.7343 .43147 m
.76656 .44355 L
s
.7343 .43147 m
.75083 .44922 L
s
.72533 .43624 m
.7343 .43147 L
s
.01 w
.92779 .48187 Mdot
.5 Mabswid
.92779 .48187 m
.93929 .4911 L
s
.92779 .48187 m
.92059 .49009 L
s
.90862 .48017 m
.92779 .48187 L
s
.01 w
.54642 .35774 Mdot
.5 Mabswid
.54642 .35774 m
.54623 .34817 L
s
.54642 .35774 m
.54753 .34827 L
s
.54642 .35774 m
.55822 .35452 L
s
.54642 .35774 m
.56074 .35484 L
s
.54808 .35837 m
.54642 .35774 L
s
.53403 .35082 m
.54642 .35774 L
s
.53431 .35142 m
.54642 .35774 L
s
.53448 .35246 m
.54642 .35774 L
s
.01 w
.78261 .49327 Mdot
.5 Mabswid
.78261 .49327 m
.8099 .48496 L
s
.78261 .49327 m
.793 .47416 L
s
.78261 .49327 m
.77985 .468 L
s
.01 w
.58177 .36674 Mdot
.5 Mabswid
.58177 .36674 m
.56608 .35342 L
s
.55822 .35452 m
.58177 .36674 L
s
.56074 .35484 m
.58177 .36674 L
s
.58656 .36054 m
.58177 .36674 L
s
.61221 .37612 m
.58177 .36674 L
s
.57047 .35233 m
.58177 .36674 L
s
.58351 .36601 m
.58177 .36674 L
s
.56252 .35476 m
.58177 .36674 L
s
.01 w
.84575 .46264 Mdot
.5 Mabswid
.84575 .46264 m
.8663 .4736 L
s
.84575 .46264 m
.84731 .47645 L
s
.82361 .46319 m
.84575 .46264 L
s
.01 w
.28221 .50045 Mdot
.5 Mabswid
.28221 .50045 m
.27525 .5058 L
s
.26285 .4884 m
.28221 .50045 L
s
.27175 .48271 m
.28221 .50045 L
s
.28255 .47667 m
.28221 .50045 L
s
.01 w
.47411 .36407 Mdot
.5 Mabswid
.47411 .36407 m
.48469 .35705 L
s
.47411 .36407 m
.50244 .35627 L
s
.47411 .36407 m
.50054 .3567 L
s
.47411 .36407 m
.44811 .37426 L
s
.47411 .36407 m
.45011 .36481 L
s
.47411 .36407 m
.48359 .35599 L
s
.47411 .36407 m
.44293 .35861 L
s
.47411 .36407 m
.44203 .36387 L
s
.47411 .36407 m
.45071 .36862 L
s
.47001 .36525 m
.47411 .36407 L
s
.01 w
.8168 .50205 Mdot
.5 Mabswid
.84986 .49566 m
.8168 .50205 L
s
.83765 .48673 m
.8168 .50205 L
s
.8099 .48496 m
.8168 .50205 L
s
.01 w
.94668 .4958 Mdot
.5 Mabswid
.94668 .4958 m
.92961 .49507 L
s
.95155 .492 m
.94668 .4958 L
s
.93929 .4911 m
.94668 .4958 L
s
.01 w
.54808 .35837 Mdot
.5 Mabswid
.54808 .35837 m
.54623 .34817 L
s
.54808 .35837 m
.54753 .34827 L
s
.54808 .35837 m
.55822 .35452 L
s
.54808 .35837 m
.56074 .35484 L
s
.54832 .34948 m
.54808 .35837 L
s
.56252 .35476 m
.54808 .35837 L
s
.54881 .35896 m
.54808 .35837 L
s
.53431 .35142 m
.54808 .35837 L
s
.53448 .35246 m
.54808 .35837 L
s
.53458 .35311 m
.54808 .35837 L
s
.01 w
.90862 .48017 Mdot
.5 Mabswid
.90862 .48017 m
.92059 .49009 L
s
.90862 .48017 m
.89712 .48882 L
s
.88693 .47745 m
.90862 .48017 L
s
.01 w
.27525 .5058 Mdot
.5 Mabswid
.27525 .5058 m
.26165 .50016 L
s
.27525 .5058 m
.27181 .50929 L
s
.25946 .49229 m
.27525 .5058 L
s
.26285 .4884 m
.27525 .5058 L
s
.27175 .48271 m
.27525 .5058 L
s
.01 w
.76656 .44355 Mdot
.5 Mabswid
.76656 .44355 m
.79732 .45204 L
s
.76656 .44355 m
.78373 .45684 L
s
.76656 .44355 m
.76481 .45868 L
s
.75083 .44922 m
.76656 .44355 L
s
.01 w
.58351 .36601 Mdot
.5 Mabswid
.58351 .36601 m
.56608 .35342 L
s
.58351 .36601 m
.56074 .35484 L
s
.58351 .36601 m
.58656 .36054 L
s
.58351 .36601 m
.61221 .37612 L
s
.58351 .36601 m
.57254 .34994 L
s
.58351 .36601 m
.58312 .36156 L
s
.58351 .36601 m
.57047 .35233 L
s
.56252 .35476 m
.58351 .36601 L
s
.57417 .35136 m
.58351 .36601 L
s
.01 w
.79732 .45204 Mdot
.5 Mabswid
.79732 .45204 m
.82361 .46319 L
s
.79732 .45204 m
.8022 .46529 L
s
.78373 .45684 m
.79732 .45204 L
s
.01 w
.47001 .36525 Mdot
.5 Mabswid
.47001 .36525 m
.48469 .35705 L
s
.47001 .36525 m
.44811 .37426 L
s
.47001 .36525 m
.45011 .36481 L
s
.47001 .36525 m
.48508 .35145 L
s
.47001 .36525 m
.48359 .35599 L
s
.47001 .36525 m
.44203 .36387 L
s
.47001 .36525 m
.45071 .36862 L
s
.01 w
.52005 .35504 Mdot
.5 Mabswid
.52005 .35504 m
.52524 .34602 L
s
.52005 .35504 m
.5245 .34588 L
s
.52005 .35504 m
.5112 .34973 L
s
.52005 .35504 m
.50933 .3496 L
s
.52005 .35504 m
.50244 .35627 L
s
.52005 .35504 m
.50054 .3567 L
s
.51878 .35535 m
.52005 .35504 L
s
.53403 .35082 m
.52005 .35504 L
s
.53431 .35142 m
.52005 .35504 L
s
.53448 .35246 m
.52005 .35504 L
s
.01 w
.61221 .37612 Mdot
.5 Mabswid
.61221 .37612 m
.64511 .39038 L
s
.61221 .37612 m
.58656 .36054 L
s
.01 w
.95155 .492 Mdot
.5 Mabswid
.95155 .492 m
.94919 .49151 L
s
.95155 .492 m
.94563 .49833 L
s
.93929 .4911 m
.95155 .492 L
s
.01 w
.54881 .35896 Mdot
.5 Mabswid
.54881 .35896 m
.54753 .34827 L
s
.54881 .35896 m
.56074 .35484 L
s
.54881 .35896 m
.54832 .34948 L
s
.54881 .35896 m
.56252 .35476 L
s
.53448 .35246 m
.54881 .35896 L
s
.53458 .35311 m
.54881 .35896 L
s
.01 w
.58312 .36156 Mdot
.5 Mabswid
.58312 .36156 m
.57254 .34994 L
s
.57047 .35233 m
.58312 .36156 L
s
.01 w
.64511 .39038 Mdot
.5 Mabswid
.64511 .39038 m
.67557 .40241 L
s
.64511 .39038 m
.67513 .40473 L
s
.01 w
.92961 .49507 Mdot
.5 Mabswid
.92961 .49507 m
.90545 .4951 L
s
.93929 .4911 m
.92961 .49507 L
s
.92059 .49009 m
.92961 .49507 L
s
.01 w
.44293 .35861 Mdot
.5 Mabswid
.44293 .35861 m
.42082 .35642 L
s
.44293 .35861 m
.41346 .3616 L
s
.44203 .36387 m
.44293 .35861 L
s
.01 w
.27181 .50929 Mdot
.5 Mabswid
.27181 .50929 m
.26924 .51162 L
s
.25769 .49534 m
.27181 .50929 L
s
.25946 .49229 m
.27181 .50929 L
s
.26285 .4884 m
.27181 .50929 L
s
.01 w
.50244 .35627 Mdot
.5 Mabswid
.50244 .35627 m
.5053 .34722 L
s
.50244 .35627 m
.48469 .35705 L
s
.50244 .35627 m
.5112 .34973 L
s
.50244 .35627 m
.50933 .3496 L
s
.50054 .3567 m
.50244 .35627 L
s
.51878 .35535 m
.50244 .35627 L
s
.01 w
.44811 .37426 Mdot
.5 Mabswid
.44811 .37426 m
.41685 .38328 L
s
.44811 .37426 m
.41695 .38027 L
s
.41419 .37482 m
.44811 .37426 L
s
.45071 .36862 m
.44811 .37426 L
s
.01 w
.53403 .35082 Mdot
.5 Mabswid
.53403 .35082 m
.52524 .34602 L
s
.53403 .35082 m
.54623 .34817 L
s
.53403 .35082 m
.537 .33523 L
s
.53403 .35082 m
.53717 .33979 L
s
.53431 .35142 m
.53403 .35082 L
s
.01 w
.88693 .47745 Mdot
.5 Mabswid
.88693 .47745 m
.89712 .48882 L
s
.88693 .47745 m
.87291 .48641 L
s
.8663 .4736 m
.88693 .47745 L
s
.01 w
.67513 .40473 Mdot
.5 Mabswid
.67513 .40473 m
.70576 .41193 L
s
.67513 .40473 m
.7029 .41692 L
s
.67513 .40473 m
.67557 .40241 L
s
.01 w
.26924 .51162 Mdot
.5 Mabswid
.25769 .49534 m
.26924 .51162 L
s
.25946 .49229 m
.26924 .51162 L
s
.01 w
.93929 .4911 Mdot
.5 Mabswid
.93929 .4911 m
.93237 .49004 L
s
.93929 .4911 m
.94919 .49151 L
s
.93929 .4911 m
.94563 .49833 L
s
.93929 .4911 m
.93411 .49655 L
s
.92059 .49009 m
.93929 .4911 L
s
.01 w
.79674 .50669 Mdot
.5 Mabswid
.79674 .50669 m
.81011 .49364 L
s
.79674 .50669 m
.81311 .49298 L
s
.79674 .50669 m
.8099 .48496 L
s
.79674 .50669 m
.79747 .51013 L
s
.01 w
.8738 .49675 Mdot
.5 Mabswid
.8738 .49675 m
.84986 .49566 L
s
.90545 .4951 m
.8738 .49675 L
s
.89712 .48882 m
.8738 .49675 L
s
.87291 .48641 m
.8738 .49675 L
s
.01 w
.90545 .4951 Mdot
.5 Mabswid
.92059 .49009 m
.90545 .4951 L
s
.89712 .48882 m
.90545 .4951 L
s
.01 w
.8663 .4736 Mdot
.5 Mabswid
.8663 .4736 m
.87291 .48641 L
s
.84731 .47645 m
.8663 .4736 L
s
.01 w
.72533 .43624 Mdot
.5 Mabswid
.72533 .43624 m
.72842 .42782 L
s
.72533 .43624 m
.7029 .41692 L
s
.72533 .43624 m
.75083 .44922 L
s
.75019 .43806 m
.72533 .43624 L
s
.01 w
.51878 .35535 Mdot
.5 Mabswid
.51878 .35535 m
.52524 .34602 L
s
.51878 .35535 m
.5245 .34588 L
s
.51878 .35535 m
.5112 .34973 L
s
.51878 .35535 m
.50933 .3496 L
s
.51878 .35535 m
.50054 .3567 L
s
.52367 .34697 m
.51878 .35535 L
s
.50798 .34918 m
.51878 .35535 L
s
.50107 .35709 m
.51878 .35535 L
s
.51823 .35584 m
.51878 .35535 L
s
.53431 .35142 m
.51878 .35535 L
s
.53448 .35246 m
.51878 .35535 L
s
.53458 .35311 m
.51878 .35535 L
s
.01 w
.50054 .3567 Mdot
.5 Mabswid
.50054 .3567 m
.5053 .34722 L
s
.50054 .3567 m
.48469 .35705 L
s
.50054 .3567 m
.5112 .34973 L
s
.50054 .3567 m
.50933 .3496 L
s
.48359 .35599 m
.50054 .3567 L
s
.50798 .34918 m
.50054 .3567 L
s
.50107 .35709 m
.50054 .3567 L
s
.51823 .35584 m
.50054 .3567 L
s
.01 w
.82361 .46319 Mdot
.5 Mabswid
.82361 .46319 m
.84731 .47645 L
s
.82361 .46319 m
.82076 .47556 L
s
.8022 .46529 m
.82361 .46319 L
s
.01 w
.42082 .35642 Mdot
.5 Mabswid
.42082 .35642 m
.39034 .3614 L
s
.41346 .3616 m
.42082 .35642 L
s
.01 w
.79747 .51013 Mdot
.5 Mabswid
.79747 .51013 m
.81011 .49364 L
s
.79747 .51013 m
.81311 .49298 L
s
.01 w
.51823 .35584 Mdot
.5 Mabswid
.51823 .35584 m
.5245 .34588 L
s
.51823 .35584 m
.50933 .3496 L
s
.51823 .35584 m
.52367 .34697 L
s
.51823 .35584 m
.50798 .34918 L
s
.51823 .35584 m
.50107 .35709 L
s
.53448 .35246 m
.51823 .35584 L
s
.53458 .35311 m
.51823 .35584 L
s
.01 w
.50107 .35709 Mdot
.5 Mabswid
.50107 .35709 m
.48469 .35705 L
s
.50107 .35709 m
.50933 .3496 L
s
.50107 .35709 m
.48359 .35599 L
s
.50107 .35709 m
.50798 .34918 L
s
.01 w
.53431 .35142 Mdot
.5 Mabswid
.53431 .35142 m
.52524 .34602 L
s
.53431 .35142 m
.5245 .34588 L
s
.53431 .35142 m
.54623 .34817 L
s
.53431 .35142 m
.54753 .34827 L
s
.53431 .35142 m
.537 .33523 L
s
.53431 .35142 m
.53717 .33979 L
s
.53431 .35142 m
.53725 .34206 L
s
.53448 .35246 m
.53431 .35142 L
s
.01 w
.92059 .49009 Mdot
.5 Mabswid
.92059 .49009 m
.90936 .48765 L
s
.92059 .49009 m
.93237 .49004 L
s
.92059 .49009 m
.93411 .49655 L
s
.92059 .49009 m
.91702 .49608 L
s
.89712 .48882 m
.92059 .49009 L
s
.01 w
.44203 .36387 Mdot
.5 Mabswid
.44203 .36387 m
.41346 .3616 L
s
.44203 .36387 m
.41304 .36795 L
s
.45071 .36862 m
.44203 .36387 L
s
.01 w
.84986 .49566 Mdot
.5 Mabswid
.87291 .48641 m
.84986 .49566 L
s
.85927 .48827 m
.84986 .49566 L
s
.83765 .48673 m
.84986 .49566 L
s
.01 w
.94563 .49833 Mdot
.5 Mabswid
.94563 .49833 m
.93147 .50107 L
s
.93411 .49655 m
.94563 .49833 L
s
.01 w
.94919 .49151 Mdot
.5 Mabswid
.94919 .49151 m
.93237 .49004 L
s
.01 w
.55822 .35452 Mdot
.5 Mabswid
.55822 .35452 m
.55234 .34199 L
s
.55822 .35452 m
.54623 .34817 L
s
.55822 .35452 m
.54753 .34827 L
s
.55822 .35452 m
.56608 .35342 L
s
.56074 .35484 m
.55822 .35452 L
s
.01 w
.67557 .40241 Mdot
.5 Mabswid
.67557 .40241 m
.70576 .41193 L
s
.67557 .40241 m
.7029 .41692 L
s
.01 w
.78373 .45684 Mdot
.5 Mabswid
.78373 .45684 m
.8022 .46529 L
s
.78373 .45684 m
.77985 .468 L
s
.76481 .45868 m
.78373 .45684 L
s
.01 w
.45071 .36862 Mdot
.5 Mabswid
.45071 .36862 m
.48469 .35705 L
s
.45071 .36862 m
.41695 .38027 L
s
.45071 .36862 m
.41878 .37105 L
s
.45071 .36862 m
.45011 .36481 L
s
.45071 .36862 m
.48359 .35599 L
s
.45071 .36862 m
.41304 .36795 L
s
.45071 .36862 m
.41419 .37482 L
s
.01 w
.93411 .49655 Mdot
.5 Mabswid
.93411 .49655 m
.93147 .50107 L
s
.91702 .49608 m
.93411 .49655 L
s
.01 w
.53448 .35246 Mdot
.5 Mabswid
.53448 .35246 m
.52524 .34602 L
s
.53448 .35246 m
.5245 .34588 L
s
.53448 .35246 m
.54623 .34817 L
s
.53448 .35246 m
.54753 .34827 L
s
.53448 .35246 m
.52367 .34697 L
s
.53448 .35246 m
.54832 .34948 L
s
.53448 .35246 m
.53717 .33979 L
s
.53448 .35246 m
.53725 .34206 L
s
.53448 .35246 m
.53738 .34309 L
s
.53458 .35311 m
.53448 .35246 L
s
.01 w
.75083 .44922 Mdot
.5 Mabswid
.75083 .44922 m
.76481 .45868 L
s
.76822 .44681 m
.75083 .44922 L
s
.75019 .43806 m
.75083 .44922 L
s
.01 w
.7029 .41692 Mdot
.5 Mabswid
.7029 .41692 m
.73064 .42292 L
s
.7029 .41692 m
.72842 .42782 L
s
.7029 .41692 m
.70576 .41193 L
s
.01 w
.89712 .48882 Mdot
.5 Mabswid
.89712 .48882 m
.88078 .48296 L
s
.89712 .48882 m
.90936 .48765 L
s
.89712 .48882 m
.91702 .49608 L
s
.89712 .48882 m
.89703 .49516 L
s
.87291 .48641 m
.89712 .48882 L
s
.01 w
.41685 .38328 Mdot
.5 Mabswid
.41685 .38328 m
.38582 .39241 L
s
.41685 .38328 m
.38582 .3887 L
s
.41695 .38027 m
.41685 .38328 L
s
.01 w
.53458 .35311 Mdot
.5 Mabswid
.53458 .35311 m
.5245 .34588 L
s
.53458 .35311 m
.54753 .34827 L
s
.53458 .35311 m
.52367 .34697 L
s
.53458 .35311 m
.54832 .34948 L
s
.53458 .35311 m
.53725 .34206 L
s
.53458 .35311 m
.53738 .34309 L
s
.01 w
.84731 .47645 Mdot
.5 Mabswid
.84731 .47645 m
.87291 .48641 L
s
.84731 .47645 m
.85927 .48827 L
s
.84731 .47645 m
.83765 .48673 L
s
.82076 .47556 m
.84731 .47645 L
s
.01 w
.41346 .3616 Mdot
.5 Mabswid
.41346 .3616 m
.39034 .3614 L
s
.41346 .3616 m
.38172 .36729 L
s
.41304 .36795 m
.41346 .3616 L
s
.01 w
.58656 .36054 Mdot
.5 Mabswid
.58656 .36054 m
.56608 .35342 L
s
.57047 .35233 m
.58656 .36054 L
s
.57417 .35136 m
.58656 .36054 L
s
.01 w
.93237 .49004 Mdot
.5 Mabswid
.93237 .49004 m
.90936 .48765 L
s
.01 w
.56074 .35484 Mdot
.5 Mabswid
.56074 .35484 m
.55234 .34199 L
s
.56074 .35484 m
.54623 .34817 L
s
.56074 .35484 m
.54753 .34827 L
s
.56074 .35484 m
.56608 .35342 L
s
.55481 .34181 m
.56074 .35484 L
s
.54832 .34948 m
.56074 .35484 L
s
.57047 .35233 m
.56074 .35484 L
s
.56252 .35476 m
.56074 .35484 L
s
.01 w
.8022 .46529 Mdot
.5 Mabswid
.8022 .46529 m
.82076 .47556 L
s
.8022 .46529 m
.793 .47416 L
s
.77985 .468 m
.8022 .46529 L
s
.01 w
.91702 .49608 Mdot
.5 Mabswid
.91702 .49608 m
.93147 .50107 L
s
.91702 .49608 m
.91349 .50102 L
s
.89703 .49516 m
.91702 .49608 L
s
.01 w
.48469 .35705 Mdot
.5 Mabswid
.48469 .35705 m
.5053 .34722 L
s
.5112 .34973 m
.48469 .35705 L
s
.50933 .3496 m
.48469 .35705 L
s
.48364 .35014 m
.48469 .35705 L
s
.45426 .36053 m
.48469 .35705 L
s
.45011 .36481 m
.48469 .35705 L
s
.50204 .34534 m
.48469 .35705 L
s
.48359 .35599 m
.48469 .35705 L
s
.50798 .34918 m
.48469 .35705 L
s
.01 w
.26165 .50016 Mdot
.5 Mabswid
.24573 .48174 m
.26165 .50016 L
s
.26285 .4884 m
.26165 .50016 L
s
.01 w
.93147 .50107 Mdot
.5 Mabswid
.91349 .50102 m
.93147 .50107 L
s
.01 w
.56252 .35476 Mdot
.5 Mabswid
.56252 .35476 m
.55234 .34199 L
s
.56252 .35476 m
.54753 .34827 L
s
.56252 .35476 m
.56608 .35342 L
s
.56252 .35476 m
.55481 .34181 L
s
.56252 .35476 m
.54832 .34948 L
s
.56252 .35476 m
.57047 .35233 L
s
.01 w
.87291 .48641 Mdot
.5 Mabswid
.87291 .48641 m
.85697 .48126 L
s
.87291 .48641 m
.88078 .48296 L
s
.87291 .48641 m
.89703 .49516 L
s
.87291 .48641 m
.87847 .49522 L
s
.85927 .48827 m
.87291 .48641 L
s
.01 w
.76481 .45868 Mdot
.5 Mabswid
.76481 .45868 m
.77985 .468 L
s
.78248 .45425 m
.76481 .45868 L
s
.76822 .44681 m
.76481 .45868 L
s
.75019 .43806 m
.76481 .45868 L
s
.01 w
.5112 .34973 Mdot
.5 Mabswid
.5112 .34973 m
.52408 .33908 L
s
.5112 .34973 m
.52524 .34602 L
s
.5112 .34973 m
.5245 .34588 L
s
.5112 .34973 m
.5053 .34722 L
s
.50933 .3496 m
.5112 .34973 L
s
.01 w
.41695 .38027 Mdot
.5 Mabswid
.41695 .38027 m
.38582 .39241 L
s
.41695 .38027 m
.38582 .3887 L
s
.38347 .38193 m
.41695 .38027 L
s
.41419 .37482 m
.41695 .38027 L
s
.01 w
.48359 .35599 Mdot
.5 Mabswid
.48359 .35599 m
.5053 .34722 L
s
.48359 .35599 m
.50933 .3496 L
s
.48359 .35599 m
.48364 .35014 L
s
.48359 .35599 m
.45426 .36053 L
s
.48359 .35599 m
.45011 .36481 L
s
.48359 .35599 m
.50067 .34247 L
s
.48359 .35599 m
.48508 .35145 L
s
.48359 .35599 m
.50204 .34534 L
s
.50798 .34918 m
.48359 .35599 L
s
.49926 .34369 m
.48359 .35599 L
s
.01 w
.48508 .35145 Mdot
.5 Mabswid
.48508 .35145 m
.50067 .34247 L
s
.50204 .34534 m
.48508 .35145 L
s
.01 w
.89703 .49516 Mdot
.5 Mabswid
.89703 .49516 m
.91349 .50102 L
s
.89703 .49516 m
.89439 .50086 L
s
.87847 .49522 m
.89703 .49516 L
s
.01 w
.56608 .35342 Mdot
.5 Mabswid
.56608 .35342 m
.55234 .34199 L
s
.56608 .35342 m
.54623 .34817 L
s
.56608 .35342 m
.54753 .34827 L
s
.56526 .34257 m
.56608 .35342 L
s
.55481 .34181 m
.56608 .35342 L
s
.57047 .35233 m
.56608 .35342 L
s
.57417 .35136 m
.56608 .35342 L
s
.01 w
.82076 .47556 Mdot
.5 Mabswid
.82076 .47556 m
.83765 .48673 L
s
.82076 .47556 m
.8099 .48496 L
s
.793 .47416 m
.82076 .47556 L
s
.01 w
.39034 .3614 Mdot
.5 Mabswid
.39034 .3614 m
.35633 .36827 L
s
.38172 .36729 m
.39034 .3614 L
s
.01 w
.54623 .34817 Mdot
.5 Mabswid
.54623 .34817 m
.55234 .34199 L
s
.54753 .34827 m
.54623 .34817 L
s
.53934 .33445 m
.54623 .34817 L
s
.53717 .33979 m
.54623 .34817 L
s
.53725 .34206 m
.54623 .34817 L
s
.01 w
.91349 .50102 Mdot
.5 Mabswid
.89439 .50086 m
.91349 .50102 L
s
.01 w
.41304 .36795 Mdot
.5 Mabswid
.41304 .36795 m
.38172 .36729 L
s
.41304 .36795 m
.38003 .37438 L
s
.41419 .37482 m
.41304 .36795 L
s
.01 w
.30286 .46227 Mdot
.5 Mabswid
.30286 .46227 m
.32419 .43343 L
s
.30286 .46227 m
.2928 .47014 L
s
.29112 .45047 m
.30286 .46227 L
s
.30529 .44199 m
.30286 .46227 L
s
.01 w
.90936 .48765 Mdot
.5 Mabswid
.90936 .48765 m
.88078 .48296 L
s
.01 w
.45011 .36481 Mdot
.5 Mabswid
.45011 .36481 m
.41979 .36851 L
s
.45011 .36481 m
.41878 .37105 L
s
.45011 .36481 m
.45426 .36053 L
s
.41419 .37482 m
.45011 .36481 L
s
.01 w
.537 .33523 Mdot
.5 Mabswid
.537 .33523 m
.53991 .32199 L
s
.53717 .33979 m
.537 .33523 L
s
.01 w
.85927 .48827 Mdot
.5 Mabswid
.85927 .48827 m
.85697 .48126 L
s
.85927 .48827 m
.87847 .49522 L
s
.85927 .48827 m
.85783 .49485 L
s
.83765 .48673 m
.85927 .48827 L
s
.01 w
.50933 .3496 Mdot
.5 Mabswid
.50933 .3496 m
.52408 .33908 L
s
.50933 .3496 m
.52524 .34602 L
s
.50933 .3496 m
.5245 .34588 L
s
.50933 .3496 m
.5053 .34722 L
s
.52208 .33845 m
.50933 .3496 L
s
.52367 .34697 m
.50933 .3496 L
s
.50204 .34534 m
.50933 .3496 L
s
.50798 .34918 m
.50933 .3496 L
s
.01 w
.2928 .47014 Mdot
.5 Mabswid
.2928 .47014 m
.28255 .47667 L
s
.27743 .45822 m
.2928 .47014 L
s
.29112 .45047 m
.2928 .47014 L
s
.30529 .44199 m
.2928 .47014 L
s
.01 w
.52524 .34602 Mdot
.5 Mabswid
.52524 .34602 m
.52408 .33908 L
s
.5245 .34588 m
.52524 .34602 L
s
.5053 .34722 m
.52524 .34602 L
s
.53934 .33445 m
.52524 .34602 L
s
.53717 .33979 m
.52524 .34602 L
s
.53725 .34206 m
.52524 .34602 L
s
.01 w
.54753 .34827 Mdot
.5 Mabswid
.54753 .34827 m
.55234 .34199 L
s
.55481 .34181 m
.54753 .34827 L
s
.54832 .34948 m
.54753 .34827 L
s
.53934 .33445 m
.54753 .34827 L
s
.53717 .33979 m
.54753 .34827 L
s
.53725 .34206 m
.54753 .34827 L
s
.53738 .34309 m
.54753 .34827 L
s
.01 w
.77985 .468 Mdot
.5 Mabswid
.77985 .468 m
.793 .47416 L
s
.79677 .46162 m
.77985 .468 L
s
.78248 .45425 m
.77985 .468 L
s
.76822 .44681 m
.77985 .468 L
s
.01 w
.54832 .34948 Mdot
.5 Mabswid
.54832 .34948 m
.55234 .34199 L
s
.54832 .34948 m
.55481 .34181 L
s
.53725 .34206 m
.54832 .34948 L
s
.53738 .34309 m
.54832 .34948 L
s
.01 w
.87847 .49522 Mdot
.5 Mabswid
.87847 .49522 m
.89439 .50086 L
s
.87847 .49522 m
.87408 .50039 L
s
.85783 .49485 m
.87847 .49522 L
s
.01 w
.57047 .35233 Mdot
.5 Mabswid
.57047 .35233 m
.55234 .34199 L
s
.57047 .35233 m
.56526 .34257 L
s
.57047 .35233 m
.5578 .33999 L
s
.57047 .35233 m
.55481 .34181 L
s
.57047 .35233 m
.57254 .34994 L
s
.57417 .35136 m
.57047 .35233 L
s
.01 w
.72842 .42782 Mdot
.5 Mabswid
.72842 .42782 m
.73064 .42292 L
s
.75019 .43806 m
.72842 .42782 L
s
.01 w
.57254 .34994 Mdot
.5 Mabswid
.57254 .34994 m
.5578 .33999 L
s
.57254 .34994 m
.55481 .34181 L
s
.01 w
.89439 .50086 Mdot
.5 Mabswid
.87408 .50039 m
.89439 .50086 L
s
.01 w
.50798 .34918 Mdot
.5 Mabswid
.50798 .34918 m
.52408 .33908 L
s
.50798 .34918 m
.5245 .34588 L
s
.50798 .34918 m
.5053 .34722 L
s
.50798 .34918 m
.52208 .33845 L
s
.50798 .34918 m
.52367 .34697 L
s
.50798 .34918 m
.50204 .34534 L
s
.01 w
.793 .47416 Mdot
.5 Mabswid
.793 .47416 m
.8099 .48496 L
s
.79677 .46162 m
.793 .47416 L
s
.78248 .45425 m
.793 .47416 L
s
.01 w
.28255 .47667 Mdot
.5 Mabswid
.28255 .47667 m
.27175 .48271 L
s
.26482 .46518 m
.28255 .47667 L
s
.27743 .45822 m
.28255 .47667 L
s
.29112 .45047 m
.28255 .47667 L
s
.01 w
.83765 .48673 Mdot
.5 Mabswid
.83765 .48673 m
.83091 .47218 L
s
.83765 .48673 m
.85697 .48126 L
s
.83765 .48673 m
.85783 .49485 L
s
.83765 .48673 m
.83485 .49349 L
s
.8099 .48496 m
.83765 .48673 L
s
.01 w
.38582 .39241 Mdot
.5 Mabswid
.38582 .39241 m
.35554 .408 L
s
.38582 .39241 m
.35724 .39855 L
s
.38582 .3887 m
.38582 .39241 L
s
.01 w
.41419 .37482 Mdot
.5 Mabswid
.41419 .37482 m
.38582 .3887 L
s
.41419 .37482 m
.38793 .37742 L
s
.41419 .37482 m
.41878 .37105 L
s
.41419 .37482 m
.38003 .37438 L
s
.41419 .37482 m
.38347 .38193 L
s
.01 w
.5245 .34588 Mdot
.5 Mabswid
.5245 .34588 m
.52408 .33908 L
s
.5053 .34722 m
.5245 .34588 L
s
.52208 .33845 m
.5245 .34588 L
s
.52367 .34697 m
.5245 .34588 L
s
.53934 .33445 m
.5245 .34588 L
s
.53717 .33979 m
.5245 .34588 L
s
.53725 .34206 m
.5245 .34588 L
s
.53738 .34309 m
.5245 .34588 L
s
.01 w
.52367 .34697 Mdot
.5 Mabswid
.52367 .34697 m
.52408 .33908 L
s
.52367 .34697 m
.52208 .33845 L
s
.53725 .34206 m
.52367 .34697 L
s
.53738 .34309 m
.52367 .34697 L
s
.01 w
.38172 .36729 Mdot
.5 Mabswid
.38172 .36729 m
.35633 .36827 L
s
.38172 .36729 m
.34679 .37504 L
s
.38003 .37438 m
.38172 .36729 L
s
.01 w
.57417 .35136 Mdot
.5 Mabswid
.57417 .35136 m
.56526 .34257 L
s
.57417 .35136 m
.55481 .34181 L
s
.01 w
.85783 .49485 Mdot
.5 Mabswid
.85783 .49485 m
.87408 .50039 L
s
.85783 .49485 m
.85249 .4993 L
s
.83485 .49349 m
.85783 .49485 L
s
.01 w
.45426 .36053 Mdot
.5 Mabswid
.45426 .36053 m
.41979 .36851 L
s
.45426 .36053 m
.41878 .37105 L
s
.45426 .36053 m
.48364 .35014 L
s
.01 w
.5053 .34722 Mdot
.5 Mabswid
.5053 .34722 m
.52408 .33908 L
s
.51211 .33708 m
.5053 .34722 L
s
.52208 .33845 m
.5053 .34722 L
s
.48364 .35014 m
.5053 .34722 L
s
.50204 .34534 m
.5053 .34722 L
s
.49926 .34369 m
.5053 .34722 L
s
.01 w
.70576 .41193 Mdot
.5 Mabswid
.70576 .41193 m
.73802 .41855 L
s
.70576 .41193 m
.73064 .42292 L
s
.01 w
.87408 .50039 Mdot
.5 Mabswid
.85249 .4993 m
.87408 .50039 L
s
.01 w
.27175 .48271 Mdot
.5 Mabswid
.27175 .48271 m
.26285 .4884 L
s
.24924 .46903 m
.27175 .48271 L
s
.26482 .46518 m
.27175 .48271 L
s
.27743 .45822 m
.27175 .48271 L
s
.01 w
.48364 .35014 Mdot
.5 Mabswid
.50204 .34534 m
.48364 .35014 L
s
.49926 .34369 m
.48364 .35014 L
s
.01 w
.38582 .3887 Mdot
.5 Mabswid
.38582 .3887 m
.35554 .408 L
s
.38582 .3887 m
.35724 .39855 L
s
.35882 .3883 m
.38582 .3887 L
s
.38347 .38193 m
.38582 .3887 L
s
.01 w
.53717 .33979 Mdot
.5 Mabswid
.53717 .33979 m
.52408 .33908 L
s
.53717 .33979 m
.55234 .34199 L
s
.53717 .33979 m
.53991 .32199 L
s
.53717 .33979 m
.54032 .32405 L
s
.53717 .33979 m
.53934 .33445 L
s
.53725 .34206 m
.53717 .33979 L
s
.01 w
.8099 .48496 Mdot
.5 Mabswid
.8099 .48496 m
.83091 .47218 L
s
.8099 .48496 m
.83485 .49349 L
s
.8099 .48496 m
.81311 .49298 L
s
.81209 .47328 m
.8099 .48496 L
s
.81089 .46452 m
.8099 .48496 L
s
.79677 .46162 m
.8099 .48496 L
s
.01 w
.32419 .43343 Mdot
.5 Mabswid
.33011 .4191 m
.32419 .43343 L
s
.35554 .408 m
.32419 .43343 L
s
.30529 .44199 m
.32419 .43343 L
s
.01 w
.26285 .4884 Mdot
.5 Mabswid
.26285 .4884 m
.24573 .48174 L
s
.26285 .4884 m
.25946 .49229 L
s
.25025 .47594 m
.26285 .4884 L
s
.24924 .46903 m
.26285 .4884 L
s
.26482 .46518 m
.26285 .4884 L
s
.01 w
.88078 .48296 Mdot
.5 Mabswid
.88078 .48296 m
.85697 .48126 L
s
.88078 .48296 m
.85426 .47362 L
s
.01 w
.83485 .49349 Mdot
.5 Mabswid
.83485 .49349 m
.85249 .4993 L
s
.83485 .49349 m
.83088 .49768 L
s
.81311 .49298 m
.83485 .49349 L
s
.01 w
.35554 .408 Mdot
.5 Mabswid
.35554 .408 m
.33011 .4191 L
s
.35724 .39855 m
.35554 .408 L
s
.01 w
.85249 .4993 Mdot
.5 Mabswid
.83088 .49768 m
.85249 .4993 L
s
.01 w
.25946 .49229 Mdot
.5 Mabswid
.25946 .49229 m
.25769 .49534 L
s
.24821 .47818 m
.25946 .49229 L
s
.25025 .47594 m
.25946 .49229 L
s
.24924 .46903 m
.25946 .49229 L
s
.01 w
.50204 .34534 Mdot
.5 Mabswid
.50204 .34534 m
.52408 .33908 L
s
.50204 .34534 m
.51211 .33708 L
s
.50204 .34534 m
.51941 .33594 L
s
.50204 .34534 m
.52208 .33845 L
s
.50204 .34534 m
.50067 .34247 L
s
.49926 .34369 m
.50204 .34534 L
s
.01 w
.38003 .37438 Mdot
.5 Mabswid
.38003 .37438 m
.34679 .37504 L
s
.38003 .37438 m
.34837 .38263 L
s
.38347 .38193 m
.38003 .37438 L
s
.01 w
.35633 .36827 Mdot
.5 Mabswid
.35633 .36827 m
.31777 .3766 L
s
.34679 .37504 m
.35633 .36827 L
s
.01 w
.53725 .34206 Mdot
.5 Mabswid
.53725 .34206 m
.52408 .33908 L
s
.53725 .34206 m
.55234 .34199 L
s
.53725 .34206 m
.52208 .33845 L
s
.53725 .34206 m
.55481 .34181 L
s
.53725 .34206 m
.54032 .32405 L
s
.53725 .34206 m
.53934 .33445 L
s
.53725 .34206 m
.54003 .3335 L
s
.53738 .34309 m
.53725 .34206 L
s
.01 w
.41878 .37105 Mdot
.5 Mabswid
.41878 .37105 m
.38903 .37512 L
s
.41878 .37105 m
.38793 .37742 L
s
.41878 .37105 m
.41979 .36851 L
s
.38347 .38193 m
.41878 .37105 L
s
.01 w
.50067 .34247 Mdot
.5 Mabswid
.50067 .34247 m
.51941 .33594 L
s
.50067 .34247 m
.52208 .33845 L
s
.01 w
.25769 .49534 Mdot
.5 Mabswid
.24821 .47818 m
.25769 .49534 L
s
.25025 .47594 m
.25769 .49534 L
s
.01 w
.53738 .34309 Mdot
.5 Mabswid
.53738 .34309 m
.52408 .33908 L
s
.53738 .34309 m
.55234 .34199 L
s
.53738 .34309 m
.52208 .33845 L
s
.53738 .34309 m
.55481 .34181 L
s
.53738 .34309 m
.53934 .33445 L
s
.53738 .34309 m
.54003 .3335 L
s
.01 w
.83088 .49768 Mdot
.5 Mabswid
.81011 .49364 m
.83088 .49768 L
s
.81311 .49298 m
.83088 .49768 L
s
.01 w
.85697 .48126 Mdot
.5 Mabswid
.85697 .48126 m
.83091 .47218 L
s
.85426 .47362 m
.85697 .48126 L
s
.01 w
.75019 .43806 Mdot
.5 Mabswid
.75019 .43806 m
.73064 .42292 L
s
.75019 .43806 m
.77004 .43493 L
s
.75019 .43806 m
.75633 .42852 L
s
.75019 .43806 m
.76822 .44681 L
s
.01 w
.81311 .49298 Mdot
.5 Mabswid
.81311 .49298 m
.81011 .49364 L
s
.81313 .47601 m
.81311 .49298 L
s
.81209 .47328 m
.81311 .49298 L
s
.01 w
.49926 .34369 Mdot
.5 Mabswid
.49926 .34369 m
.51211 .33708 L
s
.49926 .34369 m
.52208 .33845 L
s
.01 w
.81011 .49364 Mdot
.5 Mabswid
.81313 .47601 m
.81011 .49364 L
s
.81209 .47328 m
.81011 .49364 L
s
.01 w
.41979 .36851 Mdot
.5 Mabswid
.41979 .36851 m
.38903 .37512 L
s
.41979 .36851 m
.38793 .37742 L
s
.01 w
.73064 .42292 Mdot
.5 Mabswid
.73064 .42292 m
.73802 .41855 L
s
.75633 .42852 m
.73064 .42292 L
s
.01 w
.38347 .38193 Mdot
.5 Mabswid
.38347 .38193 m
.35724 .39855 L
s
.38347 .38193 m
.35964 .38464 L
s
.38347 .38193 m
.38793 .37742 L
s
.38347 .38193 m
.34837 .38263 L
s
.38347 .38193 m
.35882 .3883 L
s
.01 w
.5578 .33999 Mdot
.5 Mabswid
.53929 .33547 m
.5578 .33999 L
s
.55481 .34181 m
.5578 .33999 L
s
.54003 .3335 m
.5578 .33999 L
s
.01 w
.30529 .44199 Mdot
.5 Mabswid
.30529 .44199 m
.33011 .4191 L
s
.30529 .44199 m
.29112 .45047 L
s
.28965 .43258 m
.30529 .44199 L
s
.30853 .42261 m
.30529 .44199 L
s
.01 w
.34679 .37504 Mdot
.5 Mabswid
.34679 .37504 m
.31777 .3766 L
s
.34679 .37504 m
.30921 .38528 L
s
.34837 .38263 m
.34679 .37504 L
s
.01 w
.33011 .4191 Mdot
.5 Mabswid
.33104 .40938 m
.33011 .4191 L
s
.35724 .39855 m
.33011 .4191 L
s
.30853 .42261 m
.33011 .4191 L
s
.01 w
.55234 .34199 Mdot
.5 Mabswid
.56526 .34257 m
.55234 .34199 L
s
.55772 .33015 m
.55234 .34199 L
s
.55062 .32745 m
.55234 .34199 L
s
.55481 .34181 m
.55234 .34199 L
s
.54233 .32651 m
.55234 .34199 L
s
.53934 .33445 m
.55234 .34199 L
s
.54003 .3335 m
.55234 .34199 L
s
.01 w
.35724 .39855 Mdot
.5 Mabswid
.35724 .39855 m
.33104 .40938 L
s
.33207 .39968 m
.35724 .39855 L
s
.35882 .3883 m
.35724 .39855 L
s
.01 w
.55481 .34181 Mdot
.5 Mabswid
.55481 .34181 m
.56526 .34257 L
s
.55481 .34181 m
.55772 .33015 L
s
.55481 .34181 m
.55062 .32745 L
s
.55481 .34181 m
.53929 .33547 L
s
.54233 .32651 m
.55481 .34181 L
s
.53934 .33445 m
.55481 .34181 L
s
.54003 .3335 m
.55481 .34181 L
s
.01 w
.56526 .34257 Mdot
.5 Mabswid
.55772 .33015 m
.56526 .34257 L
s
.01 w
.24573 .48174 Mdot
.5 Mabswid
.22607 .46316 m
.24573 .48174 L
s
.24924 .46903 m
.24573 .48174 L
s
.01 w
.51941 .33594 Mdot
.5 Mabswid
.52208 .33845 m
.51941 .33594 L
s
.53929 .33547 m
.51941 .33594 L
s
.54003 .3335 m
.51941 .33594 L
s
.01 w
.53991 .32199 Mdot
.5 Mabswid
.53991 .32199 m
.54275 .30915 L
s
.54032 .32405 m
.53991 .32199 L
s
.01 w
.29112 .45047 Mdot
.5 Mabswid
.29112 .45047 m
.27743 .45822 L
s
.27453 .43978 m
.29112 .45047 L
s
.28965 .43258 m
.29112 .45047 L
s
.30853 .42261 m
.29112 .45047 L
s
.01 w
.52408 .33908 Mdot
.5 Mabswid
.51211 .33708 m
.52408 .33908 L
s
.52662 .32701 m
.52408 .33908 L
s
.5345 .32583 m
.52408 .33908 L
s
.52208 .33845 m
.52408 .33908 L
s
.54233 .32651 m
.52408 .33908 L
s
.53934 .33445 m
.52408 .33908 L
s
.54003 .3335 m
.52408 .33908 L
s
.01 w
.76822 .44681 Mdot
.5 Mabswid
.76822 .44681 m
.78334 .44109 L
s
.76822 .44681 m
.77004 .43493 L
s
.76822 .44681 m
.75633 .42852 L
s
.76822 .44681 m
.78248 .45425 L
s
.01 w
.53929 .33547 Mdot
.5 Mabswid
.53929 .33547 m
.52208 .33845 L
s
.54003 .3335 m
.53929 .33547 L
s
.01 w
.34837 .38263 Mdot
.5 Mabswid
.34837 .38263 m
.30921 .38528 L
s
.34837 .38263 m
.32348 .39304 L
s
.35882 .3883 m
.34837 .38263 L
s
.01 w
.52208 .33845 Mdot
.5 Mabswid
.52208 .33845 m
.51211 .33708 L
s
.52208 .33845 m
.52662 .32701 L
s
.52208 .33845 m
.5345 .32583 L
s
.54233 .32651 m
.52208 .33845 L
s
.53934 .33445 m
.52208 .33845 L
s
.54003 .3335 m
.52208 .33845 L
s
.01 w
.38793 .37742 Mdot
.5 Mabswid
.38793 .37742 m
.36051 .37949 L
s
.38793 .37742 m
.35964 .38464 L
s
.38793 .37742 m
.38903 .37512 L
s
.35882 .3883 m
.38793 .37742 L
s
.01 w
.31777 .3766 Mdot
.5 Mabswid
.31777 .3766 m
.27257 .38537 L
s
.30921 .38528 m
.31777 .3766 L
s
.01 w
.27743 .45822 Mdot
.5 Mabswid
.27743 .45822 m
.26482 .46518 L
s
.25935 .44631 m
.27743 .45822 L
s
.27453 .43978 m
.27743 .45822 L
s
.28965 .43258 m
.27743 .45822 L
s
.01 w
.35882 .3883 Mdot
.5 Mabswid
.35882 .3883 m
.35964 .38464 L
s
.35882 .3883 m
.32348 .39304 L
s
.35882 .3883 m
.33207 .39968 L
s
.01 w
.51211 .33708 Mdot
.5 Mabswid
.52662 .32701 m
.51211 .33708 L
s
.01 w
.33104 .40938 Mdot
.5 Mabswid
.33207 .39968 m
.33104 .40938 L
s
.30853 .42261 m
.33104 .40938 L
s
.01 w
.78248 .45425 Mdot
.5 Mabswid
.78248 .45425 m
.79572 .44628 L
s
.78248 .45425 m
.78334 .44109 L
s
.78248 .45425 m
.77004 .43493 L
s
.78248 .45425 m
.79677 .46162 L
s
.01 w
.53934 .33445 Mdot
.5 Mabswid
.53934 .33445 m
.5345 .32583 L
s
.53934 .33445 m
.55062 .32745 L
s
.53934 .33445 m
.54315 .31207 L
s
.53934 .33445 m
.54325 .31693 L
s
.53934 .33445 m
.54233 .32651 L
s
.53934 .33445 m
.54032 .32405 L
s
.54003 .3335 m
.53934 .33445 L
s
.01 w
.26482 .46518 Mdot
.5 Mabswid
.26482 .46518 m
.24924 .46903 L
s
.24556 .45614 m
.26482 .46518 L
s
.25935 .44631 m
.26482 .46518 L
s
.27453 .43978 m
.26482 .46518 L
s
.01 w
.54032 .32405 Mdot
.5 Mabswid
.54032 .32405 m
.54275 .30915 L
s
.54032 .32405 m
.54315 .31207 L
s
.01 w
.38903 .37512 Mdot
.5 Mabswid
.38903 .37512 m
.36051 .37949 L
s
.38903 .37512 m
.35964 .38464 L
s
.01 w
.85426 .47362 Mdot
.5 Mabswid
.85426 .47362 m
.83091 .47218 L
s
.85426 .47362 m
.83235 .46069 L
s
.01 w
.83091 .47218 Mdot
.5 Mabswid
.83235 .46069 m
.83091 .47218 L
s
.81059 .45303 m
.83091 .47218 L
s
.81089 .46452 m
.83091 .47218 L
s
.01 w
.79677 .46162 Mdot
.5 Mabswid
.79677 .46162 m
.81059 .45303 L
s
.79677 .46162 m
.79572 .44628 L
s
.79677 .46162 m
.78334 .44109 L
s
.79677 .46162 m
.81089 .46452 L
s
.01 w
.54003 .3335 Mdot
.5 Mabswid
.54003 .3335 m
.5345 .32583 L
s
.54003 .3335 m
.55062 .32745 L
s
.54003 .3335 m
.54325 .31693 L
s
.54003 .3335 m
.54233 .32651 L
s
.01 w
.30921 .38528 Mdot
.5 Mabswid
.30921 .38528 m
.27257 .38537 L
s
.30921 .38528 m
.2726 .39214 L
s
.30921 .38528 m
.28956 .39914 L
s
.32348 .39304 m
.30921 .38528 L
s
.01 w
.73802 .41855 Mdot
.5 Mabswid
.76132 .41909 m
.73802 .41855 L
s
.75633 .42852 m
.73802 .41855 L
s
.01 w
.30853 .42261 Mdot
.5 Mabswid
.30853 .42261 m
.28944 .41512 L
s
.30853 .42261 m
.30489 .40806 L
s
.30853 .42261 m
.33207 .39968 L
s
.30853 .42261 m
.28965 .43258 L
s
.01 w
.24924 .46903 Mdot
.5 Mabswid
.24924 .46903 m
.22347 .44834 L
s
.24924 .46903 m
.22607 .46316 L
s
.24924 .46903 m
.25025 .47594 L
s
.24263 .45761 m
.24924 .46903 L
s
.24556 .45614 m
.24924 .46903 L
s
.25935 .44631 m
.24924 .46903 L
s
.01 w
.25025 .47594 Mdot
.5 Mabswid
.25025 .47594 m
.24821 .47818 L
s
.24142 .46118 m
.25025 .47594 L
s
.24263 .45761 m
.25025 .47594 L
s
.24556 .45614 m
.25025 .47594 L
s
.01 w
.32348 .39304 Mdot
.5 Mabswid
.32348 .39304 m
.28956 .39914 L
s
.32348 .39304 m
.30489 .40806 L
s
.33207 .39968 m
.32348 .39304 L
s
.01 w
.24821 .47818 Mdot
.5 Mabswid
.24142 .46118 m
.24821 .47818 L
s
.24263 .45761 m
.24821 .47818 L
s
.01 w
.35964 .38464 Mdot
.5 Mabswid
.35964 .38464 m
.33545 .38618 L
s
.35964 .38464 m
.33398 .39091 L
s
.35964 .38464 m
.36051 .37949 L
s
.33207 .39968 m
.35964 .38464 L
s
.01 w
.75633 .42852 Mdot
.5 Mabswid
.75633 .42852 m
.77139 .42282 L
s
.75633 .42852 m
.76132 .41909 L
s
.75633 .42852 m
.77004 .43493 L
s
.01 w
.27257 .38537 Mdot
.5 Mabswid
.27257 .38537 m
.23827 .39496 L
s
.27257 .38537 m
.22772 .38866 L
s
.2726 .39214 m
.27257 .38537 L
s
.01 w
.33207 .39968 Mdot
.5 Mabswid
.33207 .39968 m
.33398 .39091 L
s
.33207 .39968 m
.30489 .40806 L
s
.31227 .39773 m
.33207 .39968 L
s
.01 w
.81209 .47328 Mdot
.5 Mabswid
.81209 .47328 m
.81137 .45786 L
s
.81209 .47328 m
.80953 .45512 L
s
.81209 .47328 m
.81059 .45303 L
s
.81209 .47328 m
.81313 .47601 L
s
.81089 .46452 m
.81209 .47328 L
s
.01 w
.28965 .43258 Mdot
.5 Mabswid
.28965 .43258 m
.2729 .42186 L
s
.28965 .43258 m
.28944 .41512 L
s
.28965 .43258 m
.30489 .40806 L
s
.28965 .43258 m
.27453 .43978 L
s
.01 w
.81089 .46452 Mdot
.5 Mabswid
.81089 .46452 m
.80953 .45512 L
s
.81089 .46452 m
.81059 .45303 L
s
.81089 .46452 m
.79572 .44628 L
s
.01 w
.81313 .47601 Mdot
.5 Mabswid
.81313 .47601 m
.81137 .45786 L
s
.81313 .47601 m
.80953 .45512 L
s
.01 w
.22607 .46316 Mdot
.5 Mabswid
.22607 .46316 m
.22347 .44834 L
s
.1999 .44681 m
.22607 .46316 L
s
.01 w
.54275 .30915 Mdot
.5 Mabswid
.54275 .30915 m
.54577 .29746 L
s
.54315 .31207 m
.54275 .30915 L
s
.01 w
.2726 .39214 Mdot
.5 Mabswid
.2726 .39214 m
.23827 .39496 L
s
.2726 .39214 m
.25726 .40189 L
s
.28956 .39914 m
.2726 .39214 L
s
.01 w
.27453 .43978 Mdot
.5 Mabswid
.27453 .43978 m
.25864 .42564 L
s
.27453 .43978 m
.2729 .42186 L
s
.27453 .43978 m
.28944 .41512 L
s
.27453 .43978 m
.25935 .44631 L
s
.01 w
.77004 .43493 Mdot
.5 Mabswid
.77004 .43493 m
.78154 .42728 L
s
.77004 .43493 m
.77139 .42282 L
s
.77004 .43493 m
.76132 .41909 L
s
.77004 .43493 m
.78334 .44109 L
s
.01 w
.28956 .39914 Mdot
.5 Mabswid
.28956 .39914 m
.25726 .40189 L
s
.28956 .39914 m
.27061 .40939 L
s
.28956 .39914 m
.28944 .41512 L
s
.30489 .40806 m
.28956 .39914 L
s
.01 w
.22772 .38866 Mdot
.5 Mabswid
.22772 .38866 m
.20329 .39408 L
s
.22772 .38866 m
.23827 .39496 L
s
.22772 .38866 m
.19166 .3899 L
s
.01 w
.55772 .33015 Mdot
.5 Mabswid
.55772 .33015 m
.55935 .31763 L
s
.55772 .33015 m
.55454 .31657 L
s
.55062 .32745 m
.55772 .33015 L
s
.01 w
.36051 .37949 Mdot
.5 Mabswid
.36051 .37949 m
.33274 .38108 L
s
.36051 .37949 m
.33545 .38618 L
s
.01 w
.30489 .40806 Mdot
.5 Mabswid
.30489 .40806 m
.28944 .41512 L
s
.29382 .40354 m
.30489 .40806 L
s
.31227 .39773 m
.30489 .40806 L
s
.01 w
.24556 .45614 Mdot
.5 Mabswid
.24556 .45614 m
.22347 .44834 L
s
.24556 .45614 m
.23996 .43356 L
s
.24556 .45614 m
.24263 .45761 L
s
.25935 .44631 m
.24556 .45614 L
s
.01 w
.25935 .44631 Mdot
.5 Mabswid
.25935 .44631 m
.23996 .43356 L
s
.25935 .44631 m
.25864 .42564 L
s
.25935 .44631 m
.2729 .42186 L
s
.01 w
.83235 .46069 Mdot
.5 Mabswid
.83235 .46069 m
.81708 .44441 L
s
.81059 .45303 m
.83235 .46069 L
s
.01 w
.54233 .32651 Mdot
.5 Mabswid
.54233 .32651 m
.53858 .31508 L
s
.54233 .32651 m
.5345 .32583 L
s
.54233 .32651 m
.55454 .31657 L
s
.54233 .32651 m
.55062 .32745 L
s
.54233 .32651 m
.54665 .30504 L
s
.54233 .32651 m
.54689 .3129 L
s
.54233 .32651 m
.54325 .31693 L
s
.01 w
.54315 .31207 Mdot
.5 Mabswid
.54315 .31207 m
.54577 .29746 L
s
.54315 .31207 m
.54652 .29874 L
s
.54325 .31693 m
.54315 .31207 L
s
.01 w
.33398 .39091 Mdot
.5 Mabswid
.33398 .39091 m
.33545 .38618 L
s
.31227 .39773 m
.33398 .39091 L
s
.01 w
.78334 .44109 Mdot
.5 Mabswid
.78334 .44109 m
.79229 .43191 L
s
.78334 .44109 m
.78154 .42728 L
s
.78334 .44109 m
.77139 .42282 L
s
.78334 .44109 m
.79572 .44628 L
s
.01 w
.23827 .39496 Mdot
.5 Mabswid
.23827 .39496 m
.20629 .40321 L
s
.23827 .39496 m
.22896 .40802 L
s
.23827 .39496 m
.20329 .39408 L
s
.25726 .40189 m
.23827 .39496 L
s
.01 w
.52662 .32701 Mdot
.5 Mabswid
.52662 .32701 m
.53372 .31523 L
s
.52662 .32701 m
.53858 .31508 L
s
.5345 .32583 m
.52662 .32701 L
s
.01 w
.55062 .32745 Mdot
.5 Mabswid
.55062 .32745 m
.55935 .31763 L
s
.55062 .32745 m
.55454 .31657 L
s
.54689 .3129 m
.55062 .32745 L
s
.01 w
.25726 .40189 Mdot
.5 Mabswid
.25726 .40189 m
.22896 .40802 L
s
.25726 .40189 m
.25062 .41442 L
s
.27061 .40939 m
.25726 .40189 L
s
.01 w
.5345 .32583 Mdot
.5 Mabswid
.5345 .32583 m
.53372 .31523 L
s
.5345 .32583 m
.53858 .31508 L
s
.54689 .3129 m
.5345 .32583 L
s
.01 w
.19166 .3899 Mdot
.5 Mabswid
.19166 .3899 m
.17345 .39395 L
s
.19166 .3899 m
.20329 .39408 L
s
.19166 .3899 m
.16284 .39154 L
s
.01 w
.54325 .31693 Mdot
.5 Mabswid
.54325 .31693 m
.54652 .29874 L
s
.54325 .31693 m
.54665 .30504 L
s
.01 w
.27061 .40939 Mdot
.5 Mabswid
.27061 .40939 m
.25062 .41442 L
s
.27061 .40939 m
.2729 .42186 L
s
.28944 .41512 m
.27061 .40939 L
s
.01 w
.20329 .39408 Mdot
.5 Mabswid
.20329 .39408 m
.17977 .4011 L
s
.20329 .39408 m
.20629 .40321 L
s
.20329 .39408 m
.17345 .39395 L
s
.01 w
.79572 .44628 Mdot
.5 Mabswid
.79572 .44628 m
.80126 .43545 L
s
.79572 .44628 m
.79229 .43191 L
s
.79572 .44628 m
.78154 .42728 L
s
.79572 .44628 m
.81059 .45303 L
s
.01 w
.28944 .41512 Mdot
.5 Mabswid
.28944 .41512 m
.2729 .42186 L
s
.27882 .40856 m
.28944 .41512 L
s
.29382 .40354 m
.28944 .41512 L
s
.31227 .39773 m
.28944 .41512 L
s
.01 w
.81059 .45303 Mdot
.5 Mabswid
.81059 .45303 m
.81708 .44441 L
s
.81059 .45303 m
.80439 .43841 L
s
.81059 .45303 m
.80126 .43545 L
s
.81059 .45303 m
.79229 .43191 L
s
.81059 .45303 m
.80953 .45512 L
s
.01 w
.24263 .45761 Mdot
.5 Mabswid
.24263 .45761 m
.23878 .44294 L
s
.24263 .45761 m
.23582 .44146 L
s
.24263 .45761 m
.23996 .43356 L
s
.24263 .45761 m
.24142 .46118 L
s
.01 w
.22347 .44834 Mdot
.5 Mabswid
.19411 .43563 m
.22347 .44834 L
s
.1999 .44681 m
.22347 .44834 L
s
.21141 .42943 m
.22347 .44834 L
s
.23996 .43356 m
.22347 .44834 L
s
.01 w
.16284 .39154 Mdot
.5 Mabswid
.16284 .39154 m
.1395 .39462 L
s
.16284 .39154 m
.15055 .39428 L
s
.16284 .39154 m
.17345 .39395 L
s
.01 w
.24142 .46118 Mdot
.5 Mabswid
.24142 .46118 m
.23878 .44294 L
s
.24142 .46118 m
.23582 .44146 L
s
.01 w
.1999 .44681 Mdot
.5 Mabswid
.1999 .44681 m
.19411 .43563 L
s
.16938 .43211 m
.1999 .44681 L
s
.01 w
.17345 .39395 Mdot
.5 Mabswid
.17345 .39395 m
.15503 .40063 L
s
.17345 .39395 m
.17977 .4011 L
s
.17345 .39395 m
.15055 .39428 L
s
.01 w
.22896 .40802 Mdot
.5 Mabswid
.22896 .40802 m
.20286 .41685 L
s
.22896 .40802 m
.23022 .42131 L
s
.22896 .40802 m
.20629 .40321 L
s
.25062 .41442 m
.22896 .40802 L
s
.01 w
.33545 .38618 Mdot
.5 Mabswid
.33545 .38618 m
.33274 .38108 L
s
.31227 .39773 m
.33545 .38618 L
s
.31359 .38809 m
.33545 .38618 L
s
.01 w
.20629 .40321 Mdot
.5 Mabswid
.20629 .40321 m
.18365 .41018 L
s
.20629 .40321 m
.20286 .41685 L
s
.20629 .40321 m
.17977 .4011 L
s
.01 w
.25062 .41442 Mdot
.5 Mabswid
.25062 .41442 m
.23022 .42131 L
s
.25062 .41442 m
.25864 .42564 L
s
.2729 .42186 m
.25062 .41442 L
s
.01 w
.76132 .41909 Mdot
.5 Mabswid
.76132 .41909 m
.76982 .41006 L
s
.76132 .41909 m
.7665 .40812 L
s
.76132 .41909 m
.77139 .42282 L
s
.01 w
.2729 .42186 Mdot
.5 Mabswid
.2729 .42186 m
.25864 .42564 L
s
.26364 .41352 m
.2729 .42186 L
s
.27882 .40856 m
.2729 .42186 L
s
.29382 .40354 m
.2729 .42186 L
s
.01 w
.80953 .45512 Mdot
.5 Mabswid
.80953 .45512 m
.80625 .43993 L
s
.80953 .45512 m
.80439 .43841 L
s
.80953 .45512 m
.80126 .43545 L
s
.80953 .45512 m
.81137 .45786 L
s
.01 w
.15055 .39428 Mdot
.5 Mabswid
.15055 .39428 m
.13426 .39984 L
s
.15055 .39428 m
.15503 .40063 L
s
.15055 .39428 m
.1395 .39462 L
s
.01 w
.17977 .4011 Mdot
.5 Mabswid
.17977 .4011 m
.16181 .41012 L
s
.17977 .4011 m
.18365 .41018 L
s
.17977 .4011 m
.15503 .40063 L
s
.01 w
.1395 .39462 Mdot
.5 Mabswid
.1395 .39462 m
.11958 .39925 L
s
.1395 .39462 m
.13426 .39984 L
s
.01 w
.81137 .45786 Mdot
.5 Mabswid
.81137 .45786 m
.80625 .43993 L
s
.81137 .45786 m
.80439 .43841 L
s
.01 w
.31227 .39773 Mdot
.5 Mabswid
.31227 .39773 m
.29382 .40354 L
s
.29978 .39232 m
.31227 .39773 L
s
.31359 .38809 m
.31227 .39773 L
s
.01 w
.54577 .29746 Mdot
.5 Mabswid
.54577 .29746 m
.54913 .28548 L
s
.54652 .29874 m
.54577 .29746 L
s
.01 w
.15503 .40063 Mdot
.5 Mabswid
.15503 .40063 m
.13894 .40877 L
s
.15503 .40063 m
.16181 .41012 L
s
.15503 .40063 m
.13426 .39984 L
s
.01 w
.25864 .42564 Mdot
.5 Mabswid
.25864 .42564 m
.23996 .43356 L
s
.25864 .42564 m
.23022 .42131 L
s
.26364 .41352 m
.25864 .42564 L
s
.27882 .40856 m
.25864 .42564 L
s
.01 w
.77139 .42282 Mdot
.5 Mabswid
.77139 .42282 m
.77718 .4132 L
s
.77139 .42282 m
.76982 .41006 L
s
.77139 .42282 m
.7665 .40812 L
s
.77139 .42282 m
.78154 .42728 L
s
.01 w
.23022 .42131 Mdot
.5 Mabswid
.23022 .42131 m
.21141 .42943 L
s
.23022 .42131 m
.23996 .43356 L
s
.23022 .42131 m
.20286 .41685 L
s
.01 w
.18365 .41018 Mdot
.5 Mabswid
.18365 .41018 m
.17513 .42195 L
s
.18365 .41018 m
.16181 .41012 L
s
.20286 .41685 m
.18365 .41018 L
s
.01 w
.13426 .39984 Mdot
.5 Mabswid
.13426 .39984 m
.11887 .40694 L
s
.13426 .39984 m
.13894 .40877 L
s
.13426 .39984 m
.11958 .39925 L
s
.01 w
.19411 .43563 Mdot
.5 Mabswid
.16938 .43211 m
.19411 .43563 L
s
.17513 .42195 m
.19411 .43563 L
s
.18905 .42651 m
.19411 .43563 L
s
.21141 .42943 m
.19411 .43563 L
s
.01 w
.20286 .41685 Mdot
.5 Mabswid
.20286 .41685 m
.17513 .42195 L
s
.20286 .41685 m
.18905 .42651 L
s
.20286 .41685 m
.21141 .42943 L
s
.01 w
.11958 .39925 Mdot
.5 Mabswid
.11958 .39925 m
.10395 .40582 L
s
.11958 .39925 m
.11887 .40694 L
s
.01 w
.16938 .43211 Mdot
.5 Mabswid
.13833 .42479 m
.16938 .43211 L
s
.14964 .4198 m
.16938 .43211 L
s
.17513 .42195 m
.16938 .43211 L
s
.01 w
.16181 .41012 Mdot
.5 Mabswid
.16181 .41012 m
.14964 .4198 L
s
.16181 .41012 m
.17513 .42195 L
s
.16181 .41012 m
.13894 .40877 L
s
.01 w
.81708 .44441 Mdot
.5 Mabswid
.81708 .44441 m
.80506 .4274 L
s
.80126 .43545 m
.81708 .44441 L
s
.01 w
.78154 .42728 Mdot
.5 Mabswid
.78154 .42728 m
.78479 .41634 L
s
.78154 .42728 m
.77718 .4132 L
s
.78154 .42728 m
.76982 .41006 L
s
.78154 .42728 m
.79229 .43191 L
s
.01 w
.13894 .40877 Mdot
.5 Mabswid
.13894 .40877 m
.12508 .41663 L
s
.13894 .40877 m
.14964 .4198 L
s
.13894 .40877 m
.11887 .40694 L
s
.01 w
.29382 .40354 Mdot
.5 Mabswid
.29382 .40354 m
.27882 .40856 L
s
.28634 .39628 m
.29382 .40354 L
s
.29978 .39232 m
.29382 .40354 L
s
.31359 .38809 m
.29382 .40354 L
s
.01 w
.23996 .43356 Mdot
.5 Mabswid
.23996 .43356 m
.2271 .41734 L
s
.23996 .43356 m
.21372 .43718 L
s
.23996 .43356 m
.23582 .44146 L
s
.23996 .43356 m
.21141 .42943 L
s
.24704 .42294 m
.23996 .43356 L
s
.25088 .41416 m
.23996 .43356 L
s
.26364 .41352 m
.23996 .43356 L
s
.01 w
.54652 .29874 Mdot
.5 Mabswid
.54652 .29874 m
.54913 .28548 L
s
.54652 .29874 m
.55013 .28671 L
s
.54665 .30504 m
.54652 .29874 L
s
.01 w
.11887 .40694 Mdot
.5 Mabswid
.11887 .40694 m
.1056 .4141 L
s
.11887 .40694 m
.12508 .41663 L
s
.11887 .40694 m
.10395 .40582 L
s
.01 w
.33274 .38108 Mdot
.5 Mabswid
.31359 .38809 m
.33274 .38108 L
s
.31594 .3787 m
.33274 .38108 L
s
.01 w
.79229 .43191 Mdot
.5 Mabswid
.79229 .43191 m
.79208 .41902 L
s
.79229 .43191 m
.78479 .41634 L
s
.79229 .43191 m
.77718 .4132 L
s
.79229 .43191 m
.80126 .43545 L
s
.01 w
.21141 .42943 Mdot
.5 Mabswid
.21141 .42943 m
.2271 .41734 L
s
.21141 .42943 m
.19564 .42056 L
s
.21141 .42943 m
.18995 .43354 L
s
.21141 .42943 m
.21372 .43718 L
s
.21141 .42943 m
.18905 .42651 L
s
.01 w
.13833 .42479 Mdot
.5 Mabswid
.11384 .42045 m
.13833 .42479 L
s
.12508 .41663 m
.13833 .42479 L
s
.14964 .4198 m
.13833 .42479 L
s
.01 w
.10395 .40582 Mdot
.5 Mabswid
.10395 .40582 m
.09282 .4125 L
s
.10395 .40582 m
.1056 .4141 L
s
.01 w
.17513 .42195 Mdot
.5 Mabswid
.17513 .42195 m
.19564 .42056 L
s
.17513 .42195 m
.17065 .41771 L
s
.17513 .42195 m
.14913 .42575 L
s
.17513 .42195 m
.16849 .42952 L
s
.17513 .42195 m
.14964 .4198 L
s
.18905 .42651 m
.17513 .42195 L
s
.01 w
.18905 .42651 Mdot
.5 Mabswid
.18905 .42651 m
.19564 .42056 L
s
.18905 .42651 m
.16849 .42952 L
s
.18905 .42651 m
.18995 .43354 L
s
.01 w
.55935 .31763 Mdot
.5 Mabswid
.55935 .31763 m
.5658 .30871 L
s
.55935 .31763 m
.56054 .30713 L
s
.55454 .31657 m
.55935 .31763 L
s
.01 w
.54665 .30504 Mdot
.5 Mabswid
.54665 .30504 m
.55013 .28671 L
s
.54665 .30504 m
.55063 .29323 L
s
.54689 .3129 m
.54665 .30504 L
s
.01 w
.55454 .31657 Mdot
.5 Mabswid
.55454 .31657 m
.5658 .30871 L
s
.55454 .31657 m
.56054 .30713 L
s
.55092 .30308 m
.55454 .31657 L
s
.54689 .3129 m
.55454 .31657 L
s
.01 w
.14964 .4198 Mdot
.5 Mabswid
.14964 .4198 m
.17065 .41771 L
s
.14964 .4198 m
.13888 .4167 L
s
.14964 .4198 m
.12807 .42272 L
s
.14964 .4198 m
.14913 .42575 L
s
.14964 .4198 m
.12508 .41663 L
s
.01 w
.23582 .44146 Mdot
.5 Mabswid
.23582 .44146 m
.21735 .44249 L
s
.23582 .44146 m
.23878 .44294 L
s
.23582 .44146 m
.21372 .43718 L
s
.24597 .42578 m
.23582 .44146 L
s
.24704 .42294 m
.23582 .44146 L
s
.01 w
.11384 .42045 Mdot
.5 Mabswid
.09616 .41814 m
.11384 .42045 L
s
.1056 .4141 m
.11384 .42045 L
s
.12508 .41663 m
.11384 .42045 L
s
.01 w
.23878 .44294 Mdot
.5 Mabswid
.23878 .44294 m
.21735 .44249 L
s
.24597 .42578 m
.23878 .44294 L
s
.24704 .42294 m
.23878 .44294 L
s
.01 w
.53858 .31508 Mdot
.5 Mabswid
.53858 .31508 m
.53541 .30602 L
s
.53858 .31508 m
.5407 .30539 L
s
.53858 .31508 m
.53372 .31523 L
s
.55092 .30308 m
.53858 .31508 L
s
.54689 .3129 m
.53858 .31508 L
s
.01 w
.80126 .43545 Mdot
.5 Mabswid
.80126 .43545 m
.80506 .4274 L
s
.80126 .43545 m
.79544 .42134 L
s
.80126 .43545 m
.79208 .41902 L
s
.80126 .43545 m
.78479 .41634 L
s
.80126 .43545 m
.80439 .43841 L
s
.01 w
.21372 .43718 Mdot
.5 Mabswid
.21372 .43718 m
.19505 .43935 L
s
.21372 .43718 m
.21735 .44249 L
s
.21372 .43718 m
.18995 .43354 L
s
.01 w
.53372 .31523 Mdot
.5 Mabswid
.53372 .31523 m
.53541 .30602 L
s
.53372 .31523 m
.5407 .30539 L
s
.01 w
.12508 .41663 Mdot
.5 Mabswid
.12508 .41663 m
.13888 .4167 L
s
.12508 .41663 m
.11407 .41444 L
s
.12508 .41663 m
.1102 .41989 L
s
.12508 .41663 m
.12807 .42272 L
s
.12508 .41663 m
.1056 .4141 L
s
.01 w
.09616 .41814 Mdot
.5 Mabswid
.09282 .4125 m
.09616 .41814 L
s
.1056 .4141 m
.09616 .41814 L
s
.01 w
.27882 .40856 Mdot
.5 Mabswid
.27882 .40856 m
.26364 .41352 L
s
.27391 .39945 m
.27882 .40856 L
s
.28634 .39628 m
.27882 .40856 L
s
.29978 .39232 m
.27882 .40856 L
s
.01 w
.54689 .3129 Mdot
.5 Mabswid
.54689 .3129 m
.5407 .30539 L
s
.54689 .3129 m
.56054 .30713 L
s
.54689 .3129 m
.55063 .29323 L
s
.54689 .3129 m
.55092 .30308 L
s
.01 w
.1056 .4141 Mdot
.5 Mabswid
.1056 .4141 m
.11407 .41444 L
s
.1056 .4141 m
.09623 .41268 L
s
.1056 .4141 m
.09813 .41941 L
s
.1056 .4141 m
.1102 .41989 L
s
.1056 .4141 m
.09282 .4125 L
s
.01 w
.18995 .43354 Mdot
.5 Mabswid
.18995 .43354 m
.17257 .43572 L
s
.18995 .43354 m
.19505 .43935 L
s
.18995 .43354 m
.16849 .42952 L
s
.01 w
.80439 .43841 Mdot
.5 Mabswid
.80439 .43841 m
.79814 .42267 L
s
.80439 .43841 m
.79544 .42134 L
s
.80439 .43841 m
.79208 .41902 L
s
.80439 .43841 m
.80625 .43993 L
s
.01 w
.09282 .4125 Mdot
.5 Mabswid
.09282 .4125 m
.09623 .41268 L
s
.09282 .4125 m
.09813 .41941 L
s
.01 w
.16849 .42952 Mdot
.5 Mabswid
.16849 .42952 m
.15131 .43189 L
s
.16849 .42952 m
.17257 .43572 L
s
.16849 .42952 m
.14913 .42575 L
s
.01 w
.21735 .44249 Mdot
.5 Mabswid
.21735 .44249 m
.19505 .43935 L
s
.01 w
.14913 .42575 Mdot
.5 Mabswid
.14913 .42575 m
.13125 .4281 L
s
.14913 .42575 m
.15131 .43189 L
s
.14913 .42575 m
.12807 .42272 L
s
.01 w
.31359 .38809 Mdot
.5 Mabswid
.31359 .38809 m
.29978 .39232 L
s
.30655 .38096 m
.31359 .38809 L
s
.31594 .3787 m
.31359 .38809 L
s
.01 w
.19505 .43935 Mdot
.5 Mabswid
.19505 .43935 m
.17257 .43572 L
s
.01 w
.12807 .42272 Mdot
.5 Mabswid
.12807 .42272 m
.11243 .42453 L
s
.12807 .42272 m
.13125 .4281 L
s
.12807 .42272 m
.1102 .41989 L
s
.01 w
.80625 .43993 Mdot
.5 Mabswid
.80625 .43993 m
.79814 .42267 L
s
.80625 .43993 m
.79544 .42134 L
s
.01 w
.1102 .41989 Mdot
.5 Mabswid
.1102 .41989 m
.11243 .42453 L
s
.1102 .41989 m
.09813 .41941 L
s
.01 w
.13888 .4167 Mdot
.5 Mabswid
.13888 .4167 m
.17065 .41771 L
s
.11407 .41444 m
.13888 .4167 L
s
.01 w
.11407 .41444 Mdot
.5 Mabswid
.09623 .41268 m
.11407 .41444 L
s
.01 w
.17257 .43572 Mdot
.5 Mabswid
.17257 .43572 m
.15131 .43189 L
s
.01 w
.19564 .42056 Mdot
.5 Mabswid
.19564 .42056 m
.2271 .41734 L
s
.20338 .41449 m
.19564 .42056 L
s
.17065 .41771 m
.19564 .42056 L
s
.01 w
.09623 .41268 Mdot
.09813 .41941 Mdot
.5 Mabswid
.09813 .41941 m
.11243 .42453 L
s
.01 w
.15131 .43189 Mdot
.5 Mabswid
.15131 .43189 m
.13125 .4281 L
s
.01 w
.7665 .40812 Mdot
.5 Mabswid
.7665 .40812 m
.76455 .39633 L
s
.7665 .40812 m
.7625 .39472 L
s
.7665 .40812 m
.76982 .41006 L
s
.01 w
.17065 .41771 Mdot
.5 Mabswid
.17065 .41771 m
.20338 .41449 L
s
.01 w
.26364 .41352 Mdot
.5 Mabswid
.26364 .41352 m
.25088 .41416 L
s
.25792 .40346 m
.26364 .41352 L
s
.27391 .39945 m
.26364 .41352 L
s
.28634 .39628 m
.26364 .41352 L
s
.01 w
.13125 .4281 Mdot
.5 Mabswid
.13125 .4281 m
.11243 .42453 L
s
.01 w
.11243 .42453 Mdot
.76982 .41006 Mdot
.5 Mabswid
.76982 .41006 m
.76919 .39853 L
s
.76982 .41006 m
.76455 .39633 L
s
.76982 .41006 m
.7625 .39472 L
s
.76982 .41006 m
.77718 .4132 L
s
.01 w
.54913 .28548 Mdot
.5 Mabswid
.54913 .28548 m
.55294 .27323 L
s
.55013 .28671 m
.54913 .28548 L
s
.01 w
.29978 .39232 Mdot
.5 Mabswid
.29978 .39232 m
.28634 .39628 L
s
.29656 .38386 m
.29978 .39232 L
s
.30655 .38096 m
.29978 .39232 L
s
.31594 .3787 m
.29978 .39232 L
s
.01 w
.77718 .4132 Mdot
.5 Mabswid
.77718 .4132 m
.77484 .40071 L
s
.77718 .4132 m
.76919 .39853 L
s
.77718 .4132 m
.76455 .39633 L
s
.77718 .4132 m
.78479 .41634 L
s
.01 w
.80506 .4274 Mdot
.5 Mabswid
.80506 .4274 m
.79216 .40999 L
s
.79208 .41902 m
.80506 .4274 L
s
.01 w
.2271 .41734 Mdot
.5 Mabswid
.2329 .40652 m
.2271 .41734 L
s
.20338 .41449 m
.2271 .41734 L
s
.25088 .41416 m
.2271 .41734 L
s
.25792 .40346 m
.2271 .41734 L
s
.01 w
.20338 .41449 Mdot
.5 Mabswid
.20338 .41449 m
.2329 .40652 L
s
.01 w
.78479 .41634 Mdot
.5 Mabswid
.78479 .41634 m
.78044 .40251 L
s
.78479 .41634 m
.77484 .40071 L
s
.78479 .41634 m
.76919 .39853 L
s
.78479 .41634 m
.79208 .41902 L
s
.01 w
.24704 .42294 Mdot
.5 Mabswid
.24704 .42294 m
.24597 .42578 L
s
.25088 .41416 m
.24704 .42294 L
s
.25753 .40886 m
.24704 .42294 L
s
.25957 .4062 m
.24704 .42294 L
s
.25792 .40346 m
.24704 .42294 L
s
.01 w
.25088 .41416 Mdot
.5 Mabswid
.25957 .4062 m
.25088 .41416 L
s
.25792 .40346 m
.25088 .41416 L
s
.27391 .39945 m
.25088 .41416 L
s
.01 w
.24597 .42578 Mdot
.5 Mabswid
.25753 .40886 m
.24597 .42578 L
s
.25957 .4062 m
.24597 .42578 L
s
.01 w
.28634 .39628 Mdot
.5 Mabswid
.28634 .39628 m
.27391 .39945 L
s
.28576 .38667 m
.28634 .39628 L
s
.29656 .38386 m
.28634 .39628 L
s
.30655 .38096 m
.28634 .39628 L
s
.01 w
.79208 .41902 Mdot
.5 Mabswid
.79208 .41902 m
.79216 .40999 L
s
.79208 .41902 m
.78405 .40461 L
s
.79208 .41902 m
.78044 .40251 L
s
.79208 .41902 m
.77484 .40071 L
s
.79208 .41902 m
.79544 .42134 L
s
.01 w
.55013 .28671 Mdot
.5 Mabswid
.55013 .28671 m
.55294 .27323 L
s
.55013 .28671 m
.55423 .27486 L
s
.55063 .29323 m
.55013 .28671 L
s
.01 w
.79544 .42134 Mdot
.5 Mabswid
.79544 .42134 m
.78698 .40574 L
s
.79544 .42134 m
.78405 .40461 L
s
.79544 .42134 m
.78044 .40251 L
s
.79544 .42134 m
.79814 .42267 L
s
.01 w
.31594 .3787 Mdot
.5 Mabswid
.31594 .3787 m
.30655 .38096 L
s
.31623 .36953 m
.31594 .3787 L
s
.31945 .3678 m
.31594 .3787 L
s
.01 w
.79814 .42267 Mdot
.5 Mabswid
.79814 .42267 m
.78698 .40574 L
s
.79814 .42267 m
.78405 .40461 L
s
.01 w
.5658 .30871 Mdot
.5 Mabswid
.5658 .30871 m
.58009 .30365 L
s
.5658 .30871 m
.56693 .30024 L
s
.56054 .30713 m
.5658 .30871 L
s
.01 w
.56054 .30713 Mdot
.5 Mabswid
.56054 .30713 m
.58009 .30365 L
s
.56054 .30713 m
.56693 .30024 L
s
.55424 .29579 m
.56054 .30713 L
s
.55092 .30308 m
.56054 .30713 L
s
.01 w
.55063 .29323 Mdot
.5 Mabswid
.55063 .29323 m
.55423 .27486 L
s
.55063 .29323 m
.55473 .28386 L
s
.55092 .30308 m
.55063 .29323 L
s
.01 w
.27391 .39945 Mdot
.5 Mabswid
.27391 .39945 m
.25792 .40346 L
s
.27698 .38876 m
.27391 .39945 L
s
.28576 .38667 m
.27391 .39945 L
s
.29656 .38386 m
.27391 .39945 L
s
.01 w
.5407 .30539 Mdot
.5 Mabswid
.5407 .30539 m
.52917 .2991 L
s
.5407 .30539 m
.54211 .29806 L
s
.5407 .30539 m
.53541 .30602 L
s
.55424 .29579 m
.5407 .30539 L
s
.55092 .30308 m
.5407 .30539 L
s
.01 w
.53541 .30602 Mdot
.5 Mabswid
.53541 .30602 m
.52917 .2991 L
s
.53541 .30602 m
.54211 .29806 L
s
.01 w
.55092 .30308 Mdot
.5 Mabswid
.55092 .30308 m
.54211 .29806 L
s
.55092 .30308 m
.56693 .30024 L
s
.55092 .30308 m
.55473 .28386 L
s
.55092 .30308 m
.55424 .29579 L
s
.01 w
.7625 .39472 Mdot
.5 Mabswid
.7625 .39472 m
.75415 .38185 L
s
.7625 .39472 m
.75284 .38033 L
s
.7625 .39472 m
.76455 .39633 L
s
.01 w
.2329 .40652 Mdot
.5 Mabswid
.2329 .40652 m
.25727 .39424 L
s
.25792 .40346 m
.2329 .40652 L
s
.01 w
.76455 .39633 Mdot
.5 Mabswid
.76455 .39633 m
.75764 .38349 L
s
.76455 .39633 m
.75415 .38185 L
s
.76455 .39633 m
.75284 .38033 L
s
.76455 .39633 m
.76919 .39853 L
s
.01 w
.25792 .40346 Mdot
.5 Mabswid
.25792 .40346 m
.25727 .39424 L
s
.25792 .40346 m
.25957 .4062 L
s
.27376 .39137 m
.25792 .40346 L
s
.27698 .38876 m
.25792 .40346 L
s
.28576 .38667 m
.25792 .40346 L
s
.01 w
.30655 .38096 Mdot
.5 Mabswid
.30655 .38096 m
.29656 .38386 L
s
.30909 .37137 m
.30655 .38096 L
s
.31623 .36953 m
.30655 .38096 L
s
.31945 .3678 m
.30655 .38096 L
s
.01 w
.76919 .39853 Mdot
.5 Mabswid
.76919 .39853 m
.76209 .38523 L
s
.76919 .39853 m
.75764 .38349 L
s
.76919 .39853 m
.75415 .38185 L
s
.76919 .39853 m
.77484 .40071 L
s
.01 w
.79216 .40999 Mdot
.5 Mabswid
.79216 .40999 m
.77586 .3915 L
s
.78044 .40251 m
.79216 .40999 L
s
.01 w
.25957 .4062 Mdot
.5 Mabswid
.25957 .4062 m
.25753 .40886 L
s
.27208 .39269 m
.25957 .4062 L
s
.27376 .39137 m
.25957 .4062 L
s
.27698 .38876 m
.25957 .4062 L
s
.01 w
.77484 .40071 Mdot
.5 Mabswid
.77484 .40071 m
.76605 .38593 L
s
.77484 .40071 m
.76209 .38523 L
s
.77484 .40071 m
.75764 .38349 L
s
.77484 .40071 m
.78044 .40251 L
s
.01 w
.25753 .40886 Mdot
.5 Mabswid
.27208 .39269 m
.25753 .40886 L
s
.27376 .39137 m
.25753 .40886 L
s
.01 w
.29656 .38386 Mdot
.5 Mabswid
.29656 .38386 m
.28576 .38667 L
s
.30179 .3734 m
.29656 .38386 L
s
.30909 .37137 m
.29656 .38386 L
s
.31623 .36953 m
.29656 .38386 L
s
.01 w
.55294 .27323 Mdot
.5 Mabswid
.55294 .27323 m
.55731 .25966 L
s
.55423 .27486 m
.55294 .27323 L
s
.01 w
.78044 .40251 Mdot
.5 Mabswid
.78044 .40251 m
.77586 .3915 L
s
.78044 .40251 m
.77024 .38844 L
s
.78044 .40251 m
.76605 .38593 L
s
.78044 .40251 m
.76209 .38523 L
s
.78044 .40251 m
.78405 .40461 L
s
.01 w
.78405 .40461 Mdot
.5 Mabswid
.78405 .40461 m
.7731 .38925 L
s
.78405 .40461 m
.77024 .38844 L
s
.78405 .40461 m
.76605 .38593 L
s
.78405 .40461 m
.78698 .40574 L
s
.01 w
.78698 .40574 Mdot
.5 Mabswid
.78698 .40574 m
.7731 .38925 L
s
.78698 .40574 m
.77024 .38844 L
s
.01 w
.28576 .38667 Mdot
.5 Mabswid
.28576 .38667 m
.27698 .38876 L
s
.29502 .37506 m
.28576 .38667 L
s
.30179 .3734 m
.28576 .38667 L
s
.30909 .37137 m
.28576 .38667 L
s
.01 w
.25727 .39424 Mdot
.5 Mabswid
.25727 .39424 m
.27855 .38056 L
s
.27698 .38876 m
.25727 .39424 L
s
.01 w
.75284 .38033 Mdot
.5 Mabswid
.75284 .38033 m
.73939 .36703 L
s
.75284 .38033 m
.73841 .36563 L
s
.75284 .38033 m
.75415 .38185 L
s
.01 w
.75415 .38185 Mdot
.5 Mabswid
.75415 .38185 m
.74239 .36835 L
s
.75415 .38185 m
.73939 .36703 L
s
.75415 .38185 m
.73841 .36563 L
s
.75415 .38185 m
.75764 .38349 L
s
.01 w
.31945 .3678 Mdot
.5 Mabswid
.31945 .3678 m
.31623 .36953 L
s
.32929 .35722 m
.31945 .3678 L
s
.33136 .35607 m
.31945 .3678 L
s
.01 w
.55424 .29579 Mdot
.5 Mabswid
.55424 .29579 m
.54211 .29806 L
s
.55424 .29579 m
.56693 .30024 L
s
.55424 .29579 m
.55841 .28068 L
s
.55424 .29579 m
.55811 .29266 L
s
.55424 .29579 m
.55473 .28386 L
s
.01 w
.27698 .38876 Mdot
.5 Mabswid
.27698 .38876 m
.27855 .38056 L
s
.27698 .38876 m
.27376 .39137 L
s
.2916 .3767 m
.27698 .38876 L
s
.29502 .37506 m
.27698 .38876 L
s
.30179 .3734 m
.27698 .38876 L
s
.01 w
.56693 .30024 Mdot
.5 Mabswid
.56693 .30024 m
.58789 .29916 L
s
.56693 .30024 m
.57474 .29496 L
s
.56693 .30024 m
.58009 .30365 L
s
.55811 .29266 m
.56693 .30024 L
s
.01 w
.58009 .30365 Mdot
.5 Mabswid
.58009 .30365 m
.60624 .30372 L
s
.58009 .30365 m
.58789 .29916 L
s
.01 w
.55423 .27486 Mdot
.5 Mabswid
.55423 .27486 m
.55731 .25966 L
s
.55423 .27486 m
.55888 .264 L
s
.55473 .28386 m
.55423 .27486 L
s
.01 w
.75764 .38349 Mdot
.5 Mabswid
.75764 .38349 m
.74639 .36975 L
s
.75764 .38349 m
.74239 .36835 L
s
.75764 .38349 m
.73939 .36703 L
s
.75764 .38349 m
.76209 .38523 L
s
.01 w
.31623 .36953 Mdot
.5 Mabswid
.31623 .36953 m
.30909 .37137 L
s
.32497 .35886 m
.31623 .36953 L
s
.32929 .35722 m
.31623 .36953 L
s
.33136 .35607 m
.31623 .36953 L
s
.01 w
.54211 .29806 Mdot
.5 Mabswid
.54211 .29806 m
.52836 .29375 L
s
.54211 .29806 m
.54163 .29195 L
s
.54211 .29806 m
.52917 .2991 L
s
.55811 .29266 m
.54211 .29806 L
s
.01 w
.27376 .39137 Mdot
.5 Mabswid
.27376 .39137 m
.27208 .39269 L
s
.28912 .37773 m
.27376 .39137 L
s
.2916 .3767 m
.27376 .39137 L
s
.29502 .37506 m
.27376 .39137 L
s
.01 w
.55473 .28386 Mdot
.5 Mabswid
.55473 .28386 m
.55888 .264 L
s
.55473 .28386 m
.55841 .28068 L
s
.01 w
.76209 .38523 Mdot
.5 Mabswid
.76209 .38523 m
.75037 .37123 L
s
.76209 .38523 m
.74639 .36975 L
s
.76209 .38523 m
.74239 .36835 L
s
.76209 .38523 m
.76605 .38593 L
s
.01 w
.52917 .2991 Mdot
.5 Mabswid
.52917 .2991 m
.51114 .29501 L
s
.52917 .2991 m
.52836 .29375 L
s
.01 w
.77586 .3915 Mdot
.5 Mabswid
.77586 .3915 m
.75373 .3706 L
s
.76605 .38593 m
.77586 .3915 L
s
.01 w
.27208 .39269 Mdot
.5 Mabswid
.28912 .37773 m
.27208 .39269 L
s
.2916 .3767 m
.27208 .39269 L
s
.01 w
.30909 .37137 Mdot
.5 Mabswid
.30909 .37137 m
.30179 .3734 L
s
.31983 .36022 m
.30909 .37137 L
s
.32497 .35886 m
.30909 .37137 L
s
.32929 .35722 m
.30909 .37137 L
s
.01 w
.76605 .38593 Mdot
.5 Mabswid
.76605 .38593 m
.75373 .3706 L
s
.76605 .38593 m
.75394 .37267 L
s
.76605 .38593 m
.75037 .37123 L
s
.76605 .38593 m
.74639 .36975 L
s
.76605 .38593 m
.77024 .38844 L
s
.01 w
.77024 .38844 Mdot
.5 Mabswid
.77024 .38844 m
.7564 .37318 L
s
.77024 .38844 m
.75394 .37267 L
s
.77024 .38844 m
.75037 .37123 L
s
.77024 .38844 m
.7731 .38925 L
s
.01 w
.30179 .3734 Mdot
.5 Mabswid
.30179 .3734 m
.29502 .37506 L
s
.31487 .36111 m
.30179 .3734 L
s
.31983 .36022 m
.30179 .3734 L
s
.32497 .35886 m
.30179 .3734 L
s
.01 w
.7731 .38925 Mdot
.5 Mabswid
.7731 .38925 m
.7564 .37318 L
s
.7731 .38925 m
.75394 .37267 L
s
.01 w
.27855 .38056 Mdot
.5 Mabswid
.27855 .38056 m
.30034 .3662 L
s
.29502 .37506 m
.27855 .38056 L
s
.01 w
.73841 .36563 Mdot
.5 Mabswid
.73841 .36563 m
.72066 .3522 L
s
.73841 .36563 m
.71976 .35096 L
s
.73841 .36563 m
.73939 .36703 L
s
.01 w
.73939 .36703 Mdot
.5 Mabswid
.73939 .36703 m
.72363 .35329 L
s
.73939 .36703 m
.72066 .3522 L
s
.73939 .36703 m
.71976 .35096 L
s
.73939 .36703 m
.74239 .36835 L
s
.01 w
.29502 .37506 Mdot
.5 Mabswid
.29502 .37506 m
.30034 .3662 L
s
.29502 .37506 m
.2916 .3767 L
s
.31142 .36274 m
.29502 .37506 L
s
.31487 .36111 m
.29502 .37506 L
s
.31983 .36022 m
.29502 .37506 L
s
.01 w
.74239 .36835 Mdot
.5 Mabswid
.74239 .36835 m
.7276 .35453 L
s
.74239 .36835 m
.72363 .35329 L
s
.74239 .36835 m
.72066 .3522 L
s
.74239 .36835 m
.74639 .36975 L
s
.01 w
.33136 .35607 Mdot
.5 Mabswid
.33136 .35607 m
.32929 .35722 L
s
.34709 .34529 m
.33136 .35607 L
s
.34829 .34383 m
.33136 .35607 L
s
.01 w
.32929 .35722 Mdot
.5 Mabswid
.32929 .35722 m
.32497 .35886 L
s
.34391 .34632 m
.32929 .35722 L
s
.34709 .34529 m
.32929 .35722 L
s
.34829 .34383 m
.32929 .35722 L
s
.01 w
.2916 .3767 Mdot
.5 Mabswid
.2916 .3767 m
.28912 .37773 L
s
.30873 .36352 m
.2916 .3767 L
s
.31142 .36274 m
.2916 .3767 L
s
.31487 .36111 m
.2916 .3767 L
s
.01 w
.74639 .36975 Mdot
.5 Mabswid
.74639 .36975 m
.73318 .35661 L
s
.74639 .36975 m
.7276 .35453 L
s
.74639 .36975 m
.72363 .35329 L
s
.74639 .36975 m
.75037 .37123 L
s
.01 w
.55731 .25966 Mdot
.5 Mabswid
.55731 .25966 m
.56227 .2423 L
s
.55888 .264 m
.55731 .25966 L
s
.01 w
.28912 .37773 Mdot
.5 Mabswid
.30873 .36352 m
.28912 .37773 L
s
.31142 .36274 m
.28912 .37773 L
s
.01 w
.58789 .29916 Mdot
.5 Mabswid
.58789 .29916 m
.60624 .30372 L
s
.57474 .29496 m
.58789 .29916 L
s
.58382 .29365 m
.58789 .29916 L
s
.61077 .30133 m
.58789 .29916 L
s
.01 w
.57474 .29496 Mdot
.5 Mabswid
.55811 .29266 m
.57474 .29496 L
s
.58382 .29365 m
.57474 .29496 L
s
.01 w
.32497 .35886 Mdot
.5 Mabswid
.32497 .35886 m
.31983 .36022 L
s
.34003 .34743 m
.32497 .35886 L
s
.34391 .34632 m
.32497 .35886 L
s
.34709 .34529 m
.32497 .35886 L
s
.01 w
.55811 .29266 Mdot
.5 Mabswid
.55811 .29266 m
.54163 .29195 L
s
.55811 .29266 m
.56174 .28608 L
s
.55811 .29266 m
.55841 .28068 L
s
.5384 .28951 m
.55811 .29266 L
s
.58382 .29365 m
.55811 .29266 L
s
.01 w
.75037 .37123 Mdot
.5 Mabswid
.75037 .37123 m
.75373 .3706 L
s
.75037 .37123 m
.73467 .35684 L
s
.75037 .37123 m
.73318 .35661 L
s
.75037 .37123 m
.7276 .35453 L
s
.75037 .37123 m
.75394 .37267 L
s
.01 w
.54163 .29195 Mdot
.5 Mabswid
.54163 .29195 m
.52836 .29375 L
s
.5384 .28951 m
.54163 .29195 L
s
.01 w
.75373 .3706 Mdot
.5 Mabswid
.75373 .3706 m
.72966 .35023 L
s
.73318 .35661 m
.75373 .3706 L
s
.01 w
.60624 .30372 Mdot
.5 Mabswid
.61077 .30133 m
.60624 .30372 L
s
.63798 .31069 m
.60624 .30372 L
s
.01 w
.55841 .28068 Mdot
.5 Mabswid
.55841 .28068 m
.56242 .26754 L
s
.55841 .28068 m
.56174 .28608 L
s
.55841 .28068 m
.55888 .264 L
s
.01 w
.71976 .35096 Mdot
.5 Mabswid
.71976 .35096 m
.69831 .33766 L
s
.71976 .35096 m
.69702 .33683 L
s
.71976 .35096 m
.72066 .3522 L
s
.01 w
.75394 .37267 Mdot
.5 Mabswid
.75394 .37267 m
.73692 .3573 L
s
.75394 .37267 m
.73467 .35684 L
s
.75394 .37267 m
.73318 .35661 L
s
.75394 .37267 m
.7564 .37318 L
s
.01 w
.52836 .29375 Mdot
.5 Mabswid
.52836 .29375 m
.51114 .29501 L
s
.51174 .29221 m
.52836 .29375 L
s
.5384 .28951 m
.52836 .29375 L
s
.01 w
.31983 .36022 Mdot
.5 Mabswid
.31983 .36022 m
.31487 .36111 L
s
.33712 .34752 m
.31983 .36022 L
s
.34003 .34743 m
.31983 .36022 L
s
.34391 .34632 m
.31983 .36022 L
s
.01 w
.72066 .3522 Mdot
.5 Mabswid
.72066 .3522 m
.70151 .33852 L
s
.72066 .3522 m
.69831 .33766 L
s
.72066 .3522 m
.69702 .33683 L
s
.72066 .3522 m
.72363 .35329 L
s
.01 w
.30034 .3662 Mdot
.5 Mabswid
.30034 .3662 m
.32535 .35118 L
s
.31487 .36111 m
.30034 .3662 L
s
.01 w
.7564 .37318 Mdot
.5 Mabswid
.7564 .37318 m
.73692 .3573 L
s
.7564 .37318 m
.73467 .35684 L
s
.01 w
.72363 .35329 Mdot
.5 Mabswid
.72363 .35329 m
.706 .3396 L
s
.72363 .35329 m
.70151 .33852 L
s
.72363 .35329 m
.69831 .33766 L
s
.72363 .35329 m
.7276 .35453 L
s
.01 w
.55888 .264 Mdot
.5 Mabswid
.55888 .264 m
.56227 .2423 L
s
.55888 .264 m
.56314 .24986 L
s
.55888 .264 m
.56242 .26754 L
s
.01 w
.31487 .36111 Mdot
.5 Mabswid
.31487 .36111 m
.32535 .35118 L
s
.31487 .36111 m
.31142 .36274 L
s
.33288 .34942 m
.31487 .36111 L
s
.33712 .34752 m
.31487 .36111 L
s
.34003 .34743 m
.31487 .36111 L
s
.01 w
.34829 .34383 Mdot
.5 Mabswid
.34829 .34383 m
.34709 .34529 L
s
.36847 .33343 m
.34829 .34383 L
s
.36934 .33206 m
.34829 .34383 L
s
.01 w
.51114 .29501 Mdot
.5 Mabswid
.4843 .29648 m
.51114 .29501 L
s
.51174 .29221 m
.51114 .29501 L
s
.01 w
.34709 .34529 Mdot
.5 Mabswid
.34709 .34529 m
.34391 .34632 L
s
.36597 .33436 m
.34709 .34529 L
s
.36847 .33343 m
.34709 .34529 L
s
.36934 .33206 m
.34709 .34529 L
s
.01 w
.7276 .35453 Mdot
.5 Mabswid
.7276 .35453 m
.71103 .34062 L
s
.7276 .35453 m
.706 .3396 L
s
.7276 .35453 m
.70151 .33852 L
s
.7276 .35453 m
.73318 .35661 L
s
.01 w
.31142 .36274 Mdot
.5 Mabswid
.31142 .36274 m
.30873 .36352 L
s
.33049 .34997 m
.31142 .36274 L
s
.33288 .34942 m
.31142 .36274 L
s
.33712 .34752 m
.31142 .36274 L
s
.01 w
.69702 .33683 Mdot
.5 Mabswid
.69702 .33683 m
.67225 .32386 L
s
.69702 .33683 m
.67049 .32326 L
s
.69702 .33683 m
.69831 .33766 L
s
.01 w
.30873 .36352 Mdot
.5 Mabswid
.33049 .34997 m
.30873 .36352 L
s
.33288 .34942 m
.30873 .36352 L
s
.01 w
.34391 .34632 Mdot
.5 Mabswid
.34391 .34632 m
.34003 .34743 L
s
.36269 .33516 m
.34391 .34632 L
s
.36597 .33436 m
.34391 .34632 L
s
.36847 .33343 m
.34391 .34632 L
s
.01 w
.73318 .35661 Mdot
.5 Mabswid
.73318 .35661 m
.72966 .35023 L
s
.73318 .35661 m
.71307 .34145 L
s
.73318 .35661 m
.71103 .34062 L
s
.73318 .35661 m
.706 .3396 L
s
.73318 .35661 m
.73467 .35684 L
s
.01 w
.69831 .33766 Mdot
.5 Mabswid
.69831 .33766 m
.67672 .32448 L
s
.69831 .33766 m
.67225 .32386 L
s
.69831 .33766 m
.67049 .32326 L
s
.69831 .33766 m
.70151 .33852 L
s
.01 w
.34003 .34743 Mdot
.5 Mabswid
.34003 .34743 m
.33712 .34752 L
s
.35931 .33601 m
.34003 .34743 L
s
.36269 .33516 m
.34003 .34743 L
s
.36597 .33436 m
.34003 .34743 L
s
.01 w
.58382 .29365 Mdot
.5 Mabswid
.58382 .29365 m
.56392 .28488 L
s
.58382 .29365 m
.56174 .28608 L
s
.58382 .29365 m
.59048 .29192 L
s
.61696 .30083 m
.58382 .29365 L
s
.61077 .30133 m
.58382 .29365 L
s
.01 w
.73467 .35684 Mdot
.5 Mabswid
.73467 .35684 m
.71479 .34185 L
s
.73467 .35684 m
.71307 .34145 L
s
.73467 .35684 m
.71103 .34062 L
s
.73467 .35684 m
.73692 .3573 L
s
.01 w
.61077 .30133 Mdot
.5 Mabswid
.61077 .30133 m
.59048 .29192 L
s
.61077 .30133 m
.61696 .30083 L
s
.645 .31148 m
.61077 .30133 L
s
.63798 .31069 m
.61077 .30133 L
s
.01 w
.70151 .33852 Mdot
.5 Mabswid
.70151 .33852 m
.68162 .32481 L
s
.70151 .33852 m
.67672 .32448 L
s
.70151 .33852 m
.67225 .32386 L
s
.70151 .33852 m
.706 .3396 L
s
.01 w
.63798 .31069 Mdot
.5 Mabswid
.63798 .31069 m
.61696 .30083 L
s
.63798 .31069 m
.645 .31148 L
s
.67225 .32386 m
.63798 .31069 L
s
.67049 .32326 m
.63798 .31069 L
s
.01 w
.67049 .32326 Mdot
.5 Mabswid
.67049 .32326 m
.645 .31148 L
s
.67049 .32326 m
.67225 .32386 L
s
.01 w
.73692 .3573 Mdot
.5 Mabswid
.73692 .3573 m
.71479 .34185 L
s
.73692 .3573 m
.71307 .34145 L
s
.01 w
.32535 .35118 Mdot
.5 Mabswid
.32535 .35118 m
.35674 .33483 L
s
.33712 .34752 m
.32535 .35118 L
s
.01 w
.36934 .33206 Mdot
.5 Mabswid
.36934 .33206 m
.36847 .33343 L
s
.39303 .32222 m
.36934 .33206 L
s
.39382 .32125 m
.36934 .33206 L
s
.01 w
.5384 .28951 Mdot
.5 Mabswid
.5384 .28951 m
.56392 .28488 L
s
.5384 .28951 m
.56174 .28608 L
s
.5384 .28951 m
.50929 .29081 L
s
.5384 .28951 m
.51174 .29221 L
s
.5384 .28951 m
.53689 .28699 L
s
.01 w
.72966 .35023 Mdot
.5 Mabswid
.70493 .33213 m
.72966 .35023 L
s
.71103 .34062 m
.72966 .35023 L
s
.01 w
.56174 .28608 Mdot
.5 Mabswid
.56174 .28608 m
.56392 .28488 L
s
.56174 .28608 m
.56242 .26754 L
s
.53689 .28699 m
.56174 .28608 L
s
.59048 .29192 m
.56174 .28608 L
s
.01 w
.67225 .32386 Mdot
.5 Mabswid
.67225 .32386 m
.65027 .31144 L
s
.67225 .32386 m
.645 .31148 L
s
.67225 .32386 m
.67672 .32448 L
s
.01 w
.33712 .34752 Mdot
.5 Mabswid
.33712 .34752 m
.35674 .33483 L
s
.33712 .34752 m
.33288 .34942 L
s
.35634 .33696 m
.33712 .34752 L
s
.35931 .33601 m
.33712 .34752 L
s
.36269 .33516 m
.33712 .34752 L
s
.01 w
.36847 .33343 Mdot
.5 Mabswid
.36847 .33343 m
.36597 .33436 L
s
.39086 .32308 m
.36847 .33343 L
s
.39303 .32222 m
.36847 .33343 L
s
.39382 .32125 m
.36847 .33343 L
s
.01 w
.706 .3396 Mdot
.5 Mabswid
.706 .3396 m
.6865 .32516 L
s
.706 .3396 m
.68162 .32481 L
s
.706 .3396 m
.67672 .32448 L
s
.706 .3396 m
.71103 .34062 L
s
.01 w
.33288 .34942 Mdot
.5 Mabswid
.33288 .34942 m
.33049 .34997 L
s
.35432 .33706 m
.33288 .34942 L
s
.35634 .33696 m
.33288 .34942 L
s
.35931 .33601 m
.33288 .34942 L
s
.01 w
.36597 .33436 Mdot
.5 Mabswid
.36597 .33436 m
.36269 .33516 L
s
.38772 .32361 m
.36597 .33436 L
s
.39086 .32308 m
.36597 .33436 L
s
.39303 .32222 m
.36597 .33436 L
s
.01 w
.51174 .29221 Mdot
.5 Mabswid
.51174 .29221 m
.47982 .29614 L
s
.51174 .29221 m
.4843 .29648 L
s
.51174 .29221 m
.50929 .29081 L
s
.53689 .28699 m
.51174 .29221 L
s
.01 w
.33049 .34997 Mdot
.5 Mabswid
.35432 .33706 m
.33049 .34997 L
s
.35634 .33696 m
.33049 .34997 L
s
.01 w
.645 .31148 Mdot
.5 Mabswid
.645 .31148 m
.62275 .29989 L
s
.645 .31148 m
.61696 .30083 L
s
.645 .31148 m
.65027 .31144 L
s
.67672 .32448 m
.645 .31148 L
s
.01 w
.71103 .34062 Mdot
.5 Mabswid
.71103 .34062 m
.70493 .33213 L
s
.71103 .34062 m
.68877 .32642 L
s
.71103 .34062 m
.6865 .32516 L
s
.71103 .34062 m
.68162 .32481 L
s
.71103 .34062 m
.71307 .34145 L
s
.01 w
.56242 .26754 Mdot
.5 Mabswid
.56242 .26754 m
.56594 .25144 L
s
.56242 .26754 m
.56548 .26766 L
s
.56242 .26754 m
.56392 .28488 L
s
.56242 .26754 m
.56314 .24986 L
s
.01 w
.67672 .32448 Mdot
.5 Mabswid
.67672 .32448 m
.65519 .31063 L
s
.67672 .32448 m
.65027 .31144 L
s
.67672 .32448 m
.68162 .32481 L
s
.01 w
.36269 .33516 Mdot
.5 Mabswid
.36269 .33516 m
.35931 .33601 L
s
.38272 .32492 m
.36269 .33516 L
s
.38772 .32361 m
.36269 .33516 L
s
.39086 .32308 m
.36269 .33516 L
s
.01 w
.39382 .32125 Mdot
.5 Mabswid
.39382 .32125 m
.39303 .32222 L
s
.4204 .31217 m
.39382 .32125 L
s
.42118 .31135 m
.39382 .32125 L
s
.01 w
.61696 .30083 Mdot
.5 Mabswid
.61696 .30083 m
.59479 .29023 L
s
.61696 .30083 m
.59048 .29192 L
s
.61696 .30083 m
.62275 .29989 L
s
.65027 .31144 m
.61696 .30083 L
s
.01 w
.71307 .34145 Mdot
.5 Mabswid
.71307 .34145 m
.69063 .327 L
s
.71307 .34145 m
.68877 .32642 L
s
.71307 .34145 m
.6865 .32516 L
s
.71307 .34145 m
.71479 .34185 L
s
.01 w
.4843 .29648 Mdot
.5 Mabswid
.4843 .29648 m
.45006 .30326 L
s
.4843 .29648 m
.45101 .303 L
s
.4843 .29648 m
.47982 .29614 L
s
.50929 .29081 m
.4843 .29648 L
s
.01 w
.39303 .32222 Mdot
.5 Mabswid
.39303 .32222 m
.39086 .32308 L
s
.41822 .31246 m
.39303 .32222 L
s
.4204 .31217 m
.39303 .32222 L
s
.42118 .31135 m
.39303 .32222 L
s
.01 w
.56227 .2423 Mdot
.5 Mabswid
.56227 .2423 m
.56666 .23222 L
s
.56227 .2423 m
.56645 .21848 L
s
.56314 .24986 m
.56227 .2423 L
s
.01 w
.35931 .33601 Mdot
.5 Mabswid
.35931 .33601 m
.35674 .33483 L
s
.35931 .33601 m
.35634 .33696 L
s
.38212 .32486 m
.35931 .33601 L
s
.38272 .32492 m
.35931 .33601 L
s
.38772 .32361 m
.35931 .33601 L
s
.01 w
.59048 .29192 Mdot
.5 Mabswid
.59048 .29192 m
.5662 .28271 L
s
.59048 .29192 m
.56392 .28488 L
s
.59048 .29192 m
.59479 .29023 L
s
.62275 .29989 m
.59048 .29192 L
s
.01 w
.71479 .34185 Mdot
.5 Mabswid
.71479 .34185 m
.69063 .327 L
s
.71479 .34185 m
.68877 .32642 L
s
.01 w
.68162 .32481 Mdot
.5 Mabswid
.68162 .32481 m
.66021 .31027 L
s
.68162 .32481 m
.65519 .31063 L
s
.68162 .32481 m
.65027 .31144 L
s
.68162 .32481 m
.6865 .32516 L
s
.01 w
.39086 .32308 Mdot
.5 Mabswid
.39086 .32308 m
.38772 .32361 L
s
.41491 .3129 m
.39086 .32308 L
s
.41822 .31246 m
.39086 .32308 L
s
.4204 .31217 m
.39086 .32308 L
s
.01 w
.35674 .33483 Mdot
.5 Mabswid
.35674 .33483 m
.38961 .31919 L
s
.38272 .32492 m
.35674 .33483 L
s
.01 w
.56392 .28488 Mdot
.5 Mabswid
.56392 .28488 m
.5662 .28271 L
s
.56392 .28488 m
.56548 .26766 L
s
.53669 .28492 m
.56392 .28488 L
s
.53689 .28699 m
.56392 .28488 L
s
.59479 .29023 m
.56392 .28488 L
s
.01 w
.42118 .31135 Mdot
.5 Mabswid
.42118 .31135 m
.4204 .31217 L
s
.45006 .30326 m
.42118 .31135 L
s
.45101 .303 m
.42118 .31135 L
s
.01 w
.65027 .31144 Mdot
.5 Mabswid
.65027 .31144 m
.62837 .29871 L
s
.65027 .31144 m
.62275 .29989 L
s
.65027 .31144 m
.65519 .31063 L
s
.01 w
.56314 .24986 Mdot
.5 Mabswid
.56314 .24986 m
.56666 .23222 L
s
.56314 .24986 m
.56594 .25144 L
s
.01 w
.35634 .33696 Mdot
.5 Mabswid
.35634 .33696 m
.35432 .33706 L
s
.38042 .32504 m
.35634 .33696 L
s
.38212 .32486 m
.35634 .33696 L
s
.38272 .32492 m
.35634 .33696 L
s
.01 w
.45101 .303 Mdot
.5 Mabswid
.45101 .303 m
.4204 .31217 L
s
.45101 .303 m
.45006 .30326 L
s
.47982 .29614 m
.45101 .303 L
s
.01 w
.70493 .33213 Mdot
.5 Mabswid
.67898 .315 m
.70493 .33213 L
s
.6865 .32516 m
.70493 .33213 L
s
.01 w
.53689 .28699 Mdot
.5 Mabswid
.53689 .28699 m
.5662 .28271 L
s
.53689 .28699 m
.50719 .28924 L
s
.53689 .28699 m
.50929 .29081 L
s
.53689 .28699 m
.53669 .28492 L
s
.01 w
.4204 .31217 Mdot
.5 Mabswid
.4204 .31217 m
.41822 .31246 L
s
.44725 .30319 m
.4204 .31217 L
s
.45006 .30326 m
.4204 .31217 L
s
.01 w
.50929 .29081 Mdot
.5 Mabswid
.50929 .29081 m
.47715 .29537 L
s
.50929 .29081 m
.47982 .29614 L
s
.50929 .29081 m
.50719 .28924 L
s
.53669 .28492 m
.50929 .29081 L
s
.01 w
.35432 .33706 Mdot
.5 Mabswid
.38042 .32504 m
.35432 .33706 L
s
.38212 .32486 m
.35432 .33706 L
s
.01 w
.38772 .32361 Mdot
.5 Mabswid
.38772 .32361 m
.38272 .32492 L
s
.41113 .31333 m
.38772 .32361 L
s
.41491 .3129 m
.38772 .32361 L
s
.41822 .31246 m
.38772 .32361 L
s
.01 w
.45006 .30326 Mdot
.5 Mabswid
.45006 .30326 m
.41822 .31246 L
s
.45006 .30326 m
.44725 .30319 L
s
.47715 .29537 m
.45006 .30326 L
s
.47982 .29614 m
.45006 .30326 L
s
.01 w
.6865 .32516 Mdot
.5 Mabswid
.6865 .32516 m
.67898 .315 L
s
.6865 .32516 m
.66205 .31213 L
s
.6865 .32516 m
.66021 .31027 L
s
.6865 .32516 m
.65519 .31063 L
s
.6865 .32516 m
.68877 .32642 L
s
.01 w
.47982 .29614 Mdot
.5 Mabswid
.47982 .29614 m
.44725 .30319 L
s
.47982 .29614 m
.47715 .29537 L
s
.50719 .28924 m
.47982 .29614 L
s
.01 w
.62275 .29989 Mdot
.5 Mabswid
.62275 .29989 m
.59851 .28793 L
s
.62275 .29989 m
.59479 .29023 L
s
.62275 .29989 m
.62837 .29871 L
s
.65519 .31063 m
.62275 .29989 L
s
.01 w
.41822 .31246 Mdot
.5 Mabswid
.41822 .31246 m
.41491 .3129 L
s
.44424 .30291 m
.41822 .31246 L
s
.44725 .30319 m
.41822 .31246 L
s
.01 w
.38272 .32492 Mdot
.5 Mabswid
.38272 .32492 m
.38961 .31919 L
s
.38272 .32492 m
.38212 .32486 L
s
.40983 .31372 m
.38272 .32492 L
s
.41113 .31333 m
.38272 .32492 L
s
.41491 .3129 m
.38272 .32492 L
s
.01 w
.68877 .32642 Mdot
.5 Mabswid
.68877 .32642 m
.66407 .31365 L
s
.68877 .32642 m
.66205 .31213 L
s
.68877 .32642 m
.66021 .31027 L
s
.68877 .32642 m
.69063 .327 L
s
.01 w
.65519 .31063 Mdot
.5 Mabswid
.65519 .31063 m
.6307 .29411 L
s
.65519 .31063 m
.62837 .29871 L
s
.65519 .31063 m
.66021 .31027 L
s
.01 w
.56548 .26766 Mdot
.5 Mabswid
.56548 .26766 m
.568 .26156 L
s
.56548 .26766 m
.5662 .28271 L
s
.56548 .26766 m
.56594 .25144 L
s
.01 w
.59479 .29023 Mdot
.5 Mabswid
.59479 .29023 m
.56813 .27868 L
s
.59479 .29023 m
.5662 .28271 L
s
.59479 .29023 m
.59851 .28793 L
s
.62837 .29871 m
.59479 .29023 L
s
.01 w
.69063 .327 Mdot
.5 Mabswid
.69063 .327 m
.66407 .31365 L
s
.69063 .327 m
.66205 .31213 L
s
.01 w
.44725 .30319 Mdot
.5 Mabswid
.44725 .30319 m
.41491 .3129 L
s
.44725 .30319 m
.44424 .30291 L
s
.47498 .29403 m
.44725 .30319 L
s
.47715 .29537 m
.44725 .30319 L
s
.01 w
.38212 .32486 Mdot
.5 Mabswid
.38212 .32486 m
.38042 .32504 L
s
.40862 .31369 m
.38212 .32486 L
s
.40983 .31372 m
.38212 .32486 L
s
.41113 .31333 m
.38212 .32486 L
s
.01 w
.41491 .3129 Mdot
.5 Mabswid
.41491 .3129 m
.41113 .31333 L
s
.4411 .30274 m
.41491 .3129 L
s
.44424 .30291 m
.41491 .3129 L
s
.01 w
.5662 .28271 Mdot
.5 Mabswid
.5662 .28271 m
.56813 .27868 L
s
.5662 .28271 m
.568 .26156 L
s
.537 .28239 m
.5662 .28271 L
s
.53669 .28492 m
.5662 .28271 L
s
.59851 .28793 m
.5662 .28271 L
s
.01 w
.47715 .29537 Mdot
.5 Mabswid
.47715 .29537 m
.44424 .30291 L
s
.47715 .29537 m
.47498 .29403 L
s
.50487 .28747 m
.47715 .29537 L
s
.50719 .28924 m
.47715 .29537 L
s
.01 w
.38042 .32504 Mdot
.5 Mabswid
.40862 .31369 m
.38042 .32504 L
s
.40983 .31372 m
.38042 .32504 L
s
.01 w
.38961 .31919 Mdot
.5 Mabswid
.42124 .30617 m
.38961 .31919 L
s
.41113 .31333 m
.38961 .31919 L
s
.01 w
.53669 .28492 Mdot
.5 Mabswid
.53669 .28492 m
.56813 .27868 L
s
.53669 .28492 m
.50487 .28747 L
s
.53669 .28492 m
.50719 .28924 L
s
.53669 .28492 m
.537 .28239 L
s
.01 w
.56594 .25144 Mdot
.5 Mabswid
.56594 .25144 m
.56934 .24146 L
s
.56594 .25144 m
.568 .26156 L
s
.56594 .25144 m
.56666 .23222 L
s
.01 w
.50719 .28924 Mdot
.5 Mabswid
.50719 .28924 m
.47498 .29403 L
s
.50719 .28924 m
.50487 .28747 L
s
.537 .28239 m
.50719 .28924 L
s
.01 w
.67898 .315 Mdot
.5 Mabswid
.65173 .29745 m
.67898 .315 L
s
.66021 .31027 m
.67898 .315 L
s
.01 w
.66021 .31027 Mdot
.5 Mabswid
.66021 .31027 m
.65173 .29745 L
s
.66021 .31027 m
.63471 .30044 L
s
.66021 .31027 m
.6307 .29411 L
s
.66021 .31027 m
.62837 .29871 L
s
.66021 .31027 m
.66205 .31213 L
s
.01 w
.62837 .29871 Mdot
.5 Mabswid
.62837 .29871 m
.60923 .28697 L
s
.62837 .29871 m
.59851 .28793 L
s
.62837 .29871 m
.6307 .29411 L
s
.01 w
.41113 .31333 Mdot
.5 Mabswid
.41113 .31333 m
.42124 .30617 L
s
.41113 .31333 m
.40983 .31372 L
s
.43969 .30351 m
.41113 .31333 L
s
.4411 .30274 m
.41113 .31333 L
s
.44424 .30291 m
.41113 .31333 L
s
.01 w
.44424 .30291 Mdot
.5 Mabswid
.44424 .30291 m
.4411 .30274 L
s
.47228 .2931 m
.44424 .30291 L
s
.47498 .29403 m
.44424 .30291 L
s
.01 w
.66205 .31213 Mdot
.5 Mabswid
.66205 .31213 m
.63473 .30184 L
s
.66205 .31213 m
.63471 .30044 L
s
.66205 .31213 m
.6307 .29411 L
s
.66205 .31213 m
.66407 .31365 L
s
.01 w
.40983 .31372 Mdot
.5 Mabswid
.40983 .31372 m
.40862 .31369 L
s
.43855 .30382 m
.40983 .31372 L
s
.43969 .30351 m
.40983 .31372 L
s
.4411 .30274 m
.40983 .31372 L
s
.01 w
.66407 .31365 Mdot
.5 Mabswid
.66407 .31365 m
.63473 .30184 L
s
.66407 .31365 m
.63471 .30044 L
s
.01 w
.59851 .28793 Mdot
.5 Mabswid
.59851 .28793 m
.57059 .27666 L
s
.59851 .28793 m
.56813 .27868 L
s
.59851 .28793 m
.60923 .28697 L
s
.6307 .29411 m
.59851 .28793 L
s
.01 w
.40862 .31369 Mdot
.5 Mabswid
.43855 .30382 m
.40862 .31369 L
s
.43969 .30351 m
.40862 .31369 L
s
.01 w
.47498 .29403 Mdot
.5 Mabswid
.47498 .29403 m
.4411 .30274 L
s
.47498 .29403 m
.47228 .2931 L
s
.50639 .28306 m
.47498 .29403 L
s
.50487 .28747 m
.47498 .29403 L
s
.01 w
.56666 .23222 Mdot
.5 Mabswid
.56666 .23222 m
.57072 .22211 L
s
.56666 .23222 m
.56934 .24146 L
s
.56666 .23222 m
.56945 .20963 L
s
.56645 .21848 m
.56666 .23222 L
s
.01 w
.4411 .30274 Mdot
.5 Mabswid
.4411 .30274 m
.42124 .30617 L
s
.4411 .30274 m
.45307 .2945 L
s
.4411 .30274 m
.43969 .30351 L
s
.47128 .2946 m
.4411 .30274 L
s
.47228 .2931 m
.4411 .30274 L
s
.01 w
.56813 .27868 Mdot
.5 Mabswid
.56813 .27868 m
.57059 .27666 L
s
.56813 .27868 m
.5707 .25726 L
s
.568 .26156 m
.56813 .27868 L
s
.537 .28239 m
.56813 .27868 L
s
.01 w
.42124 .30617 Mdot
.5 Mabswid
.45307 .2945 m
.42124 .30617 L
s
.01 w
.568 .26156 Mdot
.5 Mabswid
.568 .26156 m
.5707 .25726 L
s
.568 .26156 m
.56934 .24146 L
s
.01 w
.50487 .28747 Mdot
.5 Mabswid
.50487 .28747 m
.47228 .2931 L
s
.50487 .28747 m
.50639 .28306 L
s
.52968 .28014 m
.50487 .28747 L
s
.537 .28239 m
.50487 .28747 L
s
.01 w
.537 .28239 Mdot
.5 Mabswid
.537 .28239 m
.57059 .27666 L
s
.537 .28239 m
.50639 .28306 L
s
.537 .28239 m
.52968 .28014 L
s
.01 w
.6307 .29411 Mdot
.5 Mabswid
.6307 .29411 m
.60164 .27013 L
s
.6307 .29411 m
.65173 .29745 L
s
.6307 .29411 m
.62536 .27743 L
s
.6307 .29411 m
.60311 .28983 L
s
.6307 .29411 m
.60923 .28697 L
s
.6307 .29411 m
.63471 .30044 L
s
.01 w
.56645 .21848 Mdot
.5 Mabswid
.56645 .21848 m
.56945 .20963 L
s
.56645 .21848 m
.56922 .1972 L
s
.01 w
.43969 .30351 Mdot
.5 Mabswid
.43969 .30351 m
.43855 .30382 L
s
.4699 .29575 m
.43969 .30351 L
s
.47128 .2946 m
.43969 .30351 L
s
.47228 .2931 m
.43969 .30351 L
s
.01 w
.65173 .29745 Mdot
.5 Mabswid
.62536 .27743 m
.65173 .29745 L
s
.01 w
.63471 .30044 Mdot
.5 Mabswid
.63471 .30044 m
.60423 .29251 L
s
.63471 .30044 m
.60311 .28983 L
s
.63471 .30044 m
.60923 .28697 L
s
.63471 .30044 m
.63473 .30184 L
s
.01 w
.43855 .30382 Mdot
.5 Mabswid
.4699 .29575 m
.43855 .30382 L
s
.47128 .2946 m
.43855 .30382 L
s
.01 w
.47228 .2931 Mdot
.5 Mabswid
.47228 .2931 m
.45307 .2945 L
s
.47228 .2931 m
.48552 .28256 L
s
.47228 .2931 m
.47128 .2946 L
s
.50251 .28851 m
.47228 .2931 L
s
.50639 .28306 m
.47228 .2931 L
s
.01 w
.63473 .30184 Mdot
.5 Mabswid
.63473 .30184 m
.60423 .29251 L
s
.63473 .30184 m
.60311 .28983 L
s
.01 w
.60923 .28697 Mdot
.5 Mabswid
.60923 .28697 m
.60164 .27013 L
s
.60923 .28697 m
.57059 .27666 L
s
.60923 .28697 m
.60311 .28983 L
s
.01 w
.45307 .2945 Mdot
.5 Mabswid
.48552 .28256 m
.45307 .2945 L
s
.01 w
.47128 .2946 Mdot
.5 Mabswid
.47128 .2946 m
.4699 .29575 L
s
.50311 .28973 m
.47128 .2946 L
s
.50251 .28851 m
.47128 .2946 L
s
.50639 .28306 m
.47128 .2946 L
s
.01 w
.56934 .24146 Mdot
.5 Mabswid
.56934 .24146 m
.57287 .23584 L
s
.56934 .24146 m
.5707 .25726 L
s
.56934 .24146 m
.57072 .22211 L
s
.01 w
.4699 .29575 Mdot
.5 Mabswid
.50311 .28973 m
.4699 .29575 L
s
.50251 .28851 m
.4699 .29575 L
s
.01 w
.60311 .28983 Mdot
.5 Mabswid
.60311 .28983 m
.57125 .286 L
s
.60311 .28983 m
.57164 .28276 L
s
.60311 .28983 m
.57059 .27666 L
s
.60311 .28983 m
.60423 .29251 L
s
.01 w
.50639 .28306 Mdot
.5 Mabswid
.50639 .28306 m
.54239 .2651 L
s
.50639 .28306 m
.48552 .28256 L
s
.50639 .28306 m
.51702 .26812 L
s
.50639 .28306 m
.50251 .28851 L
s
.5371 .28414 m
.50639 .28306 L
s
.52968 .28014 m
.50639 .28306 L
s
.01 w
.52968 .28014 Mdot
.5 Mabswid
.52968 .28014 m
.54239 .2651 L
s
.52968 .28014 m
.57059 .27666 L
s
.52968 .28014 m
.50251 .28851 L
s
.52968 .28014 m
.5371 .28414 L
s
.01 w
.50251 .28851 Mdot
.5 Mabswid
.50251 .28851 m
.50311 .28973 L
s
.53679 .28647 m
.50251 .28851 L
s
.5371 .28414 m
.50251 .28851 L
s
.01 w
.60423 .29251 Mdot
.5 Mabswid
.60423 .29251 m
.57125 .286 L
s
.60423 .29251 m
.57164 .28276 L
s
.01 w
.57059 .27666 Mdot
.5 Mabswid
.57059 .27666 m
.54239 .2651 L
s
.57059 .27666 m
.60164 .27013 L
s
.57059 .27666 m
.57414 .2651 L
s
.57059 .27666 m
.57164 .28276 L
s
.57059 .27666 m
.57349 .25534 L
s
.5707 .25726 m
.57059 .27666 L
s
.5371 .28414 m
.57059 .27666 L
s
.01 w
.5707 .25726 Mdot
.5 Mabswid
.5707 .25726 m
.57349 .25534 L
s
.5707 .25726 m
.57287 .23584 L
s
.01 w
.48552 .28256 Mdot
.5 Mabswid
.51702 .26812 m
.48552 .28256 L
s
.01 w
.50311 .28973 Mdot
.5 Mabswid
.53679 .28647 m
.50311 .28973 L
s
.5371 .28414 m
.50311 .28973 L
s
.01 w
.5371 .28414 Mdot
.5 Mabswid
.5371 .28414 m
.57125 .286 L
s
.5371 .28414 m
.57164 .28276 L
s
.5371 .28414 m
.53679 .28647 L
s
.01 w
.62536 .27743 Mdot
.5 Mabswid
.62536 .27743 m
.60164 .27013 L
s
.60527 .25346 m
.62536 .27743 L
s
.01 w
.53679 .28647 Mdot
.5 Mabswid
.53679 .28647 m
.57125 .286 L
s
.53679 .28647 m
.57164 .28276 L
s
.01 w
.57125 .286 Mdot
.5 Mabswid
.57125 .286 m
.5742 .27297 L
s
.57164 .28276 m
.57125 .286 L
s
.01 w
.57164 .28276 Mdot
.5 Mabswid
.57164 .28276 m
.5742 .27297 L
s
.57164 .28276 m
.57414 .2651 L
s
.01 w
.56945 .20963 Mdot
.5 Mabswid
.56945 .20963 m
.57268 .20329 L
s
.56945 .20963 m
.57072 .22211 L
s
.56945 .20963 m
.57175 .1906 L
s
.56922 .1972 m
.56945 .20963 L
s
.01 w
.60164 .27013 Mdot
.5 Mabswid
.58939 .2451 m
.60164 .27013 L
s
.60527 .25346 m
.60164 .27013 L
s
.57349 .25534 m
.60164 .27013 L
s
.01 w
.57072 .22211 Mdot
.5 Mabswid
.57072 .22211 m
.57385 .21645 L
s
.57072 .22211 m
.57287 .23584 L
s
.57072 .22211 m
.57268 .20329 L
s
.01 w
.54239 .2651 Mdot
.5 Mabswid
.56035 .24282 m
.54239 .2651 L
s
.51702 .26812 m
.54239 .2651 L
s
.54268 .24834 m
.54239 .2651 L
s
.57349 .25534 m
.54239 .2651 L
s
.01 w
.51702 .26812 Mdot
.5 Mabswid
.54268 .24834 m
.51702 .26812 L
s
.01 w
.56922 .1972 Mdot
.5 Mabswid
.56922 .1972 m
.57175 .1906 L
s
.56922 .1972 m
.57147 .17952 L
s
.01 w
.57349 .25534 Mdot
.5 Mabswid
.57349 .25534 m
.56035 .24282 L
s
.57349 .25534 m
.58939 .2451 L
s
.57349 .25534 m
.57653 .24709 L
s
.57349 .25534 m
.57414 .2651 L
s
.57349 .25534 m
.57558 .23869 L
s
.57287 .23584 m
.57349 .25534 L
s
.01 w
.57287 .23584 Mdot
.5 Mabswid
.57287 .23584 m
.57618 .22479 L
s
.57287 .23584 m
.57558 .23869 L
s
.57287 .23584 m
.57385 .21645 L
s
.01 w
.5742 .27297 Mdot
.5 Mabswid
.5742 .27297 m
.57678 .25649 L
s
.57414 .2651 m
.5742 .27297 L
s
.01 w
.57414 .2651 Mdot
.5 Mabswid
.57414 .2651 m
.57678 .25649 L
s
.57414 .2651 m
.57653 .24709 L
s
.01 w
.60527 .25346 Mdot
.5 Mabswid
.60527 .25346 m
.58939 .2451 L
s
.59053 .22596 m
.60527 .25346 L
s
.01 w
.57268 .20329 Mdot
.5 Mabswid
.57268 .20329 m
.57548 .20257 L
s
.57268 .20329 m
.57385 .21645 L
s
.57268 .20329 m
.57444 .18696 L
s
.57175 .1906 m
.57268 .20329 L
s
.01 w
.58939 .2451 Mdot
.5 Mabswid
.59053 .22596 m
.58939 .2451 L
s
.57618 .22479 m
.58939 .2451 L
s
.57558 .23869 m
.58939 .2451 L
s
.01 w
.54268 .24834 Mdot
.5 Mabswid
.54268 .24834 m
.56035 .24282 L
s
.56247 .22387 m
.54268 .24834 L
s
.01 w
.57175 .1906 Mdot
.5 Mabswid
.57175 .1906 m
.57444 .18696 L
s
.57175 .1906 m
.57335 .176 L
s
.57147 .17952 m
.57175 .1906 L
s
.01 w
.57385 .21645 Mdot
.5 Mabswid
.57385 .21645 m
.57618 .22479 L
s
.57385 .21645 m
.57548 .20257 L
s
.01 w
.56035 .24282 Mdot
.5 Mabswid
.56247 .22387 m
.56035 .24282 L
s
.57618 .22479 m
.56035 .24282 L
s
.57558 .23869 m
.56035 .24282 L
s
.01 w
.57558 .23869 Mdot
.5 Mabswid
.57558 .23869 m
.57845 .22958 L
s
.57558 .23869 m
.57653 .24709 L
s
.57558 .23869 m
.57618 .22479 L
s
.01 w
.57678 .25649 Mdot
.5 Mabswid
.57678 .25649 m
.57913 .23905 L
s
.57653 .24709 m
.57678 .25649 L
s
.01 w
.57147 .17952 Mdot
.5 Mabswid
.57147 .17952 m
.57367 .16718 L
s
.57147 .17952 m
.57335 .176 L
s
.01 w
.57653 .24709 Mdot
.5 Mabswid
.57653 .24709 m
.57913 .23905 L
s
.57653 .24709 m
.57845 .22958 L
s
.01 w
.57618 .22479 Mdot
.5 Mabswid
.57618 .22479 m
.56247 .22387 L
s
.57618 .22479 m
.59053 .22596 L
s
.57618 .22479 m
.57974 .21313 L
s
.57618 .22479 m
.57845 .22958 L
s
.57618 .22479 m
.5778 .20623 L
s
.57548 .20257 m
.57618 .22479 L
s
.01 w
.57548 .20257 Mdot
.5 Mabswid
.57548 .20257 m
.5778 .20623 L
s
.57548 .20257 m
.57684 .1863 L
s
.57444 .18696 m
.57548 .20257 L
s
.01 w
.59053 .22596 Mdot
.5 Mabswid
.5862 .20041 m
.59053 .22596 L
s
.5778 .20623 m
.59053 .22596 L
s
.01 w
.57444 .18696 Mdot
.5 Mabswid
.57444 .18696 m
.57684 .1863 L
s
.57444 .18696 m
.57548 .17236 L
s
.57335 .176 m
.57444 .18696 L
s
.01 w
.57335 .176 Mdot
.5 Mabswid
.57335 .176 m
.57548 .17236 L
s
.57335 .176 m
.57367 .16718 L
s
.01 w
.56247 .22387 Mdot
.5 Mabswid
.5705 .19957 m
.56247 .22387 L
s
.5778 .20623 m
.56247 .22387 L
s
.01 w
.57845 .22958 Mdot
.5 Mabswid
.57845 .22958 m
.58104 .22168 L
s
.57845 .22958 m
.57913 .23905 L
s
.57845 .22958 m
.57974 .21313 L
s
.01 w
.57913 .23905 Mdot
.5 Mabswid
.57913 .23905 m
.58104 .22168 L
s
.01 w
.57367 .16718 Mdot
.5 Mabswid
.57367 .16718 m
.57599 .16135 L
s
.57367 .16718 m
.57548 .17236 L
s
.01 w
.5778 .20623 Mdot
.5 Mabswid
.5778 .20623 m
.5705 .19957 L
s
.5778 .20623 m
.5862 .20041 L
s
.5778 .20623 m
.58094 .19624 L
s
.5778 .20623 m
.57974 .21313 L
s
.5778 .20623 m
.57904 .18666 L
s
.57684 .1863 m
.5778 .20623 L
s
.01 w
.57548 .17236 Mdot
.5 Mabswid
.57548 .17236 m
.57785 .17084 L
s
.57548 .17236 m
.57684 .1863 L
s
.57548 .17236 m
.57599 .16135 L
s
.01 w
.57684 .1863 Mdot
.5 Mabswid
.57684 .1863 m
.57904 .18666 L
s
.57684 .1863 m
.57785 .17084 L
s
.01 w
.57974 .21313 Mdot
.5 Mabswid
.57974 .21313 m
.58241 .20479 L
s
.57974 .21313 m
.58104 .22168 L
s
.57974 .21313 m
.58094 .19624 L
s
.01 w
.58104 .22168 Mdot
.5 Mabswid
.58104 .22168 m
.58241 .20479 L
s
.01 w
.5862 .20041 Mdot
.5 Mabswid
.58513 .18013 m
.5862 .20041 L
s
.57904 .18666 m
.5862 .20041 L
s
.01 w
.5705 .19957 Mdot
.5 Mabswid
.57405 .18002 m
.5705 .19957 L
s
.57904 .18666 m
.5705 .19957 L
s
.01 w
.57599 .16135 Mdot
.5 Mabswid
.57599 .16135 m
.57868 .15942 L
s
.57599 .16135 m
.57785 .17084 L
s
.01 w
.57785 .17084 Mdot
.5 Mabswid
.57785 .17084 m
.57991 .1708 L
s
.57785 .17084 m
.57904 .18666 L
s
.57785 .17084 m
.57868 .15942 L
s
.01 w
.57904 .18666 Mdot
.5 Mabswid
.57904 .18666 m
.57405 .18002 L
s
.57904 .18666 m
.58513 .18013 L
s
.57904 .18666 m
.58171 .1813 L
s
.57904 .18666 m
.58094 .19624 L
s
.57904 .18666 m
.57991 .1708 L
s
.01 w
.58094 .19624 Mdot
.5 Mabswid
.58094 .19624 m
.58337 .18851 L
s
.58094 .19624 m
.58241 .20479 L
s
.58094 .19624 m
.58171 .1813 L
s
.01 w
.58241 .20479 Mdot
.5 Mabswid
.58241 .20479 m
.58337 .18851 L
s
.01 w
.58513 .18013 Mdot
.5 Mabswid
.5855 .16563 m
.58513 .18013 L
s
.57991 .1708 m
.58513 .18013 L
s
.01 w
.57405 .18002 Mdot
.5 Mabswid
.57512 .16589 m
.57405 .18002 L
s
.57991 .1708 m
.57405 .18002 L
s
.01 w
.57868 .15942 Mdot
.5 Mabswid
.57868 .15942 m
.58053 .1604 L
s
.57868 .15942 m
.57991 .1708 L
s
.01 w
.58171 .1813 Mdot
.5 Mabswid
.58171 .1813 m
.58337 .18851 L
s
.58171 .1813 m
.58282 .17277 L
s
.57991 .1708 m
.58171 .1813 L
s
.01 w
.57991 .1708 Mdot
.5 Mabswid
.57991 .1708 m
.57512 .16589 L
s
.57991 .1708 m
.5855 .16563 L
s
.57991 .1708 m
.58282 .17277 L
s
.57991 .1708 m
.58053 .1604 L
s
.01 w
.58337 .18851 Mdot
.5 Mabswid
.58282 .17277 m
.58337 .18851 L
s
.01 w
.5855 .16563 Mdot
.5 Mabswid
.58053 .1604 m
.5855 .16563 L
s
.01 w
.57512 .16589 Mdot
.5 Mabswid
.58053 .1604 m
.57512 .16589 L
s
.01 w
.58282 .17277 Mdot
.5 Mabswid
.58053 .1604 m
.58282 .17277 L
s
.01 w
.58053 .1604 Mdot
.25 Mabswid
.69423 0 m
.98425 .433 L
s
.98425 .433 m
1 .54835 L
s
1 .54835 m
.70153 .12619 L
s
.70153 .12619 m
.69423 0 L
s
.0191 .25742 m
0 .37802 L
s
0 .37802 m
.70153 .12619 L
s
.70153 .12619 m
.69423 0 L
s
.69423 0 m
.0191 .25742 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  ImageSize->{288, 205.063},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000cB000`400?l00000o`00003oaP3oool2
000005P0oooo00340?ooo`80000000<0oooo000000000000E`3oool00<40oooo0`0000030?ooo`80
0000E`3oool00;h0oooo0`0000060?ooo`030000003oool0000005H0oooo002l0?ooo`8000002@3o
ool010000000oooo0?ooo`00001E0?ooo`00^@3oool3000000/0oooo00@000000?ooo`3oool00000
E@3oool00;H0oooo0`00000>0?ooo`050000003oool0oooo0?ooo`000000E03oool00;@0oooo0P00
000A0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0D@3oool00;40oooo0`00000C
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0D@3oool00:l0oooo0P00000F0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0D03oool00:`0oooo0`00000I0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0C`3oool00:T0oooo0`00000L0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0C`3oool00:L0oooo0P00000O0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0CP3oool00:@0oooo0`00000Q0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0C@3oool00:40oooo0`00000T0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0C@3oool009l0oooo0P00000W0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0C03oool009`0oooo0`00000Y0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0B`3oool009X0oooo0P00000/0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0B`3oool009L0oooo0`00000^0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0BP3oool009@0oooo0`00000a0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0B@3oool00980oooo0P00000d0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0B@3oool008l0oooo0`00000f0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
B03oool008d0oooo0P00000i0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A`3o
ool008X0oooo0`00000k0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0A`3oool0
08L0oooo0`00000n0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0AP3oool008D0
oooo0P0000110?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0A@3oool00880oooo
0`0000130?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0A@3oool007l0oooo0`00
00160?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0A03oool007d0oooo0P00001:
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0@`3oool007X0oooo0`00001<0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0@`3oool007P0oooo0P00001?0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0@P3oool007D0oooo0`00001A0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0@@3oool00780oooo0`00001D0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0@@3oool00700oooo0P00001G0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0@03oool006d0oooo0`00001I0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0?`3oool006X0oooo0`00001L0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool0?`3oool006P0oooo0P00001O0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool0?P3oool006D0oooo0`00001P0?ooo`8000005P3oool00`000000oooo0?oo
o`0m0?ooo`00H`3oool200000600oooo0`0000020?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0?@3oool00600oooo0`00001P0?ooo`8000001@3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo03`0oooo001M0?ooo`<00000H03oool3000000P0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`0k0?ooo`00F`3oool200000600oooo0`00000<0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0>`3oool005P0oooo0`00001O0?ooo`<00000403o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03X0oooo001E0?ooo`<00000G`3oool3
000001<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0i0?ooo`00D`3oool20000
0600oooo0P00000G0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0>@3oool00500
oooo0`00001O0?ooo`<000006P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03P0
oooo001>0?ooo`800000E@3oool2000000P0oooo0`00000M0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool0=`3oool004/0oooo0`00001F0?ooo`<000001@3oool300000240oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0g0?ooo`00B03oool3000005P0oooo2@00000U
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0=P3oool004H0oooo0P00001L0?oo
o`D00000:03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03D0oooo00130?ooo`<0
0000GP3oool4000002X0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0e0?ooo`00
@03oool3000005h0oooo1`00000[0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
=03oool003h0oooo0P00001N0?ooo`<000000P3oool6000002/0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0c0?ooo`00>`3oool3000005d0oooo0`0000050?ooo`H00000:`3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03<0oooo000i0?ooo`800000GP3oool20000
00P0oooo1@00000]0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0<P3oool003H0
oooo0`00001M0?ooo`<000002P3oool5000002h0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0a0?ooo`00<`3oool3000005d0oooo0`00000=0?ooo`H00000;@3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo0340oooo000a0?ooo`800000G@3oool3000000l0oooo1`00
000^0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0<03oool002h0oooo0`00001L
0?ooo`<000004`3oool6000002l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0_
0?ooo`00;03oool2000005d0oooo0P00000F0?ooo`H00000;`3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo02l0oooo000Y0?ooo`<00000G03oool3000001L0oooo1`00000`0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0;P3oool002H0oooo0`00001L0?ooo`<00000
6P3oool700000340oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0]0?ooo`00903o
ool2000005`0oooo0`00000M0?ooo`H0000000<0oooo0000003oool0<03oool00`000000oooo0?oo
o`0B0?ooo`030000003oool0oooo02d0oooo000Q0?ooo`<00000G03oool2000001l0oooo1`000000
0`3oool000000?ooo`0`0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0;03oool0
01h0oooo0`00001L0?ooo`<00000803oool7000000030?ooo`00000000000380oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0/0?ooo`00703oool2000005`0oooo0`00000T0?ooo`T0
0000<`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02/0oooo000I0?ooo`<00000
F`3oool3000002H0oooo1`0000020?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0Z0?ooo`005`3oool2000005/0oooo0`00000X0?ooo`030000003o
ool0000000D000000P3oool2000003<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0Z0?ooo`00503oool3000005/0oooo0P00000Z0?ooo`030000003oool0000000L0000000<0oooo
000000000000=03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02T0oooo000A0?oo
o`<00000F`3oool3000002`0oooo00<000000?ooo`0000001P0000001@3oool000000000003oool0
000003<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0X0?ooo`003`3oool20000
05/0oooo0`00000^0?ooo`030000003oool0000000X0000000<0oooo0000003oool0<`3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo02P0oooo000<0?ooo`<00000FP3oool3000002h0
oooo3@0000000`3oool00000000000020?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0W0?ooo`002@3oool3000005X0oooo0`00000b0?ooo`800000
00<0oooo0000003oool01P0000000`3oool0000000000004000003D0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0V0?ooo`001`3oool2000005/0oooo0P00000c0?ooo`<000000P3o
ool00`000000oooo00000006000000<0oooo00@000000?ooo`0000000000=03oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo02H0oooo00050?ooo`800000FP3oool3000003@0oooo00L0
00000?ooo`3oool000000?ooo`000000oooo00L00000103oool00`000000oooo0?ooo`02000003@0
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0U0?ooo`001@3oool2000005L0oooo
0`00000f0?ooo`040000003oool0oooo0?ooo`80000000<0oooo0000000000001`0000040?ooo`05
0000003oool000000?ooo`000000=03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
02@0oooo00050?ooo`030000003oool0000005<0oooo0`00000g0?ooo`80000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`00000000000080oooo0P0000030?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0T0?ooo`00
1@3oool010000000oooo0?ooo`00001?0?ooo`<00000>03oool5000000030?ooo`000000000000<0
000000<0oooo000000000000100000040?ooo`80000000<0oooo0000003oool00P3oool00`000000
oooo0?ooo`0b0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool08`3oool000@0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1:0?ooo`800000>@3oool400000080oooo
0P0000000`3oool000000?ooo`020?ooo`L000001@3oool4000000<0oooo00<000000?ooo`3oool0
<P3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0280oooo00040?ooo`030000003o
ool0oooo00<0oooo0P0000170?ooo`<00000>@3oool200000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`3oool8000000030?ooo`0000000000008000000P3oool7000003@0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0R0?ooo`00103oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0440oooo0`00000j0?ooo`8000000`3oool010000000oooo
0000000000030?ooo`030000003oool0oooo0080oooo200000070?ooo`8000000`3oool2000003<0
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0Q0?ooo`00103oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo03d0oooo0`00000j0?ooo`@000000P3oool4000000030?oo
o`000000000001800000103oool00`000000oooo000000030?ooo`800000<`3oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo0200oooo00040?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0>@3oool3000003/0oooo100000020?oooal0000000<0oooo0000003oool00P00
0000103oool000000?ooo`00000c0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
803oool000@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0f0?ooo`800000?03o
ool3000000030?ooo`000000000002@000000P3oool010000000oooo0000003oool200000340oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0O0?ooo`00103oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo0380oooo0`00000l0?oooc4000000`3oool00`000000oooo0?oo
o`0_0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool07P3oool000<0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0^0?ooo`<00000?03ooolH00000080oooo70000002
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0N
0?ooo`000`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02X0oooo0`00000k0?oo
o`d0000000<0oooo0000003oool01@3oool00`000000oooo0?ooo`0W000002l0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0M0?ooo`000`3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo02L0oooo0P00000k0?ooo`X000004`3ooolS000000030?ooo`000000000002l0
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0L0?ooo`000`3oool00`000000oooo
0?ooo`0>0?ooo`800000903oool3000003X0oooo2`00000F0?ooo`d0000000<0oooo0000003oool0
1P3oool@000002l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0L0?ooo`000`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01h0oooo0`00000k0?ooo`P00000703o
ool6000000040?ooo`000000000000000140oooo3000000^0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool06`3oool000<0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0J0?ooo`<00000?03oool7000001l0oooo1@0000000`3oool0000000000002000001@0oooo2`00
000/0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06P3oool000<0oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`0F0?ooo`<00000?@3oool9000001h0oooo2@00000H
0?ooo`X00000;03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01X0oooo00020?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool04`3oool2000003d0oooo1P00000T0?oo
o`T00000703oool8000002/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0I0?oo
o`000P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00l0oooo0`00000m0?ooo`H0
00009P3oool9000001h0oooo1`00000Z0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool0603oool00080oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0;0?ooo`<00000
?P3oool7000002D0oooo2@0000000`3oool000000?ooo`0N0?ooo`P00000:@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo01P0oooo00020?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool01`3oool3000003l0oooo1@00000X0?ooo`P0000000@0oooo0000000000000000
8P3oool8000002L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`000P3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00<0oooo0`00000o0?ooo`H00000:03o
ool2000000030?ooo`000000000000T00000903oool6000002L0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0F0?ooo`000P3oool00`000000oooo0?ooo`0I0?ooo`80000000<0oooo
000000000000@@3oool6000002P0oooo3P0000000`3oool000000?ooo`0T0?ooo`H000009P3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00020?ooo`030000003oool0oooo
01T0oooo0`0000110?ooo`H000009P3ooolE000002D0oooo1P00000V0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool05@3oool000030?ooo`000000oooo01P0oooo0`0000030?ooo`03
0000003oool0oooo03`0oooo1@00000Y0?oooaD000009`3oool5000002H0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0D0?ooo`0000<0oooo0000003oool05@3oool3000000L0oooo
00<000000?ooo`3oool0>@3oool7000002L0oooo300000000`3oool0000000000009000002P0oooo
1@00000T0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0503oool000030?ooo`00
0000oooo0180oooo0`00000;0?ooo`030000003oool0oooo03H0oooo1`00000Q0?oooa00000000<0
oooo0000000000003P00000X0?ooo`D00000903oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo01<0oooo00000`3oool000000?ooo`0@0?ooo`8000003`3oool00`000000oooo0?ooo`0d
0?ooo`H000005P3oool2000000<0oooo200000020?ooob000000:03oool5000002@0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`0000<0oooo0000003oool03@3oool30000
0180oooo00<000000?ooo`3oool0<@3oool7000001@0oooo:`0000000`3oool00000000000060000
02L0oooo1@00000S0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00003
0?ooo`000000oooo00X0oooo0`00000F0?ooo`030000003oool0oooo02h0oooo2000000?0?ooo`d0
0000103ooolZ000002P0oooo1@00000R0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool04@3oool000030?ooo`000000oooo00L0oooo0`00000J0?ooo`030000003oool0oooo02/0oooo
2000000<0?ooo`/000000P3oool010000000oooo0?ooo`3ooolc000002D0oooo1@00000R0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0403oool000030000003oool0oooo00@0oooo
0`00000N0?ooo`800000:P3oool8000000P0ooooCP00000Q0?ooo`H00000803oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0100oooo00000`000000oooo0?ooo`020?ooo`8000008`3o
ool00`000000oooo0?ooo`0V0?ooo`T000000P3oool=00000080oooo00<000000?ooo`3oool04000
00000`3oool000000000000/000000030?ooo`000000oooo008000008@3oool500000200oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`0000<000000?ooo`0000000P00000V
0?ooo`030000003oool0oooo02<0oooo?00000000`3oool000000000000W000001l0oooo1000000Q
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03P3oool000800000:P3oool00`00
0000oooo0?ooo`0P0?ooo`h0000000<0oooo0000000000000P0000000`3oool000000000000Q0000
00<0oooo2@0000000`3oool000000000000U000001d0oooo1000000Q0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool03P3oool000030?ooo`000000oooo02X0oooo00<000000?ooo`3o
ool07P3oool^000000D0oooo00@000000?ooo`3oool0oooo=`00000K0?ooo`D00000803oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00d0oooo00020?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool05`3oool^000000030?ooo`000000oooo00l0oooo=`00000I0?ooo`D0
0000803oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo00030?ooo`800000
:@3oool2000000<0oooo5@0000000`3oool000000000000X000001P0oooo1`0000000`3oool00000
0000000A00000080oooo6P00000G0?ooo`H000007`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo00`0oooo00050?ooo`030000003oool0oooo01l0oooo0P0000000`3oool000000000
000C00000080oooo100000000`3oool000000000000N000000030?ooo`000000oooo00L00000703o
ool=000000030?ooo`000000oooo02P000005@3oool6000001l0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0;0?ooo`001P3oool00`000000oooo0?ooo`0L0?ooo`L000000P3oool2
000000030?ooo`00000000000080oooo100000000`3oool000000?ooo`030?ooo``0000000<0oooo
0000000000003P0000000`3oool0000000000004000000<0oooo1`0000000`3oool000000?ooo`0M
0?oooaH000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000D0000000<0oooo
0000000000003@00000D0?ooo`H000007`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00X0oooo00070?ooo`030000003oool0oooo01L0oooo5P0000040?ooo`030000003oool0oooo
00@0000000<0oooo0000003oool00`0000000`3oool000000000000@000000030?ooo`0000000000
00X0000000<0oooo0000000000008P3ooolC000000030?ooo`000000oooo0100oooo400000000`3o
ool0000000000002000000030?ooo`000000000000l0oooo1`00000O0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool02P3oool000P0oooo00<000000?ooo`3oool0503oool200000005
0?ooo`00000000000000003oool00P0000020?ooo`@000000`3oool400000080oooo1`0000040?oo
oa/0000000<0oooo0000000000000`3oool6000002D0oooo00<000000?ooo`3oool03@00000H0?oo
o`H0000000<0oooo0000000000003000000@0?ooo`L000007P3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo00T0oooo00090?ooo`8000004P3oool800000080oooo0`0000030?ooo`04
0000003oool00000000000<0oooo1P000000103oool000000?ooo`3oool8000000030?ooo`000000
000000<0000000<0oooo0000000000000`0000000`3oool0000000000004000000@0oooo00@00000
0?ooo`000000oooo0`0000000`3oool000000000000X0?ooo`030000003oool0000000T0000000<0
oooo0000000000006@3ooolG000000`0oooo2@00000N0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0203oool000/0oooo00<000000?ooo`3oool03@3oool2000000050?ooo`000000
00000000003oool00P0000000`3oool000000000000@000000@0oooo1@0000000`3oool000000000
0004000000030?ooo`000000000000h00000103oool00`000000oooo00000002000000030?ooo`00
0000000000<00000:03oool00`000000oooo00000004000000060?ooo`00000000000000003oool0
00007P3oool3000000030?ooo`000000oooo010000002`3oool9000001h0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`080?ooo`00303oool00`000000oooo0?ooo`0:0?ooo`/00000
00<0oooo0000000000000P3oool010000000oooo0?ooo`3oool3000000<0oooo0P0000000`3oool0
000000000006000000<0oooo00<000000?ooo`000000400000020?ooo`8000000`3oool00`000000
oooo00000005000000030?ooo`000000oooo02T0oooo1`0000001P3oool00000000000000000oooo
00000200oooo5`0000080?ooo`H0000000@0oooo00000000000000007P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo00L0oooo000=0?ooo`030000003oool0oooo00X0oooo1P000000
0`3oool000000000000c00000080oooo00<000000?ooo`0000001P0000020?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`0000000P000000103oool000000000003oool2000002<0oooo6@00
00020?ooo`@0000000<0oooo0000000000001@00000N0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool01P3oool000h0oooo00<000000?ooo`3oool02P3oool<000000030?ooo`000000
000001<0000000<0oooo000000000000400000020?ooo`80000000<0oooo00000000000020000002
0?ooo`800000;03oool2000000030?ooo`000000000000H000009P3oool3000000030?ooo`000000
0000020000007P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00H0oooo000?0?oo
o`8000003@3oool@000000<0oooo100000020?ooo`D0000000<0oooo0000000000000P000000103o
ool000000?ooo`3oool7000000030?ooo`000000000000<0000000<0oooo0000000000000P3oool4
00000080oooo0P0000000`3oool000000?ooo`0^0?ooo`T00000:03oool4000000030?ooo`000000
oooo01h000007`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00D0oooo000A0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P0000000`3oool00000000000060000
00030?ooo`000000000000T000001@3oool00`000000oooo00000003000000040?ooo`0000000000
0?ooo`80000000<0oooo0000000000001`0000030?ooo`040000003oool0000000000300oooo00<0
00000?ooo`0000000P000000103oool000000?ooo`00000Z0?ooo`H000000P3ooolM000001d0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`040?ooo`004P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo00`000000P3oool00`000000oooo00000002000000030?ooo`00
0000000000@0000000<0oooo0000003oool00P0000030?ooo`040000003oool000000?ooo`800000
0P3oool300000080oooo0P0000000`3oool000000000000300000340oooo2@00000[0?ooo`800000
00<0oooo0000000000000`0000000`3oool0000000000006000000030?ooo`000000000000L00000
00<0oooo0000000000001P00000N0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
103oool001<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0<000000<0oooo0P00
00020?ooo`D00000103oool00`000000oooo00000005000000040?ooo`00000000000?ooo`800000
00@0oooo0000003oool0oooo0P00000b0?ooo`P00000;@3oool2000000050?ooo`00000000000000
003oool03@0000000`3oool000000000000;000000030?ooo`000000oooo01d0oooo00<000000?oo
o`3oool03`3oool2000000D0oooo000D0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3o
ool03@0000020?ooo`@000000`3oool2000000040?ooo`000000000000000080oooo0P0000000`3o
ool000000000000600000380oooo2@00000^0?ooo`80000000@0oooo0000003oool000000`3oool4
000000030?ooo`000000000000D0000000<0oooo0000000000002`00000O0?ooo`030000003oool0
oooo00X0oooo100000000`3oool000000?ooo`040?ooo`005@3oool2000001l0oooo0`0000020?oo
o`/0000000@0oooo000000000000oooo0`0000000`3oool00000000000020?ooo`80000000<0oooo
0000000000000P0000030?ooo`030000003oool0oooo0300oooo2@00000_0?ooo`80000000<0oooo
0000003oool00P0000001@3oool000000?ooo`000000oooo00<0000000<0oooo0000000000004P00
000M0?ooo`030000003oool0oooo00L0oooo0`0000050?ooo`030000003oool0oooo00<0oooo000G
0?ooo`030000003oool0oooo01h0oooo200000000`3oool000000?ooo`03000000<0oooo0P000003
0?ooo`050000003oool000000000003oool01@0000030?ooo`030000003oool0oooo0340oooo2@00
000`0?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool000000?ooo`020?ooo`X00000
00<0oooo0000000000003P00000I0?ooo`030000003oool0oooo0080oooo100000080?ooo`030000
003oool0oooo00<0oooo000H0?ooo`030000003oool0oooo01h0oooo0`0000000`3oool000000000
0004000000030?ooo`00000000000080oooo100000000`3oool00000000000020?ooo`@0000000<0
oooo0000000000000P3oool00`000000oooo0?ooo`0a0?ooo`<0000000<0oooo0000000000000`00
000b0?ooo`@0000000<0oooo0000000000000P3oool010000000oooo0?ooo`3oool4000000030?oo
o`000000000001P000005@3oool4000000`0oooo00<000000?ooo`3oool00`3oool001T0oooo00<0
00000?ooo`3oool0803oool010000000oooo0?ooo`3oool8000000030?ooo`000000oooo00<00000
00@0oooo000000000000oooo0P0000020?ooo`80000000<0oooo0000003oool0=03oool8000003<0
oooo00@000000?ooo`00000000000P3oool00`000000oooo000000030?ooo`<0000000<0oooo0000
00000000600000000`3oool0000000000002000000h0oooo1000000@0?ooo`030000003oool0oooo
0080oooo000J0?ooo`030000003oool0oooo0200oooo0P0000001@3oool000000?ooo`000000oooo
00<000000P3oool010000000oooo0000003oool5000000040?ooo`00000000000?ooo`80000000<0
oooo0000003oool0=03oool8000003<0oooo00<000000?ooo`3oool00P0000020?ooo`<000000P3o
ool2000000050?ooo`00000000000000003oool01@000000103oool000000000003oool900000080
oooo300000070?ooo`<00000103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080
oooo000K0?ooo`8000008P3oool3000000030?ooo`000000000000@000000P3oool00`000000oooo
0000000200000080oooo0P0000000`3oool0000000000002000003D0oooo2@00000d0?ooo`030000
003oool0000000H0000000<0oooo0000003oool0200000000`3oool0000000000004000000030?oo
o`000000000000<0000000<0oooo0000000000000P0000020?ooo`<0000000<0oooo000000000000
2`0000080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool001d0oooo00<0
00000?ooo`3oool0803oool300000080oooo1P0000000`3oool0000000000005000000030?ooo`00
0000000000800000=P3oool5000000040?ooo`0000000000000003D0oooo0`0000040?ooo`D00000
0P3oool3000000030?ooo`000000oooo0080000000D0oooo00000000000000000?ooo`0A00000080
oooo2P0000080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool001h0oooo
00<000000?ooo`3oool0803oool8000000040?ooo`000000000000000080oooo0P0000000`3oool0
000000000004000003H0oooo2000000f0?ooo`80000000<0oooo0000003oool00`3oool200000080
oooo00D000000?ooo`00000000000?ooo`03000000030?ooo`000000000000L000000P3oool30000
0080oooo100000000`3oool0000000000005000000040?ooo`00000000000?ooo`H000001P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo000O0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0100000020?ooo`D0000000@0oooo00000000000000000P3oool0
0`000000oooo0?ooo`0d0?ooo`@0000000@0oooo0000000000000000=P3oool200000080oooo00<0
00000?ooo`3oool00P0000000`3oool000000?ooo`02000000040?ooo`000000oooo0?oooa<00000
00<0oooo000000000000200000000`3oool0000000000004000000040?ooo`00000000000?ooo`80
00001@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo000P0?ooo`030000
003oool0oooo0240oooo00<000000?ooo`000000100000000`3oool0000000000007000000030?oo
o`000000000003D0oooo1@000000103oool000000?ooo`00000g0?ooo`<0000000<0oooo0000003o
ool00P0000020?ooo`T0000000<0oooo000000000000100000000`3oool000000000000200000003
0?ooo`000000000000`0000000@0oooo000000000000oooo0`0000000`3oool00000000000060000
00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`008@3oool200000280
oooo2P0000000`3oool00000000000020?ooo`<00000=@3oool:000003P0oooo00<000000?ooo`00
00000P0000000`3oool000000000000400000080oooo00<000000?ooo`0000000`0000001@3oool0
0000000000000000oooo00l0000000<0oooo0000000000000P3oool6000000040?ooo`0000000000
0?ooo`<000000P3oool2000000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`02
0?ooo`008`3oool00`000000oooo0?ooo`0O0?ooo`D0000000<0oooo0000000000001P000000103o
ool0000000000000000e0?ooo`P0000000<0oooo0000003oool0=`3oool00`000000oooo0?ooo`05
000000030?ooo`00000000000080000000<0oooo0000000000000P0000020?ooo`040000003oool0
oooo0?ooo`X000000P3oool9000000030?ooo`00000000000080000000<0oooo0000000000001000
00001@3oool00000000000000000oooo008000000P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0040oooo000T0?ooo`030000003oool0oooo01l0oooo1P0000000`3oool000000000
00020?ooo`<0000000<0oooo000000000000=@3oool:000003P0oooo00@000000?ooo`3oool0oooo
0P0000000`3oool000000?ooo`0200000080oooo0`0000020?ooo`030000003oool0000000@0oooo
1@0000020?ooo`80000000L0oooo00000000000000000?ooo`000000oooo00X0000000<0oooo0000
000000000P0000000`3oool000000000000600000080oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`010?ooo`009@3oool00`000000oooo0?ooo`0P0?ooo`D0000000<0oooo00000000
00001`00000d0?ooo`L0000000@0oooo0000000000000000>@3oool01@000000oooo000000000000
oooo00X000000P3oool200000080oooo900000000`3oool000000?ooo`02000000050?ooo`000000
00000?ooo`0000002P3oool00`000000oooo0?ooo`010?ooo`009P3oool00`000000oooo0?ooo`0O
0?ooo`P0000000<0oooo0000000000001000000d0?ooo`/00000>@3oool010000000oooo00000000
00020?ooo`8000000P3oool01@000000oooo000000000000oooo00L0000000<0oooo000000000000
0P0000020?ooo`l0000000<0oooo0000000000000P0000000`3oool000000000000@000000T0oooo
00<000000?ooo`3oool00@3oool002L0oooo0P00000P0?ooo`H0000000<0oooo0000000000000P00
00000`3oool000000000000c0?ooo`030000003oool0000000L0000000<0oooo000000000000>03o
ool00`000000oooo0000000500000080oooo0P0000000`3oool000000?ooo`04000000@0oooo;000
00000`3oool000000?ooo`070?ooo`030000003oool0oooo0040oooo000Y0?ooo`030000003oool0
oooo01h0oooo100000000`3oool000000000000700000380oooo00<000000?ooo`00000010000000
103oool000000?ooo`3oool2000003T0oooo0`000000103oool000000000003oool;000000<0oooo
6P0000020?ooo`l000000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0040oooo
000Z0?ooo`030000003oool0oooo01d0oooo200000000`3oool000000000000300000300oooo2000
0000103oool000000000000000020?ooo`030000003oool0oooo03H0oooo0P0000001P3oool00000
0000003oool000000?ooo`@0000000T0oooo0000003oool000000?ooo`000000oooo0000003oool0
2@0000001P3oool000000?ooo`3oool000000?oooaX000000P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00@3oool002/0oooo00<000000?ooo`3o
ool07@3oool5000000030?ooo`000000000000H00000;`3oool2000000040?ooo`00000000000?oo
o`80000000@0oooo000000000000oooo0`00000i0?ooo`/0000000L0oooo0000003oool000000?oo
o`000000oooo00T000000P3oool6000000L0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0040oooo000/0?ooo`030000003oool0oooo01d0oooo1@00
00000`3oool000000?ooo`05000002h0oooo0P000000103oool000000000003oool3000000040?oo
o`000000000000000080oooo00<000000?ooo`3oool0=P3oool600000080oooo0P0000020?ooo``0
00000P3oool00`000000oooo0?ooo`03000000030?ooo`000000oooo02@0oooo00<000000?ooo`3o
ool0103oool100000040oooo0@3oool002d0oooo0P00000M0?ooo`h00000;03oool01@000000oooo
000000000000oooo00H0000000<0oooo0000000000000P3oool2000003@0oooo100000000`3oool0
000000000002000000050?ooo`000000oooo0000003oool0100000020?ooo`D000000`3oool40000
02X0oooo00<000000?ooo`3oool0103oool100000040oooo0@3oool002l0oooo00<000000?ooo`3o
ool06`3oool=000002`0oooo0P0000001@3oool000000?ooo`000000oooo0080000000<0oooo0000
003oool00P0000020?ooo`800000<@3oool300000080oooo100000000`3oool00000000000050000
00040?ooo`00000000000?ooo`/00000;P3oool00`000000oooo0?ooo`030?ooo`4000000@3oool1
0?ooo`00<03oool00`000000oooo0?ooo`0K0?ooo`L000000P3oool4000002X0oooo00H000000?oo
o`00000000000?ooo`0000020?ooo`<000000P3oool01P000000oooo000000000000oooo000002d0
oooo100000050?ooo`@0000000@0oooo00000000000000000P3oool;000000050?ooo`0000000000
0?ooo`000000<03oool00`000000oooo0?ooo`020?ooo`4000000@3oool10?ooo`00<@3oool00`00
0000oooo0?ooo`0K0?ooo`D0000000<0oooo0000000000001@00000X0?ooo`030000003oool00000
00T000000P3oool010000000oooo0000000000020?ooo`030000003oool0oooo02L0oooo0`000008
0?ooo`l0000000<0oooo0000000000000P0000000`3oool000000000000d0?ooo`030000003oool0
oooo0080oooo0@0000010?ooo`40oooo000b0?ooo`030000003oool0oooo01/0oooo3@00000V0?oo
o`D000000P3oool00`000000oooo00000007000000050?ooo`000000oooo0?ooo`0000009@3oool4
000000X0oooo10000000103oool000000000000000020?ooo`<0000000<0oooo0000003oool01P00
000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool003<0oooo0P00000L0?ooo`d000008`3o
ool3000000030?ooo`00000000000080oooo00<000000?ooo`3oool0100000020?ooo`040000003o
ool0000000000080oooo00<000000?ooo`3oool0803oool3000000d0oooo3P0000000`3oool00000
00000005000003T0oooo00@000000?ooo`3oool000000P3oool003D0oooo00<000000?ooo`3oool0
6P3oool=00000240oooo0`000000103oool000000?ooo`0000020?ooo`030000003oool0oooo0080
000000D0oooo0000003oool0oooo000000020?ooo`<0000000<0oooo0000003oool0703oool40000
0100oooo0`0000000`3oool0000000000002000000030?ooo`000000oooo00X00000>P3oool01000
0000oooo0?ooo`0000020?ooo`00=P3oool00`000000oooo0?ooo`0J0?ooo`d000007`3oool01@00
0000oooo0000003oool000000080oooo00@000000?ooo`000000oooo100000020?ooo`080000003o
ool000000?ooo`000000oooo0000003oool3000001T0oooo0`00000C0?ooo`L0000000<0oooo0000
000000002@00000n0?ooo`040000003oool0oooo00000040oooo000g0?ooo`030000003oool0oooo
01X0oooo200000000`3oool0000000000003000001/0oooo0P0000020?ooo`800000103oool30000
00040?ooo`000000000000000080oooo00L000000?ooo`000000oooo0000003oool000000080oooo
0P00000E0?ooo`@00000503oool7000000070?ooo`00000000000000003oool000000?ooo`050000
0440oooo00<000000?ooo`0000000@3oool003P0oooo00<000000?ooo`3oool06@3oool@000001P0
oooo00@000000?ooo`3oool0oooo0P0000040?ooo`<000000P3oool2000000@0oooo0`0000030?oo
o`050000003oool000000?ooo`0000004@3oool3000001L0oooo300000000`3oool0000000000005
00000480oooo0P0000010?ooo`00>@3oool2000001X0oooo2P000000103oool000000000003oool3
000001@0oooo0P0000000`3oool000000000000@00000080oooo0`0000030?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool02P3oool4000001T0oooo1P0000001@3oool0000000000000
0000oooo00P00000A03oool200000040oooo000k0?ooo`030000003oool0oooo01T0oooo4P00000>
0?ooo`P0000000<0oooo0000000000000P3oool2000000040?ooo`00000000000?ooo`@0000000<0
oooo0000000000000`0000040?ooo`8000000P3oool00`000000oooo0?ooo`070?ooo`<000006`3o
ool7000000030?ooo`000000000000T00000AP3oool200000040oooo000l0?ooo`030000003oool0
oooo01X0oooo5@0000020?ooo`80000000<0oooo0000000000000`0000000`3oool0000000000002
000000<0oooo00@000000?ooo`00000000000P3oool00`000000oooo00000004000000030?ooo`00
0000oooo00X000000`3oool00`000000oooo0?ooo`020?ooo`@00000703oool7000000050?ooo`00
000000000000003oool01`0000140?ooo`@000000`3oool003d0oooo00<000000?ooo`3oool06@3o
oolL000000<0oooo0`000000103oool000000000003oool300000080oooo00@000000?ooo`000000
00000P3oool300000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`<000000`3oool4
000001h0oooo0P0000000`3oool000000000000>000000030?ooo`000000oooo03l0oooo10000007
0?ooo`00?P3oool00`000000oooo0?ooo`0I0?ooobl0000000<0oooo0000000000000`000000103o
ool000000?ooo`0000020?ooo`<0000000<0oooo0000000000001@00000N0?ooo`X0000000<0oooo
0000000000001`00000o0?ooo`@000002`3oool003l0oooo0P00000L0?oooa8000000P3oool50000
00050?ooo`00000000000000003oool00`000000103oool000000000003oool2000000030?ooo`00
000000000080oooo1P0000020?ooo`80000000@0oooo000000000000oooo1P0000020?ooo`<00000
6P3ooolC000003l0oooo0`00000?0?ooo`00@@3oool00`000000oooo0?ooo`0K0?oooa@0000000@0
oooo000000000000oooo1@0000020?ooo`030000003oool00000008000000P3oool00`000000oooo
00000006000000030?ooo`000000000000T0000000<0oooo0000000000000P0000000`3oool00000
0?ooo`0400000180oooo3P0000000`3oool0000000000004000000030?ooo`000000oooo03X0oooo
1000000B0?ooo`00@P3oool00`000000oooo0?ooo`0K0?ooo`h0000000<0oooo0000000000002@00
00020?ooo`040000003oool00000000000<0oooo0P0000000`3oool0000000000005000000030?oo
o`000000000000D0000000<0oooo0000000000001@000000103oool000000000000000030?ooo`P0
00000P3oool2000000<0oooo300000000`3oool0000000000009000003/0oooo1000000F0?ooo`00
@`3oool00`000000oooo0?ooo`0M0?oooa4000000P3oool3000000030?ooo`000000000001000000
00<0oooo0000000000000P000000103oool000000?ooo`3oool3000000050?ooo`00000000000000
003oool05P0000000`3oool000000000000C000003T0oooo1000000J0?ooo`00A03oool00`000000
oooo0?ooo`0N0?ooo`P0000000<0oooo0000000000001P0000000`3oool000000000000200000080
oooo1P0000001@3oool00000000000000000oooo00L000000P3oool2000000040?ooo`0000000000
0?ooo`<0000000<0oooo0000000000000P0000000`3oool0000000000002000000060?ooo`000000
00000?ooo`000000oooo10000000103oool000000?ooo`3ooolD000000030?ooo`000000oooo03H0
oooo0`00000N0?ooo`00A@3oool2000001l0oooo4`0000001@3oool00000000000000000oooo00<0
00000`3oool00`000000oooo0?ooo`07000000030?ooo`000000000000`0000000<0oooo00000000
00000P0000000`3oool0000000000004000000030?ooo`000000000001P00000=`3oool400000240
oooo00170?ooo`030000003oool0oooo01l0oooo2`000000103oool000000000003oool800000003
0?ooo`000000000000@0000000D0oooo00000000000000000?ooo`0400000080oooo0`0000020?oo
oaD0000000<0oooo0000000000000P0000000`3oool000000000000>000003D0oooo1000000U0?oo
o`00B03oool00`000000oooo0?ooo`0P0?ooo`d00000103oool200000080oooo300000030?ooo`04
0000003oool0oooo00000080oooo0P0000020?ooo`040000003oool0oooo0?ooo`<0000000<0oooo
0000003oool010000000103oool000000?ooo`3ooolD000000030?ooo`000000oooo0340oooo1000
000Y0?ooo`00B@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0000000/000000P3oool:
000000030?ooo`00000000000080000000<0oooo0000000000001`0000020?ooo`80000000<0oooo
0000003oool07`00000e0?ooo`<00000;@3oool004X0oooo00<000000?ooo`3oool0903oool;0000
00030?ooo`000000000000<0oooo00@000000?ooo`3oool0oooo1@0000050?oooa00000000<0oooo
0000003oool01@0000000`3oool000000?ooo`0=000000030?ooo`000000oooo0340oooo1000000`
0?ooo`00B`3oool2000002D0oooo0P0000000`3oool0000000000007000000040?ooo`0000000000
000000D0oooo100000030?ooo`<0000000<0oooo0000003oool00P0000001P3oool000000000003o
ool000000?ooo`@0000000<0oooo0000003oool04000000e0?ooo`@00000=03oool004d0oooo00<0
00000?ooo`3oool08`3oool2000000030?ooo`000000000000d000000P3oool4000000030?ooo`00
0000000000D0oooo00<000000?ooo`0000000P0000001@3oool00000000000000000oooo01<00000
0P3oool00`000000oooo0?ooo`0`0?ooo`<00000>03oool004h0oooo00<000000?ooo`3oool08P3o
ool00`000000oooo0?ooo`030?ooo`80000000<0oooo000000000000;P00000e0?ooo`@00000>`3o
ool004l0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`050?ooo`@0000000<0oooo
0000000000003P0000020?oooaD000000`3oool00`000000oooo0?ooo`0`0?ooo`@00000?`3oool0
0500oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`060?ooo`80000000<0oooo0000
000000002@0000030?oooa8000000`3oool00`000000oooo0?ooo`0d0?ooo`@00000@`3oool00540
oooo0P00000P0?ooo`030000003oool0oooo00P0oooo0P0000020?ooo`030000003oool0000001<0
00000P3oool00`000000oooo0?ooo`0i0?ooo`<00000A`3oool005<0oooo00<000000?ooo`3oool0
7@3oool00`000000oooo0?ooo`0:0?ooo`80000000<0oooo0000003oool01`0000020?ooo`<00000
00H0oooo00000000000000000?ooo`00000k0?ooo`@00000BP3oool005@0oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0:0?ooo`@0000000<0oooo000000000000100000001P3oool0
00000000003oool000000?ooo`800000>`3oool4000004h0oooo001E0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0000000=000003T0oooo1000001B0?oo
o`00EP3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`00
00001@0000000`3oool000000?ooo`03000003L0oooo0`00001F0?ooo`00E`3oool2000001X0oooo
00<000000?ooo`3oool0303oool7000000040?ooo`0000000000000003H0oooo1000001I0?ooo`00
F@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00`0oooo2@00000d0?ooo`@00000
G@3oool005X0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0=0?ooo`P00000<03o
ool400000640oooo001K0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool03@3oool5
000000030?ooo`000000oooo02d0oooo0`00001U0?ooo`00G03oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo00d0oooo1P00000[0?ooo`@00000J03oool005d0oooo0P00000D0?ooo`03
0000003oool0oooo00d0oooo1@00000X0?ooo`@00000K03oool005l0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0=0?ooo`D00000903oool400000700oooo001P0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool03@3oool500000280oooo0`00001d0?ooo`00H@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo1000000N0?ooo`@00000M`3oool0
0680oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`D000006`3oool40000
07/0oooo001S0?ooo`8000003@3oool00`000000oooo0?ooo`0=0?ooo`@000005`3oool4000007l0
oooo001U0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0C0?ooo`<00000P`3oool006H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0Q0?ooo`@00000QP3oool006L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0M
0?ooo`@00000RP3oool006P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0J0?oo
o`<00000SP3oool006T0oooo0P0000070?ooo`030000003oool0oooo01H0oooo1000002A0?ooo`00
J`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0180oooo1000002E0?ooo`00K03o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo1000002I0?ooo`00K@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo0`00002M0?ooo`00KP3oool01@00
0000oooo0?ooo`3oool0000000T0oooo1000002P0?ooo`00K`3oool2000000030?ooo`000000oooo
00@0oooo1000002T0?ooo`00L@3oool2000000030?ooo`000000000000800000Z03oool00780oooo
0P00002/0?ooo`00\
\>"],
  ImageRangeCache->{{{81, 368}, {644.75, 440.688}} -> {-0.270295, 1.57793, \
0.00332715, 0.00332715}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  " and ",
  StyleBox["GraphPlot3D", "MR"],
  " also work with graphs created by the ",
  StyleBox["Combinatorica",
    FontSlant->"Italic"],
  " package. This example creates a butterfly graph using ",
  StyleBox["Combinatorica", "TR",
    FontSlant->"Italic"],
  " and shows the layout ",
  StyleBox["Combinatorica",
    FontSlant->"Italic"],
  " assigned."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g = ButterflyGraph[3]; \ ShowGraph[g];\)], "Input",
  CellLabel->"In[8]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.1 2 0.0483871 0.967742 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.1 .04839 m
.36667 .04839 L
s
.1 .04839 m
.36667 .56452 L
s
.36667 .04839 m
.63333 .04839 L
s
.36667 .04839 m
.63333 .30645 L
s
.36667 .04839 m
.1 .56452 L
s
.63333 .04839 m
.9 .04839 L
s
.63333 .04839 m
.9 .17742 L
s
.63333 .04839 m
.36667 .30645 L
s
.9 .04839 m
.63333 .17742 L
s
.1 .17742 m
.36667 .17742 L
s
.1 .17742 m
.36667 .69355 L
s
.36667 .17742 m
.63333 .17742 L
s
.36667 .17742 m
.63333 .43548 L
s
.36667 .17742 m
.1 .69355 L
s
.63333 .17742 m
.9 .17742 L
s
.63333 .17742 m
.36667 .43548 L
s
.1 .30645 m
.36667 .30645 L
s
.1 .30645 m
.36667 .82258 L
s
.36667 .30645 m
.63333 .30645 L
s
.36667 .30645 m
.1 .82258 L
s
.63333 .30645 m
.9 .30645 L
s
.63333 .30645 m
.9 .43548 L
s
.9 .30645 m
.63333 .43548 L
s
.1 .43548 m
.36667 .43548 L
s
.1 .43548 m
.36667 .95161 L
s
.36667 .43548 m
.63333 .43548 L
s
.36667 .43548 m
.1 .95161 L
s
.63333 .43548 m
.9 .43548 L
s
.1 .56452 m
.36667 .56452 L
s
.36667 .56452 m
.63333 .56452 L
s
.36667 .56452 m
.63333 .82258 L
s
.63333 .56452 m
.9 .56452 L
s
.63333 .56452 m
.9 .69355 L
s
.63333 .56452 m
.36667 .82258 L
s
.9 .56452 m
.63333 .69355 L
s
.1 .69355 m
.36667 .69355 L
s
.36667 .69355 m
.63333 .69355 L
s
.36667 .69355 m
.63333 .95161 L
s
.63333 .69355 m
.9 .69355 L
s
.63333 .69355 m
.36667 .95161 L
s
.1 .82258 m
.36667 .82258 L
s
.36667 .82258 m
.63333 .82258 L
s
.63333 .82258 m
.9 .82258 L
s
.63333 .82258 m
.9 .95161 L
s
.9 .82258 m
.63333 .95161 L
s
.1 .95161 m
.36667 .95161 L
s
.36667 .95161 m
.63333 .95161 L
s
.63333 .95161 m
.9 .95161 L
s
.025 w
.1 .04839 Mdot
.36667 .04839 Mdot
.63333 .04839 Mdot
.9 .04839 Mdot
.1 .17742 Mdot
.36667 .17742 Mdot
.63333 .17742 Mdot
.9 .17742 Mdot
.1 .30645 Mdot
.36667 .30645 Mdot
.63333 .30645 Mdot
.9 .30645 Mdot
.1 .43548 Mdot
.36667 .43548 Mdot
.63333 .43548 Mdot
.9 .43548 Mdot
.1 .56452 Mdot
.36667 .56452 Mdot
.63333 .56452 Mdot
.9 .56452 Mdot
.1 .69355 Mdot
.36667 .69355 Mdot
.63333 .69355 Mdot
.9 .69355 Mdot
.1 .82258 Mdot
.36667 .82258 Mdot
.63333 .82258 Mdot
.9 .82258 Mdot
.1 .95161 Mdot
.36667 .95161 Mdot
.63333 .95161 Mdot
.9 .95161 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool3000004X0oooo0`0000190?ooo`<00000BP3oool3000001`0oooo000J0?ooo`D0
0000B03oool5000004L0oooo1@0000180?ooo`D000006`3oool001T0oooo1`0000160?ooo`L00000
A@3oool7000004H0oooo1`00000J0?ooo`006@3oooo]000001X0oooo000I0?ooo`L00000AP3oool7
000004D0oooo1`0000160?ooo`L000006P3oool001X0oooo1@0000180?ooo`D00000A`3oool50000
00030?ooo`00000000000480oooo0P0000000`3oool0000000000003000001/0oooo000K0?ooo`@0
0000B03oool4000000030?ooo`000000oooo04@0oooo00<000000?ooo`0000000P0000040?ooo`80
0000?P3oool2000000@0oooo0`00000L0?ooo`007P3oool00`000000oooo0?ooo`160?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`090?ooo`800000
>P3oool2000002D0oooo000O0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00`0oooo0P00000f0?ooo`8000009`3o
ool001l0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool03`3oool200000380oooo0P00000Y0?ooo`00803oool00`00
0000oooo0?ooo`120?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0>`3oool00`00
0000oooo0?ooo`0B0?ooo`800000;P3oool2000002/0oooo000P0?ooo`030000003oool0oooo0480
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01D0
oooo0P00000Z0?ooo`800000;@3oool00240oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0603oool2000002H0oooo
0P00000_0?ooo`008@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0=@3oool00`000000oooo0?ooo`0K0?ooo`8000008P3oool200000340oooo000R
0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0c
0?ooo`030000003oool0oooo01h0oooo0P00000N0?ooo`800000<`3oool00280oooo00<000000?oo
o`3oool0?P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0340oooo00<000000?oo
o`3oool08@3oool3000001P0oooo0`00000e0?ooo`008`3oool00`000000oooo0?ooo`0l0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0U0?ooo`80
0000503oool2000003P0oooo000S0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo02P0oooo0P00000@0?ooo`800000
>P3oool002@0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool0:`3oool2000000`0oooo0P00000l0?ooo`00903oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0:@3oool0
0`000000oooo0?ooo`0^0?ooo`800000203oool2000003h0oooo000U0?ooo`030000003oool0oooo
03P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo
0340oooo0P0000040?ooo`800000@03oool002D0oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0=03oool400000480
oooo000V0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool06P3oool2000002<0oooo
0P00000g0?ooo`@00000@P3oool002H0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0=@3oool2000000@0oooo0P00
00100?ooo`009`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01h0oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`0d0?ooo`800000203oool2000003h0oooo000W0?oo
o`030000003oool0oooo03@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo03<0oooo0P00000<0?ooo`800000?03oool002P0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool0<P3oool200000100oooo0P00000j0?ooo`00:03oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo0280oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0a0?ooo`800000
503oool2000003P0oooo000Y0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02l0oooo0`00000H0?ooo`<00000=@3o
ool002T0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0;P3oool2000001h0oooo0P00000c0?ooo`00:P3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0]0?ooo`8000008P3oool200000340oooo000Z0?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo02`0
oooo0P00000V0?ooo`800000;`3oool002/0oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0:`3oool2000002X0oooo
0P00000]0?ooo`00;03oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0Z0?ooo`800000;P3oool2000002/0oooo000/
0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo02T0oooo0P00000b0?ooo`800000:@3oool002d0oooo00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0:03oool2000003H0oooo0P00000W0?ooo`00;@3oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0W0?ooo`80
0000>P3oool2000002D0oooo000K0?ooo`<00000403oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo00h0oooo0`00000Q0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
7`3oool3000000@0oooo0P00000n0?ooo`800000103oool3000001`0oooo000J0?ooo`D000003`3o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00d0oooo1@00000Q0?ooo`050000003o
ool0oooo0?ooo`0000008@3oool5000000030?ooo`00000000000480oooo0P0000000`3oool00000
00000003000001/0oooo000I0?ooo`L000003`3oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo00d0oooo1`00000Q0?ooo`030000003oool000000240oooo1`0000160?ooo`L000006P3o
ool001T0ooook@00000J0?ooo`006@3oool700000100oooo00<000000?ooo`3oool08P3oool00`00
0000oooo0?ooo`0>0?ooo`L000008@3oool00`000000oooo0000000Q0?ooo`L00000AP3oool70000
01X0oooo000J0?ooo`D000004@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00l0
oooo1@00000Q0?ooo`050000003oool0oooo0?ooo`0000008@3oool5000004P0oooo1@00000K0?oo
o`006`3oool400000180oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0@0?ooo`@0
000000<0oooo0000003oool07P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`0000000P00001:0?ooo`<00000703oool001h0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`1/0?ooo`007`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo06d0oooo000O0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07P3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0KP3oool0
0200oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1_0?ooo`00803oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo0700oooo000Q0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0L@3oool00240oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`1b0?ooo`008P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo07<0oooo000R0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0M03oool002<0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`1e0?ooo`008`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo07H0oooo000T0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0M`3o
ool002@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`1h0?ooo`009@3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0G0?ooo`050000003oool0oooo0?ooo`0000008@3oool01@000000oooo0?ooo`3o
ool0000007/0oooo000U0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`0000008`3oool0
0`000000oooo0000001l0?ooo`009P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`<000008`3oool30000
07`0oooo000V0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00D000000?ooo`3oool0oooo0000000Q0?oo
o`050000003oool0oooo0?ooo`000000N`3oool002L0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`1h0?ooo`009`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07L0
oooo000X0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0MP3oool002P0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`1e0?ooo`00:@3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo07@0oooo000Y0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0L`3oool002X0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1b0?ooo`00
:P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0740oooo000[0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0L03oool002`0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`1_0?ooo`00;03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
06h0oooo000]0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0K@3oool002d0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1/0?ooo`00;P3oool00`000000oooo0?oo
o`0@0?ooo`040000003oool0oooo00000180oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`1[0?ooo`006`3oool300000100oooo00<000000?ooo`3oool0403oool010000000oooo0?oo
o`00000B0?ooo`030000003oool0oooo00h0oooo1000000Q0?ooo`050000003oool0oooo0?ooo`00
00008@3oool4000004X0oooo0`00000L0?ooo`006P3oool500000100oooo00<000000?ooo`3oool0
403oool200000180oooo00<000000?ooo`3oool03P3oool500000280oooo00<000000?ooo`000000
8P3oool5000004P0oooo1@00000K0?ooo`006@3oooo]000001X0oooo000I0?ooo`L00000403oool0
0`000000oooo0?ooo`0?0?ooo`8000004@3oool00`000000oooo0?ooo`0>0?ooo`L000008@3oool0
0`000000oooo0000000Q0?ooo`L00000AP3oool7000001X0oooo000I0?ooo`L00000403oool00`00
0000oooo0?ooo`0?0?ooo`8000004@3oool00`000000oooo0?ooo`0>0?ooo`L00000803oool01@00
0000oooo0?ooo`3oool000000200oooo2@0000120?ooo`T000006P3oool001X0oooo1@00000B0?oo
o`030000003oool0oooo00d0oooo00@000000?ooo`3oool000003`3oool00`000000oooo0?ooo`0@
0?ooo`D00000803oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01h0oooo1@000003
0?ooo`800000?P3oool2000000<0oooo1@00000K0?ooo`006`3oool400000180oooo00<000000?oo
o`3oool03@3oool010000000oooo0?ooo`00000?0?ooo`030000003oool0oooo0100oooo1000000P
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool07P3oool3000000H0oooo0P00000j
0?ooo`8000001P3oool3000001`0oooo000O0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0:03oool2000003H0oooo0P00000W0?ooo`007`3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo02T0oooo0P00000b0?ooo`800000:@3oool00200oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0Z0?ooo`800000;P3oool2000002/0oooo000P0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0:`3oool2000002X0oooo0P00000]0?ooo`008@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo02`0oooo0P00000V0?ooo`800000;`3oool0
0240oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
01h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0]0?ooo`8000008P3oool20000
0340oooo000R0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0;P3oool2000001h0
oooo0P00000c0?ooo`008P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02l0oooo
0`00000H0?ooo`<00000=@3oool002<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0a0?ooo`800000503oool2000003P0oooo000S0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool0<P3oool200000100oooo0P00000j0?ooo`00903oool00`000000oooo0?ooo`0@0?oo
o`050000003oool0oooo0?ooo`0000003P3oool01@000000oooo0?ooo`3oool000000180oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo03<0oooo0P00
000<0?ooo`800000?03oool002@0oooo00<000000?ooo`3oool0403oool010000000oooo0?ooo`00
000@0?ooo`040000003oool0oooo00000180oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo03@0oooo0P0000080?ooo`800000?P3oool002D0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0000000@0?ooo`030000003oool000000180oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03D0oooo0P00
00040?ooo`800000@03oool002D0oooo00<000000?ooo`3oool0403oool200000180oooo0P00000B
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0f
0?ooo`@00000@P3oool002H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool06@3oool2000002D0oooo0P00000f0?oo
o`@00000@P3oool002H0oooo00<000000?ooo`3oool03`3oool200000180oooo0P00000A0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0a0?ooo`80
0000103oool200000400oooo000W0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`000000
403oool00`000000oooo0000000@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
:@3oool00`000000oooo0?ooo`0^0?ooo`800000203oool2000003h0oooo000W0?ooo`030000003o
ool0oooo00d0oooo00@000000?ooo`3oool00000403oool010000000oooo0?ooo`00000?0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0[0?ooo`80
0000303oool2000003`0oooo000X0?ooo`030000003oool0oooo00`0oooo00D000000?ooo`3oool0
oooo0000000>0?ooo`050000003oool0oooo0?ooo`0000003P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo02d0oooo00<000000?ooo`3oool0:03oool200000100oooo0P00000j0?oo
o`00:03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo02D0oooo0P00000D0?ooo`80
0000>03oool002T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0Q0?ooo`<00000
603oool3000003D0oooo000Y0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool07P3o
ool2000001h0oooo0P00000c0?ooo`00:P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0
oooo01/0oooo0P00000R0?ooo`800000<@3oool002X0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0=`3oool00`00
0000oooo0?ooo`0H0?ooo`8000009P3oool2000002l0oooo000[0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03T0
oooo00<000000?ooo`3oool05@3oool2000002X0oooo0P00000]0?ooo`00;03oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0k0?ooo`030000003oool0oooo0180oooo0P00000^0?ooo`800000:`3oool002`0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0?@3oool00`000000oooo0?ooo`0?0?ooo`800000<P3oool2000002T0oooo000]
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0303oool2000003H0oooo0P00000W
0?ooo`00;@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00T0oooo0P00000j0?oo
o`8000009@3oool002h0oooo00@000000?ooo`3oool000003`3oool010000000oooo0?ooo`00000?
0?ooo`040000003oool0oooo000001@0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?oo
o`060?ooo`800000?P3oool2000002<0oooo000K0?ooo`<00000403oool010000000oooo0?ooo`00
000?0?ooo`040000003oool0oooo000000l0oooo00@000000?ooo`3oool00000403oool4000004L0
oooo100000020?ooo`800000@P3oool200000080oooo0`00000L0?ooo`006P3oool500000100oooo
0P00000A0?ooo`8000004@3oool200000100oooo1@0000170?ooo`H00000AP3oool6000001/0oooo
000I0?ooond000006P3oool001T0oooo1`00000?0?ooo`8000004@3oool200000140oooo0P00000?
0?ooo`L00000A@3oool7000004H0oooo1`00000J0?ooo`006@3oool7000000l0oooo0P00000A0?oo
o`8000004@3oool2000000l0oooo1`0000150?ooo`L00000AP3oool7000001X0oooo000J0?ooo`D0
00003`3oool010000000oooo0?ooo`00000?0?ooo`040000003oool0oooo000000l0oooo00@00000
0?ooo`3oool000003`3oool5000004L0oooo1@0000180?ooo`D000006`3oool001/0oooo1000000?
0?ooo`040000003oool0oooo000000l0oooo00@000000?ooo`3oool000003`3oool010000000oooo
0?ooo`00000?0?ooo`@00000B@3oool3000004X0oooo0`00000L0?ooo`007`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0;L0oooo000O0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0]`3oool00200oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`2h
0?ooo`00803oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0;P0oooo000Q0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0^@3oool00240oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`2i0?ooo`008P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0;X0oooo000R0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0^P3oool0
02<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2k0?ooo`008`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0;/0oooo000T0?ooo`050000003oool0oooo0?ooo`00
00003P3oool01@000000oooo0?ooo`3oool0000000h0oooo00D000000?ooo`3oool0oooo0000000>
0?ooo`050000003oool0oooo0?ooo`000000_P3oool002@0oooo00@000000?ooo`3oool000003`3o
ool010000000oooo0?ooo`00000@0?ooo`040000003oool0oooo000000l0oooo00@000000?ooo`3o
ool00000_P3oool002D0oooo00<000000?ooo`000000403oool00`000000oooo0000000@0?ooo`03
0000003oool000000100oooo00<000000?ooo`000000_`3oool002D0oooo0P00000A0?ooo`800000
4P3oool200000140oooo0P00002o0?ooo`009P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`2n0?ooo`009@3oool2
00000140oooo0P00000B0?ooo`8000004@3oool200000;l0oooo000U0?ooo`030000003oool00000
0100oooo00<000000?ooo`000000403oool00`000000oooo0000000@0?ooo`030000003oool00000
0;l0oooo000T0?ooo`040000003oool0oooo000000l0oooo00@000000?ooo`3oool00000403oool0
10000000oooo0?ooo`00000?0?ooo`040000003oool0oooo00000;h0oooo000T0?ooo`050000003o
ool0oooo0?ooo`0000003P3oool01@000000oooo0?ooo`3oool0000000h0oooo00D000000?ooo`3o
ool0oooo0000000>0?ooo`050000003oool0oooo0?ooo`000000_P3oool002<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`2k0?ooo`008`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0;/0oooo000R0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
^P3oool00280oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`2j0?ooo`008@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo0;T0oooo000Q0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0^@3oool00200oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`2h0?ooo`00803oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0;P0oooo
000O0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0]`3oool001l0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`2g0?ooo`007P3oool00`000000oooo0?ooo`0=0?oo
o`040000003oool0oooo000000l0oooo00@000000?ooo`3oool000003`3oool010000000oooo0?oo
o`00000?0?ooo`030000003oool0oooo0;H0oooo000K0?ooo`@000003`3oool010000000oooo0?oo
o`00000?0?ooo`040000003oool0oooo000000l0oooo00@000000?ooo`3oool000003`3oool40000
04T0oooo0`00001:0?ooo`<00000703oool001X0oooo1@00000@0?ooo`8000004@3oool200000140
oooo0P00000@0?ooo`D00000A`3oool5000004P0oooo1@00000K0?ooo`006@3oool7000000l0oooo
0P00000A0?ooo`8000004@3oool2000000l0oooo1`0000150?ooo`L00000AP3oool7000001X0oooo
000I0?ooond000006P3oool001T0oooo1`00000?0?ooo`8000004@3oool200000140oooo0P00000?
0?ooo`L00000A@3oool7000004H0oooo1`00000J0?ooo`006P3oool5000000l0oooo00@000000?oo
o`3oool000003`3oool010000000oooo0?ooo`00000?0?ooo`040000003oool0oooo000000l0oooo
1@0000170?ooo`D0000000<0oooo000000000000@P3oool2000000030?ooo`000000000000<00000
6`3oool001/0oooo0`00000@0?ooo`040000003oool0oooo000000l0oooo00@000000?ooo`3oool0
00003`3oool010000000oooo0?ooo`00000@0?ooo`<0000000<0oooo0000003oool0A03oool00`00
0000oooo00000002000000@0oooo0P00000n0?ooo`800000103oool3000001`0oooo000]0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo0440oooo00<000000?ooo`3oool02@3oool2000003X0oooo0P00000U0?ooo`00
;@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo00`0oooo0P00000f0?ooo`800000
9`3oool002`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0?0?ooo`800000<P3o
ool2000002T0oooo000/0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool04P3oool2
000002h0oooo0P00000[0?ooo`00:`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo
01D0oooo0P00000Z0?ooo`800000;@3oool002X0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0=`3oool00`000000
oooo0?ooo`0H0?ooo`8000009P3oool2000002l0oooo000Z0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool06`3oool200000280oooo0P00000a0?ooo`00:@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0c0?ooo`030000003oool0oooo01h0oooo0P00000N0?ooo`800000<`3oool002T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`0Q0?ooo`<00000603oool3000003D0oooo000X0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool09@3oool2000001@0oooo0P00000h0?oo
o`00:03oool00`000000oooo0?ooo`0<0?ooo`050000003oool0oooo0?ooo`0000003P3oool01@00
0000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0]
0?ooo`030000003oool0oooo02P0oooo0P00000@0?ooo`800000>P3oool002L0oooo00<000000?oo
o`3oool03@3oool010000000oooo0?ooo`00000@0?ooo`040000003oool0oooo000000l0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02/0oooo0P00
000<0?ooo`800000?03oool002L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0000000@
0?ooo`030000003oool000000100oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0Y
0?ooo`030000003oool0oooo02h0oooo0P0000080?ooo`800000?P3oool002H0oooo00<000000?oo
o`3oool03`3oool200000180oooo0P00000A0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`0a0?ooo`800000103oool200000400oooo000V0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0d0?ooo`@0
0000@P3oool002D0oooo00<000000?ooo`3oool0403oool200000180oooo0P00000B0?ooo`030000
003oool0oooo01T0oooo0P00000S0?ooo`800000=`3oool400000480oooo000U0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`000000403oool00`000000oooo0000000B0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0e0?ooo`800000103o
ool200000400oooo000T0?ooo`030000003oool0oooo0100oooo00@000000?ooo`3oool00000403o
ool010000000oooo0?ooo`00000B0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
7@3oool00`000000oooo0?ooo`0d0?ooo`800000203oool2000003h0oooo000T0?ooo`030000003o
ool0oooo0100oooo00D000000?ooo`3oool0oooo0000000>0?ooo`050000003oool0oooo0?ooo`00
00004P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0<`3oool2000000`0oooo0P00000l0?ooo`008`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo0380oooo0P00000@0?ooo`800000>P3oool002<0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0a0?ooo`800000503oool2000003P0oooo000R0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool0;`3oool3000001P0oooo0`00000e0?ooo`008P3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo02h0oooo0P00000N0?ooo`800000<`3oool00240
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0]0?ooo`8000008P3oool200000340
oooo000Q0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0;03oool2000002H0oooo
0P00000_0?ooo`00803oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02/0oooo0P00
000Z0?ooo`800000;@3oool00200oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0Z
0?ooo`800000;P3oool2000002/0oooo000O0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0:@3oool200000380oooo0P00000Y0?ooo`007`3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo02P0oooo0P00000f0?ooo`8000009`3oool001h0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo000000l0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool09`3oool2000003X0oooo0P00000U0?ooo`006`3oool400000180oooo00<000000?ooo`3oool0
3@3oool010000000oooo0?ooo`00000?0?ooo`030000003oool0oooo0100oooo1000000Q0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool07`3oool3000000@0oooo0P00000n0?ooo`80
0000103oool3000001`0oooo000J0?ooo`D000004@3oool00`000000oooo0?ooo`0?0?ooo`800000
4@3oool00`000000oooo0?ooo`0?0?ooo`D000008@3oool01@000000oooo0?ooo`3oool000000240
oooo1@0000000`3oool00000000000120?ooo`80000000<0oooo0000000000000`00000K0?ooo`00
6@3oool700000100oooo00<000000?ooo`3oool03`3oool200000140oooo00<000000?ooo`3oool0
3P3oool700000240oooo00<000000?ooo`0000008@3oool7000004H0oooo1`00000J0?ooo`006@3o
ooo]000001X0oooo000I0?ooo`L000003`3oool00`000000oooo0?ooo`0@0?ooo`8000004P3oool0
0`000000oooo0?ooo`0=0?ooo`L000008@3oool00`000000oooo0000000Q0?ooo`L00000AP3oool7
000001X0oooo000J0?ooo`D000003`3oool00`000000oooo0?ooo`0@0?ooo`040000003oool0oooo
00000180oooo00<000000?ooo`3oool03@3oool500000240oooo00D000000?ooo`3oool0oooo0000
000Q0?ooo`D00000B03oool5000001/0oooo000K0?ooo`<00000403oool00`000000oooo0?ooo`0@
0?ooo`040000003oool0oooo00000180oooo00<000000?ooo`3oool03P3oool3000000030?ooo`00
0000oooo01h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0000000800000BP3oool3000001`0oooo000]0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool0K03oool002d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1]0?oo
o`00;03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo06h0oooo000/0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0K`3oool002/0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`1`0?ooo`00:P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0740oooo000Z0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0LP3oool002T0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1c0?ooo`00:@3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo07@0oooo000X0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0M@3oool002P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1f
0?ooo`009`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07L0oooo000W0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0N03oool002H0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
603oool01@000000oooo0?ooo`3oool000000240oooo00D000000?ooo`3oool0oooo0000001k0?oo
o`009P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0I0?ooo`030000003oool0000002<0oooo00<000000?ooo`00
0000O03oool002D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0603oool3000002<0oooo0`00001l0?ooo`009@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0G0?ooo`050000003oool0oooo0?ooo`0000008@3oool01@000000oooo
0?ooo`3oool0000007/0oooo000T0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
N03oool002@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1g0?ooo`008`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo07H0oooo000S0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0M@3oool00280oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`1d0?ooo`008P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo07<0oooo
000Q0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0LP3oool00240oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`1a0?ooo`00803oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo0700oooo000P0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0K`3oool001l0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0N0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1^0?ooo`007`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo06d0oooo000N0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0K03oool001/0oooo1000000B0?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool0403oool4000000030?ooo`000000oooo01h0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0000000800000BP3oool30000
01`0oooo000J0?ooo`D000004@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00l0
oooo1@00000Q0?ooo`050000003oool0oooo0?ooo`0000008@3oool5000004P0oooo1@00000K0?oo
o`006@3oool700000100oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0>0?ooo`L0
00008@3oool00`000000oooo0000000Q0?ooo`L00000AP3oool7000001X0oooo000I0?ooond00000
6P3oool001T0oooo1`00000?0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool03@3o
ool700000240oooo00<000000?ooo`0000008@3oool7000004H0oooo1`00000J0?ooo`006P3oool5
000000l0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0=0?ooo`D000008@3oool0
1@000000oooo0?ooo`3oool000000240oooo1@0000000`3oool00000000000120?ooo`80000000<0
oooo0000000000000`00000K0?ooo`006`3oool300000100oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0>0?ooo`<000008@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01l0oooo0`0000040?ooo`800000?P3oool2000000@0oooo0`00000L0?ooo`00;@3oool00`00
0000oooo0?ooo`0X0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0W0?ooo`800000>P3oool2000002D0oooo000]0?ooo`030000003oool0oooo02P0
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02P0
oooo0P00000f0?ooo`8000009`3oool002`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`0]0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0:@3oool200000380oooo
0P00000Y0?ooo`00;03oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0Z0?ooo`800000;P3oool2000002/0oooo000[
0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo02/0oooo0P00000Z0?ooo`800000;@3oool002X0oooo00<000000?oo
o`3oool0;P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0;03oool2000002H0oooo0P00000_0?ooo`00:P3oool00`000000oooo0?ooo`0^0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0]0?ooo`80
00008P3oool200000340oooo000Y0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02h0oooo0P00000N0?ooo`800000
<`3oool002T0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool0;`3oool3000001P0oooo0`00000e0?ooo`00:03oool0
0`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0a0?ooo`800000503oool2000003P0oooo000X0?ooo`030000003oool0oooo
0380oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
0380oooo0P00000@0?ooo`800000>P3oool002L0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0<`3oool2000000`0
oooo0P00000l0?ooo`009`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0d0?ooo`800000203oool2000003h0oooo
000V0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo03D0oooo0P0000040?ooo`800000@03oool002H0oooo00<00000
0?ooo`3oool0=P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0240oooo00<00000
0?ooo`3oool0=P3oool400000480oooo000U0?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool0603oool2000002D0oooo0P00000f0?ooo`@00000@P3oool002D0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3o
ool0<@3oool2000000@0oooo0P0000100?ooo`00903oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0^0?ooo`800000
203oool2000003h0oooo000T0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02/0oooo0P00000<0?ooo`800000?03o
ool002<0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo02d0oooo00<000000?ooo`3oool0:03oool200000100oooo0P00000j0?ooo`008`3oool00`00
0000oooo0?ooo`0l0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0;`3oool00`00
0000oooo0?ooo`0U0?ooo`800000503oool2000003P0oooo000R0?ooo`030000003oool0oooo03h0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0240
oooo0`00000H0?ooo`<00000=@3oool00280oooo00<000000?ooo`3oool0?P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool07P3oool2000001h0oooo
0P00000c0?ooo`008@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0=@3oool00`000000oooo0?ooo`0K0?ooo`8000008P3oool200000340oooo000Q
0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0g
0?ooo`030000003oool0oooo01P0oooo0P00000V0?ooo`800000;`3oool00200oooo00<000000?oo
o`3oool0@P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03T0oooo00<000000?oo
o`3oool05@3oool2000002X0oooo0P00000]0?ooo`00803oool00`000000oooo0?ooo`120?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0B0?ooo`80
0000;P3oool2000002/0oooo000O0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00l0oooo0P00000b0?ooo`800000
:@3oool001l0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo03l0oooo00<000000?ooo`3oool0303oool2000003H0oooo0P00000W0?ooo`007P3oool0
0`000000oooo0?ooo`160?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0@@3oool0
0`000000oooo0?ooo`090?ooo`800000>P3oool2000002D0oooo000K0?ooo`@00000B03oool40000
00030?ooo`000000oooo04@0oooo00<000000?ooo`0000000P0000040?ooo`800000?P3oool20000
00@0oooo0`00000L0?ooo`006P3oool5000004P0oooo1@0000170?ooo`D0000000<0oooo00000000
0000@P3oool2000000030?ooo`000000000000<000006`3oool001T0oooo1`0000160?ooo`L00000
A@3oool7000004H0oooo1`00000J0?ooo`006@3oooo]000001X0oooo000I0?ooo`L00000AP3oool7
000004D0oooo1`0000160?ooo`L000006P3oool001X0oooo1@0000180?ooo`D00000A`3oool50000
04P0oooo1@00000K0?ooo`006`3oool3000004X0oooo0`0000190?ooo`<00000BP3oool3000001`0
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo0000\
\>"],
  ImageRangeCache->{{{81, 368}, {370.25, 83.25}} -> {0.408881, 0.249736, \
0.00174218, 0.0036005}}]
}, Open  ]],

Cell[TextData[{
  "This draws the same graph using ",
  StyleBox["GraphPlot", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[g];\)\)], "Input",
  CellLabel->"In[9]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00885 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.499236 0.480416 0.50441 0.480416 [
[ 0 0 0 0 ]
[ 1 1.00885 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.19796 .80236 m
.10857 .58592 L
s
.19796 .80236 m
.41364 .899 L
s
.10857 .58592 m
.02442 .35383 L
s
.10857 .58592 m
.112 .41888 L
s
.10857 .58592 m
.25264 .74942 L
s
.02442 .35383 m
.1226 .12528 L
s
.02442 .35383 m
.08098 .08116 L
s
.02442 .35383 m
.02381 .65131 L
s
.1226 .12528 m
.352 .02402 L
s
.8821 .13134 m
.65267 .02655 L
s
.8821 .13134 m
.97619 .35967 L
s
.65267 .02655 m
.352 .02402 L
s
.65267 .02655 m
.4189 .10765 L
s
.65267 .02655 m
.92209 .08574 L
s
.352 .02402 m
.08098 .08116 L
s
.352 .02402 m
.5843 .10797 L
s
.12196 .88293 m
.02381 .65131 L
s
.12196 .88293 m
.3473 .98373 L
s
.02381 .65131 m
.112 .41888 L
s
.02381 .65131 m
.07533 .92194 L
s
.112 .41888 m
.25634 .25548 L
s
.112 .41888 m
.20266 .20153 L
s
.25634 .25548 m
.4189 .10765 L
s
.74507 .25769 m
.5843 .10797 L
s
.74507 .25769 m
.88731 .4231 L
s
.5843 .10797 m
.4189 .10765 L
s
.5843 .10797 m
.79922 .2042 L
s
.4189 .10765 m
.20266 .20153 L
s
.25264 .74942 m
.41364 .899 L
s
.41364 .899 m
.57948 .89954 L
s
.41364 .899 m
.64615 .98483 L
s
.57948 .89954 m
.7419 .75171 L
s
.57948 .89954 m
.79564 .80557 L
s
.57948 .89954 m
.3473 .98373 L
s
.7419 .75171 m
.88811 .59052 L
s
.92209 .08574 m
.97619 .35967 L
s
.97619 .35967 m
.88811 .59052 L
s
.97619 .35967 m
.97334 .65626 L
s
.88811 .59052 m
.79564 .80557 L
s
.88811 .59052 m
.88731 .4231 L
s
.07533 .92194 m
.3473 .98373 L
s
.3473 .98373 m
.64615 .98483 L
s
.64615 .98483 m
.87323 .88477 L
s
.64615 .98483 m
.91805 .927 L
s
.87323 .88477 m
.97334 .65626 L
s
.79922 .2042 m
.88731 .4231 L
s
.88731 .4231 m
.97334 .65626 L
s
.97334 .65626 m
.91805 .927 L
s
.008 w
.19796 .80236 Mdot
.10857 .58592 Mdot
.02442 .35383 Mdot
.1226 .12528 Mdot
.8821 .13134 Mdot
.65267 .02655 Mdot
.352 .02402 Mdot
.08098 .08116 Mdot
.12196 .88293 Mdot
.02381 .65131 Mdot
.112 .41888 Mdot
.25634 .25548 Mdot
.74507 .25769 Mdot
.5843 .10797 Mdot
.4189 .10765 Mdot
.20266 .20153 Mdot
.25264 .74942 Mdot
.41364 .899 Mdot
.57948 .89954 Mdot
.7419 .75171 Mdot
.92209 .08574 Mdot
.97619 .35967 Mdot
.88811 .59052 Mdot
.79564 .80557 Mdot
.07533 .92194 Mdot
.3473 .98373 Mdot
.64615 .98483 Mdot
.87323 .88477 Mdot
.79922 .2042 Mdot
.88731 .4231 Mdot
.97334 .65626 Mdot
.91805 .927 Mdot
0 0 m
1 0 L
1 1.00885 L
0 1.00885 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  ImageSize->{285.438, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004M00017b000`400?l00000o`00003oo`3ooolN
0?ooo`00o`3ooolN0?ooo`00o`3ooolN0?ooo`00o`3ooolN0?ooo`00o`3ooolN0?ooo`00o`3ooolN
0?ooo`00HP3oool]000008h0oooo001N0?ooo`D0000000<0oooo0000003oool00`00000V0?ooobd0
0000H@3oool005T0oooo1@0000000`3oool00000000000080?ooo`800000BP3oool300000080oooo
1P00001M0?ooo`00E@3oool4000000@0oooo0P00000<0?ooo`<00000A03oool3000000P0oooo0P00
00000`3oool0000000000003000005P0oooo001@0?ooo`D000001@3oool300000140oooo0`00000n
0?ooo`<000003@3oool2000000@0oooo1000001D0?ooo`00C03oool4000000P0oooo0P00000G0?oo
o`<00000>@3oool200000180oooo0P0000060?ooo`D00000C`3oool004L0oooo1@00000:0?ooo`80
0000703oool2000003@0oooo0`00000F0?ooo`8000002@3oool4000004/0oooo00130?ooo`@00000
303oool300000200oooo0`00000^0?ooo`<000006`3oool3000000X0oooo1@0000160?ooo`00?P3o
ool5000000h0oooo0P00000V0?ooo`<00000:03oool300000240oooo0P00000=0?ooo`@00000@P3o
ool003T0oooo1@00000A0?ooo`800000:`3oool300000280oooo0`00000V0?ooo`8000003`3oool5
000003d0oooo000e0?ooo`@00000503oool200000300oooo0P00000M0?ooo`<00000:`3oool20000
0180oooo1@00000h0?ooo`00<03oool5000001D0oooo0`00000d0?ooo`<000005`3oool300000300
oooo0P00000E0?ooo`@00000=03oool002`0oooo1000000H0?ooo`800000>P3oool300000140oooo
0`00000e0?ooo`8000005`3oool5000002l0oooo000W0?ooo`D000006P3oool2000003l0oooo0`00
000<0?ooo`800000>P3oool3000001T0oooo1000000[0?ooo`008`3oool4000001`0oooo0`000014
0?ooo`8000001`3oool3000003l0oooo0P00000K0?ooo`D000009P3oool001h0oooo1@00000N0?oo
o`800000B@3oool3000000040?ooo`0000000000000004@0oooo0P00000N0?ooo`@000008P3oool0
01H0oooo0P0000020?ooo`@000008@3oool2000004`0oooo1@0000170?ooo`800000803oool50000
01d0oooo000G0?ooo`<000008`3oool2000004/0oooo0`0000050?ooo`<00000AP3oool2000002<0
oooo1000000I0?ooo`005`3oool00`000000oooo0?ooo`0P0?ooo`<00000BP3oool3000000/0oooo
0P0000160?ooo`8000009@3oool3000001H0oooo000G0?ooo`030000003oool0oooo01h0oooo0P00
001:0?ooo`<00000403oool3000004D0oooo0`00000T0?ooo`030000003oool0oooo01@0oooo000F
0?ooo`030000003oool0oooo01d0oooo0P00001:0?ooo`8000005P3oool3000004D0oooo0P00000R
0?ooo`030000003oool0oooo01@0oooo000F0?ooo`030000003oool0oooo01/0oooo0P0000190?oo
o`<000006`3oool3000004@0oooo0P00000Q0?ooo`030000003oool0oooo01<0oooo000F0?ooo`03
0000003oool0oooo01P0oooo0`0000180?ooo`<000008@3oool2000004@0oooo0P00000O0?ooo`03
0000003oool0oooo01<0oooo000F0?ooo`030000003oool0oooo01H0oooo0P0000180?ooo`<00000
9P3oool3000004<0oooo0P00000M0?ooo`030000003oool0oooo01<0oooo000E0?ooo`030000003o
ool0oooo01D0oooo0P0000170?oooc800000@P3oool2000001/0oooo00<000000?ooo`3oool04`3o
ool001D0oooo00<000000?ooo`3oool04P3oool3000004L0oooo1000000^0?ooo`@00000@P3oool3
000001P0oooo00<000000?ooo`3oool04`3oool001D0oooo00<000000?ooo`3oool0403oool20000
04P0oooo0P0000000`3oool000000?ooo`0a0?ooo`040000003oool00000000004<0oooo0P00000G
0?ooo`030000003oool0oooo0180oooo000E0?ooo`030000003oool0oooo00h0oooo0P0000170?oo
o`<000000P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00800000@`3oool20000
01D0oooo00<000000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool0303oool2000004L0
oooo0P0000030?ooo`800000=P3oool010000000oooo0?ooo`3oool2000004<0oooo0P00000C0?oo
o`030000003oool0oooo0180oooo000D0?ooo`030000003oool0oooo00/0oooo0P0000170?ooo`80
0000103oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0080oooo0P0000130?ooo`80
00004@3oool00`000000oooo0?ooo`0B0?ooo`00503oool00`000000oooo0?ooo`0;0?ooo`800000
A@3oool2000000D0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`030?ooo`<00000
@P3oool2000000l0oooo00<000000?ooo`3oool04P3oool001@0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`120?ooo`<000001P3oool00`000000oooo0?ooo`0k0?ooo`030000003o
ool0oooo00D0oooo0P0000120?ooo`<00000303oool00`000000oooo0?ooo`0B0?ooo`00503oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0400oooo0P0000080?ooo`030000003oool0
oooo03d0oooo00<000000?ooo`3oool01P3oool200000440oooo0P00000=0?ooo`030000003oool0
oooo0140oooo000C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0?`3oool20000
00T0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`070?ooo`800000@03oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo000C0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0?03oool3000000X0oooo00<000000?ooo`3oool0@@3oool00`000000
oooo0?ooo`080?ooo`800000?P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140
oooo000C0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0>`3oool2000000`0oooo
00<000000?ooo`3oool0@`3oool2000000X0oooo0`00000l0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool04@3oool001<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0i0?ooo`8000003@3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00X0oooo0P00
000j0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool04@3oool001<0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0f0?ooo`<000003@3oool2000004X0oooo00<00000
0?ooo`3oool02`3oool2000003P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0@
0?ooo`004P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03D0oooo0P00000?0?oo
o`030000003oool0oooo04/0oooo00<000000?ooo`3oool0303oool2000003L0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0@0?ooo`004P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo03<0oooo0P00000@0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3o
ool03@3oool2000003D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0@0?ooo`00
4P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0380oooo0P00000A0?ooo`030000
003oool0oooo04l0oooo00<000000?ooo`3oool03P3oool2000003@0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0@0?ooo`004P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo02l0oooo0`00000B0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool03`3o
ool300000340oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`004@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo02h0oooo0P00000D0?ooo`030000003oool0
oooo05<0oooo00<000000?ooo`3oool04@3oool200000300oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0?0?ooo`004@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
02`0oooo0P00000E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool04P3oool20000
02h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0?0?ooo`004@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo02T0oooo0`00000F0?ooo`030000003oool0oooo05L0
oooo00<000000?ooo`3oool04`3oool2000002`0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0?0?ooo`004@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02P0oooo
0P00000G0?ooo`800000F`3oool00`000000oooo0?ooo`0D0?ooo`800000:`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00l0oooo000A0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool09P3oool2000001P0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?oo
o`0E0?ooo`<00000:03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00l0oooo000@
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool09@3oool2000001T0oooo00<00000
0?ooo`3oool0GP3oool00`000000oooo0?ooo`0G0?ooo`8000009`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00h0oooo000@0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool08P3oool3000001X0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0H0?oo
o`8000009@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00h0oooo000@0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool08@3oool2000001`0oooo00<000000?ooo`3o
ool0HP3oool00`000000oooo0?ooo`0I0?ooo`8000008`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00h0oooo000@0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
7`3oool2000001d0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`0J0?ooo`800000
8P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00h0oooo000?0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool07@3oool2000001h0oooo00<000000?ooo`3oool0IP3o
ool00`000000oooo0?ooo`0K0?ooo`@000007P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00h0oooo000?0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool07P3oool2
000001d0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`0L0?ooo`8000007`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo000?0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0K0?ooo`800000K03oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0=0?ooo`003`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00d0
oooo000?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03@3oool000h0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool0L@3oool2000001`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00d0oooo000>0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo07@0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool03@3oool000h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0<0?oo
o`003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`1h0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo000>0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo07X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0O03o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0<0?ooo`003@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool05@3oool200000800oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool0
00d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`003@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`230?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo000<0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo08D0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02`3oool000`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo0180oooo0P0000280?ooo`<00000503oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02`3oool000`0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`000000R@3oool2000001@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00/0oooo000<0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo08/0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02P3oool000`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0S@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`00
2`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`2>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
7@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo08l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0M0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool02P3oool000/0oooo00D000000?ooo`3oool0oooo0000
000P0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0:0?ooo`002`3oool01@000000oooo0?ooo`3oool000000200oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo09D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool02@3oool000X0oooo00D000000?ooo`3oool0oooo0000000P
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`09
0?ooo`002P3oool01@000000oooo0?ooo`3oool000000200oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`2I0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool07@3oool0
1@000000oooo0?ooo`3oool0000000/0oooo000:0?ooo`040000003oool0oooo00000200oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool07@3oool01@000000oooo0?ooo`3oool0000000/0oooo000:0?ooo`040000003o
ool0oooo00000200oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2L0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool07P3oool01@000000oooo0?ooo`3oool0000000X0
oooo00090?ooo`040000003oool0oooo00000200oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`2M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool07@3oool01@000000
oooo0?ooo`3oool0000000X0oooo00090?ooo`040000003oool0oooo00000200oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool07@3oool01@000000oooo0?ooo`3oool0000000X0oooo00090?ooo`040000003oool0oooo
000001l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`00000:0?ooo`002@3oool0
0`000000oooo0000000P0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0X`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01d0oooo00@000000?ooo`3oool000002P3o
ool000P0oooo00@000000?ooo`3oool00000803oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo0:D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0000000X0oooo00080?ooo`030000003oool000000200oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`2W0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool0
10000000oooo0?ooo`0000090?ooo`00203oool00`000000oooo0000000P0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01d0oooo00@000000?ooo`3oool000002@3oool000P0oooo0P00000P0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`0000002@3oool000P0oooo0P00000P0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`0000002@3oool000L0oooo00<000000?ooo`0000007`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0:d0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0M0?ooo`8000002@3oool000L0oooo0P00000P0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`000000203oool000L0oooo0P00000P0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0/@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01h0oooo0P00
00080?ooo`001`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0/`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01d0oooo0P000008
0?ooo`001P3oool200000200oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2e0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool2000000P0oooo00060?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2g0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`060?ooo`00
1P3oool2000001l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2h0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool07@3oool2000000L0oooo00060?ooo`8000007`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0;T0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0N0?ooo`8000001P3oool000H0oooo0P00000N0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0^`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo01d0oooo0P0000060?ooo`001P3oool2000001h0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`2m0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`050?ooo`001P3oool2000001d0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`2o0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool06`3oool2000000L0
oooo00060?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`310?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06`3oool2000000L0oooo
00060?ooo`030000003oool0000001/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`330?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0000
00070?ooo`001P3oool010000000oooo0?ooo`00000J0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0a@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`0000001`3oool000H0oooo00@000000?ooo`3oool000006P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0000000L0oooo00060?ooo`040000003oool0oooo000001T0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`370?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool05`3oool010000000oooo0?ooo`0000070?ooo`001P3oool01@000000oooo0?oo
o`3oool0000001P0oooo00D000000?ooo`3oool0oooo0000003;0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool05`3oool010000000oooo0?ooo`0000070?ooo`001P3oool01@000000
oooo0?ooo`3oool0000001L0oooo00D000000?ooo`3oool0oooo0000003=0?ooo`050000003oool0
oooo0?ooo`0000006@3oool010000000oooo0?ooo`0000070?ooo`001P3oool01@000000oooo0?oo
o`3oool0000001L0oooo00@000000?ooo`3oool00000c`3oool01@000000oooo0?ooo`3oool00000
01L0oooo00D000000?ooo`3oool0oooo000000070?ooo`001P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`000000d@3oool010000000oooo0?ooo`00000G
0?ooo`050000003oool0oooo0?ooo`0000001`3oool000H0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool000000=<0oooo00@000000?ooo`3oool000005@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool04`3oool200000=D0oooo00<000000?ooo`0000005@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool04@3oool00`000000oooo0000003F0?ooo`8000005@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool04@3oool200000=L0oooo00<000000?ooo`0000004`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool03`3oool200000=T0oooo0P00000C0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0?0?ooo`800000fP3oool200000180oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`050?ooo`001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool0f@3oool200000140oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`001P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo0P00003L0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`001P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo0P00003L0?ooo`80
00003`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00060?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0000003L0?ooo`800000
3`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0000003L0?ooo`8000003`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0000003L0?ooo`030000003oool0
000000d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`001P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool00000g03oool0
0`000000oooo0000000=0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool0
00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo
00000=`0oooo00@000000?ooo`3oool00000303oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00D0oooo00060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool0
10000000oooo0?ooo`00003L0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00L0oooo00D000000?ooo`3oool0oooo0000003L0?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo0000003L0?ooo`05
0000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00D0oooo00060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0=X0oooo00D000000?ooo`3oool0oooo000000090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0fP3oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3J0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00D0
oooo00060?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0=X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01@3oool000H0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0fP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3J
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0=X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool01@3oool000H0oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool00000
00H0oooo00<000000?ooo`3oool0fP3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo
0?ooo`0000003@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0;0?oo
o`040000003oool0oooo000000L0oooo00<000000?ooo`3oool0fP3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?ooo`050?ooo`001P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool0fP3oool0
0`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?oo
o`050?ooo`001P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0000000L0oooo00<00000
0?ooo`3oool0fP3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000h0oooo00<00000
0?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool0303oool2000000P0oooo00<000000?oo
o`3oool0fP3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000h0oooo00<000000?oo
o`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0=/0oooo00<000000?ooo`3oool01@3oool2000000l0oooo00<000000?ooo`3o
ool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0=/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00`0oooo0P0000070?ooo`030000003o
ool0oooo0=/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00H0oooo00060?ooo`030000003oool0oooo00`0oooo00<000000?ooo`0000001P3oool0
0`000000oooo0?ooo`3K0?ooo`030000003oool0oooo00D0oooo0P00000>0?ooo`030000003oool0
oooo00H0oooo00060?ooo`030000003oool0oooo00/0oooo00@000000?ooo`3oool000001P3oool0
0`000000oooo0?ooo`3K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000003@3oool0
0`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo0?ooo`0;0?ooo`040000003oool0oooo
000000H0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
000000d0oooo00<000000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool02`3oool01@00
0000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`000000303oool00`000000oooo0?ooo`060?ooo`001P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`3K0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000
000<0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0=/0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`060?oo
o`001P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`3K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00060?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000=d0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`060?ooo`050000003oool0oooo0?ooo`000000g@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`00
1P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0
oooo0000003M0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00003M0?ooo`050000003oool0oooo0?oo
o`000000203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00003M0?oo
o`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00H0oooo00060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool01000
0000oooo0?ooo`00003M0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`000000g@3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool000000=d0oooo00@000000?ooo`3oool000002`3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool02`3oool200000=d0oooo00<000000?ooo`000000303oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0303oool200000=d0oooo00<000000?ooo`0000003@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0303oool200000=d0oooo00<000000?ooo`0000003@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3K0?ooo`8000003P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool03P3oool200000=`0oooo0P00000?0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0>
0?ooo`800000f`3oool200000100oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`06
0?ooo`001P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo0P00003K0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?oo
o`001P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`00
0000f@3oool200000140oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`00
1P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0140oooo0P00003H0?ooo`800000
4P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool04P3oool00`000000oooo0000003F0?ooo`030000003o
ool0000001<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`001P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo01<0oooo00<000000?ooo`000000e03oool0
0`000000oooo0000000D0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool0
00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0C0?ooo`040000003oool0oooo
00000=80oooo00@000000?ooo`3oool00000503oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00H0oooo00060?ooo`050000003oool0oooo0?ooo`0000005P3oool01@000000oooo0?oo
o`3oool000000=40oooo00<000000?ooo`0000005P3oool01@000000oooo0?ooo`3oool0000000P0
oooo00060?ooo`050000003oool0oooo0?ooo`0000005`3oool01@000000oooo0?ooo`3oool00000
0<l0oooo00@000000?ooo`3oool000005P3oool01@000000oooo0?ooo`3oool0000000P0oooo0006
0?ooo`040000003oool0oooo000001P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`3;0?ooo`050000003oool0oooo0?ooo`0000005P3oool01@000000oooo0?ooo`3oool0000000P0
oooo00060?ooo`040000003oool0oooo000001T0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`390?ooo`050000003oool0oooo0?ooo`000000603oool010000000oooo0?ooo`000008
0?ooo`001P3oool010000000oooo0?ooo`00000I0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0b03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01H0oooo00@00000
0?ooo`3oool00000203oool000H0oooo00<000000?ooo`0000006P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0G
0?ooo`040000003oool0oooo000000P0oooo00060?ooo`030000003oool0000001/0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`340?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0603oool00`000000oooo000000080?ooo`001P3oool00`000000oooo0000000K0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`000000203oool000H0oooo0P00000M0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0`03oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo01X0oooo0P0000080?ooo`001P3oool2000001d0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`2n0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
6P3oool2000000P0oooo00060?ooo`8000007P3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo0;`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0K0?ooo`800000203o
ool000H0oooo0P00000N0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0^`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool01P3oool0
00H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0;X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0M0?ooo`8000001`3oool000H0
oooo0P00000O0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0^03oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01d0oooo0P0000070?ooo`001`3oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0]P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01d0oooo0P0000080?ooo`001`3oool2000001l0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`070?ooo`001`3oool2000001l0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0703oool2000000T0oooo00070?ooo`030000003oool0000001h0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool07@3oool2000000T0oooo00070?ooo`030000003oool0000001l0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`2^0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0703oool00`000000oooo000000090?ooo`00203oool2000001l0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`2/0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
7@3oool00`000000oooo000000090?ooo`00203oool00`000000oooo0000000O0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo01d0oooo0P00000:0?ooo`00203oool00`000000oooo0000000O0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`0000002P3oool000P0oooo00@000000?ooo`3oool000007`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0000000X0oooo00080?ooo`040000003oool0oooo
000001l0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0703oool010000000oooo0?ooo`00000:0?ooo`002@3oool0
10000000oooo0?ooo`00000N0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0Y03o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo00@000000?ooo`3oool00000
2P3oool000T0oooo00@000000?ooo`3oool000007`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo0:80oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L0?ooo`040000
003oool0oooo000000/0oooo00090?ooo`040000003oool0oooo000001l0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool07@3oool010000000oooo0?ooo`00000;0?ooo`002@3oool01@000000oooo0?ooo`3oool00000
01l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2N0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`00000;0?ooo`002@3oool01@00
0000oooo0?ooo`3oool0000001l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2M
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0703oool01@000000oooo0?ooo`3o
ool0000000/0oooo000:0?ooo`050000003oool0oooo0?ooo`0000007`3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo09/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0M0?ooo`050000003oool0oooo0?ooo`0000002`3oool000X0oooo00D000000?ooo`3oool0oooo
0000000O0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0V@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01`0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`00
2P3oool01@000000oooo0?ooo`3oool0000001l0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`2G0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool07@3oool01@000000
oooo0?ooo`3oool0000000`0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool02P3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`002P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`2B0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0900oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0S`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0;0?ooo`002`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00/0
oooo000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0B0?ooo`<00000R`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`002`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool04P3oool2000008T0oooo0P00
000E0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0;0?ooo`00303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01d0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`270?ooo`800000503oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool000`0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0Q@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`00303oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`230?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00`0oooo000<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0800oooo0P00000G0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`00303o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool05@3o
ool2000007l0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0N`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0<0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00d0oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool000d0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01`0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`1c0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00d0oooo000>0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0740oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool03@3oool000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0>0?oo
o`003P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`1/0?ooo`8000007@3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool000h0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0L0?ooo`8000007@3oool00`000000oooo0?ooo`1Z0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00h0oooo000>0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool07@3o
ool2000001d0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`0L0?ooo`8000007`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00h0oooo000?0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool07P3oool2000001`0oooo0P00001W0?ooo`030000003oool0
oooo01d0oooo0P00000N0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool03P3oool0
00l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0P0?ooo`800000703oool00`00
0000oooo0?ooo`1S0?ooo`030000003oool0oooo01`0oooo0P00000P0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool03`3oool000l0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0Q0?ooo`8000006`3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo01/0
oooo0P00000R0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool03`3oool000l0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0S0?ooo`<000006@3oool00`000000oooo
0?ooo`1O0?ooo`030000003oool0oooo01T0oooo0`00000S0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool03`3oool000l0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0V0?ooo`800000603oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo01P0oooo0P00
000V0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool03`3oool00100oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0W0?ooo`8000005`3oool00`000000oooo0?ooo`1J
0?ooo`800000603oool3000002L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0?
0?ooo`00403oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02T0oooo0P00000F0?oo
o`030000003oool0oooo05P0oooo00<000000?ooo`3oool05P3oool2000002X0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0@0?ooo`00403oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo02X0oooo0`00000D0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3o
ool05@3oool2000002/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`00
403oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02d0oooo0P00000C0?ooo`030000
003oool0oooo05@0oooo00<000000?ooo`3oool04`3oool3000002d0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0@0?ooo`00403oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo02l0oooo0P00000B0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool04P3o
ool200000300oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`004@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0300oooo0P00000A0?ooo`800000D@3oool0
0`000000oooo0?ooo`0@0?ooo`<00000<@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0100oooo000A0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0<P3oool30000
0100oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0?0?ooo`800000=03oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo0140oooo000A0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0=03oool2000000l0oooo00<000000?ooo`3oool0B`3oool00`000000
oooo0?ooo`0>0?ooo`800000=@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0140
oooo000A0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0=P3oool2000000h0oooo
00<000000?ooo`3oool0B03oool2000000h0oooo0`00000g0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool04@3oool00140oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0g0?ooo`<00000303oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00`0oooo0P00
000i0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool00140oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0j0?ooo`8000002`3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo00/0oooo0P00000k0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool04@3oool00180oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0l0?oo
o`8000002P3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo00T0oooo0`00000m0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool00180oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0m0?ooo`8000002@3oool00`000000oooo0?ooo`100?ooo`03
0000003oool0oooo00P0oooo0P00000o0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool04P3oool00180oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0o0?ooo`<00000
1`3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo00H0oooo0`0000110?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`110?ooo`8000001P3oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo00D0oooo0P0000130?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04P3o
ool00180oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`130?ooo`8000001@3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo00@0oooo0P0000150?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool0303oool20000
04D0oooo0P0000040?ooo`800000>@3oool00`000000oooo0?ooo`020?ooo`<00000AP3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo00`0
oooo0P0000170?ooo`<000000`3oool00`000000oooo0?ooo`0d0?ooo`8000000`3oool2000004P0
oooo0P00000>0?ooo`030000003oool0oooo01<0oooo000C0?ooo`030000003oool0oooo00h0oooo
0P0000180?ooo`8000000P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00<00000
B03oool2000000030?ooo`000000oooo00d0oooo00<000000?ooo`3oool04`3oool001<0oooo00<0
00000?ooo`3oool0403oool2000004P0oooo0P0000000`3oool000000?ooo`0a0?ooo`040000003o
ool00000000004T0oooo0P00000B0?ooo`030000003oool0oooo01<0oooo000C0?ooo`030000003o
ool0oooo0180oooo0P0000180?ooo`<00000<03oool3000004T0oooo0P00000D0?ooo`030000003o
ool0oooo01<0oooo000D0?ooo`030000003oool0oooo01<0oooo0`0000170?oooc800000B03oool3
000001H0oooo00<000000?ooo`3oool04`3oool001@0oooo00<000000?ooo`3oool05P3oool20000
04L0oooo0`00000W0?ooo`<000000P3oool00`000000oooo0?ooo`140?ooo`800000603oool00`00
0000oooo0?ooo`0D0?ooo`00503oool00`000000oooo0?ooo`0H0?ooo`800000B03oool300000280
oooo0P00001:0?ooo`8000006P3oool00`000000oooo0?ooo`0D0?ooo`00503oool00`000000oooo
0?ooo`0J0?ooo`<00000B03oool3000001`0oooo0`00001:0?ooo`800000703oool00`000000oooo
0?ooo`0D0?ooo`00503oool00`000000oooo0?ooo`0M0?ooo`800000B@3oool2000001L0oooo0`00
001:0?ooo`<000007P3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0N
0?ooo`800000B@3oool300000140oooo0`00001;0?ooo`8000008@3oool00`000000oooo0?ooo`0D
0?ooo`00503oool200000280oooo0P00001:0?ooo`<00000303oool2000004`0oooo0P00000R0?oo
o`030000003oool0oooo01D0oooo000E0?ooo`<000008P3oool3000004X0oooo0P0000070?ooo`<0
0000C03oool2000002@0oooo00<000000?ooo`3oool05@3oool001P0oooo1000000Q0?ooo`800000
BP3oool3000000040?ooo`0000000000000004`0oooo0`00000T0?ooo`<000005`3oool001`0oooo
1@00000N0?ooo`800000B@3oool5000004/0oooo0P00000S0?ooo`@000000P3oool00`000000oooo
0?ooo`0E0?ooo`008@3oool4000001`0oooo0`0000140?ooo`8000001@3oool2000004L0oooo0P00
000P0?ooo`D000007P3oool002D0oooo1@00000J0?ooo`800000?`3oool3000000T0oooo0`000012
0?ooo`8000007@3oool5000002<0oooo000Z0?ooo`@00000603oool2000003X0oooo0`00000?0?oo
o`800000?P3oool2000001/0oooo1000000X0?ooo`00;P3oool5000001D0oooo0P00000e0?ooo`<0
0000503oool3000003P0oooo0`00000H0?ooo`D00000;03oool003<0oooo1000000C0?ooo`<00000
<03oool2000001X0oooo0`00000c0?ooo`8000005`3oool400000340oooo000g0?ooo`D000004@3o
ool2000002/0oooo0`00000O0?ooo`800000;`3oool2000001@0oooo1@00000e0?ooo`00?03oool5
000000h0oooo0P00000V0?ooo`<00000903oool3000002X0oooo0P00000A0?ooo`D00000>P3oool0
0440oooo1000000<0?ooo`<00000803oool3000002X0oooo0`00000T0?ooo`<000003`3oool40000
03l0oooo00150?ooo`D000002P3oool2000001`0oooo0P00000`0?ooo`800000803oool2000000d0
oooo1@0000130?ooo`00BP3oool4000000P0oooo0P00000G0?ooo`<00000=03oool3000001/0oooo
0P00000;0?ooo`@00000B03oool004h0oooo1@0000050?ooo`8000004P3oool3000003X0oooo0`00
000F0?ooo`800000203oool5000004`0oooo001C0?ooo`@000000`3oool3000000`0oooo0`000010
0?ooo`8000004@3oool3000000H0oooo1000001A0?ooo`00E`3oool5000000030?ooo`0000000000
00P0oooo0P0000150?ooo`<00000303oool2000000@0oooo1@00001E0?ooo`00G03oool5000000<0
oooo0`00001:0?ooo`<000001`3oool2000000030?ooo`000000000000<00000FP3oool00600oooo
;@00000W0?ooo`80000000<0oooo0000000000001@00001O0?ooo`00H`3oool00`000000oooo0?oo
o`0W0?ooobd00000H`3oool00?l0oooo7P3oool00?l0oooo7P3oool00?l0oooo7P3oool00?l0oooo
7P3oool00?l0oooo7P3oool00?l0oooo7P3oool00001\
\>"],
  ImageRangeCache->{{{81, 365.438}, {370.188, 83.25}} -> {-1.63205, \
-0.440684, 0.00731857, 0.00731857}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  " may produce slightly different output on different platforms, due to \
floating point differences."
}], "Text"],

Cell[CellGroupData[{

Cell["Graph Drawing Algorithms", "Subsection"],

Cell["\<\
Graphs are often used to encapsulate the relationship between \
items. Graph drawing enables visualization of these relationships. The \
usefulness of the visual representation depends upon whether the drawing is \
aesthetic. While there are no strict criteria for aesthetic drawing, it is \
generally agreed that such a drawing has minimal edge crossing and even \
spacing between vertices. This problem has been studied extensively in the \
literature, and many approaches have been proposed. Two popular straight-edge \
drawing algorithms, the spring model and spring-electrical model, work by \
minimizing the energy of physical models of the graph. The high-dimensional \
embedding method, on the other hand, is quite different.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Spring model", "Subsubsection",
  CellTags->"spring model"],

Cell["\<\
The spring model assigns force between each pair of nodes. When two \
nodes are too close together, a repelling force comes into effect. When two \
nodes are too far apart, they are subject to an attractive force. This \
scenario can be illustrated by linking the vertices with \
springs\[LongDash]hence the name \[OpenCurlyDoubleQuote]spring model\
\[CloseCurlyDoubleQuote] (or \[OpenCurlyDoubleQuote]spring embedding method\
\[CloseCurlyDoubleQuote]). \
\>", "Text"],

Cell["\<\
This algorithm works by adding springs to all edges and adding \
looser springs to all vertex pairs that are not adjacent. Thus, in two \
dimensions, the total energy of the system is \
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Sum]\+\(i = 
              1\)\%\(\[LeftBracketingBar]V\[RightBracketingBar] - 1\)\), 
        RowBox[{\(\[Sum]\+\(j = 
                i + 1\)\%\(\[LeftBracketingBar]V\[RightBracketingBar]\)\), 
          RowBox[{\(k\_ij\), "  ", 
            SuperscriptBox[
              RowBox[{"(", " ", 
                RowBox[{"||", \(x\_i - x\_j\), \( || \^2\), 
                  RowBox[{"-", " ", 
                    SubscriptBox["l", 
                      StyleBox["ij",
                        FontSlant->"Italic"]]}]}], " ", ")"}], "2"]}]}]}], 
      TraditionalForm]], "Text"],

Cell[TextData[{
  "Here, ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  " are the coordinate vectors of nodes ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  ", and",
  Cell[BoxData[
      \(TraditionalForm\`\(\(||\)\(x\_i - x\_j\)\(||\)\)\)]],
  " is the Euclidean distance between them. ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["l", 
          StyleBox["ij",
            FontSlant->"Italic"]], TraditionalForm]]],
  " is the natural length of the spring between vertex ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " and vertex ",
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  ", and can be chosen as the graph distance between ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  ". The parameters ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["k", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "=", " ", 
          RowBox[{
            RowBox[{"R", "/", 
              SuperscriptBox[
                SubscriptBox["l", 
                  StyleBox["ij",
                    FontSlant->"Italic"]], "2"]}], " "}]}], 
        TraditionalForm]]],
  "are the strength of the springs, where ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is a parameter representing the strength of the strings.",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(|\)\(V\)\(|\)\)\)\)]],
  " is the number of vertices. "
}], "Text"],

Cell["\<\
The layout of the graph vertices is calculated by minimizing this \
energy function. One way to minimize the energy function is by iteratively \
moving each of the vertices along the direction of the spring force until an \
approximate equilibrium is reached. Multilevel techniques are used to \
overcome local minima.\
\>", "Text"],

Cell[TextData[{
  "The spring model works well for problems like regular grid graphs, in \
which it is possible to lay out the graph so that physical distances between \
vertices are proportional to the graph distances. This model does, however, \
require more memory and CPU time. To reduce its ",
  Cell[BoxData[
      \(TraditionalForm\`O(\(|\)\(V\)\( | \^2\))\)]],
  " complexity, vertices that are far apart are ignored in the calculation of \
the force and energy. See the ",
  ButtonBox["method option",
    ButtonData:>"method_option_forced_directed",
    ButtonStyle->"Hyperlink"],
  " ",
  StyleBox["InferentialDistance", "MR"],
  " for more information."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[GridGraph[20, 20], 
        Method \[Rule] "\<SpringModel\>"];\)\)], "Input",
  CellLabel->"In[10]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476192 0.5 0.476192 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.96361 .03404 m
.96714 .0842 L
s
.96361 .03404 m
.91344 .03077 L
s
.96714 .0842 m
.97056 .13399 L
s
.96714 .0842 m
.91578 .08212 L
s
.97056 .13399 m
.97248 .18199 L
s
.97056 .13399 m
.91811 .13293 L
s
.97248 .18199 m
.97366 .22935 L
s
.97248 .18199 m
.91945 .18179 L
s
.97366 .22935 m
.97444 .27852 L
s
.97366 .22935 m
.92058 .2295 L
s
.97444 .27852 m
.97502 .32741 L
s
.97444 .27852 m
.92139 .27871 L
s
.97502 .32741 m
.97548 .37627 L
s
.97502 .32741 m
.92202 .32758 L
s
.97548 .37627 m
.97582 .42524 L
s
.97548 .37627 m
.92252 .37644 L
s
.97582 .42524 m
.97604 .47429 L
s
.97582 .42524 m
.92286 .42543 L
s
.97604 .47429 m
.97616 .52331 L
s
.97604 .47429 m
.92309 .47444 L
s
.97616 .52331 m
.97619 .57236 L
s
.97616 .52331 m
.92322 .52343 L
s
.97619 .57236 m
.9761 .62133 L
s
.97619 .57236 m
.92323 .57244 L
s
.9761 .62133 m
.97589 .67019 L
s
.9761 .62133 m
.92314 .62143 L
s
.97589 .67019 m
.97555 .71909 L
s
.97589 .67019 m
.92288 .67029 L
s
.97555 .71909 m
.97502 .76826 L
s
.97555 .71909 m
.9225 .71917 L
s
.97502 .76826 m
.97408 .81562 L
s
.97502 .76826 m
.92194 .76837 L
s
.97408 .81562 m
.9724 .86364 L
s
.97408 .81562 m
.92105 .81608 L
s
.9724 .86364 m
.96923 .91344 L
s
.9724 .86364 m
.91995 .86496 L
s
.96923 .91344 m
.96596 .96361 L
s
.96923 .91344 m
.91788 .91578 L
s
.96596 .96361 m
.9158 .96714 L
s
.91344 .03077 m
.91578 .08212 L
s
.91344 .03077 m
.86364 .0276 L
s
.91578 .08212 m
.91811 .13293 L
s
.91578 .08212 m
.86496 .08005 L
s
.91811 .13293 m
.91945 .18179 L
s
.91811 .13293 m
.86575 .1324 L
s
.91945 .18179 m
.92058 .2295 L
s
.91945 .18179 m
.86699 .18123 L
s
.92058 .2295 m
.92139 .27871 L
s
.92058 .2295 m
.868 .22915 L
s
.92139 .27871 m
.92202 .32758 L
s
.92139 .27871 m
.86877 .27856 L
s
.92202 .32758 m
.92252 .37644 L
s
.92202 .32758 m
.86939 .32757 L
s
.92252 .37644 m
.92286 .42543 L
s
.92252 .37644 m
.86986 .3765 L
s
.92286 .42543 m
.92309 .47444 L
s
.92286 .42543 m
.87021 .42552 L
s
.92309 .47444 m
.92322 .52343 L
s
.92309 .47444 m
.87044 .47456 L
s
.92322 .52343 m
.92323 .57244 L
s
.92322 .52343 m
.87056 .52357 L
s
.92323 .57244 m
.92314 .62143 L
s
.92323 .57244 m
.87058 .57261 L
s
.92314 .62143 m
.92288 .67029 L
s
.92314 .62143 m
.87048 .62163 L
s
.92288 .67029 m
.9225 .71917 L
s
.92288 .67029 m
.87026 .67056 L
s
.9225 .71917 m
.92194 .76837 L
s
.9225 .71917 m
.86988 .71957 L
s
.92194 .76837 m
.92105 .81608 L
s
.92194 .76837 m
.86936 .76899 L
s
.92105 .81608 m
.91995 .86496 L
s
.92105 .81608 m
.8686 .81691 L
s
.91995 .86496 m
.91788 .91578 L
s
.91995 .86496 m
.8676 .86575 L
s
.91788 .91578 m
.9158 .96714 L
s
.91788 .91578 m
.86707 .91811 L
s
.9158 .96714 m
.86602 .97056 L
s
.86364 .0276 m
.86496 .08005 L
s
.86364 .0276 m
.81562 .02592 L
s
.86496 .08005 m
.86575 .1324 L
s
.86496 .08005 m
.81608 .07895 L
s
.86575 .1324 m
.86699 .18123 L
s
.86575 .1324 m
.81691 .1314 L
s
.86699 .18123 m
.868 .22915 L
s
.86699 .18123 m
.81793 .18046 L
s
.868 .22915 m
.86877 .27856 L
s
.868 .22915 m
.81877 .22867 L
s
.86877 .27856 m
.86939 .32757 L
s
.86877 .27856 m
.81944 .27831 L
s
.86939 .32757 m
.86986 .3765 L
s
.86939 .32757 m
.82 .32742 L
s
.86986 .3765 m
.87021 .42552 L
s
.86986 .3765 m
.82044 .37644 L
s
.87021 .42552 m
.87044 .47456 L
s
.87021 .42552 m
.82076 .42555 L
s
.87044 .47456 m
.87056 .52357 L
s
.87044 .47456 m
.82098 .47465 L
s
.87056 .52357 m
.87058 .57261 L
s
.87056 .52357 m
.82111 .52373 L
s
.87058 .57261 m
.87048 .62163 L
s
.87058 .57261 m
.82113 .57283 L
s
.87048 .62163 m
.87026 .67056 L
s
.87048 .62163 m
.82106 .62194 L
s
.87026 .67056 m
.86988 .71957 L
s
.87026 .67056 m
.82087 .67097 L
s
.86988 .71957 m
.86936 .76899 L
s
.86988 .71957 m
.82055 .72008 L
s
.86936 .76899 m
.8686 .81691 L
s
.86936 .76899 m
.82013 .76972 L
s
.8686 .81691 m
.8676 .86575 L
s
.8686 .81691 m
.81954 .81793 L
s
.8676 .86575 m
.86707 .91811 L
s
.8676 .86575 m
.81877 .86699 L
s
.86707 .91811 m
.86602 .97056 L
s
.86707 .91811 m
.81821 .91945 L
s
.86602 .97056 m
.81801 .97248 L
s
.81562 .02592 m
.81608 .07895 L
s
.81562 .02592 m
.76826 .02498 L
s
.81608 .07895 m
.81691 .1314 L
s
.81608 .07895 m
.76837 .07806 L
s
.81691 .1314 m
.81793 .18046 L
s
.81691 .1314 m
.76899 .13064 L
s
.81793 .18046 m
.81877 .22867 L
s
.81793 .18046 m
.76972 .17987 L
s
.81877 .22867 m
.81944 .27831 L
s
.81877 .22867 m
.77037 .22827 L
s
.81944 .27831 m
.82 .32742 L
s
.81944 .27831 m
.77096 .27801 L
s
.82 .32742 m
.82044 .37644 L
s
.82 .32742 m
.77145 .32723 L
s
.82044 .37644 m
.82076 .42555 L
s
.82044 .37644 m
.77185 .37636 L
s
.82076 .42555 m
.82098 .47465 L
s
.82076 .42555 m
.77215 .42555 L
s
.82098 .47465 m
.82111 .52373 L
s
.82098 .47465 m
.77236 .47474 L
s
.82111 .52373 m
.82113 .57283 L
s
.82111 .52373 m
.77248 .52389 L
s
.82113 .57283 m
.82106 .62194 L
s
.82113 .57283 m
.77252 .57307 L
s
.82106 .62194 m
.82087 .67097 L
s
.82106 .62194 m
.77247 .62227 L
s
.82087 .67097 m
.82055 .72008 L
s
.82087 .67097 m
.77232 .67139 L
s
.82055 .72008 m
.82013 .76972 L
s
.82055 .72008 m
.77208 .72062 L
s
.82013 .76972 m
.81954 .81793 L
s
.82013 .76972 m
.77173 .77037 L
s
.81954 .81793 m
.81877 .86699 L
s
.81954 .81793 m
.77133 .81877 L
s
.81877 .86699 m
.81821 .91945 L
s
.81877 .86699 m
.77085 .868 L
s
.81821 .91945 m
.81801 .97248 L
s
.81821 .91945 m
.7705 .92058 L
s
.81801 .97248 m
.77065 .97366 L
s
.76826 .02498 m
.76837 .07806 L
s
.76826 .02498 m
.71909 .02445 L
s
.76837 .07806 m
.76899 .13064 L
s
.76837 .07806 m
.71917 .0775 L
s
.76899 .13064 m
.76972 .17987 L
s
.76899 .13064 m
.71957 .13012 L
s
.76972 .17987 m
.77037 .22827 L
s
.76972 .17987 m
.72008 .17945 L
s
.77037 .22827 m
.77096 .27801 L
s
.77037 .22827 m
.72062 .22792 L
s
.77096 .27801 m
.77145 .32723 L
s
.77096 .27801 m
.72112 .27776 L
s
.77145 .32723 m
.77185 .37636 L
s
.77145 .32723 m
.72154 .32708 L
s
.77185 .37636 m
.77215 .42555 L
s
.77185 .37636 m
.72188 .3763 L
s
.77215 .42555 m
.77236 .47474 L
s
.77215 .42555 m
.72215 .42557 L
s
.77236 .47474 m
.77248 .52389 L
s
.77236 .47474 m
.72235 .47483 L
s
.77248 .52389 m
.77252 .57307 L
s
.77248 .52389 m
.72247 .52405 L
s
.77252 .57307 m
.77247 .62227 L
s
.77252 .57307 m
.72252 .57331 L
s
.77247 .62227 m
.77232 .67139 L
s
.77247 .62227 m
.7225 .62258 L
s
.77232 .67139 m
.77208 .72062 L
s
.77232 .67139 m
.72241 .67179 L
s
.77208 .72062 m
.77173 .77037 L
s
.77208 .72062 m
.72224 .72112 L
s
.77173 .77037 m
.77133 .81877 L
s
.77173 .77037 m
.72199 .77096 L
s
.77133 .81877 m
.77085 .868 L
s
.77133 .81877 m
.72169 .81944 L
s
.77085 .868 m
.7705 .92058 L
s
.77085 .868 m
.72144 .86877 L
s
.7705 .92058 m
.77065 .97366 L
s
.7705 .92058 m
.72129 .92139 L
s
.77065 .97366 m
.72148 .97444 L
s
.71909 .02445 m
.71917 .0775 L
s
.71909 .02445 m
.67019 .02411 L
s
.71917 .0775 m
.71957 .13012 L
s
.71917 .0775 m
.67029 .07712 L
s
.71957 .13012 m
.72008 .17945 L
s
.71957 .13012 m
.67056 .12974 L
s
.72008 .17945 m
.72062 .22792 L
s
.72008 .17945 m
.67097 .17913 L
s
.72062 .22792 m
.72112 .27776 L
s
.72062 .22792 m
.67139 .22768 L
s
.72112 .27776 m
.72154 .32708 L
s
.72112 .27776 m
.67179 .27759 L
s
.72154 .32708 m
.72188 .3763 L
s
.72154 .32708 m
.67215 .32698 L
s
.72188 .3763 m
.72215 .42557 L
s
.72188 .3763 m
.67244 .37626 L
s
.72215 .42557 m
.72235 .47483 L
s
.72215 .42557 m
.67268 .4256 L
s
.72235 .47483 m
.72247 .52405 L
s
.72235 .47483 m
.67286 .47492 L
s
.72247 .52405 m
.72252 .57331 L
s
.72247 .52405 m
.67298 .52421 L
s
.72252 .57331 m
.7225 .62258 L
s
.72252 .57331 m
.67305 .57353 L
s
.7225 .62258 m
.72241 .67179 L
s
.7225 .62258 m
.67306 .62286 L
s
.72241 .67179 m
.72224 .72112 L
s
.72241 .67179 m
.67302 .67214 L
s
.72224 .72112 m
.72199 .77096 L
s
.72224 .72112 m
.67291 .72154 L
s
.72199 .77096 m
.72169 .81944 L
s
.72199 .77096 m
.67277 .77145 L
s
.72169 .81944 m
.72144 .86877 L
s
.72169 .81944 m
.67258 .82 L
s
.72144 .86877 m
.72129 .92139 L
s
.72144 .86877 m
.67243 .86939 L
s
.72129 .92139 m
.72148 .97444 L
s
.72129 .92139 m
.67242 .92202 L
s
.72148 .97444 m
.67259 .97502 L
s
.67019 .02411 m
.67029 .07712 L
s
.67019 .02411 m
.62133 .0239 L
s
.67029 .07712 m
.67056 .12974 L
s
.67029 .07712 m
.62143 .07686 L
s
.67056 .12974 m
.67097 .17913 L
s
.67056 .12974 m
.62163 .12952 L
s
.67097 .17913 m
.67139 .22768 L
s
.67097 .17913 m
.62194 .17894 L
s
.67139 .22768 m
.67179 .27759 L
s
.67139 .22768 m
.62227 .22753 L
s
.67179 .27759 m
.67215 .32698 L
s
.67179 .27759 m
.62258 .2775 L
s
.67215 .32698 m
.67244 .37626 L
s
.67215 .32698 m
.62286 .32694 L
s
.67244 .37626 m
.67268 .4256 L
s
.67244 .37626 m
.62311 .37627 L
s
.67268 .4256 m
.67286 .47492 L
s
.67268 .4256 m
.62331 .42565 L
s
.67286 .47492 m
.67298 .52421 L
s
.67286 .47492 m
.62348 .47502 L
s
.67298 .52421 m
.67305 .57353 L
s
.67298 .52421 m
.6236 .52436 L
s
.67305 .57353 m
.67306 .62286 L
s
.67305 .57353 m
.62369 .57372 L
s
.67306 .62286 m
.67302 .67214 L
s
.67306 .62286 m
.62373 .62311 L
s
.67302 .67214 m
.67291 .72154 L
s
.67302 .67214 m
.62374 .67244 L
s
.67291 .72154 m
.67277 .77145 L
s
.67291 .72154 m
.6237 .72188 L
s
.67277 .77145 m
.67258 .82 L
s
.67277 .77145 m
.62364 .77185 L
s
.67258 .82 m
.67243 .86939 L
s
.67258 .82 m
.62356 .82044 L
s
.67243 .86939 m
.67242 .92202 L
s
.67243 .86939 m
.6235 .86986 L
s
.67242 .92202 m
.67259 .97502 L
s
.67242 .92202 m
.62356 .92252 L
s
.67259 .97502 m
.62374 .97548 L
s
.62133 .0239 m
.62143 .07686 L
s
.62133 .0239 m
.57236 .02381 L
s
.62143 .07686 m
.62163 .12952 L
s
.62143 .07686 m
.57244 .07677 L
s
.62163 .12952 m
.62194 .17894 L
s
.62163 .12952 m
.57261 .12942 L
s
.62194 .17894 m
.62227 .22753 L
s
.62194 .17894 m
.57283 .17887 L
s
.62227 .22753 m
.62258 .2775 L
s
.62227 .22753 m
.57307 .22748 L
s
.62258 .2775 m
.62286 .32694 L
s
.62258 .2775 m
.57331 .27748 L
s
.62286 .32694 m
.62311 .37627 L
s
.62286 .32694 m
.57353 .32695 L
s
.62311 .37627 m
.62331 .42565 L
s
.62311 .37627 m
.57372 .37631 L
s
.62331 .42565 m
.62348 .47502 L
s
.62331 .42565 m
.5739 .42573 L
s
.62348 .47502 m
.6236 .52436 L
s
.62348 .47502 m
.57405 .47513 L
s
.6236 .52436 m
.62369 .57372 L
s
.6236 .52436 m
.57417 .5245 L
s
.62369 .57372 m
.62373 .62311 L
s
.62369 .57372 m
.57427 .5739 L
s
.62373 .62311 m
.62374 .67244 L
s
.62373 .62311 m
.57435 .62331 L
s
.62374 .67244 m
.6237 .72188 L
s
.62374 .67244 m
.5744 .67268 L
s
.6237 .72188 m
.62364 .77185 L
s
.6237 .72188 m
.57443 .72215 L
s
.62364 .77185 m
.62356 .82044 L
s
.62364 .77185 m
.57445 .77214 L
s
.62356 .82044 m
.6235 .86986 L
s
.62356 .82044 m
.57445 .82076 L
s
.6235 .86986 m
.62356 .92252 L
s
.6235 .86986 m
.57448 .87021 L
s
.62356 .92252 m
.62374 .97548 L
s
.62356 .92252 m
.57457 .92286 L
s
.62374 .97548 m
.57476 .97582 L
s
.57236 .02381 m
.57244 .07677 L
s
.57236 .02381 m
.52331 .02384 L
s
.57244 .07677 m
.57261 .12942 L
s
.57244 .07677 m
.52343 .07678 L
s
.57261 .12942 m
.57283 .17887 L
s
.57261 .12942 m
.52357 .12944 L
s
.57283 .17887 m
.57307 .22748 L
s
.57283 .17887 m
.52373 .17889 L
s
.57307 .22748 m
.57331 .27748 L
s
.57307 .22748 m
.52389 .22752 L
s
.57331 .27748 m
.57353 .32695 L
s
.57331 .27748 m
.52405 .27753 L
s
.57353 .32695 m
.57372 .37631 L
s
.57353 .32695 m
.52421 .32702 L
s
.57372 .37631 m
.5739 .42573 L
s
.57372 .37631 m
.52436 .3764 L
s
.5739 .42573 m
.57405 .47513 L
s
.5739 .42573 m
.5245 .42583 L
s
.57405 .47513 m
.57417 .5245 L
s
.57405 .47513 m
.52463 .47525 L
s
.57417 .5245 m
.57427 .5739 L
s
.57417 .5245 m
.52475 .52463 L
s
.57427 .5739 m
.57435 .62331 L
s
.57427 .5739 m
.52487 .57405 L
s
.57435 .62331 m
.5744 .67268 L
s
.57435 .62331 m
.52498 .62348 L
s
.5744 .67268 m
.57443 .72215 L
s
.5744 .67268 m
.52508 .67286 L
s
.57443 .72215 m
.57445 .77214 L
s
.57443 .72215 m
.52517 .72235 L
s
.57445 .77214 m
.57445 .82076 L
s
.57445 .77214 m
.52526 .77235 L
s
.57445 .82076 m
.57448 .87021 L
s
.57445 .82076 m
.52535 .82098 L
s
.57448 .87021 m
.57457 .92286 L
s
.57448 .87021 m
.52544 .87044 L
s
.57457 .92286 m
.57476 .97582 L
s
.57457 .92286 m
.52556 .92309 L
s
.57476 .97582 m
.52571 .97604 L
s
.52331 .02384 m
.52343 .07678 L
s
.52331 .02384 m
.47428 .02396 L
s
.52343 .07678 m
.52357 .12944 L
s
.52343 .07678 m
.47444 .07691 L
s
.52357 .12944 m
.52373 .17889 L
s
.52357 .12944 m
.47456 .12956 L
s
.52373 .17889 m
.52389 .22752 L
s
.52373 .17889 m
.47465 .17902 L
s
.52389 .22752 m
.52405 .27753 L
s
.52389 .22752 m
.47474 .22764 L
s
.52405 .27753 m
.52421 .32702 L
s
.52405 .27753 m
.47483 .27765 L
s
.52421 .32702 m
.52436 .3764 L
s
.52421 .32702 m
.47492 .32714 L
s
.52436 .3764 m
.5245 .42583 L
s
.52436 .3764 m
.47502 .37652 L
s
.5245 .42583 m
.52463 .47525 L
s
.5245 .42583 m
.47513 .42595 L
s
.52463 .47525 m
.52475 .52463 L
s
.52463 .47525 m
.47525 .47537 L
s
.52475 .52463 m
.52487 .57405 L
s
.52475 .52463 m
.47537 .52475 L
s
.52487 .57405 m
.52498 .62348 L
s
.52487 .57405 m
.4755 .57417 L
s
.52498 .62348 m
.52508 .67286 L
s
.52498 .62348 m
.47564 .6236 L
s
.52508 .67286 m
.52517 .72235 L
s
.52508 .67286 m
.47579 .67298 L
s
.52517 .72235 m
.52526 .77235 L
s
.52517 .72235 m
.47595 .72247 L
s
.52526 .77235 m
.52535 .82098 L
s
.52526 .77235 m
.47611 .77248 L
s
.52535 .82098 m
.52544 .87044 L
s
.52535 .82098 m
.47627 .82111 L
s
.52544 .87044 m
.52556 .92309 L
s
.52544 .87044 m
.47643 .87056 L
s
.52556 .92309 m
.52571 .97604 L
s
.52556 .92309 m
.47657 .92322 L
s
.52571 .97604 m
.47669 .97616 L
s
.47428 .02396 m
.47444 .07691 L
s
.47428 .02396 m
.42524 .02418 L
s
.47444 .07691 m
.47456 .12956 L
s
.47444 .07691 m
.42543 .07714 L
s
.47456 .12956 m
.47465 .17902 L
s
.47456 .12956 m
.42552 .12979 L
s
.47465 .17902 m
.47474 .22764 L
s
.47465 .17902 m
.42555 .17924 L
s
.47474 .22764 m
.47483 .27765 L
s
.47474 .22764 m
.42555 .22786 L
s
.47483 .27765 m
.47492 .32714 L
s
.47483 .27765 m
.42557 .27785 L
s
.47492 .32714 m
.47502 .37652 L
s
.47492 .32714 m
.4256 .32732 L
s
.47502 .37652 m
.47513 .42595 L
s
.47502 .37652 m
.42565 .37669 L
s
.47513 .42595 m
.47525 .47537 L
s
.47513 .42595 m
.42573 .4261 L
s
.47525 .47537 m
.47537 .52475 L
s
.47525 .47537 m
.42583 .4755 L
s
.47537 .52475 m
.4755 .57417 L
s
.47537 .52475 m
.42595 .52487 L
s
.4755 .57417 m
.47564 .6236 L
s
.4755 .57417 m
.4261 .57427 L
s
.47564 .6236 m
.47579 .67298 L
s
.47564 .6236 m
.42628 .62369 L
s
.47579 .67298 m
.47595 .72247 L
s
.47579 .67298 m
.42647 .67305 L
s
.47595 .72247 m
.47611 .77248 L
s
.47595 .72247 m
.42669 .72252 L
s
.47611 .77248 m
.47627 .82111 L
s
.47611 .77248 m
.42693 .77252 L
s
.47627 .82111 m
.47643 .87056 L
s
.47627 .82111 m
.42717 .82113 L
s
.47643 .87056 m
.47657 .92322 L
s
.47643 .87056 m
.42739 .87058 L
s
.47657 .92322 m
.47669 .97616 L
s
.47657 .92322 m
.42756 .92323 L
s
.47669 .97616 m
.42764 .97619 L
s
.42524 .02418 m
.42543 .07714 L
s
.42524 .02418 m
.37626 .02452 L
s
.42543 .07714 m
.42552 .12979 L
s
.42543 .07714 m
.37644 .07748 L
s
.42552 .12979 m
.42555 .17924 L
s
.42552 .12979 m
.3765 .13014 L
s
.42555 .17924 m
.42555 .22786 L
s
.42555 .17924 m
.37644 .17956 L
s
.42555 .22786 m
.42557 .27785 L
s
.42555 .22786 m
.37636 .22815 L
s
.42557 .27785 m
.4256 .32732 L
s
.42557 .27785 m
.3763 .27812 L
s
.4256 .32732 m
.42565 .37669 L
s
.4256 .32732 m
.37626 .32756 L
s
.42565 .37669 m
.42573 .4261 L
s
.42565 .37669 m
.37627 .37689 L
s
.42573 .4261 m
.42583 .4755 L
s
.42573 .4261 m
.37631 .42628 L
s
.42583 .4755 m
.42595 .52487 L
s
.42583 .4755 m
.3764 .47564 L
s
.42595 .52487 m
.4261 .57427 L
s
.42595 .52487 m
.37652 .52498 L
s
.4261 .57427 m
.42628 .62369 L
s
.4261 .57427 m
.37669 .57435 L
s
.42628 .62369 m
.42647 .67305 L
s
.42628 .62369 m
.37689 .62373 L
s
.42647 .67305 m
.42669 .72252 L
s
.42647 .67305 m
.37714 .67306 L
s
.42669 .72252 m
.42693 .77252 L
s
.42669 .72252 m
.37742 .7225 L
s
.42693 .77252 m
.42717 .82113 L
s
.42693 .77252 m
.37773 .77247 L
s
.42717 .82113 m
.42739 .87058 L
s
.42717 .82113 m
.37806 .82106 L
s
.42739 .87058 m
.42756 .92323 L
s
.42739 .87058 m
.37837 .87048 L
s
.42756 .92323 m
.42764 .97619 L
s
.42756 .92323 m
.37857 .92314 L
s
.42764 .97619 m
.37867 .9761 L
s
.37626 .02452 m
.37644 .07748 L
s
.37626 .02452 m
.32741 .02498 L
s
.37644 .07748 m
.3765 .13014 L
s
.37644 .07748 m
.32758 .07798 L
s
.3765 .13014 m
.37644 .17956 L
s
.3765 .13014 m
.32757 .13061 L
s
.37644 .17956 m
.37636 .22815 L
s
.37644 .17956 m
.32742 .18 L
s
.37636 .22815 m
.3763 .27812 L
s
.37636 .22815 m
.32723 .22855 L
s
.3763 .27812 m
.37626 .32756 L
s
.3763 .27812 m
.32709 .27846 L
s
.37626 .32756 m
.37627 .37689 L
s
.37626 .32756 m
.32698 .32785 L
s
.37627 .37689 m
.37631 .42628 L
s
.37627 .37689 m
.32694 .37714 L
s
.37631 .42628 m
.3764 .47564 L
s
.37631 .42628 m
.32695 .42647 L
s
.3764 .47564 m
.37652 .52498 L
s
.3764 .47564 m
.32702 .47579 L
s
.37652 .52498 m
.37669 .57435 L
s
.37652 .52498 m
.32714 .52508 L
s
.37669 .57435 m
.37689 .62373 L
s
.37669 .57435 m
.32732 .5744 L
s
.37689 .62373 m
.37714 .67306 L
s
.37689 .62373 m
.32756 .62374 L
s
.37714 .67306 m
.37742 .7225 L
s
.37714 .67306 m
.32785 .67302 L
s
.37742 .7225 m
.37773 .77247 L
s
.37742 .7225 m
.32821 .72241 L
s
.37773 .77247 m
.37806 .82106 L
s
.37773 .77247 m
.32861 .77232 L
s
.37806 .82106 m
.37837 .87048 L
s
.37806 .82106 m
.32903 .82087 L
s
.37837 .87048 m
.37857 .92314 L
s
.37837 .87048 m
.32944 .87026 L
s
.37857 .92314 m
.37867 .9761 L
s
.37857 .92314 m
.32971 .92288 L
s
.37867 .9761 m
.32981 .97589 L
s
.32741 .02498 m
.32758 .07798 L
s
.32741 .02498 m
.27852 .02556 L
s
.32758 .07798 m
.32757 .13061 L
s
.32758 .07798 m
.27871 .07861 L
s
.32757 .13061 m
.32742 .18 L
s
.32757 .13061 m
.27856 .13123 L
s
.32742 .18 m
.32723 .22855 L
s
.32742 .18 m
.27831 .18056 L
s
.32723 .22855 m
.32709 .27846 L
s
.32723 .22855 m
.27801 .22904 L
s
.32709 .27846 m
.32698 .32785 L
s
.32709 .27846 m
.27776 .27888 L
s
.32698 .32785 m
.32694 .37714 L
s
.32698 .32785 m
.27759 .32821 L
s
.32694 .37714 m
.32695 .42647 L
s
.32694 .37714 m
.2775 .37742 L
s
.32695 .42647 m
.32702 .47579 L
s
.32695 .42647 m
.27748 .42669 L
s
.32702 .47579 m
.32714 .52508 L
s
.32702 .47579 m
.27753 .47595 L
s
.32714 .52508 m
.32732 .5744 L
s
.32714 .52508 m
.27765 .52517 L
s
.32732 .5744 m
.32756 .62374 L
s
.32732 .5744 m
.27785 .57443 L
s
.32756 .62374 m
.32785 .67302 L
s
.32756 .62374 m
.27812 .6237 L
s
.32785 .67302 m
.32821 .72241 L
s
.32785 .67302 m
.27846 .67292 L
s
.32821 .72241 m
.32861 .77232 L
s
.32821 .72241 m
.27888 .72224 L
s
.32861 .77232 m
.32903 .82087 L
s
.32861 .77232 m
.27938 .77208 L
s
.32903 .82087 m
.32944 .87026 L
s
.32903 .82087 m
.27992 .82055 L
s
.32944 .87026 m
.32971 .92288 L
s
.32944 .87026 m
.28043 .86988 L
s
.32971 .92288 m
.32981 .97589 L
s
.32971 .92288 m
.28084 .9225 L
s
.32981 .97589 m
.28091 .97555 L
s
.27852 .02556 m
.27871 .07861 L
s
.27852 .02556 m
.22935 .02634 L
s
.27871 .07861 m
.27856 .13123 L
s
.27871 .07861 m
.2295 .07942 L
s
.27856 .13123 m
.27831 .18056 L
s
.27856 .13123 m
.22915 .132 L
s
.27831 .18056 m
.27801 .22904 L
s
.27831 .18056 m
.22867 .18123 L
s
.27801 .22904 m
.27776 .27888 L
s
.27801 .22904 m
.22827 .22963 L
s
.27776 .27888 m
.27759 .32821 L
s
.27776 .27888 m
.22792 .27938 L
s
.27759 .32821 m
.2775 .37742 L
s
.27759 .32821 m
.22768 .32861 L
s
.2775 .37742 m
.27748 .42669 L
s
.2775 .37742 m
.22753 .37773 L
s
.27748 .42669 m
.27753 .47595 L
s
.27748 .42669 m
.22748 .42693 L
s
.27753 .47595 m
.27765 .52517 L
s
.27753 .47595 m
.22752 .47611 L
s
.27765 .52517 m
.27785 .57443 L
s
.27765 .52517 m
.22765 .52526 L
s
.27785 .57443 m
.27812 .6237 L
s
.27785 .57443 m
.22786 .57445 L
s
.27812 .6237 m
.27846 .67292 L
s
.27812 .6237 m
.22815 .62364 L
s
.27846 .67292 m
.27888 .72224 L
s
.27846 .67292 m
.22855 .67277 L
s
.27888 .72224 m
.27938 .77208 L
s
.27888 .72224 m
.22904 .72199 L
s
.27938 .77208 m
.27992 .82055 L
s
.27938 .77208 m
.22963 .77173 L
s
.27992 .82055 m
.28043 .86988 L
s
.27992 .82055 m
.23028 .82013 L
s
.28043 .86988 m
.28084 .9225 L
s
.28043 .86988 m
.23101 .86936 L
s
.28084 .9225 m
.28091 .97555 L
s
.28084 .9225 m
.23163 .92194 L
s
.28091 .97555 m
.23174 .97502 L
s
.22935 .02634 m
.2295 .07942 L
s
.22935 .02634 m
.18199 .02752 L
s
.2295 .07942 m
.22915 .132 L
s
.2295 .07942 m
.1818 .08055 L
s
.22915 .132 m
.22867 .18123 L
s
.22915 .132 m
.18123 .13301 L
s
.22867 .18123 m
.22827 .22963 L
s
.22867 .18123 m
.18046 .18207 L
s
.22827 .22963 m
.22792 .27938 L
s
.22827 .22963 m
.17987 .23028 L
s
.22792 .27938 m
.22768 .32861 L
s
.22792 .27938 m
.17945 .27992 L
s
.22768 .32861 m
.22753 .37773 L
s
.22768 .32861 m
.17913 .32903 L
s
.22753 .37773 m
.22748 .42693 L
s
.22753 .37773 m
.17894 .37806 L
s
.22748 .42693 m
.22752 .47611 L
s
.22748 .42693 m
.17887 .42717 L
s
.22752 .47611 m
.22765 .52526 L
s
.22752 .47611 m
.17889 .47627 L
s
.22765 .52526 m
.22786 .57445 L
s
.22765 .52526 m
.17902 .52535 L
s
.22786 .57445 m
.22815 .62364 L
s
.22786 .57445 m
.17924 .57445 L
s
.22815 .62364 m
.22855 .67277 L
s
.22815 .62364 m
.17956 .62356 L
s
.22855 .67277 m
.22904 .72199 L
s
.22855 .67277 m
.18 .67258 L
s
.22904 .72199 m
.22963 .77173 L
s
.22904 .72199 m
.18056 .72169 L
s
.22963 .77173 m
.23028 .82013 L
s
.22963 .77173 m
.18123 .77133 L
s
.23028 .82013 m
.23101 .86936 L
s
.23028 .82013 m
.18207 .81954 L
s
.23101 .86936 m
.23163 .92194 L
s
.23101 .86936 m
.18309 .8686 L
s
.23163 .92194 m
.23174 .97502 L
s
.23163 .92194 m
.18392 .92105 L
s
.23174 .97502 m
.18438 .97408 L
s
.18199 .02752 m
.1818 .08055 L
s
.18199 .02752 m
.13399 .02944 L
s
.1818 .08055 m
.18123 .13301 L
s
.1818 .08055 m
.13293 .08189 L
s
.18123 .13301 m
.18046 .18207 L
s
.18123 .13301 m
.1324 .13425 L
s
.18046 .18207 m
.17987 .23028 L
s
.18046 .18207 m
.1314 .18309 L
s
.17987 .23028 m
.17945 .27992 L
s
.17987 .23028 m
.13064 .23101 L
s
.17945 .27992 m
.17913 .32903 L
s
.17945 .27992 m
.13012 .28043 L
s
.17913 .32903 m
.17894 .37806 L
s
.17913 .32903 m
.12974 .32944 L
s
.17894 .37806 m
.17887 .42717 L
s
.17894 .37806 m
.12952 .37837 L
s
.17887 .42717 m
.17889 .47627 L
s
.17887 .42717 m
.12942 .42739 L
s
.17889 .47627 m
.17902 .52535 L
s
.17889 .47627 m
.12944 .47643 L
s
.17902 .52535 m
.17924 .57445 L
s
.17902 .52535 m
.12956 .52544 L
s
.17924 .57445 m
.17956 .62356 L
s
.17924 .57445 m
.12979 .57448 L
s
.17956 .62356 m
.18 .67258 L
s
.17956 .62356 m
.13014 .6235 L
s
.18 .67258 m
.18056 .72169 L
s
.18 .67258 m
.13061 .67243 L
s
.18056 .72169 m
.18123 .77133 L
s
.18056 .72169 m
.13123 .72144 L
s
.18123 .77133 m
.18207 .81954 L
s
.18123 .77133 m
.132 .77085 L
s
.18207 .81954 m
.18309 .8686 L
s
.18207 .81954 m
.13301 .81877 L
s
.18309 .8686 m
.18392 .92105 L
s
.18309 .8686 m
.13425 .8676 L
s
.18392 .92105 m
.18438 .97408 L
s
.18392 .92105 m
.13504 .91995 L
s
.18438 .97408 m
.13636 .9724 L
s
.13399 .02944 m
.13293 .08189 L
s
.13399 .02944 m
.0842 .03286 L
s
.13293 .08189 m
.1324 .13425 L
s
.13293 .08189 m
.08212 .08422 L
s
.1324 .13425 m
.1314 .18309 L
s
.1324 .13425 m
.08005 .13504 L
s
.1314 .18309 m
.13064 .23101 L
s
.1314 .18309 m
.07895 .18392 L
s
.13064 .23101 m
.13012 .28043 L
s
.13064 .23101 m
.07806 .23163 L
s
.13012 .28043 m
.12974 .32944 L
s
.13012 .28043 m
.0775 .28083 L
s
.12974 .32944 m
.12952 .37837 L
s
.12974 .32944 m
.07712 .32971 L
s
.12952 .37837 m
.12942 .42739 L
s
.12952 .37837 m
.07686 .37857 L
s
.12942 .42739 m
.12944 .47643 L
s
.12942 .42739 m
.07677 .42756 L
s
.12944 .47643 m
.12956 .52544 L
s
.12944 .47643 m
.07678 .47657 L
s
.12956 .52544 m
.12979 .57448 L
s
.12956 .52544 m
.07691 .52556 L
s
.12979 .57448 m
.13014 .6235 L
s
.12979 .57448 m
.07714 .57457 L
s
.13014 .6235 m
.13061 .67243 L
s
.13014 .6235 m
.07748 .62356 L
s
.13061 .67243 m
.13123 .72144 L
s
.13061 .67243 m
.07798 .67242 L
s
.13123 .72144 m
.132 .77085 L
s
.13123 .72144 m
.07861 .72129 L
s
.132 .77085 m
.13301 .81877 L
s
.132 .77085 m
.07942 .7705 L
s
.13301 .81877 m
.13425 .8676 L
s
.13301 .81877 m
.08055 .81821 L
s
.13425 .8676 m
.13504 .91995 L
s
.13425 .8676 m
.08189 .86707 L
s
.13504 .91995 m
.13636 .9724 L
s
.13504 .91995 m
.08422 .91788 L
s
.13636 .9724 m
.08656 .96923 L
s
.0842 .03286 m
.08212 .08422 L
s
.0842 .03286 m
.03404 .03639 L
s
.08212 .08422 m
.08005 .13504 L
s
.08212 .08422 m
.03077 .08656 L
s
.08005 .13504 m
.07895 .18392 L
s
.08005 .13504 m
.0276 .13636 L
s
.07895 .18392 m
.07806 .23163 L
s
.07895 .18392 m
.02592 .18438 L
s
.07806 .23163 m
.0775 .28083 L
s
.07806 .23163 m
.02498 .23174 L
s
.0775 .28083 m
.07712 .32971 L
s
.0775 .28083 m
.02445 .28091 L
s
.07712 .32971 m
.07686 .37857 L
s
.07712 .32971 m
.02411 .32981 L
s
.07686 .37857 m
.07677 .42756 L
s
.07686 .37857 m
.0239 .37867 L
s
.07677 .42756 m
.07678 .47657 L
s
.07677 .42756 m
.02381 .42764 L
s
.07678 .47657 m
.07691 .52556 L
s
.07678 .47657 m
.02384 .47669 L
s
.07691 .52556 m
.07714 .57457 L
s
.07691 .52556 m
.02396 .52571 L
s
.07714 .57457 m
.07748 .62356 L
s
.07714 .57457 m
.02418 .57476 L
s
.07748 .62356 m
.07798 .67242 L
s
.07748 .62356 m
.02452 .62374 L
s
.07798 .67242 m
.07861 .72129 L
s
.07798 .67242 m
.02498 .67259 L
s
.07861 .72129 m
.07942 .7705 L
s
.07861 .72129 m
.02556 .72148 L
s
.07942 .7705 m
.08055 .81821 L
s
.07942 .7705 m
.02634 .77065 L
s
.08055 .81821 m
.08189 .86707 L
s
.08055 .81821 m
.02752 .81801 L
s
.08189 .86707 m
.08422 .91788 L
s
.08189 .86707 m
.02944 .86601 L
s
.08422 .91788 m
.08656 .96923 L
s
.08422 .91788 m
.03286 .9158 L
s
.08656 .96923 m
.03639 .96596 L
s
.03404 .03639 m
.03077 .08656 L
s
.03077 .08656 m
.0276 .13636 L
s
.0276 .13636 m
.02592 .18438 L
s
.02592 .18438 m
.02498 .23174 L
s
.02498 .23174 m
.02445 .28091 L
s
.02445 .28091 m
.02411 .32981 L
s
.02411 .32981 m
.0239 .37867 L
s
.0239 .37867 m
.02381 .42764 L
s
.02381 .42764 m
.02384 .47669 L
s
.02384 .47669 m
.02396 .52571 L
s
.02396 .52571 m
.02418 .57476 L
s
.02418 .57476 m
.02452 .62374 L
s
.02452 .62374 m
.02498 .67259 L
s
.02498 .67259 m
.02556 .72148 L
s
.02556 .72148 m
.02634 .77065 L
s
.02634 .77065 m
.02752 .81801 L
s
.02752 .81801 m
.02944 .86601 L
s
.02944 .86601 m
.03286 .9158 L
s
.03286 .9158 m
.03639 .96596 L
s
.008 w
.96361 .03404 Mdot
.96714 .0842 Mdot
.97056 .13399 Mdot
.97248 .18199 Mdot
.97366 .22935 Mdot
.97444 .27852 Mdot
.97502 .32741 Mdot
.97548 .37627 Mdot
.97582 .42524 Mdot
.97604 .47429 Mdot
.97616 .52331 Mdot
.97619 .57236 Mdot
.9761 .62133 Mdot
.97589 .67019 Mdot
.97555 .71909 Mdot
.97502 .76826 Mdot
.97408 .81562 Mdot
.9724 .86364 Mdot
.96923 .91344 Mdot
.96596 .96361 Mdot
.91344 .03077 Mdot
.91578 .08212 Mdot
.91811 .13293 Mdot
.91945 .18179 Mdot
.92058 .2295 Mdot
.92139 .27871 Mdot
.92202 .32758 Mdot
.92252 .37644 Mdot
.92286 .42543 Mdot
.92309 .47444 Mdot
.92322 .52343 Mdot
.92323 .57244 Mdot
.92314 .62143 Mdot
.92288 .67029 Mdot
.9225 .71917 Mdot
.92194 .76837 Mdot
.92105 .81608 Mdot
.91995 .86496 Mdot
.91788 .91578 Mdot
.9158 .96714 Mdot
.86364 .0276 Mdot
.86496 .08005 Mdot
.86575 .1324 Mdot
.86699 .18123 Mdot
.868 .22915 Mdot
.86877 .27856 Mdot
.86939 .32757 Mdot
.86986 .3765 Mdot
.87021 .42552 Mdot
.87044 .47456 Mdot
.87056 .52357 Mdot
.87058 .57261 Mdot
.87048 .62163 Mdot
.87026 .67056 Mdot
.86988 .71957 Mdot
.86936 .76899 Mdot
.8686 .81691 Mdot
.8676 .86575 Mdot
.86707 .91811 Mdot
.86602 .97056 Mdot
.81562 .02592 Mdot
.81608 .07895 Mdot
.81691 .1314 Mdot
.81793 .18046 Mdot
.81877 .22867 Mdot
.81944 .27831 Mdot
.82 .32742 Mdot
.82044 .37644 Mdot
.82076 .42555 Mdot
.82098 .47465 Mdot
.82111 .52373 Mdot
.82113 .57283 Mdot
.82106 .62194 Mdot
.82087 .67097 Mdot
.82055 .72008 Mdot
.82013 .76972 Mdot
.81954 .81793 Mdot
.81877 .86699 Mdot
.81821 .91945 Mdot
.81801 .97248 Mdot
.76826 .02498 Mdot
.76837 .07806 Mdot
.76899 .13064 Mdot
.76972 .17987 Mdot
.77037 .22827 Mdot
.77096 .27801 Mdot
.77145 .32723 Mdot
.77185 .37636 Mdot
.77215 .42555 Mdot
.77236 .47474 Mdot
.77248 .52389 Mdot
.77252 .57307 Mdot
.77247 .62227 Mdot
.77232 .67139 Mdot
.77208 .72062 Mdot
.77173 .77037 Mdot
.77133 .81877 Mdot
.77085 .868 Mdot
.7705 .92058 Mdot
.77065 .97366 Mdot
.71909 .02445 Mdot
.71917 .0775 Mdot
.71957 .13012 Mdot
.72008 .17945 Mdot
.72062 .22792 Mdot
.72112 .27776 Mdot
.72154 .32708 Mdot
.72188 .3763 Mdot
.72215 .42557 Mdot
.72235 .47483 Mdot
.72247 .52405 Mdot
.72252 .57331 Mdot
.7225 .62258 Mdot
.72241 .67179 Mdot
.72224 .72112 Mdot
.72199 .77096 Mdot
.72169 .81944 Mdot
.72144 .86877 Mdot
.72129 .92139 Mdot
.72148 .97444 Mdot
.67019 .02411 Mdot
.67029 .07712 Mdot
.67056 .12974 Mdot
.67097 .17913 Mdot
.67139 .22768 Mdot
.67179 .27759 Mdot
.67215 .32698 Mdot
.67244 .37626 Mdot
.67268 .4256 Mdot
.67286 .47492 Mdot
.67298 .52421 Mdot
.67305 .57353 Mdot
.67306 .62286 Mdot
.67302 .67214 Mdot
.67291 .72154 Mdot
.67277 .77145 Mdot
.67258 .82 Mdot
.67243 .86939 Mdot
.67242 .92202 Mdot
.67259 .97502 Mdot
.62133 .0239 Mdot
.62143 .07686 Mdot
.62163 .12952 Mdot
.62194 .17894 Mdot
.62227 .22753 Mdot
.62258 .2775 Mdot
.62286 .32694 Mdot
.62311 .37627 Mdot
.62331 .42565 Mdot
.62348 .47502 Mdot
.6236 .52436 Mdot
.62369 .57372 Mdot
.62373 .62311 Mdot
.62374 .67244 Mdot
.6237 .72188 Mdot
.62364 .77185 Mdot
.62356 .82044 Mdot
.6235 .86986 Mdot
.62356 .92252 Mdot
.62374 .97548 Mdot
.57236 .02381 Mdot
.57244 .07677 Mdot
.57261 .12942 Mdot
.57283 .17887 Mdot
.57307 .22748 Mdot
.57331 .27748 Mdot
.57353 .32695 Mdot
.57372 .37631 Mdot
.5739 .42573 Mdot
.57405 .47513 Mdot
.57417 .5245 Mdot
.57427 .5739 Mdot
.57435 .62331 Mdot
.5744 .67268 Mdot
.57443 .72215 Mdot
.57445 .77214 Mdot
.57445 .82076 Mdot
.57448 .87021 Mdot
.57457 .92286 Mdot
.57476 .97582 Mdot
.52331 .02384 Mdot
.52343 .07678 Mdot
.52357 .12944 Mdot
.52373 .17889 Mdot
.52389 .22752 Mdot
.52405 .27753 Mdot
.52421 .32702 Mdot
.52436 .3764 Mdot
.5245 .42583 Mdot
.52463 .47525 Mdot
.52475 .52463 Mdot
.52487 .57405 Mdot
.52498 .62348 Mdot
.52508 .67286 Mdot
.52517 .72235 Mdot
.52526 .77235 Mdot
.52535 .82098 Mdot
.52544 .87044 Mdot
.52556 .92309 Mdot
.52571 .97604 Mdot
.47428 .02396 Mdot
.47444 .07691 Mdot
.47456 .12956 Mdot
.47465 .17902 Mdot
.47474 .22764 Mdot
.47483 .27765 Mdot
.47492 .32714 Mdot
.47502 .37652 Mdot
.47513 .42595 Mdot
.47525 .47537 Mdot
.47537 .52475 Mdot
.4755 .57417 Mdot
.47564 .6236 Mdot
.47579 .67298 Mdot
.47595 .72247 Mdot
.47611 .77248 Mdot
.47627 .82111 Mdot
.47643 .87056 Mdot
.47657 .92322 Mdot
.47669 .97616 Mdot
.42524 .02418 Mdot
.42543 .07714 Mdot
.42552 .12979 Mdot
.42555 .17924 Mdot
.42555 .22786 Mdot
.42557 .27785 Mdot
.4256 .32732 Mdot
.42565 .37669 Mdot
.42573 .4261 Mdot
.42583 .4755 Mdot
.42595 .52487 Mdot
.4261 .57427 Mdot
.42628 .62369 Mdot
.42647 .67305 Mdot
.42669 .72252 Mdot
.42693 .77252 Mdot
.42717 .82113 Mdot
.42739 .87058 Mdot
.42756 .92323 Mdot
.42764 .97619 Mdot
.37626 .02452 Mdot
.37644 .07748 Mdot
.3765 .13014 Mdot
.37644 .17956 Mdot
.37636 .22815 Mdot
.3763 .27812 Mdot
.37626 .32756 Mdot
.37627 .37689 Mdot
.37631 .42628 Mdot
.3764 .47564 Mdot
.37652 .52498 Mdot
.37669 .57435 Mdot
.37689 .62373 Mdot
.37714 .67306 Mdot
.37742 .7225 Mdot
.37773 .77247 Mdot
.37806 .82106 Mdot
.37837 .87048 Mdot
.37857 .92314 Mdot
.37867 .9761 Mdot
.32741 .02498 Mdot
.32758 .07798 Mdot
.32757 .13061 Mdot
.32742 .18 Mdot
.32723 .22855 Mdot
.32709 .27846 Mdot
.32698 .32785 Mdot
.32694 .37714 Mdot
.32695 .42647 Mdot
.32702 .47579 Mdot
.32714 .52508 Mdot
.32732 .5744 Mdot
.32756 .62374 Mdot
.32785 .67302 Mdot
.32821 .72241 Mdot
.32861 .77232 Mdot
.32903 .82087 Mdot
.32944 .87026 Mdot
.32971 .92288 Mdot
.32981 .97589 Mdot
.27852 .02556 Mdot
.27871 .07861 Mdot
.27856 .13123 Mdot
.27831 .18056 Mdot
.27801 .22904 Mdot
.27776 .27888 Mdot
.27759 .32821 Mdot
.2775 .37742 Mdot
.27748 .42669 Mdot
.27753 .47595 Mdot
.27765 .52517 Mdot
.27785 .57443 Mdot
.27812 .6237 Mdot
.27846 .67292 Mdot
.27888 .72224 Mdot
.27938 .77208 Mdot
.27992 .82055 Mdot
.28043 .86988 Mdot
.28084 .9225 Mdot
.28091 .97555 Mdot
.22935 .02634 Mdot
.2295 .07942 Mdot
.22915 .132 Mdot
.22867 .18123 Mdot
.22827 .22963 Mdot
.22792 .27938 Mdot
.22768 .32861 Mdot
.22753 .37773 Mdot
.22748 .42693 Mdot
.22752 .47611 Mdot
.22765 .52526 Mdot
.22786 .57445 Mdot
.22815 .62364 Mdot
.22855 .67277 Mdot
.22904 .72199 Mdot
.22963 .77173 Mdot
.23028 .82013 Mdot
.23101 .86936 Mdot
.23163 .92194 Mdot
.23174 .97502 Mdot
.18199 .02752 Mdot
.1818 .08055 Mdot
.18123 .13301 Mdot
.18046 .18207 Mdot
.17987 .23028 Mdot
.17945 .27992 Mdot
.17913 .32903 Mdot
.17894 .37806 Mdot
.17887 .42717 Mdot
.17889 .47627 Mdot
.17902 .52535 Mdot
.17924 .57445 Mdot
.17956 .62356 Mdot
.18 .67258 Mdot
.18056 .72169 Mdot
.18123 .77133 Mdot
.18207 .81954 Mdot
.18309 .8686 Mdot
.18392 .92105 Mdot
.18438 .97408 Mdot
.13399 .02944 Mdot
.13293 .08189 Mdot
.1324 .13425 Mdot
.1314 .18309 Mdot
.13064 .23101 Mdot
.13012 .28043 Mdot
.12974 .32944 Mdot
.12952 .37837 Mdot
.12942 .42739 Mdot
.12944 .47643 Mdot
.12956 .52544 Mdot
.12979 .57448 Mdot
.13014 .6235 Mdot
.13061 .67243 Mdot
.13123 .72144 Mdot
.132 .77085 Mdot
.13301 .81877 Mdot
.13425 .8676 Mdot
.13504 .91995 Mdot
.13636 .9724 Mdot
.0842 .03286 Mdot
.08212 .08422 Mdot
.08005 .13504 Mdot
.07895 .18392 Mdot
.07806 .23163 Mdot
.0775 .28083 Mdot
.07712 .32971 Mdot
.07686 .37857 Mdot
.07677 .42756 Mdot
.07678 .47657 Mdot
.07691 .52556 Mdot
.07714 .57457 Mdot
.07748 .62356 Mdot
.07798 .67242 Mdot
.07861 .72129 Mdot
.07942 .7705 Mdot
.08055 .81821 Mdot
.08189 .86707 Mdot
.08422 .91788 Mdot
.08656 .96923 Mdot
.03404 .03639 Mdot
.03077 .08656 Mdot
.0276 .13636 Mdot
.02592 .18438 Mdot
.02498 .23174 Mdot
.02445 .28091 Mdot
.02411 .32981 Mdot
.0239 .37867 Mdot
.02381 .42764 Mdot
.02384 .47669 Mdot
.02396 .52571 Mdot
.02418 .57476 Mdot
.02452 .62374 Mdot
.02498 .67259 Mdot
.02556 .72148 Mdot
.02634 .77065 Mdot
.02752 .81801 Mdot
.02944 .86601 Mdot
.03286 .9158 Mdot
.03639 .96596 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00C`3oool2000000`0oooo0P00000<0?ooo`8000001P3ooomD000000H0
oooo0P00000<0?ooo`800000@`3oool002d0ooooAP0000070?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooocP000008@3oool001l0oooo3P00
00070?ooo`030000003oool0oooo00X0oooo0P00000<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`8000001P3oool>000001<0oooo000A
0?ooo`h000001`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00@0oooo2000000;
0?ooo`002@3oool8000000L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool000T0oooo0P00000=0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00T0oooo00090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2@3oool000T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`002@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00090?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02@3oool000T0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`090?ooo`002@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo
00080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0203oool000P0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`00203oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00P0oooo00080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo0P00000<0?ooo`80
0000303oool2000000`0oooo0P00000<0?ooo`800000303oool2000000`0oooo0P00000<0?ooo`80
00003@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo00080?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`800000
1P3oooo4000000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`00203o
ool00`000000oooo0?ooo`0;0?ooo`8000001`3ooolL000000H0oooo0P00000<0?ooo`8000003@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103o
ool?000000H0oooo0P00000:0?ooo`00203ooolG000000L0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2
000000H0oooo2000000:0?ooo`00203oool2000000d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0203oool000P0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`00203oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00P0oooo00080?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0203oool000P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`08
0?ooo`00203oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo00080?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool000L0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`070?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00L0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool0
00L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`001`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0:0?ooo`800000303oool2000000`0oooo0P00000<0?ooo`800000303oool2000000`0
oooo0P00000<0?ooo`800000303oool2000000d0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`070?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool02P3oool2000000H0ooooa@0000060?ooo`8000003P3oool00`000000oooo
0?ooo`070?ooo`001`3oool2000000H0oooo;00000060?ooo`800000303oool2000000d0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00
000<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01@3ooolG000000T0oooo0007
0?ooo`P000001`3oool2000000h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00L0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool01`3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`00
1`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00070?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool01`3oool000L0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`070?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00L0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01P3oool000L0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool2000000`0oooo0P00000<0?oo
o`8000003@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P0000050?ooojT0
00001`3oool2000000d0oooo0P00000=0?ooo`800000203oool000H0oooo@P0000070?ooo`800000
303oool2000000d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00000<0?ooo`800000
1@3ooolW000000P0oooo00070?ooo`030000003oool0oooo00`0oooo0P00000=0?ooo`800000303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00H0
oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01P3oool000L0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`00
1`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo0P00000<0?ooo`800000303oool2
000000`0oooo0P00000=0?ooo`800000303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`8000003@3oool2000000D0oooogP0000080?ooo`001P3ooold000000L0
oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00000=0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo0P00000=0?ooo`030000003oool0oooo00X0oooo0P00000=0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`06
0?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool0
00L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02P3oool2000000`0oooo0P00000=0?ooo`8000001@3oooo3000000L0oooo00060?oo
oe0000001`3oool2000000d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`800000303oool2000000`0oooo0P00000=0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo0P0000070?oo
o`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`06
0?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00060?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`8000003@3o
ool2000000`0oooo0P00000<0?ooo`8000001P3ooomo000000H0oooo0P00000=0?ooo`8000001`3o
ool9000000L0oooo00060?ooofd000001`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`800000303oool2
000000d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00@0oooo7P0000070?ooo`8000001`3oool000H0oooo0P00000>0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00H0oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000H0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?oo
o`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00H0oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000H0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00000<0?ooo`800000303oool2000000`0oooo
0P00000<0?ooo`800000303oool2000000H0oooo>@0000060?ooo`800000303oool2000000d0oooo
0P00000=0?ooo`8000001P3oool9000000L0oooo00060?oooiL000001`3oool2000000`0oooo0P00
000<0?ooo`8000003@3oool00`000000oooo0?ooo`040?ooocX000001`3oool2000000L0oooo0006
0?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00H0oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool01P3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00060?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool01P3oool000H0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0
oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00000<0?ooo`80
0000303oool2000000d0oooo0P00000<0?ooo`800000303oool2000000`0oooo0P00000<0?ooo`80
0000303oool2000000d0oooo0P00000=0?ooo`8000003@3oool2000000L0oooo00060?ooool00000
500000070?ooo`001P3oool2000000h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00
000=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?oo
o`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`05
0?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00000<0?oo
o`800000303oool2000000`0oooo0P00000=0?ooo`8000002`3oool2000000d0oooo0P00000=0?oo
o`8000003@3oool2000000L0oooo00060?ooool00000500000070?ooo`001P3oool2000000h0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool2000000`0oooo0P00000=0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo
00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0
oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00000<
0?ooo`8000003@3oool2000000d0oooo0P0000070?ooo`001P3ooooo000001@000001`3oool000H0
oooo0P00000>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00000<0?ooo`8000003@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`800000303oool2000000d0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?oo
o`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool2000000d0oooo0P00000=0?ooo`8000001`3oool000H0ooooo`00000D
000000L0oooo00060?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`800000303oool20000
00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo0P00000<0?ooo`8000003@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00000<0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00060?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`050?ooo`001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00060?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000H0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00D0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3o
ool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00070?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo0P00000=0?ooo`8000001`3oool000H0oooo0P00
00070?ooodP000001P3oool2000000`0oooo0P0000060?ooojH000001`3oool000L0oooo20000007
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo0P0000060?oooa`000001`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo0P00000<0?ooo`8000003@3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00000<
0?ooo`8000003@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00070?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00D0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3o
ool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00070?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo0007
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool2000000d0oooo0P0000070?ooo`00
1P3oool2000000L0oooo7@0000070?ooo`8000002`3oool2000000d0oooo0P00000<0?ooo`800000
303oool2000000`0oooo0P00000<0?ooo`8000003@3oool2000000`0oooo0P0000060?ooofd00000
1`3oool000L0oooo200000070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0103o
oon0000000L0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo0P00000<0?ooo`030000003oool0oooo00/0oooo0P00000=0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00D0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool000L0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00D0oooo00070?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?oo
o`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000H0
oooo0P00000=0?ooo`8000003P3oool2000000`0oooo0P00000<0?ooo`800000303oool2000000`0
oooo0P00000<0?ooo`800000303oool2000000`0oooo0P00000=0?ooo`800000303oool2000000`0
oooo0P00000<0?ooo`8000001P3ooomA000000L0oooo00070?oool4000001`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000d0oooo
0P00000=0?ooo`8000001`3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3o
ool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo0007
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000H0oooo0P00000>0?oo
o`8000003@3oool2000000`0oooo0P00000<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo0P00000<0?oo
o`8000001P3ooole000000L0oooo00070?ooomd000001`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool2000000L0oooo00070?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00X0oooo0P00000=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00000<0?ooo`800000
303oool2000000`0oooo0P00000=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00H0oooo00070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?oo
o`001`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00000=0?ooo`800000203o
ool000L0oooo9P0000060?ooo`800000303oool2000000d0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`800000303oool2000000H0oooo@P0000080?ooo`001`3oool20000
00h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooojT000001`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`800000303oool2000000`0
oooo0P00000<0?ooo`8000003@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`06
0?ooo`001`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00070?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`060?ooo`00203oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00H0oooo00080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool0
00P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`00203oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00080?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`8000001`3oool8000000P0oooo
00070?ooobH000001P3oool2000000d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool2000000`0oooo0P00
00060?ooob`000001`3oool00`000000oooo0?ooo`060?ooo`00203oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0103ooong000000H0oooo0P00000=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`06
0?ooo`00203oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00000<0?oo
o`800000303oool2000000`0oooo0P00000<0?ooo`800000303oool2000000d0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00080?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`060?ooo`00203oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00H0oooo00080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool0
00P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`070?ooo`002@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00090?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`070?ooo`002@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00090?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool2000000T0oooo00080?ooo`T000001`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00D0oooo5`0000090?ooo`002@3oool00`000000oooo0?ooo`050?ooo`h000001`3o
ool2000000`0oooo0P00000<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3o
ool2000000H0oooo700000070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3o
ool000T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`040?ooolD000001P3oool2
000000`0oooo0P00000=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool0
00T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo0P00000<0?ooo`800000303oool2000000`0oooo0P00000<0?ooo`800000303oool20000
00`0oooo0P00000<0?ooo`8000003@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo
00090?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool000T0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`002P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00P0oooo000:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0203oool000X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`080?ooo`002P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0203oool000X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`080?ooo`002@3oool2000000d0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo2000000:0?ooo`002P3oool7000000L0oooo
0P00000=0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00@0oooo3`0000070?ooo`030000003oool0oooo00P0oooo
000A0?ooo`l000001P3oool2000000`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool2000000D0oooo3P00
00080?ooo`030000003oool0oooo01H0oooo000P0?ooocL000001`3oool2000000`0oooo0P00000<
0?ooo`800000303oool2000000`0oooo0P00000<0?ooo`8000001P3ooom5000000L0oooo00<00000
0?ooo`3oool09@3oool003D0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0ooooE@0000070?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0400oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo0000\
\>"],
  ImageRangeCache->{{{81, 368}, {511.188, 224.188}} -> {-1.64269, 0.5904, \
0.00731712, 0.00731712}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spring-electrical model", "Subsubsection",
  CellTags->"spring-electrical model"],

Cell[TextData[{
  "The disadvantage of the spring model is that it requires knowing the graph \
distance between every pair of vertices. The spring-electrical model uses two \
forces. The attractive force, ",
  Cell[BoxData[
      FormBox[Cell[TextData[{
          Cell[BoxData[
              \(TraditionalForm\`\(\(f\_a\)\(\ \)\(=\)\)\)]],
          " ",
          Cell[BoxData[
              FormBox[
                RowBox[{
                  SuperscriptBox[
                    SubscriptBox["d", 
                      StyleBox["ij",
                        FontSlant->"Italic"]], "2"], "/", "K"}], 
                TraditionalForm]]]
        }]], TraditionalForm]]],
  ", is restricted to adjacent vertices and is proportional to the physical \
distance between them. The electrical force, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\_r\), " ", "=", 
          RowBox[{\(-K\^2\), "/", 
            SubscriptBox["d", 
              StyleBox["ij",
                FontSlant->"Italic"]]}]}], TraditionalForm]]],
  ", on the other hand, is global and is inversely proportional to the \
distance between nodes ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  ". Overall, the energy to be minimized is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(i = \
1\)\%\(\(|\)\(V\)\(|\)\)f\_\(\_i\)\^2\)]],
  ", where"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(f\_i\), "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(-C\), " ", 
              RowBox[{\(\[Sum]\+\(j \[NotEqual] i\)\), " ", 
                RowBox[{
                  FractionBox[\(K\^2\), 
                    SubscriptBox["d", 
                      StyleBox["ij",
                        FontSlant->"Italic"]]], 
                  FractionBox[\((x\_j - x\_i)\), 
                    SubscriptBox["d", 
                      StyleBox["ij",
                        FontSlant->"Italic"]]]}]}]}], "+", 
            RowBox[{\(\[Sum]\+\(i\[LongLeftRightArrow]j\)\), 
              RowBox[{
                FractionBox[
                  SuperscriptBox[
                    SubscriptBox["d", 
                      StyleBox["ij",
                        FontSlant->"Italic"]], "2"], "K"], " ", 
                FractionBox[\((x\_j - x\_i)\), 
                  SubscriptBox["d", 
                    StyleBox["ij",
                      FontSlant->"Italic"]]]}]}]}], " ", "=", " ", 
          RowBox[{
            RowBox[{\(-C\), " ", 
              RowBox[{\(\[Sum]\+\(j \[NotEqual] i\)\), 
                RowBox[{
                  FractionBox[\(K\^2\), 
                    SuperscriptBox[
                      SubscriptBox["d", 
                        StyleBox["ij",
                          FontSlant->"Italic"]], "2"]], \((x\_j - 
                      x\_i)\)}]}]}], " ", "+", 
            RowBox[{\(\[Sum]\+\(\(\(i\)\(<\)\) \[Rule] j\)\), 
              RowBox[{
                FractionBox[
                  SubscriptBox["d", 
                    StyleBox["ij",
                      FontSlant->"Italic"]], 
                  "K"], \((x\_j - x\_i)\)}]}]}]}]}], TraditionalForm]], "Text"],

Cell[TextData[{
  "Here, ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " is a constant that regulates the relative strength of the repulsive and \
attractive forces, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["d", 
            StyleBox["ij",
              FontSlant->"Italic"]], " ", "=", 
          " ", \(\(||\)\(x\_i\  - \ x\_j\)\(||\)\)}], TraditionalForm]]],
  " is the Euclidean distance between nodes ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  ", and ",
  StyleBox["K",
    FontSlant->"Italic"],
  " is the natural spring length. For a graph of two vertices, the ideal \
distance between the vertices is ",
  Cell[BoxData[
      \(TraditionalForm\`K\ C\^\(1/3\)\)]],
  ", which gives a total energy of zero."
}], "Text"],

Cell["\<\
The layout of the graph vertices is calculated by minimizing the \
energy function. One way to do this is by iteratively moving each of the \
vertices along the direction of the spring force until an approximate \
equilibrium is reached. Multilevel techniques are used to overcome local \
minima, and an octree data structure is used to reduce the computational \
complexity in some cases.\
\>", "Text"],

Cell[TextData[{
  "In general, the spring-electrical model works well for most problems. With \
multilevel and octree techniques, it is implemented very efficiently with a \
complexity of about ",
  Cell[BoxData[
      \(TraditionalForm\`O(\(|\)\(V\)\(|\)\(\ \
\)\(log(\(|\)\(V\)\(|\))\))\)]],
  ". A side-effect of this algorithm is that vertices at the periphery tend \
to be closer to each other than those in the center. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[GridGraph[20, 20], 
        Method \[Rule] SpringElectricalModel];\)\)], "Input",
  CellLabel->"In[11]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95418 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500011 0.476202 0.482569 0.476202 [
[ 0 0 0 0 ]
[ 1 .95418 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.04539 .91919 m
.07275 .92058 L
s
.04539 .91919 m
.04323 .894 L
s
.07275 .92058 m
.10929 .92285 L
s
.07275 .92058 m
.07054 .89456 L
s
.10929 .92285 m
.15216 .92489 L
s
.10929 .92285 m
.10752 .89715 L
s
.15216 .92489 m
.19966 .92649 L
s
.15216 .92489 m
.15087 .8998 L
s
.19966 .92649 m
.25054 .92743 L
s
.19966 .92649 m
.1986 .90145 L
s
.25054 .92743 m
.3039 .92674 L
s
.25054 .92743 m
.24969 .90233 L
s
.3039 .92674 m
.35937 .92814 L
s
.3039 .92674 m
.30332 .90277 L
s
.35937 .92814 m
.41615 .92959 L
s
.35937 .92814 m
.35892 .90394 L
s
.41615 .92959 m
.47361 .93024 L
s
.41615 .92959 m
.4159 .90494 L
s
.47361 .93024 m
.53139 .93065 L
s
.47361 .93024 m
.47359 .90567 L
s
.53139 .93065 m
.58885 .93113 L
s
.53139 .93065 m
.53159 .90608 L
s
.58885 .93113 m
.64542 .93139 L
s
.58885 .93113 m
.5893 .90622 L
s
.64542 .93139 m
.70055 .93124 L
s
.64542 .93139 m
.64612 .90623 L
s
.70055 .93124 m
.75364 .93146 L
s
.70055 .93124 m
.70148 .90594 L
s
.75364 .93146 m
.80404 .93131 L
s
.75364 .93146 m
.75478 .90579 L
s
.80404 .93131 m
.85077 .9309 L
s
.80404 .93131 m
.80556 .90506 L
s
.85077 .9309 m
.8929 .92968 L
s
.85077 .9309 m
.85261 .90437 L
s
.8929 .92968 m
.92894 .92786 L
s
.8929 .92968 m
.89511 .90303 L
s
.92894 .92786 m
.95574 .92593 L
s
.92894 .92786 m
.93154 .90123 L
s
.95574 .92593 m
.95866 .89951 L
s
.04323 .894 m
.07054 .89456 L
s
.04323 .894 m
.04095 .85998 L
s
.07054 .89456 m
.10752 .89715 L
s
.07054 .89456 m
.0686 .86092 L
s
.10752 .89715 m
.15087 .8998 L
s
.10752 .89715 m
.10557 .86266 L
s
.15087 .8998 m
.1986 .90145 L
s
.15087 .8998 m
.14915 .86524 L
s
.1986 .90145 m
.24969 .90233 L
s
.1986 .90145 m
.19713 .8671 L
s
.24969 .90233 m
.30332 .90277 L
s
.24969 .90233 m
.24845 .86842 L
s
.30332 .90277 m
.35892 .90394 L
s
.30332 .90277 m
.30233 .86927 L
s
.35892 .90394 m
.4159 .90494 L
s
.35892 .90394 m
.35822 .87031 L
s
.4159 .90494 m
.47359 .90567 L
s
.4159 .90494 m
.41548 .87101 L
s
.47359 .90567 m
.53159 .90608 L
s
.47359 .90567 m
.47353 .87143 L
s
.53159 .90608 m
.5893 .90622 L
s
.53159 .90608 m
.53174 .87187 L
s
.5893 .90622 m
.64612 .90623 L
s
.5893 .90622 m
.58973 .87181 L
s
.64612 .90623 m
.70148 .90594 L
s
.64612 .90623 m
.64695 .87139 L
s
.70148 .90594 m
.75478 .90579 L
s
.70148 .90594 m
.70255 .87116 L
s
.75478 .90579 m
.80556 .90506 L
s
.75478 .90579 m
.75632 .8705 L
s
.80556 .90506 m
.85261 .90437 L
s
.80556 .90506 m
.80772 .8693 L
s
.85261 .90437 m
.89511 .90303 L
s
.85261 .90437 m
.85506 .86853 L
s
.89511 .90303 m
.93154 .90123 L
s
.89511 .90303 m
.89799 .8671 L
s
.93154 .90123 m
.95866 .89951 L
s
.93154 .90123 m
.93476 .86547 L
s
.95866 .89951 m
.96203 .86405 L
s
.04095 .85998 m
.0686 .86092 L
s
.04095 .85998 m
.0385 .81986 L
s
.0686 .86092 m
.10557 .86266 L
s
.0686 .86092 m
.06621 .82081 L
s
.10557 .86266 m
.14915 .86524 L
s
.10557 .86266 m
.10342 .82239 L
s
.14915 .86524 m
.19713 .8671 L
s
.14915 .86524 m
.14719 .82436 L
s
.19713 .8671 m
.24845 .86842 L
s
.19713 .8671 m
.19535 .82618 L
s
.24845 .86842 m
.30233 .86927 L
s
.24845 .86842 m
.24699 .82755 L
s
.30233 .86927 m
.35822 .87031 L
s
.30233 .86927 m
.30127 .82849 L
s
.35822 .87031 m
.41548 .87101 L
s
.35822 .87031 m
.35746 .82936 L
s
.41548 .87101 m
.47353 .87143 L
s
.41548 .87101 m
.41499 .82998 L
s
.47353 .87143 m
.53174 .87187 L
s
.47353 .87143 m
.47336 .83039 L
s
.53174 .87187 m
.58973 .87181 L
s
.53174 .87187 m
.53188 .8306 L
s
.58973 .87181 m
.64695 .87139 L
s
.58973 .87181 m
.59018 .83049 L
s
.64695 .87139 m
.70255 .87116 L
s
.64695 .87139 m
.64784 .82996 L
s
.70255 .87116 m
.75632 .8705 L
s
.70255 .87116 m
.70386 .82963 L
s
.75632 .8705 m
.80772 .8693 L
s
.75632 .8705 m
.75808 .82876 L
s
.80772 .8693 m
.85506 .86853 L
s
.80772 .8693 m
.80962 .82761 L
s
.85506 .86853 m
.89799 .8671 L
s
.85506 .86853 m
.85764 .82642 L
s
.89799 .8671 m
.93476 .86547 L
s
.89799 .8671 m
.90104 .82502 L
s
.93476 .86547 m
.96203 .86405 L
s
.93476 .86547 m
.93802 .82358 L
s
.96203 .86405 m
.96543 .82241 L
s
.0385 .81986 m
.06621 .82081 L
s
.0385 .81986 m
.03598 .77524 L
s
.06621 .82081 m
.10342 .82239 L
s
.06621 .82081 m
.06368 .77601 L
s
.10342 .82239 m
.14719 .82436 L
s
.10342 .82239 m
.10104 .77724 L
s
.14719 .82436 m
.19535 .82618 L
s
.14719 .82436 m
.14499 .77885 L
s
.19535 .82618 m
.24699 .82755 L
s
.19535 .82618 m
.1935 .78042 L
s
.24699 .82755 m
.30127 .82849 L
s
.24699 .82755 m
.24551 .78165 L
s
.30127 .82849 m
.35746 .82936 L
s
.30127 .82849 m
.30012 .78248 L
s
.35746 .82936 m
.41499 .82998 L
s
.35746 .82936 m
.35667 .78318 L
s
.41499 .82998 m
.47336 .83039 L
s
.41499 .82998 m
.41459 .78363 L
s
.47336 .83039 m
.53188 .8306 L
s
.47336 .83039 m
.47321 .784 L
s
.53188 .8306 m
.59018 .83049 L
s
.53188 .8306 m
.53203 .78411 L
s
.59018 .83049 m
.64784 .82996 L
s
.59018 .83049 m
.59063 .78403 L
s
.64784 .82996 m
.70386 .82963 L
s
.64784 .82996 m
.6486 .78361 L
s
.70386 .82963 m
.75808 .82876 L
s
.70386 .82963 m
.70524 .78304 L
s
.75808 .82876 m
.80962 .82761 L
s
.75808 .82876 m
.75987 .78216 L
s
.80962 .82761 m
.85764 .82642 L
s
.80962 .82761 m
.81178 .78103 L
s
.85764 .82642 m
.90104 .82502 L
s
.85764 .82642 m
.8602 .7798 L
s
.90104 .82502 m
.93802 .82358 L
s
.90104 .82502 m
.90391 .77853 L
s
.93802 .82358 m
.96543 .82241 L
s
.93802 .82358 m
.94109 .77723 L
s
.96543 .82241 m
.96854 .77625 L
s
.03598 .77524 m
.06368 .77601 L
s
.03598 .77524 m
.03355 .72713 L
s
.06368 .77601 m
.10104 .77724 L
s
.06368 .77601 m
.06128 .72763 L
s
.10104 .77724 m
.14499 .77885 L
s
.10104 .77724 m
.09884 .72855 L
s
.14499 .77885 m
.1935 .78042 L
s
.14499 .77885 m
.14291 .72976 L
s
.1935 .78042 m
.24551 .78165 L
s
.1935 .78042 m
.19179 .73105 L
s
.24551 .78165 m
.30012 .78248 L
s
.24551 .78165 m
.24407 .73201 L
s
.30012 .78248 m
.35667 .78318 L
s
.30012 .78248 m
.29896 .73268 L
s
.35667 .78318 m
.41459 .78363 L
s
.35667 .78318 m
.35587 .73318 L
s
.41459 .78363 m
.47321 .784 L
s
.41459 .78363 m
.41413 .73345 L
s
.47321 .784 m
.53203 .78411 L
s
.47321 .784 m
.47315 .73367 L
s
.53203 .78411 m
.59063 .78403 L
s
.53203 .78411 m
.53229 .73375 L
s
.59063 .78403 m
.6486 .78361 L
s
.59063 .78403 m
.59116 .7337 L
s
.6486 .78361 m
.70524 .78304 L
s
.6486 .78361 m
.64945 .73335 L
s
.70524 .78304 m
.75987 .78216 L
s
.70524 .78304 m
.70638 .73279 L
s
.75987 .78216 m
.81178 .78103 L
s
.75987 .78216 m
.76135 .732 L
s
.81178 .78103 m
.8602 .7798 L
s
.81178 .78103 m
.81359 .7309 L
s
.8602 .7798 m
.90391 .77853 L
s
.8602 .7798 m
.86237 .72979 L
s
.90391 .77853 m
.94109 .77723 L
s
.90391 .77853 m
.90649 .7287 L
s
.94109 .77723 m
.96854 .77625 L
s
.94109 .77723 m
.94378 .72758 L
s
.96854 .77625 m
.97131 .72676 L
s
.03355 .72713 m
.06128 .72763 L
s
.03355 .72713 m
.0314 .67646 L
s
.06128 .72763 m
.09884 .72855 L
s
.06128 .72763 m
.0592 .67668 L
s
.09884 .72855 m
.14291 .72976 L
s
.09884 .72855 m
.09691 .67714 L
s
.14291 .72976 m
.19179 .73105 L
s
.14291 .72976 m
.14111 .678 L
s
.19179 .73105 m
.24407 .73201 L
s
.19179 .73105 m
.19019 .67888 L
s
.24407 .73201 m
.29896 .73268 L
s
.24407 .73201 m
.24276 .67953 L
s
.29896 .73268 m
.35587 .73318 L
s
.29896 .73268 m
.29796 .67999 L
s
.35587 .73318 m
.41413 .73345 L
s
.35587 .73318 m
.35517 .68029 L
s
.41413 .73345 m
.47315 .73367 L
s
.41413 .73345 m
.41377 .68046 L
s
.47315 .73367 m
.53229 .73375 L
s
.47315 .73367 m
.47311 .68053 L
s
.53229 .73375 m
.59116 .7337 L
s
.53229 .73375 m
.53267 .68049 L
s
.59116 .7337 m
.64945 .73335 L
s
.59116 .7337 m
.59179 .68043 L
s
.64945 .73335 m
.70638 .73279 L
s
.64945 .73335 m
.6502 .68018 L
s
.70638 .73279 m
.76135 .732 L
s
.70638 .73279 m
.70737 .67975 L
s
.76135 .732 m
.81359 .7309 L
s
.76135 .732 m
.76264 .67906 L
s
.81359 .7309 m
.86237 .72979 L
s
.81359 .7309 m
.81517 .67815 L
s
.86237 .72979 m
.90649 .7287 L
s
.86237 .72979 m
.86411 .67716 L
s
.90649 .7287 m
.94378 .72758 L
s
.90649 .7287 m
.9084 .67629 L
s
.94378 .72758 m
.97131 .72676 L
s
.94378 .72758 m
.94595 .67544 L
s
.97131 .72676 m
.9738 .67477 L
s
.0314 .67646 m
.0592 .67668 L
s
.0314 .67646 m
.0296 .62407 L
s
.0592 .67668 m
.09691 .67714 L
s
.0592 .67668 m
.05743 .62401 L
s
.09691 .67714 m
.14111 .678 L
s
.09691 .67714 m
.09519 .62406 L
s
.14111 .678 m
.19019 .67888 L
s
.14111 .678 m
.13955 .62434 L
s
.19019 .67888 m
.24276 .67953 L
s
.19019 .67888 m
.18885 .62472 L
s
.24276 .67953 m
.29796 .67999 L
s
.24276 .67953 m
.24161 .62507 L
s
.29796 .67999 m
.35517 .68029 L
s
.29796 .67999 m
.29707 .62528 L
s
.35517 .68029 m
.41377 .68046 L
s
.35517 .68029 m
.35456 .62535 L
s
.41377 .68046 m
.47311 .68053 L
s
.41377 .68046 m
.41341 .6254 L
s
.47311 .68053 m
.53267 .68049 L
s
.47311 .68053 m
.47296 .62531 L
s
.53267 .68049 m
.59179 .68043 L
s
.53267 .68049 m
.53267 .62517 L
s
.59179 .68043 m
.6502 .68018 L
s
.59179 .68043 m
.59208 .62503 L
s
.6502 .68018 m
.70737 .67975 L
s
.6502 .68018 m
.65077 .62482 L
s
.70737 .67975 m
.76264 .67906 L
s
.70737 .67975 m
.70818 .62453 L
s
.76264 .67906 m
.81517 .67815 L
s
.76264 .67906 m
.76367 .62405 L
s
.81517 .67815 m
.86411 .67716 L
s
.81517 .67815 m
.81642 .62341 L
s
.86411 .67716 m
.9084 .67629 L
s
.86411 .67716 m
.86558 .62268 L
s
.9084 .67629 m
.94595 .67544 L
s
.9084 .67629 m
.90991 .62201 L
s
.94595 .67544 m
.9738 .67477 L
s
.94595 .67544 m
.94761 .62136 L
s
.9738 .67477 m
.97541 .62079 L
s
.0296 .62407 m
.05743 .62401 L
s
.0296 .62407 m
.02802 .57037 L
s
.05743 .62401 m
.09519 .62406 L
s
.05743 .62401 m
.05595 .57005 L
s
.09519 .62406 m
.13955 .62434 L
s
.09519 .62406 m
.09384 .56969 L
s
.13955 .62434 m
.18885 .62472 L
s
.13955 .62434 m
.1383 .56942 L
s
.18885 .62472 m
.24161 .62507 L
s
.18885 .62472 m
.18769 .56933 L
s
.24161 .62507 m
.29707 .62528 L
s
.24161 .62507 m
.24066 .56935 L
s
.29707 .62528 m
.35456 .62535 L
s
.29707 .62528 m
.29633 .56928 L
s
.35456 .62535 m
.41341 .6254 L
s
.35456 .62535 m
.35402 .56914 L
s
.41341 .6254 m
.47296 .62531 L
s
.41341 .6254 m
.41301 .56895 L
s
.47296 .62531 m
.53267 .62517 L
s
.47296 .62531 m
.47273 .56873 L
s
.53267 .62517 m
.59208 .62503 L
s
.53267 .62517 m
.53263 .56846 L
s
.59208 .62503 m
.65077 .62482 L
s
.59208 .62503 m
.59229 .56825 L
s
.65077 .62482 m
.70818 .62453 L
s
.65077 .62482 m
.65115 .56802 L
s
.70818 .62453 m
.76367 .62405 L
s
.70818 .62453 m
.70875 .56782 L
s
.76367 .62405 m
.81642 .62341 L
s
.76367 .62405 m
.76425 .56754 L
s
.81642 .62341 m
.86558 .62268 L
s
.81642 .62341 m
.81715 .56724 L
s
.86558 .62268 m
.90991 .62201 L
s
.86558 .62268 m
.86648 .56691 L
s
.90991 .62201 m
.94761 .62136 L
s
.90991 .62201 m
.91071 .56642 L
s
.94761 .62136 m
.97541 .62079 L
s
.94761 .62136 m
.94837 .56588 L
s
.97541 .62079 m
.97619 .56543 L
s
.02802 .57037 m
.05595 .57005 L
s
.02802 .57037 m
.02657 .51601 L
s
.05595 .57005 m
.09384 .56969 L
s
.05595 .57005 m
.0547 .51536 L
s
.09384 .56969 m
.1383 .56942 L
s
.09384 .56969 m
.09275 .51457 L
s
.1383 .56942 m
.18769 .56933 L
s
.1383 .56942 m
.13739 .51385 L
s
.18769 .56933 m
.24066 .56935 L
s
.18769 .56933 m
.18691 .51329 L
s
.24066 .56935 m
.29633 .56928 L
s
.24066 .56935 m
.23999 .51293 L
s
.29633 .56928 m
.35402 .56914 L
s
.29633 .56928 m
.29579 .51259 L
s
.35402 .56914 m
.41301 .56895 L
s
.35402 .56914 m
.35357 .51214 L
s
.41301 .56895 m
.47273 .56873 L
s
.41301 .56895 m
.41265 .51172 L
s
.47273 .56873 m
.53263 .56846 L
s
.47273 .56873 m
.47248 .51138 L
s
.53263 .56846 m
.59229 .56825 L
s
.53263 .56846 m
.53252 .51101 L
s
.59229 .56825 m
.65115 .56802 L
s
.59229 .56825 m
.59223 .51069 L
s
.65115 .56802 m
.70875 .56782 L
s
.65115 .56802 m
.65118 .51047 L
s
.70875 .56782 m
.76425 .56754 L
s
.70875 .56782 m
.70877 .51031 L
s
.76425 .56754 m
.81715 .56724 L
s
.76425 .56754 m
.76443 .51024 L
s
.81715 .56724 m
.86648 .56691 L
s
.81715 .56724 m
.81742 .5103 L
s
.86648 .56691 m
.91071 .56642 L
s
.86648 .56691 m
.86673 .5102 L
s
.91071 .56642 m
.94837 .56588 L
s
.91071 .56642 m
.91094 .50995 L
s
.94837 .56588 m
.97619 .56543 L
s
.94837 .56588 m
.94845 .50961 L
s
.97619 .56543 m
.9761 .50936 L
s
.02657 .51601 m
.0547 .51536 L
s
.02657 .51601 m
.02532 .4615 L
s
.0547 .51536 m
.09275 .51457 L
s
.0547 .51536 m
.05351 .46052 L
s
.09275 .51457 m
.13739 .51385 L
s
.09275 .51457 m
.0919 .45922 L
s
.13739 .51385 m
.18691 .51329 L
s
.13739 .51385 m
.13673 .45811 L
s
.18691 .51329 m
.23999 .51293 L
s
.18691 .51329 m
.18638 .45713 L
s
.23999 .51293 m
.29579 .51259 L
s
.23999 .51293 m
.23959 .45632 L
s
.29579 .51259 m
.35357 .51214 L
s
.29579 .51259 m
.29544 .45556 L
s
.35357 .51214 m
.41265 .51172 L
s
.35357 .51214 m
.35317 .45488 L
s
.41265 .51172 m
.47248 .51138 L
s
.41265 .51172 m
.41223 .45426 L
s
.47248 .51138 m
.53252 .51101 L
s
.47248 .51138 m
.47206 .45374 L
s
.53252 .51101 m
.59223 .51069 L
s
.53252 .51101 m
.53207 .45324 L
s
.59223 .51069 m
.65118 .51047 L
s
.59223 .51069 m
.59184 .45292 L
s
.65118 .51047 m
.70877 .51031 L
s
.65118 .51047 m
.65083 .45268 L
s
.70877 .51031 m
.76443 .51024 L
s
.70877 .51031 m
.70849 .45259 L
s
.76443 .51024 m
.81742 .5103 L
s
.76443 .51024 m
.76415 .45274 L
s
.81742 .5103 m
.86673 .5102 L
s
.81742 .5103 m
.81714 .45305 L
s
.86673 .5102 m
.91094 .50995 L
s
.86673 .5102 m
.86647 .45321 L
s
.91094 .50995 m
.94845 .50961 L
s
.91094 .50995 m
.9105 .45314 L
s
.94845 .50961 m
.9761 .50936 L
s
.94845 .50961 m
.94784 .45303 L
s
.9761 .50936 m
.97537 .45294 L
s
.02532 .4615 m
.05351 .46052 L
s
.02532 .4615 m
.02466 .40722 L
s
.05351 .46052 m
.0919 .45922 L
s
.05351 .46052 m
.05313 .40576 L
s
.0919 .45922 m
.13673 .45811 L
s
.0919 .45922 m
.0915 .40419 L
s
.13673 .45811 m
.18638 .45713 L
s
.13673 .45811 m
.13642 .40266 L
s
.18638 .45713 m
.23959 .45632 L
s
.18638 .45713 m
.18611 .40126 L
s
.23959 .45632 m
.29544 .45556 L
s
.23959 .45632 m
.23929 .39988 L
s
.29544 .45556 m
.35317 .45488 L
s
.29544 .45556 m
.29513 .39872 L
s
.35317 .45488 m
.41223 .45426 L
s
.35317 .45488 m
.35281 .39776 L
s
.41223 .45426 m
.47206 .45374 L
s
.41223 .45426 m
.41182 .39692 L
s
.47206 .45374 m
.53207 .45324 L
s
.47206 .45374 m
.47155 .39624 L
s
.53207 .45324 m
.59184 .45292 L
s
.53207 .45324 m
.53153 .3957 L
s
.59184 .45292 m
.65083 .45268 L
s
.59184 .45292 m
.59118 .39528 L
s
.65083 .45268 m
.70849 .45259 L
s
.65083 .45268 m
.65008 .39507 L
s
.70849 .45259 m
.76415 .45274 L
s
.70849 .45259 m
.70769 .3951 L
s
.76415 .45274 m
.81714 .45305 L
s
.76415 .45274 m
.76328 .39538 L
s
.81714 .45305 m
.86647 .45321 L
s
.81714 .45305 m
.81611 .39589 L
s
.86647 .45321 m
.9105 .45314 L
s
.86647 .45321 m
.8651 .39622 L
s
.9105 .45314 m
.94784 .45303 L
s
.9105 .45314 m
.90913 .3965 L
s
.94784 .45303 m
.97537 .45294 L
s
.94784 .45303 m
.94646 .39664 L
s
.97537 .45294 m
.97399 .3967 L
s
.02466 .40722 m
.05313 .40576 L
s
.02466 .40722 m
.02381 .35373 L
s
.05313 .40576 m
.0915 .40419 L
s
.05313 .40576 m
.05284 .35184 L
s
.0915 .40419 m
.13642 .40266 L
s
.0915 .40419 m
.09133 .3499 L
s
.13642 .40266 m
.18611 .40126 L
s
.13642 .40266 m
.13634 .34796 L
s
.18611 .40126 m
.23929 .39988 L
s
.18611 .40126 m
.18602 .34612 L
s
.23929 .39988 m
.29513 .39872 L
s
.23929 .39988 m
.23916 .34426 L
s
.29513 .39872 m
.35281 .39776 L
s
.29513 .39872 m
.29498 .34268 L
s
.35281 .39776 m
.41182 .39692 L
s
.35281 .39776 m
.3526 .34133 L
s
.41182 .39692 m
.47155 .39624 L
s
.41182 .39692 m
.41143 .3403 L
s
.47155 .39624 m
.53153 .3957 L
s
.47155 .39624 m
.47099 .33946 L
s
.53153 .3957 m
.59118 .39528 L
s
.53153 .3957 m
.53076 .3388 L
s
.59118 .39528 m
.65008 .39507 L
s
.59118 .39528 m
.59027 .33831 L
s
.65008 .39507 m
.70769 .3951 L
s
.65008 .39507 m
.64902 .33816 L
s
.70769 .3951 m
.76328 .39538 L
s
.70769 .3951 m
.70641 .33823 L
s
.76328 .39538 m
.81611 .39589 L
s
.76328 .39538 m
.76175 .33864 L
s
.81611 .39589 m
.8651 .39622 L
s
.81611 .39589 m
.8143 .33925 L
s
.8651 .39622 m
.90913 .3965 L
s
.8651 .39622 m
.8632 .33988 L
s
.90913 .3965 m
.94646 .39664 L
s
.90913 .3965 m
.90718 .34054 L
s
.94646 .39664 m
.97399 .3967 L
s
.94646 .39664 m
.94453 .34095 L
s
.97399 .3967 m
.97204 .34118 L
s
.02381 .35373 m
.05284 .35184 L
s
.02381 .35373 m
.02449 .30137 L
s
.05284 .35184 m
.09133 .3499 L
s
.05284 .35184 m
.05321 .29932 L
s
.09133 .3499 m
.13634 .34796 L
s
.09133 .3499 m
.09164 .29696 L
s
.13634 .34796 m
.18602 .34612 L
s
.13634 .34796 m
.13662 .29467 L
s
.18602 .34612 m
.23916 .34426 L
s
.18602 .34612 m
.18619 .29232 L
s
.23916 .34426 m
.29498 .34268 L
s
.23916 .34426 m
.23927 .28996 L
s
.29498 .34268 m
.3526 .34133 L
s
.29498 .34268 m
.29494 .288 L
s
.3526 .34133 m
.41143 .3403 L
s
.3526 .34133 m
.3524 .28633 L
s
.41143 .3403 m
.47099 .33946 L
s
.41143 .3403 m
.41106 .28504 L
s
.47099 .33946 m
.53076 .3388 L
s
.47099 .33946 m
.47034 .284 L
s
.53076 .3388 m
.59027 .33831 L
s
.53076 .3388 m
.52992 .28314 L
s
.59027 .33831 m
.64902 .33816 L
s
.59027 .33831 m
.58924 .28263 L
s
.64902 .33816 m
.70641 .33823 L
s
.64902 .33816 m
.64775 .28242 L
s
.70641 .33823 m
.76175 .33864 L
s
.70641 .33823 m
.70482 .28254 L
s
.76175 .33864 m
.8143 .33925 L
s
.76175 .33864 m
.75988 .28305 L
s
.8143 .33925 m
.8632 .33988 L
s
.8143 .33925 m
.81222 .28385 L
s
.8632 .33988 m
.90718 .34054 L
s
.8632 .33988 m
.86092 .28477 L
s
.90718 .34054 m
.94453 .34095 L
s
.90718 .34054 m
.90476 .28579 L
s
.94453 .34095 m
.97204 .34118 L
s
.94453 .34095 m
.94201 .28653 L
s
.97204 .34118 m
.96952 .287 L
s
.02449 .30137 m
.05321 .29932 L
s
.02449 .30137 m
.02554 .25087 L
s
.05321 .29932 m
.09164 .29696 L
s
.05321 .29932 m
.05407 .24855 L
s
.09164 .29696 m
.13662 .29467 L
s
.09164 .29696 m
.09229 .24588 L
s
.13662 .29467 m
.18619 .29232 L
s
.13662 .29467 m
.13713 .24329 L
s
.18619 .29232 m
.23927 .28996 L
s
.18619 .29232 m
.18663 .24032 L
s
.23927 .28996 m
.29494 .288 L
s
.23927 .28996 m
.23953 .23759 L
s
.29494 .288 m
.3524 .28633 L
s
.29494 .288 m
.29502 .23541 L
s
.3524 .28633 m
.41106 .28504 L
s
.3524 .28633 m
.35234 .23347 L
s
.41106 .28504 m
.47034 .284 L
s
.41106 .28504 m
.41086 .23199 L
s
.47034 .284 m
.52992 .28314 L
s
.47034 .284 m
.46988 .2304 L
s
.52992 .28314 m
.58924 .28263 L
s
.52992 .28314 m
.52905 .22942 L
s
.58924 .28263 m
.64775 .28242 L
s
.58924 .28263 m
.58802 .2288 L
s
.64775 .28242 m
.70482 .28254 L
s
.64775 .28242 m
.64618 .22858 L
s
.70482 .28254 m
.75988 .28305 L
s
.70482 .28254 m
.70289 .22869 L
s
.75988 .28305 m
.81222 .28385 L
s
.75988 .28305 m
.75757 .22924 L
s
.81222 .28385 m
.86092 .28477 L
s
.81222 .28385 m
.80958 .23019 L
s
.86092 .28477 m
.90476 .28579 L
s
.86092 .28477 m
.85809 .23147 L
s
.90476 .28579 m
.94201 .28653 L
s
.90476 .28579 m
.90187 .23273 L
s
.94201 .28653 m
.96952 .287 L
s
.94201 .28653 m
.93905 .23388 L
s
.96952 .287 m
.96651 .2346 L
s
.02554 .25087 m
.05407 .24855 L
s
.02554 .25087 m
.02679 .20277 L
s
.05407 .24855 m
.09229 .24588 L
s
.05407 .24855 m
.05514 .20034 L
s
.09229 .24588 m
.13713 .24329 L
s
.09229 .24588 m
.09332 .19737 L
s
.13713 .24329 m
.18663 .24032 L
s
.13713 .24329 m
.13795 .19442 L
s
.18663 .24032 m
.23953 .23759 L
s
.18663 .24032 m
.18727 .19104 L
s
.23953 .23759 m
.29502 .23541 L
s
.23953 .23759 m
.23997 .18793 L
s
.29502 .23541 m
.35234 .23347 L
s
.29502 .23541 m
.29526 .18539 L
s
.35234 .23347 m
.41086 .23199 L
s
.35234 .23347 m
.3523 .18317 L
s
.41086 .23199 m
.46988 .2304 L
s
.41086 .23199 m
.4105 .18115 L
s
.46988 .2304 m
.52905 .22942 L
s
.46988 .2304 m
.46922 .1794 L
s
.52905 .22942 m
.58802 .2288 L
s
.52905 .22942 m
.52809 .17827 L
s
.58802 .2288 m
.64618 .22858 L
s
.58802 .2288 m
.58664 .17757 L
s
.64618 .22858 m
.70289 .22869 L
s
.64618 .22858 m
.64447 .17747 L
s
.70289 .22869 m
.75757 .22924 L
s
.70289 .22869 m
.70073 .17748 L
s
.75757 .22924 m
.80958 .23019 L
s
.75757 .22924 m
.75504 .17811 L
s
.80958 .23019 m
.85809 .23147 L
s
.80958 .23019 m
.80677 .17921 L
s
.85809 .23147 m
.90187 .23273 L
s
.85809 .23147 m
.85502 .18076 L
s
.90187 .23273 m
.93905 .23388 L
s
.90187 .23273 m
.89862 .1823 L
s
.93905 .23388 m
.96651 .2346 L
s
.93905 .23388 m
.93569 .1837 L
s
.96651 .2346 m
.96308 .18469 L
s
.02679 .20277 m
.05514 .20034 L
s
.02679 .20277 m
.02875 .15781 L
s
.05514 .20034 m
.09332 .19737 L
s
.05514 .20034 m
.05713 .155 L
s
.09332 .19737 m
.13795 .19442 L
s
.09332 .19737 m
.09498 .15198 L
s
.13795 .19442 m
.18727 .19104 L
s
.13795 .19442 m
.13937 .14834 L
s
.18727 .19104 m
.23997 .18793 L
s
.18727 .19104 m
.1882 .14517 L
s
.23997 .18793 m
.29526 .18539 L
s
.23997 .18793 m
.24058 .14175 L
s
.29526 .18539 m
.3523 .18317 L
s
.29526 .18539 m
.29551 .13919 L
s
.3523 .18317 m
.4105 .18115 L
s
.3523 .18317 m
.35224 .13627 L
s
.4105 .18115 m
.46922 .1794 L
s
.4105 .18115 m
.41006 .13394 L
s
.46922 .1794 m
.52809 .17827 L
s
.46922 .1794 m
.46844 .13193 L
s
.52809 .17827 m
.58664 .17757 L
s
.52809 .17827 m
.52696 .13061 L
s
.58664 .17757 m
.64447 .17747 L
s
.58664 .17757 m
.58517 .12978 L
s
.64447 .17747 m
.70073 .17748 L
s
.64447 .17747 m
.64254 .12955 L
s
.70073 .17748 m
.75504 .17811 L
s
.70073 .17748 m
.69848 .12964 L
s
.75504 .17811 m
.80677 .17921 L
s
.75504 .17811 m
.75244 .13035 L
s
.80677 .17921 m
.85502 .18076 L
s
.80677 .17921 m
.80379 .13163 L
s
.85502 .18076 m
.89862 .1823 L
s
.85502 .18076 m
.85169 .13346 L
s
.89862 .1823 m
.93569 .1837 L
s
.89862 .1823 m
.89506 .13525 L
s
.93569 .1837 m
.96308 .18469 L
s
.93569 .1837 m
.93198 .13698 L
s
.96308 .18469 m
.95936 .13819 L
s
.02875 .15781 m
.05713 .155 L
s
.02875 .15781 m
.03119 .11714 L
s
.05713 .155 m
.09498 .15198 L
s
.05713 .155 m
.0592 .11421 L
s
.09498 .15198 m
.13937 .14834 L
s
.09498 .15198 m
.09688 .11068 L
s
.13937 .14834 m
.1882 .14517 L
s
.13937 .14834 m
.14088 .10681 L
s
.1882 .14517 m
.24058 .14175 L
s
.1882 .14517 m
.18944 .10331 L
s
.24058 .14175 m
.29551 .13919 L
s
.24058 .14175 m
.24145 .09992 L
s
.29551 .13919 m
.35224 .13627 L
s
.29551 .13919 m
.29591 .09693 L
s
.35224 .13627 m
.41006 .13394 L
s
.35224 .13627 m
.35216 .09388 L
s
.41006 .13394 m
.46844 .13193 L
s
.41006 .13394 m
.40961 .09123 L
s
.46844 .13193 m
.52696 .13061 L
s
.46844 .13193 m
.46768 .08909 L
s
.52696 .13061 m
.58517 .12978 L
s
.52696 .13061 m
.52591 .08759 L
s
.58517 .12978 m
.64254 .12955 L
s
.58517 .12978 m
.58376 .08672 L
s
.64254 .12955 m
.69848 .12964 L
s
.64254 .12955 m
.64071 .08639 L
s
.69848 .12964 m
.75244 .13035 L
s
.69848 .12964 m
.69638 .08651 L
s
.75244 .13035 m
.80379 .13163 L
s
.75244 .13035 m
.74995 .08728 L
s
.80379 .13163 m
.85169 .13346 L
s
.80379 .13163 m
.80088 .08869 L
s
.85169 .13346 m
.89506 .13525 L
s
.85169 .13346 m
.84841 .09063 L
s
.89506 .13525 m
.93198 .13698 L
s
.89506 .13525 m
.89145 .09267 L
s
.93198 .13698 m
.95936 .13819 L
s
.93198 .13698 m
.92819 .09479 L
s
.95936 .13819 m
.95559 .09626 L
s
.03119 .11714 m
.0592 .11421 L
s
.03119 .11714 m
.03389 .08247 L
s
.0592 .11421 m
.09688 .11068 L
s
.0592 .11421 m
.06185 .07899 L
s
.09688 .11068 m
.14088 .10681 L
s
.09688 .11068 m
.09915 .07511 L
s
.14088 .10681 m
.18944 .10331 L
s
.14088 .10681 m
.14272 .07108 L
s
.18944 .10331 m
.24145 .09992 L
s
.18944 .10331 m
.19078 .06749 L
s
.24145 .09992 m
.29591 .09693 L
s
.24145 .09992 m
.24227 .06415 L
s
.29591 .09693 m
.35216 .09388 L
s
.29591 .09693 m
.29631 .06099 L
s
.35216 .09388 m
.40961 .09123 L
s
.35216 .09388 m
.35218 .0579 L
s
.40961 .09123 m
.46768 .08909 L
s
.40961 .09123 m
.40924 .05506 L
s
.46768 .08909 m
.52591 .08759 L
s
.46768 .08909 m
.46699 .05281 L
s
.52591 .08759 m
.58376 .08672 L
s
.52591 .08759 m
.52494 .05132 L
s
.58376 .08672 m
.64071 .08639 L
s
.58376 .08672 m
.58245 .05024 L
s
.64071 .08639 m
.69638 .08651 L
s
.64071 .08639 m
.63912 .04975 L
s
.69638 .08651 m
.74995 .08728 L
s
.69638 .08651 m
.69445 .04984 L
s
.74995 .08728 m
.80088 .08869 L
s
.74995 .08728 m
.74771 .05069 L
s
.80088 .08869 m
.84841 .09063 L
s
.80088 .08869 m
.79841 .05215 L
s
.84841 .09063 m
.89145 .09267 L
s
.84841 .09063 m
.8456 .05408 L
s
.89145 .09267 m
.92819 .09479 L
s
.89145 .09267 m
.88825 .05628 L
s
.92819 .09479 m
.95559 .09626 L
s
.92819 .09479 m
.92466 .05868 L
s
.95559 .09626 m
.95198 .06046 L
s
.03389 .08247 m
.06185 .07899 L
s
.03389 .08247 m
.03598 .05678 L
s
.06185 .07899 m
.09915 .07511 L
s
.06185 .07899 m
.06364 .05291 L
s
.09915 .07511 m
.14272 .07108 L
s
.09915 .07511 m
.10064 .04886 L
s
.14272 .07108 m
.19078 .06749 L
s
.14272 .07108 m
.14392 .04467 L
s
.19078 .06749 m
.24227 .06415 L
s
.19078 .06749 m
.19165 .04125 L
s
.24227 .06415 m
.29631 .06099 L
s
.24227 .06415 m
.24286 .03787 L
s
.29631 .06099 m
.35218 .0579 L
s
.29631 .06099 m
.29665 .03424 L
s
.35218 .0579 m
.40924 .05506 L
s
.35218 .0579 m
.35225 .03115 L
s
.40924 .05506 m
.46699 .05281 L
s
.40924 .05506 m
.409 .02816 L
s
.46699 .05281 m
.52494 .05132 L
s
.46699 .05281 m
.46647 .02597 L
s
.52494 .05132 m
.58245 .05024 L
s
.52494 .05132 m
.52414 .02454 L
s
.58245 .05024 m
.63912 .04975 L
s
.58245 .05024 m
.58141 .0233 L
s
.63912 .04975 m
.69445 .04984 L
s
.63912 .04975 m
.63789 .02272 L
s
.69445 .04984 m
.74771 .05069 L
s
.69445 .04984 m
.693 .02279 L
s
.74771 .05069 m
.79841 .05215 L
s
.74771 .05069 m
.74607 .02371 L
s
.79841 .05215 m
.8456 .05408 L
s
.79841 .05215 m
.79652 .02516 L
s
.8456 .05408 m
.88825 .05628 L
s
.8456 .05408 m
.84347 .02701 L
s
.88825 .05628 m
.92466 .05868 L
s
.88825 .05628 m
.88581 .02928 L
s
.92466 .05868 m
.95198 .06046 L
s
.92466 .05868 m
.92184 .03174 L
s
.95198 .06046 m
.9489 .03377 L
s
.03598 .05678 m
.06364 .05291 L
s
.06364 .05291 m
.10064 .04886 L
s
.10064 .04886 m
.14392 .04467 L
s
.14392 .04467 m
.19165 .04125 L
s
.19165 .04125 m
.24286 .03787 L
s
.24286 .03787 m
.29665 .03424 L
s
.29665 .03424 m
.35225 .03115 L
s
.35225 .03115 m
.409 .02816 L
s
.409 .02816 m
.46647 .02597 L
s
.46647 .02597 m
.52414 .02454 L
s
.52414 .02454 m
.58141 .0233 L
s
.58141 .0233 m
.63789 .02272 L
s
.63789 .02272 m
.693 .02279 L
s
.693 .02279 m
.74607 .02371 L
s
.74607 .02371 m
.79652 .02516 L
s
.79652 .02516 m
.84347 .02701 L
s
.84347 .02701 m
.88581 .02928 L
s
.88581 .02928 m
.92184 .03174 L
s
.92184 .03174 m
.9489 .03377 L
s
.008 w
.04539 .91919 Mdot
.07275 .92058 Mdot
.10929 .92285 Mdot
.15216 .92489 Mdot
.19966 .92649 Mdot
.25054 .92743 Mdot
.3039 .92674 Mdot
.35937 .92814 Mdot
.41615 .92959 Mdot
.47361 .93024 Mdot
.53139 .93065 Mdot
.58885 .93113 Mdot
.64542 .93139 Mdot
.70055 .93124 Mdot
.75364 .93146 Mdot
.80404 .93131 Mdot
.85077 .9309 Mdot
.8929 .92968 Mdot
.92894 .92786 Mdot
.95574 .92593 Mdot
.04323 .894 Mdot
.07054 .89456 Mdot
.10752 .89715 Mdot
.15087 .8998 Mdot
.1986 .90145 Mdot
.24969 .90233 Mdot
.30332 .90277 Mdot
.35892 .90394 Mdot
.4159 .90494 Mdot
.47359 .90567 Mdot
.53159 .90608 Mdot
.5893 .90622 Mdot
.64612 .90623 Mdot
.70148 .90594 Mdot
.75478 .90579 Mdot
.80556 .90506 Mdot
.85261 .90437 Mdot
.89511 .90303 Mdot
.93154 .90123 Mdot
.95866 .89951 Mdot
.04095 .85998 Mdot
.0686 .86092 Mdot
.10557 .86266 Mdot
.14915 .86524 Mdot
.19713 .8671 Mdot
.24845 .86842 Mdot
.30233 .86927 Mdot
.35822 .87031 Mdot
.41548 .87101 Mdot
.47353 .87143 Mdot
.53174 .87187 Mdot
.58973 .87181 Mdot
.64695 .87139 Mdot
.70255 .87116 Mdot
.75632 .8705 Mdot
.80772 .8693 Mdot
.85506 .86853 Mdot
.89799 .8671 Mdot
.93476 .86547 Mdot
.96203 .86405 Mdot
.0385 .81986 Mdot
.06621 .82081 Mdot
.10342 .82239 Mdot
.14719 .82436 Mdot
.19535 .82618 Mdot
.24699 .82755 Mdot
.30127 .82849 Mdot
.35746 .82936 Mdot
.41499 .82998 Mdot
.47336 .83039 Mdot
.53188 .8306 Mdot
.59018 .83049 Mdot
.64784 .82996 Mdot
.70386 .82963 Mdot
.75808 .82876 Mdot
.80962 .82761 Mdot
.85764 .82642 Mdot
.90104 .82502 Mdot
.93802 .82358 Mdot
.96543 .82241 Mdot
.03598 .77524 Mdot
.06368 .77601 Mdot
.10104 .77724 Mdot
.14499 .77885 Mdot
.1935 .78042 Mdot
.24551 .78165 Mdot
.30012 .78248 Mdot
.35667 .78318 Mdot
.41459 .78363 Mdot
.47321 .784 Mdot
.53203 .78411 Mdot
.59063 .78403 Mdot
.6486 .78361 Mdot
.70524 .78304 Mdot
.75987 .78216 Mdot
.81178 .78103 Mdot
.8602 .7798 Mdot
.90391 .77853 Mdot
.94109 .77723 Mdot
.96854 .77625 Mdot
.03355 .72713 Mdot
.06128 .72763 Mdot
.09884 .72855 Mdot
.14291 .72976 Mdot
.19179 .73105 Mdot
.24407 .73201 Mdot
.29896 .73268 Mdot
.35587 .73318 Mdot
.41413 .73345 Mdot
.47315 .73367 Mdot
.53229 .73375 Mdot
.59116 .7337 Mdot
.64945 .73335 Mdot
.70638 .73279 Mdot
.76135 .732 Mdot
.81359 .7309 Mdot
.86237 .72979 Mdot
.90649 .7287 Mdot
.94378 .72758 Mdot
.97131 .72676 Mdot
.0314 .67646 Mdot
.0592 .67668 Mdot
.09691 .67714 Mdot
.14111 .678 Mdot
.19019 .67888 Mdot
.24276 .67953 Mdot
.29796 .67999 Mdot
.35517 .68029 Mdot
.41377 .68046 Mdot
.47311 .68053 Mdot
.53267 .68049 Mdot
.59179 .68043 Mdot
.6502 .68018 Mdot
.70737 .67975 Mdot
.76264 .67906 Mdot
.81517 .67815 Mdot
.86411 .67716 Mdot
.9084 .67629 Mdot
.94595 .67544 Mdot
.9738 .67477 Mdot
.0296 .62407 Mdot
.05743 .62401 Mdot
.09519 .62406 Mdot
.13955 .62434 Mdot
.18885 .62472 Mdot
.24161 .62507 Mdot
.29707 .62528 Mdot
.35456 .62535 Mdot
.41341 .6254 Mdot
.47296 .62531 Mdot
.53267 .62517 Mdot
.59208 .62503 Mdot
.65077 .62482 Mdot
.70818 .62453 Mdot
.76367 .62405 Mdot
.81642 .62341 Mdot
.86558 .62268 Mdot
.90991 .62201 Mdot
.94761 .62136 Mdot
.97541 .62079 Mdot
.02802 .57037 Mdot
.05595 .57005 Mdot
.09384 .56969 Mdot
.1383 .56942 Mdot
.18769 .56933 Mdot
.24066 .56935 Mdot
.29633 .56928 Mdot
.35402 .56914 Mdot
.41301 .56895 Mdot
.47273 .56873 Mdot
.53263 .56846 Mdot
.59229 .56825 Mdot
.65115 .56802 Mdot
.70875 .56782 Mdot
.76425 .56754 Mdot
.81715 .56724 Mdot
.86648 .56691 Mdot
.91071 .56642 Mdot
.94837 .56588 Mdot
.97619 .56543 Mdot
.02657 .51601 Mdot
.0547 .51536 Mdot
.09275 .51457 Mdot
.13739 .51385 Mdot
.18691 .51329 Mdot
.23999 .51293 Mdot
.29579 .51259 Mdot
.35357 .51214 Mdot
.41265 .51172 Mdot
.47248 .51138 Mdot
.53252 .51101 Mdot
.59223 .51069 Mdot
.65118 .51047 Mdot
.70877 .51031 Mdot
.76443 .51024 Mdot
.81742 .5103 Mdot
.86673 .5102 Mdot
.91094 .50995 Mdot
.94845 .50961 Mdot
.9761 .50936 Mdot
.02532 .4615 Mdot
.05351 .46052 Mdot
.0919 .45922 Mdot
.13673 .45811 Mdot
.18638 .45713 Mdot
.23959 .45632 Mdot
.29544 .45556 Mdot
.35317 .45488 Mdot
.41223 .45426 Mdot
.47206 .45374 Mdot
.53207 .45324 Mdot
.59184 .45292 Mdot
.65083 .45268 Mdot
.70849 .45259 Mdot
.76415 .45274 Mdot
.81714 .45305 Mdot
.86647 .45321 Mdot
.9105 .45314 Mdot
.94784 .45303 Mdot
.97537 .45294 Mdot
.02466 .40722 Mdot
.05313 .40576 Mdot
.0915 .40419 Mdot
.13642 .40266 Mdot
.18611 .40126 Mdot
.23929 .39988 Mdot
.29513 .39872 Mdot
.35281 .39776 Mdot
.41182 .39692 Mdot
.47155 .39624 Mdot
.53153 .3957 Mdot
.59118 .39528 Mdot
.65008 .39507 Mdot
.70769 .3951 Mdot
.76328 .39538 Mdot
.81611 .39589 Mdot
.8651 .39622 Mdot
.90913 .3965 Mdot
.94646 .39664 Mdot
.97399 .3967 Mdot
.02381 .35373 Mdot
.05284 .35184 Mdot
.09133 .3499 Mdot
.13634 .34796 Mdot
.18602 .34612 Mdot
.23916 .34426 Mdot
.29498 .34268 Mdot
.3526 .34133 Mdot
.41143 .3403 Mdot
.47099 .33946 Mdot
.53076 .3388 Mdot
.59027 .33831 Mdot
.64902 .33816 Mdot
.70641 .33823 Mdot
.76175 .33864 Mdot
.8143 .33925 Mdot
.8632 .33988 Mdot
.90718 .34054 Mdot
.94453 .34095 Mdot
.97204 .34118 Mdot
.02449 .30137 Mdot
.05321 .29932 Mdot
.09164 .29696 Mdot
.13662 .29467 Mdot
.18619 .29232 Mdot
.23927 .28996 Mdot
.29494 .288 Mdot
.3524 .28633 Mdot
.41106 .28504 Mdot
.47034 .284 Mdot
.52992 .28314 Mdot
.58924 .28263 Mdot
.64775 .28242 Mdot
.70482 .28254 Mdot
.75988 .28305 Mdot
.81222 .28385 Mdot
.86092 .28477 Mdot
.90476 .28579 Mdot
.94201 .28653 Mdot
.96952 .287 Mdot
.02554 .25087 Mdot
.05407 .24855 Mdot
.09229 .24588 Mdot
.13713 .24329 Mdot
.18663 .24032 Mdot
.23953 .23759 Mdot
.29502 .23541 Mdot
.35234 .23347 Mdot
.41086 .23199 Mdot
.46988 .2304 Mdot
.52905 .22942 Mdot
.58802 .2288 Mdot
.64618 .22858 Mdot
.70289 .22869 Mdot
.75757 .22924 Mdot
.80958 .23019 Mdot
.85809 .23147 Mdot
.90187 .23273 Mdot
.93905 .23388 Mdot
.96651 .2346 Mdot
.02679 .20277 Mdot
.05514 .20034 Mdot
.09332 .19737 Mdot
.13795 .19442 Mdot
.18727 .19104 Mdot
.23997 .18793 Mdot
.29526 .18539 Mdot
.3523 .18317 Mdot
.4105 .18115 Mdot
.46922 .1794 Mdot
.52809 .17827 Mdot
.58664 .17757 Mdot
.64447 .17747 Mdot
.70073 .17748 Mdot
.75504 .17811 Mdot
.80677 .17921 Mdot
.85502 .18076 Mdot
.89862 .1823 Mdot
.93569 .1837 Mdot
.96308 .18469 Mdot
.02875 .15781 Mdot
.05713 .155 Mdot
.09498 .15198 Mdot
.13937 .14834 Mdot
.1882 .14517 Mdot
.24058 .14175 Mdot
.29551 .13919 Mdot
.35224 .13627 Mdot
.41006 .13394 Mdot
.46844 .13193 Mdot
.52696 .13061 Mdot
.58517 .12978 Mdot
.64254 .12955 Mdot
.69848 .12964 Mdot
.75244 .13035 Mdot
.80379 .13163 Mdot
.85169 .13346 Mdot
.89506 .13525 Mdot
.93198 .13698 Mdot
.95936 .13819 Mdot
.03119 .11714 Mdot
.0592 .11421 Mdot
.09688 .11068 Mdot
.14088 .10681 Mdot
.18944 .10331 Mdot
.24145 .09992 Mdot
.29591 .09693 Mdot
.35216 .09388 Mdot
.40961 .09123 Mdot
.46768 .08909 Mdot
.52591 .08759 Mdot
.58376 .08672 Mdot
.64071 .08639 Mdot
.69638 .08651 Mdot
.74995 .08728 Mdot
.80088 .08869 Mdot
.84841 .09063 Mdot
.89145 .09267 Mdot
.92819 .09479 Mdot
.95559 .09626 Mdot
.03389 .08247 Mdot
.06185 .07899 Mdot
.09915 .07511 Mdot
.14272 .07108 Mdot
.19078 .06749 Mdot
.24227 .06415 Mdot
.29631 .06099 Mdot
.35218 .0579 Mdot
.40924 .05506 Mdot
.46699 .05281 Mdot
.52494 .05132 Mdot
.58245 .05024 Mdot
.63912 .04975 Mdot
.69445 .04984 Mdot
.74771 .05069 Mdot
.79841 .05215 Mdot
.8456 .05408 Mdot
.88825 .05628 Mdot
.92466 .05868 Mdot
.95198 .06046 Mdot
.03598 .05678 Mdot
.06364 .05291 Mdot
.10064 .04886 Mdot
.14392 .04467 Mdot
.19165 .04125 Mdot
.24286 .03787 Mdot
.29665 .03424 Mdot
.35225 .03115 Mdot
.409 .02816 Mdot
.46647 .02597 Mdot
.52414 .02454 Mdot
.58141 .0233 Mdot
.63789 .02272 Mdot
.693 .02279 Mdot
.74607 .02371 Mdot
.79652 .02516 Mdot
.84347 .02701 Mdot
.88581 .02928 Mdot
.92184 .03174 Mdot
.9489 .03377 Mdot
0 0 m
1 0 L
1 .95418 L
0 .95418 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  ImageSize->{288, 274.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014R000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00U@3oool2000000L0oooo<00000070?ooo`800000B@3oool007@0oooo0P0000070?ooob40
0000203oool2000000l0oooo00<000000?ooo`3oool0303oool2000000H0oooo:P00000X0?ooo`00
I03oool2000000L0oooo400000080?ooo`8000003`3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`/00000
103oool2000001L0oooo001D0?ooo`8000001`3oool@000000P0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P3o
ool>000000l0oooo00150?ooo`8000001P3oool@000000P0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03@3oool0
03H0oooo0P0000060?ooo`l00000203oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00d0oooo000X0?ooo`8000001P3oool>000000L0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo000L0?ooo`8000001@3oool=000000L0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool03@3oool001L0oooo300000060?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00D0ooooD000
00060?ooo`800000303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`003P3oool9000000D0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo0P000008
0?oooa000000203oool2000000l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3ooolJ000000H0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00090?oo
o`D00000103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool01@3ooolQ000000P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02P3oool2000000@0oooo300000040?oo
o`8000001`3oool00`000000oooo0?ooo`0<0?ooo`002P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool@000000P0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02@3oool2000000@0oooo3P00000>0?ooo`002P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00D0oooo3`0000080?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
303oool000X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0103oool?000000L0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00090?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`d000001`3oool2
000000d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00`0oooo00090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool;0000
00H0oooo0P00000<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00090?ooo`040000003oool0oooo0?oo
o`X000001@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0303oool000T0oooo100000040?ooo`8000002@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool000T0oooo0P0000060?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00d0oooo0P00000?0?ooo`8000003P3oool2000000d0oooo0P00000=0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool000T0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00H0ooooKP0000060?ooo`8000002`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3o
ool000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03@3oool2000000L0oooo4@0000080?ooo`030000003oool0
oooo00d0oooo0P00000?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo0P0000050?oooaT000001@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00090?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`8000001`3oool@0000
00P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo0P0000040?ooo`h000003@3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`050?oooal00000203oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`002@3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`040?ooo`l000001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool02`3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo2P0000070?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo0009
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool200000080oooo1P000003
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02`3oool000T0oooo00<000000?oo
o`3oool0103oool2000000@0oooo2@0000090?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool02`3oool000P0oooo3P0000050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0;0?ooo`002@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00X0oooo00090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3o
ool000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`002@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool20000
00P0ooooD00000070?ooo`800000303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`002@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0=0?ooo`8000001`3ooolR000000P0oooo00<000000?ooo`3oool03@3oool2000000l0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`8000001P3ooolK000000H0
oooo0P0000090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool000T0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo
0P0000070?oooa000000203oool2000000l0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`030?oooaX00000303oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`050?oooal00000203oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`00203oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`04
0?ooo`l000001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool02P3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00@0oooo3@0000070?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo00080?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool<000000H0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0:0?ooo`00203oool010000000oooo0?ooo`3oool:000000D0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0
oooo00070?ooo`D00000103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`00203oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00X0oooo00080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool02@3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?oo
o`00203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo00080?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool2000000l0oooo0P00000>0?ooo`800000
3P3oool2000000d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`00203o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo0P0000070?ooog0000001P3o
ool2000000/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00T0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00H0oooo8@0000080?ooo`8000003`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0103ooolR
000000<0oooo0P00000;0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo0P0000060?oooa400000203oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`8000002@3oool01000
0000oooo0?ooo`3oool5000000/0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo0P0000060?oo
o`l00000203oool2000000l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool000L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo0P0000050?ooo`l0
00001`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool02@3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?oooaT00000
1`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`090?ooo`001`3oool010000000oooo0?ooo`3oool:000000D0oooo
0P00000;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool000L0oooo1000
00040?ooo`8000002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool02@3oool000L0oooo0P0000060?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo00070?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool000L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`080?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`001`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool20000
00l0oooo0P0000070?oooc4000001`3oool2000000d0oooo0P00000=0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00P0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo0P0000070?oooc<00000203oool2000000l0
oooo00<000000?ooo`3oool03@3oool2000000H0oooo:`0000060?ooo`800000203oool2000000L0
oooo00<000000?ooo`3oool0203oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00D0oooo8@0000080?ooo`8000003`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00<0oooo6P00000:0?ooo`001`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0:0?ooo`8000001`3oool?000000P0oooo0P00000?0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo0007
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`09
0?ooo`8000001P3oool?000000L0oooo0P00000>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0203oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?oo
oaT000001`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`080?ooo`001P3oool2000000<0oooo2P0000050?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`00
1`3oool4000000@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0203oool000L0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`080?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00P0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool000L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`001`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00L0oooo00070?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01`3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`07
0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo0P00000?0?oo
o`8000003P3oool2000000l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00L0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool2000000L0ooooO`0000060?ooo`8000002@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`050?oooc800000203oool200000100oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
0`3ooolJ000000T0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo0P0000070?ooo`l00000203o
ool2000000l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01`3oool000L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo700000070?ooo`8000003P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00070?ooo`030000003oool0oooo
00@0oooo0P0000050?ooo``000001P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00L0oooo00060?ooo`l000001@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01`3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`070?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo0007
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool000L0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`070?ooo`001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00L0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1`3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`001P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00060?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01`3oool000H0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`8000003`3oool2000000l0oooo0P00000>0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`001P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`800000203ooonL000000@0oooo0P0000060?ooo`800000203oool000H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`8000001P3ooolR000000P0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool2000000`0oooo0P00000;0?ooo`030000003oool0oooo00<0oooo3P00
00080?ooo`001P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02@3oool2000000H0oooo7P0000080?ooo`8000003`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`07
0?ooo`001P3oool00`000000oooo0?ooo`050?ooo`8000001@3ooolI000000L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01`3oool000H0oooo3`0000050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`070?ooo`001P3oool2000000L0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1`3oool000H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`001P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00060?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01`3oool000H0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`070?ooo`001P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo
00060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool000H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01P3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`001`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`8000003`3oool2000000P0ooooO`0000060?ooo`800000203o
ool2000000H0oooo0P0000080?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`8000001`3ooom2
000000P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`8000003`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00<0oooo6P0000080?ooo`001`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo0P0000060?oooa`000001`3oool20000
00h0oooo0P00000?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00060?ooo`8000000`3ooolF000000H0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`001`3oool4000000@0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`060?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00070?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3o
ool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`001`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo0007
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00h0oooo0P00000?0?ooo`8000003`3oool2000000h0oooo0P00000>
0?ooo`8000003@3oool2000000d0oooo0P00000:0?ooo`8000002@3oool2000000H0oooo0P000007
0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo0P0000060?oo
old000001`3oool000L0oooo00<000000?ooo`3oool0103oool2000000D0oooo=`0000080?ooo`80
00003`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`060?ooo`001P3oool?000000D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01P3oool000L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00H0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool000L0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`001`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00H0oooo00070?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00070?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00D0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool000L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0
oooo0P00000>0?ooo`8000003`3oool2000000P0ooooVP0000070?ooo`001`3oool2000000H0oooo
0P0000040?ooofX00000203oool00`000000oooo0?ooo`0>0?ooo`8000003`3oool2000000l0oooo
0P00000?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0;0?ooo`8000002`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01@3oool000L0oooo3P0000050?ooo`8000002`3oool00`000000oooo0?oo
o`0;0?ooo`8000003@3oool2000000h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`050?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00070?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00080?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01@3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`050?ooo`00203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo0008
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool000P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`00203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo0P00000?0?ooo`800000
3`3oool2000000h0oooo0P00000>0?ooo`8000001`3ooolf000000L0oooo00070?ooom`000001`3o
ool00`000000oooo0?ooo`0;0?ooo`8000002`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01@3oool000P0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`070?ooo`8000002`3oool2000000`0oooo0P00000>0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo0P00000?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`00203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo
00080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool000P0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`00203oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01P3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`00203o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00080?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`060?ooo`00203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0
oooo00080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`001`3oool2000000H0oooo0P00
00090?ooo`8000002`3oool2000000d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0303oool2000000d0oooo0P00
00060?ooobP000001`3oool000P0ooooj@0000070?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool01`3oool2000000H0oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool2000000l0oooo0P00000?0?ooo`8000003`3oool2000000l0oooo0P00000?0?oo
o`8000003`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`060?ooo`00203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1P3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`00203oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool000P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`060?ooo`002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo
00090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool000T0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`002@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00H0oooo00090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01P3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`00203o
ool2000000L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool2000000P0oooo0P0000030?ooo`D00000203o
ool000T0oooo9P0000060?ooo`8000003P3oool2000000d0oooo0P00000?0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`8000003P3oool2
000000H0oooo<@0000040?ooo`030000003oool0oooo00H0oooo00090?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01`3oool2000000/0oooo00<000000?ooo`3oool0103ooonc0000
00L0oooo0P00000<0?ooo`8000002`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool2000000l0
oooo0P00000?0?ooo`8000003`3oool2000000l0oooo0P00000?0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01P3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`060?ooo`002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo0009
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool000T0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`060?ooo`002@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00L0oooo00090?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1`3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`002@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00090?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo
00090?ooo`@00000103oool2000000P0oooo0P00000<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02@3oool2000000@0oooo3`0000080?ooo`002@3oool200000080oooo<P000006
0?ooo`8000003P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo0P000007
0?ooobL000001@3oool2000000H0oooo0P0000080?ooo`002@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00D0ooooX`0000070?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01`3oool000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo0P00000?0?ooo`030000003oool0oooo00d0oooo0P00000?0?ooo`80
00003`3oool2000000l0oooo0P00000?0?ooo`030000003oool0oooo00d0oooo0P00000>0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`00
2@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00090?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01`3oool000T0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`070?ooo`002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00L0oooo000:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0203oool000X0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`002P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00P0oooo000:0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0203oool000X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?oo
o`002P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00P0oooo00090?ooo`l00000
103oool2000000/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00L0oooo0P0000030?ooo`D000002@3oool000X0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`030?oooaP000001P3oool2000000h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3o
ool2000000D0oooo8`0000030?ooo`8000002@3oool000X0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo0P0000050?oooch00000203oool2
000000l0oooo0P00000?0?ooo`8000003P3oool2000000l0oooo0P0000070?ooobd000001`3oool2
000000/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00P0oooo000:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3ooomD0000
00P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0203oool000X0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`080?ooo`002P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00P0oooo
000:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0203oool000/0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`002`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00P0oooo000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0203oool000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`002`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo000;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0203oool000X0oooo3P0000050?ooo`8000002`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`040?ooo`8000002P3oool000/0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`020?oooaT000001P3oool2000000d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0:0?ooo`8000001@3ooolJ000000X0oooo000;0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00@0oooo
;@0000070?ooo`8000003`3oool2000000l0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo00d0oooo0P00000>0?ooo`8000003@3oool2000000L0oooo
6`0000060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`080?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo0P00
000>0?ooo`030000003oool0oooo00D0ooooP`0000070?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0203oool000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00d0oooo0P00000?0?ooo`8000003`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool000/0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`080?ooo`002`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`002`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo000;0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool02@3oool000/0oooo100000040?ooo`8000002@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool000/0oooo
0P0000020?oooaD000001P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`8000002`3oool000/0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo3@00
00060?ooo`8000003P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02@3oool2000000@0oooo3P00000;0?ooo`002`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool2000000D0oooo?P000007
0?ooo`8000003`3oool2000000l0oooo00<000000?ooo`3oool03@3oool2000000l0oooo0P00000=
0?ooo`8000001`3ooolf000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`09
0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0303oool2000000h0oooo0P0000070?ooof800000203oool00`000000oooo0?ooo`0;0?oo
o`800000303oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`090?ooo`002`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00T0oooo000<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
2@3oool000`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`00303oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo000<0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool02P3oool000/0oooo3P0000050?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0080oooo300000060?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo
0P00000<0?ooo`00303oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo0P00
00050?oooa/000001`3oool2000000d0oooo0P00000?0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo0P00
00040?ooo`h00000303oool000`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`04
0?ooocl00000203oool2000000h0oooo0P00000?0?ooo`8000003P3oool2000000h0oooo0P00000=
0?ooo`8000001`3ooolV000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:
0?ooo`003@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool01@3ooomQ000000L0oooo00<000000?ooo`3oool02P3oool2000000X0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo000=0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool000d0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0;0?ooo`00303oool5000000<0oooo0P0000090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`003@3oool0
10000000oooo0?ooo`3oool9000000@0oooo0P00000;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool02`3oool001X0oooo600000060?ooo`8000003@3oool2000000d0oooo0P00000?
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`3o
ool5000000d0oooo000/0?ooo`030000003oool0oooo00<0ooooC@0000080?ooo`8000003P3oool2
000000l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`8000001@3ooolD
000000@0oooo00<000000?ooo`3oool02`3oool006L0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`050?ooog/000001P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
01<0oooo002Y0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0=P3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{81, 368}, {466.75, 193}} -> {-1.64328, 0.399309, \
0.00731963, 0.00731963}}]
}, Open  ]],

Cell[TextData[{
  "This tendency can be alleviated with the method option ",
  StyleBox["RepulsiveForcePower", "MR"],
  ", which is described ",
  ButtonBox["later",
    ButtonData:>"RepulsiveForcePower",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["High-dimensional embedding", "Subsubsection",
  CellTags->"high-dimensional embedding"],

Cell["\<\
In the high-dimensional embedding method, a graph is embedded in a \
high number of dimensions and then projected back linearly to two or three \
dimensions.\
\>", "Text"],

Cell[TextData[{
  "First, a ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-dimensional coordinate system is created based on ",
  StyleBox["k ",
    FontSlant->"Italic"],
  "centers. The centers are a set of ",
  StyleBox["k ",
    FontSlant->"Italic"],
  "vertices that are chosen to be as far apart as possible. The first vertex \
is selected at random, and then each of the remaining centers is chosen as \
the farthest vertex from the previously selected centers. In other words, if \
",
  StyleBox["j",
    FontSlant->"Italic"],
  " centers have been selected, ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["c", 
          RowBox[{
            StyleBox["j",
              FontSlant->"Italic"], 
            StyleBox["+",
              FontSlant->"Plain"], 
            StyleBox["1",
              FontSlant->"Plain"]}]], TraditionalForm]]],
  " is the vertex whose shortest distance to the ",
  StyleBox["j",
    FontSlant->"Italic"],
  " centers is larger than or equal to the shortest distance of all the other \
vertices to the ",
  StyleBox["j",
    FontSlant->"Italic"],
  " centers. "
}], "Text"],

Cell[TextData[{
  "Here, there are ",
  StyleBox["n",
    FontSlant->"Italic"],
  " ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-dimensional coordinate vectors, where ",
  StyleBox["n ",
    FontSlant->"Italic"],
  "is the total number of vertices in the graph. Each vertex ",
  Cell[BoxData[
      \(TraditionalForm\`u\_i\)]],
  " has the coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\_i\)\(=\)\)\)]],
  "{",
  Cell[BoxData[
      \(TraditionalForm\`d\_\(\(u\_i\) c\_1\), \ 
      d\_\(\(u\_i\) c\_2\),  ... , \ d\_\(\(u\_i\) c\_k\)\)]],
  "}, where ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["d", 
          RowBox[{\(u\_i\), 
            SubscriptBox[
              StyleBox["c",
                FontSlant->"Italic"], "j"]}]], TraditionalForm]]],
  "is the graph distance between the vertex ",
  Cell[BoxData[
      \(TraditionalForm\`u\_i\)]],
  " and the center ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  ". The ",
  StyleBox["n",
    FontSlant->"Italic"],
  " ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-dimensional coordinate vectors form an ",
  StyleBox["n",
    FontSlant->"Italic"],
  " \[Times] ",
  StyleBox["k",
    FontSlant->"Italic"],
  " matrix ",
  StyleBox["X, ",
    FontSlant->"Italic"],
  StyleBox["where ",
    FontVariations->{"CompatibilityType"->0}],
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " is",
  StyleBox[" the ",
    FontVariations->{"CompatibilityType"->0}],
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  StyleBox["-th row of ",
    FontVariations->{"CompatibilityType"->0}],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  "."
}], "Text"],

Cell["\<\
Since it is only possible to draw in two and three dimensions, and \
since the coordinates are correlated, the coordinates are projected back to \
two or three dimensions by a suitable linear combination.\
\>", "Text"],

Cell[TextData[{
  "Here, the graph with ",
  StyleBox["n",
    FontSlant->"Italic"],
  " coordinates and ",
  StyleBox["k",
    FontSlant->"Italic"],
  " centers is projected back to 2 dimensions. To make this projection \
shift-invariant, ",
  StyleBox["X",
    FontSlant->"Italic"],
  " is first normalized to ",
  Cell[BoxData[
      \(TraditionalForm\`\(X\^'\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "      ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(X\^'\)\(=\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`X\  - \ e\ e\^T\ X/n, \ e\  = \ {1,  ... , 1}\)]]
}], "Text"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1\ and\ v\_2\)]],
  " be two ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-dimensional linear combination vectors. The two linear combinations \
should be uncorrelated, so they must be orthogonal to each other."
}], "Text"],

Cell[TextData[{
  "      ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(X\^'\)\ v\_1)\)\^T\ \(X\^'\)\ v\_2\  = \ \(v\_1\
\^T\ \((X\^\(\('\) \(T\)\)\ \(X\^'\))\)\ v\_2\  = \ 0\)\)]]
}], "Text"],

Cell["Each must be as far away from 0 as possible. ", "Text"],

Cell[TextData[{
  "       ",
  Cell[BoxData[
      \(TraditionalForm\`v\_i\^T\ \((X\^\(\('\) \(T\)\)\ \(X\^'\))\)\ \
\(\(v\_i\)\(\ \)\(/\)\)\  || v\_i\( || \^2\)\  \[Rule] \ max, \ \ i\  = \ 
        1, \ 2\)]]
}], "Text"],

Cell[TextData[{
  "To achieve this, let ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  " be the two eigenvectors that correspond to the first two largest \
eigenvalues of the ",
  StyleBox["k",
    FontSlant->"Italic"],
  " x ",
  StyleBox["k",
    FontSlant->"Italic"],
  " symmetric matrix ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(X\^\(\('\) \(T\)\)\), 
          SuperscriptBox[
            StyleBox["X",
              FontSlant->"Italic"], "'"]}], TraditionalForm]]],
  ". This process of choosing two highly uncorrelated vectors is also known \
as principal component analysis."
}], "Text"],

Cell[TextData[{
  "For the purpose of drawing the graph in two dimensions, the coordinates of \
the vertices are given by ",
  Cell[BoxData[
      \(TraditionalForm\`\(X\^'\) v\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(X\^'\) \(\(v\_2\)\(.\)\)\)]]
}], "Text"],

Cell["\<\
The high-dimensional embedding method tends to be very fast but its \
results are often of lower quality than force-directed algorithms.\
\>", \
"Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms for drawing trees", "Subsubsection",
  CellTags->"trees"],

Cell[TextData[{
  "If the graph represents a tree, algorithms that are designed to draw trees \
are more suitable. Two such algorithms are the radial drawing algorithm and \
the layered drawing algorithm ",
  ButtonBox["[1]",
    ButtonData:>"[1]",
    ButtonStyle->"Hyperlink"],
  ". In the radial drawing algorithm, a reasonable root of the tree is \
chosen. Then, starting from that root of the tree, each sub-tree is drawn \
inside a wedge, with the angle of the wedge proportional to the number of \
leaves in that sub-tree. In the layered drawing algorithm, a reasonable root \
of the tree is chosen. Then, starting from that root, sub-trees of the root \
are recursively drawn such that vertices on the same level have the same ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " coordinate, and the horizontally closest vertices of adjacent sub-trees \
are of unit distance apart. The root is placed at the center of the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-coordinates of its sub-trees and its ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-coordinate is ",
  "one unit above them."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for GraphPlot/GraphPlot3D", "Subsection",
  CellTags->"Options_for_GraphPlot"],

Cell[TextData[{
  "In addition to options for ",
  StyleBox["Graphics", "MR"],
  StyleBox[" and ", "TR"],
  StyleBox["Graphics3D", "MR"],
  ", the following options are accepted."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI"],
              StyleBox[" ", "TI"]
            }]], Cell[TextData[{
              StyleBox["default value", "TI"],
              StyleBox[" ", "TI"]
            }]], Cell[""]},
          {Cell[TextData[StyleBox["Method", "MR"]]], Cell[TextData[StyleBox[
            "Automatic ", "MR"]]], 
            StyleBox[\(method\ used\ to\ lay\ out\ the\ graph\),
              "TR"]},
          {Cell[TextData[StyleBox["VertexStyleFunction", "MR"]]], Cell[
            TextData[{
              StyleBox["None", "MR"],
              " "
            }]], 
            
            StyleBox[\(style\ function\ describing\ how\ vertices\ are\ drawn\
\),
              "TR"]},
          {Cell[TextData[StyleBox["EdgeStyleFunction", "MR"]]], Cell[
            TextData[{
              StyleBox["None", "MR"],
              " "
            }]], 
            StyleBox[\(style\ function\ describing\ how\ edges\ are\ drawn\),
              "TR"]},
          {Cell[TextData[{
              StyleBox["PlotStyle", "MR"],
              StyleBox[" ", "MR"]
            }]], Cell[TextData[StyleBox["Automatic", "MR"]]], Cell[
            "style in which objects are drawn"]},
          {Cell[TextData[{
              StyleBox["RandomSeed", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              
              "random seed used for initial vertex placement in the spring \
model and the spring\[Hyphen]electrical model, and for selecting the first of \
the ",
              StyleBox["k",
                FontSlant->"Italic"],
              " centers in the high\[Hyphen]dimensional embedding method"
            }]]},
          {
            StyleBox["VertexCoordinates",
              "MR"], 
            StyleBox["None",
              "MR"], \(user\[Hyphen]supplied\ vertex\ coordinates\)}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{RowLines->{True, False}}],

Cell[TextData[{
  "Options for ",
  StyleBox["GraphPlot", "MR"],
  " and ",
  StyleBox["GraphPlot3D", "MR"],
  "."
}], "Caption"],

Cell[CellGroupData[{

Cell["Method", "SubsubsectionIcon"],

Cell[TextData[{
  StyleBox["GraphPlot", "MR"],
  StyleBox[" and ", "TR"],
  StyleBox["GraphPlot3D", "MR"],
  StyleBox[" have several methods available. The method is specified by the ",
     "TR"],
  StyleBox["Method", "MR"],
  StyleBox[" option, which either takes the method given as a string or a \
list whose first element is the method (given as a string) and whose \
remaining elements are method-specific options. All method-specific options \
should also be given as strings.", "TR"]
}], "Text"],

Cell[TextData[{
  "The following are valid values of the ",
  StyleBox["Method", "MR"],
  " option."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["Automatic", "MR"]]], 
            Cell["\<\
specifies that a method suitable for the problem should \
be chosen automatically. The default method is usually good enough for most \
cases.\
\>"]},
          {Cell[TextData[{
              StyleBox["\"SpringModel\"", "MR"],
              " "
            }]], Cell[TextData[{
              "invokes the ",
              ButtonBox["spring model",
                ButtonData:>"spring model",
                ButtonStyle->"Hyperlink"],
              
              ", in which a vertex is subject to either attractive or \
repulsive force from another vertex, as though they are connected by a \
spring. The spring has an ideal length equal to the graph distance between",
              StyleBox[" ",
                FontSlant->"Italic"],
              "the vertices. The total spring energy is minimized."
            }]]},
          {Cell[TextData[{
              StyleBox["\"SpringElectricalModel\"", "MR"],
              " "
            }]], Cell[TextData[{
              "invokes the ",
              ButtonBox["spring-electrical model",
                ButtonData:>"spring-electrical model",
                ButtonStyle->"Hyperlink"],
              
              ", in which neighboring vertices are subject to an attractive \
spring force that is proportional to their physical distance, and all \
vertices are subject to a repulsive electrical force that is inversely \
proportional to their distance. The overall energy is minimzed."
            }]]},
          {Cell[TextData[{
              StyleBox["\"HighDimensionalEmbedding\"", "MR"],
              ButtonBox[" ",
                ButtonData:>"high-dimensional embedding",
                ButtonStyle->"Hyperlink"]
            }]], Cell[TextData[{
              "invokes the ",
              ButtonBox["high-dimensional embedding",
                ButtonData:>"high-dimensional embedding",
                ButtonStyle->"Hyperlink"],
              
              " method, in which the graph is first laid out in a \
high-dimensional space based on the graph distances of the vertices to ",
              StyleBox["k",
                FontSlant->"Italic"],
              
              " centers. This layout is then projected to two- or \
three-dimensional space by linear combination of the high-dimensional \
coordinates using principal component analysis."
            }]]},
          {Cell[TextData[{
              StyleBox["\"RadialDrawing\"", "MR"],
              ButtonBox[" ",
                ButtonData:>"trees",
                ButtonStyle->"Hyperlink"]
            }]], Cell[TextData[{
              "invokes the ",
              ButtonBox["radial drawing method",
                ButtonData:>"trees",
                ButtonStyle->"Hyperlink"],
              
              ", which is most suitable for tree graphs or tree-like graphs. \
If the graph is not a tree, a spanning tree is first constructed, and a \
radial drawing of the spanning tree is used to derive the drawing for the \
graph. "
            }]]},
          {
            StyleBox[Cell[TextData[{
                StyleBox["\"LayeredDrawing\"", "MR"],
                ButtonBox[" ",
                  ButtonData:>"trees",
                  ButtonStyle->"Hyperlink"]
              }]],
              "MR"], Cell[TextData[{
              "invokes the ",
              ButtonBox["layered drawing method",
                ButtonData:>"trees",
                ButtonStyle->"Hyperlink"],
              
              ", which is most suitable for tree graphs or tree-like graphs. \
If the graph is not a tree, a spanning tree is first constructed, and a \
layered drawing of the spanning tree is used to derive the drawing for the \
graph."
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnEvenTable"]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexStyleFunction", "SubsubsectionIcon"],

Cell[TextData[{
  "Possible values for this option are ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["None", "MR"],
  ", or a user-supplied function. The user-supplied function should be of the \
form ",
  StyleBox["f[i_]:=\[Ellipsis]", "MR"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " is a vertex index."
}], "Text"],

Cell[TextData[{
  "By default, ",
  StyleBox["VertexStyleFunction", "MR"],
  StyleBox[" is set to ", "TR"],
  StyleBox["None", "MR"],
  ". A point is drawn for each vertex, but the point is not labeled. If ",
  StyleBox["VertexStyleFunction", "MR"],
  StyleBox[" is set to ", "TR"],
  StyleBox["Automatic", "MR"],
  ", a point and a label are drawn for each vertex when graphs are small. "
}], "Text"],

Cell["\<\
Sometimes it is convenient to be able to define a custom style. In \
this example, vertices are plotted as red disks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[{1 \[Rule] 2, 1 \[Rule] 3, 1 \[Rule] 4, 2 \[Rule] 3, 
          2 \[Rule] 4, 3 \[Rule] 5, 4 \[Rule] 6, 5 \[Rule] 7, 5 \[Rule] 8, 
          6 \[Rule] 7, 6 \[Rule] 8, 7 \[Rule] 8}, \ 
        VertexStyleFunction \[Rule] \(({Hue[0], 
                Disk[#, 0.03]} &)\)];\)\)], "Input",
  CellLabel->"In[12]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .40855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.49983 0.462486 0.20422 0.462486 [
[ 0 0 0 0 ]
[ 1 .40855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.96232 .29338 m
.96227 .11511 L
s
.96232 .29338 m
.71029 .38468 L
s
.96232 .29338 m
.71088 .02364 L
s
.96227 .11511 m
.71029 .38468 L
s
.96227 .11511 m
.71088 .02364 L
s
.71029 .38468 m
.28897 .38495 L
s
.71088 .02364 m
.28928 .0236 L
s
.28897 .38495 m
.0377 .11472 L
s
.28897 .38495 m
.03768 .29332 L
s
.28928 .0236 m
.0377 .11472 L
s
.28928 .0236 m
.03768 .29332 L
s
.0377 .11472 m
.03768 .29332 L
s
1 0 0 r
.96232 .29338 m
.96232 .29338 .01387 0 365.73 arc
F
.96227 .11511 m
.96227 .11511 .01387 0 365.73 arc
F
.71029 .38468 m
.71029 .38468 .01387 0 365.73 arc
F
.71088 .02364 m
.71088 .02364 .01387 0 365.73 arc
F
.28897 .38495 m
.28897 .38495 .01387 0 365.73 arc
F
.28928 .0236 m
.28928 .0236 .01387 0 365.73 arc
F
.0377 .11472 m
.0377 .11472 .01387 0 365.73 arc
F
.03768 .29332 m
.03768 .29332 .01387 0 365.73 arc
F
0 0 m
1 0 L
1 .40855 L
0 .40855 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{288, 117.625},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000MB000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00D03oool60?l007<0oooo1@3o
001B0?ooo`00D03oool70?l00740oooo1`3o001A0?ooo`00C`3oool80?l00700oooo203o001A0?oo
o`00D03oool70?l0074000001`3o001A0?ooo`00C`3oool00`000000o`000?l000050?l00740oooo
1`3o00000`000000oooo0?ooo`1>0?ooo`00C@3oool2000000030?ooo`3o0000o`0000@0o`00LP3o
ool60?l00080oooo0P00001>0?ooo`00BP3oool3000000<0oooo00<000000?ooo`3o00000P3o001e
0?ooo`<0o`0000<0oooo0000003oool00P3oool3000004/0oooo00170?ooo`<000001@3oool00`00
0000oooo0?ooo`1m0?ooo`030000003oool0oooo00<0oooo0`0000180?ooo`00A03oool3000000L0
oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`050?ooo`<00000A@3oool00440oooo
0`0000090?ooo`030000003oool0oooo0840oooo00<000000?ooo`3oool01`3oool2000004<0oooo
000o0?ooo`8000002`3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo00P0oooo0`00
00100?ooo`00?03oool3000000d0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`0;
0?ooo`<00000?@3oool003T0oooo0`00000?0?ooo`030000003oool0oooo08D0oooo00<000000?oo
o`3oool03@3oool3000003X0oooo000f0?ooo`<000004@3oool00`000000oooo0?ooo`270?ooo`03
0000003oool0oooo00l0oooo0`00000g0?ooo`00=03oool2000001<0oooo00<000000?ooo`3oool0
R@3oool00`000000oooo0?ooo`0A0?ooo`800000=@3oool00340oooo0`00000D0?ooo`030000003o
ool0oooo08/0oooo00<000000?ooo`3oool04P3oool300000380oooo000^0?ooo`<000005P3oool0
0`000000oooo0?ooo`2=0?ooo`030000003oool0oooo01@0oooo0`00000_0?ooo`00:`3oool30000
01P0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`0F0?ooo`<00000;03oool002T0
oooo0P00000J0?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool0603oool2000002X0
oooo000V0?ooo`<000006`3oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo01T0oooo
0`00000W0?ooo`008`3oool3000001d0oooo00<000000?ooo`3oool0U@3oool00`000000oooo0?oo
o`0K0?ooo`<00000903oool00200oooo0`00000O0?ooo`030000003oool0oooo09L0oooo00<00000
0?ooo`3oool07@3oool300000240oooo000M0?ooo`<000008@3oool00`000000oooo0?ooo`2I0?oo
o`030000003oool0oooo01l0oooo0P00000O0?ooo`006`3oool2000002<0oooo00<000000?ooo`3o
ool0V`3oool00`000000oooo0?ooo`0P0?ooo`<00000703oool001P0oooo0`00000T0?ooo`030000
003oool0oooo09d0oooo00<000000?ooo`3oool08P3oool3000001T0oooo000E0?ooo`<000009P3o
ool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo02@0oooo0`00000F0?ooo`00203oool6
0?l000@0oooo0`00000X0?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool09P3oool3
000000<0oooo1P3o000:0?ooo`00203oool70?l000030?ooo`000000000002/0oooo00<000000?oo
o`3oool0X@3oool00`000000oooo0?ooo`0Y0?ooo`80000000<0oooo0?l0003o00001@3o00090?oo
o`001`3oool80?l000030000003oool0oooo02X0oooo00<000000?ooo`3oool0X`3oool00`000000
oooo0?ooo`0Z0?ooo`030000003o0000o`0000D0o`002@3oool000P0oooo1`3o000/0?ooo`030000
003oool0oooo0:D0oooo00<000000?ooo`3oool0:@3oool80?l000T0oooo00080?ooo`L0o`00:`3o
ool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo02T0oooo1`3o00090?ooo`00203oool6
0?l002/0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`0X0?ooo`L0o`002@3oool0
00X0oooo0`3o00000`3oool000000?ooo`0X0?ooo`030000003oool0oooo0:/0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?l000030?l000X0oooo000;0?ooo`050000003oool0oooo0?oo
o`0000009`3oool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo02D0oooo00D000000?oo
o`3oool0oooo0000000<0?ooo`002`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`2c0?ooo`030000003oool0oooo01l0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0]@3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool000/0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0;L0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo000;0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`2i0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0:0?oo
o`002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0^`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool02P3oool000/0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo0;d0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`2m0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0<40oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`330?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0a@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool000/0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0<L0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00X0oooo000;
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`39
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0:
0?ooo`002`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0b`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool02P3oool000/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0<d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`3?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`0C0?ooo`050000003o
ool0oooo0?ooo`000000d`3oool01@000000oooo0?ooo`3oool0000001D0oooo00<000000?ooo`3o
ool02P3oool000/0oooo00<000000?ooo`3oool04`3oool010000000oooo0?ooo`00003E0?ooo`04
0000003oool0oooo000001D0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3o
ool0503oool200000=L0oooo0P00000F0?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000
003oool0oooo01@0oooo0P00003G0?ooo`8000005P3oool00`000000oooo0?ooo`0:0?ooo`002`3o
ool00`000000oooo0?ooo`0C0?ooo`040000003oool0oooo00000=D0oooo00@000000?ooo`3oool0
00005@3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`0C0?ooo`050000
003oool0oooo0?ooo`000000d`3oool01@000000oooo0?ooo`3oool0000001D0oooo00<000000?oo
o`3oool02P3oool000/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0<l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`3=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0b`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0<T0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`370?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0a@3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02P3oool000/0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0<<0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo
000;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`310?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`0:0?ooo`002`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0_`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo0;d0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`2m0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0^`3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0;T0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`2g0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0]@3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool000/0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0;<0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00X0
oooo000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`2a0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool0[`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool02P3oool000/0oooo00D000000?ooo`3oool0oooo0000000W0?ooo`030000003o
ool0oooo0:d0oooo00<000000?ooo`3oool09@3oool01@000000oooo0?ooo`3oool0000000`0oooo
00080?ooo`H0o`0000<000000?ooo`3oool09`3oool00`000000oooo0?ooo`2[0?ooo`030000003o
ool0oooo02L0oooo1P3o000:0?ooo`00203oool70?l002X0oooo00<000000?ooo`3oool0Z@3oool0
0`000000oooo0?ooo`0X0?ooo`L0o`002@3oool000L0oooo203o000[0?ooo`030000003oool0oooo
0:L0oooo00<000000?ooo`3oool0:03oool80?l000T0oooo00080?ooo`L0o`00;03oool00`000000
oooo0?ooo`2U0?ooo`030000003oool0oooo02X0oooo1`3o00090?ooo`00203oool70?l000030000
003oool0oooo02X0oooo00<000000?ooo`3oool0X`3oool00`000000oooo0?ooo`0Z0?ooo`030000
003o0000o`0000D0o`002@3oool000P0oooo1P3o00020?ooo`800000:`3oool00`000000oooo0?oo
o`2Q0?ooo`030000003oool0oooo02T0oooo0P0000000`3oool0o`000?l000040?l000X0oooo000:
0?ooo`<0o`001@3oool3000002P0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`0V
0?ooo`<000001@3oool30?l000/0oooo000E0?ooo`<000009P3oool00`000000oooo0?ooo`2O0?oo
o`030000003oool0oooo02@0oooo0`00000F0?ooo`00603oool3000002@0oooo00<000000?ooo`3o
ool0W@3oool00`000000oooo0?ooo`0R0?ooo`<000006@3oool001/0oooo0P00000S0?ooo`030000
003oool0oooo09/0oooo00<000000?ooo`3oool0803oool3000001`0oooo000M0?ooo`<000008@3o
ool00`000000oooo0?ooo`2I0?ooo`030000003oool0oooo01l0oooo0P00000O0?ooo`00803oool3
000001l0oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0M0?ooo`<000008@3oool0
02<0oooo0`00000M0?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3oool06`3oool30000
02@0oooo000V0?ooo`<000006`3oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo01T0
oooo0`00000W0?ooo`00:@3oool2000001X0oooo00<000000?ooo`3oool0T@3oool00`000000oooo
0?ooo`0H0?ooo`800000:P3oool002/0oooo0`00000H0?ooo`030000003oool0oooo08l0oooo00<0
00000?ooo`3oool05P3oool3000002`0oooo000^0?ooo`<000005P3oool00`000000oooo0?ooo`2=
0?ooo`030000003oool0oooo01@0oooo0`00000_0?ooo`00<@3oool3000001@0oooo00<000000?oo
o`3oool0R`3oool00`000000oooo0?ooo`0B0?ooo`<00000<P3oool003@0oooo0P00000C0?ooo`03
0000003oool0oooo08T0oooo00<000000?ooo`3oool04@3oool2000003D0oooo000f0?ooo`<00000
4@3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo00l0oooo0`00000g0?ooo`00>@3o
ool3000000l0oooo00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`0=0?ooo`<00000>P3o
ool003`0oooo0`00000=0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3oool02`3oool3
000003d0oooo000o0?ooo`8000002`3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo
00P0oooo0`0000100?ooo`00@@3oool3000000T0oooo00<000000?ooo`3oool0P@3oool00`000000
oooo0?ooo`070?ooo`800000@`3oool004@0oooo0`0000070?ooo`030000003oool0oooo07l0oooo
00<000000?ooo`3oool01@3oool3000004D0oooo00170?ooo`<000001@3oool00`000000oooo0?oo
o`1m0?ooo`030000003oool0oooo00<0oooo0`0000180?ooo`00BP3oool3000000<0oooo1P3o001b
0?ooo`H0o`0000@000000?ooo`3oool0oooo0`00001;0?ooo`00C@3oool2000000030?ooo`3o0000
o`0000D0o`00L@3oool70?l000030?ooo`000000000004h0oooo001?0?ooo`030000003o0000o`00
00D0o`00L03oool80?l000030000003oool0oooo04h0oooo001?0?ooo`P0o`00L@0000070?l00540
oooo001@0?ooo`L0o`00L@3oool70?l00540oooo001@0?ooo`L0o`00L@3oool70?l00540oooo001B
0?ooo`@0o`00M03oool40?l00580oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
0000\
\>"],
  ImageRangeCache->{{{81, 368}, {212.563, 95.9375}} -> {-1.70013, 0.285113, \
0.00757459, 0.00757459}}]
}, Open  ]],

Cell[TextData[{
  "To draw no vertices at all, define ",
  StyleBox["VertexStyleFunction", "MR"],
  " to be the empty list."
}], "Text"],

Cell[BoxData[
    \(\(a = 
        Import["\<LinearAlgebraExamples/Data/gr_30_30.rsa\>", \
"\<HarwellBoeing\>"];\)\)], "Input",
  CellLabel->"In[13]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GraphPlot[a, \ VertexStyleFunction \[Rule] \(({} &)\)];\)\)], "Input",\

  CellLabel->"In[14]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81594 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.501476 0.477666 0.413073 0.477666 [
[ 0 0 0 0 ]
[ 1 .81594 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.54299 .79651 m
.53687 .78899 L
s
.54299 .79651 m
.54766 .79198 L
s
.54299 .79651 m
.54137 .78528 L
s
.53687 .78899 m
.52709 .78142 L
s
.53687 .78899 m
.54766 .79198 L
s
.53687 .78899 m
.54137 .78528 L
s
.53687 .78899 m
.53171 .77569 L
s
.52709 .78142 m
.51515 .771 L
s
.52709 .78142 m
.54137 .78528 L
s
.52709 .78142 m
.53171 .77569 L
s
.52709 .78142 m
.51972 .76572 L
s
.51515 .771 m
.5018 .75807 L
s
.51515 .771 m
.53171 .77569 L
s
.51515 .771 m
.51972 .76572 L
s
.51515 .771 m
.50616 .75318 L
s
.5018 .75807 m
.4867 .74531 L
s
.5018 .75807 m
.51972 .76572 L
s
.5018 .75807 m
.50616 .75318 L
s
.5018 .75807 m
.49093 .74015 L
s
.4867 .74531 m
.46991 .73308 L
s
.4867 .74531 m
.50616 .75318 L
s
.4867 .74531 m
.49093 .74015 L
s
.4867 .74531 m
.47412 .72807 L
s
.46991 .73308 m
.45205 .7197 L
s
.46991 .73308 m
.49093 .74015 L
s
.46991 .73308 m
.47412 .72807 L
s
.46991 .73308 m
.45617 .7151 L
s
.45205 .7197 m
.4333 .70568 L
s
.45205 .7197 m
.47412 .72807 L
s
.45205 .7197 m
.45617 .7151 L
s
.45205 .7197 m
.43732 .70131 L
s
.4333 .70568 m
.41352 .69212 L
s
.4333 .70568 m
.45617 .7151 L
s
.4333 .70568 m
.43732 .70131 L
s
.4333 .70568 m
.41744 .68848 L
s
.41352 .69212 m
.39289 .67911 L
s
.41352 .69212 m
.43732 .70131 L
s
.41352 .69212 m
.41744 .68848 L
s
.41352 .69212 m
.39693 .67485 L
s
.39289 .67911 m
.37178 .66462 L
s
.39289 .67911 m
.41744 .68848 L
s
.39289 .67911 m
.39693 .67485 L
s
.39289 .67911 m
.37565 .66182 L
s
.37178 .66462 m
.35005 .65097 L
s
.37178 .66462 m
.39693 .67485 L
s
.37178 .66462 m
.37565 .66182 L
s
.37178 .66462 m
.3539 .64845 L
s
.35005 .65097 m
.32786 .63888 L
s
.35005 .65097 m
.37565 .66182 L
s
.35005 .65097 m
.3539 .64845 L
s
.35005 .65097 m
.33184 .63487 L
s
.32786 .63888 m
.30563 .62498 L
s
.32786 .63888 m
.3539 .64845 L
s
.32786 .63888 m
.33184 .63487 L
s
.32786 .63888 m
.30961 .62136 L
s
.30563 .62498 m
.2831 .61228 L
s
.30563 .62498 m
.33184 .63487 L
s
.30563 .62498 m
.30961 .62136 L
s
.30563 .62498 m
.28715 .60852 L
s
.2831 .61228 m
.26059 .59879 L
s
.2831 .61228 m
.30961 .62136 L
s
.2831 .61228 m
.28715 .60852 L
s
.2831 .61228 m
.26472 .5952 L
s
.26059 .59879 m
.23814 .5854 L
s
.26059 .59879 m
.28715 .60852 L
s
.26059 .59879 m
.26472 .5952 L
s
.26059 .59879 m
.24242 .58151 L
s
.23814 .5854 m
.21594 .57184 L
s
.23814 .5854 m
.26472 .5952 L
s
.23814 .5854 m
.24242 .58151 L
s
.23814 .5854 m
.22026 .56743 L
s
.21594 .57184 m
.19404 .55853 L
s
.21594 .57184 m
.24242 .58151 L
s
.21594 .57184 m
.22026 .56743 L
s
.21594 .57184 m
.1986 .55411 L
s
.19404 .55853 m
.17274 .54538 L
s
.19404 .55853 m
.22026 .56743 L
s
.19404 .55853 m
.1986 .55411 L
s
.19404 .55853 m
.17735 .54048 L
s
.17274 .54538 m
.15196 .53204 L
s
.17274 .54538 m
.1986 .55411 L
s
.17274 .54538 m
.17735 .54048 L
s
.17274 .54538 m
.15671 .52699 L
s
.15196 .53204 m
.1318 .51877 L
s
.15196 .53204 m
.17735 .54048 L
s
.15196 .53204 m
.15671 .52699 L
s
.15196 .53204 m
.13669 .51361 L
s
.1318 .51877 m
.11229 .50566 L
s
.1318 .51877 m
.15671 .52699 L
s
.1318 .51877 m
.13669 .51361 L
s
.1318 .51877 m
.11744 .50049 L
s
.11229 .50566 m
.09373 .49301 L
s
.11229 .50566 m
.13669 .51361 L
s
.11229 .50566 m
.11744 .50049 L
s
.11229 .50566 m
.09921 .48792 L
s
.09373 .49301 m
.07661 .48143 L
s
.09373 .49301 m
.11744 .50049 L
s
.09373 .49301 m
.09921 .48792 L
s
.09373 .49301 m
.08201 .47601 L
s
.07661 .48143 m
.06068 .47081 L
s
.07661 .48143 m
.09921 .48792 L
s
.07661 .48143 m
.08201 .47601 L
s
.07661 .48143 m
.06653 .46526 L
s
.06068 .47081 m
.04622 .46138 L
s
.06068 .47081 m
.08201 .47601 L
s
.06068 .47081 m
.06653 .46526 L
s
.06068 .47081 m
.05266 .45573 L
s
.04622 .46138 m
.03382 .45368 L
s
.04622 .46138 m
.06653 .46526 L
s
.04622 .46138 m
.05266 .45573 L
s
.04622 .46138 m
.04092 .44793 L
s
.03382 .45368 m
.02381 .4488 L
s
.03382 .45368 m
.05266 .45573 L
s
.03382 .45368 m
.04092 .44793 L
s
.03382 .45368 m
.03292 .443 L
s
.02381 .4488 m
.04092 .44793 L
s
.02381 .4488 m
.03292 .443 L
s
.54766 .79198 m
.54137 .78528 L
s
.54766 .79198 m
.55529 .78415 L
s
.54766 .79198 m
.54907 .7771 L
s
.54137 .78528 m
.53171 .77569 L
s
.54137 .78528 m
.55529 .78415 L
s
.54137 .78528 m
.54907 .7771 L
s
.54137 .78528 m
.53944 .76814 L
s
.53171 .77569 m
.51972 .76572 L
s
.53171 .77569 m
.54907 .7771 L
s
.53171 .77569 m
.53944 .76814 L
s
.53171 .77569 m
.52744 .75739 L
s
.51972 .76572 m
.50616 .75318 L
s
.51972 .76572 m
.53944 .76814 L
s
.51972 .76572 m
.52744 .75739 L
s
.51972 .76572 m
.51369 .74533 L
s
.50616 .75318 m
.49093 .74015 L
s
.50616 .75318 m
.52744 .75739 L
s
.50616 .75318 m
.51369 .74533 L
s
.50616 .75318 m
.49828 .73209 L
s
.49093 .74015 m
.47412 .72807 L
s
.49093 .74015 m
.51369 .74533 L
s
.49093 .74015 m
.49828 .73209 L
s
.49093 .74015 m
.4815 .71866 L
s
.47412 .72807 m
.45617 .7151 L
s
.47412 .72807 m
.49828 .73209 L
s
.47412 .72807 m
.4815 .71866 L
s
.47412 .72807 m
.46335 .70701 L
s
.45617 .7151 m
.43732 .70131 L
s
.45617 .7151 m
.4815 .71866 L
s
.45617 .7151 m
.46335 .70701 L
s
.45617 .7151 m
.44432 .69418 L
s
.43732 .70131 m
.41744 .68848 L
s
.43732 .70131 m
.46335 .70701 L
s
.43732 .70131 m
.44432 .69418 L
s
.43732 .70131 m
.42444 .6806 L
s
.41744 .68848 m
.39693 .67485 L
s
.41744 .68848 m
.44432 .69418 L
s
.41744 .68848 m
.42444 .6806 L
s
.41744 .68848 m
.40386 .66735 L
s
.39693 .67485 m
.37565 .66182 L
s
.39693 .67485 m
.42444 .6806 L
s
.39693 .67485 m
.40386 .66735 L
s
.39693 .67485 m
.38248 .65525 L
s
.37565 .66182 m
.3539 .64845 L
s
.37565 .66182 m
.40386 .66735 L
s
.37565 .66182 m
.38248 .65525 L
s
.37565 .66182 m
.36073 .64209 L
s
.3539 .64845 m
.33184 .63487 L
s
.3539 .64845 m
.38248 .65525 L
s
.3539 .64845 m
.36073 .64209 L
s
.3539 .64845 m
.33872 .62839 L
s
.33184 .63487 m
.30961 .62136 L
s
.33184 .63487 m
.36073 .64209 L
s
.33184 .63487 m
.33872 .62839 L
s
.33184 .63487 m
.31647 .61497 L
s
.30961 .62136 m
.28715 .60852 L
s
.30961 .62136 m
.33872 .62839 L
s
.30961 .62136 m
.31647 .61497 L
s
.30961 .62136 m
.29413 .60172 L
s
.28715 .60852 m
.26472 .5952 L
s
.28715 .60852 m
.31647 .61497 L
s
.28715 .60852 m
.29413 .60172 L
s
.28715 .60852 m
.2718 .58809 L
s
.26472 .5952 m
.24242 .58151 L
s
.26472 .5952 m
.29413 .60172 L
s
.26472 .5952 m
.2718 .58809 L
s
.26472 .5952 m
.2496 .57421 L
s
.24242 .58151 m
.22026 .56743 L
s
.24242 .58151 m
.2718 .58809 L
s
.24242 .58151 m
.2496 .57421 L
s
.24242 .58151 m
.22767 .56023 L
s
.22026 .56743 m
.1986 .55411 L
s
.22026 .56743 m
.2496 .57421 L
s
.22026 .56743 m
.22767 .56023 L
s
.22026 .56743 m
.20604 .54622 L
s
.1986 .55411 m
.17735 .54048 L
s
.1986 .55411 m
.22767 .56023 L
s
.1986 .55411 m
.20604 .54622 L
s
.1986 .55411 m
.18489 .53236 L
s
.17735 .54048 m
.15671 .52699 L
s
.17735 .54048 m
.20604 .54622 L
s
.17735 .54048 m
.18489 .53236 L
s
.17735 .54048 m
.16438 .51863 L
s
.15671 .52699 m
.13669 .51361 L
s
.15671 .52699 m
.18489 .53236 L
s
.15671 .52699 m
.16438 .51863 L
s
.15671 .52699 m
.14452 .5051 L
s
.13669 .51361 m
.11744 .50049 L
s
.13669 .51361 m
.16438 .51863 L
s
.13669 .51361 m
.14452 .5051 L
s
.13669 .51361 m
.12549 .4919 L
s
.11744 .50049 m
.09921 .48792 L
s
.11744 .50049 m
.14452 .5051 L
s
.11744 .50049 m
.12549 .4919 L
s
.11744 .50049 m
.10745 .47918 L
s
.09921 .48792 m
.08201 .47601 L
s
.09921 .48792 m
.12549 .4919 L
s
.09921 .48792 m
.10745 .47918 L
s
.09921 .48792 m
.09069 .46727 L
s
.08201 .47601 m
.06653 .46526 L
s
.08201 .47601 m
.10745 .47918 L
s
.08201 .47601 m
.09069 .46727 L
s
.08201 .47601 m
.07547 .45629 L
s
.06653 .46526 m
.05266 .45573 L
s
.06653 .46526 m
.09069 .46727 L
s
.06653 .46526 m
.07547 .45629 L
s
.06653 .46526 m
.06206 .44667 L
s
.05266 .45573 m
.04092 .44793 L
s
.05266 .45573 m
.07547 .45629 L
s
.05266 .45573 m
.06206 .44667 L
s
.05266 .45573 m
.05119 .4389 L
s
.04092 .44793 m
.03292 .443 L
s
.04092 .44793 m
.06206 .44667 L
s
.04092 .44793 m
.05119 .4389 L
s
.04092 .44793 m
.04391 .43401 L
s
.03292 .443 m
.05119 .4389 L
s
.03292 .443 m
.04391 .43401 L
s
.55529 .78415 m
.54907 .7771 L
s
.55529 .78415 m
.56489 .77348 L
s
.55529 .78415 m
.55894 .76737 L
s
.54907 .7771 m
.53944 .76814 L
s
.54907 .7771 m
.56489 .77348 L
s
.54907 .7771 m
.55894 .76737 L
s
.54907 .7771 m
.54936 .75818 L
s
.53944 .76814 m
.52744 .75739 L
s
.53944 .76814 m
.55894 .76737 L
s
.53944 .76814 m
.54936 .75818 L
s
.53944 .76814 m
.53734 .74732 L
s
.52744 .75739 m
.51369 .74533 L
s
.52744 .75739 m
.54936 .75818 L
s
.52744 .75739 m
.53734 .74732 L
s
.52744 .75739 m
.52353 .7347 L
s
.51369 .74533 m
.49828 .73209 L
s
.51369 .74533 m
.53734 .74732 L
s
.51369 .74533 m
.52353 .7347 L
s
.51369 .74533 m
.5079 .72351 L
s
.49828 .73209 m
.4815 .71866 L
s
.49828 .73209 m
.52353 .7347 L
s
.49828 .73209 m
.5079 .72351 L
s
.49828 .73209 m
.49101 .71036 L
s
.4815 .71866 m
.46335 .70701 L
s
.4815 .71866 m
.5079 .72351 L
s
.4815 .71866 m
.49101 .71036 L
s
.4815 .71866 m
.47282 .69767 L
s
.46335 .70701 m
.44432 .69418 L
s
.46335 .70701 m
.49101 .71036 L
s
.46335 .70701 m
.47282 .69767 L
s
.46335 .70701 m
.45372 .68466 L
s
.44432 .69418 m
.42444 .6806 L
s
.44432 .69418 m
.47282 .69767 L
s
.44432 .69418 m
.45372 .68466 L
s
.44432 .69418 m
.43371 .67199 L
s
.42444 .6806 m
.40386 .66735 L
s
.42444 .6806 m
.45372 .68466 L
s
.42444 .6806 m
.43371 .67199 L
s
.42444 .6806 m
.41301 .65879 L
s
.40386 .66735 m
.38248 .65525 L
s
.40386 .66735 m
.43371 .67199 L
s
.40386 .66735 m
.41301 .65879 L
s
.40386 .66735 m
.39172 .64578 L
s
.38248 .65525 m
.36073 .64209 L
s
.38248 .65525 m
.41301 .65879 L
s
.38248 .65525 m
.39172 .64578 L
s
.38248 .65525 m
.36998 .63303 L
s
.36073 .64209 m
.33872 .62839 L
s
.36073 .64209 m
.39172 .64578 L
s
.36073 .64209 m
.36998 .63303 L
s
.36073 .64209 m
.34796 .61964 L
s
.33872 .62839 m
.31647 .61497 L
s
.33872 .62839 m
.36998 .63303 L
s
.33872 .62839 m
.34796 .61964 L
s
.33872 .62839 m
.32574 .60597 L
s
.31647 .61497 m
.29413 .60172 L
s
.31647 .61497 m
.34796 .61964 L
s
.31647 .61497 m
.32574 .60597 L
s
.31647 .61497 m
.30351 .59236 L
s
.29413 .60172 m
.2718 .58809 L
s
.29413 .60172 m
.32574 .60597 L
s
.29413 .60172 m
.30351 .59236 L
s
.29413 .60172 m
.28126 .57844 L
s
.2718 .58809 m
.2496 .57421 L
s
.2718 .58809 m
.30351 .59236 L
s
.2718 .58809 m
.28126 .57844 L
s
.2718 .58809 m
.25914 .56434 L
s
.2496 .57421 m
.22767 .56023 L
s
.2496 .57421 m
.28126 .57844 L
s
.2496 .57421 m
.25914 .56434 L
s
.2496 .57421 m
.23728 .55013 L
s
.22767 .56023 m
.20604 .54622 L
s
.22767 .56023 m
.25914 .56434 L
s
.22767 .56023 m
.23728 .55013 L
s
.22767 .56023 m
.21576 .53592 L
s
.20604 .54622 m
.18489 .53236 L
s
.20604 .54622 m
.23728 .55013 L
s
.20604 .54622 m
.21576 .53592 L
s
.20604 .54622 m
.19472 .52182 L
s
.18489 .53236 m
.16438 .51863 L
s
.18489 .53236 m
.21576 .53592 L
s
.18489 .53236 m
.19472 .52182 L
s
.18489 .53236 m
.17429 .50786 L
s
.16438 .51863 m
.14452 .5051 L
s
.16438 .51863 m
.19472 .52182 L
s
.16438 .51863 m
.17429 .50786 L
s
.16438 .51863 m
.15458 .49417 L
s
.14452 .5051 m
.12549 .4919 L
s
.14452 .5051 m
.17429 .50786 L
s
.14452 .5051 m
.15458 .49417 L
s
.14452 .5051 m
.1357 .48085 L
s
.12549 .4919 m
.10745 .47918 L
s
.12549 .4919 m
.15458 .49417 L
s
.12549 .4919 m
.1357 .48085 L
s
.12549 .4919 m
.11792 .46805 L
s
.10745 .47918 m
.09069 .46727 L
s
.10745 .47918 m
.1357 .48085 L
s
.10745 .47918 m
.11792 .46805 L
s
.10745 .47918 m
.10144 .456 L
s
.09069 .46727 m
.07547 .45629 L
s
.09069 .46727 m
.11792 .46805 L
s
.09069 .46727 m
.10144 .456 L
s
.09069 .46727 m
.08658 .44502 L
s
.07547 .45629 m
.06206 .44667 L
s
.07547 .45629 m
.10144 .456 L
s
.07547 .45629 m
.08658 .44502 L
s
.07547 .45629 m
.07365 .4354 L
s
.06206 .44667 m
.05119 .4389 L
s
.06206 .44667 m
.08658 .44502 L
s
.06206 .44667 m
.07365 .4354 L
s
.06206 .44667 m
.0633 .42769 L
s
.05119 .4389 m
.04391 .43401 L
s
.05119 .4389 m
.07365 .4354 L
s
.05119 .4389 m
.0633 .42769 L
s
.05119 .4389 m
.05657 .42294 L
s
.04391 .43401 m
.0633 .42769 L
s
.04391 .43401 m
.05657 .42294 L
s
.56489 .77348 m
.55894 .76737 L
s
.56489 .77348 m
.57606 .76131 L
s
.56489 .77348 m
.57019 .75464 L
s
.55894 .76737 m
.54936 .75818 L
s
.55894 .76737 m
.57606 .76131 L
s
.55894 .76737 m
.57019 .75464 L
s
.55894 .76737 m
.56093 .74665 L
s
.54936 .75818 m
.53734 .74732 L
s
.54936 .75818 m
.57019 .75464 L
s
.54936 .75818 m
.56093 .74665 L
s
.54936 .75818 m
.54896 .73637 L
s
.53734 .74732 m
.52353 .7347 L
s
.53734 .74732 m
.56093 .74665 L
s
.53734 .74732 m
.54896 .73637 L
s
.53734 .74732 m
.53506 .72379 L
s
.52353 .7347 m
.5079 .72351 L
s
.52353 .7347 m
.54896 .73637 L
s
.52353 .7347 m
.53506 .72379 L
s
.52353 .7347 m
.51941 .71288 L
s
.5079 .72351 m
.49101 .71036 L
s
.5079 .72351 m
.53506 .72379 L
s
.5079 .72351 m
.51941 .71288 L
s
.5079 .72351 m
.50241 .70051 L
s
.49101 .71036 m
.47282 .69767 L
s
.49101 .71036 m
.51941 .71288 L
s
.49101 .71036 m
.50241 .70051 L
s
.49101 .71036 m
.48424 .68784 L
s
.47282 .69767 m
.45372 .68466 L
s
.47282 .69767 m
.50241 .70051 L
s
.47282 .69767 m
.48424 .68784 L
s
.47282 .69767 m
.46504 .67482 L
s
.45372 .68466 m
.43371 .67199 L
s
.45372 .68466 m
.48424 .68784 L
s
.45372 .68466 m
.46504 .67482 L
s
.45372 .68466 m
.44496 .66166 L
s
.43371 .67199 m
.41301 .65879 L
s
.43371 .67199 m
.46504 .67482 L
s
.43371 .67199 m
.44496 .66166 L
s
.43371 .67199 m
.4242 .64829 L
s
.41301 .65879 m
.39172 .64578 L
s
.41301 .65879 m
.44496 .66166 L
s
.41301 .65879 m
.4242 .64829 L
s
.41301 .65879 m
.40289 .63521 L
s
.39172 .64578 m
.36998 .63303 L
s
.39172 .64578 m
.4242 .64829 L
s
.39172 .64578 m
.40289 .63521 L
s
.39172 .64578 m
.38121 .62237 L
s
.36998 .63303 m
.34796 .61964 L
s
.36998 .63303 m
.40289 .63521 L
s
.36998 .63303 m
.38121 .62237 L
s
.36998 .63303 m
.35918 .60877 L
s
.34796 .61964 m
.32574 .60597 L
s
.34796 .61964 m
.38121 .62237 L
s
.34796 .61964 m
.35918 .60877 L
s
.34796 .61964 m
.33705 .59506 L
s
.32574 .60597 m
.30351 .59236 L
s
.32574 .60597 m
.35918 .60877 L
s
.32574 .60597 m
.33705 .59506 L
s
.32574 .60597 m
.31482 .58101 L
s
.30351 .59236 m
.28126 .57844 L
s
.30351 .59236 m
.33705 .59506 L
s
.30351 .59236 m
.31482 .58101 L
s
.30351 .59236 m
.29262 .56683 L
s
.28126 .57844 m
.25914 .56434 L
s
.28126 .57844 m
.31482 .58101 L
s
.28126 .57844 m
.29262 .56683 L
s
.28126 .57844 m
.27053 .55247 L
s
.25914 .56434 m
.23728 .55013 L
s
.25914 .56434 m
.29262 .56683 L
s
.25914 .56434 m
.27053 .55247 L
s
.25914 .56434 m
.24872 .53807 L
s
.23728 .55013 m
.21576 .53592 L
s
.23728 .55013 m
.27053 .55247 L
s
.23728 .55013 m
.24872 .53807 L
s
.23728 .55013 m
.22731 .52368 L
s
.21576 .53592 m
.19472 .52182 L
s
.21576 .53592 m
.24872 .53807 L
s
.21576 .53592 m
.22731 .52368 L
s
.21576 .53592 m
.20635 .5094 L
s
.19472 .52182 m
.17429 .50786 L
s
.19472 .52182 m
.22731 .52368 L
s
.19472 .52182 m
.20635 .5094 L
s
.19472 .52182 m
.18602 .49528 L
s
.17429 .50786 m
.15458 .49417 L
s
.17429 .50786 m
.20635 .5094 L
s
.17429 .50786 m
.18602 .49528 L
s
.17429 .50786 m
.1664 .48142 L
s
.15458 .49417 m
.1357 .48085 L
s
.15458 .49417 m
.18602 .49528 L
s
.15458 .49417 m
.1664 .48142 L
s
.15458 .49417 m
.14768 .46799 L
s
.1357 .48085 m
.11792 .46805 L
s
.1357 .48085 m
.1664 .48142 L
s
.1357 .48085 m
.14768 .46799 L
s
.1357 .48085 m
.13011 .4551 L
s
.11792 .46805 m
.10144 .456 L
s
.11792 .46805 m
.14768 .46799 L
s
.11792 .46805 m
.13011 .4551 L
s
.11792 .46805 m
.11389 .443 L
s
.10144 .456 m
.08658 .44502 L
s
.10144 .456 m
.13011 .4551 L
s
.10144 .456 m
.11389 .443 L
s
.10144 .456 m
.09932 .43197 L
s
.08658 .44502 m
.07365 .4354 L
s
.08658 .44502 m
.11389 .443 L
s
.08658 .44502 m
.09932 .43197 L
s
.08658 .44502 m
.08678 .42243 L
s
.07365 .4354 m
.0633 .42769 L
s
.07365 .4354 m
.09932 .43197 L
s
.07365 .4354 m
.08678 .42243 L
s
.07365 .4354 m
.07678 .41485 L
s
.0633 .42769 m
.05657 .42294 L
s
.0633 .42769 m
.08678 .42243 L
s
.0633 .42769 m
.07678 .41485 L
s
.0633 .42769 m
.07041 .41017 L
s
.05657 .42294 m
.07678 .41485 L
s
.05657 .42294 m
.07041 .41017 L
s
.57606 .76131 m
.57019 .75464 L
s
.57606 .76131 m
.58868 .74776 L
s
.57606 .76131 m
.58308 .74248 L
s
.57019 .75464 m
.56093 .74665 L
s
.57019 .75464 m
.58868 .74776 L
s
.57019 .75464 m
.58308 .74248 L
s
.57019 .75464 m
.57367 .73284 L
s
.56093 .74665 m
.54896 .73637 L
s
.56093 .74665 m
.58308 .74248 L
s
.56093 .74665 m
.57367 .73284 L
s
.56093 .74665 m
.56196 .72407 L
s
.54896 .73637 m
.53506 .72379 L
s
.54896 .73637 m
.57367 .73284 L
s
.54896 .73637 m
.56196 .72407 L
s
.54896 .73637 m
.54806 .71256 L
s
.53506 .72379 m
.51941 .71288 L
s
.53506 .72379 m
.56196 .72407 L
s
.53506 .72379 m
.54806 .71256 L
s
.53506 .72379 m
.53242 .70047 L
s
.51941 .71288 m
.50241 .70051 L
s
.51941 .71288 m
.54806 .71256 L
s
.51941 .71288 m
.53242 .70047 L
s
.51941 .71288 m
.51542 .68918 L
s
.50241 .70051 m
.48424 .68784 L
s
.50241 .70051 m
.53242 .70047 L
s
.50241 .70051 m
.51542 .68918 L
s
.50241 .70051 m
.49721 .67646 L
s
.48424 .68784 m
.46504 .67482 L
s
.48424 .68784 m
.51542 .68918 L
s
.48424 .68784 m
.49721 .67646 L
s
.48424 .68784 m
.47796 .66355 L
s
.46504 .67482 m
.44496 .66166 L
s
.46504 .67482 m
.49721 .67646 L
s
.46504 .67482 m
.47796 .66355 L
s
.46504 .67482 m
.45789 .65055 L
s
.44496 .66166 m
.4242 .64829 L
s
.44496 .66166 m
.47796 .66355 L
s
.44496 .66166 m
.45789 .65055 L
s
.44496 .66166 m
.43711 .63721 L
s
.4242 .64829 m
.40289 .63521 L
s
.4242 .64829 m
.45789 .65055 L
s
.4242 .64829 m
.43711 .63721 L
s
.4242 .64829 m
.41578 .62362 L
s
.40289 .63521 m
.38121 .62237 L
s
.40289 .63521 m
.43711 .63721 L
s
.40289 .63521 m
.41578 .62362 L
s
.40289 .63521 m
.39407 .61018 L
s
.38121 .62237 m
.35918 .60877 L
s
.38121 .62237 m
.41578 .62362 L
s
.38121 .62237 m
.39407 .61018 L
s
.38121 .62237 m
.37209 .59642 L
s
.35918 .60877 m
.33705 .59506 L
s
.35918 .60877 m
.39407 .61018 L
s
.35918 .60877 m
.37209 .59642 L
s
.35918 .60877 m
.34992 .58235 L
s
.33705 .59506 m
.31482 .58101 L
s
.33705 .59506 m
.37209 .59642 L
s
.33705 .59506 m
.34992 .58235 L
s
.33705 .59506 m
.32772 .56808 L
s
.31482 .58101 m
.29262 .56683 L
s
.31482 .58101 m
.34992 .58235 L
s
.31482 .58101 m
.32772 .56808 L
s
.31482 .58101 m
.30552 .55362 L
s
.29262 .56683 m
.27053 .55247 L
s
.29262 .56683 m
.32772 .56808 L
s
.29262 .56683 m
.30552 .55362 L
s
.29262 .56683 m
.2835 .53908 L
s
.27053 .55247 m
.24872 .53807 L
s
.27053 .55247 m
.30552 .55362 L
s
.27053 .55247 m
.2835 .53908 L
s
.27053 .55247 m
.26173 .5245 L
s
.24872 .53807 m
.22731 .52368 L
s
.24872 .53807 m
.2835 .53908 L
s
.24872 .53807 m
.26173 .5245 L
s
.24872 .53807 m
.24035 .50995 L
s
.22731 .52368 m
.20635 .5094 L
s
.22731 .52368 m
.26173 .5245 L
s
.22731 .52368 m
.24035 .50995 L
s
.22731 .52368 m
.21949 .49551 L
s
.20635 .5094 m
.18602 .49528 L
s
.20635 .5094 m
.24035 .50995 L
s
.20635 .5094 m
.21949 .49551 L
s
.20635 .5094 m
.19921 .48126 L
s
.18602 .49528 m
.1664 .48142 L
s
.18602 .49528 m
.21949 .49551 L
s
.18602 .49528 m
.19921 .48126 L
s
.18602 .49528 m
.1797 .46729 L
s
.1664 .48142 m
.14768 .46799 L
s
.1664 .48142 m
.19921 .48126 L
s
.1664 .48142 m
.1797 .46729 L
s
.1664 .48142 m
.16112 .45374 L
s
.14768 .46799 m
.13011 .4551 L
s
.14768 .46799 m
.1797 .46729 L
s
.14768 .46799 m
.16112 .45374 L
s
.14768 .46799 m
.14368 .44078 L
s
.13011 .4551 m
.11389 .443 L
s
.13011 .4551 m
.16112 .45374 L
s
.13011 .4551 m
.14368 .44078 L
s
.13011 .4551 m
.12765 .42865 L
s
.11389 .443 m
.09932 .43197 L
s
.11389 .443 m
.14368 .44078 L
s
.11389 .443 m
.12765 .42865 L
s
.11389 .443 m
.11334 .41761 L
s
.09932 .43197 m
.08678 .42243 L
s
.09932 .43197 m
.12765 .42865 L
s
.09932 .43197 m
.11334 .41761 L
s
.09932 .43197 m
.10105 .40811 L
s
.08678 .42243 m
.07678 .41485 L
s
.08678 .42243 m
.11334 .41761 L
s
.08678 .42243 m
.10105 .40811 L
s
.08678 .42243 m
.09138 .40062 L
s
.07678 .41485 m
.07041 .41017 L
s
.07678 .41485 m
.10105 .40811 L
s
.07678 .41485 m
.09138 .40062 L
s
.07678 .41485 m
.08532 .39611 L
s
.07041 .41017 m
.09138 .40062 L
s
.07041 .41017 m
.08532 .39611 L
s
.58868 .74776 m
.58308 .74248 L
s
.58868 .74776 m
.60259 .73391 L
s
.58868 .74776 m
.59701 .72847 L
s
.58308 .74248 m
.57367 .73284 L
s
.58308 .74248 m
.60259 .73391 L
s
.58308 .74248 m
.59701 .72847 L
s
.58308 .74248 m
.58799 .72074 L
s
.57367 .73284 m
.56196 .72407 L
s
.57367 .73284 m
.59701 .72847 L
s
.57367 .73284 m
.58799 .72074 L
s
.57367 .73284 m
.57623 .71106 L
s
.56196 .72407 m
.54806 .71256 L
s
.56196 .72407 m
.58799 .72074 L
s
.56196 .72407 m
.57623 .71106 L
s
.56196 .72407 m
.56229 .69977 L
s
.54806 .71256 m
.53242 .70047 L
s
.54806 .71256 m
.57623 .71106 L
s
.54806 .71256 m
.56229 .69977 L
s
.54806 .71256 m
.54677 .68848 L
s
.53242 .70047 m
.51542 .68918 L
s
.53242 .70047 m
.56229 .69977 L
s
.53242 .70047 m
.54677 .68848 L
s
.53242 .70047 m
.52975 .67646 L
s
.51542 .68918 m
.49721 .67646 L
s
.51542 .68918 m
.54677 .68848 L
s
.51542 .68918 m
.52975 .67646 L
s
.51542 .68918 m
.51154 .6641 L
s
.49721 .67646 m
.47796 .66355 L
s
.49721 .67646 m
.52975 .67646 L
s
.49721 .67646 m
.51154 .6641 L
s
.49721 .67646 m
.49227 .65124 L
s
.47796 .66355 m
.45789 .65055 L
s
.47796 .66355 m
.51154 .6641 L
s
.47796 .66355 m
.49227 .65124 L
s
.47796 .66355 m
.47216 .63796 L
s
.45789 .65055 m
.43711 .63721 L
s
.45789 .65055 m
.49227 .65124 L
s
.45789 .65055 m
.47216 .63796 L
s
.45789 .65055 m
.45139 .62452 L
s
.43711 .63721 m
.41578 .62362 L
s
.43711 .63721 m
.47216 .63796 L
s
.43711 .63721 m
.45139 .62452 L
s
.43711 .63721 m
.43007 .61076 L
s
.41578 .62362 m
.39407 .61018 L
s
.41578 .62362 m
.45139 .62452 L
s
.41578 .62362 m
.43007 .61076 L
s
.41578 .62362 m
.4083 .59678 L
s
.39407 .61018 m
.37209 .59642 L
s
.39407 .61018 m
.43007 .61076 L
s
.39407 .61018 m
.4083 .59678 L
s
.39407 .61018 m
.38628 .58266 L
s
.37209 .59642 m
.34992 .58235 L
s
.37209 .59642 m
.4083 .59678 L
s
.37209 .59642 m
.38628 .58266 L
s
.37209 .59642 m
.36415 .56835 L
s
.34992 .58235 m
.32772 .56808 L
s
.34992 .58235 m
.38628 .58266 L
s
.34992 .58235 m
.36415 .56835 L
s
.34992 .58235 m
.34191 .55383 L
s
.32772 .56808 m
.30552 .55362 L
s
.32772 .56808 m
.36415 .56835 L
s
.32772 .56808 m
.34191 .55383 L
s
.32772 .56808 m
.31974 .53919 L
s
.30552 .55362 m
.2835 .53908 L
s
.30552 .55362 m
.34191 .55383 L
s
.30552 .55362 m
.31974 .53919 L
s
.30552 .55362 m
.29773 .52446 L
s
.2835 .53908 m
.26173 .5245 L
s
.2835 .53908 m
.31974 .53919 L
s
.2835 .53908 m
.29773 .52446 L
s
.2835 .53908 m
.27598 .50975 L
s
.26173 .5245 m
.24035 .50995 L
s
.26173 .5245 m
.29773 .52446 L
s
.26173 .5245 m
.27598 .50975 L
s
.26173 .5245 m
.25465 .49506 L
s
.24035 .50995 m
.21949 .49551 L
s
.24035 .50995 m
.27598 .50975 L
s
.24035 .50995 m
.25465 .49506 L
s
.24035 .50995 m
.23382 .48049 L
s
.21949 .49551 m
.19921 .48126 L
s
.21949 .49551 m
.25465 .49506 L
s
.21949 .49551 m
.23382 .48049 L
s
.21949 .49551 m
.21361 .4661 L
s
.19921 .48126 m
.1797 .46729 L
s
.19921 .48126 m
.23382 .48049 L
s
.19921 .48126 m
.21361 .4661 L
s
.19921 .48126 m
.19419 .45204 L
s
.1797 .46729 m
.16112 .45374 L
s
.1797 .46729 m
.21361 .4661 L
s
.1797 .46729 m
.19419 .45204 L
s
.1797 .46729 m
.17563 .43843 L
s
.16112 .45374 m
.14368 .44078 L
s
.16112 .45374 m
.19419 .45204 L
s
.16112 .45374 m
.17563 .43843 L
s
.16112 .45374 m
.15844 .4254 L
s
.14368 .44078 m
.12765 .42865 L
s
.14368 .44078 m
.17563 .43843 L
s
.14368 .44078 m
.15844 .4254 L
s
.14368 .44078 m
.14258 .41323 L
s
.12765 .42865 m
.11334 .41761 L
s
.12765 .42865 m
.15844 .4254 L
s
.12765 .42865 m
.14258 .41323 L
s
.12765 .42865 m
.12839 .40223 L
s
.11334 .41761 m
.10105 .40811 L
s
.11334 .41761 m
.14258 .41323 L
s
.11334 .41761 m
.12839 .40223 L
s
.11334 .41761 m
.11629 .39272 L
s
.10105 .40811 m
.09138 .40062 L
s
.10105 .40811 m
.12839 .40223 L
s
.10105 .40811 m
.11629 .39272 L
s
.10105 .40811 m
.10687 .38533 L
s
.09138 .40062 m
.08532 .39611 L
s
.09138 .40062 m
.11629 .39272 L
s
.09138 .40062 m
.10687 .38533 L
s
.09138 .40062 m
.10098 .38083 L
s
.08532 .39611 m
.10687 .38533 L
s
.08532 .39611 m
.10098 .38083 L
s
.60259 .73391 m
.59701 .72847 L
s
.60259 .73391 m
.61692 .71755 L
s
.60259 .73391 m
.6119 .71382 L
s
.59701 .72847 m
.58799 .72074 L
s
.59701 .72847 m
.61692 .71755 L
s
.59701 .72847 m
.6119 .71382 L
s
.59701 .72847 m
.60299 .70635 L
s
.58799 .72074 m
.57623 .71106 L
s
.58799 .72074 m
.6119 .71382 L
s
.58799 .72074 m
.60299 .70635 L
s
.58799 .72074 m
.59137 .69691 L
s
.57623 .71106 m
.56229 .69977 L
s
.57623 .71106 m
.60299 .70635 L
s
.57623 .71106 m
.59137 .69691 L
s
.57623 .71106 m
.57771 .68677 L
s
.56229 .69977 m
.54677 .68848 L
s
.56229 .69977 m
.59137 .69691 L
s
.56229 .69977 m
.57771 .68677 L
s
.56229 .69977 m
.56218 .67517 L
s
.54677 .68848 m
.52975 .67646 L
s
.54677 .68848 m
.57771 .68677 L
s
.54677 .68848 m
.56218 .67517 L
s
.54677 .68848 m
.54521 .66319 L
s
.52975 .67646 m
.51154 .6641 L
s
.52975 .67646 m
.56218 .67517 L
s
.52975 .67646 m
.54521 .66319 L
s
.52975 .67646 m
.52696 .65052 L
s
.51154 .6641 m
.49227 .65124 L
s
.51154 .6641 m
.54521 .66319 L
s
.51154 .6641 m
.52696 .65052 L
s
.51154 .6641 m
.50768 .63761 L
s
.49227 .65124 m
.47216 .63796 L
s
.49227 .65124 m
.52696 .65052 L
s
.49227 .65124 m
.50768 .63761 L
s
.49227 .65124 m
.48758 .62427 L
s
.47216 .63796 m
.45139 .62452 L
s
.47216 .63796 m
.50768 .63761 L
s
.47216 .63796 m
.48758 .62427 L
s
.47216 .63796 m
.46676 .61054 L
s
.45139 .62452 m
.43007 .61076 L
s
.45139 .62452 m
.48758 .62427 L
s
.45139 .62452 m
.46676 .61054 L
s
.45139 .62452 m
.44539 .59653 L
s
.43007 .61076 m
.4083 .59678 L
s
.43007 .61076 m
.46676 .61054 L
s
.43007 .61076 m
.44539 .59653 L
s
.43007 .61076 m
.42362 .58229 L
s
.4083 .59678 m
.38628 .58266 L
s
.4083 .59678 m
.44539 .59653 L
s
.4083 .59678 m
.42362 .58229 L
s
.4083 .59678 m
.40159 .56784 L
s
.38628 .58266 m
.36415 .56835 L
s
.38628 .58266 m
.42362 .58229 L
s
.38628 .58266 m
.40159 .56784 L
s
.38628 .58266 m
.37941 .55326 L
s
.36415 .56835 m
.34191 .55383 L
s
.36415 .56835 m
.40159 .56784 L
s
.36415 .56835 m
.37941 .55326 L
s
.36415 .56835 m
.35719 .53856 L
s
.34191 .55383 m
.31974 .53919 L
s
.34191 .55383 m
.37941 .55326 L
s
.34191 .55383 m
.35719 .53856 L
s
.34191 .55383 m
.33504 .52374 L
s
.31974 .53919 m
.29773 .52446 L
s
.31974 .53919 m
.35719 .53856 L
s
.31974 .53919 m
.33504 .52374 L
s
.31974 .53919 m
.31303 .50888 L
s
.29773 .52446 m
.27598 .50975 L
s
.29773 .52446 m
.33504 .52374 L
s
.29773 .52446 m
.31303 .50888 L
s
.29773 .52446 m
.29131 .49402 L
s
.27598 .50975 m
.25465 .49506 L
s
.27598 .50975 m
.31303 .50888 L
s
.27598 .50975 m
.29131 .49402 L
s
.27598 .50975 m
.26999 .47922 L
s
.25465 .49506 m
.23382 .48049 L
s
.25465 .49506 m
.29131 .49402 L
s
.25465 .49506 m
.26999 .47922 L
s
.25465 .49506 m
.2492 .46452 L
s
.23382 .48049 m
.21361 .4661 L
s
.23382 .48049 m
.26999 .47922 L
s
.23382 .48049 m
.2492 .46452 L
s
.23382 .48049 m
.22903 .45007 L
s
.21361 .4661 m
.19419 .45204 L
s
.21361 .4661 m
.2492 .46452 L
s
.21361 .4661 m
.22903 .45007 L
s
.21361 .4661 m
.20966 .43592 L
s
.19419 .45204 m
.17563 .43843 L
s
.19419 .45204 m
.22903 .45007 L
s
.19419 .45204 m
.20966 .43592 L
s
.19419 .45204 m
.19129 .42222 L
s
.17563 .43843 m
.15844 .4254 L
s
.17563 .43843 m
.20966 .43592 L
s
.17563 .43843 m
.19129 .42222 L
s
.17563 .43843 m
.17412 .40917 L
s
.15844 .4254 m
.14258 .41323 L
s
.15844 .4254 m
.19129 .42222 L
s
.15844 .4254 m
.17412 .40917 L
s
.15844 .4254 m
.15835 .397 L
s
.14258 .41323 m
.12839 .40223 L
s
.14258 .41323 m
.17412 .40917 L
s
.14258 .41323 m
.15835 .397 L
s
.14258 .41323 m
.14429 .38596 L
s
.12839 .40223 m
.11629 .39272 L
s
.12839 .40223 m
.15835 .397 L
s
.12839 .40223 m
.14429 .38596 L
s
.12839 .40223 m
.13233 .37651 L
s
.11629 .39272 m
.10687 .38533 L
s
.11629 .39272 m
.14429 .38596 L
s
.11629 .39272 m
.13233 .37651 L
s
.11629 .39272 m
.12306 .36913 L
s
.10687 .38533 m
.10098 .38083 L
s
.10687 .38533 m
.13233 .37651 L
s
.10687 .38533 m
.12306 .36913 L
s
.10687 .38533 m
.11732 .36467 L
s
.10098 .38083 m
.12306 .36913 L
s
.10098 .38083 m
.11732 .36467 L
s
.61692 .71755 m
.6119 .71382 L
s
.61692 .71755 m
.63208 .70074 L
s
.61692 .71755 m
.62755 .69805 L
s
.6119 .71382 m
.60299 .70635 L
s
.6119 .71382 m
.63208 .70074 L
s
.6119 .71382 m
.62755 .69805 L
s
.6119 .71382 m
.61903 .6916 L
s
.60299 .70635 m
.59137 .69691 L
s
.60299 .70635 m
.62755 .69805 L
s
.60299 .70635 m
.61903 .6916 L
s
.60299 .70635 m
.60758 .68264 L
s
.59137 .69691 m
.57771 .68677 L
s
.59137 .69691 m
.61903 .6916 L
s
.59137 .69691 m
.60758 .68264 L
s
.59137 .69691 m
.59392 .67219 L
s
.57771 .68677 m
.56218 .67517 L
s
.57771 .68677 m
.60758 .68264 L
s
.57771 .68677 m
.59392 .67219 L
s
.57771 .68677 m
.57849 .66102 L
s
.56218 .67517 m
.54521 .66319 L
s
.56218 .67517 m
.59392 .67219 L
s
.56218 .67517 m
.57849 .66102 L
s
.56218 .67517 m
.5615 .64875 L
s
.54521 .66319 m
.52696 .65052 L
s
.54521 .66319 m
.57849 .66102 L
s
.54521 .66319 m
.5615 .64875 L
s
.54521 .66319 m
.54328 .6361 L
s
.52696 .65052 m
.50768 .63761 L
s
.52696 .65052 m
.5615 .64875 L
s
.52696 .65052 m
.54328 .6361 L
s
.52696 .65052 m
.524 .62304 L
s
.50768 .63761 m
.48758 .62427 L
s
.50768 .63761 m
.54328 .6361 L
s
.50768 .63761 m
.524 .62304 L
s
.50768 .63761 m
.50386 .60945 L
s
.48758 .62427 m
.46676 .61054 L
s
.48758 .62427 m
.524 .62304 L
s
.48758 .62427 m
.50386 .60945 L
s
.48758 .62427 m
.48302 .59549 L
s
.46676 .61054 m
.44539 .59653 L
s
.46676 .61054 m
.50386 .60945 L
s
.46676 .61054 m
.48302 .59549 L
s
.46676 .61054 m
.46162 .58127 L
s
.44539 .59653 m
.42362 .58229 L
s
.44539 .59653 m
.48302 .59549 L
s
.44539 .59653 m
.46162 .58127 L
s
.44539 .59653 m
.43983 .56678 L
s
.42362 .58229 m
.40159 .56784 L
s
.42362 .58229 m
.46162 .58127 L
s
.42362 .58229 m
.43983 .56678 L
s
.42362 .58229 m
.41779 .55212 L
s
.40159 .56784 m
.37941 .55326 L
s
.40159 .56784 m
.43983 .56678 L
s
.40159 .56784 m
.41779 .55212 L
s
.40159 .56784 m
.3956 .53731 L
s
.37941 .55326 m
.35719 .53856 L
s
.37941 .55326 m
.41779 .55212 L
s
.37941 .55326 m
.3956 .53731 L
s
.37941 .55326 m
.37338 .52243 L
s
.35719 .53856 m
.33504 .52374 L
s
.35719 .53856 m
.3956 .53731 L
s
.35719 .53856 m
.37338 .52243 L
s
.35719 .53856 m
.35124 .50748 L
s
.33504 .52374 m
.31303 .50888 L
s
.33504 .52374 m
.37338 .52243 L
s
.33504 .52374 m
.35124 .50748 L
s
.33504 .52374 m
.32923 .4925 L
s
.31303 .50888 m
.29131 .49402 L
s
.31303 .50888 m
.35124 .50748 L
s
.31303 .50888 m
.32923 .4925 L
s
.31303 .50888 m
.30751 .47753 L
s
.29131 .49402 m
.26999 .47922 L
s
.29131 .49402 m
.32923 .4925 L
s
.29131 .49402 m
.30751 .47753 L
s
.29131 .49402 m
.2862 .46262 L
s
.26999 .47922 m
.2492 .46452 L
s
.26999 .47922 m
.30751 .47753 L
s
.26999 .47922 m
.2862 .46262 L
s
.26999 .47922 m
.2654 .44787 L
s
.2492 .46452 m
.22903 .45007 L
s
.2492 .46452 m
.2862 .46262 L
s
.2492 .46452 m
.2654 .44787 L
s
.2492 .46452 m
.24529 .43332 L
s
.22903 .45007 m
.20966 .43592 L
s
.22903 .45007 m
.2654 .44787 L
s
.22903 .45007 m
.24529 .43332 L
s
.22903 .45007 m
.22598 .41914 L
s
.20966 .43592 m
.19129 .42222 L
s
.20966 .43592 m
.24529 .43332 L
s
.20966 .43592 m
.22598 .41914 L
s
.20966 .43592 m
.20766 .40539 L
s
.19129 .42222 m
.17412 .40917 L
s
.19129 .42222 m
.22598 .41914 L
s
.19129 .42222 m
.20766 .40539 L
s
.19129 .42222 m
.19055 .3923 L
s
.17412 .40917 m
.15835 .397 L
s
.17412 .40917 m
.20766 .40539 L
s
.17412 .40917 m
.19055 .3923 L
s
.17412 .40917 m
.17486 .38013 L
s
.15835 .397 m
.14429 .38596 L
s
.15835 .397 m
.19055 .3923 L
s
.15835 .397 m
.17486 .38013 L
s
.15835 .397 m
.16091 .36909 L
s
.14429 .38596 m
.13233 .37651 L
s
.14429 .38596 m
.17486 .38013 L
s
.14429 .38596 m
.16091 .36909 L
s
.14429 .38596 m
.14904 .35962 L
s
.13233 .37651 m
.12306 .36913 L
s
.13233 .37651 m
.16091 .36909 L
s
.13233 .37651 m
.14904 .35962 L
s
.13233 .37651 m
.1399 .35227 L
s
.12306 .36913 m
.11732 .36467 L
s
.12306 .36913 m
.14904 .35962 L
s
.12306 .36913 m
.1399 .35227 L
s
.12306 .36913 m
.13425 .34783 L
s
.11732 .36467 m
.1399 .35227 L
s
.11732 .36467 m
.13425 .34783 L
s
.63208 .70074 m
.62755 .69805 L
s
.63208 .70074 m
.64929 .68664 L
s
.63208 .70074 m
.64439 .6827 L
s
.62755 .69805 m
.61903 .6916 L
s
.62755 .69805 m
.64929 .68664 L
s
.62755 .69805 m
.64439 .6827 L
s
.62755 .69805 m
.63564 .67541 L
s
.61903 .6916 m
.60758 .68264 L
s
.61903 .6916 m
.64439 .6827 L
s
.61903 .6916 m
.63564 .67541 L
s
.61903 .6916 m
.62449 .66731 L
s
.60758 .68264 m
.59392 .67219 L
s
.60758 .68264 m
.63564 .67541 L
s
.60758 .68264 m
.62449 .66731 L
s
.60758 .68264 m
.61092 .65719 L
s
.59392 .67219 m
.57849 .66102 L
s
.59392 .67219 m
.62449 .66731 L
s
.59392 .67219 m
.61092 .65719 L
s
.59392 .67219 m
.59549 .64573 L
s
.57849 .66102 m
.5615 .64875 L
s
.57849 .66102 m
.61092 .65719 L
s
.57849 .66102 m
.59549 .64573 L
s
.57849 .66102 m
.57858 .63376 L
s
.5615 .64875 m
.54328 .6361 L
s
.5615 .64875 m
.59549 .64573 L
s
.5615 .64875 m
.57858 .63376 L
s
.5615 .64875 m
.56036 .62093 L
s
.54328 .6361 m
.524 .62304 L
s
.54328 .6361 m
.57858 .63376 L
s
.54328 .6361 m
.56036 .62093 L
s
.54328 .6361 m
.54103 .60757 L
s
.524 .62304 m
.50386 .60945 L
s
.524 .62304 m
.56036 .62093 L
s
.524 .62304 m
.54103 .60757 L
s
.524 .62304 m
.52084 .5938 L
s
.50386 .60945 m
.48302 .59549 L
s
.50386 .60945 m
.54103 .60757 L
s
.50386 .60945 m
.52084 .5938 L
s
.50386 .60945 m
.49999 .5796 L
s
.48302 .59549 m
.46162 .58127 L
s
.48302 .59549 m
.52084 .5938 L
s
.48302 .59549 m
.49999 .5796 L
s
.48302 .59549 m
.47857 .56518 L
s
.46162 .58127 m
.43983 .56678 L
s
.46162 .58127 m
.49999 .5796 L
s
.46162 .58127 m
.47857 .56518 L
s
.46162 .58127 m
.45677 .55052 L
s
.43983 .56678 m
.41779 .55212 L
s
.43983 .56678 m
.47857 .56518 L
s
.43983 .56678 m
.45677 .55052 L
s
.43983 .56678 m
.43472 .53566 L
s
.41779 .55212 m
.3956 .53731 L
s
.41779 .55212 m
.45677 .55052 L
s
.41779 .55212 m
.43472 .53566 L
s
.41779 .55212 m
.41253 .52071 L
s
.3956 .53731 m
.37338 .52243 L
s
.3956 .53731 m
.43472 .53566 L
s
.3956 .53731 m
.41253 .52071 L
s
.3956 .53731 m
.39031 .50564 L
s
.37338 .52243 m
.35124 .50748 L
s
.37338 .52243 m
.41253 .52071 L
s
.37338 .52243 m
.39031 .50564 L
s
.37338 .52243 m
.36815 .49057 L
s
.35124 .50748 m
.32923 .4925 L
s
.35124 .50748 m
.39031 .50564 L
s
.35124 .50748 m
.36815 .49057 L
s
.35124 .50748 m
.34615 .47549 L
s
.32923 .4925 m
.30751 .47753 L
s
.32923 .4925 m
.36815 .49057 L
s
.32923 .4925 m
.34615 .47549 L
s
.32923 .4925 m
.32445 .46045 L
s
.30751 .47753 m
.2862 .46262 L
s
.30751 .47753 m
.34615 .47549 L
s
.30751 .47753 m
.32445 .46045 L
s
.30751 .47753 m
.30312 .44546 L
s
.2862 .46262 m
.2654 .44787 L
s
.2862 .46262 m
.32445 .46045 L
s
.2862 .46262 m
.30312 .44546 L
s
.2862 .46262 m
.28234 .43066 L
s
.2654 .44787 m
.24529 .43332 L
s
.2654 .44787 m
.30312 .44546 L
s
.2654 .44787 m
.28234 .43066 L
s
.2654 .44787 m
.26225 .41607 L
s
.24529 .43332 m
.22598 .41914 L
s
.24529 .43332 m
.28234 .43066 L
s
.24529 .43332 m
.26225 .41607 L
s
.24529 .43332 m
.24295 .40185 L
s
.22598 .41914 m
.20766 .40539 L
s
.22598 .41914 m
.26225 .41607 L
s
.22598 .41914 m
.24295 .40185 L
s
.22598 .41914 m
.22469 .3881 L
s
.20766 .40539 m
.19055 .3923 L
s
.20766 .40539 m
.24295 .40185 L
s
.20766 .40539 m
.22469 .3881 L
s
.20766 .40539 m
.20762 .37501 L
s
.19055 .3923 m
.17486 .38013 L
s
.19055 .3923 m
.22469 .3881 L
s
.19055 .3923 m
.20762 .37501 L
s
.19055 .3923 m
.192 .3628 L
s
.17486 .38013 m
.16091 .36909 L
s
.17486 .38013 m
.20762 .37501 L
s
.17486 .38013 m
.192 .3628 L
s
.17486 .38013 m
.1781 .35176 L
s
.16091 .36909 m
.14904 .35962 L
s
.16091 .36909 m
.192 .3628 L
s
.16091 .36909 m
.1781 .35176 L
s
.16091 .36909 m
.16635 .34232 L
s
.14904 .35962 m
.1399 .35227 L
s
.14904 .35962 m
.1781 .35176 L
s
.14904 .35962 m
.16635 .34232 L
s
.14904 .35962 m
.15728 .33498 L
s
.1399 .35227 m
.13425 .34783 L
s
.1399 .35227 m
.16635 .34232 L
s
.1399 .35227 m
.15728 .33498 L
s
.1399 .35227 m
.1518 .3305 L
s
.13425 .34783 m
.15728 .33498 L
s
.13425 .34783 m
.1518 .3305 L
s
.64929 .68664 m
.64439 .6827 L
s
.64929 .68664 m
.6665 .67053 L
s
.64929 .68664 m
.66176 .66679 L
s
.64439 .6827 m
.63564 .67541 L
s
.64439 .6827 m
.6665 .67053 L
s
.64439 .6827 m
.66176 .66679 L
s
.64439 .6827 m
.65331 .66011 L
s
.63564 .67541 m
.62449 .66731 L
s
.63564 .67541 m
.66176 .66679 L
s
.63564 .67541 m
.65331 .66011 L
s
.63564 .67541 m
.64193 .65114 L
s
.62449 .66731 m
.61092 .65719 L
s
.62449 .66731 m
.65331 .66011 L
s
.62449 .66731 m
.64193 .65114 L
s
.62449 .66731 m
.62846 .64129 L
s
.61092 .65719 m
.59549 .64573 L
s
.61092 .65719 m
.64193 .65114 L
s
.61092 .65719 m
.62846 .64129 L
s
.61092 .65719 m
.61311 .63003 L
s
.59549 .64573 m
.57858 .63376 L
s
.59549 .64573 m
.62846 .64129 L
s
.59549 .64573 m
.61311 .63003 L
s
.59549 .64573 m
.59619 .61786 L
s
.57858 .63376 m
.56036 .62093 L
s
.57858 .63376 m
.61311 .63003 L
s
.57858 .63376 m
.59619 .61786 L
s
.57858 .63376 m
.57794 .60492 L
s
.56036 .62093 m
.54103 .60757 L
s
.56036 .62093 m
.59619 .61786 L
s
.56036 .62093 m
.57794 .60492 L
s
.56036 .62093 m
.55861 .59139 L
s
.54103 .60757 m
.52084 .5938 L
s
.54103 .60757 m
.57794 .60492 L
s
.54103 .60757 m
.55861 .59139 L
s
.54103 .60757 m
.5384 .57739 L
s
.52084 .5938 m
.49999 .5796 L
s
.52084 .5938 m
.55861 .59139 L
s
.52084 .5938 m
.5384 .57739 L
s
.52084 .5938 m
.51753 .56307 L
s
.49999 .5796 m
.47857 .56518 L
s
.49999 .5796 m
.5384 .57739 L
s
.49999 .5796 m
.51753 .56307 L
s
.49999 .5796 m
.4961 .54845 L
s
.47857 .56518 m
.45677 .55052 L
s
.47857 .56518 m
.51753 .56307 L
s
.47857 .56518 m
.4961 .54845 L
s
.47857 .56518 m
.4743 .53364 L
s
.45677 .55052 m
.43472 .53566 L
s
.45677 .55052 m
.4961 .54845 L
s
.45677 .55052 m
.4743 .53364 L
s
.45677 .55052 m
.45224 .51865 L
s
.43472 .53566 m
.41253 .52071 L
s
.43472 .53566 m
.4743 .53364 L
s
.43472 .53566 m
.45224 .51865 L
s
.43472 .53566 m
.43004 .50355 L
s
.41253 .52071 m
.39031 .50564 L
s
.41253 .52071 m
.45224 .51865 L
s
.41253 .52071 m
.43004 .50355 L
s
.41253 .52071 m
.40782 .48838 L
s
.39031 .50564 m
.36815 .49057 L
s
.39031 .50564 m
.43004 .50355 L
s
.39031 .50564 m
.40782 .48838 L
s
.39031 .50564 m
.38564 .4732 L
s
.36815 .49057 m
.34615 .47549 L
s
.36815 .49057 m
.40782 .48838 L
s
.36815 .49057 m
.38564 .4732 L
s
.36815 .49057 m
.36366 .45801 L
s
.34615 .47549 m
.32445 .46045 L
s
.34615 .47549 m
.38564 .4732 L
s
.34615 .47549 m
.36366 .45801 L
s
.34615 .47549 m
.34193 .4429 L
s
.32445 .46045 m
.30312 .44546 L
s
.32445 .46045 m
.36366 .45801 L
s
.32445 .46045 m
.34193 .4429 L
s
.32445 .46045 m
.3206 .42788 L
s
.30312 .44546 m
.28234 .43066 L
s
.30312 .44546 m
.34193 .4429 L
s
.30312 .44546 m
.3206 .42788 L
s
.30312 .44546 m
.29984 .41301 L
s
.28234 .43066 m
.26225 .41607 L
s
.28234 .43066 m
.3206 .42788 L
s
.28234 .43066 m
.29984 .41301 L
s
.28234 .43066 m
.27973 .39845 L
s
.26225 .41607 m
.24295 .40185 L
s
.26225 .41607 m
.29984 .41301 L
s
.26225 .41607 m
.27973 .39845 L
s
.26225 .41607 m
.26048 .38419 L
s
.24295 .40185 m
.22469 .3881 L
s
.24295 .40185 m
.27973 .39845 L
s
.24295 .40185 m
.26048 .38419 L
s
.24295 .40185 m
.24223 .37047 L
s
.22469 .3881 m
.20762 .37501 L
s
.22469 .3881 m
.26048 .38419 L
s
.22469 .3881 m
.24223 .37047 L
s
.22469 .3881 m
.22523 .35739 L
s
.20762 .37501 m
.192 .3628 L
s
.20762 .37501 m
.24223 .37047 L
s
.20762 .37501 m
.22523 .35739 L
s
.20762 .37501 m
.20964 .34519 L
s
.192 .3628 m
.1781 .35176 L
s
.192 .3628 m
.22523 .35739 L
s
.192 .3628 m
.20964 .34519 L
s
.192 .3628 m
.19579 .33415 L
s
.1781 .35176 m
.16635 .34232 L
s
.1781 .35176 m
.20964 .34519 L
s
.1781 .35176 m
.19579 .33415 L
s
.1781 .35176 m
.18412 .32467 L
s
.16635 .34232 m
.15728 .33498 L
s
.16635 .34232 m
.19579 .33415 L
s
.16635 .34232 m
.18412 .32467 L
s
.16635 .34232 m
.17517 .31733 L
s
.15728 .33498 m
.1518 .3305 L
s
.15728 .33498 m
.18412 .32467 L
s
.15728 .33498 m
.17517 .31733 L
s
.15728 .33498 m
.16975 .31286 L
s
.1518 .3305 m
.17517 .31733 L
s
.1518 .3305 m
.16975 .31286 L
s
.6665 .67053 m
.66176 .66679 L
s
.6665 .67053 m
.68486 .6553 L
s
.6665 .67053 m
.67983 .65079 L
s
.66176 .66679 m
.65331 .66011 L
s
.66176 .66679 m
.68486 .6553 L
s
.66176 .66679 m
.67983 .65079 L
s
.66176 .66679 m
.67134 .64397 L
s
.65331 .66011 m
.64193 .65114 L
s
.65331 .66011 m
.67983 .65079 L
s
.65331 .66011 m
.67134 .64397 L
s
.65331 .66011 m
.65992 .6348 L
s
.64193 .65114 m
.62846 .64129 L
s
.64193 .65114 m
.67134 .64397 L
s
.64193 .65114 m
.65992 .6348 L
s
.64193 .65114 m
.6465 .62481 L
s
.62846 .64129 m
.61311 .63003 L
s
.62846 .64129 m
.65992 .6348 L
s
.62846 .64129 m
.6465 .62481 L
s
.62846 .64129 m
.63117 .61368 L
s
.61311 .63003 m
.59619 .61786 L
s
.61311 .63003 m
.6465 .62481 L
s
.61311 .63003 m
.63117 .61368 L
s
.61311 .63003 m
.61423 .60137 L
s
.59619 .61786 m
.57794 .60492 L
s
.59619 .61786 m
.63117 .61368 L
s
.59619 .61786 m
.61423 .60137 L
s
.59619 .61786 m
.59595 .58828 L
s
.57794 .60492 m
.55861 .59139 L
s
.57794 .60492 m
.61423 .60137 L
s
.57794 .60492 m
.59595 .58828 L
s
.57794 .60492 m
.5766 .57462 L
s
.55861 .59139 m
.5384 .57739 L
s
.55861 .59139 m
.59595 .58828 L
s
.55861 .59139 m
.5766 .57462 L
s
.55861 .59139 m
.55639 .56047 L
s
.5384 .57739 m
.51753 .56307 L
s
.5384 .57739 m
.5766 .57462 L
s
.5384 .57739 m
.55639 .56047 L
s
.5384 .57739 m
.5355 .546 L
s
.51753 .56307 m
.4961 .54845 L
s
.51753 .56307 m
.55639 .56047 L
s
.51753 .56307 m
.5355 .546 L
s
.51753 .56307 m
.5141 .53125 L
s
.4961 .54845 m
.4743 .53364 L
s
.4961 .54845 m
.5355 .546 L
s
.4961 .54845 m
.5141 .53125 L
s
.4961 .54845 m
.49229 .51631 L
s
.4743 .53364 m
.45224 .51865 L
s
.4743 .53364 m
.5141 .53125 L
s
.4743 .53364 m
.49229 .51631 L
s
.4743 .53364 m
.47022 .50118 L
s
.45224 .51865 m
.43004 .50355 L
s
.45224 .51865 m
.49229 .51631 L
s
.45224 .51865 m
.47022 .50118 L
s
.45224 .51865 m
.44803 .48597 L
s
.43004 .50355 m
.40782 .48838 L
s
.43004 .50355 m
.47022 .50118 L
s
.43004 .50355 m
.44803 .48597 L
s
.43004 .50355 m
.42578 .47071 L
s
.40782 .48838 m
.38564 .4732 L
s
.40782 .48838 m
.44803 .48597 L
s
.40782 .48838 m
.42578 .47071 L
s
.40782 .48838 m
.4036 .45544 L
s
.38564 .4732 m
.36366 .45801 L
s
.38564 .4732 m
.42578 .47071 L
s
.38564 .4732 m
.4036 .45544 L
s
.38564 .4732 m
.3816 .4402 L
s
.36366 .45801 m
.34193 .4429 L
s
.36366 .45801 m
.4036 .45544 L
s
.36366 .45801 m
.3816 .4402 L
s
.36366 .45801 m
.35987 .42502 L
s
.34193 .4429 m
.3206 .42788 L
s
.34193 .4429 m
.3816 .4402 L
s
.34193 .4429 m
.35987 .42502 L
s
.34193 .4429 m
.33854 .40999 L
s
.3206 .42788 m
.29984 .41301 L
s
.3206 .42788 m
.35987 .42502 L
s
.3206 .42788 m
.33854 .40999 L
s
.3206 .42788 m
.31776 .39512 L
s
.29984 .41301 m
.27973 .39845 L
s
.29984 .41301 m
.33854 .40999 L
s
.29984 .41301 m
.31776 .39512 L
s
.29984 .41301 m
.29765 .38054 L
s
.27973 .39845 m
.26048 .38419 L
s
.27973 .39845 m
.31776 .39512 L
s
.27973 .39845 m
.29765 .38054 L
s
.27973 .39845 m
.27842 .3663 L
s
.26048 .38419 m
.24223 .37047 L
s
.26048 .38419 m
.29765 .38054 L
s
.26048 .38419 m
.27842 .3663 L
s
.26048 .38419 m
.26022 .3526 L
s
.24223 .37047 m
.22523 .35739 L
s
.24223 .37047 m
.27842 .3663 L
s
.24223 .37047 m
.26022 .3526 L
s
.24223 .37047 m
.24321 .33954 L
s
.22523 .35739 m
.20964 .34519 L
s
.22523 .35739 m
.26022 .3526 L
s
.22523 .35739 m
.24321 .33954 L
s
.22523 .35739 m
.22765 .3274 L
s
.20964 .34519 m
.19579 .33415 L
s
.20964 .34519 m
.24321 .33954 L
s
.20964 .34519 m
.22765 .3274 L
s
.20964 .34519 m
.21389 .31637 L
s
.19579 .33415 m
.18412 .32467 L
s
.19579 .33415 m
.22765 .3274 L
s
.19579 .33415 m
.21389 .31637 L
s
.19579 .33415 m
.20229 .30689 L
s
.18412 .32467 m
.17517 .31733 L
s
.18412 .32467 m
.21389 .31637 L
s
.18412 .32467 m
.20229 .30689 L
s
.18412 .32467 m
.19341 .29951 L
s
.17517 .31733 m
.16975 .31286 L
s
.17517 .31733 m
.20229 .30689 L
s
.17517 .31733 m
.19341 .29951 L
s
.17517 .31733 m
.18804 .29502 L
s
.16975 .31286 m
.19341 .29951 L
s
.16975 .31286 m
.18804 .29502 L
s
.68486 .6553 m
.67983 .65079 L
s
.68486 .6553 m
.70341 .63913 L
s
.68486 .6553 m
.6984 .63469 L
s
.67983 .65079 m
.67134 .64397 L
s
.67983 .65079 m
.70341 .63913 L
s
.67983 .65079 m
.6984 .63469 L
s
.67983 .65079 m
.68985 .62762 L
s
.67134 .64397 m
.65992 .6348 L
s
.67134 .64397 m
.6984 .63469 L
s
.67134 .64397 m
.68985 .62762 L
s
.67134 .64397 m
.67859 .61878 L
s
.65992 .6348 m
.6465 .62481 L
s
.65992 .6348 m
.68985 .62762 L
s
.65992 .6348 m
.67859 .61878 L
s
.65992 .6348 m
.66499 .60832 L
s
.6465 .62481 m
.63117 .61368 L
s
.6465 .62481 m
.67859 .61878 L
s
.6465 .62481 m
.66499 .60832 L
s
.6465 .62481 m
.64956 .59682 L
s
.63117 .61368 m
.61423 .60137 L
s
.63117 .61368 m
.66499 .60832 L
s
.63117 .61368 m
.64956 .59682 L
s
.63117 .61368 m
.63258 .58439 L
s
.61423 .60137 m
.59595 .58828 L
s
.61423 .60137 m
.64956 .59682 L
s
.61423 .60137 m
.63258 .58439 L
s
.61423 .60137 m
.61428 .57115 L
s
.59595 .58828 m
.5766 .57462 L
s
.59595 .58828 m
.63258 .58439 L
s
.59595 .58828 m
.61428 .57115 L
s
.59595 .58828 m
.59493 .55734 L
s
.5766 .57462 m
.55639 .56047 L
s
.5766 .57462 m
.61428 .57115 L
s
.5766 .57462 m
.59493 .55734 L
s
.5766 .57462 m
.5747 .5431 L
s
.55639 .56047 m
.5355 .546 L
s
.55639 .56047 m
.59493 .55734 L
s
.55639 .56047 m
.5747 .5431 L
s
.55639 .56047 m
.55382 .5285 L
s
.5355 .546 m
.5141 .53125 L
s
.5355 .546 m
.5747 .5431 L
s
.5355 .546 m
.55382 .5285 L
s
.5355 .546 m
.53241 .51365 L
s
.5141 .53125 m
.49229 .51631 L
s
.5141 .53125 m
.55382 .5285 L
s
.5141 .53125 m
.53241 .51365 L
s
.5141 .53125 m
.51061 .49856 L
s
.49229 .51631 m
.47022 .50118 L
s
.49229 .51631 m
.53241 .51365 L
s
.49229 .51631 m
.51061 .49856 L
s
.49229 .51631 m
.48855 .48336 L
s
.47022 .50118 m
.44803 .48597 L
s
.47022 .50118 m
.51061 .49856 L
s
.47022 .50118 m
.48855 .48336 L
s
.47022 .50118 m
.46634 .46808 L
s
.44803 .48597 m
.42578 .47071 L
s
.44803 .48597 m
.48855 .48336 L
s
.44803 .48597 m
.46634 .46808 L
s
.44803 .48597 m
.44411 .45275 L
s
.42578 .47071 m
.4036 .45544 L
s
.42578 .47071 m
.46634 .46808 L
s
.42578 .47071 m
.44411 .45275 L
s
.42578 .47071 m
.42192 .43744 L
s
.4036 .45544 m
.3816 .4402 L
s
.4036 .45544 m
.44411 .45275 L
s
.4036 .45544 m
.42192 .43744 L
s
.4036 .45544 m
.3999 .42216 L
s
.3816 .4402 m
.35987 .42502 L
s
.3816 .4402 m
.42192 .43744 L
s
.3816 .4402 m
.3999 .42216 L
s
.3816 .4402 m
.37816 .40694 L
s
.35987 .42502 m
.33854 .40999 L
s
.35987 .42502 m
.3999 .42216 L
s
.35987 .42502 m
.37816 .40694 L
s
.35987 .42502 m
.35683 .39189 L
s
.33854 .40999 m
.31776 .39512 L
s
.33854 .40999 m
.37816 .40694 L
s
.33854 .40999 m
.35683 .39189 L
s
.33854 .40999 m
.33602 .37705 L
s
.31776 .39512 m
.29765 .38054 L
s
.31776 .39512 m
.35683 .39189 L
s
.31776 .39512 m
.33602 .37705 L
s
.31776 .39512 m
.31593 .36246 L
s
.29765 .38054 m
.27842 .3663 L
s
.29765 .38054 m
.33602 .37705 L
s
.29765 .38054 m
.31593 .36246 L
s
.29765 .38054 m
.2967 .34824 L
s
.27842 .3663 m
.26022 .3526 L
s
.27842 .3663 m
.31593 .36246 L
s
.27842 .3663 m
.2967 .34824 L
s
.27842 .3663 m
.27849 .33455 L
s
.26022 .3526 m
.24321 .33954 L
s
.26022 .3526 m
.2967 .34824 L
s
.26022 .3526 m
.27849 .33455 L
s
.26022 .3526 m
.26149 .32158 L
s
.24321 .33954 m
.22765 .3274 L
s
.24321 .33954 m
.27849 .33455 L
s
.24321 .33954 m
.26149 .32158 L
s
.24321 .33954 m
.24598 .30954 L
s
.22765 .3274 m
.21389 .31637 L
s
.22765 .3274 m
.26149 .32158 L
s
.22765 .3274 m
.24598 .30954 L
s
.22765 .3274 m
.2323 .29844 L
s
.21389 .31637 m
.20229 .30689 L
s
.21389 .31637 m
.24598 .30954 L
s
.21389 .31637 m
.2323 .29844 L
s
.21389 .31637 m
.22075 .289 L
s
.20229 .30689 m
.19341 .29951 L
s
.20229 .30689 m
.2323 .29844 L
s
.20229 .30689 m
.22075 .289 L
s
.20229 .30689 m
.21192 .28164 L
s
.19341 .29951 m
.18804 .29502 L
s
.19341 .29951 m
.22075 .289 L
s
.19341 .29951 m
.21192 .28164 L
s
.19341 .29951 m
.20662 .27713 L
s
.18804 .29502 m
.21192 .28164 L
s
.18804 .29502 m
.20662 .27713 L
s
.70341 .63913 m
.6984 .63469 L
s
.70341 .63913 m
.72241 .62288 L
s
.70341 .63913 m
.71729 .6183 L
s
.6984 .63469 m
.68985 .62762 L
s
.6984 .63469 m
.72241 .62288 L
s
.6984 .63469 m
.71729 .6183 L
s
.6984 .63469 m
.70866 .61108 L
s
.68985 .62762 m
.67859 .61878 L
s
.68985 .62762 m
.71729 .6183 L
s
.68985 .62762 m
.70866 .61108 L
s
.68985 .62762 m
.69727 .60191 L
s
.67859 .61878 m
.66499 .60832 L
s
.67859 .61878 m
.70866 .61108 L
s
.67859 .61878 m
.69727 .60191 L
s
.67859 .61878 m
.68364 .59133 L
s
.66499 .60832 m
.64956 .59682 L
s
.66499 .60832 m
.69727 .60191 L
s
.66499 .60832 m
.68364 .59133 L
s
.66499 .60832 m
.66814 .57962 L
s
.64956 .59682 m
.63258 .58439 L
s
.64956 .59682 m
.68364 .59133 L
s
.64956 .59682 m
.66814 .57962 L
s
.64956 .59682 m
.6511 .56698 L
s
.63258 .58439 m
.61428 .57115 L
s
.63258 .58439 m
.66814 .57962 L
s
.63258 .58439 m
.6511 .56698 L
s
.63258 .58439 m
.63281 .55365 L
s
.61428 .57115 m
.59493 .55734 L
s
.61428 .57115 m
.6511 .56698 L
s
.61428 .57115 m
.63281 .55365 L
s
.61428 .57115 m
.61348 .53973 L
s
.59493 .55734 m
.5747 .5431 L
s
.59493 .55734 m
.63281 .55365 L
s
.59493 .55734 m
.61348 .53973 L
s
.59493 .55734 m
.59324 .52539 L
s
.5747 .5431 m
.55382 .5285 L
s
.5747 .5431 m
.61348 .53973 L
s
.5747 .5431 m
.59324 .52539 L
s
.5747 .5431 m
.57236 .51069 L
s
.55382 .5285 m
.53241 .51365 L
s
.55382 .5285 m
.59324 .52539 L
s
.55382 .5285 m
.57236 .51069 L
s
.55382 .5285 m
.55094 .49575 L
s
.53241 .51365 m
.51061 .49856 L
s
.53241 .51365 m
.57236 .51069 L
s
.53241 .51365 m
.55094 .49575 L
s
.53241 .51365 m
.52914 .48057 L
s
.51061 .49856 m
.48855 .48336 L
s
.51061 .49856 m
.55094 .49575 L
s
.51061 .49856 m
.52914 .48057 L
s
.51061 .49856 m
.50708 .46529 L
s
.48855 .48336 m
.46634 .46808 L
s
.48855 .48336 m
.52914 .48057 L
s
.48855 .48336 m
.50708 .46529 L
s
.48855 .48336 m
.48489 .44995 L
s
.46634 .46808 m
.44411 .45275 L
s
.46634 .46808 m
.50708 .46529 L
s
.46634 .46808 m
.48489 .44995 L
s
.46634 .46808 m
.46266 .4346 L
s
.44411 .45275 m
.42192 .43744 L
s
.44411 .45275 m
.48489 .44995 L
s
.44411 .45275 m
.46266 .4346 L
s
.44411 .45275 m
.44048 .41926 L
s
.42192 .43744 m
.3999 .42216 L
s
.42192 .43744 m
.46266 .4346 L
s
.42192 .43744 m
.44048 .41926 L
s
.42192 .43744 m
.41846 .40395 L
s
.3999 .42216 m
.37816 .40694 L
s
.3999 .42216 m
.44048 .41926 L
s
.3999 .42216 m
.41846 .40395 L
s
.3999 .42216 m
.39669 .38875 L
s
.37816 .40694 m
.35683 .39189 L
s
.37816 .40694 m
.41846 .40395 L
s
.37816 .40694 m
.39669 .38875 L
s
.37816 .40694 m
.37534 .37372 L
s
.35683 .39189 m
.33602 .37705 L
s
.35683 .39189 m
.39669 .38875 L
s
.35683 .39189 m
.37534 .37372 L
s
.35683 .39189 m
.35452 .35887 L
s
.33602 .37705 m
.31593 .36246 L
s
.33602 .37705 m
.37534 .37372 L
s
.33602 .37705 m
.35452 .35887 L
s
.33602 .37705 m
.33444 .3443 L
s
.31593 .36246 m
.2967 .34824 L
s
.31593 .36246 m
.35452 .35887 L
s
.31593 .36246 m
.33444 .3443 L
s
.31593 .36246 m
.31519 .33013 L
s
.2967 .34824 m
.27849 .33455 L
s
.2967 .34824 m
.33444 .3443 L
s
.2967 .34824 m
.31519 .33013 L
s
.2967 .34824 m
.29697 .31646 L
s
.27849 .33455 m
.26149 .32158 L
s
.27849 .33455 m
.31519 .33013 L
s
.27849 .33455 m
.29697 .31646 L
s
.27849 .33455 m
.28 .30351 L
s
.26149 .32158 m
.24598 .30954 L
s
.26149 .32158 m
.29697 .31646 L
s
.26149 .32158 m
.28 .30351 L
s
.26149 .32158 m
.26452 .29152 L
s
.24598 .30954 m
.2323 .29844 L
s
.24598 .30954 m
.28 .30351 L
s
.24598 .30954 m
.26452 .29152 L
s
.24598 .30954 m
.25087 .28048 L
s
.2323 .29844 m
.22075 .289 L
s
.2323 .29844 m
.26452 .29152 L
s
.2323 .29844 m
.25087 .28048 L
s
.2323 .29844 m
.23936 .27104 L
s
.22075 .289 m
.21192 .28164 L
s
.22075 .289 m
.25087 .28048 L
s
.22075 .289 m
.23936 .27104 L
s
.22075 .289 m
.2306 .26373 L
s
.21192 .28164 m
.20662 .27713 L
s
.21192 .28164 m
.23936 .27104 L
s
.21192 .28164 m
.2306 .26373 L
s
.21192 .28164 m
.22542 .25934 L
s
.20662 .27713 m
.2306 .26373 L
s
.20662 .27713 m
.22542 .25934 L
s
.72241 .62288 m
.71729 .6183 L
s
.72241 .62288 m
.74132 .60579 L
s
.72241 .62288 m
.73615 .60119 L
s
.71729 .6183 m
.70866 .61108 L
s
.71729 .6183 m
.74132 .60579 L
s
.71729 .6183 m
.73615 .60119 L
s
.71729 .6183 m
.72744 .59393 L
s
.70866 .61108 m
.69727 .60191 L
s
.70866 .61108 m
.73615 .60119 L
s
.70866 .61108 m
.72744 .59393 L
s
.70866 .61108 m
.71601 .58466 L
s
.69727 .60191 m
.68364 .59133 L
s
.69727 .60191 m
.72744 .59393 L
s
.69727 .60191 m
.71601 .58466 L
s
.69727 .60191 m
.70231 .57392 L
s
.68364 .59133 m
.66814 .57962 L
s
.68364 .59133 m
.71601 .58466 L
s
.68364 .59133 m
.70231 .57392 L
s
.68364 .59133 m
.68677 .56203 L
s
.66814 .57962 m
.6511 .56698 L
s
.66814 .57962 m
.70231 .57392 L
s
.66814 .57962 m
.68677 .56203 L
s
.66814 .57962 m
.66973 .5493 L
s
.6511 .56698 m
.63281 .55365 L
s
.6511 .56698 m
.68677 .56203 L
s
.6511 .56698 m
.66973 .5493 L
s
.6511 .56698 m
.65144 .53584 L
s
.63281 .55365 m
.61348 .53973 L
s
.63281 .55365 m
.66973 .5493 L
s
.63281 .55365 m
.65144 .53584 L
s
.63281 .55365 m
.6321 .52181 L
s
.61348 .53973 m
.59324 .52539 L
s
.61348 .53973 m
.65144 .53584 L
s
.61348 .53973 m
.6321 .52181 L
s
.61348 .53973 m
.6119 .50739 L
s
.59324 .52539 m
.57236 .51069 L
s
.59324 .52539 m
.6321 .52181 L
s
.59324 .52539 m
.6119 .50739 L
s
.59324 .52539 m
.59101 .49262 L
s
.57236 .51069 m
.55094 .49575 L
s
.57236 .51069 m
.6119 .50739 L
s
.57236 .51069 m
.59101 .49262 L
s
.57236 .51069 m
.5696 .47759 L
s
.55094 .49575 m
.52914 .48057 L
s
.55094 .49575 m
.59101 .49262 L
s
.55094 .49575 m
.5696 .47759 L
s
.55094 .49575 m
.5478 .46237 L
s
.52914 .48057 m
.50708 .46529 L
s
.52914 .48057 m
.5696 .47759 L
s
.52914 .48057 m
.5478 .46237 L
s
.52914 .48057 m
.52576 .44705 L
s
.50708 .46529 m
.48489 .44995 L
s
.50708 .46529 m
.5478 .46237 L
s
.50708 .46529 m
.52576 .44705 L
s
.50708 .46529 m
.50358 .43169 L
s
.48489 .44995 m
.46266 .4346 L
s
.48489 .44995 m
.52576 .44705 L
s
.48489 .44995 m
.50358 .43169 L
s
.48489 .44995 m
.48135 .41634 L
s
.46266 .4346 m
.44048 .41926 L
s
.46266 .4346 m
.50358 .43169 L
s
.46266 .4346 m
.48135 .41634 L
s
.46266 .4346 m
.45918 .401 L
s
.44048 .41926 m
.41846 .40395 L
s
.44048 .41926 m
.48135 .41634 L
s
.44048 .41926 m
.45918 .401 L
s
.44048 .41926 m
.43714 .38568 L
s
.41846 .40395 m
.39669 .38875 L
s
.41846 .40395 m
.45918 .401 L
s
.41846 .40395 m
.43714 .38568 L
s
.41846 .40395 m
.4154 .37053 L
s
.39669 .38875 m
.37534 .37372 L
s
.39669 .38875 m
.43714 .38568 L
s
.39669 .38875 m
.4154 .37053 L
s
.39669 .38875 m
.39402 .35555 L
s
.37534 .37372 m
.35452 .35887 L
s
.37534 .37372 m
.4154 .37053 L
s
.37534 .37372 m
.39402 .35555 L
s
.37534 .37372 m
.37318 .34081 L
s
.35452 .35887 m
.33444 .3443 L
s
.35452 .35887 m
.39402 .35555 L
s
.35452 .35887 m
.37318 .34081 L
s
.35452 .35887 m
.35307 .32623 L
s
.33444 .3443 m
.31519 .33013 L
s
.33444 .3443 m
.37318 .34081 L
s
.33444 .3443 m
.35307 .32623 L
s
.33444 .3443 m
.33383 .31207 L
s
.31519 .33013 m
.29697 .31646 L
s
.31519 .33013 m
.35307 .32623 L
s
.31519 .33013 m
.33383 .31207 L
s
.31519 .33013 m
.31561 .29845 L
s
.29697 .31646 m
.28 .30351 L
s
.29697 .31646 m
.33383 .31207 L
s
.29697 .31646 m
.31561 .29845 L
s
.29697 .31646 m
.29866 .28555 L
s
.28 .30351 m
.26452 .29152 L
s
.28 .30351 m
.31561 .29845 L
s
.28 .30351 m
.29866 .28555 L
s
.28 .30351 m
.28321 .27346 L
s
.26452 .29152 m
.25087 .28048 L
s
.26452 .29152 m
.29866 .28555 L
s
.26452 .29152 m
.28321 .27346 L
s
.26452 .29152 m
.26954 .26257 L
s
.25087 .28048 m
.23936 .27104 L
s
.25087 .28048 m
.28321 .27346 L
s
.25087 .28048 m
.26954 .26257 L
s
.25087 .28048 m
.25808 .25317 L
s
.23936 .27104 m
.2306 .26373 L
s
.23936 .27104 m
.26954 .26257 L
s
.23936 .27104 m
.25808 .25317 L
s
.23936 .27104 m
.24938 .24584 L
s
.2306 .26373 m
.22542 .25934 L
s
.2306 .26373 m
.25808 .25317 L
s
.2306 .26373 m
.24938 .24584 L
s
.2306 .26373 m
.24427 .24154 L
s
.22542 .25934 m
.24938 .24584 L
s
.22542 .25934 m
.24427 .24154 L
s
.74132 .60579 m
.73615 .60119 L
s
.74132 .60579 m
.76013 .58807 L
s
.74132 .60579 m
.75495 .58358 L
s
.73615 .60119 m
.72744 .59393 L
s
.73615 .60119 m
.76013 .58807 L
s
.73615 .60119 m
.75495 .58358 L
s
.73615 .60119 m
.74623 .57628 L
s
.72744 .59393 m
.71601 .58466 L
s
.72744 .59393 m
.75495 .58358 L
s
.72744 .59393 m
.74623 .57628 L
s
.72744 .59393 m
.73473 .567 L
s
.71601 .58466 m
.70231 .57392 L
s
.71601 .58466 m
.74623 .57628 L
s
.71601 .58466 m
.73473 .567 L
s
.71601 .58466 m
.72097 .55617 L
s
.70231 .57392 m
.68677 .56203 L
s
.70231 .57392 m
.73473 .567 L
s
.70231 .57392 m
.72097 .55617 L
s
.70231 .57392 m
.70541 .54417 L
s
.68677 .56203 m
.66973 .5493 L
s
.68677 .56203 m
.72097 .55617 L
s
.68677 .56203 m
.70541 .54417 L
s
.68677 .56203 m
.68836 .53131 L
s
.66973 .5493 m
.65144 .53584 L
s
.66973 .5493 m
.70541 .54417 L
s
.66973 .5493 m
.68836 .53131 L
s
.66973 .5493 m
.67004 .51777 L
s
.65144 .53584 m
.6321 .52181 L
s
.65144 .53584 m
.68836 .53131 L
s
.65144 .53584 m
.67004 .51777 L
s
.65144 .53584 m
.65072 .50368 L
s
.6321 .52181 m
.6119 .50739 L
s
.6321 .52181 m
.67004 .51777 L
s
.6321 .52181 m
.65072 .50368 L
s
.6321 .52181 m
.63056 .48915 L
s
.6119 .50739 m
.59101 .49262 L
s
.6119 .50739 m
.65072 .50368 L
s
.6119 .50739 m
.63056 .48915 L
s
.6119 .50739 m
.60968 .47437 L
s
.59101 .49262 m
.5696 .47759 L
s
.59101 .49262 m
.63056 .48915 L
s
.59101 .49262 m
.60968 .47437 L
s
.59101 .49262 m
.58827 .45927 L
s
.5696 .47759 m
.5478 .46237 L
s
.5696 .47759 m
.60968 .47437 L
s
.5696 .47759 m
.58827 .45927 L
s
.5696 .47759 m
.56651 .44406 L
s
.5478 .46237 m
.52576 .44705 L
s
.5478 .46237 m
.58827 .45927 L
s
.5478 .46237 m
.56651 .44406 L
s
.5478 .46237 m
.54448 .42873 L
s
.52576 .44705 m
.50358 .43169 L
s
.52576 .44705 m
.56651 .44406 L
s
.52576 .44705 m
.54448 .42873 L
s
.52576 .44705 m
.5223 .41339 L
s
.50358 .43169 m
.48135 .41634 L
s
.50358 .43169 m
.54448 .42873 L
s
.50358 .43169 m
.5223 .41339 L
s
.50358 .43169 m
.50009 .39801 L
s
.48135 .41634 m
.45918 .401 L
s
.48135 .41634 m
.5223 .41339 L
s
.48135 .41634 m
.50009 .39801 L
s
.48135 .41634 m
.47792 .3827 L
s
.45918 .401 m
.43714 .38568 L
s
.45918 .401 m
.50009 .39801 L
s
.45918 .401 m
.47792 .3827 L
s
.45918 .401 m
.45589 .36744 L
s
.43714 .38568 m
.4154 .37053 L
s
.43714 .38568 m
.47792 .3827 L
s
.43714 .38568 m
.45589 .36744 L
s
.43714 .38568 m
.43413 .35231 L
s
.4154 .37053 m
.39402 .35555 L
s
.4154 .37053 m
.45589 .36744 L
s
.4154 .37053 m
.43413 .35231 L
s
.4154 .37053 m
.41275 .3374 L
s
.39402 .35555 m
.37318 .34081 L
s
.39402 .35555 m
.43413 .35231 L
s
.39402 .35555 m
.41275 .3374 L
s
.39402 .35555 m
.39191 .3229 L
s
.37318 .34081 m
.35307 .32623 L
s
.37318 .34081 m
.41275 .3374 L
s
.37318 .34081 m
.39191 .3229 L
s
.37318 .34081 m
.37179 .30837 L
s
.35307 .32623 m
.33383 .31207 L
s
.35307 .32623 m
.39191 .3229 L
s
.35307 .32623 m
.37179 .30837 L
s
.35307 .32623 m
.35254 .29413 L
s
.33383 .31207 m
.31561 .29845 L
s
.33383 .31207 m
.37179 .30837 L
s
.33383 .31207 m
.35254 .29413 L
s
.33383 .31207 m
.33434 .28056 L
s
.31561 .29845 m
.29866 .28555 L
s
.31561 .29845 m
.35254 .29413 L
s
.31561 .29845 m
.33434 .28056 L
s
.31561 .29845 m
.3174 .26772 L
s
.29866 .28555 m
.28321 .27346 L
s
.29866 .28555 m
.33434 .28056 L
s
.29866 .28555 m
.3174 .26772 L
s
.29866 .28555 m
.30196 .2557 L
s
.28321 .27346 m
.26954 .26257 L
s
.28321 .27346 m
.3174 .26772 L
s
.28321 .27346 m
.30196 .2557 L
s
.28321 .27346 m
.2883 .2448 L
s
.26954 .26257 m
.25808 .25317 L
s
.26954 .26257 m
.30196 .2557 L
s
.26954 .26257 m
.2883 .2448 L
s
.26954 .26257 m
.27688 .23545 L
s
.25808 .25317 m
.24938 .24584 L
s
.25808 .25317 m
.2883 .2448 L
s
.25808 .25317 m
.27688 .23545 L
s
.25808 .25317 m
.26822 .2281 L
s
.24938 .24584 m
.24427 .24154 L
s
.24938 .24584 m
.27688 .23545 L
s
.24938 .24584 m
.26822 .2281 L
s
.24938 .24584 m
.26307 .22353 L
s
.24427 .24154 m
.26822 .2281 L
s
.24427 .24154 m
.26307 .22353 L
s
.76013 .58807 m
.75495 .58358 L
s
.76013 .58807 m
.7789 .57016 L
s
.76013 .58807 m
.77366 .56569 L
s
.75495 .58358 m
.74623 .57628 L
s
.75495 .58358 m
.7789 .57016 L
s
.75495 .58358 m
.77366 .56569 L
s
.75495 .58358 m
.76485 .55838 L
s
.74623 .57628 m
.73473 .567 L
s
.74623 .57628 m
.77366 .56569 L
s
.74623 .57628 m
.76485 .55838 L
s
.74623 .57628 m
.75328 .54903 L
s
.73473 .567 m
.72097 .55617 L
s
.73473 .567 m
.76485 .55838 L
s
.73473 .567 m
.75328 .54903 L
s
.73473 .567 m
.7395 .53814 L
s
.72097 .55617 m
.70541 .54417 L
s
.72097 .55617 m
.75328 .54903 L
s
.72097 .55617 m
.7395 .53814 L
s
.72097 .55617 m
.72394 .52611 L
s
.70541 .54417 m
.68836 .53131 L
s
.70541 .54417 m
.7395 .53814 L
s
.70541 .54417 m
.72394 .52611 L
s
.70541 .54417 m
.70687 .51317 L
s
.68836 .53131 m
.67004 .51777 L
s
.68836 .53131 m
.72394 .52611 L
s
.68836 .53131 m
.70687 .51317 L
s
.68836 .53131 m
.68857 .49952 L
s
.67004 .51777 m
.65072 .50368 L
s
.67004 .51777 m
.70687 .51317 L
s
.67004 .51777 m
.68857 .49952 L
s
.67004 .51777 m
.66925 .48541 L
s
.65072 .50368 m
.63056 .48915 L
s
.65072 .50368 m
.68857 .49952 L
s
.65072 .50368 m
.66925 .48541 L
s
.65072 .50368 m
.64911 .47083 L
s
.63056 .48915 m
.60968 .47437 L
s
.63056 .48915 m
.66925 .48541 L
s
.63056 .48915 m
.64911 .47083 L
s
.63056 .48915 m
.62828 .45598 L
s
.60968 .47437 m
.58827 .45927 L
s
.60968 .47437 m
.64911 .47083 L
s
.60968 .47437 m
.62828 .45598 L
s
.60968 .47437 m
.60691 .44093 L
s
.58827 .45927 m
.56651 .44406 L
s
.58827 .45927 m
.62828 .45598 L
s
.58827 .45927 m
.60691 .44093 L
s
.58827 .45927 m
.58516 .4257 L
s
.56651 .44406 m
.54448 .42873 L
s
.56651 .44406 m
.60691 .44093 L
s
.56651 .44406 m
.58516 .4257 L
s
.56651 .44406 m
.56313 .41039 L
s
.54448 .42873 m
.5223 .41339 L
s
.54448 .42873 m
.58516 .4257 L
s
.54448 .42873 m
.56313 .41039 L
s
.54448 .42873 m
.54097 .39506 L
s
.5223 .41339 m
.50009 .39801 L
s
.5223 .41339 m
.56313 .41039 L
s
.5223 .41339 m
.54097 .39506 L
s
.5223 .41339 m
.51876 .37974 L
s
.50009 .39801 m
.47792 .3827 L
s
.50009 .39801 m
.54097 .39506 L
s
.50009 .39801 m
.51876 .37974 L
s
.50009 .39801 m
.49659 .36445 L
s
.47792 .3827 m
.45589 .36744 L
s
.47792 .3827 m
.51876 .37974 L
s
.47792 .3827 m
.49659 .36445 L
s
.47792 .3827 m
.47457 .34927 L
s
.45589 .36744 m
.43413 .35231 L
s
.45589 .36744 m
.49659 .36445 L
s
.45589 .36744 m
.47457 .34927 L
s
.45589 .36744 m
.45281 .3342 L
s
.43413 .35231 m
.41275 .3374 L
s
.43413 .35231 m
.47457 .34927 L
s
.43413 .35231 m
.45281 .3342 L
s
.43413 .35231 m
.43146 .31938 L
s
.41275 .3374 m
.39191 .3229 L
s
.41275 .3374 m
.45281 .3342 L
s
.41275 .3374 m
.43146 .31938 L
s
.41275 .3374 m
.41063 .30479 L
s
.39191 .3229 m
.37179 .30837 L
s
.39191 .3229 m
.43146 .31938 L
s
.39191 .3229 m
.41063 .30479 L
s
.39191 .3229 m
.3905 .29046 L
s
.37179 .30837 m
.35254 .29413 L
s
.37179 .30837 m
.41063 .30479 L
s
.37179 .30837 m
.3905 .29046 L
s
.37179 .30837 m
.37125 .27645 L
s
.35254 .29413 m
.33434 .28056 L
s
.35254 .29413 m
.3905 .29046 L
s
.35254 .29413 m
.37125 .27645 L
s
.35254 .29413 m
.35305 .26301 L
s
.33434 .28056 m
.3174 .26772 L
s
.33434 .28056 m
.37125 .27645 L
s
.33434 .28056 m
.35305 .26301 L
s
.33434 .28056 m
.33613 .2501 L
s
.3174 .26772 m
.30196 .2557 L
s
.3174 .26772 m
.35305 .26301 L
s
.3174 .26772 m
.33613 .2501 L
s
.3174 .26772 m
.32067 .2382 L
s
.30196 .2557 m
.2883 .2448 L
s
.30196 .2557 m
.33613 .2501 L
s
.30196 .2557 m
.32067 .2382 L
s
.30196 .2557 m
.30705 .22736 L
s
.2883 .2448 m
.27688 .23545 L
s
.2883 .2448 m
.32067 .2382 L
s
.2883 .2448 m
.30705 .22736 L
s
.2883 .2448 m
.29568 .21801 L
s
.27688 .23545 m
.26822 .2281 L
s
.27688 .23545 m
.30705 .22736 L
s
.27688 .23545 m
.29568 .21801 L
s
.27688 .23545 m
.28706 .21068 L
s
.26822 .2281 m
.26307 .22353 L
s
.26822 .2281 m
.29568 .21801 L
s
.26822 .2281 m
.28706 .21068 L
s
.26822 .2281 m
.28195 .20608 L
s
.26307 .22353 m
.28706 .21068 L
s
.26307 .22353 m
.28195 .20608 L
s
.7789 .57016 m
.77366 .56569 L
s
.7789 .57016 m
.79755 .55215 L
s
.7789 .57016 m
.79221 .54765 L
s
.77366 .56569 m
.76485 .55838 L
s
.77366 .56569 m
.79755 .55215 L
s
.77366 .56569 m
.79221 .54765 L
s
.77366 .56569 m
.78333 .5403 L
s
.76485 .55838 m
.75328 .54903 L
s
.76485 .55838 m
.79221 .54765 L
s
.76485 .55838 m
.78333 .5403 L
s
.76485 .55838 m
.77168 .53091 L
s
.75328 .54903 m
.7395 .53814 L
s
.75328 .54903 m
.78333 .5403 L
s
.75328 .54903 m
.77168 .53091 L
s
.75328 .54903 m
.7579 .51997 L
s
.7395 .53814 m
.72394 .52611 L
s
.7395 .53814 m
.77168 .53091 L
s
.7395 .53814 m
.7579 .51997 L
s
.7395 .53814 m
.74231 .50788 L
s
.72394 .52611 m
.70687 .51317 L
s
.72394 .52611 m
.7579 .51997 L
s
.72394 .52611 m
.74231 .50788 L
s
.72394 .52611 m
.72523 .49491 L
s
.70687 .51317 m
.68857 .49952 L
s
.70687 .51317 m
.74231 .50788 L
s
.70687 .51317 m
.72523 .49491 L
s
.70687 .51317 m
.70693 .48124 L
s
.68857 .49952 m
.66925 .48541 L
s
.68857 .49952 m
.72523 .49491 L
s
.68857 .49952 m
.70693 .48124 L
s
.68857 .49952 m
.68764 .46702 L
s
.66925 .48541 m
.64911 .47083 L
s
.66925 .48541 m
.70693 .48124 L
s
.66925 .48541 m
.68764 .46702 L
s
.66925 .48541 m
.66751 .45246 L
s
.64911 .47083 m
.62828 .45598 L
s
.64911 .47083 m
.68764 .46702 L
s
.64911 .47083 m
.66751 .45246 L
s
.64911 .47083 m
.6467 .43758 L
s
.62828 .45598 m
.60691 .44093 L
s
.62828 .45598 m
.66751 .45246 L
s
.62828 .45598 m
.6467 .43758 L
s
.62828 .45598 m
.62536 .42255 L
s
.60691 .44093 m
.58516 .4257 L
s
.60691 .44093 m
.6467 .43758 L
s
.60691 .44093 m
.62536 .42255 L
s
.60691 .44093 m
.60365 .40738 L
s
.58516 .4257 m
.56313 .41039 L
s
.58516 .4257 m
.62536 .42255 L
s
.58516 .4257 m
.60365 .40738 L
s
.58516 .4257 m
.58164 .39211 L
s
.56313 .41039 m
.54097 .39506 L
s
.56313 .41039 m
.60365 .40738 L
s
.56313 .41039 m
.58164 .39211 L
s
.56313 .41039 m
.55947 .3768 L
s
.54097 .39506 m
.51876 .37974 L
s
.54097 .39506 m
.58164 .39211 L
s
.54097 .39506 m
.55947 .3768 L
s
.54097 .39506 m
.53727 .36154 L
s
.51876 .37974 m
.49659 .36445 L
s
.51876 .37974 m
.55947 .3768 L
s
.51876 .37974 m
.53727 .36154 L
s
.51876 .37974 m
.5151 .34635 L
s
.49659 .36445 m
.47457 .34927 L
s
.49659 .36445 m
.53727 .36154 L
s
.49659 .36445 m
.5151 .34635 L
s
.49659 .36445 m
.49309 .33125 L
s
.47457 .34927 m
.45281 .3342 L
s
.47457 .34927 m
.5151 .34635 L
s
.47457 .34927 m
.49309 .33125 L
s
.47457 .34927 m
.47135 .31631 L
s
.45281 .3342 m
.43146 .31938 L
s
.45281 .3342 m
.49309 .33125 L
s
.45281 .3342 m
.47135 .31631 L
s
.45281 .3342 m
.45003 .30152 L
s
.43146 .31938 m
.41063 .30479 L
s
.43146 .31938 m
.47135 .31631 L
s
.43146 .31938 m
.45003 .30152 L
s
.43146 .31938 m
.42922 .28706 L
s
.41063 .30479 m
.3905 .29046 L
s
.41063 .30479 m
.45003 .30152 L
s
.41063 .30479 m
.42922 .28706 L
s
.41063 .30479 m
.40909 .27284 L
s
.3905 .29046 m
.37125 .27645 L
s
.3905 .29046 m
.42922 .28706 L
s
.3905 .29046 m
.40909 .27284 L
s
.3905 .29046 m
.38984 .25897 L
s
.37125 .27645 m
.35305 .26301 L
s
.37125 .27645 m
.40909 .27284 L
s
.37125 .27645 m
.38984 .25897 L
s
.37125 .27645 m
.37165 .24561 L
s
.35305 .26301 m
.33613 .2501 L
s
.35305 .26301 m
.38984 .25897 L
s
.35305 .26301 m
.37165 .24561 L
s
.35305 .26301 m
.35471 .23281 L
s
.33613 .2501 m
.32067 .2382 L
s
.33613 .2501 m
.37165 .24561 L
s
.33613 .2501 m
.35471 .23281 L
s
.33613 .2501 m
.33929 .22095 L
s
.32067 .2382 m
.30705 .22736 L
s
.32067 .2382 m
.35471 .23281 L
s
.32067 .2382 m
.33929 .22095 L
s
.32067 .2382 m
.32573 .21025 L
s
.30705 .22736 m
.29568 .21801 L
s
.30705 .22736 m
.33929 .22095 L
s
.30705 .22736 m
.32573 .21025 L
s
.30705 .22736 m
.31439 .20092 L
s
.29568 .21801 m
.28706 .21068 L
s
.29568 .21801 m
.32573 .21025 L
s
.29568 .21801 m
.31439 .20092 L
s
.29568 .21801 m
.30579 .1936 L
s
.28706 .21068 m
.28195 .20608 L
s
.28706 .21068 m
.31439 .20092 L
s
.28706 .21068 m
.30579 .1936 L
s
.28706 .21068 m
.3008 .18929 L
s
.28195 .20608 m
.30579 .1936 L
s
.28195 .20608 m
.3008 .18929 L
s
.79755 .55215 m
.79221 .54765 L
s
.79755 .55215 m
.81601 .53408 L
s
.79755 .55215 m
.8106 .52959 L
s
.79221 .54765 m
.78333 .5403 L
s
.79221 .54765 m
.81601 .53408 L
s
.79221 .54765 m
.8106 .52959 L
s
.79221 .54765 m
.80162 .52224 L
s
.78333 .5403 m
.77168 .53091 L
s
.78333 .5403 m
.8106 .52959 L
s
.78333 .5403 m
.80162 .52224 L
s
.78333 .5403 m
.78993 .51278 L
s
.77168 .53091 m
.7579 .51997 L
s
.77168 .53091 m
.80162 .52224 L
s
.77168 .53091 m
.78993 .51278 L
s
.77168 .53091 m
.77608 .50181 L
s
.7579 .51997 m
.74231 .50788 L
s
.7579 .51997 m
.78993 .51278 L
s
.7579 .51997 m
.77608 .50181 L
s
.7579 .51997 m
.76044 .48968 L
s
.74231 .50788 m
.72523 .49491 L
s
.74231 .50788 m
.77608 .50181 L
s
.74231 .50788 m
.76044 .48968 L
s
.74231 .50788 m
.74335 .47665 L
s
.72523 .49491 m
.70693 .48124 L
s
.72523 .49491 m
.76044 .48968 L
s
.72523 .49491 m
.74335 .47665 L
s
.72523 .49491 m
.72504 .46297 L
s
.70693 .48124 m
.68764 .46702 L
s
.70693 .48124 m
.74335 .47665 L
s
.70693 .48124 m
.72504 .46297 L
s
.70693 .48124 m
.70576 .44874 L
s
.68764 .46702 m
.66751 .45246 L
s
.68764 .46702 m
.72504 .46297 L
s
.68764 .46702 m
.70576 .44874 L
s
.68764 .46702 m
.68564 .43413 L
s
.66751 .45246 m
.6467 .43758 L
s
.66751 .45246 m
.70576 .44874 L
s
.66751 .45246 m
.68564 .43413 L
s
.66751 .45246 m
.66487 .41927 L
s
.6467 .43758 m
.62536 .42255 L
s
.6467 .43758 m
.68564 .43413 L
s
.6467 .43758 m
.66487 .41927 L
s
.6467 .43758 m
.64355 .40425 L
s
.62536 .42255 m
.60365 .40738 L
s
.62536 .42255 m
.66487 .41927 L
s
.62536 .42255 m
.64355 .40425 L
s
.62536 .42255 m
.62183 .3891 L
s
.60365 .40738 m
.58164 .39211 L
s
.60365 .40738 m
.64355 .40425 L
s
.60365 .40738 m
.62183 .3891 L
s
.60365 .40738 m
.59987 .37394 L
s
.58164 .39211 m
.55947 .3768 L
s
.58164 .39211 m
.62183 .3891 L
s
.58164 .39211 m
.59987 .37394 L
s
.58164 .39211 m
.57773 .35873 L
s
.55947 .3768 m
.53727 .36154 L
s
.55947 .3768 m
.59987 .37394 L
s
.55947 .3768 m
.57773 .35873 L
s
.55947 .3768 m
.55553 .34357 L
s
.53727 .36154 m
.5151 .34635 L
s
.53727 .36154 m
.57773 .35873 L
s
.53727 .36154 m
.55553 .34357 L
s
.53727 .36154 m
.53338 .32844 L
s
.5151 .34635 m
.49309 .33125 L
s
.5151 .34635 m
.55553 .34357 L
s
.5151 .34635 m
.53338 .32844 L
s
.5151 .34635 m
.51139 .31342 L
s
.49309 .33125 m
.47135 .31631 L
s
.49309 .33125 m
.53338 .32844 L
s
.49309 .33125 m
.51139 .31342 L
s
.49309 .33125 m
.48966 .2986 L
s
.47135 .31631 m
.45003 .30152 L
s
.47135 .31631 m
.51139 .31342 L
s
.47135 .31631 m
.48966 .2986 L
s
.47135 .31631 m
.46834 .28392 L
s
.45003 .30152 m
.42922 .28706 L
s
.45003 .30152 m
.48966 .2986 L
s
.45003 .30152 m
.46834 .28392 L
s
.45003 .30152 m
.44756 .26959 L
s
.42922 .28706 m
.40909 .27284 L
s
.42922 .28706 m
.46834 .28392 L
s
.42922 .28706 m
.44756 .26959 L
s
.42922 .28706 m
.42746 .25551 L
s
.40909 .27284 m
.38984 .25897 L
s
.40909 .27284 m
.44756 .26959 L
s
.40909 .27284 m
.42746 .25551 L
s
.40909 .27284 m
.40821 .24186 L
s
.38984 .25897 m
.37165 .24561 L
s
.38984 .25897 m
.42746 .25551 L
s
.38984 .25897 m
.40821 .24186 L
s
.38984 .25897 m
.39002 .22861 L
s
.37165 .24561 m
.35471 .23281 L
s
.37165 .24561 m
.40821 .24186 L
s
.37165 .24561 m
.39002 .22861 L
s
.37165 .24561 m
.37309 .21587 L
s
.35471 .23281 m
.33929 .22095 L
s
.35471 .23281 m
.39002 .22861 L
s
.35471 .23281 m
.37309 .21587 L
s
.35471 .23281 m
.3577 .20406 L
s
.33929 .22095 m
.32573 .21025 L
s
.33929 .22095 m
.37309 .21587 L
s
.33929 .22095 m
.3577 .20406 L
s
.33929 .22095 m
.34422 .19363 L
s
.32573 .21025 m
.31439 .20092 L
s
.32573 .21025 m
.3577 .20406 L
s
.32573 .21025 m
.34422 .19363 L
s
.32573 .21025 m
.3328 .18411 L
s
.31439 .20092 m
.30579 .1936 L
s
.31439 .20092 m
.34422 .19363 L
s
.31439 .20092 m
.3328 .18411 L
s
.31439 .20092 m
.32415 .1767 L
s
.30579 .1936 m
.3008 .18929 L
s
.30579 .1936 m
.3328 .18411 L
s
.30579 .1936 m
.32415 .1767 L
s
.30579 .1936 m
.31901 .17196 L
s
.3008 .18929 m
.32415 .1767 L
s
.3008 .18929 m
.31901 .17196 L
s
.81601 .53408 m
.8106 .52959 L
s
.81601 .53408 m
.83417 .51605 L
s
.81601 .53408 m
.82867 .51157 L
s
.8106 .52959 m
.80162 .52224 L
s
.8106 .52959 m
.83417 .51605 L
s
.8106 .52959 m
.82867 .51157 L
s
.8106 .52959 m
.81965 .5042 L
s
.80162 .52224 m
.78993 .51278 L
s
.80162 .52224 m
.82867 .51157 L
s
.80162 .52224 m
.81965 .5042 L
s
.80162 .52224 m
.80788 .49478 L
s
.78993 .51278 m
.77608 .50181 L
s
.78993 .51278 m
.81965 .5042 L
s
.78993 .51278 m
.80788 .49478 L
s
.78993 .51278 m
.79397 .48379 L
s
.77608 .50181 m
.76044 .48968 L
s
.77608 .50181 m
.80788 .49478 L
s
.77608 .50181 m
.79397 .48379 L
s
.77608 .50181 m
.77827 .47158 L
s
.76044 .48968 m
.74335 .47665 L
s
.76044 .48968 m
.79397 .48379 L
s
.76044 .48968 m
.77827 .47158 L
s
.76044 .48968 m
.76113 .45853 L
s
.74335 .47665 m
.72504 .46297 L
s
.74335 .47665 m
.77827 .47158 L
s
.74335 .47665 m
.76113 .45853 L
s
.74335 .47665 m
.74281 .44478 L
s
.72504 .46297 m
.70576 .44874 L
s
.72504 .46297 m
.76113 .45853 L
s
.72504 .46297 m
.74281 .44478 L
s
.72504 .46297 m
.72352 .43056 L
s
.70576 .44874 m
.68564 .43413 L
s
.70576 .44874 m
.74281 .44478 L
s
.70576 .44874 m
.72352 .43056 L
s
.70576 .44874 m
.70343 .41598 L
s
.68564 .43413 m
.66487 .41927 L
s
.68564 .43413 m
.72352 .43056 L
s
.68564 .43413 m
.70343 .41598 L
s
.68564 .43413 m
.68266 .40112 L
s
.66487 .41927 m
.64355 .40425 L
s
.66487 .41927 m
.70343 .41598 L
s
.66487 .41927 m
.68266 .40112 L
s
.66487 .41927 m
.66136 .3861 L
s
.64355 .40425 m
.62183 .3891 L
s
.64355 .40425 m
.68266 .40112 L
s
.64355 .40425 m
.66136 .3861 L
s
.64355 .40425 m
.63969 .37109 L
s
.62183 .3891 m
.59987 .37394 L
s
.62183 .3891 m
.66136 .3861 L
s
.62183 .3891 m
.63969 .37109 L
s
.62183 .3891 m
.61771 .35593 L
s
.59987 .37394 m
.57773 .35873 L
s
.59987 .37394 m
.63969 .37109 L
s
.59987 .37394 m
.61771 .35593 L
s
.59987 .37394 m
.5956 .34086 L
s
.57773 .35873 m
.55553 .34357 L
s
.57773 .35873 m
.61771 .35593 L
s
.57773 .35873 m
.5956 .34086 L
s
.57773 .35873 m
.57344 .32585 L
s
.55553 .34357 m
.53338 .32844 L
s
.55553 .34357 m
.5956 .34086 L
s
.55553 .34357 m
.57344 .32585 L
s
.55553 .34357 m
.55131 .31088 L
s
.53338 .32844 m
.51139 .31342 L
s
.53338 .32844 m
.57344 .32585 L
s
.53338 .32844 m
.55131 .31088 L
s
.53338 .32844 m
.52932 .29592 L
s
.51139 .31342 m
.48966 .2986 L
s
.51139 .31342 m
.55131 .31088 L
s
.51139 .31342 m
.52932 .29592 L
s
.51139 .31342 m
.50762 .28121 L
s
.48966 .2986 m
.46834 .28392 L
s
.48966 .2986 m
.52932 .29592 L
s
.48966 .2986 m
.50762 .28121 L
s
.48966 .2986 m
.4863 .26668 L
s
.46834 .28392 m
.44756 .26959 L
s
.46834 .28392 m
.50762 .28121 L
s
.46834 .28392 m
.4863 .26668 L
s
.46834 .28392 m
.46554 .25242 L
s
.44756 .26959 m
.42746 .25551 L
s
.44756 .26959 m
.4863 .26668 L
s
.44756 .26959 m
.46554 .25242 L
s
.44756 .26959 m
.44545 .23845 L
s
.42746 .25551 m
.40821 .24186 L
s
.42746 .25551 m
.46554 .25242 L
s
.42746 .25551 m
.44545 .23845 L
s
.42746 .25551 m
.4262 .22506 L
s
.40821 .24186 m
.39002 .22861 L
s
.40821 .24186 m
.44545 .23845 L
s
.40821 .24186 m
.4262 .22506 L
s
.40821 .24186 m
.40803 .21189 L
s
.39002 .22861 m
.37309 .21587 L
s
.39002 .22861 m
.4262 .22506 L
s
.39002 .22861 m
.40803 .21189 L
s
.39002 .22861 m
.39116 .19937 L
s
.37309 .21587 m
.3577 .20406 L
s
.37309 .21587 m
.40803 .21189 L
s
.37309 .21587 m
.39116 .19937 L
s
.37309 .21587 m
.37585 .18798 L
s
.3577 .20406 m
.34422 .19363 L
s
.3577 .20406 m
.39116 .19937 L
s
.3577 .20406 m
.37585 .18798 L
s
.3577 .20406 m
.36223 .177 L
s
.34422 .19363 m
.3328 .18411 L
s
.34422 .19363 m
.37585 .18798 L
s
.34422 .19363 m
.36223 .177 L
s
.34422 .19363 m
.35084 .16778 L
s
.3328 .18411 m
.32415 .1767 L
s
.3328 .18411 m
.36223 .177 L
s
.3328 .18411 m
.35084 .16778 L
s
.3328 .18411 m
.34209 .15998 L
s
.32415 .1767 m
.31901 .17196 L
s
.32415 .1767 m
.35084 .16778 L
s
.32415 .1767 m
.34209 .15998 L
s
.32415 .1767 m
.33702 .1553 L
s
.31901 .17196 m
.34209 .15998 L
s
.31901 .17196 m
.33702 .1553 L
s
.83417 .51605 m
.82867 .51157 L
s
.83417 .51605 m
.85197 .49816 L
s
.83417 .51605 m
.8464 .4937 L
s
.82867 .51157 m
.81965 .5042 L
s
.82867 .51157 m
.85197 .49816 L
s
.82867 .51157 m
.8464 .4937 L
s
.82867 .51157 m
.83726 .48636 L
s
.81965 .5042 m
.80788 .49478 L
s
.81965 .5042 m
.8464 .4937 L
s
.81965 .5042 m
.83726 .48636 L
s
.81965 .5042 m
.8254 .47692 L
s
.80788 .49478 m
.79397 .48379 L
s
.80788 .49478 m
.83726 .48636 L
s
.80788 .49478 m
.8254 .47692 L
s
.80788 .49478 m
.81138 .46591 L
s
.79397 .48379 m
.77827 .47158 L
s
.79397 .48379 m
.8254 .47692 L
s
.79397 .48379 m
.81138 .46591 L
s
.79397 .48379 m
.79564 .45372 L
s
.77827 .47158 m
.76113 .45853 L
s
.77827 .47158 m
.81138 .46591 L
s
.77827 .47158 m
.79564 .45372 L
s
.77827 .47158 m
.77845 .44064 L
s
.76113 .45853 m
.74281 .44478 L
s
.76113 .45853 m
.79564 .45372 L
s
.76113 .45853 m
.77845 .44064 L
s
.76113 .45853 m
.76014 .42687 L
s
.74281 .44478 m
.72352 .43056 L
s
.74281 .44478 m
.77845 .44064 L
s
.74281 .44478 m
.76014 .42687 L
s
.74281 .44478 m
.74082 .41261 L
s
.72352 .43056 m
.70343 .41598 L
s
.72352 .43056 m
.76014 .42687 L
s
.72352 .43056 m
.74082 .41261 L
s
.72352 .43056 m
.72073 .39801 L
s
.70343 .41598 m
.68266 .40112 L
s
.70343 .41598 m
.74082 .41261 L
s
.70343 .41598 m
.72073 .39801 L
s
.70343 .41598 m
.7 .38327 L
s
.68266 .40112 m
.66136 .3861 L
s
.68266 .40112 m
.72073 .39801 L
s
.68266 .40112 m
.7 .38327 L
s
.68266 .40112 m
.67869 .36827 L
s
.66136 .3861 m
.63969 .37109 L
s
.66136 .3861 m
.7 .38327 L
s
.66136 .3861 m
.67869 .36827 L
s
.66136 .3861 m
.657 .35322 L
s
.63969 .37109 m
.61771 .35593 L
s
.63969 .37109 m
.67869 .36827 L
s
.63969 .37109 m
.657 .35322 L
s
.63969 .37109 m
.63507 .33822 L
s
.61771 .35593 m
.5956 .34086 L
s
.61771 .35593 m
.657 .35322 L
s
.61771 .35593 m
.63507 .33822 L
s
.61771 .35593 m
.61298 .32331 L
s
.5956 .34086 m
.57344 .32585 L
s
.5956 .34086 m
.63507 .33822 L
s
.5956 .34086 m
.61298 .32331 L
s
.5956 .34086 m
.59084 .30848 L
s
.57344 .32585 m
.55131 .31088 L
s
.57344 .32585 m
.61298 .32331 L
s
.57344 .32585 m
.59084 .30848 L
s
.57344 .32585 m
.56872 .29363 L
s
.55131 .31088 m
.52932 .29592 L
s
.55131 .31088 m
.59084 .30848 L
s
.55131 .31088 m
.56872 .29363 L
s
.55131 .31088 m
.54677 .27881 L
s
.52932 .29592 m
.50762 .28121 L
s
.52932 .29592 m
.56872 .29363 L
s
.52932 .29592 m
.54677 .27881 L
s
.52932 .29592 m
.52505 .26409 L
s
.50762 .28121 m
.4863 .26668 L
s
.50762 .28121 m
.54677 .27881 L
s
.50762 .28121 m
.52505 .26409 L
s
.50762 .28121 m
.50376 .24968 L
s
.4863 .26668 m
.46554 .25242 L
s
.4863 .26668 m
.52505 .26409 L
s
.4863 .26668 m
.50376 .24968 L
s
.4863 .26668 m
.48302 .23573 L
s
.46554 .25242 m
.44545 .23845 L
s
.46554 .25242 m
.50376 .24968 L
s
.46554 .25242 m
.48302 .23573 L
s
.46554 .25242 m
.46295 .22189 L
s
.44545 .23845 m
.4262 .22506 L
s
.44545 .23845 m
.48302 .23573 L
s
.44545 .23845 m
.46295 .22189 L
s
.44545 .23845 m
.44371 .2084 L
s
.4262 .22506 m
.40803 .21189 L
s
.4262 .22506 m
.46295 .22189 L
s
.4262 .22506 m
.44371 .2084 L
s
.4262 .22506 m
.4256 .19568 L
s
.40803 .21189 m
.39116 .19937 L
s
.40803 .21189 m
.44371 .2084 L
s
.40803 .21189 m
.4256 .19568 L
s
.40803 .21189 m
.40874 .18319 L
s
.39116 .19937 m
.37585 .18798 L
s
.39116 .19937 m
.4256 .19568 L
s
.39116 .19937 m
.40874 .18319 L
s
.39116 .19937 m
.39346 .17191 L
s
.37585 .18798 m
.36223 .177 L
s
.37585 .18798 m
.40874 .18319 L
s
.37585 .18798 m
.39346 .17191 L
s
.37585 .18798 m
.37985 .16118 L
s
.36223 .177 m
.35084 .16778 L
s
.36223 .177 m
.39346 .17191 L
s
.36223 .177 m
.37985 .16118 L
s
.36223 .177 m
.36843 .15187 L
s
.35084 .16778 m
.34209 .15998 L
s
.35084 .16778 m
.37985 .16118 L
s
.35084 .16778 m
.36843 .15187 L
s
.35084 .16778 m
.35974 .14423 L
s
.34209 .15998 m
.33702 .1553 L
s
.34209 .15998 m
.36843 .15187 L
s
.34209 .15998 m
.35974 .14423 L
s
.34209 .15998 m
.35451 .13905 L
s
.33702 .1553 m
.35974 .14423 L
s
.33702 .1553 m
.35451 .13905 L
s
.85197 .49816 m
.8464 .4937 L
s
.85197 .49816 m
.86936 .48065 L
s
.85197 .49816 m
.86362 .47617 L
s
.8464 .4937 m
.83726 .48636 L
s
.8464 .4937 m
.86936 .48065 L
s
.8464 .4937 m
.86362 .47617 L
s
.8464 .4937 m
.85435 .46881 L
s
.83726 .48636 m
.8254 .47692 L
s
.83726 .48636 m
.86362 .47617 L
s
.83726 .48636 m
.85435 .46881 L
s
.83726 .48636 m
.84236 .45936 L
s
.8254 .47692 m
.81138 .46591 L
s
.8254 .47692 m
.85435 .46881 L
s
.8254 .47692 m
.84236 .45936 L
s
.8254 .47692 m
.82828 .44835 L
s
.81138 .46591 m
.79564 .45372 L
s
.81138 .46591 m
.84236 .45936 L
s
.81138 .46591 m
.82828 .44835 L
s
.81138 .46591 m
.81242 .43615 L
s
.79564 .45372 m
.77845 .44064 L
s
.79564 .45372 m
.82828 .44835 L
s
.79564 .45372 m
.81242 .43615 L
s
.79564 .45372 m
.79523 .42307 L
s
.77845 .44064 m
.76014 .42687 L
s
.77845 .44064 m
.81242 .43615 L
s
.77845 .44064 m
.79523 .42307 L
s
.77845 .44064 m
.77686 .40926 L
s
.76014 .42687 m
.74082 .41261 L
s
.76014 .42687 m
.79523 .42307 L
s
.76014 .42687 m
.77686 .40926 L
s
.76014 .42687 m
.75753 .39503 L
s
.74082 .41261 m
.72073 .39801 L
s
.74082 .41261 m
.77686 .40926 L
s
.74082 .41261 m
.75753 .39503 L
s
.74082 .41261 m
.73743 .38043 L
s
.72073 .39801 m
.7 .38327 L
s
.72073 .39801 m
.75753 .39503 L
s
.72073 .39801 m
.73743 .38043 L
s
.72073 .39801 m
.71667 .36568 L
s
.7 .38327 m
.67869 .36827 L
s
.7 .38327 m
.73743 .38043 L
s
.7 .38327 m
.71667 .36568 L
s
.7 .38327 m
.69539 .35079 L
s
.67869 .36827 m
.657 .35322 L
s
.67869 .36827 m
.71667 .36568 L
s
.67869 .36827 m
.69539 .35079 L
s
.67869 .36827 m
.67372 .33582 L
s
.657 .35322 m
.63507 .33822 L
s
.657 .35322 m
.69539 .35079 L
s
.657 .35322 m
.67372 .33582 L
s
.657 .35322 m
.65177 .32086 L
s
.63507 .33822 m
.61298 .32331 L
s
.63507 .33822 m
.67372 .33582 L
s
.63507 .33822 m
.65177 .32086 L
s
.63507 .33822 m
.62971 .30602 L
s
.61298 .32331 m
.59084 .30848 L
s
.61298 .32331 m
.65177 .32086 L
s
.61298 .32331 m
.62971 .30602 L
s
.61298 .32331 m
.60757 .29133 L
s
.59084 .30848 m
.56872 .29363 L
s
.59084 .30848 m
.62971 .30602 L
s
.59084 .30848 m
.60757 .29133 L
s
.59084 .30848 m
.58552 .27707 L
s
.56872 .29363 m
.54677 .27881 L
s
.56872 .29363 m
.60757 .29133 L
s
.56872 .29363 m
.58552 .27707 L
s
.56872 .29363 m
.56353 .26212 L
s
.54677 .27881 m
.52505 .26409 L
s
.54677 .27881 m
.58552 .27707 L
s
.54677 .27881 m
.56353 .26212 L
s
.54677 .27881 m
.54186 .24753 L
s
.52505 .26409 m
.50376 .24968 L
s
.52505 .26409 m
.56353 .26212 L
s
.52505 .26409 m
.54186 .24753 L
s
.52505 .26409 m
.52059 .23315 L
s
.50376 .24968 m
.48302 .23573 L
s
.50376 .24968 m
.54186 .24753 L
s
.50376 .24968 m
.52059 .23315 L
s
.50376 .24968 m
.49984 .21935 L
s
.48302 .23573 m
.46295 .22189 L
s
.48302 .23573 m
.52059 .23315 L
s
.48302 .23573 m
.49984 .21935 L
s
.48302 .23573 m
.47981 .20563 L
s
.46295 .22189 m
.44371 .2084 L
s
.46295 .22189 m
.49984 .21935 L
s
.46295 .22189 m
.47981 .20563 L
s
.46295 .22189 m
.46063 .19248 L
s
.44371 .2084 m
.4256 .19568 L
s
.44371 .2084 m
.47981 .20563 L
s
.44371 .2084 m
.46063 .19248 L
s
.44371 .2084 m
.44252 .17971 L
s
.4256 .19568 m
.40874 .18319 L
s
.4256 .19568 m
.46063 .19248 L
s
.4256 .19568 m
.44252 .17971 L
s
.4256 .19568 m
.42571 .16748 L
s
.40874 .18319 m
.39346 .17191 L
s
.40874 .18319 m
.44252 .17971 L
s
.40874 .18319 m
.42571 .16748 L
s
.40874 .18319 m
.41035 .1559 L
s
.39346 .17191 m
.37985 .16118 L
s
.39346 .17191 m
.42571 .16748 L
s
.39346 .17191 m
.41035 .1559 L
s
.39346 .17191 m
.39682 .14563 L
s
.37985 .16118 m
.36843 .15187 L
s
.37985 .16118 m
.41035 .1559 L
s
.37985 .16118 m
.39682 .14563 L
s
.37985 .16118 m
.38537 .13604 L
s
.36843 .15187 m
.35974 .14423 L
s
.36843 .15187 m
.39682 .14563 L
s
.36843 .15187 m
.38537 .13604 L
s
.36843 .15187 m
.37698 .12965 L
s
.35974 .14423 m
.35451 .13905 L
s
.35974 .14423 m
.38537 .13604 L
s
.35974 .14423 m
.37698 .12965 L
s
.35974 .14423 m
.37125 .12318 L
s
.35451 .13905 m
.37698 .12965 L
s
.35451 .13905 m
.37125 .12318 L
s
.86936 .48065 m
.86362 .47617 L
s
.86936 .48065 m
.88607 .46356 L
s
.86936 .48065 m
.88024 .45909 L
s
.86362 .47617 m
.85435 .46881 L
s
.86362 .47617 m
.88607 .46356 L
s
.86362 .47617 m
.88024 .45909 L
s
.86362 .47617 m
.87079 .45168 L
s
.85435 .46881 m
.84236 .45936 L
s
.85435 .46881 m
.88024 .45909 L
s
.85435 .46881 m
.87079 .45168 L
s
.85435 .46881 m
.85868 .44221 L
s
.84236 .45936 m
.82828 .44835 L
s
.84236 .45936 m
.87079 .45168 L
s
.84236 .45936 m
.85868 .44221 L
s
.84236 .45936 m
.84445 .43117 L
s
.82828 .44835 m
.81242 .43615 L
s
.82828 .44835 m
.85868 .44221 L
s
.82828 .44835 m
.84445 .43117 L
s
.82828 .44835 m
.82857 .41903 L
s
.81242 .43615 m
.79523 .42307 L
s
.81242 .43615 m
.84445 .43117 L
s
.81242 .43615 m
.82857 .41903 L
s
.81242 .43615 m
.81131 .40594 L
s
.79523 .42307 m
.77686 .40926 L
s
.79523 .42307 m
.82857 .41903 L
s
.79523 .42307 m
.81131 .40594 L
s
.79523 .42307 m
.79289 .39215 L
s
.77686 .40926 m
.75753 .39503 L
s
.77686 .40926 m
.81131 .40594 L
s
.77686 .40926 m
.79289 .39215 L
s
.77686 .40926 m
.77354 .3779 L
s
.75753 .39503 m
.73743 .38043 L
s
.75753 .39503 m
.79289 .39215 L
s
.75753 .39503 m
.77354 .3779 L
s
.75753 .39503 m
.75338 .36337 L
s
.73743 .38043 m
.71667 .36568 L
s
.73743 .38043 m
.77354 .3779 L
s
.73743 .38043 m
.75338 .36337 L
s
.73743 .38043 m
.73261 .34862 L
s
.71667 .36568 m
.69539 .35079 L
s
.71667 .36568 m
.75338 .36337 L
s
.71667 .36568 m
.73261 .34862 L
s
.71667 .36568 m
.71135 .33383 L
s
.69539 .35079 m
.67372 .33582 L
s
.69539 .35079 m
.73261 .34862 L
s
.69539 .35079 m
.71135 .33383 L
s
.69539 .35079 m
.68969 .31898 L
s
.67372 .33582 m
.65177 .32086 L
s
.67372 .33582 m
.71135 .33383 L
s
.67372 .33582 m
.68969 .31898 L
s
.67372 .33582 m
.66774 .3041 L
s
.65177 .32086 m
.62971 .30602 L
s
.65177 .32086 m
.68969 .31898 L
s
.65177 .32086 m
.66774 .3041 L
s
.65177 .32086 m
.64564 .28929 L
s
.62971 .30602 m
.60757 .29133 L
s
.62971 .30602 m
.66774 .3041 L
s
.62971 .30602 m
.64564 .28929 L
s
.62971 .30602 m
.6235 .27471 L
s
.60757 .29133 m
.58552 .27707 L
s
.60757 .29133 m
.64564 .28929 L
s
.60757 .29133 m
.6235 .27471 L
s
.60757 .29133 m
.6014 .26018 L
s
.58552 .27707 m
.56353 .26212 L
s
.58552 .27707 m
.6235 .27471 L
s
.58552 .27707 m
.6014 .26018 L
s
.58552 .27707 m
.5795 .24594 L
s
.56353 .26212 m
.54186 .24753 L
s
.56353 .26212 m
.6014 .26018 L
s
.56353 .26212 m
.5795 .24594 L
s
.56353 .26212 m
.55784 .2313 L
s
.54186 .24753 m
.52059 .23315 L
s
.54186 .24753 m
.5795 .24594 L
s
.54186 .24753 m
.55784 .2313 L
s
.54186 .24753 m
.5366 .21712 L
s
.52059 .23315 m
.49984 .21935 L
s
.52059 .23315 m
.55784 .2313 L
s
.52059 .23315 m
.5366 .21712 L
s
.52059 .23315 m
.51591 .20348 L
s
.49984 .21935 m
.47981 .20563 L
s
.49984 .21935 m
.5366 .21712 L
s
.49984 .21935 m
.51591 .20348 L
s
.49984 .21935 m
.49591 .18987 L
s
.47981 .20563 m
.46063 .19248 L
s
.47981 .20563 m
.51591 .20348 L
s
.47981 .20563 m
.49591 .18987 L
s
.47981 .20563 m
.47675 .17686 L
s
.46063 .19248 m
.44252 .17971 L
s
.46063 .19248 m
.49591 .18987 L
s
.46063 .19248 m
.47675 .17686 L
s
.46063 .19248 m
.45866 .16423 L
s
.44252 .17971 m
.42571 .16748 L
s
.44252 .17971 m
.47675 .17686 L
s
.44252 .17971 m
.45866 .16423 L
s
.44252 .17971 m
.44185 .152 L
s
.42571 .16748 m
.41035 .1559 L
s
.42571 .16748 m
.45866 .16423 L
s
.42571 .16748 m
.44185 .152 L
s
.42571 .16748 m
.4265 .14042 L
s
.41035 .1559 m
.39682 .14563 L
s
.41035 .1559 m
.44185 .152 L
s
.41035 .1559 m
.4265 .14042 L
s
.41035 .1559 m
.41305 .13065 L
s
.39682 .14563 m
.38537 .13604 L
s
.39682 .14563 m
.4265 .14042 L
s
.39682 .14563 m
.41305 .13065 L
s
.39682 .14563 m
.40152 .12105 L
s
.38537 .13604 m
.37698 .12965 L
s
.38537 .13604 m
.41305 .13065 L
s
.38537 .13604 m
.40152 .12105 L
s
.38537 .13604 m
.39258 .11325 L
s
.37698 .12965 m
.37125 .12318 L
s
.37698 .12965 m
.40152 .12105 L
s
.37698 .12965 m
.39258 .11325 L
s
.37698 .12965 m
.38733 .10827 L
s
.37125 .12318 m
.39258 .11325 L
s
.37125 .12318 m
.38733 .10827 L
s
.88607 .46356 m
.88024 .45909 L
s
.88607 .46356 m
.90208 .44708 L
s
.88607 .46356 m
.89609 .4426 L
s
.88024 .45909 m
.87079 .45168 L
s
.88024 .45909 m
.90208 .44708 L
s
.88024 .45909 m
.89609 .4426 L
s
.88024 .45909 m
.88647 .43515 L
s
.87079 .45168 m
.85868 .44221 L
s
.87079 .45168 m
.89609 .4426 L
s
.87079 .45168 m
.88647 .43515 L
s
.87079 .45168 m
.87421 .42565 L
s
.85868 .44221 m
.84445 .43117 L
s
.85868 .44221 m
.88647 .43515 L
s
.85868 .44221 m
.87421 .42565 L
s
.85868 .44221 m
.85986 .41464 L
s
.84445 .43117 m
.82857 .41903 L
s
.84445 .43117 m
.87421 .42565 L
s
.84445 .43117 m
.85986 .41464 L
s
.84445 .43117 m
.8439 .40248 L
s
.82857 .41903 m
.81131 .40594 L
s
.82857 .41903 m
.85986 .41464 L
s
.82857 .41903 m
.8439 .40248 L
s
.82857 .41903 m
.82656 .38939 L
s
.81131 .40594 m
.79289 .39215 L
s
.81131 .40594 m
.8439 .40248 L
s
.81131 .40594 m
.82656 .38939 L
s
.81131 .40594 m
.80815 .37577 L
s
.79289 .39215 m
.77354 .3779 L
s
.79289 .39215 m
.82656 .38939 L
s
.79289 .39215 m
.80815 .37577 L
s
.79289 .39215 m
.78865 .36145 L
s
.77354 .3779 m
.75338 .36337 L
s
.77354 .3779 m
.80815 .37577 L
s
.77354 .3779 m
.78865 .36145 L
s
.77354 .3779 m
.76845 .34691 L
s
.75338 .36337 m
.73261 .34862 L
s
.75338 .36337 m
.78865 .36145 L
s
.75338 .36337 m
.76845 .34691 L
s
.75338 .36337 m
.74768 .33234 L
s
.73261 .34862 m
.71135 .33383 L
s
.73261 .34862 m
.76845 .34691 L
s
.73261 .34862 m
.74768 .33234 L
s
.73261 .34862 m
.72638 .31754 L
s
.71135 .33383 m
.68969 .31898 L
s
.71135 .33383 m
.74768 .33234 L
s
.71135 .33383 m
.72638 .31754 L
s
.71135 .33383 m
.70469 .30277 L
s
.68969 .31898 m
.66774 .3041 L
s
.68969 .31898 m
.72638 .31754 L
s
.68969 .31898 m
.70469 .30277 L
s
.68969 .31898 m
.68273 .28795 L
s
.66774 .3041 m
.64564 .28929 L
s
.66774 .3041 m
.70469 .30277 L
s
.66774 .3041 m
.68273 .28795 L
s
.66774 .3041 m
.66062 .27328 L
s
.64564 .28929 m
.6235 .27471 L
s
.64564 .28929 m
.68273 .28795 L
s
.64564 .28929 m
.66062 .27328 L
s
.64564 .28929 m
.63843 .25874 L
s
.6235 .27471 m
.6014 .26018 L
s
.6235 .27471 m
.66062 .27328 L
s
.6235 .27471 m
.63843 .25874 L
s
.6235 .27471 m
.61639 .24426 L
s
.6014 .26018 m
.5795 .24594 L
s
.6014 .26018 m
.63843 .25874 L
s
.6014 .26018 m
.61639 .24426 L
s
.6014 .26018 m
.59448 .23004 L
s
.5795 .24594 m
.55784 .2313 L
s
.5795 .24594 m
.61639 .24426 L
s
.5795 .24594 m
.59448 .23004 L
s
.5795 .24594 m
.57287 .21585 L
s
.55784 .2313 m
.5366 .21712 L
s
.55784 .2313 m
.59448 .23004 L
s
.55784 .2313 m
.57287 .21585 L
s
.55784 .2313 m
.55168 .20196 L
s
.5366 .21712 m
.51591 .20348 L
s
.5366 .21712 m
.57287 .21585 L
s
.5366 .21712 m
.55168 .20196 L
s
.5366 .21712 m
.53106 .1882 L
s
.51591 .20348 m
.49591 .18987 L
s
.51591 .20348 m
.55168 .20196 L
s
.51591 .20348 m
.53106 .1882 L
s
.51591 .20348 m
.51112 .17495 L
s
.49591 .18987 m
.47675 .17686 L
s
.49591 .18987 m
.53106 .1882 L
s
.49591 .18987 m
.51112 .17495 L
s
.49591 .18987 m
.49202 .1623 L
s
.47675 .17686 m
.45866 .16423 L
s
.47675 .17686 m
.51112 .17495 L
s
.47675 .17686 m
.49202 .1623 L
s
.47675 .17686 m
.474 .15011 L
s
.45866 .16423 m
.44185 .152 L
s
.45866 .16423 m
.49202 .1623 L
s
.45866 .16423 m
.474 .15011 L
s
.45866 .16423 m
.45712 .13704 L
s
.44185 .152 m
.4265 .14042 L
s
.44185 .152 m
.474 .15011 L
s
.44185 .152 m
.45712 .13704 L
s
.44185 .152 m
.44179 .12607 L
s
.4265 .14042 m
.41305 .13065 L
s
.4265 .14042 m
.45712 .13704 L
s
.4265 .14042 m
.44179 .12607 L
s
.4265 .14042 m
.4281 .11518 L
s
.41305 .13065 m
.40152 .12105 L
s
.41305 .13065 m
.44179 .12607 L
s
.41305 .13065 m
.4281 .11518 L
s
.41305 .13065 m
.41667 .10653 L
s
.40152 .12105 m
.39258 .11325 L
s
.40152 .12105 m
.4281 .11518 L
s
.40152 .12105 m
.41667 .10653 L
s
.40152 .12105 m
.40761 .09808 L
s
.39258 .11325 m
.38733 .10827 L
s
.39258 .11325 m
.41667 .10653 L
s
.39258 .11325 m
.40761 .09808 L
s
.39258 .11325 m
.40275 .09441 L
s
.38733 .10827 m
.40761 .09808 L
s
.38733 .10827 m
.40275 .09441 L
s
.90208 .44708 m
.89609 .4426 L
s
.90208 .44708 m
.91731 .43142 L
s
.90208 .44708 m
.91112 .42693 L
s
.89609 .4426 m
.88647 .43515 L
s
.89609 .4426 m
.91731 .43142 L
s
.89609 .4426 m
.91112 .42693 L
s
.89609 .4426 m
.90132 .41946 L
s
.88647 .43515 m
.87421 .42565 L
s
.88647 .43515 m
.91112 .42693 L
s
.88647 .43515 m
.90132 .41946 L
s
.88647 .43515 m
.88882 .40992 L
s
.87421 .42565 m
.85986 .41464 L
s
.87421 .42565 m
.90132 .41946 L
s
.87421 .42565 m
.88882 .40992 L
s
.87421 .42565 m
.87436 .39889 L
s
.85986 .41464 m
.8439 .40248 L
s
.85986 .41464 m
.88882 .40992 L
s
.85986 .41464 m
.87436 .39889 L
s
.85986 .41464 m
.85825 .38673 L
s
.8439 .40248 m
.82656 .38939 L
s
.8439 .40248 m
.87436 .39889 L
s
.8439 .40248 m
.85825 .38673 L
s
.8439 .40248 m
.84081 .37369 L
s
.82656 .38939 m
.80815 .37577 L
s
.82656 .38939 m
.85825 .38673 L
s
.82656 .38939 m
.84081 .37369 L
s
.82656 .38939 m
.8222 .35995 L
s
.80815 .37577 m
.78865 .36145 L
s
.80815 .37577 m
.84081 .37369 L
s
.80815 .37577 m
.8222 .35995 L
s
.80815 .37577 m
.80269 .34579 L
s
.78865 .36145 m
.76845 .34691 L
s
.78865 .36145 m
.8222 .35995 L
s
.78865 .36145 m
.80269 .34579 L
s
.78865 .36145 m
.78243 .33131 L
s
.76845 .34691 m
.74768 .33234 L
s
.76845 .34691 m
.80269 .34579 L
s
.76845 .34691 m
.78243 .33131 L
s
.76845 .34691 m
.76158 .31668 L
s
.74768 .33234 m
.72638 .31754 L
s
.74768 .33234 m
.78243 .33131 L
s
.74768 .33234 m
.76158 .31668 L
s
.74768 .33234 m
.74023 .30193 L
s
.72638 .31754 m
.70469 .30277 L
s
.72638 .31754 m
.76158 .31668 L
s
.72638 .31754 m
.74023 .30193 L
s
.72638 .31754 m
.71851 .28717 L
s
.70469 .30277 m
.68273 .28795 L
s
.70469 .30277 m
.74023 .30193 L
s
.70469 .30277 m
.71851 .28717 L
s
.70469 .30277 m
.69655 .27246 L
s
.68273 .28795 m
.66062 .27328 L
s
.68273 .28795 m
.71851 .28717 L
s
.68273 .28795 m
.69655 .27246 L
s
.68273 .28795 m
.67444 .25795 L
s
.66062 .27328 m
.63843 .25874 L
s
.66062 .27328 m
.69655 .27246 L
s
.66062 .27328 m
.67444 .25795 L
s
.66062 .27328 m
.65232 .24398 L
s
.63843 .25874 m
.61639 .24426 L
s
.63843 .25874 m
.67444 .25795 L
s
.63843 .25874 m
.65232 .24398 L
s
.63843 .25874 m
.63022 .22915 L
s
.61639 .24426 m
.59448 .23004 L
s
.61639 .24426 m
.65232 .24398 L
s
.61639 .24426 m
.63022 .22915 L
s
.61639 .24426 m
.60835 .21488 L
s
.59448 .23004 m
.57287 .21585 L
s
.59448 .23004 m
.63022 .22915 L
s
.59448 .23004 m
.60835 .21488 L
s
.59448 .23004 m
.58677 .20113 L
s
.57287 .21585 m
.55168 .20196 L
s
.57287 .21585 m
.60835 .21488 L
s
.57287 .21585 m
.58677 .20113 L
s
.57287 .21585 m
.56563 .18736 L
s
.55168 .20196 m
.53106 .1882 L
s
.55168 .20196 m
.58677 .20113 L
s
.55168 .20196 m
.56563 .18736 L
s
.55168 .20196 m
.54506 .17348 L
s
.53106 .1882 m
.51112 .17495 L
s
.53106 .1882 m
.56563 .18736 L
s
.53106 .1882 m
.54506 .17348 L
s
.53106 .1882 m
.52517 .16065 L
s
.51112 .17495 m
.49202 .1623 L
s
.51112 .17495 m
.54506 .17348 L
s
.51112 .17495 m
.52517 .16065 L
s
.51112 .17495 m
.50613 .14815 L
s
.49202 .1623 m
.474 .15011 L
s
.49202 .1623 m
.52517 .16065 L
s
.49202 .1623 m
.50613 .14815 L
s
.49202 .1623 m
.48803 .13529 L
s
.474 .15011 m
.45712 .13704 L
s
.474 .15011 m
.50613 .14815 L
s
.474 .15011 m
.48803 .13529 L
s
.474 .15011 m
.47131 .12316 L
s
.45712 .13704 m
.44179 .12607 L
s
.45712 .13704 m
.48803 .13529 L
s
.45712 .13704 m
.47131 .12316 L
s
.45712 .13704 m
.45594 .11187 L
s
.44179 .12607 m
.4281 .11518 L
s
.44179 .12607 m
.47131 .12316 L
s
.44179 .12607 m
.45594 .11187 L
s
.44179 .12607 m
.44223 .10126 L
s
.4281 .11518 m
.41667 .10653 L
s
.4281 .11518 m
.45594 .11187 L
s
.4281 .11518 m
.44223 .10126 L
s
.4281 .11518 m
.43045 .09115 L
s
.41667 .10653 m
.40761 .09808 L
s
.41667 .10653 m
.44223 .10126 L
s
.41667 .10653 m
.43045 .09115 L
s
.41667 .10653 m
.42169 .08457 L
s
.40761 .09808 m
.40275 .09441 L
s
.40761 .09808 m
.43045 .09115 L
s
.40761 .09808 m
.42169 .08457 L
s
.40761 .09808 m
.41566 .07769 L
s
.40275 .09441 m
.42169 .08457 L
s
.40275 .09441 m
.41566 .07769 L
s
.91731 .43142 m
.91112 .42693 L
s
.91731 .43142 m
.93168 .41688 L
s
.91731 .43142 m
.92522 .41227 L
s
.91112 .42693 m
.90132 .41946 L
s
.91112 .42693 m
.93168 .41688 L
s
.91112 .42693 m
.92522 .41227 L
s
.91112 .42693 m
.91507 .4047 L
s
.90132 .41946 m
.88882 .40992 L
s
.90132 .41946 m
.92522 .41227 L
s
.90132 .41946 m
.91507 .4047 L
s
.90132 .41946 m
.90241 .39517 L
s
.88882 .40992 m
.87436 .39889 L
s
.88882 .40992 m
.91507 .4047 L
s
.88882 .40992 m
.90241 .39517 L
s
.88882 .40992 m
.88774 .38418 L
s
.87436 .39889 m
.85825 .38673 L
s
.87436 .39889 m
.90241 .39517 L
s
.87436 .39889 m
.88774 .38418 L
s
.87436 .39889 m
.87146 .37205 L
s
.85825 .38673 m
.84081 .37369 L
s
.85825 .38673 m
.88774 .38418 L
s
.85825 .38673 m
.87146 .37205 L
s
.85825 .38673 m
.85388 .35906 L
s
.84081 .37369 m
.8222 .35995 L
s
.84081 .37369 m
.87146 .37205 L
s
.84081 .37369 m
.85388 .35906 L
s
.84081 .37369 m
.83514 .34538 L
s
.8222 .35995 m
.80269 .34579 L
s
.8222 .35995 m
.85388 .35906 L
s
.8222 .35995 m
.83514 .34538 L
s
.8222 .35995 m
.81552 .33122 L
s
.80269 .34579 m
.78243 .33131 L
s
.80269 .34579 m
.83514 .34538 L
s
.80269 .34579 m
.81552 .33122 L
s
.80269 .34579 m
.79519 .31679 L
s
.78243 .33131 m
.76158 .31668 L
s
.78243 .33131 m
.81552 .33122 L
s
.78243 .33131 m
.79519 .31679 L
s
.78243 .33131 m
.77425 .30218 L
s
.76158 .31668 m
.74023 .30193 L
s
.76158 .31668 m
.79519 .31679 L
s
.76158 .31668 m
.77425 .30218 L
s
.76158 .31668 m
.75284 .2875 L
s
.74023 .30193 m
.71851 .28717 L
s
.74023 .30193 m
.77425 .30218 L
s
.74023 .30193 m
.75284 .2875 L
s
.74023 .30193 m
.73108 .27273 L
s
.71851 .28717 m
.69655 .27246 L
s
.71851 .28717 m
.75284 .2875 L
s
.71851 .28717 m
.73108 .27273 L
s
.71851 .28717 m
.70908 .25819 L
s
.69655 .27246 m
.67444 .25795 L
s
.69655 .27246 m
.73108 .27273 L
s
.69655 .27246 m
.70908 .25819 L
s
.69655 .27246 m
.68693 .24361 L
s
.67444 .25795 m
.65232 .24398 L
s
.67444 .25795 m
.70908 .25819 L
s
.67444 .25795 m
.68693 .24361 L
s
.67444 .25795 m
.66477 .2292 L
s
.65232 .24398 m
.63022 .22915 L
s
.65232 .24398 m
.68693 .24361 L
s
.65232 .24398 m
.66477 .2292 L
s
.65232 .24398 m
.64272 .21502 L
s
.63022 .22915 m
.60835 .21488 L
s
.63022 .22915 m
.66477 .2292 L
s
.63022 .22915 m
.64272 .21502 L
s
.63022 .22915 m
.62085 .20072 L
s
.60835 .21488 m
.58677 .20113 L
s
.60835 .21488 m
.64272 .21502 L
s
.60835 .21488 m
.62085 .20072 L
s
.60835 .21488 m
.59932 .1871 L
s
.58677 .20113 m
.56563 .18736 L
s
.58677 .20113 m
.62085 .20072 L
s
.58677 .20113 m
.59932 .1871 L
s
.58677 .20113 m
.57824 .17318 L
s
.56563 .18736 m
.54506 .17348 L
s
.56563 .18736 m
.59932 .1871 L
s
.56563 .18736 m
.57824 .17318 L
s
.56563 .18736 m
.55773 .15979 L
s
.54506 .17348 m
.52517 .16065 L
s
.54506 .17348 m
.57824 .17318 L
s
.54506 .17348 m
.55773 .15979 L
s
.54506 .17348 m
.53788 .14666 L
s
.52517 .16065 m
.50613 .14815 L
s
.52517 .16065 m
.55773 .15979 L
s
.52517 .16065 m
.53788 .14666 L
s
.52517 .16065 m
.51889 .13417 L
s
.50613 .14815 m
.48803 .13529 L
s
.50613 .14815 m
.53788 .14666 L
s
.50613 .14815 m
.51889 .13417 L
s
.50613 .14815 m
.50094 .12334 L
s
.48803 .13529 m
.47131 .12316 L
s
.48803 .13529 m
.51889 .13417 L
s
.48803 .13529 m
.50094 .12334 L
s
.48803 .13529 m
.48414 .10931 L
s
.47131 .12316 m
.45594 .11187 L
s
.47131 .12316 m
.50094 .12334 L
s
.47131 .12316 m
.48414 .10931 L
s
.47131 .12316 m
.46862 .09746 L
s
.45594 .11187 m
.44223 .10126 L
s
.45594 .11187 m
.48414 .10931 L
s
.45594 .11187 m
.46862 .09746 L
s
.45594 .11187 m
.45473 .0867 L
s
.44223 .10126 m
.43045 .09115 L
s
.44223 .10126 m
.46862 .09746 L
s
.44223 .10126 m
.45473 .0867 L
s
.44223 .10126 m
.44284 .07661 L
s
.43045 .09115 m
.42169 .08457 L
s
.43045 .09115 m
.45473 .0867 L
s
.43045 .09115 m
.44284 .07661 L
s
.43045 .09115 m
.43343 .06815 L
s
.42169 .08457 m
.41566 .07769 L
s
.42169 .08457 m
.44284 .07661 L
s
.42169 .08457 m
.43343 .06815 L
s
.42169 .08457 m
.42804 .06373 L
s
.41566 .07769 m
.43343 .06815 L
s
.41566 .07769 m
.42804 .06373 L
s
.93168 .41688 m
.92522 .41227 L
s
.93168 .41688 m
.94496 .40359 L
s
.93168 .41688 m
.9381 .39887 L
s
.92522 .41227 m
.91507 .4047 L
s
.92522 .41227 m
.94496 .40359 L
s
.92522 .41227 m
.9381 .39887 L
s
.92522 .41227 m
.92768 .39126 L
s
.91507 .4047 m
.90241 .39517 L
s
.91507 .4047 m
.9381 .39887 L
s
.91507 .4047 m
.92768 .39126 L
s
.91507 .4047 m
.9147 .38172 L
s
.90241 .39517 m
.88774 .38418 L
s
.90241 .39517 m
.92768 .39126 L
s
.90241 .39517 m
.9147 .38172 L
s
.90241 .39517 m
.89977 .37077 L
s
.88774 .38418 m
.87146 .37205 L
s
.88774 .38418 m
.9147 .38172 L
s
.88774 .38418 m
.89977 .37077 L
s
.88774 .38418 m
.8834 .35882 L
s
.87146 .37205 m
.85388 .35906 L
s
.87146 .37205 m
.89977 .37077 L
s
.87146 .37205 m
.8834 .35882 L
s
.87146 .37205 m
.86555 .34584 L
s
.85388 .35906 m
.83514 .34538 L
s
.85388 .35906 m
.8834 .35882 L
s
.85388 .35906 m
.86555 .34584 L
s
.85388 .35906 m
.84663 .33219 L
s
.83514 .34538 m
.81552 .33122 L
s
.83514 .34538 m
.86555 .34584 L
s
.83514 .34538 m
.84663 .33219 L
s
.83514 .34538 m
.82691 .31813 L
s
.81552 .33122 m
.79519 .31679 L
s
.81552 .33122 m
.84663 .33219 L
s
.81552 .33122 m
.82691 .31813 L
s
.81552 .33122 m
.80647 .30374 L
s
.79519 .31679 m
.77425 .30218 L
s
.79519 .31679 m
.82691 .31813 L
s
.79519 .31679 m
.80647 .30374 L
s
.79519 .31679 m
.78545 .28919 L
s
.77425 .30218 m
.75284 .2875 L
s
.77425 .30218 m
.80647 .30374 L
s
.77425 .30218 m
.78545 .28919 L
s
.77425 .30218 m
.76396 .27446 L
s
.75284 .2875 m
.73108 .27273 L
s
.75284 .2875 m
.78545 .28919 L
s
.75284 .2875 m
.76396 .27446 L
s
.75284 .2875 m
.74213 .25975 L
s
.73108 .27273 m
.70908 .25819 L
s
.73108 .27273 m
.76396 .27446 L
s
.73108 .27273 m
.74213 .25975 L
s
.73108 .27273 m
.72008 .24518 L
s
.70908 .25819 m
.68693 .24361 L
s
.70908 .25819 m
.74213 .25975 L
s
.70908 .25819 m
.72008 .24518 L
s
.70908 .25819 m
.69792 .2311 L
s
.68693 .24361 m
.66477 .2292 L
s
.68693 .24361 m
.72008 .24518 L
s
.68693 .24361 m
.69792 .2311 L
s
.68693 .24361 m
.67575 .21632 L
s
.66477 .2292 m
.64272 .21502 L
s
.66477 .2292 m
.69792 .2311 L
s
.66477 .2292 m
.67575 .21632 L
s
.66477 .2292 m
.65364 .20196 L
s
.64272 .21502 m
.62085 .20072 L
s
.64272 .21502 m
.67575 .21632 L
s
.64272 .21502 m
.65364 .20196 L
s
.64272 .21502 m
.63179 .18773 L
s
.62085 .20072 m
.59932 .1871 L
s
.62085 .20072 m
.65364 .20196 L
s
.62085 .20072 m
.63179 .18773 L
s
.62085 .20072 m
.61027 .17376 L
s
.59932 .1871 m
.57824 .17318 L
s
.59932 .1871 m
.63179 .18773 L
s
.59932 .1871 m
.61027 .17376 L
s
.59932 .1871 m
.58925 .1601 L
s
.57824 .17318 m
.55773 .15979 L
s
.57824 .17318 m
.61027 .17376 L
s
.57824 .17318 m
.58925 .1601 L
s
.57824 .17318 m
.56882 .14637 L
s
.55773 .15979 m
.53788 .14666 L
s
.55773 .15979 m
.58925 .1601 L
s
.55773 .15979 m
.56882 .14637 L
s
.55773 .15979 m
.54902 .13329 L
s
.53788 .14666 m
.51889 .13417 L
s
.53788 .14666 m
.56882 .14637 L
s
.53788 .14666 m
.54902 .13329 L
s
.53788 .14666 m
.53 .12125 L
s
.51889 .13417 m
.50094 .12334 L
s
.51889 .13417 m
.54902 .13329 L
s
.51889 .13417 m
.53 .12125 L
s
.51889 .13417 m
.51207 .10822 L
s
.50094 .12334 m
.48414 .10931 L
s
.50094 .12334 m
.53 .12125 L
s
.50094 .12334 m
.51207 .10822 L
s
.50094 .12334 m
.49532 .09593 L
s
.48414 .10931 m
.46862 .09746 L
s
.48414 .10931 m
.51207 .10822 L
s
.48414 .10931 m
.49532 .09593 L
s
.48414 .10931 m
.47983 .08396 L
s
.46862 .09746 m
.45473 .0867 L
s
.46862 .09746 m
.49532 .09593 L
s
.46862 .09746 m
.47983 .08396 L
s
.46862 .09746 m
.46588 .07345 L
s
.45473 .0867 m
.44284 .07661 L
s
.45473 .0867 m
.47983 .08396 L
s
.45473 .0867 m
.46588 .07345 L
s
.45473 .0867 m
.45381 .06299 L
s
.44284 .07661 m
.43343 .06815 L
s
.44284 .07661 m
.46588 .07345 L
s
.44284 .07661 m
.45381 .06299 L
s
.44284 .07661 m
.44427 .05432 L
s
.43343 .06815 m
.42804 .06373 L
s
.43343 .06815 m
.45381 .06299 L
s
.43343 .06815 m
.44427 .05432 L
s
.43343 .06815 m
.43816 .04825 L
s
.42804 .06373 m
.44427 .05432 L
s
.42804 .06373 m
.43816 .04825 L
s
.94496 .40359 m
.9381 .39887 L
s
.94496 .40359 m
.95701 .39193 L
s
.94496 .40359 m
.94968 .38711 L
s
.9381 .39887 m
.92768 .39126 L
s
.9381 .39887 m
.95701 .39193 L
s
.9381 .39887 m
.94968 .38711 L
s
.9381 .39887 m
.93876 .37948 L
s
.92768 .39126 m
.9147 .38172 L
s
.92768 .39126 m
.94968 .38711 L
s
.92768 .39126 m
.93876 .37948 L
s
.92768 .39126 m
.92538 .36999 L
s
.9147 .38172 m
.89977 .37077 L
s
.9147 .38172 m
.93876 .37948 L
s
.9147 .38172 m
.92538 .36999 L
s
.9147 .38172 m
.91016 .35911 L
s
.89977 .37077 m
.8834 .35882 L
s
.89977 .37077 m
.92538 .36999 L
s
.89977 .37077 m
.91016 .35911 L
s
.89977 .37077 m
.8934 .34714 L
s
.8834 .35882 m
.86555 .34584 L
s
.8834 .35882 m
.91016 .35911 L
s
.8834 .35882 m
.8934 .34714 L
s
.8834 .35882 m
.87539 .33433 L
s
.86555 .34584 m
.84663 .33219 L
s
.86555 .34584 m
.8934 .34714 L
s
.86555 .34584 m
.87539 .33433 L
s
.86555 .34584 m
.85637 .32089 L
s
.84663 .33219 m
.82691 .31813 L
s
.84663 .33219 m
.87539 .33433 L
s
.84663 .33219 m
.85637 .32089 L
s
.84663 .33219 m
.8365 .30693 L
s
.82691 .31813 m
.80647 .30374 L
s
.82691 .31813 m
.85637 .32089 L
s
.82691 .31813 m
.8365 .30693 L
s
.82691 .31813 m
.81596 .29258 L
s
.80647 .30374 m
.78545 .28919 L
s
.80647 .30374 m
.8365 .30693 L
s
.80647 .30374 m
.81596 .29258 L
s
.80647 .30374 m
.79484 .27803 L
s
.78545 .28919 m
.76396 .27446 L
s
.78545 .28919 m
.81596 .29258 L
s
.78545 .28919 m
.79484 .27803 L
s
.78545 .28919 m
.77327 .26333 L
s
.76396 .27446 m
.74213 .25975 L
s
.76396 .27446 m
.79484 .27803 L
s
.76396 .27446 m
.77327 .26333 L
s
.76396 .27446 m
.75137 .24866 L
s
.74213 .25975 m
.72008 .24518 L
s
.74213 .25975 m
.77327 .26333 L
s
.74213 .25975 m
.75137 .24866 L
s
.74213 .25975 m
.72925 .23398 L
s
.72008 .24518 m
.69792 .2311 L
s
.72008 .24518 m
.75137 .24866 L
s
.72008 .24518 m
.72925 .23398 L
s
.72008 .24518 m
.70703 .21953 L
s
.69792 .2311 m
.67575 .21632 L
s
.69792 .2311 m
.72925 .23398 L
s
.69792 .2311 m
.70703 .21953 L
s
.69792 .2311 m
.68485 .20521 L
s
.67575 .21632 m
.65364 .20196 L
s
.67575 .21632 m
.70703 .21953 L
s
.67575 .21632 m
.68485 .20521 L
s
.67575 .21632 m
.66274 .19081 L
s
.65364 .20196 m
.63179 .18773 L
s
.65364 .20196 m
.68485 .20521 L
s
.65364 .20196 m
.66274 .19081 L
s
.65364 .20196 m
.64089 .17659 L
s
.63179 .18773 m
.61027 .17376 L
s
.63179 .18773 m
.66274 .19081 L
s
.63179 .18773 m
.64089 .17659 L
s
.63179 .18773 m
.61942 .1622 L
s
.61027 .17376 m
.58925 .1601 L
s
.61027 .17376 m
.64089 .17659 L
s
.61027 .17376 m
.61942 .1622 L
s
.61027 .17376 m
.59843 .14826 L
s
.58925 .1601 m
.56882 .14637 L
s
.58925 .1601 m
.61942 .1622 L
s
.58925 .1601 m
.59843 .14826 L
s
.58925 .1601 m
.57808 .13454 L
s
.56882 .14637 m
.54902 .13329 L
s
.56882 .14637 m
.59843 .14826 L
s
.56882 .14637 m
.57808 .13454 L
s
.56882 .14637 m
.55828 .12189 L
s
.54902 .13329 m
.53 .12125 L
s
.54902 .13329 m
.57808 .13454 L
s
.54902 .13329 m
.55828 .12189 L
s
.54902 .13329 m
.53941 .10873 L
s
.53 .12125 m
.51207 .10822 L
s
.53 .12125 m
.55828 .12189 L
s
.53 .12125 m
.53941 .10873 L
s
.53 .12125 m
.52152 .09633 L
s
.51207 .10822 m
.49532 .09593 L
s
.51207 .10822 m
.53941 .10873 L
s
.51207 .10822 m
.52152 .09633 L
s
.51207 .10822 m
.50477 .08399 L
s
.49532 .09593 m
.47983 .08396 L
s
.49532 .09593 m
.52152 .09633 L
s
.49532 .09593 m
.50477 .08399 L
s
.49532 .09593 m
.48934 .0721 L
s
.47983 .08396 m
.46588 .07345 L
s
.47983 .08396 m
.50477 .08399 L
s
.47983 .08396 m
.48934 .0721 L
s
.47983 .08396 m
.47529 .06117 L
s
.46588 .07345 m
.45381 .06299 L
s
.46588 .07345 m
.48934 .0721 L
s
.46588 .07345 m
.47529 .06117 L
s
.46588 .07345 m
.46323 .05122 L
s
.45381 .06299 m
.44427 .05432 L
s
.45381 .06299 m
.47529 .06117 L
s
.45381 .06299 m
.46323 .05122 L
s
.45381 .06299 m
.45344 .04196 L
s
.44427 .05432 m
.43816 .04825 L
s
.44427 .05432 m
.46323 .05122 L
s
.44427 .05432 m
.45344 .04196 L
s
.44427 .05432 m
.44727 .03548 L
s
.43816 .04825 m
.45344 .04196 L
s
.43816 .04825 m
.44727 .03548 L
s
.95701 .39193 m
.94968 .38711 L
s
.95701 .39193 m
.96745 .38232 L
s
.95701 .39193 m
.95949 .37759 L
s
.94968 .38711 m
.93876 .37948 L
s
.94968 .38711 m
.96745 .38232 L
s
.94968 .38711 m
.95949 .37759 L
s
.94968 .38711 m
.94781 .37003 L
s
.93876 .37948 m
.92538 .36999 L
s
.93876 .37948 m
.95949 .37759 L
s
.93876 .37948 m
.94781 .37003 L
s
.93876 .37948 m
.93391 .36065 L
s
.92538 .36999 m
.91016 .35911 L
s
.92538 .36999 m
.94781 .37003 L
s
.92538 .36999 m
.93391 .36065 L
s
.92538 .36999 m
.91834 .34989 L
s
.91016 .35911 m
.8934 .34714 L
s
.91016 .35911 m
.93391 .36065 L
s
.91016 .35911 m
.91834 .34989 L
s
.91016 .35911 m
.90134 .33807 L
s
.8934 .34714 m
.87539 .33433 L
s
.8934 .34714 m
.91834 .34989 L
s
.8934 .34714 m
.90134 .33807 L
s
.8934 .34714 m
.8831 .32535 L
s
.87539 .33433 m
.85637 .32089 L
s
.87539 .33433 m
.90134 .33807 L
s
.87539 .33433 m
.8831 .32535 L
s
.87539 .33433 m
.86387 .31197 L
s
.85637 .32089 m
.8365 .30693 L
s
.85637 .32089 m
.8831 .32535 L
s
.85637 .32089 m
.86387 .31197 L
s
.85637 .32089 m
.84386 .29812 L
s
.8365 .30693 m
.81596 .29258 L
s
.8365 .30693 m
.86387 .31197 L
s
.8365 .30693 m
.84386 .29812 L
s
.8365 .30693 m
.82322 .28388 L
s
.81596 .29258 m
.79484 .27803 L
s
.81596 .29258 m
.84386 .29812 L
s
.81596 .29258 m
.82322 .28388 L
s
.81596 .29258 m
.80201 .26933 L
s
.79484 .27803 m
.77327 .26333 L
s
.79484 .27803 m
.82322 .28388 L
s
.79484 .27803 m
.80201 .26933 L
s
.79484 .27803 m
.78035 .25469 L
s
.77327 .26333 m
.75137 .24866 L
s
.77327 .26333 m
.80201 .26933 L
s
.77327 .26333 m
.78035 .25469 L
s
.77327 .26333 m
.75836 .23998 L
s
.75137 .24866 m
.72925 .23398 L
s
.75137 .24866 m
.78035 .25469 L
s
.75137 .24866 m
.75836 .23998 L
s
.75137 .24866 m
.7362 .2254 L
s
.72925 .23398 m
.70703 .21953 L
s
.72925 .23398 m
.75836 .23998 L
s
.72925 .23398 m
.7362 .2254 L
s
.72925 .23398 m
.71396 .21071 L
s
.70703 .21953 m
.68485 .20521 L
s
.70703 .21953 m
.7362 .2254 L
s
.70703 .21953 m
.71396 .21071 L
s
.70703 .21953 m
.69172 .1964 L
s
.68485 .20521 m
.66274 .19081 L
s
.68485 .20521 m
.71396 .21071 L
s
.68485 .20521 m
.69172 .1964 L
s
.68485 .20521 m
.66953 .18259 L
s
.66274 .19081 m
.64089 .17659 L
s
.66274 .19081 m
.69172 .1964 L
s
.66274 .19081 m
.66953 .18259 L
s
.66274 .19081 m
.64778 .16772 L
s
.64089 .17659 m
.61942 .1622 L
s
.64089 .17659 m
.66953 .18259 L
s
.64089 .17659 m
.64778 .16772 L
s
.64089 .17659 m
.62628 .15369 L
s
.61942 .1622 m
.59843 .14826 L
s
.61942 .1622 m
.64778 .16772 L
s
.61942 .1622 m
.62628 .15369 L
s
.61942 .1622 m
.60544 .13901 L
s
.59843 .14826 m
.57808 .13454 L
s
.59843 .14826 m
.62628 .15369 L
s
.59843 .14826 m
.60544 .13901 L
s
.59843 .14826 m
.58513 .12493 L
s
.57808 .13454 m
.55828 .12189 L
s
.57808 .13454 m
.60544 .13901 L
s
.57808 .13454 m
.58513 .12493 L
s
.57808 .13454 m
.56545 .11144 L
s
.55828 .12189 m
.53941 .10873 L
s
.55828 .12189 m
.58513 .12493 L
s
.55828 .12189 m
.56545 .11144 L
s
.55828 .12189 m
.54664 .09855 L
s
.53941 .10873 m
.52152 .09633 L
s
.53941 .10873 m
.56545 .11144 L
s
.53941 .10873 m
.54664 .09855 L
s
.53941 .10873 m
.52878 .08603 L
s
.52152 .09633 m
.50477 .08399 L
s
.52152 .09633 m
.54664 .09855 L
s
.52152 .09633 m
.52878 .08603 L
s
.52152 .09633 m
.51203 .07419 L
s
.50477 .08399 m
.48934 .0721 L
s
.50477 .08399 m
.52878 .08603 L
s
.50477 .08399 m
.51203 .07419 L
s
.50477 .08399 m
.49673 .06204 L
s
.48934 .0721 m
.47529 .06117 L
s
.48934 .0721 m
.51203 .07419 L
s
.48934 .0721 m
.49673 .06204 L
s
.48934 .0721 m
.4826 .05286 L
s
.47529 .06117 m
.46323 .05122 L
s
.47529 .06117 m
.49673 .06204 L
s
.47529 .06117 m
.4826 .05286 L
s
.47529 .06117 m
.47064 .04123 L
s
.46323 .05122 m
.45344 .04196 L
s
.46323 .05122 m
.4826 .05286 L
s
.46323 .05122 m
.47064 .04123 L
s
.46323 .05122 m
.46097 .03419 L
s
.45344 .04196 m
.44727 .03548 L
s
.45344 .04196 m
.47064 .04123 L
s
.45344 .04196 m
.46097 .03419 L
s
.45344 .04196 m
.45477 .02505 L
s
.44727 .03548 m
.46097 .03419 L
s
.44727 .03548 m
.45477 .02505 L
s
.96745 .38232 m
.95949 .37759 L
s
.96745 .38232 m
.97619 .376 L
s
.96745 .38232 m
.9663 .37147 L
s
.95949 .37759 m
.94781 .37003 L
s
.95949 .37759 m
.97619 .376 L
s
.95949 .37759 m
.9663 .37147 L
s
.95949 .37759 m
.95391 .36407 L
s
.94781 .37003 m
.93391 .36065 L
s
.94781 .37003 m
.9663 .37147 L
s
.94781 .37003 m
.95391 .36407 L
s
.94781 .37003 m
.93953 .3549 L
s
.93391 .36065 m
.91834 .34989 L
s
.93391 .36065 m
.95391 .36407 L
s
.93391 .36065 m
.93953 .3549 L
s
.93391 .36065 m
.92366 .34428 L
s
.91834 .34989 m
.90134 .33807 L
s
.91834 .34989 m
.93953 .3549 L
s
.91834 .34989 m
.92366 .34428 L
s
.91834 .34989 m
.9064 .33254 L
s
.90134 .33807 m
.8831 .32535 L
s
.90134 .33807 m
.92366 .34428 L
s
.90134 .33807 m
.9064 .33254 L
s
.90134 .33807 m
.88798 .31996 L
s
.8831 .32535 m
.86387 .31197 L
s
.8831 .32535 m
.9064 .33254 L
s
.8831 .32535 m
.88798 .31996 L
s
.8831 .32535 m
.86852 .30663 L
s
.86387 .31197 m
.84386 .29812 L
s
.86387 .31197 m
.88798 .31996 L
s
.86387 .31197 m
.86852 .30663 L
s
.86387 .31197 m
.84841 .29282 L
s
.84386 .29812 m
.82322 .28388 L
s
.84386 .29812 m
.86852 .30663 L
s
.84386 .29812 m
.84841 .29282 L
s
.84386 .29812 m
.82766 .27864 L
s
.82322 .28388 m
.80201 .26933 L
s
.82322 .28388 m
.84841 .29282 L
s
.82322 .28388 m
.82766 .27864 L
s
.82322 .28388 m
.80634 .26413 L
s
.80201 .26933 m
.78035 .25469 L
s
.80201 .26933 m
.82766 .27864 L
s
.80201 .26933 m
.80634 .26413 L
s
.80201 .26933 m
.78463 .2494 L
s
.78035 .25469 m
.75836 .23998 L
s
.78035 .25469 m
.80634 .26413 L
s
.78035 .25469 m
.78463 .2494 L
s
.78035 .25469 m
.76257 .23467 L
s
.75836 .23998 m
.7362 .2254 L
s
.75836 .23998 m
.78463 .2494 L
s
.75836 .23998 m
.76257 .23467 L
s
.75836 .23998 m
.74035 .21993 L
s
.7362 .2254 m
.71396 .21071 L
s
.7362 .2254 m
.76257 .23467 L
s
.7362 .2254 m
.74035 .21993 L
s
.7362 .2254 m
.71807 .20532 L
s
.71396 .21071 m
.69172 .1964 L
s
.71396 .21071 m
.74035 .21993 L
s
.71396 .21071 m
.71807 .20532 L
s
.71396 .21071 m
.69579 .19092 L
s
.69172 .1964 m
.66953 .18259 L
s
.69172 .1964 m
.71807 .20532 L
s
.69172 .1964 m
.69579 .19092 L
s
.69172 .1964 m
.67362 .17664 L
s
.66953 .18259 m
.64778 .16772 L
s
.66953 .18259 m
.69579 .19092 L
s
.66953 .18259 m
.67362 .17664 L
s
.66953 .18259 m
.65169 .16294 L
s
.64778 .16772 m
.62628 .15369 L
s
.64778 .16772 m
.67362 .17664 L
s
.64778 .16772 m
.65169 .16294 L
s
.64778 .16772 m
.63046 .14764 L
s
.62628 .15369 m
.60544 .13901 L
s
.62628 .15369 m
.65169 .16294 L
s
.62628 .15369 m
.63046 .14764 L
s
.62628 .15369 m
.60956 .13317 L
s
.60544 .13901 m
.58513 .12493 L
s
.60544 .13901 m
.63046 .14764 L
s
.60544 .13901 m
.60956 .13317 L
s
.60544 .13901 m
.58928 .11892 L
s
.58513 .12493 m
.56545 .11144 L
s
.58513 .12493 m
.60956 .13317 L
s
.58513 .12493 m
.58928 .11892 L
s
.58513 .12493 m
.56969 .1051 L
s
.56545 .11144 m
.54664 .09855 L
s
.56545 .11144 m
.58928 .11892 L
s
.56545 .11144 m
.56969 .1051 L
s
.56545 .11144 m
.55086 .09193 L
s
.54664 .09855 m
.52878 .08603 L
s
.54664 .09855 m
.56969 .1051 L
s
.54664 .09855 m
.55086 .09193 L
s
.54664 .09855 m
.53312 .07918 L
s
.52878 .08603 m
.51203 .07419 L
s
.52878 .08603 m
.55086 .09193 L
s
.52878 .08603 m
.53312 .07918 L
s
.52878 .08603 m
.51649 .06678 L
s
.51203 .07419 m
.49673 .06204 L
s
.51203 .07419 m
.53312 .07918 L
s
.51203 .07419 m
.51649 .06678 L
s
.51203 .07419 m
.5011 .05526 L
s
.49673 .06204 m
.4826 .05286 L
s
.49673 .06204 m
.51649 .06678 L
s
.49673 .06204 m
.5011 .05526 L
s
.49673 .06204 m
.4872 .04443 L
s
.4826 .05286 m
.47064 .04123 L
s
.4826 .05286 m
.5011 .05526 L
s
.4826 .05286 m
.4872 .04443 L
s
.4826 .05286 m
.47484 .03711 L
s
.47064 .04123 m
.46097 .03419 L
s
.47064 .04123 m
.4872 .04443 L
s
.47064 .04123 m
.47484 .03711 L
s
.47064 .04123 m
.46579 .02511 L
s
.46097 .03419 m
.45477 .02505 L
s
.46097 .03419 m
.47484 .03711 L
s
.46097 .03419 m
.46579 .02511 L
s
.46097 .03419 m
.45931 .01943 L
s
.45477 .02505 m
.46579 .02511 L
s
.45477 .02505 m
.45931 .01943 L
s
.97619 .376 m
.9663 .37147 L
s
.9663 .37147 m
.95391 .36407 L
s
.95391 .36407 m
.93953 .3549 L
s
.93953 .3549 m
.92366 .34428 L
s
.92366 .34428 m
.9064 .33254 L
s
.9064 .33254 m
.88798 .31996 L
s
.88798 .31996 m
.86852 .30663 L
s
.86852 .30663 m
.84841 .29282 L
s
.84841 .29282 m
.82766 .27864 L
s
.82766 .27864 m
.80634 .26413 L
s
.80634 .26413 m
.78463 .2494 L
s
.78463 .2494 m
.76257 .23467 L
s
.76257 .23467 m
.74035 .21993 L
s
.74035 .21993 m
.71807 .20532 L
s
.71807 .20532 m
.69579 .19092 L
s
.69579 .19092 m
.67362 .17664 L
s
.67362 .17664 m
.65169 .16294 L
s
.65169 .16294 m
.63046 .14764 L
s
.63046 .14764 m
.60956 .13317 L
s
.60956 .13317 m
.58928 .11892 L
s
.58928 .11892 m
.56969 .1051 L
s
.56969 .1051 m
.55086 .09193 L
s
.55086 .09193 m
.53312 .07918 L
s
.53312 .07918 m
.51649 .06678 L
s
.51649 .06678 m
.5011 .05526 L
s
.5011 .05526 m
.4872 .04443 L
s
.4872 .04443 m
.47484 .03711 L
s
.47484 .03711 m
.46579 .02511 L
s
.46579 .02511 m
.45931 .01943 L
s
0 0 m
1 0 L
1 .81594 L
0 .81594 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[14]:=",
  ImageSize->{288, 234.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jR000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00P`3oool0
0`000000oooo0?ooo`2J0?ooo`00P`3oool2000009/0oooo00220?ooo`@00000VP3oool00840oooo
1P00002I0?ooo`00P@3oool7000009P0oooo00200?ooo`T00000U`3oool007l0oooo3000002E0?oo
o`00OP3oool00`000000oooo00000004000000030?ooo`000000000000@00000U03oool007d0oooo
0`0000000`3oool0000000000003000000050?ooo`00000000000000003oool00P00002C0?ooo`00
O03oool5000000030?ooo`000000000000@0000000@0oooo000000000000oooo0`00002A0?ooo`00
O03oool2000000030?ooo`00000000000080000000@0oooo000000000000oooo2@00002@0?ooo`00
N`3oool00`000000oooo00000003000000050?ooo`00000000000000003oool0200000000`3oool0
00000000002?0?ooo`00N`3oool2000000040?ooo`00000000000?oooa800000S@3oool007X0oooo
00D000000?ooo`00000000000?ooo`07000000070?ooo`00000000000000003oool000000?ooo`07
000008`0oooo001i0?ooo`L0000000L0oooo00000000000000000?ooo`000000oooo0080000000<0
oooo0000000000000P0000001@3oool00000000000000000oooo00800000R`3oool007T0oooo1@00
00000`3oool000000?ooo`02000000050?ooo`00000000000000003oool0200000001P3oool00000
0?ooo`000000oooo000008X0oooo001h0?ooo`D0000000D0oooo00000000000000000?ooo`080000
00050?ooo`00000000000000003oool02@0000280?ooo`00M`3oool01`000000oooo000000000000
oooo0000003oool01@000000103oool000000000000000020?ooo`040000003oool000000?ooo`<0
000000<0oooo0000000000001P0000270?ooo`00MP3oool>000000030?ooo`000000oooo00@00000
0P3oool00`000000oooo00000002000000030?ooo`000000oooo0080000000@0oooo000000000000
0000Q@3oool007D0oooo0P0000000`3oool0000000000002000000050?ooo`000000oooo0000003o
ool06@0000000`3oool000000?ooo`230?ooo`00M@3oool?00000080oooo00<000000?ooo`000000
0`0000000`3oool000000?ooo`04000000030?ooo`000000oooo00P00000PP3oool007@0oooo1@00
00003`3oool00000000000000000oooo0000003oool000000?ooo`000000oooo0000003oool00000
0?ooo`0200000080oooo100000000`3oool000000?ooo`02000000030?ooo`000000oooo00@00000
00<0oooo000000000000P@3oool007<0oooo00<000000?ooo`0000001`0000001P3oool000000?oo
o`000000oooo00000080oooo0`0000000`3oool000000000000>00000080oooo00D000000?ooo`00
0000oooo000000200?ooo`00LP3oool00`000000oooo00000002000000060?ooo`00000000000?oo
o`000000oooo0`0000020?ooo`T000000P3oool3000000040?ooo`000000oooo0?ooo`<000000P3o
ool5000000040?ooo`0000000000000007h0oooo001a0?ooo`P000000P3oool800000080oooo0`00
00020?ooo`060000003oool000000?ooo`000000oooo0P0000020?ooo`030000003oool0000000<0
000000<0oooo0000003oool01P00001m0?ooo`00L03oool5000000030?ooo`000000000000<00000
0P3oool300000080oooo00H000000?ooo`000000oooo0000003oool400000080oooo00<000000?oo
o`3oool00`0000020?ooo`030000003oool0oooo00<0000000D0oooo0000003oool000000?ooo`03
000007`0oooo001_0?ooo`030000003oool0000000L0000000L0oooo0000003oool000000?ooo`00
0000oooo00@000000P3ooolI000000040?ooo`00000000000?ooo`<00000NP3oool006h0oooo1000
00020?ooo`80000000<0oooo0000003oool00`0000020?ooo`P0000000<0oooo0000003oool00`00
00030?ooo`030000003oool0000000<000000P3oool00`000000oooo00000003000000030?ooo`00
0000000000@0000000<0oooo000000000000N@3oool006`0oooo2@0000020?ooo`P000000P3oool4
00000080oooo00@000000?ooo`000000oooo0`0000001`3oool000000?ooo`000000oooo0000003o
ool00P0000002P3oool000000000003oool000000?ooo`000000oooo0000003oool8000007L0oooo
001[0?ooo`80000000<0oooo0000000000000P3oool500000080oooo0`0000020?ooo`050000003o
ool000000?ooo`0000000P3oool400000080oooo00<000000?ooo`3oool00`0000020?ooo`T00000
0P3oool2000000050?ooo`000000oooo0000003oool00P0000000`3oool000000000001f0?ooo`00
JP3oool00`000000oooo0?ooo`08000000070?ooo`000000oooo0000003oool000000?ooo`040000
0080oooo4P0000030?ooo`<000000P3oool=000000030?ooo`000000oooo07@0oooo001Y0?ooo`<0
000000D0oooo00000000000000000?ooo`0200000080oooo0`0000020?ooo`X000000P3oool40000
00040?ooo`000000oooo0?ooo`@0000000P0oooo0000003oool0oooo0000003oool000000?ooo`<0
00000P3oool4000000050?ooo`000000oooo0000003oool01@00001c0?ooo`00I`3oool300000005
0?ooo`00000000000000003oool00P0000000`3oool000000?ooo`0700000080oooo100000020?oo
o`050000003oool000000?ooo`0000000P3oool400000080oooo00<000000?ooo`0000000`000003
0?ooo`030000003oool0oooo00<000000P3oool02@000000oooo000000000000oooo0000003oool0
00000?ooo`0400000780oooo001V0?ooo`h0000000@0oooo00000000000000000P3oool01@000000
oooo0000003oool000000080oooo100000020?ooob<0000000<0oooo0000000000000P00001a0?oo
o`00I@3oool2000000030?ooo`00000000000080000000@0oooo00000000000000000P3oool30000
00030?ooo`000000oooo00@000000P3oool:000000<0oooo0`0000020?ooo`030000003oool0oooo
00@000000P3oool00`000000oooo0?ooo`0400000080oooo00<000000?ooo`3oool00`0000000`3o
ool0000000000006000006l0oooo001T0?ooo`<0000000<0oooo0000000000002@0000030?ooo`T0
00000`3oool3000000<0oooo00H000000?ooo`000000oooo0000003oool300000080oooo0P000002
0?ooo`030000003oool000000080oooo018000000?ooo`000000oooo0000003oool000000?ooo`00
0000oooo0000003oool000000?ooo`000000oooo0000003oool4000006h0oooo001S0?ooo`800000
00D0oooo00000000000000000?ooo`03000000030?ooo`000000000000H000000`3oool300000080
oooo00L000000?ooo`00000000000?ooo`000000oooo0080000000H0oooo0000003oool000000?oo
o`0000030?ooo`<000000P3oool00`000000oooo0?ooo`0400000080oooo00<000000?ooo`3oool0
100000020?ooo`070000003oool000000000003oool000000?ooo`06000006`0oooo001R0?ooo`03
0000003oool0000000@0000000<0oooo0000000000000`000000103oool000000000000000020?oo
o`070000003oool000000000003oool000000?ooo`04000000<0oooo00@000000?ooo`3oool0oooo
0`0000020?ooob4000000P3oool3000000030?ooo`000000000006/0oooo001Q0?ooo`H0000000@0
oooo00000000000000000P3oool01P000000oooo0000003oool000000?ooo`@000000`3ooolD0000
0080oooo0`0000020?ooo`040000003oool0oooo0?ooo`@000000P3oool00`000000oooo0?ooo`04
00000080oooo00@000000?ooo`000000oooo1@0000000`3oool000000?ooo`03000006T0oooo001P
0?ooo`80000000<0oooo0000000000001P0000020?ooo`060000003oool000000?ooo`000000oooo
200000020?ooo`<000000`3oool010000000oooo0?ooo`3oool400000080oooo00H000000?ooo`00
0000oooo0000003oool300000080oooo00D000000?ooo`3oool000000?ooo`02000000030?ooo`00
000000000080oooo00<000000?ooo`0000000P0000001`3oool000000?ooo`000000oooo0000003o
ool01@0000000`3oool000000000001X0?ooo`00G`3oool5000000070?ooo`000000oooo0000003o
ool000000?ooo`08000000040?ooo`0000000000000000<0oooo00H000000?ooo`000000oooo0000
003oool2000000030?ooo`000000oooo0080000000@0oooo0000003oool0oooo100000020?ooo`04
0000003oool0oooo0?ooo`<000000`3ooolC000000060?ooo`00000000000?ooo`000000oooo1P00
001V0?ooo`00GP3oool6000000030?ooo`00000000000080oooo00<000000?ooo`0000000`000000
203oool000000?ooo`3oool000000?ooo`000000oooo0P0000001P3oool000000?ooo`000000oooo
000000<0oooo0`0000030?oooa@000000`3oool300000080oooo00@000000?ooo`3oool0oooo1000
00000`3oool0000000000004000000030?ooo`000000oooo0080000000<0oooo000000000000I@3o
ool005d0oooo1@0000001@3oool00000000000000000oooo00@0000000P0oooo0000000000000000
0?ooo`000000oooo00000080oooo00@000000?ooo`3oool0oooo0`0000020?ooo`/000000`3oool3
000000<0oooo00<000000?ooo`3oool0100000020?ooo`070000003oool0oooo0000003oool00000
0?ooo`0300000080oooo00<000000?ooo`0000000P3oool01P000000oooo0000003oool000000?oo
o`L0000000@0oooo0000000000000000H`3oool005`0oooo100000000`3oool000000?ooo`040000
00030?ooo`000000oooo00<000000P3oool3000000<0oooo2`0000020?ooo`@000000P3oool01`00
0000oooo000000000000oooo0000003oool00P0000001P3oool000000?ooo`000000oooo00000080
oooo0P0000000`3oool00000000000030?ooo`030000003oool0oooo00<000000`3oool00`000000
oooo0?ooo`02000000070?ooo`000000oooo0000003oool000000?ooo`05000000040?ooo`000000
000000000640oooo001K0?ooo`030000003oool0oooo00T0000000<0oooo0000000000000P3oool:
000000<0oooo100000020?ooo`050000003oool000000?ooo`0000000P3oool4000000<0oooo00@0
00000?ooo`3oool0oooo0`0000030?oooad0000000H0oooo000000000000oooo0000003oool70000
05l0oooo001J0?ooo`030000003oool000000080000000<0oooo0000000000000P0000020?ooo`L0
00000P3oool400000080oooo00H000000?ooo`00000000000?ooo`0000020?ooo`@000000P3ooolE
000000<0oooo100000020?ooo`030000003oool0oooo00@000000P3oool010000000oooo0?ooo`3o
ool4000000030?ooo`000000000000D0000000<0oooo0000000000001@00001N0?ooo`00F@3oool8
000000030?ooo`00000000000080000000@0oooo00000000000000000P3oool3000000040?ooo`00
0000oooo0?ooo`@000000`3oool:000000<0oooo100000030?ooo`030000003oool0oooo00@00000
0P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`0000000P3oool01`00
0000oooo0000003oool000000?ooo`0000000P3oool02`000000oooo0?ooo`000000oooo0000003o
ool000000?ooo`000000oooo00P0000000@0oooo0000000000000000G03oool005P0oooo1@000000
0`3oool0000000000002000000030?ooo`000000oooo0080000000<0oooo0000003oool00`000003
0?ooo`/000000`3oool3000000<0oooo00D000000?ooo`000000oooo000000020?ooo`080000003o
ool0oooo0000003oool000000?ooo`0000020?ooo`030000003oool000000080oooo00@000000?oo
o`3oool000000P3oool400000080oooo00<000000?ooo`3oool0100000030?ooo`030000003oool0
oooo0080000000D0oooo0000003oool000000?ooo`03000000030?ooo`00000000000080000000<0
oooo000000000000F`3oool005L0oooo0`0000000`3oool000000000000400000080oooo0P000002
0?ooo`030000003oool0000000L000000`3oool3000000<0oooo00L000000?ooo`3oool000000?oo
o`000000oooo0080000000H0oooo0000003oool000000?ooo`0000030?ooo`@000000`3oool00`00
0000oooo0?ooo`04000000<0oooo7@0000020?ooo`80000000<0oooo0000003oool01P00001I0?oo
o`00EP3oool00`000000oooo00000003000000050?ooo`000000oooo0000003oool00`0000000`3o
ool0000000000002000000040?ooo`0000000000000000<0oooo00L000000?ooo`3oool000000?oo
o`000000oooo0080000000@0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool30000
0080oooo5P0000030?ooo`@000000P3oool00`000000oooo0?ooo`04000000<0oooo00<000000?oo
o`3oool0100000000`3oool0000000000005000000030?ooo`000000oooo0080000000<0oooo0000
00000000F03oool005D0oooo00@000000?ooo`00000000000P3oool2000000030?ooo`000000oooo
00D000000P3oool01P000000oooo0000003oool000000?ooo`80000000@0oooo0000003oool00000
0P3oool010000000oooo0?ooo`3oool3000000<0oooo2`0000030?ooo`@000000P3oool010000000
oooo0?ooo`3oool400000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003o
ool000000080oooo00@000000?ooo`000000oooo0P0000002`3oool000000?ooo`3oool000000?oo
o`000000oooo0000003oool000000080oooo2@000000103oool0000000000000001F0?ooo`00D`3o
ool=000000040?ooo`0000000000000000<0oooo0P0000020?ooo`040000003oool0oooo0?ooo`<0
00000`3oool;000000<0oooo0`0000030?ooo`060000003oool0oooo0000003oool000000P3oool0
0`000000oooo000000020?ooo`030000003oool000000080oooo0P0000000`3oool0000000000003
0?ooo`030000003oool0oooo00@000000P3oool010000000oooo0?ooo`3oool400000080oooo00<0
00000?ooo`3oool00P000000203oool000000?ooo`3oool000000?ooo`000000oooo1@000000103o
ool0000000000000001D0?ooo`00DP3oool500000080oooo0`0000020?ooo`060000003oool00000
0?ooo`000000oooo100000030?ooo`/000000`3oool400000080oooo00L000000?ooo`0000000000
0?ooo`000000oooo0080000000@0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool4
00000080oooo:00000020?ooo`80000000<0oooo0000003oool01`00001B0?ooo`00D@3oool40000
00030?ooo`000000000000@000000P3oool200000080oooo00<000000?ooo`0000001`0000030?oo
o`@000000P3oool01P000000oooo000000000000oooo00000080oooo100000030?ooo`040000003o
ool0oooo0?ooo`<000000`3oool;000000@0oooo100000020?ooo`040000003oool0oooo0?ooo`@0
00000P3oool010000000oooo0?ooo`3oool400000080oooo00<000000?ooo`3oool00`0000020?oo
o`L0000000<0oooo0000003oool00P000000103oool0000000000000001A0?ooo`00D03oool00`00
0000oooo0?ooo`03000000060?ooo`00000000000?ooo`000000oooo0`0000000`3oool000000000
0002000000030?ooo`0000000000008000000P3oool01P000000oooo000000000000oooo00000080
oooo100000030?oooaH000000`3oool3000000<0oooo00H000000?ooo`3oool000000?ooo`000002
0?ooo`030000003oool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo00000002
0?ooo`030000003oool000000080oooo00<000000?ooo`0000000P3oool010000000oooo00000000
00020?ooo`030000003oool0oooo00T0000000@0oooo0000003oool00000D03oool004l0oooo1@00
00000`3oool00000000000020?ooo`030000003oool0000000@0000000L0oooo0000003oool0oooo
0000003oool000000080oooo100000030?ooo`/000000`3oool3000000<0oooo00@000000?ooo`3o
ool0oooo100000030?ooo`070000003oool000000000003oool000000?ooo`02000000040?ooo`00
0000oooo000000<0oooo00<000000?ooo`3oool0100000030?ooo`030000003oool0oooo00@00000
0`3oool00`000000oooo0?ooo`0400000080oooo00<000000?ooo`0000000P0000020?ooo`070000
003oool000000000003oool000000?ooo`0400000080oooo00<000000?ooo`3oool0C@3oool004h0
oooo200000000`3oool0000000000002000000040?ooo`000000000000000080oooo00<000000?oo
o`0000000P3oool00`000000oooo0?ooo`08000000<0oooo0`0000030?ooo`070000003oool0oooo
0000003oool000000?ooo`02000000030?ooo`000000oooo0080000000@0oooo0000003oool0oooo
0P0000000`3oool00000000000030?ooo`040000003oool0oooo0?ooo`<00000103ooolN000000<0
oooo0`0000020?ooo`030000003oool000000080000000<0oooo0000003oool01P00001=0?ooo`00
C@3oool5000000030?ooo`0000000000008000000P3oool01P000000oooo0000003oool000000?oo
o`@0000000<0oooo0000000000000`000000103oool000000000000000020?ooo`030000003oool0
oooo0080000000<0oooo0000003oool00P000000103oool000000?ooo`0000020?ooo`040000003o
ool0oooo0?ooo`<000000`3ooolG000000<0oooo0`0000030?ooo`040000003oool0oooo0?ooo`@0
00000P3oool010000000oooo0?ooo`3oool400000080oooo2P0000020?ooo`060000003oool00000
0?ooo`000000oooo1@00001<0?ooo`00C03oool4000000030?ooo`000000000000<000000`3oool2
00000080oooo00<000000?ooo`00000010000000103oool000000?ooo`3oool2000000080?ooo`00
0000oooo0000003oool000000?ooo`0000030?ooo`040000003oool0oooo0?ooo`<000000`3oool;
000000@0oooo100000030?ooo`030000003oool0oooo00@000000`3oool020000000oooo0?ooo`00
0000oooo0000003oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<00000
0?ooo`0000000P3oool020000000oooo0?ooo`000000oooo0000003oool000000P3oool010000000
oooo0000000000020?ooo`T000000P3oool4000004/0oooo001;0?ooo`030000003oool0oooo00<0
000000D0oooo0000003oool000000?ooo`04000000030?ooo`00000000000080000000@0oooo0000
0000000000000P3oool00`000000oooo000000030?ooo`030000003oool0oooo00<00000103oool;
000000<0oooo100000030?ooo`060000003oool0oooo0000003oool000000P3oool020000000oooo
0?ooo`000000oooo0000003oool000000P3oool200000080oooo00<000000?ooo`0000000P3oool0
20000000oooo000000000000oooo0000003oool000000P3oool00`000000oooo0?ooo`04000000<0
oooo00<000000?ooo`3oool0100000020?ooo`090000003oool000000000003oool000000?ooo`00
0000oooo008000000P3oool8000004T0oooo001:0?ooo`030000003oool000000080000000D0oooo
000000000000oooo000000020?ooo`D0000000P0oooo0000003oool0oooo0000003oool000000?oo
o`@000000`3oool<000000<0oooo0`0000030?ooo`060000003oool0oooo0000003oool000000P3o
ool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool0oooo100000030?oo
o`040000003oool0oooo0?ooo`@000000`3oool010000000oooo0?ooo`3oool3000000<0oooo5@00
00020?ooo`80000000D0oooo0000003oool000000?ooo`02000000050?ooo`000000oooo0000003o
ool0100000180?ooo`00B@3oool8000000030?ooo`00000000000080000000@0oooo000000000000
00000P3oool00`000000oooo000000020?ooo`030000003oool0000000L000000`3oool4000000<0
oooo00L000000?ooo`3oool000000?ooo`000000oooo0080000000@0oooo0000003oool000000P3o
ool010000000oooo0?ooo`3oool4000000<0oooo8@0000030?ooo`@000000`3oool00`000000oooo
0?ooo`0400000080oooo2P0000020?ooo`80000000D0oooo0000003oool000000?ooo`04000004H0
oooo00180?ooo`D0000000<0oooo0000000000000P0000000`3oool000000?ooo`02000000030?oo
o`000000oooo00@0000000<0oooo0000000000000P000000103oool000000000000000030?ooo`06
0000003oool0oooo0000003oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo
00@000000?ooo`3oool0oooo0`0000030?ooo`d000000`3oool3000000<0oooo00<000000?ooo`3o
ool00P3oool400000080oooo00@000000?ooo`3oool0oooo100000020?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`0000000P3oool01`000000oooo0?ooo`000000oooo0000003oool0
0P000000103oool000000?ooo`3oool4000000030?ooo`000000000000P0000000<0oooo00000000
00000P0000150?ooo`00A`3oool3000000030?ooo`000000000000@000000P3oool200000080oooo
00<000000?ooo`3oool01@000000203oool000000?ooo`3oool000000?ooo`000000oooo0P000000
103oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`@000000`3oool<000000<0oooo
100000030?ooo`080000003oool0oooo0000003oool000000?ooo`0000020?ooo`070000003oool0
oooo0?ooo`000000oooo000000020?ooo`080000003oool0oooo0000003oool000000?ooo`000002
0?ooo`060000003oool0oooo0000003oool000000P3oool020000000oooo0?ooo`000000oooo0000
003oool000000P3oool010000000oooo0?ooo`3oool2000000090?ooo`000000oooo0?ooo`000000
oooo0000003oool000000080oooo100000000`3oool0000000000006000004<0oooo00160?ooo`03
0000003oool0000000<0000000D0oooo0000003oool000000?ooo`03000000030?ooo`0000000000
00<0000000@0oooo00000000000000000P3oool00`000000oooo000000020?ooo`040000003oool0
oooo0?ooo`<000000`3oool<000000<0oooo100000030?ooo`060000003oool0oooo0000003oool0
00000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool00P000000
103oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`@000000`3oool00`000000oooo
0?ooo`04000000<0oooo00@000000?ooo`3oool0oooo100000020?ooo`/000000P3oool20000000<
0?ooo`000000oooo0?ooo`000000oooo0000003oool000000?ooo`000000oooo1@0000110?ooo`00
A@3oool010000000oooo0000000000020?ooo`80000000<0oooo0000003oool01@0000020?ooo`07
0000003oool000000000003oool000000?ooo`04000000<0oooo2`0000040?ooo`<000000`3oool0
1P000000oooo0?ooo`000000oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?oo
o`040000003oool0oooo0?ooo`@000000`3oool00`000000oooo0?ooo`020?ooo`<000000`3ooolQ
000000<0oooo0`0000020?ooo`X000000P3oool2000000030?ooo`000000oooo00L00000?`3oool0
04<0oooo3@000000103oool000000000000000030?ooo`8000000`3oool00`000000oooo00000007
000000<0oooo0`0000030?ooo`030000003oool0oooo0080000000<0oooo0000003oool00P000000
103oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`@000000`3ooolH000000<0oooo
100000020?ooo`040000003oool0oooo0?ooo`@000000`3oool010000000oooo0?ooo`3oool40000
0080oooo00P000000?ooo`3oool000000?ooo`000000oooo00000080oooo00<000000?ooo`3oool0
100000020?ooo`H000000P3oool300000080oooo0P00000n0?ooo`00@P3oool500000080oooo0`00
00020?ooo`060000003oool000000?ooo`000000oooo100000000`3oool000000000000300000004
0?ooo`0000000000000000<0oooo00L000000?ooo`3oool000000?ooo`000000oooo0080000000@0
oooo0000003oool000000`3oool010000000oooo0?ooo`3oool3000000<0oooo3@0000030?ooo`@0
00000`3oool010000000oooo0?ooo`3oool4000000<0oooo00H000000?ooo`3oool000000?ooo`00
00020?ooo`030000003oool000000080oooo00<000000?ooo`0000000P3oool2000000070?ooo`00
0000oooo0?ooo`000000oooo000000020?ooo`030000003oool000000080oooo00D000000?ooo`3o
ool000000?ooo`0300000080oooo00L000000?ooo`000000oooo0000003oool000000080oooo00<0
00000?ooo`000000100000001@3oool000000?ooo`000000oooo00800000?03oool00440oooo1000
00000`3oool000000000000400000080oooo0P0000020?ooo`030000003oool0000000@000000P3o
ool01`000000oooo0?ooo`000000oooo0000003oool00P000000103oool000000?ooo`0000020?oo
o`040000003oool0oooo0?ooo`<00000103oool<000000<0oooo100000030?ooo`060000003oool0
oooo0000003oool000000P3oool01@000000oooo0?ooo`000000oooo0080000000D0oooo0000003o
ool0oooo000000020?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0100000030?oo
o`040000003oool0oooo0?ooo`@000000`3oool00`000000oooo0?ooo`04000000<0oooo00@00000
0?ooo`3oool0oooo0`0000020?ooo`030000003oool0oooo00@000000P3oool010000000oooo0000
003oool500000080oooo0P00000k0?ooo`00@03oool00`000000oooo0?ooo`03000000060?ooo`00
000000000?ooo`000000oooo0`0000000`3oool0000000000002000000030?ooo`00000000000080
00000P3oool00`000000oooo000000020?ooo`040000003oool0oooo0?ooo`<000000`3oool<0000
00<0oooo100000030?ooo`060000003oool0oooo0000003oool000000P3oool01P000000oooo0?oo
o`000000oooo00000080oooo00@000000?ooo`3oool0oooo100000030?ooo`040000003oool0oooo
0?ooo`@00000103ooolc000000060?ooo`00000000000?ooo`000000oooo1`00000i0?ooo`00?`3o
ool00`000000oooo00000002000000030?ooo`00000000000080oooo00<000000?ooo`0000001000
00001`3oool000000?ooo`3oool000000?ooo`0000000P3oool4000000<0oooo2`0000030?ooo`@0
00000`3oool01P000000oooo0?ooo`000000oooo00000080oooo00H000000?ooo`3oool000000?oo
o`0000020?ooo`040000003oool0oooo0?ooo`@000000`3ooolH000000<0oooo100000020?ooo`03
0000003oool0oooo0080oooo100000020?ooo`040000003oool0oooo0?ooo`@000000P3oool01000
0000oooo0?ooo`3oool400000080oooo00<000000?ooo`3oool0100000020?ooo`L0000000<0oooo
0000000000001@00000h0?ooo`00?P3oool8000000030?ooo`00000000000080000000@0oooo0000
0000000000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo00P000000`3oool3
000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`060000003oool0oooo0000003o
ool000000P3oool010000000oooo0?ooo`3oool4000000<0oooo3@0000030?ooo`@000000`3oool0
10000000oooo0?ooo`3oool4000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`03
0000003oool000000080oooo0P0000001`3oool000000?ooo`3oool000000?ooo`0000000P3oool0
0`000000oooo000000020?ooo`060000003oool0oooo0000003oool000000P3oool01@000000oooo
0000003oool000000080oooo00@000000?ooo`000000oooo0P0000001@3oool000000?ooo`000000
oooo00P0000000@0oooo0000000000000000=P3oool003d0oooo1@0000000`3oool0000000000002
00000080oooo00H000000?ooo`000000oooo0000003oool4000000030?ooo`000000000000<00000
00@0oooo00000000000000000`3oool01`000000oooo0?ooo`000000oooo0000003oool00P000000
103oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`@000000`3oool=000000<0oooo
100000030?ooo`060000003oool0oooo0000003oool000000P3oool01@000000oooo0?ooo`000000
oooo0080000000@0oooo0000003oool0oooo0P0000020?ooo`030000003oool000000080oooo00<0
00000?ooo`3oool0100000040?ooo`030000003oool0oooo00@000000`3oool00`000000oooo0?oo
o`04000000<0oooo00<000000?ooo`3oool0100000020?ooo`040000003oool0oooo0?ooo`800000
00D0oooo0000003oool000000?ooo`03000000030?ooo`00000000000080000000<0oooo00000000
0000=@3oool003`0oooo0`0000000`3oool0000000000004000000<0oooo0P000000103oool00000
0?ooo`3oool5000000040?ooo`000000oooo0?ooo`80000000<0oooo0000003oool00P000000103o
ool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`<000000`3oool=000000<0oooo1000
00030?ooo`060000003oool0oooo0000003oool000000P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00@000000?ooo`3oool0oooo100000040?ooo`040000003oool0oooo0?ooo`@00000
0`3ooolc00000080oooo0P0000000`3oool000000?ooo`06000003<0oooo000k0?ooo`030000003o
ool0000000<0000000D0oooo0000003oool000000?ooo`04000000030?ooo`000000000000800000
00@0oooo00000000000000000P3oool00`000000oooo000000030?ooo`040000003oool0oooo0?oo
o`<000000`3oool<000000<0oooo100000030?ooo`060000003oool0oooo0000003oool000000P3o
ool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool0oooo100000030?oo
oaP000000`3oool4000000<0oooo00@000000?ooo`3oool0oooo100000020?ooo`040000003oool0
oooo0?ooo`@000000`3oool00`000000oooo0?ooo`0400000080oooo00@000000?ooo`3oool0oooo
100000000`3oool0000000000005000000030?ooo`000000oooo0080000000<0oooo000000000000
<P3oool003X0oooo00@000000?ooo`00000000000P3oool2000000040?ooo`000000oooo0?ooo`D0
000000<0oooo0000003oool00P0000000`3oool000000?ooo`04000000@0oooo2`0000030?ooo`@0
00000`3oool01P000000oooo0?ooo`000000oooo00000080oooo00H000000?ooo`3oool000000?oo
o`0000020?ooo`040000003oool0oooo0?ooo`@000000`3oool=000000<0oooo100000030?ooo`03
0000003oool0oooo0080oooo100000020?ooo`060000003oool0oooo0000003oool000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00<000000?ooo`0000000P3o
ool01@000000oooo0?ooo`000000oooo0080000000/0oooo0000003oool0oooo0000003oool00000
0?ooo`000000oooo000000020?ooo`080000003oool0oooo0000003oool000000?ooo`0000020?oo
o`T0000000<0oooo000000000000<@3oool003T0oooo200000000`3oool000000000000200000004
0?ooo`000000000000000080oooo0P0000030?ooo`030000003oool0000000L00000103oool30000
00<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`060000003oool0oooo0000003oool0
00000P3oool010000000oooo0?ooo`3oool4000000<0oooo3@0000030?ooo`@000000`3oool01P00
0000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo
000000020?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool000000080oooo00<000000?ooo`3oool0100000030?ooo`040000003oool0
oooo0?ooo`@000000P3oool00`000000oooo0?ooo`04000000<0oooo00<000000?ooo`3oool00P00
0000203oool000000?ooo`3oool000000?ooo`000000oooo1@0000000`3oool000000?ooo`0_0?oo
o`00>03oool3000000030?ooo`000000oooo00@0000000<0oooo0000003oool00P0000000`3oool0
00000?ooo`03000000030?ooo`000000000000<0000000@0oooo00000000000000000`3oool00`00
0000oooo0?ooo`02000000030?ooo`000000oooo0080000000@0oooo0000003oool000000P3oool0
10000000oooo0?ooo`3oool4000000<0oooo3@0000030?ooo`@000000`3oool01P000000oooo0?oo
o`000000oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`3oool4000000<0oooo
00@000000?ooo`3oool0oooo100000030?ooobP000000P3oool2000000030?ooo`000000000000D0
0000;P3oool003L0oooo0`0000000`3oool000000000000400000080oooo0P0000020?ooo`030000
003oool0000000@000000P3oool01`000000oooo0?ooo`000000oooo0000003oool00P000000103o
ool000000?ooo`0000030?ooo`040000003oool0oooo0?ooo`<000000`3oool<000000@0oooo1000
00030?ooo`060000003oool0oooo0000003oool000000P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00@000000?ooo`3oool0oooo100000040?ooo`040000003oool0oooo0?ooo`@00000
0`3ooolG000000<0oooo100000030?ooo`040000003oool0oooo0?ooo`@000000P3oool00`000000
oooo0?ooo`04000000<0oooo00<000000?ooo`3oool00`0000020?ooo`L0000000<0oooo0000003o
ool01000000]0?ooo`00=P3oool00`000000oooo00000003000000050?ooo`000000oooo0000003o
ool00`0000000`3oool0000000000002000000040?ooo`0000000000000000<0oooo00H000000?oo
o`3oool000000?ooo`0000030?ooo`<00000103oool;000000@0oooo0`0000030?ooo`030000003o
ool0oooo0080000000D0oooo0000003oool0oooo000000020?ooo`030000003oool000000080oooo
00@000000?ooo`3oool0oooo100000030?oooaT000000`3oool400000080oooo00<000000?ooo`3o
ool00P3oool400000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`80000000L0oooo
0000003oool0oooo0000003oool000000080oooo00<000000?ooo`0000000P3oool010000000oooo
0000003oool2000000060?ooo`000000oooo0?ooo`000000oooo0P0000020?ooo`030000003oool0
oooo00/00000;03oool003D0oooo00@000000?ooo`00000000000P3oool010000000oooo00000000
00020?ooo`@000000P3oool01P000000oooo0000003oool000000?ooo`80000000@0oooo0000003o
ool000000P3oool00`000000oooo0?ooo`08000000@0oooo0`0000030?ooo`030000003oool0oooo
0080000000<0oooo0000003oool00P000000103oool000000?ooo`0000030?ooo`040000003oool0
oooo0?ooo`@000000`3oool=000000<0oooo100000030?ooo`030000003oool0oooo0080oooo1000
00030?ooo`060000003oool0oooo0000003oool000000P3oool01@000000oooo0?ooo`000000oooo
0080000000D0oooo0000003oool0oooo000000020?ooo`030000003oool000000080oooo00@00000
0?ooo`3oool0oooo100000030?ooo`030000003oool0oooo00@000000P3oool010000000oooo0?oo
o`3oool400000080oooo00<000000?ooo`0000000P0000020?ooo`070000003oool000000000003o
ool000000?ooo`06000002X0oooo000c0?ooo`H000000P3oool2000000030?ooo`000000000000@0
00000`3oool200000080oooo00@000000?ooo`3oool0oooo0`0000000`3oool00000000000030000
00040?ooo`0000000000000000<0oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`02
000000040?ooo`000000oooo000000<0oooo00@000000?ooo`3oool0oooo0`0000040?ooo`d00000
0`3oool4000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo
00@000000?ooo`3oool0oooo100000040?ooo`030000003oool0oooo00@000000`3ooolO000000<0
oooo0`0000020?ooo`040000003oool0000000000080oooo1`00000X0?ooo`00<P3oool500000080
oooo1P0000001@3oool000000?ooo`000000oooo00@000000`3oool800000080oooo00L000000?oo
o`3oool000000?ooo`000000oooo0080000000@0oooo0000003oool000000`3oool010000000oooo
0?ooo`3oool3000000@0oooo300000040?ooo`@000000`3oool01P000000oooo0?ooo`000000oooo
00000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`3oool4000000<0oooo5`0000040?oo
o`<000000`3oool010000000oooo0?ooo`3oool400000080oooo00@000000?ooo`3oool0oooo1000
00020?ooo`T000000P3oool300000080oooo0`0000020?ooo`8000009P3oool00340oooo0P000000
103oool000000000000000020?ooo`<000000P3oool200000080oooo00<000000?ooo`0000001`00
00030?ooo`@000000P3oool00`000000oooo000000020?ooo`040000003oool0oooo0?ooo`<00000
103oool<000000<0oooo100000030?ooo`030000003oool0oooo0080000000D0oooo0000003oool0
oooo000000020?ooo`030000003oool000000080oooo00@000000?ooo`3oool0oooo100000040?oo
o`040000003oool0oooo0?ooo`@000000`3oool=000000<0oooo100000030?ooo`040000003oool0
oooo0?ooo`@000000P3oool02@000000oooo0?ooo`3oool000000?ooo`000000oooo000000020?oo
o`060000003oool0oooo0000003oool000000P3oool00`000000oooo000000020?ooo`030000003o
ool000000080oooo00<000000?ooo`0000000P3oool4000000030?ooo`000000000000L000000P3o
ool01@000000oooo0000003oool0000002D0oooo000`0?ooo`030000003oool0oooo0080000000<0
oooo0000000000001`0000000`3oool0000000000002000000040?ooo`0000000000000000<0oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`@000000`3oool<000000<0oooo100000030?oo
o`060000003oool0oooo0000003oool000000P3oool01P000000oooo0?ooo`000000oooo000000<0
oooo00@000000?ooo`3oool0oooo100000030?oooaT000000`3oool4000000<0oooo00H000000?oo
o`3oool000000?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000
0P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00P000000?ooo`00000000000?ooo`00
0000oooo00000080oooo00<000000?ooo`3oool0100000030?ooo`030000003oool0oooo00@00000
00P0oooo0000003oool0oooo0000003oool000000?ooo`@0000000<0oooo00000000000010000000
103oool0000000000000000S0?ooo`00;`3oool3000000050?ooo`00000000000000003oool00`00
00020?ooo`@0000000P0oooo0000003oool0oooo0000003oool000000?ooo`80000000@0oooo0000
003oool000000P3oool00`000000oooo0?ooo`08000000<0oooo100000030?ooo`060000003oool0
oooo0000003oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?oo
o`3oool0oooo100000040?ooo``00000103oool4000000<0oooo00<000000?ooo`3oool00P3oool4
000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`060000003oool0oooo0000003o
ool000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool0100000040?ooo`040000003oool0oooo0?ooo`<000000`3ooolD00000080oooo1000
00002@3oool000000?ooo`000000oooo0000003oool000000?ooo`0600000280oooo000^0?ooo`80
000000D0oooo00000000000000000?ooo`0200000080oooo1P0000020?ooo`030000003oool00000
0080oooo00@000000?ooo`3oool0oooo0`0000000`3oool0000000000003000000040?ooo`000000
0000000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`060000003oool0oooo0000
003oool000000P3oool010000000oooo0?ooo`3oool4000000<0oooo3@0000040?ooo`<00000103o
ool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo000000020?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?oo
o`3oool4000000@0oooo00@000000?ooo`3oool0oooo100000030?oooaH000000`3oool3000000<0
oooo00@000000?ooo`3oool0oooo0`0000020?ooo`T000000P3oool4000000050?ooo`000000oooo
0000003oool00`00000Q0?ooo`00;@3oool00`000000oooo0000000:000000050?ooo`000000oooo
0000003oool0100000030?ooo`P0000000@0oooo0000003oool0oooo0P0000000`3oool000000?oo
o`02000000040?ooo`000000oooo00000080oooo00@000000?ooo`3oool0oooo100000030?ooo`d0
00000`3oool4000000<0oooo00<000000?ooo`3oool00P000000103oool000000?ooo`0000030?oo
o`060000003oool0oooo0000003oool000000`3oool01P000000oooo0?ooo`000000oooo00000080
oooo00@000000?ooo`3oool0oooo100000030?oooaP000000`3oool4000000<0oooo00@000000?oo
o`3oool0oooo100000020?ooo`080000003oool0oooo0000003oool000000?ooo`0000020?ooo`0:
0000003oool0oooo0000003oool000000?ooo`000000oooo000000<0oooo0`0000020?ooo`T00000
00@0oooo000000000000oooo0`00000O0?ooo`00;03oool3000000040?ooo`00000000000?ooo`<0
00000`3oool200000080oooo00<000000?ooo`0000001P0000040?ooo`<000000P3oool00`000000
oooo000000030?ooo`040000003oool0oooo0?ooo`<000000`3oool=000000<0oooo100000030?oo
o`060000003oool0oooo0000003oool000000P3oool01P000000oooo0?ooo`000000oooo000000<0
oooo00<000000?ooo`3oool00P000000103oool000000?ooo`0000020?ooo`030000003oool0oooo
0080oooo100000030?ooo`d000000`3oool4000000<0oooo00<000000?ooo`3oool00P3oool40000
0080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`8000000P3oool01@000000oooo0000
003oool000000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`080000003oool00000
0000003oool000000?ooo`0000020?ooo`040000003oool0000000000080oooo00@000000?ooo`00
0000oooo0`0000020?ooo`@0000000<0oooo000000000000100000000`3oool000000000000N0?oo
o`00:`3oool2000000040?ooo`00000000000?ooo`H0000000@0oooo000000000000oooo10000000
103oool000000000000000020?ooo`030000003oool0oooo0080000000<0oooo0000003oool01000
00040?ooo``000000`3oool4000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`06
0000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool4000000@0oooo00<0
00000?ooo`3oool00P3oool3000000<0oooo3P0000030?ooo`@000000`3oool01P000000oooo0?oo
o`000000oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000020?oo
o`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool4000000<0oooo
00<000000?ooo`3oool0100000030?ooo`040000003oool0oooo0?ooo`<000000`3oool00`000000
oooo0?ooo`03000000<0oooo00<000000?ooo`3oool00`0000020?ooo`030000003oool000000080
000000<0oooo0000000000001P00000L0?ooo`00:P3oool7000000040?ooo`000000oooo00000080
oooo100000003@3oool000000?ooo`3oool000000?ooo`000000oooo0000003oool000000?ooo`00
00000`3oool00`000000oooo00000008000000<0oooo100000030?ooo`060000003oool0oooo0000
003oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool0
oooo100000030?oooaT00000103oool4000000<0oooo00H000000?ooo`3oool000000?ooo`000002
0?ooo`060000003oool0oooo0000003oool000000`3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool000000080oooo00@000000?ooo`3oool0oooo100000030?ooocT0000000@0oooo0000
00000000oooo0P00000K0?ooo`00:@3oool2000000050?ooo`00000000000000003oool00P000002
0?ooo`H000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo0`0000000`3oool00000
00000003000000030?ooo`0000000000008000000`3oool01P000000oooo0?ooo`000000oooo0000
0080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`@00000
0`3oool<000000@0oooo100000040?ooo`040000003oool0oooo0?ooo`@000000`3oool00`000000
oooo0?ooo`02000000050?ooo`000000oooo0?ooo`0000000P3oool00`000000oooo000000020?oo
o`040000003oool0oooo0?ooo`@00000103oool010000000oooo0?ooo`3oool4000000<0oooo3000
00040?ooo`<000000`3oool010000000oooo0?ooo`3oool400000080oooo00@000000?ooo`3oool0
oooo100000020?ooo`030000003oool0oooo00@000000P3oool00`000000oooo0?ooo`0400000080
oooo00<000000?ooo`3oool00`0000000`3oool0000000000004000000030?ooo`000000oooo01T0
oooo000X0?ooo`030000003oool0000000T000000P3oool02@000000oooo0000003oool000000?oo
o`000000oooo000000020?ooo`030000003oool0000000@000000P3oool01P000000oooo0?ooo`00
0000oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo
0?ooo`@000000`3oool<000000@0oooo0`0000040?ooo`060000003oool0oooo0000003oool00000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000P3oool01P000000
oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool0oooo100000030?oooaT000000`3o
ool400000080oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000000P3oool01P00
0000oooo0?ooo`000000oooo00000080oooo00P000000?ooo`3oool000000?ooo`000000oooo0000
0080oooo00D000000?ooo`3oool000000?ooo`0200000080oooo00<000000?ooo`0000000P3oool2
00000080oooo00<000000?ooo`0000000P3oool00`000000oooo00000003000000030?ooo`000000
000000D00000603oool002L0oooo0`000000103oool000000000003oool300000080oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`03000000030?ooo`00000000000080000000@0oooo
00000000000000000`3oool01P000000oooo0?ooo`000000oooo000000<0oooo100000030?ooo``0
0000103oool3000000@0oooo00P000000?ooo`3oool000000?ooo`000000oooo000000<0oooo00H0
00000?ooo`3oool000000?ooo`0000030?ooo`060000003oool0oooo0000003oool000000P3oool0
10000000oooo0?ooo`3oool4000000@0oooo3@0000030?ooo`@000000`3oool00`000000oooo0?oo
o`020?ooo`@000000`3oool01P000000oooo0?ooo`000000oooo00000080oooo00H000000?ooo`3o
ool000000?ooo`0000020?ooo`030000003oool0oooo0080000000@0oooo0000003oool000000P3o
ool00`000000oooo0?ooo`04000000<0oooo00<000000?ooo`3oool0100000020?ooo`030000003o
ool0oooo00@000000P3oool00`000000oooo0?ooo`0400000080oooo00L000000?ooo`3oool00000
0?ooo`000000oooo00H000005`3oool002H0oooo0P000000103oool000000000003oool600000003
0?ooo`000000000000<0oooo1`000000203oool000000?ooo`3oool000000?ooo`000000oooo0P00
0000103oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`P00000103oool3000000<0
oooo00<000000?ooo`3oool00P000000103oool000000?ooo`0000030?ooo`060000003oool0oooo
0000003oool000000P3oool2000000040?ooo`000000oooo00000080oooo00<000000?ooo`3oool0
0P3oool4000000<0oooo300000000`3oool000000?ooo`020?ooo`@000000`3oool01P000000oooo
0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo00000002
0?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool4000000<0
oooo00<000000?ooo`3oool00P3oool3000000<0oooo;@0000020?ooo`030000003oool000000080
00005@3oool002D0oooo1`000000103oool000000?ooo`0000020?ooo`H000000`3oool300000080
oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`3oool3000000030?ooo`0000000000
00@0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`02000000030?ooo`000000
oooo0080000000@0oooo0000003oool000000`3oool00`000000oooo0?ooo`02000000040?ooo`00
0000oooo00000080oooo00<000000?ooo`3oool00P3oool3000000<0oooo3P0000030?ooo`@00000
103oool01P000000oooo0?ooo`000000oooo00000080oooo00H000000?ooo`3oool000000?ooo`00
00030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool010000000oooo
0?ooo`3oool4000000<0oooo5`0000030?ooo`@000000P3oool010000000oooo0?ooo`3oool30000
0080oooo00@000000?ooo`3oool0oooo0`0000020?ooo`040000003oool0oooo0?ooo`@0000000@0
oooo0000003oool0oooo0`0000020?ooo`H0000000<0oooo0000000000004`3oool002@0oooo0P00
00001@3oool00000000000000000oooo008000000P3oool600000080oooo00L000000?ooo`3oool0
00000?ooo`000000oooo00@000000`3oool800000080oooo00P000000?ooo`3oool0oooo0000003o
ool000000?ooo`80000000@0oooo0000003oool000000`3oool010000000oooo0?ooo`3oool30000
00@0oooo00<000000?ooo`3oool00P3oool3000000<0oooo3@0000040?ooo`@000000`3oool01P00
0000oooo0?ooo`000000oooo00000080oooo0P0000020?ooo`030000003oool000000080oooo00@0
00000?ooo`3oool0oooo100000040?ooo`040000003oool0oooo0?ooo`@000000`3oool=000000<0
oooo100000030?ooo`040000003oool0oooo0?ooo`@000000P3oool01P000000oooo0?ooo`000000
oooo00000080oooo00<000000?ooo`0000000P3oool010000000oooo0000003oool300000080oooo
00@000000?ooo`000000oooo0`0000020?ooo`050000003oool0oooo0000003oool0100000020?oo
o`@0000000D0oooo00000000000000000?ooo`0400000180oooo000S0?ooo`030000003oool00000
00T000000P3oool02@000000oooo0000003oool000000?ooo`000000oooo000000020?ooo`030000
003oool0000000L000000`3oool3000000<0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`3oool3000000@0oooo600000030?ooo`@000000`3oool00`000000oooo0?ooo`020000
00050?ooo`000000oooo0?ooo`0000000P3oool00`000000oooo000000020?ooo`030000003oool0
oooo0080oooo100000030?oooaT000000`3oool4000000<0oooo00H000000?ooo`3oool000000?oo
o`0000020?ooo`050000003oool0oooo0000003oool00P0000001@3oool000000?ooo`3oool00000
0080oooo00D000000?ooo`000000oooo000000030?ooo`@000000P3oool010000000oooo0?ooo`3o
ool3000000<0oooo00<000000?ooo`3oool00`0000030?ooo`T000000P3oool3000000050?ooo`00
000000000000003oool00`00000A0?ooo`008P3oool6000000040?ooo`000000000000000080oooo
00<000000?ooo`0000000P3oool00`000000oooo0?ooo`03000000030?ooo`000000000000800000
00@0oooo00000000000000000`3oool01`000000oooo0?ooo`000000oooo0000003oool00P000000
103oool000000?ooo`0000030?ooo`030000003oool0oooo00T000000`3oool3000000@0oooo00<0
00000?ooo`3oool00P3oool4000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`06
0000003oool0oooo0000003oool000000`3oool010000000oooo0?ooo`3oool4000000<0oooo3@00
00040?ooo`@000000`3oool00`000000oooo0?ooo`020?ooo`@000000`3oool01P000000oooo0?oo
o`000000oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0
oooo0?ooo`@000000`3oool010000000oooo0?ooo`3oool400000080oooo7P0000020?ooo`<00000
0P3oool@000000l0oooo000Q0?ooo`80000000<0oooo0000000000001`0000000`3oool000000000
00030?ooo`L0000000P0oooo0000003oool0oooo0000003oool000000?ooo`80000000@0oooo0000
003oool000000P3oool010000000oooo0?ooo`3oool3000000030?ooo`000000000000@0000000@0
oooo0000000000000000103oool020000000oooo0?ooo`000000oooo0000003oool000000`3oool0
0`000000oooo0?ooo`02000000050?ooo`000000oooo0?ooo`0000000P3oool00`000000oooo0000
00020?ooo`040000003oool0oooo0?ooo`@00000103oool=000000@0oooo0`0000040?ooo`060000
003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0
00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`@0
00000`3ooolG000000<0oooo0`0000030?ooo`030000003oool0oooo00@000000P3oool00`000000
oooo0?ooo`0400000080oooo00<000000?ooo`3oool00P000000103oool000000000000000020?oo
o`<0000000<0oooo0000003oool00`0000000`3oool0000000000002000000h0oooo000P0?ooo`D0
00000P3oool2000000040?ooo`000000oooo0?ooo`H000000`3oool300000080oooo00<000000?oo
o`0000000P3oool010000000oooo0?ooo`3oool3000000<0oooo200000030?ooo`080000003oool0
oooo0000003oool000000?ooo`0000030?ooo`060000003oool0oooo0000003oool000000P3oool2
000000040?ooo`000000oooo000000<0oooo00@000000?ooo`3oool0oooo100000030?ooo``00000
00<0oooo0000003oool00P3oool4000000<0oooo00<000000?ooo`3oool00P000000103oool00000
0?ooo`0000030?ooo`060000003oool0oooo0000003oool000000`3oool01P000000oooo0?ooo`00
0000oooo00000080oooo00@000000?ooo`3oool0oooo100000030?ooo`d000000`3oool3000000@0
oooo00@000000?ooo`3oool0oooo0`0000030?ooo`070000003oool0oooo0000003oool000000?oo
o`02000000060?ooo`000000oooo0000003oool000000P3oool00`000000oooo000000020?ooo`04
0000003oool000000?ooo`80000000D0oooo000000000000oooo000000030?ooo`<0000000<0oooo
0000003oool0100000000`3oool0000000000006000000`0oooo000O0?ooo`H000000P3oool20000
00030?ooo`000000000000@000000P3oool01`000000oooo0?ooo`000000oooo0000003oool01000
00030?ooo`/000000`3oool4000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`80
000000@0oooo0000003oool000000P3oool00`000000oooo0?ooo`020?ooo`<00000103oool=0000
00<0oooo100000040?ooo`060000003oool0oooo0000003oool000000P3oool01P000000oooo0?oo
o`000000oooo000000<0oooo00<000000?ooo`3oool00P000000103oool000000?ooo`0000020?oo
o`030000003oool0oooo0080oooo100000030?ooo`d000000`3oool4000000<0oooo00P000000?oo
o`3oool000000?ooo`000000oooo000000<0oooo00L000000?ooo`3oool000000?ooo`000000oooo
0080000000@0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool3000000<0oooo00<0
00000?ooo`3oool0100000020?ooob8000002@3oool001l0oooo100000020?ooo`D000000P3oool0
2@000000oooo0000003oool000000?ooo`000000oooo000000020?ooo`030000003oool0000000L0
00000`3oool3000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo0?ooo`020?ooo`<000000`3oool=000000@0oooo
100000030?ooo`060000003oool0oooo0000003oool000000P3oool200000080oooo00<000000?oo
o`0000000P3oool010000000oooo0?ooo`3oool4000000@0oooo00<000000?ooo`3oool00P3oool3
000000<0oooo3P0000030?ooo`@000000`3oool01P000000oooo0?ooo`000000oooo00000080oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo0080000000@0oooo0000
003oool000000P3oool010000000oooo0?ooo`3oool3000000<0oooo500000030?ooo`<000000P3o
ool00`000000oooo0?ooo`0300000080oooo00<000000?ooo`0000000`0000000`3oool000000000
0004000000030?ooo`000000000000<000001`3oool001h0oooo0`0000000`3oool000000?ooo`04
000000040?ooo`000000oooo00000080oooo00<000000?ooo`3oool00`0000000`3oool000000000
0002000000040?ooo`0000000000000000<0oooo00L000000?ooo`3oool000000?ooo`000000oooo
0080000000@0oooo0000003oool000000P3oool010000000oooo0?ooo`3oool4000000<0oooo3@00
00030?ooo`@000000`3oool00`000000oooo0?ooo`02000000050?ooo`000000oooo0?ooo`000000
0P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo100000030?oooaT00000
103oool4000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`060000003oool0oooo
0000003oool000000P3oool010000000oooo0?ooo`3oool4000000<0oooo00<000000?ooo`3oool0
0P3oool3000000<0oooo2P000000103oool000000?ooo`3oool400000080oooo00@000000?ooo`3o
ool0oooo10000000403oool000000?ooo`3oool000000?ooo`000000oooo0000003oool000000?oo
o`000000oooo0000003oool4000000030?ooo`000000000000d00000203oool001d0oooo00<00000
0?ooo`000000100000000`3oool0000000000004000000<0oooo1`000000203oool000000?ooo`3o
ool000000?ooo`000000oooo0P000000103oool000000?ooo`0000020?ooo`040000003oool0oooo
0?ooo`<000000`3oool=000000<0oooo100000030?ooo`060000003oool0oooo0000003oool00000
0P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool0oooo10000003
0?ooo`d00000103oool4000000@0oooo00@000000?ooo`3oool0oooo100000030?ooo`030000003o
ool0oooo0080000000D0oooo0000003oool0oooo000000020?ooo`030000003oool000000080oooo
00@000000?ooo`3oool0oooo100000030?oooaH0000000@0oooo0000003oool0oooo100000030?oo
o`050000003oool000000?ooo`0000000P3oool00`000000oooo000000020?ooo`030000003oool0
00000080oooo100000020?ooo`030000003oool0oooo00<000000P3oool800000080oooo0`000000
0`3oool000000?ooo`04000000X0oooo000L0?ooo`@000000P3oool4000000030?ooo`0000000000
00D000000`3oool300000080oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`3oool3
000000<0oooo300000030?ooo`@000000`3oool01P000000oooo0?ooo`000000oooo00000080oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`@00000103oool<
000000D0oooo0`0000040?ooo`060000003oool0oooo0000003oool000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo
000000<0oooo00@000000?ooo`3oool0oooo100000030?ooo``00000103oool3000000@0oooo00@0
00000?ooo`3oool0oooo100000030?ooo`050000003oool000000?ooo`0000000P3oool020000000
oooo0?ooo`000000oooo0000003oool000000`3oool400000080oooo4P0000020?ooo`<000000P3o
ool01@000000oooo000000000000oooo00H000002`3oool001X0oooo3@000000103oool000000000
000000020?ooo`070000003oool000000000003oool000000?ooo`04000000<0oooo2`0000030?oo
o`@000000`3oool01P000000oooo0?ooo`000000oooo00000080oooo00H000000?ooo`3oool00000
0?ooo`0000020?ooo`040000003oool0oooo0?ooo`@000000`3oool<000000030?ooo`000000oooo
0080oooo0`0000040?ooo`090000003oool0oooo0?ooo`000000oooo0000003oool0000000<0oooo
00H000000?ooo`3oool000000?ooo`0000030?ooo`060000003oool0oooo0000003oool000000P3o
ool010000000oooo0?ooo`3oool4000000@0oooo3@0000030?ooo`<000001