(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    130591,       4518]*)
(*NotebookOutlinePosition[    135304,       4666]*)
(*  CellTagsIndexPosition[    134352,       4632]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Complex Polynomial Systems", "Chapter",
  CellTags->{"t:1", "c:1"}],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"t:3", "c:3"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions ",
  ButtonBox["Reduce",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Resolve",
    ButtonStyle->"RefGuideLink"],
  ", and ",
  ButtonBox["FindInstance",
    ButtonStyle->"RefGuideLink"],
  " allow to solve a wide variety of problems that can be expressed in terms \
of equations and inequalities. The functions use a collection of algorithms \
applicable to classes of problems satisfying particular properties, as well \
as a set of heuristics that attempt to reduce the given problem to a sequence \
of problems which can be solved using the algorithms. This notebook describes \
the algorithms used to solve the class of problems known as complex \
polynomial systems. It characterizes the structure of the returned answers, \
and describes the options that affect various aspects of solving the complex \
polynomial systems."
}], "Text"],

Cell[TextData[{
  "A ",
  StyleBox["complex polynomial system",
    FontSlant->"Italic"],
  " is an expression constructed with polynomial equations and inequations"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(f(x\_1,  ... , 
        x\_n) \[Equal] \ \(g(x\_1,  ... , x\_n)\)\ \ and\ \ \(f(x\_1,  ... , 
          x\_n)\) \[NotEqual] \ g(x\_1,  ... , x\_n)\)\)\)], "DisplayFormula"],

Cell["combined using logical connectives and quantifiers", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalPhi]\_1 \[And] \[CapitalPhi]\_2, \ \
\[CapitalPhi]\_1 \[Or] \[CapitalPhi]\_2, \ \[CapitalPhi]\_1 \[Implies] \
\[CapitalPhi]\_2, \[Not] \[CapitalPhi], \[ForAll] \_x \[CapitalPhi], \ 
    and\ \ \(\[Exists] \_x \[CapitalPhi]\)\)], "DisplayFormula"],

Cell[TextData[{
  "An occurrence of a variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " inside ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \_x \[CapitalPhi]\ \ or\ \ \(\[Exists] \_x \
\[CapitalPhi]\)\)]],
  " is called a ",
  StyleBox["bound occurrence",
    FontSlant->"Italic"],
  ", and any other occurrence of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called a ",
  StyleBox["free occurrence.",
    FontSlant->"Italic"],
  " A variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called a ",
  StyleBox["free variable",
    FontSlant->"Italic"],
  " of a complex polynomial system if the system contains a free occurrence \
of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". A complex polynomial system is ",
  StyleBox["quantifier-free",
    FontSlant->"Italic"],
  " if it contains no quantifiers."
}], "Text"],

Cell[TextData[{
  "Here is an example of a complex polynomial system with free variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["z.",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`x\^2 + y\^2 \[Equal] 
        z\^2 \[And] \[Exists] \_t\((\[ForAll] \_u t\ x \[NotEqual] 
                u\ y\ z + 7 \[Or] \(x\^2\) t \[Equal] 
              2\ z + 1)\)\)], "NumberedEquation",
  CellTags->"Complex1"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " quantifiers are represented using the functions ",
  ButtonBox["Exists",
    ButtonStyle->"RefGuideLink"],
  " (\[Exists]) and ",
  ButtonBox["ForAll",
    ButtonStyle->"RefGuideLink"],
  " (\[ForAll]). "
}], "Text"],

Cell[TextData[{
  "Any complex polynomial system can be transformed to the ",
  StyleBox["prenex normal form",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(Q\_\(1\ x\_1\)\) 
          Q\_\(2\ x\_2\) ... \) \(Q\_\(n\ x\_n\)\) \(\[CapitalPhi](
        x\_1,  ... , x\_n; y\_1,  ... , y\_m)\)\)], "NumberedEquation",
  CellTags->"PNF"],

Cell[TextData[{
  "where each ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  " is a quantifier \[ForAll] or \[Exists], and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n; y\_1,  ... , 
        y\_m)\)]],
  " is quantifier-free."
}], "Text"],

Cell[TextData[{
  "Any ",
  "quantifier-free",
  " complex polynomial system can be transformed to the ",
  StyleBox["disjunctive normal form",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\((\(\(\(\[CurlyPhi]\_\(1, 
                      1\)\)\(\[And]\)\) ... \) \[And] \[CurlyPhi]\_\(1, \
n\_1\))\)\(\[Or]\)\) ... \) \[Or] \((\(\(\(\[CurlyPhi]\_\(m, 
                  1\)\)\(\[And]\)\) ... \) \[And] \[CurlyPhi]\_\(m, n\_m\))\)\
\)], "NumberedEquation",
  CellTags->"DNF"],

Cell[TextData[{
  "where each ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi]\_\(i, j\)\)]],
  " is a polynomial equation or inequation. "
}], "Text"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " always put complex polynomial systems in the prenex normal form, with ",
  "quantifier-free",
  " parts in the disjunctive normal form, and subtract the sides of the \
equations and inequations to put them in the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(f(x\_1,  ... , x\_n) \[Equal] \ 
      0\ and\ \ \(f(x\_1,  ... , x\_n)\) \[NotEqual] \ 
      0\)\)\)], "DisplayFormula"],

Cell["\<\
In the following sections, assume that the system has been \
transformed to this form.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can solve arbitrary complex polynomial systems. The solution (possibly \
after expanding \[And] with respect to \[Or]) is a disjunction of terms of \
the form"
}], "Text"],

Cell[BoxData[{
    \(TraditionalForm\`x\_1 = \(r\_1\  \[And] \ \(g\_1\)(x\_1) \[NotEqual] 
            0 \[And] 
          x\_2 = \(r\_2\)(x\_1)\  \[And] \ \ \(g\_2\)(x\_1, x\_2) \[NotEqual] 
              0\  \[And]  ... \)\), "\[IndentingNewLine]", 
    \(TraditionalForm\`\ \(\(\[And]\)\(\ \)\(\(g\_\(n - 1\)\)(x\_1,  ... , 
            x\_\(n - 1\)) \[NotEqual] 
          0\)\(\ \)\(\[And]\)\(\ \)\(x\_n\)\) = \(r\_n\)(x\_1,  ... , 
          x\_\(n - 1\))\  \[And] \ \ \(g\_n\)(x\_1,  ... , x\_n) \[NotEqual] 
          0\)}], "NumberedEquation",
  TextAlignment->Center,
  CellTags->"GeneralComplexSolution"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  " are the free variables of the system, each ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i\)]],
  " is a polynomial, each ",
  Cell[BoxData[
      \(TraditionalForm\`r\_i\)],
    TextAlignment->Center],
  " is an algebraic function expressed using radicals or ",
  ButtonBox["Root",
    ButtonStyle->"RefGuideLink"],
  " objects, and any terms of the conjunction (",
  ButtonBox["4",
    ButtonData:>"GeneralComplexSolution",
    ButtonStyle->"Hyperlink"],
  ") may be absent. Each ",
  Cell[BoxData[
      \(TraditionalForm\`\(r\_i\)(x\_1,  ... , x\_\(i - 1\))\)],
    TextAlignment->Center],
  " is well defined, that is, no denominators or leading terms of ",
  StyleBox["Root", "MR"],
  " objects in ",
  Cell[BoxData[
      \(TraditionalForm\`r\_i\)],
    TextAlignment->Center],
  " become zero for any ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_1,  ... , x\_\(i - 1\))\)\)],
    TextAlignment->Center],
  " satisfying the preceding terms of the conjunction (",
  ButtonBox["4",
    ButtonData:>"GeneralComplexSolution",
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell[TextData[{
  "This solves the system (",
  ButtonBox["1",
    ButtonData:>"Complex1",
    ButtonStyle->"Hyperlink"],
  ")."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^2 + y\^2 \[Equal] 
          z\^2 && \[Exists] \_t\((\[ForAll] \_u t\ x \[NotEqual] u\ y\ z + 7 || 
              x\^2\ t \[Equal] 2\ z + 1)\), {x, y, z}]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(\((y \[Equal] 0 && z \[Equal] \(-x\))\) || \((y \[Equal] 0 && 
          z \[Equal] 
            x)\) || \((\((y \[Equal] \(-\[ImaginaryI]\)\ x || 
              y \[Equal] \[ImaginaryI]\ x)\) && 
          z \[Equal] 
            0)\) || \((\((z \[Equal] \(-\@\(x\^2 + y\^2\)\) || 
              z \[Equal] \@\(x\^2 + y\^2\))\) && 
          x \[NotEqual] 0)\) || \((x \[Equal] 0 && y \[Equal] \(-\(1\/2\)\) && 
          z \[Equal] \(-\(1\/2\)\))\) || \((x \[Equal] 0 && y \[Equal] 1\/2 && 
          z \[Equal] \(-\(1\/2\)\))\)\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Resolve", "MR"],
  " can eliminate quantifiers from arbitrary complex polynomial systems. If \
no variables are specified, the result is a logical combination of terms"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`f(x\_1,  ... , x\_n) \[Equal] 
      0\ \ and\ \ \(g(x\_1,  ... , x\_n)\) \[NotEqual] 0\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  StyleBox["f",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g",
    FontSlant->"Italic"],
  " are polynomials, and each ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " is a free variable of the system. With variables specified in the input, \
",
  StyleBox["Resolve", "MR"],
  " gives the same answer as ",
  StyleBox["Reduce", "MR"],
  ". "
}], "Text"],

Cell[TextData[{
  "This eliminates quantifiers from the system (",
  ButtonBox["1",
    ButtonData:>"Complex1",
    ButtonStyle->"Hyperlink"],
  ")."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[
      x\^2 + y\^2 \[Equal] 
          z\^2 && \[Exists] \_t\((\[ForAll] \_u t\ x \[NotEqual] u\ y\ z + 7 || 
              x\^2\ t \[Equal] 2\ z + 1)\)]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \(\((y \[Equal] 0 && x - z \[Equal] 0)\) || \((y \[Equal] 0 && 
          x + z \[Equal] 0)\) || \((x\^2 + y\^2 \[Equal] 0 && 
          z \[Equal] 0)\) || \((x \[Equal] 0 && \(-1\) + 2\ y \[Equal] 0 && 
          1 + 2\ z \[Equal] 0)\) || \((x \[Equal] 0 && 1 + 2\ y \[Equal] 0 && 
          1 + 2\ z \[Equal] 0)\) || \((x\^2 + y\^2 - z\^2 \[Equal] 0 && 
          y - z \[NotEqual] 0 && y + z \[NotEqual] 0)\)\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["FindInstance", "MR"],
  " can handle arbitrary complex polynomial systems giving instances of \
complex solutions, or an empty list for systems that have no solutions. If \
the number of instances requested is more than one, the instances are \
randomly generated from the full solution of the system, and therefore they \
may depend on the value of the ",
  StyleBox["RandomSeed", "MR"],
  " option. If one instance is requested, a faster algorithm that produces \
one instance is used, and the instance returned is always the same."
}], "Text"],

Cell[TextData[{
  "This finds a solution for the system (",
  ButtonBox["1",
    ButtonData:>"Complex1",
    ButtonStyle->"Hyperlink"],
  ")."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
      x\^2 + y\^2 \[Equal] 
          z\^2 && \[Exists] \_t\((\[ForAll] \_u t\ x \[NotEqual] u\ y\ z + 7 || 
              x\^2\ t \[Equal] 2\ z + 1)\), {x, y, z}]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{x \[Rule] 0, y \[Rule] 0, z \[Rule] 0}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "The main tool used in solving complex polynomial systems is the Gr\
\[ODoubleDot]bner basis algorithm (see, e.g., [",
  ButtonBox["1",
    ButtonData:>"BW",
    ButtonStyle->"Hyperlink"],
  "]), which is directly available in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as the ",
  ButtonBox["GroebnerBasis",
    ButtonStyle->"RefGuideLink"],
  " function."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Gr\[ODoubleDot]bner Bases", "Section"],

Cell[CellGroupData[{

Cell["Theory", "Subsection"],

Cell[TextData[{
  "This section gives a very brief introduction to the theory of Gr\
\[ODoubleDot]bner bases. It presents only the properties that are necessary \
to describe the algorithms used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in solving complex polynomial systems. For a more complete presentation \
see, for example, [",
  ButtonBox["1",
    ButtonData:>"BW",
    ButtonStyle->"Hyperlink"],
  "], [",
  ButtonBox["2",
    ButtonData:>"CLS",
    ButtonStyle->"Hyperlink"],
  "]. Note that what [",
  ButtonBox["2",
    ButtonData:>"CLS",
    ButtonStyle->"Hyperlink"],
  "] calls a monomial, [",
  ButtonBox["1",
    ButtonData:>"BW",
    ButtonStyle->"Hyperlink"],
  "] calls a term, and vice versa. This notebook uses the terminology of [",
  ButtonBox["1",
    ButtonData:>"BW",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "A ",
  StyleBox["monomial",
    FontSlant->"Italic"],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  " is an expression of the form ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^e\_1 ... \) x\_n\^e\_n\)]],
  " with nonnegative integers ",
  Cell[BoxData[
      \(TraditionalForm\`e\_i\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`M = M(x\_1,  ... , x\_n)\)]],
  " be the set of all monomials in ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  ". A ",
  StyleBox["monomial order",
    FontSlant->"Italic"],
  " is a linear order \[PrecedesSlantEqual] on ",
  StyleBox["M,",
    FontSlant->"Italic"],
  " such that 1\[PrecedesSlantEqual] ",
  StyleBox["t",
    FontSlant->"Italic"],
  " for all ",
  StyleBox["t ",
    FontSlant->"Italic"],
  "\[Element]",
  StyleBox[" M",
    FontSlant->"Italic"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`t\_1 \[PrecedesSlantEqual] t\_2\)]],
  " implies ",
  Cell[BoxData[
      \(TraditionalForm\`\(t\_1\) s \[PrecedesSlantEqual] \(t\_2\) s\)]],
  " for all ",
  Cell[BoxData[
      \(TraditionalForm\`t\_1, t\_2, s\  \[Element] \ M\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Let ",
  StyleBox["R",
    FontSlant->"Italic"],
  " be a field, the domain of integers, or the domain of univariate \
polynomials over a field. Let ",
  StyleBox["Quot",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Rem ",
    FontSlant->"Italic"],
  "be functions ",
  Cell[BoxData[
      \(TraditionalForm\`R\^2\[LongRightArrow]R\)]],
  " defined as follows. If ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is a field, ",
  StyleBox["Quot(a, b) ",
    FontSlant->"Italic"],
  "= ",
  StyleBox["a/b",
    FontSlant->"Italic"],
  ", and",
  StyleBox[" Rem(a, b) = ",
    FontSlant->"Italic"],
  "0. If ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is the domain of integers, ",
  StyleBox["Quot",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Rem",
    FontSlant->"Italic"],
  " are the integer quotient and remainder functions, with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"-", 
          RowBox[{"|", "b", "|", 
            RowBox[{\(\(/\)\(2\)\), "<", 
              RowBox[{
                StyleBox["Rem",
                  FontSlant->"Italic"], "(", \(a, b\), ")"}], 
              "\[LessEqual]"}], "|", "b", "|", \(\(/\)\(2\)\)}]}], 
        TraditionalForm]]],
  ". If ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is the domain of univariate polynomials over a field, ",
  StyleBox["Quot",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Rem",
    FontSlant->"Italic"],
  " are the polynomial quotient and remainder functions."
}], "Text"],

Cell[TextData[{
  "A product ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\ m\)]],
  ", where",
  StyleBox[" a ",
    FontSlant->"Italic"],
  "is a nonzero element of",
  StyleBox[" R ",
    FontSlant->"Italic"],
  "and",
  StyleBox[" m ",
    FontSlant->"Italic"],
  "is a monomial, is called a ",
  StyleBox["term",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Let \[PrecedesSlantEqual] be a monomial order on ",
  StyleBox["M",
    FontSlant->"Italic"],
  ", and let ",
  Cell[BoxData[
      \(TraditionalForm\`f \[Element] R[x\_1,  ... , x\_n]\\{0}\)]],
  ". The ",
  StyleBox["leading monomial",
    FontSlant->"Italic"],
  " ",
  StyleBox["LM(f)",
    FontSlant->"Italic"],
  " of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " is the \[PrecedesSlantEqual]-largest monomial appearing in ",
  StyleBox["f,",
    FontSlant->"Italic"],
  " the ",
  StyleBox["leading coefficient",
    FontSlant->"Italic"],
  " ",
  StyleBox["LC(f) ",
    FontSlant->"Italic"],
  "of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " is the coefficient at ",
  StyleBox["LM(f)",
    FontSlant->"Italic"],
  " in ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", and the ",
  StyleBox["leading term LT(f) ",
    FontSlant->"Italic"],
  "of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " ",
  StyleBox[" ",
    FontSlant->"Italic"],
  "is the product",
  StyleBox[" LC(f) LM(f)",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "A ",
  StyleBox["Gr\[ODoubleDot]bner basis",
    FontSlant->"Italic"],
  " of an ideal ",
  StyleBox["I ",
    FontSlant->"Italic"],
  "in ",
  Cell[BoxData[
      \(TraditionalForm\`R[x\_1,  ... , x\_n]\)]],
  ", with respect to a monomial order \[PrecedesSlantEqual], is a finite set \
",
  StyleBox["G",
    FontSlant->"Italic"],
  " of polynomials, such that for each",
  StyleBox[" f ",
    FontSlant->"Italic"],
  "\[Element]",
  StyleBox[" I,",
    FontSlant->"Italic"],
  " there exists ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "\[Element]",
  StyleBox[" G,",
    FontSlant->"Italic"],
  " such that ",
  StyleBox["LT(g)",
    FontSlant->"Italic"],
  " divides ",
  StyleBox["LT(f).",
    FontSlant->"Italic"],
  " Every ideal ",
  StyleBox["I",
    FontSlant->"Italic"],
  " has a Gr\[ODoubleDot]bner basis (see, e.g., [",
  ButtonBox["1",
    ButtonData:>"BW",
    ButtonStyle->"Hyperlink"],
  "] for a proof)."
}], "Text"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`p \[Element] R[x\_1,  ... , x\_n]\\{0}\)]],
  ", and let ",
  Cell[BoxData[
      \(TraditionalForm\`m \[Element] R[x\_1,  ... , x\_n]\)]],
  " be a monomial. A term ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\ m\)]],
  " is ",
  StyleBox["reducible",
    FontSlant->"Italic"],
  " modulo ",
  StyleBox["p",
    FontSlant->"Italic"],
  ", if ",
  StyleBox["LM(p)",
    FontSlant->"Italic"],
  " divides ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["a \[NotEqual] Rem(a, LC(p))",
    FontSlant->"Italic"],
  ". If ",
  StyleBox["t ",
    FontSlant->"Italic"],
  "is reducible modulo ",
  StyleBox["p",
    FontSlant->"Italic"],
  ", the ",
  StyleBox["reduction",
    FontSlant->"Italic"],
  " of ",
  StyleBox["t ",
    FontSlant->"Italic"],
  "modulo ",
  StyleBox["p",
    FontSlant->"Italic"],
  " is the polynomial"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["Red",
            FontSlant->"Italic"], "(", \(t, \ p\), ")"}], " ", "=", " ", 
        RowBox[{"t", " ", "-", " ", 
          RowBox[{
            RowBox[{
              StyleBox["Quot",
                FontSlant->"Italic"], "(", 
              RowBox[{"a", ",", " ", 
                RowBox[{
                  StyleBox["LC",
                    FontSlant->"Italic"], "(", "p", ")"}]}], ")"}], " ", 
            FractionBox["m", 
              RowBox[{
                StyleBox["LM",
                  FontSlant->"Italic"], "(", "p", ")"}]], "p"}]}]}], 
      TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "Note that if ",
  StyleBox["Rem(a, LC(p)) \[NotEqual]  ",
    FontSlant->"Italic"],
  "0, then ",
  StyleBox["LT(Red(t, p)) = Rem(a, LC(p)) m;",
    FontSlant->"Italic"],
  " otherwise ",
  StyleBox["LM(Red(t, p))",
    FontSlant->"Italic"],
  " \[PrecedesSlantEqual] ",
  StyleBox["m",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`f \[Element] R[x\_1,  ... , x\_n]\)]],
  ", and let ",
  StyleBox["P",
    FontSlant->"Italic"],
  " be an ordered finite subset of ",
  Cell[BoxData[
      \(TraditionalForm\`R[x\_1,  ... , x\_n]\\{0}\)]],
  ". ",
  StyleBox["f",
    FontSlant->"Italic"],
  " is ",
  StyleBox["reducible",
    FontSlant->"Italic"],
  " modulo ",
  StyleBox["P",
    FontSlant->"Italic"],
  " if ",
  StyleBox["f",
    FontSlant->"Italic"],
  " contains a term reducible modulo an element of ",
  StyleBox["P.",
    FontSlant->"Italic"],
  " The ",
  StyleBox["reduction",
    FontSlant->"Italic"],
  " ",
  StyleBox["Red(f, P)",
    FontSlant->"Italic"],
  " of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " modulo ",
  StyleBox["P",
    FontSlant->"Italic"],
  " is defined by the following procedure. While the set ",
  StyleBox["RT",
    FontSlant->"Italic"],
  " of terms of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " reducible modulo an element of ",
  StyleBox["P",
    FontSlant->"Italic"],
  " is not empty, take the term ",
  StyleBox["t",
    FontSlant->"Italic"],
  " \[Element] ",
  StyleBox["RT",
    FontSlant->"Italic"],
  " with the \[PrecedesSlantEqual]-largest monomial, take the first ",
  StyleBox["p",
    FontSlant->"Italic"],
  " \[Element] ",
  StyleBox["P",
    FontSlant->"Italic"],
  ", such that ",
  StyleBox["t",
    FontSlant->"Italic"],
  " is reducible modulo ",
  StyleBox["p",
    FontSlant->"Italic"],
  ", and replace the term ",
  StyleBox["t",
    FontSlant->"Italic"],
  " in ",
  StyleBox["f",
    FontSlant->"Italic"],
  " with ",
  StyleBox["Red(t, p)",
    FontSlant->"Italic"],
  ". Note that the monomials of terms ",
  StyleBox["t",
    FontSlant->"Italic"],
  " chosen in subsequent steps of the procedure form a \
\[PrecedesSlantEqual]-descending chain, and each monomial can appear at most \
",
  StyleBox["k",
    FontSlant->"Italic"],
  " times, where ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is the number of elements of ",
  StyleBox["P,",
    FontSlant->"Italic"],
  " hence the procedure terminates."
}], "Text"],

Cell[TextData[{
  "A Gr\[ODoubleDot]bner basis ",
  StyleBox["G",
    FontSlant->"Italic"],
  " is ",
  StyleBox["semi-reduced",
    FontSlant->"Italic"],
  " if for all ",
  StyleBox["g",
    FontSlant->"Italic"],
  " \[Element] ",
  StyleBox["G",
    FontSlant->"Italic"],
  ", ",
  StyleBox["g",
    FontSlant->"Italic"],
  " is not reducible modulo ",
  StyleBox["G\\",
    FontSlant->"Italic"],
  "{",
  StyleBox["g",
    FontSlant->"Italic"],
  "}",
  ", and if ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is the domain of integers, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["LC",
              FontSlant->"Italic"], "(", "g", ")"}], ">", "0"}], 
        TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  ButtonBox["GroebnerBasis",
    ButtonStyle->"RefGuideLink"],
  " returns semi-reduced Gr\[ODoubleDot]bner bases. In the following \
discussion, all Gr\[ODoubleDot]bner bases are assumed to be semi-reduced. \
Note that this is not the same as reduced Gr\[ODoubleDot]bner bases defined \
in the literature, since here the basis polynomials are not required to be \
monic. For a fixed monomial order, every ideal has a unique reduced Gr\
\[ODoubleDot]bner basis. Semi-reduced Gr\[ODoubleDot]bner bases defined here \
are only unique up to multiplication by invertible elements of ",
  StyleBox["R ",
    FontSlant->"Italic"],
  "(see ",
  ButtonBox["Property 2",
    ButtonData:>"GBProperty2",
    ButtonStyle->"Hyperlink"],
  "). "
}], "Text"],

Cell[TextData[{
  "Property 1: Let ",
  StyleBox["G",
    FontSlant->"Italic"],
  " be a Gr\[ODoubleDot]bner basis of an ideal ",
  StyleBox["I ",
    FontSlant->"Italic"],
  "in ",
  Cell[BoxData[
      \(TraditionalForm\`R[x\_1,  ... , x\_n]\)]],
  ", and let ",
  Cell[BoxData[
      \(TraditionalForm\`f \[Element] R[x\_1,  ... , x\_n]\)]],
  ". Then ",
  Cell[BoxData[
      \(TraditionalForm\`f \[Element] I\)]],
  " iff ",
  StyleBox["Red(f, G) =",
    FontSlant->"Italic"],
  " 0."
}], "Theorem",
  CellTags->"GBProperty1"],

Cell["This is a simple consequence of the definitions.", "Text"],

Cell[TextData[{
  "Property 2: Let ",
  Cell[BoxData[
      \(TraditionalForm\`G = {g\_1, \(\(...\) \(g\_k\)\)}\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`H = {h\_1, \(\(...\) \(h\_m\)\)}\)]],
  " be two Gr\[ODoubleDot]bner bases of an ideal ",
  StyleBox["I",
    FontSlant->"Italic"],
  " with respect to the same monomial order \[PrecedesSlantEqual], and \
suppose that elements of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " and ",
  StyleBox["H",
    FontSlant->"Italic"],
  " are ordered by their leading monomials. Then ",
  StyleBox["k = m",
    FontSlant->"Italic"],
  ", and for all ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] k\)]],
  ", if ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is the domain of integers, ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i = h\_i\)]],
  ", otherwise ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i = c\_i\ h\_i\)]],
  " for some invertible element ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " of ",
  StyleBox["R",
    FontSlant->"Italic"],
  ". "
}], "Theorem",
  CellTags->"GBProperty2"],

Cell[TextData[{
  "If ",
  StyleBox["LM(f) = LM(g)",
    FontSlant->"Italic"],
  ", then ",
  StyleBox["LT(f)",
    FontSlant->"Italic"],
  " is reducible modulo ",
  StyleBox["g",
    FontSlant->"Italic"],
  " or ",
  StyleBox["LT(g)",
    FontSlant->"Italic"],
  " is reducible modulo ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". Hence the leading monomials of the elements of a Gr\[ODoubleDot]bner \
basis are all different. Without loss of generality assume ",
  StyleBox["k ",
    FontSlant->"Italic"],
  "\[LessEqual]",
  StyleBox[" m",
    FontSlant->"Italic"],
  ". For induction, fix ",
  StyleBox["j",
    FontSlant->"Italic"],
  " ",
  "\[LessEqual]",
  StyleBox[" k",
    FontSlant->"Italic"],
  " and suppose that for all ",
  StyleBox["i",
    FontSlant->"Italic"],
  " < ",
  StyleBox["j",
    FontSlant->"Italic"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i = c\_i\ h\_i\)]],
  " for some invertible element ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " of ",
  StyleBox["R",
    FontSlant->"Italic"],
  ". If ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is the domain of integers, ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i = 1\)]],
  ". Without loss of generality assume ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["LM",
              FontSlant->"Italic"], "(", \(g\_j\), ")"}], 
          "\[PrecedesSlantEqual]", 
          RowBox[{
            StyleBox["LM",
              FontSlant->"Italic"], "(", \(h\_j\), ")"}]}], 
        TraditionalForm]]],
  ". Since ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j\)]],
  " belongs to ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", there exists ",
  StyleBox["i",
    FontSlant->"Italic"],
  ", such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(h\_i\), ")"}], TraditionalForm]]],
  " divides ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(g\_j\), ")"}], TraditionalForm]]],
  ". Then ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["LM",
              FontSlant->"Italic"], "(", \(h\_i\), ")"}], 
          "\[PrecedesSlantEqual]", 
          RowBox[{
            StyleBox["LM",
              FontSlant->"Italic"], "(", \(g\_j\), ")"}]}], 
        TraditionalForm]]],
  ", and so ",
  Cell[BoxData[
      \(TraditionalForm\`i \[LessEqual] j\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`i < j\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j\)]],
  " would be reducible modulo ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  " and also modulo ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i = c\_i\ h\_i\)]],
  ", which is impossible, since ",
  StyleBox["G",
    FontSlant->"Italic"],
  " is semi-reduced. Hence ",
  Cell[BoxData[
      \(TraditionalForm\`i = j\)]],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["LM",
              FontSlant->"Italic"], "(", \(g\_j\), ")"}], "=", 
          RowBox[{
            StyleBox["LM",
              FontSlant->"Italic"], "(", \(h\_j\), ")"}]}], 
        TraditionalForm]]],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(h\_j\), ")"}], TraditionalForm]]],
  " divides ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(g\_j\), ")"}], TraditionalForm]]],
  ". Similarly, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(g\_j\), ")"}], TraditionalForm]]],
  " divides ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(h\_j\), ")"}], TraditionalForm]]],
  ". Therefore, there exists an invertible element ",
  Cell[BoxData[
      \(TraditionalForm\`c\_j\)]],
  " of ",
  StyleBox["R",
    FontSlant->"Italic"],
  ", such that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["LT",
              FontSlant->"Italic"], "(", \(g\_j\), ")"}], "=", 
          RowBox[{\(c\_j\), 
            RowBox[{
              StyleBox["LT",
                FontSlant->"Italic"], "(", \(h\_j\), ")"}]}]}], 
        TraditionalForm]]],
  ". If ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is the domain of integers, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LC",
            FontSlant->"Italic"], "(", \(g\_j\), ")"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LC",
            FontSlant->"Italic"], "(", \(h\_j\), ")"}], TraditionalForm]]],
  " are positive, and so ",
  Cell[BoxData[
      \(TraditionalForm\`c\_j = 1\)]],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`r = \(c\_j\) h\_j - g\_j\)]],
  ". Suppose ",
  Cell[BoxData[
      \(TraditionalForm\`r \[NotEqual] 0\)]],
  ". Since ",
  StyleBox["r",
    FontSlant->"Italic"],
  " belongs to ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", ",
  StyleBox["LT(r) ",
    FontSlant->"Italic"],
  "must be divisible by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(g\_i\), ")"}], TraditionalForm]]],
  ", for some ",
  StyleBox["i",
    FontSlant->"Italic"],
  " < ",
  StyleBox["j",
    FontSlant->"Italic"],
  ". Let \[Alpha] and \[Beta] be the coefficients at ",
  StyleBox["LM(r)",
    FontSlant->"Italic"],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`h\_j\)]],
  ". If ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is a field, the term ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Alpha]", " ", 
          RowBox[{
            StyleBox["LM",
              FontSlant->"Italic"], "(", "r", ")"}]}], TraditionalForm]]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j\)]],
  " is reducible modulo ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i\)]],
  ", which contradicts the assumption that ",
  StyleBox["G",
    FontSlant->"Italic"],
  " is semi-reduced. If ",
  StyleBox["R",
    FontSlant->"Italic"],
  " is the domain of univariate polynomials over a field,"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["deg",
            FontSlant->"Italic"], "(", 
          RowBox[{
            StyleBox["LC",
              FontSlant->"Italic"], "(", \(g\_i\), ")"}], ")"}], 
        "\[LessEqual]", 
        RowBox[{
          StyleBox["deg",
            FontSlant->"Italic"], "(", 
          RowBox[{
            StyleBox["LC",
              FontSlant->"Italic"], "(", "r", ")"}], ")"}], "\[LessEqual]", 
        RowBox[{
          StyleBox["max",
            FontSlant->"Italic"], "(", 
          RowBox[{
            RowBox[{
              StyleBox["deg",
                FontSlant->"Italic"], "(", "\[Alpha]", ")"}], ",", 
            RowBox[{
              StyleBox["deg",
                FontSlant->"Italic"], "(", "\[Beta]", ")"}]}], ")"}]}], 
      TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "and so either ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j\)]],
  " is reducible modulo ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i\)]],
  ", or ",
  Cell[BoxData[
      \(TraditionalForm\`h\_j\)]],
  " is reducible modulo ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i = \(c\_i\) g\_i\)]],
  ", which contradicts the assumption that ",
  StyleBox["G",
    FontSlant->"Italic"],
  " and ",
  StyleBox["H",
    FontSlant->"Italic"],
  " are semi-reduced. Finally, let ",
  StyleBox["R",
    FontSlant->"Italic"],
  " be the domain of integers. Since neither ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j\)]],
  " is reducible modulo ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i\)]],
  " nor ",
  Cell[BoxData[
      \(TraditionalForm\`h\_j\)]],
  " is reducible modulo ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i = g\_i\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["-"], 
              RowBox[{
                StyleBox["LC",
                  FontSlant->"Italic"], "(", \(g\_i\), ")"}]}], "/", "2"}], 
          "<", "\[Alpha]", 
          StyleBox["\[LessEqual]"], 
          RowBox[{
            RowBox[{
              StyleBox["LC",
                FontSlant->"Italic"], "(", \(g\_i\), ")"}], "/", "2"}]}], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                StyleBox["LC",
                  FontSlant->"Italic"], "(", \(g\_i\), ")"}]}], "/", "2"}], 
          "<", " ", "\[Beta]", 
          StyleBox["\[LessEqual]"], 
          RowBox[{
            RowBox[{
              StyleBox["LC",
                FontSlant->"Italic"], "(", \(g\_i\), ")"}], "/", "2"}]}], 
        TraditionalForm]]],
  ". Hence ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                StyleBox["LC",
                  FontSlant->"Italic"], "(", \(g\_i\), ")"}]}], "<", 
            RowBox[{
              StyleBox["LC",
                FontSlant->"Italic"], "(", "r", ")"}]}], "=", 
          RowBox[{\(\[Beta] - \[Alpha]\), "<", 
            RowBox[{
              StyleBox["LC",
                FontSlant->"Italic"], "(", \(g\_i\), ")"}]}]}], 
        TraditionalForm]]],
  ", which is impossible, since ",
  StyleBox["LT(r) ",
    FontSlant->"Italic"],
  "is divisible by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["LT",
            FontSlant->"Italic"], "(", \(g\_i\), ")"}], TraditionalForm]]],
  ". Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`r = 0\)]],
  ", and so ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j = c\_j\ h\_j\)]],
  ". By induction on ",
  StyleBox["j",
    FontSlant->"Italic"],
  ", for all  ",
  StyleBox["j",
    FontSlant->"Italic"],
  " ",
  "\[LessEqual]",
  StyleBox[" k,",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j = c\_j\ h\_j\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`k < m\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`h\_\(k + 1\)\)]],
  " would be reducible modulo some ",
  Cell[BoxData[
      \(TraditionalForm\`g\_j\)]],
  ", with ",
  StyleBox["j",
    FontSlant->"Italic"],
  " ",
  "\[LessEqual]",
  StyleBox[" k,",
    FontSlant->"Italic"],
  " and hence ",
  Cell[BoxData[
      \(TraditionalForm\`h\_\(k + 1\)\)]],
  " would be reducible modulo ",
  Cell[BoxData[
      \(TraditionalForm\`h\_j = \(c\_j\^\(-1\)\) g\_j\)]],
  ". Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`k = m\)]],
  ", which completes the proof of ",
  ButtonBox["Property 2.",
    ButtonData:>"GBProperty2",
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[TextData[{
  "Property 3: Let ",
  StyleBox["I",
    FontSlant->"Italic"],
  " be an ideal in ",
  Cell[BoxData[
      \(TraditionalForm\`R[x\_1,  ... , x\_n]\)]],
  ", let ",
  Cell[BoxData[
      \(TraditionalForm\`f \[Element] R[x\_1,  ... , x\_n]\)]],
  ", and let ",
  StyleBox["G",
    FontSlant->"Italic"],
  " be a Gr\[ODoubleDot]bner basis of the ideal ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(<\)\(I\)\), \(\(1 - y\ f\)\(>\)\)\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`R[x\_1,  ... , x\_n, y]\)]],
  ". Then ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "belongs to the radical of ",
  StyleBox["I",
    FontSlant->"Italic"],
  " iff ",
  Cell[BoxData[
      \(TraditionalForm\`G = {c}\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "for an invertible element ",
  StyleBox["c",
    FontSlant->"Italic"],
  " of ",
  StyleBox["R",
    FontSlant->"Italic"],
  "."
}], "Theorem",
  CellTags->"GBProperty3"],

Cell[TextData[{
  "If an ideal contains invertible elements of ",
  StyleBox["R,",
    FontSlant->"Italic"],
  " ",
  ButtonBox["GroebnerBasis",
    ButtonStyle->"RefGuideLink"],
  " always returns {1}. "
}], "Text"],

Cell["Note first that", "Text"],

Cell[BoxData[
    \(TraditionalForm\`1 - \(y\^\(2\^k\)\) 
          f\^\(2\^k\) = \(\((1 - y\ f)\) \((1 + 
                y\ f)\) ... \) \((1 + \(y\^\(2\^\(k - 1\)\)\) 
              f\^\(2\^\(k - 1\)\))\)\)], "DisplayFormula"],

Cell[TextData[{
  "belongs to the ideal ",
  Cell[BoxData[
      \(TraditionalForm\`J = \(\(<\)\(I\)\), \(\(1 - y\ f\)\(>\)\)\)]],
  " for any nonnegative integer ",
  StyleBox["k",
    FontSlant->"Italic"],
  ". Hence, if ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "belongs to the radical of ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", then 1 belongs to ",
  StyleBox["J. ",
    FontSlant->"Italic"],
  "Since",
  StyleBox[" G ",
    FontSlant->"Italic"],
  "is a",
  StyleBox[" ",
    FontSlant->"Italic"],
  "Gr\[ODoubleDot]bner basis of",
  StyleBox[" J",
    FontSlant->"Italic"],
  ", it must contain an element ",
  StyleBox["c",
    FontSlant->"Italic"],
  " whose leading coefficient divides 1. Hence ",
  StyleBox["c",
    FontSlant->"Italic"],
  " is an invertible element of ",
  StyleBox["R",
    FontSlant->"Italic"],
  ". Since ",
  StyleBox["G",
    FontSlant->"Italic"],
  " is semi-reduced and ",
  StyleBox["c",
    FontSlant->"Italic"],
  " divides any term, ",
  Cell[BoxData[
      \(TraditionalForm\`G = {c}\)]],
  ". Now suppose that  ",
  Cell[BoxData[
      \(TraditionalForm\`G = {c}\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "for an invertible element ",
  StyleBox["c",
    FontSlant->"Italic"],
  " of ",
  StyleBox["R",
    FontSlant->"Italic"],
  ". Then 1 belongs to ",
  StyleBox["J",
    FontSlant->"Italic"],
  ", and so "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`1 = \(a\_0 + \(a\_1\) y +  ... \) + \(a\_m\) 
          y\^m + \((1 - 
              y\ f)\) \((\(b\_0 + \(b\_1\) y +  ... \) + \(b\_\(m - 1\)\) 
                y\^\(m - 1\))\)\)], "DisplayFormula"],

Cell[TextData[{
  "where each ",
  Cell[BoxData[
      \(TraditionalForm\`a\_i\)]],
  " belongs to ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", and each ",
  Cell[BoxData[
      \(TraditionalForm\`b\_i\)]],
  " belongs to ",
  Cell[BoxData[
      \(TraditionalForm\`R[x\_1,  ... , x\_n]\)]],
  ". Hence comparing coefficients at powers of ",
  StyleBox["y",
    FontSlant->"Italic"],
  " leads to the following equations modulo ",
  StyleBox["I",
    FontSlant->"Italic"],
  ": ",
  Cell[BoxData[
      \(TraditionalForm\`b\_0 \[Congruent] 1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`b\_i \[Congruent] \(b\_\(i - 1\)\) f\)]],
  ", for ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] m - 1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\(b\_\(m - 1\)\) f \[Congruent] 0\)]],
  ". Then, ",
  Cell[BoxData[
      \(TraditionalForm\`b\_i \[Congruent] f\^i\)]],
  ", for ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] i \[LessEqual] m - 1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`f\^m \[Congruent] 0\)]],
  " modulo ",
  StyleBox["I",
    FontSlant->"Italic"],
  ". Therefore, ",
  StyleBox["f",
    FontSlant->"Italic"],
  " belongs to the radical of ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", which completes the proof of ",
  ButtonBox["Property 3",
    ButtonData:>"GBProperty3",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"],

Cell["\<\
The following more technical property is important for solving \
complex polynomial systems.\
\>", "Text"],

Cell[TextData[{
  "Property 4: Let ",
  StyleBox["G",
    FontSlant->"Italic"],
  " be a Gr\[ODoubleDot]bner basis of an ideal ",
  StyleBox["I",
    FontSlant->"Italic"],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC][x\_1,  ... , x\_n, y]\)]],
  " with a monomial order that makes monomials containing ",
  StyleBox["y",
    FontSlant->"Italic"],
  " greater than monomials not containing ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", let ",
  StyleBox["h",
    FontSlant->"Italic"],
  " be the element of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " with the lowest positive degree ",
  StyleBox["d",
    FontSlant->"Italic"],
  " in ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", let ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["c",
            FontSlant->"Italic"], "(", \(x\_1,  ... , x\_n\), ")"}], 
        TraditionalForm]]],
  " be the leading coefficient of ",
  StyleBox["h",
    FontSlant->"Italic"],
  " in ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and let ",
  Cell[BoxData[
      \(TraditionalForm\`{h\_1,  ... , \ h\_s}\)]],
  " be all elements of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " that do not depend on ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". Then for any polynomial ",
  StyleBox["p ",
    FontSlant->"Italic"],
  "\[Element]",
  StyleBox[" I",
    FontSlant->"Italic"],
  " and any point ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\_1,  ... , \ \(a\_\(\(n\)\(,\)\)\) b)\)\)]],
  " if ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["c",
              FontSlant->"Italic"], "(", \(a\_1,  ... , a\_n\), ")"}], 
          "\[NotEqual]", "0"}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(h\_i\)(a\_1,  ... , a\_n) = 0\)]],
  ", for ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] s\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`h(a\_1,  ... , a\_n, b) = \ 0\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`p(a\_1,  ... , a\_n, b) = \ 0\)]],
  "."
}], "Theorem",
  CellTags->"GBProperty4"],

Cell[TextData[{
  "Consider the pseudoremainder ",
  StyleBox["r",
    FontSlant->"Italic"],
  " of the division of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " by ",
  StyleBox["h",
    FontSlant->"Italic"],
  " as polynomials in ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(c(x\_1,  ... , x\_n)\)\^e\) \(p(x\_1,  ... , x\_n, 
          y)\) = \(q(x\_1,  ... , x\_n, y)\)\ \(h(x\_1,  ... , x\_n, y)\) + 
        r(x\_1,  ... , x\_n, y)\)], "NumberedEquation",
  CellTags->"ComplQuantElim5"],

Cell[TextData[{
  "Since ",
  StyleBox["p",
    FontSlant->"Italic"],
  " and ",
  StyleBox["h",
    FontSlant->"Italic"],
  " belong to ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", so does ",
  StyleBox["r",
    FontSlant->"Italic"],
  ". By ",
  ButtonBox["Property 1, ",
    ButtonData:>"GBProperty1",
    ButtonStyle->"Hyperlink"],
  "reduction of ",
  StyleBox["r",
    FontSlant->"Italic"],
  " by ",
  StyleBox["G",
    FontSlant->"Italic"],
  " must yield zero. Since the degree of ",
  StyleBox["r",
    FontSlant->"Italic"],
  " in ",
  StyleBox["y",
    FontSlant->"Italic"],
  " is less than ",
  StyleBox["d",
    FontSlant->"Italic"],
  ", ",
  StyleBox["r",
    FontSlant->"Italic"],
  " cannot be reduced by any of the elements of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " that depend on ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". Hence"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`r(x\_1,  ... , x\_n, 
        y) = \ \(\(\(\(\(p\_1\)(x\_1,  ... , x\_n, y)\) \(\(h\_1\)(
                x\_1,  ... , x\_n)\)\)\(+\)\) ... \) + \(\(p\_s\)(
            x\_1,  ... , x\_n, y)\) \(\(h\_s\)(x\_1,  ... , 
            x\_n)\)\)], "DisplayFormula"],

Cell[TextData[{
  "and so ",
  Cell[BoxData[
      \(TraditionalForm\`r(a\_1,  ... , a\_n, b) = 0\)]],
  ". Since ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["c",
              FontSlant->"Italic"], "(", \(a\_1,  ... , a\_n\), ")"}], 
          "\[NotEqual]", "0"}], TraditionalForm]]],
  ", (",
  ButtonBox["5",
    ButtonData:>"ComplQuantElim5",
    ButtonStyle->"Hyperlink"],
  ") implies that ",
  Cell[BoxData[
      \(TraditionalForm\`p(a\_1,  ... , a\_n, b) = \ 0\)]],
  ", which completes the proof of ",
  ButtonBox["Property 4",
    ButtonData:>"GBProperty4",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function GroebnerBasis "
}], "Subsection"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  ButtonBox["GroebnerBasis",
    ButtonStyle->"RefGuideLink"],
  " finds semi-reduced Gr\[ODoubleDot]bner bases. This section describes ",
  ButtonBox["GroebnerBasis",
    ButtonStyle->"RefGuideLink"],
  " options used in solving of complex polynomial systems."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["CoefficientDomain",
              "MR"], 
            StyleBox["Automatic",
              
              "MR"], \(the\ type\ of\ objects\ assumed\ to\ be\ \
coefficients\)},
          {
            StyleBox["Method",
              "MR"], 
            StyleBox["Buchberger",
              "MR"], Cell["the method used to compute the basis", "Text"]},
          {
            StyleBox["MonomialOrder",
              "MR"], 
            StyleBox["Lexicographic",
              "MR"], Cell[
            "the criterion used for ordering monomials", "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  StyleBox["GroebnerBasis", "MR"],
  " options used in solving of complex polynomial systems. "
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CoefficientDomain", "TR"]], "SubsubsectionIcon"],

Cell[TextData[{
  "This option specifies the domain ",
  StyleBox["R",
    FontSlant->"Italic"],
  " of coefficients",
  StyleBox[".",
    FontSlant->"Italic"],
  " With the default ",
  StyleBox["Automatic", "MR"],
  " setting, the coefficient domain is the field generated by numeric \
coefficients present in the input. "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{GridBox[{
            {
              StyleBox["Integers",
                "MR"], \(the\ domain\ of\ integers\)}
            }], GridBox[{
            {
              RowBox[{
                StyleBox["InexactNumbers",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["prec",
                  "TI"], 
                StyleBox["]",
                  "MR"]}], Cell[TextData[{
                "inexact numbers with precision ",
                StyleBox["prec",
                  FontSlant->"Italic"]
              }], "Text"]}
            }], GridBox[{
            {
              StyleBox[
                RowBox[{"Polynomials", "[", 
                  StyleBox["x"], "]"}],
                "MR"], 
              RowBox[{
              "the", " ", "domain", " ", "of", " ", "polynomials", " ", "in", 
                " ", 
                StyleBox["x",
                  FontSlant->"Italic"]}]},
            {
              StyleBox["RationalFunctions",
                "MR"], Cell[TextData[{
                
                "the field of rational functions in variables not on the \
variable list given to ",
                StyleBox["GroebnerBasis", "MR"]
              }], "Text"]},
            {
              StyleBox["Rationals",
                "MR"], Cell["the field of rational numbers", "Text"]}
            }]}], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Available settings for ",
  StyleBox["CoefficientDomain", "MR"],
  "."
}], "Caption"],

Cell[TextData[{
  "Note that the coefficient domain ",
  StyleBox["R",
    FontSlant->"Italic"],
  " also depends on the setting of the ",
  StyleBox["Modulus", "MR"],
  " option of ",
  StyleBox["GroebnerBasis", "MR"],
  ". With ",
  StyleBox["Modulus", "MR"],
  "\[Rule]",
  StyleBox["p",
    FontSlant->"Italic"],
  ", for a prime number ",
  StyleBox["p",
    FontSlant->"Italic"],
  ", the coefficient domain is the field ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  ", or the field of rational functions over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  " if ",
  StyleBox["CoefficientDomain->RationalFunctions", "MR"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Method", "TR"]], "SubsubsectionIcon"],

Cell[TextData[{
  "With the default setting ",
  StyleBox["Method->Buchberger", "MR"],
  ", ",
  StyleBox["GroebnerBasis", "MR"],
  " uses a variant of the Buchberger algorithm. Another algorithm available \
is the Gr\[ODoubleDot]bner walk, which computes a Gr\[ODoubleDot]bner basis \
in an easier monomial order and then transforms it to the required harder \
monomial order. This is often faster than directly computing a \
Gr\[ODoubleDot]bner basis in the required order, especially if the input \
polynomials are known to be a Gr\[ODoubleDot]bner basis for the easier \
order."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["GroebnerBasis[", "MR"],
              StyleBox["polys", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["vars", "TI"],
              StyleBox[", Method\[Rule]{\"GroebnerWalk\"", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      RowBox[{
                        FormBox[
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                StyleBox["InitialMonomialOrder",
                                  "MR"], 
                                StyleBox["->",
                                  "MR"], 
                                SubscriptBox[
                                  StyleBox["order",
                                    "TI"], "1"]}], "}"}], ",", " "}],
                          "TraditionalForm"], 
                        StyleBox["MonomialOrder",
                          "MR"]}], 
                      StyleBox["->",
                        "MR"], 
                      SubscriptBox[
                        StyleBox["order",
                          "TI"], "2"]}], TraditionalForm]]]
            }], "Text"], Cell[TextData[{
              "find a Gr\[ODoubleDot]bner basis in ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["order",
                        FontSlant->"Italic"], "1"], TraditionalForm]]],
              
              " and use the Gr\[ODoubleDot]bner walk algorithm to transform \
it to a Gr\[ODoubleDot]bner basis in ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["order",
                        FontSlant->"Italic"], "2"], TraditionalForm]]]
            }], "Text"]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->0.5},
  CellTags->"GBWalk"],

Cell["\<\
Transforming Gr\[ODoubleDot]bner bases using the \
Gr\[ODoubleDot]bner walk algorithm. \
\>", "Caption"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["MonomialOrder", "TR"]], "SubsubsectionIcon"],

Cell[TextData[{
  "This option specifies the monomial order. The value can be either one of \
the named monomial orders or a weight matrix. The following table gives \
conditions for ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1\^d\_1 ... \) x\_n\^d\_n\)]],
  "\[PrecedesSlantEqual]",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(x\_1\^e\_1 ... \) x\_n\^e\_n\)\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["Lexicographic",
              "MR"], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          FormBox[\(d\_1 \[Equal] e\_1\),
                            "TraditionalForm"], "\[And]"}], "..."}], 
                      "\[And]", \(d\_\(i - 1\) \[Equal] e\_\(i - 1\)\)}], 
                    TraditionalForm]]],
              " \[And] ",
              Cell[BoxData[
                  \(TraditionalForm\`d\_i < e\_i\)]]
            }], "Text"]},
          {
            StyleBox["DegreeLexicographic",
              "MR"], 
            RowBox[{Cell[TextData[Cell[BoxData[
                  \(TraditionalForm\`\(\(\(\(d\_1\)\(+\)\) ... \) + 
                          d\_n < \(\(e\_1\)\(+\)\) ... \) + e\_n\)]]], 
                "Text"], "\[Or]", " ", 
              RowBox[{"(", 
                RowBox[{Cell[TextData[Cell[BoxData[
                      \(TraditionalForm\`\(\(\(\(d\_1\)\(+\)\) ... \) + 
                              d\_n \[Equal] \(\(e\_1\)\(+\)\) ... \) + 
                        e\_n\)]]], "Text"], "\[And]", Cell[TextData[{
                    Cell[BoxData[
                        FormBox[
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                FormBox[\(d\_1 \[Equal] e\_1\),
                                  "TraditionalForm"], "\[And]"}], "..."}], 
                            "\[And]", \(d\_\(i - 1\) \[Equal] 
                              e\_\(i - 1\)\)}], TraditionalForm]]],
                    " \[And] ",
                    Cell[BoxData[
                        \(TraditionalForm\`d\_i < e\_i\)]]
                  }], "Text"]}], ")"}]}]},
          {
            StyleBox["DegreeReverseLexicographic",
              "MR"], 
            RowBox[{
              RowBox[{Cell["", "Text"], Cell[TextData[Cell[BoxData[
                    \(TraditionalForm\`\(\(\(\(d\_1\)\(+\)\) ... \) + 
                            d\_n < \(\(e\_1\)\(+\)\) ... \) + e\_n\)]]], 
                  "Text"]}], "\[Or]", " ", 
              RowBox[{"(", 
                RowBox[{Cell[TextData[Cell[BoxData[
                      \(TraditionalForm\`\(\(\(\(d\_1\)\(+\)\) ... \) + 
                              d\_n \[Equal] \(\(e\_1\)\(+\)\) ... \) + 
                        e\_n\)]]], "Text"], "\[And]", Cell[TextData[{
                    Cell[BoxData[
                        FormBox[
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                FormBox[\(d\_n \[Equal] e\_n\),
                                  "TraditionalForm"], "\[And]"}], "..."}], 
                            "\[And]", \(d\_\(i + 1\) \[Equal] 
                              e\_\(i + 1\)\)}], TraditionalForm]]],
                    " \[And] ",
                    Cell[BoxData[
                        \(TraditionalForm\`d\_i < e\_i\)]]
                  }], "Text"]}], ")"}]}]}
          }], TextForm]], "DefinitionBox"],

Cell["Monomial orders. ", "Caption"],

Cell[TextData[{
  "Quantifier elimination needs an order in which monomials containing \
quantifier variables are greater than monomials not containing quantifier \
variables. The ",
  StyleBox["Lexicographic", "MR"],
  " order satisfies this condition, but the following ",
  StyleBox["EliminationOrder", "MR"],
  " usually leads to faster computations."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[\(\(\(m\_1\)(X)\) \(\(n\_1\)(Y)\)\),
            "TraditionalForm"], 
          "\[PrecedesSlantEqual]", \(\(\(m\_2\)(
              X)\) \(\(n\_2\)(Y)\)\[DoubleLongLeftRightArrow]\ \(\(n\_1\)(
                Y)\)\), \( \[PrecedesSlantEqual] \_DRL\), \(\(n\_2\)(Y)\)}], 
        "\[Or]", \((\(n\_1\)(Y) == \(n\_2\)(Y) \[And] \(m\_1\)(
                X)\( \[PrecedesSlantEqual] \_DRL\)\(m\_2\)(X)\)}], 
      TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  StyleBox["X",
    FontSlant->"Italic"],
  " denotes free variables, ",
  StyleBox["Y",
    FontSlant->"Italic"],
  " denotes quantifier variables, ",
  Cell[BoxData[
      \(TraditionalForm\`m\_i\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`n\_i\)]],
  " are monomials, and ",
  Cell[BoxData[
      \(TraditionalForm\`\( \[PrecedesSlantEqual] \_DRL\)\)]],
  " denotes the ",
  StyleBox["DegreeReverseLexicographic", "MR"],
  " order."
}], "Text"],

Cell[TextData[{
  "Using ",
  StyleBox["EliminationOrder", "MR"],
  " requires the ",
  StyleBox["GroebnerBasis", "MR"],
  " syntax with elimination variables specified."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GroebnerBasis",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["polys",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["xvars",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["yvars",
                  "TI"], ",", " ", 
                RowBox[{
                  StyleBox["MonomialOrder",
                    "MR"], 
                  StyleBox["\[Rule]",
                    FontVariations->{"StrikeThrough"->True}], 
                  StyleBox["EliminationOrder",
                    "MR"]}]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
            "find", " ", "a", " ", "Gr\[ODoubleDot]bner", " ", "basis", " ", 
              "in", " ", 
              StyleBox["EliminationOrder",
                "MR"], " "}]}
          }], TextForm]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->0.5},
  CellTags->"ElimOrder"],

Cell["Gr\[ODoubleDot]bner basis in elimination order.", "Caption"],

Cell[TextData[{
  "By default, ",
  StyleBox["GroebnerBasis", "MR"],
  " with ",
  StyleBox["MonomialOrder->EliminationOrder", "MR"],
  ", drops the polynomials that contain ",
  StyleBox["yvars",
    FontSlant->"Italic"],
  " from the result, returning only basis polynomials in ",
  StyleBox["xvars",
    FontSlant->"Italic"],
  ". To get all basis polynomials, the value of the system option ",
  StyleBox["EliminateFromGroebnerBasis", "MR"],
  " from the ",
  StyleBox["GroebnerBasisOptions", "MR"],
  " group must be changed. (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " changes the option locally in the quantifier elimination algorithm.) The \
option value can be changed with"
}], "Text"],

Cell["\<\
Developer`SetSystemOptions[\"GroebnerBasisOptions\"
        \[Rule] {\"EliminateFromGroebnerBasis\"-> False}]\
\>", "Program"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["EliminateFromGroebnerBasis", "MR"],
              StyleBox["\"", "MR"]
            }]], 
            StyleBox[Cell[TextData[StyleBox["True", "MR"]]],
              "MR"], 
            RowBox[{
              RowBox[{"whether", " ", 
                StyleBox["GroebnerBasis",
                  "MR"], " ", "with", " ", 
                StyleBox["MonomialOrder",
                  "MR"]}], 
              StyleBox["->",
                "MR"], 
              RowBox[{
                StyleBox["EliminationOrder",
                  "MR"], " ", "should", " ", "remove", " ", "polynomials", 
                " ", "containing", " ", "elimination", " ", "variables"}]}]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.1, 0.7},
  RowLines->{0.5, False}}],

Cell[TextData[{
  "System option ",
  StyleBox["EliminateFromGroebnerBasis", "MR"],
  "."
}], "Caption"],

Cell[TextData[{
  "This eliminates ",
  StyleBox["y",
    FontSlant->"Italic"],
  " from ",
  Cell[BoxData[
      \(\[Exists] \_y\((x\_1\%2 + x\_2\%2 - \(x\_1\) \(x\_2\) y \[Equal] 
              1 \[And] 
            x\_1\%2 + x\_2\%2 + \(x\_1\) \(x\_2\) y + 1 \[Equal] 0)\)\)]],
  ". The answer is a polynomial whose zeros are the Zariski closure of the \
projection of the solution set of the two original equations on the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_1, x\_2)\)\)]],
  " plane."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\_1\%2 + x\_2\%2 - \(x\_1\) \(x\_2\) y - 1, 
        x\_1\%2 + x\_2\%2 + \(x\_1\) \(x\_2\) y + 1}, {x\_1, x\_2}, {y}, 
      MonomialOrder \[Rule] EliminationOrder]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({x\_1\%2 + x\_2\%2}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "The exact description of the projection of the solution set on the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_1, x\_2)\)\)]],
  " plane depends on all basis polynomials. Note that the second basis \
polynomial cannot be zero if ",
  Cell[BoxData[
      \(x\_1\)]],
  " or ",
  Cell[BoxData[
      \(x\_2\)]],
  " are zero."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Developer`SetSystemOptions["\<GroebnerBasisOptions\>" \[Rule] \
{"\<EliminateFromGroebnerBasis\>" \[Rule] False}]; \), "\n", 
    \(GroebnerBasis[{x\_1\%2 + x\_2\%2 - \(x\_1\) \(x\_2\) y - 1, 
        x\_1\%2 + x\_2\%2 + \(x\_1\) \(x\_2\) y + 1}, {x\_1, x\_2}, {y}, 
      MonomialOrder \[Rule] EliminationOrder]\)}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({x\_1\%2 + x\_2\%2, 
      1 + y\ x\_1\ x\_2, \(-x\_1\) + y\ x\_2\%3}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell["This resets the system option to its default value.", "MathCaption"],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<GroebnerBasisOptions\>" \[Rule] \
{"\<EliminateFromGroebnerBasis\>" \[Rule] True}]; \)], "Input",
  CellLabel->"In[7]:="],

Cell[TextData[{
  StyleBox["Resolve", "MR"],
  " gives the exact description of the projection of the solution set on the \
",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_1, x\_2)\)\)]],
  " plane."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[\[Exists] \_y\((x\_1\%2 + 
                x\_2\%2 - \(x\_1\) \(x\_2\) y \[Equal] 1 \[And] 
            x\_1\%2 + x\_2\%2 + \(x\_1\) \(x\_2\) y + 1 \[Equal] 
              0)\)]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \(x\_1\%2 + x\_2\%2 \[Equal] 0 && x\_2 \[NotEqual] 0\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Decision Problems", "Section"],

Cell[TextData[{
  "A ",
  StyleBox["decision problem",
    FontSlant->"Italic"],
  " is a system with all variables existentially quantified, that is, a \
system of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\[Exists] \_\(x\_1\)\[Exists] \_\(x\_2\) ... \) \(\
\[Exists] \_\(x\_n\)\[CapitalPhi](x\_1,  ... , x\_n)\)\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  " are all variables in \[CapitalPhi]. Solving a decision problem means \
deciding whether it is equivalent to ",
  StyleBox["True", "MR"],
  " or to ",
  StyleBox["False", "MR"],
  ", that is, deciding whether the ",
  "quantifier-free",
  " system of polynomial equations and inequations ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n)\)]],
  " has solutions."
}], "Text"],

Cell["\<\
Solving this decision problem proves that a quadratic equation with \
a zero determinant cannot have two different roots.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_{a, b, c, x, y}\((a\ x\^2 + b\ x + c \[Equal] 0 && 
            a\ y\^2 + b\ y + c \[Equal] 0 && x \[NotEqual] y && 
            b\^2 - 4\ a\ c \[Equal] 0 && a \[NotEqual] 0)\)]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["Given the identities", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(\(\[Exists] \_x\((\ \(\(\(\[CapitalPhi]\_1\)\(\
\[Or]\)\) ... \) \[Or] \ \[CapitalPhi]\_\(\(n\)\(\ \)\))\)\ \
\[DoubleLongLeftRightArrow]\ \ \(\[Exists] \_x \
\[CapitalPhi]\_1\)\)\(\[Or]\)\) ... \) \[Or] \ \[Exists] \_x \
\[CapitalPhi]\_\(\(n\)\(\ \)\)\[IndentingNewLine]
    \(\(\(\(g\_1 \[NotEqual] 0\)\(\[And]\)\) ... \) \[And] 
            g\_k \[NotEqual] \(\(0\ \[DoubleLongLeftRightArrow]\ \ g\_1\)\(\
\[CenterDot]\)\) ... \)\[CenterDot]g\_k \[NotEqual] 
      0\)\(\ \)\)\)], "DisplayFormula"],

Cell["\<\
solving any decision problem can be reduced to solving a finite \
number of decision problems of the form\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(\[Exists] \_\(x\_1\)\[Exists] \_\(x\_2\) \
... \) \(\[Exists] \_\(x\_n\)\(f\_1\)(x\_1,  ... , x\_n) \[Equal] 
                0\)\)\(\[And]\)\) ... \) \[And] \(f\_k\)(x\_1,  ... , 
          x\_n) \[Equal] 0 \[And] \ 
      g(x\_1,  ... , x\_n) \[NotEqual] 0\)], "DisplayFormula"],

Cell[TextData[{
  "By Hilbert\[CloseCurlyQuote]s nullstellensatz and ",
  ButtonBox["Property 3",
    ButtonData:>"GBProperty3",
    ButtonStyle->"Hyperlink"],
  " of Gr\[ODoubleDot]bner bases"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(f\_1\)(x\_1,  ... , x\_n) \[Equal] 
            0\)\(\[And]\)\) ... \) \[And] \(f\_k\)(x\_1,  ... , 
          x\_n) \[Equal] 0 \[And] \ 
      g(x\_1,  ... , x\_n) \[NotEqual] 0\)], "DisplayFormula"],

Cell["has complex solutions iff ", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox["GroebnerBasis",
          "MR"], 
        "[", \({f\_1,  ... , f\_k, 1 - g\ z}, \ {x\_1,  ... , x\_n, \ z}\), 
        "]"}], TraditionalForm]], "DisplayFormula"],

Cell["with an arbitrary monomial order, is different than {1}. ", "Text"],

Cell[TextData[{
  "This shows that ",
  Cell[BoxData[
      \(x\^2 + y\^2 == 2\  \[And] x == y\  \[And] x \[NotEqual] \(-1\)\)]],
  " has complex solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\^2 + y\^2 - 2, x - y, 1 - \((x + 1)\)\ z}, {x, y, 
        z}]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({\(-1\) + 2\ z, 1 - y, 1 - x}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "This shows that ",
  Cell[BoxData[
      \(x\^2 + y\^2 == 2\  \[And] x == y\  \[And] x\^2 \[NotEqual] 1\)]],
  " has no complex solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\^2 + y\^2 - 2, x - y, 1 - \((x\^2 - 1)\)\ z}, {x, y, 
        z}]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \({1}\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " solves a decision problem, the monomial order used by the ",
  StyleBox["GroebnerBasis", "MR"],
  " computation is ",
  StyleBox["MonomialOrder->EliminationOrder", "MR"],
  ", with {",
  StyleBox["z",
    FontSlant->"Italic"],
  "} specified as the elimination variable list. This setting corresponds to \
the monomial ordering in which monomials containing ",
  StyleBox["z",
    FontSlant->"Italic"],
  " are greater than those that do not contain ",
  StyleBox["z",
    FontSlant->"Italic"],
  ", and the ordering of monomials not containing ",
  StyleBox["z",
    FontSlant->"Italic"],
  " is degree reverse lexicographic. If there is no inequation condition, \
there is no need to introduce ",
  StyleBox["z",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses ",
  StyleBox["MonomialOrder->DegreeReverseLexicographic", "MR"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quantifier Elimination", "Section",
  CellTags->"ComplexQuantifierElimination"],

Cell[TextData[{
  "For any complex polynomial system there exists an equivalent \
quantifier-free complex polynomial system. This follows from Chevalley\
\[CloseCurlyQuote]s theorem stating that a projection of a \
quasi-algebraically constructible set (a solution set of a quantifier-free \
system of polynomial equations and inequations) is a quasi-algebraically \
constructible set (see [",
  ButtonBox["3",
    ButtonData:>"L",
    ButtonStyle->"Hyperlink"],
  "]). ",
  StyleBox["Quantifier elimination ",
    FontSlant->"Italic"],
  "is the procedure of finding a quantifier-free complex polynomial system \
equivalent to a given complex polynomial system. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", quantifier elimination for complex polynomial systems is done by ",
  StyleBox["Resolve", "MR"],
  ". It is also used by ",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["FindInstance", "MR"],
  " as the first step in solving or finding instances of solutions of complex \
polynomial systems."
}], "Text"],

Cell["\<\
Eliminating quantifiers from this system gives a condition for \
quadratic equations to have at least two different zeros.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[\[Exists] \_{x, y}\((a\ x\^2 + b\ x + c \[Equal] 0 && 
            a\ y\^2 + b\ y + c \[Equal] 0 && x \[NotEqual] y)\)]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(\((a \[NotEqual] 0 && \(-b\^2\) + 4\ a\ c \[NotEqual] 
            0)\) || \((a \[Equal] 0 && b \[Equal] 0 && 
          c \[Equal] 0)\)\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "For complex polynomial systems ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the following quantifier elimination method. Given the identities"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\[ForAll] \_x \[CapitalPhi]\ \ \
\[DoubleLongLeftRightArrow]\ \ \(\[Not] \((\[Exists] \_x\(\[Not] \
\[CapitalPhi]\))\)\)\[IndentingNewLine]
    \(\(\(\[Exists] \_x\((\ \(\(\(\[CapitalPhi]\_1\)\(\[Or]\)\) ... \) \[Or] \
\ \[CapitalPhi]\_\(\(n\)\(\ \)\))\)\ \[DoubleLongLeftRightArrow]\ \ \(\
\[Exists] \_x \[CapitalPhi]\_1\)\)\(\[Or]\)\) ... \) \[Or] \ \[Exists] \_x \
\[CapitalPhi]\_\(\(n\)\(\ \)\)\[IndentingNewLine]
    \(\(\(\(g\_1 \[NotEqual] 0\)\(\[And]\)\) ... \) \[And] 
            g\_k \[NotEqual] \(\(0\ \[DoubleLongLeftRightArrow]\ \ g\_1\)\(\
\[CenterDot]\)\) ... \)\[CenterDot]g\_k \[NotEqual] 
      0\)\(\ \)\)\)], "DisplayFormula"],

Cell["\<\
eliminating quantifiers from any complex polynomial system can be \
reduced to a finite number of single existential quantifier eliminations from \
systems of the form\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\[Exists] \_y\( f\_1\)(x\_1,  ... , x\_n, 
                y) \[Equal] 0\)\(\[And]\)\) ... \) \[And] \(f\_k\)(
          x\_1,  ... , x\_n, y) \[Equal] 0 \[And] \ 
      g(x\_1,  ... , x\_n, y) \[NotEqual] 0\)], "NumberedEquation",
  CellTags->"ComplQuantElim1"],

Cell[TextData[{
  "To eliminate the quantifier from (",
  ButtonBox["6",
    ButtonData:>"ComplQuantElim1",
    ButtonStyle->"Hyperlink"],
  "), ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " first computes the Gr\[ODoubleDot]bner basis of equations"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox["G",
          FontSlant->"Italic"], "=", 
        RowBox[{
          StyleBox["GroebnerBasis",
            "MR"], "[", \({f\_1,  ... , f\_k}, \ {x\_1,  ... , x\_n, y}\), 
          "]"}]}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "with a monomial order that makes monomials containing ",
  StyleBox["y",
    FontSlant->"Italic"],
  " greater than monomials not containing ",
  StyleBox["y. ",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "The monomial order used is ",
  StyleBox[ButtonBox["EliminationOrder",
    ButtonData:>"ElimOrder",
    ButtonStyle->"Hyperlink"], "MR"],
  ", with {y} specified as the elimination variable list, and with ",
  ButtonBox["all basis polynomials kept",
    ButtonData:>"GBElim",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text"],

Cell[TextData[{
  "If ",
  StyleBox["G",
    FontSlant->"Italic"],
  " contains no polynomials that depend on ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", then a quantifier-free system equivalent to (",
  ButtonBox["6",
    ButtonData:>"ComplQuantElim1",
    ButtonStyle->"Hyperlink"],
  ") can be obtained by equating all elements of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " to zero, and asserting that at least one coefficient of ",
  StyleBox["g",
    FontSlant->"Italic"],
  " as a polynomial in ",
  StyleBox["y",
    FontSlant->"Italic"],
  " is not equal to zero. Otherwise let ",
  StyleBox["h",
    FontSlant->"Italic"],
  " be the element of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " with the lowest positive degree ",
  StyleBox["d",
    FontSlant->"Italic"],
  " in ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", let ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["c",
            FontSlant->"Italic"], "(", \(x\_1,  ... , x\_n\), ")"}], 
        TraditionalForm]]],
  " be the leading coefficient of ",
  StyleBox["h",
    FontSlant->"Italic"],
  " in ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and let ",
  Cell[BoxData[
      \(TraditionalForm\`{h\_1,  ... , \ h\_s}\)]],
  " be all elements of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " that do not depend on ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". Now (",
  ButtonBox["6",
    ButtonData:>"ComplQuantElim1",
    ButtonStyle->"Hyperlink"],
  ") can be split into a disjunction of two systems"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"  ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{\(\[Exists] \_y\), 
                RowBox[{
                  RowBox[{
                    StyleBox["c",
                      FontSlant->"Italic"], \((x\_1,  ... , x\_n)\)}], 
                  "\[Equal]", "0"}]}], 
              "\[And]", \(\(f\_1\)(x\_1,  ... , x\_n, y) \[Equal] 0\), 
              "\[And]"}], "..."}], 
          "\[And]", \(\(f\_k\)(x\_1,  ... , x\_n, y) \[Equal] 0\), "\[And]", 
          " ", \(g(x\_1,  ... , x\_n, y) \[NotEqual] 0\)}]}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"ComplQuantElim2"],

Cell["and", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(\[Exists] \_y\), 
              RowBox[{
                RowBox[{
                  StyleBox["c",
                    FontSlant->"Italic"], "(", \(x\_1,  ... , x\_n\), ")"}], 
                "\[NotEqual]", " ", "0"}]}], "\[And]", 
            " ", \(\(f\_1\)(x\_1,  ... , x\_n, y) \[Equal] 0\), "\[And]"}], 
          "..."}], "\[And]", \(\(f\_k\)(x\_1,  ... , x\_n, y) \[Equal] 0\), 
        "\[And]", 
        " ", \(\(g(x\_1,  ... , x\_n, y)\)\(\[NotEqual]\)\(0\)\(\ \)\)}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"ComplQuantElim3"],

Cell[TextData[{
  "To eliminate the quantifier from (",
  ButtonBox["7",
    ButtonData:>"ComplQuantElim2",
    ButtonStyle->"Hyperlink"],
  "), the quantifier elimination procedure is called recursively. Since the \
ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`{c, f\_1,  ... , \ f\_k}\)]],
  " strictly contains the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`{f\_1,  ... , \ f\_k}\)]],
  ", the Noetherian property of polynomial rings guarantees finiteness of the \
recursion."
}], "Text"],

Cell[TextData[{
  "If ",
  StyleBox["c",
    FontSlant->"Italic"],
  " belongs to the radical of the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`{f\_1,  ... , \ f\_k}\)]],
  ", which is exactly when 1 belongs to"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox["GroebnerBasis",
          "MR"], 
        "[", \({h\_1,  ... , h\_s, 1 - c\ z}, \ {x\_1,  ... , x\_n, \ z}\), 
        "]"}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
  "(",
  ButtonBox["8",
    ButtonData:>"ComplQuantElim3",
    ButtonStyle->"Hyperlink"],
  ") is equivalent to ",
  StyleBox["False", "MR"],
  ". Otherwise let"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`r = \(\(\(\(\(r\_\(d - 1\)\)(x\_1,  ... , x\_n)\) 
                y\^\(d - 1\)\)\(+\)\) ... \) + \(r\_0\)(x\_1,  ... , 
            x\_n) \[Equal] \ \(\(c(x\_1,  ... , 
                  x\_n)\)\^e\) \(g(x\_1,  ... , x\_n, y)\)\^d - \(q(
              x\_1,  ... , x\_n, y)\)\ \(h(x\_1,  ... , x\_n, 
              y)\)\)], "DisplayFormula"],

Cell[TextData[{
  "be the pseudoremainder of the division of ",
  Cell[BoxData[
      \(TraditionalForm\`g\^d\)]],
  " by ",
  StyleBox["h",
    FontSlant->"Italic"],
  " as polynomials in ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". Then (",
  ButtonBox["8",
    ButtonData:>"ComplQuantElim3",
    ButtonStyle->"Hyperlink"],
  ") is equivalent to the quantifier-free system"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["c",
                  FontSlant->"Italic"], "(", \(x\_1,  ... , x\_n\), ")"}], 
              "\[NotEqual]", " ", "0"}], "\[And]", 
            " ", \(\(h\_1\)(x\_1,  ... , x\_n) \[Equal] 0\), "\[And]"}], 
          "..."}], "\[And]", \(\(h\_s\)(x\_1,  ... , x\_n) \[Equal] 0\), 
        "\[And]", \((\(\(\(\(r\_\(d - 1\)\)(x\_1,  ... , x\_n) \[NotEqual] 
                  0\)\(\ \)\(\[Or]\)\) ... \) \[Or] \(r\_0\)(x\_1,  ... , 
                x\_n) \[NotEqual] 0)\)}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"ComplQuantElim4"],

Cell[TextData[{
  "To show that (",
  ButtonBox["8",
    ButtonData:>"ComplQuantElim3",
    ButtonStyle->"Hyperlink"],
  ") implies (",
  ButtonBox["9",
    ButtonData:>"ComplQuantElim4",
    ButtonStyle->"Hyperlink"],
  "), suppose that ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\_1,  ... , \ a\_n)\)\)]],
  " satisfies (",
  ButtonBox["8",
    ButtonData:>"ComplQuantElim3",
    ButtonStyle->"Hyperlink"],
  "). Then ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["c",
              FontSlant->"Italic"], "(", \(a\_1,  ... , a\_n\), ")"}], 
          "\[NotEqual]", " ", "0"}], TraditionalForm]]],
  " and there exists ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", such that"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(\(\(\(\(f\_1\)(a\_1,  ... , a\_n, 
              b) \[Equal] 0\)\(\[And]\)\) ... \) \[And] \(f\_k\)(a\_1,  ... , 
          a\_n, b) \[Equal] 
        0 \[And] \ \(\(g(a\_1,  ... , a\_n, 
          b)\)\(\[NotEqual]\)\(0\)\(\ \)\)\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`{h\_1,  ... , \ h\_s}\)]],
  " and ",
  StyleBox["h",
    FontSlant->"Italic"],
  " belong to the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`{f\_1,  ... , \ f\_k}\)]],
  ","
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(h\_1\)(a\_1,  ... , a\_n) \[Equal] 
            0\)\(\[And]\)\) ... \) \[And] \(h\_s\)(a\_1,  ... , 
          a\_n) \[Equal] 0\)], "DisplayFormula"],

Cell[TextData[{
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`h(a\_1,  ... , a\_n, b) \[Equal] 0\)]],
  ". Hence"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(r(a\_1,  ... , a\_n, 
              b) \[Equal] \ \(\(\(\(r\_\(d - 1\)\)(a\_1,  ... , a\_n)\) 
                b\^\(d - 1\)\)\(+\)\) ... \) + \(r\_0\)(a\_1,  ... , 
          a\_n) \[Equal] \ \(\(c(a\_1,  ... , 
              a\_n)\)\^e\) \(g(a\_1,  ... , a\_n, b)\)\^d \[NotEqual] \ 
      0\)], "DisplayFormula"],

Cell["which implies that", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(r\_\(d - 1\)\)(a\_1,  ... , a\_n) \[NotEqual] 
            0\)\(\ \)\(\[Or]\)\) ... \) \[Or] \(r\_0\)(a\_1,  ... , 
          a\_n) \[NotEqual] 0\)], "DisplayFormula"],

Cell[TextData[{
  "To show that (",
  ButtonBox["9",
    ButtonData:>"ComplQuantElim4",
    ButtonStyle->"Hyperlink"],
  ") implies (",
  ButtonBox["8",
    ButtonData:>"ComplQuantElim3",
    ButtonStyle->"Hyperlink"],
  "), suppose that ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\_1,  ... , \ a\_n)\)\)]],
  " satisfies (",
  ButtonBox["9",
    ButtonData:>"ComplQuantElim4",
    ButtonStyle->"Hyperlink"],
  "). Then"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(r(a\_1,  ... , a\_n, 
              y) \[Equal] \ \(\(\(\(r\_\(d - 1\)\)(a\_1,  ... , a\_n)\) 
                y\^\(d - 1\)\)\(+\)\) ... \) + \(r\_0\)(a\_1,  ... , 
          a\_n) \[Equal] \ \(\(c(a\_1,  ... , 
                a\_n)\)\^e\) \(g(a\_1,  ... , a\_n, y)\)\^d - \(q(
            a\_1,  ... , a\_n, y)\)\ \(h(a\_1,  ... , a\_n, 
            y)\)\)], "DisplayFormula"],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`h(a\_1,  ... , a\_n, y)\)]],
  " is a polynomial of degree ",
  StyleBox["d",
    FontSlant->"Italic"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`r(a\_1,  ... , a\_n, y)\)]],
  " is a nonzero polynomial of degree less than ",
  StyleBox["d",
    FontSlant->"Italic"],
  ", there is a root ",
  StyleBox["b",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`h(a\_1,  ... , a\_n, y)\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`\((y - b)\)\^m\)]],
  " divides ",
  Cell[BoxData[
      \(TraditionalForm\`h(a\_1,  ... , a\_n, y)\)]],
  " but not ",
  Cell[BoxData[
      \(TraditionalForm\`r(a\_1,  ... , a\_n, y)\)]],
  " for some ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] m \[LessEqual] d\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`g(a\_1,  ... , a\_n, b)\)]],
  " was zero, then ",
  Cell[BoxData[
      \(TraditionalForm\`\((y - b)\)\^m\)]],
  " would divide ",
  Cell[BoxData[
      \(TraditionalForm\`\(g(a\_1,  ... , a\_n, y)\)\^d\)]],
  ", which is impossible because it would imply that ",
  Cell[BoxData[
      \(TraditionalForm\`\((y - b)\)\^m\)]],
  " divides ",
  Cell[BoxData[
      \(TraditionalForm\`r(a\_1,  ... , a\_n, y)\)]],
  ". Therefore ",
  Cell[BoxData[
      \(TraditionalForm\`g(a\_1,  ... , a\_n, b) \[NotEqual] 0\)]],
  ". ",
  ButtonBox["Property 4",
    ButtonData:>"GBProperty4",
    ButtonStyle->"Hyperlink"],
  " shows that ",
  Cell[BoxData[
      \(TraditionalForm\`p(a\_1,  ... , a\_n, b) \[Equal] \ 0\)]],
  " for any polynomial ",
  StyleBox["p ",
    FontSlant->"Italic"],
  "\[Element]",
  StyleBox[" G",
    FontSlant->"Italic"],
  ". Since ",
  StyleBox["G",
    FontSlant->"Italic"],
  " is a Gr\[ODoubleDot]bner basis of the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`{f\_1,  ... , \ f\_k}\)]],
  ","
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(\(\(\(\(f\_1\)(a\_1,  ... , a\_n, 
              b) \[Equal] 0\)\(\[And]\)\) ... \) \[And] \(f\_k\)(a\_1,  ... , 
          a\_n, b) \[Equal] 0\)\)\)], "DisplayFormula"],

Cell["\<\
which completes the proof of correctness of the quantifier \
elimination algorithm.\
\>", "Text"],

Cell[TextData[{
  "This eliminates the quantifier from ",
  Cell[BoxData[
      \(TraditionalForm\`\[Exists] \_y x\_1\%2 + x\_2\%2 + y\^2 == 1 \[And] 
        x\_1 + x\_2 == y\)]],
  ". Here ",
  Cell[BoxData[
      \(TraditionalForm\`g = 1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`h = \(-y\) + x\_1 + x\_2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`c = \(-1\)\)]],
  ". Since ",
  StyleBox["c",
    FontSlant->"Italic"],
  " is a nonzero constant, (",
  ButtonBox["7",
    ButtonData:>"ComplQuantElim2",
    ButtonStyle->"Hyperlink"],
  ") is ",
  Cell[BoxData[
      \(TraditionalForm\`False\)]],
  " and the equivalent quantifier-free system is given by (",
  ButtonBox["9",
    ButtonData:>"ComplQuantElim4",
    ButtonStyle->"Hyperlink"],
  "). Since ",
  StyleBox["g",
    FontSlant->"Italic"],
  " is a nonzero constant, (",
  ButtonBox["9",
    ButtonData:>"ComplQuantElim4",
    ButtonStyle->"Hyperlink"],
  ") becomes ",
  Cell[BoxData[
      \(TraditionalForm\`1 - 2\ x\_1\%2 - 2\ x\_1\ x\_2 - 2\ x\_2\%2 \[Equal] 
        0\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Developer`SetSystemOptions["\<GroebnerBasisOptions\>" \[Rule] \
{"\<EliminateFromGroebnerBasis\>" \[Rule] False}]; \), "\n", 
    \(GroebnerBasis[{x\_1\%2 + x\_2\%2 + y\^2 - 1, x\_1 + x\_2 - y}, {x\_1, 
        x\_2}, {y}, MonomialOrder \[Rule] EliminationOrder]\)}], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \({1 - 2\ x\_1\%2 - 2\ x\_1\ x\_2 - 2\ x\_2\%2, \(-y\) + x\_1 + 
        x\_2}\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["This resets the system option to its default value.", "MathCaption"],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<GroebnerBasisOptions\>" \[Rule] \
{"\<EliminateFromGroebnerBasis\>" \[Rule] True}]; \)], "Input",
  CellLabel->"In[15]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Arbitrary Complex Polynomial Systems", "Section"],

Cell[CellGroupData[{

Cell["FindInstance", "Subsection"],

Cell[TextData[{
  StyleBox["FindInstance", "MR"],
  " can handle arbitrary complex polynomial systems giving instances of \
complex solutions, or an empty list for systems that have no solutions. If \
the number of instances requested is more than one, the instances are \
randomly generated from the full solution of the system given by ",
  StyleBox["Reduce", "MR"],
  ". If one instance is requested, a faster algorithm that produces one \
instance is used. Here is a description of the algorithm used to find a \
single instance, or prove that a system has no solutions."
}], "Text"],

Cell[TextData[{
  "If the system contains general quantifiers (\[ForAll]), the ",
  ButtonBox["quantifier elimination",
    ButtonData:>"ComplexQuantifierElimination",
    ButtonStyle->"Hyperlink"],
  " algorithm is used to eliminate the innermost quantifiers until the system \
contains only existential quantifiers (\[Exists]) or is quantifier-free. Note \
that"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\[Exists] \_\(x\_1\)\[Exists] \_\(x\_2\) ... \) \(\
\[Exists] \_\(x\_n\)\[CapitalPhi](x\_1,  ... , x\_n, y\_1,  ... , \ 
          y\_m)\)\)], "NumberedEquation",
  CellTags->"ComplFI1"],

Cell[TextData[{
  "has solutions if and only if ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[CapitalPhi](x\_1,  ... , x\_n, 
        y\_1,  ... , \ y\_m)\)\)\)]],
  " has solutions, and if ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\_1,  ... , a\_n, b\_1,  ... , b\_m)\)\)]],
  " is a solution of ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n, y\_1,  ... , \ 
        y\_m)\)]],
  " then ",
  Cell[BoxData[
      \(TraditionalForm\`\((b\_1,  ... , b\_m)\)\)]],
  " is a solution of (",
  ButtonBox["10",
    ButtonData:>"ComplFI1",
    ButtonStyle->"Hyperlink"],
  "). Hence to find instances of solutions of systems containing only \
existential quantifiers it is enough to be able to find instances of ",
  "quantifier-free",
  " systems. Moreover, ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\_1,  ... , a\_n)\)\)]],
  " is a solution of"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(\[CapitalPhi]\_1\)(x\_1,  ... , 
            x\_n)\)\(\[Or]\)\) ... \) \[Or] \(\[CapitalPhi]\_m\)(x\_1,  ... , 
        x\_n)\)], "DisplayFormula"],

Cell[TextData[{
  "if and only if it is a solution of one of the ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_i\)(x\_1,  ... , x\_n)\)]],
  ", with ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] m\)]],
  ", so it is enough to show how to find instances of solutions of"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(f\_1\)(x\_1,  ... , x\_n) \[Equal] 
            0\)\(\[And]\)\) ... \) \[And] \(f\_k\)(x\_1,  ... , 
          x\_n) \[Equal] 0 \[And] \ 
      g(x\_1,  ... , x\_n) \[NotEqual] 0\)], "NumberedEquation",
  CellTags->"ComplFI2"],

Cell[TextData[{
  "First compute the ",
  StyleBox["GroebnerBasis", "MR"],
  " ",
  StyleBox["G",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`{f\_1,  ... , f\_k, 1 - g\ z}\)]],
  " with ",
  StyleBox["MonomialOrder->EliminationOrder", "MR"],
  ", eliminating the polynomials that depend on ",
  StyleBox["z",
    FontSlant->"Italic"],
  " (if there is no inequation condition, ",
  StyleBox["G",
    FontSlant->"Italic"],
  " is the ",
  StyleBox["GroebnerBasis", "MR"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`{f\_1,  ... , f\_k}\)]],
  " with  ",
  StyleBox["MonomialOrder->DegreeReverseLexicographic", "MR"],
  "). If ",
  StyleBox["G",
    FontSlant->"Italic"],
  " contains 1, there are no solutions. Otherwise, compute a subset ",
  StyleBox["S",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`{x\_1,  ... , x\_n}\)]],
  " of the highest cardinality among subsets strongly independent modulo the \
ideal generated by ",
  StyleBox["G",
    FontSlant->"Italic"],
  " with respect to the degree reverse lexicographic order (see [",
  ButtonBox["1",
    ButtonData:>"BW",
    ButtonStyle->"Hyperlink"],
  "], Section 9.3). Reorder ",
  Cell[BoxData[
      \(TraditionalForm\`{x\_1,  ... , x\_n}\)]],
  " so that ",
  Cell[BoxData[
      \(TraditionalForm\`S \[Equal] {x\_\(n - d + 1\),  ... , x\_n}\)]],
  ", and compute the lexicographic order ",
  StyleBox["GroebnerBasis", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " of the ideal generated by ",
  StyleBox["G",
    FontSlant->"Italic"],
  ". To compute ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the ",
  ButtonBox["Gr\[ODoubleDot]bner walk ",
    ButtonData:>"GBWalk",
    ButtonStyle->"Hyperlink"],
  "algorithm."
}], "Text"],

Cell[TextData[{
  "For each of the variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] n - d\)]],
  ", select the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i \[Element] H\)]],
  " with the smallest leading monomial among elements of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " that depend on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " and not on ",
  Cell[BoxData[
      \(TraditionalForm\`{x\_1,  ... , x\_\(i - 1\)}\)]],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " be the leading coefficient of ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  " as a polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " depends on a variable that is not in ",
  StyleBox["S,",
    FontSlant->"Italic"],
  " replace ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " with the lexicographic order Gr\[ODoubleDot]bner basis of the ideal \
generated by ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  ". The following shows that this operation keeps ",
  StyleBox["S",
    FontSlant->"Italic"],
  " strongly independent modulo the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". Hence, possibly after a finite (by the Noetherian property of polynomial \
rings) number of extensions of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", the leading coefficient ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  " depends only on ",
  Cell[BoxData[
      \(TraditionalForm\`{x\_\(n - d + 1\),  ... , x\_n}\)]],
  ", for all ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] n - d\)]],
  ". For the set of polynomials ",
  StyleBox["P, ",
    FontSlant->"Italic"],
  "let ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["P",
    FontSlant->"Italic"],
  ")",
  " be the set of common zeros of elements of ",
  StyleBox["P. ",
    FontSlant->"Italic"],
  "Both ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["G",
    FontSlant->"Italic"],
  ")",
  " and ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["H",
    FontSlant->"Italic"],
  ")",
  " have dimension ",
  StyleBox["d",
    FontSlant->"Italic"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`Z(H) \[Subset] Z(G)\)]],
  ", hence any ",
  StyleBox["d",
    FontSlant->"Italic"],
  "-dimensional irreducible component of ",
  StyleBox["Z(H)",
    FontSlant->"Italic"],
  " is also a component of ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["G",
    FontSlant->"Italic"],
  ")",
  ". Since ",
  StyleBox["g",
    FontSlant->"Italic"],
  " does not vanish on any irreducible component of ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["G",
    FontSlant->"Italic"],
  ")",
  ", it does not vanish on any ",
  StyleBox["d",
    FontSlant->"Italic"],
  "-dimensional irreducible component of ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["H",
    FontSlant->"Italic"],
  ")",
  StyleBox[". ",
    FontSlant->"Italic"],
  "Therefore, the Gr\[ODoubleDot]bner basis of ",
  StyleBox["H",
    FontSlant->"Italic"],
  " and ",
  StyleBox["g",
    FontSlant->"Italic"],
  " contains a polynomial ",
  StyleBox["t",
    FontSlant->"Italic"],
  " depending only on ",
  Cell[BoxData[
      \(TraditionalForm\`{x\_\(n - d + 1\),  ... , x\_n}\)]],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`p = \(t\ c\_1 ... \) c\_\(n - d\)\)]],
  ". To find a solution of (",
  ButtonBox["11",
    ButtonData:>"ComplFI2",
    ButtonStyle->"Hyperlink"],
  "), pick its last ",
  StyleBox["d",
    FontSlant->"Italic"],
  " coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`{a\_\(n - d + 1\),  ... , a\_n}\)]],
  " so that ",
  Cell[BoxData[
      \(TraditionalForm\`p(a\_\(n - d + 1\),  ... , a\_n) \[NotEqual] 0\)]],
  ". For all ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] n - d\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(c\_i\)(a\_\(n - d + 1\),  ... , a\_n) \[NotEqual] 
        0\)]],
  ", and so by ",
  ButtonBox["Property 4",
    ButtonData:>"GBProperty4",
    ButtonStyle->"Hyperlink"],
  " if ",
  Cell[BoxData[
      \(TraditionalForm\`a\_i\)]],
  ", for ",
  Cell[BoxData[
      \(TraditionalForm\`i = n - d,  ... , \ 1\)]],
  ", is chosen to be the first root of ",
  Cell[BoxData[
      \(TraditionalForm\`\(h\_i\)(x\_i, a\_\(i + 1\),  ... , \ a\_n)\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\_1,  ... , a\_n)\) \[Element] Z(H) \[Subset] 
        Z(G)\)]],
  ". Moreover, ",
  Cell[BoxData[
      \(TraditionalForm\`g(a\_1,  ... , a\_n) \[NotEqual] 0\)]],
  ", because otherwise ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\_1,  ... , a\_n)\)\)]],
  " would belong to ",
  Cell[BoxData[
      \(TraditionalForm\`Z(H \[Union] {g})\)]],
  ", which would imply that ",
  Cell[BoxData[
      \(TraditionalForm\`t(a\_\(n - d + 1\),  ... , a\_n) \[Equal] \ 0\)]],
  ", which is impossible since ",
  StyleBox["t",
    FontSlant->"Italic"],
  " divides ",
  StyleBox["p",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "To prove the correctness of the aforementioned algorithm, it must be shown \
that extending ",
  StyleBox["H",
    FontSlant->"Italic"],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " that depend on a variable not in ",
  StyleBox["S",
    FontSlant->"Italic"],
  " preserves strong independence of ",
  StyleBox["S",
    FontSlant->"Italic"],
  " modulo the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". Suppose for some ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] n - d\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " depends on a variable, which is not in ",
  StyleBox["S",
    FontSlant->"Italic"],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`I\_\(i + 1\) \[Subset] \[DoubleStruckCapitalC][
          x\_\(i + 1\),  ... , \ x\_n]\)]],
  " denote the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`H \[Intersection] \[DoubleStruckCapitalC][
          x\_\(i + 1\),  ... , \ x\_n]\)]],
  ", and let ",
  Cell[BoxData[
      \(TraditionalForm\`J\_\(i + 1\) \[Subset] \[DoubleStruckCapitalC][
          x\_\(i + 1\),  ... , \ x\_n]\)]],
  " denote the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`I\_\(i + 1\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  ". Then ",
  Cell[BoxData[
      \(TraditionalForm\`J\_\(i + 1\)\)]],
  " does not contain nonzero elements of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC][x\_\(n - d + 1\),  ... , \ 
        x\_n]\)]],
  ". To prove this, suppose that ",
  Cell[BoxData[
      \(TraditionalForm\`r \[Equal] p\ c\_i + q \[Element] 
        J\_\(i + 1\) \[Intersection] \[DoubleStruckCapitalC][
              x\_\(n - d + 1\),  ... , \ x\_n]\\{0}\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`p \[Element] \[DoubleStruckCapitalC][
          x\_\(i + 1\),  ... , \ x\_n]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q \[Element] I\_\(i + 1\)\)]],
  ". Then ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i \[Equal] \ \(c\_i\) x\_i\^k + t\)]],
  ", with ",
  Cell[BoxData[
      \(TraditionalForm\`\(deg\_\(x\_i\)\)(t) < k\)]],
  ", and"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`p\ h\_i \[Equal] p\ \(c\_i\) x\_i\^k + p\ t \[Equal] 
      r\ x\_i\^k - q\ x\_i\^k + p\ t\)], "DisplayFormula"],

Cell[TextData[{
  "belongs to the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", and so does ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i = \ r\ x\_i\^k + p\ t\)]],
  ". This contradicts the choice of ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  " since the leading monomial of ",
  Cell[BoxData[
      \(TraditionalForm\`g\_i\)]],
  " depends on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " and is strictly smaller than the leading monomial of ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  ". Therefore, the projection of ",
  Cell[BoxData[
      \(TraditionalForm\`Z(J\_\(i + 1\))\)]],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`A\_d = \((\[DoubleStruckCapitalC]\^d)\)\_{x\_\(n - d \
+ 1\),  ... , \ x\_n}\)]],
  " is dense in ",
  Cell[BoxData[
      \(TraditionalForm\`A\_d\)]],
  ", and so, since ",
  Cell[BoxData[
      \(TraditionalForm\`Z(I\_\(i + 1\))\)]],
  " has dimension ",
  StyleBox["d",
    FontSlant->"Italic"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " must be zero on some irreducible component ",
  Cell[BoxData[
      \(TraditionalForm\`C\_\(i + 1\)\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`Z(I\_\(i + 1\))\)]],
  " whose projection on ",
  Cell[BoxData[
      \(TraditionalForm\`A\_d\)]],
  " is dense in ",
  Cell[BoxData[
      \(TraditionalForm\`A\_d\)]],
  ". Since ",
  Cell[BoxData[
      \(TraditionalForm\`Z(I\_\(i + 1\))\)]],
  " is the Zariski closure of the projection of the ",
  StyleBox["d",
    FontSlant->"Italic"],
  "-dimensional set ",
  Cell[BoxData[
      \(TraditionalForm\`Z(H)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`C\_\(i + 1\)\)]],
  " is contained in the Zariski closure of the projection of an irreducible \
component ",
  StyleBox["C ",
    FontSlant->"Italic"],
  "of ",
  StyleBox["Z(H)",
    FontSlant->"Italic"],
  ". ",
  Cell[BoxData[
      \(TraditionalForm\`Z(c\_i) \[Intersection] C\)]],
  " has dimension ",
  StyleBox["d",
    FontSlant->"Italic"],
  ", hence ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " is zero on ",
  StyleBox["C",
    FontSlant->"Italic"],
  ", and the projection of ",
  StyleBox["C",
    FontSlant->"Italic"],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`A\_d\)]],
  " is dense in ",
  Cell[BoxData[
      \(TraditionalForm\`A\_d\)]],
  ", which proves that ",
  StyleBox["S",
    FontSlant->"Italic"],
  " is strongly independent modulo the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Here is an example in which ",
  StyleBox["H ",
    FontSlant->"Italic"],
  "needs to be extended. Here ",
  Cell[BoxData[
      \(TraditionalForm\`S \[Equal] {x\_3}\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`h\_1 \[Equal] \((x\_2 - x\_3)\)\ x\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1 \[Equal] x\_2 - x\_3\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`I\_2 \[Equal]  < \((x\_2 - x\_3)\)\^2\ \((x\_2 - 
              2\ x\_3)\) > \)]],
  ". ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1\)]],
  " is zero on one of the two one-dimensional components of ",
  Cell[BoxData[
      \(TraditionalForm\`I\_2\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{\((x\_2 - x\_3)\)\^2\ \((x\_2 - 2\ x\_3)\), \((x\_2 - 
              x\_3)\)\ x\_1, x\_1\%2 - x\_1}, {x\_1, x\_2, x\_3}]\)], "Input",\

  CellLabel->"In[16]:="],

Cell[BoxData[
    \({x\_2\%3 - 4\ x\_2\%2\ x\_3 + 5\ x\_2\ x\_3\%2 - 2\ x\_3\%3, 
      x\_1\ x\_2 - x\_1\ x\_3, \(-x\_1\) + x\_1\%2}\)], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
  "Extending ",
  StyleBox["H",
    FontSlant->"Italic"],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(c\_1\)\(\ \)\)\)]],
  " results in all ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " depending on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_3\)]],
  " only (in fact even constant) while preserving the strong independence of \
",
  Cell[BoxData[
      \(TraditionalForm\`{x\_3}\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\_2\%3 - 4\ x\_2\%2\ x\_3 + 5\ x\_2\ x\_3\%2 - 
          2\ x\_3\%3, x\_1\ x\_2 - x\_1\ x\_3, \(-x\_1\) + x\_1\%2, 
        x\_2 - x\_3\ }, {x\_1, x\_2, x\_3}]\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    \({x\_2 - x\_3, \(-x\_1\) + x\_1\%2}\)], "Output",
  CellLabel->"Out[17]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce", "Subsection"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can solve arbitrary complex polynomial systems. As the first step, ",
  StyleBox["Reduce", "MR"],
  " uses the ",
  ButtonBox["quantifier elimination",
    ButtonData:>"ComplexQuantifierElimination",
    ButtonStyle->"Hyperlink"],
  " algorithm to eliminate the quantifiers. If the obtained quantifier-free \
system is a disjunction, each term of the disjunction is solved separately, \
and the solution is given as a disjunction of the solutions of the terms. \
Thus, the problem is reduced to solving ",
  "quantifier-free",
  " systems of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(f\_1\)(x\_1,  ... , x\_n) \[Equal] 
            0\)\(\[And]\)\) ... \) \[And] \(f\_k\)(x\_1,  ... , 
          x\_n) \[Equal] 0 \[And] \ 
      g(x\_1,  ... , x\_n) \[NotEqual] 0\)], "NumberedEquation",
  CellTags->"ComplQFReduce1"],

Cell[TextData[{
  "First compute the ",
  StyleBox["GroebnerBasis", "MR"],
  " ",
  StyleBox["G",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`{f\_1,  ... , f\_k, 1 - g\ z}\)]],
  " with variable order ",
  Cell[BoxData[
      \(TraditionalForm\`{z, \ x\_n,  ... , x\_1}\)]],
  " and  ",
  StyleBox["MonomialOrder->Lexicographic", "MR"],
  ", and select the polynomials that do not depend on ",
  StyleBox["z",
    FontSlant->"Italic"],
  ". Then the solution set of  ",
  Cell[BoxData[
      \(TraditionalForm\`G \[Equal] 0 \[And] \ 
        g(x\_1,  ... , x\_n) \[NotEqual] 0\)]],
  " is equal to the solution set of (",
  ButtonBox["12",
    ButtonData:>"ComplQFReduce1",
    ButtonStyle->"Hyperlink"],
  ") and ",
  StyleBox["g",
    FontSlant->"Italic"],
  " does not vanish on any component of the zero set ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["G",
    FontSlant->"Italic"],
  ")",
  StyleBox[" ",
    FontSlant->"Italic"],
  "of ",
  StyleBox["G. ",
    FontSlant->"Italic"],
  "If ",
  StyleBox["G",
    FontSlant->"Italic"],
  " contains 1, (",
  ButtonBox["12",
    ButtonData:>"ComplQFReduce1",
    ButtonStyle->"Hyperlink"],
  ") has no solutions. Otherwise for each ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i \[LessEqual] n\)]],
  ", such that the set ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " of elements of ",
  StyleBox["G",
    FontSlant->"Italic"],
  " depending on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " and not on any ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`j > i\)]],
  " is not empty, select an element ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`G\_i\)]],
  " with the lowest positive degree in ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ". If one of the leading coefficients ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`h\_i\)]],
  " is zero on ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["G",
    FontSlant->"Italic"],
  ")",
  ", that is, it belongs to the radical of the ideal generated by ",
  StyleBox["G",
    FontSlant->"Italic"],
  ",  replace ",
  StyleBox["G",
    FontSlant->"Italic"],
  " by the lexicographic Gr\[ODoubleDot]bner basis of the ideal generated by \
",
  StyleBox["G",
    FontSlant->"Italic"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  ". Now split the system into"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\((c\_\(i\_1\) \[Equal] 0 \[And] 
              G \[Equal] 0 \[And] \ 
              g \[NotEqual] 0)\) \[Or] \((c\_\(i\_2\) \[Equal] 0 \[And] 
              G \[Equal] 0 \[And] \ \(c\_\(i\_1\)\) g \[NotEqual] 
                0)\) \[Or]  ... \) \[Or] \((\(c\_\(i\_s\) \[Equal] 0 \[And] 
                G \[Equal] 0 \[And] c\_\(i\_1\) ... \) 
            c\_\(i\_\(s - 1\)\)\ g \[NotEqual] 
          0)\) \[Or] \((\(G \[Equal] 0 \[And] c\_\(i\_1\) ... \) 
            c\_\(i\_s\)\ g \[NotEqual] 0)\)\)], "NumberedEquation",
  CellTags->"ComplQFReduce2"],

Cell[TextData[{
  "and call the solving procedure recursively on all but the last term of the \
disjunction (",
  ButtonBox["13",
    ButtonData:>"ComplQFReduce2",
    ButtonStyle->"Hyperlink"],
  "). Note that the algebraic set  ",
  Cell[BoxData[
      \(TraditionalForm\`c\_\(i\_j\) \[Equal] 0 \[And] G \[Equal] 0\)]],
  " is strictly contained in ",
  Cell[BoxData[
      \(TraditionalForm\`G \[Equal] 0\)]],
  ", so the recursion is finite. If the product of all the ",
  Cell[BoxData[
      \(TraditionalForm\`c\_i\)]],
  " and ",
  StyleBox["g",
    FontSlant->"Italic"],
  " belongs to the radical of the ideal generated by ",
  StyleBox["G,",
    FontSlant->"Italic"],
  " the last term has no solutions. Otherwise, by ",
  ButtonBox["Property 4",
    ButtonData:>"GBProperty4",
    ButtonStyle->"Hyperlink"],
  ", the solution set of the last term is equal to"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          
          RowBox[{\(\(c\_\(i\_1\)\)(x\_1,  ... , x\_\(i\_1 - 1\)) \[NotEqual] 
              0\), "\[And]", 
            RowBox[{
              StyleBox["Roots",
                "MR"], "[", \(h\_\(i\_1\) \[Equal] 0, x\_\(i\_1\)\), "]"}], 
            "\[And]"}], "..."}], 
        "\[And]", \(\(c\_\(i\_s\)\)(x\_1,  ... , x\_\(i\_s - 1\)) \[NotEqual] 
          0\), "\[And]", 
        RowBox[{
          StyleBox["Roots",
            "MR"], "[", \(h\_\(i\_s\) \[Equal] 0, x\_\(i\_s\)\), "]"}], 
        "\[And]", \(g(x\_1,  ... , x\_n) \[NotEqual] 0\)}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"ComplQFReduce2"],

Cell[TextData[{
  "The conditions ",
  Cell[BoxData[
      \(TraditionalForm\`c\_\(i\_j\) \[NotEqual] 0\)]],
  " guarantee that all the solutions (represented as radicals or ",
  StyleBox["Root", "MR"],
  " objects) given by ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Roots",
            "MR"], "[", \(h\_\(i\_j\) \[Equal] 0, x\_\(i\_j\)\), "]"}], 
        TraditionalForm]]],
  "  are well defined. ",
  StyleBox["Reduce", "MR"],
  " performs several operations in order to simplify the inequation \
conditions returned, like removing multiple factors, removing factors common \
with earlier inequation conditions, reducing modulo the ",
  Cell[BoxData[
      \(TraditionalForm\`h\_\(i\_j\)\)]],
  ", and removing factors that are nonzero on ",
  StyleBox["Z",
    FontSlant->"Italic"],
  "(",
  StyleBox["G",
    FontSlant->"Italic"],
  ")",
  "."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Section"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions for solving complex polynomial systems have a number of options \
that control the way that they operate. This section gives a summary of these \
options."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {Cell["Backsubstitution", "MR"], 
            StyleBox[Cell[TextData[StyleBox["False", "MR"]]],
              "MR"], 
            RowBox[{
            "whether", " ", "the", " ", "solutions", " ", "given", " ", "by", 
              " ", 
              StyleBox["Reduce",
                "MR"], " ", "and", " ", 
              StyleBox["Resolve",
                "MR"], " ", "with", " ", "specified", " ", "variables", " ", 
              "should", " ", "be", " ", "unwound", " ", "by", " ", 
              "backsubstitution"}]},
          {
            StyleBox["Cubics",
              "MR"], 
            StyleBox["False",
              
              "MR"], \(whether\ the\ Cardano\ formulas\ should\ be\ used\ to\ \
express\ solutions\ of\ cubics\)},
          {
            StyleBox["Quartics",
              "MR"], 
            StyleBox["False",
              
              "MR"], \(whether\ the\ Cardano\ formulas\ should\ be\ used\ to\ \
express\ solutions\ of\ quartics\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of ",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Resolve", "MR"],
  " affecting the behavior of complex polynomial systems."
}], "Caption"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["WorkingPrecision",
              "MR"], "\[Infinity]", 
            
            RowBox[{\(the\ working\ precision\ to\ be\ used\ in\ computations\
\), ",", " ", 
              
              RowBox[{\(with\ the\ default\ settings\ of\ system\ options\), 
                ";", " ", 
                RowBox[{
                "the", " ", "value", " ", "of", " ", "working", " ", 
                  "precision", " ", "affects", " ", "only", " ", "calls", " ",
                   "to", " ", 
                  StyleBox["Roots",
                    "MR"]}]}]}]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  "Options of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " affecting the behavior of complex polynomial systems."
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Backsubstitution", "TR"]], "SubsubsectionIcon"],

Cell[TextData[{
  "By default, ",
  StyleBox["Reduce", "MR"],
  " may use variables appearing earlier in the variable list to express \
solutions for variables appearing later in the variable list."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^2 + y\^2 \[Equal] 1 && x\^5 - 3\ x + 7 \[Equal] 0, {x, 
        y}]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \(\((x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 1] || 
          x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 2] || 
          x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 3] || 
          x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 4] || 
          x \[Equal] 
            Root[7 - 3\ #1 + #1\^5 &, 
              5])\) && \((y \[Equal] \(-\@\(1 - x\^2\)\) || 
          y \[Equal] \@\(1 - x\^2\))\)\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["Backsubstitution->True", "MR"],
  ", ",
  StyleBox["Reduce", "MR"],
  " uses backsubstitution to eliminate variables from the right-hand sides of \
the equations."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^2 + y\^2 \[Equal] 1 && x\^5 - 3\ x + 7 \[Equal] 0, {x, y}, 
      Backsubstitution \[Rule] True]\)], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    \(\((x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 1] && 
          y \[Equal] \(-\@\(1 - Root[7 - 3\ #1 + #1\^5 &, 1]\^2\)\))\) || \
\((x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 1] && 
          y \[Equal] \@\(1 - Root[7 - 3\ #1 + #1\^5 &, 1]\^2\))\) || \((x \
\[Equal] Root[7 - 3\ #1 + #1\^5 &, 2] && 
          y \[Equal] \(-\@\(1 - Root[7 - 3\ #1 + #1\^5 &, 2]\^2\)\))\) || \
\((x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 2] && 
          y \[Equal] \@\(1 - Root[7 - 3\ #1 + #1\^5 &, 2]\^2\))\) || \((x \
\[Equal] Root[7 - 3\ #1 + #1\^5 &, 3] && 
          y \[Equal] \(-\@\(1 - Root[7 - 3\ #1 + #1\^5 &, 3]\^2\)\))\) || \
\((x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 3] && 
          y \[Equal] \@\(1 - Root[7 - 3\ #1 + #1\^5 &, 3]\^2\))\) || \((x \
\[Equal] Root[7 - 3\ #1 + #1\^5 &, 4] && 
          y \[Equal] \(-\@\(1 - Root[7 - 3\ #1 + #1\^5 &, 4]\^2\)\))\) || \
\((x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 4] && 
          y \[Equal] \@\(1 - Root[7 - 3\ #1 + #1\^5 &, 4]\^2\))\) || \((x \
\[Equal] Root[7 - 3\ #1 + #1\^5 &, 5] && 
          y \[Equal] \(-\@\(1 - Root[7 - 3\ #1 + #1\^5 &, 5]\^2\)\))\) || \
\((x \[Equal] Root[7 - 3\ #1 + #1\^5 &, 5] && 
          y \[Equal] \@\(1 - Root[7 - 3\ #1 + #1\^5 &, 5]\^2\))\)\)], "Output",\

  CellLabel->"Out[19]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Cubics", "TR",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Quartics", "TR",
    FontWeight->"Bold"]
}], "SubsubsectionIcon"],

Cell[TextData[{
  "By default ",
  StyleBox["Reduce", "MR"],
  " does not use the Cardano formulas for solving cubics or quartics."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 3\ x + 7 \[Equal] 0, \ x]\)], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    \(x \[Equal] Root[7 - 3\ #1 + #1\^3 &, 1] || 
      x \[Equal] Root[7 - 3\ #1 + #1\^3 &, 2] || 
      x \[Equal] Root[7 - 3\ #1 + #1\^3 &, 3]\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell[TextData[{
  "Setting the options ",
  StyleBox["Cubics", "MR"],
  " and ",
  StyleBox["Quartics", "MR"],
  " to ",
  StyleBox["True", "MR"],
  " allows ",
  StyleBox["Reduce", "MR"],
  " to use the Cardano formulas for solving cubics and quartics."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 3\ x + 7 \[Equal] 0, \ x, \ 
      Cubics \[Rule] True]\)], "Input",
  CellLabel->"In[21]:="],

Cell[BoxData[
    \(x \[Equal] \(-\((2\/\(7 - 3\ \@5\))\)\^\(1/3\)\) - \((1\/2\ \((7 - 3\ \
\@5)\))\)\^\(1/3\) || 
      x \[Equal] 
        1\/2\ \((1 + \[ImaginaryI]\ \@3)\)\ \((1\/2\ \((7 - 3\ \
\@5)\))\)\^\(1/3\) + \(1 - \[ImaginaryI]\ \@3\)\/\(2\^\(2/3\)\ \((7 - 3\ \@5)\
\)\^\(1/3\)\) || 
      x \[Equal] 
        1\/2\ \((1 - \[ImaginaryI]\ \@3)\)\ \((1\/2\ \((7 - 3\ \
\@5)\))\)\^\(1/3\) + \(1 + \[ImaginaryI]\ \@3\)\/\(2\^\(2/3\)\ \((7 - 3\ \@5)\
\)\^\(1/3\)\)\)], "Output",
  CellLabel->"Out[21]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["WorkingPrecision", "TR"]], "SubsubsectionIcon"],

Cell[TextData[{
  "With ",
  StyleBox["WorkingPrecision", "MR"],
  " set to a finite number, ",
  StyleBox["Reduce", "MR"],
  " uses numeric methods to find polynomial roots."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 3\ x + 7 \[Equal] 0, \ x, \ 
      WorkingPrecision \[Rule] 20]\)], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    \(x \[Equal] \
\(-2.42598875736162212607641804353295788251`20.01383185703354\) || 
      x \[Equal] 
        1.21299437868081106303820902176647894125`19.761044306700303 - 
          1.18914510810655089078181065598302524433`19.752420372071693\ \
\[ImaginaryI] || 
      x \[Equal] 
        1.21299437868081106303820902176647894125`19.761044306700303 + 
          1.18914510810655089078181065598302524433`19.752420372071693\ \
\[ImaginaryI]\)], "Output",
  CellLabel->"Out[22]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The ReduceOptions group of system options", "Subsection"],

Cell[TextData[{
  "Here are the system options from the ",
  StyleBox["ReduceOptions", "MR"],
  " group that may affect the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for complex polynomial systems. The options can be set with"
}], "Text"],

Cell["\<\
Developer`SetSystemOptions[\"ReduceOptions\"
    \[Rule] {\"option name\"-> value}]\
\>", "Program"],

Cell[TextData[{
  "This sets the option ",
  StyleBox["FinitePrecisionGB", "MR"],
  " to ",
  StyleBox["True", "MR"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<FinitePrecisionGB\>" \[Rule] True}]; \)], "Input",
  CellLabel->"In[23]:="],

Cell[TextData[{
  "This checks the value of ",
  StyleBox["FinitePrecisionGB", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<FinitePrecisionGB\>" /. \(("\<ReduceOptions\>" /. 
          Developer`SystemOptions[])\)\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell[TextData[{
  "This sets the option ",
  StyleBox["FinitePrecisionGB", "MR"],
  " back to the default value ",
  StyleBox["False", "MR"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<FinitePrecisionGB\>" \[Rule] False}]; \)], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {Cell[TextData[StyleBox["\"FinitePrecisionGB\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            RowBox[{
            "whether", " ", "finite", " ", "values", " ", "of", " ", 
              "working", " ", "precision", " ", "should", " ", "be", " ", 
              "used", " ", "in", " ", "calls", " ", "to", " ", 
              StyleBox["GroebnerBasis",
                "MR"]}]},
          {Cell[TextData[StyleBox["\"ReorderVariables\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            RowBox[{"whether", " ", 
              StyleBox["Reduce",
                "MR"], " ", "and", " ", 
              StyleBox["Resolve",
                "MR"], " ", "are", " ", "allowed", " ", "to", " ", "reorder", 
              " ", "the", " ", "specified", " ", "variables"}]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  "The ",
  StyleBox["ReduceOptions",
    FontFamily->"Courier"],
  " group options that affect the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for complex polynomial systems."
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FinitePrecisionGB", "TR"]], "SubsubsectionIcon"],

Cell[TextData[{
  "By default, ",
  StyleBox["Reduce", "MR"],
  " uses ",
  StyleBox["GroebnerBasis", "MR"],
  " with ",
  StyleBox["CoefficientDomain->Automatic", "MR"],
  ". This means that even with ",
  StyleBox["WorkingPrecision", "MR"],
  " set to a finite number ",
  StyleBox["prec",
    FontSlant->"Italic"],
  ", if the input is exact ",
  StyleBox["GroebnerBasis", "MR"],
  " uses exact computations."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SeedRandom[123]; \), "\n", 
    \(f = \[Sum]\+\(i = 0\)\%2\(\[Sum]\+\(j = 0\)\%3 Random[
              Integer, {\(-10\^100\), 10\^100}]\ x\^i\ y\^j\); 
    g = \[Sum]\+\(i = 0\)\%3\(\[Sum]\+\(j = 0\)\%2 Random[
              Integer, {\(-10\^100\), 10\^100}]\ x\^i\ y\^j\); \), "\n", 
    \(Timing[
      a\_1 = Reduce[f \[Equal] 0 && g \[Equal] 0, {x, y}, 
          WorkingPrecision \[Rule] 100, 
          Backsubstitution \[Rule] True]; ]\)}], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    \({5.42`\ Second, Null}\)], "Output",
  CellLabel->"Out[28]="]
}, Open  ]],

Cell[TextData[{
  "Setting the system option ",
  StyleBox["\"FinitePrecisionGB\"-> True", "MR"],
  " makes ",
  StyleBox["Reduce", "MR"],
  " use ",
  StyleBox["GroebnerBasis", "MR"],
  " with ",
  StyleBox["CoefficientDomain -> InexactNumbers[", "MR"],
  StyleBox["prec",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<FinitePrecisionGB\>" \[Rule] True}]; \), "\n", 
    \(Timing[
      a\_2 = Reduce[f \[Equal] 0 && g \[Equal] 0, {x, y}, 
          WorkingPrecision \[Rule] 100, 
          Backsubstitution \[Rule] True]; ]\)}], "Input",
  CellLabel->"In[29]:="],

Cell[BoxData[
    \({0.22999999999999943`\ Second, Null}\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]],

Cell[TextData[{
  "Using finite precision may significantly improve the speed of ",
  StyleBox["GroebnerBasis", "MR"],
  " computations. However, the numeric computations may fail due to loss of \
precision, or give incorrect answers. They usually give less precise results \
than exact ",
  StyleBox["GroebnerBasis", "MR"],
  " computations followed by numeric root finding."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision /@ {a\_1, a\_2}\)], "Input",
  CellLabel->"In[31]:="],

Cell[BoxData[
    \({90.72670198980741`, 48.95331558173478`}\)], "Output",
  CellLabel->"Out[31]="]
}, Open  ]],

Cell["This shows that the results are equal up to their precision.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[{x, y} /. \[InvisibleSpace]{ToRules[a\_1]}] - 
      Sort[{x, y} /. \[InvisibleSpace]{ToRules[a\_2]}]\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \({{0``54.95293735757824 + 0``54.95293735757824\ \[ImaginaryI], 
        0``49.150776223637884 + 
          0``49.456395644483536\ \[ImaginaryI]}, {0``54.95293735757824 + 
          0``54.95293735757824\ \[ImaginaryI], 
        0``49.150776223637884 + 
          0``49.456395644483536\ \[ImaginaryI]}, {0``54.61168826305101, 
        0``49.526597415511226}, {0``57.149241629273554 + 
          0``57.149241629273554\ \[ImaginaryI], 
        0``54.51557342731427 + 
          0``54.573937063807065\ \[ImaginaryI]}, {0``57.149241629273554 + 
          0``57.149241629273554\ \[ImaginaryI], 
        0``54.51557342731427 + 
          0``54.573937063807065\ \[ImaginaryI]}, {0``56.69664158683366 + 
          0``56.69664158683366\ \[ImaginaryI], 
        0``53.362874151177316 + 
          0``53.41627303574739\ \[ImaginaryI]}, {0``56.69664158683366 + 
          0``56.69664158683366\ \[ImaginaryI], 
        0``53.362874151177316 + 
          0``53.41627303574739\ \[ImaginaryI]}, {0``56.856318882539036 + 
          0``56.856318882539036\ \[ImaginaryI], 
        0``53.14953457852088 + 
          0``53.1803397290547\ \[ImaginaryI]}, {0``56.856318882539036 + 
          0``56.856318882539036\ \[ImaginaryI], 
        0``53.14953457852088 + 
          0``53.1803397290547\ \[ImaginaryI]}, {0``57.876445187624896 + 
          0``57.876445187624896\ \[ImaginaryI], 
        0``54.803218288870184 + 
          0``54.86825717430321\ \[ImaginaryI]}, {0``57.876445187624896 + 
          0``57.876445187624896\ \[ImaginaryI], 
        0``54.803218288870184 + 
          0``54.86825717430321\ \[ImaginaryI]}, {0``57.53019114967478 + 
          0``57.53019114967478\ \[ImaginaryI], 
        0``51.91152945791364 + 
          0``51.95129765938371\ \[ImaginaryI]}, {0``57.53019114967478 + 
          0``57.53019114967478\ \[ImaginaryI], 
        0``51.91152945791364 + 
          0``51.95129765938371\ \[ImaginaryI]}}\)], "Output",
  CellLabel->"Out[32]="]
}, Open  ]],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<FinitePrecisionGB\>" \[Rule] False}]; \)], "Input",
  CellLabel->"In[33]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ReorderVariables", "TR"]], "SubsubsectionIcon"],

Cell[TextData[{
  "By default, ",
  StyleBox["Reduce", "MR"],
  " is not allowed to reorder the specified variables. Variables appearing \
earlier in the variable list may be used to express solutions for variables \
appearing later in the variable list, but not vice versa."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      z\^3 + 3\ z - 2\ y + 1 \[Equal] x && z\^2 - 7 \[Equal] y, {x, y, 
        z}]\)], "Input",
  CellLabel->"In[34]:="],

Cell[BoxData[
    \(\((x \[Equal] 21 && 
          y \[Equal] \(-10\) && \((z \[Equal] \(-\[ImaginaryI]\)\ \@3 || 
              z \[Equal] \[ImaginaryI]\ \@3)\))\) || \((x \[Equal] 21 && 
          y \[Equal] \(-3\) && 
          z \[Equal] 
            2)\) || \((\((y \[Equal] 
                Root[699 + 2\ x - x\^2 + 244\ #1 - 4\ x\ #1 + 
                      23\ #1\^2 + #1\^3 &, 1] || 
              y \[Equal] 
                Root[699 + 2\ x - x\^2 + 244\ #1 - 4\ x\ #1 + 
                      23\ #1\^2 + #1\^3 &, 2] || 
              y \[Equal] 
                Root[699 + 2\ x - x\^2 + 244\ #1 - 4\ x\ #1 + 
                      23\ #1\^2 + #1\^3 &, 3])\) && \(-21\) + x \[NotEqual] 
            0 && z \[Equal] \(72 - 2\ x + 13\ y + y\^2\)\/\(\(-21\) + \
x\))\)\)], "Output",
  CellLabel->"Out[34]="]
}, Open  ]],

Cell[TextData[{
  "Setting the system option ",
  StyleBox["\"ReorderVariables\"->True", "MR"],
  " allows ",
  StyleBox["Reduce", "MR"],
  " to pick a variable order that makes the equations easier to solve."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ReorderVariables\>" \[Rule] True}]; 
    Reduce[z\^3 + 3\ z - 2\ y + 1 \[Equal] x && z\^2 - 7 \[Equal] y, {x, y, 
        z}]\)], "Input",
  CellLabel->"In[35]:="],

Cell[BoxData[
    \(y \[Equal] \(-7\) + z\^2 && 
      x \[Equal] 15 + 3\ z - 2\ z\^2 + z\^3\)], "Output",
  CellLabel->"Out[35]="]
}, Open  ]],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ReorderVariables\>" \[Rule] False}]; \)], "Input",
  CellLabel->"In[36]:="]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Section",
  CellTags->{"t:29", "c:29"}],

Cell[TextData[{
  "[1] T. Becker and V. Weispfenning, ",
  StyleBox["Gr\[ODoubleDot]bner Bases",
    FontSlant->"Italic"],
  ", New York: Springer-Verlag, 1993."
}], "Reference",
  CellTags->"BW"],

Cell[TextData[{
  "[2] D. Cox, J. Little, and D. O'Shea, ",
  StyleBox["Ideals, Varieties, and Algorithms",
    FontSlant->"Italic"],
  ", New York: Springer-Verlag, 1996."
}], "Reference",
  CellTags->"CLS"],

Cell[TextData[{
  "[3] S. \[CapitalLSlash]ojasiewicz, ",
  StyleBox["Introduction to Complex Analytic Geometry",
    FontSlant->"Italic"],
  ", Springer-Verlag, 1991."
}], "Reference",
  CellTags->"L"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Brackets",
WindowSize->{650, 550},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Complex Polynomial Systems",
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "t:1"->{
    Cell[1776, 53, 73, 1, 88, "Chapter",
      CellTags->{"t:1", "c:1"}]},
  "c:1"->{
    Cell[1776, 53, 73, 1, 88, "Chapter",
      CellTags->{"t:1", "c:1"}]},
  "t:3"->{
    Cell[1874, 58, 59, 1, 61, "Section",
      CellTags->{"t:3", "c:3"}]},
  "c:3"->{
    Cell[1874, 58, 59, 1, 61, "Section",
      CellTags->{"t:3", "c:3"}]},
  "Complex1"->{
    Cell[4748, 149, 255, 5, 31, "NumberedEquation",
      CellTags->"Complex1"]},
  "PNF"->{
    Cell[5457, 175, 217, 4, 30, "NumberedEquation",
      CellTags->"PNF"]},
  "DNF"->{
    Cell[6141, 200, 327, 6, 30, "NumberedEquation",
      CellTags->"DNF"]},
  "GeneralComplexSolution"->{
    Cell[7503, 244, 615, 11, 43, "NumberedEquation",
      CellTags->"GeneralComplexSolution"]},
  "GBProperty1"->{
    Cell[25306, 918, 531, 21, 46, "Theorem",
      CellTags->"GBProperty1"]},
  "GBProperty2"->{
    Cell[25907, 943, 1106, 40, 78, "Theorem",
      CellTags->"GBProperty2"]},
  "GBProperty3"->{
    Cell[38023, 1405, 944, 38, 62, "Theorem",
      CellTags->"GBProperty3"]},
  "GBProperty4"->{
    Cell[42624, 1590, 2127, 81, 92, "Theorem",
      CellTags->"GBProperty4"]},
  "ComplQuantElim5"->{
    Cell[45061, 1689, 256, 4, 29, "NumberedEquation",
      CellTags->"ComplQuantElim5"]},
  "GBWalk"->{
    Cell[52074, 1938, 2047, 51, 92, "DefinitionBox",
      CellTags->"GBWalk"]},
  "ElimOrder"->{
    Cell[59531, 2137, 1257, 39, 56, "DefinitionBox",
      CellTags->"ElimOrder"]},
  "ComplexQuantifierElimination"->{
    Cell[70712, 2508, 85, 1, 35, "Section",
      CellTags->"ComplexQuantifierElimination"]},
  "ComplQuantElim1"->{
    Cell[73494, 2583, 305, 5, 29, "NumberedEquation",
      CellTags->"ComplQuantElim1"]},
  "ComplQuantElim2"->{
    Cell[76477, 2693, 669, 17, 29, "NumberedEquation",
      CellTags->"ComplQuantElim2"]},
  "ComplQuantElim3"->{
    Cell[77171, 2714, 655, 16, 29, "NumberedEquation",
      CellTags->"ComplQuantElim3"]},
  "ComplQuantElim4"->{
    Cell[79801, 2801, 697, 16, 43, "NumberedEquation",
      CellTags->"ComplQuantElim4"]},
  "ComplFI1"->{
    Cell[88856, 3100, 225, 4, 30, "NumberedEquation",
      CellTags->"ComplFI1"]},
  "ComplFI2"->{
    Cell[90512, 3149, 271, 5, 28, "NumberedEquation",
      CellTags->"ComplFI2"]},
  "ComplQFReduce1"->{
    Cell[105601, 3703, 277, 5, 28, "NumberedEquation",
      CellTags->"ComplQFReduce1"]},
  "ComplQFReduce2"->{
    Cell[108465, 3813, 594, 10, 47, "NumberedEquation",
      CellTags->"ComplQFReduce2"],
    Cell[109947, 3853, 701, 18, 46, "NumberedEquation",
      CellTags->"ComplQFReduce2"]},
  "t:29"->{
    Cell[129890, 4489, 59, 1, 35, "Section",
      CellTags->{"t:29", "c:29"}]},
  "c:29"->{
    Cell[129890, 4489, 59, 1, 35, "Section",
      CellTags->{"t:29", "c:29"}]},
  "BW"->{
    Cell[129952, 4492, 196, 6, 24, "Reference",
      CellTags->"BW"]},
  "CLS"->{
    Cell[130151, 4500, 208, 6, 24, "Reference",
      CellTags->"CLS"]},
  "L"->{
    Cell[130362, 4508, 201, 6, 24, "Reference",
      CellTags->"L"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"t:1", 131352, 4539},
  {"c:1", 131438, 4542},
  {"t:3", 131524, 4545},
  {"c:3", 131610, 4548},
  {"Complex1", 131701, 4551},
  {"PNF", 131794, 4554},
  {"DNF", 131882, 4557},
  {"GeneralComplexSolution", 131989, 4560},
  {"GBProperty1", 132105, 4563},
  {"GBProperty2", 132202, 4566},
  {"GBProperty3", 132300, 4569},
  {"GBProperty4", 132398, 4572},
  {"ComplQuantElim5", 132501, 4575},
  {"GBWalk", 132606, 4578},
  {"ElimOrder", 132704, 4581},
  {"ComplexQuantifierElimination", 132824, 4584},
  {"ComplQuantElim1", 132941, 4587},
  {"ComplQuantElim2", 133055, 4590},
  {"ComplQuantElim3", 133170, 4593},
  {"ComplQuantElim4", 133285, 4596},
  {"ComplFI1", 133393, 4599},
  {"ComplFI2", 133493, 4602},
  {"ComplQFReduce1", 133599, 4605},
  {"ComplQFReduce2", 133712, 4608},
  {"t:29", 133907, 4613},
  {"c:29", 134000, 4616},
  {"BW", 134091, 4619},
  {"CLS", 134174, 4622},
  {"L", 134256, 4625}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 73, 1, 88, "Chapter",
  CellTags->{"t:1", "c:1"}],

Cell[CellGroupData[{
Cell[1874, 58, 59, 1, 61, "Section",
  CellTags->{"t:3", "c:3"}],
Cell[1936, 61, 934, 21, 94, "Text"],
Cell[2873, 84, 177, 5, 24, "Text"],
Cell[3053, 91, 219, 3, 28, "DisplayFormula"],
Cell[3275, 96, 66, 0, 22, "Text"],
Cell[3344, 98, 292, 4, 28, "DisplayFormula"],
Cell[3639, 104, 854, 31, 56, "Text"],
Cell[4496, 137, 249, 10, 24, "Text"],
Cell[4748, 149, 255, 5, 31, "NumberedEquation",
  CellTags->"Complex1"],
Cell[5006, 156, 298, 11, 24, "Text"],
Cell[5307, 169, 147, 4, 24, "Text"],
Cell[5457, 175, 217, 4, 30, "NumberedEquation",
  CellTags->"PNF"],
Cell[5677, 181, 278, 9, 22, "Text"],
Cell[5958, 192, 180, 6, 24, "Text"],
Cell[6141, 200, 327, 6, 30, "NumberedEquation",
  CellTags->"DNF"],
Cell[6471, 208, 158, 5, 22, "Text"],
Cell[6632, 215, 361, 10, 51, "Text"],
Cell[6996, 227, 169, 3, 28, "DisplayFormula"],
Cell[7168, 232, 110, 3, 22, "Text"],
Cell[7281, 237, 219, 5, 37, "Text"],
Cell[7503, 244, 615, 11, 43, "NumberedEquation",
  CellTags->"GeneralComplexSolution"],
Cell[8121, 257, 1180, 37, 69, "Text"],
Cell[9304, 296, 147, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[9476, 306, 228, 5, 30, "Input"],
Cell[9707, 313, 588, 11, 92, "Output"]
}, Open  ]],
Cell[10310, 327, 208, 4, 37, "Text"],
Cell[10521, 333, 146, 2, 28, "DisplayFormula"],
Cell[10670, 337, 396, 16, 39, "Text"],
Cell[11069, 355, 168, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[11262, 365, 218, 5, 30, "Input"],
Cell[11483, 372, 467, 7, 61, "Output"]
}, Open  ]],
Cell[11965, 382, 574, 10, 81, "Text"],
Cell[12542, 394, 161, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[12728, 404, 234, 5, 30, "Input"],
Cell[12965, 411, 99, 2, 25, "Output"]
}, Open  ]],
Cell[13079, 416, 403, 13, 40, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[13519, 434, 44, 0, 35, "Section"],

Cell[CellGroupData[{
Cell[13588, 438, 28, 0, 36, "Subsection"],
Cell[13619, 440, 862, 28, 70, "Text"],
Cell[14484, 470, 361, 14, 24, "Text"],
Cell[14848, 486, 860, 32, 40, "Text"],
Cell[15711, 520, 1496, 56, 86, "Text"],
Cell[17210, 578, 365, 17, 24, "Text"],
Cell[17578, 597, 1066, 47, 56, "Text"],
Cell[18647, 646, 959, 40, 56, "Text"],
Cell[19609, 688, 927, 41, 40, "Text"],
Cell[20539, 731, 677, 19, 46, "DisplayFormula"],
Cell[21219, 752, 349, 14, 24, "Text"],
Cell[21571, 768, 2137, 88, 104, "Text"],
Cell[23711, 858, 752, 35, 38, "Text"],
Cell[24466, 895, 837, 21, 82, "Text"],
Cell[25306, 918, 531, 21, 46, "Theorem",
  CellTags->"GBProperty1"],
Cell[25840, 941, 64, 0, 22, "Text"],
Cell[25907, 943, 1106, 40, 78, "Theorem",
  CellTags->"GBProperty2"],
Cell[27016, 985, 6367, 247, 182, "Text"],
Cell[33386, 1234, 855, 26, 28, "DisplayFormula"],
Cell[34244, 1262, 3776, 141, 116, "Text"],
Cell[38023, 1405, 944, 38, 62, "Theorem",
  CellTags->"GBProperty3"],
Cell[38970, 1445, 216, 8, 24, "Text"],
Cell[39189, 1455, 31, 0, 22, "Text"],
Cell[39223, 1457, 228, 4, 35, "DisplayFormula"],
Cell[39454, 1463, 1388, 58, 72, "Text"],
Cell[40845, 1523, 236, 4, 31, "DisplayFormula"],
Cell[41084, 1529, 1418, 54, 72, "Text"],
Cell[42505, 1585, 116, 3, 22, "Text"],
Cell[42624, 1590, 2127, 81, 92, "Theorem",
  CellTags->"GBProperty4"],
Cell[44754, 1673, 304, 14, 24, "Text"],
Cell[45061, 1689, 256, 4, 29, "NumberedEquation",
  CellTags->"ComplQuantElim5"],
Cell[45320, 1695, 884, 42, 40, "Text"],
Cell[46207, 1739, 296, 5, 28, "DisplayFormula"],
Cell[46506, 1746, 665, 24, 40, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47208, 1775, 114, 4, 36, "Subsection"],
Cell[47325, 1781, 367, 11, 39, "Text"],
Cell[47695, 1794, 843, 23, 112, "DefinitionBox3Col"],
Cell[48541, 1819, 126, 3, 15, "Caption"],

Cell[CellGroupData[{
Cell[48692, 1826, 72, 0, 24, "SubsubsectionIcon"],
Cell[48767, 1828, 336, 11, 38, "Text"],
Cell[49106, 1841, 1451, 43, 137, "DefinitionBox"],
Cell[50560, 1886, 104, 4, 15, "Caption"],
Cell[50667, 1892, 709, 25, 55, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[51413, 1922, 61, 0, 20, "SubsubsectionIcon"],
Cell[51477, 1924, 594, 12, 79, "Text"],
Cell[52074, 1938, 2047, 51, 92, "DefinitionBox",
  CellTags->"GBWalk"],
Cell[54124, 1991, 114, 3, 15, "Caption"]
}, Closed]],

Cell[CellGroupData[{
Cell[54275, 1999, 68, 0, 20, "SubsubsectionIcon"],
Cell[54346, 2001, 398, 10, 37, "Text"],
Cell[54747, 2013, 3182, 69, 126, "DefinitionBox"],
Cell[57932, 2084, 36, 0, 15, "Caption"],
Cell[57971, 2086, 367, 8, 52, "Text"],
Cell[58341, 2096, 523, 11, 28, "DisplayFormula"],
Cell[58867, 2109, 476, 18, 39, "Text"],
Cell[59346, 2129, 182, 6, 23, "Text"],
Cell[59531, 2137, 1257, 39, 56, "DefinitionBox",
  CellTags->"ElimOrder"],
Cell[60791, 2178, 66, 0, 15, "Caption"],
Cell[60860, 2180, 711, 20, 84, "Text"],
Cell[61574, 2202, 136, 3, 44, "Program"],
Cell[61713, 2207, 1038, 25, 108, "DefinitionBox3Col"],
Cell[62754, 2234, 104, 4, 15, "Caption"],
Cell[62861, 2240, 522, 14, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[63408, 2258, 237, 4, 49, "Input"],
Cell[63648, 2264, 77, 2, 27, "Output"]
}, Open  ]],
Cell[63740, 2269, 368, 12, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[64133, 2285, 371, 6, 81, "Input"],
Cell[64507, 2293, 127, 3, 27, "Output"]
}, Open  ]],
Cell[64649, 2299, 74, 0, 40, "MathCaption"],
Cell[64726, 2301, 171, 3, 42, "Input"],
Cell[64900, 2306, 220, 7, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[65145, 2317, 242, 5, 30, "Input"],
Cell[65390, 2324, 108, 2, 27, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[65571, 2334, 36, 0, 35, "Section"],
Cell[65610, 2336, 186, 6, 24, "Text"],
Cell[65799, 2344, 167, 2, 30, "DisplayFormula"],
Cell[65969, 2348, 496, 15, 52, "Text"],
Cell[66468, 2365, 152, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[66645, 2372, 253, 4, 50, "Input"],
Cell[66901, 2378, 63, 2, 25, "Output"]
}, Open  ]],
Cell[66979, 2383, 36, 0, 22, "Text"],
Cell[67018, 2385, 546, 9, 43, "DisplayFormula"],
Cell[67567, 2396, 129, 3, 22, "Text"],
Cell[67699, 2401, 325, 5, 30, "DisplayFormula"],
Cell[68027, 2408, 205, 6, 24, "Text"],
Cell[68235, 2416, 245, 4, 28, "DisplayFormula"],
Cell[68483, 2422, 42, 0, 22, "Text"],
Cell[68528, 2424, 222, 6, 28, "DisplayFormula"],
Cell[68753, 2432, 73, 0, 22, "Text"],
Cell[68829, 2434, 176, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[69030, 2443, 137, 3, 30, "Input"],
Cell[69170, 2448, 88, 2, 25, "Output"]
}, Open  ]],
Cell[69273, 2453, 177, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[69475, 2462, 140, 3, 30, "Input"],
Cell[69618, 2467, 62, 2, 25, "Output"]
}, Open  ]],
Cell[69695, 2472, 980, 31, 88, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[70712, 2508, 85, 1, 35, "Section",
  CellTags->"ComplexQuantifierElimination"],
Cell[70800, 2511, 1035, 25, 113, "Text"],
Cell[71838, 2538, 153, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[72016, 2545, 185, 3, 30, "Input"],
Cell[72204, 2550, 195, 4, 27, "Output"]
}, Open  ]],
Cell[72414, 2557, 192, 5, 24, "Text"],
Cell[72609, 2564, 688, 11, 58, "DisplayFormula"],
Cell[73300, 2577, 191, 4, 36, "Text"],
Cell[73494, 2583, 305, 5, 29, "NumberedEquation",
  CellTags->"ComplQuantElim1"],
Cell[73802, 2590, 274, 9, 24, "Text"],
Cell[74079, 2601, 286, 8, 28, "DisplayFormula"],
Cell[74368, 2611, 217, 7, 24, "Text"],
Cell[74588, 2620, 344, 10, 40, "Text"],
Cell[74935, 2632, 1539, 59, 86, "Text"],
Cell[76477, 2693, 669, 17, 29, "NumberedEquation",
  CellTags->"ComplQuantElim2"],
Cell[77149, 2712, 19, 0, 22, "Text"],
Cell[77171, 2714, 655, 16, 29, "NumberedEquation",
  CellTags->"ComplQuantElim3"],
Cell[77829, 2732, 529, 14, 52, "Text"],
Cell[78361, 2748, 243, 8, 24, "Text"],
Cell[78607, 2758, 222, 6, 28, "DisplayFormula"],
Cell[78832, 2766, 189, 8, 24, "Text"],
Cell[79024, 2776, 379, 6, 31, "DisplayFormula"],
Cell[79406, 2784, 392, 15, 38, "Text"],
Cell[79801, 2801, 697, 16, 43, "NumberedEquation",
  CellTags->"ComplQuantElim4"],
Cell[80501, 2819, 743, 28, 38, "Text"],
Cell[81247, 2849, 303, 5, 28, "DisplayFormula"],
Cell[81553, 2856, 274, 11, 24, "Text"],
Cell[81830, 2869, 194, 3, 28, "DisplayFormula"],
Cell[82027, 2874, 130, 5, 22, "Text"],
Cell[82160, 2881, 353, 6, 31, "DisplayFormula"],
Cell[82516, 2889, 34, 0, 22, "Text"],
Cell[82553, 2891, 212, 3, 28, "DisplayFormula"],
Cell[82768, 2896, 437, 17, 24, "Text"],
Cell[83208, 2915, 417, 7, 49, "DisplayFormula"],
Cell[83628, 2924, 1931, 69, 87, "Text"],
Cell[85562, 2995, 216, 3, 28, "DisplayFormula"],
Cell[85781, 3000, 107, 3, 22, "Text"],
Cell[85891, 3005, 1093, 40, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[87009, 3049, 322, 5, 81, "Input"],
Cell[87334, 3056, 135, 3, 27, "Output"]
}, Open  ]],
Cell[87484, 3062, 74, 0, 40, "MathCaption"],
Cell[87561, 3064, 172, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[87770, 3072, 55, 0, 35, "Section"],

Cell[CellGroupData[{
Cell[87850, 3076, 34, 0, 36, "Subsection"],
Cell[87887, 3078, 587, 10, 80, "Text"],
Cell[88477, 3090, 376, 8, 38, "Text"],
Cell[88856, 3100, 225, 4, 30, "NumberedEquation",
  CellTags->"ComplFI1"],
Cell[89084, 3106, 903, 26, 66, "Text"],
Cell[89990, 3134, 192, 3, 28, "DisplayFormula"],
Cell[90185, 3139, 324, 8, 36, "Text"],
Cell[90512, 3149, 271, 5, 28, "NumberedEquation",
  CellTags->"ComplFI2"],
Cell[90786, 3156, 1857, 66, 119, "Text"],
Cell[92646, 3224, 5351, 205, 238, "Text"],
Cell[98000, 3431, 2216, 70, 116, "Text"],
Cell[100219, 3503, 149, 2, 31, "DisplayFormula"],
Cell[100371, 3507, 2621, 100, 117, "Text"],
Cell[102995, 3609, 695, 24, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[103715, 3637, 195, 4, 30, "Input"],
Cell[103913, 3643, 172, 3, 27, "Output"]
}, Open  ]],
Cell[104100, 3649, 452, 18, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[104577, 3671, 234, 4, 48, "Input"],
Cell[104814, 3677, 93, 2, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104956, 3685, 28, 0, 36, "Subsection"],
Cell[104987, 3687, 611, 14, 66, "Text"],
Cell[105601, 3703, 277, 5, 28, "NumberedEquation",
  CellTags->"ComplQFReduce1"],
Cell[105881, 3710, 2581, 101, 134, "Text"],
Cell[108465, 3813, 594, 10, 47, "NumberedEquation",
  CellTags->"ComplQFReduce2"],
Cell[109062, 3825, 882, 26, 74, "Text"],
Cell[109947, 3853, 701, 18, 46, "NumberedEquation",
  CellTags->"ComplQFReduce2"],
Cell[110651, 3873, 889, 28, 77, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[111589, 3907, 26, 0, 35, "Section"],
Cell[111618, 3909, 259, 7, 38, "Text"],
Cell[111880, 3918, 1281, 32, 168, "DefinitionBox3Col"],
Cell[113164, 3952, 174, 6, 15, "Caption"],
Cell[113341, 3960, 880, 21, 108, "DefinitionBox3Col"],
Cell[114224, 3983, 217, 8, 15, "Caption"],

Cell[CellGroupData[{
Cell[114466, 3995, 71, 0, 24, "SubsubsectionIcon"],
Cell[114540, 3997, 217, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[114782, 4006, 142, 4, 30, "Input"],
Cell[114927, 4012, 428, 9, 78, "Output"]
}, Open  ]],
Cell[115370, 4024, 221, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[115616, 4035, 164, 3, 30, "Input"],
Cell[115783, 4040, 1260, 22, 365, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[117092, 4068, 156, 6, 24, "SubsubsectionIcon"],
Cell[117251, 4076, 150, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[117426, 4084, 97, 2, 30, "Input"],
Cell[117526, 4088, 198, 4, 45, "Output"]
}, Open  ]],
Cell[117739, 4095, 273, 10, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[118037, 4109, 127, 3, 30, "Input"],
Cell[118167, 4114, 509, 11, 149, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[118725, 4131, 71, 0, 24, "SubsubsectionIcon"],
Cell[118799, 4133, 194, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[119018, 4143, 135, 3, 30, "Input"],
Cell[119156, 4148, 495, 11, 57, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[119700, 4165, 63, 0, 36, "Subsection"],
Cell[119766, 4167, 326, 10, 38, "Text"],
Cell[120095, 4179, 110, 3, 44, "Program"],
Cell[120208, 4184, 142, 6, 40, "MathCaption"],
Cell[120353, 4192, 156, 3, 42, "Input"],
Cell[120512, 4197, 110, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[120647, 4205, 150, 3, 42, "Input"],
Cell[120800, 4210, 63, 2, 25, "Output"]
}, Open  ]],
Cell[120878, 4215, 166, 6, 40, "MathCaption"],
Cell[121047, 4223, 157, 3, 42, "Input"],
Cell[121207, 4228, 1114, 24, 130, "DefinitionBox3Col"],
Cell[122324, 4254, 293, 11, 15, "Caption"],

Cell[CellGroupData[{
Cell[122642, 4269, 72, 0, 24, "SubsubsectionIcon"],
Cell[122717, 4271, 431, 15, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[123173, 4290, 503, 10, 154, "Input"],
Cell[123679, 4302, 80, 2, 25, "Output"]
}, Open  ]],
Cell[123774, 4307, 347, 13, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[124146, 4324, 326, 7, 74, "Input"],
Cell[124475, 4333, 95, 2, 25, "Output"]
}, Open  ]],
Cell[124585, 4338, 395, 8, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[125005, 4350, 83, 2, 26, "Input"],
Cell[125091, 4354, 99, 2, 25, "Output"]
}, Open  ]],
Cell[125205, 4359, 85, 1, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[125315, 4364, 164, 3, 26, "Input"],
Cell[125482, 4369, 1960, 38, 225, "Output"]
}, Open  ]],
Cell[127457, 4410, 157, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[127651, 4418, 71, 0, 20, "SubsubsectionIcon"],
Cell[127725, 4420, 294, 6, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[128044, 4430, 149, 4, 30, "Input"],
Cell[128196, 4436, 816, 17, 139, "Output"]
}, Open  ]],
Cell[129027, 4456, 228, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[129280, 4466, 244, 5, 62, "Input"],
Cell[129527, 4473, 131, 3, 27, "Output"]
}, Open  ]],
Cell[129673, 4479, 156, 3, 42, "Input"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[129890, 4489, 59, 1, 35, "Section",
  CellTags->{"t:29", "c:29"}],
Cell[129952, 4492, 196, 6, 24, "Reference",
  CellTags->"BW"],
Cell[130151, 4500, 208, 6, 24, "Reference",
  CellTags->"CLS"],
Cell[130362, 4508, 201, 6, 24, "Reference",
  CellTags->"L"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

