(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    140007,       4243]*)
(*NotebookOutlinePosition[    146791,       4458]*)
(*  CellTagsIndexPosition[    145339,       4408]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Diophantine Polynomial Systems", "Chapter",
  CellTags->{"t:1", "c:1"}],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"t:3", "c:3"}],

Cell[TextData[{
  "A ",
  StyleBox["Diophantine polynomial system",
    FontSlant->"Italic"],
  " is an expression constructed with polynomial equations and inequalities"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(f(x\_1,  ... , x\_n) \[Equal] \ 
      g(x\_1,  ... , x\_n), 
    f(x\_1,  ... , x\_n) \[NotEqual] \ 
      g(x\_1,  ... , x\_n), \[IndentingNewLine]f(x\_1,  ... , 
        x\_n) \[GreaterEqual] \ g(x\_1,  ... , x\_n), \ 
    f(x\_1,  ... , x\_n) > \ 
      g(x\_1,  ... , x\_n), \[IndentingNewLine]f(x\_1,  ... , 
        x\_n) \[LessEqual] \ \ g(x\_1,  ... , x\_n), 
    f(x\_1,  ... , x\_n) < \ g(x\_1,  ... , x\_n), \)\)\)], "DisplayFormula"],

Cell["combined using logical connectives and quantifiers", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalPhi]\_1 \[And] \[CapitalPhi]\_2, \ \
\[CapitalPhi]\_1 \[Or] \[CapitalPhi]\_2, \ \[CapitalPhi]\_1 \[Implies] \
\[CapitalPhi]\_2, \[Not] \[CapitalPhi], \[ForAll] \_x \[CapitalPhi], \ 
    and\ \ \(\[Exists] \_x \[CapitalPhi]\), \)], "DisplayFormula"],

Cell["where the variables represent integer quantities.", "Text"],

Cell[TextData[{
  "An occurrence of a variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " inside ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \_x \[CapitalPhi]\ \ or\ \ \(\[Exists] \_x \
\[CapitalPhi]\)\)]],
  " is called a ",
  StyleBox["bound occurrence",
    FontSlant->"Italic"],
  "; any other occurrence of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called a ",
  StyleBox["free occurrence.",
    FontSlant->"Italic"],
  " A variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called a ",
  StyleBox["free variable",
    FontSlant->"Italic"],
  " of a polynomial system if the system contains a free occurrence of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". A Diophantine polynomial system is ",
  StyleBox["quantifier-free",
    FontSlant->"Italic"],
  " if it contains no quantifiers. A ",
  StyleBox["decision problem",
    FontSlant->"Italic"],
  " is a system with all variables existentially quantified, that is, a \
system of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\[Exists] \_\(x\_1\)\[Exists] \_\(x\_2\) ... \) \
\(\[Exists] \_\(x\_n\)\[CapitalPhi](x\_1,  ... , 
          x\_n)\)\)\(,\)\)\)], "NumberedEquation",
  CellTags->"Diophantine1"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  " are all variables in \[CapitalPhi]. The decision problem (",
  ButtonBox["1",
    ButtonData:>"Diophantine1",
    ButtonStyle->"Hyperlink"],
  ") is equivalent to ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ", depending on whether the quantifier-free system of polynomial equations \
and inequalities ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n)\)]],
  " has integer solutions."
}], "Text"],

Cell["An example of a Diophantine polynomial system is", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[ForAll] \_\(n, \ n \[GreaterEqual] 2\)\(\[Exists] \_\
\(p, \ p > 1\)\(\[Exists] \_\(q, \ q > 1\)\(\[ForAll] \_\(a, \ a > 1\)\(\
\[ForAll] \_\(b, \ b > 1\)\ a\ b \[NotEqual] p\)\)\)\) \[And] 
        a\ b \[NotEqual] q \[And] p + q = 
      2 \( \(n\)\(.\)\)\)], "NumberedEquation",
  CellTags->"Diophantine2"],

Cell[TextData[{
  "Goldbach's conjecture [",
  ButtonBox["1",
    ButtonData:>"1",
    ButtonStyle->"Hyperlink"],
  "], formulated in 1742 and still unproven, asserts that system (",
  ButtonBox["2",
    ButtonData:>"Diophantine2",
    ButtonStyle->"Hyperlink"],
  ") is equivalent to ",
  StyleBox["True", "MR"],
  ". This suggests that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " may not be able to solve arbitrary Diophantine polynomial systems. In \
fact, Matiyasevich's solution of Hilbert's tenth problem [",
  ButtonBox["2",
    ButtonData:>"2",
    ButtonStyle->"Hyperlink"],
  "] shows that no algorithm can be constructed that would solve arbitrary \
Diophantine polynomial systems, not even quantifier-free systems or decision \
problems. Nevertheless, ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "functions ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " are able to solve several reasonably large classes of Diophantine \
systems. This notebook describes these classes of systems and methods used by \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to solve them. The methods are presented in the order in which they are \
used."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Linear Systems", "Section"],

Cell[CellGroupData[{

Cell["Systems of Linear Equations", "Subsection",
  CellTags->"LinearEqns"],

Cell[TextData[{
  "Conjunctions of linear Diophantine equations are solvable for an arbitrary \
number of variables. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a method based on the computation Hermite normal form of matrices, \
available in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directly as ",
  ButtonBox["Developer`HermiteNormalForm",
    ButtonStyle->"RefGuideLink"],
  ". The result may contain new unrestricted integer parameters. If the \
equations are independent, the number of parameters is equal to the \
difference between the number of variables and the number of equations."
}], "Text"],

Cell["\<\
This system has four variables and two independent equations, hence \
the result is expressed in terms of two integer parameters.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      3  a + 4  b + 18  c + 24  d \[Equal] 30 && 
        27  a + 16  b + 28  c + 24  d \[Equal] 30, {a, b, c, d}, 
      Integers]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(\((C[1] | C[2])\) \[Element] Integers && a \[Equal] 2 + 8\ C[1] && 
      b \[Equal] 6 - 6\ C[1] + 15\ C[2] && 
      c \[Equal] \(-12\) - 12\ C[1] - 18\ C[2] && 
      d \[Equal] 9 + 9\ C[1] + 11\ C[2]\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frobenius Equations", "Subsection",
  CellTags->"Frobenius"],

Cell[TextData[{
  "A ",
  StyleBox["Frobenius equation",
    FontSlant->"Italic"],
  " is an equation of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(\(\(a\_1\) x\_1\)\(+\)\) ... \) + \(a\_n\) 
          x\_n \[Equal] \ m\)\(,\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1,  ... , \ a\_n\)]],
  " are positive integers, ",
  StyleBox["m",
    FontSlant->"Italic"],
  " is an integer, and the coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , \ x\_n\)]],
  " of solutions are required to be nonnegative integers."
}], "Text"],

Cell[TextData[{
  "For finding solution instances of Frobenius equations ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a fast algorithm based on the computation of the critical tree in \
the Frobenius graph [",
  ButtonBox["11",
    ButtonData:>"11",
    ButtonStyle->"Hyperlink"],
  "]. The algorithm applies when the smallest of  ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1,  ... , \ a\_n\)]],
  " does not exceed the value of the ",
  StyleBox[ButtonBox["MaxFrobeniusGraph",
    ButtonData:>"MaxFrobeniusGraph",
    ButtonStyle->"Hyperlink"], "MR"],
  " system option (the default is 1,000,000). Otherwise the more general ",
  ButtonBox["methods for solving bounded linear systems",
    ButtonData:>"BoundedLinearSystems",
    ButtonStyle->"Hyperlink"],
  " are used. The add-on package ",
  ButtonBox["NumberTheory`Frobenius`",
    ButtonStyle->"AddOnsLink"],
  " provides specialized functionality for solving Frobenius equations and \
computing Frobenius numbers."
}], "Text"],

Cell["This finds a solution of a Frobenius equation.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
      123456\ x + 234567\ y + 345678\ z + 456789\ u + 567890\ v + 678901\ w + 
            789012\ r + 890123\ s + 901234\ t \[Equal] 123456789 && 
        x \[GreaterEqual] 0 && y \[GreaterEqual] 0 && z \[GreaterEqual] 0 && 
        u \[GreaterEqual] 0 && v \[GreaterEqual] 0 && w \[GreaterEqual] 0 && 
        r \[GreaterEqual] 0 && s \[GreaterEqual] 0 && 
        t \[GreaterEqual] 0, {x, y, z, u, v, w, r, s, t}, 
      Integers]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({{x \[Rule] 5, y \[Rule] 8, z \[Rule] 12, u \[Rule] 17, v \[Rule] 24, 
        w \[Rule] 29, r \[Rule] 29, s \[Rule] 29, t \[Rule] 30}}\)], "Output",\

  CellLabel->"Out[2]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bounded Systems of Linear Equations and Inequalities", "Subsection",
  CellTags->"BoundedLinearSystems"],

Cell[TextData[{
  "If a real solution set of a system of linear equations and inequalities is \
a bounded polyhedron, the system has finitely many integer solutions. To find \
the solutions, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the following procedure."
}], "Text"],

Cell[TextData[{
  "We may assume the system has the form ",
  Cell[BoxData[
      \(TraditionalForm\`M\_eq . x \[Equal] b\_eq\  \[And] \ 
        M\_ineq . x \[GreaterEqual] b\_ineq\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`M\_eq\)]],
  " is a  ",
  Cell[BoxData[
      \(TraditionalForm\`k\[Cross]n\)]],
  " integer matrix, ",
  Cell[BoxData[
      \(TraditionalForm\`b\_eq\)]],
  " is a length ",
  Cell[BoxData[
      \(TraditionalForm\`\(k\_\ \)\)]],
  "integer vector, ",
  Cell[BoxData[
      \(TraditionalForm\`M\_ineq\)]],
  "is an ",
  Cell[BoxData[
      \(TraditionalForm\`l\[Cross]n\)]],
  " integer matrix, and  ",
  Cell[BoxData[
      \(TraditionalForm\`b\_ineq\)]],
  " is a length ",
  StyleBox["l",
    FontSlant->"Italic"],
  " integer vector. First, ",
  ButtonBox["the method for solving systems of linear equations",
    ButtonData:>"LinearEqns",
    ButtonStyle->"Hyperlink"],
  " is used to find an integer vector ",
  StyleBox["s",
    FontSlant->"Italic"],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`M\_eq . s \[Equal] b\_eq\)]],
  " and a ",
  Cell[BoxData[
      \(TraditionalForm\`p\[Cross]n\)]],
  " integer matrix ",
  StyleBox["N ",
    FontSlant->"Italic"],
  "whose rows generate the nullspace of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_eq . x \[Equal] 0\)]],
  ". The integer solution set of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_eq . x \[Equal] b\_eq\)]],
  " is equal to ",
  Cell[BoxData[
      \(TraditionalForm\`{s + 
          i . \(N : i \[Element] \[DoubleStruckCapitalZ]\^p\)}\)]],
  ".  Put ",
  Cell[BoxData[
      \(TraditionalForm\`M\_mult = M\_ineq . N\^T\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\_mult = b\_ineq - M\_ineq . s\)]],
  ".  The integer solution set of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_eq . x \[Equal] b\_eq\  \[And] \ 
        M\_ineq . x \[GreaterEqual] b\_ineq\)]],
  " is equal to  ",
  Cell[BoxData[
      \(TraditionalForm\`{s + 
          i . \(N : i \[Element] \[ScriptCapitalI]\)}\)]],
  ", where \[ScriptCapitalI] is the integer solution set of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_mult . i \[GreaterEqual] b\_mult\)]],
  ". To improve efficiency of finding the set \[ScriptCapitalI], ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simplifies ",
  Cell[BoxData[
      \(TraditionalForm\`M\_mult\^T\)]],
  " using ",
  StyleBox["LatticeReduce", "MR"],
  ", obtaining ",
  Cell[BoxData[
      \(TraditionalForm\`M\_red\^T\)]],
  ". Note that if the columns of ",
  Cell[BoxData[
      \(TraditionalForm\`M\_mult\)]],
  " are linearly dependent, ",
  Cell[BoxData[
      \(TraditionalForm\`M\_mult . i \[GreaterEqual] b\_mult\)]],
  " has no solutions (otherwise it would have infinitely many solutions, \
which contradicts the assumptions). Hence we may assume that ",
  Cell[BoxData[
      \(TraditionalForm\`M\_mult\)]],
  " has linearly independent columns and so ",
  Cell[BoxData[
      \(TraditionalForm\`M\_red\)]],
  " has ",
  StyleBox["p",
    FontSlant->"Italic"],
  " columns. Put ",
  Cell[BoxData[
      \(TraditionalForm\`R = \(\((M\_mult\^T . 
                  M\_mult)\)\^\(-1\)\) \((\(M\_mult\^T\) M\_red)\)\)]],
  ". Lattice reduction techniques are also used to find a small vector ",
  Cell[BoxData[
      \(TraditionalForm\`b\_red\)]],
  " in the lattice ",
  Cell[BoxData[
      \(TraditionalForm\`b\_mult + M\_red . v\)]],
  ". Let ",
  Cell[BoxData[
      \(TraditionalForm\`v\_0\)]],
  " be such that ",
  Cell[BoxData[
      \(TraditionalForm\`b\_red = b\_mult + M\_red . v\_0\)]],
  ". The set \[ScriptCapitalI] can be computed from the set ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalI]\_red\)]],
  " of all ",
  Cell[BoxData[
      \(TraditionalForm\`i \[Element] \[DoubleStruckCapitalZ]\^p\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`M\_red . i \[GreaterEqual] b\_red\)]],
  " using the formula ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalI] = {R . \((i - v\_0)\) : 
            i \[Element] \[ScriptCapitalI]\_red}\)]],
  "."
}], "Text"],

Cell[TextData[{
  "To find the set ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalI]\_red\)]],
  " a simple recursive algorithm can be used. The algorithm finds the bounds \
on the first variable using ",
  StyleBox["LinearProgramming", "MR"],
  " and, for each integer value ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1\)]],
  " between the bounds, calls itself recursively with the first variable set \
to ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1\)]],
  ". This algorithm is used when the system option ",
  StyleBox["BranchLinearDiophantine", "MR"],
  " is set to ",
  StyleBox["False", "MR"],
  ". With the default setting ",
  StyleBox["True", "MR"],
  " a hybrid algorithm combining the recursive algorithm and a \
branch-and-bound type algorithm is used. At each level of the recursion, the \
recursion is continued for the \"middle\" values of the first variable \
(defined as a projection of the set of points contained in the real solution \
set together with a unit cube) while the remaining parts of the real solution \
set are searched for integer solutions using the branch-and-bound type \
algorithm. ",
  StyleBox["FindInstance", "MR"],
  " finds the single element of ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalI]\_red\)]],
  " it needs using a branch-and-bound type algorithm."
}], "Text",
  CellTags->"PolyhedronIntegerPoints"],

Cell[TextData[{
  "There are two system options, ",
  StyleBox[ButtonBox["BranchLinearDiophantine",
    ButtonData:>"BranchLinearDiophantine",
    ButtonStyle->"Hyperlink"], "MR"],
  " and ",
  StyleBox[ButtonBox["LatticeReduceDiophantine",
    ButtonData:>"LatticeReduceDiophantine",
    ButtonStyle->"Hyperlink"], "MR"],
  ", that allow you to control the exact algorithm used. In some cases \
changing the values of these options may greatly improve the performance of \
",
  StyleBox["Reduce", "MR"],
  "."
}], "Text",
  CellTags->"PolyhedronIntegerPoints"],

Cell["This finds all integer points in a triangle.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      7\ x + y \[GreaterEqual] 3 && 3\ x - 33\ y + 333 \[GreaterEqual] 0 && 
        x < y, {x, y}, Integers]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-1\) && y \[Equal] 10)\) || \((x \[Equal] 0 && 
          y \[Equal] 3)\) || \((x \[Equal] 0 && 
          y \[Equal] 4)\) || \((x \[Equal] 0 && 
          y \[Equal] 5)\) || \((x \[Equal] 0 && 
          y \[Equal] 6)\) || \((x \[Equal] 0 && 
          y \[Equal] 7)\) || \((x \[Equal] 0 && 
          y \[Equal] 8)\) || \((x \[Equal] 0 && 
          y \[Equal] 9)\) || \((x \[Equal] 0 && 
          y \[Equal] 10)\) || \((x \[Equal] 1 && 
          y \[Equal] 2)\) || \((x \[Equal] 1 && 
          y \[Equal] 3)\) || \((x \[Equal] 1 && 
          y \[Equal] 4)\) || \((x \[Equal] 1 && 
          y \[Equal] 5)\) || \((x \[Equal] 1 && 
          y \[Equal] 6)\) || \((x \[Equal] 1 && 
          y \[Equal] 7)\) || \((x \[Equal] 1 && 
          y \[Equal] 8)\) || \((x \[Equal] 1 && 
          y \[Equal] 9)\) || \((x \[Equal] 1 && 
          y \[Equal] 10)\) || \((x \[Equal] 2 && 
          y \[Equal] 3)\) || \((x \[Equal] 2 && 
          y \[Equal] 4)\) || \((x \[Equal] 2 && 
          y \[Equal] 5)\) || \((x \[Equal] 2 && 
          y \[Equal] 6)\) || \((x \[Equal] 2 && 
          y \[Equal] 7)\) || \((x \[Equal] 2 && 
          y \[Equal] 8)\) || \((x \[Equal] 2 && 
          y \[Equal] 9)\) || \((x \[Equal] 2 && 
          y \[Equal] 10)\) || \((x \[Equal] 3 && 
          y \[Equal] 4)\) || \((x \[Equal] 3 && 
          y \[Equal] 5)\) || \((x \[Equal] 3 && 
          y \[Equal] 6)\) || \((x \[Equal] 3 && 
          y \[Equal] 7)\) || \((x \[Equal] 3 && 
          y \[Equal] 8)\) || \((x \[Equal] 3 && 
          y \[Equal] 9)\) || \((x \[Equal] 3 && 
          y \[Equal] 10)\) || \((x \[Equal] 4 && 
          y \[Equal] 5)\) || \((x \[Equal] 4 && 
          y \[Equal] 6)\) || \((x \[Equal] 4 && 
          y \[Equal] 7)\) || \((x \[Equal] 4 && 
          y \[Equal] 8)\) || \((x \[Equal] 4 && 
          y \[Equal] 9)\) || \((x \[Equal] 4 && 
          y \[Equal] 10)\) || \((x \[Equal] 5 && 
          y \[Equal] 6)\) || \((x \[Equal] 5 && 
          y \[Equal] 7)\) || \((x \[Equal] 5 && 
          y \[Equal] 8)\) || \((x \[Equal] 5 && 
          y \[Equal] 9)\) || \((x \[Equal] 5 && 
          y \[Equal] 10)\) || \((x \[Equal] 6 && 
          y \[Equal] 7)\) || \((x \[Equal] 6 && 
          y \[Equal] 8)\) || \((x \[Equal] 6 && 
          y \[Equal] 9)\) || \((x \[Equal] 6 && 
          y \[Equal] 10)\) || \((x \[Equal] 7 && 
          y \[Equal] 8)\) || \((x \[Equal] 7 && 
          y \[Equal] 9)\) || \((x \[Equal] 7 && 
          y \[Equal] 10)\) || \((x \[Equal] 8 && 
          y \[Equal] 9)\) || \((x \[Equal] 8 && 
          y \[Equal] 10)\) || \((x \[Equal] 9 && 
          y \[Equal] 10)\) || \((x \[Equal] 10 && 
          y \[Equal] 11)\)\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " enumerates the solutions explicitly only if the number of integer \
solutions of the system does not exceed the maximum of the ",
  Cell[BoxData[
      \(TraditionalForm\`p\^th\)]],
  " power of the value of the system option ",
  StyleBox[ButtonBox["DiscreteSolutionBound",
    ButtonData:>"DiscreteSolutionBound",
    ButtonStyle->"Hyperlink"], "MR"],
  ", where ",
  StyleBox["p",
    FontSlant->"Italic"],
  " is the dimension of the solution lattice of the equations, and the second \
element of the value of the system option ",
  StyleBox[ButtonBox["ExhaustiveSearchMaxPoints",
    ButtonData:>"ExhaustiveSearchMaxPoints",
    ButtonStyle->"Hyperlink"], "MR"],
  ". "
}], "Text",
  CellTags->"BoundedSolutionLimits"],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " does not give explicit solutions because their number would exceed the \
default limit of 10,000."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x \[GreaterEqual] 0 && y \[GreaterEqual] 0 && 
        x + y \[LessEqual] 200, {x, y}, Integers]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(\((x | y)\) \[Element] 
        Integers && \((\((0 \[LessEqual] x \[LessEqual] 199 && 
              0 \[LessEqual] y \[LessEqual] 200 - x)\) || \((x \[Equal] 200 && 
              y \[Equal] 0)\))\)\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "This increases the value of the system option ",
  StyleBox[ButtonBox["DiscreteSolutionBound",
    ButtonData:>"DiscreteSolutionBound",
    ButtonStyle->"Hyperlink"], "MR"],
  " to 1000."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<DiscreteSolutionBound\>" \[Rule] 1000}];\)\)], "Input",
  CellLabel->"In[5]:="],

Cell[TextData[{
  "Since there are two variables and no equations, the limit on the number of \
solutions is now ",
  Cell[BoxData[
      \(TraditionalForm\`1000\^2\)]],
  ", and ",
  StyleBox["Reduce", "MR"],
  " can enumerate the solutions explicitly."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
        x \[GreaterEqual] 0 && y \[GreaterEqual] 0 && 
          x + y \[LessEqual] 200, {x, y}, Integers] // Length\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \(20301\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["DiscreteSolutionBound", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<DiscreteSolutionBound\>" \[Rule] 10}];\)\)], "Input",
  CellLabel->"In[7]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary Systems of Linear Equations and Inequalities", "Subsection"],

Cell[TextData[{
  "Quantifier-free systems of linear Diophantine equations and inequalities \
are solvable for an arbitrary number of variables. The system is written in \
the ",
  StyleBox["disjunctive normal form",
    FontSlant->"Italic"],
  ", that is, as a disjunction of conjunctions, and each conjunction is \
solved separately. If a conjunction contains only equations, ",
  ButtonBox["the method for solving systems of linear equations",
    ButtonData:>"LinearEqns",
    ButtonStyle->"Hyperlink"],
  " is used. If the difference between the number of variables and the number \
of equations is at most one, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " solves the equations using ",
  ButtonBox["the method for solving systems of linear equations",
    ButtonData:>"LinearEqns",
    ButtonStyle->"Hyperlink"],
  ", and if the solution contains at most one free parameter (which is true \
in the generic case), backsubstitutes the solution into the inequalities to \
determine inequality restrictions for the parameter. For all other \
quantifier-free systems of linear Diophantine equations and inequalities ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the algorithm described in [",
  ButtonBox["3",
    ButtonData:>"3",
    ButtonStyle->"Hyperlink"],
  "], with some linear-programming-based improvements for handling bounded \
variables. The result may contain new nonnegative integer parameters, and the \
number of new parameters may be larger than the number of variables."
}], "Text"],

Cell["\<\
This system has three variables; however, to express the solution \
set, we need eight nonnegative integer parameters.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      a + 2  b - 3  c \[Equal] 4 && 3  a - 2  b + c \[GreaterEqual] 1, {a, b, 
        c}, Integers]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \(\((C[1] | C[2] | C[3] | C[4] | C[5] | C[6] | C[7] | C[8])\) \[Element] 
        Integers && C[1] \[GreaterEqual] 0 && C[2] \[GreaterEqual] 0 && 
      C[3] \[GreaterEqual] 0 && C[4] \[GreaterEqual] 0 && 
      C[5] \[GreaterEqual] 0 && C[6] \[GreaterEqual] 0 && 
      C[7] \[GreaterEqual] 0 && 
      C[8] \[GreaterEqual] 
        0 && \((\((a \[Equal] 
                3 + 2\ C[1] + C[2] + 3\ C[3] + C[4] + 2\ C[5] - 2\ C[6] - 
                  C[7] && b \[Equal] 
                5 + 5\ C[1] + C[2] - 2\ C[4] - C[5] - 5\ C[6] - 4\ C[7] - 
                  3\ C[8] && 
              c \[Equal] 
                3 + 4\ C[1] + C[2] + C[3] - C[4] - 4\ C[6] - 3\ C[7] - 
                  2\ C[8])\) || \((a \[Equal] 
                2 + 2\ C[1] + C[2] + 3\ C[3] + C[4] + 2\ C[5] - 2\ C[6] - 
                  C[7] && b \[Equal] 
                1 + 5\ C[1] + C[2] - 2\ C[4] - C[5] - 5\ C[6] - 4\ C[7] - 
                  3\ C[8] && 
              c \[Equal] 
                4\ C[1] + C[2] + C[3] - C[4] - 4\ C[6] - 3\ C[7] - 
                  2\ C[8])\) || \((a \[Equal] 
                4 + 2\ C[1] + C[2] + 3\ C[3] + C[4] + 2\ C[5] - 2\ C[6] - 
                  C[7] && b \[Equal] 
                5\ C[1] + C[2] - 2\ C[4] - C[5] - 5\ C[6] - 4\ C[7] - 
                  3\ C[8] && 
              c \[Equal] 
                4\ C[1] + C[2] + C[3] - C[4] - 4\ C[6] - 3\ C[7] - 
                  2\ C[8])\) || \((a \[Equal] 
                1 + 2\ C[1] + C[2] + 3\ C[3] + C[4] + 2\ C[5] - 2\ C[6] - 
                  C[7] && b \[Equal] 
                5\ C[1] + C[2] - 2\ C[4] - C[5] - 5\ C[6] - 4\ C[7] - 
                  3\ C[8] && 
              c \[Equal] \(-1\) + 4\ C[1] + C[2] + C[3] - C[4] - 4\ C[6] - 
                  3\ C[7] - 2\ C[8])\) || \((a \[Equal] \(-1\) + 2\ C[1] + 
                  C[2] + 3\ C[3] + C[4] + 2\ C[5] - 2\ C[6] - C[7] && 
              b \[Equal] \(-5\) + 5\ C[1] + C[2] - 2\ C[4] - C[5] - 5\ C[6] - 
                  4\ C[7] - 3\ C[8] && 
              c \[Equal] \(-5\) + 4\ C[1] + C[2] + C[3] - C[4] - 4\ C[6] - 
                  3\ C[7] - 2\ C[8])\) || \((a \[Equal] 
                2\ C[1] + C[2] + 3\ C[3] + C[4] + 2\ C[5] - 2\ C[6] - C[7] && 
              b \[Equal] \(-4\) + 5\ C[1] + C[2] - 2\ C[4] - C[5] - 5\ C[6] - 
                  4\ C[7] - 3\ C[8] && 
              c \[Equal] \(-4\) + 4\ C[1] + C[2] + C[3] - C[4] - 4\ C[6] - 
                  3\ C[7] - 2\ C[8])\))\)\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Univariate Systems", "Section"],

Cell[CellGroupData[{

Cell["Univariate Equations", "Subsection",
  CellTags->"UnivariateEqns"],

Cell[TextData[{
  "To find integer solutions of univariate equations ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a variant of the algorithm given in [",
  ButtonBox["4",
    ButtonData:>"4",
    ButtonStyle->"Hyperlink"],
  "] with improvements described in [",
  ButtonBox["5",
    ButtonData:>"5",
    ButtonStyle->"Hyperlink"],
  "]. The algorithm can find integer solutions of polynomials of much higher \
degrees than can be handled by real root isolation algorithms and with much \
larger free terms than can be handled by integer factorization algorithms."
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " finds integer solutions of a sparse polynomial of degree 100,000."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(poly = 
        x\^100000 + 1234\ x\^77777 - 2121\ x\^12345 + 7890\ x\^999 - 
          x\^11;\)\), "\n", 
    \(\(freeterm = poly /. \[InvisibleSpace]x \[Rule] 1234567;\)\), "\n", 
    \(Timing[Reduce[poly - freeterm \[Equal] 0, x, Integers]]\)}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({11.26`\ Second, x \[Equal] 1234567}\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell["\<\
The free term of this polynomial has 609,152 digits and cannot be \
easily factored.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[freeterm]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(2.926904998127342567255744665591`15.954589770191005*^609151\)], "Output",\

  CellLabel->"Out[12]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TimeConstrained[FactorInteger[freeterm] // Timing, 1000]\)], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \($Aborted\)], "Output",
  CellLabel->"Out[13]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems of Univariate Equations and Inequalities", "Subsection"],

Cell[TextData[{
  "Systems of univariate Diophantine equations and inequalities are written \
in the disjunctive normal form, and each conjunction is solved separately. If \
a conjunction contains an equation, ",
  ButtonBox["the method for solving univariate equations",
    ButtonData:>"UnivariateEqns",
    ButtonStyle->"Hyperlink"],
  " is used, and the  solutions satisfying the remaining equations and \
inequalities are selected."
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " finds integer solutions of ",
  Cell[BoxData[
      \(x\^4 - 25  x\^2 \[Equal] \(-144\)\)]],
  " and selects the ones that satisfy the inequality ",
  Cell[BoxData[
      \(x\^100001 - 27\ x + 5 \[GreaterEqual] 0\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^4 - 25  x\^2 \[Equal] \(-144\) && 
        x\^100001 - 27\ x + 5 \[GreaterEqual] 0, x, Integers]\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    \(x \[Equal] 3 || x \[Equal] 4\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell[TextData[{
  "Conjunctions containing only inequalities are solved over the reals. \
Integer solutions in the resulting real intervals are given explicitly if \
their number in the given interval does not exceed the value of the system \
option ",
  StyleBox[ButtonBox["DiscreteSolutionBound",
    ButtonData:>"DiscreteSolutionBound",
    ButtonStyle->"Hyperlink"], "MR"],
  ". The default value of the option is 10. For intervals containing more \
integer solutions, the solutions are represented implicitly."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Bivariate Systems", "Section"],

Cell[CellGroupData[{

Cell["Quadratic Equations", "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve arbitrary quadratic Diophantine equations in two variables. The \
general form of such an equation is"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalPhi](x, y) = 
      a\ x\^2 + b\ x\ y + c\ y\^2 + d\ x + e\ y + f \[Equal] 
        0. \)], "NumberedEquation",
  CellTags->"Quadratic"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x, 
          y) = \(\(\[CapitalPhi]\_1\)(x, y)\) \(\(\[CapitalPhi]\_2\)(x, 
            y)\)\)]],
  ", where",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(\[CapitalPhi]\_1\)(x, y)\)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_2\)(x, y)\)]],
  " are linear polynomials, the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") is equivalent to ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_1\)(x, 
          y) = \(0\  \[Or] \(\[CapitalPhi]\_2\)(x, y) = 0\)\)]],
  ", and methods for solving linear Diophantine equations are used. For \
irreducible polynomials ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x, y)\)]],
  ", the algorithms used and the form of the result depend on the determinant \
",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = b\^2 - 4\ a\ c\)]],
  " of the quadratic form."
}], "Text"],

Cell[CellGroupData[{

Cell["Hyperbolic type equations with square determinants", "SubsubsectionIcon"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] > 0\)]],
  " and ",
  Cell[BoxData[
      \(\@\[CapitalDelta]\)]],
  " is an integer, then ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\ \(\[CapitalPhi](x, y)\) - 
          g = \(\(\[CapitalPhi]\_1\)(x, y)\) \(\(\[CapitalPhi]\_2\)(x, 
            y)\)\)]],
  ", where",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(\[CapitalPhi]\_1\)(x, y)\)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_2\)(x, y)\)]],
  " are linear polynomials and ",
  Cell[BoxData[
      \(TraditionalForm\`g = 
        c\ d\^2 + a\ e\^2 + \(b\^2\) f - b\ d\ e - 4\ a\ c\ f\)]],
  ". In this case, the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") is equivalent to the disjunction of linear systems ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_1\)(x, 
          y) = \(\[Delta]\  \[And] \(\[CapitalPhi]\_2\)(x, 
              y) = \(-g\)/\[Delta]\)\)]],
  ", for all divisors \[Delta] of ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". Each of the linear systems has one solution over the rationals, hence \
the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") has a finite number of integer solutions."
}], "Text"],

Cell["\<\
Here is a binary quadratic equation with \[CapitalDelta] = 9.\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      1 + 12\ x + 2\ x\^2 + 7\ y + 5\ x\ y + 2\ y\^2 \[Equal] 0, {x, y}, 
      Integers]\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-4\) && y \[Equal] \(-1\))\) || \((x \[Equal] 2 && 
          y \[Equal] \(-3\))\) || \((x \[Equal] 4 && 
          y \[Equal] \(-9\))\)\)], "Output",
  CellLabel->"Out[15]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic type equations with non-square determinants", \
"SubsubsectionIcon"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] > 0\)]],
  " and ",
  Cell[BoxData[
      \(\@\[CapitalDelta]\)]],
  " is not an integer, then the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") is a Pell-type equation. Methods for solving such equations have been \
developed since the 18th century and can be constructed based on [",
  ButtonBox["6",
    ButtonData:>"6",
    ButtonStyle->"Hyperlink"],
  "] and [",
  ButtonBox["7",
    ButtonData:>"7",
    ButtonStyle->"Hyperlink"],
  "] (though these books do not contain a complete description of the \
algorithm). The solution set is empty or infinite, parametrized by an integer \
parameter appearing in the exponent."
}], "Text"],

Cell[TextData[{
  "A Pell equation is an equation of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - D\ y\^2 \[Equal] 1\)]],
  ", where ",
  StyleBox["D",
    FontSlant->"Italic"],
  " is not a square. Solutions to Pell equations with small coefficients can \
be quite complicated."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^2 - 61\ y\^2 \[Equal] 1, {x, y}, Integers]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    \(\((C[1] \[Element] Integers && C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/2\ \((\(-\((1766319049 - 226153980\ \@61)\)\^C[1]\) - \
\((1766319049 + 226153980\ \@61)\)\^C[1])\) && 
          y \[Equal] \(-\(\(\((1766319049 - 226153980\ \@61)\)\^C[1] - \
\((1766319049 + 226153980\ \@61)\)\^C[1]\)\/\(2\ \@61\)\)\))\) || \((C[
              1] \[Element] Integers && C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/2\ \((\(-\((1766319049 - 226153980\ \@61)\)\^C[1]\) - \
\((1766319049 + 226153980\ \@61)\)\^C[1])\) && 
          y \[Equal] \(\((1766319049 - 226153980\ \@61)\)\^C[1] - \
\((1766319049 + 226153980\ \@61)\)\^C[1]\)\/\(2\ \@61\))\) || \((C[
              1] \[Element] Integers && C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/2\ \((\((1766319049 - 226153980\ \@61)\)\^C[1] + \((1766319049 \
+ 226153980\ \@61)\)\^C[1])\) && 
          y \[Equal] \(-\(\(\((1766319049 - 226153980\ \@61)\)\^C[1] - \
\((1766319049 + 226153980\ \@61)\)\^C[1]\)\/\(2\ \@61\)\)\))\) || \((C[
              1] \[Element] Integers && C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/2\ \((\((1766319049 - 226153980\ \@61)\)\^C[1] + \((1766319049 \
+ 226153980\ \@61)\)\^C[1])\) && 
          y \[Equal] \(\((1766319049 - 226153980\ \@61)\)\^C[1] - \
\((1766319049 + 226153980\ \@61)\)\^C[1]\)\/\(2\ \@61\))\)\)], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell["\<\
Here is the solution of a Pell-type equation with \[CapitalDelta] = \
5.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      Reduce[7 + 5\ x + x\^2 + 7\ y + 3\ x\ y + y\^2 \[Equal] 0, {x, y}, 
        Integers]\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    \(\((C[1] \[Element] Integers && C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((5\ \((\(-5\) - \(2\ \((\((9 - 4\ \@5)\)\^\(1 + 2\ \
C[1]\) - \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\))\)\)\/\@5)\) + 
                  3\ \((1 - 
                        2\ \((\((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) + 
                  2\ \((\((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((5\ \((\(-5\) + \(2\ \((\((9 - 4\ \@5)\)\^\(1 + 2\ \
C[1]\) - \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\))\)\)\/\@5)\) + 
                  3\ \((1 - 
                        2\ \((\((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) + 
                  2\ \((\((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((5\ \((\(-5\) - \(2\ \((\((9 - 4\ \@5)\)\^\(2\ C[1]\) - \
\((9 + 4\ \@5)\)\^\(2\ C[1]\))\)\)\/\@5)\) + 
                  3\ \((1 + 
                        2\ \((\((9 - 4\ \@5)\)\^\(2\ C[1]\) + \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) - 
                  2\ \((\((9 - 4\ \@5)\)\^\(2\ C[1]\) + \((9 + 4\ \@5)\)\^\(2\
\ C[1]\))\))\))\) || \((C[1] \[Element] Integers && C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((5\ \((\(-5\) + \(2\ \((\((9 - 4\ \@5)\)\^\(2\ C[1]\) - \
\((9 + 4\ \@5)\)\^\(2\ C[1]\))\)\)\/\@5)\) + 
                  3\ \((1 + 
                        2\ \((\((9 - 4\ \@5)\)\^\(2\ C[1]\) + \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) - 
                  2\ \((\((9 - 4\ \@5)\)\^\(2\ C[1]\) + \((9 + 4\ \@5)\)\^\(2\
\ C[1]\))\))\))\) || \((C[1] \[Element] Integers && C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 - 
                        3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) - 
                        3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((\(-5\)\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - 
                              5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) - 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) + 
                  3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) + 
                  3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 - 
                        3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) - 
                        3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((5\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + 
                              5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) + 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) + 
                  3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) + 
                  3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 + 
                        3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) + 
                        3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((5\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + 
                              5\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) - 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(1 + 2\ \
C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) - 
                  3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) - 
                  3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 + 
                        3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) + 
                        3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((\(-5\)\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - 
                              5\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) + 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(1 + 2\ \
C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) - 
                  3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) - 
                  3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 - 
                        3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) - 
                        3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((5\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + 
                              5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) - 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) + 
                  3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) + 
                  3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 - 
                        3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) - 
                        3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((\(-5\)\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) - 
                              5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) + 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(2\ C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) + 
                  3\ \((9 - 4\ \@5)\)\^\(2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(2\ C[1]\) + 
                  3\ \((9 + 4\ \@5)\)\^\(2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(2\ C[1]\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 + 
                        3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) + 
                        3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((\(-5\)\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - 
                              5\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) - 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(1 + 2\ \
C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) - 
                  3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) - 
                  3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\) || \((C[1] \[Element] Integers && 
          C[1] \[GreaterEqual] 0 && 
          x \[Equal] 
            1\/10\ \((3\ \((1 + 
                        3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) + 
                        3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\) + 
                  5\ \((\(-5\) + 
                        1\/5\ \((5\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) - 
                              3\ \@5\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + 
                              5\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) + 
                              3\ \@5\ \((9 + 4\ \@5)\)\^\(1 + 2\ \
C[1]\))\))\))\) && 
          y \[Equal] 
            1\/5\ \((\(-1\) - 
                  3\ \((9 - 4\ \@5)\)\^\(1 + 2\ C[1]\) + \@5\ \((9 - 4\ \
\@5)\)\^\(1 + 2\ C[1]\) - 
                  3\ \((9 + 4\ \@5)\)\^\(1 + 2\ C[1]\) - \@5\ \((9 + 4\ \
\@5)\)\^\(1 + 2\ C[1]\))\))\)\)], "Output",
  CellLabel->"Out[17]="]
}, Open  ]],

Cell["\<\
Even though the solutions are expressed using nonrational numbers, \
they are in fact integers, as they should be.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[sol /. C[1] \[Rule] 7]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \(\((y \[Equal] \(-143556140002351233\) && \((x \[Equal] 
                375834853819893935 || 
              x \[Equal] 54833566187159759)\))\) || \((y \[Equal] 
            375834853819893937 && \((x \[Equal] \(-983948421457330581\) || 
              x \[Equal] \(-143556140002351235\))\))\) || \((y \[Equal] 
            54833566187159761 && \((x \[Equal] \(-143556140002351235\) || 
              x \[Equal] \(-20944558559128053\))\))\) || \((y \[Equal] 
            2576010410552097799 && \((x \[Equal] \(-983948421457330581\) || 
              x \[Equal] \(-6744082810198962821\))\))\) || \((y \[Equal] \
\(-6744082810198962819\) && \((x \[Equal] 2576010410552097797 || 
              x \[Equal] 
                17656238020044790655)\))\) || \((y \[Equal] \
\(-983948421457330579\) && \((x \[Equal] 375834853819893935 || 
              x \[Equal] 2576010410552097797)\))\)\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can solve systems consisting of a Pell-type equation and inequalities \
giving simple bounds on variables."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x^2 - 3  y^2 \[Equal] 22\  && 
        0 \[LessEqual] y \[LessEqual] 1000000, {x, y}, Integers]\)], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-856487\) && 
          y \[Equal] 494493)\) || \((x \[Equal] \(-472765\) && 
          y \[Equal] 272951)\) || \((x \[Equal] \(-229495\) && 
          y \[Equal] 132499)\) || \((x \[Equal] \(-126677\) && 
          y \[Equal] 73137)\) || \((x \[Equal] \(-61493\) && 
          y \[Equal] 35503)\) || \((x \[Equal] \(-33943\) && 
          y \[Equal] 19597)\) || \((x \[Equal] \(-16477\) && 
          y \[Equal] 9513)\) || \((x \[Equal] \(-9095\) && 
          y \[Equal] 5251)\) || \((x \[Equal] \(-4415\) && 
          y \[Equal] 2549)\) || \((x \[Equal] \(-2437\) && 
          y \[Equal] 1407)\) || \((x \[Equal] \(-1183\) && 
          y \[Equal] 683)\) || \((x \[Equal] \(-653\) && 
          y \[Equal] 377)\) || \((x \[Equal] \(-317\) && 
          y \[Equal] 183)\) || \((x \[Equal] \(-175\) && 
          y \[Equal] 101)\) || \((x \[Equal] \(-85\) && 
          y \[Equal] 49)\) || \((x \[Equal] \(-47\) && 
          y \[Equal] 27)\) || \((x \[Equal] \(-23\) && 
          y \[Equal] 13)\) || \((x \[Equal] \(-13\) && 
          y \[Equal] 7)\) || \((x \[Equal] \(-7\) && 
          y \[Equal] 3)\) || \((x \[Equal] \(-5\) && 
          y \[Equal] 1)\) || \((x \[Equal] 5 && 
          y \[Equal] 1)\) || \((x \[Equal] 7 && 
          y \[Equal] 3)\) || \((x \[Equal] 13 && 
          y \[Equal] 7)\) || \((x \[Equal] 23 && 
          y \[Equal] 13)\) || \((x \[Equal] 47 && 
          y \[Equal] 27)\) || \((x \[Equal] 85 && 
          y \[Equal] 49)\) || \((x \[Equal] 175 && 
          y \[Equal] 101)\) || \((x \[Equal] 317 && 
          y \[Equal] 183)\) || \((x \[Equal] 653 && 
          y \[Equal] 377)\) || \((x \[Equal] 1183 && 
          y \[Equal] 683)\) || \((x \[Equal] 2437 && 
          y \[Equal] 1407)\) || \((x \[Equal] 4415 && 
          y \[Equal] 2549)\) || \((x \[Equal] 9095 && 
          y \[Equal] 5251)\) || \((x \[Equal] 16477 && 
          y \[Equal] 9513)\) || \((x \[Equal] 33943 && 
          y \[Equal] 19597)\) || \((x \[Equal] 61493 && 
          y \[Equal] 35503)\) || \((x \[Equal] 126677 && 
          y \[Equal] 73137)\) || \((x \[Equal] 229495 && 
          y \[Equal] 132499)\) || \((x \[Equal] 472765 && 
          y \[Equal] 272951)\) || \((x \[Equal] 856487 && 
          y \[Equal] 494493)\)\)], "Output",
  CellLabel->"Out[19]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parabolic type equations", "SubsubsectionIcon"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] = 0\)]],
  ", set ",
  Cell[BoxData[
      FormBox[
        RowBox[{"g", "=", 
          RowBox[{
            RowBox[{
              StyleBox["sign",
                FontSlant->"Italic"], "(", "a", ")"}], 
            RowBox[{
              StyleBox["gcd",
                FontSlant->"Italic"], "(", \(a, c\), ")"}]}]}], 
        TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1 = \@\(a/g\)\)]],
  ", and ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(c\_1\), "=", 
          RowBox[{
            RowBox[{
              StyleBox["sign",
                FontSlant->"Italic"], "(", \(b/g\), ")"}], \(\@\(c/g\)\)}]}], 
        TraditionalForm]]],
  ". Since ",
  Cell[BoxData[
      \(TraditionalForm\`b\^2 = 4 \(\( g\^2\)(a/g)\) \((c/g)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`a\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`c\_1\)]],
  " are nonzero integers, and ",
  Cell[BoxData[
      \(TraditionalForm\`b = 2  g\ \(a\_1\) c\_1\)]],
  ". Then"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalPhi](x, 
        y) = \(g(\(a\_1\) x + \(c\_1\) y)\)\^2 + d\ x + 
        e\ y + \(\(f\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "Set ",
  Cell[BoxData[
      \(TraditionalForm\`m = \(c\_1\) d - \(a\_1\) e\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\_1\ x + c\_1\ y\)]],
  ". Then the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") is equivalent to"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(a\_1\) \(\[CapitalPhi](x, 
          y)\) = \(\(a\_1\) \(g(\(a\_1\) x + \(c\_1\) y)\)\^2 + 
          d(a\_1\ x + c\_1\ y) - 
          m\ y + \(a\_1\) f = \(a\_1\) g\ t\^2 + d\ t - 
            m\ y + \(a\_1\) f \[Equal] 0. \)\)], "NumberedEquation",
  CellTags->"Parabolic1"],

Cell[TextData[{
  "Suppose ",
  Cell[BoxData[
      \(TraditionalForm\`m = 0\)]],
  ". If the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") had integer solutions, ",
  Cell[BoxData[
      \(TraditionalForm\`\(a\_1\) g\ t\^2 + d\ t + \(a\_1\) f = 0\)]],
  " would have integer solutions in ",
  StyleBox["t",
    FontSlant->"Italic"],
  ", and so ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x, y)\)]],
  " would be a product of two linear polynomials. Since here ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x, y)\)]],
  " is irreducible, the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") has no integer solutions. "
}], "Text"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`m \[NotEqual] 0\)]],
  ", then the equation (",
  ButtonBox["4",
    ButtonData:>"Parabolic1",
    ButtonStyle->"Hyperlink"],
  ") implies"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\(a\_1\) g\ t\^2 + d\ t + \(a\_1\) f\), "\[Congruent]", 
        RowBox[{"0", "  ", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                StyleBox["mod",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], "|", "m", "|"}], ")"}], "."}]}]}], 
      TraditionalForm]], "NumberedEquation",
  CellTags->"Parabolic2"],

Cell[TextData[{
  "If the modular equation (",
  ButtonBox["5",
    ButtonData:>"Parabolic2",
    ButtonStyle->"Hyperlink"],
  ") has no solutions in ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") has no integer solutions. (If ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(m\)\(|\)\) = 1\)]],
  ", the modular equation (",
  ButtonBox["5",
    ButtonData:>"Parabolic2",
    ButtonStyle->"Hyperlink"],
  ") has one solution, ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  ".) Otherwise ",
  Cell[BoxData[
      \(TraditionalForm\`t = u + k\ m\)]],
  ", for some solution ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] u <  | m | \)]],
  " of the modular equation (",
  ButtonBox["5",
    ButtonData:>"Parabolic2",
    ButtonStyle->"Hyperlink"],
  "). Replacing ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Rule] u + k\ m\)]],
  " in the equation (",
  ButtonBox["4",
    ButtonData:>"Parabolic1",
    ButtonStyle->"Hyperlink"],
  ") and solving the resulting linear equation for ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " gives"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y \[Equal] \(a\_1\) 
          g\ m\ k\^2 + \((d + 2 \( a\_1\) g\ u)\) 
          k + \ \((\(a\_1\) g\ u\^2 + 
              d\ u + \(a\_1\) f)\)/\(\(m\)\(.\)\)\)], "NumberedEquation",
  CellTags->"Parabolic3"],

Cell[TextData[{
  "Note that since ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " satisfies the modular equation (",
  ButtonBox["5",
    ButtonData:>"Parabolic2",
    ButtonStyle->"Hyperlink"],
  "), the division in the last term of (",
  ButtonBox["6",
    ButtonData:>"Parabolic3",
    ButtonStyle->"Hyperlink"],
  ") gives an integer result. Since ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\_1\ x + c\_1\ y\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t = u + k\ m\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((u + k\ m - \(c\_1\) y)\)/a\_1\)]],
  ". Taking the equation (",
  ButtonBox["6",
    ButtonData:>"Parabolic3",
    ButtonStyle->"Hyperlink"],
  ") and the fact that ",
  Cell[BoxData[
      \(TraditionalForm\`m = \(c\_1\) d - \(a\_1\) e\)]],
  " into account gives"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`x \[Equal] \(-c\_1\) 
          g\ m\ k\^2 - \((e + 2 \( c\_1\) g\ u)\) 
          k - \ \((\(c\_1\) g\ u\^2 + 
              e\ u + \(c\_1\) f)\)/\(\(m\)\(.\)\)\)], "NumberedEquation",
  CellTags->"Parabolic4"],

Cell[TextData[{
  "Therefore, the full solution of the equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") of parabolic type consists of one-parameter solution families given by \
equations (",
  ButtonBox["6",
    ButtonData:>"Parabolic3",
    ButtonStyle->"Hyperlink"],
  ") and (",
  ButtonBox["7",
    ButtonData:>"Parabolic4",
    ButtonStyle->"Hyperlink"],
  ") for each solution ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " of the modular equation (",
  ButtonBox["5",
    ButtonData:>"Parabolic2",
    ButtonStyle->"Hyperlink"],
  "), for which ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(c\_1\) g\ u\^2 + e\ u + \(c\_1\) f)\)/m\)]],
  " is an integer."
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " finds integer solutions of a quadratic equation of the parabolic type."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^2 - 2\ x\ y + y\^2 + 5\ x - 7\ y \[Equal] 22, {x, y}, 
      Integers]\)], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    \(\((C[1] \[Element] Integers && 
          x \[Equal] \(-11\) + 7\ C[1] + 2\ C[1]\^2 && 
          y \[Equal] \(-11\) + 5\ C[1] + 2\ C[1]\^2)\) || \((C[1] \[Element] 
            Integers && x \[Equal] \(-7\) + 9\ C[1] + 2\ C[1]\^2 && 
          y \[Equal] \(-8\) + 7\ C[1] + 2\ C[1]\^2)\)\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic type equations", "SubsubsectionIcon"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta] < 0\)]],
  ", the solutions of equation (",
  ButtonBox["3",
    ButtonData:>"Quadratic",
    ButtonStyle->"Hyperlink"],
  ") are integer points on an ellipse. Since an ellipse is a bounded set, the \
number of solutions must be finite. An obvious algorithm for finding integer \
points would be to compute the solutions for ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " for each of the finite number of possible integer values of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". This, however, would be prohibitively slow for larger ellipses. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a faster algorithm described in [",
  ButtonBox["8",
    ButtonData:>"8",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " finds positive integer solutions of a quadratic equation of the elliptic \
type. There are more than ",
  Cell[BoxData[
      \(TraditionalForm\`8\[Times]10\^18\)]],
  " possible positive integer values of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", so the obvious algorithm would not be practical for this ellipse."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      23  x\^2 + 17  y\^2 \[Equal] 1693339429465935072912802926367922572800 && 
        x > 0 && y > 0, {x, y}, Integers]\)], "Input",
  CellLabel->"In[21]:="],

Cell[BoxData[
    \(\((x \[Equal] 1234567890987654321 && 
          y \[Equal] 9876543210123456789)\) || \((x \[Equal] 
            2394388915976549628 && 
          y \[Equal] 9583927013507483052)\) || \((x \[Equal] 
            3587688774846621081 && 
          y \[Equal] 9066079904941225629)\) || \((x \[Equal] 
            4628858032573225308 && 
          y \[Equal] 8403549375095756172)\) || \((x \[Equal] 
            4730542803202013073 && 
          y \[Equal] 8326586121887736693)\) || \((x \[Equal] 
            6448688263945408950 && 
          y \[Equal] 6583719143723572530)\) || \((x \[Equal] 
            6563464511756847993 && 
          y \[Equal] 6428433631978684413)\) || \((x \[Equal] 
            7787179624084878150 && 
          y \[Equal] 4191136305399154530)\)\)], "Output",
  CellLabel->"Out[21]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Thue Equations", "Subsection"],

Cell[TextData[{
  "A",
  StyleBox[" Thue ",
    FontSlant->"Italic"],
  "equation is a Diophantine equation of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\[CapitalPhi](x, y) = 
      m\)\(,\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x, y)\)]],
  " is an irreducible homogenous form of degree \[GreaterEqual] 3. "
}], "Text"],

Cell[TextData[{
  "The number of solutions of Thue equations is always finite. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can in principle solve arbitrary Thue equations, though the time \
necessary to find the solutions lengthens very fast with degree and \
coefficient size. The hardest part of the algorithm is computing a bound on \
the size of solutions. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses an algorithm based on the Baker-Wustholz theorem to find the bound \
[",
  ButtonBox["9",
    ButtonData:>"9",
    ButtonStyle->"Hyperlink"],
  "]. If the input contains inequalities that provide a reasonable size bound \
on solutions, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can compute the solutions much faster."
}], "Text"],

Cell["This finds integer solutions of a cubic Thue equation.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 4\ x\ y\^2 + y\^3 == 1, {x, y}, Integers] // 
      Timing\)], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    \({0.5100000000000091`\ Second, \((x \[Equal] \(-2\) && 
            y \[Equal] 1)\) || \((x \[Equal] 0 && 
            y \[Equal] 1)\) || \((x \[Equal] 1 && 
            y \[Equal] 0)\) || \((x \[Equal] 1 && 
            y \[Equal] 4)\) || \((x \[Equal] 2 && 
            y \[Equal] 1)\) || \((x \[Equal] 508 && 
            y \[Equal] 273)\)}\)], "Output",
  CellLabel->"Out[22]="]
}, Open  ]],

Cell[TextData[{
  "If we give ",
  StyleBox["Reduce", "MR"],
  " a bound on the size of solutions, it can solve the equation much faster."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
        x\^3 - 4\ x\ y\^2 + y\^3 == 1\  && \ \(-10^10\) < x < 10^10, {x, y}, 
        Integers] // Timing\)], "Input",
  CellLabel->"In[23]:="],

Cell[BoxData[
    \({0.05000000000001814`\ Second, \((x \[Equal] \(-2\) && 
            y \[Equal] 1)\) || \((x \[Equal] 0 && 
            y \[Equal] 1)\) || \((x \[Equal] 1 && 
            y \[Equal] 0)\) || \((x \[Equal] 1 && 
            y \[Equal] 4)\) || \((x \[Equal] 2 && 
            y \[Equal] 1)\) || \((x \[Equal] 508 && 
            y \[Equal] 273)\)}\)], "Output",
  CellLabel->"Out[23]="]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " finds the only solution of a degree 15 Thue equation with at most a \
100-digit ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " coordinate. Without the bound on the solution size, ",
  StyleBox["Reduce", "MR"],
  " did not finish in 1000 seconds."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
        x\^15 - 4\ \(\(\(x\)\(\ \)\)\^12\) y\^3 + 7 \( x\^7\) y\^8 - 
              2  y\^15 \[Equal] 
            23058325506004605670097246320963935108919550\  && \ \(-10^100\) < 
            x < 10^100, {x, y}, Integers] // Timing\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    \({12.35999999999995`\ Second, 
      x \[Equal] 777 && y \[Equal] \(-121\)}\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Multivariate Nonlinear Systems", "Section"],

Cell[CellGroupData[{

Cell["Systems Solvable with the Modular Sieve Method", "Subsection",
  CellTags->"Sieve"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a variant of the modular sieve method (see e.g. [",
  ButtonBox["9",
    ButtonData:>"9",
    ButtonStyle->"Hyperlink"],
  "]). The method may prove that a system has no solutions in integers modulo \
an integer ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", and therefore, it has no integer solutions. Otherwise, it may find a \
solution with small integer coordinates or prove that the system has no \
integer solutions with all coordinates between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-b\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ". The number of candidate solution points that the sieve method is allowed \
to test is controlled by the system option ",
  StyleBox[ButtonBox["SieveMaxPoints",
    ButtonData:>"SieveMaxPoints",
    ButtonStyle->"Hyperlink"], "MR"],
  ". "
}], "Text"],

Cell["This equation has no solutions modulo 2.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\(-2\)\ x\^3\ y\^9 + 6\ x\^5\ y\^5\ z\^2 + 6\ x\^8\ y\^2\ z\^5 + 
          4\ x\^7\ y\^6\ z\^7 \[Equal] 7, {x, y, z}, Integers]\)], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[25]="]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["FindInstance", "MR"],
  " finds a small solution using the modular sieve."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
      9\ x\^6\ y\^8\ z - 81\ x\^2\ y\^9\ z - 5\ x\^9\ y\^5\ z\^5 + 
          2\ x\^6\ y\^2\ z\^9 \[Equal] 1080, {x, y, z}, Integers]\)], "Input",\

  CellLabel->"In[26]:="],

Cell[BoxData[
    \({{x \[Rule] 1, y \[Rule] 2, z \[Rule] 3}}\)], "Output",
  CellLabel->"Out[26]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems with More Than one Equation", "Subsection",
  CellTags->"ManyEqn"],

Cell[TextData[{
  "If a Diophantine polynomial system contains more than one equation, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses ",
  ButtonBox["GroebnerBasis",
    ButtonStyle->"RefGuideLink"],
  " in an attempt to reduce the problem to a sequence of simpler problems."
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Systems solvable by recursion over finitely many partial \
solutions\
\>", "SubsubsectionIcon"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " attempts to solve an element of the Gr\[ODoubleDot]bner basis, which \
depends on the minimal number of the initial variables. If the number of \
solutions is finite, then for each solution ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " substitutes the computed values and attempts to solve the obtained system \
for the remaining variables."
}], "Text"],

Cell[TextData[{
  "Here the first equation has four integer solutions for ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". For each of the solutions, the second equation becomes a univariate \
equation in ",
  StyleBox["z",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^4 - x\ y + y\^2 \[Equal] 7 && 
        z\^4 - x\ z + y\^2 + y \[Equal] 2400, {x, y, z}, Integers]\)], "Input",\

  CellLabel->"In[27]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-1\) && y \[Equal] \(-3\) && 
          z \[Equal] \(-7\))\) || \((x \[Equal] \(-1\) && y \[Equal] 2 && 
          z \[Equal] \(-7\))\)\)], "Output",
  CellLabel->"Out[27]="]
}, Open  ]],

Cell[TextData[{
  "Here the first equation is a Thue equation with one solution. After \
replacing ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " with the values computed from the first equation, the second equation \
becomes a Pell equation."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^3 - 2\ y\^3 \[Equal] 11 && z\^2 - x\ y\ w\^2 \[Equal] 1 && z > 0 && 
        w > 0, {x, y, z, w}, Integers]\)], "Input",
  CellLabel->"In[28]:="],

Cell[BoxData[
    \(x \[Equal] 3 && y \[Equal] 2 && C[1] \[Element] Integers && 
      C[1] \[GreaterEqual] 1 && 
      z \[Equal] 1\/2\ \((\((5 - 2\ \@6)\)\^C[1] + \((5 + 2\ \@6)\)\^C[1])\) && 
      w \[Equal] \(-\(\(\((5 - 2\ \@6)\)\^C[1] - \((5 + 2\ \
\@6)\)\^C[1]\)\/\(2\ \@6\)\)\)\)], "Output",
  CellLabel->"Out[28]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems with linear-triangular Gr\[ODoubleDot]bner bases", \
"SubsubsectionIcon"],

Cell["\<\
This heuristic applies to systems with Gr\[ODoubleDot]bner bases of \
the form\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\({\(c\_1\) x\_1 - \(f\_1\)(Y),  ... , \(c\_k\) 
            x\_k - \(f\_k\)(Y), g(Y)}\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "In this case, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " solves the system of congruences"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(\(\(f\_1\)(Y) \[Congruent] 
            0\ mod\ c\_1\)\(\[And]\)\) ... \) \[And] \(f\_k\)(Y) \[Congruent] 
        0\ mod\ c\_k\)\(,\)\)\)], "NumberedEquation",
  CellTags->"Congruences"],

Cell[TextData[{
  "substitutes the solutions into the equation ",
  Cell[BoxData[
      \(TraditionalForm\`g(Y) \[Equal] 0\)]],
  " and the inequalities present in the original system, and attempts to \
solve the so-obtained systems for the integer parameters present in the \
solutions of the system (",
  ButtonBox["8",
    ButtonData:>"Congruences",
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell["\<\
This system reduces to solving a congruence and a Pell \
equation.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^2 - 7\ y\^2 \[Equal] 1 && 2\ z \[Equal] x\^3 - 1 && 
        t - 4\ z\^2 + y \[Equal] 7 && x > 0 && y > 0, {x, y, z, t}, 
      Integers]\)], "Input",
  CellLabel->"In[29]:="],

Cell[BoxData[
    \(C[1] \[Element] Integers && C[1] \[GreaterEqual] 1 && 
      x \[Equal] 
        1 + 1\/4\ \((\(-4\) + 
                2\ \((\((127 - 48\ \@7)\)\^C[1] + \((127 + 48\ \
\@7)\)\^C[1])\))\) && 
      y \[Equal] \(-\(\(\((127 - 48\ \@7)\)\^C[1] - \((127 + 48\ \@7)\)\^C[1]\
\)\/\(2\ \@7\)\)\) && 
      z \[Equal] 
        1\/2\ \((\(-1\) + \((1 + 1\/4\ \((\(-4\) + 2\ \((\((127 - 48\ \
\@7)\)\^C[1] + \((127 + 48\ \@7)\)\^C[1])\))\))\)\^3)\) && 
      t \[Equal] 8 - 2\ x\^3 + x\^6 - y\)], "Output",
  CellLabel->"Out[29]="]
}, Open  ]],

Cell["\<\
This system reduces to solving a system of two congruences and a \
quadratic Diophantine equation of the parabolic type for each family of \
congruence solutions.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      3\ z \[Equal] x\^2 - 2\ x\ y && 
        2\ t \[Equal] 
          x\^3 + 96\ z\^2 - 1 && \((x - 2\ y)\)\^2 - 3\ x \[Equal] 18, {x, y, 
        z, t}, Integers]\)], "Input",
  CellLabel->"In[30]:="],

Cell[BoxData[
    \(\((C[1] \[Element] Integers && 
          x \[Equal] 3 + 6\ \((\(-1\) + 4\ C[1] + 8\ C[1]\^2)\) && 
          y \[Equal] 3 + 6\ \((\(-1\) + C[1] + 4\ C[1]\^2)\) && 
          z \[Equal] 
            1\/3\ \((\(-2\)\ \((3 + 
                        6\ \((\(-1\) + C[1] + 4\ C[1]\^2)\))\)\ \((3 + 
                        6\ \((\(-1\) + 4\ C[1] + 
                              8\ C[1]\^2)\))\) + \((3 + 6\ \((\(-1\) + 4\ \
C[1] + 8\ C[1]\^2)\))\)\^2)\) && 
          t \[Equal] 
            1\/2\ \((\(-1\) + 
                  192\ \((3 + 6\ \((\(-1\) + 4\ C[1] + 8\ C[1]\^2)\))\)\^2 + 
                  33\ \((3 + 6\ \((\(-1\) + 4\ C[1] + 8\ C[1]\^2)\))\)\^3)\))\
\) || \((C[1] \[Element] Integers && 
          x \[Equal] 3 + 6\ \((3 + 12\ C[1] + 8\ C[1]\^2)\) && 
          y \[Equal] 6\ \((1 + 5\ C[1] + 4\ C[1]\^2)\) && 
          z \[Equal] 
            1\/3\ \((\(-12\)\ \((1 + 5\ C[1] + 4\ C[1]\^2)\)\ \((3 + 
                        6\ \((3 + 12\ C[1] + 
                              8\ C[1]\^2)\))\) + \((3 + 6\ \((3 + 12\ C[1] + \
8\ C[1]\^2)\))\)\^2)\) && 
          t \[Equal] 
            1\/2\ \((\(-1\) + 
                  192\ \((3 + 6\ \((3 + 12\ C[1] + 8\ C[1]\^2)\))\)\^2 + 
                  33\ \((3 + 6\ \((3 + 12\ C[1] + 8\ \
C[1]\^2)\))\)\^3)\))\)\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sums of Squares", "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve equations of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(x\_1\^2 + x\_2\^2 +  ... \) + x\_n\^2 \[Equal] 
      m\)], "NumberedEquation",
  CellTags->"SumOfSquares"],

Cell[TextData[{
  "using the algorithm described in [",
  ButtonBox["10",
    ButtonData:>"10",
    ButtonStyle->"Hyperlink"],
  "]. For multivariate quadratic equations, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " attempts to find an affine transformation that puts the equation in the \
form (",
  ButtonBox["9",
    ButtonData:>"SumOfSquares",
    ButtonStyle->"Hyperlink"],
  "). A heuristic method based on ",
  ButtonBox["CholeskyDecomposition",
    ButtonStyle->"RefGuideLink"],
  " is used for this purpose. However, the method may fail for some equations \
that can be represented in the form (",
  ButtonBox["9",
    ButtonData:>"SumOfSquares",
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell["This solves a sum of squares equation in three variables.", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\((x - 2\ y + 3\ z)\)\^2 + \((4\ y + 5\ z)\)\^2 + z\^2 \[Equal] 
        14, {x, y, z}, Integers]\)], "Input",
  CellLabel->"In[31]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-3\) && y \[Equal] \(-2\) && 
          z \[Equal] 18)\) || \((x \[Equal] \(-3\) && y \[Equal] \(-2\) && 
          z \[Equal] 20)\) || \((x \[Equal] \(-3\) && y \[Equal] \(-1\) && 
          z \[Equal] 13)\) || \((x \[Equal] \(-3\) && y \[Equal] \(-1\) && 
          z \[Equal] 15)\) || \((x \[Equal] \(-1\) && y \[Equal] \(-1\) && 
          z \[Equal] 5)\) || \((x \[Equal] \(-1\) && y \[Equal] \(-1\) && 
          z \[Equal] 11)\) || \((x \[Equal] \(-1\) && y \[Equal] 0 && 
          z \[Equal] 0)\) || \((x \[Equal] \(-1\) && y \[Equal] 0 && 
          z \[Equal] 6)\) || \((x \[Equal] 1 && y \[Equal] 0 && 
          z \[Equal] \(-6\))\) || \((x \[Equal] 1 && y \[Equal] 0 && 
          z \[Equal] 0)\) || \((x \[Equal] 1 && y \[Equal] 1 && 
          z \[Equal] \(-11\))\) || \((x \[Equal] 1 && y \[Equal] 1 && 
          z \[Equal] \(-5\))\) || \((x \[Equal] 3 && y \[Equal] 1 && 
          z \[Equal] \(-15\))\) || \((x \[Equal] 3 && y \[Equal] 1 && 
          z \[Equal] \(-13\))\) || \((x \[Equal] 3 && y \[Equal] 2 && 
          z \[Equal] \(-20\))\) || \((x \[Equal] 3 && y \[Equal] 2 && 
          z \[Equal] \(-18\))\)\)], "Output",
  CellLabel->"Out[31]="]
}, Open  ]],

Cell[TextData[{
  "To find a single solution of (",
  ButtonBox["9",
    ButtonData:>"SumOfSquares",
    ButtonStyle->"Hyperlink"],
  ") ",
  StyleBox["FindInstance", "MR"],
  " uses an algorithm based on [",
  ButtonBox["12",
    ButtonData:>"12",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "This finds a decomposition of a 10,000 digit integer into a sum of seven \
squares. ",
  StyleBox["N", "MR"],
  " is applied to make the printed result smaller."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeedRandom[1]; a = Random[Integer, {0, 10\^10000}]; 
    N[s7 = FindInstance[
            x\^2 + y\^2 + z\^2 + t\^2 + u\^2 + v\^2 + w\^2 \[Equal] a, {x, y, 
              z, t, u, v, w}, Integers]] // Timing\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \({8.390000000000033`\ Second, {{x \[Rule] 
            6.3083575932900092531508158986`15.954589770191005*^4999, 
          y \[Rule] 
            8.20951731251473756358734536429597`15.954589770191005*^2499, 
          z \[Rule] 8.9699436463956830539378396`15.954589770191005*^1249, 
          t \[Rule] 7.51735811395367081581113409`15.954589770191005*^624, 
          u \[Rule] 5.33926164282226537062919709`15.954589770191005*^624, 
          v \[Rule] 4.21353629091077393792030766`15.954589770191005*^624, 
          w \[Rule] 
            6.945666255274927599750065`15.954589770191005*^622}}}\)], "Output",\

  CellLabel->"Out[32]="]
}, Open  ]],

Cell["This proves that the decomposition found is correct.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x^2 + y^2 + z^2 + t^2 + u^2 + v^2 + w^2 - a /. s7\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \({0}\)], "Output",
  CellLabel->"Out[33]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations with Reducible Nonconstant Parts", "Subsection"],

Cell[TextData[{
  "If the sum of nonconstant terms in an equation factors, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the formula"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`f\ g = \(\(\(c\)\(\[DoubleLongLeftRightArrow]\)\)\( \
\[Or] \_\(d | c\)\)f = \(d \[And] g = c/d\)\)\)], "DisplayFormula"],

Cell["\<\
to reduce the equation to a disjunction of pairs of equations with \
lower degrees.\
\>", "Text"],

Cell["\<\
This cubic equation reduces to 12 pairs of quadratic and linear \
equations.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\((x - 2\ y + 3\ z)\)\ x\^2 - \((x - 2\ y + 
                3\ z)\)\ y\ z \[Equal] 18, {x, y, z}, Integers]\)], "Input",
  CellLabel->"In[34]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-71\) && y \[Equal] \(-112\) && 
          z \[Equal] \(-45\))\) || \((x \[Equal] \(-55\) && 
          y \[Equal] \(-82\) && 
          z \[Equal] \(-37\))\) || \((x \[Equal] \(-53\) && 
          y \[Equal] \(-80\) && 
          z \[Equal] \(-35\))\) || \((x \[Equal] \(-11\) && y \[Equal] 8 && 
          z \[Equal] 15)\) || \((x \[Equal] \(-9\) && y \[Equal] \(-12\) && 
          z \[Equal] \(-7\))\) || \((x \[Equal] \(-9\) && y \[Equal] 8 && 
          z \[Equal] 9)\) || \((x \[Equal] \(-9\) && y \[Equal] 10 && 
          z \[Equal] 9)\) || \((x \[Equal] \(-3\) && y \[Equal] \(-6\) && 
          z \[Equal] \(-1\))\) || \((x \[Equal] \(-1\) && y \[Equal] \(-2\) && 
          z \[Equal] 1)\) || \((x \[Equal] \(-1\) && y \[Equal] 4 && 
          z \[Equal] 1)\) || \((x \[Equal] 6 && y \[Equal] \(-6\) && 
          z \[Equal] \(-7\))\) || \((x \[Equal] 6 && y \[Equal] \(-6\) && 
          z \[Equal] \(-5\))\) || \((x \[Equal] 13 && y \[Equal] \(-10\) && 
          z \[Equal] \(-17\))\) || \((x \[Equal] 34 && y \[Equal] 50 && 
          z \[Equal] 23)\) || \((x \[Equal] 38 && y \[Equal] 58 && 
          z \[Equal] 25)\) || \((x \[Equal] 83 && y \[Equal] 130 && 
          z \[Equal] 53)\)\)], "Output",
  CellLabel->"Out[34]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations with a Linear Variable", "Subsection",
  CellTags->"LinVarEqn"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " attempts to solve Diophantine systems of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(f(x\_1,  ... , x\_n)\) y + 
          g(x\_1,  ... , x\_n) \[Equal] 0 \[And] \[CapitalPhi](x\_1,  ... , 
        x\_n, y)\)\(,\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n, y)\)]],
  " is a conjunction of inequalities or ",
  StyleBox["True", "MR"],
  ", by reducing them to"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`f(x\_1,  ... , x\_n) \[Equal] 0 \[And] 
        g(x\_1,  ... , x\_n) \[Equal] 0 \[And] \[CapitalPhi](x\_1,  ... , 
          x\_n, y) \[Or] 
      y \[Equal] \(-\(g(x\_1,  ... , x\_n)\)\)/\(f(x\_1,  ... , 
              x\_n)\) \[And] \(\(\[CapitalPhi](x\_1,  ... , 
            x\_n, \(-\(g(x\_1,  ... , x\_n)\)\)/\(f(x\_1,  ... , 
                x\_n)\))\)\(.\)\)\)], "NumberedEquation",
  CellTags->"LinVar"],

Cell[TextData[{
  "The first part of the system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") is solved using the method for solving ",
  ButtonBox["systems with more than one equation",
    ButtonData:>"ManyEqn",
    ButtonStyle->"Hyperlink"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recognizes three cases when the second part of the system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") is solvable. If ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_1,  ... , x\_n) \[Congruent] 1\)]],
  ", the solution is given by ",
  Cell[BoxData[
      \(TraditionalForm\`y \[Equal] \(-\(g(x\_1,  ... , x\_n)\)\)\)]],
  " and by the restrictions on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  " obtained by solving the inequalities ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , 
        x\_n, \(-\(g(x\_1,  ... , x\_n)\)\))\)]],
  ". Nonlinear systems of inequalities are solved using  ",
  ButtonBox["CylindricalDecomposition",
    ButtonStyle->"RefGuideLink"],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_1,  ... , x\_n) \[Congruent] m\)]],
  " for an integer constant ",
  Cell[BoxData[
      \(TraditionalForm\`m \[GreaterEqual] 2\)]],
  ", the solution of the second part of the system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") is given by ",
  Cell[BoxData[
      \(TraditionalForm\`y \[Equal] \(-\(g(x\_1,  ... , x\_n)\)\)/m\)]],
  " and by the restrictions on ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  " obtained by solving the congruence ",
  Cell[BoxData[
      \(TraditionalForm\`g(x\_1,  ... , x\_n) \[Congruent] 0\ mod\ m\)]],
  " and then solving the inequalities ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , 
        x\_n, \(-\(g(x\_1,  ... , x\_n)\)\)/m)\)]],
  " for each solution of the congruence. If ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_1,  ... , x\_n)\)]],
  " is nonconstant, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can solve the second part of the system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") if ",
  Cell[BoxData[
      \(TraditionalForm\`n = 1\)]],
  ". Since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " factors all equations at the preprocessing stage, ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_1)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g(x\_1)\)]],
  " can be assumed to be relatively prime. Then"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`d\ \(g(x\_1)\) = \(q(x\_1)\) \(f(x\_1)\) + 
        r(x\_1)\)], "DisplayFormula"],

Cell[TextData[{
  "for an integer ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  " and polynomials ",
  Cell[BoxData[
      \(TraditionalForm\`q(x\_1)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r(x\_1)\)]],
  " with integer coefficients and ",
  Cell[BoxData[
      \(TraditionalForm\`deg(r) < deg(f)\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\(g(x\_1)\)\)/\(f(x\_1)\)\)]],
  " is an integer, then ",
  Cell[BoxData[
      \(TraditionalForm\`\(r(x\_1)\)/\(f(x\_1)\)\)]],
  " is an integer, and so ",
  Cell[BoxData[
      \(TraditionalForm\`r(x\_1) \[Equal] 0\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(r(
          x\_1)\)\(|\)\(\(\[GreaterEqual]\)\(\ \)\(\(|\)\(f(
              x\_1)\)\(|\)\)\)\)\)]],
  ". Since ",
  Cell[BoxData[
      \(TraditionalForm\`deg(r) < deg(f)\)]],
  ", the last condition is satisfied only by a finite number of integers ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ". Hence the solutions of the second part of the system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") can be selected from a finite number of solution candidates. "
}], "Text"],

Cell[TextData[{
  "Additionally, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the following heuristic to detect cases when the system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") has no solutions. If there is an integer ",
  Cell[BoxData[
      \(TraditionalForm\`m \[GreaterEqual] 2\)]],
  ", such that ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_1,  ... , x\_n)\)]],
  " is always divisible by ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`g(x\_1,  ... , x\_n)\)]],
  " is never divisible by ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", then the system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") has no solutions. Candidates for ",
  StyleBox["m",
    FontSlant->"Italic"],
  " are found by computing the ",
  StyleBox["GCD", "MR"],
  " of the values of ",
  StyleBox["f",
    FontSlant->"Italic"],
  " at several points."
}], "Text"],

Cell[TextData[{
  "The last two methods use exhaustive search over finite sets of points. The \
allowed number of search points is controlled by the system option ",
  StyleBox[ButtonBox["SieveMaxPoints",
    ButtonData:>"SieveMaxPoints",
    ButtonStyle->"Hyperlink"], "MR"],
  ". "
}], "Text"],

Cell[TextData[{
  "This reduces to (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") with ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_1,  ... , x\_n) \[Congruent] 1\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^3 - 7\ x\ y + 5\ y\^4 - z \[Equal] 3 && 2\ x - y > 1, {x, y, z}, 
      Integers]\)], "Input",
  CellLabel->"In[35]:="],

Cell[BoxData[
    \(\((C[1] | C[2] | C[3] | C[4] | C[5])\) \[Element] Integers && 
      C[1] \[GreaterEqual] 0 && C[2] \[GreaterEqual] 0 && 
      C[3] \[GreaterEqual] 0 && C[4] \[GreaterEqual] 0 && 
      C[5] \[GreaterEqual] 
        0 && \((\((x \[Equal] 1 + C[1] + C[2] + C[3] - C[4] && 
              y \[Equal] C[1] + 2\ C[2] - 2\ C[4] - C[5])\) || \((x \[Equal] 
                C[1] + C[2] + C[3] - C[4] && 
              y \[Equal] \(-2\) + C[1] + 2\ C[2] - 2\ C[4] - C[5])\))\) && 
      z \[Equal] \(-3\) + x\^3 - 7\ x\ y + 5\ y\^4\)], "Output",
  CellLabel->"Out[35]="]
}, Open  ]],

Cell[TextData[{
  "This reduces to (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ") with ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_1,  ... , x\_n) \[Congruent] 3\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 2\ x\^2\ y + 9\ x\ y\^4 - 3\ z \[Equal] 8, {x, y, z}, 
      Integers]\)], "Input",
  CellLabel->"In[36]:="],

Cell[BoxData[
    \(\((C[1] | C[2])\) \[Element] 
        Integers && \((\((x \[Equal] 1 + 3\ C[1] && 
              y \[Equal] 1 + 3\ C[2])\) || \((x \[Equal] 2 + 3\ C[1] && 
              y \[Equal] 3\ C[2])\))\) && 
      z \[Equal] 
        1\/3\ \((\(-8\) + x\^3 - 2\ x\^2\ y + 9\ x\ y\^4)\)\)], "Output",
  CellLabel->"Out[36]="]
}, Open  ]],

Cell[TextData[{
  "This reduces to the ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Equal] 1\)]],
  " case of system (",
  ButtonBox["10",
    ButtonData:>"LinVar",
    ButtonStyle->"Hyperlink"],
  ")."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x\^5 + 7\ x - 271 + y\ \((x\^3 + 21\ x\^2 - 17)\) \[Equal] 0, {x, y}, 
      Integers]\)], "Input",
  CellLabel->"In[37]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-1\) && y \[Equal] 93)\) || \((x \[Equal] 2 && 
          y \[Equal] 3)\)\)], "Output",
  CellLabel->"Out[37]="]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " detects that the equation has no solutions, because ",
  Cell[BoxData[
      \(TraditionalForm\`9\ x\^6\ y\^3\ z\^4 - 9\ x\^2\ y\^3\ z\^8 - 
        5\ y\^8\ z\^9 - 10\)]],
  " is always divisible by 5, and ",
  Cell[BoxData[
      \(TraditionalForm\`7 - 5\ x\^4\ y\ z\^4 + 7\ x\^8\ y\^2\ z\^4 - 
        9\ z\^8 - 4\ x\^6\ y\ z\^8\)]],
  " is never divisible by 5."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\((9\ x\^6\ y\^3\ z\^4 - 9\ x\^2\ y\^3\ z\^8 - 5\ y\^8\ z\^9 - 
                10)\)\ t + 7 - 5\ x\^4\ y\ z\^4 + 7\ x\^8\ y\^2\ z\^4 - 
          9\ z\^8 - 4\ x\^6\ y\ z\^8 \[Equal] 0, {x, y, z, t}, 
      Integers]\)], "Input",
  CellLabel->"In[38]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[38]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems with Empty or Bounded Real Solution Sets", "Subsection"],

Cell[TextData[{
  "If a Diophantine polynomial system is not solved by any other methods, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " solves the system over the reals using the Cylindrical Algebraic \
Decomposition (CAD) algorithm. If the system has no real solutions, then \
clearly it has no integer solutions. If the real solution set is bounded, \
then the number of integer solutions is finite. In principle, all the integer \
solutions can be found in this case from a cylindrical decomposition. Namely, \
for each cylinder, we enumerate all possible integer values of the first \
coordinate, then for each value of the first coordinate, we enumerate all \
possible integer values of the second coordinate, and so on. However, for \
large bounded solution sets this method could lead to a huge number of points \
to try. Therefore, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has a bound on the number of explicitly enumerated integer solutions in a \
real interval. By default this bound is equal to 10. It can be changed using \
the system option ",
  StyleBox[ButtonBox["DiscreteSolutionBound",
    ButtonData:>"DiscreteSolutionBound",
    ButtonStyle->"Hyperlink"], "MR"],
  ". For systems for which the real solution set is unbounded or bounded but \
large, the solution is represented implicitly by returning CAD and a \
condition that all variables are integers. Note that for multivariate systems \
such an implicit representation may not even be enough to tell whether \
integer solutions exist. This should be expected, given Matiyasevich's \
solution of Hilbert's tenth problem [",
  ButtonBox["2",
    ButtonData:>"2",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "Here the real solution set is bounded, but ",
  StyleBox["Reduce", "MR"],
  " gives some cylinders in an implicit form. This is because some of the \
intervals bounding ",
  StyleBox["y",
    FontSlant->"Italic"],
  " contain more than 10 integers."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      x^5 + y^2 + z^3 - x\ y\ z \[Equal] 8 && x^2 + y^2 \[LessEqual] 30, {x, 
        y, z}, Integers]\)], "Input",
  CellLabel->"In[39]:="],

Cell[BoxData[
    \(\((y | z)\) \[Element] 
        Integers && \((\((x \[Equal] \(-2\) && \(-5\) \[LessEqual] 
                y \[LessEqual] 5 && 
              z \[Equal] 
                Root[\(-40\) + y\^2 + 2\ y\ #1 + #1\^3 &, 
                  1])\) || \((x \[Equal] \(-1\) && \((\((y \[Equal] \(-3\) && 
                      z \[Equal] 0)\) || \((y \[Equal] 3 && 
                      z \[Equal] 0)\))\))\) || \((x \[Equal] 
                0 && \((\((y \[Equal] \(-4\) && 
                      z \[Equal] \(-2\))\) || \((y \[Equal] \(-3\) && 
                      z \[Equal] \(-1\))\) || \((y \[Equal] 0 && 
                      z \[Equal] 2)\) || \((y \[Equal] 3 && 
                      z \[Equal] \(-1\))\) || \((y \[Equal] 4 && 
                      z \[Equal] \(-2\))\))\))\) || \((x \[Equal] 
                1 && \((\((y \[Equal] \(-5\) && 
                      z \[Equal] \(-2\))\) || \((y \[Equal] \(-2\) && 
                      z \[Equal] 1)\) || \((y \[Equal] 1 && 
                      z \[Equal] 2)\) || \((y \[Equal] 
                        3 && \((z \[Equal] \(-2\) || 
                          z \[Equal] 1)\))\))\))\) || \((x \[Equal] 
                2 && \(-5\) \[LessEqual] y \[LessEqual] 5 && 
              z \[Equal] 
                Root[24 + y\^2 - 2\ y\ #1 + #1\^3 &, 1])\))\)\)], "Output",
  CellLabel->"Out[39]="]
}, Open  ]],

Cell[TextData[{
  "Increasing the value of the system option ",
  StyleBox[ButtonBox["DiscreteSolutionBound",
    ButtonData:>"DiscreteSolutionBound",
    ButtonStyle->"Hyperlink"], "MR"],
  " allows ",
  StyleBox["Reduce", "MR"],
  " to find all integer solutions explicitly."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<DiscreteSolutionBound\>" \[Rule] 11}];\)\), "\[IndentingNewLine]", 
    \(Reduce[
      x^5 + y^2 + z^3 - x\ y\ z \[Equal] 8 && x^2 + y^2 \[LessEqual] 30, {x, 
        y, z}, Integers]\)}], "Input",
  CellLabel->"In[40]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-1\) && \((\((y \[Equal] \(-3\) && 
                  z \[Equal] 0)\) || \((y \[Equal] 3 && 
                  z \[Equal] 0)\))\))\) || \((x \[Equal] 
            0 && \((\((y \[Equal] \(-4\) && 
                  z \[Equal] \(-2\))\) || \((y \[Equal] \(-3\) && 
                  z \[Equal] \(-1\))\) || \((y \[Equal] 0 && 
                  z \[Equal] 2)\) || \((y \[Equal] 3 && 
                  z \[Equal] \(-1\))\) || \((y \[Equal] 4 && 
                  z \[Equal] \(-2\))\))\))\) || \((x \[Equal] 
            1 && \((\((y \[Equal] \(-5\) && 
                  z \[Equal] \(-2\))\) || \((y \[Equal] \(-2\) && 
                  z \[Equal] 1)\) || \((y \[Equal] 1 && 
                  z \[Equal] 2)\) || \((y \[Equal] 
                    3 && \((z \[Equal] \(-2\) || 
                      z \[Equal] 1)\))\))\))\) || \((x \[Equal] \(-2\) && 
          y \[Equal] 4 && z \[Equal] 2)\)\)], "Output",
  CellLabel->"Out[41]="]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["DiscreteSolutionBound", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<DiscreteSolutionBound\>" \[Rule] 10}];\)\)], "Input",
  CellLabel->"In[42]:="],

Cell[TextData[{
  "Here ",
  ButtonBox["the modular sieve method",
    ButtonData:>"Sieve",
    ButtonStyle->"Hyperlink"],
  " shows that there are no solutions in ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-15\), 15]\)\^3\)]],
  ". After adding the corresponding inequalities, ",
  StyleBox["Reduce", "MR"],
  " shows that this equation has no solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      9\ x\^2\ y\^2 + 7\ x\^2\ z\^2 + 5\ y\^2\ z\^2 \[Equal] 
        x\ y\ z + 10, {x, y, z}, Integers]\)], "Input",
  CellLabel->"In[43]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[43]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Equations of the Form ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(g(x, y, z\_1,  ... , z\_n)\) + y \[Equal] c\)]]
}], "Subsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " attempts to solve Diophantine systems of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(x\ \(g(x, y, z\_1,  ... , z\_n)\) + y \[Equal] 
        c \[And] \[CapitalPhi](x, y, z\_1,  ... , 
        z\_n)\)\(,\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x, y, z\_1,  ... , z\_n)\)]],
  " is a conjunction of inequalities or ",
  StyleBox["True", "MR"],
  ", by transforming them to"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`x \[Equal] 0 \[And] 
        y \[Equal] c \[And] \[CapitalPhi](0, c, z\_1,  ... , z\_n) \[Or] 
      y \[Equal] c + t\ x \[And] 
        g(x, c + t\ x, z\_1,  ... , z\_n) + t \[Equal] 
          0 \[And] \(\(\[CapitalPhi](x, c + t\ x, z\_1,  ... , 
            z\_n)\)\(.\)\)\)], "NumberedEquation",
  CellTags->"DivisibilityHeuristic"],

Cell[TextData[{
  "The resulting system (",
  ButtonBox["11",
    ButtonData:>"DivisibilityHeuristic",
    ButtonStyle->"Hyperlink"],
  ") may, or may not, be easier to solve. Systems exist for which this \
transformation could be applied recursively arbitrarily many times; \
therefore, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a recursion bound to ensure the heuristic terminates. "
}], "Text"],

Cell[TextData[{
  "This transforms to a system (",
  ButtonBox["11",
    ButtonData:>"DivisibilityHeuristic",
    ButtonStyle->"Hyperlink"],
  ") with no real solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\(-x\^2\) + y + x\ y + x\ z \[Equal] 0 && x > 0 && y > 0 && 
        z > 0, {x, y, z}, Integers]\)], "Input",
  CellLabel->"In[44]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[44]="]
}, Open  ]],

Cell[TextData[{
  "Here the system (",
  ButtonBox["11",
    ButtonData:>"DivisibilityHeuristic",
    ButtonStyle->"Hyperlink"],
  ") obtained after three recursive transformations has a reducible \
nonconstant part."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 2\ x\ y\^2 + 20\ x\ y + y \[Equal] 5, {x, y}, 
      Integers]\)], "Input",
  CellLabel->"In[45]:="],

Cell[BoxData[
    \(\((x \[Equal] \(-7\) && y \[Equal] 12)\) || \((x \[Equal] 0 && 
          y \[Equal] 5)\) || \((x \[Equal] 7 && 
          y \[Equal] \(-2\))\)\)], "Output",
  CellLabel->"Out[45]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems Solvable by Exhaustive Search", "Subsection",
  CellTags->"ExhaustiveSearch"],

Cell[TextData[{
  "For systems containing explicit lower and upper bounds on all variables, \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses exhaustive search to find solutions. The bounds of the search are \
specified by the value of the system option ",
  StyleBox[ButtonBox["ExhaustiveSearchMaxPoints",
    ButtonData:>"ExhaustiveSearchMaxPoints",
    ButtonStyle->"Hyperlink"], "MR"],
  ". The option value should be a pair of integers (the default is {1,000, \
10,000}). If the number of integer points within the bounds does not exceed \
the first integer, the exhaustive search is used instead of any solution \
methods other than univariate polynomial solving. Otherwise, if the number of \
integer points within the bounds does not exceed the second integer, the \
exhaustive search is performed after all other methods fail."
}], "Text"],

Cell["\<\
This transcendental Diophantine equation with bounded variable \
values is solved by exhaustive search.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      Sin[\(\[Pi]\ x\ y\)\/2]\^2 \[Equal] Gamma[21\ x - 37\ y] && 
        0 < x < 100 && 1 \[LessEqual] y \[LessEqual] 100, x, 
      Integers]\)], "Input",
  CellLabel->"In[46]:="],

Cell[BoxData[
    \(\((y \[Equal] 13 && x \[Equal] 23)\) || \((y \[Equal] 55 && 
          x \[Equal] 97)\)\)], "Output",
  CellLabel->"Out[46]="]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Section"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions for solving real polynomial systems have a number of options \
that control the way they operate. This section gives a summary of these \
options."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["GeneratedParameters",
              "MR"], 
            StyleBox["C",
              
              "MR"], \(specifies\ how\ the\ new\ parameters\ generated\ to\ \
represent\ solutions\ should\ be\ named\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " options affecting the behavior for Diophantine polynomial systems."
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["GeneratedParameters",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "To represent infinite solutions of some Diophantine systems, ",
  StyleBox["Reduce", "MR"],
  " needs to introduce new integer parameters. The names of the new \
parameters are specified by the option ",
  StyleBox["GeneratedParameters", "MR"],
  ". With ",
  StyleBox["GeneratedParameters", "MR"],
  " -> ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", the new parameters are named ",
  StyleBox["f",
    FontSlant->"Italic"],
  StyleBox["[1]", "MR"],
  ", ",
  StyleBox["f",
    FontSlant->"Italic"],
  StyleBox["[2]", "MR"],
  ", \[Ellipsis]."
}], "Text"],

Cell[TextData[{
  "By default, the new parameters generated by ",
  StyleBox["Reduce", "MR"],
  " are named ",
  StyleBox["C[1]", "MR"],
  ", ",
  StyleBox["C[2]", "MR"],
  ", \[Ellipsis]."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x + y + z \[Equal] 2 && x > y + 1, {x, y, z}, 
      Integers]\)], "Input",
  CellLabel->"In[47]:="],

Cell[BoxData[
    \(\((C[1] | C[2] | C[3] | C[4] | C[5])\) \[Element] Integers && 
      C[1] \[GreaterEqual] 0 && C[2] \[GreaterEqual] 0 && 
      C[3] \[GreaterEqual] 0 && C[4] \[GreaterEqual] 0 && 
      C[5] \[GreaterEqual] 
        0 && \((\((x \[Equal] 1 + C[1] + C[2] + C[3] - C[4] && 
              y \[Equal] \(-1\) + C[1] - C[3] - C[4] - C[5] && 
              z \[Equal] 
                2 - 2\ C[1] - C[2] + 2\ C[4] + C[5])\) || \((x \[Equal] 
                2 + C[1] + C[2] + C[3] - C[4] && 
              y \[Equal] C[1] - C[3] - C[4] - C[5] && 
              z \[Equal] \(-2\)\ C[1] - C[2] + 2\ C[4] + 
                  C[5])\) || \((x \[Equal] C[1] + C[2] + C[3] - C[4] && 
              y \[Equal] \(-2\) + C[1] - C[3] - C[4] - C[5] && 
              z \[Equal] 
                4 - 2\ C[1] - C[2] + 2\ C[4] + C[5])\))\)\)], "Output",
  CellLabel->"Out[47]="]
}, Open  ]],

Cell[TextData[{
  " The option ",
  StyleBox["GeneratedParameters", "MR"],
  " allows users to customize the parameter names."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x + y + z \[Equal] 2 && x > y + 1, {x, y, z}, Integers, 
      GeneratedParameters \[Rule] \((Subscript[k, #] &)\)]\)], "Input",
  CellLabel->"In[48]:="],

Cell[BoxData[
    \(\((k\_1 | k\_2 | k\_3 | k\_4 | k\_5)\) \[Element] Integers && 
      k\_1 \[GreaterEqual] 0 && k\_2 \[GreaterEqual] 0 && 
      k\_3 \[GreaterEqual] 0 && k\_4 \[GreaterEqual] 0 && 
      k\_5 \[GreaterEqual] 
        0 && \((\((x \[Equal] 1 + k\_1 + k\_2 + k\_3 - k\_4 && 
              y \[Equal] \(-1\) + k\_1 - k\_3 - k\_4 - k\_5 && 
              z \[Equal] 
                2 - 2\ k\_1 - k\_2 + 2\ k\_4 + k\_5)\) || \((x \[Equal] 
                2 + k\_1 + k\_2 + k\_3 - k\_4 && 
              y \[Equal] k\_1 - k\_3 - k\_4 - k\_5 && 
              z \[Equal] \(-2\)\ k\_1 - k\_2 + 2\ k\_4 + 
                  k\_5)\) || \((x \[Equal] k\_1 + k\_2 + k\_3 - k\_4 && 
              y \[Equal] \(-2\) + k\_1 - k\_3 - k\_4 - k\_5 && 
              z \[Equal] 
                4 - 2\ k\_1 - k\_2 + 2\ k\_4 + k\_5)\))\)\)], "Output",
  CellLabel->"Out[48]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReduceOptions Group of System Options", "Subsection"],

Cell[TextData[{
  "Here are the system options from the ",
  StyleBox["ReduceOptions", "MR"],
  " group that may affect the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for Diophantine polynomial systems. The options can be set with"
}], "Text"],

Cell["\<\
Developer`SetSystemOptions[\"ReduceOptions\" -> {\"option name\"-> \
value}].\
\>", "Program"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {Cell[TextData[StyleBox["\"BranchLinearDiophantine\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            RowBox[{
              RowBox[{"whether", " ", 
                StyleBox["Reduce",
                  "MR"], " ", "should", " ", "use", " ", "a", " ", "branch"}],
               "-", "and", 
              "-", \(bound\ type\ algorithm\ to\ compute\ solutions\ of\ \
bounded\ systems\ of\ linear\ Diophantine\ inequalities\)}]},
          {Cell[TextData[StyleBox["\"DiscreteSolutionBound\"", "MR"]]], 
            "10", \(the\ bound\ on\ the\ number\ of\ explicitly\ enumerated\ \
integer\ solutions\ in\ a\ real\ interval\)},
          {Cell[TextData[StyleBox[
            "\"ExhaustiveSearchMaxPoints\"", "MR"]]], \({1, 000, 10, 
              000}\), \(the\ maximal\ number\ of\ integer\ points\ within\ \
variable\ bounds\ for\ which\ the\ exhaustive\ search\ is\ used\ before\ and\ \
after\ all\ other\ solution\ methods\)},
          {Cell[TextData[StyleBox["\"LatticeReduceDiophantine\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            RowBox[{"whether", " ", 
              StyleBox["LatticeReduce",
                "MR"], " ", "should", " ", "be", " ", "used", " ", "to", " ", 
              "preprocess", " ", "bounded", " ", "systems", " ", "of", " ", 
              "linear", " ", "Diophantine", " ", "inequalities"}]},
          {Cell[TextData[StyleBox["\"MaxFrobeniusGraph\"", "MR"]]], \(1, 000, 
            000\), 
            RowBox[{
            "the", " ", "maximal", " ", "size", " ", "of", " ", "the", " ", 
              "smallest", " ", "coefficient", " ", "in", " ", "a", " ", 
              "Frobenius", " ", "equation", " ", "for", " ", "which", " ", 
              StyleBox["FindInstance",
                "MR"], " ", "computes", " ", "the", " ", "critical", " ", 
              "tree", " ", "in", " ", "the", " ", "Frobenius", " ", 
              "graph"}]},
          {Cell[TextData[StyleBox["\"SieveMaxPoints\"", "MR"]]], \(10, 
            000\), \(the\ maximal\ number\ of\ points\ at\ which\ the\ \
modular\ sieve\ method\ evaluates\ the\ system\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  StyleBox["ReduceOptions", "MR"],
  " group options affecting the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for real polynomial systems."
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["BranchLinearDiophantine",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"BranchLinearDiophantine"],

Cell[TextData[{
  "The value of the system option ",
  StyleBox["BranchLinearDiophantine", "MR"],
  " specifies which variant of the algorithm should be used in ",
  ButtonBox["the final stage of solving bounded linear systems",
    ButtonData:>"PolyhedronIntegerPoints",
    ButtonStyle->"Hyperlink"],
  ". Neither variant seems to be clearly better. For some examples the hybrid \
method combining a branch-and-bound type algorithm and a simple recursive \
enumeration is faster; for other examples the simple recursive enumeration \
alone is faster. The hybrid method seems to be more robust for badly \
conditioned problems, hence it is the default method."
}], "Text"],

Cell["\<\
This finds integer points in a long, narrow four-dimensional \
simplex using the default hybrid method.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(a = 10000;\)\), "\n", 
    \(\(Reduce[
          a\ x + a\ y + a\ z - 3\ \((a - 1)\)\ t \[LessEqual] 3\ a && 
            a\ x + a\ y + a\ t - 3\ \((a - 1)\)\ z \[LessEqual] 3\ a && 
            a\ x + a\ z + a\ t - 3\ \((a - 1)\)\ y \[LessEqual] 3\ a && 
            a\ y + a\ z + a\ t - 3\ \((a - 1)\)\ x \[LessEqual] 3\ a && 
            x + y + z + t \[GreaterEqual] 1 && x < y && z < t, {x, y, z, t}, 
          Integers] // Length\) // Timing\)}], "Input",
  CellLabel->"In[49]:="],

Cell[BoxData[
    \({0.4899999999999455`\ Second, 3336}\)], "Output",
  CellLabel->"Out[50]="]
}, Open  ]],

Cell[TextData[{
  "This sets the value of the system option ",
  StyleBox["BranchLinearDiophantine", "MR"],
  " to ",
  StyleBox["False", "MR"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<BranchLinearDiophantine\>" \[Rule] False}]; \)], "Input",
  CellLabel->"In[51]:="],

Cell["\<\
Here the simple recursive enumeration method is used, and for this \
badly conditioned problem it is 10 times slower. \
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Reduce[
          a\ x + a\ y + a\ z - 3\ \((a - 1)\)\ t \[LessEqual] 3\ a && 
            a\ x + a\ y + a\ t - 3\ \((a - 1)\)\ z \[LessEqual] 3\ a && 
            a\ x + a\ z + a\ t - 3\ \((a - 1)\)\ y \[LessEqual] 3\ a && 
            a\ y + a\ z + a\ t - 3\ \((a - 1)\)\ x \[LessEqual] 3\ a && 
            x + y + z + t \[GreaterEqual] 1 && x < y && z < t, {x, y, z, t}, 
          Integers] // Length\) // Timing\)], "Input",
  CellLabel->"In[52]:="],

Cell[BoxData[
    \({4.699999999999945`\ Second, 3336}\)], "Output",
  CellLabel->"Out[52]="]
}, Open  ]],

Cell[TextData[{
  "This resets the value of the system option ",
  StyleBox["BranchLinearDiophantine", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<BranchLinearDiophantine\>" \[Rule] True}]; \)], "Input",
  CellLabel->"In[53]:="],

Cell[TextData[{
  "Here are solutions of a system of two randomly generated equations ",
  StyleBox["eqns",
    FontSlant->"Italic"],
  " and three randomly generated inequalities ",
  StyleBox["ineqs",
    FontSlant->"Italic"],
  " in seven variables inside a simplex bounded by ",
  StyleBox["bds",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SeedRandom[1]; \), "\n", 
    \(A = Table[Random[Integer, {\(-1000\), 1000}], {2}, {7}]; \), "\n", 
    \(a = Table[Random[Integer, {\(-1000\), 1000}], {2}]; \), "\n", 
    \(B = Table[Random[Integer, {\(-1000\), 1000}], {3}, {7}]; 
    b = Table[Random[Integer, {\(-1000\), 1000}], {3}]; \), "\n", 
    \(X = x /@ Range[7]; \), "\n", 
    \(eqns = And @@ Thread[A . X \[Equal] a]; \), "\n", 
    \(ineqs = And @@ Thread[B . X \[GreaterEqual] b]; \), "\n", 
    \(\(bds = 
        And @@ Thread[X \[GreaterEqual] 0] && 
          Total[X] \[LessEqual] 100;\)\), "\n", 
    \(Reduce[eqns && ineqs && bds, X, Integers] // Timing\)}], "Input",
  CellLabel->"In[54]:="],

Cell[BoxData[
    \({8.530000000000022`\ Second, \((x[1] \[Equal] 9 && x[2] \[Equal] 8 && 
            x[3] \[Equal] 2 && x[4] \[Equal] 14 && x[5] \[Equal] 20 && 
            x[6] \[Equal] 22 && x[7] \[Equal] 13)\) || \((x[1] \[Equal] 12 && 
            x[2] \[Equal] 15 && x[3] \[Equal] 0 && x[4] \[Equal] 12 && 
            x[5] \[Equal] 11 && x[6] \[Equal] 22 && 
            x[7] \[Equal] 18)\)}\)], "Output",
  CellLabel->"Out[62]="]
}, Open  ]],

Cell["\<\
For this system the nondefault simple recursion method is faster.\
\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<BranchLinearDiophantine\>" \[Rule] False}];\)\), "\n", 
    \(Reduce[eqns && ineqs && bds, X, Integers] // Timing\)}], "Input",
  CellLabel->"In[63]:="],

Cell[BoxData[
    \({1.80000000000005`\ Second, \((x[1] \[Equal] 9 && x[2] \[Equal] 8 && 
            x[3] \[Equal] 2 && x[4] \[Equal] 14 && x[5] \[Equal] 20 && 
            x[6] \[Equal] 22 && x[7] \[Equal] 13)\) || \((x[1] \[Equal] 12 && 
            x[2] \[Equal] 15 && x[3] \[Equal] 0 && x[4] \[Equal] 12 && 
            x[5] \[Equal] 11 && x[6] \[Equal] 22 && 
            x[7] \[Equal] 18)\)}\)], "Output",
  CellLabel->"Out[64]="]
}, Open  ]],

Cell[TextData[{
  "Here is a random system very similar to the previous one, except that it \
contains one more variable and the right-hand side of the last of ",
  StyleBox["bds",
    FontSlant->"Italic"],
  " is changed from 100 to 200. However, for this system the default method \
is faster."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<BranchLinearDiophantine\>" \[Rule] True}]; \), "\n", 
    \(SeedRandom[1]; \), "\n", 
    \(A = Table[Random[Integer, {\(-1000\), 1000}], {2}, {8}]; \), "\n", 
    \(a = Table[Random[Integer, {\(-1000\), 1000}], {2}]; \), "\n", 
    \(B = Table[Random[Integer, {\(-1000\), 1000}], {3}, {8}]; 
    b = Table[Random[Integer, {\(-1000\), 1000}], {3}]; \), "\n", 
    \(X = x /@ Range[8]; \), "\n", 
    \(eqns = And @@ Thread[A . X \[Equal] a]; \), "\n", 
    \(ineqs = And @@ Thread[B . X \[GreaterEqual] b]; \), "\n", 
    \(\(bds = 
        And @@ Thread[X \[GreaterEqual] 0] && 
          Total[X] \[LessEqual] 200;\)\), "\n", 
    \(Reduce[eqns && ineqs && bds, X, Integers] // Timing\)}], "Input",
  CellLabel->"In[65]:="],

Cell[BoxData[
    \({19.429999999999982`\ Second, \((x[1] \[Equal] 2 && x[2] \[Equal] 6 && 
            x[3] \[Equal] 27 && x[4] \[Equal] 35 && x[5] \[Equal] 0 && 
            x[6] \[Equal] 6 && x[7] \[Equal] 0 && 
            x[8] \[Equal] 38)\) || \((x[1] \[Equal] 10 && x[2] \[Equal] 1 && 
            x[3] \[Equal] 48 && x[4] \[Equal] 54 && x[5] \[Equal] 1 && 
            x[6] \[Equal] 1 && x[7] \[Equal] 1 && 
            x[8] \[Equal] 55)\)}\)], "Output",
  CellLabel->"Out[74]="]
}, Open  ]],

Cell["The nondefault method is slower for this system.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<BranchLinearDiophantine\>" \[Rule] False}];\)\), "\n", 
    \(Reduce[eqns && ineqs && bds, X, Integers] // Timing\)}], "Input",
  CellLabel->"In[75]:="],

Cell[BoxData[
    \({57.78000000000003`\ Second, \((x[1] \[Equal] 2 && x[2] \[Equal] 6 && 
            x[3] \[Equal] 27 && x[4] \[Equal] 35 && x[5] \[Equal] 0 && 
            x[6] \[Equal] 6 && x[7] \[Equal] 0 && 
            x[8] \[Equal] 38)\) || \((x[1] \[Equal] 10 && x[2] \[Equal] 1 && 
            x[3] \[Equal] 48 && x[4] \[Equal] 54 && x[5] \[Equal] 1 && 
            x[6] \[Equal] 1 && x[7] \[Equal] 1 && 
            x[8] \[Equal] 55)\)}\)], "Output",
  CellLabel->"Out[76]="]
}, Open  ]],

Cell[TextData[{
  "This resets the value of the system option ",
  StyleBox["BranchLinearDiophantine", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<BranchLinearDiophantine\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[77]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["DiscreteSolutionBound",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"DiscreteSolutionBound"],

Cell[TextData[{
  "The value of the system option ",
  StyleBox["DiscreteSolutionBound", "MR"],
  " specifies whether integer solutions in a real interval ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] x \[LessEqual] b\)]],
  " should be enumerated explicitly or represented implicitly as ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalZ]\  \[And] 
        a \[LessEqual] x \[LessEqual] b\)]],
  ". With ",
  StyleBox["DiscreteSolutionBound", "MR"],
  " -> ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", the integer solutions in the given real interval are enumerated \
explicitly if their number does not exceed ",
  StyleBox["n",
    FontSlant->"Italic"],
  ". The default value of the option is 10. "
}], "Text"],

Cell[TextData[{
  "There are 10 integers in the real interval ",
  Cell[BoxData[
      \(0 \[LessEqual] x < 10\)]],
  ". ",
  StyleBox["Reduce", "MR"],
  " writes them out explicitly. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[0 \[LessEqual] x\^3 < 1000, Integers]\)], "Input",
  CellLabel->"In[78]:="],

Cell[BoxData[
    \(x \[Equal] 0 || x \[Equal] 1 || x \[Equal] 2 || x \[Equal] 3 || 
      x \[Equal] 4 || x \[Equal] 5 || x \[Equal] 6 || x \[Equal] 7 || 
      x \[Equal] 8 || x \[Equal] 9\)], "Output",
  CellLabel->"Out[78]="]
}, Open  ]],

Cell[TextData[{
  "There are 11 integers in the real interval ",
  Cell[BoxData[
      \(0 \[LessEqual] x < 1001\^\(1/3\)\)]],
  ". ",
  StyleBox["Reduce", "MR"],
  " represents them implicitly."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[0 \[LessEqual] x\^3 < 1001, Integers]\)], "Input",
  CellLabel->"In[79]:="],

Cell[BoxData[
    \(x \[Element] Integers && 0 \[LessEqual] x \[LessEqual] 10\)], "Output",
  CellLabel->"Out[79]="]
}, Open  ]],

Cell[TextData[{
  "This increases the ",
  StyleBox["DiscreteSolutionBound", "MR"],
  " to 11."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<DiscreteSolutionBound\>" \[Rule] 11}];\)\)], "Input",
  CellLabel->"In[80]:="],

Cell[TextData[{
  "Now ",
  StyleBox["Reduce", "MR"],
  " represents the solutions explicitly."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[0 \[LessEqual] x\^3 < 1001, Integers]\)], "Input",
  CellLabel->"In[81]:="],

Cell[BoxData[
    \(x \[Equal] 0 || x \[Equal] 1 || x \[Equal] 2 || x \[Equal] 3 || 
      x \[Equal] 4 || x \[Equal] 5 || x \[Equal] 6 || x \[Equal] 7 || 
      x \[Equal] 8 || x \[Equal] 9 || x \[Equal] 10\)], "Output",
  CellLabel->"Out[81]="]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["DiscreteSolutionBound", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<DiscreteSolutionBound\>" \[Rule] 10}];\)\)], "Input",
  CellLabel->"In[82]:="],

Cell[TextData[{
  "The value of ",
  StyleBox["DiscreteSolutionBound", "MR"],
  " also affects ",
  ButtonBox["the solving of bounded linear systems",
    ButtonData:>"BoundedSolutionLimits",
    ButtonStyle->"Hyperlink"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ExhaustiveSearchMaxPoints", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"ExhaustiveSearchMaxPoints"],

Cell[TextData[{
  "The system option ",
  StyleBox["ExhaustiveSearchMaxPoints", "MR"],
  " specifies the maximal number of search points used by ",
  ButtonBox["the exhaustive search method",
    ButtonData:>"ExhaustiveSearch",
    ButtonStyle->"Hyperlink"],
  ". The option value should be a pair of integers (the default is {1,000, \
10,000}). If the number of integer points within the bounds does not exceed \
the first integer, the exhaustive search is used instead of any solution \
methods other than univariate polynomial solving. Otherwise, if the number of \
integer points within the bounds does not exceed the second integer, the \
exhaustive search is performed after all other methods fail."
}], "Text"],

Cell[TextData[{
  "With the default setting of ",
  StyleBox["ExhaustiveSearchMaxPoints", "MR"],
  ", ",
  StyleBox["Reduce", "MR"],
  " is unable to solve this equation."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      Binomial[x, y] \[Equal] Gamma[x + y] && 
        1 \[LessEqual] x \[LessEqual] 200 && 
        1 \[LessEqual] y \[LessEqual] 200, {x, y}, Integers]\)], "Input",
  CellLabel->"In[83]:="],

Cell[BoxData[
    RowBox[{\(Reduce::"nsmet"\), \(\(:\)\(\ \)\), "\<\"This system cannot be \
solved with the methods available to Reduce. \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Reduce::nsmet\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[83]:="],

Cell[BoxData[
    \(Reduce[
      Binomial[x, y] \[Equal] Gamma[x + y] && 
        1 \[LessEqual] x \[LessEqual] 200 && 
        1 \[LessEqual] y \[LessEqual] 200, {x, y}, Integers]\)], "Output",
  CellLabel->"Out[83]="]
}, Open  ]],

Cell[TextData[{
  "This increases the value of the second element of ",
  StyleBox["ExhaustiveSearchMaxPoints", "MR"],
  " to 100,000."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ExhaustiveSearchMaxPoints\>" \[Rule] {1000, 100000}}];\)\)], "Input",
  CellLabel->"In[84]:="],

Cell[TextData[{
  "Now ",
  StyleBox["Reduce", "MR"],
  " can solve the equation."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      Binomial[x, y] \[Equal] Gamma[x + y] && 
        1 \[LessEqual] x \[LessEqual] 200 && 
        1 \[LessEqual] y \[LessEqual] 200, {x, y}, Integers]\)], "Input",
  CellLabel->"In[85]:="],

Cell[BoxData[
    \(\((x \[Equal] 1 && y \[Equal] 1)\) || \((x \[Equal] 2 && 
          y \[Equal] 1)\)\)], "Output",
  CellLabel->"Out[85]="]
}, Open  ]],

Cell[TextData[{
  "With the default setting of ",
  StyleBox["ExhaustiveSearchMaxPoints", "MR"],
  ", ",
  StyleBox["Reduce", "MR"],
  " solves this equation using the method for solving Pell equations."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ExhaustiveSearchMaxPoints\>" \[Rule] {1000, 10000}}]; 
    Reduce[x\^2 - 2\ y\^2 \[Equal] 1 && 1 \[LessEqual] x \[LessEqual] 1000 && 
          1 \[LessEqual] y \[LessEqual] 1000, {x, y}, Integers] // 
      Timing\)], "Input",
  CellLabel->"In[86]:="],

Cell[BoxData[
    \({0.010000000000036424`\ Second, \((x \[Equal] 3 && 
            y \[Equal] 2)\) || \((x \[Equal] 17 && 
            y \[Equal] 12)\) || \((x \[Equal] 99 && 
            y \[Equal] 70)\) || \((x \[Equal] 577 && 
            y \[Equal] 408)\)}\)], "Output",
  CellLabel->"Out[86]="]
}, Open  ]],

Cell[TextData[{
  "Increasing the first element of ",
  StyleBox["ExhaustiveSearchMaxPoints", "MR"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`10\^6\)]],
  " makes ",
  StyleBox["Reduce", "MR"],
  " use the exhaustive search first. In this example the search is much \
slower than the Pell equation solver."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ExhaustiveSearchMaxPoints\>" \[Rule] {10\^6, 10\^6}}];\)\), "\n", 
    \(Reduce[
        x\^2 - 2\ y\^2 \[Equal] 1 && 1 \[LessEqual] x \[LessEqual] 1000 && 
          1 \[LessEqual] y \[LessEqual] 1000, {x, y}, Integers] // 
      Timing\)}], "Input",
  CellLabel->"In[87]:="],

Cell[BoxData[
    \({4.970000000000045`\ Second, \((x \[Equal] 3 && 
            y \[Equal] 2)\) || \((x \[Equal] 17 && 
            y \[Equal] 12)\) || \((x \[Equal] 99 && 
            y \[Equal] 70)\) || \((x \[Equal] 577 && 
            y \[Equal] 408)\)}\)], "Output",
  CellLabel->"Out[88]="]
}, Open  ]],

Cell["\<\
For this equation the Pell equation solver is slower than the \
exhaustive search.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ExhaustiveSearchMaxPoints\>" \[Rule] {1000, 10000}}];\)\), "\n", 
    \(Reduce[
        x\^2 - 21\ y\^2 \[Equal] 2004 && 1 \[LessEqual] x \[LessEqual] 100 && 
          1 \[LessEqual] y \[LessEqual] 100, {x, y}, Integers] // 
      Timing\)}], "Input",
  CellLabel->"In[89]:="],

Cell[BoxData[
    \({0.20000000000002727`\ Second, 
      x \[Equal] 45 && y \[Equal] 1}\)], "Output",
  CellLabel->"Out[90]="]
}, Open  ]],

Cell["The exhaustive search is faster here.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ExhaustiveSearchMaxPoints\>" \[Rule] {10000, 10000}}]; 
    Reduce[x\^2 - 21\ y\^2 \[Equal] 2004 && 
          1 \[LessEqual] x \[LessEqual] 100 && 
          1 \[LessEqual] y \[LessEqual] 100, {x, y}, Integers] // 
      Timing\)], "Input",
  CellLabel->"In[91]:="],

Cell[BoxData[
    \({0.04999999999998184`\ Second, 
      x \[Equal] 45 && y \[Equal] 1}\)], "Output",
  CellLabel->"Out[91]="]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["ExhaustiveSearchMaxPoints", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<ExhaustiveSearchMaxPoints\>" \[Rule] {1000, 10000}}];\)\)], "Input",
  CellLabel->"In[92]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LatticeReduceDiophantine",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"LatticeReduceDiophantine"],

Cell[TextData[{
  "The value of the system option ",
  StyleBox["LatticeReduceDiophantine", "MR"],
  " specifies whether ",
  StyleBox["LatticeReduce", "MR"],
  " should be used to preprocess ",
  ButtonBox["systems of bounded linear inequalities",
    ButtonData:>"BoundedLinearSystems",
    ButtonStyle->"Hyperlink"],
  ". The use of ",
  StyleBox["LatticeReduce", "MR"],
  " is important for systems of inequalities describing polyhedra whose \
projections on some non-axial lines are much smaller than their projections \
on the axes. However, there are systems for which ",
  StyleBox["LatticeReduce", "MR"],
  ", instead of simplifying the problem, makes it significantly harder."
}], "Text"],

Cell[TextData[{
  "This finds the only two integer points in a triangle whose projections on \
both axes have sizes greater than ",
  StyleBox["a",
    FontSlant->"Italic"],
  " but whose projection on the line ",
  Cell[BoxData[
      \(TraditionalForm\`x + 5000  y \[Equal] 0\)]],
  " has size one."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(a = 10\^4; \), "\n", 
    \(Reduce[
        a\ x \[LessEqual] \((a + 1)\)\ y && \((a + 
                  1)\)\ x \[GreaterEqual] \((a + 2)\)\ y && 
          0 \[LessEqual] x \[LessEqual] a + 1, {x, y}, Integers] // 
      Timing\)}], "Input",
  CellLabel->"In[93]:="],

Cell[BoxData[
    \({0.010000000000036424`\ Second, \((x \[Equal] 0 && 
            y \[Equal] 0)\) || \((x \[Equal] 10001 && 
            y \[Equal] 10000)\)}\)], "Output",
  CellLabel->"Out[94]="]
}, Open  ]],

Cell[TextData[{
  "This sets the value of the system option ",
  StyleBox["LatticeReduceDiophantine", "MR"],
  " to ",
  StyleBox["False", "MR"],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<LatticeReduceDiophantine\>" \[Rule] False}];\)\)], "Input",
  CellLabel->"In[95]:="],

Cell[TextData[{
  "The nondefault method is much slower for this system, and the speed \
difference grows with ",
  StyleBox["a",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
        a\ x \[LessEqual] \((a + 1)\)\ y && \((a + 
                  1)\)\ x \[GreaterEqual] \((a + 2)\)\ y && 
          0 \[LessEqual] x \[LessEqual] a + 1, {x, y}, Integers] // 
      Timing\)], "Input",
  CellLabel->"In[96]:="],

Cell[BoxData[
    \({3.9300000000000272`\ Second, \((x \[Equal] 0 && 
            y \[Equal] 0)\) || \((x \[Equal] 10001 && 
            y \[Equal] 10000)\)}\)], "Output",
  CellLabel->"Out[96]="]
}, Open  ]],

Cell[TextData[{
  "Here is a system that contains a set of simple inequalities ",
  StyleBox["bds,",
    FontSlant->"Italic"],
  " which bound solutions to a reasonably small size polyhedron, combined \
with a set of relatively complicated inequalities ",
  StyleBox["ineqs",
    FontSlant->"Italic"],
  ". For such systems, using ",
  StyleBox["LatticeReduce", "MR"],
  " tends to increase the timing."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<LatticeReduceDiophantine\>" \[Rule] True}]; \), "\n", 
    \(SeedRandom[1]; \), "\n", 
    \(B = Table[Random[Integer, {\(-1000\), 1000}], {3}, {5}]; 
    b = Table[Random[Integer, {\(-1000\), 1000}], {3}]; \), "\n", 
    \(X = x /@ Range[5]; \), "\n", 
    \(ineqs = And @@ Thread[B . X \[GreaterEqual] b]; \), "\n", 
    \(\(bds = 
        And @@ Thread[X \[GreaterEqual] 0] && 
          Total[X] \[LessEqual] 10;\)\), "\n", 
    \(\(Reduce[ineqs && bds, X, Integers] // Length\) // Timing\)}], "Input",
  CellLabel->"In[97]:="],

Cell[BoxData[
    \({1.7899999999999727`\ Second, 35}\)], "Output",
  CellLabel->"Out[103]="]
}, Open  ]],

Cell["The nondefault method is faster for this system.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<LatticeReduceDiophantine\>" \[Rule] False}];\)\), "\n", 
    \(\(Reduce[ineqs && bds, X, Integers] // Length\) // Timing\)}], "Input",
  CellLabel->"In[104]:="],

Cell[BoxData[
    \({0.03000000000000913`\ Second, 35}\)], "Output",
  CellLabel->"Out[105]="]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["LatticeReduceDiophantine", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<LatticeReduceDiophantine\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[106]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["MaxFrobeniusGraph", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"MaxFrobeniusGraph"],

Cell[TextData[{
  "The system option ",
  StyleBox["MaxFrobeniusGraph", "MR"],
  " specifies the maximal size of the smallest coefficient in a ",
  ButtonBox["Frobenius equation",
    ButtonData:>"Frobenius",
    ButtonStyle->"Hyperlink"],
  " for which ",
  StyleBox["FindInstance", "MR"],
  " uses an algorithm based on the computation of the critical tree in the \
Frobenius graph [",
  ButtonBox["11",
    ButtonData:>"11",
    ButtonStyle->"Hyperlink"],
  "]. Otherwise, the more general ",
  ButtonBox["methods for solving bounded linear systems",
    ButtonData:>"BoundedLinearSystems",
    ButtonStyle->"Hyperlink"],
  " are used. Unlike the general method for solving bounded linear systems, \
the method based on the computation of the Frobenius graph depends very \
little on the number of variables, hence it is the faster choice for \
equations with many variables. On the other hand, the method requires storing \
a graph of the size of the smallest coefficient, so for large coefficients it \
may run out of memory."
}], "Text"],

Cell[TextData[{
  "To find a solution of a Frobenius equation with the smallest coefficient \
larger than ",
  Cell[BoxData[
      \(TraditionalForm\`10\^6\)]],
  ", ",
  StyleBox["FindInstance", "MR"],
  " by default uses the general method for solving bounded linear systems. \
For this example the method is relatively slow but uses little memory. The \
kernel has been restarted to show the memory usage by the current example."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SeedRandom[1]; \), "\n", 
    \(\(A = Table[Random[Integer, {5\ 10\^6, 10\^7}], {25}];\)\), "\n", 
    \(\(X = x /@ Range[25];\)\), "\n", 
    \(FindInstance[
        A . X \[Equal] 123456789 && And @@ Thread[X \[GreaterEqual] 0], X, 
        Integers] // Timing\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({72.22`\ Second, {{x[1] \[Rule] 1, x[2] \[Rule] 0, x[3] \[Rule] 0, 
          x[4] \[Rule] 0, x[5] \[Rule] 2, x[6] \[Rule] 3, x[7] \[Rule] 0, 
          x[8] \[Rule] 0, x[9] \[Rule] 0, x[10] \[Rule] 7, x[11] \[Rule] 0, 
          x[12] \[Rule] 0, x[13] \[Rule] 0, x[14] \[Rule] 0, x[15] \[Rule] 0, 
          x[16] \[Rule] 2, x[17] \[Rule] 1, x[18] \[Rule] 0, x[19] \[Rule] 0, 
          x[20] \[Rule] 3, x[21] \[Rule] 0, x[22] \[Rule] 0, x[23] \[Rule] 0, 
          x[24] \[Rule] 0, x[25] \[Rule] 0}}}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MaxMemoryUsed[]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(3345072\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "This increases the value of ",
  StyleBox["MaxFrobeniusGraph", "MR"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`10\^7\)]],
  "."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<MaxFrobeniusGraph\>" \[Rule] 10\^7}];\)\)], "Input",
  CellLabel->"In[6]:="],

Cell[TextData[{
  "Now ",
  StyleBox["FindInstance", "MR"],
  " uses the method based on the computation of the Frobenius graph. It finds \
the solution faster, but it uses more memory."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        A . X \[Equal] 123456789 && And @@ Thread[X \[GreaterEqual] 0], X, 
        Integers] // Timing\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({2.390000000000006`\ Second, {{x[1] \[Rule] 0, x[2] \[Rule] 14, 
          x[3] \[Rule] 0, x[4] \[Rule] 0, x[5] \[Rule] 1, x[6] \[Rule] 0, 
          x[7] \[Rule] 0, x[8] \[Rule] 0, x[9] \[Rule] 0, x[10] \[Rule] 0, 
          x[11] \[Rule] 0, x[12] \[Rule] 0, x[13] \[Rule] 0, x[14] \[Rule] 0, 
          x[15] \[Rule] 0, x[16] \[Rule] 2, x[17] \[Rule] 1, x[18] \[Rule] 1, 
          x[19] \[Rule] 1, x[20] \[Rule] 0, x[21] \[Rule] 0, x[22] \[Rule] 1, 
          x[23] \[Rule] 1, x[24] \[Rule] 0, x[25] \[Rule] 0}}}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MaxMemoryUsed[]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \(70827000\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["MaxFrobeniusGraph", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<MaxFrobeniusGraph\>" \[Rule] 10\^6}]; \)], "Input",
  CellLabel->"In[9]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["SieveMaxPoints", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"SieveMaxPoints"],

Cell[TextData[{
  "The system option ",
  StyleBox["SieveMaxPoints", "MR"],
  " specifies the maximal number of search points used by ",
  ButtonBox["the modular sieve method",
    ButtonData:>"Sieve",
    ButtonStyle->"Hyperlink"],
  " and by searches used in ",
  ButtonBox["solving equations with a linear variable",
    ButtonData:>"LinVarEqn",
    ButtonStyle->"Hyperlink"],
  ". The default value of the option is 10,000."
}], "Text"],

Cell[TextData[{
  "With the default setting of ",
  StyleBox["SieveMaxPoints", "MR"],
  ", ",
  StyleBox["FindInstance", "MR"],
  " is unable to find a solution for this equation."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[x\^2 + 21\ y\^3 - 17\ z\^4 \[Equal] 401, {x, y, z}, 
      Integers]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    RowBox[{\(FindInstance::"nsmet"\), \(\(:\)\(\ \)\), "\<\"The methods \
available to FindInstance are insufficient to find the requested instances or \
prove they do not exist. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"FindInstance::nsmet\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[10]:="],

Cell[BoxData[
    \(FindInstance[x\^2 + 21\ y\^3 - 17\ z\^4 \[Equal] 401, {x, y, z}, 
      Integers]\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "Increasing the number of ",
  StyleBox["SieveMaxPoints", "MR"],
  " to one million allows ",
  StyleBox["FindInstance", "MR"],
  " to find a solution."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<SieveMaxPoints\>" \[Rule] 1000000}];\)\), "\n", 
    \(FindInstance[x\^2 + 21\ y\^3 - 17\ z\^4 \[Equal] 401, {x, y, z}, 
      Integers]\)}], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \({{x \[Rule] \(-29\), y \[Rule] \(-2\), z \[Rule] \(-2\)}}\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "This resets ",
  StyleBox["SieveMaxPoints", "MR"],
  " to the default value."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
{"\<SieveMaxPoints\>" \[Rule] 10000}];\)\)], "Input",
  CellLabel->"In[13]:="]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Section",
  CellTags->{"t:29", "c:29"}],

Cell[TextData[{
  "[1] C. Goldbach, Letter to L. Euler, June 7, 1742. ",
  ButtonBox["http://www.mathstat.dal.ca/~joerg/pic/g-letter.jpg",
    ButtonData:>{
      URL[ "http://www.mathstat.dal.ca/~joerg/pic/g-letter.jpg"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"1"],

Cell[TextData[{
  "[2] Yu. V. Matiyasevich, \[OpenCurlyDoubleQuote]The Diophantineness of \
enumerable sets,\[CloseCurlyDoubleQuote]  (Russian) ",
  StyleBox["Dokl. Akad. Nauk SSSR,",
    FontSlant->"Italic"],
  " ",
  StyleBox["191",
    FontWeight->"Bold"],
  ", 1970 pp. 279-282. English translation: ",
  StyleBox["Soviet Math. Dokl.,",
    FontSlant->"Italic"],
  " ",
  StyleBox["11",
    FontWeight->"Bold"],
  ", 1970 pp. 354--358."
}], "Text",
  CellTags->"2"],

Cell[TextData[{
  "[3] E. Contejean and H. Devie, \[OpenCurlyDoubleQuote]An efficient \
incremental algorithm for solving systems of linear Diophantine equations,\
\[CloseCurlyDoubleQuote] ",
  StyleBox["Information and Computation,",
    FontSlant->"Italic"],
  " ",
  StyleBox["113",
    FontWeight->"Bold"],
  ", 1994 pp. 143-172."
}], "Text",
  CellTags->"3"],

Cell[TextData[{
  "[4] F. Cucker, P. Koiran, and S. Smale, \[OpenCurlyDoubleQuote]A \
Polynomial Time Algorithm for Diophantine Equations in One Variable,\
\[CloseCurlyDoubleQuote] ",
  StyleBox["Journal of Symbolic Computation,",
    FontSlant->"Italic"],
  " ",
  StyleBox["27",
    FontWeight->"Bold"],
  "(1), 1999 pp. 21-30."
}], "Text",
  CellTags->"4"],

Cell[TextData[{
  "[5] A. Strzebonski, \[OpenCurlyDoubleQuote]An Improved Algorithm for \
Diophantine Equations in One Variable,\[CloseCurlyDoubleQuote] Paper \
presented at the ACA 2002 Session on Symbolic-Numerical Methods in \
Computational Science, Volos, Greece. Notebook with the conference talk \
available at ",
  ButtonBox["members.wolfram.com/adams",
    ButtonData:>{
      URL[ "http://members.wolfram.com/adams"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"5"],

Cell[TextData[{
  "[6] L. E. Dickson,  ",
  StyleBox["History of the Theory of Numbers",
    FontSlant->"Italic"],
  ", New York: Chelsea, 1952."
}], "Text",
  CellTags->"6"],

Cell[TextData[{
  "[7] T. Nagell, ",
  StyleBox["Introduction to Number Theory,",
    FontSlant->"Italic"],
  " New York: Wiley, 1951."
}], "Text",
  CellTags->"7"],

Cell[TextData[{
  "[8] K. Hardy, J. B. Muskat and K. S. Williams, \[OpenCurlyDoubleQuote]A \
deterministic algorithm for solving ",
  Cell[BoxData[
      \(TraditionalForm\`n = f\ u\^2 + g\ v\^2\)]],
  " in coprime integers ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ",\[CloseCurlyDoubleQuote]  ",
  StyleBox["Mathematics of Computation,",
    FontSlant->"Italic"],
  " ",
  StyleBox["55",
    FontWeight->"Bold"],
  ", 1990 pp. 327-343. "
}], "Text",
  CellTags->"8"],

Cell[TextData[{
  "[9] N. Smart, ",
  StyleBox["The Algorithmic Resolution of Diophantine Equations",
    FontSlant->"Italic"],
  ", London Mathematical Society Student Text, ",
  StyleBox["41",
    FontWeight->"Bold"],
  ", Cambridge University Press, 1998. "
}], "Text",
  CellTags->"9"],

Cell[TextData[{
  "[10] D. M. Bressoud and S. Wagon, ",
  StyleBox["A Course in Computational Number Theory",
    FontSlant->"Italic"],
  ", San Francisco: Key College Publishing, 2000."
}], "Text",
  CellTags->"10"],

Cell[TextData[{
  "[11] D. E. Beihoffer, J. Hendry, A. Nijenhuis, and S. Wagon, \
\[OpenCurlyDoubleQuote]Faster Algorithms for Frobenius Numbers,\
\[CloseCurlyDoubleQuote] to appear in ",
  StyleBox["The Electronic Journal of Combinatorics",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"11"],

Cell[TextData[{
  "[12] M. O. Rabin and J. O. Shallit, \[OpenCurlyDoubleQuote]Randomized \
algorithms in number theory,\[CloseCurlyDoubleQuote]",
  StyleBox[" Communications on Pure and Applied Mathematics",
    FontSlant->"Italic"],
  ", ",
  StyleBox["39",
    FontWeight->"Bold"],
  ", 1986 pp. 239-256."
}], "Text",
  CellTags->"12"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Brackets",
WindowSize->{651, 548},
WindowMargins->{{Automatic, 213}, {162, Automatic}},
WindowTitle->"Diophantine Polynomial Systems",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowSelection->True,
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "t:1"->{
    Cell[1776, 53, 77, 1, 96, "Chapter",
      CellTags->{"t:1", "c:1"}]},
  "c:1"->{
    Cell[1776, 53, 77, 1, 96, "Chapter",
      CellTags->{"t:1", "c:1"}]},
  "t:3"->{
    Cell[1878, 58, 59, 1, 67, "Section",
      CellTags->{"t:3", "c:3"}]},
  "c:3"->{
    Cell[1878, 58, 59, 1, 67, "Section",
      CellTags->{"t:3", "c:3"}]},
  "Diophantine1"->{
    Cell[4057, 125, 221, 4, 33, "NumberedEquation",
      CellTags->"Diophantine1"]},
  "Diophantine2"->{
    Cell[4893, 152, 348, 6, 32, "NumberedEquation",
      CellTags->"Diophantine2"]},
  "LinearEqns"->{
    Cell[6604, 206, 75, 1, 41, "Subsection",
      CellTags->"LinearEqns"]},
  "Frobenius"->{
    Cell[8022, 252, 66, 1, 41, "Subsection",
      CellTags->"Frobenius"]},
  "BoundedLinearSystems"->{
    Cell[10571, 331, 110, 1, 41, "Subsection",
      CellTags->"BoundedLinearSystems"]},
  "PolyhedronIntegerPoints"->{
    Cell[15074, 474, 1386, 33, 152, "Text",
      CellTags->"PolyhedronIntegerPoints"],
    Cell[16463, 509, 561, 15, 56, "Text",
      CellTags->"PolyhedronIntegerPoints"]},
  "BoundedSolutionLimits"->{
    Cell[20067, 595, 795, 21, 72, "Text",
      CellTags->"BoundedSolutionLimits"]},
  "UnivariateEqns"->{
    Cell[27358, 796, 72, 1, 41, "Subsection",
      CellTags->"UnivariateEqns"]},
  "Quadratic"->{
    Cell[31226, 935, 182, 4, 31, "NumberedEquation",
      CellTags->"Quadratic"]},
  "Parabolic1"->{
    Cell[52492, 1476, 316, 6, 31, "NumberedEquation",
      CellTags->"Parabolic1"]},
  "Parabolic2"->{
    Cell[53786, 1522, 445, 12, 31, "NumberedEquation",
      CellTags->"Parabolic2"]},
  "Parabolic3"->{
    Cell[55428, 1581, 247, 5, 31, "NumberedEquation",
      CellTags->"Parabolic3"]},
  "Parabolic4"->{
    Cell[56515, 1619, 248, 5, 31, "NumberedEquation",
      CellTags->"Parabolic4"]},
  "Sieve"->{
    Cell[64202, 1874, 89, 1, 41, "Subsection",
      CellTags->"Sieve"]},
  "ManyEqn"->{
    Cell[66083, 1941, 80, 1, 41, "Subsection",
      CellTags->"ManyEqn"]},
  "Congruences"->{
    Cell[69194, 2054, 232, 4, 30, "NumberedEquation",
      CellTags->"Congruences"]},
  "SumOfSquares"->{
    Cell[72734, 2160, 146, 3, 31, "NumberedEquation",
      CellTags->"SumOfSquares"]},
  "LinVarEqn"->{
    Cell[79025, 2337, 79, 1, 41, "Subsection",
      CellTags->"LinVarEqn"]},
  "LinVar"->{
    Cell[79661, 2360, 449, 8, 48, "NumberedEquation",
      CellTags->"LinVar"]},
  "DivisibilityHeuristic"->{
    Cell[95489, 2844, 373, 7, 48, "NumberedEquation",
      CellTags->"DivisibilityHeuristic"]},
  "ExhaustiveSearch"->{
    Cell[97393, 2912, 91, 1, 41, "Subsection",
      CellTags->"ExhaustiveSearch"]},
  "BranchLinearDiophantine"->{
    Cell[106361, 3166, 160, 3, 24, "SubsubsectionIcon",
      CellTags->"BranchLinearDiophantine"]},
  "DiscreteSolutionBound"->{
    Cell[114584, 3391, 156, 3, 24, "SubsubsectionIcon",
      CellTags->"DiscreteSolutionBound"]},
  "ExhaustiveSearchMaxPoints"->{
    Cell[117912, 3514, 170, 3, 24, "SubsubsectionIcon",
      CellTags->"ExhaustiveSearchMaxPoints"]},
  "LatticeReduceDiophantine"->{
    Cell[124149, 3712, 162, 3, 24, "SubsubsectionIcon",
      CellTags->"LatticeReduceDiophantine"]},
  "MaxFrobeniusGraph"->{
    Cell[128843, 3865, 154, 3, 24, "SubsubsectionIcon",
      CellTags->"MaxFrobeniusGraph"]},
  "SieveMaxPoints"->{
    Cell[133425, 4006, 148, 3, 24, "SubsubsectionIcon",
      CellTags->"SieveMaxPoints"]},
  "t:29"->{
    Cell[135879, 4092, 59, 1, 41, "Section",
      CellTags->{"t:29", "c:29"}]},
  "c:29"->{
    Cell[135879, 4092, 59, 1, 41, "Section",
      CellTags->{"t:29", "c:29"}]},
  "1"->{
    Cell[135941, 4095, 295, 8, 24, "Text",
      CellTags->"1"]},
  "2"->{
    Cell[136239, 4105, 469, 16, 40, "Text",
      CellTags->"2"]},
  "3"->{
    Cell[136711, 4123, 363, 11, 40, "Text",
      CellTags->"3"]},
  "4"->{
    Cell[137077, 4136, 359, 11, 40, "Text",
      CellTags->"4"]},
  "5"->{
    Cell[137439, 4149, 499, 12, 56, "Text",
      CellTags->"5"]},
  "6"->{
    Cell[137941, 4163, 174, 6, 24, "Text",
      CellTags->"6"]},
  "7"->{
    Cell[138118, 4171, 164, 6, 24, "Text",
      CellTags->"7"]},
  "8"->{
    Cell[138285, 4179, 537, 19, 40, "Text",
      CellTags->"8"]},
  "9"->{
    Cell[138825, 4200, 289, 9, 40, "Text",
      CellTags->"9"]},
  "10"->{
    Cell[139117, 4211, 216, 6, 40, "Text",
      CellTags->"10"]},
  "11"->{
    Cell[139336, 4219, 303, 8, 40, "Text",
      CellTags->"11"]},
  "12"->{
    Cell[139642, 4229, 337, 10, 40, "Text",
      CellTags->"12"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"t:1", 140842, 4267},
  {"c:1", 140928, 4270},
  {"t:3", 141014, 4273},
  {"c:3", 141100, 4276},
  {"Diophantine1", 141195, 4279},
  {"Diophantine2", 141301, 4282},
  {"LinearEqns", 141405, 4285},
  {"Frobenius", 141499, 4288},
  {"BoundedLinearSystems", 141603, 4291},
  {"PolyhedronIntegerPoints", 141723, 4294},
  {"BoundedSolutionLimits", 141927, 4299},
  {"UnivariateEqns", 142034, 4302},
  {"Quadratic", 142133, 4305},
  {"Parabolic1", 142235, 4308},
  {"Parabolic2", 142339, 4311},
  {"Parabolic3", 142444, 4314},
  {"Parabolic4", 142548, 4317},
  {"Sieve", 142647, 4320},
  {"ManyEqn", 142736, 4323},
  {"Congruences", 142831, 4326},
  {"SumOfSquares", 142938, 4329},
  {"LinVarEqn", 143043, 4332},
  {"LinVar", 143135, 4335},
  {"DivisibilityHeuristic", 143246, 4338},
  {"ExhaustiveSearch", 143367, 4341},
  {"BranchLinearDiophantine", 143483, 4344},
  {"DiscreteSolutionBound", 143613, 4347},
  {"ExhaustiveSearchMaxPoints", 143745, 4350},
  {"LatticeReduceDiophantine", 143880, 4353},
  {"MaxFrobeniusGraph", 144007, 4356},
  {"SieveMaxPoints", 144124, 4359},
  {"t:29", 144228, 4362},
  {"c:29", 144321, 4365},
  {"1", 144411, 4368},
  {"2", 144486, 4371},
  {"3", 144562, 4374},
  {"4", 144638, 4377},
  {"5", 144714, 4380},
  {"6", 144790, 4383},
  {"7", 144865, 4386},
  {"8", 144940, 4389},
  {"9", 145016, 4392},
  {"10", 145092, 4395},
  {"11", 145169, 4398},
  {"12", 145246, 4401}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 77, 1, 96, "Chapter",
  CellTags->{"t:1", "c:1"}],

Cell[CellGroupData[{
Cell[1878, 58, 59, 1, 67, "Section",
  CellTags->{"t:3", "c:3"}],
Cell[1940, 61, 182, 5, 24, "Text"],
Cell[2125, 68, 493, 9, 66, "DisplayFormula"],
Cell[2621, 79, 66, 0, 24, "Text"],
Cell[2690, 81, 294, 4, 30, "DisplayFormula"],
Cell[2987, 87, 65, 0, 24, "Text"],
Cell[3055, 89, 999, 34, 72, "Text"],
Cell[4057, 125, 221, 4, 33, "NumberedEquation",
  CellTags->"Diophantine1"],
Cell[4281, 131, 542, 17, 56, "Text"],
Cell[4826, 150, 64, 0, 24, "Text"],
Cell[4893, 152, 348, 6, 32, "NumberedEquation",
  CellTags->"Diophantine2"],
Cell[5244, 160, 1265, 37, 136, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[6546, 202, 33, 0, 41, "Section"],

Cell[CellGroupData[{
Cell[6604, 206, 75, 1, 41, "Subsection",
  CellTags->"LinearEqns"],
Cell[6682, 209, 642, 15, 88, "Text"],
Cell[7327, 226, 162, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[7514, 234, 196, 5, 42, "Input"],
Cell[7713, 241, 260, 5, 41, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8022, 252, 66, 1, 41, "Subsection",
  CellTags->"Frobenius"],
Cell[8091, 255, 126, 5, 24, "Text"],
Cell[8220, 262, 147, 2, 30, "DisplayFormula"],
Cell[8370, 266, 344, 11, 40, "Text"],
Cell[8717, 279, 1006, 25, 104, "Text"],
Cell[9726, 306, 69, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[9820, 310, 504, 9, 74, "Input"],
Cell[10327, 321, 195, 4, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10571, 331, 110, 1, 41, "Subsection",
  CellTags->"BoundedLinearSystems"],
Cell[10684, 334, 292, 7, 40, "Text"],
Cell[10979, 343, 4092, 129, 242, "Text"],
Cell[15074, 474, 1386, 33, 152, "Text",
  CellTags->"PolyhedronIntegerPoints"],
Cell[16463, 509, 561, 15, 56, "Text",
  CellTags->"PolyhedronIntegerPoints"],
Cell[17027, 526, 67, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[17119, 530, 174, 4, 26, "Input"],
Cell[17296, 536, 2756, 56, 233, "Output"]
}, Open  ]],
Cell[20067, 595, 795, 21, 72, "Text",
  CellTags->"BoundedSolutionLimits"],
Cell[20865, 618, 176, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[21066, 627, 167, 4, 26, "Input"],
Cell[21236, 633, 258, 5, 25, "Output"]
}, Open  ]],
Cell[21509, 641, 225, 6, 40, "MathCaption"],
Cell[21737, 649, 162, 3, 42, "Input"],
Cell[21902, 654, 273, 8, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[22200, 666, 181, 4, 26, "Input"],
Cell[22384, 672, 63, 2, 25, "Output"]
}, Open  ]],
Cell[22462, 677, 122, 4, 40, "MathCaption"],
Cell[22587, 683, 160, 3, 42, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22784, 691, 76, 0, 41, "Subsection"],
Cell[22863, 693, 1533, 32, 184, "Text"],
Cell[24399, 727, 149, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[24573, 734, 165, 4, 26, "Input"],
Cell[24741, 740, 2494, 45, 329, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[27296, 792, 37, 0, 41, "Section"],

Cell[CellGroupData[{
Cell[27358, 796, 72, 1, 41, "Subsection",
  CellTags->"UnivariateEqns"],
Cell[27433, 799, 595, 15, 72, "Text"],
Cell[28031, 816, 144, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[28200, 824, 304, 6, 60, "Input"],
Cell[28507, 832, 95, 2, 25, "Output"]
}, Open  ]],
Cell[28617, 837, 115, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[28757, 844, 69, 2, 26, "Input"],
Cell[28829, 848, 120, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28986, 856, 114, 2, 26, "Input"],
Cell[29103, 860, 67, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29219, 868, 70, 0, 41, "Subsection"],
Cell[29292, 870, 449, 9, 72, "Text"],
Cell[29744, 881, 301, 10, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[30070, 895, 171, 4, 30, "Input"],
Cell[30244, 901, 87, 2, 25, "Output"]
}, Open  ]],
Cell[30346, 906, 527, 10, 72, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[30922, 922, 36, 0, 41, "Section"],

Cell[CellGroupData[{
Cell[30983, 926, 41, 0, 41, "Subsection"],
Cell[31027, 928, 196, 5, 40, "Text"],
Cell[31226, 935, 182, 4, 31, "NumberedEquation",
  CellTags->"Quadratic"],
Cell[31411, 941, 1009, 29, 72, "Text"],

Cell[CellGroupData[{
Cell[32445, 974, 79, 0, 24, "SubsubsectionIcon"],
Cell[32527, 976, 1335, 40, 89, "Text"],
Cell[33865, 1018, 94, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[33984, 1025, 155, 4, 30, "Input"],
Cell[34142, 1031, 211, 4, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34402, 1041, 85, 1, 24, "SubsubsectionIcon"],
Cell[34490, 1044, 769, 23, 73, "Text"],
Cell[35262, 1069, 313, 9, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[35600, 1082, 110, 2, 30, "Input"],
Cell[35713, 1086, 1424, 25, 585, "Output"]
}, Open  ]],
Cell[37152, 1114, 103, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[37280, 1121, 156, 4, 30, "Input"],
Cell[37439, 1127, 9438, 191, 2669, "Output"]
}, Open  ]],
Cell[46892, 1321, 145, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[47062, 1328, 89, 2, 26, "Input"],
Cell[47154, 1332, 937, 15, 185, "Output"]
}, Open  ]],
Cell[48106, 1350, 174, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[48305, 1358, 167, 4, 26, "Input"],
Cell[48475, 1364, 2323, 42, 249, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50847, 1412, 53, 0, 24, "SubsubsectionIcon"],
Cell[50903, 1414, 1100, 41, 42, "Text"],
Cell[52006, 1457, 163, 3, 31, "DisplayFormula"],
Cell[52172, 1462, 317, 12, 24, "Text"],
Cell[52492, 1476, 316, 6, 31, "NumberedEquation",
  CellTags->"Parabolic1"],
Cell[52811, 1484, 752, 25, 56, "Text"],
Cell[53566, 1511, 217, 9, 24, "Text"],
Cell[53786, 1522, 445, 12, 31, "NumberedEquation",
  CellTags->"Parabolic2"],
Cell[54234, 1536, 1191, 43, 72, "Text"],
Cell[55428, 1581, 247, 5, 31, "NumberedEquation",
  CellTags->"Parabolic3"],
Cell[55678, 1588, 834, 29, 56, "Text"],
Cell[56515, 1619, 248, 5, 31, "NumberedEquation",
  CellTags->"Parabolic4"],
Cell[56766, 1626, 731, 25, 56, "Text"],
Cell[57500, 1653, 149, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[57674, 1661, 138, 3, 30, "Input"],
Cell[57815, 1666, 347, 6, 43, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58211, 1678, 52, 0, 24, "SubsubsectionIcon"],
Cell[58266, 1680, 829, 24, 72, "Text"],
Cell[59098, 1706, 406, 11, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[59529, 1721, 187, 4, 65, "Input"],
Cell[59719, 1727, 826, 17, 137, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[60606, 1751, 36, 0, 41, "Subsection"],
Cell[60645, 1753, 132, 5, 24, "Text"],
Cell[60780, 1760, 102, 2, 30, "DisplayFormula"],
Cell[60885, 1764, 174, 5, 24, "Text"],
Cell[61062, 1771, 786, 20, 104, "Text"],
Cell[61851, 1793, 77, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[61953, 1797, 130, 3, 30, "Input"],
Cell[62086, 1802, 401, 8, 41, "Output"]
}, Open  ]],
Cell[62502, 1813, 157, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[62684, 1821, 171, 4, 30, "Input"],
Cell[62858, 1827, 402, 8, 41, "Output"]
}, Open  ]],
Cell[63275, 1838, 332, 10, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[63632, 1852, 299, 6, 66, "Input"],
Cell[63934, 1860, 133, 3, 25, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[64128, 1870, 49, 0, 41, "Section"],

Cell[CellGroupData[{
Cell[64202, 1874, 89, 1, 41, "Subsection",
  CellTags->"Sieve"],
Cell[64294, 1877, 907, 25, 88, "Text"],
Cell[65204, 1904, 63, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[65292, 1908, 193, 3, 30, "Input"],
Cell[65488, 1913, 64, 2, 25, "Output"]
}, Open  ]],
Cell[65567, 1918, 132, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[65724, 1926, 207, 5, 48, "Input"],
Cell[65934, 1933, 100, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[66083, 1941, 80, 1, 41, "Subsection",
  CellTags->"ManyEqn"],
Cell[66166, 1944, 304, 8, 40, "Text"],

Cell[CellGroupData[{
Cell[66495, 1956, 105, 3, 24, "SubsubsectionIcon"],
Cell[66603, 1961, 438, 10, 56, "Text"],
Cell[67044, 1973, 328, 12, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[67397, 1989, 174, 5, 30, "Input"],
Cell[67574, 1996, 210, 4, 25, "Output"]
}, Open  ]],
Cell[67799, 2003, 317, 10, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[68141, 2017, 182, 4, 30, "Input"],
Cell[68326, 2023, 325, 6, 72, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[68700, 2035, 87, 1, 24, "SubsubsectionIcon"],
Cell[68790, 2038, 102, 3, 24, "Text"],
Cell[68895, 2043, 156, 2, 30, "DisplayFormula"],
Cell[69054, 2047, 137, 5, 24, "Text"],
Cell[69194, 2054, 232, 4, 30, "NumberedEquation",
  CellTags->"Congruences"],
Cell[69429, 2060, 402, 11, 56, "Text"],
Cell[69834, 2073, 97, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[69956, 2080, 212, 5, 49, "Input"],
Cell[70171, 2087, 542, 12, 168, "Output"]
}, Open  ]],
Cell[70728, 2102, 193, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[70946, 2110, 231, 6, 49, "Input"],
Cell[71180, 2118, 1334, 27, 321, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72575, 2152, 37, 0, 41, "Subsection"],
Cell[72615, 2154, 116, 4, 24, "Text"],
Cell[72734, 2160, 146, 3, 31, "NumberedEquation",
  CellTags->"SumOfSquares"],
Cell[72883, 2165, 719, 22, 72, "Text"],
Cell[73605, 2189, 82, 1, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[73712, 2194, 162, 3, 30, "Input"],
Cell[73877, 2199, 1210, 18, 137, "Output"]
}, Open  ]],
Cell[75102, 2220, 298, 12, 24, "Text"],
Cell[75403, 2234, 199, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[75627, 2243, 265, 5, 69, "Input"],
Cell[75895, 2250, 654, 12, 79, "Output"]
}, Open  ]],
Cell[76564, 2265, 75, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[76664, 2269, 107, 2, 26, "Input"],
Cell[76774, 2273, 62, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[76885, 2281, 64, 0, 41, "Subsection"],
Cell[76952, 2283, 163, 5, 24, "Text"],
Cell[77118, 2290, 158, 2, 31, "DisplayFormula"],
Cell[77279, 2294, 107, 3, 24, "Text"],
Cell[77389, 2299, 107, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[77521, 2306, 173, 3, 30, "Input"],
Cell[77697, 2311, 1279, 20, 137, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[79025, 2337, 79, 1, 41, "Subsection",
  CellTags->"LinVarEqn"],
Cell[79107, 2340, 134, 4, 24, "Text"],
Cell[79244, 2346, 195, 3, 30, "DisplayFormula"],
Cell[79442, 2351, 216, 7, 24, "Text"],
Cell[79661, 2360, 449, 8, 48, "NumberedEquation",
  CellTags->"LinVar"],
Cell[80113, 2370, 2603, 78, 168, "Text"],
Cell[82719, 2450, 118, 2, 30, "DisplayFormula"],
Cell[82840, 2454, 1184, 38, 72, "Text"],
Cell[84027, 2494, 997, 36, 72, "Text"],
Cell[85027, 2532, 295, 7, 40, "Text"],
Cell[85325, 2541, 233, 9, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[85583, 2554, 156, 4, 30, "Input"],
Cell[85742, 2560, 582, 10, 90, "Output"]
}, Open  ]],
Cell[86339, 2573, 233, 9, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[86597, 2586, 142, 3, 30, "Input"],
Cell[86742, 2591, 335, 7, 75, "Output"]
}, Open  ]],
Cell[87092, 2601, 224, 9, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[87341, 2614, 158, 4, 30, "Input"],
Cell[87502, 2620, 148, 3, 25, "Output"]
}, Open  ]],
Cell[87665, 2626, 444, 12, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[88134, 2642, 281, 5, 67, "Input"],
Cell[88418, 2649, 64, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[88531, 2657, 70, 0, 41, "Subsection"],
Cell[88604, 2659, 1716, 32, 216, "Text"],
Cell[90323, 2693, 287, 8, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[90635, 2705, 168, 4, 26, "Input"],
Cell[90806, 2711, 1364, 24, 139, "Output"]
}, Open  ]],
Cell[92185, 2738, 296, 8, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[92506, 2750, 307, 6, 58, "Input"],
Cell[92816, 2758, 969, 17, 89, "Output"]
}, Open  ]],
Cell[93800, 2778, 122, 4, 40, "MathCaption"],
Cell[93925, 2784, 161, 3, 42, "Input"],
Cell[94089, 2789, 381, 11, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[94495, 2804, 170, 4, 30, "Input"],
Cell[94668, 2810, 64, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[94781, 2818, 155, 4, 41, "Subsection"],
Cell[94939, 2824, 134, 4, 24, "Text"],
Cell[95076, 2830, 184, 3, 30, "DisplayFormula"],
Cell[95263, 2835, 223, 7, 24, "Text"],
Cell[95489, 2844, 373, 7, 48, "NumberedEquation",
  CellTags->"DivisibilityHeuristic"],
Cell[95865, 2853, 419, 11, 56, "Text"],
Cell[96287, 2866, 189, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[96501, 2876, 161, 3, 30, "Input"],
Cell[96665, 2881, 64, 2, 25, "Output"]
}, Open  ]],
Cell[96744, 2886, 236, 7, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[97005, 2897, 134, 3, 30, "Input"],
Cell[97142, 2902, 202, 4, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[97393, 2912, 91, 1, 41, "Subsection",
  CellTags->"ExhaustiveSearch"],
Cell[97487, 2915, 864, 16, 120, "Text"],
Cell[98354, 2933, 134, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[98513, 2940, 210, 5, 41, "Input"],
Cell[98726, 2947, 146, 3, 25, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[98933, 2957, 26, 0, 41, "Section"],
Cell[98962, 2959, 251, 7, 40, "Text"],
Cell[99216, 2968, 529, 13, 94, "DefinitionBox3Col"],
Cell[99748, 2983, 130, 3, 16, "Caption"],

Cell[CellGroupData[{
Cell[99903, 2990, 117, 2, 24, "SubsubsectionIcon"],
Cell[100023, 2994, 579, 20, 56, "Text"],
Cell[100605, 3016, 208, 8, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[100838, 3028, 127, 3, 26, "Input"],
Cell[100968, 3033, 878, 16, 121, "Output"]
}, Open  ]],
Cell[101861, 3052, 145, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[102031, 3060, 180, 3, 42, "Input"],
Cell[102214, 3065, 878, 16, 73, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[103141, 3087, 59, 0, 41, "Subsection"],
Cell[103203, 3089, 330, 10, 40, "Text"],
Cell[103536, 3101, 104, 3, 29, "Program"],
Cell[103643, 3106, 2433, 45, 332, "DefinitionBox3Col"],
Cell[106079, 3153, 257, 9, 16, "Caption"],

Cell[CellGroupData[{
Cell[106361, 3166, 160, 3, 24, "SubsubsectionIcon",
  CellTags->"BranchLinearDiophantine"],
Cell[106524, 3171, 673, 12, 88, "Text"],
Cell[107200, 3185, 134, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[107359, 3192, 510, 9, 74, "Input"],
Cell[107872, 3203, 94, 2, 25, "Output"]
}, Open  ]],
Cell[107981, 3208, 169, 6, 40, "MathCaption"],
Cell[108153, 3216, 163, 3, 42, "Input"],
Cell[108319, 3221, 149, 3, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[108493, 3228, 477, 8, 58, "Input"],
Cell[108973, 3238, 93, 2, 25, "Output"]
}, Open  ]],
Cell[109081, 3243, 155, 4, 40, "MathCaption"],
Cell[109239, 3249, 162, 3, 42, "Input"],
Cell[109404, 3254, 351, 11, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[109780, 3269, 686, 13, 170, "Input"],
Cell[110469, 3284, 438, 7, 73, "Output"]
}, Open  ]],
Cell[110922, 3294, 98, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[111045, 3301, 236, 4, 58, "Input"],
Cell[111284, 3307, 437, 7, 73, "Output"]
}, Open  ]],
Cell[111736, 3317, 315, 7, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[112076, 3328, 807, 15, 202, "Input"],
Cell[112886, 3345, 487, 8, 73, "Output"]
}, Open  ]],
Cell[113388, 3356, 71, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[113484, 3360, 236, 4, 58, "Input"],
Cell[113723, 3366, 486, 8, 73, "Output"]
}, Open  ]],
Cell[114224, 3377, 155, 4, 40, "MathCaption"],
Cell[114382, 3383, 165, 3, 42, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[114584, 3391, 156, 3, 24, "SubsubsectionIcon",
  CellTags->"DiscreteSolutionBound"],
Cell[114743, 3396, 761, 20, 72, "Text"],
Cell[115507, 3418, 204, 7, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[115736, 3429, 102, 2, 30, "Input"],
Cell[115841, 3433, 229, 4, 25, "Output"]
}, Open  ]],
Cell[116085, 3440, 214, 7, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[116324, 3451, 102, 2, 30, "Input"],
Cell[116429, 3455, 116, 2, 25, "Output"]
}, Open  ]],
Cell[116560, 3460, 114, 4, 40, "MathCaption"],
Cell[116677, 3466, 161, 3, 42, "Input"],
Cell[116841, 3471, 114, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[116980, 3479, 102, 2, 30, "Input"],
Cell[117085, 3483, 246, 4, 41, "Output"]
}, Open  ]],
Cell[117346, 3490, 122, 4, 40, "MathCaption"],
Cell[117471, 3496, 161, 3, 42, "Input"],
Cell[117635, 3501, 240, 8, 24, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117912, 3514, 170, 3, 24, "SubsubsectionIcon",
  CellTags->"ExhaustiveSearchMaxPoints"],
Cell[118085, 3519, 717, 13, 104, "Text"],
Cell[118805, 3534, 190, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[119020, 3544, 219, 5, 42, "Input"],
Cell[119242, 3551, 331, 5, 31, "Message"],
Cell[119576, 3558, 220, 5, 41, "Output"]
}, Open  ]],
Cell[119811, 3566, 154, 4, 40, "MathCaption"],
Cell[119968, 3572, 177, 3, 42, "Input"],
Cell[120148, 3577, 101, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[120274, 3585, 219, 5, 42, "Input"],
Cell[120496, 3592, 142, 3, 25, "Output"]
}, Open  ]],
Cell[120653, 3598, 222, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[120900, 3608, 333, 6, 62, "Input"],
Cell[121236, 3616, 300, 6, 41, "Output"]
}, Open  ]],
Cell[121551, 3625, 335, 10, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[121911, 3639, 360, 7, 68, "Input"],
Cell[122274, 3648, 297, 6, 41, "Output"]
}, Open  ]],
Cell[122586, 3657, 113, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[122724, 3664, 361, 7, 62, "Input"],
Cell[123088, 3673, 127, 3, 25, "Output"]
}, Open  ]],
Cell[123230, 3679, 60, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[123315, 3683, 347, 7, 62, "Input"],
Cell[123665, 3692, 127, 3, 25, "Output"]
}, Open  ]],
Cell[123807, 3698, 126, 4, 40, "MathCaption"],
Cell[123936, 3704, 176, 3, 42, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124149, 3712, 162, 3, 24, "SubsubsectionIcon",
  CellTags->"LatticeReduceDiophantine"],
Cell[124314, 3717, 698, 16, 88, "Text"],
Cell[125015, 3735, 320, 9, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[125360, 3748, 290, 7, 60, "Input"],
Cell[125653, 3757, 198, 4, 25, "Output"]
}, Open  ]],
Cell[125866, 3764, 170, 6, 40, "MathCaption"],
Cell[126039, 3772, 167, 3, 42, "Input"],
Cell[126209, 3777, 180, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[126414, 3787, 260, 6, 42, "Input"],
Cell[126677, 3795, 196, 4, 25, "Output"]
}, Open  ]],
Cell[126888, 3802, 422, 11, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[127335, 3817, 613, 12, 154, "Input"],
Cell[127951, 3831, 93, 2, 25, "Output"]
}, Open  ]],
Cell[128059, 3836, 71, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[128155, 3840, 244, 4, 58, "Input"],
Cell[128402, 3846, 94, 2, 25, "Output"]
}, Open  ]],
Cell[128511, 3851, 125, 4, 40, "MathCaption"],
Cell[128639, 3857, 167, 3, 42, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[128843, 3865, 154, 3, 24, "SubsubsectionIcon",
  CellTags->"MaxFrobeniusGraph"],
Cell[129000, 3870, 1043, 24, 120, "Text"],
Cell[130046, 3896, 451, 10, 88, "MathCaption"],

Cell[CellGroupData[{
Cell[130522, 3910, 321, 7, 95, "Input"],
Cell[130846, 3919, 560, 8, 89, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131443, 3932, 72, 2, 26, "Input"],
Cell[131518, 3936, 65, 2, 25, "Output"]
}, Open  ]],
Cell[131598, 3941, 175, 7, 40, "MathCaption"],
Cell[131776, 3950, 159, 3, 30, "Input"],
Cell[131938, 3955, 205, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[132168, 3964, 174, 4, 26, "Input"],
Cell[132345, 3970, 573, 8, 89, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[132955, 3983, 72, 2, 26, "Input"],
Cell[133030, 3987, 66, 2, 25, "Output"]
}, Open  ]],
Cell[133111, 3992, 118, 4, 40, "MathCaption"],
Cell[133232, 3998, 156, 3, 30, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133425, 4006, 148, 3, 24, "SubsubsectionIcon",
  CellTags->"SieveMaxPoints"],
Cell[133576, 4011, 440, 12, 56, "Text"],
Cell[134019, 4025, 199, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[134243, 4035, 139, 3, 30, "Input"],
Cell[134385, 4040, 393, 6, 44, "Message"],
Cell[134781, 4048, 140, 3, 26, "Output"]
}, Open  ]],
Cell[134936, 4054, 189, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[135150, 4064, 259, 5, 62, "Input"],
Cell[135412, 4071, 116, 2, 25, "Output"]
}, Open  ]],
Cell[135543, 4076, 115, 4, 40, "MathCaption"],
Cell[135661, 4082, 157, 3, 26, "Input"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[135879, 4092, 59, 1, 41, "Section",
  CellTags->{"t:29", "c:29"}],
Cell[135941, 4095, 295, 8, 24, "Text",
  CellTags->"1"],
Cell[136239, 4105, 469, 16, 40, "Text",
  CellTags->"2"],
Cell[136711, 4123, 363, 11, 40, "Text",
  CellTags->"3"],
Cell[137077, 4136, 359, 11, 40, "Text",
  CellTags->"4"],
Cell[137439, 4149, 499, 12, 56, "Text",
  CellTags->"5"],
Cell[137941, 4163, 174, 6, 24, "Text",
  CellTags->"6"],
Cell[138118, 4171, 164, 6, 24, "Text",
  CellTags->"7"],
Cell[138285, 4179, 537, 19, 40, "Text",
  CellTags->"8"],
Cell[138825, 4200, 289, 9, 40, "Text",
  CellTags->"9"],
Cell[139117, 4211, 216, 6, 40, "Text",
  CellTags->"10"],
Cell[139336, 4219, 303, 8, 40, "Text",
  CellTags->"11"],
Cell[139642, 4229, 337, 10, 40, "Text",
  CellTags->"12"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

