(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    219291,       6086]*)
(*NotebookOutlinePosition[    224693,       6279]*)
(*  CellTagsIndexPosition[    223584,       6234]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Real Polynomial Systems", "Chapter",
  CellTags->{"t:1", "c:1"}],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"t:3", "c:3"}],

Cell[TextData[{
  "A ",
  StyleBox["real polynomial system",
    FontSlant->"Italic"],
  " is an expression constructed with polynomial equations and inequalities"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(f(x\_1,  ... , x\_n) \[Equal] \ 
      g(x\_1,  ... , x\_n), 
    f(x\_1,  ... , x\_n) \[NotEqual] \ 
      g(x\_1,  ... , x\_n), \[IndentingNewLine]f(x\_1,  ... , 
        x\_n) \[GreaterEqual] \ g(x\_1,  ... , x\_n), \ 
    f(x\_1,  ... , x\_n) > \ 
      g(x\_1,  ... , x\_n), \[IndentingNewLine]f(x\_1,  ... , 
        x\_n) \[LessEqual] \ \ g(x\_1,  ... , x\_n), 
    f(x\_1,  ... , x\_n) < \ g(x\_1,  ... , x\_n)\)\)\)], "DisplayFormula"],

Cell["combined using logical connectives and quantifiers", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[CapitalPhi]\_1 \[And] \[CapitalPhi]\_2, \ \
\[CapitalPhi]\_1 \[Or] \[CapitalPhi]\_2, \ \[CapitalPhi]\_1 \[Implies] \
\[CapitalPhi]\_2, \[Not] \[CapitalPhi], \[ForAll] \_x \[CapitalPhi], \ 
    and\ \ \(\[Exists] \_x\( \(\[CapitalPhi]\)\(.\)\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "An occurrence of a variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " inside ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \_x \[CapitalPhi]\ \ or\ \ \(\[Exists] \_x \
\[CapitalPhi]\)\)]],
  " is called a ",
  StyleBox["bound occurrence",
    FontSlant->"Italic"],
  ";",
  " any other occurrence of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called a ",
  StyleBox["free occurrence.",
    FontSlant->"Italic"],
  " A variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called a ",
  StyleBox["free variable",
    FontSlant->"Italic"],
  " of a real polynomial system if the system contains a free occurrence of \
",
  StyleBox["x",
    FontSlant->"Italic"],
  ". A real polynomial system is ",
  StyleBox["quantifier free",
    FontSlant->"Italic"],
  " if it contains no quantifiers."
}], "Text"],

Cell[TextData[{
  "An example of a real polynomial system with free variables ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["z ",
    FontSlant->"Italic"],
  "is the following"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`x\^2 + y\^2 \[LessEqual] \ 
        z\^2 \[And] \[Exists] \_t\(\((\[ForAll] \_u t\ x > 
                  u\ y\ z + 7 \[Or] \(x\^2\) t \[Equal] 
                2\ z + 1)\)\(.\)\)\)], "NumberedEquation",
  CellTags->"Real1"],

Cell[TextData[{
  "Any real polynomial system can be transformed to the ",
  StyleBox["prenex normal form",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(Q\_\(1\ y\_1\)\) 
          Q\_\(2\ y\_2\) ... \) \(Q\_\(m\ y\_m\)\) \(\[CapitalPhi](
        x\_1,  ... , x\_n; y\_1,  ... , 
        y\_m)\)\)\(,\)\)\)], "NumberedEquation",
  CellTags->"PNF"],

Cell[TextData[{
  "where each ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_i\)]],
  " is \[ForAll] or \[Exists], and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n; y\_1,  ... , 
        y\_m)\)]],
  " is a quantifier-free formula called the ",
  StyleBox["quantifier",
    FontSlant->"Italic"],
  "-",
  StyleBox["free part ",
    FontSlant->"Italic"],
  "of the system."
}], "Text"],

Cell[TextData[{
  "Any quantifier-free real polynomial system can be transformed to the ",
  StyleBox["disjunctive normal form",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\(\((\(\(\(\[CurlyPhi]\_\(1, 
                      1\)\)\(\[And]\)\) ... \) \[And] \[CurlyPhi]\_\(1, \
n\_1\))\)\(\[Or]\)\) ... \) \[Or] \((\(\(\(\[CurlyPhi]\_\(m, 
                  1\)\)\(\[And]\)\) ... \) \[And] \[CurlyPhi]\_\(m, n\_m\))\)\
\)\(,\)\)\)], "NumberedEquation",
  CellTags->"DNF"],

Cell[TextData[{
  "where each ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi]\_\(i, j\)\)]],
  " is a polynomial equation or inequality. "
}], "Text"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " always put real polynomial systems in the prenex normal form, with \
quantifier-free parts in the disjunctive normal form, and subtract sides of \
equations and inequalities to put them in the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\ \)\(f(x\_1,  ... , 
        x\_n) \[Equal] \((\(\(or\)\(\ \)\(\[NotEqual]\)\), \ \(\(\
\[GreaterEqual]\)\(\ \)\(\(,\)\(\(>\)\(\(,\)\(\(\[LessEqual]\)\(\ \
\)\(\(,\)\(<\)\)\)\)\)\)\))\)\ \ 0. \)\)\)], "DisplayFormula"],

Cell["\<\
In the following sections we will always assume the system has been \
transformed to the previous form.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " can solve arbitrary real polynomial systems. For a system with free \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  ", the solution (possibly after expanding \[And] with respect to \[Or]) is \
a disjunction of terms of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(B(\(x\_1;\))\  \[And] 
          B(x\_2; x\_1)\  \[And] \ \ B(x\_3; x\_1, 
            x\_2)\  \[And]  ... \) \[And] \ 
      B(x\_n; x\_1,  ... , x\_\(n - 1\))\)\(,\)\)\)], "NumberedEquation",
  TextAlignment->Center,
  CellTags->"GeneralRealSolution"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`B(x\_k; x\_1,  ... , x\_\(k - 1\))\)],
    TextAlignment->Center],
  " is one of"
}], "Text"],

Cell[BoxData[{
    FormBox[\(x\_k \[Equal] \(r\_1\)(x\_1,  ... , x\_\(k - 1\))\), 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[\(\(r\_1\)(x\_1,  ... , 
          x\_\(k - 1\)) < \((\(or\)\(\ \)\(\[LessEqual]\))\)\ x\_k < \
\((\(or\)\(\ \)\(\[LessEqual]\))\)\ \(\(r\_2\)(x\_1,  ... , x\_\(k - 1\))\)\),
       TraditionalForm], "\[IndentingNewLine]", 
    FormBox[\(x\_k < \((\(or\)\(\ \)\(\[LessEqual]\))\)\ \(\(r\_2\)(
            x\_1,  ... , x\_\(k - 1\))\)\), 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[\(x\_k > \((\(or\)\(\ \)\(\[GreaterEqual]\))\)\ \(\(r\_1\)(
            x\_1,  ... , x\_\(k - 1\))\)\), 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[
      StyleBox["True",
        "MR"], TraditionalForm]}], "NumberedEquation",
  TextAlignment->Center,
  CellTags->"RealSolutionTerm"],

Cell[TextData[{
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`r\_\(\(1\)\(\ \)\)\)],
    TextAlignment->Center],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`r\_2\)]],
  " are algebraic functions (expressed using ",
  StyleBox["Root", "MR"],
  " objects or radicals) such that for all ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_\(k - 1\)\)],
    TextAlignment->Center],
  " satisfying ",
  Cell[BoxData[
      \(TraditionalForm\`\(B(\(x\_1;\))\  \[And] 
            B(x\_2; x\_1)\  \[And]  ... \) \[And] \ 
        B(x\_\(k - 1\); x\_1,  ... , x\_\(k - 2\))\)],
    TextAlignment->Center],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`r\_\(\(1\)\(\ \)\)\)],
    TextAlignment->Center],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`r\_2\)]],
  " are well defined (that is, denominators and leading terms of ",
  StyleBox["Root", "MR"],
  " objects are nonzero), real valued, continuous, and satisfy inequality ",
  Cell[BoxData[
      \(TraditionalForm\`r\_1 < r\_2\)]],
  "."
}], "Text"],

Cell[TextData[{
  "The subset of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " described by formula (",
  ButtonBox["4",
    ButtonData:>"GeneralRealSolution",
    ButtonStyle->"Hyperlink"],
  ") is called a ",
  StyleBox["cell",
    FontSlant->"Italic"],
  ". The cells described by different terms of solution of a real polynomial \
system are disjoint."
}], "Text"],

Cell[TextData[{
  "This solves the system (",
  ButtonBox["1",
    ButtonData:>"Real1",
    ButtonStyle->"Hyperlink"],
  "). The cells are represented in a nested form."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      Reduce[x\^2 + y\^2 \[LessEqual] \ 
            z\^2 && \[Exists] \_t\((\[ForAll] \_u t\ x > u\ y\ z + 7 || 
                x\^2\ t \[Equal] 2\ z + 1)\), {x, y, z}, Reals]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(\((x < 
            0 && \((z \[LessEqual] \(-\@\(x\^2 + y\^2\)\) || 
              z \[GreaterEqual] \@\(x\^2 + y\^2\))\))\) || \((x \[Equal] 
            0 && \(-\(1\/2\)\) \[LessEqual] y \[LessEqual] 1\/2 && 
          z \[Equal] \(-\(1\/2\)\))\) || \((0 < x < 
            1\/2 && \((\((y < \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) && \((z \
\[LessEqual] \(-\@\(x\^2 + y\^2\)\) || 
                      z \[GreaterEqual] \@\(x\^2 + y\^2\))\))\) || \((y \
\[Equal] \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) && \((z \[LessEqual] \(-\(1\/2\)\) || 
                      z \[GreaterEqual] \@\(x\^2 + y\^2\))\))\) || \
\((\(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) < y < 
                    1\/2\ \@\(1 - 4\ x\^2\) && \((z \[LessEqual] \(-\@\(x\^2 \
+ y\^2\)\) || z \[GreaterEqual] \@\(x\^2 + y\^2\))\))\) || \((y \[Equal] 
                    1\/2\ \@\(1 - 4\ x\^2\) && \((z \[LessEqual] \
\(-\(1\/2\)\) || z \[GreaterEqual] \@\(x\^2 + y\^2\))\))\) || \((y > 
                    1\/2\ \@\(1 - 4\ x\^2\) && \((z \[LessEqual] \(-\@\(x\^2 \
+ y\^2\)\) || 
                      z \[GreaterEqual] \@\(x\^2 + y\^2\))\))\))\))\) || \((x \
\[Equal] 1\/2 && \((\((y < 
                    0 && \((z \[LessEqual] \(-\@\(1\/4 + y\^2\)\) || 
                      z \[GreaterEqual] \@\(1\/4 + y\^2\))\))\) || \((y \
\[Equal] 0 && \((z \[LessEqual] \(-\(1\/2\)\) || 
                      z \[GreaterEqual] 1\/2)\))\) || \((y > 
                    0 && \((z \[LessEqual] \(-\@\(1\/4 + y\^2\)\) || 
                      z \[GreaterEqual] \@\(1\/4 + y\^2\))\))\))\))\) || \((x \
> 1\/2 && \((z \[LessEqual] \(-\@\(x\^2 + y\^2\)\) || 
              z \[GreaterEqual] \@\(x\^2 + y\^2\))\))\)\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell["\<\
This defines a function expanding \[And] with respect to \
\[Or].\
\>", "MathCaption"],

Cell[BoxData[{
    \(lexp[e_Or] := lexp /@ e\), "\n", 
    \(lexp[And[a___, b_Or, c___]] := \(lexp[And[a, #, c]] &\) /@ b\), "\n", 
    \(lexp[other_] := other\)}], "Input",
  CellLabel->"In[2]:="],

Cell[TextData[{
  "Here is the solution of the system (",
  ButtonBox["1",
    ButtonData:>"Real1",
    ButtonStyle->"Hyperlink"],
  ") written explicitly as a union of disjoint cells."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(lexp[sol]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(\((x < 0 && z \[LessEqual] \(-\@\(x\^2 + y\^2\)\))\) || \((x < 0 && 
          z \[GreaterEqual] \@\(x\^2 + y\^2\))\) || \((x \[Equal] 
            0 && \(-\(1\/2\)\) \[LessEqual] y \[LessEqual] 1\/2 && 
          z \[Equal] \(-\(1\/2\)\))\) || \((0 < x < 1\/2 && 
          y < \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) && 
          z \[LessEqual] \(-\@\(x\^2 + y\^2\)\))\) || \((0 < x < 1\/2 && 
          y < \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) && 
          z \[GreaterEqual] \@\(x\^2 + y\^2\))\) || \((0 < x < 1\/2 && 
          y \[Equal] \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) && 
          z \[LessEqual] \(-\(1\/2\)\))\) || \((0 < x < 1\/2 && 
          y \[Equal] \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) && 
          z \[GreaterEqual] \@\(x\^2 + y\^2\))\) || \((0 < x < 
            1\/2 && \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) < y < 
            1\/2\ \@\(1 - 4\ x\^2\) && 
          z \[LessEqual] \(-\@\(x\^2 + y\^2\)\))\) || \((0 < x < 
            1\/2 && \(-\(1\/2\)\)\ \@\(1 - 4\ x\^2\) < y < 
            1\/2\ \@\(1 - 4\ x\^2\) && 
          z \[GreaterEqual] \@\(x\^2 + y\^2\))\) || \((0 < x < 1\/2 && 
          y \[Equal] 1\/2\ \@\(1 - 4\ x\^2\) && 
          z \[LessEqual] \(-\(1\/2\)\))\) || \((0 < x < 1\/2 && 
          y \[Equal] 1\/2\ \@\(1 - 4\ x\^2\) && 
          z \[GreaterEqual] \@\(x\^2 + y\^2\))\) || \((0 < x < 1\/2 && 
          y > 1\/2\ \@\(1 - 4\ x\^2\) && 
          z \[LessEqual] \(-\@\(x\^2 + y\^2\)\))\) || \((0 < x < 1\/2 && 
          y > 1\/2\ \@\(1 - 4\ x\^2\) && 
          z \[GreaterEqual] \@\(x\^2 + y\^2\))\) || \((x \[Equal] 1\/2 && 
          y < 0 && z \[LessEqual] \(-\@\(1\/4 + y\^2\)\))\) || \((x \[Equal] 
            1\/2 && y < 0 && 
          z \[GreaterEqual] \@\(1\/4 + y\^2\))\) || \((x \[Equal] 1\/2 && 
          y \[Equal] 0 && 
          z \[LessEqual] \(-\(1\/2\)\))\) || \((x \[Equal] 1\/2 && 
          y \[Equal] 0 && z \[GreaterEqual] 1\/2)\) || \((x \[Equal] 1\/2 && 
          y > 0 && z \[LessEqual] \(-\@\(1\/4 + y\^2\)\))\) || \((x \[Equal] 
            1\/2 && y > 0 && 
          z \[GreaterEqual] \@\(1\/4 + y\^2\))\) || \((x > 1\/2 && 
          z \[LessEqual] \(-\@\(x\^2 + y\^2\)\))\) || \((x > 1\/2 && 
          z \[GreaterEqual] \@\(x\^2 + y\^2\))\)\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Resolve", "MR"],
  " can eliminate quantifiers from arbitrary real polynomial systems. If no \
variables are specified in the input and all input polynomials are at most \
linear in the bound variables, ",
  StyleBox["Resolve", "MR"],
  " may be able to eliminate the quantifiers without solving the resulting \
system.  Otherwise, ",
  StyleBox["Resolve", "MR"],
  " uses the same algorithm and gives the same answer as ",
  StyleBox["Reduce", "MR"],
  ". "
}], "Text"],

Cell[TextData[{
  "This eliminates quantifiers from the system (",
  ButtonBox["1",
    ButtonData:>"Real1",
    ButtonStyle->"Hyperlink"],
  ")."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[
      x\^2 + y\^2 \[LessEqual] \ 
          z\^2 && \[Exists] \_t\((\[ForAll] \_u t\ x > u\ y\ z + 7 || 
              x\^2\ t \[Equal] 2\ z + 1)\), Reals]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \(\((1\/2 + z \[Equal] 0 && 
          x\^2 + y\^2 - z\^2 \[LessEqual] 0)\) || \((x\^2 \[NotEqual] 0 && 
          x\^2 + y\^2 - z\^2 \[LessEqual] 0)\) || \((\(-x\) < 0 && 
          y\ z \[Equal] 0 && 
          x\^2 + y\^2 - z\^2 \[LessEqual] 0)\) || \((x < 0 && 
          y\ z \[Equal] 0 && x\^2 + y\^2 - z\^2 \[LessEqual] 0)\)\)], "Output",\

  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["FindInstance", "MR"],
  " can handle arbitrary real polynomial systems, giving instances of real \
solutions or an empty list for systems that have no solutions. If the number \
of instances requested is more than one, the instances are randomly generated \
from the full solution of the system and therefore may depend on the value of \
the ",
  StyleBox["RandomSeed", "MR"],
  " option. If one instance is requested and the system does not contain \
general (\[ForAll]) quantifiers, a faster algorithm producing one instance is \
used and the instance returned is always the same."
}], "Text"],

Cell[TextData[{
  "This finds a solution of the system (",
  ButtonBox["1",
    ButtonData:>"Real1",
    ButtonStyle->"Hyperlink"],
  ")."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
      x\^2 + y\^2 \[LessEqual] \ 
          z\^2 && \[Exists] \_t\((\[ForAll] \_u t\ x > u\ y\ z + 7 || 
              x\^2\ t \[Equal] 2\ z + 1)\), {x, y, z}, Reals]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({{x \[Rule] \(-51\), y \[Rule] 47\/10, 
        z \[Rule] \(-\(\@262309\/10\)\)}}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "The main general tool used in solving real polynomial systems is the \
Cylindrical Algebraic Decomposition (CAD) algorithm (see, for example, [",
  ButtonBox["1",
    ButtonData:>"1",
    ButtonStyle->"Hyperlink"],
  "]). CAD for quantifier-free systems is available in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directly as ",
  ButtonBox["CylindricalDecomposition",
    ButtonStyle->"RefGuideLink"],
  ". There are also several other algorithms used to solve special case \
problems."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Cylindrical Algebraic Decomposition", "Section"],

Cell[CellGroupData[{

Cell["Semi-algebraic Sets and Cell Decomposition", "Subsection"],

Cell[TextData[{
  "A subset of  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " is ",
  StyleBox["semi",
    FontSlant->"Italic"],
  "-",
  StyleBox["algebraic",
    FontSlant->"Italic"],
  " if it is a solution set of a quantifier-free real polynomial system. \
According to Tarski's theorem [",
  ButtonBox["2",
    ButtonData:>"2",
    ButtonStyle->"Hyperlink"],
  "], solution sets of arbitrary (quantified) real polynomial systems are \
semi-algebraic."
}], "Text"],

Cell[TextData[{
  "Every semi-algebraic set can be represented as a finite union of disjoint \
cells [",
  ButtonBox["3",
    ButtonData:>"3",
    ButtonStyle->"Hyperlink"],
  "] defined recursively as follows."
}], "Text"],

Cell["\<\
A cell in \[DoubleStruckCapitalR] is a point or an open interval.\
\
\>", "BulletText"],

Cell[TextData[{
  "A cell in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^k\)]],
  " has one of the two forms"
}], "BulletText"],

Cell[BoxData[{
    \(TraditionalForm\`{\((a\_1, \[Ellipsis], a\_k, 
            a\_\(k + 1\))\) : \((a\_1, \[Ellipsis], a\_k)\) \[Element] 
            C\_k\[Wedge]a\_\(k + 1\) = 
        r(a\_1, \[Ellipsis], a\_k)}\), "\[IndentingNewLine]", 
    \(TraditionalForm\`\(\({\((a\_1, \[Ellipsis], a\_k, 
          a\_\(k + 1\))\) : \((a\_1, \[Ellipsis], a\_k)\) \[Element] 
          C\_k\[Wedge]r\_1 \((a\_1, \[Ellipsis], a\_k)\) < 
            a\_\(k + 1\) < \(r\_2\)(a\_1, \[Ellipsis], 
              a\_k)}\)\(,\)\)\)}], "NumberedEquation"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`C\_k\)]],
  " is a cell in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^k\)]],
  ", ",
  StyleBox["r",
    FontSlant->"Italic"],
  "  is a continuous algebraic function, ",
  Cell[BoxData[
      \(TraditionalForm\`r\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`r\_2\)]],
  " are continuous algebraic functions, -\[Infinity], or \[Infinity], and ",
  Cell[BoxData[
      \(TraditionalForm\`r\_1 < r\_2\)]],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`C\_k\)]],
  "."
}], "Text"],

Cell[TextData[{
  "By an algebraic function we mean a function  ",
  Cell[BoxData[
      \(TraditionalForm\`r : 
        C\_k\[LongRightArrow]\[DoubleStruckCapitalR]\)]],
  " for which there is a polynomial"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`f = \(c\_0\) x\_\(k + 1\)\^m + \(c\_1\) 
            x\_\(k + 1\)\^\(m - 1\) + \[Ellipsis]c\_m \[Element] \
\[DoubleStruckCapitalR][x\_1, \[Ellipsis], x\_k, 
          x\_\(k + 1\)]\)], "DisplayFormula"],

Cell["such that ", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(c\_0\)(a\_1, \[Ellipsis], a\_k) \[NotEqual] 
        0\[Wedge]f \((a\_1, \[Ellipsis], a\_k, 
            r(a\_1, \[Ellipsis], a\_k))\) = 0. \)], "DisplayFormula"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " algebraic functions can be represented as ",
  StyleBox["Root", "MR"],
  " objects or radicals."
}], "Text"],

Cell[TextData[{
  "The CAD algorithm, introduced by Collins [",
  ButtonBox["4",
    ButtonData:>"4",
    ButtonStyle->"Hyperlink"],
  "], computes a cell decomposition of solution sets of arbitrary real \
polynomial systems. The objective of the original Collins algorithm was to \
eliminate quantifiers from a quantified real polynomial system and to produce \
an equivalent quantifier-free polynomial system. After finding a cell \
decomposition, the algorithm performed an additional step of finding an \
implicit representation of the semi-algebraic set in terms of polynomial \
equations and inequalities in the free variables. The objective of ",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["Reduce", "MR"],
  " is somewhat different. Given a semi-algebraic set presented by a real \
polynomial system, quantified or not, ",
  StyleBox["Reduce", "MR"],
  " finds a cell decomposition of the set, explicitly written in terms of \
algebraic functions."
}], "Text"],

Cell[TextData[{
  "While",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["Reduce", "MR"],
  " may use other methods to solve the system, ",
  StyleBox["CylindricalDecomposition", "MR"],
  " gives a direct access to the CAD algorithm. For a quantifier-free real \
polynomial system, ",
  StyleBox["CylindricalDecomposition", "MR"],
  " gives a nested formula representing disjunction of cells in the solved \
form (",
  ButtonBox["4",
    ButtonData:>"GeneralRealSolution",
    ButtonStyle->"Hyperlink"],
  "). As in the output of ",
  StyleBox["Reduce", "MR"],
  ", the cells are disjoint and additionally are always ordered \
lexicographically with respect to ranges of the subsequent variables."
}], "Text"],

Cell["This finds a cell decomposition of an annulus.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CylindricalDecomposition[
      1 \[LessEqual] \ x^2 + y^2 < 2, \ {x, \ y}]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \(\((\(-\@2\) < x < \(-1\) && \(-\@\(2 - x\^2\)\) < 
            y < \@\(2 - x\^2\))\) || \((\(-1\) \[LessEqual] x \[LessEqual] 
            1 && \((\(-\@\(2 - x\^2\)\) < 
                y \[LessEqual] \(-\@\(1 - x\^2\)\) || \@\(1 - x\^2\) \
\[LessEqual] y < \@\(2 - x\^2\))\))\) || \((1 < 
            x < \@2 && \(-\@\(2 - x\^2\)\) < 
            y < \@\(2 - x\^2\))\)\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Projection Phase of the CAD Algorithm", "Subsection"],

Cell[TextData[{
  "Finding a cell decomposition of a semi-algebraic set using the CAD \
algorithm consists of two phases, projection and lifting. In the projection \
phase, we start with the set ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(n + m\)\)]],
  " of factors of the polynomials present in the quantifier-free part \
\[CapitalPhi]",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_1,  ... , x\_n; y\_1,  ... , y\_m)\)\)]],
  " of the system (",
  ButtonBox["2",
    ButtonData:>"PNF",
    ButtonStyle->"Hyperlink"],
  ") and eliminate variables one by one using a projection operator ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " such that"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(P\_\(k + 1\)\) : \[DoubleStruckCapitalR][
          t\_1, \[Ellipsis], t\_k, t\_\(k + 1\)] \[Superset] 
        A\_\(k + 1\)\[LongRightArrow]
          A\_k \[Subset] \(\(\[DoubleStruckCapitalR][t\_1, \[Ellipsis], 
            t\_k]\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "Generally speaking, if all polynomials of ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k\)]],
  " have constant signs on a cell ",
  Cell[BoxData[
      \(TraditionalForm\`C \[Subset] \[DoubleStruckCapitalR]\^k\)]],
  ", then all polynomials of ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(k + 1\)\)]],
  " are delineable over ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ", that is, each has a fixed number of real roots on ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " as a polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`t\_\(k + 1\)\)]],
  ", the roots are continuous functions on ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ", they have constant multiplicities, and two roots of two of the \
polynomials are equal either everywhere or nowhere in ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ". Variables are ordered so that"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\((t\_1, \[Ellipsis], 
        t\_\(n + m\))\) = \(\((x\_1,  ... , x\_n, y\_1,  ... , 
          y\_m)\)\(.\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "This way the roots of polynomials of ",
  Cell[BoxData[
      \(TraditionalForm\`A\_1, \[Ellipsis], A\_n\)]],
  " are the algebraic functions needed in the construction of the cell \
decomposition of the semi-algebraic set."
}], "Text"],

Cell[TextData[{
  "Several improvements have reduced the size of the original Collins \
projection. The currently best projection operator applicable in all cases is \
due to Hong [",
  ButtonBox["5",
    ButtonData:>"5",
    ButtonStyle->"Hyperlink"],
  "]; however, in most situations we can use a smaller projection operator \
given by McCallum [",
  ButtonBox["6",
    ButtonData:>"6",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["7",
    ButtonData:>"7",
    ButtonStyle->"Hyperlink"],
  "], with an improvement by Brown [",
  ButtonBox["8",
    ButtonData:>"8",
    ButtonStyle->"Hyperlink"],
  "]. There are even smaller projection operators that can be applied in some \
special cases. When equational constraints are present, we can use the \
projection operator suggested by Collins [",
  ButtonBox["9",
    ButtonData:>"9",
    ButtonStyle->"Hyperlink"],
  "], and developed and proven by McCallum [",
  ButtonBox["10",
    ButtonData:>"10",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["11",
    ButtonData:>"11",
    ButtonStyle->"Hyperlink"],
  "]. When there are no equations and only strict inequalities, and there are \
no free variables or we are interested only in the full-dimensional part of \
the semi-algebraic set, we can use an even smaller projection operator \
described in [",
  ButtonBox["12",
    ButtonData:>"12",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["13",
    ButtonData:>"13",
    ButtonStyle->"Hyperlink"],
  "]. For systems containing equational constraints that generate a \
zero-dimensional ideal, Gr\[ODoubleDot]bner bases are used to find projection \
polynomials. "
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the smallest of the previously mentioned projections that is \
appropriate for the given example. Whenever applicable, we use the equational \
constraints; otherwise, we attempt to use McCallum\[CloseCurlyQuote]s \
projection with Brown\[CloseCurlyQuote]s improvement. When the system does \
not turn out to be well oriented, we compute Hong\[CloseCurlyQuote]s \
projection."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Lifting Phase of the CAD Algorithm", "Subsection",
  CellTags->"CADLift"],

Cell[TextData[{
  "In the lifting phase, we find a cell decomposition of the semi-algebraic \
set. Generally speaking, although the actual details depend on the projection \
operator used, we start with cells in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^1\)]],
  " consisting of all distinct roots of ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(A\_1\)\(\ \)\)\)]],
  "and the open intervals between the roots. We find a sample point in each \
of the cells and remove the cells whose sample points do not satisfy the \
system describing the semi-algebraic set (the system may contain conditions \
involving only ",
  Cell[BoxData[
      \(TraditionalForm\`t\_1\)]],
  "). Next we lift the cells to cells in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ", one dimension at a time. Suppose we have lifted the cells to ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^k\)]],
  ". To lift a cell ",
  Cell[BoxData[
      \(TraditionalForm\`C \[Subset] \[DoubleStruckCapitalR]\^k\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^\(k + 1\)\)]],
  ", we find the real roots of  ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(k + 1\)\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`t\_1, \[Ellipsis], t\_k\)]],
  " replaced with the coordinates of the sample point ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ". Since the polynomials of  ",
  Cell[BoxData[
      \(TraditionalForm\`A\_\(k + 1\)\)]],
  "are delineable on ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ", each root ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " is a value of a continuous algebraic function at ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ", and the function can be represented as a ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  "th root of a polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`f \[Element] A\_\(k + 1\)\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " is the ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  "th root of ",
  Cell[BoxData[
      \(TraditionalForm\`f(c, t\_\(k + 1\))\)]],
  ". Now the lifting of the cell ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^\(k + 1\)\)]],
  " will consist of graphs of these algebraic functions and of the slices of \
",
  Cell[BoxData[
      \(TraditionalForm\`C\[Times]\[DoubleStruckCapitalR]\)]],
  " between the subsequent graphs. The sample points in each of the new cells \
will be obtained by adding the ",
  Cell[BoxData[
      \(TraditionalForm\`k + 1\)]],
  "st coordinate to ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ", equal to one of the roots, or to a number between two subsequent roots. \
As in the first step, we remove those lifted cells whose sample points do not \
satisfy the system describing the semi-algebraic set. "
}], "Text"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`k \[GreaterEqual] \ n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`t\_\(k + 1\) = y\_l\)]],
  " is a quantifier variable and we may not need to construct all the lifted \
cells. All we need is to find the (necessarily constant) truth value of ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Q\_\(l\ y\_l\)\) 
            Q\_\(l + 1\ y\_\(l + 1\)\) ... \) \(Q\_\(m\ y\_m\)\) \
\[CapitalPhi]\)]],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_l \[Equal] \[Exists] \)]],
  ", we know that the value is ",
  StyleBox["True", "MR"],
  " as soon as the truth value of  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Q\_\(l + 1\ y\_\(l + 1\)\) ... \) \(Q\_\(m\ y\_m\
\)\) \(\[CapitalPhi]\)\(\ \)\)\)]],
  "on one of the lifted cells is ",
  StyleBox["True", "MR"],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`Q\_l \[Equal] \[ForAll] \)]],
  ", we know that the value is ",
  StyleBox["False", "MR"],
  " as soon as the truth value of  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Q\_\(l + 1\ y\_\(l + 1\)\) ... \) \(Q\_\(m\ y\_m\
\)\) \(\[CapitalPhi]\)\(\ \)\)\)]],
  "on one of the lifted cells is ",
  StyleBox["False", "MR"],
  "."
}], "Text"],

Cell[TextData[{
  "The coefficients of sample points computed this way are in general \
algebraic numbers. To save costly algebraic number computations, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses arbitrary-precision floating point number (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \"bignum\") approximations of the coefficients, whenever the results can \
be validated. Note that using approximate arithmetic may be enough to prove \
that two roots of a polynomial or a pair of polynomials are distinct, and to \
find a nonzero sign of a polynomial at a sample point. What we cannot prove \
with approximate arithmetic is that two roots of a polynomial or a pair of \
polynomials are equal, or that a polynomial is zero at a sample point. \
However, we can often use information about the origins of the cell to \
resolve these problems. For instance, if we know that the resultant of two \
polynomials vanishes on the cell, and these two polynomials have exactly one \
pair of complex roots that can be equal within the precision bounds, we can \
conclude that these roots are equal. Similarly, if the last coordinate of a \
sample point was a root of a factor of the given polynomial, we know that \
this polynomial is zero at the sample point. If we cannot resolve all the \
uncertainties using the collected information about the cell, we compute the \
exact algebraic number values of the coordinates. For more details, see [",
  ButtonBox["14",
    ButtonData:>"14",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Decision Problems, FindInstance, and Assumptions ", "Section"],

Cell[TextData[{
  "A ",
  StyleBox["decision problem",
    FontSlant->"Italic"],
  " is a system with all variables existentially quantified, that is, a \
system of the form"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\[Exists] \_\(x\_1\)\[Exists] \_\(x\_2\) ... \) \
\(\[Exists] \_\(x\_n\)\[CapitalPhi](x\_1,  ... , 
          x\_n)\)\)\(,\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1,  ... , x\_n\)]],
  " are all variables in \[CapitalPhi]. Solving a decision problem means \
deciding whether it is equivalent to ",
  StyleBox["True", "MR"],
  " or to ",
  StyleBox["False", "MR"],
  ", that is, deciding whether the quantifier-free system of polynomial \
equations and inequalities ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n)\)]],
  " has solutions."
}], "Text"],

Cell[TextData[{
  "All algorithms used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to solve real polynomial decision problems are capable of producing a \
point satisfying ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPhi](x\_1,  ... , x\_n)\)]],
  " if the system has solutions. Therefore the algorithms discussed in this \
section are used not only in ",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Resolve", "MR"],
  " for decision problems, but also in ",
  StyleBox["FindInstance", "MR"],
  ", whenever a single instance is requested and the system is quantifier \
free or contains only existential quantifiers. The algorithms discussed here \
are also used for inference testing by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions using assumptions such as ",
  StyleBox["Simplify", "MR"],
  ", ",
  StyleBox["Refine", "MR"],
  ", ",
  StyleBox["Integrate", "MR"],
  ", and so forth."
}], "Text"],

Cell[TextData[{
  "Solving this decision problem proves that the set  ",
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, 
              y)\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : 
              x\^4 + y\^4 - 2  x\ y \[LessEqual] \ 1\)}\)]],
  " contains the disk of radius 4/5 centered at the origin."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_{x, y}\((x\^2 + y\^2 \[LessEqual] 16\/25 && 
            x\^4 + y\^4 - 2\ x\ y > 1)\), Reals]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
  "This shows that ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " does not contain the unit disk and provides a counterexample: a point in \
the unit disk that does not belong to ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
      x\^2 + y\^2 \[LessEqual] 1 && x\^4 + y\^4 - 2\ x\ y > 1, \ {x, \ y}, 
      Reals]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({{x \[Rule] 3\/4, y \[Rule] \(-\(1\/2\)\)}}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "The primary method that allows ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to solve arbitrary real polynomial decision problems is the CAD \
algorithm. There are, however, several other special case algorithms that \
provide much better performance in cases in which they are applicable."
}], "Text"],

Cell[TextData[{
  "When all polynomials are linear with rational number or floating point \
number coefficients, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a method based on the Simplex linear programming method. For other \
linear systems, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a variant of the Loos-Weispfenning linear quantifier elimination \
algorithm [",
  ButtonBox["15",
    ButtonData:>"15",
    ButtonStyle->"Hyperlink"],
  "]. When the system contains no equations and only strict inequalities, a \
faster \[OpenCurlyDoubleQuote]generic\[CloseCurlyDoubleQuote] version of CAD \
is used [",
  ButtonBox["12",
    ButtonData:>"12",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["13",
    ButtonData:>"13",
    ButtonStyle->"Hyperlink"],
  "]. For systems containing equational constraints that generate a \
zero-dimensional ideal, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses Gr\[ODoubleDot]bner bases to find a solution. For nonlinear systems \
with floating point number coefficients, an inexact coefficient version of \
CAD [",
  ButtonBox["16",
    ButtonData:>"16",
    ButtonStyle->"Hyperlink"],
  "] is used."
}], "Text"],

Cell[TextData[{
  "There are also some special case methods that can be used as preprocessors \
to other decision methods. When the system contains an equational constraint \
linear with a constant coefficient in one of the variables, the constraint is \
used to eliminate the linear variable. If there is a variable that appears in \
the system only linearly with constant coefficients, the variable is \
eliminated using the Loos-Weispfenning linear quantifier elimination \
algorithm [",
  ButtonBox["15",
    ButtonData:>"15",
    ButtonStyle->"Hyperlink"],
  "]. If there is a variable that appears in the system only quadratically, \
the quadratic case of Weispfenning's quantifier elimination by virtual \
substitution algorithm [",
  ButtonBox["22",
    ButtonData:>"22",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["23",
    ButtonData:>"23",
    ButtonStyle->"Hyperlink"],
  "] could be used to eliminate the variable. For some examples this gives a \
substantial speedup, however quite often it results in a significant \
slowdown. By default, the algorithm is not used as a preprocessor. Setting \
the system option ",
  StyleBox["QVSPreprocessor", "MR"],
  " in the ",
  StyleBox["InequalitySolvingOptions", "MR"],
  " group to ",
  StyleBox["True", "MR"],
  " makes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " use it. "
}], "Text"],

Cell[TextData[{
  "There are a two other special cases of real decision algorithms available \
in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". An algorithm by Aubry, Rouillier, and Safey El Din [",
  ButtonBox["17",
    ButtonData:>"17",
    ButtonStyle->"Hyperlink"],
  "] applies to systems containing only equations. There are examples for \
which the algorithm performs much better than CAD; however, for randomly \
chosen systems of equations, it seems to perform significantly worse; \
therefore, it is not used by default. Setting the system option ",
  StyleBox["ARSDecision", "MR"],
  " in the ",
  StyleBox["InequalitySolvingOptions", "MR"],
  " group to ",
  StyleBox["True", "MR"],
  " causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use the algorithm. Another algorithm by G.X. Zeng and X.N. Zeng [",
  ButtonBox["18",
    ButtonData:>"18",
    ButtonStyle->"Hyperlink"],
  "] applies to systems that consist of a single strict inequality. Again, \
the algorithm is faster than CAD for some examples, but slower in general; \
therefore, it is not used by default. Setting the system option ",
  StyleBox["ZengDecision", "MR"],
  " in the ",
  StyleBox["InequalitySolvingOptions", "MR"],
  " group to ",
  StyleBox["True", "MR"],
  " causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use the algorithm. "
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Arbitrary Real Polynomial Systems", "Section",
  CellTags->"ComplexQuantifierElimination"],

Cell[CellGroupData[{

Cell["Solving Real Polynomial Systems", "Subsection"],

Cell[TextData[{
  "According to Tarski's theorem [",
  ButtonBox["2",
    ButtonData:>"2",
    ButtonStyle->"Hyperlink"],
  "], the solution set of an arbitrary (quantified) real polynomial system is \
a semi-algebraic set. ",
  StyleBox["Reduce", "MR"],
  " gives a description of this set in the solved form (",
  ButtonBox["4",
    ButtonData:>"GeneralRealSolution",
    ButtonStyle->"Hyperlink"],
  "). "
}], "Text"],

Cell[TextData[{
  "This shows for what ",
  Cell[BoxData[
      \(TraditionalForm\`r > 0\)]],
  " the set  ",
  Cell[BoxData[
      \(TraditionalForm\`S = {\((x, 
              y)\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : 
              x\^4 + y\^4 - 2  x\ y \[LessEqual] \ 1\)}\)]],
  " contains the disk of radius ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " centered at the origin."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[ForAll] \_\({x, y}, r > 0 && x\^2 + y\^2 \[LessEqual] \
r\^2\)x\^4 + y\^4 - 2\ x\ y \[LessEqual] 1, r, Reals]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \(r \[LessEqual] Root[\(-2\) + 2\ #1\^2 + #1\^4 &, 2]\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell[TextData[{
  "This gives the projection of ",
  Cell[BoxData[
      \(x\^2 + y\^2 + z\^2 - x\ y\ z \[LessEqual] 1\)]],
  "on the ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " plane along the ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  "-axis."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_z x\^2 + y\^2 + z\^2 - x\ y\ z \[LessEqual] 1, {x, 
        y}]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(\((x < \(-2\) && \((y \[LessEqual] \(-\@\(\(\(-4\) + 4\ \
x\^2\)\/\(\(-4\) + x\^2\)\)\) || 
              y \[GreaterEqual] \@\(\(\(-4\) + 4\ x\^2\)\/\(\(-4\) + \
x\^2\)\))\))\) || \((x \[Equal] \(-1\) && 
          y \[Equal] 0)\) || \((\(-1\) < x < 
            1 && \(-\@\(\(\(-4\) + 4\ x\^2\)\/\(\(-4\) + x\^2\)\)\) \
\[LessEqual] 
            y \[LessEqual] \@\(\(\(-4\) + 4\ x\^2\)\/\(\(-4\) + x\^2\)\))\) || \
\((x \[Equal] 1 && 
          y \[Equal] 0)\) || \((x > 
            2 && \((y \[LessEqual] \(-\@\(\(\(-4\) + 4\ x\^2\)\/\(\(-4\) + \
x\^2\)\)\) || 
              y \[GreaterEqual] \@\(\(\(-4\) + 4\ x\^2\)\/\(\(-4\) + \
x\^2\)\))\))\)\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "This finds the projection of Whitney's umbrella ",
  Cell[BoxData[
      \(x\^2 - y\^2\ z \[Equal] 0\)]],
  " on the ",
  Cell[BoxData[
      \(TraditionalForm\`\((y, z)\)\)]],
  " plane along the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_x x\^2 - y\^2\ z \[Equal] 0, {y, z}, 
      Reals]\)], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \(\((y < 0 && z \[GreaterEqual] 0)\) || 
      y \[Equal] 0 || \((y > 0 && z \[GreaterEqual] 0)\)\)], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell["\<\
Here we find the interior of the previous projection set by \
directly using the definition.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_\(d, d > 0\)\((\[ForAll] \_\({v, w}, \((v - y)\)\^2 \
+ \((w - z)\)\^2 \[LessEqual] d\)\((\[Exists] \_u u\^2 - v\^2\ w \[Equal] 
                  0)\))\), {y, z}, Reals]\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    \(z > 0\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantifier Elimination", "Subsection"],

Cell[TextData[{
  "The objective of ",
  StyleBox["Resolve", "MR"],
  " with no variables specified is to eliminate quantifiers and produce an \
equivalent quantifier-free formula. The formula may or may not be in a solved \
form, depending on the algorithm used."
}], "Text"],

Cell[TextData[{
  "Producing a fully solved quantifier-free formula here is difficult because \
of the complexity of polynomials in ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " appearing in the input. However, since ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " appears in the input polynomials only linearly, the quantifier can be \
quickly eliminated using the Loos-Weispfenning linear quantifier elimination \
algorithm, which depends very little on the complexity of coefficients."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[\[Exists] \_x\((a\ x \[GreaterEqual] 
              b\^3 - 3\ a\ c\^2 - 5\ a\^3\ b\ c + 9 && 
            b\ c\^2\ x - 3\ x \[LessEqual] 
              11\ a\^2\ b - 3\ c\^3 + 4\ a\ b\^2\ c + 9)\)]\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \(\((a | b | c)\) \[Element] 
        Reals && \((\((\(-a\) < 
                0 && \(-27\) - 9\ a - 11\ a\^3\ b - 3\ b\^3 + 
                  15\ a\^3\ b\ c - 4\ a\^2\ b\^2\ c + 9\ a\ c\^2 + 
                  9\ b\ c\^2 + b\^4\ c\^2 + 3\ a\ c\^3 - 
                  5\ a\^3\ b\^2\ c\^3 - 3\ a\ b\ c\^4 \[LessEqual] 
                0)\) || \((a < 0 && 
              27 + 9\ a + 11\ a\^3\ b + 3\ b\^3 - 15\ a\^3\ b\ c + 
                  4\ a\^2\ b\^2\ c - 9\ a\ c\^2 - 9\ b\ c\^2 - b\^4\ c\^2 - 
                  3\ a\ c\^3 + 5\ a\^3\ b\^2\ c\^3 + 
                  3\ a\ b\ c\^4 \[LessEqual] 0)\) || \((3 - b\ c\^2 < 
                0 && \(-27\) - 9\ a - 11\ a\^3\ b - 3\ b\^3 + 
                  15\ a\^3\ b\ c - 4\ a\^2\ b\^2\ c + 9\ a\ c\^2 + 
                  9\ b\ c\^2 + b\^4\ c\^2 + 3\ a\ c\^3 - 
                  5\ a\^3\ b\^2\ c\^3 - 3\ a\ b\ c\^4 \[LessEqual] 
                0)\) || \((\(-3\) + b\ c\^2 < 0 && 
              27 + 9\ a + 11\ a\^3\ b + 3\ b\^3 - 15\ a\^3\ b\ c + 
                  4\ a\^2\ b\^2\ c - 9\ a\ c\^2 - 9\ b\ c\^2 - b\^4\ c\^2 - 
                  3\ a\ c\^3 + 5\ a\^3\ b\^2\ c\^3 + 
                  3\ a\ b\ c\^4 \[LessEqual] 0)\) || \((a \[Equal] 0 && 
              9 + b\^3 - 5\ a\^3\ b\ c - 3\ a\ c\^2 \[LessEqual] 
                0 && \(-9\) - 11\ a\^2\ b - 4\ a\ b\^2\ c + 
                  3\ c\^3 \[LessEqual] 0)\) || \((\(-3\) + b\ c\^2 \[Equal] 
                0 && 9 + b\^3 - 5\ a\^3\ b\ c - 3\ a\ c\^2 \[LessEqual] 
                0 && \(-9\) - 11\ a\^2\ b - 4\ a\ b\^2\ c + 
                  3\ c\^3 \[LessEqual] 0)\))\)\)], "Output",
  CellLabel->"Out[15]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms", "Subsection"],

Cell[TextData[{
  "The primary method used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for solving real polynomial systems and real quantifier elimination is \
the CAD algorithm. There are, however, simpler methods applicable in special \
cases. "
}], "Text"],

Cell["\<\
If the system contains an equational constraint in a variable from \
the innermost quantifier, the constraint is used to simplify the system using \
the identity\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Exists] \_y a\ y \[Equal] 
        b\ \[Wedge]\(\[CapitalPhi](x\_1,  ... , x\_n; 
              y)\)\ \[DoubleLongLeftRightArrow]\ a \[NotEqual] 
        0\[Wedge]\(\[CapitalPhi](x\_1,  ... , x\_n; 
              b/a)\)\[Vee]\(\[Exists] \_y a\  \[Equal] 0\[Wedge]\ b \[Equal] 
              0\[Wedge]\(\(\[CapitalPhi](x\_1,  ... , x\_n; 
                    y)\)\(.\)\)\)\)], "DisplayFormula"],

Cell[TextData[{
  "Note that if ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " is a nonzero constant, this eliminates the variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "If all polynomials in the system are linear in a variable from the \
innermost quantifier, the variable is eliminated using the Loos-Weispfenning \
linear quantifier elimination algorithm [",
  ButtonBox["15",
    ButtonData:>"15",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "If all polynomials in the system are at most quadratic in a variable from \
the innermost quantifier, the variable is eliminated using the quadratic case \
of Weispfenning's quantifier elimination by virtual substitution algorithm \
[",
  ButtonBox["22",
    ButtonData:>"22",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["23",
    ButtonData:>"23",
    ButtonStyle->"Hyperlink"],
  "]. With the default setting of the system option ",
  StyleBox[ButtonBox["QuadraticQE",
    ButtonData:>"QuadraticQE",
    ButtonStyle->"Hyperlink"], "MR"],
  ", the algorithm is used for ",
  StyleBox["Resolve", "MR"],
  " with no variables specified and with at least two parameters present, and \
for ",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Resolve", "MR"],
  " with at least three variables as long as elimination of one variable at \
most doubles the ",
  StyleBox["LeafCount", "MR"],
  " of the system."
}], "Text"],

Cell["\<\
The CAD algorithm is used when the previous three special case \
methods are no longer applicable, but there are still quantifiers left to \
eliminate or a solution is required.\
\>", "Text"],

Cell[TextData[{
  "For systems containing equational constraints that generate a \
zero-dimensional ideal, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses Gr\[ODoubleDot]bner bases to find the solution set. "
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Section"],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions for solving real polynomial systems have a number of options \
that control the way that they operate. This section gives a summary of these \
options."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox["Cubics",
              "MR"], 
            StyleBox["False",
              
              "MR"], \(whether\ the\ Cardano\ formulas\ should\ be\ used\ to\ \
express\ numeric\ solutions\ of\ cubics\)},
          {
            StyleBox["Quartics",
              "MR"], 
            StyleBox["False",
              
              "MR"], \(whether\ the\ Cardano\ formulas\ should\ be\ used\ to\ \
express\ numeric\ solutions\ of\ quartics\)},
          {
            StyleBox["WorkingPrecision",
              "MR"], 
            "\[Infinity]", \(the\ working\ precision\ to\ be\ used\ in\ \
computations\)}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " options affecting the behavior for real polynomial systems."
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Cubics",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Quartics",
    FontFamily->"Helvetica",
    FontWeight->"Bold"]
}], "SubsubsectionIcon"],

Cell[TextData[{
  "By default, ",
  StyleBox["Reduce", "MR"],
  " does not use the Cardano formulas for solving cubics or quartics over the \
reals."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 3\ x + 7 \[Equal] 0, \ x, Reals]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    \(x \[Equal] Root[7 - 3\ #1 + #1\^3 &, 1]\)], "Output",
  CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
  "Setting options ",
  StyleBox["Cubics", "MR"],
  " and ",
  StyleBox["Quartics", "MR"],
  " to ",
  StyleBox["True", "MR"],
  " makes ",
  StyleBox["Reduce", "MR"],
  " use the Cardano formulas to represent numeric solutions of cubics and \
quartics. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 - 3\ x + 7 \[Equal] 0, \ x, \ Reals, 
      Cubics \[Rule] True]\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    \(x \[Equal] \(-\((2\/\(7 - 3\ \@5\))\)\^\(1/3\)\) - \((1\/2\ \((7 - 3\ \
\@5)\))\)\^\(1/3\)\)], "Output",
  CellLabel->"Out[17]="]
}, Open  ]],

Cell[TextData[{
  "Solutions of cubics and quartics involving parameters will still be \
represented using ",
  StyleBox["Root", "MR"],
  " objects."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^3 \[Equal] a, x, Reals, Cubics \[Rule] True]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \(x \[Equal] Root[\(-a\) + #1\^3 &, 1]\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[TextData[{
  "This is because the Cardano formulas do not separate real solutions from \
nonreal ones. For instance, in this case, for ",
  Cell[BoxData[
      \(TraditionalForm\`a = \(-1\)\)]],
  " the third radical solution is real, but for ",
  Cell[BoxData[
      \(TraditionalForm\`a = 1\)]],
  " the first radical solution is real."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = Reduce[x\^3 \[Equal] a, x, Cubics \[Rule] True]\)], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    \(x \[Equal] a\^\(1/3\) || 
      x \[Equal] \(-\((\(-1\))\)\^\(1/3\)\)\ a\^\(1/3\) || 
      x \[Equal] \((\(-1\))\)\^\(2/3\)\ a\^\(1/3\)\)], "Output",
  CellLabel->"Out[19]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol /. {{a \[Rule] \(-1\)}, {a \[Rule] 1}}\)], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    \({x \[Equal] \((\(-1\))\)\^\(1/3\) || 
        x \[Equal] \(-\((\(-1\))\)\^\(2/3\)\) || x \[Equal] \(-1\), 
      x \[Equal] 1 || x \[Equal] \(-\((\(-1\))\)\^\(1/3\)\) || 
        x \[Equal] \((\(-1\))\)\^\(2/3\)}\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["WorkingPrecision", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The setting of ",
  StyleBox["WorkingPrecision", "MR"],
  " affects the ",
  ButtonBox["lifting phase of the CAD algorithm",
    ButtonData:>"CADLift",
    ButtonStyle->"Hyperlink"],
  ". With a finite working precision ",
  StyleBox["prec",
    FontSlant->"Italic"],
  ", sample points in the first variable lifted are represented as \
arbitrary-precision floating point numbers with ",
  StyleBox["prec",
    FontSlant->"Italic"],
  " digits of precision. When we compute sample points for subsequent \
variables, we find roots of polynomials whose coefficients depend on already \
computed sample point coordinates and therefore may be inexact. Hence \
coordinates of sample points will have precision ",
  StyleBox["prec",
    FontSlant->"Italic"],
  " or lower. Determining sign of polynomials at sample points is simply done \
by evaluating ",
  StyleBox["Sign", "MR"],
  " of the floating point number obtained after the substitution. Using a \
finite ",
  StyleBox["WorkingPrecision", "MR"],
  " may allow getting the answer faster; however, the answer may be incorrect \
or the computation may fail due to loss of precision."
}], "Text"],

Cell[TextData[{
  "This problem is too hard for ",
  StyleBox["Reduce", "MR"],
  " working in infinite ",
  StyleBox["WorkingPrecision", "MR"],
  ",",
  StyleBox[" ", "MR"],
  "due to high degrees of algebraic numbers involved. Using 30 digits of \
precision sample points solves it in under two seconds."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_{y, z}\((x\^4 + 2\ y\^4 + 3\ z\^4 \[LessEqual] 1 && 
              x\^3 - 9\ y\^3 + 7\ z\^3 \[GreaterEqual] 2)\), x, Reals, 
        WorkingPrecision \[Rule] 30] // Timing\)], "Input",
  CellLabel->"In[21]:="],

Cell[BoxData[
    \({0.65`\ Second, 
      Root[\(-192899\) - 6912\ #1\^3 + 589065\ #1\^4 + 5184\ #1\^6 - 
              589065\ #1\^8 - 1728\ #1\^9 + 196571\ #1\^12 &, 1] \[LessEqual] 
        x \[LessEqual] 
        Root[\(-192899\) - 6912\ #1\^3 + 589065\ #1\^4 + 5184\ #1\^6 - 
              589065\ #1\^8 - 1728\ #1\^9 + 196571\ #1\^12 &, 2]}\)], "Output",\

  CellLabel->"Out[21]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["ReduceOptions Group of System Options", "Subsection"],

Cell[TextData[{
  "Here are the system options from the ",
  StyleBox["ReduceOptions", "MR"],
  " group that may affect the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for real polynomial systems. The options can be set with"
}], "Text"],

Cell["\<\
Developer`SetSystemOptions[\"ReduceOptions\" -> {\"option name\" -> \
value}].\
\>", "Program"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {Cell[TextData[StyleBox["\"FactorInequalities\"", "MR"]]], 
            StyleBox["False",
              
              "MR"], \(whether\ inequalities\ should\ be\ factored\ at\ the\ \
input\ preprocessing\ stage\)},
          {Cell[TextData[StyleBox["\"ReorderVariables\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            RowBox[{"whether", " ", 
              StyleBox["Reduce",
                "MR"], " ", "and", " ", 
              StyleBox["Resolve",
                "MR"], " ", "are", " ", "allowed", " ", "to", " ", "reorder", 
              " ", "the", " ", "specified", " ", "variables"}]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  "ReduceOptions group options affecting the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for real polynomial systems."
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FactorInequalities",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell["Using transformations", "Text"],

Cell[BoxData[{
    \(TraditionalForm\`f\ g < 0\ \[LongRightArrow]\ f < 0\  \[And] \ 
        g > 0\  \[Or] \ f > 0\  \[And] g < 0\), "\[IndentingNewLine]", 
    \(TraditionalForm\`f\ g \[LessEqual] \ 
          0\ \[LongRightArrow]\ f \[LessEqual] \ 0\  \[And] \ 
        g \[GreaterEqual] \ 0\  \[Or] \ 
      f \[GreaterEqual] \ 0\  \[And] 
        g \[LessEqual] \ 0\)}], "NumberedEquation",
  CellTags->"FactorIneqs"],

Cell["\<\
at the input preprocessing stage may speed up the computations in \
some cases. In general, however, it does not make the problem easier to \
solve, and, in some cases, it may make the problem significantly harder. By \
default, these transformations are not used.\
\>", "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " does not use transformations (",
  ButtonBox["7",
    ButtonData:>"FactorIneqs",
    ButtonStyle->"Hyperlink"],
  ")."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(t1 = \(Timing[
            Reduce[\((x\^3 - 5\ x\ y\^2 - 3\ y\^2 + 7\ z\^2 - 1)\)\ \((x\^2 - 
                      3\ x\ y + 5\ y\^2 + 3\ y\ z - 2)\)\ \((x\^2 - 2\ z + 
                      y - 3)\) \[LessEqual] 0, {x, y, z}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\n", \

    \(\(t2 = \(Timing[
            Reduce[\[Product]\+\(i = 1\)\%10\((x - y\ i)\) \[LessEqual] 
                0, {x, y}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\n", \

    \(\(t3 = \(Timing[
            Reduce[y\^21 - x\ y\^7 + z - 1 < 0 && 
                y\^14 + 3\ x\^2\ y\^7 - 11\ z + 7 > 0 && 
                y\^7 \[GreaterEqual] 0, {x, y, z}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\
\[IndentingNewLine]", 
    \({t1, t2, t3}\)}], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    \({8.64`\ Second, 0.019999999999999497`\ Second, 
      0.029999999999999923`\ Second}\)], "Output",
  CellLabel->"Out[25]="]
}, Open  ]],

Cell[TextData[{
  "Using transformations (",
  ButtonBox["7",
    ButtonData:>"FactorIneqs",
    ButtonStyle->"Hyperlink"],
  ") speeds up the first example; however, it makes the other two examples \
significantly slower. The second example suffers from exponential growth of \
the number of inequalities. By replacing ",
  Cell[BoxData[
      \(TraditionalForm\`y\^7 \[GreaterEqual] 0\)]],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\)\(\[GreaterEqual]\)\(0\)\(\ \)\)\)]],
  "in the third example, we get a degree 21 system in ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " instead of a degree 3 system in ",
  Cell[BoxData[
      \(TraditionalForm\`y\^7\)]],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
\("\<FactorInequalities\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(\(t1 = \(Timing[
            Reduce[\((x\^3 - 5\ x\ y\^2 - 3\ y\^2 + 7\ z\^2 - 1)\)\ \((x\^2 - 
                      3\ x\ y + 5\ y\^2 + 3\ y\ z - 2)\)\ \((x\^2 - 2\ z + 
                      y - 3)\) \[LessEqual] 0, {x, y, z}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\n", \

    \(\(t2 = \(Timing[
            Reduce[\[Product]\+\(i = 1\)\%10\((x - y\ i)\) \[LessEqual] 
                0, {x, y}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\n", \

    \(\(t3 = \(Timing[
            Reduce[y\^21 - x\ y\^7 + z - 1 < 0 && 
                y\^14 + 3\ x\^2\ y\^7 - 11\ z + 7 > 0 && 
                y\^7 \[GreaterEqual] 0, {x, y, z}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\
\[IndentingNewLine]", 
    \({t1, t2, t3}\)}], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    \({6.800000000000001`\ Second, 7.409999999999998`\ Second, 
      0.4400000000000017`\ Second}\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
\("\<FactorInequalities\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[31]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ReorderVariables", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "By default, ",
  StyleBox["Reduce", "MR"],
  " is not allowed to reorder the specified variables. Variables appearing \
earlier in the variable list may be used to express solutions for variables \
appearing later in the variable list, but not vice versa."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x > y\^3 + 7\ y - 1, {x, y}, Reals]\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \(y < Root[\(-1\) - x + 7\ #1 + #1\^3 &, 1]\)], "Output",
  CellLabel->"Out[32]="]
}, Open  ]],

Cell[TextData[{
  "Setting the system option ",
  StyleBox["ReorderVariables\[Rule]True", "MR"],
  " allows ",
  StyleBox["Reduce", "MR"],
  " to pick a variable order that makes the system easier to solve."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
\("\<ReorderVariables\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[x > y\^3 + 7\ y - 1, {x, y}, Reals]\)}], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \(x > \(-1\) + 7\ y + y\^3\)], "Output",
  CellLabel->"Out[34]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<ReduceOptions\>" \[Rule] \
\("\<ReorderVariables\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[35]:="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InequalitySolvingOptions Group of System Options", "Subsection"],

Cell[TextData[{
  "Here are the system options from the ",
  StyleBox["InequalitySolvingOptions", "MR"],
  " group that may affect the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for real polynomial systems. The options can be set with"
}], "Text"],

Cell["\<\
Developer`SetSystemOptions[\"InequalitySolvingOptions\"
      -> {\"option name\" -> value}].\
\>", "Program"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {Cell[TextData[StyleBox["\"ARSDecision\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            RowBox[{
            "whether", " ", "to", " ", "use", " ", "the", " ", "decision", 
              " ", "algorithm", " ", "given", " ", 
              RowBox[{"in", " ", "[", 
                ButtonBox["17",
                  ButtonData:>"17",
                  ButtonStyle->"Hyperlink",
                  ButtonFrame->"None"], "]"}]}]},
          {Cell[TextData[StyleBox["\"BrownProjection\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            RowBox[{
            "whether", " ", "the", " ", "CAD", " ", "algorithm", " ", 
              "should", " ", "use", " ", "the", " ", "improved", " ", 
              "projection", " ", "operator", " ", "given", " ", 
              RowBox[{"in", " ", "[", 
                ButtonBox["8",
                  ButtonData:>"8",
                  ButtonStyle->"Hyperlink",
                  ButtonFrame->"None"], "]"}]}]},
          {Cell[TextData[StyleBox["\"CAD\"", "MR"]]], 
            StyleBox["True",
              "MR"], \(whether\ to\ use\ the\ CAD\ algorithm\)},
          {Cell[TextData[StyleBox["\"CADDefaultPrecision\"", "MR"]]], 
            StyleBox["30.103",
              
              "MR"], \(the\ precision\ to\ which\ nonrational\ roots\ are\ \
computed\ in\ the\ lifting\ phase\ of\ the\ CAD\ algorithm; \ 
            if\ computation\ with\ approximate\ roots\ cannot\ be\ validated, \
\ the\ algorithm\ reverts\ to\ exact\ algebraic\ number\ computation\)},
          {Cell[TextData[StyleBox["\"CADSortVariables\"", "MR"]]], 
            StyleBox["True",
              
              "MR"], \(whether\ the\ CAD\ algorithm\ should\ use\ variable\ \
reordering\ heuristics\n
            
            for\ quantifier\ variables\ within\ a\ single\ quantifier\ or\ in\
\ decision\ problems\)},
          {Cell[TextData[StyleBox[
            "\"CADZeroTest\"", 
              "MR"]]], \({0, \[Infinity]}\), \(determines\ the\ zero\ testing\
\ method\ used\ by\ the\ CAD\ algorithm\ for\ expressions\ obtained\ by\ \
evaluating\ polynomials\ at\ points\ with\ algebraic\ number\ coordinates\)},
          {Cell[TextData[StyleBox[
            "\"ContinuedFractionRootIsolation\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            
            RowBox[{\(whether\ the\ CAD\ algorithm\ should\ use\ a\ real\ \
root\ isolation\ method\ based\ on\ continued\ fractions\ rather\ than\ on\ \
interval\), "\n", 
              RowBox[{"bisection", " ", "[", 
                ButtonBox["19",
                  ButtonData:>"19",
                  ButtonStyle->"Hyperlink",
                  ButtonFrame->"None"], "]"}]}]},
          {Cell[TextData[StyleBox["\"FGLMBasisConversion\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            RowBox[{
              RowBox[{
                RowBox[{
                "whether", " ", "the", " ", "CAD", " ", "algorithm", " ", 
                  "should", " ", "use", " ", "a", " ", "Gr\[ODoubleDot]bner", 
                  " ", "basis", " ", "conversion", " ", "algorithm", " ", 
                  "based", " ", 
                  RowBox[{"on", "  ", "[", 
                    ButtonBox["20",
                      ButtonData:>"20",
                      ButtonStyle->"Hyperlink",
                      ButtonFrame->"None"], "]"}], " ", "to", " ", "find", 
                  " ", "univariate", " ", "polynomials", " ", "in", " ", 
                  "zero"}], "-", "dimensional"}], "\n", 
              RowBox[{\(Gr\[ODoubleDot]bner\ bases; \ otherwise\), ",", " ", 
                RowBox[{
                  StyleBox["GroebnerWalk",
                    "MR"], " ", "is", " ", "used"}]}]}]},
          {Cell[TextData[StyleBox["\"FGLMElimination\"", "MR"]]], 
            StyleBox["Automatic",
              "MR"], 
            
            RowBox[{\(whether\ the\ decision\ and\ quantifier\ elimination\ \
algorithms\ for\ systems\ with\ equational\ constraints\ forming\ a\ zero\), 
              "-", 
              RowBox[{
              "dimensional", " ", "ideal", " ", "should", " ", "use", " ", 
                "an", " ", "algorithm", " ", "based", " ", 
                RowBox[{"on", "  ", "[", 
                  ButtonBox["20",
                    ButtonData:>"20",
                    ButtonStyle->"Hyperlink",
                    ButtonFrame->"None"], "]"}], " ", "to", " ", "look", " ", 
                "for", " ", "linear", " ", "equation", " ", "constraints", 
                " ", \((with\ constant\ leading\ coefficients)\), " ", "in", 
                " ", "one", " ", "of", " ", "the", " ", "variables", " ", 
                "to", " ", "be", " ", "used", " ", "for", " ", 
                "elimination"}]}]},
          {Cell[TextData[StyleBox["\"GenericCAD\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            RowBox[{
              RowBox[{
              "whether", " ", "to", " ", "use", " ", "the", " ", "variant", 
                " ", "of", " ", "the", " ", "CAD", " ", "algorithm", " ", 
                "described", " ", 
                RowBox[{"in", " ", "[", 
                  ButtonBox["13",
                    ButtonData:>"13",
                    ButtonStyle->"Hyperlink",
                    ButtonFrame->"None"], "]"}], " ", "for"}], 
              "\n", \(decision\ and\ optimization\ problems\)}]},
          {Cell[TextData[StyleBox["\"GroebnerCAD\"", "MR"]]], 
            StyleBox["True",
              
              "MR"], \(whether\ the\ CAD\ algorithm\ for\ systems\ with\ \
equational\ constraints\ forming\ a\ zero - 
              dimensional\ ideal\ should\ use\ Gr\[ODoubleDot]bner\ bases\ as\
\ projection\)},
          {Cell[TextData[StyleBox[
            "\"LinearDecisionMethodCrossovers\"", "MR"]]], 
            StyleBox[\({0, 30, 20}\),
              
              "MR"], \(determines\ methods\ used\ to\ find\ solutions\ of\ \
systems\ of\ linear\ equations\ and\ inequalities\ with\n
            rational\ number\ coefficients\)},
          {Cell[TextData[StyleBox["\"LinearEquations\"", "MR"]]], 
            StyleBox["True",
              
              "MR"], \(whether\ to\ use\ linear\ equation\ constraints\ \
\((with\ constant\ leading\ coefficients)\)\ to\ eliminate\ variables\ in\ \
decision\ problems\)},
          {Cell[TextData[StyleBox["\"LinearQE\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            
            RowBox[{\(whether\ to\ use\ the\ Loos - Weispfenning\), " ", "\n",
               
              RowBox[{"linear", " ", "quantifier", " ", "elimination", " ", 
                RowBox[{"algorithm", " ", "[", 
                  ButtonBox["15",
                    ButtonData:>"15",
                    ButtonStyle->"Hyperlink",
                    ButtonFrame->"None"], "]"}], "  ", "for", " ", 
                "quantifier", " ", "elimination", " ", "problems"}]}]},
          {Cell[TextData[StyleBox["\"LWDecision\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            
            RowBox[{\(whether\ to\ use\ the\ Loos - Weispfenning\), " ", "\n",
               
              RowBox[{"linear", " ", "quantifier", " ", "elimination", " ", 
                RowBox[{"algorithm", " ", "[", 
                  ButtonBox["15",
                    ButtonData:>"15",
                    ButtonStyle->"Hyperlink",
                    ButtonFrame->"None"], "]"}], " ", "for", " ", "decision", 
                " ", "problems", " ", "with", " ", "linear", " ", 
                "inequality", " ", "systems"}]}]},
          {Cell[TextData[StyleBox["\"LWPreprocessor\"", "MR"]]], 
            StyleBox["Automatic",
              "MR"], 
            RowBox[{
              RowBox[{\(whether\ to\ use\ the\ Loos\), "-", 
                RowBox[{
                "Weispfenning", " ", "linear", " ", "quantifier", " ", 
                  "elimination", " ", 
                  RowBox[{"algorithm", " ", "[", 
                    ButtonBox["15",
                      ButtonData:>"15",
                      ButtonStyle->"Hyperlink",
                      ButtonFrame->"None"], "]"}], " ", "as", " ", "a", " ", 
                  "preprocessor"}]}], 
              "\n", \(for\ the\ decision\ problems\)}]},
          {Cell[TextData[StyleBox[
            "\"MultipleEquationalConstraints\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            RowBox[{
              RowBox[{
                RowBox[{
                "whether", " ", "the", " ", "CAD", " ", "algorithm", " ", 
                  "should", " ", "use", " ", "the", " ", "unproven", " ", 
                  "projection", " ", "operator", " ", "using", " ", 
                  "multiple", " ", "equational", " ", "constraints", " ", 
                  "suggested", " ", 
                  RowBox[{"in", " ", "[", 
                    ButtonBox["4",
                      ButtonData:>"4",
                      ButtonStyle->"Hyperlink",
                      ButtonFrame->"None"], "]"}]}], ";", " ", 
                RowBox[{"if", " ", 
                  StyleBox["False",
                    "MR"]}]}], ",", "  ", 
              RowBox[{
              "the", " ", "operator", " ", "proven", " ", "correct", " ", 
                RowBox[{"in", " ", "[", 
                  ButtonBox["11",
                    ButtonData:>"11",
                    ButtonStyle->"Hyperlink",
                    ButtonFrame->"None"], "]"}], " ", "is", " ", "used"}]}]},
          {Cell[TextData[StyleBox["\"ProjectAlgebraic\"", "MR"]]], 
            StyleBox["Automatic",
              
              "MR"], \(whether\ the\ CAD\ algorithm\ should\ compute\ \
projections\n
            
            with\ respect\ to\ variables\ replacing\ algebraic\ number\ \
coefficients\ or\ use\ their\ minimal\ polynomials\ instead\)},
          {Cell[TextData[StyleBox["\"QuadraticQE\"", "MR"]]], 
            StyleBox["Automatic",
              
              "MR"], \(whether\ to\ use\ the\ quadratic\ case\ of\ \
Weispfenning' 
              s\ quantifier\ elimination\ by\ virtual\ substitution\ \
algorithm\ in\ quantifier\ elimination\)},
          {Cell[TextData[StyleBox["\"QVSPreprocessor\"", "MR"]]], 
            StyleBox["False",
              
              "MR"], \(whether\ to\ use\ the\ quadratic\ case\ of\ \
Weispfenning' 
              s\ quantifier\ elimination\ by\ virtual\ substitution\ \
algorithm\ as\ a\ preprocessor\ for\ the\ decision\ problems\)},
          {Cell[TextData[StyleBox["\"ReducePowers\"", "MR"]]], 
            StyleBox["True",
              "MR"], 
            RowBox[{
              RowBox[{"whether", " ", "to", " ", "replace", " ", 
                StyleBox[\(x\^d\),
                  FontSlant->"Italic"], " ", "with", " ", 
                StyleBox["x",
                  FontSlant->"Italic"], " ", "in", " ", "the", " ", "input", 
                " ", "to", " ", "the", " ", "CAD"}], ",", 
              RowBox[{"where", " ", 
                StyleBox["d",
                  FontSlant->"Italic"], " ", "is", " ", "the", " ", 
                StyleBox["GCD",
                  "MR"], " ", "of", " ", "all", " ", "exponents", " ", "of", 
                " ", 
                StyleBox["x",
                  FontSlant->"Italic"], " ", "in", " ", "the", " ", 
                "system"}]}]},
          {Cell[TextData[StyleBox["\"RootReduced\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            
            RowBox[{\(whether\ the\ coordinates\ of\ solutions\ of\ systems\ \
with\ equational\ constraints\ forming\ a\ zero\), "-", 
              RowBox[{
              "dimensional", " ", "ideal", " ", "should", " ", "be", " ", 
                "reduced", " ", "to", " ", "single", " ", 
                StyleBox["Root",
                  "MR"], " ", "objects"}]}]},
          {Cell[TextData[StyleBox["\"Simplex\"", "MR"]]], 
            StyleBox["True",
              "MR"], \(whether\ to\ use\ the\ Simplex\ algorithm\ in\ the\n
            decision\ algorithm\ for\ linear\ inequality\ systems\)},
          {Cell[TextData[StyleBox["\"ThreadOr\"", "MR"]]], 
            StyleBox["True",
              
              "MR"], \(whether\ to\ solve\ each\ case\ of\ disjunction\ \
separately\ in\ decision\n
            problems, \ optimization, \ 
            and\ in\ quantifier\ elimination\ of\ existential\n
            
            quantifiers\ when\ the\ quantifier\ free\ system\ does\ not\ need\
\ to\ be\ solved\)},
          {Cell[TextData[StyleBox["\"ZengDecision\"", "MR"]]], 
            StyleBox["False",
              "MR"], 
            RowBox[{
            "whether", " ", "to", " ", "use", " ", "the", " ", "decision", 
              " ", "algorithm", " ", "given", " ", 
              RowBox[{"in", " ", "[", 
                ButtonBox["18",
                  ButtonData:>"18",
                  ButtonStyle->"Hyperlink",
                  ButtonFrame->"None"], "]"}]}]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.3, 0.1, 0.6},
  RowLines->{0.5, False}}],

Cell[TextData[{
  "InequalitySolvingOptions group options affecting the behavior of ",
  StyleBox["Reduce", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  ", and ",
  StyleBox["FindInstance", "MR"],
  " for real polynomial systems."
}], "Caption"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ARSDecision", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The option ",
  StyleBox["ARSDecision", "MR"],
  " specifies whether ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should use the algorithm by Aubry, Rouillier, and Safey El Din [",
  ButtonBox["17",
    ButtonData:>"17",
    ButtonStyle->"Hyperlink"],
  "]. The algorithm applies to decision problems containing only equations. \
There are examples for which the algorithm performs much better than the CAD \
algorithm; however, for randomly chosen systems of equations it seems to \
perform significantly worse. Therefore it is not used by default. Here is a \
decision problem (referred to as butcher8 in the literature), which is not \
done by CAD in 1000 seconds, but which can be done quite fast by the \
algorithm given in [",
  ButtonBox["17",
    ButtonData:>"17",
    ButtonStyle->"Hyperlink"],
  "]."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \
\("\<ARSDecision\>" \[Rule] True\)]; 
    FindInstance[\(-a\) - b + b\_1 + b\_2 + b\_3 \[Equal] 
            0 && \(-\(1\/2\)\) - b\/2 + a\ b - b\^2 + b\_2\ c\_2 + 
              b\_3\ c\_3 \[Equal] 
            0 && \(4\ b\)\/3 + b\^2 + b\^3 - a\ \((1\/3 + b\^2)\) + 
              b\_2\ c\_2\%2 + b\_3\ c\_3\%2 \[Equal] 
            0 && \(2\ b\)\/3 + b\^2 + b\^3 - a\ \((1\/6 + b\/2 + b\^2)\) + 
              b\_3\ c\_2\ a\_\(3, 2\) \[Equal] 
            0 && \(-\(1\/4\)\) - b\/4 - \(5\ b\^2\)\/2 - \(3\ b\^3\)\/2 - 
              b\^4 + a\ \((b + b\^3)\) + b\_2\ c\_2\%3 + 
              b\_3\ c\_3\%3 \[Equal] 
            0 && \(-\(1\/8\)\) - \(3\ b\)\/8 - \(7\ b\^2\)\/4 - \(3\ \
b\^3\)\/2 - b\^4 + a\ \((b\/2 + b\^2\/2 + b\^3)\) + 
              b\_3\ c\_2\ c\_3\ a\_\(3, 2\) \[Equal] 
            0 && \(-\(1\/12\)\) - b\/12 - \(7\ b\^2\)\/6 - \(3\ b\^3\)\/2 - 
              b\^4 + a\ \((\(2\ b\)\/3 + b\^2 + b\^3)\) + 
              b\_3\ c\_2\%2\ a\_\(3, 2\) \[Equal] 0 && 
          1\/24 + \(7\ b\)\/24 + \(13\ b\^2\)\/12 + \(3\ b\^3\)\/2 + b\^4 - 
              a\ \((b\/3 + b\^2 + b\^3)\) \[Equal] 0, {a, b, a\_\(3, 2\), 
          b\_1, b\_2, b\_3, c\_2, c\_3}, Reals] // Timing\)], "Input",
  CellLabel->"In[36]:="],

Cell[BoxData[
    \({0.5800000000000004`\ Second, {{a \[Rule] 
            Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1], 
          b \[Rule] \(-1\) + 
              Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1], 
          a\_\(3, 2\) \[Rule] 
            1\/356\ \((\(-93\) + 
                  630\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1] - 
                  684\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1]\^2)\
\), b\_1 \[Rule] \(1\/2916\) \((\(-3959\) + 
                  3954\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1] + 
                  2028\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, \
1]\^2)\), 
          b\_2 \[Rule] \(1\/2916\) \((\(-1381\) + 
                  4542\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1] - 
                  3144\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, \
1]\^2)\), 
          b\_3 \[Rule] 
            1\/243\ \((202 - 
                  222\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1] + 
                  93\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, \
1]\^2)\), 
          c\_2 \[Rule] 
            1\/3\ \((\(-4\) + 
                  17\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 1] - 
                  12\ Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, \
1]\^2)\), 
          c\_3 \[Rule] 
            2 - Root[\(-8\) + 25\ #1 - 30\ #1\^2 + 12\ #1\^3 &, 
                1]}}}\)], "Output",
  CellLabel->"Out[36]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ARSDecision\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[37]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["BrownProjection", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "By default, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " implementation of the CAD algorithm uses Brown\[CloseCurlyQuote]s \
improved projection operator [",
  ButtonBox["8",
    ButtonData:>"8",
    ButtonStyle->"Hyperlink"],
  "]. The improvement usually speeds up computations substantially. There are \
some cases where using Brown\[CloseCurlyQuote]s projection operator results \
in a slight slowdown. The option ",
  StyleBox["BrownProjection", "MR"],
  " specifies whether Brown\[CloseCurlyQuote]s improvement should be used. In \
the first example [",
  ButtonBox["21",
    ButtonData:>"21",
    ButtonStyle->"Hyperlink"],
  "], using Brown\[CloseCurlyQuote]s improved projection operator results in \
a speedup by a factor of 3; in the second, it results in a 20% slowdown."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(t1 = \(Timing[
            Reduce[\[Exists] \_\({q1, q2}, q1 > 1 && q2 > 0\)\((\[ForAll] \
\_\(w, w \[Element] Reals\)\((\((4 - 
                                  q1\^2)\)\ w\^4 + \((4\ \((\((1 + q1)\)\^2 - 
                                        2\ q2)\) - \((q2\^2 + 
                                      q1\^2)\))\)\ w\^2 + 
                            3\ q2\^2 \[GreaterEqual] 
                          0 && \((4 - 
                                  q1\^2)\)\ w\^4 + \((4\ \((\((\(-1\) + q1)\)\
\^2 - 2\ q2)\) - \((q2\^2 + q1\^2)\))\)\ w\^2 + 3\ q2\^2 \[GreaterEqual] 
                          0)\))\)]]\)\[LeftDoubleBracket]1\
\[RightDoubleBracket];\)\), "\n", 
    \(\(f = x\^3 - 5\ x\ y - 3\ y\^2 + 7;\)\), "\n", 
    \(\(g = x\^4 - 4\ x\^2\ y - y\^3 - 1;\)\), "\n", 
    \(\(t2 = \(Timing[
            Reduce[f\ z\^2 < f + g, {x, y, z}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\n", \

    \({t1, t2}\)}], "Input",
  CellLabel->"In[38]:="],

Cell[BoxData[
    \({0.3399999999999986`\ Second, 0.1999999999999987`\ Second}\)], "Output",\

  CellLabel->"Out[42]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<BrownProjection\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[43]:="],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(t1 = \(Timing[
            Reduce[\[Exists] \_\({q1, q2}, q1 > 1 && q2 > 0\)\((\[ForAll] \
\_\(w, w \[Element] Reals\)\((\((4 - 
                                  q1\^2)\)\ w\^4 + \((4\ \((\((1 + q1)\)\^2 - 
                                        2\ q2)\) - \((q2\^2 + 
                                      q1\^2)\))\)\ w\^2 + 
                            3\ q2\^2 \[GreaterEqual] 
                          0 && \((4 - 
                                  q1\^2)\)\ w\^4 + \((4\ \((\((\(-1\) + q1)\)\
\^2 - 2\ q2)\) - \((q2\^2 + q1\^2)\))\)\ w\^2 + 3\ q2\^2 \[GreaterEqual] 
                          0)\))\)]]\)\[LeftDoubleBracket]1\
\[RightDoubleBracket];\)\), "\n", 
    \(\(t2 = \(Timing[
            Reduce[f\ z\^2 < f + g, {x, y, z}, 
              Reals]]\)\[LeftDoubleBracket]1\[RightDoubleBracket];\)\), "\n", \

    \({t1, t2}\)}], "Input",
  CellLabel->"In[44]:="],

Cell[BoxData[
    \({0.9999999999999994`\ Second, 0.14999999999999944`\ Second}\)], "Output",\

  CellLabel->"Out[46]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<BrownProjection\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[47]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CAD", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The option ",
  StyleBox["CAD", "MR"],
  " specifies whether ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is allowed to use the CAD algorithm. With ",
  StyleBox["CAD", "MR"],
  " set to ",
  StyleBox["False", "MR"],
  ", computations that require CAD will fail immediately instead of \
attempting the high complexity CAD computation. With CAD enabled, this \
computation is not done in 1000 seconds. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CAD\>" \[Rule] False\)];\)\), "\n", 
    \(Reduce[
        x\^12 + 2\ x\^7\ y\^5\ z\^3 - 21\ z\^4\ t\^2\ y\^7 + 19 \[LessEqual] 
            0 && t\^7 - 24\ x\^5\ y\^4\ z - 32\ z\^11 \[Equal] 0, {x, y, z, 
          t}, Reals] // Timing\)}], "Input",
  CellLabel->"In[48]:="],

Cell[BoxData[
    RowBox[{\(Reduce::"nsmet"\), \(\(:\)\(\ \)\), "\<\"This system cannot be \
solved with the methods available to Reduce. \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Reduce::nsmet\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[48]:="],

Cell[BoxData[
    \({0.10000000000000085`\ Second, 
      Reduce[19 + x\^12 + 2\ x\^7\ y\^5\ z\^3 - 
              21\ t\^2\ y\^7\ z\^4 \[LessEqual] 0 && 
          t\^7 - 24\ x\^5\ y\^4\ z - 32\ z\^11 \[Equal] 0, {x, y, z, t}, 
        Reals]}\)], "Output",
  CellLabel->"Out[49]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CAD\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[50]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CADDefaultPrecision", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "By default, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses validated numeric computations in the ",
  ButtonBox["lifting phase of the CAD algorithm",
    ButtonData:>"CADLift",
    ButtonStyle->"Hyperlink"],
  ", reverting to exact algebraic number computations only if the numeric \
computations cannot be validated [",
  ButtonBox["14",
    ButtonData:>"14",
    ButtonStyle->"Hyperlink"],
  "]. The option ",
  StyleBox["CADDefaultPrecision", "MR"],
  " specifies the initial precision with which the sample point coordinates \
are computed. Choosing the value of ",
  StyleBox["CADDefaultPrecision", "MR"],
  " is a tradeoff between speed of numeric computations and the number of \
points where the algorithm reverts to exact computations due to precision \
loss. With the default value of 100 bits, the cases where the algorithm needs \
to revert to exact computations due to precision loss seem quite rare. \
Setting ",
  StyleBox["CADDefaultPrecision", "MR"],
  " to ",
  StyleBox["Infinity", "MR"],
  " causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use exact algebraic number computations in the lifting phase of CAD. \
Here is an example that runs fastest with the lowest ",
  StyleBox["CADDefaultPrecision", "MR"],
  " setting. (Specifying values lower than 16.2556 (54 bits) results in ",
  StyleBox["CADDefaultPrecision", "MR"],
  " being set to 16.2556.) With ",
  StyleBox["CADDefaultPrecision", "MR"],
  "\[Rule]",
  StyleBox["Infinity", "MR"],
  ", the example did not finish in 1000 seconds."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_{x, y}\((931 + 576\ y\^3 + 626\ x\^2\ y - 
                  564\ y\ z - 750\ z\^2 < 
                0 && \(-535\) + 961\ y + 578\ z \[LessEqual] 
                0 && \(-410\) + 528\ y\^2 - 905\ x \[LessEqual] 0 && 
              z\^2 - 71\ x\ y + 4\ y\^2 - 81 \[LessEqual] 0)\), z, Reals] // 
      Timing\)], "Input",
  CellLabel->"In[51]:="],

Cell[BoxData[
    \({0.49999999999999944`\ Second, 
      Root[\(-39135557564264692223468097\) + 70369504018854614821499160\ #1 - 
              7499740633203604239774740\ #1\^2 - 
              91567784348961473370737040\ #1\^3 + 
              10948550214483020279449920\ #1\^4 - 
              1313704439523340062769800\ #1\^5 - 
              47035179704857006865939040\ #1\^6 - 
              18217590707582813495520\ #1\^7 + 23290773235831759680\ #1\^8 + 
              9309551043209472\ #1\^10 &, 1] < z \[LessEqual] 
        Root[\(-55420506053355\) + 915537370820\ #1 - 18135837359975\ #1\^2 + 
              7238953493376\ #1\^3 &, 1]}\)], "Output",
  CellLabel->"Out[51]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CADDefaultPrecision\>" \[Rule] 16\)];\)\), "\n", 
    \(Reduce[\[Exists] \_{x, y}\((931 + 576\ y\^3 + 626\ x\^2\ y - 
                  564\ y\ z - 750\ z\^2 < 
                0 && \(-535\) + 961\ y + 578\ z \[LessEqual] 
                0 && \(-410\) + 528\ y\^2 - 905\ x \[LessEqual] 0 && 
              z\^2 - 71\ x\ y + 4\ y\^2 - 81 \[LessEqual] 0)\), z, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[52]:="],

Cell[BoxData[
    \({0.4199999999999999`\ Second, 
      Root[\(-39135557564264692223468097\) + 70369504018854614821499160\ #1 - 
              7499740633203604239774740\ #1\^2 - 
              91567784348961473370737040\ #1\^3 + 
              10948550214483020279449920\ #1\^4 - 
              1313704439523340062769800\ #1\^5 - 
              47035179704857006865939040\ #1\^6 - 
              18217590707582813495520\ #1\^7 + 23290773235831759680\ #1\^8 + 
              9309551043209472\ #1\^10 &, 1] < z \[LessEqual] 
        Root[\(-55420506053355\) + 915537370820\ #1 - 18135837359975\ #1\^2 + 
              7238953493376\ #1\^3 &, 1]}\)], "Output",
  CellLabel->"Out[53]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CADDefaultPrecision\>" \[Rule] 30.103\)];\)\)], "Input",
  CellLabel->"In[54]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CADSortVariables", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The performance of the CAD algorithm often depends quite strongly on the \
order of variables used. Some aspects of the variable ordering are fixed by \
the problem we are solving: quantifier variables need to be projected before \
free variables, and variables from innermost quantifiers need to be projected \
first. Variables specified in ",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Resolve", "MR"],
  " cannot be reordered unless ",
  StyleBox["ReorderVariables", "MR"],
  " is set to ",
  StyleBox["True", "MR"],
  ". This, however, still leaves some freedom in ordering of variables: \
variables from the same quantifier can be reordered, and so can be variables \
given to ",
  StyleBox["FindInstance", "MR"],
  ". By default, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a variable ordering heuristic to determine the order of these \
variables. In most cases the heuristic improves the performance of CAD; in \
some examples, however, the heuristic does not pick the best ordering. \
Setting ",
  StyleBox["CADSortVariables", "MR"],
  " to ",
  StyleBox["False", "MR"],
  " disables the heuristic and the order of variables used is as given in the \
quantifier variable list or in the variable list argument to ",
  StyleBox["FindInstance", "MR"],
  ". Here is an example [",
  ButtonBox["21",
    ButtonData:>"21",
    ButtonStyle->"Hyperlink"],
  "] that without reordering of quantified variables does not finish in 1000 \
seconds."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      Reduce[\[ForAll] \_\({p\_1, p\_2, w\_1, w\_2}, 16 \[LessEqual] 20\ p\_1 \
\[LessEqual] 25 && 16 \[LessEqual] 20\ p\_2 \[LessEqual] 25 && 0 \[LessEqual] \
w\_1 \[LessEqual] 2\)\((p\_2\ \((1 + p\_1\ q\_1)\) < 
                0 && \(-24\)\ w\_1\%2 + 
                  p\_2\%2\ \((\((1 + p\_1\ q\_1)\)\^2 - 25)\) > 
                0 && \((400 - q\_1\%2)\)\ w\_2\%2 + 
                  p\_2\%2\ \((400\ \((1 + p\_1\ q\_1)\)\^2 - q\_1\%2)\) > 
                0)\), q\_1, Reals]]\)], "Input",
  CellLabel->"In[55]:="],

Cell[BoxData[
    \({0.37000000000000016`\ Second, \(-20\) \[LessEqual] q\_1 < 
        5\/4\ \((\(-1\) - 5\ \@7)\)}\)], "Output",
  CellLabel->"Out[55]="]
}, Open  ]],

Cell["This shows the optimal variable ordering for the example.", \
"MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CADSortVariables\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[56]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[
      Reduce[\[ForAll] \_\({w\_1, w\_2, p\_2, p\_1}, 16 \[LessEqual] 20\ p\_1 \
\[LessEqual] 25 && 16 \[LessEqual] 20\ p\_2 \[LessEqual] 25 && 0 \[LessEqual] \
w\_1 \[LessEqual] 2\)\((p\_2\ \((1 + p\_1\ q\_1)\) < 
                0 && \(-24\)\ w\_1\%2 + 
                  p\_2\%2\ \((\((1 + p\_1\ q\_1)\)\^2 - 25)\) > 
                0 && \((400 - q\_1\%2)\)\ w\_2\%2 + 
                  p\_2\%2\ \((400\ \((1 + p\_1\ q\_1)\)\^2 - q\_1\%2)\) > 
                0)\), q\_1, Reals]]\)], "Input",
  CellLabel->"In[57]:="],

Cell[BoxData[
    \({0.34999999999999915`\ Second, \(-20\) \[LessEqual] q\_1 < 
        5\/4\ \((\(-1\) - 5\ \@7)\)}\)], "Output",
  CellLabel->"Out[57]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CADSortVariables\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[58]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CADZeroTest", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "One of the most time-consuming operations in the ",
  ButtonBox["lifting phase of the CAD algorithm",
    ButtonData:>"CADLift",
    ButtonStyle->"Hyperlink"],
  " is determining the sign of a polynomial evaluated at a sample point with \
algebraic number coordinates. We try to avoid the problem by using sample \
points with arbitrary-precision floating point number coordinates and keeping \
track of the \[OpenCurlyDoubleQuote]genealogy\[CloseCurlyDoubleQuote] of \
projection polynomials and sample points in order to validate the results. \
However, if some of the results cannot be validated, we have to revert to \
computations with exact algebraic number coordinates. To determine the sign \
of a polynomial evaluated at a sample point with algebraic number \
coordinates, we first evaluate the polynomial at numeric approximations of \
the algebraic numbers. If the result is nonzero (that is zero is not within \
the error bounds of the resulting bignum), we know the sign. Otherwise, we \
need to test whether a polynomial expression in algebraic numbers is zero. \
The value of the ",
  StyleBox["CADZeroTest", "MR"],
  " option specifies what zero testing method should be used at this moment. \
The value should be a pair {",
  StyleBox["t",
    FontSlant->"Italic"],
  ", ",
  StyleBox["acc",
    FontSlant->"Italic"],
  "}. With the default value ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(t \[Equal] 0\)\(,\)\)\)]],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " computes an accuracy ",
  StyleBox["eacc",
    FontSlant->"Italic"],
  " such that if the expression is zero up to this accuracy, it must be zero. \
If ",
  StyleBox["eacc",
    FontSlant->"Italic"],
  "\[LessEqual]",
  StyleBox["acc",
    FontSlant->"Italic"],
  ", the value of the expression is computed up to accuracy ",
  StyleBox["eacc",
    FontSlant->"Italic"],
  " and its sign is checked. Otherwise, the expression is represented as a \
single ",
  StyleBox["Root ", "MR"],
  "object using ",
  StyleBox["RootReduce", "MR"],
  " and the sign of the ",
  StyleBox["Root", "MR"],
  " object is found. With the default value ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["acc",
              FontSlant->"Italic"], "\[Equal]", "\[Infinity]"}], ","}], 
        TraditionalForm]]],
  "  we revert to ",
  StyleBox["RootReduce", "MR"],
  " if ",
  StyleBox["eacc>",
    FontSlant->"Italic"],
  StyleBox["$MaxPrecision", "MR"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Equal] 1\)]],
  ", ",
  StyleBox["RootReduce", "MR"],
  " is always used. If ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Equal] 2\)]],
  ", expressions that are zero up to accuracy ",
  StyleBox["acc",
    FontSlant->"Italic"],
  " are considered zero. This is the fastest method, but, unlike the other \
two, it may give incorrect results because expressions that are nonzero but \
close to zero may be treated as zero."
}], "Text"],

Cell[TextData[{
  "This example runs faster with the CAD algorithm using the 30 digits of \
accuracy numeric zero test. The result in this example is correct; however, \
this setting of ",
  StyleBox["CADZeroTest", "MR"],
  " may lead to incorrect results. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(t1 = \(Timing[
            Reduce[\[Exists] \_z\((z\^3 - a\^2\ z + b \[Equal] 0 && 
                    z\^3 - b\^2\ z + a \[Equal] 0)\), {a, b}, 
              Reals]]\)[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CADZeroTest\>" \[Rule] {2, 30}\)];\)\), "\[IndentingNewLine]", 
    \(\(t2 = \(Timing[
            Reduce[\[Exists] \_z\((z\^3 - a\^2\ z + b \[Equal] 0 && 
                    z\^3 - b\^2\ z + a \[Equal] 0)\), {a, b}, 
              Reals]]\)[\([1]\)];\)\), "\[IndentingNewLine]", 
    \({t1, t2}\)}], "Input",
  CellLabel->"In[59]:="],

Cell[BoxData[
    \({1.8100000000000014`\ Second, 1.100000000000001`\ Second}\)], "Output",
  CellLabel->"Out[62]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<CADZeroTest\>" \[Rule] {0, Infinity}\)];\)\)], "Input",
  CellLabel->"In[63]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ContinuedFractionRootIsolation", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "To isolate real roots of polynomials, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses methods based on Descartes\[CloseCurlyQuote] rule of sign. There are \
two interval subdivision strategies implemented, one based on interval \
bisection and another based on continued fractions  (see [",
  ButtonBox["19",
    ButtonData:>"19",
    ButtonStyle->"Hyperlink"],
  "] for details). The variant based on continued fractions is generally \
faster and is used by default. Setting  ",
  StyleBox["ContinuedFractionRootIsolation", "MR"],
  " to ",
  StyleBox["False", "MR"],
  " causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use the interval bisection variant."
}], "Text"],

Cell[TextData[{
  "Here is an example where the speed difference between the two root \
isolation methods affects ",
  StyleBox["Reduce", "MR"],
  " timing. We need to clear the ",
  StyleBox["Root", "MR"],
  " cache between the ",
  StyleBox["Reduce", "MR"],
  " calls; otherwise, the second call would save time on factoring the 400th \
degree polynomial when ",
  StyleBox["Root", "MR"],
  " objects are created."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(SeedRandom[1234];\)\), "\n", 
    \(\(f = \[Sum]\+\(i = 0\)\%399 Random[Integer, {\(-1000\), 1000}]\ x\^i + 
          x\^400;\)\), "\n", 
    \(\(t1 = Timing[Reduce[f \[LessEqual] 0, x, Reals]];\)\), "\n", 
    \(\(Developer`ClearCache["\<Root\>"];\)\), "\n", 
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ContinuedFractionRootIsolation\>" \[Rule] False\)];\)\), "\n", 
    \(\(t2 = Timing[Reduce[f \[LessEqual] 0, x, Reals]];\)\), "\n", 
    \({t1\[LeftDoubleBracket]1\[RightDoubleBracket], 
      t2\[LeftDoubleBracket]1\[RightDoubleBracket], 
      t1\[LeftDoubleBracket]2\[RightDoubleBracket] === 
        t2\[LeftDoubleBracket]2\[RightDoubleBracket]}\)}], "Input",
  CellLabel->"In[64]:="],

Cell[BoxData[
    \({3.2399999999999998`\ Second, 3.9200000000000013`\ Second, 
      True}\)], "Output",
  CellLabel->"Out[70]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ContinuedFractionRootIsolation\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[71]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FGLMBasisConversion", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "For systems with equational constraints generating a zero-dimensional \
ideal ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a variant of the CAD algorithm that finds projection polynomials \
using Gr\[ODoubleDot]bner basis methods. If the lexicographic order Gr\
\[ODoubleDot]bner basis of ",
  StyleBox["I",
    FontSlant->"Italic"],
  " does not contain linear polynomials with constant coefficients in every \
variable but the last one, then for every variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " we find a univariate polynomial in ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  " that belongs to ",
  StyleBox["I",
    FontSlant->"Italic"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can do this in two ways. By default, it uses a method based on ",
  StyleBox["GroebnerWalk", "MR"],
  " computations. Setting ",
  StyleBox["FGLMBasisConversion", "MR"],
  " to ",
  StyleBox["True", "MR"],
  " causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use a method based on [",
  ButtonBox["20",
    ButtonData:>"20",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "The method based on [",
  ButtonBox["20]",
    ButtonData:>"20",
    ButtonStyle->"Hyperlink"],
  " seems to be slightly slower in general."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(t1 = 
        Timing[Reduce[
            x\^10 + 3\ x\^4 - 5\ x\^3 + 7\ x\^2 - 9\ x \[Equal] 11 && 
              y\^3 - y\^2 + x \[Equal] 1 && 
              z\^3 + 2\ z - 3\ x \[Equal] 4, {x, y, z}, Reals]];\)\), "\n", 
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<FGLMBasisConversion\>" \[Rule] True\)];\)\), "\n", 
    \(\(t2 = 
        Timing[Reduce[
            x\^10 + 3\ x\^4 - 5\ x\^3 + 7\ x\^2 - 9\ x \[Equal] 11 && 
              y\^3 - y\^2 + x \[Equal] 1 && 
              z\^3 + 2\ z - 3\ x \[Equal] 4, {x, y, z}, Reals]];\)\), "\n", 
    \({t1\[LeftDoubleBracket]1\[RightDoubleBracket], 
      t2\[LeftDoubleBracket]1\[RightDoubleBracket], 
      t1\[LeftDoubleBracket]2\[RightDoubleBracket] === 
        t2\[LeftDoubleBracket]2\[RightDoubleBracket]}\)}], "Input",
  CellLabel->"In[72]:="],

Cell[BoxData[
    \({0.12000000000000141`\ Second, 0.15999999999999687`\ Second, 
      True}\)], "Output",
  CellLabel->"Out[75]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<FGLMBasisConversion\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[76]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FGLMElimination", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The ",
  StyleBox["FGLMElimination ", "MR"],
  "option specifies whether ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should use a special case heuristic applicable to systems with equational \
constraints generating a zero-dimensional ideal ",
  StyleBox["I",
    FontSlant->"Italic"],
  ". The heuristic uses a method based on [",
  ButtonBox["20",
    ButtonData:>"20",
    ButtonStyle->"Hyperlink"],
  "] to find in ",
  StyleBox["I",
    FontSlant->"Italic"],
  " polynomials that are linear (with a constant coefficient) in one of the \
quantified variables and uses such polynomials for elimination. The method \
can be used both in the decision algorithm and in quantifier elimination. \
With the default ",
  StyleBox["Automatic", "MR"],
  " setting, it is used only in ",
  StyleBox["Resolve", "MR"],
  " with no \[OpenCurlyDoubleQuote]solve\[CloseCurlyDoubleQuote] variables \
specified and for systems with at least two free variables."
}], "Text"],

Cell[TextData[{
  "This by default uses the elimination method based on [",
  ButtonBox["20",
    ButtonData:>"20",
    ButtonStyle->"Hyperlink"],
  "], and returns a quantifier-free system in an unsolved form."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[\[Exists] \_z\((x\^2 + 2\ y\^3 - 3\ x\ y + 4\ x\ z + 
                  2\ z\^3 \[Equal] 1 && 
              y\^3 - 2\ x\^2\ z + 5\ x - 7\ z\^3 \[Equal] 2 && 
              3\ x\ y + 4\ z\^3 - 5\ y\^3 \[Equal] 0)\), Reals] // 
      Timing\)], "Input",
  CellLabel->"In[77]:="],

Cell[BoxData[
    \({0.030000000000000276`\ Second, \(-387703943456010\) + 
            836307322497954\ x + 94016672514000\ x\^2 + 
            42483692361858\ x\^3 + 48951449972226\ x\^4 + 
            592457191920\ x\^5 + 6111106822080\ x\^6 - 682099934085412\ y + 
            2386910531381715\ x\ y - 33458557021065\ x\^2\ y + 
            179029980402448\ x\^3\ y + 23352969127806\ x\^4\ y - 
            10673134807104\ x\^5\ y + 1298614472640\ x\^6\ y - 
            6165373996350\ y\^2 + 1787681183046234\ x\ y\^2 - 
            463516345125783\ x\^2\ y\^2 + 1221461511750\ x\^3\ y\^2 + 
            7275931779870\ x\^4\ y\^2 - 3220021226880\ x\^5\ y\^2 + 
            453968712000\ x\^6\ y\^2 - 1333886745639423\ y\^3 - 
            2629577891362724\ y\^4 - 20449871823375\ y\^5 + 
            473314204852983\ y\^6 \[Equal] 
          0 && \(-567795134\) + 1059962112\ x + 430480332\ x\^2 + 
            309282350\ x\^3 - 11545182\ x\^4 + 23721822\ x\^5 - 
            7231680\ x\^6 + 2099520\ x\^7 + 320591520\ y + 927840621\ x\ y - 
            389548395\ x\^2\ y - 209188980\ x\^3\ y - 29695086\ x\^4\ y + 
            15536448\ x\^5\ y - 3779136\ x\^6\ y - 40678200\ y\^2 - 
            761836590\ x\ y\^2 + 158630400\ x\^2\ y\^2 + 
            30508650\ x\^3\ y\^2 - 2255020201\ y\^3 + 1242292140\ y\^4 - 
            157628025\ y\^5 \[Equal] 
          0 && \(-394500\) + 962118\ x - 153630\ x\^2 + 43806\ x\^3 + 
            17982\ x\^4 + 5760\ x\^6 - 578624\ y + 2180295\ x\ y - 
            352890\ x\^2\ y + 291671\ x\^3\ y + 12492\ x\^4\ y - 
            10368\ x\^5\ y + 168480\ y\^2 + 1168968\ x\ y\^2 - 
            445266\ x\^2\ y\^2 - 50220\ x\^3\ y\^2 - 1370121\ y\^3 - 
            2271328\ y\^4 + 652860\ y\^5 + 445266\ y\^6 - 
            112995\ y\^7 \[Equal] 
          0 && \(-8\) + 18\ x + 2\ x\^3 + 21\ x\ y - 9\ x\^2\ y - 31\ y\^3 + 
            9\ x\ y\^3 \[Equal] 0}\)], "Output",
  CellLabel->"Out[77]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["FGLMElimination", "MR"],
  " set to ",
  StyleBox["False", "MR"],
  ", the example takes longer to compute and the answer is in a solved form. \
(We show ",
  StyleBox["N", "MR"],
  " of the answer for better readability.)"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<FGLMElimination\>" \[Rule] False\)];\)\), "\n", 
    \(\(Resolve[\[Exists] \_z\((x\^2 + 2\ y\^3 - 3\ x\ y + 4\ x\ z + 
                    2\ z\^3 \[Equal] 1 && 
                y\^3 - 2\ x\^2\ z + 5\ x - 7\ z\^3 \[Equal] 2 && 
                3\ x\ y + 4\ z\^3 - 5\ y\^3 \[Equal] 0)\), Reals] // 
        Timing\) // N\)}], "Input",
  CellLabel->"In[78]:="],

Cell[BoxData[
    \({0.05999999999999914`\ Second, \((y \[Equal] \(-0.6168114930309259`\) && 
            x \[Equal] \(-5.18103204618521`\) - 137.34669045959384`\ y - 
                1010.7772077622324`\ y\^2 - 2069.963292131805`\ y\^3 + 
                92.70620495840251`\ y\^4 + 7185.167171283084`\ y\^5 + 
                10826.994842914604`\ y\^6 - 17208.036096999178`\ y\^7 - 
                25441.00374948718`\ y\^8 + 59919.27655504113`\ y\^9 + 
                5428.346811272452`\ y\^10 - 87974.35090833936`\ y\^11 + 
                90884.3117937849`\ y\^12 + 9563.19090528646`\ y\^13 - 
                65852.07047593516`\ y\^14 + 61525.6430633211`\ y\^15 - 
                51406.51813344433`\ y\^16 + 51634.32575405828`\ y\^17 - 
                27621.232729631618`\ y\^18 + 1364.5006363685343`\ y\^19 + 
                5842.544493947248`\ y\^20 - 1836.1487036996837`\ y\^21 - 
                216.10433836262564`\ y\^22 + 
                162.85349715825288`\ y\^23)\) || \((y \[Equal] \
\(-0.5100250814599211`\) && 
            x \[Equal] \(-5.18103204618521`\) - 137.34669045959384`\ y - 
                1010.7772077622324`\ y\^2 - 2069.963292131805`\ y\^3 + 
                92.70620495840251`\ y\^4 + 7185.167171283084`\ y\^5 + 
                10826.994842914604`\ y\^6 - 17208.036096999178`\ y\^7 - 
                25441.00374948718`\ y\^8 + 59919.27655504113`\ y\^9 + 
                5428.346811272452`\ y\^10 - 87974.35090833936`\ y\^11 + 
                90884.3117937849`\ y\^12 + 9563.19090528646`\ y\^13 - 
                65852.07047593516`\ y\^14 + 61525.6430633211`\ y\^15 - 
                51406.51813344433`\ y\^16 + 51634.32575405828`\ y\^17 - 
                27621.232729631618`\ y\^18 + 1364.5006363685343`\ y\^19 + 
                5842.544493947248`\ y\^20 - 1836.1487036996837`\ y\^21 - 
                216.10433836262564`\ y\^22 + 
                162.85349715825288`\ y\^23)\) || \((y \[Equal] \
\(-0.08979850665278406`\) && 
            x \[Equal] \(-5.18103204618521`\) - 137.34669045959384`\ y - 
                1010.7772077622324`\ y\^2 - 2069.963292131805`\ y\^3 + 
                92.70620495840251`\ y\^4 + 7185.167171283084`\ y\^5 + 
                10826.994842914604`\ y\^6 - 17208.036096999178`\ y\^7 - 
                25441.00374948718`\ y\^8 + 59919.27655504113`\ y\^9 + 
                5428.346811272452`\ y\^10 - 87974.35090833936`\ y\^11 + 
                90884.3117937849`\ y\^12 + 9563.19090528646`\ y\^13 - 
                65852.07047593516`\ y\^14 + 61525.6430633211`\ y\^15 - 
                51406.51813344433`\ y\^16 + 51634.32575405828`\ y\^17 - 
                27621.232729631618`\ y\^18 + 1364.5006363685343`\ y\^19 + 
                5842.544493947248`\ y\^20 - 1836.1487036996837`\ y\^21 - 
                216.10433836262564`\ y\^22 + 
                162.85349715825288`\ y\^23)\) || \((y \[Equal] 
              0.6643417099163675` && 
            x \[Equal] \(-5.18103204618521`\) - 137.34669045959384`\ y - 
                1010.7772077622324`\ y\^2 - 2069.963292131805`\ y\^3 + 
                92.70620495840251`\ y\^4 + 7185.167171283084`\ y\^5 + 
                10826.994842914604`\ y\^6 - 17208.036096999178`\ y\^7 - 
                25441.00374948718`\ y\^8 + 59919.27655504113`\ y\^9 + 
                5428.346811272452`\ y\^10 - 87974.35090833936`\ y\^11 + 
                90884.3117937849`\ y\^12 + 9563.19090528646`\ y\^13 - 
                65852.07047593516`\ y\^14 + 61525.6430633211`\ y\^15 - 
                51406.51813344433`\ y\^16 + 51634.32575405828`\ y\^17 - 
                27621.232729631618`\ y\^18 + 1364.5006363685343`\ y\^19 + 
                5842.544493947248`\ y\^20 - 1836.1487036996837`\ y\^21 - 
                216.10433836262564`\ y\^22 + 
                162.85349715825288`\ y\^23)\)}\)], "Output",
  CellLabel->"Out[79]="]
}, Open  ]],

Cell[TextData[{
  "If there is only one free variable, ",
  StyleBox["Resolve", "MR"],
  " by default does not use the elimination method based on [",
  ButtonBox["20",
    ButtonData:>"20",
    ButtonStyle->"Hyperlink"],
  "]. (We show ",
  StyleBox["N", "MR"],
  " of the answer for better readability.)"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<FGLMElimination\>" \[Rule] Automatic\)];\)\), "\[IndentingNewLine]", 
    \(\(Resolve[\[Exists] \_{y, z}\((x\^2 + 2\ y\^3 - 3\ x\ y + 4\ x\ z + 
                    2\ z\^3 \[Equal] 1 && 
                y\^3 - 2\ x\^2\ z + 5\ x - 7\ z\^3 \[Equal] 2 && 
                3\ x\ y + 4\ z\^3 - 5\ y\^3 \[Equal] 0)\), Reals] // 
        Timing\) // N\)}], "Input",
  CellLabel->"In[80]:="],

Cell[BoxData[
    \({0.06`\ Second, 
      x \[Equal] \(-1.0508767487688377`\) || x \[Equal] 0.4528348868677499` || 
        x \[Equal] 0.4711404273803387` || 
        x \[Equal] 0.5346272342555823`}\)], "Output",
  CellLabel->"Out[81]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["FGLMElimination", "MR"],
  " set to ",
  StyleBox["True", "MR"],
  ",",
  " the example takes longer to compute and the answer is given in an \
unsolved form."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<FGLMElimination\>" \[Rule] True\)];\)\), "\n", 
    \(Resolve[\[Exists] \_{y, z}\((x\^2 + 2\ y\^3 - 3\ x\ y + 4\ x\ z + 
                  2\ z\^3 \[Equal] 1 && 
              y\^3 - 2\ x\^2\ z + 5\ x - 7\ z\^3 \[Equal] 2 && 
              3\ x\ y + 4\ z\^3 - 5\ y\^3 \[Equal] 0)\), Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[82]:="],

Cell[BoxData[
    \({0.17000000000000004`\ Second, \(-27206534396294947\) + 
          328914818820879210\ x - 1654010622073883961\ x\^2 + 
          4186250649401504955\ x\^3 - 4131264062314837638\ x\^4 - 
          5359613482785909285\ x\^5 + 20455887169340134671\ x\^6 - 
          18111422036067816735\ x\^7 - 14851799572578604767\ x\^8 + 
          46025930760201888392\ x\^9 - 33951750015320895222\ x\^10 - 
          3130213891174116318\ x\^11 + 18846711211560897036\ x\^12 - 
          13729694750794525104\ x\^13 + 8758251556584250005\ x\^14 - 
          4917731156959045278\ x\^15 + 2285701226953461792\ x\^16 - 
          895869248032870029\ x\^17 + 304502137753065983\ x\^18 - 
          88547080320192096\ x\^19 + 21286381859013600\ x\^20 - 
          4017686252055552\ x\^21 + 554267616334848\ x\^22 - 
          49218499805184\ x\^23 + 2176782336000\ x\^24 \[Equal] 
        0}\)], "Output",
  CellLabel->"Out[83]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<FGLMElimination\>" \[Rule] Automatic\)];\)\)], "Input",
  CellLabel->"In[84]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["GenericCAD", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a simplified version of the CAD algorithm described in [",
  ButtonBox["13",
    ButtonData:>"13",
    ButtonStyle->"Hyperlink"],
  "] to solve decision problems or find solutions of real polynomial systems \
that do not contain equations. The method finds a solution or proves that \
there are no solutions if all inequalities in the system are strict (< or >). \
The method is also used for systems containing weak (<= or >=) inequalities. \
In this case, if it finds a solution of the strict inequality version of the \
system, it is also a solution of the original system. However, if it proves \
that the strict inequality version of the system has no solutions, the full \
version of the CAD algorithm is needed to decide whether the original system \
has solutions. The system option ",
  StyleBox["GenericCAD", "MR"],
  " specifies whether ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " should use the method."
}], "Text"],

Cell[TextData[{
  "Here the ",
  StyleBox["GenericCAD", "MR"],
  " method finds a solution of the strict inequality version of the system."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x\^4 + y\^4 + z\^4 \[LessEqual] 12 && 
          x\^2\ y\^2 - 3\ x\^2\ z\^2 \[GreaterEqual] 1 && 
          x\ y \[LessEqual] 3\ z\^3 + 4, {x, y, z}, Reals] // 
      Timing\)], "Input",
  CellLabel->"In[85]:="],

Cell[BoxData[
    \({0.16999999999999998`\ Second, {{x \[Rule] 145\/128, 
          y \[Rule] \(-\(113\/64\)\), 
          z \[Rule] \(-\(113\/128\)\)}}}\)], "Output",
  CellLabel->"Out[85]="]
}, Open  ]],

Cell[TextData[{
  "Without ",
  StyleBox["GenericCAD", "MR"],
  ",",
  " finding a solution of the system takes much longer."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GenericCAD\>" \[Rule] False\)];\)\), "\n", 
    \(FindInstance[
        x\^4 + y\^4 + z\^4 \[LessEqual] 12 && 
          x\^2\ y\^2 - 3\ x\^2\ z\^2 \[GreaterEqual] 1 && 
          x\ y \[LessEqual] 3\ z\^3 + 4, {x, y, z}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[86]:="],

Cell[BoxData[
    \({0.94`\ Second, {{x \[Rule] 309\/256, y \[Rule] \(-\(223\/128\)\), 
          z \[Rule] \(-\(1809\/2048\)\)}}}\)], "Output",
  CellLabel->"Out[87]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GenericCAD\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[88]:="],

Cell[TextData[{
  "This system has no solutions and contains weak inequalities. After the ",
  StyleBox["GenericCAD", "MR"],
  " method finds no solutions of the strict inequality version of the system, \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " needs to run the full CAD to prove that there are no solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x\^4 + y\^4 + z\^4 \[LessEqual] 12 && 
          x\^3 + y\^3 - z\^3 \[GreaterEqual] 9, {x, y, z}, Reals] // 
      Timing\)], "Input",
  CellLabel->"In[89]:="],

Cell[BoxData[
    \({0.9500000000000001`\ Second, {}}\)], "Output",
  CellLabel->"Out[89]="]
}, Open  ]],

Cell[TextData[{
  "Running the same example with ",
  StyleBox["GenericCAD\[Rule]False", "MR"],
  " allows to save the time previously used by the ",
  StyleBox["GenericCAD", "MR"],
  " computation."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GenericCAD\>" \[Rule] False\)];\)\), "\n", 
    \(FindInstance[
        x\^4 + y\^4 + z\^4 \[LessEqual] 12 && 
          x\^3 + y\^3 - z\^3 \[GreaterEqual] 9, {x, y, z}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[90]:="],

Cell[BoxData[
    \({0.5500000000000002`\ Second, {}}\)], "Output",
  CellLabel->"Out[91]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GenericCAD\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[92]:="],

Cell[TextData[{
  "This system contains only strict inequalities, so ",
  StyleBox["GenericCAD", "MR"],
  " can prove that it has no solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x\^4 + y\^4 + z\^4 < 12 && x\^2\ y\^2 - 3\ x\^2\ z\^2 > 7 && 
          x\ y < 3\ z\^3 + 4, {x, y, z}, Reals] // Timing\)], "Input",
  CellLabel->"In[93]:="],

Cell[BoxData[
    \({0.16999999999999987`\ Second, {}}\)], "Output",
  CellLabel->"Out[93]="]
}, Open  ]],

Cell[TextData[{
  "Without ",
  StyleBox["GenericCAD", "MR"],
  ",",
  " it takes a very long time to prove that the system has no solutions."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GenericCAD\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(TimeConstrained[
      FindInstance[
          x\^4 + y\^4 + z\^4 < 12 && x\^2\ y\^2 - 3\ x\^2\ z\^2 > 7 && 
            x\ y < 3\ z\^3 + 4, {x, y, z}, Reals] // Timing, \ 
      3600]\)}], "Input",
  CellLabel->"In[94]:="],

Cell[BoxData[
    \($Aborted\)], "Output",
  CellLabel->"Out[95]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GenericCAD\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[96]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["GroebnerCAD", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "For systems with equational constraints generating a zero-dimensional \
ideal ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a variant of the CAD algorithm that finds projection polynomials \
using Gr\[ODoubleDot]bner basis methods. Setting ",
  StyleBox["GroebnerCAD", "MR"],
  " to ",
  StyleBox["False", "MR"],
  ", causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use the standard CAD projection instead."
}], "Text"],

Cell[TextData[{
  "With ",
  StyleBox["GroebnerCAD\[Rule]False", "MR"],
  ",",
  " this example runs three orders of magnitude slower."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(a1 = 
          Reduce[x\^2 + y\^2 + z\^2 \[Equal] 12 && 
              x\^2\ y\^2 - 3\ x\^2\ z\^2 \[Equal] 1 && 
              x\ y \[Equal] 3\ z\^3 + 4, {x, y, z}, Reals];\) // 
      Timing\)], "Input",
  CellLabel->"In[97]:="],

Cell[BoxData[
    \({0.02999999999999995`\ Second, Null}\)], "Output",
  CellLabel->"Out[97]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GroebnerCAD\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[98]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(a2 = 
          Reduce[x\^2 + y\^2 + z\^2 \[Equal] 12 && 
              x\^2\ y\^2 - 3\ x\^2\ z\^2 \[Equal] 1 && 
              x\ y \[Equal] 3\ z\^3 + 4, {x, y, z}, Reals];\) // 
      Timing\)], "Input",
  CellLabel->"In[99]:="],

Cell[BoxData[
    \({20.91`\ Second, Null}\)], "Output",
  CellLabel->"Out[99]="]
}, Open  ]],

Cell["This checks that the solutions are equivalent.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[\(({x, y, z} //. N[{ToRules[a1]}, 30])\) - \(({x, y, z} //. 
            N[{ToRules[a2]}, 30])\)]\)], "Input",
  CellLabel->"In[100]:="],

Cell[BoxData[
    \({{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 
        0, 0}, {0, 0, 0}}\)], "Output",
  CellLabel->"Out[100]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<GroebnerCAD\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[101]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["LinearDecisionMethodCrossovers, LWDecision, ", "MR",
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  "and ",
  StyleBox["Simplex", "MR",
    FontFamily->"Helvetica",
    FontWeight->"Bold"]
}], "SubsubsectionIcon"],

Cell[TextData[{
  "These three options specify methods used to solve decision problems or \
find solution instances for systems of linear equations and inequalities. The \
available methods are the Loos-Weispfenning algorithm [",
  ButtonBox["15",
    ButtonData:>"15",
    ButtonStyle->"Hyperlink"],
  "], the Simplex algorithm, and the Revised Simplex algorithm. All three \
methods can handle systems with rational or floating point number \
coefficients. For systems with exact numeric nonrational coefficients, only \
the Loos-Weispfenning algorithm is implemented. ",
  StyleBox["LWDecision", "MR"],
  " specifies whether the Loos-Weispfenning algorithm is available. ",
  StyleBox["Simplex", "MR"],
  " specifies whether the Simplex and Revised Simplex algorithms can be used. \
",
  StyleBox["LinearDecisionMethodCrossovers", "MR"],
  " determines which method is used if all are available and applicable. The \
value of the option should be a triple {",
  StyleBox["m",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", ",
  StyleBox["p",
    FontSlant->"Italic"],
  "}.  For linear systems with up to ",
  StyleBox["m", "TI"],
  " variables, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the Loos-Weispfenning method [",
  ButtonBox["15",
    ButtonData:>"15",
    ButtonStyle->"Hyperlink"],
  "]; for systems with ",
  StyleBox["m ",
    FontSlant->"Italic"],
  "+ 1 to ",
  StyleBox["n",
    FontSlant->"Italic"],
  " variables, the Simplex algorithm; and for more than ",
  StyleBox["n",
    FontSlant->"Italic"],
  " variables, the Revised Simplex algorithm. If the Simplex algorithm is \
used, the slack variables are used if the number of inequalities is no more \
than ",
  StyleBox["p",
    FontSlant->"Italic"],
  " times the number of variables. The default values are ",
  StyleBox["m",
    FontSlant->"Italic"],
  "=0, ",
  StyleBox["n",
    FontSlant->"Italic"],
  "=30, and ",
  StyleBox["p",
    FontSlant->"Italic"],
  "=20. "
}], "Text"],

Cell["\<\
By default, the Simplex algorithm is used to find a solution of a \
linear system with three variables.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x + 2  y + 3  z \[Equal] 4 && 5  x + 6  y - 7  z \[LessEqual] 8 && 
          9  x - 10  y + 11  z > 12, {x, y, z}, Reals] // Timing\)], "Input",
  CellLabel->"In[102]:="],

Cell[BoxData[
    \({8.552186736565659`*^-16\ Second, {{x \[Rule] 199\/138, 
          y \[Rule] 149\/276, z \[Rule] 34\/69}}}\)], "Output",
  CellLabel->"Out[102]="]
}, Open  ]],

Cell["Here the Revised Simplex algorithm is used.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearDecisionMethodCrossovers\>" \[Rule] {0, 0, 
              20}\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        x + 2  y + 3  z \[Equal] 4 && 5  x + 6  y - 7  z \[LessEqual] 8 && 
          9  x - 10  y + 11  z > 12, {x, y, z}, Reals] // Timing\)}], "Input",\

  CellLabel->"In[103]:="],

Cell[BoxData[
    \({0.06000000000000086`\ Second, {{x \[Rule] 0, y \[Rule] 5\/52, 
          z \[Rule] 33\/26}}}\)], "Output",
  CellLabel->"Out[104]="]
}, Open  ]],

Cell["Here the Loos-Weispfenning algorithm is used.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearDecisionMethodCrossovers\>" \[Rule] {10, 0, 
              20}\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        x + 2  y + 3  z \[Equal] 4 && 5  x + 6  y - 7  z \[LessEqual] 8 && 
          9  x - 10  y + 11  z > 12, {x, y, z}, Reals] // Timing\)}], "Input",\

  CellLabel->"In[105]:="],

Cell[BoxData[
    \({0.`\ Second, {{x \[Rule] 34\/23, y \[Rule] 5\/46, 
          z \[Rule] 53\/69}}}\)], "Output",
  CellLabel->"Out[106]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearDecisionMethodCrossovers\>" \[Rule] {0, 30, 20}\)];\)\)], "Input",
  CellLabel->"In[107]:="],

Cell["\<\
Here the Loos-Weispfenning algorithm is used because the Simplex \
and Revised Simplex algorithms are not implemented for systems with exact \
nonrational coefficients.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x + \[Pi]\ y + \[ExponentialE]\ z > Sin[1] && 
          Log[2]\ x + \[Pi]\^\[ExponentialE]\ y - 7\^\[Pi]\ z \[Equal] 
            8\/\[ExponentialE], {x, y, z}, Reals] // Timing\)], "Input",
  CellLabel->"In[108]:="],

Cell[BoxData[
    \({0.009999999999998583`\ Second, {{x \[Rule] 0, y \[Rule] 2, 
          z \[Rule] \(-\(\(8\ 7\^\(-\[Pi]\)\)\/\[ExponentialE]\)\) + 
              2\ 7\^\(-\[Pi]\)\ \[Pi]\^\[ExponentialE]}}}\)], "Output",
  CellLabel->"Out[108]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["LWDecision", "MR"],
  " set to ",
  StyleBox["False", "MR"],
  ", and Simplex and Revised Simplex not applicable, ",
  StyleBox["FindInstance", "MR"],
  " has to use the CAD algorithm here."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWDecision\>" \[Rule] False\)];\)\), "\n", 
    \(FindInstance[
        x + \[Pi]\ y + \[ExponentialE]\ z > Sin[1] && 
          Log[2]\ x + \[Pi]\^\[ExponentialE]\ y - 7\^\[Pi]\ z \[Equal] 
            8\/\[ExponentialE], {x, y, z}, Reals] // Timing\)}], "Input",
  CellLabel->"In[109]:="],

Cell[BoxData[
    \({0.020000000000000573`\ Second, {{x \[Rule] 0, y \[Rule] 98, 
          z \[Rule] \(2\ 7\^\(-\[Pi]\)\ \((\(-4\) + 49\ \[ExponentialE]\ \
\[Pi]\^\[ExponentialE])\)\)\/\[ExponentialE]}}}\)], "Output",
  CellLabel->"Out[110]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWDecision\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[111]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LinearEquations", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The ",
  StyleBox["LinearEquations", "MR"],
  " option specifies whether linear equation constraints with constant \
leading coefficients should be used to eliminate variables. This generally \
improves the performance of the algorithm. The option is provided to allow \
experimentation with the \[OpenCurlyDoubleQuote]pure",
  "\[CloseCurlyDoubleQuote]",
  " CAD-based decision algorithm."
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the first equation to eliminate ",
  StyleBox["x",
    FontSlant->"Italic"],
  " before using CAD to find a solution of the resulting system with two \
variables."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x + 2\ y\^2 + z\^3 \[Equal] 7 && 
          2\ x\^2\ y\^3 - 3\ x\ z\^3 + 5\ x\ y\ z - x\^3 + x + y - 
              z \[GreaterEqual] 3 && 
          4\ x\ y\^3 + 5\ y\^4\ z\^2 + 11\ y\ z\^2 \[LessEqual] 3\ z\^3 + 7 && 
          x\^2 + y\^2 + z\^2 \[LessEqual] 4, {x, y, z}, Reals] // 
      Timing\)], "Input",
  CellLabel->"In[112]:="],

Cell[BoxData[
    \({0.130000000000001`\ Second, {{x \[Rule] \(-\(17411\/55296\)\), 
          y \[Rule] 123\/64, z \[Rule] \(-\(5\/12\)\)}}}\)], "Output",
  CellLabel->"Out[112]="]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses CAD to find a solution of the original system with three variables."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearEquations\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        x + 2\ y\^2 + z\^3 \[Equal] 7 && 
          2\ x\^2\ y\^3 - 3\ x\ z\^3 + 5\ x\ y\ z - x\^3 + x + y - 
              z \[GreaterEqual] 3 && 
          4\ x\ y\^3 + 5\ y\^4\ z\^2 + 11\ y\ z\^2 \[LessEqual] 3\ z\^3 + 7 && 
          x\^2 + y\^2 + z\^2 \[LessEqual] 4, {x, y, z}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[113]:="],

Cell[BoxData[
    \({0.3399999999999984`\ Second, {{x \[Rule] \(-\(78015\/262144\)\), 
          y \[Rule] 491\/256, z \[Rule] \(-\(25\/64\)\)}}}\)], "Output",
  CellLabel->"Out[114]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearEquations\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[115]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LinearQE", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The ",
  StyleBox["LinearQE", "MR"],
  " option specifies methods used to handle systems containing at least one \
innermost quantifier variable that appears at most linearly in all equations \
and inequalities in the system. The option setting does not affect solving of \
decision problems. With the default setting ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the Loos-Weispfenning algorithm [",
  ButtonBox["15",
    ButtonData:>"15",
    ButtonStyle->"Hyperlink"],
  "] to eliminate all quantifier variables that appear only linearly in the \
system, and then if there are any quantifiers left or the result needs to be \
solved for the free variables, the CAD algorithm is used. With ",
  StyleBox["LinearQE->Automatic", "MR"],
  ", the Loos-Weispfenning algorithm is used only for variables that appear \
in the system only linearly with constant coefficients. With ",
  StyleBox["LinearQE->False", "MR"],
  ",  the Loos-Weispfenning algorithm is not used."
}], "Text"],

Cell[TextData[{
  "With the default setting ",
  StyleBox["LinearQE->True", "MR"],
  ",  the Loos-Weispfenning algorithm is used to eliminate both ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and CAD is used to solve the remaining quantifier-free system with two \
variables."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(a1 = 
          Reduce[\[Exists] \_{x, y}\((2\ x + 3\ y\ z + 
                      4\ z\^2\ t \[LessEqual] 1 && 
                  5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 
                    3 && 3\ x - 5\ t\ z\^2 - 3\ t\^2 - 
                      y\ z\ t \[GreaterEqual] 2 && 
                  t\^2 + z\^2 \[LessEqual] z\ y)\), {z, t}];\) // 
      Timing\)], "Input",
  CellLabel->"In[116]:="],

Cell[BoxData[
    \({0.8199999999999986`\ Second, Null}\)], "Output",
  CellLabel->"Out[116]="]
}, Open  ]],

Cell[TextData[{
  "With  ",
  StyleBox["LinearQE->Automatic", "MR"],
  ",  the Loos-Weispfenning algorithm is used only to eliminate  ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", and CAD is used to solve the remaining system with three variables. For \
this example, the default method is about twice as fast."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearQE\>" \[Rule] Automatic\)];\)\), "\[IndentingNewLine]", 
    \(\(a2 = 
          Reduce[\[Exists] \_{x, y}\((2\ x + 3\ y\ z + 
                      4\ z\^2\ t \[LessEqual] 1 && 
                  5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 
                    3 && 3\ x - 5\ t\ z\^2 - 3\ t\^2 - 
                      y\ z\ t \[GreaterEqual] 2 && 
                  t\^2 + z\^2 \[LessEqual] z\ y)\), {z, t}];\) // 
      Timing\)}], "Input",
  CellLabel->"In[117]:="],

Cell[BoxData[
    \({1.9299999999999984`\ Second, Null}\)], "Output",
  CellLabel->"Out[118]="]
}, Open  ]],

Cell["Both methods give the same answer.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a1 === a2\)], "Input",
  CellLabel->"In[119]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[119]="]
}, Open  ]],

Cell[TextData[{
  "With  ",
  StyleBox["LinearQE->False", "MR"],
  ",  the Loos-Weispfenning algorithm is not used. ",
  StyleBox["Reduce", "MR"],
  " uses CAD to solve the original system with four variables, which for this \
example takes a very long time."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearQE\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(TimeConstrained[\(a3 = 
            Reduce[\[Exists] \_{x, y}\((2\ x + 3\ y\ z + 
                        4\ z\^2\ t \[LessEqual] 1 && 
                    5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 
                        4\ z\^2\ t\^2 \[LessEqual] 3 && 
                    3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
                    t\^2 + z\^2 \[LessEqual] z\ y)\), {z, t}];\) // Timing, 
      300]\)}], "Input",
  CellLabel->"In[120]:="],

Cell[BoxData[
    \($Aborted\)], "Output",
  CellLabel->"Out[121]="]
}, Open  ]],

Cell[TextData[{
  "This is the same example, except that ",
  StyleBox["z",
    FontSlant->"Italic"],
  " has been added to the quantified variables. With the default setting ",
  StyleBox["LinearQE->True", "MR"],
  ",  the Loos-Weispfenning algorithm is used to eliminate both ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ",  and CAD is used to solve the remaining system with one quantified and \
one free variable. This time the default method is not the fastest."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearQE\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[\[Exists] \_{x, y, z}\((2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 
                1 && 5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 
                  4\ z\^2\ t\^2 \[LessEqual] 3 && 
              3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
              t\^2 + z\^2 \[LessEqual] z\ y)\), t] // Timing\)}], "Input",
  CellLabel->"In[122]:="],

Cell[BoxData[
    \({0.6500000000000022`\ Second, 
      t \[LessEqual] 
        Root[55696 + 611712\ #1 + 3248544\ #1\^2 + 13500064\ #1\^3 + 
              41178060\ #1\^4 + 72638592\ #1\^5 + 76002697\ #1\^6 + 
              88447680\ #1\^7 + 181305153\ #1\^8 + 201350948\ #1\^9 + 
              88499331\ #1\^10 + 68427618\ #1\^11 + 155219660\ #1\^12 + 
              20594160\ #1\^13 + 99572016\ #1\^14 + 167324192\ #1\^15 &, 
          1]}\)], "Output",
  CellLabel->"Out[123]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["LinearQE->Automatic", "MR"],
  ",  the Loos-Weispfenning algorithm is used only to eliminate ",
  StyleBox["x",
    FontSlant->"Italic"],
  ",  and then CAD is used to solve the remaining system with two quantified \
and one free variable. This is the fastest method for this example."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearQE\>" \[Rule] Automatic\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[\[Exists] \_{x, y, z}\((2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 
                1 && 5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 
                  4\ z\^2\ t\^2 \[LessEqual] 3 && 
              3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
              t\^2 + z\^2 \[LessEqual] z\ y)\), t] // Timing\)}], "Input",
  CellLabel->"In[124]:="],

Cell[BoxData[
    \({0.33000000000002505`\ Second, 
      t \[LessEqual] 
        Root[55696 + 611712\ #1 + 3248544\ #1\^2 + 13500064\ #1\^3 + 
              41178060\ #1\^4 + 72638592\ #1\^5 + 76002697\ #1\^6 + 
              88447680\ #1\^7 + 181305153\ #1\^8 + 201350948\ #1\^9 + 
              88499331\ #1\^10 + 68427618\ #1\^11 + 155219660\ #1\^12 + 
              20594160\ #1\^13 + 99572016\ #1\^14 + 167324192\ #1\^15 &, 
          1]}\)], "Output",
  CellLabel->"Out[125]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["LinearQE->False", "MR"],
  ",  the CAD algorithm is used to solve the system."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearQE\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[\[Exists] \_{x, y, z}\((2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 
                1 && 5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 
                  4\ z\^2\ t\^2 \[LessEqual] 3 && 
              3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
              t\^2 + z\^2 \[LessEqual] z\ y)\), t] // Timing\)}], "Input",
  CellLabel->"In[126]:="],

Cell[BoxData[
    \({0.42999999999998406`\ Second, 
      t \[LessEqual] 
        Root[55696 + 611712\ #1 + 3248544\ #1\^2 + 13500064\ #1\^3 + 
              41178060\ #1\^4 + 72638592\ #1\^5 + 76002697\ #1\^6 + 
              88447680\ #1\^7 + 181305153\ #1\^8 + 201350948\ #1\^9 + 
              88499331\ #1\^10 + 68427618\ #1\^11 + 155219660\ #1\^12 + 
              20594160\ #1\^13 + 99572016\ #1\^14 + 167324192\ #1\^15 &, 
          1]}\)], "Output",
  CellLabel->"Out[127]="]
}, Open  ]],

Cell[TextData[{
  "The default setting ",
  StyleBox["LinearQE->True", "MR"],
  " is definitely advantageous for quantifier elimination problems where all \
quantified variables appear only linearly in the system and the \
quantifier-free version of the system does not need to be given in a solved \
form. This is because the complexity of the Loos-Weispfenning algorithm \
depends very little on the number of free variables, unlike the complexity of \
the CAD algorithm that is doubly exponential in the number of all variables. \
With ",
  StyleBox["LinearQE->False", "MR"],
  ",  this example does not finish in 1000 seconds."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LinearQE\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(Resolve[\[Exists] \_{x, y}\((2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 
                1 && 5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ \(t\^2\) u + 
                  v^7 - 6  w^4  t \[LessEqual] 3 && 
              3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t - 
                  5  y\ w\ z \[GreaterEqual] 2)\), Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[128]:="],

Cell[BoxData[
    \({0.009999999999986353`\ Second, \((\(-t\^3\) < 0 && 
            5\ t\^3 + 30\ t\^5 + 27\ z + 6\ t\ z + 36\ t\^3\ z + 8\ t\^4\ z - 
                9\ v\^7\ z - 2\ t\ v\^7\ z + 30\ w\ z + 40\ t\^3\ w\ z - 
                10\ v\^7\ w\ z + 54\ t\ w\^4\ z + 12\ t\^2\ w\^4\ z + 
                60\ t\ w\^5\ z + 110\ t\^4\ z\^2 - 36\ t\^2\ u\ z\^3 - 
                8\ t\^3\ u\ z\^3 - 40\ t\^2\ u\ w\ z\^3 - 63\ z\^5 - 
                14\ t\ z\^5 - 70\ w\ z\^5 \[LessEqual] 0)\) || \((t\^3 < 
              0 && \(-5\)\ t\^3 - 30\ t\^5 - 27\ z - 6\ t\ z - 36\ t\^3\ z - 
                8\ t\^4\ z + 9\ v\^7\ z + 2\ t\ v\^7\ z - 30\ w\ z - 
                40\ t\^3\ w\ z + 10\ v\^7\ w\ z - 54\ t\ w\^4\ z - 
                12\ t\^2\ w\^4\ z - 60\ t\ w\^5\ z - 110\ t\^4\ z\^2 + 
                36\ t\^2\ u\ z\^3 + 8\ t\^3\ u\ z\^3 + 40\ t\^2\ u\ w\ z\^3 + 
                63\ z\^5 + 14\ t\ z\^5 + 70\ w\ z\^5 \[LessEqual] 
              0)\) || \((\(-9\)\ z - 2\ t\ z - 10\ w\ z < 
              0 && \(-5\)\ t\^3 - 30\ t\^5 - 27\ z - 6\ t\ z - 36\ t\^3\ z - 
                8\ t\^4\ z + 9\ v\^7\ z + 2\ t\ v\^7\ z - 30\ w\ z - 
                40\ t\^3\ w\ z + 10\ v\^7\ w\ z - 54\ t\ w\^4\ z - 
                12\ t\^2\ w\^4\ z - 60\ t\ w\^5\ z - 110\ t\^4\ z\^2 + 
                36\ t\^2\ u\ z\^3 + 8\ t\^3\ u\ z\^3 + 40\ t\^2\ u\ w\ z\^3 + 
                63\ z\^5 + 14\ t\ z\^5 + 70\ w\ z\^5 \[LessEqual] 
              0)\) || \((9\ z + 2\ t\ z + 10\ w\ z < 0 && 
            5\ t\^3 + 30\ t\^5 + 27\ z + 6\ t\ z + 36\ t\^3\ z + 8\ t\^4\ z - 
                9\ v\^7\ z - 2\ t\ v\^7\ z + 30\ w\ z + 40\ t\^3\ w\ z - 
                10\ v\^7\ w\ z + 54\ t\ w\^4\ z + 12\ t\^2\ w\^4\ z + 
                60\ t\ w\^5\ z + 110\ t\^4\ z\^2 - 36\ t\^2\ u\ z\^3 - 
                8\ t\^3\ u\ z\^3 - 40\ t\^2\ u\ w\ z\^3 - 63\ z\^5 - 
                14\ t\ z\^5 - 70\ w\ z\^5 \[LessEqual] 
              0)\) || \((t\^3 \[Equal] 0 && 
            1\/2 + 3\ t\^2 + 11\ t\ z\^2 \[LessEqual] 
              0 && \(-3\) - 4\ t\^3 + v\^7 - 6\ t\ w\^4 + 4\ t\^2\ u\ z\^2 + 
                7\ z\^4 \[LessEqual] 
              0)\) || \((9\ z + 2\ t\ z + 10\ w\ z \[Equal] 0 && 
            1\/2 + 3\ t\^2 + 11\ t\ z\^2 \[LessEqual] 
              0 && \(-3\) - 4\ t\^3 + v\^7 - 6\ t\ w\^4 + 4\ t\^2\ u\ z\^2 + 
                7\ z\^4 \[LessEqual] 0)\)}\)], "Output",
  CellLabel->"Out[129]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LWPreprocessor", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The ",
  StyleBox["LWPreprocessor", "MR"],
  " option setting affects solving decision problems and instance finding. \
The option specifies whether the Loos-Weispfenning algorithm [",
  ButtonBox["8",
    ButtonData:>"8",
    ButtonStyle->"Hyperlink"],
  "] should be used to eliminate variables that appear at most linearly in \
all equations and inequalities before applying the CAD algorithm to the \
resulting system. With the default setting ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the Loos-Weispfenning algorithm to eliminate variables that appear \
only linearly with constant coefficients. With ",
  StyleBox["LWPreprocessor", "MR"],
  " ",
  StyleBox["->True", "MR"],
  ", the Loos-Weispfenning algorithm is used for all variables that appear \
only linearly. With ",
  StyleBox["LWPreprocessor", "MR"],
  "\" ",
  StyleBox["->False", "MR"],
  ", the Loos-Weispfenning algorithm is not used as a preprocessor to the \
CAD-based decision algorithm."
}], "Text"],

Cell[TextData[{
  "With the default setting  ",
  StyleBox["LWPreprocessor->Automatic", "MR"],
  ", the Loos-Weispfenning algorithm is used only to eliminate  ",
  StyleBox["x",
    FontSlant->"Italic"],
  ",  and CAD is used to find a solution of the remaining system with three \
variables. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 1 && 
          5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 3 && 
          3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
          t\^2 + z\^2 \[LessEqual] z\ y, {x, y, z, t}] // Timing\)], "Input",
  CellLabel->"In[130]:="],

Cell[BoxData[
    \({0.07000000000000456`\ Second, {{x \[Rule] \(-\(44923\/48\)\), 
          y \[Rule] 306, z \[Rule] 3\/4, t \[Rule] \(-15\)}}}\)], "Output",
  CellLabel->"Out[130]="]
}, Open  ]],

Cell[TextData[{
  "With  ",
  StyleBox["LWPreprocessor->True", "MR"],
  ", the Loos-Weispfenning algorithm is used to eliminate both  ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and CAD is used to find a solution of the remaining system with two \
variables. For this example, this method is about three times slower than the \
default one."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWPreprocessor\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 1 && 
          5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 3 && 
          3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
          t\^2 + z\^2 \[LessEqual] z\ y, {x, y, z, t}] // Timing\)}], "Input",\

  CellLabel->"In[131]:="],

Cell[BoxData[
    \({0.22000000000001138`\ Second, {{x \[Rule] \(-\(845057\/1109760\)\), 
          y \[Rule] 54532\/24565, z \[Rule] 1, 
          t \[Rule] \(-\(17\/16\)\)}}}\)], "Output",
  CellLabel->"Out[132]="]
}, Open  ]],

Cell[TextData[{
  "With  ",
  StyleBox["LWPreprocessor->False", "MR"],
  ", the CAD algorithm is used to find a solution of the original system with \
four variables. For this example, this method is equally fast as the default \
one."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWPreprocessor\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 1 && 
          5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 3 && 
          3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
          t\^2 + z\^2 \[LessEqual] z\ y, {x, y, z, t}] // Timing\)}], "Input",\

  CellLabel->"In[133]:="],

Cell[BoxData[
    \({0.0699999999999841`\ Second, {{x \[Rule] \(-332\), y \[Rule] 306, 
          z \[Rule] 3\/4, t \[Rule] \(-15\)}}}\)], "Output",
  CellLabel->"Out[134]="]
}, Open  ]],

Cell[TextData[{
  "This example differs from the previous one only in that the last \
inequality was turned into an equation. With the default setting  ",
  StyleBox["LWPreprocessor->Automatic", "MR"],
  ", the Loos-Weispfenning algorithm is only used to eliminate  ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", and CAD is used to find a solution of the remaining system with three \
variables. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWPreprocessor\>" \[Rule] Automatic\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 1 && 
          5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 3 && 
          3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
          t\^2 + z\^2 == z\ y, {x, y, z, t}] // Timing\)}], "Input",
  CellLabel->"In[135]:="],

Cell[BoxData[
    \({0.20999999999999092`\ Second, {{x \[Rule] 
            1\/3\ \((3341\/256 - \(4117\ \@943\)\/4096)\), y \[Rule] 4, 
          z \[Rule] 23\/16, t \[Rule] \(-\(\@943\/16\)\)}}}\)], "Output",
  CellLabel->"Out[136]="]
}, Open  ]],

Cell[TextData[{
  "With  ",
  StyleBox["LWPreprocessor->True", "MR"],
  ", the Loos-Weispfenning algorithm is used to eliminate both  ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", and CAD is used to find a solution of the remaining system with two \
variables. For the revised example, this method is twice as fast as the \
default one."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWPreprocessor\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 1 && 
          5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 3 && 
          3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
          t\^2 + z\^2 == z\ y, {x, y, z, t}] // Timing\)}], "Input",
  CellLabel->"In[137]:="],

Cell[BoxData[
    \({0.0800000000000114`\ Second, {{x \[Rule] 
            1\/3\ \((2 + 5\ Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, 1] + 
                  3\ Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, 1]\^2 + \
\((\(-4\) - 4\ Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, 1]\^2 + 
                        4\ Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, \
1]\^3)\)/\((5\ Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, 1]\^2)\))\), 
          y \[Rule] \(\(-4\) - 4\ Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, \
1]\^2 + 4\ Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, 1]\^3\)\/\(5\ Root[4 + 4\ \
#1\^2 + #1\^3 + 5\ #1\^5 &, 1]\^3\), z \[Rule] 1, 
          t \[Rule] Root[4 + 4\ #1\^2 + #1\^3 + 5\ #1\^5 &, 1]}}}\)], "Output",\

  CellLabel->"Out[138]="]
}, Open  ]],

Cell[TextData[{
  "With  ",
  StyleBox["LWPreprocessor->False", "MR"],
  ", the CAD algorithm is used to find a solution of the original system with \
four variables. For the revised example, this is seven times slower than the \
default method."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWPreprocessor\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        2\ x + 3\ y\ z + 4\ z\^2\ t \[LessEqual] 1 && 
          5\ t\^3\ y + 7\ z\^4 - 4\ t\^3 + 4\ z\^2\ t\^2 \[LessEqual] 3 && 
          3\ x - 5\ t\ z\^2 - 3\ t\^2 - y\ z\ t \[GreaterEqual] 2 && 
          t\^2 + z\^2 == z\ y, {x, y, z, t}] // Timing\)}], "Input",
  CellLabel->"In[139]:="],

Cell[BoxData[
    \({1.4300000000000272`\ Second, {{x \[Rule] 0, y \[Rule] 11, z \[Rule] 3, 
          t \[Rule] \(-2\)\ \@6}}}\)], "Output",
  CellLabel->"Out[140]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<LWPreprocessor\>" \[Rule] Automatic\)];\)\)], "Input",
  CellLabel->"In[141]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["MultipleEquationalConstraints", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The ",
  StyleBox["MultipleEquationalConstraints", "MR"],
  " option specifies whether the CAD algorithm should use the unproven \
projection operator with multiple equational constraints suggested in [",
  ButtonBox["4",
    ButtonData:>"4",
    ButtonStyle->"Hyperlink"],
  "]. With the default setting ",
  StyleBox["False", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the somewhat larger projection operator proven correct in [",
  ButtonBox["11",
    ButtonData:>"11",
    ButtonStyle->"Hyperlink"],
  "]."
}], "Text"],

Cell[TextData[{
  "Here we find an instance satisfying the system using the CAD algorithm \
with ",
  StyleBox["MultipleEquationalConstraints", "MR"],
  " ",
  StyleBox["->True", "MR"],
  ". Even though the method used to find the solution was based on an \
unproven conjecture, the solution is proven to be correct, that is, it \
satisfies the input system."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<MultipleEquationalConstraints\>" \[Rule] 
            True\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[\(-1\) + a \[LessEqual] 0 && \(-1\) - a < 
            0 && \(-3\) - a + k\^2 + a\ k\^2 \[LessEqual] 0 && 
          v\_1\^2 \[Equal] 2 && 1 + a - v\_2\%2 \[Equal] 0 && 
          k + a\ k - v\_2\ v\_3 \[LessEqual] 
            0 && \(-k\) - a\ k - v\_2\ v\_3 \[LessEqual] 0 && 
          3 + a - v\_3\%2 \[Equal] 0 && 
          18 + 6\ a + 6\ a\^2 + 2\ a\^3 - 21\ k - 27\ a\ k - 7\ a\^2\ k - 
              a\^3\ k + 6\ k\^2 + 10\ a\ k\^2 + 2\ a\^2\ k\^2 - 
              2\ a\^3\ k\^2 + k\^3 + 3\ a\ k\^3 + 3\ a\^2\ k\^3 + 
              a\^3\ k\^3 - 3\ v\_1\ v\_4 + 6\ a\ v\_1\ v\_4 + 
              a\^2\ v\_1\ v\_4 - 4\ a\ k\ v\_1\ v\_4 - 
              4\ a\^2\ k\ v\_1\ v\_4 + k\^2\ v\_1\ v\_4 + 
              2\ a\ k\^2\ v\_1\ v\_4 + a\^2\ k\^2\ v\_1\ v\_4 \[Equal] 
            0 && \(-3\) - a + k\^2 + a\ k\^2 + v\_4\%2 \[Equal] 0 && 
          v\_1 > 0 && v\_2 \[GreaterEqual] 0 && v\_3 \[GreaterEqual] 0 && 
          v\_4 \[GreaterEqual] 0, {v\_1, k, a, v\_2, v\_3, v\_4}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[142]:="],

Cell[BoxData[
    \({0.1399999999999727`\ Second, {{v\_1 \[Rule] \@2, k \[Rule] 1, 
          a \[Rule] \(-\(7\/16\)\), v\_2 \[Rule] 3\/4, v\_3 \[Rule] \@41\/4, 
          v\_4 \[Rule] \@2}}}\)], "Output",
  CellLabel->"Out[143]="]
}, Open  ]],

Cell[TextData[{
  "With the default setting ",
  StyleBox["MultipleEquationalConstraints->False", "MR"],
  ", finding the solution of this system takes three times longer."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<MultipleEquationalConstraints\>" \[Rule] 
            False\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[\(-1\) + a \[LessEqual] 0 && \(-1\) - a < 
            0 && \(-3\) - a + k\^2 + a\ k\^2 \[LessEqual] 0 && 
          v\_1\^2 \[Equal] 2 && 1 + a - v\_2\%2 \[Equal] 0 && 
          k + a\ k - v\_2\ v\_3 \[LessEqual] 
            0 && \(-k\) - a\ k - v\_2\ v\_3 \[LessEqual] 0 && 
          3 + a - v\_3\%2 \[Equal] 0 && 
          18 + 6\ a + 6\ a\^2 + 2\ a\^3 - 21\ k - 27\ a\ k - 7\ a\^2\ k - 
              a\^3\ k + 6\ k\^2 + 10\ a\ k\^2 + 2\ a\^2\ k\^2 - 
              2\ a\^3\ k\^2 + k\^3 + 3\ a\ k\^3 + 3\ a\^2\ k\^3 + 
              a\^3\ k\^3 - 3\ v\_1\ v\_4 + 6\ a\ v\_1\ v\_4 + 
              a\^2\ v\_1\ v\_4 - 4\ a\ k\ v\_1\ v\_4 - 
              4\ a\^2\ k\ v\_1\ v\_4 + k\^2\ v\_1\ v\_4 + 
              2\ a\ k\^2\ v\_1\ v\_4 + a\^2\ k\^2\ v\_1\ v\_4 \[Equal] 
            0 && \(-3\) - a + k\^2 + a\ k\^2 + v\_4\%2 \[Equal] 0 && 
          v\_1 > 0 && v\_2 \[GreaterEqual] 0 && v\_3 \[GreaterEqual] 0 && 
          v\_4 \[GreaterEqual] 0, {v\_1, k, a, v\_2, v\_3, v\_4}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[144]:="],

Cell[BoxData[
    \({0.39999999999999547`\ Second, {{v\_1 \[Rule] \@2, k \[Rule] 1, 
          a \[Rule] \(-\(7\/16\)\), v\_2 \[Rule] 3\/4, v\_3 \[Rule] \@41\/4, 
          v\_4 \[Rule] \@2}}}\)], "Output",
  CellLabel->"Out[145]="]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["FindInstance", "MR"],
  " shows that the system has no solutions. Since it is using the CAD \
algorithm with ",
  StyleBox["MultipleEquationalConstraints", "MR"],
  " ",
  StyleBox["->True", "MR"],
  ", the correctness of the answer depends on an unproven conjecture."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<MultipleEquationalConstraints\>" \[Rule] 
            True\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        k \[NotEqual] 1 && \(-1\) + a \[LessEqual] 0 && \(-1\) - a < 
            0 && \(-3\) - a + k\^2 + a\ k\^2 \[LessEqual] 0 && 
          v\_1\^2 \[Equal] 2 && 1 + a - v\_2\%2 \[Equal] 0 && 
          k + a\ k - v\_2\ v\_3 \[LessEqual] 
            0 && \(-k\) - a\ k - v\_2\ v\_3 \[LessEqual] 0 && 
          3 + a - v\_3\%2 \[Equal] 0 && 
          18 + 6\ a + 6\ a\^2 + 2\ a\^3 - 21\ k - 27\ a\ k - 7\ a\^2\ k - 
              a\^3\ k + 6\ k\^2 + 10\ a\ k\^2 + 2\ a\^2\ k\^2 - 
              2\ a\^3\ k\^2 + k\^3 + 3\ a\ k\^3 + 3\ a\^2\ k\^3 + 
              a\^3\ k\^3 - 3\ v\_1\ v\_4 + 6\ a\ v\_1\ v\_4 + 
              a\^2\ v\_1\ v\_4 - 4\ a\ k\ v\_1\ v\_4 - 
              4\ a\^2\ k\ v\_1\ v\_4 + k\^2\ v\_1\ v\_4 + 
              2\ a\ k\^2\ v\_1\ v\_4 + a\^2\ k\^2\ v\_1\ v\_4 \[Equal] 
            0 && \(-3\) - a + k\^2 + a\ k\^2 + v\_4\%2 \[Equal] 0 && 
          v\_1 > 0 && v\_2 \[GreaterEqual] 0 && v\_3 \[GreaterEqual] 0 && 
          v\_4 \[GreaterEqual] 0, {v\_1, k, a, v\_2, v\_3, v\_4}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[146]:="],

Cell[BoxData[
    \({0.24000000000002727`\ Second, {}}\)], "Output",
  CellLabel->"Out[147]="]
}, Open  ]],

Cell[TextData[{
  "With the default setting ",
  StyleBox["MultipleEquationalConstraints", "MR"],
  " ",
  StyleBox["->False", "MR"],
  ", proving that the system has no solutions takes longer, but the answer is \
known to be correct."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<MultipleEquationalConstraints\>" \[Rule] 
            False\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        k \[NotEqual] 1 && \(-1\) + a \[LessEqual] 0 && \(-1\) - a < 
            0 && \(-3\) - a + k\^2 + a\ k\^2 \[LessEqual] 0 && 
          v\_1\^2 \[Equal] 2 && 1 + a - v\_2\%2 \[Equal] 0 && 
          k + a\ k - v\_2\ v\_3 \[LessEqual] 
            0 && \(-k\) - a\ k - v\_2\ v\_3 \[LessEqual] 0 && 
          3 + a - v\_3\%2 \[Equal] 0 && 
          18 + 6\ a + 6\ a\^2 + 2\ a\^3 - 21\ k - 27\ a\ k - 7\ a\^2\ k - 
              a\^3\ k + 6\ k\^2 + 10\ a\ k\^2 + 2\ a\^2\ k\^2 - 
              2\ a\^3\ k\^2 + k\^3 + 3\ a\ k\^3 + 3\ a\^2\ k\^3 + 
              a\^3\ k\^3 - 3\ v\_1\ v\_4 + 6\ a\ v\_1\ v\_4 + 
              a\^2\ v\_1\ v\_4 - 4\ a\ k\ v\_1\ v\_4 - 
              4\ a\^2\ k\ v\_1\ v\_4 + k\^2\ v\_1\ v\_4 + 
              2\ a\ k\^2\ v\_1\ v\_4 + a\^2\ k\^2\ v\_1\ v\_4 \[Equal] 
            0 && \(-3\) - a + k\^2 + a\ k\^2 + v\_4\%2 \[Equal] 0 && 
          v\_1 > 0 && v\_2 \[GreaterEqual] 0 && v\_3 \[GreaterEqual] 0 && 
          v\_4 \[GreaterEqual] 0, {v\_1, k, a, v\_2, v\_3, v\_4}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[148]:="],

Cell[BoxData[
    \({0.8600000000000182`\ Second, {}}\)], "Output",
  CellLabel->"Out[149]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ProjectAlgebraic", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The setting of the ",
  StyleBox["ProjectAlgebraic", "MR"],
  " option affects handling of algebraic number coefficients in the CAD \
algorithm. "
}], "Text"],

Cell[TextData[{
  "Algebraic numbers found in coefficients of the input system are replaced \
with new variables. The new variables are always put first in the variable \
ordering so that in the projection phase of the CAD algorithm they are \
eliminated last. When the current projection polynomials contain ",
  StyleBox["k+1",
    FontSlant->"Italic"],
  " variables with at least ",
  StyleBox["k",
    FontSlant->"Italic"],
  " first variables replacing algebraic number coefficients, we have a choice \
of whether or not to continue the projection phase. If we do not continue the \
projection phase, we can start the lifting phase extending the \
zero-dimensional cell in the first ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-variables on which each of the variables is equal to the corresponding \
algebraic number coefficient. If we choose to compute the last ",
  StyleBox["k",
    FontSlant->"Italic"],
  " projections, we may find in the lifting phase that the algebraic number \
coefficient corresponding to a variable being lifted lies between the roots \
of the projection polynomials. Hence for this variable we will be extending a \
one-dimensional cell with a rational number sample point. Thus there is a \
tradeoff between avoiding computation of the last ",
  StyleBox["k",
    FontSlant->"Italic"],
  " projections and avoiding algebraic number coordinates in sample points."
}], "Text"],

Cell[TextData[{
  "With ",
  StyleBox["ProjectAlgebraic->True", "MR"],
  ", the projection phase is continued for variables replacing algebraic \
number coefficients until there is one variable left. With ",
  StyleBox["ProjectAlgebraic->False", "MR"],
  ", the projection phase is stopped as soon as there is one variable left \
that does not replace an algebraic number coefficient. With the default \
setting  ",
  StyleBox["ProjectAlgebraic->Automatic", "MR"],
  ", the projection phase is stopped if there is at most one variable left \
that does not replace an algebraic number coefficient and there are at least \
three projection polynomials, or there is a projection polynomial of degree \
more than two in the projection variable."
}], "Text"],

Cell[TextData[{
  "With few high-degree algebraic number coefficients, equations, and \
inequalities in the system, ",
  StyleBox["ProjectAlgebraics->True", "MR"],
  " tends to be a better choice. (N is applied to the output for better \
readability.)"
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ProjectAlgebraic\>" \[Rule] True\)];\)\), "\n", 
    \(\(FindInstance[
          Root[#1\^9 - 11\ #1 + 7 &, 1]\ x\^2 - 
              Root[#1\^7 - 5\ #1 + 3 &, 1]\ y\^2 - x\ y \[Equal] 1, {x, y}, 
          Reals] // Timing\) // N\)}], "Input",
  CellLabel->"In[150]:="],

Cell[BoxData[
    \({0.01000000000000456`\ Second, {{x \[Rule] \(-1.`\), 
          y \[Rule] \(-1.7269814148931095`\)}}}\)], "Output",
  CellLabel->"Out[151]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ProjectAlgebraic\>" \[Rule] False\)];\)\), "\n", 
    \(\(FindInstance[
          Root[#1\^9 - 11\ #1 + 7 &, 1]\ x\^2 - 
              Root[#1\^7 - 5\ #1 + 3 &, 1]\ y\^2 - x\ y \[Equal] 1, {x, y}, 
          Reals] // Timing\) // N\)}], "Input",
  CellLabel->"In[152]:="],

Cell[BoxData[
    \({0.39000000000001367`\ Second, {{x \[Rule] \(-1.`\), 
          y \[Rule] \(-1.7269814148931093`\)}}}\)], "Output",
  CellLabel->"Out[153]="]
}, Open  ]],

Cell[TextData[{
  "With many low-degree algebraic number coefficients, equations, and \
inequalities in the system, ",
  StyleBox["ProjectAlgebraics->False", "MR"],
  " tends to be faster."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ProjectAlgebraic\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        x\^2 + y\^2 - \(\@2\) x - \(\@3\) y - \@5 < 0\  && x < \@7\ y^2, {x, 
          y}, Reals] // Timing\)}], "Input",
  CellLabel->"In[154]:="],

Cell[BoxData[
    \({6.730000000000027`\ Second, {{x \[Rule] 3\/4, 
          y \[Rule] \(-\(57\/64\)\)}}}\)], "Output",
  CellLabel->"Out[155]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ProjectAlgebraic\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        x\^2 + y\^2 - \(\@2\) x - \(\@3\) y - \@5 < 0\  && x < \@7\ y^2, {x, 
          y}, Reals] // Timing\)}], "Input",
  CellLabel->"In[156]:="],

Cell[BoxData[
    \({0.010000000000009113`\ Second, {{x \[Rule] 3\/4, 
          y \[Rule] \(-\(57\/64\)\)}}}\)], "Output",
  CellLabel->"Out[157]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["ProjectAlgebraics->Automatic", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " picks the faster method in the second example, but fails to pick the \
faster method in the first example."
}], "MathCaption"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ProjectAlgebraic\>" \[Rule] Automatic\)];\)\)], "Input",
  CellLabel->"In[158]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FindInstance[
          Root[#1\^9 - 11\ #1 + 7 &, 1]\ x\^2 - 
              Root[#1\^7 - 5\ #1 + 3 &, 1]\ y\^2 - x\ y \[Equal] 1, {x, y}, 
          Reals] // Timing\) // N\)], "Input",
  CellLabel->"In[159]:="],

Cell[BoxData[
    \({0.2900000000000182`\ Second, {{x \[Rule] \(-1.`\), 
          y \[Rule] \(-1.7269814148931093`\)}}}\)], "Output",
  CellLabel->"Out[159]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x\^2 + y\^2 - \(\@2\) x - \(\@3\) y - \@5 < 0\  && x < \@7\ y^2, {x, 
          y}, Reals] // Timing\)], "Input",
  CellLabel->"In[160]:="],

Cell[BoxData[
    \({0.009999999999997733`\ Second, {{x \[Rule] 3\/4, 
          y \[Rule] \(-\(57\/64\)\)}}}\)], "Output",
  CellLabel->"Out[160]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["QuadraticQE", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"QuadraticQE"],

Cell[TextData[{
  "The ",
  StyleBox["QuadraticQE", "MR"],
  " option specifies whether the quadratic case of Weispfenning's quantifier \
elimination by virtual substitution algorithm [",
  ButtonBox["22",
    ButtonData:>"22",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["23",
    ButtonData:>"23",
    ButtonStyle->"Hyperlink"],
  "] should be used to eliminate quantified variables that appear at most \
quadratically in all equations and inequalities in the system. The complexity \
of Weispfenning's algorithm depends very little on the number of free \
variables, unlike the complexity of the CAD algorithm that is doubly \
exponential in the number of all variables. Hence, it is definitely \
advantageous to use it when all quantifiers can be eliminated using the \
algorithm, there are many free variables present, and the quantifier-free \
version of the system does not need to be given in a solved form. On the \
other hand, eliminating a variable using Weispfenning's algorithm often \
significantly increases the size of the formula, so if ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " needs to apply CAD to the result or if the system contains few free \
variables using CAD on the original system may be faster. With the default \
setting ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the algorithm for ",
  StyleBox["Resolve", "MR"],
  " with no variables specified and with at least two parameters present, and \
for ",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Resolve", "MR"],
  " with at least three variables as long as elimination of one variable at \
most doubles the ",
  StyleBox["LeafCount", "MR"],
  " of the system. This criterion seems to work reasonably well, however for \
some examples it does not give the optimal choice of the algorithm. Changing \
the option value may allow to solve problems which otherwise take a very long \
time. With ",
  StyleBox["LinearQE->True", "MR"],
  ", Weispfenning's algorithm is used whenever there is a quadratic variable \
to eliminate, with ",
  StyleBox["LinearQE->False", "MR"],
  ", Weispfenning's algorithm is not used."
}], "Text"],

Cell[TextData[{
  StyleBox["Resolve", "MR"],
  " with no variables specified and with at least two parameters present uses \
Weispfenning's algorithm to eliminate  ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". The result is not solved for the parameters ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[\[Exists] \_x\((a\ x\^2 + b\ x + c)\)\ \((c\ x\^2 + b\ x + 
                  a)\) <= 0, Reals] // Timing\)], "Input",
  CellLabel->"In[161]:="],

Cell[BoxData[
    \({0.030000000000006827`\ Second, 
      a\ c < 0 || \((a \[Equal] 0 && a\ b + b\ c > 0)\) || \((c \[Equal] 0 && 
            a\ b + b\ c > 0)\) || \((a \[NotEqual] 
              0 && \(-b\^2\) + 4\ a\ c \[LessEqual] 0)\) || \((c \[NotEqual] 
              0 && \(-b\^2\) + 4\ a\ c \[LessEqual] 0)\) || \((a \[Equal] 0 && 
            b \[Equal] 0 && 
            a\^2 + b\^2 + c\^2 \[LessEqual] 0)\) || \((a \[Equal] 0 && 
            a + c \[Equal] 0 && 
            a\^2 + b\^2 + c\^2 \[LessEqual] 0)\) || \((a \[Equal] 0 && 
            b \[NotEqual] 0 && 
            a\^2\ b\^2\ c\^2 - a\ b\^2\ c\^3 + a\ c\^5 \[LessEqual] 
              0)\) || \((b \[Equal] 0 && c \[Equal] 0 && 
            a\^2 + b\^2 + c\^2 \[LessEqual] 0)\) || \((c \[Equal] 0 && 
            a + c \[Equal] 0 && 
            a\^2 + b\^2 + c\^2 \[LessEqual] 0)\) || \((b \[NotEqual] 0 && 
            c \[Equal] 0 && 
            a\^5\ c - a\^3\ b\^2\ c + a\^2\ b\^2\ c\^2 \[LessEqual] 
              0)\)}\)], "Output",
  CellLabel->"Out[161]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " by default uses CAD for this example. The result is solved for the \
parameters ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_x\((a\ x\^2 + b\ x + c)\)\ \((c\ x\^2 + b\ x + a)\) <= 
            0, {a, b, c}, Reals] // Timing\)], "Input",
  CellLabel->"In[162]:="],

Cell[BoxData[
    \({0.22999999999997728`\ Second, \((a < 0 && 
            c \[GreaterEqual] b\^2\/\(4\ a\))\) || 
        a \[Equal] 
          0 || \((a > 0 && c \[LessEqual] b\^2\/\(4\ a\))\)}\)], "Output",
  CellLabel->"Out[162]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["QuadraticQE->True", "MR"],
  ", ",
  StyleBox["Reduce", "MR"],
  " uses Weispfenning's algorithm to eliminate  ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and then CAD to solve the quantifier-free formula for the parameters ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c",
    FontSlant->"Italic"],
  ". In this example this is faster than the default method of using CAD from \
the beginning."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<QuadraticQE\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[\[Exists] \_x\((a\ x\^2 + b\ x + c)\)\ \((c\ x\^2 + b\ x + a)\) <= 
            0, {a, b, c}, Reals] // Timing\)}], "Input",
  CellLabel->"In[163]:="],

Cell[BoxData[
    \({0.14000000000001592`\ Second, \((a < 0 && 
            c \[GreaterEqual] b\^2\/\(4\ a\))\) || 
        a \[Equal] 
          0 || \((a > 0 && c \[LessEqual] b\^2\/\(4\ a\))\)}\)], "Output",
  CellLabel->"Out[164]="]
}, Open  ]],

Cell[TextData[{
  "For this system with three free variables Weispfenning's algorithm works \
much better than CAD. With ",
  StyleBox["QuadraticQE->False", "MR"],
  ", ",
  StyleBox["Resolve", "MR"],
  " does not finish in 1000 seconds."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<QuadraticQE\>" \[Rule] Automatic\)];\)\), "\[IndentingNewLine]", 
    \(Resolve[\[Exists] \_t\((\(-602\) + 528\ z - 222\ z\^2 - 410\ t - 
                  685\ z\ t + 427\ t\^2 + 422\ x + 5\ z\ x - 279\ t\ x - 
                  188\ x\^2 + 1000\ y - 704\ z\ y + 879\ t\ y - 179\ x\ y - 
                  689\ y\^2 \[Equal] 
                0 && \(-723\) - 380\ z + 323\ z\^2 - 964\ t - 749\ z\ t - 
                  9\ t\^2 + 497\ x - 191\ z\ x + 147\ t\ x + 815\ x\^2 + 
                  935\ y - 536\ z\ y - 558\ t\ y - 152\ x\ y + 
                  400\ y\^2 \[GreaterEqual] 0)\), Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[165]:="],

Cell[BoxData[
    \({0.019999999999972734`\ Second, \((93310576\ x + 312563284\ x\^2 + 
                619260202\ y - 174039637\ x\ y + 343049591\ y\^2 - 
                552659742\ z - 119285170\ x\ z - 72117355\ y\ z - 
                107223538\ z\^2 \[GreaterEqual] 
              438555086 && \(-491996\)\ x + 398945\ x\^2 - 2428780\ y - 
                184750\ x\ y + 1949453\ y\^2 - 340124\ z + 373690\ x\ z - 
                1798\ y\ z + 
                848401\ z\^2 \[GreaterEqual] \(-1196316\))\) || \
\((\(-491996\)\ x + 398945\ x\^2 - 2428780\ y - 184750\ x\ y + 
                1949453\ y\^2 - 340124\ z + 373690\ x\ z - 1798\ y\ z + 
                848401\ z\^2 \[GreaterEqual] \(-1196316\) && 
            86243585140\ x - 498040191089\ x\^2 + 109809123842\ x\^3 + 
                131969169211\ x\^4 - 484187889894\ y + 419393624593\ x\ y + 
                362278042647\ x\^2\ y - 133070811401\ x\^3\ y + 
                202349297280\ y\^2 - 82166879722\ x\ y\^2 + 
                289809046115\ x\^2\ y\^2 + 247824969889\ y\^3 - 
                76078568059\ x\ y\^3 + 19522904791\ y\^4 + 300933814382\ z + 
                137426763740\ x\ z - 651512554048\ x\^2\ z - 
                82614322010\ x\^3\ z - 106739496711\ y\ z - 
                29291657121\ x\ y\ z - 82755933843\ x\^2\ y\ z - 
                840794940583\ y\^2\ z + 38003381704\ x\ y\^2\ z - 
                469158313975\ y\^3\ z + 299057381894\ z\^2 + 
                126196261244\ x\ z\^2 - 114619700688\ x\^2\ z\^2 + 
                129231867162\ y\ z\^2 + 56929552463\ x\ y\ z\^2 - 
                439149714263\ y\^2\ z\^2 - 102928178270\ z\^3 + 
                26325949198\ x\ z\^3 - 153241487043\ y\ z\^3 - 
                107856045675\ z\^4 \[LessEqual] 19224638243)\)}\)], "Output",
  CellLabel->"Out[166]="]
}, Open  ]],

Cell[TextData[{
  "For this system with only one free variable ",
  StyleBox["Resolve", "MR"],
  " uses CAD."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Resolve[\[ForAll] \_{x, y}Implies[x > r && y > r, 
            x\^2\ \((1 + 2\ y)\)\^2 > y\^2\ \((1 + 2\ x\^2)\)], Reals] // 
      Timing\)], "Input",
  CellLabel->"In[167]:="],

Cell[BoxData[
    \({0.039999999999990904`\ Second, r \[GreaterEqual] 1\/\@2}\)], "Output",
  CellLabel->"Out[167]="]
}, Open  ]],

Cell["\<\
Weispfenning's algorithm is slower here and gives a more \
complicated result.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<QuadraticQE\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(\(Resolve[\[ForAll] \_{x, y}Implies[x > r && y > r, 
              x\^2\ \((1 + 2\ y)\)\^2 > y\^2\ \((1 + 2\ x\^2)\)], Reals] // 
        LeafCount\) // Timing\)}], "Input",
  CellLabel->"In[168]:="],

Cell[BoxData[
    \({0.1700000000000273`\ Second, 2711}\)], "Output",
  CellLabel->"Out[169]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<QuadraticQE\>" \[Rule] Automatic\)];\)\)], "Input",
  CellLabel->"In[170]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["QVSPreprocessor", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon",
  CellTags->"QVSPreprocessor"],

Cell[TextData[{
  "The ",
  StyleBox["QVSPreprocessor", "MR"],
  " option setting affects solving decision problems and instance finding. \
The option specifies whether the quadratic case of Weispfenning's quantifier \
elimination by virtual substitution algorithm [",
  ButtonBox["22",
    ButtonData:>"22",
    ButtonStyle->"Hyperlink"],
  ", ",
  ButtonBox["23",
    ButtonData:>"23",
    ButtonStyle->"Hyperlink"],
  "] should be used to eliminate variables that appear at most quadratically \
in all equations and inequalities before applying the CAD algorithm to the \
resulting system. The default setting is ",
  StyleBox["False", "MR"],
  " and the algorithm is not used. There are examples where using \
Weispfenning's algorithm as a preprocessor significantly helps the \
performance, and there are examples where using the preprocessor \
significantly hurts the performance. It seems that the preprocessor tends to \
help in examples with many variables and where instances exist. With ",
  StyleBox["QVSPreprocessor", "MR"],
  " ",
  StyleBox["->True", "MR"],
  ", Weispfenning's algorithm is used each time there is a quadratic \
variable. With ",
  StyleBox["QVSPreprocessor", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the algorithm for systems with at least four variables. "
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " finds a solution using Weispfenning's algorithm as a preprocessor. \
Without the preprocessor this example takes 470 seconds."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<QVSPreprocessor\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[\(-11\) - 909\ y\ z - 
              462\ y\^2\ z + \((657 - 471\ y\^3 + 501\ z - 48\ x\ z)\)\ t + 
              t\^2 \[Equal] 0 && 
          258 + 223\ x\^2\ y - 544\ y\^3 + 571\ z\^2 + 
              38\ y\ z\^2 + \((\(-798\) + 79\ x\^2\ y + 214\ y\^2 - 
                    828\ x\^2\ z - 392\ z\^2)\)\ t + t\^2 \[GreaterEqual] 
            0, {x, y, z, t}, Reals] // Timing\)}], "Input",
  CellLabel->"In[171]:="],

Cell[BoxData[
    \({0.05999999999998182`\ Second, {{x \[Rule] 1, 
          y \[Rule] 1\/308\ \((\(-303\) + \@\(282203\/3\))\), 
          z \[Rule] \(-1\), t \[Rule] 0}}}\)], "Output",
  CellLabel->"Out[172]="]
}, Open  ]],

Cell[TextData[{
  "This uses CAD to show that there are no solutions. With ",
  StyleBox["QVSPreprocessor->True", "MR"],
  " this example does not finish in 1000 seconds, due to complexity of \
computing ",
  StyleBox["LogicalExpand", "MR"],
  " for the generated large logical formulas."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \
\("\<QVSPreprocessor\>" \[Rule] False\)]; 
    FindInstance[\(! \((a < 0 || b < 0 || c < 0 || d < 0 || e < 0 || f < 0 || 
              a\^2 + b\^2 > e\^2 || c\^2 + d\^2 > f\^2 || 
              a\ c + b\ d \[LessEqual] e\ f)\)\), {a, b, c, d, e, f}, Reals] // 
      Timing\)], "Input",
  CellLabel->"In[173]:="],

Cell[BoxData[
    \({0.06999999999998863`\ Second, {}}\)], "Output",
  CellLabel->"Out[173]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ReducePowers", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "For any variable ",
  StyleBox["x",
    FontSlant->"Italic"],
  " in the input to the CAD algorithm, if all powers of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " appearing in the system are integer multiples of an integer ",
  StyleBox["k",
    FontSlant->"Italic"],
  ",  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " replaces ",
  Cell[BoxData[
      \(TraditionalForm\`x\^k\)]],
  " in the input system with a new variable, runs the CAD on the new system, \
and then resolves the answer so that it is expressed in terms of the original \
variables. Setting ",
  StyleBox["ReducePowers->False", "MR"],
  " turns off this shortcut. With ",
  StyleBox["ReducePowers->False", "MR"],
  ", the algebraic functions appearing as cell bounds in the output of the \
CAD algorithm are always rational functions, quadratic radical expressions, \
or ",
  StyleBox["Root", "MR"],
  " objects. With the default setting ",
  StyleBox["ReducePowers->True", "MR"],
  ", they may in addition be ",
  Cell[BoxData[
      \(TraditionalForm\`e\^\(1/n\)\)]],
  " for any of the previous expressions ",
  StyleBox["e",
    FontSlant->"Italic"],
  ",",
  StyleBox[" ",
    FontSlant->"Italic"],
  "or ",
  Cell[BoxData[
      \(TraditionalForm\`Root[a  #\^n - e &, 1]\)]],
  " for some integer ",
  StyleBox["a",
    FontSlant->"Italic"],
  ",",
  " and a rational function or a quadratic radical expression ",
  StyleBox["e",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "With the default setting ",
  StyleBox["ReducePowers->True", "MR"],
  ", the CAD algorithm solves a quadratic equation in variables replacing ",
  Cell[BoxData[
      \(TraditionalForm\`x\^7\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\^5\)]],
  ", and then the result is represented in terms of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  ". The result contains ",
  StyleBox["Root", "MR"],
  " objects with quadratic radical expressions inside."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[x\^14 + 3\ x\^7\ y\^5 - 5\ y\^10 \[Equal] 1, {x, y}, Reals] // 
      Timing\)], "Input",
  CellLabel->"In[174]:="],

Cell[BoxData[
    \({0.00999999999999543`\ Second, \((x < \(-\((5\/29)\)\^\(1/14\)\)\ \
2\^\(1/7\) && \((y \[Equal] 
                  Root[\(-3\)\ x\^7 + \@\(\(-20\) + 29\ x\^14\) + 
                        10\ #1\^5 &, 1] || 
                y \[Equal] 
                  Root[\(-3\)\ x\^7 - \@\(\(-20\) + 29\ x\^14\) + 
                        10\ #1\^5 &, 
                    1])\))\) || \((x \[Equal] \(-\((5\/29)\)\^\(1/14\)\)\ 2\^\
\(1/7\) && y \[Equal] 
              Root[\(-3\)\ x\^7 + \@\(\(-20\) + 29\ x\^14\) + 10\ #1\^5 &, 
                1])\) || \((x \[Equal] \((5\/29)\)\^\(1/14\)\ 2\^\(1/7\) && 
            y \[Equal] 
              Root[\(-3\)\ x\^7 + \@\(\(-20\) + 29\ x\^14\) + 10\ #1\^5 &, 
                1])\) || \((x > \((5\/29)\)\^\(1/14\)\ 2\^\(1/7\) && \((y \
\[Equal] Root[\(-3\)\ x\^7 + \@\(\(-20\) + 29\ x\^14\) + 10\ #1\^5 &, 1] || 
                y \[Equal] 
                  Root[\(-3\)\ x\^7 - \@\(\(-20\) + 29\ x\^14\) + 
                        10\ #1\^5 &, 1])\))\)}\)], "Output",
  CellLabel->"Out[174]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["ReducePowers->True", "MR"],
  ", the CAD algorithm solves the original 14th degree equation that takes \
several times longer. The result contains only ",
  StyleBox["Root", "MR"],
  " objects with polynomial expressions inside."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ReducePowers\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[x\^14 + 3\ x\^7\ y\^5 - 5\ y\^10 \[Equal] 1, {x, y}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[175]:="],

Cell[BoxData[
    \({0.08000000000000454`\ Second, \((x < 
              Root[\(-20\) + 29\ #1\^14 &, 
                1] && \((y \[Equal] 
                  Root[1 - x\^14 - 3\ x\^7\ #1\^5 + 5\ #1\^10 &, 1] || 
                y \[Equal] 
                  Root[1 - x\^14 - 3\ x\^7\ #1\^5 + 5\ #1\^10 &, 
                    2])\))\) || \((x \[Equal] 
              Root[\(-20\) + 29\ #1\^14 &, 1] && 
            y \[Equal] Root[\(-9\) + 145\ #1\^10 &, 1])\) || \((x \[Equal] 
              Root[\(-20\) + 29\ #1\^14 &, 2] && 
            y \[Equal] 
              Root[\(-9\) + 145\ #1\^10 &, 
                2])\) || \((Root[\(-20\) + 29\ #1\^14 &, 2] < x < 
              1 && \((y \[Equal] 
                  Root[1 - x\^14 - 3\ x\^7\ #1\^5 + 5\ #1\^10 &, 1] || 
                y \[Equal] 
                  Root[1 - x\^14 - 3\ x\^7\ #1\^5 + 5\ #1\^10 &, 
                    2])\))\) || \((x \[Equal] 
              1 && \((y \[Equal] 0 || 
                y \[Equal] Root[\(-3\) + 5\ #1\^5 &, 1])\))\) || \((x > 
              1 && \((y \[Equal] 
                  Root[1 - x\^14 - 3\ x\^7\ #1\^5 + 5\ #1\^10 &, 1] || 
                y \[Equal] 
                  Root[1 - x\^14 - 3\ x\^7\ #1\^5 + 5\ #1\^10 &, 
                    2])\))\)}\)], "Output",
  CellLabel->"Out[176]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["RootReduced", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "For systems with equational constraints generating a zero-dimensional \
ideal ",
  StyleBox["I",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a variant of the CAD algorithm that finds projection polynomials \
using Gr\[ODoubleDot]bner basis methods. If the lexicographic order Gr\
\[ODoubleDot]bner basis of ",
  StyleBox["I",
    FontSlant->"Italic"],
  " contains linear polynomials with constant coefficients in every variable \
but the last one (which is true \[OpenCurlyDoubleQuote]generically\
\[CloseCurlyDoubleQuote]), then all coordinates of solutions are easily \
represented as polynomials in the last coordinate. Setting ",
  StyleBox["RootReduced", "MR"],
  " to ",
  StyleBox["True", "MR"],
  ", causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to represent each coordinate as a single numeric ",
  StyleBox["Root", "MR"],
  " object. Computing this reduced representation often takes much longer \
than solving the system."
}], "Text"],

Cell[TextData[{
  "By default, we get the value of ",
  StyleBox["y",
    FontSlant->"Italic"],
  " expressed in terms of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
        y\^5 - 3\ y\^2 + 2\ y + x\^5 + 7\ x + 4 \[Equal] 0 && 
          y\^2 + y - x\^5 - 3\ x - 11 \[Equal] 0, {x, y}, Reals] // 
      Timing\)], "Input",
  CellLabel->"In[177]:="],

Cell[BoxData[
    \({0.009999999999972725`\ Second, 
      x \[Equal] 
          Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 
                4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 
                5940\ #1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 
                2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 
                90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1] && 
        y \[Equal] 
          106736486\/182019 + \(1296051\ x\)\/1462 + \(66665810\ \
x\^2\)\/182019 - \(969563\ x\^3\)\/8466 - \(24035081\ x\^4\)\/364038 + \
\(96373723\ x\^5\)\/364038 + \(54920533\ x\^6\)\/182019 + \(25145123\ \
x\^7\)\/364038 - \(10853975\ x\^8\)\/182019 - \(1489646\ x\^9\)\/182019 + \
\(8836411\ x\^10\)\/182019 + \(4385547\ x\^11\)\/121346 + \(93708\ \
x\^12\)\/60673 - \(530532\ x\^13\)\/60673 + \(69480\ x\^14\)\/60673 + \(85501\
\ x\^15\)\/21414 + \(305971\ x\^16\)\/182019 - \(3130\ x\^17\)\/10707 - \
\(5092\ x\^18\)\/10707 + \(2072\ x\^19\)\/10707 + \(43705\ x\^20\)\/364038 + \
\(3719\ x\^21\)\/182019 - \(2194\ x\^22\)\/182019 - \(1492\ x\^23\)\/182019 + \
\(1208\ x\^24\)\/182019}\)], "Output",
  CellLabel->"Out[177]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["Backsubstitution\[Rule]True", "MR"],
  ", we get a numeric value of ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", but the representation of the value is large."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
        y\^5 - 3\ y\^2 + 2\ y + x\^5 + 7\ x + 4 \[Equal] 0 && 
          y\^2 + y - x\^5 - 3\ x - 11 \[Equal] 0, {x, y}, Reals, 
        Backsubstitution \[Rule] True] // Timing\)], "Input",
  CellLabel->"In[178]:="],

Cell[BoxData[
    \({0.009999999999981801`\ Second, 
      x \[Equal] 
          Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 
                4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 
                5940\ #1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 
                2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 
                90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1] && 
        y \[Equal] \(1\/364038\) \((213472972 + 
                322716699\ Root[
                    156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 
                        4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 
                        32790\ #1\^7 + 5940\ #1\^8 + 405\ #1\^9 + 
                        13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 
                        270\ #1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 
                        90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1] + 
                133331620\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^2 - 
                41691209\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^3 - 
                24035081\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^4 + 
                96373723\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^5 + 
                109841066\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^6 + 
                25145123\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^7 - 
                21707950\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^8 - 
                2979292\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\
\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 \
+ 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + \
1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, \
1]\^9 + 17672822\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + \
4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + 405\ \
#1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\
\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1]\^10 \
+ 13156641\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 4455\ \
#1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + 405\ #1\^9 \
+ 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\^15 + \
660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1]\^11 + 
                562248\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^12 - 
                3183192\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\
\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 \
+ 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + \
1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, \
1]\^13 + 416880\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + \
4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + 405\ \
#1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\
\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1]\^14 \
+ 1453517\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 4455\ #1\
\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + 405\ #1\^9 + \
13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\^15 + \
660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1]\^15 + 
                611942\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^16 - 
                106420\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^17 - 
                173128\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^18 + 
                70448\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^19 + 
                43705\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ \
#1\^3 + 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ \
#1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ \
#1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + \
#1\^25 &, 1]\^20 + 
                7438\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 \
+ 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + \
405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + \
1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, \
1]\^21 - 4388\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 4455\
\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + 405\ \
#1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\
\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1]\^22 \
- 2984\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 4455\ #1\^4 \
+ 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + 405\ #1\^9 + \
13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\^15 + \
660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1]\^23 + 
                2416\ Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 \
+ 4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 5940\ #1\^8 + \
405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 2970\ #1\^12 + 270\ #1\^13 + \
1210\ #1\^15 + 660\ #1\^16 + 90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, \
1]\^24)\)}\)], "Output",
  CellLabel->"Out[178]="]
}, Open  ]],

Cell[TextData[{
  "Setting ",
  StyleBox["RootReduced->True", "MR"],
  " causes ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to represent the value of ",
  StyleBox["y",
    FontSlant->"Italic"],
  " as a single ",
  StyleBox["Root", "MR"],
  " object. However, the computation takes ten times longer."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<RootReduced\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[
        y\^5 - 3\ y\^2 + 2\ y + x\^5 + 7\ x + 4 \[Equal] 0 && 
          y\^2 + y - x\^5 - 3\ x - 11 \[Equal] 0, {x, y}, Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[179]:="],

Cell[BoxData[
    \({0.1200000000000091`\ Second, 
      x \[Equal] 
          Root[156956 + 220462\ #1 + 120941\ #1\^2 + 32850\ #1\^3 + 
                4455\ #1\^4 + 72765\ #1\^5 + 80162\ #1\^6 + 32790\ #1\^7 + 
                5940\ #1\^8 + 405\ #1\^9 + 13281\ #1\^10 + 10910\ #1\^11 + 
                2970\ #1\^12 + 270\ #1\^13 + 1210\ #1\^15 + 660\ #1\^16 + 
                90\ #1\^17 + 55\ #1\^20 + 15\ #1\^21 + #1\^25 &, 1] && 
        y \[Equal] 
          Root[\(-33447\) + 39343\ #1 - 55392\ #1\^2 + 54390\ #1\^3 - 
                43015\ #1\^4 + 38216\ #1\^5 - 32870\ #1\^6 + 31390\ #1\^7 - 
                22700\ #1\^8 + 14085\ #1\^9 - 9582\ #1\^10 + 6610\ #1\^11 - 
                5310\ #1\^12 + 2870\ #1\^13 - 1380\ #1\^14 + 850\ #1\^15 - 
                500\ #1\^16 + 370\ #1\^17 - 120\ #1\^18 + 40\ #1\^19 - 
                35\ #1\^20 + 15\ #1\^21 - 10\ #1\^22 + #1\^25 &, 
            1]}\)], "Output",
  CellLabel->"Out[180]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<RootReduced\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[181]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ThreadOr", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The ",
  StyleBox["ThreadOr", "MR"],
  " option specifies how the identity"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(\(\[Exists] \_\(x\_1,  ... , x\_n\)\((\(\(\(\
\[CapitalPhi]\_1\)\(\[Or]\)\) ... \) \[Or] \[CapitalPhi]\_k)\)\ \
\[DoubleLongLeftRightArrow]\ \(\[Exists] \_\(x\_1,  ... , x\_n\)\[CapitalPhi]\
\_1\)\)\(\[Or]\)\) ... \) \[Or] \[Exists] \_\(x\_1,  ... , \
x\_n\)\[CapitalPhi]\_k\)], "NumberedEquation",
  CellTags->"ExistsOr"],

Cell[TextData[{
  "should be used in the decision algorithm (",
  StyleBox["Reduce", "MR"],
  " and ",
  StyleBox["Resolve", "MR"],
  " for systems containing no free variables or parameters), ",
  StyleBox["FindInstance", "MR"],
  ", and quantifier elimination (",
  StyleBox["Resolve", "MR"],
  " with no variables specified). With the default setting  ",
  StyleBox["ThreadOr->True", "MR"],
  ", the identity (",
  ButtonBox["8",
    ButtonData:>"ExistsOr",
    ButtonStyle->"Hyperlink"],
  ") is used before attempting any solution algorithms. With ",
  StyleBox["ThreadOr->False,", "MR"],
  " the identity (",
  ButtonBox["8",
    ButtonData:>"ExistsOr",
    ButtonStyle->"Hyperlink"],
  ") may be used by algorithms that require using it (for instance, the \
Simplex algorithm), but will not be used by algorithms that do not require \
using it (for instance, the CAD algorithm)."
}], "Text"],

Cell[TextData[{
  "Here ",
  StyleBox["Reduce", "MR"],
  " finds an instance satisfying the first simpler term of ",
  StyleBox["Or", "MR"],
  ", and hence avoids dealing with the second, more complicated, term."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[\[Exists] \_{x, y, z}\((x + y + z \[GreaterEqual] 
                0 || \((x\^5 - 3\ x\ y\^4\ z + 17\ x\^3\ z\^2 - 
                      11\ y \[Equal] 0 && 
                  x\^2 + y\^2 + z\^2 \[LessEqual] 1)\))\), Reals] // 
      Timing\)], "Input",
  CellLabel->"In[182]:="],

Cell[BoxData[
    \({4.551914400963142`*^-15\ Second, True}\)], "Output",
  CellLabel->"Out[182]="]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["ThreadOr->False", "MR"],
  ", ",
  StyleBox["Reduce", "MR"],
  " needs to run a CAD-based decision algorithm on the whole system."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ThreadOr\>" \[Rule] False\)];\)\), "\[IndentingNewLine]", 
    \(Reduce[\[Exists] \_{x, y, z}\((x + y + z \[GreaterEqual] 
                0 || \((x\^5 - 3\ x\ y\^4\ z + 17\ x\^3\ z\^2 - 
                      11\ y \[Equal] 0 && 
                  x\^2 + y\^2 + z\^2 \[LessEqual] 1)\))\), Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[183]:="],

Cell[BoxData[
    \({0.5200000000000046`\ Second, True}\)], "Output",
  CellLabel->"Out[184]="]
}, Open  ]],

Cell[TextData[{
  "This system has no solutions and so with ",
  StyleBox["ThreadOr->True", "MR"],
  " ",
  StyleBox["Reduce", "MR"],
  " needs to run a CAD-based decision algorithm on each of the terms. "
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ThreadOr\>" \[Rule] True\)];\)\), "\n", 
    \(Reduce[\[Exists] \_{x, y, z}\((\((x\^2 + y\^2 + z\^2 < 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 < 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 \[GreaterEqual] 
                    1)\) || \((x\^2 + y\^2 + z\^2 < 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 < 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 \[GreaterEqual] 
                    1)\) || \((x\^2 + y\^2 + z\^2 \[GreaterEqual] 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 < 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 < 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 \[GreaterEqual] 
                    1)\) || \((x\^2 + y\^2 + z\^2 < 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 < 
                    1)\) || \((x\^2 + y\^2 + z\^2 \[GreaterEqual] 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 < 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 < 
                    1)\) || \((x\^2 + y\^2 + z\^2 \[GreaterEqual] 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 < 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 < 1)\))\), Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[185]:="],

Cell[BoxData[
    \({0.9800000000000227`\ Second, False}\)], "Output",
  CellLabel->"Out[186]="]
}, Open  ]],

Cell[TextData[{
  "Since all six terms of ",
  StyleBox["Or", "MR"],
  " involve exactly the same polynomials, running a CAD-based decision \
algorithm on the whole expression consists of very similar computations as \
running a CAD-based decision algorithm on one of the terms. In this case the \
computation with ",
  StyleBox["ThreadOr->False", "MR"],
  " is faster."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ThreadOr\>" \[Rule] False\)];\)\), "\n", 
    \(Reduce[\[Exists] \_{x, y, z}\((\((x\^2 + y\^2 + z\^2 < 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 < 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 \[GreaterEqual] 
                    1)\) || \((x\^2 + y\^2 + z\^2 < 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 < 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 \[GreaterEqual] 
                    1)\) || \((x\^2 + y\^2 + z\^2 \[GreaterEqual] 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 < 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 < 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 \[GreaterEqual] 
                    1)\) || \((x\^2 + y\^2 + z\^2 < 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 < 
                    1)\) || \((x\^2 + y\^2 + z\^2 \[GreaterEqual] 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 < 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 < 
                    1)\) || \((x\^2 + y\^2 + z\^2 \[GreaterEqual] 
                    1 && \((x - 2)\)\^2 + y\^2 + z\^2 \[GreaterEqual] 1 && 
                  x\^2 + \((y - 2)\)\^2 + z\^2 < 1 && 
                  x\^2 + y\^2 + \((z - 2)\)\^2 < 1)\))\), Reals] // 
      Timing\)}], "Input",
  CellLabel->"In[187]:="],

Cell[BoxData[
    \({0.25000000000000455`\ Second, False}\)], "Output",
  CellLabel->"Out[188]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ThreadOr\>" \[Rule] True\)];\)\)], "Input",
  CellLabel->"In[189]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ZengDecision", "MR",
  FontFamily->"Helvetica",
  FontWeight->"Bold"]], "SubsubsectionIcon"],

Cell[TextData[{
  "The option ",
  StyleBox["ZengDecision", "MR"],
  " specifies whether ",
  StyleBox["Mathematica", "TI"],
  " should use the algorithm by G.X. Zeng and X.N. Zeng [",
  ButtonBox["18",
    ButtonData:>"18",
    ButtonStyle->"Hyperlink"],
  "]. The algorithm applies to decision problems with systems that consist of \
a single strict inequality. There are examples for which the algorithm \
performs better than the strict inequality variant of the CAD algorithm \
described in [",
  ButtonBox["13",
    ButtonData:>"13",
    ButtonStyle->"Hyperlink"],
  "].  However, for randomly chosen inequalities, it seems to perform worse; \
therefore, it is not used by default. Here is an example from [",
  ButtonBox["18",
    ButtonData:>"18",
    ButtonStyle->"Hyperlink"],
  "] that runs faster with ",
  StyleBox["ZengDecision->True", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindInstance[
        x\^4 + y\^4 + z\^4 + w\^4 - 5\ x\ y\ z\ w + x\^2 + y\^2 + z\^2 + 
            w\^2 + 1 < 0, {x, y, z, w}, Reals] // Timing\)], "Input",
  CellLabel->"In[190]:="],

Cell[BoxData[
    \({5.560000000000005`\ Second, {{x \[Rule] \(-5\), y \[Rule] \(-5\), 
          z \[Rule] \(-6\), w \[Rule] \(-4\)}}}\)], "Output",
  CellLabel->"Out[190]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ZengDecision\>" \[Rule] True\)];\)\), "\[IndentingNewLine]", 
    \(FindInstance[
        x\^4 + y\^4 + z\^4 + w\^4 - 5\ x\ y\ z\ w + x\^2 + y\^2 + z\^2 + 
            w\^2 + 1 < 0, {x, y, z, w}, Reals] // Timing\)}], "Input",
  CellLabel->"In[191]:="],

Cell[BoxData[
    \({0.3900000000000023`\ Second, {{x \[Rule] \(-5\), y \[Rule] \(-5\), 
          z \[Rule] \(-6\), w \[Rule] \(-4\)}}}\)], "Output",
  CellLabel->"Out[192]="]
}, Open  ]],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<InequalitySolvingOptions\>" \[Rule] \("\
\<ZengDecision\>" \[Rule] False\)];\)\)], "Input",
  CellLabel->"In[193]:="]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Section",
  CellTags->{"t:29", "c:29"}],

Cell[TextData[{
  "[1] B. F. Caviness and J. R. Johnson, eds., ",
  StyleBox["Quantifier Elimination and Cylindrical Algebraic Decomposition",
    FontSlant->"Italic"],
  ".",
  StyleBox[" ",
    FontSlant->"Italic"],
  "Texts and Monographs in Symbolic Computation",
  ", New York: Springer-Verlag, 1998."
}], "Text",
  CellTags->"1"],

Cell[TextData[{
  "[2] A. Tarski, ",
  StyleBox["A Decision Method for Elementary Algebra and Geometry",
    FontSlant->"Italic"],
  ", Berkeley: University of California Press, 1951."
}], "Text",
  CellTags->"2"],

Cell[TextData[{
  "[3] S. \[CapitalLSlash]ojasiewicz, ",
  StyleBox["Ensembles semi-analytiques, ",
    FontSlant->"Italic"],
  "Bures-sur-Yvette:",
  StyleBox[" ",
    FontSlant->"Italic"],
  "Inst. Hautes \[CapitalEAcute]tudes Sci.. 1964."
}], "Text",
  CellTags->"3"],

Cell[TextData[{
  "[4] G. E. Collins, \[OpenCurlyDoubleQuote]",
  "Quantifier Elimination for the Elementary Theory of Real Closed Fields by \
Cylindrical Algebraic Decomposition",
  ",\[CloseCurlyDoubleQuote] ",
  StyleBox["Lecture Notes in Computer Science", "TI"],
  ", ",
  StyleBox["33", "TB"],
  ", 1975 pp. 134-183."
}], "Text",
  CellTags->"4"],

Cell[TextData[{
  "[5] H. Hong, \[OpenCurlyDoubleQuote]An Improvement of the Projection \
Operator in Cylindrical Algebraic Decomposition,\[CloseCurlyDoubleQuote]  \
in",
  StyleBox[" Issac ",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]",
  StyleBox["90: Proceedings of the International Symposium on Symbolic and \
Algebraic Computation",
    FontSlant->"Italic"],
  " (M. Nagata, ed.), New York: ACM, 1990 pp. 261-264."
}], "Text",
  CellTags->"5"],

Cell[TextData[{
  "[6] S. McCallum,",
  StyleBox[" ",
    FontSlant->"Italic"],
  "\[OpenCurlyDoubleQuote]An Improved Projection for Cylindrical Algebraic \
Decomposition of Three Dimensional Space,\[CloseCurlyDoubleQuote] ",
  StyleBox["J. Symb. Comput.", "TI"],
  ", ",
  StyleBox["5 ",
    FontWeight->"Bold"],
  "(1/2), 1988 pp. 141-161."
}], "Text",
  CellTags->"6"],

Cell[TextData[{
  "[7] S. McCallum, \[OpenCurlyDoubleQuote]An Improved Projection for \
Cylindrical Algebraic Decomposition,\[CloseCurlyDoubleQuote] ",
  StyleBox["Quantifier Elimination and Cylindrical Algebraic Decomposition",
    FontSlant->"Italic"],
  ".",
  StyleBox[" ",
    FontSlant->"Italic"],
  "Texts and Monographs in Symbolic Computation (B. F. Caviness and J. R. \
Johnson, eds.), New York: Springer-Verlag, 1998 pp. 242-268."
}], "Text",
  CellTags->"7"],

Cell[TextData[{
  "[8] C. W. Brown, \[OpenCurlyDoubleQuote]Improved Projection for \
Cylindrical Algebraic Decomposition,\[CloseCurlyDoubleQuote] ",
  StyleBox["J. Symb. Comput.", "TI"],
  ", ",
  StyleBox["32 ",
    FontWeight->"Bold"],
  "(5)",
  ", 2001 pp. 447-465."
}], "Text",
  CellTags->"8"],

Cell[TextData[{
  "[9] G. E. Collins, \[OpenCurlyDoubleQuote]Quantifier Elimination by \
Cylindrical Algebraic Decomposition--Twenty Years of Progress,\
\[CloseCurlyDoubleQuote] ",
  StyleBox["Quantifier Elimination and Cylindrical Algebraic Decomposition",
    FontSlant->"Italic"],
  ".",
  StyleBox[" ",
    FontSlant->"Italic"],
  "Texts and Monographs in Symbolic Computation (B. F. Caviness and J. R. \
Johnson, eds.), New York: Springer-Verlag, 1998 pp. 8-23."
}], "Text",
  CellTags->"9"],

Cell[TextData[{
  "[10] S. McCallum, \[OpenCurlyDoubleQuote]On Projection in CAD-Based \
Quantifier Elimination with Equational Constraint,\[CloseCurlyDoubleQuote] \
in",
  StyleBox[" Issac ",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]",
  StyleBox["99: Proceedings of the International Symposium on Symbolic and \
Algebraic Computation",
    FontSlant->"Italic"],
  " (Sam Dooley, ed.), New York: ACM, 1999 pp. 145-149."
}], "Text",
  CellTags->"10"],

Cell[TextData[{
  "[11] S. McCallum, \[OpenCurlyDoubleQuote]On Propagation of Equational \
Constraints in CAD-Based Quantifier Elimination,\[CloseCurlyDoubleQuote] in",
  StyleBox[" Issac 2001: Proceedings of the International Symposium on \
Symbolic and Algebraic Computation",
    FontSlant->"Italic"],
  ", New York: ACM, 2001 pp. 223-231."
}], "Text",
  CellTags->"11"],

Cell[TextData[{
  "[12] A. Strzebonski, \[OpenCurlyDoubleQuote]An Algorithm for Systems of \
Strong Polynomial Inequalities,\[CloseCurlyDoubleQuote] ",
  StyleBox["The Mathematica Journal",
    FontSlant->"Italic"],
  ", ",
  StyleBox["4",
    FontWeight->"Bold"],
  " (4), 1994 pp. 74-77."
}], "Text",
  CellTags->"12"],

Cell[TextData[{
  "[13] A. Strzebonski, \[OpenCurlyDoubleQuote]Solving Systems of Strict \
Polynomial Inequalities,\[CloseCurlyDoubleQuote] ",
  StyleBox["J. Symb. Comput.", "TI"],
  ", ",
  StyleBox["29 ",
    FontWeight->"Bold"],
  "(3), 2000 pp. 471-480."
}], "Text",
  CellTags->"13"],

Cell[TextData[{
  "[14] A. Strzebonski, Cylindrical Algebraic Decomposition Using Validated \
Numerics. Paper presented at the ACA 2002 Session on Symbolic-Numerical \
Methods in Computational Science, Volos, Greece. Notebook with the conference \
talk available at ",
  ButtonBox["members.wolfram.com/adams",
    ButtonData:>{
      URL[ "http://members.wolfram.com/adams"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"14"],

Cell[TextData[{
  "[15] R. Loos and V. Weispfenning, \[OpenCurlyDoubleQuote]Applying Linear \
Quantifier Elimination,\[CloseCurlyDoubleQuote] ",
  StyleBox["Comput. J.", "TI"],
  ", ",
  StyleBox["36",
    FontWeight->"Bold"],
  " (5), 1993 pp. 450-461."
}], "Text",
  CellTags->"15"],

Cell[TextData[{
  "[16] A. Strzebonski, \[OpenCurlyDoubleQuote]A Real Polynomial Decision \
Algorithm Using Arbitrary-Precision Floating Point Arithmetic,\
\[CloseCurlyDoubleQuote]  ",
  StyleBox["Reliable Comput.",
    FontSlant->"Italic"],
  ", ",
  StyleBox["5",
    FontWeight->"Bold"],
  " (3), 1999 pp. 337-346; ",
  StyleBox["Developments in Reliable Computing (", "TI"],
  "Tibor Csendes, ed.), New York: Kluwer Academic Publishers, 1999 pp. \
337-346."
}], "Text",
  CellTags->"16"],

Cell[TextData[{
  "[17] P. Aubry, F. Rouillier,  and M. Safey El Din, \
\[OpenCurlyDoubleQuote]Real Solving for Positive Dimensional Systems,\
\[CloseCurlyDoubleQuote]  ",
  StyleBox["J. Symb. Comput.", "TI"],
  ", ",
  StyleBox["34 ",
    FontWeight->"Bold"],
  "(",
  StyleBox["6",
    FontColor->GrayLevel[0]],
  "), 2002 pp. 543-560."
}], "Text",
  CellTags->"17"],

Cell[TextData[{
  "[18] G. X. Zeng and X. N. Zeng,  \[OpenCurlyDoubleQuote]An Effective \
Decision Method for Semidefinite Polynomials,\[CloseCurlyDoubleQuote]  ",
  StyleBox["J. Symb. Comput.", "TI"],
  ", ",
  StyleBox["37",
    FontWeight->"Bold"],
  " (1), 2004 pp. 83-99."
}], "Text",
  CellTags->"18"],

Cell[TextData[{
  "[19] A. G. Akritas and A. Strzebonski, Effective Real Root Isolation Using \
Continued Fractions",
  StyleBox[".",
    FontSlant->"Italic"],
  " Paper presented at the ACA 2002 Session on Symbolic-Numerical Methods in \
Computational Science, Volos, Greece. Notebook with the conference talk \
available at ",
  ButtonBox["members.wolfram.com/adams",
    ButtonData:>{
      URL[ "http://members.wolfram.com/adams"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"19"],

Cell[TextData[{
  "[20] J. C. Faugere, P. Gianni, D. Lazard, and T. Mora, \
\[OpenCurlyDoubleQuote]Efficient Computation of Zero-Dimensional Gr\
\[ODoubleDot]bner Bases by Change of Ordering,\[CloseCurlyDoubleQuote] ",
  StyleBox["J. Symb. Comput.", "TI"],
  ", ",
  StyleBox["16",
    FontWeight->"Bold"],
  " (4), 1993 pp, 329-344."
}], "Text",
  CellTags->"20"],

Cell[TextData[{
  "[21] P. Dorato, W. Yang, and C. Abdallah, \[OpenCurlyDoubleQuote]Robust \
Multi-Objective Feedback Design by Quantifier Elimination,\
\[CloseCurlyDoubleQuote] ",
  StyleBox["J. Symb. Comput.", "TI"],
  ", ",
  StyleBox["24",
    FontWeight->"Bold"],
  " (2), 1997 pp, 153-159. "
}], "Text",
  CellTags->"21"],

Cell[TextData[{
  "[22] V. Weispfenning, \[OpenCurlyDoubleQuote]Quantifier elimination for \
real algebra-the cubic case\[CloseCurlyDoubleQuote], in",
  StyleBox[" Issac 1994: Proceedings of the International Symposium on \
Symbolic and Algebraic Computation",
    FontSlant->"Italic"],
  ", New York: ACM, 1994 pp. 258-263."
}], "Text",
  CellTags->"22"],

Cell[TextData[{
  "[23] V. Weispfenning, \[OpenCurlyDoubleQuote]Quantifier elimination for \
real algebra-the quadratic case and beyond\[CloseCurlyDoubleQuote], ",
  StyleBox["Appl. Algebra Eng. Commun. Comput.",
    FontSlant->"Italic"],
  ", ",
  StyleBox["8 ",
    FontWeight->"Bold"],
  "(2), 1997, pp. 85-101."
}], "Text",
  CellTags->"23"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->None,
Saveable->False,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{650, 550},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Real Polynomial Systems",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "t:1"->{
    Cell[1776, 53, 70, 1, 96, "Chapter",
      CellTags->{"t:1", "c:1"}]},
  "c:1"->{
    Cell[1776, 53, 70, 1, 96, "Chapter",
      CellTags->{"t:1", "c:1"}]},
  "t:3"->{
    Cell[1871, 58, 59, 1, 67, "Section",
      CellTags->{"t:3", "c:3"}]},
  "c:3"->{
    Cell[1871, 58, 59, 1, 67, "Section",
      CellTags->{"t:3", "c:3"}]},
  "Real1"->{
    Cell[4098, 134, 261, 5, 31, "NumberedEquation",
      CellTags->"Real1"]},
  "PNF"->{
    Cell[4509, 147, 239, 5, 34, "NumberedEquation",
      CellTags->"PNF"]},
  "DNF"->{
    Cell[5337, 177, 340, 6, 34, "NumberedEquation",
      CellTags->"DNF"]},
  "GeneralRealSolution"->{
    Cell[6902, 224, 296, 6, 30, "NumberedEquation",
      CellTags->"GeneralRealSolution"]},
  "RealSolutionTerm"->{
    Cell[7366, 240, 841, 17, 102, "NumberedEquation",
      CellTags->"RealSolutionTerm"]},
  "CADLift"->{
    Cell[27904, 833, 83, 1, 41, "Subsection",
      CellTags->"CADLift"]},
  "ComplexQuantifierElimination"->{
    Cell[41361, 1227, 96, 1, 41, "Section",
      CellTags->"ComplexQuantifierElimination"]},
  "FactorIneqs"->{
    Cell[59353, 1816, 421, 8, 48, "NumberedEquation",
      CellTags->"FactorIneqs"]},
  "QuadraticQE"->{
    Cell[168469, 4736, 142, 3, 20, "SubsubsectionIcon",
      CellTags->"QuadraticQE"]},
  "QVSPreprocessor"->{
    Cell[178556, 5011, 150, 3, 20, "SubsubsectionIcon",
      CellTags->"QVSPreprocessor"]},
  "ExistsOr"->{
    Cell[201198, 5543, 363, 6, 33, "NumberedEquation",
      CellTags->"ExistsOr"]},
  "t:29"->{
    Cell[210639, 5796, 59, 1, 41, "Section",
      CellTags->{"t:29", "c:29"}]},
  "c:29"->{
    Cell[210639, 5796, 59, 1, 41, "Section",
      CellTags->{"t:29", "c:29"}]},
  "1"->{
    Cell[210701, 5799, 335, 10, 40, "Text",
      CellTags->"1"]},
  "2"->{
    Cell[211039, 5811, 213, 6, 40, "Text",
      CellTags->"2"]},
  "3"->{
    Cell[211255, 5819, 270, 9, 24, "Text",
      CellTags->"3"]},
  "4"->{
    Cell[211528, 5830, 352, 10, 40, "Text",
      CellTags->"4"]},
  "5"->{
    Cell[211883, 5842, 454, 12, 56, "Text",
      CellTags->"5"]},
  "6"->{
    Cell[212340, 5856, 371, 12, 40, "Text",
      CellTags->"6"]},
  "7"->{
    Cell[212714, 5870, 470, 11, 56, "Text",
      CellTags->"7"]},
  "8"->{
    Cell[213187, 5883, 299, 10, 40, "Text",
      CellTags->"8"]},
  "9"->{
    Cell[213489, 5895, 496, 12, 56, "Text",
      CellTags->"9"]},
  "10"->{
    Cell[213988, 5909, 456, 12, 56, "Text",
      CellTags->"10"]},
  "11"->{
    Cell[214447, 5923, 373, 8, 56, "Text",
      CellTags->"11"]},
  "12"->{
    Cell[214823, 5933, 320, 10, 40, "Text",
      CellTags->"12"]},
  "13"->{
    Cell[215146, 5945, 288, 9, 40, "Text",
      CellTags->"13"]},
  "14"->{
    Cell[215437, 5956, 449, 11, 56, "Text",
      CellTags->"14"]},
  "15"->{
    Cell[215889, 5969, 284, 9, 40, "Text",
      CellTags->"15"]},
  "16"->{
    Cell[216176, 5980, 491, 14, 56, "Text",
      CellTags->"16"]},
  "17"->{
    Cell[216670, 5996, 368, 13, 40, "Text",
      CellTags->"17"]},
  "18"->{
    Cell[217041, 6011, 307, 9, 40, "Text",
      CellTags->"18"]},
  "19"->{
    Cell[217351, 6022, 509, 14, 56, "Text",
      CellTags->"19"]},
  "20"->{
    Cell[217863, 6038, 364, 10, 40, "Text",
      CellTags->"20"]},
  "21"->{
    Cell[218230, 6050, 327, 10, 40, "Text",
      CellTags->"21"]},
  "22"->{
    Cell[218560, 6062, 355, 8, 40, "Text",
      CellTags->"22"]},
  "23"->{
    Cell[218918, 6072, 345, 10, 40, "Text",
      CellTags->"23"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"t:1", 220116, 6110},
  {"c:1", 220202, 6113},
  {"t:3", 220288, 6116},
  {"c:3", 220374, 6119},
  {"Real1", 220462, 6122},
  {"PNF", 220552, 6125},
  {"DNF", 220640, 6128},
  {"GeneralRealSolution", 220744, 6131},
  {"RealSolutionTerm", 220861, 6134},
  {"CADLift", 220968, 6137},
  {"ComplexQuantifierElimination", 221079, 6140},
  {"FactorIneqs", 221192, 6143},
  {"QuadraticQE", 221298, 6146},
  {"QVSPreprocessor", 221410, 6149},
  {"ExistsOr", 221519, 6152},
  {"t:29", 221616, 6155},
  {"c:29", 221709, 6158},
  {"1", 221799, 6161},
  {"2", 221875, 6164},
  {"3", 221950, 6167},
  {"4", 222025, 6170},
  {"5", 222101, 6173},
  {"6", 222177, 6176},
  {"7", 222253, 6179},
  {"8", 222329, 6182},
  {"9", 222405, 6185},
  {"10", 222482, 6188},
  {"11", 222560, 6191},
  {"12", 222637, 6194},
  {"13", 222715, 6197},
  {"14", 222792, 6200},
  {"15", 222870, 6203},
  {"16", 222947, 6206},
  {"17", 223025, 6209},
  {"18", 223103, 6212},
  {"19", 223180, 6215},
  {"20", 223258, 6218},
  {"21", 223336, 6221},
  {"22", 223414, 6224},
  {"23", 223491, 6227}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 70, 1, 96, "Chapter",
  CellTags->{"t:1", "c:1"}],

Cell[CellGroupData[{
Cell[1871, 58, 59, 1, 67, "Section",
  CellTags->{"t:3", "c:3"}],
Cell[1933, 61, 175, 5, 24, "Text"],
Cell[2111, 68, 491, 9, 66, "DisplayFormula"],
Cell[2605, 79, 66, 0, 24, "Text"],
Cell[2674, 81, 305, 4, 30, "DisplayFormula"],
Cell[2982, 87, 850, 32, 56, "Text"],
Cell[3835, 121, 260, 11, 24, "Text"],
Cell[4098, 134, 261, 5, 31, "NumberedEquation",
  CellTags->"Real1"],
Cell[4362, 141, 144, 4, 24, "Text"],
Cell[4509, 147, 239, 5, 34, "NumberedEquation",
  CellTags->"PNF"],
Cell[4751, 154, 415, 15, 40, "Text"],
Cell[5169, 171, 165, 4, 24, "Text"],
Cell[5337, 177, 340, 6, 34, "NumberedEquation",
  CellTags->"DNF"],
Cell[5680, 185, 158, 5, 24, "Text"],
Cell[5841, 192, 341, 9, 56, "Text"],
Cell[6185, 203, 260, 4, 30, "DisplayFormula"],
Cell[6448, 209, 127, 3, 24, "Text"],
Cell[6578, 214, 321, 8, 40, "Text"],
Cell[6902, 224, 296, 6, 30, "NumberedEquation",
  CellTags->"GeneralRealSolution"],
Cell[7201, 232, 162, 6, 24, "Text"],
Cell[7366, 240, 841, 17, 102, "NumberedEquation",
  CellTags->"RealSolutionTerm"],
Cell[8210, 259, 1025, 33, 72, "Text"],
Cell[9238, 294, 402, 13, 40, "Text"],
Cell[9643, 309, 188, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[9856, 319, 241, 5, 30, "Input"],
Cell[10100, 326, 1711, 28, 367, "Output"]
}, Open  ]],
Cell[11826, 357, 96, 3, 40, "MathCaption"],
Cell[11925, 362, 197, 4, 58, "Input"],
Cell[12125, 368, 204, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[12354, 378, 66, 2, 26, "Input"],
Cell[12423, 382, 2272, 38, 617, "Output"]
}, Open  ]],
Cell[14710, 423, 498, 12, 72, "Text"],
Cell[15211, 437, 165, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[15401, 447, 221, 5, 30, "Input"],
Cell[15625, 454, 389, 8, 61, "Output"]
}, Open  ]],
Cell[16029, 465, 623, 11, 88, "Text"],
Cell[16655, 478, 157, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[16837, 488, 237, 5, 48, "Input"],
Cell[17077, 495, 139, 3, 44, "Output"]
}, Open  ]],
Cell[17231, 501, 533, 14, 72, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[17801, 520, 54, 0, 41, "Section"],

Cell[CellGroupData[{
Cell[17880, 524, 64, 0, 41, "Subsection"],
Cell[17947, 526, 502, 17, 56, "Text"],
Cell[18452, 545, 223, 7, 40, "Text"],
Cell[18678, 554, 97, 3, 26, "BulletText"],
Cell[18778, 559, 152, 5, 26, "BulletText"],
Cell[18933, 566, 540, 9, 48, "NumberedEquation"],
Cell[19476, 577, 592, 23, 40, "Text"],
Cell[20071, 602, 219, 6, 24, "Text"],
Cell[20293, 610, 240, 4, 32, "DisplayFormula"],
Cell[20536, 616, 26, 0, 24, "Text"],
Cell[20565, 618, 201, 3, 30, "DisplayFormula"],
Cell[20769, 623, 189, 7, 24, "Text"],
Cell[20961, 632, 978, 20, 136, "Text"],
Cell[21942, 654, 716, 19, 88, "Text"],
Cell[22661, 675, 69, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[22755, 679, 132, 3, 26, "Input"],
Cell[22890, 684, 427, 8, 93, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23366, 698, 63, 0, 41, "Subsection"],
Cell[23432, 700, 672, 18, 72, "Text"],
Cell[24107, 720, 302, 5, 30, "DisplayFormula"],
Cell[24412, 727, 910, 27, 72, "Text"],
Cell[25325, 756, 170, 3, 30, "DisplayFormula"],
Cell[25498, 761, 255, 6, 40, "Text"],
Cell[25756, 769, 1644, 48, 152, "Text"],
Cell[27403, 819, 464, 9, 72, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27904, 833, 83, 1, 41, "Subsection",
  CellTags->"CADLift"],
Cell[27990, 836, 3035, 86, 232, "Text"],
Cell[31028, 924, 1293, 39, 97, "Text"],
Cell[32324, 965, 1560, 27, 216, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[33933, 998, 68, 0, 41, "Section"],
Cell[34004, 1000, 186, 6, 24, "Text"],
Cell[34193, 1008, 191, 3, 33, "DisplayFormula"],
Cell[34387, 1013, 487, 14, 56, "Text"],
Cell[34877, 1029, 954, 27, 104, "Text"],
Cell[35834, 1058, 332, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[36191, 1069, 169, 3, 43, "Input"],
Cell[36363, 1074, 63, 2, 25, "Output"]
}, Open  ]],
Cell[36441, 1079, 278, 9, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[36744, 1092, 160, 4, 30, "Input"],
Cell[36907, 1098, 102, 2, 41, "Output"]
}, Open  ]],
Cell[37024, 1103, 334, 7, 56, "Text"],
Cell[37361, 1112, 1207, 35, 120, "Text"],
Cell[38571, 1149, 1367, 34, 152, "Text"],
Cell[39941, 1185, 1383, 37, 152, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[41361, 1227, 96, 1, 41, "Section",
  CellTags->"ComplexQuantifierElimination"],

Cell[CellGroupData[{
Cell[41482, 1232, 53, 0, 41, "Subsection"],
Cell[41538, 1234, 420, 13, 40, "Text"],
Cell[41961, 1249, 420, 13, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[42406, 1266, 176, 3, 32, "Input"],
Cell[42585, 1271, 110, 2, 26, "Output"]
}, Open  ]],
Cell[42710, 1276, 294, 11, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[43029, 1291, 140, 3, 30, "Input"],
Cell[43172, 1296, 710, 15, 158, "Output"]
}, Open  ]],
Cell[43897, 1314, 296, 11, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[44218, 1329, 127, 3, 30, "Input"],
Cell[44348, 1334, 154, 3, 25, "Output"]
}, Open  ]],
Cell[44517, 1340, 123, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[44665, 1347, 247, 4, 32, "Input"],
Cell[44915, 1353, 64, 2, 25, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45028, 1361, 44, 0, 41, "Subsection"],
Cell[45075, 1363, 276, 6, 40, "Text"],
Cell[45354, 1371, 639, 17, 88, "MathCaption"],

Cell[CellGroupData[{
Cell[46018, 1392, 263, 5, 30, "Input"],
Cell[46284, 1399, 1649, 27, 195, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47982, 1432, 32, 0, 41, "Subsection"],
Cell[48017, 1434, 277, 7, 40, "Text"],
Cell[48297, 1443, 185, 4, 40, "Text"],
Cell[48485, 1449, 432, 7, 31, "DisplayFormula"],
Cell[48920, 1458, 266, 11, 24, "Text"],
Cell[49189, 1471, 300, 8, 40, "Text"],
Cell[49492, 1481, 944, 27, 104, "Text"],
Cell[50439, 1510, 201, 4, 40, "Text"],
Cell[50643, 1516, 236, 6, 40, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[50928, 1528, 26, 0, 41, "Section"],
Cell[50957, 1530, 256, 7, 40, "Text"],
Cell[51216, 1539, 926, 25, 154, "DefinitionBox3Col"],
Cell[52145, 1566, 206, 7, 16, "Caption"],

Cell[CellGroupData[{
Cell[52376, 1577, 202, 8, 24, "SubsubsectionIcon"],
Cell[52581, 1587, 168, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[52774, 1596, 104, 2, 30, "Input"],
Cell[52881, 1600, 98, 2, 26, "Output"]
}, Open  ]],
Cell[52994, 1605, 290, 11, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[53309, 1620, 134, 3, 30, "Input"],
Cell[53446, 1625, 149, 3, 49, "Output"]
}, Open  ]],
Cell[53610, 1631, 168, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[53803, 1640, 112, 2, 30, "Input"],
Cell[53918, 1644, 95, 2, 26, "Output"]
}, Open  ]],
Cell[54028, 1649, 362, 9, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[54415, 1662, 111, 2, 30, "Input"],
Cell[54529, 1666, 195, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54761, 1675, 100, 2, 26, "Input"],
Cell[54864, 1679, 271, 5, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[55184, 1690, 120, 2, 20, "SubsubsectionIcon"],
Cell[55307, 1694, 1165, 28, 136, "Text"],
Cell[56475, 1724, 324, 9, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[56824, 1737, 248, 4, 49, "Input"],
Cell[57075, 1743, 388, 8, 78, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[57512, 1757, 59, 0, 41, "Subsection"],
Cell[57574, 1759, 323, 10, 40, "Text"],
Cell[57900, 1771, 105, 3, 29, "Program"],
Cell[58008, 1776, 923, 20, 132, "DefinitionBox3Col"],
Cell[58934, 1798, 235, 8, 16, "Caption"],

Cell[CellGroupData[{
Cell[59194, 1810, 116, 2, 24, "SubsubsectionIcon"],
Cell[59313, 1814, 37, 0, 24, "Text"],
Cell[59353, 1816, 421, 8, 48, "NumberedEquation",
  CellTags->"FactorIneqs"],
Cell[59777, 1826, 288, 5, 56, "Text"],
Cell[60068, 1833, 196, 8, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[60289, 1845, 877, 19, 185, "Input"],
Cell[61169, 1866, 143, 3, 25, "Output"]
}, Open  ]],
Cell[61327, 1872, 709, 20, 88, "MathCaption"],

Cell[CellGroupData[{
Cell[62061, 1896, 1015, 21, 217, "Input"],
Cell[63079, 1919, 151, 3, 25, "Output"]
}, Open  ]],
Cell[63245, 1925, 163, 3, 26, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[63445, 1933, 120, 2, 20, "SubsubsectionIcon"],
Cell[63568, 1937, 294, 6, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[63887, 1947, 100, 2, 30, "Input"],
Cell[63990, 1951, 100, 2, 26, "Output"]
}, Open  ]],
Cell[64105, 1956, 226, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[64356, 1966, 238, 4, 46, "Input"],
Cell[64597, 1972, 83, 2, 26, "Output"]
}, Open  ]],
Cell[64695, 1977, 161, 3, 26, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[64905, 1986, 70, 0, 41, "Subsection"],
Cell[64978, 1988, 334, 10, 40, "Text"],
Cell[65315, 2000, 120, 3, 44, "Program"],
Cell[65438, 2005, 13327, 286, 1400, "DefinitionBox3Col"],
Cell[78768, 2293, 246, 8, 16, "Caption"],

Cell[CellGroupData[{
Cell[79039, 2305, 115, 2, 24, "SubsubsectionIcon"],
Cell[79157, 2309, 862, 21, 136, "MathCaption"],

Cell[CellGroupData[{
Cell[80044, 2334, 1323, 22, 333, "Input"],
Cell[81370, 2358, 1445, 30, 355, "Output"]
}, Open  ]],
Cell[82830, 2391, 167, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[83034, 2399, 119, 2, 20, "SubsubsectionIcon"],
Cell[83156, 2403, 839, 20, 120, "MathCaption"],

Cell[CellGroupData[{
Cell[84020, 2427, 1007, 20, 159, "Input"],
Cell[85030, 2449, 119, 3, 25, "Output"]
}, Open  ]],
Cell[85164, 2455, 171, 3, 42, "Input"],

Cell[CellGroupData[{
Cell[85360, 2462, 899, 18, 123, "Input"],
Cell[86262, 2482, 120, 3, 25, "Output"]
}, Open  ]],
Cell[86397, 2488, 170, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[86604, 2496, 107, 2, 20, "SubsubsectionIcon"],
Cell[86714, 2500, 454, 13, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[87193, 2517, 371, 7, 65, "Input"],
Cell[87567, 2526, 331, 5, 31, "Message"],
Cell[87901, 2533, 283, 6, 58, "Output"]
}, Open  ]],
Cell[88199, 2542, 158, 3, 26, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[88394, 2550, 123, 2, 20, "SubsubsectionIcon"],
Cell[88520, 2554, 1588, 39, 216, "MathCaption"],

Cell[CellGroupData[{
Cell[90133, 2597, 385, 7, 68, "Input"],
Cell[90521, 2606, 684, 12, 143, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[91242, 2623, 518, 9, 100, "Input"],
Cell[91763, 2634, 683, 12, 143, "Output"]
}, Open  ]],
Cell[92461, 2649, 176, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[92674, 2657, 120, 2, 20, "SubsubsectionIcon"],
Cell[92797, 2661, 1511, 36, 216, "MathCaption"],

Cell[CellGroupData[{
Cell[94333, 2701, 549, 10, 68, "Input"],
Cell[94885, 2713, 155, 3, 41, "Output"]
}, Open  ]],
Cell[95055, 2719, 82, 1, 40, "MathCaption"],
Cell[95140, 2722, 172, 3, 42, "Input"],

Cell[CellGroupData[{
Cell[95337, 2729, 549, 10, 68, "Input"],
Cell[95889, 2741, 155, 3, 41, "Output"]
}, Open  ]],
Cell[96059, 2747, 171, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[96267, 2755, 115, 2, 20, "SubsubsectionIcon"],
Cell[96385, 2759, 3030, 82, 296, "Text"],
Cell[99418, 2843, 277, 6, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[99720, 2853, 649, 12, 151, "Input"],
Cell[100372, 2867, 116, 2, 25, "Output"]
}, Open  ]],
Cell[100503, 2872, 175, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[100715, 2880, 134, 2, 20, "SubsubsectionIcon"],
Cell[100852, 2884, 725, 19, 88, "Text"],
Cell[101580, 2905, 435, 12, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[102040, 2921, 754, 13, 169, "Input"],
Cell[102797, 2936, 130, 3, 25, "Output"]
}, Open  ]],
Cell[102942, 2942, 185, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[103164, 2950, 123, 2, 20, "SubsubsectionIcon"],
Cell[103290, 2954, 1221, 40, 120, "Text"],
Cell[104514, 2996, 178, 6, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[104717, 3006, 863, 17, 140, "Input"],
Cell[105583, 3025, 132, 3, 25, "Output"]
}, Open  ]],
Cell[105730, 3031, 175, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[105942, 3039, 119, 2, 20, "SubsubsectionIcon"],
Cell[106064, 3043, 993, 26, 104, "Text"],
Cell[107060, 3071, 230, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[107315, 3081, 305, 6, 50, "Input"],
Cell[107623, 3089, 1944, 31, 339, "Output"]
}, Open  ]],
Cell[109582, 3123, 281, 9, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[109888, 3136, 454, 8, 82, "Input"],
Cell[110345, 3146, 3850, 57, 373, "Output"]
}, Open  ]],
Cell[114210, 3206, 325, 10, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[114560, 3220, 480, 8, 82, "Input"],
Cell[115043, 3230, 238, 5, 25, "Output"]
}, Open  ]],
Cell[115296, 3238, 217, 8, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[115538, 3250, 441, 8, 82, "Input"],
Cell[115982, 3260, 931, 15, 197, "Output"]
}, Open  ]],
Cell[116928, 3278, 175, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[117140, 3286, 114, 2, 20, "SubsubsectionIcon"],
Cell[117257, 3290, 1019, 21, 136, "Text"],
Cell[118279, 3313, 158, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[118462, 3321, 253, 6, 49, "Input"],
Cell[118718, 3329, 192, 4, 41, "Output"]
}, Open  ]],
Cell[118925, 3336, 144, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[119094, 3345, 380, 8, 81, "Input"],
Cell[119477, 3355, 169, 3, 41, "Output"]
}, Open  ]],
Cell[119661, 3361, 165, 3, 42, "Input"],
Cell[119829, 3366, 347, 8, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[120201, 3378, 201, 5, 30, "Input"],
Cell[120405, 3385, 92, 2, 25, "Output"]
}, Open  ]],
Cell[120512, 3390, 218, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[120755, 3400, 328, 7, 62, "Input"],
Cell[121086, 3409, 92, 2, 25, "Output"]
}, Open  ]],
Cell[121193, 3414, 165, 3, 42, "Input"],
Cell[121361, 3419, 163, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[121549, 3427, 199, 4, 49, "Input"],
Cell[121751, 3433, 93, 2, 25, "Output"]
}, Open  ]],
Cell[121859, 3438, 161, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[122045, 3447, 386, 8, 82, "Input"],
Cell[122434, 3457, 67, 2, 25, "Output"]
}, Open  ]],
Cell[122516, 3462, 165, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[122718, 3470, 115, 2, 20, "SubsubsectionIcon"],
Cell[122836, 3474, 527, 17, 56, "Text"],
Cell[123366, 3493, 154, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[123545, 3502, 252, 6, 49, "Input"],
Cell[123800, 3510, 95, 2, 25, "Output"]
}, Open  ]],
Cell[123910, 3515, 167, 3, 42, "Input"],

Cell[CellGroupData[{
Cell[124102, 3522, 252, 6, 49, "Input"],
Cell[124357, 3530, 81, 2, 25, "Output"]
}, Open  ]],
Cell[124453, 3535, 69, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[124547, 3539, 161, 3, 42, "Input"],
Cell[124711, 3544, 157, 3, 41, "Output"]
}, Open  ]],
Cell[124883, 3550, 167, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[125087, 3558, 250, 8, 20, "SubsubsectionIcon"],
Cell[125340, 3568, 2013, 60, 200, "Text"],
Cell[127356, 3630, 134, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[127515, 3637, 213, 4, 42, "Input"],
Cell[127731, 3643, 166, 3, 41, "Output"]
}, Open  ]],
Cell[127912, 3649, 66, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[128003, 3653, 399, 8, 74, "Input"],
Cell[128405, 3663, 153, 3, 41, "Output"]
}, Open  ]],
Cell[128573, 3669, 68, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[128666, 3673, 400, 8, 74, "Input"],
Cell[129069, 3683, 141, 3, 41, "Output"]
}, Open  ]],
Cell[129225, 3689, 193, 3, 42, "Input"],
Cell[129421, 3694, 199, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[129645, 3702, 259, 5, 63, "Input"],
Cell[129907, 3709, 248, 4, 42, "Output"]
}, Open  ]],
Cell[130170, 3716, 248, 8, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[130443, 3728, 386, 7, 97, "Input"],
Cell[130832, 3737, 244, 4, 42, "Output"]
}, Open  ]],
Cell[131091, 3744, 166, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[131294, 3752, 119, 2, 20, "SubsubsectionIcon"],
Cell[131416, 3756, 421, 9, 56, "Text"],
Cell[131840, 3767, 270, 9, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[132135, 3780, 380, 8, 68, "Input"],
Cell[132518, 3790, 181, 3, 41, "Output"]
}, Open  ]],
Cell[132714, 3796, 175, 5, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[132914, 3805, 529, 10, 99, "Input"],
Cell[133446, 3817, 185, 3, 41, "Output"]
}, Open  ]],
Cell[133646, 3823, 171, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[133854, 3831, 112, 2, 20, "SubsubsectionIcon"],
Cell[133969, 3835, 1048, 23, 136, "Text"],
Cell[135020, 3860, 353, 11, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[135398, 3875, 441, 9, 50, "Input"],
Cell[135842, 3886, 95, 2, 25, "Output"]
}, Open  ]],
Cell[135952, 3891, 334, 8, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[136311, 3903, 587, 11, 82, "Input"],
Cell[136901, 3916, 95, 2, 25, "Output"]
}, Open  ]],
Cell[137011, 3921, 57, 0, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[137093, 3925, 68, 2, 26, "Input"],
Cell[137164, 3929, 64, 2, 25, "Output"]
}, Open  ]],
Cell[137243, 3934, 278, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[137546, 3945, 615, 11, 101, "Input"],
Cell[138164, 3958, 68, 2, 25, "Output"]
}, Open  ]],
Cell[138247, 3963, 541, 14, 88, "MathCaption"],

Cell[CellGroupData[{
Cell[138813, 3981, 513, 8, 82, "Input"],
Cell[139329, 3991, 483, 9, 94, "Output"]
}, Open  ]],
Cell[139827, 4003, 343, 8, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[140195, 4015, 518, 8, 82, "Input"],
Cell[140716, 4025, 484, 9, 94, "Output"]
}, Open  ]],
Cell[141215, 4037, 136, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[141376, 4045, 514, 8, 82, "Input"],
Cell[141893, 4055, 484, 9, 94, "Output"]
}, Open  ]],
Cell[142392, 4067, 650, 12, 120, "MathCaption"],

Cell[CellGroupData[{
Cell[143067, 4083, 530, 9, 100, "Input"],
Cell[143600, 4094, 2418, 36, 344, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[146067, 4136, 118, 2, 20, "SubsubsectionIcon"],
Cell[146188, 4140, 1052, 27, 136, "Text"],
Cell[147243, 4169, 313, 8, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[147581, 4181, 338, 6, 50, "Input"],
Cell[147922, 4189, 185, 3, 41, "Output"]
}, Open  ]],
Cell[148122, 4195, 419, 12, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[148566, 4211, 487, 9, 82, "Input"],
Cell[149056, 4222, 216, 4, 41, "Output"]
}, Open  ]],
Cell[149287, 4229, 254, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[149566, 4239, 488, 9, 82, "Input"],
Cell[150057, 4250, 174, 3, 41, "Output"]
}, Open  ]],
Cell[150246, 4256, 419, 9, 88, "MathCaption"],

Cell[CellGroupData[{
Cell[150690, 4269, 480, 8, 82, "Input"],
Cell[151173, 4279, 236, 4, 50, "Output"]
}, Open  ]],
Cell[151424, 4286, 413, 12, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[151862, 4302, 475, 8, 82, "Input"],
Cell[152340, 4312, 723, 12, 194, "Output"]
}, Open  ]],
Cell[153078, 4327, 265, 6, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[153368, 4337, 476, 8, 82, "Input"],
Cell[153847, 4347, 167, 3, 35, "Output"]
}, Open  ]],
Cell[154029, 4353, 175, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[154241, 4361, 133, 2, 20, "SubsubsectionIcon"],
Cell[154377, 4365, 574, 18, 56, "Text"],
Cell[154954, 4385, 378, 9, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[155357, 4398, 1258, 21, 171, "Input"],
Cell[156618, 4421, 231, 4, 44, "Output"]
}, Open  ]],
Cell[156864, 4428, 191, 4, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[157080, 4436, 1259, 21, 171, "Input"],
Cell[158342, 4459, 232, 4, 44, "Output"]
}, Open  ]],
Cell[158589, 4466, 326, 9, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[158940, 4479, 1286, 22, 171, "Input"],
Cell[160229, 4503, 94, 2, 25, "Output"]
}, Open  ]],
Cell[160338, 4508, 254, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[160617, 4519, 1287, 22, 171, "Input"],
Cell[161907, 4543, 93, 2, 25, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[162049, 4551, 120, 2, 20, "SubsubsectionIcon"],
Cell[162172, 4555, 177, 5, 40, "Text"],
Cell[162352, 4562, 1414, 28, 184, "Text"],
Cell[163769, 4592, 753, 14, 120, "Text"],
Cell[164525, 4608, 271, 6, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[164821, 4618, 366, 7, 81, "Input"],
Cell[165190, 4627, 161, 3, 25, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[165388, 4635, 367, 7, 81, "Input"],
Cell[165758, 4644, 161, 3, 25, "Output"]
}, Open  ]],
Cell[165934, 4650, 208, 5, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[166167, 4659, 330, 6, 81, "Input"],
Cell[166500, 4667, 146, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[166683, 4675, 331, 6, 81, "Input"],
Cell[167017, 4683, 149, 3, 41, "Output"]
}, Open  ]],
Cell[167181, 4689, 267, 8, 56, "MathCaption"],
Cell[167451, 4699, 177, 3, 42, "Input"],

Cell[CellGroupData[{
Cell[167653, 4706, 234, 5, 49, "Input"],
Cell[167890, 4713, 160, 3, 25, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[168087, 4721, 181, 4, 49, "Input"],
Cell[168271, 4727, 149, 3, 41, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[168469, 4736, 142, 3, 20, "SubsubsectionIcon",
  CellTags->"QuadraticQE"],
Cell[168614, 4741, 2193, 50, 280, "Text"],
Cell[170810, 4793, 431, 16, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[171266, 4813, 172, 3, 30, "Input"],
Cell[171441, 4818, 1044, 19, 110, "Output"]
}, Open  ]],
Cell[172500, 4840, 301, 13, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[172826, 4857, 176, 3, 30, "Input"],
Cell[173005, 4862, 236, 5, 43, "Output"]
}, Open  ]],
Cell[173256, 4870, 531, 19, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[173812, 4893, 320, 5, 62, "Input"],
Cell[174135, 4900, 236, 5, 43, "Output"]
}, Open  ]],
Cell[174386, 4908, 257, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[174668, 4919, 749, 12, 118, "Input"],
Cell[175420, 4933, 1818, 28, 297, "Output"]
}, Open  ]],
Cell[177253, 4964, 128, 4, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[177406, 4972, 197, 4, 47, "Input"],
Cell[177606, 4978, 117, 2, 46, "Output"]
}, Open  ]],
Cell[177738, 4983, 109, 3, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[177872, 4990, 362, 6, 79, "Input"],
Cell[178237, 4998, 95, 2, 25, "Output"]
}, Open  ]],
Cell[178347, 5003, 172, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[178556, 5011, 150, 3, 20, "SubsubsectionIcon",
  CellTags->"QVSPreprocessor"],
Cell[178709, 5016, 1406, 36, 168, "Text"],
Cell[180118, 5054, 228, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[180371, 5064, 599, 10, 119, "Input"],
Cell[180973, 5076, 212, 4, 54, "Output"]
}, Open  ]],
Cell[181200, 5083, 307, 7, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[181532, 5094, 401, 7, 82, "Input"],
Cell[181936, 5103, 94, 2, 25, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[182079, 5111, 116, 2, 20, "SubsubsectionIcon"],
Cell[182198, 5115, 1485, 48, 136, "Text"],
Cell[183686, 5165, 555, 18, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[184266, 5187, 142, 3, 30, "Input"],
Cell[184411, 5192, 1050, 19, 301, "Output"]
}, Open  ]],
Cell[185476, 5214, 287, 7, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[185788, 5225, 288, 5, 62, "Input"],
Cell[186079, 5232, 1292, 26, 178, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[187420, 5264, 115, 2, 20, "SubsubsectionIcon"],
Cell[187538, 5268, 1036, 27, 120, "Text"],
Cell[188577, 5297, 191, 8, 40, "MathCaption"],

Cell[CellGroupData[{
Cell[188793, 5309, 211, 5, 49, "Input"],
Cell[189007, 5316, 1192, 19, 271, "Output"]
}, Open  ]],
Cell[190214, 5338, 222, 7, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[190461, 5349, 244, 5, 49, "Input"],
Cell[190708, 5356, 8362, 122, 1832, "Output"]
}, Open  ]],
Cell[199085, 5481, 335, 12, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[199445, 5497, 355, 7, 81, "Input"],
Cell[199803, 5506, 951, 16, 148, "Output"]
}, Open  ]],
Cell[200769, 5525, 168, 3, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[200974, 5533, 112, 2, 20, "SubsubsectionIcon"],
Cell[201089, 5537, 106, 4, 24, "Text"],
Cell[201198, 5543, 363, 6, 33, "NumberedEquation",
  CellTags->"ExistsOr"],
Cell[201564, 5551, 898, 24, 104, "Text"],
Cell[202465, 5577, 231, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[202721, 5587, 307, 6, 67, "Input"],
Cell[203031, 5595, 99, 2, 26, "Output"]
}, Open  ]],
Cell[203145, 5600, 188, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[203358, 5610, 449, 8, 81, "Input"],
Cell[203810, 5620, 95, 2, 25, "Output"]
}, Open  ]],
Cell[203920, 5625, 224, 6, 56, "MathCaption"],

Cell[CellGroupData[{
Cell[204169, 5635, 1705, 28, 242, "Input"],
Cell[205877, 5665, 96, 2, 25, "Output"]
}, Open  ]],
Cell[205988, 5670, 389, 9, 88, "MathCaption"],

Cell[CellGroupData[{
Cell[206402, 5683, 1706, 28, 242, "Input"],
Cell[208111, 5713, 97, 2, 25, "Output"]
}, Open  ]],
Cell[208223, 5718, 164, 3, 26, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[208424, 5726, 116, 2, 20, "SubsubsectionIcon"],
Cell[208543, 5730, 881, 24, 120, "MathCaption"],

Cell[CellGroupData[{
Cell[209449, 5758, 203, 4, 49, "Input"],
Cell[209655, 5764, 175, 3, 25, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[209867, 5772, 348, 6, 81, "Input"],
Cell[210218, 5780, 176, 3, 25, "Output"]
}, Open  ]],
Cell[210409, 5786, 169, 3, 42, "Input"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[210639, 5796, 59, 1, 41, "Section",
  CellTags->{"t:29", "c:29"}],
Cell[210701, 5799, 335, 10, 40, "Text",
  CellTags->"1"],
Cell[211039, 5811, 213, 6, 40, "Text",
  CellTags->"2"],
Cell[211255, 5819, 270, 9, 24, "Text",
  CellTags->"3"],
Cell[211528, 5830, 352, 10, 40, "Text",
  CellTags->"4"],
Cell[211883, 5842, 454, 12, 56, "Text",
  CellTags->"5"],
Cell[212340, 5856, 371, 12, 40, "Text",
  CellTags->"6"],
Cell[212714, 5870, 470, 11, 56, "Text",
  CellTags->"7"],
Cell[213187, 5883, 299, 10, 40, "Text",
  CellTags->"8"],
Cell[213489, 5895, 496, 12, 56, "Text",
  CellTags->"9"],
Cell[213988, 5909, 456, 12, 56, "Text",
  CellTags->"10"],
Cell[214447, 5923, 373, 8, 56, "Text",
  CellTags->"11"],
Cell[214823, 5933, 320, 10, 40, "Text",
  CellTags->"12"],
Cell[215146, 5945, 288, 9, 40, "Text",
  CellTags->"13"],
Cell[215437, 5956, 449, 11, 56, "Text",
  CellTags->"14"],
Cell[215889, 5969, 284, 9, 40, "Text",
  CellTags->"15"],
Cell[216176, 5980, 491, 14, 56, "Text",
  CellTags->"16"],
Cell[216670, 5996, 368, 13, 40, "Text",
  CellTags->"17"],
Cell[217041, 6011, 307, 9, 40, "Text",
  CellTags->"18"],
Cell[217351, 6022, 509, 14, 56, "Text",
  CellTags->"19"],
Cell[217863, 6038, 364, 10, 40, "Text",
  CellTags->"20"],
Cell[218230, 6050, 327, 10, 40, "Text",
  CellTags->"21"],
Cell[218560, 6062, 355, 8, 40, "Text",
  CellTags->"22"],
Cell[218918, 6072, 345, 10, 40, "Text",
  CellTags->"23"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

