(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   6647612,     285848]*)
(*NotebookOutlinePosition[   6719570,     287928]*)
(*  CellTagsIndexPosition[   6708551,     287553]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Linear Algebra in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[TextData[StyleBox["Document Version 1.0\nSeptember 2003", "SB"]], \
"CopyrightHead",
  CellTags->"Introduction"],

Cell[TextData[{
  "Copyright \[Copyright] 1999-2003 Wolfram Research, Inc. All rights \
reserved.\n",
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  StyleBox[" is a", "TI",
    FontSlant->"Plain"],
  " trademark of Wolfram Research, Inc.\nAll other trademarks used herein are \
the property of their respective owners."
}], "Copyright",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Introduction ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:1"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, 24}},
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Tensors and Arrays",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:2"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:2"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrices as ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox["Expressions",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Expression Input and Output",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:4"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:4"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Design Principles of ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:5"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:5"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:5"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Matrix and Tensor Operations ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:6"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Building Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:7"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:7"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Special Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:8"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:8"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:9"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:9"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Getting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:10"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:10"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Getting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:11"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:11"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Setting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:12"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:12"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Setting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:13"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:13"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[ButtonBox["Extracting Submatrices ",
  ButtonData:>{
    FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:14"},
  ButtonStyle->"PageLink"]], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Deleting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:15"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:15"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Inserting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:16"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:16"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Extending Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:17"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:17"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Transpose",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:18"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:18"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Rotating Elements",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:19"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:19"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Testing Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:20"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:20"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Further Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:21"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:21"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Element-wise Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:22"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:22"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Listability",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:23"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:23"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Map",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:24"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:24"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Vectors and Tensors",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:25"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:25"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Testing Vectors and Tensors",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:26"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:26"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Visualization of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:27"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:27"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Formatting Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:28"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:28"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Plotting Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:29"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:29"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Import and Export of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:30"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:30"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Multiplication",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:31"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:31"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Outer Product",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:32"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:32"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Visualization of the Outer Product",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:33"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:33"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Generalized Inner Product",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:34"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:34"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Permutations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:35"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:35"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Permutation Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:36"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:36"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Sparse Arrays ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:37"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Basic Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:38"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:38"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["SparseArray",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:39"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:39"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Rule Inputs for SparseArray",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:40"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:40"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Identity and Diagonal Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:41"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:41"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Normal",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:42"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:42"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["ArrayRules",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:43"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:43"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:44"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:44"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Getting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:45"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:45"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Getting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:46"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:46"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Setting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:47"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:47"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Setting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:48"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:48"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[ButtonBox["Extracting Submatrices ",
  ButtonData:>{
    FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:49"},
  ButtonStyle->"PageLink"]], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Deleting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:50"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:50"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Inserting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:51"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:51"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Extending Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:52"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:52"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Transpose",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:53"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:53"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Rotating Elements",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:54"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:54"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Testing Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:55"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:55"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Further Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:56"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:56"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Element-wise Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:57"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:57"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Listability",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:58"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:58"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Map",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:59"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:59"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Visualization of Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:60"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:60"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Formatting Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:61"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:61"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Plotting Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:62"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:62"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Import and Export of Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:63"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:63"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Multiplication",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:64"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:64"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Outer Product",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:65"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:65"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Matrix Permutations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:66"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:66"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Converting Equations to Sparse Arrays",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:67"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:67"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["SparseArray Data Format",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:68"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:68"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Matrix Computations ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:69"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Basic Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:70"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:70"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Norms",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:71"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:71"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Vector Norms",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:72"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:72"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Matrix Norms",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:73"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:73"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["NullSpace",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:74"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:74"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Rank",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:75"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:75"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Reduced Row Echelon Form",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:76"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:76"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Inverse",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:77"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:77"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["PseudoInverse",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:78"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:78"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Determinant",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:79"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:79"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Minors",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:80"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:80"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Solving Linear Systems",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:81"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:81"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Singular Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:82"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:82"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Homogeneous Equations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:83"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:83"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Estimating and Calculating Accuracy",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:84"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:84"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Symbolic and Exact Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:85"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:85"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Row Reduction",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:86"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:86"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Saving the Factorization",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:87"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:87"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Methods",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:88"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:88"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["LAPACK",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:89"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:89"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Multifrontal",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:90"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:90"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Krylov",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:91"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:91"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Cholesky",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:92"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:92"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Symbolic Methods",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:93"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:93"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Least Squares Solutions",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:94"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:94"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Data Fitting",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:95"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:95"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Eigensystem Computations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:96"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:96"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Eigensystem Properties",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:97"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:97"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Diagonalizing a Matrix",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:98"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:98"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Symbolic and Exact Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:99"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:99"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Generalized Eigenvalues",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:100"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:100"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Methods",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:101"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:101"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["LAPACK",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:102"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:102"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Arnoldi",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:103"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:103"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Symbolic Methods",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:104"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:104"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Decompositions",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:105"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:105"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["LU Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:106"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:106"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Cholesky Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:107"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:107"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Cholesky and LU Factorizations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:108"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:108"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Gram-Schmidt Orthogonalization",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:109"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:109"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["QR Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:110"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:110"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Solving Systems of Equations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:111"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:111"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Singular Value Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:112"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:112"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Generalized Singular Values",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:113"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:113"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Options",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:114"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:114"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Schur Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:115"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:115"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Generalized Schur Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:116"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:116"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Options",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:117"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:117"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Jordan Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:118"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:118"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Functions of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:119"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:119"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Matrix Types ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:120"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Numbers in ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:121"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:121"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:121"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Exact versus Approximate Numbers",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:122"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:122"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Mixed Mode Arithmetic",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:123"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:123"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrices in ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:124"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:124"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:124"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Standard Numerical Techniques",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:125"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:125"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Arbitrary-Precision Numerical Techniques",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:126"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:126"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Symbolic Algebra Techniques",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:127"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:127"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Mixed Mode Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:128"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:128"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Complex Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:129"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:129"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Arbitrary-Precision Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:130"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:130"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Performance ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:131"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Packed Arrays",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:132"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:132"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Packed Array Functions",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:133"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:133"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Packed Array Operations",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:134"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:134"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Packed Array Summary",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:135"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:135"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Programming Efficiency",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:136"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:136"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Measuring Performance",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:137"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:137"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Vectorizing Loops",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:138"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:138"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["List Creation",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:139"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:139"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["List Updating",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:140"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:140"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Using Built-in Support",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:141"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:141"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["A Slow Way",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:142"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:142"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["A Faster Way",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:143"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:143"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Also Fast but Neater",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:144"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:144"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Contents",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:145"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:145"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Mixed Symbolic/Numerical Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:146"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:146"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Mixed Numerical Type Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:147"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:147"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Integer Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:148"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:148"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Expression Efficiency",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:149"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:149"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Updating of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:150"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:150"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Appending to Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:151"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:151"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Examples ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:152"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Matrix Ordering",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:153"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:153"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Full Rank Least Squares Solutions",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:154"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:154"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Least Squares Cholesky",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:155"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:155"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Least Squares QR",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:156"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:156"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Minimization of 1 and Infinity Norms",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:157"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:157"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["One-Norm Minimization",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:158"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:158"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Infinity-Norm Minimization",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:159"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:159"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Finite Difference Solutions",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:160"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:160"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Mesh Partitioning",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:161"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:161"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Data",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:162"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:162"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Plotting the Mesh",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:163"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:163"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["The Laplacian",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:164"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:164"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["The Fiedler Vector",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:165"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:165"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Partitioning the Nodes",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:166"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:166"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["Matrix Functions with NDSolve",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:167"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:167"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["TOCTitle"],
  ".",
  ButtonBox[" Appendix ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:168"},
    ButtonStyle->"PageLink"]
}], "TOCTitle",
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  CellTags->"LAReport:TOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Software References",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:169"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:169"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["ARPACK",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:170"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:170"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["ATLAS",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:171"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:171"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Harwell-Boeing",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:172"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:172"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["Matrix Market",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:173"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:173"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["METIS",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:174"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:174"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["TAUCS",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:175"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:175"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"],

Cell[TextData[{
  ButtonBox["UMFPACK",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:176"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:176"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LAReport:TOC"]
}, Open  ]],

Cell[TextData[{
  ButtonBox["References",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:177"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "LinearAlgebra.nb"], "c:177"},
    ButtonStyle->"PageLink"]
}], "TOCSection",
  CellTags->"LAReport:TOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["Chapter"],
  ". Introduction"
}], "Chapter",
  ShowCellBracket->True,
  CellTags->{"t:1", "c:1"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has a broad range of functions to support linear algebra operations and \
to integrate them into the system. It can work with vectors, matrices, and \
tensors that can contain machine-precision floating point numbers, ",
  "arbitrary-precision",
  " floating point numbers, complex floating point numbers, integers, \
rational numbers, and general symbolic quantities. Linear algebra operations \
are supported for matrices that contain all these different types of entry."
}], "Text"],

Cell[TextData[{
  "While ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " supports both dense and sparse matrices, the initial parts of this \
document will concentrate on dense matrices; sparse matrices are documented \
in their own section. In general, all the operations that work on dense \
matrices work on sparse matrices in an equivalent way."
}], "Text"],

Cell[TextData[{
  "Matrices are represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with lists. They can be entered directly with the { } notation that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides for lists."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1.5, 1.6}, {1.7, 1.8}}\)], "InputOnly",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({{1.5`, 1.6`}, {1.7`, 1.8`}}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell[TextData[{
  "They can be created programmatically with ",
  StyleBox["Table", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Random[], {3}, {3}]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({{0.09146317195678264`, 0.5107039846294176`, 
        0.8763778487694037`}, {0.9262469880203367`, 0.8709000095626248`, 
        0.31815158475332866`}, {0.9586717355414787`, 0.3170952286301728`, 
        0.8791309622767869`}}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat = Table[m\_\(i, j\), {i, 3}, {j, 3}]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{m\_\(1, 1\), m\_\(1, 2\), m\_\(1, 3\)}, {m\_\(2, 1\), m\_\(2, 2\), 
        m\_\(2, 3\)}, {m\_\(3, 1\), m\_\(3, 2\), m\_\(3, 3\)}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell["You can extract size information.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[mat]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({3, 3}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["It is also possible to test if something is a matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[\ mat]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["MatrixForm", "MR"],
  " helps to make the structure of the matrix clearer."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[mat]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  "Matrices are important in many areas of computation because they are an \
efficient way to represent linear systems of equations. Many computer \
applications can work with matrices because they can work efficiently with \
arrays of numbers. However, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can also work directly with the systems of linear equations the matrices \
represent. Here, a matrix is multiplied by a vector of the unknowns and a \
system of equations is formed."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = {{1.5, 1.6}, {1.7, 1.8}};\)\), "\n", 
    \(eqns = Thread[mat . {x, y} \[Equal] {2, 6}]\)}], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({1.5`\ x + 1.6`\ y \[Equal] 2, 
      1.7`\ x + 1.8`\ y \[Equal] 6}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "These equations can be solved with the algebraic equation solver, ",
  StyleBox["Solve", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[eqns, {x, y}]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({{x \[Rule] 299.99999999999756`, 
        y \[Rule] \(-279.99999999999767`\)}}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
  "Alternatively, the matrix representation of the equations can be solved \
directly with the ",
  StyleBox["LinearSolve", "MR"],
  " command."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[mat, {2, 6}]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({299.99999999999756`, \(-279.99999999999767`\)}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell["\<\
Conversion between matrices and the linear systems they represent is often \
useful in order to understand the underlying principles. Using one form or \
the other can also be a very useful way to set up particular problems.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Tensors and Arrays", "Section",
  CellTags->{"t:190", "c:2"}],

Cell["\<\
A matrix has two indices that label each entry. By convention the values of \
these indices label the row and column when the matrix is written in a \
tabular form. A generalization of matrices can have less than or more than \
two indices. Typically an object with no indices is called a scalar, and one \
with one index is called a vector. An object with more than two indices is \
called a tensor, although a scalar, vector, or matrix can also be called a \
tensor.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " works with tensors that have arbitrary numbers of indices with the same \
list structure that is used for matrices. The number of levels of lists \
represents the number of indices. For example, the following is a vector."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec = {1, 2, 3}\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[vec]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({3}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["\<\
The following is a tensor with 3 indices, with lengths 2, 3, and 4, \
respectively. The number of indices required to label a tensor can be called \
the rank of the tensor.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tensor = {\ {{1, 2, 3, 4}, {4, 5, 6, 7}, {4, 5, 6, 7}}, {{1, 2, 3, 
            9}, {1, 2, 6, 5}, {1, 2, 6, 5}}}\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{{1, 2, 3, 4}, {4, 5, 6, 7}, {4, 5, 6, 7}}, {{1, 2, 3, 9}, {1, 2, 6, 
          5}, {1, 2, 6, 5}}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[tensor]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({2, 3, 4}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "It should be noted that the notion of a tensor as used in physics has \
additional properties beyond the labelling of elements  in generalized \
matrices. This is discussed more in the description of tensors given in ",
  ButtonBox["MathWorld",
    ButtonData:>"t:189",
    ButtonStyle->"NotebookLink"],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " the term tensor is used to refer to generalized matrices."
}], "Text"],

Cell[TextData[{
  "Many of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions that operate on matrices are also generalized to work for \
vectors and tensors. This important principle will be demonstrated many times \
in this document, and is covered in the section ",
  ButtonBox["Matrix and Tensor Operations",
    ButtonData:>"t:3",
    ButtonStyle->"NotebookLink"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Matrices as ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "Expressions"
}], "Section",
  CellTags->{"t:2", "c:3"}],

Cell[TextData[{
  "One important feature of matrices in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is that they are ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions. This means that all of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands that operate on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions work on matrices. The same principle applies to vectors and \
tensors. The fact that all objects in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " have a common expression structure greatly enhances the expressive nature \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming. This principle, sometimes called the fundamental principle \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", may seem abstract, uninteresting, or obvious to people who have a \
background in purely numerical programming, but users who have a background \
in object oriented programming will recognize the benefits of a common parent \
object. Some examples of this principle will be discussed in this section."
}], "Text"],

Cell["\<\
As demonstrated above, a matrix can be entered with a list notation.\
\>", "Text"],

Cell[BoxData[
    \(\(mat = {{1, 2, 3}, {4, 5, 6}};\)\)], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "One important way to understand ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions is through the function ",
  StyleBox["FullForm", "MR"],
  ". This shows the literal details of how the expression is arranged in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In this case, the tree structure of the matrix is seen. There is an \
outer node, which is a ",
  StyleBox["List", "MR"],
  "; in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "this is called having a head of ",
  StyleBox["List", "MR"],
  ". The outer node has two arguments, each of which has the head ",
  StyleBox["List", "MR"],
  "; each of these has three arguments that are integers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[mat]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[List[1, 2, 3], List[4, 5, 6]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[2]//FullForm="]
}, Open  ]],

Cell[TextData[{
  "The head of the matrix expression can be inspected with the function ",
  StyleBox["Head", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[mat]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \(List\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Length", "MR"],
  " returns the number of arguments of the matrix expression."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[mat]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Part", "MR"],
  " can be used to extract elements of an expression."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([\ 2, 3]\)]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " operations such as ",
  StyleBox["FullForm", "MR"],
  ", ",
  StyleBox["Head", "MR"],
  ", ",
  StyleBox["Length", "MR"],
  ", and ",
  StyleBox["Part", "MR"],
  " will work for any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. This is very convenient because it means that a common set of \
programming constructs will work for programming in many different \
applications, and not only for linear algebra. The same techniques apply to \
many other areas in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", for example, graphics programming, document programming, and symbolic \
algebra programming. These operations are often called structural operations \
because they work on the structure of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions. They can be contrasted with other operations that are \
specific to linear algebra. For example, the function ",
  StyleBox["MatrixQ", "MR"],
  " is specific to matrix computation."
}], "Text"],

Cell[CellGroupData[{

Cell["Expression Input and Output", "Subsection",
  CellTags->{"t:118", "c:4"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains commands for I/O on expressions. It also has many commands for \
I/O with specially formatted data. The commands that can work with formatted \
data are reviewed in the section ",
  ButtonBox["Import and Export of Matrices",
    ButtonData:>"t:21",
    ButtonStyle->"NotebookLink"],
  ". In this section the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands for I/O on expressions are reviewed."
}], "Text"],

Cell[TextData[{
  "The concept of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["FullForm", "MR"],
  " is completely equivalent to that of serializable objects in Java or C#. \
The ",
  StyleBox["FullForm", "MR"],
  " of any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression is a complete specification of the expression. Saving the ",
  StyleBox["FullForm", "MR"],
  " into a file and reading it back again will recreate the expression."
}], "Text"],

Cell[TextData[{
  "You can save a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression into a file with the command ",
  StyleBox["Put", "MR"],
  ", entered using ",
  StyleBox[">>", "MR"],
  " as a short-cut notation."
}], "Text"],

Cell[BoxData[{
    \(\(mat = {{1, 2, 3}, {4, 5, 6}};\)\), "\n", 
    \(mat >> file.1\)}], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "The contents of the file can be inspected with ",
  StyleBox["!!", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! file.1\)\)], "Input",
  CellLabel->"In[3]:="],

Cell["{{1, 2, 3}, {4, 5, 6}}", "Print",
  CellLabel->"From In[3]:="]
}, Open  ]],

Cell[TextData[{
  "The file can be read back into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with ",
  StyleBox["Get", "MR"],
  ", entered using ",
  StyleBox["<<", "MR"],
  " as a short-cut notation."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< file.1\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{1, 2, 3}, {4, 5, 6}}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["\<\
This restores the matrix from the file so that it can be used for further \
computation.\
\>", "Text"],

Cell[TextData[{
  "Another way to do I/O on matrices in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is to use ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ". This is an interprocess communication mechanism that is particularly \
useful for communicating between different ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sessions."
}], "Text"],

Cell[TextData[{
  "Using ",
  StyleBox["Put", "MR"],
  " and ",
  StyleBox["Get", "MR"],
  " to store matrices in files is most useful if you want to save work from \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to be restored later. If you want to exchange matrices with other \
applications, data saved in general formats is more useful; this is described \
in the section ",
  ButtonBox["Import and Export of Matrices",
    ButtonData:>"t:21",
    ButtonStyle->"NotebookLink"],
  "."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Design Principles of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  CellTags->{"t:170", "c:5"}],

Cell[TextData[{
  "The support for linear algebra demonstrates a number of important ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " design principles."
}], "Text"],

Cell["\<\
It provides a wide range of functionality for technical computation.\
\>", "BulletText"],

Cell["\<\
It provides machine-precision computation that meets or surpasses the speed \
of dedicated machine-precision numerical applications.\
\>", "BulletText"],

Cell["\<\
It provides arbitrary-precision computation that is efficient enough to solve \
important classes of problems.\
\>", "BulletText"],

Cell["\<\
It integrates machine-precision and arbitrary-precision computation.\
\>", "BulletText"],

Cell[TextData[{
  "It integrates machine- and arbitrary-precision computation with symbolic \
computation so that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is suitable for many different solution techniques."
}], "BulletText"],

Cell[TextData[{
  "These design principles underpin much of the design of linear algebra \
functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  
  CounterBox["Chapter"],
  ". Matrix and Tensor Operations"
}], "Chapter",
  ShowCellBracket->True,
  CellTags->{"t:3", "c:6"}],

Cell[TextData[{
  "This chapter will review the functions that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides for building and working with matrices, vectors, and tensors. It \
will focus on functions that are specific to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and will use matrices for many of the examples. However, all of the \
functions are general, and they will also work for vectors and tensors."
}], "Text"],

Cell[CellGroupData[{

Cell["Building Matrices", "Section",
  CellTags->{"t:4", "c:7"}],

Cell[TextData[{
  "Matrices are represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with lists. They can be entered directly with the {  } notation that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides for lists. An example of a matrix is shown below; by default a \
matrix prints with the list notation. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1.5, 1.6}, {1.7, 1.8}}\)], "InputOnly",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({{1.5`, 1.6`}, {1.7`, 1.8`}}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides a number of ways to build matrices."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Table[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"build an \"\>", Cell[BoxData[
                        \(TraditionalForm\`m\[Cross]n\)], 
                      "InlineFormula"], "\<\" matrix where \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" is a function of \"\>", 
                    StyleBox["\<\"i\"\>",
                      "TI"], "\<\" and \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], "\<\" that gives the value of \"\>", Cell[
                    BoxData[
                        \(TraditionalForm\`i, j\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`\[Null]\^"th"\)], 
                      "InlineFormula"], "\<\" entry \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Array[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"build an \"\>", Cell[BoxData[
                        \(TraditionalForm\`m\[Cross]n\)], 
                      "InlineFormula"], "\<\" matrix whose \"\>", Cell[
                    BoxData[
                        \(TraditionalForm\`i, j\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`\[Null]\^"th"\)], 
                      "InlineFormula"], "\<\" entry is \"\>", \(f[i, 
                      j]\), "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"DiagonalMatrix[\"\>",
                      "MR"], 
                    StyleBox["\<\"list\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"build a diagonal matrix with the elements of \
\"\>", 
                    StyleBox["\<\"list\"\>",
                      "TI"], "\<\" on the diagonal \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"IdentityMatrix[\"\>",
                      "MR"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"build an \"\>", Cell[BoxData[
                        \(TraditionalForm\`n\[Cross]n\)], 
                      "InlineFormula"], "\<\" identity matrix \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Normal[SparseArray[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"->\"\>",
                      "MR"], Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"->\"\>",
                      "MR"], Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"build an\"\>", 
                    StyleBox["\<\"m\[Cross]n\"\>",
                      "TI"], "\<\" matrix with nonzero values \"\>", Cell[
                    BoxData[
                        \(TraditionalForm\`\[Nu]\_k\)], 
                      "InlineFormula"], "\<\" at positions \"\>", Cell[
                    BoxData[
                        \(TraditionalForm\`{i\_k, j\_k}\)], 
                      "InlineFormula"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.1"],

Cell[TextData[{
  "The function ",
  StyleBox["Table", "MR"],
  " is particularly important to generate matrices. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " documentation contains more information on ",
  ButtonBox["Table",
    ButtonStyle->"RefGuideLink"],
  ". In this example a 3\[Cross]3 matrix is built."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat = Table[m\_\(i, j\), {i, 3}, {j, 3}]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({{m\_\(1, 1\), m\_\(1, 2\), m\_\(1, 3\)}, {m\_\(2, 1\), m\_\(2, 2\), 
        m\_\(2, 3\)}, {m\_\(3, 1\), m\_\(3, 2\), m\_\(3, 3\)}}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["MatrixForm prints the matrix in a two-dimensional form.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[%]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  "Another way to build matrices in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is with the ",
  StyleBox["Array", "MR"],
  " command. Here it is used to build a 3\[Cross]3 matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[m, {3, 3}]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{m[1, 1], m[1, 2], m[1, 3]}, {m[2, 1], m[2, 2], m[2, 3]}, {m[3, 1], 
        m[3, 2], m[3, 3]}}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has a number of functions for building certain specialized matrices. This \
builds the identity matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IdentityMatrix[5]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({{1, 0, 0, 0, 0}, {0, 1, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 1, 
        0}, {0, 0, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "Note that the identity matrix that is generated is an integer matrix. If \
you want to compute with floating point numbers it can be advantageous to use \
matrices that contain floating point entries; this is described in more \
detail in the section ",
  ButtonBox["Performance: Matrix Contents",
    ButtonData:>"t:184",
    ButtonStyle->"NotebookLink"],
  ". If you start with an integer matrix, such as the identity matrix \
generated previously, it can be converted to a floating point matrix by using \
the function ",
  StyleBox["N", "MR"],
  ". This is shown in the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[IdentityMatrix[5]]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({{1.`, 0.`, 0.`, 0.`, 0.`}, {0.`, 1.`, 0.`, 0.`, 0.`}, {0.`, 0.`, 1.`, 
        0.`, 0.`}, {0.`, 0.`, 0.`, 1.`, 0.`}, {0.`, 0.`, 0.`, 0.`, 
        1.`}}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell["Here a diagonal matrix is constructed.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DiagonalMatrix[\ {1, 2, 3, 4}]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 2, 0, 0}, {0, 0, 3, 0}, {0, 0, 0, 4}}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "This makes a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]4\)], "InlineFormula"],
  " matrix with two nonzero values filled in. ",
  StyleBox["SparseArray", "MR"],
  " expressions are described in a later ",
  ButtonBox["section",
    ButtonData:>"t:28",
    ButtonStyle->"NotebookLink"],
  "."
}], "Text",
  CellTags->{"S3.7.1", "1.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Normal[
      SparseArray[{{2, 3} \[Rule] a, {3, 2} \[Rule] b}, {3, 4}]]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, a, 0}, {0, b, 0, 0}}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Table[0,\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a zero matrix "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Table[Random[\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"],\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a matrix with random numerical entries \
"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Table[If[\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], "\<\" \"\>", 
                    StyleBox["\<\">=\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"1,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"0],\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a lower\:f39ftriangular matrix "\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.1"],

Cell[TextData[{
  "Constructing special types of matrices with ",
  StyleBox["Table", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.7.1"],

Cell[TextData[{
  StyleBox["Table", "MR"],
  " evaluates ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " separately for each element, to give a different pseudorandom number in \
each case."
}], "Text",
  CellTags->{"S3.7.1", "1.8"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Random[], {3}, {3}]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({{0.4989646768680005`, 0.42591428589295416`, 
        0.8977544804664038`}, {0.4006128602064354`, 0.4716999551620189`, 
        0.7105887385900531`}, {0.9217796756126916`, 0.2577649816281045`, 
        0.42859916470276505`}}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SparseArray[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a zero matrix "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SparseArray[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\"_,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["_",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>", 
                    StyleBox["\<\"->\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"1,\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"an \"\>", Cell[BoxData[
                        \(TraditionalForm\`n\[Cross]n\)], 
                      "InlineFormula"], "\<\" identity matrix \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"SparseArray[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\"_,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox["_",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"/;\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\">=\"\>",
                      "MR"], 
                    StyleBox["\<\"j\"\>",
                      "TI"], "\<\" \"\>", 
                    StyleBox["\<\"->\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"1,\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a lower\:f39ftriangular matrix "\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.1"],

Cell[TextData[{
  "Constructing special types of matrices with ",
  StyleBox["SparseArray", "MR"],
  ". "
}], "Caption",
  CellTags->"S3.7.1"],

Cell["This sets up a general lower triangular matrix. ", "Text",
  CellTags->{"S3.7.1", "1.9"}],

Cell[CellGroupData[{

Cell["SparseArray[{i_, j_}/;i>=j -> f[i, j], {3, 3}] // MatrixForm", "Input",
  CellLabel->"In[10]:=",
  CellTags->"S3.7.1"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(f[1, 1]\), "0", "0"},
            {\(f[2, 1]\), \(f[2, 2]\), "0"},
            {\(f[3, 1]\), \(f[3, 2]\), \(f[3, 3]\)}
            }], "\[NoBreak]", ")"}],
      MatrixForm[ 
        SparseArray[ 
        Automatic, {3, 3}, 0, {1, {{0, 1, 3, 6}, {{1}, {1}, {2}, {3}, {1}, {
          2}}}, {
          f[ 1, 1], 
          f[ 2, 1], 
          f[ 2, 2], 
          f[ 3, 3], 
          f[ 3, 1], 
          f[ 3, 2]}}]]]], "Output",
  CellLabel->"Out[10]//MatrixForm=",
  CellTags->"S3.7.1"]
}, Open  ]],

Cell[TextData[{
  "Functions that can read in matrices from files are discussed in the \
section ",
  ButtonBox["Import and Export",
    ButtonData:>"t:21",
    ButtonStyle->"NotebookLink"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Special Matrices", "Subsection",
  CellTags->{"t:102", "c:8"}],

Cell[TextData[{
  "The standard package ",
  StyleBox["LinearAlgebra`MatrixManipulation`", "MR"],
  " contains definitions for a number of special matrices."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HilbertMatrix[\"\>",
                      "MR"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"create an \"\>", Cell[BoxData[
                        \(TraditionalForm\`n\[Cross]n\)], 
                      "InlineFormula"], "\<\" Hilbert matrix, with elements \
given by \"\>", Cell[BoxData[
                        \(TraditionalForm\`1/\((i + j - 1)\)\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HilbertMatrix[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"create an \"\>", Cell[BoxData[
                        \(TraditionalForm\`m\[Cross]n\)], 
                      "InlineFormula"], "\<\" Hilbert matrix\"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HankelMatrix[\"\>",
                      "MR"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"create an \"\>", Cell[BoxData[
                        \(TraditionalForm\`n\[Cross]n\)], 
                      "InlineFormula"], "\<\" Hankel matrix with the first \
column given by \"\>", Cell[BoxData[
                        \(TraditionalForm\`1\)], 
                      "InlineFormula"], \(\(,\)\(\ \)\), Cell[BoxData[
                        \(TraditionalForm\`2\)], 
                      "InlineFormula"], \(\(,\)\(\ \)\), Cell[BoxData[
                        \(TraditionalForm\`\[Ellipsis]\)], 
                      "InlineFormula"], \(\(,\)\(\ \)\), Cell[BoxData[
                        \(TraditionalForm\`n\)], 
                      "InlineFormula"], "\<\" and zeros beneath the main \
antidiagonal\"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HankelMatrix[\"\>",
                      "MR"], 
                    StyleBox["\<\"list\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"create a Hankel matrix with the first column \
given by \"\>", 
                    StyleBox["\<\"list\"\>",
                      
                      "TI"], "\<\" and zeros beneath the main \
antidiagonal\"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"HankelMatrix[\"\>",
                      "MR"], 
                    StyleBox["\<\"col\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"row\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"create a Hankel matrix with the first column \
given by the list \"\>", 
                    StyleBox["\<\"col\"\>",
                      "TI"], "\<\" and the last row given by the list \"\>", 
                    StyleBox["\<\"row\"\>",
                      "TI"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S5.48.1"],

Cell["Special matrices. ", "Caption",
  CellTags->"S5.48.1"],

Cell["You need to load the package to use its functions.", "Text"],

Cell[BoxData[
    \(Needs["\<LinearAlgebra`MatrixManipulation`\>"]\)], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]4\)], "InlineFormula"],
  " Hilbert matrix. "
}], "Text",
  CellTags->{"S5.48.1", "1.20"}],

Cell[CellGroupData[{

Cell["HilbertMatrix[2, 4]//MatrixForm", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S5.48.1"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", \(1\/2\), \(1\/3\), \(1\/4\)},
            {\(1\/2\), \(1\/3\), \(1\/4\), \(1\/5\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm=",
  CellTags->"S5.48.1"]
}, Open  ]],

Cell["The elements of the Hankel matrix can be given as a list. ", "Text",
  CellTags->{"S5.48.1", "1.21"}],

Cell[CellGroupData[{

Cell["HankelMatrix[{w, x, y, z}]//MatrixForm", "Input",
  CellLabel->"In[3]:=",
  CellTags->"S5.48.1"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"w", "x", "y", "z"},
            {"x", "y", "z", "0"},
            {"y", "z", "0", "0"},
            {"z", "0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm=",
  CellTags->"S5.48.1"]
}, Open  ]],

Cell["\<\
The Hankel matrix can be filled with nonzero values by giving the final row. \
This also allows a non\[Hyphen]square matrix to be generated. Note that the \
last element of the first column and the first element of the final row must \
be identical. \
\>", "Text",
  CellTags->{"S5.48.1", "1.22"}],

Cell[CellGroupData[{

Cell["HankelMatrix[{w, x, y, z}, {z, m, n}]//MatrixForm", "Input",
  CellLabel->"In[4]:=",
  CellTags->"S5.48.1"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"w", "x", "y"},
            {"x", "y", "z"},
            {"y", "z", "m"},
            {"z", "m", "n"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm=",
  CellTags->"S5.48.1"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Structural Operations", "Section",
  CellTags->{"t:6", "c:9"}],

Cell[TextData[{
  "These operations are all related to the structure of matrices. Many of the \
techniques shown in this section can be applied to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions and are not specific just to matrices."
}], "Text"],

Cell[CellGroupData[{

Cell["Getting Pieces of Matrices", "Subsection",
  CellTags->{"t:7", "c:10"}],

Cell[TextData[{
  "Extracting elements, rows, or columns of a matrix is quite straightforward \
with the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Part", "MR"],
  ". Typically ",
  StyleBox["Part", "MR"],
  " is entered with ",
  StyleBox["[[ ]]", "MR"],
  " notation."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"the \"\>", Cell[BoxData[
                        \(TraditionalForm\`i, j\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`\[Null]\^"th"\)], 
                      "InlineFormula"], "\<\" entry \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"the \"\>", Cell[BoxData[
                        \(TraditionalForm\`i\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`\[Null]\^"th"\)], 
                      "InlineFormula"], "\<\" row \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[All,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"the \"\>", Cell[BoxData[
                        \(TraditionalForm\`i\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`\[Null]\^"th"\)], 
                      "InlineFormula"], "\<\" column \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", 
                    StyleBox["\<\",\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], 
                            StyleBox["\<\"r\"\>",
                              "MIT"]], TraditionalForm]], "InlineFormula"], 
                    Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", 
                    StyleBox["\<\",\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], 
                            StyleBox["\<\"s\"\>",
                              "MIT"]], TraditionalForm]], "InlineFormula"], 
                    Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"the \"\>", Cell[BoxData[
                        \(TraditionalForm\`r\[Cross]s\)], 
                      "InlineFormula"], "\<\" submatrix with elements having \
row indices \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], 
                            StyleBox["\<\"k\"\>",
                              "MIT"]], TraditionalForm]], 
                      "InlineFormula"], "\<\" and column indices \"\>", Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], 
                            StyleBox["\<\"k\"\>",
                              "MIT"]], TraditionalForm]], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Tr[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"List]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"list of the diagonal elements of \"\>", 
                    StyleBox["m",
                      "MR"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.2"],

Cell["Ways to get pieces of matrices. ", "Caption",
  CellTags->"S3.7.2"],

Cell["Define the following matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = 
        Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "InputOnly",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell["This gets the second element in the first row.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([1, 2]\)]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \(m\_\(1, 2\)\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "This gets the ",
  Cell[BoxData[
      \(TraditionalForm\`3\^rd\)]],
  " row."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([3]\)]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({m\_\(3, 1\), m\_\(3, 2\), m\_\(3, 3\), m\_\(3, 4\), 
      m\_\(3, 5\)}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "It can also obtain a column by using ",
  StyleBox["All", "MR"],
  " to specify all rows."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([All, 3]\)]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({m\_\(1, 3\), m\_\(2, 3\), m\_\(3, 3\), m\_\(4, 3\), 
      m\_\(5, 3\)}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell["\<\
Negative indices are used to refer to the end of the matrix. The following \
gets the last element of the last row.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([\(-1\), \(-1\)]\)]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \(m\_\(5, 5\)\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Tr", "MR"],
  " works on the diagonal elements of a matrix. The one argument form adds \
them up."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tr[mat]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \(m\_\(1, 1\) + m\_\(2, 2\) + m\_\(3, 3\) + m\_\(4, 4\) + 
      m\_\(5, 5\)\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Tr", "MR"],
  " can also take a function, as its second argument, to apply to the \
diagonal elements. If ",
  StyleBox["List", "MR"],
  " is used this returns the diagonal elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tr[mat, List]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({m\_\(1, 1\), m\_\(2, 2\), m\_\(3, 3\), m\_\(4, 4\), 
      m\_\(5, 5\)}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "It should be noted that these commands for extracting parts of matrices \
will work for any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression."
}], "Text"],

Cell[CellGroupData[{

Cell["Getting Multiple Pieces", "Subsubsection",
  CellTags->"c:11"],

Cell["\<\
It is possible to extract multiple elements by using indices in lists. This \
will be demonstrated with the following sample matrix.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell["\<\
The following gets the first and third elements of the second row.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([2, {1, 3}]\)]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({m\_\(2, 1\), m\_\(2, 3\)}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell["The following gets the second and fourth rows.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([{2, 4}]\)]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{m\_\(2, 1\), m\_\(2, 2\), m\_\(2, 3\), m\_\(2, 4\), 
        m\_\(2, 5\)}, {m\_\(4, 1\), m\_\(4, 2\), m\_\(4, 3\), m\_\(4, 4\), 
        m\_\(4, 5\)}}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["\<\
The following gets the first and third elements of the second and fourth \
rows.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[\([{2, 4}, {1, 3}]\)]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({{m\_\(2, 1\), m\_\(2, 3\)}, {m\_\(4, 1\), m\_\(4, 3\)}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Pieces of Matrices", "Subsection",
  CellTags->{"t:9", "c:12"}],

Cell[TextData[{
  "Setting elements, rows, and columns so that a matrix is updated is quite \
straightforward using the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Part", "MR"],
  " on the left-hand side of an assignment."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], "\<\" \"\>", 
                    StyleBox["\<\"=\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"a\"\>",
                              "TI"], "\<\"11\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"a\"\>",
                              "TI"], "\<\"12\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"a\"\>",
                              "TI"], "\<\"21\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"a\"\>",
                              "TI"], "\<\"22\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]], 
            Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"assign \"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"], "\<\" to be a matrix \"\>"}], 
                  TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"=\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"v\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"reset element \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" to be \"\>", 
                    StyleBox["\<\"v\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"=\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"v\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"reset all elements in row \"\>", 
                    StyleBox["\<\"i\"\>",
                      "TI"], "\<\" to be \"\>", 
                    StyleBox["\<\"v\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"=\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]], 
            Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"reset elements in row \"\>", 
                    StyleBox["\<\"i\"\>",
                      "TI"], "\<\" to be \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[All,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"=\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"v\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"reset all elements in column \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], "\<\" to be \"\>", 
                    StyleBox["\<\"v\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"[[All,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], 
                    StyleBox["\<\"]]\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"=\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]], 
            Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"reset elements in column \"\>", 
                    StyleBox["\<\"j\"\>",
                      "TI"], "\<\" to be \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"v\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.2"],

Cell["Resetting parts of matrices. ", "Caption",
  CellTags->"S3.7.2"],

Cell["Here is a 5\[Cross]5 matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  "To update parts of a matrix you can use ",
  StyleBox["Part", "MR"],
  " on the left-hand side of an assignment."
}], "Text"],

Cell["This sets the third element of the third row.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([3, 3]\)] = x;\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), 
              "x", \(m\_\(3, 4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]],

Cell["This sets the second row to have a particular value.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([2]\)] = {1, 2, 3, 4, 5};\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"1", "2", "3", "4", "5"},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), 
              "x", \(m\_\(3, 4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//MatrixForm="]
}, Open  ]],

Cell["This sets the second column.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([All, 
            2]\)] = {\(-1\), \(-2\), \(-3\), \(-4\), \(-5\)};\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(-1\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"1", \(-2\), "3", "4", "5"},
            {\(m\_\(3, 1\)\), \(-3\), "x", \(m\_\(3, 4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(-4\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(-5\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[8]//MatrixForm="]
}, Open  ]],

Cell["\<\
It is also possible to use negative indices to count from the end of the \
matrix. The following example sets the last element of the last row.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([\(-1\), \(-1\)]\)] = x;\)\), "\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(-1\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"1", \(-2\), "3", "4", "5"},
            {\(m\_\(3, 1\)\), \(-3\), "x", \(m\_\(3, 4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(-4\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(-5\), \(m\_\(5, 3\)\), \(m\_\(5, 4\)\), "x"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[10]//MatrixForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Multiple Pieces", "Subsubsection",
  CellTags->"c:13"],

Cell["\<\
It is possible to set multiple elements by using indices in lists. This will \
be demonstrated with the following sample matrix.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second row.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([2, {1, 3}]\)] = x;\)\), "\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"x", \(m\_\(2, 2\)\), "x", \(m\_\(2, 4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]],

Cell["\<\
If the right-hand side of the assignment is a list that matches the number of \
elements being assigned, the assignment is done element by element. Thus, the \
following gives two different values for the first and third elements of the \
second row.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([2, {1, 3}]\)] = {x, y};\)\), "\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"x", \(m\_\(2, 2\)\), "y", \(m\_\(2, 4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//MatrixForm="]
}, Open  ]],

Cell["The following sets the second and fourth rows.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([{2, 4}]\)] = {1, 2, 3, 4, 5};\)\), "\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"1", "2", "3", "4", "5"},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {"1", "2", "3", "4", "5"},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[8]//MatrixForm="]
}, Open  ]],

Cell["\<\
The following gives two different values for the second and fourth rows.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([{2, 4}]\)] = {{1, 2, 3, 4, 
            5}, {\(-1\), \(-2\), \(-3\), \(-4\), \(-5\)}};\)\), "\
\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"1", "2", "3", "4", "5"},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(-1\), \(-2\), \(-3\), \(-4\), \(-5\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[10]//MatrixForm="]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second and fourth \
rows.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = 
        Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\[IndentingNewLine]", 
    \(\(mat[\([{2, 4}, {1, 3}]\)] = x;\)\), "\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"x", \(m\_\(2, 2\)\), "x", \(m\_\(2, 4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {"x", \(m\_\(4, 2\)\), "x", \(m\_\(4, 4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[13]//MatrixForm="]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second and fourth rows \
with different values.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat[\([{2, 4}, {1, 3}]\)] = {{a, b}, {c, 
            d}};\)\), "\[IndentingNewLine]", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {"a", \(m\_\(2, 2\)\), "b", \(m\_\(2, 4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {"c", \(m\_\(4, 2\)\), "d", \(m\_\(4, 4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[15]//MatrixForm="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extracting Submatrices", "Subsection",
  CellTags->{"t:8", "c:14"}],

Cell[TextData[{
  StyleBox["Take", "MR"],
  " is useful to extract a submatrix."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Take[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"extract the submatrix with rows \"\>", Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], "\<\" and columns \"\>", Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Take[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"extract the submatrix with rows \"\>", Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Take[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["All",
                      "MR"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"extract the submatrix with columns \"\>", Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.2"],

Cell["Extracting submatrices. ", "Caption",
  CellTags->"S3.7.2"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  "This extracts the submatrix from ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "MR",
            FontSlant->"Plain"], \(2, 1\)], TraditionalForm]]],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "MR",
            FontSlant->"Plain"], \(3, 2\)], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[mat, {2, 3}, {1, 2}] // MatrixForm\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell["This extracts the submatrix of rows 1 to 3.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[mat, {1, 3}] // MatrixForm\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]],

Cell["This extracts the submatrix of columns 2 to 4.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[mat, All, {2, 4}] // MatrixForm\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 4\)\)},
            {\(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 4\)\)},
            {\(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 4\)\)},
            {\(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 4\)\)},
            {\(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 4\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[5]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["n", "MR"],
  "egative indices to count from the end."
}], "Text"],

Cell["\<\
This returns the matrix with the first and last columns dropped.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[mat, All, {2, \(-2\)}] // MatrixForm\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 4\)\)},
            {\(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 4\)\)},
            {\(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 4\)\)},
            {\(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 4\)\)},
            {\(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 4\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//MatrixForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Deleting Rows and Columns", "Subsection",
  CellTags->{"t:179", "c:15"}],

Cell[TextData[{
  "If you want to delete rows or columns you can use ",
  StyleBox["Drop", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Drop[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], 
            RowBox[{"delete", " ", Cell[BoxData[
                  FormBox[
                    RowBox[{"\<\"rows \"\>", Cell[BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"i\"\>",
                                "TI"], "\<\"0\"\>"], TraditionalForm]], 
                        "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"i\"\>",
                                "TI"], "\<\"1\"\>"], TraditionalForm]], 
                        "InlineFormula"]}], TraditionalForm]]]}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Drop[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox[\({}\),
                      "MR"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], 
            RowBox[{"delete", " ", Cell[BoxData[
                  FormBox[
                    RowBox[{"\<\"columns \"\>", Cell[BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"j\"\>",
                                "TI"], "\<\"0\"\>"], TraditionalForm]], 
                        "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"j\"\>",
                                "TI"], "\<\"1\"\>"], TraditionalForm]], 
                        "InlineFormula"]}], TraditionalForm]]]}]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Drop[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"i\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"0\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"j\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], 
            RowBox[{"delete", " ", Cell[BoxData[
                  FormBox[
                    RowBox[{"\<\"rows \"\>", Cell[BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"i\"\>",
                                "TI"], "\<\"0\"\>"], TraditionalForm]], 
                        "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"i\"\>",
                                "TI"], "\<\"1\"\>"], TraditionalForm]], 
                        "InlineFormula"], "\<\" and columns \"\>", Cell[
                      BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"j\"\>",
                                "TI"], "\<\"0\"\>"], TraditionalForm]], 
                        "InlineFormula"], "\<\" through \"\>", Cell[BoxData[
                          FormBox[
                            SubscriptBox[
                              StyleBox["\<\"j\"\>",
                                "TI"], "\<\"1\"\>"], TraditionalForm]], 
                        "InlineFormula"], "\<\" \"\>"}], 
                    TraditionalForm]]]}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.2"],

Cell["Deleting rows and columns. ", "Caption",
  CellTags->"S3.7.2"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell["This drops rows 2 through 4.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[mat, {2, 4}] // MatrixForm\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell["This drops columns 2 through 4.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[mat, {}, {2, 4}] // MatrixForm\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]],

Cell["\<\
In this example rows 2 and 3, and columns 1, 2, and 3 are all dropped.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[mat, {2, 3}, {1, 3}] // MatrixForm\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(4, 4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[5]//MatrixForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inserting Rows and Columns", "Subsection",
  CellTags->{"t:223", "c:16"}],

Cell[TextData[{
  "If you want to insert a row, you can use ",
  StyleBox["Insert", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Insert[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"r\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"insert row\"\>", 
                    StyleBox["\<\"r\"\>",
                      "TI"], "\<\" into matrix \"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"], "\<\" at position \"\>", 
                    StyleBox["\<\"i\"\>",
                      "TI"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.3"],

Cell["Inserting a row. ", "Caption",
  CellTags->"S3.7.2"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[m\_\(i, j\), {i, 5}, {j, 5}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell["This inserts a row before row 3.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Insert[mat, {x, x, x, x, x}, 3] // MatrixForm\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), \(m\_\(2, 5\)\)},
            {"x", "x", "x", "x", "x"},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell["\<\
If you want to insert a column, you must transpose the matrix, insert the \
column as a row, and then transpose the matrix back. This inserts a column \
before column 5.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[Insert[Transpose[mat], {x, x, x, x, x}, 5]] // 
      MatrixForm\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(m\_\(1, 1\)\), \(m\_\(1, 2\)\), \(m\_\(1, 3\)\), \(m\_\(1, 
                  4\)\), "x", \(m\_\(1, 5\)\)},
            {\(m\_\(2, 1\)\), \(m\_\(2, 2\)\), \(m\_\(2, 3\)\), \(m\_\(2, 
                  4\)\), "x", \(m\_\(2, 5\)\)},
            {\(m\_\(3, 1\)\), \(m\_\(3, 2\)\), \(m\_\(3, 3\)\), \(m\_\(3, 
                  4\)\), "x", \(m\_\(3, 5\)\)},
            {\(m\_\(4, 1\)\), \(m\_\(4, 2\)\), \(m\_\(4, 3\)\), \(m\_\(4, 
                  4\)\), "x", \(m\_\(4, 5\)\)},
            {\(m\_\(5, 1\)\), \(m\_\(5, 2\)\), \(m\_\(5, 3\)\), \(m\_\(5, 
                  4\)\), "x", \(m\_\(5, 5\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extending Matrices", "Subsection",
  CellTags->{"t:10", "c:17"}],

Cell[TextData[{
  "You can increase the size of a matrix by padding it with ",
  StyleBox["PadLeft", "MR"],
  " and ",
  StyleBox["PadRight", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(mat = {{1, 2}, {3, 4}};\)\)], "InputOnly",
  CellLabel->"In[1]:="],

Cell[TextData[{
  StyleBox["PadLeft", "MR"],
  " adds the elements to the beginning of the matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadLeft[mat, {4, 4}] // MatrixForm\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "0", "0", "0"},
            {"0", "0", "0", "0"},
            {"0", "0", "1", "2"},
            {"0", "0", "3", "4"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  StyleBox["PadRight", "MR"],
  " adds the elements to the end of the matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadRight[mat, {4, 4}] // MatrixForm\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "0", "0"},
            {"3", "4", "0", "0"},
            {"0", "0", "0", "0"},
            {"0", "0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell["\<\
One important use of the padding functions is to replicate and tile a matrix. \
In this example the input matrix is extended to have two versions in every \
row and three in every column.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = {{1, 2, 3}, {4, 5, 6}};\)\), "\n", 
    \(PadRight[mat, {4, 9}, mat]\)}], "InputOnly",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{1, 2, 3, 1, 2, 3, 1, 2, 3}, {4, 5, 6, 4, 5, 6, 4, 5, 6}, {1, 2, 3, 1, 
        2, 3, 1, 2, 3}, {4, 5, 6, 4, 5, 6, 4, 5, 6}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // MatrixForm\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "3", "1", "2", "3", "1", "2", "3"},
            {"4", "5", "6", "4", "5", "6", "4", "5", "6"},
            {"1", "2", "3", "1", "2", "3", "1", "2", "3"},
            {"4", "5", "6", "4", "5", "6", "4", "5", "6"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[6]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  StyleBox["PadLeft", "MR"],
  " and ",
  StyleBox["PadRight", "MR"],
  " have a number of extra features and are completely general so that they \
work for arbitrary rank tensors. These are described in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " documentation."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose", "Subsection",
  CellTags->{"t:11", "c:18"}],

Cell["Transposition of elements is a general matrix operation.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = {{1, 2, 3}, {4, 5, 6}};\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "3"},
            {"4", "5", "6"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Transpose", "MR"],
  " swaps elements at specific indices."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[mat]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{1, 4}, {2, 5}, {3, 6}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // MatrixForm\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "4"},
            {"2", "5"},
            {"3", "6"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  "If you wish to compute the conjugate transpose of a matrix, you can \
combine the functions ",
  StyleBox["Transpose", "MR"],
  " and ",
  StyleBox["Conjugate", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = {{1. , \(-I\)}, {I, 10. }};\)\), "\n", 
    \(matCT = Conjugate[\ Transpose[mat]]\)}], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({{1.`, \(-\[ImaginaryI]\)}, {\[ImaginaryI], 10.`}}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell["\<\
If a matrix is equal to its conjugate transpose, it is said to be \
hermitian.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat === matCT\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotating Elements", "Subsection",
  CellTags->{"t:12", "c:19"}],

Cell[TextData[{
  "Another structural operation is to rotate elements within an index. This \
can be done with the functions ",
  StyleBox["RotateLeft", "MR"],
  " and ",
  StyleBox["RotateRight", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(m = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};\)\), "\n", 
    \(m // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "3"},
            {"4", "5", "6"},
            {"7", "8", "9"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell["\<\
This rotates left by one step in the first level, which operates on the rows.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RotateLeft[m, 1] // MatrixForm\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"4", "5", "6"},
            {"7", "8", "9"},
            {"1", "2", "3"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell["\<\
This rotates left by one step in the second level, which operates on the \
columns.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RotateLeft[m, {0, 1}] // MatrixForm\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"2", "3", "1"},
            {"5", "6", "4"},
            {"8", "9", "7"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]],

Cell["This rotates the columns in the opposite direction.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RotateRight[m, {0, 1}] // MatrixForm\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"3", "1", "2"},
            {"6", "4", "5"},
            {"9", "7", "8"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[5]//MatrixForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing Matrices", "Subsection",
  CellTags->{"t:13", "c:20"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides a number of functions for testing matrices and extracting size \
information."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MatrixQ[\"\>",
                      "MR"], 
                    StyleBox["\<\"expr\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"give \"\>", 
                    StyleBox["\<\"True\"\>",
                      "MR"], "\<\" if \"\>", 
                    StyleBox["\<\"expr\"\>",
                      "TI"], "\<\" has the form of a matrix, and \"\>", 
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" otherwise \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Dimensions[\"\>",
                      "MR"], 
                    StyleBox["\<\"expr\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a list of the dimensions of a vector or \
matrix "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["\<\"m\"\>",
                        "TI"], 
                      StyleBox["\<\"i\"\>",
                        "TI"]], 
                    StyleBox["\<\"==\"\>",
                      "MR"], 
                    SubscriptBox[
                      StyleBox["\<\"m\"\>",
                        "TI"], 
                      StyleBox["\<\"j\"\>",
                        "TI"]], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                \(TraditionalForm\`"compare elements of two matrices for \
equality "\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.3"],

Cell["\<\
Functions for testing the structure of vectors, matrices, and arrays. \
\>", "Caption",
  CellTags->"S3.7.3"],

Cell[TextData[{
  "If you want to test that an expression is a matrix, you can use the \
predicate ",
  StyleBox["MatrixQ", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[{{1, 2, 3}, {4, 5, 5}}]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell["The integer 5 is not a matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[\ 5]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["A matrix has to have the same lengths in every dimension.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[\ {{1, 2, 3}, {4, 5}}]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["MatrixQ", "MR"],
  " takes an optional second argument that specifies a test to apply to every \
element. In this example every element is tested to see if it is an integer."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[{{2, 2, 3}, {4, 5, 6}}, IntegerQ]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["\<\
In the example below every element must be an integer greater than 1.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[{{2, 2, 3}, {4, 5, 6}}, 
      IntegerQ[#]\  && \ # > 1\  &]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "The command ",
  StyleBox["Dimensions", "MR"],
  " is useful for extracting size information."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[{{1, 2, 3}, {4, 5, 6}}]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({2, 3}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "To compare if the elements of two matrices are equal, it is possible to \
use ",
  StyleBox["Equal", "MR"],
  ", typically entered using a ",
  StyleBox["==", "MR"],
  " short-cut notation. For example, comparing a matrix with itself returns \
",
  StyleBox["True", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat1 = {{1, 2}, {4, 5}};\)\), "\n", 
    \(mat1 \[Equal] mat1\)}], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Equal", "MR"],
  " uses the value of numbers so it can be used to compare integer and real \
values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat1 \[Equal] N[mat1]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
  "It should be noted that ",
  StyleBox["Equal", "MR"],
  " works on any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. If you want to compare two matrices for equality using \
properties of the matrix as a whole, it may be better to compare matrix \
norms. These are discussed in a ",
  ButtonBox["later",
    ButtonData:>"t:147",
    ButtonStyle->"NotebookLink"],
  " section."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further Structural Operations", "Subsection",
  CellTags->{"t:23", "c:21"}],

Cell["\<\
This section discusses some further structural operations that are useful for \
working with matrices.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Flatten[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"flatten out nested lists in\"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Flatten[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"flatten out nested lists in\"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"], "\<\"to level\"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Partition[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"partition\"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"], "\<\" into sublists of length \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Join[\"\>",
                      "MR"], Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"m\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox["\<\",\"\>",
                      "MR"], Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"m\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"concatenate\"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"m\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], "\<\" and \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"m\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Append[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"r\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"insert row\"\>", 
                    StyleBox["\<\"r\"\>",
                      "TI"], "\<\" at the end of \"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Prepend[\"\>",
                      "MR"], 
                    StyleBox["\<\"m\"\>",
                      "TI"], 
                    StyleBox["\<\",\"\>",
                      "MR"], 
                    StyleBox["\<\"r\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"insert row\"\>", 
                    StyleBox["\<\"r\"\>",
                      "TI"], "\<\" at the beginning of \"\>", 
                    StyleBox["\<\"m\"\>",
                      "TI"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.3"],

Cell["This generates a sample matrix for demonstration.", "Text"],

Cell[BoxData[
    \(\(mat = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};\)\)], "Input",
  CellLabel->"In[1]:="],

Cell["This flattens the matrix into a vector.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec = Flatten[mat]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  "Here the vector is partitioned back into a matrix with rows of length 4 \
using ",
  StyleBox["Partition", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[vec, 4]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{1, 2, 3, 4}, {5, 6, 7, 8}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "Matrices can be joined together with the function ",
  StyleBox["Join.", "MR"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Join[\ mat, mat]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, {1, 2, 3}, {4, 5, 6}, {7, 8, 
        9}}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "A new row can be inserted at the end of a matrix with ",
  StyleBox["Append", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Append[mat, {x, x, x}]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, {x, x, x}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "It should be noted that this can also be done with ",
  StyleBox["Insert", "MR"],
  "; see the section ",
  ButtonBox["Inserting Rows and Columns",
    ButtonData:>"t:223",
    ButtonStyle->"NotebookLink"],
  "."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Element-wise Operations", "Section",
  CellTags->{"t:15", "c:22"}],

Cell[TextData[{
  "If you want to operate on the elements of a matrix, you can do this easily \
with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". First, build a matrix of floating point numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[Random[], {i, 3}, {j, 3}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0.8242376793911093`", "0.1373696536974197`", 
              "0.7571451927717358`"},
            {"0.8042810578549265`", "0.5643991601262874`", 
              "0.9310522219837936`"},
            {"0.6656820208149531`", "0.29357707322550897`", 
              "0.6880213113568838`"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell["\<\
Arithmetic operations applied to a matrix thread down to work on each \
element. Thus, if 5 is added to the matrix, the result is equivalent to \
adding 5 to each element.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat + 5\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{5.824237679391109`, 5.137369653697419`, 
        5.757145192771736`}, {5.804281057854927`, 5.564399160126287`, 
        5.931052221983793`}, {5.665682020814953`, 5.293577073225509`, 
        5.688021311356884`}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell["Here, every element of the matrix is doubled.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2\ mat\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{1.6484753587822185`, 0.2747393073948394`, 
        1.5142903855434715`}, {1.608562115709853`, 1.1287983202525749`, 
        1.8621044439675871`}, {1.3313640416299062`, 0.5871541464510179`, 
        1.3760426227137676`}}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["Here, every element of the matrix is squared.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat\^2\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({{0.679367752128041`, 0.01887042175694902`, 
        0.5732688429373489`}, {0.6468680200242397`, 0.31854641195125866`, 
        0.8668582400609592`}, {0.4431325528362796`, 0.08618749792365585`, 
        0.47337332488124606`}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell["\<\
If one matrix is divided by another, the division is done element by element. \
If the dimensions of the two matrices do not agree, there is an error.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat^2/mat\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({{0.8242376793911093`, 0.1373696536974197`, 
        0.7571451927717358`}, {0.8042810578549265`, 0.5643991601262874`, 
        0.9310522219837936`}, {0.6656820208149531`, 0.2935770732255089`, 
        0.6880213113568838`}}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "To apply the ",
  StyleBox["Sin", "MR"],
  " function to every element, you apply ",
  StyleBox["Sin", "MR"],
  " to the entire matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[mat]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({{0.7340302909026167`, 0.13693802393356405`, 
        0.686849373511599`}, {0.7203321498732713`, 0.5349082568888571`, 
        0.8022485510613441`}, {0.6175956828003125`, 0.28937809686343985`, 
        0.6350098813992837`}}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["\<\
If both of the arguments of an operation are matrices, the operation is \
carried out on corresponding elements.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat\  + mat\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \({{1.6484753587822185`, 0.2747393073948394`, 
        1.5142903855434715`}, {1.608562115709853`, 1.1287983202525749`, 
        1.8621044439675871`}, {1.3313640416299062`, 0.5871541464510179`, 
        1.3760426227137676`}}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell["\<\
Note that the dimensions of the two matrices have to be compatible.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat + {{1, 2}, {2, 3}}\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    RowBox[{\(Thread::"tdlen"\), \(\(:\)\(\ \)\), "\<\"Objects of unequal \
length in \\!\\(\\(\\({\\(\\({0.8242376793911093`, \\(\\(\[LeftSkeleton] 19 \
\[RightSkeleton]\\)\\), \\(\\(\[LeftSkeleton] 19 \
\[RightSkeleton]\\)\\)}\\)\\), \\(\\({\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)}\\)\\), \\(\\({\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)}\\)\\)}\\)\\) \\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\
\\) \\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)\\) cannot be combined. \\!\
\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideNotebookLink\\\", ButtonFrame->None, \
ButtonData:>\\\"Thread::tdlen\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[9]:="],

Cell[BoxData[
    \({{1, 2}, {2, 3}} + {{0.8242376793911093`, 0.1373696536974197`, 
          0.7571451927717358`}, {0.8042810578549265`, 0.5643991601262874`, 
          0.9310522219837936`}, {0.6656820208149531`, 0.29357707322550897`, 
          0.6880213113568838`}}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
If one of the arguments is a matrix and the other is a vector, the operation \
is carried out between rows of the matrix and elements of the vector.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat + {x, y, z}\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \({{\(\(0.8242376793911093`\)\(\[InvisibleSpace]\)\) + 
          x, \(\(0.1373696536974197`\)\(\[InvisibleSpace]\)\) + 
          x, \(\(0.7571451927717358`\)\(\[InvisibleSpace]\)\) + 
          x}, {\(\(0.8042810578549265`\)\(\[InvisibleSpace]\)\) + 
          y, \(\(0.5643991601262874`\)\(\[InvisibleSpace]\)\) + 
          y, \(\(0.9310522219837936`\)\(\[InvisibleSpace]\)\) + 
          y}, {\(\(0.6656820208149531`\)\(\[InvisibleSpace]\)\) + 
          z, \(\(0.29357707322550897`\)\(\[InvisibleSpace]\)\) + 
          z, \(\(0.6880213113568838`\)\(\[InvisibleSpace]\)\) + 
          z}}\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "Note that the multiplication of two matrices using the operator ",
  StyleBox["Times", "MR"],
  " (typically this is entered by placing two arguments together) produces a \
matrix with elements that are products of the corresponding elements of the \
matrices. If you want to carry out matrix multiplication, this can be done \
with the function ",
  StyleBox["Dot", "MR"],
  " and is described in the section ",
  ButtonBox["Matrix Multiplication",
    ButtonData:>"t:24",
    ButtonStyle->"NotebookLink"],
  ".  An example of element-wise multiplication is shown in the following \
example."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat1 = {{1, 2}, \ {3, 4}};\)\), "\[IndentingNewLine]", 
    \(\(mat2 = \ {{2, 2}, \ {3, 3}};\)\), "\[IndentingNewLine]", 
    \(mat1\ \ mat2\)}], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \({{2, 4}, {9, 12}}\)], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listability", "Subsection",
  CellTags->{"t:16", "c:23"}],

Cell[TextData[{
  "If you want to apply your own function to each element in a matrix, you \
may do this by giving your function the attribute ",
  StyleBox["Listable", "MR"],
  ". This function squares each element and divides the result by 3."
}], "Text"],

Cell[BoxData[{
    \(\(SetAttributes[fun, Listable];\)\), "\n", 
    \(fun[x_] := x^2/3\)}], "InputOnly",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(\(mat = {{1. , 4. }, {4. , 5. }};\)\)], "InputOnly",
  CellLabel->"In[3]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(fun[\ mat]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({{0.3333333333333333`, 5.333333333333333`}, {5.333333333333333`, 
        8.333333333333332`}}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["\<\
Of course, the function will still work with symbolic matrices.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fun[{{1, 2}, {x, 4}}]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({{1\/3, 4\/3}, {x\^2\/3, 16\/3}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "More information on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming can be found in ",
  StyleBox["The",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Book",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Map", "Subsection",
  CellTags->{"t:17", "c:24"}],

Cell[TextData[{
  "Instead of using listability you can use ",
  StyleBox["Map", "MR"],
  " to apply a function to every element in a matrix."
}], "Text"],

Cell[BoxData[
    \(\(mat\  = \ {{1. , 4. }, {4. , 5. }};\)\)], "InputOnly",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "This says that the function ",
  StyleBox["f", "MR"],
  " should be applied to every element in the matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[f, mat, {\(-1\)}]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({{f[1.`], f[4.`]}, {f[4.`], f[5.`]}}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["\<\
Here, a function that squares its argument and divides the result by 3 is \
applied to every element in the matrix.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[#^2/3\  &, mat, {\(-1\)}]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{0.3333333333333333`, 5.333333333333333`}, {5.333333333333333`, 
        8.333333333333332`}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "More information on ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming can be found in ",
  StyleBox["The",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Book",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Vectors and Tensors", "Section",
  CellTags->{"t:18", "c:25"}],

Cell[TextData[{
  "In addition to supporting matrices, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " supports vectors and tensors. All of these are built from lists. As \
described in the ",
  ButtonBox["Introduction",
    ButtonData:>"t:190",
    ButtonStyle->"NotebookLink"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the term tensor to refer to generalized matrices. All the operations \
for building matrices can be generalized to work for vectors and tensors. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " vectors have one level of list. Here a vector is constructed."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec = {1, 2, 3}\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell["\<\
In addition, there are a number of functions that generate vectors.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Table[\"\>",
                      "MR"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"i\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"build a length\[Hyphen]\"\>", Cell[BoxData[
                        FormBox[
                          StyleBox["n",
                            "TI"], TraditionalForm]], 
                      "InlineFormula"], "\<\" vector by evaluating \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" with \"\>", 
                    StyleBox["\<\"i\"\>",
                      "TI"], "\<\" \"\>", 
                    StyleBox["\<\"=\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"1\"\>",
                      "MR"], \(\(,\)\(\ \)\), 
                    StyleBox["\<\"2\"\>",
                      "MR"], \(\(,\)\(\ \)\(\[Ellipsis]\)\(\ \)\(,\)\(\ \)\), 
                    
                    StyleBox["\<\"n\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Array[\"\>",
                      "MR"], 
                    StyleBox["\<\"a\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"build a length\[Hyphen]\"\>", Cell[BoxData[
                        FormBox[
                          StyleBox["n",
                            "TI"], TraditionalForm]], 
                      "InlineFormula"], "\<\" vector of the form \"\>", Cell[
                    BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"a\"\>",
                      "TI"], 
                    StyleBox["\<\"[1],\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"a\"\>",
                      "TI"], 
                    StyleBox["\<\"[2],\"\>",
                      "MR"], "\<\" \[Ellipsis] \"\>", Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Range[\"\>",
                      "MR"], 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"create the list \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"1,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"2,\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"3,\"\>",
                      "MR"], "\<\" \[Ellipsis] \"\>", 
                    StyleBox["\<\",\"\>",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Range[\"\>",
                      "MR"], Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"create the list \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox["\<\"+1,\"\>",
                      "MR"], "\<\" \[Ellipsis] \"\>", 
                    StyleBox["\<\",\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Range[\"\>",
                      "MR"], Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"dn\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"create the list \"\>", Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], Cell[
                    BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"1\"\>"], TraditionalForm]], 
                      "InlineFormula"], 
                    StyleBox["+",
                      "MR"], 
                    StyleBox["\<\"dn\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \[Ellipsis] \"\>", 
                    StyleBox["\<\",\"\>",
                      "MR"], "\<\" \"\>", Cell[BoxData[
                        FormBox[
                          SubscriptBox[
                            StyleBox["\<\"n\"\>",
                              "TI"], "\<\"2\"\>"], TraditionalForm]], 
                      "InlineFormula"], Cell[BoxData[
                        \(TraditionalForm\`}\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, False, False, False, True, False}},
  CellTags->"S1.8.3"],

Cell["Functions for generating vectors. ", "Caption",
  CellTags->"S1.8.3"],

Cell[TextData[{
  "One very efficient way to generate a vector is to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Range", "MR"],
  ". This generates a vector of integers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[10]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["\<\
This generates a vector of reals, starting with 1., incrementing in 0.1, and \
ending at 4.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[1. , 4, 0.1]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({1.`, 1.1`, 1.2`, 1.3`, 1.4`, 1.5`, 1.6`, 1.7`, 1.8`, 
      1.9000000000000001`, 2.`, 2.1`, 2.2`, 2.3000000000000003`, 2.4`, 2.5`, 
      2.6`, 2.7`, 2.8000000000000003`, 2.9`, 3.`, 3.1`, 3.2`, 
      3.3000000000000003`, 3.4000000000000004`, 3.5`, 3.6`, 3.7`, 
      3.8000000000000003`, 3.9000000000000004`, 4.`}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Table", "MR"],
  " can also be used to programmatically construct a vector; this is \
particularly useful if you want to execute a function to determine the \
elements of the vector."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec = Table[Random[], {5}]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({0.3976484374584866`, 0.5998822639434546`, 0.6372653914596241`, 
      0.8193615754446475`, 0.46850247508247134`}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell["\<\
The operations and functions discussed in previous sections have equivalent \
versions for vectors.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec\  + 4\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({4.3976484374584865`, 4.599882263943455`, 4.637265391459624`, 
      4.819361575444647`, 4.468502475082471`}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec[\([2]\)]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \(0.5998822639434546`\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vec[\([4]\)] = x;\)\), "\n", 
    \(vec\)}], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({0.3976484374584866`, 0.5998822639434546`, 0.6372653914596241`, x, 
      0.46850247508247134`}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "It should be noted that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has no concept of a row or a column vector; a vector has a single index \
that can be used to reference an element of the vector."
}], "Text"],

Cell[TextData[{
  "Tensors can also be built using the ",
  StyleBox["Table", "MR"],
  " command. Here, three iterators are used to generate a 2\[Cross]3\[Cross]4 \
tensor."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tensor = Table[Random[], {2}, {3}, {4}]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({{{0.20211613926207156`, 0.059081041642037334`, 0.9904194580495908`, 
          0.8480807531664433`}, {0.47793527576096734`, 0.3376000882268081`, 
          0.20246002518546408`, 0.2887131559973494`}, {0.048374447072186987`, 
          0.5894792344368095`, 0.1098431611379648`, 
          0.5146276172370138`}}, {{0.7869750042810342`, 0.4471300166074152`, 
          0.03506049751096116`, 0.6607932572693415`}, {0.7148067580383081`, 
          0.9947741412964775`, 0.664911438342428`, 
          0.26314481981085486`}, {0.11492449409485347`, 0.3575087498368532`, 
          0.8455498628977807`, 0.7946423447283835`}}}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
  "One can extract an element by using ",
  StyleBox["Part", "MR"],
  " with three indices."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tensor[\([1, 2, 1]\)]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(0.47793527576096734`\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing Vectors and Tensors", "Subsection",
  CellTags->"c:26"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides a number of functions for testing vectors and tensors and \
extracting size information."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"VectorQ[\"\>",
                      "MR"], 
                    StyleBox["\<\"expr\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"give \"\>", 
                    StyleBox["\<\"True\"\>",
                      "MR"], "\<\" if \"\>", 
                    StyleBox["\<\"expr\"\>",
                      "TI"], "\<\" has the form of a vector, and \"\>", 
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" otherwise \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MatrixQ[\"\>",
                      "MR"], 
                    StyleBox["\<\"expr\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"give \"\>", 
                    StyleBox["\<\"True\"\>",
                      "MR"], "\<\" if \"\>", 
                    StyleBox["\<\"expr\"\>",
                      "TI"], "\<\" has the form of a matrix, and \"\>", 
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" otherwise \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ArrayQ[\"\>",
                      "MR"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"test whether \"\>", 
                    StyleBox["\<\"t\"\>",
                      "TI"], "\<\" is a tensor of rank \"\>", 
                    StyleBox["\<\"n\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Dimensions[\"\>",
                      "MR"], 
                    StyleBox["\<\"expr\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"a list of the dimensions of a vector or \
matrix "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ArrayDepth[\"\>",
                      "MR"], 
                    StyleBox["\<\"t\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"find the rank of a tensor "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["\<\"t\"\>",
                        "TI"], 
                      StyleBox["\<\"i\"\>",
                        "TI"]], 
                    StyleBox["\<\"==\"\>",
                      "MR"], 
                    SubscriptBox[
                      StyleBox["\<\"t\"\>",
                        "TI"], 
                      StyleBox["\<\"j\"\>",
                        "TI"]], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                \(TraditionalForm\`"compare elements of two tensors for \
equality "\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.3"],

Cell["\<\
Functions for testing the structure of vectors, matrices, and arrays. \
\>", "Caption",
  CellTags->"S3.7.3"],

Cell[TextData[{
  "If you want to test that an expression is a matrix you can use the \
predicate ",
  StyleBox["MatrixQ", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[{{1, 2, 3}, {4, 5, 5}}]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell[TextData[{
  "In addition to ",
  StyleBox["MatrixQ", "MR"],
  ", ",
  StyleBox["VectorQ", "MR"],
  " and ",
  StyleBox["ArrayQ", "MR"],
  " are useful for testing vectors and tensors."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(VectorQ[{1, 2, 3}]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\ {{{1, 2}, {3, 4}}, {{4, 5}, {6, 7}}}]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["ArrayQ", "MR"],
  " can also take a rank argument to test the depth of the array."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\ {{{1, 2}, {3, 4}}, {{4, 5}, {6, 7}}}, \ 3]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["ArrayQ", "MR"],
  " also takes a third argument that tests each element. In this example the \
result is ",
  StyleBox["False", "MR"],
  " because not all the elements are ",
  StyleBox["NumberQ", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayQ[\ {{{x, 2}, {3, 4}}, {{4, 5}, {6, 7}}}, \ 3, NumberQ]\)], "Input",\

  CellLabel->"In[5]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "The command ",
  StyleBox["Dimensions", "MR"],
  " is useful for extracting size information."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[{{{1, 2}, {3, 4}}, {{4, 5}, {6, 7}}}]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({2, 2, 2}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Dimensions", "MR"],
  " returns a list of length 2 when the input is a matrix, stating that two \
indices are used to reference any element in the matrix. Another way to test \
the number of indices required to reference elements is with ",
  StyleBox["ArrayDepth", "MR"],
  ". In this example the result is 2."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArrayDepth[\ {{1, 2, 3}, {4, 5, 6}}]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "To compare if the elements of two tensors are equal it is possible to use \
",
  StyleBox["Equal", "MR"],
  ", typically entered using a ",
  StyleBox["==", "MR"],
  " short-cut notation. For example, comparing a tensor with itself returns \
",
  StyleBox["True", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ten = {{{1, 2}, {3, 4}}, {{4, 5}, {6, 7}}};\)\), "\n", 
    \(ten \[Equal] ten\)}], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Equal", "MR"],
  " uses the value of numbers so it can be used to compare integer and real \
values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ten \[Equal] N[ten]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell["\<\
If the structure of two objects does not match they are not equal.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ten \[Equal] {1, 2, 3}\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualization of Matrices", "Section",
  CellTags->{"t:19", "c:27"}],

Cell["\<\
This section reviews the functions that are available for formatting and \
plotting matrices.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MatrixForm[\"\>",
                      "MR"], 
                    StyleBox["\<\"mat\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"print a matrix with the elements arranged \
in a two\[Hyphen]dimensional array "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MatrixPlot[\"\>",
                      "MR"], 
                    StyleBox["\<\"mat\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"show the structural pattern of \"\>", 
                    StyleBox["\<\"mat\"\>",
                      "TI"]}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MatrixPlot[\"\>",
                      "MR"], 
                    StyleBox["\<\"mat\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"cen\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"show \"\>", 
                    StyleBox["\<\"mat\"\>",
                      "TI"], "\<\" with center value \"\>", 
                    StyleBox["\<\"cen\"\>",
                      "TI"]}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.3"],

Cell[CellGroupData[{

Cell["Formatting Matrices", "Subsection",
  CellTags->{"t:20", "c:28"}],

Cell[TextData[{
  "Matrices can be formatted with the function ",
  StyleBox["MatrixForm", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = {{a, b}, {c, d}};\)\), "\n", 
    \(MatrixForm[mat]\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "b"},
            {"c", "d"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  StyleBox["MatrixForm", "MR"],
  " also works for vectors and higher rank tensors; the braces can help to \
understand the grouping."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[\ Array[\ m, \ {3, 2, 4, 2}]]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(m[1, 1, 1, 1]\), \(m[1, 1, 1, 2]\)},
                    {\(m[1, 1, 2, 1]\), \(m[1, 1, 2, 2]\)},
                    {\(m[1, 1, 3, 1]\), \(m[1, 1, 3, 2]\)},
                    {\(m[1, 1, 4, 1]\), \(m[1, 1, 4, 2]\)}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(m[1, 2, 1, 1]\), \(m[1, 2, 1, 2]\)},
                    {\(m[1, 2, 2, 1]\), \(m[1, 2, 2, 2]\)},
                    {\(m[1, 2, 3, 1]\), \(m[1, 2, 3, 2]\)},
                    {\(m[1, 2, 4, 1]\), \(m[1, 2, 4, 2]\)}
                    }], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(m[2, 1, 1, 1]\), \(m[2, 1, 1, 2]\)},
                    {\(m[2, 1, 2, 1]\), \(m[2, 1, 2, 2]\)},
                    {\(m[2, 1, 3, 1]\), \(m[2, 1, 3, 2]\)},
                    {\(m[2, 1, 4, 1]\), \(m[2, 1, 4, 2]\)}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(m[2, 2, 1, 1]\), \(m[2, 2, 1, 2]\)},
                    {\(m[2, 2, 2, 1]\), \(m[2, 2, 2, 2]\)},
                    {\(m[2, 2, 3, 1]\), \(m[2, 2, 3, 2]\)},
                    {\(m[2, 2, 4, 1]\), \(m[2, 2, 4, 2]\)}
                    }], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(m[3, 1, 1, 1]\), \(m[3, 1, 1, 2]\)},
                    {\(m[3, 1, 2, 1]\), \(m[3, 1, 2, 2]\)},
                    {\(m[3, 1, 3, 1]\), \(m[3, 1, 3, 2]\)},
                    {\(m[3, 1, 4, 1]\), \(m[3, 1, 4, 2]\)}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {\(m[3, 2, 1, 1]\), \(m[3, 2, 1, 2]\)},
                    {\(m[3, 2, 2, 1]\), \(m[3, 2, 2, 2]\)},
                    {\(m[3, 2, 3, 1]\), \(m[3, 2, 3, 2]\)},
                    {\(m[3, 2, 4, 1]\), \(m[3, 2, 4, 2]\)}
                    }], "\[NoBreak]", ")"}]}
            }], "\[NoBreak]", ")"}],
      MatrixForm[ {{{{
        m[ 1, 1, 1, 1], 
        m[ 1, 1, 1, 2]}, {
        m[ 1, 1, 2, 1], 
        m[ 1, 1, 2, 2]}, {
        m[ 1, 1, 3, 1], 
        m[ 1, 1, 3, 2]}, {
        m[ 1, 1, 4, 1], 
        m[ 1, 1, 4, 2]}}, {{
        m[ 1, 2, 1, 1], 
        m[ 1, 2, 1, 2]}, {
        m[ 1, 2, 2, 1], 
        m[ 1, 2, 2, 2]}, {
        m[ 1, 2, 3, 1], 
        m[ 1, 2, 3, 2]}, {
        m[ 1, 2, 4, 1], 
        m[ 1, 2, 4, 2]}}}, {{{
        m[ 2, 1, 1, 1], 
        m[ 2, 1, 1, 2]}, {
        m[ 2, 1, 2, 1], 
        m[ 2, 1, 2, 2]}, {
        m[ 2, 1, 3, 1], 
        m[ 2, 1, 3, 2]}, {
        m[ 2, 1, 4, 1], 
        m[ 2, 1, 4, 2]}}, {{
        m[ 2, 2, 1, 1], 
        m[ 2, 2, 1, 2]}, {
        m[ 2, 2, 2, 1], 
        m[ 2, 2, 2, 2]}, {
        m[ 2, 2, 3, 1], 
        m[ 2, 2, 3, 2]}, {
        m[ 2, 2, 4, 1], 
        m[ 2, 2, 4, 2]}}}, {{{
        m[ 3, 1, 1, 1], 
        m[ 3, 1, 1, 2]}, {
        m[ 3, 1, 2, 1], 
        m[ 3, 1, 2, 2]}, {
        m[ 3, 1, 3, 1], 
        m[ 3, 1, 3, 2]}, {
        m[ 3, 1, 4, 1], 
        m[ 3, 1, 4, 2]}}, {{
        m[ 3, 2, 1, 1], 
        m[ 3, 2, 1, 2]}, {
        m[ 3, 2, 2, 1], 
        m[ 3, 2, 2, 2]}, {
        m[ 3, 2, 3, 1], 
        m[ 3, 2, 3, 2]}, {
        m[ 3, 2, 4, 1], 
        m[ 3, 2, 4, 2]}}}}]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting Matrices", "Subsection",
  CellTags->{"t:22", "c:29"}],

Cell[TextData[{
  "A convenient way to plot matrices is with the function ",
  StyleBox["MatrixPlot", "MR"],
  ". It is defined in the package ",
  StyleBox["LinearAlgebra`MatrixManipulation`", "MR"],
  ". First, the package must be loaded."
}], "Text"],

Cell[BoxData[
    \(Needs["\<LinearAlgebra`MatrixManipulation`\>"]\)], "Input",
  CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(mat = Table[\ Random[Integer], {10}, {10}];\)\), "\n", 
    \(mat // MatrixForm\)}], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "0", "1", "1", "0", "0", "0", "0", "1", "1"},
            {"1", "0", "0", "1", "0", "0", "1", "1", "1", "1"},
            {"1", "0", "0", "0", "1", "1", "1", "0", "0", "0"},
            {"0", "1", "0", "0", "0", "1", "1", "0", "1", "1"},
            {"1", "1", "0", "0", "0", "0", "1", "0", "0", "0"},
            {"0", "0", "0", "0", "1", "0", "1", "0", "1", "1"},
            {"0", "1", "0", "0", "1", "1", "0", "0", "0", "1"},
            {"0", "0", "1", "1", "1", "1", "0", "0", "1", "1"},
            {"1", "0", "1", "1", "1", "0", "1", "0", "1", "0"},
            {"1", "1", "0", "1", "1", "0", "0", "0", "1", "1"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MatrixPlot[mat];\)\)], "Input",
  CellLabel->"In[4]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0288462 0.0961538 1.02885 0.0961538 [
[.16346 -0.0125 -3 -9 ]
[.16346 -0.0125 3 0 ]
[.35577 -0.0125 -3 -9 ]
[.35577 -0.0125 3 0 ]
[.54808 -0.0125 -3 -9 ]
[.54808 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.93269 -0.0125 -6 -9 ]
[.93269 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .06731 -12 -4.5 ]
[-0.0125 .06731 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .45192 -6 -4.5 ]
[-0.0125 .45192 0 4.5 ]
[-0.0125 .64423 -6 -4.5 ]
[-0.0125 .64423 0 4.5 ]
[-0.0125 .83654 -6 -4.5 ]
[-0.0125 .83654 0 4.5 ]
[ 0 0 -0.125 0 ]
[.16346 1.0125 -3 0 ]
[.16346 1.0125 3 9 ]
[.35577 1.0125 -3 0 ]
[.35577 1.0125 3 9 ]
[.54808 1.0125 -3 0 ]
[.54808 1.0125 3 9 ]
[.74038 1.0125 -3 0 ]
[.74038 1.0125 3 9 ]
[.93269 1.0125 -6 0 ]
[.93269 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .06731 0 -4.5 ]
[1.0125 .06731 12 4.5 ]
[1.0125 .25962 0 -4.5 ]
[1.0125 .25962 6 4.5 ]
[1.0125 .45192 0 -4.5 ]
[1.0125 .45192 6 4.5 ]
[1.0125 .64423 0 -4.5 ]
[1.0125 .64423 6 4.5 ]
[1.0125 .83654 0 -4.5 ]
[1.0125 .83654 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16346 0 m
.16346 .00625 L
s
[(2)] .16346 -0.0125 0 1 Mshowa
.35577 0 m
.35577 .00625 L
s
[(4)] .35577 -0.0125 0 1 Mshowa
.54808 0 m
.54808 .00625 L
s
[(6)] .54808 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(8)] .74038 -0.0125 0 1 Mshowa
.93269 0 m
.93269 .00625 L
s
[(10)] .93269 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .06731 m
.00625 .06731 L
s
[(10)] -0.0125 .06731 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(8)] -0.0125 .25962 1 0 Mshowa
0 .45192 m
.00625 .45192 L
s
[(6)] -0.0125 .45192 1 0 Mshowa
0 .64423 m
.00625 .64423 L
s
[(4)] -0.0125 .64423 1 0 Mshowa
0 .83654 m
.00625 .83654 L
s
[(2)] -0.0125 .83654 1 0 Mshowa
0 0 m
0 1 L
s
.16346 .99375 m
.16346 1 L
s
[(2)] .16346 1.0125 0 -1 Mshowa
.35577 .99375 m
.35577 1 L
s
[(4)] .35577 1.0125 0 -1 Mshowa
.54808 .99375 m
.54808 1 L
s
[(6)] .54808 1.0125 0 -1 Mshowa
.74038 .99375 m
.74038 1 L
s
[(8)] .74038 1.0125 0 -1 Mshowa
.93269 .99375 m
.93269 1 L
s
[(10)] .93269 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .06731 m
1 .06731 L
s
[(10)] 1.0125 .06731 -1 0 Mshowa
.99375 .25962 m
1 .25962 L
s
[(8)] 1.0125 .25962 -1 0 Mshowa
.99375 .45192 m
1 .45192 L
s
[(6)] 1.0125 .45192 -1 0 Mshowa
.99375 .64423 m
1 .64423 L
s
[(4)] 1.0125 .64423 -1 0 Mshowa
.99375 .83654 m
1 .83654 L
s
[(2)] 1.0125 .83654 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
10 string
10 10 8 [10 0 0 10 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FF0000FFFFFF0000
00FF000000FF00FF00FF
FFFF00000000FFFF0000
FF00FFFF0000FFFFFF00
FFFFFFFF00FF00FF0000
0000FFFFFFFF00FFFFFF
FF00FFFFFF0000FF0000
00FFFFFF000000FFFFFF
00FFFF00FFFF00000000
00FF0000FFFFFFFF0000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00D@3oool00`3ookl0M000000000040000000307Boo`3oool0oooo04<0
oooo00D0omnL04P000000000000007Boo`150?ooo`050;md0000000000000000M02oool0A03oool0
1@2oM000000000000000000007Bo0400oooo00<0okmd0000000000000`0000001@00M;l0oooo0?oo
o`3oool0okmd00<0000000<0M;oo0?ooo`3oool0:@3oool00580oooo00<0_g@00000M02oool00P3o
ool00`3OW7@0W=oo0?ooo`160?ooo`030;md001d_ol0oooo04@0oooo00H0gia8001d_`3oool0oooo
0?noM000M;m30?ooo`030?noM000M;l0oooo0080oooo00<0_gA809cOo`3oool0@@3oool00`2LB4P0
W=oo0?ooo`040?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo:P3oool005<0oooo00<0okmd0000
B02Lgol0BP3oool00`2oM000M;oo0?ooo`130?ooo`030?oo_`1d0000M;oo0080oooo00<0oono07A8
W03oool0@P3oool00`3OW4P0B9cO0?ooo`020?ooo`030;md001d_ol0oooo0440oooo00<0W4Q809cO
o`3oool00`3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo02T0oooo001D0?ooo`03
0?oOW0180000B9cO04D0oooo00<0gia80000000000000`0000000`1d_ol0oooo0?ooo`110?ooo`07
0?noM000B4P0M01d0;ooo`3oool0gia8001d_`130?ooo`030?noM000B9`0oooo0080oooo00<0W4Q8
09cOo`3oool0@@3oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd
001d_`3oool0:@3oool005H0oooo00<0W4P004RLg`3oool0@`3oool01P3o_g@0001d0;ooo`3oool0
_g@007Bood@0oooo00<0omnL04Q8W03o_g@00P0000000`00B9`0oooo0?ooo`130?ooo`050=nLB000
0000000000000018W=l0@`3oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo
00<0okmd001d_`3oool0:@3oool005L0oooo00<0W4Qd0;ooo`3oool0@`3oool01@3OW4P007Bo0?oo
o`2oM000M;oo04@0oooo00<0oono07@0M02oool0A`3oool00`3ookl0M4RL0?ooo`020?ooo`0309a8
M02oool0oooo0440oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?no
M000M;l0oooo02T0oooo001B0?ooo`030=nLB01d_ol0oooo0080oooo00<0_g@007Boo`3oool0A03o
ool0102LB000B9cO0;md001d_om50?ooo`030;md0018W=l0oooo04H0oooo00<0okmd04RLg`3oool0
0P3oool00`2oM000M;oo0?ooo`110?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd04RLg`3oool0
0P3oool00`3OW4P0B9cO0?ooo`0Y0?ooo`00DP3oool01`3o_g@0001d0;ooo`3oool0okmd0000B02L
gol0A@3oool0103ogi`0B01804Q8001d_om50?ooo`030?oo_`1d000007Bo04H0oooo00L0omnL04P0
M02oool0oooo0?oOW01807@0_ooo03l0oooo00D0gia800000000B9`0W4Q809cOo`050?ooo`0609a8
001d_ol0oooo0?oOW01807@0_ooo:P3oool005<0oooo00D0okmd000000000000001809cOo`170?oo
o`030?noM0000000M;oo04L0oooo00@0_g@000000000000004RLA03oool01@3o_g@0000000000000
04P0W=oo0480oooo00<0gia80000B02Lgol01@3oool01@3ookl0M0000000000004P0W=oo02/0oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo000F0?ooool00000Q000000G0?ooo`005P3oool00`000000
oooo0?ooo`0l0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`170?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`0l0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?oo
o`170?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3o
oon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooBP00000U
ooooodX00000L?oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3ooom:000002GoooooBP00001`ooooodX000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooodX000009Ooooom:0000073oooooBP0000070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooBP00000UooooodX00000
L?oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oom:000002GoooooBP00001`ooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooodX000009Ooooom:0000073oooooBP0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooBP00000UooooodX00000L?oooom:0000
00L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000002Go
ooooBP00001`ooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?ooodX000009Ooooom:0000073oooooBP0000070?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00D0ooooBP00000UooooodX00000L?oooom:000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000002GoooooBP00001`
ooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oo
odX000009Ooooom:0000073oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0ooooBP00000UooooodX00000L?oooom:000000L0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000002GoooooBP00001`ooooodX00000
1`3oool00`000000oooo0?ooo`0E0?ooo`0000<0oooo0?noM0000000100000001@00M;l0oooo0?oo
o`3oool0okmd00<0000000<0M;oo0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooodX00000
9Ooooom:0000073oooooBP0000070?ooo`030000003oool0oooo0080oooo00<0okmd000000000000
0`0000001@00M;l0oooo0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool00P3oool000@0oooo
00<0W4Q809cOo`3oool0103oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`D0oooo00<000000?oo
o`3oool01@3ooom:000002GoooooBP00001`ooooodX000001`3oool00`000000oooo0?ooo`050?oo
o`0309a8B02Lgol0oooo00@0oooo00H0W4Qd0;ooo`3oool0oono07@0M02oool30?ooo`00103oool0
0`2LB4P0W=oo0?ooo`030?ooo`030?noM000M;l0oooo0080oooo00<0gia804RLg`3oool0103oool0
0`000000oooo0?ooo`050?ooodX000009Ooooom:0000073oooooBP0000070?ooo`030000003oool0
oooo00D0oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0
oooo0080oooo00040?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o
_g@007Bo0?ooo`040?ooo`@00000103ooom:000002GoooooBP00001`ooooodX00000103oool40000
00L0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo
0080oooo00040?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@0
07Bo0?ooo`040?ooo`030000003oool0oooo00D0ooooBP00000UooooodX00000L?oooom:000000L0
oooo00<000000?ooo`3oool01@3oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080
oooo00<0okmd001d_`3oool00P3oool000@0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO
0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<000000?ooo`3oool01@3ooom:000002Gooooo
BP00001`ooooodX000001`3oool00`000000oooo0?ooo`050?ooo`0309a8B02Lgol0oooo00<0oooo
00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`00103oool00`2LB4P0W=oo0?oo
o`030?ooo`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool0103oool00`000000oooo0?oo
o`050?ooodX000009Ooooom:0000073oooooBP0000070?ooo`030000003oool0oooo00D0oooo00<0
W4Q809cOo`3oool00`3oool00`3o_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo0080oooo0000
1P3oool0gia800000000B9`0W4Q809cOo`D0oooo00H0W4P007Boo`3oool0omnL04P0M02oool50?oo
o`030000003oool0oooo00D0ooooBP00000UooooodX00000L?oooom:000000L0oooo00<000000?oo
o`3oool00P3oool01@3OW4P000000018W02LB4P0W=oo00D0oooo00H0W4P007Boo`3oool0omnL04P0
M02oool30?ooo`000`3oool00`3OW4P0001809cOo`050?ooo`050?oo_`1d000000000000B02Lgol0
1P3oool00`000000oooo0?ooo`050?ooodX000009Ooooom:0000073oooooBP0000070?ooo`030000
003oool0oooo00@0oooo00<0gia80000B02Lgol01@3oool01@3ookl0M0000000000004P0W=oo00@0
oooo000F0?ooo`030000003oool0oooo00D0ooooBP00000UooooodX00000L?oooom:000000L0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000002GoooooBP00
001`ooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooodX000009Ooooom:0000073oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00D0ooooBP00000UooooodX00000L?oooom:000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000002GoooooBP00001`ooooodX0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooodX00000
9Ooooom:0000073oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0ooooBP00000UooooodX00000L?oooom:000000L0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01@3ooom:000002GoooooBP00001`ooooodX000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooodX000009Ooooom:0000
073oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
ooooBP00000UooooodX00000L?oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000002GoooooBP00001`ooooodX000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooodX000009Ooooom:0000073oooooBP00
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooBP00000U
ooooodX00000L?oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3ooom:000002GoooooBP00001`ooooodX000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo9@00000UooooobD0
00009Oooool70?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
9@00000Uooooofl000009_oooolU000002Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooK`00000VooooobD000009Ooo
oolU000002Gooooo1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooobD000009Ooooom_000002Kooooo9@00000UooooobD000009Oooool70?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000Uooooofl000009_oooolU0000
02Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000002GoooooK`00000VooooobD000009OoooolU000002Gooooo1`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo
9@00000UooooobD000009Oooool70?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo9@00000Uooooofl000009_oooolU000002Gooooo9@00000Uooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooK`00000V
ooooobD000009OoooolU000002Gooooo1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo9@00000UooooobD000009Oooool70?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000Uooooofl0
00009_oooolU000002Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000002GoooooK`00000VooooobD000009OoooolU000002Gooooo
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooo
oom_000002Kooooo9@00000UooooobD000009Oooool70?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo9@00000Uooooofl000009_oooolU000002Gooooo9@00000U
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
02GoooooK`00000VooooobD000009OoooolU000002Gooooo1`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo9@00000UooooobD0
00009Oooool70?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
9@00000Uooooofl000009_oooolU000002Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooK`00000VooooobD000009Ooo
oolU000002Gooooo1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooobD000009Ooooom_000002Kooooo9@00000UooooobD000009Oooool70?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000Uooooofl000009_oooolU0000
02Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000002GoooooK`00000VooooobD000009OoooolU000002Gooooo1`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo
9@00000UooooobD000009Oooool70?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo9@00000Uooooofl000009_oooolU000002Gooooo9@00000Uooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooK`00000V
ooooobD000009OoooolU000002Gooooo1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo9@00000UooooobD000009Oooool70?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000Uooooofl0
00009_oooolU000002Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000002GoooooK`00000VooooobD000009OoooolU000002Gooooo
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooo
oom_000002Kooooo9@00000UooooobD000009Oooool70?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo9@00000Uooooofl000009_oooolU000002Gooooo9@00000U
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
02GoooooK`00000VooooobD000009OoooolU000002Gooooo1`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo9@00000UooooobD0
00009Oooool70?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
9@00000Uooooofl000009_oooolU000002Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooK`00000VooooobD000009Ooo
oolU000002Gooooo1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooobD000009Ooooom_000002Kooooo9@00000UooooobD000009Oooool70?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000Uooooofl000009_oooolU0000
02Gooooo9@00000Uooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000002GoooooK`00000VooooobD000009OoooolU000002Gooooo1`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom_000002Kooooo
9@00000UooooobD000009Oooool70?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[oooooBP0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[o
ooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
B_oooonE000004[oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[oooooBP0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[o
ooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
B_oooonE000004[oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[oooooBP0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooB_oooonE000004[o
ooooBP0000070?ooo`030000003oool0oooo01D0oooo000;0?ooo`050;md00000000000000000000
M;l01P3oool00`000000oooo0?ooo`050?oood[oooooU@00001:ooooodX000001`3oool00`000000
oooo0?ooo`030?ooo`050;md00000000000000000000M;l03@3oool000X0oooo00<0okmd001d_`3o
ool00P3oool00`2oM4P0W=oo0?ooo`040?ooo`030000003oool0oooo00D0ooooB_oooonE000004[o
ooooBP0000070?ooo`030000003oool0oooo0080oooo00<0okmd001d_`3oool00P3oool00`2oM4P0
W=oo0?ooo`0;0?ooo`002P3oool00`3OW4P0B9cO0?ooo`020?ooo`030;md001d_ol0oooo00@0oooo
00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<000000?ooo`3oool0
0P3oool00`3OW4P0B9cO0?ooo`020?ooo`030;md001d_ol0oooo00/0oooo000:0?ooo`030?noM000
B9`0oooo0080oooo00<0W4Q809cOo`3oool0103oool4000000@0ooooB_oooonE000004[oooooBP00
00040?ooo`@00000103oool00`3o_g@004RL0?ooo`020?ooo`0309a8B02Lgol0oooo00/0oooo000;
0?ooo`050=nLB0000000000000000018W=l01P3oool00`000000oooo0?ooo`050?oood[oooooU@00
001:ooooodX000001`3oool00`000000oooo0?ooo`030?ooo`050=nLB0000000000000000018W=l0
3@3oool000X0oooo00<0oono07A8W03oool00P3oool00`2LB7@0_ooo0?ooo`040?ooo`030000003o
ool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0oooo0080oooo00<0
oono07A8W03oool00P3oool00`2LB7@0_ooo0?ooo`0;0?ooo`002P3oool00`3o_g@0B9cO0?ooo`02
0?ooo`030;md001d_ol0oooo00@0oooo00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:
000000L0oooo00<000000?ooo`3oool00P3oool00`3o_g@0B9cO0?ooo`020?ooo`030;md001d_ol0
oooo00/0oooo000:0?ooo`070?oOW01807@0_ooo0?ooo`3ogi`0B01d0;ooo`050?ooo`030000003o
ool0oooo00D0ooooB_oooonE000004[oooooBP0000070?ooo`030000003oool0oooo0080oooo00L0
omnL04P0M02oool0oooo0?oOW01807@0_ooo00`0oooo000;0?ooo`050?noM000000000000000B02L
gol01P3oool00`000000oooo0?ooo`050?oood[oooooU@00001:ooooodX000001`3oool00`000000
oooo0?ooo`030?ooo`050?noM000000000000000B02Lgol03@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooo
oiD00000B_oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooo
oiD00000B_oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:oooooiD00000B_oooom:
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUoooo
obD00000B_oooom;000006oooooo9@0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0oooo9OoooolU000004[oooooB`00001_ooooobD000001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001:oooood/00000
KooooolU000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oolUooooobD00000B_oooom;000006oooooo9@0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo9OoooolU000004[oooooB`00001_ooooobD000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001:oooo
od/00000KooooolU000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolUooooobD00000B_oooom;000006oooooo9@0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000004[oooooB`00001_ooooobD00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00
001:oooood/00000KooooolU000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooolUooooobD00000B_oooom;000006oooooo9@0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000004[oooooB`00001_oooo
obD000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGo
oooo9@00001:oooood/00000KooooolU000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolUooooobD00000B_oooom;000006oooooo9@0000070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000004[oooooB`00
001_ooooobD000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooobGooooo9@00001:oooood/00000KooooolU000000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000B_oooom;000006oooooo9@0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000004[o
ooooB`00001_ooooobD000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?ooobGooooo9@00001:oooood/00000KooooolU000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000B_oooom;000006oooooo9@00
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU
000004[oooooB`00001_ooooobD000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooobGooooo9@00001:oooood/00000KooooolU000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000B_oooom;000006oo
oooo9@0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
9OoooolU000004[oooooB`00001_ooooobD000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?ooobGooooo9@00001:oooood/00000KooooolU000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000B_oooom;
000006oooooo9@0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo9OoooolU000004[oooooB`00001_ooooobD000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001:oooood/00000KooooolU000000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000
B_oooom;000006oooooo9@0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo9OoooolU000004[oooooB`00001_ooooobD000001`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001:oooood/00000KooooolU
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUoooo
obD00000B_oooom;000006oooooo9@0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0oooo9OoooolU000004[oooooB`00001_ooooobD000001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001:oooood/00000
KooooolU000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oolUooooobD00000B_oooom;000006oooooo9@0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo9OoooolU000004[oooooB`00001_ooooobD000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001:oooo
od/00000KooooolU000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolUooooobD00000B_oooom;000006oooooo9@0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooiCooooo9@00
000VooooobD000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooonDooooobD000009_oooolU000002GoooooBP0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000Uoooo
odX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooiCo
oooo9@00000VooooobD000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooonDooooobD000009_oooolU000002GoooooBP0000070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00
000UooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?oooiCooooo9@00000VooooobD000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3ooonDooooobD000009_oooolU000002GoooooBP0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooU?oooolU000002Ko
oooo9@00000UooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?oooiCooooo9@00000VooooobD000009Ooooom:000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooonDooooobD000009_oooolU000002GoooooBP00
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooU?oooolU
000002Kooooo9@00000UooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?oooiCooooo9@00000VooooobD000009Ooooom:000000L0oooo00<000000?oo
o`3oool05@3oool000`0oooo00D0_g@0000000000000001d0;ooo`050?ooo`030000003oool0oooo
00D0ooooU?oooolU000002Kooooo9@00000UooooodX000001`3oool00`000000oooo0?ooo`040?oo
o`050;md0000000000000000M02oool0303oool000/0oooo00H0gia8001d_`3oool0oooo0?noM000
M;l50?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX000001`3o
ool00`000000oooo0?ooo`030?ooo`060=nLB000M;l0oooo0?ooo`3o_g@007Bo303oool000X0oooo
00<0oono07@0001d_ol00P3oool00`3ookl0M4RL0?ooo`040?ooo`030000003oool0oooo00D0oooo
U?oooolU000002Kooooo9@00000UooooodX000001`3oool00`000000oooo0?ooo`020?ooo`030?oo
_`1d0000M;oo0080oooo00<0oono07A8W03oool02`3oool000X0oooo00L0okmd0018B01d07@0_ooo
0?ooo`3OW4P007Bo00D0oooo100000040?oooiCooooo9@00000VooooobD000009Ooooom:000000@0
oooo100000040?ooo`070?noM000B4P0M01d0;ooo`3oool0gia8001d_`0<0?ooo`002P3oool00`3o
gi`0B4RL0?noM002000000030018W03oool0oooo00@0oooo00<000000?ooo`3oool01@3ooonDoooo
obD000009_oooolU000002GoooooBP0000070?ooo`030000003oool0oooo0080oooo00<0omnL04Q8
W03o_g@00P0000000`00B9`0oooo0?ooo`0;0?ooo`002P3oool00`3ookl0M01d0;ooo`090?ooo`03
0000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX000001`3oool00`000000
oooo0?ooo`020?ooo`030?oo_`1d07@0_ooo0100oooo000;0?ooo`030;md0018W=l0oooo00P0oooo
00<000000?ooo`3oool01@3ooonDooooobD000009_oooolU000002GoooooBP0000070?ooo`030000
003oool0oooo00<0oooo00<0_g@004RLg`3oool03`3oool000/0oooo00<0oono07@00000M;l0203o
ool00`000000oooo0?ooo`050?oooiCooooo9@00000VooooobD000009Ooooom:000000L0oooo00<0
00000?ooo`3oool00`3oool00`3ookl0M000001d_`0?0?ooo`003@3oool0102oM000000000000000
B9`50?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX000001`3o
ool00`000000oooo0?ooo`050?ooo`040;md0000000000000018W0`0oooo000F0?ooo`030000003o
ool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX000001`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooiCooooo9@00000VooooobD000009Ooooom:
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooonDoooo
obD000009_oooolU000002GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX000001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooiCooooo9@00000VooooobD00000
9Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oonDooooobD000009_oooolU000002GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooiCooooo9@00000Voooo
obD000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooonDooooobD000009_oooolU000002GoooooBP0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000UooooodX00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooiCooooo9@00
000VooooobD000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooonDooooobD000009_oooolU000002GoooooBP0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0ooooU?oooolU000002Kooooo9@00000Uoooo
odX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooiCo
oooo9@00000VooooobD000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:0000
09Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:0000
09Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:0000
09Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:0000
09Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:0000
09Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:0000
09Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooom:0000
09Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooom:000009Gooooo9@00001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000Kooooom;000002GoooooBP00
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU
000006ooooooB`00000UooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooobGooooo9@00001_oooood/000009Ooooom:000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000Kooooom;000002Go
ooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
9OoooolU000006ooooooB`00000UooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?ooobGooooo9@00001_oooood/000009Ooooom:000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000Kooooom;
000002GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo9OoooolU000006ooooooB`00000UooooodX000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001_oooood/000009Ooooom:000000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000
Kooooom;000002GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo9OoooolU000006ooooooB`00000UooooodX000001`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001_oooood/000009Ooooom:
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolUoooo
obD00000Kooooom;000002GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0oooo9OoooolU000006ooooooB`00000UooooodX000001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001_oooood/00000
9Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool000`0oooo00D0omnL04P0000000000000
07Boo`050?ooo`030000003oool0oooo00D0oooo9OoooolU000006ooooooB`00000UooooodX00000
1`3oool00`000000oooo0?ooo`040?ooo`050?oOW018000000000000001d_ol0303oool000h0oooo
00<0_g@007Boo`3oool01@3oool00`000000oooo0?ooo`050?ooobGooooo9@00001_oooood/00000
9Ooooom:000000L0oooo00<000000?ooo`3oool01P3oool00`2oM000M;oo0?ooo`0<0?ooo`003P3o
ool00`2oM000M;oo0?ooo`050?ooo`030000003oool0oooo00D0oooo9OoooolU000006ooooooB`00
000UooooodX000001`3oool00`000000oooo0?ooo`060?ooo`030;md001d_ol0oooo00`0oooo000:
0?ooo`030=nLB0000000000000<0000000<0M;oo0?ooo`3oool00`3oool00`000000oooo0?ooo`05
0?ooobGooooo9@00001_oooood/000009Ooooom:000000L0oooo00<000000?ooo`3oool00P3oool0
0`3OW4P00000000000030000000307Boo`3oool0oooo00X0oooo000:0?ooo`060?noM00007@0_ooo
0?ooo`2oM000M;oo1P3oool4000000@0oooo9OoooolU000006ooooooB`00000UooooodX00000103o
ool4000000@0oooo00H0okmd0000M02oool0oooo0;md001d_ol=0?ooo`002`3oool01@3OW4P007Bo
0?ooo`2oM000M;oo00H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000Kooooom;000002Go
ooooBP0000070?ooo`030000003oool0oooo00<0oooo00D0gia8001d_`3oool0_g@007Boo`0=0?oo
o`00303oool0102LB000B9cO0;md001d_ol60?ooo`030000003oool0oooo00D0oooo9OoooolU0000
06ooooooB`00000UooooodX000001`3oool00`000000oooo0?ooo`040?ooo`0409a80018W=l0_g@0
07Boo`d0oooo000<0?ooo`040?oOW01804P0B4P007Boo`H0oooo00<000000?ooo`3oool01@3ooolU
ooooobD00000Kooooom;000002GoooooBP0000070?ooo`030000003oool0oooo00@0oooo00@0omnL
04P0B018B000M;oo3@3oool000d0oooo00<0okmd0000001d_ol01P3oool00`000000oooo0?ooo`05
0?ooobGooooo9@00001_oooood/000009Ooooom:000000L0oooo00<000000?ooo`3oool01@3oool0
0`3o_g@0000007Boo`0=0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00001_oooo
od/000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolUooooobD00000Kooooom;000002GoooooBP0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000006ooooooB`00000UooooodX00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGooooo9@00
001_oooood/000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooolUooooobD00000Kooooom;000002GoooooBP0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000006ooooooB`00000Uoooo
odX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobGo
oooo9@00001_oooood/000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolUooooobD00000Kooooom;000002GoooooBP0000070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000006ooooooB`00
000UooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooobGooooo9@00001_oooood/000009Ooooom:000000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3ooolUooooobD00000Kooooom;000002GoooooBP0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9OoooolU000006oo
ooooB`00000UooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?ooobGooooo9@00001_oooood/000009Ooooom:000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
06ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
06ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
06ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
06ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
06ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
06ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
06ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_ooooo`L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000006ooooooL000001_
ooooo`L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
04[ooooo9@00001;oooooi@000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`050?ooobD00000B_oooolU000004_oooooU00000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD000000L0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000004[ooooo9@00
001;oooooi@000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooobD00000B_oooolU000004_oooooU00000070?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000004[ooooo9@00001;oooooi@0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD00000
B_oooolU000004_oooooU00000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo9@00001:ooooobD00000BooooonD000000L0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01@3ooolU000004[ooooo9@00001;oooooi@000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD00000B_oooolU0000
04_oooooU00000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo9@00001:ooooobD00000BooooonD000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000004[ooooo9@00001;oooooi@000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD00000B_oooolU000004_oooooU000
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00001:
ooooobD00000BooooonD000000L0oooo00<000000?ooo`3oool05@3oool000T0oooo00<0oono07@0
00000000100000000`1d_ol0oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo9@00001:oooo
obD00000BooooonD000000L0oooo00H000000?ooo`3oool0oooo0?oo_`1d00050000000307Boo`3o
ool0oooo00X0oooo000:0?ooo`030;md000007@0_ooo0080oooo00<0giad09cOo`3oool0103oool0
0`000000oooo0?ooo`050?ooobD00000B_oooolU000004_oooooU00000070?ooo`030000003oool0
oooo0080oooo00<0_g@00000M02oool00P3oool00`3OW7@0W=oo0?ooo`0;0?ooo`002`3oool00`3o
_g@0001809cOo`080?ooo`030000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD0000
00L0oooo00<000000?ooo`3oool00`3oool00`3o_g@0001809cOo`0?0?ooo`00303oool00`3ogi`0
B00004RLg`070?ooo`030000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD000000L0
oooo00<000000?ooo`3oool0103oool00`3ogi`0B00004RLg`0>0?ooo`003P3oool00`2LB000B9cO
0?ooo`050?ooo`@00000103ooolU000004[ooooo9@00001;oooooi@00000103oool4000000P0oooo
00<0W4P004RLg`3oool0303oool000l0oooo00<0W4Qd0;ooo`3oool0103oool00`000000oooo0?oo
o`050?ooobD00000B_oooolU000004_oooooU00000070?ooo`030000003oool0oooo00L0oooo00<0
W4Qd0;ooo`3oool02`3oool000X0oooo00<0gia807Boo`3oool00P3oool00`2oM000M;oo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD000000L0oooo00<00000
0?ooo`3oool00P3oool00`3OW4P0M;oo0?ooo`020?ooo`030;md001d_ol0oooo00/0oooo000:0?oo
o`070?noM00007@0_ooo0?ooo`3o_g@0001809cOo`050?ooo`030000003oool0oooo00D0oooo9@00
001:ooooobD00000BooooonD000000L0oooo00<000000?ooo`3oool00P3oool01`3o_g@0001d0;oo
o`3oool0okmd0000B02Lgol0303oool000/0oooo00D0okmd000000000000001809cOo`060?ooo`03
0000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD000000L0oooo00<000000?ooo`3o
ool00`3oool01@3o_g@000000000000004P0W=oo00d0oooo000F0?ooo`030000003oool0oooo00D0
oooo9@00001:ooooobD00000BooooonD000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000004[ooooo9@00001;oooooi@000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD00000B_oooolU000004_oooooU000
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00001:
ooooobD00000BooooonD000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3ooolU000004[ooooo9@00001;oooooi@000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooobD00000B_oooolU000004_oooooU00000070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00001:ooooobD00000
BooooonD000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oolU000004[ooooo9@00001;oooooi@000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooobD00000B_oooolU000004_oooooU00000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD0000
00L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000004[o
oooo9@00001;oooooi@000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?ooobD00000B_oooolU000004_oooooU00000070?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00D0oooo9@00001:ooooobD00000BooooonD000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooBP00002E
ooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oo
obD000009Ooooom:000009GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0oooo9@00000UooooodX00000UOoooom:000000L0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooBP00002EooooodX00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooo
oom:000009GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00D0oooo9@00000UooooodX00000UOoooom:000000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooBP00002EooooodX000001`3oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom:000009Go
ooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
9@00000UooooodX00000UOoooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<0
00000?ooo`3oool01@3ooolU000002GoooooBP00002EooooodX000001`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom:000009GoooooBP000007
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000Uoooo
odX00000UOoooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolU000002GoooooBP00002EooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom:000009GoooooBP0000070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000UooooodX00000UOoo
oom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU
000002GoooooBP00002EooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooobD000009Ooooom:000009GoooooBP0000070?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000UooooodX00000UOoooom:000000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002Gooooo
BP00002EooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`050?ooobD000009Ooooom:000009GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo9@00000UooooodX00000UOoooom:000000L0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooBP00002Eoooo
odX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD0
00009Ooooom:000009GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00D0oooo9@00000UooooodX00000UOoooom:000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000002GoooooBP00002EooooodX000001`3o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom:
000009GoooooBP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo9@00000UooooodX00000UOoooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01@3ooolU000002GoooooBP00002EooooodX000001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom:000009Gooooo
BP0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00
000UooooodX00000UOoooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooolU000002GoooooBP00002EooooodX000001`3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`050?ooobD000009Ooooom:000009GoooooBP0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000UooooodX0
0000UOoooom:000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1@3ooolU000002GoooooBP00002EooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?ooobD000009Ooooom:000009GoooooBP0000070?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo9@00000UooooodX00000UOoooom:
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
02GoooooBP00002EooooodX000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0?l0ooooP03o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0A`3oool00`000000
oooo0?ooo`180?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo03`0oooo
00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01D0oooo000F0?ooool00000Q000000G0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00D@3oool00`3ookl0M000000000040000000307Boo`3o
ool0oooo04<0oooo00D0omnL04P000000000000007Boo`150?ooo`050;md0000000000000000M02o
ool0A03oool01@2oM000000000000000000007Bo0400oooo00<0okmd0000000000000`0000001@00
M;l0oooo0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool0:@3oool00580oooo00<0_g@00000
M02oool00P3oool00`3OW7@0W=oo0?ooo`160?ooo`030;md001d_ol0oooo04@0oooo00H0gia8001d
_`3oool0oooo0?noM000M;m30?ooo`030?noM000M;l0oooo0080oooo00<0_gA809cOo`3oool0@@3o
ool00`2LB4P0W=oo0?ooo`040?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo:P3oool005<0oooo
00<0okmd0000B02Lgol0BP3oool00`2oM000M;oo0?ooo`130?ooo`030?oo_`1d0000M;oo0080oooo
00<0oono07A8W03oool0@P3oool00`3OW4P0B9cO0?ooo`020?ooo`030;md001d_ol0oooo0440oooo
00<0W4Q809cOo`3oool00`3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo02T0oooo
001D0?ooo`030?oOW0180000B9cO04D0oooo00<0gia80000000000000`0000000`1d_ol0oooo0?oo
o`110?ooo`070?noM000B4P0M01d0;ooo`3oool0gia8001d_`130?ooo`030?noM000B9`0oooo0080
oooo00<0W4Q809cOo`3oool0@@3oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080
oooo00<0okmd001d_`3oool0:@3oool005H0oooo00<0W4P004RLg`3oool0@`3oool01P3o_g@0001d
0;ooo`3oool0_g@007Bood@0oooo00<0omnL04Q8W03o_g@00P0000000`00B9`0oooo0?ooo`130?oo
o`050=nLB0000000000000000018W=l0@`3oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0
oooo0080oooo00<0okmd001d_`3oool0:@3oool005L0oooo00<0W4Qd0;ooo`3oool0@`3oool01@3O
W4P007Bo0?ooo`2oM000M;oo04@0oooo00<0oono07@0M02oool0A`3oool00`3ookl0M4RL0?ooo`02
0?ooo`0309a8M02oool0oooo0440oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`02
0?ooo`030?noM000M;l0oooo02T0oooo001B0?ooo`030=nLB01d_ol0oooo0080oooo00<0_g@007Bo
o`3oool0A03oool0102LB000B9cO0;md001d_om50?ooo`030;md0018W=l0oooo04H0oooo00<0okmd
04RLg`3oool00P3oool00`2oM000M;oo0?ooo`110?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd
04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`0Y0?ooo`00DP3oool01`3o_g@0001d0;ooo`3oool0
okmd0000B02Lgol0A@3oool0103ogi`0B01804Q8001d_om50?ooo`030?oo_`1d000007Bo04H0oooo
00L0omnL04P0M02oool0oooo0?oOW01807@0_ooo03l0oooo00D0gia800000000B9`0W4Q809cOo`05
0?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo:P3oool005<0oooo00D0okmd0000000000000018
09cOo`170?ooo`030?noM0000000M;oo04L0oooo00@0_g@000000000000004RLA03oool01@3o_g@0
00000000000004P0W=oo0480oooo00<0gia80000B02Lgol01@3oool01@3ookl0M0000000000004P0
W=oo02/0oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o
0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287.313}, {287.313, 0}} -> {-0.31583, -11.3159, \
0.0404814, 0.0404814}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["MatrixPlot", "MR"],
  " has a number of graphics options for controlling the appearance of the \
plot. Many of these are the typical options of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["DensityGraphics", "MR"],
  " objects. It also has a special option, ",
  StyleBox["MaxMatrixSize", "MR"],
  ", that controls the maximum size for the display of a matrix. Above this \
size the matrix is downsampled. Some of the important options are summarized \
in the following."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MaxMatrixSize\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"512\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"maximum size of matrix to display"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"AspectRatio\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"1\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"scaling for the final image shape"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"ColorFunction\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"coloring for each element"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Mesh\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"False\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"whether to draw a mesh"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MeshStyle\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"GrayLevel[1]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"the style of the mesh"\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S5.27.1"],

Cell["Options of MatrixPlot. ", "Caption",
  CellTags->"S3.7.2"],

Cell[TextData[{
  "By default, no mesh is drawn around the elements; this can be enabled with \
the ",
  StyleBox["Mesh", "MR"],
  " option. Typically you would not want to draw the mesh if the matrix is \
very large. When the mesh is drawn, it has a default style that uses white \
lines in order to reduce interference with the picture. The style of the mesh \
can be altered with the ",
  StyleBox["MeshStyle", "MR"],
  " option."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MatrixPlot[Table[\ Random[Integer], {50}, {50}], \ 
        Mesh \[Rule] True];\)\)], "Input",
  CellLabel->"In[5]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00961538 0.0192308 0.990385 0.0192308 [
[.00962 -0.0125 -3 -9 ]
[.00962 -0.0125 3 0 ]
[.20192 -0.0125 -6 -9 ]
[.20192 -0.0125 6 0 ]
[.39423 -0.0125 -6 -9 ]
[.39423 -0.0125 6 0 ]
[.58654 -0.0125 -6 -9 ]
[.58654 -0.0125 6 0 ]
[.77885 -0.0125 -6 -9 ]
[.77885 -0.0125 6 0 ]
[.97115 -0.0125 -6 -9 ]
[.97115 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02885 -12 -4.5 ]
[-0.0125 .02885 0 4.5 ]
[-0.0125 .22115 -12 -4.5 ]
[-0.0125 .22115 0 4.5 ]
[-0.0125 .41346 -12 -4.5 ]
[-0.0125 .41346 0 4.5 ]
[-0.0125 .60577 -12 -4.5 ]
[-0.0125 .60577 0 4.5 ]
[-0.0125 .79808 -12 -4.5 ]
[-0.0125 .79808 0 4.5 ]
[-0.0125 .99038 -6 -4.5 ]
[-0.0125 .99038 0 4.5 ]
[ 0 0 -0.125 0 ]
[.00962 1.0125 -3 0 ]
[.00962 1.0125 3 9 ]
[.20192 1.0125 -6 0 ]
[.20192 1.0125 6 9 ]
[.39423 1.0125 -6 0 ]
[.39423 1.0125 6 9 ]
[.58654 1.0125 -6 0 ]
[.58654 1.0125 6 9 ]
[.77885 1.0125 -6 0 ]
[.77885 1.0125 6 9 ]
[.97115 1.0125 -6 0 ]
[.97115 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .02885 0 -4.5 ]
[1.0125 .02885 12 4.5 ]
[1.0125 .22115 0 -4.5 ]
[1.0125 .22115 12 4.5 ]
[1.0125 .41346 0 -4.5 ]
[1.0125 .41346 12 4.5 ]
[1.0125 .60577 0 -4.5 ]
[1.0125 .60577 12 4.5 ]
[1.0125 .79808 0 -4.5 ]
[1.0125 .79808 12 4.5 ]
[1.0125 .99038 0 -4.5 ]
[1.0125 .99038 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00962 0 m
.00962 .00625 L
s
[(0)] .00962 -0.0125 0 1 Mshowa
.20192 0 m
.20192 .00625 L
s
[(10)] .20192 -0.0125 0 1 Mshowa
.39423 0 m
.39423 .00625 L
s
[(20)] .39423 -0.0125 0 1 Mshowa
.58654 0 m
.58654 .00625 L
s
[(30)] .58654 -0.0125 0 1 Mshowa
.77885 0 m
.77885 .00625 L
s
[(40)] .77885 -0.0125 0 1 Mshowa
.97115 0 m
.97115 .00625 L
s
[(50)] .97115 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .02885 m
.00625 .02885 L
s
[(50)] -0.0125 .02885 1 0 Mshowa
0 .22115 m
.00625 .22115 L
s
[(40)] -0.0125 .22115 1 0 Mshowa
0 .41346 m
.00625 .41346 L
s
[(30)] -0.0125 .41346 1 0 Mshowa
0 .60577 m
.00625 .60577 L
s
[(20)] -0.0125 .60577 1 0 Mshowa
0 .79808 m
.00625 .79808 L
s
[(10)] -0.0125 .79808 1 0 Mshowa
0 .99038 m
.00625 .99038 L
s
[(0)] -0.0125 .99038 1 0 Mshowa
0 0 m
0 1 L
s
.00962 .99375 m
.00962 1 L
s
[(0)] .00962 1.0125 0 -1 Mshowa
.20192 .99375 m
.20192 1 L
s
[(10)] .20192 1.0125 0 -1 Mshowa
.39423 .99375 m
.39423 1 L
s
[(20)] .39423 1.0125 0 -1 Mshowa
.58654 .99375 m
.58654 1 L
s
[(30)] .58654 1.0125 0 -1 Mshowa
.77885 .99375 m
.77885 1 L
s
[(40)] .77885 1.0125 0 -1 Mshowa
.97115 .99375 m
.97115 1 L
s
[(50)] .97115 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .02885 m
1 .02885 L
s
[(50)] 1.0125 .02885 -1 0 Mshowa
.99375 .22115 m
1 .22115 L
s
[(40)] 1.0125 .22115 -1 0 Mshowa
.99375 .41346 m
1 .41346 L
s
[(30)] 1.0125 .41346 -1 0 Mshowa
.99375 .60577 m
1 .60577 L
s
[(20)] 1.0125 .60577 -1 0 Mshowa
.99375 .79808 m
1 .79808 L
s
[(10)] 1.0125 .79808 -1 0 Mshowa
.99375 .99038 m
1 .99038 L
s
[(0)] 1.0125 .99038 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
50 string
50 50 8 [50 0 0 50 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
00FFFFFFFFFF00FFFFFFFF0000FFFF00FFFF00FFFFFFFF0000FF00FFFFFF0000FF0000FF
FF0000FF000000000000FFFFFFFF
FF00FFFF0000FF00FFFF00000000FF0000FFFF00FFFFFFFFFFFF00000000FF00FFFF0000
FFFFFF000000FFFFFF0000FFFF00
FFFFFF000000FF0000FF000000000000000000FF0000FFFF00FF00FFFFFFFFFF0000FF00
00FFFFFF00FF00FFFF000000FF00
FF0000FF00FF0000FF00FF0000FFFFFFFFFF0000000000FF00FF00000000FFFF00FFFF00
FF00FF000000FF00FF0000FFFF00
00FFFF00FF00FF00000000FF0000FFFFFFFFFF0000FFFF0000FF0000FFFF0000FFFFFF00
FF00FFFFFFFF0000FFFFFF000000
FF00FFFFFF00FF0000FFFF00FF0000FF0000FFFF0000FF00000000FFFFFF0000FFFFFF00
FF00FFFF00000000FFFF00FFFF00
FF0000FF00FF000000FF000000FFFF00FF0000000000FFFFFFFF000000FFFF0000000000
FF0000FF00000000FFFFFF0000FF
FFFF000000FFFF00FF0000FFFFFFFF00FFFF000000FF00FFFFFF0000FFFF00FFFF000000
000000FF0000FF00FF00FFFF0000
FF00FFFFFF0000000000FFFFFF0000FFFF00FF0000FF00000000FF000000FF00FFFFFFFF
0000FF00FF00000000FF00000000
FF00FFFFFFFFFFFFFF0000FFFF00FFFF000000FFFFFFFF0000FF00FFFF0000FFFF00FF00
0000FF00FFFF00FF0000000000FF
FFFF00000000FF00000000FFFFFF00FF00FFFF00FF00FFFF000000FFFF00000000FFFF00
FFFF00FFFFFFFFFF00FF00FF00FF
00FFFFFF00000000FFFFFF0000000000FFFFFF00FFFFFF000000FFFFFF00FFFF00FFFFFF
FFFF0000FF00FFFFFF000000FF00
000000FFFF00FF0000FF00FF0000000000FF000000FF00000000FFFFFF000000000000FF
FFFFFF00FF00FFFFFF0000000000
FF00FFFFFF00FFFFFF0000FF00FFFFFFFF0000FFFF0000FF00FFFFFFFFFFFFFF00FFFF00
FF00FF00FFFFFFFFFFFFFFFFFF00
FF00FF000000FF0000FF0000FF00FFFFFF0000000000000000FFFF00FFFFFF0000FF00FF
000000FF00FFFFFFFFFF0000FF00
000000FF00000000FFFFFF00000000FF00FFFF00FF00FF00FF00FF00FFFF00FFFFFFFF00
00FFFFFF000000FFFF000000FFFF
00FFFFFF000000FF00FFFF00FFFF0000FF00FFFFFFFFFF0000000000FFFF00FF0000FF00
FFFFFFFFFFFFFF000000FF00FFFF
000000000000FF00FFFF0000FF0000FFFF0000FF0000FFFF000000FF0000FFFF000000FF
FFFF00FF0000FFFFFFFFFFFFFF00
FF00FFFF00FF00FFFF00FFFF00FFFFFF000000FF00FF00FF00FF00FF00FFFFFFFF0000FF
00FFFF00FFFFFF00FF00FF00FFFF
FF00FF0000FF000000FF0000FF000000FF0000FFFF0000FFFFFFFFFF0000FF00FF0000FF
FFFFFF00FFFFFF000000FF0000FF
FF00FF000000FFFF00FFFF00FFFFFFFFFF00000000FF00FF00FF0000000000FFFF00FF00
00FFFFFFFFFFFFFFFFFFFF00FFFF
000000FFFF00FFFFFFFF0000FFFF0000FF000000FF00000000FF00FFFF00FFFFFF000000
FF000000FFFFFFFFFFFFFF0000FF
FF00FF00FF00FF00FFFFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFF0000FF00FFFF0000
FFFFFF00FF00FFFF00000000FF00
FFFFFF0000FFFFFF00FFFF0000FFFF0000FFFFFFFF0000FF00FFFFFFFFFF000000FFFF00
FF0000FFFF00000000FFFFFFFF00
000000FFFF00FFFFFF000000FF0000FFFF0000FFFFFF00FF00FFFF00000000FF00FF00FF
FFFF00FFFFFFFF00000000FF0000
FF0000000000FFFF0000FF0000FFFF00FFFF0000000000FF000000FFFFFFFF00000000FF
00FFFF0000FF000000FF00FFFF00
FFFF00FF0000FF0000FFFFFF0000FFFFFF00FFFFFFFF00FF00FFFFFFFFFFFFFF000000FF
FFFF00FFFF0000FFFF000000FF00
FF00FFFFFF00FF0000FF00000000FF0000FFFFFF00FFFF00FFFFFF00FF0000FF00FF0000
00FF0000000000FFFFFF0000FF00
FFFFFFFF0000FFFF000000FF00FF00FFFF00FF00000000FFFFFFFF00FFFFFFFF00FF00FF
0000FFFF00FFFFFF0000FFFFFF00
FF0000000000FF00FFFF00FF000000FFFFFF0000FFFFFF00FF00000000000000FF00FF00
FFFF00FFFFFFFF00FF00FF00FF00
00FFFFFFFF0000FF000000FFFF00FF000000FF0000FFFF00000000FF00FFFF0000FFFFFF
FF00FFFFFFFFFF00FFFFFF000000
0000FFFFFFFFFF00FFFF00FF000000FFFF0000FF000000FFFF00FF00FF00000000FFFFFF
FFFFFF0000FF000000FFFFFF00FF
00FFFF00FFFF00000000FF00FF0000000000FFFF00FFFFFFFFFFFF0000FFFFFFFF000000
FF00FF00FFFFFFFF0000FF000000
FFFF000000FF00FFFFFF00FFFFFF000000FFFF00000000FFFFFF00FFFFFFFF00FFFF0000
FF00FFFF000000000000FF00FFFF
00FF00FF0000FF00FFFF00FFFFFFFFFF00FFFFFF00000000FF00FFFFFF00FF00FF00FFFF
00FFFFFFFF00FF000000FFFF00FF
00000000FF00FF00FF0000FFFF000000FF00FF00FFFF00FFFFFFFF000000FFFF00000000
000000FFFFFFFFFF00FF000000FF
FFFF0000000000FF00000000FFFF00000000FF00FF0000FFFF00FF00FFFF00FF000000FF
FF000000FF000000FF0000FF0000
FFFFFF00000000FF00FF0000FFFFFF0000FFFF00FF00FF00FFFFFF0000FF0000FF00FFFF
FFFFFF00FFFF00FFFFFFFFFFFF00
00FF00FFFF0000FF00FFFFFFFF0000FFFF000000000000FF00000000FF0000FFFF0000FF
FFFF00FF0000FFFFFF0000FFFF00
00FFFF00FFFFFF00FF0000FFFFFF0000000000FFFF00FF0000FFFFFF00000000FFFF0000
FFFFFFFFFFFF00FFFFFF00FFFF00
FF0000FF00FFFF0000FFFF00FFFF000000FF0000FFFF0000FF0000FF00000000FF00FF00
FFFFFFFFFF00FFFFFF00000000FF
00FFFF0000FFFFFF00000000FF00000000FF00000000FFFF0000FF00000000FF0000FFFF
00FFFF0000FFFF00FFFFFF000000
FFFF0000FFFFFFFFFF0000000000FF00FF000000FF0000FF0000FF0000FF00FF00FFFF00
FFFFFFFFFF00FF00FFFF0000FF00
000000000000FF00FFFFFF00FF00FF00FFFF000000FF00FFFFFF0000FFFF00FFFF000000
00FFFF00FF000000FFFFFFFF00FF
FFFF000000FF0000FF0000FF00FF00FF0000FF00FFFF000000FF00FFFFFF0000FFFFFF00
FF0000FF00FF000000FFFFFF00FF
00FFFF00FF00FF00FF000000FFFFFFFF00FFFF00FFFF000000FF0000FFFFFFFF0000FF00
FF0000FFFF0000FF00FF00FF00FF
FF00FF0000FFFFFFFF0000FF00FF00FF0000FF000000FF00FFFFFF00FFFF0000FFFFFF00
0000FF00FF0000000000FF0000FF
FFFFFF00FF00FFFFFF0000000000FF000000FF0000FFFF0000FF00FFFFFFFFFF0000FFFF
00FF000000FF00FFFF00FF00FFFF
FF00000000FF00FFFF000000FFFFFFFF0000FF0000FF00FF00FFFFFF000000000000FFFF
FFFFFF0000FFFF00FFFF00FFFF00
00FF00000000FF000000FFFF00FFFFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFF00FF
pop
P
% End of image
1 g
.01923 .01923 m
.01923 .98077 L
s
.03846 .01923 m
.03846 .98077 L
s
.05769 .01923 m
.05769 .98077 L
s
.07692 .01923 m
.07692 .98077 L
s
.09615 .01923 m
.09615 .98077 L
s
.11538 .01923 m
.11538 .98077 L
s
.13462 .01923 m
.13462 .98077 L
s
.15385 .01923 m
.15385 .98077 L
s
.17308 .01923 m
.17308 .98077 L
s
.19231 .01923 m
.19231 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.23077 .01923 m
.23077 .98077 L
s
.25 .01923 m
.25 .98077 L
s
.26923 .01923 m
.26923 .98077 L
s
.28846 .01923 m
.28846 .98077 L
s
.30769 .01923 m
.30769 .98077 L
s
.32692 .01923 m
.32692 .98077 L
s
.34615 .01923 m
.34615 .98077 L
s
.36538 .01923 m
.36538 .98077 L
s
.38462 .01923 m
.38462 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.42308 .01923 m
.42308 .98077 L
s
.44231 .01923 m
.44231 .98077 L
s
.46154 .01923 m
.46154 .98077 L
s
.48077 .01923 m
.48077 .98077 L
s
.5 .01923 m
.5 .98077 L
s
.51923 .01923 m
.51923 .98077 L
s
.53846 .01923 m
.53846 .98077 L
s
.55769 .01923 m
.55769 .98077 L
s
.57692 .01923 m
.57692 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.61538 .01923 m
.61538 .98077 L
s
.63462 .01923 m
.63462 .98077 L
s
.65385 .01923 m
.65385 .98077 L
s
.67308 .01923 m
.67308 .98077 L
s
.69231 .01923 m
.69231 .98077 L
s
.71154 .01923 m
.71154 .98077 L
s
.73077 .01923 m
.73077 .98077 L
s
.75 .01923 m
.75 .98077 L
s
.76923 .01923 m
.76923 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.80769 .01923 m
.80769 .98077 L
s
.82692 .01923 m
.82692 .98077 L
s
.84615 .01923 m
.84615 .98077 L
s
.86538 .01923 m
.86538 .98077 L
s
.88462 .01923 m
.88462 .98077 L
s
.90385 .01923 m
.90385 .98077 L
s
.92308 .01923 m
.92308 .98077 L
s
.94231 .01923 m
.94231 .98077 L
s
.96154 .01923 m
.96154 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .03846 m
.98077 .03846 L
s
.01923 .05769 m
.98077 .05769 L
s
.01923 .07692 m
.98077 .07692 L
s
.01923 .09615 m
.98077 .09615 L
s
.01923 .11538 m
.98077 .11538 L
s
.01923 .13462 m
.98077 .13462 L
s
.01923 .15385 m
.98077 .15385 L
s
.01923 .17308 m
.98077 .17308 L
s
.01923 .19231 m
.98077 .19231 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .23077 m
.98077 .23077 L
s
.01923 .25 m
.98077 .25 L
s
.01923 .26923 m
.98077 .26923 L
s
.01923 .28846 m
.98077 .28846 L
s
.01923 .30769 m
.98077 .30769 L
s
.01923 .32692 m
.98077 .32692 L
s
.01923 .34615 m
.98077 .34615 L
s
.01923 .36538 m
.98077 .36538 L
s
.01923 .38462 m
.98077 .38462 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .42308 m
.98077 .42308 L
s
.01923 .44231 m
.98077 .44231 L
s
.01923 .46154 m
.98077 .46154 L
s
.01923 .48077 m
.98077 .48077 L
s
.01923 .5 m
.98077 .5 L
s
.01923 .51923 m
.98077 .51923 L
s
.01923 .53846 m
.98077 .53846 L
s
.01923 .55769 m
.98077 .55769 L
s
.01923 .57692 m
.98077 .57692 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .61538 m
.98077 .61538 L
s
.01923 .63462 m
.98077 .63462 L
s
.01923 .65385 m
.98077 .65385 L
s
.01923 .67308 m
.98077 .67308 L
s
.01923 .69231 m
.98077 .69231 L
s
.01923 .71154 m
.98077 .71154 L
s
.01923 .73077 m
.98077 .73077 L
s
.01923 .75 m
.98077 .75 L
s
.01923 .76923 m
.98077 .76923 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .80769 m
.98077 .80769 L
s
.01923 .82692 m
.98077 .82692 L
s
.01923 .84615 m
.98077 .84615 L
s
.01923 .86538 m
.98077 .86538 L
s
.01923 .88462 m
.98077 .88462 L
s
.01923 .90385 m
.98077 .90385 L
s
.01923 .92308 m
.98077 .92308 L
s
.01923 .94231 m
.98077 .94231 L
s
.01923 .96154 m
.98077 .96154 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00603oool01@3o_g@00000000000000000M;oo03l0oooo00<0okmd0000
000000000`0000001@00M;l0oooo0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool0>03oool0
0`3ookl0M000000000040000000507Boo`3oool0oooo0?ooo`3o_g@00`0000000`1d_ol0oooo0?oo
o`0j0?ooo`050;md00000000000000000018W=l0103oool01@3o_g@00000000000000000M;oo03d0
oooo00D0omnL04P000000000000007Boo`030?ooo`050?noM000000000000000001d_ol0?@3oool0
1@2oM0000000000000000000M;oo00@0oooo00D0okmd000000000000000007Boo`0L0?ooo`00603o
ool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oood40oooo00<0W4Q809cOo`3oool0103oool01P2LB7@0
_ooo0?ooo`3ookl0M01d0;ooocX0oooo00<0_g@00000M02oool00P3oool00`3OW7@0W=oo0?ooo`02
0?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo>P3oool01`2oM00007Bo0?ooo`3oool0oono07@0
0018W=l00`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oooch0oooo00<0_g@007Boo`3oool00`3o
ool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oooc/0oooo00L0_g@0001d_`3oool0oooo0?oOW0180000
M;oo00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02ooolK0?ooo`005`3oool00`3o_g@007Bo0?oo
o`020?ooo`030=nLB018W=l0oooo0400oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@007Bo0?oo
o`020?ooo`030=nLB018W=l0oooo03X0oooo00<0okmd0000B02Lgol01@3oool00`3o_g@007Bo0?oo
o`020?ooo`030=nLB018W=l0oooo03h0oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`03
0=nLB018W=l0oooo03d0oooo00<0_g@007Boo`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`03
0=nLB018W=l0oooo03l0oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0
oooo01X0oooo000G0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0@03oool00`2L
B4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0>`3oool00`3o
gi`0B00004RLg`040?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0?@3oool00`3o
gi`0B01809cOo`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0>@3oool00`3O
W4P00000000000030000000507Boo`3oool0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0o
0?ooo`060?noM000M;l0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@007Bo0?ooo`0J0?ooo`005`3o
ool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo0400oooo00<0W4Q809cOo`3oool00`3o
ool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03d0oooo00<0W4P004RLg`3oool00P3o
ool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03/0oooo00@0gia80000000004P0W=oo
0`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03T0oooo00H0okmd0000M02oool0
oooo0;md001d_ol30?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0?`3oool01P2L
B000M;oo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool06P3oool001L0oooo00<0gia8
04RLg`3oool00P3oool00`3o_g@007Bo0?ooo`100?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia8
04RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0n0?ooo`0609a8M02oool0oooo0?ooo`3OW4P0B9cO
0`3oool00`3o_g@007Bo0?ooo`0m0?ooo`030?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool0
0P3oool00`3o_g@007Bo0?ooo`0j0?ooo`050=nLB000M;l0oooo0;md001d_ol00`3oool00`3OW4P0
B9cO0?ooo`020?ooo`030?noM000M;l0oooo03X0oooo00<0oono07@0000000000P0000001P18W=l0
oooo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool06P3oool001L0oooo00<0okmd04RL
g`3oool00P3oool00`3OW4P0B9cO0?ooo`100?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd04RL
g`3oool00P3oool00`3OW4P0B9cO0?ooo`0i0?ooo`030=nLB01d_ol0oooo0080oooo00H0_g@007Bo
o`3oool0oooo0?noM018W=l30?ooo`030=nLB018W=l0oooo03h0oooo00H0_g@007Boo`3oool0oooo
0?noM018W=l30?ooo`030=nLB018W=l0oooo03/0oooo00@0W4P004RLg`2oM000M;oo0`3oool00`3o
_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo03X0oooo00<0oono07@0M02oool01P3oool00`3o
_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo01X0oooo000H0?ooo`0609a8001d_ol0oooo0?oO
W01807@0_ooo?P3oool01@3OW4P000000018W02LB4P0W=oo00D0oooo00H0W4P007Boo`3oool0omnL
04P0M02ooolj0?ooo`070?noM00007@0_ooo0?ooo`3o_g@0001809cOo`030?ooo`0609a8001d_ol0
oooo0?oOW01807@0_ooo>P3oool01`3o_g@0001809cOo`3oool0omnL04P0B02Lgol00`3oool01P2L
B000M;oo0?ooo`3ogi`0B01d0;oooc`0oooo00@0omnL04P0B018B000M;oo103oool01P2LB000M;oo
0?ooo`3ogi`0B01d0;oooc/0oooo00<0oono07@0M02oool01`3oool01P2LB000M;oo0?ooo`3ogi`0
B01d0;oooa/0oooo000H0?ooo`050?oo_`1d000000000000B02Lgol0@@3oool00`3OW4P0001809cO
o`050?ooo`050?oo_`1d000000000000B02Lgol0?03oool01@3o_g@000000000000004P0W=oo00@0
oooo00D0oono07@000000000001809cOo`0l0?ooo`050?oOW018000000000000001d_ol0103oool0
1@3ookl0M0000000000004P0W=oo03h0oooo00<0okmd0000001d_ol0103oool01@3ookl0M0000000
000004P0W=oo03`0oooo00<0oono07@0000000000P0000000`0007@0_ooo0?ooo`020?ooo`050?oo
_`1d000000000000B02Lgol0703oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool001H0ooooo`000024
000001L0oooo000F0?ooo`050000003oool0oooo0?ooo`000000B@3oool00`000000oooo0?ooo`17
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool001H0oooo00D000000?oo
o`3oool0oooo000000190?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool0
0`000000oooo0?ooo`170?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool01@000000oooo0?ooo`3oool0000004T0oooo00<00000
0?ooo`3oool0A`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo04L0oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0?l0ooooP03o
ool00`000000oooo0?ooo`0E0?ooo`000P3oool01@2oM0000000000000000000M;oo00@0oooo00D0
okmd000000000000000007Boo`060?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo
0?ooo`030?ooo`050;md0000000000000000001d_ol0103oool01@3o_g@00000000000000000M;oo
00@0oooo00000`3oool0_g@0001d_`020?ooo`030?oOW0180000M;oo00<0oooo00H0W4Qd0;ooo`3o
ool0oono07@0M02oool50?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`P0oooo00<000000?ooo`3oool00P3oool01`2oM00007Bo0?ooo`3oool0omnL04P0001d_ol0
0`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`<0oooo00060?ooo`060?noM000M;l0oooo0?oo
o`3o_g@007Bo0`3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0oooo00H0oooo1P000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool01`3oool01P3o_g@007Bo0?ooo`3o
ool0okmd001d_`<0oooo00<0gia804RLg`3oool00P3oool000H0oooo00H0okmd001d_`3oool0oooo
0=nLB018W=l30?ooo`030?noM000M;l0oooo00@0oooo100000050?ooo`H0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool50?ooo`@000002@3oool01P3o_g@007Bo0?ooo`3oool0gia804RLg`<0oooo00<0okmd
001d_`3oool00P3oool000H0oooo00H0W4P007Boo`3oool0oooo0=nLB018W=l30?ooo`030?noM000
M;l0oooo00@0oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo203o
ool00`000000oooo0?ooo`070?ooo`0609a8001d_ol0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@0
07Bo0?ooo`020?ooo`0000<0oooo0?oo_`1d00000`0000001P18W=l0oooo0?ooo`3oool0gia804RL
g`<0oooo00<0okmd001d_`3oool0103oool00`000000oooo0?ooo`060?ooo`H0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool80?ooo`030000003oool0oooo0080oooo00<0oono07@0000000000P0000001P18
W=l0oooo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool00P3oool000040?ooo`3ookl0
M01d0;ooo`H0oooo00<0okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003o
ool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool00P3o
ool00`3ookl0M01d0;ooo`060?ooo`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool00P3o
ool000040?ooo`3ookl0M01d0;ooo`L0oooo00H0W4P007Boo`3oool0omnL04P0M02oool50?ooo`03
0000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`020?ooo`030?oo_`1d07@0_ooo00L0
oooo00H0W4P007Boo`3oool0omnL04P0M02oool30?ooo`0000<0oooo0?oo_`1d00000`0000000`00
07@0_ooo0?ooo`020?ooo`050?oo_`1d000000000000B02Lgol01P3oool00`000000oooo0?ooo`06
0?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo0080oooo00<0oono
07@0000000000P0000000`0007@0_ooo0?ooo`020?ooo`050?oo_`1d000000000000B02Lgol0103o
ool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0
oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool0o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0
oooo1_ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3o
ool6ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000080?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3o
ool6000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0oooo000000000000100000080?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool600000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3o
ool6ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?oo
o`Kooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?oo
o`Kooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?oo
o`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@00000203oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo
1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<0
00000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?oo
o`0E0?ooo`000`3oool01@3ogi`0B000000000000000M;oo00<0oooo00D0okmd0000000000000000
07Boo`060?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`040?ooo`050?oO
W018000000000000001d_ol00`3oool01@3o_g@00000000000000000M;oo00@0oooo00050?ooo`03
0;md001d_ol0oooo00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02oool50?ooo`030000003oool0
oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool01P3oool0
0`2oM000M;oo0?ooo`030?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo0`3oool000D0oooo00<0
_g@007Boo`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo00@0oooo00<0
00000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?oo
o`060?ooo`030;md001d_ol0oooo0080oooo00<0okmd001d_`3oool00P3oool00`3OW4P0B9cO0?oo
o`020?ooo`0000<0oooo0=nLB0000000100000001@1d_ol0oooo0?ooo`3OW4P0B9cO00<0oooo00<0
okmd001d_`3oool0103oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool80?ooo`030000003oool0oooo0080oooo00<0gia80000000000000`0000001@1d_ol0oooo0?oo
o`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool00P3oool000070?ooo`3o_g@0001d0;ooo`3oool0
_g@007Boo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool4000000D0
oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`D0oooo100000040?ooo`060?noM00007@0_ooo0?oo
o`2oM000M;oo0`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo0080oooo00020?oo
o`050=nLB000M;l0oooo0;md001d_ol00`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0
oooo00@0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool0
0`000000oooo0?ooo`030?ooo`050=nLB000M;l0oooo0;md001d_ol00`3oool00`3OW4P0B9cO0?oo
o`020?ooo`030?noM000M;l0oooo0080oooo00030?ooo`0409a80018W=l0_g@007Boo`<0oooo00<0
okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0oooo00H0oooo1_oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool0103oool0102LB000B9cO0;md
001d_ol30?ooo`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool00P3oool000<0oooo00@0
omnL04P0B018B000M;oo103oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`D0oooo00<000000?oo
o`3oool0o`3ooon00?ooo`030000003oool0oooo00@0oooo00@0omnL04P0B018B000M;oo103oool0
1P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`<0oooo00040?ooo`030?noM0000000M;oo00@0oooo00D0
oono07@000000000001809cOo`060?ooo`030000003oool0oooo00H0oooo1P0000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000P0oooo00<000000?ooo`3oool01@3oool00`3o_g@0000007Boo`040?ooo`050?oo
_`1d000000000000B02Lgol0103oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`060?ooo`H0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1P0000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Ko
oooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P00
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool80?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P00
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool80?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool80?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool60000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000040000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool80?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`P0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`06
0?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`06
0?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo203oool00`000000oooo0?ooo`0E0?ooo`000P3oool01@2oM0000000000000000000B9cO00@0
oooo00D0okmd000000000000000007Boo`060?ooo`030000003oool0oooo0?l0ooooP03oool00`00
0000oooo0?ooo`030?ooo`050;md00000000000000000018W=l0103oool01@3o_g@0000000000000
0000M;oo00@0oooo00000`3oool0_g@0001d_`020?ooo`030?oo_`1d0000B9cO00<0oooo00H0W4Qd
0;ooo`3oool0oono07@0M02oool50?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`P0oooo00<000000?ooo`3oool00P3oool01`2oM00007Bo0?ooo`3oool0oono07@0
0018W=l00`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`<0oooo00060?ooo`060?noM000M;l0
oooo0?ooo`3o_g@007Bo0`3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0oooo00H0oooo
1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool01`3oool01P3o_g@007Bo
0?ooo`3oool0okmd001d_`<0oooo00<0gia804RLg`3oool00P3oool000D0oooo00<0omnL04P0B02L
gol00P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<000000?ooo`3o
ool01P3oool6ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`060?ooo`03
0?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`00
0`3oool0103OW4P000000000B02Lgol30?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3o
ool0103oool4000000D0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`D0oooo100000060?ooo`04
0=nLB0000000001809cOo`<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?oo
o`001@3oool00`3ogi`0B01809cOo`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3o
ool0103oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool80?ooo`03
0000003oool0oooo00H0oooo00<0omnL04P0B02Lgol00P3oool00`3OW4P0B9cO0?ooo`020?ooo`03
0?noM000M;l0oooo0080oooo00060?ooo`060;md001d_ol0oooo0?ooo`3o_g@0B9cO0`3oool00`3O
W4P0B9cO0?ooo`040?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`P0oooo00<000000?ooo`3oool01`3oool01P2oM000M;oo0?ooo`3oool0okmd04RLg`<0oooo00<0
gia804RLg`3oool00P3oool000080?ooo`3o_g@0001809cOo`3oool0omnL04P0B02Lgol30?ooo`06
09a8001d_ol0oooo0?oOW01807@0_ooo1@3oool00`000000oooo0?ooo`3o0?oooh00oooo00<00000
0?ooo`3oool00P3oool01`3o_g@0001809cOo`3oool0omnL04P0B02Lgol00`3oool01P2LB000M;oo
0?ooo`3ogi`0B01d0;ooo`<0oooo00020?ooo`050?oOW018000000000000001d_ol0103oool01@3o
okl0M0000000000004P0W=oo00H0oooo00<000000?ooo`3oool01P3oool6000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo203oool00`000000oooo0?ooo`030?ooo`050?oOW018000000000000001d_ol0103o
ool01@3ookl0M0000000000004P0W=oo00@0oooo000F0?ooo`030000003oool0oooo00H0oooo1P00
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000000000040000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000040000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`3o
0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool60000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000080?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`06
0?ooo`H0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00H0oooo1P0000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`06
0?ooo`Kooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
0000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`06
0?ooo`Kooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
0000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0?l0
ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0
oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0
oooo1_ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000P0oooo00<000000?ooo`3oool05@3oool000030?oo_`1d0000000000@0000000D0
M;oo0?ooo`3oool0oooo0?noM0030000000307Boo`3oool0oooo00@0oooo00<000000?ooo`3oool0
o`3ooon00?ooo`060000003oool0oooo0?ooo`3ookl0M0001@0000001@1d_ol0oooo0?ooo`3oool0
okmd00<0000000<0M;oo0?ooo`3oool00P3oool000040?ooo`2oM000001d0;ooo`80oooo00<0giad
09cOo`3oool00P3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`D0oooo00<000000?ooo`3oool0
1P3oool6000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@00000203oool00`000000oooo0?ooo`020?ooo`030;md
000007@0_ooo0080oooo00<0giad09cOo`3oool00P3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oo
o`<0oooo00020?ooo`030?noM00004P0W=oo00D0oooo00<0okmd001d_`3oool00P3oool00`3OW4P0
B9cO0?ooo`040?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000P0
oooo00<000000?ooo`3oool00`3oool00`3o_g@0001809cOo`050?ooo`030?noM000M;l0oooo0080
oooo00<0gia804RLg`3oool00P3oool000<0oooo00<0omnL04P00018W=l0103oool00`3OW4P0B9cO
0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<000000?ooo`3oool01P3oool6000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@00000203oool00`000000oooo0?ooo`040?ooo`030?oOW0180000B9cO00@0oooo
00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`001@3oool00`2LB000B9cO0?oo
o`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool4000000D0oooo1P00
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000D0oooo100000080?ooo`0309a80018W=l0oooo0080oooo00<0
gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`001P3oool01P2LB7@0_ooo0?ooo`3o
ool0gia804RLg`<0oooo00<0okmd001d_`3oool0103oool00`000000oooo0?ooo`060?ooo`H00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000080?ooo`030000003oool0oooo00L0oooo00H0W4Qd0;ooo`3oool0
oooo0=nLB018W=l30?ooo`030?noM000M;l0oooo0080oooo00000`3oool0gia807Boo`030?ooo`06
0;md001d_ol0oooo0?ooo`3o_g@0B9cO0`3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0
oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000P0oooo00<000000?ooo`3oool00P3oool0
0`3OW4P0M;oo0?ooo`020?ooo`060;md001d_ol0oooo0?ooo`3o_g@0B9cO0`3oool00`3OW4P0B9cO
0?ooo`020?ooo`0000P0oooo0?noM00007@0_ooo0?ooo`3o_g@0001809cOo`<0oooo00H0W4P007Bo
o`3oool0omnL04P0M02oool50?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?oo
o`020?ooo`070?noM00007@0_ooo0?ooo`3o_g@0001809cOo`030?ooo`0609a8001d_ol0oooo0?oO
W01807@0_ooo0`3oool00080oooo00D0okmd000000000000001809cOo`040?ooo`050?oo_`1d0000
00000000B02Lgol01P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool80?ooo`030000003oool0oooo00<0oooo00D0okmd000000000000001809cOo`040?ooo`050?oo
_`1d000000000000B02Lgol0103oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`060?ooo`H0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo
00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1P0000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Ko
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0?l0ooooP03o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P00
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P00
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000080?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000080?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1P3oool6ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool60000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`06
0?ooo`H0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`06
0?ooo`H0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
0000203oool00`000000oooo0?ooo`0E0?ooo`0000<0oooo0?noM0000000100000001@00M;l0oooo
0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooh00
oooo00<000000?ooo`3oool00P3oool00`3o_g@000000000000300000005001d_`3oool0oooo0?oo
o`3o_g@00`0000000`1d_ol0oooo0?ooo`020?ooo`00103oool00`2LB4P0W=oo0?ooo`040?ooo`06
09a8M02oool0oooo0?oo_`1d07@0_ooo1@3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool80?ooo`030000003oool0oooo00D0oooo00<0W4Q809cOo`3oool0103oool0
1P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`<0oooo00040?ooo`0309a8B02Lgol0oooo00<0oooo00<0
okmd001d_`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0oooo00H0oooo1_oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool01@3oool00`2LB4P0W=oo0?oo
o`030?ooo`030?noM000M;l0oooo0080oooo00<0gia804RLg`3oool00P3oool000@0oooo00<0W4Q8
09cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<00000
0?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`05
0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`02
0?ooo`00103oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d
_`3oool0103oool4000000D0oooo1_ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`D0oooo100000070?oo
o`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?oo
o`00103oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3o
ool0103oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`03
0000003oool0oooo00D0oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`03
0?noM000M;l0oooo0080oooo00040?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd04RLg`3oool0
0P3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`P0oooo00<000000?ooo`3oool01@3oool00`2LB4P0W=oo0?ooo`030?ooo`030?no
M018W=l0oooo0080oooo00<0gia804RLg`3oool00P3oool000060?ooo`3OW4P000000018W02LB4P0
W=oo1@3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`D0oooo00<000000?ooo`3oool01P3oool6
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0000000000005
000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`020?ooo`050=nLB0000000
04RL09a8B02Lgol01@3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`<0oooo00030?ooo`030=nL
B00004P0W=oo00D0oooo00D0oono07@000000000001809cOo`060?ooo`030000003oool0oooo0?l0
ooooP03oool00`000000oooo0?ooo`040?ooo`030=nLB00004P0W=oo00D0oooo00D0oono07@00000
0000001809cOo`040?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000
0000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo
1P0000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<0
00000?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000000000001000
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@00000203oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000008
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01P3oool6000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<0
00000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000008
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000080?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon0
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01P3oool6000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooo
ooooooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3ooooo
ooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooo
ooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0
000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0
000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0
000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooo
ooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0
000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooo
ooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000
00000005000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000
00000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3ooooooooo
ooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooo
ooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6
000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`060?ooo`H0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3ooooooooooooo
o`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000
0004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3ooooooooooooo
o`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000
0005000000030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000
0005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3ooooooooooooo
o`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3ooooooooooooo
o`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6
ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004
000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04
ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004
000000030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05
ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005
000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool000000000000500000003
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
o`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`060?ooo`Kooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05oooo
o`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04oooo
o`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oool00000000000050000
00030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool00000000000040000
00030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04oooo
o`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`03
0?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool000000000000500000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`03
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oool000000000000400000003
0?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`03
0?ooo`000000000000@0000000<0ooooooooooooool01Oooool00`3oool000000000000400000003
0?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oo
o`000000000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oo
oooooooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
o`000000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oo
oooooooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oo
o`000000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oo
oooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`060?ooo`H0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo
00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`060?ooo`Kooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooo
oooooooo00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooo
oooooooo00Cooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooo
oooooooo00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`00
0000000000@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`00
0000000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`00
0000000000@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`00
0000000000D0000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000
000000@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooo
oooo00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooo
oooo00Cooooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000
000000D0000000<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooo
oooo00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000
000000@0000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000
000000@0000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Ko
oooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`3o0?oooh00oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`0000000000
00@0000000<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00@0000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`0000000000
00D0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`0000000000
00@0000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo
00Gooooo00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo
00Cooooo00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`0000000000
00D0000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo
00Gooooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo
00Cooooo00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo
00Cooooo203oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Ko
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Co
oooo00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0
000000<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0
000000<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0
000000<0ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Go
oooo00<0ooooooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
ooooooooool01?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00H0oooo1_ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000
00000000100000000`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00H0oooo1_ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo
00<0oooo0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D00000
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@00000
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo000000000000100000000`3oool0000000000005000000030?ooo`000000000000@00000
00<0oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo
00<0oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo
00<0ooooooooooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0
oooo0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
oooo000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0
oooo000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0
ooooooooooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0
ooooooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo
000000000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo
ooooooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo
0000000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo
000000000000100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00H0oooo1_ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@00000203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`Kooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo000000000000
100000080?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1_oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00H0oooo1P0000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000
00000000100000000`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooo
ooooool01Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000
00000000100000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooooooo
ooooool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooo
ooooool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000
000000001@0000000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000
0000100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000
0000100000000`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?ooo`000000000000@0000000<0oooooooooooo
ool01Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo00000000
00001@0000000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000
0000100000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooooooooooo
ool01?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooooooooooo
ool01?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo000000000000
1@0000000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000
100000000`3oool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000
100000000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool0
1?ooool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo000000000000
1@0000000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool0
1Oooool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool0
1?ooool00`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool0
1?ooool80?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00H0oooo1P00
00000`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo0000000000001000
00000`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Ooo
ool00`3oool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo0000000000001000
00000`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01?oo
ool00`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?oo
ool00`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Ooo
ool00`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@00
00000`3oooooooooooooo`04ooooo`P0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01P3oool6000000030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oool0000000000004000000030?ooo`000000000000D0000000<0oooo00000000000010000000
0`3oooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0oooo00000000000010000000
0`3oool0000000000005000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?ooo`000000000000@0000000<0ooooooooooooool01Oooool0
0`3oool0000000000004000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@000000
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool0
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0oooo00000000000010000000
0`3oooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool0
0`3oooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool0
0`3oool0000000000005000000030?oooooooooooooo00Cooooo203oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`060?ooo`H0000000<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?ooo`000000000000@0000000<0oooo0000000000001@0000000`3o
ool0000000000004000000030?oooooooooooooo00Gooooo00<0oooo000000000000100000000`3o
ool0000000000004000000030?ooo`000000000000D0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0oooo000000000000100000000`3o
ooooooooooooo`05ooooo`030?ooo`000000000000@0000000<0ooooooooooooool01?ooool00`3o
ool0000000000005000000030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Cooooo00<0oooo0000000000001@0000000`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`05ooooo`030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ool0000000000004000000030?oooooooooooooo00Cooooo00<0ooooooooooooool01Oooool00`3o
ooooooooooooo`04ooooo`030?oooooooooooooo00Gooooo00<0ooooooooooooool01?ooool00`3o
ooooooooooooo`04ooooo`030?ooo`000000000000D0000000<0ooooooooooooool01?ooool80?oo
o`030000003oool0oooo01D0oooo000;0?ooo`050?noM000000000000000001d_ol01P3oool00`00
0000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool00`3oool01@3o_g@00000000000000000
M;oo00d0oooo000;0?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo1@3oool00`000000oooo0?oo
o`3o0?oooh00oooo00<000000?ooo`3oool00`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo``0
oooo000:0?ooo`030?noM000M;l0oooo0080oooo00<0gia804RLg`3oool0103oool00`000000oooo
0?ooo`3o0?oooh00oooo00<000000?ooo`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`030=nL
B018W=l0oooo00/0oooo000:0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103o
ool00`000000oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool00P3oool00`3OW4P0B9cO0?oo
o`020?ooo`030?noM000M;l0oooo00/0oooo000:0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd
001d_`3oool0103oool400000?l0ooooO03oool4000000@0oooo00<0gia804RLg`3oool00P3oool0
0`3o_g@007Bo0?ooo`0;0?ooo`002P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo
00@0oooo00D000000?ooo`3oool0oooo000000190?ooo`030000003oool0oooo04L0oooo00<00000
0?ooo`3oool0A`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo04P0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd
001d_`3oool02`3oool000X0oooo00<0okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`040?oo
o`050000003oool0oooo0?ooo`000000B@3oool00`000000oooo0?ooo`170?ooo`030000003oool0
oooo04L0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`180?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool00P3oool00`3o_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0
oooo00/0oooo000;0?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo1@3oool01@000000oooo0?oo
o`3oool0000004T0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`170?ooo`030000
003oool0oooo04L0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00<0oooo00H0W4P007Boo`3oool0omnL04P0M02oool<0?ooo`002`3oool01@3ookl0
M0000000000004P0W=oo00H0ooooo`000024000000D0oooo00D0oono07@000000000001809cOo`0=
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00603oool01@3o_g@000000000
00000000M;oo03l0oooo00<0okmd0000000000000`0000001@00M;l0oooo0?ooo`3oool0okmd00<0
000000<0M;oo0?ooo`3oool0>03oool00`3ookl0M000000000040000000507Boo`3oool0oooo0?oo
o`3o_g@00`0000000`1d_ol0oooo0?ooo`0j0?ooo`050;md00000000000000000018W=l0103oool0
1@3o_g@00000000000000000M;oo03d0oooo00D0omnL04P000000000000007Boo`030?ooo`050?no
M000000000000000001d_ol0?@3oool01@2oM0000000000000000000M;oo00@0oooo00D0okmd0000
00000000000007Boo`0L0?ooo`00603oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oood40oooo00<0
W4Q809cOo`3oool0103oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooocX0oooo00<0_g@00000M02o
ool00P3oool00`3OW7@0W=oo0?ooo`020?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo>P3oool0
1`2oM00007Bo0?ooo`3oool0oono07@00018W=l00`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oo
och0oooo00<0_g@007Boo`3oool00`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oooc/0oooo00L0
_g@0001d_`3oool0oooo0?oOW0180000M;oo00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02ooolK
0?ooo`005`3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo0400oooo00<0W4Q809cO
o`3oool00`3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo03X0oooo00<0okmd0000
B02Lgol01@3oool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo03h0oooo00H0okmd001d
_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0oooo03d0oooo00<0_g@007Boo`3oool00P3o
ool00`3o_g@007Bo0?ooo`020?ooo`030=nLB018W=l0oooo03l0oooo00H0okmd001d_`3oool0oooo
0?noM000M;l30?ooo`030=nLB018W=l0oooo01X0oooo000G0?ooo`030=nLB018W=l0oooo0080oooo
00<0okmd001d_`3oool0@03oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo
00<0okmd001d_`3oool0>`3oool00`3ogi`0B00004RLg`040?ooo`030=nLB018W=l0oooo0080oooo
00<0okmd001d_`3oool0?@3oool00`3ogi`0B01809cOo`020?ooo`030=nLB018W=l0oooo0080oooo
00<0okmd001d_`3oool0>@3oool00`3OW4P00000000000030000000507Boo`3oool0oooo0=nLB018
W=l00`3oool00`3o_g@007Bo0?ooo`0o0?ooo`060?noM000M;l0oooo0?ooo`3OW4P0B9cO0`3oool0
0`3o_g@007Bo0?ooo`0J0?ooo`005`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo
0400oooo00<0W4Q809cOo`3oool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo
03d0oooo00<0W4P004RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo
03/0oooo00@0gia80000000004P0W=oo0`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0
oooo03T0oooo00H0okmd0000M02oool0oooo0;md001d_ol30?ooo`030=nLB018W=l0oooo0080oooo
00<0okmd001d_`3oool0?`3oool01P2LB000M;oo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d
_`3oool06P3oool001L0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`100?ooo`03
09a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0n0?ooo`06
09a8M02oool0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@007Bo0?ooo`0m0?ooo`030?oOW01804P0
W=oo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0j0?ooo`050=nLB000M;l0
oooo0;md001d_ol00`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03X0oooo00<0
oono07@0000000000P0000001P18W=l0oooo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3o
ool06P3oool001L0oooo00<0okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`100?ooo`0309a8
B02Lgol0oooo00<0oooo00<0okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`0i0?ooo`030=nL
B01d_ol0oooo0080oooo00H0_g@007Boo`3oool0oooo0?noM018W=l30?ooo`030=nLB018W=l0oooo
03h0oooo00H0_g@007Boo`3oool0oooo0?noM018W=l30?ooo`030=nLB018W=l0oooo03/0oooo00@0
W4P004RLg`2oM000M;oo0`3oool00`3o_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo03X0oooo
00<0oono07@0M02oool01P3oool00`3o_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo01X0oooo
000H0?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo?P3oool01@3OW4P000000018W02LB4P0W=oo
00D0oooo00H0W4P007Boo`3oool0omnL04P0M02ooolj0?ooo`070?noM00007@0_ooo0?ooo`3o_g@0
001809cOo`030?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo>P3oool01`3o_g@0001809cOo`3o
ool0omnL04P0B02Lgol00`3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;oooc`0oooo00@0omnL04P0
B018B000M;oo103oool01P2LB000M;oo0?ooo`3ogi`0B01d0;oooc/0oooo00<0oono07@0M02oool0
1`3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;oooa/0oooo000H0?ooo`050?oo_`1d000000000000
B02Lgol0@@3oool00`3OW4P0001809cOo`050?ooo`050?oo_`1d000000000000B02Lgol0?03oool0
1@3o_g@000000000000004P0W=oo00@0oooo00D0oono07@000000000001809cOo`0l0?ooo`050?oO
W018000000000000001d_ol0103oool01@3ookl0M0000000000004P0W=oo03h0oooo00<0okmd0000
001d_ol0103oool01@3ookl0M0000000000004P0W=oo03`0oooo00<0oono07@0000000000P000000
0`0007@0_ooo0?ooo`020?ooo`050?oo_`1d000000000000B02Lgol0703oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287.313}, {287.313, 0}} -> {-3.57915, -54.5791, \
0.202407, 0.202407}}]
}, Open  ]],

Cell[TextData[{
  "Color can be given to the picture with the ",
  StyleBox["ColorFunction", "MR"],
  " option."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MatrixPlot[Table[\ Random[Integer], {50}, {50}], \ 
        ColorFunction \[Rule] \((RGBColor[#, 0, 0] &)\)];\)\)], "Input",
  CellLabel->"In[6]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00961538 0.0192308 0.990385 0.0192308 [
[.00962 -0.0125 -3 -9 ]
[.00962 -0.0125 3 0 ]
[.20192 -0.0125 -6 -9 ]
[.20192 -0.0125 6 0 ]
[.39423 -0.0125 -6 -9 ]
[.39423 -0.0125 6 0 ]
[.58654 -0.0125 -6 -9 ]
[.58654 -0.0125 6 0 ]
[.77885 -0.0125 -6 -9 ]
[.77885 -0.0125 6 0 ]
[.97115 -0.0125 -6 -9 ]
[.97115 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02885 -12 -4.5 ]
[-0.0125 .02885 0 4.5 ]
[-0.0125 .22115 -12 -4.5 ]
[-0.0125 .22115 0 4.5 ]
[-0.0125 .41346 -12 -4.5 ]
[-0.0125 .41346 0 4.5 ]
[-0.0125 .60577 -12 -4.5 ]
[-0.0125 .60577 0 4.5 ]
[-0.0125 .79808 -12 -4.5 ]
[-0.0125 .79808 0 4.5 ]
[-0.0125 .99038 -6 -4.5 ]
[-0.0125 .99038 0 4.5 ]
[ 0 0 -0.125 0 ]
[.00962 1.0125 -3 0 ]
[.00962 1.0125 3 9 ]
[.20192 1.0125 -6 0 ]
[.20192 1.0125 6 9 ]
[.39423 1.0125 -6 0 ]
[.39423 1.0125 6 9 ]
[.58654 1.0125 -6 0 ]
[.58654 1.0125 6 9 ]
[.77885 1.0125 -6 0 ]
[.77885 1.0125 6 9 ]
[.97115 1.0125 -6 0 ]
[.97115 1.0125 6 9 ]
[ 0 1 .125 0 ]
[1.0125 .02885 0 -4.5 ]
[1.0125 .02885 12 4.5 ]
[1.0125 .22115 0 -4.5 ]
[1.0125 .22115 12 4.5 ]
[1.0125 .41346 0 -4.5 ]
[1.0125 .41346 12 4.5 ]
[1.0125 .60577 0 -4.5 ]
[1.0125 .60577 12 4.5 ]
[1.0125 .79808 0 -4.5 ]
[1.0125 .79808 12 4.5 ]
[1.0125 .99038 0 -4.5 ]
[1.0125 .99038 6 4.5 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00962 0 m
.00962 .00625 L
s
[(0)] .00962 -0.0125 0 1 Mshowa
.20192 0 m
.20192 .00625 L
s
[(10)] .20192 -0.0125 0 1 Mshowa
.39423 0 m
.39423 .00625 L
s
[(20)] .39423 -0.0125 0 1 Mshowa
.58654 0 m
.58654 .00625 L
s
[(30)] .58654 -0.0125 0 1 Mshowa
.77885 0 m
.77885 .00625 L
s
[(40)] .77885 -0.0125 0 1 Mshowa
.97115 0 m
.97115 .00625 L
s
[(50)] .97115 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .02885 m
.00625 .02885 L
s
[(50)] -0.0125 .02885 1 0 Mshowa
0 .22115 m
.00625 .22115 L
s
[(40)] -0.0125 .22115 1 0 Mshowa
0 .41346 m
.00625 .41346 L
s
[(30)] -0.0125 .41346 1 0 Mshowa
0 .60577 m
.00625 .60577 L
s
[(20)] -0.0125 .60577 1 0 Mshowa
0 .79808 m
.00625 .79808 L
s
[(10)] -0.0125 .79808 1 0 Mshowa
0 .99038 m
.00625 .99038 L
s
[(0)] -0.0125 .99038 1 0 Mshowa
0 0 m
0 1 L
s
.00962 .99375 m
.00962 1 L
s
[(0)] .00962 1.0125 0 -1 Mshowa
.20192 .99375 m
.20192 1 L
s
[(10)] .20192 1.0125 0 -1 Mshowa
.39423 .99375 m
.39423 1 L
s
[(20)] .39423 1.0125 0 -1 Mshowa
.58654 .99375 m
.58654 1 L
s
[(30)] .58654 1.0125 0 -1 Mshowa
.77885 .99375 m
.77885 1 L
s
[(40)] .77885 1.0125 0 -1 Mshowa
.97115 .99375 m
.97115 1 L
s
[(50)] .97115 1.0125 0 -1 Mshowa
0 1 m
1 1 L
s
.99375 .02885 m
1 .02885 L
s
[(50)] 1.0125 .02885 -1 0 Mshowa
.99375 .22115 m
1 .22115 L
s
[(40)] 1.0125 .22115 -1 0 Mshowa
.99375 .41346 m
1 .41346 L
s
[(30)] 1.0125 .41346 -1 0 Mshowa
.99375 .60577 m
1 .60577 L
s
[(20)] 1.0125 .60577 -1 0 Mshowa
.99375 .79808 m
1 .79808 L
s
[(10)] 1.0125 .79808 -1 0 Mshowa
.99375 .99038 m
1 .99038 L
s
[(0)] 1.0125 .99038 -1 0 Mshowa
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of colorimage (RGB)
p
.01923 .01923 translate
.96154 .96154 scale
150 string
50 50 8 [50 0 0 50 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  false 3 Mcolorimage
FF0000FF0000FF0000000000FF0000000000FF0000FF0000FF0000000000000000000000
000000FF0000FF0000000000FF0000000000FF0000000000000000000000000000000000
FF0000000000FF0000FF0000FF0000000000000000000000FF0000FF0000000000FF0000
000000FF0000000000000000000000FF0000000000000000FF0000FF0000000000FF0000
000000000000
FF0000FF0000000000FF0000FF0000FF0000000000000000FF0000000000000000FF0000
FF0000000000FF0000000000FF0000000000000000000000FF0000FF0000FF0000FF0000
000000000000FF0000FF0000000000000000000000FF0000FF0000000000FF0000FF0000
FF0000000000000000000000000000000000000000000000FF0000000000000000FF0000
FF0000000000
FF0000000000000000000000FF0000000000FF0000000000FF0000FF0000FF0000FF0000
FF0000000000FF0000FF0000FF0000FF0000FF0000FF0000FF0000000000FF0000000000
FF0000FF0000FF0000000000FF0000000000000000000000FF0000FF0000FF0000000000
000000000000FF0000000000FF0000FF0000FF0000FF0000FF0000FF0000FF0000000000
000000FF0000
FF0000000000000000FF0000FF0000FF0000000000000000000000FF0000000000000000
000000FF0000FF0000000000000000FF0000000000FF0000000000000000000000000000
FF0000000000FF0000FF0000FF0000FF0000FF0000FF0000000000FF0000000000FF0000
000000FF0000FF0000000000FF0000FF0000FF0000FF0000FF0000000000000000000000
FF0000000000
000000000000000000FF0000000000FF0000000000FF0000000000000000000000FF0000
FF0000000000FF0000000000FF0000FF0000FF0000000000FF0000FF0000000000FF0000
FF0000000000000000000000FF0000FF0000FF0000000000000000FF0000000000000000
FF0000000000FF0000FF0000FF0000000000000000000000000000000000000000FF0000
FF0000000000
FF0000000000FF0000000000000000000000FF0000000000FF0000000000FF0000FF0000
000000000000000000000000000000FF0000000000FF0000000000000000000000FF0000
000000FF0000FF0000FF0000FF0000000000FF0000FF0000000000000000000000000000
FF0000000000000000000000000000FF0000FF0000000000FF0000FF0000FF0000FF0000
FF0000FF0000
FF0000000000FF0000000000000000FF0000FF0000FF0000000000000000FF0000FF0000
FF0000FF0000000000000000000000FF0000FF0000FF0000000000000000000000000000
FF0000000000FF0000FF0000000000000000FF0000000000000000000000000000000000
000000000000FF0000000000000000FF0000000000FF0000FF0000FF0000000000FF0000
FF0000FF0000
000000000000000000000000000000000000000000FF0000000000FF0000000000FF0000
FF0000FF0000FF0000000000000000000000000000FF0000FF0000000000FF0000FF0000
FF0000FF0000FF0000000000000000FF0000FF0000FF0000000000000000000000FF0000
000000FF0000FF0000FF0000FF0000FF0000FF0000FF0000FF0000FF0000000000000000
000000FF0000
000000FF0000FF0000000000000000FF0000000000FF0000FF0000000000000000000000
FF0000FF0000FF0000000000000000FF0000FF0000000000FF0000000000000000000000
FF0000FF0000FF0000FF0000FF0000000000FF0000000000000000FF0000FF0000000000
FF0000FF0000000000000000000000000000FF0000000000000000FF0000FF0000000000
FF0000000000
000000FF0000FF0000FF0000000000000000FF0000000000FF0000000000FF0000000000
FF0000000000FF0000FF0000FF0000FF0000000000000000000000000000FF0000000000
FF0000000000FF0000000000FF0000FF0000FF0000FF0000FF0000000000000000FF0000
FF0000000000FF0000FF0000FF0000FF0000FF0000000000000000FF0000000000FF0000
000000FF0000
FF0000000000FF0000000000000000FF0000FF0000FF0000000000FF0000FF0000FF0000
FF0000000000000000FF0000FF0000FF0000000000FF0000FF0000FF0000000000FF0000
FF0000FF0000000000FF0000FF0000000000000000000000000000000000FF0000FF0000
000000000000FF0000000000000000000000000000FF0000000000FF0000FF0000000000
000000FF0000
FF0000000000FF0000FF0000FF0000FF0000000000000000000000FF0000FF0000000000
FF0000FF0000FF0000FF0000000000FF0000FF0000000000FF0000FF0000FF0000000000
FF0000000000000000FF0000FF0000000000000000FF0000FF0000000000000000FF0000
FF0000000000000000000000FF0000000000000000FF0000FF0000000000000000FF0000
000000000000
FF0000000000FF0000FF0000000000000000000000FF0000FF0000FF0000000000000000
FF0000FF0000FF0000FF0000000000FF0000FF0000FF0000FF0000000000FF0000000000
000000000000FF0000FF0000FF0000000000FF0000000000000000000000FF0000000000
FF0000FF0000FF0000FF0000FF0000FF0000000000FF0000000000000000FF0000FF0000
000000000000
FF0000000000FF0000FF0000FF0000000000FF0000000000FF0000000000000000FF0000
000000FF0000FF0000FF0000000000000000FF0000FF0000FF0000FF0000FF0000FF0000
FF0000FF0000FF0000FF0000FF0000FF0000000000FF0000FF0000FF0000000000000000
FF0000FF0000000000FF0000FF0000000000FF0000000000000000FF0000000000000000
FF0000FF0000
FF0000000000FF0000FF0000000000000000FF0000FF0000FF0000FF0000000000FF0000
FF0000000000000000FF0000000000000000FF0000000000000000000000FF0000FF0000
FF0000000000FF0000FF0000FF0000FF0000000000FF0000FF0000000000000000000000
FF0000FF0000FF0000000000000000FF0000000000FF0000FF0000FF0000FF0000000000
FF0000FF0000
000000000000FF0000FF0000FF0000FF0000FF0000000000000000FF0000FF0000FF0000
FF0000FF0000FF0000FF0000000000000000FF0000FF0000FF0000FF0000FF0000000000
000000000000000000FF0000FF0000FF0000000000FF0000FF0000FF0000000000000000
FF0000FF0000FF0000000000FF0000000000000000000000FF0000FF0000FF0000FF0000
FF0000000000
000000000000000000FF0000000000000000000000FF0000FF0000FF0000000000FF0000
FF0000FF0000FF0000000000000000000000000000FF0000000000000000000000000000
000000000000000000000000FF0000FF0000FF0000FF0000000000000000FF0000000000
FF0000000000FF0000FF0000FF0000000000000000000000FF0000000000FF0000000000
000000FF0000
FF0000000000FF0000000000FF0000FF0000FF0000000000000000FF0000FF0000000000
FF0000000000FF0000FF0000FF0000000000000000FF0000FF0000000000FF0000FF0000
FF0000FF0000000000000000FF0000000000000000000000000000FF0000000000FF0000
FF0000FF0000000000FF0000000000FF0000FF0000FF0000000000FF0000FF0000FF0000
000000000000
FF0000FF0000000000FF0000000000FF0000000000000000000000000000FF0000000000
FF0000000000000000FF0000FF0000FF0000000000FF0000FF0000FF0000FF0000000000
000000000000FF0000FF0000000000FF0000FF0000FF0000FF0000000000FF0000000000
000000000000000000FF0000FF0000000000000000FF0000000000FF0000FF0000000000
FF0000000000
000000000000FF0000000000FF0000FF0000000000FF0000FF0000FF0000FF0000FF0000
FF0000000000FF0000FF0000FF0000FF0000FF0000000000FF0000FF0000000000000000
000000000000FF0000000000FF0000FF0000FF0000FF0000000000FF0000FF0000FF0000
FF0000000000000000000000FF0000000000FF0000FF0000000000FF0000000000000000
000000FF0000
000000FF0000FF0000FF0000000000000000000000FF0000FF0000FF0000000000FF0000
FF0000000000FF0000000000000000000000000000FF0000FF0000FF0000000000000000
000000FF0000000000FF0000FF0000FF0000FF0000000000000000000000000000FF0000
000000FF0000FF0000FF0000000000000000FF0000000000FF0000000000FF0000FF0000
FF0000000000
000000000000FF0000FF0000000000000000000000000000000000000000000000000000
000000000000000000000000FF0000000000FF0000FF0000000000FF0000FF0000FF0000
FF0000000000FF0000000000FF0000000000FF0000000000000000FF0000000000FF0000
000000FF0000FF0000FF0000FF0000FF0000FF0000000000FF0000000000FF0000FF0000
000000FF0000
FF0000000000FF0000000000000000000000000000FF0000000000FF0000000000000000
FF0000FF0000000000000000FF0000000000000000000000000000FF0000FF0000000000
FF0000000000000000000000FF0000FF0000FF0000FF0000000000FF0000000000000000
FF0000FF0000000000FF0000000000FF0000FF0000FF0000FF0000000000FF0000000000
FF0000FF0000
FF0000FF0000FF0000FF0000FF0000FF0000FF0000000000000000FF0000FF0000FF0000
000000FF0000FF0000FF0000000000FF0000FF0000FF0000FF0000FF0000000000FF0000
000000000000FF0000000000000000FF0000FF0000000000FF0000000000FF0000FF0000
000000FF0000FF0000FF0000000000FF0000FF0000000000FF0000FF0000000000FF0000
000000000000
000000000000FF0000FF0000FF0000000000FF0000FF0000000000FF0000000000FF0000
000000000000000000FF0000000000000000000000000000FF0000FF0000FF0000FF0000
000000000000FF0000FF0000FF0000000000FF0000FF0000000000FF0000000000FF0000
FF0000FF0000000000000000000000FF0000FF0000000000FF0000000000FF0000000000
000000000000
FF0000FF0000000000000000FF0000FF0000FF0000FF0000000000000000000000000000
000000000000000000FF0000000000FF0000FF0000FF0000000000FF0000FF0000FF0000
000000FF0000FF0000000000FF0000000000FF0000FF0000FF0000FF0000FF0000000000
FF0000FF0000FF0000000000FF0000FF0000FF0000FF0000000000FF0000000000000000
FF0000000000
000000FF0000000000000000FF0000000000000000000000FF0000000000000000FF0000
FF0000000000FF0000FF0000FF0000FF0000000000FF0000000000FF0000000000FF0000
000000FF0000000000FF0000000000FF0000000000000000000000000000FF0000000000
FF0000FF0000FF0000FF0000000000FF0000FF0000000000FF0000FF0000000000FF0000
FF0000FF0000
FF0000FF0000FF0000FF0000000000FF0000000000000000FF0000000000000000FF0000
000000000000000000000000000000FF0000FF0000000000FF0000FF0000FF0000000000
FF0000FF0000000000000000FF0000FF0000FF0000FF0000000000FF0000FF0000FF0000
FF0000000000000000FF0000FF0000000000000000FF0000000000FF0000FF0000000000
000000000000
000000FF0000FF0000000000FF0000FF0000FF0000FF0000FF0000000000FF0000000000
FF0000000000FF0000FF0000FF0000000000000000FF0000FF0000000000FF0000FF0000
000000000000000000000000000000FF0000FF0000000000FF0000000000FF0000FF0000
FF0000FF0000FF0000FF0000FF0000000000000000000000000000000000000000FF0000
000000000000
000000000000FF0000000000000000FF0000000000FF0000000000FF0000FF0000000000
FF0000FF0000000000FF0000000000FF0000FF0000000000FF0000000000FF0000FF0000
000000FF0000000000000000FF0000000000FF0000000000000000000000FF0000000000
000000000000000000000000FF0000000000000000FF0000FF0000FF0000FF0000FF0000
FF0000FF0000
FF0000FF0000000000000000FF0000FF0000FF0000000000000000FF0000000000FF0000
FF0000000000000000000000FF0000000000000000000000000000000000FF0000FF0000
FF0000000000000000000000000000FF0000FF0000000000000000FF0000000000FF0000
000000000000000000FF0000000000000000000000FF0000000000FF0000000000FF0000
000000FF0000
000000FF0000000000000000000000000000FF0000000000000000000000FF0000FF0000
FF0000FF0000000000000000000000000000000000FF0000FF0000FF0000FF0000FF0000
FF0000FF0000000000000000000000FF0000FF0000000000FF0000FF0000000000000000
FF0000000000FF0000000000000000FF0000FF0000FF0000000000000000FF0000000000
FF0000000000
000000000000000000000000FF0000FF0000000000000000FF0000FF0000FF0000000000
000000000000000000FF0000000000000000FF0000FF0000FF0000FF0000FF0000FF0000
FF0000000000FF0000000000000000FF0000FF0000000000FF0000FF0000000000FF0000
000000000000000000000000FF0000FF0000FF0000FF0000000000000000000000FF0000
FF0000000000
000000FF0000FF0000000000000000000000FF0000FF0000FF0000FF0000000000000000
FF0000FF0000FF0000FF0000000000000000000000000000FF0000FF0000FF0000FF0000
000000000000FF0000FF0000000000000000FF0000000000000000FF0000FF0000000000
000000FF0000000000FF0000FF0000000000000000000000FF0000FF0000000000FF0000
000000000000
FF0000000000FF0000000000000000000000000000000000000000FF0000FF0000FF0000
FF0000FF0000000000000000FF0000FF0000FF0000000000000000FF0000FF0000000000
FF0000FF0000000000FF0000FF0000FF0000000000FF0000000000FF0000000000000000
000000FF0000FF0000000000000000000000FF0000FF0000000000FF0000FF0000000000
000000000000
000000000000000000FF0000000000000000FF0000000000FF0000FF0000000000000000
000000000000FF0000000000FF0000FF0000FF0000FF0000000000FF0000000000000000
000000FF0000000000000000FF0000000000000000000000000000FF0000FF0000FF0000
000000FF0000000000000000000000000000000000FF0000FF0000FF0000FF0000000000
000000000000
000000000000000000000000000000FF0000FF0000000000000000000000FF0000000000
FF0000000000000000FF0000000000000000000000FF0000FF0000FF0000FF0000FF0000
FF0000000000FF0000000000000000000000FF0000000000000000000000000000000000
FF0000FF0000FF0000FF0000FF0000FF0000000000FF0000000000000000FF0000000000
FF0000FF0000
000000000000000000FF0000000000000000000000000000FF0000000000000000FF0000
000000000000000000000000000000000000FF0000000000FF0000FF0000000000000000
FF0000000000000000FF0000000000FF0000000000FF0000000000000000000000FF0000
000000FF0000FF0000FF0000FF0000FF0000000000000000FF0000FF0000FF0000FF0000
000000000000
FF0000000000000000FF0000000000FF0000FF0000FF0000FF0000FF0000000000FF0000
000000FF0000000000FF0000FF0000000000FF0000FF0000000000FF0000FF0000000000
FF0000000000FF0000FF0000000000FF0000FF0000FF0000FF0000FF0000000000000000
000000FF0000FF0000FF0000000000000000FF0000000000000000000000FF0000FF0000
FF0000FF0000
FF0000000000FF0000FF0000FF0000FF0000000000FF0000000000000000FF0000000000
000000000000FF0000FF0000FF0000000000FF0000000000FF0000FF0000FF0000000000
000000FF0000000000000000000000000000FF0000000000000000000000000000000000
000000FF0000000000FF0000000000000000000000000000FF0000FF0000FF0000000000
FF0000FF0000
FF0000FF0000FF0000FF0000FF0000000000000000000000000000000000000000000000
FF0000000000000000000000FF0000FF0000FF0000000000FF0000000000000000000000
000000FF0000000000FF0000FF0000FF0000FF0000FF0000000000000000FF0000000000
FF0000FF0000FF0000FF0000FF0000000000000000000000000000000000FF0000000000
FF0000000000
FF0000000000000000FF0000000000000000000000FF0000FF0000000000FF0000000000
FF0000000000FF0000FF0000000000FF0000FF0000000000FF0000000000FF0000FF0000
000000000000FF0000000000000000000000FF0000000000FF0000000000000000000000
FF0000FF0000FF0000000000FF0000FF0000000000000000000000000000FF0000FF0000
FF0000000000
000000000000000000FF0000FF0000000000FF0000000000000000FF0000000000000000
FF0000000000000000FF0000000000000000000000FF0000000000FF0000FF0000000000
000000FF0000FF0000000000000000FF0000000000000000000000000000000000000000
000000FF0000FF0000FF0000FF0000000000FF0000000000000000FF0000FF0000000000
000000000000
FF0000FF0000000000FF0000FF0000000000000000FF0000FF0000FF0000FF0000FF0000
FF0000FF0000FF0000FF0000000000FF0000000000000000000000000000000000FF0000
000000000000000000000000FF0000000000000000000000FF0000FF0000000000FF0000
FF0000000000FF0000000000FF0000FF0000000000FF0000FF0000FF0000000000000000
000000000000
FF0000FF0000000000FF0000FF0000FF0000000000FF0000FF0000000000000000000000
000000000000000000FF0000000000FF0000000000000000000000000000000000FF0000
000000000000000000000000FF0000FF0000FF0000000000FF0000FF0000000000FF0000
000000FF0000FF0000FF0000000000000000FF0000FF0000000000FF0000FF0000FF0000
FF0000000000
FF0000000000000000FF0000000000FF0000000000000000000000000000FF0000FF0000
FF0000000000000000FF0000000000000000000000FF0000000000000000000000FF0000
FF0000000000000000000000000000FF0000FF0000FF0000FF0000000000000000FF0000
000000000000FF0000000000000000FF0000FF0000000000000000000000000000FF0000
000000000000
FF0000FF0000FF0000000000FF0000FF0000000000FF0000FF0000FF0000000000000000
000000000000FF0000FF0000FF0000FF0000000000FF0000000000FF0000000000000000
FF0000FF0000FF0000000000FF0000FF0000FF0000FF0000FF0000FF0000000000FF0000
FF0000FF0000FF0000FF0000FF0000000000000000FF0000FF0000000000FF0000FF0000
000000000000
FF0000000000FF0000000000000000000000000000000000000000000000FF0000FF0000
000000000000FF0000000000000000000000FF0000FF0000000000FF0000000000FF0000
FF0000FF0000000000FF0000000000FF0000FF0000000000000000000000FF0000FF0000
000000000000FF0000000000FF0000FF0000000000FF0000FF0000FF0000000000000000
000000000000
000000000000FF0000FF0000FF0000000000FF0000FF0000FF0000FF0000000000000000
000000FF0000000000000000FF0000FF0000000000000000FF0000FF0000FF0000000000
000000000000000000FF0000FF0000FF0000000000000000000000FF0000FF0000FF0000
000000FF0000FF0000000000FF0000000000000000000000FF0000FF0000FF0000000000
000000000000
FF0000000000FF0000FF0000000000000000000000FF0000FF0000FF0000FF0000FF0000
FF0000FF0000FF0000000000FF0000000000FF0000000000000000FF0000000000000000
FF0000000000000000000000FF0000FF0000000000000000FF0000000000000000FF0000
FF0000000000000000FF0000000000FF0000FF0000000000FF0000FF0000FF0000000000
000000FF0000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00603oool01@3o_g@00000000000000000M;oo03l0oooo00<0okmd0000
000000000`0000001@00M;l0oooo0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool0>03oool0
0`3ookl0M000000000040000000507Boo`3oool0oooo0?ooo`3o_g@00`0000000`1d_ol0oooo0?oo
o`0j0?ooo`050;md00000000000000000018W=l0103oool01@3o_g@00000000000000000M;oo03d0
oooo00D0omnL04P000000000000007Boo`030?ooo`050?noM000000000000000001d_ol0?@3oool0
1@2oM0000000000000000000M;oo00@0oooo00D0okmd000000000000000007Boo`0L0?ooo`00603o
ool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oood40oooo00<0W4Q809cOo`3oool0103oool01P2LB7@0
_ooo0?ooo`3ookl0M01d0;ooocX0oooo00<0_g@00000M02oool00P3oool00`3OW7@0W=oo0?ooo`02
0?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo>P3oool01`2oM00007Bo0?ooo`3oool0oono07@0
0018W=l00`3oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oooch0oooo00<0_g@007Boo`3oool00`3o
ool01P2LB7@0_ooo0?ooo`3ookl0M01d0;oooc/0oooo00L0_g@0001d_`3oool0oooo0?oOW0180000
M;oo00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02ooolK0?ooo`005`3oool00`3o_g@007Bo0?oo
o`020?ooo`030=nLB018W=l0oooo0400oooo00<0W4Q809cOo`3oool00`3oool00`3o_g@007Bo0?oo
o`020?ooo`030=nLB018W=l0oooo03X0oooo00<0okmd0000B02Lgol01@3oool00`3o_g@007Bo0?oo
o`020?ooo`030=nLB018W=l0oooo03h0oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`03
0=nLB018W=l0oooo03d0oooo00<0_g@007Boo`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`03
0=nLB018W=l0oooo03l0oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0
oooo01X0oooo000G0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0@03oool00`2L
B4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0>`3oool00`3o
gi`0B00004RLg`040?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0?@3oool00`3o
gi`0B01809cOo`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0>@3oool00`3O
W4P00000000000030000000507Boo`3oool0oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`0o
0?ooo`060?noM000M;l0oooo0?ooo`3OW4P0B9cO0`3oool00`3o_g@007Bo0?ooo`0J0?ooo`005`3o
ool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo0400oooo00<0W4Q809cOo`3oool00`3o
ool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03d0oooo00<0W4P004RLg`3oool00P3o
ool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03/0oooo00@0gia80000000004P0W=oo
0`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03T0oooo00H0okmd0000M02oool0
oooo0;md001d_ol30?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0?`3oool01P2L
B000M;oo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool06P3oool001L0oooo00<0gia8
04RLg`3oool00P3oool00`3o_g@007Bo0?ooo`100?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia8
04RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0n0?ooo`0609a8M02oool0oooo0?ooo`3OW4P0B9cO
0`3oool00`3o_g@007Bo0?ooo`0m0?ooo`030?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool0
0P3oool00`3o_g@007Bo0?ooo`0j0?ooo`050=nLB000M;l0oooo0;md001d_ol00`3oool00`3OW4P0
B9cO0?ooo`020?ooo`030?noM000M;l0oooo03X0oooo00<0oono07@0000000000P0000001P18W=l0
oooo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool06P3oool001L0oooo00<0okmd04RL
g`3oool00P3oool00`3OW4P0B9cO0?ooo`100?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd04RL
g`3oool00P3oool00`3OW4P0B9cO0?ooo`0i0?ooo`030=nLB01d_ol0oooo0080oooo00H0_g@007Bo
o`3oool0oooo0?noM018W=l30?ooo`030=nLB018W=l0oooo03h0oooo00H0_g@007Boo`3oool0oooo
0?noM018W=l30?ooo`030=nLB018W=l0oooo03/0oooo00@0W4P004RLg`2oM000M;oo0`3oool00`3o
_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo03X0oooo00<0oono07@0M02oool01P3oool00`3o
_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo01X0oooo000H0?ooo`0609a8001d_ol0oooo0?oO
W01807@0_ooo?P3oool01@3OW4P000000018W02LB4P0W=oo00D0oooo00H0W4P007Boo`3oool0omnL
04P0M02ooolj0?ooo`070?noM00007@0_ooo0?ooo`3o_g@0001809cOo`030?ooo`0609a8001d_ol0
oooo0?oOW01807@0_ooo>P3oool01`3o_g@0001809cOo`3oool0omnL04P0B02Lgol00`3oool01P2L
B000M;oo0?ooo`3ogi`0B01d0;oooc`0oooo00@0omnL04P0B018B000M;oo103oool01P2LB000M;oo
0?ooo`3ogi`0B01d0;oooc/0oooo00<0oono07@0M02oool01`3oool01P2LB000M;oo0?ooo`3ogi`0
B01d0;oooa/0oooo000H0?ooo`050?oo_`1d000000000000B02Lgol0@@3oool00`3OW4P0001809cO
o`050?ooo`050?oo_`1d000000000000B02Lgol0?03oool01@3o_g@000000000000004P0W=oo00@0
oooo00D0oono07@000000000001809cOo`0l0?ooo`050?oOW018000000000000001d_ol0103oool0
1@3ookl0M0000000000004P0W=oo03h0oooo00<0okmd0000001d_ol0103oool01@3ookl0M0000000
000004P0W=oo03`0oooo00<0oono07@0000000000P0000000`0007@0_ooo0?ooo`020?ooo`050?oo
_`1d000000000000B02Lgol0703oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool001H0ooooo`000024
000001L0oooo000F0?ooo`050000003oool0oooo0?ooo`000000B@3oool00`000000oooo0?ooo`17
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool05@3oool001H0oooo00D000000?oo
o`3oool0oooo000000190?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool0
0`000000oooo0?ooo`170?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool01@000000oooo0?ooo`3oool0000004T0oooo00<00000
0?ooo`3oool0A`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo04L0oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo0?l0ooooP03oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`3o0?oooh00oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
o`3ooon00?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0?l0ooooP03o
ool00`000000oooo0?ooo`0E0?ooo`000P3oool01@2oM0000000000000000000M;oo00@0oooo00D0
okmd000000000000000007Boo`060?ooo`030000003oool0oooo0?l0ooooP03oool00`000000oooo
0?ooo`030?ooo`050;md0000000000000000001d_ol0103oool01@3o_g@00000000000000000M;oo
00@0oooo00000`3oool0_g@0001d_`020?ooo`030?oOW0180000M;oo00<0oooo00H0W4Qd0;ooo`3o
ool0oono07@0M02oool50?ooo`030000003oool0oooo00D0oooo5P3o0007000000P0o`001`00000G
0?l001d000003`3o0008000000L0o`001`0000080?l002D000001`3o0008000001H0o`005P00000?
0?l000P000001`3o0008000000L0o`005P0000080?l000l000003`3o0007000000L0o`003`000007
0?ooo`030000003oool0oooo0080oooo00L0_g@0001d_`3oool0oooo0?oOW0180000M;oo00<0oooo
00H0W4Qd0;ooo`3oool0oono07@0M02oool30?ooo`001P3oool01P3o_g@007Bo0?ooo`3oool0okmd
001d_`<0oooo00<0gia804RLg`3oool0103oool00`000000oooo0?ooo`050?oooaH0o`001`000008
0?l000L000005`3o000M000000l0o`00200000070?l000L00000203o000U000000L0o`002000000F
0?l001H000003`3o0008000000L0o`00200000070?l001H00000203o000?000000l0o`001`000007
0?l000l000001`3oool00`000000oooo0?ooo`070?ooo`060?noM000M;l0oooo0?ooo`3o_g@007Bo
0`3oool00`3OW4P0B9cO0?ooo`020?ooo`001P3oool01P3o_g@007Bo0?ooo`3oool0gia804RLg`<0
oooo00<0okmd001d_`3oool0103oool4000000@0oooo5P3o0007000000P0o`001`00000G0?l001d0
00003`3o0008000000L0o`001`0000080?l002D000001`3o0008000001H0o`005P00000?0?l000P0
00001`3o0008000000L0o`005P0000080?l000l000003`3o0007000000L0o`003`0000040?ooo`@0
00002@3oool01P3o_g@007Bo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool00P3oool0
00H0oooo00H0W4P007Boo`3oool0oooo0=nLB018W=l30?ooo`030?noM000M;l0oooo00@0oooo00<0
00000?ooo`3oool01@3ooolF0?l000L00000203o0007000001L0o`007@00000?0?l000P000001`3o
0007000000P0o`009@0000070?l000P000005P3o000F000000l0o`00200000070?l000P000001`3o
000F000000P0o`003`00000?0?l000L000001`3o000?000000L0oooo00<000000?ooo`3oool01`3o
ool01P2LB000M;oo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool00P3oool000030?oo
o`3ookl0M00000<0000000H0B9cO0?ooo`3oool0oooo0=nLB018W=l30?ooo`030?noM000M;l0oooo
00@0oooo00<000000?ooo`3oool01@3ooolF0?l000L00000203o0007000001L0o`007@00000?0?l0
00P000001`3o0007000000P0o`009@0000070?l000P000005P3o000F000000l0o`00200000070?l0
00P000001`3o000F000000P0o`003`00000?0?l000L000001`3o000?000000L0oooo00<000000?oo
o`3oool00P3oool00`3ookl0M000000000020000000604RLg`3oool0oooo0?ooo`3OW4P0B9cO0`3o
ool00`3o_g@007Bo0?ooo`020?ooo`0000@0oooo0?oo_`1d07@0_ooo1P3oool00`3o_g@0B9cO0?oo
o`020?ooo`030=nLB018W=l0oooo00@0oooo00<000000?ooo`3oool01@3ooolF0?l000L00000203o
0007000001L0o`007@00000?0?l000P000001`3o0007000000P0o`009@0000070?l000P000005P3o
000F000000l0o`00200000070?l000P000001`3o000F000000P0o`003`00000?0?l000L000001`3o
000?000000L0oooo00<000000?ooo`3oool00P3oool00`3ookl0M01d0;ooo`060?ooo`030?noM018
W=l0oooo0080oooo00<0gia804RLg`3oool00P3oool000040?ooo`3ookl0M01d0;ooo`L0oooo00H0
W4P007Boo`3oool0omnL04P0M02oool50?ooo`030000003oool0oooo00D0oooo5P3o0007000000P0
o`001`00000G0?l001d000003`3o0008000000L0o`001`0000080?l002D000001`3o0008000001H0
o`005P00000?0?l000P000001`3o0008000000L0o`005P0000080?l000l000003`3o0007000000L0
o`003`0000070?ooo`030000003oool0oooo0080oooo00<0oono07@0M02oool01`3oool01P2LB000
M;oo0?ooo`3ogi`0B01d0;ooo`<0oooo00000`3oool0oono07@00003000000030000M02oool0oooo
0080oooo00D0oono07@000000000001809cOo`060?ooo`030000003oool0oooo00D0oooo3`3o0007
000001H0o`003`0000080?l000h000003`3o0008000000L0o`00200000070?l001H000007P3o000?
000000l0o`005P00000?0?l000L000005`3o000d000000L0o`003`00000?0?l000L000001`3oool0
0`000000oooo0?ooo`020?ooo`030?oo_`1d000000000080000000<0001d0;ooo`3oool00P3oool0
1@3ookl0M0000000000004P0W=oo00@0oooo000F0?ooo`030000003oool0oooo00D0oooo3`3o0007
000001H0o`003`0000080?l000h000003`3o0008000000L0o`00200000070?l001H000007P3o000?
000000l0o`005P00000?0?l000L000005`3o000d000000L0o`003`00000?0?l000L000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0o`001`00000F0?l0
00l00000203o000>000000l0o`00200000070?l000P000001`3o000F000001h0o`003`00000?0?l0
01H000003`3o0007000001L0o`00=00000070?l000l000003`3o0007000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l000L000005P3o000?000000P0
o`003P00000?0?l000P000001`3o0008000000L0o`005P00000N0?l000l000003`3o000F000000l0
o`001`00000G0?l003@000001`3o000?000000l0o`001`0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo3`3o0007000001H0o`003`0000080?l000h00000
3`3o0008000000L0o`00200000070?l001H000007P3o000?000000l0o`005P00000?0?l000L00000
5`3o000d000000L0o`003`00000?0?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?ooo`l0o`001`00000F0?l000l00000203o000>000000l0o`002000
00070?l000P000001`3o000F000001h0o`003`00000?0?l001H000003`3o0007000001L0o`00=000
00070?l000l000003`3o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3oool?0?l000L000005P3o000?000000P0o`003P00000?0?l000P000001`3o0008
000000L0o`005P00000N0?l000l000003`3o000F000000l0o`001`00000G0?l003@000001`3o000?
000000l0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo3`3o0007000001H0o`003`0000080?l000h000003`3o0008000000L0o`00200000070?l0
01H000007P3o000?000000l0o`005P00000?0?l000L000005`3o000d000000L0o`003`00000?0?l0
00L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0
o`005P0000080?l000L00000203o0007000002D0o`002000000d0?l000L00000203o0007000001H0
o`00200000070?l001H000005`3o000F000000P0o`001`00000d0?l000l000001`3o00070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o000F000000P0o`00
1`0000080?l000L000009@3o0008000003@0o`001`0000080?l000L000005P3o0008000000L0o`00
5P00000G0?l001H00000203o0007000003@0o`003`0000070?l000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l001H00000203o0007000000P0o`001`00
000U0?l000P00000=03o0007000000P0o`001`00000F0?l000P000001`3o000F000001L0o`005P00
00080?l000L00000=03o000?000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooo`L0o`005P0000080?l000L00000203o0007000002D0o`002000000d
0?l000L00000203o0007000001H0o`00200000070?l001H000005`3o000F000000P0o`001`00000d
0?l000l000001`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo1`3o000F000000P0o`001`0000080?l000L000009@3o0008000003@0o`001`0000080?l0
00L000005P3o0008000000L0o`005P00000G0?l001H00000203o0007000003@0o`003`0000070?l0
00L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l001H0
0000203o0007000000P0o`001`00000U0?l000P00000=03o0007000000P0o`001`00000F0?l000P0
00001`3o000F000001L0o`005P0000080?l000L00000=03o000?000000L0o`001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`005P0000080?l000L00000
203o0007000002D0o`002000000d0?l000L00000203o0007000001H0o`00200000070?l001H00000
5`3o000F000000P0o`001`00000d0?l000l000001`3o00070?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00D0oooo1`3o000?000001H0o`005`0000070?l001H000003`3o
000?000000L0o`00200000070?l001h000001`3o0008000002`0o`00200000070?l000P000001`3o
0008000000l0o`001`00000U0?l001H00000203o0007000000L0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01@3oool70?l000l000005P3o000G000000L0o`005P00000?
0?l000l000001`3o0008000000L0o`007P0000070?l000P00000;03o0008000000L0o`0020000007
0?l000P000003`3o0007000002D0o`005P0000080?l000L000001`3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`003`00000F0?l001L000001`3o000F0000
00l0o`003`0000070?l000P000001`3o000N000000L0o`002000000/0?l000P000001`3o00080000
00L0o`002000000?0?l000L000009@3o000F000000P0o`001`0000070?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o000?000001H0o`005`0000070?l001H0
00003`3o000?000000L0o`00200000070?l001h000001`3o0008000002`0o`00200000070?l000P0
00001`3o0008000000l0o`001`00000U0?l001H00000203o0007000000L0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000l000005P3o000G000000L0o`00
5P00000?0?l000l000001`3o0008000000L0o`007P0000070?l000P00000;03o0008000000L0o`00
200000070?l000P000003`3o0007000002D0o`005P0000080?l000L000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`003`00000F0?l001L000001`3o
000F000000l0o`003`0000070?l000P000001`3o000N000000L0o`002000000/0?l000P000001`3o
0008000000L0o`002000000?0?l000L000009@3o000F000000P0o`001`0000070?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o000?000001H0o`005`000007
0?l001H000003`3o000?000000L0o`00200000070?l001h000001`3o0008000002`0o`0020000007
0?l000P000001`3o0008000000l0o`001`00000U0?l001H00000203o0007000000L0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolF000000L0o`00200000070?l0
00P000001`3o000F000000l0o`00200000070?l000P000005P3o0007000000l0o`002000000>0?l0
01L000005P3o000?000000L0o`003`0000080?l000L000005P3o000]000000l0o`001`0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo5P0000070?l000P0
00001`3o0008000000L0o`005P00000?0?l000P000001`3o0008000001H0o`001`00000?0?l000P0
00003P3o000G000001H0o`003`0000070?l000l00000203o0007000001H0o`00;@00000?0?l000L0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooaH00000
1`3o0008000000L0o`00200000070?l001H000003`3o0008000000L0o`002000000F0?l000L00000
3`3o0008000000h0o`005`00000F0?l000l000001`3o000?000000P0o`001`00000F0?l002d00000
3`3o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oolF000000L0o`00200000070?l000P000001`3o000F000000l0o`00200000070?l000P000005P3o
0007000000l0o`002000000>0?l001L000005P3o000?000000L0o`003`0000080?l000L000005P3o
000]000000l0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00D0oooo5P0000070?l000P000001`3o0008000000L0o`005P00000?0?l000P000001`3o0008
000001H0o`001`00000?0?l000P000003P3o000G000001H0o`003`0000070?l000l00000203o0007
000001H0o`00;@00000?0?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?oooaH000001`3o0008000000L0o`00200000070?l001H000003`3o00080000
00L0o`002000000F0?l000L000003`3o0008000000h0o`005`00000F0?l000l000001`3o000?0000
00P0o`001`00000F0?l002d000003`3o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01@3ooolF000000L0o`00200000070?l000P000001`3o000F000000l0
o`00200000070?l000P000005P3o0007000000l0o`002000000>0?l001L000005P3o000?000000L0
o`003`0000080?l000L000005P3o000]000000l0o`001`0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo5P0000070?l000P000001`3o0008000000L0o`00
5P00000?0?l000P000001`3o0008000001H0o`001`00000?0?l000P000003P3o000G000001H0o`00
3`0000070?l000l00000203o0007000001H0o`00;@00000?0?l000L000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l001H00000203o
0007000000P0o`001`00000?0?l002D000001`3o0008000000L0o`005`0000070?l000L000007P3o
0008000000h0o`007P0000080?l001d000003`3o0008000002`0o`001`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l001H00000203o0007
000000P0o`001`00000?0?l002D000001`3o0008000000L0o`005`0000070?l000L000007P3o0008
000000h0o`007P0000080?l001d000003`3o0008000002`0o`001`3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l001H00000203o00070000
00P0o`001`00000?0?l002D000001`3o0008000000L0o`005`0000070?l000L000007P3o00080000
00h0o`007P0000080?l001d000003`3o0008000002`0o`001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l001H00000203o0007000000P0
o`001`00000?0?l002D000001`3o0008000000L0o`005`0000070?l000L000007P3o0008000000h0
o`007P0000080?l001d000003`3o0008000002`0o`001`3oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l001H00000203o0007000000P0o`00
1`00000?0?l002D000001`3o0008000000L0o`005`0000070?l000L000007P3o0008000000h0o`00
7P0000080?l001d000003`3o0008000002`0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l001H00000203o0007000000P0o`001`00
000?0?l002D000001`3o0008000000L0o`005`0000070?l000L000007P3o0008000000h0o`007P00
00080?l001d000003`3o0008000002`0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooo`L0o`00200000070?l001H00000203o0007000000P0o`001`00000?
0?l002D000001`3o0008000000L0o`005`0000070?l000L000007P3o0008000000h0o`007P000008
0?l001d000003`3o0008000002`0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooo`L0o`00200000070?l000l000005P3o000?000001h0o`005P00000F0?l0
01h000001`3o0008000000l0o`003`0000070?l003@00000203o000>000000P0o`001`00000G0?l0
00L000005P3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo1`3o0008000000L0o`003`00000F0?l000l000007P3o000F000001H0o`007P0000070?l000P0
00003`3o000?000000L0o`00=00000080?l000h00000203o0007000001L0o`001`00000F0?l000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P00000
1`3o000?000001H0o`003`00000N0?l001H000005P3o000N000000L0o`002000000?0?l000l00000
1`3o000d000000P0o`003P0000080?l000L000005`3o0007000001H0o`001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l000l000005P3o
000?000001h0o`005P00000F0?l001h000001`3o0008000000l0o`003`0000070?l003@00000203o
000>000000P0o`001`00000G0?l000L000005P3o00070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo1`3o0008000000L0o`003`00000F0?l000l000007P3o000F
000001H0o`007P0000070?l000P000003`3o000?000000L0o`00=00000080?l000h00000203o0007
000001L0o`001`00000F0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3oool70?l000P000001`3o000?000001H0o`003`00000N0?l001H000005P3o000N0000
00L0o`002000000?0?l000l000001`3o000d000000P0o`003P0000080?l000L000005`3o00070000
01H0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0
o`00200000070?l000l000005P3o000?000001h0o`005P00000F0?l001h000001`3o0008000000l0
o`003`0000070?l003@00000203o000>000000P0o`001`00000G0?l000L000005P3o00070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo=00000070?l000P00000
1`3o0007000001h0o`007P00000?0?l000L000009@3o000?000001H0o`005`0000070?l000P00000
@`3o000F000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`050?oooc@000001`3o0008000000L0o`001`00000N0?l001h000003`3o0007000002D0o`003`00
000F0?l001L000001`3o0008000004<0o`005P0000070?l000L0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01@3ooold000000L0o`00200000070?l000L000007P3o000N
000000l0o`001`00000U0?l000l000005P3o000G000000L0o`00200000130?l001H000001`3o0007
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo=00000070?l0
00P000001`3o0007000001h0o`007P00000?0?l000L000009@3o000?000001H0o`005`0000070?l0
00P00000@`3o000F000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`050?oooc@000001`3o0008000000L0o`001`00000N0?l001h000003`3o0007000002D0
o`003`00000F0?l001L000001`3o0008000004<0o`005P0000070?l000L0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01@3ooold000000L0o`00200000070?l000L00000
7P3o000N000000l0o`001`00000U0?l000l000005P3o000G000000L0o`00200000130?l001H00000
1`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo=000
00070?l000P000001`3o0007000001h0o`007P00000?0?l000L000009@3o000?000001H0o`005`00
00070?l000P00000@`3o000F000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?oooc@000001`3o0008000000L0o`001`00000N0?l001h000003`3o0007
000002D0o`003`00000F0?l001L000001`3o0008000004<0o`005P0000070?l000L0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool7000000l0o`003`0000070?l0
00P000003`3o000F000001H0o`003`00000?0?l000L00000203o000F000002D0o`00200000070?l0
00l000003`3o0007000000l0o`007P0000070?l000l000003`3o0007000000P0o`001`0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`00000?0?l000l0
00001`3o0008000000l0o`005P00000F0?l000l000003`3o0007000000P0o`005P00000U0?l000P0
00001`3o000?000000l0o`001`00000?0?l001h000001`3o000?000000l0o`001`0000080?l000L0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L00000
3`3o000?000000L0o`002000000?0?l001H000005P3o000?000000l0o`001`0000080?l001H00000
9@3o0008000000L0o`003`00000?0?l000L000003`3o000N000000L0o`003`00000?0?l000L00000
203o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
ool7000000l0o`003`0000070?l000P000003`3o000F000001H0o`003`00000?0?l000L00000203o
000F000002D0o`00200000070?l000l000003`3o0007000000l0o`007P0000070?l000l000003`3o
0007000000P0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00D0oooo1`00000?0?l000l000001`3o0008000000l0o`005P00000F0?l000l000003`3o0007
000000P0o`005P00000U0?l000P000001`3o000?000000l0o`001`00000?0?l001h000001`3o000?
000000l0o`001`0000080?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooo`L000003`3o000?000000L0o`002000000?0?l001H000005P3o000?0000
00l0o`001`0000080?l001H000009@3o0008000000L0o`003`00000?0?l000L000003`3o000N0000
00L0o`003`00000?0?l000L00000203o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01@3oool7000000l0o`003`0000070?l000P000003`3o000F000001H0
o`003`00000?0?l000L00000203o000F000002D0o`00200000070?l000l000003`3o0007000000l0
o`007P0000070?l000l000003`3o0007000000P0o`001`0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo1`00000F0?l000l00000203o0007000000P0o`00
1`0000070?l000P000001`3o0008000001d0o`007P0000080?l000L000001`3o0008000000L0o`00
2000000U0?l000l000003`3o0007000002D0o`003`0000080?l000L000001`3o0008000000L0o`00
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L000005P3o
000?000000P0o`001`0000080?l000L000001`3o0008000000L0o`002000000M0?l001h00000203o
0007000000L0o`00200000070?l000P000009@3o000?000000l0o`001`00000U0?l000l00000203o
0007000000L0o`00200000070?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3oool7000001H0o`003`0000080?l000L00000203o0007000000L0o`0020000007
0?l000P000007@3o000N000000P0o`001`0000070?l000P000001`3o0008000002D0o`003`00000?
0?l000L000009@3o000?000000P0o`001`0000070?l000P000001`3o00070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`00000F0?l000l00000203o00070000
00P0o`001`0000070?l000P000001`3o0008000001d0o`007P0000080?l000L000001`3o00080000
00L0o`002000000U0?l000l000003`3o0007000002D0o`003`0000080?l000L000001`3o00080000
00L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0
00005P3o000?000000P0o`001`0000080?l000L000001`3o0008000000L0o`002000000M0?l001h0
0000203o0007000000L0o`00200000070?l000P000009@3o000?000000l0o`001`00000U0?l000l0
0000203o0007000000L0o`00200000070?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3oool7000001H0o`003`0000080?l000L00000203o0007000000L0o`00
200000070?l000P000007@3o000N000000P0o`001`0000070?l000P000001`3o0008000002D0o`00
3`00000?0?l000L000009@3o000?000000P0o`001`0000070?l000P000001`3o00070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`00000F0?l000l00000203o
0007000000P0o`001`0000070?l000P000001`3o0008000001d0o`007P0000080?l000L000001`3o
0008000000L0o`002000000U0?l000l000003`3o0007000002D0o`003`0000080?l000L000001`3o
0008000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`000`3oool01@3ogi`0B00000000000
0000M;oo00<0oooo00D0okmd000000000000000007Boo`060?ooo`030000003oool0oooo00D0oooo
1`00000F0?l000l00000203o0007000000P0o`001`0000070?l000P000001`3o0008000001d0o`00
7P0000080?l000L000001`3o0008000000L0o`002000000U0?l000l000003`3o0007000002D0o`00
3`0000080?l000L000001`3o0008000000L0o`001`3oool00`000000oooo0?ooo`040?ooo`050?oO
W018000000000000001d_ol00`3oool01@3o_g@00000000000000000M;oo00@0oooo00050?ooo`03
0;md001d_ol0oooo00<0oooo00H0W4Qd0;ooo`3oool0oono07@0M02oool50?ooo`030000003oool0
oooo00D0oooo1`3o0008000000L0o`003`00000F0?l000P000007@3o000?000001H0o`002000000F
0?l000P000005P3o0007000000l0o`009@00000?0?l000l00000203o000M000000P0o`001`00000?
0?l000l000001`3o00070?ooo`030000003oool0oooo00H0oooo00<0_g@007Boo`3oool00`3oool0
1P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`<0oooo00050?ooo`030;md001d_ol0oooo0080oooo00<0
okmd001d_`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0oooo00D0oooo1`3o
0008000000L0o`003`00000F0?l000P000007@3o000?000001H0o`002000000F0?l000P000005P3o
0007000000l0o`009@00000?0?l000l00000203o000M000000P0o`001`00000?0?l000l000001`3o
00070?ooo`030000003oool0oooo00H0oooo00<0_g@007Boo`3oool00P3oool00`3o_g@007Bo0?oo
o`020?ooo`030=nLB018W=l0oooo0080oooo00000`3oool0gia8000000040000000507Boo`3oool0
oooo0=nLB018W=l00`3oool00`3o_g@007Bo0?ooo`040?ooo`030000003oool0oooo00D0oooo1`3o
0008000000L0o`003`00000F0?l000P000007@3o000?000001H0o`002000000F0?l000P000005P3o
0007000000l0o`009@00000?0?l000l00000203o000M000000P0o`001`00000?0?l000l000001`3o
00070?ooo`030000003oool0oooo0080oooo00<0gia80000000000000`0000001@1d_ol0oooo0?oo
o`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool00P3oool000070?ooo`3o_g@0001d0;ooo`3oool0
_g@007Boo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool4000000@0
oooo1`3o0008000000L0o`003`00000F0?l000P000007@3o000?000001H0o`002000000F0?l000P0
00005P3o0007000000l0o`009@00000?0?l000l00000203o000M000000P0o`001`00000?0?l000l0
00001`3o00040?ooo`@00000103oool01P3o_g@0001d0;ooo`3oool0_g@007Boo`<0oooo00<0gia8
04RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`000P3oool01@3OW4P007Bo0?ooo`2oM000
M;oo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`040?ooo`030000003oool0
oooo00D0oooo1`3o0008000000L0o`003`00000F0?l000P000007@3o000?000001H0o`002000000F
0?l000P000005P3o0007000000l0o`009@00000?0?l000l00000203o000M000000P0o`001`00000?
0?l000l000001`3o00070?ooo`030000003oool0oooo00<0oooo00D0gia8001d_`3oool0_g@007Bo
o`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool00P3oool000<0oooo00@0W4P0
04RLg`2oM000M;oo0`3oool00`3o_g@0B9cO0?ooo`020?ooo`030=nLB018W=l0oooo00@0oooo00<0
00000?ooo`3oool01@3oool70?l000P000001`3o000?000001H0o`002000000M0?l000l000005P3o
0008000001H0o`002000000F0?l000L000003`3o000U000000l0o`003`0000080?l001d00000203o
0007000000l0o`003`0000070?l000L0oooo00<000000?ooo`3oool0103oool0102LB000B9cO0;md
001d_ol30?ooo`030?noM018W=l0oooo0080oooo00<0gia804RLg`3oool00P3oool000<0oooo00@0
omnL04P0B018B000M;oo103oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`D0oooo00<000000?oo
o`3oool01@3oool70?l000P000001`3o000?000001H0o`002000000M0?l000l000005P3o00080000
01H0o`002000000F0?l000L000003`3o000U000000l0o`003`0000080?l001d00000203o00070000
00l0o`003`0000070?l000L0oooo00<000000?ooo`3oool0103oool0103ogi`0B01804Q8001d_ol4
0?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo0`3oool000@0oooo00<0okmd0000001d_ol0103o
ool01@3ookl0M0000000000004P0W=oo00H0oooo00<000000?ooo`3oool01@3oool70?l000P00000
7@3o000G000000h0o`002000000N0?l000L000003`3o0007000001L0o`001`0000070?l000l00000
3`3o000?000000l0o`003`00000?0?l001H000001`3o000?000000l0o`003`0000070?l000l00000
1`3oool00`000000oooo0?ooo`050?ooo`030?noM0000000M;oo00@0oooo00D0oono07@000000000
001809cOo`040?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`002000000M0?l001L00000
3P3o0008000001h0o`001`00000?0?l000L000005`3o0007000000L0o`003`00000?0?l000l00000
3`3o000?000000l0o`005P0000070?l000l000003`3o000?000000L0o`003`0000070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0o`005`00
000>0?l000P000007P3o0007000000l0o`001`00000G0?l000L000001`3o000?000000l0o`003`00
000?0?l000l000003`3o000F000000L0o`003`00000?0?l000l000001`3o000?000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000007@3o000G
000000h0o`002000000N0?l000L000003`3o0007000001L0o`001`0000070?l000l000003`3o000?
000000l0o`003`00000?0?l001H000001`3o000?000000l0o`003`0000070?l000l000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`002000000M0?l0
01L000003P3o0008000001h0o`001`00000?0?l000L000005`3o0007000000L0o`003`00000?0?l0
00l000003`3o000?000000l0o`005P0000070?l000l000003`3o000?000000L0o`003`0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0
o`005`00000>0?l000P000007P3o0007000000l0o`001`00000G0?l000L000001`3o000?000000l0
o`003`00000?0?l000l000003`3o000F000000L0o`003`00000?0?l000l000001`3o000?000000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P00000
7@3o000G000000h0o`002000000N0?l000L000003`3o0007000001L0o`001`0000070?l000l00000
3`3o000?000000l0o`003`00000?0?l001H000001`3o000?000000l0o`003`0000070?l000l00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`002000
000>0?l001L000005P3o000?000001h0o`001`00000N0?l000L00000203o000F000001H0o`002000
00070?l001H00000203o0007000002d0o`001`0000080?l000l000003P3o000?000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000003P3o000G
000001H0o`003`00000N0?l000L000007P3o0007000000P0o`005P00000F0?l000P000001`3o000F
000000P0o`001`00000]0?l000L00000203o000?000000h0o`003`0000070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000000h0o`005`00000F0?l0
00l000007P3o0007000001h0o`001`0000080?l001H000005P3o0008000000L0o`005P0000080?l0
00L00000;@3o0007000000P0o`003`00000>0?l000l000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooo`L0o`002000000>0?l001L000005P3o000?000001h0
o`001`00000N0?l000L00000203o000F000001H0o`00200000070?l001H00000203o0007000002d0
o`001`0000080?l000l000003P3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3oool70?l000P000003P3o000G000001H0o`003`00000N0?l000L00000
7P3o0007000000P0o`005P00000F0?l000P000001`3o000F000000P0o`001`00000]0?l000L00000
203o000?000000h0o`003`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo1`3o0008000000h0o`005`00000F0?l000l000007P3o0007000001h0o`001`00
00080?l001H000005P3o0008000000L0o`005P0000080?l000L00000;@3o0007000000P0o`003`00
000>0?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooo`L0o`002000000>0?l001L000005P3o000?000001h0o`001`00000N0?l000L00000203o000F
000001H0o`00200000070?l001H00000203o0007000002d0o`001`0000080?l000l000003P3o000?
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l0
00P000003P3o000G000001H0o`003`00000N0?l000L000007P3o0007000000P0o`005P00000F0?l0
00P000001`3o000F000000P0o`001`00000]0?l000L00000203o000?000000h0o`003`0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001H0
o`001`0000080?l000L00000203o000>000000P0o`001`00000G0?l000h00000FP3o0007000001H0
o`003`00000?0?l000P000003P3o0008000000L0o`003`0000080?l000h000003`3o00070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001H0o`00
1`0000080?l000L00000203o000>000000P0o`001`00000G0?l000h00000FP3o0007000001H0o`00
3`00000?0?l000P000003P3o0008000000L0o`003`0000080?l000h000003`3o00070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001H0o`001`00
00080?l000L00000203o000>000000P0o`001`00000G0?l000h00000FP3o0007000001H0o`003`00
000?0?l000P000003P3o0008000000L0o`003`0000080?l000h000003`3o00070?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001H0o`001`000008
0?l000L00000203o000>000000P0o`001`00000G0?l000h00000FP3o0007000001H0o`003`00000?
0?l000P000003P3o0008000000L0o`003`0000080?l000h000003`3o00070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001H0o`001`0000080?l0
00L00000203o000>000000P0o`001`00000G0?l000h00000FP3o0007000001H0o`003`00000?0?l0
00P000003P3o0008000000L0o`003`0000080?l000h000003`3o00070?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001H0o`001`0000080?l000L0
0000203o000>000000P0o`001`00000G0?l000h00000FP3o0007000001H0o`003`00000?0?l000P0
00003P3o0008000000L0o`003`0000080?l000h000003`3o00070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001H0o`001`0000080?l000L00000
203o000>000000P0o`001`00000G0?l000h00000FP3o0007000001H0o`003`00000?0?l000P00000
3P3o0008000000L0o`003`0000080?l000h000003`3o00070?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o
000?000000P0o`003P0000080?l001H000005P3o0008000001h0o`001`00000?0?l001H000005`3o
000>000000P0o`001`00000N0?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o000?
000000P0o`003P0000080?l001H000005P3o0008000001h0o`001`00000?0?l001H000005`3o000>
000000P0o`001`00000N0?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o000?0000
00P0o`003P0000080?l001H000005P3o0008000001h0o`001`00000?0?l001H000005`3o000>0000
00P0o`001`00000N0?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o000?000000P0
o`003P0000080?l001H000005P3o0008000001h0o`001`00000?0?l001H000005`3o000>000000P0
o`001`00000N0?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o000?000000P0o`00
3P0000080?l001H000005P3o0008000001h0o`001`00000?0?l001H000005`3o000>000000P0o`00
1`00000N0?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o000?000000P0o`003P00
00080?l001H000005P3o0008000001h0o`001`00000?0?l001H000005`3o000>000000P0o`001`00
000N0?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o000?000000P0o`003P000008
0?l001H000005P3o0008000001h0o`001`00000?0?l001H000005`3o000>000000P0o`001`00000N
0?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo1`3o0008000000h0o`003`00000N0?l000L000003`3o000?000000P0o`003P0000080?l0
01H000005P3o0008000001h0o`001`00000?0?l001H000005`3o000>000000P0o`001`00000N0?l0
00L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo3`00000U0?l000l00000=03o000>000002H0o`007@00000G0?l000L000005P3o000?000001L0
o`001`0000070?l001L000009@3o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3oool?000002D0o`003`00000d0?l000h000009P3o000M000001L0o`00
1`00000F0?l000l000005`3o0007000000L0o`005`00000U0?l000L000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l000009@3o000?000003@0o`003P00
000V0?l001d000005`3o0007000001H0o`003`00000G0?l000L000001`3o000G000002D0o`001`00
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`00000U
0?l000l00000=03o000>000002H0o`007@00000G0?l000L000005P3o000?000001L0o`001`000007
0?l001L000009@3o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3oool?000002D0o`003`00000d0?l000h000009P3o000M000001L0o`001`00000F0?l0
00l000005`3o0007000000L0o`005`00000U0?l000L000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?ooo`l000009@3o000?000003@0o`003P00000V0?l001d0
00005`3o0007000001H0o`003`00000G0?l000L000001`3o000G000002D0o`001`0000070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`00000U0?l000l00000
=03o000>000002H0o`007@00000G0?l000L000005P3o000?000001L0o`001`0000070?l001L00000
9@3o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oolF000000L0o`005`00000F0?l000L000007P3o000N000000L0o`00?000000M0?l000l00000203o
0007000000P0o`001`00000F0?l001L000001`3o0008000000L0o`003`0000070?l000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolF000000L0o`005`00000F
0?l000L000007P3o000N000000L0o`00?000000M0?l000l00000203o0007000000P0o`001`00000F
0?l001L000001`3o0008000000L0o`003`0000070?l000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3ooolF000000L0o`005`00000F0?l000L000007P3o000N0000
00L0o`00?000000M0?l000l00000203o0007000000P0o`001`00000F0?l001L000001`3o00080000
00L0o`003`0000070?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolF000000L0o`005`00000F0?l000L000007P3o000N000000L0o`00?000000M0?l000l0
0000203o0007000000P0o`001`00000F0?l001L000001`3o0008000000L0o`003`0000070?l000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolF000000L0o`00
5`00000F0?l000L000007P3o000N000000L0o`00?000000M0?l000l00000203o0007000000P0o`00
1`00000F0?l001L000001`3o0008000000L0o`003`0000070?l000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolF000000L0o`005`00000F0?l000L000007P3o
000N000000L0o`00?000000M0?l000l00000203o0007000000P0o`001`00000F0?l001L000001`3o
0008000000L0o`003`0000070?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooolF000000L0o`005`00000F0?l000L000007P3o000N000000L0o`00?000000M
0?l000l00000203o0007000000P0o`001`00000F0?l001L000001`3o0008000000L0o`003`000007
0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l0
00P000001`3o0007000001L0o`003`00000>0?l000P000001`3o0008000001H0o`003`00000?0?l0
00L000007P3o000?000000L0o`007P0000070?l000P000005P3o0008000000L0o`001`00000G0?l0
00L000005P3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3oool70?l000P000001`3o0007000001L0o`003`00000>0?l000P000001`3o0008000001H0
o`003`00000?0?l000L000007P3o000?000000L0o`007P0000070?l000P000005P3o0008000000L0
o`001`00000G0?l000L000005P3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3oool70?l000P000001`3o0007000001L0o`003`00000>0?l000P00000
1`3o0008000001H0o`003`00000?0?l000L000007P3o000?000000L0o`007P0000070?l000P00000
5P3o0008000000L0o`001`00000G0?l000L000005P3o000?000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000001`3o0007000001L0o`003`00
000>0?l000P000001`3o0008000001H0o`003`00000?0?l000L000007P3o000?000000L0o`007P00
00070?l000P000005P3o0008000000L0o`001`00000G0?l000L000005P3o000?000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000001`3o0007
000001L0o`003`00000>0?l000P000001`3o0008000001H0o`003`00000?0?l000L000007P3o000?
000000L0o`007P0000070?l000P000005P3o0008000000L0o`001`00000G0?l000L000005P3o000?
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l0
00P000001`3o0007000001L0o`003`00000>0?l000P000001`3o0008000001H0o`003`00000?0?l0
00L000007P3o000?000000L0o`007P0000070?l000P000005P3o0008000000L0o`001`00000G0?l0
00L000005P3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3oool70?l000P000001`3o0007000001L0o`003`00000>0?l000P000001`3o0008000001H0
o`003`00000?0?l000L000007P3o000?000000L0o`007P0000070?l000P000005P3o0008000000L0
o`001`00000G0?l000L000005P3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3oool70?l000P000001`3o0007000001L0o`003`00000>0?l000P00000
1`3o0008000001H0o`003`00000?0?l000L000007P3o000?000000L0o`007P0000070?l000P00000
5P3o0008000000L0o`001`00000G0?l000L000005P3o000?000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l000L000001`3o0008000000L0o`007P00
00070?l000P000001`3o000?000001H0o`002000000N0?l001H000003`3o0007000001h0o`001`00
00080?l001h000003P3o000?000000P0o`001`00000?0?l000L00000203o0007000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l000L000001`3o0008
000000L0o`007P0000070?l000P000001`3o000?000001H0o`002000000N0?l001H000003`3o0007
000001h0o`001`0000080?l001h000003P3o000?000000P0o`001`00000?0?l000L00000203o0007
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l0
00L000001`3o0008000000L0o`007P0000070?l000P000001`3o000?000001H0o`002000000N0?l0
01H000003`3o0007000001h0o`001`0000080?l001h000003P3o000?000000P0o`001`00000?0?l0
00L00000203o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3oool?0?l000L000001`3o0008000000L0o`007P0000070?l000P000001`3o000?000001H0
o`002000000N0?l001H000003`3o0007000001h0o`001`0000080?l001h000003P3o000?000000P0
o`001`00000?0?l000L00000203o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3oool?0?l000L000001`3o0008000000L0o`007P0000070?l000P00000
1`3o000?000001H0o`002000000N0?l001H000003`3o0007000001h0o`001`0000080?l001h00000
3P3o000?000000P0o`001`00000?0?l000L00000203o0007000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l000L000001`3o0008000000L0o`007P00
00070?l000P000001`3o000?000001H0o`002000000N0?l001H000003`3o0007000001h0o`001`00
00080?l001h000003P3o000?000000P0o`001`00000?0?l000L00000203o0007000000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l000L000001`3o0008
000000L0o`007P0000070?l000P000001`3o000?000001H0o`002000000N0?l001H000003`3o0007
000001h0o`001`0000080?l001h000003P3o000?000000P0o`001`00000?0?l000L00000203o0007
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0000
00L0o`001`00000?0?l000P00000;03o0008000002D0o`001`00000?0?l001h000001`3o00080000
01d0o`002000000N0?l001H000001`3o0008000000l0o`001`0000080?l001H000001`3o00070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`0000070?l000L0
00003`3o0008000002`0o`002000000U0?l000L000003`3o000N000000L0o`002000000M0?l000P0
00007P3o000F000000L0o`002000000?0?l000L00000203o000F000000L0o`001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l000001`3o0007000000l0o`00
2000000/0?l000P000009@3o0007000000l0o`007P0000070?l000P000007@3o0008000001h0o`00
5P0000070?l000P000003`3o0007000000P0o`005P0000070?l000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3oool?000000L0o`001`00000?0?l000P00000;03o
0008000002D0o`001`00000?0?l001h000001`3o0008000001d0o`002000000N0?l001H000001`3o
0008000000l0o`001`0000080?l001H000001`3o00070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo3`0000070?l000L000003`3o0008000002`0o`002000000U
0?l000L000003`3o000N000000L0o`002000000M0?l000P000007P3o000F000000L0o`002000000?
0?l000L00000203o000F000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooo`l000001`3o0007000000l0o`002000000/0?l000P000009@3o00070000
00l0o`007P0000070?l000P000007@3o0008000001h0o`005P0000070?l000P000003`3o00070000
00P0o`005P0000070?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3oool?000000L0o`001`00000?0?l000P00000;03o0008000002D0o`001`00000?0?l001h0
00001`3o0008000001d0o`002000000N0?l001H000001`3o0008000000l0o`001`0000080?l001H0
00001`3o00070?ooo`030000003oool0oooo01D0oooo00020?ooo`050;md00000000000000000018
W=l0103oool01@3o_g@00000000000000000M;oo00H0oooo00<000000?ooo`3oool01@3oool?0000
00L0o`001`00000?0?l000P00000;03o0008000002D0o`001`00000?0?l001h000001`3o00080000
01d0o`002000000N0?l001H000001`3o0008000000l0o`001`0000080?l001H000001`3o00070?oo
o`030000003oool0oooo00<0oooo00D0_g@0000000000000000004RLg`040?ooo`050?noM0000000
00000000001d_ol0103oool000030?ooo`2oM00007Bo0080oooo00<0oono07@00018W=l00`3oool0
1P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`D0oooo00<000000?ooo`3oool01@3oool7000001H0o`00
5`00000F0?l000L000003`3o0008000000L0o`007P00000F0?l001H00000203o0007000001h0o`00
7P0000070?l000P000005P3o000?000000L0o`00200000070?l000P000005P3o0007000000L0oooo
00<000000?ooo`3oool00P3oool01`2oM00007Bo0?ooo`3oool0oono07@00018W=l00`3oool01P2L
B7@0_ooo0?ooo`3ookl0M01d0;ooo`<0oooo00060?ooo`060?noM000M;l0oooo0?ooo`3o_g@007Bo
0`3oool00`3OW4P0B9cO0?ooo`040?ooo`030000003oool0oooo00D0oooo1`00000F0?l001L00000
5P3o0007000000l0o`00200000070?l001h000005P3o000F000000P0o`001`00000N0?l001h00000
1`3o0008000001H0o`003`0000070?l000P000001`3o0008000001H0o`001`0000070?ooo`030000
003oool0oooo00L0oooo00H0okmd001d_`3oool0oooo0?noM000M;l30?ooo`030=nLB018W=l0oooo
0080oooo00050?ooo`030?oOW01804P0W=oo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@0
07Bo0?ooo`040?ooo`030000003oool0oooo00D0oooo1`00000F0?l001L000005P3o0007000000l0
o`00200000070?l001h000005P3o000F000000P0o`001`00000N0?l001h000001`3o0008000001H0
o`003`0000070?l000P000001`3o0008000001H0o`001`0000070?ooo`030000003oool0oooo00H0
oooo00<0omnL04P0B02Lgol00P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo0080
oooo00030?ooo`040=nLB0000000001809cOo`<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@0
07Bo0?ooo`040?ooo`@00000103oool7000001H0o`005`00000F0?l000L000003`3o0008000000L0
o`007P00000F0?l001H00000203o0007000001h0o`007P0000070?l000P000005P3o000?000000L0
o`00200000070?l000P000005P3o0007000000@0oooo100000060?ooo`040=nLB0000000001809cO
o`<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`001@3oool00`3ogi`0
B01809cOo`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool00`000000
oooo0?ooo`050?ooo`L000005P3o000G000001H0o`001`00000?0?l000P000001`3o000N000001H0
o`005P0000080?l000L000007P3o000N000000L0o`002000000F0?l000l000001`3o0008000000L0
o`002000000F0?l000L000001`3oool00`000000oooo0?ooo`060?ooo`030?oOW01804P0W=oo0080
oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`001P3oool01P2oM000M;oo
0?ooo`3oool0okmd04RLg`<0oooo00<0gia804RLg`3oool0103oool00`000000oooo0?ooo`050?oo
o`L000005P3o000G000001H0o`001`00000?0?l000P000001`3o000N000001H0o`005P0000080?l0
00L000007P3o000N000000L0o`002000000F0?l000l000001`3o0008000000L0o`002000000F0?l0
00L000001`3oool00`000000oooo0?ooo`070?ooo`060;md001d_ol0oooo0?ooo`3o_g@0B9cO0`3o
ool00`3OW4P0B9cO0?ooo`020?ooo`0000P0oooo0?noM00004P0W=oo0?ooo`3ogi`0B01809cOo`<0
oooo00H0W4P007Boo`3oool0omnL04P0M02oool50?ooo`030000003oool0oooo00D0oooo1`00000F
0?l001L000005P3o0007000000l0o`00200000070?l001h000005P3o000F000000P0o`001`00000N
0?l001h000001`3o0008000001H0o`003`0000070?l000P000001`3o0008000001H0o`001`000007
0?ooo`030000003oool0oooo0080oooo00L0okmd0000B02Lgol0oooo0?oOW01804P0W=oo00<0oooo
00H0W4P007Boo`3oool0omnL04P0M02oool30?ooo`000P3oool01@3ogi`0B000000000000000M;oo
00@0oooo00D0oono07@000000000001809cOo`060?ooo`030000003oool0oooo00D0oooo3`00000>
0?l005X000001`3o0007000000l0o`002000000M0?l000P000001`3o0008000000L0o`0020000007
0?l000l000001`3o0008000000L0o`002000000/0?l000P000001`3o0008000000h0o`0020000007
0?l000L0oooo00<000000?ooo`3oool00`3oool01@3ogi`0B000000000000000M;oo00@0oooo00D0
oono07@000000000001809cOo`040?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l000003P3o
001J000000L0o`001`00000?0?l000P000007@3o0008000000L0o`00200000070?l000P000001`3o
000?000000L0o`00200000070?l000P00000;03o0008000000L0o`002000000>0?l000P000001`3o
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`00000>
0?l005X000001`3o0007000000l0o`002000000M0?l000P000001`3o0008000000L0o`0020000007
0?l000l000001`3o0008000000L0o`002000000/0?l000P000001`3o0008000000h0o`0020000007
0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0000
00h0o`00FP0000070?l000L000003`3o0008000001d0o`00200000070?l000P000001`3o00080000
00L0o`003`0000070?l000P000001`3o0008000002`0o`00200000070?l000P000003P3o00080000
00L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0
00003P3o001J000000L0o`001`00000?0?l000P000007@3o0008000000L0o`00200000070?l000P0
00001`3o000?000000L0o`00200000070?l000P00000;03o0008000000L0o`002000000>0?l000P0
00001`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
3`00000>0?l005X000001`3o0007000000l0o`002000000M0?l000P000001`3o0008000000L0o`00
200000070?l000l000001`3o0008000000L0o`002000000/0?l000P000001`3o0008000000h0o`00
200000070?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
ool?000000h0o`00FP0000070?l000L000003`3o0008000001d0o`00200000070?l000P000001`3o
0008000000L0o`003`0000070?l000P000001`3o0008000002`0o`00200000070?l000P000003P3o
0008000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooo`L0o`00200000070?l001h000001`3o0008000000L0o`003`00000?0?l000l000001`3o000N
000000l0o`001`0000070?l001L000007@3o0008000000L0o`003`00000?0?l000P000001`3o0007
000001h0o`00200000070?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?oo
o`030000003oool0oooo00D0oooo1`3o0008000000L0o`007P0000070?l000P000001`3o000?0000
00l0o`003`0000070?l001h000003`3o0007000000L0o`005`00000M0?l000P000001`3o000?0000
00l0o`00200000070?l000L000007P3o0008000000L0o`001`00000?0?l000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000001`3o000N000000L0
o`00200000070?l000l000003`3o000?000000L0o`007P00000?0?l000L000001`3o000G000001d0
o`00200000070?l000l000003`3o0008000000L0o`001`00000N0?l000P000001`3o0007000000l0
o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00
200000070?l001h000001`3o0008000000L0o`003`00000?0?l000l000001`3o000N000000l0o`00
1`0000070?l001L000007@3o0008000000L0o`003`00000?0?l000P000001`3o0007000001h0o`00
200000070?l000L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo1`3o0008000000L0o`007P0000070?l000P000001`3o000?000000l0o`003`00
00070?l001h000003`3o0007000000L0o`005`00000M0?l000P000001`3o000?000000l0o`002000
00070?l000L000007P3o0008000000L0o`001`00000?0?l000L0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000001`3o000N000000L0o`0020000007
0?l000l000003`3o000?000000L0o`007P00000?0?l000L000001`3o000G000001d0o`0020000007
0?l000l000003`3o0008000000L0o`001`00000N0?l000P000001`3o0007000000l0o`001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l0
01h000001`3o0008000000L0o`003`00000?0?l000l000001`3o000N000000l0o`001`0000070?l0
01L000007@3o0008000000L0o`003`00000?0?l000P000001`3o0007000001h0o`00200000070?l0
00L000003`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo1`3o0008000000L0o`007P0000070?l000P000001`3o000?000000l0o`003`0000070?l001h0
00003`3o0007000000L0o`005`00000M0?l000P000001`3o000?000000l0o`00200000070?l000L0
00007P3o0008000000L0o`001`00000?0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooold0?l000l000005P3o0007000001L0o`001`00000U0?l000P00000
1`3o000?000000L0o`003`00000?0?l000L00000203o0007000000l0o`002000000F0?l000L00000
3`3o0008000000l0o`001`0000070?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?oooc@0o`003`00000F0?l000L000005`3o0007000002D0o`002000
00070?l000l000001`3o000?000000l0o`001`0000080?l000L000003`3o0008000001H0o`001`00
000?0?l000P000003`3o0007000000L0o`003`0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo=03o000?000001H0o`001`00000G0?l000L000009@3o0008
000000L0o`003`0000070?l000l000003`3o0007000000P0o`001`00000?0?l000P000005P3o0007
000000l0o`002000000?0?l000L000001`3o000?000000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3ooold0?l000l000005P3o0007000001L0o`001`00000U0?l0
00P000001`3o000?000000L0o`003`00000?0?l000L00000203o0007000000l0o`002000000F0?l0
00L000003`3o0008000000l0o`001`0000070?l000l000001`3oool00`000000oooo0?ooo`0E0?oo
o`005P3oool00`000000oooo0?ooo`050?oooc@0o`003`00000F0?l000L000005`3o0007000002D0
o`00200000070?l000l000001`3o000?000000l0o`001`0000080?l000L000003`3o0008000001H0
o`001`00000?0?l000P000003`3o0007000000L0o`003`0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo=03o000?000001H0o`001`00000G0?l000L00000
9@3o0008000000L0o`003`0000070?l000l000003`3o0007000000P0o`001`00000?0?l000P00000
5P3o0007000000l0o`002000000?0?l000L000001`3o000?000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooold0?l000l000005P3o0007000001L0o`001`00
000U0?l000P000001`3o000?000000L0o`003`00000?0?l000L00000203o0007000000l0o`002000
000F0?l000L000003`3o0008000000l0o`001`0000070?l000l000001`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l000005P3o0007000000l0o`0020000007
0?l000L00000203o000F000000P0o`007@00000N0?l000l000005P3o0008000000h0o`0020000007
0?l000P000005P3o000F000000l0o`00200000070?l000P000001`3o000F000000L0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?000001H0o`001`00000?0?l0
00P000001`3o0007000000P0o`005P0000080?l001d000007P3o000?000001H0o`002000000>0?l0
00P000001`3o0008000001H0o`005P00000?0?l000P000001`3o0008000000L0o`005P0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`00000F0?l000L0
00003`3o0008000000L0o`001`0000080?l001H00000203o000M000001h0o`003`00000F0?l000P0
00003P3o0008000000L0o`002000000F0?l001H000003`3o0008000000L0o`00200000070?l001H0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l00000
5P3o0007000000l0o`00200000070?l000L00000203o000F000000P0o`007@00000N0?l000l00000
5P3o0008000000h0o`00200000070?l000P000005P3o000F000000l0o`00200000070?l000P00000
1`3o000F000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
ool?000001H0o`001`00000?0?l000P000001`3o0007000000P0o`005P0000080?l001d000007P3o
000?000001H0o`002000000>0?l000P000001`3o0008000001H0o`005P00000?0?l000P000001`3o
0008000000L0o`005P0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00D0oooo3`00000F0?l000L000003`3o0008000000L0o`001`0000080?l001H00000203o000M
000001h0o`003`00000F0?l000P000003P3o0008000000L0o`002000000F0?l001H000003`3o0008
000000L0o`00200000070?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooo`l000005P3o0007000000l0o`00200000070?l000L00000203o000F0000
00P0o`007@00000N0?l000l000005P3o0008000000h0o`00200000070?l000P000005P3o000F0000
00l0o`00200000070?l000P000001`3o000F000000L0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01@3oool?000001H0o`001`00000?0?l000P000001`3o0007000000P0
o`005P0000080?l001d000007P3o000?000001H0o`002000000>0?l000P000001`3o0008000001H0
o`005P00000?0?l000P000001`3o0008000000L0o`005P0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo3`3o000>000001h0o`00=00000080?l000L00000
5P3o0008000001H0o`001`00000?0?l000P000001`3o0008000002D0o`001`00000G0?l000L00000
7P3o0007000000P0o`003P0000080?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?ooo`l0o`003P00000N0?l003@00000203o0007000001H0o`002000
000F0?l000L000003`3o0008000000L0o`002000000U0?l000L000005`3o0007000001h0o`001`00
00080?l000h00000203o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3oool?0?l000h000007P3o000d000000P0o`001`00000F0?l000P000005P3o0007
000000l0o`00200000070?l000P000009@3o0007000001L0o`001`00000N0?l000L00000203o000>
000000P0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo3`3o000>000001h0o`00=00000080?l000L000005P3o0008000001H0o`001`00000?0?l0
00P000001`3o0008000002D0o`001`00000G0?l000L000007P3o0007000000P0o`003P0000080?l0
00L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0
o`003P00000N0?l003@00000203o0007000001H0o`002000000F0?l000L000003`3o0008000000L0
o`002000000U0?l000L000005`3o0007000001h0o`001`0000080?l000h00000203o0007000000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l000h00000
7P3o000d000000P0o`001`00000F0?l000P000005P3o0007000000l0o`00200000070?l000P00000
9@3o0007000001L0o`001`00000N0?l000L00000203o000>000000P0o`001`0000070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`3o000>000001h0o`00=000
00080?l000L000005P3o0008000001H0o`001`00000?0?l000P000001`3o0008000002D0o`001`00
000G0?l000L000007P3o0007000000P0o`003P0000080?l000L000001`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L00000203o000>000000P0o`005P000008
0?l000h000003`3o0008000001d0o`00200000070?l000P000001`3o0008000000L0o`001`000008
0?l000L00000203o0007000000P0o`007@0000080?l000L000007P3o0007000000l0o`002000000?
0?l000L000005P3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo1`0000080?l000h00000203o000F000000P0o`003P00000?0?l000P000007@3o00080000
00L0o`00200000070?l000P000001`3o0007000000P0o`001`0000080?l000L00000203o000M0000
00P0o`001`00000N0?l000L000003`3o0008000000l0o`001`00000F0?l000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool7000000P0o`003P0000080?l001H0
0000203o000>000000l0o`002000000M0?l000P000001`3o0008000000L0o`00200000070?l000L0
0000203o0007000000P0o`001`0000080?l001d00000203o0007000001h0o`001`00000?0?l000P0
00003`3o0007000001H0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?ooo`L00000203o000>000000P0o`005P0000080?l000h000003`3o0008000001d0o`00
200000070?l000P000001`3o0008000000L0o`001`0000080?l000L00000203o0007000000P0o`00
7@0000080?l000L000007P3o0007000000l0o`002000000?0?l000L000005P3o00070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`0000080?l000h00000203o
000F000000P0o`003P00000?0?l000P000007@3o0008000000L0o`00200000070?l000P000001`3o
0007000000P0o`001`0000080?l000L00000203o000M000000P0o`001`00000N0?l000L000003`3o
0008000000l0o`001`00000F0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3oool7000000P0o`003P0000080?l001H00000203o000>000000l0o`002000000M
0?l000P000001`3o0008000000L0o`00200000070?l000L00000203o0007000000P0o`001`000008
0?l001d00000203o0007000001h0o`001`00000?0?l000P000003`3o0007000001H0o`001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L00000203o000>0000
00P0o`005P0000080?l000h000003`3o0008000001d0o`00200000070?l000P000001`3o00080000
00L0o`001`0000080?l000L00000203o0007000000P0o`007@0000080?l000L000007P3o00070000
00l0o`002000000?0?l000L000005P3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`03
0000003oool0oooo00D0oooo7@3o0008000000L0o`003`0000080?l000h00000203o000U000000l0
o`001`00000G0?l000L000003`3o000?000001d0o`002000000N0?l000l000003P3o000?000000P0
o`001`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?oooad0o`00200000070?l000l00000203o000>000000P0o`009@00000?0?l000L00000
5`3o0007000000l0o`003`00000M0?l000P000007P3o000?000000h0o`003`0000080?l000L00000
3`3o000F000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oolM0?l000P000001`3o000?000000P0o`003P0000080?l002D000003`3o0007000001L0o`001`00
000?0?l000l000007@3o0008000001h0o`003`00000>0?l000l00000203o0007000000l0o`005P00
00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo7@3o0008
000000L0o`003`0000080?l000h00000203o000U000000l0o`001`00000G0?l000L000003`3o000?
000001d0o`002000000N0?l000l000003P3o000?000000P0o`001`00000?0?l001H000001`3oool0
0`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooad0o`00200000070?l0
00l00000203o000>000000P0o`009@00000?0?l000L000005`3o0007000000l0o`003`00000M0?l0
00P000007P3o000?000000h0o`003`0000080?l000L000003`3o000F000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolM0?l000P000001`3o000?000000P0
o`003P0000080?l002D000003`3o0007000001L0o`001`00000?0?l000l000007@3o0008000001h0
o`003`00000>0?l000l00000203o0007000000l0o`005P0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo7@3o0008000000L0o`003`0000080?l000h00000
203o000U000000l0o`001`00000G0?l000L000003`3o000?000001d0o`002000000N0?l000l00000
3P3o000?000000P0o`001`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?oooad0o`00200000070?l000l00000203o000>000000P0o`009@00
000?0?l000L000005`3o0007000000l0o`003`00000M0?l000P000007P3o000?000000h0o`003`00
00080?l000L000003`3o000F000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3oool7000000l0o`001`00000V0?l000L000001`3o0008000000L0o`002000000F
0?l000l000003`3o0007000000l0o`009@00000?0?l000L00000203o0007000003@0o`00;@000007
0?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oo
o`L000003`3o0007000002H0o`001`0000070?l000P000001`3o0008000001H0o`003`00000?0?l0
00L000003`3o000U000000l0o`001`0000080?l000L00000=03o000]000000L0o`003`0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`00000?0?l000L0
00009P3o0007000000L0o`00200000070?l000P000005P3o000?000000l0o`001`00000?0?l002D0
00003`3o0007000000P0o`001`00000d0?l002d000001`3o000?000000L0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01@3oool7000000l0o`001`00000V0?l000L00000
1`3o0008000000L0o`002000000F0?l000l000003`3o0007000000l0o`009@00000?0?l000L00000
203o0007000003@0o`00;@0000070?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?ooo`L000003`3o0007000002H0o`001`0000070?l000P000001`3o
0008000001H0o`003`00000?0?l000L000003`3o000U000000l0o`001`0000080?l000L00000=03o
000]000000L0o`003`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00D0oooo1`00000?0?l000L000009P3o0007000000L0o`00200000070?l000P000005P3o000?
000000l0o`001`00000?0?l002D000003`3o0007000000P0o`001`00000d0?l002d000001`3o000?
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70000
00l0o`001`00000V0?l000L000001`3o0008000000L0o`002000000F0?l000l000003`3o00070000
00l0o`009@00000?0?l000L00000203o0007000003@0o`00;@0000070?l000l000001`3oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l000001`3o000?000000L0
o`00200000070?l000P000003P3o0008000000l0o`001`0000080?l000L000003`3o0007000000P0
o`001`00000?0?l000L00000203o000?000000L0o`00200000070?l001H00000203o000U000000L0
o`003`00000d0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1@3oool?000000L0o`003`0000070?l000P000001`3o0008000000h0o`002000000?0?l000L00000
203o0007000000l0o`001`0000080?l000L000003`3o0007000000P0o`003`0000070?l000P00000
1`3o000F000000P0o`009@0000070?l000l00000=03o00070?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00D0oooo3`0000070?l000l000001`3o0008000000L0o`002000
000>0?l000P000003`3o0007000000P0o`001`00000?0?l000L00000203o0007000000l0o`001`00
00080?l000l000001`3o0008000000L0o`005P0000080?l002D000001`3o000?000003@0o`001`3o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l000001`3o000?
000000L0o`00200000070?l000P000003P3o0008000000l0o`001`0000080?l000L000003`3o0007
000000P0o`001`00000?0?l000L00000203o000?000000L0o`00200000070?l001H00000203o000U
000000L0o`003`00000d0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3oool?000000L0o`003`0000070?l000P000001`3o0008000000h0o`002000000?0?l0
00L00000203o0007000000l0o`001`0000080?l000L000003`3o0007000000P0o`003`0000070?l0
00P000001`3o000F000000P0o`009@0000070?l000l00000=03o00070?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`0000070?l000l000001`3o0008000000L0
o`002000000>0?l000P000003`3o0007000000P0o`001`00000?0?l000L00000203o0007000000l0
o`001`0000080?l000l000001`3o0008000000L0o`005P0000080?l002D000001`3o000?000003@0
o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l00000
1`3o000?000000L0o`00200000070?l000P000003P3o0008000000l0o`001`0000080?l000L00000
3`3o0007000000P0o`001`00000?0?l000L00000203o000?000000L0o`00200000070?l001H00000
203o000U000000L0o`003`00000d0?l000L0oooo00<000000?ooo`3oool05@3oool000030?oo_`1d
0000000000@0000000D0M;oo0?ooo`3oool0oooo0?noM0030000000307Boo`3oool0oooo00@0oooo
00<000000?ooo`3oool01@3oool?0?l000h000005`3o000?000000L0o`001`00000?0?l001L00000
1`3o000U000001H0o`007P00000?0?l000l000001`3o0008000000L0o`005`0000070?l001H00000
203o0007000000P0o`001`0000070?l000P000001`3o00070?ooo`060000003oool0oooo0?ooo`3o
okl0M0001@0000001@1d_ol0oooo0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool00P3oool0
00040?ooo`2oM000001d0;ooo`80oooo00<0giad09cOo`3oool00P3oool01P2LB7@0_ooo0?ooo`3o
okl0M01d0;ooo`D0oooo00<000000?ooo`3oool01@3oool?0?l000h000005`3o000?000000L0o`00
1`00000?0?l001L000001`3o000U000001H0o`007P00000?0?l000l000001`3o0008000000L0o`00
5`0000070?l001H00000203o0007000000P0o`001`0000070?l000P000001`3o00070?ooo`030000
003oool0oooo0080oooo00<0_g@00000M02oool00P3oool00`3OW7@0W=oo0?ooo`020?ooo`0609a8
M02oool0oooo0?oo_`1d07@0_ooo0`3oool00080oooo00<0okmd0000B02Lgol01@3oool00`3o_g@0
07Bo0?ooo`020?ooo`030=nLB018W=l0oooo00@0oooo00<000000?ooo`3oool01@3oool?0?l000h0
00005`3o000?000000L0o`001`00000?0?l001L000001`3o000U000001H0o`007P00000?0?l000l0
00001`3o0008000000L0o`005`0000070?l001H00000203o0007000000P0o`001`0000070?l000P0
00001`3o00070?ooo`030000003oool0oooo00<0oooo00<0okmd0000B02Lgol01@3oool00`3o_g@0
07Bo0?ooo`020?ooo`030=nLB018W=l0oooo0080oooo00030?ooo`030?oOW0180000B9cO00@0oooo
00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`040?ooo`030000003oool0oooo00D0oooo
3`3o000>000001L0o`003`0000070?l000L000003`3o000G000000L0o`009@00000F0?l001h00000
3`3o000?000000L0o`00200000070?l001L000001`3o000F000000P0o`001`0000080?l000L00000
1`3o0008000000L0o`001`3oool00`000000oooo0?ooo`040?ooo`030?oOW0180000B9cO00@0oooo
00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`020?ooo`001@3oool00`2LB000B9cO0?oo
o`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool0103oool4000000@0oooo3`3o
000>000001L0o`003`0000070?l000L000003`3o000G000000L0o`009@00000F0?l001h000003`3o
000?000000L0o`00200000070?l001L000001`3o000F000000P0o`001`0000080?l000L000001`3o
0008000000L0o`00103oool4000000P0oooo00<0W4P004RLg`3oool00P3oool00`3OW4P0B9cO0?oo
o`020?ooo`030?noM000M;l0oooo0080oooo00060?ooo`0609a8M02oool0oooo0?ooo`3OW4P0B9cO
0`3oool00`3o_g@007Bo0?ooo`040?ooo`030000003oool0oooo00D0oooo3`3o000>000001L0o`00
3`0000070?l000L000003`3o000G000000L0o`009@00000F0?l001h000003`3o000?000000L0o`00
200000070?l001L000001`3o000F000000P0o`001`0000080?l000L000001`3o0008000000L0o`00
1`3oool00`000000oooo0?ooo`070?ooo`0609a8M02oool0oooo0?ooo`3OW4P0B9cO0`3oool00`3o
_g@007Bo0?ooo`020?ooo`0000<0oooo0=nLB01d_ol00`3oool01P2oM000M;oo0?ooo`3oool0okmd
04RLg`<0oooo00<0gia804RLg`3oool0103oool00`000000oooo0?ooo`050?ooo`l0o`003P00000G
0?l000l000001`3o0007000000l0o`005`0000070?l002D000005P3o000N000000l0o`003`000007
0?l000P000001`3o000G000000L0o`005P0000080?l000L00000203o0007000000L0o`0020000007
0?l000L0oooo00<000000?ooo`3oool00P3oool00`3OW4P0M;oo0?ooo`020?ooo`060;md001d_ol0
oooo0?ooo`3o_g@0B9cO0`3oool00`3OW4P0B9cO0?ooo`020?ooo`0000P0oooo0?noM00007@0_ooo
0?ooo`3o_g@0001809cOo`<0oooo00H0W4P007Boo`3oool0omnL04P0M02oool50?ooo`030000003o
ool0oooo00D0oooo3`3o000>000001L0o`003`0000070?l000L000003`3o000G000000L0o`009@00
000F0?l001h000003`3o000?000000L0o`00200000070?l001L000001`3o000F000000P0o`001`00
00080?l000L000001`3o0008000000L0o`001`3oool00`000000oooo0?ooo`020?ooo`070?noM000
07@0_ooo0?ooo`3o_g@0001809cOo`030?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo0`3oool0
0080oooo00D0okmd000000000000001809cOo`040?ooo`050?oo_`1d000000000000B02Lgol01P3o
ool00`000000oooo0?ooo`050?ooo`L00000203o000M000000P0o`005P00000N0?l002D00000=03o
000F000000l0o`001`00000?0?l000l00000203o0007000000P0o`003P00000G0?l000l000001`3o
0007000000P0o`001`0000070?ooo`030000003oool0oooo00<0oooo00D0okmd0000000000000018
09cOo`040?ooo`050?oo_`1d000000000000B02Lgol0103oool001H0oooo00<000000?ooo`3oool0
1@3oool7000000P0o`007@0000080?l001H000007P3o000U000003@0o`005P00000?0?l000L00000
3`3o000?000000P0o`001`0000080?l000h000005`3o000?000000L0o`001`0000080?l000L00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L00000203o
000M000000P0o`005P00000N0?l002D00000=03o000F000000l0o`001`00000?0?l000l00000203o
0007000000P0o`003P00000G0?l000l000001`3o0007000000P0o`001`0000070?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`0000080?l001d00000203o000F
000001h0o`009@00000d0?l001H000003`3o0007000000l0o`003`0000080?l000L00000203o000>
000001L0o`003`0000070?l000L00000203o0007000000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3oool7000000P0o`007@0000080?l001H000007P3o000U0000
03@0o`005P00000?0?l000L000003`3o000?000000P0o`001`0000080?l000h000005`3o000?0000
00L0o`001`0000080?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`050?ooo`L00000203o000M000000P0o`005P00000N0?l002D00000=03o000F000000l0
o`001`00000?0?l000l00000203o0007000000P0o`003P00000G0?l000l000001`3o0007000000P0
o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo
1`0000080?l001d00000203o000F000001h0o`009@00000d0?l001H000003`3o0007000000l0o`00
3`0000080?l000L00000203o000>000001L0o`003`0000070?l000L00000203o0007000000L0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolM000000l0o`003`00
000F0?l001h00000203o000>000003@0o`00200000070?l000l000003`3o0007000000l0o`002000
00070?l001h000007P3o000F000000l0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo7@00000?0?l000l000005P3o000N000000P0o`003P00000d
0?l000P000001`3o000?000000l0o`001`00000?0?l000P000001`3o000N000001h0o`005P00000?
0?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oo
oad000003`3o000?000001H0o`007P0000080?l000h00000=03o0008000000L0o`003`00000?0?l0
00L000003`3o0008000000L0o`007P00000N0?l001H000003`3o0007000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolM000000l0o`003`00000F0?l001h0
0000203o000>000003@0o`00200000070?l000l000003`3o0007000000l0o`00200000070?l001h0
00007P3o000F000000l0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00D0oooo7@00000?0?l000l000005P3o000N000000P0o`003P00000d0?l000P00000
1`3o000?000000l0o`001`00000?0?l000P000001`3o000N000001h0o`005P00000?0?l000L00000
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooad000003`3o
000?000001H0o`007P0000080?l000h00000=03o0008000000L0o`003`00000?0?l000L000003`3o
0008000000L0o`007P00000N0?l001H000003`3o0007000000L0oooo00<000000?ooo`3oool05@3o
ool001H0oooo00<000000?ooo`3oool01@3ooolM000000l0o`003`00000F0?l001h00000203o000>
000003@0o`00200000070?l000l000003`3o0007000000l0o`00200000070?l001h000007P3o000F
000000l0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo7@00000?0?l000l000005P3o000N000000P0o`003P00000d0?l000P000001`3o000?0000
00l0o`001`00000?0?l000P000001`3o000N000001h0o`005P00000?0?l000L000001`3oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L000003`3o000F000001h0
o`003`00000N0?l001d000007P3o000?000000l0o`003`0000070?l000l000003`3o000?000000L0
o`002000000>0?l001L000003`3o0007000000L0o`003`0000070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo1`00000?0?l001H000007P3o000?000001h0o`00
7@00000N0?l000l000003`3o000?000000L0o`003`00000?0?l000l000001`3o0008000000h0o`00
5`00000?0?l000L000001`3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<0
00000?ooo`3oool01@3oool7000000l0o`005P00000N0?l000l000007P3o000M000001h0o`003`00
000?0?l000l000001`3o000?000000l0o`003`0000070?l000P000003P3o000G000000l0o`001`00
00070?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooo`L000003`3o000F000001h0o`003`00000N0?l001d000007P3o000?000000l0o`003`000007
0?l000l000003`3o000?000000L0o`002000000>0?l001L000003`3o0007000000L0o`003`000007
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`00000?0?l0
01H000007P3o000?000001h0o`007@00000N0?l000l000003`3o000?000000L0o`003`00000?0?l0
00l000001`3o0008000000h0o`005`00000?0?l000L000001`3o000?000000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool7000000l0o`005P00000N0?l000l0
00007P3o000M000001h0o`003`00000?0?l000l000001`3o000?000000l0o`003`0000070?l000P0
00003P3o000G000000l0o`001`0000070?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`050?ooo`L000003`3o000F000001h0o`003`00000N0?l001d00000
7P3o000?000000l0o`003`0000070?l000l000003`3o000?000000L0o`002000000>0?l001L00000
3`3o0007000000L0o`003`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003o
ool0oooo00D0oooo1`3o0008000000L0o`00;@00000U0?l000l000005P3o000?000000l0o`001`00
000?0?l000L000005`3o0007000000L0o`00200000070?l001L000003`3o000F000000l0o`001`00
000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?ooo`L0o`00200000070?l002d000009@3o000?000001H0o`003`00000?0?l000L000003`3o0007
000001L0o`001`0000070?l000P000001`3o000G000000l0o`005P00000?0?l000L000003`3o000F
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l0
00P000001`3o000]000002D0o`003`00000F0?l000l000003`3o0007000000l0o`001`00000G0?l0
00L000001`3o0008000000L0o`005`00000?0?l001H000003`3o0007000000l0o`005P0000070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000000L0
o`00;@00000U0?l000l000005P3o000?000000l0o`001`00000?0?l000L000005`3o0007000000L0
o`00200000070?l001L000003`3o000F000000l0o`001`00000?0?l001H000001`3oool00`000000
oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00200000070?l002d00000
9@3o000?000001H0o`003`00000?0?l000L000003`3o0007000001L0o`001`0000070?l000P00000
1`3o000G000000l0o`005P00000?0?l000L000003`3o000F000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000001`3o000]000002D0o`003`00
000F0?l000l000003`3o0007000000l0o`001`00000G0?l000L000001`3o0008000000L0o`005`00
000?0?l001H000003`3o0007000000l0o`005P0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo1`3o0008000000L0o`00;@00000U0?l000l000005P3o000?
000000l0o`001`00000?0?l000L000005`3o0007000000L0o`00200000070?l001L000003`3o000F
000000l0o`001`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?oooaH000001`3o000?000000P0o`001`00000?0?l001h000001`3o00080000
01d0o`00200000070?l001H00000203o000?000000L0o`007P00000F0?l000P000001`3o000U0000
01h0o`005P0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo5P0000070?l000l00000203o0007000000l0o`007P0000070?l000P000007@3o0008000000L0
o`005P0000080?l000l000001`3o000N000001H0o`00200000070?l002D000007P3o000F000000L0
oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolF000000L0o`00
3`0000080?l000L000003`3o000N000000L0o`002000000M0?l000P000001`3o000F000000P0o`00
3`0000070?l001h000005P3o0008000000L0o`009@00000N0?l001H000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooaH000001`3o000?000000P0o`001`00
000?0?l001h000001`3o0008000001d0o`00200000070?l001H00000203o000?000000L0o`007P00
000F0?l000P000001`3o000U000001h0o`005P0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo5P0000070?l000l00000203o0007000000l0o`007P000007
0?l000P000007@3o0008000000L0o`005P0000080?l000l000001`3o000N000001H0o`0020000007
0?l002D000007P3o000F000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3ooolF000000L0o`003`0000080?l000L000003`3o000N000000L0o`002000000M0?l0
00P000001`3o000F000000P0o`003`0000070?l001h000005P3o0008000000L0o`009@00000N0?l0
01H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooaH0
00001`3o000?000000P0o`001`00000?0?l001h000001`3o0008000001d0o`00200000070?l001H0
0000203o000?000000L0o`007P00000F0?l000P000001`3o000U000001h0o`005P0000070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo5P0000070?l000l00000
203o0007000000l0o`007P0000070?l000P000007@3o0008000000L0o`005P0000080?l000l00000
1`3o000N000001H0o`00200000070?l002D000007P3o000F000000L0oooo00<000000?ooo`3oool0
5@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000000l0o`005P0000070?l000P000001`3o
000?000000P0o`005P00000/0?l000P000001`3o000G000000L0o`009@00000]0?l000L00000203o
000?000000L0o`001`00000?0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooolU000000l0o`005P0000070?l000P000001`3o000?000000P0o`005P00000/
0?l000P000001`3o000G000000L0o`009@00000]0?l000L00000203o000?000000L0o`001`00000?
0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU0000
00l0o`005P0000070?l000P000001`3o000?000000P0o`005P00000/0?l000P000001`3o000G0000
00L0o`009@00000]0?l000L00000203o000?000000L0o`001`00000?0?l000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000000l0o`005P0000070?l000P0
00001`3o000?000000P0o`005P00000/0?l000P000001`3o000G000000L0o`009@00000]0?l000L0
0000203o000?000000L0o`001`00000?0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolU000000l0o`005P0000070?l000P000001`3o000?000000P0o`00
5P00000/0?l000P000001`3o000G000000L0o`009@00000]0?l000L00000203o000?000000L0o`00
1`00000?0?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
oolU000000l0o`005P0000070?l000P000001`3o000?000000P0o`005P00000/0?l000P000001`3o
000G000000L0o`009@00000]0?l000L00000203o000?000000L0o`001`00000?0?l000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3ooolU000000l0o`005P000007
0?l000P000001`3o000?000000P0o`005P00000/0?l000P000001`3o000G000000L0o`009@00000]
0?l000L00000203o000?000000L0o`001`00000?0?l000L0oooo00<000000?ooo`3oool05@3oool0
01H0oooo00<000000?ooo`3oool01@3ooolF000000L0o`007P0000080?l000h00000203o000/0000
00P0o`001`00000?0?l000l000001`3o000?000000P0o`001`0000080?l000L000001`3o000G0000
00L0o`002000000U0?l000l000007@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01@3ooolF000000L0o`007P0000080?l000h00000203o000/000000P0
o`001`00000?0?l000l000001`3o000?000000P0o`001`0000080?l000L000001`3o000G000000L0
o`002000000U0?l000l000007@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo
00<000000?ooo`3oool01@3ooolF000000L0o`007P0000080?l000h00000203o000/000000P0o`00
1`00000?0?l000l000001`3o000?000000P0o`001`0000080?l000L000001`3o000G000000L0o`00
2000000U0?l000l000007@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<0
00000?ooo`3oool01@3ooolF000000L0o`007P0000080?l000h00000203o000/000000P0o`001`00
000?0?l000l000001`3o000?000000P0o`001`0000080?l000L000001`3o000G000000L0o`002000
000U0?l000l000007@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<00000
0?ooo`3oool01@3ooolF000000L0o`007P0000080?l000h00000203o000/000000P0o`001`00000?
0?l000l000001`3o000?000000P0o`001`0000080?l000L000001`3o000G000000L0o`002000000U
0?l000l000007@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3ooolF000000L0o`007P0000080?l000h00000203o000/000000P0o`001`00000?0?l0
00l000001`3o000?000000P0o`001`0000080?l000L000001`3o000G000000L0o`002000000U0?l0
00l000007@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3o
ool01@3ooolF000000L0o`007P0000080?l000h00000203o000/000000P0o`001`00000?0?l000l0
00001`3o000?000000P0o`001`0000080?l000L000001`3o000G000000L0o`002000000U0?l000l0
00007@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1@3ooolF000000L0o`007P0000080?l000h00000203o000/000000P0o`001`00000?0?l000l00000
1`3o000?000000P0o`001`0000080?l000L000001`3o000G000000L0o`002000000U0?l000l00000
7@3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3o
ool70?l000l000001`3o0008000002D0o`001`0000080?l000L00000203o0007000000l0o`001`00
000?0?l000P000003`3o0007000000L0o`002000000?0?l000L000009@3o000G000001H0o`003`00
00070?l001L000007@3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0
oooo00D0oooo1`3o000?000000L0o`002000000U0?l000L00000203o0007000000P0o`001`00000?
0?l000L000003`3o0008000000l0o`001`0000070?l000P000003`3o0007000002D0o`005`00000F
0?l000l000001`3o000G000001d0o`001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?ooo`L0o`003`0000070?l000P000009@3o0007000000P0o`001`0000080?l0
00L000003`3o0007000000l0o`002000000?0?l000L000001`3o0008000000l0o`001`00000U0?l0
01L000005P3o000?000000L0o`005`00000M0?l000L0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01@3oool70?l000l000001`3o0008000002D0o`001`0000080?l000L0
0000203o0007000000l0o`001`00000?0?l000P000003`3o0007000000L0o`002000000?0?l000L0
00009@3o000G000001H0o`003`0000070?l001L000007@3o00070?ooo`030000003oool0oooo01D0
oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o000?000000L0o`002000000U0?l000L00000
203o0007000000P0o`001`00000?0?l000L000003`3o0008000000l0o`001`0000070?l000P00000
3`3o0007000002D0o`005`00000F0?l000l000001`3o000G000001d0o`001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`003`0000070?l000P000009@3o
0007000000P0o`001`0000080?l000L000003`3o0007000000l0o`002000000?0?l000L000001`3o
0008000000l0o`001`00000U0?l001L000005P3o000?000000L0o`005`00000M0?l000L0oooo00<0
00000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000l000001`3o0008
000002D0o`001`0000080?l000L00000203o0007000000l0o`001`00000?0?l000P000003`3o0007
000000L0o`002000000?0?l000L000009@3o000G000001H0o`003`0000070?l001L000007@3o0007
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o00080000
01d0o`00200000070?l000l000001`3o000G000001H0o`001`0000080?l000L000005`3o000>0000
00P0o`007P0000070?l002d000001`3o0008000000L0o`007P00000F0?l000L000003`3o00070?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0
o`00200000070?l000l000001`3o000G000001H0o`001`0000080?l000L000005`3o000>000000P0
o`007P0000070?l002d000001`3o0008000000L0o`007P00000F0?l000L000003`3o00070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0o`00
200000070?l000l000001`3o000G000001H0o`001`0000080?l000L000005`3o000>000000P0o`00
7P0000070?l002d000001`3o0008000000L0o`007P00000F0?l000L000003`3o00070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0o`002000
00070?l000l000001`3o000G000001H0o`001`0000080?l000L000005`3o000>000000P0o`007P00
00070?l002d000001`3o0008000000L0o`007P00000F0?l000L000003`3o00070?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0o`0020000007
0?l000l000001`3o000G000001H0o`001`0000080?l000L000005`3o000>000000P0o`007P000007
0?l002d000001`3o0008000000L0o`007P00000F0?l000L000003`3o00070?ooo`030000003oool0
oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0o`00200000070?l0
00l000001`3o000G000001H0o`001`0000080?l000L000005`3o000>000000P0o`007P0000070?l0
02d000001`3o0008000000L0o`007P00000F0?l000L000003`3o00070?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000001d0o`00200000070?l000l0
00001`3o000G000001H0o`001`0000080?l000L000005`3o000>000000P0o`007P0000070?l002d0
00001`3o0008000000L0o`007P00000F0?l000L000003`3o00070?ooo`030000003oool0oooo01D0
oooo00000`3oool0okmd0000000400000005001d_`3oool0oooo0?ooo`3o_g@00`0000000`1d_ol0
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo9@3o000d000000L0o`005`00000F0?l000L0
0000203o000M000000P0o`001`00000U0?l000l00000203o0007000002D0o`009P0000070?l000L0
0000203o0007000000L0oooo00<000000?ooo`3oool00P3oool00`3o_g@000000000000300000005
001d_`3oool0oooo0?ooo`3o_g@00`0000000`1d_ol0oooo0?ooo`020?ooo`00103oool00`2LB4P0
W=oo0?ooo`040?ooo`0609a8M02oool0oooo0?oo_`1d07@0_ooo1@3oool00`000000oooo0?ooo`05
0?ooobD0o`00=00000070?l001L000005P3o0007000000P0o`007@0000080?l000L000009@3o000?
000000P0o`001`00000U0?l002H000001`3o0007000000P0o`001`0000070?ooo`030000003oool0
oooo00D0oooo00<0W4Q809cOo`3oool0103oool01P2LB7@0_ooo0?ooo`3ookl0M01d0;ooo`<0oooo
00040?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd001d_`3oool00P3oool00`3OW4P0B9cO0?oo
o`040?ooo`030000003oool0oooo00D0oooo9@3o000d000000L0o`005`00000F0?l000L00000203o
000M000000P0o`001`00000U0?l000l00000203o0007000002D0o`009P0000070?l000L00000203o
0007000000L0oooo00<000000?ooo`3oool01@3oool00`2LB4P0W=oo0?ooo`030?ooo`030?noM000
M;l0oooo0080oooo00<0gia804RLg`3oool00P3oool000@0oooo00<0W4Q809cOo`3oool00`3oool0
0`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo00<000000?ooo`3oool01@3ooolU
0?l003@000001`3o000G000001H0o`001`0000080?l001d00000203o0007000002D0o`003`000008
0?l000L000009@3o000V000000L0o`001`0000080?l000L000001`3oool00`000000oooo0?ooo`05
0?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`02
0?ooo`00103oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d
_`3oool0103oool4000000@0oooo9@3o000d000000L0o`005`00000F0?l000L00000203o000M0000
00P0o`001`00000U0?l000l00000203o0007000002D0o`009P0000070?l000L00000203o00070000
00@0oooo100000070?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RLg`3oool00P3oool00`3o
_g@007Bo0?ooo`020?ooo`00103oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080
oooo00<0okmd001d_`3oool0103oool00`000000oooo0?ooo`050?ooobD0o`00=00000070?l001L0
00005P3o0007000000P0o`007@0000080?l000L000009@3o000?000000P0o`001`00000U0?l002H0
00001`3o0007000000P0o`001`0000070?ooo`030000003oool0oooo00D0oooo00<0W4Q809cOo`3o
ool00`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo0080oooo00040?ooo`0309a8
B02Lgol0oooo00<0oooo00<0okmd04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`040?ooo`030000
003oool0oooo00D0oooo9@3o000d000000L0o`005`00000F0?l000L00000203o000M000000P0o`00
1`00000U0?l000l00000203o0007000002D0o`009P0000070?l000L00000203o0007000000L0oooo
00<000000?ooo`3oool01@3oool00`2LB4P0W=oo0?ooo`030?ooo`030?noM018W=l0oooo0080oooo
00<0gia804RLg`3oool00P3oool000060?ooo`3OW4P000000018W02LB4P0W=oo1@3oool01P2LB000
M;oo0?ooo`3ogi`0B01d0;ooo`D0oooo00<000000?ooo`3oool01@3ooolU0?l003@000001`3o000G
000001H0o`001`0000080?l001d00000203o0007000002D0o`003`0000080?l000L000009@3o000V
000000L0o`001`0000080?l000L000001`3oool00`000000oooo0?ooo`020?ooo`050=nLB0000000
04RL09a8B02Lgol01@3oool01P2LB000M;oo0?ooo`3ogi`0B01d0;ooo`<0oooo00030?ooo`030=nL
B00004P0W=oo00D0oooo00D0oono07@000000000001809cOo`060?ooo`030000003oool0oooo00D0
oooo1`3o000?000000L0o`005`00000?0?l000L000001`3o0008000000L0o`002000000?0?l000L0
00003`3o0007000000P0o`001`00000?0?l000l000001`3o000G000000L0o`001`0000080?l001H0
00005`3o0007000000l0o`007P00000F0?l000L000001`3oool00`000000oooo0?ooo`040?ooo`03
0=nLB00004P0W=oo00D0oooo00D0oono07@000000000001809cOo`040?ooo`005P3oool00`000000
oooo0?ooo`050?ooo`L0o`003`0000070?l001L000003`3o0007000000L0o`00200000070?l000P0
00003`3o0007000000l0o`001`0000080?l000L000003`3o000?000000L0o`005`0000070?l000L0
0000203o000F000001L0o`001`00000?0?l001h000005P3o0007000000L0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000l000001`3o000G000000l0o`00
1`0000070?l000P000001`3o0008000000l0o`001`00000?0?l000L00000203o0007000000l0o`00
3`0000070?l001L000001`3o0007000000P0o`005P00000G0?l000L000003`3o000N000001H0o`00
1`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o
000?000000L0o`005`00000?0?l000L000001`3o0008000000L0o`002000000?0?l000L000003`3o
0007000000P0o`001`00000?0?l000l000001`3o000G000000L0o`001`0000080?l001H000005`3o
0007000000l0o`007P00000F0?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooo`L0o`003`0000070?l001L000003`3o0007000000L0o`0020000007
0?l000P000003`3o0007000000l0o`001`0000080?l000L000003`3o000?000000L0o`005`000007
0?l000L00000203o000F000001L0o`001`00000?0?l001h000005P3o0007000000L0oooo00<00000
0?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000l000001`3o000G0000
00l0o`001`0000070?l000P000001`3o0008000000l0o`001`00000?0?l000L00000203o00070000
00l0o`003`0000070?l001L000001`3o0007000000P0o`005P00000G0?l000L000003`3o000N0000
01H0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo1`3o000?000000L0o`005`00000?0?l000L000001`3o0008000000L0o`002000000?0?l000L0
00003`3o0007000000P0o`001`00000?0?l000l000001`3o000G000000L0o`001`0000080?l001H0
00005`3o0007000000l0o`007P00000F0?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`050?oooaH000003`3o0007000000P0o`003`0000070?l000l00000
1`3o000?000000P0o`005P0000070?l000P000003`3o000>000000l0o`003`0000080?l003@00000
7@3o0008000000L0o`003`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3o
ool00`000000oooo0?ooo`050?oooaH000003`3o0007000000P0o`003`0000070?l000l000001`3o
000?000000P0o`005P0000070?l000P000003`3o000>000000l0o`003`0000080?l003@000007@3o
0008000000L0o`003`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?oooaH000003`3o0007000000P0o`003`0000070?l000l000001`3o000?
000000P0o`005P0000070?l000P000003`3o000>000000l0o`003`0000080?l003@000007@3o0008
000000L0o`003`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`00
0000oooo0?ooo`050?oooaH000003`3o0007000000P0o`003`0000070?l000l000001`3o000?0000
00P0o`005P0000070?l000P000003`3o000>000000l0o`003`0000080?l003@000007@3o00080000
00L0o`003`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`050?oooaH000003`3o0007000000P0o`003`0000070?l000l000001`3o000?000000P0
o`005P0000070?l000P000003`3o000>000000l0o`003`0000080?l003@000007@3o0008000000L0
o`003`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?oooaH000003`3o0007000000P0o`003`0000070?l000l000001`3o000?000000P0o`00
5P0000070?l000P000003`3o000>000000l0o`003`0000080?l003@000007@3o0008000000L0o`00
3`00000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`050?oooaH000003`3o0007000000P0o`003`0000070?l000l000001`3o000?000000P0o`005P00
00070?l000P000003`3o000>000000l0o`003`0000080?l003@000007@3o0008000000L0o`003`00
000?0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`05
0?oooaH000003`3o0007000000P0o`003`0000070?l000l000001`3o000?000000P0o`005P000007
0?l000P000003`3o000>000000l0o`003`0000080?l003@000007@3o0008000000L0o`003`00000?
0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oo
o`l0o`001`00000?0?l000l00000@`3o0007000000L0o`009P0000070?l001h000001`3o000F0000
00l0o`002000000?0?l000L00000203o0007000000l0o`001`00000G0?l001d000001`3oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0o`001`00000?0?l000l0
0000@`3o0007000000L0o`009P0000070?l001h000001`3o000F000000l0o`002000000?0?l000L0
0000203o0007000000l0o`001`00000G0?l001d000001`3oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`050?ooo`l0o`001`00000?0?l000l00000@`3o0007000000L0o`00
9P0000070?l001h000001`3o000F000000l0o`002000000?0?l000L00000203o0007000000l0o`00
1`00000G0?l001d000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`050?ooo`l0o`001`00000?0?l000l00000@`3o0007000000L0o`009P0000070?l001h000001`3o
000F000000l0o`002000000?0?l000L00000203o0007000000l0o`001`00000G0?l001d000001`3o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0o`001`00000?
0?l000l00000@`3o0007000000L0o`009P0000070?l001h000001`3o000F000000l0o`002000000?
0?l000L00000203o0007000000l0o`001`00000G0?l001d000001`3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0o`001`00000?0?l000l00000@`3o00070000
00L0o`009P0000070?l001h000001`3o000F000000l0o`002000000?0?l000L00000203o00070000
00l0o`001`00000G0?l001d000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000
oooo0?ooo`050?ooo`l0o`001`00000?0?l000l00000@`3o0007000000L0o`009P0000070?l001h0
00001`3o000F000000l0o`002000000?0?l000L00000203o0007000000l0o`001`00000G0?l001d0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0o`00
1`00000F0?l000P000003`3o000/000000P0o`001`0000070?l002H000001`3o000N000001H0o`00
1`00000?0?l000P000001`3o0008000001H0o`003`00000?0?l000L000007P3o0007000000L0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0?l000L000005P3o
0008000000l0o`00;00000080?l000L000001`3o000V000000L0o`007P00000F0?l000L000003`3o
0008000000L0o`002000000F0?l000l000003`3o0007000001h0o`001`0000070?ooo`030000003o
ool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`3o0007000001H0o`002000000?
0?l002`00000203o0007000000L0o`009P0000070?l001h000005P3o0007000000l0o`0020000007
0?l000P000005P3o000?000000l0o`001`00000N0?l000L000001`3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`l0o`001`00000F0?l000P000003`3o000/0000
00P0o`001`0000070?l002H000001`3o000N000001H0o`001`00000?0?l000P000001`3o00080000
01H0o`003`00000?0?l000L000007P3o0007000000L0oooo00<000000?ooo`3oool05@3oool001H0
oooo00<000000?ooo`3oool01@3oool?0?l000L000005P3o0008000000l0o`00;00000080?l000L0
00001`3o000V000000L0o`007P00000F0?l000L000003`3o0008000000L0o`002000000F0?l000l0
00003`3o0007000001h0o`001`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000
003oool0oooo00D0oooo3`3o0007000001H0o`002000000?0?l002`00000203o0007000000L0o`00
9P0000070?l001h000005P3o0007000000l0o`00200000070?l000P000005P3o000?000000l0o`00
1`00000N0?l000L000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`050?ooo`l0o`001`00000F0?l000P000003`3o000/000000P0o`001`0000070?l002H000001`3o
000N000001H0o`001`00000?0?l000P000001`3o0008000001H0o`003`00000?0?l000L000007P3o
0007000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool7
0?l000l000001`3o0008000000L0o`007P00000F0?l000l00000203o000F000000L0o`005`00000>
0?l001h000007P3o000?000000L0o`003`0000080?l000h000003`3o000N000000L0o`003`000007
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o000?0000
00L0o`00200000070?l001h000005P3o000?000000P0o`005P0000070?l001L000003P3o000N0000
01h0o`003`0000070?l000l00000203o000>000000l0o`007P0000070?l000l000001`3oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`003`0000070?l000P0
00001`3o000N000001H0o`003`0000080?l001H000001`3o000G000000h0o`007P00000N0?l000l0
00001`3o000?000000P0o`003P00000?0?l001h000001`3o000?000000L0oooo00<000000?ooo`3o
ool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000l000001`3o0008000000L0o`00
7P00000F0?l000l00000203o000F000000L0o`005`00000>0?l001h000007P3o000?000000L0o`00
3`0000080?l000h000003`3o000N000000L0o`003`0000070?ooo`030000003oool0oooo01D0oooo
000F0?ooo`030000003oool0oooo00D0oooo1`3o000?000000L0o`00200000070?l001h000005P3o
000?000000P0o`005P0000070?l001L000003P3o000N000001h0o`003`0000070?l000l00000203o
000>000000l0o`007P0000070?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooo`L0o`003`0000070?l000P000001`3o000N000001H0o`003`000008
0?l001H000001`3o000G000000h0o`007P00000N0?l000l000001`3o000?000000P0o`003P00000?
0?l001h000001`3o000?000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool01@3oool70?l000l000001`3o0008000000L0o`007P00000F0?l000l00000203o000F0000
00L0o`005`00000>0?l001h000007P3o000?000000L0o`003`0000080?l000h000003`3o000N0000
00L0o`003`0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo1`3o000?000000L0o`00200000070?l001h000005P3o000?000000P0o`005P0000070?l001L0
00003P3o000N000001h0o`003`0000070?l000l00000203o000>000000l0o`007P0000070?l000l0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooaH0o`00
1`00000?0?l000P000005P3o000N000001d0o`00200000070?l000P000001`3o000?000001H0o`00
2000000/0?l000P00000;03o000?000000l0o`002000000>0?l000l000001`3oool00`000000oooo
0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooaH0o`001`00000?0?l000P000005P3o
000N000001d0o`00200000070?l000P000001`3o000?000001H0o`002000000/0?l000P00000;03o
000?000000l0o`002000000>0?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?oooaH0o`001`00000?0?l000P000005P3o000N000001d0o`0020000007
0?l000P000001`3o000?000001H0o`002000000/0?l000P00000;03o000?000000l0o`002000000>
0?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oo
oaH0o`001`00000?0?l000P000005P3o000N000001d0o`00200000070?l000P000001`3o000?0000
01H0o`002000000/0?l000P00000;03o000?000000l0o`002000000>0?l000l000001`3oool00`00
0000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oooaH0o`001`00000?0?l000P0
00005P3o000N000001d0o`00200000070?l000P000001`3o000?000001H0o`002000000/0?l000P0
0000;03o000?000000l0o`002000000>0?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`00
5P3oool00`000000oooo0?ooo`050?oooaH0o`001`00000?0?l000P000005P3o000N000001d0o`00
200000070?l000P000001`3o000?000001H0o`002000000/0?l000P00000;03o000?000000l0o`00
2000000>0?l000l000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?oo
o`050?oooaH0o`001`00000?0?l000P000005P3o000N000001d0o`00200000070?l000P000001`3o
000?000001H0o`002000000/0?l000P00000;03o000?000000l0o`002000000>0?l000l000001`3o
ool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`0020000007
0?l003@000003`3o000?000000L0o`005P00000?0?l000P000001`3o0008000001H0o`001`000008
0?l000L000003`3o000F000000l0o`003`0000080?l000L000003`3o0007000001L0o`007@000007
0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o00080000
00L0o`00=000000?0?l000l000001`3o000F000000l0o`00200000070?l000P000005P3o00070000
00P0o`001`00000?0?l001H000003`3o000?000000P0o`001`00000?0?l000L000005`3o000M0000
00L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P0
00001`3o000d000000l0o`003`0000070?l001H000003`3o0008000000L0o`002000000F0?l000L0
0000203o0007000000l0o`005P00000?0?l000l00000203o0007000000l0o`001`00000G0?l001d0
00001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`00
200000070?l003@000003`3o000?000000L0o`005P00000?0?l000P000001`3o0008000001H0o`00
1`0000080?l000L000003`3o000F000000l0o`003`0000080?l000L000003`3o0007000001L0o`00
7@0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o
0008000000L0o`00=000000?0?l000l000001`3o000F000000l0o`00200000070?l000P000005P3o
0007000000P0o`001`00000?0?l001H000003`3o000?000000P0o`001`00000?0?l000L000005`3o
000M000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool7
0?l000P000001`3o000d000000l0o`003`0000070?l001H000003`3o0008000000L0o`002000000F
0?l000L00000203o0007000000l0o`005P00000?0?l000l00000203o0007000000l0o`001`00000G
0?l001d000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?oo
o`L0o`00200000070?l003@000003`3o000?000000L0o`005P00000?0?l000P000001`3o00080000
01H0o`001`0000080?l000L000003`3o000F000000l0o`003`0000080?l000L000003`3o00070000
01L0o`007@0000070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0
oooo1`3o0008000000L0o`00=000000?0?l000l000001`3o000F000000l0o`00200000070?l000P0
00005P3o0007000000P0o`001`00000?0?l001H000003`3o000?000000P0o`001`00000?0?l000L0
00005`3o000M000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool0
1@3oool?000001H0o`001`00000N0?l001H00000203o000?000000h0o`003`00000G0?l001d00000
5`3o000F000001H0o`002000000?0?l000L000001`3o000G000001H0o`005P0000070?ooo`030000
003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`00000F0?l000L000007P3o
000F000000P0o`003`00000>0?l000l000005`3o000M000001L0o`005P00000F0?l000P000003`3o
0007000000L0o`005`00000F0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooo`l000005P3o0007000001h0o`005P0000080?l000l000003P3o000?
000001L0o`007@00000G0?l001H000005P3o0008000000l0o`001`0000070?l001L000005P3o000F
000000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?0000
01H0o`001`00000N0?l001H00000203o000?000000h0o`003`00000G0?l001d000005`3o000F0000
01H0o`002000000?0?l000L000001`3o000G000001H0o`005P0000070?ooo`030000003oool0oooo
01D0oooo000F0?ooo`030000003oool0oooo00D0oooo3`00000F0?l000L000007P3o000F000000P0
o`003`00000>0?l000l000005`3o000M000001L0o`005P00000F0?l000P000003`3o0007000000L0
o`005`00000F0?l001H000001`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo
0?ooo`050?ooo`l000005P3o0007000001h0o`005P0000080?l000l000003P3o000?000001L0o`00
7@00000G0?l001H000005P3o0008000000l0o`001`0000070?l001L000005P3o000F000000L0oooo
00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool?000001H0o`001`00
000N0?l001H00000203o000?000000h0o`003`00000G0?l001d000005`3o000F000001H0o`002000
000?0?l000L000001`3o000G000001H0o`005P0000070?ooo`030000003oool0oooo01D0oooo000F
0?ooo`030000003oool0oooo00D0oooo1`3o0008000000h0o`005`00000k0?l000P000001`3o0007
000000P0o`003`0000070?l000l000001`3o000G000000l0o`003P0000080?l000l000003`3o000?
000000L0o`001`00000?0?l000P000005P3o000?000000L0o`001`3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`002000000>0?l001L00000>`3o00080000
00L0o`001`0000080?l000l000001`3o000?000000L0o`005`00000?0?l000h00000203o000?0000
00l0o`003`0000070?l000L000003`3o0008000001H0o`003`0000070?l000L0oooo00<000000?oo
o`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool70?l000P000003P3o000G000003/0
o`00200000070?l000L00000203o000?000000L0o`003`0000070?l001L000003`3o000>000000P0
o`003`00000?0?l000l000001`3o0007000000l0o`002000000F0?l000l000001`3o00070?ooo`03
0000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo00D0oooo1`3o0008000000h0o`00
5`00000k0?l000P000001`3o0007000000P0o`003`0000070?l000l000001`3o000G000000l0o`00
3P0000080?l000l000003`3o000?000000L0o`001`00000?0?l000P000005P3o000?000000L0o`00
1`3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`050?ooo`L0o`002000
000>0?l001L00000>`3o0008000000L0o`001`0000080?l000l000001`3o000?000000L0o`005`00
000?0?l000h00000203o000?000000l0o`003`0000070?l000L000003`3o0008000001H0o`003`00
00070?l000L0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?ooo`3oool01@3oool7
0?l000P000003P3o000G000003/0o`00200000070?l000L00000203o000?000000L0o`003`000007
0?l001L000003`3o000>000000P0o`003`00000?0?l000l000001`3o0007000000l0o`002000000F
0?l000l000001`3o00070?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo
00D0oooo1`3o0008000000h0o`005`00000k0?l000P000001`3o0007000000P0o`003`0000070?l0
00l000001`3o000G000000l0o`003P0000080?l000l000003`3o000?000000L0o`001`00000?0?l0
00P000005P3o000?000000L0o`001`3oool00`000000oooo0?ooo`0E0?ooo`002`3oool01@3o_g@0
0000000000000000M;oo00H0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo
00<0oooo00D0okmd000000000000000007Boo`0=0?ooo`002`3oool01P2LB7@0_ooo0?ooo`3ookl0
M01d0;ooo`D0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo00<0oooo00H0
W4Qd0;ooo`3oool0oono07@0M02oool<0?ooo`002P3oool00`3o_g@007Bo0?ooo`020?ooo`030=nL
B018W=l0oooo00@0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003oool0oooo0080oooo
00<0okmd001d_`3oool00P3oool00`3OW4P0B9cO0?ooo`0;0?ooo`002P3oool00`3OW4P0B9cO0?oo
o`020?ooo`030?noM000M;l0oooo00@0oooo00<000000?ooo`3oool0o`3ooon00?ooo`030000003o
ool0oooo0080oooo00<0gia804RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0;0?ooo`002P3oool0
0`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00@0oooo1000003o0?ooog`0oooo10000004
0?ooo`030=nLB018W=l0oooo0080oooo00<0okmd001d_`3oool02`3oool000X0oooo00<0gia804RL
g`3oool00P3oool00`3o_g@007Bo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000B@3oool0
0`000000oooo0?ooo`170?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A`3oool0
0`000000oooo0?ooo`180?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool0
0`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo00/0oooo000:0?ooo`030?noM018W=l0oooo
0080oooo00<0gia804RLg`3oool0103oool01@000000oooo0?ooo`3oool0000004T0oooo00<00000
0?ooo`3oool0A`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo04L0oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0080oooo00<0okmd
04RLg`3oool00P3oool00`3OW4P0B9cO0?ooo`0;0?ooo`002`3oool01P2LB000M;oo0?ooo`3ogi`0
B01d0;ooo`D0oooo00D000000?ooo`3oool0oooo000000190?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`0609a8001d_ol0oooo0?oOW018
07@0_ooo303oool000/0oooo00D0oono07@000000000001809cOo`060?ooool00000Q00000050?oo
o`050?oo_`1d000000000000B02Lgol03@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool001P0oooo00D0okmd000000000000000007Boo`0o0?ooo`030?noM0000000000000<00000
00D007Bo0?ooo`3oool0oooo0?noM0030000000307Boo`3oool0oooo03P0oooo00<0oono07@00000
0000100000001@1d_ol0oooo0?ooo`3oool0okmd00<0000000<0M;oo0?ooo`3oool0>P3oool01@2o
M0000000000000000000B9cO00@0oooo00D0okmd000000000000000007Boo`0m0?ooo`050?oOW018
000000000000001d_ol00`3oool01@3o_g@00000000000000000M;oo03d0oooo00D0_g@000000000
0000000007Boo`040?ooo`050?noM000000000000000001d_ol0703oool001P0oooo00H0W4Qd0;oo
o`3oool0oono07@0M02ooom10?ooo`0309a8B02Lgol0oooo00@0oooo00H0W4Qd0;ooo`3oool0oono
07@0M02ooolj0?ooo`030;md000007@0_ooo0080oooo00<0giad09cOo`3oool00P3oool01P2LB7@0
_ooo0?ooo`3ookl0M01d0;ooocX0oooo00L0_g@0001d_`3oool0oooo0?oo_`1d0000B9cO00<0oooo
00H0W4Qd0;ooo`3oool0oono07@0M02oooln0?ooo`030;md001d_ol0oooo00<0oooo00H0W4Qd0;oo
o`3oool0oono07@0M02ooolk0?ooo`070;md0000M;l0oooo0?ooo`3ogi`0B00007Boo`030?ooo`06
09a8M02oool0oooo0?oo_`1d07@0_ooo6`3oool001L0oooo00<0okmd001d_`3oool00P3oool00`3O
W4P0B9cO0?ooo`100?ooo`0309a8B02Lgol0oooo00<0oooo00<0okmd001d_`3oool00P3oool00`3O
W4P0B9cO0?ooo`0j0?ooo`030?noM00004P0W=oo00D0oooo00<0okmd001d_`3oool00P3oool00`3O
W4P0B9cO0?ooo`0n0?ooo`060?noM000M;l0oooo0?ooo`3o_g@007Bo0`3oool00`3OW4P0B9cO0?oo
o`0m0?ooo`030;md001d_ol0oooo0080oooo00<0okmd001d_`3oool00P3oool00`3OW4P0B9cO0?oo
o`0o0?ooo`060?noM000M;l0oooo0?ooo`3o_g@007Bo0`3oool00`3OW4P0B9cO0?ooo`0J0?ooo`00
5`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo0400oooo00<0W4Q809cOo`3oool0
0`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03/0oooo00<0omnL04P00018W=l0
103oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03d0oooo00<0omnL04P0B02Lgol0
0P3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03T0oooo00<0gia8000000000000
0`0000001@1d_ol0oooo0?ooo`3OW4P0B9cO00<0oooo00<0okmd001d_`3oool0?`3oool01P3o_g@0
07Bo0?ooo`3oool0gia804RLg`<0oooo00<0okmd001d_`3oool06P3oool001L0oooo00<0gia804RL
g`3oool00P3oool00`3o_g@007Bo0?ooo`100?ooo`0309a8B02Lgol0oooo00<0oooo00<0gia804RL
g`3oool00P3oool00`3o_g@007Bo0?ooo`0m0?ooo`0309a80018W=l0oooo0080oooo00<0gia804RL
g`3oool00P3oool00`3o_g@007Bo0?ooo`0k0?ooo`040=nLB0000000001809cOo`<0oooo00<0gia8
04RLg`3oool00P3oool00`3o_g@007Bo0?ooo`0i0?ooo`060?noM00007@0_ooo0?ooo`2oM000M;oo
0`3oool00`3OW4P0B9cO0?ooo`020?ooo`030?noM000M;l0oooo03l0oooo00H0W4P007Boo`3oool0
oooo0=nLB018W=l30?ooo`030?noM000M;l0oooo01X0oooo000G0?ooo`030=nLB018W=l0oooo0080
oooo00<0okmd001d_`3oool0@03oool00`2LB4P0W=oo0?ooo`030?ooo`030=nLB018W=l0oooo0080
oooo00<0okmd001d_`3oool0?P3oool01P2LB7@0_ooo0?ooo`3oool0gia804RLg`<0oooo00<0okmd
001d_`3oool0?@3oool00`3ogi`0B01809cOo`020?ooo`030=nLB018W=l0oooo0080oooo00<0okmd
001d_`3oool0>P3oool01@3OW4P007Bo0?ooo`2oM000M;oo00<0oooo00<0gia804RLg`3oool00P3o
ool00`3o_g@007Bo0?ooo`0j0?ooo`030?oo_`1d000000000080000000H0B9cO0?ooo`3oool0oooo
0=nLB018W=l30?ooo`030?noM000M;l0oooo01X0oooo000G0?ooo`030?noM018W=l0oooo0080oooo
00<0gia804RLg`3oool0@03oool00`2LB4P0W=oo0?ooo`030?ooo`030?noM018W=l0oooo0080oooo
00<0gia804RLg`3oool0>@3oool00`3OW4P0M;oo0?ooo`020?ooo`060;md001d_ol0oooo0?ooo`3o
_g@0B9cO0`3oool00`3OW4P0B9cO0?ooo`0n0?ooo`060;md001d_ol0oooo0?ooo`3o_g@0B9cO0`3o
ool00`3OW4P0B9cO0?ooo`0k0?ooo`0409a80018W=l0_g@007Boo`<0oooo00<0okmd04RLg`3oool0
0P3oool00`3OW4P0B9cO0?ooo`0j0?ooo`030?oo_`1d07@0_ooo00H0oooo00<0okmd04RLg`3oool0
0P3oool00`3OW4P0B9cO0?ooo`0J0?ooo`00603oool01P2LB000M;oo0?ooo`3ogi`0B01d0;oooch0
oooo00D0gia800000000B9`0W4Q809cOo`050?ooo`0609a8001d_ol0oooo0?oOW01807@0_ooo>P3o
ool01`3o_g@0001d0;ooo`3oool0okmd0000B02Lgol00`3oool01P2LB000M;oo0?ooo`3ogi`0B01d
0;ooocX0oooo00L0okmd0000B02Lgol0oooo0?oOW01804P0W=oo00<0oooo00H0W4P007Boo`3oool0
omnL04P0M02oooll0?ooo`040?oOW01804P0B4P007Boo`@0oooo00H0W4P007Boo`3oool0omnL04P0
M02ooolk0?ooo`030?oo_`1d07@0_ooo00L0oooo00H0W4P007Boo`3oool0omnL04P0M02ooolK0?oo
o`00603oool01@3ookl0M0000000000004P0W=oo0440oooo00<0gia80000B02Lgol01@3oool01@3o
okl0M0000000000004P0W=oo03`0oooo00D0okmd000000000000001809cOo`040?ooo`050?oo_`1d
000000000000B02Lgol0?03oool01@3ogi`0B000000000000000M;oo00@0oooo00D0oono07@00000
0000001809cOo`0n0?ooo`030?noM0000000M;oo00@0oooo00D0oono07@000000000001809cOo`0l
0?ooo`030?oo_`1d000000000080000000<0001d0;ooo`3oool00P3oool01@3ookl0M00000000000
04P0W=oo01`0oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-3.57915, -54.5791, 0.202407, \
0.202407}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Import and Export of Matrices", "Section",
  CellTags->{"t:21", "c:30"}],

Cell["\<\
This section reviews the functions that are available for importing and \
exporting matrices.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Import[\"\>",
                      "MR"], 
                    StyleBox["\<\"file\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"format\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"import data in the specified format from \
a file"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Export[\"\>",
                      "MR"], 
                    StyleBox["\<\"file\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"mat\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"format\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"export matrix to a file, converting it to \
the specified format"\)]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S3.7.3"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides a number of different tools for input/output. If you want to \
save your data in a file so that later you or a colleague can continue to \
work with it in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you might want to use some of the functions that work with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions in files. These are discussed in the section ",
  ButtonBox["Expression Input and Output",
    ButtonData:>"t:118",
    ButtonStyle->"NotebookLink"],
  "."
}], "Text"],

Cell[TextData[{
  "If you want to work with matrices from a source external to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using specific data formats, the functions ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  " are useful. The ",
  StyleBox["Import", "MR"],
  " function supports a variety of different formats, some of which are \
relevant to matrices."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ImportFormats\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({"AIFF", "AU", "BMP", "CSV", "DICOM", "Dump", "DXF", "EPS", "EPSI", 
      "EPSTIFF", "Expression", "ExpressionML", "FITS", "GIF", 
      "HarwellBoeing", "HDF", "JPEG", "Lines", "List", "MAT", "MathML", 
      "MGF", "MPS", "MTX", "NB", "NotebookML", "PBM", "PGM", "PNG", "PNM", 
      "PPM", "SDTS", "SND", "STL", "SymbolicXML", "Table", "Text", "TIFF", 
      "TSV", "UnicodeText", "WAV", "Words", "XBitmap", "XML"}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Table", "MR"],
  " format will read tabular data into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This format is not specific to matrices and can process different types \
of information such as numbers, dates, and currencies. However, this is often \
a simple way to read in a matrix. This example displays a sample data file."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! LinearAlgebraExamples/Data/simplematrix.dat\)\)], "Input",
  CellLabel->"In[2]:="],

Cell["\<\
4.5 6.7
3.2 1.2\
\>", "Print",
  CellLabel->"From In[2]:="]
}, Open  ]],

Cell[TextData[{
  "Now the data file is read into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with the ",
  StyleBox["Import", "MR"],
  " command using a format of ",
  StyleBox["Table", "MR"],
  "; the result is a matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<LinearAlgebraExamples/Data/simplematrix.dat\>", \
"\<Table\>"]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({{4.5`, 6.7`}, {3.2`, 1.2`}}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Export", "MR"],
  " can be used to write out a matrix in some particular format. Here it uses \
the ",
  StyleBox["Table", "MR"],
  " format."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<fileout.dat\>", {{1, 2}, {3, 4}}, "\<Table\>"]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \("fileout.dat"\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! fileout.dat\)\)], "Input",
  CellLabel->"In[5]:="],

Cell["\<\
1   2
3   4\
\>", "Print",
  CellLabel->"From In[5]:="]
}, Open  ]],

Cell[TextData[{
  "This example shows how to write a matrix into a ",
  StyleBox["CSV", "MR"],
  " format. This could be read into another application such as a \
spreadsheet."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<filecsvout.dat\>", {{1, 2}, {3, 4}}, "\<CSV\>"]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \("filecsvout.dat"\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! filecsvout.dat\)\)], "Input",
  CellLabel->"In[7]:="],

Cell["\<\
1,2
3,4\
\>", "Print",
  CellLabel->"From In[7]:="]
}, Open  ]],

Cell[TextData[{
  "There are other matrix formats. For example, Harwell-Boeing, used for \
sparse matrices, and Matrix Market, used for both sparse and dense matrices. \
These are discussed in the section ",
  ButtonBox["Import and Export of Sparse Matrices",
    ButtonData:>"t:120",
    ButtonStyle->"NotebookLink"],
  ". In addition the MAT matrix format and the FITS astronomical data format \
can also be useful as import or export formats."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrix Multiplication", "Section",
  CellTags->{"t:24", "c:31"}],

Cell[TextData[{
  "Matrix multiplication (also called dot or inner product) is carried out in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with the function ",
  StyleBox["Dot", "MR"],
  ", typically entered with a dot short-hand syntax."
}], "Text"],

Cell[BoxData[
    \(\(mat = {{1, 2}, {3, 4}};\)\)], "Input",
  CellLabel->"In[1]:="],

Cell["\<\
This demonstrates matrix multiplication of a matrix with itself.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat . mat\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \({{7, 10}, {15, 22}}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["This multiplies a matrix with a vector.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat . {4, 5}\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \({14, 32}\)], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "The matrix product can be computed with two matrices of different sizes so \
long as they are compatible. For matrices this means that to multiply a ",
  Cell[BoxData[
      \(TraditionalForm\`m\_1\[Cross]n\_1\)]],
  "matrix by a ",
  Cell[BoxData[
      \(TraditionalForm\`m\_2\[Cross]n\_2\)]],
  "matrix, it is required that ",
  Cell[BoxData[
      \(TraditionalForm\`n\_1\)]],
  "is equal to ",
  Cell[BoxData[
      \(TraditionalForm\`m\_2\)]],
  ". Here, a 2\[Cross]3 matrix is multiplied by a 3\[Cross]2 matrix."
}], "Text"],

Cell[BoxData[{
    \(\(mat1 = {{1, 2, 3}, {4, 5, 6}};\)\), "\n", 
    \(\(mat2 = {{4, 1}, {5, 6}, {3, 1}};\)\)}], "InputOnly",
  CellLabel->"In[4]:="],

Cell["This will result in a 2x2 matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat1 . mat2\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({{23, 16}, {59, 40}}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell["This generates a 3x3 matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat2 . mat1\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({{8, 13, 18}, {29, 40, 51}, {7, 11, 15}}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["If the dimensions do not match, an error is generated.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat1 . {1, 2}\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    RowBox[{\(Dot::"dotsh"\), \(\(:\)\(\ \)\), "\<\"Tensors \\!\\({\\(\\({1, \
2, 3}\\)\\), \\(\\({4, 5, 6}\\)\\)}\\) and \\!\\({1, 2}\\) have incompatible \
shapes. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideNotebookLink\\\", ButtonFrame->None, \
ButtonData:>\\\"Dot::dotsh\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[8]:="],

Cell[BoxData[
    \({{1, 2, 3}, {4, 5, 6}} . {1, 2}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["Dot", "MR"],
  " can be used to multiply vectors of equal length; the result will be a \
scalar."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vec = {1, 2, 3};\)\), "\n", 
    \(vec . vec\)}], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(14\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell["\<\
Multiplication of a matrix by a vector works equivalently. This multiples a 2\
\[Cross]3 matrix by a length 3 vector.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat1 . vec\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \({14, 32}\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell["\<\
This multiples the length 3 vector by a 3\[Cross]2 matrix.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec . mat2\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \({23, 16}\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "The definition of matrix multiplication is such that the product ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " of two matrices ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`C\  \[LongEqual] \ A . B\)]],
  ", is given as below."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`c\_\(i\[VeryThinSpace]j\) \[LongEqual] \[Sum]\+k\( 
              a\_\(i\[VeryThinSpace]k\)\) 
          b\_\(k\[VeryThinSpace]j\)\)], "NumberedEquation",
  GridBoxOptions->{ColumnAlignments->{Left}}],

Cell[TextData[{
  "The definition generalizes, so that the product ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " of two arbitrary rank tensors ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  " is as follows."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`s\_\(\(\(\(i\)\(\[VeryThinSpace]\)\)\_1\) \(i\_2\) \
\[Ellipsis]\[VeryThinSpace]\(i\_\(m - 1\)\) \(j\_2\) \[Ellipsis]\
\[VeryThinSpace]j\_m\) \[LongEqual] \[Sum]\+k t\_\(\(i\_1\) \(i\_2\) \
\[Ellipsis]\[VeryThinSpace]i\_\(m - 1\)\[VeryThinSpace]k\)\ \ u\_\(k\
\[VeryThinSpace]\(j\_2\) \[Ellipsis]\[VeryThinSpace]j\_m\)\)], \
"NumberedEquation",
  GridBoxOptions->{ColumnAlignments->{Left}}],

Cell[TextData[{
  "Thus applying ",
  StyleBox["Dot", "MR"],
  " to a rank ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " tensor and a rank ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " tensor results in a rank ",
  Cell[BoxData[
      \(TraditionalForm\`n + m - 2\)]],
  " tensor. An example is shown below. First, a 2\[Cross]3\[Cross]4 tensor is \
defined."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(tensor1 = {\ {{1, 2, 3, 4}, {4, 5, 6, 7}, {4, 5, 6, 7}}, {{1, 2, 3, 
              9}, {1, 2, 6, 5}, {1, 2, 6, 5}}};\)\), "\n", 
    \(tensor1 // MatrixForm\)}], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"1"},
                    {"2"},
                    {"3"},
                    {"4"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"4"},
                    {"5"},
                    {"6"},
                    {"7"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"4"},
                    {"5"},
                    {"6"},
                    {"7"}
                    }], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"1"},
                    {"2"},
                    {"3"},
                    {"9"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"1"},
                    {"2"},
                    {"6"},
                    {"5"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"1"},
                    {"2"},
                    {"6"},
                    {"5"}
                    }], "\[NoBreak]", ")"}]}
            }], "\[NoBreak]", ")"}],
      MatrixForm[ {{{1, 2, 3, 4}, {4, 5, 6, 7}, {4, 5, 6, 7}}, {{1, 2, 3, 
        9}, {1, 2, 6, 5}, {1, 2, 6, 5}}}]]], "Output",
  CellLabel->"Out[14]//MatrixForm="]
}, Open  ]],

Cell["\<\
Now, a 4\[Cross]2\[Cross]1 tensor is defined.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(tensor2 = {\ {{1}, {4}}, {{7}, {1}}, {{8}, {3}}, {{9}, {1}}};\)\), "\n\
", 
    \(tensor2 // MatrixForm\)}], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"1"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"4"}
                    }], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"7"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"1"}
                    }], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"8"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"3"}
                    }], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"9"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"1"}
                    }], "\[NoBreak]", ")"}]}
            }], "\[NoBreak]", ")"}],
      MatrixForm[ {{{1}, {4}}, {{7}, {1}}, {{8}, {3}}, {{9}, {
        1}}}]]], "Output",
  CellLabel->"Out[16]//MatrixForm="]
}, Open  ]],

Cell[TextData[{
  "This multiplies ",
  StyleBox["tensor1", "MR"],
  " by ",
  StyleBox["tensor2", "MR"],
  ". They are compatible because the length of the innermost index of ",
  StyleBox["tensor1", "MR"],
  " equals the length of the outermost index of ",
  StyleBox["tensor2", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tensor1 . tensor2 // MatrixForm\)], "Input",
  CellLabel->"In[17]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"75"},
                    {"19"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"150"},
                    {"46"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"150"},
                    {"46"}
                    }], "\[NoBreak]", ")"}]},
            {
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"120"},
                    {"24"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"108"},
                    {"29"}
                    }], "\[NoBreak]", ")"}], 
              RowBox[{"(", "\[NoBreak]", GridBox[{
                    {"108"},
                    {"29"}
                    }], "\[NoBreak]", ")"}]}
            }], "\[NoBreak]", ")"}],
      MatrixForm[ {{{{75}, {19}}, {{150}, {46}}, {{150}, {46}}}, {{{120}, {
        24}}, {{108}, {29}}, {{108}, {29}}}}]]], "Output",
  CellLabel->"Out[17]//MatrixForm="]
}, Open  ]],

Cell["\<\
The result is a 2\[Cross]3\[Cross]2\[Cross]1 tensor.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[%]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \({2, 3, 2, 1}\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outer Product", "Subsection",
  CellTags->{"t:201", "c:32"}],

Cell[TextData[{
  "The outer product is a way to build a higher rank tensor from those of \
lower rank. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides this functionality with the function ",
  StyleBox["Outer", "MR"],
  ". One use of this is to combine two vectors to form a matrix as an outer \
product."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vec1 = {a, b, c};\)\), "\n", 
    \(\(vec2 = {x, y, z};\)\), "\n", 
    \(Outer[Times, vec1, vec2] // MatrixForm\)}], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(a\ x\), \(a\ y\), \(a\ z\)},
            {\(b\ x\), \(b\ y\), \(b\ z\)},
            {\(c\ x\), \(c\ y\), \(c\ z\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm="]
}, Open  ]],

Cell["\<\
The function that is used to combine corresponding elements is given as the \
first argument. It can be an unknown function as in the following example.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[f, {a, b, c}, {ap, bp}] // MatrixForm\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(f[a, ap]\), \(f[a, bp]\)},
            {\(f[b, ap]\), \(f[b, bp]\)},
            {\(f[c, ap]\), \(f[c, bp]\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization of the Outer Product", "Subsubsection",
  CellTags->{"t:202", "c:33"}],

Cell[TextData[{
  "One way to visualize the operation of ",
  StyleBox["Outer", "MR"],
  " is demonstrated in this example. First, a list of points is created."
}], "Text"],

Cell[BoxData[
    \(\(pts = Table[{Sin[t], Cos[t]}, {t, 0, 2  Pi, Pi/8. }];\)\)], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "This shows how ",
  StyleBox["Outer", "MR"],
  " joins each point to each other point."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[Graphics[Outer[Line[\ {##}] &, pts, pts, 1]], 
        AspectRatio \[Rule] Automatic];\)\)], "Input",
  CellLabel->"In[2]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.5 .97619 m
.5 .97619 L
s
.5 .97619 m
.68223 .93994 L
s
.5 .97619 m
.83672 .83672 L
s
.5 .97619 m
.93994 .68223 L
s
.5 .97619 m
.97619 .5 L
s
.5 .97619 m
.93994 .31777 L
s
.5 .97619 m
.83672 .16328 L
s
.5 .97619 m
.68223 .06006 L
s
.5 .97619 m
.5 .02381 L
s
.5 .97619 m
.31777 .06006 L
s
.5 .97619 m
.16328 .16328 L
s
.5 .97619 m
.06006 .31777 L
s
.5 .97619 m
.02381 .5 L
s
.5 .97619 m
.06006 .68223 L
s
.5 .97619 m
.16328 .83672 L
s
.5 .97619 m
.31777 .93994 L
s
.5 .97619 m
.5 .97619 L
s
.68223 .93994 m
.5 .97619 L
s
.68223 .93994 m
.68223 .93994 L
s
.68223 .93994 m
.83672 .83672 L
s
.68223 .93994 m
.93994 .68223 L
s
.68223 .93994 m
.97619 .5 L
s
.68223 .93994 m
.93994 .31777 L
s
.68223 .93994 m
.83672 .16328 L
s
.68223 .93994 m
.68223 .06006 L
s
.68223 .93994 m
.5 .02381 L
s
.68223 .93994 m
.31777 .06006 L
s
.68223 .93994 m
.16328 .16328 L
s
.68223 .93994 m
.06006 .31777 L
s
.68223 .93994 m
.02381 .5 L
s
.68223 .93994 m
.06006 .68223 L
s
.68223 .93994 m
.16328 .83672 L
s
.68223 .93994 m
.31777 .93994 L
s
.68223 .93994 m
.5 .97619 L
s
.83672 .83672 m
.5 .97619 L
s
.83672 .83672 m
.68223 .93994 L
s
.83672 .83672 m
.83672 .83672 L
s
.83672 .83672 m
.93994 .68223 L
s
.83672 .83672 m
.97619 .5 L
s
.83672 .83672 m
.93994 .31777 L
s
.83672 .83672 m
.83672 .16328 L
s
.83672 .83672 m
.68223 .06006 L
s
.83672 .83672 m
.5 .02381 L
s
.83672 .83672 m
.31777 .06006 L
s
.83672 .83672 m
.16328 .16328 L
s
.83672 .83672 m
.06006 .31777 L
s
.83672 .83672 m
.02381 .5 L
s
.83672 .83672 m
.06006 .68223 L
s
.83672 .83672 m
.16328 .83672 L
s
.83672 .83672 m
.31777 .93994 L
s
.83672 .83672 m
.5 .97619 L
s
.93994 .68223 m
.5 .97619 L
s
.93994 .68223 m
.68223 .93994 L
s
.93994 .68223 m
.83672 .83672 L
s
.93994 .68223 m
.93994 .68223 L
s
.93994 .68223 m
.97619 .5 L
s
.93994 .68223 m
.93994 .31777 L
s
.93994 .68223 m
.83672 .16328 L
s
.93994 .68223 m
.68223 .06006 L
s
.93994 .68223 m
.5 .02381 L
s
.93994 .68223 m
.31777 .06006 L
s
.93994 .68223 m
.16328 .16328 L
s
.93994 .68223 m
.06006 .31777 L
s
.93994 .68223 m
.02381 .5 L
s
.93994 .68223 m
.06006 .68223 L
s
.93994 .68223 m
.16328 .83672 L
s
.93994 .68223 m
.31777 .93994 L
s
.93994 .68223 m
.5 .97619 L
s
.97619 .5 m
.5 .97619 L
s
.97619 .5 m
.68223 .93994 L
s
.97619 .5 m
.83672 .83672 L
s
.97619 .5 m
.93994 .68223 L
s
.97619 .5 m
.97619 .5 L
s
.97619 .5 m
.93994 .31777 L
s
.97619 .5 m
.83672 .16328 L
s
.97619 .5 m
.68223 .06006 L
s
.97619 .5 m
.5 .02381 L
s
.97619 .5 m
.31777 .06006 L
s
.97619 .5 m
.16328 .16328 L
s
.97619 .5 m
.06006 .31777 L
s
.97619 .5 m
.02381 .5 L
s
.97619 .5 m
.06006 .68223 L
s
.97619 .5 m
.16328 .83672 L
s
.97619 .5 m
.31777 .93994 L
s
.97619 .5 m
.5 .97619 L
s
.93994 .31777 m
.5 .97619 L
s
.93994 .31777 m
.68223 .93994 L
s
.93994 .31777 m
.83672 .83672 L
s
.93994 .31777 m
.93994 .68223 L
s
.93994 .31777 m
.97619 .5 L
s
.93994 .31777 m
.93994 .31777 L
s
.93994 .31777 m
.83672 .16328 L
s
.93994 .31777 m
.68223 .06006 L
s
.93994 .31777 m
.5 .02381 L
s
.93994 .31777 m
.31777 .06006 L
s
.93994 .31777 m
.16328 .16328 L
s
.93994 .31777 m
.06006 .31777 L
s
.93994 .31777 m
.02381 .5 L
s
.93994 .31777 m
.06006 .68223 L
s
.93994 .31777 m
.16328 .83672 L
s
.93994 .31777 m
.31777 .93994 L
s
.93994 .31777 m
.5 .97619 L
s
.83672 .16328 m
.5 .97619 L
s
.83672 .16328 m
.68223 .93994 L
s
.83672 .16328 m
.83672 .83672 L
s
.83672 .16328 m
.93994 .68223 L
s
.83672 .16328 m
.97619 .5 L
s
.83672 .16328 m
.93994 .31777 L
s
.83672 .16328 m
.83672 .16328 L
s
.83672 .16328 m
.68223 .06006 L
s
.83672 .16328 m
.5 .02381 L
s
.83672 .16328 m
.31777 .06006 L
s
.83672 .16328 m
.16328 .16328 L
s
.83672 .16328 m
.06006 .31777 L
s
.83672 .16328 m
.02381 .5 L
s
.83672 .16328 m
.06006 .68223 L
s
.83672 .16328 m
.16328 .83672 L
s
.83672 .16328 m
.31777 .93994 L
s
.83672 .16328 m
.5 .97619 L
s
.68223 .06006 m
.5 .97619 L
s
.68223 .06006 m
.68223 .93994 L
s
.68223 .06006 m
.83672 .83672 L
s
.68223 .06006 m
.93994 .68223 L
s
.68223 .06006 m
.97619 .5 L
s
.68223 .06006 m
.93994 .31777 L
s
.68223 .06006 m
.83672 .16328 L
s
.68223 .06006 m
.68223 .06006 L
s
.68223 .06006 m
.5 .02381 L
s
.68223 .06006 m
.31777 .06006 L
s
.68223 .06006 m
.16328 .16328 L
s
.68223 .06006 m
.06006 .31777 L
s
.68223 .06006 m
.02381 .5 L
s
.68223 .06006 m
.06006 .68223 L
s
.68223 .06006 m
.16328 .83672 L
s
.68223 .06006 m
.31777 .93994 L
s
.68223 .06006 m
.5 .97619 L
s
.5 .02381 m
.5 .97619 L
s
.5 .02381 m
.68223 .93994 L
s
.5 .02381 m
.83672 .83672 L
s
.5 .02381 m
.93994 .68223 L
s
.5 .02381 m
.97619 .5 L
s
.5 .02381 m
.93994 .31777 L
s
.5 .02381 m
.83672 .16328 L
s
.5 .02381 m
.68223 .06006 L
s
.5 .02381 m
.5 .02381 L
s
.5 .02381 m
.31777 .06006 L
s
.5 .02381 m
.16328 .16328 L
s
.5 .02381 m
.06006 .31777 L
s
.5 .02381 m
.02381 .5 L
s
.5 .02381 m
.06006 .68223 L
s
.5 .02381 m
.16328 .83672 L
s
.5 .02381 m
.31777 .93994 L
s
.5 .02381 m
.5 .97619 L
s
.31777 .06006 m
.5 .97619 L
s
.31777 .06006 m
.68223 .93994 L
s
.31777 .06006 m
.83672 .83672 L
s
.31777 .06006 m
.93994 .68223 L
s
.31777 .06006 m
.97619 .5 L
s
.31777 .06006 m
.93994 .31777 L
s
.31777 .06006 m
.83672 .16328 L
s
.31777 .06006 m
.68223 .06006 L
s
.31777 .06006 m
.5 .02381 L
s
.31777 .06006 m
.31777 .06006 L
s
.31777 .06006 m
.16328 .16328 L
s
.31777 .06006 m
.06006 .31777 L
s
.31777 .06006 m
.02381 .5 L
s
.31777 .06006 m
.06006 .68223 L
s
.31777 .06006 m
.16328 .83672 L
s
.31777 .06006 m
.31777 .93994 L
s
.31777 .06006 m
.5 .97619 L
s
.16328 .16328 m
.5 .97619 L
s
.16328 .16328 m
.68223 .93994 L
s
.16328 .16328 m
.83672 .83672 L
s
.16328 .16328 m
.93994 .68223 L
s
.16328 .16328 m
.97619 .5 L
s
.16328 .16328 m
.93994 .31777 L
s
.16328 .16328 m
.83672 .16328 L
s
.16328 .16328 m
.68223 .06006 L
s
.16328 .16328 m
.5 .02381 L
s
.16328 .16328 m
.31777 .06006 L
s
.16328 .16328 m
.16328 .16328 L
s
.16328 .16328 m
.06006 .31777 L
s
.16328 .16328 m
.02381 .5 L
s
.16328 .16328 m
.06006 .68223 L
s
.16328 .16328 m
.16328 .83672 L
s
.16328 .16328 m
.31777 .93994 L
s
.16328 .16328 m
.5 .97619 L
s
.06006 .31777 m
.5 .97619 L
s
.06006 .31777 m
.68223 .93994 L
s
.06006 .31777 m
.83672 .83672 L
s
.06006 .31777 m
.93994 .68223 L
s
.06006 .31777 m
.97619 .5 L
s
.06006 .31777 m
.93994 .31777 L
s
.06006 .31777 m
.83672 .16328 L
s
.06006 .31777 m
.68223 .06006 L
s
.06006 .31777 m
.5 .02381 L
s
.06006 .31777 m
.31777 .06006 L
s
.06006 .31777 m
.16328 .16328 L
s
.06006 .31777 m
.06006 .31777 L
s
.06006 .31777 m
.02381 .5 L
s
.06006 .31777 m
.06006 .68223 L
s
.06006 .31777 m
.16328 .83672 L
s
.06006 .31777 m
.31777 .93994 L
s
.06006 .31777 m
.5 .97619 L
s
.02381 .5 m
.5 .97619 L
s
.02381 .5 m
.68223 .93994 L
s
.02381 .5 m
.83672 .83672 L
s
.02381 .5 m
.93994 .68223 L
s
.02381 .5 m
.97619 .5 L
s
.02381 .5 m
.93994 .31777 L
s
.02381 .5 m
.83672 .16328 L
s
.02381 .5 m
.68223 .06006 L
s
.02381 .5 m
.5 .02381 L
s
.02381 .5 m
.31777 .06006 L
s
.02381 .5 m
.16328 .16328 L
s
.02381 .5 m
.06006 .31777 L
s
.02381 .5 m
.02381 .5 L
s
.02381 .5 m
.06006 .68223 L
s
.02381 .5 m
.16328 .83672 L
s
.02381 .5 m
.31777 .93994 L
s
.02381 .5 m
.5 .97619 L
s
.06006 .68223 m
.5 .97619 L
s
.06006 .68223 m
.68223 .93994 L
s
.06006 .68223 m
.83672 .83672 L
s
.06006 .68223 m
.93994 .68223 L
s
.06006 .68223 m
.97619 .5 L
s
.06006 .68223 m
.93994 .31777 L
s
.06006 .68223 m
.83672 .16328 L
s
.06006 .68223 m
.68223 .06006 L
s
.06006 .68223 m
.5 .02381 L
s
.06006 .68223 m
.31777 .06006 L
s
.06006 .68223 m
.16328 .16328 L
s
.06006 .68223 m
.06006 .31777 L
s
.06006 .68223 m
.02381 .5 L
s
.06006 .68223 m
.06006 .68223 L
s
.06006 .68223 m
.16328 .83672 L
s
.06006 .68223 m
.31777 .93994 L
s
.06006 .68223 m
.5 .97619 L
s
.16328 .83672 m
.5 .97619 L
s
.16328 .83672 m
.68223 .93994 L
s
.16328 .83672 m
.83672 .83672 L
s
.16328 .83672 m
.93994 .68223 L
s
.16328 .83672 m
.97619 .5 L
s
.16328 .83672 m
.93994 .31777 L
s
.16328 .83672 m
.83672 .16328 L
s
.16328 .83672 m
.68223 .06006 L
s
.16328 .83672 m
.5 .02381 L
s
.16328 .83672 m
.31777 .06006 L
s
.16328 .83672 m
.16328 .16328 L
s
.16328 .83672 m
.06006 .31777 L
s
.16328 .83672 m
.02381 .5 L
s
.16328 .83672 m
.06006 .68223 L
s
.16328 .83672 m
.16328 .83672 L
s
.16328 .83672 m
.31777 .93994 L
s
.16328 .83672 m
.5 .97619 L
s
.31777 .93994 m
.5 .97619 L
s
.31777 .93994 m
.68223 .93994 L
s
.31777 .93994 m
.83672 .83672 L
s
.31777 .93994 m
.93994 .68223 L
s
.31777 .93994 m
.97619 .5 L
s
.31777 .93994 m
.93994 .31777 L
s
.31777 .93994 m
.83672 .16328 L
s
.31777 .93994 m
.68223 .06006 L
s
.31777 .93994 m
.5 .02381 L
s
.31777 .93994 m
.31777 .06006 L
s
.31777 .93994 m
.16328 .16328 L
s
.31777 .93994 m
.06006 .31777 L
s
.31777 .93994 m
.02381 .5 L
s
.31777 .93994 m
.06006 .68223 L
s
.31777 .93994 m
.16328 .83672 L
s
.31777 .93994 m
.31777 .93994 L
s
.31777 .93994 m
.5 .97619 L
s
.5 .97619 m
.5 .97619 L
s
.5 .97619 m
.68223 .93994 L
s
.5 .97619 m
.83672 .83672 L
s
.5 .97619 m
.93994 .68223 L
s
.5 .97619 m
.97619 .5 L
s
.5 .97619 m
.93994 .31777 L
s
.5 .97619 m
.83672 .16328 L
s
.5 .97619 m
.68223 .06006 L
s
.5 .97619 m
.5 .02381 L
s
.5 .97619 m
.31777 .06006 L
s
.5 .97619 m
.16328 .16328 L
s
.5 .97619 m
.06006 .31777 L
s
.5 .97619 m
.02381 .5 L
s
.5 .97619 m
.06006 .68223 L
s
.5 .97619 m
.16328 .83672 L
s
.5 .97619 m
.31777 .93994 L
s
.5 .97619 m
.5 .97619 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00e@3oool500000=H0oooo003@0?ooo`l00000d@3oool00<X0oooo1P0000000`3oool00000
0000000;000000030?ooo`000000000000@00000b`3oool00<D0oooo1@0000050?ooo`80000000<0
oooo0000000000002@0000000`3oool00000000000050?ooo`D00000aP3oool00<00oooo1@000008
0?ooo`8000000P3oool00`000000oooo00000008000000040?ooo`000000oooo0?ooo`800000203o
ool500000<40oooo002k0?ooo`D000002P3oool300000080oooo0P0000000`3oool000000?ooo`07
000000030?ooo`000000oooo008000000P3oool3000000X0oooo1@00002l0?ooo`00]@3oool60000
00d0oooo0P0000040?ooo`070000003oool0oooo0000003oool000000?ooo`05000000040?ooo`00
0000oooo00000080oooo00<000000?ooo`3oool00P3oool2000000d0oooo1P00002f0?ooo`00/03o
ool500000100oooo0`0000040?ooo`8000000P3oool01P000000oooo0000003oool000000?ooo`<0
000000H0oooo0000003oool000000?ooo`0000020?ooo`800000103oool300000100oooo1@00002a
0?ooo`00Z`3oool5000001<0oooo0P0000060?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1`000000oooo000000000000oooo0000003oool00P0000001@3oool000000?ooo`3oool0000000<0
oooo00<000000?ooo`3oool0103oool2000001<0oooo1@00002/0?ooo`00Y@3oool6000001H0oooo
0P0000060?ooo`8000000`3oool040000000oooo0?ooo`000000oooo0000003oool000000?ooo`00
0000oooo0000003oool000000?ooo`0000020?ooo`040000003oool0oooo0?ooo`8000001P3oool2
000001H0oooo1P00002V0?ooo`00X03oool5000001T0oooo0`0000070?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000000P3oool02@000000oooo0000003oool000000?ooo`000000
oooo000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01@3oool30000
01T0oooo1@00002Q0?ooo`00V`3oool5000001`0oooo0P0000080?ooo`800000103oool01`000000
oooo0?ooo`3oool000000?ooo`0000000P3oool01@000000oooo0000003oool000000080oooo00<0
00000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`800000203oool2000001`0oooo1@00
002L0?ooo`00UP3oool5000001h0oooo0`0000090?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`080000003oool0oooo0000003oool000000?ooo`0000020?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`07
0?ooo`<000007P3oool5000009L0oooo002@0?ooo`H000008@3oool2000000X0oooo0P0000050?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000020?ooo`060000003oool0
oooo0000003oool000000`3oool01@000000oooo0?ooo`3oool0000000D0oooo0P00000:0?ooo`80
00008@3oool600000940oooo002;0?ooo`D00000903oool3000000/0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`<00000903oool5000008`0oooo00280?oo
oil00000R@3oool008H0oooo2P00000P0?ooo`8000003@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`800000803oool:000008L0oooo0025
0?ooo`X0000000<0oooo0000000000000`00000H0?ooo`<000003@3oool2000000L0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool00000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`050?ooo`8000003@3oool3000001P0oooo1@0000000`3oool0000000000008000008H0
oooo00230?ooo`/0000000<0oooo000000000000103oool500000140oooo0P00000?0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00d0oooo0P00000A0?ooo`D00000103oool2000000030?ooo`000000000000T00000Q03oool00880
oooo00<000000?ooo`00000020000000103oool000000?ooo`3oool2000000L0oooo1@0000090?oo
o`<000003`3oool2000000P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo0P00
000?0?ooo`<000002@3oool5000000L0oooo0P0000020?ooo`030000003oool0000000P0000000<0
oooo0000003oool0PP3oool00800oooo0P0000000`3oool000000?ooo`07000000030?ooo`000000
oooo008000000P3oool3000000T0oooo1@0000020?ooo`8000004@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo
0P0000020?ooo`D000002@3oool300000080oooo0P0000000`3oool000000?ooo`07000000030?oo
o`000000oooo00800000P@3oool007l0oooo00L000000?ooo`3oool000000?ooo`000000oooo00D0
000000@0oooo0000003oool000000P3oool00`000000oooo0?ooo`020?ooo`800000303oool50000
00h0oooo0P0000090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`07
0?ooo`8000003P3oool5000000`0oooo0P0000040?ooo`070000003oool0oooo0000003oool00000
0?ooo`05000000040?ooo`000000oooo00000080oooo00<000000?ooo`3oool0OP3oool007h0oooo
00T000000?ooo`3oool000000?ooo`000000oooo0000003oool00`0000001P3oool000000?ooo`00
0000oooo00000080oooo0P0000040?ooo`<000001P3oool3000000D0oooo1@0000080?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01P3oool5000000D0oooo0`0000060?ooo`<00000103oool200000080
oooo00H000000?ooo`000000oooo0000003oool3000000060?ooo`000000oooo0000003oool00000
0P3oool00`000000oooo0?ooo`1m0?ooo`00O03oool200000080oooo00D000000?ooo`3oool00000
0?ooo`02000000030?ooo`000000oooo0080000000D0oooo0000003oool0oooo000000030?ooo`03
0000003oool0oooo00@0oooo0P0000020?ooo`8000003@3oool5000000030?ooo`000000000000X0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0
oooo0P0000000`3oool0000000000003000000d0oooo0P0000020?ooo`8000001P3oool01@000000
oooo0?ooo`3oool000000080oooo00L000000?ooo`00000000000?ooo`000000oooo0080000000D0
oooo0000003oool0oooo000000020?ooo`800000O@3oool007/0oooo00D000000?ooo`3oool0oooo
000000020?ooo`0=0000003oool000000?ooo`000000oooo0000003oool000000?ooo`000000oooo
000000020?ooo`040000003oool0oooo0?ooo`8000001@3oool4000001<0oooo1@0000070?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`D0
00004`3oool4000000D0oooo0P0000030?ooo`0@0000003oool0oooo0000003oool000000?ooo`00
0000oooo0000003oool000000?ooo`000000oooo00000080oooo00D000000?ooo`3oool0oooo0000
001l0?ooo`00N@3oool2000000<0oooo00@000000?ooo`3oool000000P3oool02@000000oooo0000
003oool000000?ooo`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00P0000040?ooo`8000003`3oool2000000D0oooo1@0000000`3oool000000?ooo`06
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000100000050?ooo`8000003`3oool2
000000@0oooo0P0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3o
ool02@000000oooo0000003oool000000?ooo`000000oooo000000020?ooo`040000003oool0oooo
000000<0oooo0P00001j0?ooo`00N03oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo
0?ooo`000000oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo
000000030?ooo`040000003oool0oooo0?ooo`<00000203oool2000000`0oooo00<000000?ooo`3o
ool02P3oool5000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool5000000`0oooo00<000000?ooo`3o
ool02P3oool2000000P0oooo0`0000030?ooo`070000003oool0oooo0?ooo`000000oooo00000002
0?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo000000030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0M`3oool007H0oooo0P0000040?ooo`050000003oool0
oooo0?ooo`0000000P3oool020000000oooo0?ooo`000000oooo0000003oool000000P3oool01000
0000oooo0?ooo`0000030?ooo`<000000`3oool00`000000oooo0?ooo`070?ooo`<000001`3oool2
000000`0oooo00<000000?ooo`3oool00`3oool5000000D0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`D000001@3oool00`000000oooo0?ooo`0:0?ooo`8000001`3oool3
000000T0oooo00@000000?ooo`3oool0oooo0`0000030?ooo`040000003oool0oooo00000080oooo
00D000000?ooo`000000oooo000000020?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool00P3oool2000007L0oooo001e0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool000000080oooo00H000000?ooo`3oool000000?ooo`00
00030?ooo`030000003oool00000008000001@3oool2000000X0oooo0P0000040?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`05000000D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo1@00
00020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`020?ooo`8000002P3oool2000000D0oooo0`0000000`3oool000000?ooo`020?ooo`030000003o
ool000000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`050000003oool0oooo0?oo
o`0000001@3oool00`000000oooo0?ooo`1d0?ooo`00L`3oool2000000D0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00D00000
0?ooo`3oool000000?ooo`03000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`090?ooo`@000003@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo1`00
00050?ooo`030000003oool0oooo00<0oooo1`0000060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool02`3oool4000000/0oooo00<000000?ooo`3oool0103oool010000000oooo0?oo
o`3oool3000000050?ooo`000000oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00`3oool2000007@0oooo001b0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0200000080oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`8000002P3oool010000000oooo0000
0000000;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`030?ooo`D0000000<0oooo0000003oool01@0000050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`80000000<0oooo0000003oool0
2@3oool2000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0200000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1a0?ooo`00L03oool2000000H0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?oo
o`3oool000000P3oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo0P0000040?ooo`800000203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0700000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool2000000@0oooo0P000007
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`3o
ool000000?ooo`<000000P3oool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`040?ooo`800000L@3oool006l0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`04000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0
oooo00D0oooo0P0000030?ooo`800000203oool3000000@0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo1@0000030?ooo`040000003oool0
oooo0?ooo`D00000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool00P3oool3000000P0oooo0P0000030?ooo`8000001`3oool00`000000oooo0?oo
o`030?ooo`050000003oool0oooo0?ooo`0000000`3oool400000080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`1^0?ooo`00K@3oool2000000L0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo00000080oooo0P0000030?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000003oool00000
00d0oooo0P0000000`3oool000000?ooo`090?ooo`030000003oool0oooo00D0oooo1P0000000`3o
ool000000?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000001@0000070?oo
o`030000003oool0oooo00P0oooo00@000000?ooo`00000000003@3oool00`000000oooo00000008
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
00030?ooo`8000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool01@3oool2000006h0oooo001/0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`<00000
00<0oooo0000003oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`050?ooo`<000003`3oool3000000P0oooo00<000000?ooo`3o
ool00P3oool5000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo1@0000040?ooo`030000003oool0oooo00H0oooo0`00000?0?ooo`<0
00001`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool00000008000000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1[0?oo
o`00JP3oool2000000P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`03
0000003oool00000008000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo0000000=0?ooo`040000003oool0oooo0?ooo`8000001P3oool5000000<0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`D000001P3oool2000000<0oooo00<0
00000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000
oooo0?ooo`3oool3000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`060?ooo`800000J`3oool006T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo0080oooo0`0000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`02000000D0oooo0P00000:0?ooo`030000003oool0oooo
00@0oooo1P0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool60000
00H0oooo00<000000?ooo`3oool0203oool2000000D0oooo0P0000020?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`03000000@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo06P0oooo001X0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`3oool3000000@0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`040?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo0080oooo100000020?ooo`8000002@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00L0oooo0P0000020?ooo`@00000103oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo0P0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool3000000<0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06L0oooo
001V0?ooo`8000002@3oool00`000000oooo0?ooo`050?ooo`@000000P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool3000000X0oooo0P0000050?ooo`H00000
1`3oool3000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`<00000
1`3oool6000000D0oooo0P00000:0?ooo`<000001@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool4000000L0oooo00<000000?ooo`3oool01`3oool2000006L0
oooo001U0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool2000000@0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`090?ooo`H000002`3oool010000000oooo0?ooo`3oool30000
00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool3000000<0oooo00<00000
0?ooo`3oool02@3oool6000000/0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`8000001`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06@0oooo001S0?ooo`8000002P3oool0
0`000000oooo0?ooo`040?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo0`0000050?ooo`030000003oool0oooo00@0oooo2000000<0?ooo`030000003oool0
oooo00D0oooo0`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`060?ooo`<000001`3oool00`000000oooo0?ooo`0:0?ooo`P000001P3oool0
0`000000oooo0?ooo`030?ooo`<000001P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo0P0000060?ooo`030000003oool0oooo00P0oooo0P00001T0?ooo`00HP3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo0`0000000`3oool000000?ooo`040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?oo
o`H000001P3oool2000000`0oooo00<000000?ooo`3oool01`3oool3000000H0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo0`0000090?oo
o`030000003oool0oooo00X0oooo0P0000060?ooo`H00000203oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020000
00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1Q0?ooo`00H03oool2000000/0
oooo00@000000?ooo`3oool0oooo0P0000030?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00`3oool010000000oooo0?ooo`3oool2000000030?ooo`000000oooo0080oooo1P000009
0?ooo`030000003oool0oooo008000002@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00800000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`07
0?ooo`8000000P3oool00`000000oooo0?ooo`070?ooo`H000000`3oool010000000oooo00000000
00030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool010000000oooo0?oo
o`3oool2000000<0oooo00<000000?ooo`3oool02@3oool200000640oooo001O0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`0000000P0000040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo000000020?ooo`D000001P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00<0oooo100000080?ooo`030000003oool0oooo00H0oooo1000
00050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool500000080oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo0`00
00000`3oool000000?ooo`0;0?ooo`030000003oool0oooo05h0oooo001M0?ooo`800000303oool3
000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`D000000P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool2
000000D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`8000001`3oool0
0`000000oooo0?ooo`050?ooo`800000203oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00<0oooo0P0000070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`05000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`<00000303oool2000005h0oooo001L0?ooo`030000003oool0oooo00/0oooo0P0000080?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00<0oooo1`0000070?ooo`030000003oool0oooo00L0oooo00D000000?oo
o`3oool0oooo0000000:0?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo0?oo
o`070?ooo`040000003oool00000000000D0oooo00<000000?ooo`3oool00`3oool2000000030?oo
o`000000oooo00P0oooo00<000000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000X0
oooo00D000000?ooo`3oool0oooo000000090?ooo`030000003oool0oooo00D0oooo1`0000050?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00H0oooo0P00000=0?ooo`030000003oool0oooo05/0oooo001J0?ooo`80
00002`3oool3000000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`000000100000020?ooo`8000000P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`000000303oool3000000/0
oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`3oool300000080oooo00<000000?oo
o`3oool00`0000030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool30000
00`0oooo00<000000?ooo`0000002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
008000000P3oool5000000030?ooo`000000oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo0`00000;0?ooo`800000F`3oool005T0
oooo00<000000?ooo`3oool02@3oool2000000030?ooo`000000oooo00T0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D00000103oool00`000000
oooo000000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`040?ooo`D000001P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00P3oool00`000000oooo000000040?ooo`D000000P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool010000000
oooo00000000000;0?ooo`030000003oool0oooo05P0oooo001G0?ooo`8000002@3oool300000080
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0
oooo1@0000030?ooo`030000003oool0oooo00<0oooo0P0000060?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000=0?ooo`040000003oool000000000
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo0P0000000`3oool000000?ooo`0<0?oo
o`030000003oool0000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`8000001@3oool010000000oooo0?ooo`3oool5000000D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00<000002@3oool2000005P0oooo001F0?oo
o`030000003oool0oooo00L0oooo0P0000040?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool01P3oool6000000030?ooo`000000oooo00D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo000000060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool200000080oooo00<00000
0?ooo`3oool00P0000050?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000
00060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0000
00040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000001@0000080?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool00P3oool2000000T0oooo00<000000?ooo`3oool0E@3o
ool005@0oooo0P0000070?ooo`<000001@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0080oooo1@0000060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P000002
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`03
0?ooo`800000103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<00000103oool0
0`000000oooo0?ooo`020?ooo`<000000P3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo0080oooo0P0000050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`D00000103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo0`000007
0?ooo`800000E@3oool005<0oooo00<000000?ooo`3oool01@3oool2000000L0oooo00<000000?oo
o`3oool02@3oool6000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0000000@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?oo
o`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00H0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`<000001`3oool00`000000oooo0?oo
o`050?ooo`<000002P3oool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000203oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000001P3oool00`000000
oooo0?ooo`050?ooo`040000003oool0oooo0?ooo`H000002`3oool00`000000oooo0?ooo`050?oo
o`8000001`3oool00`000000oooo0?ooo`1B0?ooo`00DP3oool00`000000oooo0?ooo`040?ooo`80
0000203oool00`000000oooo0?ooo`060?ooo`D00000203oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo0P0000050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo000000090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0203oool3000000X0oooo0P0000090?ooo`030000003oool0oooo00L0oooo0P00000:0?ooo`<0
00002P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`00
00002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo0P0000060?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool5000000P0oooo00<000000?ooo`3o
ool01P3oool2000000H0oooo00<000000?ooo`3oool0D@3oool00500oooo0P0000040?ooo`<00000
2@3oool00`000000oooo0?ooo`020?ooo`D000000`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool2000000L0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`060?ooo`8000002`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool4000000X0oooo00<000000?ooo`3oool0
203oool4000000L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00T0oooo0P0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1@3oool2000000D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`040000
003oool0oooo0?ooo`D00000103oool00`000000oooo0?ooo`070?ooo`<00000103oool200000540
oooo001?0?ooo`030000003oool0oooo0080oooo0P00000;0?ooo`H000001`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool2000000030?oo
o`000000oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`800000
303oool01@000000oooo0?ooo`3oool0000000d0oooo0`0000030?ooo`8000000`3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool0oooo0P0000030?oo
o`<000003@3oool01@000000oooo0?ooo`3oool0000000`0oooo0P0000080?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool010000000oooo0000000000040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`H000002`3o
ool2000000@0oooo00<000000?ooo`3oool0CP3oool004d0oooo0P0000020?ooo`<000002@3oool5
000000/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0103oool010000000oooo0?ooo`00000<0?ooo`030000003oool0000000d0oooo
00@000000?ooo`3oool0oooo0`0000050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`030?ooo`<000000`3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0000000`0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`090?ooo`D000002@3oool3
00000080oooo0P00001>0?ooo`00C03oool00`000000oooo0?ooo`02000000L0oooo1@0000020?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`040000003oool00000000000@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000=0?ooo`8000003@3o
ool01@000000oooo000000000000oooo008000001@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool2000000050?ooo`00000000000?ooo`00
00003@3oool2000000d0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`80000000<0oooo0000
003oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool01@0000070?ooo`8000000P3oool00`000000oooo0?ooo`1;0?ooo`00BP3oool200000003
0?ooo`000000000000@0oooo1@0000060?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`060?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00X0oooo0P00000<0?ooo`<000001@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo0`00000<0?ooo`800000303oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo0P0000080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`040?ooo`D00000103oool2000000030?ooo`000000000004/0
oooo00190?ooo`@0000000<0oooo0000000000000`00000:0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`8000001`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool000001`3oool00`000000
oooo0?ooo`080?ooo`040000003oool0oooo000000T0oooo0`0000080?ooo`80000000<0oooo0000
003oool02P3oool00`000000oooo0?ooo`090?ooo`040000003oool00000000000P0oooo0`000009
0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool01@3oool010000000oooo0?oo
o`0000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool2000000P0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo
1@0000000`3oool0000000000002000004X0oooo00170?ooo`L000003P3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool2000000P0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000P0oooo00<0
00000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000H0oooo0P0000020?ooo`030000
003oool0oooo00P0oooo0P00000;0?ooo`030000003oool0oooo00T0oooo0P00000:0?ooo`030000
003oool0oooo008000001P3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool2000000L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo1`0000180?ooo`00AP3ooooo000002@00000A`3oool004D0oooo2@00
000<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`030?ooo`050000003oool0oooo0?ooo`000000203oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00H0oooo0P00000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1@3oool2000000H0oooo00<000000?ooo`3oool02P3oool00`000000oooo000000090?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`000000303oool00`000000oooo0?ooo`040?ooo`800000
1`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo0P0000080?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000D0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0
oooo2@0000160?ooo`00A@3oool8000000030?ooo`000000000000<000001P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool0oooo0P0000040?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`04
0000003oool0oooo000000X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?oo
o`<0000000<0oooo0000003oool0103oool00`000000oooo0?ooo`0;0?ooo`040000003oool0oooo
000000P0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`00000=0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`0000000P0000040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0203oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`8000000`3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool5000000030?oo
o`000000000000H00000AP3oool004@0oooo200000000`3oool00000000000040?ooo`H000003`3o
ool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool20000
00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
0080oooo0P0000060?ooo`030000003oool0oooo00@0oooo0P0000040?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo00000005
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`0=0?ooo`H00000103o
ool2000000030?ooo`000000000000H00000A@3oool004<0oooo20000000103oool000000?ooo`3o
ool2000000H0oooo1P00000;0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`0000000000
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool0
00000P3oool2000000P0oooo00@000000?ooo`3oool000003@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00/0oooo00@000000?ooo`3oool00000203oool200000080oooo00@00000
0?ooo`3oool00000303oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0P00
00000`3oool000000?ooo`0:0?ooo`030000003oool0oooo00T0oooo1P0000060?ooo`8000000P3o
ool00`000000oooo00000007000004@0oooo00130?ooo`L0000000<0oooo0000003oool00P000002
0?ooo`<000000P3oool00`000000oooo0?ooo`040?ooo`D000001@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`07
0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00<000002`3oool00`000000oooo0000000=0?ooo`030000003oool0oooo00D0oooo0P00
00030?ooo`040000003oool0oooo0?ooo`8000001`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0000000/0oooo0`0000020?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool00`3oool5000000H0
oooo00<000000?ooo`3oool00`0000020?ooo`80000000<0oooo0000003oool01`0000140?ooo`00
@P3oool00`000000oooo00000004000000040?ooo`000000oooo00000080oooo00<000000?ooo`3o
ool00P3oool2000000`0oooo1@00000<0?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00L0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`0:0?oo
o`8000003`3oool2000000d0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool2000000l0oooo0P00000<
0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00L0oooo0P00000<0?ooo`D00000303oool2000000@0oooo00L0
00000?ooo`3oool000000?ooo`000000oooo00D0000000<0oooo0000003oool0@P3oool00440oooo
00@000000?ooo`000000oooo0`0000001P3oool000000?ooo`000000oooo00000080oooo0P000002
0?ooo`030000003oool00000008000003@3oool7000000D0oooo0P00000:0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01`3oool00`000000oooo000000090?ooo`030000003oool0
oooo00H0oooo1@00000?0?ooo`8000003@3oool00`000000oooo0?ooo`080?ooo`D000002P3oool0
0`000000oooo0?ooo`0;0?ooo`8000003`3oool5000000P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo000000090?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool2
000000D0oooo1`00000=0?ooo`<0000000@0oooo0000003oool0oooo0P0000020?ooo`060000003o
ool000000?ooo`000000oooo0`000000103oool000000?ooo`0000120?ooo`00@@3oool01`000000
oooo000000000000oooo0000003oool00P0000001@3oool000000?ooo`3oool0000000<0oooo0P00
00050?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`H000002`3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`040?ooo`8000000`3oool2000000l0oooo00<000000?ooo`0000002`3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0000
000?0?ooo`8000000`3oool2000000H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02@3oool6000000L0oooo00<0
00000?ooo`3oool0203oool2000000D0oooo0P0000030?ooo`050000003oool0oooo0000003oool0
0P0000000`3oool000000?ooo`02000000030?ooo`000000oooo0440oooo00100?ooo`0=0000003o
ool000000?ooo`000000oooo0000003oool000000?ooo`000000oooo000000020?ooo`030000003o
ool0oooo00<000001P3oool2000000L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`05000000H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`070?ooo`8000002P3o
ool010000000oooo0?ooo`3oool3000000@0oooo00@000000?ooo`3oool000003@3oool01@000000
oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool02@3oool5000000/0oooo00<000000?oo
o`3oool0203oool01@000000oooo0?ooo`3oool0000000d0oooo00@000000?ooo`3oool00000103o
ool3000000<0oooo00<000000?ooo`3oool0203oool2000000T0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`040?ooo`D000000P3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo0P0000060?ooo`<000000P3oool040000000oooo0?ooo`000000oooo0000003o
ool000000?ooo`000000oooo0000003oool000000?ooo`0000110?ooo`00?`3oool030000000oooo
0?ooo`000000oooo0000003oool000000?ooo`000000oooo00000080oooo00<000000?ooo`3oool0
0P0000030?ooo`030000003oool0oooo00D0oooo0`0000040?ooo`030000003oool0oooo00H0oooo
0P0000020?ooo`030000003oool0oooo00<0oooo1@0000000`3oool000000?ooo`090?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`0000002`3oool3000000H0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo0`00000;0?ooo`03
0000003oool0000000P0oooo00<000000?ooo`3oool0203oool00`000000oooo00000004000000D0
oooo00<000000?ooo`3oool00P0000080?ooo`030000003oool0oooo0080oooo0`0000070?ooo`04
0000003oool0oooo0?ooo`8000000P3oool030000000oooo0?ooo`000000oooo0000003oool00000
0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0?P3oool003h0oooo00@000000?ooo`3o
ool000000P3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`0000000P3oool2
000000@0oooo0P0000080?ooo`80000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00P0oooo1@0000070?ooo`030000003oool0oooo00D0oooo00@00000
0?ooo`3oool000002P3oool2000000L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`060?ooo`8000000`3oool010000000oooo0?ooo`3oool2000000P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`060?ooo`8000002P3oool010000000oooo0?ooo`0000070?ooo`03
0000003oool0oooo00D0oooo1@00000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool01P3oool010000000oooo0000000000080?ooo`800000103oool200000080oooo00<000000?oo
o`0000000P3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`000000@03oool0
03h0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0000003oool000000080oooo00<0
00000?ooo`3oool00P0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01`3o
ool3000000D0oooo0P0000040?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool0oooo
1@0000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000070?ooo`<0
00000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00`0000070?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`050000
00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`8000001@3oool30000
00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0200000080oooo00P000000?oo
o`3oool000000?ooo`000000oooo00000080oooo00@000000?ooo`3oool00000?`3oool003d0oooo
00L000000?ooo`3oool0oooo0000003oool000000080oooo00H000000?ooo`3oool000000?ooo`00
00020?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?oo
o`0200000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00H0oooo1@0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool2000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo0P0000060?ooo`030000003oool0oooo00@0oooo0P0000060?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`800000103o
ool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`D00000203oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P0000020?ooo`030000
003oool0oooo00D0oooo0P0000050?ooo`040000003oool0oooo0?ooo`8000000P3oool00`000000
oooo000000020?ooo`060000003oool0oooo0000003oool000000`3oool00`000000oooo0?ooo`0l
0?ooo`00?03oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`02000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo0P0000070?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`05000000@0oooo00<0
00000?ooo`0000000P0000080?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo000000080?ooo`<0
000000<0oooo0000003oool00`3oool500000080oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00D0oooo0P0000050?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`040000003oool000000000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo03/0oooo000l0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`040?ooo`8000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
00000`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`H000002`3oool01@000000oooo0?ooo`3oool0000000X0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`0000000`3o
ool2000000T0oooo00<000000?ooo`3oool01`3oool2000000<0oooo00D000000?ooo`3oool0oooo
0000000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool01@000000oooo
0?ooo`3oool0000000/0oooo1P0000030?ooo`050000003oool0oooo0?ooo`0000002`3oool00`00
0000oooo0?ooo`0:0?ooo`040000003oool0oooo0?ooo`<000000P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo008000001P3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool0>`3oool003/0oooo00D000000?ooo`3oool0oooo000000030?ooo`04
0000003oool0oooo00000080oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo000000030?ooo`8000001P3oool2
000000030?ooo`000000oooo00/0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`00
00050?ooo`T000001`3oool010000000oooo0?ooo`00000<0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool02P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`040000003oool0oooo
000000L0oooo2@0000050?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool02P3o
ool010000000oooo0000000000060?ooo`8000000`3oool00`000000oooo000000070?ooo`030000
003oool0oooo0080oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`000000?03oool003X0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`050?ooo`80
00000P3oool00`000000oooo0?ooo`080?ooo`<000002`3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0000000@0oooo0P0000030?ooo`030000003oool0oooo00<0oooo1@0000030?ooo`80
00003@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`00
00000P00000<0?ooo`030000003oool0oooo00X0oooo0`0000000`3oool000000?ooo`0=0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool02`3oool2000000<0oooo1@0000050?ooo`04
0000003oool0oooo0?ooo`800000103oool00`000000oooo0000000;0?ooo`030000003oool0oooo
00T0oooo0`00000:0?ooo`030000003oool0oooo008000001`3oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`0000000P3oool200000080oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03T0oooo000j0?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0200000080oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P00000;0?ooo`030000003oool0oooo008000002@3oool00`000000oooo0?oo
o`090?ooo`8000000`3oool2000000H0oooo00<000000?ooo`3oool01`3oool5000000h0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`8000003P3oool00`000000oooo0?oo
o`0<0?ooo`8000003`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo1@00
00090?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`8000002`3oool00`000000oooo0?oo
o`070?ooo`8000000P3oool00`000000oooo0?ooo`090?ooo`8000000P3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0200000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0>@3oool003T0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`040000003oool000000?oo
o`8000002P3oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0000000800000203oool00`000000oooo0?ooo`0:0?ooo`L000002P3oool01000
0000oooo0?ooo`00000?0?ooo`<000003P3oool00`000000oooo0?ooo`0<0?ooo`<000003`3oool0
10000000oooo0?ooo`00000:0?ooo`L00000303oool00`000000oooo0?ooo`060?ooo`<0000000<0
oooo0000003oool02`3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?oo
o`080?ooo`80000000@0oooo0000003oool00000103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000000`3oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0>03oool003P0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo0P0000020?ooo`050000003o
ool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<00000
103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo0P0000030?ooo`030000
003oool0oooo00T0oooo0`00000;0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`000000
1@3oool6000000@0oooo00@000000?ooo`3oool000003P3oool01@000000oooo0000003oool00000
00d0oooo00<000000?ooo`3oool02`3oool01@000000oooo0000003oool0000000h0oooo00@00000
0?ooo`3oool00000103oool6000000D0oooo00<000000?ooo`0000002`3oool00`000000oooo0?oo
o`090?ooo`<000002`3oool010000000oooo0?ooo`3oool2000000P0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`020?ooo`<000000P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000`3oool01@000000
oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0=`3oool003P0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool30000
00L0oooo0P0000060?ooo`030000003oool0oooo00P0oooo0P0000000`3oool000000?ooo`080?oo
o`@00000303oool00`000000oooo0?ooo`090?ooo`030000003oool0000000/0oooo1`00000=0?oo
o`8000000P3oool010000000oooo0?ooo`00000<0?ooo`030000003oool0oooo00X0oooo00@00000
0?ooo`3oool000000P3oool2000000d0oooo1`00000;0?ooo`030000003oool0000000/0oooo00<0
00000?ooo`3oool02P3oool4000000T0oooo00@000000?ooo`00000000002P3oool00`000000oooo
0?ooo`040?ooo`8000001`3oool3000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0=`3oool003L0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo008000000`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000X0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`<000001P3oool300000080oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`00
00003`3oool5000000T0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00/0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool01`3oool5000000l0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool00`0000060?ooo`<000003@3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo03H0oooo000f0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo000000@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo0P0000000`3oool000000?ooo`090?ooo`8000000P3oool00`000000oooo0?ooo`0<0?ooo`05
0000003oool000000000003oool00`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00h0oooo00@000000?ooo`3oool0oooo1@0000020?ooo`800000103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo0P0000020?ooo`D000000`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;
0?ooo`060000003oool0oooo0?ooo`000000oooo0`0000001@3oool000000000003oool0000000h0
oooo00<000000?ooo`3oool00P00000:0?ooo`040000003oool00000000000@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0=@3oool003H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`0000000P0000030?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`0000003@3oool010000000oooo0?ooo`3oool4000000030?ooo`000000oooo
00<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0303oool00`000000oooo000000070?ooo`D000000`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`D000001`3oool00`000000oooo0000000>
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`0000030?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`0000002`3oool010000000oooo0?ooo`3oool3000000030?ooo`00
0000oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`060000003o
ool0oooo0000003oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo03D0
oooo000e0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool2000000<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`090?ooo`8000003@3oool010000000
oooo0000000000040?ooo`800000103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`040000003oool0oooo
000000D0oooo0P0000040?ooo`D000001P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0103oool5000000@0oooo0P0000050?ooo`040000003oool0
oooo000000h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000000`3oool000000?oo
o`0<0?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?ooo`80
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03@0oooo000d0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`3oool300000003
0?ooo`000000oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0000000;0?ooo`<0
00001@3oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool01@000000
oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3oool00`000000oooo000000040000
0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0000000<0oooo0000003oool0203oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`000000303oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool00`3oool3
000000/0oooo00<000000?ooo`0000002P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
0000008000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0<`3oool003@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?oo
o`800000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00@00000
0?ooo`3oool0oooo0P0000070?ooo`80000000<0oooo0000003oool0103oool00`000000oooo0?oo
o`030?ooo`<000003@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`040000003oool00000000000X0oooo
00<000000?ooo`3oool0103oool5000000D0oooo00<000000?ooo`3oool00`3oool5000000H0oooo
00<000000?ooo`3oool0203oool2000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2`3oool3000000D0oooo00<000000?ooo`3oool00`3oool010000000oooo0000000000070?ooo`80
00000`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`800000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
03<0oooo000c0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool2000000D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`800000103oool2000000P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?oo
o`<000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo0`00000<0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`d000002`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool02P3oool3000000P0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool3
000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00H0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0<P3oool0
0380oooo00<000000?ooo`3oool01@3oool01`000000oooo0?ooo`3oool000000?ooo`0000001@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003o
ool0000000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`<000001@3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`00
00090?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0080oooo0`00000;0?ooo`030000003oool0oooo00X0oooo2`00000<0?ooo`030000
003oool0oooo00T0oooo0`0000040?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
2@3oool01@000000oooo0?ooo`3oool0000000T0oooo0`0000020?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`<000001`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`000000103oool2000000@0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0a0?ooo`00<P3oool00`000000oooo
0?ooo`050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0080000000<0oooo0000003oool00P3oool01@000000
oooo0?ooo`3oool0000000T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?oo
o`80000000<0oooo0000003oool0103oool01@000000oooo0?ooo`3oool0000000X0oooo00<00000
0?ooo`3oool00`3oool2000000L0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003o
ool0oooo00P0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01P3oool6000000<0oooo00@000000?ooo`3oool0oooo1P0000080?ooo`03
0000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000000L0oooo0P000005
0?ooo`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo000000050?ooo`040000003o
ool00000000000H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`050000
003oool0oooo0?ooo`0000000`3oool010000000oooo0000000000020?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0<@3oool00340oooo00<000000?ooo`3oool01@3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo000000040?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo0`0000040?ooo`8000000`3oool010000000oooo
0?ooo`00000;0?ooo`030000003oool0oooo00D0oooo0`0000040?ooo`040000003oool0oooo0000
00d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`02000000D0oooo00<000000?oo
o`3oool01`3oool010000000oooo0?ooo`3oool5000000H0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`040?ooo`D000000`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00<0oooo0P0000020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02`3o
ool010000000oooo0?ooo`0000040?ooo`<000001`3oool00`000000oooo0?ooo`090?ooo`040000
003oool0oooo000000<0oooo0P0000040?ooo`<000000`3oool01@000000oooo0?ooo`3oool00000
00T0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0`0?ooo`00<03oool00`000000oooo0?ooo`06
0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`8000001@3oool00`000000oooo000000050?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`0000000P3oool2000000T0oooo00H000000?ooo`3oool000000?ooo`00000<0?ooo`030000
003oool0oooo00P0oooo0P0000020?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo000000070?ooo`030000003oool0oooo00H0oooo1@00000<0?ooo`050000
003oool000000?ooo`000000303oool5000000P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo000000080?ooo`030000003oool0oooo00`0oooo00<000000?ooo`0000000P3oool2000000X0
oooo00<000000?ooo`3oool02P3oool00`000000oooo000000020?ooo`030000003oool0oooo00L0
oooo0P0000020?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool00`3oool00`000000
oooo000000050?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`0_0?ooo`00;`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`020?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`080?ooo`@00000303oool4000000d0oooo00<000000?ooo`3oool02P3oool2000000030?oo
o`000000000000h0oooo00<000000?ooo`3oool01@3oool3000000T0oooo00<000000?ooo`000000
1P00000A0?ooo`<000004@3oool7000000030?ooo`000000oooo00P0oooo0`0000070?ooo`030000
003oool0oooo00`0oooo0P0000000`3oool000000000000<0?ooo`030000003oool0oooo00/0oooo
1000000<0?ooo`@000002P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo
00<000000?ooo`0000001`3oool00`000000oooo0?ooo`0_0?ooo`00;`3oool00`000000oooo0?oo
o`060?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo008000000P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3o
ool3000000l0oooo0P00000>0?ooo`030000003oool0oooo00`0oooo0`00000?0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01P3oool5000000H0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00@0oooo1@0000080?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool03@3oool3000000h0oooo00<000000?ooo`3oool0303o
ool2000000l0oooo0`0000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`030?ooo`800000203oool00`000000oooo0?ooo`0^0?ooo`00;P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool3000000@0oooo00<00000
0?ooo`3oool00`3oool2000000P0oooo00<000000?ooo`3oool00`3oool3000000040?ooo`000000
oooo000000h0oooo00@000000?ooo`0000000000303oool00`000000oooo0?ooo`0<0?ooo`800000
00<0oooo0000000000003@3oool00`000000oooo0?ooo`020?ooo`<000000`3oool5000000@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0?0?ooo`<000004@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0080oooo1@0000030?ooo`<00000103oool00`000000oooo
0?ooo`0;0?ooo`80000000<0oooo0000000000003P3oool00`000000oooo0?ooo`0:0?ooo`800000
00<0oooo0000003oool03@3oool010000000oooo0000003oool3000000D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo000000050?ooo`030000003oool0oooo0080oooo0`0000060?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0]0?ooo`00
;@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0?ooo`02000000@0oooo00@000000?ooo`3oool00000303oool20000
00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0<0?ooo`8000000`3oool30000
00/0oooo00D000000?ooo`3oool000000?ooo`05000000X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0>0?ooo`050000003oool000000?ooo`000000403oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00P0oooo1@0000001@3oool000000?ooo`3oool0000000/0oooo
0`0000030?ooo`8000003P3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo0?ooo`80
0000303oool010000000oooo0?ooo`0000040?ooo`8000000P3oool00`000000oooo0?ooo`060?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0/
0?ooo`00;@3oool00`000000oooo0?ooo`060?ooo`8000001`3oool00`000000oooo0?ooo`020?oo
o`<000001P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000T0oooo0P000005
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0203oool00`000000oooo00000004
0?ooo`8000002@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0000000H0oooo0P000009
0?ooo`H000003`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00d0oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool03@3oool6000000T0oooo0P0000060?ooo`030000003oool0000000d0oooo00<0
00000?ooo`3oool01`3oool2000000@0oooo00<000000?ooo`0000002P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo0P0000090?ooo`040000003oool0oooo000000@0oooo
00<000000?ooo`3oool0103oool3000000@0oooo00<000000?ooo`3oool01@3oool2000000P0oooo
00<000000?ooo`3oool0;03oool002`0oooo00<000000?ooo`3oool01P3oool2000000L0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000060?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`@000001P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00H0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo000000070?ooo`8000000P3oool7
00000080oooo00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool0000000l0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00d0oooo00D000000?ooo`3oool0
oooo0000000@0?ooo`030000003oool0oooo00L000000P3oool2000000L0oooo00D000000?ooo`3o
ool0oooo0000000<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool01000
0000oooo0?ooo`0000080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool4
000000D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000H0oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`050?ooo`800000203oool00`000000oooo
0?ooo`0[0?ooo`00:`3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000L0oooo00<0
00000?ooo`3oool00P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000001@3o
ool010000000oooo0?ooo`3oool2000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool00000203oool2000000H0
oooo00<000000?ooo`3oool02P3oool01@000000oooo0?ooo`3oool0000000H0oooo1P0000020?oo
o`80000000D0oooo0000003oool0oooo0000000A0?ooo`040000003oool0oooo000000h0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00`0oooo00@0
00000?ooo`3oool000004@3oool01@000000oooo0?ooo`000000oooo008000000P3oool6000000H0
oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00@0oooo0P0000080?oo
o`040000003oool0oooo000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo0P0000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000001`3oool010000000oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo000000080?ooo`030000003oool0ooo