(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    102098,       3011]*)
(*NotebookOutlinePosition[    368094,      12107]*)
(*  CellTagsIndexPosition[    368009,      12101]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Linear Algebra in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Chapter",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  "1.",
  ButtonBox[" Introduction ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:1"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Tensors and Arrays",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:2"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:2"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrices as ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox["Expressions",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:3"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Expression Input and Output",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:4"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:4"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Design Principles of ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:5"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:5"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:5"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.",
  ButtonBox[" Matrix and Tensor Operations ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:6"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Building Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:7"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:7"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Special Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:8"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:8"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:9"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:9"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Getting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:10"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:10"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Getting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:11"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:11"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Setting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:12"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:12"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Setting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:13"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:13"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[ButtonBox["Extracting Submatrices",
  ButtonData:>{
    FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", "RefGuide",
       "AdvancedDocumentation", "LinearAlgebra"}, "LinearAlgebra.nb"], 
    "c:14"},
  ButtonStyle->"PageLink"]], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Deleting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:15"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:15"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Inserting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:16"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:16"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Extending Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:17"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:17"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Transpose",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:18"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:18"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Rotating Elements",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:19"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:19"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Testing Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:20"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:20"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Further Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:21"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:21"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Element-wise Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:22"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:22"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Listability",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:23"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:23"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Map",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:24"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:24"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Vectors and Tensors",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:25"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:25"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Testing Vectors and Tensors",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:26"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:26"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Visualization of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:27"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:27"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Formatting Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:28"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:28"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Plotting Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:29"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:29"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Import and Export of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:30"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:30"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Multiplication",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:31"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:31"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Outer Product",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:32"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:32"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Visualization of the Outer Product",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:33"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:33"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Generalized Inner Product",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:34"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:34"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Permutations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:35"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:35"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Permutation Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:36"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:36"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "3.",
  ButtonBox[" Sparse Arrays ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:37"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Basic Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:38"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:38"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["SparseArray",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:39"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:39"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Rule Inputs for SparseArray",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:40"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:40"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Identity and Diagonal Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:41"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:41"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Normal",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:42"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:42"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["ArrayRules",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:43"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:43"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:44"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:44"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Getting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:45"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:45"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Getting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:46"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:46"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Setting Pieces of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:47"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:47"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Setting Multiple Pieces",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:48"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:48"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[ButtonBox["Extracting Submatrices ",
  ButtonData:>{
    FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", "RefGuide",
       "AdvancedDocumentation", "LinearAlgebra"}, "LinearAlgebra.nb"], 
    "c:49"},
  ButtonStyle->"PageLink"]], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Deleting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:50"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:50"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Inserting Rows and Columns",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:51"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:51"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Extending Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:52"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:52"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Transpose",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:53"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:53"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Rotating Elements",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:54"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:54"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Testing Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:55"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:55"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Further Structural Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:56"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:56"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Element-wise Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:57"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:57"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Listability",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:58"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:58"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Map",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:59"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:59"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Visualization of Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:60"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:60"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Formatting Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:61"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:61"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Plotting Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:62"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:62"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Import and Export of Sparse Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:63"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:63"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Multiplication",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:64"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:64"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Outer Product",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:65"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:65"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Matrix Permutations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:66"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:66"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Converting Equations to Sparse Arrays",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:67"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:67"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["SparseArray Data Format",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:68"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:68"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "4.",
  ButtonBox[" Matrix Computations ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:69"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Basic Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:70"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:70"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Norms",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:71"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:71"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Vector Norms",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:72"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:72"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Matrix Norms",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:73"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:73"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["NullSpace",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:74"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:74"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Rank",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:75"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:75"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Row Echelon Form",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:76"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:76"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Inverse",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:77"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:77"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["PseudoInverse",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:78"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:78"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Determinant",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:79"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:79"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Minors",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:80"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:80"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Solving Linear Systems",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:81"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:81"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Singular Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:82"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:82"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Homogeneous Equations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:83"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:83"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Estimating and Calculating Accuracy",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:84"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:84"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Symbolic and Exact Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:85"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:85"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Row Reduction",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:86"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:86"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Saving the Factorization",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:87"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:87"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Methods",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:88"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:88"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["LAPACK",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:89"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:89"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Multifrontal",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:90"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:90"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Krylov",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:91"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:91"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Cholesky",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:92"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:92"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Symbolic Methods",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:93"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:93"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Least Squares Solutions",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:94"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:94"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Data Fitting",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:95"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:95"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Eigensystem Computations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:96"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:96"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Eigensystem Properties",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:97"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:97"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Diagonalizing a Matrix",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:98"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:98"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Symbolic and Exact Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:99"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:99"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Generalized Eigenvalues",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:100"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:100"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Methods",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:101"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:101"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["LAPACK",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:102"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:102"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Arnoldi",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:103"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:103"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Symbolic Methods",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:104"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:104"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Decompositions",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:105"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:105"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["LU Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:106"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:106"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Cholesky Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:107"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:107"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[ButtonBox["Cholesky and LU Factorizations ",
  ButtonData:>{
    FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", "RefGuide",
       "AdvancedDocumentation", "LinearAlgebra"}, "LinearAlgebra.nb"], 
    "c:108"},
  ButtonStyle->"PageLink"]], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Gram-Schmidt Orthogonalization",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:109"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:109"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["QR Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:110"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:110"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Solving Systems of Equations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:111"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:111"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Singular Value Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:112"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:112"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Generalized Singular Values",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:113"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:113"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Options",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:114"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:114"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Schur Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:115"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:115"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Generalized Schur Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:116"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:116"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Options",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:117"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:117"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Jordan Decomposition",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:118"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:118"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Functions of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:119"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:119"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "5.",
  ButtonBox[" Matrix Types ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:120"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Numbers in ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:121"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:121"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:121"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Exact versus Approximate Numbers",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:122"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:122"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Mixed Mode Arithmetic",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:123"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:123"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrices in ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:124"},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:124"},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:124"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Standard Numerical Techniques",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:125"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:125"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Extended Precision Numerical Techniques",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:126"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:126"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Symbolic Algebra Techniques",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:127"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:127"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Mixed Mode Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:128"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:128"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Complex Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:129"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:129"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Arbitrary-Precision Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:130"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:130"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.",
  ButtonBox[" Performance ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:131"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Packed Arrays",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:132"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:132"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Packed Array Functions",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:133"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:133"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Packed Array Operations",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:134"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:134"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Packed Array Summary",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:135"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:135"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Programming Efficiency",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:136"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:136"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Measuring Performance",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:137"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:137"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Vectorizing Loops",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:138"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:138"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["List Creation",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:139"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:139"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["List Updating",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:140"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:140"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Using Built-in Support",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:141"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:141"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["A Slow Way",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:142"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:142"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["A Faster Way",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:143"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:143"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Also Fast but Neater",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:144"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:144"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Matrix Contents",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:145"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:145"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Mixed Symbolic/Numeric Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:146"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:146"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Mixed Numerical Type Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:147"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:147"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Integer Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:148"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:148"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Expression Efficiency",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:149"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:149"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Updating of Matrices",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:150"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:150"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[ButtonBox["Appending to Matrices ",
  ButtonData:>{
    FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", "RefGuide",
       "AdvancedDocumentation", "LinearAlgebra"}, "LinearAlgebra.nb"], 
    "c:151"},
  ButtonStyle->"PageLink"]], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.",
  ButtonBox[" Examples ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:152"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Matrix Ordering",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:153"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:153"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Full Rank Least Squares Solutions",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:154"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:154"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Least Squares Cholesky",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:155"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:155"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Least Squares QR",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:156"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:156"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Minimization of 1 and Infinity Norms",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:157"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:157"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["One-Norm Minimization",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:158"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:158"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Infinity-Norm Minimization",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:159"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:159"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Finite Difference Solutions",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:160"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:160"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Mesh Partitioning",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:161"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:161"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Data",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:162"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:162"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Plotting the Mesh",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:163"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:163"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["The Laplacian",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:164"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:164"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["The Fiedler Vector",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:165"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:165"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Partitioning the Nodes",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:166"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:166"},
    ButtonStyle->"PageLink"]
}], "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["Matrix Functions with NDSolve",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:167"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:167"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "8.",
  ButtonBox[" Appendix ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:168"},
    ButtonStyle->"PageLink"]
}], "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Software References",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:169"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:169"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["ARPACK",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:170"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:170"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["ATLAS",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:171"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:171"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Harwell-Boeing",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:172"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:172"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["Matrix Market",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:173"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:173"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["METIS",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:174"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:174"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["TAUCS",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:175"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:175"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[TextData[{
  ButtonBox["UMFPACK",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:176"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:176"},
    ButtonStyle->"PageLink"]
}], "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[TextData[{
  ButtonBox["References",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:177"},
    ButtonStyle->"PageLink"],
  ButtonBox[" ",
    ButtonData:>{
      FrontEnd`FileName[ {$TopDirectory, "Documentation", "English", 
        "RefGuide", "AdvancedDocumentation", "LinearAlgebra"}, 
        "LinearAlgebra.nb"], "c:177"},
    ButtonStyle->"PageLink"]
}], "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{31, 1280}, {0, 1002}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{570, 598},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions for On-line Help", "Subtitle"],
  
  Cell["\<\
These styles are carefully tuned for all aspects of the online \
help. It's recommended that they remain unchanged.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Brackets"],
    PageWidth->WindowWidth,
    ShowCellBracket->True,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "SlideShow"],
    PageWidth->WindowWidth,
    ScrollingOptions->{"PagewiseDisplay"->True},
    ShowCellBracket->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ShowAutoStyles->False,
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintout"],
    PageWidth->PaperWidth,
    ShowCellBracket->True,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintoutNonGray"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True},
    CellLabelAutoDelete->False,
    CellFrameLabelMargins->6,
    StyleMenuListing->None],
  
  Cell[StyleData["Notebook", "Printout"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True}],
  
  Cell[StyleData["Notebook", "EnhancedPrintout"],
    PageFooters->{{None, None, None}, {None, None, None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{False, False},
    PrintingOptions->{"PrintingMargins"->{{54, 54}, {36, 72}},
    "PageSize"->{594, 657},
    "PrintRegistrationMarks"->True,
    "FirstPageHeader"->False,
    "FacingPages"->True,
    "FirstPageFace"->Right}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Chapter"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{27, 27}, {10, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Plain",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Chapter", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["Chapter", "Printout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontSize->24],
  
  Cell[StyleData["Chapter", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Chapter", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellMargins->{{27, 27}, {12, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Section", "Presentation"],
    FontSize->30],
  
  Cell[StyleData["Section", "SlideShow"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {5, 0}},
    PageBreakBelow->False,
    CellFrameMargins->{{36, 36}, {Inherited, 15}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["Section", "EnhancedPrintout"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, 2}, {5, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Section", "EnhancedPrintoutNonGray"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CellFrameLabelMargins->6,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Subsection", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Subsection", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{2, 0}, {5, 24}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {5, 20}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Subsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionColor"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.297993, 0, 0.454994]],
  
  Cell[StyleData["SubsubsectionColor", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionColor", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{46, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->8},
    CellGroupingRules->{"SectionGrouping", 40},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsectionIcon", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubsectionIcon", "Printout"],
    CellDingbat->"\[FilledSquare]",
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{65, 27}, {0, 8}},
    CellElementSpacings->{"ClosedGroupTopMargin"->4},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsubsectionIcon", "Presentation"],
    CellMargins->{{65, Inherited}, {Inherited, Inherited}},
    FontSize->18],
  
  Cell[StyleData["SubsubsectionIcon", "Printout"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{27, 27}, {0, 8}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    ParagraphSpacing->{0, 8},
    FontSize->12],
  
  Cell[StyleData["Text", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Text", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Hyphenation->False,
    FontSize->14],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CompactText"],
    CellMargins->{{27, 27}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["CompactText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CompactText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Compact12Text"],
    CellMargins->{{27, 27}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None],
  
  Cell[StyleData["Compact12Text", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Compact12Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextSans"],
    CellMargins->{{27, 27}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["TextSans", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["TextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Frutiger 55 Roman",
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Frutiger 55 Roman",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedText"],
    CellMargins->{{66, 4}, {4, 4}},
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedText", "Printout"],
    CellMargins->{{16, 4}, {2, 4}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintout"],
    CellMargins->{{16, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    ParagraphIndent->-18,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote"],
    CellMargins->{{88, 4}, {4, 0}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndentedText"],
    CellMargins->{{66, 4}, {0, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["IndentedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndentedText", "SlideShow"],
    CellMargins->{{80, 24}, {5, 5}},
    Hyphenation->False,
    FontSize->13],
  
  Cell[StyleData["IndentedText", "Printout"],
    CellMargins->{{16, 4}, {2, 4}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["IndentedText", "EnhancedPrintout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["IndentedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedList"],
    CellMargins->{{58, 4}, {4, 4}},
    CellFrameLabels->{{Cell[ 
            TextData[ {
              StyleBox[ 
                CounterBox[ "ItemizedList"], "TB"], 
              StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {
            24, Inherited}, TextAlignment -> Right], Inherited}, {
        Inherited, Inherited}},
    LineSpacing->{1, 3},
    CounterIncrements->"ItemizedList",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedList", "Printout"],
    CellMargins->{{9, 4}, {2, 4}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedList", "EnhancedPrintout"],
    CellMargins->{{9, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedSubList"],
    CellMargins->{{92, 4}, {4, 4}},
    CellFrameLabels->{{Cell[ 
            TextData[ {
              StyleBox[ 
                CounterBox[ "ItemizedSubList"], "TB"], 
              StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {
            24, Inherited}, TextAlignment -> Right], Inherited}, {
        Inherited, Inherited}},
    CounterIncrements->"ItemizedSubList",
    StyleMenuListing->None,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["ItemizedSubList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedSubList", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedSubList", "EnhancedPrintout"],
    CellMargins->{{26, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedSubList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedSubListNote"],
    CellMargins->{{110, 4}, {4, 4}},
    CounterIncrements->"ItemizedSubList",
    StyleMenuListing->None,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["ItemizedSubListNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedSubListNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedSubListNote", "EnhancedPrintout"],
    CellMargins->{{56, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedSubListNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{48, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BulletedList"],
    CellMargins->{{76, 4}, {4, 4}},
    CellFrameLabels->{{
      Cell[ "\[Bullet]", "BulletedList", CellBaseline -> Baseline], 
          Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 3},
    CounterIncrements->"BulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["BulletedList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BulletedList", "Printout"],
    CellMargins->{{16, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["BulletedList", "EnhancedPrintout"],
    CellMargins->{{26, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BulletedList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListNote"],
    CellMargins->{{88, 4}, {4, 0}},
    LineSpacing->{1, 2},
    CounterIncrements->"ListNote",
    StyleMenuListing->None],
  
  Cell[StyleData["ListNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ListNote", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ListNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathCaption"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{66, 12}, {2, 20}},
    PageBreakBelow->False,
    CellFrameMargins->{{8, 8}, {8, 2}},
    CellFrameColor->GrayLevel[0.700008],
    CellFrameLabelMargins->4,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8},
    FontColor->GrayLevel[0.2]],
  
  Cell[StyleData["MathCaption", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MathCaption", "SlideShow"],
    ShowCellBracket->False,
    CellMargins->{{36, 36}, {6, 6}}],
  
  Cell[StyleData["MathCaption", "Printout"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{27, 27}, {0, 8}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"SmallText",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {3, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Input", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {0, 6}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {4, 8}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Input", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->StandardForm],
  
  Cell[StyleData["Output", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Output", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {8, 4}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Output", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputOnly"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InputOnly", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["InputOnly", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 6}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["InputOnly", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    AutoStyleOptions->{"UnmatchedBracketStyle"->None},
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->RGBColor[0.6, 0.100008, 0.100008]],
  
  Cell[StyleData["Message", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Message", "SlideShow"],
    CellMargins->{{100, 50}, {6, 6}},
    FontSize->10,
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["Message", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Print", "SlideShow"],
    CellMargins->{{100, 50}, {6, 6}}],
  
  Cell[StyleData["Print", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier Std",
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier Std",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["Graphics", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Graphics", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {4, 4}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Graphics", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{32, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier Std",
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{32, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier Std",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["CellLabel", "SlideShow"],
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Name"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["Name", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["Name", "Printout"],
    FontSize->7,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintout"],
    FontFamily->"Frutiger 56 Italic",
    FontSize->7,
    FontSlant->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 56 Italic",
    FontSize->7,
    FontSlant->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlinks", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks. The others point to the various sections of the help \
browser. These styles will modify individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLinkMR"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLinkText"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Times",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLinkText", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DemosLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["DemosLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["DemosLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["DemosLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TourLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["TourLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["TourLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["TourLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLinkMR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MasterIndexLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MasterIndexLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MasterIndexLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MasterIndexLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JT"],
    StyleMenuListing->None,
    FontFamily->"JFontText"],
  
  Cell[StyleData["JT", "Printout"]],
  
  Cell[StyleData["JT", "EnhancedPrintout"]],
  
  Cell[StyleData["JT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JS"],
    StyleMenuListing->None,
    FontFamily->"JFontSans"],
  
  Cell[StyleData["JS", "Printout"]],
  
  Cell[StyleData["JS", "EnhancedPrintout"]],
  
  Cell[StyleData["JS", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JSB"],
    StyleMenuListing->None,
    FontFamily->"JFontSansBold"],
  
  Cell[StyleData["JSB", "Printout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["RM", "Printout"]],
  
  Cell[StyleData["RM", "EnhancedPrintout"]],
  
  Cell[StyleData["RM", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["BF", "Printout"]],
  
  Cell[StyleData["BF", "EnhancedPrintout"]],
  
  Cell[StyleData["BF", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["IT", "Printout"]],
  
  Cell[StyleData["IT", "EnhancedPrintout"]],
  
  Cell[StyleData["IT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TR", "Printout"]],
  
  Cell[StyleData["TR", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TR", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSlant->"Italic"],
  
  Cell[StyleData["TI", "Printout"]],
  
  Cell[StyleData["TI", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TI", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TB", "Printout"]],
  
  Cell[StyleData["TB", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TB", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["TBI", "Printout"]],
  
  Cell[StyleData["TBI", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TBI", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MR"],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MR", "Printout"]],
  
  Cell[StyleData["MR", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["MR", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MO", "Printout"],
    FontSlant->"Oblique"],
  
  Cell[StyleData["MO", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"],
  
  Cell[StyleData["MO", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MB"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MB", "Printout"]],
  
  Cell[StyleData["MB", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["MB", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MBO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MBO", "Printout"],
    FontSlant->"Oblique"],
  
  Cell[StyleData["MBO", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"],
  
  Cell[StyleData["MBO", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SR", "Printout"]],
  
  Cell[StyleData["SR", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["SR", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "EnhancedPrintout"],
    FontFamily->"Frutiger 56 Italic",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 56 Italic",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SB", "Printout"],
    StyleMenuListing->None],
  
  Cell[StyleData["SB", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["SB", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SBColor"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBColor", "Printout"],
    StyleMenuListing->None],
  
  Cell[StyleData["SBColor", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["SBColor", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "EnhancedPrintout"],
    FontFamily->"Frutiger 66 BoldItalic",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 66 BoldItalic",
    FontWeight->"Plain",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["M4"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "Printout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "EnhancedPrintout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "EnhancedPrintoutNonGray"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Frutiger 56 Italic",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO10", "EnhancedPrintoutNonGray"],
    StyleMenuListing->None,
    FontFamily->"Frutiger 56 Italic",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S9"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "Printout"],
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->9,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "Printout"],
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB9"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Bold",
    PrivateFontOptions->{"OperatorSubstitution"->False}],
  
  Cell[StyleData["SB9", "Printout"],
    FontSize->7],
  
  Cell[StyleData["SB9", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->7,
    FontWeight->"Plain"],
  
  Cell[StyleData["SB9", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->7,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["SB10", "Printout"],
    FontSize->8],
  
  Cell[StyleData["SB10", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->8,
    FontWeight->"Plain"],
  
  Cell[StyleData["SB10", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->8,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MR10"],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    SingleLetterItalics->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MR10", "Printout"],
    FontSize->7],
  
  Cell[StyleData["MR10", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->7],
  
  Cell[StyleData["MR10", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1MR", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallCaps"],
    StyleMenuListing->None,
    Magnification->0.8],
  
  Cell[StyleData["SmallCaps", "Printout"]],
  
  Cell[StyleData["SmallCaps", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["SmallCaps", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["KeyboardChars"],
    StyleMenuListing->None,
    FontSize->12],
  
  Cell[StyleData["KeyboardChars", "Printout"],
    FontSize->10],
  
  Cell[StyleData["KeyboardChars", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["KeyboardChars", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Emphasis Boxes and Pictures", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Box"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["Box", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Box", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DoubleBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->2,
    RowAlignments->Top}],
  
  Cell[StyleData["DoubleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DoubleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["1ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["1ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["1ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.31, 0.67}}],
  
  Cell[StyleData["2ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.46}],
  
  Cell[StyleData["2ColumnEvenBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.35,
    ColumnAlignments->{Right, Left}}],
  
  Cell[StyleData["2ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.32}],
  
  Cell[StyleData["3ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.24,
    ColumnAlignments->{Right, Center, Left}}],
  
  Cell[StyleData["3ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellFrame->0.5,
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.13, 0.35, 0.13, 0.35}}],
  
  Cell[StyleData["4ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["4ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.202}],
  
  Cell[StyleData["5ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["5ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],
  
  Cell[StyleData["6ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["6ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FramedBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["FramedBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FramedBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["FramedBox", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["FramedBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox3Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox3Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox3Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox4Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.15, 0.35, 0.15, 0.35},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox4Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox4Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox5Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->0.2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox5Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox5Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox6Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox6Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox6Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 2}},
    CellFrameColor->GrayLevel[0],
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BottomBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BottomBox", "Printout"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {-2, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-2, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-4, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-4, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, 0}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-5, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-7, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-7, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Picture"],
    CellMargins->{{27, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Picture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Picture", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OpenCloseItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedPicture", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintout"],
    CellMargins->{{78, 2}, {12, -6}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListGraphic"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ListGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListGraphic", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5],
  
  Cell[StyleData["ListGraphic", "EnhancedPrintout"],
    CellMargins->{{78, 2}, {12, -6}},
    Magnification->0.5],
  
  Cell[StyleData["ListGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListNoteBox"],
    CellFrame->0.5,
    CellMargins->{{88, 12}, {8, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ListNoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListNoteBox", "Printout"],
    CellMargins->{{77, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ListNoteBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ListNoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{77, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellMargins->{{41, 4}, {0, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureGroup", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureGroup", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintoutNonGray"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Sound"],
    ShowCellBracket->True,
    CellMargins->{{27, Inherited}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Sound", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Sound", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Caption"],
    CellMargins->{{27, 4}, {0, 3}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["Caption", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["Caption", "Printout"],
    CellMargins->{{2, 4}, {2, 0}},
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {2, 2}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {2, -2}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Tables", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.34, 0.64},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->0.49,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnEvenTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{27, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    AutoSpacing->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineOutput"],
    CellMargins->{{27, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InlineOutput", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{66, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True},
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DisplayFormula", "Printout"]],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayMath"],
    CellMargins->{{66, 10}, {7, 7}},
    Evaluatable->False,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input"],
  
  Cell[StyleData["DisplayMath", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DisplayMath", "Printout"],
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{66, 27}, {7, 7}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LanguageCategory->"Formula",
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["EquationNumber"],
    CellMargins->{{66, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1.83, 0},
    LanguageCategory->"Formula"],
  
  Cell[StyleData["EquationNumber", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["EquationNumber", "Printout"],
    LineSpacing->{1.7, 0}],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintout"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintoutNonGray"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellMargins->{{66, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    ShowSpecialCharacters->Automatic,
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintoutNonGray"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Unique Help Browser Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell["\<\
Standard Styles
\
\>", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel1"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 10}, {2, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-38,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel1", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["InspectorLevel1", "SlideShow"],
    HyphenationOptions->{"HyphenationCharacter"->"-"}],
  
  Cell[StyleData["InspectorLevel1", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel2"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["InspectorLevel2", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectName"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellGroupingRules->{"SectionGrouping", 50},
    CellFrameMargins->{{27, 12}, {3, 15}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold",
    Background->RGBColor[0.960784, 0.878431, 0.666667]],
  
  Cell[StyleData["ObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["ObjectName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {1, 10}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["SubObjectNameClosed", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{90, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["SubObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["GroupObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["GroupObjectNameClosed", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectNameWarningMessages"],
    CellMargins->{{27, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["ObjectNameWarningMessages", "SlideShow"],
    CellMargins->{{10, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Command"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 12}, {3, 15}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Section",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    Background->RGBColor[0.960784, 0.878431, 0.666667]],
  
  Cell[StyleData["Command", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Command", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CharacterName"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 27}, {8, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["CharacterName", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CharacterName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CharacterName", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Usage"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 27}, {8, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    Hyphenation->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["Usage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Usage", "SlideShow"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{72, 4}, {0, 4}},
    CellFrameMargins->5,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ErrorMessage"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    ShowCellBracket->True,
    CellMargins->{{27, 4}, {0, 4}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    CellFrameMargins->5,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["ErrorMessage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ErrorMessage", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["ErrorMessage", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notes"],
    CellMargins->{{27, 27}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Notes", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NotesList"],
    CellMargins->{{20, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NotesList", "SlideShow"],
    CellMargins->{{82, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Printout"],
    CellMargins->{{12, 0}, {2, 8}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ReferenceSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 30},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["ReferenceSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["ReferenceSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Reference"],
    CellMargins->{{27, 27}, {0, 8}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    ParagraphSpacing->{0, 8},
    FontSize->12],
  
  Cell[StyleData["Reference", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Reference", "SlideShow"],
    CellMargins->{{27, 27}, {4, 4}},
    Hyphenation->False,
    FontSize->14],
  
  Cell[StyleData["Reference", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["Reference", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Reference", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["ExampleSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleText"],
    CellMargins->{{27, 40}, {0, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ExampleText", "Printout"],
    CellMargins->{{2, 80}, {0, 8}},
    PageBreakBelow->False,
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSubsection"],
    ShowCellBracket->True,
    CellMargins->{{27, 4}, {0, 16}},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSubsection", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["ExampleSubsection", "Printout"],
    CellMargins->{{12, 0}, {0, 16}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MessagesSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["MessagesSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["MessagesSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TemplateSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{27, 4}, {0, 10}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->True},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["TemplateSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["TemplateSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LineHead"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{27, 4}, {8, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["LineHead", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["LineHead", "Printout"],
    CellMargins->{{2, 0}, {8, 18}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushInput"],
    CellMargins->{{27, 4}, {1, 4}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["FlushInput", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FlushInput", "Printout"],
    CellMargins->{{2, 0}, {1, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushOutput"],
    CellMargins->{{27, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    StyleMenuListing->None],
  
  Cell[StyleData["FlushOutput", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FlushOutput", "Printout"],
    CellMargins->{{2, Inherited}, {Inherited, Inherited}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DialogItem"],
    CellDingbat->"\[EmptyDiamond]",
    CellMargins->{{27, 4}, {0, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["DialogItem", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["DialogItem", "Printout"],
    CellMargins->{{12, 0}, {0, 12}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupDivider"],
    CellMargins->{{27, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->{"TitleGrouping", 0},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["GroupDivider", "Presentation"],
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Highlight"],
    CellFrame->0.5,
    CellMargins->{{27, 4}, {0, 18}},
    CellFrameColor->GrayLevel[0.800015],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.950011]],
  
  Cell[StyleData["Highlight", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Highlight", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserNotes"],
    CellFrame->{{3, 0}, {0, 0}},
    CellMargins->{{27, 4}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["UserNotes", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["UserNotes", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8],
  
  Cell[StyleData["UserNotes", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {0, 4}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8],
  
  Cell[StyleData["UserNotes", "EnhancedPrintoutNonGray"],
    CellMargins->{{0, 0}, {0, 4}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MoreInfo"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["MoreInfo", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["MoreInfo", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserTips"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["UserTips", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["UserTips", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0.800015],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["UserTips", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8,
    Background->GrayLevel[0.700008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Theorem"],
    CellFrame->{{4, 0}, {0, 0}},
    CellMargins->{{27, 62}, {0, 14}},
    CellFrameMargins->4,
    CellFrameColor->RGBColor[0, 0, 0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Theorem", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Theorem", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    CellFrameMargins->3,
    CellFrameColor->GrayLevel[0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Commentary"],
    CellFrame->{{2, 0}, {0, 0}},
    CellMargins->{{36, 10}, {7, 7}},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CellFrameColor->RGBColor[0, 0.2, 1],
    LineSpacing->{1, 3},
    FontSlant->"Italic"],
  
  Cell[StyleData["Commentary", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Commentary", "Printout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level1Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level1Icon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Level1Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level2Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level2Icon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Level2Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CopyrightHead"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CopyrightHead", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CopyrightHead", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Copyright"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["Copyright", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Copyright", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["Copyright", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterSubsection"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 45},
    CellFrameLabelMargins->6,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->16],
  
  Cell[StyleData["RegisterSubsection", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["RegisterSubsection", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 12}},
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "Printout"],
    CellMargins->{{9, 0}, {5, 24}},
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterSubsubsection"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["RegisterSubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["RegisterSubsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["RegisterSubsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["RegisterSubsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterText"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["RegisterText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["RegisterText", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["RegisterText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CaptionHead"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CaptionHead", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CaptionHead", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["CaptionHead", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CaptionText"],
    CellMargins->{{66, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None],
  
  Cell[StyleData["CaptionText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CaptionText", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["CaptionText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BulletText"],
    CellMargins->{{76, 4}, {4, 4}},
    CellFrameLabels->{{
      Cell[ "\[Bullet]", "BulletText", CellBaseline -> Baseline], 
          Inherited}, {Inherited, Inherited}},
    Hyphenation->False,
    LineSpacing->{1, 3},
    CounterIncrements->"BulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["BulletText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BulletText", "Printout"],
    FontSize->10],
  
  Cell[StyleData["BulletText", "EnhancedPrintout"],
    CellMargins->{{16, 4}, {2, 4}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BulletText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["HelpLabels"],
    CellMargins->{{88, 4}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["HelpLabels", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["HelpLabels", "Printout"],
    CellMargins->{{34, 2}, {6, 6}},
    FontSize->10],
  
  Cell[StyleData["HelpLabels", "EnhancedPrintout"],
    CellMargins->{{34, 2}, {6, 6}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Manual.nb Merge", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell["Function List", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionName"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{24, 10}, {10, 12}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold",
    CellTags->"FunctionName"],
  
  Cell[StyleData["FunctionName", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["FunctionName", "Printout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionSubsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{36, 10}, {0, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontWeight->"Bold",
    CellTags->"FunctionSubsection"],
  
  Cell[StyleData["FunctionSubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionSubsection", "Printout"],
    CellMargins->{{30, 0}, {0, 6}}],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescription"],
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["FunctionDescription", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescription", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuled"],
    CellFrame->{{0, 0}, {0.25, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuled", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuled", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleTop"],
    CellFrame->{{0, 0}, {0, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleBottom"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionExample"],
    CellMargins->{{36, 10}, {4, 0}},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["FunctionExample", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["FunctionExample", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionTextNote"],
    CellMargins->{{36, 4}, {0, 4}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 4},
    LineIndent->0,
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionTextNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionTextNote", "Printout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontSize->9],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnFunctionTable"],
    CellMargins->{{36, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnFunctionTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnFunctionTable", "Printout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Browser Emulation", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextNormal"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["TextNormal", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TextNormal", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BrowserEmulation"],
    CellMargins->{{12, 1}, {7, 24}},
    CellGroupingRules->{"SectionGrouping", 70},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    GridBoxOptions->{ColumnWidths->0.25,
    ColumnAlignments->{Left},
    GridFrame->True,
    GridFrameMargins->0.5,
    ColumnLines->True}],
  
  Cell[StyleData["BrowserEmulation", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BrowserEmulation", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CategoryDefs"],
    CellMargins->{{300, 10}, {7, 7}},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    Background->RGBColor[1, 0.8, 0.6],
    GridBoxOptions->{ColumnAlignments->{Left},
    GridFrame->False,
    RowLines->True,
    ColumnLines->True}],
  
  Cell[StyleData["CategoryDefs", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CategoryDefs", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category1"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    StyleMenuListing->None,
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Category1", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Category1", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category2"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{85, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    StyleMenuListing->None,
    FontSize->14,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 0.500008]],
  
  Cell[StyleData["Category2", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["Category2", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category3"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{157, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.2, 0, 0.4]],
  
  Cell[StyleData["Category3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Category3", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category4"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{230, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    StyleMenuListing->None,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0.300008, 0.4]],
  
  Cell[StyleData["Category4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Category4", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Misc", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.25,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["4ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["4ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.2,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["5ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["5ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.16,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["6ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["6ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["7ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.14,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["7ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["7ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["8ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.12,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["8ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["8ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ABItemizedText"],
    CellMargins->{{20, 4}, {0, 5}},
    LineSpacing->{1, 3},
    ParagraphIndent->-21,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ABItemizedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ABItemizedText", "Printout"],
    Hyphenation->True,
    ParagraphIndent->-21,
    FontSize->11],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintout"],
    Hyphenation->True,
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapNumber"],
    CellMargins->{{27, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->42,
    FontWeight->"Plain",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ChapNumber", "Presentation"],
    FontSize->63],
  
  Cell[StyleData["ChapNumber", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->36],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->36,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->36,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapTitle"],
    CellMargins->{{27, Inherited}, {80, 10}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ChapTitle", "Presentation"],
    FontSize->54],
  
  Cell[StyleData["ChapTitle", "Printout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontSize->30],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemDingbat"],
    CellSize->{22, 14},
    TextAlignment->Right,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["ItemDingbat", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemDingbat", "Printout"],
    CellSize->{22, 13.125}],
  
  Cell[StyleData["ItemDingbat", "EnhancedPrintout"],
    CellSize->{22, 11}],
  
  Cell[StyleData["ItemDingbat", "EnhancedPrintoutNonGray"],
    CellSize->{22, 11}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1"],
    CellMargins->{{19, 4}, {4, 4}},
    ParagraphIndent->-22,
    CounterIncrements->"Item1",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item1", "Printout"],
    CellMargins->{{12, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item1", "EnhancedPrintout"],
    CellMargins->{{16, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item1", "EnhancedPrintoutNonGray"],
    CellMargins->{{16, 0}, {2, 4}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1Continued"],
    CellMargins->{{41, 4}, {4, 1}},
    CounterIncrements->"Item1Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item1Continued", "Printout"],
    CellMargins->{{34, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintout"],
    CellMargins->{{39, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 0}, {4, 1}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2"],
    CellMargins->{{32, 4}, {4, 4}},
    ParagraphIndent->-22,
    CounterIncrements->"Item2",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item2", "Printout"],
    CellMargins->{{26, 0}, {4, 4}},
    ParagraphIndent->-22,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintout"],
    CellMargins->{{29, 0}, {2, 4}},
    ParagraphIndent->-22,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintoutNonGray"],
    CellMargins->{{29, 0}, {2, 4}},
    ParagraphIndent->-22,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2Continued"],
    CellMargins->{{54, 4}, {4, 1}},
    CounterIncrements->"Item2Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item2Continued", "Printout"],
    CellMargins->{{27, 0}, {4, 1}}],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintout"],
    CellMargins->{{52, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{52, 0}, {4, 1}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3"],
    CellMargins->{{45, 4}, {4, 4}},
    ParagraphIndent->-23,
    CounterIncrements->"Item3",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item3", "Printout"],
    CellMargins->{{27, 0}, {2, 4}}],
  
  Cell[StyleData["Item3", "EnhancedPrintout"],
    CellMargins->{{42, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item3", "EnhancedPrintoutNonGray"],
    CellMargins->{{42, 0}, {2, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3Continued"],
    CellMargins->{{67, 4}, {4, 1}},
    CounterIncrements->"Item3Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item3Continued", "Printout"],
    CellMargins->{{27, 0}, {4, 1}}],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintout"],
    CellMargins->{{65, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{65, 0}, {4, 1}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBulletText"],
    CellMargins->{{19, 4}, {0, 5}},
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedBulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedBulletText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedBulletText", "Printout"],
    Hyphenation->True,
    ParagraphIndent->-20,
    FontSize->11],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintout"],
    Hyphenation->True,
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NoteBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {8, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["NoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NoteBox", "Printout"],
    CellMargins->{{2, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["NoteBox", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["NoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBox"],
    CellFrame->0.5,
    CellMargins->{{41, 4}, {8, 2}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ItemizedNoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNoteBox", "Printout"],
    CellMargins->{{39, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{37, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameMargins->{{8, 8}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedTopBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTopBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {0, 6}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {0, 6}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{37, 4}, {4, 0}},
    CellHorizontalScrolling->True,
    CellFrameMargins->{{8, 8}, {8, 0}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedBottomBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedBottomBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {6, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpacedBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpacedBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleSpacedBox", "Printout"],
    CellMargins->{{2, 0}, {0, 0}},
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNote"],
    CellMargins->{{41, 4}, {0, 12}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNote", "Printout"],
    CellMargins->{{38, 4}, {0, 9}},
    Hyphenation->True,
    FontSize->11],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBelow"],
    CellMargins->{{41, 4}, {0, 8}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNoteBelow", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNoteBelow", "Printout"],
    CellMargins->{{38, 4}, {0, 12}},
    Hyphenation->True,
    FontSize->11],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextBelowPic"],
    CellMargins->{{19, 4}, {0, 8}},
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextBelowPic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextBelowPic", "Printout"],
    CellMargins->{{20, 4}, {2, 12}},
    Hyphenation->True,
    ParagraphIndent->-18,
    FontSize->11],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintout"],
    CellMargins->{{20, 4}, {2, 12}},
    Hyphenation->True,
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 4}, {2, 12}},
    Hyphenation->True,
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote2"],
    CellMargins->{{41, 4}, {0, 4}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextNote2", "Printout"],
    CellMargins->{{38, 4}, {0, 2}},
    Hyphenation->True,
    FontSize->11],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 2}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 2}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem1"],
    CellMargins->{{48, 4}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem1",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem1", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintoutNonGray"],
    CellMargins->{{12, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem2"],
    CellMargins->{{71, 4}, {3, 3}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-21,
    CounterIncrements->"NumberedItem2",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem2", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem3"],
    CellMargins->{{94, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem3",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem3", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeaderBold"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["PageHeaderBold", "Printout"]],
  
  Cell[StyleData["PageHeaderBold", "EnhancedPrintout"],
    FontFamily->"Frutiger"],
  
  Cell[StyleData["PageHeaderBold", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SingleRowTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["SingleRowTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SingleRowTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsubsection"],
    CellMargins->{{27, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Subsubsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{27, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{27, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextBelow"],
    CellMargins->{{27, 4}, {0, 14}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontSize->12],
  
  Cell[StyleData["TextBelow", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TextBelow", "Printout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{27, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    FontSize->54],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->30],
  
  Cell[StyleData["Title", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain"],
  
  Cell[StyleData["Title", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Undersubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Undersubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Undersubsection", "Printout"],
    CellMargins->{{2, 0}, {7, 10}},
    FontSize->10],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SectionFirst"],
    CellMargins->{{27, 27}, {12, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SectionFirst", "Presentation"],
    FontSize->30],
  
  Cell[StyleData["SectionFirst", "Printout"],
    CellMargins->{{2, 0}, {0, 6}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["SectionFirst", "EnhancedPrintout"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 6}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SectionFirst", "EnhancedPrintoutNonGray"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 6}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionFirst"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsectionFirst", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubsectionFirst", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 6}},
    FontSize->12],
  
  Cell[StyleData["SubsectionFirst", "Printout"],
    CellMargins->{{9, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontSize->12],
  
  Cell[StyleData["SubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionFirst"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsubsectionFirst", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionFirst", "Printout"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontSize->10],
  
  Cell[StyleData["SubsubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SubsubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsubsectionFirst"],
    CellMargins->{{10, 4}, {0, 12}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsubsubsectionFirst", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsubsectionFirst", "Printout"],
    CellMargins->{{2, 0}, {3, 3}},
    FontSize->10],
  
  Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 3}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 3}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell["Spacer Cell", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Spacer"],
    CellMargins->{{10, 10}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->1},
    CellOpen->False,
    StyleMenuListing->None],
  
  Cell[StyleData["Spacer", "Printout"],
    CellOpen->True,
    FontSize->3]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DiscretionaryHyphen"],
    StyleMenuListing->None,
    FontSize->0.0625,
    FontColor->GrayLevel[1]],
  
  Cell[StyleData["DiscretionaryHyphen", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintoutNonGray"],
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller1"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller1", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.63],
  
  Cell[StyleData["PictureSmaller1", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.63],
  
  Cell[StyleData["PictureSmaller1", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.63]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller2"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller2", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.61],
  
  Cell[StyleData["PictureSmaller2", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.61],
  
  Cell[StyleData["PictureSmaller2", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.61]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller3"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller3", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.59],
  
  Cell[StyleData["PictureSmaller3", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.59],
  
  Cell[StyleData["PictureSmaller3", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.59]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller4"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller4", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.57],
  
  Cell[StyleData["PictureSmaller4", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.57],
  
  Cell[StyleData["PictureSmaller4", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.57]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller5"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller5", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.55],
  
  Cell[StyleData["PictureSmaller5", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.55],
  
  Cell[StyleData["PictureSmaller5", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.55]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller6"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller6", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.53],
  
  Cell[StyleData["PictureSmaller6", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.53],
  
  Cell[StyleData["PictureSmaller6", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.53]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPicture"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPicture", "Printout"],
    CellMargins->{{55, Inherited}, {8, -4}},
    Magnification->0.65],
  
  Cell[StyleData["ItemPicture", "EnhancedPrintout"],
    CellMargins->{{60, Inherited}, {10, -3}},
    Magnification->0.65],
  
  Cell[StyleData["ItemPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{60, Inherited}, {10, -3}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller1"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller1", "Printout"],
    CellMargins->{{56, Inherited}, {9, -3}},
    Magnification->0.63],
  
  Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintout"],
    CellMargins->{{63, Inherited}, {10, -3}},
    Magnification->0.63],
  
  Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintoutNonGray"],
    CellMargins->{{63, Inherited}, {10, -3}},
    Magnification->0.63]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller2"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller2", "Printout"],
    CellMargins->{{58, Inherited}, {8, -4}},
    Magnification->0.61],
  
  Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintout"],
    CellMargins->{{65, Inherited}, {11, -3}},
    Magnification->0.61],
  
  Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintoutNonGray"],
    CellMargins->{{65, Inherited}, {11, -3}},
    Magnification->0.61]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller3"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller3", "Printout"],
    CellMargins->{{61, Inherited}, {10, -2}},
    Magnification->0.59],
  
  Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintout"],
    CellMargins->{{67, Inherited}, {11, -3}},
    Magnification->0.59],
  
  Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintoutNonGray"],
    CellMargins->{{67, Inherited}, {11, -3}},
    Magnification->0.59]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller4"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller4", "Printout"],
    CellMargins->{{63, Inherited}, {10, -2}},
    Magnification->0.57],
  
  Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintout"],
    CellMargins->{{69, Inherited}, {12, -4}},
    Magnification->0.57],
  
  Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintoutNonGray"],
    CellMargins->{{69, Inherited}, {12, -4}},
    Magnification->0.57]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller5"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller5", "Printout"],
    CellMargins->{{65, Inherited}, {11, -2}},
    Magnification->0.55],
  
  Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintout"],
    CellMargins->{{71, Inherited}, {13, -2}},
    Magnification->0.55],
  
  Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintoutNonGray"],
    CellMargins->{{71, Inherited}, {13, -2}},
    Magnification->0.55]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller6"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller6", "Printout"],
    CellMargins->{{67, Inherited}, {12, -2}},
    Magnification->0.53],
  
  Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintout"],
    CellMargins->{{74, Inherited}, {13, -3}},
    Magnification->0.53],
  
  Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintoutNonGray"],
    CellMargins->{{74, Inherited}, {13, -3}},
    Magnification->0.53]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger1"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger1", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.68],
  
  Cell[StyleData["PictureBigger1", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.68],
  
  Cell[StyleData["PictureBigger1", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.68]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger2"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger2", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.71],
  
  Cell[StyleData["PictureBigger2", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.71],
  
  Cell[StyleData["PictureBigger2", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.71]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger3"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger3", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.74],
  
  Cell[StyleData["PictureBigger3", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.74],
  
  Cell[StyleData["PictureBigger3", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.74]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger4"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger4", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.77],
  
  Cell[StyleData["PictureBigger4", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.77],
  
  Cell[StyleData["PictureBigger4", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.77]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger5"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger5", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.8],
  
  Cell[StyleData["PictureBigger5", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.8],
  
  Cell[StyleData["PictureBigger5", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger6"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger6", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.83],
  
  Cell[StyleData["PictureBigger6", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.83],
  
  Cell[StyleData["PictureBigger6", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.83]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger1"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger1", "Printout"],
    CellMargins->{{50, Inherited}, {9, -3}},
    Magnification->0.68],
  
  Cell[StyleData["ItemPictureBigger1", "EnhancedPrintout"],
    CellMargins->{{57, Inherited}, {10, -3}},
    Magnification->0.68],
  
  Cell[StyleData["ItemPictureBigger1", "EnhancedPrintoutNonGray"],
    CellMargins->{{57, Inherited}, {10, -3}},
    Magnification->0.68]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger2"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger2", "Printout"],
    CellMargins->{{48, Inherited}, {8, -4}},
    Magnification->0.71],
  
  Cell[StyleData["ItemPictureBigger2", "EnhancedPrintout"],
    CellMargins->{{54, Inherited}, {10, -3}},
    Magnification->0.71],
  
  Cell[StyleData["ItemPictureBigger2", "EnhancedPrintoutNonGray"],
    CellMargins->{{54, Inherited}, {10, -3}},
    Magnification->0.71]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger3"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger3", "Printout"],
    CellMargins->{{46, Inherited}, {10, -2}},
    Magnification->0.74],
  
  Cell[StyleData["ItemPictureBigger3", "EnhancedPrintout"],
    CellMargins->{{52, Inherited}, {10, -3}},
    Magnification->0.74],
  
  Cell[StyleData["ItemPictureBigger3", "EnhancedPrintoutNonGray"],
    CellMargins->{{52, Inherited}, {10, -3}},
    Magnification->0.74]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger4"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger4", "Printout"],
    CellMargins->{{45, Inherited}, {10, -2}},
    Magnification->0.77],
  
  Cell[StyleData["ItemPictureBigger4", "EnhancedPrintout"],
    CellMargins->{{50, Inherited}, {10, -3}},
    Magnification->0.77],
  
  Cell[StyleData["ItemPictureBigger4", "EnhancedPrintoutNonGray"],
    CellMargins->{{50, Inherited}, {10, -3}},
    Magnification->0.77]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger5"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger5", "Printout"],
    CellMargins->{{43, Inherited}, {11, -2}},
    Magnification->0.8],
  
  Cell[StyleData["ItemPictureBigger5", "EnhancedPrintout"],
    CellMargins->{{49, Inherited}, {10, -3}},
    Magnification->0.8],
  
  Cell[StyleData["ItemPictureBigger5", "EnhancedPrintoutNonGray"],
    CellMargins->{{49, Inherited}, {10, -3}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger6"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger6", "Printout"],
    CellMargins->{{43, Inherited}, {12, -2}},
    Magnification->0.83],
  
  Cell[StyleData["ItemPictureBigger6", "EnhancedPrintout"],
    CellMargins->{{46, Inherited}, {8, -2}},
    Magnification->0.83],
  
  Cell[StyleData["ItemPictureBigger6", "EnhancedPrintoutNonGray"],
    CellMargins->{{46, Inherited}, {8, -2}},
    Magnification->0.83]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ScreenGraphic"],
    CellMargins->{{12, Inherited}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ScreenGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ScreenGraphic", "Printout"],
    CellMargins->{{2, Inherited}, {0, 8}}],
  
  Cell[StyleData["ScreenGraphic", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False],
  
  Cell[StyleData["ScreenGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrintGraphic"],
    CellMargins->{{12, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False,
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PrintGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PrintGraphic", "Printout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False],
  
  Cell[StyleData["PrintGraphic", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->12},
    CellOpen->True],
  
  Cell[StyleData["PrintGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->12},
    CellOpen->True]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallTextSans"],
    CellMargins->{{10, 4}, {8, 8}},
    TextJustification->1,
    LineSpacing->{1, 2},
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallTextSans", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SmallTextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->7],
  
  Cell[StyleData["SmallTextSans", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, -2},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["AuthorTools", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BilateralCell"],
    CellMargins->{{27, 4}, {0, 8}},
    StyleMenuListing->None,
    FontSize->12,
    GridBoxOptions->{ColumnWidths->{0.33, 0.6},
    RowAlignments->Top,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BilateralCell", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BilateralCell", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["BilateralCell", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RuledPageBreak"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{27, 4}, {12, 0}},
    CellFrameMargins->{{0, 0}, {1, 0}},
    FontSize->8],
  
  Cell[StyleData["RuledPageBreak", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["RuledPageBreak", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}}],
  
  Cell[StyleData["RuledPageBreak", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True,
    FontSize->1],
  
  Cell[StyleData["RuledPageBreak", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True],
  
  Cell[StyleData["RuledPageBreak", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True]
  }, Closed]],
  
  Cell[StyleData["PaletteTitle"],
    CellFrame->{{0, 0}, {1, 0}},
    CellMargins->{{4, 0}, {Inherited, 0}},
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->RGBColor[0, 0.32549, 0.537255],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #2]}]&),
    ButtonEvaluator->None,
    ButtonStyle->"PaletteButton",
    ButtonMargins->3}],
  
  Cell[StyleData["PaletteButton"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonEvaluator->"Local",
    Active->True,
    ButtonMargins->6,
    Background->RGBColor[0.329412, 0.584314, 0.694118]}],
  
  Cell[StyleData["PaletteButton2"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonEvaluator->"Local",
    Active->True,
    ButtonMargins->4,
    Background->RGBColor[0.537255, 0.72549, 0.843137]}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{27, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "Presentation"],
    FontSize->27],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{57, 10}, {6, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "Presentation"],
    FontSize->23],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{87, 10}, {5, 5}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{117, 10}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Slide Show Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowNavigationBar"],
    Editable->False,
    CellFrame->True,
    CellMargins->{{0, 0}, {3, 3}},
    CellElementSpacings->{"CellMinHeight"->0.8125},
    CellGroupingRules->{"SectionGrouping", 30},
    CellFrameMargins->False,
    CellFrameColor->GrayLevel[1],
    CellFrameLabelMargins->False,
    TextAlignment->Center,
    CounterIncrements->"SlideShowNavigationBar",
    StyleMenuListing->None,
    FontSize->10,
    Background->GrayLevel[0.8],
    Magnification->1,
    GridBoxOptions->{GridBaseline->Center,
    RowSpacings->0,
    ColumnSpacings->0,
    ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
    RowAlignments->Baseline,
    ColumnAlignments->{
      Center, Center, Center, Center, Center, Center, Right, Center}}],
  
  Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
    Deletable->False,
    ShowCellBracket->False,
    CellMargins->{{-1, -1}, {-1, -1}},
    PageBreakAbove->True,
    CellFrameMargins->{{1, 1}, {0, 0}}],
  
  Cell[StyleData["SlideShowNavigationBar", "Printout"],
    CellMargins->{{18, 4}, {4, 4}},
    LineSpacing->{1, 3},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{0, 0}, {10, 0}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CellFrameMargins->{{12, 4}, {6, 12}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["SlideShowSection", "Presentation"],
    FontSize->27],
  
  Cell[StyleData["SlideShowSection", "SlideShow"],
    ShowCellBracket->False,
    PageBreakAbove->True],
  
  Cell[StyleData["SlideShowSection", "Printout"],
    CellMargins->{{18, 30}, {0, 30}},
    CellFrameMargins->5,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideHyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontSize->26,
    FontColor->GrayLevel[0.400015],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMinHeight->0.85,
    ButtonMargins->0.5,
    ButtonNote->None}],
  
  Cell[StyleData["SlideHyperlink", "SlideShow"]],
  
  Cell[StyleData["SlideHyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOCLink"],
    CellMargins->{{24, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMargins->1.5,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["SlideTOCLink", "SlideShow"]],
  
  Cell[StyleData["SlideTOCLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOC"],
    CellDingbat->"\[Bullet]",
    CellMargins->{{18, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    FontFamily->"Helvetica"],
  
  Cell[StyleData["SlideTOC", "SlideShow"],
    FontSize->14],
  
  Cell[StyleData["SlideTOC", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Title Page, Contents, and Index", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsTitle"],
    CellMargins->{{21, 4}, {12, 24}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ContentsTitle", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["ContentsTitle", "Printout"],
    CellMargins->{{12, 0}, {102, 89}},
    PageBreakBelow->False,
    FontSize->30.5,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ContentsTitle", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {15, 30}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsSection"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{35, 4}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ContentsSection", "Printout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{20, 4}, {5, 20}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["IndexSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndexSection", "Printout"],
    CellMargins->{{12, 0}, {5, 20}},
    PageBreakBelow->False,
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Contents"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{50, 4}, {0, 5}},
    CellGroupingRules->{"SectionGrouping", 90},
    StyleMenuListing->None],
  
  Cell[StyleData["Contents", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Contents", "Printout"],
    CellMargins->{{40, 4}, {0, 5}},
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintout"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintoutNonGray"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index"],
    CellMargins->{{21, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["Index", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Index", "Printout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontSize->9],
  
  Cell[StyleData["Index", "EnhancedPrintout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["Index", "EnhancedPrintoutNonGray"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSubentry"],
    CellMargins->{{36, 4}, {0, 0}},
    ParagraphIndent->-48],
  
  Cell[StyleData["IndexSubentry", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndexSubentry", "Printout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontSize->9],
  
  Cell[StyleData["IndexSubentry", "EnhancedPrintout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index2Column"],
    CellMargins->{{21, 4}, {0, 8}},
    ParagraphIndent->-20,
    TabSpacings->1,
    StyleMenuListing->None,
    FontSize->10,
    GridBoxOptions->{ColumnWidths->0.5,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["Index2Column", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Index2Column", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->8],
  
  Cell[StyleData["Index2Column", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {1, 1}},
    LineSpacing->{1, 0.2},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["Index2Column", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {1, 1}},
    LineSpacing->{1, 0.2},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Leader"],
    TabFilling->".",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["Leader", "Printout"],
    FontSize->10],
  
  Cell[StyleData["Leader", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LeaderNoDots"],
    TabFilling->" ",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["LeaderNoDots", "Printout"],
    FontSize->10],
  
  Cell[StyleData["LeaderNoDots", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["PageLink", "Printout"],
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["PageLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCPage"],
    CellSize->{22, Inherited},
    TextAlignment->Right,
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["TOCPage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCPage", "Printout"],
    FontSize->10],
  
  Cell[StyleData["TOCPage", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitle"],
    CellMargins->{{20, 0}, {1, 8}},
    CellGroupingRules->{"SectionGrouping", 70},
    TabSpacings->46,
    CounterIncrements->"TOCTitle",
    CounterAssignments->{{"TOCSection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["TOCTitle", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCTitle", "Printout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    TabSpacings->47.4,
    FontSize->11],
  
  Cell[StyleData["TOCTitle", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {2, 10}},
    PageBreakBelow->False,
    TabSpacings->49.3,
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSection"],
    CellMargins->{{48, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 75},
    TabSpacings->42.9,
    CounterIncrements->"TOCSection",
    CounterAssignments->{{"TOCSubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->12],
  
  Cell[StyleData["TOCSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSection", "Printout"],
    CellMargins->{{30, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->12],
  
  Cell[StyleData["TOCSection", "EnhancedPrintout"],
    CellMargins->{{26, 0}, {1, 3}},
    PageBreakBelow->False,
    TabSpacings->46.45,
    FontFamily->"Frutiger",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsection"],
    CellMargins->{{76, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 80},
    TabSpacings->39.8,
    CounterIncrements->"TOCSubsection",
    CounterAssignments->{{"TOCSubsubsection", 0}},
    FontSize->12],
  
  Cell[StyleData["TOCSubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsection", "Printout"],
    CellMargins->{{70, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->10],
  
  Cell[StyleData["TOCSubsection", "EnhancedPrintout"],
    CellMargins->{{38, 0}, {1, 1}},
    PageBreakBelow->False,
    TabSpacings->45.15,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsubsection"],
    CellMargins->{{104, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 85},
    TabSpacings->36.7,
    CounterIncrements->"TOCSubsubsection",
    FontSize->12],
  
  Cell[StyleData["TOCSubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsubsection", "Printout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->9],
  
  Cell[StyleData["TOCSubsubsection", "EnhancedPrintout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitleDingbat"],
    CellSize->{34, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCTitleDingbat", "EnhancedPrintout"],
    FontFamily->"Frutiger",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSectionDingbat"],
    CellSize->{38, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCSectionDingbat", "EnhancedPrintout"],
    FontFamily->"Frutiger",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsectionDingbat"],
    CellSize->{54, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCSubsectionDingbat", "EnhancedPrintout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitleCondensed"],
    CellMargins->{{20, 0}, {1, 8}},
    CellGroupingRules->{"SectionGrouping", 70},
    TabSpacings->50.4,
    CounterIncrements->"TOCTitleCondensed",
    CounterAssignments->{{"TOCSectionCondensed", 0}, {
        "TOCSubsectionCondensed", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["TOCTitleCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCTitleCondensed", "Printout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["TOCTitleCondensed", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSectionCondensed"],
    CellMargins->{{48, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 75},
    TabSpacings->47.4,
    CounterIncrements->"TOCSectionCondensed",
    CounterAssignments->{{"TOCSubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold",
    FontColor->GrayLevel[0.2]],
  
  Cell[StyleData["TOCSectionCondensed", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["TOCSectionCondensed", "Printout"],
    CellMargins->{{36, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["TOCSectionCondensed", "EnhancedPrintout"],
    CellMargins->{{36, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsectionCondensed"],
    PageWidth->470,
    CellMargins->{{76, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 80},
    TextJustification->1,
    FontSize->12],
  
  Cell[StyleData["TOCSubsectionCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsectionCondensed", "Printout"],
    CellMargins->{{72, 0}, {1, 1}},
    PageBreakBelow->False,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["TOCSubsectionCondensed", "EnhancedPrintout"],
    CellMargins->{{72, 0}, {1, 1}},
    PageBreakBelow->False,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsubsectionCondensed"],
    CellMargins->{{104, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 85},
    TabSpacings->39.3,
    CounterIncrements->"TOCSubsubsectionCondensed",
    FontSize->12],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "Printout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->9],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "EnhancedPrintout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TitlePageGraphic"],
    CellMargins->{{0, 0}, {100, 20}},
    Evaluatable->False,
    PageBreakBelow->False,
    TextAlignment->Center],
  
  Cell[StyleData["TitlePageGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TitlePageGraphic", "Printout"],
    CellMargins->{{0, 0}, {230, 88}}],
  
  Cell[StyleData["TitlePageGraphic", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {230, 88}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TitlePageLogo"],
    CellMargins->{{0, 0}, {0, 0}}],
  
  Cell[StyleData["TitlePageLogo", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TitlePageLogo", "Printout"]],
  
  Cell[StyleData["TitlePageLogo", "EnhancedPrintout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Horizontal Lines", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Line1"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-16, 9}},
    StyleMenuListing->None,
    FontSize->2],
  
  Cell[StyleData["Line1", "Presentation"],
    FontSize->3],
  
  Cell[StyleData["Line1", "Printout"],
    CellMargins->{{2, 0}, {-16, 9}}]
  }, Closed]],
  
  Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramTop"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 4}, {-18, 18}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramTop", "Presentation"],
    FontSize->6],
  
  Cell[StyleData["ProgramTop", "Printout"],
    CellMargins->{{2, 0}, {-18, 18}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramBottom"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{27, 4}, {-10, -2}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramBottom", "Presentation"],
    FontSize->6],
  
  Cell[StyleData["ProgramBottom", "Printout"],
    CellMargins->{{2, 0}, {-10, -2}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SessionLabel"],
    CellFrame->{{0.5, 0}, {0, 0.5}},
    CellMargins->{{27, 4}, {-4, 18}},
    LineSpacing->{1, 0},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SessionLabel", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SessionLabel", "Printout"],
    CellMargins->{{2, 0}, {-4, 18}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Page Headers and Footers", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeader"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageHeader", "Printout"]],
  
  Cell[StyleData["PageHeader", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["PageHeader", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Bold"],
  
  Cell[StyleData["PageNumber", "Printout"]],
  
  Cell[StyleData["PageNumber", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["PageNumber", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageFooter"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["PageFooter", "Printout"]],
  
  Cell[StyleData["PageFooter", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["PageFooter", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["For compatibility", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["Header", "Printout"]],
  
  Cell[StyleData["Header", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSlant->"Plain"],
  
  Cell[StyleData["Header", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Footer"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["Footer", "Printout"]],
  
  Cell[StyleData["Footer", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["Footer", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["CellExpression", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->10],
  
  Cell[StyleData["CellExpression", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InputForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["InputForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["OutputForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["StandardForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "LinearAlgebraTOC"->{
    Cell[1776, 53, 137, 5, 88, "Chapter",
      CellTags->"LinearAlgebraTOC"],
    Cell[1938, 62, 325, 9, 36, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[2266, 73, 560, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[2851, 91, 1082, 27, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[3936, 120, 565, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[4516, 137, 844, 21, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[5397, 163, 341, 9, 26, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[5763, 176, 559, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[6325, 192, 554, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[6916, 211, 563, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[7504, 229, 566, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[8073, 245, 566, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[8676, 264, 566, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[9245, 280, 566, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[9826, 297, 307, 6, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[10136, 305, 565, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[10704, 321, 566, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[11273, 337, 558, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[11834, 353, 549, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[12386, 369, 557, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[12946, 385, 556, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[13505, 401, 569, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[14111, 420, 567, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[14681, 436, 551, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[15235, 452, 543, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[15815, 471, 563, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[16381, 487, 567, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[16985, 506, 569, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[17557, 522, 559, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[18119, 538, 557, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[18691, 555, 573, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[19289, 573, 565, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[19879, 591, 553, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[20435, 607, 577, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[21027, 624, 565, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[21629, 643, 563, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[22195, 659, 560, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[22804, 679, 327, 9, 26, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[23156, 692, 560, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[23741, 710, 551, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[24295, 726, 570, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[24880, 743, 577, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[25460, 759, 546, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[26009, 775, 550, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[26596, 794, 565, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[27186, 812, 566, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[27755, 828, 566, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[28358, 847, 566, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[28927, 863, 566, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[29508, 880, 308, 6, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[29819, 888, 565, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[30387, 904, 566, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[30956, 920, 558, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[31517, 936, 549, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[32069, 952, 557, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[32629, 968, 556, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[33188, 984, 569, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[33794, 1003, 567, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[34364, 1019, 551, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[34918, 1035, 543, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[35498, 1054, 576, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[36077, 1070, 566, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[36646, 1086, 564, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[37225, 1103, 580, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[37830, 1121, 565, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[38398, 1137, 553, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[38966, 1154, 563, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[39532, 1170, 581, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[40116, 1186, 567, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[40720, 1205, 333, 9, 26, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[41078, 1218, 560, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[41663, 1236, 545, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[42211, 1252, 555, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[42769, 1268, 555, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[43339, 1285, 549, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[43891, 1301, 544, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[44438, 1317, 556, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[44997, 1333, 547, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[45547, 1349, 553, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[46103, 1365, 551, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[46657, 1381, 546, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[47240, 1400, 566, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[47809, 1416, 557, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[48369, 1432, 561, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[48933, 1448, 575, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[49533, 1466, 567, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[50103, 1482, 556, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[50674, 1499, 564, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[51263, 1517, 547, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[51813, 1533, 549, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[52365, 1549, 555, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[52923, 1565, 549, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[53475, 1581, 551, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[54029, 1597, 559, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[54637, 1617, 567, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[55207, 1633, 552, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[55796, 1652, 568, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[56367, 1668, 562, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[56932, 1684, 562, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[57497, 1700, 567, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[58067, 1716, 565, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[58657, 1734, 549, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[59209, 1750, 551, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[59763, 1766, 552, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[60318, 1782, 561, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[60928, 1802, 567, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[61498, 1818, 558, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[62081, 1836, 564, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[62648, 1852, 320, 6, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[62983, 1861, 572, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[63580, 1879, 558, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[64141, 1895, 573, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[64751, 1914, 570, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[65324, 1930, 572, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[65899, 1946, 552, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[66488, 1965, 561, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[67052, 1981, 576, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[67631, 1997, 552, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[68198, 2014, 562, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[68775, 2031, 567, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[69379, 2050, 327, 9, 26, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[69731, 2063, 840, 21, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[70574, 2086, 574, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[71151, 2102, 563, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[71751, 2121, 841, 21, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[72595, 2144, 574, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[73172, 2160, 584, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[73759, 2176, 572, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[74334, 2192, 561, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[74910, 2209, 562, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[75475, 2225, 574, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[76086, 2244, 326, 9, 26, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[76437, 2257, 559, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[76999, 2273, 564, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[77566, 2289, 565, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[78134, 2305, 562, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[78733, 2324, 568, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[79304, 2340, 563, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[79892, 2358, 559, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[80454, 2374, 558, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[81015, 2390, 558, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[81610, 2409, 564, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[82177, 2425, 555, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[82735, 2441, 557, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[83295, 2457, 565, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[83897, 2476, 557, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[84457, 2492, 576, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[85036, 2508, 574, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[85613, 2524, 561, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[86223, 2544, 567, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[86793, 2560, 562, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[87358, 2576, 308, 6, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[87715, 2588, 323, 9, 26, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[88041, 2599, 561, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[88627, 2617, 579, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[89209, 2633, 564, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[89776, 2649, 558, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[90371, 2668, 582, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[90956, 2684, 563, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[91522, 2700, 568, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[92105, 2717, 573, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[92703, 2735, 563, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[93269, 2751, 549, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[93821, 2767, 559, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[94383, 2783, 555, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[94941, 2799, 560, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[95504, 2815, 564, 14, 18, "TOCSubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[96083, 2832, 575, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[96695, 2851, 323, 9, 26, "SubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[97043, 2864, 565, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"],
    Cell[97611, 2880, 551, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[98165, 2896, 550, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[98718, 2912, 559, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[99280, 2928, 558, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[99841, 2944, 550, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[100394, 2960, 550, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[100947, 2976, 552, 14, 18, "TOCSubsubsection",
      CellTags->"LinearAlgebraTOC"],
    Cell[101514, 2993, 556, 14, 24, "SubsubsectionIcon",
      CellTags->"LinearAlgebraTOC"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"LinearAlgebraTOC", 351934, 11740}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 137, 5, 88, "Chapter",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[1938, 62, 325, 9, 36, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[2266, 73, 560, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[2851, 91, 1082, 27, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[3936, 120, 565, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[4516, 137, 844, 21, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[5397, 163, 341, 9, 26, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[5763, 176, 559, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[6325, 192, 554, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[6916, 211, 563, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[7504, 229, 566, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[8073, 245, 566, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[8676, 264, 566, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[9245, 280, 566, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[9826, 297, 307, 6, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[10136, 305, 565, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[10704, 321, 566, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[11273, 337, 558, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[11834, 353, 549, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[12386, 369, 557, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[12946, 385, 556, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[13505, 401, 569, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[14111, 420, 567, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[14681, 436, 551, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[15235, 452, 543, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[15815, 471, 563, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[16381, 487, 567, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[16985, 506, 569, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[17557, 522, 559, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[18119, 538, 557, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[18691, 555, 573, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[19289, 573, 565, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[19879, 591, 553, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[20435, 607, 577, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[21027, 624, 565, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[21629, 643, 563, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[22195, 659, 560, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22804, 679, 327, 9, 26, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[23156, 692, 560, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[23741, 710, 551, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[24295, 726, 570, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[24880, 743, 577, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[25460, 759, 546, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[26009, 775, 550, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[26596, 794, 565, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[27186, 812, 566, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[27755, 828, 566, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[28358, 847, 566, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[28927, 863, 566, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[29508, 880, 308, 6, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[29819, 888, 565, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[30387, 904, 566, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[30956, 920, 558, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[31517, 936, 549, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[32069, 952, 557, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[32629, 968, 556, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[33188, 984, 569, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[33794, 1003, 567, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[34364, 1019, 551, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[34918, 1035, 543, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[35498, 1054, 576, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[36077, 1070, 566, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[36646, 1086, 564, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[37225, 1103, 580, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[37830, 1121, 565, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[38398, 1137, 553, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[38966, 1154, 563, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[39532, 1170, 581, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[40116, 1186, 567, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[40720, 1205, 333, 9, 26, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[41078, 1218, 560, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[41663, 1236, 545, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[42211, 1252, 555, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[42769, 1268, 555, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[43339, 1285, 549, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[43891, 1301, 544, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[44438, 1317, 556, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[44997, 1333, 547, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[45547, 1349, 553, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[46103, 1365, 551, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[46657, 1381, 546, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[47240, 1400, 566, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[47809, 1416, 557, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[48369, 1432, 561, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[48933, 1448, 575, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[49533, 1466, 567, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[50103, 1482, 556, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[50674, 1499, 564, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[51263, 1517, 547, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[51813, 1533, 549, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[52365, 1549, 555, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[52923, 1565, 549, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[53475, 1581, 551, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[54029, 1597, 559, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[54637, 1617, 567, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[55207, 1633, 552, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[55796, 1652, 568, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[56367, 1668, 562, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[56932, 1684, 562, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[57497, 1700, 567, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[58067, 1716, 565, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[58657, 1734, 549, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[59209, 1750, 551, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[59763, 1766, 552, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[60318, 1782, 561, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[60928, 1802, 567, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[61498, 1818, 558, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[62081, 1836, 564, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[62648, 1852, 320, 6, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[62983, 1861, 572, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[63580, 1879, 558, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[64141, 1895, 573, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[64751, 1914, 570, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[65324, 1930, 572, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[65899, 1946, 552, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[66488, 1965, 561, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[67052, 1981, 576, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[67631, 1997, 552, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[68198, 2014, 562, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[68775, 2031, 567, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[69379, 2050, 327, 9, 26, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[69731, 2063, 840, 21, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[70574, 2086, 574, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[71151, 2102, 563, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[71751, 2121, 841, 21, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[72595, 2144, 574, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[73172, 2160, 584, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[73759, 2176, 572, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[74334, 2192, 561, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[74910, 2209, 562, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[75475, 2225, 574, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[76086, 2244, 326, 9, 26, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[76437, 2257, 559, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[76999, 2273, 564, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[77566, 2289, 565, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[78134, 2305, 562, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[78733, 2324, 568, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[79304, 2340, 563, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[79892, 2358, 559, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[80454, 2374, 558, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[81015, 2390, 558, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[81610, 2409, 564, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[82177, 2425, 555, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[82735, 2441, 557, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[83295, 2457, 565, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[83897, 2476, 557, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[84457, 2492, 576, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[85036, 2508, 574, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[85613, 2524, 561, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[86223, 2544, 567, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[86793, 2560, 562, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[87358, 2576, 308, 6, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[87715, 2588, 323, 9, 26, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[88041, 2599, 561, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[88627, 2617, 579, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[89209, 2633, 564, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[89776, 2649, 558, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[90371, 2668, 582, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[90956, 2684, 563, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[91522, 2700, 568, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[92105, 2717, 573, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[92703, 2735, 563, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[93269, 2751, 549, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[93821, 2767, 559, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[94383, 2783, 555, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[94941, 2799, 560, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[95504, 2815, 564, 14, 18, "TOCSubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[96083, 2832, 575, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],

Cell[CellGroupData[{
Cell[96695, 2851, 323, 9, 26, "SubsectionIcon",
  CellTags->"LinearAlgebraTOC"],

Cell[CellGroupData[{
Cell[97043, 2864, 565, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"],
Cell[97611, 2880, 551, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[98165, 2896, 550, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[98718, 2912, 559, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[99280, 2928, 558, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[99841, 2944, 550, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[100394, 2960, 550, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"],
Cell[100947, 2976, 552, 14, 18, "TOCSubsubsection",
  CellTags->"LinearAlgebraTOC"]
}, Closed]],
Cell[101514, 2993, 556, 14, 24, "SubsubsectionIcon",
  CellTags->"LinearAlgebraTOC"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

