(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2866352,      79141]*)
(*NotebookOutlinePosition[   2914136,      80092]*)
(*  CellTagsIndexPosition[   2914015,      80085]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["NMinimize", "Chapter",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  StyleBox["NMinimize", "MR"],
  " and ",
  StyleBox["NMaximize", "MR"],
  " implement several algorithms for finding constrained global optima. The \
methods are flexible enough to cope with functions that are not \
differentiable or continuous, and are not easily trapped by local optima. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell["\<\
Keep in mind, however, that finding a global optimum can be \
arbitrarily difficult, even without constraints, and so the methods used may \
fail. It may frequently be useful to optimize the function several times with \
different starting conditions and take the best of the results. \
\>", "Text",\

  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMaximize[\"\>",
                      "MR"], "\[Null]", 
                    StyleBox["f",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["vars",
                      "TI"], 
                    StyleBox["]",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global maximum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" with variables \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMinimize[\"\>",
                      "MR"], "\[Null]", 
                    StyleBox["f",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["vars",
                      "TI"], 
                    StyleBox["]",
                      "MR"], " "}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global minimum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" with variables \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMaximize[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global maximum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" subject to the constraints \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMinimize[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global minimum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" subject to the constraints \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMaximize[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"Method\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\` \[Rule] \)], "InlineFormula"], 
                    StyleBox["\<\"method\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global maximum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" subject to the constraints \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], \(\(,\)\(\ \)\(using\)\(\ \)\), 
                    StyleBox["\<\"method\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMinimize[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"Method\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\` \[Rule] \)], "InlineFormula"], 
                    StyleBox["\<\"method\"\>",
                      "TI"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global minimum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" subject to the constraints \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], \(\(,\)\(\ \)\(using\)\(\ \)\), 
                    StyleBox["\<\"method\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMaximize[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"Method\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\` \[Rule] \)], "InlineFormula"], 
                    Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"method\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"mopts\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global maximum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" subject to the constraints \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], \(\(,\)\(\ \)\(using\)\(\ \)\), 
                    StyleBox["\<\"method\"\>",
                      "TI"], "\<\" with method\[Hyphen]options \"\>", 
                    StyleBox["\<\"mopts\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"NMinimize[\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"f\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"vars\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"Method\"\>",
                      "MR"], Cell[BoxData[
                        \(TraditionalForm\` \[Rule] \)], "InlineFormula"], 
                    Cell[BoxData[
                        \(TraditionalForm\`{\)], "InlineFormula"], 
                    StyleBox["\<\"method\"\>",
                      "TI"], 
                    StyleBox[",",
                      "MR"], "\<\" \"\>", 
                    StyleBox["\<\"mopts\"\>",
                      "TI"], Cell[BoxData[
                        \(TraditionalForm\`}\)], "InlineFormula"], 
                    StyleBox["\<\"]\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{"\<\"find the global minimum of \"\>", 
                    StyleBox["\<\"f\"\>",
                      "TI"], "\<\" subject to the constraints \"\>", 
                    StyleBox["\<\"cons\"\>",
                      "TI"], \(\(,\)\(\ \)\(using\)\(\ \)\), 
                    StyleBox["\<\"method\"\>",
                      "TI"], "\<\" with method\[Hyphen]options \"\>", 
                    StyleBox["\<\"mopts\"\>",
                      "TI"], "\<\" \"\>"}], TraditionalForm]]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell["Numerically finding global optima. ", "Caption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "This finds the maximum of ",
  Cell[BoxData[
      \(TraditionalForm\`sin(x + y) - x\^2 - y\^2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMaximize[Sin[x + y] - x\^2 - y\^2, {x, y}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.40048861211337894`, {x \[Rule] 0.3695425666075804`, 
        y \[Rule] 0.3695425666075804`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "This finds the minimum of ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + \((y - 1\/2)\)\^2\)], "InlineFormula"],
  " subject to the constraints ",
  Cell[BoxData[
      \(TraditionalForm\`y \[GreaterEqual] 0\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y \[GreaterEqual] x + 1\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2 + \((y -  .5)\)\^2, 
        y \[GreaterEqual] 0 && y \[GreaterEqual] x + 1}, {x, y}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.12499999906867741`, {x \[Rule] \(-0.24999999906879697`\), 
        y \[Rule] 0.7499999990685579`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "The constraints may be either a list or logical combination of equalities, \
inequalities, and domain specifications. Equalities and inequalities may be \
nonlinear. Any strong inequalities will be converted to weak inequalities due \
to limits of working with approximate numbers. Specify domains using ",
  StyleBox["Element", "MR"],
  "\[LongDash]for example, ",
  StyleBox["Element[x,", "MR"],
  " ",
  StyleBox["Integers]", "MR"],
  " or ",
  StyleBox["x", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[Element] \)], "InlineFormula"],
  " ",
  StyleBox["Integers", "MR"],
  ". Currently only ",
  StyleBox["Integers", "MR"],
  " and ",
  StyleBox["Reals", "MR"],
  " (default) are accepted, and only variables may be given a domain. \
Constraints are generally enforced by adding penalties when points leave the \
feasible region. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "Constraints can contain logical operators like ",
  StyleBox["And", "MR"],
  ", ",
  StyleBox["Or", "MR"],
  ", and so on. "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2 + y\^2, 
        x \[GreaterEqual] 1 || y \[GreaterEqual] 2}, {x, y}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({1.`, {x \[Rule] 1.`, y \[Rule] 0.`}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "Here ",
  Cell[BoxData[
      \(TraditionalForm\`x\)], "InlineFormula"],
  " is restricted to being an integer. "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{\((x - 1/3)\)\^2 + \((y - 1/3)\)\^2, 
        x \[Element] Integers}, {x, y}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.1111111111111111`, {x \[Rule] 0, 
        y \[Rule] 0.3333333333333333`}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "In order for ",
  StyleBox["NMinimize", "MR"],
  " to work, it needs a rectangular initial region in which to start. This is \
similar to giving other numerical methods a starting point or starting \
points. The initial region is specified by giving each variable a finite \
upper and lower bound. This is done by including ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] x \[LessEqual] b\)], 
    "InlineFormula"],
  " in the constraints, or ",
  Cell[BoxData[
      \(TraditionalForm\`{\)], "InlineFormula"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula"],
  " in the variables. If both are given, the bounds in the variables are used \
for the initial region, and the constraints are just used as constraints. If \
no initial region is specified for a variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)], "InlineFormula"],
  ", the default initial region of ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] x \[LessEqual] 1\)], 
    "InlineFormula"],
  " is used. Different variables can have initial regions defined in \
different ways. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell["\<\
Here the initial region is taken from the variables. The problem is \
unconstrained. \
\>", "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[x\^2, {{x, 3, 4}}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.`, {x \[Rule] 0.`}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell["Here the initial region is taken from the constraints. ", "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2, 3 \[LessEqual] x \[LessEqual] 4}, {x}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({9.`, {x \[Rule] 3.`}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "Here the initial region for ",
  Cell[BoxData[
      \(TraditionalForm\`x\)], "InlineFormula"],
  " is taken from the constraints, the initial region for ",
  Cell[BoxData[
      \(TraditionalForm\`y\)], "InlineFormula"],
  " is taken from the variables, and the initial region for ",
  Cell[BoxData[
      \(TraditionalForm\`z\)], "InlineFormula"],
  " is taken to be the default. The problem is unconstrained in ",
  Cell[BoxData[
      \(TraditionalForm\`y\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`z\)], "InlineFormula"],
  ", but not ",
  Cell[BoxData[
      \(TraditionalForm\`x\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2 + y\^2 + z\^2, 
        3 \[LessEqual] x \[LessEqual] 4}, {x, {y, 2, 5}, z}]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({9.`, {x \[Rule] 3.`, y \[Rule] 0.`, z \[Rule] 0.`}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "SO10"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "SO10"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["AccuracyGoal",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"goal for accuracy of solution "\)]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"EvaluationMonitor\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"None\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`expression\ to\ evaluate\ at\ each\ \
function\ evaluation\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MaxIterations\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"100\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"maximum number of iterations "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Method\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"which method to use for minimization \
"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"PrecisionGoal\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"goal for precision of solution "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"StepMonitor\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"None\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`expression\ to\ evaluate\ at\ each\ \
step\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"WorkingPrecision\"\>",
                      "MR"], 
                    StyleBox["\<\" \"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"MachinePrecision\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"number of digits of precision to use \
"\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  StyleBox["NMinimize", "MR"],
  " options. "
}], "Caption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "The polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`4  x\^4 - 4  x\^2 + 1\)]],
  " has global minima at ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] \(\[PlusMinus]\(\(\@2\/2\)\(.\)\)\)\)]],
  " ",
  StyleBox["NelderMead", "MR"],
  " finds one of the minima."
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[4  x\^4 - 4  x\^2 + 1, \ x, \ 
      Method -> "\<NelderMead\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.`, {x \[Rule] \(-0.7071067816241212`\)}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "We can find the other minimum by using a different ",
  StyleBox["RandomSeed", "MR"],
  "."
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[4  x\^4 - 4  x\^2 + 1, \ x, \ 
      Method \[Rule] {"\<NelderMead\>", \ "\<RandomSeed\>" \[Rule] 
            101}]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.`, {x \[Rule] 0.7071067811735079`}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  StyleBox["NMinimize", "MR"],
  " and ",
  StyleBox["NMaximize", "MR"],
  " have several optimization methods available: ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["DifferentialEvolution", "MR"],
  ", ",
  StyleBox["NelderMead", "MR"],
  ", ",
  StyleBox["RandomSearch", "MR"],
  ", and ",
  StyleBox["SimulatedAnnealing", "MR"],
  ". The optimization method is controlled by the ",
  StyleBox["Method", "MR"],
  " option, which either takes the method as a string, or takes a list whose \
first element is the method as a string and whose remaining elements are \
method\[Hyphen]specific options. All method\[Hyphen]specific option left\
\[Hyphen]hand sides should also be given as strings."
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell["The following function has a large number of local minima.", \
"MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[f];\)\), "\[IndentingNewLine]", 
    \(\(f = \[ExponentialE]\^Sin[50\ x] + Sin[60\ \[ExponentialE]\^y] + 
          Sin[70\ Sin[x]] + Sin[Sin[80\ y]] - Sin[10\ \((x + y)\)] + 
          1\/4\ \((x\^2 + y\^2)\);\)\), "\[IndentingNewLine]", 
    \(Plot3D[f, \ {x, \ \(-1\), \ 1}, \ {y, \ \(-1\), \ 1}, \ 
      PlotPoints \[Rule] 50, \ Mesh \[Rule] False]\)}], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.55061e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -23.5978 -9 ]
[.17646 .18758 .40224 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -15.8219 -9 ]
[.50253 .05935 2.17811 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 24 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 18 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02111 .28391 -12 -2.75819 ]
[.02111 .28391 0 6.24181 ]
[.01372 .33023 -6 -2.7974 ]
[.01372 .33023 0 6.2026 ]
[.00611 .37796 -6 -2.83791 ]
[.00611 .37796 0 6.16209 ]
[-0.00174 .42716 -6 -2.87981 ]
[-0.00174 .42716 0 6.12019 ]
[-0.00984 .4779 -6 -2.92315 ]
[-0.00984 .4779 0 6.07685 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-1)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-0.5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(0.5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-1)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-0.5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(0.5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(1)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03335 .27917 m
.03947 .2768 L
s
[(-2)] .02111 .28391 1 -0.38707 Mshowa
.026 .32559 m
.03213 .32326 L
s
[(0)] .01372 .33023 1 -0.37836 Mshowa
.01842 .37341 m
.02457 .37114 L
s
[(2)] .00611 .37796 1 -0.36935 Mshowa
.0106 .42271 m
.01678 .42049 L
s
[(4)] -0.00174 .42716 1 -0.36004 Mshowa
.00255 .47356 m
.00874 .47139 L
s
[(6)] -0.00984 .4779 1 -0.35041 Mshowa
.125 Mabswid
.03153 .29065 m
.03521 .28923 L
s
.0297 .30221 m
.03338 .3008 L
s
.02786 .31385 m
.03153 .31245 L
s
.02412 .33741 m
.02781 .33602 L
s
.02224 .34932 m
.02592 .34794 L
s
.02033 .36132 m
.02402 .35995 L
s
.01649 .38559 m
.02018 .38424 L
s
.01454 .39787 m
.01824 .39652 L
s
.01258 .41024 m
.01628 .4089 L
s
.00861 .43528 m
.01232 .43395 L
s
.00661 .44794 m
.01032 .44662 L
s
.00458 .4607 m
.0083 .45939 L
s
.03516 .26778 m
.03883 .26635 L
s
.03695 .25647 m
.04061 .25504 L
s
.00049 .48652 m
.00421 .48522 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.605 .333 .477 r
.39525 .69692 .40305 .66309 .4134 .66862 .40572 .70269 Mtetra
.333 .087 .383 r
.40572 .70269 .4134 .66862 .42445 .65334 .417 .68569 Mtetra
.522 .252 .446 r
.417 .68569 .42445 .65334 .4351 .65259 .42785 .68238 Mtetra
.376 .114 .384 r
.42785 .68238 .4351 .65259 .44599 .64341 .43898 .6697 Mtetra
.18 0 .284 r
.43898 .6697 .44599 .64341 .45701 .62819 .45022 .65068 Mtetra
.727 .429 .474 r
.45022 .65068 .45701 .62819 .46734 .65225 .46067 .67203 Mtetra
.52 .21 .381 r
.46067 .67203 .46734 .65225 .4782 .65321 .47166 .67074 Mtetra
.193 0 .21 r
.47166 .67074 .4782 .65321 .48925 .64193 .48285 .65832 Mtetra
.731 .41 .437 r
.48285 .65832 .48925 .64193 .50009 .65882 .49375 .67597 Mtetra
.69 .367 .424 r
.49375 .67597 .50009 .65882 .51113 .66924 .50486 .68848 Mtetra
.491 .178 .362 r
.50486 .68848 .51113 .66924 .52232 .66349 .51615 .68568 Mtetra
0 0 .152 r
.51615 .68568 .52232 .66349 .53348 .63702 .52748 .66236 Mtetra
.797 .503 .49 r
.52748 .66236 .53348 .63702 .54492 .67744 .53899 .70739 Mtetra
0 0 .2 r
.53899 .70739 .54492 .67744 .55601 .6421 .5503 .6744 Mtetra
0 0 .057 r
.5503 .6744 .55601 .6421 .56678 .59367 .56131 .62684 Mtetra
.832 .546 .504 r
.56131 .62684 .56678 .59367 .57925 .67066 .57384 .70651 Mtetra
.921 .771 .29 r
.57384 .70651 .57925 .67066 .58905 .57602 .58391 .60865 Mtetra
.651 .368 .478 r
.58391 .60865 .58905 .57602 .60072 .59068 .59568 .62155 Mtetra
.714 .424 .483 r
.59568 .62155 .60072 .59068 .61288 .61791 .60788 .64628 Mtetra
0 0 0 r
.60788 .64628 .61288 .61791 .6232 .57283 .6183 .5967 Mtetra
.618 .316 .435 r
.6183 .5967 .6232 .57283 .63506 .58267 .63017 .60334 Mtetra
.717 .4 .441 r
.63017 .60334 .63506 .58267 .64745 .60362 .64257 .62195 Mtetra
.609 .283 .393 r
.64257 .62195 .64745 .60362 .6595 .61029 .65467 .62719 Mtetra
.872 .801 .313 r
.65467 .62719 .6595 .61029 .66937 .56305 .66469 .57914 Mtetra
.901 .59 .45 r
.66469 .57914 .66937 .56305 .68537 .65428 .68079 .67323 Mtetra
.944 .8 .344 r
.68079 .67323 .68537 .65428 .69411 .5848 .68982 .60525 Mtetra
.745 .423 .438 r
.68982 .60525 .69411 .5848 .70718 .60469 .70319 .62905 Mtetra
.637 .331 .435 r
.70319 .62905 .70718 .60469 .71964 .60991 .716 .63824 Mtetra
.454 .183 .412 r
.716 .63824 .71964 .60991 .73118 .59818 .72791 .62977 Mtetra
.11 0 .323 r
.72791 .62977 .73118 .59818 .74135 .56506 .73841 .59842 Mtetra
.627 .342 .466 r
.73841 .59842 .74135 .56506 .75416 .57331 .75148 .60819 Mtetra
.604 .325 .466 r
.75148 .60819 .75416 .57331 .76698 .5799 .76447 .61473 Mtetra
0 0 .019 r
.76447 .61473 .76698 .5799 .77396 .50669 .77148 .53798 Mtetra
.821 .513 .468 r
.77148 .53798 .77396 .50669 .79125 .57079 .78876 .60084 Mtetra
0 0 .214 r
.78876 .60084 .79125 .57079 .80047 .52989 .79784 .55549 Mtetra
.393 .127 .387 r
.79784 .55549 .80047 .52989 .81227 .52165 .80949 .54351 Mtetra
.753 .425 .429 r
.80949 .54351 .81227 .52165 .82746 .55104 .82456 .57035 Mtetra
.283 .007 .306 r
.82456 .57035 .82746 .55104 .83913 .53953 .83617 .55657 Mtetra
.674 .327 .379 r
.83617 .55657 .83913 .53953 .8531 .55172 .8502 .56828 Mtetra
.361 .05 .297 r
.8502 .56828 .8531 .55172 .86507 .54238 .86238 .55963 Mtetra
.795 .445 .393 r
.86238 .55963 .86507 .54238 .88105 .57113 .87874 .59114 Mtetra
.41 .114 .349 r
.87874 .59114 .88105 .57113 .89295 .55962 .89114 .58277 Mtetra
.139 0 .306 r
.89114 .58277 .89295 .55962 .90301 .53181 .90176 .55824 Mtetra
.781 .454 .434 r
.90176 .55824 .90301 .53181 .92017 .56597 .91957 .597 Mtetra
.282 .063 .394 r
.91957 .597 .92017 .56597 .93035 .53929 .93027 .57276 Mtetra
.199 .012 .387 r
.93027 .57276 .93035 .53929 .93955 .50576 .93983 .54023 Mtetra
.663 .367 .459 r
.93983 .54023 .93955 .50576 .95497 .52203 .95555 .55734 Mtetra
.31 .098 .422 r
.95555 .55734 .95497 .52203 .96524 .49775 .96582 .53126 Mtetra
.522 .253 .448 r
.96582 .53126 .96524 .49775 .97849 .49611 .97894 .52712 Mtetra
.503 .389 .657 r
.38988 .66288 .39525 .69692 .40572 .70269 .40023 .66989 Mtetra
.701 .53 .653 r
.40023 .66989 .40572 .70269 .417 .68569 .41147 .65303 Mtetra
.623 .477 .662 r
.41147 .65303 .417 .68569 .42785 .68238 .42231 .64826 Mtetra
.689 .519 .651 r
.42231 .64826 .42785 .68238 .43898 .6697 .43346 .63308 Mtetra
.715 .533 .642 r
.43346 .63308 .43898 .6697 .45022 .65068 .44474 .61095 Mtetra
.39 .298 .63 r
.44474 .61095 .45022 .65068 .46067 .67203 .45515 .62827 Mtetra
.611 .45 .639 r
.45515 .62827 .46067 .67203 .47166 .67074 .4661 .62371 Mtetra
.66 .482 .632 r
.4661 .62371 .47166 .67074 .48285 .65832 .47723 .60917 Mtetra
.449 .327 .621 r
.47723 .60917 .48285 .65832 .49375 .67597 .488 .62527 Mtetra
.487 .353 .624 r
.488 .62527 .49375 .67597 .50486 .68848 .49897 .63777 Mtetra
.585 .425 .63 r
.49897 .63777 .50486 .68848 .51615 .68568 .51014 .63672 Mtetra
.68 .495 .628 r
.51014 .63672 .51615 .68568 .52748 .66236 .52138 .61667 Mtetra
0 0 .495 r
.52138 .61667 .52748 .66236 .53899 .70739 .53272 .66423 Mtetra
.725 .532 .629 r
.53272 .66423 .53899 .70739 .5503 .6744 .54402 .63532 Mtetra
.779 .572 .621 r
.54402 .63532 .5503 .6744 .56131 .62684 .55506 .5914 Mtetra
.811 .555 0 r
.55506 .5914 .56131 .62684 .57384 .70651 .56738 .67178 Mtetra
.868 .635 .584 r
.56738 .67178 .57384 .70651 .58391 .60865 .57758 .57575 Mtetra
.444 .356 .662 r
.57758 .57575 .58391 .60865 .59568 .62155 .58924 .5875 Mtetra
.287 .245 .636 r
.58924 .5875 .59568 .62155 .60788 .64628 .60128 .60955 Mtetra
.806 .592 .613 r
.60128 .60955 .60788 .64628 .6183 .5967 .61164 .55752 Mtetra
.557 .42 .65 r
.61164 .55752 .6183 .5967 .63017 .60334 .6233 .56037 Mtetra
.454 .342 .638 r
.6233 .56037 .63017 .60334 .64257 .62195 .63545 .57505 Mtetra
.564 .415 .637 r
.63545 .57505 .64257 .62195 .65467 .62719 .64732 .5773 Mtetra
.765 .551 .609 r
.64732 .5773 .65467 .62719 .66469 .57914 .65727 .52868 Mtetra
0 0 .257 r
.65727 .52868 .66469 .57914 .68079 .67323 .67298 .6202 Mtetra
.791 .568 .597 r
.67298 .6202 .68079 .67323 .68982 .60525 .68212 .55504 Mtetra
.379 .282 .618 r
.68212 .55504 .68982 .60525 .70319 .62905 .69542 .5807 Mtetra
.493 .365 .634 r
.69542 .5807 .70319 .62905 .716 .63824 .70826 .59298 Mtetra
.609 .449 .64 r
.70826 .59298 .716 .63824 .72791 .62977 .72029 .58825 Mtetra
.725 .531 .629 r
.72029 .58825 .72791 .62977 .73841 .59842 .73097 .56067 Mtetra
.471 .367 .655 r
.73097 .56067 .73841 .59842 .75148 .60819 .74408 .57263 Mtetra
.512 .4 .663 r
.74408 .57263 .75148 .60819 .76447 .61473 .75706 .58014 Mtetra
.862 .626 .581 r
.75706 .58014 .76447 .61473 .77148 .53798 .76416 .50407 Mtetra
0 0 .399 r
.76416 .50407 .77148 .53798 .78876 .60084 .78107 .56414 Mtetra
.803 .587 .609 r
.78107 .56414 .78876 .60084 .79784 .55549 .78996 .51652 Mtetra
.677 .502 .642 r
.78996 .51652 .79784 .55549 .80949 .54351 .80126 .50113 Mtetra
.385 .302 .638 r
.80126 .50113 .80949 .54351 .82456 .57035 .81581 .52369 Mtetra
.668 .487 .631 r
.81581 .52369 .82456 .57035 .83617 .55657 .82706 .50696 Mtetra
.522 .385 .636 r
.82706 .50696 .83617 .55657 .8502 .56828 .84071 .51614 Mtetra
.627 .453 .628 r
.84071 .51614 .8502 .56828 .86238 .55963 .8527 .50681 Mtetra
.364 .275 .62 r
.8527 .50681 .86238 .55963 .87874 .59114 .86885 .53814 Mtetra
.611 .442 .629 r
.86885 .53814 .87874 .59114 .89114 .58277 .88136 .53198 Mtetra
.679 .49 .623 r
.88136 .53198 .89114 .58277 .90176 .55824 .89227 .51104 Mtetra
.238 .199 .61 r
.89227 .51104 .90176 .55824 .91957 .597 .91023 .55257 Mtetra
.688 .503 .631 r
.91023 .55257 .91957 .597 .93027 .57276 .92132 .53232 Mtetra
.735 .538 .626 r
.92132 .53232 .93027 .57276 .93983 .54023 .93124 .50313 Mtetra
.414 .336 .66 r
.93124 .50313 .93983 .54023 .95555 .55734 .94703 .5216 Mtetra
.735 .545 .635 r
.94703 .5216 .95555 .55734 .96582 .53126 .95732 .49607 Mtetra
.621 .475 .662 r
.95732 .49607 .96582 .53126 .97894 .52712 .97021 .49065 Mtetra
.627 .358 .491 r
.38161 .7017 .38988 .66288 .40023 .66989 .39199 .71171 Mtetra
.4 .157 .426 r
.39199 .71171 .40023 .66989 .41147 .65303 .40339 .69593 Mtetra
.52 .265 .468 r
.40339 .69593 .41147 .65303 .42231 .64826 .41441 .69114 Mtetra
.393 .153 .427 r
.41441 .69114 .42231 .64826 .43346 .63308 .42581 .67417 Mtetra
.257 .035 .374 r
.42581 .67417 .43346 .63308 .44474 .61095 .43738 .64889 Mtetra
.652 .38 .494 r
.43738 .64889 .44474 .61095 .45515 .62827 .44798 .66338 Mtetra
.47 .208 .434 r
.44798 .66338 .45515 .62827 .4661 .62371 .45916 .65517 Mtetra
.289 .043 .356 r
.45916 .65517 .4661 .62371 .47723 .60917 .47051 .63716 Mtetra
.669 .379 .471 r
.47051 .63716 .47723 .60917 .488 .62527 .48141 .65137 Mtetra
.657 .362 .46 r
.48141 .65137 .488 .62527 .49897 .63777 .49248 .66318 Mtetra
.54 .247 .418 r
.49248 .66318 .49897 .63777 .51014 .63672 .50378 .66264 Mtetra
.201 0 .293 r
.50378 .66264 .51014 .63672 .52138 .61667 .51518 .64412 Mtetra
.805 .513 .494 r
.51518 .64412 .52138 .61667 .53272 .66423 .52657 .69586 Mtetra
.137 0 .3 r
.52657 .69586 .53272 .66423 .54402 .63532 .53808 .67 Mtetra
0 0 .179 r
.53808 .67 .54402 .63532 .55506 .5914 .54937 .62865 Mtetra
.829 .545 .508 r
.54937 .62865 .55506 .5914 .56738 .67178 .56179 .71461 Mtetra
.834 .723 .195 r
.56179 .71461 .56738 .67178 .57758 .57575 .57234 .61781 Mtetra
.635 .365 .491 r
.57234 .61781 .57758 .57575 .58924 .5875 .58418 .63064 Mtetra
.675 .401 .498 r
.58418 .63064 .58924 .5875 .60128 .60955 .59637 .6526 Mtetra
0 0 .202 r
.59637 .6526 .60128 .60955 .61164 .55752 .60693 .59686 Mtetra
.556 .291 .469 r
.60693 .59686 .61164 .55752 .6233 .56037 .61869 .59671 Mtetra
.635 .355 .478 r
.61869 .59671 .6233 .56037 .63545 .57505 .63089 .60823 Mtetra
.543 .269 .449 r
.63089 .60823 .63545 .57505 .64732 .5773 .6428 .60709 Mtetra
0 0 .014 r
.6428 .60709 .64732 .5773 .65727 .52868 .65285 .55472 Mtetra
.87 .568 .473 r
.65285 .55472 .65727 .52868 .67298 .6202 .66857 .64668 Mtetra
.801 .72 .187 r
.66857 .64668 .67298 .6202 .68212 .55504 .67789 .58009 Mtetra
.745 .433 .456 r
.67789 .58009 .68212 .55504 .69542 .5807 .69139 .60773 Mtetra
.674 .369 .45 r
.69139 .60773 .69542 .5807 .70826 .59298 .70452 .62303 Mtetra
.539 .256 .435 r
.70452 .62303 .70826 .59298 .72029 .58825 .71692 .62183 Mtetra
.257 .036 .375 r
.71692 .62183 .72029 .58825 .73097 .56067 .72801 .59741 Mtetra
.656 .37 .475 r
.72801 .59741 .73097 .56067 .74408 .57263 .74155 .61328 Mtetra
.621 .345 .478 r
.74155 .61328 .74408 .57263 .75706 .58014 .75491 .62372 Mtetra
0 0 .153 r
.75491 .62372 .75706 .58014 .76416 .50407 .76227 .54656 Mtetra
.787 .491 .486 r
.76227 .54656 .76416 .50407 .78107 .56414 .77944 .60837 Mtetra
.032 0 .343 r
.77944 .60837 .78107 .56414 .78996 .51652 .78838 .55759 Mtetra
.402 .17 .443 r
.78838 .55759 .78996 .51652 .80126 .50113 .79964 .53894 Mtetra
.671 .382 .474 r
.79964 .53894 .80126 .50113 .81581 .52369 .81413 .55863 Mtetra
.343 .112 .413 r
.81413 .55863 .81581 .52369 .82706 .50696 .82523 .53786 Mtetra
.602 .311 .447 r
.82523 .53786 .82706 .50696 .84071 .51614 .83878 .54418 Mtetra
.415 .151 .402 r
.83878 .54418 .84071 .51614 .8527 .50681 .85073 .53259 Mtetra
.756 .432 .435 r
.85073 .53259 .8527 .50681 .86885 .53814 .86701 .56394 Mtetra
.484 .198 .403 r
.86701 .56394 .86885 .53814 .88136 .53198 .87977 .55853 Mtetra
.293 .052 .367 r
.87977 .55853 .88136 .53198 .89227 .51104 .89108 .53942 Mtetra
.796 .469 .436 r
.89108 .53942 .89227 .51104 .91023 .55257 .90967 .58538 Mtetra
.386 .143 .418 r
.90967 .58538 .91023 .55257 .92132 .53232 .92139 .56856 Mtetra
.305 .091 .416 r
.92139 .56856 .92132 .53232 .93124 .50313 .93192 .54238 Mtetra
.677 .382 .467 r
.93192 .54238 .93124 .50313 .94703 .5216 .94838 .56458 Mtetra
.374 .156 .45 r
.94838 .56458 .94703 .5216 .95732 .49607 .9591 .54017 Mtetra
.526 .271 .471 r
.9591 .54017 .95732 .49607 .97021 .49065 .97228 .535 Mtetra
.341 .302 .669 r
.37592 .6747 .38161 .7017 .39199 .71171 .38611 .68796 Mtetra
.708 .557 .681 r
.38611 .68796 .39199 .71171 .40339 .69593 .39741 .67489 Mtetra
.627 .519 .712 r
.39741 .67489 .40339 .69593 .41441 .69114 .40836 .67152 Mtetra
.752 .599 .687 r
.40836 .67152 .41441 .69114 .42581 .67417 .41977 .65459 Mtetra
.798 .623 .665 r
.41977 .65459 .42581 .67417 .43738 .64889 .4314 .62798 Mtetra
.303 .313 .705 r
.4314 .62798 .43738 .64889 .44798 .66338 .44201 .63968 Mtetra
.698 .551 .684 r
.44201 .63968 .44798 .66338 .45916 .65517 .45325 .62808 Mtetra
.743 .569 .658 r
.45325 .62808 .45916 .65517 .47051 .63716 .46464 .60661 Mtetra
.434 .354 .666 r
.46464 .60661 .47051 .63716 .48141 .65137 .47551 .61735 Mtetra
.474 .372 .658 r
.47551 .61735 .48141 .65137 .49248 .66318 .48652 .62657 Mtetra
.593 .448 .654 r
.48652 .62657 .49248 .66318 .50378 .66264 .49775 .62491 Mtetra
.693 .516 .643 r
.49775 .62491 .50378 .66264 .51518 .64412 .50911 .60702 Mtetra
0 0 .331 r
.50911 .60702 .51518 .64412 .52657 .69586 .52033 .65971 Mtetra
.719 .536 .642 r
.52033 .65971 .52657 .69586 .53808 .67 .53182 .63712 Mtetra
.781 .582 .631 r
.53182 .63712 .53808 .67 .54937 .62865 .54314 .59975 Mtetra
.934 .639 .172 r
.54314 .59975 .54937 .62865 .56179 .71461 .55538 .6884 Mtetra
.888 .656 .582 r
.55538 .6884 .56179 .71461 .57234 .61781 .5661 .59542 Mtetra
.27 .286 .693 r
.5661 .59542 .57234 .61781 .58418 .63064 .57792 .61007 Mtetra
0 .08 .613 r
.57792 .61007 .58418 .63064 .59637 .6526 .59007 .63243 Mtetra
.875 .661 .61 r
.59007 .63243 .59637 .6526 .60693 .59686 .60068 .57608 Mtetra
.613 .515 .719 r
.60068 .57608 .60693 .59686 .61869 .59671 .61236 .57364 Mtetra
.444 .397 .711 r
.61236 .57364 .61869 .59671 .63089 .60823 .62441 .58179 Mtetra
.631 .502 .687 r
.62441 .58179 .63089 .60823 .6428 .60709 .63617 .57694 Mtetra
.837 .619 .608 r
.63617 .57694 .6428 .60709 .65285 .55472 .64613 .5217 Mtetra
.818 .547 0 r
.64613 .5217 .65285 .55472 .66857 .64668 .66148 .60944 Mtetra
.836 .61 .596 r
.66148 .60944 .66857 .64668 .67789 .58009 .6708 .5422 Mtetra
.263 .222 .623 r
.6708 .5422 .67789 .58009 .69139 .60773 .68414 .56914 Mtetra
.418 .329 .647 r
.68414 .56914 .69139 .60773 .70452 .62303 .69721 .58542 Mtetra
.568 .433 .657 r
.69721 .58542 .70452 .62303 .71692 .62183 .70967 .58675 Mtetra
.714 .534 .644 r
.70967 .58675 .71692 .62183 .72801 .59741 .72094 .56603 Mtetra
.327 .287 .661 r
.72094 .56603 .72801 .59741 .74155 .61328 .7346 .58537 Mtetra
.391 .344 .686 r
.7346 .58537 .74155 .61328 .75491 .62372 .74812 .59908 Mtetra
.894 .66 .576 r
.74812 .59908 .75491 .62372 .76227 .54656 .75577 .52493 Mtetra
.756 .451 0 r
.75577 .52493 .76227 .54656 .77944 .60837 .77288 .58745 Mtetra
.878 .662 .606 r
.77288 .58745 .77944 .60837 .78838 .55759 .78186 .5366 Mtetra
.772 .608 .676 r
.78186 .5366 .78838 .55759 .79964 .53894 .793 .51625 Mtetra
.282 .299 .701 r
.793 .51625 .79964 .53894 .81413 .55863 .80717 .53278 Mtetra
.768 .588 .655 r
.80717 .53278 .81413 .55863 .82523 .53786 .81796 .50855 Mtetra
.553 .445 .685 r
.81796 .50855 .82523 .53786 .83878 .54418 .8311 .51103 Mtetra
.687 .52 .655 r
.8311 .51103 .83878 .54418 .85073 .53259 .84271 .49636 Mtetra
.265 .235 .638 r
.84271 .49636 .85073 .53259 .86701 .56394 .85859 .52495 Mtetra
.622 .467 .651 r
.85859 .52495 .86701 .56394 .87977 .55853 .87119 .51876 Mtetra
.688 .509 .639 r
.87119 .51876 .87977 .55853 .89108 .53942 .88254 .50064 Mtetra
.053 .087 .578 r
.88254 .50064 .89108 .53942 .90967 .58538 .90113 .54791 Mtetra
.668 .501 .649 r
.90113 .54791 .90967 .58538 .92139 .56856 .91318 .53452 Mtetra
.725 .543 .644 r
.91318 .53452 .92139 .56856 .93192 .54238 .92416 .51235 Mtetra
.254 .251 .663 r
.92416 .51235 .93192 .54238 .94838 .56458 .94096 .53792 Mtetra
.75 .577 .661 r
.94096 .53792 .94838 .56458 .9591 .54017 .95207 .51663 Mtetra
.619 .512 .711 r
.95207 .51663 .9591 .54017 .97228 .535 .96546 .51321 Mtetra
.671 .395 .494 r
.36746 .71039 .37592 .6747 .38611 .68796 .3776 .72786 Mtetra
.46 .203 .437 r
.3776 .72786 .38611 .68796 .39741 .67489 .38896 .71806 Mtetra
.551 .291 .474 r
.38896 .71806 .39741 .67489 .40836 .67152 .4 .71746 Mtetra
.415 .173 .436 r
.4 .71746 .40836 .67152 .41977 .65459 .41159 .70161 Mtetra
.273 .054 .388 r
.41159 .70161 .41977 .65459 .4314 .62798 .42348 .67427 Mtetra
.621 .358 .497 r
.42348 .67427 .4314 .62798 .44201 .63968 .43428 .68501 Mtetra
.43 .186 .441 r
.43428 .68501 .44201 .63968 .45325 .62808 .44579 .67048 Mtetra
.267 .044 .379 r
.44579 .67048 .45325 .62808 .46464 .60661 .45748 .64503 Mtetra
.609 .337 .479 r
.45748 .64503 .46464 .60661 .47551 .61735 .46855 .6525 Mtetra
.603 .326 .47 r
.46855 .6525 .47551 .61735 .48652 .62657 .47974 .65876 Mtetra
.508 .233 .432 r
.47974 .65876 .48652 .62657 .49775 .62491 .49114 .65479 Mtetra
.242 0 .327 r
.49114 .65479 .49775 .62491 .50911 .60702 .50269 .63554 Mtetra
.807 .515 .495 r
.50269 .63554 .50911 .60702 .52033 .65971 .51394 .68998 Mtetra
.213 0 .318 r
.51394 .68998 .52033 .65971 .53182 .63712 .52561 .66887 Mtetra
0 0 .187 r
.52561 .66887 .53182 .63712 .54314 .59975 .53717 .6337 Mtetra
.847 .559 .502 r
.53717 .6337 .54314 .59975 .55538 .6884 .54945 .72862 Mtetra
.847 .738 .217 r
.54945 .72862 .55538 .6884 .5661 .59542 .56053 .6368 Mtetra
.662 .385 .491 r
.56053 .6368 .5661 .59542 .57792 .61007 .57257 .65517 Mtetra
.683 .408 .499 r
.57257 .65517 .57792 .61007 .59007 .63243 .58493 .68048 Mtetra
0 0 .239 r
.58493 .68048 .59007 .63243 .60068 .57608 .59583 .62298 Mtetra
.535 .28 .475 r
.59583 .62298 .60068 .57608 .61236 .57364 .60771 .61969 Mtetra
.594 .33 .485 r
.60771 .61969 .61236 .57364 .62441 .58179 .6199 .62595 Mtetra
.495 .242 .461 r
.6199 .62595 .62441 .58179 .63617 .57694 .63177 .61778 Mtetra
0 0 .144 r
.63177 .61778 .63617 .57694 .64613 .5217 .64184 .55737 Mtetra
.839 .543 .488 r
.64184 .55737 .64613 .5217 .66148 .60944 .65718 .644 Mtetra
0 0 0 r
.65718 .644 .66148 .60944 .6708 .5422 .6666 .57233 Mtetra
.72 .418 .466 r
.6666 .57233 .6708 .5422 .68414 .56914 .68002 .59838 Mtetra
.675 .373 .455 r
.68002 .59838 .68414 .56914 .69721 .58542 .69325 .615 Mtetra
.574 .283 .436 r
.69325 .615 .69721 .58542 .70967 .58675 .70595 .61785 Mtetra
.318 .074 .377 r
.70595 .61785 .70967 .58675 .72094 .56603 .71755 .59941 Mtetra
.699 .401 .467 r
.71755 .59941 .72094 .56603 .7346 .58537 .73162 .62296 Mtetra
.664 .375 .472 r
.73162 .62296 .7346 .58537 .74812 .59908 .7456 .64112 Mtetra
0 0 .147 r
.7456 .64112 .74812 .59908 .75577 .52493 .75366 .56828 Mtetra
.795 .497 .483 r
.75366 .56828 .75577 .52493 .77288 .58745 .77124 .63561 Mtetra
.073 0 .36 r
.77124 .63561 .77288 .58745 .78186 .5366 .78052 .58438 Mtetra
.403 .176 .452 r
.78052 .58438 .78186 .5366 .793 .51625 .79186 .56316 Mtetra
.637 .361 .485 r
.79186 .56316 .793 .51625 .80717 .53278 .80615 .57859 Mtetra
.333 .121 .435 r
.80615 .57859 .80717 .53278 .81796 .50855 .8169 .5507 Mtetra
.548 .283 .467 r
.8169 .5507 .81796 .50855 .8311 .51103 .82995 .5497 Mtetra
.388 .153 .431 r
.82995 .5497 .8311 .51103 .84271 .49636 .84141 .53097 Mtetra
.706 .402 .459 r
.84141 .53097 .84271 .49636 .85859 .52495 .85723 .55718 Mtetra
.469 .202 .425 r
.85723 .55718 .85859 .52495 .87119 .51876 .86979 .54874 Mtetra
.323 .083 .387 r
.86979 .54874 .87119 .51876 .88254 .50064 .88124 .52953 Mtetra
.803 .475 .434 r
.88124 .52953 .88254 .50064 .90113 .54791 .90018 .57887 Mtetra
.434 .171 .414 r
.90018 .57887 .90113 .54791 .91318 .53452 .91268 .56753 Mtetra
.354 .116 .409 r
.91268 .56753 .91318 .53452 .92416 .51235 .92423 .54824 Mtetra
.718 .408 .453 r
.92423 .54824 .92416 .51235 .94096 .53792 .94181 .5786 Mtetra
.414 .178 .445 r
.94181 .5786 .94096 .53792 .95207 .51663 .95361 .56061 Mtetra
.553 .288 .468 r
.95361 .56061 .95207 .51663 .96546 .51321 .96766 .56031 Mtetra
.318 .245 .615 r
.3623 .67066 .36746 .71039 .3776 .72786 .3722 .69102 Mtetra
.626 .471 .652 r
.3722 .69102 .3776 .72786 .38896 .71806 .38335 .68495 Mtetra
.547 .424 .664 r
.38335 .68495 .38896 .71806 .4 .71746 .3942 .68775 Mtetra
.688 .528 .665 r
.3942 .68775 .4 .71746 .41159 .70161 .40568 .67469 Mtetra
.762 .582 .654 r
.40568 .67469 .41159 .70161 .42348 .67427 .41753 .64899 Mtetra
.388 .345 .688 r
.41753 .64899 .42348 .67427 .43428 .68501 .42827 .65956 Mtetra
.72 .56 .672 r
.42827 .65956 .43428 .68501 .44579 .67048 .4398 .64362 Mtetra
.771 .587 .65 r
.4398 .64362 .44579 .67048 .45748 .64503 .45155 .61571 Mtetra
.53 .423 .677 r
.45155 .61571 .45748 .64503 .46855 .6525 .46261 .61958 Mtetra
.551 .428 .665 r
.46261 .61958 .46855 .6525 .47974 .65876 .47379 .622 Mtetra
.634 .476 .652 r
.47379 .622 .47974 .65876 .49114 .65479 .48516 .61471 Mtetra
.703 .519 .637 r
.48516 .61471 .49114 .65479 .50269 .63554 .49667 .59337 Mtetra
0 0 .399 r
.49667 .59337 .50269 .63554 .51394 .68998 .50774 .64561 Mtetra
.69 .505 .633 r
.50774 .64561 .51394 .68998 .52561 .66887 .51935 .62523 Mtetra
.737 .539 .625 r
.51935 .62523 .52561 .66887 .53717 .6337 .53087 .59246 Mtetra
.845 .592 .05 r
.53087 .59246 .53717 .6337 .54945 .72862 .5429 .68863 Mtetra
.848 .618 .59 r
.5429 .68863 .54945 .72862 .56053 .6368 .5541 .60182 Mtetra
.285 .242 .632 r
.5541 .60182 .56053 .6368 .57257 .65517 .56607 .6235 Mtetra
.096 .122 .598 r
.56607 .6235 .57257 .65517 .58493 .68048 .57837 .65156 Mtetra
.839 .624 .612 r
.57837 .65156 .58493 .68048 .59583 .62298 .58936 .59659 Mtetra
.609 .488 .69 r
.58936 .59659 .59583 .62298 .60771 .61969 .60122 .59385 Mtetra
.506 .425 .698 r
.60122 .59385 .60771 .61969 .6199 .62595 .61334 .59905 Mtetra
.677 .53 .678 r
.61334 .59905 .6199 .62595 .63177 .61778 .62511 .58859 Mtetra
.854 .631 .6 r
.62511 .58859 .63177 .61778 .64184 .55737 .63515 .52561 Mtetra
.807 .535 0 r
.63515 .52561 .64184 .55737 .65718 .644 .6501 .60722 Mtetra
.848 .618 .589 r
.6501 .60722 .65718 .644 .6666 .57233 .65946 .53305 Mtetra
.332 .266 .632 r
.65946 .53305 .6666 .57233 .68002 .59838 .6726 .55573 Mtetra
.45 .342 .64 r
.6726 .55573 .68002 .59838 .69325 .615 .6856 .57028 Mtetra
.558 .414 .641 r
.6856 .57028 .69325 .615 .70595 .61785 .69817 .57279 Mtetra
.672 .491 .633 r
.69817 .57279 .70595 .61785 .71755 .59941 .70978 .55594 Mtetra
.333 .262 .626 r
.70978 .55594 .71755 .59941 .73162 .62296 .72383 .58157 Mtetra
.374 .295 .638 r
.72383 .58157 .73162 .62296 .7456 .64112 .73788 .60285 Mtetra
.841 .61 .589 r
.73788 .60285 .7456 .64112 .75366 .56828 .74629 .53479 Mtetra
0 0 .28 r
.74629 .53479 .75366 .56828 .77124 .63561 .76387 .60462 Mtetra
.828 .612 .611 r
.76387 .60462 .77124 .63561 .78052 .58438 .7734 .55644 Mtetra
.735 .564 .66 r
.7734 .55644 .78052 .58438 .79186 .56316 .78483 .53654 Mtetra
.361 .332 .691 r
.78483 .53654 .79186 .56316 .80615 .57859 .79901 .5514 Mtetra
.786 .596 .643 r
.79901 .5514 .80615 .57859 .8169 .5507 .80962 .5219 Mtetra
.617 .488 .683 r
.80962 .5219 .8169 .5507 .82995 .5497 .82236 .51786 Mtetra
.733 .552 .647 r
.82236 .51786 .82995 .5497 .84141 .53097 .83346 .49565 Mtetra
.339 .288 .653 r
.83346 .49565 .84141 .53097 .85723 .55718 .84875 .51759 Mtetra
.653 .487 .646 r
.84875 .51759 .85723 .55718 .86979 .54874 .86092 .50596 Mtetra
.695 .509 .631 r
.86092 .50596 .86979 .54874 .88124 .52953 .87208 .48483 Mtetra
.127 .126 .586 r
.87208 .48483 .88124 .52953 .90018 .57887 .89064 .53225 Mtetra
.636 .466 .635 r
.89064 .53225 .90018 .57887 .91268 .56753 .90313 .5218 Mtetra
.669 .488 .632 r
.90313 .5218 .91268 .56753 .92423 .54824 .91489 .50497 Mtetra
.288 .24 .629 r
.91489 .50497 .92423 .54824 .94181 .5786 .93264 .53795 Mtetra
.664 .493 .643 r
.93264 .53795 .94181 .5786 .95361 .56061 .94487 .52399 Mtetra
.549 .427 .666 r
.94487 .52399 .95361 .56061 .96766 .56031 .95932 .52736 Mtetra
.856 .44 0 r
.35578 .66083 .3623 .67066 .3722 .69102 .36553 .68352 Mtetra
.643 .701 .888 r
.36553 .68352 .3722 .69102 .38335 .68495 .37658 .68073 Mtetra
0 .2 .615 r
.37658 .68073 .38335 .68495 .3942 .68775 .3873 .68726 Mtetra
.836 .943 .894 r
.3873 .68726 .3942 .68775 .40568 .67469 .39872 .67763 Mtetra
.963 .903 .714 r
.39872 .67763 .40568 .67469 .41753 .64899 .41058 .65444 Mtetra
.748 .342 .281 r
.41058 .65444 .41753 .64899 .42827 .65956 .42132 .6666 Mtetra
.78 .949 .614 r
.42132 .6666 .42827 .65956 .4398 .64362 .43295 .65053 Mtetra
.981 .912 .632 r
.43295 .65053 .4398 .64362 .45155 .61571 .44485 .62092 Mtetra
.463 0 .014 r
.44485 .62092 .45155 .61571 .46261 .61958 .45602 .62217 Mtetra
.158 0 0 r
.45602 .62217 .46261 .61958 .47379 .622 .4673 .62115 Mtetra
.862 .933 .869 r
.4673 .62115 .47379 .622 .48516 .61471 .47877 .61017 Mtetra
.91 .782 .707 r
.47877 .61017 .48516 .61471 .49667 .59337 .49039 .58551 Mtetra
.951 .603 .298 r
.49039 .58551 .49667 .59337 .50774 .64561 .5014 .63539 Mtetra
.847 .708 .71 r
.5014 .63539 .50774 .64561 .51935 .62523 .51306 .61395 Mtetra
.875 .702 .664 r
.51306 .61395 .51935 .62523 .53087 .59246 .52465 .58162 Mtetra
.966 .654 .374 r
.52465 .58162 .53087 .59246 .5429 .68863 .53652 .67967 Mtetra
.937 .712 .573 r
.53652 .67967 .5429 .68863 .5541 .60182 .54791 .59577 Mtetra
.874 .44 .051 r
.54791 .59577 .5541 .60182 .56607 .6235 .55991 .62115 Mtetra
.907 .51 .237 r
.55991 .62115 .56607 .6235 .57837 .65156 .57225 .6531 Mtetra
.981 .797 .583 r
.57225 .6531 .57837 .65156 .58936 .59659 .58345 .60088 Mtetra
.304 0 0 r
.58345 .60088 .58936 .59659 .60122 .59385 .59542 .60015 Mtetra
.62 .17 .161 r
.59542 .60015 .60122 .59385 .61334 .59905 .60762 .60603 Mtetra
0 0 0 r
.60762 .60603 .61334 .59905 .62511 .58859 .61945 .59457 Mtetra
.997 .8 .522 r
.61945 .59457 .62511 .58859 .63515 .52561 .62959 .5288 Mtetra
.933 .603 .388 r
.62959 .5288 .63515 .52561 .6501 .60722 .64437 .60773 Mtetra
.982 .761 .531 r
.64437 .60773 .6501 .60722 .65946 .53305 .65376 .52946 Mtetra
.804 .318 0 r
.65376 .52946 .65946 .53305 .6726 .55573 .66676 .54867 Mtetra
0 .132 .654 r
.66676 .54867 .6726 .55573 .6856 .57028 .67963 .56039 Mtetra
.522 .603 .876 r
.67963 .56039 .6856 .57028 .69817 .57279 .69214 .56125 Mtetra
.82 .7 .732 r
.69214 .56125 .69817 .57279 .70978 .55594 .70378 .54424 Mtetra
0 0 .339 r
.70378 .54424 .70978 .55594 .72383 .58157 .71788 .57119 Mtetra
0 0 .379 r
.71788 .57119 .72383 .58157 .73788 .60285 .73208 .59516 Mtetra
.96 .739 .56 r
.73208 .59516 .73788 .60285 .74629 .53479 .74083 .53044 Mtetra
.949 .592 .264 r
.74083 .53044 .74629 .53479 .76387 .60462 .75864 .60444 Mtetra
.993 .821 .568 r
.75864 .60444 .76387 .60462 .7734 .55644 .76853 .55945 Mtetra
.864 .974 .664 r
.76853 .55945 .7734 .55644 .78483 .53654 .78025 .54194 Mtetra
.769 .323 .193 r
.78025 .54194 .78483 .53654 .79901 .5514 .7946 .55818 Mtetra
.895 .884 .457 r
.7946 .55818 .79901 .5514 .80962 .5219 .8053 .52808 Mtetra
.103 0 0 r
.8053 .52808 .80962 .5219 .82236 .51786 .81796 .5222 Mtetra
.914 .924 .542 r
.81796 .5222 .82236 .51786 .83346 .49565 .82889 .49686 Mtetra
.792 .302 .037 r
.82889 .49686 .83346 .49565 .84875 .51759 .84389 .51527 Mtetra
.916 .934 .805 r
.84389 .51527 .84875 .51759 .86092 .50596 .85575 .49982 Mtetra
.935 .814 .7 r
.85575 .49982 .86092 .50596 .87208 .48483 .86665 .47543 Mtetra
.814 .421 0 r
.86665 .47543 .87208 .48483 .89064 .53225 .88494 .52064 Mtetra
.77 .696 .78 r
.88494 .52064 .89064 .53225 .90313 .5218 .89738 .5094 Mtetra
.814 .701 .741 r
.89738 .5094 .90313 .5218 .91489 .50497 .90926 .49335 Mtetra
0 0 .352 r
.90926 .49335 .91489 .50497 .93264 .53795 .92726 .52854 Mtetra
.785 .744 .815 r
.92726 .52854 .93264 .53795 .94487 .52399 .93995 .51789 Mtetra
.063 .441 .876 r
.93995 .51789 .94487 .52399 .95932 .52736 .95495 .52514 Mtetra
.383 .265 .592 r
.3516 .60372 .35578 .66083 .36553 .68352 .36117 .62663 Mtetra
.576 .409 .619 r
.36117 .62663 .36553 .68352 .37658 .68073 .37198 .62606 Mtetra
.505 .359 .616 r
.37198 .62606 .37658 .68073 .3873 .68726 .38244 .6355 Mtetra
.609 .439 .626 r
.38244 .6355 .3873 .68726 .39872 .67763 .39361 .62959 Mtetra
.679 .494 .628 r
.39361 .62959 .39872 .67763 .41058 .65444 .40527 .61017 Mtetra
.433 .32 .625 r
.40527 .61017 .41058 .65444 .42132 .6666 .41581 .62461 Mtetra
.667 .491 .638 r
.41581 .62461 .42132 .6666 .43295 .65053 .42733 .61016 Mtetra
.733 .54 .631 r
.42733 .61016 .43295 .65053 .44485 .62092 .4392 .58095 Mtetra
.577 .43 .645 r
.4392 .58095 .44485 .62092 .45602 .62217 .45031 .58062 Mtetra
.602 .446 .642 r
.45031 .58062 .45602 .62217 .4673 .62115 .46155 .57687 Mtetra
.662 .484 .634 r
.46155 .57687 .4673 .62115 .47877 .61017 .47299 .5626 Mtetra
.711 .516 .624 r
.47299 .5626 .47877 .61017 .49039 .58551 .48458 .5348 Mtetra
.039 .028 .514 r
.48458 .5348 .49039 .58551 .5014 .63539 .49541 .58008 Mtetra
.681 .488 .619 r
.49541 .58008 .5014 .63539 .51306 .61395 .50698 .55673 Mtetra
.708 .506 .614 r
.50698 .55673 .51306 .61395 .52465 .58162 .51848 .52411 Mtetra
0 0 .171 r
.51848 .52411 .52465 .58162 .53652 .67967 .53003 .61967 Mtetra
.798 .571 .593 r
.53003 .61967 .53652 .67967 .54791 .59577 .54143 .53978 Mtetra
.355 .252 .598 r
.54143 .53978 .54791 .59577 .55991 .62115 .55326 .56726 Mtetra
.263 .189 .583 r
.55326 .56726 .55991 .62115 .57225 .6531 .56544 .60189 Mtetra
.76 .547 .609 r
.56544 .60189 .57225 .6531 .58345 .60088 .57667 .55434 Mtetra
.558 .409 .635 r
.57667 .55434 .58345 .60088 .59542 .60015 .58858 .55653 Mtetra
.512 .381 .64 r
.58858 .55653 .59542 .60015 .60762 .60603 .60071 .56415 Mtetra
.646 .477 .641 r
.60071 .56415 .60762 .60603 .61945 .59457 .61248 .55336 Mtetra
.822 .597 .597 r
.61248 .55336 .61945 .59457 .62959 .5288 .62264 .48779 Mtetra
0 0 .232 r
.62264 .48779 .62959 .5288 .64437 .60773 .63707 .56282 Mtetra
.836 .602 .585 r
.63707 .56282 .64437 .60773 .65376 .52946 .64642 .48285 Mtetra
.452 .335 .63 r
.64642 .48285 .65376 .52946 .66676 .54867 .6591 .49788 Mtetra
.521 .379 .628 r
.6591 .49788 .66676 .54867 .67963 .56039 .67165 .50567 Mtetra
.584 .42 .624 r
.67165 .50567 .67963 .56039 .69214 .56125 .68387 .50357 Mtetra
.657 .468 .617 r
.68387 .50357 .69214 .56125 .70378 .54424 .69531 .48528 Mtetra
.402 .288 .608 r
.69531 .48528 .70378 .54424 .71788 .57119 .70914 .51112 Mtetra
.417 .299 .61 r
.70914 .51112 .71788 .57119 .73208 .59516 .72317 .53556 Mtetra
.773 .547 .593 r
.72317 .53556 .73208 .59516 .74083 .53044 .73212 .47506 Mtetra
0 0 .456 r
.73212 .47506 .74083 .53044 .75864 .60444 .74976 .55041 Mtetra
.737 .526 .607 r
.74976 .55041 .75864 .60444 .76853 .55945 .7599 .51013 Mtetra
.649 .47 .628 r
.7599 .51013 .76853 .55945 .78025 .54194 .77179 .49624 Mtetra
.427 .324 .635 r
.77179 .49624 .78025 .54194 .7946 .55818 .78616 .51451 Mtetra
.724 .526 .623 r
.78616 .51451 .7946 .55818 .8053 .52808 .79693 .48603 Mtetra
.616 .457 .644 r
.79693 .48603 .8053 .52808 .81796 .5222 .80947 .47981 Mtetra
.72 .525 .625 r
.80947 .47981 .81796 .5222 .82889 .49686 .82021 .45306 Mtetra
.455 .347 .642 r
.82021 .45306 .82889 .49686 .84389 .51527 .83474 .46802 Mtetra
.675 .489 .627 r
.83474 .46802 .84389 .51527 .85575 .49982 .84617 .44916 Mtetra
.704 .504 .616 r
.84617 .44916 .85575 .49982 .86665 .47543 .85664 .42159 Mtetra
.275 .212 .603 r
.85664 .42159 .86665 .47543 .88494 .52064 .87423 .46222 Mtetra
.634 .451 .618 r
.87423 .46222 .88494 .52064 .89738 .5094 .8863 .44898 Mtetra
.645 .457 .614 r
.8863 .44898 .89738 .5094 .90926 .49335 .89797 .43247 Mtetra
.366 .269 .611 r
.89797 .43247 .90926 .49335 .92726 .52854 .91569 .46717 Mtetra
.61 .433 .618 r
.91569 .46717 .92726 .52854 .93995 .51789 .92849 .45884 Mtetra
.519 .375 .624 r
.92849 .45884 .93995 .51789 .95495 .52514 .94367 .46896 Mtetra
.742 .436 .465 r
.3435 .62434 .3516 .60372 .36117 .62663 .35311 .64727 Mtetra
.539 .221 .377 r
.35311 .64727 .36117 .62663 .37198 .62606 .36398 .64778 Mtetra
.669 .359 .439 r
.36398 .64778 .37198 .62606 .38244 .6355 .37441 .65984 Mtetra
.497 .195 .383 r
.37441 .65984 .38244 .6355 .39361 .62959 .38558 .65721 Mtetra
.245 0 .297 r
.38558 .65721 .39361 .62959 .40527 .61017 .39729 .64114 Mtetra
.684 .394 .477 r
.39729 .64114 .40527 .61017 .41581 .62461 .40781 .65955 Mtetra
.402 .138 .396 r
.40781 .65955 .41581 .62461 .42733 .61016 .41944 .64755 Mtetra
.119 0 .293 r
.41944 .64755 .42733 .61016 .4392 .58095 .43151 .61912 Mtetra
.547 .275 .455 r
.43151 .61912 .4392 .58095 .45031 .58062 .44278 .6189 Mtetra
.5 .233 .441 r
.44278 .6189 .45031 .58062 .46155 .57687 .45423 .61369 Mtetra
.339 .09 .382 r
.45423 .61369 .46155 .57687 .47299 .5626 .46592 .59646 Mtetra
0 0 .226 r
.46592 .59646 .47299 .5626 .48458 .5348 .47777 .56464 Mtetra
.778 .483 .489 r
.47777 .56464 .48458 .5348 .49541 .58008 .48869 .60737 Mtetra
0 0 .177 r
.48869 .60737 .49541 .58008 .50698 .55673 .50047 .58032 Mtetra
0 0 0 r
.50047 .58032 .50698 .55673 .51848 .52411 .51217 .54483 Mtetra
.882 .586 .48 r
.51217 .54483 .51848 .52411 .53003 .61967 .52365 .64115 Mtetra
.99 .817 .436 r
.52365 .64115 .53003 .61967 .54143 .53978 .53532 .56033 Mtetra
.772 .454 .448 r
.53532 .56033 .54143 .53978 .55326 .56726 .54723 .59028 Mtetra
.791 .479 .46 r
.54723 .59028 .55326 .56726 .56544 .60189 .55952 .62877 Mtetra
0 0 0 r
.55952 .62877 .56544 .60189 .57667 .55434 .57102 .58394 Mtetra
.599 .303 .438 r
.57102 .58394 .57667 .55434 .58858 .55653 .58315 .58999 Mtetra
.632 .341 .458 r
.58315 .58999 .58858 .55653 .60071 .56415 .5955 .60107 Mtetra
.461 .197 .426 r
.5955 .60107 .60071 .56415 .61248 .55336 .60753 .59216 Mtetra
0 0 .016 r
.60753 .59216 .61248 .55336 .62264 .48779 .61796 .5254 Mtetra
.822 .525 .487 r
.61796 .5254 .62264 .48779 .63707 .56282 .63249 .60181 Mtetra
.728 .656 .101 r
.63249 .60181 .63707 .56282 .64642 .48285 .64201 .51742 Mtetra
.637 .346 .46 r
.64201 .51742 .64642 .48285 .6591 .49788 .65474 .52971 Mtetra
.583 .292 .44 r
.65474 .52971 .6591 .49788 .67165 .50567 .66731 .53408 Mtetra
.475 .189 .399 r
.66731 .53408 .67165 .50567 .68387 .50357 .67953 .52846 Mtetra
.147 0 .274 r
.67953 .52846 .68387 .50357 .69531 .48528 .691 .50707 Mtetra
.743 .413 .424 r
.691 .50707 .69531 .48528 .70914 .51112 .70488 .53187 Mtetra
.747 .412 .416 r
.70488 .53187 .70914 .51112 .72317 .53556 .71902 .55669 Mtetra
.819 .738 .213 r
.71902 .55669 .72317 .53556 .73212 .47506 .72823 .49648 Mtetra
.879 .553 .429 r
.72823 .49648 .73212 .47506 .74976 .55041 .74617 .57612 Mtetra
0 0 .15 r
.74617 .57612 .74976 .55041 .7599 .51013 .75673 .53862 Mtetra
.416 .141 .385 r
.75673 .53862 .7599 .51013 .77179 .49624 .76907 .52833 Mtetra
.695 .386 .449 r
.76907 .52833 .77179 .49624 .78616 .51451 .78392 .55071 Mtetra
.253 .036 .378 r
.78392 .55071 .78616 .51451 .79693 .48603 .79509 .52412 Mtetra
.506 .238 .442 r
.79509 .52412 .79693 .48603 .80947 .47981 .80796 .51905 Mtetra
.274 .061 .397 r
.80796 .51905 .80947 .47981 .82021 .45306 .81887 .4913 Mtetra
.636 .343 .458 r
.81887 .4913 .82021 .45306 .83474 .46802 .83349 .50501 Mtetra
.328 .098 .405 r
.83349 .50501 .83474 .46802 .84617 .44916 .84483 .48276 Mtetra
.16 0 .351 r
.84483 .48276 .84617 .44916 .85664 .42159 .85511 .45093 Mtetra
.767 .44 .432 r
.85511 .45093 .85664 .42159 .87423 .46222 .87256 .48888 Mtetra
.317 .061 .359 r
.87256 .48888 .87423 .46222 .8863 .44898 .88445 .47218 Mtetra
.232 0 .315 r
.88445 .47218 .8863 .44898 .89797 .43247 .89604 .45326 Mtetra
.79 .436 .385 r
.89604 .45326 .89797 .43247 .91569 .46717 .91386 .48795 Mtetra
.414 .108 .336 r
.91386 .48795 .91569 .46717 .92849 .45884 .92693 .48033 Mtetra
.658 .314 .378 r
.92693 .48033 .92849 .45884 .94367 .46896 .94259 .493 Mtetra
.863 .469 .292 r
.33635 .62434 .3435 .62434 .35311 .64727 .34605 .64552 Mtetra
.204 .705 .911 r
.34605 .64552 .35311 .64727 .36398 .64778 .35697 .64558 Mtetra
.796 .308 .039 r
.35697 .64558 .36398 .64778 .37441 .65984 .36737 .65873 Mtetra
.172 .696 .87 r
.36737 .65873 .37441 .65984 .38558 .65721 .37848 .65847 Mtetra
.887 .966 .837 r
.37848 .65847 .38558 .65721 .39729 .64114 .39014 .64563 Mtetra
.832 .459 .348 r
.39014 .64563 .39729 .64114 .40781 .65955 .40054 .66799 Mtetra
0 0 0 r
.40054 .66799 .40781 .65955 .41944 .64755 .41215 .65946 Mtetra
.848 .905 .495 r
.41215 .65946 .41944 .64755 .43151 .61912 .42428 .63343 Mtetra
.537 .177 .304 r
.42428 .63343 .43151 .61912 .44278 .6189 .43561 .63474 Mtetra
.379 .032 .246 r
.43561 .63474 .44278 .6189 .45423 .61369 .44716 .6295 Mtetra
0 0 0 r
.44716 .6295 .45423 .61369 .46592 .59646 .45901 .61058 Mtetra
.904 .884 .459 r
.45901 .61058 .46592 .59646 .47777 .56464 .47106 .57569 Mtetra
.848 .52 .431 r
.47106 .57569 .47777 .56464 .48869 .60737 .48202 .61545 Mtetra
.973 .917 .591 r
.48202 .61545 .48869 .60737 .50047 .58032 .49396 .58443 Mtetra
.988 .848 .614 r
.49396 .58443 .50047 .58032 .51217 .54483 .50581 .54542 Mtetra
.939 .629 .426 r
.50581 .54542 .51217 .54483 .52365 .64115 .51717 .6399 Mtetra
.963 .744 .56 r
.51717 .6399 .52365 .64115 .53532 .56033 .52903 .55764 Mtetra
.906 .505 .227 r
.52903 .55764 .53532 .56033 .54723 .59028 .54093 .58817 Mtetra
.922 .55 .294 r
.54093 .58817 .54723 .59028 .55952 .62877 .55321 .6288 Mtetra
.974 .809 .617 r
.55321 .6288 .55952 .62877 .57102 .58394 .56487 .58675 Mtetra
.703 .216 .085 r
.56487 .58675 .57102 .58394 .58315 .58999 .57711 .59657 Mtetra
.759 .347 .268 r
.57711 .59657 .58315 .58999 .5955 .60107 .58959 .61158 Mtetra
.259 0 .077 r
.58959 .61158 .5955 .60107 .60753 .59216 .6018 .60579 Mtetra
.993 .826 .457 r
.6018 .60579 .60753 .59216 .61796 .5254 .61248 .54016 Mtetra
.894 .574 .435 r
.61248 .54016 .61796 .5254 .63249 .60181 .62704 .61841 Mtetra
.994 .799 .428 r
.62704 .61841 .63249 .60181 .64201 .51742 .63675 .53184 Mtetra
.666 .303 .346 r
.63675 .53184 .64201 .51742 .65474 .52971 .64949 .54207 Mtetra
.521 .136 .252 r
.64949 .54207 .65474 .52971 .66731 .53408 .66202 .54322 Mtetra
.018 0 0 r
.66202 .54322 .66731 .53408 .67953 .52846 .67417 .5338 Mtetra
.931 .936 .581 r
.67417 .5338 .67953 .52846 .691 .50707 .68558 .50867 Mtetra
.84 .395 .166 r
.68558 .50867 .691 .50707 .70488 .53187 .69934 .53079 Mtetra
.847 .387 .081 r
.69934 .53079 .70488 .53187 .71902 .55669 .71341 .55409 Mtetra
.981 .772 .548 r
.71341 .55409 .71902 .55669 .72823 .49648 .72275 .49346 Mtetra
.95 .6 .291 r
.72275 .49346 .72823 .49648 .74617 .57612 .74072 .57488 Mtetra
.984 .843 .622 r
.74072 .57488 .74617 .57612 .75673 .53862 .75157 .53988 Mtetra
.498 .902 .794 r
.75157 .53988 .75673 .53862 .76907 .52833 .76424 .5331 Mtetra
.843 .421 .232 r
.76424 .5331 .76907 .52833 .78392 .55071 .77946 .55963 Mtetra
.639 .778 .319 r
.77946 .55963 .78392 .55071 .79509 .52412 .79103 .5363 Mtetra
.427 .042 .203 r
.79103 .5363 .79509 .52412 .80796 .51905 .80423 .5338 Mtetra
0 0 0 r
.80423 .5338 .80796 .51905 .81887 .4913 .81538 .5069 Mtetra
.689 .318 .34 r
.81538 .5069 .81887 .4913 .83349 .50501 .83011 .52055 Mtetra
0 0 .06 r
.83011 .52055 .83349 .50501 .84483 .48276 .84141 .49616 Mtetra
0 0 0 r
.84141 .49616 .84483 .48276 .85511 .45093 .85153 .46094 Mtetra
.846 .453 .3 r
.85153 .46094 .85511 .45093 .87256 .48888 .86869 .49565 Mtetra
.625 .792 .353 r
.86869 .49565 .87256 .48888 .88445 .47218 .88028 .475 Mtetra
.9 .944 .585 r
.88028 .475 .88445 .47218 .89604 .45326 .8916 .45269 Mtetra
.86 .408 .051 r
.8916 .45269 .89604 .45326 .91386 .48795 .90922 .48537 Mtetra
.765 .954 .935 r
.90922 .48537 .91386 .48795 .92693 .48033 .92227 .47695 Mtetra
.507 0 0 r
.92227 .47695 .92693 .48033 .94259 .493 .93808 .49048 Mtetra
.288 .236 .624 r
.33107 .59022 .33635 .62434 .34605 .64552 .34083 .60807 Mtetra
.588 .442 .65 r
.34083 .60807 .34605 .64552 .35697 .64558 .35177 .60616 Mtetra
.43 .326 .634 r
.35177 .60616 .35697 .64558 .36737 .65873 .36209 .61852 Mtetra
.565 .421 .644 r
.36209 .61852 .36737 .65873 .37848 .65847 .37307 .61918 Mtetra
.648 .482 .644 r
.37307 .61918 .37848 .65847 .39014 .64563 .38458 .60878 Mtetra
.169 .147 .588 r
.38458 .60878 .39014 .64563 .40054 .66799 .39474 .63402 Mtetra
.616 .47 .66 r
.39474 .63402 .40054 .66799 .41215 .65946 .40617 .62922 Mtetra
.736 .559 .652 r
.40617 .62922 .41215 .65946 .42428 .63343 .41819 .60689 Mtetra
.515 .425 .692 r
.41819 .60689 .42428 .63343 .43561 .63474 .4294 .61082 Mtetra
.622 .506 .7 r
.4294 .61082 .43561 .63474 .44716 .6295 .44089 .60703 Mtetra
.751 .59 .676 r
.44089 .60703 .44716 .6295 .45901 .61058 .45275 .58818 Mtetra
.82 .628 .643 r
.45275 .58818 .45901 .61058 .47106 .57569 .46486 .55203 Mtetra
0 0 .284 r
.46486 .55203 .47106 .57569 .48202 .61545 .47575 .58867 Mtetra
.797 .603 .64 r
.47575 .58867 .48202 .61545 .49396 .58443 .48774 .55443 Mtetra
.806 .602 .626 r
.48774 .55443 .49396 .58443 .50581 .54542 .49964 .5122 Mtetra
.916 .634 .144 r
.49964 .5122 .50581 .54542 .51717 .6399 .51077 .60187 Mtetra
.851 .621 .59 r
.51077 .60187 .51717 .6399 .52903 .55764 .5227 .51849 Mtetra
.177 .152 .59 r
.5227 .51849 .52903 .55764 .54093 .58817 .53446 .54733 Mtetra
0 .009 .521 r
.53446 .54733 .54093 .58817 .55321 .6288 .54656 .58756 Mtetra
.765 .56 .62 r
.54656 .58756 .55321 .6288 .56487 .58675 .55823 .54802 Mtetra
.44 .34 .645 r
.55823 .54802 .56487 .58675 .57711 .59657 .5704 .56059 Mtetra
.341 .279 .642 r
.5704 .56059 .57711 .59657 .58959 .61158 .58284 .57897 Mtetra
.592 .459 .669 r
.58284 .57897 .58959 .61158 .6018 .60579 .59507 .5769 Mtetra
.856 .633 .6 r
.59507 .5769 .6018 .60579 .61248 .54016 .6059 .51494 Mtetra
.899 .591 .093 r
.6059 .51494 .61248 .54016 .62704 .61841 .62032 .59449 Mtetra
.902 .666 .572 r
.62032 .59449 .62704 .61841 .63675 .53184 .63019 .50912 Mtetra
.406 .379 .716 r
.63019 .50912 .63675 .53184 .64949 .54207 .64285 .51828 Mtetra
.588 .489 .709 r
.64285 .51828 .64949 .54207 .66202 .54322 .65526 .51706 Mtetra
.696 .545 .678 r
.65526 .51706 .66202 .54322 .67417 .5338 .66725 .50438 Mtetra
.771 .581 .641 r
.66725 .50438 .67417 .5338 .68558 .50867 .67848 .47578 Mtetra
.336 .288 .655 r
.67848 .47578 .68558 .50867 .69934 .53079 .69193 .49393 Mtetra
.344 .282 .644 r
.69193 .49393 .69934 .53079 .71341 .55409 .70571 .51387 Mtetra
.825 .596 .593 r
.70571 .51387 .71341 .55409 .72275 .49346 .71501 .4526 Mtetra
0 0 .277 r
.71501 .4526 .72275 .49346 .74072 .57488 .73265 .53222 Mtetra
.744 .541 .62 r
.73265 .53222 .74072 .57488 .75157 .53988 .74357 .49912 Mtetra
.602 .449 .647 r
.74357 .49912 .75157 .53988 .76424 .5331 .75634 .49499 Mtetra
.227 .203 .622 r
.75634 .49499 .76424 .5331 .77946 .55963 .77166 .52455 Mtetra
.707 .529 .646 r
.77166 .52455 .77946 .55963 .79103 .5363 .7835 .50527 Mtetra
.562 .448 .68 r
.7835 .50527 .79103 .5363 .80423 .5338 .79694 .50621 Mtetra
.762 .581 .653 r
.79694 .50621 .80423 .5338 .81538 .5069 .80831 .48203 Mtetra
.336 .327 .702 r
.80831 .48203 .81538 .5069 .83011 .52055 .82308 .49669 Mtetra
.784 .607 .66 r
.82308 .49669 .83011 .52055 .84141 .49616 .83437 .47209 Mtetra
.836 .633 .628 r
.83437 .47209 .84141 .49616 .85153 .46094 .84435 .43529 Mtetra
.009 .103 .615 r
.84435 .43529 .85153 .46094 .86869 .49565 .86109 .46657 Mtetra
.756 .573 .649 r
.86109 .46657 .86869 .49565 .88028 .475 .87227 .44237 Mtetra
.75 .56 .639 r
.87227 .44237 .88028 .475 .8916 .45269 .88317 .41654 Mtetra
.252 .229 .639 r
.88317 .41654 .8916 .45269 .90922 .48537 .90022 .44533 Mtetra
.644 .479 .645 r
.90022 .44533 .90922 .48537 .92227 .47695 .91293 .43474 Mtetra
.473 .364 .65 r
.91293 .43474 .92227 .47695 .93808 .49048 .92847 .4471 Mtetra
0 0 .515 r
.3245 .57889 .33107 .59022 .34083 .60807 .33443 .59315 Mtetra
.662 .586 .759 r
.33443 .59315 .34083 .60807 .35177 .60616 .34552 .58828 Mtetra
.238 .304 .729 r
.34552 .58828 .35177 .60616 .36209 .61852 .3559 .59866 Mtetra
.568 .494 .731 r
.3559 .59866 .36209 .61852 .37307 .61918 .36688 .59881 Mtetra
.692 .564 .706 r
.36688 .59881 .37307 .61918 .38458 .60878 .37834 .58944 Mtetra
0 0 .322 r
.37834 .58944 .38458 .60878 .39474 .63402 .38834 .61685 Mtetra
.598 .534 .754 r
.38834 .61685 .39474 .63402 .40617 .62922 .39965 .61535 Mtetra
.801 .661 .708 r
.39965 .61535 .40617 .62922 .41819 .60689 .41159 .59672 Mtetra
.122 .371 .83 r
.41159 .59672 .41819 .60689 .4294 .61082 .42269 .60413 Mtetra
.56 .708 .94 r
.42269 .60413 .4294 .61082 .44089 .60703 .43414 .60304 Mtetra
.89 .815 .768 r
.43414 .60304 .44089 .60703 .45275 .58818 .44604 .58558 Mtetra
.943 .783 .654 r
.44604 .58558 .45275 .58818 .46486 .55203 .45826 .54927 Mtetra
.918 .544 .294 r
.45826 .54927 .46486 .55203 .47575 .58867 .46914 .58457 Mtetra
.936 .77 .651 r
.46914 .58457 .47575 .58867 .48774 .55443 .48127 .54752 Mtetra
.926 .736 .627 r
.48127 .54752 .48774 .55443 .49964 .5122 .4933 .50183 Mtetra
.965 .647 .362 r
.4933 .50183 .49964 .5122 .51077 .60187 .50429 .58766 Mtetra
.922 .694 .576 r
.50429 .58766 .51077 .60187 .5227 .51849 .51639 .50123 Mtetra
0 0 .407 r
.51639 .50123 .5227 .51849 .53446 .54733 .52808 .52754 Mtetra
.708 .401 0 r
.52808 .52754 .53446 .54733 .54656 .58756 .54008 .56641 Mtetra
.84 .643 .637 r
.54008 .56641 .54656 .58756 .55823 .54802 .5518 .52752 Mtetra
.21 .266 .703 r
.5518 .52752 .55823 .54802 .5704 .56059 .56395 .54184 Mtetra
0 .051 .604 r
.56395 .54184 .5704 .56059 .58284 .57897 .57638 .56313 Mtetra
.53 .515 .784 r
.57638 .56313 .58284 .57897 .59507 .5769 .58868 .56473 Mtetra
.922 .708 .597 r
.58868 .56473 .59507 .5769 .6059 .51494 .59972 .50644 Mtetra
.961 .626 .311 r
.59972 .50644 .6059 .51494 .62032 .59449 .61411 .58927 Mtetra
.964 .735 .545 r
.61411 .58927 .62032 .59449 .63019 .50912 .62422 .50563 Mtetra
.519 0 0 r
.62422 .50563 .63019 .50912 .64285 .51828 .63693 .51542 Mtetra
.493 .834 .998 r
.63693 .51542 .64285 .51828 .65526 .51706 .64935 .51326 Mtetra
.892 .866 .807 r
.64935 .51326 .65526 .51706 .66725 .50438 .6613 .49824 Mtetra
.937 .78 .66 r
.6613 .49824 .66725 .50438 .67848 .47578 .67247 .46633 Mtetra
0 .098 .649 r
.67247 .46633 .67848 .47578 .69193 .49393 .68574 .48074 Mtetra
0 .146 .687 r
.68574 .48074 .69193 .49393 .70571 .51387 .6993 .497 Mtetra
.918 .691 .579 r
.6993 .497 .70571 .51387 .71501 .4526 .70855 .43317 Mtetra
.893 .563 .07 r
.70855 .43317 .71501 .4526 .73265 .53222 .72591 .51062 Mtetra
.831 .639 .643 r
.72591 .51062 .73265 .53222 .74357 .49912 .73687 .47752 Mtetra
.61 .517 .724 r
.73687 .47752 .74357 .49912 .75634 .49499 .74972 .47472 Mtetra
0 0 .519 r
.74972 .47472 .75634 .49499 .77166 .52455 .76515 .50674 Mtetra
.764 .628 .71 r
.76515 .50674 .77166 .52455 .7835 .50527 .77729 .49105 Mtetra
.437 .488 .814 r
.77729 .49105 .7835 .50527 .79694 .50621 .79104 .49579 Mtetra
.867 .742 .722 r
.79104 .49579 .79694 .50621 .80831 .48203 .80277 .47505 Mtetra
0 0 .504 r
.80277 .47505 .80831 .48203 .82308 .49669 .81778 .49231 Mtetra
.95 .854 .712 r
.81778 .49231 .82308 .49669 .83437 .47209 .82926 .46881 Mtetra
.986 .826 .601 r
.82926 .46881 .83437 .47209 .84435 .43529 .83931 .43151 Mtetra
.822 .362 0 r
.83931 .43151 .84435 .43529 .86109 .46657 .85588 .46108 Mtetra
.956 .829 .677 r
.85588 .46108 .86109 .46657 .87227 .44237 .86683 .4338 Mtetra
.934 .778 .664 r
.86683 .4338 .87227 .44237 .88317 .41654 .8774 .40428 Mtetra
0 0 .556 r
.8774 .40428 .88317 .41654 .90022 .44533 .89399 .42922 Mtetra
.762 .644 .731 r
.89399 .42922 .90022 .44533 .91293 .43474 .90633 .41538 Mtetra
.377 .394 .751 r
.90633 .41538 .91293 .43474 .92847 .4471 .92157 .42543 Mtetra
.645 .347 .45 r
.31554 .60623 .3245 .57889 .33443 .59315 .32575 .61726 Mtetra
.369 .067 .316 r
.32575 .61726 .33443 .59315 .34552 .58828 .33717 .60877 Mtetra
.629 .307 .407 r
.33717 .60877 .34552 .58828 .3559 .59866 .34777 .6164 Mtetra
.48 .14 .312 r
.34777 .6164 .3559 .59866 .36688 .59881 .35894 .61472 Mtetra
.178 0 .13 r
.35894 .61472 .36688 .59881 .37834 .58944 .37053 .6048 Mtetra
.791 .469 .444 r
.37053 .6048 .37834 .58944 .38834 .61685 .38051 .63373 Mtetra
.532 .185 .325 r
.38051 .63373 .38834 .61685 .39965 .61535 .39182 .63468 Mtetra
.05 0 .117 r
.39182 .63468 .39965 .61535 .41159 .59672 .4038 .61916 Mtetra
.658 .34 .424 r
.4038 .61916 .41159 .59672 .42269 .60413 .41488 .63058 Mtetra
.564 .259 .409 r
.41488 .63058 .42269 .60413 .43414 .60304 .42636 .63315 Mtetra
.3 .03 .327 r
.42636 .63315 .43414 .60304 .44604 .58558 .43837 .61815 Mtetra
0 0 .118 r
.43837 .61815 .44604 .58558 .45826 .54927 .45081 .58252 Mtetra
.749 .455 .485 r
.45081 .58252 .45826 .54927 .46914 .58457 .46176 .61885 Mtetra
0 0 .114 r
.46176 .61885 .46914 .58457 .48127 .54752 .47416 .57945 Mtetra
0 0 0 r
.47416 .57945 .48127 .54752 .4933 .50183 .48648 .53005 Mtetra
.852 .557 .487 r
.48648 .53005 .4933 .50183 .50429 .58766 .49746 .61436 Mtetra
.985 .811 .415 r
.49746 .61436 .50429 .58766 .51639 .50123 .5099 .52249 Mtetra
.74 .418 .436 r
.5099 .52249 .51639 .50123 .52808 .52754 .52166 .54604 Mtetra
.806 .482 .44 r
.52166 .54604 .52808 .52754 .54008 .56641 .5337 .58319 Mtetra
.854 .833 .36 r
.5337 .58319 .54008 .56641 .5518 .52752 .5456 .54268 Mtetra
.711 .357 .375 r
.5456 .54268 .5518 .52752 .56395 .54184 .55783 .55774 Mtetra
.764 .419 .4 r
.55783 .55774 .56395 .54184 .57638 .56313 .57037 .58137 Mtetra
.59 .245 .353 r
.57037 .58137 .57638 .56313 .58868 .56473 .58284 .5862 Mtetra
.869 .795 .303 r
.58284 .5862 .58868 .56473 .59972 .50644 .59417 .53056 Mtetra
.874 .564 .458 r
.59417 .53056 .59972 .50644 .61411 .58927 .6087 .61914 Mtetra
.888 .764 .264 r
.6087 .61914 .61411 .58927 .62422 .50563 .61916 .5368 Mtetra
.639 .335 .44 r
.61916 .5368 .62422 .50563 .63693 .51542 .6321 .54901 Mtetra
.524 .238 .422 r
.6321 .54901 .63693 .51542 .64935 .51326 .64473 .54753 Mtetra
.349 .093 .378 r
.64473 .54753 .64935 .51326 .6613 .49824 .65685 .53128 Mtetra
0 0 .25 r
.65685 .53128 .6613 .49824 .67247 .46633 .66813 .49634 Mtetra
.635 .328 .433 r
.66813 .49634 .67247 .46633 .68574 .48074 .68141 .50788 Mtetra
.65 .333 .422 r
.68141 .50788 .68574 .48074 .6993 .497 .69494 .52077 Mtetra
.843 .742 .222 r
.69494 .52077 .6993 .497 .70855 .43317 .70419 .45216 Mtetra
.884 .552 .416 r
.70419 .45216 .70855 .43317 .72591 .51062 .72148 .52817 Mtetra
0 0 0 r
.72148 .52817 .72591 .51062 .73687 .47752 .73248 .49293 Mtetra
.442 .084 .261 r
.73248 .49293 .73687 .47752 .74972 .47472 .74545 .48999 Mtetra
.814 .451 .37 r
.74545 .48999 .74972 .47472 .76515 .50674 .7611 .524 Mtetra
.205 0 .207 r
.7611 .524 .76515 .50674 .77729 .49105 .77359 .51085 Mtetra
.625 .277 .361 r
.77359 .51085 .77729 .49105 .79104 .49579 .78778 .5194 Mtetra
.237 0 .293 r
.78778 .5194 .79104 .49579 .80277 .47505 .80001 .50222 Mtetra
.701 .372 .416 r
.80001 .50222 .80277 .47505 .81778 .49231 .81553 .52359 Mtetra
.271 .031 .355 r
.81553 .52359 .81778 .49231 .82926 .46881 .82744 .50223 Mtetra
.051 0 .303 r
.82744 .50223 .82926 .46881 .83931 .43151 .83778 .46527 Mtetra
.722 .402 .437 r
.83778 .46527 .83931 .43151 .85588 .46108 .85459 .49544 Mtetra
.191 0 .353 r
.85459 .49544 .85588 .46108 .86683 .4338 .86554 .46567 Mtetra
.105 0 .321 r
.86554 .46567 .86683 .4338 .8774 .40428 .87596 .43248 Mtetra
.699 .368 .412 r
.87596 .43248 .8774 .40428 .89399 .42922 .89237 .45436 Mtetra
.27 .013 .328 r
.89237 .45436 .89399 .42922 .90633 .41538 .90445 .43646 Mtetra
.603 .258 .358 r
.90445 .43646 .90633 .41538 .92157 .42543 .91947 .44347 Mtetra
.458 .365 .662 r
.3101 .57479 .31554 .60623 .32575 .61726 .32042 .58256 Mtetra
.667 .502 .652 r
.32042 .58256 .32575 .61726 .33717 .60877 .33199 .57052 Mtetra
.528 .397 .646 r
.33199 .57052 .33717 .60877 .34777 .6164 .34269 .57436 Mtetra
.605 .446 .639 r
.34269 .57436 .34777 .6164 .35894 .61472 .35392 .56963 Mtetra
.645 .471 .633 r
.35392 .56963 .35894 .61472 .37053 .6048 .36551 .55793 Mtetra
.231 .167 .575 r
.36551 .55793 .37053 .6048 .38051 .63373 .37537 .58563 Mtetra
.553 .4 .628 r
.37537 .58563 .38051 .63373 .39182 .63468 .38653 .58746 Mtetra
.648 .471 .63 r
.38653 .58746 .39182 .63468 .4038 .61916 .39833 .57448 Mtetra
.422 .311 .622 r
.39833 .57448 .4038 .61916 .41488 .63058 .40918 .58887 Mtetra
.509 .38 .639 r
.40918 .58887 .41488 .63058 .42636 .63315 .42046 .59502 Mtetra
.655 .488 .647 r
.42046 .59502 .42636 .63315 .43837 .61815 .43232 .58367 Mtetra
.763 .568 .634 r
.43232 .58367 .43837 .61815 .45081 .58252 .44468 .55113 Mtetra
0 0 .422 r
.44468 .55113 .45081 .58252 .46176 .61885 .45548 .58841 Mtetra
.797 .597 .631 r
.45548 .58841 .46176 .61885 .47416 .57945 .46789 .54937 Mtetra
.826 .614 .617 r
.46789 .54937 .47416 .57945 .48648 .53005 .48027 .49902 Mtetra
.909 .623 .127 r
.48027 .49902 .48648 .53005 .49746 .61436 .49107 .57938 Mtetra
.87 .636 .582 r
.49107 .57938 .49746 .61436 .5099 .52249 .50362 .48532 Mtetra
.315 .254 .628 r
.50362 .48532 .5099 .52249 .52166 .54604 .51527 .5047 Mtetra
.115 .103 .566 r
.51527 .5047 .52166 .54604 .5337 .58319 .52714 .53768 Mtetra
.762 .552 .614 r
.52714 .53768 .5337 .58319 .5456 .54268 .539 .49551 Mtetra
.45 .33 .625 r
.539 .49551 .5456 .54268 .55783 .55774 .55107 .50904 Mtetra
.347 .256 .608 r
.55107 .50904 .55783 .55774 .57037 .58137 .56344 .53244 Mtetra
.518 .377 .629 r
.56344 .53244 .57037 .58137 .58284 .5862 .5758 .53892 Mtetra
.781 .563 .604 r
.5758 .53892 .58284 .5862 .59417 .53056 .58719 .48732 Mtetra
.717 .492 0 r
.58719 .48732 .59417 .53056 .6087 .61914 .60149 .57781 Mtetra
.844 .61 .585 r
.60149 .57781 .6087 .61914 .61916 .5368 .61214 .50048 Mtetra
.393 .315 .649 r
.61214 .50048 .61916 .5368 .6321 .54901 .62507 .51553 Mtetra
.564 .439 .668 r
.62507 .51553 .6321 .54901 .64473 .54753 .6377 .51601 Mtetra
.697 .53 .658 r
.6377 .51601 .64473 .54753 .65685 .53128 .64981 .50047 Mtetra
.792 .591 .629 r
.64981 .50047 .65685 .53128 .66813 .49634 .66107 .46494 Mtetra
.458 .375 .674 r
.66107 .46494 .66813 .49634 .68141 .50788 .67416 .47393 Mtetra
.465 .372 .666 r
.67416 .47393 .68141 .50788 .69494 .52077 .68741 .4832 Mtetra
.851 .616 .582 r
.68741 .4832 .69494 .52077 .70419 .45216 .69655 .41195 Mtetra
0 0 .325 r
.69655 .41195 .70419 .45216 .72148 .52817 .71332 .48278 Mtetra
.751 .542 .612 r
.71332 .48278 .72148 .52817 .73248 .49293 .72414 .44529 Mtetra
.597 .435 .633 r
.72414 .44529 .73248 .49293 .74545 .48999 .73688 .44064 Mtetra
.275 .212 .603 r
.73688 .44064 .74545 .48999 .7611 .524 .75226 .47354 Mtetra
.633 .457 .626 r
.75226 .47354 .7611 .524 .77359 .51085 .76475 .46191 Mtetra
.488 .36 .632 r
.76475 .46191 .77359 .51085 .78778 .5194 .77897 .47281 Mtetra
.648 .472 .631 r
.77897 .47281 .78778 .5194 .80001 .50222 .79141 .4594 Mtetra
.332 .266 .631 r
.79141 .4594 .80001 .50222 .81553 .52359 .80708 .48411 Mtetra
.685 .507 .64 r
.80708 .48411 .81553 .52359 .82744 .50223 .81927 .4665 Mtetra
.772 .568 .623 r
.81927 .4665 .82744 .50223 .83778 .46527 .82987 .43252 Mtetra
.147 .168 .625 r
.82987 .43252 .83778 .46527 .85459 .49544 .84663 .4634 Mtetra
.771 .575 .634 r
.84663 .4634 .85459 .49544 .86554 .46567 .85755 .43356 Mtetra
.791 .586 .624 r
.85755 .43356 .86554 .46567 .87596 .43248 .86781 .39889 Mtetra
.358 .307 .664 r
.86781 .39889 .87596 .43248 .89237 .45436 .88374 .41732 Mtetra
.712 .528 .638 r
.88374 .41732 .89237 .45436 .90445 .43646 .89535 .3959 Mtetra
.545 .414 .653 r
.89535 .3959 .90445 .43646 .91947 .44347 .90978 .39885 Mtetra
.616 .27 .362 r
.3016 .59084 .3101 .57479 .32042 .58256 .31211 .59679 Mtetra
0 0 0 r
.31211 .59679 .32042 .58256 .33199 .57052 .32397 .58158 Mtetra
.487 .087 .208 r
.32397 .58158 .33199 .57052 .34269 .57436 .33494 .58188 Mtetra
0 0 0 r
.33494 .58188 .34269 .57436 .35392 .56963 .34644 .57354 Mtetra
.886 .991 .775 r
.34644 .57354 .35392 .56963 .36551 .55793 .35826 .5588 Mtetra
.874 .495 .321 r
.35826 .5588 .36551 .55793 .37537 .58563 .36818 .5848 Mtetra
.091 0 0 r
.36818 .5848 .37537 .58563 .38653 .58746 .3794 .58617 Mtetra
.871 .911 .855 r
.3794 .58617 .38653 .58746 .39833 .57448 .39122 .57417 Mtetra
.829 .384 .173 r
.39122 .57417 .39833 .57448 .40918 .58887 .402 .59104 Mtetra
.711 .227 .094 r
.402 .59104 .40918 .58887 .42046 .59502 .4132 .60063 Mtetra
0 0 0 r
.4132 .60063 .42046 .59502 .43232 .58367 .42504 .59299 Mtetra
.954 .929 .586 r
.42504 .59299 .43232 .58367 .44468 .55113 .43747 .56362 Mtetra
.843 .514 .432 r
.43747 .56362 .44468 .55113 .45548 .58841 .4482 .60425 Mtetra
.898 .874 .437 r
.4482 .60425 .45548 .58841 .46789 .54937 .46078 .56617 Mtetra
.969 .862 .465 r
.46078 .56617 .46789 .54937 .48027 .49902 .47338 .51507 Mtetra
.885 .578 .463 r
.47338 .51507 .48027 .49902 .49107 .57938 .48412 .59524 Mtetra
.998 .79 .495 r
.48412 .59524 .49107 .57938 .50362 .48532 .497 .49713 Mtetra
.739 .371 .354 r
.497 .49713 .50362 .48532 .51527 .5047 .50872 .51332 Mtetra
.835 .473 .37 r
.50872 .51332 .51527 .5047 .52714 .53768 .52061 .54292 Mtetra
.995 .842 .578 r
.52061 .54292 .52714 .53768 .539 .49551 .53261 .49709 Mtetra
.728 .231 .053 r
.53261 .49709 .539 .49551 .55107 .50904 .5447 .50833 Mtetra
.858 .418 .16 r
.5447 .50833 .55107 .50904 .56344 .53244 .55707 .5308 Mtetra
.492 0 0 r
.55707 .5308 .56344 .53244 .5758 .53892 .56947 .53778 Mtetra
.974 .789 .592 r
.56947 .53778 .5758 .53892 .58719 .48732 .58104 .48778 Mtetra
.945 .619 .382 r
.58104 .48778 .58719 .48732 .60149 .57781 .59531 .58207 Mtetra
.992 .785 .522 r
.59531 .58207 .60149 .57781 .61214 .50048 .60625 .50779 Mtetra
.785 .377 .279 r
.60625 .50779 .61214 .50048 .62507 .51553 .61934 .5268 Mtetra
.564 .158 .232 r
.61934 .5268 .62507 .51553 .6377 .51601 .63218 .53054 Mtetra
.048 0 .071 r
.63218 .53054 .6377 .51601 .64981 .50047 .6445 .51688 Mtetra
.674 .728 .218 r
.6445 .51688 .64981 .50047 .66107 .46494 .65595 .48144 Mtetra
.631 .269 .338 r
.65595 .48144 .66107 .46494 .67416 .47393 .66911 .4897 Mtetra
.617 .25 .323 r
.66911 .4897 .67416 .47393 .68741 .4832 .68237 .49683 Mtetra
.986 .803 .406 r
.68237 .49683 .68741 .4832 .69655 .41195 .69153 .42137 Mtetra
.91 .561 .367 r
.69153 .42137 .69655 .41195 .71332 .48278 .70812 .48927 Mtetra
.982 .869 .499 r
.70812 .48927 .71332 .48278 .72414 .44529 .71886 .44782 Mtetra
.427 .844 .677 r
.71886 .44782 .72414 .44529 .73688 .44064 .7315 .4403 Mtetra
.879 .445 .14 r
.7315 .4403 .73688 .44064 .75226 .47354 .74679 .47174 Mtetra
.856 .963 .872 r
.74679 .47174 .75226 .47354 .76475 .46191 .75935 .45991 Mtetra
.622 .063 0 r
.75935 .45991 .76475 .46191 .77897 .47281 .77372 .47226 Mtetra
.802 .993 .872 r
.77372 .47226 .77897 .47281 .79141 .4594 .78646 .46148 Mtetra
.856 .412 .147 r
.78646 .46148 .79141 .4594 .80708 .48411 .80249 .49006 Mtetra
0 0 0 r
.80249 .49006 .80708 .48411 .81927 .4665 .81514 .47623 Mtetra
.744 .793 .307 r
.81514 .47623 .81927 .4665 .82987 .43252 .82619 .44536 Mtetra
.826 .439 .319 r
.82619 .44536 .82987 .43252 .84663 .4634 .84334 .47939 Mtetra
0 0 .013 r
.84334 .47939 .84663 .4634 .85755 .43356 .85453 .45036 Mtetra
0 0 0 r
.85453 .45036 .85755 .43356 .86781 .39889 .86489 .41483 Mtetra
.71 .327 .321 r
.86489 .41483 .86781 .39889 .88374 .41732 .88078 .43177 Mtetra
0 0 .034 r
.88078 .43177 .88374 .41732 .89535 .3959 .89218 .40704 Mtetra
.45 .039 .167 r
.89218 .40704 .89535 .3959 .90978 .39885 .90631 .40633 Mtetra
.616 .226 .281 r
.29332 .60133 .3016 .59084 .31211 .59679 .30392 .60679 Mtetra
.715 .902 .531 r
.30392 .60679 .31211 .59679 .32397 .58158 .31602 .58944 Mtetra
.28 0 0 r
.31602 .58944 .32397 .58158 .33494 .58188 .32723 .58668 Mtetra
.763 .985 .746 r
.32723 .58668 .33494 .58188 .34644 .57354 .339 .57465 Mtetra
.935 .909 .77 r
.339 .57465 .34644 .57354 .35826 .5588 .35109 .55624 Mtetra
.885 .475 .228 r
.35109 .55624 .35826 .5588 .36818 .5848 .36113 .57932 Mtetra
.495 .73 .977 r
.36113 .57932 .36818 .5848 .3794 .58617 .37246 .57878 Mtetra
.816 .752 .792 r
.37246 .57878 .3794 .58617 .39122 .57417 .38435 .56628 Mtetra
.775 .311 0 r
.38435 .56628 .39122 .57417 .402 .59104 .39507 .58421 Mtetra
.566 .062 0 r
.39507 .58421 .402 .59104 .4132 .60063 .40618 .59623 Mtetra
.672 .829 .959 r
.40618 .59623 .4132 .60063 .42504 .59299 .41797 .59195 Mtetra
.945 .84 .709 r
.41797 .59195 .42504 .59299 .43747 .56362 .4304 .56619 Mtetra
.902 .557 .382 r
.4304 .56619 .43747 .56362 .4482 .60425 .44101 .61078 Mtetra
.989 .887 .615 r
.44101 .61078 .4482 .60425 .46078 .56617 .45369 .57513 Mtetra
.997 .847 .562 r
.45369 .57513 .46078 .56617 .47338 .51507 .46644 .52496 Mtetra
.905 .594 .446 r
.46644 .52496 .47338 .51507 .48412 .59524 .4771 .60615 Mtetra
.99 .774 .515 r
.4771 .60615 .48412 .59524 .497 .49713 .49029 .5054 Mtetra
.735 .335 .291 r
.49029 .5054 .497 .49713 .50872 .51332 .50207 .51907 Mtetra
.84 .458 .327 r
.50207 .51907 .50872 .51332 .52061 .54292 .51399 .54538 Mtetra
.985 .811 .587 r
.51399 .54538 .52061 .54292 .53261 .49709 .52614 .4955 Mtetra
.565 0 0 r
.52614 .4955 .53261 .49709 .5447 .50833 .53824 .50346 Mtetra
.818 .343 0 r
.53824 .50346 .5447 .50833 .55707 .5308 .55058 .52356 Mtetra
.085 .443 .879 r
.55058 .52356 .55707 .5308 .56947 .53778 .56299 .52945 Mtetra
.935 .737 .61 r
.56299 .52945 .56947 .53778 .58104 .48778 .57468 .47983 Mtetra
.962 .635 .338 r
.57468 .47983 .58104 .48778 .59531 .58207 .58884 .57624 Mtetra
.96 .741 .562 r
.58884 .57624 .59531 .58207 .60625 .50779 .60001 .50481 Mtetra
.847 .384 .044 r
.60001 .50481 .60625 .50779 .61934 .5268 .61322 .52768 Mtetra
.594 .032 0 r
.61322 .52768 .61934 .5268 .63218 .53054 .62623 .53527 Mtetra
.48 .834 .567 r
.62623 .53527 .63218 .53054 .6445 .51688 .63877 .52474 Mtetra
.949 .9 .515 r
.63877 .52474 .6445 .51688 .65595 .48144 .65043 .49099 Mtetra
.657 .237 .234 r
.65043 .49099 .65595 .48144 .66911 .4897 .66371 .50001 Mtetra
.609 .19 .223 r
.66371 .50001 .66911 .4897 .68237 .49683 .67702 .50631 Mtetra
.998 .796 .449 r
.67702 .50631 .68237 .49683 .69153 .42137 .68626 .4277 Mtetra
.918 .562 .344 r
.68626 .4277 .69153 .42137 .70812 .48927 .70268 .49294 Mtetra
.998 .847 .533 r
.70268 .49294 .70812 .48927 .71886 .44782 .71332 .44737 Mtetra
.825 .991 .868 r
.71332 .44737 .71886 .44782 .7315 .4403 .72581 .43619 Mtetra
.846 .393 0 r
.72581 .43619 .7315 .4403 .74679 .47174 .74093 .46483 Mtetra
.848 .811 .813 r
.74093 .46483 .74679 .47174 .75935 .45991 .75342 .45129 Mtetra
0 .218 .738 r
.75342 .45129 .75935 .45991 .77372 .47226 .7678 .46348 Mtetra
.771 .756 .839 r
.7678 .46348 .77372 .47226 .78646 .46148 .78069 .45407 Mtetra
.782 .346 0 r
.78069 .45407 .78646 .46148 .80249 .49006 .79695 .48547 Mtetra
.819 .889 .893 r
.79695 .48547 .80249 .49006 .81514 .47623 .80998 .47523 Mtetra
.981 .901 .658 r
.80998 .47523 .81514 .47623 .82619 .44536 .82149 .44808 Mtetra
.883 .459 .181 r
.82149 .44808 .82619 .44536 .84334 .47939 .83905 .48604 Mtetra
.803 .865 .421 r
.83905 .48604 .84334 .47939 .85453 .45036 .85062 .45937 Mtetra
.809 .811 .325 r
.85062 .45937 .85453 .45036 .86489 .41483 .86123 .42466 Mtetra
.736 .306 .228 r
.86123 .42466 .86489 .41483 .88078 .43177 .87721 .44152 Mtetra
0 0 0 r
.87721 .44152 .88078 .43177 .89218 .40704 .88853 .41466 Mtetra
.273 0 0 r
.88853 .41466 .89218 .40704 .90631 .40633 .90242 .4109 Mtetra
.447 .388 .699 r
.28736 .5767 .29332 .60133 .30392 .60679 .29786 .58294 Mtetra
.739 .578 .674 r
.29786 .58294 .30392 .60679 .31602 .58944 .30999 .56507 Mtetra
.63 .508 .696 r
.30999 .56507 .31602 .58944 .32723 .58668 .32129 .56028 Mtetra
.711 .552 .671 r
.32129 .56028 .32723 .58668 .339 .57465 .33322 .54525 Mtetra
.738 .561 .653 r
.33322 .54525 .339 .57465 .35109 .55624 .34548 .5234 Mtetra
.224 .197 .617 r
.34548 .5234 .35109 .55624 .36113 .57932 .3556 .54247 Mtetra
.598 .45 .651 r
.3556 .54247 .36113 .57932 .37246 .57878 .36699 .53886 Mtetra
.668 .493 .64 r
.36699 .53886 .37246 .57878 .38435 .56628 .37889 .52459 Mtetra
.36 .271 .618 r
.37889 .52459 .38435 .56628 .39507 .58421 .38952 .54159 Mtetra
.428 .319 .627 r
.38952 .54159 .39507 .58421 .40618 .59623 .40048 .5543 Mtetra
.58 .429 .641 r
.40048 .5543 .40618 .59623 .41797 .59195 .4121 .55236 Mtetra
.708 .522 .636 r
.4121 .55236 .41797 .59195 .4304 .56619 .42439 .53022 Mtetra
0 0 .307 r
.42439 .53022 .4304 .56619 .44101 .61078 .43475 .57784 Mtetra
.767 .573 .636 r
.43475 .57784 .44101 .61078 .45369 .57513 .44734 .5461 Mtetra
.824 .616 .621 r
.44734 .5461 .45369 .57513 .46644 .52496 .46009 .49908 Mtetra
.952 .648 .214 r
.46009 .49908 .46644 .52496 .4771 .60615 .47052 .58095 Mtetra
.899 .664 .574 r
.47052 .58095 .4771 .60615 .49029 .5054 .48388 .48099 Mtetra
.322 .311 .692 r
.48388 .48099 .49029 .5054 .50207 .51907 .4956 .49298 Mtetra
.014 .092 .601 r
.4956 .49298 .50207 .51907 .51399 .54538 .50744 .51621 Mtetra
.839 .623 .611 r
.50744 .51621 .51399 .54538 .52614 .4955 .51964 .46334 Mtetra
.517 .408 .669 r
.51964 .46334 .52614 .4955 .53824 .50346 .53166 .4674 Mtetra
.354 .286 .641 r
.53166 .4674 .53824 .50346 .55058 .52356 .54386 .48373 Mtetra
.534 .402 .647 r
.54386 .48373 .55058 .52356 .56299 .52945 .55613 .48699 Mtetra
.791 .574 .606 r
.55613 .48699 .56299 .52945 .57468 .47983 .56782 .43714 Mtetra
.775 .534 0 r
.56782 .43714 .57468 .47983 .58884 .57624 .58166 .53197 Mtetra
.824 .594 .591 r
.58166 .53197 .58884 .57624 .60001 .50481 .59293 .4637 Mtetra
.262 .212 .611 r
.59293 .4637 .60001 .50481 .61322 .52768 .60606 .48908 Mtetra
.448 .348 .649 r
.60606 .48908 .61322 .52768 .62623 .53527 .61906 .50017 Mtetra
.624 .475 .659 r
.61906 .50017 .62623 .53527 .63877 .52474 .63167 .49345 Mtetra
.772 .579 .637 r
.63167 .49345 .63877 .52474 .65043 .49099 .64345 .46315 Mtetra
.4 .352 .688 r
.64345 .46315 .65043 .49099 .66371 .50001 .65674 .47404 Mtetra
.463 .403 .704 r
.65674 .47404 .66371 .50001 .67702 .50631 .67003 .48081 Mtetra
.902 .663 .567 r
.67003 .48081 .67702 .50631 .68626 .4277 .67935 .40191 Mtetra
.711 .43 0 r
.67935 .40191 .68626 .4277 .70268 .49294 .69546 .46409 Mtetra
.843 .625 .607 r
.69546 .46409 .70268 .49294 .71332 .44737 .70597 .41564 Mtetra
.691 .526 .658 r
.70597 .41564 .71332 .44737 .72581 .43619 .7182 .40078 Mtetra
.248 .222 .633 r
.7182 .40078 .72581 .43619 .74093 .46483 .73292 .42524 Mtetra
.677 .5 .639 r
.73292 .42524 .74093 .46483 .75342 .45129 .74515 .40895 Mtetra
.475 .361 .644 r
.74515 .40895 .75342 .45129 .7678 .46348 .75926 .41912 Mtetra
.628 .46 .636 r
.75926 .41912 .7678 .46348 .78069 .45407 .77204 .4096 Mtetra
.244 .201 .609 r
.77204 .4096 .78069 .45407 .79695 .48547 .78819 .4416 Mtetra
.616 .454 .639 r
.78819 .4416 .79695 .48547 .80998 .47523 .80136 .43414 Mtetra
.709 .519 .63 r
.80136 .43414 .80998 .47523 .82149 .44808 .81316 .41091 Mtetra
.035 .078 .576 r
.81316 .41091 .82149 .44808 .83905 .48604 .83087 .45207 Mtetra
.731 .547 .643 r
.83087 .45207 .83905 .48604 .85062 .45937 .84279 .4292 Mtetra
.79 .591 .632 r
.84279 .4292 .85062 .45937 .86123 .42466 .85369 .39736 Mtetra
.297 .293 .686 r
.85369 .39736 .86123 .42466 .87721 .44152 .86971 .41518 Mtetra
.788 .602 .649 r
.86971 .41518 .87721 .44152 .88853 .41466 .88101 .38814 Mtetra
.629 .508 .697 r
.88101 .38814 .88853 .41466 .90242 .4109 .89464 .38248 Mtetra
.608 .323 .459 r
.2769 .61477 .28736 .5767 .29786 .58294 .28736 .62364 Mtetra
.316 .058 .355 r
.28736 .62364 .29786 .58294 .30999 .56507 .29968 .60629 Mtetra
.483 .209 .422 r
.29968 .60629 .30999 .56507 .32129 .56028 .3112 .60088 Mtetra
.318 .061 .358 r
.3112 .60088 .32129 .56028 .33322 .54525 .32347 .58349 Mtetra
.132 0 .271 r
.32347 .58349 .33322 .54525 .34548 .5234 .33615 .55806 Mtetra
.659 .366 .465 r
.33615 .55806 .34548 .5234 .3556 .54247 .34655 .57406 Mtetra
.431 .143 .372 r
.34655 .57406 .3556 .54247 .36699 .53886 .35828 .56678 Mtetra
.172 0 .241 r
.35828 .56678 .36699 .53886 .37889 .52459 .3705 .54926 Mtetra
.68 .365 .435 r
.3705 .54926 .37889 .52459 .38952 .54159 .38127 .56479 Mtetra
.662 .341 .419 r
.38127 .56479 .38952 .54159 .40048 .5543 .39234 .57735 Mtetra
.505 .182 .354 r
.39234 .57735 .40048 .5543 .4121 .55236 .40405 .57652 Mtetra
.014 0 .142 r
.40405 .57652 .4121 .55236 .42439 .53022 .41645 .55644 Mtetra
.812 .508 .475 r
.41645 .55644 .42439 .53022 .43475 .57784 .42671 .6087 Mtetra
0 0 .16 r
.42671 .6087 .43475 .57784 .44734 .5461 .43945 .58015 Mtetra
0 0 .002 r
.43945 .58015 .44734 .5461 .46009 .49908 .45241 .53556 Mtetra
.836 .542 .493 r
.45241 .53556 .46009 .49908 .47052 .58095 .46276 .62283 Mtetra
.919 .784 .307 r
.46276 .62283 .47052 .58095 .48388 .48099 .47654 .52145 Mtetra
.625 .336 .46 r
.47654 .52145 .48388 .48099 .4956 .49298 .48843 .53396 Mtetra
.675 .383 .471 r
.48843 .53396 .4956 .49298 .50744 .51621 .50042 .55651 Mtetra
0 0 .029 r
.50042 .55651 .50744 .51621 .51964 .46334 .51295 .49942 Mtetra
.54 .251 .426 r
.51295 .49942 .51964 .46334 .53166 .4674 .52514 .50016 Mtetra
.639 .336 .44 r
.52514 .50016 .53166 .4674 .54386 .48373 .53747 .51321 Mtetra
.527 .224 .396 r
.53747 .51321 .54386 .48373 .55613 .48699 .54988 .51322 Mtetra
.74 .724 .196 r
.54988 .51322 .55613 .48699 .56782 .43714 .56178 .45998 Mtetra
.885 .573 .452 r
.56178 .45998 .56782 .43714 .58166 .53197 .57559 .55576 Mtetra
.917 .8 .327 r
.57559 .55576 .58166 .53197 .59293 .4637 .58712 .48664 Mtetra
.752 .419 .421 r
.58712 .48664 .59293 .4637 .60606 .48908 .60041 .5146 Mtetra
.664 .337 .41 r
.60041 .5146 .60606 .48908 .61906 .50017 .61364 .52921 Mtetra
.491 .188 .38 r
.61364 .52921 .61906 .50017 .63167 .49345 .62655 .52627 Mtetra
.119 0 .28 r
.62655 .52627 .63167 .49345 .64345 .46315 .63869 .49912 Mtetra
.64 .337 .441 r
.63869 .49912 .64345 .46315 .65674 .47404 .6523 .51372 Mtetra
.602 .308 .443 r
.6523 .51372 .65674 .47404 .67003 .48081 .6659 .52298 Mtetra
0 0 .005 r
.6659 .52298 .67003 .48081 .67935 .40191 .67552 .44232 Mtetra
.797 .486 .462 r
.67552 .44232 .67935 .40191 .69546 .46409 .6918 .50569 Mtetra
0 0 .225 r
.6918 .50569 .69546 .46409 .70597 .41564 .70243 .45348 Mtetra
.337 .087 .38 r
.70243 .45348 .70597 .41564 .7182 .40078 .71469 .43495 Mtetra
.68 .366 .436 r
.71469 .43495 .7182 .40078 .73292 .42524 .72938 .45635 Mtetra
.254 .005 .33 r
.72938 .45635 .73292 .42524 .74515 .40895 .74157 .43606 Mtetra
.6 .276 .393 r
.74157 .43606 .74515 .40895 .75926 .41912 .75566 .44364 Mtetra
.345 .052 .316 r
.75566 .44364 .75926 .41912 .77204 .4096 .7685 .43233 Mtetra
.772 .421 .391 r
.7685 .43233 .77204 .4096 .78819 .4416 .78481 .46494 Mtetra
.427 .113 .328 r
.78481 .46494 .78819 .4416 .80136 .43414 .79828 .45885 Mtetra
.164 0 .268 r
.79828 .45885 .80136 .43414 .81316 .41091 .8105 .43795 Mtetra
.801 .456 .404 r
.8105 .43795 .81316 .41091 .83087 .45207 .82879 .48396 Mtetra
.295 .043 .351 r
.82879 .48396 .83087 .45207 .84279 .4292 .8413 .46463 Mtetra
.196 0 .344 r
.8413 .46463 .84279 .4292 .85369 .39736 .85276 .43561 Mtetra
.667 .353 .432 r
.85276 .43561 .85369 .39736 .86971 .41518 .86936 .45682 Mtetra
.293 .069 .392 r
.86936 .45682 .86971 .41518 .88101 .38814 .88102 .43031 Mtetra
.49 .218 .428 r
.88102 .43031 .88101 .38814 .89464 .38248 .89489 .42428 Mtetra
.445 .318 .614 r
.27258 .56685 .2769 .61477 .28736 .62364 .2827 .57864 Mtetra
.661 .482 .632 r
.2827 .57864 .28736 .62364 .29968 .60629 .29478 .56376 Mtetra
.599 .44 .638 r
.29478 .56376 .29968 .60629 .3112 .60088 .30616 .55923 Mtetra
.682 .501 .635 r
.30616 .55923 .3112 .60088 .32347 .58349 .3184 .54144 Mtetra
.722 .529 .629 r
.3184 .54144 .32347 .58349 .33615 .55806 .33112 .51438 Mtetra
.426 .312 .621 r
.33112 .51438 .33615 .55806 .34655 .57406 .34158 .52687 Mtetra
.635 .46 .628 r
.34158 .52687 .34655 .57406 .35828 .56678 .35339 .516 Mtetra
.678 .487 .621 r
.35339 .516 .35828 .56678 .3705 .54926 .36568 .49518 Mtetra
.462 .324 .607 r
.36568 .49518 .3705 .54926 .38127 .56479 .37644 .50716 Mtetra
.485 .338 .606 r
.37644 .50716 .38127 .56479 .39234 .57735 .38743 .51731 Mtetra
.568 .398 .611 r
.38743 .51731 .39234 .57735 .40405 .57652 .39901 .51584 Mtetra
.653 .461 .611 r
.39901 .51584 .40405 .57652 .41645 .55644 .41124 .49719 Mtetra
0 0 .457 r
.41124 .49719 .41645 .55644 .42671 .6087 .42121 .55017 Mtetra
.679 .482 .612 r
.42121 .55017 .42671 .6087 .43945 .58015 .43374 .5256 Mtetra
.735 .526 .609 r
.43374 .5256 .43945 .58015 .45241 .53556 .44654 .48567 Mtetra
.732 .527 0 r
.44654 .48567 .45241 .53556 .46276 .62283 .45655 .57437 Mtetra
.845 .609 .582 r
.45655 .57437 .46276 .62283 .47654 .52145 .47034 .47774 Mtetra
.422 .314 .626 r
.47034 .47774 .47654 .52145 .48843 .53396 .48209 .49134 Mtetra
.299 .23 .609 r
.48209 .49134 .48843 .53396 .50042 .55651 .49394 .51331 Mtetra
.805 .583 .602 r
.49394 .51331 .50042 .55651 .51295 .49942 .50647 .45571 Mtetra
.578 .425 .637 r
.50647 .45571 .51295 .49942 .52514 .50016 .51856 .45359 Mtetra
.482 .353 .628 r
.51856 .45359 .52514 .50016 .53747 .51321 .53074 .46268 Mtetra
.587 .422 .625 r
.53074 .46268 .53747 .51321 .54988 .51322 .543 .45879 Mtetra
.774 .551 .597 r
.543 .45879 .54988 .51322 .56178 .45998 .55483 .40352 Mtetra
0 0 .23 r
.55483 .40352 .56178 .45998 .57559 .55576 .56823 .49393 Mtetra
.784 .554 .587 r
.56823 .49393 .57559 .55576 .58712 .48664 .57973 .42564 Mtetra
.355 .246 .59 r
.57973 .42564 .58712 .48664 .60041 .5146 .59278 .453 Mtetra
.455 .317 .604 r
.59278 .453 .60041 .5146 .61364 .52921 .60584 .46889 Mtetra
.559 .394 .613 r
.60584 .46889 .61364 .52921 .62655 .52627 .61866 .46893 Mtetra
.673 .476 .612 r
.61866 .46893 .62655 .52627 .63869 .49912 .63083 .44604 Mtetra
.421 .304 .614 r
.63083 .44604 .63869 .49912 .6523 .51372 .64439 .46386 Mtetra
.465 .34 .625 r
.64439 .46386 .6523 .51372 .6659 .52298 .65795 .47597 Mtetra
.836 .597 .577 r
.65795 .47597 .6659 .52298 .67552 .44232 .66774 .39889 Mtetra
0 0 .405 r
.66774 .39889 .67552 .44232 .6918 .50569 .68377 .46144 Mtetra
.798 .573 .597 r
.68377 .46144 .6918 .50569 .70243 .45348 .69437 .40919 Mtetra
.688 .5 .627 r
.69437 .40919 .70243 .45348 .71469 .43495 .70643 .3886 Mtetra
.408 .307 .627 r
.70643 .3886 .71469 .43495 .72938 .45635 .72072 .40604 Mtetra
.689 .493 .617 r
.72072 .40604 .72938 .45635 .74157 .43606 .73259 .38232 Mtetra
.537 .385 .623 r
.73259 .38232 .74157 .43606 .75566 .44364 .74624 .38589 Mtetra
.633 .447 .614 r
.74624 .38589 .75566 .44364 .7685 .43233 .75872 .37186 Mtetra
.356 .254 .599 r
.75872 .37186 .7685 .43233 .78481 .46494 .77458 .40161 Mtetra
.591 .414 .611 r
.77458 .40161 .78481 .46494 .79828 .45885 .78784 .39533 Mtetra
.647 .452 .606 r
.78784 .39533 .79828 .45885 .8105 .43795 .80005 .37626 Mtetra
.22 .162 .576 r
.80005 .37626 .8105 .43795 .82879 .48396 .81818 .42338 Mtetra
.635 .447 .611 r
.81818 .42338 .82879 .48396 .8413 .46463 .83091 .40803 Mtetra
.679 .48 .609 r
.83091 .40803 .8413 .46463 .85276 .43561 .84269 .38347 Mtetra
.38 .284 .62 r
.84269 .38347 .85276 .43561 .86936 .45682 .8594 .40753 Mtetra
.689 .494 .618 r
.8594 .40753 .86936 .45682 .88102 .43031 .87129 .38406 Mtetra
.594 .436 .637 r
.87129 .38406 .88102 .43031 .89489 .42428 .88518 .37922 Mtetra
.656 .365 .466 r
.26195 .60273 .27258 .56685 .2827 .57864 .27189 .61878 Mtetra
.392 .122 .379 r
.27189 .61878 .2827 .57864 .29478 .56376 .28396 .60694 Mtetra
.514 .238 .433 r
.28396 .60694 .29478 .56376 .30616 .55923 .29538 .60474 Mtetra
.344 .089 .376 r
.29538 .60474 .30616 .55923 .3184 .54144 .30781 .58745 Mtetra
.163 0 .304 r
.30781 .58745 .3184 .54144 .33112 .51438 .32088 .55903 Mtetra
.612 .332 .468 r
.32088 .55903 .33112 .51438 .34158 .52687 .33159 .57003 Mtetra
.379 .117 .385 r
.33159 .57003 .34158 .52687 .35339 .516 .34379 .55581 Mtetra
.165 0 .29 r
.34379 .55581 .35339 .516 .36568 .49518 .35652 .53083 Mtetra
.607 .313 .445 r
.35652 .53083 .36568 .49518 .37644 .50716 .36757 .53957 Mtetra
.6 .3 .432 r
.36757 .53957 .37644 .50716 .38743 .51731 .37881 .54702 Mtetra
.48 .179 .378 r
.37881 .54702 .38743 .51731 .39901 .51584 .39061 .5437 Mtetra
.117 0 .214 r
.39061 .5437 .39901 .51584 .41124 .49719 .40305 .52425 Mtetra
.815 .512 .476 r
.40305 .52425 .41124 .49719 .42121 .55017 .41297 .57962 Mtetra
.068 0 .204 r
.41297 .57962 .42121 .55017 .43374 .5256 .42565 .55704 Mtetra
0 0 .03 r
.42565 .55704 .43374 .5256 .44654 .48567 .43863 .5196 Mtetra
.85 .555 .489 r
.43863 .5196 .44654 .48567 .45655 .57437 .44848 .61487 Mtetra
.915 .788 .31 r
.44848 .61487 .45655 .57437 .47034 .47774 .46265 .51908 Mtetra
.647 .355 .463 r
.46265 .51908 .47034 .47774 .48209 .49134 .47452 .53607 Mtetra
.675 .385 .473 r
.47452 .53607 .48209 .49134 .49394 .51331 .48651 .56051 Mtetra
0 0 .103 r
.48651 .56051 .49394 .51331 .50647 .45571 .49941 .50108 Mtetra
.506 .233 .435 r
.49941 .50108 .50647 .45571 .51856 .45359 .51173 .49751 Mtetra
.582 .298 .451 r
.51173 .49751 .51856 .45359 .53074 .46268 .52411 .50426 Mtetra
.463 .191 .414 r
.52411 .50426 .53074 .46268 .543 .45879 .53657 .49676 Mtetra
0 0 0 r
.53657 .49676 .543 .45879 .55483 .40352 .54868 .43626 Mtetra
.853 .546 .468 r
.54868 .43626 .55483 .40352 .56823 .49393 .56207 .52575 Mtetra
.815 .739 .215 r
.56207 .52575 .56823 .49393 .57973 .42564 .57382 .45341 Mtetra
.729 .406 .433 r
.57382 .45341 .57973 .42564 .59278 .453 .58698 .48044 Mtetra
.673 .349 .417 r
.58698 .48044 .59278 .453 .60584 .46889 .60019 .49728 Mtetra
.545 .232 .387 r
.60019 .49728 .60584 .46889 .61866 .46893 .61324 .49942 Mtetra
.213 0 .295 r
.61324 .49942 .61866 .46893 .63083 .44604 .62572 .47921 Mtetra
.688 .373 .437 r
.62572 .47921 .63083 .44604 .64439 .46386 .63959 .50151 Mtetra
.647 .342 .441 r
.63959 .50151 .64439 .46386 .65795 .47597 .65352 .51806 Mtetra
0 0 .02 r
.65352 .51806 .65795 .47597 .66774 .39889 .66372 .44185 Mtetra
.798 .486 .462 r
.66372 .44185 .66774 .39889 .68377 .46144 .68008 .50886 Mtetra
0 0 .265 r
.68008 .50886 .68377 .46144 .69437 .40919 .69098 .45555 Mtetra
.339 .101 .399 r
.69098 .45555 .69437 .40919 .70643 .3886 .70326 .43345 Mtetra
.63 .335 .452 r
.70326 .43345 .70643 .3886 .72072 .40604 .71768 .44926 Mtetra
.256 .032 .37 r
.71768 .44926 .72072 .40604 .73259 .38232 .72958 .42151 Mtetra
.53 .243 .423 r
.72958 .42151 .73259 .38232 .74624 .38589 .74321 .42146 Mtetra
.327 .073 .367 r
.74321 .42146 .74624 .38589 .75872 .37186 .75566 .40347 Mtetra
.716 .388 .421 r
.75566 .40347 .75872 .37186 .77458 .40161 .77152 .43116 Mtetra
.427 .134 .363 r
.77152 .43116 .77458 .40161 .78784 .39533 .78486 .42314 Mtetra
.231 0 .304 r
.78486 .42314 .78784 .39533 .80005 .37626 .79725 .40357 Mtetra
.811 .464 .401 r
.79725 .40357 .80005 .37626 .81818 .42338 .81574 .4534 Mtetra
.367 .088 .352 r
.81574 .4534 .81818 .42338 .83091 .40803 .82894 .4406 Mtetra
.266 .02 .343 r
.82894 .4406 .83091 .40803 .84269 .38347 .84129 .41919 Mtetra
.708 .381 .422 r
.84129 .41919 .84269 .38347 .8594 .40753 .8587 .44817 Mtetra
.345 .101 .393 r
.8587 .44817 .8594 .40753 .87129 .38406 .87122 .42775 Mtetra
.517 .237 .429 r
.87122 .42775 .87129 .38406 .88518 .37922 .8857 .42561 Mtetra
.336 .238 .593 r
.25767 .55502 .26195 .60273 .27189 .61878 .26722 .57414 Mtetra
.62 .452 .633 r
.26722 .57414 .27189 .61878 .28396 .60694 .27894 .56614 Mtetra
.549 .407 .64 r
.27894 .56614 .28396 .60694 .29538 .60474 .29005 .56715 Mtetra
.676 .503 .645 r
.29005 .56715 .29538 .60474 .30781 .58745 .30228 .55231 Mtetra
.742 .553 .638 r
.30228 .55231 .30781 .58745 .32088 .55903 .31526 .5251 Mtetra
.413 .328 .65 r
.31526 .5251 .32088 .55903 .33159 .57003 .32592 .53524 Mtetra
.69 .518 .649 r
.32592 .53524 .33159 .57003 .34379 .55581 .33819 .5191 Mtetra
.74 .548 .635 r
.33819 .5191 .34379 .55581 .35652 .53083 .35104 .49135 Mtetra
.508 .38 .641 r
.35104 .49135 .35652 .53083 .36757 .53957 .36217 .49617 Mtetra
.526 .386 .633 r
.36217 .49617 .36757 .53957 .37881 .54702 .37347 .49971 Mtetra
.605 .438 .628 r
.37347 .49971 .37881 .54702 .39061 .5437 .38529 .4933 Mtetra
.678 .487 .62 r
.38529 .4933 .39061 .5437 .40305 .52425 .39771 .47228 Mtetra
0 0 .399 r
.39771 .47228 .40305 .52425 .41297 .57962 .40744 .52563 Mtetra
.672 .48 .617 r
.40744 .52563 .41297 .57962 .42565 .55704 .41998 .50449 Mtetra
.723 .518 .612 r
.41998 .50449 .42565 .55704 .43863 .5196 .43282 .47018 Mtetra
.81 .584 .025 r
.43282 .47018 .43863 .5196 .44848 .61487 .44231 .56654 Mtetra
.839 .605 .584 r
.44231 .56654 .44848 .61487 .46265 .51908 .45645 .47641 Mtetra
.318 .243 .612 r
.45645 .47641 .46265 .51908 .47452 .53607 .46812 .49651 Mtetra
.17 .146 .587 r
.46812 .49651 .47452 .53607 .48651 .56051 .47994 .52322 Mtetra
.822 .601 .604 r
.47994 .52322 .48651 .56051 .49941 .50108 .49286 .46609 Mtetra
.596 .454 .659 r
.49286 .46609 .49941 .50108 .51173 .49751 .50511 .46246 Mtetra
.502 .391 .66 r
.50511 .46246 .51173 .49751 .52411 .50426 .5174 .46747 Mtetra
.646 .485 .65 r
.5174 .46747 .52411 .50426 .53657 .49676 .52979 .45721 Mtetra
.828 .601 .595 r
.52979 .45721 .53657 .49676 .54868 .43626 .54191 .39419 Mtetra
.722 .496 0 r
.54191 .39419 .54868 .43626 .56207 .52575 .55498 .47793 Mtetra
.826 .592 .585 r
.55498 .47793 .56207 .52575 .57382 .45341 .56672 .40371 Mtetra
.33 .242 .602 r
.56672 .40371 .57382 .45341 .58698 .48044 .57963 .42751 Mtetra
.437 .313 .613 r
.57963 .42751 .58698 .48044 .60019 .49728 .59264 .44267 Mtetra
.542 .386 .619 r
.59264 .44267 .60019 .49728 .61324 .49942 .60553 .44503 Mtetra
.656 .467 .616 r
.60553 .44503 .61324 .49942 .62572 .47921 .61796 .42709 Mtetra
.341 .249 .603 r
.61796 .42709 .62572 .47921 .63959 .50151 .63173 .45177 Mtetra
.384 .283 .616 r
.63173 .45177 .63959 .50151 .65352 .51806 .64561 .4716 Mtetra
.829 .593 .581 r
.64561 .4716 .65352 .51806 .66372 .44185 .65604 .40055 Mtetra
0 0 .319 r
.65604 .40055 .66372 .44185 .68008 .50886 .67226 .46943 Mtetra
.809 .587 .601 r
.67226 .46943 .68008 .50886 .69098 .45555 .6833 .41896 Mtetra
.713 .529 .639 r
.6833 .41896 .69098 .45555 .70326 .43345 .69558 .39769 Mtetra
.388 .317 .655 r
.69558 .39769 .70326 .43345 .71768 .44926 .70982 .41218 Mtetra
.751 .553 .627 r
.70982 .41218 .71768 .44926 .72958 .42151 .72156 .38241 Mtetra
.589 .443 .651 r
.72156 .38241 .72958 .42151 .74321 .42146 .73487 .37889 Mtetra
.697 .507 .628 r
.73487 .37889 .74321 .42146 .75566 .40347 .74699 .35733 Mtetra
.344 .264 .621 r
.74699 .35733 .75566 .40347 .77152 .43116 .76235 .38057 Mtetra
.625 .449 .624 r
.76235 .38057 .77152 .43116 .78486 .42314 .77533 .36967 Mtetra
.669 .475 .614 r
.77533 .36967 .78486 .42314 .79725 .40357 .78749 .34877 Mtetra
.145 .117 .566 r
.78749 .34877 .79725 .40357 .81574 .4534 .80559 .3969 Mtetra
.619 .439 .617 r
.80559 .3969 .81574 .4534 .82894 .4406 .81878 .38567 Mtetra
.655 .464 .614 r
.81878 .38567 .82894 .4406 .84129 .41919 .8313 .36735 Mtetra
.301 .23 .608 r
.8313 .36735 .84129 .41919 .8587 .44817 .8488 .3991 Mtetra
.655 .471 .624 r
.8488 .3991 .8587 .44817 .87122 .42775 .86165 .38292 Mtetra
.549 .409 .642 r
.86165 .38292 .87122 .42775 .8857 .42561 .87639 .38425 Mtetra
.792 .442 .394 r
.24884 .56488 .25767 .55502 .26722 .57414 .25817 .58715 Mtetra
.307 0 .109 r
.25817 .58715 .26722 .57414 .27894 .56614 .26972 .58271 Mtetra
.589 .232 .331 r
.26972 .58271 .27894 .56614 .29005 .56715 .28064 .58762 Mtetra
.172 0 .153 r
.28064 .58762 .29005 .56715 .30228 .55231 .2928 .57592 Mtetra
0 0 0 r
.2928 .57592 .30228 .55231 .31526 .5251 .30585 .55055 Mtetra
.644 .327 .419 r
.30585 .55055 .31526 .5251 .32592 .53524 .31654 .56193 Mtetra
.134 0 .198 r
.31654 .56193 .32592 .53524 .33819 .5191 .32903 .54492 Mtetra
0 0 0 r
.32903 .54492 .33819 .5191 .35104 .49135 .34221 .51463 Mtetra
.541 .213 .362 r
.34221 .51463 .35104 .49135 .36217 .49617 .35361 .51651 Mtetra
.504 .163 .322 r
.35361 .51651 .36217 .49617 .37347 .49971 .36519 .51646 Mtetra
.163 0 .109 r
.36519 .51646 .37347 .49971 .38529 .4933 .37729 .50633 Mtetra
.758 .872 .447 r
.37729 .50633 .38529 .4933 .39771 .47228 .38998 .48205 Mtetra
.877 .55 .429 r
.38998 .48205 .39771 .47228 .40744 .52563 .39973 .53413 Mtetra
.868 .953 .602 r
.39973 .53413 .40744 .52563 .41998 .50449 .41242 .51232 Mtetra
.983 .908 .608 r
.41242 .51232 .41998 .50449 .43282 .47018 .42539 .47871 Mtetra
.918 .611 .447 r
.42539 .47871 .43282 .47018 .44231 .56654 .43465 .57879 Mtetra
.995 .793 .519 r
.43465 .57879 .44231 .56654 .45645 .47641 .44903 .49089 Mtetra
.774 .421 .386 r
.44903 .49089 .45645 .47641 .46812 .49651 .46069 .51521 Mtetra
.783 .446 .417 r
.46069 .51521 .46812 .49651 .47994 .52322 .4725 .54618 Mtetra
.896 .826 .356 r
.4725 .54618 .47994 .52322 .49286 .46609 .48566 .49078 Mtetra
.481 .159 .343 r
.48566 .49078 .49286 .46609 .50511 .46246 .49805 .48869 Mtetra
.578 .255 .386 r
.49805 .48869 .50511 .46246 .5174 .46747 .51049 .49391 Mtetra
.309 .014 .291 r
.51049 .49391 .5174 .46747 .52979 .45721 .52305 .48197 Mtetra
.916 .808 .338 r
.52305 .48197 .52979 .45721 .54191 .39419 .53544 .41497 Mtetra
.879 .56 .442 r
.53544 .41497 .54191 .39419 .55498 .47793 .54846 .49675 Mtetra
.987 .815 .424 r
.54846 .49675 .55498 .47793 .56672 .40371 .56043 .41752 Mtetra
.756 .383 .349 r
.56043 .41752 .56672 .40371 .57963 .42751 .57336 .43833 Mtetra
.702 .296 .276 r
.57336 .43833 .57963 .42751 .59264 .44267 .5864 .45126 Mtetra
.469 .012 .085 r
.5864 .45126 .59264 .44267 .60553 .44503 .59936 .4526 Mtetra
.654 .864 .483 r
.59936 .4526 .60553 .44503 .61796 .42709 .61192 .43496 Mtetra
.825 .426 .292 r
.61192 .43496 .61796 .42709 .63173 .45177 .62581 .46195 Mtetra
.79 .392 .3 r
.62581 .46195 .63173 .45177 .64561 .4716 .63988 .48529 Mtetra
.981 .818 .417 r
.63988 .48529 .64561 .4716 .65604 .40055 .65068 .41699 Mtetra
.891 .549 .394 r
.65068 .41699 .65604 .40055 .67226 .46943 .66712 .49109 Mtetra
.689 .695 .164 r
.66712 .49109 .67226 .46943 .6833 .41896 .67853 .44295 Mtetra
.128 0 .221 r
.67853 .44295 .6833 .41896 .69558 .39769 .6911 .42341 Mtetra
.664 .326 .389 r
.6911 .42341 .69558 .39769 .70982 .41218 .70554 .43897 Mtetra
0 0 .171 r
.70554 .43897 .70982 .41218 .72156 .38241 .71743 .40764 Mtetra
.429 .115 .33 r
.71743 .40764 .72156 .38241 .73487 .37889 .73077 .40176 Mtetra
0 0 .165 r
.73077 .40176 .73487 .37889 .74699 .35733 .74285 .37646 Mtetra
.717 .349 .35 r
.74285 .37646 .74699 .35733 .76235 .38057 .75808 .39632 Mtetra
.081 0 .111 r
.75808 .39632 .76235 .38057 .77533 .36967 .77093 .38158 Mtetra
0 0 0 r
.77093 .38158 .77533 .36967 .78749 .34877 .78299 .35752 Mtetra
.883 .489 .28 r
.78299 .35752 .78749 .34877 .80559 .3969 .80104 .40458 Mtetra
0 0 0 r
.80104 .40458 .80559 .3969 .81878 .38567 .81434 .3931 Mtetra
.81434 .3931 .81878 .38567 .8313 .36735 .82712 .37603 Mtetra
.848 .43 .24 r
.82712 .37603 .8313 .36735 .8488 .3991 .84501 .41105 Mtetra
.048 0 .022 r
.84501 .41105 .8488 .3991 .86165 .38292 .8584 .3984 Mtetra
.572 .177 .255 r
.8584 .3984 .86165 .38292 .87639 .38425 .87373 .40386 Mtetra
0 0 .464 r
.24272 .54067 .24884 .56488 .25817 .58715 .25184 .5643 Mtetra
.585 .491 .714 r
.25184 .5643 .25817 .58715 .26972 .58271 .26315 .56269 Mtetra
.313 .341 .73 r
.26315 .56269 .26972 .58271 .28064 .58762 .27377 .57115 Mtetra
.694 .599 .745 r
.27377 .57115 .28064 .58762 .2928 .57592 .28568 .56324 Mtetra
.829 .685 .704 r
.28568 .56324 .2928 .57592 .30585 .55055 .29857 .54118 Mtetra
.567 .109 0 r
.29857 .54118 .30585 .55055 .31654 .56193 .3091 .55487 Mtetra
.848 .763 .768 r
.3091 .55487 .31654 .56193 .32903 .54492 .3216 .53874 Mtetra
.907 .756 .682 r
.3216 .53874 .32903 .54492 .34221 .51463 .33491 .50775 Mtetra
.49 .691 .957 r
.33491 .50775 .34221 .51463 .35361 .51651 .34643 .50759 Mtetra
.639 .691 .882 r
.34643 .50759 .35361 .51651 .36519 .51646 .35819 .50438 Mtetra
.787 .683 .75 r
.35819 .50438 .36519 .51646 .37729 .50633 .37049 .49053 Mtetra
.835 .667 .673 r
.37049 .49053 .37729 .50633 .38998 .48205 .38338 .46266 Mtetra
.917 .585 .117 r
.38338 .46266 .38998 .48205 .39973 .53413 .39313 .5113 Mtetra
.779 .607 .668 r
.39313 .5113 .39973 .53413 .41242 .51232 .4059 .48765 Mtetra
.81 .618 .643 r
.4059 .48765 .41242 .51232 .42539 .47871 .41891 .45378 Mtetra
.974 .672 .301 r
.41891 .45378 .42539 .47871 .43465 .57879 .42791 .554 Mtetra
.892 .662 .583 r
.42791 .554 .43465 .57879 .44903 .49089 .44236 .46915 Mtetra
0 0 .439 r
.44236 .46915 .44903 .49089 .46069 .51521 .45387 .49667 Mtetra
.728 .398 0 r
.45387 .49667 .46069 .51521 .4725 .54618 .46554 .53137 Mtetra
.9 .695 .616 r
.46554 .53137 .4725 .54618 .48566 .49078 .47876 .47966 Mtetra
.508 .592 .873 r
.47876 .47966 .48566 .49078 .49805 .48869 .49115 .48035 Mtetra
.048 .397 .854 r
.49115 .48035 .49805 .48869 .51049 .49391 .50358 .48709 Mtetra
.824 .797 .826 r
.50358 .48709 .51049 .49391 .52305 .48197 .51621 .47509 Mtetra
.953 .737 .573 r
.51621 .47509 .52305 .48197 .53544 .41497 .52876 .40645 Mtetra
.959 .621 .307 r
.52876 .40645 .53544 .41497 .54846 .49675 .54162 .48544 Mtetra
.945 .715 .558 r
.54162 .48544 .54846 .49675 .56043 .41752 .55374 .40268 Mtetra
0 .085 .642 r
.55374 .40268 .56043 .41752 .57336 .43833 .56658 .41958 Mtetra
.308 .358 .752 r
.56658 .41958 .57336 .43833 .5864 .45126 .57952 .42896 Mtetra
.577 .496 .727 r
.57952 .42896 .5864 .45126 .59936 .4526 .5924 .42775 Mtetra
.745 .582 .674 r
.5924 .42775 .59936 .4526 .61192 .43496 .60494 .4091 Mtetra
0 .043 .58 r
.60494 .4091 .61192 .43496 .62581 .46195 .61873 .43623 Mtetra
0 .092 .609 r
.61873 .43623 .62581 .46195 .63988 .48529 .63278 .46128 Mtetra
.894 .664 .583 r
.63278 .46128 .63988 .48529 .65068 .41699 .6438 .39651 Mtetra
.899 .568 .081 r
.6438 .39651 .65068 .41699 .66712 .49109 .66023 .47402 Mtetra
.896 .692 .62 r
.66023 .47402 .66712 .49109 .67853 .44295 .67191 .42986 Mtetra
.81 .7 .743 r
.67191 .42986 .67853 .44295 .6911 .42341 .68468 .41353 Mtetra
0 0 .556 r
.68468 .41353 .6911 .42341 .70554 .43897 .69925 .4312 Mtetra
.937 .786 .669 r
.69925 .4312 .70554 .43897 .71743 .40764 .71126 .40041 Mtetra
.729 .794 .904 r
.71126 .40041 .71743 .40764 .73077 .40176 .72459 .39352 Mtetra
.927 .787 .686 r
.72459 .39352 .73077 .40176 .74285 .37646 .73659 .3658 Mtetra
0 .098 .651 r
.73659 .3658 .74285 .37646 .75808 .39632 .75157 .38221 Mtetra
.823 .697 .725 r
.75157 .38221 .75808 .39632 .77093 .38158 .76416 .36359 Mtetra
.845 .672 .666 r
.76416 .36359 .77093 .38158 .78299 .35752 .77598 .33592 Mtetra
0 0 .387 r
.77598 .33592 .78299 .35752 .80104 .40458 .79365 .37961 Mtetra
.704 .562 .691 r
.79365 .37961 .80104 .40458 .81434 .3931 .80679 .36644 Mtetra
.727 .568 .674 r
.80679 .36644 .81434 .3931 .82712 .37603 .81955 .34929 Mtetra
0 .016 .566 r
.81955 .34929 .82712 .37603 .84501 .41105 .83745 .38531 Mtetra
.67 .54 .697 r
.83745 .38531 .84501 .41105 .8584 .3984 .85111 .37549 Mtetra
.399 .391 .734 r
.85111 .37549 .8584 .3984 .87373 .40386 .8668 .38456 Mtetra
0 0 .318 r
.23617 .52159 .24272 .54067 .25184 .5643 .24522 .54517 Mtetra
.556 .499 .748 r
.24522 .54517 .25184 .5643 .26315 .56269 .25638 .54514 Mtetra
.106 .235 .715 r
.25638 .54514 .26315 .56269 .27377 .57115 .26676 .55638 Mtetra
.647 .594 .781 r
.26676 .55638 .27377 .57115 .28568 .56324 .27842 .55209 Mtetra
.823 .7 .729 r
.27842 .55209 .28568 .56324 .29857 .54118 .2911 .53378 Mtetra
.796 .322 0 r
.2911 .53378 .29857 .54118 .3091 .55487 .30139 .55083 Mtetra
.863 .833 .816 r
.30139 .55083 .3091 .55487 .3216 .53874 .31381 .53696 Mtetra
.939 .809 .689 r
.31381 .53696 .3216 .53874 .33491 .50775 .32719 .50673 Mtetra
.204 .722 .874 r
.32719 .50673 .33491 .50775 .34643 .50759 .33879 .50596 Mtetra
.661 .923 .975 r
.33879 .50596 .34643 .50759 .35819 .50438 .3507 .50069 Mtetra
.892 .834 .782 r
.3507 .50069 .35819 .50438 .37049 .49053 .36323 .48364 Mtetra
.908 .753 .677 r
.36323 .48364 .37049 .49053 .38338 .46266 .37637 .45205 Mtetra
.948 .589 .243 r
.37637 .45205 .38338 .46266 .39313 .5113 .38618 .49692 Mtetra
.843 .681 .682 r
.38618 .49692 .39313 .5113 .4059 .48765 .39912 .47023 Mtetra
.852 .666 .649 r
.39912 .47023 .4059 .48765 .41891 .45378 .41226 .43458 Mtetra
.975 .667 .338 r
.41226 .43458 .41891 .45378 .42791 .554 .42105 .5337 Mtetra
.905 .676 .582 r
.42105 .5337 .42791 .554 .44236 .46915 .43562 .45032 Mtetra
0 0 .29 r
.43562 .45032 .44236 .46915 .45387 .49667 .447 .48008 Mtetra
.838 .482 0 r
.447 .48008 .45387 .49667 .46554 .53137 .45852 .51811 Mtetra
.904 .705 .624 r
.45852 .51811 .46554 .53137 .47876 .47966 .4718 .47028 Mtetra
.281 .514 .901 r
.4718 .47028 .47876 .47966 .49115 .48035 .48416 .47457 Mtetra
0 .122 .589 r
.48416 .47457 .49115 .48035 .50358 .48709 .49659 .48415 Mtetra
.831 .91 .892 r
.49659 .48415 .50358 .48709 .51621 .47509 .50928 .47364 Mtetra
.974 .764 .56 r
.50928 .47364 .51621 .47509 .52876 .40645 .52203 .40461 Mtetra
.945 .608 .351 r
.52203 .40461 .52876 .40645 .54162 .48544 .53477 .48246 Mtetra
.972 .746 .539 r
.53477 .48246 .54162 .48544 .55374 .40268 .54708 .39657 Mtetra
.563 .05 0 r
.54708 .39657 .55374 .40268 .56658 .41958 .55989 .40992 Mtetra
.228 .473 .884 r
.55989 .40992 .56658 .41958 .57952 .42896 .57277 .41545 Mtetra
.654 .625 .808 r
.57277 .41545 .57952 .42896 .5924 .42775 .5856 .41077 Mtetra
.809 .658 .695 r
.5856 .41077 .5924 .42775 .60494 .4091 .59811 .38971 Mtetra
0 0 .527 r
.59811 .38971 .60494 .4091 .61873 .43623 .61181 .41553 Mtetra
0 0 .565 r
.61181 .41553 .61873 .43623 .63278 .46128 .62579 .44085 Mtetra
.906 .68 .584 r
.62579 .44085 .63278 .46128 .6438 .39651 .637 .37831 Mtetra
.923 .585 .129 r
.637 .37831 .6438 .39651 .66023 .47402 .65339 .45863 Mtetra
.898 .704 .631 r
.65339 .45863 .66023 .47402 .67191 .42986 .66532 .41837 Mtetra
.788 .716 .785 r
.66532 .41837 .67191 .42986 .68468 .41353 .67833 .40585 Mtetra
.648 .183 0 r
.67833 .40585 .68468 .41353 .69925 .4312 .69307 .42682 Mtetra
.96 .839 .679 r
.69307 .42682 .69925 .4312 .71126 .40041 .7053 .398 Mtetra
.668 .934 .969 r
.7053 .398 .71126 .40041 .72459 .39352 .71875 .3917 Mtetra
.979 .879 .662 r
.71875 .3917 .72459 .39352 .73659 .3658 .73079 .36286 Mtetra
.625 .077 0 r
.73079 .36286 .73659 .3658 .75157 .38221 .74564 .37695 Mtetra
.937 .854 .735 r
.74564 .37695 .75157 .38221 .76416 .36359 .75807 .35485 Mtetra
.939 .781 .659 r
.75807 .35485 .76416 .36359 .77598 .33592 .76967 .32331 Mtetra
.722 .343 0 r
.76967 .32331 .77598 .33592 .79365 .37961 .78697 .36316 Mtetra
.784 .661 .727 r
.78697 .36316 .79365 .37961 .80679 .36644 .79988 .34702 Mtetra
.783 .636 .699 r
.79988 .34702 .80679 .36644 .81955 .34929 .81251 .32821 Mtetra
0 0 .511 r
.81251 .32821 .81955 .34929 .83745 .38531 .8303 .36378 Mtetra
.672 .565 .726 r
.8303 .36378 .83745 .38531 .85111 .37549 .8441 .35538 Mtetra
.304 .353 .748 r
.8441 .35538 .85111 .37549 .8668 .38456 .86006 .36714 Mtetra
.828 .42 0 r
.229 .50944 .23617 .52159 .24522 .54517 .23812 .53159 Mtetra
.543 .557 .819 r
.23812 .53159 .24522 .54517 .25638 .54514 .24927 .53165 Mtetra
0 .066 .63 r
.24927 .53165 .25638 .54514 .26676 .55638 .25949 .54447 Mtetra
.585 .608 .841 r
.25949 .54447 .26676 .55638 .27842 .55209 .27095 .54302 Mtetra
.819 .729 .766 r
.27095 .54302 .27842 .55209 .2911 .53378 .28343 .52829 Mtetra
.874 .433 .105 r
.28343 .52829 .2911 .53378 .30139 .55083 .29343 .54922 Mtetra
.84 .918 .887 r
.29343 .54922 .30139 .55083 .31381 .53696 .30572 .53864 Mtetra
.961 .864 .698 r
.30572 .53864 .31381 .53696 .32719 .50673 .31909 .51052 Mtetra
.293 0 0 r
.31909 .51052 .32719 .50673 .33879 .50596 .3307 .51069 Mtetra
0 0 0 r
.3307 .51069 .33879 .50596 .3507 .50069 .34271 .50477 Mtetra
.933 .968 .742 r
.34271 .50477 .3507 .50069 .36323 .48364 .35545 .48556 Mtetra
.971 .842 .657 r
.35545 .48556 .36323 .48364 .37637 .45205 .36888 .45065 Mtetra
.917 .557 .336 r
.36888 .45065 .37637 .45205 .38618 .49692 .37878 .49199 Mtetra
.924 .781 .684 r
.37878 .49199 .38618 .49692 .39912 .47023 .39197 .46152 Mtetra
.911 .734 .649 r
.39197 .46152 .39912 .47023 .41226 .43458 .40532 .42281 Mtetra
.966 .654 .375 r
.40532 .42281 .41226 .43458 .42105 .5337 .41396 .51981 Mtetra
.925 .699 .578 r
.41396 .51981 .42105 .5337 .43562 .45032 .42874 .43609 Mtetra
.807 .428 0 r
.42874 .43609 .43562 .45032 .447 .48008 .44003 .46681 Mtetra
.908 .535 .091 r
.44003 .46681 .447 .48008 .45852 .51811 .45141 .50725 Mtetra
.913 .722 .632 r
.45141 .50725 .45852 .51811 .4718 .47028 .46475 .46282 Mtetra
0 .28 .765 r
.46475 .46282 .4718 .47028 .48416 .47457 .47707 .47096 Mtetra
.699 .164 0 r
.47707 .47096 .48416 .47457 .49659 .48415 .48948 .48427 Mtetra
.689 .974 .915 r
.48948 .48427 .49659 .48415 .50928 .47364 .50223 .47655 Mtetra
.988 .788 .547 r
.50223 .47655 .50928 .47364 .52203 .40461 .51519 .40846 Mtetra
.93 .595 .381 r
.51519 .40846 .52203 .40461 .53477 .48246 .52785 .48705 Mtetra
.99 .772 .514 r
.52785 .48705 .53477 .48246 .54708 .39657 .54041 .39888 Mtetra
.693 .18 .012 r
.54041 .39888 .54708 .39657 .55989 .40992 .55323 .40956 Mtetra
.16 0 0 r
.55323 .40956 .55989 .40992 .57277 .41545 .56612 .4115 Mtetra
.785 .892 .921 r
.56612 .4115 .57277 .41545 .5856 .41077 .57894 .40295 Mtetra
.906 .779 .71 r
.57894 .40295 .5856 .41077 .59811 .38971 .59145 .37844 Mtetra
.618 .212 0 r
.59145 .37844 .59811 .38971 .61181 .41553 .60505 .40175 Mtetra
0 0 .436 r
.60505 .40175 .61181 .41553 .62579 .44085 .61896 .42586 Mtetra
.93 .707 .579 r
.61896 .42586 .62579 .44085 .637 .37831 .63032 .36389 Mtetra
.942 .598 .184 r
.63032 .36389 .637 .37831 .65339 .45863 .64663 .44602 Mtetra
.91 .727 .642 r
.64663 .44602 .65339 .45863 .66532 .41837 .65878 .40892 Mtetra
.753 .745 .845 r
.65878 .40892 .66532 .41837 .67833 .40585 .67202 .40018 Mtetra
.786 .315 0 r
.67202 .40018 .67833 .40585 .69307 .42682 .68697 .42514 Mtetra
.969 .895 .695 r
.68697 .42514 .69307 .42682 .7053 .398 .69949 .39942 Mtetra
.244 .751 .717 r
.69949 .39942 .7053 .398 .71875 .3917 .71315 .39521 Mtetra
.958 .929 .592 r
.71315 .39521 .71875 .3917 .73079 .36286 .72535 .36674 Mtetra
.709 .204 .035 r
.72535 .36674 .73079 .36286 .74564 .37695 .74022 .38002 Mtetra
.933 .948 .615 r
.74022 .38002 .74564 .37695 .75807 .35485 .75259 .35534 Mtetra
.993 .879 .586 r
.75259 .35534 .75807 .35485 .76967 .32331 .76405 .32021 Mtetra
.865 .423 .031 r
.76405 .32021 .76967 .32331 .78697 .36316 .78105 .35633 Mtetra
.913 .836 .756 r
.78105 .35633 .78697 .36316 .79988 .34702 .79371 .3364 Mtetra
.885 .765 .724 r
.79371 .3364 .79988 .34702 .81251 .32821 .80614 .31462 Mtetra
0 0 .377 r
.80614 .31462 .81251 .32821 .8303 .36378 .82372 .34838 Mtetra
.706 .639 .78 r
.82372 .34838 .8303 .36378 .8441 .35538 .83753 .33979 Mtetra
.159 .312 .77 r
.83753 .33979 .8441 .35538 .86006 .36714 .85362 .35292 Mtetra
.806 .427 .338 r
.22017 .51508 .229 .50944 .23812 .53159 .22951 .53479 Mtetra
.115 0 0 r
.22951 .53479 .23812 .53159 .24927 .53165 .24083 .53348 Mtetra
.773 .322 .179 r
.24083 .53348 .24927 .53165 .25949 .54447 .25104 .54655 Mtetra
.199 0 0 r
.25104 .54655 .25949 .54447 .27095 .54302 .26242 .54676 Mtetra
.802 .999 .812 r
.26242 .54676 .27095 .54302 .28343 .52829 .27479 .53481 Mtetra
.825 .458 .359 r
.27479 .53481 .28343 .52829 .29343 .54922 .28453 .5597 Mtetra
.077 0 0 r
.28453 .5597 .29343 .54922 .30572 .53864 .29666 .55292 Mtetra
.776 .886 .47 r
.29666 .55292 .30572 .53864 .31909 .51052 .31 .52781 Mtetra
.54 .174 .296 r
.31 .52781 .31909 .51052 .3307 .51069 .32157 .53041 Mtetra
.376 .027 .239 r
.32157 .53041 .3307 .51069 .34271 .50477 .33366 .52541 Mtetra
0 0 0 r
.33366 .52541 .34271 .50477 .35545 .48556 .34662 .50528 Mtetra
.835 .854 .397 r
.34662 .50528 .35545 .48556 .36888 .45065 .36038 .46777 Mtetra
.817 .488 .433 r
.36038 .46777 .36888 .45065 .37878 .49199 .3704 .50665 Mtetra
.908 .902 .495 r
.3704 .50665 .37878 .49199 .39197 .46152 .38394 .47201 Mtetra
.992 .882 .569 r
.38394 .47201 .39197 .46152 .40532 .42281 .39763 .42919 Mtetra
.922 .611 .438 r
.39763 .42919 .40532 .42281 .41396 .51981 .40621 .52404 Mtetra
.979 .766 .548 r
.40621 .52404 .41396 .51981 .42874 .43609 .42132 .43768 Mtetra
.879 .488 .289 r
.42132 .43768 .42874 .43609 .44003 .46681 .43261 .46816 Mtetra
.904 .537 .329 r
.43261 .46816 .44003 .46681 .45141 .50725 .44393 .51002 Mtetra
.986 .84 .614 r
.44393 .51002 .45141 .50725 .46475 .46282 .45738 .46772 Mtetra
.715 .253 .152 r
.45738 .46772 .46475 .46282 .47707 .47096 .4697 .47946 Mtetra
.76 .352 .278 r
.4697 .47946 .47707 .47096 .48948 .48427 .48212 .49694 Mtetra
.322 0 .099 r
.48212 .49694 .48948 .48427 .50223 .47655 .49496 .4929 Mtetra
.989 .837 .461 r
.49496 .4929 .50223 .47655 .51519 .40846 .50818 .42655 Mtetra
.887 .563 .43 r
.50818 .42655 .51519 .40846 .52785 .48705 .52079 .50826 Mtetra
.989 .809 .423 r
.52079 .50826 .52785 .48705 .54041 .39888 .53368 .41846 Mtetra
.627 .268 .341 r
.53368 .41846 .54041 .39888 .55323 .40956 .54661 .42787 Mtetra
.471 .108 .266 r
.54661 .42787 .55323 .40956 .56612 .4115 .5596 .42706 Mtetra
.079 0 .057 r
.5596 .42706 .56612 .4115 .57894 .40295 .57251 .41477 Mtetra
.776 .85 .399 r
.57251 .41477 .57894 .40295 .59145 .37844 .58511 .38612 Mtetra
.783 .362 .249 r
.58511 .38612 .59145 .37844 .60505 .40175 .59868 .40625 Mtetra
.812 .372 .196 r
.59868 .40625 .60505 .40175 .61896 .42586 .61257 .42808 Mtetra
.996 .8 .524 r
.61257 .42808 .61896 .42586 .63032 .36389 .62407 .36455 Mtetra
.943 .592 .317 r
.62407 .36455 .63032 .36389 .64663 .44602 .64033 .44779 Mtetra
.991 .881 .606 r
.64033 .44779 .64663 .44602 .65878 .40892 .65271 .41242 Mtetra
0 0 0 r
.65271 .41242 .65878 .40892 .67202 .40018 .66618 .40682 Mtetra
.837 .419 .243 r
.66618 .40682 .67202 .40018 .68697 .42514 .68139 .43603 Mtetra
0 0 0 r
.68139 .43603 .68697 .42514 .69949 .39942 .69427 .41395 Mtetra
.446 .05 .193 r
.69427 .41395 .69949 .39942 .71315 .39521 .70826 .41307 Mtetra
0 0 0 r
.70826 .41307 .71315 .39521 .72535 .36674 .72077 .3863 Mtetra
.667 .293 .328 r
.72077 .3863 .72535 .36674 .74022 .38002 .73584 .40055 Mtetra
0 0 .084 r
.73584 .40055 .74022 .38002 .75259 .35534 .74833 .37449 Mtetra
0 0 0 r
.74833 .37449 .75259 .35534 .76405 .32021 .7598 .33638 Mtetra
.804 .417 .323 r
.7598 .33638 .76405 .32021 .78105 .35633 .77667 .36969 Mtetra
0 0 0 r
.77667 .36969 .78105 .35633 .79371 .3364 .78916 .34556 Mtetra
.66 .785 .322 r
.78916 .34556 .79371 .3364 .80614 .31462 .8014 .31981 Mtetra
.844 .4 .164 r
.8014 .31981 .80614 .31462 .82372 .34838 .81878 .35093 Mtetra
.525 .886 .666 r
.81878 .35093 .82372 .34838 .83753 .33979 .83253 .34055 Mtetra
.649 .091 0 r
.83253 .34055 .83753 .33979 .85362 .35292 .84869 .35363 Mtetra
.408 .272 .583 r
.21724 .45645 .22017 .51508 .22951 .53479 .22675 .47198 Mtetra
.574 .396 .602 r
.22675 .47198 .22951 .53479 .24083 .53348 .23814 .46792 Mtetra
.466 .311 .586 r
.23814 .46792 .24083 .53348 .25104 .54655 .24831 .47899 Mtetra
.547 .372 .595 r
.24831 .47899 .25104 .54655 .26242 .54676 .25951 .47911 Mtetra
.604 .416 .6 r
.25951 .47911 .26242 .54676 .27479 .53481 .27158 .46894 Mtetra
.313 .196 .555 r
.27158 .46894 .27479 .53481 .28453 .5597 .28095 .49565 Mtetra
.568 .391 .602 r
.28095 .49565 .28453 .5597 .29666 .55292 .29267 .49248 Mtetra
.66 .464 .608 r
.29267 .49248 .29666 .55292 .31 .52781 .30562 .47165 Mtetra
.505 .351 .606 r
.30562 .47165 .31 .52781 .32157 .53041 .31683 .4773 Mtetra
.57 .403 .616 r
.31683 .4773 .32157 .53041 .33366 .52541 .32867 .47456 Mtetra
.667 .477 .619 r
.32867 .47456 .33366 .52541 .34662 .50528 .34147 .45567 Mtetra
.739 .531 .612 r
.34147 .45567 .34662 .50528 .36038 .46777 .35518 .41827 Mtetra
.053 .032 .511 r
.35518 .41827 .36038 .46777 .3704 .50665 .36514 .45402 Mtetra
.732 .523 .609 r
.36514 .45402 .3704 .50665 .38394 .47201 .37873 .41698 Mtetra
.75 .534 .602 r
.37873 .41698 .38394 .47201 .39763 .42919 .39247 .37155 Mtetra
0 0 .1 r
.39247 .37155 .39763 .42919 .40621 .52404 .40092 .45967 Mtetra
.807 .571 .581 r
.40092 .45967 .40621 .52404 .42132 .43768 .41606 .37287 Mtetra
.323 .21 .566 r
.41606 .37287 .42132 .43768 .43261 .46816 .42718 .40021 Mtetra
.204 .121 .534 r
.42718 .40021 .43261 .46816 .44393 .51002 .43827 .4399 Mtetra
.707 .492 .594 r
.43827 .4399 .44393 .51002 .45738 .46772 .45155 .3999 Mtetra
.459 .308 .589 r
.45155 .3999 .45738 .46772 .4697 .47946 .4636 .41343 Mtetra
.403 .27 .584 r
.4636 .41343 .4697 .47946 .48212 .49694 .47575 .43352 Mtetra
.55 .38 .604 r
.47575 .43352 .48212 .49694 .49496 .4929 .48837 .43326 Mtetra
.777 .549 .589 r
.48837 .43326 .49496 .4929 .50818 .42655 .50153 .37215 Mtetra
0 0 .22 r
.50153 .37215 .50818 .42655 .52079 .50826 .51381 .45432 Mtetra
.832 .591 .575 r
.51381 .45432 .52079 .50826 .53368 .41846 .52674 .36811 Mtetra
.474 .34 .618 r
.52674 .36811 .53368 .41846 .54661 .42787 .5395 .37711 Mtetra
.568 .406 .622 r
.5395 .37711 .54661 .42787 .5596 .42706 .55234 .37463 Mtetra
.642 .456 .617 r
.55234 .37463 .5596 .42706 .57251 .41477 .56509 .3597 Mtetra
.709 .501 .605 r
.56509 .3597 .57251 .41477 .58511 .38612 .57754 .32813 Mtetra
.431 .301 .602 r
.57754 .32813 .58511 .38612 .59868 .40625 .59081 .34368 Mtetra
.426 .293 .596 r
.59081 .34368 .59868 .40625 .61257 .42808 .60435 .36116 Mtetra
.771 .536 .579 r
.60435 .36116 .61257 .42808 .62407 .36455 .61576 .29719 Mtetra
0 0 .415 r
.61576 .29719 .62407 .36455 .64033 .44779 .6315 .37611 Mtetra
.686 .472 .591 r
.6315 .37611 .64033 .44779 .65271 .41242 .64376 .34225 Mtetra
.567 .388 .598 r
.64376 .34225 .65271 .41242 .66618 .40682 .6571 .33854 Mtetra
.338 .228 .579 r
.6571 .33854 .66618 .40682 .68139 .43603 .67212 .36963 Mtetra
.635 .439 .6 r
.67212 .36963 .68139 .43603 .69427 .41395 .68504 .35184 Mtetra
.532 .371 .608 r
.68504 .35184 .69427 .41395 .70826 .41307 .69904 .3546 Mtetra
.668 .468 .605 r
.69904 .3546 .70826 .41307 .72077 .3863 .71164 .33159 Mtetra
.43 .309 .613 r
.71164 .33159 .72077 .3863 .73584 .40055 .72662 .34737 Mtetra
.687 .486 .61 r
.72662 .34737 .73584 .40055 .74833 .37449 .73907 .3224 Mtetra
.74 .523 .599 r
.73907 .3224 .74833 .37449 .7598 .33638 .75044 .28412 Mtetra
.289 .217 .599 r
.75044 .28412 .7598 .33638 .77667 .36969 .76683 .314 Mtetra
.69 .485 .604 r
.76683 .314 .77667 .36969 .78916 .34556 .77895 .28695 Mtetra
.691 .482 .599 r
.77895 .28695 .78916 .34556 .8014 .31981 .79077 .25798 Mtetra
.371 .262 .598 r
.79077 .25798 .8014 .31981 .81878 .35093 .80745 .28417 Mtetra
.613 .422 .6 r
.80745 .28417 .81878 .35093 .83253 .34055 .82072 .27099 Mtetra
.491 .338 .6 r
.82072 .27099 .83253 .34055 .84869 .35363 .83638 .28165 Mtetra
.593 .325 .48 r
.20216 .52598 .21724 .45645 .22675 .47198 .21216 .53867 Mtetra
.476 .216 .44 r
.21216 .53867 .22675 .47198 .23814 .46792 .22414 .53106 Mtetra
.579 .308 .469 r
.22414 .53106 .23814 .46792 .24831 .47899 .23472 .54013 Mtetra
.519 .25 .447 r
.23472 .54013 .24831 .47899 .25951 .47911 .24627 .53905 Mtetra
.446 .184 .421 r
.24627 .53905 .25951 .47911 .27158 .46894 .25861 .5288 Mtetra
.669 .389 .489 r
.25861 .5288 .27158 .46894 .28095 .49565 .26793 .55858 Mtetra
.525 .257 .45 r
.26793 .55858 .28095 .49565 .29267 .49248 .2797 .55848 Mtetra
.394 .143 .411 r
.2797 .55848 .29267 .49248 .30562 .47165 .29277 .54067 Mtetra
.58 .31 .472 r
.29277 .54067 .30562 .47165 .31683 .4773 .30397 .55081 Mtetra
.533 .27 .462 r
.30397 .55081 .31683 .4773 .32867 .47456 .31589 .55168 Mtetra
.425 .178 .433 r
.31589 .55168 .32867 .47456 .34147 .45567 .32896 .53446 Mtetra
.256 .037 .378 r
.32896 .53446 .34147 .45567 .35518 .41827 .34314 .49623 Mtetra
.666 .392 .497 r
.34314 .49623 .35518 .41827 .36514 .45402 .35326 .53362 Mtetra
.238 .025 .374 r
.35326 .53362 .36514 .45402 .37873 .41698 .36746 .49269 Mtetra
.11 0 .323 r
.36746 .49269 .37873 .41698 .39247 .37155 .38187 .44193 Mtetra
.773 .49 .505 r
.38187 .44193 .39247 .37155 .40092 .45967 .39039 .53094 Mtetra
0 0 .012 r
.39039 .53094 .40092 .45967 .41606 .37287 .40634 .43631 Mtetra
.647 .366 .479 r
.40634 .43631 .41606 .37287 .42718 .40021 .41774 .46203 Mtetra
.693 .407 .484 r
.41774 .46203 .42718 .40021 .43827 .4399 .42902 .50173 Mtetra
.123 0 .316 r
.42902 .50173 .43827 .4399 .45155 .3999 .44274 .45968 Mtetra
.608 .327 .464 r
.44274 .45968 .45155 .3999 .4636 .41343 .45501 .47514 Mtetra
.641 .356 .472 r
.45501 .47514 .4636 .41343 .47575 .43352 .46734 .49897 Mtetra
.546 .275 .455 r
.46734 .49897 .47575 .43352 .48837 .43326 .48022 .50255 Mtetra
0 0 .279 r
.48022 .50255 .48837 .43326 .50153 .37215 .49383 .4426 Mtetra
.777 .485 .492 r
.49383 .4426 .50153 .37215 .51381 .45432 .50622 .53328 Mtetra
0 0 .206 r
.50622 .53328 .51381 .45432 .52674 .36811 .51971 .4455 Mtetra
.578 .309 .472 r
.51971 .4455 .52674 .36811 .5395 .37711 .53284 .4569 Mtetra
.518 .259 .462 r
.53284 .4569 .5395 .37711 .55234 .37463 .54607 .45457 Mtetra
.441 .196 .446 r
.54607 .45457 .55234 .37463 .56509 .3597 .55922 .4375 Mtetra
.311 .092 .412 r
.55922 .4375 .56509 .3597 .57754 .32813 .57205 .40157 Mtetra
.585 .312 .469 r
.57205 .40157 .57754 .32813 .59081 .34368 .5856 .41451 Mtetra
.593 .317 .467 r
.5856 .41451 .59081 .34368 .60435 .36116 .5994 .42917 Mtetra
0 0 .27 r
.5994 .42917 .60435 .36116 .61576 .29719 .61112 .3588 Mtetra
.779 .474 .471 r
.61112 .3588 .61576 .29719 .6315 .37611 .62707 .43915 Mtetra
.252 .037 .382 r
.62707 .43915 .6315 .37611 .64376 .34225 .63966 .40281 Mtetra
.506 .236 .44 r
.63966 .40281 .64376 .34225 .6571 .33854 .65336 .39966 Mtetra
.676 .378 .462 r
.65336 .39966 .6571 .33854 .67212 .36963 .66882 .43453 Mtetra
.435 .183 .431 r
.66882 .43453 .67212 .36963 .68504 .35184 .68226 .41944 Mtetra
.561 .286 .456 r
.68226 .41944 .68504 .35184 .69904 .3546 .69686 .42662 Mtetra
.418 .176 .437 r
.69686 .42662 .69904 .3546 .71164 .33159 .71008 .40669 Mtetra
.609 .329 .467 r
.71008 .40669 .71164 .33159 .72662 .34737 .72573 .42709 Mtetra
.411 .175 .444 r
.72573 .42709 .72662 .34737 .73907 .3224 .73873 .40319 Mtetra
.321 .109 .428 r
.73873 .40319 .73907 .3224 .75044 .28412 .75052 .36362 Mtetra
.638 .353 .47 r
.75052 .36362 .75044 .28412 .76683 .314 .76738 .39459 Mtetra
.377 .152 .44 r
.76738 .39459 .76683 .314 .77895 .28695 .7797 .36378 Mtetra
.351 .131 .433 r
.7797 .36378 .77895 .28695 .79077 .25798 .7916 .32996 Mtetra
.622 .335 .461 r
.7916 .32996 .79077 .25798 .80745 .28417 .80845 .35384 Mtetra
.435 .189 .441 r
.80845 .35384 .80745 .28417 .82072 .27099 .82176 .33639 Mtetra
.565 .285 .45 r
.82176 .33639 .82072 .27099 .83638 .28165 .83757 .34478 Mtetra
.482 .321 .585 r
.20006 .45953 .20216 .52598 .21216 .53867 .21024 .4682 Mtetra
.605 .414 .597 r
.21024 .4682 .21216 .53867 .22414 .53106 .22238 .45693 Mtetra
.514 .34 .583 r
.22238 .45693 .22414 .53106 .23472 .54013 .23308 .46194 Mtetra
.565 .378 .587 r
.23308 .46194 .23472 .54013 .24627 .53905 .24465 .45802 Mtetra
.598 .403 .588 r
.24465 .45802 .24627 .53905 .25861 .5288 .25689 .44658 Mtetra
.348 .208 .545 r
.25689 .44658 .25861 .5288 .26793 .55858 .266 .47495 Mtetra
.537 .354 .581 r
.266 .47495 .26793 .55858 .2797 .55848 .27742 .47622 Mtetra
.609 .411 .589 r
.27742 .47622 .2797 .55848 .29277 .54067 .29005 .46173 Mtetra
.464 .301 .574 r
.29005 .46173 .29277 .54067 .30397 .55081 .30079 .47484 Mtetra
.519 .345 .585 r
.30079 .47484 .30397 .55081 .31589 .55168 .31226 .47925 Mtetra
.613 .419 .596 r
.31226 .47925 .31589 .55168 .32896 .53446 .32494 .46576 Mtetra
.695 .484 .598 r
.32494 .46576 .32896 .53446 .34314 .49623 .33882 .43091 Mtetra
.187 .106 .526 r
.33882 .43091 .34314 .49623 .35326 .53362 .34869 .46779 Mtetra
.716 .501 .598 r
.34869 .46779 .35326 .53362 .36746 .49269 .36277 .42735 Mtetra
.744 .522 .594 r
.36277 .42735 .36746 .49269 .38187 .44193 .37714 .37604 Mtetra
0 0 .221 r
.37714 .37604 .38187 .44193 .39039 .53094 .38553 .45855 Mtetra
.804 .566 .577 r
.38553 .45855 .39039 .53094 .40634 .43631 .4015 .36346 Mtetra
.402 .26 .571 r
.4015 .36346 .40634 .43631 .41774 .46203 .41279 .38429 Mtetra
.298 .18 .546 r
.41279 .38429 .41774 .46203 .42902 .50173 .42389 .419 Mtetra
.695 .476 .586 r
.42389 .419 .42902 .50173 .44274 .45968 .43746 .37655 Mtetra
.468 .304 .575 r
.43746 .37655 .44274 .45968 .45501 .47514 .44946 .39057 Mtetra
.41 .26 .565 r
.44946 .39057 .45501 .47514 .46734 .49897 .46148 .41412 Mtetra
.516 .34 .581 r
.46148 .41412 .46734 .49897 .48022 .50255 .47405 .41973 Mtetra
.723 .496 .582 r
.47405 .41973 .48022 .50255 .49383 .4426 .48746 .3654 Mtetra
0 0 .33 r
.48746 .3654 .49383 .4426 .50622 .53328 .4994 .4561 Mtetra
.781 .542 .574 r
.4994 .4561 .50622 .53328 .51971 .4455 .51282 .37504 Mtetra
.46 .308 .587 r
.51282 .37504 .51971 .4455 .53284 .4569 .5257 .38859 Mtetra
.551 .376 .598 r
.5257 .38859 .53284 .4569 .54607 .45457 .53872 .38764 Mtetra
.63 .435 .599 r
.53872 .38764 .54607 .45457 .55922 .4375 .5517 .3709 Mtetra
.703 .487 .593 r
.5517 .3709 .55922 .4375 .57205 .40157 .5644 .33444 Mtetra
.486 .33 .595 r
.5644 .33444 .57205 .40157 .5856 .41451 .57766 .34389 Mtetra
.485 .327 .591 r
.57766 .34389 .5856 .41451 .5994 .42917 .59111 .35411 Mtetra
.771 .532 .572 r
.59111 .35411 .5994 .42917 .61112 .3588 .60269 .28249 Mtetra
0 0 .462 r
.60269 .28249 .61112 .3588 .62707 .43915 .61802 .35575 Mtetra
.68 .461 .582 r
.61802 .35575 .62707 .43915 .63966 .40281 .63035 .31825 Mtetra
.563 .375 .585 r
.63035 .31825 .63966 .40281 .65336 .39966 .64372 .31385 Mtetra
.365 .233 .565 r
.64372 .31385 .65336 .39966 .66882 .43453 .65875 .34728 Mtetra
.595 .398 .584 r
.65875 .34728 .66882 .43453 .68226 .41944 .67203 .33453 Mtetra
.499 .33 .583 r
.67203 .33453 .68226 .41944 .69686 .42662 .68645 .34425 Mtetra
.609 .41 .587 r
.68645 .34425 .69686 .42662 .71008 .40669 .69966 .3287 Mtetra
.418 .278 .582 r
.69966 .3287 .71008 .40669 .72573 .42709 .71516 .35189 Mtetra
.632 .43 .591 r
.71516 .35189 .72573 .42709 .73873 .40319 .72821 .33191 Mtetra
.694 .475 .587 r
.72821 .33191 .73873 .40319 .75052 .36362 .74005 .29561 Mtetra
.348 .238 .585 r
.74005 .29561 .75052 .36362 .76738 .39459 .75658 .32586 Mtetra
.68 .467 .591 r
.75658 .32586 .76738 .39459 .7797 .36378 .76871 .29491 Mtetra
.694 .476 .587 r
.76871 .29491 .7797 .36378 .7916 .32996 .78031 .25968 Mtetra
.434 .296 .593 r
.78031 .25968 .7916 .32996 .80845 .35384 .79648 .27897 Mtetra
.634 .431 .589 r
.79648 .27897 .80845 .35384 .82176 .33639 .80923 .25807 Mtetra
.526 .354 .591 r
.80923 .25807 .82176 .33639 .83757 .34478 .82432 .26208 Mtetra
.59 .261 .379 r
.18894 .48433 .20006 .45953 .21024 .4682 .19944 .49074 Mtetra
.032 0 .071 r
.19944 .49074 .21024 .4682 .22238 .45693 .21207 .47589 Mtetra
.513 .154 .294 r
.21207 .47589 .22238 .45693 .23308 .46194 .22319 .47727 Mtetra
.184 0 .055 r
.22319 .47727 .23308 .46194 .24465 .45802 .23517 .46984 Mtetra
0 0 0 r
.23517 .46984 .24465 .45802 .25689 .44658 .24776 .45563 Mtetra
.819 .464 .384 r
.24776 .45563 .25689 .44658 .266 .47495 .25695 .48299 Mtetra
.459 0 .054 r
.25695 .48299 .266 .47495 .27742 .47622 .26843 .48444 Mtetra
.587 .879 .572 r
.26843 .48444 .27742 .47622 .29005 .46173 .28106 .47147 Mtetra
.747 .36 .32 r
.28106 .47147 .29005 .46173 .30079 .47484 .29163 .4877 Mtetra
.636 .243 .283 r
.29163 .4877 .30079 .47484 .31226 .47925 .30292 .49595 Mtetra
.13 0 .052 r
.30292 .49595 .31226 .47925 .32494 .46576 .3155 .48619 Mtetra
.709 .803 .334 r
.3155 .48619 .32494 .46576 .33882 .43091 .32943 .45411 Mtetra
.795 .473 .444 r
.32943 .45411 .33882 .43091 .34869 .46779 .33916 .49426 Mtetra
.68 .747 .248 r
.33916 .49426 .34869 .46779 .36277 .42735 .35348 .45395 Mtetra
.872 .831 .36 r
.35348 .45395 .36277 .42735 .37714 .37604 .36821 .40095 Mtetra
.862 .555 .466 r
.36821 .40095 .37714 .37604 .38553 .45855 .37655 .4833 Mtetra
.999 .811 .472 r
.37655 .4833 .38553 .45855 .4015 .36346 .3931 .38314 Mtetra
.704 .353 .379 r
.3931 .38314 .4015 .36346 .41279 .38429 .40459 .40069 Mtetra
.796 .448 .396 r
.40459 .40069 .41279 .38429 .42389 .419 .41584 .43225 Mtetra
.979 .882 .518 r
.41584 .43225 .42389 .419 .43746 .37655 .42972 .38615 Mtetra
.699 .281 .25 r
.42972 .38615 .43746 .37655 .44946 .39057 .44182 .39843 Mtetra
.806 .408 .299 r
.44182 .39843 .44946 .39057 .46148 .41412 .45387 .42181 Mtetra
.606 .144 .129 r
.45387 .42181 .46148 .41412 .47405 .41973 .4665 .42862 Mtetra
.998 .851 .54 r
.4665 .42862 .47405 .41973 .48746 .3654 .4801 .3761 Mtetra
.918 .594 .412 r
.4801 .3761 .48746 .3654 .4994 .4561 .4919 .47174 Mtetra
.997 .819 .467 r
.4919 .47174 .4994 .4561 .51282 .37504 .5056 .39332 Mtetra
.706 .338 .349 r
.5056 .39332 .51282 .37504 .5257 .38859 .51858 .4109 Mtetra
.521 .169 .311 r
.51858 .4109 .5257 .38859 .53872 .38764 .53177 .41292 Mtetra
.184 0 .209 r
.53177 .41292 .53872 .38764 .5517 .3709 .54496 .39746 Mtetra
0 0 0 r
.54496 .39746 .5517 .3709 .5644 .33444 .5579 .36023 Mtetra
.596 .254 .36 r
.5579 .36023 .5644 .33444 .57766 .34389 .5713 .36845 Mtetra
.591 .244 .349 r
.5713 .36845 .57766 .34389 .59111 .35411 .58485 .37611 Mtetra
.944 .801 .346 r
.58485 .37611 .59111 .35411 .60269 .28249 .59663 .29954 Mtetra
.885 .539 .386 r
.59663 .29954 .60269 .28249 .61802 .35575 .61188 .37026 Mtetra
.852 .831 .358 r
.61188 .37026 .61802 .35575 .63035 .31825 .6243 .32875 Mtetra
.147 0 0 r
.6243 .32875 .63035 .31825 .64372 .31385 .6377 .32185 Mtetra
.845 .437 .268 r
.6377 .32185 .64372 .31385 .65875 .34728 .65275 .35461 Mtetra
0 0 0 r
.65275 .35461 .65875 .34728 .67203 .33453 .66617 .34223 Mtetra
.679 .211 .134 r
.66617 .34223 .67203 .33453 .68645 .34425 .68079 .35413 Mtetra
0 0 0 r
.68079 .35413 .68645 .34425 .69966 .3287 .69432 .34162 Mtetra
.792 .387 .285 r
.69432 .34162 .69966 .3287 .71516 .35189 .71017 .36918 Mtetra
.03 0 .077 r
.71017 .36918 .71516 .35189 .72821 .33191 .72364 .35288 Mtetra
0 0 0 r
.72364 .35288 .72821 .33191 .74005 .29561 .7359 .3192 Mtetra
.767 .399 .359 r
.7359 .3192 .74005 .29561 .75658 .32586 .75278 .35243 Mtetra
0 0 .159 r
.75278 .35243 .75658 .32586 .76871 .29491 .76517 .32148 Mtetra
0 0 .121 r
.76517 .32148 .76871 .29491 .78031 .25968 .77691 .28453 Mtetra
.67 .305 .346 r
.77691 .28453 .78031 .25968 .79648 .27897 .79308 .30195 Mtetra
0 0 .163 r
.79308 .30195 .79648 .27897 .80923 .25807 .80572 .27722 Mtetra
.481 .108 .255 r
.80572 .27722 .80923 .25807 .82432 .26208 .82063 .27743 Mtetra
.593 .158 .184 r
.17926 .493 .18894 .48433 .19944 .49074 .18992 .4983 Mtetra
.864 .986 .708 r
.18992 .4983 .19944 .49074 .21207 .47589 .20291 .48078 Mtetra
.133 0 0 r
.20291 .48078 .21207 .47589 .22319 .47727 .21441 .47873 Mtetra
.839 .982 .872 r
.21441 .47873 .22319 .47727 .23517 .46984 .22682 .46744 Mtetra
.902 .85 .783 r
.22682 .46744 .23517 .46984 .24776 .45563 .23978 .44966 Mtetra
.899 .483 .173 r
.23978 .44966 .24776 .45563 .25695 .48299 .24915 .47437 Mtetra
.49 .653 .932 r
.24915 .47437 .25695 .48299 .26843 .48444 .26075 .47439 Mtetra
.797 .72 .78 r
.26075 .47439 .26843 .48444 .28106 .47147 .27342 .46152 Mtetra
.739 .285 0 r
.27342 .46152 .28106 .47147 .29163 .4877 .28384 .4794 Mtetra
0 .011 .523 r
.28384 .4794 .29163 .4877 .30292 .49595 .29493 .4906 Mtetra
.72 .826 .931 r
.29493 .4906 .30292 .49595 .3155 .48619 .30732 .48453 Mtetra
.943 .83 .702 r
.30732 .48453 .3155 .48619 .32943 .45411 .32114 .45612 Mtetra
.901 .549 .365 r
.32114 .45612 .32943 .45411 .33916 .49426 .3306 .50009 Mtetra
.987 .873 .631 r
.3306 .50009 .33916 .49426 .35348 .45395 .34499 .46178 Mtetra
.993 .837 .582 r
.34499 .46178 .35348 .45395 .36821 .40095 .3599 .40915 Mtetra
.911 .595 .432 r
.3599 .40915 .36821 .40095 .37655 .4833 .36811 .49187 Mtetra
.984 .767 .53 r
.36811 .49187 .37655 .4833 .3931 .38314 .38513 .38853 Mtetra
.752 .313 .208 r
.38513 .38853 .3931 .38314 .40459 .40069 .39677 .4031 Mtetra
.863 .461 .272 r
.39677 .4031 .40459 .40069 .41584 .43225 .40813 .43107 Mtetra
.969 .79 .607 r
.40813 .43107 .41584 .43225 .42972 .38615 .4223 .38097 Mtetra
.452 0 0 r
.4223 .38097 .42972 .38615 .44182 .39843 .4345 .39017 Mtetra
.782 .321 0 r
.4345 .39017 .44182 .39843 .45387 .42181 .44657 .41156 Mtetra
.148 .424 .865 r
.44657 .41156 .45387 .42181 .4665 .42862 .45921 .41785 Mtetra
.929 .728 .611 r
.45921 .41785 .4665 .42862 .4801 .3761 .47293 .36637 Mtetra
.963 .636 .333 r
.47293 .36637 .4801 .3761 .4919 .47174 .4845 .46466 Mtetra
.959 .739 .562 r
.4845 .46466 .4919 .47174 .5056 .39332 .49839 .38951 Mtetra
.824 .347 0 r
.49839 .38951 .5056 .39332 .51858 .4109 .51136 .41114 Mtetra
.469 0 0 r
.51136 .41114 .51858 .4109 .53177 .41292 .52461 .41694 Mtetra
.689 .958 .71 r
.52461 .41694 .53177 .41292 .54496 .39746 .53793 .40426 Mtetra
.977 .904 .566 r
.53793 .40426 .54496 .39746 .5579 .36023 .55106 .3682 Mtetra
.627 .162 .13 r
.55106 .3682 .5579 .36023 .5713 .36845 .56453 .37655 Mtetra
.578 .107 .098 r
.56453 .37655 .5713 .36845 .58485 .37611 .57815 .38276 Mtetra
.999 .793 .483 r
.57815 .38276 .58485 .37611 .59663 .29954 .59011 .30258 Mtetra
.928 .565 .311 r
.59011 .30258 .59663 .29954 .61188 .37026 .60522 .37021 Mtetra
.993 .831 .578 r
.60522 .37021 .61188 .37026 .6243 .32875 .61767 .32452 Mtetra
.818 .905 .901 r
.61767 .32452 .6243 .32875 .6377 .32185 .63102 .31411 Mtetra
.811 .37 0 r
.63102 .31411 .6377 .32185 .65275 .35461 .64595 .34436 Mtetra
.814 .757 .799 r
.64595 .34436 .65275 .35461 .66617 .34223 .65938 .33083 Mtetra
0 .234 .753 r
.65938 .33083 .66617 .34223 .68079 .35413 .67402 .34317 Mtetra
.769 .735 .822 r
.67402 .34317 .68079 .35413 .69432 .34162 .6877 .33264 Mtetra
.759 .324 0 r
.6877 .33264 .69432 .34162 .71017 .36918 .70373 .36351 Mtetra
.842 .879 .868 r
.70373 .36351 .71017 .36918 .72364 .35288 .71752 .35109 Mtetra
.982 .888 .655 r
.71752 .35109 .72364 .35288 .7359 .3192 .73017 .32114 Mtetra
.873 .436 .141 r
.73017 .32114 .7359 .3192 .75278 .35243 .74733 .35808 Mtetra
.893 .913 .512 r
.74733 .35808 .75278 .35243 .76517 .32148 .76004 .32899 Mtetra
.903 .87 .432 r
.76004 .32899 .76517 .32148 .77691 .28453 .77198 .29226 Mtetra
.727 .256 .129 r
.77198 .29226 .77691 .28453 .79308 .30195 .78818 .30894 Mtetra
.798 .87 .433 r
.78818 .30894 .79308 .30195 .80572 .27722 .80075 .2815 Mtetra
.082 0 0 r
.80075 .2815 .80572 .27722 .82063 .27743 .81544 .27825 Mtetra
.595 .206 .277 r
.16887 .50682 .17926 .493 .18992 .4983 .17955 .51258 Mtetra
.614 .83 .437 r
.17955 .51258 .18992 .4983 .20291 .48078 .19283 .49363 Mtetra
.25 0 .032 r
.19283 .49363 .20291 .48078 .21441 .47873 .20467 .48901 Mtetra
.61 .872 .533 r
.20467 .48901 .21441 .47873 .22682 .46744 .21751 .47413 Mtetra
.939 .965 .712 r
.21751 .47413 .22682 .46744 .23978 .44966 .23095 .45237 Mtetra
.834 .433 .288 r
.23095 .45237 .23978 .44966 .24915 .47437 .2406 .47371 Mtetra
.389 .838 .927 r
.2406 .47371 .24915 .47437 .26075 .47439 .25247 .471 Mtetra
.873 .856 .823 r
.25247 .471 .26075 .47439 .27342 .46152 .26532 .45667 Mtetra
.837 .367 .034 r
.26532 .45667 .27342 .46152 .28384 .4794 .2757 .47474 Mtetra
.727 .202 0 r
.2757 .47474 .28384 .4794 .29493 .4906 .28667 .48767 Mtetra
.542 .86 .997 r
.28667 .48767 .29493 .4906 .30732 .48453 .29891 .48454 Mtetra
.949 .871 .727 r
.29891 .48454 .30732 .48453 .32114 .45612 .31263 .45967 Mtetra
.899 .555 .384 r
.31263 .45967 .32114 .45612 .3306 .50009 .32177 .50806 Mtetra
.984 .905 .626 r
.32177 .50806 .3306 .50009 .34499 .46178 .33616 .47282 Mtetra
.996 .861 .567 r
.33616 .47282 .34499 .46178 .3599 .40915 .35121 .42188 Mtetra
.899 .585 .443 r
.35121 .42188 .3599 .40915 .36811 .49187 .3592 .50689 Mtetra
.994 .784 .514 r
.3592 .50689 .36811 .49187 .38513 .38853 .37669 .40138 Mtetra
.688 .296 .297 r
.37669 .40138 .38513 .38853 .39677 .4031 .38847 .41411 Mtetra
.796 .418 .342 r
.38847 .41411 .39677 .4031 .40813 .43107 .39997 .43923 Mtetra
.997 .84 .562 r
.39997 .43923 .40813 .43107 .4223 .38097 .4145 .38478 Mtetra
.554 .025 0 r
.4145 .38478 .4223 .38097 .4345 .39017 .42686 .39029 Mtetra
.811 .342 .104 r
.42686 .39029 .4345 .39017 .44657 .41156 .43902 .40865 Mtetra
0 .381 .702 r
.43902 .40865 .44657 .41156 .45921 .41785 .45173 .41295 Mtetra
.958 .767 .603 r
.45173 .41295 .45921 .41785 .47293 .36637 .46563 .36079 Mtetra
.957 .63 .355 r
.46563 .36079 .47293 .36637 .4845 .46466 .47699 .46056 Mtetra
.969 .754 .56 r
.47699 .46056 .4845 .46466 .49839 .38951 .49107 .38758 Mtetra
.858 .408 .109 r
.49107 .38758 .49839 .38951 .51136 .41114 .50403 .41291 Mtetra
.652 .115 0 r
.50403 .41291 .51136 .41114 .52461 .41694 .51733 .42281 Mtetra
0 0 0 r
.51733 .42281 .52461 .41694 .53793 .40426 .53077 .41383 Mtetra
.928 .91 .519 r
.53077 .41383 .53793 .40426 .55106 .3682 .5441 .38024 Mtetra
.646 .224 .228 r
.5441 .38024 .55106 .3682 .56453 .37655 .5577 .39036 Mtetra
.582 .168 .223 r
.5577 .39036 .56453 .37655 .57815 .38276 .57143 .39671 Mtetra
.994 .806 .436 r
.57143 .39671 .57815 .38276 .59011 .30258 .58364 .3138 Mtetra
.899 .542 .355 r
.58364 .3138 .59011 .30258 .60522 .37021 .59868 .37951 Mtetra
.981 .859 .479 r
.59868 .37951 .60522 .37021 .61767 .32452 .61122 .32956 Mtetra
.653 .915 .611 r
.61122 .32956 .61767 .32452 .63102 .31411 .62457 .31515 Mtetra
.846 .391 .117 r
.62457 .31515 .63102 .31411 .64595 .34436 .63939 .34209 Mtetra
.907 .944 .818 r
.63939 .34209 .64595 .34436 .65938 .33083 .65281 .32592 Mtetra
.441 0 0 r
.65281 .32592 .65938 .33083 .67402 .34317 .66743 .33718 Mtetra
.8 .864 .896 r
.66743 .33718 .67402 .34317 .6877 .33264 .68121 .32708 Mtetra
.838 .391 0 r
.68121 .32708 .6877 .33264 .70373 .36351 .69734 .36013 Mtetra
.77 .941 .937 r
.69734 .36013 .70373 .36351 .71752 .35109 .71142 .35094 Mtetra
.971 .929 .673 r
.71142 .35094 .71752 .35109 .73017 .32114 .72444 .32471 Mtetra
.882 .458 .183 r
.72444 .32471 .73017 .32114 .74733 .35808 .74195 .36612 Mtetra
.752 .859 .425 r
.74195 .36612 .74733 .35808 .76004 .32899 .75505 .34012 Mtetra
.771 .806 .323 r
.75505 .34012 .76004 .32899 .77198 .29226 .76733 .30507 Mtetra
.714 .283 .224 r
.76733 .30507 .77198 .29226 .78818 .30894 .78374 .32273 Mtetra
0 0 0 r
.78374 .32273 .78818 .30894 .80075 .2815 .79639 .29391 Mtetra
.266 0 .058 r
.79639 .29391 .80075 .2815 .81544 .27825 .811 .28818 Mtetra
.469 .325 .603 r
.16548 .45506 .16887 .50682 .17955 .51258 .17586 .46231 Mtetra
.664 .475 .619 r
.17586 .46231 .17955 .51258 .19283 .49363 .18899 .44396 Mtetra
.589 .419 .619 r
.18899 .44396 .19283 .49363 .20467 .48901 .20084 .43809 Mtetra
.657 .468 .617 r
.20084 .43809 .20467 .48901 .21751 .47413 .21381 .4209 Mtetra
.687 .488 .612 r
.21381 .4209 .21751 .47413 .23095 .45237 .22744 .39616 Mtetra
.368 .244 .578 r
.22744 .39616 .23095 .45237 .2406 .47371 .23728 .41296 Mtetra
.582 .401 .602 r
.23728 .41296 .2406 .47371 .25247 .471 .24929 .40664 Mtetra
.633 .438 .6 r
.24929 .40664 .25247 .471 .26532 .45667 .26219 .38993 Mtetra
.412 .267 .573 r
.26219 .38993 .26532 .45667 .2757 .47474 .27251 .40578 Mtetra
.448 .293 .577 r
.27251 .40578 .2757 .47474 .28667 .48767 .28328 .41815 Mtetra
.549 .37 .591 r
.28328 .41815 .28667 .48767 .29891 .48454 .29522 .41654 Mtetra
.648 .447 .597 r
.29522 .41654 .29891 .48454 .31263 .45967 .30857 .39514 Mtetra
0 0 .433 r
.30857 .39514 .31263 .45967 .32177 .50806 .31728 .44544 Mtetra
.691 .483 .601 r
.31728 .44544 .32177 .50806 .33616 .47282 .33129 .4149 Mtetra
.747 .529 .598 r
.33129 .4149 .33616 .47282 .35121 .42188 .34605 .36848 Mtetra
.742 .546 0 r
.34605 .36848 .35121 .42188 .3592 .50689 .35368 .45347 Mtetra
.846 .605 .574 r
.35368 .45347 .3592 .50689 .37669 .40138 .37112 .35134 Mtetra
.424 .299 .606 r
.37112 .35134 .37669 .40138 .38847 .41411 .38278 .36297 Mtetra
.29 .202 .58 r
.38278 .36297 .38847 .41411 .39997 .43923 .3942 .38519 Mtetra
.78 .554 .593 r
.3942 .38519 .39997 .43923 .4145 .38478 .40877 .32887 Mtetra
.529 .368 .607 r
.40877 .32887 .4145 .38478 .42686 .39029 .42109 .33032 Mtetra
.426 .289 .59 r
.42109 .33032 .42686 .39029 .43902 .40865 .43316 .34419 Mtetra
.534 .364 .597 r
.43316 .34419 .43902 .40865 .45173 .41295 .44575 .34502 Mtetra
.744 .517 .586 r
.44575 .34502 .45173 .41295 .46563 .36079 .45957 .29254 Mtetra
0 0 .209 r
.45957 .29254 .46563 .36079 .47699 .46056 .47055 .38794 Mtetra
.771 .535 .577 r
.47055 .38794 .47699 .46056 .49107 .38758 .48453 .31846 Mtetra
.338 .218 .566 r
.48453 .31846 .49107 .38758 .50403 .41291 .49719 .34509 Mtetra
.452 .303 .587 r
.49719 .34509 .50403 .41291 .51733 .42281 .51024 .35789 Mtetra
.569 .391 .6 r
.51024 .35789 .51733 .42281 .53077 .41383 .5235 .35287 Mtetra
.688 .479 .599 r
.5235 .35287 .53077 .41383 .5441 .38024 .53673 .32372 Mtetra
.439 .306 .602 r
.53673 .32372 .5441 .38024 .5577 .39036 .55015 .33619 Mtetra
.48 .339 .611 r
.55015 .33619 .5577 .39036 .57143 .39671 .56372 .34373 Mtetra
.834 .589 .567 r
.56372 .34373 .57143 .39671 .58364 .3138 .576 .26273 Mtetra
0 0 .394 r
.576 .26273 .58364 .3138 .59868 .37951 .59067 .32501 Mtetra
.773 .544 .587 r
.59067 .32501 .59868 .37951 .61122 .32956 .60311 .27339 Mtetra
.646 .453 .607 r
.60311 .27339 .61122 .32956 .62457 .31515 .61621 .2556 Mtetra
.363 .251 .59 r
.61621 .2556 .62457 .31515 .63939 .34209 .63062 .27761 Mtetra
.64 .441 .597 r
.63062 .27761 .63939 .34209 .65281 .32592 .64374 .25832 Mtetra
.489 .332 .594 r
.64374 .25832 .65281 .32592 .66743 .33718 .65798 .26644 Mtetra
.595 .404 .593 r
.65798 .26644 .66743 .33718 .68121 .32708 .67149 .25535 Mtetra
.325 .214 .571 r
.67149 .25535 .68121 .32708 .69734 .36013 .68726 .28734 Mtetra
.575 .389 .592 r
.68726 .28734 .69734 .36013 .71142 .35094 .70121 .28022 Mtetra
.644 .439 .59 r
.70121 .28022 .71142 .35094 .72444 .32471 .71428 .25783 Mtetra
.212 .142 .557 r
.71428 .25783 .72444 .32471 .74195 .36612 .73162 .30145 Mtetra
.649 .447 .597 r
.73162 .30145 .74195 .36612 .75505 .34012 .74488 .27997 Mtetra
.695 .482 .595 r
.74488 .27997 .75505 .34012 .76733 .30507 .75734 .24901 Mtetra
.392 .281 .607 r
.75734 .24901 .76733 .30507 .78374 .32273 .77365 .26809 Mtetra
.694 .486 .602 r
.77365 .26809 .78374 .32273 .79639 .29391 .78628 .24046 Mtetra
.586 .416 .617 r
.78628 .24046 .79639 .29391 .811 .28818 .80064 .2337 Mtetra
.599 .301 .435 r
.15158 .49826 .16548 .45506 .17586 .46231 .16175 .50898 Mtetra
.29 .018 .316 r
.16175 .50898 .17586 .46231 .18899 .44396 .17499 .49201 Mtetra
.454 .168 .389 r
.17499 .49201 .18899 .44396 .20084 .43809 .18703 .48644 Mtetra
.274 .007 .315 r
.18703 .48644 .20084 .43809 .21381 .4209 .20043 .46756 Mtetra
.082 0 .225 r
.20043 .46756 .21381 .4209 .22744 .39616 .21464 .43956 Mtetra
.619 .32 .441 r
.21464 .43956 .22744 .39616 .23728 .41296 .22489 .45357 Mtetra
.373 .083 .337 r
.22489 .45357 .23728 .41296 .24929 .40664 .23745 .44334 Mtetra
.13 0 .215 r
.23745 .44334 .24929 .40664 .26219 .38993 .2509 .42272 Mtetra
.635 .318 .417 r
.2509 .42272 .26219 .38993 .27251 .40578 .26152 .4364 Mtetra
.621 .298 .402 r
.26152 .4364 .27251 .40578 .28328 .41815 .27249 .44778 Mtetra
.474 .149 .335 r
.27249 .44778 .28328 .41815 .29522 .41654 .28458 .44638 Mtetra
.037 0 .136 r
.28458 .44638 .29522 .41654 .30857 .39514 .29805 .42622 Mtetra
.803 .492 .464 r
.29805 .42622 .30857 .39514 .31728 .44544 .3065 .48101 Mtetra
0 0 .132 r
.3065 .48101 .31728 .44544 .33129 .4149 .32059 .45352 Mtetra
0 0 0 r
.32059 .45352 .33129 .4149 .34605 .36848 .33551 .40968 Mtetra
.833 .532 .481 r
.33551 .40968 .34605 .36848 .35368 .45347 .34278 .50128 Mtetra
.922 .801 .331 r
.34278 .50128 .35368 .45347 .37112 .35134 .36076 .39804 Mtetra
.605 .305 .434 r
.36076 .39804 .37112 .35134 .38278 .36297 .37256 .41124 Mtetra
.653 .351 .448 r
.37256 .41124 .38278 .36297 .3942 .38519 .38414 .43385 Mtetra
0 0 0 r
.38414 .43385 .3942 .38519 .40877 .32887 .39926 .37351 Mtetra
.493 .199 .395 r
.39926 .37351 .40877 .32887 .42109 .33032 .41191 .37197 Mtetra
.594 .286 .417 r
.41191 .37197 .42109 .33032 .43316 .34419 .42427 .3826 Mtetra
.472 .169 .369 r
.42427 .3826 .43316 .34419 .44575 .34502 .43718 .37976 Mtetra
0 0 0 r
.43718 .37976 .44575 .34502 .45957 .29254 .45142 .32281 Mtetra
.868 .552 .449 r
.45142 .32281 .45957 .29254 .47055 .38794 .46235 .41888 Mtetra
.878 .794 .303 r
.46235 .41888 .47055 .38794 .48453 .31846 .47671 .3472 Mtetra
.729 .391 .407 r
.47671 .3472 .48453 .31846 .49719 .34509 .48948 .37575 Mtetra
.648 .312 .39 r
.48948 .37575 .49719 .34509 .51024 .35789 .50267 .39159 Mtetra
.481 .164 .352 r
.50267 .39159 .51024 .35789 .5235 .35287 .51614 .39017 Mtetra
.112 0 .241 r
.51614 .39017 .5235 .35287 .53673 .32372 .52966 .36425 Mtetra
.632 .314 .414 r
.52966 .36425 .53673 .32372 .55015 .33619 .54332 .38111 Mtetra
.588 .28 .414 r
.54332 .38111 .55015 .33619 .56372 .34373 .55717 .39209 Mtetra
0 0 0 r
.55717 .39209 .56372 .34373 .576 .26273 .56989 .30978 Mtetra
.784 .463 .445 r
.56989 .30978 .576 .26273 .59067 .32501 .58475 .37466 Mtetra
0 0 .184 r
.58475 .37466 .59067 .32501 .60311 .27339 .59751 .31965 Mtetra
.292 .036 .344 r
.59751 .31965 .60311 .27339 .61621 .2556 .61084 .29851 Mtetra
.639 .32 .416 r
.61084 .29851 .61621 .2556 .63062 .27761 .62538 .31773 Mtetra
.214 0 .302 r
.62538 .31773 .63062 .27761 .64374 .25832 .63863 .294 Mtetra
.547 .226 .375 r
.63863 .294 .64374 .25832 .65798 .26644 .65296 .29897 Mtetra
.309 .019 .299 r
.65296 .29897 .65798 .26644 .67149 .25535 .6666 .28517 Mtetra
.736 .384 .382 r
.6666 .28517 .67149 .25535 .68726 .28734 .68251 .31702 Mtetra
.403 .085 .309 r
.68251 .31702 .68726 .28734 .70121 .28022 .69673 .31032 Mtetra
.166 0 .245 r
.69673 .31032 .70121 .28022 .71428 .25783 .71016 .28949 Mtetra
.79 .435 .386 r
.71016 .28949 .71428 .25783 .73162 .30145 .72795 .33785 Mtetra
.285 .013 .313 r
.72795 .33785 .73162 .30145 .74488 .27997 .74175 .31987 Mtetra
.178 0 .302 r
.74175 .31987 .74488 .27997 .75734 .24901 .75478 .29203 Mtetra
.656 .327 .404 r
.75478 .29203 .75734 .24901 .77365 .26809 .77169 .31543 Mtetra
.265 .025 .351 r
.77169 .31543 .77365 .26809 .78628 .24046 .7848 .28914 Mtetra
.461 .176 .394 r
.7848 .28914 .78628 .24046 .80064 .2337 .79957 .28297 Mtetra
.805 .337 .115 r
.14247 .49684 .15158 .49826 .16175 .50898 .15221 .51144 Mtetra
.88 .977 .836 r
.15221 .51144 .16175 .50898 .17499 .49201 .16523 .49743 Mtetra
0 0 0 r
.16523 .49743 .17499 .49201 .18703 .48644 .17715 .4937 Mtetra
.889 .986 .721 r
.17715 .4937 .18703 .48644 .20043 .46756 .19065 .47499 Mtetra
.974 .919 .677 r
.19065 .47499 .20043 .46756 .21464 .43956 .20516 .44548 Mtetra
.716 .28 .212 r
.20516 .44548 .21464 .43956 .22489 .45357 .21566 .45705 Mtetra
.857 .996 .816 r
.21566 .45705 .22489 .45357 .23745 .44334 .22864 .44322 Mtetra
.943 .862 .731 r
.22864 .44322 .23745 .44334 .2509 .42272 .24254 .41862 Mtetra
.644 .089 0 r
.24254 .41862 .2509 .42272 .26152 .4364 .25345 .42874 Mtetra
0 .157 .647 r
.25345 .42874 .26152 .4364 .27249 .44778 .26463 .43737 Mtetra
.613 .669 .88 r
.26463 .43737 .27249 .44778 .28458 .44638 .27684 .4345 Mtetra
.835 .71 .726 r
.27684 .4345 .28458 .44638 .29805 .42622 .29036 .41446 Mtetra
.957 .617 .302 r
.29036 .41446 .29805 .42622 .3065 .48101 .29857 .47092 Mtetra
.871 .737 .712 r
.29857 .47092 .3065 .48101 .32059 .45352 .31254 .44637 Mtetra
.925 .754 .65 r
.31254 .44637 .32059 .45352 .33551 .40968 .32739 .40613 Mtetra
.947 .632 .406 r
.32739 .40613 .33551 .40968 .34278 .50128 .33419 .50229 Mtetra
.969 .748 .549 r
.33419 .50229 .34278 .50128 .36076 .39804 .35236 .40173 Mtetra
.77 .317 .173 r
.35236 .40173 .36076 .39804 .37256 .41124 .36406 .41749 Mtetra
.817 .412 .283 r
.36406 .41749 .37256 .41124 .38414 .43385 .37561 .44136 Mtetra
.995 .822 .559 r
.37561 .44136 .38414 .43385 .39926 .37351 .39102 .37974 Mtetra
.086 0 0 r
.39102 .37974 .39926 .37351 .41191 .37197 .40384 .37608 Mtetra
.61 .096 .001 r
.40384 .37608 .41191 .37197 .42427 .3826 .41636 .38355 Mtetra
.569 .939 .879 r
.41636 .38355 .42427 .3826 .43718 .37976 .42945 .37681 Mtetra
.969 .769 .58 r
.42945 .37681 .43718 .37976 .45142 .32281 .44399 .31582 Mtetra
.958 .628 .342 r
.44399 .31582 .45142 .32281 .46235 .41888 .45478 .40884 Mtetra
.949 .728 .568 r
.45478 .40884 .46235 .41888 .47671 .3472 .46938 .3351 Mtetra
.772 .36 0 r
.46938 .3351 .47671 .3472 .48948 .37575 .48209 .36309 Mtetra
0 0 .557 r
.48209 .36309 .48948 .37575 .50267 .39159 .49525 .38 Mtetra
.463 .588 .892 r
.49525 .38 .50267 .39159 .51614 .39017 .50873 .38113 Mtetra
.889 .777 .732 r
.50873 .38113 .51614 .39017 .52966 .36425 .52234 .35871 Mtetra
.774 .284 0 r
.52234 .35871 .52966 .36425 .54332 .38111 .53602 .37968 Mtetra
.719 .187 0 r
.53602 .37968 .54332 .38111 .55717 .39209 .54994 .39462 Mtetra
.994 .782 .507 r
.54994 .39462 .55717 .39209 .56989 .30978 .56295 .31448 Mtetra
.921 .557 .316 r
.56295 .31448 .56989 .30978 .58475 .37466 .5778 .3817 Mtetra
.997 .843 .504 r
.5778 .3817 .58475 .37466 .59751 .31965 .59078 .32608 Mtetra
.845 .942 .576 r
.59078 .32608 .59751 .31965 .61084 .29851 .60421 .30315 Mtetra
.747 .264 .095 r
.60421 .30315 .61084 .29851 .62538 .31773 .61872 .31965 Mtetra
.97 .932 .651 r
.61872 .31965 .62538 .31773 .63863 .294 .63198 .29198 Mtetra
.074 .618 .842 r
.63198 .29198 .63863 .294 .65296 .29897 .64622 .29298 Mtetra
.898 .863 .797 r
.64622 .29298 .65296 .29897 .6666 .28517 .65978 .27557 Mtetra
.73 .297 0 r
.65978 .27557 .6666 .28517 .68251 .31702 .67554 .30483 Mtetra
.713 .702 .838 r
.67554 .30483 .68251 .31702 .69673 .31032 .68973 .29695 Mtetra
.85 .73 .731 r
.68973 .29695 .69673 .31032 .71016 .28949 .70325 .27657 Mtetra
.824 .441 0 r
.70325 .27657 .71016 .28949 .72795 .33785 .7211 .32696 Mtetra
.825 .768 .799 r
.7211 .32696 .72795 .33785 .74175 .31987 .7352 .31227 Mtetra
.931 .834 .727 r
.7352 .31227 .74175 .31987 .75478 .29203 .74861 .28831 Mtetra
.783 .3 0 r
.74861 .28831 .75478 .29203 .77169 .31543 .76587 .31593 Mtetra
.938 .964 .684 r
.76587 .31593 .77169 .31543 .7848 .28914 .77939 .29286 Mtetra
0 0 0 r
.77939 .29286 .7848 .28914 .79957 .28297 .79447 .28887 Mtetra
0 .055 .572 r
.1364 .46869 .14247 .49684 .15221 .51144 .14563 .48693 Mtetra
.68 .546 .696 r
.14563 .48693 .15221 .51144 .16523 .49743 .15822 .47673 Mtetra
.552 .495 .745 r
.15822 .47673 .16523 .49743 .17715 .4937 .1698 .47603 Mtetra
.771 .634 .71 r
.1698 .47603 .17715 .4937 .19065 .47499 .18314 .45918 Mtetra
.84 .673 .675 r
.18314 .45918 .19065 .47499 .20516 .44548 .19767 .43005 Mtetra
0 .214 .727 r
.19767 .43005 .20516 .44548 .21566 .45705 .20827 .4403 Mtetra
.775 .643 .717 r
.20827 .4403 .21566 .45705 .22864 .44322 .22151 .42387 Mtetra
.818 .646 .669 r
.22151 .42387 .22864 .44322 .24254 .41862 .23576 .39587 Mtetra
.382 .371 .723 r
.23576 .39587 .24254 .41862 .25345 .42874 .24694 .402 Mtetra
.442 .383 .696 r
.24694 .402 .25345 .42874 .26463 .43737 .25837 .40686 Mtetra
.612 .478 .675 r
.25837 .40686 .26463 .43737 .27684 .4345 .27074 .4012 Mtetra
.724 .544 .647 r
.27074 .4012 .27684 .4345 .29036 .41446 .28434 .37992 Mtetra
.796 .545 0 r
.28434 .37992 .29036 .41446 .29857 .47092 .29237 .43557 Mtetra
.724 .541 .642 r
.29237 .43557 .29857 .47092 .31254 .44637 .3062 .41295 Mtetra
.789 .587 .627 r
.3062 .41295 .31254 .44637 .32739 .40613 .32086 .37603 Mtetra
.972 .676 .285 r
.32086 .37603 .32739 .40613 .33419 .50229 .3272 .47486 Mtetra
.898 .663 .574 r
.3272 .47486 .33419 .50229 .35236 .40173 .3453 .37904 Mtetra
0 .045 .593 r
.3453 .37904 .35236 .40173 .36406 .41749 .35676 .39806 Mtetra
0 0 .354 r
.35676 .39806 .36406 .41749 .37561 .44136 .36813 .42419 Mtetra
.905 .691 .602 r
.36813 .42419 .37561 .44136 .39102 .37974 .38363 .36369 Mtetra
.632 .591 .79 r
.38363 .36369 .39102 .37974 .40384 .37608 .39648 .35935 Mtetra
.358 .43 .799 r
.39648 .35935 .40384 .37608 .41636 .38355 .40905 .36461 Mtetra
.704 .6 .738 r
.40905 .36461 .41636 .38355 .42945 .37681 .42225 .35457 Mtetra
.895 .671 .591 r
.42225 .35457 .42945 .37681 .44399 .31582 .437 .2902 Mtetra
.949 .637 .204 r
.437 .2902 .44399 .31582 .45478 .40884 .44765 .37833 Mtetra
.883 .648 .577 r
.44765 .37833 .45478 .40884 .46938 .3351 .46241 .30223 Mtetra
.016 .067 .572 r
.46241 .30223 .46938 .3351 .48209 .36309 .47502 .32772 Mtetra
.283 .243 .636 r
.47502 .32772 .48209 .36309 .49525 .38 .48806 .34375 Mtetra
.513 .398 .66 r
.48806 .34375 .49525 .38 .50873 .38113 .50145 .34584 Mtetra
.709 .53 .645 r
.50145 .34584 .50873 .38113 .52234 .35871 .51503 .32615 Mtetra
.069 .111 .597 r
.51503 .32615 .52234 .35871 .53602 .37968 .52859 .35031 Mtetra
.157 .19 .645 r
.52859 .35031 .53602 .37968 .54994 .39462 .54244 .36906 Mtetra
.908 .67 .566 r
.54244 .36906 .54994 .39462 .56295 .31448 .55564 .2932 Mtetra
.889 .556 .062 r
.55564 .2932 .56295 .31448 .5778 .3817 .57035 .36291 Mtetra
.911 .694 .597 r
.57035 .36291 .5778 .3817 .59078 .32608 .58348 .30905 Mtetra
.83 .68 .697 r
.58348 .30905 .59078 .32608 .60421 .30315 .59696 .28613 Mtetra
.007 .202 .714 r
.59696 .28613 .60421 .30315 .61872 .31965 .61139 .30091 Mtetra
.856 .678 .66 r
.61139 .30091 .61872 .31965 .63198 .29198 .62461 .27042 Mtetra
.587 .521 .747 r
.62461 .27042 .63198 .29198 .64622 .29298 .63868 .26759 Mtetra
.765 .598 .671 r
.63868 .26759 .64622 .29298 .65978 .27557 .65208 .24631 Mtetra
.038 .112 .613 r
.65208 .24631 .65978 .27557 .67554 .30483 .66754 .27155 Mtetra
.647 .497 .666 r
.66754 .27155 .67554 .30483 .68973 .29695 .68155 .2611 Mtetra
.717 .534 .641 r
.68155 .2611 .68973 .29695 .70325 .27657 .69497 .23978 Mtetra
0 0 .45 r
.69497 .23978 .70325 .27657 .7211 .32696 .71261 .2897 Mtetra
.652 .491 .652 r
.71261 .2897 .7211 .32696 .7352 .31227 .72678 .27716 Mtetra
.715 .536 .645 r
.72678 .27716 .7352 .31227 .74861 .28831 .74041 .25667 Mtetra
0 .078 .592 r
.74041 .25667 .74861 .28831 .76587 .31593 .75782 .28784 Mtetra
.736 .574 .672 r
.75782 .28784 .76587 .31593 .77939 .29286 .77167 .26893 Mtetra
.548 .486 .739 r
.77167 .26893 .77939 .29286 .79447 .28887 .78702 .26829 Mtetra
.07 .068 .548 r
.13144 .43174 .1364 .46869 .14563 .48693 .14019 .45284 Mtetra
.612 .466 .659 r
.14019 .45284 .14563 .48693 .15822 .47673 .15229 .44649 Mtetra
.486 .394 .676 r
.15229 .44649 .15822 .47673 .1698 .47603 .16341 .44945 Mtetra
.702 .551 .679 r
.16341 .44945 .1698 .47603 .18314 .45918 .17641 .43572 Mtetra
.792 .616 .662 r
.17641 .43572 .18314 .45918 .19767 .43005 .19079 .40853 Mtetra
.185 .253 .701 r
.19079 .40853 .19767 .43005 .20827 .4403 .2013 .41897 Mtetra
.755 .605 .691 r
.2013 .41897 .20827 .4403 .22151 .42387 .21467 .40137 Mtetra
.811 .629 .656 r
.21467 .40137 .22151 .42387 .23576 .39587 .22918 .37097 Mtetra
.485 .421 .71 r
.22918 .37097 .23576 .39587 .24694 .402 .24063 .3735 Mtetra
.522 .426 .687 r
.24063 .3735 .24694 .402 .25837 .40686 .25232 .37438 Mtetra
.642 .491 .663 r
.25232 .37438 .25837 .40686 .27074 .4012 .26493 .36515 Mtetra
.727 .54 .637 r
.26493 .36515 .27074 .4012 .28434 .37992 .27868 .34142 Mtetra
0 0 .114 r
.27868 .34142 .28434 .37992 .29237 .43557 .28666 .39455 Mtetra
.704 .515 .63 r
.28666 .39455 .29237 .43557 .3062 .41295 .30042 .37234 Mtetra
.758 .553 .62 r
.30042 .37234 .3062 .41295 .32086 .37603 .31493 .33758 Mtetra
.955 .676 .232 r
.31493 .33758 .32086 .37603 .3272 .47486 .32084 .43759 Mtetra
.871 .634 .578 r
.32084 .43759 .3272 .47486 .3453 .37904 .33881 .3468 Mtetra
.023 .069 .571 r
.33881 .3468 .3453 .37904 .35676 .39806 .34996 .36933 Mtetra
0 0 .449 r
.34996 .36933 .35676 .39806 .36813 .42419 .36104 .39856 Mtetra
.87 .651 .605 r
.36104 .39856 .36813 .42419 .38363 .36369 .37652 .34086 Mtetra
.597 .51 .727 r
.37652 .34086 .38363 .36369 .39648 .35935 .38932 .33742 Mtetra
.429 .415 .742 r
.38932 .33742 .39648 .35935 .40905 .36461 .40187 .34194 Mtetra
.706 .575 .706 r
.40187 .34194 .40905 .36461 .42225 .35457 .41514 .32978 Mtetra
.889 .662 .588 r
.41514 .32978 .42225 .35457 .437 .2902 .43009 .26276 Mtetra
.935 .628 .169 r
.43009 .26276 .437 .2902 .44765 .37833 .4406 .34595 Mtetra
.881 .644 .574 r
.4406 .34595 .44765 .37833 .46241 .30223 .45554 .26703 Mtetra
.143 .144 .599 r
.45554 .26703 .46241 .30223 .47502 .32772 .46808 .28887 Mtetra
.348 .275 .631 r
.46808 .28887 .47502 .32772 .48806 .34375 .48102 .30249 Mtetra
.521 .388 .641 r
.48102 .30249 .48806 .34375 .50145 .34584 .49429 .30389 Mtetra
.68 .496 .63 r
.49429 .30389 .50145 .34584 .51503 .32615 .5078 .28551 Mtetra
.143 .13 .582 r
.5078 .28551 .51503 .32615 .52859 .35031 .5212 .31159 Mtetra
.207 .182 .608 r
.5212 .31159 .52859 .35031 .54244 .36906 .53492 .33347 Mtetra
.869 .63 .574 r
.53492 .33347 .54244 .36906 .55564 .2932 .54824 .26246 Mtetra
.797 .512 0 r
.54824 .26246 .55564 .2932 .57035 .36291 .56277 .33502 Mtetra
.863 .642 .602 r
.56277 .33502 .57035 .36291 .58348 .30905 .57603 .28448 Mtetra
.769 .604 .674 r
.57603 .28448 .58348 .30905 .59696 .28613 .58956 .2632 Mtetra
.171 .246 .699 r
.58956 .2632 .59696 .28613 .61139 .30091 .60392 .27779 Mtetra
.834 .645 .646 r
.60392 .27779 .61139 .30091 .62461 .27042 .61714 .24587 Mtetra
.623 .52 .717 r
.61714 .24587 .62461 .27042 .63868 .26759 .63108 .24011 Mtetra
.776 .595 .654 r
.63108 .24011 .63868 .26759 .65208 .24631 .64434 .2153 Mtetra
.164 .188 .639 r
.64434 .2153 .65208 .24631 .66754 .27155 .6595 .23615 Mtetra
.668 .504 .653 r
.6595 .23615 .66754 .27155 .68155 .2611 .67327 .22221 Mtetra
.719 .527 .629 r
.67327 .22221 .68155 .2611 .69497 .23978 .68652 .19863 Mtetra
0 0 .488 r
.68652 .19863 .69497 .23978 .71261 .2897 .70381 .24629 Mtetra
.633 .462 .634 r
.70381 .24629 .71261 .2897 .72678 .27716 .71793 .23432 Mtetra
.675 .491 .629 r
.71793 .23432 .72678 .27716 .74041 .25667 .73162 .21607 Mtetra
.09 .106 .582 r
.73162 .21607 .74041 .25667 .75782 .28784 .74906 .24977 Mtetra
.666 .497 .646 r
.74906 .24977 .75782 .28784 .77167 .26893 .76317 .23496 Mtetra
.498 .402 .678 r
.76317 .23496 .77167 .26893 .78702 .26829 .77877 .23819 Mtetra
.828 .45 .339 r
.12138 .43661 .13144 .43174 .14019 .45284 .12983 .46016 Mtetra
.135 0 0 r
.12983 .46016 .14019 .45284 .15229 .44649 .14164 .4571 Mtetra
.614 .192 .218 r
.14164 .4571 .15229 .44649 .16341 .44945 .15237 .46404 Mtetra
0 0 0 r
.15237 .46404 .16341 .44945 .17641 .43572 .16511 .45395 Mtetra
.675 .836 .412 r
.16511 .45395 .17641 .43572 .19079 .40853 .17939 .4294 Mtetra
.656 .303 .362 r
.17939 .4294 .19079 .40853 .2013 .41897 .18977 .442 Mtetra
0 0 0 r
.18977 .442 .2013 .41897 .21467 .40137 .20332 .42445 Mtetra
.706 .812 .352 r
.20332 .42445 .21467 .40137 .22918 .37097 .21821 .39227 Mtetra
.471 .106 .264 r
.21821 .39227 .22918 .37097 .24063 .3735 .23 .39235 Mtetra
.394 .016 .197 r
.23 .39235 .24063 .3735 .25232 .37438 .24211 .3898 Mtetra
0 0 0 r
.24211 .3898 .25232 .37438 .26493 .36515 .25518 .37661 Mtetra
.917 .947 .6 r
.25518 .37661 .26493 .36515 .27868 .34142 .26941 .34906 Mtetra
.884 .546 .404 r
.26941 .34906 .27868 .34142 .28666 .39455 .27748 .40008 Mtetra
.951 .954 .705 r
.27748 .40008 .28666 .39455 .30042 .37234 .29149 .37624 Mtetra
.98 .873 .655 r
.29149 .37624 .30042 .37234 .31493 .33758 .30618 .34131 Mtetra
.931 .619 .43 r
.30618 .34131 .31493 .33758 .32084 .43759 .3117 .44407 Mtetra
.983 .775 .548 r
.3117 .44407 .32084 .43759 .33881 .3468 .32987 .35525 Mtetra
.817 .43 .32 r
.32987 .35525 .33881 .3468 .34996 .36933 .34082 .38188 Mtetra
.823 .458 .366 r
.34082 .38188 .34996 .36933 .36104 .39856 .35168 .41565 Mtetra
.981 .871 .501 r
.35168 .41565 .36104 .39856 .37652 .34086 .36732 .36044 Mtetra
.439 .061 .224 r
.36732 .36044 .37652 .34086 .38932 .33742 .38015 .35943 Mtetra
.562 .195 .304 r
.38015 .35943 .38932 .33742 .40187 .34194 .39279 .36511 Mtetra
.15 0 .131 r
.39279 .36511 .40187 .34194 .41514 .32978 .40628 .35214 Mtetra
.974 .84 .435 r
.40628 .35214 .41514 .32978 .43009 .26276 .42167 .28172 Mtetra
.886 .556 .42 r
.42167 .28172 .43009 .26276 .4406 .34595 .43215 .3633 Mtetra
.998 .817 .469 r
.43215 .3633 .4406 .34595 .45554 .26703 .44755 .27925 Mtetra
.738 .333 .282 r
.44755 .27925 .45554 .26703 .46808 .28887 .46022 .29767 Mtetra
.661 .207 .164 r
.46022 .29767 .46808 .28887 .48102 .30249 .47328 .30831 Mtetra
.273 0 0 r
.47328 .30831 .48102 .30249 .49429 .30389 .48667 .30774 Mtetra
.886 .985 .713 r
.48667 .30774 .49429 .30389 .5078 .28551 .50031 .2887 Mtetra
.845 .412 .197 r
.50031 .2887 .5078 .28551 .5212 .31159 .51373 .31618 Mtetra
.821 .381 .192 r
.51373 .31618 .5212 .31159 .53492 .33347 .52749 .34091 Mtetra
1 .817 .497 r
.52749 .34091 .53492 .33347 .54824 .26246 .5411 .27259 Mtetra
.914 .56 .351 r
.5411 .27259 .54824 .26246 .56277 .33502 .55563 .35037 Mtetra
.904 .849 .397 r
.55563 .35037 .56277 .33502 .57603 .28448 .56919 .30282 Mtetra
0 0 0 r
.56919 .30282 .57603 .28448 .58956 .2632 .58297 .28412 Mtetra
.675 .292 .314 r
.58297 .28412 .58956 .2632 .60392 .27779 .59753 .30072 Mtetra
0 0 0 r
.59753 .30072 .60392 .27779 .61714 .24587 .61098 .26818 Mtetra
.323 0 .209 r
.61098 .26818 .61714 .24587 .63108 .24011 .62507 .2608 Mtetra
0 0 0 r
.62507 .2608 .63108 .24011 .64434 .2153 .63844 .23267 Mtetra
.695 .292 .279 r
.63844 .23267 .64434 .2153 .6595 .23615 .65357 .25022 Mtetra
0 0 0 r
.65357 .25022 .6595 .23615 .67327 .22221 .66733 .23214 Mtetra
.737 .841 .395 r
.66733 .23214 .67327 .22221 .68652 .19863 .68057 .20476 Mtetra
.883 .47 .222 r
.68057 .20476 .68652 .19863 .70381 .24629 .69777 .25043 Mtetra
.584 .894 .618 r
.69777 .25043 .70381 .24629 .71793 .23432 .71194 .23721 Mtetra
.811 .973 .672 r
.71194 .23721 .71793 .23432 .73162 .21607 .7258 .2193 Mtetra
.859 .411 .124 r
.7258 .2193 .73162 .21607 .74906 .24977 .74345 .25544 Mtetra
0 0 0 r
.74345 .25544 .74906 .24977 .76317 .23496 .75796 .2438 Mtetra
.563 .069 .039 r
.75796 .2438 .76317 .23496 .77877 .23819 .77402 .25115 Mtetra
.776 .427 .396 r
.10998 .45088 .12138 .43661 .12983 .46016 .11831 .47563 Mtetra
.417 .011 .158 r
.11831 .47563 .12983 .46016 .14164 .4571 .12995 .47485 Mtetra
.645 .276 .33 r
.12995 .47485 .14164 .4571 .15237 .46404 .14035 .4854 Mtetra
.296 0 .161 r
.14035 .4854 .15237 .46404 .16511 .45395 .15279 .47917 Mtetra
0 0 0 r
.15279 .47917 .16511 .45395 .17939 .4294 .16691 .45803 Mtetra
.661 .33 .402 r
.16691 .45803 .17939 .4294 .18977 .442 .17702 .47422 Mtetra
.15 0 .176 r
.17702 .47422 .18977 .442 .20332 .42445 .19062 .45823 Mtetra
0 0 0 r
.19062 .45823 .20332 .42445 .21821 .39227 .20582 .42563 Mtetra
.473 .149 .337 r
.20582 .42563 .21821 .39227 .23 .39235 .21789 .42458 Mtetra
.405 .081 .301 r
.21789 .42458 .23 .39235 .24211 .3898 .2304 .41943 Mtetra
.091 0 .137 r
.2304 .41943 .24211 .3898 .25518 .37661 .24401 .40242 Mtetra
0 0 0 r
.24401 .40242 .25518 .37661 .26941 .34906 .25882 .37044 Mtetra
.823 .496 .436 r
.25882 .37044 .26941 .34906 .27748 .40008 .26709 .41887 Mtetra
.654 .804 .36 r
.26709 .41887 .27748 .40008 .29149 .37624 .28153 .39187 Mtetra
.93 .913 .527 r
.28153 .39187 .29149 .37624 .30618 .34131 .29656 .35501 Mtetra
.908 .598 .448 r
.29656 .35501 .30618 .34131 .3117 .44407 .30179 .45963 Mtetra
.997 .807 .524 r
.30179 .45963 .3117 .44407 .32987 .35525 .3203 .37112 Mtetra
.791 .431 .374 r
.3203 .37112 .32987 .35525 .34082 .38188 .33107 .40132 Mtetra
.805 .458 .4 r
.33107 .40132 .34082 .38188 .35168 .41565 .34172 .43979 Mtetra
.899 .854 .404 r
.34172 .43979 .35168 .41565 .36732 .36044 .35751 .38749 Mtetra
.516 .168 .316 r
.35751 .38749 .36732 .36044 .38015 .35943 .37033 .39011 Mtetra
.582 .243 .36 r
.37033 .39011 .38015 .35943 .39279 .36511 .38303 .39856 Mtetra
.292 0 .262 r
.38303 .39856 .39279 .36511 .40628 .35214 .39671 .38636 Mtetra
.876 .8 .313 r
.39671 .38636 .40628 .35214 .42167 .28172 .41258 .31342 Mtetra
.85 .527 .441 r
.41258 .31342 .42167 .28172 .43215 .3633 .42304 .39522 Mtetra
.952 .813 .37 r
.42304 .39522 .43215 .3633 .44755 .27925 .439 .30574 Mtetra
.649 .295 .359 r
.439 .30574 .44755 .27925 .46022 .29767 .45188 .3208 Mtetra
.574 .207 .307 r
.45188 .3208 .46022 .29767 .47328 .30831 .46514 .32784 Mtetra
.371 0 .186 r
.46514 .32784 .47328 .30831 .48667 .30774 .47873 .32409 Mtetra
0 0 0 r
.47873 .32409 .48667 .30774 .50031 .2887 .49258 .30275 Mtetra
.785 .393 .312 r
.49258 .30275 .50031 .2887 .51373 .31618 .50607 .33024 Mtetra
.778 .381 .303 r
.50607 .33024 .51373 .31618 .52749 .34091 .5199 .3566 Mtetra
.978 .835 .434 r
.5199 .3566 .52749 .34091 .5411 .27259 .53382 .28972 Mtetra
.898 .55 .378 r
.53382 .28972 .5411 .27259 .55563 .35037 .54835 .37283 Mtetra
.697 .739 .229 r
.54835 .37283 .55563 .35037 .56919 .30282 .56224 .32847 Mtetra
.169 0 .175 r
.56224 .32847 .56919 .30282 .58297 .28412 .57632 .3133 Mtetra
.673 .316 .36 r
.57632 .3133 .58297 .28412 .59753 .30072 .59113 .33351 Mtetra
0 0 .14 r
.59113 .33351 .59753 .30072 .61098 .26818 .60491 .3018 Mtetra
.39 .075 .306 r
.60491 .3018 .61098 .26818 .62507 .2608 .61925 .29434 Mtetra
0 0 .173 r
.61925 .29434 .62507 .2608 .63844 .23267 .63284 .26391 Mtetra
.629 .277 .354 r
.63284 .26391 .63844 .23267 .65357 .25022 .64807 .2791 Mtetra
.081 0 .183 r
.64807 .2791 .65357 .25022 .66733 .23214 .66191 .25682 Mtetra
0 0 .033 r
.66191 .25682 .66733 .23214 .68057 .20476 .67518 .22489 Mtetra
.817 .432 .324 r
.67518 .22489 .68057 .20476 .69777 .25043 .69234 .26794 Mtetra
.006 0 .033 r
.69234 .26794 .69777 .25043 .71194 .23721 .70655 .25191 Mtetra
0 0 0 r
.70655 .25191 .71194 .23721 .7258 .2193 .72052 .2326 Mtetra
.826 .41 .253 r
.72052 .2326 .7258 .2193 .74345 .25544 .73834 .26994 Mtetra
.148 0 .026 r
.73834 .26994 .74345 .25544 .75796 .2438 .75318 .26027 Mtetra
.616 .191 .212 r
.75318 .26027 .75796 .2438 .77402 .25115 .7697 .27125 Mtetra
.059 .042 .521 r
.10565 .40907 .10998 .45088 .11831 .47563 .11398 .43238 Mtetra
.532 .386 .628 r
.11398 .43238 .11831 .47563 .12995 .47485 .12543 .43223 Mtetra
.341 .249 .603 r
.12543 .43223 .12995 .47485 .14035 .4854 .13546 .44468 Mtetra
.563 .415 .638 r
.13546 .44468 .14035 .4854 .15279 .47917 .14744 .44177 Mtetra
.686 .51 .643 r
.14744 .44177 .15279 .47917 .16691 .45803 .16107 .42473 Mtetra
.044 .072 .565 r
.16107 .42473 .16691 .45803 .17702 .47422 .17068 .44444 Mtetra
.681 .528 .671 r
.17068 .44444 .17702 .47422 .19062 .45823 .18393 .43165 Mtetra
.794 .608 .65 r
.18393 .43165 .19062 .45823 .20582 .42563 .19896 .40112 Mtetra
.547 .467 .717 r
.19896 .40112 .20582 .42563 .21789 .42458 .21096 .40033 Mtetra
.636 .524 .71 r
.21096 .40033 .21789 .42458 .2304 .41943 .22357 .39389 Mtetra
.748 .584 .673 r
.22357 .39389 .2304 .41943 .24401 .40242 .23741 .37434 Mtetra
.805 .609 .638 r
.23741 .37434 .24401 .40242 .25882 .37044 .25254 .3391 Mtetra
.715 .469 0 r
.25254 .3391 .25882 .37044 .26709 .41887 .26099 .38284 Mtetra
.758 .561 .631 r
.26099 .38284 .26709 .41887 .28153 .39187 .27568 .35249 Mtetra
.777 .568 .617 r
.27568 .35249 .28153 .39187 .29656 .35501 .29088 .31344 Mtetra
.949 .677 .223 r
.29088 .31344 .29656 .35501 .30179 .45963 .29597 .4144 Mtetra
.85 .613 .579 r
.29597 .4144 .30179 .45963 .3203 .37112 .31448 .32766 Mtetra
0 0 .501 r
.31448 .32766 .3203 .37112 .33107 .40132 .325 .3588 Mtetra
0 0 .394 r
.325 .3588 .33107 .40132 .34172 .43979 .3353 .39944 Mtetra
.8 .583 .607 r
.3353 .39944 .34172 .43979 .35751 .38749 .35088 .35169 Mtetra
.437 .345 .654 r
.35088 .35169 .35751 .38749 .37033 .39011 .36342 .35813 Mtetra
.312 .277 .658 r
.36342 .35813 .37033 .39011 .38303 .39856 .37586 .36989 Mtetra
.656 .519 .685 r
.37586 .36989 .38303 .39856 .39671 .38636 .38942 .36018 Mtetra
.891 .661 .584 r
.38942 .36018 .39671 .38636 .41258 .31342 .40537 .28876 Mtetra
.945 .628 .19 r
.40537 .28876 .41258 .31342 .42304 .39522 .41563 .3691 Mtetra
.911 .671 .562 r
.41563 .3691 .42304 .39522 .439 .30574 .43182 .27822 Mtetra
.284 .283 .682 r
.43182 .27822 .439 .30574 .45188 .3208 .4447 .28975 Mtetra
.487 .399 .682 r
.4447 .28975 .45188 .3208 .46514 .32784 .45797 .29268 Mtetra
.617 .47 .66 r
.45797 .29268 .46514 .32784 .47873 .32409 .47155 .28497 Mtetra
.722 .529 .63 r
.47155 .28497 .47873 .32409 .49258 .30275 .48539 .26069 Mtetra
.165 .14 .582 r
.48539 .26069 .49258 .30275 .50607 .33024 .49872 .28544 Mtetra
.19 .152 .582 r
.49872 .28544 .50607 .33024 .5199 .3566 .51237 .31057 Mtetra
.828 .59 .578 r
.51237 .31057 .5199 .3566 .53382 .28972 .52632 .24603 Mtetra
.705 .477 0 r
.52632 .24603 .53382 .28972 .54835 .37283 .54054 .32989 Mtetra
.776 .559 .606 r
.54054 .32989 .54835 .37283 .56224 .32847 .55445 .28983 Mtetra
.636 .475 .648 r
.55445 .28983 .56224 .32847 .57632 .3133 .56853 .27881 Mtetra
.116 .14 .609 r
.56853 .27881 .57632 .3133 .59113 .33351 .58327 .30247 Mtetra
.778 .587 .641 r
.58327 .30247 .59113 .33351 .60491 .3018 .59714 .27399 Mtetra
.613 .501 .702 r
.59714 .27399 .60491 .3018 .61925 .29434 .6115 .26811 Mtetra
.812 .623 .646 r
.6115 .26811 .61925 .29434 .63284 .26391 .62512 .23784 Mtetra
.253 .281 .697 r
.62512 .23784 .63284 .26391 .64807 .2791 .64021 .25117 Mtetra
.777 .597 .655 r
.64021 .25117 .64807 .2791 .66191 .25682 .65393 .22606 Mtetra
.812 .606 .623 r
.65393 .22606 .66191 .25682 .67518 .22489 .66705 .19068 Mtetra
0 0 .517 r
.66705 .19068 .67518 .22489 .69234 .26794 .68378 .22889 Mtetra
.694 .512 .637 r
.68378 .22889 .69234 .26794 .70655 .25191 .69772 .20938 Mtetra
.696 .505 .625 r
.69772 .20938 .70655 .25191 .72052 .2326 .71147 .18771 Mtetra
.099 .1 .571 r
.71147 .18771 .72052 .2326 .73834 .26994 .72894 .2229 Mtetra
.603 .436 .628 r
.72894 .2229 .73834 .26994 .75318 .26027 .74371 .21376 Mtetra
.406 .307 .629 r
.74371 .21376 .75318 .26027 .7697 .27125 .76019 .22639 Mtetra
0 0 .417 r
.09896 .38591 .10565 .40907 .11398 .43238 .1075 .40672 Mtetra
.55 .459 .705 r
.1075 .40672 .11398 .43238 .12543 .43223 .11901 .40566 Mtetra
.141 .18 .642 r
.11901 .40566 .12543 .43223 .13546 .44468 .12889 .41866 Mtetra
.543 .455 .705 r
.12889 .41866 .13546 .44468 .14744 .44177 .14057 .41793 Mtetra
.714 .572 .693 r
.14057 .41793 .14744 .44177 .16107 .42473 .15383 .40426 Mtetra
0 0 .299 r
.15383 .40426 .16107 .42473 .17068 .44444 .16293 .42772 Mtetra
.704 .618 .759 r
.16293 .42772 .17068 .44444 .18393 .43165 .17578 .41876 Mtetra
.857 .704 .691 r
.17578 .41876 .18393 .43165 .19896 .40112 .19059 .3913 Mtetra
.42 .609 .927 r
.19059 .3913 .19896 .40112 .21096 .40033 .20242 .39235 Mtetra
.707 .765 .897 r
.20242 .39235 .21096 .40033 .22357 .39389 .21504 .3862 Mtetra
.875 .772 .744 r
.21504 .3862 .22357 .39389 .23741 .37434 .22907 .36534 Mtetra
.909 .739 .659 r
.22907 .36534 .23741 .37434 .25254 .3391 .24455 .32747 Mtetra
.939 .57 .21 r
.24455 .32747 .25254 .3391 .26099 .38284 .25319 .36756 Mtetra
.868 .692 .662 r
.25319 .36756 .26099 .38284 .27568 .35249 .26828 .33335 Mtetra
.867 .67 .635 r
.26828 .33335 .27568 .35249 .29088 .31344 .28383 .29091 Mtetra
.976 .671 .335 r
.28383 .29091 .29088 .31344 .29597 .4144 .28887 .38819 Mtetra
.897 .664 .578 r
.28887 .38819 .29597 .4144 .31448 .32766 .30762 .30075 Mtetra
0 0 .349 r
.30762 .30075 .31448 .32766 .325 .3588 .31802 .33162 Mtetra
.725 .447 0 r
.31802 .33162 .325 .3588 .3353 .39944 .32809 .37349 Mtetra
.845 .639 .624 r
.32809 .37349 .3353 .39944 .35088 .35169 .34356 .32905 Mtetra
.24 .292 .715 r
.34356 .32905 .35088 .35169 .36342 .35813 .35585 .33916 Mtetra
0 .097 .644 r
.35585 .33916 .36342 .35813 .37586 .36989 .36805 .35482 Mtetra
.668 .632 .804 r
.36805 .35482 .37586 .36989 .38942 .36018 .38148 .34861 Mtetra
.94 .723 .581 r
.38148 .34861 .38942 .36018 .40537 .28876 .39754 .27952 Mtetra
.958 .62 .312 r
.39754 .27952 .40537 .28876 .41563 .3691 .40757 .36096 Mtetra
.96 .73 .546 r
.40757 .36096 .41563 .3691 .43182 .27822 .42405 .26923 Mtetra
0 .227 .731 r
.42405 .26923 .43182 .27822 .4447 .28975 .43699 .27861 Mtetra
.507 .628 .905 r
.43699 .27861 .4447 .28975 .45797 .29268 .45036 .27822 Mtetra
.754 .677 .777 r
.45036 .27822 .45797 .29268 .47155 .28497 .46404 .26659 Mtetra
.843 .674 .672 r
.46404 .26659 .47155 .28497 .48539 .26069 .47799 .23854 Mtetra
0 .024 .585 r
.47799 .23854 .48539 .26069 .49872 .28544 .49127 .25983 Mtetra
0 .045 .587 r
.49127 .25983 .49872 .28544 .51237 .31057 .50483 .28258 Mtetra
.888 .655 .58 r
.50483 .28258 .51237 .31057 .52632 .24603 .51888 .21811 Mtetra
.89 .58 .076 r
.51888 .21811 .52632 .24603 .54054 .32989 .53285 .30212 Mtetra
.829 .626 .629 r
.53285 .30212 .54054 .32989 .55445 .28983 .54683 .26493 Mtetra
.641 .533 .715 r
.54683 .26493 .55445 .28983 .56853 .27881 .56094 .25748 Mtetra
0 0 .497 r
.56094 .25748 .56853 .27881 .58327 .30247 .57568 .28502 Mtetra
.841 .688 .693 r
.57568 .28502 .58327 .30247 .59714 .27399 .58969 .26039 Mtetra
.594 .631 .858 r
.58969 .26039 .59714 .27399 .6115 .26811 .60415 .25743 Mtetra
.917 .775 .689 r
.60415 .25743 .6115 .26811 .62512 .23784 .61792 .22869 Mtetra
0 .128 .654 r
.61792 .22869 .62512 .23784 .64021 .25117 .63303 .24201 Mtetra
.926 .802 .704 r
.63303 .24201 .64021 .25117 .65393 .22606 .64678 .21522 Mtetra
.946 .769 .631 r
.64678 .21522 .65393 .22606 .66705 .19068 .65988 .17689 Mtetra
.674 .29 0 r
.65988 .17689 .66705 .19068 .68378 .22889 .67635 .21117 Mtetra
.839 .689 .697 r
.67635 .21117 .68378 .22889 .69772 .20938 .69012 .18766 Mtetra
.819 .65 .674 r
.69012 .18766 .69772 .20938 .71147 .18771 .70369 .16251 Mtetra
0 0 .536 r
.70369 .16251 .71147 .18771 .72894 .2229 .72086 .19469 Mtetra
.659 .529 .694 r
.72086 .19469 .72894 .2229 .74371 .21376 .73552 .18438 Mtetra
.313 .304 .69 r
.73552 .18438 .74371 .21376 .76019 .22639 .75195 .19725 Mtetra
.152 .127 .573 r
.0941 .34933 .09896 .38591 .1075 .40672 .10298 .36641 Mtetra
.566 .416 .636 r
.10298 .36641 .1075 .40672 .11901 .40566 .1147 .36302 Mtetra
.345 .249 .601 r
.1147 .36302 .11901 .40566 .12889 .41866 .12458 .37481 Mtetra
.527 .381 .625 r
.12458 .37481 .12889 .41866 .14057 .41793 .13607 .37469 Mtetra
.632 .459 .63 r
.13607 .37469 .14057 .41793 .15383 .40426 .14898 .36332 Mtetra
0 0 .492 r
.14898 .36332 .15383 .40426 .16293 .42772 .1576 .38952 Mtetra
.586 .437 .646 r
.1576 .38952 .16293 .42772 .17578 .41876 .16996 .38444 Mtetra
.732 .548 .643 r
.16996 .38444 .17578 .41876 .19059 .3913 .18433 .361 Mtetra
.455 .375 .677 r
.18433 .361 .19059 .3913 .20242 .39235 .19579 .36498 Mtetra
.597 .483 .695 r
.19579 .36498 .20242 .39235 .21504 .3862 .20819 .36066 Mtetra
.753 .588 .671 r
.20819 .36066 .21504 .3862 .22907 .36534 .2222 .34022 Mtetra
.829 .631 .636 r
.2222 .34022 .22907 .36534 .24455 .32747 .23783 .30139 Mtetra
.735 .455 0 r
.23783 .30139 .24455 .32747 .25319 .36756 .24658 .33839 Mtetra
.809 .609 .632 r
.24658 .33839 .25319 .36756 .26828 .33335 .26197 .30098 Mtetra
.82 .608 .616 r
.26197 .30098 .26828 .33335 .28383 .29091 .27783 .25525 Mtetra
.959 .675 .24 r
.27783 .25525 .28383 .29091 .28887 .38819 .28292 .34715 Mtetra
.862 .624 .577 r
.28292 .34715 .28887 .38819 .30762 .30075 .3019 .25851 Mtetra
0 .007 .511 r
.3019 .25851 .30762 .30075 .31802 .33162 .31225 .2872 Mtetra
0 0 .39 r
.31225 .2872 .31802 .33162 .32809 .37349 .32214 .32816 Mtetra
.77 .554 .606 r
.32214 .32816 .32809 .37349 .34356 .32905 .33746 .28615 Mtetra
.353 .263 .613 r
.33746 .28615 .34356 .32905 .35585 .33916 .34946 .29884 Mtetra
.217 .176 .595 r
.34946 .29884 .35585 .33916 .36805 .35482 .36134 .31786 Mtetra
.555 .423 .655 r
.36134 .31786 .36805 .35482 .38148 .34861 .3745 .31558 Mtetra
.862 .632 .589 r
.3745 .31558 .38148 .34861 .39754 .27952 .39049 .25065 Mtetra
.934 .629 .168 r
.39049 .25065 .39754 .27952 .40757 .36096 .4002 .33353 Mtetra
.908 .667 .562 r
.4002 .33353 .40757 .36096 .42405 .26923 .41681 .24354 Mtetra
.335 .329 .704 r
.41681 .24354 .42405 .26923 .43699 .27861 .4297 .25211 Mtetra
.57 .476 .708 r
.4297 .25211 .43699 .27861 .45036 .27822 .44308 .2495 Mtetra
.701 .546 .674 r
.44308 .2495 .45036 .27822 .46404 .26659 .45681 .23466 Mtetra
.785 .586 .631 r
.45681 .23466 .46404 .26659 .47799 .23854 .47082 .20308 Mtetra
.237 .211 .626 r
.47082 .20308 .47799 .23854 .49127 .25983 .48401 .22011 Mtetra
.242 .2 .61 r
.48401 .22011 .49127 .25983 .50483 .28258 .49745 .23909 Mtetra
.838 .598 .576 r
.49745 .23909 .50483 .28258 .51888 .21811 .51155 .17382 Mtetra
0 0 .121 r
.51155 .17382 .51888 .21811 .53285 .30212 .52518 .25532 Mtetra
.747 .533 .604 r
.52518 .25532 .53285 .30212 .54683 .26493 .53913 .21987 Mtetra
.572 .416 .631 r
.53913 .21987 .54683 .26493 .56094 .25748 .55315 .21492 Mtetra
.078 .083 .561 r
.55315 .21492 .56094 .25748 .57568 .28502 .56774 .24534 Mtetra
.698 .513 .634 r
.56774 .24534 .57568 .28502 .58969 .26039 .58178 .22498 Mtetra
.519 .408 .667 r
.58178 .22498 .58969 .26039 .60415 .25743 .59626 .2257 Mtetra
.761 .573 .644 r
.59626 .2257 .60415 .25743 .61792 .22869 .61012 .2001 Mtetra
.242 .258 .677 r
.61012 .2001 .61792 .22869 .63303 .24201 .62518 .21475 Mtetra
.79 .607 .653 r
.62518 .21475 .63303 .24201 .64678 .21522 .63896 .1881 Mtetra
.848 .638 .617 r
.63896 .1881 .64678 .21522 .65988 .17689 .65204 .14849 Mtetra
0 0 .55 r
.65204 .14849 .65988 .17689 .67635 .21117 .66823 .17936 Mtetra
.77 .578 .639 r
.66823 .17936 .67635 .21117 .69012 .18766 .68179 .1523 Mtetra
.763 .563 .627 r
.68179 .1523 .69012 .18766 .70369 .16251 .69512 .12351 Mtetra
.13 .137 .597 r
.69512 .12351 .70369 .16251 .72086 .19469 .71185 .15138 Mtetra
.635 .463 .632 r
.71185 .15138 .72086 .19469 .73552 .18438 .72623 .13857 Mtetra
.413 .31 .628 r
.72623 .13857 .73552 .18438 .75195 .19725 .74238 .14983 Mtetra
.614 .303 .419 r
.07843 .39122 .0941 .34933 .10298 .36641 .08787 .40515 Mtetra
.384 .071 .306 r
.08787 .40515 .10298 .36641 .1147 .36302 .10022 .39845 Mtetra
.592 .269 .39 r
.10022 .39845 .1147 .36302 .12458 .37481 .11046 .40842 Mtetra
.466 .137 .324 r
.11046 .40842 .12458 .37481 .13607 .37469 .12221 .4076 Mtetra
.268 0 .224 r
.12221 .4076 .13607 .37469 .14898 .36332 .13525 .39682 Mtetra
.719 .399 .436 r
.13525 .39682 .14898 .36332 .1576 .38952 .14358 .42619 Mtetra
.458 .135 .33 r
.14358 .42619 .1576 .38952 .16996 .38444 .15574 .42454 Mtetra
.125 0 .189 r
.15574 .42454 .16996 .38444 .18433 .361 .17001 .40446 Mtetra
.564 .251 .396 r
.17001 .40446 .18433 .361 .19579 .36498 .18122 .41267 Mtetra
.477 .173 .371 r
.18122 .41267 .19579 .36498 .20819 .36066 .19353 .41156 Mtetra
.251 0 .286 r
.19353 .41156 .20819 .36066 .2222 .34022 .20771 .39243 Mtetra
0 0 .112 r
.20771 .39243 .2222 .34022 .23783 .30139 .22381 .35257 Mtetra
.703 .396 .455 r
.22381 .35257 .23783 .30139 .24658 .33839 .23266 .39 Mtetra
0 0 .101 r
.23266 .39 .24658 .33839 .26197 .30098 .24875 .34864 Mtetra
0 0 0 r
.24875 .34864 .26197 .30098 .27783 .25525 .26541 .29785 Mtetra
.831 .525 .472 r
.26541 .29785 .27783 .25525 .28292 .34715 .2705 .38914 Mtetra
.954 .829 .395 r
.2705 .38914 .28292 .34715 .3019 .25851 .29044 .29407 Mtetra
.698 .37 .416 r
.29044 .29407 .3019 .25851 .31225 .2872 .30103 .321 Mtetra
.759 .43 .429 r
.30103 .321 .31225 .2872 .32214 .32816 .31101 .36184 Mtetra
0 0 0 r
.31101 .36184 .32214 .32816 .33746 .28615 .3267 .3189 Mtetra
.63 .291 .378 r
.3267 .3189 .33746 .28615 .34946 .29884 .33873 .33383 Mtetra
.676 .341 .399 r
.33873 .33383 .34946 .29884 .36134 .31786 .35055 .35667 Mtetra
.5 .177 .35 r
.35055 .35667 .36134 .31786 .3745 .31558 .36374 .35841 Mtetra
0 0 0 r
.36374 .35841 .3745 .31558 .39049 .25065 .38006 .29537 Mtetra
.828 .511 .452 r
.38006 .29537 .39049 .25065 .4002 .33353 .3895 .38527 Mtetra
.777 .727 .197 r
.3895 .38527 .4002 .33353 .41681 .24354 .40668 .29432 Mtetra
.566 .255 .401 r
.40668 .29432 .41681 .24354 .4297 .25211 .41978 .30445 Mtetra
.463 .165 .374 r
.41978 .30445 .4297 .25211 .44308 .2495 .43347 .3013 Mtetra
.312 .037 .326 r
.43347 .3013 .44308 .2495 .45681 .23466 .44761 .28387 Mtetra
.019 0 .214 r
.44761 .28387 .45681 .23466 .47082 .20308 .46208 .24794 Mtetra
.596 .274 .394 r
.46208 .24794 .47082 .20308 .48401 .22011 .47554 .26184 Mtetra
.613 .284 .388 r
.47554 .26184 .48401 .22011 .49745 .23909 .48923 .27769 Mtetra
.715 .697 .161 r
.48923 .27769 .49745 .23909 .51155 .17382 .50377 .20727 Mtetra
.85 .512 .411 r
.50377 .20727 .51155 .17382 .52518 .25532 .51743 .28934 Mtetra
0 0 .059 r
.51743 .28934 .52518 .25532 .53913 .21987 .5317 .25246 Mtetra
.423 .091 .296 r
.5317 .25246 .53913 .21987 .55315 .21492 .54597 .24865 Mtetra
.731 .377 .381 r
.54597 .24865 .55315 .21492 .56774 .24534 .56076 .28282 Mtetra
.246 0 .263 r
.56076 .28282 .56774 .24534 .58178 .22498 .57517 .26566 Mtetra
.529 .201 .356 r
.57517 .26566 .58178 .22498 .59626 .2257 .59001 .27076 Mtetra
.229 0 .29 r
.59001 .27076 .59626 .2257 .61012 .2001 .60431 .24827 Mtetra
.614 .287 .392 r
.60431 .24827 .61012 .2001 .62518 .21475 .61979 .26679 Mtetra
.238 0 .315 r
.61979 .26679 .62518 .21475 .63896 .1881 .63399 .24089 Mtetra
.058 0 .265 r
.63399 .24089 .63896 .1881 .65204 .14849 .64745 .19978 Mtetra
.667 .335 .402 r
.64745 .19978 .65204 .14849 .66823 .17936 .66391 .23058 Mtetra
.181 0 .302 r
.66391 .23058 .66823 .17936 .68179 .1523 .67769 .1996 Mtetra
.119 0 .276 r
.67769 .1996 .68179 .1523 .69512 .12351 .69115 .16606 Mtetra
.657 .313 .377 r
.69115 .16606 .69512 .12351 .71185 .15138 .70796 .19108 Mtetra
.289 .006 .298 r
.70796 .19108 .71185 .15138 .72623 .13857 .72241 .17434 Mtetra
.563 .215 .337 r
.72241 .17434 .72623 .13857 .74238 .14983 .73867 .18349 Mtetra
0 .118 .669 r
.07022 .37781 .07843 .39122 .08787 .40515 .08014 .38792 Mtetra
.72 .619 .744 r
.08014 .38792 .08787 .40515 .10022 .39845 .09302 .37731 Mtetra
.306 .343 .736 r
.09302 .37731 .10022 .39845 .11046 .40842 .10366 .38379 Mtetra
.584 .49 .714 r
.10366 .38379 .11046 .40842 .12221 .4076 .11566 .3806 Mtetra
.681 .538 .684 r
.11566 .3806 .12221 .4076 .13525 .39682 .12878 .369 Mtetra
0 0 .254 r
.12878 .369 .13525 .39682 .14358 .42619 .13692 .39876 Mtetra
.514 .431 .7 r
.13692 .39876 .14358 .42619 .15574 .42454 .14877 .3993 Mtetra
.73 .577 .683 r
.14877 .3993 .15574 .42454 .17001 .40446 .16267 .38269 Mtetra
.068 .184 .678 r
.16267 .38269 .17001 .40446 .18122 .41267 .17339 .39475 Mtetra
.427 .464 .795 r
.17339 .39475 .18122 .41267 .19353 .41156 .18529 .39749 Mtetra
.795 .687 .746 r
.18529 .39749 .19353 .41156 .20771 .39243 .1992 .3815 Mtetra
.899 .727 .659 r
.1992 .3815 .20771 .39243 .22381 .35257 .21524 .34347 Mtetra
.932 .553 .226 r
.21524 .34347 .22381 .35257 .23266 .39 .22396 .38127 Mtetra
.92 .744 .647 r
.22396 .38127 .23266 .39 .24875 .34864 .24032 .33855 Mtetra
.924 .728 .619 r
.24032 .33855 .24875 .34864 .26541 .29785 .25737 .28511 Mtetra
.964 .647 .364 r
.25737 .28511 .26541 .29785 .2705 .38914 .26252 .37255 Mtetra
.928 .696 .567 r
.26252 .37255 .2705 .38914 .29044 .29407 .28301 .27386 Mtetra
0 0 .403 r
.28301 .27386 .29044 .29407 .30103 .321 .29378 .29691 Mtetra
.746 .443 0 r
.29378 .29691 .30103 .321 .31101 .36184 .30383 .33447 Mtetra
.84 .633 .623 r
.30383 .33447 .31101 .36184 .3267 .3189 .31966 .29041 Mtetra
.157 .19 .645 r
.31966 .29041 .3267 .3189 .33873 .33383 .3316 .30522 Mtetra
0 0 .524 r
.3316 .30522 .33873 .33383 .35055 .35667 .34322 .32945 Mtetra
.429 .384 .707 r
.34322 .32945 .35055 .35667 .36374 .35841 .3562 .33416 Mtetra
.885 .664 .599 r
.3562 .33416 .36374 .35841 .38006 .29537 .37245 .27529 Mtetra
.966 .644 .275 r
.37245 .27529 .38006 .29537 .3895 .38527 .38146 .36884 Mtetra
.937 .704 .56 r
.38146 .36884 .3895 .38527 .40668 .29432 .39872 .28159 Mtetra
0 .134 .68 r
.39872 .28159 .40668 .29432 .41978 .30445 .41173 .29414 Mtetra
.564 .684 .921 r
.41173 .29414 .41978 .30445 .43347 .3013 .42542 .29194 Mtetra
.863 .785 .773 r
.42542 .29194 .43347 .3013 .44761 .28387 .43965 .2738 Mtetra
.93 .759 .648 r
.43965 .2738 .44761 .28387 .46208 .24794 .45429 .23564 Mtetra
0 .242 .757 r
.45429 .23564 .46208 .24794 .47554 .26184 .4678 .24616 Mtetra
.003 .236 .744 r
.4678 .24616 .47554 .26184 .48923 .27769 .48151 .25791 Mtetra
.93 .695 .562 r
.48151 .25791 .48923 .27769 .50377 .20727 .49625 .18397 Mtetra
.911 .584 .107 r
.49625 .18397 .50377 .20727 .51743 .28934 .50969 .26199 Mtetra
.838 .633 .626 r
.50969 .26199 .51743 .28934 .5317 .25246 .524 .22332 Mtetra
.587 .478 .696 r
.524 .22332 .5317 .25246 .54597 .24865 .53822 .21893 Mtetra
0 0 .463 r
.53822 .21893 .54597 .24865 .56076 .28282 .55288 .25374 Mtetra
.696 .547 .68 r
.55288 .25374 .56076 .28282 .57517 .26566 .56732 .23926 Mtetra
.347 .345 .714 r
.56732 .23926 .57517 .26566 .59001 .27076 .58217 .24791 Mtetra
.762 .618 .699 r
.58217 .24791 .59001 .27076 .60431 .24827 .5966 .22958 Mtetra
0 .008 .583 r
.5966 .22958 .60431 .24827 .61979 .26679 .61213 .2519 Mtetra
.857 .727 .718 r
.61213 .2519 .61979 .26679 .63399 .24089 .62651 .229 Mtetra
.943 .763 .63 r
.62651 .229 .63399 .24089 .64745 .19978 .64016 .18945 Mtetra
.724 .292 0 r
.64016 .18945 .64745 .19978 .66391 .23058 .65659 .22024 Mtetra
.941 .79 .665 r
.65659 .22024 .66391 .23058 .67769 .1996 .6704 .18755 Mtetra
.941 .768 .64 r
.6704 .18755 .67769 .1996 .69115 .16606 .68381 .15102 Mtetra
0 .025 .597 r
.68381 .15102 .69115 .16606 .70796 .19108 .70035 .17206 Mtetra
.813 .674 .709 r
.70035 .17206 .70796 .19108 .72241 .17434 .71459 .15125 Mtetra
.411 .414 .753 r
.71459 .15125 .72241 .17434 .73867 .18349 .73054 .15658 Mtetra
.573 .231 .352 r
.05577 .40699 .07022 .37781 .08014 .38792 .0662 .41435 Mtetra
.025 0 .036 r
.0662 .41435 .08014 .38792 .09302 .37731 .07979 .39977 Mtetra
.508 .138 .273 r
.07979 .39977 .09302 .37731 .10366 .38379 .09103 .40251 Mtetra
.211 0 .056 r
.09103 .40251 .10366 .38379 .11566 .3806 .10361 .39591 Mtetra
0 0 0 r
.10361 .39591 .11566 .3806 .12878 .369 .11717 .38187 Mtetra
.803 .447 .383 r
.11717 .38187 .12878 .369 .13692 .39876 .12535 .41128 Mtetra
.448 .005 .101 r
.12535 .41128 .13692 .39876 .14877 .3993 .13719 .41269 Mtetra
0 0 0 r
.13719 .41269 .14877 .3993 .16267 .38269 .15099 .39818 Mtetra
.701 .319 .32 r
.15099 .39818 .16267 .38269 .17339 .39475 .16136 .41399 Mtetra
.578 .192 .275 r
.16136 .41399 .17339 .39475 .18529 .39749 .17291 .42096 Mtetra
.091 0 .05 r
.17291 .42096 .18529 .39749 .1992 .3815 .18662 .40871 Mtetra
.672 .783 .313 r
.18662 .40871 .1992 .3815 .21524 .34347 .2027 .37304 Mtetra
.773 .444 .43 r
.2027 .37304 .21524 .34347 .22396 .38127 .21117 .41394 Mtetra
.678 .759 .269 r
.21117 .41394 .22396 .38127 .24032 .33855 .2279 .37052 Mtetra
.868 .844 .38 r
.2279 .37052 .24032 .33855 .25737 .28511 .24552 .31449 Mtetra
.857 .544 .456 r
.24552 .31449 .25737 .28511 .26252 .37255 .25061 .40161 Mtetra
.999 .819 .484 r
.25061 .40161 .26252 .37255 .28301 .27386 .27204 .29695 Mtetra
.696 .335 .359 r
.27204 .29695 .28301 .27386 .29378 .29691 .28316 .31659 Mtetra
.79 .434 .383 r
.28316 .31659 .29378 .29691 .30383 .33447 .29345 .35118 Mtetra
.967 .893 .519 r
.29345 .35118 .30383 .33447 .31966 .29041 .30979 .30358 Mtetra
.682 .267 .252 r
.30979 .30358 .31966 .29041 .3316 .30522 .32188 .3172 Mtetra
.782 .386 .305 r
.32188 .3172 .3316 .30522 .34322 .32945 .33351 .34201 Mtetra
.57 .129 .162 r
.33351 .34201 .34322 .32945 .3562 .33416 .34648 .34864 Mtetra
.99 .867 .519 r
.34648 .34864 .3562 .33416 .37245 .27529 .36291 .2919 Mtetra
.906 .577 .413 r
.36291 .2919 .37245 .27529 .38146 .36884 .37151 .39139 Mtetra
.991 .829 .454 r
.37151 .39139 .38146 .36884 .39872 .28159 .38908 .30645 Mtetra
.66 .29 .334 r
.38908 .30645 .39872 .28159 .41173 .29414 .40207 .32306 Mtetra
.469 .115 .282 r
.40207 .32306 .41173 .29414 .42542 .29194 .41587 .32348 Mtetra
.136 0 .168 r
.41587 .32348 .42542 .29194 .43965 .2738 .43034 .30598 Mtetra
0 0 0 r
.43034 .30598 .43965 .2738 .45429 .23564 .44534 .26621 Mtetra
.571 .216 .328 r
.44534 .26621 .45429 .23564 .4678 .24616 .45908 .27493 Mtetra
.572 .211 .317 r
.45908 .27493 .4678 .24616 .48151 .25791 .47301 .28367 Mtetra
.944 .814 .365 r
.47301 .28367 .48151 .25791 .49625 .18397 .4882 .20413 Mtetra
.881 .528 .376 r
.4882 .20413 .49625 .18397 .50969 .26199 .50163 .27986 Mtetra
.825 .833 .362 r
.50163 .27986 .50969 .26199 .524 .22332 .51621 .2372 Mtetra
.183 0 0 r
.51621 .2372 .524 .22332 .53822 .21893 .53058 .23072 Mtetra
.826 .418 .273 r
.53058 .23072 .53822 .21893 .55288 .25374 .5453 .26561 Mtetra
0 0 0 r
.5453 .26561 .55288 .25374 .56732 .23926 .55992 .25214 Mtetra
.634 .185 .167 r
.55992 .25214 .56732 .23926 .58217 .24791 .57494 .26368 Mtetra
0 0 0 r
.57494 .26368 .58217 .24791 .5966 .22958 .58966 .24884 Mtetra
.748 .346 .289 r
.58966 .24884 .5966 .22958 .61213 .2519 .60545 .276 Mtetra
.018 0 .083 r
.60545 .276 .61213 .2519 .62651 .229 .6202 .25668 Mtetra
0 0 0 r
.6202 .25668 .62651 .229 .64016 .18945 .63425 .21925 Mtetra
.737 .362 .341 r
.63425 .21925 .64016 .18945 .65659 .22024 .65097 .25276 Mtetra
0 0 .118 r
.65097 .25276 .65659 .22024 .6704 .18755 .66507 .21924 Mtetra
0 0 .075 r
.66507 .21924 .6704 .18755 .68381 .15102 .67869 .18013 Mtetra
.65 .272 .315 r
.67869 .18013 .68381 .15102 .70035 .17206 .69531 .19884 Mtetra
0 0 .115 r
.69531 .19884 .70035 .17206 .71459 .15125 .70955 .17369 Mtetra
.466 .078 .218 r
.70955 .17369 .71459 .15125 .73054 .15658 .72546 .17508 Mtetra
.463 .308 .585 r
.05372 .35046 .05577 .40699 .0662 .41435 .06428 .35561 Mtetra
.638 .442 .601 r
.06428 .35561 .0662 .41435 .07979 .39977 .07814 .33824 Mtetra
.527 .352 .587 r
.07814 .33824 .07979 .39977 .09103 .40251 .08975 .33694 Mtetra
.589 .396 .589 r
.08975 .33694 .09103 .40251 .10361 .39591 .10267 .3265 Mtetra
.62 .418 .587 r
.10267 .3265 .10361 .39591 .11717 .38187 .11646 .30943 Mtetra
.253 .13 .512 r
.11646 .30943 .11717 .38187 .12535 .41128 .12479 .33519 Mtetra
.512 .328 .568 r
.12479 .33519 .12535 .41128 .13719 .41269 .13653 .33543 Mtetra
.593 .391 .578 r
.13653 .33543 .13719 .41269 .15099 .39818 .15 .32198 Mtetra
.37 .219 .541 r
.15 .32198 .15099 .39818 .16136 .41399 .15994 .33912 Mtetra
.438 .272 .558 r
.15994 .33912 .16136 .41399 .17291 .42096 .17091 .34892 Mtetra
.568 .376 .581 r
.17091 .34892 .17291 .42096 .18662 .40871 .18399 .34079 Mtetra
.681 .467 .589 r
.18399 .34079 .18662 .40871 .2027 .37304 .19947 .30989 Mtetra
0 0 .418 r
.19947 .30989 .2027 .37304 .21117 .41394 .20746 .3524 Mtetra
.725 .506 .593 r
.20746 .3524 .21117 .41394 .2279 .37052 .22385 .31195 Mtetra
.769 .541 .589 r
.22385 .31195 .2279 .37052 .24552 .31449 .24129 .25765 Mtetra
.773 .58 .01 r
.24129 .25765 .24552 .31449 .25061 .40161 .24631 .34071 Mtetra
.841 .595 .567 r
.24631 .34071 .25061 .40161 .27204 .29695 .26784 .23641 Mtetra
.361 .231 .566 r
.26784 .23641 .27204 .29695 .28316 .31659 .27906 .25168 Mtetra
.199 .107 .519 r
.27906 .25168 .28316 .31659 .29345 .35118 .28945 .28086 Mtetra
.734 .505 .58 r
.28945 .28086 .29345 .35118 .30979 .30358 .30585 .23113 Mtetra
.438 .277 .564 r
.30585 .23113 .30979 .30358 .32188 .3172 .31789 .2412 Mtetra
.337 .199 .541 r
.31789 .2412 .32188 .3172 .33351 .34201 .32937 .26325 Mtetra
.473 .299 .564 r
.32937 .26325 .33351 .34201 .34648 .34864 .34208 .26943 Mtetra
.727 .493 .572 r
.34208 .26943 .34648 .34864 .36291 .2919 .35819 .21642 Mtetra
0 0 .147 r
.35819 .21642 .36291 .2919 .37151 .39139 .36632 .31463 Mtetra
.784 .538 .565 r
.36632 .31463 .37151 .39139 .38908 .30645 .38355 .23651 Mtetra
.35 .217 .556 r
.38355 .23651 .38908 .30645 .40207 .32306 .39612 .25623 Mtetra
.488 .322 .582 r
.39612 .25623 .40207 .32306 .41587 .32348 .40958 .25991 Mtetra
.611 .416 .593 r
.40958 .25991 .41587 .32348 .43034 .30598 .42379 .24517 Mtetra
.719 .497 .588 r
.42379 .24517 .43034 .30598 .44534 .26621 .43865 .20735 Mtetra
.45 .304 .591 r
.43865 .20735 .44534 .26621 .45908 .27493 .45219 .21492 Mtetra
.466 .315 .591 r
.45219 .21492 .45908 .27493 .47301 .28367 .46595 .22097 Mtetra
.818 .567 .559 r
.46595 .22097 .47301 .28367 .4882 .20413 .48116 .14054 Mtetra
0 0 .348 r
.48116 .14054 .4882 .20413 .50163 .27986 .49424 .20943 Mtetra
.723 .491 .574 r
.49424 .20943 .50163 .27986 .51621 .2372 .50869 .16423 Mtetra
.572 .378 .58 r
.50869 .16423 .51621 .2372 .53058 .23072 .52282 .15452 Mtetra
.279 .165 .54 r
.52282 .15452 .53058 .23072 .5453 .26561 .53715 .18559 Mtetra
.586 .384 .574 r
.53715 .18559 .5453 .26561 .55992 .25214 .5515 .17186 Mtetra
.441 .279 .564 r
.5515 .17186 .55992 .25214 .57494 .26368 .5662 .18369 Mtetra
.577 .377 .574 r
.5662 .18369 .57494 .26368 .58966 .24884 .5807 .17172 Mtetra
.305 .186 .549 r
.5807 .17172 .58966 .24884 .60545 .276 .59619 .20109 Mtetra
.595 .394 .579 r
.59619 .20109 .60545 .276 .6202 .25668 .61084 .18631 Mtetra
.679 .457 .578 r
.61084 .18631 .6202 .25668 .63425 .21925 .62488 .15376 Mtetra
.211 .135 .548 r
.62488 .15376 .63425 .21925 .65097 .25276 .64134 .18884 Mtetra
.686 .467 .584 r
.64134 .18884 .65097 .25276 .66507 .21924 .65541 .15777 Mtetra
.719 .492 .58 r
.65541 .15777 .66507 .21924 .67869 .18013 .66894 .11964 Mtetra
.383 .262 .589 r
.66894 .11964 .67869 .18013 .69531 .19884 .68516 .13585 Mtetra
.672 .457 .586 r
.68516 .13585 .69531 .19884 .70955 .17369 .6991 .10834 Mtetra
.534 .36 .591 r
.6991 .10834 .70955 .17369 .72546 .17508 .71449 .10559 Mtetra
.547 .174 .285 r
.04003 .37208 .05372 .35046 .06428 .35561 .05071 .37712 Mtetra
0 0 0 r
.05071 .37712 .06428 .35561 .07814 .33824 .06505 .35765 Mtetra
.3 0 .112 r
.06505 .35765 .07814 .33824 .08975 .33694 .0772 .35335 Mtetra
0 0 0 r
.0772 .35335 .08975 .33694 .10267 .3265 .09078 .33902 Mtetra
.818 .956 .618 r
.09078 .33902 .10267 .3265 .11646 .30943 .10526 .3179 Mtetra
.797 .412 .327 r
.10526 .3179 .11646 .30943 .12479 .33519 .11397 .34064 Mtetra
.105 0 0 r
.11397 .34064 .12479 .33519 .13653 .33543 .12607 .33861 Mtetra
.864 .991 .829 r
.12607 .33861 .13653 .33543 .15 .32198 .13976 .32423 Mtetra
.803 .365 .203 r
.13976 .32423 .15 .32198 .15994 .33912 .14958 .34231 Mtetra
.722 .244 .11 r
.14958 .34231 .15994 .33912 .17091 .34892 .16031 .35452 Mtetra
0 0 0 r
.16031 .35452 .17091 .34892 .18399 .34079 .17311 .34975 Mtetra
.949 .955 .67 r
.17311 .34975 .18399 .34079 .19947 .30989 .18838 .32242 Mtetra
.856 .512 .401 r
.18838 .32242 .19947 .30989 .20746 .3524 .19586 .36963 Mtetra
.931 .92 .542 r
.19586 .36963 .20746 .3524 .22385 .31195 .21225 .33169 Mtetra
.979 .886 .527 r
.21225 .33169 .22385 .31195 .24129 .25765 .22991 .27825 Mtetra
.879 .561 .443 r
.22991 .27825 .24129 .25765 .24631 .34071 .23461 .36353 Mtetra
.999 .804 .507 r
.23461 .36353 .24631 .34071 .26784 .23641 .2569 .25584 Mtetra
.65 .267 .305 r
.2569 .25584 .26784 .23641 .27906 .25168 .26839 .26886 Mtetra
.763 .389 .348 r
.26839 .26886 .27906 .25168 .28945 .28086 .27907 .295 Mtetra
.993 .871 .545 r
.27907 .295 .28945 .28086 .30585 .23113 .29608 .2406 Mtetra
.573 .105 .104 r
.29608 .2406 .30585 .23113 .31789 .2412 .30844 .24718 Mtetra
.78 .341 .208 r
.30844 .24718 .31789 .2412 .32937 .26325 .3201 .26669 Mtetra
.478 0 0 r
.3201 .26669 .32937 .26325 .34208 .26943 .33296 .27148 Mtetra
.986 .818 .591 r
.33296 .27148 .34208 .26943 .35819 .21642 .34932 .21816 Mtetra
.941 .611 .379 r
.34932 .21816 .35819 .21642 .36632 .31463 .35709 .31908 Mtetra
.991 .794 .541 r
.35709 .31908 .36632 .31463 .38355 .23651 .37452 .24319 Mtetra
.803 .373 .224 r
.37452 .24319 .38355 .23651 .39612 .25623 .38695 .26707 Mtetra
.588 .127 .125 r
.38695 .26707 .39612 .25623 .40958 .25991 .40034 .27496 Mtetra
0 0 0 r
.40034 .27496 .40958 .25991 .42379 .24517 .41462 .26362 Mtetra
.77 .834 .372 r
.41462 .26362 .42379 .24517 .43865 .20735 .42967 .22759 Mtetra
.585 .187 .254 r
.42967 .22759 .43865 .20735 .45219 .21492 .44333 .23641 Mtetra
.536 .143 .243 r
.44333 .23641 .45219 .21492 .46595 .22097 .45725 .24202 Mtetra
.98 .818 .415 r
.45725 .24202 .46595 .22097 .48116 .14054 .47292 .15784 Mtetra
.879 .518 .359 r
.47292 .15784 .48116 .14054 .49424 .20943 .48599 .22479 Mtetra
.933 .863 .433 r
.48599 .22479 .49424 .20943 .50869 .16423 .50076 .17491 Mtetra
0 0 0 r
.50076 .17491 .50869 .16423 .52282 .15452 .51506 .16123 Mtetra
.821 .381 .195 r
.51506 .16123 .52282 .15452 .53715 .18559 .52942 .18944 Mtetra
.766 .977 .71 r
.52942 .18944 .53715 .18559 .5515 .17186 .54389 .17353 Mtetra
.631 .076 0 r
.54389 .17353 .5515 .17186 .5662 .18369 .55865 .18497 Mtetra
.679 .977 .824 r
.55865 .18497 .5662 .18369 .5807 .17172 .57329 .17405 Mtetra
.85 .397 .123 r
.57329 .17405 .5807 .17172 .59619 .20109 .58887 .20639 Mtetra
.439 .82 .579 r
.58887 .20639 .59619 .20109 .61084 .18631 .60377 .19517 Mtetra
.823 .899 .484 r
.60377 .19517 .61084 .18631 .62488 .15376 .61814 .16629 Mtetra
.836 .418 .247 r
.61814 .16629 .62488 .15376 .64134 .18884 .63485 .20601 Mtetra
0 0 0 r
.63485 .20601 .64134 .18884 .65541 .15777 .64927 .17744 Mtetra
.64927 .17744 .65541 .15777 .66894 .11964 .66314 .1402 Mtetra
.658 .244 .248 r
.66314 .1402 .66894 .11964 .68516 .13585 .67955 .15688 Mtetra
0 0 0 r
.67955 .15688 .68516 .13585 .6991 .10834 .69364 .12721 Mtetra
.298 0 .117 r
.69364 .12721 .6991 .10834 .71449 .10559 .70906 .1215 Mtetra
.405 .311 .636 r
.03503 .3358 .04003 .37208 .05071 .37712 .04544 .3419 Mtetra
.708 .529 .645 r
.04544 .3419 .05071 .37712 .06505 .35765 .05978 .32231 Mtetra
.597 .451 .654 r
.05978 .32231 .06505 .35765 .0772 .35335 .07212 .31614 Mtetra
.687 .509 .641 r
.07212 .31614 .0772 .35335 .09078 .33902 .08607 .29892 Mtetra
.719 .526 .628 r
.08607 .29892 .09078 .33902 .10526 .3179 .10098 .27438 Mtetra
.175 .121 .553 r
.10098 .27438 .10526 .3179 .11397 .34064 .11009 .29266 Mtetra
.569 .402 .615 r
.11009 .29266 .11397 .34064 .12607 .33861 .1225 .28719 Mtetra
.645 .453 .61 r
.1225 .28719 .12607 .33861 .13976 .32423 .13635 .27075 Mtetra
.292 .186 .557 r
.13635 .27075 .13976 .32423 .14958 .34231 .14614 .28733 Mtetra
.365 .238 .572 r
.14614 .28733 .14958 .34231 .16031 .35452 .15664 .29976 Mtetra
.537 .368 .6 r
.15664 .29976 .16031 .35452 .17311 .34975 .16905 .29714 Mtetra
.68 .479 .607 r
.16905 .29714 .17311 .34975 .18838 .32242 .18384 .27362 Mtetra
0 0 .216 r
.18384 .27362 .18838 .32242 .19586 .36963 .19074 .3235 Mtetra
.74 .532 .612 r
.19074 .3235 .19586 .36963 .21225 .33169 .20666 .29002 Mtetra
.802 .581 .604 r
.20666 .29002 .21225 .33169 .22991 .27825 .224 .24046 Mtetra
.948 .67 .216 r
.224 .24046 .22991 .27825 .23461 .36353 .2283 .32607 Mtetra
.887 .644 .566 r
.2283 .32607 .23461 .36353 .2569 .25584 .25065 .22027 Mtetra
.3 .247 .63 r
.25065 .22027 .2569 .25584 .26839 .26886 .26216 .23172 Mtetra
.013 .04 .541 r
.26216 .23172 .26839 .26886 .27907 .295 .27292 .25463 Mtetra
.825 .598 .595 r
.27292 .25463 .27907 .295 .29608 .2406 .29019 .19758 Mtetra
.485 .353 .626 r
.29019 .19758 .29608 .2406 .30844 .24718 .30272 .2 Mtetra
.305 .216 .587 r
.30272 .2 .30844 .24718 .3201 .26669 .31448 .21523 Mtetra
.496 .345 .606 r
.31448 .21523 .3201 .26669 .33296 .27148 .32736 .21693 Mtetra
.78 .548 .585 r
.32736 .21693 .33296 .27148 .34932 .21816 .34372 .16346 Mtetra
.816 .593 .037 r
.34372 .16346 .34932 .21816 .35709 .31908 .35119 .26142 Mtetra
.812 .57 .571 r
.35119 .26142 .35709 .31908 .37452 .24319 .36847 .18915 Mtetra
.184 .118 .543 r
.36847 .18915 .37452 .24319 .38695 .26707 .38056 .21515 Mtetra
.388 .27 .595 r
.38056 .21515 .38695 .26707 .40034 .27496 .39362 .22645 Mtetra
.581 .413 .619 r
.39362 .22645 .40034 .27496 .41462 .26362 .40762 .21919 Mtetra
.742 .532 .611 r
.40762 .21919 .41462 .26362 .42967 .22759 .42252 .18719 Mtetra
.358 .278 .628 r
.42252 .18719 .42967 .22759 .44333 .23641 .43597 .19811 Mtetra
.426 .333 .647 r
.43597 .19811 .44333 .23641 .45725 .24202 .44977 .20446 Mtetra
.886 .637 .556 r
.44977 .20446 .45725 .24202 .47292 .15784 .46555 .12089 Mtetra
0 0 .147 r
.46555 .12089 .47292 .15784 .48599 .22479 .4784 .18437 Mtetra
.825 .594 .588 r
.4784 .18437 .48599 .22479 .50076 .17491 .49322 .13199 Mtetra
.667 .483 .626 r
.49322 .13199 .50076 .17491 .51506 .16123 .50745 .11459 Mtetra
.2 .153 .577 r
.50745 .11459 .51506 .16123 .52942 .18944 .5216 .13807 Mtetra
.654 .459 .608 r
.5216 .13807 .52942 .18944 .54389 .17353 .53594 .11918 Mtetra
.429 .298 .599 r
.53594 .11918 .54389 .17353 .55865 .18497 .55046 .12805 Mtetra
.596 .411 .601 r
.55046 .12805 .55865 .18497 .57329 .17405 .56493 .11671 Mtetra
.169 .113 .546 r
.56493 .11671 .57329 .17405 .58887 .20639 .58023 .14895 Mtetra
.577 .397 .602 r
.58023 .14895 .58887 .20639 .60377 .19517 .59502 .14039 Mtetra
.678 .471 .598 r
.59502 .14039 .60377 .19517 .61814 .16629 .6094 .11565 Mtetra
0 0 .508 r
.6094 .11565 .61814 .16629 .63485 .20601 .62594 .15824 Mtetra
.694 .493 .611 r
.62594 .15824 .63485 .20601 .64927 .17744 .64046 .13396 Mtetra
.756 .541 .605 r
.64046 .13396 .64927 .17744 .66314 .1402 .65444 .10021 Mtetra
.27 .229 .627 r
.65444 .10021 .66314 .1402 .67955 .15688 .67076 .11802 Mtetra
.754 .549 .62 r
.67076 .11802 .67955 .15688 .69364 .12721 .68483 .08869 Mtetra
.595 .449 .653 r
.68483 .08869 .69364 .12721 .70906 .1215 .70006 .08131 Mtetra
.554 .25 .406 r
.01547 .392 .03503 .3358 .04544 .3419 .0256 .40134 Mtetra
.25 0 .277 r
.0256 .40134 .04544 .3419 .05978 .32231 .04016 .38242 Mtetra
.415 .12 .353 r
.04016 .38242 .05978 .32231 .07212 .31614 .05284 .3759 Mtetra
.245 0 .277 r
.05284 .3759 .07212 .31614 .08607 .29892 .06745 .35627 Mtetra
.073 0 .193 r
.06745 .35627 .08607 .29892 .10098 .27438 .08324 .32779 Mtetra
.596 .287 .416 r
.08324 .32779 .10098 .27438 .11009 .29266 .09293 .3432 Mtetra
.36 .058 .311 r
.09293 .3432 .11009 .29266 .1225 .28719 .10613 .33375 Mtetra
.148 0 .202 r
.10613 .33375 .1225 .28719 .13635 .27075 .12074 .31348 Mtetra
.609 .286 .397 r
.12074 .31348 .13635 .27075 .14614 .28733 .13089 .3285 Mtetra
.59 .263 .384 r
.13089 .3285 .14614 .28733 .15664 .29976 .14158 .34067 Mtetra
.445 .12 .32 r
.14158 .34067 .15664 .29976 .16905 .29714 .15411 .33893 Mtetra
.071 0 .152 r
.15411 .33893 .16905 .29714 .18384 .27362 .169 .31706 Mtetra
.771 .455 .453 r
.169 .31706 .18384 .27362 .19074 .3235 .17536 .37249 Mtetra
0 0 .134 r
.17536 .37249 .19074 .3235 .20666 .29002 .19132 .34199 Mtetra
0 0 0 r
.19132 .34199 .20666 .29002 .224 .24046 .20887 .29449 Mtetra
.81 .503 .47 r
.20887 .29449 .224 .24046 .2283 .32607 .21246 .38748 Mtetra
.894 .804 .323 r
.21246 .38748 .2283 .32607 .25065 .22027 .2357 .27893 Mtetra
.568 .259 .405 r
.2357 .27893 .25065 .22027 .26216 .23172 .24737 .29152 Mtetra
.622 .311 .422 r
.24737 .29152 .26216 .23172 .27292 .25463 .25836 .31447 Mtetra
0 0 0 r
.25836 .31447 .27292 .25463 .29019 .19758 .27653 .25233 Mtetra
.468 .162 .364 r
.27653 .25233 .29019 .19758 .30272 .2 .28959 .25144 Mtetra
.57 .252 .391 r
.28959 .25144 .30272 .2 .31448 .21523 .30182 .26348 Mtetra
.453 .14 .343 r
.30182 .26348 .31448 .21523 .32736 .21693 .31521 .26167 Mtetra
0 0 0 r
.31521 .26167 .32736 .21693 .34372 .16346 .33227 .20362 Mtetra
.851 .529 .442 r
.33227 .20362 .34372 .16346 .35119 .26142 .33956 .30375 Mtetra
.806 .77 .261 r
.33956 .30375 .35119 .26142 .36847 .18915 .35743 .22926 Mtetra
.688 .348 .394 r
.35743 .22926 .36847 .18915 .38056 .21515 .36954 .25812 Mtetra
.6 .264 .373 r
.36954 .25812 .38056 .21515 .39362 .22645 .38267 .27319 Mtetra
.436 .12 .33 r
.38267 .27319 .39362 .22645 .40762 .21919 .39681 .26984 Mtetra
.105 0 .224 r
.39681 .26984 .40762 .21919 .42252 .18719 .41199 .24085 Mtetra
.584 .262 .39 r
.41199 .24085 .42252 .18719 .43597 .19811 .42559 .25617 Mtetra
.543 .229 .386 r
.42559 .25617 .43597 .19811 .44977 .20446 .43962 .26566 Mtetra
0 0 0 r
.43962 .26566 .44977 .20446 .46555 .12089 .45607 .17928 Mtetra
.76 .43 .428 r
.45607 .17928 .46555 .12089 .4784 .18437 .46905 .24549 Mtetra
0 0 .153 r
.46905 .24549 .4784 .18437 .49322 .13199 .48444 .1886 Mtetra
.27 0 .307 r
.48444 .1886 .49322 .13199 .50745 .11459 .4991 .16727 Mtetra
.614 .285 .389 r
.4991 .16727 .50745 .11459 .5216 .13807 .51354 .18799 Mtetra
.21 0 .273 r
.51354 .18799 .5216 .13807 .53594 .11918 .52825 .16454 Mtetra
.523 .193 .35 r
.52825 .16454 .53594 .11918 .55046 .12805 .54305 .17064 Mtetra
.305 .005 .281 r
.54305 .17064 .55046 .12805 .56493 .11671 .55782 .15699 Mtetra
.701 .345 .37 r
.55782 .15699 .56493 .11671 .58023 .14895 .57334 .19008 Mtetra
.38 .062 .296 r
.57334 .19008 .58023 .14895 .59502 .14039 .58848 .18259 Mtetra
.174 0 .242 r
.58848 .18259 .59502 .14039 .6094 .11565 .60328 .15977 Mtetra
.747 .39 .378 r
.60328 .15977 .6094 .11565 .62594 .15824 .62022 .2081 Mtetra
.26 0 .293 r
.62022 .2081 .62594 .15824 .64046 .13396 .63528 .18728 Mtetra
.161 0 .278 r
.63528 .18728 .64046 .13396 .65444 .10021 .64983 .15621 Mtetra
.61 .276 .381 r
.64983 .15621 .65444 .10021 .67076 .11802 .66672 .17827 Mtetra
.234 0 .316 r
.66672 .17827 .67076 .11802 .68483 .08869 .68131 .14943 Mtetra
.423 .129 .359 r
.68131 .14943 .68483 .08869 .70006 .08131 .69698 .14196 Mtetra
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-1)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-0.5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(0.5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(1)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 233.562},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000jB000`400?l00000o`00003ooooooolQ
ooooo`00`?ooool3o`0005gooooo0031ooooo`03o`000?oooooooooo05cooooo0031ooooo`03o`00
0?oooooooooo05cooooo0031ooooo`03o`000?oooooooooo05cooooo0031ooooo`03o`000?oooooo
oooo05cooooo0030ooooo`;o00003_ooool3o`0004gooooo0031ooooo`03o`000?oooooooooo00go
oooo00?o0000ooooooooool0C?ooool00<Wooooo1Ol00003ooooo`03o`000?oooooooooo04cooooo
003Aooooo`03o`000?oooooooooo04cooooo003Aooooo`03o`000?oooooooooo04cooooo003@oooo
o`;o0000C_ooool00<Gooooo0_l0000:ooooo`03o`000?oooooooooo04cooooo0032ooooo`?o0000
00?oooooo`000?l00000F?ooool00<3ooooo0_l00004ooooo`;o0000F?ooool00;gooooo0ol00006
ooooo`03o`000?oooooo000005Oooooo002jooooo`?o00002Oooool00ol0003oooooo`00001Goooo
o`00^?ooool2o`0000?ooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool0001Foooo
o`00]Oooool3o`0000kooooo00Go0000ooooooooooooooooo`00001Eooooo`00/oooool2o`00017o
oooo00Co0000oooooooooooooooo0_l0001Dooooo`00Q_ooool2o`0000Cooooo00?o0000oooooooo
ool00_ooool3o`0001cooooo0ol0000Cooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0D_ooool008Gooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000
01Wooooo0_l00003ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`1Aooooo`00QOooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo
01Cooooo0ol0000Iooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0DOooool008Go
oooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Aooooo`?o00007?ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo053ooooo0025ooooo`04o`000?ooooooooooo`00
00Oooooo1?l0000Booooo`;o000000?oooooo`000?ooool07?ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo053ooooo0025ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000oooo
ooooool04?ooool3o`00027ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1?oooo
o`00Q_ooool2o`0000Sooooo1Ol0000<ooooo`;o00009?ooool00ol0003oooooooooo`04ooooo`;o
0000D?ooool009kooooo0ol0000Vooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
C_ooool009cooooo0_l00002ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`1=ooooo`00VOooool3o`0002_ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`1<ooooo`00Uoooool2o`0002kooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`1<ooooo`00U?ooool3o`00033ooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`1;ooooo`00TOooool3o`0000?ooooo00?o0000ooooooooool0;Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo04[ooooo002?ooooo`;o0000=_ooool00ol0003ooooooooo
o`09ooooo`;o0000Boooool008cooooo0ol0000hooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool0BOooool008[ooooo1?l0000iooooo`03o`000?m/8E_ooooo00_ooooo00?o0000oooo
ooooool0B?ooool008Oooooo0ol0000looooo`03of`QFol0003oK25K00cooooo00?o0000oooooooo
ool0B?ooool008Gooooo0_l0000nooooo`;oK25K00?o0000of`QFonHLZL03?ooool00ol0003ooooo
ooooo`17ooooo`00H_ooool2o`0001kooooo0ol00010ooooo`?oK25K00?o0000oiQbYoooool03?oo
ool00ol0003oooooooooo`16ooooo`00HOooool01?l0003oooooooooool0000Jooooo`?o00000_oo
ool00ol0003oooooooooo`0mooooo`06oc/0D?m/8E_oK25Kof`QFol0003oV7:W3Oooool00ol0003o
ooooooooo`16ooooo`00HOooool01?l0003oooooooooool0000Hooooo`;o0000AOooool01Olk053o
K25Kof`QFom/8E_o000000;oV7:W3?ooool2o`0000oooooo0_l00004ooooo`03o`000?oooooooooo
00;ooooo0ol0000Zooooo`00HOooool01?l0003oooooooooool0000Eooooo`?o0000@?ooool00onL
AV7oooooooooo`03ooooo`;o>`1@0om/8E/00ol0003oV7:WoiQbY`0>ooooo`03o`000?oooooooooo
00_ooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000002Wooooo001Q
ooooo`04o`000?ooooooooooo`0001?ooooo0ol00011ooooo`03obT0AonLAV7oW4IQ00Cooooo0_lk
0503of`QF`03o`000?nHLZOoV7:W00;oC00M3?ooool00ol0003oooooooooo`04ooooo`Go00000_oo
ool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo02Oooooo001Qooooo`04o`000?oo
ooooooooo`00013ooooo0ol00003ooooo`03o`000?oooooooooo03kooooo00Co:@17oia6HOnLAV7o
W4IQ0_ooool3oc/0D0?oK25K00?o0000oiQbYonHLZL00_m<01d=ooooo`03o`000?oooooooooo00[o
oooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0Wooooo`00H_ooool2o`0000oo
oooo0_l00016ooooo`;o:@171?nLAV401?oooooo>`1@oc/0D?lk0503of`QF`05o`000?nHLZOoV7:W
oiQbYom<01d03Oooool00ol0003oooooooooo`0:ooooo`04o`000?ooooooooooo`0000Oooooo1?l0
000Zooooo`00L?ooool3o`0002;ooooo00?oWDQSooooooooool01Oooool2ohDaFA;ooooo00?o_f=P
ooooooooool01oooool2obT0A`CoW4IQ1?lk0503of`QF`04o`000?nHLZOoV7:WoiQbY`;oR5bG3Ooo
ool00ol0003oooooooooo`09ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool0
:oooool006gooooo0ol00002ooooo`03o`000?oooooooooo01oooooo00?oA@1>oie8HonMB6<01_oo
ool3ohDaF@?ooooo00?oCP57ok=HG_ooool02_ooool00ol/03go_f=Pooooo`08ooooo`;o:@171?nL
AV43oc/0D0CoK25K00?o0000oiQbYonHLZL00on8G9L>ooooo`03o`000?oooooooooo00Wooooo0_l0
0008ooooo`Go0000:Oooool006_ooooo0_l0000Vooooo`;oA@1>0_nMB6<5ooooo`03ocD0AOn5<EWo
QC5I00;oQC5I00?oooooodh1Aom>0DL00_ncF5h:ooooo`03ob`0?OnoHf3ooooo00Oooooo0olY04L4
oia6H@?o>`1@1?m/8E/00ol0003o[7BFohQLU`03ohQLU`gooooo0_l00013ooooo`00J?ooool3o`00
01kooooo00?o`Vi]ooooooooool01_ooool2odD0CPCoWDQS0oooool00ole04GoQC5IohDaF@03ohDa
F@?oCP570_ncF5h9ooooo`04ob`0?OnoHf3o_f=PokmSH0Oooooo0_lY04L5oia6H@?o>`1@1?m/8E/0
0ol0003o[7BFohQLU`03ohQLU`oooooo00?o0000ooooooooool0@?ooool006Kooooo0ol0000Poooo
o`03ol9^KOoooooooooo00Gooooo0om504h5oie8H`03oooooole04Go=@1500GoQC5I0om>0DL3ok=H
GPOooooo0_l/03d3okmSH0Kooooo0olY04L5oia6H@?o>`1@1?m/8E/00ol0003o[7BFohQLU`03ohQL
Ua3ooooo00?o0000ooooooooool0?oooool006?ooooo0ol00003ooooo`03o`000?oooooooooo01co
oooo00?o0000ol9^KOooool01_ooool3odD0CPGoWDQS0ole04D5ohDaF@?oCP570oncF5h7ooooo`;o
;00m0onoHf06ooooo`?o:@171OnLAV43oc/0D0CoK25K00?o0000ojadU_n8G9L00on8G9L@ooooo`03
o`000?oooooooooo03oooooo001Qooooo`;o00009Oooool2ol9^K@Oooooo0om504h5oie8H`?o=@15
1On5<ET2odh1A`Go/eQN1?ooool01?mQ3d_o;00mob`0?Ol/03d4okmSH0Cooooo00Co@P1;obT0AolY
04Oo:@171OnLAV43oc/0D0CoK25K00?o0000ojadU_n/M9H01?n8G9L00om90DcoT3MFoi0gEP0=oooo
o`03o`000?oooooooooo03kooooo001Nooooo`?o00009oooool3ol9^K@Gooooo00Co000WodD0C_m5
04koA@1>1OnMB6<2ocD0A@GoQC5I0om>0DL6ok=HGP04oooooomQ3d_oH@m;of4?B`?o;00m1?noHf04
ooooo`04od80BolY04Oo:@17obT0A`GoW4IQ0olk0503of`QF`04ojadU_l0003o[7BFojadUPCoR5bG
00?oB@5<oi0gE_n@=eH00_n@=eH<ooooo`;o0000?_ooool005cooooo0_l00002ooooo`03o`000?oo
oooooooo02Gooooo0oo2KVd2ooooo`04on64Foooooooooooo`009`?oA@1>1?nMB6<3ocD0A@GoQC5I
0om>0DL6ok=HGPCoH@m;0ol/03d4okmSH0?ooooo0_m204/3obT0A`GoW4IQ0olk05001Om/8E_oHT>F
ojadU_n/M9Ko000000;o[7BF1?n8G9L00om90DcoT3MFoi0gEP03oi0gEP_ooooo00?o0000oooooooo
ool0?Oooool005Wooooo0ol0000/ooooo`?o`Vi]00Goooooon64FooQQ5_ohHAKooooo`04odD0CPCo
WDQS0ole04D5ohDaF@?oCP571_ncF5h4of4?B`;o;00m1_noHf001?oooooo@P1;od80Bom204/3obT0
A`CoW4IQ1?lk05001Oo1S9koHT>FojadU_n/M9Ko000000;o[7BF1?n8G9L00om90DcoT3MFoi0gEP03
oi0gEPcooooo00?o0000ooooooooool0??ooool002_ooooo0_l00004ooooo`03o`000?oooooooooo
00;ooooo0ol0000Mooooo`?o0000;oooool3ol9^K@05oooooooQQ5_ohHAKon64Fol002L00om504h5
oie8H`?o=@151On5<ET3odh1A`Ko/eQN0omQ3d/3ob`0?@Ko_f=P00Cooooood80Bom204_o@P1;0olY
04L4oia6H@Co>`1@00?o`HbNof93U_n/M9H00_n/M9H00ol0003o[7BFohQLU`03ohQLU`;oMa<g1?n@
=eH=ooooo`03o`000?oooooooooo03_ooooo000Zooooo`04o`000?ooooooooooo`0000Oooooo00Go
0000ooooooooooooooooo`00000Jooooo`;o000000?oooooo`000?ooool0;_ooool01?l0003o`Vi]
ol9^KOo2KVd4on64F`04o`009om504koA@1>odD0CPGoWDQS0ole04D5ohDaF@;oCP5700?oV6VIok=H
G_ncF5h01?ncF5h3of4?B`?o;00m1_noHf04od80B`?o:@1700Co`HZJoia6HOnLAV7oW4IQ0olk0503
of93UP?o[7BF00?o0000ojadU_n8G9L00on8G9L2ogLC=`CoT3MF3Oooool00ol0003oooooooooo`0k
ooooo`008oooool5o`0000;ooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`0E
ooooo`?o0000<oooool00ol0003o`Vi]ol9^K@02ol9^K@?ohHAK00Co000WodD0C_m504koA@1>1OnM
B6<2ocD0A@GoQC5I0_m>0DL00om]C9WoV6VIoiQYV@04ok=HGPCoH@m;0ol/03d6okmSH0?o@P1;0olY
04L2ol6:VP03okQmU?nLAV7oW4IQ00?o>`1@0omR@iH3ojadUP03o`000?n/M9Ko[7BF00?oR5bG0_mg
4cL01OmYJL3oT3MFoi0gE_n@=eKoJDnP00gooooo00?o0000ooooooooool0>_ooool002[ooooo00Co
0000oooooooooooo00002oooool00ol0003oooooooooo`0Cooooo`;o0000=_ooool00ol0003o`Vi]
ol9^K@02ol9^K@?ohHAK00Co000WodD0C_m504koA@1>1?nMB6<3ocD0A@CoYgFK00CoQC5Iodh1Aom]
C9WoKDbI0_nHJIT4ok=HGPCoH@m;0_l/03d2ojehV@Go_f=P0om204/3obT0A`03ol6:V_n_MiGo^7fD
00;oW4IQ0_lk05000onhOICoHT>Fof93UP02of93UP;o[7BF00?o0000ojadU_n/M9H01?n8G9L00omg
4cOoJFW0oi0gEP02oi0gEP03ofU?X?oooooooooo00cooooo00?o0000ooooooooool0>Oooool002[o
oooo00Co0000oooooooooooo00001oooool4o`0001?ooooo0ol0000hooooo`Go`Vi]0_oQQ5/2o`00
9`?oA@1>00CoZW^Poie8HonMB6?oWDQS0ole04D5ojMeV`CoKDbI0_nHJIT3ok=HGPCoH@m;0_l/03d2
ojehV@Go_f=P0om204/2obT0A`07ok5nW?o1RY[o[gNEojmgUOnhOICoW4IQoc/0D002okQmU0CoHT>F
0_n/M9H00ol0003o[7BFojadUP04ohQLU`?oJFW000?oT3MFofU?X?mYCj003_ooool2o`0003[ooooo
000Zooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool04_ooool2o`0000?ooooo
00?o0000ooooooooool05Oooool00ooIQg7oooooooooo`0Mooooo`Go`Vi]0_oQQ5/2o`009`;oA@1>
00?odiRFonkLK_nMB6<00_nMB6<2ocD0A@;o<bNC1?nWMI/01?o4n[GoUV:Bofe<VOm]C9T2oiQYV@?o
/eQN1?mQ3d/01?l/03goTfFJojehVOn]N9T4okmSH0Co@P1;0_lY04L01?naOYco`HZJojmgUOn_MiD2
okQmU003oc/0D?nhOICo^7fD00CoHT>F0_n/M9H00ol0003o[7BFojadUP03om2/]@05ohQLUonRMZ7o
JFW0ofUY`?n@=eH00_mYCj0?ooooo`03o`000?oooooooooo03Sooooo000[ooooo`;o00002?ooool5
o`0000gooooo0ol0000Mooooo`03omV7LOo@U`Wooooo01cooooo00?o0000ol9^KOo2KVd01?o2KVd0
1?oQQ5_o000WodD0C_m504h2om>HUP05onkLK_niOI;oWDQSoie8Hole04D00_nBH9@01Olc9i?oYgFK
ojMeVonWMI_oa?Ze00;oUV:B00CoL4N@ofe<VOnHJIWoV6VI0oncF5h3of4?B`03ob`0?OnCII[oTfFJ
00?o[GRI0onoHf04od80B`;o:@1700Co/GjLojmgUOn_MiGo[gNE1OnhOI@4of93UP;o[7BF00?o0000
ojadU_n/M9H00oo@[;D4oj9fX@03oi0gE_mYCj3oJDnP013ooooo00?o0000ooooooooool0=oooool0
04Cooooo0ol0000Pooooo`03omV7LOo@U`Wooooo01cooooo00?o0000ol9^KOo2KVd01?o2KVd2o`00
9`;oA@1>0_oCV9H01Oo^g6ko^GfBoie8HonMB6?o=@1500;oTV2D00Co<bNCojMeVonWMI_oa?Ze0onF
HY82og17T003oiQYVOn]n];o[O[B00;o/eQN0omQ3d/01?l/03goTfFJoi=UV_nCIIX2ojehV@?o_f=P
1?m204/00olY04Oo/GjLok5nW003ojmgU@Go^7fD00Col<BSof93U_mR@iKoHT>F0_n/M9H00ol0003o
[7BFom2/]@02om2/]@GoXWJQ0omYCj0@ooooo`03o`000?oooooooooo03Oooooo0012ooooo`;o0000
0_ooool00ol0003oooooooooo`0Mooooo`;ofHMa00?od9L9ooooooooool06oooool00ol0003o`Vi]
ol9^K@04ol9^K@;o000W00CoA@1>om>HU_oCV9Kok]a^0oniOI801ole04GoTV2Doi9PU?nBH9CoAbZ:
ojMeVom7:XX01?nFHY84og17T003oi=PT_ncF5koH@m;00;oH@m;1OnCIIX2ojehV@?o_f=P1?m204/0
0olY04Oo/GjLojmgU@03ojmgU@Go^7fD0_o`a:<2of93UP;o[7BF00Go0000ojadU_o@[;God:beo`00
R@04oj9fX@04ojR7/Om@CK3oJDnPofU?X17ooooo00?o0000ooooooooool0=_ooool003oooooo0ol0
000Tooooo`?ofHMa5Oooool00onE@f?oooooooooo`05ooooo`03o`000?o2KVgo`Vi]00Co`Vi]0_l0
02L3om>HUP04onkLK_niOI;o^GfBokUmTPCoTV2D0om7:XX4oiIRTPCoL4N@0_nCH9800omQ3d_oTf2B
ob/LR`05oi=UVP03ojehVOoBiW_o_f=P00;o_f=P1?m204/2ok5nW0Go[gNE1?nhOI@2oo34X`07olFC
XomR@iKoHT>FojadU_l0003odJJ/om2/]@02o`00R@03ob4SV?nRMZ7oXWJQ00;oZ8Na0_m@CK02ofU?
X13ooooo00?o0000ooooooooool0=_ooool003gooooo0_l0000Wooooo`?ofHMa1_ooool00on`FFCo
ooooooooo`0<ooooo`;oUD=S1_ooool2on:SSPGo`Vi]0_l002L3om>HUP04onkLK_niOI;o^GfBokUm
TPCoTV2D0om7:XX5oiIRTP?oL4N@1?nCH982ob/LR`CoTfFJ00?o[GRIoiQTU?n]M9<00_noHf04od80
B`03ok5nW?n_MiGo[gNE00Co[gNE0onhOI@2oo34X`;oaI>S00Coe[2bof93U_n/M9Ko00000_oAYZ`0
1?lI6I;o0029o`00ROnRMZ44ojR7/@;oD4f`00?oJDnPooooooooool03oooool2o`0003Kooooo000j
ooooo`?o000000?oooooo`000?ooool09_ooool3omV7L@Kooooo00?o/5UTooooooooool02oooool0
1?lJ03WoUD=SoiE3HonE@f<5ooooo`;ohZ>>1Oo2KVd2o`009`;odiRF00?ok]a^okUmT_niOI800_ni
OI84oi9PU0?oAbZ:1OnFHY83og17T0GoTf2B00Go:ab;oi=UV_nCII[oTfFJog3AU002oiQTU003ojed
TonoHf3o_f=P00?o@P1;0_naOY`6ojmgU@?o^7fD00?ol<ZZoo34Xoo5Tj<00_oF/;801?oAYZco[7BF
o`000?oAYZ`2ok:1W`;o00291OnXQk43oe1=/1;ooooo00?o0000ooooooooool0=?ooool003Sooooo
0_l00005ooooo`03o`000?oooooooooo01Sooooo0omg:Ed8ooooo`CofHMa1Oooool3ok1II0cooooo
1?nE@f<2oh/jHP;ooooo00?o0000on:SS_oRXhh01?o2KVd2o`009`?odiRF00?ok]a^okUmT_niOI80
0_niOI84oi9PU0?oAbZ:1OnFHY83og17T0GoTf2B00Co:ab;oi=UV_nCII[oL=6D0onHI9@00on]M9?o
_f=Pod80B`02od80B`04o`00P_naOYco=R:<ocHRS0Go[gNE0onhOI@00oo`bZ[oaI>SolFCX`03omJ`
/P03om6V[?l0003odJJ/00;o/X6O00?o6AVBo`00ROnXQk401?nXQk43oe1=/1;ooooo00?o0000oooo
ooooool0=?ooool003Gooooo0ol0000Rooooo`?oMbUM00?oTD1Tooooooooool01Oooool4omV7L@03
om2G2Ooooooooooo00;ooooo0on`FF@;ooooo`03oaX0>OnE@f?oUD=S00;oUD=S1?n;>V800ol0003o
hZ>>on:SSP04ol9^K@;o000W0ooCV9H00oo^g6ko^GfBokUmTP02okUmTPCoTV2D1?m7:XX4oiIRTPCo
L4N@1?nCH9800om>;hcoTfFJodh_S004oiQTU0;o[GBC0_m204/2ojedT`03ok5nW?lf8Xco=R:<00Go
[gNE0_nhOI@2oo3:ZP03olFCXooF/;;oe[2b00;oe[2b00?odJJ/o`000?nbPIl00_nbPIl00olI6I;o
0029o`00R@04ojR7/@CoD4f`4_ooool00ol0003oooooooooo`0cooooo`00<_ooool5o`0002;ooooo
00Co0000ogLYGOmg:EgoMbUM0_nA@6@6ooooo`CofHMa00?od9L9ooooooooool00_ooool3ok1II0_o
oooo00?o6P0ioiE3HonE@f<00_nE@f<4oh/jHP03o`000?oRXhkohZ>>00Co`Vi]0_l002L3om>HUPGo
^GfB1?nBH9@4odLZRPCoUV:B1?m`Ai04oi=PTP?oCRn<1OnHI9@00on]M9?o@P1;ojedT`02ojedT`?o
=R:<1On_MiD2okQmU003oo3:Z_n/BP3oaI>S00Goe[2b00Co0000ok:1WonbPIoo/X6O0_lI6I800ol0
08WoZ8NaojR7/@03ojR7/@?oD4f`4oooool00ol0003oooooooooo`0booooo`00<?ooool2o`0002Oo
oooo0omg:Ed4oi50I0Gooooo1?oIQg401?o@U`Woooooooooooooool5ok1II0[ooooo00?o6P0ioiE3
HonE@f<00_nE@f<4oh/jHP?ohZ>>1?o2KVd01Ol002OodI6?om>HU_oCV9Kok]a^00Go^GfB1?nBH9@4
odLZRPCoUV:B1?m`Ai04oi=PTP?oCRn<1OnHI9@5ojedT`?o=R:<1_n_MiD00onhOICol<ZZo`00Q006
omJ`/P03o`000?nbPIoo/X6O00;o/X6O00?o6AVBo`00ROnXQk401?nXQk44oe1=/1;ooooo00?o0000
ooooooooool0<_ooool000gooooo0ol0000Mooooo`?o0000:Oooool3ogLYG@CoTD1T0omc8eL00ooo
ooooahbEomV7L@03omV7L@04om2G2Oooooooooooooooo`Go/5UT00?oVD=Oooooooooool01_ooool2
oaX0>@CoUD=S1?n;>V801?m]EJGohZ>>on:SS_ojdFX3ol9^K@05o`009ooATHoo000Uom>HU_o^g6h0
1OniOI85oi9PU0?oAbZ:1?nFHY84og17T0CoTf2B0om>;h`5oiQTU0Go[GBC0olf8X`6ojmgU@04okQm
U?l008Co0024oja:00Goe[2b00?o0000ok:1WonbPIl00_nbPIl2oaTITPCoZ8Na00?oVVnPofM>XOmW
CZ400_m@CK0Cooooo`;o00002?ooool2o`0002Sooooo000>ooooo`03o`000?oooooooooo01[ooooo
0ol0000Zooooo`04o`000?mg:EgoMbUMogLYG@CoTD1T1?mc8eL00oo7S9GofHMaomV7L@02omV7L@04
om2G2Oo`W67ol9aQooooo`Go/5UT0_nI@el7ooooo`03oaX0>OnE@f?oUD=S00;oUD=S1On;>V801?m]
EJGohZ>>on:SS_ojdFX2ol9^K@;o000W0_oATHl00ooCV9Kok[6?okUmTP05okUmTPCoTV2D0om7:XX4
oiIRTPCoL4N@1?nCH983odh_S0GoV6BD1On]M9<3ocHRS0Ko[gNE00Col<ZZolnKWol008Co00241?oF
/;800onaPj?o/X6Oo`000003ok:1W`;o6AVB00?o0029ojR7/OnXQk400_nJKj04ofM>XACooooo00?o
0000ooooooooool01Oooool01?l0003oooooooooool0000Wooooo`001_ooool5o`0000?ooooo00?o
0000ooooooooool05oooool3o`0000?ooooo00?o0000ooooooooool07_ooool00onA@VOooooooooo
o`06ooooo`04o`000?mg:EgoMbUMogLYG@CoTD1T1?mc8eL00oo7S9GofHMaomV7L@02omV7L@04om2G
2Oo`W67ol9aQooooo`Go/5UT0onI@el4ooooo`03oflNE?lJ03Wo6P0i00CoUD=S1?n;>V801Ol0003o
KEFUon:SS_oRXhkon]5Z00;o`Vi]00Ko000Wom6ASooATHoodI6?onkLK_o^/Hl6okUmTPCoTV2D0om7
:XX4oiIRTPCoL4N@1?nCH984odh_S0CoV6BD1On]M9<4ocHRS0Go[gNE00Col<ZZolnKWol008Co0024
0ooF/;83ok63X`04o`000?nbPIoo/X6Ook:1W`?o6AVB00?oZ8NaoiY_X?nJKj000_nJKj04ofM>XA?o
oooo00?o0000ooooooooool01Oooool01?l0003oooooooooool0000Wooooo`003_ooool00ol0003o
ooooooooo`0Eooooo`;o00009oooool2oi52I`Oooooo1?mg:Ed3oi50I0GoLb=G00?oahbEomV7LOoI
Qg400_oIQg400oo@U`Wol9aQoo2LH@05ok1II0GoVD=O00CooooooflNE?m_7UCoKaiD0_lJ03T4oiE3
H`CoRcYR0_m]EJD2on:SSP04oo[AJ_o2KVgo`Vi]o`009`?odI6?00?olM1MonjaSoniOI801OniOI84
oi9PU0?oAbZ:1?nFHY84og17T0CoTf2B1?m>;h`4oiQTU0Go[GBC00ColL>QocHRS?lf8Xco=R:<1On_
MiD2olnKW`?o002400?oe[2bok63XonaPj<00_naPj<00ol0003o/X6Ook:1W`02ok:1W`;o6AVB1OnJ
Kj04ofM>XACooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000Wooooo`003_oo
ool00ol0003oooooooooo`0Booooo`?o0000:Oooool3oi52I`Gooooo00Co0000ogLYGOmg:EgoMbUM
1?nA@6@4og<SE`03ogiHVoo7S9GoahbE00?ofHMa00?od9L9oo2LHOo`W6401On`FF@5oiU3G`CoKaiD
0_lJ03T4oiE3H`CoRcYR0_m]EJD2on:SSP04oo[AJ_o2KVgo`Vi]o`009`?odI6?00?olM1MonjaSol0
05T01OniOI84oi9PU0?oAbZ:1?nFHY84og17T0CoTf2B1?m>;h`4oiQTU0Co[GBC0_oa`j43ocHRS0Co
[gNE00Col<ZZolnKWoo?Vioo^8JQ0_l008@5ok63X`03o`000?nbPIoo/X6O00;o/X6O0_lI6I85oiY_
X0CoIdjQ5Oooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0002Oooooo000=oooo
o`;o00004_ooool2o`0000?ooooo00?o0000ooooooooool09Oooool4oi52I`Gooooo00Co0000ogLY
GOmg:EgoMbUM1?nA@6@4og<SE`03ogiHVoo7S9GoahbE00?ofHMa00Cod9L9oo2LHOo`W67oci6B1?n`
FF@5oiU3G`?oKaiD0olJ03T4oiE3H`CoRcYR0om]EJD01?oRXhkon]5Zol9^KOo2KVd3om6AS`04oo7@
GOo^/Hook[6?o`00F@Go^GfB0_nBH9@00ooFXZ3oUWZbodLZRP02odLZRPGoUV:B0om`Ai05oi=PTP?o
CRn<1?nHI9@4ojedT`;olL>Q00?obY^WocHRS?lf8X`01?n_MiD2olnKW`;oZh6W0_l008@5ok63X`03
o`000?nbPIoo/X6O00;o/X6O0olI6I84oiY_X0CoIdjQ2_ooool00omf;FCoooooooooo`08ooooo`03
o`000?oooooooooo00?ooooo00Co0000oooooooooooo00009oooool000kooooo00?o0000oooooooo
ool03Oooool3o`0002gooooo1?nA@VL00onOCfcoooooooooo`02ooooo`CoMbUM1?nA@6@4og<SE`03
ogiHVoo7S9GoahbE00CofHMa0_o`W6400oo?TI;o/5UTok1II002ok1II0GoVD=O0om_7U@2oaX0>@Go
UD=S1?n;>V801?mcCIOoKEFUofeEYOojdFX2ogM@U`05ol9^KOoATHoodI6?om6ASooad5d00_o^/Hl0
0ol005Wo^GfBokUmTP03okUmTP03om?EG?oFXZ3oeZ:P00;oUWZb0_m7:XX5oiIRTP?oL4N@1OnCH983
odh_S0CoV6BD1?n]M9<01OoK^[OolL>Qong=]?o]cKCo=R:<00?o[gNE0oo?Vil2oj^1Y`;o00241Ona
Pj<00ol0003o/X6Ook:1W`02ok:1W`03ojamXOlI6I;o6AVB00GoVVnP1?mWCZ43oi0A2@Cooooo0omf
;F@:ooooo`;o00001Oooool2o`0002Sooooo000Kooooo`?o0000<?ooool4oi52I`05oim?K?oooooo
YTA>ooooool000001?mg:Ed4oi50I0CoLb=G00?oOURKolN<UOo7S9D01?oIQg400oo`W67oc/E2olnA
TP03ok1II0GoVD=O1?m_7U@2oaX0>@GoUD=S0on;>V801Ol0003oLdfGog==UomcCIOon]5Z00;oMe2G
00Go000Wom6ASooATHoodI6?oo7@G@03onjaS`Go^GfB00?odmELomJRX?oFXZ000_nFN[82odLZRPGo
UV:B0om`Ai05oi=PTP?oCRn<1OnHI9@2ojedT`;ofkZg00CobY^Wong=]?o]cKCo=R:<0on_MiD3olnK
W`;oZh6W00?o^8JQo`00Q?l008@01?naPj<01?l0003o/X6Ook:1WonbPIl2ojamX@;o6AVB1OnJKj04
ofM>X@CoT1490_ooool4ogH]I0cooooo00?o0000ooooooooool0;?ooool001Wooooo0_l00003oooo
o`03o`000?oooooooooo02gooooo0onA@VL3oim?K0;oYTA>00?o0000ogLYGOmg:Ed00_mg:Ed3oi50
I0CoLb=G0omnF9/00oo7S9GofHMaomV7L@02omV7L@04om2G2Oo?TI;oci6BolnATP;o/5UT1OnI@el4
oflNE0;o6P0i00?o_HRLoiE3HonE@f<00_nE@f<3oh/jHPCoLdfG0omgD9L4om6AS`04oo7@GOo^/Hoo
k[6?onjaS`Co^GfB00CodmELomJRX?oFXZ3oeZ:P0onFN[82odLZRPCoUV:B1?m`Ai04oi=PTP?oCRn<
1OnHI9@2ojedT`;ofkZg00Go@4Nbong=]?o]cKCoaYRWocHRS002ojmgU@;oci^O0on[PJL00onhQZ7o
0024o`00Q003ok63X`;o00000_nbPIl01OnRMZ;o[7fQojamXOn/OJ7o6AVB00GoVVnP1?mWCZ44oi0A
2@;ooooo1?mf;F@<ooooo`03o`000?oooooooooo02cooooo000Fooooo`?o0000;_ooool00ol0003o
ooooooooo`03ooooo`CoTD9W0onOCf`2ojI4CP04o`000?mg:EgoMbUMogLYG@CoTD1T1?mc8eL3ogiH
V`03olN<UOoIQg7ofHMa00;ofHMa00Cod9L9olnAT_o?TI;oci6B0_n`FF@5oiU3G`?oKaiD0_lJ03T0
0onDJIko_HRLokf8W002oiE3H`CoRcYR1?mcCIL3ogM@U`?odI6?0_oad5d3onjaS`Co^GfB00?odmEL
omJRX?oFXZ000_oFXZ02oiIj/P;oAbZ:1?nFHY84og17T0CoTf2B0om>;h`5oiQTU003ojedTooK^[Oo
fkZg00?o@4Nb00GokLfdolJHYolf8Xco[gNEolJHY`02olnKW`?oZh6W0_nhQZ401ol008Co0000o`00
0?l0003o/H>So`000?nbPIl00onRMZ82ojamX@;o6AVB1?nJKj04ofM>X@;oWC0f00CoT149ogmV[Omo
IZgo@`II1?mf;F@00onFJYgoooooooooo`0:ooooo`03o`000?oooooooooo02_ooooo000Eooooo`;o
0000<?ooool00oo?P7Soooooooooo`03ooooo`CoTD9W1?nOCf`00ol0003oMbUMogLYG@02om>IV0Co
TD1T1?mc8eL3ogiHV`03olN<UOoIQg7ofHMa00;ofHMa00Cod9L9olnAT_o?TI;oci6B0_n`FF@5oiU3
G`?oKaiD0_lJ03T01OnDJIko_HRLokf8W?nmR9coUD=S00CoRcYR00Co^7nFog==UomcCIOoLdfG1?mg
D9L2om6AS`03oo7@GOo^/Hook[6?00;ok[6?1?niOI85omJRX0;oUWZb0_m7:XX4oiIRTP04ok:<[_m`
Ai3oL4N@og17T0CoTf2B0om>;h`5oiQTU003ojedTooK^[OofkZg00?o@4Nb0oo6V:L01?n_MiGoaYRW
olJHYoo?Vil3oj^1Y`?o00001OnaPj<01?l0003oXWJRoj9fX_nRMZ83ojamX@03oaTIT_nJKj3oVVnP
00;oVVnP1?mWCZ42oid`=P?oOfJ]00?o@`IIogH]I?mf;F@00_mf;F@00onFJYgoooooooooo`0:oooo
o`03o`000?oooooooooo02_ooooo000Eooooo`03o`000?oooooo000002oooooo00?och1hoooooooo
ool00oooool4oi52I`CoWdm/00?o0000om>IV?oCVIP00_oCVIP01?ongX_oTD1Toi50I?nA@6@4og<S
E`?oOURK00?oahbEomV7LOoIQg400_oIQg400oo>aD;oci6BolnATP02olnATPGoVD=O1?m_7U@01olJ
03WoU6VNoiAYW_nDJIko_HRLoiaZUonhOiH01?n;>V801?nhOiKoLdfGog==UomcCIL4ogM@U`;odI6?
00GolM1MonjaSoo^/Hook[6?ocdcW003okUmTP03om?EG?oFXZ3oeZ:P00?oeZ:P0onoR9X01?m7:X[o
UV:BoiIRT_nFHY83ok:<[P;oL4N@0onCH982ol>N/P;oCRn<1OnHI9@00on]M9?ofkZgolnOY@03od17
/PKoaYRW00GoZh6Wo`000?l0003o0000oj^1Y`02okR6X@Go/H>S00CoXWJRo`000?nRMZ;oXWJR0on/
OJ400olI6I;oVVnPoiY_X003oiY_X0?oIdjQ0_nM<3H3ogmV[@03od<6FOmf;FCoMReT00;oMReT00?o
UVZMooooooooool02oooool2o`0002_ooooo000Eooooo`;o000000?oooooo`000?ooool0;?ooool0
0ol0003och1hoo:[=`04ooooo`?oTD9W1OnOCf`00ol0003odiVHom>IV002om>IV0;oo]j;0_nA@6@3
og<SE`05odhgU_mnF9_oOURKogiHVoo7S9D01?oIQg46olnATPCoVD=O1?m_7U@01_lJ03WoU6VNoiAY
W_nDJIko_HRLoiaZU`?o^7nF00?oRcYRo`000?nhOiH00omcCIL4ogM@U`;odI6?00GolM1MonjaSoo^
/Hook[6?ocdcW003okUmTP03om?EG?oFXZ3oeZ:P00?oeZ:P0onoR9X00om7:X[oUV:BoiIRTP05ok:<
[P04og17T?nCH9;oTf2BoeQH]P;o`ijb0om>;h`4oiQTU004om^j]oo?WjGocinUolnOY@?o@4Nb0oo6
V:L3o`0000CoZh6W00?o^8JQokN8Y?l008@00onaPj<01Ol007coXWJRoj9fX_l0003oXWJR00Co[7fQ
1OnJKj03ofM>X@;oWC0f0omoIZd00om31UWoMReTogH]I002ogH]I003oiIZWOooooooNa]100;oNa]1
2Oooool2o`0002_ooooo000Eooooo`05o`000?ooooooooooooooool00000;?ooool00ol0003och1h
oo:[=`03ooooo`CoTD9W1OnOCf`00ol0003odiVHom>IV002om>IV0;oo]j;00?o^h6Dog<SEomc8eL0
0_m`AY001OmF<X[oOURKogiHVomnF9_oahbE00CofHMa1_o?TI801?ombh[oVD=OoiU3GonI@el4oflN
E0CoU6VN00?o_HRLoiaZUonLJYL01OnhOiH4og==U`?oMe2G00CodI6?oo7@GOoad5go03bn0_o^/Hl0
1?lm<ico001IokUmT_niOI86omJRX0Co_hRJ00?oUV:Boi9ZXOl007H01OnbS:h00onCH9;oF5RfoeQH
]P03ol>N/P;oCRn<1?nHI9@01?oK^[OocinUolnOYOo?WjD3od17/P?o00000_o6V:L01OlY<:?oZh6W
oj^1Yon[PJOoYGnZ00;o]hRT00Go0024ok63XonaPj?o001co`00O002oj9fXP03o`000?nRMZ;o[7fQ
00?o[7fQ00Go6AVBoiY_X?nJKj3oVVnPoaLKU002ojYoY@;oIdjQ00?oWC0fogmV[OmoIZd00_moIZd3
ogH]I0;oUVZM00?oooooog/K@Omk6d400_mk6d49ooooo`03o`000?oooooooooo02Wooooo000Doooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool2oln0N004oo:[=ooooooooooo
on6?L@CoTD9W1?nOCf`00ol0003o0`Z:om>IV002om>IV0;oo]j;1?nkPI@2og16T0?oES::00?oOURK
olN<UOoIQg400ooIQg46olnATP04oog;R_o8RI3oVD=OoiU3G`?oKaiD00Co6P0ioiAYW_nDJIkoU6VN
1?nLJYL5okQoUP;ok/:U0_mcCIL3ogM@U`04om6ASooad5goejb/o`0l_P;ok[6?0_lm<i`00oniOI;o
dmELon>WU004omJRX003o`007_noR9[o_hRJ00?o_hRJ00?oY8Rgo`00M_nbS:h01?nbS:h2ok:3XP;o
F5Rf00Co`ijboiRQfonHXM_oCRn<0onHI9@5olnOY@?o00001?o6V:L01?l979co:C2Soj^1Yon[PJL2
ojEoZP?o]hRT00Co/H>SokN8Y?ngR:Co001c0onRMZ800ol0003oXWJRojamX@02ojamX@03okN9YOnJ
Kj3o01>G00;o5a^D0onZOjD00omWCZ7oZWnUogmV[@03ogmV[@?oMReT0_nFJYd00ol002WoNa]1og/K
@@02og/K@@[ooooo00?o0000ooooooooool0:?ooool001Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Wooooo`04o`000?o?P7Soch1hoo:[=`;ooooo00?ohHmaoi52IonA@VL00_nA
@VL4oim?K003o`000?l32X[odiVH00;odiVH0_ongX/4ok^1U0;oL4J@0omF<XX00omiC93oo=6GomV7
L@02omV7L@03olk5@_o?TI;oci6B00?oci6B0_ombhX2olR9T0;oKaiD00?oFCN>of=5V?mSAIP00_nD
JIh5oiaZU`Go^7nF0_o^`ZD00oncRjcoLdfGogM@U`02ogM@U`04om6ASooad5goejb/okR7X@;ok[6?
00Go00^FocdcW?niOI;oeYVCon>WU004omJRX003om>GTonoR9[o_hRJ00?o_hRJ00?oY8Rgo`00M_nb
S:h01?nbS:h3ok:3XP05omN`/Oo3W[;oek2aoiRQfom>;h`00_nHI9@3olnOY@?o00000_nFQKl01Om0
Ak;oaYRWolJHYoo6V:Oo`iV[00;o2AbL00?oZh6WojEoZ_nUOjX00_nUOjX5okN8Y003o`00Lol007co
XWJR00;oXWJR00?o0000ojamXOn/OJ400ongRJD00ol04iOo5a^DoaLKU005ojYoY@CoS7bm0omf;F@2
oiIZW@GoNa]12oooool00ol0003oooooooooo`0Wooooo`005?ooool3o`0000Gooooo00?o0000oooo
ooooool09_ooool01Ol0003och1holn0N?obZcOooooo00;ohHma0onA@VL5oim?K003o`000?l32X[o
diVH00;odiVH0_ongX/4ok^1U0;oL4J@0omF<XX2ogU<T0?ofHMa00?o^WjBolnAT_o?TI800oo?TI82
oog;RP?ob8V@0omI=hh00omlDYCoU6VNogaBU005oiaZU`Co^7nF0oo^`ZD00oncRjco`Jg6ogM@U`02
ogM@U`03om6ASooG[:co^8NQ00;o^8NQ00Ko:R>Do`0;U_lm<ico^GfBomJITooSYi@4omJRX003om>G
TonoR9[o_hRJ00;o_hRJ0_oDX:400onTR;Oo/Xb^ok:<[P02ok:<[P03oa<ESonbPj;o/X>R00Coek2a
0_nLP;<00onHI9CoW82co`000002o`0000;ocinU0onFQKl01Oo3VJ_o@4NbolJHYoo6V:Oo`iV[00;o
2AbL1OnUOjX5okN8Y003o`00Lol007coXWJR00;oXWJR00?o0000ojamXOngRJD00ongRJD2o`0CU`03
oaLKU?nZOjGoZWnU00?oZWnU1On<O;d2ogH]I0?oUVZM0omk6d42ohIJU`[ooooo00?o0000oooooooo
ool09oooool001Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03obD0
<onKBFGooooo01?ooooo0oo?P7P00oobZcOoooooon6?L@04oi52I`GoWdm/00CoeiRAo`<:R_oCVISo
diVH0_ongX/5ok^1U0;oL4J@0omF<XX2ogU<T0?ofHMa0_njOY84olnATP03oog;R_o8RI3ob8V@00;o
b8V@0omI=hh4ogaBU0CoW6ZG1?nhOiH00ooLb<Gok/:Uonk2Y@04ol6]aP03ogM@UooATHooejb/00?o
^8NQ00Go:R>Do`0;U_l02iKodmELomJIT`02on>WU0;oeZ:P0_oCUi<4okn8VP;oe:2Q00KoY8Rgo`00
M_nbS:ko/Xb^o`00OolC5Hl2ok:3XPCoek2a0_nLP;<2o`000003oib0/oo?WjGocinU00;ocinU1?nF
QKl01?o3VJ_oaYRWol>IZoo3VJ/3o`TLW0CoYGnZ1OngR:@2o`00L`CoXWJR00?o0000okN9YOngRJD0
0_ngRJD2o`0CU`;o5a^D0onZOjD2okbB[0CoS7bm0_mf;F@3oiIZW@?o50000_n6FYL00on@B7?ooooo
ooooo`08ooooo`;o00009oooool000_ooooo1Ol00004ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool01Oooool00onHBF[oooooooooo`05ooooo`04obD0<onKBFGoVdUUoi]9I@[ooooo
00?oaGAcooooooooool01Oooool01Ol0003och1holn0N?o?P7SolZ/g00;ohHma00Coi<eBoi52IonA
@VOoTD9W1?nOCf`00ol0003oeiRAoe`kT002om>IV0;oo]j;1OnkPI@3og16T0;oES::0omiC902omV7
L@;o^WjB1?o?TI800oombh[ob8V@olR9T002olR9T0?oFCN>1?mlDY@4oiaZU`Co^7nF0_oLb<D6ol6]
aP03oo7@GOnhQj7o^8NQ00;o^8NQ00Co:R>Do`06UOl02iKo00^F0ooSYi@2omJRX0;odiNC1?noR9X2
omBPX@;oY8Rg00Go/Xb^ojB8]ol007oo001ook:3XP04omN`/@?o00000onLP;<3olnOY@03om^]Z?nF
QKooUXFo00;oUXFo1?o3VJ/00ooUg<co2AbLo`TLW004ojEoZPGo]hRT00?ofKZko`00LonRMZ800onR
MZ800ongRJGo0000okN9Y@03okN9Y@;o01>G00?o5a^DojYoYOnZOjD00onlTZ`4ohal_@;oMReT0onF
JYd2od@03P?oQUZG0_n@B7<:ooooo`03o`000?oooooooooo02Gooooo000<ooooo`04o`000?oooooo
ooooo`0000Cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`?oV4UZ1Ooo
ool2obD0<`CoVdUU2Oooool2olEdL`Kooooo00?o0000oln0N?o?P7P00_o?P7P2on6?L@04onC=D_oS
Y93oTD9Woi52I`CoWdm/00Go0000omNHTOmL>i3o0`Z:om>IV002ookNR`Go^h6D0om`AY03oeHbRP;o
NDb@0_oIQg42okYnTP?oci6B0_ombhX4olR9T0?oFCN>1?mlDY@4oiaZU`?o^7nF0ooLb<D00on1X>Oo
`Jg6ol6]aP02ol6]aP03oiehZ?nhQj7o^8NQ00?o^8NQ0_lZ8i@2o`0;UP?ohjND0_oFXZ02om>GT`?o
_hRJ1?oDX:42ojB8]`;oXWVU00?o001oomN`/OoG/;400ol00002olNFY0CoW82c0oo?WjD2om^]Z0?o
UXFo0oo3VJ/3onGLc003o`TLW?nUOj[oYGnZ00;oYGnZ1?ngR:@2omVj^`04o`00Lol007coXWJRoj9f
XP;oYWfV00?o]hVUo`000?ngRJD00_ngRJD3o`0CU`03ojYoYOnlTZco_9:/00;o_9:/1On<O;d01Ol0
003oUVZMoiIZWOnFJYgoA00>00CoQUZG0_n@B7<:ooooo`03o`000?oooooooooo02Gooooo0005oooo
o`Go00000oooool00ol0003oooooooooo`03ooooo`;o00002oooool01Ol0003ooooooooooooooooo
4P0a00?oV4UZ0oooool01?mL3Too9@0cobD0<olU03<4oi]9I@Sooooo00?o4P0VolEdLoo5M7<01_oo
ool00ol0003och1holn0N002oln0N0;ohHma0ooSY905oim?K0;oeiRA00GoG3^@o`<:R_oCVISoo]j;
oc8KQ005ok^1U0?oL4J@0omF<XX2ogU<T004omV7LOnjOY;o^WjBokYnTP?oci6B0_ombhX5olR9T0;o
FCN>1?mlDY@4oiaZU`?o^7nF0ooLb<D01?n1X>Oo`Jg6ol6]a_o1[LH2oiehZ0Go^8NQ0_lZ8i@2o`0;
UPCohjND0ooCUi<3okn8VPCoe:2Q00CoY8Rgoj9iYOnRNJGoXWVU0ol00002omN`/@?oaiJT1OnLP;<0
1?o?WjGofjfXom^]Z?oK[JP4oiJ5_`05ol>IZooUg<coiMc<onGLc?nHIiL00_l979`4ojEoZP;o]hRT
0ooI^[/2o`00L`06oj9fX_nVOJKoYWfVojImY_ngRJGo00000ongRJD3o`0CU`Ko_9:/0on<O;d01?na
O9[oUVZMoiIZWOnFJYd2oj9^UPCoQUZG0_n@B7<;ooooo`03o`000?oooooooooo02Cooooo000>oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02oooool01?l0003ooooooooooolB0344
oiQ9JP03oooooomL3TooG0i?00;o9@0c1OnKBFD00onG@f;oooooooooo`04ooooo`04oa809_o5M7?o
aGAcolEdL`Gooooo00?o0000oln0N?o?P7P00oo?P7P00ooQSg7oi<eBon>TT002on>TT0GoWdm/0_oG
V942oe`kT003ookNRolb6hCo<Q^400Go^h6D0om`AY03oeHbRP;oNDb@00CofHMaokYnT_njOY;o^WjB
0oo?TI82oog;RPGob8V@0omI=hh3ogaBU0GoW6ZG0_nhOiH2omc8a@?oO6J^00Co`Jg6oiehZ?nMN:So
WGRX1_nhQj401?lZ8iCo<2JDo`0;U_l02iH2on>WU0GodiNC00?o_hRJomBPXOoDX:400ooDX:401_nR
NJGo0000o`000?l0003o7B>Ko`00O`?oek2a0oo7UZ@5oib0/`05olnOYOoK[JSofjfXom^]Z?ohkZH0
0_lBW]L01OnFQKoo`iV[onGLc?oUg<coOEBH00;oV6NG00?o2AbLojEoZ_nUOjX00_nUOjX2okN8Y0Co
fKZk00?o001cojImY_nVOJH00_nVOJH2okN9Y@04o`000?ngRJGo]hVUonkE^P;o01>G1_nlTZ`01On<
O;go/GbJok5lV_naO9[oUVZM00CoXVjF1?n6FYL2oi18L`03ogeFVOoooooooooo00Wooooo00?o0000
ooooooooool08oooool000_ooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooo
oooo00cooooo00?o0000oa80<OnHBFX01?nHBFX3oe`>C`;o9@0c1?nKBFD3oiM3HPGooooo00Co4P0V
olEdLoo5M7?oaGAc1Oooool00ol0003och1holn0N003oln0N003on6?LOoTcE;ohjB@00?ohjB@0onO
Cf`00ol0003oeiRAomNHT@03oe`kT0;o<Q^41OnkPI@3og16T0?oES::0_miC9001?oIQg7o^WjBokYn
T_njOY83olnATP03oog;R_o8RI3ob8V@00Cob8V@0omI=hh3ogaBU0GoW6ZG00Co^7nFomc8aOoLb<Go
B4R^0omlIZh5oiehZ0Go^8NQ00Co:R>Doc0VU?l`9YCo00^F0_oSYi@5om>GT`04okn8V_oDX:7oe:2Q
omBPX@?o00001?nRNJD00olM8i_oek2aomN`/@05olNFY0?oW82c1OoK[JP01_ohkZKoXg2Hoj=`V?nS
L9So4YkGonGLc0;oOEBH0_nHIiL00ol979coYGnZojEoZP02ojEoZP03okN8Y?oI^[_ofKZk00?ofKZk
00?o001cojImY_nVOJH00onVOJH2okN9Y@04o`000?o^eK[ok]FjonkE^P;o01>G1OnlTZ`01Oo`mZoo
/GbJok5lV_naO9[oKd^G00GoXVjF1?n6FYL00on@B7?oOEJIooooo`0:ooooo`;o00009?ooool000_o
oooo00Go0000ooooooooooooooooo`000003ooooo`;o00003Oooool2oa80<@GoV4UZ0_mL3Tl3obD0
<`CoVdUU0onG@f84og4ND@;o4P0V0oo5M7<4ooooo`03o`008_l0003och1h00Coch1h00?ohHmaonC=
D_oSY9000ooSY903oim?K0?oeiRA0omL>i02oc8KQ0Go^h6D0om`AY03oeHbRP;oNDb@00CofHMaokYn
T_njOY;o^WjB0oo?TI800oombh[ob8V@olR9T004olR9T0?oFCN>0omlDY@5oiaZU`03okQoU_oLb<Go
B4R^00;oB4R^0_mlIZh5oiehZ0Go^8NQ0_lZ8i@01?l`9YCo00^Fon>WU?oSYi@5om>GT`05okn8V_l0
003o0000o`000?oDX:400_o6Si/4oj9iY@;o7B>K00?oek2aolNFY?o7UZ@00oo7UZ@00onLP;?o0C>f
omFUY@04om^]Z0;on>jV0onSL9P4ogeDV0?oV6NG00Co2AbLojEoZ_nUOj[o][?F1OoI^[/00onTL9Oo
001co`00L`04ojImYP?o]hVU00?o0000onkE^_naNiP00_l04iL5okbB[0Co/GbJ00?oKd^Goj9^U_nR
KYH00onRKYH4ohIJU`03oi18LommEYWooooo00[ooooo0_l0000Tooooo`003?ooool3o`0000Cooooo
00?o0000ooooooooool03?ooool2oa80<@CoV4UZ0omL3Tl2obD0<`CoVdUU1?nG@f84og4ND@03oa80
9_o5M7?oaGAc00;oaGAc1?ooool00ol0003o_HRLoln0N004oln0N003oo:[=ooTcE;ohjB@00;ohjB@
0_oocH42oim?K0?oeiRA00?oom5koe`kT?mL>i000_lb6h@5ok^1U0?oL4J@0omF<XX3ogU<T0?o^WjB
0_o?TI82oog;RPKob8V@0omI=hh3ogaBU0GoW6ZG00?o^7nFonV[Som8B:h00_m8B:h3ogaV[PCoWGRX
1OnhQj42obXSU0;o<2JD00?o00^Fon>WU?oCUi<00_oCUi<3o`0000Coe:2Q0_o6Si/4oj9iY@;o7B>K
1_o7UZ@2o`4c]PGofjfX00?on>jVoj=`V?nSL9P00_nSL9P4ogeDV0?oV6NG00?o^T`0ojEoZ_nf/mH0
0_nf/mH3omVj^`04oi=SUonTL9OoY72Go`00L`CoYWfV0_ngRJD00oo^eK[o0000onkE^P02ok5kV003
o`0CUonlTZco_9:/00;o_9:/00Col?J_ok5lV_naO9[o/GbJ0_m_BiL5oj9^UPCoQUZG00?oT4QcogeF
VOooool03?ooool00ol0003oooooooooo`0Qooooo`004oooool00ol0003oooooooooo`0;ooooo`03
och0A_lB037oV4UZ00CoV4UZ0omL3Tl2obD0<`CoVdUU0onG@f84og4ND@;o4P0V1?o5M7<3ooooo`03
o`008_l0003o_HRL00Goch1h00?olZ/gon>TT?oSY9000_oSY902ooo=P@;oWdm/0ooGV9400ooodG_o
kK:Aoe`kT002oc8KQ0Go^h6D00?omnB4og16T?m`AY000omF<XX3ogU<T0Co^WjB00?oci6Boog;R_om
bhX01_o8RI03oeTgSP?oO5:D1OnLJYL2onV[S`03oo?@G_m8B:koB4R^00?oO6J^1?nMN:P5okR7X@03
ojinXOlZ8iCo<2JD00;o<2JD00KodiNCo`000?l0003o0000om>GToojeFl5omBPX@;oaXnK1OnRNJD2
oadSV`GoaiJT00?of?6Co`4c]_l1<kH00ooK[JP2ooS^YPCoXg2H1?mmE9P4oiQWU`Go][?F00?ofKZk
oi=SUonCHiL00_nTL9L00ol007?oYWfVojImYP03ojImYP04okN9YOo^eK[ok]Fjo`0000;o/G^H00Ko
01>GokbB[?nlTZco_9:/oo3f[omTAi/3ok5lVP?oKd^G1?nRKYH4ohIJU`03oi18LommEYWooooo00co
oooo00?o0000ooooooooool08Oooool001;ooooo0_l0000<ooooo`03och0A_lB037o4P0a00GoV4UZ
0_mL3Tl3obD0<`?oVdUU1?nG@f84og4ND@;o4P0V1Oo5M7<2ooooo`03o`008_l0003o_HRL00Goch1h
00?oi<eBon>TT?oSY9000_oSY902ooo=P@CoeiRA0_oodG/01?o]/Y7oG3^@oc8KQ?lb6h@5ok^1U003
ooOTQ?oGXYooL4J@00?oES::1?miC903okYnTP03olnAT_ombh[ob8V@00Kob8V@00?ooMAdoeTgS_mI
=hh01?mlDY@4oiaZU`;ojJ^?00?olm1NoooAN?m8B:h00omlIZh4oiehZ0Co^8NQ00CoQF>TojinXOlZ
8iCo<2JD0ol00004om>GT`03oo[EKooodGooe:2Q00;oe:2Q0oo6Si/5oj9iY@;o7B>K1?o7UZ@01?oH
lI?oaH^FojEcVol1<kH3om^]Z003ooS^Y_mL@9OoG42G00CoXg2H0ommE9P4oiQWU`04okY<0?nf/mKo
][?FokJcePCoTf>G0_nTL9L00ol007?oYWfVojImYP03ojImYP05okN9YOo^eK[ok]FjojIbV?l00000
0_naNiP01Ol04iOo_9:/okbB[?o`mZooI4NK00?o/GbJ0om_BiL4oj9^UPCoQUZG00?oT4QcogeFVOmm
EYT03Oooool00ol0003oooooooooo`0Pooooo`004_ooool00ol0003oooooooooo`0:ooooo`;o?P16
0_lB0344oiQ9JP?oG0i?0_lU03<4oi]9I@CoUd=R1?ma7U400olB02KoaGAcolEdL`04olEdL`;ooooo
00?o0000okf8W?nmR9`01Oo?P7P00ooTcE;ohjB@on>TT002on>TT0;oolf11?oGV942oooAN`;okK:A
0olb6h@3ok^1U0;omnB40_oGXYl3oeHbRPCoNDb@0onjOY800oo?TI;ooL^:olR9T006olR9T003oogD
M?o_]8ooFCN>00CoO5:D0onLJYL3onV[S`04oo?@G_oodGSoom5hodQ8[P;oO6J^1OnMN:P2okR7X@;o
QF>T00?o[WjQo`000?l000000_l`9Y@5om>GT`03oo[EKooodGooe:2Q00;oe:2Q0oo6Si/5oj9iY@;o
7B>K1?o7UZ@01?oHlI?oaH^FojEcVonULi/2om^]Z0;on>jV0_mL@9L4oj=`V0?oOEBH1?nHIiL01?mC
=Y;o][?Foe<fT_mC=Y84oi=SU`?oY72G1OnVOJH02OoCa<cok]FjonkE^_nVLYSo/G^Ho`000?naNiSo
aLiBokbB[002oo3f[`;oI4NK00?o/GbJofm;Uom_BiL00_m_BiL4oj9^UPGoQUZG00?oT4QcogeFVOoo
ool03Oooool00ol0003oooooooooo`0Oooooo`004_ooool00ol0003oooooooooo`08ooooo`05ofXN
F_ln04Ko?P16och0A_lB03401OnHBFX3oe`>C`;o9@0c00CoTFJMoi]9IOnKBFGoVdUU0onG@f84og4N
D@;o4P0V1_o5M7<00ooooooo000Ro`000002okf8W0Goch1h00?oi<eBon>TT?oSY9000_oSY902ooo=
P@CoeiRA00Coom5konfbTOo]/Y7okK:A0olb6h@3ok^1U004ooOTQ?oGXYooej:OomNRW`?oES::1?mi
C903okYnTP03oog;R_oRZIWob8V@00Gob8V@00CooMAdonndSoo_]8ooFCN>1?mlDY@2oiaZU`CojJ^?
00Colm1NoooAN?oodGSohJBB0_mlIZh5oiehZ0;o^8NQ0ol000001?n^OZ7o<2JDoc0VU?l`9Y@5om>G
T`03oo[EKooodGooe:2Q00;oe:2Q1?o6Si/3oj9iY@;og:BJ0_lM8i/3olNFY0?oaH^F0_nULi/00ooK
[JSoYG>Koea0U`02oea0U`CoXg2H0ommE9P5oiQWU`?oDcJB1?nCHiL3ojA`U`04o`00LonVOJKoYWfV
ojImYP?odlC<00Kok]FjojIbV?naNiSo0000ok5kV?o5cU82ojigU`;o/GVF00?oI4NKok5lV_m_BiL0
0om_BiL4oj9^UPGoQUZG00?oT4QcogeFVOooool03Oooool2o`0000Sooooo0_l00004ooooo`03o`00
0?oooooooooo00;ooooo0ol0000:ooooo`004_ooool3o`0000Oooooo0_mZ7UX2och0AP;o4P0a1?nH
BFX3oe`>C`;o9@0c0_nAIYd2oi]9I@CoUd=R1?ma7U42oa809PKoaGAc00?ofh=Vo`008_nmR9`00_nm
R9`5oln0N004onC=D_oSY93ohjB@on>TT0;oolf11OoGV9401OoodG_okK:AonfbTOo]/Y7om=AU00;o
<Q^40onkPI@00oogi8Coej:OomNRW`02omNRW`;oES::1?miC903okYnTP03oogMQ?oRZIWob8V@00Go
b8V@00CooMAdonndSoo_]8ookkB?1?mlDY@00onLJYOomKZ;onV[S`02onV[S`;olm1N00?oom5hon6T
T_oQY9800_oQY9801?mlIZkoWGRXoiehZ?nMN:P3o`0000?oQF>T00?o[WjQobXSU?l`9Y@00_l`9Y@3
om>GT`03oo[EKooodGooom5o00;oe:2Q1Oo6Si/2oj9iY@?og:BJ00CojK6HoadSVoo7UZCoaiJT1?o5
RiH3ojEcV`;odNOV0_mL@9L4oj=`V0CoOEBH1?nHIiL3oe<fTPCoTf>G0onTL9L00ol007?oYWfVojIm
YP04om?4c0;oYW:H0_naNiP01?l0003oaLiBojigUon^MiL3ok5iUP03ok5lV_naNIKoKd^G00;oKd^G
1OnRKYH4ohIJU`03oi18LommEYWooooo00kooooo00?o0000ooooooooool01Oooool01?l0003ooooo
ooooool00007ooooo`05o`000?ooooooooooooooool000002Oooool000_ooooo0_l00005ooooo`03
o`000?oooooooooo00Kooooo0omZ7UX2och0AP;o4P0a1?nHBFX3oe`>C`06obD0<onAIYgoTFJMoi5V
WOnULicoVdUU1?nG@f84og4ND@03oa809_n9GYWoaGAc00GoaGAc0_l00283okf8W0Goch1h1?oSY902
ooo=P@GoeiRA00Goom5konfbTOo]/Y7okK:AooCDI@02oc8KQ0;o^h6D00?omnB4omNRWooGXYl00ooG
XYl3oeHbRP?oNDb@0_njOY82oogMQ003on:YVOo8RI3ob8V@00Cob8V@00GooMAdonndSoo_]8ookkB?
olJj<P03onRZS`;omKZ;0ooYZhl00oocd5koom5hoooAN004on6TTP04on:UTol0003o0000o`0000?o
FDJQ0on5Hj@00on^OZ7o:R>Doc0VU002oc0VU0?odiNC00Gon]E_oooAOooodGoogZ6BomBPX@05olJ?
V`03oj9iYOoLY9[og:BJ00;og:BJ00CojK6HoadSVoo7UZCoaiJT1?o5RiH2ojEcV`;oo]BC00?odNOV
oea0UomL@9L01?nSL9P4ogeDV0CoV6NG0omC=Y84oi=SU`CoY72G00?oYWfVom?4c?oCa<`00ooCa<`2
ojIbV0;o/G^H00CoaLiBo`000?n^MiOo[WNG1OnaNIH4ofm;U`CoXVjF1?n6FYL00on@B7?oOEJIoooo
o`0>ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00002oooool00ol0003ooooo
ooooo`07ooooo`002_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Kooooo
0_mZ7UX3och0AP03oa80<OnHBF[oV4UZ00?oV4UZ0omL3Tl01OlU03?oTFJMoi5VWOnAIYgoYG>L00Co
Ud=R1?ma7U400olB02KoREjIohUNV@06olEdL`03o`008_l0003o_HRL00;o_HRL1?o?P7P00ooTcE;o
hjB@on>TT002on>TT0;oolf11?oGV942oooAN`?okK:A00?om=AUoc8KQ?lb6h@00_nkPI@00oogi8Co
ej:OomNRW`03omNRW`03olF=VomF<X[oES::00?oNDb@0_njOY82oogMQ003on:YVOo8RI3ob8V@00Co
b8V@00CooMAdonndSoo_]8ookkB?1?oXZXl2ooFjR`?ojJ^?00?olm1NoooAN?oodGP00_oQY983o`00
0004on:UTol44I;o116BodPnXP;oFDJQ0on5Hj@2ojinX@?o<2JD0ooCUi<01OojeFooom5oomjQT_oN
XI;oe:2Q00GoaXnK00?oimUUombTV_oLY9X00_oLY9X2onVaV003oadSVoo7UZCoaH^F00?oaH^F00Oo
YG>Koo_KN_one9?oo]BCojifU?n@GiGoG42G00CoXg2H0_oXlM42ogeDV0?oV6NG00Coc=gUoe<fT_mC
=Y;oDcJB1?nCHiL4ojA`U`GodlC<1?nVLYP00onaNiSoaLiBo`000003ojigU`Co/GVF1?m_BiL4oj9^
UPCoQUZG00?oT4QcogeFVOmmEYT03oooool00ol0003oooooooooo`04ooooo`04o`000?oooooooooo
o`0000_ooooo00?o0000ooooooooool01oooool000[ooooo00Co0000oooooooooooo00001?ooool0
0ol0003oooooooooo`05ooooo`03ocl0A_mZ7U[oJQiJ00;o?P160_lB03401?n_PZCoV4UZoiQ9J_nH
BFX3oe`>C`03obD0<ol/7XgoTFJM00;oTFJM0_nULi`3oiM3HPCoLAiA00Co4P0VohUNVOn9GYWoREjI
1Oo5M7<00ol002;o_HRLokf8W002okf8W0Coch1h00?oi<eBon>TT?oSY9000_oSY902ooo=P@CoeiRA
0_oodG/3onfbT@03ooCDIOoLWi?o<Q^400;o^h6D00?omnB4omNRWooGXYl00ooGXYl2olF=V`04oeHb
R_miC93oNDb@ogU<T0;o^WjB00CooMf4on:YVOoRZIWohZVI1Oo8RI001?ome7CokkB?onndSoo6^S83
onRZS`?omKZ;0ooYZhl00oocd5koom5ho`000002o`0000;ohJBB0_oRYI<2o`@ATP;oB3jR0_mIAZ42
ohESY0;o[WjQ0ol`9Y@3om>GT`04oo[EKooodGoogZ6BomjQTPKoaXnK1OoLY9X2onVaV003oooGPOo5
RiKoaH^F00?oaH^F0_okfgX2ookDT`;o[WJD00?oT5nEoea0UonSL9P00_nSL9P2onSad@04o`0k`?mm
E9SoV6NGoiQWU`?oc=gU0_mC=Y85oi=SU`?oY72G00Gon>f/om?4c?oCa<codlC<ocHTSP04ojIbV004
ok5kV?o5cU;o[WNGo`0000;o[WNG1?naNIH4ofm;U`CoXVjF1?n6FYL00on@B7?oOEJIogeFV@0@oooo
o`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00001oooool4o`0000[ooooo000:oooo
o`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool00_n=?fL3ooooo`04ocl0A_mZ7U[o
JQiJofXNFP;o?P1600Co4P0aojn2Y?n_PZCo[h:T0_nHBFX2oe`>C`;oWV^F00Oo;1j=oi5VWOnAIYgo
TFJMojEcW?oMoMCoPe>A00;oUd=R1?ma7U44ohUNV@CoaGAc0_l00284okf8W0Coch1h00?oi<eBolB:
U_oSY9000_oSY902ooo=P@CoeiRA00?oom5konfbTOo]/Y400_o]/Y401Oode6Gog9nCoc8KQ?nkPICo
mnB400Goej:O0oo5SI/01OmF<X[oNDb@ogU<T?miC93o^WjB00;ooMf40ooRZIT4olR9T0;ooMAd0_o_
]8l01?o6^S;oj:Z?onRZSooXZXl3ooFjR`;ojJ^?0ol000001?oodGSohJBBon6TT_oQY983on:UT`?o
116B0_m8?Z801?mIAZ7oQF>TohESY?n5Hj@2ojinX@;o<2JD0_oCUi<2oo[EK`03oooAOooNXI;ogZ6B
00GoaXnK00?oimUUombTV_oLY9X00_oLY9X3onVaV003oooGPOo5RiKoaH^F00?oaH^F00Conm]jookD
Toone9?of]AK0_n^MY@01?n@GiGoG42Goj=`V?nSL9P2onSad@;od<7<00?o03_0oiQWUoo<gND00_o<
gND00oo4_=;oDcJBoe<fTP05oi=SU`?oY72G00?on>f/oo_SYooCa<`00_lf98h4ojIbV006olG>D_oT
jH?o[WNGojigUol0003o[WNG1?naNIH01?n`NiWoKd^Gofm;Uom_BiL4oj9^UP;oW6bI0on6FYL2ogeF
VA3ooooo0_l00004ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool02oooool0
00[ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`03ohdoI`03oooooolo04Ko
?`1600;oJQiJ0oln04H00olB037o[h:Tojn2Y002ojn2Y003oiQ9J_nFIIKoUVFF00?oWV^F0_nAIYd0
1Om08H?oPe>Aoh=CTOn3Di7oUfBC00;oLAiA00?oUfBCoedlT_mM?9801?n9GYT4olEdL`03o`008_l0
003o_HRL00?o_HRL00Cok^^:oln0N?o?P7Soch1h0_o4RYH2on>TT0;oolf11OoGV9401?oodG_okK:A
onfbTOo]/Y42ooCDI@04ombOTolb6hCo^h6DooOTQ0Goej:O00Co001SolF=Voo5SI_oaHfK0omiC900
1?njOY;ooMf4oogMQ?m]H[@2on:YV@Cob8V@00GooMAdonndSoo_]8ookkB?olJj<P03onRZS`;omKZ;
0ol000000ooYZhoolm1NoooAN004on6TTP?ohZFC00?ol[ZAo`@AT_l44I800om8?Z83ohESY0;o[WjQ
0_l`9Y@2om>GT`03oo[EKooodGoo=2jK00;ogZ6B1Oo6Si/00ooWfFGog:BJombTVP02ombTVP;ojK6H
0_ooeh45olF;UP03oo_KN_one9?oo]BC00?o[WJD0_n@GiD00onSL9Soj?7AonSad@04om31c0;o03_0
00Goc=gUolBld_o4_=;oa;cBoe<fTP05oi=SU`;oY72G00Con>f/oo_SYookhjOo/GVF0_lf98h4ojIb
V003ol3KK?mI?9Go[WNG00;o[WNG00Oo0000ok5iU_naNIKo/GVFok1kVOnXb5;ojMK100;oKd^G1?nR
KYH3oia/V@04ogeFVOn6FYOoOEJIogeFVA7ooooo00?o0000ooooooooool00oooool2o`0000Sooooo
1Ol00009ooooo`002_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?oSCmW
0olo04H2ofXNFP;o?P1600?o4P0aoiQcYon_PZ@00_n_PZ@4oiIUUPCoWV^F0_m08H<3oh=CT@CoUfBC
0_mM?984ohUNV@CoaGAc00?o000Rokf8W?nmR9`00onmR9`01_o^jh[och1holn0N?o?P7So^H6GolB:
UP;ohjB@0_oocH45omNHT@05oooANoo]/Y7okK:AonfbTOode6D00ooLWi<00onkPICoiJVConFYT`03
omNRW`03o`00P?l006?oaHfK00?oaHfK00Cof:>OogU<T?njOY;ooMf40_m]H[@2on:YV@Cob8V@00Oo
oMAdonndSoo_]8ookkB?olJj<_oTZIGoj:Z?00?o00000ooYZhl00oocd5koom5hoooAN004on6TTP?o
hZFC00?ol[ZAo`@AT_l44I800om8?Z83oh=UZ004ojinXOneQjGo]HNUoc0VU0;odiNC00Con]E_ob@Q
U?ld;Y_o=2jK0_oNXI84olJ?V`;oo/R10ooLY9X2onVaV0;oomN11?o5RiH2oo_KNP;oo]BC0on^MY@3
oi1OU@03onSadOo@`Lcod<7<00;od<7<0onHIID4olBldP;oDcJB1?nCHiL00onTL9Oon>f/ooS][002
oo_SY`03oj5^UonaNIKo=RB>00CoYW:H00?oi>V3oeTlUOn^MiL00_n^MiL01Ol0003o/GVFok5iU_na
NIKo/7^I00;ojMK100?oh/>iofm;Uom_BiL00_nRKYH3oia/V@03ohKRZ_ndXlOo]:?700;oOEJI4_oo
ool00ol0003oooooooooo`0Jooooo`002oooool2o`0000Cooooo0_l00004ohdoI`;o?`160omZ7UX2
och0AP05oa80<OnHLjOo[h:Tojn2Y?n6FYH01?nFIIH4oii[UP;o@2630on3Di44oiMTT`03oehhR_mM
?9;oREjI00?oREjI0oo5M7<2o`008P06o`00=onmR9co_HRLokf8W?o^jh[o^H6G0_o?P7P00ooTcE;o
^H6GolB:UP02on>TT0;oolf11?oGV942oooAN`?okK:A00Gom=AUombOTooLWi?og9nCooOTQ002onFY
T`?oej:O00?o0020o`00Hoo5SI/00_o5SI/3omRSW`04oogMQ?m]H[CoKF:dofeR]0;ohZVI1?o8RI00
1Oome7CokkB?onndSoo_]8ooi:VE00;o000000?oj:Z?ooFjRooe^X/00ooYZhl00oocd5koom5hoooA
N004on6TTP?ohZFC0_ob^Y401?l44I;oB3jRodPnX_m8?Z83oh=UZ0Co]HNU00Co<2JDom>GToojeFoo
4AbH0_ld;Y/2omjQTP?oaXnK00?oimUUook8POoEUY400_oLY9X3onVaV0;oomN11?o5RiH01?okfg[o
o]BCookDTooJe5/3ojifU0CoT5nE0oo@`L`4oiQUU@04ogmDUOo4_=;oa;cBolBldP;oDcJB1?nCHiL0
0onTL9Oon>f/ooS][002oo_SY`03oj5^UonaNIKo=RB>00?oYW:H00?o`=]/onCYPomI?9D01?n^MiL0
0ol0003o/GVFok5iUP03onWF`@;ob::b00CoKd^Goj9^U_o8X[;oW6bI0_n6hZX4okBSa`03obQ?aOmm
EYWooooo013ooooo00?o0000ooooooooool06_ooool0017ooooo00?o0000oooooon=?fL00on=?fL2
ocl0AP;oJQiJ0oln04H2oiQcY`03ojn2Y?n6FYKoQUZF00CoUVFF1?nNJiH2od0QP`?oPe>A1?nGI9<2
oehhRP;oREjI00?oL4F>oi5PU?o5M7<00_o5M7<00ol002;o[WNFo`00=`03okf8W007onk[R_niPIOo
ch1holn0N?oTcE;o^H6GolB:UP02on>TT003ooo=POo[_ZGoeiRA00?oeiRA00?oom5konfbTOo]/Y40
0_o]/Y401?ode6Gog9nCombOTooLWi<3onFYT`?oej:O00?o0020o`00FOo5SI/00_o5SI/3omRSW`03
o`00Q_m]H[CoKF:d00;oKF:d00CohZVIolR9T?o8RI3ob8V@0_ome7@01Oo_]8oo0000o`000?l0003o
i:VE00;oj:Z?0_oe^X/3onV[S`03oo?@G_oodGSoom5h00CohJBB0_oRYI<3oo:jT@03o`@AT_m8?Z;o
B3jR00;oB3jR0_n3IJP4okF7Y@04oc0VU?oCUi?o4AbHoa4LV0;o=2jK0_oNXI83olJ?V`;oo/R100?o
eIJAombTV_oLY9X00ooY/IP00oooeh7olLeHo`00I003olF;UP04oo_KN_one9?oo]BCom[DF`?o[WJD
1?n@GiD00omM>i3od<7<oedkT004oiQUU@;oOeBE00Coa;cBogmDUOnKJ9KoDcJB0onCHiL3olG`k`;o
en7N0_nQKYL00onaNIKo=RB>ojIbV002ojIbV003onCYPomI?9GoFCbE00Co[WNG00?o/GVFo`000?n`
O9X00ooYe/401?o8ZK[ob::bolRR/_nRKYH2olRR/P03o`00P_ndXlOo]:?700?o]:?70_lXClD00onV
5`3oooooooooo`0?ooooo`03o`000?oooooooooo01Wooooo000Aooooo`03o`000?ooooooSCmW00;o
SCmW0olo04H2ofXNFP;o?P1600?o4P0aoiQcYonSLIT00on6FYH4oiIUUPCoWV^F0_m08H<3oh=CT@Co
UfBC0_mN>8X3og15SP07oi5PU?o5M7?oaGAcolEdLol002;o[WNFo`00=`02okf8W003onk[R_niPIOo
^H6G00;och1h0_niPIL2olB:UP03on>TT?oocH7ojkjU00CoeiRA00Koom5konfbTOo]/Y7okK:AooCD
IOo6TId3ombOT`CoiJVC00Coej:OomVLU?l0083o00200oo5SI/4omRSW`CoKF:d00Co01RTolR9T?o8
RI3ob8V@0ol00002onndS`;oi:VE00Co]9>dooFjRooe^X_omKZ;0ooYZhl01?ocd5koom5hooS4U?oh
a9@2on6TTP?ohZFC0oob^Y400ooPbdgo116BodPnXP02odPnXP?oPfFX1?neQjD01OojeFoo4AbHoa4L
V?lX<:Go=2jK00;ogZ6B0oo6Si/2ook8P@03omFFTOoLY9[og:BJ00?ojK6H00?oomN1oo7=F?o5R980
0oo5RiH00ookfg[oo]BCookDT`04ojifU0CoT5nE0omM>i04oiQUU@CoOeBE00CoVfRFoe<fT_nCHiOo
Tf>G0oo5l>l3omOQgP;oXFjG0_naNIH00olf98koYW:Hol3KK003oeTlU@Go[WNG00Co/GVFo`000?oY
e/7ojMK10_o8ZKX5olRR/P03o`04T?l008;o]:?700?o]:?70olXClDBooooo`;o00006Oooool0013o
oooo0_l00004ohdoI`;o?`160omZ7UX2och0AP?oXg6I0on6FYH4oiIUUPCoWV^F0_m08H<3oh=CT@Co
UfBC0_mN>8X3og15SP;oTF2D00?oaGAco`008_n^MiH00_n^MiH2okf8W003onk[R_niPIOo^H6G00;o
ch1h0_niPIL01Oo4RYKojkjUooo=POo[_ZGoj;fX00CoeiRA00Koom5konfbTOo]/Y7okK:AooCDIOo6
TId3ombOT`?oiJVC00?ofIbDomNRWooIW9@00_l00802olF=V`Gof:>O1?m_F:L01?l06:Co0000o`00
0?l00002oogDM0;okkB?00Coa[XbonBYUOoTZIGoKFZm0ooe^X/3onV[S`04oo?@G_oha9Con<BDooS4
U0;ohJBB0ooRYI<3oo:jT@03on3;COl44I;oB3jR00;oB3jR0on3IJP5okF7Y@?o4AbH00?o:32UomjQ
T_oNXI800_o6Si/01_oXZi3oo/R1ook8POmjEYcoeIJAombTVP;ojK6H0_ooeh401OoacESoaHRBolF;
U_o5RiKonm]j00;oo]BC00?of]AKojifU?n^MY@00on^MY@4oi1OU@;oGC^@1OnHIID3ogmDU@;oVfRF
00CoTf>GolG`koo5l>ooaO3_0ooGhMh3oj5^U`;o/GVF00?o=RB>ojIbV?naNIH00omI?9D5ojigU`03
ok5iU_l0003ojMK100?ob:Vj1?o8X[82okZA[005o`00P_ndXlOo]:?7okBSaon/T;T00_m=F[l2obQ?
aA7ooooo00?o0000ooooooooool06?ooool0013ooooo00?o0000oooooon=?fL00on=?fL2ocl0AP;o
JQiJ0oln04H3oj=aV@?oQUZF1?nFIIH4oii[UP;o@2630on3Di44oiMTT`;oGSR:0om`AHh2oi5PU003
olEdLol002;o[WNF00;o[WNF00?o_HRLonk[R_l006/00_niPIL2oln0N0;o^H6G00Goa8ZFon^nYOoo
cH7ojkjUoljKX`03omNHT@;oom5k0oo]/Y400oode6GoaY6MombOT`02ombOT`?oiJVC1?oIW9@00ol0
083o001SolF=V`05omRSW`03olbEVom_F:Oo000000;o00000oo8RI002_ome7CokkB?onndSoo_]8oo
a[XbonBYUOoPc53oFfk<okBC]?oe^X/4onV[S`04oooAN?oha9Con<BDohQMV0;ohJBB0ooRYI<2oo:j
T@;oh<]=00CoaHRCodPnX_m8?Z;oB3jR0on3IJP5okF7Y@05on?6^olA79So4AbHobP`YOld;Y/00_oX
Zi001_o6Si_oj:^@ook8POonb87oNUJLomFFT@?ojK6H0_ooeh401OmlDiOoaHRBolF;U_o5RiKonm]j
00;oo]BC00?of]AKojifU?n^MY@00on^MY@4oi1OU@?oGC^@1?nHIID3ogmDU@CoVfRF00CoaO3_omOQ
g_oGhMkoen7N1?nQKYL3ok5iUP03ojIbV?naNIKoFCbE00?oFCbE1?n^MiL00ooH[:[oZgVMo`000004
olRY^P;ob::b0onjTJ`00ol0193o0022okBSa`03ojb@^@?oCEZo4_ooool00ol0003oooooooooo`0G
ooooo`004?ooool00ol0003oooooohdoI`02ohdoI`?o?`160_mZ7UX2och0APCoXg6I0on6FYH4oiIU
UPCoWV^F0_m08H<3oh=CT@CoUfBC0_mN>8X3og15SP;oTF2D00?oaGAcoi5PU?n^MiH00_n^MiH00onm
R9co[WNFo`00J`02okV1U`05oln0N?oTcE;o^H6GokV1Uoo4RYH00oo[_ZD01?o>Vj?oeiRAomNHTOoG
V942oooAN`?okK:A0oo6TId00ooLWi?oiJVConFYT`02onFYT`CofIbD00?o0020o`00I?o5SI/01?oH
Xil3o`0000?oKeRW0oo8RI001?ome7CokkB?onndSoo_]8l2onBYU@;oFfk<0_ndVK`3onV[S`05oo?@
G_oUZiOon<BDooS4U?n8GIP00_oQY983on:UT`;ol[ZA00Coh<]=olF8Too5R9?o002>0_m8?Z83oh=U
Z0Co]HNU0ooSa[/00olA79So:32UobP`Y@02onR[T003olJ?VooXZi3oo/R100;oNUJL00CoeIJAonVa
V?oY/ISojK6H0_ooeh401OmlDiOoaHRBolF;U_o5RiKonm]j00;oo]BC00?o001fojifU?n^MY@00on^
MY@4oi1OU@?oGC^@1?nHIID4ogmDU@?oVfRF0_m[Ai@00ooGhMkoJdNDoj5^U`03oj5^U`Go/GVF1?mI
?9D4ojigU`;oZgVM00?ob:Vjo`000?o8ZKX00_o8ZKX00oo8X[;o^Y6/okZA[002okZA[003o`04T?l0
08;o[92i00?o[92i1?m=F[lBooooo`03o`000?oooooooooo01Kooooo000@ooooo`03o`000?n=?fOo
SCmW00;oSCmW0_lo04H3ofXNFP03och0A_mfCYGoXg6I00CoXg6I0on6FYH3oiIUUPCoWV^F0_m08H<3
oh=CT@CoUfBC0_mN>8X3og15SP;oTF2D00?o000Roi5PU?n^MiH01?n^MiH01?l006_o^H6GokV1Uoo?
P7P3okV1U`?ojkjU0_o>Vj<3omNHT@05oooANoo]/Y7okK:AonfbTOode6D00oo6TId00ooLWi?oiJVC
onFYT`02onFYT`CofIbD0_l00802omRSW`?o00000_o<UI/4ofmHY`;ob8V@0_ome7@3onndS`;oi:VE
0omKK/`01_ndVKcojJ^?onV[SooYZhoolm1NonF[U`;on<BD00?oR5fHon6TT_oQY9800ooRYI<2oo:j
T@05on3;COo5R9?oaHRColF8Tol008h00_m8?Z82oh=UZ0Co]HNU0ooSa[/00olA79So:32UobP`Y@03
onR[T0;oo/R10_mjEY`2omFFT@;ojK6H00KoomN1oo7=F?mlDiOoaHRBo`00I?o5RiH2ookDT`03om[D
Fol007Ko[WJD00Co[WJD1?n@GiD3oedkT0CoV6FE1?moE9D4oi]XUP?oJdND1OnQKYL4ok5iUP04onoJ
_?mI?9GoFCbEoeTlU@Co[WNG0_n[NId00ol006?o0000olRY^P02olRY^PKo^Y6/00?o00B@o`00P_n/
T;T00_n/T;T4odeJ_a;ooooo00?o0000ooooooooool05_ooool000Kooooo1Ol00005ooooo`03o`00
0?n=?fOoSCmW00;oSCmW0_lo04H2ofXNFP03och0A_mfCYGoMTjE00GoXg6I0on6FYH3oiIUUPCoWV^F
0_m08H<3oh=CT@CoUfBC0_mN>8X3og15SPCoTF2D1On^MiH01?l006_o^H6GokV1Uoo?P7P3okV1U`?o
jkjU0oo>Vj<2omNHT@06oooANoo]/Y7okK:AonfbTOode6Go`XnQ0_o6TId00ooLWi?oiJVConFYT`02
onFYT`CofIbD00Co0020o`000?l0003o00000ooHXil2olbEV`CoKeRW00GoCdJXolR9T?ome7CooMAd
ojN4[`02onndS`;oi:VE00CoXIO:oe]^c?mKK/co]9Vl0ooYZhl01?ocd5kon<BDooS4U?oha9@2ohQM
V0CohZFC0_ob^Y400ooPbdgoaHRColF8T`02olF8T`03o`00S_m8?Z;oPfFX00;oPfFX0_neQjD3on?6
^`;o/7ZI00?o4AbHobP`YOoXZi000_oXZi02ook8P@;oNUJL0_oEUY42onVaV007oooGPOmlDiOoO5>G
ogaCUoo5R9;oaH^FolF8TP02olF9U003o`00M_n^MYCo[WJD00?o[WJD1?n@GiD3oedkT0CoV6FE1?mo
E9D4oi]XUP?oJdND1OnQKYL4ok5iUP;okmZl0_mI?9D3ojigU`CoZgVM00Cob:Vjo`000?o8ZK[o]8n`
1_njTJ`00ol0193o0022ojb@^@03ojb@^@CoCEZo4_ooool2o`0001Kooooo0007ooooo`04o`000?oo
ooooooooo`0000Gooooo00Co0000ohdoIon=?fOoSCmW0olo04H00omZ7U[oooooogI>U@02ogI>U@Go
Xg6I0on6FYH3oiIUUPCoWV^F0_m08H<3oh=CT@CoUfBC0omN>8X2og15SPGoTF2D1?n^MiH01?l006_o
^H6GokV1Uoo?P7P3okV1U`?ojkjU0oo>Vj<2omNHT@04oooANooN/JWokK:AonfbT@;o`XnQ0_o6TId0
1?oLWi?oiJVConFYTooUZI<3omVLU0?o000000?o0020omRSWooHXil00_oHXil3olbEV`CoKeRW00?o
CdJXolR9T?ome7@00_nWQ:l2onndS`;oi:VE0oo7SIL2okBI_0;ojJ^?0onAl>43ohQMV0?ohZFC0oob
^Y400ooPbdgoaHRColF8T`02olF8T`03oeHgT?l008koPfFX00;oPfFX00?o]HNUon?6^ooSa[/00_oS
a[/3ok1jV@;o:32U0_oXZi02ook8P@;oNUJL0_oEUY400ooY/ISoomN1oooGP@03ogaCU`03olF8T_ok
fg[oaHRB00;oaHVD0_l007H4ojifU0CoT5nE0omM>i04oiQUU@CoOeBE1?nKJ9H3of]7U0GoXFjG0ona
NIH3onoJ_0;oFCbE0on^MiL4oj]iW@03o`00Hoo8ZK[o000000;o]8n`1OnjTJ`2o`04T0Co[92i0_mV
I;/2odeJ_a?ooooo00?o0000ooooooooool05?ooool000Sooooo00?o0000ooooooooool01Oooool0
1?l0003oSCmWohdoIon=?fL2ocl0AP04ofXNF_ooooooooooooooo`;oMTjE1OnSLIT3ohIJUP?oUVFF
1?nNJiH2od0QP`?oPe>A1?nGI9<3oehhRP;oL4F>1OnAH9@3ojigUP05ojc8D?l006_o^H6GokV1Uoo?
P7P00_niPIL3on^nY@CocY^S00CoeiRAoooANongN03og[6Y0_o]/Y42ol:?X@03olJAWOo^jHKog9nC
00?oiJVC0ol00002omVLU003ooo>Q_l0083o001T00?of:>O1?o<UI/3ofmHY`03odm6Z?o8RI3ooMAd
00;oYhB_00CokkB?olJj<_nWQ:ooh<a@1?o7SIL01?ndVKcojJ^?onV[SonAl>42ofe9U`?oR5fH0ooR
YI<3oo:jT@03on3;COo5R9?oaHRC00;oaHRC0_mF=i03ogJFi005okF7YOoSa[_ohlJkon?6^onAI9T0
0on`NYT2obP`Y@;oj:^@0_onb842ogYFW0;oeIJA00?oo/i_oooGPOmlDiL00omlDiL3olF8TP;oaHVD
0_l007H4ojifU0CoT5nE0omM>i04oiQUU@CoOeBE1?nKJ9H3of]7U0GoXFjG0onaNIH01Ol06JKokmZl
om:b^OoB/[WoFCbE00?o[WNG1On[NId2okB?/003o`000?ndSk3o^Y6/00Co^Y6/00?oYgJMo`04T?l0
08800_n/T;T2oj^:/PCoIVBk0oooool2oh@lK@gooooo00?o0000ooooooooool05?ooool000Wooooo
00?o0000ooooooooool00oooool00ol0003oSCmWohdoI`02ohdoI`;o?`161?ooool2ogI>U@GoXg6I
0on6FYH3oiIUUPCoWV^F0_m08H<3oh=CT@CoUfBC0omN>8X3og15SPCoTF2D0on^MiH2onJjZ003o`00
JoniPIOo^H6G00;o^H6G00CoglFnon^nYOo[_ZGo_iF/0oo>Vj<01?oGV97oom5kojAmZOo2Sj42onfb
T@;o`XnQ00CoaY6MonkYQ_oUZI?oiJVC0_l00004omVLU0;oolj600?o0020o`00I?oHXil00_oHXil4
olbEV`CoKeRW00?ob8V@odm6Z?nWQ:l01?nWQ:l5olN=U`03ohMNVooYZhoojJ^?00?oKDVG0on8GIP3
on:UT`?ol[ZA1Oo5R9<3oeHgT0?oMYKT0_oSa[/2oi5TV@Co/7ZI00?o:32UonR[T?oXZi000_onb843
ogYFW003omFFTOoncVooO5BH00CoO5>G0oo5R982olF9U0;o001f1?n^MY@4oi1OU@?oGC^@1?nHIID4
ogmDU@CoVfRF0om[Ai@5oj5^U`?o/GVF00Co/X6Pom:b^OoB/[Wod[:i0_mI?9D00on^MiOoWg:Ooimb
W`04oj]iW@;o]8n`00?o0000okB?/?njTJ`00onjTJ`2ojMfW@;o00B@00Co[92ioj^:/_n[R[;oZhZb
1?mVI;/2oi8]@@?oQ3a]0_mm=fd<ooooo`03o`000?oooooooooo01?ooooo0006ooooo`05o`000?oo
ooooooooooooool000001?ooool01?l0003oSCmWohdoIon=?fL3ocl0APCooooo0omfCYD4oj=aV@?o
QUZF0onFIIH3oii[UP03oiEm]_m08H?o@26300?oPe>A1?nGI9<3oehhRP?oL4F>1?nAH9@3ojigUP03
ol^___oV^ZSo001[00?o^H6G00Go[L94omo5__noUJcojkjUoknE[003oljKX`03omNHTOoodG_oY7fY
00Go`XnQ00CoaY6Mo`000?l0003o00000_oUZI<4omVLU0;oolj600ConlJ<o`00I?oHXioof:>O1Oo<
UI/01_oVfVOonmj0omjVV_m_F:OooMAdodm6Z0CoYhB_1_o7SIL2oooGS`04oo?@G_m]BIOoKDVGofe9
U`?oR5fH00?o_XBFon:UTooRYI<00_ob^Y400ooPbdgoaHRColF8T`03olF8T`?oESN@00GoLdfFogJF
i?mfU^CoMYKTon?6^`02oi5TV@Co/7ZI00CokNR4obP`YOonb87oo/R11?mjEY`00ooEUY7oo/i_ogaD
V004ogaCU`?oaHRB0oo5RI@00ol007Ko[WJDojifU003ojifU0CoT5nE0_mM>i04oiQUU@CoOeBE1?nK
J9H3of]7U0GoXFjG0_naNIH2ok:1X006o`0IY_oB/[Wod[:iom:b^OmI?9Go[WNG0_nOLYl4oj]iW@05
o`00HondSk3o]8n`o`000?ndSk000_njTJ`4ojMfW@03o`04T?n[R[;oZhZb00;oZhZb1?mVI;/2oi8]
@@?oQ3a]0_mm=fd=ooooo`03o`000?oooooooooo01;ooooo0006ooooo`05o`000?oooooooooooooo
ool000001?ooool01?l0003oSCmWohdoIon=?fL2ocl0APGooooo0omfCYD4oj=aV@?oQUZF0onFIIH2
oii[UP;oUGff00?o[XV_od0QPon3Di400_n3Di44oiMTT`?oGSR:0om`AHh4oi5PU0;o[WNF0oo;[kh0
1_l006_o^H6GokV1UoniPIOo]<?Uomo5_P?o_iF/0oo>Vj<00ooGV97oY7fYojAmZ@03ol:?X@?o0000
00?oloBdonFYTooUZI<00_oUZI<4omVLU0;oolj600ConlJ<o`00P?oHXioof:>O1Oo<UI/2oo_NP0?o
gZJJ00Goik2Jodm6Z?nWQ:ooYhB_ookBS`06olN=U`;oomN?00Con<ZKofe9Uom]BIOoKDVG0on8GIP0
0onnQ9KohZFCon:UT`02oo:jT@03on3;COo5R9?oaHRC00?oaHRC00?on<6?oeHgT?mF=i001?mcCIH3
oi5TV@Co/7ZI00CokNR4oo[WT?onb87oo/R10_ncO9L2ogYFW003ook>KomlE9SoO5BH00CoO5>G0oo5
R983olF9U003o`00M_n^MYCo[WJD00?o[WJD1?n@GiD3oedkT0?oV6FE1?moE9D4oi]XUPCoJdND1?nQ
KYL2ok5iUP;o/X6P00KoF4>Nom:b^OoB/[Wod[:ioimbWon^MiL2oimbW`CoZgVM00Ko9Af@okB?/?nd
Sk3o]8n`o`000?njTJ`5ojMfW@03o`04T?n[R[;oZhZb00?oZhZb0omVI;/2oi8]@@06ohaXY?n4?6go
Q3a]oiQ_Xomm=fgoXH:b3?ooool2o`0001?ooooo0007ooooo`?o00001Oooool2o`0000;oSCmW00?o
?`16ooooooooool01?ooool3ogI>U@CoXg6I0on6FYH3oiIUUP06oii[U_nEOKKoUGffoiEm]_n^RJoo
@2630on3Di44oiMTT`?oGSR:0om`AHh4oi5PU0;o[WNF0oo;[kh01Ol006_o^H6GokV1Uon]`TCoXXJe
00Go_iF/00?ocY^SohE][ooGV9400_nTOJT3o`0000;o`XnQ00?oloBdokV;YOndPj400_oUZI<5omVL
U0;oolj600ConlJ<o`00P?l006Cof:>O1Oo<UI/00ookgX3ogZJJomjVVP02omjVVP;oik2J00?oYhB_
ookBSoondXl01_o7SIL01?ooehoon<ZKooS:VoojhH@2ofe9U`CoR5fH0_oRYI<2oo:jT@03on3;COo5
R9?oaHRC00?oaHRC00Con<6?oeHgT?mF=i3oESN@0omcCIH3oi5TV@?o/7ZI00?okNR4oo[WT?ojii00
0_nQKiT4ok=lU`03ook>KomlE9SoO5BH00CoO5>G0oo5R983olF9U003o`00M_n^MYCo[WJD00?o[WJD
1?n@GiD3oedkT0?oV6FE1?moE9D5oi]XUP?oJdND1OnQKYL01onaNIKo/X6Pok:1X?nbPJ3oF4>Nom:b
^OmH@ih01?nOLYl5oj]iW@Co]8n`00?o0000oii`WOnWMYd01?nWMYd00ol0193oZhZboj^:/P02oj^:
/PCoIVBk00OoTRe1ohaXY?n4?6goQ3a]oiQ_Xomm=fgoXH:b00gooooo00?o0000ooooooooool04Ooo
ool000oooooo00Co0000oooooooooooo?`161oooool3ogI>U@CoXg6I0on6FYH2oiIUUP03oooooom>
EkcoUGff00;oUGff00?o[XV_od0QPon3Di400_n3Di44oiMTT`?oGSR:0om`AHh4oi5PU003ojigU_o;
[kkobjnn00;objnn00?o001[okV1UoniPIL00_nRQ[D5oknE[003oljKXon5KJoo000000;o00001?o2
Sj401?nWcEco^H^UokV;YOndPj42onFYT`GofIbD0_oocXH00ookaXcogZ:Co`00I005olbEV`03onKJ
IookgX3ogZJJ00?ogZJJ0ooW/9X00oondXooBS>DodXcU004olN=U`;oomN?0_ohbY/00oojhHCo/GVF
ofe9U`04ohQMV0;ohZFC0_ob^Y400oo]^YcoaHRColF8T`03olF8T`;on<6?0_mF=i03og==UPCoTFBI
0_n`NYT00oo]j8Con^N@oj5_V@02oj5_V@Co/gbG1?mlE9P3ogaCU`;oaHRB00GoKD^HolF9U?o5RICo
aHVDo`00MP05ojifU0CoT5nE0omM>i04oiQUU@?oOeBE1OnKJ9H3of]7U0GoXFjG00Co/GVFok:1X?nb
PJ3o/X6P0omH@ih4oimbW`GoZgVM00Ko001SokB?/?ndSk3oWW2Mo`000?nNL9d5ojMfW@03o`04T?n[
R[;oZhZb00;oZhZb0_nWN9l2ofIT^`;oS6RT0_n4?6d00onHKj?oOCM]oj62/P03og<9:P[ooooo00?o
0000ooooooooool04Oooool000oooooo00?o0000ooooooooool02?ooool3ogI>U@CoXg6I0_ooool0
0onhW[koooooooooo`02ooooo`05odiG_?nEOKKoUGffoiEm]_m08H<00on3Di43oiMTT`;o^Y>^0_mN
>8X3og15SPCoTF2D00Co[WNFol^___o;[kkobjnn0_n<MkL2okV1U`;oXXJe1?noUJ`3o`000004og5R
/_n5KJooY7fYokMh00?o`XnQ0oniRjD00ondPj7oiJVConFYT`04omVLU0?oolj600?onlJ<omjRTol0
06@01Oo<UI/2oo_NP0CogZJJ0ooW/9X00oondXooBS>DodXcU004olN=U`;oomN?0_ohbY/00oojhHCo
/GVFofe9U`04ohQMV005okj4U_ob^Y7ol[ZAoo:jTOo]^Y`01?o5R9<3ooS1S`03ooFmSomF=i3oLdfF
00;oLdfF1?nAI9T2ok1jV@03ongXQ?nQKiWoXFnI00;oXFnI1?ncO9L01?neP9[oO5BHogaDV?mlE9P3
ogaCU`;oaHRB00GoKD^HolF9U?o5RICoaHVDo`00MP05ojifU0?o[gRG00CoTF>IoedkT?mM>i3oGC^@
1?nHIID3ogmDU@GoVfRF0om[Ai@5oj5^U`Co/X6P0omH@ih4oimbW`GoZgVM00?o9Af@okB?/?nNL9d0
0_nNL9d00ol0003oYgJMojMfW@03ojMfW@03oddjVon[R[;oZhZb00;oZhZb0_nWN9l4ohaXY0;oQ3a]
00?oV6nSogdgKOnQP[800omc2BX;ooooo`03o`000?oooooooooo013ooooo000>ooooo`;o00002_oo
ool3ogI>U@?oXg6I2?ooool01On@JZ;oUGffoiEm]_nEOKKo[XV_00?oPe>A0_nGI9<2oh=^/`;o^Y>^
00CoGSR:og15S_m`AHkoL4F>1?nAH9@00on^MiKobjnnol^__P03ohag]`03okV1UonRQ[GoXXJe00;o
XXJe0ol000000onoUJcoHEjiog5R/P02og5R/P05ojAmZOngN03o`XnQol:?XOnWcE`00oniRjD00ond
Pj7oiJVConFYT`04omVLU0;oolj60_okaX`00ooNXY?o001TolbEV`04olbEV`03oo_NP?l02iOo001b
00;ogZJJ0ooW/9X2ookBS`;oBS>D1?o7SIL01?ooehoon<ZKooS:VoojhH@3ok5iUPCoR5fH00Ko_XBF
oo:jTOob^Y7ol[ZAonfjW?l003D3olF8T`;on<6?0_oe_Hl00omF=i3oLdfFog==UP02og==UP?oTFBI
00?o/7ZIongXQ?n=H9T01?nQKiT4ok=lU`04ojAdWOneP9[oO5BHogaDV0?oO5>G0_o5R9801Om]BiSo
aHVDolF9U?o5RICo001f00Go[WJD0on_N9L2oi5SV@;oGC^@1?nHIID4ogmDU@CoVfRF0om[Ai@5oj5^
U`Co/X6P1?mH@ih3oimbW`GoZgVM0olU7I03oii`W@03o`000?nWMYgoYgJM00;oYgJM00CoCCZKo`04
T?n[R[;oZhZb1?nWN9l4ohaXY003oh@lKOnHKj?oOCM]00;oXH:b00?oA@00oh]YYon;JJL02oooool0
0ol0003oooooooooo`06ooooo`?o00001_ooool000kooooo00?o0000ooooooooool02oooool00omf
CYGoXg6Ioj=aV@09ooooo`?oS7Fd00?o92jToePoVOn3Di400_n3Di401?nGI9?oPfjcoh=^/on3K[<3
okZC[P?oL4F>0onAH9@2ofefb`03ol^___o;VjKobi^V00;oS7Ng00?o^H6Goj:6]Ol000000_l00003
oknE[0?oHEji0_maH[82oiaj[0;o`XnQ1?niRjD2okB3X@03onFYTooIW9CofIbD00;ofIbD0_oocXH2
oo_6S0;ogZ:C1Oo<UI/2ooRoS003o`00F_oNYY[ogZJJ00?oik2J0_ondXl2odXcU0?oahfG0_ooehl2
ooS:V`04oo[QQ?naNIKo/GVFok5iUP;oMdfC00?o066cohQMV?oea9X00oob^Y400oo]^Yco000eolF8
T`02olF8T`;on<6?0_oe_Hl00ooodGOoLdfFog==UP02og==UP?oTFBI00?o/7ZIohePVOn=H9T01?nQ
KiT4ok=lU`04ojAdWOneP9[ob>C[ogaDV0?oO5>G0_o5R982ofe;V003olF9U?onc8Koo/b600Co[WJD
1?n_N9L2oi5SV@;oGC^@1?nHIID4ogmDU@CoVfRF0om[Ai@5oj5^U`Co/X6P00CoXW:MoeQ3W_mH@iko
F4>N1?nOLYl4oj]iW@03ojEcVolU7I3o9Af@00?oWW2M00?o0000ojMfWOnWMYd00_nWMYd2oddjV`03
oj^:/_m=>Y_oYgRO00?oYgRO1?n<J:@00on4?6goV6nSogdgK@02oj62/P03odD00?n;JJOoRfVW00_o
oooo0_l00008ooooo`03o`000?oooooooooo00Gooooo000>ooooo`03o`000?oooooooooo00cooooo
00?oXg6Iooooooooool02?ooool4ohae]003ob@^Y?mH?iWoQV6O00;oQV6O0on3K[<4okZC[P04oiI_
YOm`AHkoTF2Doi5PU0CofkB`0_o;VjH01?n<MkOo0000o`000?l00003oj:6]@;o_iF/0_oAYJ/2of5N
^@;oLF:b0_nLNZ`00oo2Sj7oW7Z/okV;Y@03okV;Y@03o`007OndPj7ofIbD00CofIbD0_oocXH01Ook
aXcogZ:ComjRTooNXY?o001T00?oc9FK00Conmj0ooRoS?o/cECof9ZB0_oNYYX3onN`VP;oo]:?0_m:
<i@3olN=U`;oomN?0_ohbY/01?ojhHCo/GVFok5iU_naNIH2ogM=T`;o9FcM00Ko066cooG4V_ob^Y7o
h<]=onfjW?l003D3olF8T`;on<6?0_oe_Hl2oooAM`03olN:T_mcCIKoLdfF00?oTFBI0on=H9T4oj5_
V@?o/gbG0_nTM9d00oneP9[ob>C[ojNOcP04ogaCU`04olF8T_m]BiSoKD^HolF9U0;oo/b61?n^MY@4
ojmhU`;ooN6K00?oj;ZToedkT?nHIID00onHIID4ogmDU@CoVfRF00?oklV[of]7U?m[Ai@01?nQKYL2
oiIaYP;o/X6P0onRLYd2oeQ3WPCoWg:O0on[NId2ojEcV`;o9Af@1?nNL9d00ol0003oYgJMojMfW@02
ojMfW@?oCCZK1?nWN9l4ohaXY004oh@lKOnHKj?oV6nSokJ7X`CoRfVW3?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Gooooo000>ooooo`;o00006?ooool01?l?2XGoS7Fdohae]?n<
MK@2ob@^Y0?oQV6O1?n3K[<2okZC[P?oUVnU00?oTF2Dok^<Y?oK];000_oK];02ol^KYP;o00000on<
MkL3oj:6]@04oknE[?oAYJ_odJF[om6UZ`;oHEji0omaH[800onLNZco`XnQoiaj[004okV;Y@03o`00
7OndPj7ofIbD00CofIbD0_oocXH01OokaXcogZ:ComjRTooNXY?o001T00?oc9FK0_oh_h`01?o/cECo
f9ZBo`00L_oNYYX3onN`VP04ookBSom:<iCoBS>DodXcU0?oahfG00CoomN?ooS:VoohbY_on^641Ona
NIH2ogM=T`?o9FcM0oo]^Y`01?l003GoaHRColF8Too5R9<2ooS1S`;omKf?0_oodGL2olN:TP04og==
U_nAI9WoTFBIogE>UP?oSF2I1?nQKiT3ok=lU`03ojAdWOljNN;oYio>00?oYio>0omlDiL01?o5R9;o
_YB/ofe;V?o5RI@2ook<QP04o`00M_n^MYCo[WJDojifU0Co[gRG0_omhI/00ooX^ZCoGC^@oiQUU@03
oiQUU@CoOeBE0onKJ9H2ono9Z`03ol2=X?m[AiCoJdND00;oXFjG0onFLJH00onbPJ3oRF:Ooj9bW@03
oj9bW@03oeQ3W_nOLYooWg:O00;oWg:O0_n[NId3ojEcV`;o9Af@1?nNL9d00onWMYgo0000ojMfW@02
ojMfW@?oCCZK1?nWN9l4ohaXY003oh@lKOnHKj?oV6nS00;o]XNS0on;JJL=ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool01Oooool000kooooo00?o0000ooooooooool05oooool01?l?
2XGoS7Fdohae]?n<MK@2ob@^Y0?oRgBd00Ko]Y:aoh=^/on3K[?oPfjcokZC[_nfT[43oiI_Y@04okBN
`_oK];3ofkB`om^d/0?o00000_o;VjH3ohag]`;oXXJe1OoAYJ/00ooag;_oHEjiog5R/P02og5R/P?o
W7Z/1OniRjD00ondPj7ofIbDomVLU002omVLU0?oolj600?onlJ<omjRTooNXY<00_oNXY<3olbEV`;o
n;n<00?ok<eDomRJT_oHVY801?oW/9X01?ondXooolmhodXcU?m:<i@3olN=U`04oooGSoohbY_on<ZK
oo[QQ0Go/GVF0omgCI<3obE/g@;okKZL00Co000eolF8Too5R9?oaHRC0_oh`Hl2ooFmS`06oooAMoo7
RY;oahZBolN:T_meCYKoTFBI0_meCYH3ohePV@GoXFnI0_ncO9L00om>Fl3o>WWRojNOcP03ojNOcP0:
olnX/OmlDiOoO5>GolF8T_nnU:coKD^HolF9U?onc8Kok[BDo`00MP;o[WJD00?oijjEojmhUon_N9L0
0_n_N9L00oomhI_oj;ZTonRjY002oedkT0?oV6FE0_nRL9T2ogmDU@;oVfRF0oo_bJ/2ol2=X003of]7
U?nQKYOoXFjG00?oUW6V00?o/X6PohURWonRLYd00onRLYd00omH@ikoWg:OoimbW`02oimbW`03oj]i
WOnGJIcoYG>K00?oYG>K00?o9Af@oii`WOnNL9d00_nNL9d2ojMfW@03o`000?nWMYgoYgJM00?oCCZK
1OnWN9l4ohaXY0;oV6nS0_nfQj<4oh]YY`cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`05ooooo`001_ooool3o`0000Gooooo00?o0000ooooooooool05oooool00ol?2XGoS7Fdohae
]002ohae]003ob@^Y?n;M;CoRgBd00;oRgBd0_n3K[<3okJB/@04oiI_YOndW/;o]9k2okBN`P?o0000
1Oo;VjH2ohag]`;o`IZ`1_oAYJ/2oo7L^`03of5N^OmaH[;oLF:b00?oW7Z/1?niRjD00ooE]KWo]8>Q
omVLU003omVLU0;oolj60_okaX`4omjRT`;oc9FK00Coi]YWooRoS?oh_hcok<eD0_oHVY83onN`VP;o
o]:?0_oocgP2odXcU003olN=UoooehooomN?00;on<ZK00?on^64ok5iU_naNIH00onaNIH3ogM=T`;o
J4:@00CoQ5NDobE/gOoofH[oQ5ND0oo5R9<2ooS1S`;omKf?00Coom5golN:T_o7RY;oahZB1?meCYH3
ohePV@GoXFnI00Go/gbGom>GUOl05JCoCU_0ocYihP04ojNOcP05olnX/OmlDiOo_YB/okjD[?l02i@0
0_onc8H01Oo^]9Co001fojifU?n^MYCoijjE00?o[gRG0_omhI/3onRjY004oedkT?nHIIGoV6FEoiQU
U@;oXW2I00Co0000ooSU/OnKJ9KomMJ]0oo_bJ/3ol2=X004oj5^Uon`OYgo/7jMok1nW@?oRF:O1OnR
LYd00omH@ikoWg:OoimbW`03oiMYW0CoYG>K0_lU7I03oii`W@;oYgJM00Co0000ojMfWOnWMYgo[GZK
0_m=>Y/5ojMhW`CoS6RT00CoV6nSokJ7XonfQj?o]XNS1?n;JJL00onJ@U_oooooooooo`0:ooooo`03
o`000?oooooooooo00?ooooo0_l00007ooooo`001oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo01Oooooo0_l?2XD3ohae]0;o92jT0on;M;@5okJB/@04okBN`_l0003o0000o`0000;o
]9k200?ofkB`ol^KY_o;VjH00oo;VjH4ol6J/003olJT]ooAYJ_odJF[00;odJF[0ooag;/00onRL9Wo
LF:bog5R/P04oiaj[0;o^H^U0_oE]KT2okB3X@?ofIbD0_oocXH2oo_6S0CogZ:C0_o<UI/00ooUZI;o
n;n<ooRoS004omRJTP;oik2J0_ondXl01_oocgSocI2CodXcU?m:<iCoahfGoooGS`;on<ZK00?on^64
od`^RonaNIH01?naNIH3ogM=T`;oJ4:@1?n4Ei@2olF8T`?on<6?0_oe_Hl00ooodGOoahZBolN:TP02
olN:TP?oMDjF0on=H9T5oj5_V@03ok=lUooCUiGo01FT00;oCU_00_nWWlh2oi=n^PGo_YB/00Go00^D
o`00T?o^]9Cok[BDojifU002onN^U@?o[gRG0_omhI/3onRjY004oedkT?nHIIGoV6FEoeHjU0;oXW2I
00Cock>nokJ7XonfQj?omMJ]0_o_bJ/00omSDJOo`8fPol2=X002ol2=X0?o/7jM0on9HYl5oj9bW@03
oe]1VOnOLYooUfVL00CoUfVL1?nULi/01?lU7I3oWW2Moii`WOnNL9d3ojMfW@03o`000?n]NY_o[GZK
00;oCCZK1OnWN9l2ok1nWP03oiQ_XomKCZWo]XNS00?o]XNS1?n;JJL00onJ@U_oooooooooo`09oooo
o`?o00001Oooool00ol0003oooooooooo`05ooooo`001?ooool5o`0000Cooooo0_l0000Jooooo`04
o`l:QOn<MKCoS7FdohQRX0;o92jT0on;M;@3okJB/@?o00001OndW/86ol^KYP?o`IZ`0_o6Y;L3om6U
Z`?olMbk00GoU6JJoj9`VOnRL9Wo02RUog5R/P03oiaj[006okV;YOoE]KWoeKFiomFe^OndPj7o^HZT
0ooIW9@2ooo>QP03oo_6S?oNXY?ogZ:C00;ogZ:C00KoiJVBo`00I?o<UI_oiJVBooRoS?o/cE@4omRJ
TP;oik2J00?oo]:?oo_4QooocgP00_o=T9<00om:<iCoahfGoooGS`02ofI2TP;oC2j;1OnaNIH3ogM=
T`;oJ4:@1?n4Ei@2olF8T`;on<6?0ooe_Hl00ooodGOoahZBolN:TP02olN:TP?oMDjF0on=H9T5oj5_
V@03ok=lUooCUiGodiNE00;oCU_01?nCO[X5okjD[005o`0;U?l008Ko002@onjdU?n^MY@00_oW[YD0
1?l006[o[gRGojmhUoomhI/3onRjY0;oiKBQ00GoV6FEolnc__o?/kkoXW2Iolnc_P04okJ7X`;oklV[
00CoHe6Wol2=X?o0SJ3o`8fP1?n`OYd4ohURW`CoXW:M0omK@IT4oiMYW0CoYG>K00?o9Af@oii`WOnN
L9d00_nNL9d2ojMfW@05ojejVol0003o[GZKojejVom=>Y/01OnWN9l2ok1nWP;oFdjY1OnfQj<3oh]Y
Y`03oiY2FomPI<3ooooo00Kooooo0ol00002ooooo`03o`000?oooooooooo00_ooooo0004ooooo`04
o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool06Oooool01_l?2XGoR6:PohQRX?n8HZ3o
EcnJob@^Y0?oRgBd0ol00002ojn2Y003o`/BT?ndW/;o]9k200;o]9k200?o[XN[ol^KY_o;VjH00oo;
VjH00ol_@;?o`IZ`ol6J/003olJT]`?odJF[0_oag;/2oiAVVP?oXW2I00Co02RUoiaj[?nLNZcoW:_Q
1?oE]KT2okV:Y0?ofIbD0_oocXH00ookaXcogZ:ComjRT`02omjRT`;oiJVB00Coc9FKooRoS?oh_hco
k<eD1?oHVY82onN`VP03ookBSooocgSoolmh00?ocI2C00CoomN?ofI2T_mV@Y;oIT:B0_m<;X/5ok5i
UP?oMdfC0_mX@Y04ohAGU0;oaHRC0_oh`Hl2ooFmS`;oom5g1?o7RY83ogE>UP?oSF2I1OnQKiT01?ol
d6codiNEom>GUOmD?IX2odiK`0CoTgjj1?nnU:`2o`0;U003o`00T?o^]9Co[WJD00;oijjE00Co001Z
ojmhUoomhI_ooN6K0ooX^Z@3onFdX@04onFaW_o?/kkock>nolnFV@Co]XNS00?o/7nPono9ZomSDJL0
0oo0SJ04ok1nW@CoRF:O0onRLYd2oj1eXP;oFd6I1?nGJI`4ojEcV`03obDMT?nNL9goWW2M00;oWW2M
0_nWMYd01?nRLYco[GZKo`000?n]NY/2oddjV`?oYgRO0on`OYh2oe]>Z@Go]XNS0on;JJL00onJ@U_o
H6C0ooooo`03ooooo`?o00001Oooool00ol0003oooooooooo`0;ooooo`001Oooool00ol0003ooooo
o`000005ooooo`03o`000?oooooooooo01Wooooo00Co3`Z5ohQRX?n8HZ3oR6:P0_mG?iX3o`000003
oh]d]?nfT[7o[h:T00?o[h:T0ondW/83ojj7Z`Cobi^V00?o03Jjol6J/?o6Y;L01?o6Y;L00ooAYJ_o
lMbkoo7L^`03oiAVVPCoXW2I1?nLZn43omFe^@;o^HZT0_oIW9@3ooo>QP03oo_6S?oNXY?ogZ:C00;o
gZ:C0ooUZI82ooRoS003onc=E?oHVY;of9ZB00;of9ZB00?oo/R3ookBSooka8L00_oocgP4olf@T`?o
IT:B0_m<;X/5ok5iUP?oMdfC0omX@Y03ohAGU0;oaHRC0_oh`Hl2ooFmS`;oom5g1?o7RY84ogE>UP?o
SF2I1?nQKiT01?old6codiNEom>GUOmD?IX2odiK`0CoTgjj1?nnU:`01?nWMigo00^Do`00T?l00903
onN^U@04onBYUOn_N9OooN6KoogQV`?oj;ZT0_oU]:42onFaWP03olnc__o?UYWociJI00Co]XNS0_n`
Oj02of=AY`03ol2=X?mXCZ3o/7jM00?o/7jM0_n]Oj<2ohURW`;oXW:M0onPMJ82oe]1V@CoUfVL1?nU
Li/00olh:I?oWW2Moii`W@02oii`W@05ojMfWOnRLYcoXW:LojejVol000000_n]NY/00om=>Y_oYgRO
ojMhW`03ok1nWP03olVJY_mKCZWoFdjY00Go]XNS00Go`jBkojAjYOn;JJOoRfVWof1T`004o`0000So
oooo00?o0000ooooooooool02oooool000Kooooo0_l00005ooooo`;o00006_ooool00ol?2XGoR6:P
ohQRX003o`000004oeLoV_n;M;CoRgBdoi1ZX`Go[h:T00?o2a:@okBN`_n^Qj/00on^Qj/3ol^KYP;o
ejb/1_o6Y;L2om_nd004oehnTonDIY[oU6JJoiAVVPCoXW2I00?oJDBBoib[hOnLZn400_nLZn401?oE
]KWoS5jGohaNUoniRZ@2omVLU0;oolj600?onlJ<onc1Y_oNXY<00ooNXY<3onFYTP;on;n<00?ok<eD
omRJT_oHVY800_oHVY82ook8P`03oo_4QooocgSoolmh00CocI2C00?ocY:DofI2T_mV@Y800_m<;X/5
ok5iUP?oMdfC0omX@Y03ohAGU004o`00=Oo5R9?on<6?ooS1S`;omKf?0_oodGL4olN:TPCoMDjF0on=
H9T4oj5_V@06ooc@K?oCUiGodiNEom>GUOmD?I[oCU_01?nCO[X3okjD[0;oYgNM00?o00^Do`0GVol0
09000ooW[YD00ooTZIGo[gRGoogQV`03onRjY0?oiKBQ0_oU/Ih00on`/BWociJIolnFV@03okJ7X`06
olbBV?n`Oj3o/7nPomNOVomSDJOo`8fP0_mXCZ03ok1nW@?o[GnS00CoNEbToj9bWOmiG:CoNEbT0onP
MJ800omK@IWoUfVLoiMYW002oiMYW0CoYG>K00?o]HBQobDMT?nNL9d00_nNL9d3oj9bW0;o[GZK00?o
0000olZGXOm=>Y/00_nWN9l3ok1nWP;o_hnS0_mKCZT3okJ7X`04ol>T^onTNZGoY7ZUojAjY@;oNEfV
00?oH6C0ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`001oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01Wooooo0ol000001?n8HZ3oEcnJoeLoV_mG?iX3oi1ZX`Go[h:T
00?o2a:@ojj7Zon^Qj/00on^Qj/3ol^KYP;oejb/00?o03JjolJT]oo6Y;L00_o6Y;L2om_nd0;oGSjC
0onDIYX4oj9`V@;oJDBB0_nLZn401OmbBi?oS5jGohaNUon<GYOo^HZT00;ofIbD0_oocXH00ooN_;Ko
k<6Vonc1YP03omjRT`?oiJVB0_oh_h`4omRJTP;oo/R30_oka8L2ooo?N0CocI2C00?ocY:DofI2T_mV
@Y800_m<;X/5ok5iUP?oMdfC0omX@Y03ohAGU004o`00=Oo5R9?on<6?ooS1S`;omKf?00?oom5golN:
T_o7RY800oo7RY82omBGT`;oMDjF0on=H9T3oj5_V@03ooc@K?oCUiGodiNE00;odiNE0_mD?IX00om>
Fl3oTgjjoi=n^P02oi=n^P03okjD[?nWMigoYgNM00;oYgNM00?o00^Do`0GVol009000_oW[YD00ooT
ZIGooN6KonBYU@03onRjY0?oiKBQ0_oU/Ih01?n`/BWociJIolnFVOo?UYT2okJ7X`06olbBV?n`Oj3o
einKomNOVon`QZSo`8fP0_mXCZ02ok1nW@Go[GnS0omiG:@3oj1eXP03oe]1VOnGJIcoUfVL00;oUfVL
0onULi/2okF4X@03obDMT?nNL9goWW2M00CoXW:L0on]NY/00ol0003oaI>RojMhW`02of58WP03ok1n
W_noSj?o_hnS00;o_hnS00CoFdjYokJ7XonfQj?o@3ZS1?nTNZD3ogUMYPcooooo00?o0000oooooooo
ool02_ooool000gooooo00?o0000ooooooooool05_ooool3o`000004o`l:QOn8HZ3oR6:PohQRX0?o
EcnJ0on@JZ<5ojn2Y003o`/BT?n^Qj_o[XN[00?o[XN[0oo;VjH2omN/[004ooW[[Oo6Y;OoaZBgolJT
]`;ofok@00?o[gbLoehnTomN?Y<00onDIYX4oj9`V@?oJDBB0_mbBi<3ohaNU`;o^HZT00?ofIbDooo>
Q_oocXH00_oN_;H00on`NiWogZ:ComjRT`04onFYTP;on;n<1?oHVY82ook8P`;onlB70_oocgP4olf@
T`;ocY:D00?oIT:Bod`^Rom<;X/01OnaNIH3ogM=T`?oJ4:@0on4Ei@01?niOYCoaHRCooS1Sooh`Hl2
ooFmS`03oooAMoo7RY;oahZB00?oahZB0ooDUi<01?meCYKoSF2IohePVOn=H9T2oj5_V@03oo6gS_ol
d6codiNE00?odiNE0_mD?IX00om_D9coTgjjoi=n^P02oi=n^P03okjD[?nWMigoYgNM00;oYgNM00?o
00^Do`0GVol009000_oW[YD3onBYU@03omBGU?oX^ZCoj;ZT00;oiKBQ0ooU/Ih4olnFV@04okJ7Xoo<
TYSoc9:Hok1oX0;oeinK00KoomR8oo_NOookgWooJ4jPok1nWOlo>:85ojeoX`?oNEbT0onPMJ800omK
@IWoUfVLoiMYW003oiMYW0;oYG>K0_neQ:400olh:I?oWW2Moj9bW004oj9bW0?o[GZK00OobYNQo`00
0?o5Tj;obYJOof58W_n`OYko`I:V00Co_hnS00?o]XNSod0jXom0>Z<01?nTNZD3ogUMYPcooooo00?o
0000ooooooooool02_ooool000cooooo00?o0000ooooooooool05Oooool2o`0000?ooooo0_l?2XD3
ohQRX0;oEcnJ0on@JZ<5ojn2Y0;o2a:@1On^Qj/01?o;VjKoejb/omN/[?oijjd2ojQgW@03olJT]ooK
o]3o[gbL00;o[gbL0_mN?Y<3oiAVVPCoXW2I0omYA983og9;T`;oS5jG0_niRZ@00ooIW9Coolj6omjl
]P02omjl]P03ok1kVOoNXY?ogZ:C00CoiJVB00?on;n<onc=E?oHVY800ooHVY82ook8P`;onlB700?o
olmholf@Too=T9<00_o=T9<3oljBU003ofI2T_m<;X_oC2j;00Go/GVF1?mgCI<2ofQ2T0?oQ5ND00Co
^GjDooS1Sooh`Hoon<6?0_oe_Hl00ooodGOoahZBolN:TP03olN:TP?oe9NC00GooLm/ohePVOn=H9Wo
SF2Ioj5_V@02oo6gSP03ooc@K?oCUiGodiNE00;odiNE0_mD?IX3ofm@W0CoRV:N1?nWMid2o`0GV`06
onN^UOoTZIGoi:VEonBYUOokdF[oe9ND0_oX^Z@2onFdX@;oiK6N00?o/;4YolnFVOo?UYT00_o?UYT0
0onfQj?oc9:HolbBV003omNOV`07oooHR?okgWoonmiooiQ_X_n`OYgoV6nRoclhXP03ojeoX`04omW?
d?l0=kco03NlogULY0CoX7FR00?oFd6IoiMYW?nGJI`00_nGJI`00onULi_oWGBSokF4X@02okF4X@;o
>2VC1OnRLY`01On]NY_o^hbTolZGXOl0003oaI>R00;obYJO00?o/7jNol6BY_noSj<00onoSj<3od0j
X`CoY7ZU0omiGJH<ooooo`03o`000?oooooooooo00[ooooo000<ooooo`;o00004oooool3o`0000Ko
oooo00Co3`Z5ohQRX?n8HZ3oR6:P0_mG?iX3oi1ZX`Go[h:T0_l;4Y05ojj7Z`04ol^KY_oG[:coejb/
ooW[[@?oZ7NM1?n_O9`00oo`mkKoGSjCoiAVVP02oiAVVPCoXW2I0omYA983og9;T`;oS5jG0_niRZ@0
0ooocXKo^HZTomjl]P02omjl]P03ok1kVOoNXY?ogZ:C00?oiJVB0_oh_h`00oo/cECof9ZBomRJTP02
omRJTP;oo/R300?onlB7ooo?N?oocgP01?o=T9<3oljBU003ofI2T_m<;X_oC2j;00Go/GVF1?mgCI<2
ofQ2T0?oQ5ND00?o^GjDooS1Sooh`Hl00ooe_Hl00ooodGOoahZBolN:TP03olN:TP;oe9NC00?ooLm/
oog5PoomaH<00_oh_XT3oo6gSP03ooc@K?oCUiGodiNE00;odiNE00?ob8fFoe@mV_m_D9`00om_D9`3
ohYRWPCoYgNM00?o00^Do`0GVol05i/00ooTZID00ookdF[oe9NDomBGU003onFdX@;oiK6N00?o/;4Y
olnFVOo?UYT00_o?UYT3olbBV0?oeinK00CoomR8oo_NOoo0RYco`8ZL0_nHKj800olo>:;o[GnSojeo
X`03omW?d0;o03Nl00GoNEbToj1eX_nPMJ;oaL7Foe]1V@04oiMYW003ojEcVonMM:?o]HBQ00;o]HBQ
0_lh:I<5oj9bW005ojejVonkS:CoaI>RolFCX_l000000_o:UYl2ol6BYPCo_hnS00Coi_6Eod0jXom0
>Z?o@3ZS1?nTNZD3ogUMYP_ooooo00?o0000ooooooooool02_ooool000cooooo00?o0000oooooooo
ool03oooool3o`0000Wooooo00Co3`Z5ohQRX?n8HZ3oR6:P0_mG?iX4oi1ZX`Co[h:T00?o/hf]o`/B
T?n^Qj/01?n^Qj/2omN/[003ooW[[OnXMigoZ7NM00;oZ7NM0on_O9`00oo`mkKoi]W8oehnT`03oiAV
VP?oXW2I0_oOfm82ofU4TP?oLT^C0on<GYL2okV:Y0?og[bf0_n`NiT2omjRT`?oiJVB0_oh_h`00oo/
cECof9ZBomRJTP02omRJTP;oo/R300?onlB7ooo?N?oocgP01?o=T9<4oljBU0?oC2j;1?naNIH01?nd
OISoMdfCogM=TomgCI<2ofQ2T0CoQ5ND0_niOY@2ooFmS`;oom5g1?o7RY83omBGT`03oog?K?omaH?o
oLF300;on;j90_oa]hh2ooc@K0CodiNE00?ob8fFoe@mV_m_D9`00om_D9`3ohYRWPCoYgNM00?oEcnJ
o`0GVol05i/00ooTZID00ookdF[oe9NDomBGU002onFdX@?oiK6N00?o/;4YolnFVOo?UYT00_o?UYT3
olbBV0;oeinK00?oomR8oo_NOookgWl00_o0RY`3oiQ_XP03ojeoXooIcm3ofLo@00;ofLo@0_oKm]l0
0ol0=kcoX7FRolG1eP02olG1eP;oUfVL1?nMM:<3okF4X@03oo_VZ?lh:I?oXW:L00CoXW:L00?o[GZK
ok^<Y?o5Tj800_o5Tj801?l0003obYJOol6BY_o1TZH3okn?X`03onKaUOnUM9go@3ZS00;o@3ZS1?nT
NZD3ogUMYP03ojQ@H?oooooooooo00Sooooo00?o0000ooooooooool02_ooool000cooooo00?o0000
ooooooooool03?ooool3o`0000cooooo00Co3`Z5ohQRX?n8HZ3oR6:P0omG?iX3oi1ZX`?o[h:T00?o
O6B]ok>=[OncSJd01?n^Qj/3omN/[003ooW[[OnXMigoZ7NM00;oZ7NM0_n_O9`2oo3g]P03onKIb?mN
?Y?oU6JJ00;oU6JJ0_nRL9T4omoKdP04ofU4T_mbBi?oLT^Cog9;T`?oS5jG00?o^HZTomjl]_oN_;H0
0_oN_;H3ok1kV@04omjRTooUZI;oiJVBonFYTP;on;n<00?o]h2IomRJT_oHVY800_oHVY82ook8P`03
oo_4QooocgSoolmh00CocI2C1?o>TY@3od`^R`Co/GVF0_ndOIP2ogM=T`;oJ4:@1?n4Ei@3okUnU003
ooFmSooodGOo001D00CoahZB0ooDUi<00oomcfcooLF3oog5P`02ooRnR@;olKN>0_old6`4om>GU@03
olR=U_mD?I[oKe2L00?oKe2L0on:HYh5ojMgW@;o01NK0ooTZID3omBGU0;oiKBQ0ooU/Ih00on`/BWo
ciJIolnFV@02olnFV@;oc9:H0ooGWi/00ooof8Sonmiooo_NO`02ol2:W0CoV6nR0ooIcm02om_fg`03
oj9dX?mlG:7oaL7F00;oaL7F0_o=o]l2ochcV`CoWGBS00Co]HBQoo_VZ?okiZSo>2VC1OnRLY`2ok^<
Y0?oaI>R00Co0000ol6BY_o1TZKo`I:V0onoSj<00onRLikoYGBMojEdW@02od0jX`CoY7ZU0omiGJH3
ojQ@H0Sooooo00?o0000ooooooooool02_ooool000cooooo0_l0000:ooooo`?o00004?ooool3ohQR
X0?oEcnJ0on@JZ<2ojn2Y0?oO6B]00Go/hf]o`/BT?n^Qj_o[XN[olFR]@02omN/[003ooW[[OnFJiko
Z7NM00?oZ7NM0_n_O9`3omKkg`05onKIb?nDIY[oU6JJoiAVV_nRL9T01?oOfm800oo<^<OoJDBBog9;
T`02og9;T`?oS5jG00Go^HZTomjl]_oN_;Kog[bfo`00KP03ok1kV@CoiJVB0_oh_h`2okN0V@?of9ZB
00Goo/R3oo_4Qooka8Ooolmhokn8VP04olf@T`CocY:D0om<;X/3ok5iUP05oc@NR?ndOISo]7fHokAm
V?mgCI<00_mX@Y04ohAGU0;o^GjD0_n<HIX00ooodGOo001DolN:TP03olN:TP?oe9NC00?ooLm/oog5
PoomaH<00_oh_XT2oo6gSP;oo=1/0ooCUiD3olR=UP04oe@mV_m_D9coKe2Lofm@W0?oRV:N1OnWMid0
0omG?i[o01NKo`0GV`02onBYU@Coe9ND00CoiKBQonFaW_oU/Iko/;4Y1?o?UYT3olbBV0?oeinK00?o
omR8oo_NOoo0RY`00_o0RY`4oiQ_XP04odHfV_oIcm3ofoKOom_fg`;oXWBP0_mlG:400oo5`MKocOkO
olgng`02ojEhX@03ochcVonMM:?oWGBS00;oWGBS00Co]HBQoo_VZ?nnbdko>2VC1OnRLY`00onkS:Co
aI>RolFCXP03olFCXP07o`000?o1TZKo`I:Vol6BY_noSj?oi_6Eoj9cWP03ojEdW@03od0jXonTNZGo
Y7ZU00;oY7ZU1?miGJH2ojQ@H0Wooooo00?o0000ooooooooool02Oooool000?ooooo0ol00006oooo
o`03o`000?oooooooooo00Kooooo0ol0000Cooooo`?oR6:P0omG?iX3oi1ZX`;o[h:T0omlI:d00onc
SJgoaJ:eojj7Z`03olFR]@03omN/[?oSo;SoUV^N00CoZ7NM00Co[gbLomKkgooFnmooe__O0_n@H9H2
oiAVVPCoHmK]00Cogm_Bolbhaoo<^<Ooc;S70ombBi<3ohaNU`Cog[bf00ColMBcok1kVOn`NiWo/7^I
1?oUZI82ooRoS0;o]h2I0_oHVY82ook8P`;onlB700?oolmhonSVO_o=T9<00oo=T9<4oljBU003oo[4
S?m<;X_oC2j;00?o/GVF00?o=1j8okAmV?ndOIP00_ndOIP2ofQ2T0CoQ5ND0_niOY@2ohaQVP03olJ<
U_l005CoahZB00?oahZB0ooDUi<00oomcfcooLF3oog5P`02ooRnR@;olKN>00?oo=1/om>GUOoCUiD0
0_oCUiD3olR=UP04oe@mV_m_D9coKe2Lofm@W0CoRV:N1?nWMid2oeLoVP03o`0GVooTZIGoi:VE00Co
e9ND0ooU/Ih00on`/BWociJIolnFV@02olnFV@?oc9:H0ooGWi/2oo_NO`?o`8ZL1?nHKj82odHfVP04
om_fgonRM:3oXWBPoj9dX0CoO5bQ0onUN:400oln<i_oWGBSoiedX`02oiedX`04okF4XOokiZSo0000
olFAW`CoXW:L0_nkS:@00olU:iooaI>RolFCXP02olFCXP05ol6BY_l0003o`I:Vol6BY_noSj<00_nR
Lih3ojEdW@03od0jXonTNZGoY7ZU00?oY7ZU0omiGJH2ojQ@H0Wooooo00?o0000ooooooooool02Ooo
ool000;ooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo00?ooooo0ol0
000Jooooo`;oEcnJ0on@JZ<01On_PZCoW7NXogaT[OmlI:goSGjn00KoaJ:e00?ohobhoiI[W_nFJih0
1?nXMid3omKkg`04oh=GUOn@H9KoT62Foi1PUP?oVFNF0_mmYnh4olbha`?oLT^C0on<GYL01_nULYSo
g[bfomjl]_obg[[olMBco`00KP;o/7^I1?oUZI801?oh_hcok<eDokN0VOngP9T2omRJTP;oo/R300Co
nlB7ooo?N?nkQI_oj>In0oo=T9<01?oG[ZkocY:DoljBU?o>TY@2oo[4S0;oC2j;0onaNIH00old7XSo
]7fHokAmV002okAmV0;oJ4:@1?n4Ei@2okUnU0;oS66J00?oaXbFo`00E?o7RY800oo7RY83omBGT`04
oog?K?omaH?on;j9ooRnR@?olKN>00?oo=1/om>GUOoCUiD00_oCUiD3olR=UP04oe@mV_m_D9coKe2L
ofm@W0CoRV:N1?nWMid2oeLoVP03o`0GVooTZIGoi:VE00Coe9ND0ooU/Ih00on`/BWociJIolnFV@02
olnFV@?oc9:H0_oGWi/00ooof8Sonmiooo_NO`03ol2:W0CoV6nR0_m6=YX5oj9dX0?oO5bQ1?nUN:44
oiedX`05om7Si?l0003o[h6Sojn1Xolh:I<00_nRLY`2ok^<Y003olgMJolU:iooaI>R00;oaI>R00Ko
0QZMol6BY_o1TZKo0000ol6BY_nObUX2oj9cWPCoYGBM00?o@3ZSojAjYOnTNZD00_nTNZD3ogUMYP;o
Z51P00?oQ5nOooooooooool01_ooool00ol0003oooooooooo`09ooooo`000_ooool01Ol0003ooooo
oooooooooooo000000Cooooo00Co0000oooooooooooooooo0ol0000Nooooo`03oeLoV_n@JZ?oT6ZS
00;oW7NX00?o[X^bohen__n=O[h00_n=O[h5olFR]@?oUV^N0onXMid2oiYYV0?oPeNE0on@H9H4oiUW
UP;oOJO^0oo<^<L00onKJIKoLT^Cog9;T`03ohaNU`03ojEbV?obg[[og[bf00;olMBc00?o001^ok1k
VOn`NiT00ooUZI82ooRoS003oblKQ_ngP9Wo]h2I00;of9ZB0_onb8<01?oka8Ooolmhok^5Voo/ajl3
olf@T`04omN^[_o>TYCocY:DoljBU0;on/B<0_m<;X/2ok5iUP;o=1j80ondOIP2oocGW@;oJ4:@0on4
Ei@2okUnU0;oS66J00?oaXbFo`00E?o7RY800oo7RY800ol003Soe9NCoog?K002oog5P`;on;j90ooa
]hh00oold6codiNEom>GU@02om>GU@Cob8fF0om_D9`4ohYRWPCoYgNM0omG?iX00ol05i_onm5Zof98
W@03omBGU005omJHTooU/IkoiK6NomJHTol005400oo?UYT3olbBV0;oeinK00?oomR8oo_NOoo0RY`0
0oo0RY`4oiQ_XP;oASJJ1OnRM:03ogaLX@CoYGRQ00?o?S>KoiedXonMM:<00_oAhn@3ojn1X`07ocPY
TonRLYcoXW:Lo`PCTonkS:CoeZ:PobD[W`03olFCXP05o`8JWOo1TZKo`I:Vo`000?o1TZH01?nRLih3
ojEdW@04od0jXonTNZGoY7ZUojAjY@;o`oC_00GoP@00ogUMY_nXD63oZ51PohAOW`08ooooo`03o`00
0?oooooooooo00Wooooo0002ooooo`Co00001Oooool4o`0002;ooooo00?oT6ZSoiagZ?n^Rk800on^
Rk83ohen_PCoaJ:e00CohobhoiI[W_nFJikoUV^N0_nXMid3oiYYV0?oPeNE0on@H9H4oiUWUP;oFCF;
00?oREZDolbhaon9FY@00_nKJIH01OmbBi?oS5jGohaNUon<GYOoYG:H00;ol]jj0_oae;<01?l006ko
/7^Iok1kVOn`NiT2onFYTP;on;n<00?o;a^6okN0VOngP9T00_oHVY82ook8P`04oo_4QonkQI_oj>In
onc7[`?ocI2C00Coejj^oljBU?o>TYCocY:D0_oja8`01_o//Y?oC2j;ok5iU_naNIKoijfDoc@NR0?o
]7fH0_oleid2ofQ2T0?oQ5ND0_niOY@2ohaQVP03olJ<U_l005CoahZB00;oahZB00Kod/cCo`00>?oD
Ui?ooLm/oog5PonUO:H2om>IV0?olKN>00?oo=1/om>GUOoCUiD00_oCUiD4olR=UP04oeXnUom_D9co
Ke2Lofm@W0?oRV:N1?nWMid00on/NIcoEcnJoeLoVP03of98W@?oe9ND00GoeYRConFaW_oU/IkoeYRC
o`00D@03olnFV@;oc9:H00GofIfDomNOVooGWi_oomR8oo_NO`05ol2:W0CoV6nR0_m6=YX4oj9dX0Co
O5bQ0onUN:401?mDA:7oWGBSom7Si?oAhn@4ojn1X`07olFAWonRLYcoaI6OolRKZ?nkS:CoeZ:PobD[
W`03olFCXP05o`8JWOo1TZKo`I:Vol6BY_l000001?nRLih4ojEdW@04ojAjYOo3m>oo`oC_ol?dk`;o
W6jN00CoQ5nOogUMY_nXD63oQ5nO2?ooool00ol0003oooooooooo`09ooooo`000_ooool00ol0003o
ooooooooo`06ooooo`;o00009?ooool00ol03Y;o[X^bojj;/P03ojj;/P?oSGjn0oo5X[D2ojUiWP?o
UV^N00?oZ7NMog]BUOnJJIP00_nJJIP3oh=GU@?oT62F1?nIIiH2oeTeR`?oREZD0onKJIH2ohaNU`;o
R]co0onhdnh00onLJiSo001^ok1kV@02ok1kV@;oiJVB0_oh_h`00ol_6hKo]h2IokN0V@02omRJTP06
ook8Pooka8OonlB7ok^5VooXiWkok<N_0oo=T9<01?oG[ZkocY:DoljBU?o>TY@2oo[4S006onbbTom<
;X_o/GVFok5iU_oW[ICo=1j80ondOIP2oocGW@03onVhXOmX@Y3oQ5ND00;oQ5ND00Ko^GjDohaQV_n<
HI[oS66JolJ<U_l<IMX3olN:TP04om;<dol003Soe9NCoog?K0?oYGbV00GodiVHoo6gS_oa]hkoo=1/
olJ=V004om>GU@Cob8fF0_mJ?YL2ofm@W0?oRV:N0onWMid3ojaiW004oeLoV_mRB9goHTRMof98W@?o
e9ND00GoMeNOomJHTon`/BWoiZVAo`00D@02olnFV@08ooc=Ioo<TYSoc9:HomVMU?oG_CSoeinKoo_N
Ool005<5ol2:W0CoV6nR0_m6=YX4oj9dX0CoO5bQ0onUN:42oeA4X@03om7Si?n_PJ?o[h6S00?o[h6S
0_o5TIl2olRKZ0;oeZ:P00?o[7fPolFCX_o5Tj800_ndPId3ol6BYP03odHfV_l0003oXW>N00;oXW>N
1?nUM9d00omMA9co`oC_oee4W003oia^WP;oQ5nO00?oZ51PohAOWoooool01oooool00ol0003ooooo
ooooo`09ooooo`000oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo02;ooooo1On^
Rk84ohen_P04olFR]OnYNIkoZGVNojUiWP;oUV^N0omkDYD3oiYYV0?oPeNE0on@H9H4oiUWUP;oFCF;
0on9FY@4oi]YUP;oMTfB0onhdnh00on4F9GoW6^Ho`00KP02ok1kV@03oo_WX?oUZI;oiJVB00;on;n<
00?o;a^6okN0VOngP9T00_oHVY801?onb8?onlB7ok^5VonkQI/2onc7[`?ocI2C00Coejj^o`006Oo>
TYCocY:D0_oja8`00oo//Y?oC2j;ok5iUP02onN]U005oc@NR?ndOISo]7fHokAmV?oleid00_oY^:40
1OmX@Y3oQ5NDohAGU?n4EiCo^GjD00?oS66J00?ooMIfoiQdZ?o7RY800_o7RY801?oBc=?o000homBG
Toomcf`3ojElYP;oUVbO00ColKN>ooc@K?o6SISo^7h00ooCUiD4olR=UP04on[<DomJ?YOoFSjGofm@
W0CoRV:N0_nWMid3ojaiW0;oEcnJ0_mRB9d3omBGU005ogMGWooFV9?oeYRCogIW]?oVZI400_o?UYT0
2?mgGj[oc9:HolbBV?oIWICojk2DoooHR?o[/9CodiRG1Oo0RY`2oiQ_XP;oW8Bi0_m6=YX4oj9dX0Co
O5bQ1?nUN:42oeA4X@Go[h6S0_o5TIl3olRKZ008o`000?n/OJ3o9B^OolFCX_ndPIgokm2co`8JWOo1
TZH2odHfVP04oj9cW_l0003oXW>Noj9cWPCoYGBM0omMA9`4oia^WPCoQ5nO1Oooool00on6AGSooooo
o`00000;ooooo`001?ooool2o`0000Sooooo00?o0000ooooooooool08Oooool00ol03Y;o[X^bojj;
/P03ojj;/P;oSGjn0_mhDiX3ojUiWP?ooooo0_mkDYD4oiYYV0;oPeNE0on@H9H4oiUWUP;oFCF;0on9
FY@4oi]YUP?oMTfB00Go^=?^ohAHUOn4F9GoW6^Ho`00KP02ok1kV@06oo_WX?oUZI;oiJVBooRoS?o/
cECo;a^60ongP9T01OoHVY;oo/R3o`d8P_nkQI_oj>In00;oeJZ/00Ko000holf@Too=T9?oejj^o`00
6Oo>TY@2oo[4S0?ok;:C00Ko/GVFonN]U?oW[ICoi:VEoc@NR?ndOIP2oocGW@;ojKRQ00GoJ4:@ohAG
U?n4EiCoQ5NDokUnU002ohaQVP?odYVJ00?o001DolN:T_o7RY800_n0I:P00ooDUi?oYGbVojElYP02
ojElYP;oUVbO00CoaXfHooc@K?o6SISobY:K0_oCUiD5olR=UP04on[<DomJ?YOoFSjGogAAVPCoRV:N
00?oYgNMohmTW?n/NI`00on/NI`01?mG?i[oHTRMof98WOmRB9d2omBGU005ogMGWooFV9?oeYRCogIW
]?oVZI400_o?UYT01?mgGj[o001WolbBV?oIWI@3on^`U003om>HUol005?o`8ZL00?o`8ZL0ooDXj@2
oib4^@03odHfV_nRM:3oXWBP00;oXWBP1?mlG:44ojEhX@?oE4BQ1On_PJ<01?o5TIoob9^XolRKZ?o8
VjP3ojamX009olFCX_ndPIgokm2cono@/oo1TZKo822FodHfV_nRLiko000000;oXW>N1?nUM9d3oee4
W0CoW6jN1?n4Gil3ooooo`?oQTEh0_ooool00ol0003oooooooooo`08ooooo`003oooool00ol0003o
ooooooooo`0Pooooo`03o`0>T_n^Rk;o[X^b00?o[X^b0_oQn]H2ogQCVP?oZGVN0oooool2og]BU@Co
VVVH0_n3EiD4oi1PUP?oVFNF0_mI=H/3ohUJU0CoVfVF0omfCI83ohAHU@;oW6^H00Co/7^Ioo_WX?ok
ij3onnNP0_oh_h`2oblKQP?o]h2I0_onb8<01_l=28;o^hFKonSVO_oEZZco`]mbo`00>0;ocI2C00?o
ejj^o`006Oo>TY@00_oja8`3onbbT`06ok5iU_oW[ICoijfDonBYUOld7XSo]7fH0_oleid2onVhX@06
onNdWon4EiCoQ5NDohAGU?niOYCoi[6M1?oBVIX00ol005CoahZBolN:TP02oi=/X`04omBGTonUO:Ko
YGbVojElYPCoUVbO00?oaXfHohQVYOn8IZD00_oCUiD5olR=UP03on[<DooBV9OoFSjG00CoM56J00?o
RV:NojMgWOn?I9`01On/NI`3of98W@;oe9ND00OoMeNOomJHTooFV9?oMVNdonJYTOl0057ociJI00;o
MenZ00?oc9:HomVMU?o[/9@00_o[/9@00ooCV9Oo001Col2:W003ol2:W0?oe:>T0_nLQ;T2odHfVP?o
XWBP1?mlG:44ojEhX@?oE4BQ1On_PJ<4olRKZ0Co[7fP00?o]86Mono@/oo_d;<00_naPZ401?m6=Y[o
XW>Noj9cW_l00002oj9cWP?oYGBM00Cod;>moee4W?mMA9coGDBL0onLKYh4ohAOW`;ooooo1?n6AGP0
0onNNJWoQD1bo`00000:ooooo`004?ooool2o`00027ooooo1?n^Rk82on7jeP?oN5>J0_nYNIh4oooo
o`?oNe:E0onJJIP3oh=GU@?oT62F0onIIiH2oeTeR`?oREZD1?nKJIH3ogI=TP?oQ5RE0_nLJiP01_n`
NiWonnNPok5kVOnaNiWon;n<ok5kV@?o;a^60_ngP9T02Oonb8?obJjoolV^_onkQI_oeJZ/ol;OL_nJ
L:3o000holf@T`02omN^[P04olNKZoo>TYCon/B<oo[4S0?ok;:C0ooW[I@00ooTZIGo=1j8okAmV002
oocGW@;ojKRQ0_oW]9l3onJaW@03onGCFooBVI[odYVJ00;odYVJ00?o001DolN:T_o7RY800_oFWi`0
0oomcfcoYGbVooc?UP02og]JX0?oUVbO00?oaXfHohQVYOn8IZD00_oCUiD4olR=UP03on[<DooBV9Oo
dYRG00;oFSjG0omdDIX3ohmTW0Go[7VL0omRB9d2omBGU003ogMGWooFV9?oeYRC00;oMVNd00Cool]b
olnFVOmgGj[oMenZ0_oIWI@01Ol09Joojk2Don^`U?oCV9Oo001C00Co`8ZL0ooDXj@3oiYbY@03odHf
V_nRM:3oXWBP00;oXWBP0omlG:44ojEhX@?oE4BQ1On_PJ<4olRKZ0Co[7fP0_o_d;<3ok62X@06odHf
V_nRLikoXW>Noj9cW_l0003oXW>N0_nUM9d2om2c_@?oGDBL0onLKYh4ohAOW`;ooooo1?n6AGP00onN
NJWoQD1bo`00000:ooooo`004_ooool00ol0003oooooooooo`0Nooooo`03o`0>T_n^Rk;o[X^b00;o
hO[F00GoooooogQCV_mhDi[oN5>JojUiWP05ooooo`?oNe:E0onJJIP3oh=GU@?oT62F0onIIiH2oeTe
R`?oREZD1?nKJIH3ogI=TP?oQ5RE0_nLJiP00on`NiWoW6^Hok5kV@02ok5kV@;oZWZN0_l_6hH2okN0
V@05ook8Poo9[[oobJjoonSVO_oEZZ`00_nJL:000ol003SocI2ComN^[P02olNKZ`03oljBU?oja8co
n/B<00;ok;:C0ooW[I@3onBYU@03okAmV?oleigojKRQ00;ojKRQ0_oW]9l3onJaW@GodYVJ00?o001D
olN:T_o>UIX01?oFWi`2ooc?UP05og]JX?nFK9ooUVbOoiI/Woo6SIP00_n8IZD2om>GU@Cob8fF00Go
j/aCom:HUooBV9OodYRGoeXnU`03ogAAVP?oSfBL1On/NI`01?o5U:?oHTRMof98WOoDUi@2ogMGW`;o
eYRC0oo5U:@3ogMOZP;ofIfD00Go02F_on^`U?oCV9OodiRGo`00D`03ol2:W0Coe:>T0onJLZD00om6
=Y[oXWBPoj9dX002oj9dX0?oO5bQ1?nUN:401?oM_KSoE4BQoeA4XOmDA:44ojn1X`?ob9^X00CoM5RT
ojamX?n/OJ3o[7fP0_oZklh01Oo_d;?o/H:Qok62XOnaPZ7o822F00?oXW>N00?o0000oj9cW_nUM9d0
1?o@/kd2oee4W0?oW6jN1On4Gil00omO9g?oQTEhohI5N002ohI5N003oiiiZOn5@7;o000000[ooooo
000Cooooo`03o`000?oooooooooo01kooooo00?o[X^bon7je_ooool01Oooool00onYNIkooooooooo
o`03ooooo`?oNe:E0onJJIP3oh=GU@?oT62F0onIIiH2oeTeR`?oREZD1?nKJIH3ogI=TP?oQ5RE1?nL
JiP3ok5kV@;oZWZN0_l_6hH3okN0V@;obJjo1?nJL:000on]O9kocI2ComN^[P02olNKZ`03oljBU?oj
a8con/B<00;ok;:C0ooW[I@3onBYU@03oocGWOonbhCojKRQ00;ojKRQ0_oW]9l3onJaW@GodYVJ00?o
001DolN:T_o>UIX00ooFWi`2ooc?UP03ookGToo3SIgoUVbO00;oUVbO0on8IZD2om>GU@05onnlW?o8
SIKob8fFolR=U_oZc5<00ooBV9L01?mJ?YOoM56JogAAV_mdDIX3ohmTW0Co[7VL0oo5U:<01?mRB9go
e9NDogMGWomgEil2omJHT`CoaIBT0_mgGjX01?oIWICoekdhoeQ8Y?o[/9@3om>HU`?o`8ZL0ooDXj@0
1OnnRYkoVW:UoiYbYOnJLZGoASJJ00CoXWBP1?mlG:42ojEhX@03ohmb[_o3U:Oo`iBW00;oE4BQ0on_
PJ<01OmFDk?ob9^XolRKZ?o8VjSoM5RT00;o[7fP0ooZklh4ok62X@03ob0PU_m6=Y[oXW>N00;oXW>N
00?o0000om2c_Oo@/kd00oo@/kd2oee4W0CoW6jN1?n4Gil00omO9g?oQTEhohI5N002ohI5N003oiii
ZOn5@7;o000000[ooooo000Dooooo`03o`000?oooooooooo02_ooooo0omkDYD3oiYYV0?oPeNE0on@
H9H3oiUWUP;oFCF;0on9FY@4oi]YUP?oMTfB0on4F9D4oia[V0?o/G^I00CoZWZNogf`m?l_6hKo;a^6
0_ngP9T01?nS/>7obJjoohIRX_n6HZ83oiY`X003ojelW_o=T9?oai^[00;oai^[00?ocY:Doo[4S?o/
/Y<00_o//Y<3onN]U0?oi:VE00?oo/^4omJJUOoFVYD00_oY^:42onNdW`?oi[6M1?oBVIX00oo>UI[o
001DolN:TP04omJOW0;oo<nF00Coo]NCol>=WOo3SIgoLeBO0_mJBJ@2ohQVY@;odiNE00GokkbLolR=
U_o8SIKob8fFon[<D`04om:HU`?oM56J1?n?I9`3ojaiW0;oaIBS00?o[;Xgok:7Z?mRB9d00omgEil0
0onbRjgoaIBTolFDY002olFDY003onk_U?mgGj[oMenZ00?oF4RT0ooCV9L3ol2:W0?oe:>T0_nnRYh3
oiYbY@CoXWBP0_o3X;D2ogaLX@03ojEhXOn?LZkoSg:^00?o`iBW00[oE4BQojn1Xon_PJ?o[h6Sok^=
YOmFDk?ob9^Xok^=YOmFBJOo[7fP0ooZklh00onWO:Go/H:Qok62X@02ok62X@03ob0PU_m6=Y[oXW>N
00;oXW>N00?oaK;7o`000?o@/kd00_o@/kd00on[O:7oBCfQoee4W004oia^WPCoQ5nO00?oGbMcohI5
N?n=BGL00_n6AGP00onNNJWoQD1bo`00000:ooooo`005Oooool2o`0002_ooooo0omkDYD3oiYYV0?o
PeNE0on@H9H3oiUWUP?oFCF;0on9FY@3oi]YUP?oMTfB1?n4F9D3oia[V0;o/G^I0_nZNYh2okf<XP04
oblKQ_ngP9Wo]h2Ioh9QY0?oQV:R0onJL:000on]O9kocI2CojelWP02olNKZ`;on/B<0oo//Y<3onN]
U0?oi:VE00Coo/^4omJJUOoFVYGoeYZE0_oW]9l3onJaW@03onGCFooBVI[odYVJ00;odYVJ00?ocYFJ
o`00E?o7RY801?oFWi`2ooc?UP03ookGToo3SIgo`hfM00;oLeBO00KoFTVTohQVYOn8IZGobY:Kom>G
UOo__9`3olR=UP03on[<DooBV9OodYRG00;odYRG00ComKf?ogAAV_mdDI[oM56J0on?I9`2ojaiW003
oimiZ?o5U:?oaIBS00?o/XNX00CobYNQogMGWomgEioo/X^]0oo5U:@2onk_U003ojQgWOmgGj[oF4RT
00;oF4RT0ooCV9L2ol2:W004o`00A_oDXjCoe:>TomBSY0;o_XZN0onJLZD00om6=Y[oXWBPoj9dX003
ol>P]@;o]8NU00CoYGRQohmb[_n?LZkoSg:^0oo3U:L00omDA:7o[h6SonW/RP02ok^=Y@03olRKZ?nk
SJGoETVW00;oETVW00?oj^o>ojMlYOnWO:D01?naPZ42ob0PUP;oXW>N0oo5//L00ol0003od;>moj]l
X@02oj]lX@03oee4W?nLKYkoW6jN00;oW6jN1?n4Gil3ohe9M`05oij3]_n6AGSoWWVYoiiiZOl00000
2_ooool001Oooooo00?o0000ooooooooool0:?ooool3og]BU@?oVVVH0on3EiD3oi1PUP?oVFNF0omI
=H/3ohUJU0?oVfVF0omfCI84ohAHU@?oW6^H0_naNiT01OnZNYkoj<6^okf<X_nmS:;o;a^600;o]h2I
00CoPV6TohIRX_n6HZ;oQV:R1?nJL:001_o=T9?o[GbNolNKZoo7Vj_on/B<omkcVP?ok;:C0ooW[I@3
onBYU@04ook;Q?oFVYGoeYZEomJJU@;oikBO0ooV/Id5om:IVP;ocYFJ00?oahZBomJOW?oFWi`00_oF
Wi`00oolciKoo]NCol>=W@02ol>=W@?oLeBO0on8IZD00oo:TY_okkbLolR=UP02olR=UP04on[<DooB
V9OodYRGom:HU`?omKf?0_mdDIX3ohmTW005ojaiW?nONJSoWgVXoimiZ?o5U:<00onbQjP2olZGX@;o
/X^]0oo5U:@2onk_U003ojQgWOmFBJOoETVW00;oF4RT0ooCV9L00ol005?o`8ZLolF<U`02omBSY0?o
_XZN1?nJLZD01?nRM:3o>S>Ool>P]Oo3X;D3okB7Y@CoSg:^0oo3U:L00onMM:Co[h6Sok^=Y@04ok^=
Y@?oETVW1?nWO:D4ok62X@03ob0PU_nRLikoaK;700?oaK;700?o0000oj]lXOn[O:400_n[O:400om9
?J7oGDBLoia^WP02oia^WP;ob;k@0on4Gil2ohe9M`06oij3]_n6AGSoWWVYoiiiZOoooooo00002Ooo
ool001Sooooo00?o0000ooooooooool09oooool3og]BU@?oVVVH0on3EiD3oi1PUP?oVFNF0omI=H/3
ohUJU0?oVfVF0omfCI84ohAHU@?oW6^H00?o/G^Ioi5WWOnZNYh00onmS:801?l_6hKo]h2Ioh9QY?n2
HJ@3ohIRXPCoVW2P0_n]O9h3olNKZ`04omkcV_n/NYgok;:ConbbT`?oijfD0ooTZID00oonbhCoeYZE
omJJU@02omJJU@04onNdWooV/Igoi[6MonJaW@GodYVJ0_o>UIX01?o7RY;o0aNIomJOW?oFWi`2ooc?
UP04ookGToo3SIgo`hfMol>=W@?oLeBO0_lELN400on8IZGobY:KonnlW002olR=UP;oj/aC0ooBV9L2
ooFmS`03oog8QOoHW9GoM56J00?oSfBL00Co[7VLoimiZ?nONJSoWgVX1?nbQjP01?o:Uj7o/X^]ok:;
[OnbRjd2olFDY0;ok^nD00CoUF^OojQgWOnXMigoETVW0_mHB:@3om>HU`03oo_5S?o0RYcoaHbG00;o
e:>T0onnRYh5oiYbY@;o>S>O00Co`j2eokB7YOndQjGo]8NU1?n?LZh2ol>DY`04oiedY?nMO:koWGb^
oiel[PGo^hfU0_mFBJL4ojMlY@Co/H:Q00?o822FolFbaoo5//L00oo5//L00on[O:7o0000oj]lX@02
oj]lX@04odTmXOmMA9coW6jNoia^WP?ob;k@0on<KJX2ohe9M`06oij3]_n6AGSoWWVYoiiiZOoooooo
00002Oooool001Wooooo00?o0000ooooooooool09oooool2og]BU@?oVVVH0on3EiD3oi1PUP?oVFNF
0omI=H/3ohUJU0?oVfVF0omfCI84ohAHU@?oW6^H00?o/G^IonS1[_oX`Jh01?nmS:800ongP9WoPV6T
oh9QY003ohIRXPCoVW2P0on]O9h01Oo7Vj_og_>JojajWOn/NYgok;:C00?oijfD0ooTZID2ook;Q0Co
eYZE0ooV/Id00ooUde_odYVJom:IVP02om:IVP05od`jVoo>UI[ocYFJoljEV_l35iT00_oFWi`2ooc?
UP04ookGToo3SIgo`hfMol>=W@CoLeBO0_lELN42onnlW0;ob8fF00?oj/aCom:HUooBV9L00_oBV9L2
ooFmS`03oog8QOoHW9Gof9bE00;oSfBL00GoLUVVoimiZ?nONJSoWgVXoi1`Z`04ok:7Z003olZGXOnb
Rjgo/X^]00;o/X^]00CoaIBTonk_U?o^kiCoUF^O0onXMid3oeQ8Y0;odiRG0_okaH`00oo5S9Oo0016
omBSY003okj:WPGoVW:U0_lj<il4okB7Y@GoSg:^00?o`iBWoiel[_nMO:h00_nMO:h5ok^=Y@?oETVW
0onWO:D4ok62X@;o822F0oo5//L01?nRMj;oZgbQoj]lXOl00002oj]lX@;oBCfQ00GoW6jNolRnd?o8
_]3ob;k@ojUnY004oha]ZP03ohe9MonNPkKoWX>f00?ooooo00?o0000ooooooooool01oooool001[o
oooo0_l0000Xooooo`03og]BUOnJJISoVVVH00;ooooo0_n3EiD3oi1PUP?oVFNF0omI=H/3ohUJU0?o
VfVF0omfCI84ohAHU@?oW6^H00?o/G^IonS1[_n`Q:H01?nmS:801?ngP9Wo[GbNoh9QY?n2HJ@2ohIR
XPCoVW2P0_n]O9h00onAIIcoai^[o`00IP03ojajW@?oijfD0ooTZID2ook;Q0CoeYZE0ooV/Id2ob/U
UP?odYVJ00GoC3ZKoljEV_o>UI[ogZ:Do`<GV@02omJOW003ooc?U_onei?oo]NC00Co`hfM0omcE9l2
oeQ1V`05oaEahOo__9cob8fFolR=U_oZc5<01?oBV9L2ooFmS`04oog8QOoHW9Gof9bEomRLU@;oI52V
00CoWgVXoi1`Zon@L:_oT72[1?nbQjP00onFOKGo/X^]ok:;[@02ok:;[@04olFDY?nEJiooUF^OoiE[
W`?oZ7NM0omHB:@2om>HU`04oo_5S?o5S9OoaHbGo`00APGo_XZN1?nJLZD2ocXcW`Go]8NU1?n?LZh0
0oo3U:OobIRToiel[P02oiel[PGo^hfU0omFBJL3ojMlY@Co/H:Q0olP89H01?o5//OoXWNRoj9gX_nR
Mj82oj]lX@04o`000?n[O:7oBCfQodTmX@?ob;k@0onYOZ@3oha]ZP03ohe9MonNPkKoWX>f00?ooooo
00?o0000ooooooooool01oooool001cooooo00?o0000ooooooooool09_ooool00onJJISooooooooo
o`02ooooo`04oh=GUOn@H9KoT62Foi1PUP;oVFNF0_n<GiP2oeTeR`?oREZD0onKJIH3ogI=TPCoQ5RE
0onLJiP2onS1[P03ok24Y_nmS:;o_HbR00?o_HbR0_n]O9h00on2HJCoQV:RohIRXP04oiY`X0;o[GbN
00?oTFFLojMfW?l006H00on/NYd3onN]U0?oi:VE0_onbh@3omJJU@04on[9CooHViCoi[6MonJaW@;o
:bFF0ooBVIX01Om<>Y_ocYFJoljEV_oNXYCoo<mZ00;oeYnL00?oo<nFookGToo3SId01?o3SId3og=D
W`;oF46K0_n4H:42olR=UP03on[<DooBV9OodYRG00;odYRG0_oe_Hl01?omb8Gof9bEomRLUOoHW9D3
ofA@YP?oT72[1?nbQjP00onFOKGo/X^]ok:;[@02ok:;[@04ohEQX?nEJiooUF^OoiE[W`CoZ7NM0_mH
B:@2om>HU`04oo_5S?o5S9OoaHbGolF<U`Go_XZN0onJLZD01?nlQY_o>S>OocXcWolj<il4okB7Y@;o
Sg:^0_niQYl2olVHY0CoWGb^1?nkSJD00on_QJOoETVWoeI9Y`03ojMlY@Co/H:Q00?o/8:Sob0PU_lP
89H01?nRMj82oj]lX@03o`000?n[O:7oBCfQ00;oBCfQ00?ob;k@ojUnY?nYOZ@00_nYOZ@4oha]ZP03
ohe9Mooooooooooo00;ooooo00?o0000ooooooooool01oooool001gooooo00?o0000ooooooooool0
:oooool3oi1PUP04oiUWU_n<GiSoS5nHohaOV0;oFCF;0on9FY@3oi]YUP?oMTfB1?n4F9D3oia[V004
onS1[_n`Q:Ko/8BVok24YP?o_HbR1?n]O9h3ohIRXP?oVW2P00Go[GbNoi5UW?nAIIcoYgJLo`00IP04
ojajW@;oijfD0ooTZID00oonbhCoeYZEomJJU@02omJJU@04on[9CooHViCoi[6MonJaW@;o:bFF0ooB
VIX02Om<>Y_ocYFJoljEV_oNXYCoo<mZo`<GVOoFWicoo<nFookGT`05ol>=W@?oLeBO0_mH@I/2ohAP
X@;ob8fF00?oj/aCom:HUooBV9L00_oBV9L2ooFmS`07oog8QOoHW9Gof9bEomRLUOoS`d?om[b;ofA@
YP03oi1`Z`?o/XNX0onFOKD2ok:;[@;oQF6P0onEJil4ojQgW@;oF4RT0_oCV9L01?okaHcoaHbGolF<
Uoo5S9L5okj:WP05oiYbYOokeioo_8JKokb6VonVN:000_lj<il4okB7Y@?o^HJO00?oiN9dolVHY?o9
V:@01?nMO:h3ok^=Y@;o[hFW0_mFBJL4ojMlY@;o/H:Q0_n`PZ<2ob0PUPCoXWNR0on[O:401?l0003o
ZgbQodTmXOm9?J45ojUnY0CoS6fZ00?oSDUgooooooooool00_ooool00ol0003oooooooooo`07oooo
o`007_ooool00ol0003oooooooooo`0/ooooo`03o`00DOmgCiKoS5nH00;oS5nH0_mI=H/3ohUJU0?o
VfVF00?oTFBJogI=T_mfCI801?n4F9D2oia[V003omW3a?oX`Jko/8BV00;o/8BV0onmS:800onRMJ3o
[GbNojelWP02ojelWP03ogIBVon6HZ;oVW2P00;oVW2P00Go[GbNoi5UW?nAIIcoYgJLo`00IP04ojaj
W@;oijfD0ooTZID00oonbhCoeYZEomJJU@02omJJU@?of9^D00?ojlQ>onJYT_l[9IH00_oBVIX01?oo
bWkoC3ZKoljEV_o>UIX2ooc?JP04onbaToolciKoo]NCoadJT0Go`hfM0omcE9l2oeQ1V`?oQ62Q00?o
b8fFolN@V_oBV9L00ooBV9L2ooFmS`Cof9bE00Cohl=3ooJlRooVZY;oI52V0on@L:/01_nbQjSoeYZE
omJJUOok`XOoUWfeok:;[@?oQF6P0onEJil4ojQgW@05ofI9VomHB:CodiRGom>HUookaH`00oo5S9L5
okj:WP;onmNO0_nlQY/00onVN:3o>S>OocXcW`04okB7Y@?o^HJO0oo9V:@4oiel[P;o^hfU00GoQF:R
ojn5Yon5HZ;oX7>PoeI9Y`04ojMlY@03ok62XOnOMjKo/8:S00;o/8:S0_lP89H3oj9gXPCoZgbQ00?o
0000odTmXOm9?J401OnYOZ@4oha]ZP03ohe9Mooooooooooo00?ooooo00?o0000ooooooooool01_oo
ool001oooooo00?o0000ooooooooool0:oooool00ol007KoSWnoohaOV002ohaOV003oiYZVOmI=H_o
REZD00;oREZD0onKJIH2oi5TVP03ogI=T_n4F9GoQ5RE00;oQ5RE00?oW6^HomW3a?oI`l@01?n`Q:H2
okf<XP;oXWFP1?n]O9h2ogIBV`;oVW2P00KoO5JKoi5UW?nAIIcoTFFLojMfW?l006H4ojajW@;oijfD
0ooTZID00oonbhCoeYZEomJJU@02omJJU@?of9^D00?ojlQ>onJYT_l[9IH00_oBVIX2ooo:OP04od`j
Voo>UI[oo<mZooc?JP;ok;6C00?ofIjGoadJT?o3SId01?o3SId01?oJeEcoLeBOog=DWomcE9l2oeQ1
V`;oQ62Q00?ob8fFolN@V_o7T9X00_oBV9L3ooFmS`Cof9bE00Cohl=3ooJlRooVZY;oiZZB0on@L:/0
1_nbQjSoeYZEoo_2Qook`XOofIjFoeA4X@?oQF6P0onEJil4ojQgW@;oITVK00?oF4RToo_5S?okaH`0
0oo5S9L00ol004Ko_XZNokj:WP02okj:WP;onmNO0_nlQY/2ojIhX005ocXcWondQjGo]8NUokB7YOm]
DZ800oniQYl4olVHY0CoWGb^00Co^hfUohERX_n5HZ;oQF:R0_nPLj001_mFBJOoYgbUojMlYOnWO:Go
/H:QoimgYP?o/8:S0_lP89H4oj9gXP?oZgbQ00Co0000odTmXOm9?J7oBCfQ1?nYOZ@4oha]ZP03ohe9
Mooooooooooo00?ooooo00?o0000ooooooooool01_ooool0023ooooo0_l0000/ooooo`?oSWno00?o
6cbgoiFKeomI=H/00on9FY@2oi]YUP?oTFBJ00?oZ7JKohAHUOn4F9D00_n4F9D00onLJiSofL?4omW3
a004ok24YP04okf<X_nRMJ3oXWFPoj9eX0Co[GbN0_mfDY/3ogaFV`?oTFFL00?oYgJLo`00I_n/NYd0
1?n/NYd3onBYU@;oo/^41?oFVYD3omRKU00:on_8C_oVZI;oiZVBob/UU_oBVI[oolYnomjRU?m<>Y_o
gZ:Dooc?JP?ok;6C00?ofIjGoadJT?lM6Y001?o3SId2omNTX`;oLeBO0_mH@I/2ohAPX@03on[<Doo7
T9[oai2J00;odYRG0_oe_Hl00oomb8Gof9bEomRLU@02omRLU@;om[b;0ooVZY801?njYaWoeYZEomJJ
UOoFVYD2oo_2Q`04omVNU_mDA:7oE4BQo`0QY`;oQF6P0onEJil3ojQgW@04om6c^omVBI_oF4RToo_5
S0;oJTbL0oo5S9L3okj:WP;onmNO0onlQY/3ojIhX0?o]8NU0_m]DZ800oniQYooiN9dolVHY003olVH
Y0;oWGb^0on[O:43ohERXP;oX7>P00?oETVWojMlYOnWO:D01?nOMjH2ok22X`03ojemWolP89KoXWNR
00?oXWNR1?n[O:400ol0003oBCfQodTmX@05ojUnY0?oS6fZ00?oSDUgooooooooool00oooool00ol0
003oooooooooo`06ooooo`008_ooool00ol0003oooooooooo`0Yooooo`06o`00DOn>OkooSWnoohio
_olK?;OoFCF;0on9FY@01?nKJIKoTFBJoi5TV_nAI9X3omB_]003okf=XooLeM3ofL?400;ofL?400?o
JE>Vok24Y_n`Q:H00_n`Q:H01?nmS:;oXWFPoj9eX?nRMJ04ojelWP03oj]nXomfDY_oMU:K00;oO5JK
0onAII`2ojMfW003o`00I_n/NYgo[7ZM00;o[7ZM0ooTZID2ook;Q0CoeYZE0ooHVi@01_o[b4koiZVB
onJYT_l[9IKodYVJooo:OP?ogZ:D00Coo<mZonbaToo//I?ok;6C0_oIWYL01OlM6Y3o`hfMol>=WOo3
SIgof]EL00?oejBS00?oLeBOoeQ1VomH@I/00on4H:42olN@VP;odYRG0_oe_Hl00oomb8Gof9bEomRL
U@02omRLU@;om[b;0_oVZY800oonc6goeYZEomJJU@02omJJU@;onl:700KofIjFoeA4XOmDA:7oE4BQ
o`0QYon5HJ03oiE[W`;oZ7NM0_oA/k/2ofI9V`03oo_5S?mZC9coJTbL00?oaHbG0onnRYh2oo_GW`Co
_8JK00SoYWRPomgiZOlj<ioo]8NUokb@Z?mLE;3oKE:RokV6W`GobIRT00?oHTfSoj]lXOn[O:400_n[
O:43ohERXP?oX7>P00?oYgbUod<lXonOMjH00onOMjH01?n`PZ?oW76QojemWolP89H4oj9gXPCoZgbQ
00?o^H^To`000?m9?J401OnYOZ@4oha]ZPGooooo00?o0000ooooooooool01_ooool002?ooooo00?o
0000ooooooooool0:?ooool01_l007KoSWnoohio_on>Okoo6cbgojFHa`?oREZD00?oVfVFoi5TV_oB
/kX01?oD[k@2okf=X`;ofL?40_mYDjH4ok24YP04ofe?W_nRMJ3oXWFPoj9eX0?o[GbN00CoVG>Voj]n
Xon[OZ?oMU:K0_mlEY/3oi5UW0;oYgJL00?o001VojajWOn/NYd00_n/NYd3onBYU@;oo/^41?oFVYD3
omRKU006on_8C_oVZI;oiZVBonJYT_omaX?oolYn0ooNXY@01?olcf[ok;6ConbaToo//I<2omVNU`05
oadJT?o3SIgo`hfMol>=WOoJeE`00ooGY:<00oo3SikoF46KoeQ1V`03ohAPX@;oai2J0_oBV9L2ooFm
S`05oog8QOoHW9Gof9bEomRLUOoS`d<00_of_8/2onJZTP03ook<KOoFVYGoeYZE00;oeYZE00?onl:7
omVNU_oIWYH00omDA:42o`0QY`?oUF^O00?oZ7NMom6c^ooA/k/00_oA/k/2ofI9V`;oJTbL0oo5S9L3
okj:WP;onmNO1?nlQY/01?nVN:3o_92Xokb@Z?ndQjD2okb@Z003oeaD/?niQYoobIRT00CobIRT00?o
HTfSoj]lXOn[O:400_n[O:42ooooo`03ohERX_nPLj3oX7>P00;oX7>P00?oGDJNod<lXonOMjH00_nO
MjH00on`PZ?oW76QojemW`02ob0PUP?oXWNR0on[O:42okV;Y003okb9X?l0003oBCfQ00CoZGjT1?n<
KJX5ooooo`03o`000?oooooooooo00Kooooo000Tooooo`03o`000?oooooooooo02Sooooo0on>Okl2
oa/l]`GoYIS700God[>jomB_]?oD[kCoe:ndojf0Y@03okf=X`04omW3a?nhQj7oJE>VofUCYP?o/8BV
00CoKDnNoj9eX?nRMJ3oXWFP0_n]O9h2oiUcYP;oZgjS00?oMU:KogaFVomlEY/00onAII`2ojMfW003
o`00I_n/NYgo[7ZM00;o[7ZM00Co[G^LonBYUOoTZIGoo/^41?oFVYD01OoZbDoof9^DomRKU?oHViCo
jlQ>00;oiZVB0_omaX<01OoobWkogZ:DomjRU?oNXYCoo<mZ00?ok;6C0_oIWYL01OlM6Y3o`hfMol>=
WOo3SIgof]EL00?oejBS00?o`hnNoeQ1VomH@I/00on4H:42olN@VP;odYRG0_oe_Hl01Oomb8Gof9bE
omRLUOoHW9Gohl=300;om[b;0_oVZY800oonc6goeYZEomJJU@02omJJU@03oo_2QooIWYKofIjF00?o
E4BQ00?oLeNSo`0QYon5V^000_n5V^000onXMigodK>kom6c^`02om6c^`04oeE3X?mVBI_oJTbLofY<
W0?oaHbG0_nnRYh2oo_GW`Go_8JK00?oo]:Aokb@Z?nlT:P00onlT:P3oeaD/0?obIRT0_ooool01?mR
CJ?oZgbQoj]lXOn[O:43ooooo`04ohERX_nPLj3oX7>Pooooo`;oGDJN0_nOMjH3oiaaX@;o[GfO00?o
822Foj9gX_nRMj800_nRMj801on[O:7oZh2VokV;Y?n`P:7o_8VPo`000?m9?J401?nYOZ@9ooooo`03
o`000?oooooooooo00Kooooo000Uooooo`;o0000:?ooool3oiEm]P;oD5Nj1?nUV<L00onaVKkoe:nd
omB_]002omB_]003ojf0YOnmSJ?o_HfS00;o_HfS0_nhQj400omYDjKo/8BVok24YP02ofe?WP?oXWFP
00Co[GbNoiUcY_nILjKoVG>V0on[OZ<3ogaFV`?oTFFL00?oYgJLo`00I_n/NYd00_n/NYd2ojekW0;o
i:VE00?oo/^4omJJUOoFVYD00_oFVYD01OoZbDoof9^DomRKU?oHViCojlQ>00;oiZVB00?ooLJ3ooo:
O_oobWh00ooNXY@00oolcf[ok;6ConbaT`04omVNU`?o`hfM1?oGY:<00oo3SikoL5NUoeQ1V`03ohAP
X@;oai2J0_oBV9L2ooFmS`05oog8QOoHW9Gof9bEomRLUOoS`d<00_of_8/2onJZTP03ook<KOoFVYGo
eYZE00;oeYZE00Conl:7omVNU_oIWYKofIjF0_mDA:42og=GX`03o`0QYon5V^3oQI[P00CodK>k00?o
[7fRoeE3X?mVBI/00_mZC9`3olF<U`05o`00A_nnRYkonmNOoo_GWol007@01?nlQY/00oondY7odibL
okb@Z003okb@Z003olfFVomLE;3oG5B`00?obIRT0_ooool00omRCJ?oZgbQoj]lX@05ooooo`04oj1c
X?ooooooooooooooo`?oGDJN0onLLJ42ojemW`03ob0PU_nRMj;oXWNR00;oXWNR00CoZgbQoj^0Y_ni
RjCo/82Q0_nlRJ000ol0003oZGjTojUnY002ojUnY0Wooooo00?o0000ooooooooool01_ooool002Oo
oooo00?o0000ooooooooool09Oooool4oiEm]P;oD5Nj00CoYIS7ok6I__naVKko/IVn0ooD[k@2ojf0
Y@?o_HfS00So[X2RokR7XOnhQj7o^8NQok24Y_nfSJ_o_8nWofe?WP;oXWFP00?oh_g6ocTbWOnILjH0
0_nILjH3oj]nX`03oea5W_mlEY_oO5JK00?oTFFL00?oYgJLo`00I_n/NYd00_n/NYd2ojekW0;oi:VE
00?oo/^4omJJUOoFVYD00_oFVYD4omRKU0?oiZVB00?ooLJ3ooo:O_oobWh00ooNXY@00oolcf[ok;6C
onbaT`04omVNU`;o`hfM00Cof]ELomNTXooGY:?oejBS0oo3Sih01?mH@I_oQ62QohAPXOn4H:42olN@
VP04omk;COoBV9OomKf?ooFmS`Cof9bE00?ohl=3ooJlRoof_8/00_oVZY800oonc6goeYZEomJJU@02
omJJU@04oo_2QooIWYKofIjFomVNUP?oE4BQ0_mcEj<3ohFJh0;odK>k0on/OJ801?mE@j3oJTbLofY<
W?mZC9`2olF<U`05ooFmSonnRYkonmNOoo_GWol007@01?nlQY/00oondY7odibLokb@Z003okb@Z003
olfFVoooooooG5B`00;obIRT1?ooool00on[O:7oooooooooo`08ooooo`?oGDJN0onLLJ43ojemW`Co
XWNR0_n[P:H01_niRjCo/82Qok20XOnlRJ3oBCfQo`0000;oZGjT2oooool00ol0003oooooooooo`05
ooooo`00:?ooool00ol0003oooooooooo`0Uooooo`?oUGff0_m@EkX5ok6I_P04omB_]?n]P:Go[H2U
ojf0Y@?o_HfS00Co[X2RokR7XOnhQj7o^8NQ0_nfSJ/01_nlSjOoknS5oj9eX?nJLZ?oYGRRocTbW@?o
VG>V0_n[OZ<2om30bP03oea5W_mlEY_oTFFL00;oTFFL00GoYgJLoiA]Y?n/NYgo[7ZMo`00M003ojek
W0;oo/^41?oFVYD4omRKU0?oiZVB00?ooLJ3ooo:O_oNXY@00_oNXY@2ooc?JP;ok;6C1?oIWYL2ol>=
W@04om[EG?oGY:?oejBSomNTX`?o`hnN00CoL5NUoeQ1Von4H:7oQ62Q0_o7T9X01?n7PlSomKf?ooFm
Sooe_Hl4omRLU@03on?3@oof_8_om[b;00;oiZZB00Coo/a]omJJUOoFVYGoeYZE0_ok`XL3omVNUP?o
E4BQ0_mcEj<3ohiYY003ohFJh?oA/k_o[7fR00;o[7fR00CoED>PofY<W?mZC9coJTbL0_o5S9L01Ooe
_HoonmNOoo_GWookeioo001d00?o_8JK00?oo]:Aom>LW?oCW9`00onlT:P2olfFV`;ooooo00?oG5B`
olVHY?ooool03oooool2oee6WPCoW76Q0_n]OIl00olP89KoXWNRoj9gXP03oj^0YP?o/82Q0_ooool0
0om9?J7o0000ooooo`0;ooooo`03o`000?oooooooooo00Gooooo000Yooooo`03o`000?oooooooooo
02Cooooo0onEOKH3oe1G^PCo/IVn00Coe:ndojf0YOn]P:Go[H2U0onmSJ<2ojj0XP05okR7XOnfSJ_o
]Xf[okJ=Zoo3o;h00onJLZ<2ojEhXP?oVG>V00?oZgjSom30b_o@`<X00_o@`<X02OmLAIkoTFFLoi5U
W?nAIIcoYgJLoiA]Y?n/NYgo]HFRo`00M003ojekW003ook;Q?nlQY_oeYZE00?oeYZE0ooHVi@01_o[
b4koiZVBonJYT_oVZI;ooLJ3ooo:OP?ogZ:D0_olcfX2onbaT`?ofIjG00Com[j?oadJT?o3SIgo00:5
0ooGY:<3ol>?WP03og1GYOmH@I_oQ62Q00;oQ62Q00Goai2JohN3b?oe_HoomKf?oog8Q@04omRLU@03
on?3@oof_8_om[b;00;oiZZB00Coo/a]o`00>ooFVYGoeYZE0_ok`XL3omVNUP?oE4BQ0_mcEj<4ohiY
Y0Co[7fR0_mE@j02ofY<W0;oaHbG00GomKf?omNLU_oGW9KoeibFo`00M003okb6V`03ookBTOoCW9co
dibL00?o_92X0_o=UY/3ooooo`03olVHY?oooooooooo00oooooo00?oGDJNoiaaXOnLLJ400_nLLJ40
1On]OIoooooooooooonRMj;o3AJC00?oZh2V0on`P:43ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool01Oooool002[ooooo0_l0000Tooooo`CoUGff0_m@EkX4ok6I_PGo[H2U00Go_HfS
ojj0X_n^P:;o[X2RokR7X@02okJ=Z`03ol?l__n7IJGoVW:S00;oVW:S0onUN:83ogjjnP?od<3:00?o
g^WJoea5W_m]DJ000_m]DJ02oiA]Y003ojajWOneQJ;o001d00Co[G^L0_o4TZ83omJJU@?of9^D00Ko
jlQ>onJYT_oVZI;oiZVBoog6PooobWh3omjRU004ooc?J_o//I?ok;6ConbaT`?ofIjG00Kom[j?oogA
Koo3SIgo;BJGokEV0?oGY:<4ol>?WP;oL5NU0on4H:401OoNbdgoUgF[oiMeZonGMJ_ooLR500Cof9bE
0_of_8/2onJZTP;oo/a]00?oeYjKomJJUOoFVYD00_ok`XL3omVNUP03omJLV?mDA:7oE4BQ00;oLeNS
1?n>JJ@4ojamXP;oED>P0_mZC9`2olF<U`05ooFmSooGW9KoeibFomNLU_l007@00onlQY/01OondY7o
dibLom>LW?oCW9co_92X00?ocIJK5Oooool00omMAYkoW76QoiaaX@02oiaaX@05ojemWooooooooooo
ooooool=5Y<00_n[P:H4ok20X@Cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05
ooooo`00;?ooool00ol0003oooooooooo`0Rooooo`;oUGff0onNLj83ok6I_P03ohaXXon]P:Go[H2U
00?o[H2U00Oo_HfSojj0X_n^P:;o[X2RokR7XOnfSJ_oZX2V00;oQfFU0onJLZ<4ojEhXP?oO[[j00Co
d<3:omkYf_oNjM[og^WJ0om]DJ03oiA]Y0;o]HFR1?n]Ni`2olBBXP;oeYZE00Goj/U?omRKU?oHViCo
f9^Don_8CP03onJYTP03oog6PooobWkogZ:D00;ogZ:D00Coo<mZonbaToo//I?ok;6C0ooIWYL01_of
_XoooM5_om[EG?l]9YOo00:5omNTX`Co`hnN0om`EjD2oeM7Y0CoUgF[00Gofj:IomRLUOoHW9Gof9bE
on?3@`02ooJlR`;oiZZB0_onc6d00ooFWY_oeYZEomJJU@02oo_2Q`?ofIjF00?oeYbHoeA4XOmDA:40
0omcEj<3ohiYY0Co[7fR0omE@j001?mZC9coaHbGooFmSooe_Hl4omNLUP?o_8JK00Goo]:Aom>LW?oC
W9codibLokb@Z002olfFVaOooooo00CoGDJNoiaaXOnLLJ7oW76Q1Oooool00on[P:Ko?3:Lok20X@02
ok20X@Kooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05ooooo`00;Oooool00ol0
003oooooooooo`0Qooooo`03oiEm]_mF?9OoESbG00?oWW>R00Co/IVnohaXXon<J:?oS6RS1?n]P:D0
1?nmSJ?o[X2Rojj0X_n^P:83ojZ0YP;oQfFU0onJLZ<4ojEhXP;o>bZC0on=IZ000ooNjM[oYGRQojEh
X@02ofeAX0?oU6fT00?o]HFRoo7G]On]Ni`00on]Ni`2olBBXP;oeYZE00Goj/U?olbHXOoHViCof9^D
on_8CP03onJYTP03oog6Poo<VZ?oc9ZS00;ogZ:D00Coo<mZonbaToo//I?ok;6C0ooIWYL01_of_Xoo
oM5_olbBUoo<TYOo00:5omNTX`Co`hnN0_oicid2og1GY@;oEdNT0onGMJ/01OoKXYWof9bEomRLUOoH
W9Gohl=300;om[b;0_oVZY800oonc6gofZ6Ioj60[`02omJJU@;onl:70ooIWYH2omJLV004oeA4XOmc
Ej?oLeNSog=GX`CoSVVT0on/OJ83oeE3X004oem;XomZC9comKf?ooFmS`CoeibF0_nlQY/2ookBT@?o
dibL00?oh:VKolfFVoo=UY/05oooool00omMAYkoW76QoiaaX@08ooooo`?o/82Q1oooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Gooooo000^ooooo`03o`000?oooooooooo027ooooo
0_mF?9L4oiicXP?oS6RS1?n]P:D3ojj0XPCoZX2V0_n7IJD3oiYbX`CoYGRR0_lk:Y<3oheVX0CoYGRQ
00KoKE6PoiA]Y?nDKJCoU6fTokF5X_oaekD3ojekW003ol>AX_o4TZ;oa9:R00;oeYZE00KoiMm_olbH
XOoHViCof9^Don_8C_nYNj82onJYTP03ooo:O_o<VZ?oc9ZS00;ogZ:D00Coo<mZonbaToo//I?ok;6C
0ooIWYL01Oof_XoooM5_olbBUoo<TYOo00:500Go`hnN0_oicid01?o2S9_oL5NUoeM7Y?mGAj@3oiMe
Z`;ofj:I0_oHW9D00ooS`d?oYGZTooJlR`02onJZTP03ook<KOoJXIWoXH2_00;oeYZE0_ok`XL3omVN
UP?oeYbH00?oE4BQog=GXomcEj<01?n>JJ@4ojamXP;oED>P00CoGd^SofY<W?oe_HoomKf?0ooGW9H0
0ooTZ9?o001dokb6V`02ookBT@?odibL00?oh:VKo`00I_o=UY/06?ooool00onLLJ7oooooooooo`07
ooooo`03oc`bW?n`P:7ooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`05
ooooo`00;oooool2o`00027ooooo0_mF?9L4oiicXP?oS6RS0on]P:D01?nIL:?o[X2Rojj0X_meGJT4
ojZ0YP;oQfFU1?nJLZ<4ojEhXP04oc/ZTon=IZ3oSFJPoheVX0CoYGRQ00?oK4nOoiA]Y?nDKJ@00_n/
e?D01Ol0003o001dojekW?n]Nico`i6R00;oa9:R0_oFVYD02ooUgfooc9RQomRKU?oHViCojlQ>ojUk
X_oVZI;ooLJ3ooo:O_o<VZ?onNZG00;ogZ:D00?oo<mZojilW_o//I<00ooIWYL2ooJnS`04oogAKoo<
TYOoc9:Go`02Q@Go`hnN0_oicid2ol:<V`;oEdNT1?nGMJ/01_oKXYWof9bEomRLUOoS`d?oYGZTooo<
Q@;oiZZB00?oo/a]omZQVOnQP:l00_oFVYD00ook`XOofIjFomVNUP02omVNUP?oeYbH00?oE4BQog=G
XomcEj<01?n>JJ@4ojamXP?oED>P00?oGd^SooFmSooe_Hl00ooGW9H00ooTZ9?o001dokb6V`02ookB
T@?odibL00?oh:VKooooooo=UY/08oooool00on`P:7oooooooooo`07ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01?ooool0037ooooo00?o0000ooooooooool07_ooool2oeHlU`Co
WW>R0on<J:<2ojf0Y@;oVG2S00?o[X2RogEMZOmeGJT01OnZP:H2ohMUY@?oVW:S1?nUN:801?lk:Y?o
SFJPoheVX?n=IZ04ojEhX@;oK4nO00SoPV6SojcDmOn2HJ?oYgbUo`00M?n]NicoYgbUol>AXP;oa9:R
0_oFVYD01?l006coc9RQomRKU?oHVi@2ojUkXP05onJYT_omaX?oc9ZSolbJXooijYL00_oNXY@00ool
cf[o[WbNonbaT`03omVNU`;om[j?00CooM5_olbBUoo<TYOoc9:G1?o3Sih2ooW?W@03o`000?o2S9_o
`XbK00;oEdNT1?nGMJ/01_oKXYWof9bEomRLUOoS`d?oYGZTojf7[@;oiZZB00Coo/a]omZQVOnQP:oo
eYjK0_ok`XL3omVNUPCoeYbH00?obY6Hog=GXomcEj<01?n>JJ@4ojamXP?oED>P00?oGd^SooFmSooG
W9H00ooGW9H2onBXT`03okb6VoondY7odibL00?odibL00?oh:VKooooooooool0;_ooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00Cooooo000booooo`03o`000?oooooooooo01gooooo
0_mF?9L4oiicXP?oS6RS00Co[H2UoiU`XonIL:?o_I>/0_ooool2ogEMZ@CoZX2V0_n7IJD3oiYbX`Co
YGRR00Co>bZCoheVX?n=IZ3oSFJP1?nUN:43ofa?W`;oPV6S0_nWO:D00on]NicoYgbUol>AXP02olBB
XP;oeYZE00Co`9N]olbHXOoHViCof9^D0onYNj801?omaX?oc9ZSolbJXooijYL2omjRU0?o[WbN0ooI
WYL2ooJnS`05oogAKoo<TYOoc9:GolbBUol00XD00oo3Sih2ooW?W@Co`XbK00?oEdNToiMeZonGMJ/0
0_nGMJ/01?ondgCof9bEomRLUOnUNZ@2ojf7[@;oiZZB00Coo/a]omZQVOnQP:ooXH2_0_ok`XL3omVN
UP?oeYbH00CocKP_olZAV?mcEj?oLeNS1?n>JJ@4ojamXP?oED>P0_mOBj<4omNLUP;oi:RC0_ondY43
om>LW003on2YVooooooooooo02oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`04
ooooo`00<oooool00ol0003oooooooooo`0Looooo`;oESbG1?nNLj82ohaXX`;oZG^Q00?oVG2SokfC
[?ooool00_ooool2ogEMZ@CoZX2V0_n7IJD3oiYbX`?oYGRR00?o/I2doc/ZTon=IZ000_n=IZ04ojEh
X@?oK4nO0on2HJ<00onWO:Go[G^LojMlY@02ol>AXP05olBBX_omhigoeYZEol2G[Ol006`00_oHVi@3
ojUkXP;oc9ZS0_oijYL00ol91h?oo<mZojilWP02ojilWP?ofIjG00?om[j?oogAKoomdFl00oo<TYL0
1?l00XGo`hnNol>?W_o3Sih2ooW?W@Co`XbK00?onlbEoeM7Y?nGMJ/00_nGMJ/01?ondgCof9bEomRL
UOn1K;82ojf7[@;oiZZB00Coo/a]omZQVOnQP:ooXH2_0_ok`XL3omVNUP?oeYbH00?ocKP_olZAV?o:
TIP00_mcEj<3ohiYY0Co[7fR00?o]XRToeE3X?mE@j000_mOBj<4omNLUP;oi:RC00?oPfJYombPU?oC
W9`00_oCW9`cooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool003Cooooo
0_l0000Mooooo`;oESbG0onNLj801?maDIgoZG^QojUkXOnYNj45ooooo`;oMEfY0onZP:H00om9?9oo
QfFUohMUY@03oiYbX`;oYGRR0_nAO[/2oc/ZT`;oSFJP1OnUN:42ofa?W`?oPV6S0onWO:D2ol>AXP07
oogSWOo0Ujgo`9N]ol2G[Ol006cof9^Don_8CP03ojUkXP06okJ4Woo<VZ?onNZGok>4Xol91h?oo<mZ
0on^O9h3omVNU`03ooJnSoomdFooc9:G00Coc9:G0oo3Sih2ooW?W@Co`XbK00ConlbEomJOW?nGMJ_o
UgF[0_nKO;000on1K;;ohl=3oh5//P03ojf7[@;oo/a]0_mdEj<3oi1ZX`?ofIjF0ooFW9P4olZAV003
og=GXon>JJCoSVVT00;oSVVT0_n/OJ83okJ8Y003oeE3X?mOBj?oGd^S00CoeibF0_oTZ9<2oh=VZ@?o
dibL=?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo000fooooo`03o`00
0?oooooooooo01_ooooo00?oESbGoiicX_nNLj800_maDId3ojUkX@Kooooo00CoMEfYojZ0Y_nZP:Ko
oooo0_m9?9l01On7IJGoVW:SoiYbXonJLZ?oYGRR00?oTGjk00?o/I2doc/ZTon=IZ000_n=IZ04ojEh
X@;oK4nO0on2HJ<4ojMlY@03ol>AX_o0Ujgo`9N]00?o`9N]00?oc9RQon_8C_nYNj800_nYNj800ooL
k]koc9ZSonS8]002ok>4X`04o`T7Pon^O9ko[WbNojilWP?ofIjG00?om[j?oogAKoo<TYL01?o<TYL2
ol>?WP;onLnM00Co0000ol:<Voo2S9_o`XbK0_okc9D2omJOW0CoVgb`00?ohl=3oh5//_n1K;800_n]
Qjd00oonc6go[HN]ooooo`02ogAGX`;oT6ZS0ooIWYH3omJLV0CobY6H00?olLaHohiYY?n>JJ@00_n>
JJ@01On/OJ;oTFjXoi5^Z?nfR:CoVg:S00;oED>P0_mOBj<3omNLUP05onBXToooooooooooooooool0
04L00_oCW9`eooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool003Oooooo
00?o0000ooooooooool06oooool01?nNLj;oooooog5AWOmaDId2ojUkX@Sooooo00?oZX2Voooooooo
ool00_m9?9l00onFLJKoVW:SoiYbX`02ofiCXP?oTGjk00?o/I2doc/ZTon=IZ000_n=IZ04ojEhX@;o
K4nO0on2HJ<4ojMlY@03oin1/oo0Ujgo`9N]00?o`9N]00Coc9RQoiYbY?nYNj;oZG^R0_oLk]h01OnR
NJKo/hBSok>4XoncQ:?o2@N300?o[WbN0_oIWYL2ooJnS`03oogAKoo<TYOoc9:G00;oc9:G00?okkJB
ol>?W_o3Sih00_oicid01?m3<9Go`XbKol:<Voo2S9/2oo_<U@?oeYnL0onKO;03oh5//P;o[HN]00Go
o/a]ojf7[OooooooooooogAGX`02oi1ZX`03olj80?oIWYKofIjF00?oeYbH1?o:TIP01_oac5Sooooo
of58W_m[E:GoSVVTojamXP;oTFjX00Co]XRToi]bXoniQj7oED>P0_mOBj<3omNLUP03onBXTooooooo
oooo00;ooooo0_oCW9`eooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool0
03Sooooo00?o0000ooooooooool07Oooool00omaDIgoZG^Qooooo`0;ooooo`;oBCbO0onFLJH2ofiC
XP?oT6^T00?oYG^Toc/ZTon=IZ000_n=IZ04ojEhX@03olfY]Om/CiooK4nO00;oPV6S1?nWO:D2oin1
/`?o`9N]0onJLZ@00onYNj;og>kNomc^gP02oj9iYP?o/hBS00Co2@N3ojilW_n^O9ko[WbN0_oIWYL2
ooJnS`03oogAKoo<TYOoc9:G00;oc9:G00?okkJBo`02QOo3Sih00_oicid01?m3<9Go`XbKol:<Voo2
S9/2oo_<U@?oeYnL0_nKO;03oljGW004oh5//_n]Qjgo[HN]ojf7[@Cooooo0on@JZ<2omVNUP03oooo
oooFW9SoeYbH00CobY6H00ColLaHoooooomQB9koHDRN1?nAKZP01?nfR:CoVg:Soi]bXoniQj42oem;
X`?oeibF00?oI5R_ooooooooool00_ooool2om>LW3Kooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`03ooooo`00>Oooool2o`0001kooooo00?oZG^Qooooooooool02_ooool2odTlW`?o
UW6V0_m^Dj83oi1[Y003ojEkY?lk:Y?oSFJP00;oSFJP1?nUN:42olfY]@04ofa?Won2HJ?oPV6Soh9Q
X`?oYgbU0_nOPK<2ol2G[@?oQfb]0on=KJX3oj9iYP?o/hBS00Ko2@N3ojilW_n^O9kof;FeonZR9?oI
WYL2ooJnS`03oogAKoo<TYOoc9:G00;oc9:G0_o_]Y801?o3SikonLnMooW?WOm3<9D3ol:<V`;onlbE
0ooFWi`2omnYW0?ocYNL00?oooooojf7[Oooool02?ooool2omVNUP03oooooooFW9SoeYbH00CobY6H
0oooool01?mQB9koOUfRogiMX_mnGJ84oi]bX`04okV7XOmOBj?oGd^Soem;X`;oeibF1Oooool2om>L
W3Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`00>oooool00ol0003o
ooooooooo`0Xooooo`?oBCbO0_nFLJH2ofiCXP?oT6^T0_nUNj@3oheVX0?oYGRQ00CoVHS1olfY]Onl
SjKo_8nV0on2HJ<2ojMlY@?oWh6c00?o`9N]olFFY_n7K:d00_n7K:d3ohe]ZP?oXWVV0oncQ:<00ol9
1h?o[WbNojilWP02omRe]@04omVNUoof_Xoom[j?okb9W`Coc9:G0_o_]Y82ooW?W@03odPmXOm3<9Go
`XbK00;o`XbK00?onlbEomJOW?oFWi`00_oFWi`01?oOZIcoBCjRoljGW?o>Ui`<ooooo`;ofIjF00?o
ooooomJLV?oFW9P00oo:TIP00ooac5Soooooooooo`02ooooo`?oOUfR1?nKLZ<01OniQj7ooooooem;
XomOBj?oeibF00Kooooo00?odibLooooooooool0=oooool01Ol0003ooooooooooooooooo000000Go
oooo000looooo`03o`000?oooooooooo02Sooooo0_m9?9l2oiIaYP?oKU>R0on@Jj@01?nUNjCoSFJP
oheVX?n=IZ02ojEhX@03oiV8`OnMN:So_8nV00Co_8nV00?oPfbaojMlYOn3K;400_nOPK<01?okjJ7o
aIJVolFFY_o5UZH2ohM/[@?oSFfZ0onRNJH4ok>4X`08ojilW_oH]KGof;FeomRe]OoIWYOom[j?oogA
KonlRIl4olbBU`;okkJB0_oIWYL01?m8?J7o@c2Eod<`UOo2S9/2oo_<U@CoeYnL00CogjVLodTnX_o>
UicocYNL3?ooool00ooIWYKoooooooooo`02omJLV0?obY6H00?olLaHooooooooool01?ooool2ogiM
XP;oVg:S1?ooool00omOBj?oeibFooooo`0oooooo`05o`000?ooooooooooooooool000001Oooool0
03gooooo00?o0000ooooooooool0:?ooool01?m9?9ooUW6VoiIaY_nFLJH2ofiCXP?oT6^T1?nUNj@0
1?nUN:7oWGRXoiehZ?nMN:P5okb?YP06omWWO_nZOJ?o^hZQoin1/onkRZ7onnVQ0oo5UZH3ohM/[@;o
SFfZ1?nRNJH3ok>4X`04ojilW_oH]KGof;FeomRe]@;om[j?00?ooM5_okb9WonlRIl00oo<TYL2onnf
TP;ofIjG00CoB3fQod<`UOm3<9Go`XbK0_okc9D4omJOW004omnYW?oooooocYNLoljGW0cooooo00Ko
cXP0ooooooooooooeYbHolfh;ol00442olZAV003oo7<F?oooooooooo00Kooooo00?oVg:Soooooooo
ool01?ooool00omOBj?oooooooooo`0oooooo`04o`000?ooooooooooo`0000Gooooo000nooooo`;o
0000:?ooool01?m9?9ooUW6VoiIaY_nFLJH2ofiCXP?oT6^T1?nUNj@00ol[9IKoWGRXoiehZ002oieh
Z0Co_8nV0_nZOJ<3ok^:X@CoaIJV0on7K:d2ohe]ZPCoXWVV1?ncQ:<2omRe]@03ok21X_of_Xoom[j?
00?o_8VO0oo<TYL2onnfTP;ofIjG0_m8?J401?m3<9Go`XbKoo_<UOokc9D3omJOW0;ogjVL00?ooooo
odTnX_o>Ui`04_ooool2olZAV003oo7<F?oooooooooo053ooooo00?o0000ooooool000001Oooool0
043ooooo00?o0000ooooooooool09_ooool3oiIaYP;oKU>R0on@Jj@4ojEkY0;o:bFF0onMN:P3okb?
YP06omWWO_nZOJ?oZWfSojYmXonkRZ7onnVQ1?o5UZH3ohM/[@?oSFfZ0onRNJH4ok>4X`03o`00I_oH
]KGo/86R00;o/86R0onlRIl2olbBU`;okkJB0ooIWYL01?oH_3OoB3fQod<`UOo2S9/2oo_<U@?oeYnL
0_oOZI`00oooooooBCjRoljGW00Booooo`;obY6H00?olLaHooooooooool0D?ooool00ol0003ooooo
o`000005ooooo`00@Oooool00ol0003oooooooooo`0Wooooo`03ocBdjOm^Dj;oKU>R00?oT6^T1?nU
Nj@2ob/UUP?oWGRX0onlSjH01OoIigkoZWfSojYmXonZOJ?o^hZQ00GoaIJV0_nnTJP01?n7K:goSFfZ
ohe]Z_n=KJX3oj9iYP?o/hBS0_naQ:@4ok21XP?o_8VO0_o<TYL2onnfTP?ofIjG0_oSYi@00om3<9Go
`XbKoo_<U@04omJOW003omnYW?oooooooooo01Cooooo0_o:TIP00ooac5Soooooooooo`1Aooooo`03
o`000?oooooo000000Cooooo0012ooooo`03o`000?oooooooooo02Oooooo00?oHT>GofiCX_m^Dj80
0on@Jj@3ojEkY003on?ge_l[9IKoWGRX00;oWGRX0_nlSjH00ooIigkoZWfSojYmX`02ojYmX`03ok^:
XOo5UZKoaIJV00?oaIJV00?o/Xf_okjAZ?nLLj<00on=KJX3oj9iYP;o/hBS00?oUg:Wok64Y?naQ:@0
1?n`PJ83okb9W`;oc9:G0_o_]Y83omVNU`;ohjND00?oeKTaoo_<UOokc9D01?oFWi`Gooooo`;obY6H
EOooool2o`0000Cooooo0013ooooo`03o`000?oooooooooo02Kooooo00?oHT>Goi=XW_m^Dj800on@
Jj@2ojEkY003on?ge_nKL:3o:bFF00CoWGRX00?o_8nVomWWO_nZOJ<00onZOJ<2okR?[0?oaIJV0_nb
SJl01OnnTJSoW7>SoiacXonXNj7oSFfZ00?oXWVV00Go/hBSoiMbYonGLZOoUg:Wok64Y004ok21XP?o
_8VO0_o<TYL2onnfTP?ofIjG0_oSYi@00ooE^C7onlbEoaPOV@04omJOW1Oooooo0_o:TIQDooooo`?o
00001?ooool004Cooooo0_l0000Vooooo`;oHT>G00GoTfRNoi1[Y?n@JjCoT6^TojEkY002on?geP;o
Vg2P1?nMN:P00onlSjKoKU6OojYmX`02ojYmX`?o^8n/0oo5UZH00onbSJooHdbQoiacX`02oiacX`;o
Z7^Q0_nRNJH00ombDikoNEnXoiMbY`02oiMbY`03ok64Y?l006Ko/86R00;o/86R0_nlRIl00onhRJCo
c9:GolbBU`02onnfTP;ofIjG00Kof;`gon>WU?oSYiCoeKTaomjRUOlH7iT3omJOW1Sooooo0_o:TIQ@
ooooo`Co00001oooool004Kooooo00?o0000ooooooooool08oooool2of93U`?oTfRN0_n1Fid4oi]`
X006ob/UU_nMN:SoWGRXoiehZ?o3U:OoKU6O0_nZOJ<4okR?[0;oaIJV00?o/Xf_of=<XOmSC:400onL
Lj<3ojQkX@?oLU>N0onGLZL00onaQ:Co001Vok21XP03ok21XP05okb9WonhRJCoc9:GolbBUoo_]Y80
0ooIWYL00ooH_3OohjNDon>WU003omjRU@03oaPOVOoFWicoeYnL01Sooooo00?o0011oo7<F?ooool0
Boooool4o`0000_ooooo0017ooooo`03o`000?oooooooooo02;ooooo0_mR@iL3oi=XWP?oPE^M0onK
L:000ol[9IKoWGRXoiehZ003ol>DY`03ojYmXomSF;3o^8n/00Co^8n/00CoaIJVooooooooooooHdbQ
0onLLj<2ojQkX@;ooooo0_mbDih3ogaJW`;oUFbQ1?n`PJ801OnlRIoo^8VTolbBUoo<TYOokkJB00?o
fIjG00?of;`gon>WU?oSYi@00ooNXYD00olH7iWoeYnLomJOW00Iooooo`03oo7<F?oooooooooo04Ko
oooo1?l0000?ooooo`00B?ooool00ol0003oooooooooo`0Rooooo`04of93UonCJ9koTfRNoi=XWP?o
PE^M0onKL:000on]OZ3oWGRXooKW]P04ol>DY`;oHeR`1?nhSj`01?o5UZKooooooooooomSC:43oiac
X`03ojQkXOoooooooooo00;ooooo00CoLU>NogaJWomlFYooO5ZO0_nEK:44ok21XP?o^8VT00?oc9:G
onnfT_oIWYL00_oIWYL00ooH_3OohjNDon>WU003omjRU@03oooooooFWicoeYnL05kooooo1?l0000C
ooooo`00BOooool2o`0002;ooooo00CoHT>Goi=XW_nCJ9koTfRN0on1Fid3oi]`X003ojenX?ofikKo
m^Nf00Co`iBW0_mSF;04okR?[0Cooooo0_nLLj<6ooooo`04og9CW_mlFYooO5ZOogaJW`;oUFbQ1?n`
PJ83okR9Y0;okkJB0ooIWYL00ooH_3OohjNDon>WU003omjRU@03oooooooFWicoeYnL05_ooooo0ol0
000Gooooo`00Boooool00ol0003oooooooooo`0Oooooo`04of93UonCJ9koTfRNoi=XWP?oPE^M0onK
L:000on]OZ3oe_7Tol>DY`04ol>DY`03ol2I[omSF;3o^8n/00?o^8n/3Oooool3ogaJW`;oUFbQ1?n`
PJ83okR9Y0;okkJB0ooIWYL00ooH_3OohjNDon>WU003omjRU@03oooooolH7iWooooo05Oooooo1?l0
000Jooooo`00C?ooool00ol0003oooooooooo`0Nooooo`04oe4nWOnCJ9koTfRNoi=XWP?oPE^M0onK
L:02omKai0Go`iBW00?o`9V_ok24Y_mSF;000_nhSj`?ooooo`;oO5ZO0_nEK:43ok21XP?o^8VT00?o
^HRQonnfT_o_]Y800ooIWYL3on>WU0?ogZ:EE_ooool4o`0001kooooo001=ooooo`03o`000?oooooo
oooo01kooooo0_nCJ9h3ojBch`03oh5KWOnKL:3oVg2P00;oe_7T0_n`QjX3ol>DY`05ol2I[ooooooo
oooooooooonhSj`04Oooool01?mlFYooUFbQoiE/XOnEK:42ok21XP?o^8VT00?o^HRQonnfT_oIWYL0
0ooIWYL3on>WU003oooooooNXYGogZ:E05;ooooo1?l0000Rooooo`00C_ooool2o`0001kooooo00Oo
DCjMojBchonT/n?oY;?Soj1hY_n<K:WoVg2P00;oe_7T0on`QjX3ol>DYaOooooo0_nEK:402?oooooo
/86Rooooool005Co^8VTooooool007ko^HRQ0ooIWYL01OoH_3OohjNDon>WU?oSYiCooooo00;ogZ:E
C_ooool4o`0002Kooooo001@ooooo`03o`000?oooooooooo01_ooooo0_mA?Yd00onT/n?oX7RVoj1h
YP03oha/Z@Co/8NZ0oo3U:LJooooo`07ok21X_oooooooooookR9Y?oooooo001nokV8X@03omVNU`05
omRl=ooSYiCohjNDon>WU?ooool00_oNXYE:ooooo`Co0000:_ooool0057ooooo00?o0000oooooooo
ool06_ooool2oe4nW@CoX7RV0_n<K:T4ok27ZP;o`iBW7_ooool01?nhRJCoooooo`00O_niR:43omVN
U`06omRl=ooSYiCohjNDomFi<OoooooogZ:EAoooool4o`0002kooooo001Booooo`03o`000?oooooo
oooo01Wooooo0_mA?Yd4oj1hYP?oS6bY1?n`QjX00oo3U:Ooooooooooo`0Nooooo`03o`00O_niR:7o
fIjG00;ofIjG00?of;`goooooooSYi@00_ooool00ooNXYGoooooooooo`11ooooo`Co0000<_ooool0
05?ooooo0_l0000Jooooo`;oDCjM0onPN:H3oha/Z@Co/8NZ00?o`iBWooooooooool07oooool01oni
R:7oooooomVNUooIWYOof;`goooooooSYi@0@_ooool4o`0003Kooooo001Eooooo`03o`000?oooooo
oooo01Oooooo0_mA?Yd3oj1hYP?oS6bY1?n`QjXTooooo`;ofIjG0_ooool00ooSYiCoooooooooo`0l
ooooo`Co0000>_ooool005Kooooo00?o0000ooooooooool05_ooool2oe4nW@?oX7RV0on<K:T4ok27
ZRCooooo0_oIWYLmooooo`Co0000?_ooool005Oooooo00?o0000ooooooooool05Oooool2oe4nW@Co
X7RV0on<K:T2ok27ZRGooooo0_oIWYLjooooo`?o0000@_ooool005Sooooo0_l0000Fooooo`03oe4n
WOnPN:KoX7RV00;oX7RV0on<K:T00on`Qj[oooooooooo`0Tooooo`;ofIjG=_ooool4o`0004Gooooo
001Jooooo`03o`000?oooooooooo01Cooooo00CoDCjMoj1hY_nPN:KoX7RV0oooool00ol0003ooooo
ooooo`0Uooooo`03omRl=ooooooooooo033ooooo1?l00019ooooo`00Foooool00ol0003ooooooooo
o`0Cooooo`03oe4nWOnPN:KoX7RV00Cooooo00?o0000ooooooooool0E?ooool4o`0004gooooo001L
ooooo`03o`000?oooooooooo01?ooooo00?oX7RVooooooooool00oooool00ol0003oooooooooo`1@
ooooo`Co0000DOooool005gooooo0_l0000Iooooo`03o`000?oooooooooo04cooooo1?l0001Eoooo
o`00Goooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo04Sooooo1?l0001Iooooo`00
H?ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo04Cooooo1?l0001Mooooo`00HOoo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo043ooooo1?l0001Qooooo`00H_ooool2
o`0001Cooooo00?o0000ooooooooool0??ooool4o`0006Gooooo001Tooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0>Oooool3o`0006Wooooo001Uooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool0=Oooool4o`0006cooooo001Vooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool0<Oooool4o`00073ooooo001Wooooo`03o`000?oooooooooo00gooooo00?o
0000ooooooooool0;_ooool4o`0007Cooooo001Xooooo`;o00003Oooool00ol0003oooooooooo`0Z
ooooo`Co0000N?ooool006[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Voooo
o`Co0000O?ooool006_ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Rooooo`Co
0000P?ooool006cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Nooooo`Co0000
Q?ooool006gooooo0_l00008ooooo`03o`000?oooooooooo01[ooooo1?l00028ooooo`00Koooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo1?l0002<ooooo`00L?ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo01;ooooo1?l0002@ooooo`00LOooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00oooooo0ol0002Dooooo`00L_ooool2o`0000?ooooo
00?o0000ooooooooool02oooool4o`0009Oooooo001dooooo`04o`000?ooooooooooo`0000Wooooo
1?l0002Kooooo`00MOooool00ol0003oooooo`000005ooooo`Co0000Woooool007Kooooo0_l00000
0ooooooo0000o`000002o`000:?ooooo001gooooo`;o0000Yoooool00001\
\>"],
  ImageRangeCache->{{{74.875, 361.875}, {502.688, 270.125}} -> {-0.301987, \
0.969008, 0.00350305, 0.00350305}},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "Here we use ",
  StyleBox["RandomSearch.", "MR"]
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[f, {x, y}, Method \[Rule] "\<RandomSearch\>"]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({\(-2.905187040207686`\), {x \[Rule] \(-0.3945316888405724`\), 
        y \[Rule] \(-0.7211870385307986`\)}}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "Here we use ",
  StyleBox["RandomSearch", "MR"],
  " with more starting points and find the global minimum. "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[f, {x, y}, 
      Method \[Rule] {"\<RandomSearch\>", "\<SearchPoints\>" \[Rule] 
            250}]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({\(-3.3068686474752393`\), {x \[Rule] \(-0.02440307968908496`\), 
        y \[Rule] 0.2106124271495502`}}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Automatic", "SubsubsectionIcon",
  CellGroupingRules->{"SectionGrouping", 73},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "With ",
  StyleBox["Method", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["NMinimize", "MR"],
  " picks which method to use based on the type of problem. If the objective \
function and constraints are linear, ",
  StyleBox["LinearProgramming", "MR"],
  " is used. If there are integer variables, or if the head of the objective \
function is not a numeric function, ",
  StyleBox["DifferentialEvolution", "MR"],
  " is used. For everything else, it uses ",
  StyleBox["NelderMead", "MR"],
  ", and if ",
  StyleBox["NelderMead", "MR"],
  " does poorly, it tries ",
  StyleBox["DifferentialEvolution", "MR"],
  ". "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell["\<\
This is a contour plot of a function in two variables over the unit \
disk. \
\>", "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[rainbow];\)\), "\n", 
    \(rainbow[a_] := Hue[0.75\ a, \  .5, 1]\), "\n", 
    \(ContourPlot[
      If[x\^2 + y\^2 \[LessEqual] 1, 100\ \((y - x\^2)\)\^2 + \((1 - x)\)\^2, 
        150], {x, \(-1\), 1}, {y, \(-1\), 1}, 
      Contours \[Rule] \[ExponentialE]\^Range[\(-1\), 5, 0.333], 
      ColorFunction \[Rule] rainbow, PlotPoints \[Rule] 250]\)}], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.480769 0.5 0.480769 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -12 -9 ]
[.25962 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -24 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-1)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(0.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(1)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-1)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-0.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(0.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.75 .5 1 r
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.5 .661 1 r
.44015 .01934 m
.44401 .01934 L
.44787 .01934 L
.45173 .01934 L
.45559 .01934 L
.45945 .01934 L
.46331 .01934 L
.46718 .01934 L
.47104 .01934 L
.4749 .01934 L
.47876 .01934 L
.48262 .01934 L
.48648 .01934 L
.49035 .01934 L
.49421 .01934 L
.49807 .01934 L
.50193 .01934 L
.50579 .01934 L
.50965 .01934 L
.51352 .01934 L
.51738 .01934 L
.52124 .01934 L
.5251 .01934 L
.52896 .01934 L
.53282 .01934 L
.53669 .01934 L
.54055 .01934 L
.54441 .01934 L
.54827 .01934 L
.55213 .01934 L
.55599 .01934 L
.55985 .01934 L
.56348 .02309 L
.56372 .02332 L
.56758 .02332 L
.57144 .02332 L
.5753 .02333 L
.57916 .02333 L
.58302 .02333 L
.58665 .02695 L
.58689 .02719 L
.59075 .02719 L
.59461 .02719 L
.59847 .0272 L
.60233 .0272 L
.60595 .03082 L
.60619 .03106 L
.61006 .03106 L
.61392 .03107 L
.61778 .03107 L
.62139 .03468 L
.62164 .03493 L
.6255 .03493 L
.62936 .03494 L
.63323 .03494 L
.63682 .03854 L
.63709 .0388 L
.64095 .0388 L
.64481 .03881 L
.6484 .0424 L
.64867 .04267 L
.65253 .04267 L
.65639 .04268 L
.65998 .04626 L
.66026 .04654 L
.66412 .04655 L
.66798 .04656 L
.67155 .05012 L
.67184 .05041 L
.6757 .05042 L
.67927 .05399 L
.67956 .05428 L
.68343 .05429 L
.68729 .0543 L
.69083 .05785 L
.69115 .05816 L
.69501 .05817 L
.69855 .06171 L
.69887 .06203 L
.70273 .06205 L
.70626 .06557 L
.7066 .0659 L
.71046 .06592 L
.71397 .06943 L
.71432 .06978 L
.71818 .0698 L
.72168 .07329 L
.72204 .07366 L
.7259 .07368 L
.72938 .07715 L
.72977 .07754 L
.73363 .07756 L
.73708 .08102 L
.73749 .08142 L
.74135 .08145 L
.74478 .08488 L
.74521 .08531 L
.74864 .08874 L
.74907 .08917 L
.75293 .08921 L
.75633 .0926 L
.7568 .09307 L
.76066 .09311 L
.76401 .09646 L
.76452 .09698 L
.76787 .10032 L
.76838 .10084 L
.77224 .10089 L
.77553 .10419 L
.7761 .10476 L
.77939 .10805 L
.77997 .10863 L
.78324 .11191 L
.78383 .1125 L
.78769 .11258 L
.79087 .11577 L
.79155 .11646 L
.79472 .11963 L
.79541 .12034 L
.79856 .12349 L
.79927 .12422 L
.80314 .12435 L
.80614 .12736 L
.807 .12825 L
.80996 .13122 L
.81086 .13215 L
.81378 .13508 L
.81472 .13605 L
.8176 .13894 L
.81858 .13997 L
.8214 .1428 L
.82244 .1439 L
.8252 .14666 L
.82631 .14783 L
.82898 .15053 L
.83017 .15179 L
.83403 .15235 L
.83604 .15439 L
.83789 .15648 L
.83962 .15825 L
.84175 .16074 L
.84308 .16211 L
.84561 .16521 L
.84633 .16597 L
.84747 .16983 L
.84947 .17218 L
.85094 .17369 L
.85334 .17663 L
.85421 .17756 L
.85708 .18142 L
.8572 .18157 L
.85928 .18528 L
.86106 .18745 L
.86212 .18914 L
.86482 .193 L
.86492 .19316 L
.86736 .19686 L
.86878 .19905 L
.86974 .20073 L
.87238 .20459 L
.87264 .20499 L
.87487 .20845 L
.87651 .211 L
.87734 .21231 L
.87979 .21617 L
.88037 .21708 L
.88223 .22003 L
.88423 .22321 L
.88466 .2239 L
.88707 .22776 L
.88809 .22941 L
.88946 .23162 L
.89184 .23548 L
.89195 .23567 L
.8942 .23934 L
.89581 .24199 L
.89655 .2432 L
.89889 .24707 L
.89968 .24837 L
.90121 .25093 L
.90352 .25479 L
.90354 .25482 L
.90581 .25865 L
.9074 .26133 L
.9081 .26251 L
.91037 .26637 L
.91126 .2679 L
.91262 .27023 L
.91487 .2741 L
.91512 .27453 L
.9171 .27796 L
.91898 .28123 L
.91932 .28182 L
.92153 .28568 L
.92285 .28799 L
.92373 .28954 L
.92592 .2934 L
.92671 .29481 L
.92809 .29727 L
.93025 .30113 L
.93057 .30169 L
.93241 .30499 L
.93443 .30863 L
.93453 .30885 L
.93668 .31271 L
.93829 .31564 L
.93872 .31657 L
.94017 .32044 L
.94215 .32271 L
.94288 .3243 L
.94468 .32816 L
.94601 .32984 L
.94702 .33202 L
.94903 .33588 L
.94988 .33703 L
.95108 .33974 L
.95326 .34361 L
.95374 .34428 L
.95508 .34747 L
.95586 .35133 L
.9576 .35364 L
.95906 .35519 L
.95977 .35905 L
.96015 .36291 L
.96146 .3645 L
.96367 .36677 L
.96404 .37064 L
.96427 .3745 L
.96443 .37836 L
.96532 .37937 L
.96815 .38222 L
.9683 .38608 L
.96841 .38994 L
.9685 .39381 L
.96918 .39456 L
.97228 .39767 L
.97237 .40153 L
.97244 .40539 L
.97249 .40925 L
.97254 .41311 L
.97305 .41366 L
.97635 .41698 L
.9764 .42084 L
.97644 .4247 L
.97647 .42856 L
.9765 .43242 L
.97652 .43628 L
.97691 .43669 L
.98056 .44015 L
.98057 .44401 L
.98059 .44787 L
.9806 .45173 L
.98061 .45559 L
.98061 .45945 L
.98062 .46331 L
.98063 .46718 L
.98063 .47104 L
.98064 .4749 L
.98065 .47876 L
.98065 .48262 L
.98065 .48648 L
.98066 .49035 L
.98066 .49421 L
.98067 .49807 L
.98067 .50193 L
.98067 .50579 L
.98067 .50965 L
.98068 .51352 L
.98068 .51738 L
.98068 .52124 L
.98068 .5251 L
.98069 .52896 L
.98069 .53282 L
.98069 .53669 L
.98069 .54055 L
.98069 .54441 L
.98069 .54827 L
.9807 .55213 L
.9807 .55599 L
.9807 .55985 L
.97691 .56357 L
.97677 .56372 L
.97677 .56758 L
.97677 .57144 L
.97677 .5753 L
.97678 .57916 L
.97678 .58302 L
.97305 .58676 L
.97292 .58689 L
.97292 .59075 L
.97292 .59461 L
.97293 .59847 L
.97293 .60233 L
.96918 .60608 L
.96907 .60619 L
.96907 .61006 L
.96907 .61392 L
.96907 .61778 L
.96532 .62153 L
.96522 .62164 L
.96522 .6255 L
.96522 .62936 L
.96522 .63323 L
.96146 .63698 L
.96136 .63709 L
.96136 .64095 L
.96136 .64481 L
.9576 .64857 L
.9575 .64867 L
.9575 .65253 L
.9575 .65639 L
.95374 .66016 L
.95364 .66026 L
.95364 .66412 L
.95365 .66798 L
.94988 .67175 L
.94979 .67184 L
.94979 .6757 L
.94601 .67947 L
.94593 .67956 L
.94593 .68343 L
.94593 .68729 L
.94215 .69106 L
.94207 .69115 L
.94207 .69501 L
.93829 .69879 L
.93821 .69887 L
.93821 .70273 L
.93443 .70651 L
.93435 .7066 L
.93435 .71046 L
.93057 .71424 L
.93049 .71432 L
.93049 .71818 L
.92671 .72196 L
.92663 .72204 L
.92663 .7259 L
.92285 .72968 L
.92277 .72977 L
.92277 .73363 L
.91898 .73741 L
.9189 .73749 L
.9189 .74135 L
.91512 .74513 L
.91504 .74521 L
.91126 .749 L
.91118 .74907 L
.91118 .75293 L
.9074 .75672 L
.90732 .7568 L
.90732 .76066 L
.90354 .76444 L
.90346 .76452 L
.89968 .7683 L
.8996 .76838 L
.8996 .77224 L
.89581 .77603 L
.89574 .7761 L
.89195 .77989 L
.89188 .77997 L
.88809 .78375 L
.88802 .78383 L
.88802 .78769 L
.88423 .79148 L
.88415 .79155 L
.88037 .79534 L
.88029 .79541 L
.87651 .7992 L
.87643 .79927 L
.87643 .80314 L
.87264 .80692 L
.87257 .807 L
.86878 .81078 L
.86871 .81086 L
.86492 .81464 L
.86485 .81472 L
.86106 .81851 L
.86098 .81858 L
.8572 .82237 L
.85712 .82244 L
.85334 .82623 L
.85326 .82631 L
.84947 .83009 L
.8494 .83017 L
.8494 .83403 L
.84561 .83781 L
.84554 .83789 L
.84175 .84167 L
.84167 .84175 L
.83789 .84554 L
.83781 .84561 L
.83403 .8494 L
.83017 .8494 L
.83009 .84947 L
.82631 .85326 L
.82623 .85334 L
.82244 .85712 L
.82236 .8572 L
.81858 .86098 L
.8185 .86106 L
.81472 .86484 L
.81464 .86492 L
.81086 .8687 L
.81078 .86878 L
.807 .87256 L
.80691 .87264 L
.80314 .87642 L
.79927 .87642 L
.79919 .87651 L
.79541 .88028 L
.79533 .88037 L
.79155 .88414 L
.79146 .88423 L
.78769 .888 L
.78383 .888 L
.78374 .88809 L
.77997 .89186 L
.77988 .89195 L
.7761 .89572 L
.77601 .89581 L
.77224 .89958 L
.76838 .89958 L
.76829 .89968 L
.76452 .90344 L
.76443 .90354 L
.76066 .9073 L
.7568 .9073 L
.7567 .9074 L
.75293 .91116 L
.74907 .91116 L
.74897 .91126 L
.74521 .91502 L
.74511 .91512 L
.74135 .91888 L
.73749 .91888 L
.73739 .91898 L
.73363 .92274 L
.72977 .92274 L
.72966 .92285 L
.7259 .9266 L
.72204 .9266 L
.72193 .92671 L
.71818 .93046 L
.71432 .93046 L
.71421 .93057 L
.71046 .93432 L
.7066 .93432 L
.70648 .93443 L
.70273 .93818 L
.69887 .93817 L
.69875 .93829 L
.69501 .94203 L
.69115 .94203 L
.69103 .94215 L
.68729 .94589 L
.68343 .94589 L
.67956 .94589 L
.67943 .94601 L
.6757 .94975 L
.67184 .94974 L
.67171 .94988 L
.66798 .9536 L
.66412 .9536 L
.66026 .9536 L
.66012 .95374 L
.65639 .95746 L
.65253 .95746 L
.64867 .95745 L
.64852 .9576 L
.64481 .96131 L
.64095 .96131 L
.63709 .96131 L
.63693 .96146 L
.63323 .96517 L
.62936 .96516 L
.6255 .96516 L
.62164 .96516 L
.62147 .96532 L
.61778 .96902 L
.61392 .96902 L
.61006 .96901 L
.60619 .96901 L
.60602 .96918 L
.60233 .97287 L
.59847 .97287 L
.59461 .97286 L
.59075 .97286 L
.58689 .97286 L
.5867 .97305 L
.58302 .97672 L
.57916 .97671 L
.5753 .97671 L
.57144 .97671 L
.56758 .97671 L
.56372 .97671 L
.56351 .97691 L
.55985 .98067 L
.55599 .98067 L
.55213 .98067 L
.54827 .98067 L
.54441 .98067 L
.54055 .98067 L
.53669 .98067 L
.53282 .98067 L
.52896 .98066 L
.5251 .98066 L
.52124 .98066 L
.51738 .98066 L
.51352 .98066 L
.50965 .98066 L
.50579 .98066 L
.50193 .98066 L
.49807 .98066 L
.49421 .98066 L
.49035 .98066 L
.48648 .98066 L
.48262 .98066 L
.47876 .98066 L
.4749 .98066 L
.47104 .98066 L
.46718 .98066 L
.46331 .98067 L
.45945 .98067 L
.45559 .98067 L
.45173 .98067 L
.44787 .98067 L
.44401 .98067 L
.44015 .98067 L
.43649 .97691 L
.43628 .97671 L
.43242 .97671 L
.42856 .97671 L
.4247 .97671 L
.42084 .97671 L
.41698 .97671 L
.41331 .97305 L
.41311 .97286 L
.40925 .97286 L
.40539 .97286 L
.40153 .97286 L
.39767 .97286 L
.39399 .96918 L
.39381 .96901 L
.38994 .96901 L
.38608 .96901 L
.38222 .96901 L
.37853 .96532 L
.37836 .96516 L
.3745 .96516 L
.37064 .96516 L
.36677 .96516 L
.36307 .96146 L
.36291 .96131 L
.35905 .96131 L
.35519 .96131 L
.35148 .9576 L
.35133 .95745 L
.34747 .95745 L
.34361 .95746 L
.33989 .95374 L
.33974 .9536 L
.33588 .9536 L
.33202 .9536 L
.3283 .94988 L
.32816 .94974 L
.3243 .94974 L
.32057 .94601 L
.32044 .94589 L
.31657 .94589 L
.31271 .94589 L
.30898 .94215 L
.30885 .94203 L
.30499 .94203 L
.30125 .93829 L
.30113 .93817 L
.29727 .93817 L
.29352 .93443 L
.2934 .93431 L
.28954 .93432 L
.2858 .93057 L
.28568 .93046 L
.28182 .93046 L
.27807 .92671 L
.27796 .9266 L
.2741 .9266 L
.27034 .92285 L
.27023 .92274 L
.26637 .92274 L
.26262 .91898 L
.26251 .91888 L
.25865 .91888 L
.25489 .91512 L
.25479 .91502 L
.25103 .91126 L
.25093 .91116 L
.24707 .91116 L
.2433 .9074 L
.2432 .9073 L
.23934 .9073 L
.23558 .90354 L
.23548 .90344 L
.23171 .89968 L
.23162 .89958 L
.22776 .89958 L
.22399 .89581 L
.2239 .89572 L
.22013 .89195 L
.22003 .89186 L
.21626 .88809 L
.21617 .888 L
.21231 .888 L
.20854 .88423 L
.20845 .88414 L
.20467 .88037 L
.20459 .88028 L
.20081 .87651 L
.20073 .87642 L
.19686 .87642 L
.19309 .87264 L
.193 .87256 L
.18923 .86878 L
.18914 .8687 L
.18536 .86492 L
.18528 .86484 L
.1815 .86106 L
.18142 .86098 L
.17764 .8572 L
.17756 .85712 L
.17378 .85334 L
.17369 .85326 L
.16991 .84947 L
.16983 .84939 L
.16597 .84939 L
.16219 .84561 L
.16211 .84553 L
.15833 .84175 L
.15825 .84167 L
.15447 .83789 L
.15439 .83781 L
.1506 .83403 L
.1506 .83017 L
.15053 .83009 L
.14674 .82631 L
.14666 .82623 L
.14288 .82244 L
.1428 .82237 L
.13902 .81858 L
.13894 .8185 L
.13516 .81472 L
.13508 .81464 L
.13129 .81086 L
.13122 .81078 L
.12743 .807 L
.12736 .80692 L
.12357 .80314 L
.12357 .79927 L
.12349 .7992 L
.11971 .79541 L
.11963 .79534 L
.11585 .79155 L
.11577 .79147 L
.11199 .78769 L
.11199 .78383 L
.11191 .78375 L
.10813 .77997 L
.10805 .77989 L
.10426 .7761 L
.10419 .77603 L
.1004 .77224 L
.1004 .76838 L
.10032 .7683 L
.09654 .76452 L
.09646 .76444 L
.09268 .76066 L
.09268 .7568 L
.0926 .75672 L
.08882 .75293 L
.08882 .74907 L
.08874 .74899 L
.08496 .74521 L
.08488 .74513 L
.0811 .74135 L
.0811 .73749 L
.08102 .73741 L
.07724 .73363 L
.07724 .72977 L
.07715 .72968 L
.07338 .7259 L
.07338 .72204 L
.07329 .72196 L
.06952 .71818 L
.06952 .71432 L
.06943 .71423 L
.06566 .71046 L
.06566 .7066 L
.06557 .70651 L
.0618 .70273 L
.0618 .69887 L
.06171 .69878 L
.05794 .69501 L
.05794 .69115 L
.05785 .69106 L
.05408 .68729 L
.05408 .68343 L
.05408 .67956 L
.05399 .67947 L
.05022 .6757 L
.05022 .67184 L
.05012 .67175 L
.04636 .66798 L
.04636 .66412 L
.04636 .66026 L
.04626 .66016 L
.0425 .65639 L
.0425 .65253 L
.0425 .64867 L
.0424 .64857 L
.03864 .64481 L
.03864 .64095 L
.03864 .63709 L
.03854 .63698 L
.03479 .63323 L
.03479 .62936 L
.03479 .6255 L
.03479 .62164 L
.03468 .62153 L
.03093 .61778 L
.03093 .61392 L
.03093 .61006 L
.03093 .60619 L
.03082 .60607 L
.02708 .60233 L
.02708 .59847 L
.02708 .59461 L
.02708 .59075 L
.02708 .58689 L
.02695 .58675 L
.02323 .58302 L
.02323 .57916 L
.02323 .5753 L
.02324 .57144 L
.02324 .56758 L
.02324 .56372 L
.02309 .56356 L
.01931 .55985 L
.01931 .55599 L
.01931 .55213 L
.01931 .54827 L
.01931 .54441 L
.01931 .54055 L
.01932 .53669 L
.01932 .53282 L
.01932 .52896 L
.01932 .5251 L
.01932 .52124 L
.01933 .51738 L
.01933 .51352 L
.01933 .50965 L
.01934 .50579 L
.01934 .50193 L
.01934 .49807 L
.01935 .49421 L
.01935 .49035 L
.01936 .48648 L
.01936 .48262 L
.01937 .47876 L
.01937 .4749 L
.01938 .47104 L
.01939 .46718 L
.0194 .46331 L
.01941 .45945 L
.01942 .45559 L
.01943 .45173 L
.01944 .44787 L
.01946 .44401 L
.01948 .44015 L
.02309 .43675 L
.02354 .43628 L
.02357 .43242 L
.02361 .42856 L
.02365 .4247 L
.02371 .42084 L
.02378 .41698 L
.02695 .41379 L
.02757 .41311 L
.02764 .40925 L
.02773 .40539 L
.02784 .40153 L
.028 .39767 L
.03082 .39482 L
.03171 .39381 L
.03186 .38994 L
.03209 .38608 L
.03244 .38222 L
.03468 .37993 L
.03597 .37836 L
.03633 .3745 L
.03699 .37064 L
.03846 .36677 L
.03854 .36668 L
.04092 .36291 L
.0424 .35919 L
.04249 .35905 L
.04469 .35519 L
.04626 .35181 L
.04659 .35133 L
.04874 .34747 L
.05012 .34449 L
.05059 .34361 L
.05282 .33974 L
.05399 .33723 L
.05471 .33588 L
.05678 .33202 L
.05785 .33004 L
.05886 .32816 L
.06095 .3243 L
.06171 .3229 L
.06305 .32044 L
.06516 .31657 L
.06557 .31583 L
.06728 .31271 L
.06942 .30885 L
.06943 .30882 L
.07156 .30499 L
.07329 .30188 L
.07371 .30113 L
.07588 .29727 L
.07715 .29499 L
.07805 .2934 L
.08024 .28954 L
.08102 .28817 L
.08243 .28568 L
.08464 .28182 L
.08488 .28141 L
.08686 .27796 L
.08874 .27471 L
.0891 .2741 L
.09134 .27023 L
.0926 .26808 L
.0936 .26637 L
.09587 .26251 L
.09646 .2615 L
.09815 .25865 L
.10032 .25499 L
.10045 .25479 L
.10276 .25093 L
.10419 .24855 L
.10508 .24707 L
.10741 .2432 L
.10805 .24216 L
.10976 .23934 L
.11191 .23584 L
.11213 .23548 L
.11451 .23162 L
.11577 .22957 L
.1169 .22776 L
.11931 .2239 L
.11963 .22338 L
.12173 .22003 L
.12349 .21724 L
.12417 .21617 L
.12662 .21231 L
.12736 .21116 L
.12909 .20845 L
.13122 .20515 L
.13158 .20459 L
.13409 .20073 L
.13508 .1992 L
.13661 .19686 L
.13894 .19331 L
.13915 .193 L
.1417 .18914 L
.1428 .18749 L
.14428 .18528 L
.14666 .18173 L
.14687 .18142 L
.14961 .17756 L
.15053 .17616 L
.1526 .17369 L
.15439 .17039 L
.15481 .16983 L
.15755 .16597 L
.15825 .165 L
.16077 .16211 L
.16211 .1593 L
.16295 .15825 L
.16564 .15439 L
.16597 .15403 L
.16983 .15238 L
.1715 .15053 L
.17369 .14831 L
.1752 .14666 L
.17756 .14429 L
.17894 .1428 L
.18142 .14031 L
.1827 .13894 L
.18528 .13635 L
.18648 .13508 L
.18914 .1324 L
.19027 .13122 L
.193 .12847 L
.19407 .12736 L
.19686 .12456 L
.20073 .12436 L
.20157 .12349 L
.20459 .12047 L
.2054 .11963 L
.20845 .11658 L
.20924 .11577 L
.21231 .1127 L
.21617 .11259 L
.21684 .11191 L
.22003 .10871 L
.22069 .10805 L
.2239 .10484 L
.22454 .10419 L
.22776 .10097 L
.23162 .1009 L
.23219 .10032 L
.23548 .09703 L
.23604 .09646 L
.23934 .09316 L
.2432 .09311 L
.24371 .0926 L
.24707 .08925 L
.25093 .08921 L
.2514 .08874 L
.25479 .08535 L
.25526 .08488 L
.25865 .08148 L
.26251 .08145 L
.26295 .08102 L
.26637 .07759 L
.27023 .07756 L
.27064 .07715 L
.2741 .0737 L
.27796 .07368 L
.27835 .07329 L
.28182 .06982 L
.28568 .0698 L
.28605 .06943 L
.28954 .06594 L
.2934 .06592 L
.29376 .06557 L
.29727 .06206 L
.30113 .06205 L
.30147 .06171 L
.30499 .05819 L
.30885 .05818 L
.30918 .05785 L
.31271 .05432 L
.31657 .0543 L
.32044 .05429 L
.32075 .05399 L
.3243 .05044 L
.32816 .05042 L
.32846 .05012 L
.33202 .04657 L
.33588 .04656 L
.33974 .04655 L
.34003 .04626 L
.34361 .04269 L
.34747 .04268 L
.35133 .04268 L
.35161 .0424 L
.35519 .03882 L
.35905 .03881 L
.36291 .03881 L
.36318 .03854 L
.36677 .03495 L
.37064 .03494 L
.3745 .03494 L
.37836 .03493 L
.37862 .03468 L
.38222 .03108 L
.38608 .03107 L
.38994 .03107 L
.39381 .03106 L
.39406 .03082 L
.39767 .02721 L
.40153 .0272 L
.40539 .0272 L
.40925 .02719 L
.41311 .02719 L
.41336 .02695 L
.41698 .02334 L
.42084 .02333 L
.4247 .02333 L
.42856 .02333 L
.43242 .02332 L
.43628 .02332 L
.43652 .02309 L
F
0 g
.44015 .01934 m
.44401 .01934 L
.44787 .01934 L
.45173 .01934 L
.45559 .01934 L
.45945 .01934 L
.46331 .01934 L
.46718 .01934 L
.47104 .01934 L
.4749 .01934 L
.47876 .01934 L
.48262 .01934 L
.48648 .01934 L
.49035 .01934 L
.49421 .01934 L
.49807 .01934 L
.50193 .01934 L
.50579 .01934 L
.50965 .01934 L
.51352 .01934 L
.51738 .01934 L
.52124 .01934 L
.5251 .01934 L
.52896 .01934 L
.53282 .01934 L
.53669 .01934 L
.54055 .01934 L
.54441 .01934 L
.54827 .01934 L
.55213 .01934 L
.55599 .01934 L
.55985 .01934 L
.56348 .02309 L
.56372 .02332 L
.56758 .02332 L
.57144 .02332 L
.5753 .02333 L
.57916 .02333 L
.58302 .02333 L
.58665 .02695 L
.58689 .02719 L
.59075 .02719 L
.59461 .02719 L
.59847 .0272 L
.60233 .0272 L
.60595 .03082 L
.60619 .03106 L
.61006 .03106 L
.61392 .03107 L
.61778 .03107 L
Mistroke
.62139 .03468 L
.62164 .03493 L
.6255 .03493 L
.62936 .03494 L
.63323 .03494 L
.63682 .03854 L
.63709 .0388 L
.64095 .0388 L
.64481 .03881 L
.6484 .0424 L
.64867 .04267 L
.65253 .04267 L
.65639 .04268 L
.65998 .04626 L
.66026 .04654 L
.66412 .04655 L
.66798 .04656 L
.67155 .05012 L
.67184 .05041 L
.6757 .05042 L
.67927 .05399 L
.67956 .05428 L
.68343 .05429 L
.68729 .0543 L
.69083 .05785 L
.69115 .05816 L
.69501 .05817 L
.69855 .06171 L
.69887 .06203 L
.70273 .06205 L
.70626 .06557 L
.7066 .0659 L
.71046 .06592 L
.71397 .06943 L
.71432 .06978 L
.71818 .0698 L
.72168 .07329 L
.72204 .07366 L
.7259 .07368 L
.72938 .07715 L
.72977 .07754 L
.73363 .07756 L
.73708 .08102 L
.73749 .08142 L
.74135 .08145 L
.74478 .08488 L
.74521 .08531 L
.74864 .08874 L
.74907 .08917 L
.75293 .08921 L
Mistroke
.75633 .0926 L
.7568 .09307 L
.76066 .09311 L
.76401 .09646 L
.76452 .09698 L
.76787 .10032 L
.76838 .10084 L
.77224 .10089 L
.77553 .10419 L
.7761 .10476 L
.77939 .10805 L
.77997 .10863 L
.78324 .11191 L
.78383 .1125 L
.78769 .11258 L
.79087 .11577 L
.79155 .11646 L
.79472 .11963 L
.79541 .12034 L
.79856 .12349 L
.79927 .12422 L
.80314 .12435 L
.80614 .12736 L
.807 .12825 L
.80996 .13122 L
.81086 .13215 L
.81378 .13508 L
.81472 .13605 L
.8176 .13894 L
.81858 .13997 L
.8214 .1428 L
.82244 .1439 L
.8252 .14666 L
.82631 .14783 L
.82898 .15053 L
.83017 .15179 L
.83403 .15235 L
.83604 .15439 L
.83789 .15648 L
.83962 .15825 L
.84175 .16074 L
.84308 .16211 L
.84561 .16521 L
.84633 .16597 L
.84747 .16983 L
.84947 .17218 L
.85094 .17369 L
.85334 .17663 L
.85421 .17756 L
.85708 .18142 L
Mistroke
.8572 .18157 L
.85928 .18528 L
.86106 .18745 L
.86212 .18914 L
.86482 .193 L
.86492 .19316 L
.86736 .19686 L
.86878 .19905 L
.86974 .20073 L
.87238 .20459 L
.87264 .20499 L
.87487 .20845 L
.87651 .211 L
.87734 .21231 L
.87979 .21617 L
.88037 .21708 L
.88223 .22003 L
.88423 .22321 L
.88466 .2239 L
.88707 .22776 L
.88809 .22941 L
.88946 .23162 L
.89184 .23548 L
.89195 .23567 L
.8942 .23934 L
.89581 .24199 L
.89655 .2432 L
.89889 .24707 L
.89968 .24837 L
.90121 .25093 L
.90352 .25479 L
.90354 .25482 L
.90581 .25865 L
.9074 .26133 L
.9081 .26251 L
.91037 .26637 L
.91126 .2679 L
.91262 .27023 L
.91487 .2741 L
.91512 .27453 L
.9171 .27796 L
.91898 .28123 L
.91932 .28182 L
.92153 .28568 L
.92285 .28799 L
.92373 .28954 L
.92592 .2934 L
.92671 .29481 L
.92809 .29727 L
.93025 .30113 L
Mistroke
.93057 .30169 L
.93241 .30499 L
.93443 .30863 L
.93453 .30885 L
.93668 .31271 L
.93829 .31564 L
.93872 .31657 L
.94017 .32044 L
.94215 .32271 L
.94288 .3243 L
.94468 .32816 L
.94601 .32984 L
.94702 .33202 L
.94903 .33588 L
.94988 .33703 L
.95108 .33974 L
.95326 .34361 L
.95374 .34428 L
.95508 .34747 L
.95586 .35133 L
.9576 .35364 L
.95906 .35519 L
.95977 .35905 L
.96015 .36291 L
.96146 .3645 L
.96367 .36677 L
.96404 .37064 L
.96427 .3745 L
.96443 .37836 L
.96532 .37937 L
.96815 .38222 L
.9683 .38608 L
.96841 .38994 L
.9685 .39381 L
.96918 .39456 L
.97228 .39767 L
.97237 .40153 L
.97244 .40539 L
.97249 .40925 L
.97254 .41311 L
.97305 .41366 L
.97635 .41698 L
.9764 .42084 L
.97644 .4247 L
.97647 .42856 L
.9765 .43242 L
.97652 .43628 L
.97691 .43669 L
.98056 .44015 L
.98057 .44401 L
Mistroke
.98059 .44787 L
.9806 .45173 L
.98061 .45559 L
.98061 .45945 L
.98062 .46331 L
.98063 .46718 L
.98063 .47104 L
.98064 .4749 L
.98065 .47876 L
.98065 .48262 L
.98065 .48648 L
.98066 .49035 L
.98066 .49421 L
.98067 .49807 L
.98067 .50193 L
.98067 .50579 L
.98067 .50965 L
.98068 .51352 L
.98068 .51738 L
.98068 .52124 L
.98068 .5251 L
.98069 .52896 L
.98069 .53282 L
.98069 .53669 L
.98069 .54055 L
.98069 .54441 L
.98069 .54827 L
.9807 .55213 L
.9807 .55599 L
.9807 .55985 L
.97691 .56357 L
.97677 .56372 L
.97677 .56758 L
.97677 .57144 L
.97677 .5753 L
.97678 .57916 L
.97678 .58302 L
.97305 .58676 L
.97292 .58689 L
.97292 .59075 L
.97292 .59461 L
.97293 .59847 L
.97293 .60233 L
.96918 .60608 L
.96907 .60619 L
.96907 .61006 L
.96907 .61392 L
.96907 .61778 L
.96532 .62153 L
.96522 .62164 L
Mistroke
.96522 .6255 L
.96522 .62936 L
.96522 .63323 L
.96146 .63698 L
.96136 .63709 L
.96136 .64095 L
.96136 .64481 L
.9576 .64857 L
.9575 .64867 L
.9575 .65253 L
.9575 .65639 L
.95374 .66016 L
.95364 .66026 L
.95364 .66412 L
.95365 .66798 L
.94988 .67175 L
.94979 .67184 L
.94979 .6757 L
.94601 .67947 L
.94593 .67956 L
.94593 .68343 L
.94593 .68729 L
.94215 .69106 L
.94207 .69115 L
.94207 .69501 L
.93829 .69879 L
.93821 .69887 L
.93821 .70273 L
.93443 .70651 L
.93435 .7066 L
.93435 .71046 L
.93057 .71424 L
.93049 .71432 L
.93049 .71818 L
.92671 .72196 L
.92663 .72204 L
.92663 .7259 L
.92285 .72968 L
.92277 .72977 L
.92277 .73363 L
.91898 .73741 L
.9189 .73749 L
.9189 .74135 L
.91512 .74513 L
.91504 .74521 L
.91126 .749 L
.91118 .74907 L
.91118 .75293 L
.9074 .75672 L
.90732 .7568 L
Mistroke
.90732 .76066 L
.90354 .76444 L
.90346 .76452 L
.89968 .7683 L
.8996 .76838 L
.8996 .77224 L
.89581 .77603 L
.89574 .7761 L
.89195 .77989 L
.89188 .77997 L
.88809 .78375 L
.88802 .78383 L
.88802 .78769 L
.88423 .79148 L
.88415 .79155 L
.88037 .79534 L
.88029 .79541 L
.87651 .7992 L
.87643 .79927 L
.87643 .80314 L
.87264 .80692 L
.87257 .807 L
.86878 .81078 L
.86871 .81086 L
.86492 .81464 L
.86485 .81472 L
.86106 .81851 L
.86098 .81858 L
.8572 .82237 L
.85712 .82244 L
.85334 .82623 L
.85326 .82631 L
.84947 .83009 L
.8494 .83017 L
.8494 .83403 L
.84561 .83781 L
.84554 .83789 L
.84175 .84167 L
.84167 .84175 L
.83789 .84554 L
.83781 .84561 L
.83403 .8494 L
.83017 .8494 L
.83009 .84947 L
.82631 .85326 L
.82623 .85334 L
.82244 .85712 L
.82236 .8572 L
.81858 .86098 L
.8185 .86106 L
Mistroke
.81472 .86484 L
.81464 .86492 L
.81086 .8687 L
.81078 .86878 L
.807 .87256 L
.80691 .87264 L
.80314 .87642 L
.79927 .87642 L
.79919 .87651 L
.79541 .88028 L
.79533 .88037 L
.79155 .88414 L
.79146 .88423 L
.78769 .888 L
.78383 .888 L
.78374 .88809 L
.77997 .89186 L
.77988 .89195 L
.7761 .89572 L
.77601 .89581 L
.77224 .89958 L
.76838 .89958 L
.76829 .89968 L
.76452 .90344 L
.76443 .90354 L
.76066 .9073 L
.7568 .9073 L
.7567 .9074 L
.75293 .91116 L
.74907 .91116 L
.74897 .91126 L
.74521 .91502 L
.74511 .91512 L
.74135 .91888 L
.73749 .91888 L
.73739 .91898 L
.73363 .92274 L
.72977 .92274 L
.72966 .92285 L
.7259 .9266 L
.72204 .9266 L
.72193 .92671 L
.71818 .93046 L
.71432 .93046 L
.71421 .93057 L
.71046 .93432 L
.7066 .93432 L
.70648 .93443 L
.70273 .93818 L
.69887 .93817 L
Mistroke
.69875 .93829 L
.69501 .94203 L
.69115 .94203 L
.69103 .94215 L
.68729 .94589 L
.68343 .94589 L
.67956 .94589 L
.67943 .94601 L
.6757 .94975 L
.67184 .94974 L
.67171 .94988 L
.66798 .9536 L
.66412 .9536 L
.66026 .9536 L
.66012 .95374 L
.65639 .95746 L
.65253 .95746 L
.64867 .95745 L
.64852 .9576 L
.64481 .96131 L
.64095 .96131 L
.63709 .96131 L
.63693 .96146 L
.63323 .96517 L
.62936 .96516 L
.6255 .96516 L
.62164 .96516 L
.62147 .96532 L
.61778 .96902 L
.61392 .96902 L
.61006 .96901 L
.60619 .96901 L
.60602 .96918 L
.60233 .97287 L
.59847 .97287 L
.59461 .97286 L
.59075 .97286 L
.58689 .97286 L
.5867 .97305 L
.58302 .97672 L
.57916 .97671 L
.5753 .97671 L
.57144 .97671 L
.56758 .97671 L
.56372 .97671 L
.56351 .97691 L
.55985 .98067 L
.55599 .98067 L
.55213 .98067 L
.54827 .98067 L
Mistroke
.54441 .98067 L
.54055 .98067 L
.53669 .98067 L
.53282 .98067 L
.52896 .98066 L
.5251 .98066 L
.52124 .98066 L
.51738 .98066 L
.51352 .98066 L
.50965 .98066 L
.50579 .98066 L
.50193 .98066 L
.49807 .98066 L
.49421 .98066 L
.49035 .98066 L
.48648 .98066 L
.48262 .98066 L
.47876 .98066 L
.4749 .98066 L
.47104 .98066 L
.46718 .98066 L
.46331 .98067 L
.45945 .98067 L
.45559 .98067 L
.45173 .98067 L
.44787 .98067 L
.44401 .98067 L
.44015 .98067 L
.43649 .97691 L
.43628 .97671 L
.43242 .97671 L
.42856 .97671 L
.4247 .97671 L
.42084 .97671 L
.41698 .97671 L
.41331 .97305 L
.41311 .97286 L
.40925 .97286 L
.40539 .97286 L
.40153 .97286 L
.39767 .97286 L
.39399 .96918 L
.39381 .96901 L
.38994 .96901 L
.38608 .96901 L
.38222 .96901 L
.37853 .96532 L
.37836 .96516 L
.3745 .96516 L
.37064 .96516 L
Mistroke
.36677 .96516 L
.36307 .96146 L
.36291 .96131 L
.35905 .96131 L
.35519 .96131 L
.35148 .9576 L
.35133 .95745 L
.34747 .95745 L
.34361 .95746 L
.33989 .95374 L
.33974 .9536 L
.33588 .9536 L
.33202 .9536 L
.3283 .94988 L
.32816 .94974 L
.3243 .94974 L
.32057 .94601 L
.32044 .94589 L
.31657 .94589 L
.31271 .94589 L
.30898 .94215 L
.30885 .94203 L
.30499 .94203 L
.30125 .93829 L
.30113 .93817 L
.29727 .93817 L
.29352 .93443 L
.2934 .93431 L
.28954 .93432 L
.2858 .93057 L
.28568 .93046 L
.28182 .93046 L
.27807 .92671 L
.27796 .9266 L
.2741 .9266 L
.27034 .92285 L
.27023 .92274 L
.26637 .92274 L
.26262 .91898 L
.26251 .91888 L
.25865 .91888 L
.25489 .91512 L
.25479 .91502 L
.25103 .91126 L
.25093 .91116 L
.24707 .91116 L
.2433 .9074 L
.2432 .9073 L
.23934 .9073 L
.23558 .90354 L
Mistroke
.23548 .90344 L
.23171 .89968 L
.23162 .89958 L
.22776 .89958 L
.22399 .89581 L
.2239 .89572 L
.22013 .89195 L
.22003 .89186 L
.21626 .88809 L
.21617 .888 L
.21231 .888 L
.20854 .88423 L
.20845 .88414 L
.20467 .88037 L
.20459 .88028 L
.20081 .87651 L
.20073 .87642 L
.19686 .87642 L
.19309 .87264 L
.193 .87256 L
.18923 .86878 L
.18914 .8687 L
.18536 .86492 L
.18528 .86484 L
.1815 .86106 L
.18142 .86098 L
.17764 .8572 L
.17756 .85712 L
.17378 .85334 L
.17369 .85326 L
.16991 .84947 L
.16983 .84939 L
.16597 .84939 L
.16219 .84561 L
.16211 .84553 L
.15833 .84175 L
.15825 .84167 L
.15447 .83789 L
.15439 .83781 L
.1506 .83403 L
.1506 .83017 L
.15053 .83009 L
.14674 .82631 L
.14666 .82623 L
.14288 .82244 L
.1428 .82237 L
.13902 .81858 L
.13894 .8185 L
.13516 .81472 L
.13508 .81464 L
Mistroke
.13129 .81086 L
.13122 .81078 L
.12743 .807 L
.12736 .80692 L
.12357 .80314 L
.12357 .79927 L
.12349 .7992 L
.11971 .79541 L
.11963 .79534 L
.11585 .79155 L
.11577 .79147 L
.11199 .78769 L
.11199 .78383 L
.11191 .78375 L
.10813 .77997 L
.10805 .77989 L
.10426 .7761 L
.10419 .77603 L
.1004 .77224 L
.1004 .76838 L
.10032 .7683 L
.09654 .76452 L
.09646 .76444 L
.09268 .76066 L
.09268 .7568 L
.0926 .75672 L
.08882 .75293 L
.08882 .74907 L
.08874 .74899 L
.08496 .74521 L
.08488 .74513 L
.0811 .74135 L
.0811 .73749 L
.08102 .73741 L
.07724 .73363 L
.07724 .72977 L
.07715 .72968 L
.07338 .7259 L
.07338 .72204 L
.07329 .72196 L
.06952 .71818 L
.06952 .71432 L
.06943 .71423 L
.06566 .71046 L
.06566 .7066 L
.06557 .70651 L
.0618 .70273 L
.0618 .69887 L
.06171 .69878 L
.05794 .69501 L
Mistroke
.05794 .69115 L
.05785 .69106 L
.05408 .68729 L
.05408 .68343 L
.05408 .67956 L
.05399 .67947 L
.05022 .6757 L
.05022 .67184 L
.05012 .67175 L
.04636 .66798 L
.04636 .66412 L
.04636 .66026 L
.04626 .66016 L
.0425 .65639 L
.0425 .65253 L
.0425 .64867 L
.0424 .64857 L
.03864 .64481 L
.03864 .64095 L
.03864 .63709 L
.03854 .63698 L
.03479 .63323 L
.03479 .62936 L
.03479 .6255 L
.03479 .62164 L
.03468 .62153 L
.03093 .61778 L
.03093 .61392 L
.03093 .61006 L
.03093 .60619 L
.03082 .60607 L
.02708 .60233 L
.02708 .59847 L
.02708 .59461 L
.02708 .59075 L
.02708 .58689 L
.02695 .58675 L
.02323 .58302 L
.02323 .57916 L
.02323 .5753 L
.02324 .57144 L
.02324 .56758 L
.02324 .56372 L
.02309 .56356 L
.01931 .55985 L
.01931 .55599 L
.01931 .55213 L
.01931 .54827 L
.01931 .54441 L
.01931 .54055 L
Mistroke
.01932 .53669 L
.01932 .53282 L
.01932 .52896 L
.01932 .5251 L
.01932 .52124 L
.01933 .51738 L
.01933 .51352 L
.01933 .50965 L
.01934 .50579 L
.01934 .50193 L
.01934 .49807 L
.01935 .49421 L
.01935 .49035 L
.01936 .48648 L
.01936 .48262 L
.01937 .47876 L
.01937 .4749 L
.01938 .47104 L
.01939 .46718 L
.0194 .46331 L
.01941 .45945 L
.01942 .45559 L
.01943 .45173 L
.01944 .44787 L
.01946 .44401 L
.01948 .44015 L
.02309 .43675 L
.02354 .43628 L
.02357 .43242 L
.02361 .42856 L
.02365 .4247 L
.02371 .42084 L
.02378 .41698 L
.02695 .41379 L
.02757 .41311 L
.02764 .40925 L
.02773 .40539 L
.02784 .40153 L
.028 .39767 L
.03082 .39482 L
.03171 .39381 L
.03186 .38994 L
.03209 .38608 L
.03244 .38222 L
.03468 .37993 L
.03597 .37836 L
.03633 .3745 L
.03699 .37064 L
.03846 .36677 L
.03854 .36668 L
Mistroke
.04092 .36291 L
.0424 .35919 L
.04249 .35905 L
.04469 .35519 L
.04626 .35181 L
.04659 .35133 L
.04874 .34747 L
.05012 .34449 L
.05059 .34361 L
.05282 .33974 L
.05399 .33723 L
.05471 .33588 L
.05678 .33202 L
.05785 .33004 L
.05886 .32816 L
.06095 .3243 L
.06171 .3229 L
.06305 .32044 L
.06516 .31657 L
.06557 .31583 L
.06728 .31271 L
.06942 .30885 L
.06943 .30882 L
.07156 .30499 L
.07329 .30188 L
.07371 .30113 L
.07588 .29727 L
.07715 .29499 L
.07805 .2934 L
.08024 .28954 L
.08102 .28817 L
.08243 .28568 L
.08464 .28182 L
.08488 .28141 L
.08686 .27796 L
.08874 .27471 L
.0891 .2741 L
.09134 .27023 L
.0926 .26808 L
.0936 .26637 L
.09587 .26251 L
.09646 .2615 L
.09815 .25865 L
.10032 .25499 L
.10045 .25479 L
.10276 .25093 L
.10419 .24855 L
.10508 .24707 L
.10741 .2432 L
.10805 .24216 L
Mistroke
.10976 .23934 L
.11191 .23584 L
.11213 .23548 L
.11451 .23162 L
.11577 .22957 L
.1169 .22776 L
.11931 .2239 L
.11963 .22338 L
.12173 .22003 L
.12349 .21724 L
.12417 .21617 L
.12662 .21231 L
.12736 .21116 L
.12909 .20845 L
.13122 .20515 L
.13158 .20459 L
.13409 .20073 L
.13508 .1992 L
.13661 .19686 L
.13894 .19331 L
.13915 .193 L
.1417 .18914 L
.1428 .18749 L
.14428 .18528 L
.14666 .18173 L
.14687 .18142 L
.14961 .17756 L
.15053 .17616 L
.1526 .17369 L
.15439 .17039 L
.15481 .16983 L
.15755 .16597 L
.15825 .165 L
.16077 .16211 L
.16211 .1593 L
.16295 .15825 L
.16564 .15439 L
.16597 .15403 L
.16983 .15238 L
.1715 .15053 L
.17369 .14831 L
.1752 .14666 L
.17756 .14429 L
.17894 .1428 L
.18142 .14031 L
.1827 .13894 L
.18528 .13635 L
.18648 .13508 L
.18914 .1324 L
.19027 .13122 L
Mistroke
.193 .12847 L
.19407 .12736 L
.19686 .12456 L
.20073 .12436 L
.20157 .12349 L
.20459 .12047 L
.2054 .11963 L
.20845 .11658 L
.20924 .11577 L
.21231 .1127 L
.21617 .11259 L
.21684 .11191 L
.22003 .10871 L
.22069 .10805 L
.2239 .10484 L
.22454 .10419 L
.22776 .10097 L
.23162 .1009 L
.23219 .10032 L
.23548 .09703 L
.23604 .09646 L
.23934 .09316 L
.2432 .09311 L
.24371 .0926 L
.24707 .08925 L
.25093 .08921 L
.2514 .08874 L
.25479 .08535 L
.25526 .08488 L
.25865 .08148 L
.26251 .08145 L
.26295 .08102 L
.26637 .07759 L
.27023 .07756 L
.27064 .07715 L
.2741 .0737 L
.27796 .07368 L
.27835 .07329 L
.28182 .06982 L
.28568 .0698 L
.28605 .06943 L
.28954 .06594 L
.2934 .06592 L
.29376 .06557 L
.29727 .06206 L
.30113 .06205 L
.30147 .06171 L
.30499 .05819 L
.30885 .05818 L
.30918 .05785 L
Mistroke
.31271 .05432 L
.31657 .0543 L
.32044 .05429 L
.32075 .05399 L
.3243 .05044 L
.32816 .05042 L
.32846 .05012 L
.33202 .04657 L
.33588 .04656 L
.33974 .04655 L
.34003 .04626 L
.34361 .04269 L
.34747 .04268 L
.35133 .04268 L
.35161 .0424 L
.35519 .03882 L
.35905 .03881 L
.36291 .03881 L
.36318 .03854 L
.36677 .03495 L
.37064 .03494 L
.3745 .03494 L
.37836 .03493 L
.37862 .03468 L
.38222 .03108 L
.38608 .03107 L
.38994 .03107 L
.39381 .03106 L
.39406 .03082 L
.39767 .02721 L
.40153 .0272 L
.40539 .0272 L
.40925 .02719 L
.41311 .02719 L
.41336 .02695 L
.41698 .02334 L
.42084 .02333 L
.4247 .02333 L
.42856 .02333 L
.43242 .02332 L
.43628 .02332 L
.43652 .02309 L
.44015 .01934 L
Mfstroke
.5 1 .826 r
.44015 .02253 m
.44401 .02247 L
.44787 .02241 L
.45173 .02237 L
.45559 .02232 L
.45945 .02228 L
.46331 .02225 L
.46718 .02222 L
.47104 .0222 L
.4749 .02217 L
.47876 .02215 L
.48262 .02214 L
.48648 .02213 L
.49035 .02212 L
.49421 .02211 L
.49807 .0221 L
.50193 .0221 L
.50579 .0221 L
.50965 .02211 L
.51352 .02211 L
.51738 .02212 L
.52124 .02214 L
.5251 .02215 L
.52896 .02217 L
.53282 .02219 L
.53669 .02222 L
.54055 .02224 L
.54441 .02228 L
.54827 .02231 L
.55213 .02235 L
.55599 .0224 L
.55985 .02245 L
.56018 .02309 L
.56372 .02654 L
.56758 .02657 L
.57144 .02661 L
.5753 .02665 L
.57916 .02669 L
.58302 .02674 L
.58324 .02695 L
.58689 .03051 L
.59075 .03056 L
.59461 .03061 L
.59847 .03067 L
.60233 .03073 L
.60242 .03082 L
.60619 .03451 L
.61006 .03457 L
.61392 .03465 L
.61765 .03468 L
.61778 .0348 L
.62164 .0385 L
.6233 .03854 L
.6255 .03866 L
.62936 .03893 L
.63071 .0424 L
.63323 .04376 L
.63709 .04284 L
.63772 .04626 L
.64095 .04811 L
.64438 .05012 L
.64481 .05038 L
.64867 .05271 L
.65074 .05399 L
.65253 .05511 L
.65639 .05756 L
.65684 .05785 L
.66026 .06008 L
.6627 .06171 L
.66412 .06266 L
.66798 .0653 L
.66836 .06557 L
.67184 .06801 L
.67384 .06943 L
.6757 .07078 L
.67914 .07329 L
.67956 .07361 L
.68343 .0765 L
.68429 .07715 L
.68729 .07945 L
.6893 .08102 L
.69115 .08247 L
.69418 .08488 L
.69501 .08555 L
.69887 .08869 L
.69893 .08874 L
.70273 .09189 L
.70358 .0926 L
.7066 .09516 L
.70812 .09646 L
.71046 .09849 L
.71256 .10032 L
.71432 .10188 L
.71691 .10419 L
.71818 .10533 L
.72117 .10805 L
.72204 .10885 L
.72535 .11191 L
.7259 .11243 L
.72945 .11577 L
.72977 .11607 L
.73349 .11963 L
.73363 .11977 L
.73745 .12349 L
.73749 .12353 L
.74134 .12736 L
.74135 .12736 L
.74518 .13122 L
.74521 .13125 L
.74895 .13508 L
.74907 .1352 L
.75267 .13894 L
.75293 .13922 L
.75633 .1428 L
.7568 .14329 L
.75995 .14666 L
.76066 .14743 L
.76351 .15053 L
.76452 .15163 L
.76702 .15439 L
.76838 .1559 L
.77049 .15825 L
.77224 .16022 L
.77391 .16211 L
.7761 .16461 L
.77729 .16597 L
.77997 .16906 L
.78063 .16983 L
.78383 .17357 L
.78393 .17369 L
.78719 .17756 L
.78769 .17815 L
.79042 .18142 L
.79155 .18279 L
.79361 .18528 L
.79541 .18749 L
.79676 .18914 L
.79927 .19225 L
.79988 .193 L
.80297 .19686 L
.80314 .19707 L
.80603 .20073 L
.807 .20196 L
.80905 .20459 L
.81086 .20691 L
.81205 .20845 L
.81472 .21192 L
.81502 .21231 L
.81796 .21617 L
.81858 .217 L
.82087 .22003 L
.82244 .22213 L
.82376 .2239 L
.82631 .22733 L
.82662 .22776 L
.82946 .23162 L
.83017 .23259 L
.83227 .23548 L
.83403 .23791 L
.83506 .23934 L
.83782 .2432 L
.83789 .2433 L
.84056 .24707 L
.84175 .24875 L
.84328 .25093 L
.84561 .25426 L
.84598 .25479 L
.84866 .25865 L
.84947 .25983 L
.85132 .26251 L
.85334 .26547 L
.85395 .26637 L
.85657 .27023 L
.8572 .27116 L
.85917 .2741 L
.86106 .27692 L
.86175 .27796 L
.86431 .28182 L
.86492 .28275 L
.86685 .28568 L
.86878 .28863 L
.86938 .28954 L
.87189 .2934 L
.87264 .29458 L
.87438 .29727 L
.87651 .30059 L
.87685 .30113 L
.87931 .30499 L
.88037 .30666 L
.88175 .30885 L
.88418 .31271 L
.88423 .31279 L
.88659 .31657 L
.88809 .31899 L
.88899 .32044 L
.89137 .3243 L
.89195 .32524 L
.89374 .32816 L
.89581 .33157 L
.89609 .33202 L
.89843 .33588 L
.89968 .33795 L
.90076 .33974 L
.90307 .34361 L
.90354 .34439 L
.90537 .34747 L
.9074 .3509 L
.90765 .35133 L
.90992 .35519 L
.91126 .35747 L
.91218 .35905 L
.91443 .36291 L
.91512 .3641 L
.91667 .36677 L
.91889 .37064 L
.91898 .3708 L
.9211 .3745 L
.92285 .37756 L
.9233 .37836 L
.92549 .38222 L
.92671 .38437 L
.92767 .38608 L
.92984 .38994 L
.93057 .39126 L
.93199 .39381 L
.93414 .39767 L
.93443 .3982 L
.93627 .40153 L
.93829 .40521 L
.93839 .40539 L
.94051 .40925 L
.94215 .41228 L
.94261 .41311 L
.9447 .41698 L
.94601 .41941 L
.94679 .42084 L
.94886 .4247 L
.94988 .4266 L
.95092 .42856 L
.95298 .43242 L
.95374 .43386 L
.95502 .43628 L
.95706 .44015 L
.9576 .44117 L
.95909 .44401 L
.9611 .44787 L
.96146 .44855 L
.96311 .45173 L
.96511 .45559 L
.96532 .456 L
.96711 .45945 L
.96909 .46331 L
.96918 .4635 L
.97106 .46718 L
.97303 .47104 L
.97305 .47107 L
.97646 .4749 L
.97691 .4787 L
.97691 .47876 L
.97724 .48262 L
.9775 .48648 L
.97771 .49035 L
.97789 .49421 L
.97805 .49807 L
.97818 .50193 L
.9783 .50579 L
.97841 .50965 L
.97851 .51352 L
.9786 .51738 L
.97868 .52124 L
.97875 .5251 L
.97882 .52896 L
.97888 .53282 L
.97894 .53669 L
.97899 .54055 L
.97904 .54441 L
.97909 .54827 L
.97913 .55213 L
.97917 .55599 L
.97921 .55985 L
.97691 .5615 L
.97478 .56372 L
.97482 .56758 L
.97485 .57144 L
.97488 .5753 L
.97491 .57916 L
.97493 .58302 L
.97305 .58492 L
.97115 .58689 L
.97117 .59075 L
.97119 .59461 L
.97122 .59847 L
.97124 .60233 L
.96918 .60439 L
.96743 .60619 L
.96745 .61006 L
.96747 .61392 L
.96749 .61778 L
.96532 .61995 L
.96367 .62164 L
.96369 .6255 L
.9637 .62936 L
.96372 .63323 L
.96146 .63549 L
.95989 .63709 L
.95991 .64095 L
.95992 .64481 L
.9576 .64714 L
.95609 .64867 L
.9561 .65253 L
.95611 .65639 L
.95374 .65877 L
.95228 .66026 L
.95229 .66412 L
.9523 .66798 L
.94988 .67041 L
.94846 .67184 L
.94847 .6757 L
.94601 .67816 L
.94463 .67956 L
.94464 .68343 L
.94465 .68729 L
.94215 .68978 L
.9408 .69115 L
.94081 .69501 L
.93829 .69753 L
.93697 .69887 L
.93697 .70273 L
.93443 .70528 L
.93313 .7066 L
.93313 .71046 L
.93057 .71302 L
.92928 .71432 L
.92929 .71818 L
.92671 .72076 L
.92544 .72204 L
.92544 .7259 L
.92285 .7285 L
.92159 .72977 L
.9216 .73363 L
.91898 .73624 L
.91774 .73749 L
.91775 .74135 L
.91512 .74398 L
.91389 .74521 L
.91126 .74784 L
.91004 .74907 L
.91004 .75293 L
.9074 .75558 L
.90618 .7568 L
.90619 .76066 L
.90354 .76331 L
.90233 .76452 L
.89968 .76717 L
.89847 .76838 L
.89847 .77224 L
.89581 .7749 L
.89462 .7761 L
.89195 .77877 L
.89076 .77997 L
.88809 .78263 L
.8869 .78383 L
.8869 .78769 L
.88423 .79036 L
.88304 .79155 L
.88037 .79422 L
.87918 .79541 L
.87651 .79808 L
.87531 .79927 L
.87531 .80314 L
.87264 .8058 L
.87145 .807 L
.86878 .80966 L
.86759 .81086 L
.86492 .81352 L
.86372 .81472 L
.86106 .81738 L
.85986 .81858 L
.8572 .82124 L
.85599 .82244 L
.85334 .8251 L
.85213 .82631 L
.84947 .82896 L
.84826 .83017 L
.84826 .83403 L
.84561 .83667 L
.84439 .83789 L
.84175 .84053 L
.84052 .84175 L
.83789 .84439 L
.83666 .84561 L
.83403 .84824 L
.83017 .84824 L
.82892 .84947 L
.82631 .85209 L
.82505 .85334 L
.82244 .85594 L
.82118 .8572 L
.81858 .85979 L
.81731 .86106 L
.81472 .86365 L
.81344 .86492 L
.81086 .8675 L
.80956 .86878 L
.807 .87135 L
.80569 .87264 L
.80314 .8752 L
.79927 .87519 L
.79795 .87651 L
.79541 .87904 L
.79407 .88037 L
.79155 .88289 L
.7902 .88423 L
.78769 .88674 L
.78383 .88673 L
.78245 .88809 L
.77997 .89057 L
.77857 .89195 L
.7761 .89442 L
.77469 .89581 L
.77224 .89826 L
.76838 .89825 L
.76694 .89968 L
.76452 .9021 L
.76306 .90354 L
.76066 .90594 L
.7568 .90593 L
.75531 .9074 L
.75293 .90977 L
.74907 .90975 L
.74755 .91126 L
.74521 .91359 L
.74366 .91512 L
.74135 .91743 L
.73749 .91742 L
.7359 .91898 L
.73363 .92125 L
.72977 .92124 L
.72814 .92285 L
.7259 .92507 L
.72204 .92506 L
.72037 .92671 L
.71818 .92889 L
.71432 .92887 L
.7126 .93057 L
.71046 .9327 L
.7066 .93269 L
.70482 .93443 L
.70273 .93651 L
.69887 .9365 L
.69704 .93829 L
.69501 .94032 L
.69115 .9403 L
.68926 .94215 L
.68729 .94412 L
.68343 .9441 L
.67956 .94409 L
.6776 .94601 L
.6757 .9479 L
.67184 .94788 L
.6698 .94988 L
.66798 .95169 L
.66412 .95167 L
.66026 .95165 L
.65812 .95374 L
.65639 .95546 L
.65253 .95544 L
.64867 .95541 L
.64643 .9576 L
.64481 .95921 L
.64095 .95919 L
.63709 .95917 L
.63473 .96146 L
.63323 .96296 L
.62936 .96294 L
.6255 .96291 L
.62164 .96289 L
.61914 .96532 L
.61778 .96667 L
.61392 .96665 L
.61006 .96662 L
.60619 .9666 L
.60353 .96918 L
.60233 .97037 L
.59847 .97034 L
.59461 .97032 L
.59075 .97029 L
.58689 .97027 L
.58402 .97305 L
.58302 .97403 L
.57916 .974 L
.5753 .97398 L
.57144 .97395 L
.56758 .97393 L
.56372 .9739 L
.56061 .97691 L
.55985 .9782 L
.55599 .97817 L
.55213 .97814 L
.54827 .97811 L
.54441 .97808 L
.54055 .97805 L
.53669 .97803 L
.53282 .978 L
.52896 .97798 L
.5251 .97796 L
.52124 .97795 L
.51738 .97793 L
.51352 .97792 L
.50965 .97791 L
.50579 .9779 L
.50193 .9779 L
.49807 .9779 L
.49421 .9779 L
.49035 .9779 L
.48648 .97791 L
.48262 .97792 L
.47876 .97793 L
.4749 .97794 L
.47104 .97796 L
.46718 .97798 L
.46331 .978 L
.45945 .97802 L
.45559 .97805 L
.45173 .97807 L
.44787 .9781 L
.44401 .97813 L
.44015 .97816 L
.43942 .97691 L
.43628 .97388 L
.43242 .9739 L
.42856 .97392 L
.4247 .97394 L
.42084 .97397 L
.41698 .974 L
.41602 .97305 L
.41311 .97023 L
.40925 .97026 L
.40539 .97028 L
.40153 .97031 L
.39767 .97034 L
.39651 .96918 L
.39381 .96656 L
.38994 .96659 L
.38608 .96661 L
.38222 .96664 L
.3809 .96532 L
.37836 .96285 L
.3745 .96288 L
.37064 .9629 L
.36677 .96293 L
.3653 .96146 L
.36291 .95913 L
.35905 .95916 L
.35519 .95918 L
.3536 .9576 L
.35133 .95538 L
.34747 .9554 L
.34361 .95543 L
.34191 .95374 L
.33974 .95162 L
.33588 .95164 L
.33202 .95166 L
.33023 .94988 L
.32816 .94785 L
.3243 .94787 L
.32244 .94601 L
.32044 .94405 L
.31657 .94407 L
.31271 .94409 L
.31077 .94215 L
.30885 .94027 L
.30499 .94029 L
.30298 .93829 L
.30113 .93647 L
.29727 .93649 L
.29521 .93443 L
.2934 .93266 L
.28954 .93268 L
.28743 .93057 L
.28568 .92885 L
.28182 .92886 L
.27966 .92671 L
.27796 .92503 L
.2741 .92505 L
.27189 .92285 L
.27023 .92121 L
.26637 .92123 L
.26413 .91898 L
.26251 .91739 L
.25865 .9174 L
.25636 .91512 L
.25479 .91357 L
.25248 .91126 L
.25093 .90973 L
.24707 .90974 L
.24472 .9074 L
.2432 .9059 L
.23934 .90591 L
.23696 .90354 L
.23548 .90207 L
.23308 .89968 L
.23162 .89823 L
.22776 .89824 L
.22533 .89581 L
.2239 .89439 L
.22145 .89195 L
.22003 .89055 L
.21757 .88809 L
.21617 .8867 L
.21231 .88671 L
.20983 .88423 L
.20845 .88287 L
.20595 .88037 L
.20459 .87902 L
.20207 .87651 L
.20073 .87517 L
.19686 .87518 L
.19433 .87264 L
.193 .87133 L
.19046 .86878 L
.18914 .86748 L
.18659 .86492 L
.18528 .86362 L
.18271 .86106 L
.18142 .85977 L
.17884 .8572 L
.17756 .85592 L
.17497 .85334 L
.17369 .85207 L
.1711 .84947 L
.16983 .84821 L
.16597 .84822 L
.16337 .84561 L
.16211 .84436 L
.1595 .84175 L
.15825 .84051 L
.15563 .83789 L
.15439 .83665 L
.15176 .83403 L
.15176 .83017 L
.15053 .82894 L
.14789 .82631 L
.14666 .82508 L
.14403 .82244 L
.1428 .82122 L
.14016 .81858 L
.13894 .81736 L
.1363 .81472 L
.13508 .8135 L
.13244 .81086 L
.13122 .80964 L
.12857 .807 L
.12736 .80578 L
.12471 .80314 L
.12471 .79927 L
.12349 .79806 L
.12085 .79541 L
.11963 .7942 L
.11699 .79155 L
.11577 .79033 L
.11313 .78769 L
.11313 .78383 L
.11191 .78261 L
.10927 .77997 L
.10805 .77874 L
.10541 .7761 L
.10419 .77488 L
.10155 .77224 L
.10155 .76838 L
.10032 .76715 L
.0977 .76452 L
.09646 .76328 L
.09384 .76066 L
.09384 .7568 L
.0926 .75555 L
.08999 .75293 L
.08999 .74907 L
.08874 .74782 L
.08613 .74521 L
.08488 .74395 L
.08228 .74135 L
.08229 .73749 L
.08102 .73621 L
.07843 .73363 L
.07844 .72977 L
.07715 .72847 L
.07459 .7259 L
.07459 .72204 L
.07329 .72073 L
.07074 .71818 L
.07075 .71432 L
.06943 .71299 L
.0669 .71046 L
.06691 .7066 L
.06557 .70525 L
.06306 .70273 L
.06307 .69887 L
.06171 .6975 L
.05922 .69501 L
.05923 .69115 L
.05785 .68975 L
.05539 .68729 L
.0554 .68343 L
.05541 .67956 L
.05399 .67812 L
.05157 .6757 L
.05158 .67184 L
.05012 .67037 L
.04774 .66798 L
.04775 .66412 L
.04776 .66026 L
.04626 .65873 L
.04393 .65639 L
.04394 .65253 L
.04395 .64867 L
.0424 .64709 L
.04013 .64481 L
.04014 .64095 L
.04016 .63709 L
.03854 .63543 L
.03634 .63323 L
.03635 .62936 L
.03637 .6255 L
.03638 .62164 L
.03468 .61989 L
.03257 .61778 L
.03259 .61392 L
.03261 .61006 L
.03263 .60619 L
.03082 .60432 L
.02883 .60233 L
.02886 .59847 L
.02888 .59461 L
.02891 .59075 L
.02893 .58689 L
.02695 .58484 L
.02515 .58302 L
.02518 .57916 L
.02522 .5753 L
.02525 .57144 L
.02528 .56758 L
.02532 .56372 L
.02309 .56138 L
.02091 .55985 L
.02095 .55599 L
.021 .55213 L
.02105 .54827 L
.02111 .54441 L
.02116 .54055 L
.02123 .53669 L
.0213 .53282 L
.02137 .52896 L
.02146 .5251 L
.02155 .52124 L
.02165 .51738 L
.02176 .51352 L
.02189 .50965 L
.02203 .50579 L
.02219 .50193 L
.02238 .49807 L
.02261 .49421 L
.02289 .49035 L
.02309 .48806 L
.02325 .48648 L
.02378 .48262 L
.02695 .48036 L
.02776 .47876 L
.02971 .4749 L
.03082 .47271 L
.03167 .47104 L
.03363 .46718 L
.03468 .46513 L
.03561 .46331 L
.03759 .45945 L
.03854 .45761 L
.03958 .45559 L
.04158 .45173 L
.0424 .45015 L
.04359 .44787 L
.04561 .44401 L
.04626 .44276 L
.04764 .44015 L
.04967 .43628 L
.05012 .43543 L
.05172 .43242 L
.05377 .42856 L
.05399 .42816 L
.05583 .4247 L
.05785 .42095 L
.05791 .42084 L
.05999 .41698 L
.06171 .41381 L
.06208 .41311 L
.06419 .40925 L
.06557 .40672 L
.0663 .40539 L
.06842 .40153 L
.06943 .3997 L
.07056 .39767 L
.0727 .39381 L
.07329 .39274 L
.07486 .38994 L
.07702 .38608 L
.07715 .38585 L
.0792 .38222 L
.08102 .37902 L
.08139 .37836 L
.08359 .3745 L
.08488 .37224 L
.0858 .37064 L
.08802 .36677 L
.08874 .36554 L
.09026 .36291 L
.09251 .35905 L
.0926 .35889 L
.09477 .35519 L
.09646 .35231 L
.09704 .35133 L
.09932 .34747 L
.10032 .34578 L
.10162 .34361 L
.10393 .33974 L
.10419 .33933 L
.10626 .33588 L
.10805 .33293 L
.1086 .33202 L
.11095 .32816 L
.11191 .32659 L
.11332 .3243 L
.1157 .32044 L
.11577 .32032 L
.1181 .31657 L
.11963 .31411 L
.12051 .31271 L
.12293 .30885 L
.12349 .30796 L
.12538 .30499 L
.12736 .30188 L
.12784 .30113 L
.13031 .29727 L
.13122 .29586 L
.1328 .2934 L
.13508 .2899 L
.13531 .28954 L
.13783 .28568 L
.13894 .284 L
.14038 .28182 L
.1428 .27816 L
.14294 .27796 L
.14552 .2741 L
.14666 .27239 L
.14812 .27023 L
.15053 .26668 L
.15073 .26637 L
.15337 .26251 L
.15439 .26103 L
.15603 .25865 L
.15825 .25544 L
.1587 .25479 L
.1614 .25093 L
.16211 .24992 L
.16412 .24707 L
.16597 .24446 L
.16686 .2432 L
.16963 .23934 L
.16983 .23906 L
.17242 .23548 L
.17369 .23372 L
.17523 .23162 L
.17756 .22845 L
.17806 .22776 L
.18093 .2239 L
.18142 .22323 L
.18381 .22003 L
.18528 .21808 L
.18673 .21617 L
.18914 .213 L
.18967 .21231 L
.19263 .20845 L
.193 .20797 L
.19563 .20459 L
.19686 .20301 L
.19866 .20073 L
.20073 .19811 L
.20171 .19686 L
.20459 .19327 L
.2048 .193 L
.20792 .18914 L
.20845 .18849 L
.21108 .18528 L
.21231 .18378 L
.21427 .18142 L
.21617 .17913 L
.21749 .17756 L
.22003 .17454 L
.22075 .17369 L
.2239 .17002 L
.22405 .16983 L
.22739 .16597 L
.22776 .16555 L
.23077 .16211 L
.23162 .16115 L
.23419 .15825 L
.23548 .15681 L
.23766 .15439 L
.23934 .15253 L
.24117 .15053 L
.2432 .14832 L
.24474 .14666 L
.24707 .14417 L
.24835 .1428 L
.25093 .14008 L
.25201 .13894 L
.25479 .13605 L
.25573 .13508 L
.25865 .13208 L
.2595 .13122 L
.26251 .12818 L
.26334 .12736 L
.26637 .12434 L
.26723 .12349 L
.27023 .12056 L
.27119 .11963 L
.2741 .11685 L
.27523 .11577 L
.27796 .11319 L
.27933 .11191 L
.28182 .1096 L
.28351 .10805 L
.28568 .10607 L
.28777 .10419 L
.28954 .10261 L
.29212 .10032 L
.2934 .0992 L
.29656 .09646 L
.29727 .09586 L
.3011 .0926 L
.30113 .09258 L
.30499 .08936 L
.30575 .08874 L
.30885 .08621 L
.3105 .08488 L
.31271 .08312 L
.31538 .08102 L
.31657 .08008 L
.32039 .07715 L
.32044 .07712 L
.3243 .07421 L
.32554 .07329 L
.32816 .07137 L
.33084 .06943 L
.33202 .06859 L
.33588 .06587 L
.33631 .06557 L
.33974 .06321 L
.34197 .06171 L
.34361 .06062 L
.34747 .05809 L
.34784 .05785 L
.35133 .05562 L
.35394 .05399 L
.35519 .05321 L
.35905 .05087 L
.3603 .05012 L
.36291 .04859 L
.36677 .04637 L
.36696 .04626 L
.37064 .04421 L
.37396 .0424 L
.3745 .03899 L
.37836 .03871 L
.38137 .03854 L
.38222 .03511 L
.38608 .03485 L
.38927 .03468 L
.38994 .03466 L
.39381 .03459 L
.39767 .03082 L
.39767 .03082 L
.40153 .03075 L
.40539 .03068 L
.40925 .03062 L
.41311 .03057 L
.41682 .02695 L
.41698 .0268 L
.42084 .02675 L
.4247 .0267 L
.42856 .02666 L
.43242 .02662 L
.43628 .02658 L
.43987 .02309 L
F
0 g
.44015 .02253 m
.44401 .02247 L
.44787 .02241 L
.45173 .02237 L
.45559 .02232 L
.45945 .02228 L
.46331 .02225 L
.46718 .02222 L
.47104 .0222 L
.4749 .02217 L
.47876 .02215 L
.48262 .02214 L
.48648 .02213 L
.49035 .02212 L
.49421 .02211 L
.49807 .0221 L
.50193 .0221 L
.50579 .0221 L
.50965 .02211 L
.51352 .02211 L
.51738 .02212 L
.52124 .02214 L
.5251 .02215 L
.52896 .02217 L
.53282 .02219 L
.53669 .02222 L
.54055 .02224 L
.54441 .02228 L
.54827 .02231 L
.55213 .02235 L
.55599 .0224 L
.55985 .02245 L
.56018 .02309 L
.56372 .02654 L
.56758 .02657 L
.57144 .02661 L
.5753 .02665 L
.57916 .02669 L
.58302 .02674 L
.58324 .02695 L
.58689 .03051 L
.59075 .03056 L
.59461 .03061 L
.59847 .03067 L
.60233 .03073 L
.60242 .03082 L
.60619 .03451 L
.61006 .03457 L
.61392 .03465 L
.61765 .03468 L
Mistroke
.61778 .0348 L
.62164 .0385 L
.6233 .03854 L
.6255 .03866 L
.62936 .03893 L
.63071 .0424 L
.63323 .04376 L
.63709 .04284 L
.63772 .04626 L
.64095 .04811 L
.64438 .05012 L
.64481 .05038 L
.64867 .05271 L
.65074 .05399 L
.65253 .05511 L
.65639 .05756 L
.65684 .05785 L
.66026 .06008 L
.6627 .06171 L
.66412 .06266 L
.66798 .0653 L
.66836 .06557 L
.67184 .06801 L
.67384 .06943 L
.6757 .07078 L
.67914 .07329 L
.67956 .07361 L
.68343 .0765 L
.68429 .07715 L
.68729 .07945 L
.6893 .08102 L
.69115 .08247 L
.69418 .08488 L
.69501 .08555 L
.69887 .08869 L
.69893 .08874 L
.70273 .09189 L
.70358 .0926 L
.7066 .09516 L
.70812 .09646 L
.71046 .09849 L
.71256 .10032 L
.71432 .10188 L
.71691 .10419 L
.71818 .10533 L
.72117 .10805 L
.72204 .10885 L
.72535 .11191 L
.7259 .11243 L
.72945 .11577 L
Mistroke
.72977 .11607 L
.73349 .11963 L
.73363 .11977 L
.73745 .12349 L
.73749 .12353 L
.74134 .12736 L
.74135 .12736 L
.74518 .13122 L
.74521 .13125 L
.74895 .13508 L
.74907 .1352 L
.75267 .13894 L
.75293 .13922 L
.75633 .1428 L
.7568 .14329 L
.75995 .14666 L
.76066 .14743 L
.76351 .15053 L
.76452 .15163 L
.76702 .15439 L
.76838 .1559 L
.77049 .15825 L
.77224 .16022 L
.77391 .16211 L
.7761 .16461 L
.77729 .16597 L
.77997 .16906 L
.78063 .16983 L
.78383 .17357 L
.78393 .17369 L
.78719 .17756 L
.78769 .17815 L
.79042 .18142 L
.79155 .18279 L
.79361 .18528 L
.79541 .18749 L
.79676 .18914 L
.79927 .19225 L
.79988 .193 L
.80297 .19686 L
.80314 .19707 L
.80603 .20073 L
.807 .20196 L
.80905 .20459 L
.81086 .20691 L
.81205 .20845 L
.81472 .21192 L
.81502 .21231 L
.81796 .21617 L
.81858 .217 L
Mistroke
.82087 .22003 L
.82244 .22213 L
.82376 .2239 L
.82631 .22733 L
.82662 .22776 L
.82946 .23162 L
.83017 .23259 L
.83227 .23548 L
.83403 .23791 L
.83506 .23934 L
.83782 .2432 L
.83789 .2433 L
.84056 .24707 L
.84175 .24875 L
.84328 .25093 L
.84561 .25426 L
.84598 .25479 L
.84866 .25865 L
.84947 .25983 L
.85132 .26251 L
.85334 .26547 L
.85395 .26637 L
.85657 .27023 L
.8572 .27116 L
.85917 .2741 L
.86106 .27692 L
.86175 .27796 L
.86431 .28182 L
.86492 .28275 L
.86685 .28568 L
.86878 .28863 L
.86938 .28954 L
.87189 .2934 L
.87264 .29458 L
.87438 .29727 L
.87651 .30059 L
.87685 .30113 L
.87931 .30499 L
.88037 .30666 L
.88175 .30885 L
.88418 .31271 L
.88423 .31279 L
.88659 .31657 L
.88809 .31899 L
.88899 .32044 L
.89137 .3243 L
.89195 .32524 L
.89374 .32816 L
.89581 .33157 L
.89609 .33202 L
Mistroke
.89843 .33588 L
.89968 .33795 L
.90076 .33974 L
.90307 .34361 L
.90354 .34439 L
.90537 .34747 L
.9074 .3509 L
.90765 .35133 L
.90992 .35519 L
.91126 .35747 L
.91218 .35905 L
.91443 .36291 L
.91512 .3641 L
.91667 .36677 L
.91889 .37064 L
.91898 .3708 L
.9211 .3745 L
.92285 .37756 L
.9233 .37836 L
.92549 .38222 L
.92671 .38437 L
.92767 .38608 L
.92984 .38994 L
.93057 .39126 L
.93199 .39381 L
.93414 .39767 L
.93443 .3982 L
.93627 .40153 L
.93829 .40521 L
.93839 .40539 L
.94051 .40925 L
.94215 .41228 L
.94261 .41311 L
.9447 .41698 L
.94601 .41941 L
.94679 .42084 L
.94886 .4247 L
.94988 .4266 L
.95092 .42856 L
.95298 .43242 L
.95374 .43386 L
.95502 .43628 L
.95706 .44015 L
.9576 .44117 L
.95909 .44401 L
.9611 .44787 L
.96146 .44855 L
.96311 .45173 L
.96511 .45559 L
.96532 .456 L
Mistroke
.96711 .45945 L
.96909 .46331 L
.96918 .4635 L
.97106 .46718 L
.97303 .47104 L
.97305 .47107 L
.97646 .4749 L
.97691 .4787 L
.97691 .47876 L
.97724 .48262 L
.9775 .48648 L
.97771 .49035 L
.97789 .49421 L
.97805 .49807 L
.97818 .50193 L
.9783 .50579 L
.97841 .50965 L
.97851 .51352 L
.9786 .51738 L
.97868 .52124 L
.97875 .5251 L
.97882 .52896 L
.97888 .53282 L
.97894 .53669 L
.97899 .54055 L
.97904 .54441 L
.97909 .54827 L
.97913 .55213 L
.97917 .55599 L
.97921 .55985 L
.97691 .5615 L
.97478 .56372 L
.97482 .56758 L
.97485 .57144 L
.97488 .5753 L
.97491 .57916 L
.97493 .58302 L
.97305 .58492 L
.97115 .58689 L
.97117 .59075 L
.97119 .59461 L
.97122 .59847 L
.97124 .60233 L
.96918 .60439 L
.96743 .60619 L
.96745 .61006 L
.96747 .61392 L
.96749 .61778 L
.96532 .61995 L
.96367 .62164 L
Mistroke
.96369 .6255 L
.9637 .62936 L
.96372 .63323 L
.96146 .63549 L
.95989 .63709 L
.95991 .64095 L
.95992 .64481 L
.9576 .64714 L
.95609 .64867 L
.9561 .65253 L
.95611 .65639 L
.95374 .65877 L
.95228 .66026 L
.95229 .66412 L
.9523 .66798 L
.94988 .67041 L
.94846 .67184 L
.94847 .6757 L
.94601 .67816 L
.94463 .67956 L
.94464 .68343 L
.94465 .68729 L
.94215 .68978 L
.9408 .69115 L
.94081 .69501 L
.93829 .69753 L
.93697 .69887 L
.93697 .70273 L
.93443 .70528 L
.93313 .7066 L
.93313 .71046 L
.93057 .71302 L
.92928 .71432 L
.92929 .71818 L
.92671 .72076 L
.92544 .72204 L
.92544 .7259 L
.92285 .7285 L
.92159 .72977 L
.9216 .73363 L
.91898 .73624 L
.91774 .73749 L
.91775 .74135 L
.91512 .74398 L
.91389 .74521 L
.91126 .74784 L
.91004 .74907 L
.91004 .75293 L
.9074 .75558 L
.90618 .7568 L
Mistroke
.90619 .76066 L
.90354 .76331 L
.90233 .76452 L
.89968 .76717 L
.89847 .76838 L
.89847 .77224 L
.89581 .7749 L
.89462 .7761 L
.89195 .77877 L
.89076 .77997 L
.88809 .78263 L
.8869 .78383 L
.8869 .78769 L
.88423 .79036 L
.88304 .79155 L
.88037 .79422 L
.87918 .79541 L
.87651 .79808 L
.87531 .79927 L
.87531 .80314 L
.87264 .8058 L
.87145 .807 L
.86878 .80966 L
.86759 .81086 L
.86492 .81352 L
.86372 .81472 L
.86106 .81738 L
.85986 .81858 L
.8572 .82124 L
.85599 .82244 L
.85334 .8251 L
.85213 .82631 L
.84947 .82896 L
.84826 .83017 L
.84826 .83403 L
.84561 .83667 L
.84439 .83789 L
.84175 .84053 L
.84052 .84175 L
.83789 .84439 L
.83666 .84561 L
.83403 .84824 L
.83017 .84824 L
.82892 .84947 L
.82631 .85209 L
.82505 .85334 L
.82244 .85594 L
.82118 .8572 L
.81858 .85979 L
.81731 .86106 L
Mistroke
.81472 .86365 L
.81344 .86492 L
.81086 .8675 L
.80956 .86878 L
.807 .87135 L
.80569 .87264 L
.80314 .8752 L
.79927 .87519 L
.79795 .87651 L
.79541 .87904 L
.79407 .88037 L
.79155 .88289 L
.7902 .88423 L
.78769 .88674 L
.78383 .88673 L
.78245 .88809 L
.77997 .89057 L
.77857 .89195 L
.7761 .89442 L
.77469 .89581 L
.77224 .89826 L
.76838 .89825 L
.76694 .89968 L
.76452 .9021 L
.76306 .90354 L
.76066 .90594 L
.7568 .90593 L
.75531 .9074 L
.75293 .90977 L
.74907 .90975 L
.74755 .91126 L
.74521 .91359 L
.74366 .91512 L
.74135 .91743 L
.73749 .91742 L
.7359 .91898 L
.73363 .92125 L
.72977 .92124 L
.72814 .92285 L
.7259 .92507 L
.72204 .92506 L
.72037 .92671 L
.71818 .92889 L
.71432 .92887 L
.7126 .93057 L
.71046 .9327 L
.7066 .93269 L
.70482 .93443 L
.70273 .93651 L
.69887 .9365 L
Mistroke
.69704 .93829 L
.69501 .94032 L
.69115 .9403 L
.68926 .94215 L
.68729 .94412 L
.68343 .9441 L
.67956 .94409 L
.6776 .94601 L
.6757 .9479 L
.67184 .94788 L
.6698 .94988 L
.66798 .95169 L
.66412 .95167 L
.66026 .95165 L
.65812 .95374 L
.65639 .95546 L
.65253 .95544 L
.64867 .95541 L
.64643 .9576 L
.64481 .95921 L
.64095 .95919 L
.63709 .95917 L
.63473 .96146 L
.63323 .96296 L
.62936 .96294 L
.6255 .96291 L
.62164 .96289 L
.61914 .96532 L
.61778 .96667 L
.61392 .96665 L
.61006 .96662 L
.60619 .9666 L
.60353 .96918 L
.60233 .97037 L
.59847 .97034 L
.59461 .97032 L
.59075 .97029 L
.58689 .97027 L
.58402 .97305 L
.58302 .97403 L
.57916 .974 L
.5753 .97398 L
.57144 .97395 L
.56758 .97393 L
.56372 .9739 L
.56061 .97691 L
.55985 .9782 L
.55599 .97817 L
.55213 .97814 L
.54827 .97811 L
Mistroke
.54441 .97808 L
.54055 .97805 L
.53669 .97803 L
.53282 .978 L
.52896 .97798 L
.5251 .97796 L
.52124 .97795 L
.51738 .97793 L
.51352 .97792 L
.50965 .97791 L
.50579 .9779 L
.50193 .9779 L
.49807 .9779 L
.49421 .9779 L
.49035 .9779 L
.48648 .97791 L
.48262 .97792 L
.47876 .97793 L
.4749 .97794 L
.47104 .97796 L
.46718 .97798 L
.46331 .978 L
.45945 .97802 L
.45559 .97805 L
.45173 .97807 L
.44787 .9781 L
.44401 .97813 L
.44015 .97816 L
.43942 .97691 L
.43628 .97388 L
.43242 .9739 L
.42856 .97392 L
.4247 .97394 L
.42084 .97397 L
.41698 .974 L
.41602 .97305 L
.41311 .97023 L
.40925 .97026 L
.40539 .97028 L
.40153 .97031 L
.39767 .97034 L
.39651 .96918 L
.39381 .96656 L
.38994 .96659 L
.38608 .96661 L
.38222 .96664 L
.3809 .96532 L
.37836 .96285 L
.3745 .96288 L
.37064 .9629 L
Mistroke
.36677 .96293 L
.3653 .96146 L
.36291 .95913 L
.35905 .95916 L
.35519 .95918 L
.3536 .9576 L
.35133 .95538 L
.34747 .9554 L
.34361 .95543 L
.34191 .95374 L
.33974 .95162 L
.33588 .95164 L
.33202 .95166 L
.33023 .94988 L
.32816 .94785 L
.3243 .94787 L
.32244 .94601 L
.32044 .94405 L
.31657 .94407 L
.31271 .94409 L
.31077 .94215 L
.30885 .94027 L
.30499 .94029 L
.30298 .93829 L
.30113 .93647 L
.29727 .93649 L
.29521 .93443 L
.2934 .93266 L
.28954 .93268 L
.28743 .93057 L
.28568 .92885 L
.28182 .92886 L
.27966 .92671 L
.27796 .92503 L
.2741 .92505 L
.27189 .92285 L
.27023 .92121 L
.26637 .92123 L
.26413 .91898 L
.26251 .91739 L
.25865 .9174 L
.25636 .91512 L
.25479 .91357 L
.25248 .91126 L
.25093 .90973 L
.24707 .90974 L
.24472 .9074 L
.2432 .9059 L
.23934 .90591 L
.23696 .90354 L
Mistroke
.23548 .90207 L
.23308 .89968 L
.23162 .89823 L
.22776 .89824 L
.22533 .89581 L
.2239 .89439 L
.22145 .89195 L
.22003 .89055 L
.21757 .88809 L
.21617 .8867 L
.21231 .88671 L
.20983 .88423 L
.20845 .88287 L
.20595 .88037 L
.20459 .87902 L
.20207 .87651 L
.20073 .87517 L
.19686 .87518 L
.19433 .87264 L
.193 .87133 L
.19046 .86878 L
.18914 .86748 L
.18659 .86492 L
.18528 .86362 L
.18271 .86106 L
.18142 .85977 L
.17884 .8572 L
.17756 .85592 L
.17497 .85334 L
.17369 .85207 L
.1711 .84947 L
.16983 .84821 L
.16597 .84822 L
.16337 .84561 L
.16211 .84436 L
.1595 .84175 L
.15825 .84051 L
.15563 .83789 L
.15439 .83665 L
.15176 .83403 L
.15176 .83017 L
.15053 .82894 L
.14789 .82631 L
.14666 .82508 L
.14403 .82244 L
.1428 .82122 L
.14016 .81858 L
.13894 .81736 L
.1363 .81472 L
.13508 .8135 L
Mistroke
.13244 .81086 L
.13122 .80964 L
.12857 .807 L
.12736 .80578 L
.12471 .80314 L
.12471 .79927 L
.12349 .79806 L
.12085 .79541 L
.11963 .7942 L
.11699 .79155 L
.11577 .79033 L
.11313 .78769 L
.11313 .78383 L
.11191 .78261 L
.10927 .77997 L
.10805 .77874 L
.10541 .7761 L
.10419 .77488 L
.10155 .77224 L
.10155 .76838 L
.10032 .76715 L
.0977 .76452 L
.09646 .76328 L
.09384 .76066 L
.09384 .7568 L
.0926 .75555 L
.08999 .75293 L
.08999 .74907 L
.08874 .74782 L
.08613 .74521 L
.08488 .74395 L
.08228 .74135 L
.08229 .73749 L
.08102 .73621 L
.07843 .73363 L
.07844 .72977 L
.07715 .72847 L
.07459 .7259 L
.07459 .72204 L
.07329 .72073 L
.07074 .71818 L
.07075 .71432 L
.06943 .71299 L
.0669 .71046 L
.06691 .7066 L
.06557 .70525 L
.06306 .70273 L
.06307 .69887 L
.06171 .6975 L
.05922 .69501 L
Mistroke
.05923 .69115 L
.05785 .68975 L
.05539 .68729 L
.0554 .68343 L
.05541 .67956 L
.05399 .67812 L
.05157 .6757 L
.05158 .67184 L
.05012 .67037 L
.04774 .66798 L
.04775 .66412 L
.04776 .66026 L
.04626 .65873 L
.04393 .65639 L
.04394 .65253 L
.04395 .64867 L
.0424 .64709 L
.04013 .64481 L
.04014 .64095 L
.04016 .63709 L
.03854 .63543 L
.03634 .63323 L
.03635 .62936 L
.03637 .6255 L
.03638 .62164 L
.03468 .61989 L
.03257 .61778 L
.03259 .61392 L
.03261 .61006 L
.03263 .60619 L
.03082 .60432 L
.02883 .60233 L
.02886 .59847 L
.02888 .59461 L
.02891 .59075 L
.02893 .58689 L
.02695 .58484 L
.02515 .58302 L
.02518 .57916 L
.02522 .5753 L
.02525 .57144 L
.02528 .56758 L
.02532 .56372 L
.02309 .56138 L
.02091 .55985 L
.02095 .55599 L
.021 .55213 L
.02105 .54827 L
.02111 .54441 L
.02116 .54055 L
Mistroke
.02123 .53669 L
.0213 .53282 L
.02137 .52896 L
.02146 .5251 L
.02155 .52124 L
.02165 .51738 L
.02176 .51352 L
.02189 .50965 L
.02203 .50579 L
.02219 .50193 L
.02238 .49807 L
.02261 .49421 L
.02289 .49035 L
.02309 .48806 L
.02325 .48648 L
.02378 .48262 L
.02695 .48036 L
.02776 .47876 L
.02971 .4749 L
.03082 .47271 L
.03167 .47104 L
.03363 .46718 L
.03468 .46513 L
.03561 .46331 L
.03759 .45945 L
.03854 .45761 L
.03958 .45559 L
.04158 .45173 L
.0424 .45015 L
.04359 .44787 L
.04561 .44401 L
.04626 .44276 L
.04764 .44015 L
.04967 .43628 L
.05012 .43543 L
.05172 .43242 L
.05377 .42856 L
.05399 .42816 L
.05583 .4247 L
.05785 .42095 L
.05791 .42084 L
.05999 .41698 L
.06171 .41381 L
.06208 .41311 L
.06419 .40925 L
.06557 .40672 L
.0663 .40539 L
.06842 .40153 L
.06943 .3997 L
.07056 .39767 L
Mistroke
.0727 .39381 L
.07329 .39274 L
.07486 .38994 L
.07702 .38608 L
.07715 .38585 L
.0792 .38222 L
.08102 .37902 L
.08139 .37836 L
.08359 .3745 L
.08488 .37224 L
.0858 .37064 L
.08802 .36677 L
.08874 .36554 L
.09026 .36291 L
.09251 .35905 L
.0926 .35889 L
.09477 .35519 L
.09646 .35231 L
.09704 .35133 L
.09932 .34747 L
.10032 .34578 L
.10162 .34361 L
.10393 .33974 L
.10419 .33933 L
.10626 .33588 L
.10805 .33293 L
.1086 .33202 L
.11095 .32816 L
.11191 .32659 L
.11332 .3243 L
.1157 .32044 L
.11577 .32032 L
.1181 .31657 L
.11963 .31411 L
.12051 .31271 L
.12293 .30885 L
.12349 .30796 L
.12538 .30499 L
.12736 .30188 L
.12784 .30113 L
.13031 .29727 L
.13122 .29586 L
.1328 .2934 L
.13508 .2899 L
.13531 .28954 L
.13783 .28568 L
.13894 .284 L
.14038 .28182 L
.1428 .27816 L
.14294 .27796 L
Mistroke
.14552 .2741 L
.14666 .27239 L
.14812 .27023 L
.15053 .26668 L
.15073 .26637 L
.15337 .26251 L
.15439 .26103 L
.15603 .25865 L
.15825 .25544 L
.1587 .25479 L
.1614 .25093 L
.16211 .24992 L
.16412 .24707 L
.16597 .24446 L
.16686 .2432 L
.16963 .23934 L
.16983 .23906 L
.17242 .23548 L
.17369 .23372 L
.17523 .23162 L
.17756 .22845 L
.17806 .22776 L
.18093 .2239 L
.18142 .22323 L
.18381 .22003 L
.18528 .21808 L
.18673 .21617 L
.18914 .213 L
.18967 .21231 L
.19263 .20845 L
.193 .20797 L
.19563 .20459 L
.19686 .20301 L
.19866 .20073 L
.20073 .19811 L
.20171 .19686 L
.20459 .19327 L
.2048 .193 L
.20792 .18914 L
.20845 .18849 L
.21108 .18528 L
.21231 .18378 L
.21427 .18142 L
.21617 .17913 L
.21749 .17756 L
.22003 .17454 L
.22075 .17369 L
.2239 .17002 L
.22405 .16983 L
.22739 .16597 L
Mistroke
.22776 .16555 L
.23077 .16211 L
.23162 .16115 L
.23419 .15825 L
.23548 .15681 L
.23766 .15439 L
.23934 .15253 L
.24117 .15053 L
.2432 .14832 L
.24474 .14666 L
.24707 .14417 L
.24835 .1428 L
.25093 .14008 L
.25201 .13894 L
.25479 .13605 L
.25573 .13508 L
.25865 .13208 L
.2595 .13122 L
.26251 .12818 L
.26334 .12736 L
.26637 .12434 L
.26723 .12349 L
.27023 .12056 L
.27119 .11963 L
.2741 .11685 L
.27523 .11577 L
.27796 .11319 L
.27933 .11191 L
.28182 .1096 L
.28351 .10805 L
.28568 .10607 L
.28777 .10419 L
.28954 .10261 L
.29212 .10032 L
.2934 .0992 L
.29656 .09646 L
.29727 .09586 L
.3011 .0926 L
.30113 .09258 L
.30499 .08936 L
.30575 .08874 L
.30885 .08621 L
.3105 .08488 L
.31271 .08312 L
.31538 .08102 L
.31657 .08008 L
.32039 .07715 L
.32044 .07712 L
.3243 .07421 L
.32554 .07329 L
Mistroke
.32816 .07137 L
.33084 .06943 L
.33202 .06859 L
.33588 .06587 L
.33631 .06557 L
.33974 .06321 L
.34197 .06171 L
.34361 .06062 L
.34747 .05809 L
.34784 .05785 L
.35133 .05562 L
.35394 .05399 L
.35519 .05321 L
.35905 .05087 L
.3603 .05012 L
.36291 .04859 L
.36677 .04637 L
.36696 .04626 L
.37064 .04421 L
.37396 .0424 L
.3745 .03899 L
.37836 .03871 L
.38137 .03854 L
.38222 .03511 L
.38608 .03485 L
.38927 .03468 L
.38994 .03466 L
.39381 .03459 L
.39767 .03082 L
.39767 .03082 L
.40153 .03075 L
.40539 .03068 L
.40925 .03062 L
.41311 .03057 L
.41682 .02695 L
.41698 .0268 L
.42084 .02675 L
.4247 .0267 L
.42856 .02666 L
.43242 .02662 L
.43628 .02658 L
.43987 .02309 L
.44015 .02253 L
Mfstroke
.542 1 .5 r
.48648 .08476 m
.49035 .08452 L
.49421 .08436 L
.49807 .08425 L
.50193 .0842 L
.50579 .08422 L
.50965 .0843 L
.51352 .08444 L
.51738 .08465 L
.52075 .08488 L
.52124 .08492 L
.5251 .08525 L
.52896 .08564 L
.53282 .08609 L
.53669 .08661 L
.54055 .08719 L
.54441 .08783 L
.54827 .08853 L
.54934 .08874 L
.55213 .0893 L
.55599 .09013 L
.55985 .09102 L
.56372 .09197 L
.56612 .0926 L
.56758 .09299 L
.57144 .09407 L
.5753 .09521 L
.57916 .09641 L
.57932 .09646 L
.58302 .09768 L
.58689 .09901 L
.59055 .10032 L
.59075 .1004 L
.59461 .10185 L
.59847 .10337 L
.6005 .10419 L
.60233 .10494 L
.60619 .10658 L
.60952 .10805 L
.61006 .10829 L
.61392 .11005 L
.61778 .11188 L
.61784 .11191 L
.62164 .11377 L
.6255 .11572 L
.6256 .11577 L
.62936 .11773 L
.6329 .11963 L
.63323 .11981 L
.63709 .12195 L
.63981 .12349 L
.64095 .12415 L
.64481 .12642 L
.64638 .12736 L
.64867 .12874 L
.65253 .13113 L
.65267 .13122 L
.65639 .13358 L
.65871 .13508 L
.66026 .1361 L
.66412 .13867 L
.66452 .13894 L
.66798 .14131 L
.67012 .1428 L
.67184 .14401 L
.67555 .14666 L
.6757 .14677 L
.67956 .1496 L
.68081 .15053 L
.68343 .15249 L
.68592 .15439 L
.68729 .15544 L
.69089 .15825 L
.69115 .15845 L
.69501 .16152 L
.69574 .16211 L
.69887 .16466 L
.70046 .16597 L
.70273 .16786 L
.70508 .16983 L
.7066 .17112 L
.70959 .17369 L
.71046 .17445 L
.714 .17756 L
.71432 .17784 L
.71818 .18129 L
.71833 .18142 L
.72204 .1848 L
.72257 .18528 L
.7259 .18837 L
.72673 .18914 L
.72977 .19201 L
.73081 .193 L
.73363 .19571 L
.73482 .19686 L
.73749 .19947 L
.73877 .20073 L
.74135 .20329 L
.74264 .20459 L
.74521 .20718 L
.74646 .20845 L
.74907 .21113 L
.75022 .21231 L
.75293 .21514 L
.75392 .21617 L
.7568 .21921 L
.75757 .22003 L
.76066 .22335 L
.76117 .2239 L
.76452 .22755 L
.76471 .22776 L
.76821 .23162 L
.76838 .23181 L
.77167 .23548 L
.77224 .23613 L
.77508 .23934 L
.7761 .24051 L
.77845 .2432 L
.77997 .24496 L
.78177 .24707 L
.78383 .24947 L
.78506 .25093 L
.78769 .25404 L
.78831 .25479 L
.79153 .25865 L
.79155 .25868 L
.79471 .26251 L
.79541 .26338 L
.79785 .26637 L
.79927 .26814 L
.80096 .27023 L
.80314 .27296 L
.80404 .2741 L
.807 .27784 L
.80709 .27796 L
.81011 .28182 L
.81086 .28279 L
.81309 .28568 L
.81472 .2878 L
.81605 .28954 L
.81858 .29287 L
.81899 .2934 L
.82189 .29727 L
.82244 .298 L
.82477 .30113 L
.82631 .3032 L
.82762 .30499 L
.83017 .30846 L
.83045 .30885 L
.83326 .31271 L
.83403 .31378 L
.83604 .31657 L
.83789 .31916 L
.8388 .32044 L
.84153 .3243 L
.84175 .32461 L
.84424 .32816 L
.84561 .33012 L
.84694 .33202 L
.84947 .33569 L
.84961 .33588 L
.85226 .33974 L
.85334 .34132 L
.85489 .34361 L
.8572 .34702 L
.8575 .34747 L
.86009 .35133 L
.86106 .35278 L
.86267 .35519 L
.86492 .3586 L
.86522 .35905 L
.86776 .36291 L
.86878 .36448 L
.87028 .36677 L
.87264 .37042 L
.87278 .37064 L
.87527 .3745 L
.87651 .37643 L
.87774 .37836 L
.88019 .38222 L
.88037 .3825 L
.88263 .38608 L
.88423 .38863 L
.88505 .38994 L
.88746 .39381 L
.88809 .39483 L
.88985 .39767 L
.89195 .40109 L
.89222 .40153 L
.89459 .40539 L
.89581 .4074 L
.89694 .40925 L
.89927 .41311 L
.89968 .41379 L
.90159 .41698 L
.90354 .42023 L
.9039 .42084 L
.90619 .4247 L
.9074 .42674 L
.90847 .42856 L
.91074 .43242 L
.91126 .43331 L
.913 .43628 L
.91512 .43994 L
.91524 .44015 L
.91747 .44401 L
.91898 .44663 L
.91969 .44787 L
.9219 .45173 L
.92285 .45339 L
.9241 .45559 L
.92628 .45945 L
.92671 .46021 L
.92846 .46331 L
.93057 .46709 L
.93062 .46718 L
.93277 .47104 L
.93443 .47403 L
.93491 .4749 L
.93704 .47876 L
.93829 .48104 L
.93916 .48262 L
.94127 .48648 L
.94215 .4881 L
.94337 .49035 L
.94546 .49421 L
.94601 .49523 L
.94754 .49807 L
.94961 .50193 L
.94988 .50243 L
.95167 .50579 L
.95372 .50965 L
.95374 .50968 L
.95576 .51352 L
.9576 .517 L
.9578 .51738 L
.95982 .52124 L
.96146 .52438 L
.96184 .5251 L
.96384 .52896 L
.96532 .53182 L
.96584 .53282 L
.96783 .53669 L
.96918 .53933 L
.96981 .54055 L
.97178 .54441 L
.97305 .5469 L
.97651 .54827 L
.97677 .55213 L
.97691 .55452 L
.97698 .55599 L
.97716 .55985 L
.97691 .55997 L
.97337 .56372 L
.97344 .56758 L
.9735 .57144 L
.97355 .5753 L
.97361 .57916 L
.97366 .58302 L
.97305 .58364 L
.96993 .58689 L
.96998 .59075 L
.97002 .59461 L
.97006 .59847 L
.9701 .60233 L
.96918 .60325 L
.96634 .60619 L
.96637 .61006 L
.9664 .61392 L
.96643 .61778 L
.96532 .61889 L
.96265 .62164 L
.96268 .6255 L
.9627 .62936 L
.96273 .63323 L
.96146 .6345 L
.95893 .63709 L
.95895 .64095 L
.95897 .64481 L
.9576 .64619 L
.95517 .64867 L
.95519 .65253 L
.9552 .65639 L
.95374 .65787 L
.95139 .66026 L
.95141 .66412 L
.95142 .66798 L
.94988 .66953 L
.9476 .67184 L
.94762 .6757 L
.94601 .67731 L
.94379 .67956 L
.9438 .68343 L
.94382 .68729 L
.94215 .68895 L
.93999 .69115 L
.94 .69501 L
.93829 .69672 L
.93616 .69887 L
.93617 .70273 L
.93443 .70448 L
.93234 .7066 L
.93234 .71046 L
.93057 .71224 L
.92851 .71432 L
.92851 .71818 L
.92671 .71999 L
.92467 .72204 L
.92468 .7259 L
.92285 .72774 L
.92083 .72977 L
.92084 .73363 L
.91898 .73548 L
.91699 .73749 L
.917 .74135 L
.91512 .74323 L
.91315 .74521 L
.91126 .7471 L
.9093 .74907 L
.9093 .75293 L
.9074 .75484 L
.90545 .7568 L
.90545 .76066 L
.90354 .76258 L
.9016 .76452 L
.89968 .76645 L
.89775 .76838 L
.89775 .77224 L
.89581 .77418 L
.89389 .7761 L
.89195 .77804 L
.89003 .77997 L
.88809 .78191 L
.88618 .78383 L
.88618 .78769 L
.88423 .78964 L
.88232 .79155 L
.88037 .7935 L
.87846 .79541 L
.87651 .79736 L
.87459 .79927 L
.87459 .80314 L
.87264 .80508 L
.87073 .807 L
.86878 .80894 L
.86686 .81086 L
.86492 .8128 L
.863 .81472 L
.86106 .81666 L
.85913 .81858 L
.8572 .82052 L
.85527 .82244 L
.85334 .82437 L
.8514 .82631 L
.84947 .82823 L
.84753 .83017 L
.84752 .83403 L
.84561 .83594 L
.84365 .83789 L
.84175 .83979 L
.83978 .84175 L
.83789 .84364 L
.83591 .84561 L
.83403 .84749 L
.83017 .84749 L
.82817 .84947 L
.82631 .85133 L
.82429 .85334 L
.82244 .85518 L
.82042 .8572 L
.81858 .85903 L
.81654 .86106 L
.81472 .86288 L
.81266 .86492 L
.81086 .86672 L
.80878 .86878 L
.807 .87056 L
.8049 .87264 L
.80314 .87441 L
.79927 .87439 L
.79714 .87651 L
.79541 .87823 L
.79326 .88037 L
.79155 .88207 L
.78937 .88423 L
.78769 .88591 L
.78383 .8859 L
.78161 .88809 L
.77997 .88973 L
.77772 .89195 L
.7761 .89357 L
.77383 .89581 L
.77224 .8974 L
.76838 .89738 L
.76606 .89968 L
.76452 .90122 L
.76217 .90354 L
.76066 .90504 L
.7568 .90503 L
.75439 .9074 L
.75293 .90885 L
.74907 .90883 L
.74661 .91126 L
.74521 .91265 L
.74271 .91512 L
.74135 .91648 L
.73749 .91645 L
.73492 .91898 L
.73363 .92027 L
.72977 .92025 L
.72712 .92285 L
.7259 .92406 L
.72204 .92404 L
.71932 .92671 L
.71818 .92785 L
.71432 .92782 L
.71152 .93057 L
.71046 .93162 L
.7066 .9316 L
.7037 .93443 L
.70273 .93539 L
.69887 .93537 L
.69588 .93829 L
.69501 .93916 L
.69115 .93913 L
.68805 .94215 L
.68729 .94291 L
.68343 .94288 L
.67956 .94284 L
.67631 .94601 L
.6757 .94662 L
.67184 .94658 L
.66846 .94988 L
.66798 .95035 L
.66412 .95031 L
.66026 .95027 L
.65668 .95374 L
.65639 .95402 L
.65253 .95398 L
.64867 .95393 L
.64488 .9576 L
.64481 .95767 L
.64095 .95762 L
.63944 .9576 L
.63709 .95752 L
.63323 .95402 L
.63271 .95374 L
.62936 .95188 L
.62564 .94988 L
.6255 .9498 L
.62164 .94779 L
.61815 .94601 L
.61778 .94583 L
.61392 .94393 L
.61017 .94215 L
.61006 .9421 L
.60619 .94033 L
.60233 .93862 L
.60158 .93829 L
.59847 .93697 L
.59461 .93539 L
.59221 .93443 L
.59075 .93386 L
.58689 .9324 L
.58302 .931 L
.58181 .93057 L
.57916 .92966 L
.5753 .92838 L
.57144 .92716 L
.56994 .92671 L
.56758 .92601 L
.56372 .92491 L
.55985 .92388 L
.55599 .92291 L
.55571 .92285 L
.55213 .922 L
.54827 .92116 L
.54441 .92037 L
.54055 .91965 L
.53669 .91899 L
.53665 .91898 L
.53282 .91839 L
.52896 .91785 L
.5251 .91738 L
.52124 .91696 L
.51738 .91661 L
.51352 .91632 L
.50965 .91609 L
.50579 .91592 L
.50193 .91581 L
.49807 .91577 L
.49421 .91578 L
.49035 .91586 L
.48648 .916 L
.48262 .91621 L
.47876 .91647 L
.4749 .91679 L
.47104 .91718 L
.46718 .91763 L
.46331 .91814 L
.45945 .91871 L
.45776 .91898 L
.45559 .91935 L
.45173 .92004 L
.44787 .9208 L
.44401 .92162 L
.44015 .9225 L
.43869 .92285 L
.43628 .92344 L
.43242 .92444 L
.42856 .92551 L
.4247 .92664 L
.42446 .92671 L
.42084 .92783 L
.41698 .92908 L
.41311 .93039 L
.4126 .93057 L
.40925 .93176 L
.40539 .9332 L
.4022 .93443 L
.40153 .93469 L
.39767 .93625 L
.39381 .93787 L
.39283 .93829 L
.38994 .93955 L
.38608 .9413 L
.38424 .94215 L
.38222 .9431 L
.37836 .94497 L
.37625 .94601 L
.3745 .9469 L
.37064 .94889 L
.36877 .94988 L
.36677 .95094 L
.36291 .95306 L
.36169 .95374 L
.35905 .95746 L
.35519 .95759 L
.35133 .95386 L
.34747 .95391 L
.34361 .95396 L
.34338 .95374 L
.33974 .95021 L
.33588 .95025 L
.33202 .95029 L
.3316 .94988 L
.32816 .94652 L
.3243 .94656 L
.32375 .94601 L
.32044 .94279 L
.31657 .94282 L
.31271 .94286 L
.312 .94215 L
.30885 .93907 L
.30499 .9391 L
.30417 .93829 L
.30113 .93531 L
.29727 .93534 L
.29635 .93443 L
.2934 .93155 L
.28954 .93157 L
.28853 .93057 L
.28568 .92777 L
.28182 .9278 L
.28072 .92671 L
.27796 .92399 L
.2741 .92401 L
.27292 .92285 L
.27023 .9202 L
.26637 .92023 L
.26513 .91898 L
.26251 .91641 L
.25865 .91643 L
.25734 .91512 L
.25479 .91261 L
.25343 .91126 L
.25093 .90879 L
.24707 .90881 L
.24565 .9074 L
.2432 .90498 L
.23934 .905 L
.23787 .90354 L
.23548 .90117 L
.23398 .89968 L
.23162 .89735 L
.22776 .89736 L
.22621 .89581 L
.2239 .89353 L
.22232 .89195 L
.22003 .8897 L
.21843 .88809 L
.21617 .88586 L
.21231 .88587 L
.21066 .88423 L
.20845 .88204 L
.20678 .88037 L
.20459 .8782 L
.20289 .87651 L
.20073 .87436 L
.19686 .87437 L
.19514 .87264 L
.193 .87053 L
.19126 .86878 L
.18914 .86668 L
.18738 .86492 L
.18528 .86284 L
.1835 .86106 L
.18142 .85899 L
.17962 .8572 L
.17756 .85515 L
.17574 .85334 L
.17369 .8513 L
.17187 .84947 L
.16983 .84745 L
.16597 .84746 L
.16413 .84561 L
.16211 .84361 L
.16025 .84175 L
.15825 .83976 L
.15638 .83789 L
.15439 .8359 L
.15251 .83403 L
.15251 .83017 L
.15053 .82819 L
.14864 .82631 L
.14666 .82434 L
.14477 .82244 L
.1428 .82048 L
.1409 .81858 L
.13894 .81662 L
.13704 .81472 L
.13508 .81277 L
.13317 .81086 L
.13122 .80891 L
.12931 .807 L
.12736 .80505 L
.12544 .80314 L
.12544 .79927 L
.12349 .79732 L
.12158 .79541 L
.11963 .79346 L
.11772 .79155 L
.11577 .7896 L
.11386 .78769 L
.11386 .78383 L
.11191 .78187 L
.11001 .77997 L
.10805 .778 L
.10615 .7761 L
.10419 .77414 L
.10229 .77224 L
.10229 .76838 L
.10032 .7664 L
.09844 .76452 L
.09646 .76253 L
.09459 .76066 L
.09459 .7568 L
.0926 .7548 L
.09074 .75293 L
.09074 .74907 L
.08874 .74706 L
.08689 .74521 L
.08488 .74318 L
.08305 .74135 L
.08305 .73749 L
.08102 .73544 L
.07921 .73363 L
.07921 .72977 L
.07715 .72769 L
.07537 .7259 L
.07538 .72204 L
.07329 .71994 L
.07154 .71818 L
.07154 .71432 L
.06943 .71218 L
.06771 .71046 L
.06772 .7066 L
.06557 .70443 L
.06388 .70273 L
.06389 .69887 L
.06171 .69666 L
.06006 .69501 L
.06007 .69115 L
.05785 .68889 L
.05624 .68729 L
.05626 .68343 L
.05627 .67956 L
.05399 .67724 L
.05245 .6757 L
.05246 .67184 L
.05012 .66946 L
.04865 .66798 L
.04866 .66412 L
.04868 .66026 L
.04626 .65779 L
.04487 .65639 L
.04489 .65253 L
.04491 .64867 L
.0424 .64611 L
.04111 .64481 L
.04113 .64095 L
.04115 .63709 L
.03854 .6344 L
.03737 .63323 L
.03739 .62936 L
.03742 .6255 L
.03745 .62164 L
.03468 .61879 L
.03368 .61778 L
.03371 .61392 L
.03374 .61006 L
.03378 .60619 L
.03082 .60312 L
.03003 .60233 L
.03007 .59847 L
.03012 .59461 L
.03016 .59075 L
.03021 .58689 L
.02695 .58348 L
.02651 .58302 L
.02657 .57916 L
.02663 .5753 L
.02669 .57144 L
.02676 .56758 L
.02683 .56372 L
.02344 .55985 L
.02695 .55791 L
.02792 .55599 L
.02986 .55213 L
.03082 .55025 L
.03182 .54827 L
.03378 .54441 L
.03468 .54265 L
.03575 .54055 L
.03773 .53669 L
.03854 .53512 L
.03972 .53282 L
.04172 .52896 L
.0424 .52765 L
.04372 .5251 L
.04574 .52124 L
.04626 .52024 L
.04776 .51738 L
.0498 .51352 L
.05012 .51289 L
.05184 .50965 L
.05389 .50579 L
.05399 .50561 L
.05595 .50193 L
.05785 .49839 L
.05802 .49807 L
.0601 .49421 L
.06171 .49123 L
.06219 .49035 L
.06429 .48648 L
.06557 .48413 L
.0664 .48262 L
.06852 .47876 L
.06943 .4771 L
.07065 .4749 L
.07279 .47104 L
.07329 .47013 L
.07494 .46718 L
.0771 .46331 L
.07715 .46322 L
.07927 .45945 L
.08102 .45637 L
.08146 .45559 L
.08365 .45173 L
.08488 .44959 L
.08586 .44787 L
.08808 .44401 L
.08874 .44286 L
.09031 .44015 L
.09256 .43628 L
.0926 .43621 L
.09481 .43242 L
.09646 .42961 L
.09708 .42856 L
.09936 .4247 L
.10032 .42307 L
.10165 .42084 L
.10396 .41698 L
.10419 .4166 L
.10628 .41311 L
.10805 .41019 L
.10862 .40925 L
.11096 .40539 L
.11191 .40384 L
.11333 .40153 L
.1157 .39767 L
.11577 .39756 L
.11809 .39381 L
.11963 .39134 L
.1205 .38994 L
.12292 .38608 L
.12349 .38518 L
.12536 .38222 L
.12736 .37908 L
.12781 .37836 L
.13028 .3745 L
.13122 .37304 L
.13277 .37064 L
.13508 .36707 L
.13527 .36677 L
.13779 .36291 L
.13894 .36116 L
.14033 .35905 L
.1428 .35531 L
.14288 .35519 L
.14545 .35133 L
.14666 .34952 L
.14805 .34747 L
.15053 .3438 L
.15066 .34361 L
.15329 .33974 L
.15439 .33814 L
.15594 .33588 L
.15825 .33254 L
.15861 .33202 L
.1613 .32816 L
.16211 .327 L
.16401 .3243 L
.16597 .32153 L
.16675 .32044 L
.16951 .31657 L
.16983 .31612 L
.17229 .31271 L
.17369 .31077 L
.17509 .30885 L
.17756 .30548 L
.17792 .30499 L
.18077 .30113 L
.18142 .30026 L
.18365 .29727 L
.18528 .2951 L
.18656 .2934 L
.18914 .29 L
.18949 .28954 L
.19245 .28568 L
.193 .28496 L
.19544 .28182 L
.19686 .27999 L
.19845 .27796 L
.20073 .27508 L
.2015 .2741 L
.20458 .27023 L
.20459 .27023 L
.20769 .26637 L
.20845 .26544 L
.21084 .26251 L
.21231 .26071 L
.21401 .25865 L
.21617 .25605 L
.21723 .25479 L
.22003 .25145 L
.22048 .25093 L
.22377 .24707 L
.2239 .24691 L
.22709 .2432 L
.22776 .24244 L
.23046 .23934 L
.23162 .23803 L
.23387 .23548 L
.23548 .23368 L
.23733 .23162 L
.23934 .22939 L
.24082 .22776 L
.2432 .22516 L
.24437 .2239 L
.24707 .221 L
.24797 .22003 L
.25093 .2169 L
.25162 .21617 L
.25479 .21286 L
.25532 .21231 L
.25865 .20888 L
.25908 .20845 L
.26251 .20497 L
.26289 .20459 L
.26637 .20112 L
.26677 .20073 L
.27023 .19733 L
.27071 .19686 L
.2741 .1936 L
.27473 .193 L
.27796 .18994 L
.27881 .18914 L
.28182 .18634 L
.28297 .18528 L
.28568 .1828 L
.28721 .18142 L
.28954 .17932 L
.29153 .17756 L
.2934 .17591 L
.29595 .17369 L
.29727 .17256 L
.30046 .16983 L
.30113 .16927 L
.30499 .16604 L
.30507 .16597 L
.30885 .16288 L
.3098 .16211 L
.31271 .15977 L
.31464 .15825 L
.31657 .15673 L
.31961 .15439 L
.32044 .15376 L
.3243 .15084 L
.32472 .15053 L
.32816 .14799 L
.32998 .14666 L
.33202 .1452 L
.33541 .1428 L
.33588 .14247 L
.33974 .1398 L
.34101 .13894 L
.34361 .1372 L
.34682 .13508 L
.34747 .13466 L
.35133 .13218 L
.35286 .13122 L
.35519 .12977 L
.35905 .12741 L
.35915 .12736 L
.36291 .12512 L
.36572 .12349 L
.36677 .12289 L
.37064 .12073 L
.37263 .11963 L
.3745 .11862 L
.37836 .11658 L
.37993 .11577 L
.38222 .1146 L
.38608 .11269 L
.38769 .11191 L
.38994 .11083 L
.39381 .10904 L
.39601 .10805 L
.39767 .10731 L
.40153 .10564 L
.40503 .10419 L
.40539 .10404 L
.40925 .1025 L
.41311 .10102 L
.41498 .10032 L
.41698 .0996 L
.42084 .09824 L
.4247 .09695 L
.42621 .09646 L
.42856 .09572 L
.43242 .09455 L
.43628 .09345 L
.4394 .0926 L
.44015 .09241 L
.44401 .09142 L
.44787 .09051 L
.45173 .08965 L
.45559 .08886 L
.45619 .08874 L
.45945 .08813 L
.46331 .08746 L
.46718 .08685 L
.47104 .08631 L
.4749 .08583 L
.47876 .08541 L
.48262 .08505 L
.48477 .08488 L
F
0 g
.48648 .08476 m
.49035 .08452 L
.49421 .08436 L
.49807 .08425 L
.50193 .0842 L
.50579 .08422 L
.50965 .0843 L
.51352 .08444 L
.51738 .08465 L
.52075 .08488 L
.52124 .08492 L
.5251 .08525 L
.52896 .08564 L
.53282 .08609 L
.53669 .08661 L
.54055 .08719 L
.54441 .08783 L
.54827 .08853 L
.54934 .08874 L
.55213 .0893 L
.55599 .09013 L
.55985 .09102 L
.56372 .09197 L
.56612 .0926 L
.56758 .09299 L
.57144 .09407 L
.5753 .09521 L
.57916 .09641 L
.57932 .09646 L
.58302 .09768 L
.58689 .09901 L
.59055 .10032 L
.59075 .1004 L
.59461 .10185 L
.59847 .10337 L
.6005 .10419 L
.60233 .10494 L
.60619 .10658 L
.60952 .10805 L
.61006 .10829 L
.61392 .11005 L
.61778 .11188 L
.61784 .11191 L
.62164 .11377 L
.6255 .11572 L
.6256 .11577 L
.62936 .11773 L
.6329 .11963 L
.63323 .11981 L
.63709 .12195 L
Mistroke
.63981 .12349 L
.64095 .12415 L
.64481 .12642 L
.64638 .12736 L
.64867 .12874 L
.65253 .13113 L
.65267 .13122 L
.65639 .13358 L
.65871 .13508 L
.66026 .1361 L
.66412 .13867 L
.66452 .13894 L
.66798 .14131 L
.67012 .1428 L
.67184 .14401 L
.67555 .14666 L
.6757 .14677 L
.67956 .1496 L
.68081 .15053 L
.68343 .15249 L
.68592 .15439 L
.68729 .15544 L
.69089 .15825 L
.69115 .15845 L
.69501 .16152 L
.69574 .16211 L
.69887 .16466 L
.70046 .16597 L
.70273 .16786 L
.70508 .16983 L
.7066 .17112 L
.70959 .17369 L
.71046 .17445 L
.714 .17756 L
.71432 .17784 L
.71818 .18129 L
.71833 .18142 L
.72204 .1848 L
.72257 .18528 L
.7259 .18837 L
.72673 .18914 L
.72977 .19201 L
.73081 .193 L
.73363 .19571 L
.73482 .19686 L
.73749 .19947 L
.73877 .20073 L
.74135 .20329 L
.74264 .20459 L
.74521 .20718 L
Mistroke
.74646 .20845 L
.74907 .21113 L
.75022 .21231 L
.75293 .21514 L
.75392 .21617 L
.7568 .21921 L
.75757 .22003 L
.76066 .22335 L
.76117 .2239 L
.76452 .22755 L
.76471 .22776 L
.76821 .23162 L
.76838 .23181 L
.77167 .23548 L
.77224 .23613 L
.77508 .23934 L
.7761 .24051 L
.77845 .2432 L
.77997 .24496 L
.78177 .24707 L
.78383 .24947 L
.78506 .25093 L
.78769 .25404 L
.78831 .25479 L
.79153 .25865 L
.79155 .25868 L
.79471 .26251 L
.79541 .26338 L
.79785 .26637 L
.79927 .26814 L
.80096 .27023 L
.80314 .27296 L
.80404 .2741 L
.807 .27784 L
.80709 .27796 L
.81011 .28182 L
.81086 .28279 L
.81309 .28568 L
.81472 .2878 L
.81605 .28954 L
.81858 .29287 L
.81899 .2934 L
.82189 .29727 L
.82244 .298 L
.82477 .30113 L
.82631 .3032 L
.82762 .30499 L
.83017 .30846 L
.83045 .30885 L
.83326 .31271 L
Mistroke
.83403 .31378 L
.83604 .31657 L
.83789 .31916 L
.8388 .32044 L
.84153 .3243 L
.84175 .32461 L
.84424 .32816 L
.84561 .33012 L
.84694 .33202 L
.84947 .33569 L
.84961 .33588 L
.85226 .33974 L
.85334 .34132 L
.85489 .34361 L
.8572 .34702 L
.8575 .34747 L
.86009 .35133 L
.86106 .35278 L
.86267 .35519 L
.86492 .3586 L
.86522 .35905 L
.86776 .36291 L
.86878 .36448 L
.87028 .36677 L
.87264 .37042 L
.87278 .37064 L
.87527 .3745 L
.87651 .37643 L
.87774 .37836 L
.88019 .38222 L
.88037 .3825 L
.88263 .38608 L
.88423 .38863 L
.88505 .38994 L
.88746 .39381 L
.88809 .39483 L
.88985 .39767 L
.89195 .40109 L
.89222 .40153 L
.89459 .40539 L
.89581 .4074 L
.89694 .40925 L
.89927 .41311 L
.89968 .41379 L
.90159 .41698 L
.90354 .42023 L
.9039 .42084 L
.90619 .4247 L
.9074 .42674 L
.90847 .42856 L
Mistroke
.91074 .43242 L
.91126 .43331 L
.913 .43628 L
.91512 .43994 L
.91524 .44015 L
.91747 .44401 L
.91898 .44663 L
.91969 .44787 L
.9219 .45173 L
.92285 .45339 L
.9241 .45559 L
.92628 .45945 L
.92671 .46021 L
.92846 .46331 L
.93057 .46709 L
.93062 .46718 L
.93277 .47104 L
.93443 .47403 L
.93491 .4749 L
.93704 .47876 L
.93829 .48104 L
.93916 .48262 L
.94127 .48648 L
.94215 .4881 L
.94337 .49035 L
.94546 .49421 L
.94601 .49523 L
.94754 .49807 L
.94961 .50193 L
.94988 .50243 L
.95167 .50579 L
.95372 .50965 L
.95374 .50968 L
.95576 .51352 L
.9576 .517 L
.9578 .51738 L
.95982 .52124 L
.96146 .52438 L
.96184 .5251 L
.96384 .52896 L
.96532 .53182 L
.96584 .53282 L
.96783 .53669 L
.96918 .53933 L
.96981 .54055 L
.97178 .54441 L
.97305 .5469 L
.97651 .54827 L
.97677 .55213 L
.97691 .55452 L
Mistroke
.97698 .55599 L
.97716 .55985 L
.97691 .55997 L
.97337 .56372 L
.97344 .56758 L
.9735 .57144 L
.97355 .5753 L
.97361 .57916 L
.97366 .58302 L
.97305 .58364 L
.96993 .58689 L
.96998 .59075 L
.97002 .59461 L
.97006 .59847 L
.9701 .60233 L
.96918 .60325 L
.96634 .60619 L
.96637 .61006 L
.9664 .61392 L
.96643 .61778 L
.96532 .61889 L
.96265 .62164 L
.96268 .6255 L
.9627 .62936 L
.96273 .63323 L
.96146 .6345 L
.95893 .63709 L
.95895 .64095 L
.95897 .64481 L
.9576 .64619 L
.95517 .64867 L
.95519 .65253 L
.9552 .65639 L
.95374 .65787 L
.95139 .66026 L
.95141 .66412 L
.95142 .66798 L
.94988 .66953 L
.9476 .67184 L
.94762 .6757 L
.94601 .67731 L
.94379 .67956 L
.9438 .68343 L
.94382 .68729 L
.94215 .68895 L
.93999 .69115 L
.94 .69501 L
.93829 .69672 L
.93616 .69887 L
.93617 .70273 L
Mistroke
.93443 .70448 L
.93234 .7066 L
.93234 .71046 L
.93057 .71224 L
.92851 .71432 L
.92851 .71818 L
.92671 .71999 L
.92467 .72204 L
.92468 .7259 L
.92285 .72774 L
.92083 .72977 L
.92084 .73363 L
.91898 .73548 L
.91699 .73749 L
.917 .74135 L
.91512 .74323 L
.91315 .74521 L
.91126 .7471 L
.9093 .74907 L
.9093 .75293 L
.9074 .75484 L
.90545 .7568 L
.90545 .76066 L
.90354 .76258 L
.9016 .76452 L
.89968 .76645 L
.89775 .76838 L
.89775 .77224 L
.89581 .77418 L
.89389 .7761 L
.89195 .77804 L
.89003 .77997 L
.88809 .78191 L
.88618 .78383 L
.88618 .78769 L
.88423 .78964 L
.88232 .79155 L
.88037 .7935 L
.87846 .79541 L
.87651 .79736 L
.87459 .79927 L
.87459 .80314 L
.87264 .80508 L
.87073 .807 L
.86878 .80894 L
.86686 .81086 L
.86492 .8128 L
.863 .81472 L
.86106 .81666 L
.85913 .81858 L
Mistroke
.8572 .82052 L
.85527 .82244 L
.85334 .82437 L
.8514 .82631 L
.84947 .82823 L
.84753 .83017 L
.84752 .83403 L
.84561 .83594 L
.84365 .83789 L
.84175 .83979 L
.83978 .84175 L
.83789 .84364 L
.83591 .84561 L
.83403 .84749 L
.83017 .84749 L
.82817 .84947 L
.82631 .85133 L
.82429 .85334 L
.82244 .85518 L
.82042 .8572 L
.81858 .85903 L
.81654 .86106 L
.81472 .86288 L
.81266 .86492 L
.81086 .86672 L
.80878 .86878 L
.807 .87056 L
.8049 .87264 L
.80314 .87441 L
.79927 .87439 L
.79714 .87651 L
.79541 .87823 L
.79326 .88037 L
.79155 .88207 L
.78937 .88423 L
.78769 .88591 L
.78383 .8859 L
.78161 .88809 L
.77997 .88973 L
.77772 .89195 L
.7761 .89357 L
.77383 .89581 L
.77224 .8974 L
.76838 .89738 L
.76606 .89968 L
.76452 .90122 L
.76217 .90354 L
.76066 .90504 L
.7568 .90503 L
.75439 .9074 L
Mistroke
.75293 .90885 L
.74907 .90883 L
.74661 .91126 L
.74521 .91265 L
.74271 .91512 L
.74135 .91648 L
.73749 .91645 L
.73492 .91898 L
.73363 .92027 L
.72977 .92025 L
.72712 .92285 L
.7259 .92406 L
.72204 .92404 L
.71932 .92671 L
.71818 .92785 L
.71432 .92782 L
.71152 .93057 L
.71046 .93162 L
.7066 .9316 L
.7037 .93443 L
.70273 .93539 L
.69887 .93537 L
.69588 .93829 L
.69501 .93916 L
.69115 .93913 L
.68805 .94215 L
.68729 .94291 L
.68343 .94288 L
.67956 .94284 L
.67631 .94601 L
.6757 .94662 L
.67184 .94658 L
.66846 .94988 L
.66798 .95035 L
.66412 .95031 L
.66026 .95027 L
.65668 .95374 L
.65639 .95402 L
.65253 .95398 L
.64867 .95393 L
.64488 .9576 L
.64481 .95767 L
.64095 .95762 L
.63944 .9576 L
.63709 .95752 L
.63323 .95402 L
.63271 .95374 L
.62936 .95188 L
.62564 .94988 L
.6255 .9498 L
Mistroke
.62164 .94779 L
.61815 .94601 L
.61778 .94583 L
.61392 .94393 L
.61017 .94215 L
.61006 .9421 L
.60619 .94033 L
.60233 .93862 L
.60158 .93829 L
.59847 .93697 L
.59461 .93539 L
.59221 .93443 L
.59075 .93386 L
.58689 .9324 L
.58302 .931 L
.58181 .93057 L
.57916 .92966 L
.5753 .92838 L
.57144 .92716 L
.56994 .92671 L
.56758 .92601 L
.56372 .92491 L
.55985 .92388 L
.55599 .92291 L
.55571 .92285 L
.55213 .922 L
.54827 .92116 L
.54441 .92037 L
.54055 .91965 L
.53669 .91899 L
.53665 .91898 L
.53282 .91839 L
.52896 .91785 L
.5251 .91738 L
.52124 .91696 L
.51738 .91661 L
.51352 .91632 L
.50965 .91609 L
.50579 .91592 L
.50193 .91581 L
.49807 .91577 L
.49421 .91578 L
.49035 .91586 L
.48648 .916 L
.48262 .91621 L
.47876 .91647 L
.4749 .91679 L
.47104 .91718 L
.46718 .91763 L
.46331 .91814 L
Mistroke
.45945 .91871 L
.45776 .91898 L
.45559 .91935 L
.45173 .92004 L
.44787 .9208 L
.44401 .92162 L
.44015 .9225 L
.43869 .92285 L
.43628 .92344 L
.43242 .92444 L
.42856 .92551 L
.4247 .92664 L
.42446 .92671 L
.42084 .92783 L
.41698 .92908 L
.41311 .93039 L
.4126 .93057 L
.40925 .93176 L
.40539 .9332 L
.4022 .93443 L
.40153 .93469 L
.39767 .93625 L
.39381 .93787 L
.39283 .93829 L
.38994 .93955 L
.38608 .9413 L
.38424 .94215 L
.38222 .9431 L
.37836 .94497 L
.37625 .94601 L
.3745 .9469 L
.37064 .94889 L
.36877 .94988 L
.36677 .95094 L
.36291 .95306 L
.36169 .95374 L
.35905 .95746 L
.35519 .95759 L
.35133 .95386 L
.34747 .95391 L
.34361 .95396 L
.34338 .95374 L
.33974 .95021 L
.33588 .95025 L
.33202 .95029 L
.3316 .94988 L
.32816 .94652 L
.3243 .94656 L
.32375 .94601 L
.32044 .94279 L
Mistroke
.31657 .94282 L
.31271 .94286 L
.312 .94215 L
.30885 .93907 L
.30499 .9391 L
.30417 .93829 L
.30113 .93531 L
.29727 .93534 L
.29635 .93443 L
.2934 .93155 L
.28954 .93157 L
.28853 .93057 L
.28568 .92777 L
.28182 .9278 L
.28072 .92671 L
.27796 .92399 L
.2741 .92401 L
.27292 .92285 L
.27023 .9202 L
.26637 .92023 L
.26513 .91898 L
.26251 .91641 L
.25865 .91643 L
.25734 .91512 L
.25479 .91261 L
.25343 .91126 L
.25093 .90879 L
.24707 .90881 L
.24565 .9074 L
.2432 .90498 L
.23934 .905 L
.23787 .90354 L
.23548 .90117 L
.23398 .89968 L
.23162 .89735 L
.22776 .89736 L
.22621 .89581 L
.2239 .89353 L
.22232 .89195 L
.22003 .8897 L
.21843 .88809 L
.21617 .88586 L
.21231 .88587 L
.21066 .88423 L
.20845 .88204 L
.20678 .88037 L
.20459 .8782 L
.20289 .87651 L
.20073 .87436 L
.19686 .87437 L
Mistroke
.19514 .87264 L
.193 .87053 L
.19126 .86878 L
.18914 .86668 L
.18738 .86492 L
.18528 .86284 L
.1835 .86106 L
.18142 .85899 L
.17962 .8572 L
.17756 .85515 L
.17574 .85334 L
.17369 .8513 L
.17187 .84947 L
.16983 .84745 L
.16597 .84746 L
.16413 .84561 L
.16211 .84361 L
.16025 .84175 L
.15825 .83976 L
.15638 .83789 L
.15439 .8359 L
.15251 .83403 L
.15251 .83017 L
.15053 .82819 L
.14864 .82631 L
.14666 .82434 L
.14477 .82244 L
.1428 .82048 L
.1409 .81858 L
.13894 .81662 L
.13704 .81472 L
.13508 .81277 L
.13317 .81086 L
.13122 .80891 L
.12931 .807 L
.12736 .80505 L
.12544 .80314 L
.12544 .79927 L
.12349 .79732 L
.12158 .79541 L
.11963 .79346 L
.11772 .79155 L
.11577 .7896 L
.11386 .78769 L
.11386 .78383 L
.11191 .78187 L
.11001 .77997 L
.10805 .778 L
.10615 .7761 L
.10419 .77414 L
Mistroke
.10229 .77224 L
.10229 .76838 L
.10032 .7664 L
.09844 .76452 L
.09646 .76253 L
.09459 .76066 L
.09459 .7568 L
.0926 .7548 L
.09074 .75293 L
.09074 .74907 L
.08874 .74706 L
.08689 .74521 L
.08488 .74318 L
.08305 .74135 L
.08305 .73749 L
.08102 .73544 L
.07921 .73363 L
.07921 .72977 L
.07715 .72769 L
.07537 .7259 L
.07538 .72204 L
.07329 .71994 L
.07154 .71818 L
.07154 .71432 L
.06943 .71218 L
.06771 .71046 L
.06772 .7066 L
.06557 .70443 L
.06388 .70273 L
.06389 .69887 L
.06171 .69666 L
.06006 .69501 L
.06007 .69115 L
.05785 .68889 L
.05624 .68729 L
.05626 .68343 L
.05627 .67956 L
.05399 .67724 L
.05245 .6757 L
.05246 .67184 L
.05012 .66946 L
.04865 .66798 L
.04866 .66412 L
.04868 .66026 L
.04626 .65779 L
.04487 .65639 L
.04489 .65253 L
.04491 .64867 L
.0424 .64611 L
.04111 .64481 L
Mistroke
.04113 .64095 L
.04115 .63709 L
.03854 .6344 L
.03737 .63323 L
.03739 .62936 L
.03742 .6255 L
.03745 .62164 L
.03468 .61879 L
.03368 .61778 L
.03371 .61392 L
.03374 .61006 L
.03378 .60619 L
.03082 .60312 L
.03003 .60233 L
.03007 .59847 L
.03012 .59461 L
.03016 .59075 L
.03021 .58689 L
.02695 .58348 L
.02651 .58302 L
.02657 .57916 L
.02663 .5753 L
.02669 .57144 L
.02676 .56758 L
.02683 .56372 L
.02344 .55985 L
.02695 .55791 L
.02792 .55599 L
.02986 .55213 L
.03082 .55025 L
.03182 .54827 L
.03378 .54441 L
.03468 .54265 L
.03575 .54055 L
.03773 .53669 L
.03854 .53512 L
.03972 .53282 L
.04172 .52896 L
.0424 .52765 L
.04372 .5251 L
.04574 .52124 L
.04626 .52024 L
.04776 .51738 L
.0498 .51352 L
.05012 .51289 L
.05184 .50965 L
.05389 .50579 L
.05399 .50561 L
.05595 .50193 L
.05785 .49839 L
Mistroke
.05802 .49807 L
.0601 .49421 L
.06171 .49123 L
.06219 .49035 L
.06429 .48648 L
.06557 .48413 L
.0664 .48262 L
.06852 .47876 L
.06943 .4771 L
.07065 .4749 L
.07279 .47104 L
.07329 .47013 L
.07494 .46718 L
.0771 .46331 L
.07715 .46322 L
.07927 .45945 L
.08102 .45637 L
.08146 .45559 L
.08365 .45173 L
.08488 .44959 L
.08586 .44787 L
.08808 .44401 L
.08874 .44286 L
.09031 .44015 L
.09256 .43628 L
.0926 .43621 L
.09481 .43242 L
.09646 .42961 L
.09708 .42856 L
.09936 .4247 L
.10032 .42307 L
.10165 .42084 L
.10396 .41698 L
.10419 .4166 L
.10628 .41311 L
.10805 .41019 L
.10862 .40925 L
.11096 .40539 L
.11191 .40384 L
.11333 .40153 L
.1157 .39767 L
.11577 .39756 L
.11809 .39381 L
.11963 .39134 L
.1205 .38994 L
.12292 .38608 L
.12349 .38518 L
.12536 .38222 L
.12736 .37908 L
.12781 .37836 L
Mistroke
.13028 .3745 L
.13122 .37304 L
.13277 .37064 L
.13508 .36707 L
.13527 .36677 L
.13779 .36291 L
.13894 .36116 L
.14033 .35905 L
.1428 .35531 L
.14288 .35519 L
.14545 .35133 L
.14666 .34952 L
.14805 .34747 L
.15053 .3438 L
.15066 .34361 L
.15329 .33974 L
.15439 .33814 L
.15594 .33588 L
.15825 .33254 L
.15861 .33202 L
.1613 .32816 L
.16211 .327 L
.16401 .3243 L
.16597 .32153 L
.16675 .32044 L
.16951 .31657 L
.16983 .31612 L
.17229 .31271 L
.17369 .31077 L
.17509 .30885 L
.17756 .30548 L
.17792 .30499 L
.18077 .30113 L
.18142 .30026 L
.18365 .29727 L
.18528 .2951 L
.18656 .2934 L
.18914 .29 L
.18949 .28954 L
.19245 .28568 L
.193 .28496 L
.19544 .28182 L
.19686 .27999 L
.19845 .27796 L
.20073 .27508 L
.2015 .2741 L
.20458 .27023 L
.20459 .27023 L
.20769 .26637 L
.20845 .26544 L
Mistroke
.21084 .26251 L
.21231 .26071 L
.21401 .25865 L
.21617 .25605 L
.21723 .25479 L
.22003 .25145 L
.22048 .25093 L
.22377 .24707 L
.2239 .24691 L
.22709 .2432 L
.22776 .24244 L
.23046 .23934 L
.23162 .23803 L
.23387 .23548 L
.23548 .23368 L
.23733 .23162 L
.23934 .22939 L
.24082 .22776 L
.2432 .22516 L
.24437 .2239 L
.24707 .221 L
.24797 .22003 L
.25093 .2169 L
.25162 .21617 L
.25479 .21286 L
.25532 .21231 L
.25865 .20888 L
.25908 .20845 L
.26251 .20497 L
.26289 .20459 L
.26637 .20112 L
.26677 .20073 L
.27023 .19733 L
.27071 .19686 L
.2741 .1936 L
.27473 .193 L
.27796 .18994 L
.27881 .18914 L
.28182 .18634 L
.28297 .18528 L
.28568 .1828 L
.28721 .18142 L
.28954 .17932 L
.29153 .17756 L
.2934 .17591 L
.29595 .17369 L
.29727 .17256 L
.30046 .16983 L
.30113 .16927 L
.30499 .16604 L
Mistroke
.30507 .16597 L
.30885 .16288 L
.3098 .16211 L
.31271 .15977 L
.31464 .15825 L
.31657 .15673 L
.31961 .15439 L
.32044 .15376 L
.3243 .15084 L
.32472 .15053 L
.32816 .14799 L
.32998 .14666 L
.33202 .1452 L
.33541 .1428 L
.33588 .14247 L
.33974 .1398 L
.34101 .13894 L
.34361 .1372 L
.34682 .13508 L
.34747 .13466 L
.35133 .13218 L
.35286 .13122 L
.35519 .12977 L
.35905 .12741 L
.35915 .12736 L
.36291 .12512 L
.36572 .12349 L
.36677 .12289 L
.37064 .12073 L
.37263 .11963 L
.3745 .11862 L
.37836 .11658 L
.37993 .11577 L
.38222 .1146 L
.38608 .11269 L
.38769 .11191 L
.38994 .11083 L
.39381 .10904 L
.39601 .10805 L
.39767 .10731 L
.40153 .10564 L
.40503 .10419 L
.40539 .10404 L
.40925 .1025 L
.41311 .10102 L
.41498 .10032 L
.41698 .0996 L
.42084 .09824 L
.4247 .09695 L
.42621 .09646 L
Mistroke
.42856 .09572 L
.43242 .09455 L
.43628 .09345 L
.4394 .0926 L
.44015 .09241 L
.44401 .09142 L
.44787 .09051 L
.45173 .08965 L
.45559 .08886 L
.45619 .08874 L
.45945 .08813 L
.46331 .08746 L
.46718 .08685 L
.47104 .08631 L
.4749 .08583 L
.47876 .08541 L
.48262 .08505 L
.48477 .08488 L
.48648 .08476 L
Mfstroke
.806 1 .5 r
.47876 .15016 m
.48262 .14979 L
.48648 .14949 L
.49035 .14925 L
.49421 .14907 L
.49807 .14895 L
.50193 .1489 L
.50579 .14891 L
.50965 .14898 L
.51352 .14912 L
.51738 .14931 L
.52124 .14957 L
.5251 .1499 L
.52896 .15028 L
.53114 .15053 L
.53282 .15073 L
.53669 .15124 L
.54055 .15181 L
.54441 .15244 L
.54827 .15314 L
.55213 .1539 L
.55446 .15439 L
.55599 .15472 L
.55985 .1556 L
.56372 .15655 L
.56758 .15756 L
.57008 .15825 L
.57144 .15863 L
.5753 .15977 L
.57916 .16096 L
.58269 .16211 L
.58302 .16222 L
.58689 .16354 L
.59075 .16493 L
.59356 .16597 L
.59461 .16637 L
.59847 .16788 L
.60233 .16945 L
.60325 .16983 L
.60619 .17109 L
.61006 .17278 L
.61208 .17369 L
.61392 .17454 L
.61778 .17636 L
.62024 .17756 L
.62164 .17824 L
.6255 .18019 L
.62788 .18142 L
.62936 .1822 L
.63323 .18427 L
.63507 .18528 L
.63709 .1864 L
.64095 .1886 L
.64188 .18914 L
.64481 .19086 L
.64838 .193 L
.64867 .19318 L
.65253 .19556 L
.6546 .19686 L
.65639 .19801 L
.66026 .20052 L
.66058 .20073 L
.66412 .20309 L
.66633 .20459 L
.66798 .20572 L
.67184 .20841 L
.67189 .20845 L
.6757 .21117 L
.67727 .21231 L
.67956 .21399 L
.68249 .21617 L
.68343 .21688 L
.68729 .21982 L
.68756 .22003 L
.69115 .22283 L
.6925 .2239 L
.69501 .2259 L
.69731 .22776 L
.69887 .22903 L
.70201 .23162 L
.70273 .23223 L
.70659 .23548 L
.7066 .23548 L
.71046 .2388 L
.71108 .23934 L
.71432 .24219 L
.71547 .2432 L
.71818 .24563 L
.71977 .24707 L
.72204 .24914 L
.72398 .25093 L
.7259 .25271 L
.72812 .25479 L
.72977 .25634 L
.73219 .25865 L
.73363 .26004 L
.73618 .26251 L
.73749 .26379 L
.7401 .26637 L
.74135 .26761 L
.74396 .27023 L
.74521 .2715 L
.74776 .2741 L
.74907 .27544 L
.75151 .27796 L
.75293 .27945 L
.75519 .28182 L
.7568 .28352 L
.75883 .28568 L
.76066 .28765 L
.76241 .28954 L
.76452 .29184 L
.76594 .2934 L
.76838 .2961 L
.76943 .29727 L
.77224 .30042 L
.77287 .30113 L
.7761 .3048 L
.77627 .30499 L
.77963 .30885 L
.77997 .30925 L
.78294 .31271 L
.78383 .31375 L
.78622 .31657 L
.78769 .31832 L
.78946 .32044 L
.79155 .32295 L
.79266 .3243 L
.79541 .32765 L
.79583 .32816 L
.79896 .33202 L
.79927 .3324 L
.80207 .33588 L
.80314 .33722 L
.80514 .33974 L
.807 .3421 L
.80817 .34361 L
.81086 .34705 L
.81118 .34747 L
.81416 .35133 L
.81472 .35205 L
.81711 .35519 L
.81858 .35712 L
.82004 .35905 L
.82244 .36226 L
.82294 .36291 L
.82581 .36677 L
.82631 .36745 L
.82865 .37064 L
.83017 .37271 L
.83147 .3745 L
.83403 .37802 L
.83427 .37836 L
.83704 .38222 L
.83789 .3834 L
.8398 .38608 L
.84175 .38885 L
.84252 .38994 L
.84523 .39381 L
.84561 .39435 L
.84792 .39767 L
.84947 .39992 L
.85058 .40153 L
.85323 .40539 L
.85334 .40555 L
.85585 .40925 L
.8572 .41125 L
.85845 .41311 L
.86104 .41698 L
.86106 .417 L
.86361 .42084 L
.86492 .42282 L
.86616 .4247 L
.86869 .42856 L
.86878 .4287 L
.8712 .43242 L
.87264 .43465 L
.8737 .43628 L
.87618 .44015 L
.87651 .44065 L
.87865 .44401 L
.88037 .44672 L
.88109 .44787 L
.88353 .45173 L
.88423 .45285 L
.88594 .45559 L
.88809 .45904 L
.88835 .45945 L
.89073 .46331 L
.89195 .4653 L
.8931 .46718 L
.89546 .47104 L
.89581 .47162 L
.89781 .4749 L
.89968 .478 L
.90014 .47876 L
.90245 .48262 L
.90354 .48444 L
.90475 .48648 L
.90704 .49035 L
.9074 .49095 L
.90932 .49421 L
.91126 .49751 L
.91159 .49807 L
.91384 .50193 L
.91512 .50414 L
.91608 .50579 L
.9183 .50965 L
.91898 .51084 L
.92052 .51352 L
.92272 .51738 L
.92285 .51759 L
.92492 .52124 L
.92671 .52441 L
.9271 .5251 L
.92927 .52896 L
.93057 .53129 L
.93143 .53282 L
.93357 .53669 L
.93443 .53823 L
.93571 .54055 L
.93784 .54441 L
.93829 .54524 L
.93995 .54827 L
.94206 .55213 L
.94215 .5523 L
.94416 .55599 L
.94601 .55943 L
.94624 .55985 L
.94832 .56372 L
.94988 .56663 L
.95039 .56758 L
.95244 .57144 L
.95374 .57388 L
.95449 .5753 L
.95653 .57916 L
.9576 .5812 L
.95856 .58302 L
.96058 .58689 L
.96146 .58858 L
.96259 .59075 L
.96459 .59461 L
.96532 .59602 L
.96899 .59847 L
.96914 .60233 L
.96546 .60619 L
.96551 .61006 L
.96556 .61392 L
.9656 .61778 L
.96532 .61806 L
.96186 .62164 L
.9619 .6255 L
.96193 .62936 L
.96197 .63323 L
.96146 .63374 L
.9582 .63709 L
.95823 .64095 L
.95826 .64481 L
.9576 .64548 L
.95448 .64867 L
.9545 .65253 L
.95453 .65639 L
.95374 .65719 L
.95073 .66026 L
.95076 .66412 L
.95078 .66798 L
.94988 .66888 L
.94697 .67184 L
.94699 .6757 L
.94601 .67668 L
.94318 .67956 L
.94319 .68343 L
.94321 .68729 L
.94215 .68835 L
.93939 .69115 L
.93941 .69501 L
.93829 .69613 L
.93558 .69887 L
.93559 .70273 L
.93443 .7039 L
.93177 .7066 L
.93178 .71046 L
.93057 .71167 L
.92795 .71432 L
.92796 .71818 L
.92671 .71943 L
.92412 .72204 L
.92413 .7259 L
.92285 .72719 L
.92029 .72977 L
.9203 .73363 L
.91898 .73494 L
.91646 .73749 L
.91646 .74135 L
.91512 .74269 L
.91262 .74521 L
.91126 .74657 L
.90877 .74907 L
.90878 .75293 L
.9074 .75431 L
.90493 .7568 L
.90493 .76066 L
.90354 .76205 L
.90108 .76452 L
.89968 .76593 L
.89723 .76838 L
.89723 .77224 L
.89581 .77366 L
.89338 .7761 L
.89195 .77753 L
.88952 .77997 L
.88809 .7814 L
.88566 .78383 L
.88566 .78769 L
.88423 .78912 L
.8818 .79155 L
.88037 .79299 L
.87794 .79541 L
.87651 .79685 L
.87408 .79927 L
.87408 .80314 L
.87264 .80457 L
.87022 .807 L
.86878 .80843 L
.86635 .81086 L
.86492 .81229 L
.86248 .81472 L
.86106 .81614 L
.85862 .81858 L
.8572 .82 L
.85475 .82244 L
.85334 .82385 L
.85088 .82631 L
.84947 .82771 L
.847 .83017 L
.847 .83403 L
.84561 .83541 L
.84313 .83789 L
.84175 .83926 L
.83925 .84175 L
.83789 .84311 L
.83538 .84561 L
.83403 .84696 L
.83017 .84695 L
.82763 .84947 L
.82631 .85079 L
.82375 .85334 L
.82244 .85464 L
.81987 .8572 L
.81858 .85848 L
.81598 .86106 L
.81472 .86232 L
.8121 .86492 L
.81086 .86616 L
.80821 .86878 L
.807 .87 L
.80433 .87264 L
.80314 .87383 L
.79927 .87382 L
.79656 .87651 L
.79541 .87765 L
.79267 .88037 L
.79155 .88148 L
.78878 .88423 L
.78769 .88531 L
.78383 .88529 L
.781 .88809 L
.77997 .88912 L
.7771 .89195 L
.7761 .89295 L
.7732 .89581 L
.77224 .89677 L
.76838 .89675 L
.76541 .89968 L
.76452 .90057 L
.76151 .90354 L
.76066 .90438 L
.7568 .90436 L
.75371 .9074 L
.75293 .90817 L
.74907 .90814 L
.7459 .91126 L
.74521 .91195 L
.74198 .91512 L
.74135 .91575 L
.73749 .91572 L
.73417 .91898 L
.73363 .91952 L
.72977 .91949 L
.72634 .92285 L
.7259 .92328 L
.72204 .92325 L
.71851 .92671 L
.71818 .92703 L
.71432 .92699 L
.71066 .93057 L
.71046 .93077 L
.7066 .93073 L
.7028 .93443 L
.70273 .93449 L
.69887 .93445 L
.69759 .93443 L
.69501 .9323 L
.69288 .93057 L
.69115 .92917 L
.68806 .92671 L
.68729 .9261 L
.68343 .92309 L
.68311 .92285 L
.67956 .92014 L
.67803 .91898 L
.6757 .91725 L
.6728 .91512 L
.67184 .91443 L
.66798 .91166 L
.66741 .91126 L
.66412 .90896 L
.66184 .9074 L
.66026 .90632 L
.65639 .90374 L
.65608 .90354 L
.65253 .90123 L
.65011 .89968 L
.64867 .89877 L
.64481 .89638 L
.64389 .89581 L
.64095 .89405 L
.63739 .89195 L
.63709 .89177 L
.63323 .88957 L
.63059 .88809 L
.62936 .88742 L
.6255 .88533 L
.62341 .88423 L
.62164 .88331 L
.61778 .88135 L
.61581 .88037 L
.61392 .87944 L
.61006 .87761 L
.60768 .87651 L
.60619 .87583 L
.60233 .87411 L
.59892 .87264 L
.59847 .87246 L
.59461 .87086 L
.59075 .86933 L
.58932 .86878 L
.58689 .86786 L
.58302 .86645 L
.57916 .86511 L
.57861 .86492 L
.5753 .86382 L
.57144 .8626 L
.56758 .86144 L
.56627 .86106 L
.56372 .86034 L
.55985 .8593 L
.55599 .85832 L
.55213 .85741 L
.55121 .8572 L
.54827 .85655 L
.54441 .85576 L
.54055 .85503 L
.53669 .85436 L
.53282 .85375 L
.52991 .85334 L
.52896 .85321 L
.5251 .85272 L
.52124 .8523 L
.51738 .85194 L
.51352 .85164 L
.50965 .8514 L
.50579 .85123 L
.50193 .85111 L
.49807 .85106 L
.49421 .85107 L
.49035 .85114 L
.48648 .85127 L
.48262 .85147 L
.47876 .85172 L
.4749 .85204 L
.47104 .85242 L
.46718 .85286 L
.46346 .85334 L
.46331 .85336 L
.45945 .85392 L
.45559 .85454 L
.45173 .85523 L
.44787 .85598 L
.44401 .85679 L
.44216 .8572 L
.44015 .85766 L
.43628 .85859 L
.43242 .85959 L
.42856 .86064 L
.42709 .86106 L
.4247 .86176 L
.42084 .86294 L
.41698 .86418 L
.41475 .86492 L
.41311 .86548 L
.40925 .86685 L
.40539 .86827 L
.40404 .86878 L
.40153 .86976 L
.39767 .87131 L
.39445 .87264 L
.39381 .87292 L
.38994 .87459 L
.38608 .87632 L
.38568 .87651 L
.38222 .87812 L
.37836 .87997 L
.37756 .88037 L
.3745 .88189 L
.37064 .88387 L
.36995 .88423 L
.36677 .88591 L
.36291 .88802 L
.36278 .88809 L
.35905 .89018 L
.35597 .89195 L
.35519 .89241 L
.35133 .8947 L
.34948 .89581 L
.34747 .89705 L
.34361 .89946 L
.34326 .89968 L
.33974 .90193 L
.33728 .90354 L
.33588 .90446 L
.33202 .90706 L
.33152 .9074 L
.32816 .90972 L
.32595 .91126 L
.3243 .91243 L
.32056 .91512 L
.32044 .91522 L
.31657 .91806 L
.31533 .91898 L
.31271 .92096 L
.31025 .92285 L
.30885 .92393 L
.3053 .92671 L
.30499 .92695 L
.30113 .93004 L
.30048 .93057 L
.29727 .93438 L
.2934 .93065 L
.28954 .93069 L
.28942 .93057 L
.28568 .92692 L
.28182 .92696 L
.28157 .92671 L
.27796 .92318 L
.2741 .92321 L
.27373 .92285 L
.27023 .91942 L
.26637 .91946 L
.2659 .91898 L
.26251 .91566 L
.25865 .91569 L
.25808 .91512 L
.25479 .91189 L
.25416 .91126 L
.25093 .90808 L
.24707 .90811 L
.24635 .9074 L
.2432 .9043 L
.23934 .90432 L
.23855 .90354 L
.23548 .90051 L
.23464 .89968 L
.23162 .89669 L
.22776 .89671 L
.22685 .89581 L
.2239 .89289 L
.22295 .89195 L
.22003 .88907 L
.21905 .88809 L
.21617 .88524 L
.21231 .88526 L
.21128 .88423 L
.20845 .88143 L
.20738 .88037 L
.20459 .8776 L
.20349 .87651 L
.20073 .87377 L
.19686 .87378 L
.19572 .87264 L
.193 .86995 L
.19184 .86878 L
.18914 .86611 L
.18795 .86492 L
.18528 .86227 L
.18406 .86106 L
.18142 .85843 L
.18018 .8572 L
.17756 .85459 L
.1763 .85334 L
.17369 .85075 L
.17242 .84947 L
.16983 .8469 L
.16597 .84691 L
.16467 .84561 L
.16211 .84306 L
.1608 .84175 L
.15825 .83922 L
.15692 .83789 L
.15439 .83537 L
.15305 .83403 L
.15304 .83017 L
.15053 .82766 L
.14917 .82631 L
.14666 .82381 L
.1453 .82244 L
.1428 .81995 L
.14143 .81858 L
.13894 .8161 L
.13756 .81472 L
.13508 .81224 L
.1337 .81086 L
.13122 .80838 L
.12983 .807 L
.12736 .80452 L
.12597 .80314 L
.12597 .79927 L
.12349 .7968 L
.12211 .79541 L
.11963 .79294 L
.11825 .79155 L
.11577 .78907 L
.11439 .78769 L
.11439 .78383 L
.11191 .78134 L
.11053 .77997 L
.10805 .77748 L
.10668 .7761 L
.10419 .77361 L
.10282 .77224 L
.10283 .76838 L
.10032 .76587 L
.09897 .76452 L
.09646 .762 L
.09512 .76066 L
.09513 .7568 L
.0926 .75426 L
.09128 .75293 L
.09129 .74907 L
.08874 .74651 L
.08744 .74521 L
.08488 .74263 L
.0836 .74135 L
.0836 .73749 L
.08102 .73488 L
.07976 .73363 L
.07977 .72977 L
.07715 .72713 L
.07594 .7259 L
.07594 .72204 L
.07329 .71936 L
.07211 .71818 L
.07212 .71432 L
.06943 .7116 L
.06829 .71046 L
.0683 .7066 L
.06557 .70383 L
.06448 .70273 L
.06449 .69887 L
.06171 .69605 L
.06067 .69501 L
.06069 .69115 L
.05785 .68827 L
.05687 .68729 L
.05689 .68343 L
.05691 .67956 L
.05399 .67659 L
.0531 .6757 L
.05312 .67184 L
.05012 .66879 L
.04932 .66798 L
.04934 .66412 L
.04936 .66026 L
.04626 .65708 L
.04558 .65639 L
.0456 .65253 L
.04563 .64867 L
.0424 .64536 L
.04186 .64481 L
.04189 .64095 L
.04192 .63709 L
.03854 .6336 L
.03816 .63323 L
.0382 .62936 L
.03824 .6255 L
.03828 .62164 L
.03468 .6179 L
.03456 .61778 L
.03461 .61392 L
.03466 .61006 L
.03468 .60888 L
.03477 .60619 L
.03802 .60233 L
.03854 .60133 L
.04001 .59847 L
.042 .59461 L
.0424 .59384 L
.044 .59075 L
.04602 .58689 L
.04626 .58642 L
.04804 .58302 L
.05007 .57916 L
.05012 .57905 L
.0521 .5753 L
.05399 .57175 L
.05415 .57144 L
.05621 .56758 L
.05785 .56451 L
.05827 .56372 L
.06035 .55985 L
.06171 .55734 L
.06244 .55599 L
.06453 .55213 L
.06557 .55022 L
.06664 .54827 L
.06875 .54441 L
.06943 .54317 L
.07088 .54055 L
.07302 .53669 L
.07329 .53618 L
.07516 .53282 L
.07715 .52926 L
.07732 .52896 L
.07949 .5251 L
.08102 .5224 L
.08167 .52124 L
.08386 .51738 L
.08488 .51559 L
.08607 .51352 L
.08828 .50965 L
.08874 .50886 L
.09051 .50579 L
.0926 .50218 L
.09275 .50193 L
.095 .49807 L
.09646 .49557 L
.09726 .49421 L
.09954 .49035 L
.10032 .48902 L
.10183 .48648 L
.10413 .48262 L
.10419 .48253 L
.10645 .47876 L
.10805 .4761 L
.10877 .4749 L
.11112 .47104 L
.11191 .46974 L
.11348 .46718 L
.11577 .46344 L
.11585 .46331 L
.11823 .45945 L
.11963 .4572 L
.12063 .45559 L
.12305 .45173 L
.12349 .45102 L
.12548 .44787 L
.12736 .44491 L
.12793 .44401 L
.13039 .44015 L
.13122 .43886 L
.13287 .43628 L
.13508 .43287 L
.13537 .43242 L
.13788 .42856 L
.13894 .42695 L
.14042 .4247 L
.1428 .42108 L
.14296 .42084 L
.14553 .41698 L
.14666 .41528 L
.14812 .41311 L
.15053 .40954 L
.15072 .40925 L
.15335 .40539 L
.15439 .40387 L
.15599 .40153 L
.15825 .39825 L
.15865 .39767 L
.16134 .39381 L
.16211 .3927 L
.16405 .38994 L
.16597 .38721 L
.16677 .38608 L
.16952 .38222 L
.16983 .38179 L
.1723 .37836 L
.17369 .37643 L
.17509 .3745 L
.17756 .37112 L
.17791 .37064 L
.18076 .36677 L
.18142 .36589 L
.18363 .36291 L
.18528 .36071 L
.18653 .35905 L
.18914 .3556 L
.18945 .35519 L
.1924 .35133 L
.193 .35055 L
.19538 .34747 L
.19686 .34556 L
.19839 .34361 L
.20073 .34063 L
.20143 .33974 L
.2045 .33588 L
.20459 .33577 L
.2076 .33202 L
.20845 .33097 L
.21073 .32816 L
.21231 .32623 L
.2139 .3243 L
.21617 .32155 L
.2171 .32044 L
.22003 .31694 L
.22034 .31657 L
.22362 .31271 L
.2239 .31239 L
.22693 .30885 L
.22776 .3079 L
.23029 .30499 L
.23162 .30347 L
.23369 .30113 L
.23548 .29911 L
.23713 .29727 L
.23934 .29481 L
.24061 .2934 L
.2432 .29057 L
.24415 .28954 L
.24707 .28639 L
.24773 .28568 L
.25093 .28228 L
.25136 .28182 L
.25479 .27823 L
.25505 .27796 L
.25865 .27424 L
.25879 .2741 L
.26251 .27031 L
.26259 .27023 L
.26637 .26645 L
.26645 .26637 L
.27023 .26265 L
.27037 .26251 L
.2741 .25891 L
.27437 .25865 L
.27796 .25523 L
.27843 .25479 L
.28182 .25162 L
.28257 .25093 L
.28568 .24807 L
.28678 .24707 L
.28954 .24458 L
.29108 .2432 L
.2934 .24115 L
.29547 .23934 L
.29727 .23779 L
.29996 .23548 L
.30113 .23449 L
.30454 .23162 L
.30499 .23125 L
.30885 .22807 L
.30924 .22776 L
.31271 .22496 L
.31405 .2239 L
.31657 .22191 L
.31898 .22003 L
.32044 .21892 L
.32405 .21617 L
.3243 .21599 L
.32816 .21313 L
.32927 .21231 L
.33202 .21032 L
.33466 .20845 L
.33588 .20759 L
.33974 .20491 L
.34021 .20459 L
.34361 .20229 L
.34597 .20073 L
.34747 .19974 L
.35133 .19725 L
.35194 .19686 L
.35519 .19483 L
.35816 .193 L
.35905 .19246 L
.36291 .19016 L
.36466 .18914 L
.36677 .18792 L
.37064 .18574 L
.37148 .18528 L
.3745 .18363 L
.37836 .18158 L
.37867 .18142 L
.38222 .17959 L
.38608 .17766 L
.3863 .17756 L
.38994 .1758 L
.39381 .174 L
.39446 .17369 L
.39767 .17226 L
.40153 .17058 L
.40329 .16983 L
.40539 .16896 L
.40925 .16741 L
.41298 .16597 L
.41311 .16592 L
.41698 .1645 L
.42084 .16313 L
.42385 .16211 L
.4247 .16183 L
.42856 .16059 L
.43242 .15941 L
.43628 .1583 L
.43645 .15825 L
.44015 .15724 L
.44401 .15625 L
.44787 .15533 L
.45173 .15446 L
.45208 .15439 L
.45559 .15366 L
.45945 .15292 L
.46331 .15224 L
.46718 .15163 L
.47104 .15107 L
.4749 .15058 L
.4754 .15053 L
F
0 g
.47876 .15016 m
.48262 .14979 L
.48648 .14949 L
.49035 .14925 L
.49421 .14907 L
.49807 .14895 L
.50193 .1489 L
.50579 .14891 L
.50965 .14898 L
.51352 .14912 L
.51738 .14931 L
.52124 .14957 L
.5251 .1499 L
.52896 .15028 L
.53114 .15053 L
.53282 .15073 L
.53669 .15124 L
.54055 .15181 L
.54441 .15244 L
.54827 .15314 L
.55213 .1539 L
.55446 .15439 L
.55599 .15472 L
.55985 .1556 L
.56372 .15655 L
.56758 .15756 L
.57008 .15825 L
.57144 .15863 L
.5753 .15977 L
.57916 .16096 L
.58269 .16211 L
.58302 .16222 L
.58689 .16354 L
.59075 .16493 L
.59356 .16597 L
.59461 .16637 L
.59847 .16788 L
.60233 .16945 L
.60325 .16983 L
.60619 .17109 L
.61006 .17278 L
.61208 .17369 L
.61392 .17454 L
.61778 .17636 L
.62024 .17756 L
.62164 .17824 L
.6255 .18019 L
.62788 .18142 L
.62936 .1822 L
.63323 .18427 L
Mistroke
.63507 .18528 L
.63709 .1864 L
.64095 .1886 L
.64188 .18914 L
.64481 .19086 L
.64838 .193 L
.64867 .19318 L
.65253 .19556 L
.6546 .19686 L
.65639 .19801 L
.66026 .20052 L
.66058 .20073 L
.66412 .20309 L
.66633 .20459 L
.66798 .20572 L
.67184 .20841 L
.67189 .20845 L
.6757 .21117 L
.67727 .21231 L
.67956 .21399 L
.68249 .21617 L
.68343 .21688 L
.68729 .21982 L
.68756 .22003 L
.69115 .22283 L
.6925 .2239 L
.69501 .2259 L
.69731 .22776 L
.69887 .22903 L
.70201 .23162 L
.70273 .23223 L
.70659 .23548 L
.7066 .23548 L
.71046 .2388 L
.71108 .23934 L
.71432 .24219 L
.71547 .2432 L
.71818 .24563 L
.71977 .24707 L
.72204 .24914 L
.72398 .25093 L
.7259 .25271 L
.72812 .25479 L
.72977 .25634 L
.73219 .25865 L
.73363 .26004 L
.73618 .26251 L
.73749 .26379 L
.7401 .26637 L
.74135 .26761 L
Mistroke
.74396 .27023 L
.74521 .2715 L
.74776 .2741 L
.74907 .27544 L
.75151 .27796 L
.75293 .27945 L
.75519 .28182 L
.7568 .28352 L
.75883 .28568 L
.76066 .28765 L
.76241 .28954 L
.76452 .29184 L
.76594 .2934 L
.76838 .2961 L
.76943 .29727 L
.77224 .30042 L
.77287 .30113 L
.7761 .3048 L
.77627 .30499 L
.77963 .30885 L
.77997 .30925 L
.78294 .31271 L
.78383 .31375 L
.78622 .31657 L
.78769 .31832 L
.78946 .32044 L
.79155 .32295 L
.79266 .3243 L
.79541 .32765 L
.79583 .32816 L
.79896 .33202 L
.79927 .3324 L
.80207 .33588 L
.80314 .33722 L
.80514 .33974 L
.807 .3421 L
.80817 .34361 L
.81086 .34705 L
.81118 .34747 L
.81416 .35133 L
.81472 .35205 L
.81711 .35519 L
.81858 .35712 L
.82004 .35905 L
.82244 .36226 L
.82294 .36291 L
.82581 .36677 L
.82631 .36745 L
.82865 .37064 L
.83017 .37271 L
Mistroke
.83147 .3745 L
.83403 .37802 L
.83427 .37836 L
.83704 .38222 L
.83789 .3834 L
.8398 .38608 L
.84175 .38885 L
.84252 .38994 L
.84523 .39381 L
.84561 .39435 L
.84792 .39767 L
.84947 .39992 L
.85058 .40153 L
.85323 .40539 L
.85334 .40555 L
.85585 .40925 L
.8572 .41125 L
.85845 .41311 L
.86104 .41698 L
.86106 .417 L
.86361 .42084 L
.86492 .42282 L
.86616 .4247 L
.86869 .42856 L
.86878 .4287 L
.8712 .43242 L
.87264 .43465 L
.8737 .43628 L
.87618 .44015 L
.87651 .44065 L
.87865 .44401 L
.88037 .44672 L
.88109 .44787 L
.88353 .45173 L
.88423 .45285 L
.88594 .45559 L
.88809 .45904 L
.88835 .45945 L
.89073 .46331 L
.89195 .4653 L
.8931 .46718 L
.89546 .47104 L
.89581 .47162 L
.89781 .4749 L
.89968 .478 L
.90014 .47876 L
.90245 .48262 L
.90354 .48444 L
.90475 .48648 L
.90704 .49035 L
Mistroke
.9074 .49095 L
.90932 .49421 L
.91126 .49751 L
.91159 .49807 L
.91384 .50193 L
.91512 .50414 L
.91608 .50579 L
.9183 .50965 L
.91898 .51084 L
.92052 .51352 L
.92272 .51738 L
.92285 .51759 L
.92492 .52124 L
.92671 .52441 L
.9271 .5251 L
.92927 .52896 L
.93057 .53129 L
.93143 .53282 L
.93357 .53669 L
.93443 .53823 L
.93571 .54055 L
.93784 .54441 L
.93829 .54524 L
.93995 .54827 L
.94206 .55213 L
.94215 .5523 L
.94416 .55599 L
.94601 .55943 L
.94624 .55985 L
.94832 .56372 L
.94988 .56663 L
.95039 .56758 L
.95244 .57144 L
.95374 .57388 L
.95449 .5753 L
.95653 .57916 L
.9576 .5812 L
.95856 .58302 L
.96058 .58689 L
.96146 .58858 L
.96259 .59075 L
.96459 .59461 L
.96532 .59602 L
.96899 .59847 L
.96914 .60233 L
.96546 .60619 L
.96551 .61006 L
.96556 .61392 L
.9656 .61778 L
.96532 .61806 L
Mistroke
.96186 .62164 L
.9619 .6255 L
.96193 .62936 L
.96197 .63323 L
.96146 .63374 L
.9582 .63709 L
.95823 .64095 L
.95826 .64481 L
.9576 .64548 L
.95448 .64867 L
.9545 .65253 L
.95453 .65639 L
.95374 .65719 L
.95073 .66026 L
.95076 .66412 L
.95078 .66798 L
.94988 .66888 L
.94697 .67184 L
.94699 .6757 L
.94601 .67668 L
.94318 .67956 L
.94319 .68343 L
.94321 .68729 L
.94215 .68835 L
.93939 .69115 L
.93941 .69501 L
.93829 .69613 L
.93558 .69887 L
.93559 .70273 L
.93443 .7039 L
.93177 .7066 L
.93178 .71046 L
.93057 .71167 L
.92795 .71432 L
.92796 .71818 L
.92671 .71943 L
.92412 .72204 L
.92413 .7259 L
.92285 .72719 L
.92029 .72977 L
.9203 .73363 L
.91898 .73494 L
.91646 .73749 L
.91646 .74135 L
.91512 .74269 L
.91262 .74521 L
.91126 .74657 L
.90877 .74907 L
.90878 .75293 L
.9074 .75431 L
Mistroke
.90493 .7568 L
.90493 .76066 L
.90354 .76205 L
.90108 .76452 L
.89968 .76593 L
.89723 .76838 L
.89723 .77224 L
.89581 .77366 L
.89338 .7761 L
.89195 .77753 L
.88952 .77997 L
.88809 .7814 L
.88566 .78383 L
.88566 .78769 L
.88423 .78912 L
.8818 .79155 L
.88037 .79299 L
.87794 .79541 L
.87651 .79685 L
.87408 .79927 L
.87408 .80314 L
.87264 .80457 L
.87022 .807 L
.86878 .80843 L
.86635 .81086 L
.86492 .81229 L
.86248 .81472 L
.86106 .81614 L
.85862 .81858 L
.8572 .82 L
.85475 .82244 L
.85334 .82385 L
.85088 .82631 L
.84947 .82771 L
.847 .83017 L
.847 .83403 L
.84561 .83541 L
.84313 .83789 L
.84175 .83926 L
.83925 .84175 L
.83789 .84311 L
.83538 .84561 L
.83403 .84696 L
.83017 .84695 L
.82763 .84947 L
.82631 .85079 L
.82375 .85334 L
.82244 .85464 L
.81987 .8572 L
.81858 .85848 L
Mistroke
.81598 .86106 L
.81472 .86232 L
.8121 .86492 L
.81086 .86616 L
.80821 .86878 L
.807 .87 L
.80433 .87264 L
.80314 .87383 L
.79927 .87382 L
.79656 .87651 L
.79541 .87765 L
.79267 .88037 L
.79155 .88148 L
.78878 .88423 L
.78769 .88531 L
.78383 .88529 L
.781 .88809 L
.77997 .88912 L
.7771 .89195 L
.7761 .89295 L
.7732 .89581 L
.77224 .89677 L
.76838 .89675 L
.76541 .89968 L
.76452 .90057 L
.76151 .90354 L
.76066 .90438 L
.7568 .90436 L
.75371 .9074 L
.75293 .90817 L
.74907 .90814 L
.7459 .91126 L
.74521 .91195 L
.74198 .91512 L
.74135 .91575 L
.73749 .91572 L
.73417 .91898 L
.73363 .91952 L
.72977 .91949 L
.72634 .92285 L
.7259 .92328 L
.72204 .92325 L
.71851 .92671 L
.71818 .92703 L
.71432 .92699 L
.71066 .93057 L
.71046 .93077 L
.7066 .93073 L
.7028 .93443 L
.70273 .93449 L
Mistroke
.69887 .93445 L
.69759 .93443 L
.69501 .9323 L
.69288 .93057 L
.69115 .92917 L
.68806 .92671 L
.68729 .9261 L
.68343 .92309 L
.68311 .92285 L
.67956 .92014 L
.67803 .91898 L
.6757 .91725 L
.6728 .91512 L
.67184 .91443 L
.66798 .91166 L
.66741 .91126 L
.66412 .90896 L
.66184 .9074 L
.66026 .90632 L
.65639 .90374 L
.65608 .90354 L
.65253 .90123 L
.65011 .89968 L
.64867 .89877 L
.64481 .89638 L
.64389 .89581 L
.64095 .89405 L
.63739 .89195 L
.63709 .89177 L
.63323 .88957 L
.63059 .88809 L
.62936 .88742 L
.6255 .88533 L
.62341 .88423 L
.62164 .88331 L
.61778 .88135 L
.61581 .88037 L
.61392 .87944 L
.61006 .87761 L
.60768 .87651 L
.60619 .87583 L
.60233 .87411 L
.59892 .87264 L
.59847 .87246 L
.59461 .87086 L
.59075 .86933 L
.58932 .86878 L
.58689 .86786 L
.58302 .86645 L
.57916 .86511 L
Mistroke
.57861 .86492 L
.5753 .86382 L
.57144 .8626 L
.56758 .86144 L
.56627 .86106 L
.56372 .86034 L
.55985 .8593 L
.55599 .85832 L
.55213 .85741 L
.55121 .8572 L
.54827 .85655 L
.54441 .85576 L
.54055 .85503 L
.53669 .85436 L
.53282 .85375 L
.52991 .85334 L
.52896 .85321 L
.5251 .85272 L
.52124 .8523 L
.51738 .85194 L
.51352 .85164 L
.50965 .8514 L
.50579 .85123 L
.50193 .85111 L
.49807 .85106 L
.49421 .85107 L
.49035 .85114 L
.48648 .85127 L
.48262 .85147 L
.47876 .85172 L
.4749 .85204 L
.47104 .85242 L
.46718 .85286 L
.46346 .85334 L
.46331 .85336 L
.45945 .85392 L
.45559 .85454 L
.45173 .85523 L
.44787 .85598 L
.44401 .85679 L
.44216 .8572 L
.44015 .85766 L
.43628 .85859 L
.43242 .85959 L
.42856 .86064 L
.42709 .86106 L
.4247 .86176 L
.42084 .86294 L
.41698 .86418 L
.41475 .86492 L
Mistroke
.41311 .86548 L
.40925 .86685 L
.40539 .86827 L
.40404 .86878 L
.40153 .86976 L
.39767 .87131 L
.39445 .87264 L
.39381 .87292 L
.38994 .87459 L
.38608 .87632 L
.38568 .87651 L
.38222 .87812 L
.37836 .87997 L
.37756 .88037 L
.3745 .88189 L
.37064 .88387 L
.36995 .88423 L
.36677 .88591 L
.36291 .88802 L
.36278 .88809 L
.35905 .89018 L
.35597 .89195 L
.35519 .89241 L
.35133 .8947 L
.34948 .89581 L
.34747 .89705 L
.34361 .89946 L
.34326 .89968 L
.33974 .90193 L
.33728 .90354 L
.33588 .90446 L
.33202 .90706 L
.33152 .9074 L
.32816 .90972 L
.32595 .91126 L
.3243 .91243 L
.32056 .91512 L
.32044 .91522 L
.31657 .91806 L
.31533 .91898 L
.31271 .92096 L
.31025 .92285 L
.30885 .92393 L
.3053 .92671 L
.30499 .92695 L
.30113 .93004 L
.30048 .93057 L
.29727 .93438 L
.2934 .93065 L
.28954 .93069 L
Mistroke
.28942 .93057 L
.28568 .92692 L
.28182 .92696 L
.28157 .92671 L
.27796 .92318 L
.2741 .92321 L
.27373 .92285 L
.27023 .91942 L
.26637 .91946 L
.2659 .91898 L
.26251 .91566 L
.25865 .91569 L
.25808 .91512 L
.25479 .91189 L
.25416 .91126 L
.25093 .90808 L
.24707 .90811 L
.24635 .9074 L
.2432 .9043 L
.23934 .90432 L
.23855 .90354 L
.23548 .90051 L
.23464 .89968 L
.23162 .89669 L
.22776 .89671 L
.22685 .89581 L
.2239 .89289 L
.22295 .89195 L
.22003 .88907 L
.21905 .88809 L
.21617 .88524 L
.21231 .88526 L
.21128 .88423 L
.20845 .88143 L
.20738 .88037 L
.20459 .8776 L
.20349 .87651 L
.20073 .87377 L
.19686 .87378 L
.19572 .87264 L
.193 .86995 L
.19184 .86878 L
.18914 .86611 L
.18795 .86492 L
.18528 .86227 L
.18406 .86106 L
.18142 .85843 L
.18018 .8572 L
.17756 .85459 L
.1763 .85334 L
Mistroke
.17369 .85075 L
.17242 .84947 L
.16983 .8469 L
.16597 .84691 L
.16467 .84561 L
.16211 .84306 L
.1608 .84175 L
.15825 .83922 L
.15692 .83789 L
.15439 .83537 L
.15305 .83403 L
.15304 .83017 L
.15053 .82766 L
.14917 .82631 L
.14666 .82381 L
.1453 .82244 L
.1428 .81995 L
.14143 .81858 L
.13894 .8161 L
.13756 .81472 L
.13508 .81224 L
.1337 .81086 L
.13122 .80838 L
.12983 .807 L
.12736 .80452 L
.12597 .80314 L
.12597 .79927 L
.12349 .7968 L
.12211 .79541 L
.11963 .79294 L
.11825 .79155 L
.11577 .78907 L
.11439 .78769 L
.11439 .78383 L
.11191 .78134 L
.11053 .77997 L
.10805 .77748 L
.10668 .7761 L
.10419 .77361 L
.10282 .77224 L
.10283 .76838 L
.10032 .76587 L
.09897 .76452 L
.09646 .762 L
.09512 .76066 L
.09513 .7568 L
.0926 .75426 L
.09128 .75293 L
.09129 .74907 L
.08874 .74651 L
Mistroke
.08744 .74521 L
.08488 .74263 L
.0836 .74135 L
.0836 .73749 L
.08102 .73488 L
.07976 .73363 L
.07977 .72977 L
.07715 .72713 L
.07594 .7259 L
.07594 .72204 L
.07329 .71936 L
.07211 .71818 L
.07212 .71432 L
.06943 .7116 L
.06829 .71046 L
.0683 .7066 L
.06557 .70383 L
.06448 .70273 L
.06449 .69887 L
.06171 .69605 L
.06067 .69501 L
.06069 .69115 L
.05785 .68827 L
.05687 .68729 L
.05689 .68343 L
.05691 .67956 L
.05399 .67659 L
.0531 .6757 L
.05312 .67184 L
.05012 .66879 L
.04932 .66798 L
.04934 .66412 L
.04936 .66026 L
.04626 .65708 L
.04558 .65639 L
.0456 .65253 L
.04563 .64867 L
.0424 .64536 L
.04186 .64481 L
.04189 .64095 L
.04192 .63709 L
.03854 .6336 L
.03816 .63323 L
.0382 .62936 L
.03824 .6255 L
.03828 .62164 L
.03468 .6179 L
.03456 .61778 L
.03461 .61392 L
.03466 .61006 L
Mistroke
.03468 .60888 L
.03477 .60619 L
.03802 .60233 L
.03854 .60133 L
.04001 .59847 L
.042 .59461 L
.0424 .59384 L
.044 .59075 L
.04602 .58689 L
.04626 .58642 L
.04804 .58302 L
.05007 .57916 L
.05012 .57905 L
.0521 .5753 L
.05399 .57175 L
.05415 .57144 L
.05621 .56758 L
.05785 .56451 L
.05827 .56372 L
.06035 .55985 L
.06171 .55734 L
.06244 .55599 L
.06453 .55213 L
.06557 .55022 L
.06664 .54827 L
.06875 .54441 L
.06943 .54317 L
.07088 .54055 L
.07302 .53669 L
.07329 .53618 L
.07516 .53282 L
.07715 .52926 L
.07732 .52896 L
.07949 .5251 L
.08102 .5224 L
.08167 .52124 L
.08386 .51738 L
.08488 .51559 L
.08607 .51352 L
.08828 .50965 L
.08874 .50886 L
.09051 .50579 L
.0926 .50218 L
.09275 .50193 L
.095 .49807 L
.09646 .49557 L
.09726 .49421 L
.09954 .49035 L
.10032 .48902 L
.10183 .48648 L
Mistroke
.10413 .48262 L
.10419 .48253 L
.10645 .47876 L
.10805 .4761 L
.10877 .4749 L
.11112 .47104 L
.11191 .46974 L
.11348 .46718 L
.11577 .46344 L
.11585 .46331 L
.11823 .45945 L
.11963 .4572 L
.12063 .45559 L
.12305 .45173 L
.12349 .45102 L
.12548 .44787 L
.12736 .44491 L
.12793 .44401 L
.13039 .44015 L
.13122 .43886 L
.13287 .43628 L
.13508 .43287 L
.13537 .43242 L
.13788 .42856 L
.13894 .42695 L
.14042 .4247 L
.1428 .42108 L
.14296 .42084 L
.14553 .41698 L
.14666 .41528 L
.14812 .41311 L
.15053 .40954 L
.15072 .40925 L
.15335 .40539 L
.15439 .40387 L
.15599 .40153 L
.15825 .39825 L
.15865 .39767 L
.16134 .39381 L
.16211 .3927 L
.16405 .38994 L
.16597 .38721 L
.16677 .38608 L
.16952 .38222 L
.16983 .38179 L
.1723 .37836 L
.17369 .37643 L
.17509 .3745 L
.17756 .37112 L
.17791 .37064 L
Mistroke
.18076 .36677 L
.18142 .36589 L
.18363 .36291 L
.18528 .36071 L
.18653 .35905 L
.18914 .3556 L
.18945 .35519 L
.1924 .35133 L
.193 .35055 L
.19538 .34747 L
.19686 .34556 L
.19839 .34361 L
.20073 .34063 L
.20143 .33974 L
.2045 .33588 L
.20459 .33577 L
.2076 .33202 L
.20845 .33097 L
.21073 .32816 L
.21231 .32623 L
.2139 .3243 L
.21617 .32155 L
.2171 .32044 L
.22003 .31694 L
.22034 .31657 L
.22362 .31271 L
.2239 .31239 L
.22693 .30885 L
.22776 .3079 L
.23029 .30499 L
.23162 .30347 L
.23369 .30113 L
.23548 .29911 L
.23713 .29727 L
.23934 .29481 L
.24061 .2934 L
.2432 .29057 L
.24415 .28954 L
.24707 .28639 L
.24773 .28568 L
.25093 .28228 L
.25136 .28182 L
.25479 .27823 L
.25505 .27796 L
.25865 .27424 L
.25879 .2741 L
.26251 .27031 L
.26259 .27023 L
.26637 .26645 L
.26645 .26637 L
Mistroke
.27023 .26265 L
.27037 .26251 L
.2741 .25891 L
.27437 .25865 L
.27796 .25523 L
.27843 .25479 L
.28182 .25162 L
.28257 .25093 L
.28568 .24807 L
.28678 .24707 L
.28954 .24458 L
.29108 .2432 L
.2934 .24115 L
.29547 .23934 L
.29727 .23779 L
.29996 .23548 L
.30113 .23449 L
.30454 .23162 L
.30499 .23125 L
.30885 .22807 L
.30924 .22776 L
.31271 .22496 L
.31405 .2239 L
.31657 .22191 L
.31898 .22003 L
.32044 .21892 L
.32405 .21617 L
.3243 .21599 L
.32816 .21313 L
.32927 .21231 L
.33202 .21032 L
.33466 .20845 L
.33588 .20759 L
.33974 .20491 L
.34021 .20459 L
.34361 .20229 L
.34597 .20073 L
.34747 .19974 L
.35133 .19725 L
.35194 .19686 L
.35519 .19483 L
.35816 .193 L
.35905 .19246 L
.36291 .19016 L
.36466 .18914 L
.36677 .18792 L
.37064 .18574 L
.37148 .18528 L
.3745 .18363 L
.37836 .18158 L
Mistroke
.37867 .18142 L
.38222 .17959 L
.38608 .17766 L
.3863 .17756 L
.38994 .1758 L
.39381 .174 L
.39446 .17369 L
.39767 .17226 L
.40153 .17058 L
.40329 .16983 L
.40539 .16896 L
.40925 .16741 L
.41298 .16597 L
.41311 .16592 L
.41698 .1645 L
.42084 .16313 L
.42385 .16211 L
.4247 .16183 L
.42856 .16059 L
.43242 .15941 L
.43628 .1583 L
.43645 .15825 L
.44015 .15724 L
.44401 .15625 L
.44787 .15533 L
.45173 .15446 L
.45208 .15439 L
.45559 .15366 L
.45945 .15292 L
.46331 .15224 L
.46718 .15163 L
.47104 .15107 L
.4749 .15058 L
.4754 .15053 L
.47876 .15016 L
Mfstroke
.995 1 .5 r
.48648 .20447 m
.49035 .20422 L
.49421 .20404 L
.49807 .20391 L
.50193 .20385 L
.50579 .20385 L
.50965 .20391 L
.51352 .20404 L
.51738 .20422 L
.52124 .20447 L
.52276 .20459 L
.5251 .20479 L
.52896 .20516 L
.53282 .2056 L
.53669 .2061 L
.54055 .20666 L
.54441 .20729 L
.54827 .20797 L
.55075 .20845 L
.55213 .20872 L
.55599 .20954 L
.55985 .21041 L
.56372 .21135 L
.56742 .21231 L
.56758 .21235 L
.57144 .21342 L
.5753 .21454 L
.57916 .21573 L
.58055 .21617 L
.58302 .21698 L
.58689 .21829 L
.59075 .21967 L
.59174 .22003 L
.59461 .22111 L
.59847 .22261 L
.60166 .2239 L
.60233 .22417 L
.60619 .2258 L
.61006 .22749 L
.61066 .22776 L
.61392 .22924 L
.61778 .23105 L
.61896 .23162 L
.62164 .23293 L
.6255 .23487 L
.6267 .23548 L
.62936 .23687 L
.63323 .23893 L
.63398 .23934 L
.63709 .24106 L
.64087 .2432 L
.64095 .24325 L
.64481 .2455 L
.64744 .24707 L
.64867 .24781 L
.65253 .25019 L
.65371 .25093 L
.65639 .25263 L
.65973 .25479 L
.66026 .25513 L
.66412 .25769 L
.66553 .25865 L
.66798 .26032 L
.67113 .26251 L
.67184 .26301 L
.6757 .26576 L
.67655 .26637 L
.67956 .26858 L
.6818 .27023 L
.68343 .27145 L
.6869 .2741 L
.68729 .27439 L
.69115 .27739 L
.69187 .27796 L
.69501 .28046 L
.6967 .28182 L
.69887 .28359 L
.70142 .28568 L
.70273 .28678 L
.70602 .28954 L
.7066 .29003 L
.71046 .29334 L
.71053 .2934 L
.71432 .29672 L
.71494 .29727 L
.71818 .30016 L
.71926 .30113 L
.72204 .30366 L
.72349 .30499 L
.7259 .30723 L
.72764 .30885 L
.72977 .31085 L
.73172 .31271 L
.73363 .31454 L
.73572 .31657 L
.73749 .3183 L
.73966 .32044 L
.74135 .32211 L
.74354 .3243 L
.74521 .32599 L
.74735 .32816 L
.74907 .32993 L
.7511 .33202 L
.75293 .33393 L
.7548 .33588 L
.7568 .338 L
.75844 .33974 L
.76066 .34212 L
.76203 .34361 L
.76452 .34631 L
.76557 .34747 L
.76838 .35057 L
.76907 .35133 L
.77224 .35488 L
.77252 .35519 L
.77592 .35905 L
.7761 .35926 L
.77929 .36291 L
.77997 .3637 L
.78261 .36677 L
.78383 .3682 L
.78589 .37064 L
.78769 .37277 L
.78914 .3745 L
.79155 .3774 L
.79235 .37836 L
.79541 .38209 L
.79552 .38222 L
.79866 .38608 L
.79927 .38684 L
.80177 .38994 L
.80314 .39165 L
.80485 .39381 L
.807 .39653 L
.80789 .39767 L
.81086 .40147 L
.8109 .40153 L
.81389 .40539 L
.81472 .40648 L
.81684 .40925 L
.81858 .41154 L
.81977 .41311 L
.82244 .41667 L
.82267 .41698 L
.82555 .42084 L
.82631 .42186 L
.8284 .4247 L
.83017 .42711 L
.83122 .42856 L
.83402 .43242 L
.83403 .43243 L
.8368 .43628 L
.83789 .43781 L
.83955 .44015 L
.84175 .44325 L
.84229 .44401 L
.845 .44787 L
.84561 .44875 L
.84769 .45173 L
.84947 .45432 L
.85035 .45559 L
.853 .45945 L
.85334 .45995 L
.85563 .46331 L
.8572 .46564 L
.85824 .46718 L
.86082 .47104 L
.86106 .47139 L
.86339 .4749 L
.86492 .47721 L
.86595 .47876 L
.86848 .48262 L
.86878 .48308 L
.871 .48648 L
.87264 .48903 L
.8735 .49035 L
.87598 .49421 L
.87651 .49503 L
.87845 .49807 L
.88037 .5011 L
.8809 .50193 L
.88333 .50579 L
.88423 .50722 L
.88575 .50965 L
.88809 .51342 L
.88815 .51352 L
.89054 .51738 L
.89195 .51967 L
.89292 .52124 L
.89528 .5251 L
.89581 .52599 L
.89762 .52896 L
.89968 .53236 L
.89995 .53282 L
.90227 .53669 L
.90354 .53881 L
.90457 .54055 L
.90687 .54441 L
.9074 .54531 L
.90914 .54827 L
.91126 .55188 L
.91141 .55213 L
.91366 .55599 L
.91512 .5585 L
.9159 .55985 L
.91813 .56372 L
.91898 .5652 L
.92035 .56758 L
.92255 .57144 L
.92285 .57195 L
.92475 .5753 L
.92671 .57877 L
.92693 .57916 L
.9291 .58302 L
.93057 .58565 L
.93126 .58689 L
.93341 .59075 L
.93443 .59259 L
.93555 .59461 L
.93768 .59847 L
.93829 .59959 L
.93979 .60233 L
.9419 .60619 L
.94215 .60666 L
.944 .61006 L
.94601 .61379 L
.94609 .61392 L
.94816 .61778 L
.94988 .62098 L
.95023 .62164 L
.95229 .6255 L
.95374 .62823 L
.95434 .62936 L
.95638 .63323 L
.9576 .63555 L
.95762 .63709 L
.95766 .64095 L
.95769 .64481 L
.9576 .64491 L
.95394 .64867 L
.95397 .65253 L
.954 .65639 L
.95374 .65666 L
.95022 .66026 L
.95025 .66412 L
.95028 .66798 L
.94988 .66838 L
.94649 .67184 L
.94651 .6757 L
.94601 .6762 L
.94271 .67956 L
.94273 .68343 L
.94275 .68729 L
.94215 .68789 L
.93894 .69115 L
.93896 .69501 L
.93829 .69568 L
.93515 .69887 L
.93516 .70273 L
.93443 .70347 L
.93134 .7066 L
.93135 .71046 L
.93057 .71124 L
.92753 .71432 L
.92754 .71818 L
.92671 .71902 L
.92371 .72204 L
.92372 .7259 L
.92285 .72678 L
.91989 .72977 L
.9199 .73363 L
.91898 .73454 L
.91606 .73749 L
.91607 .74135 L
.91512 .7423 L
.91223 .74521 L
.91126 .74618 L
.90838 .74907 L
.90839 .75293 L
.9074 .75393 L
.90454 .7568 L
.90455 .76066 L
.90354 .76167 L
.9007 .76452 L
.89968 .76554 L
.89685 .76838 L
.89685 .77224 L
.89581 .77328 L
.893 .7761 L
.89195 .77715 L
.88914 .77997 L
.88809 .78102 L
.88528 .78383 L
.88529 .78769 L
.88423 .78875 L
.88143 .79155 L
.88037 .79261 L
.87757 .79541 L
.87651 .79647 L
.8737 .79927 L
.8737 .80314 L
.87264 .80419 L
.86984 .807 L
.86878 .80805 L
.86597 .81086 L
.86492 .81191 L
.8621 .81472 L
.86106 .81576 L
.85823 .81858 L
.8572 .81962 L
.85436 .82244 L
.85334 .82347 L
.85049 .82631 L
.84947 .82732 L
.84662 .83017 L
.84661 .83403 L
.84561 .83503 L
.84274 .83789 L
.84175 .83887 L
.83886 .84175 L
.83789 .84272 L
.83498 .84561 L
.83403 .84656 L
.83017 .84655 L
.82723 .84947 L
.82631 .85039 L
.82334 .85334 L
.82244 .85423 L
.81946 .8572 L
.81858 .85807 L
.81557 .86106 L
.81472 .86191 L
.81168 .86492 L
.81086 .86574 L
.80779 .86878 L
.807 .86957 L
.8039 .87264 L
.80314 .8734 L
.79927 .87339 L
.79612 .87651 L
.79541 .87721 L
.79222 .88037 L
.79155 .88104 L
.78832 .88423 L
.78769 .88486 L
.78383 .88484 L
.78053 .88809 L
.77997 .88866 L
.77662 .89195 L
.7761 .89247 L
.77271 .89581 L
.77224 .89628 L
.76838 .89626 L
.76491 .89968 L
.76452 .90006 L
.76099 .90354 L
.76066 .90387 L
.7568 .90384 L
.75317 .9074 L
.75293 .90763 L
.74907 .9076 L
.74534 .91126 L
.74521 .91139 L
.7414 .91512 L
.74135 .91518 L
.73749 .91513 L
.73627 .91512 L
.73363 .91252 L
.73234 .91126 L
.72977 .90876 L
.72835 .9074 L
.7259 .90507 L
.72428 .90354 L
.72204 .90144 L
.72014 .89968 L
.71818 .89787 L
.71593 .89581 L
.71432 .89436 L
.71163 .89195 L
.71046 .89091 L
.70724 .88809 L
.7066 .88753 L
.70276 .88423 L
.70273 .88421 L
.69887 .88094 L
.69818 .88037 L
.69501 .87774 L
.6935 .87651 L
.69115 .8746 L
.6887 .87264 L
.68729 .87153 L
.68378 .86878 L
.68343 .86851 L
.67956 .86556 L
.67872 .86492 L
.6757 .86266 L
.67353 .86106 L
.67184 .85983 L
.66817 .8572 L
.66798 .85706 L
.66412 .85435 L
.66264 .85334 L
.66026 .85171 L
.65693 .84947 L
.65639 .84912 L
.65253 .8466 L
.651 .84561 L
.64867 .84414 L
.64483 .84175 L
.64481 .84174 L
.64095 .8394 L
.6384 .83789 L
.63709 .83712 L
.63323 .8349 L
.63167 .83403 L
.62936 .83275 L
.6255 .83066 L
.62458 .83017 L
.62164 .82863 L
.61778 .82666 L
.61708 .82631 L
.61392 .82475 L
.61006 .8229 L
.60908 .82244 L
.60619 .82111 L
.60233 .81939 L
.60047 .81858 L
.59847 .81773 L
.59461 .81613 L
.59108 .81472 L
.59075 .81459 L
.58689 .81311 L
.58302 .8117 L
.58066 .81086 L
.57916 .81034 L
.5753 .80905 L
.57144 .80782 L
.56876 .807 L
.56758 .80665 L
.56372 .80554 L
.55985 .80449 L
.55599 .8035 L
.55448 .80314 L
.55213 .80258 L
.54827 .80172 L
.54441 .80092 L
.54055 .80018 L
.53669 .7995 L
.53531 .79927 L
.53282 .79888 L
.52896 .79833 L
.5251 .79784 L
.52124 .7974 L
.51738 .79703 L
.51352 .79672 L
.50965 .79648 L
.50579 .79629 L
.50193 .79617 L
.49807 .7961 L
.49421 .7961 L
.49035 .79616 L
.48648 .79629 L
.48262 .79647 L
.47876 .79671 L
.4749 .79702 L
.47104 .79739 L
.46718 .79782 L
.46331 .79831 L
.45945 .79886 L
.45682 .79927 L
.45559 .79948 L
.45173 .80015 L
.44787 .80089 L
.44401 .80169 L
.44015 .80255 L
.43765 .80314 L
.43628 .80347 L
.43242 .80445 L
.42856 .8055 L
.4247 .8066 L
.42337 .807 L
.42084 .80777 L
.41698 .809 L
.41311 .81029 L
.41146 .81086 L
.40925 .81164 L
.40539 .81305 L
.40153 .81453 L
.40104 .81472 L
.39767 .81607 L
.39381 .81766 L
.39165 .81858 L
.38994 .81932 L
.38608 .82105 L
.38304 .82244 L
.38222 .82283 L
.37836 .82467 L
.37504 .82631 L
.3745 .82658 L
.37064 .82854 L
.36754 .83017 L
.36677 .83057 L
.36291 .83266 L
.36045 .83403 L
.35905 .83482 L
.35519 .83703 L
.35372 .83789 L
.35133 .8393 L
.34747 .84164 L
.34728 .84175 L
.34361 .84404 L
.34112 .84561 L
.33974 .8465 L
.33588 .84902 L
.33519 .84947 L
.33202 .8516 L
.32947 .85334 L
.32816 .85424 L
.3243 .85695 L
.32394 .8572 L
.32044 .85971 L
.31859 .86106 L
.31657 .86254 L
.31339 .86492 L
.31271 .86543 L
.30885 .86838 L
.30833 .86878 L
.30499 .8714 L
.30341 .87264 L
.30113 .87447 L
.29861 .87651 L
.29727 .87761 L
.29393 .88037 L
.2934 .8808 L
.28954 .88406 L
.28935 .88423 L
.28568 .88738 L
.28487 .88809 L
.28182 .89076 L
.28048 .89195 L
.27796 .89421 L
.27618 .89581 L
.2741 .89771 L
.27196 .89968 L
.27023 .90128 L
.26782 .90354 L
.26637 .90491 L
.26376 .9074 L
.26251 .90859 L
.25976 .91126 L
.25865 .91505 L
.25479 .91131 L
.25474 .91126 L
.25093 .90752 L
.24707 .90756 L
.24691 .9074 L
.2432 .90376 L
.23934 .90379 L
.23908 .90354 L
.23548 .89999 L
.23516 .89968 L
.23162 .89619 L
.22776 .89622 L
.22735 .89581 L
.2239 .8924 L
.22344 .89195 L
.22003 .88859 L
.21953 .88809 L
.21617 .88477 L
.21231 .8848 L
.21174 .88423 L
.20845 .88097 L
.20784 .88037 L
.20459 .87715 L
.20394 .87651 L
.20073 .87333 L
.19686 .87334 L
.19616 .87264 L
.193 .86951 L
.19227 .86878 L
.18914 .86568 L
.18838 .86492 L
.18528 .86185 L
.18449 .86106 L
.18142 .85801 L
.1806 .8572 L
.17756 .85418 L
.17672 .85334 L
.17369 .85034 L
.17283 .84947 L
.16983 .8465 L
.16597 .84651 L
.16508 .84561 L
.16211 .84266 L
.1612 .84175 L
.15825 .83882 L
.15732 .83789 L
.15439 .83497 L
.15344 .83403 L
.15344 .83017 L
.15053 .82726 L
.14957 .82631 L
.14666 .82341 L
.14569 .82244 L
.1428 .81956 L
.14182 .81858 L
.13894 .81571 L
.13795 .81472 L
.13508 .81185 L
.13409 .81086 L
.13122 .80799 L
.13022 .807 L
.12736 .80413 L
.12636 .80314 L
.12636 .79927 L
.12349 .79641 L
.12249 .79541 L
.11963 .79255 L
.11863 .79155 L
.11577 .78869 L
.11478 .78769 L
.11478 .78383 L
.11191 .78096 L
.11092 .77997 L
.10805 .77709 L
.10707 .7761 L
.10419 .77322 L
.10321 .77224 L
.10322 .76838 L
.10032 .76548 L
.09937 .76452 L
.09646 .7616 L
.09552 .76066 L
.09553 .7568 L
.0926 .75386 L
.09168 .75293 L
.09169 .74907 L
.08874 .74611 L
.08785 .74521 L
.08488 .74222 L
.08401 .74135 L
.08401 .73749 L
.08102 .73447 L
.08018 .73363 L
.08019 .72977 L
.07715 .7267 L
.07636 .7259 L
.07637 .72204 L
.07329 .71893 L
.07254 .71818 L
.07255 .71432 L
.06943 .71116 L
.06873 .71046 L
.06875 .7066 L
.06557 .70338 L
.06493 .70273 L
.06495 .69887 L
.06171 .69559 L
.06114 .69501 L
.06115 .69115 L
.05785 .68779 L
.05735 .68729 L
.05737 .68343 L
.05739 .67956 L
.05399 .67609 L
.0536 .6757 L
.05363 .67184 L
.05012 .66826 L
.04984 .66798 L
.04987 .66412 L
.0499 .66026 L
.04626 .65652 L
.04614 .65639 L
.04617 .65253 L
.04621 .64867 L
.04256 .64481 L
.04626 .64315 L
.04741 .64095 L
.04943 .63709 L
.05012 .63576 L
.05146 .63323 L
.0535 .62936 L
.05399 .62844 L
.05554 .6255 L
.0576 .62164 L
.05785 .62118 L
.05967 .61778 L
.06171 .61399 L
.06175 .61392 L
.06383 .61006 L
.06557 .60685 L
.06593 .60619 L
.06803 .60233 L
.06943 .59978 L
.07015 .59847 L
.07228 .59461 L
.07329 .59277 L
.07441 .59075 L
.07656 .58689 L
.07715 .58583 L
.07872 .58302 L
.08089 .57916 L
.08102 .57894 L
.08307 .5753 L
.08488 .57212 L
.08527 .57144 L
.08747 .56758 L
.08874 .56536 L
.08969 .56372 L
.09191 .55985 L
.0926 .55867 L
.09415 .55599 L
.09641 .55213 L
.09646 .55204 L
.09867 .54827 L
.10032 .54546 L
.10095 .54441 L
.10324 .54055 L
.10419 .53896 L
.10554 .53669 L
.10786 .53282 L
.10805 .53251 L
.11019 .52896 L
.11191 .52613 L
.11254 .5251 L
.11489 .52124 L
.11577 .51981 L
.11727 .51738 L
.11963 .51355 L
.11966 .51352 L
.12206 .50965 L
.12349 .50736 L
.12448 .50579 L
.12691 .50193 L
.12736 .50123 L
.12936 .49807 L
.13122 .49516 L
.13182 .49421 L
.13431 .49035 L
.13508 .48915 L
.1368 .48648 L
.13894 .4832 L
.13932 .48262 L
.14185 .47876 L
.1428 .47732 L
.1444 .4749 L
.14666 .4715 L
.14697 .47104 L
.14956 .46718 L
.15053 .46575 L
.15217 .46331 L
.15439 .46005 L
.1548 .45945 L
.15744 .45559 L
.15825 .45442 L
.16011 .45173 L
.16211 .44885 L
.1628 .44787 L
.16551 .44401 L
.16597 .44335 L
.16824 .44015 L
.16983 .4379 L
.17099 .43628 L
.17369 .43252 L
.17377 .43242 L
.17657 .42856 L
.17756 .4272 L
.17939 .4247 L
.18142 .42195 L
.18224 .42084 L
.18511 .41698 L
.18528 .41675 L
.18801 .41311 L
.18914 .41162 L
.19094 .40925 L
.193 .40656 L
.1939 .40539 L
.19686 .40155 L
.19688 .40153 L
.19989 .39767 L
.20073 .39661 L
.20294 .39381 L
.20459 .39173 L
.20601 .38994 L
.20845 .38691 L
.20912 .38608 L
.21226 .38222 L
.21231 .38215 L
.21543 .37836 L
.21617 .37746 L
.21864 .3745 L
.22003 .37283 L
.22188 .37064 L
.2239 .36826 L
.22517 .36677 L
.22776 .36376 L
.22849 .36291 L
.23162 .35932 L
.23185 .35905 L
.23526 .35519 L
.23548 .35494 L
.23871 .35133 L
.23934 .35062 L
.2422 .34747 L
.2432 .34637 L
.24574 .34361 L
.24707 .34217 L
.24933 .33974 L
.25093 .33805 L
.25297 .33588 L
.25479 .33398 L
.25667 .33202 L
.25865 .32997 L
.26042 .32816 L
.26251 .32603 L
.26423 .3243 L
.26637 .32215 L
.2681 .32044 L
.27023 .31834 L
.27204 .31657 L
.2741 .31458 L
.27605 .31271 L
.27796 .31089 L
.28012 .30885 L
.28182 .30726 L
.28427 .30499 L
.28568 .3037 L
.28851 .30113 L
.28954 .30019 L
.29282 .29727 L
.2934 .29675 L
.29723 .2934 L
.29727 .29337 L
.30113 .29006 L
.30173 .28954 L
.30499 .28681 L
.30634 .28568 L
.30885 .28361 L
.31106 .28182 L
.31271 .28049 L
.31589 .27796 L
.31657 .27742 L
.32044 .27442 L
.32085 .2741 L
.3243 .27148 L
.32595 .27023 L
.32816 .2686 L
.33121 .26637 L
.33202 .26578 L
.33588 .26303 L
.33662 .26251 L
.33974 .26034 L
.34222 .25865 L
.34361 .25771 L
.34747 .25515 L
.34802 .25479 L
.35133 .25265 L
.35404 .25093 L
.35519 .25021 L
.35905 .24783 L
.36031 .24707 L
.36291 .24551 L
.36677 .24326 L
.36688 .2432 L
.37064 .24107 L
.37377 .23934 L
.3745 .23895 L
.37836 .23688 L
.38105 .23548 L
.38222 .23488 L
.38608 .23294 L
.38879 .23162 L
.38994 .23106 L
.39381 .22925 L
.39708 .22776 L
.39767 .2275 L
.40153 .22581 L
.40539 .22418 L
.40608 .2239 L
.40925 .22262 L
.41311 .22112 L
.416 .22003 L
.41698 .21968 L
.42084 .2183 L
.4247 .21699 L
.42719 .21617 L
.42856 .21574 L
.43242 .21455 L
.43628 .21342 L
.44015 .21236 L
.44032 .21231 L
.44401 .21136 L
.44787 .21042 L
.45173 .20954 L
.45559 .20873 L
.45699 .20845 L
.45945 .20798 L
.46331 .20729 L
.46718 .20666 L
.47104 .2061 L
.4749 .2056 L
.47876 .20516 L
.48262 .20479 L
.48498 .20459 L
F
0 g
.48648 .20447 m
.49035 .20422 L
.49421 .20404 L
.49807 .20391 L
.50193 .20385 L
.50579 .20385 L
.50965 .20391 L
.51352 .20404 L
.51738 .20422 L
.52124 .20447 L
.52276 .20459 L
.5251 .20479 L
.52896 .20516 L
.53282 .2056 L
.53669 .2061 L
.54055 .20666 L
.54441 .20729 L
.54827 .20797 L
.55075 .20845 L
.55213 .20872 L
.55599 .20954 L
.55985 .21041 L
.56372 .21135 L
.56742 .21231 L
.56758 .21235 L
.57144 .21342 L
.5753 .21454 L
.57916 .21573 L
.58055 .21617 L
.58302 .21698 L
.58689 .21829 L
.59075 .21967 L
.59174 .22003 L
.59461 .22111 L
.59847 .22261 L
.60166 .2239 L
.60233 .22417 L
.60619 .2258 L
.61006 .22749 L
.61066 .22776 L
.61392 .22924 L
.61778 .23105 L
.61896 .23162 L
.62164 .23293 L
.6255 .23487 L
.6267 .23548 L
.62936 .23687 L
.63323 .23893 L
.63398 .23934 L
.63709 .24106 L
Mistroke
.64087 .2432 L
.64095 .24325 L
.64481 .2455 L
.64744 .24707 L
.64867 .24781 L
.65253 .25019 L
.65371 .25093 L
.65639 .25263 L
.65973 .25479 L
.66026 .25513 L
.66412 .25769 L
.66553 .25865 L
.66798 .26032 L
.67113 .26251 L
.67184 .26301 L
.6757 .26576 L
.67655 .26637 L
.67956 .26858 L
.6818 .27023 L
.68343 .27145 L
.6869 .2741 L
.68729 .27439 L
.69115 .27739 L
.69187 .27796 L
.69501 .28046 L
.6967 .28182 L
.69887 .28359 L
.70142 .28568 L
.70273 .28678 L
.70602 .28954 L
.7066 .29003 L
.71046 .29334 L
.71053 .2934 L
.71432 .29672 L
.71494 .29727 L
.71818 .30016 L
.71926 .30113 L
.72204 .30366 L
.72349 .30499 L
.7259 .30723 L
.72764 .30885 L
.72977 .31085 L
.73172 .31271 L
.73363 .31454 L
.73572 .31657 L
.73749 .3183 L
.73966 .32044 L
.74135 .32211 L
.74354 .3243 L
.74521 .32599 L
Mistroke
.74735 .32816 L
.74907 .32993 L
.7511 .33202 L
.75293 .33393 L
.7548 .33588 L
.7568 .338 L
.75844 .33974 L
.76066 .34212 L
.76203 .34361 L
.76452 .34631 L
.76557 .34747 L
.76838 .35057 L
.76907 .35133 L
.77224 .35488 L
.77252 .35519 L
.77592 .35905 L
.7761 .35926 L
.77929 .36291 L
.77997 .3637 L
.78261 .36677 L
.78383 .3682 L
.78589 .37064 L
.78769 .37277 L
.78914 .3745 L
.79155 .3774 L
.79235 .37836 L
.79541 .38209 L
.79552 .38222 L
.79866 .38608 L
.79927 .38684 L
.80177 .38994 L
.80314 .39165 L
.80485 .39381 L
.807 .39653 L
.80789 .39767 L
.81086 .40147 L
.8109 .40153 L
.81389 .40539 L
.81472 .40648 L
.81684 .40925 L
.81858 .41154 L
.81977 .41311 L
.82244 .41667 L
.82267 .41698 L
.82555 .42084 L
.82631 .42186 L
.8284 .4247 L
.83017 .42711 L
.83122 .42856 L
.83402 .43242 L
Mistroke
.83403 .43243 L
.8368 .43628 L
.83789 .43781 L
.83955 .44015 L
.84175 .44325 L
.84229 .44401 L
.845 .44787 L
.84561 .44875 L
.84769 .45173 L
.84947 .45432 L
.85035 .45559 L
.853 .45945 L
.85334 .45995 L
.85563 .46331 L
.8572 .46564 L
.85824 .46718 L
.86082 .47104 L
.86106 .47139 L
.86339 .4749 L
.86492 .47721 L
.86595 .47876 L
.86848 .48262 L
.86878 .48308 L
.871 .48648 L
.87264 .48903 L
.8735 .49035 L
.87598 .49421 L
.87651 .49503 L
.87845 .49807 L
.88037 .5011 L
.8809 .50193 L
.88333 .50579 L
.88423 .50722 L
.88575 .50965 L
.88809 .51342 L
.88815 .51352 L
.89054 .51738 L
.89195 .51967 L
.89292 .52124 L
.89528 .5251 L
.89581 .52599 L
.89762 .52896 L
.89968 .53236 L
.89995 .53282 L
.90227 .53669 L
.90354 .53881 L
.90457 .54055 L
.90687 .54441 L
.9074 .54531 L
.90914 .54827 L
Mistroke
.91126 .55188 L
.91141 .55213 L
.91366 .55599 L
.91512 .5585 L
.9159 .55985 L
.91813 .56372 L
.91898 .5652 L
.92035 .56758 L
.92255 .57144 L
.92285 .57195 L
.92475 .5753 L
.92671 .57877 L
.92693 .57916 L
.9291 .58302 L
.93057 .58565 L
.93126 .58689 L
.93341 .59075 L
.93443 .59259 L
.93555 .59461 L
.93768 .59847 L
.93829 .59959 L
.93979 .60233 L
.9419 .60619 L
.94215 .60666 L
.944 .61006 L
.94601 .61379 L
.94609 .61392 L
.94816 .61778 L
.94988 .62098 L
.95023 .62164 L
.95229 .6255 L
.95374 .62823 L
.95434 .62936 L
.95638 .63323 L
.9576 .63555 L
.95762 .63709 L
.95766 .64095 L
.95769 .64481 L
.9576 .64491 L
.95394 .64867 L
.95397 .65253 L
.954 .65639 L
.95374 .65666 L
.95022 .66026 L
.95025 .66412 L
.95028 .66798 L
.94988 .66838 L
.94649 .67184 L
.94651 .6757 L
.94601 .6762 L
Mistroke
.94271 .67956 L
.94273 .68343 L
.94275 .68729 L
.94215 .68789 L
.93894 .69115 L
.93896 .69501 L
.93829 .69568 L
.93515 .69887 L
.93516 .70273 L
.93443 .70347 L
.93134 .7066 L
.93135 .71046 L
.93057 .71124 L
.92753 .71432 L
.92754 .71818 L
.92671 .71902 L
.92371 .72204 L
.92372 .7259 L
.92285 .72678 L
.91989 .72977 L
.9199 .73363 L
.91898 .73454 L
.91606 .73749 L
.91607 .74135 L
.91512 .7423 L
.91223 .74521 L
.91126 .74618 L
.90838 .74907 L
.90839 .75293 L
.9074 .75393 L
.90454 .7568 L
.90455 .76066 L
.90354 .76167 L
.9007 .76452 L
.89968 .76554 L
.89685 .76838 L
.89685 .77224 L
.89581 .77328 L
.893 .7761 L
.89195 .77715 L
.88914 .77997 L
.88809 .78102 L
.88528 .78383 L
.88529 .78769 L
.88423 .78875 L
.88143 .79155 L
.88037 .79261 L
.87757 .79541 L
.87651 .79647 L
.8737 .79927 L
Mistroke
.8737 .80314 L
.87264 .80419 L
.86984 .807 L
.86878 .80805 L
.86597 .81086 L
.86492 .81191 L
.8621 .81472 L
.86106 .81576 L
.85823 .81858 L
.8572 .81962 L
.85436 .82244 L
.85334 .82347 L
.85049 .82631 L
.84947 .82732 L
.84662 .83017 L
.84661 .83403 L
.84561 .83503 L
.84274 .83789 L
.84175 .83887 L
.83886 .84175 L
.83789 .84272 L
.83498 .84561 L
.83403 .84656 L
.83017 .84655 L
.82723 .84947 L
.82631 .85039 L
.82334 .85334 L
.82244 .85423 L
.81946 .8572 L
.81858 .85807 L
.81557 .86106 L
.81472 .86191 L
.81168 .86492 L
.81086 .86574 L
.80779 .86878 L
.807 .86957 L
.8039 .87264 L
.80314 .8734 L
.79927 .87339 L
.79612 .87651 L
.79541 .87721 L
.79222 .88037 L
.79155 .88104 L
.78832 .88423 L
.78769 .88486 L
.78383 .88484 L
.78053 .88809 L
.77997 .88866 L
.77662 .89195 L
.7761 .89247 L
Mistroke
.77271 .89581 L
.77224 .89628 L
.76838 .89626 L
.76491 .89968 L
.76452 .90006 L
.76099 .90354 L
.76066 .90387 L
.7568 .90384 L
.75317 .9074 L
.75293 .90763 L
.74907 .9076 L
.74534 .91126 L
.74521 .91139 L
.7414 .91512 L
.74135 .91518 L
.73749 .91513 L
.73627 .91512 L
.73363 .91252 L
.73234 .91126 L
.72977 .90876 L
.72835 .9074 L
.7259 .90507 L
.72428 .90354 L
.72204 .90144 L
.72014 .89968 L
.71818 .89787 L
.71593 .89581 L
.71432 .89436 L
.71163 .89195 L
.71046 .89091 L
.70724 .88809 L
.7066 .88753 L
.70276 .88423 L
.70273 .88421 L
.69887 .88094 L
.69818 .88037 L
.69501 .87774 L
.6935 .87651 L
.69115 .8746 L
.6887 .87264 L
.68729 .87153 L
.68378 .86878 L
.68343 .86851 L
.67956 .86556 L
.67872 .86492 L
.6757 .86266 L
.67353 .86106 L
.67184 .85983 L
.66817 .8572 L
.66798 .85706 L
Mistroke
.66412 .85435 L
.66264 .85334 L
.66026 .85171 L
.65693 .84947 L
.65639 .84912 L
.65253 .8466 L
.651 .84561 L
.64867 .84414 L
.64483 .84175 L
.64481 .84174 L
.64095 .8394 L
.6384 .83789 L
.63709 .83712 L
.63323 .8349 L
.63167 .83403 L
.62936 .83275 L
.6255 .83066 L
.62458 .83017 L
.62164 .82863 L
.61778 .82666 L
.61708 .82631 L
.61392 .82475 L
.61006 .8229 L
.60908 .82244 L
.60619 .82111 L
.60233 .81939 L
.60047 .81858 L
.59847 .81773 L
.59461 .81613 L
.59108 .81472 L
.59075 .81459 L
.58689 .81311 L
.58302 .8117 L
.58066 .81086 L
.57916 .81034 L
.5753 .80905 L
.57144 .80782 L
.56876 .807 L
.56758 .80665 L
.56372 .80554 L
.55985 .80449 L
.55599 .8035 L
.55448 .80314 L
.55213 .80258 L
.54827 .80172 L
.54441 .80092 L
.54055 .80018 L
.53669 .7995 L
.53531 .79927 L
.53282 .79888 L
Mistroke
.52896 .79833 L
.5251 .79784 L
.52124 .7974 L
.51738 .79703 L
.51352 .79672 L
.50965 .79648 L
.50579 .79629 L
.50193 .79617 L
.49807 .7961 L
.49421 .7961 L
.49035 .79616 L
.48648 .79629 L
.48262 .79647 L
.47876 .79671 L
.4749 .79702 L
.47104 .79739 L
.46718 .79782 L
.46331 .79831 L
.45945 .79886 L
.45682 .79927 L
.45559 .79948 L
.45173 .80015 L
.44787 .80089 L
.44401 .80169 L
.44015 .80255 L
.43765 .80314 L
.43628 .80347 L
.43242 .80445 L
.42856 .8055 L
.4247 .8066 L
.42337 .807 L
.42084 .80777 L
.41698 .809 L
.41311 .81029 L
.41146 .81086 L
.40925 .81164 L
.40539 .81305 L
.40153 .81453 L
.40104 .81472 L
.39767 .81607 L
.39381 .81766 L
.39165 .81858 L
.38994 .81932 L
.38608 .82105 L
.38304 .82244 L
.38222 .82283 L
.37836 .82467 L
.37504 .82631 L
.3745 .82658 L
.37064 .82854 L
Mistroke
.36754 .83017 L
.36677 .83057 L
.36291 .83266 L
.36045 .83403 L
.35905 .83482 L
.35519 .83703 L
.35372 .83789 L
.35133 .8393 L
.34747 .84164 L
.34728 .84175 L
.34361 .84404 L
.34112 .84561 L
.33974 .8465 L
.33588 .84902 L
.33519 .84947 L
.33202 .8516 L
.32947 .85334 L
.32816 .85424 L
.3243 .85695 L
.32394 .8572 L
.32044 .85971 L
.31859 .86106 L
.31657 .86254 L
.31339 .86492 L
.31271 .86543 L
.30885 .86838 L
.30833 .86878 L
.30499 .8714 L
.30341 .87264 L
.30113 .87447 L
.29861 .87651 L
.29727 .87761 L
.29393 .88037 L
.2934 .8808 L
.28954 .88406 L
.28935 .88423 L
.28568 .88738 L
.28487 .88809 L
.28182 .89076 L
.28048 .89195 L
.27796 .89421 L
.27618 .89581 L
.2741 .89771 L
.27196 .89968 L
.27023 .90128 L
.26782 .90354 L
.26637 .90491 L
.26376 .9074 L
.26251 .90859 L
.25976 .91126 L
Mistroke
.25865 .91505 L
.25479 .91131 L
.25474 .91126 L
.25093 .90752 L
.24707 .90756 L
.24691 .9074 L
.2432 .90376 L
.23934 .90379 L
.23908 .90354 L
.23548 .89999 L
.23516 .89968 L
.23162 .89619 L
.22776 .89622 L
.22735 .89581 L
.2239 .8924 L
.22344 .89195 L
.22003 .88859 L
.21953 .88809 L
.21617 .88477 L
.21231 .8848 L
.21174 .88423 L
.20845 .88097 L
.20784 .88037 L
.20459 .87715 L
.20394 .87651 L
.20073 .87333 L
.19686 .87334 L
.19616 .87264 L
.193 .86951 L
.19227 .86878 L
.18914 .86568 L
.18838 .86492 L
.18528 .86185 L
.18449 .86106 L
.18142 .85801 L
.1806 .8572 L
.17756 .85418 L
.17672 .85334 L
.17369 .85034 L
.17283 .84947 L
.16983 .8465 L
.16597 .84651 L
.16508 .84561 L
.16211 .84266 L
.1612 .84175 L
.15825 .83882 L
.15732 .83789 L
.15439 .83497 L
.15344 .83403 L
.15344 .83017 L
Mistroke
.15053 .82726 L
.14957 .82631 L
.14666 .82341 L
.14569 .82244 L
.1428 .81956 L
.14182 .81858 L
.13894 .81571 L
.13795 .81472 L
.13508 .81185 L
.13409 .81086 L
.13122 .80799 L
.13022 .807 L
.12736 .80413 L
.12636 .80314 L
.12636 .79927 L
.12349 .79641 L
.12249 .79541 L
.11963 .79255 L
.11863 .79155 L
.11577 .78869 L
.11478 .78769 L
.11478 .78383 L
.11191 .78096 L
.11092 .77997 L
.10805 .77709 L
.10707 .7761 L
.10419 .77322 L
.10321 .77224 L
.10322 .76838 L
.10032 .76548 L
.09937 .76452 L
.09646 .7616 L
.09552 .76066 L
.09553 .7568 L
.0926 .75386 L
.09168 .75293 L
.09169 .74907 L
.08874 .74611 L
.08785 .74521 L
.08488 .74222 L
.08401 .74135 L
.08401 .73749 L
.08102 .73447 L
.08018 .73363 L
.08019 .72977 L
.07715 .7267 L
.07636 .7259 L
.07637 .72204 L
.07329 .71893 L
.07254 .71818 L
Mistroke
.07255 .71432 L
.06943 .71116 L
.06873 .71046 L
.06875 .7066 L
.06557 .70338 L
.06493 .70273 L
.06495 .69887 L
.06171 .69559 L
.06114 .69501 L
.06115 .69115 L
.05785 .68779 L
.05735 .68729 L
.05737 .68343 L
.05739 .67956 L
.05399 .67609 L
.0536 .6757 L
.05363 .67184 L
.05012 .66826 L
.04984 .66798 L
.04987 .66412 L
.0499 .66026 L
.04626 .65652 L
.04614 .65639 L
.04617 .65253 L
.04621 .64867 L
.04256 .64481 L
.04626 .64315 L
.04741 .64095 L
.04943 .63709 L
.05012 .63576 L
.05146 .63323 L
.0535 .62936 L
.05399 .62844 L
.05554 .6255 L
.0576 .62164 L
.05785 .62118 L
.05967 .61778 L
.06171 .61399 L
.06175 .61392 L
.06383 .61006 L
.06557 .60685 L
.06593 .60619 L
.06803 .60233 L
.06943 .59978 L
.07015 .59847 L
.07228 .59461 L
.07329 .59277 L
.07441 .59075 L
.07656 .58689 L
.07715 .58583 L
Mistroke
.07872 .58302 L
.08089 .57916 L
.08102 .57894 L
.08307 .5753 L
.08488 .57212 L
.08527 .57144 L
.08747 .56758 L
.08874 .56536 L
.08969 .56372 L
.09191 .55985 L
.0926 .55867 L
.09415 .55599 L
.09641 .55213 L
.09646 .55204 L
.09867 .54827 L
.10032 .54546 L
.10095 .54441 L
.10324 .54055 L
.10419 .53896 L
.10554 .53669 L
.10786 .53282 L
.10805 .53251 L
.11019 .52896 L
.11191 .52613 L
.11254 .5251 L
.11489 .52124 L
.11577 .51981 L
.11727 .51738 L
.11963 .51355 L
.11966 .51352 L
.12206 .50965 L
.12349 .50736 L
.12448 .50579 L
.12691 .50193 L
.12736 .50123 L
.12936 .49807 L
.13122 .49516 L
.13182 .49421 L
.13431 .49035 L
.13508 .48915 L
.1368 .48648 L
.13894 .4832 L
.13932 .48262 L
.14185 .47876 L
.1428 .47732 L
.1444 .4749 L
.14666 .4715 L
.14697 .47104 L
.14956 .46718 L
.15053 .46575 L
Mistroke
.15217 .46331 L
.15439 .46005 L
.1548 .45945 L
.15744 .45559 L
.15825 .45442 L
.16011 .45173 L
.16211 .44885 L
.1628 .44787 L
.16551 .44401 L
.16597 .44335 L
.16824 .44015 L
.16983 .4379 L
.17099 .43628 L
.17369 .43252 L
.17377 .43242 L
.17657 .42856 L
.17756 .4272 L
.17939 .4247 L
.18142 .42195 L
.18224 .42084 L
.18511 .41698 L
.18528 .41675 L
.18801 .41311 L
.18914 .41162 L
.19094 .40925 L
.193 .40656 L
.1939 .40539 L
.19686 .40155 L
.19688 .40153 L
.19989 .39767 L
.20073 .39661 L
.20294 .39381 L
.20459 .39173 L
.20601 .38994 L
.20845 .38691 L
.20912 .38608 L
.21226 .38222 L
.21231 .38215 L
.21543 .37836 L
.21617 .37746 L
.21864 .3745 L
.22003 .37283 L
.22188 .37064 L
.2239 .36826 L
.22517 .36677 L
.22776 .36376 L
.22849 .36291 L
.23162 .35932 L
.23185 .35905 L
.23526 .35519 L
Mistroke
.23548 .35494 L
.23871 .35133 L
.23934 .35062 L
.2422 .34747 L
.2432 .34637 L
.24574 .34361 L
.24707 .34217 L
.24933 .33974 L
.25093 .33805 L
.25297 .33588 L
.25479 .33398 L
.25667 .33202 L
.25865 .32997 L
.26042 .32816 L
.26251 .32603 L
.26423 .3243 L
.26637 .32215 L
.2681 .32044 L
.27023 .31834 L
.27204 .31657 L
.2741 .31458 L
.27605 .31271 L
.27796 .31089 L
.28012 .30885 L
.28182 .30726 L
.28427 .30499 L
.28568 .3037 L
.28851 .30113 L
.28954 .30019 L
.29282 .29727 L
.2934 .29675 L
.29723 .2934 L
.29727 .29337 L
.30113 .29006 L
.30173 .28954 L
.30499 .28681 L
.30634 .28568 L
.30885 .28361 L
.31106 .28182 L
.31271 .28049 L
.31589 .27796 L
.31657 .27742 L
.32044 .27442 L
.32085 .2741 L
.3243 .27148 L
.32595 .27023 L
.32816 .2686 L
.33121 .26637 L
.33202 .26578 L
.33588 .26303 L
Mistroke
.33662 .26251 L
.33974 .26034 L
.34222 .25865 L
.34361 .25771 L
.34747 .25515 L
.34802 .25479 L
.35133 .25265 L
.35404 .25093 L
.35519 .25021 L
.35905 .24783 L
.36031 .24707 L
.36291 .24551 L
.36677 .24326 L
.36688 .2432 L
.37064 .24107 L
.37377 .23934 L
.3745 .23895 L
.37836 .23688 L
.38105 .23548 L
.38222 .23488 L
.38608 .23294 L
.38879 .23162 L
.38994 .23106 L
.39381 .22925 L
.39708 .22776 L
.39767 .2275 L
.40153 .22581 L
.40539 .22418 L
.40608 .2239 L
.40925 .22262 L
.41311 .22112 L
.416 .22003 L
.41698 .21968 L
.42084 .2183 L
.4247 .21699 L
.42719 .21617 L
.42856 .21574 L
.43242 .21455 L
.43628 .21342 L
.44015 .21236 L
.44032 .21231 L
.44401 .21136 L
.44787 .21042 L
.45173 .20954 L
.45559 .20873 L
.45699 .20845 L
.45945 .20798 L
.46331 .20729 L
.46718 .20666 L
.47104 .2061 L
Mistroke
.4749 .2056 L
.47876 .20516 L
.48262 .20479 L
.48498 .20459 L
.48648 .20447 L
Mfstroke
1 .869 .5 r
.49421 .25078 m
.49807 .25064 L
.50193 .25057 L
.50579 .25056 L
.50965 .25061 L
.51352 .25072 L
.51738 .2509 L
.51789 .25093 L
.52124 .25114 L
.5251 .25144 L
.52896 .2518 L
.53282 .25223 L
.53669 .25272 L
.54055 .25327 L
.54441 .25389 L
.54827 .25456 L
.54948 .25479 L
.55213 .2553 L
.55599 .25611 L
.55985 .25697 L
.56372 .2579 L
.56666 .25865 L
.56758 .25889 L
.57144 .25994 L
.5753 .26106 L
.57916 .26224 L
.58003 .26251 L
.58302 .26348 L
.58689 .26478 L
.59075 .26615 L
.59136 .26637 L
.59461 .26758 L
.59847 .26907 L
.60138 .27023 L
.60233 .27062 L
.60619 .27224 L
.61006 .27392 L
.61045 .2741 L
.61392 .27566 L
.61778 .27747 L
.6188 .27796 L
.62164 .27934 L
.6255 .28127 L
.62659 .28182 L
.62936 .28326 L
.63323 .28531 L
.6339 .28568 L
.63709 .28743 L
.64082 .28954 L
.64095 .28961 L
.64481 .29186 L
.64741 .2934 L
.64867 .29416 L
.65253 .29653 L
.65371 .29727 L
.65639 .29896 L
.65975 .30113 L
.66026 .30146 L
.66412 .30401 L
.66557 .30499 L
.66798 .30663 L
.67118 .30885 L
.67184 .30932 L
.6757 .31206 L
.67661 .31271 L
.67956 .31487 L
.68187 .31657 L
.68343 .31774 L
.68698 .32044 L
.68729 .32067 L
.69115 .32366 L
.69196 .3243 L
.69501 .32672 L
.6968 .32816 L
.69887 .32984 L
.70152 .33202 L
.70273 .33302 L
.70614 .33588 L
.7066 .33627 L
.71046 .33958 L
.71065 .33974 L
.71432 .34295 L
.71506 .34361 L
.71818 .34638 L
.71939 .34747 L
.72204 .34988 L
.72362 .35133 L
.7259 .35344 L
.72778 .35519 L
.72977 .35706 L
.73186 .35905 L
.73363 .36074 L
.73587 .36291 L
.73749 .36449 L
.73981 .36677 L
.74135 .3683 L
.74369 .37064 L
.74521 .37217 L
.7475 .3745 L
.74907 .37611 L
.75126 .37836 L
.75293 .3801 L
.75496 .38222 L
.7568 .38416 L
.7586 .38608 L
.76066 .38828 L
.7622 .38994 L
.76452 .39247 L
.76574 .39381 L
.76838 .39672 L
.76924 .39767 L
.77224 .40103 L
.77269 .40153 L
.7761 .40539 L
.7761 .4054 L
.77946 .40925 L
.77997 .40984 L
.78279 .41311 L
.78383 .41433 L
.78607 .41698 L
.78769 .41889 L
.78932 .42084 L
.79155 .42352 L
.79253 .4247 L
.79541 .4282 L
.7957 .42856 L
.79885 .43242 L
.79927 .43295 L
.80195 .43628 L
.80314 .43776 L
.80503 .44015 L
.807 .44264 L
.80807 .44401 L
.81086 .44757 L
.81109 .44787 L
.81407 .45173 L
.81472 .45257 L
.81703 .45559 L
.81858 .45764 L
.81996 .45945 L
.82244 .46276 L
.82286 .46331 L
.82573 .46718 L
.82631 .46795 L
.82858 .47104 L
.83017 .4732 L
.83141 .4749 L
.83403 .47851 L
.83421 .47876 L
.83699 .48262 L
.83789 .48388 L
.83974 .48648 L
.84175 .48932 L
.84247 .49035 L
.84518 .49421 L
.84561 .49482 L
.84787 .49807 L
.84947 .50038 L
.85054 .50193 L
.85319 .50579 L
.85334 .50601 L
.85582 .50965 L
.8572 .5117 L
.85842 .51352 L
.86101 .51738 L
.86106 .51745 L
.86358 .52124 L
.86492 .52326 L
.86613 .5251 L
.86867 .52896 L
.86878 .52914 L
.87119 .53282 L
.87264 .53508 L
.87368 .53669 L
.87617 .54055 L
.87651 .54108 L
.87863 .54441 L
.88037 .54714 L
.88108 .54827 L
.88352 .55213 L
.88423 .55327 L
.88594 .55599 L
.88809 .55946 L
.88834 .55985 L
.89073 .56372 L
.89195 .56571 L
.8931 .56758 L
.89546 .57144 L
.89581 .57202 L
.89781 .5753 L
.89968 .5784 L
.90014 .57916 L
.90245 .58302 L
.90354 .58484 L
.90476 .58689 L
.90705 .59075 L
.9074 .59134 L
.90933 .59461 L
.91126 .5979 L
.91159 .59847 L
.91384 .60233 L
.91512 .60453 L
.91608 .60619 L
.91831 .61006 L
.91898 .61122 L
.92053 .61392 L
.92273 .61778 L
.92285 .61797 L
.92493 .62164 L
.92671 .62479 L
.92711 .6255 L
.92928 .62936 L
.93057 .63167 L
.93144 .63323 L
.93359 .63709 L
.93443 .63861 L
.93572 .64095 L
.93785 .64481 L
.93829 .64561 L
.93997 .64867 L
.94208 .65253 L
.94215 .65268 L
.94417 .65639 L
.94601 .6598 L
.94973 .66026 L
.94982 .66412 L
.94988 .66423 L
.94988 .66798 L
.94988 .66799 L
.94611 .67184 L
.94614 .6757 L
.94601 .67583 L
.94235 .67956 L
.94237 .68343 L
.9424 .68729 L
.94215 .68753 L
.9386 .69115 L
.93862 .69501 L
.93829 .69534 L
.93481 .69887 L
.93483 .70273 L
.93443 .70314 L
.93102 .7066 L
.93103 .71046 L
.93057 .71092 L
.92721 .71432 L
.92723 .71818 L
.92671 .7187 L
.9234 .72204 L
.92341 .7259 L
.92285 .72647 L
.91958 .72977 L
.91959 .73363 L
.91898 .73424 L
.91576 .73749 L
.91577 .74135 L
.91512 .742 L
.91193 .74521 L
.91126 .74588 L
.90809 .74907 L
.9081 .75293 L
.9074 .75363 L
.90425 .7568 L
.90426 .76066 L
.90354 .76138 L
.90041 .76452 L
.89968 .76526 L
.89656 .76838 L
.89657 .77224 L
.89581 .773 L
.89271 .7761 L
.89195 .77687 L
.88886 .77997 L
.88809 .78074 L
.885 .78383 L
.88501 .78769 L
.88423 .78847 L
.88115 .79155 L
.88037 .79233 L
.87729 .79541 L
.87651 .79619 L
.87342 .79927 L
.87342 .80314 L
.87264 .80391 L
.86956 .807 L
.86878 .80777 L
.86569 .81086 L
.86492 .81163 L
.86182 .81472 L
.86106 .81548 L
.85795 .81858 L
.8572 .81933 L
.85408 .82244 L
.85334 .82319 L
.85021 .82631 L
.84947 .82704 L
.84633 .83017 L
.84632 .83403 L
.84561 .83474 L
.84245 .83789 L
.84175 .83858 L
.83857 .84175 L
.83789 .84243 L
.83468 .84561 L
.83403 .84627 L
.83017 .84626 L
.82692 .84947 L
.82631 .85009 L
.82304 .85334 L
.82244 .85393 L
.81915 .8572 L
.81858 .85776 L
.81526 .86106 L
.81472 .8616 L
.81137 .86492 L
.81086 .86543 L
.80747 .86878 L
.807 .86925 L
.80357 .87264 L
.80314 .87308 L
.79927 .87306 L
.79579 .87651 L
.79541 .87688 L
.79188 .88037 L
.79155 .8807 L
.78797 .88423 L
.78769 .88451 L
.78383 .88448 L
.78017 .88809 L
.77997 .8883 L
.77625 .89195 L
.7761 .8921 L
.77233 .89581 L
.77224 .8959 L
.76838 .89587 L
.76452 .89965 L
.76199 .89581 L
.76066 .89436 L
.75845 .89195 L
.7568 .89017 L
.75486 .88809 L
.75293 .88604 L
.75122 .88423 L
.74907 .88197 L
.74753 .88037 L
.74521 .87796 L
.74379 .87651 L
.74135 .87402 L
.73999 .87264 L
.73749 .87014 L
.73613 .86878 L
.73363 .86632 L
.7322 .86492 L
.72977 .86256 L
.72821 .86106 L
.7259 .85886 L
.72415 .8572 L
.72204 .85522 L
.72002 .85334 L
.71818 .85164 L
.7158 .84947 L
.71432 .84813 L
.71151 .84561 L
.71046 .84468 L
.70713 .84175 L
.7066 .84129 L
.70273 .83796 L
.70266 .83789 L
.69887 .83469 L
.69809 .83403 L
.69501 .83148 L
.69341 .83017 L
.69115 .82833 L
.68862 .82631 L
.68729 .82525 L
.68371 .82244 L
.68343 .82223 L
.67956 .81927 L
.67866 .81858 L
.6757 .81637 L
.67347 .81472 L
.67184 .81353 L
.66813 .81086 L
.66798 .81075 L
.66412 .80803 L
.66262 .807 L
.66026 .80538 L
.65692 .80314 L
.65639 .80279 L
.65253 .80026 L
.65101 .79927 L
.64867 .79779 L
.64487 .79541 L
.64481 .79538 L
.64095 .79303 L
.63846 .79155 L
.63709 .79074 L
.63323 .78852 L
.63175 .78769 L
.62936 .78636 L
.6255 .78426 L
.6247 .78383 L
.62164 .78222 L
.61778 .78024 L
.61724 .77997 L
.61392 .77832 L
.61006 .77647 L
.60929 .7761 L
.60619 .77467 L
.60233 .77294 L
.60074 .77224 L
.59847 .77127 L
.59461 .76966 L
.59144 .76838 L
.59075 .76811 L
.58689 .76662 L
.58302 .7652 L
.58113 .76452 L
.57916 .76383 L
.5753 .76253 L
.57144 .76129 L
.56941 .76066 L
.56758 .76011 L
.56372 .75899 L
.55985 .75793 L
.55599 .75694 L
.55543 .7568 L
.55213 .756 L
.54827 .75513 L
.54441 .75432 L
.54055 .75357 L
.53701 .75293 L
.53669 .75288 L
.53282 .75225 L
.52896 .75169 L
.5251 .75118 L
.52124 .75074 L
.51738 .75036 L
.51352 .75004 L
.50965 .74978 L
.50579 .74958 L
.50193 .74945 L
.49807 .74937 L
.49421 .74936 L
.49035 .74941 L
.48648 .74952 L
.48262 .74969 L
.47876 .74992 L
.4749 .75021 L
.47104 .75057 L
.46718 .75099 L
.46331 .75146 L
.45945 .752 L
.45559 .75261 L
.45362 .75293 L
.45173 .75327 L
.44787 .75399 L
.44401 .75478 L
.44015 .75562 L
.43628 .75653 L
.4352 .7568 L
.43242 .7575 L
.42856 .75853 L
.4247 .75962 L
.42123 .76066 L
.42084 .76078 L
.41698 .76199 L
.41311 .76327 L
.4095 .76452 L
.40925 .76461 L
.40539 .76601 L
.40153 .76747 L
.39919 .76838 L
.39767 .76899 L
.39381 .77057 L
.38994 .77222 L
.38989 .77224 L
.38608 .77392 L
.38222 .77569 L
.38134 .7761 L
.37836 .77752 L
.3745 .77941 L
.37339 .77997 L
.37064 .78136 L
.36677 .78338 L
.36593 .78383 L
.36291 .78545 L
.35905 .78759 L
.35887 .78769 L
.35519 .78978 L
.35216 .79155 L
.35133 .79204 L
.34747 .79436 L
.34575 .79541 L
.34361 .79675 L
.33974 .79919 L
.33961 .79927 L
.33588 .80169 L
.3337 .80314 L
.33202 .80426 L
.32816 .80689 L
.328 .807 L
.3243 .80957 L
.32248 .81086 L
.32044 .81232 L
.31714 .81472 L
.31657 .81514 L
.31271 .81801 L
.31195 .81858 L
.30885 .82094 L
.30691 .82244 L
.30499 .82394 L
.30199 .82631 L
.30113 .82699 L
.29727 .83011 L
.2972 .83017 L
.2934 .83329 L
.29252 .83403 L
.28954 .83653 L
.28795 .83789 L
.28568 .83984 L
.28347 .84175 L
.28182 .8432 L
.27909 .84561 L
.27796 .84662 L
.2748 .84947 L
.2741 .85011 L
.27058 .85334 L
.27023 .85366 L
.26645 .8572 L
.26637 .85727 L
.26251 .86094 L
.26238 .86106 L
.25865 .86467 L
.25839 .86492 L
.25479 .86846 L
.25447 .86878 L
.25093 .87232 L
.2506 .87264 L
.24707 .87623 L
.2468 .87651 L
.2432 .88021 L
.24305 .88037 L
.23936 .88423 L
.23934 .88425 L
.23572 .88809 L
.23548 .88835 L
.23213 .89195 L
.23162 .89575 L
.23149 .89581 L
.22776 .89582 L
.22775 .89581 L
.2239 .89202 L
.22383 .89195 L
.22003 .88822 L
.21991 .88809 L
.21617 .88441 L
.21231 .88444 L
.2121 .88423 L
.20845 .88062 L
.20819 .88037 L
.20459 .87681 L
.20429 .87651 L
.20073 .87299 L
.19686 .87301 L
.1965 .87264 L
.193 .86918 L
.1926 .86878 L
.18914 .86536 L
.1887 .86492 L
.18528 .86153 L
.18481 .86106 L
.18142 .8577 L
.18092 .8572 L
.17756 .85386 L
.17703 .85334 L
.17369 .85003 L
.17314 .84947 L
.16983 .84619 L
.16597 .8462 L
.16538 .84561 L
.16211 .84236 L
.1615 .84175 L
.15825 .83852 L
.15762 .83789 L
.15439 .83467 L
.15374 .83403 L
.15374 .83017 L
.15053 .82697 L
.14986 .82631 L
.14666 .82312 L
.14599 .82244 L
.1428 .81927 L
.14211 .81858 L
.13894 .81542 L
.13824 .81472 L
.13508 .81156 L
.13438 .81086 L
.13122 .8077 L
.13051 .807 L
.12736 .80385 L
.12665 .80314 L
.12664 .79927 L
.12349 .79612 L
.12278 .79541 L
.11963 .79226 L
.11892 .79155 L
.11577 .7884 L
.11506 .78769 L
.11507 .78383 L
.11191 .78067 L
.11121 .77997 L
.10805 .7768 L
.10736 .7761 L
.10419 .77292 L
.10351 .77224 L
.10351 .76838 L
.10032 .76518 L
.09966 .76452 L
.09646 .76131 L
.09582 .76066 L
.09582 .7568 L
.0926 .75356 L
.09198 .75293 L
.09199 .74907 L
.08874 .7458 L
.08815 .74521 L
.08488 .74192 L
.08431 .74135 L
.08432 .73749 L
.08102 .73415 L
.08049 .73363 L
.0805 .72977 L
.07715 .72638 L
.07668 .7259 L
.07669 .72204 L
.07329 .71861 L
.07287 .71818 L
.07288 .71432 L
.06943 .71082 L
.06907 .71046 L
.06908 .7066 L
.06557 .70303 L
.06528 .70273 L
.0653 .69887 L
.06171 .69523 L
.06149 .69501 L
.06152 .69115 L
.05785 .68741 L
.05772 .68729 L
.05775 .68343 L
.05778 .67956 L
.05402 .6757 L
.0541 .67184 L
.05785 .67001 L
.05893 .66798 L
.06099 .66412 L
.06171 .66279 L
.06307 .66026 L
.06515 .65639 L
.06557 .65563 L
.06725 .65253 L
.06935 .64867 L
.06943 .64853 L
.07147 .64481 L
.07329 .6415 L
.0736 .64095 L
.07573 .63709 L
.07715 .63453 L
.07788 .63323 L
.08004 .62936 L
.08102 .62762 L
.08221 .6255 L
.08439 .62164 L
.08488 .62077 L
.08658 .61778 L
.08874 .61399 L
.08878 .61392 L
.091 .61006 L
.0926 .60727 L
.09322 .60619 L
.09546 .60233 L
.09646 .60061 L
.09771 .59847 L
.09998 .59461 L
.10032 .59402 L
.10225 .59075 L
.10419 .58748 L
.10454 .58689 L
.10684 .58302 L
.10805 .58102 L
.10916 .57916 L
.11149 .5753 L
.11191 .57461 L
.11383 .57144 L
.11577 .56827 L
.11619 .56758 L
.11856 .56372 L
.11963 .56199 L
.12095 .55985 L
.12335 .55599 L
.12349 .55577 L
.12577 .55213 L
.12736 .54961 L
.1282 .54827 L
.13065 .54441 L
.13122 .54352 L
.13312 .54055 L
.13508 .53749 L
.1356 .53669 L
.13809 .53282 L
.13894 .53152 L
.14061 .52896 L
.1428 .52562 L
.14314 .5251 L
.14569 .52124 L
.14666 .51978 L
.14826 .51738 L
.15053 .514 L
.15085 .51352 L
.15345 .50965 L
.15439 .50828 L
.15608 .50579 L
.15825 .50263 L
.15873 .50193 L
.16139 .49807 L
.16211 .49704 L
.16408 .49421 L
.16597 .49151 L
.16679 .49035 L
.16952 .48648 L
.16983 .48604 L
.17227 .48262 L
.17369 .48064 L
.17505 .47876 L
.17756 .4753 L
.17785 .4749 L
.18067 .47104 L
.18142 .47002 L
.18352 .46718 L
.18528 .46481 L
.18639 .46331 L
.18914 .45966 L
.18929 .45945 L
.19222 .45559 L
.193 .45457 L
.19518 .45173 L
.19686 .44954 L
.19816 .44787 L
.20073 .44458 L
.20117 .44401 L
.20422 .44015 L
.20459 .43968 L
.20729 .43628 L
.20845 .43484 L
.2104 .43242 L
.21231 .43006 L
.21354 .42856 L
.21617 .42535 L
.21671 .4247 L
.21992 .42084 L
.22003 .4207 L
.22317 .41698 L
.2239 .41611 L
.22645 .41311 L
.22776 .41159 L
.22977 .40925 L
.23162 .40713 L
.23314 .40539 L
.23548 .40273 L
.23654 .40153 L
.23934 .39839 L
.23999 .39767 L
.2432 .39412 L
.24349 .39381 L
.24703 .38994 L
.24707 .38991 L
.25062 .38608 L
.25093 .38576 L
.25427 .38222 L
.25479 .38167 L
.25796 .37836 L
.25865 .37765 L
.26172 .3745 L
.26251 .37369 L
.26553 .37064 L
.26637 .36979 L
.26941 .36677 L
.27023 .36596 L
.27335 .36291 L
.2741 .36218 L
.27735 .35905 L
.27796 .35847 L
.28143 .35519 L
.28182 .35483 L
.28559 .35133 L
.28568 .35124 L
.28954 .34772 L
.28983 .34747 L
.2934 .34426 L
.29415 .34361 L
.29727 .34087 L
.29856 .33974 L
.30113 .33753 L
.30307 .33588 L
.30499 .33426 L
.30768 .33202 L
.30885 .33106 L
.3124 .32816 L
.31271 .32791 L
.31657 .32483 L
.31725 .3243 L
.32044 .32181 L
.32222 .32044 L
.3243 .31885 L
.32733 .31657 L
.32816 .31596 L
.33202 .31312 L
.33259 .31271 L
.33588 .31036 L
.33802 .30885 L
.33974 .30765 L
.34361 .30501 L
.34363 .30499 L
.34747 .30242 L
.34944 .30113 L
.35133 .29991 L
.35519 .29745 L
.35548 .29727 L
.35905 .29506 L
.36178 .2934 L
.36291 .29273 L
.36677 .29046 L
.36837 .28954 L
.37064 .28825 L
.3745 .28611 L
.37529 .28568 L
.37836 .28403 L
.38222 .28201 L
.3826 .28182 L
.38608 .28006 L
.38994 .27817 L
.39038 .27796 L
.39381 .27634 L
.39767 .27457 L
.39873 .2741 L
.40153 .27287 L
.40539 .27123 L
.40781 .27023 L
.40925 .26965 L
.41311 .26814 L
.41698 .26668 L
.41782 .26637 L
.42084 .26529 L
.4247 .26396 L
.42856 .2627 L
.42915 .26251 L
.43242 .2615 L
.43628 .26036 L
.44015 .25928 L
.44252 .25865 L
.44401 .25827 L
.44787 .25731 L
.45173 .25643 L
.45559 .2556 L
.45945 .25484 L
.4597 .25479 L
.46331 .25413 L
.46718 .2535 L
.47104 .25292 L
.4749 .25241 L
.47876 .25196 L
.48262 .25157 L
.48648 .25124 L
.49035 .25098 L
.49126 .25093 L
F
0 g
.49421 .25078 m
.49807 .25064 L
.50193 .25057 L
.50579 .25056 L
.50965 .25061 L
.51352 .25072 L
.51738 .2509 L
.51789 .25093 L
.52124 .25114 L
.5251 .25144 L
.52896 .2518 L
.53282 .25223 L
.53669 .25272 L
.54055 .25327 L
.54441 .25389 L
.54827 .25456 L
.54948 .25479 L
.55213 .2553 L
.55599 .25611 L
.55985 .25697 L
.56372 .2579 L
.56666 .25865 L
.56758 .25889 L
.57144 .25994 L
.5753 .26106 L
.57916 .26224 L
.58003 .26251 L
.58302 .26348 L
.58689 .26478 L
.59075 .26615 L
.59136 .26637 L
.59461 .26758 L
.59847 .26907 L
.60138 .27023 L
.60233 .27062 L
.60619 .27224 L
.61006 .27392 L
.61045 .2741 L
.61392 .27566 L
.61778 .27747 L
.6188 .27796 L
.62164 .27934 L
.6255 .28127 L
.62659 .28182 L
.62936 .28326 L
.63323 .28531 L
.6339 .28568 L
.63709 .28743 L
.64082 .28954 L
.64095 .28961 L
Mistroke
.64481 .29186 L
.64741 .2934 L
.64867 .29416 L
.65253 .29653 L
.65371 .29727 L
.65639 .29896 L
.65975 .30113 L
.66026 .30146 L
.66412 .30401 L
.66557 .30499 L
.66798 .30663 L
.67118 .30885 L
.67184 .30932 L
.6757 .31206 L
.67661 .31271 L
.67956 .31487 L
.68187 .31657 L
.68343 .31774 L
.68698 .32044 L
.68729 .32067 L
.69115 .32366 L
.69196 .3243 L
.69501 .32672 L
.6968 .32816 L
.69887 .32984 L
.70152 .33202 L
.70273 .33302 L
.70614 .33588 L
.7066 .33627 L
.71046 .33958 L
.71065 .33974 L
.71432 .34295 L
.71506 .34361 L
.71818 .34638 L
.71939 .34747 L
.72204 .34988 L
.72362 .35133 L
.7259 .35344 L
.72778 .35519 L
.72977 .35706 L
.73186 .35905 L
.73363 .36074 L
.73587 .36291 L
.73749 .36449 L
.73981 .36677 L
.74135 .3683 L
.74369 .37064 L
.74521 .37217 L
.7475 .3745 L
.74907 .37611 L
Mistroke
.75126 .37836 L
.75293 .3801 L
.75496 .38222 L
.7568 .38416 L
.7586 .38608 L
.76066 .38828 L
.7622 .38994 L
.76452 .39247 L
.76574 .39381 L
.76838 .39672 L
.76924 .39767 L
.77224 .40103 L
.77269 .40153 L
.7761 .40539 L
.7761 .4054 L
.77946 .40925 L
.77997 .40984 L
.78279 .41311 L
.78383 .41433 L
.78607 .41698 L
.78769 .41889 L
.78932 .42084 L
.79155 .42352 L
.79253 .4247 L
.79541 .4282 L
.7957 .42856 L
.79885 .43242 L
.79927 .43295 L
.80195 .43628 L
.80314 .43776 L
.80503 .44015 L
.807 .44264 L
.80807 .44401 L
.81086 .44757 L
.81109 .44787 L
.81407 .45173 L
.81472 .45257 L
.81703 .45559 L
.81858 .45764 L
.81996 .45945 L
.82244 .46276 L
.82286 .46331 L
.82573 .46718 L
.82631 .46795 L
.82858 .47104 L
.83017 .4732 L
.83141 .4749 L
.83403 .47851 L
.83421 .47876 L
.83699 .48262 L
Mistroke
.83789 .48388 L
.83974 .48648 L
.84175 .48932 L
.84247 .49035 L
.84518 .49421 L
.84561 .49482 L
.84787 .49807 L
.84947 .50038 L
.85054 .50193 L
.85319 .50579 L
.85334 .50601 L
.85582 .50965 L
.8572 .5117 L
.85842 .51352 L
.86101 .51738 L
.86106 .51745 L
.86358 .52124 L
.86492 .52326 L
.86613 .5251 L
.86867 .52896 L
.86878 .52914 L
.87119 .53282 L
.87264 .53508 L
.87368 .53669 L
.87617 .54055 L
.87651 .54108 L
.87863 .54441 L
.88037 .54714 L
.88108 .54827 L
.88352 .55213 L
.88423 .55327 L
.88594 .55599 L
.88809 .55946 L
.88834 .55985 L
.89073 .56372 L
.89195 .56571 L
.8931 .56758 L
.89546 .57144 L
.89581 .57202 L
.89781 .5753 L
.89968 .5784 L
.90014 .57916 L
.90245 .58302 L
.90354 .58484 L
.90476 .58689 L
.90705 .59075 L
.9074 .59134 L
.90933 .59461 L
.91126 .5979 L
.91159 .59847 L
Mistroke
.91384 .60233 L
.91512 .60453 L
.91608 .60619 L
.91831 .61006 L
.91898 .61122 L
.92053 .61392 L
.92273 .61778 L
.92285 .61797 L
.92493 .62164 L
.92671 .62479 L
.92711 .6255 L
.92928 .62936 L
.93057 .63167 L
.93144 .63323 L
.93359 .63709 L
.93443 .63861 L
.93572 .64095 L
.93785 .64481 L
.93829 .64561 L
.93997 .64867 L
.94208 .65253 L
.94215 .65268 L
.94417 .65639 L
.94601 .6598 L
.94973 .66026 L
.94982 .66412 L
.94988 .66423 L
.94988 .66798 L
.94988 .66799 L
.94611 .67184 L
.94614 .6757 L
.94601 .67583 L
.94235 .67956 L
.94237 .68343 L
.9424 .68729 L
.94215 .68753 L
.9386 .69115 L
.93862 .69501 L
.93829 .69534 L
.93481 .69887 L
.93483 .70273 L
.93443 .70314 L
.93102 .7066 L
.93103 .71046 L
.93057 .71092 L
.92721 .71432 L
.92723 .71818 L
.92671 .7187 L
.9234 .72204 L
.92341 .7259 L
Mistroke
.92285 .72647 L
.91958 .72977 L
.91959 .73363 L
.91898 .73424 L
.91576 .73749 L
.91577 .74135 L
.91512 .742 L
.91193 .74521 L
.91126 .74588 L
.90809 .74907 L
.9081 .75293 L
.9074 .75363 L
.90425 .7568 L
.90426 .76066 L
.90354 .76138 L
.90041 .76452 L
.89968 .76526 L
.89656 .76838 L
.89657 .77224 L
.89581 .773 L
.89271 .7761 L
.89195 .77687 L
.88886 .77997 L
.88809 .78074 L
.885 .78383 L
.88501 .78769 L
.88423 .78847 L
.88115 .79155 L
.88037 .79233 L
.87729 .79541 L
.87651 .79619 L
.87342 .79927 L
.87342 .80314 L
.87264 .80391 L
.86956 .807 L
.86878 .80777 L
.86569 .81086 L
.86492 .81163 L
.86182 .81472 L
.86106 .81548 L
.85795 .81858 L
.8572 .81933 L
.85408 .82244 L
.85334 .82319 L
.85021 .82631 L
.84947 .82704 L
.84633 .83017 L
.84632 .83403 L
.84561 .83474 L
.84245 .83789 L
Mistroke
.84175 .83858 L
.83857 .84175 L
.83789 .84243 L
.83468 .84561 L
.83403 .84627 L
.83017 .84626 L
.82692 .84947 L
.82631 .85009 L
.82304 .85334 L
.82244 .85393 L
.81915 .8572 L
.81858 .85776 L
.81526 .86106 L
.81472 .8616 L
.81137 .86492 L
.81086 .86543 L
.80747 .86878 L
.807 .86925 L
.80357 .87264 L
.80314 .87308 L
.79927 .87306 L
.79579 .87651 L
.79541 .87688 L
.79188 .88037 L
.79155 .8807 L
.78797 .88423 L
.78769 .88451 L
.78383 .88448 L
.78017 .88809 L
.77997 .8883 L
.77625 .89195 L
.7761 .8921 L
.77233 .89581 L
.77224 .8959 L
.76838 .89587 L
.76452 .89965 L
.76199 .89581 L
.76066 .89436 L
.75845 .89195 L
.7568 .89017 L
.75486 .88809 L
.75293 .88604 L
.75122 .88423 L
.74907 .88197 L
.74753 .88037 L
.74521 .87796 L
.74379 .87651 L
.74135 .87402 L
.73999 .87264 L
.73749 .87014 L
Mistroke
.73613 .86878 L
.73363 .86632 L
.7322 .86492 L
.72977 .86256 L
.72821 .86106 L
.7259 .85886 L
.72415 .8572 L
.72204 .85522 L
.72002 .85334 L
.71818 .85164 L
.7158 .84947 L
.71432 .84813 L
.71151 .84561 L
.71046 .84468 L
.70713 .84175 L
.7066 .84129 L
.70273 .83796 L
.70266 .83789 L
.69887 .83469 L
.69809 .83403 L
.69501 .83148 L
.69341 .83017 L
.69115 .82833 L
.68862 .82631 L
.68729 .82525 L
.68371 .82244 L
.68343 .82223 L
.67956 .81927 L
.67866 .81858 L
.6757 .81637 L
.67347 .81472 L
.67184 .81353 L
.66813 .81086 L
.66798 .81075 L
.66412 .80803 L
.66262 .807 L
.66026 .80538 L
.65692 .80314 L
.65639 .80279 L
.65253 .80026 L
.65101 .79927 L
.64867 .79779 L
.64487 .79541 L
.64481 .79538 L
.64095 .79303 L
.63846 .79155 L
.63709 .79074 L
.63323 .78852 L
.63175 .78769 L
.62936 .78636 L
Mistroke
.6255 .78426 L
.6247 .78383 L
.62164 .78222 L
.61778 .78024 L
.61724 .77997 L
.61392 .77832 L
.61006 .77647 L
.60929 .7761 L
.60619 .77467 L
.60233 .77294 L
.60074 .77224 L
.59847 .77127 L
.59461 .76966 L
.59144 .76838 L
.59075 .76811 L
.58689 .76662 L
.58302 .7652 L
.58113 .76452 L
.57916 .76383 L
.5753 .76253 L
.57144 .76129 L
.56941 .76066 L
.56758 .76011 L
.56372 .75899 L
.55985 .75793 L
.55599 .75694 L
.55543 .7568 L
.55213 .756 L
.54827 .75513 L
.54441 .75432 L
.54055 .75357 L
.53701 .75293 L
.53669 .75288 L
.53282 .75225 L
.52896 .75169 L
.5251 .75118 L
.52124 .75074 L
.51738 .75036 L
.51352 .75004 L
.50965 .74978 L
.50579 .74958 L
.50193 .74945 L
.49807 .74937 L
.49421 .74936 L
.49035 .74941 L
.48648 .74952 L
.48262 .74969 L
.47876 .74992 L
.4749 .75021 L
.47104 .75057 L
Mistroke
.46718 .75099 L
.46331 .75146 L
.45945 .752 L
.45559 .75261 L
.45362 .75293 L
.45173 .75327 L
.44787 .75399 L
.44401 .75478 L
.44015 .75562 L
.43628 .75653 L
.4352 .7568 L
.43242 .7575 L
.42856 .75853 L
.4247 .75962 L
.42123 .76066 L
.42084 .76078 L
.41698 .76199 L
.41311 .76327 L
.4095 .76452 L
.40925 .76461 L
.40539 .76601 L
.40153 .76747 L
.39919 .76838 L
.39767 .76899 L
.39381 .77057 L
.38994 .77222 L
.38989 .77224 L
.38608 .77392 L
.38222 .77569 L
.38134 .7761 L
.37836 .77752 L
.3745 .77941 L
.37339 .77997 L
.37064 .78136 L
.36677 .78338 L
.36593 .78383 L
.36291 .78545 L
.35905 .78759 L
.35887 .78769 L
.35519 .78978 L
.35216 .79155 L
.35133 .79204 L
.34747 .79436 L
.34575 .79541 L
.34361 .79675 L
.33974 .79919 L
.33961 .79927 L
.33588 .80169 L
.3337 .80314 L
.33202 .80426 L
Mistroke
.32816 .80689 L
.328 .807 L
.3243 .80957 L
.32248 .81086 L
.32044 .81232 L
.31714 .81472 L
.31657 .81514 L
.31271 .81801 L
.31195 .81858 L
.30885 .82094 L
.30691 .82244 L
.30499 .82394 L
.30199 .82631 L
.30113 .82699 L
.29727 .83011 L
.2972 .83017 L
.2934 .83329 L
.29252 .83403 L
.28954 .83653 L
.28795 .83789 L
.28568 .83984 L
.28347 .84175 L
.28182 .8432 L
.27909 .84561 L
.27796 .84662 L
.2748 .84947 L
.2741 .85011 L
.27058 .85334 L
.27023 .85366 L
.26645 .8572 L
.26637 .85727 L
.26251 .86094 L
.26238 .86106 L
.25865 .86467 L
.25839 .86492 L
.25479 .86846 L
.25447 .86878 L
.25093 .87232 L
.2506 .87264 L
.24707 .87623 L
.2468 .87651 L
.2432 .88021 L
.24305 .88037 L
.23936 .88423 L
.23934 .88425 L
.23572 .88809 L
.23548 .88835 L
.23213 .89195 L
.23162 .89575 L
.23149 .89581 L
Mistroke
.22776 .89582 L
.22775 .89581 L
.2239 .89202 L
.22383 .89195 L
.22003 .88822 L
.21991 .88809 L
.21617 .88441 L
.21231 .88444 L
.2121 .88423 L
.20845 .88062 L
.20819 .88037 L
.20459 .87681 L
.20429 .87651 L
.20073 .87299 L
.19686 .87301 L
.1965 .87264 L
.193 .86918 L
.1926 .86878 L
.18914 .86536 L
.1887 .86492 L
.18528 .86153 L
.18481 .86106 L
.18142 .8577 L
.18092 .8572 L
.17756 .85386 L
.17703 .85334 L
.17369 .85003 L
.17314 .84947 L
.16983 .84619 L
.16597 .8462 L
.16538 .84561 L
.16211 .84236 L
.1615 .84175 L
.15825 .83852 L
.15762 .83789 L
.15439 .83467 L
.15374 .83403 L
.15374 .83017 L
.15053 .82697 L
.14986 .82631 L
.14666 .82312 L
.14599 .82244 L
.1428 .81927 L
.14211 .81858 L
.13894 .81542 L
.13824 .81472 L
.13508 .81156 L
.13438 .81086 L
.13122 .8077 L
.13051 .807 L
Mistroke
.12736 .80385 L
.12665 .80314 L
.12664 .79927 L
.12349 .79612 L
.12278 .79541 L
.11963 .79226 L
.11892 .79155 L
.11577 .7884 L
.11506 .78769 L
.11507 .78383 L
.11191 .78067 L
.11121 .77997 L
.10805 .7768 L
.10736 .7761 L
.10419 .77292 L
.10351 .77224 L
.10351 .76838 L
.10032 .76518 L
.09966 .76452 L
.09646 .76131 L
.09582 .76066 L
.09582 .7568 L
.0926 .75356 L
.09198 .75293 L
.09199 .74907 L
.08874 .7458 L
.08815 .74521 L
.08488 .74192 L
.08431 .74135 L
.08432 .73749 L
.08102 .73415 L
.08049 .73363 L
.0805 .72977 L
.07715 .72638 L
.07668 .7259 L
.07669 .72204 L
.07329 .71861 L
.07287 .71818 L
.07288 .71432 L
.06943 .71082 L
.06907 .71046 L
.06908 .7066 L
.06557 .70303 L
.06528 .70273 L
.0653 .69887 L
.06171 .69523 L
.06149 .69501 L
.06152 .69115 L
.05785 .68741 L
.05772 .68729 L
Mistroke
.05775 .68343 L
.05778 .67956 L
.05402 .6757 L
.0541 .67184 L
.05785 .67001 L
.05893 .66798 L
.06099 .66412 L
.06171 .66279 L
.06307 .66026 L
.06515 .65639 L
.06557 .65563 L
.06725 .65253 L
.06935 .64867 L
.06943 .64853 L
.07147 .64481 L
.07329 .6415 L
.0736 .64095 L
.07573 .63709 L
.07715 .63453 L
.07788 .63323 L
.08004 .62936 L
.08102 .62762 L
.08221 .6255 L
.08439 .62164 L
.08488 .62077 L
.08658 .61778 L
.08874 .61399 L
.08878 .61392 L
.091 .61006 L
.0926 .60727 L
.09322 .60619 L
.09546 .60233 L
.09646 .60061 L
.09771 .59847 L
.09998 .59461 L
.10032 .59402 L
.10225 .59075 L
.10419 .58748 L
.10454 .58689 L
.10684 .58302 L
.10805 .58102 L
.10916 .57916 L
.11149 .5753 L
.11191 .57461 L
.11383 .57144 L
.11577 .56827 L
.11619 .56758 L
.11856 .56372 L
.11963 .56199 L
.12095 .55985 L
Mistroke
.12335 .55599 L
.12349 .55577 L
.12577 .55213 L
.12736 .54961 L
.1282 .54827 L
.13065 .54441 L
.13122 .54352 L
.13312 .54055 L
.13508 .53749 L
.1356 .53669 L
.13809 .53282 L
.13894 .53152 L
.14061 .52896 L
.1428 .52562 L
.14314 .5251 L
.14569 .52124 L
.14666 .51978 L
.14826 .51738 L
.15053 .514 L
.15085 .51352 L
.15345 .50965 L
.15439 .50828 L
.15608 .50579 L
.15825 .50263 L
.15873 .50193 L
.16139 .49807 L
.16211 .49704 L
.16408 .49421 L
.16597 .49151 L
.16679 .49035 L
.16952 .48648 L
.16983 .48604 L
.17227 .48262 L
.17369 .48064 L
.17505 .47876 L
.17756 .4753 L
.17785 .4749 L
.18067 .47104 L
.18142 .47002 L
.18352 .46718 L
.18528 .46481 L
.18639 .46331 L
.18914 .45966 L
.18929 .45945 L
.19222 .45559 L
.193 .45457 L
.19518 .45173 L
.19686 .44954 L
.19816 .44787 L
.20073 .44458 L
Mistroke
.20117 .44401 L
.20422 .44015 L
.20459 .43968 L
.20729 .43628 L
.20845 .43484 L
.2104 .43242 L
.21231 .43006 L
.21354 .42856 L
.21617 .42535 L
.21671 .4247 L
.21992 .42084 L
.22003 .4207 L
.22317 .41698 L
.2239 .41611 L
.22645 .41311 L
.22776 .41159 L
.22977 .40925 L
.23162 .40713 L
.23314 .40539 L
.23548 .40273 L
.23654 .40153 L
.23934 .39839 L
.23999 .39767 L
.2432 .39412 L
.24349 .39381 L
.24703 .38994 L
.24707 .38991 L
.25062 .38608 L
.25093 .38576 L
.25427 .38222 L
.25479 .38167 L
.25796 .37836 L
.25865 .37765 L
.26172 .3745 L
.26251 .37369 L
.26553 .37064 L
.26637 .36979 L
.26941 .36677 L
.27023 .36596 L
.27335 .36291 L
.2741 .36218 L
.27735 .35905 L
.27796 .35847 L
.28143 .35519 L
.28182 .35483 L
.28559 .35133 L
.28568 .35124 L
.28954 .34772 L
.28983 .34747 L
.2934 .34426 L
Mistroke
.29415 .34361 L
.29727 .34087 L
.29856 .33974 L
.30113 .33753 L
.30307 .33588 L
.30499 .33426 L
.30768 .33202 L
.30885 .33106 L
.3124 .32816 L
.31271 .32791 L
.31657 .32483 L
.31725 .3243 L
.32044 .32181 L
.32222 .32044 L
.3243 .31885 L
.32733 .31657 L
.32816 .31596 L
.33202 .31312 L
.33259 .31271 L
.33588 .31036 L
.33802 .30885 L
.33974 .30765 L
.34361 .30501 L
.34363 .30499 L
.34747 .30242 L
.34944 .30113 L
.35133 .29991 L
.35519 .29745 L
.35548 .29727 L
.35905 .29506 L
.36178 .2934 L
.36291 .29273 L
.36677 .29046 L
.36837 .28954 L
.37064 .28825 L
.3745 .28611 L
.37529 .28568 L
.37836 .28403 L
.38222 .28201 L
.3826 .28182 L
.38608 .28006 L
.38994 .27817 L
.39038 .27796 L
.39381 .27634 L
.39767 .27457 L
.39873 .2741 L
.40153 .27287 L
.40539 .27123 L
.40781 .27023 L
.40925 .26965 L
Mistroke
.41311 .26814 L
.41698 .26668 L
.41782 .26637 L
.42084 .26529 L
.4247 .26396 L
.42856 .2627 L
.42915 .26251 L
.43242 .2615 L
.43628 .26036 L
.44015 .25928 L
.44252 .25865 L
.44401 .25827 L
.44787 .25731 L
.45173 .25643 L
.45559 .2556 L
.45945 .25484 L
.4597 .25479 L
.46331 .25413 L
.46718 .2535 L
.47104 .25292 L
.4749 .25241 L
.47876 .25196 L
.48262 .25157 L
.48648 .25124 L
.49035 .25098 L
.49126 .25093 L
.49421 .25078 L
Mfstroke
1 .772 .5 r
.47104 .29284 m
.4749 .29231 L
.47876 .29184 L
.48262 .29144 L
.48648 .2911 L
.49035 .29083 L
.49421 .29061 L
.49807 .29046 L
.50193 .29037 L
.50579 .29035 L
.50965 .29038 L
.51352 .29048 L
.51738 .29065 L
.52124 .29087 L
.5251 .29116 L
.52896 .29151 L
.53282 .29192 L
.53669 .2924 L
.54055 .29294 L
.54357 .2934 L
.54441 .29354 L
.54827 .29421 L
.55213 .29493 L
.55599 .29572 L
.55985 .29658 L
.56279 .29727 L
.56372 .29749 L
.56758 .29847 L
.57144 .29951 L
.5753 .30062 L
.57702 .30113 L
.57916 .30178 L
.58302 .30301 L
.58689 .30431 L
.58886 .30499 L
.59075 .30566 L
.59461 .30708 L
.59847 .30856 L
.59921 .30885 L
.60233 .3101 L
.60619 .31171 L
.60853 .31271 L
.61006 .31338 L
.61392 .31511 L
.61708 .31657 L
.61778 .3169 L
.62164 .31876 L
.62501 .32044 L
.6255 .32068 L
.62936 .32266 L
.63246 .3243 L
.63323 .32471 L
.63709 .32682 L
.63948 .32816 L
.64095 .32899 L
.64481 .33122 L
.64616 .33202 L
.64867 .33352 L
.65253 .33588 L
.65254 .33588 L
.65639 .3383 L
.65865 .33974 L
.66026 .34079 L
.66412 .34333 L
.66452 .34361 L
.66798 .34594 L
.67019 .34747 L
.67184 .34862 L
.67567 .35133 L
.6757 .35135 L
.67956 .35415 L
.68098 .35519 L
.68343 .35701 L
.68613 .35905 L
.68729 .35994 L
.69114 .36291 L
.69115 .36292 L
.69501 .36597 L
.69601 .36677 L
.69887 .36908 L
.70077 .37064 L
.70273 .37226 L
.70541 .3745 L
.7066 .3755 L
.70995 .37836 L
.71046 .3788 L
.71432 .38216 L
.71439 .38222 L
.71818 .38559 L
.71873 .38608 L
.72204 .38908 L
.72299 .38994 L
.7259 .39263 L
.72717 .39381 L
.72977 .39624 L
.73127 .39767 L
.73363 .39992 L
.7353 .40153 L
.73749 .40366 L
.73926 .40539 L
.74135 .40746 L
.74315 .40925 L
.74521 .41133 L
.74698 .41311 L
.74907 .41525 L
.75075 .41698 L
.75293 .41925 L
.75446 .42084 L
.7568 .4233 L
.75812 .4247 L
.76066 .42741 L
.76172 .42856 L
.76452 .43159 L
.76528 .43242 L
.76838 .43584 L
.76879 .43628 L
.77224 .44014 L
.77225 .44015 L
.77567 .44401 L
.7761 .44451 L
.77904 .44787 L
.77997 .44894 L
.78237 .45173 L
.78383 .45343 L
.78567 .45559 L
.78769 .45798 L
.78892 .45945 L
.79155 .4626 L
.79214 .46331 L
.79532 .46718 L
.79541 .46728 L
.79847 .47104 L
.79927 .47203 L
.80159 .4749 L
.80314 .47683 L
.80467 .47876 L
.807 .4817 L
.80772 .48262 L
.81074 .48648 L
.81086 .48663 L
.81373 .49035 L
.81472 .49163 L
.8167 .49421 L
.81858 .49669 L
.81963 .49807 L
.82244 .50181 L
.82254 .50193 L
.82542 .50579 L
.82631 .50699 L
.82827 .50965 L
.83017 .51223 L
.8311 .51352 L
.83391 .51738 L
.83403 .51754 L
.83669 .52124 L
.83789 .52291 L
.83945 .5251 L
.84175 .52835 L
.84219 .52896 L
.8449 .53282 L
.84561 .53384 L
.84759 .53669 L
.84947 .5394 L
.85026 .54055 L
.85292 .54441 L
.85334 .54502 L
.85555 .54827 L
.8572 .55071 L
.85816 .55213 L
.86075 .55599 L
.86106 .55646 L
.86332 .55985 L
.86492 .56227 L
.86588 .56372 L
.86842 .56758 L
.86878 .56814 L
.87094 .57144 L
.87264 .57407 L
.87344 .5753 L
.87592 .57916 L
.87651 .58007 L
.87839 .58302 L
.88037 .58613 L
.88084 .58689 L
.88328 .59075 L
.88423 .59226 L
.8857 .59461 L
.88809 .59844 L
.88811 .59847 L
.8905 .60233 L
.89195 .60469 L
.89288 .60619 L
.89524 .61006 L
.89581 .611 L
.89758 .61392 L
.89968 .61738 L
.89992 .61778 L
.90224 .62164 L
.90354 .62382 L
.90454 .6255 L
.90684 .62936 L
.9074 .63032 L
.90912 .63323 L
.91126 .63688 L
.91138 .63709 L
.91364 .64095 L
.91512 .6435 L
.91588 .64481 L
.91811 .64867 L
.91898 .65019 L
.92033 .65253 L
.92253 .65639 L
.92285 .65694 L
.92473 .66026 L
.92671 .66376 L
.92691 .66412 L
.92908 .66798 L
.93057 .67063 L
.93124 .67184 L
.93339 .6757 L
.93443 .67757 L
.93553 .67956 L
.93766 .68343 L
.93829 .68457 L
.94208 .68729 L
.93833 .69115 L
.93836 .69501 L
.93829 .69508 L
.93456 .69887 L
.93458 .70273 L
.93443 .70288 L
.93077 .7066 L
.93079 .71046 L
.93057 .71068 L
.92697 .71432 L
.92699 .71818 L
.92671 .71846 L
.92317 .72204 L
.92318 .7259 L
.92285 .72624 L
.91936 .72977 L
.91937 .73363 L
.91898 .73401 L
.91554 .73749 L
.91555 .74135 L
.91512 .74178 L
.91171 .74521 L
.91126 .74566 L
.90787 .74907 L
.90788 .75293 L
.9074 .75342 L
.90404 .7568 L
.90405 .76066 L
.90354 .76117 L
.9002 .76452 L
.89968 .76504 L
.89635 .76838 L
.89636 .77224 L
.89581 .77279 L
.8925 .7761 L
.89195 .77666 L
.88865 .77997 L
.88809 .78053 L
.88479 .78383 L
.8848 .78769 L
.88423 .78826 L
.88094 .79155 L
.88037 .79212 L
.87708 .79541 L
.87651 .79598 L
.87321 .79927 L
.87321 .80314 L
.87264 .8037 L
.86935 .807 L
.86878 .80756 L
.86548 .81086 L
.86492 .81142 L
.86161 .81472 L
.86106 .81527 L
.85774 .81858 L
.8572 .81912 L
.85387 .82244 L
.85334 .82297 L
.84999 .82631 L
.84947 .82682 L
.84611 .83017 L
.84611 .83403 L
.84561 .83452 L
.84223 .83789 L
.84175 .83837 L
.83835 .84175 L
.83789 .84221 L
.83446 .84561 L
.83403 .84605 L
.83017 .84603 L
.8267 .84947 L
.82631 .84987 L
.82281 .85334 L
.82244 .8537 L
.81892 .8572 L
.81858 .85753 L
.81502 .86106 L
.81472 .86136 L
.81113 .86492 L
.81086 .86519 L
.80723 .86878 L
.807 .86901 L
.80332 .87264 L
.80314 .87283 L
.79927 .87281 L
.79553 .87651 L
.79541 .87662 L
.79162 .88037 L
.79155 .88043 L
.7877 .88423 L
.78769 .88424 L
.78391 .88423 L
.78383 .88419 L
.78271 .88037 L
.77997 .87713 L
.77944 .87651 L
.77612 .87264 L
.7761 .87263 L
.77277 .86878 L
.77224 .86818 L
.76937 .86492 L
.76838 .8638 L
.76593 .86106 L
.76452 .85948 L
.76245 .8572 L
.76066 .85523 L
.75893 .85334 L
.7568 .85103 L
.75535 .84947 L
.75293 .8469 L
.75173 .84561 L
.74907 .84282 L
.74805 .84175 L
.74521 .83881 L
.74432 .83789 L
.74135 .83486 L
.74053 .83403 L
.73749 .83097 L
.73669 .83017 L
.73363 .82714 L
.73278 .82631 L
.72977 .82337 L
.7288 .82244 L
.7259 .81967 L
.72476 .81858 L
.72204 .81602 L
.72065 .81472 L
.71818 .81244 L
.71646 .81086 L
.71432 .80892 L
.71218 .807 L
.71046 .80546 L
.70783 .80314 L
.7066 .80206 L
.70338 .79927 L
.70273 .79872 L
.69887 .79544 L
.69883 .79541 L
.69501 .79223 L
.69419 .79155 L
.69115 .78908 L
.68943 .78769 L
.68729 .78598 L
.68455 .78383 L
.68343 .78295 L
.67956 .77998 L
.67954 .77997 L
.6757 .77707 L
.6744 .7761 L
.67184 .77423 L
.6691 .77224 L
.66798 .77144 L
.66412 .76872 L
.66364 .76838 L
.66026 .76605 L
.65799 .76452 L
.65639 .76345 L
.65253 .76091 L
.65215 .76066 L
.64867 .75843 L
.64607 .7568 L
.64481 .75601 L
.64095 .75366 L
.63975 .75293 L
.63709 .75136 L
.63323 .74913 L
.63313 .74907 L
.62936 .74695 L
.62619 .74521 L
.6255 .74484 L
.62164 .74279 L
.61885 .74135 L
.61778 .7408 L
.61392 .73888 L
.61106 .73749 L
.61006 .73701 L
.60619 .7352 L
.60271 .73363 L
.60233 .73346 L
.59847 .73178 L
.59461 .73016 L
.59365 .72977 L
.59075 .7286 L
.58689 .7271 L
.58368 .7259 L
.58302 .72566 L
.57916 .72429 L
.5753 .72297 L
.57245 .72204 L
.57144 .72172 L
.56758 .72053 L
.56372 .7194 L
.55985 .71833 L
.55931 .71818 L
.55599 .71732 L
.55213 .71637 L
.54827 .71549 L
.54441 .71466 L
.5427 .71432 L
.54055 .7139 L
.53669 .7132 L
.53282 .71256 L
.52896 .71198 L
.5251 .71146 L
.52124 .71101 L
.51738 .71061 L
.51569 .71046 L
.51352 .71028 L
.50965 .71 L
.50579 .70979 L
.50193 .70964 L
.49807 .70956 L
.49421 .70953 L
.49035 .70956 L
.48648 .70966 L
.48262 .70981 L
.47876 .71003 L
.4749 .71031 L
.47314 .71046 L
.47104 .71065 L
.46718 .71105 L
.46331 .71152 L
.45945 .71204 L
.45559 .71263 L
.45173 .71327 L
.44787 .71398 L
.44613 .71432 L
.44401 .71475 L
.44015 .71558 L
.43628 .71647 L
.43242 .71743 L
.42952 .71818 L
.42856 .71844 L
.4247 .71952 L
.42084 .72065 L
.41698 .72185 L
.41638 .72204 L
.41311 .72311 L
.40925 .72443 L
.40539 .72581 L
.40514 .7259 L
.40153 .72726 L
.39767 .72876 L
.39517 .72977 L
.39381 .73033 L
.38994 .73195 L
.38611 .73363 L
.38608 .73364 L
.38222 .73539 L
.37836 .7372 L
.37776 .73749 L
.3745 .73907 L
.37064 .74101 L
.36996 .74135 L
.36677 .743 L
.36291 .74506 L
.36263 .74521 L
.35905 .74717 L
.35568 .74907 L
.35519 .74935 L
.35133 .75159 L
.34906 .75293 L
.34747 .75389 L
.34361 .75625 L
.34273 .7568 L
.33974 .75868 L
.33666 .76066 L
.33588 .76116 L
.33202 .76371 L
.33081 .76452 L
.32816 .76631 L
.32516 .76838 L
.3243 .76898 L
.32044 .77171 L
.31969 .77224 L
.31657 .7745 L
.31439 .7761 L
.31271 .77735 L
.30925 .77997 L
.30885 .78027 L
.30499 .78324 L
.30424 .78383 L
.30113 .78628 L
.29936 .78769 L
.29727 .78937 L
.2946 .79155 L
.2934 .79253 L
.28995 .79541 L
.28954 .79575 L
.28568 .79903 L
.2854 .79927 L
.28182 .80237 L
.28095 .80314 L
.27796 .80578 L
.27659 .807 L
.2741 .80924 L
.27231 .81086 L
.27023 .81276 L
.26812 .81472 L
.26637 .81635 L
.264 .81858 L
.26251 .82 L
.25996 .82244 L
.25865 .82371 L
.25598 .82631 L
.25479 .82748 L
.25207 .83017 L
.25093 .83131 L
.24822 .83403 L
.24707 .8352 L
.24443 .83789 L
.2432 .83915 L
.2407 .84175 L
.23934 .84317 L
.23702 .84561 L
.23548 .84725 L
.23339 .84947 L
.23162 .85138 L
.22982 .85334 L
.22776 .85558 L
.22629 .8572 L
.2239 .85984 L
.2228 .86106 L
.22003 .86416 L
.21936 .86492 L
.21617 .86854 L
.21596 .86878 L
.21261 .87264 L
.21231 .87299 L
.20929 .87651 L
.20845 .88032 L
.20459 .87654 L
.20455 .87651 L
.20073 .87273 L
.19686 .87275 L
.19676 .87264 L
.193 .86893 L
.19285 .86878 L
.18914 .86511 L
.18895 .86492 L
.18528 .86128 L
.18505 .86106 L
.18142 .85746 L
.18116 .8572 L
.17756 .85363 L
.17727 .85334 L
.17369 .84979 L
.17338 .84947 L
.16983 .84596 L
.16597 .84597 L
.16561 .84561 L
.16211 .84213 L
.16173 .84175 L
.15825 .83829 L
.15784 .83789 L
.15439 .83445 L
.15396 .83403 L
.15396 .83017 L
.15053 .82675 L
.15008 .82631 L
.14666 .8229 L
.14621 .82244 L
.1428 .81905 L
.14233 .81858 L
.13894 .8152 L
.13846 .81472 L
.13508 .81134 L
.13459 .81086 L
.13122 .80749 L
.13073 .807 L
.12736 .80363 L
.12686 .80314 L
.12686 .79927 L
.12349 .79591 L
.123 .79541 L
.11963 .79205 L
.11914 .79155 L
.11577 .78818 L
.11528 .78769 L
.11528 .78383 L
.11191 .78045 L
.11143 .77997 L
.10805 .77658 L
.10757 .7761 L
.10419 .7727 L
.10372 .77224 L
.10373 .76838 L
.10032 .76496 L
.09988 .76452 L
.09646 .76108 L
.09604 .76066 L
.09605 .7568 L
.0926 .75333 L
.09221 .75293 L
.09221 .74907 L
.08874 .74557 L
.08838 .74521 L
.08488 .74168 L
.08455 .74135 L
.08456 .73749 L
.08102 .73392 L
.08073 .73363 L
.08074 .72977 L
.07715 .72614 L
.07692 .7259 L
.07693 .72204 L
.07329 .71836 L
.07312 .71818 L
.07313 .71432 L
.06943 .71056 L
.06932 .71046 L
.06934 .7066 L
.06557 .70276 L
.06554 .70273 L
.06556 .69887 L
.06557 .69797 L
.06717 .69501 L
.06926 .69115 L
.06943 .69084 L
.07137 .68729 L
.07329 .68377 L
.07348 .68343 L
.07561 .67956 L
.07715 .67677 L
.07775 .6757 L
.07989 .67184 L
.08102 .66983 L
.08205 .66798 L
.08422 .66412 L
.08488 .66295 L
.0864 .66026 L
.08859 .65639 L
.08874 .65614 L
.0908 .65253 L
.0926 .64939 L
.09301 .64867 L
.09524 .64481 L
.09646 .6427 L
.09748 .64095 L
.09973 .63709 L
.10032 .63608 L
.102 .63323 L
.10419 .62951 L
.10427 .62936 L
.10657 .6255 L
.10805 .62301 L
.10887 .62164 L
.11119 .61778 L
.11191 .61658 L
.11352 .61392 L
.11577 .6102 L
.11586 .61006 L
.11822 .60619 L
.11963 .60389 L
.12059 .60233 L
.12298 .59847 L
.12349 .59765 L
.12539 .59461 L
.12736 .59146 L
.1278 .59075 L
.13024 .58689 L
.13122 .58534 L
.13269 .58302 L
.13508 .57928 L
.13515 .57916 L
.13764 .5753 L
.13894 .57328 L
.14014 .57144 L
.14265 .56758 L
.1428 .56735 L
.14519 .56372 L
.14666 .56148 L
.14774 .55985 L
.15031 .55599 L
.15053 .55567 L
.1529 .55213 L
.15439 .54993 L
.15551 .54827 L
.15814 .54441 L
.15825 .54425 L
.16079 .54055 L
.16211 .53863 L
.16346 .53669 L
.16597 .53308 L
.16615 .53282 L
.16886 .52896 L
.16983 .52758 L
.17159 .5251 L
.17369 .52215 L
.17435 .52124 L
.17713 .51738 L
.17756 .51679 L
.17993 .51352 L
.18142 .51148 L
.18276 .50965 L
.18528 .50624 L
.18561 .50579 L
.18849 .50193 L
.18914 .50106 L
.1914 .49807 L
.193 .49595 L
.19433 .49421 L
.19686 .4909 L
.19729 .49035 L
.20028 .48648 L
.20073 .48591 L
.20329 .48262 L
.20459 .48098 L
.20634 .47876 L
.20845 .47612 L
.20942 .4749 L
.21231 .47132 L
.21254 .47104 L
.21568 .46718 L
.21617 .46658 L
.21886 .46331 L
.22003 .4619 L
.22208 .45945 L
.2239 .45729 L
.22533 .45559 L
.22776 .45274 L
.22862 .45173 L
.23162 .44826 L
.23195 .44787 L
.23533 .44401 L
.23548 .44383 L
.23874 .44015 L
.23934 .43947 L
.2422 .43628 L
.2432 .43517 L
.24571 .43242 L
.24707 .43094 L
.24926 .42856 L
.25093 .42677 L
.25286 .4247 L
.25479 .42266 L
.25652 .42084 L
.25865 .41861 L
.26023 .41698 L
.26251 .41463 L
.264 .41311 L
.26637 .41071 L
.26782 .40925 L
.27023 .40685 L
.27171 .40539 L
.2741 .40306 L
.27567 .40153 L
.27796 .39932 L
.27969 .39767 L
.28182 .39565 L
.28379 .39381 L
.28568 .39205 L
.28797 .38994 L
.28954 .38851 L
.29222 .38608 L
.2934 .38502 L
.29657 .38222 L
.29727 .38161 L
.301 .37836 L
.30113 .37825 L
.30499 .37496 L
.30554 .3745 L
.30885 .37173 L
.31018 .37064 L
.31271 .36856 L
.31493 .36677 L
.31657 .36546 L
.3198 .36291 L
.32044 .36242 L
.3243 .35944 L
.32481 .35905 L
.32816 .35653 L
.32996 .35519 L
.33202 .35368 L
.33526 .35133 L
.33588 .35089 L
.33974 .34816 L
.34074 .34747 L
.34361 .3455 L
.3464 .34361 L
.34747 .3429 L
.35133 .34036 L
.35228 .33974 L
.35519 .33788 L
.35839 .33588 L
.35905 .33547 L
.36291 .33312 L
.36476 .33202 L
.36677 .33083 L
.37064 .32861 L
.37143 .32816 L
.3745 .32645 L
.37836 .32435 L
.37846 .3243 L
.38222 .32232 L
.3859 .32044 L
.38608 .32034 L
.38994 .31843 L
.39381 .31659 L
.39383 .31657 L
.39767 .3148 L
.40153 .31308 L
.40238 .31271 L
.40539 .31142 L
.40925 .30983 L
.41169 .30885 L
.41311 .30829 L
.41698 .30682 L
.42084 .30542 L
.42205 .30499 L
.4247 .30407 L
.42856 .30279 L
.43242 .30157 L
.43388 .30113 L
.43628 .30042 L
.44015 .29932 L
.44401 .29829 L
.44787 .29733 L
.44811 .29727 L
.45173 .29642 L
.45559 .29558 L
.45945 .2948 L
.46331 .29408 L
.46718 .29343 L
.46733 .2934 L
F
0 g
.47104 .29284 m
.4749 .29231 L
.47876 .29184 L
.48262 .29144 L
.48648 .2911 L
.49035 .29083 L
.49421 .29061 L
.49807 .29046 L
.50193 .29037 L
.50579 .29035 L
.50965 .29038 L
.51352 .29048 L
.51738 .29065 L
.52124 .29087 L
.5251 .29116 L
.52896 .29151 L
.53282 .29192 L
.53669 .2924 L
.54055 .29294 L
.54357 .2934 L
.54441 .29354 L
.54827 .29421 L
.55213 .29493 L
.55599 .29572 L
.55985 .29658 L
.56279 .29727 L
.56372 .29749 L
.56758 .29847 L
.57144 .29951 L
.5753 .30062 L
.57702 .30113 L
.57916 .30178 L
.58302 .30301 L
.58689 .30431 L
.58886 .30499 L
.59075 .30566 L
.59461 .30708 L
.59847 .30856 L
.59921 .30885 L
.60233 .3101 L
.60619 .31171 L
.60853 .31271 L
.61006 .31338 L
.61392 .31511 L
.61708 .31657 L
.61778 .3169 L
.62164 .31876 L
.62501 .32044 L
.6255 .32068 L
.62936 .32266 L
Mistroke
.63246 .3243 L
.63323 .32471 L
.63709 .32682 L
.63948 .32816 L
.64095 .32899 L
.64481 .33122 L
.64616 .33202 L
.64867 .33352 L
.65253 .33588 L
.65254 .33588 L
.65639 .3383 L
.65865 .33974 L
.66026 .34079 L
.66412 .34333 L
.66452 .34361 L
.66798 .34594 L
.67019 .34747 L
.67184 .34862 L
.67567 .35133 L
.6757 .35135 L
.67956 .35415 L
.68098 .35519 L
.68343 .35701 L
.68613 .35905 L
.68729 .35994 L
.69114 .36291 L
.69115 .36292 L
.69501 .36597 L
.69601 .36677 L
.69887 .36908 L
.70077 .37064 L
.70273 .37226 L
.70541 .3745 L
.7066 .3755 L
.70995 .37836 L
.71046 .3788 L
.71432 .38216 L
.71439 .38222 L
.71818 .38559 L
.71873 .38608 L
.72204 .38908 L
.72299 .38994 L
.7259 .39263 L
.72717 .39381 L
.72977 .39624 L
.73127 .39767 L
.73363 .39992 L
.7353 .40153 L
.73749 .40366 L
.73926 .40539 L
Mistroke
.74135 .40746 L
.74315 .40925 L
.74521 .41133 L
.74698 .41311 L
.74907 .41525 L
.75075 .41698 L
.75293 .41925 L
.75446 .42084 L
.7568 .4233 L
.75812 .4247 L
.76066 .42741 L
.76172 .42856 L
.76452 .43159 L
.76528 .43242 L
.76838 .43584 L
.76879 .43628 L
.77224 .44014 L
.77225 .44015 L
.77567 .44401 L
.7761 .44451 L
.77904 .44787 L
.77997 .44894 L
.78237 .45173 L
.78383 .45343 L
.78567 .45559 L
.78769 .45798 L
.78892 .45945 L
.79155 .4626 L
.79214 .46331 L
.79532 .46718 L
.79541 .46728 L
.79847 .47104 L
.79927 .47203 L
.80159 .4749 L
.80314 .47683 L
.80467 .47876 L
.807 .4817 L
.80772 .48262 L
.81074 .48648 L
.81086 .48663 L
.81373 .49035 L
.81472 .49163 L
.8167 .49421 L
.81858 .49669 L
.81963 .49807 L
.82244 .50181 L
.82254 .50193 L
.82542 .50579 L
.82631 .50699 L
.82827 .50965 L
Mistroke
.83017 .51223 L
.8311 .51352 L
.83391 .51738 L
.83403 .51754 L
.83669 .52124 L
.83789 .52291 L
.83945 .5251 L
.84175 .52835 L
.84219 .52896 L
.8449 .53282 L
.84561 .53384 L
.84759 .53669 L
.84947 .5394 L
.85026 .54055 L
.85292 .54441 L
.85334 .54502 L
.85555 .54827 L
.8572 .55071 L
.85816 .55213 L
.86075 .55599 L
.86106 .55646 L
.86332 .55985 L
.86492 .56227 L
.86588 .56372 L
.86842 .56758 L
.86878 .56814 L
.87094 .57144 L
.87264 .57407 L
.87344 .5753 L
.87592 .57916 L
.87651 .58007 L
.87839 .58302 L
.88037 .58613 L
.88084 .58689 L
.88328 .59075 L
.88423 .59226 L
.8857 .59461 L
.88809 .59844 L
.88811 .59847 L
.8905 .60233 L
.89195 .60469 L
.89288 .60619 L
.89524 .61006 L
.89581 .611 L
.89758 .61392 L
.89968 .61738 L
.89992 .61778 L
.90224 .62164 L
.90354 .62382 L
.90454 .6255 L
Mistroke
.90684 .62936 L
.9074 .63032 L
.90912 .63323 L
.91126 .63688 L
.91138 .63709 L
.91364 .64095 L
.91512 .6435 L
.91588 .64481 L
.91811 .64867 L
.91898 .65019 L
.92033 .65253 L
.92253 .65639 L
.92285 .65694 L
.92473 .66026 L
.92671 .66376 L
.92691 .66412 L
.92908 .66798 L
.93057 .67063 L
.93124 .67184 L
.93339 .6757 L
.93443 .67757 L
.93553 .67956 L
.93766 .68343 L
.93829 .68457 L
.94208 .68729 L
.93833 .69115 L
.93836 .69501 L
.93829 .69508 L
.93456 .69887 L
.93458 .70273 L
.93443 .70288 L
.93077 .7066 L
.93079 .71046 L
.93057 .71068 L
.92697 .71432 L
.92699 .71818 L
.92671 .71846 L
.92317 .72204 L
.92318 .7259 L
.92285 .72624 L
.91936 .72977 L
.91937 .73363 L
.91898 .73401 L
.91554 .73749 L
.91555 .74135 L
.91512 .74178 L
.91171 .74521 L
.91126 .74566 L
.90787 .74907 L
.90788 .75293 L
Mistroke
.9074 .75342 L
.90404 .7568 L
.90405 .76066 L
.90354 .76117 L
.9002 .76452 L
.89968 .76504 L
.89635 .76838 L
.89636 .77224 L
.89581 .77279 L
.8925 .7761 L
.89195 .77666 L
.88865 .77997 L
.88809 .78053 L
.88479 .78383 L
.8848 .78769 L
.88423 .78826 L
.88094 .79155 L
.88037 .79212 L
.87708 .79541 L
.87651 .79598 L
.87321 .79927 L
.87321 .80314 L
.87264 .8037 L
.86935 .807 L
.86878 .80756 L
.86548 .81086 L
.86492 .81142 L
.86161 .81472 L
.86106 .81527 L
.85774 .81858 L
.8572 .81912 L
.85387 .82244 L
.85334 .82297 L
.84999 .82631 L
.84947 .82682 L
.84611 .83017 L
.84611 .83403 L
.84561 .83452 L
.84223 .83789 L
.84175 .83837 L
.83835 .84175 L
.83789 .84221 L
.83446 .84561 L
.83403 .84605 L
.83017 .84603 L
.8267 .84947 L
.82631 .84987 L
.82281 .85334 L
.82244 .8537 L
.81892 .8572 L
Mistroke
.81858 .85753 L
.81502 .86106 L
.81472 .86136 L
.81113 .86492 L
.81086 .86519 L
.80723 .86878 L
.807 .86901 L
.80332 .87264 L
.80314 .87283 L
.79927 .87281 L
.79553 .87651 L
.79541 .87662 L
.79162 .88037 L
.79155 .88043 L
.7877 .88423 L
.78769 .88424 L
.78391 .88423 L
.78383 .88419 L
.78271 .88037 L
.77997 .87713 L
.77944 .87651 L
.77612 .87264 L
.7761 .87263 L
.77277 .86878 L
.77224 .86818 L
.76937 .86492 L
.76838 .8638 L
.76593 .86106 L
.76452 .85948 L
.76245 .8572 L
.76066 .85523 L
.75893 .85334 L
.7568 .85103 L
.75535 .84947 L
.75293 .8469 L
.75173 .84561 L
.74907 .84282 L
.74805 .84175 L
.74521 .83881 L
.74432 .83789 L
.74135 .83486 L
.74053 .83403 L
.73749 .83097 L
.73669 .83017 L
.73363 .82714 L
.73278 .82631 L
.72977 .82337 L
.7288 .82244 L
.7259 .81967 L
.72476 .81858 L
Mistroke
.72204 .81602 L
.72065 .81472 L
.71818 .81244 L
.71646 .81086 L
.71432 .80892 L
.71218 .807 L
.71046 .80546 L
.70783 .80314 L
.7066 .80206 L
.70338 .79927 L
.70273 .79872 L
.69887 .79544 L
.69883 .79541 L
.69501 .79223 L
.69419 .79155 L
.69115 .78908 L
.68943 .78769 L
.68729 .78598 L
.68455 .78383 L
.68343 .78295 L
.67956 .77998 L
.67954 .77997 L
.6757 .77707 L
.6744 .7761 L
.67184 .77423 L
.6691 .77224 L
.66798 .77144 L
.66412 .76872 L
.66364 .76838 L
.66026 .76605 L
.65799 .76452 L
.65639 .76345 L
.65253 .76091 L
.65215 .76066 L
.64867 .75843 L
.64607 .7568 L
.64481 .75601 L
.64095 .75366 L
.63975 .75293 L
.63709 .75136 L
.63323 .74913 L
.63313 .74907 L
.62936 .74695 L
.62619 .74521 L
.6255 .74484 L
.62164 .74279 L
.61885 .74135 L
.61778 .7408 L
.61392 .73888 L
.61106 .73749 L
Mistroke
.61006 .73701 L
.60619 .7352 L
.60271 .73363 L
.60233 .73346 L
.59847 .73178 L
.59461 .73016 L
.59365 .72977 L
.59075 .7286 L
.58689 .7271 L
.58368 .7259 L
.58302 .72566 L
.57916 .72429 L
.5753 .72297 L
.57245 .72204 L
.57144 .72172 L
.56758 .72053 L
.56372 .7194 L
.55985 .71833 L
.55931 .71818 L
.55599 .71732 L
.55213 .71637 L
.54827 .71549 L
.54441 .71466 L
.5427 .71432 L
.54055 .7139 L
.53669 .7132 L
.53282 .71256 L
.52896 .71198 L
.5251 .71146 L
.52124 .71101 L
.51738 .71061 L
.51569 .71046 L
.51352 .71028 L
.50965 .71 L
.50579 .70979 L
.50193 .70964 L
.49807 .70956 L
.49421 .70953 L
.49035 .70956 L
.48648 .70966 L
.48262 .70981 L
.47876 .71003 L
.4749 .71031 L
.47314 .71046 L
.47104 .71065 L
.46718 .71105 L
.46331 .71152 L
.45945 .71204 L
.45559 .71263 L
.45173 .71327 L
Mistroke
.44787 .71398 L
.44613 .71432 L
.44401 .71475 L
.44015 .71558 L
.43628 .71647 L
.43242 .71743 L
.42952 .71818 L
.42856 .71844 L
.4247 .71952 L
.42084 .72065 L
.41698 .72185 L
.41638 .72204 L
.41311 .72311 L
.40925 .72443 L
.40539 .72581 L
.40514 .7259 L
.40153 .72726 L
.39767 .72876 L
.39517 .72977 L
.39381 .73033 L
.38994 .73195 L
.38611 .73363 L
.38608 .73364 L
.38222 .73539 L
.37836 .7372 L
.37776 .73749 L
.3745 .73907 L
.37064 .74101 L
.36996 .74135 L
.36677 .743 L
.36291 .74506 L
.36263 .74521 L
.35905 .74717 L
.35568 .74907 L
.35519 .74935 L
.35133 .75159 L
.34906 .75293 L
.34747 .75389 L
.34361 .75625 L
.34273 .7568 L
.33974 .75868 L
.33666 .76066 L
.33588 .76116 L
.33202 .76371 L
.33081 .76452 L
.32816 .76631 L
.32516 .76838 L
.3243 .76898 L
.32044 .77171 L
.31969 .77224 L
Mistroke
.31657 .7745 L
.31439 .7761 L
.31271 .77735 L
.30925 .77997 L
.30885 .78027 L
.30499 .78324 L
.30424 .78383 L
.30113 .78628 L
.29936 .78769 L
.29727 .78937 L
.2946 .79155 L
.2934 .79253 L
.28995 .79541 L
.28954 .79575 L
.28568 .79903 L
.2854 .79927 L
.28182 .80237 L
.28095 .80314 L
.27796 .80578 L
.27659 .807 L
.2741 .80924 L
.27231 .81086 L
.27023 .81276 L
.26812 .81472 L
.26637 .81635 L
.264 .81858 L
.26251 .82 L
.25996 .82244 L
.25865 .82371 L
.25598 .82631 L
.25479 .82748 L
.25207 .83017 L
.25093 .83131 L
.24822 .83403 L
.24707 .8352 L
.24443 .83789 L
.2432 .83915 L
.2407 .84175 L
.23934 .84317 L
.23702 .84561 L
.23548 .84725 L
.23339 .84947 L
.23162 .85138 L
.22982 .85334 L
.22776 .85558 L
.22629 .8572 L
.2239 .85984 L
.2228 .86106 L
.22003 .86416 L
.21936 .86492 L
Mistroke
.21617 .86854 L
.21596 .86878 L
.21261 .87264 L
.21231 .87299 L
.20929 .87651 L
.20845 .88032 L
.20459 .87654 L
.20455 .87651 L
.20073 .87273 L
.19686 .87275 L
.19676 .87264 L
.193 .86893 L
.19285 .86878 L
.18914 .86511 L
.18895 .86492 L
.18528 .86128 L
.18505 .86106 L
.18142 .85746 L
.18116 .8572 L
.17756 .85363 L
.17727 .85334 L
.17369 .84979 L
.17338 .84947 L
.16983 .84596 L
.16597 .84597 L
.16561 .84561 L
.16211 .84213 L
.16173 .84175 L
.15825 .83829 L
.15784 .83789 L
.15439 .83445 L
.15396 .83403 L
.15396 .83017 L
.15053 .82675 L
.15008 .82631 L
.14666 .8229 L
.14621 .82244 L
.1428 .81905 L
.14233 .81858 L
.13894 .8152 L
.13846 .81472 L
.13508 .81134 L
.13459 .81086 L
.13122 .80749 L
.13073 .807 L
.12736 .80363 L
.12686 .80314 L
.12686 .79927 L
.12349 .79591 L
.123 .79541 L
Mistroke
.11963 .79205 L
.11914 .79155 L
.11577 .78818 L
.11528 .78769 L
.11528 .78383 L
.11191 .78045 L
.11143 .77997 L
.10805 .77658 L
.10757 .7761 L
.10419 .7727 L
.10372 .77224 L
.10373 .76838 L
.10032 .76496 L
.09988 .76452 L
.09646 .76108 L
.09604 .76066 L
.09605 .7568 L
.0926 .75333 L
.09221 .75293 L
.09221 .74907 L
.08874 .74557 L
.08838 .74521 L
.08488 .74168 L
.08455 .74135 L
.08456 .73749 L
.08102 .73392 L
.08073 .73363 L
.08074 .72977 L
.07715 .72614 L
.07692 .7259 L
.07693 .72204 L
.07329 .71836 L
.07312 .71818 L
.07313 .71432 L
.06943 .71056 L
.06932 .71046 L
.06934 .7066 L
.06557 .70276 L
.06554 .70273 L
.06556 .69887 L
.06557 .69797 L
.06717 .69501 L
.06926 .69115 L
.06943 .69084 L
.07137 .68729 L
.07329 .68377 L
.07348 .68343 L
.07561 .67956 L
.07715 .67677 L
.07775 .6757 L
Mistroke
.07989 .67184 L
.08102 .66983 L
.08205 .66798 L
.08422 .66412 L
.08488 .66295 L
.0864 .66026 L
.08859 .65639 L
.08874 .65614 L
.0908 .65253 L
.0926 .64939 L
.09301 .64867 L
.09524 .64481 L
.09646 .6427 L
.09748 .64095 L
.09973 .63709 L
.10032 .63608 L
.102 .63323 L
.10419 .62951 L
.10427 .62936 L
.10657 .6255 L
.10805 .62301 L
.10887 .62164 L
.11119 .61778 L
.11191 .61658 L
.11352 .61392 L
.11577 .6102 L
.11586 .61006 L
.11822 .60619 L
.11963 .60389 L
.12059 .60233 L
.12298 .59847 L
.12349 .59765 L
.12539 .59461 L
.12736 .59146 L
.1278 .59075 L
.13024 .58689 L
.13122 .58534 L
.13269 .58302 L
.13508 .57928 L
.13515 .57916 L
.13764 .5753 L
.13894 .57328 L
.14014 .57144 L
.14265 .56758 L
.1428 .56735 L
.14519 .56372 L
.14666 .56148 L
.14774 .55985 L
.15031 .55599 L
.15053 .55567 L
Mistroke
.1529 .55213 L
.15439 .54993 L
.15551 .54827 L
.15814 .54441 L
.15825 .54425 L
.16079 .54055 L
.16211 .53863 L
.16346 .53669 L
.16597 .53308 L
.16615 .53282 L
.16886 .52896 L
.16983 .52758 L
.17159 .5251 L
.17369 .52215 L
.17435 .52124 L
.17713 .51738 L
.17756 .51679 L
.17993 .51352 L
.18142 .51148 L
.18276 .50965 L
.18528 .50624 L
.18561 .50579 L
.18849 .50193 L
.18914 .50106 L
.1914 .49807 L
.193 .49595 L
.19433 .49421 L
.19686 .4909 L
.19729 .49035 L
.20028 .48648 L
.20073 .48591 L
.20329 .48262 L
.20459 .48098 L
.20634 .47876 L
.20845 .47612 L
.20942 .4749 L
.21231 .47132 L
.21254 .47104 L
.21568 .46718 L
.21617 .46658 L
.21886 .46331 L
.22003 .4619 L
.22208 .45945 L
.2239 .45729 L
.22533 .45559 L
.22776 .45274 L
.22862 .45173 L
.23162 .44826 L
.23195 .44787 L
.23533 .44401 L
Mistroke
.23548 .44383 L
.23874 .44015 L
.23934 .43947 L
.2422 .43628 L
.2432 .43517 L
.24571 .43242 L
.24707 .43094 L
.24926 .42856 L
.25093 .42677 L
.25286 .4247 L
.25479 .42266 L
.25652 .42084 L
.25865 .41861 L
.26023 .41698 L
.26251 .41463 L
.264 .41311 L
.26637 .41071 L
.26782 .40925 L
.27023 .40685 L
.27171 .40539 L
.2741 .40306 L
.27567 .40153 L
.27796 .39932 L
.27969 .39767 L
.28182 .39565 L
.28379 .39381 L
.28568 .39205 L
.28797 .38994 L
.28954 .38851 L
.29222 .38608 L
.2934 .38502 L
.29657 .38222 L
.29727 .38161 L
.301 .37836 L
.30113 .37825 L
.30499 .37496 L
.30554 .3745 L
.30885 .37173 L
.31018 .37064 L
.31271 .36856 L
.31493 .36677 L
.31657 .36546 L
.3198 .36291 L
.32044 .36242 L
.3243 .35944 L
.32481 .35905 L
.32816 .35653 L
.32996 .35519 L
.33202 .35368 L
.33526 .35133 L
Mistroke
.33588 .35089 L
.33974 .34816 L
.34074 .34747 L
.34361 .3455 L
.3464 .34361 L
.34747 .3429 L
.35133 .34036 L
.35228 .33974 L
.35519 .33788 L
.35839 .33588 L
.35905 .33547 L
.36291 .33312 L
.36476 .33202 L
.36677 .33083 L
.37064 .32861 L
.37143 .32816 L
.3745 .32645 L
.37836 .32435 L
.37846 .3243 L
.38222 .32232 L
.3859 .32044 L
.38608 .32034 L
.38994 .31843 L
.39381 .31659 L
.39383 .31657 L
.39767 .3148 L
.40153 .31308 L
.40238 .31271 L
.40539 .31142 L
.40925 .30983 L
.41169 .30885 L
.41311 .30829 L
.41698 .30682 L
.42084 .30542 L
.42205 .30499 L
.4247 .30407 L
.42856 .30279 L
.43242 .30157 L
.43388 .30113 L
.43628 .30042 L
.44015 .29932 L
.44401 .29829 L
.44787 .29733 L
.44811 .29727 L
.45173 .29642 L
.45559 .29558 L
.45945 .2948 L
.46331 .29408 L
.46718 .29343 L
.46733 .2934 L
Mistroke
.47104 .29284 L
Mfstroke
1 .702 .5 r
.46718 .32758 m
.47104 .32697 L
.4749 .32643 L
.47876 .32594 L
.48262 .32552 L
.48648 .32516 L
.49035 .32487 L
.49421 .32464 L
.49807 .32447 L
.50193 .32436 L
.50579 .32432 L
.50965 .32434 L
.51352 .32442 L
.51738 .32457 L
.52124 .32478 L
.5251 .32505 L
.52896 .32539 L
.53282 .32578 L
.53669 .32624 L
.54055 .32677 L
.54441 .32736 L
.54827 .328 L
.54914 .32816 L
.55213 .32872 L
.55599 .32949 L
.55985 .33033 L
.56372 .33123 L
.56689 .33202 L
.56758 .3322 L
.57144 .33322 L
.5753 .33431 L
.57916 .33547 L
.58051 .33588 L
.58302 .33668 L
.58689 .33796 L
.59075 .3393 L
.59198 .33974 L
.59461 .34071 L
.59847 .34217 L
.60209 .34361 L
.60233 .3437 L
.60619 .3453 L
.61006 .34695 L
.61122 .34747 L
.61392 .34867 L
.61778 .35046 L
.61962 .35133 L
.62164 .3523 L
.6255 .35421 L
.62744 .35519 L
.62936 .35618 L
.63323 .35821 L
.63479 .35905 L
.63709 .36031 L
.64095 .36247 L
.64173 .36291 L
.64481 .36469 L
.64834 .36677 L
.64867 .36698 L
.65253 .36932 L
.65465 .37064 L
.65639 .37173 L
.66026 .37421 L
.6607 .3745 L
.66412 .37675 L
.66653 .37836 L
.66798 .37935 L
.67184 .38201 L
.67215 .38222 L
.6757 .38473 L
.67758 .38608 L
.67956 .38752 L
.68285 .38994 L
.68343 .39037 L
.68729 .39329 L
.68797 .39381 L
.69115 .39626 L
.69294 .39767 L
.69501 .3993 L
.69779 .40153 L
.69887 .40241 L
.70251 .40539 L
.70273 .40557 L
.7066 .4088 L
.70713 .40925 L
.71046 .41209 L
.71164 .41311 L
.71432 .41545 L
.71606 .41698 L
.71818 .41886 L
.72038 .42084 L
.72204 .42234 L
.72462 .4247 L
.7259 .42589 L
.72877 .42856 L
.72977 .42949 L
.73285 .43242 L
.73363 .43316 L
.73686 .43628 L
.73749 .43689 L
.7408 .44015 L
.74135 .44069 L
.74468 .44401 L
.74521 .44454 L
.74849 .44787 L
.74907 .44846 L
.75224 .45173 L
.75293 .45245 L
.75594 .45559 L
.7568 .45649 L
.75958 .45945 L
.76066 .4606 L
.76318 .46331 L
.76452 .46477 L
.76672 .46718 L
.76838 .46901 L
.77021 .47104 L
.77224 .47331 L
.77366 .4749 L
.7761 .47767 L
.77707 .47876 L
.77997 .48209 L
.78043 .48262 L
.78375 .48648 L
.78383 .48658 L
.78703 .49035 L
.78769 .49112 L
.79028 .49421 L
.79155 .49574 L
.79348 .49807 L
.79541 .50041 L
.79666 .50193 L
.79927 .50515 L
.7998 .50579 L
.8029 .50965 L
.80314 .50995 L
.80597 .51352 L
.807 .51481 L
.80901 .51738 L
.81086 .51974 L
.81203 .52124 L
.81472 .52473 L
.81501 .5251 L
.81796 .52896 L
.81858 .52978 L
.82089 .53282 L
.82244 .53489 L
.82379 .53669 L
.82631 .54007 L
.82666 .54055 L
.8295 .54441 L
.83017 .54531 L
.83233 .54827 L
.83403 .55061 L
.83512 .55213 L
.83789 .55598 L
.8379 .55599 L
.84065 .55985 L
.84175 .56141 L
.84338 .56372 L
.84561 .5669 L
.84609 .56758 L
.84877 .57144 L
.84947 .57246 L
.85144 .5753 L
.85334 .57807 L
.85408 .57916 L
.8567 .58302 L
.8572 .58375 L
.85931 .58689 L
.86106 .5895 L
.86189 .59075 L
.86446 .59461 L
.86492 .5953 L
.86701 .59847 L
.86878 .60117 L
.86954 .60233 L
.87205 .60619 L
.87264 .6071 L
.87455 .61006 L
.87651 .6131 L
.87703 .61392 L
.87949 .61778 L
.88037 .61916 L
.88194 .62164 L
.88423 .62528 L
.88437 .6255 L
.88679 .62936 L
.88809 .63146 L
.88919 .63323 L
.89157 .63709 L
.89195 .63771 L
.89394 .64095 L
.89581 .64402 L
.8963 .64481 L
.89864 .64867 L
.89968 .65039 L
.90097 .65253 L
.90328 .65639 L
.90354 .65682 L
.90558 .66026 L
.9074 .66332 L
.90787 .66412 L
.91015 .66798 L
.91126 .66988 L
.91241 .67184 L
.91466 .6757 L
.91512 .6765 L
.91689 .67956 L
.91898 .68319 L
.91912 .68343 L
.92133 .68729 L
.92285 .68994 L
.92353 .69115 L
.92572 .69501 L
.92671 .69675 L
.9279 .69887 L
.93007 .70273 L
.93057 .70362 L
.93058 .7066 L
.9306 .71046 L
.93057 .71049 L
.92679 .71432 L
.92681 .71818 L
.92671 .71828 L
.92299 .72204 L
.92301 .7259 L
.92285 .72607 L
.91919 .72977 L
.9192 .73363 L
.91898 .73384 L
.91537 .73749 L
.91538 .74135 L
.91512 .74161 L
.91155 .74521 L
.91126 .7455 L
.90771 .74907 L
.90772 .75293 L
.9074 .75326 L
.90388 .7568 L
.90389 .76066 L
.90354 .76101 L
.90004 .76452 L
.89968 .76489 L
.89619 .76838 L
.8962 .77224 L
.89581 .77263 L
.89235 .7761 L
.89195 .7765 L
.8885 .77997 L
.88809 .78037 L
.88464 .78383 L
.88464 .78769 L
.88423 .7881 L
.88078 .79155 L
.88037 .79197 L
.87692 .79541 L
.87651 .79583 L
.87306 .79927 L
.87306 .80314 L
.87264 .80355 L
.86919 .807 L
.86878 .80741 L
.86533 .81086 L
.86492 .81126 L
.86146 .81472 L
.86106 .81512 L
.85758 .81858 L
.8572 .81897 L
.85371 .82244 L
.85334 .82282 L
.84983 .82631 L
.84947 .82666 L
.84595 .83017 L
.84595 .83403 L
.84561 .83436 L
.84207 .83789 L
.84175 .8382 L
.83818 .84175 L
.83789 .84204 L
.8343 .84561 L
.83403 .84588 L
.83017 .84587 L
.82653 .84947 L
.82631 .8497 L
.82264 .85334 L
.82244 .85353 L
.81874 .8572 L
.81858 .85736 L
.81485 .86106 L
.81472 .86118 L
.81094 .86492 L
.81086 .86501 L
.80704 .86878 L
.807 .86883 L
.80314 .87264 L
.80034 .86878 L
.79927 .86744 L
.79726 .86492 L
.79541 .86263 L
.79415 .86106 L
.79155 .85787 L
.791 .8572 L
.78782 .85334 L
.78769 .85318 L
.78461 .84947 L
.78383 .84855 L
.78136 .84561 L
.77997 .84398 L
.77807 .84175 L
.7761 .83947 L
.77474 .83789 L
.77224 .83502 L
.77138 .83403 L
.76838 .83063 L
.76797 .83017 L
.76452 .82631 L
.76452 .8263 L
.76103 .82244 L
.76066 .82204 L
.75749 .81858 L
.7568 .81784 L
.7539 .81472 L
.75293 .81369 L
.75026 .81086 L
.74907 .80961 L
.74657 .807 L
.74521 .80559 L
.74282 .80314 L
.74135 .80163 L
.73902 .79927 L
.73749 .79773 L
.73516 .79541 L
.73363 .7939 L
.73123 .79155 L
.72977 .79012 L
.72724 .78769 L
.7259 .78641 L
.72318 .78383 L
.72204 .78276 L
.71905 .77997 L
.71818 .77916 L
.71484 .7761 L
.71432 .77563 L
.71055 .77224 L
.71046 .77216 L
.7066 .76876 L
.70617 .76838 L
.70273 .76541 L
.7017 .76452 L
.69887 .76212 L
.69713 .76066 L
.69501 .7589 L
.69245 .7568 L
.69115 .75573 L
.68767 .75293 L
.68729 .75263 L
.68343 .74959 L
.68276 .74907 L
.67956 .74661 L
.67772 .74521 L
.6757 .74369 L
.67254 .74135 L
.67184 .74083 L
.66798 .73804 L
.66721 .73749 L
.66412 .7353 L
.66171 .73363 L
.66026 .73263 L
.65639 .73002 L
.65602 .72977 L
.65253 .72746 L
.65012 .7259 L
.64867 .72497 L
.64481 .72254 L
.644 .72204 L
.64095 .72018 L
.63761 .71818 L
.63709 .71787 L
.63323 .71562 L
.63093 .71432 L
.62936 .71344 L
.6255 .71132 L
.62391 .71046 L
.62164 .70925 L
.61778 .70725 L
.61649 .7066 L
.61392 .70531 L
.61006 .70343 L
.60859 .70273 L
.60619 .70162 L
.60233 .69986 L
.6001 .69887 L
.59847 .69816 L
.59461 .69653 L
.59088 .69501 L
.59075 .69496 L
.58689 .69344 L
.58302 .69199 L
.5807 .69115 L
.57916 .6906 L
.5753 .68928 L
.57144 .68801 L
.56916 .68729 L
.56758 .6868 L
.56372 .68566 L
.55985 .68457 L
.55599 .68355 L
.55551 .68343 L
.55213 .68259 L
.54827 .68169 L
.54441 .68085 L
.54055 .68007 L
.53786 .67956 L
.53669 .67935 L
.53282 .6787 L
.52896 .6781 L
.5251 .67757 L
.52124 .6771 L
.51738 .67669 L
.51352 .67634 L
.50965 .67605 L
.50579 .67582 L
.50335 .6757 L
.50193 .67565 L
.49807 .67555 L
.49421 .6755 L
.49035 .67552 L
.48648 .6756 L
.48327 .6757 L
.48262 .67573 L
.47876 .67593 L
.4749 .67619 L
.47104 .67652 L
.46718 .6769 L
.46331 .67734 L
.45945 .67785 L
.45559 .67842 L
.45173 .67904 L
.44878 .67956 L
.44787 .67973 L
.44401 .68048 L
.44015 .68129 L
.43628 .68217 L
.43242 .6831 L
.43112 .68343 L
.42856 .68409 L
.4247 .68515 L
.42084 .68626 L
.41747 .68729 L
.41698 .68744 L
.41311 .68868 L
.40925 .68998 L
.40592 .69115 L
.40539 .69134 L
.40153 .69276 L
.39767 .69424 L
.39573 .69501 L
.39381 .69579 L
.38994 .69739 L
.38651 .69887 L
.38608 .69906 L
.38222 .70079 L
.37836 .70257 L
.37802 .70273 L
.3745 .70442 L
.37064 .70633 L
.37012 .7066 L
.36677 .70831 L
.36291 .71034 L
.36269 .71046 L
.35905 .71243 L
.35566 .71432 L
.35519 .71459 L
.35133 .7168 L
.34898 .71818 L
.34747 .71908 L
.34361 .72142 L
.34259 .72204 L
.33974 .72381 L
.33646 .7259 L
.33588 .72627 L
.33202 .72879 L
.33056 .72977 L
.32816 .73138 L
.32486 .73363 L
.3243 .73402 L
.32044 .73672 L
.31936 .73749 L
.31657 .73949 L
.31402 .74135 L
.31271 .74231 L
.30885 .7452 L
.30884 .74521 L
.30499 .74815 L
.30379 .74907 L
.30113 .75116 L
.29888 .75293 L
.29727 .75423 L
.29409 .7568 L
.2934 .75736 L
.28954 .76055 L
.28941 .76066 L
.28568 .7638 L
.28484 .76452 L
.28182 .76712 L
.28036 .76838 L
.27796 .77049 L
.27598 .77224 L
.2741 .77393 L
.27168 .7761 L
.27023 .77742 L
.26747 .77997 L
.26637 .78098 L
.26333 .78383 L
.26251 .7846 L
.25927 .78769 L
.25865 .78828 L
.25527 .79155 L
.25479 .79202 L
.25134 .79541 L
.25093 .79582 L
.24747 .79927 L
.24707 .79968 L
.24367 .80314 L
.2432 .80361 L
.23992 .807 L
.23934 .80759 L
.23622 .81086 L
.23548 .81164 L
.23258 .81472 L
.23162 .81574 L
.22898 .81858 L
.22776 .81991 L
.22544 .82244 L
.2239 .82414 L
.22194 .82631 L
.22003 .82843 L
.21849 .83017 L
.21617 .83278 L
.21507 .83403 L
.21231 .83719 L
.2117 .83789 L
.20845 .84166 L
.20837 .84175 L
.20508 .84561 L
.20459 .8462 L
.20183 .84947 L
.20073 .85079 L
.19861 .85334 L
.19686 .85545 L
.19542 .8572 L
.193 .86016 L
.19227 .86106 L
.19289 .86492 L
.18914 .86492 L
.18914 .86492 L
.18528 .8611 L
.18524 .86106 L
.18142 .85728 L
.18134 .8572 L
.17756 .85345 L
.17744 .85334 L
.17369 .84962 L
.17355 .84947 L
.16983 .84579 L
.16597 .8458 L
.16578 .84561 L
.16211 .84196 L
.1619 .84175 L
.15825 .83812 L
.15801 .83789 L
.15439 .83428 L
.15413 .83403 L
.15412 .83017 L
.15053 .82658 L
.15025 .82631 L
.14666 .82274 L
.14637 .82244 L
.1428 .81889 L
.1425 .81858 L
.13894 .81504 L
.13862 .81472 L
.13508 .81118 L
.13475 .81086 L
.13122 .80733 L
.13089 .807 L
.12736 .80347 L
.12702 .80314 L
.12702 .79927 L
.12349 .79575 L
.12316 .79541 L
.11963 .79188 L
.1193 .79155 L
.11577 .78802 L
.11544 .78769 L
.11544 .78383 L
.11191 .78029 L
.11159 .77997 L
.10805 .77642 L
.10774 .7761 L
.10419 .77254 L
.10389 .77224 L
.10389 .76838 L
.10032 .7648 L
.10005 .76452 L
.09646 .76092 L
.09621 .76066 L
.09621 .7568 L
.0926 .75316 L
.09237 .75293 L
.09238 .74907 L
.08874 .7454 L
.08855 .74521 L
.08488 .74151 L
.08472 .74135 L
.08473 .73749 L
.08102 .73374 L
.08091 .73363 L
.08092 .72977 L
.07715 .72596 L
.0771 .7259 L
.07712 .72204 L
.07333 .71818 L
.07337 .71432 L
.07715 .71385 L
.07903 .71046 L
.08102 .70687 L
.08117 .7066 L
.08332 .70273 L
.08488 .69995 L
.08548 .69887 L
.08766 .69501 L
.08874 .6931 L
.08984 .69115 L
.09204 .68729 L
.0926 .68631 L
.09425 .68343 L
.09646 .67958 L
.09647 .67956 L
.0987 .6757 L
.10032 .67291 L
.10095 .67184 L
.10321 .66798 L
.10419 .66631 L
.10548 .66412 L
.10776 .66026 L
.10805 .65977 L
.11006 .65639 L
.11191 .6533 L
.11237 .65253 L
.11469 .64867 L
.11577 .64688 L
.11703 .64481 L
.11938 .64095 L
.11963 .64053 L
.12175 .63709 L
.12349 .63425 L
.12413 .63323 L
.12652 .62936 L
.12736 .62803 L
.12893 .6255 L
.13122 .62187 L
.13136 .62164 L
.1338 .61778 L
.13508 .61577 L
.13626 .61392 L
.13873 .61006 L
.13894 .60974 L
.14123 .60619 L
.1428 .60377 L
.14374 .60233 L
.14626 .59847 L
.14666 .59786 L
.14881 .59461 L
.15053 .59202 L
.15137 .59075 L
.15395 .58689 L
.15439 .58624 L
.15655 .58302 L
.15825 .58052 L
.15917 .57916 L
.16181 .5753 L
.16211 .57486 L
.16447 .57144 L
.16597 .56927 L
.16715 .56758 L
.16983 .56375 L
.16985 .56372 L
.17258 .55985 L
.17369 .55828 L
.17533 .55599 L
.17756 .55288 L
.1781 .55213 L
.18089 .54827 L
.18142 .54754 L
.18371 .54441 L
.18528 .54227 L
.18655 .54055 L
.18914 .53706 L
.18942 .53669 L
.19231 .53282 L
.193 .53191 L
.19523 .52896 L
.19686 .52682 L
.19818 .5251 L
.20073 .5218 L
.20116 .52124 L
.20417 .51738 L
.20459 .51684 L
.2072 .51352 L
.20845 .51194 L
.21027 .50965 L
.21231 .50711 L
.21337 .50579 L
.21617 .50234 L
.21651 .50193 L
.21968 .49807 L
.22003 .49763 L
.22288 .49421 L
.2239 .49299 L
.22612 .49035 L
.22776 .48841 L
.2294 .48648 L
.23162 .48389 L
.23271 .48262 L
.23548 .47944 L
.23607 .47876 L
.23934 .47505 L
.23947 .4749 L
.24292 .47104 L
.2432 .47072 L
.24641 .46718 L
.24707 .46646 L
.24995 .46331 L
.25093 .46225 L
.25353 .45945 L
.25479 .45812 L
.25717 .45559 L
.25865 .45404 L
.26087 .45173 L
.26251 .45003 L
.26461 .44787 L
.26637 .44608 L
.26842 .44401 L
.27023 .44219 L
.27229 .44015 L
.2741 .43837 L
.27623 .43628 L
.27796 .43461 L
.28023 .43242 L
.28182 .43091 L
.28431 .42856 L
.28568 .42728 L
.28846 .4247 L
.28954 .42371 L
.2927 .42084 L
.2934 .4202 L
.29702 .41698 L
.29727 .41675 L
.30113 .41337 L
.30143 .41311 L
.30499 .41005 L
.30593 .40925 L
.30885 .4068 L
.31054 .40539 L
.31271 .40361 L
.31527 .40153 L
.31657 .40048 L
.32011 .39767 L
.32044 .39741 L
.3243 .39441 L
.32508 .39381 L
.32816 .39147 L
.33019 .38994 L
.33202 .38859 L
.33546 .38608 L
.33588 .38578 L
.33974 .38302 L
.34089 .38222 L
.34361 .38034 L
.3465 .37836 L
.34747 .37771 L
.35133 .37515 L
.35232 .3745 L
.35519 .37265 L
.35837 .37064 L
.35905 .37021 L
.36291 .36784 L
.36468 .36677 L
.36677 .36553 L
.37064 .36328 L
.37128 .36291 L
.3745 .3611 L
.37822 .35905 L
.37836 .35898 L
.38222 .35692 L
.38556 .35519 L
.38608 .35493 L
.38994 .35299 L
.39338 .35133 L
.39381 .35112 L
.39767 .34932 L
.40153 .34758 L
.40177 .34747 L
.40539 .3459 L
.40925 .34428 L
.41091 .34361 L
.41311 .34272 L
.41698 .34123 L
.42084 .33981 L
.42101 .33974 L
.4247 .33844 L
.42856 .33714 L
.43242 .3359 L
.43248 .33588 L
.43628 .33472 L
.44015 .33361 L
.44401 .33256 L
.44609 .33202 L
.44787 .33157 L
.45173 .33065 L
.45559 .32979 L
.45945 .32899 L
.46331 .32825 L
.46384 .32816 L
F
0 g
.46718 .32758 m
.47104 .32697 L
.4749 .32643 L
.47876 .32594 L
.48262 .32552 L
.48648 .32516 L
.49035 .32487 L
.49421 .32464 L
.49807 .32447 L
.50193 .32436 L
.50579 .32432 L
.50965 .32434 L
.51352 .32442 L
.51738 .32457 L
.52124 .32478 L
.5251 .32505 L
.52896 .32539 L
.53282 .32578 L
.53669 .32624 L
.54055 .32677 L
.54441 .32736 L
.54827 .328 L
.54914 .32816 L
.55213 .32872 L
.55599 .32949 L
.55985 .33033 L
.56372 .33123 L
.56689 .33202 L
.56758 .3322 L
.57144 .33322 L
.5753 .33431 L
.57916 .33547 L
.58051 .33588 L
.58302 .33668 L
.58689 .33796 L
.59075 .3393 L
.59198 .33974 L
.59461 .34071 L
.59847 .34217 L
.60209 .34361 L
.60233 .3437 L
.60619 .3453 L
.61006 .34695 L
.61122 .34747 L
.61392 .34867 L
.61778 .35046 L
.61962 .35133 L
.62164 .3523 L
.6255 .35421 L
.62744 .35519 L
Mistroke
.62936 .35618 L
.63323 .35821 L
.63479 .35905 L
.63709 .36031 L
.64095 .36247 L
.64173 .36291 L
.64481 .36469 L
.64834 .36677 L
.64867 .36698 L
.65253 .36932 L
.65465 .37064 L
.65639 .37173 L
.66026 .37421 L
.6607 .3745 L
.66412 .37675 L
.66653 .37836 L
.66798 .37935 L
.67184 .38201 L
.67215 .38222 L
.6757 .38473 L
.67758 .38608 L
.67956 .38752 L
.68285 .38994 L
.68343 .39037 L
.68729 .39329 L
.68797 .39381 L
.69115 .39626 L
.69294 .39767 L
.69501 .3993 L
.69779 .40153 L
.69887 .40241 L
.70251 .40539 L
.70273 .40557 L
.7066 .4088 L
.70713 .40925 L
.71046 .41209 L
.71164 .41311 L
.71432 .41545 L
.71606 .41698 L
.71818 .41886 L
.72038 .42084 L
.72204 .42234 L
.72462 .4247 L
.7259 .42589 L
.72877 .42856 L
.72977 .42949 L
.73285 .43242 L
.73363 .43316 L
.73686 .43628 L
.73749 .43689 L
Mistroke
.7408 .44015 L
.74135 .44069 L
.74468 .44401 L
.74521 .44454 L
.74849 .44787 L
.74907 .44846 L
.75224 .45173 L
.75293 .45245 L
.75594 .45559 L
.7568 .45649 L
.75958 .45945 L
.76066 .4606 L
.76318 .46331 L
.76452 .46477 L
.76672 .46718 L
.76838 .46901 L
.77021 .47104 L
.77224 .47331 L
.77366 .4749 L
.7761 .47767 L
.77707 .47876 L
.77997 .48209 L
.78043 .48262 L
.78375 .48648 L
.78383 .48658 L
.78703 .49035 L
.78769 .49112 L
.79028 .49421 L
.79155 .49574 L
.79348 .49807 L
.79541 .50041 L
.79666 .50193 L
.79927 .50515 L
.7998 .50579 L
.8029 .50965 L
.80314 .50995 L
.80597 .51352 L
.807 .51481 L
.80901 .51738 L
.81086 .51974 L
.81203 .52124 L
.81472 .52473 L
.81501 .5251 L
.81796 .52896 L
.81858 .52978 L
.82089 .53282 L
.82244 .53489 L
.82379 .53669 L
.82631 .54007 L
.82666 .54055 L
Mistroke
.8295 .54441 L
.83017 .54531 L
.83233 .54827 L
.83403 .55061 L
.83512 .55213 L
.83789 .55598 L
.8379 .55599 L
.84065 .55985 L
.84175 .56141 L
.84338 .56372 L
.84561 .5669 L
.84609 .56758 L
.84877 .57144 L
.84947 .57246 L
.85144 .5753 L
.85334 .57807 L
.85408 .57916 L
.8567 .58302 L
.8572 .58375 L
.85931 .58689 L
.86106 .5895 L
.86189 .59075 L
.86446 .59461 L
.86492 .5953 L
.86701 .59847 L
.86878 .60117 L
.86954 .60233 L
.87205 .60619 L
.87264 .6071 L
.87455 .61006 L
.87651 .6131 L
.87703 .61392 L
.87949 .61778 L
.88037 .61916 L
.88194 .62164 L
.88423 .62528 L
.88437 .6255 L
.88679 .62936 L
.88809 .63146 L
.88919 .63323 L
.89157 .63709 L
.89195 .63771 L
.89394 .64095 L
.89581 .64402 L
.8963 .64481 L
.89864 .64867 L
.89968 .65039 L
.90097 .65253 L
.90328 .65639 L
.90354 .65682 L
Mistroke
.90558 .66026 L
.9074 .66332 L
.90787 .66412 L
.91015 .66798 L
.91126 .66988 L
.91241 .67184 L
.91466 .6757 L
.91512 .6765 L
.91689 .67956 L
.91898 .68319 L
.91912 .68343 L
.92133 .68729 L
.92285 .68994 L
.92353 .69115 L
.92572 .69501 L
.92671 .69675 L
.9279 .69887 L
.93007 .70273 L
.93057 .70362 L
.93058 .7066 L
.9306 .71046 L
.93057 .71049 L
.92679 .71432 L
.92681 .71818 L
.92671 .71828 L
.92299 .72204 L
.92301 .7259 L
.92285 .72607 L
.91919 .72977 L
.9192 .73363 L
.91898 .73384 L
.91537 .73749 L
.91538 .74135 L
.91512 .74161 L
.91155 .74521 L
.91126 .7455 L
.90771 .74907 L
.90772 .75293 L
.9074 .75326 L
.90388 .7568 L
.90389 .76066 L
.90354 .76101 L
.90004 .76452 L
.89968 .76489 L
.89619 .76838 L
.8962 .77224 L
.89581 .77263 L
.89235 .7761 L
.89195 .7765 L
.8885 .77997 L
Mistroke
.88809 .78037 L
.88464 .78383 L
.88464 .78769 L
.88423 .7881 L
.88078 .79155 L
.88037 .79197 L
.87692 .79541 L
.87651 .79583 L
.87306 .79927 L
.87306 .80314 L
.87264 .80355 L
.86919 .807 L
.86878 .80741 L
.86533 .81086 L
.86492 .81126 L
.86146 .81472 L
.86106 .81512 L
.85758 .81858 L
.8572 .81897 L
.85371 .82244 L
.85334 .82282 L
.84983 .82631 L
.84947 .82666 L
.84595 .83017 L
.84595 .83403 L
.84561 .83436 L
.84207 .83789 L
.84175 .8382 L
.83818 .84175 L
.83789 .84204 L
.8343 .84561 L
.83403 .84588 L
.83017 .84587 L
.82653 .84947 L
.82631 .8497 L
.82264 .85334 L
.82244 .85353 L
.81874 .8572 L
.81858 .85736 L
.81485 .86106 L
.81472 .86118 L
.81094 .86492 L
.81086 .86501 L
.80704 .86878 L
.807 .86883 L
.80314 .87264 L
.80034 .86878 L
.79927 .86744 L
.79726 .86492 L
.79541 .86263 L
Mistroke
.79415 .86106 L
.79155 .85787 L
.791 .8572 L
.78782 .85334 L
.78769 .85318 L
.78461 .84947 L
.78383 .84855 L
.78136 .84561 L
.77997 .84398 L
.77807 .84175 L
.7761 .83947 L
.77474 .83789 L
.77224 .83502 L
.77138 .83403 L
.76838 .83063 L
.76797 .83017 L
.76452 .82631 L
.76452 .8263 L
.76103 .82244 L
.76066 .82204 L
.75749 .81858 L
.7568 .81784 L
.7539 .81472 L
.75293 .81369 L
.75026 .81086 L
.74907 .80961 L
.74657 .807 L
.74521 .80559 L
.74282 .80314 L
.74135 .80163 L
.73902 .79927 L
.73749 .79773 L
.73516 .79541 L
.73363 .7939 L
.73123 .79155 L
.72977 .79012 L
.72724 .78769 L
.7259 .78641 L
.72318 .78383 L
.72204 .78276 L
.71905 .77997 L
.71818 .77916 L
.71484 .7761 L
.71432 .77563 L
.71055 .77224 L
.71046 .77216 L
.7066 .76876 L
.70617 .76838 L
.70273 .76541 L
.7017 .76452 L
Mistroke
.69887 .76212 L
.69713 .76066 L
.69501 .7589 L
.69245 .7568 L
.69115 .75573 L
.68767 .75293 L
.68729 .75263 L
.68343 .74959 L
.68276 .74907 L
.67956 .74661 L
.67772 .74521 L
.6757 .74369 L
.67254 .74135 L
.67184 .74083 L
.66798 .73804 L
.66721 .73749 L
.66412 .7353 L
.66171 .73363 L
.66026 .73263 L
.65639 .73002 L
.65602 .72977 L
.65253 .72746 L
.65012 .7259 L
.64867 .72497 L
.64481 .72254 L
.644 .72204 L
.64095 .72018 L
.63761 .71818 L
.63709 .71787 L
.63323 .71562 L
.63093 .71432 L
.62936 .71344 L
.6255 .71132 L
.62391 .71046 L
.62164 .70925 L
.61778 .70725 L
.61649 .7066 L
.61392 .70531 L
.61006 .70343 L
.60859 .70273 L
.60619 .70162 L
.60233 .69986 L
.6001 .69887 L
.59847 .69816 L
.59461 .69653 L
.59088 .69501 L
.59075 .69496 L
.58689 .69344 L
.58302 .69199 L
.5807 .69115 L
Mistroke
.57916 .6906 L
.5753 .68928 L
.57144 .68801 L
.56916 .68729 L
.56758 .6868 L
.56372 .68566 L
.55985 .68457 L
.55599 .68355 L
.55551 .68343 L
.55213 .68259 L
.54827 .68169 L
.54441 .68085 L
.54055 .68007 L
.53786 .67956 L
.53669 .67935 L
.53282 .6787 L
.52896 .6781 L
.5251 .67757 L
.52124 .6771 L
.51738 .67669 L
.51352 .67634 L
.50965 .67605 L
.50579 .67582 L
.50335 .6757 L
.50193 .67565 L
.49807 .67555 L
.49421 .6755 L
.49035 .67552 L
.48648 .6756 L
.48327 .6757 L
.48262 .67573 L
.47876 .67593 L
.4749 .67619 L
.47104 .67652 L
.46718 .6769 L
.46331 .67734 L
.45945 .67785 L
.45559 .67842 L
.45173 .67904 L
.44878 .67956 L
.44787 .67973 L
.44401 .68048 L
.44015 .68129 L
.43628 .68217 L
.43242 .6831 L
.43112 .68343 L
.42856 .68409 L
.4247 .68515 L
.42084 .68626 L
.41747 .68729 L
Mistroke
.41698 .68744 L
.41311 .68868 L
.40925 .68998 L
.40592 .69115 L
.40539 .69134 L
.40153 .69276 L
.39767 .69424 L
.39573 .69501 L
.39381 .69579 L
.38994 .69739 L
.38651 .69887 L
.38608 .69906 L
.38222 .70079 L
.37836 .70257 L
.37802 .70273 L
.3745 .70442 L
.37064 .70633 L
.37012 .7066 L
.36677 .70831 L
.36291 .71034 L
.36269 .71046 L
.35905 .71243 L
.35566 .71432 L
.35519 .71459 L
.35133 .7168 L
.34898 .71818 L
.34747 .71908 L
.34361 .72142 L
.34259 .72204 L
.33974 .72381 L
.33646 .7259 L
.33588 .72627 L
.33202 .72879 L
.33056 .72977 L
.32816 .73138 L
.32486 .73363 L
.3243 .73402 L
.32044 .73672 L
.31936 .73749 L
.31657 .73949 L
.31402 .74135 L
.31271 .74231 L
.30885 .7452 L
.30884 .74521 L
.30499 .74815 L
.30379 .74907 L
.30113 .75116 L
.29888 .75293 L
.29727 .75423 L
.29409 .7568 L
Mistroke
.2934 .75736 L
.28954 .76055 L
.28941 .76066 L
.28568 .7638 L
.28484 .76452 L
.28182 .76712 L
.28036 .76838 L
.27796 .77049 L
.27598 .77224 L
.2741 .77393 L
.27168 .7761 L
.27023 .77742 L
.26747 .77997 L
.26637 .78098 L
.26333 .78383 L
.26251 .7846 L
.25927 .78769 L
.25865 .78828 L
.25527 .79155 L
.25479 .79202 L
.25134 .79541 L
.25093 .79582 L
.24747 .79927 L
.24707 .79968 L
.24367 .80314 L
.2432 .80361 L
.23992 .807 L
.23934 .80759 L
.23622 .81086 L
.23548 .81164 L
.23258 .81472 L
.23162 .81574 L
.22898 .81858 L
.22776 .81991 L
.22544 .82244 L
.2239 .82414 L
.22194 .82631 L
.22003 .82843 L
.21849 .83017 L
.21617 .83278 L
.21507 .83403 L
.21231 .83719 L
.2117 .83789 L
.20845 .84166 L
.20837 .84175 L
.20508 .84561 L
.20459 .8462 L
.20183 .84947 L
.20073 .85079 L
.19861 .85334 L
Mistroke
.19686 .85545 L
.19542 .8572 L
.193 .86016 L
.19227 .86106 L
.19289 .86492 L
.18914 .86492 L
.18914 .86492 L
.18528 .8611 L
.18524 .86106 L
.18142 .85728 L
.18134 .8572 L
.17756 .85345 L
.17744 .85334 L
.17369 .84962 L
.17355 .84947 L
.16983 .84579 L
.16597 .8458 L
.16578 .84561 L
.16211 .84196 L
.1619 .84175 L
.15825 .83812 L
.15801 .83789 L
.15439 .83428 L
.15413 .83403 L
.15412 .83017 L
.15053 .82658 L
.15025 .82631 L
.14666 .82274 L
.14637 .82244 L
.1428 .81889 L
.1425 .81858 L
.13894 .81504 L
.13862 .81472 L
.13508 .81118 L
.13475 .81086 L
.13122 .80733 L
.13089 .807 L
.12736 .80347 L
.12702 .80314 L
.12702 .79927 L
.12349 .79575 L
.12316 .79541 L
.11963 .79188 L
.1193 .79155 L
.11577 .78802 L
.11544 .78769 L
.11544 .78383 L
.11191 .78029 L
.11159 .77997 L
.10805 .77642 L
Mistroke
.10774 .7761 L
.10419 .77254 L
.10389 .77224 L
.10389 .76838 L
.10032 .7648 L
.10005 .76452 L
.09646 .76092 L
.09621 .76066 L
.09621 .7568 L
.0926 .75316 L
.09237 .75293 L
.09238 .74907 L
.08874 .7454 L
.08855 .74521 L
.08488 .74151 L
.08472 .74135 L
.08473 .73749 L
.08102 .73374 L
.08091 .73363 L
.08092 .72977 L
.07715 .72596 L
.0771 .7259 L
.07712 .72204 L
.07333 .71818 L
.07337 .71432 L
.07715 .71385 L
.07903 .71046 L
.08102 .70687 L
.08117 .7066 L
.08332 .70273 L
.08488 .69995 L
.08548 .69887 L
.08766 .69501 L
.08874 .6931 L
.08984 .69115 L
.09204 .68729 L
.0926 .68631 L
.09425 .68343 L
.09646 .67958 L
.09647 .67956 L
.0987 .6757 L
.10032 .67291 L
.10095 .67184 L
.10321 .66798 L
.10419 .66631 L
.10548 .66412 L
.10776 .66026 L
.10805 .65977 L
.11006 .65639 L
.11191 .6533 L
Mistroke
.11237 .65253 L
.11469 .64867 L
.11577 .64688 L
.11703 .64481 L
.11938 .64095 L
.11963 .64053 L
.12175 .63709 L
.12349 .63425 L
.12413 .63323 L
.12652 .62936 L
.12736 .62803 L
.12893 .6255 L
.13122 .62187 L
.13136 .62164 L
.1338 .61778 L
.13508 .61577 L
.13626 .61392 L
.13873 .61006 L
.13894 .60974 L
.14123 .60619 L
.1428 .60377 L
.14374 .60233 L
.14626 .59847 L
.14666 .59786 L
.14881 .59461 L
.15053 .59202 L
.15137 .59075 L
.15395 .58689 L
.15439 .58624 L
.15655 .58302 L
.15825 .58052 L
.15917 .57916 L
.16181 .5753 L
.16211 .57486 L
.16447 .57144 L
.16597 .56927 L
.16715 .56758 L
.16983 .56375 L
.16985 .56372 L
.17258 .55985 L
.17369 .55828 L
.17533 .55599 L
.17756 .55288 L
.1781 .55213 L
.18089 .54827 L
.18142 .54754 L
.18371 .54441 L
.18528 .54227 L
.18655 .54055 L
.18914 .53706 L
Mistroke
.18942 .53669 L
.19231 .53282 L
.193 .53191 L
.19523 .52896 L
.19686 .52682 L
.19818 .5251 L
.20073 .5218 L
.20116 .52124 L
.20417 .51738 L
.20459 .51684 L
.2072 .51352 L
.20845 .51194 L
.21027 .50965 L
.21231 .50711 L
.21337 .50579 L
.21617 .50234 L
.21651 .50193 L
.21968 .49807 L
.22003 .49763 L
.22288 .49421 L
.2239 .49299 L
.22612 .49035 L
.22776 .48841 L
.2294 .48648 L
.23162 .48389 L
.23271 .48262 L
.23548 .47944 L
.23607 .47876 L
.23934 .47505 L
.23947 .4749 L
.24292 .47104 L
.2432 .47072 L
.24641 .46718 L
.24707 .46646 L
.24995 .46331 L
.25093 .46225 L
.25353 .45945 L
.25479 .45812 L
.25717 .45559 L
.25865 .45404 L
.26087 .45173 L
.26251 .45003 L
.26461 .44787 L
.26637 .44608 L
.26842 .44401 L
.27023 .44219 L
.27229 .44015 L
.2741 .43837 L
.27623 .43628 L
.27796 .43461 L
Mistroke
.28023 .43242 L
.28182 .43091 L
.28431 .42856 L
.28568 .42728 L
.28846 .4247 L
.28954 .42371 L
.2927 .42084 L
.2934 .4202 L
.29702 .41698 L
.29727 .41675 L
.30113 .41337 L
.30143 .41311 L
.30499 .41005 L
.30593 .40925 L
.30885 .4068 L
.31054 .40539 L
.31271 .40361 L
.31527 .40153 L
.31657 .40048 L
.32011 .39767 L
.32044 .39741 L
.3243 .39441 L
.32508 .39381 L
.32816 .39147 L
.33019 .38994 L
.33202 .38859 L
.33546 .38608 L
.33588 .38578 L
.33974 .38302 L
.34089 .38222 L
.34361 .38034 L
.3465 .37836 L
.34747 .37771 L
.35133 .37515 L
.35232 .3745 L
.35519 .37265 L
.35837 .37064 L
.35905 .37021 L
.36291 .36784 L
.36468 .36677 L
.36677 .36553 L
.37064 .36328 L
.37128 .36291 L
.3745 .3611 L
.37822 .35905 L
.37836 .35898 L
.38222 .35692 L
.38556 .35519 L
.38608 .35493 L
.38994 .35299 L
Mistroke
.39338 .35133 L
.39381 .35112 L
.39767 .34932 L
.40153 .34758 L
.40177 .34747 L
.40539 .3459 L
.40925 .34428 L
.41091 .34361 L
.41311 .34272 L
.41698 .34123 L
.42084 .33981 L
.42101 .33974 L
.4247 .33844 L
.42856 .33714 L
.43242 .3359 L
.43248 .33588 L
.43628 .33472 L
.44015 .33361 L
.44401 .33256 L
.44609 .33202 L
.44787 .33157 L
.45173 .33065 L
.45559 .32979 L
.45945 .32899 L
.46331 .32825 L
.46384 .32816 L
.46718 .32758 L
Mfstroke
1 .652 .5 r
.48262 .35477 m
.48648 .35439 L
.49035 .35407 L
.49421 .35382 L
.49807 .35363 L
.50193 .3535 L
.50579 .35344 L
.50965 .35344 L
.51352 .3535 L
.51738 .35363 L
.52124 .35382 L
.5251 .35407 L
.52896 .35438 L
.53282 .35476 L
.53657 .35519 L
.53669 .3552 L
.54055 .35571 L
.54441 .35628 L
.54827 .35691 L
.55213 .3576 L
.55599 .35836 L
.55927 .35905 L
.55985 .35918 L
.56372 .36006 L
.56758 .36101 L
.57144 .36202 L
.57467 .36291 L
.5753 .36309 L
.57916 .36423 L
.58302 .36543 L
.58689 .36669 L
.58714 .36677 L
.59075 .36801 L
.59461 .3694 L
.5979 .37064 L
.59847 .37085 L
.60233 .37237 L
.60619 .37395 L
.60751 .3745 L
.61006 .37559 L
.61392 .37729 L
.61627 .37836 L
.61778 .37906 L
.62164 .38089 L
.62437 .38222 L
.6255 .38278 L
.62936 .38474 L
.63195 .38608 L
.63323 .38676 L
.63709 .38884 L
.63909 .38994 L
.64095 .39098 L
.64481 .39319 L
.64586 .39381 L
.64867 .39546 L
.65232 .39767 L
.65253 .3978 L
.65639 .4002 L
.6585 .40153 L
.66026 .40266 L
.66412 .40518 L
.66443 .40539 L
.66798 .40777 L
.67015 .40925 L
.67184 .41042 L
.67568 .41311 L
.6757 .41313 L
.67956 .41591 L
.68103 .41698 L
.68343 .41875 L
.68622 .42084 L
.68729 .42165 L
.69115 .42461 L
.69126 .4247 L
.69501 .42764 L
.69617 .42856 L
.69887 .43073 L
.70095 .43242 L
.70273 .43389 L
.70562 .43628 L
.7066 .43711 L
.71018 .44015 L
.71046 .44039 L
.71432 .44373 L
.71464 .44401 L
.71818 .44714 L
.719 .44787 L
.72204 .45061 L
.72328 .45173 L
.7259 .45414 L
.72747 .45559 L
.72977 .45773 L
.73159 .45945 L
.73363 .46139 L
.73563 .46331 L
.73749 .46511 L
.7396 .46718 L
.74135 .4689 L
.7435 .47104 L
.74521 .47275 L
.74734 .4749 L
.74907 .47666 L
.75112 .47876 L
.75293 .48063 L
.75485 .48262 L
.7568 .48467 L
.75851 .48648 L
.76066 .48877 L
.76213 .49035 L
.76452 .49293 L
.76569 .49421 L
.76838 .49716 L
.76921 .49807 L
.77224 .50145 L
.77267 .50193 L
.7761 .50579 L
.7761 .5058 L
.77948 .50965 L
.77997 .51022 L
.78282 .51352 L
.78383 .51469 L
.78612 .51738 L
.78769 .51923 L
.78938 .52124 L
.79155 .52384 L
.7926 .5251 L
.79541 .52851 L
.79579 .52896 L
.79894 .53282 L
.79927 .53324 L
.80206 .53669 L
.80314 .53803 L
.80514 .54055 L
.807 .54289 L
.8082 .54441 L
.81086 .54781 L
.81122 .54827 L
.81421 .55213 L
.81472 .55279 L
.81718 .55599 L
.81858 .55783 L
.82012 .55985 L
.82244 .56294 L
.82303 .56372 L
.82591 .56758 L
.82631 .56811 L
.82876 .57144 L
.83017 .57335 L
.8316 .5753 L
.83403 .57865 L
.8344 .57916 L
.83719 .58302 L
.83789 .58401 L
.83995 .58689 L
.84175 .58943 L
.84268 .59075 L
.8454 .59461 L
.84561 .59492 L
.84809 .59847 L
.84947 .60047 L
.85076 .60233 L
.85334 .60608 L
.85342 .60619 L
.85605 .61006 L
.8572 .61175 L
.85866 .61392 L
.86106 .61749 L
.86125 .61778 L
.86383 .62164 L
.86492 .62329 L
.86638 .6255 L
.86878 .62916 L
.86892 .62936 L
.87144 .63323 L
.87264 .63509 L
.87394 .63709 L
.87642 .64095 L
.87651 .64108 L
.87889 .64481 L
.88037 .64713 L
.88134 .64867 L
.88378 .65253 L
.88423 .65325 L
.8862 .65639 L
.88809 .65943 L
.88861 .66026 L
.891 .66412 L
.89195 .66567 L
.89337 .66798 L
.89573 .67184 L
.89581 .67197 L
.89808 .6757 L
.89968 .67834 L
.90041 .67956 L
.90273 .68343 L
.90354 .68477 L
.90504 .68729 L
.90733 .69115 L
.9074 .69127 L
.90961 .69501 L
.91126 .69783 L
.91187 .69887 L
.91413 .70273 L
.91512 .70445 L
.91637 .7066 L
.9186 .71046 L
.91898 .71113 L
.92081 .71432 L
.92285 .71788 L
.92663 .71818 L
.92286 .72204 L
.92288 .7259 L
.92285 .72594 L
.91906 .72977 L
.91907 .73363 L
.91898 .73372 L
.91525 .73749 L
.91526 .74135 L
.91512 .74149 L
.91143 .74521 L
.91126 .74538 L
.90759 .74907 L
.9076 .75293 L
.9074 .75314 L
.90376 .7568 L
.90377 .76066 L
.90354 .76089 L
.89992 .76452 L
.89968 .76477 L
.89608 .76838 L
.89608 .77224 L
.89581 .77251 L
.89223 .7761 L
.89195 .77639 L
.88838 .77997 L
.88809 .78026 L
.88453 .78383 L
.88453 .78769 L
.88423 .78799 L
.88067 .79155 L
.88037 .79185 L
.87681 .79541 L
.87651 .79572 L
.87295 .79927 L
.87294 .80314 L
.87264 .80344 L
.86908 .807 L
.86878 .80729 L
.86521 .81086 L
.86492 .81115 L
.86134 .81472 L
.86106 .815 L
.85747 .81858 L
.8572 .81885 L
.85359 .82244 L
.85334 .8227 L
.84972 .82631 L
.84947 .82655 L
.84584 .83017 L
.84583 .83403 L
.84561 .83424 L
.84195 .83789 L
.84175 .83808 L
.83806 .84175 L
.83789 .84192 L
.83417 .84561 L
.83403 .84576 L
.83017 .84574 L
.8264 .84947 L
.82631 .84957 L
.82251 .85334 L
.82244 .8534 L
.81861 .8572 L
.81858 .85723 L
.81472 .86104 L
.81316 .8572 L
.81086 .85419 L
.8102 .85334 L
.80722 .84947 L
.807 .84918 L
.80421 .84561 L
.80314 .84424 L
.80118 .84175 L
.79927 .83935 L
.79811 .83789 L
.79541 .83453 L
.79501 .83403 L
.79188 .83017 L
.79155 .82977 L
.78871 .82631 L
.78769 .82507 L
.78551 .82244 L
.78383 .82043 L
.78228 .81858 L
.77997 .81585 L
.77901 .81472 L
.7761 .81133 L
.7757 .81086 L
.77235 .807 L
.77224 .80688 L
.76896 .80314 L
.76838 .80248 L
.76553 .79927 L
.76452 .79815 L
.76206 .79541 L
.76066 .79387 L
.75854 .79155 L
.7568 .78966 L
.75497 .78769 L
.75293 .78551 L
.75136 .78383 L
.74907 .78142 L
.74769 .77997 L
.74521 .77739 L
.74397 .7761 L
.74135 .77342 L
.74019 .77224 L
.73749 .76951 L
.73636 .76838 L
.73363 .76567 L
.73246 .76452 L
.72977 .76188 L
.7285 .76066 L
.7259 .75816 L
.72448 .7568 L
.72204 .75449 L
.72038 .75293 L
.71818 .75089 L
.71621 .74907 L
.71432 .74735 L
.71195 .74521 L
.71046 .74387 L
.70762 .74135 L
.7066 .74045 L
.70319 .73749 L
.70273 .73709 L
.69887 .7338 L
.69867 .73363 L
.69501 .73056 L
.69405 .72977 L
.69115 .72738 L
.68932 .7259 L
.68729 .72427 L
.68448 .72204 L
.68343 .72122 L
.67956 .71823 L
.67951 .71818 L
.6757 .71529 L
.6744 .71432 L
.67184 .71242 L
.66915 .71046 L
.66798 .70962 L
.66412 .70687 L
.66373 .7066 L
.66026 .70418 L
.65814 .70273 L
.65639 .70155 L
.65253 .69899 L
.65235 .69887 L
.64867 .69649 L
.64635 .69501 L
.64481 .69404 L
.64095 .69166 L
.64011 .69115 L
.63709 .68934 L
.63359 .68729 L
.63323 .68708 L
.62936 .68488 L
.62675 .68343 L
.6255 .68274 L
.62164 .68067 L
.61955 .67956 L
.61778 .67865 L
.61392 .67669 L
.61191 .6757 L
.61006 .6748 L
.60619 .67297 L
.60376 .67184 L
.60233 .67119 L
.59847 .66948 L
.59496 .66798 L
.59461 .66783 L
.59075 .66624 L
.58689 .66472 L
.58533 .66412 L
.58302 .66325 L
.57916 .66184 L
.5753 .6605 L
.57459 .66026 L
.57144 .65921 L
.56758 .65799 L
.56372 .65683 L
.56223 .65639 L
.55985 .65572 L
.55599 .65468 L
.55213 .6537 L
.54827 .65278 L
.54717 .65253 L
.54441 .65193 L
.54055 .65113 L
.53669 .65039 L
.53282 .64972 L
.52896 .6491 L
.52598 .64867 L
.5251 .64855 L
.52124 .64806 L
.51738 .64763 L
.51352 .64726 L
.50965 .64695 L
.50579 .6467 L
.50193 .64651 L
.49807 .64639 L
.49421 .64632 L
.49035 .64631 L
.48648 .64637 L
.48262 .64649 L
.47876 .64666 L
.4749 .6469 L
.47104 .6472 L
.46718 .64756 L
.46331 .64798 L
.45945 .64847 L
.45794 .64867 L
.45559 .64901 L
.45173 .64961 L
.44787 .65028 L
.44401 .651 L
.44015 .65179 L
.43674 .65253 L
.43628 .65264 L
.43242 .65355 L
.42856 .65451 L
.4247 .65554 L
.42167 .65639 L
.42084 .65664 L
.41698 .65779 L
.41311 .659 L
.4093 .66026 L
.40925 .66027 L
.40539 .66161 L
.40153 .663 L
.39855 .66412 L
.39767 .66446 L
.39381 .66597 L
.38994 .66755 L
.38892 .66798 L
.38608 .66919 L
.38222 .67089 L
.38011 .67184 L
.37836 .67265 L
.3745 .67447 L
.37195 .6757 L
.37064 .67635 L
.36677 .67829 L
.36431 .67956 L
.36291 .68029 L
.35905 .68236 L
.3571 .68343 L
.35519 .68448 L
.35133 .68667 L
.35025 .68729 L
.34747 .68891 L
.34372 .69115 L
.34361 .69122 L
.33974 .69359 L
.33747 .69501 L
.33588 .69602 L
.33202 .6985 L
.33146 .69887 L
.32816 .70105 L
.32566 .70273 L
.3243 .70366 L
.32044 .70634 L
.32006 .7066 L
.31657 .70907 L
.31464 .71046 L
.31271 .71186 L
.30938 .71432 L
.30885 .71471 L
.30499 .71763 L
.30426 .71818 L
.30113 .7206 L
.29929 .72204 L
.29727 .72364 L
.29443 .7259 L
.2934 .72673 L
.28969 .72977 L
.28954 .72989 L
.28568 .73311 L
.28506 .73363 L
.28182 .73639 L
.28054 .73749 L
.27796 .73972 L
.2761 .74135 L
.2741 .74312 L
.27176 .74521 L
.27023 .74658 L
.2675 .74907 L
.26637 .7501 L
.26332 .75293 L
.26251 .75369 L
.25921 .7568 L
.25865 .75733 L
.25517 .76066 L
.25479 .76103 L
.25121 .76452 L
.25093 .76479 L
.2473 .76838 L
.24707 .76862 L
.24346 .77224 L
.2432 .7725 L
.23968 .7761 L
.23934 .77645 L
.23595 .77997 L
.23548 .78045 L
.23227 .78383 L
.23162 .78452 L
.22865 .78769 L
.22776 .78865 L
.22507 .79155 L
.2239 .79283 L
.22154 .79541 L
.22003 .79708 L
.21806 .79927 L
.21617 .80139 L
.21462 .80314 L
.21231 .80576 L
.21123 .807 L
.20845 .81019 L
.20787 .81086 L
.20459 .81468 L
.20455 .81472 L
.20127 .81858 L
.20073 .81923 L
.19803 .82244 L
.19686 .82384 L
.19482 .82631 L
.193 .82851 L
.19165 .83017 L
.18914 .83325 L
.18851 .83403 L
.1854 .83789 L
.18528 .83804 L
.18232 .84175 L
.18142 .84289 L
.17927 .84561 L
.17756 .84781 L
.17753 .84947 L
.17369 .84949 L
.17368 .84947 L
.16983 .84566 L
.16597 .84567 L
.16591 .84561 L
.16211 .84184 L
.16202 .84175 L
.15825 .838 L
.15814 .83789 L
.15439 .83416 L
.15426 .83403 L
.15425 .83017 L
.15053 .82646 L
.15037 .82631 L
.14666 .82262 L
.14649 .82244 L
.1428 .81877 L
.14262 .81858 L
.13894 .81492 L
.13874 .81472 L
.13508 .81106 L
.13487 .81086 L
.13122 .80721 L
.13101 .807 L
.12736 .80335 L
.12714 .80314 L
.12714 .79927 L
.12349 .79563 L
.12328 .79541 L
.11963 .79177 L
.11942 .79155 L
.11577 .7879 L
.11556 .78769 L
.11556 .78383 L
.11191 .78017 L
.11171 .77997 L
.10805 .77629 L
.10786 .7761 L
.10419 .77242 L
.10401 .77224 L
.10401 .76838 L
.10032 .76467 L
.10017 .76452 L
.09646 .76079 L
.09633 .76066 L
.09634 .7568 L
.0926 .75304 L
.0925 .75293 L
.09251 .74907 L
.08874 .74527 L
.08868 .74521 L
.08488 .74138 L
.08485 .74135 L
.08486 .73749 L
.08108 .73363 L
.08488 .73302 L
.08669 .72977 L
.08874 .72611 L
.08885 .7259 L
.09103 .72204 L
.0926 .71926 L
.09321 .71818 L
.09541 .71432 L
.09646 .71247 L
.09762 .71046 L
.09984 .7066 L
.10032 .70575 L
.10207 .70273 L
.10419 .69909 L
.10432 .69887 L
.10657 .69501 L
.10805 .6925 L
.10884 .69115 L
.11113 .68729 L
.11191 .68597 L
.11342 .68343 L
.11573 .67956 L
.11577 .6795 L
.11806 .6757 L
.11963 .6731 L
.1204 .67184 L
.12275 .66798 L
.12349 .66676 L
.12512 .66412 L
.12736 .66049 L
.1275 .66026 L
.1299 .65639 L
.13122 .65428 L
.13231 .65253 L
.13474 .64867 L
.13508 .64813 L
.13718 .64481 L
.13894 .64205 L
.13964 .64095 L
.14212 .63709 L
.1428 .63603 L
.14461 .63323 L
.14666 .63007 L
.14712 .62936 L
.14965 .6255 L
.15053 .62418 L
.1522 .62164 L
.15439 .61835 L
.15477 .61778 L
.15735 .61392 L
.15825 .61258 L
.15995 .61006 L
.16211 .60688 L
.16258 .60619 L
.16522 .60233 L
.16597 .60124 L
.16789 .59847 L
.16983 .59567 L
.17057 .59461 L
.17328 .59075 L
.17369 .59016 L
.17601 .58689 L
.17756 .58471 L
.17876 .58302 L
.18142 .57933 L
.18154 .57916 L
.18433 .5753 L
.18528 .57401 L
.18716 .57144 L
.18914 .56875 L
.19001 .56758 L
.19288 .56372 L
.193 .56356 L
.19578 .55985 L
.19686 .55843 L
.19871 .55599 L
.20073 .55336 L
.20167 .55213 L
.20459 .54836 L
.20466 .54827 L
.20767 .54441 L
.20845 .54342 L
.21072 .54055 L
.21231 .53854 L
.2138 .53669 L
.21617 .53373 L
.21691 .53282 L
.22003 .52898 L
.22005 .52896 L
.22323 .5251 L
.2239 .5243 L
.22645 .52124 L
.22776 .51968 L
.2297 .51738 L
.23162 .51512 L
.23299 .51352 L
.23548 .51062 L
.23632 .50965 L
.23934 .50619 L
.23969 .50579 L
.24311 .50193 L
.2432 .50183 L
.24657 .49807 L
.24707 .49752 L
.25008 .49421 L
.25093 .49328 L
.25363 .49035 L
.25479 .48911 L
.25724 .48648 L
.25865 .48499 L
.2609 .48262 L
.26251 .48094 L
.26462 .47876 L
.26637 .47695 L
.26839 .4749 L
.27023 .47303 L
.27222 .47104 L
.2741 .46917 L
.27612 .46718 L
.27796 .46537 L
.28008 .46331 L
.28182 .46164 L
.28411 .45945 L
.28568 .45797 L
.28822 .45559 L
.28954 .45437 L
.29241 .45173 L
.2934 .45082 L
.29668 .44787 L
.29727 .44734 L
.30104 .44401 L
.30113 .44393 L
.30499 .44057 L
.30549 .44015 L
.30885 .43728 L
.31004 .43628 L
.31271 .43406 L
.3147 .43242 L
.31657 .4309 L
.31948 .42856 L
.32044 .4278 L
.3243 .42476 L
.32438 .4247 L
.32816 .42179 L
.32941 .42084 L
.33202 .41888 L
.33459 .41698 L
.33588 .41603 L
.33974 .41325 L
.33994 .41311 L
.34361 .41053 L
.34545 .40925 L
.34747 .40787 L
.35116 .40539 L
.35133 .40528 L
.35519 .40275 L
.35709 .40153 L
.35905 .40029 L
.36291 .39788 L
.36327 .39767 L
.36677 .39554 L
.36971 .39381 L
.37064 .39327 L
.3745 .39106 L
.37648 .38994 L
.37836 .38891 L
.38222 .38682 L
.38361 .38608 L
.38608 .3848 L
.38994 .38284 L
.39118 .38222 L
.39381 .38094 L
.39767 .37911 L
.39928 .37836 L
.40153 .37734 L
.40539 .37563 L
.40803 .3745 L
.40925 .37399 L
.41311 .37241 L
.41698 .37089 L
.41763 .37064 L
.42084 .36943 L
.4247 .36804 L
.42839 .36677 L
.42856 .36672 L
.43242 .36545 L
.43628 .36425 L
.44015 .36311 L
.44085 .36291 L
.44401 .36204 L
.44787 .36103 L
.45173 .36008 L
.45559 .35919 L
.45624 .35905 L
.45945 .35837 L
.46331 .35761 L
.46718 .35692 L
.47104 .35629 L
.4749 .35572 L
.47876 .35521 L
.47894 .35519 L
F
0 g
.48262 .35477 m
.48648 .35439 L
.49035 .35407 L
.49421 .35382 L
.49807 .35363 L
.50193 .3535 L
.50579 .35344 L
.50965 .35344 L
.51352 .3535 L
.51738 .35363 L
.52124 .35382 L
.5251 .35407 L
.52896 .35438 L
.53282 .35476 L
.53657 .35519 L
.53669 .3552 L
.54055 .35571 L
.54441 .35628 L
.54827 .35691 L
.55213 .3576 L
.55599 .35836 L
.55927 .35905 L
.55985 .35918 L
.56372 .36006 L
.56758 .36101 L
.57144 .36202 L
.57467 .36291 L
.5753 .36309 L
.57916 .36423 L
.58302 .36543 L
.58689 .36669 L
.58714 .36677 L
.59075 .36801 L
.59461 .3694 L
.5979 .37064 L
.59847 .37085 L
.60233 .37237 L
.60619 .37395 L
.60751 .3745 L
.61006 .37559 L
.61392 .37729 L
.61627 .37836 L
.61778 .37906 L
.62164 .38089 L
.62437 .38222 L
.6255 .38278 L
.62936 .38474 L
.63195 .38608 L
.63323 .38676 L
.63709 .38884 L
Mistroke
.63909 .38994 L
.64095 .39098 L
.64481 .39319 L
.64586 .39381 L
.64867 .39546 L
.65232 .39767 L
.65253 .3978 L
.65639 .4002 L
.6585 .40153 L
.66026 .40266 L
.66412 .40518 L
.66443 .40539 L
.66798 .40777 L
.67015 .40925 L
.67184 .41042 L
.67568 .41311 L
.6757 .41313 L
.67956 .41591 L
.68103 .41698 L
.68343 .41875 L
.68622 .42084 L
.68729 .42165 L
.69115 .42461 L
.69126 .4247 L
.69501 .42764 L
.69617 .42856 L
.69887 .43073 L
.70095 .43242 L
.70273 .43389 L
.70562 .43628 L
.7066 .43711 L
.71018 .44015 L
.71046 .44039 L
.71432 .44373 L
.71464 .44401 L
.71818 .44714 L
.719 .44787 L
.72204 .45061 L
.72328 .45173 L
.7259 .45414 L
.72747 .45559 L
.72977 .45773 L
.73159 .45945 L
.73363 .46139 L
.73563 .46331 L
.73749 .46511 L
.7396 .46718 L
.74135 .4689 L
.7435 .47104 L
.74521 .47275 L
Mistroke
.74734 .4749 L
.74907 .47666 L
.75112 .47876 L
.75293 .48063 L
.75485 .48262 L
.7568 .48467 L
.75851 .48648 L
.76066 .48877 L
.76213 .49035 L
.76452 .49293 L
.76569 .49421 L
.76838 .49716 L
.76921 .49807 L
.77224 .50145 L
.77267 .50193 L
.7761 .50579 L
.7761 .5058 L
.77948 .50965 L
.77997 .51022 L
.78282 .51352 L
.78383 .51469 L
.78612 .51738 L
.78769 .51923 L
.78938 .52124 L
.79155 .52384 L
.7926 .5251 L
.79541 .52851 L
.79579 .52896 L
.79894 .53282 L
.79927 .53324 L
.80206 .53669 L
.80314 .53803 L
.80514 .54055 L
.807 .54289 L
.8082 .54441 L
.81086 .54781 L
.81122 .54827 L
.81421 .55213 L
.81472 .55279 L
.81718 .55599 L
.81858 .55783 L
.82012 .55985 L
.82244 .56294 L
.82303 .56372 L
.82591 .56758 L
.82631 .56811 L
.82876 .57144 L
.83017 .57335 L
.8316 .5753 L
.83403 .57865 L
Mistroke
.8344 .57916 L
.83719 .58302 L
.83789 .58401 L
.83995 .58689 L
.84175 .58943 L
.84268 .59075 L
.8454 .59461 L
.84561 .59492 L
.84809 .59847 L
.84947 .60047 L
.85076 .60233 L
.85334 .60608 L
.85342 .60619 L
.85605 .61006 L
.8572 .61175 L
.85866 .61392 L
.86106 .61749 L
.86125 .61778 L
.86383 .62164 L
.86492 .62329 L
.86638 .6255 L
.86878 .62916 L
.86892 .62936 L
.87144 .63323 L
.87264 .63509 L
.87394 .63709 L
.87642 .64095 L
.87651 .64108 L
.87889 .64481 L
.88037 .64713 L
.88134 .64867 L
.88378 .65253 L
.88423 .65325 L
.8862 .65639 L
.88809 .65943 L
.88861 .66026 L
.891 .66412 L
.89195 .66567 L
.89337 .66798 L
.89573 .67184 L
.89581 .67197 L
.89808 .6757 L
.89968 .67834 L
.90041 .67956 L
.90273 .68343 L
.90354 .68477 L
.90504 .68729 L
.90733 .69115 L
.9074 .69127 L
.90961 .69501 L
Mistroke
.91126 .69783 L
.91187 .69887 L
.91413 .70273 L
.91512 .70445 L
.91637 .7066 L
.9186 .71046 L
.91898 .71113 L
.92081 .71432 L
.92285 .71788 L
.92663 .71818 L
.92286 .72204 L
.92288 .7259 L
.92285 .72594 L
.91906 .72977 L
.91907 .73363 L
.91898 .73372 L
.91525 .73749 L
.91526 .74135 L
.91512 .74149 L
.91143 .74521 L
.91126 .74538 L
.90759 .74907 L
.9076 .75293 L
.9074 .75314 L
.90376 .7568 L
.90377 .76066 L
.90354 .76089 L
.89992 .76452 L
.89968 .76477 L
.89608 .76838 L
.89608 .77224 L
.89581 .77251 L
.89223 .7761 L
.89195 .77639 L
.88838 .77997 L
.88809 .78026 L
.88453 .78383 L
.88453 .78769 L
.88423 .78799 L
.88067 .79155 L
.88037 .79185 L
.87681 .79541 L
.87651 .79572 L
.87295 .79927 L
.87294 .80314 L
.87264 .80344 L
.86908 .807 L
.86878 .80729 L
.86521 .81086 L
.86492 .81115 L
Mistroke
.86134 .81472 L
.86106 .815 L
.85747 .81858 L
.8572 .81885 L
.85359 .82244 L
.85334 .8227 L
.84972 .82631 L
.84947 .82655 L
.84584 .83017 L
.84583 .83403 L
.84561 .83424 L
.84195 .83789 L
.84175 .83808 L
.83806 .84175 L
.83789 .84192 L
.83417 .84561 L
.83403 .84576 L
.83017 .84574 L
.8264 .84947 L
.82631 .84957 L
.82251 .85334 L
.82244 .8534 L
.81861 .8572 L
.81858 .85723 L
.81472 .86104 L
.81316 .8572 L
.81086 .85419 L
.8102 .85334 L
.80722 .84947 L
.807 .84918 L
.80421 .84561 L
.80314 .84424 L
.80118 .84175 L
.79927 .83935 L
.79811 .83789 L
.79541 .83453 L
.79501 .83403 L
.79188 .83017 L
.79155 .82977 L
.78871 .82631 L
.78769 .82507 L
.78551 .82244 L
.78383 .82043 L
.78228 .81858 L
.77997 .81585 L
.77901 .81472 L
.7761 .81133 L
.7757 .81086 L
.77235 .807 L
.77224 .80688 L
Mistroke
.76896 .80314 L
.76838 .80248 L
.76553 .79927 L
.76452 .79815 L
.76206 .79541 L
.76066 .79387 L
.75854 .79155 L
.7568 .78966 L
.75497 .78769 L
.75293 .78551 L
.75136 .78383 L
.74907 .78142 L
.74769 .77997 L
.74521 .77739 L
.74397 .7761 L
.74135 .77342 L
.74019 .77224 L
.73749 .76951 L
.73636 .76838 L
.73363 .76567 L
.73246 .76452 L
.72977 .76188 L
.7285 .76066 L
.7259 .75816 L
.72448 .7568 L
.72204 .75449 L
.72038 .75293 L
.71818 .75089 L
.71621 .74907 L
.71432 .74735 L
.71195 .74521 L
.71046 .74387 L
.70762 .74135 L
.7066 .74045 L
.70319 .73749 L
.70273 .73709 L
.69887 .7338 L
.69867 .73363 L
.69501 .73056 L
.69405 .72977 L
.69115 .72738 L
.68932 .7259 L
.68729 .72427 L
.68448 .72204 L
.68343 .72122 L
.67956 .71823 L
.67951 .71818 L
.6757 .71529 L
.6744 .71432 L
.67184 .71242 L
Mistroke
.66915 .71046 L
.66798 .70962 L
.66412 .70687 L
.66373 .7066 L
.66026 .70418 L
.65814 .70273 L
.65639 .70155 L
.65253 .69899 L
.65235 .69887 L
.64867 .69649 L
.64635 .69501 L
.64481 .69404 L
.64095 .69166 L
.64011 .69115 L
.63709 .68934 L
.63359 .68729 L
.63323 .68708 L
.62936 .68488 L
.62675 .68343 L
.6255 .68274 L
.62164 .68067 L
.61955 .67956 L
.61778 .67865 L
.61392 .67669 L
.61191 .6757 L
.61006 .6748 L
.60619 .67297 L
.60376 .67184 L
.60233 .67119 L
.59847 .66948 L
.59496 .66798 L
.59461 .66783 L
.59075 .66624 L
.58689 .66472 L
.58533 .66412 L
.58302 .66325 L
.57916 .66184 L
.5753 .6605 L
.57459 .66026 L
.57144 .65921 L
.56758 .65799 L
.56372 .65683 L
.56223 .65639 L
.55985 .65572 L
.55599 .65468 L
.55213 .6537 L
.54827 .65278 L
.54717 .65253 L
.54441 .65193 L
.54055 .65113 L
Mistroke
.53669 .65039 L
.53282 .64972 L
.52896 .6491 L
.52598 .64867 L
.5251 .64855 L
.52124 .64806 L
.51738 .64763 L
.51352 .64726 L
.50965 .64695 L
.50579 .6467 L
.50193 .64651 L
.49807 .64639 L
.49421 .64632 L
.49035 .64631 L
.48648 .64637 L
.48262 .64649 L
.47876 .64666 L
.4749 .6469 L
.47104 .6472 L
.46718 .64756 L
.46331 .64798 L
.45945 .64847 L
.45794 .64867 L
.45559 .64901 L
.45173 .64961 L
.44787 .65028 L
.44401 .651 L
.44015 .65179 L
.43674 .65253 L
.43628 .65264 L
.43242 .65355 L
.42856 .65451 L
.4247 .65554 L
.42167 .65639 L
.42084 .65664 L
.41698 .65779 L
.41311 .659 L
.4093 .66026 L
.40925 .66027 L
.40539 .66161 L
.40153 .663 L
.39855 .66412 L
.39767 .66446 L
.39381 .66597 L
.38994 .66755 L
.38892 .66798 L
.38608 .66919 L
.38222 .67089 L
.38011 .67184 L
.37836 .67265 L
Mistroke
.3745 .67447 L
.37195 .6757 L
.37064 .67635 L
.36677 .67829 L
.36431 .67956 L
.36291 .68029 L
.35905 .68236 L
.3571 .68343 L
.35519 .68448 L
.35133 .68667 L
.35025 .68729 L
.34747 .68891 L
.34372 .69115 L
.34361 .69122 L
.33974 .69359 L
.33747 .69501 L
.33588 .69602 L
.33202 .6985 L
.33146 .69887 L
.32816 .70105 L
.32566 .70273 L
.3243 .70366 L
.32044 .70634 L
.32006 .7066 L
.31657 .70907 L
.31464 .71046 L
.31271 .71186 L
.30938 .71432 L
.30885 .71471 L
.30499 .71763 L
.30426 .71818 L
.30113 .7206 L
.29929 .72204 L
.29727 .72364 L
.29443 .7259 L
.2934 .72673 L
.28969 .72977 L
.28954 .72989 L
.28568 .73311 L
.28506 .73363 L
.28182 .73639 L
.28054 .73749 L
.27796 .73972 L
.2761 .74135 L
.2741 .74312 L
.27176 .74521 L
.27023 .74658 L
.2675 .74907 L
.26637 .7501 L
.26332 .75293 L
Mistroke
.26251 .75369 L
.25921 .7568 L
.25865 .75733 L
.25517 .76066 L
.25479 .76103 L
.25121 .76452 L
.25093 .76479 L
.2473 .76838 L
.24707 .76862 L
.24346 .77224 L
.2432 .7725 L
.23968 .7761 L
.23934 .77645 L
.23595 .77997 L
.23548 .78045 L
.23227 .78383 L
.23162 .78452 L
.22865 .78769 L
.22776 .78865 L
.22507 .79155 L
.2239 .79283 L
.22154 .79541 L
.22003 .79708 L
.21806 .79927 L
.21617 .80139 L
.21462 .80314 L
.21231 .80576 L
.21123 .807 L
.20845 .81019 L
.20787 .81086 L
.20459 .81468 L
.20455 .81472 L
.20127 .81858 L
.20073 .81923 L
.19803 .82244 L
.19686 .82384 L
.19482 .82631 L
.193 .82851 L
.19165 .83017 L
.18914 .83325 L
.18851 .83403 L
.1854 .83789 L
.18528 .83804 L
.18232 .84175 L
.18142 .84289 L
.17927 .84561 L
.17756 .84781 L
.17753 .84947 L
.17369 .84949 L
.17368 .84947 L
Mistroke
.16983 .84566 L
.16597 .84567 L
.16591 .84561 L
.16211 .84184 L
.16202 .84175 L
.15825 .838 L
.15814 .83789 L
.15439 .83416 L
.15426 .83403 L
.15425 .83017 L
.15053 .82646 L
.15037 .82631 L
.14666 .82262 L
.14649 .82244 L
.1428 .81877 L
.14262 .81858 L
.13894 .81492 L
.13874 .81472 L
.13508 .81106 L
.13487 .81086 L
.13122 .80721 L
.13101 .807 L
.12736 .80335 L
.12714 .80314 L
.12714 .79927 L
.12349 .79563 L
.12328 .79541 L
.11963 .79177 L
.11942 .79155 L
.11577 .7879 L
.11556 .78769 L
.11556 .78383 L
.11191 .78017 L
.11171 .77997 L
.10805 .77629 L
.10786 .7761 L
.10419 .77242 L
.10401 .77224 L
.10401 .76838 L
.10032 .76467 L
.10017 .76452 L
.09646 .76079 L
.09633 .76066 L
.09634 .7568 L
.0926 .75304 L
.0925 .75293 L
.09251 .74907 L
.08874 .74527 L
.08868 .74521 L
.08488 .74138 L
Mistroke
.08485 .74135 L
.08486 .73749 L
.08108 .73363 L
.08488 .73302 L
.08669 .72977 L
.08874 .72611 L
.08885 .7259 L
.09103 .72204 L
.0926 .71926 L
.09321 .71818 L
.09541 .71432 L
.09646 .71247 L
.09762 .71046 L
.09984 .7066 L
.10032 .70575 L
.10207 .70273 L
.10419 .69909 L
.10432 .69887 L
.10657 .69501 L
.10805 .6925 L
.10884 .69115 L
.11113 .68729 L
.11191 .68597 L
.11342 .68343 L
.11573 .67956 L
.11577 .6795 L
.11806 .6757 L
.11963 .6731 L
.1204 .67184 L
.12275 .66798 L
.12349 .66676 L
.12512 .66412 L
.12736 .66049 L
.1275 .66026 L
.1299 .65639 L
.13122 .65428 L
.13231 .65253 L
.13474 .64867 L
.13508 .64813 L
.13718 .64481 L
.13894 .64205 L
.13964 .64095 L
.14212 .63709 L
.1428 .63603 L
.14461 .63323 L
.14666 .63007 L
.14712 .62936 L
.14965 .6255 L
.15053 .62418 L
.1522 .62164 L
Mistroke
.15439 .61835 L
.15477 .61778 L
.15735 .61392 L
.15825 .61258 L
.15995 .61006 L
.16211 .60688 L
.16258 .60619 L
.16522 .60233 L
.16597 .60124 L
.16789 .59847 L
.16983 .59567 L
.17057 .59461 L
.17328 .59075 L
.17369 .59016 L
.17601 .58689 L
.17756 .58471 L
.17876 .58302 L
.18142 .57933 L
.18154 .57916 L
.18433 .5753 L
.18528 .57401 L
.18716 .57144 L
.18914 .56875 L
.19001 .56758 L
.19288 .56372 L
.193 .56356 L
.19578 .55985 L
.19686 .55843 L
.19871 .55599 L
.20073 .55336 L
.20167 .55213 L
.20459 .54836 L
.20466 .54827 L
.20767 .54441 L
.20845 .54342 L
.21072 .54055 L
.21231 .53854 L
.2138 .53669 L
.21617 .53373 L
.21691 .53282 L
.22003 .52898 L
.22005 .52896 L
.22323 .5251 L
.2239 .5243 L
.22645 .52124 L
.22776 .51968 L
.2297 .51738 L
.23162 .51512 L
.23299 .51352 L
.23548 .51062 L
Mistroke
.23632 .50965 L
.23934 .50619 L
.23969 .50579 L
.24311 .50193 L
.2432 .50183 L
.24657 .49807 L
.24707 .49752 L
.25008 .49421 L
.25093 .49328 L
.25363 .49035 L
.25479 .48911 L
.25724 .48648 L
.25865 .48499 L
.2609 .48262 L
.26251 .48094 L
.26462 .47876 L
.26637 .47695 L
.26839 .4749 L
.27023 .47303 L
.27222 .47104 L
.2741 .46917 L
.27612 .46718 L
.27796 .46537 L
.28008 .46331 L
.28182 .46164 L
.28411 .45945 L
.28568 .45797 L
.28822 .45559 L
.28954 .45437 L
.29241 .45173 L
.2934 .45082 L
.29668 .44787 L
.29727 .44734 L
.30104 .44401 L
.30113 .44393 L
.30499 .44057 L
.30549 .44015 L
.30885 .43728 L
.31004 .43628 L
.31271 .43406 L
.3147 .43242 L
.31657 .4309 L
.31948 .42856 L
.32044 .4278 L
.3243 .42476 L
.32438 .4247 L
.32816 .42179 L
.32941 .42084 L
.33202 .41888 L
.33459 .41698 L
Mistroke
.33588 .41603 L
.33974 .41325 L
.33994 .41311 L
.34361 .41053 L
.34545 .40925 L
.34747 .40787 L
.35116 .40539 L
.35133 .40528 L
.35519 .40275 L
.35709 .40153 L
.35905 .40029 L
.36291 .39788 L
.36327 .39767 L
.36677 .39554 L
.36971 .39381 L
.37064 .39327 L
.3745 .39106 L
.37648 .38994 L
.37836 .38891 L
.38222 .38682 L
.38361 .38608 L
.38608 .3848 L
.38994 .38284 L
.39118 .38222 L
.39381 .38094 L
.39767 .37911 L
.39928 .37836 L
.40153 .37734 L
.40539 .37563 L
.40803 .3745 L
.40925 .37399 L
.41311 .37241 L
.41698 .37089 L
.41763 .37064 L
.42084 .36943 L
.4247 .36804 L
.42839 .36677 L
.42856 .36672 L
.43242 .36545 L
.43628 .36425 L
.44015 .36311 L
.44085 .36291 L
.44401 .36204 L
.44787 .36103 L
.45173 .36008 L
.45559 .35919 L
.45624 .35905 L
.45945 .35837 L
.46331 .35761 L
.46718 .35692 L
Mistroke
.47104 .35629 L
.4749 .35572 L
.47876 .35521 L
.47894 .35519 L
.48262 .35477 L
Mfstroke
1 .616 .5 r
.47104 .38162 m
.4749 .38102 L
.47876 .38049 L
.48262 .38002 L
.48648 .37961 L
.49035 .37927 L
.49421 .37899 L
.49807 .37877 L
.50193 .37862 L
.50579 .37853 L
.50965 .3785 L
.51352 .37854 L
.51738 .37864 L
.52124 .37881 L
.5251 .37903 L
.52896 .37933 L
.53282 .37968 L
.53669 .3801 L
.54055 .38058 L
.54441 .38112 L
.54827 .38173 L
.55112 .38222 L
.55213 .3824 L
.55599 .38314 L
.55985 .38394 L
.56372 .3848 L
.56758 .38572 L
.56901 .38608 L
.57144 .38671 L
.5753 .38776 L
.57916 .38888 L
.58267 .38994 L
.58302 .39006 L
.58689 .3913 L
.59075 .3926 L
.59415 .39381 L
.59461 .39397 L
.59847 .3954 L
.60233 .3969 L
.60426 .39767 L
.60619 .39846 L
.61006 .40008 L
.61339 .40153 L
.61392 .40176 L
.61778 .40351 L
.62164 .40532 L
.62178 .40539 L
.6255 .4072 L
.62936 .40914 L
.62959 .40925 L
.63323 .41114 L
.63692 .41311 L
.63709 .41321 L
.64095 .41533 L
.64385 .41698 L
.64481 .41753 L
.64867 .41978 L
.65044 .42084 L
.65253 .4221 L
.65639 .42448 L
.65674 .4247 L
.66026 .42693 L
.66278 .42856 L
.66412 .42943 L
.66798 .43201 L
.6686 .43242 L
.67184 .43464 L
.6742 .43628 L
.6757 .43734 L
.67956 .4401 L
.67963 .44015 L
.68343 .44292 L
.68488 .44401 L
.68729 .44581 L
.68999 .44787 L
.69115 .44876 L
.69495 .45173 L
.69501 .45178 L
.69887 .45485 L
.69979 .45559 L
.70273 .458 L
.7045 .45945 L
.7066 .4612 L
.7091 .46331 L
.71046 .46447 L
.7136 .46718 L
.71432 .4678 L
.71801 .47104 L
.71818 .47119 L
.72204 .47465 L
.72232 .4749 L
.7259 .47817 L
.72655 .47876 L
.72977 .48175 L
.73069 .48262 L
.73363 .4854 L
.73476 .48648 L
.73749 .48911 L
.73876 .49035 L
.74135 .49288 L
.74269 .49421 L
.74521 .49672 L
.74655 .49807 L
.74907 .50062 L
.75036 .50193 L
.75293 .50458 L
.7541 .50579 L
.7568 .50861 L
.75779 .50965 L
.76066 .5127 L
.76142 .51352 L
.76452 .51685 L
.765 .51738 L
.76838 .52107 L
.76854 .52124 L
.77202 .5251 L
.77224 .52535 L
.77546 .52896 L
.7761 .52969 L
.77886 .53282 L
.77997 .5341 L
.78221 .53669 L
.78383 .53856 L
.78552 .54055 L
.78769 .5431 L
.7888 .54441 L
.79155 .54769 L
.79203 .54827 L
.79523 .55213 L
.79541 .55235 L
.7984 .55599 L
.79927 .55707 L
.80153 .55985 L
.80314 .56186 L
.80462 .56372 L
.807 .56671 L
.80769 .56758 L
.81072 .57144 L
.81086 .57162 L
.81372 .5753 L
.81472 .57659 L
.8167 .57916 L
.81858 .58163 L
.81964 .58302 L
.82244 .58673 L
.82256 .58689 L
.82545 .59075 L
.82631 .59189 L
.82832 .59461 L
.83017 .59712 L
.83116 .59847 L
.83397 .60233 L
.83403 .60241 L
.83676 .60619 L
.83789 .60777 L
.83953 .61006 L
.84175 .61318 L
.84227 .61392 L
.84499 .61778 L
.84561 .61866 L
.84769 .62164 L
.84947 .62421 L
.85037 .6255 L
.85303 .62936 L
.85334 .62981 L
.85567 .63323 L
.8572 .63548 L
.85828 .63709 L
.86088 .64095 L
.86106 .64122 L
.86346 .64481 L
.86492 .64701 L
.86602 .64867 L
.86856 .65253 L
.86878 .65287 L
.87108 .65639 L
.87264 .65879 L
.87359 .66026 L
.87608 .66412 L
.87651 .66478 L
.87855 .66798 L
.88037 .67083 L
.88101 .67184 L
.88345 .6757 L
.88423 .67694 L
.88587 .67956 L
.88809 .68312 L
.88828 .68343 L
.89068 .68729 L
.89195 .68936 L
.89306 .69115 L
.89542 .69501 L
.89581 .69566 L
.89777 .69887 L
.89968 .70202 L
.90011 .70273 L
.90243 .7066 L
.90354 .70845 L
.90474 .71046 L
.90703 .71432 L
.9074 .71494 L
.90931 .71818 L
.91126 .7215 L
.91158 .72204 L
.91384 .7259 L
.91512 .72811 L
.91894 .72977 L
.91897 .73363 L
.91515 .73749 L
.91517 .74135 L
.91512 .7414 L
.91134 .74521 L
.91126 .74529 L
.9075 .74907 L
.90751 .75293 L
.9074 .75305 L
.90367 .7568 L
.90368 .76066 L
.90354 .7608 L
.89984 .76452 L
.89968 .76468 L
.89599 .76838 L
.896 .77224 L
.89581 .77243 L
.89215 .7761 L
.89195 .7763 L
.8883 .77997 L
.88809 .78017 L
.88444 .78383 L
.88444 .78769 L
.88423 .7879 L
.88059 .79155 L
.88037 .79177 L
.87673 .79541 L
.87651 .79563 L
.87286 .79927 L
.87286 .80314 L
.87264 .80335 L
.86899 .807 L
.86878 .80721 L
.86513 .81086 L
.86492 .81106 L
.86126 .81472 L
.86106 .81492 L
.85738 .81858 L
.8572 .81877 L
.85351 .82244 L
.85334 .82261 L
.84963 .82631 L
.84947 .82646 L
.84575 .83017 L
.84574 .83403 L
.84561 .83416 L
.84186 .83789 L
.84175 .838 L
.83797 .84175 L
.83789 .84183 L
.83408 .84561 L
.83403 .84567 L
.83017 .84565 L
.82631 .84947 L
.82631 .84948 L
.82251 .84947 L
.82244 .84578 L
.82232 .84561 L
.81945 .84175 L
.81858 .84059 L
.81656 .83789 L
.81472 .83545 L
.81364 .83403 L
.81086 .83038 L
.8107 .83017 L
.80773 .82631 L
.807 .82536 L
.80473 .82244 L
.80314 .82041 L
.8017 .81858 L
.79927 .81552 L
.79864 .81472 L
.79555 .81086 L
.79541 .81069 L
.79243 .807 L
.79155 .80592 L
.78928 .80314 L
.78769 .80121 L
.78609 .79927 L
.78383 .79656 L
.78287 .79541 L
.77997 .79197 L
.77961 .79155 L
.77632 .78769 L
.7761 .78744 L
.77298 .78383 L
.77224 .78298 L
.76961 .77997 L
.76838 .77857 L
.7662 .7761 L
.76452 .77423 L
.76274 .77224 L
.76066 .76994 L
.75924 .76838 L
.7568 .76572 L
.75569 .76452 L
.75293 .76156 L
.75209 .76066 L
.74907 .75746 L
.74845 .7568 L
.74521 .75341 L
.74475 .75293 L
.74135 .74944 L
.741 .74907 L
.73749 .74552 L
.73719 .74521 L
.73363 .74166 L
.73332 .74135 L
.72977 .73786 L
.72938 .73749 L
.7259 .73413 L
.72538 .73363 L
.72204 .73045 L
.72132 .72977 L
.71818 .72684 L
.71717 .7259 L
.71432 .72328 L
.71296 .72204 L
.71046 .71979 L
.70866 .71818 L
.7066 .71636 L
.70427 .71432 L
.70273 .71298 L
.69979 .71046 L
.69887 .70967 L
.69522 .7066 L
.69501 .70642 L
.69115 .70324 L
.69054 .70273 L
.68729 .70011 L
.68574 .69887 L
.68343 .69704 L
.68083 .69501 L
.67956 .69403 L
.67578 .69115 L
.6757 .69109 L
.67184 .6882 L
.6706 .68729 L
.66798 .68538 L
.66526 .68343 L
.66412 .68261 L
.66026 .67991 L
.65975 .67956 L
.65639 .67727 L
.65406 .6757 L
.65253 .67469 L
.64867 .67217 L
.64816 .67184 L
.64481 .66971 L
.64204 .66798 L
.64095 .66731 L
.63709 .66497 L
.63565 .66412 L
.63323 .6627 L
.62936 .66048 L
.62897 .66026 L
.6255 .65832 L
.62195 .65639 L
.62164 .65623 L
.61778 .65419 L
.61454 .65253 L
.61392 .65222 L
.61006 .65031 L
.60665 .64867 L
.60619 .64846 L
.60233 .64666 L
.59847 .64493 L
.59819 .64481 L
.59461 .64326 L
.59075 .64165 L
.589 .64095 L
.58689 .64011 L
.58302 .63862 L
.57916 .63719 L
.57887 .63709 L
.5753 .63583 L
.57144 .63452 L
.56758 .63328 L
.56742 .63323 L
.56372 .63209 L
.55985 .63097 L
.55599 .6299 L
.55394 .62936 L
.55213 .6289 L
.54827 .62796 L
.54441 .62708 L
.54055 .62626 L
.53669 .6255 L
.53669 .6255 L
.53282 .6248 L
.52896 .62416 L
.5251 .62359 L
.52124 .62307 L
.51738 .62261 L
.51352 .62222 L
.50965 .62188 L
.50629 .62164 L
.50579 .62161 L
.50193 .6214 L
.49807 .62124 L
.49421 .62115 L
.49035 .62112 L
.48648 .62115 L
.48262 .62124 L
.47876 .62139 L
.4749 .6216 L
.47421 .62164 L
.47104 .62187 L
.46718 .6222 L
.46331 .62259 L
.45945 .62304 L
.45559 .62356 L
.45173 .62413 L
.44787 .62477 L
.44401 .62546 L
.44379 .6255 L
.44015 .62622 L
.43628 .62703 L
.43242 .62791 L
.42856 .62885 L
.42653 .62936 L
.4247 .62984 L
.42084 .6309 L
.41698 .63202 L
.41311 .6332 L
.41303 .63323 L
.40925 .63444 L
.40539 .63574 L
.40156 .63709 L
.40153 .6371 L
.39767 .63852 L
.39381 .64 L
.39141 .64095 L
.38994 .64154 L
.38608 .64314 L
.38222 .64481 L
.38221 .64481 L
.37836 .64653 L
.3745 .64831 L
.37374 .64867 L
.37064 .65016 L
.36677 .65206 L
.36584 .65253 L
.36291 .65403 L
.35905 .65605 L
.35841 .65639 L
.35519 .65814 L
.35137 .66026 L
.35133 .66028 L
.34747 .66249 L
.34468 .66412 L
.34361 .66475 L
.33974 .66708 L
.33828 .66798 L
.33588 .66947 L
.33213 .67184 L
.33202 .67191 L
.32816 .67442 L
.32622 .6757 L
.3243 .67699 L
.32051 .67956 L
.32044 .67962 L
.31657 .6823 L
.31499 .68343 L
.31271 .68505 L
.30963 .68729 L
.30885 .68786 L
.30499 .69073 L
.30443 .69115 L
.30113 .69366 L
.29937 .69501 L
.29727 .69665 L
.29444 .69887 L
.2934 .6997 L
.28963 .70273 L
.28954 .70281 L
.28568 .70598 L
.28494 .7066 L
.28182 .70921 L
.28034 .71046 L
.27796 .7125 L
.27585 .71432 L
.2741 .71585 L
.27145 .71818 L
.27023 .71926 L
.26713 .72204 L
.26637 .72273 L
.2629 .7259 L
.26251 .72626 L
.25874 .72977 L
.25865 .72985 L
.25479 .7335 L
.25465 .73363 L
.25093 .73721 L
.25064 .73749 L
.24707 .74098 L
.24669 .74135 L
.2432 .74481 L
.2428 .74521 L
.23934 .7487 L
.23898 .74907 L
.23548 .75265 L
.23521 .75293 L
.23162 .75666 L
.23149 .7568 L
.22783 .76066 L
.22776 .76073 L
.22422 .76452 L
.2239 .76486 L
.22065 .76838 L
.22003 .76905 L
.21713 .77224 L
.21617 .7733 L
.21366 .7761 L
.21231 .77761 L
.21023 .77997 L
.20845 .78199 L
.20684 .78383 L
.20459 .78641 L
.20349 .78769 L
.20073 .7909 L
.20017 .79155 L
.1969 .79541 L
.19686 .79545 L
.19366 .79927 L
.193 .80006 L
.19046 .80314 L
.18914 .80473 L
.18729 .807 L
.18528 .80946 L
.18415 .81086 L
.18142 .81425 L
.18104 .81472 L
.17797 .81858 L
.17756 .8191 L
.17492 .82244 L
.17369 .82401 L
.1719 .82631 L
.16983 .82897 L
.16891 .83017 L
.16597 .834 L
.16595 .83403 L
.16302 .83789 L
.16211 .84173 L
.15825 .83791 L
.15823 .83789 L
.15439 .83407 L
.15435 .83403 L
.15434 .83017 L
.15053 .82637 L
.15046 .82631 L
.14666 .82253 L
.14658 .82244 L
.1428 .81868 L
.1427 .81858 L
.13894 .81483 L
.13883 .81472 L
.13508 .81098 L
.13496 .81086 L
.13122 .80712 L
.13109 .807 L
.12736 .80326 L
.12723 .80314 L
.12723 .79927 L
.12349 .79554 L
.12336 .79541 L
.11963 .79168 L
.1195 .79155 L
.11577 .78781 L
.11565 .78769 L
.11565 .78383 L
.11191 .78008 L
.1118 .77997 L
.10805 .77621 L
.10795 .7761 L
.10419 .77233 L
.1041 .77224 L
.1041 .76838 L
.10032 .76458 L
.10026 .76452 L
.09646 .7607 L
.09642 .76066 L
.09643 .7568 L
.0926 .75294 L
.09259 .75293 L
.0926 .74908 L
.0926 .74907 L
.09508 .74521 L
.09646 .74275 L
.09726 .74135 L
.09945 .73749 L
.10032 .73595 L
.10165 .73363 L
.10386 .72977 L
.10419 .72921 L
.10609 .7259 L
.10805 .72253 L
.10833 .72204 L
.11058 .71818 L
.11191 .71592 L
.11285 .71432 L
.11513 .71046 L
.11577 .70937 L
.11742 .7066 L
.11963 .70289 L
.11973 .70273 L
.12205 .69887 L
.12349 .69647 L
.12438 .69501 L
.12673 .69115 L
.12736 .69012 L
.12909 .68729 L
.13122 .68383 L
.13147 .68343 L
.13386 .67956 L
.13508 .67761 L
.13627 .6757 L
.1387 .67184 L
.13894 .67145 L
.14114 .66798 L
.1428 .66536 L
.14359 .66412 L
.14607 .66026 L
.14666 .65933 L
.14856 .65639 L
.15053 .65336 L
.15107 .65253 L
.15359 .64867 L
.15439 .64746 L
.15614 .64481 L
.15825 .64163 L
.1587 .64095 L
.16128 .63709 L
.16211 .63586 L
.16389 .63323 L
.16597 .63015 L
.16651 .62936 L
.16915 .6255 L
.16983 .62451 L
.17181 .62164 L
.17369 .61893 L
.1745 .61778 L
.1772 .61392 L
.17756 .61342 L
.17993 .61006 L
.18142 .60797 L
.18268 .60619 L
.18528 .60258 L
.18546 .60233 L
.18826 .59847 L
.18914 .59726 L
.19108 .59461 L
.193 .59201 L
.19393 .59075 L
.19681 .58689 L
.19686 .58681 L
.19971 .58302 L
.20073 .58169 L
.20264 .57916 L
.20459 .57662 L
.2056 .5753 L
.20845 .57162 L
.20859 .57144 L
.21161 .56758 L
.21231 .56669 L
.21466 .56372 L
.21617 .56182 L
.21774 .55985 L
.22003 .55701 L
.22086 .55599 L
.2239 .55227 L
.22401 .55213 L
.22719 .54827 L
.22776 .54759 L
.23041 .54441 L
.23162 .54298 L
.23367 .54055 L
.23548 .53843 L
.23697 .53669 L
.23934 .53394 L
.24031 .53282 L
.2432 .52952 L
.24369 .52896 L
.24707 .52516 L
.24712 .5251 L
.25059 .52124 L
.25093 .52087 L
.25411 .51738 L
.25479 .51664 L
.25768 .51352 L
.25865 .51247 L
.2613 .50965 L
.26251 .50837 L
.26497 .50579 L
.26637 .50433 L
.2687 .50193 L
.27023 .50036 L
.27249 .49807 L
.2741 .49645 L
.27634 .49421 L
.27796 .4926 L
.28025 .49035 L
.28182 .48882 L
.28424 .48648 L
.28568 .4851 L
.28829 .48262 L
.28954 .48145 L
.29243 .47876 L
.2934 .47786 L
.29664 .4749 L
.29727 .47433 L
.30094 .47104 L
.30113 .47087 L
.30499 .46747 L
.30533 .46718 L
.30885 .46414 L
.30981 .46331 L
.31271 .46087 L
.3144 .45945 L
.31657 .45766 L
.31911 .45559 L
.32044 .45452 L
.32393 .45173 L
.3243 .45144 L
.32816 .44842 L
.32888 .44787 L
.33202 .44547 L
.33397 .44401 L
.33588 .44258 L
.33921 .44015 L
.33974 .43976 L
.34361 .437 L
.34462 .43628 L
.34747 .4343 L
.35021 .43242 L
.35133 .43167 L
.35519 .4291 L
.35601 .42856 L
.35905 .42659 L
.36204 .4247 L
.36291 .42415 L
.36677 .42177 L
.36833 .42084 L
.37064 .41946 L
.3745 .41721 L
.37491 .41698 L
.37836 .41502 L
.38183 .41311 L
.38222 .4129 L
.38608 .41084 L
.38914 .40925 L
.38994 .40884 L
.39381 .40691 L
.39694 .40539 L
.39767 .40504 L
.40153 .40324 L
.40532 .40153 L
.40539 .4015 L
.40925 .39982 L
.41311 .39821 L
.41444 .39767 L
.41698 .39665 L
.42084 .39517 L
.42453 .39381 L
.4247 .39374 L
.42856 .39238 L
.43242 .39109 L
.436 .38994 L
.43628 .38986 L
.44015 .38869 L
.44401 .38758 L
.44787 .38654 L
.44964 .38608 L
.45173 .38556 L
.45559 .38465 L
.45945 .38379 L
.46331 .38301 L
.46718 .38228 L
.46752 .38222 L
F
0 g
.47104 .38162 m
.4749 .38102 L
.47876 .38049 L
.48262 .38002 L
.48648 .37961 L
.49035 .37927 L
.49421 .37899 L
.49807 .37877 L
.50193 .37862 L
.50579 .37853 L
.50965 .3785 L
.51352 .37854 L
.51738 .37864 L
.52124 .37881 L
.5251 .37903 L
.52896 .37933 L
.53282 .37968 L
.53669 .3801 L
.54055 .38058 L
.54441 .38112 L
.54827 .38173 L
.55112 .38222 L
.55213 .3824 L
.55599 .38314 L
.55985 .38394 L
.56372 .3848 L
.56758 .38572 L
.56901 .38608 L
.57144 .38671 L
.5753 .38776 L
.57916 .38888 L
.58267 .38994 L
.58302 .39006 L
.58689 .3913 L
.59075 .3926 L
.59415 .39381 L
.59461 .39397 L
.59847 .3954 L
.60233 .3969 L
.60426 .39767 L
.60619 .39846 L
.61006 .40008 L
.61339 .40153 L
.61392 .40176 L
.61778 .40351 L
.62164 .40532 L
.62178 .40539 L
.6255 .4072 L
.62936 .40914 L
.62959 .40925 L
Mistroke
.63323 .41114 L
.63692 .41311 L
.63709 .41321 L
.64095 .41533 L
.64385 .41698 L
.64481 .41753 L
.64867 .41978 L
.65044 .42084 L
.65253 .4221 L
.65639 .42448 L
.65674 .4247 L
.66026 .42693 L
.66278 .42856 L
.66412 .42943 L
.66798 .43201 L
.6686 .43242 L
.67184 .43464 L
.6742 .43628 L
.6757 .43734 L
.67956 .4401 L
.67963 .44015 L
.68343 .44292 L
.68488 .44401 L
.68729 .44581 L
.68999 .44787 L
.69115 .44876 L
.69495 .45173 L
.69501 .45178 L
.69887 .45485 L
.69979 .45559 L
.70273 .458 L
.7045 .45945 L
.7066 .4612 L
.7091 .46331 L
.71046 .46447 L
.7136 .46718 L
.71432 .4678 L
.71801 .47104 L
.71818 .47119 L
.72204 .47465 L
.72232 .4749 L
.7259 .47817 L
.72655 .47876 L
.72977 .48175 L
.73069 .48262 L
.73363 .4854 L
.73476 .48648 L
.73749 .48911 L
.73876 .49035 L
.74135 .49288 L
Mistroke
.74269 .49421 L
.74521 .49672 L
.74655 .49807 L
.74907 .50062 L
.75036 .50193 L
.75293 .50458 L
.7541 .50579 L
.7568 .50861 L
.75779 .50965 L
.76066 .5127 L
.76142 .51352 L
.76452 .51685 L
.765 .51738 L
.76838 .52107 L
.76854 .52124 L
.77202 .5251 L
.77224 .52535 L
.77546 .52896 L
.7761 .52969 L
.77886 .53282 L
.77997 .5341 L
.78221 .53669 L
.78383 .53856 L
.78552 .54055 L
.78769 .5431 L
.7888 .54441 L
.79155 .54769 L
.79203 .54827 L
.79523 .55213 L
.79541 .55235 L
.7984 .55599 L
.79927 .55707 L
.80153 .55985 L
.80314 .56186 L
.80462 .56372 L
.807 .56671 L
.80769 .56758 L
.81072 .57144 L
.81086 .57162 L
.81372 .5753 L
.81472 .57659 L
.8167 .57916 L
.81858 .58163 L
.81964 .58302 L
.82244 .58673 L
.82256 .58689 L
.82545 .59075 L
.82631 .59189 L
.82832 .59461 L
.83017 .59712 L
Mistroke
.83116 .59847 L
.83397 .60233 L
.83403 .60241 L
.83676 .60619 L
.83789 .60777 L
.83953 .61006 L
.84175 .61318 L
.84227 .61392 L
.84499 .61778 L
.84561 .61866 L
.84769 .62164 L
.84947 .62421 L
.85037 .6255 L
.85303 .62936 L
.85334 .62981 L
.85567 .63323 L
.8572 .63548 L
.85828 .63709 L
.86088 .64095 L
.86106 .64122 L
.86346 .64481 L
.86492 .64701 L
.86602 .64867 L
.86856 .65253 L
.86878 .65287 L
.87108 .65639 L
.87264 .65879 L
.87359 .66026 L
.87608 .66412 L
.87651 .66478 L
.87855 .66798 L
.88037 .67083 L
.88101 .67184 L
.88345 .6757 L
.88423 .67694 L
.88587 .67956 L
.88809 .68312 L
.88828 .68343 L
.89068 .68729 L
.89195 .68936 L
.89306 .69115 L
.89542 .69501 L
.89581 .69566 L
.89777 .69887 L
.89968 .70202 L
.90011 .70273 L
.90243 .7066 L
.90354 .70845 L
.90474 .71046 L
.90703 .71432 L
Mistroke
.9074 .71494 L
.90931 .71818 L
.91126 .7215 L
.91158 .72204 L
.91384 .7259 L
.91512 .72811 L
.91894 .72977 L
.91897 .73363 L
.91515 .73749 L
.91517 .74135 L
.91512 .7414 L
.91134 .74521 L
.91126 .74529 L
.9075 .74907 L
.90751 .75293 L
.9074 .75305 L
.90367 .7568 L
.90368 .76066 L
.90354 .7608 L
.89984 .76452 L
.89968 .76468 L
.89599 .76838 L
.896 .77224 L
.89581 .77243 L
.89215 .7761 L
.89195 .7763 L
.8883 .77997 L
.88809 .78017 L
.88444 .78383 L
.88444 .78769 L
.88423 .7879 L
.88059 .79155 L
.88037 .79177 L
.87673 .79541 L
.87651 .79563 L
.87286 .79927 L
.87286 .80314 L
.87264 .80335 L
.86899 .807 L
.86878 .80721 L
.86513 .81086 L
.86492 .81106 L
.86126 .81472 L
.86106 .81492 L
.85738 .81858 L
.8572 .81877 L
.85351 .82244 L
.85334 .82261 L
.84963 .82631 L
.84947 .82646 L
Mistroke
.84575 .83017 L
.84574 .83403 L
.84561 .83416 L
.84186 .83789 L
.84175 .838 L
.83797 .84175 L
.83789 .84183 L
.83408 .84561 L
.83403 .84567 L
.83017 .84565 L
.82631 .84947 L
.82631 .84948 L
.82251 .84947 L
.82244 .84578 L
.82232 .84561 L
.81945 .84175 L
.81858 .84059 L
.81656 .83789 L
.81472 .83545 L
.81364 .83403 L
.81086 .83038 L
.8107 .83017 L
.80773 .82631 L
.807 .82536 L
.80473 .82244 L
.80314 .82041 L
.8017 .81858 L
.79927 .81552 L
.79864 .81472 L
.79555 .81086 L
.79541 .81069 L
.79243 .807 L
.79155 .80592 L
.78928 .80314 L
.78769 .80121 L
.78609 .79927 L
.78383 .79656 L
.78287 .79541 L
.77997 .79197 L
.77961 .79155 L
.77632 .78769 L
.7761 .78744 L
.77298 .78383 L
.77224 .78298 L
.76961 .77997 L
.76838 .77857 L
.7662 .7761 L
.76452 .77423 L
.76274 .77224 L
.76066 .76994 L
Mistroke
.75924 .76838 L
.7568 .76572 L
.75569 .76452 L
.75293 .76156 L
.75209 .76066 L
.74907 .75746 L
.74845 .7568 L
.74521 .75341 L
.74475 .75293 L
.74135 .74944 L
.741 .74907 L
.73749 .74552 L
.73719 .74521 L
.73363 .74166 L
.73332 .74135 L
.72977 .73786 L
.72938 .73749 L
.7259 .73413 L
.72538 .73363 L
.72204 .73045 L
.72132 .72977 L
.71818 .72684 L
.71717 .7259 L
.71432 .72328 L
.71296 .72204 L
.71046 .71979 L
.70866 .71818 L
.7066 .71636 L
.70427 .71432 L
.70273 .71298 L
.69979 .71046 L
.69887 .70967 L
.69522 .7066 L
.69501 .70642 L
.69115 .70324 L
.69054 .70273 L
.68729 .70011 L
.68574 .69887 L
.68343 .69704 L
.68083 .69501 L
.67956 .69403 L
.67578 .69115 L
.6757 .69109 L
.67184 .6882 L
.6706 .68729 L
.66798 .68538 L
.66526 .68343 L
.66412 .68261 L
.66026 .67991 L
.65975 .67956 L
Mistroke
.65639 .67727 L
.65406 .6757 L
.65253 .67469 L
.64867 .67217 L
.64816 .67184 L
.64481 .66971 L
.64204 .66798 L
.64095 .66731 L
.63709 .66497 L
.63565 .66412 L
.63323 .6627 L
.62936 .66048 L
.62897 .66026 L
.6255 .65832 L
.62195 .65639 L
.62164 .65623 L
.61778 .65419 L
.61454 .65253 L
.61392 .65222 L
.61006 .65031 L
.60665 .64867 L
.60619 .64846 L
.60233 .64666 L
.59847 .64493 L
.59819 .64481 L
.59461 .64326 L
.59075 .64165 L
.589 .64095 L
.58689 .64011 L
.58302 .63862 L
.57916 .63719 L
.57887 .63709 L
.5753 .63583 L
.57144 .63452 L
.56758 .63328 L
.56742 .63323 L
.56372 .63209 L
.55985 .63097 L
.55599 .6299 L
.55394 .62936 L
.55213 .6289 L
.54827 .62796 L
.54441 .62708 L
.54055 .62626 L
.53669 .6255 L
.53669 .6255 L
.53282 .6248 L
.52896 .62416 L
.5251 .62359 L
.52124 .62307 L
Mistroke
.51738 .62261 L
.51352 .62222 L
.50965 .62188 L
.50629 .62164 L
.50579 .62161 L
.50193 .6214 L
.49807 .62124 L
.49421 .62115 L
.49035 .62112 L
.48648 .62115 L
.48262 .62124 L
.47876 .62139 L
.4749 .6216 L
.47421 .62164 L
.47104 .62187 L
.46718 .6222 L
.46331 .62259 L
.45945 .62304 L
.45559 .62356 L
.45173 .62413 L
.44787 .62477 L
.44401 .62546 L
.44379 .6255 L
.44015 .62622 L
.43628 .62703 L
.43242 .62791 L
.42856 .62885 L
.42653 .62936 L
.4247 .62984 L
.42084 .6309 L
.41698 .63202 L
.41311 .6332 L
.41303 .63323 L
.40925 .63444 L
.40539 .63574 L
.40156 .63709 L
.40153 .6371 L
.39767 .63852 L
.39381 .64 L
.39141 .64095 L
.38994 .64154 L
.38608 .64314 L
.38222 .64481 L
.38221 .64481 L
.37836 .64653 L
.3745 .64831 L
.37374 .64867 L
.37064 .65016 L
.36677 .65206 L
.36584 .65253 L
Mistroke
.36291 .65403 L
.35905 .65605 L
.35841 .65639 L
.35519 .65814 L
.35137 .66026 L
.35133 .66028 L
.34747 .66249 L
.34468 .66412 L
.34361 .66475 L
.33974 .66708 L
.33828 .66798 L
.33588 .66947 L
.33213 .67184 L
.33202 .67191 L
.32816 .67442 L
.32622 .6757 L
.3243 .67699 L
.32051 .67956 L
.32044 .67962 L
.31657 .6823 L
.31499 .68343 L
.31271 .68505 L
.30963 .68729 L
.30885 .68786 L
.30499 .69073 L
.30443 .69115 L
.30113 .69366 L
.29937 .69501 L
.29727 .69665 L
.29444 .69887 L
.2934 .6997 L
.28963 .70273 L
.28954 .70281 L
.28568 .70598 L
.28494 .7066 L
.28182 .70921 L
.28034 .71046 L
.27796 .7125 L
.27585 .71432 L
.2741 .71585 L
.27145 .71818 L
.27023 .71926 L
.26713 .72204 L
.26637 .72273 L
.2629 .7259 L
.26251 .72626 L
.25874 .72977 L
.25865 .72985 L
.25479 .7335 L
.25465 .73363 L
Mistroke
.25093 .73721 L
.25064 .73749 L
.24707 .74098 L
.24669 .74135 L
.2432 .74481 L
.2428 .74521 L
.23934 .7487 L
.23898 .74907 L
.23548 .75265 L
.23521 .75293 L
.23162 .75666 L
.23149 .7568 L
.22783 .76066 L
.22776 .76073 L
.22422 .76452 L
.2239 .76486 L
.22065 .76838 L
.22003 .76905 L
.21713 .77224 L
.21617 .7733 L
.21366 .7761 L
.21231 .77761 L
.21023 .77997 L
.20845 .78199 L
.20684 .78383 L
.20459 .78641 L
.20349 .78769 L
.20073 .7909 L
.20017 .79155 L
.1969 .79541 L
.19686 .79545 L
.19366 .79927 L
.193 .80006 L
.19046 .80314 L
.18914 .80473 L
.18729 .807 L
.18528 .80946 L
.18415 .81086 L
.18142 .81425 L
.18104 .81472 L
.17797 .81858 L
.17756 .8191 L
.17492 .82244 L
.17369 .82401 L
.1719 .82631 L
.16983 .82897 L
.16891 .83017 L
.16597 .834 L
.16595 .83403 L
.16302 .83789 L
Mistroke
.16211 .84173 L
.15825 .83791 L
.15823 .83789 L
.15439 .83407 L
.15435 .83403 L
.15434 .83017 L
.15053 .82637 L
.15046 .82631 L
.14666 .82253 L
.14658 .82244 L
.1428 .81868 L
.1427 .81858 L
.13894 .81483 L
.13883 .81472 L
.13508 .81098 L
.13496 .81086 L
.13122 .80712 L
.13109 .807 L
.12736 .80326 L
.12723 .80314 L
.12723 .79927 L
.12349 .79554 L
.12336 .79541 L
.11963 .79168 L
.1195 .79155 L
.11577 .78781 L
.11565 .78769 L
.11565 .78383 L
.11191 .78008 L
.1118 .77997 L
.10805 .77621 L
.10795 .7761 L
.10419 .77233 L
.1041 .77224 L
.1041 .76838 L
.10032 .76458 L
.10026 .76452 L
.09646 .7607 L
.09642 .76066 L
.09643 .7568 L
.0926 .75294 L
.09259 .75293 L
.0926 .74908 L
.0926 .74907 L
.09508 .74521 L
.09646 .74275 L
.09726 .74135 L
.09945 .73749 L
.10032 .73595 L
.10165 .73363 L
Mistroke
.10386 .72977 L
.10419 .72921 L
.10609 .7259 L
.10805 .72253 L
.10833 .72204 L
.11058 .71818 L
.11191 .71592 L
.11285 .71432 L
.11513 .71046 L
.11577 .70937 L
.11742 .7066 L
.11963 .70289 L
.11973 .70273 L
.12205 .69887 L
.12349 .69647 L
.12438 .69501 L
.12673 .69115 L
.12736 .69012 L
.12909 .68729 L
.13122 .68383 L
.13147 .68343 L
.13386 .67956 L
.13508 .67761 L
.13627 .6757 L
.1387 .67184 L
.13894 .67145 L
.14114 .66798 L
.1428 .66536 L
.14359 .66412 L
.14607 .66026 L
.14666 .65933 L
.14856 .65639 L
.15053 .65336 L
.15107 .65253 L
.15359 .64867 L
.15439 .64746 L
.15614 .64481 L
.15825 .64163 L
.1587 .64095 L
.16128 .63709 L
.16211 .63586 L
.16389 .63323 L
.16597 .63015 L
.16651 .62936 L
.16915 .6255 L
.16983 .62451 L
.17181 .62164 L
.17369 .61893 L
.1745 .61778 L
.1772 .61392 L
Mistroke
.17756 .61342 L
.17993 .61006 L
.18142 .60797 L
.18268 .60619 L
.18528 .60258 L
.18546 .60233 L
.18826 .59847 L
.18914 .59726 L
.19108 .59461 L
.193 .59201 L
.19393 .59075 L
.19681 .58689 L
.19686 .58681 L
.19971 .58302 L
.20073 .58169 L
.20264 .57916 L
.20459 .57662 L
.2056 .5753 L
.20845 .57162 L
.20859 .57144 L
.21161 .56758 L
.21231 .56669 L
.21466 .56372 L
.21617 .56182 L
.21774 .55985 L
.22003 .55701 L
.22086 .55599 L
.2239 .55227 L
.22401 .55213 L
.22719 .54827 L
.22776 .54759 L
.23041 .54441 L
.23162 .54298 L
.23367 .54055 L
.23548 .53843 L
.23697 .53669 L
.23934 .53394 L
.24031 .53282 L
.2432 .52952 L
.24369 .52896 L
.24707 .52516 L
.24712 .5251 L
.25059 .52124 L
.25093 .52087 L
.25411 .51738 L
.25479 .51664 L
.25768 .51352 L
.25865 .51247 L
.2613 .50965 L
.26251 .50837 L
Mistroke
.26497 .50579 L
.26637 .50433 L
.2687 .50193 L
.27023 .50036 L
.27249 .49807 L
.2741 .49645 L
.27634 .49421 L
.27796 .4926 L
.28025 .49035 L
.28182 .48882 L
.28424 .48648 L
.28568 .4851 L
.28829 .48262 L
.28954 .48145 L
.29243 .47876 L
.2934 .47786 L
.29664 .4749 L
.29727 .47433 L
.30094 .47104 L
.30113 .47087 L
.30499 .46747 L
.30533 .46718 L
.30885 .46414 L
.30981 .46331 L
.31271 .46087 L
.3144 .45945 L
.31657 .45766 L
.31911 .45559 L
.32044 .45452 L
.32393 .45173 L
.3243 .45144 L
.32816 .44842 L
.32888 .44787 L
.33202 .44547 L
.33397 .44401 L
.33588 .44258 L
.33921 .44015 L
.33974 .43976 L
.34361 .437 L
.34462 .43628 L
.34747 .4343 L
.35021 .43242 L
.35133 .43167 L
.35519 .4291 L
.35601 .42856 L
.35905 .42659 L
.36204 .4247 L
.36291 .42415 L
.36677 .42177 L
.36833 .42084 L
Mistroke
.37064 .41946 L
.3745 .41721 L
.37491 .41698 L
.37836 .41502 L
.38183 .41311 L
.38222 .4129 L
.38608 .41084 L
.38914 .40925 L
.38994 .40884 L
.39381 .40691 L
.39694 .40539 L
.39767 .40504 L
.40153 .40324 L
.40532 .40153 L
.40539 .4015 L
.40925 .39982 L
.41311 .39821 L
.41444 .39767 L
.41698 .39665 L
.42084 .39517 L
.42453 .39381 L
.4247 .39374 L
.42856 .39238 L
.43242 .39109 L
.436 .38994 L
.43628 .38986 L
.44015 .38869 L
.44401 .38758 L
.44787 .38654 L
.44964 .38608 L
.45173 .38556 L
.45559 .38465 L
.45945 .38379 L
.46331 .38301 L
.46718 .38228 L
.46752 .38222 L
.47104 .38162 L
Mfstroke
1 .591 .5 r
.49035 .4012 m
.49421 .40088 L
.49807 .40063 L
.50193 .40045 L
.50579 .40032 L
.50965 .40027 L
.51352 .40027 L
.51738 .40034 L
.52124 .40047 L
.5251 .40067 L
.52896 .40093 L
.53282 .40125 L
.53564 .40153 L
.53669 .40164 L
.54055 .40209 L
.54441 .40261 L
.54827 .40319 L
.55213 .40383 L
.55599 .40454 L
.55985 .40531 L
.56025 .40539 L
.56372 .40614 L
.56758 .40704 L
.57144 .408 L
.5753 .40903 L
.57612 .40925 L
.57916 .41012 L
.58302 .41127 L
.58689 .41249 L
.5888 .41311 L
.59075 .41377 L
.59461 .41511 L
.59847 .41652 L
.59969 .41698 L
.60233 .41799 L
.60619 .41952 L
.60938 .42084 L
.61006 .42112 L
.61392 .42278 L
.61778 .42451 L
.61819 .4247 L
.62164 .4263 L
.6255 .42815 L
.62633 .42856 L
.62936 .43007 L
.63323 .43205 L
.63394 .43242 L
.63709 .43409 L
.64095 .4362 L
.6411 .43628 L
.64481 .43837 L
.64788 .44015 L
.64867 .44061 L
.65253 .44291 L
.65435 .44401 L
.65639 .44527 L
.66026 .44769 L
.66053 .44787 L
.66412 .45018 L
.66647 .45173 L
.66798 .45274 L
.67184 .45535 L
.67219 .45559 L
.6757 .45803 L
.67771 .45945 L
.67956 .46078 L
.68306 .46331 L
.68343 .46358 L
.68729 .46645 L
.68825 .46718 L
.69115 .46939 L
.69329 .47104 L
.69501 .47238 L
.69819 .4749 L
.69887 .47545 L
.70273 .47857 L
.70297 .47876 L
.7066 .48176 L
.70763 .48262 L
.71046 .48501 L
.71218 .48648 L
.71432 .48832 L
.71664 .49035 L
.71818 .4917 L
.721 .49421 L
.72204 .49515 L
.72527 .49807 L
.7259 .49865 L
.72945 .50193 L
.72977 .50222 L
.73356 .50579 L
.73363 .50585 L
.73749 .50955 L
.7376 .50965 L
.74135 .51331 L
.74156 .51352 L
.74521 .51713 L
.74546 .51738 L
.74907 .52102 L
.74929 .52124 L
.75293 .52497 L
.75306 .5251 L
.75678 .52896 L
.7568 .52898 L
.76044 .53282 L
.76066 .53306 L
.76404 .53669 L
.76452 .5372 L
.7676 .54055 L
.76838 .5414 L
.77111 .54441 L
.77224 .54567 L
.77457 .54827 L
.7761 .55 L
.77798 .55213 L
.77997 .5544 L
.78136 .55599 L
.78383 .55885 L
.78469 .55985 L
.78769 .56338 L
.78798 .56372 L
.79123 .56758 L
.79155 .56796 L
.79445 .57144 L
.79541 .57261 L
.79763 .5753 L
.79927 .57732 L
.80077 .57916 L
.80314 .58209 L
.80388 .58302 L
.80696 .58689 L
.807 .58693 L
.81001 .59075 L
.81086 .59183 L
.81302 .59461 L
.81472 .5968 L
.81601 .59847 L
.81858 .60183 L
.81897 .60233 L
.8219 .60619 L
.82244 .60692 L
.8248 .61006 L
.82631 .61208 L
.82767 .61392 L
.83017 .6173 L
.83052 .61778 L
.83335 .62164 L
.83403 .62258 L
.83615 .6255 L
.83789 .62792 L
.83892 .62936 L
.84167 .63323 L
.84175 .63333 L
.8444 .63709 L
.84561 .63881 L
.84711 .64095 L
.84947 .64434 L
.8498 .64481 L
.85246 .64867 L
.85334 .64994 L
.85511 .65253 L
.8572 .6556 L
.85773 .65639 L
.86034 .66026 L
.86106 .66133 L
.86292 .66412 L
.86492 .66712 L
.86549 .66798 L
.86804 .67184 L
.86878 .67297 L
.87057 .6757 L
.87264 .67889 L
.87308 .67956 L
.87558 .68343 L
.87651 .68487 L
.87806 .68729 L
.88037 .69091 L
.88052 .69115 L
.88296 .69501 L
.88423 .69702 L
.88539 .69887 L
.88781 .70273 L
.88809 .70319 L
.89021 .7066 L
.89195 .70942 L
.89259 .71046 L
.89496 .71432 L
.89581 .71572 L
.89731 .71818 L
.89965 .72204 L
.89968 .72208 L
.90198 .7259 L
.90354 .72851 L
.90429 .72977 L
.90659 .73363 L
.9074 .73499 L
.90887 .73749 L
.91115 .74135 L
.91126 .74135 L
.91127 .74521 L
.91126 .74522 L
.90744 .74907 L
.90745 .75293 L
.9074 .75298 L
.90361 .7568 L
.90362 .76066 L
.90354 .76074 L
.89978 .76452 L
.89968 .76462 L
.89593 .76838 L
.89594 .77224 L
.89581 .77237 L
.89209 .7761 L
.89195 .77624 L
.88824 .77997 L
.88809 .78011 L
.88438 .78383 L
.88438 .78769 L
.88423 .78784 L
.88052 .79155 L
.88037 .79171 L
.87666 .79541 L
.87651 .79557 L
.8728 .79927 L
.8728 .80314 L
.87264 .80329 L
.86893 .807 L
.86878 .80715 L
.86506 .81086 L
.86492 .811 L
.86119 .81472 L
.86106 .81485 L
.85732 .81858 L
.8572 .8187 L
.85344 .82244 L
.85334 .82255 L
.84957 .82631 L
.84947 .8264 L
.84569 .83017 L
.84568 .83403 L
.84561 .83409 L
.84179 .83789 L
.84175 .83793 L
.83791 .84175 L
.83789 .84177 L
.83403 .84175 L
.83403 .84157 L
.83139 .83789 L
.83017 .83619 L
.82861 .83403 L
.82631 .83086 L
.8258 .83017 L
.82297 .82631 L
.82244 .82559 L
.82011 .82244 L
.81858 .82039 L
.81723 .81858 L
.81472 .81524 L
.81433 .81472 L
.81139 .81086 L
.81086 .81016 L
.80843 .807 L
.807 .80514 L
.80545 .80314 L
.80314 .80017 L
.80243 .79927 L
.79939 .79541 L
.79927 .79527 L
.79631 .79155 L
.79541 .79043 L
.79321 .78769 L
.79155 .78565 L
.79007 .78383 L
.78769 .78093 L
.7869 .77997 L
.78383 .77627 L
.78369 .7761 L
.78045 .77224 L
.77997 .77167 L
.77717 .76838 L
.7761 .76713 L
.77386 .76452 L
.77224 .76265 L
.77051 .76066 L
.76838 .75823 L
.76711 .7568 L
.76452 .75388 L
.76368 .75293 L
.76066 .74958 L
.7602 .74907 L
.7568 .74535 L
.75667 .74521 L
.7531 .74135 L
.75293 .74117 L
.74948 .73749 L
.74907 .73706 L
.74581 .73363 L
.74521 .733 L
.74208 .72977 L
.74135 .72901 L
.7383 .7259 L
.73749 .72508 L
.73447 .72204 L
.73363 .72121 L
.73057 .71818 L
.72977 .71739 L
.7266 .71432 L
.7259 .71364 L
.72257 .71046 L
.72204 .70995 L
.71847 .7066 L
.71818 .70632 L
.71432 .70275 L
.7143 .70273 L
.71046 .69925 L
.71004 .69887 L
.7066 .6958 L
.7057 .69501 L
.70273 .69241 L
.70128 .69115 L
.69887 .68908 L
.69676 .68729 L
.69501 .68582 L
.69214 .68343 L
.69115 .68261 L
.68741 .67956 L
.68729 .67947 L
.68343 .67638 L
.68257 .6757 L
.67956 .67336 L
.6776 .67184 L
.6757 .67039 L
.6725 .66798 L
.67184 .66749 L
.66798 .66465 L
.66725 .66412 L
.66412 .66187 L
.66185 .66026 L
.66026 .65914 L
.65639 .65648 L
.65627 .65639 L
.65253 .65388 L
.65049 .65253 L
.64867 .65134 L
.64481 .64886 L
.64451 .64867 L
.64095 .64644 L
.63829 .64481 L
.63709 .64408 L
.63323 .64179 L
.63179 .64095 L
.62936 .63955 L
.6255 .63737 L
.62499 .63709 L
.62164 .63525 L
.61783 .63323 L
.61778 .6332 L
.61392 .6312 L
.61026 .62936 L
.61006 .62926 L
.60619 .62739 L
.60233 .62557 L
.60218 .6255 L
.59847 .62382 L
.59461 .62213 L
.59348 .62164 L
.59075 .62049 L
.58689 .61892 L
.58399 .61778 L
.58302 .61741 L
.57916 .61595 L
.5753 .61456 L
.57346 .61392 L
.57144 .61323 L
.56758 .61196 L
.56372 .61075 L
.56142 .61006 L
.55985 .6096 L
.55599 .60851 L
.55213 .60747 L
.54827 .60651 L
.54698 .60619 L
.54441 .6056 L
.54055 .60475 L
.53669 .60396 L
.53282 .60323 L
.52896 .60256 L
.52756 .60233 L
.5251 .60195 L
.52124 .6014 L
.51738 .60092 L
.51352 .60049 L
.50965 .60012 L
.50579 .59981 L
.50193 .59957 L
.49807 .59938 L
.49421 .59925 L
.49035 .59919 L
.48648 .59918 L
.48262 .59924 L
.47876 .59935 L
.4749 .59952 L
.47104 .59976 L
.46718 .60005 L
.46331 .60041 L
.45945 .60082 L
.45559 .6013 L
.45173 .60183 L
.44846 .60233 L
.44787 .60243 L
.44401 .60308 L
.44015 .6038 L
.43628 .60457 L
.43242 .60541 L
.42901 .60619 L
.42856 .6063 L
.4247 .60726 L
.42084 .60827 L
.41698 .60935 L
.41453 .61006 L
.41311 .61048 L
.40925 .61167 L
.40539 .61293 L
.40247 .61392 L
.40153 .61424 L
.39767 .61562 L
.39381 .61705 L
.3919 .61778 L
.38994 .61854 L
.38608 .6201 L
.38239 .62164 L
.38222 .62171 L
.37836 .62338 L
.3745 .62512 L
.37366 .6255 L
.37064 .62691 L
.36677 .62876 L
.36554 .62936 L
.36291 .63067 L
.35905 .63264 L
.35794 .63323 L
.35519 .63468 L
.35133 .63677 L
.35075 .63709 L
.34747 .63892 L
.34391 .64095 L
.34361 .64113 L
.33974 .6434 L
.33739 .64481 L
.33588 .64573 L
.33202 .64811 L
.33113 .64867 L
.32816 .65056 L
.32512 .65253 L
.3243 .65307 L
.32044 .65564 L
.31931 .65639 L
.31657 .65826 L
.3137 .66026 L
.31271 .66095 L
.30885 .66369 L
.30826 .66412 L
.30499 .6665 L
.30298 .66798 L
.30113 .66936 L
.29785 .67184 L
.29727 .67228 L
.2934 .67527 L
.29285 .6757 L
.28954 .67831 L
.28797 .67956 L
.28568 .68141 L
.28321 .68343 L
.28182 .68457 L
.27855 .68729 L
.27796 .68779 L
.2741 .69107 L
.274 .69115 L
.27023 .6944 L
.26954 .69501 L
.26637 .6978 L
.26517 .69887 L
.26251 .70125 L
.26088 .70273 L
.25865 .70477 L
.25667 .7066 L
.25479 .70834 L
.25253 .71046 L
.25093 .71197 L
.24847 .71432 L
.24707 .71566 L
.24447 .71818 L
.2432 .71941 L
.24053 .72204 L
.23934 .72322 L
.23666 .7259 L
.23548 .72709 L
.23284 .72977 L
.23162 .73102 L
.22908 .73363 L
.22776 .735 L
.22537 .73749 L
.2239 .73904 L
.22172 .74135 L
.22003 .74314 L
.21811 .74521 L
.21617 .7473 L
.21455 .74907 L
.21231 .75152 L
.21103 .75293 L
.20845 .7558 L
.20756 .7568 L
.20459 .76013 L
.20412 .76066 L
.20073 .76452 L
.20073 .76453 L
.19738 .76838 L
.19686 .76898 L
.19407 .77224 L
.193 .77349 L
.19079 .7761 L
.18914 .77806 L
.18754 .77997 L
.18528 .78268 L
.18433 .78383 L
.18142 .78737 L
.18115 .78769 L
.17801 .79155 L
.17756 .79211 L
.17489 .79541 L
.17369 .79691 L
.17181 .79927 L
.16983 .80177 L
.16875 .80314 L
.16597 .80668 L
.16573 .807 L
.16273 .81086 L
.16211 .81166 L
.15975 .81472 L
.15825 .81669 L
.1568 .81858 L
.15439 .82177 L
.15388 .82244 L
.15434 .82631 L
.15053 .82631 L
.15052 .82631 L
.14666 .82246 L
.14665 .82244 L
.1428 .81861 L
.14277 .81858 L
.13894 .81476 L
.1389 .81472 L
.13508 .81091 L
.13503 .81086 L
.13122 .80706 L
.13116 .807 L
.12736 .8032 L
.12729 .80314 L
.12729 .79927 L
.12349 .79548 L
.12343 .79541 L
.11963 .79161 L
.11957 .79155 L
.11577 .78775 L
.11571 .78769 L
.11571 .78383 L
.11191 .78001 L
.11186 .77997 L
.10805 .77614 L
.10801 .7761 L
.10419 .77227 L
.10416 .77224 L
.10417 .76838 L
.10033 .76452 L
.10305 .76066 L
.10419 .75863 L
.10522 .7568 L
.10741 .75293 L
.10805 .7518 L
.1096 .74907 L
.11181 .74521 L
.11191 .74504 L
.11404 .74135 L
.11577 .73835 L
.11627 .73749 L
.11852 .73363 L
.11963 .73173 L
.12078 .72977 L
.12306 .7259 L
.12349 .72517 L
.12535 .72204 L
.12736 .71868 L
.12765 .71818 L
.12997 .71432 L
.13122 .71226 L
.13231 .71046 L
.13466 .7066 L
.13508 .7059 L
.13702 .70273 L
.13894 .69961 L
.1394 .69887 L
.14179 .69501 L
.1428 .69339 L
.14421 .69115 L
.14663 .68729 L
.14666 .68724 L
.14908 .68343 L
.15053 .68115 L
.15154 .67956 L
.15402 .6757 L
.15439 .67513 L
.15652 .67184 L
.15825 .66918 L
.15903 .66798 L
.16156 .66412 L
.16211 .66329 L
.16412 .66026 L
.16597 .65747 L
.16669 .65639 L
.16928 .65253 L
.16983 .65172 L
.17189 .64867 L
.17369 .64603 L
.17453 .64481 L
.17718 .64095 L
.17756 .64041 L
.17986 .63709 L
.18142 .63485 L
.18256 .63323 L
.18528 .62936 L
.18528 .62936 L
.18802 .6255 L
.18914 .62394 L
.19079 .62164 L
.193 .61858 L
.19358 .61778 L
.1964 .61392 L
.19686 .61329 L
.19925 .61006 L
.20073 .60806 L
.20212 .60619 L
.20459 .6029 L
.20502 .60233 L
.20794 .59847 L
.20845 .59781 L
.2109 .59461 L
.21231 .59278 L
.21389 .59075 L
.21617 .58782 L
.2169 .58689 L
.21995 .58302 L
.22003 .58292 L
.22303 .57916 L
.2239 .57809 L
.22615 .5753 L
.22776 .57332 L
.2293 .57144 L
.23162 .56862 L
.23248 .56758 L
.23548 .56399 L
.23571 .56372 L
.23897 .55985 L
.23934 .55942 L
.24227 .55599 L
.2432 .55491 L
.24562 .55213 L
.24707 .55048 L
.24901 .54827 L
.25093 .5461 L
.25244 .54441 L
.25479 .54179 L
.25592 .54055 L
.25865 .53755 L
.25944 .53669 L
.26251 .53337 L
.26302 .53282 L
.26637 .52926 L
.26665 .52896 L
.27023 .52521 L
.27034 .5251 L
.27409 .52124 L
.2741 .52123 L
.27789 .51738 L
.27796 .51731 L
.28176 .51352 L
.28182 .51346 L
.28568 .50967 L
.2857 .50965 L
.28954 .50595 L
.2897 .50579 L
.2934 .50229 L
.29379 .50193 L
.29727 .4987 L
.29795 .49807 L
.30113 .49517 L
.30219 .49421 L
.30499 .4917 L
.30652 .49035 L
.30885 .4883 L
.31095 .48648 L
.31271 .48497 L
.31548 .48262 L
.31657 .4817 L
.32011 .47876 L
.32044 .4785 L
.3243 .47536 L
.32487 .4749 L
.32816 .47228 L
.32974 .47104 L
.33202 .46927 L
.33476 .46718 L
.33588 .46632 L
.33974 .46344 L
.33992 .46331 L
.34361 .46062 L
.34524 .45945 L
.34747 .45787 L
.35074 .45559 L
.35133 .45518 L
.35519 .45256 L
.35643 .45173 L
.35905 .45 L
.36234 .44787 L
.36291 .44751 L
.36677 .44507 L
.3685 .44401 L
.37064 .44271 L
.3745 .44041 L
.37494 .44015 L
.37836 .43817 L
.3817 .43628 L
.38222 .436 L
.38608 .43389 L
.38884 .43242 L
.38994 .43184 L
.39381 .42986 L
.39642 .42856 L
.39767 .42795 L
.40153 .42609 L
.40453 .4247 L
.40539 .42431 L
.40925 .42258 L
.41311 .42093 L
.41332 .42084 L
.41698 .41933 L
.42084 .4178 L
.42298 .41698 L
.4247 .41633 L
.42856 .41493 L
.43242 .41359 L
.43385 .41311 L
.43628 .41232 L
.44015 .41111 L
.44401 .40996 L
.44651 .40925 L
.44787 .40888 L
.45173 .40786 L
.45559 .40691 L
.45945 .40602 L
.46235 .40539 L
.46331 .40519 L
.46718 .40443 L
.47104 .40373 L
.4749 .4031 L
.47876 .40253 L
.48262 .40202 L
.48648 .40158 L
.48694 .40153 L
F
0 g
.49035 .4012 m
.49421 .40088 L
.49807 .40063 L
.50193 .40045 L
.50579 .40032 L
.50965 .40027 L
.51352 .40027 L
.51738 .40034 L
.52124 .40047 L
.5251 .40067 L
.52896 .40093 L
.53282 .40125 L
.53564 .40153 L
.53669 .40164 L
.54055 .40209 L
.54441 .40261 L
.54827 .40319 L
.55213 .40383 L
.55599 .40454 L
.55985 .40531 L
.56025 .40539 L
.56372 .40614 L
.56758 .40704 L
.57144 .408 L
.5753 .40903 L
.57612 .40925 L
.57916 .41012 L
.58302 .41127 L
.58689 .41249 L
.5888 .41311 L
.59075 .41377 L
.59461 .41511 L
.59847 .41652 L
.59969 .41698 L
.60233 .41799 L
.60619 .41952 L
.60938 .42084 L
.61006 .42112 L
.61392 .42278 L
.61778 .42451 L
.61819 .4247 L
.62164 .4263 L
.6255 .42815 L
.62633 .42856 L
.62936 .43007 L
.63323 .43205 L
.63394 .43242 L
.63709 .43409 L
.64095 .4362 L
.6411 .43628 L
Mistroke
.64481 .43837 L
.64788 .44015 L
.64867 .44061 L
.65253 .44291 L
.65435 .44401 L
.65639 .44527 L
.66026 .44769 L
.66053 .44787 L
.66412 .45018 L
.66647 .45173 L
.66798 .45274 L
.67184 .45535 L
.67219 .45559 L
.6757 .45803 L
.67771 .45945 L
.67956 .46078 L
.68306 .46331 L
.68343 .46358 L
.68729 .46645 L
.68825 .46718 L
.69115 .46939 L
.69329 .47104 L
.69501 .47238 L
.69819 .4749 L
.69887 .47545 L
.70273 .47857 L
.70297 .47876 L
.7066 .48176 L
.70763 .48262 L
.71046 .48501 L
.71218 .48648 L
.71432 .48832 L
.71664 .49035 L
.71818 .4917 L
.721 .49421 L
.72204 .49515 L
.72527 .49807 L
.7259 .49865 L
.72945 .50193 L
.72977 .50222 L
.73356 .50579 L
.73363 .50585 L
.73749 .50955 L
.7376 .50965 L
.74135 .51331 L
.74156 .51352 L
.74521 .51713 L
.74546 .51738 L
.74907 .52102 L
.74929 .52124 L
Mistroke
.75293 .52497 L
.75306 .5251 L
.75678 .52896 L
.7568 .52898 L
.76044 .53282 L
.76066 .53306 L
.76404 .53669 L
.76452 .5372 L
.7676 .54055 L
.76838 .5414 L
.77111 .54441 L
.77224 .54567 L
.77457 .54827 L
.7761 .55 L
.77798 .55213 L
.77997 .5544 L
.78136 .55599 L
.78383 .55885 L
.78469 .55985 L
.78769 .56338 L
.78798 .56372 L
.79123 .56758 L
.79155 .56796 L
.79445 .57144 L
.79541 .57261 L
.79763 .5753 L
.79927 .57732 L
.80077 .57916 L
.80314 .58209 L
.80388 .58302 L
.80696 .58689 L
.807 .58693 L
.81001 .59075 L
.81086 .59183 L
.81302 .59461 L
.81472 .5968 L
.81601 .59847 L
.81858 .60183 L
.81897 .60233 L
.8219 .60619 L
.82244 .60692 L
.8248 .61006 L
.82631 .61208 L
.82767 .61392 L
.83017 .6173 L
.83052 .61778 L
.83335 .62164 L
.83403 .62258 L
.83615 .6255 L
.83789 .62792 L
Mistroke
.83892 .62936 L
.84167 .63323 L
.84175 .63333 L
.8444 .63709 L
.84561 .63881 L
.84711 .64095 L
.84947 .64434 L
.8498 .64481 L
.85246 .64867 L
.85334 .64994 L
.85511 .65253 L
.8572 .6556 L
.85773 .65639 L
.86034 .66026 L
.86106 .66133 L
.86292 .66412 L
.86492 .66712 L
.86549 .66798 L
.86804 .67184 L
.86878 .67297 L
.87057 .6757 L
.87264 .67889 L
.87308 .67956 L
.87558 .68343 L
.87651 .68487 L
.87806 .68729 L
.88037 .69091 L
.88052 .69115 L
.88296 .69501 L
.88423 .69702 L
.88539 .69887 L
.88781 .70273 L
.88809 .70319 L
.89021 .7066 L
.89195 .70942 L
.89259 .71046 L
.89496 .71432 L
.89581 .71572 L
.89731 .71818 L
.89965 .72204 L
.89968 .72208 L
.90198 .7259 L
.90354 .72851 L
.90429 .72977 L
.90659 .73363 L
.9074 .73499 L
.90887 .73749 L
.91115 .74135 L
.91126 .74135 L
.91127 .74521 L
Mistroke
.91126 .74522 L
.90744 .74907 L
.90745 .75293 L
.9074 .75298 L
.90361 .7568 L
.90362 .76066 L
.90354 .76074 L
.89978 .76452 L
.89968 .76462 L
.89593 .76838 L
.89594 .77224 L
.89581 .77237 L
.89209 .7761 L
.89195 .77624 L
.88824 .77997 L
.88809 .78011 L
.88438 .78383 L
.88438 .78769 L
.88423 .78784 L
.88052 .79155 L
.88037 .79171 L
.87666 .79541 L
.87651 .79557 L
.8728 .79927 L
.8728 .80314 L
.87264 .80329 L
.86893 .807 L
.86878 .80715 L
.86506 .81086 L
.86492 .811 L
.86119 .81472 L
.86106 .81485 L
.85732 .81858 L
.8572 .8187 L
.85344 .82244 L
.85334 .82255 L
.84957 .82631 L
.84947 .8264 L
.84569 .83017 L
.84568 .83403 L
.84561 .83409 L
.84179 .83789 L
.84175 .83793 L
.83791 .84175 L
.83789 .84177 L
.83403 .84175 L
.83403 .84157 L
.83139 .83789 L
.83017 .83619 L
.82861 .83403 L
Mistroke
.82631 .83086 L
.8258 .83017 L
.82297 .82631 L
.82244 .82559 L
.82011 .82244 L
.81858 .82039 L
.81723 .81858 L
.81472 .81524 L
.81433 .81472 L
.81139 .81086 L
.81086 .81016 L
.80843 .807 L
.807 .80514 L
.80545 .80314 L
.80314 .80017 L
.80243 .79927 L
.79939 .79541 L
.79927 .79527 L
.79631 .79155 L
.79541 .79043 L
.79321 .78769 L
.79155 .78565 L
.79007 .78383 L
.78769 .78093 L
.7869 .77997 L
.78383 .77627 L
.78369 .7761 L
.78045 .77224 L
.77997 .77167 L
.77717 .76838 L
.7761 .76713 L
.77386 .76452 L
.77224 .76265 L
.77051 .76066 L
.76838 .75823 L
.76711 .7568 L
.76452 .75388 L
.76368 .75293 L
.76066 .74958 L
.7602 .74907 L
.7568 .74535 L
.75667 .74521 L
.7531 .74135 L
.75293 .74117 L
.74948 .73749 L
.74907 .73706 L
.74581 .73363 L
.74521 .733 L
.74208 .72977 L
.74135 .72901 L
Mistroke
.7383 .7259 L
.73749 .72508 L
.73447 .72204 L
.73363 .72121 L
.73057 .71818 L
.72977 .71739 L
.7266 .71432 L
.7259 .71364 L
.72257 .71046 L
.72204 .70995 L
.71847 .7066 L
.71818 .70632 L
.71432 .70275 L
.7143 .70273 L
.71046 .69925 L
.71004 .69887 L
.7066 .6958 L
.7057 .69501 L
.70273 .69241 L
.70128 .69115 L
.69887 .68908 L
.69676 .68729 L
.69501 .68582 L
.69214 .68343 L
.69115 .68261 L
.68741 .67956 L
.68729 .67947 L
.68343 .67638 L
.68257 .6757 L
.67956 .67336 L
.6776 .67184 L
.6757 .67039 L
.6725 .66798 L
.67184 .66749 L
.66798 .66465 L
.66725 .66412 L
.66412 .66187 L
.66185 .66026 L
.66026 .65914 L
.65639 .65648 L
.65627 .65639 L
.65253 .65388 L
.65049 .65253 L
.64867 .65134 L
.64481 .64886 L
.64451 .64867 L
.64095 .64644 L
.63829 .64481 L
.63709 .64408 L
.63323 .64179 L
Mistroke
.63179 .64095 L
.62936 .63955 L
.6255 .63737 L
.62499 .63709 L
.62164 .63525 L
.61783 .63323 L
.61778 .6332 L
.61392 .6312 L
.61026 .62936 L
.61006 .62926 L
.60619 .62739 L
.60233 .62557 L
.60218 .6255 L
.59847 .62382 L
.59461 .62213 L
.59348 .62164 L
.59075 .62049 L
.58689 .61892 L
.58399 .61778 L
.58302 .61741 L
.57916 .61595 L
.5753 .61456 L
.57346 .61392 L
.57144 .61323 L
.56758 .61196 L
.56372 .61075 L
.56142 .61006 L
.55985 .6096 L
.55599 .60851 L
.55213 .60747 L
.54827 .60651 L
.54698 .60619 L
.54441 .6056 L
.54055 .60475 L
.53669 .60396 L
.53282 .60323 L
.52896 .60256 L
.52756 .60233 L
.5251 .60195 L
.52124 .6014 L
.51738 .60092 L
.51352 .60049 L
.50965 .60012 L
.50579 .59981 L
.50193 .59957 L
.49807 .59938 L
.49421 .59925 L
.49035 .59919 L
.48648 .59918 L
.48262 .59924 L
Mistroke
.47876 .59935 L
.4749 .59952 L
.47104 .59976 L
.46718 .60005 L
.46331 .60041 L
.45945 .60082 L
.45559 .6013 L
.45173 .60183 L
.44846 .60233 L
.44787 .60243 L
.44401 .60308 L
.44015 .6038 L
.43628 .60457 L
.43242 .60541 L
.42901 .60619 L
.42856 .6063 L
.4247 .60726 L
.42084 .60827 L
.41698 .60935 L
.41453 .61006 L
.41311 .61048 L
.40925 .61167 L
.40539 .61293 L
.40247 .61392 L
.40153 .61424 L
.39767 .61562 L
.39381 .61705 L
.3919 .61778 L
.38994 .61854 L
.38608 .6201 L
.38239 .62164 L
.38222 .62171 L
.37836 .62338 L
.3745 .62512 L
.37366 .6255 L
.37064 .62691 L
.36677 .62876 L
.36554 .62936 L
.36291 .63067 L
.35905 .63264 L
.35794 .63323 L
.35519 .63468 L
.35133 .63677 L
.35075 .63709 L
.34747 .63892 L
.34391 .64095 L
.34361 .64113 L
.33974 .6434 L
.33739 .64481 L
.33588 .64573 L
Mistroke
.33202 .64811 L
.33113 .64867 L
.32816 .65056 L
.32512 .65253 L
.3243 .65307 L
.32044 .65564 L
.31931 .65639 L
.31657 .65826 L
.3137 .66026 L
.31271 .66095 L
.30885 .66369 L
.30826 .66412 L
.30499 .6665 L
.30298 .66798 L
.30113 .66936 L
.29785 .67184 L
.29727 .67228 L
.2934 .67527 L
.29285 .6757 L
.28954 .67831 L
.28797 .67956 L
.28568 .68141 L
.28321 .68343 L
.28182 .68457 L
.27855 .68729 L
.27796 .68779 L
.2741 .69107 L
.274 .69115 L
.27023 .6944 L
.26954 .69501 L
.26637 .6978 L
.26517 .69887 L
.26251 .70125 L
.26088 .70273 L
.25865 .70477 L
.25667 .7066 L
.25479 .70834 L
.25253 .71046 L
.25093 .71197 L
.24847 .71432 L
.24707 .71566 L
.24447 .71818 L
.2432 .71941 L
.24053 .72204 L
.23934 .72322 L
.23666 .7259 L
.23548 .72709 L
.23284 .72977 L
.23162 .73102 L
.22908 .73363 L
Mistroke
.22776 .735 L
.22537 .73749 L
.2239 .73904 L
.22172 .74135 L
.22003 .74314 L
.21811 .74521 L
.21617 .7473 L
.21455 .74907 L
.21231 .75152 L
.21103 .75293 L
.20845 .7558 L
.20756 .7568 L
.20459 .76013 L
.20412 .76066 L
.20073 .76452 L
.20073 .76453 L
.19738 .76838 L
.19686 .76898 L
.19407 .77224 L
.193 .77349 L
.19079 .7761 L
.18914 .77806 L
.18754 .77997 L
.18528 .78268 L
.18433 .78383 L
.18142 .78737 L
.18115 .78769 L
.17801 .79155 L
.17756 .79211 L
.17489 .79541 L
.17369 .79691 L
.17181 .79927 L
.16983 .80177 L
.16875 .80314 L
.16597 .80668 L
.16573 .807 L
.16273 .81086 L
.16211 .81166 L
.15975 .81472 L
.15825 .81669 L
.1568 .81858 L
.15439 .82177 L
.15388 .82244 L
.15434 .82631 L
.15053 .82631 L
.15052 .82631 L
.14666 .82246 L
.14665 .82244 L
.1428 .81861 L
.14277 .81858 L
Mistroke
.13894 .81476 L
.1389 .81472 L
.13508 .81091 L
.13503 .81086 L
.13122 .80706 L
.13116 .807 L
.12736 .8032 L
.12729 .80314 L
.12729 .79927 L
.12349 .79548 L
.12343 .79541 L
.11963 .79161 L
.11957 .79155 L
.11577 .78775 L
.11571 .78769 L
.11571 .78383 L
.11191 .78001 L
.11186 .77997 L
.10805 .77614 L
.10801 .7761 L
.10419 .77227 L
.10416 .77224 L
.10417 .76838 L
.10033 .76452 L
.10305 .76066 L
.10419 .75863 L
.10522 .7568 L
.10741 .75293 L
.10805 .7518 L
.1096 .74907 L
.11181 .74521 L
.11191 .74504 L
.11404 .74135 L
.11577 .73835 L
.11627 .73749 L
.11852 .73363 L
.11963 .73173 L
.12078 .72977 L
.12306 .7259 L
.12349 .72517 L
.12535 .72204 L
.12736 .71868 L
.12765 .71818 L
.12997 .71432 L
.13122 .71226 L
.13231 .71046 L
.13466 .7066 L
.13508 .7059 L
.13702 .70273 L
.13894 .69961 L
Mistroke
.1394 .69887 L
.14179 .69501 L
.1428 .69339 L
.14421 .69115 L
.14663 .68729 L
.14666 .68724 L
.14908 .68343 L
.15053 .68115 L
.15154 .67956 L
.15402 .6757 L
.15439 .67513 L
.15652 .67184 L
.15825 .66918 L
.15903 .66798 L
.16156 .66412 L
.16211 .66329 L
.16412 .66026 L
.16597 .65747 L
.16669 .65639 L
.16928 .65253 L
.16983 .65172 L
.17189 .64867 L
.17369 .64603 L
.17453 .64481 L
.17718 .64095 L
.17756 .64041 L
.17986 .63709 L
.18142 .63485 L
.18256 .63323 L
.18528 .62936 L
.18528 .62936 L
.18802 .6255 L
.18914 .62394 L
.19079 .62164 L
.193 .61858 L
.19358 .61778 L
.1964 .61392 L
.19686 .61329 L
.19925 .61006 L
.20073 .60806 L
.20212 .60619 L
.20459 .6029 L
.20502 .60233 L
.20794 .59847 L
.20845 .59781 L
.2109 .59461 L
.21231 .59278 L
.21389 .59075 L
.21617 .58782 L
.2169 .58689 L
Mistroke
.21995 .58302 L
.22003 .58292 L
.22303 .57916 L
.2239 .57809 L
.22615 .5753 L
.22776 .57332 L
.2293 .57144 L
.23162 .56862 L
.23248 .56758 L
.23548 .56399 L
.23571 .56372 L
.23897 .55985 L
.23934 .55942 L
.24227 .55599 L
.2432 .55491 L
.24562 .55213 L
.24707 .55048 L
.24901 .54827 L
.25093 .5461 L
.25244 .54441 L
.25479 .54179 L
.25592 .54055 L
.25865 .53755 L
.25944 .53669 L
.26251 .53337 L
.26302 .53282 L
.26637 .52926 L
.26665 .52896 L
.27023 .52521 L
.27034 .5251 L
.27409 .52124 L
.2741 .52123 L
.27789 .51738 L
.27796 .51731 L
.28176 .51352 L
.28182 .51346 L
.28568 .50967 L
.2857 .50965 L
.28954 .50595 L
.2897 .50579 L
.2934 .50229 L
.29379 .50193 L
.29727 .4987 L
.29795 .49807 L
.30113 .49517 L
.30219 .49421 L
.30499 .4917 L
.30652 .49035 L
.30885 .4883 L
.31095 .48648 L
Mistroke
.31271 .48497 L
.31548 .48262 L
.31657 .4817 L
.32011 .47876 L
.32044 .4785 L
.3243 .47536 L
.32487 .4749 L
.32816 .47228 L
.32974 .47104 L
.33202 .46927 L
.33476 .46718 L
.33588 .46632 L
.33974 .46344 L
.33992 .46331 L
.34361 .46062 L
.34524 .45945 L
.34747 .45787 L
.35074 .45559 L
.35133 .45518 L
.35519 .45256 L
.35643 .45173 L
.35905 .45 L
.36234 .44787 L
.36291 .44751 L
.36677 .44507 L
.3685 .44401 L
.37064 .44271 L
.3745 .44041 L
.37494 .44015 L
.37836 .43817 L
.3817 .43628 L
.38222 .436 L
.38608 .43389 L
.38884 .43242 L
.38994 .43184 L
.39381 .42986 L
.39642 .42856 L
.39767 .42795 L
.40153 .42609 L
.40453 .4247 L
.40539 .42431 L
.40925 .42258 L
.41311 .42093 L
.41332 .42084 L
.41698 .41933 L
.42084 .4178 L
.42298 .41698 L
.4247 .41633 L
.42856 .41493 L
.43242 .41359 L
Mistroke
.43385 .41311 L
.43628 .41232 L
.44015 .41111 L
.44401 .40996 L
.44651 .40925 L
.44787 .40888 L
.45173 .40786 L
.45559 .40691 L
.45945 .40602 L
.46235 .40539 L
.46331 .40519 L
.46718 .40443 L
.47104 .40373 L
.4749 .4031 L
.47876 .40253 L
.48262 .40202 L
.48648 .40158 L
.48694 .40153 L
.49035 .4012 L
Mfstroke
1 .572 .5 r
.49035 .42055 m
.49421 .42019 L
.49807 .41989 L
.50193 .41966 L
.50579 .4195 L
.50965 .41939 L
.51352 .41936 L
.51738 .41938 L
.52124 .41947 L
.5251 .41963 L
.52896 .41985 L
.53282 .42013 L
.53669 .42048 L
.54004 .42084 L
.54055 .4209 L
.54441 .42137 L
.54827 .42191 L
.55213 .42252 L
.55599 .42319 L
.55985 .42393 L
.56359 .4247 L
.56372 .42473 L
.56758 .42559 L
.57144 .42652 L
.5753 .42751 L
.57915 .42856 L
.57916 .42856 L
.58302 .42968 L
.58689 .43087 L
.59075 .43212 L
.59166 .43242 L
.59461 .43343 L
.59847 .43481 L
.60233 .43625 L
.60243 .43628 L
.60619 .43775 L
.61006 .43932 L
.61202 .44015 L
.61392 .44096 L
.61778 .44265 L
.62076 .44401 L
.62164 .44441 L
.6255 .44624 L
.62884 .44787 L
.62936 .44813 L
.63323 .45008 L
.63639 .45173 L
.63709 .4521 L
.64095 .45418 L
.6435 .45559 L
.64481 .45633 L
.64867 .45854 L
.65024 .45945 L
.65253 .46081 L
.65639 .46315 L
.65667 .46331 L
.66026 .46555 L
.66282 .46718 L
.66412 .46802 L
.66798 .47054 L
.66872 .47104 L
.67184 .47314 L
.67441 .4749 L
.6757 .4758 L
.67956 .47852 L
.67991 .47876 L
.68343 .4813 L
.68523 .48262 L
.68729 .48415 L
.69039 .48648 L
.69115 .48706 L
.69501 .49004 L
.6954 .49035 L
.69887 .49308 L
.70028 .49421 L
.70273 .49619 L
.70504 .49807 L
.7066 .49935 L
.70968 .50193 L
.71046 .50259 L
.71421 .50579 L
.71432 .50588 L
.71818 .50924 L
.71865 .50965 L
.72204 .51267 L
.72299 .51352 L
.7259 .51615 L
.72724 .51738 L
.72977 .51971 L
.73141 .52124 L
.73363 .52332 L
.7355 .5251 L
.73749 .527 L
.73952 .52896 L
.74135 .53074 L
.74347 .53282 L
.74521 .53455 L
.74735 .53669 L
.74907 .53842 L
.75117 .54055 L
.75293 .54236 L
.75493 .54441 L
.7568 .54635 L
.75863 .54827 L
.76066 .55042 L
.76227 .55213 L
.76452 .55454 L
.76586 .55599 L
.76838 .55873 L
.76941 .55985 L
.77224 .56298 L
.7729 .56372 L
.7761 .5673 L
.77635 .56758 L
.77975 .57144 L
.77997 .57168 L
.78312 .5753 L
.78383 .57613 L
.78644 .57916 L
.78769 .58063 L
.78972 .58302 L
.79155 .58521 L
.79296 .58689 L
.79541 .58984 L
.79616 .59075 L
.79927 .59454 L
.79933 .59461 L
.80246 .59847 L
.80314 .5993 L
.80556 .60233 L
.807 .60413 L
.80863 .60619 L
.81086 .60902 L
.81167 .61006 L
.81468 .61392 L
.81472 .61398 L
.81765 .61778 L
.81858 .61899 L
.8206 .62164 L
.82244 .62408 L
.82352 .6255 L
.82631 .62922 L
.82641 .62936 L
.82928 .63323 L
.83017 .63443 L
.83212 .63709 L
.83403 .6397 L
.83493 .64095 L
.83773 .64481 L
.83789 .64504 L
.84049 .64867 L
.84175 .65044 L
.84324 .65253 L
.84561 .6559 L
.84596 .65639 L
.84866 .66026 L
.84947 .66143 L
.85134 .66412 L
.85334 .66702 L
.85399 .66798 L
.85663 .67184 L
.8572 .67268 L
.85925 .6757 L
.86106 .67839 L
.86184 .67956 L
.86442 .68343 L
.86492 .68418 L
.86698 .68729 L
.86878 .69002 L
.86952 .69115 L
.87205 .69501 L
.87264 .69593 L
.87455 .69887 L
.87651 .70191 L
.87704 .70273 L
.87951 .7066 L
.88037 .70794 L
.88197 .71046 L
.88423 .71404 L
.8844 .71432 L
.88683 .71818 L
.88809 .72021 L
.88923 .72204 L
.89163 .7259 L
.89195 .72643 L
.894 .72977 L
.89581 .73273 L
.89636 .73363 L
.89871 .73749 L
.89968 .73908 L
.90105 .74135 L
.90336 .74521 L
.90354 .7455 L
.90738 .74907 L
.9074 .74911 L
.9074 .75293 L
.9074 .75294 L
.90356 .7568 L
.90357 .76066 L
.90354 .76069 L
.89973 .76452 L
.89968 .76457 L
.89589 .76838 L
.89589 .77224 L
.89581 .77232 L
.89204 .7761 L
.89195 .77619 L
.88819 .77997 L
.88809 .78007 L
.88434 .78383 L
.88434 .78769 L
.88423 .7878 L
.88048 .79155 L
.88037 .79166 L
.87662 .79541 L
.87651 .79553 L
.87276 .79927 L
.87276 .80314 L
.87264 .80325 L
.86889 .807 L
.86878 .8071 L
.86502 .81086 L
.86492 .81096 L
.86115 .81472 L
.86106 .81481 L
.85727 .81858 L
.8572 .81866 L
.8534 .82244 L
.85334 .82251 L
.84952 .82631 L
.84947 .82635 L
.84564 .83017 L
.84563 .83403 L
.84561 .83405 L
.84175 .83787 L
.84078 .83403 L
.83807 .83017 L
.83789 .82991 L
.83535 .82631 L
.83403 .82445 L
.8326 .82244 L
.83017 .81905 L
.82983 .81858 L
.82704 .81472 L
.82631 .81372 L
.82422 .81086 L
.82244 .80844 L
.82138 .807 L
.81858 .80322 L
.81852 .80314 L
.81563 .79927 L
.81472 .79807 L
.81271 .79541 L
.81086 .79297 L
.80977 .79155 L
.807 .78794 L
.80681 .78769 L
.80381 .78383 L
.80314 .78296 L
.80079 .77997 L
.79927 .77805 L
.79773 .7761 L
.79541 .7732 L
.79465 .77224 L
.79155 .7684 L
.79153 .76838 L
.78839 .76452 L
.78769 .76367 L
.78521 .76066 L
.78383 .759 L
.78199 .7568 L
.77997 .75438 L
.77874 .75293 L
.7761 .74983 L
.77546 .74907 L
.77224 .74534 L
.77213 .74521 L
.76877 .74135 L
.76838 .74091 L
.76536 .73749 L
.76452 .73654 L
.76192 .73363 L
.76066 .73223 L
.75843 .72977 L
.7568 .72798 L
.75489 .7259 L
.75293 .72378 L
.75131 .72204 L
.74907 .71965 L
.74768 .71818 L
.74521 .71558 L
.744 .71432 L
.74135 .71158 L
.74026 .71046 L
.73749 .70763 L
.73647 .7066 L
.73363 .70374 L
.73262 .70273 L
.72977 .69991 L
.72871 .69887 L
.7259 .69614 L
.72473 .69501 L
.72204 .69243 L
.72069 .69115 L
.71818 .68878 L
.71658 .68729 L
.71432 .6852 L
.71239 .68343 L
.71046 .68167 L
.70812 .67956 L
.7066 .6782 L
.70377 .6757 L
.70273 .67479 L
.69933 .67184 L
.69887 .67145 L
.69501 .66816 L
.6948 .66798 L
.69115 .66493 L
.69016 .66412 L
.68729 .66177 L
.68542 .66026 L
.68343 .65866 L
.68056 .65639 L
.67956 .65562 L
.6757 .65263 L
.67558 .65253 L
.67184 .6497 L
.67046 .64867 L
.66798 .64684 L
.6652 .64481 L
.66412 .64403 L
.66026 .64129 L
.65977 .64095 L
.65639 .6386 L
.65418 .63709 L
.65253 .63598 L
.64867 .63341 L
.64839 .63323 L
.64481 .63091 L
.64238 .62936 L
.64095 .62846 L
.63709 .62608 L
.63614 .6255 L
.63323 .62375 L
.62963 .62164 L
.62936 .62149 L
.6255 .61928 L
.6228 .61778 L
.62164 .61714 L
.61778 .61505 L
.61562 .61392 L
.61392 .61303 L
.61006 .61107 L
.60802 .61006 L
.60619 .60916 L
.60233 .60732 L
.59992 .60619 L
.59847 .60553 L
.59461 .60381 L
.5912 .60233 L
.59075 .60214 L
.58689 .60054 L
.58302 .59899 L
.58169 .59847 L
.57916 .59751 L
.5753 .59608 L
.57144 .59471 L
.57113 .59461 L
.56758 .59341 L
.56372 .59216 L
.55985 .59098 L
.55908 .59075 L
.55599 .58985 L
.55213 .58878 L
.54827 .58778 L
.54464 .58689 L
.54441 .58683 L
.54055 .58594 L
.53669 .58512 L
.53282 .58435 L
.52896 .58364 L
.5253 .58302 L
.5251 .58299 L
.52124 .5824 L
.51738 .58187 L
.51352 .5814 L
.50965 .58099 L
.50579 .58064 L
.50193 .58035 L
.49807 .58012 L
.49421 .57995 L
.49035 .57984 L
.48648 .57978 L
.48262 .57979 L
.47876 .57986 L
.4749 .57998 L
.47104 .58017 L
.46718 .58041 L
.46331 .58071 L
.45945 .58108 L
.45559 .5815 L
.45173 .58198 L
.44787 .58252 L
.44459 .58302 L
.44401 .58312 L
.44015 .58378 L
.43628 .58449 L
.43242 .58527 L
.42856 .58611 L
.42518 .58689 L
.4247 .587 L
.42084 .58795 L
.41698 .58897 L
.41311 .59004 L
.41067 .59075 L
.40925 .59117 L
.40539 .59236 L
.40153 .59361 L
.39855 .59461 L
.39767 .59491 L
.39381 .59628 L
.38994 .5977 L
.38792 .59847 L
.38608 .59918 L
.38222 .60073 L
.37836 .60233 L
.37834 .60233 L
.3745 .60398 L
.37064 .6057 L
.36955 .60619 L
.36677 .60748 L
.36291 .60931 L
.36137 .61006 L
.35905 .6112 L
.35519 .61315 L
.3537 .61392 L
.35133 .61516 L
.34747 .61722 L
.34645 .61778 L
.34361 .61935 L
.33974 .62153 L
.33955 .62164 L
.33588 .62377 L
.33296 .6255 L
.33202 .62607 L
.32816 .62842 L
.32664 .62936 L
.3243 .63084 L
.32056 .63323 L
.32044 .63331 L
.31657 .63584 L
.31469 .63709 L
.31271 .63842 L
.30902 .64095 L
.30885 .64106 L
.30499 .64376 L
.30352 .64481 L
.30113 .64652 L
.29817 .64867 L
.29727 .64934 L
.2934 .65221 L
.29297 .65253 L
.28954 .65514 L
.28791 .65639 L
.28568 .65812 L
.28297 .66026 L
.28182 .66117 L
.27814 .66412 L
.27796 .66426 L
.2741 .66742 L
.27342 .66798 L
.27023 .67063 L
.2688 .67184 L
.26637 .6739 L
.26427 .6757 L
.26251 .67722 L
.25983 .67956 L
.25865 .6806 L
.25547 .68343 L
.25479 .68404 L
.25119 .68729 L
.25093 .68753 L
.24707 .69108 L
.24699 .69115 L
.2432 .69468 L
.24285 .69501 L
.23934 .69834 L
.23878 .69887 L
.23548 .70205 L
.23478 .70273 L
.23162 .70582 L
.23083 .7066 L
.22776 .70964 L
.22694 .71046 L
.2239 .71352 L
.2231 .71432 L
.22003 .71745 L
.21932 .71818 L
.21617 .72143 L
.21559 .72204 L
.21231 .72547 L
.2119 .7259 L
.20845 .72956 L
.20826 .72977 L
.20466 .73363 L
.20459 .73371 L
.20111 .73749 L
.20073 .7379 L
.19759 .74135 L
.19686 .74216 L
.19412 .74521 L
.193 .74646 L
.19068 .74907 L
.18914 .75081 L
.18728 .75293 L
.18528 .75522 L
.18391 .7568 L
.18142 .75967 L
.18057 .76066 L
.17756 .76418 L
.17727 .76452 L
.174 .76838 L
.17369 .76874 L
.17076 .77224 L
.16983 .77335 L
.16754 .7761 L
.16597 .778 L
.16436 .77997 L
.16211 .78271 L
.1612 .78383 L
.15825 .78746 L
.15806 .78769 L
.15496 .79155 L
.15439 .79226 L
.15188 .79541 L
.15053 .79711 L
.14882 .79927 L
.14666 .802 L
.14578 .80314 L
.1428 .80694 L
.14276 .807 L
.13976 .81086 L
.13894 .81471 L
.13508 .81086 L
.13507 .81086 L
.13122 .80701 L
.1312 .807 L
.12736 .80315 L
.12734 .80314 L
.12734 .79927 L
.12349 .79543 L
.12347 .79541 L
.11963 .79157 L
.11962 .79155 L
.11577 .7877 L
.11576 .78769 L
.11576 .78383 L
.11191 .77997 L
.11191 .77997 L
.11191 .77612 L
.11327 .7761 L
.11536 .77224 L
.11577 .77149 L
.11746 .76838 L
.11958 .76452 L
.11963 .76443 L
.12171 .76066 L
.12349 .75745 L
.12386 .7568 L
.12602 .75293 L
.12736 .75056 L
.12819 .74907 L
.13039 .74521 L
.13122 .74375 L
.13259 .74135 L
.13482 .73749 L
.13508 .73703 L
.13705 .73363 L
.13894 .7304 L
.13931 .72977 L
.14158 .7259 L
.1428 .72384 L
.14387 .72204 L
.14617 .71818 L
.14666 .71736 L
.14849 .71432 L
.15053 .71096 L
.15083 .71046 L
.15319 .7066 L
.15439 .70464 L
.15556 .70273 L
.15796 .69887 L
.15825 .6984 L
.16037 .69501 L
.16211 .69224 L
.1628 .69115 L
.16525 .68729 L
.16597 .68615 L
.16771 .68343 L
.16983 .68014 L
.1702 .67956 L
.17271 .6757 L
.17369 .6742 L
.17524 .67184 L
.17756 .66833 L
.17779 .66798 L
.18036 .66412 L
.18142 .66254 L
.18296 .66026 L
.18528 .65683 L
.18557 .65639 L
.18821 .65253 L
.18914 .65118 L
.19087 .64867 L
.193 .64561 L
.19356 .64481 L
.19627 .64095 L
.19686 .64011 L
.19901 .63709 L
.20073 .63469 L
.20177 .63323 L
.20456 .62936 L
.20459 .62933 L
.20738 .6255 L
.20845 .62405 L
.21022 .62164 L
.21231 .61883 L
.2131 .61778 L
.216 .61392 L
.21617 .61369 L
.21893 .61006 L
.22003 .60862 L
.2219 .60619 L
.2239 .60361 L
.22489 .60233 L
.22776 .59868 L
.22792 .59847 L
.23099 .59461 L
.23162 .59382 L
.23409 .59075 L
.23548 .58903 L
.23722 .58689 L
.23934 .5843 L
.2404 .58302 L
.2432 .57965 L
.24361 .57916 L
.24686 .5753 L
.24707 .57506 L
.25016 .57144 L
.25093 .57054 L
.25349 .56758 L
.25479 .5661 L
.25688 .56372 L
.25865 .56171 L
.26031 .55985 L
.26251 .5574 L
.26379 .55599 L
.26637 .55316 L
.26732 .55213 L
.27023 .54898 L
.2709 .54827 L
.2741 .54487 L
.27454 .54441 L
.27796 .54083 L
.27824 .54055 L
.28182 .53686 L
.28199 .53669 L
.28568 .53296 L
.28581 .53282 L
.28954 .52912 L
.2897 .52896 L
.2934 .52535 L
.29366 .5251 L
.29727 .52164 L
.29769 .52124 L
.30113 .51801 L
.3018 .51738 L
.30499 .51444 L
.306 .51352 L
.30885 .51093 L
.31028 .50965 L
.31271 .5075 L
.31466 .50579 L
.31657 .50413 L
.31913 .50193 L
.32044 .50083 L
.32372 .49807 L
.3243 .49759 L
.32816 .49442 L
.32842 .49421 L
.33202 .49132 L
.33324 .49035 L
.33588 .48828 L
.3382 .48648 L
.33974 .48531 L
.34331 .48262 L
.34361 .4824 L
.34747 .47956 L
.34858 .47876 L
.35133 .47679 L
.35402 .4749 L
.35519 .47409 L
.35905 .47144 L
.35965 .47104 L
.36291 .46887 L
.36551 .46718 L
.36677 .46636 L
.37064 .46392 L
.3716 .46331 L
.3745 .46154 L
.37798 .45945 L
.37836 .45923 L
.38222 .45698 L
.38467 .45559 L
.38608 .4548 L
.38994 .45268 L
.39173 .45173 L
.39381 .45063 L
.39767 .44865 L
.39923 .44787 L
.40153 .44673 L
.40539 .44488 L
.40725 .44401 L
.40925 .44309 L
.41311 .44137 L
.41594 .44015 L
.41698 .43971 L
.42084 .43811 L
.4247 .43659 L
.42549 .43628 L
.42856 .43512 L
.43242 .43373 L
.4362 .43242 L
.43628 .43239 L
.44015 .43113 L
.44401 .42992 L
.44787 .42879 L
.44866 .42856 L
.45173 .42771 L
.45559 .42671 L
.45945 .42576 L
.46331 .42489 L
.46417 .4247 L
.46718 .42407 L
.47104 .42332 L
.4749 .42264 L
.47876 .42202 L
.48262 .42147 L
.48648 .42098 L
.48768 .42084 L
F
0 g
.49035 .42055 m
.49421 .42019 L
.49807 .41989 L
.50193 .41966 L
.50579 .4195 L
.50965 .41939 L
.51352 .41936 L
.51738 .41938 L
.52124 .41947 L
.5251 .41963 L
.52896 .41985 L
.53282 .42013 L
.53669 .42048 L
.54004 .42084 L
.54055 .4209 L
.54441 .42137 L
.54827 .42191 L
.55213 .42252 L
.55599 .42319 L
.55985 .42393 L
.56359 .4247 L
.56372 .42473 L
.56758 .42559 L
.57144 .42652 L
.5753 .42751 L
.57915 .42856 L
.57916 .42856 L
.58302 .42968 L
.58689 .43087 L
.59075 .43212 L
.59166 .43242 L
.59461 .43343 L
.59847 .43481 L
.60233 .43625 L
.60243 .43628 L
.60619 .43775 L
.61006 .43932 L
.61202 .44015 L
.61392 .44096 L
.61778 .44265 L
.62076 .44401 L
.62164 .44441 L
.6255 .44624 L
.62884 .44787 L
.62936 .44813 L
.63323 .45008 L
.63639 .45173 L
.63709 .4521 L
.64095 .45418 L
.6435 .45559 L
Mistroke
.64481 .45633 L
.64867 .45854 L
.65024 .45945 L
.65253 .46081 L
.65639 .46315 L
.65667 .46331 L
.66026 .46555 L
.66282 .46718 L
.66412 .46802 L
.66798 .47054 L
.66872 .47104 L
.67184 .47314 L
.67441 .4749 L
.6757 .4758 L
.67956 .47852 L
.67991 .47876 L
.68343 .4813 L
.68523 .48262 L
.68729 .48415 L
.69039 .48648 L
.69115 .48706 L
.69501 .49004 L
.6954 .49035 L
.69887 .49308 L
.70028 .49421 L
.70273 .49619 L
.70504 .49807 L
.7066 .49935 L
.70968 .50193 L
.71046 .50259 L
.71421 .50579 L
.71432 .50588 L
.71818 .50924 L
.71865 .50965 L
.72204 .51267 L
.72299 .51352 L
.7259 .51615 L
.72724 .51738 L
.72977 .51971 L
.73141 .52124 L
.73363 .52332 L
.7355 .5251 L
.73749 .527 L
.73952 .52896 L
.74135 .53074 L
.74347 .53282 L
.74521 .53455 L
.74735 .53669 L
.74907 .53842 L
.75117 .54055 L
Mistroke
.75293 .54236 L
.75493 .54441 L
.7568 .54635 L
.75863 .54827 L
.76066 .55042 L
.76227 .55213 L
.76452 .55454 L
.76586 .55599 L
.76838 .55873 L
.76941 .55985 L
.77224 .56298 L
.7729 .56372 L
.7761 .5673 L
.77635 .56758 L
.77975 .57144 L
.77997 .57168 L
.78312 .5753 L
.78383 .57613 L
.78644 .57916 L
.78769 .58063 L
.78972 .58302 L
.79155 .58521 L
.79296 .58689 L
.79541 .58984 L
.79616 .59075 L
.79927 .59454 L
.79933 .59461 L
.80246 .59847 L
.80314 .5993 L
.80556 .60233 L
.807 .60413 L
.80863 .60619 L
.81086 .60902 L
.81167 .61006 L
.81468 .61392 L
.81472 .61398 L
.81765 .61778 L
.81858 .61899 L
.8206 .62164 L
.82244 .62408 L
.82352 .6255 L
.82631 .62922 L
.82641 .62936 L
.82928 .63323 L
.83017 .63443 L
.83212 .63709 L
.83403 .6397 L
.83493 .64095 L
.83773 .64481 L
.83789 .64504 L
Mistroke
.84049 .64867 L
.84175 .65044 L
.84324 .65253 L
.84561 .6559 L
.84596 .65639 L
.84866 .66026 L
.84947 .66143 L
.85134 .66412 L
.85334 .66702 L
.85399 .66798 L
.85663 .67184 L
.8572 .67268 L
.85925 .6757 L
.86106 .67839 L
.86184 .67956 L
.86442 .68343 L
.86492 .68418 L
.86698 .68729 L
.86878 .69002 L
.86952 .69115 L
.87205 .69501 L
.87264 .69593 L
.87455 .69887 L
.87651 .70191 L
.87704 .70273 L
.87951 .7066 L
.88037 .70794 L
.88197 .71046 L
.88423 .71404 L
.8844 .71432 L
.88683 .71818 L
.88809 .72021 L
.88923 .72204 L
.89163 .7259 L
.89195 .72643 L
.894 .72977 L
.89581 .73273 L
.89636 .73363 L
.89871 .73749 L
.89968 .73908 L
.90105 .74135 L
.90336 .74521 L
.90354 .7455 L
.90738 .74907 L
.9074 .74911 L
.9074 .75293 L
.9074 .75294 L
.90356 .7568 L
.90357 .76066 L
.90354 .76069 L
Mistroke
.89973 .76452 L
.89968 .76457 L
.89589 .76838 L
.89589 .77224 L
.89581 .77232 L
.89204 .7761 L
.89195 .77619 L
.88819 .77997 L
.88809 .78007 L
.88434 .78383 L
.88434 .78769 L
.88423 .7878 L
.88048 .79155 L
.88037 .79166 L
.87662 .79541 L
.87651 .79553 L
.87276 .79927 L
.87276 .80314 L
.87264 .80325 L
.86889 .807 L
.86878 .8071 L
.86502 .81086 L
.86492 .81096 L
.86115 .81472 L
.86106 .81481 L
.85727 .81858 L
.8572 .81866 L
.8534 .82244 L
.85334 .82251 L
.84952 .82631 L
.84947 .82635 L
.84564 .83017 L
.84563 .83403 L
.84561 .83405 L
.84175 .83787 L
.84078 .83403 L
.83807 .83017 L
.83789 .82991 L
.83535 .82631 L
.83403 .82445 L
.8326 .82244 L
.83017 .81905 L
.82983 .81858 L
.82704 .81472 L
.82631 .81372 L
.82422 .81086 L
.82244 .80844 L
.82138 .807 L
.81858 .80322 L
.81852 .80314 L
Mistroke
.81563 .79927 L
.81472 .79807 L
.81271 .79541 L
.81086 .79297 L
.80977 .79155 L
.807 .78794 L
.80681 .78769 L
.80381 .78383 L
.80314 .78296 L
.80079 .77997 L
.79927 .77805 L
.79773 .7761 L
.79541 .7732 L
.79465 .77224 L
.79155 .7684 L
.79153 .76838 L
.78839 .76452 L
.78769 .76367 L
.78521 .76066 L
.78383 .759 L
.78199 .7568 L
.77997 .75438 L
.77874 .75293 L
.7761 .74983 L
.77546 .74907 L
.77224 .74534 L
.77213 .74521 L
.76877 .74135 L
.76838 .74091 L
.76536 .73749 L
.76452 .73654 L
.76192 .73363 L
.76066 .73223 L
.75843 .72977 L
.7568 .72798 L
.75489 .7259 L
.75293 .72378 L
.75131 .72204 L
.74907 .71965 L
.74768 .71818 L
.74521 .71558 L
.744 .71432 L
.74135 .71158 L
.74026 .71046 L
.73749 .70763 L
.73647 .7066 L
.73363 .70374 L
.73262 .70273 L
.72977 .69991 L
.72871 .69887 L
Mistroke
.7259 .69614 L
.72473 .69501 L
.72204 .69243 L
.72069 .69115 L
.71818 .68878 L
.71658 .68729 L
.71432 .6852 L
.71239 .68343 L
.71046 .68167 L
.70812 .67956 L
.7066 .6782 L
.70377 .6757 L
.70273 .67479 L
.69933 .67184 L
.69887 .67145 L
.69501 .66816 L
.6948 .66798 L
.69115 .66493 L
.69016 .66412 L
.68729 .66177 L
.68542 .66026 L
.68343 .65866 L
.68056 .65639 L
.67956 .65562 L
.6757 .65263 L
.67558 .65253 L
.67184 .6497 L
.67046 .64867 L
.66798 .64684 L
.6652 .64481 L
.66412 .64403 L
.66026 .64129 L
.65977 .64095 L
.65639 .6386 L
.65418 .63709 L
.65253 .63598 L
.64867 .63341 L
.64839 .63323 L
.64481 .63091 L
.64238 .62936 L
.64095 .62846 L
.63709 .62608 L
.63614 .6255 L
.63323 .62375 L
.62963 .62164 L
.62936 .62149 L
.6255 .61928 L
.6228 .61778 L
.62164 .61714 L
.61778 .61505 L
Mistroke
.61562 .61392 L
.61392 .61303 L
.61006 .61107 L
.60802 .61006 L
.60619 .60916 L
.60233 .60732 L
.59992 .60619 L
.59847 .60553 L
.59461 .60381 L
.5912 .60233 L
.59075 .60214 L
.58689 .60054 L
.58302 .59899 L
.58169 .59847 L
.57916 .59751 L
.5753 .59608 L
.57144 .59471 L
.57113 .59461 L
.56758 .59341 L
.56372 .59216 L
.55985 .59098 L
.55908 .59075 L
.55599 .58985 L
.55213 .58878 L
.54827 .58778 L
.54464 .58689 L
.54441 .58683 L
.54055 .58594 L
.53669 .58512 L
.53282 .58435 L
.52896 .58364 L
.5253 .58302 L
.5251 .58299 L
.52124 .5824 L
.51738 .58187 L
.51352 .5814 L
.50965 .58099 L
.50579 .58064 L
.50193 .58035 L
.49807 .58012 L
.49421 .57995 L
.49035 .57984 L
.48648 .57978 L
.48262 .57979 L
.47876 .57986 L
.4749 .57998 L
.47104 .58017 L
.46718 .58041 L
.46331 .58071 L
.45945 .58108 L
Mistroke
.45559 .5815 L
.45173 .58198 L
.44787 .58252 L
.44459 .58302 L
.44401 .58312 L
.44015 .58378 L
.43628 .58449 L
.43242 .58527 L
.42856 .58611 L
.42518 .58689 L
.4247 .587 L
.42084 .58795 L
.41698 .58897 L
.41311 .59004 L
.41067 .59075 L
.40925 .59117 L
.40539 .59236 L
.40153 .59361 L
.39855 .59461 L
.39767 .59491 L
.39381 .59628 L
.38994 .5977 L
.38792 .59847 L
.38608 .59918 L
.38222 .60073 L
.37836 .60233 L
.37834 .60233 L
.3745 .60398 L
.37064 .6057 L
.36955 .60619 L
.36677 .60748 L
.36291 .60931 L
.36137 .61006 L
.35905 .6112 L
.35519 .61315 L
.3537 .61392 L
.35133 .61516 L
.34747 .61722 L
.34645 .61778 L
.34361 .61935 L
.33974 .62153 L
.33955 .62164 L
.33588 .62377 L
.33296 .6255 L
.33202 .62607 L
.32816 .62842 L
.32664 .62936 L
.3243 .63084 L
.32056 .63323 L
.32044 .63331 L
Mistroke
.31657 .63584 L
.31469 .63709 L
.31271 .63842 L
.30902 .64095 L
.30885 .64106 L
.30499 .64376 L
.30352 .64481 L
.30113 .64652 L
.29817 .64867 L
.29727 .64934 L
.2934 .65221 L
.29297 .65253 L
.28954 .65514 L
.28791 .65639 L
.28568 .65812 L
.28297 .66026 L
.28182 .66117 L
.27814 .66412 L
.27796 .66426 L
.2741 .66742 L
.27342 .66798 L
.27023 .67063 L
.2688 .67184 L
.26637 .6739 L
.26427 .6757 L
.26251 .67722 L
.25983 .67956 L
.25865 .6806 L
.25547 .68343 L
.25479 .68404 L
.25119 .68729 L
.25093 .68753 L
.24707 .69108 L
.24699 .69115 L
.2432 .69468 L
.24285 .69501 L
.23934 .69834 L
.23878 .69887 L
.23548 .70205 L
.23478 .70273 L
.23162 .70582 L
.23083 .7066 L
.22776 .70964 L
.22694 .71046 L
.2239 .71352 L
.2231 .71432 L
.22003 .71745 L
.21932 .71818 L
.21617 .72143 L
.21559 .72204 L
Mistroke
.21231 .72547 L
.2119 .7259 L
.20845 .72956 L
.20826 .72977 L
.20466 .73363 L
.20459 .73371 L
.20111 .73749 L
.20073 .7379 L
.19759 .74135 L
.19686 .74216 L
.19412 .74521 L
.193 .74646 L
.19068 .74907 L
.18914 .75081 L
.18728 .75293 L
.18528 .75522 L
.18391 .7568 L
.18142 .75967 L
.18057 .76066 L
.17756 .76418 L
.17727 .76452 L
.174 .76838 L
.17369 .76874 L
.17076 .77224 L
.16983 .77335 L
.16754 .7761 L
.16597 .778 L
.16436 .77997 L
.16211 .78271 L
.1612 .78383 L
.15825 .78746 L
.15806 .78769 L
.15496 .79155 L
.15439 .79226 L
.15188 .79541 L
.15053 .79711 L
.14882 .79927 L
.14666 .802 L
.14578 .80314 L
.1428 .80694 L
.14276 .807 L
.13976 .81086 L
.13894 .81471 L
.13508 .81086 L
.13507 .81086 L
.13122 .80701 L
.1312 .807 L
.12736 .80315 L
.12734 .80314 L
.12734 .79927 L
Mistroke
.12349 .79543 L
.12347 .79541 L
.11963 .79157 L
.11962 .79155 L
.11577 .7877 L
.11576 .78769 L
.11576 .78383 L
.11191 .77997 L
.11191 .77997 L
.11191 .77612 L
.11327 .7761 L
.11536 .77224 L
.11577 .77149 L
.11746 .76838 L
.11958 .76452 L
.11963 .76443 L
.12171 .76066 L
.12349 .75745 L
.12386 .7568 L
.12602 .75293 L
.12736 .75056 L
.12819 .74907 L
.13039 .74521 L
.13122 .74375 L
.13259 .74135 L
.13482 .73749 L
.13508 .73703 L
.13705 .73363 L
.13894 .7304 L
.13931 .72977 L
.14158 .7259 L
.1428 .72384 L
.14387 .72204 L
.14617 .71818 L
.14666 .71736 L
.14849 .71432 L
.15053 .71096 L
.15083 .71046 L
.15319 .7066 L
.15439 .70464 L
.15556 .70273 L
.15796 .69887 L
.15825 .6984 L
.16037 .69501 L
.16211 .69224 L
.1628 .69115 L
.16525 .68729 L
.16597 .68615 L
.16771 .68343 L
.16983 .68014 L
Mistroke
.1702 .67956 L
.17271 .6757 L
.17369 .6742 L
.17524 .67184 L
.17756 .66833 L
.17779 .66798 L
.18036 .66412 L
.18142 .66254 L
.18296 .66026 L
.18528 .65683 L
.18557 .65639 L
.18821 .65253 L
.18914 .65118 L
.19087 .64867 L
.193 .64561 L
.19356 .64481 L
.19627 .64095 L
.19686 .64011 L
.19901 .63709 L
.20073 .63469 L
.20177 .63323 L
.20456 .62936 L
.20459 .62933 L
.20738 .6255 L
.20845 .62405 L
.21022 .62164 L
.21231 .61883 L
.2131 .61778 L
.216 .61392 L
.21617 .61369 L
.21893 .61006 L
.22003 .60862 L
.2219 .60619 L
.2239 .60361 L
.22489 .60233 L
.22776 .59868 L
.22792 .59847 L
.23099 .59461 L
.23162 .59382 L
.23409 .59075 L
.23548 .58903 L
.23722 .58689 L
.23934 .5843 L
.2404 .58302 L
.2432 .57965 L
.24361 .57916 L
.24686 .5753 L
.24707 .57506 L
.25016 .57144 L
.25093 .57054 L
Mistroke
.25349 .56758 L
.25479 .5661 L
.25688 .56372 L
.25865 .56171 L
.26031 .55985 L
.26251 .5574 L
.26379 .55599 L
.26637 .55316 L
.26732 .55213 L
.27023 .54898 L
.2709 .54827 L
.2741 .54487 L
.27454 .54441 L
.27796 .54083 L
.27824 .54055 L
.28182 .53686 L
.28199 .53669 L
.28568 .53296 L
.28581 .53282 L
.28954 .52912 L
.2897 .52896 L
.2934 .52535 L
.29366 .5251 L
.29727 .52164 L
.29769 .52124 L
.30113 .51801 L
.3018 .51738 L
.30499 .51444 L
.306 .51352 L
.30885 .51093 L
.31028 .50965 L
.31271 .5075 L
.31466 .50579 L
.31657 .50413 L
.31913 .50193 L
.32044 .50083 L
.32372 .49807 L
.3243 .49759 L
.32816 .49442 L
.32842 .49421 L
.33202 .49132 L
.33324 .49035 L
.33588 .48828 L
.3382 .48648 L
.33974 .48531 L
.34331 .48262 L
.34361 .4824 L
.34747 .47956 L
.34858 .47876 L
.35133 .47679 L
Mistroke
.35402 .4749 L
.35519 .47409 L
.35905 .47144 L
.35965 .47104 L
.36291 .46887 L
.36551 .46718 L
.36677 .46636 L
.37064 .46392 L
.3716 .46331 L
.3745 .46154 L
.37798 .45945 L
.37836 .45923 L
.38222 .45698 L
.38467 .45559 L
.38608 .4548 L
.38994 .45268 L
.39173 .45173 L
.39381 .45063 L
.39767 .44865 L
.39923 .44787 L
.40153 .44673 L
.40539 .44488 L
.40725 .44401 L
.40925 .44309 L
.41311 .44137 L
.41594 .44015 L
.41698 .43971 L
.42084 .43811 L
.4247 .43659 L
.42549 .43628 L
.42856 .43512 L
.43242 .43373 L
.4362 .43242 L
.43628 .43239 L
.44015 .43113 L
.44401 .42992 L
.44787 .42879 L
.44866 .42856 L
.45173 .42771 L
.45559 .42671 L
.45945 .42576 L
.46331 .42489 L
.46417 .4247 L
.46718 .42407 L
.47104 .42332 L
.4749 .42264 L
.47876 .42202 L
.48262 .42147 L
.48648 .42098 L
.48768 .42084 L
Mistroke
.49035 .42055 L
Mfstroke
1 .559 .5 r
.47876 .4397 m
.48262 .43907 L
.48648 .43851 L
.49035 .43802 L
.49421 .4376 L
.49807 .43723 L
.50193 .43694 L
.50579 .43671 L
.50965 .43655 L
.51352 .43645 L
.51738 .43642 L
.52124 .43645 L
.5251 .43655 L
.52896 .43671 L
.53282 .43694 L
.53669 .43724 L
.54055 .4376 L
.54441 .43802 L
.54827 .43851 L
.55213 .43907 L
.55599 .43969 L
.55858 .44015 L
.55985 .44038 L
.56372 .44113 L
.56758 .44195 L
.57144 .44283 L
.5753 .44378 L
.5762 .44401 L
.57916 .44479 L
.58302 .44587 L
.58689 .44701 L
.58966 .44787 L
.59075 .44821 L
.59461 .44949 L
.59847 .45082 L
.60099 .45173 L
.60233 .45222 L
.60619 .45369 L
.61006 .45522 L
.61097 .45559 L
.61392 .45682 L
.61778 .45848 L
.61998 .45945 L
.62164 .4602 L
.6255 .46199 L
.62827 .46331 L
.62936 .46385 L
.63323 .46577 L
.63598 .46718 L
.63709 .46775 L
.64095 .4698 L
.64323 .47104 L
.64481 .47191 L
.64867 .47409 L
.65008 .4749 L
.65253 .47633 L
.65639 .47864 L
.6566 .47876 L
.66026 .48101 L
.66283 .48262 L
.66412 .48344 L
.66798 .48594 L
.6688 .48648 L
.67184 .48851 L
.67455 .49035 L
.6757 .49114 L
.67956 .49383 L
.6801 .49421 L
.68343 .49659 L
.68546 .49807 L
.68729 .49941 L
.69066 .50193 L
.69115 .5023 L
.69501 .50525 L
.69571 .50579 L
.69887 .50827 L
.70062 .50965 L
.70273 .51135 L
.70541 .51352 L
.7066 .51449 L
.71007 .51738 L
.71046 .5177 L
.71432 .52097 L
.71463 .52124 L
.71818 .52431 L
.71909 .5251 L
.72204 .52771 L
.72345 .52896 L
.7259 .53117 L
.72772 .53282 L
.72977 .5347 L
.7319 .53669 L
.73363 .5383 L
.73601 .54055 L
.73749 .54196 L
.74004 .54441 L
.74135 .54568 L
.744 .54827 L
.74521 .54947 L
.74789 .55213 L
.74907 .55332 L
.75172 .55599 L
.75293 .55723 L
.75549 .55985 L
.7568 .56121 L
.7592 .56372 L
.76066 .56525 L
.76285 .56758 L
.76452 .56936 L
.76645 .57144 L
.76838 .57353 L
.77 .5753 L
.77224 .57777 L
.7735 .57916 L
.7761 .58207 L
.77695 .58302 L
.77997 .58643 L
.78036 .58689 L
.78373 .59075 L
.78383 .59086 L
.78705 .59461 L
.78769 .59536 L
.79034 .59847 L
.79155 .59991 L
.79358 .60233 L
.79541 .60453 L
.79679 .60619 L
.79927 .60922 L
.79996 .61006 L
.8031 .61392 L
.80314 .61397 L
.8062 .61778 L
.807 .61878 L
.80927 .62164 L
.81086 .62366 L
.81231 .6255 L
.81472 .6286 L
.81532 .62936 L
.81829 .63323 L
.81858 .6336 L
.82124 .63709 L
.82244 .63867 L
.82416 .64095 L
.82631 .6438 L
.82706 .64481 L
.82992 .64867 L
.83017 .649 L
.83277 .65253 L
.83403 .65426 L
.83558 .65639 L
.83789 .65959 L
.83837 .66026 L
.84114 .66412 L
.84175 .66498 L
.84389 .66798 L
.84561 .67043 L
.84661 .67184 L
.84931 .6757 L
.84947 .67595 L
.85198 .67956 L
.85334 .68153 L
.85464 .68343 L
.8572 .68717 L
.85728 .68729 L
.85989 .69115 L
.86106 .69288 L
.86249 .69501 L
.86492 .69865 L
.86507 .69887 L
.86763 .70273 L
.86878 .70449 L
.87017 .7066 L
.87264 .71039 L
.87269 .71046 L
.87519 .71432 L
.87651 .71636 L
.87768 .71818 L
.88015 .72204 L
.88037 .72239 L
.8826 .7259 L
.88423 .72848 L
.88504 .72977 L
.88746 .73363 L
.88809 .73464 L
.88987 .73749 L
.89195 .74086 L
.89226 .74135 L
.89463 .74521 L
.89581 .74714 L
.89699 .74907 L
.89934 .75293 L
.89968 .75349 L
.90352 .7568 L
.90354 .75683 L
.90354 .76066 L
.90354 .76066 L
.8997 .76452 L
.89968 .76454 L
.89585 .76838 L
.89586 .77224 L
.89581 .77229 L
.89201 .7761 L
.89195 .77616 L
.88816 .77997 L
.88809 .78003 L
.8843 .78383 L
.88431 .78769 L
.88423 .78777 L
.88045 .79155 L
.88037 .79163 L
.87659 .79541 L
.87651 .79549 L
.87272 .79927 L
.87272 .80314 L
.87264 .80321 L
.86886 .807 L
.86878 .80707 L
.86499 .81086 L
.86492 .81093 L
.86112 .81472 L
.86106 .81478 L
.85724 .81858 L
.8572 .81863 L
.85337 .82244 L
.85334 .82247 L
.84949 .82631 L
.84947 .82632 L
.84561 .82648 L
.8455 .82631 L
.84283 .82244 L
.84175 .82089 L
.84015 .81858 L
.83789 .81536 L
.83744 .81472 L
.83471 .81086 L
.83403 .80989 L
.83197 .807 L
.83017 .80448 L
.8292 .80314 L
.82641 .79927 L
.82631 .79913 L
.82359 .79541 L
.82244 .79384 L
.82075 .79155 L
.81858 .78862 L
.81789 .78769 L
.81501 .78383 L
.81472 .78345 L
.81209 .77997 L
.81086 .77834 L
.80916 .7761 L
.807 .77329 L
.80619 .77224 L
.8032 .76838 L
.80314 .7683 L
.80018 .76452 L
.79927 .76337 L
.79713 .76066 L
.79541 .7585 L
.79405 .7568 L
.79155 .7537 L
.79093 .75293 L
.78779 .74907 L
.78769 .74895 L
.78462 .74521 L
.78383 .74426 L
.78141 .74135 L
.77997 .73963 L
.77816 .73749 L
.7761 .73506 L
.77488 .73363 L
.77224 .73055 L
.77156 .72977 L
.76838 .7261 L
.76821 .7259 L
.76481 .72204 L
.76452 .72172 L
.76137 .71818 L
.76066 .71739 L
.75789 .71432 L
.7568 .71312 L
.75436 .71046 L
.75293 .70891 L
.75079 .7066 L
.74907 .70476 L
.74717 .70273 L
.74521 .70067 L
.7435 .69887 L
.74135 .69664 L
.73977 .69501 L
.73749 .69267 L
.73599 .69115 L
.73363 .68876 L
.73216 .68729 L
.72977 .68491 L
.72826 .68343 L
.7259 .68112 L
.7243 .67956 L
.72204 .67739 L
.72027 .6757 L
.71818 .67372 L
.71618 .67184 L
.71432 .67011 L
.71201 .66798 L
.71046 .66656 L
.70777 .66412 L
.7066 .66307 L
.70344 .66026 L
.70273 .65963 L
.69902 .65639 L
.69887 .65626 L
.69501 .65295 L
.69452 .65253 L
.69115 .6497 L
.68991 .64867 L
.68729 .64651 L
.68521 .64481 L
.68343 .64337 L
.68039 .64095 L
.67956 .6403 L
.6757 .63729 L
.67544 .63709 L
.67184 .63433 L
.67037 .63323 L
.66798 .63144 L
.66516 .62936 L
.66412 .6286 L
.66026 .62583 L
.6598 .6255 L
.65639 .62311 L
.65426 .62164 L
.65253 .62046 L
.64867 .61786 L
.64855 .61778 L
.64481 .61532 L
.64263 .61392 L
.64095 .61285 L
.63709 .61043 L
.63648 .61006 L
.63323 .60807 L
.63008 .60619 L
.62936 .60577 L
.6255 .60353 L
.62339 .60233 L
.62164 .60135 L
.61778 .59923 L
.61637 .59847 L
.61392 .59717 L
.61006 .59517 L
.60896 .59461 L
.60619 .59322 L
.60233 .59134 L
.60109 .59075 L
.59847 .58952 L
.59461 .58775 L
.59267 .58689 L
.59075 .58604 L
.58689 .5844 L
.58355 .58302 L
.58302 .58281 L
.57916 .58128 L
.5753 .57981 L
.57354 .57916 L
.57144 .5784 L
.56758 .57705 L
.56372 .57576 L
.56231 .5753 L
.55985 .57452 L
.55599 .57335 L
.55213 .57223 L
.54925 .57144 L
.54827 .57118 L
.54441 .57018 L
.54055 .56924 L
.53669 .56836 L
.53301 .56758 L
.53282 .56754 L
.52896 .56678 L
.5251 .56607 L
.52124 .56543 L
.51738 .56484 L
.51352 .56431 L
.50965 .56384 L
.50854 .56372 L
.50579 .56343 L
.50193 .56308 L
.49807 .56278 L
.49421 .56254 L
.49035 .56237 L
.48648 .56225 L
.48262 .56218 L
.47876 .56218 L
.4749 .56223 L
.47104 .56234 L
.46718 .56251 L
.46331 .56274 L
.45945 .56302 L
.45559 .56337 L
.45219 .56372 L
.45173 .56377 L
.44787 .56422 L
.44401 .56474 L
.44015 .56531 L
.43628 .56594 L
.43242 .56663 L
.42856 .56737 L
.42753 .56758 L
.4247 .56817 L
.42084 .56903 L
.41698 .56994 L
.41311 .57091 L
.4111 .57144 L
.40925 .57194 L
.40539 .57302 L
.40153 .57416 L
.39785 .5753 L
.39767 .57536 L
.39381 .57661 L
.38994 .57792 L
.38641 .57916 L
.38608 .57928 L
.38222 .5807 L
.37836 .58217 L
.37619 .58302 L
.3745 .5837 L
.37064 .58529 L
.36686 .58689 L
.36677 .58692 L
.36291 .58862 L
.35905 .59036 L
.35822 .59075 L
.35519 .59217 L
.35133 .59402 L
.35013 .59461 L
.34747 .59593 L
.34361 .59789 L
.34249 .59847 L
.33974 .59991 L
.33588 .60198 L
.33523 .60233 L
.33202 .6041 L
.32829 .60619 L
.32816 .60627 L
.3243 .6085 L
.32164 .61006 L
.32044 .61077 L
.31657 .6131 L
.31523 .61392 L
.31271 .61547 L
.30904 .61778 L
.30885 .6179 L
.30499 .62038 L
.30305 .62164 L
.30113 .6229 L
.29727 .62547 L
.29722 .6255 L
.2934 .6281 L
.29156 .62936 L
.28954 .63076 L
.28603 .63323 L
.28568 .63347 L
.28182 .63623 L
.28064 .63709 L
.27796 .63903 L
.27535 .64095 L
.2741 .64188 L
.27023 .64476 L
.27017 .64481 L
.26637 .64769 L
.26509 .64867 L
.26251 .65066 L
.26009 .65253 L
.25865 .65366 L
.25516 .65639 L
.25479 .65669 L
.25093 .65976 L
.25031 .66026 L
.24707 .66286 L
.24551 .66412 L
.2432 .66598 L
.24076 .66798 L
.23934 .66913 L
.23604 .67184 L
.23548 .6723 L
.23162 .67548 L
.23135 .6757 L
.22776 .67866 L
.22668 .67956 L
.2239 .68185 L
.222 .68343 L
.22003 .68502 L
.21728 .68729 L
.21617 .68817 L
.21246 .69115 L
.21231 .69126 L
.20845 .6943 L
.20767 .69501 L
.20459 .69722 L
.20256 .69887 L
.20073 .69995 L
.19686 .70237 L
.19613 .70273 L
.193 .70421 L
.18914 .70292 L
.18908 .70273 L
.18914 .69907 L
.18918 .69887 L
.19002 .69501 L
.19159 .69115 L
.193 .68775 L
.19329 .68729 L
.19509 .68343 L
.19686 .6799 L
.19705 .67956 L
.19905 .6757 L
.20073 .67263 L
.20117 .67184 L
.20334 .66798 L
.20459 .66582 L
.20558 .66412 L
.20788 .66026 L
.20845 .65931 L
.21022 .65639 L
.21231 .65304 L
.21263 .65253 L
.21507 .64867 L
.21617 .64695 L
.21756 .64481 L
.22003 .64105 L
.2201 .64095 L
.22268 .63709 L
.2239 .63528 L
.2253 .63323 L
.22776 .62966 L
.22796 .62936 L
.23067 .6255 L
.23162 .62416 L
.23342 .62164 L
.23548 .61878 L
.23621 .61778 L
.23904 .61392 L
.23934 .61351 L
.24192 .61006 L
.2432 .60834 L
.24483 .60619 L
.24707 .60328 L
.2478 .60233 L
.25081 .59847 L
.25093 .59832 L
.25386 .59461 L
.25479 .59344 L
.25696 .59075 L
.25865 .58866 L
.2601 .58689 L
.26251 .58397 L
.2633 .58302 L
.26637 .57937 L
.26655 .57916 L
.26985 .5753 L
.27023 .57485 L
.2732 .57144 L
.2741 .57042 L
.27661 .56758 L
.27796 .56606 L
.28007 .56372 L
.28182 .56179 L
.2836 .55985 L
.28568 .5576 L
.28719 .55599 L
.28954 .55349 L
.29084 .55213 L
.2934 .54946 L
.29456 .54827 L
.29727 .54551 L
.29835 .54441 L
.30113 .54163 L
.30222 .54055 L
.30499 .53782 L
.30616 .53669 L
.30885 .5341 L
.31019 .53282 L
.31271 .53044 L
.3143 .52896 L
.31657 .52687 L
.31851 .5251 L
.32044 .52336 L
.32282 .52124 L
.3243 .51993 L
.32723 .51738 L
.32816 .51657 L
.33175 .51352 L
.33202 .51329 L
.33588 .51007 L
.33639 .50965 L
.33974 .50693 L
.34116 .50579 L
.34361 .50386 L
.34607 .50193 L
.34747 .50086 L
.35114 .49807 L
.35133 .49793 L
.35519 .49507 L
.35637 .49421 L
.35905 .49228 L
.36179 .49035 L
.36291 .48956 L
.36677 .48691 L
.36741 .48648 L
.37064 .48433 L
.37325 .48262 L
.3745 .48182 L
.37836 .47938 L
.37936 .47876 L
.38222 .47701 L
.38575 .4749 L
.38608 .47471 L
.38994 .47247 L
.39248 .47104 L
.39381 .4703 L
.39767 .46821 L
.39961 .46718 L
.40153 .46618 L
.40539 .46421 L
.40721 .46331 L
.40925 .46232 L
.41311 .46049 L
.41538 .45945 L
.41698 .45873 L
.42084 .45704 L
.42428 .45559 L
.4247 .45542 L
.42856 .45386 L
.43242 .45237 L
.43414 .45173 L
.43628 .45095 L
.44015 .44959 L
.44401 .4483 L
.44536 .44787 L
.44787 .44708 L
.45173 .44593 L
.45559 .44484 L
.45871 .44401 L
.45945 .44381 L
.46331 .44286 L
.46718 .44197 L
.47104 .44115 L
.4749 .44039 L
.47622 .44015 L
F
0 g
.47876 .4397 m
.48262 .43907 L
.48648 .43851 L
.49035 .43802 L
.49421 .4376 L
.49807 .43723 L
.50193 .43694 L
.50579 .43671 L
.50965 .43655 L
.51352 .43645 L
.51738 .43642 L
.52124 .43645 L
.5251 .43655 L
.52896 .43671 L
.53282 .43694 L
.53669 .43724 L
.54055 .4376 L
.54441 .43802 L
.54827 .43851 L
.55213 .43907 L
.55599 .43969 L
.55858 .44015 L
.55985 .44038 L
.56372 .44113 L
.56758 .44195 L
.57144 .44283 L
.5753 .44378 L
.5762 .44401 L
.57916 .44479 L
.58302 .44587 L
.58689 .44701 L
.58966 .44787 L
.59075 .44821 L
.59461 .44949 L
.59847 .45082 L
.60099 .45173 L
.60233 .45222 L
.60619 .45369 L
.61006 .45522 L
.61097 .45559 L
.61392 .45682 L
.61778 .45848 L
.61998 .45945 L
.62164 .4602 L
.6255 .46199 L
.62827 .46331 L
.62936 .46385 L
.63323 .46577 L
.63598 .46718 L
.63709 .46775 L
Mistroke
.64095 .4698 L
.64323 .47104 L
.64481 .47191 L
.64867 .47409 L
.65008 .4749 L
.65253 .47633 L
.65639 .47864 L
.6566 .47876 L
.66026 .48101 L
.66283 .48262 L
.66412 .48344 L
.66798 .48594 L
.6688 .48648 L
.67184 .48851 L
.67455 .49035 L
.6757 .49114 L
.67956 .49383 L
.6801 .49421 L
.68343 .49659 L
.68546 .49807 L
.68729 .49941 L
.69066 .50193 L
.69115 .5023 L
.69501 .50525 L
.69571 .50579 L
.69887 .50827 L
.70062 .50965 L
.70273 .51135 L
.70541 .51352 L
.7066 .51449 L
.71007 .51738 L
.71046 .5177 L
.71432 .52097 L
.71463 .52124 L
.71818 .52431 L
.71909 .5251 L
.72204 .52771 L
.72345 .52896 L
.7259 .53117 L
.72772 .53282 L
.72977 .5347 L
.7319 .53669 L
.73363 .5383 L
.73601 .54055 L
.73749 .54196 L
.74004 .54441 L
.74135 .54568 L
.744 .54827 L
.74521 .54947 L
.74789 .55213 L
Mistroke
.74907 .55332 L
.75172 .55599 L
.75293 .55723 L
.75549 .55985 L
.7568 .56121 L
.7592 .56372 L
.76066 .56525 L
.76285 .56758 L
.76452 .56936 L
.76645 .57144 L
.76838 .57353 L
.77 .5753 L
.77224 .57777 L
.7735 .57916 L
.7761 .58207 L
.77695 .58302 L
.77997 .58643 L
.78036 .58689 L
.78373 .59075 L
.78383 .59086 L
.78705 .59461 L
.78769 .59536 L
.79034 .59847 L
.79155 .59991 L
.79358 .60233 L
.79541 .60453 L
.79679 .60619 L
.79927 .60922 L
.79996 .61006 L
.8031 .61392 L
.80314 .61397 L
.8062 .61778 L
.807 .61878 L
.80927 .62164 L
.81086 .62366 L
.81231 .6255 L
.81472 .6286 L
.81532 .62936 L
.81829 .63323 L
.81858 .6336 L
.82124 .63709 L
.82244 .63867 L
.82416 .64095 L
.82631 .6438 L
.82706 .64481 L
.82992 .64867 L
.83017 .649 L
.83277 .65253 L
.83403 .65426 L
.83558 .65639 L
Mistroke
.83789 .65959 L
.83837 .66026 L
.84114 .66412 L
.84175 .66498 L
.84389 .66798 L
.84561 .67043 L
.84661 .67184 L
.84931 .6757 L
.84947 .67595 L
.85198 .67956 L
.85334 .68153 L
.85464 .68343 L
.8572 .68717 L
.85728 .68729 L
.85989 .69115 L
.86106 .69288 L
.86249 .69501 L
.86492 .69865 L
.86507 .69887 L
.86763 .70273 L
.86878 .70449 L
.87017 .7066 L
.87264 .71039 L
.87269 .71046 L
.87519 .71432 L
.87651 .71636 L
.87768 .71818 L
.88015 .72204 L
.88037 .72239 L
.8826 .7259 L
.88423 .72848 L
.88504 .72977 L
.88746 .73363 L
.88809 .73464 L
.88987 .73749 L
.89195 .74086 L
.89226 .74135 L
.89463 .74521 L
.89581 .74714 L
.89699 .74907 L
.89934 .75293 L
.89968 .75349 L
.90352 .7568 L
.90354 .75683 L
.90354 .76066 L
.90354 .76066 L
.8997 .76452 L
.89968 .76454 L
.89585 .76838 L
.89586 .77224 L
Mistroke
.89581 .77229 L
.89201 .7761 L
.89195 .77616 L
.88816 .77997 L
.88809 .78003 L
.8843 .78383 L
.88431 .78769 L
.88423 .78777 L
.88045 .79155 L
.88037 .79163 L
.87659 .79541 L
.87651 .79549 L
.87272 .79927 L
.87272 .80314 L
.87264 .80321 L
.86886 .807 L
.86878 .80707 L
.86499 .81086 L
.86492 .81093 L
.86112 .81472 L
.86106 .81478 L
.85724 .81858 L
.8572 .81863 L
.85337 .82244 L
.85334 .82247 L
.84949 .82631 L
.84947 .82632 L
.84561 .82648 L
.8455 .82631 L
.84283 .82244 L
.84175 .82089 L
.84015 .81858 L
.83789 .81536 L
.83744 .81472 L
.83471 .81086 L
.83403 .80989 L
.83197 .807 L
.83017 .80448 L
.8292 .80314 L
.82641 .79927 L
.82631 .79913 L
.82359 .79541 L
.82244 .79384 L
.82075 .79155 L
.81858 .78862 L
.81789 .78769 L
.81501 .78383 L
.81472 .78345 L
.81209 .77997 L
.81086 .77834 L
Mistroke
.80916 .7761 L
.807 .77329 L
.80619 .77224 L
.8032 .76838 L
.80314 .7683 L
.80018 .76452 L
.79927 .76337 L
.79713 .76066 L
.79541 .7585 L
.79405 .7568 L
.79155 .7537 L
.79093 .75293 L
.78779 .74907 L
.78769 .74895 L
.78462 .74521 L
.78383 .74426 L
.78141 .74135 L
.77997 .73963 L
.77816 .73749 L
.7761 .73506 L
.77488 .73363 L
.77224 .73055 L
.77156 .72977 L
.76838 .7261 L
.76821 .7259 L
.76481 .72204 L
.76452 .72172 L
.76137 .71818 L
.76066 .71739 L
.75789 .71432 L
.7568 .71312 L
.75436 .71046 L
.75293 .70891 L
.75079 .7066 L
.74907 .70476 L
.74717 .70273 L
.74521 .70067 L
.7435 .69887 L
.74135 .69664 L
.73977 .69501 L
.73749 .69267 L
.73599 .69115 L
.73363 .68876 L
.73216 .68729 L
.72977 .68491 L
.72826 .68343 L
.7259 .68112 L
.7243 .67956 L
.72204 .67739 L
.72027 .6757 L
Mistroke
.71818 .67372 L
.71618 .67184 L
.71432 .67011 L
.71201 .66798 L
.71046 .66656 L
.70777 .66412 L
.7066 .66307 L
.70344 .66026 L
.70273 .65963 L
.69902 .65639 L
.69887 .65626 L
.69501 .65295 L
.69452 .65253 L
.69115 .6497 L
.68991 .64867 L
.68729 .64651 L
.68521 .64481 L
.68343 .64337 L
.68039 .64095 L
.67956 .6403 L
.6757 .63729 L
.67544 .63709 L
.67184 .63433 L
.67037 .63323 L
.66798 .63144 L
.66516 .62936 L
.66412 .6286 L
.66026 .62583 L
.6598 .6255 L
.65639 .62311 L
.65426 .62164 L
.65253 .62046 L
.64867 .61786 L
.64855 .61778 L
.64481 .61532 L
.64263 .61392 L
.64095 .61285 L
.63709 .61043 L
.63648 .61006 L
.63323 .60807 L
.63008 .60619 L
.62936 .60577 L
.6255 .60353 L
.62339 .60233 L
.62164 .60135 L
.61778 .59923 L
.61637 .59847 L
.61392 .59717 L
.61006 .59517 L
.60896 .59461 L
Mistroke
.60619 .59322 L
.60233 .59134 L
.60109 .59075 L
.59847 .58952 L
.59461 .58775 L
.59267 .58689 L
.59075 .58604 L
.58689 .5844 L
.58355 .58302 L
.58302 .58281 L
.57916 .58128 L
.5753 .57981 L
.57354 .57916 L
.57144 .5784 L
.56758 .57705 L
.56372 .57576 L
.56231 .5753 L
.55985 .57452 L
.55599 .57335 L
.55213 .57223 L
.54925 .57144 L
.54827 .57118 L
.54441 .57018 L
.54055 .56924 L
.53669 .56836 L
.53301 .56758 L
.53282 .56754 L
.52896 .56678 L
.5251 .56607 L
.52124 .56543 L
.51738 .56484 L
.51352 .56431 L
.50965 .56384 L
.50854 .56372 L
.50579 .56343 L
.50193 .56308 L
.49807 .56278 L
.49421 .56254 L
.49035 .56237 L
.48648 .56225 L
.48262 .56218 L
.47876 .56218 L
.4749 .56223 L
.47104 .56234 L
.46718 .56251 L
.46331 .56274 L
.45945 .56302 L
.45559 .56337 L
.45219 .56372 L
.45173 .56377 L
Mistroke
.44787 .56422 L
.44401 .56474 L
.44015 .56531 L
.43628 .56594 L
.43242 .56663 L
.42856 .56737 L
.42753 .56758 L
.4247 .56817 L
.42084 .56903 L
.41698 .56994 L
.41311 .57091 L
.4111 .57144 L
.40925 .57194 L
.40539 .57302 L
.40153 .57416 L
.39785 .5753 L
.39767 .57536 L
.39381 .57661 L
.38994 .57792 L
.38641 .57916 L
.38608 .57928 L
.38222 .5807 L
.37836 .58217 L
.37619 .58302 L
.3745 .5837 L
.37064 .58529 L
.36686 .58689 L
.36677 .58692 L
.36291 .58862 L
.35905 .59036 L
.35822 .59075 L
.35519 .59217 L
.35133 .59402 L
.35013 .59461 L
.34747 .59593 L
.34361 .59789 L
.34249 .59847 L
.33974 .59991 L
.33588 .60198 L
.33523 .60233 L
.33202 .6041 L
.32829 .60619 L
.32816 .60627 L
.3243 .6085 L
.32164 .61006 L
.32044 .61077 L
.31657 .6131 L
.31523 .61392 L
.31271 .61547 L
.30904 .61778 L
Mistroke
.30885 .6179 L
.30499 .62038 L
.30305 .62164 L
.30113 .6229 L
.29727 .62547 L
.29722 .6255 L
.2934 .6281 L
.29156 .62936 L
.28954 .63076 L
.28603 .63323 L
.28568 .63347 L
.28182 .63623 L
.28064 .63709 L
.27796 .63903 L
.27535 .64095 L
.2741 .64188 L
.27023 .64476 L
.27017 .64481 L
.26637 .64769 L
.26509 .64867 L
.26251 .65066 L
.26009 .65253 L
.25865 .65366 L
.25516 .65639 L
.25479 .65669 L
.25093 .65976 L
.25031 .66026 L
.24707 .66286 L
.24551 .66412 L
.2432 .66598 L
.24076 .66798 L
.23934 .66913 L
.23604 .67184 L
.23548 .6723 L
.23162 .67548 L
.23135 .6757 L
.22776 .67866 L
.22668 .67956 L
.2239 .68185 L
.222 .68343 L
.22003 .68502 L
.21728 .68729 L
.21617 .68817 L
.21246 .69115 L
.21231 .69126 L
.20845 .6943 L
.20767 .69501 L
.20459 .69722 L
.20256 .69887 L
.20073 .69995 L
Mistroke
.19686 .70237 L
.19613 .70273 L
.193 .70421 L
.18914 .70292 L
.18908 .70273 L
.18914 .69907 L
.18918 .69887 L
.19002 .69501 L
.19159 .69115 L
.193 .68775 L
.19329 .68729 L
.19509 .68343 L
.19686 .6799 L
.19705 .67956 L
.19905 .6757 L
.20073 .67263 L
.20117 .67184 L
.20334 .66798 L
.20459 .66582 L
.20558 .66412 L
.20788 .66026 L
.20845 .65931 L
.21022 .65639 L
.21231 .65304 L
.21263 .65253 L
.21507 .64867 L
.21617 .64695 L
.21756 .64481 L
.22003 .64105 L
.2201 .64095 L
.22268 .63709 L
.2239 .63528 L
.2253 .63323 L
.22776 .62966 L
.22796 .62936 L
.23067 .6255 L
.23162 .62416 L
.23342 .62164 L
.23548 .61878 L
.23621 .61778 L
.23904 .61392 L
.23934 .61351 L
.24192 .61006 L
.2432 .60834 L
.24483 .60619 L
.24707 .60328 L
.2478 .60233 L
.25081 .59847 L
.25093 .59832 L
.25386 .59461 L
Mistroke
.25479 .59344 L
.25696 .59075 L
.25865 .58866 L
.2601 .58689 L
.26251 .58397 L
.2633 .58302 L
.26637 .57937 L
.26655 .57916 L
.26985 .5753 L
.27023 .57485 L
.2732 .57144 L
.2741 .57042 L
.27661 .56758 L
.27796 .56606 L
.28007 .56372 L
.28182 .56179 L
.2836 .55985 L
.28568 .5576 L
.28719 .55599 L
.28954 .55349 L
.29084 .55213 L
.2934 .54946 L
.29456 .54827 L
.29727 .54551 L
.29835 .54441 L
.30113 .54163 L
.30222 .54055 L
.30499 .53782 L
.30616 .53669 L
.30885 .5341 L
.31019 .53282 L
.31271 .53044 L
.3143 .52896 L
.31657 .52687 L
.31851 .5251 L
.32044 .52336 L
.32282 .52124 L
.3243 .51993 L
.32723 .51738 L
.32816 .51657 L
.33175 .51352 L
.33202 .51329 L
.33588 .51007 L
.33639 .50965 L
.33974 .50693 L
.34116 .50579 L
.34361 .50386 L
.34607 .50193 L
.34747 .50086 L
.35114 .49807 L
Mistroke
.35133 .49793 L
.35519 .49507 L
.35637 .49421 L
.35905 .49228 L
.36179 .49035 L
.36291 .48956 L
.36677 .48691 L
.36741 .48648 L
.37064 .48433 L
.37325 .48262 L
.3745 .48182 L
.37836 .47938 L
.37936 .47876 L
.38222 .47701 L
.38575 .4749 L
.38608 .47471 L
.38994 .47247 L
.39248 .47104 L
.39381 .4703 L
.39767 .46821 L
.39961 .46718 L
.40153 .46618 L
.40539 .46421 L
.40721 .46331 L
.40925 .46232 L
.41311 .46049 L
.41538 .45945 L
.41698 .45873 L
.42084 .45704 L
.42428 .45559 L
.4247 .45542 L
.42856 .45386 L
.43242 .45237 L
.43414 .45173 L
.43628 .45095 L
.44015 .44959 L
.44401 .4483 L
.44536 .44787 L
.44787 .44708 L
.45173 .44593 L
.45559 .44484 L
.45871 .44401 L
.45945 .44381 L
.46331 .44286 L
.46718 .44197 L
.47104 .44115 L
.4749 .44039 L
.47622 .44015 L
.47876 .4397 L
Mfstroke
1 .55 .5 r
.48648 .45509 m
.49035 .45448 L
.49421 .45395 L
.49807 .45348 L
.50193 .45309 L
.50579 .45276 L
.50965 .4525 L
.51352 .4523 L
.51738 .45218 L
.52124 .45212 L
.5251 .45214 L
.52896 .45221 L
.53282 .45236 L
.53669 .45258 L
.54055 .45286 L
.54441 .45321 L
.54827 .45362 L
.55213 .4541 L
.55599 .45465 L
.55985 .45527 L
.56171 .45559 L
.56372 .45595 L
.56758 .4567 L
.57144 .45752 L
.5753 .4584 L
.57916 .45935 L
.57955 .45945 L
.58302 .46037 L
.58689 .46145 L
.59075 .4626 L
.59304 .46331 L
.59461 .46382 L
.59847 .4651 L
.60233 .46644 L
.60436 .46718 L
.60619 .46786 L
.61006 .46933 L
.61392 .47088 L
.6143 .47104 L
.61778 .47249 L
.62164 .47417 L
.62328 .4749 L
.6255 .47591 L
.62936 .47772 L
.63154 .47876 L
.63323 .47959 L
.63709 .48153 L
.63921 .48262 L
.64095 .48353 L
.64481 .4856 L
.64642 .48648 L
.64867 .48774 L
.65253 .48994 L
.65324 .49035 L
.65639 .4922 L
.65972 .49421 L
.66026 .49454 L
.66412 .49693 L
.66591 .49807 L
.66798 .49939 L
.67184 .50192 L
.67185 .50193 L
.6757 .50451 L
.67757 .50579 L
.67956 .50717 L
.68309 .50965 L
.68343 .5099 L
.68729 .51268 L
.68842 .51352 L
.69115 .51554 L
.69359 .51738 L
.69501 .51845 L
.69862 .52124 L
.69887 .52144 L
.70273 .52449 L
.7035 .5251 L
.7066 .5276 L
.70826 .52896 L
.71046 .53078 L
.7129 .53282 L
.71432 .53402 L
.71743 .53669 L
.71818 .53733 L
.72187 .54055 L
.72204 .5407 L
.7259 .54414 L
.7262 .54441 L
.72977 .54764 L
.73045 .54827 L
.73363 .55121 L
.73461 .55213 L
.73749 .55484 L
.7387 .55599 L
.74135 .55854 L
.74271 .55985 L
.74521 .5623 L
.74665 .56372 L
.74907 .56613 L
.75052 .56758 L
.75293 .57002 L
.75433 .57144 L
.7568 .57398 L
.75808 .5753 L
.76066 .578 L
.76177 .57916 L
.76452 .58208 L
.7654 .58302 L
.76838 .58623 L
.76899 .58689 L
.77224 .59045 L
.77252 .59075 L
.776 .59461 L
.7761 .59473 L
.77944 .59847 L
.77997 .59907 L
.78283 .60233 L
.78383 .60348 L
.78618 .60619 L
.78769 .60795 L
.78949 .61006 L
.79155 .61249 L
.79276 .61392 L
.79541 .61709 L
.79599 .61778 L
.79918 .62164 L
.79927 .62176 L
.80233 .6255 L
.80314 .62649 L
.80546 .62936 L
.807 .63128 L
.80855 .63323 L
.81086 .63614 L
.8116 .63709 L
.81463 .64095 L
.81472 .64107 L
.81762 .64481 L
.81858 .64606 L
.82059 .64867 L
.82244 .65111 L
.82352 .65253 L
.82631 .65623 L
.82643 .65639 L
.82931 .66026 L
.83017 .66141 L
.83216 .66412 L
.83403 .66666 L
.83499 .66798 L
.8378 .67184 L
.83789 .67197 L
.84058 .6757 L
.84175 .67735 L
.84333 .67956 L
.84561 .68279 L
.84606 .68343 L
.84877 .68729 L
.84947 .68829 L
.85146 .69115 L
.85334 .69386 L
.85413 .69501 L
.85677 .69887 L
.8572 .6995 L
.8594 .70273 L
.86106 .70519 L
.862 .7066 L
.86459 .71046 L
.86492 .71096 L
.86716 .71432 L
.86878 .71678 L
.8697 .71818 L
.87223 .72204 L
.87264 .72267 L
.87475 .7259 L
.87651 .72863 L
.87724 .72977 L
.87972 .73363 L
.88037 .73465 L
.88218 .73749 L
.88423 .74073 L
.88462 .74135 L
.88705 .74521 L
.88809 .74688 L
.88946 .74907 L
.89185 .75293 L
.89195 .75309 L
.89424 .7568 L
.89581 .75937 L
.8966 .76066 L
.89967 .76452 L
.89583 .76838 L
.89583 .77224 L
.89581 .77226 L
.89199 .7761 L
.89195 .77614 L
.88813 .77997 L
.88809 .78001 L
.88428 .78383 L
.88428 .78769 L
.88423 .78774 L
.88042 .79155 L
.88037 .79161 L
.87656 .79541 L
.87651 .79547 L
.8727 .79927 L
.8727 .80314 L
.87264 .80319 L
.86883 .807 L
.86878 .80705 L
.86496 .81086 L
.86492 .8109 L
.86109 .81472 L
.86106 .81475 L
.85722 .81858 L
.8572 .8186 L
.85334 .82244 L
.85334 .82245 L
.8495 .82244 L
.84947 .81978 L
.84866 .81858 L
.84603 .81472 L
.84561 .81412 L
.84337 .81086 L
.84175 .80852 L
.8407 .807 L
.838 .80314 L
.83789 .80297 L
.83529 .79927 L
.83403 .79749 L
.83255 .79541 L
.83017 .79207 L
.8298 .79155 L
.82702 .78769 L
.82631 .78671 L
.82421 .78383 L
.82244 .7814 L
.82139 .77997 L
.81858 .77616 L
.81854 .7761 L
.81567 .77224 L
.81472 .77097 L
.81277 .76838 L
.81086 .76585 L
.80985 .76452 L
.807 .76078 L
.8069 .76066 L
.80392 .7568 L
.80314 .75578 L
.80092 .75293 L
.79927 .75083 L
.79789 .74907 L
.79541 .74595 L
.79483 .74521 L
.79174 .74135 L
.79155 .74112 L
.78861 .73749 L
.78769 .73635 L
.78546 .73363 L
.78383 .73164 L
.78227 .72977 L
.77997 .727 L
.77905 .7259 L
.7761 .72241 L
.7758 .72204 L
.7725 .71818 L
.77224 .71788 L
.76917 .71432 L
.76838 .71341 L
.7658 .71046 L
.76452 .709 L
.7624 .7066 L
.76066 .70465 L
.75894 .70273 L
.7568 .70035 L
.75545 .69887 L
.75293 .69612 L
.75191 .69501 L
.74907 .69195 L
.74833 .69115 L
.74521 .68783 L
.74469 .68729 L
.74135 .68378 L
.74101 .68343 L
.73749 .67978 L
.73727 .67956 L
.73363 .67585 L
.73348 .6757 L
.72977 .67197 L
.72963 .67184 L
.7259 .66815 L
.72572 .66798 L
.72204 .6644 L
.72175 .66412 L
.71818 .6607 L
.71772 .66026 L
.71432 .65706 L
.71361 .65639 L
.71046 .65348 L
.70943 .65253 L
.7066 .64996 L
.70517 .64867 L
.70273 .64649 L
.70083 .64481 L
.69887 .64309 L
.69641 .64095 L
.69501 .63975 L
.69189 .63709 L
.69115 .63646 L
.68729 .63324 L
.68728 .63323 L
.68343 .63007 L
.68256 .62936 L
.67956 .62696 L
.67773 .6255 L
.6757 .62391 L
.67278 .62164 L
.67184 .62092 L
.66798 .61799 L
.6677 .61778 L
.66412 .61512 L
.66248 .61392 L
.66026 .6123 L
.65711 .61006 L
.65639 .60955 L
.65253 .60685 L
.65158 .60619 L
.64867 .60421 L
.64587 .60233 L
.64481 .60163 L
.64095 .59911 L
.63995 .59847 L
.63709 .59665 L
.63381 .59461 L
.63323 .59425 L
.62936 .5919 L
.62743 .59075 L
.6255 .58962 L
.62164 .58739 L
.62076 .58689 L
.61778 .58522 L
.61392 .58311 L
.61377 .58302 L
.61006 .58105 L
.6064 .57916 L
.60619 .57906 L
.60233 .57712 L
.5986 .5753 L
.59847 .57524 L
.59461 .57342 L
.59075 .57166 L
.59026 .57144 L
.58689 .56995 L
.58302 .56831 L
.58128 .56758 L
.57916 .56672 L
.5753 .56518 L
.57146 .56372 L
.57144 .56371 L
.56758 .56229 L
.56372 .56093 L
.56053 .55985 L
.55985 .55963 L
.55599 .55839 L
.55213 .5572 L
.54827 .55607 L
.548 .55599 L
.54441 .555 L
.54055 .55398 L
.53669 .55302 L
.53287 .55213 L
.53282 .55212 L
.52896 .55127 L
.5251 .55049 L
.52124 .54975 L
.51738 .54908 L
.51352 .54846 L
.51229 .54827 L
.50965 .54789 L
.50579 .54738 L
.50193 .54693 L
.49807 .54653 L
.49421 .54619 L
.49035 .5459 L
.48648 .54567 L
.48262 .54549 L
.47876 .54537 L
.4749 .5453 L
.47104 .54529 L
.46718 .54533 L
.46331 .54542 L
.45945 .54557 L
.45559 .54577 L
.45173 .54603 L
.44787 .54633 L
.44401 .54669 L
.44015 .5471 L
.43628 .54756 L
.43242 .54807 L
.431 .54827 L
.42856 .54863 L
.4247 .54924 L
.42084 .5499 L
.41698 .55061 L
.41311 .55137 L
.40945 .55213 L
.40925 .55217 L
.40539 .55303 L
.40153 .55392 L
.39767 .55487 L
.39381 .55585 L
.39325 .55599 L
.38994 .55688 L
.38608 .55795 L
.38222 .55905 L
.3795 .55985 L
.37836 .5602 L
.3745 .56138 L
.37064 .56259 L
.36714 .56372 L
.36677 .56384 L
.36291 .56511 L
.35905 .56641 L
.35561 .56758 L
.35519 .56772 L
.35133 .56906 L
.34747 .5704 L
.34444 .57144 L
.34361 .57173 L
.33974 .57306 L
.33588 .57436 L
.33297 .5753 L
.33202 .5756 L
.32816 .57679 L
.3243 .57785 L
.32044 .57869 L
.31657 .57911 L
.31271 .57857 L
.31029 .5753 L
.31095 .57144 L
.3126 .56758 L
.31271 .5673 L
.31474 .56372 L
.31657 .56072 L
.31726 .55985 L
.32005 .55599 L
.32044 .55547 L
.32306 .55213 L
.3243 .55059 L
.32626 .54827 L
.32816 .54605 L
.32964 .54441 L
.33202 .54177 L
.33317 .54055 L
.33588 .53769 L
.33687 .53669 L
.33974 .53378 L
.34072 .53282 L
.34361 .53002 L
.34472 .52896 L
.34747 .52639 L
.34888 .5251 L
.35133 .52289 L
.35321 .52124 L
.35519 .51951 L
.3577 .51738 L
.35905 .51624 L
.36236 .51352 L
.36291 .51307 L
.36677 .51 L
.36722 .50965 L
.37064 .50702 L
.37228 .50579 L
.3745 .50414 L
.37755 .50193 L
.37836 .50136 L
.38222 .49865 L
.38308 .49807 L
.38608 .49604 L
.38887 .49421 L
.38994 .49351 L
.39381 .49106 L
.39497 .49035 L
.39767 .4887 L
.40141 .48648 L
.40153 .48642 L
.40539 .48421 L
.40826 .48262 L
.40925 .48208 L
.41311 .48003 L
.41559 .47876 L
.41698 .47806 L
.42084 .47617 L
.42351 .4749 L
.4247 .47435 L
.42856 .4726 L
.43217 .47104 L
.43242 .47093 L
.43628 .46933 L
.44015 .46781 L
.4418 .46718 L
.44401 .46635 L
.44787 .46497 L
.45173 .46367 L
.45281 .46331 L
.45559 .46243 L
.45945 .46127 L
.46331 .46017 L
.46601 .45945 L
.46718 .45915 L
.47104 .4582 L
.4749 .45732 L
.47876 .4565 L
.48262 .45576 L
.48356 .45559 L
F
0 g
.48648 .45509 m
.49035 .45448 L
.49421 .45395 L
.49807 .45348 L
.50193 .45309 L
.50579 .45276 L
.50965 .4525 L
.51352 .4523 L
.51738 .45218 L
.52124 .45212 L
.5251 .45214 L
.52896 .45221 L
.53282 .45236 L
.53669 .45258 L
.54055 .45286 L
.54441 .45321 L
.54827 .45362 L
.55213 .4541 L
.55599 .45465 L
.55985 .45527 L
.56171 .45559 L
.56372 .45595 L
.56758 .4567 L
.57144 .45752 L
.5753 .4584 L
.57916 .45935 L
.57955 .45945 L
.58302 .46037 L
.58689 .46145 L
.59075 .4626 L
.59304 .46331 L
.59461 .46382 L
.59847 .4651 L
.60233 .46644 L
.60436 .46718 L
.60619 .46786 L
.61006 .46933 L
.61392 .47088 L
.6143 .47104 L
.61778 .47249 L
.62164 .47417 L
.62328 .4749 L
.6255 .47591 L
.62936 .47772 L
.63154 .47876 L
.63323 .47959 L
.63709 .48153 L
.63921 .48262 L
.64095 .48353 L
.64481 .4856 L
Mistroke
.64642 .48648 L
.64867 .48774 L
.65253 .48994 L
.65324 .49035 L
.65639 .4922 L
.65972 .49421 L
.66026 .49454 L
.66412 .49693 L
.66591 .49807 L
.66798 .49939 L
.67184 .50192 L
.67185 .50193 L
.6757 .50451 L
.67757 .50579 L
.67956 .50717 L
.68309 .50965 L
.68343 .5099 L
.68729 .51268 L
.68842 .51352 L
.69115 .51554 L
.69359 .51738 L
.69501 .51845 L
.69862 .52124 L
.69887 .52144 L
.70273 .52449 L
.7035 .5251 L
.7066 .5276 L
.70826 .52896 L
.71046 .53078 L
.7129 .53282 L
.71432 .53402 L
.71743 .53669 L
.71818 .53733 L
.72187 .54055 L
.72204 .5407 L
.7259 .54414 L
.7262 .54441 L
.72977 .54764 L
.73045 .54827 L
.73363 .55121 L
.73461 .55213 L
.73749 .55484 L
.7387 .55599 L
.74135 .55854 L
.74271 .55985 L
.74521 .5623 L
.74665 .56372 L
.74907 .56613 L
.75052 .56758 L
.75293 .57002 L
Mistroke
.75433 .57144 L
.7568 .57398 L
.75808 .5753 L
.76066 .578 L
.76177 .57916 L
.76452 .58208 L
.7654 .58302 L
.76838 .58623 L
.76899 .58689 L
.77224 .59045 L
.77252 .59075 L
.776 .59461 L
.7761 .59473 L
.77944 .59847 L
.77997 .59907 L
.78283 .60233 L
.78383 .60348 L
.78618 .60619 L
.78769 .60795 L
.78949 .61006 L
.79155 .61249 L
.79276 .61392 L
.79541 .61709 L
.79599 .61778 L
.79918 .62164 L
.79927 .62176 L
.80233 .6255 L
.80314 .62649 L
.80546 .62936 L
.807 .63128 L
.80855 .63323 L
.81086 .63614 L
.8116 .63709 L
.81463 .64095 L
.81472 .64107 L
.81762 .64481 L
.81858 .64606 L
.82059 .64867 L
.82244 .65111 L
.82352 .65253 L
.82631 .65623 L
.82643 .65639 L
.82931 .66026 L
.83017 .66141 L
.83216 .66412 L
.83403 .66666 L
.83499 .66798 L
.8378 .67184 L
.83789 .67197 L
.84058 .6757 L
Mistroke
.84175 .67735 L
.84333 .67956 L
.84561 .68279 L
.84606 .68343 L
.84877 .68729 L
.84947 .68829 L
.85146 .69115 L
.85334 .69386 L
.85413 .69501 L
.85677 .69887 L
.8572 .6995 L
.8594 .70273 L
.86106 .70519 L
.862 .7066 L
.86459 .71046 L
.86492 .71096 L
.86716 .71432 L
.86878 .71678 L
.8697 .71818 L
.87223 .72204 L
.87264 .72267 L
.87475 .7259 L
.87651 .72863 L
.87724 .72977 L
.87972 .73363 L
.88037 .73465 L
.88218 .73749 L
.88423 .74073 L
.88462 .74135 L
.88705 .74521 L
.88809 .74688 L
.88946 .74907 L
.89185 .75293 L
.89195 .75309 L
.89424 .7568 L
.89581 .75937 L
.8966 .76066 L
.89967 .76452 L
.89583 .76838 L
.89583 .77224 L
.89581 .77226 L
.89199 .7761 L
.89195 .77614 L
.88813 .77997 L
.88809 .78001 L
.88428 .78383 L
.88428 .78769 L
.88423 .78774 L
.88042 .79155 L
.88037 .79161 L
Mistroke
.87656 .79541 L
.87651 .79547 L
.8727 .79927 L
.8727 .80314 L
.87264 .80319 L
.86883 .807 L
.86878 .80705 L
.86496 .81086 L
.86492 .8109 L
.86109 .81472 L
.86106 .81475 L
.85722 .81858 L
.8572 .8186 L
.85334 .82244 L
.85334 .82245 L
.8495 .82244 L
.84947 .81978 L
.84866 .81858 L
.84603 .81472 L
.84561 .81412 L
.84337 .81086 L
.84175 .80852 L
.8407 .807 L
.838 .80314 L
.83789 .80297 L
.83529 .79927 L
.83403 .79749 L
.83255 .79541 L
.83017 .79207 L
.8298 .79155 L
.82702 .78769 L
.82631 .78671 L
.82421 .78383 L
.82244 .7814 L
.82139 .77997 L
.81858 .77616 L
.81854 .7761 L
.81567 .77224 L
.81472 .77097 L
.81277 .76838 L
.81086 .76585 L
.80985 .76452 L
.807 .76078 L
.8069 .76066 L
.80392 .7568 L
.80314 .75578 L
.80092 .75293 L
.79927 .75083 L
.79789 .74907 L
.79541 .74595 L
Mistroke
.79483 .74521 L
.79174 .74135 L
.79155 .74112 L
.78861 .73749 L
.78769 .73635 L
.78546 .73363 L
.78383 .73164 L
.78227 .72977 L
.77997 .727 L
.77905 .7259 L
.7761 .72241 L
.7758 .72204 L
.7725 .71818 L
.77224 .71788 L
.76917 .71432 L
.76838 .71341 L
.7658 .71046 L
.76452 .709 L
.7624 .7066 L
.76066 .70465 L
.75894 .70273 L
.7568 .70035 L
.75545 .69887 L
.75293 .69612 L
.75191 .69501 L
.74907 .69195 L
.74833 .69115 L
.74521 .68783 L
.74469 .68729 L
.74135 .68378 L
.74101 .68343 L
.73749 .67978 L
.73727 .67956 L
.73363 .67585 L
.73348 .6757 L
.72977 .67197 L
.72963 .67184 L
.7259 .66815 L
.72572 .66798 L
.72204 .6644 L
.72175 .66412 L
.71818 .6607 L
.71772 .66026 L
.71432 .65706 L
.71361 .65639 L
.71046 .65348 L
.70943 .65253 L
.7066 .64996 L
.70517 .64867 L
.70273 .64649 L
Mistroke
.70083 .64481 L
.69887 .64309 L
.69641 .64095 L
.69501 .63975 L
.69189 .63709 L
.69115 .63646 L
.68729 .63324 L
.68728 .63323 L
.68343 .63007 L
.68256 .62936 L
.67956 .62696 L
.67773 .6255 L
.6757 .62391 L
.67278 .62164 L
.67184 .62092 L
.66798 .61799 L
.6677 .61778 L
.66412 .61512 L
.66248 .61392 L
.66026 .6123 L
.65711 .61006 L
.65639 .60955 L
.65253 .60685 L
.65158 .60619 L
.64867 .60421 L
.64587 .60233 L
.64481 .60163 L
.64095 .59911 L
.63995 .59847 L
.63709 .59665 L
.63381 .59461 L
.63323 .59425 L
.62936 .5919 L
.62743 .59075 L
.6255 .58962 L
.62164 .58739 L
.62076 .58689 L
.61778 .58522 L
.61392 .58311 L
.61377 .58302 L
.61006 .58105 L
.6064 .57916 L
.60619 .57906 L
.60233 .57712 L
.5986 .5753 L
.59847 .57524 L
.59461 .57342 L
.59075 .57166 L
.59026 .57144 L
.58689 .56995 L
Mistroke
.58302 .56831 L
.58128 .56758 L
.57916 .56672 L
.5753 .56518 L
.57146 .56372 L
.57144 .56371 L
.56758 .56229 L
.56372 .56093 L
.56053 .55985 L
.55985 .55963 L
.55599 .55839 L
.55213 .5572 L
.54827 .55607 L
.548 .55599 L
.54441 .555 L
.54055 .55398 L
.53669 .55302 L
.53287 .55213 L
.53282 .55212 L
.52896 .55127 L
.5251 .55049 L
.52124 .54975 L
.51738 .54908 L
.51352 .54846 L
.51229 .54827 L
.50965 .54789 L
.50579 .54738 L
.50193 .54693 L
.49807 .54653 L
.49421 .54619 L
.49035 .5459 L
.48648 .54567 L
.48262 .54549 L
.47876 .54537 L
.4749 .5453 L
.47104 .54529 L
.46718 .54533 L
.46331 .54542 L
.45945 .54557 L
.45559 .54577 L
.45173 .54603 L
.44787 .54633 L
.44401 .54669 L
.44015 .5471 L
.43628 .54756 L
.43242 .54807 L
.431 .54827 L
.42856 .54863 L
.4247 .54924 L
.42084 .5499 L
Mistroke
.41698 .55061 L
.41311 .55137 L
.40945 .55213 L
.40925 .55217 L
.40539 .55303 L
.40153 .55392 L
.39767 .55487 L
.39381 .55585 L
.39325 .55599 L
.38994 .55688 L
.38608 .55795 L
.38222 .55905 L
.3795 .55985 L
.37836 .5602 L
.3745 .56138 L
.37064 .56259 L
.36714 .56372 L
.36677 .56384 L
.36291 .56511 L
.35905 .56641 L
.35561 .56758 L
.35519 .56772 L
.35133 .56906 L
.34747 .5704 L
.34444 .57144 L
.34361 .57173 L
.33974 .57306 L
.33588 .57436 L
.33297 .5753 L
.33202 .5756 L
.32816 .57679 L
.3243 .57785 L
.32044 .57869 L
.31657 .57911 L
.31271 .57857 L
.31029 .5753 L
.31095 .57144 L
.3126 .56758 L
.31271 .5673 L
.31474 .56372 L
.31657 .56072 L
.31726 .55985 L
.32005 .55599 L
.32044 .55547 L
.32306 .55213 L
.3243 .55059 L
.32626 .54827 L
.32816 .54605 L
.32964 .54441 L
.33202 .54177 L
Mistroke
.33317 .54055 L
.33588 .53769 L
.33687 .53669 L
.33974 .53378 L
.34072 .53282 L
.34361 .53002 L
.34472 .52896 L
.34747 .52639 L
.34888 .5251 L
.35133 .52289 L
.35321 .52124 L
.35519 .51951 L
.3577 .51738 L
.35905 .51624 L
.36236 .51352 L
.36291 .51307 L
.36677 .51 L
.36722 .50965 L
.37064 .50702 L
.37228 .50579 L
.3745 .50414 L
.37755 .50193 L
.37836 .50136 L
.38222 .49865 L
.38308 .49807 L
.38608 .49604 L
.38887 .49421 L
.38994 .49351 L
.39381 .49106 L
.39497 .49035 L
.39767 .4887 L
.40141 .48648 L
.40153 .48642 L
.40539 .48421 L
.40826 .48262 L
.40925 .48208 L
.41311 .48003 L
.41559 .47876 L
.41698 .47806 L
.42084 .47617 L
.42351 .4749 L
.4247 .47435 L
.42856 .4726 L
.43217 .47104 L
.43242 .47093 L
.43628 .46933 L
.44015 .46781 L
.4418 .46718 L
.44401 .46635 L
.44787 .46497 L
Mistroke
.45173 .46367 L
.45281 .46331 L
.45559 .46243 L
.45945 .46127 L
.46331 .46017 L
.46601 .45945 L
.46718 .45915 L
.47104 .4582 L
.4749 .45732 L
.47876 .4565 L
.48262 .45576 L
.48356 .45559 L
.48648 .45509 L
Mfstroke
1 .543 .5 r
.49421 .47084 m
.49807 .47015 L
.50193 .46953 L
.50579 .46899 L
.50965 .46854 L
.51352 .46816 L
.51738 .46785 L
.52124 .46762 L
.5251 .46747 L
.52896 .46739 L
.53282 .46738 L
.53669 .46745 L
.54055 .46759 L
.54441 .46781 L
.54827 .46809 L
.55213 .46845 L
.55599 .46887 L
.55985 .46937 L
.56372 .46994 L
.56758 .47059 L
.57008 .47104 L
.57144 .4713 L
.5753 .47208 L
.57916 .47293 L
.58302 .47385 L
.58689 .47484 L
.58713 .4749 L
.59075 .47589 L
.59461 .47702 L
.59847 .47822 L
.60016 .47876 L
.60233 .47948 L
.60619 .48081 L
.61006 .48221 L
.61115 .48262 L
.61392 .48368 L
.61778 .48522 L
.62084 .48648 L
.62164 .48682 L
.6255 .4885 L
.62936 .49024 L
.6296 .49035 L
.63323 .49204 L
.63709 .49392 L
.63767 .49421 L
.64095 .49586 L
.64481 .49787 L
.64519 .49807 L
.64867 .49995 L
.65225 .50193 L
.65253 .50209 L
.65639 .5043 L
.65894 .50579 L
.66026 .50658 L
.66412 .50892 L
.66531 .50965 L
.66798 .51133 L
.67139 .51352 L
.67184 .51381 L
.6757 .51635 L
.67724 .51738 L
.67956 .51896 L
.68286 .52124 L
.68343 .52164 L
.68729 .52438 L
.68829 .5251 L
.69115 .52719 L
.69355 .52896 L
.69501 .53006 L
.69864 .53282 L
.69887 .533 L
.70273 .53601 L
.70359 .53669 L
.7066 .53908 L
.70841 .54055 L
.71046 .54222 L
.7131 .54441 L
.71432 .54542 L
.71768 .54827 L
.71818 .54869 L
.72204 .55203 L
.72216 .55213 L
.7259 .55543 L
.72653 .55599 L
.72977 .5589 L
.73082 .55985 L
.73363 .56243 L
.73501 .56372 L
.73749 .56603 L
.73913 .56758 L
.74135 .5697 L
.74316 .57144 L
.74521 .57343 L
.74713 .5753 L
.74907 .57722 L
.75102 .57916 L
.75293 .58108 L
.75485 .58302 L
.7568 .58501 L
.75862 .58689 L
.76066 .589 L
.76233 .59075 L
.76452 .59306 L
.76598 .59461 L
.76838 .59718 L
.76957 .59847 L
.77224 .60137 L
.77312 .60233 L
.7761 .60563 L
.77662 .60619 L
.77997 .60994 L
.78006 .61006 L
.78347 .61392 L
.78383 .61433 L
.78683 .61778 L
.78769 .61878 L
.79015 .62164 L
.79155 .62329 L
.79342 .6255 L
.79541 .62787 L
.79666 .62936 L
.79927 .63252 L
.79986 .63323 L
.80302 .63709 L
.80314 .63723 L
.80615 .64095 L
.807 .642 L
.80925 .64481 L
.81086 .64684 L
.81231 .64867 L
.81472 .65175 L
.81534 .65253 L
.81833 .65639 L
.81858 .65672 L
.8213 .66026 L
.82244 .66175 L
.82424 .66412 L
.82631 .66685 L
.82715 .66798 L
.83004 .67184 L
.83017 .67202 L
.83289 .6757 L
.83403 .67725 L
.83573 .67956 L
.83789 .68254 L
.83853 .68343 L
.84131 .68729 L
.84175 .6879 L
.84407 .69115 L
.84561 .69333 L
.8468 .69501 L
.84947 .69882 L
.84951 .69887 L
.8522 .70273 L
.85334 .70437 L
.85487 .7066 L
.8572 .70999 L
.85752 .71046 L
.86014 .71432 L
.86106 .71568 L
.86275 .71818 L
.86492 .72142 L
.86533 .72204 L
.8679 .7259 L
.86878 .72724 L
.87045 .72977 L
.87264 .73312 L
.87298 .73363 L
.87549 .73749 L
.87651 .73906 L
.87798 .74135 L
.88037 .74507 L
.88046 .74521 L
.88292 .74907 L
.88423 .75114 L
.88536 .75293 L
.88779 .7568 L
.88809 .75728 L
.8902 .76066 L
.89195 .76348 L
.89259 .76452 L
.89581 .76838 L
.89581 .76839 L
.89582 .77224 L
.89581 .77225 L
.89197 .7761 L
.89195 .77612 L
.88812 .77997 L
.88809 .77999 L
.88426 .78383 L
.88427 .78769 L
.88423 .78773 L
.88041 .79155 L
.88037 .79159 L
.87655 .79541 L
.87651 .79545 L
.87268 .79927 L
.87268 .80314 L
.87264 .80317 L
.86882 .807 L
.86878 .80703 L
.86495 .81086 L
.86492 .81088 L
.86108 .81472 L
.86106 .81474 L
.8572 .81858 L
.8572 .81859 L
.85336 .81858 L
.85334 .81499 L
.85316 .81472 L
.85056 .81086 L
.84947 .80926 L
.84794 .807 L
.84561 .80358 L
.84531 .80314 L
.84266 .79927 L
.84175 .79796 L
.83998 .79541 L
.83789 .7924 L
.83729 .79155 L
.83458 .78769 L
.83403 .7869 L
.83185 .78383 L
.83017 .78147 L
.82909 .77997 L
.82632 .7761 L
.82631 .77608 L
.82352 .77224 L
.82244 .77076 L
.8207 .76838 L
.81858 .7655 L
.81786 .76452 L
.81499 .76066 L
.81472 .7603 L
.8121 .7568 L
.81086 .75515 L
.80918 .75293 L
.807 .75007 L
.80624 .74907 L
.80327 .74521 L
.80314 .74504 L
.80027 .74135 L
.79927 .74007 L
.79725 .73749 L
.79541 .73517 L
.79419 .73363 L
.79155 .73032 L
.79111 .72977 L
.788 .7259 L
.78769 .72552 L
.78485 .72204 L
.78383 .72079 L
.78167 .71818 L
.77997 .71612 L
.77846 .71432 L
.7761 .71151 L
.77522 .71046 L
.77224 .70695 L
.77194 .7066 L
.76862 .70273 L
.76838 .70245 L
.76527 .69887 L
.76452 .69802 L
.76187 .69501 L
.76066 .69364 L
.75844 .69115 L
.7568 .68932 L
.75496 .68729 L
.75293 .68506 L
.75144 .68343 L
.74907 .68085 L
.74788 .67956 L
.74521 .67671 L
.74427 .6757 L
.74135 .67262 L
.74061 .67184 L
.73749 .66859 L
.73689 .66798 L
.73363 .66462 L
.73313 .66412 L
.72977 .66071 L
.72931 .66026 L
.7259 .65686 L
.72543 .65639 L
.72204 .65307 L
.72149 .65253 L
.71818 .64933 L
.71749 .64867 L
.71432 .64566 L
.71342 .64481 L
.71046 .64204 L
.70928 .64095 L
.7066 .63848 L
.70507 .63709 L
.70273 .63497 L
.70078 .63323 L
.69887 .63153 L
.69641 .62936 L
.69501 .62814 L
.69195 .6255 L
.69115 .62481 L
.68741 .62164 L
.68729 .62154 L
.68343 .61833 L
.68276 .61778 L
.67956 .61517 L
.67801 .61392 L
.6757 .61208 L
.67314 .61006 L
.67184 .60904 L
.66816 .60619 L
.66798 .60605 L
.66412 .60313 L
.66305 .60233 L
.66026 .60026 L
.6578 .59847 L
.65639 .59745 L
.65253 .5947 L
.65241 .59461 L
.64867 .592 L
.64684 .59075 L
.64481 .58937 L
.6411 .58689 L
.64095 .58678 L
.63709 .58426 L
.63517 .58302 L
.63323 .58179 L
.62936 .57938 L
.62901 .57916 L
.6255 .57703 L
.62261 .5753 L
.62164 .57473 L
.61778 .57249 L
.61594 .57144 L
.61392 .5703 L
.61006 .56817 L
.60896 .56758 L
.60619 .5661 L
.60233 .56408 L
.60162 .56372 L
.59847 .56212 L
.59461 .56022 L
.59387 .55985 L
.59075 .55837 L
.58689 .55657 L
.58562 .55599 L
.58302 .55483 L
.57916 .55314 L
.57678 .55213 L
.5753 .55151 L
.57144 .54994 L
.56758 .54841 L
.56721 .54827 L
.56372 .54694 L
.55985 .54553 L
.55669 .54441 L
.55599 .54417 L
.55213 .54286 L
.54827 .5416 L
.5449 .54055 L
.54441 .5404 L
.54055 .53925 L
.53669 .53815 L
.53282 .5371 L
.53125 .53669 L
.52896 .5361 L
.5251 .53515 L
.52124 .53425 L
.51738 .5334 L
.51461 .53282 L
.51352 .5326 L
.50965 .53185 L
.50579 .53114 L
.50193 .53048 L
.49807 .52987 L
.49421 .5293 L
.49182 .52896 L
.49035 .52877 L
.48648 .52828 L
.48262 .52783 L
.47876 .52743 L
.4749 .52705 L
.47104 .52671 L
.46718 .52641 L
.46331 .52613 L
.45945 .52587 L
.45559 .52563 L
.45173 .52541 L
.44787 .52519 L
.44628 .5251 L
.44401 .52497 L
.44015 .52474 L
.43628 .52449 L
.43242 .52418 L
.42856 .52378 L
.4247 .52323 L
.42084 .52239 L
.41771 .52124 L
.41698 .52089 L
.41347 .51738 L
.41355 .51352 L
.41555 .50965 L
.41698 .50736 L
.41876 .50579 L
.42084 .50362 L
.42287 .50193 L
.4247 .50037 L
.42777 .49807 L
.42856 .49748 L
.43242 .49483 L
.43341 .49421 L
.43628 .4924 L
.43983 .49035 L
.44015 .49017 L
.44401 .48806 L
.44712 .48648 L
.44787 .48611 L
.45173 .48428 L
.45548 .48262 L
.45559 .48258 L
.45945 .48097 L
.46331 .47947 L
.46526 .47876 L
.46718 .47808 L
.47104 .47677 L
.4749 .47557 L
.47719 .4749 L
.47876 .47445 L
.48262 .47342 L
.48648 .47248 L
.49035 .47162 L
.49321 .47104 L
F
0 g
.49421 .47084 m
.49807 .47015 L
.50193 .46953 L
.50579 .46899 L
.50965 .46854 L
.51352 .46816 L
.51738 .46785 L
.52124 .46762 L
.5251 .46747 L
.52896 .46739 L
.53282 .46738 L
.53669 .46745 L
.54055 .46759 L
.54441 .46781 L
.54827 .46809 L
.55213 .46845 L
.55599 .46887 L
.55985 .46937 L
.56372 .46994 L
.56758 .47059 L
.57008 .47104 L
.57144 .4713 L
.5753 .47208 L
.57916 .47293 L
.58302 .47385 L
.58689 .47484 L
.58713 .4749 L
.59075 .47589 L
.59461 .47702 L
.59847 .47822 L
.60016 .47876 L
.60233 .47948 L
.60619 .48081 L
.61006 .48221 L
.61115 .48262 L
.61392 .48368 L
.61778 .48522 L
.62084 .48648 L
.62164 .48682 L
.6255 .4885 L
.62936 .49024 L
.6296 .49035 L
.63323 .49204 L
.63709 .49392 L
.63767 .49421 L
.64095 .49586 L
.64481 .49787 L
.64519 .49807 L
.64867 .49995 L
.65225 .50193 L
Mistroke
.65253 .50209 L
.65639 .5043 L
.65894 .50579 L
.66026 .50658 L
.66412 .50892 L
.66531 .50965 L
.66798 .51133 L
.67139 .51352 L
.67184 .51381 L
.6757 .51635 L
.67724 .51738 L
.67956 .51896 L
.68286 .52124 L
.68343 .52164 L
.68729 .52438 L
.68829 .5251 L
.69115 .52719 L
.69355 .52896 L
.69501 .53006 L
.69864 .53282 L
.69887 .533 L
.70273 .53601 L
.70359 .53669 L
.7066 .53908 L
.70841 .54055 L
.71046 .54222 L
.7131 .54441 L
.71432 .54542 L
.71768 .54827 L
.71818 .54869 L
.72204 .55203 L
.72216 .55213 L
.7259 .55543 L
.72653 .55599 L
.72977 .5589 L
.73082 .55985 L
.73363 .56243 L
.73501 .56372 L
.73749 .56603 L
.73913 .56758 L
.74135 .5697 L
.74316 .57144 L
.74521 .57343 L
.74713 .5753 L
.74907 .57722 L
.75102 .57916 L
.75293 .58108 L
.75485 .58302 L
.7568 .58501 L
.75862 .58689 L
Mistroke
.76066 .589 L
.76233 .59075 L
.76452 .59306 L
.76598 .59461 L
.76838 .59718 L
.76957 .59847 L
.77224 .60137 L
.77312 .60233 L
.7761 .60563 L
.77662 .60619 L
.77997 .60994 L
.78006 .61006 L
.78347 .61392 L
.78383 .61433 L
.78683 .61778 L
.78769 .61878 L
.79015 .62164 L
.79155 .62329 L
.79342 .6255 L
.79541 .62787 L
.79666 .62936 L
.79927 .63252 L
.79986 .63323 L
.80302 .63709 L
.80314 .63723 L
.80615 .64095 L
.807 .642 L
.80925 .64481 L
.81086 .64684 L
.81231 .64867 L
.81472 .65175 L
.81534 .65253 L
.81833 .65639 L
.81858 .65672 L
.8213 .66026 L
.82244 .66175 L
.82424 .66412 L
.82631 .66685 L
.82715 .66798 L
.83004 .67184 L
.83017 .67202 L
.83289 .6757 L
.83403 .67725 L
.83573 .67956 L
.83789 .68254 L
.83853 .68343 L
.84131 .68729 L
.84175 .6879 L
.84407 .69115 L
.84561 .69333 L
Mistroke
.8468 .69501 L
.84947 .69882 L
.84951 .69887 L
.8522 .70273 L
.85334 .70437 L
.85487 .7066 L
.8572 .70999 L
.85752 .71046 L
.86014 .71432 L
.86106 .71568 L
.86275 .71818 L
.86492 .72142 L
.86533 .72204 L
.8679 .7259 L
.86878 .72724 L
.87045 .72977 L
.87264 .73312 L
.87298 .73363 L
.87549 .73749 L
.87651 .73906 L
.87798 .74135 L
.88037 .74507 L
.88046 .74521 L
.88292 .74907 L
.88423 .75114 L
.88536 .75293 L
.88779 .7568 L
.88809 .75728 L
.8902 .76066 L
.89195 .76348 L
.89259 .76452 L
.89581 .76838 L
.89581 .76839 L
.89582 .77224 L
.89581 .77225 L
.89197 .7761 L
.89195 .77612 L
.88812 .77997 L
.88809 .77999 L
.88426 .78383 L
.88427 .78769 L
.88423 .78773 L
.88041 .79155 L
.88037 .79159 L
.87655 .79541 L
.87651 .79545 L
.87268 .79927 L
.87268 .80314 L
.87264 .80317 L
.86882 .807 L
Mistroke
.86878 .80703 L
.86495 .81086 L
.86492 .81088 L
.86108 .81472 L
.86106 .81474 L
.8572 .81858 L
.8572 .81859 L
.85336 .81858 L
.85334 .81499 L
.85316 .81472 L
.85056 .81086 L
.84947 .80926 L
.84794 .807 L
.84561 .80358 L
.84531 .80314 L
.84266 .79927 L
.84175 .79796 L
.83998 .79541 L
.83789 .7924 L
.83729 .79155 L
.83458 .78769 L
.83403 .7869 L
.83185 .78383 L
.83017 .78147 L
.82909 .77997 L
.82632 .7761 L
.82631 .77608 L
.82352 .77224 L
.82244 .77076 L
.8207 .76838 L
.81858 .7655 L
.81786 .76452 L
.81499 .76066 L
.81472 .7603 L
.8121 .7568 L
.81086 .75515 L
.80918 .75293 L
.807 .75007 L
.80624 .74907 L
.80327 .74521 L
.80314 .74504 L
.80027 .74135 L
.79927 .74007 L
.79725 .73749 L
.79541 .73517 L
.79419 .73363 L
.79155 .73032 L
.79111 .72977 L
.788 .7259 L
.78769 .72552 L
Mistroke
.78485 .72204 L
.78383 .72079 L
.78167 .71818 L
.77997 .71612 L
.77846 .71432 L
.7761 .71151 L
.77522 .71046 L
.77224 .70695 L
.77194 .7066 L
.76862 .70273 L
.76838 .70245 L
.76527 .69887 L
.76452 .69802 L
.76187 .69501 L
.76066 .69364 L
.75844 .69115 L
.7568 .68932 L
.75496 .68729 L
.75293 .68506 L
.75144 .68343 L
.74907 .68085 L
.74788 .67956 L
.74521 .67671 L
.74427 .6757 L
.74135 .67262 L
.74061 .67184 L
.73749 .66859 L
.73689 .66798 L
.73363 .66462 L
.73313 .66412 L
.72977 .66071 L
.72931 .66026 L
.7259 .65686 L
.72543 .65639 L
.72204 .65307 L
.72149 .65253 L
.71818 .64933 L
.71749 .64867 L
.71432 .64566 L
.71342 .64481 L
.71046 .64204 L
.70928 .64095 L
.7066 .63848 L
.70507 .63709 L
.70273 .63497 L
.70078 .63323 L
.69887 .63153 L
.69641 .62936 L
.69501 .62814 L
.69195 .6255 L
Mistroke
.69115 .62481 L
.68741 .62164 L
.68729 .62154 L
.68343 .61833 L
.68276 .61778 L
.67956 .61517 L
.67801 .61392 L
.6757 .61208 L
.67314 .61006 L
.67184 .60904 L
.66816 .60619 L
.66798 .60605 L
.66412 .60313 L
.66305 .60233 L
.66026 .60026 L
.6578 .59847 L
.65639 .59745 L
.65253 .5947 L
.65241 .59461 L
.64867 .592 L
.64684 .59075 L
.64481 .58937 L
.6411 .58689 L
.64095 .58678 L
.63709 .58426 L
.63517 .58302 L
.63323 .58179 L
.62936 .57938 L
.62901 .57916 L
.6255 .57703 L
.62261 .5753 L
.62164 .57473 L
.61778 .57249 L
.61594 .57144 L
.61392 .5703 L
.61006 .56817 L
.60896 .56758 L
.60619 .5661 L
.60233 .56408 L
.60162 .56372 L
.59847 .56212 L
.59461 .56022 L
.59387 .55985 L
.59075 .55837 L
.58689 .55657 L
.58562 .55599 L
.58302 .55483 L
.57916 .55314 L
.57678 .55213 L
.5753 .55151 L
Mistroke
.57144 .54994 L
.56758 .54841 L
.56721 .54827 L
.56372 .54694 L
.55985 .54553 L
.55669 .54441 L
.55599 .54417 L
.55213 .54286 L
.54827 .5416 L
.5449 .54055 L
.54441 .5404 L
.54055 .53925 L
.53669 .53815 L
.53282 .5371 L
.53125 .53669 L
.52896 .5361 L
.5251 .53515 L
.52124 .53425 L
.51738 .5334 L
.51461 .53282 L
.51352 .5326 L
.50965 .53185 L
.50579 .53114 L
.50193 .53048 L
.49807 .52987 L
.49421 .5293 L
.49182 .52896 L
.49035 .52877 L
.48648 .52828 L
.48262 .52783 L
.47876 .52743 L
.4749 .52705 L
.47104 .52671 L
.46718 .52641 L
.46331 .52613 L
.45945 .52587 L
.45559 .52563 L
.45173 .52541 L
.44787 .52519 L
.44628 .5251 L
.44401 .52497 L
.44015 .52474 L
.43628 .52449 L
.43242 .52418 L
.42856 .52378 L
.4247 .52323 L
.42084 .52239 L
.41771 .52124 L
.41698 .52089 L
.41347 .51738 L
Mistroke
.41355 .51352 L
.41555 .50965 L
.41698 .50736 L
.41876 .50579 L
.42084 .50362 L
.42287 .50193 L
.4247 .50037 L
.42777 .49807 L
.42856 .49748 L
.43242 .49483 L
.43341 .49421 L
.43628 .4924 L
.43983 .49035 L
.44015 .49017 L
.44401 .48806 L
.44712 .48648 L
.44787 .48611 L
.45173 .48428 L
.45548 .48262 L
.45559 .48258 L
.45945 .48097 L
.46331 .47947 L
.46526 .47876 L
.46718 .47808 L
.47104 .47677 L
.4749 .47557 L
.47719 .4749 L
.47876 .47445 L
.48262 .47342 L
.48648 .47248 L
.49035 .47162 L
.49321 .47104 L
.49421 .47084 L
Mfstroke
1 .538 .5 r
.5251 .48605 m
.52896 .48537 L
.53282 .48483 L
.53669 .48443 L
.54055 .48414 L
.54441 .48397 L
.54827 .4839 L
.55213 .48392 L
.55599 .48405 L
.55985 .48426 L
.56372 .48457 L
.56758 .48496 L
.57144 .48544 L
.5753 .486 L
.57823 .48648 L
.57916 .48665 L
.58302 .48737 L
.58689 .48817 L
.59075 .48906 L
.59461 .49002 L
.59586 .49035 L
.59847 .49105 L
.60233 .49217 L
.60619 .49335 L
.60882 .49421 L
.61006 .49462 L
.61392 .49595 L
.61778 .49736 L
.61963 .49807 L
.62164 .49885 L
.6255 .5004 L
.62913 .50193 L
.62936 .50203 L
.63323 .50373 L
.63709 .5055 L
.6377 .50579 L
.64095 .50735 L
.64481 .50926 L
.64559 .50965 L
.64867 .51124 L
.65253 .5133 L
.65293 .51352 L
.65639 .51542 L
.65984 .51738 L
.66026 .51762 L
.66412 .51988 L
.66638 .52124 L
.66798 .52221 L
.67184 .52461 L
.67261 .5251 L
.6757 .52708 L
.67857 .52896 L
.67956 .52962 L
.68343 .53223 L
.68429 .53282 L
.68729 .53491 L
.6898 .53669 L
.69115 .53765 L
.69501 .54047 L
.69512 .54055 L
.69887 .54335 L
.70027 .54441 L
.70273 .5463 L
.70527 .54827 L
.7066 .54931 L
.71013 .55213 L
.71046 .5524 L
.71432 .55555 L
.71486 .55599 L
.71818 .55877 L
.71947 .55985 L
.72204 .56206 L
.72396 .56372 L
.7259 .56541 L
.72836 .56758 L
.72977 .56883 L
.73266 .57144 L
.73363 .57232 L
.73687 .5753 L
.73749 .57587 L
.741 .57916 L
.74135 .5795 L
.74505 .58302 L
.74521 .58318 L
.74902 .58689 L
.74907 .58694 L
.75292 .59075 L
.75293 .59076 L
.75676 .59461 L
.7568 .59465 L
.76053 .59847 L
.76066 .59861 L
.76424 .60233 L
.76452 .60263 L
.76789 .60619 L
.76838 .60671 L
.77149 .61006 L
.77224 .61087 L
.77504 .61392 L
.7761 .61509 L
.77854 .61778 L
.77997 .61938 L
.78198 .62164 L
.78383 .62373 L
.78539 .6255 L
.78769 .62815 L
.78874 .62936 L
.79155 .63263 L
.79206 .63323 L
.79533 .63709 L
.79541 .63718 L
.79857 .64095 L
.79927 .6418 L
.80176 .64481 L
.80314 .64648 L
.80492 .64867 L
.807 .65123 L
.80805 .65253 L
.81086 .65605 L
.81114 .65639 L
.81419 .66026 L
.81472 .66093 L
.81722 .66412 L
.81858 .66587 L
.82021 .66798 L
.82244 .67089 L
.82317 .67184 L
.82611 .6757 L
.82631 .67597 L
.82901 .67956 L
.83017 .68111 L
.83189 .68343 L
.83403 .68632 L
.83474 .68729 L
.83757 .69115 L
.83789 .69159 L
.84037 .69501 L
.84175 .69693 L
.84314 .69887 L
.84561 .70234 L
.84589 .70273 L
.84862 .7066 L
.84947 .70781 L
.85133 .71046 L
.85334 .71335 L
.85401 .71432 L
.85667 .71818 L
.8572 .71895 L
.85931 .72204 L
.86106 .72462 L
.86193 .7259 L
.86453 .72977 L
.86492 .73035 L
.86711 .73363 L
.86878 .73615 L
.86967 .73749 L
.87221 .74135 L
.87264 .74202 L
.87473 .74521 L
.87651 .74795 L
.87724 .74907 L
.87972 .75293 L
.88037 .75394 L
.8822 .7568 L
.88423 .76 L
.88465 .76066 L
.88708 .76452 L
.88809 .76613 L
.8895 .76838 L
.89191 .77224 L
.89195 .77224 L
.89196 .7761 L
.89195 .77611 L
.88811 .77997 L
.88809 .77998 L
.88425 .78383 L
.88425 .78769 L
.88423 .78771 L
.8804 .79155 L
.88037 .79158 L
.87654 .79541 L
.87651 .79544 L
.87267 .79927 L
.87267 .80314 L
.87264 .80316 L
.8688 .807 L
.86878 .80702 L
.86493 .81086 L
.86492 .81087 L
.86106 .81472 L
.86106 .81472 L
.85722 .81472 L
.8572 .81183 L
.85656 .81086 L
.85399 .807 L
.85334 .80601 L
.85141 .80314 L
.84947 .80026 L
.84881 .79927 L
.84619 .79541 L
.84561 .79457 L
.84355 .79155 L
.84175 .78893 L
.84089 .78769 L
.83822 .78383 L
.83789 .78335 L
.83552 .77997 L
.83403 .77783 L
.83281 .7761 L
.83017 .77237 L
.83007 .77224 L
.82732 .76838 L
.82631 .76697 L
.82454 .76452 L
.82244 .76163 L
.82174 .76066 L
.81892 .7568 L
.81858 .75634 L
.81607 .75293 L
.81472 .75112 L
.8132 .74907 L
.81086 .74595 L
.81031 .74521 L
.80739 .74135 L
.807 .74084 L
.80444 .73749 L
.80314 .73578 L
.80147 .73363 L
.79927 .73079 L
.79848 .72977 L
.79545 .7259 L
.79541 .72585 L
.7924 .72204 L
.79155 .72098 L
.78932 .71818 L
.78769 .71616 L
.7862 .71432 L
.78383 .71139 L
.78306 .71046 L
.77997 .70669 L
.77989 .7066 L
.77668 .70273 L
.7761 .70204 L
.77344 .69887 L
.77224 .69746 L
.77017 .69501 L
.76838 .69292 L
.76685 .69115 L
.76452 .68845 L
.76351 .68729 L
.76066 .68404 L
.76012 .68343 L
.7568 .67968 L
.75669 .67956 L
.75323 .6757 L
.75293 .67538 L
.74972 .67184 L
.74907 .67114 L
.74616 .66798 L
.74521 .66695 L
.74257 .66412 L
.74135 .66282 L
.73892 .66026 L
.73749 .65875 L
.73523 .65639 L
.73363 .65474 L
.73148 .65253 L
.72977 .65078 L
.72768 .64867 L
.7259 .64689 L
.72382 .64481 L
.72204 .64304 L
.71991 .64095 L
.71818 .63926 L
.71594 .63709 L
.71432 .63553 L
.7119 .63323 L
.71046 .63186 L
.7078 .62936 L
.7066 .62824 L
.70363 .6255 L
.70273 .62468 L
.69938 .62164 L
.69887 .62118 L
.69506 .61778 L
.69501 .61773 L
.69115 .61434 L
.69066 .61392 L
.68729 .61101 L
.68617 .61006 L
.68343 .60773 L
.68159 .60619 L
.67956 .60451 L
.67692 .60233 L
.6757 .60134 L
.67215 .59847 L
.67184 .59823 L
.66798 .59517 L
.66726 .59461 L
.66412 .59217 L
.66227 .59075 L
.66026 .58922 L
.65715 .58689 L
.65639 .58633 L
.65253 .58349 L
.65189 .58302 L
.64867 .58071 L
.6465 .57916 L
.64481 .57798 L
.64095 .5753 L
.64095 .5753 L
.63709 .57267 L
.63524 .57144 L
.63323 .5701 L
.62936 .56758 L
.62935 .56758 L
.6255 .56512 L
.62327 .56372 L
.62164 .56271 L
.61778 .56034 L
.61697 .55985 L
.61392 .55803 L
.61044 .55599 L
.61006 .55577 L
.60619 .55356 L
.60366 .55213 L
.60233 .5514 L
.59847 .54928 L
.59659 .54827 L
.59461 .54722 L
.59075 .5452 L
.58921 .54441 L
.58689 .54323 L
.58302 .5413 L
.58149 .54055 L
.57916 .53942 L
.5753 .53759 L
.57338 .53669 L
.57144 .53579 L
.56758 .53403 L
.56487 .53282 L
.56372 .53232 L
.55985 .53064 L
.55599 .52899 L
.55593 .52896 L
.55213 .52738 L
.54827 .52579 L
.54658 .5251 L
.54441 .52423 L
.54055 .52269 L
.53689 .52124 L
.53669 .52116 L
.53282 .51965 L
.52896 .51812 L
.52712 .51738 L
.5251 .51659 L
.52124 .51501 L
.51777 .51352 L
.51738 .51336 L
.51352 .51166 L
.50965 .50966 L
.50965 .50965 L
.50579 .50758 L
.50371 .50579 L
.50193 .50403 L
.50063 .50193 L
.50063 .49807 L
.50193 .49598 L
.50378 .49421 L
.50579 .49259 L
.50965 .49065 L
.51052 .49035 L
.51352 .48912 L
.51738 .48786 L
.52124 .48687 L
.52301 .48648 L
F
0 g
.5251 .48605 m
.52896 .48537 L
.53282 .48483 L
.53669 .48443 L
.54055 .48414 L
.54441 .48397 L
.54827 .4839 L
.55213 .48392 L
.55599 .48405 L
.55985 .48426 L
.56372 .48457 L
.56758 .48496 L
.57144 .48544 L
.5753 .486 L
.57823 .48648 L
.57916 .48665 L
.58302 .48737 L
.58689 .48817 L
.59075 .48906 L
.59461 .49002 L
.59586 .49035 L
.59847 .49105 L
.60233 .49217 L
.60619 .49335 L
.60882 .49421 L
.61006 .49462 L
.61392 .49595 L
.61778 .49736 L
.61963 .49807 L
.62164 .49885 L
.6255 .5004 L
.62913 .50193 L
.62936 .50203 L
.63323 .50373 L
.63709 .5055 L
.6377 .50579 L
.64095 .50735 L
.64481 .50926 L
.64559 .50965 L
.64867 .51124 L
.65253 .5133 L
.65293 .51352 L
.65639 .51542 L
.65984 .51738 L
.66026 .51762 L
.66412 .51988 L
.66638 .52124 L
.66798 .52221 L
.67184 .52461 L
.67261 .5251 L
Mistroke
.6757 .52708 L
.67857 .52896 L
.67956 .52962 L
.68343 .53223 L
.68429 .53282 L
.68729 .53491 L
.6898 .53669 L
.69115 .53765 L
.69501 .54047 L
.69512 .54055 L
.69887 .54335 L
.70027 .54441 L
.70273 .5463 L
.70527 .54827 L
.7066 .54931 L
.71013 .55213 L
.71046 .5524 L
.71432 .55555 L
.71486 .55599 L
.71818 .55877 L
.71947 .55985 L
.72204 .56206 L
.72396 .56372 L
.7259 .56541 L
.72836 .56758 L
.72977 .56883 L
.73266 .57144 L
.73363 .57232 L
.73687 .5753 L
.73749 .57587 L
.741 .57916 L
.74135 .5795 L
.74505 .58302 L
.74521 .58318 L
.74902 .58689 L
.74907 .58694 L
.75292 .59075 L
.75293 .59076 L
.75676 .59461 L
.7568 .59465 L
.76053 .59847 L
.76066 .59861 L
.76424 .60233 L
.76452 .60263 L
.76789 .60619 L
.76838 .60671 L
.77149 .61006 L
.77224 .61087 L
.77504 .61392 L
.7761 .61509 L
Mistroke
.77854 .61778 L
.77997 .61938 L
.78198 .62164 L
.78383 .62373 L
.78539 .6255 L
.78769 .62815 L
.78874 .62936 L
.79155 .63263 L
.79206 .63323 L
.79533 .63709 L
.79541 .63718 L
.79857 .64095 L
.79927 .6418 L
.80176 .64481 L
.80314 .64648 L
.80492 .64867 L
.807 .65123 L
.80805 .65253 L
.81086 .65605 L
.81114 .65639 L
.81419 .66026 L
.81472 .66093 L
.81722 .66412 L
.81858 .66587 L
.82021 .66798 L
.82244 .67089 L
.82317 .67184 L
.82611 .6757 L
.82631 .67597 L
.82901 .67956 L
.83017 .68111 L
.83189 .68343 L
.83403 .68632 L
.83474 .68729 L
.83757 .69115 L
.83789 .69159 L
.84037 .69501 L
.84175 .69693 L
.84314 .69887 L
.84561 .70234 L
.84589 .70273 L
.84862 .7066 L
.84947 .70781 L
.85133 .71046 L
.85334 .71335 L
.85401 .71432 L
.85667 .71818 L
.8572 .71895 L
.85931 .72204 L
.86106 .72462 L
Mistroke
.86193 .7259 L
.86453 .72977 L
.86492 .73035 L
.86711 .73363 L
.86878 .73615 L
.86967 .73749 L
.87221 .74135 L
.87264 .74202 L
.87473 .74521 L
.87651 .74795 L
.87724 .74907 L
.87972 .75293 L
.88037 .75394 L
.8822 .7568 L
.88423 .76 L
.88465 .76066 L
.88708 .76452 L
.88809 .76613 L
.8895 .76838 L
.89191 .77224 L
.89195 .77224 L
.89196 .7761 L
.89195 .77611 L
.88811 .77997 L
.88809 .77998 L
.88425 .78383 L
.88425 .78769 L
.88423 .78771 L
.8804 .79155 L
.88037 .79158 L
.87654 .79541 L
.87651 .79544 L
.87267 .79927 L
.87267 .80314 L
.87264 .80316 L
.8688 .807 L
.86878 .80702 L
.86493 .81086 L
.86492 .81087 L
.86106 .81472 L
.86106 .81472 L
.85722 .81472 L
.8572 .81183 L
.85656 .81086 L
.85399 .807 L
.85334 .80601 L
.85141 .80314 L
.84947 .80026 L
.84881 .79927 L
.84619 .79541 L
Mistroke
.84561 .79457 L
.84355 .79155 L
.84175 .78893 L
.84089 .78769 L
.83822 .78383 L
.83789 .78335 L
.83552 .77997 L
.83403 .77783 L
.83281 .7761 L
.83017 .77237 L
.83007 .77224 L
.82732 .76838 L
.82631 .76697 L
.82454 .76452 L
.82244 .76163 L
.82174 .76066 L
.81892 .7568 L
.81858 .75634 L
.81607 .75293 L
.81472 .75112 L
.8132 .74907 L
.81086 .74595 L
.81031 .74521 L
.80739 .74135 L
.807 .74084 L
.80444 .73749 L
.80314 .73578 L
.80147 .73363 L
.79927 .73079 L
.79848 .72977 L
.79545 .7259 L
.79541 .72585 L
.7924 .72204 L
.79155 .72098 L
.78932 .71818 L
.78769 .71616 L
.7862 .71432 L
.78383 .71139 L
.78306 .71046 L
.77997 .70669 L
.77989 .7066 L
.77668 .70273 L
.7761 .70204 L
.77344 .69887 L
.77224 .69746 L
.77017 .69501 L
.76838 .69292 L
.76685 .69115 L
.76452 .68845 L
.76351 .68729 L
Mistroke
.76066 .68404 L
.76012 .68343 L
.7568 .67968 L
.75669 .67956 L
.75323 .6757 L
.75293 .67538 L
.74972 .67184 L
.74907 .67114 L
.74616 .66798 L
.74521 .66695 L
.74257 .66412 L
.74135 .66282 L
.73892 .66026 L
.73749 .65875 L
.73523 .65639 L
.73363 .65474 L
.73148 .65253 L
.72977 .65078 L
.72768 .64867 L
.7259 .64689 L
.72382 .64481 L
.72204 .64304 L
.71991 .64095 L
.71818 .63926 L
.71594 .63709 L
.71432 .63553 L
.7119 .63323 L
.71046 .63186 L
.7078 .62936 L
.7066 .62824 L
.70363 .6255 L
.70273 .62468 L
.69938 .62164 L
.69887 .62118 L
.69506 .61778 L
.69501 .61773 L
.69115 .61434 L
.69066 .61392 L
.68729 .61101 L
.68617 .61006 L
.68343 .60773 L
.68159 .60619 L
.67956 .60451 L
.67692 .60233 L
.6757 .60134 L
.67215 .59847 L
.67184 .59823 L
.66798 .59517 L
.66726 .59461 L
.66412 .59217 L
Mistroke
.66227 .59075 L
.66026 .58922 L
.65715 .58689 L
.65639 .58633 L
.65253 .58349 L
.65189 .58302 L
.64867 .58071 L
.6465 .57916 L
.64481 .57798 L
.64095 .5753 L
.64095 .5753 L
.63709 .57267 L
.63524 .57144 L
.63323 .5701 L
.62936 .56758 L
.62935 .56758 L
.6255 .56512 L
.62327 .56372 L
.62164 .56271 L
.61778 .56034 L
.61697 .55985 L
.61392 .55803 L
.61044 .55599 L
.61006 .55577 L
.60619 .55356 L
.60366 .55213 L
.60233 .5514 L
.59847 .54928 L
.59659 .54827 L
.59461 .54722 L
.59075 .5452 L
.58921 .54441 L
.58689 .54323 L
.58302 .5413 L
.58149 .54055 L
.57916 .53942 L
.5753 .53759 L
.57338 .53669 L
.57144 .53579 L
.56758 .53403 L
.56487 .53282 L
.56372 .53232 L
.55985 .53064 L
.55599 .52899 L
.55593 .52896 L
.55213 .52738 L
.54827 .52579 L
.54658 .5251 L
.54441 .52423 L
.54055 .52269 L
Mistroke
.53689 .52124 L
.53669 .52116 L
.53282 .51965 L
.52896 .51812 L
.52712 .51738 L
.5251 .51659 L
.52124 .51501 L
.51777 .51352 L
.51738 .51336 L
.51352 .51166 L
.50965 .50966 L
.50965 .50965 L
.50579 .50758 L
.50371 .50579 L
.50193 .50403 L
.50063 .50193 L
.50063 .49807 L
.50193 .49598 L
.50378 .49421 L
.50579 .49259 L
.50965 .49065 L
.51052 .49035 L
.51352 .48912 L
.51738 .48786 L
.52124 .48687 L
.52301 .48648 L
.5251 .48605 L
Mfstroke
1 .535 .5 r
.58302 .50579 m
.58689 .50551 L
.59075 .50555 L
.59435 .50579 L
.59461 .50581 L
.59847 .50624 L
.60233 .50683 L
.60619 .50756 L
.61006 .50842 L
.61392 .5094 L
.61485 .50965 L
.61778 .51047 L
.62164 .51165 L
.6255 .51294 L
.62717 .51352 L
.62936 .5143 L
.63323 .51576 L
.63709 .51732 L
.63723 .51738 L
.64095 .51895 L
.64481 .52067 L
.64604 .52124 L
.64867 .52247 L
.65253 .52436 L
.65401 .5251 L
.65639 .52632 L
.66026 .52836 L
.66137 .52896 L
.66412 .53048 L
.66798 .53268 L
.66823 .53282 L
.67184 .53495 L
.67471 .53669 L
.6757 .5373 L
.67956 .53972 L
.68086 .54055 L
.68343 .54221 L
.68673 .54441 L
.68729 .54478 L
.69115 .54743 L
.69236 .54827 L
.69501 .55014 L
.69778 .55213 L
.69887 .55293 L
.70273 .55579 L
.703 .55599 L
.7066 .55872 L
.70807 .55985 L
.71046 .56172 L
.71297 .56372 L
.71432 .56479 L
.71774 .56758 L
.71818 .56794 L
.72204 .57115 L
.72238 .57144 L
.7259 .57444 L
.72691 .5753 L
.72977 .57779 L
.73133 .57916 L
.73363 .58121 L
.73564 .58302 L
.73749 .5847 L
.73986 .58689 L
.74135 .58827 L
.744 .59075 L
.74521 .5919 L
.74805 .59461 L
.74907 .5956 L
.75203 .59847 L
.75293 .59936 L
.75593 .60233 L
.7568 .6032 L
.75976 .60619 L
.76066 .60711 L
.76353 .61006 L
.76452 .61108 L
.76724 .61392 L
.76838 .61512 L
.77089 .61778 L
.77224 .61923 L
.77448 .62164 L
.7761 .6234 L
.77802 .6255 L
.77997 .62765 L
.78151 .62936 L
.78383 .63196 L
.78495 .63323 L
.78769 .63634 L
.78834 .63709 L
.79155 .64079 L
.79169 .64095 L
.79499 .64481 L
.79541 .6453 L
.79826 .64867 L
.79927 .64988 L
.80148 .65253 L
.80314 .65453 L
.80467 .65639 L
.807 .65925 L
.80782 .66026 L
.81086 .66403 L
.81093 .66412 L
.81401 .66798 L
.81472 .66888 L
.81706 .67184 L
.81858 .6738 L
.82007 .6757 L
.82244 .67878 L
.82305 .67956 L
.826 .68343 L
.82631 .68383 L
.82892 .68729 L
.83017 .68895 L
.83182 .69115 L
.83403 .69413 L
.83468 .69501 L
.83752 .69887 L
.83789 .69938 L
.84034 .70273 L
.84175 .7047 L
.84312 .7066 L
.84561 .71008 L
.84588 .71046 L
.84862 .71432 L
.84947 .71553 L
.85134 .71818 L
.85334 .72104 L
.85403 .72204 L
.8567 .7259 L
.8572 .72663 L
.85935 .72977 L
.86106 .73227 L
.86198 .73363 L
.86459 .73749 L
.86492 .73799 L
.86718 .74135 L
.86878 .74377 L
.86974 .74521 L
.87229 .74907 L
.87264 .74962 L
.87482 .75293 L
.87651 .75553 L
.87733 .7568 L
.87982 .76066 L
.88037 .76151 L
.8823 .76452 L
.88423 .76755 L
.88476 .76838 L
.8872 .77224 L
.88809 .77366 L
.89194 .7761 L
.8881 .77997 L
.88809 .77997 L
.88424 .78383 L
.88425 .78769 L
.88423 .78771 L
.88039 .79155 L
.88037 .79157 L
.87653 .79541 L
.87651 .79543 L
.87266 .79927 L
.87266 .80314 L
.87264 .80315 L
.8688 .807 L
.86878 .80701 L
.86493 .81086 L
.86492 .81086 L
.86106 .81086 L
.86106 .81004 L
.85907 .807 L
.8572 .80415 L
.85653 .80314 L
.85397 .79927 L
.85334 .79832 L
.8514 .79541 L
.84947 .79254 L
.84881 .79155 L
.8462 .78769 L
.84561 .78683 L
.84357 .78383 L
.84175 .78117 L
.84093 .77997 L
.83826 .7761 L
.83789 .77556 L
.83558 .77224 L
.83403 .77002 L
.83288 .76838 L
.83017 .76453 L
.83016 .76452 L
.82741 .76066 L
.82631 .75911 L
.82465 .7568 L
.82244 .75373 L
.82187 .75293 L
.81906 .74907 L
.81858 .74842 L
.81623 .74521 L
.81472 .74316 L
.81338 .74135 L
.81086 .73796 L
.8105 .73749 L
.8076 .73363 L
.807 .73282 L
.80468 .72977 L
.80314 .72774 L
.80173 .7259 L
.79927 .72271 L
.79876 .72204 L
.79576 .71818 L
.79541 .71773 L
.79273 .71432 L
.79155 .71282 L
.78968 .71046 L
.78769 .70796 L
.78659 .7066 L
.78383 .70316 L
.78348 .70273 L
.78034 .69887 L
.77997 .69841 L
.77717 .69501 L
.7761 .69373 L
.77396 .69115 L
.77224 .6891 L
.77072 .68729 L
.76838 .68452 L
.76745 .68343 L
.76452 .68 L
.76415 .67956 L
.7608 .6757 L
.76066 .67553 L
.75742 .67184 L
.7568 .67113 L
.75401 .66798 L
.75293 .66678 L
.75055 .66412 L
.74907 .66248 L
.74705 .66026 L
.74521 .65824 L
.74352 .65639 L
.74135 .65405 L
.73994 .65253 L
.73749 .64992 L
.73631 .64867 L
.73363 .64585 L
.73264 .64481 L
.72977 .64183 L
.72892 .64095 L
.7259 .63786 L
.72515 .63709 L
.72204 .63395 L
.72132 .63323 L
.71818 .63009 L
.71745 .62936 L
.71432 .62628 L
.71352 .6255 L
.71046 .62253 L
.70953 .62164 L
.7066 .61884 L
.70548 .61778 L
.70273 .61519 L
.70137 .61392 L
.69887 .6116 L
.6972 .61006 L
.69501 .60806 L
.69295 .60619 L
.69115 .60457 L
.68864 .60233 L
.68729 .60114 L
.68425 .59847 L
.68343 .59775 L
.67979 .59461 L
.67956 .59441 L
.6757 .59113 L
.67525 .59075 L
.67184 .5879 L
.67063 .58689 L
.66798 .58471 L
.66592 .58302 L
.66412 .58157 L
.66112 .57916 L
.66026 .57848 L
.65639 .57543 L
.65623 .5753 L
.65253 .57243 L
.65125 .57144 L
.64867 .56948 L
.64616 .56758 L
.64481 .56657 L
.64098 .56372 L
.64095 .56369 L
.63709 .56086 L
.6357 .55985 L
.63323 .55807 L
.63033 .55599 L
.62936 .55531 L
.6255 .55259 L
.62486 .55213 L
.62164 .5499 L
.6193 .54827 L
.61778 .54724 L
.61392 .54458 L
.61367 .54441 L
.61006 .54196 L
.60799 .54055 L
.60619 .53935 L
.60233 .53671 L
.60229 .53669 L
.59847 .5341 L
.59664 .53282 L
.59461 .53146 L
.59111 .52896 L
.59075 .52873 L
.58689 .52592 L
.58585 .5251 L
.58302 .52302 L
.58105 .52124 L
.57916 .52007 L
.57706 .51738 L
.5753 .51512 L
.57443 .51352 L
.57436 .50965 L
.5753 .50847 L
.57916 .50654 L
.583 .50579 L
F
0 g
.58302 .50579 m
.58689 .50551 L
.59075 .50555 L
.59435 .50579 L
.59461 .50581 L
.59847 .50624 L
.60233 .50683 L
.60619 .50756 L
.61006 .50842 L
.61392 .5094 L
.61485 .50965 L
.61778 .51047 L
.62164 .51165 L
.6255 .51294 L
.62717 .51352 L
.62936 .5143 L
.63323 .51576 L
.63709 .51732 L
.63723 .51738 L
.64095 .51895 L
.64481 .52067 L
.64604 .52124 L
.64867 .52247 L
.65253 .52436 L
.65401 .5251 L
.65639 .52632 L
.66026 .52836 L
.66137 .52896 L
.66412 .53048 L
.66798 .53268 L
.66823 .53282 L
.67184 .53495 L
.67471 .53669 L
.6757 .5373 L
.67956 .53972 L
.68086 .54055 L
.68343 .54221 L
.68673 .54441 L
.68729 .54478 L
.69115 .54743 L
.69236 .54827 L
.69501 .55014 L
.69778 .55213 L
.69887 .55293 L
.70273 .55579 L
.703 .55599 L
.7066 .55872 L
.70807 .55985 L
.71046 .56172 L
.71297 .56372 L
Mistroke
.71432 .56479 L
.71774 .56758 L
.71818 .56794 L
.72204 .57115 L
.72238 .57144 L
.7259 .57444 L
.72691 .5753 L
.72977 .57779 L
.73133 .57916 L
.73363 .58121 L
.73564 .58302 L
.73749 .5847 L
.73986 .58689 L
.74135 .58827 L
.744 .59075 L
.74521 .5919 L
.74805 .59461 L
.74907 .5956 L
.75203 .59847 L
.75293 .59936 L
.75593 .60233 L
.7568 .6032 L
.75976 .60619 L
.76066 .60711 L
.76353 .61006 L
.76452 .61108 L
.76724 .61392 L
.76838 .61512 L
.77089 .61778 L
.77224 .61923 L
.77448 .62164 L
.7761 .6234 L
.77802 .6255 L
.77997 .62765 L
.78151 .62936 L
.78383 .63196 L
.78495 .63323 L
.78769 .63634 L
.78834 .63709 L
.79155 .64079 L
.79169 .64095 L
.79499 .64481 L
.79541 .6453 L
.79826 .64867 L
.79927 .64988 L
.80148 .65253 L
.80314 .65453 L
.80467 .65639 L
.807 .65925 L
.80782 .66026 L
Mistroke
.81086 .66403 L
.81093 .66412 L
.81401 .66798 L
.81472 .66888 L
.81706 .67184 L
.81858 .6738 L
.82007 .6757 L
.82244 .67878 L
.82305 .67956 L
.826 .68343 L
.82631 .68383 L
.82892 .68729 L
.83017 .68895 L
.83182 .69115 L
.83403 .69413 L
.83468 .69501 L
.83752 .69887 L
.83789 .69938 L
.84034 .70273 L
.84175 .7047 L
.84312 .7066 L
.84561 .71008 L
.84588 .71046 L
.84862 .71432 L
.84947 .71553 L
.85134 .71818 L
.85334 .72104 L
.85403 .72204 L
.8567 .7259 L
.8572 .72663 L
.85935 .72977 L
.86106 .73227 L
.86198 .73363 L
.86459 .73749 L
.86492 .73799 L
.86718 .74135 L
.86878 .74377 L
.86974 .74521 L
.87229 .74907 L
.87264 .74962 L
.87482 .75293 L
.87651 .75553 L
.87733 .7568 L
.87982 .76066 L
.88037 .76151 L
.8823 .76452 L
.88423 .76755 L
.88476 .76838 L
.8872 .77224 L
.88809 .77366 L
Mistroke
.89194 .7761 L
.8881 .77997 L
.88809 .77997 L
.88424 .78383 L
.88425 .78769 L
.88423 .78771 L
.88039 .79155 L
.88037 .79157 L
.87653 .79541 L
.87651 .79543 L
.87266 .79927 L
.87266 .80314 L
.87264 .80315 L
.8688 .807 L
.86878 .80701 L
.86493 .81086 L
.86492 .81086 L
.86106 .81086 L
.86106 .81004 L
.85907 .807 L
.8572 .80415 L
.85653 .80314 L
.85397 .79927 L
.85334 .79832 L
.8514 .79541 L
.84947 .79254 L
.84881 .79155 L
.8462 .78769 L
.84561 .78683 L
.84357 .78383 L
.84175 .78117 L
.84093 .77997 L
.83826 .7761 L
.83789 .77556 L
.83558 .77224 L
.83403 .77002 L
.83288 .76838 L
.83017 .76453 L
.83016 .76452 L
.82741 .76066 L
.82631 .75911 L
.82465 .7568 L
.82244 .75373 L
.82187 .75293 L
.81906 .74907 L
.81858 .74842 L
.81623 .74521 L
.81472 .74316 L
.81338 .74135 L
.81086 .73796 L
Mistroke
.8105 .73749 L
.8076 .73363 L
.807 .73282 L
.80468 .72977 L
.80314 .72774 L
.80173 .7259 L
.79927 .72271 L
.79876 .72204 L
.79576 .71818 L
.79541 .71773 L
.79273 .71432 L
.79155 .71282 L
.78968 .71046 L
.78769 .70796 L
.78659 .7066 L
.78383 .70316 L
.78348 .70273 L
.78034 .69887 L
.77997 .69841 L
.77717 .69501 L
.7761 .69373 L
.77396 .69115 L
.77224 .6891 L
.77072 .68729 L
.76838 .68452 L
.76745 .68343 L
.76452 .68 L
.76415 .67956 L
.7608 .6757 L
.76066 .67553 L
.75742 .67184 L
.7568 .67113 L
.75401 .66798 L
.75293 .66678 L
.75055 .66412 L
.74907 .66248 L
.74705 .66026 L
.74521 .65824 L
.74352 .65639 L
.74135 .65405 L
.73994 .65253 L
.73749 .64992 L
.73631 .64867 L
.73363 .64585 L
.73264 .64481 L
.72977 .64183 L
.72892 .64095 L
.7259 .63786 L
.72515 .63709 L
.72204 .63395 L
Mistroke
.72132 .63323 L
.71818 .63009 L
.71745 .62936 L
.71432 .62628 L
.71352 .6255 L
.71046 .62253 L
.70953 .62164 L
.7066 .61884 L
.70548 .61778 L
.70273 .61519 L
.70137 .61392 L
.69887 .6116 L
.6972 .61006 L
.69501 .60806 L
.69295 .60619 L
.69115 .60457 L
.68864 .60233 L
.68729 .60114 L
.68425 .59847 L
.68343 .59775 L
.67979 .59461 L
.67956 .59441 L
.6757 .59113 L
.67525 .59075 L
.67184 .5879 L
.67063 .58689 L
.66798 .58471 L
.66592 .58302 L
.66412 .58157 L
.66112 .57916 L
.66026 .57848 L
.65639 .57543 L
.65623 .5753 L
.65253 .57243 L
.65125 .57144 L
.64867 .56948 L
.64616 .56758 L
.64481 .56657 L
.64098 .56372 L
.64095 .56369 L
.63709 .56086 L
.6357 .55985 L
.63323 .55807 L
.63033 .55599 L
.62936 .55531 L
.6255 .55259 L
.62486 .55213 L
.62164 .5499 L
.6193 .54827 L
.61778 .54724 L
Mistroke
.61392 .54458 L
.61367 .54441 L
.61006 .54196 L
.60799 .54055 L
.60619 .53935 L
.60233 .53671 L
.60229 .53669 L
.59847 .5341 L
.59664 .53282 L
.59461 .53146 L
.59111 .52896 L
.59075 .52873 L
.58689 .52592 L
.58585 .5251 L
.58302 .52302 L
.58105 .52124 L
.57916 .52007 L
.57706 .51738 L
.5753 .51512 L
.57443 .51352 L
.57436 .50965 L
.5753 .50847 L
.57916 .50654 L
.583 .50579 L
.58302 .50579 L
Mfstroke
1 .532 .5 r
.64095 .53541 m
.64481 .53596 L
.64804 .53669 L
.64867 .5368 L
.65253 .53787 L
.65639 .53925 L
.65969 .54055 L
.66026 .54079 L
.66412 .54244 L
.66798 .54427 L
.66827 .54441 L
.67184 .54617 L
.6757 .54822 L
.67579 .54827 L
.67956 .55034 L
.68265 .55213 L
.68343 .55259 L
.68729 .55492 L
.68901 .55599 L
.69115 .55734 L
.69498 .55985 L
.69501 .55987 L
.69887 .56247 L
.70068 .56372 L
.70273 .56515 L
.70612 .56758 L
.7066 .56793 L
.71046 .57078 L
.71134 .57144 L
.71432 .57371 L
.71638 .5753 L
.71818 .57672 L
.72124 .57916 L
.72204 .57981 L
.7259 .58298 L
.72596 .58302 L
.72977 .58622 L
.73055 .58689 L
.73363 .58954 L
.73502 .59075 L
.73749 .59293 L
.73938 .59461 L
.74135 .59639 L
.74363 .59847 L
.74521 .59993 L
.74779 .60233 L
.74907 .60355 L
.75185 .60619 L
.75293 .60724 L
.75584 .61006 L
.7568 .61099 L
.75975 .61392 L
.76066 .61483 L
.76359 .61778 L
.76452 .61873 L
.76736 .62164 L
.76838 .6227 L
.77107 .6255 L
.77224 .62674 L
.77471 .62936 L
.7761 .63086 L
.7783 .63323 L
.77997 .63504 L
.78183 .63709 L
.78383 .6393 L
.78531 .64095 L
.78769 .64363 L
.78874 .64481 L
.79155 .64802 L
.79212 .64867 L
.79541 .65249 L
.79545 .65253 L
.79875 .65639 L
.79927 .65702 L
.802 .66026 L
.80314 .66162 L
.80521 .66412 L
.807 .66629 L
.80838 .66798 L
.81086 .67104 L
.81151 .67184 L
.81461 .6757 L
.81472 .67585 L
.81768 .67956 L
.81858 .68072 L
.82071 .68343 L
.82244 .68567 L
.8237 .68729 L
.82631 .69068 L
.82666 .69115 L
.8296 .69501 L
.83017 .69576 L
.83251 .69887 L
.83403 .70091 L
.83539 .70273 L
.83789 .70613 L
.83823 .7066 L
.84106 .71046 L
.84175 .71142 L
.84386 .71432 L
.84561 .71677 L
.84663 .71818 L
.84937 .72204 L
.84947 .72219 L
.8521 .7259 L
.85334 .72768 L
.8548 .72977 L
.8572 .73324 L
.85747 .73363 L
.86013 .73749 L
.86106 .73886 L
.86276 .74135 L
.86492 .74455 L
.86537 .74521 L
.86796 .74907 L
.86878 .75031 L
.87054 .75293 L
.87264 .75613 L
.87308 .7568 L
.87562 .76066 L
.87651 .76203 L
.87814 .76452 L
.88037 .76799 L
.88062 .76838 L
.88311 .77224 L
.88423 .77401 L
.88557 .7761 L
.88809 .77997 L
.88424 .78383 L
.88424 .78769 L
.88423 .7877 L
.88038 .79155 L
.88037 .79156 L
.87652 .79541 L
.87651 .79543 L
.87266 .79927 L
.87266 .80314 L
.87264 .80315 L
.86879 .807 L
.86878 .807 L
.86492 .81086 L
.86335 .807 L
.86106 .80345 L
.86085 .80314 L
.85833 .79927 L
.8572 .79754 L
.8558 .79541 L
.85334 .79168 L
.85325 .79155 L
.85068 .78769 L
.84947 .78588 L
.8481 .78383 L
.84561 .78013 L
.8455 .77997 L
.84288 .7761 L
.84175 .77445 L
.84024 .77224 L
.83789 .76881 L
.83759 .76838 L
.83492 .76452 L
.83403 .76324 L
.83222 .76066 L
.83017 .75772 L
.82952 .7568 L
.82679 .75293 L
.82631 .75226 L
.82403 .74907 L
.82244 .74685 L
.82126 .74521 L
.81858 .74149 L
.81848 .74135 L
.81566 .73749 L
.81472 .7362 L
.81283 .73363 L
.81086 .73096 L
.80997 .72977 L
.80709 .7259 L
.807 .72577 L
.80419 .72204 L
.80314 .72065 L
.80126 .71818 L
.79927 .71557 L
.79831 .71432 L
.79541 .71055 L
.79534 .71046 L
.79234 .7066 L
.79155 .70559 L
.78931 .70273 L
.78769 .70068 L
.78626 .69887 L
.78383 .69582 L
.78318 .69501 L
.78007 .69115 L
.77997 .69102 L
.77693 .68729 L
.7761 .68627 L
.77377 .68343 L
.77224 .68158 L
.77057 .67956 L
.76838 .67694 L
.76735 .6757 L
.76452 .67235 L
.76409 .67184 L
.7608 .66798 L
.76066 .66781 L
.75748 .66412 L
.7568 .66333 L
.75412 .66026 L
.75293 .65891 L
.75073 .65639 L
.74907 .65453 L
.7473 .65253 L
.74521 .6502 L
.74384 .64867 L
.74135 .64592 L
.74034 .64481 L
.73749 .6417 L
.7368 .64095 L
.73363 .63752 L
.73322 .63709 L
.72977 .63339 L
.72961 .63323 L
.72595 .62936 L
.7259 .62932 L
.72225 .6255 L
.72204 .62529 L
.71851 .62164 L
.71818 .62131 L
.71472 .61778 L
.71432 .61737 L
.7109 .61392 L
.71046 .61348 L
.70703 .61006 L
.7066 .60963 L
.70311 .60619 L
.70273 .60582 L
.69916 .60233 L
.69887 .60206 L
.69516 .59847 L
.69501 .59833 L
.69115 .59464 L
.69112 .59461 L
.68729 .59099 L
.68703 .59075 L
.68343 .58737 L
.68291 .58689 L
.67956 .58378 L
.67876 .58302 L
.6757 .58021 L
.67457 .57916 L
.67184 .57667 L
.67037 .5753 L
.66798 .57314 L
.66615 .57144 L
.66412 .56961 L
.66194 .56758 L
.66026 .56608 L
.65775 .56372 L
.65639 .56252 L
.65361 .55985 L
.65253 .55892 L
.64957 .55599 L
.64867 .55525 L
.64569 .55213 L
.64481 .55155 L
.64209 .54827 L
.64095 .54694 L
.63894 .54441 L
.63709 .54136 L
.63673 .54055 L
.63709 .53682 L
.63724 .53669 L
F
0 g
.64095 .53541 m
.64481 .53596 L
.64804 .53669 L
.64867 .5368 L
.65253 .53787 L
.65639 .53925 L
.65969 .54055 L
.66026 .54079 L
.66412 .54244 L
.66798 .54427 L
.66827 .54441 L
.67184 .54617 L
.6757 .54822 L
.67579 .54827 L
.67956 .55034 L
.68265 .55213 L
.68343 .55259 L
.68729 .55492 L
.68901 .55599 L
.69115 .55734 L
.69498 .55985 L
.69501 .55987 L
.69887 .56247 L
.70068 .56372 L
.70273 .56515 L
.70612 .56758 L
.7066 .56793 L
.71046 .57078 L
.71134 .57144 L
.71432 .57371 L
.71638 .5753 L
.71818 .57672 L
.72124 .57916 L
.72204 .57981 L
.7259 .58298 L
.72596 .58302 L
.72977 .58622 L
.73055 .58689 L
.73363 .58954 L
.73502 .59075 L
.73749 .59293 L
.73938 .59461 L
.74135 .59639 L
.74363 .59847 L
.74521 .59993 L
.74779 .60233 L
.74907 .60355 L
.75185 .60619 L
.75293 .60724 L
.75584 .61006 L
Mistroke
.7568 .61099 L
.75975 .61392 L
.76066 .61483 L
.76359 .61778 L
.76452 .61873 L
.76736 .62164 L
.76838 .6227 L
.77107 .6255 L
.77224 .62674 L
.77471 .62936 L
.7761 .63086 L
.7783 .63323 L
.77997 .63504 L
.78183 .63709 L
.78383 .6393 L
.78531 .64095 L
.78769 .64363 L
.78874 .64481 L
.79155 .64802 L
.79212 .64867 L
.79541 .65249 L
.79545 .65253 L
.79875 .65639 L
.79927 .65702 L
.802 .66026 L
.80314 .66162 L
.80521 .66412 L
.807 .66629 L
.80838 .66798 L
.81086 .67104 L
.81151 .67184 L
.81461 .6757 L
.81472 .67585 L
.81768 .67956 L
.81858 .68072 L
.82071 .68343 L
.82244 .68567 L
.8237 .68729 L
.82631 .69068 L
.82666 .69115 L
.8296 .69501 L
.83017 .69576 L
.83251 .69887 L
.83403 .70091 L
.83539 .70273 L
.83789 .70613 L
.83823 .7066 L
.84106 .71046 L
.84175 .71142 L
.84386 .71432 L
Mistroke
.84561 .71677 L
.84663 .71818 L
.84937 .72204 L
.84947 .72219 L
.8521 .7259 L
.85334 .72768 L
.8548 .72977 L
.8572 .73324 L
.85747 .73363 L
.86013 .73749 L
.86106 .73886 L
.86276 .74135 L
.86492 .74455 L
.86537 .74521 L
.86796 .74907 L
.86878 .75031 L
.87054 .75293 L
.87264 .75613 L
.87308 .7568 L
.87562 .76066 L
.87651 .76203 L
.87814 .76452 L
.88037 .76799 L
.88062 .76838 L
.88311 .77224 L
.88423 .77401 L
.88557 .7761 L
.88809 .77997 L
.88424 .78383 L
.88424 .78769 L
.88423 .7877 L
.88038 .79155 L
.88037 .79156 L
.87652 .79541 L
.87651 .79543 L
.87266 .79927 L
.87266 .80314 L
.87264 .80315 L
.86879 .807 L
.86878 .807 L
.86492 .81086 L
.86335 .807 L
.86106 .80345 L
.86085 .80314 L
.85833 .79927 L
.8572 .79754 L
.8558 .79541 L
.85334 .79168 L
.85325 .79155 L
.85068 .78769 L
Mistroke
.84947 .78588 L
.8481 .78383 L
.84561 .78013 L
.8455 .77997 L
.84288 .7761 L
.84175 .77445 L
.84024 .77224 L
.83789 .76881 L
.83759 .76838 L
.83492 .76452 L
.83403 .76324 L
.83222 .76066 L
.83017 .75772 L
.82952 .7568 L
.82679 .75293 L
.82631 .75226 L
.82403 .74907 L
.82244 .74685 L
.82126 .74521 L
.81858 .74149 L
.81848 .74135 L
.81566 .73749 L
.81472 .7362 L
.81283 .73363 L
.81086 .73096 L
.80997 .72977 L
.80709 .7259 L
.807 .72577 L
.80419 .72204 L
.80314 .72065 L
.80126 .71818 L
.79927 .71557 L
.79831 .71432 L
.79541 .71055 L
.79534 .71046 L
.79234 .7066 L
.79155 .70559 L
.78931 .70273 L
.78769 .70068 L
.78626 .69887 L
.78383 .69582 L
.78318 .69501 L
.78007 .69115 L
.77997 .69102 L
.77693 .68729 L
.7761 .68627 L
.77377 .68343 L
.77224 .68158 L
.77057 .67956 L
.76838 .67694 L
Mistroke
.76735 .6757 L
.76452 .67235 L
.76409 .67184 L
.7608 .66798 L
.76066 .66781 L
.75748 .66412 L
.7568 .66333 L
.75412 .66026 L
.75293 .65891 L
.75073 .65639 L
.74907 .65453 L
.7473 .65253 L
.74521 .6502 L
.74384 .64867 L
.74135 .64592 L
.74034 .64481 L
.73749 .6417 L
.7368 .64095 L
.73363 .63752 L
.73322 .63709 L
.72977 .63339 L
.72961 .63323 L
.72595 .62936 L
.7259 .62932 L
.72225 .6255 L
.72204 .62529 L
.71851 .62164 L
.71818 .62131 L
.71472 .61778 L
.71432 .61737 L
.7109 .61392 L
.71046 .61348 L
.70703 .61006 L
.7066 .60963 L
.70311 .60619 L
.70273 .60582 L
.69916 .60233 L
.69887 .60206 L
.69516 .59847 L
.69501 .59833 L
.69115 .59464 L
.69112 .59461 L
.68729 .59099 L
.68703 .59075 L
.68343 .58737 L
.68291 .58689 L
.67956 .58378 L
.67876 .58302 L
.6757 .58021 L
.67457 .57916 L
Mistroke
.67184 .57667 L
.67037 .5753 L
.66798 .57314 L
.66615 .57144 L
.66412 .56961 L
.66194 .56758 L
.66026 .56608 L
.65775 .56372 L
.65639 .56252 L
.65361 .55985 L
.65253 .55892 L
.64957 .55599 L
.64867 .55525 L
.64569 .55213 L
.64481 .55155 L
.64209 .54827 L
.64095 .54694 L
.63894 .54441 L
.63709 .54136 L
.63673 .54055 L
.63709 .53682 L
.63724 .53669 L
.64095 .53541 L
Mfstroke
1 .5 .5 r
.69115 .57261 m
.69501 .57329 L
.69887 .57475 L
.7004 .5753 L
.70273 .57653 L
.7066 .57883 L
.70719 .57916 L
.71046 .58112 L
.71344 .58302 L
.71432 .58365 L
.71818 .58632 L
.719 .58689 L
.72204 .58907 L
.72433 .59075 L
.7259 .59195 L
.72934 .59461 L
.72977 .59495 L
.73363 .59805 L
.73415 .59847 L
.73749 .60122 L
.73882 .60233 L
.74135 .6045 L
.74332 .60619 L
.74521 .60786 L
.74769 .61006 L
.74907 .61132 L
.75193 .61392 L
.75293 .61486 L
.75606 .61778 L
.7568 .61848 L
.7601 .62164 L
.76066 .62219 L
.76405 .6255 L
.76452 .62597 L
.76792 .62936 L
.76838 .62983 L
.77172 .63323 L
.77224 .63377 L
.77544 .63709 L
.7761 .63779 L
.7791 .64095 L
.77997 .64188 L
.7827 .64481 L
.78383 .64605 L
.78624 .64867 L
.78769 .65029 L
.78971 .65253 L
.79155 .65461 L
.79314 .65639 L
.79541 .659 L
.79651 .66026 L
.79927 .66347 L
.79983 .66412 L
.80311 .66798 L
.80314 .66801 L
.80636 .67184 L
.807 .67261 L
.80957 .6757 L
.81086 .67729 L
.81272 .67956 L
.81472 .68205 L
.81584 .68343 L
.81858 .68687 L
.81891 .68729 L
.82197 .69115 L
.82244 .69177 L
.82499 .69501 L
.82631 .69673 L
.82797 .69887 L
.83017 .70177 L
.83091 .70273 L
.83382 .7066 L
.83403 .70688 L
.83672 .71046 L
.83789 .71205 L
.83958 .71432 L
.84175 .7173 L
.8424 .71818 L
.84521 .72204 L
.84561 .72261 L
.848 .7259 L
.84947 .72799 L
.85074 .72977 L
.85334 .73345 L
.85346 .73363 L
.85618 .73749 L
.8572 .73897 L
.85886 .74135 L
.86106 .74457 L
.86151 .74521 L
.86415 .74907 L
.86492 .75022 L
.86677 .75293 L
.86878 .75596 L
.86935 .7568 L
.87193 .76066 L
.87264 .76175 L
.87449 .76452 L
.87651 .76762 L
.87701 .76838 L
.87953 .77224 L
.88037 .77355 L
.88203 .7761 L
.88423 .77956 L
.88808 .77997 L
.88423 .78383 L
.88423 .78769 L
.88423 .78769 L
.88038 .79155 L
.88037 .79156 L
.87652 .79541 L
.87651 .79542 L
.87265 .79927 L
.87265 .80314 L
.87264 .80314 L
.86878 .807 L
.86878 .807 L
.86493 .807 L
.86492 .80375 L
.86453 .80314 L
.86203 .79927 L
.86106 .79775 L
.85954 .79541 L
.8572 .7918 L
.85703 .79155 L
.85449 .78769 L
.85334 .78591 L
.85195 .78383 L
.84947 .78007 L
.8494 .77997 L
.84682 .7761 L
.84561 .7743 L
.84423 .77224 L
.84175 .76857 L
.84163 .76838 L
.83899 .76452 L
.83789 .7629 L
.83635 .76066 L
.83403 .75728 L
.8337 .7568 L
.83101 .75293 L
.83017 .75172 L
.82831 .74907 L
.82631 .7462 L
.8256 .74521 L
.82287 .74135 L
.82244 .74075 L
.82011 .73749 L
.81858 .73535 L
.81734 .73363 L
.81472 .72999 L
.81455 .72977 L
.81173 .7259 L
.81086 .7247 L
.8089 .72204 L
.807 .71946 L
.80605 .71818 L
.80318 .71432 L
.80314 .71426 L
.80027 .71046 L
.79927 .70913 L
.79735 .7066 L
.79541 .70404 L
.79442 .70273 L
.79155 .69899 L
.79146 .69887 L
.78846 .69501 L
.78769 .69401 L
.78545 .69115 L
.78383 .68907 L
.78242 .68729 L
.77997 .68418 L
.77937 .68343 L
.77628 .67956 L
.7761 .67934 L
.77317 .6757 L
.77224 .67455 L
.77004 .67184 L
.76838 .66981 L
.76688 .66798 L
.76452 .66511 L
.7637 .66412 L
.76066 .66045 L
.7605 .66026 L
.75726 .65639 L
.7568 .65585 L
.754 .65253 L
.75293 .65128 L
.75071 .64867 L
.74907 .64676 L
.7474 .64481 L
.74521 .64227 L
.74407 .64095 L
.74135 .63781 L
.74072 .63709 L
.73749 .63339 L
.73734 .63323 L
.73394 .62936 L
.73363 .62902 L
.73051 .6255 L
.72977 .62467 L
.72707 .62164 L
.7259 .62035 L
.72362 .61778 L
.72204 .61604 L
.72016 .61392 L
.71818 .61173 L
.7167 .61006 L
.71432 .60742 L
.71324 .60619 L
.71046 .60309 L
.7098 .60233 L
.7066 .59872 L
.70638 .59847 L
.70301 .59461 L
.70273 .59438 L
.69969 .59075 L
.69887 .59009 L
.6965 .58689 L
.69501 .58491 L
.69354 .58302 L
.69115 .57939 L
.691 .57916 L
.68927 .5753 L
F
0 g
.69115 .57261 m
.69501 .57329 L
.69887 .57475 L
.7004 .5753 L
.70273 .57653 L
.7066 .57883 L
.70719 .57916 L
.71046 .58112 L
.71344 .58302 L
.71432 .58365 L
.71818 .58632 L
.719 .58689 L
.72204 .58907 L
.72433 .59075 L
.7259 .59195 L
.72934 .59461 L
.72977 .59495 L
.73363 .59805 L
.73415 .59847 L
.73749 .60122 L
.73882 .60233 L
.74135 .6045 L
.74332 .60619 L
.74521 .60786 L
.74769 .61006 L
.74907 .61132 L
.75193 .61392 L
.75293 .61486 L
.75606 .61778 L
.7568 .61848 L
.7601 .62164 L
.76066 .62219 L
.76405 .6255 L
.76452 .62597 L
.76792 .62936 L
.76838 .62983 L
.77172 .63323 L
.77224 .63377 L
.77544 .63709 L
.7761 .63779 L
.7791 .64095 L
.77997 .64188 L
.7827 .64481 L
.78383 .64605 L
.78624 .64867 L
.78769 .65029 L
.78971 .65253 L
.79155 .65461 L
.79314 .65639 L
.79541 .659 L
Mistroke
.79651 .66026 L
.79927 .66347 L
.79983 .66412 L
.80311 .66798 L
.80314 .66801 L
.80636 .67184 L
.807 .67261 L
.80957 .6757 L
.81086 .67729 L
.81272 .67956 L
.81472 .68205 L
.81584 .68343 L
.81858 .68687 L
.81891 .68729 L
.82197 .69115 L
.82244 .69177 L
.82499 .69501 L
.82631 .69673 L
.82797 .69887 L
.83017 .70177 L
.83091 .70273 L
.83382 .7066 L
.83403 .70688 L
.83672 .71046 L
.83789 .71205 L
.83958 .71432 L
.84175 .7173 L
.8424 .71818 L
.84521 .72204 L
.84561 .72261 L
.848 .7259 L
.84947 .72799 L
.85074 .72977 L
.85334 .73345 L
.85346 .73363 L
.85618 .73749 L
.8572 .73897 L
.85886 .74135 L
.86106 .74457 L
.86151 .74521 L
.86415 .74907 L
.86492 .75022 L
.86677 .75293 L
.86878 .75596 L
.86935 .7568 L
.87193 .76066 L
.87264 .76175 L
.87449 .76452 L
.87651 .76762 L
.87701 .76838 L
Mistroke
.87953 .77224 L
.88037 .77355 L
.88203 .7761 L
.88423 .77956 L
.88808 .77997 L
.88423 .78383 L
.88423 .78769 L
.88423 .78769 L
.88038 .79155 L
.88037 .79156 L
.87652 .79541 L
.87651 .79542 L
.87265 .79927 L
.87265 .80314 L
.87264 .80314 L
.86878 .807 L
.86878 .807 L
.86493 .807 L
.86492 .80375 L
.86453 .80314 L
.86203 .79927 L
.86106 .79775 L
.85954 .79541 L
.8572 .7918 L
.85703 .79155 L
.85449 .78769 L
.85334 .78591 L
.85195 .78383 L
.84947 .78007 L
.8494 .77997 L
.84682 .7761 L
.84561 .7743 L
.84423 .77224 L
.84175 .76857 L
.84163 .76838 L
.83899 .76452 L
.83789 .7629 L
.83635 .76066 L
.83403 .75728 L
.8337 .7568 L
.83101 .75293 L
.83017 .75172 L
.82831 .74907 L
.82631 .7462 L
.8256 .74521 L
.82287 .74135 L
.82244 .74075 L
.82011 .73749 L
.81858 .73535 L
.81734 .73363 L
Mistroke
.81472 .72999 L
.81455 .72977 L
.81173 .7259 L
.81086 .7247 L
.8089 .72204 L
.807 .71946 L
.80605 .71818 L
.80318 .71432 L
.80314 .71426 L
.80027 .71046 L
.79927 .70913 L
.79735 .7066 L
.79541 .70404 L
.79442 .70273 L
.79155 .69899 L
.79146 .69887 L
.78846 .69501 L
.78769 .69401 L
.78545 .69115 L
.78383 .68907 L
.78242 .68729 L
.77997 .68418 L
.77937 .68343 L
.77628 .67956 L
.7761 .67934 L
.77317 .6757 L
.77224 .67455 L
.77004 .67184 L
.76838 .66981 L
.76688 .66798 L
.76452 .66511 L
.7637 .66412 L
.76066 .66045 L
.7605 .66026 L
.75726 .65639 L
.7568 .65585 L
.754 .65253 L
.75293 .65128 L
.75071 .64867 L
.74907 .64676 L
.7474 .64481 L
.74521 .64227 L
.74407 .64095 L
.74135 .63781 L
.74072 .63709 L
.73749 .63339 L
.73734 .63323 L
.73394 .62936 L
.73363 .62902 L
.73051 .6255 L
Mistroke
.72977 .62467 L
.72707 .62164 L
.7259 .62035 L
.72362 .61778 L
.72204 .61604 L
.72016 .61392 L
.71818 .61173 L
.7167 .61006 L
.71432 .60742 L
.71324 .60619 L
.71046 .60309 L
.7098 .60233 L
.7066 .59872 L
.70638 .59847 L
.70301 .59461 L
.70273 .59438 L
.69969 .59075 L
.69887 .59009 L
.6965 .58689 L
.69501 .58491 L
.69354 .58302 L
.69115 .57939 L
.691 .57916 L
.68927 .5753 L
.69115 .57261 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  ImageSize->{300, 300},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0001;2000`400?l00000o`00003oooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`008Oooool3o`0003Wooooo0_l0
0004ooooo`03o`000?oooooooooo00;ooooo0ol0000gooooo`;o0000>Oooool2o`0000Cooooo00?o
0000ooooooooool00_ooool3o`0003Sooooo0ol00006ooooo`008_ooool00ol0003oooooooooo`0g
ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`00000eooooo`04o`00
0?ooooooooooo`0003Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo
000003Sooooo00?o0000ooooooooool01Oooool001[ooooo1Ol00003ooooo`03o`000?oooooooooo
033ooooo1Ol00002ooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0<oooool0
1?l0003oooooooooool0000gooooo`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0
=_ooool00ol0003oooooooooo`05ooooo`008_ooool00ol0003oooooooooo`0gooooo`04o`000?oo
ooooooooo`0000_ooooo00?o0000ooooooooool0<oooool01?l0003oooooooooool0000gooooo`04
o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`05oooo
o`008_ooool00ol0003oooooooooo`0gooooo`04o`000?ooooooooooo`0000Oooooo1?l0000foooo
o`04o`000?ooooooooooo`0003Oooooo00Co0000oooooooooooo00001oooool4o`0003Wooooo00?o
0000ooooooooool01Oooool0027ooooo0_l0000iooooo`04o`000?ooooooooooo`0000Oooooo00?o
0000ooooooooool0=oooool01?l0003oooooooooool0000gooooo`04o`000?ooooooooooo`0000Oo
oooo00?o0000ooooooooool0>Oooool2o`0000Oooooo000Rooooo`03o`000?oooooooooo03Sooooo
0_l00008ooooo`Go0000=_ooool2o`0003Wooooo0_l00008ooooo`Go0000>?ooool00ol0003ooooo
ooooo`05ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00
6oooooooo`00017o00000Oooool001_ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00_ooool1o`00007ooooo000K
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0?_ooool00ol0003oooooooooo`0o
ooooo`03o`000?oooooooooo03kooooo00?o0000ooooooooool0?_ooool00ol0003oooooooooo`02
ooooo`7o00000Oooool001?ooooo0ol00005ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00
007ooooo000Dooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0ooooool=ooooo`7o
00000Oooool000cooooo1Ol00003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
ooooool=ooooo`7o00000Oooool001Cooooo00?o0000ooooooooool01?ooool3o`0007Cooooo8_l0
001eooooo`;o00000Oooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02
ooooofco_goo3Ol0000Fogood`_o0000JonoOol5ooooo`7o00000Oooool001?ooooo0_l00006oooo
o`03o`000?oooooooooo00;oooooIonoOol;o`0002;oOooC2ol0001Vokmoo`Gooooo0Ol00001oooo
o`005?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;oooooHonoOol9o`0002ko
OooC2_l0001Qokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooeko_goo
2Ol0000hogood`Wo0000GOnoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oo
oomKokmoo`?o00000omoZOl2o`00047oOooC0ol000001?moZOoo0000o`000?l0001Jokmoo`Gooooo
0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooeSo_goo0ol00005ognYo`03o`000?mo
om?oOooC04?oOooC0ol00002ognYo`?o0000EonoOol5ooooo`7o00000Oooool001_ooooo00?o0000
ooooooooool00_oooomEokmoo`?o00001_moZOl2o`0004SoOooC00?o0000ognYoomoZOl00omoZOl3
o`0005Co_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;oooooDonoOol2o`00
00OoOjWo0_l0001;ogood`;o00001_moZOl2o`0005;o_goo1Oooool1o`00007ooooo000Kooooo`03
o`000?oooooooooo00;oooooD?noOol3o`0000SoOjWo00?o0000ogoodomoom<0COmoom<2o`0000Ko
OjWo0ol0001?okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooodko_goo
0_l00009ognYo`;o0000D_moom<00ol0003oOjWoognYo`06ognYo`?o0000C?noOol5ooooo`7o0000
0Oooool001_ooooo00?o0000ooooooooool00_oooom<okmoo`;o00002_moZOl00ol0003oOooCogoo
d`1Cogood`;o00002OmoZOl2o`0004[o_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooo
oooo00;oooooB_noOol2o`0000[oOjWo0_l0001Hogood`03o`000?moZOooOjWo00SoOjWo0_l00018
okmoo`Gooooo0Ol00001ooooo`006oooool2o`0000?oooooAonoOol3o`0000_oOjWo00?o0000ogoo
domoom<0FOmoom<2o`0000[oOjWo0_l00016okmoo`Cooooo0_l00001ooooo`006oooool00ol0003o
ooooooooo`02ooooodGo_goo0_l0000<ognYo`;o0000GOmoom<2o`0000_oOjWo0_l00014okmoo`Go
oooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooodCo_goo00?o0000ognYoomoZOl0
2omoZOl2o`00063oOooC0_l0000;ognYo`03o`000?noOooo_goo047o_goo1Oooool1o`00007ooooo
000Kooooo`03o`000?oooooooooo00;ooooo@_noOol3o`0000coOjWo00?o0000ogoodomoom<0HOmo
om<2o`0000[oOjWo0ol00011okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02
oooood3o_goo0ol0000<ognYo`;o0000;_moom<:o`0002koOooC00?o0000ognYoomoZOl02OmoZOl3
o`0003oo_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo@?noOol00ol0
003oOjWoognYo`0<ognYo`03o`000?moom?oOooC02KoOooC1ol00009oh[oO`Wo00009omoom<2o`00
00_oOjWo00?o0000okmooonoOol0?OnoOol5ooooo`7o00000Oooool001_ooooo00?o0000oooooooo
ool00_oooolnokmoo`;o00003OmoZOl2o`0002CoOooC1Ol0000Hoh[oO`Go00009?moom<2o`0000_o
OjWo0_l0000mokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooocco_goo
0_l0000>ognYo`;o00008Omoom<4o`0002;oR_mo1?l0000Qogood`;o00003?moZOl2o`0003_o_goo
1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo>onoOol00ol0003oOjWoognY
o`0=ognYo`03o`000?moom?oOooC01koOooC1?l0000Xoh[oO`?o00008?moom<2o`0000goOjWo00?o
0000okmooonoOol0>?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooooli
okmoo`;o00003omoZOl00ol0003oOooCogood`0Mogood`?o0000;_n:ogl2o`0001ooOooC0_l0000=
ognYo`?o0000=onoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolhokmo
o`03o`000?moZOooOjWo00goOjWo0_l0000Nogood`;o0000<on:ogl3o`0001koOooC00?o0000ognY
oomoZOl03?moZOl2o`0003Ko_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;o
oooo=onoOol00ol0003oOjWoognYo`0=ognYo`;o00007Omoom<2o`0003SoR_mo0ol0000Logood`03
o`000?moZOooOjWo00coOjWo0_l0000eokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003ooooo
ooooo`02ooooocGo_goo0_l0000?ognYo`;o00007?moom<2o`0003goR_mo0_l0000Kogood`03o`00
0?moZOooOjWo00goOjWo0_l0000cokmoo`Gooooo0Ol00001ooooo`006oooool2o`0000?ooooo<ono
Ool2o`00013oOjWo0_l0000Kogood`;o0000@On:ogl2o`0001[oOooC00?o0000ognYoomoZOl03_mo
ZOl00ol0003o_goookmoo`0`okmoo`Cooooo0_l00001ooooo`006oooool00ol0003oooooooooo`02
oooooc;o_goo0_l0000@ognYo`;o00006Omoom<3o`0004GoR_mo00?o0000ogoodomoom<06?moom<0
0ol0003oOjWoognYo`0>ognYo`03o`000?noOooo_goo02oo_goo1Oooool1o`00007ooooo000Koooo
o`03o`000?oooooooooo00;ooooo<?noOol3o`00013oOjWo00?o0000ogoodomoom<05omoom<2o`00
04WoR_mo0_l0000Iogood`03o`000?moZOooOjWo00koOjWo0_l0000_okmoo`Gooooo0Ol00001oooo
o`006oooool00ol0003oooooooooo`02oooooboo_goo0_l0000AognYo`03o`000?moom?oOooC01Oo
OooC00?o0000oh[oOon:ogl0Bon:ogl2o`0001SoOooC00?o0000ognYoomoZOl03omoZOl00ol0003o
_goookmoo`0/okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooobko_goo
0_l0000AognYo`03o`000?moom?oOooC01KoOooC0_l0001@oh[oO`03o`000?moom?oOooC01KoOooC
00?o0000ognYoomoZOl03omoZOl00ol0003o_goookmoo`0[okmoo`Gooooo0Ol00001ooooo`006ooo
ool00ol0003oooooooooo`02ooooobgo_goo0_l0000AognYo`03o`000?moom?oOooC01KoOooC00?o
0000oh[oOon:ogl0DOn:ogl2o`0001OoOooC00?o0000ognYoomoZOl03omoZOl00ol0003o_goookmo
o`0Zokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooobco_goo00?o0000
ognYoomoZOl04?moZOl00ol0003oOooCogood`0Eogood`;o0000E_n:ogl00ol0003oOooCogood`0E
ogood`03o`000?moZOooOjWo00ooOjWo00?o0000okmooonoOol0:OnoOol5ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_ooool[okmoo`;o00004OmoZOl00ol0003oOooCogood`0Eogoo
d`03o`000?n:ogooR_mo05OoR_mo0_l0000Fogood`03o`000?moZOooOjWo00ooOjWo00?o0000okmo
oonoOol0:?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolZokmoo`;o
00004OmoZOl2o`0001GoOooC0_l0001Koh[oO`;o00005_moom<00ol0003oOjWoognYo`0>ognYo`;o
0000:OnoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolYokmoo`;o0000
4OmoZOl2o`0001GoOooC0_l0000Voh[oOa;o00009_n:ogl2o`0001GoOooC00?o0000ognYoomoZOl0
3_moZOl2o`0002So_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo:?no
Ool2o`00017oOjWo0_l0000Eogood`03o`000?n:ogooR_mo023oR_mo1_l0000BolkoO`Ko00008On:
ogl2o`0001CoOooC0_l0000@ognYo`?o00009_noOol5ooooo`7o00000Oooool001_ooooo00?o0000
ooooooooool00_oooolWokmoo`03o`000?moZOooOjWo013oOjWo0_l0000Dogood`;o00007on:ogl4
o`0001koc_mo1?l0000Noh[oO`?o00004omoom<2o`00017oOjWo0_l0000Uokmoo`Gooooo0Ol00001
ooooo`006oooool00ol0003oooooooooo`02ooooobOo_goo00?o0000ognYoomoZOl04?moZOl00ol0
003oOooCogood`0Bogood`;o00007On:ogl3o`0002Goc_mo1?l0000Noh[oO`03o`000?moom?oOooC
01;oOooC00?o0000ognYoomoZOl03omoZOl2o`0002Co_goo1Oooool1o`00007ooooo000Kooooo`;o
00000ooooolVokmoo`03o`000?moZOooOjWo013oOjWo00?o0000ogoodomoom<04_moom<2o`0001_o
R_mo0ol0000/olkoO`;o00007On:ogl00ol0003oOooCogood`0Bogood`03o`000?moZOooOjWo00oo
OjWo00?o0000okmooonoOol08_noOol4ooooo`;o00000Oooool001_ooooo00?o0000ooooooooool0
0_oooolVokmoo`03o`000?moZOooOjWo013oOjWo00?o0000ogoodomoom<04Omoom<2o`0001[oR_mo
0ol0000`olkoO`?o00006_n:ogl2o`0001?oOooC0_l0000AognYo`03o`000?noOooo_goo027o_goo
1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo9OnoOol00ol0003oOjWoognY
o`0@ognYo`03o`000?moom?oOooC017oOooC00?o0000oh[oOon:ogl06?n:ogl2o`0003Koc_mo0ol0
000Hoh[oO`;o00004omoom<2o`00013oOjWo0_l0000Rokmoo`Gooooo0Ol00001ooooo`006oooool0
0ol0003oooooooooo`02ooooobCo_goo00?o0000ognYoomoZOl04?moZOl00ol0003oOooCogood`0A
ogood`03o`000?n:ogooR_mo01OoR_mo0_l0000jolkoO`?o00006?n:ogl00ol0003oOooCogood`0A
ogood`03o`000?moZOooOjWo00ooOjWo0_l0000Qokmoo`Gooooo0Ol00001ooooo`006oooool00ol0
003oooooooooo`02ooooobCo_goo00?o0000ognYoomoZOl03omoZOl00ol0003oOooCogood`0Aogoo
d`03o`000?n:ogooR_mo01KoR_mo0_l0000nolkoO`?o00005on:ogl00ol0003oOooCogood`0Aogoo
d`03o`000?moZOooOjWo00ooOjWo0_l0000Pokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003o
ooooooooo`02ooooob?o_goo00?o0000ognYoomoZOl03omoZOl00ol0003oOooCogood`0@ogood`;o
00005on:ogl2o`0004;oc_mo0ol0000Foh[oO`03o`000?moom?oOooC013oOooC0_l0000AognYo`03
o`000?noOooo_goo01ko_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo
8_noOol00ol0003oOjWoognYo`0?ognYo`03o`000?moom?oOooC013oOooC0_l0000Eoh[oO`?o0000
A_o>ogl2o`0001KoR_mo00?o0000ogoodomoom<04?moom<2o`00013oOjWo0_l0000Ookmoo`Gooooo
0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooob7o_goo00?o0000ognYoomoZOl03omo
ZOl00ol0003oOooCogood`0@ogood`;o00005On:ogl2o`0004[oc_mo0_l0000Eoh[oO`03o`000?mo
om?oOooC013oOooC00?o0000ognYoomoZOl03omoZOl00ol0003o_goookmoo`0Mokmoo`Gooooo0Ol0
0001ooooo`006oooool00ol0003oooooooooo`02ooooob7o_goo00?o0000ognYoomoZOl03_moZOl0
0ol0003oOooCogood`0@ogood`03o`000?n:ogooR_mo01?oR_mo0_l0001>olkoO`03o`000?n:ogoo
R_mo01?oR_mo00?o0000ogoodomoom<04?moom<00ol0003oOjWoognYo`0?ognYo`03o`000?noOooo
_goo01co_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo8?noOol00ol0
003oOjWoognYo`0>ognYo`;o00004Omoom<00ol0003oR_mooh[oO`0Coh[oO`03o`000?o>ogooc_mo
04ooc_mo0_l0000Doh[oO`03o`000?moom?oOooC013oOooC00?o0000ognYoomoZOl03_moZOl2o`00
01go_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo7onoOol2o`00013o
OjWo00?o0000ogoodomoom<03omoom<00ol0003oR_mooh[oO`0Boh[oO`;o0000E?o>ogl00ol0003o
R_mooh[oO`0Boh[oO`03o`000?moom?oOooC013oOooC00?o0000ognYoomoZOl03_moZOl00ol0003o
_goookmoo`0Kokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooaoo_goo
00?o0000ognYoomoZOl03_moZOl00ol0003oOooCogood`0?ogood`03o`000?n:ogooR_mo01;oR_mo
00?o0000olkoOoo>ogl08Oo>oglCo`00027oc_mo0_l0000Coh[oO`;o00004Omoom<00ol0003oOjWo
ognYo`0>ognYo`03o`000?noOooo_goo01[o_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oo
oooooooo00;ooooo7_noOol00ol0003oOjWoognYo`0>ognYo`03o`000?moom?oOooC00ooOooC00?o
0000oh[oOon:ogl04_n:ogl00ol0003oc_moolkoO`0LolkoO`Ko00004oonogl5o`0001koc_mo0_l0
000Boh[oO`;o00004?moom<00ol0003oOjWoognYo`0>ognYo`03o`000?noOooo_goo01[o_goo1Ooo
ool1o`00007ooooo000Kooooo`;o00000ooooolMokmoo`03o`000?moZOooOjWo00koOjWo00?o0000
ogoodomoom<03omoom<00ol0003oR_mooh[oO`0Aoh[oO`;o00006oo>ogl4o`0001koo_mo1?l0000K
olkoO`;o00004_n:ogl2o`00013oOooC00?o0000ognYoomoZOl03_moZOl00ol0003o_goookmoo`0I
okmoo`Cooooo0_l00001ooooo`006oooool00ol0003oooooooooo`02oooooaco_goo0_l0000@ognY
o`03o`000?moom?oOooC00koOooC00?o0000oh[oOon:ogl04On:ogl00ol0003oc_moolkoO`0Holko
O`?o00009_onogl3o`0001Woc_mo0_l0000Boh[oO`;o00004?moom<00ol0003oOjWoognYo`0>ognY
o`03o`000?noOooo_goo01So_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;o
oooo7?noOol00ol0003oOjWoognYo`0>ognYo`03o`000?moom?oOooC00koOooC00?o0000oh[oOon:
ogl04?n:ogl2o`0001Soc_mo0ol0000/ookoO`?o00006?o>ogl2o`00017oR_mo0_l0000@ogood`03
o`000?moZOooOjWo00goOjWo00?o0000okmooonoOol06?noOol5ooooo`7o00000Oooool001_ooooo
00?o0000ooooooooool00_oooolKokmoo`03o`000?moZOooOjWo00koOjWo00?o0000ogoodomoom<0
3_moom<00ol0003oR_mooh[oO`0@oh[oO`;o00005oo>ogl2o`0003;oo_mo0_l0000HolkoO`03o`00
0?n:ogooR_mo00ooR_mo0_l0000?ogood`;o00003omoZOl00ol0003o_goookmoo`0Gokmoo`Gooooo
0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooa_o_goo00?o0000ognYoomoZOl03Omo
ZOl00ol0003oOooCogood`0>ogood`;o00004On:ogl2o`0001Koc_mo0_l0000fookoO`?o00005_o>
ogl00ol0003oR_mooh[oO`0?oh[oO`03o`000?moom?oOooC00koOooC00?o0000ognYoomoZOl03_mo
ZOl00ol0003o_goookmoo`0Fokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02
oooooa[o_goo00?o0000ognYoomoZOl03OmoZOl00ol0003oOooCogood`0>ogood`;o00004On:ogl0
0ol0003oc_moolkoO`0ColkoO`?o0000>oonogl2o`0001Goc_mo00?o0000oh[oOon:ogl03on:ogl0
0ol0003oOooCogood`0>ogood`03o`000?moZOooOjWo00goOjWo00?o0000okmooonoOol05_noOol5
ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolIokmoo`03o`000?moZOooOjWo
00koOjWo00?o0000ogoodomoom<03Omoom<2o`00013oR_mo0_l0000DolkoO`?o0000?oonogl2o`00
01Coc_mo0_l0000@oh[oO`03o`000?moom?oOooC00goOooC0_l0000?ognYo`03o`000?noOooo_goo
01Go_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo6OnoOol00ol0003o
OjWoognYo`0=ognYo`03o`000?moom?oOooC00goOooC0_l0000@oh[oO`;o00004oo>ogl3o`0004?o
o_mo0_l0000DolkoO`03o`000?n:ogooR_mo00koR_mo00?o0000ogoodomoom<03Omoom<2o`0000oo
OjWo00?o0000okmooonoOol05?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool0
0_oooolHokmoo`03o`000?moZOooOjWo00goOjWo00?o0000ogoodomoom<03_moom<00ol0003oR_mo
oh[oO`0>oh[oO`;o00004_o>ogl3o`0004Ooo_mo0_l0000ColkoO`03o`000?n:ogooR_mo00koR_mo
00?o0000ogoodomoom<03Omoom<00ol0003oOjWoognYo`0=ognYo`03o`000?noOooo_goo01Co_goo
1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo6?noOol00ol0003oOjWoognY
o`0=ognYo`03o`000?moom?oOooC00goOooC00?o0000oh[oOon:ogl03on:ogl00ol0003oc_moolko
O`0@olkoO`03o`000?onogooo_mo04[oo_mo00?o0000olkoOoo>ogl04Oo>ogl00ol0003oR_mooh[o
O`0>oh[oO`03o`000?moom?oOooC00coOooC00?o0000ognYoomoZOl03OmoZOl00ol0003o_goookmo
o`0Dokmoo`Gooooo0Ol00001ooooo`002?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3
o`0000Gooooo00?o0000ooooooooool00_oooolGokmoo`03o`000?moZOooOjWo00goOjWo00?o0000
ogoodomoom<03_moom<00ol0003oR_mooh[oO`0=oh[oO`;o00004Oo>ogl3o`0002Coo_mo1?l0000U
ookoO`;o00004Oo>ogl2o`0000ooR_mo0_l0000>ogood`03o`000?moZOooOjWo00goOjWo00?o0000
okmooonoOol04onoOol5ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00001oooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool00_oooolFokmoo`;o00003omo
ZOl00ol0003oOooCogood`0=ogood`03o`000?n:ogooR_mo00goR_mo0_l0000AolkoO`;o00007Oon
ogl9o`0000Coomio2_l0000LookoO`;o00004Oo>ogl2o`0000ooR_mo0_l0000>ogood`03o`000?mo
ZOooOjWo00goOjWo00?o0000okmooonoOol04_noOol5ooooo`7o00000Oooool000Go00000_ooool0
1?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00_oo
oolFokmoo`03o`000?moZOooOjWo00goOjWo00?o0000ogoodomoom<03Omoom<00ol0003oR_mooh[o
O`0=oh[oO`03o`000?o>ogooc_mo00ooc_mo0_l0000JookoO`Go00005ooogWl5o`0001Woo_mo0_l0
000AolkoO`03o`000?n:ogooR_mo00goR_mo0_l0000>ogood`03o`000?moZOooOjWo00coOjWo00?o
0000okmooonoOol04_noOol5ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00002ooo
ool00ol0003oooooooooo`02ooooo`?o00000_oooolEokmoo`;o00003_moZOl00ol0003oOooCogoo
d`0=ogood`03o`000?n:ogooR_mo00goR_mo00?o0000olkoOoo>ogl03oo>ogl2o`0001Ooo_mo1?l0
000QoooNO`?o00006?onogl00ol0003oc_moolkoO`0?olkoO`03o`000?n:ogooR_mo00goR_mo00?o
0000ogoodomoom<03?moom<2o`0000koOjWo00?o0000okmooonoOol04OnoOol4ooooo`;o00000Ooo
ool000Oooooo00Co0000oooooooooooo00001oooool4o`0000Gooooo00?o0000ooooooooool00_oo
oolEokmoo`03o`000?moZOooOjWo00goOjWo00?o0000ogoodomoom<03?moom<00ol0003oR_mooh[o
O`0=oh[oO`03o`000?o>ogooc_mo00ooc_mo00?o0000ookoOoonogl05?onogl3o`0002Soomio0ol0
000FookoO`03o`000?o>ogooc_mo00ooc_mo00?o0000oh[oOon:ogl03On:ogl00ol0003oOooCogoo
d`0<ogood`03o`000?moZOooOjWo00coOjWo00?o0000okmooonoOol04OnoOol5ooooo`7o00000Ooo
ool000Oooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00;ooooo5?noOol00ol0003oOjWoognYo`0=ognYo`03o`000?moom?oOooC00coOooC00?o
0000oh[oOon:ogl03On:ogl00ol0003oc_moolkoO`0>olkoO`;o00005Oonogl2o`0002koomio0_l0
000EookoO`;o00004?o>ogl00ol0003oR_mooh[oO`0<oh[oO`;o00003_moom<00ol0003oOjWoognY
o`0<ognYo`03o`000?noOooo_goo013o_goo1Oooool1o`00007ooooo0008ooooo`;o00002?ooool5
o`0000Cooooo00?o0000ooooooooool00_oooolDokmoo`03o`000?moZOooOjWo00coOjWo00?o0000
ogoodomoom<03?moom<00ol0003oR_mooh[oO`0=oh[oO`03o`000?o>ogooc_mo00koc_mo00?o0000
ookoOoonogl04oonogl2o`0003;oomio1?l0000CookoO`03o`000?o>ogooc_mo00koc_mo00?o0000
oh[oOon:ogl03?n:ogl00ol0003oOooCogood`0<ogood`;o00003_moZOl00ol0003o_goookmoo`0?
okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooa?o_goo00?o0000ognY
oomoZOl03?moZOl00ol0003oOooCogood`0<ogood`;o00003_n:ogl00ol0003oc_moolkoO`0>olko
O`03o`000?onogooo_mo017oo_mo0ol0000hoooNO`;o00004_onogl2o`0000ooc_mo00?o0000oh[o
Oon:ogl03?n:ogl00ol0003oOooCogood`0<ogood`03o`000?moZOooOjWo00coOjWo00?o0000okmo
oonoOol03onoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolBokmoo`03
o`000?moZOooOjWo00goOjWo00?o0000ogoodomoom<02omoom<2o`0000koR_mo00?o0000olkoOoo>
ogl03_o>ogl00ol0003oo_moookoO`0@ookoO`;o0000?OoogWl2o`0001;oo_mo00?o0000olkoOoo>
ogl03Oo>ogl00ol0003oR_mooh[oO`0<oh[oO`03o`000?moom?oOooC00coOooC00?o0000ognYoomo
ZOl03?moZOl00ol0003o_goookmoo`0>okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003ooooo
ooooo`02oooooa;o_goo00?o0000ognYoomoZOl03?moZOl00ol0003oOooCogood`0<ogood`03o`00
0?n:ogooR_mo00coR_mo00?o0000olkoOoo>ogl03Oo>ogl2o`0001;oo_mo00?o0000oooNOooogWl0
?ooogWl2o`00017oo_mo0_l0000>olkoO`03o`000?n:ogooR_mo00coR_mo00?o0000ogoodomoom<0
3?moom<00ol0003oOjWoognYo`0;ognYo`03o`000?noOooo_goo00ko_goo1Oooool1o`00007ooooo
000Kooooo`03o`000?oooooooooo00;ooooo4OnoOol00ol0003oOjWoognYo`0<ognYo`;o00003Omo
om<00ol0003oR_mooh[oO`0<oh[oO`03o`000?o>ogooc_mo00goc_mo00?o0000ookoOoonogl04?on
ogl2o`0004Coomio0_l0000@ookoO`;o00003_o>ogl00ol0003oR_mooh[oO`0<oh[oO`03o`000?mo
om?oOooC00_oOooC00?o0000ognYoomoZOl03?moZOl00ol0003o_goookmoo`0=okmoo`Gooooo0Ol0
0001ooooo`006oooool00ol0003oooooooooo`02oooooa7o_goo00?o0000ognYoomoZOl03?moZOl0
0ol0003oOooCogood`0;ogood`03o`000?n:ogooR_mo00coR_mo00?o0000olkoOoo>ogl03Oo>ogl0
0ol0003oo_moookoO`0>ookoO`?o00007_oogWl;o`0001ooomio00?o0000ookoOoonogl03oonogl0
0ol0003oc_moolkoO`0;olkoO`;o00003On:ogl00ol0003oOooCogood`0<ogood`03o`000?moZOoo
OjWo00_oOjWo0_l0000>okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooo
oa3o_goo00?o0000ognYoomoZOl03?moZOl00ol0003oOooCogood`0<ogood`03o`000?n:ogooR_mo
00_oR_mo00?o0000olkoOoo>ogl03Oo>ogl00ol0003oo_moookoO`0>ookoO`03o`000?oogWooomio
01Soomio1ol0000;ooo5O`Oo00006OoogWl2o`00013oo_mo00?o0000olkoOoo>ogl02oo>ogl2o`00
00goR_mo00?o0000ogoodomoom<03?moom<00ol0003oOjWoognYo`0;ognYo`03o`000?noOooo_goo
00co_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo3onoOol2o`0000go
OjWo0_l0000=ogood`03o`000?n:ogooR_mo00_oR_mo00?o0000olkoOoo>ogl03?o>ogl2o`0000oo
o_mo0_l0000FoooNO`Go00006OooaGl5o`0001Koomio00?o0000ookoOoonogl03_onogl00ol0003o
c_moolkoO`0;olkoO`;o00003On:ogl00ol0003oOooCogood`0;ogood`03o`000?moZOooOjWo00co
OjWo00?o0000okmooonoOol02onoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool0
0_ooool?okmoo`03o`000?moZOooOjWo00_oOjWo0_l0000=ogood`03o`000?n:ogooR_mo00_oR_mo
0_l0000=olkoO`;o00003oonogl00ol0003oomiooooNO`0CoooNO`?o00008oooaGl3o`0001Coomio
0_l0000?ookoO`03o`000?o>ogooc_mo00coc_mo00?o0000oh[oOon:ogl02on:ogl00ol0003oOooC
ogood`0;ogood`03o`000?moZOooOjWo00_oOjWo0_l0000<okmoo`Gooooo0Ol00001ooooo`006ooo
ool00ol0003oooooooooo`02ooooo`ko_goo00?o0000ognYoomoZOl03?moZOl00ol0003oOooCogoo
d`0;ogood`03o`000?n:ogooR_mo00_oR_mo0_l0000=olkoO`03o`000?onogooo_mo00goo_mo0_l0
000CoooNO`?o0000:OooaGl3o`0001?oomio0_l0000>ookoO`03o`000?o>ogooc_mo00coc_mo00?o
0000oh[oOon:ogl02_n:ogl2o`0000goOooC00?o0000ognYoomoZOl02omoZOl00ol0003o_goookmo
o`0:okmoo`Gooooo0Ol00001ooooo`006oooool2o`0000?ooooo3_noOol00ol0003oOjWoognYo`0;
ognYo`03o`000?moom?oOooC00_oOooC00?o0000oh[oOon:ogl03?n:ogl00ol0003oc_moolkoO`0;
olkoO`03o`000?onogooo_mo00goo_mo00?o0000oooNOooogWl04OoogWl2o`0002ooolEo0ol0000A
oooNO`;o00003_onogl00ol0003oc_moolkoO`0<olkoO`03o`000?n:ogooR_mo00[oR_mo00?o0000
ogoodomoom<02omoom<00ol0003oOjWoognYo`0<ognYo`03o`000?noOooo_goo00Wo_goo1?ooool2
o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo3OnoOol00ol0003oOjWoognYo`0<ognY
o`03o`000?moom?oOooC00_oOooC00?o0000oh[oOon:ogl02on:ogl00ol0003oc_moolkoO`0;olko
O`03o`000?onogooo_mo00coo_mo0_l0000AoooNO`?o0000<oooaGl3o`00017oomio0_l0000=ooko
O`;o00003?o>ogl00ol0003oR_mooh[oO`0;oh[oO`03o`000?moom?oOooC00_oOooC00?o0000ognY
oomoZOl02omoZOl00ol0003o_goookmoo`09okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003o
ooooooooo`02ooooo`go_goo00?o0000ognYoomoZOl02omoZOl00ol0003oOooCogood`0;ogood`03
o`000?n:ogooR_mo00_oR_mo00?o0000olkoOoo>ogl02oo>ogl00ol0003oo_moookoO`0<ookoO`03
o`000?oogWooomio00ooomio0_l0000iooo5O`?o00003ooogWl2o`0000goo_mo0_l0000<olkoO`03
o`000?n:ogooR_mo00[oR_mo0_l0000=ogood`03o`000?moZOooOjWo00_oOjWo00?o0000okmooono
Ool02?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool<okmoo`03o`00
0?moZOooOjWo00_oOjWo00?o0000ogoodomoom<02omoom<00ol0003oR_mooh[oO`0;oh[oO`03o`00
0?o>ogooc_mo00_oc_mo00?o0000ookoOoonogl02oonogl2o`00013oomio0_l0000nooo5O`;o0000
3_oogWl2o`0000goo_mo0_l0000<olkoO`03o`000?n:ogooR_mo00[oR_mo0_l0000<ogood`03o`00
0?moZOooOjWo00_oOjWo00?o0000okmooonoOol02?noOol5ooooo`7o00000Oooool001_ooooo00?o
0000ooooooooool00_ooool;okmoo`;o00003OmoZOl00ol0003oOooCogood`0:ogood`;o00003?n:
ogl2o`0000coc_mo00?o0000ookoOoonogl02oonogl2o`0000ooomio0_l00011ooo5O`?o00003Ooo
gWl3o`0000coo_mo0_l0000<olkoO`03o`000?n:ogooR_mo00[oR_mo00?o0000ogoodomoom<02omo
om<00ol0003oOjWoognYo`0;ognYo`03o`000?noOooo_goo00Oo_goo1Oooool1o`00007ooooo000K
ooooo`03o`000?oooooooooo00;ooooo2onoOol00ol0003oOjWoognYo`0;ognYo`03o`000?moom?o
OooC00_oOooC00?o0000oh[oOon:ogl02on:ogl00ol0003oc_moolkoO`0:olkoO`03o`000?onogoo
o_mo00_oo_mo0_l0000?oooNO`;o00005oooaGlFo`0001OoolEo0_l0000?oooNO`03o`000?onogoo
o_mo00[oo_mo00?o0000olkoOoo>ogl02oo>ogl00ol0003oR_mooh[oO`09oh[oO`03o`000?moom?o
OooC00_oOooC00?o0000ognYoomoZOl02omoZOl00ol0003o_goookmoo`07okmoo`Gooooo0Ol00001
ooooo`006oooool00ol0003oooooooooo`02ooooo`_o_goo00?o0000ognYoomoZOl02omoZOl00ol0
003oOooCogood`0;ogood`03o`000?n:ogooR_mo00WoR_mo0_l0000<olkoO`;o00003?onogl2o`00
00goomio0ol0000Cooo5O`Ko00005_oo/gl5o`0001CoolEo0_l0000=oooNO`;o00003?onogl00ol0
003oc_moolkoO`0:olkoO`03o`000?n:ogooR_mo00[oR_mo00?o0000ogoodomoom<02omoom<00ol0
003oOjWoognYo`0:ognYo`;o00002?noOol5ooooo`7o00000Oooool001_ooooo00?o0000oooooooo
ool00_ooool:okmoo`03o`000?moZOooOjWo00_oOjWo00?o0000ogoodomoom<02omoom<00ol0003o
R_mooh[oO`0:oh[oO`03o`000?o>ogooc_mo00[oc_mo0_l0000<ookoO`03o`000?oogWooomio00co
omio0_l0000Booo5O`Co00008?oo/gl3o`0001;oolEo0ol0000<oooNO`;o00003?onogl00ol0003o
c_moolkoO`0:olkoO`03o`000?n:ogooR_mo00[oR_mo00?o0000ogoodomoom<02_moom<00ol0003o
OjWoognYo`0;ognYo`03o`000?noOooo_goo00Ko_goo1Oooool1o`00007ooooo000Kooooo`03o`00
0?oooooooooo00;ooooo2_noOol00ol0003oOjWoognYo`0;ognYo`03o`000?moom?oOooC00[oOooC
00?o0000oh[oOon:ogl02_n:ogl00ol0003oc_moolkoO`0:olkoO`;o00003?onogl00ol0003oomio
oooNO`0;oooNO`;o00004OooaGl3o`0002Oook=o0ol0000Aooo5O`;o00003OoogWl00ol0003oo_mo
ookoO`0:ookoO`03o`000?o>ogooc_mo00[oc_mo00?o0000oh[oOon:ogl02_n:ogl00ol0003oOooC
ogood`0:ogood`03o`000?moZOooOjWo00_oOjWo00?o0000okmooonoOol01OnoOol5ooooo`7o0000
0Oooool001_ooooo00?o0000ooooooooool00_ooool9okmoo`03o`000?moZOooOjWo00_oOjWo00?o
0000ogoodomoom<02omoom<00ol0003oR_mooh[oO`09oh[oO`;o00002oo>ogl2o`0000coo_mo00?o
0000oooNOooogWl02ooogWl2o`0000ooolEo0ol0000]ooncO`?o00004?ooaGl00ol0003oomiooooN
O`0;oooNO`03o`000?onogooo_mo00[oo_mo00?o0000olkoOoo>ogl02Oo>ogl2o`0000_oR_mo0_l0
000;ogood`03o`000?moZOooOjWo00_oOjWo00?o0000okmooonoOol01OnoOol5ooooo`7o00000Ooo
ool001_ooooo00?o0000ooooooooool00_ooool9okmoo`03o`000?moZOooOjWo00[oOjWo00?o0000
ogoodomoom<02omoom<00ol0003oR_mooh[oO`09oh[oO`;o00002oo>ogl2o`0000coo_mo00?o0000
oooNOooogWl02_oogWl2o`0000ooolEo0_l0000cooncO`?o00003_ooaGl2o`0000coomio0_l0000;
ookoO`03o`000?o>ogooc_mo00Woc_mo00?o0000oh[oOon:ogl02_n:ogl00ol0003oOooCogood`0:
ogood`03o`000?moZOooOjWo00_oOjWo00?o0000okmooonoOol01?noOol5ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_ooool8okmoo`03o`000?moZOooOjWo00_oOjWo00?o0000ogoo
domoom<02_moom<00ol0003oR_mooh[oO`0:oh[oO`03o`000?o>ogooc_mo00[oc_mo00?o0000ooko
Ooonogl02Oonogl2o`0000coomio00?o0000ooo5OoooaGl03OooaGl2o`0003Sook=o0_l0000>ooo5
O`03o`000?oogWooomio00[oomio0_l0000;ookoO`03o`000?o>ogooc_mo00Woc_mo00?o0000oh[o
Oon:ogl02_n:ogl00ol0003oOooCogood`0:ogood`03o`000?moZOooOjWo00[oOjWo00?o0000okmo
oonoOol01?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool7okmoo`;o
00003?moZOl00ol0003oOooCogood`0:ogood`03o`000?n:ogooR_mo00[oR_mo00?o0000olkoOoo>
ogl02_o>ogl00ol0003oo_moookoO`09ookoO`03o`000?oogWooomio00[oomio0_l0000>ooo5O`;o
00006ooo/gl6o`0001_ook=o0_l0000=ooo5O`;o00002ooogWl2o`0000[oo_mo0_l0000;olkoO`03
o`000?n:ogooR_mo00WoR_mo0_l0000;ogood`03o`000?moZOooOjWo00[oOjWo0_l00005okmoo`Go
oooo0Ol00001ooooo`006oooool2o`0000?ooooo1onoOol00ol0003oOjWoognYo`0;ognYo`03o`00
0?moom?oOooC00[oOooC00?o0000oh[oOon:ogl02On:ogl00ol0003oc_moolkoO`0:olkoO`03o`00
0?onogooo_mo00Woo_mo00?o0000oooNOooogWl02_oogWl00ol0003oolEoooo5O`0<ooo5O`;o0000
5Ooo/gl8o`0000KoojIo2Ol0000DooncO`;o00003?ooaGl2o`0000_oomio0_l0000;ookoO`03o`00
0?o>ogooc_mo00Woc_mo00?o0000oh[oOon:ogl02On:ogl00ol0003oOooCogood`0:ogood`03o`00
0?moZOooOjWo00[oOjWo00?o0000okmooonoOol00onoOol4ooooo`;o00000Oooool001_ooooo00?o
0000ooooooooool00_ooool6okmoo`03o`000?moZOooOjWo00_oOjWo00?o0000ogoodomoom<02_mo
om<00ol0003oR_mooh[oO`09oh[oO`;o00002oo>ogl00ol0003oo_moookoO`09ookoO`03o`000?oo
gWooomio00[oomio00?o0000ooo5OoooaGl02oooaGl2o`00017ook=o1_l0000GoonVO`Go00004Ooo
/gl2o`0000coolEo0_l0000;oooNO`03o`000?onogooo_mo00Woo_mo00?o0000olkoOoo>ogl02Oo>
ogl00ol0003oR_mooh[oO`09oh[oO`03o`000?moom?oOooC00WoOooC0_l0000;ognYo`03o`000?no
Oooo_goo00?o_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo1_noOol0
0ol0003oOjWoognYo`0:ognYo`03o`000?moom?oOooC00[oOooC0_l0000;oh[oO`03o`000?o>ogoo
c_mo00Woc_mo00?o0000ookoOoonogl02Oonogl00ol0003oomiooooNO`0:oooNO`03o`000?ooaGoo
olEo00[oolEo0_l0000@ooncO`?o00008_ooYWl3o`00013ook=o0_l0000<ooo5O`03o`000?oogWoo
omio00Woomio00?o0000ookoOoonogl02?onogl2o`0000[oc_mo00?o0000oh[oOon:ogl02On:ogl2
o`0000_oOooC00?o0000ognYoomoZOl02_moZOl00ol0003o_goookmoo`02okmoo`Gooooo0Ol00001
ooooo`006oooool00ol0003oooooooooo`02ooooo`Go_goo0_l0000<ognYo`03o`000?moom?oOooC
00[oOooC00?o0000oh[oOon:ogl02On:ogl00ol0003oc_moolkoO`09olkoO`03o`000?onogooo_mo
00Woo_mo00?o0000oooNOooogWl02OoogWl2o`0000_oolEo0_l0000?ooncO`?o0000:?ooYWl3o`00
00oook=o00?o0000ooo5OoooaGl02_ooaGl00ol0003oomiooooNO`09oooNO`03o`000?onogooo_mo
00Soo_mo0_l0000:olkoO`03o`000?n:ogooR_mo00WoR_mo00?o0000ogoodomoom<02_moom<00ol0
003oOjWoognYo`0:ognYo`04o`000?noOooo_goookmoo`Gooooo0Ol00001ooooo`006oooool00ol0
003oooooooooo`02ooooo`Go_goo00?o0000ognYoomoZOl02_moZOl00ol0003oOooCogood`0:ogoo
d`03o`000?n:ogooR_mo00WoR_mo00?o0000olkoOoo>ogl02Oo>ogl00ol0003oo_moookoO`09ooko
O`03o`000?oogWooomio00Woomio0_l0000;ooo5O`03o`000?oo/goook=o00gook=o0_l0000^oonV
O`;o00003_oo/gl2o`0000_oolEo00?o0000oooNOooogWl02OoogWl00ol0003oo_moookoO`08ooko
O`03o`000?o>ogooc_mo00Woc_mo00?o0000oh[oOon:ogl02On:ogl00ol0003oOooCogood`09ogoo
d`03o`000?moZOooOjWo00[oOjWo00Co0000okmooonoOooo_goo1Oooool1o`00007ooooo000Koooo
o`03o`000?oooooooooo00;ooooo1OnoOol00ol0003oOjWoognYo`0:ognYo`03o`000?moom?oOooC
00WoOooC0_l0000:oh[oO`03o`000?o>ogooc_mo00Woc_mo0_l0000:ookoO`03o`000?oogWooomio
00Woomio00?o0000ooo5OoooaGl02OooaGl2o`0000gook=o0ol0000boonVO`Co00003?oo/gl00ol0
003oolEoooo5O`09ooo5O`;o00002_oogWl00ol0003oo_moookoO`08ookoO`03o`000?o>ogooc_mo
00Soc_mo0_l0000;oh[oO`03o`000?moom?oOooC00WoOooC00?o0000ognYoomoZOl02OmoZOl01?l0
003o_goookmooonoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool5okmo
o`03o`000?moZOooOjWo00WoOjWo00?o0000ogoodomoom<02Omoom<2o`0000_oR_mo00?o0000olko
Ooo>ogl02?o>ogl2o`0000[oo_mo00?o0000oooNOooogWl02OoogWl00ol0003oolEoooo5O`09ooo5
O`03o`000?oo/goook=o00_ook=o0_l0000GoonVO`co00005_ooYWl2o`0000_ook=o0_l0000;ooo5
O`03o`000?oogWooomio00Ooomio0_l0000:ookoO`03o`000?o>ogooc_mo00Soc_mo00?o0000oh[o
Oon:ogl02On:ogl00ol0003oOooCogood`09ogood`;o00002_moZOl01?l0003o_goookmooonoOol5
ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool4okmoo`03o`000?moZOooOjWo
00WoOjWo00?o0000ogoodomoom<02_moom<00ol0003oR_mooh[oO`09oh[oO`03o`000?o>ogooc_mo
00Woc_mo00?o0000ookoOoonogl02?onogl00ol0003oomiooooNO`08oooNO`;o00002_ooaGl2o`00
00cook=o0_l0000BoonVO`Oo00003?ooWGl7o`00017oojIo0_l0000;ooncO`03o`000?ooaGooolEo
00WoolEo00?o0000oooNOooogWl01ooogWl2o`0000[oo_mo00?o0000olkoOoo>ogl02?o>ogl00ol0
003oR_mooh[oO`09oh[oO`03o`000?moom?oOooC00WoOooC00?o0000ognYoomoZOl02OmoZOl00ol0
003o_goookmoo`05ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool4okmoo`03
o`000?moZOooOjWo00WoOjWo00?o0000ogoodomoom<02Omoom<00ol0003oR_mooh[oO`09oh[oO`03
o`000?o>ogooc_mo00Soc_mo0_l0000:ookoO`03o`000?oogWooomio00Soomio0_l0000:ooo5O`03
o`000?oo/goook=o00[ook=o0_l0000?oonVO`Go00006_ooWGl4o`0000ooojIo0_l0000:ooncO`;o
00002_ooaGl00ol0003oomiooooNO`07oooNO`;o00002_onogl00ol0003oc_moolkoO`07olkoO`;o
00002on:ogl00ol0003oOooCogood`08ogood`;o00002_moZOl00ol0003o_goookmoo`05ooooo`7o
00000Oooool001_ooooo00?o0000ooooooooool00_ooool4okmoo`03o`000?moZOooOjWo00SoOjWo
00?o0000ogoodomoom<02_moom<00ol0003oR_mooh[oO`08oh[oO`;o00002_o>ogl00ol0003oo_mo
ookoO`08ookoO`03o`000?oogWooomio00Soomio0_l0000:ooo5O`03o`000?oo/goook=o00Wook=o
0_l0000>oonVO`?o00008oooWGl3o`0000koojIo00?o0000ooncOooo/gl02?oo/gl2o`0000[oolEo
00?o0000oooNOooogWl01ooogWl2o`0000[oo_mo00?o0000olkoOoo>ogl01oo>ogl2o`0000[oR_mo
00?o0000ogoodomoom<02Omoom<00ol0003oOjWoognYo`08ognYo`03o`000?noOooo_goo00Gooooo
0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`Co_goo00?o0000ognYoomoZOl02?mo
ZOl00ol0003oOooCogood`09ogood`03o`000?n:ogooR_mo00WoR_mo00?o0000olkoOoo>ogl02?o>
ogl00ol0003oo_moookoO`08ookoO`03o`000?oogWooomio00Soomio00?o0000ooo5OoooaGl02?oo
aGl2o`0000[ook=o0ol0000<oonVO`?o0000:OooWGl3o`0000coojIo0_l0000:ooncO`;o00002Ooo
aGl00ol0003oomiooooNO`07oooNO`;o00002Oonogl00ol0003oc_moolkoO`08olkoO`03o`000?n:
ogooR_mo00WoR_mo00?o0000ogoodomoom<02Omoom<00ol0003oOjWoognYo`07ognYo`03o`000?no
Oooo_goo00Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`;o_goo0_l0000:
ognYo`03o`000?moom?oOooC00WoOooC00?o0000oh[oOon:ogl02On:ogl00ol0003oc_moolkoO`08
olkoO`03o`000?onogooo_mo00Soo_mo00?o0000oooNOooogWl02?oogWl00ol0003oolEoooo5O`08
ooo5O`;o00002Ooo/gl2o`0000coojIo0ol0000_oonMO`?o00002oooYWl2o`0000[ook=o00?o0000
ooo5OoooaGl01oooaGl00ol0003oomiooooNO`07oooNO`;o00002Oonogl00ol0003oc_moolkoO`07
olkoO`;o00002_n:ogl00ol0003oOooCogood`09ogood`03o`000?moZOooOjWo00OoOjWo0_l00000
0onoOoooooooooooo`03ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool2okmo
o`03o`000?moZOooOjWo00SoOjWo0_l0000;ogood`03o`000?n:ogooR_mo00SoR_mo0_l00009olko
O`;o00002Oonogl2o`0000Woomio00?o0000ooo5OoooaGl01oooaGl2o`0000[ook=o00?o0000oonV
OoooYWl02_ooYWl3o`0001?ooieo3ol0000AoonMO`?o00002oooYWl2o`0000Wook=o00?o0000ooo5
OoooaGl01oooaGl2o`0000Woomio00?o0000ookoOoonogl01oonogl00ol0003oc_moolkoO`08olko
O`03o`000?n:ogooR_mo00SoR_mo00?o0000ogoodomoom<02Omoom<00ol0003oOjWoognYo`07ognY
o`03o`000?noOooooooo00Cooooo0Ol00001ooooo`006oooool2o`0000?ooooo0_noOol00ol0003o
OjWoognYo`08ognYo`03o`000?moom?oOooC00WoOooC00?o0000oh[oOon:ogl02On:ogl00ol0003o
c_moolkoO`08olkoO`03o`000?onogooo_mo00Soo_mo00?o0000oooNOooogWl01ooogWl00ol0003o
olEoooo5O`08ooo5O`03o`000?oo/goook=o00Oook=o0_l0000;oonVO`;o00004?ooWGl6o`0000oo
oiMo1_l0000>oonMO`?o00002OooYWl2o`0000Wook=o00?o0000ooo5OoooaGl01oooaGl00ol0003o
omiooooNO`07oooNO`;o00002?onogl00ol0003oc_moolkoO`08olkoO`;o00002On:ogl00ol0003o
OooCogood`0:ogood`03o`000?moZOooOjWo00KoOjWo00?o0000okmoooooool00oooool2o`00007o
oooo000Kooooo`03o`000?oooooooooo00;ooooo0_noOol00ol0003oOjWoognYo`08ognYo`03o`00
0?moom?oOooC00WoOooC00?o0000oh[oOon:ogl02On:ogl00ol0003oc_moolkoO`07olkoO`;o0000
2Oonogl00ol0003oomiooooNO`07oooNO`;o00002OooaGl00ol0003ook=oooncO`07ooncO`;o0000
2_ooYWl3o`0000cooieo1Ol0000JoonGO`Go00003?ooWGl2o`0000WoojIo0_l00009ooncO`;o0000
2?ooaGl00ol0003oomiooooNO`07oooNO`03o`000?onogooo_mo00Ooo_mo00?o0000olkoOoo>ogl0
2?o>ogl00ol0003oR_mooh[oO`08oh[oO`03o`000?moom?oOooC00WoOooC00?o0000ognYoomoZOl0
1_moZOl00ol0003o_gooooooo`04ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oo
ool2okmoo`03o`000?moZOooOjWo00OoOjWo00?o0000ogoodomoom<02Omoom<00ol0003oR_mooh[o
O`09oh[oO`03o`000?o>ogooc_mo00Ooc_mo0_l00009ookoO`03o`000?oogWooomio00Ooomio0_l0
0009ooo5O`03o`000?oo/goook=o00Oook=o0_l0000:oonVO`;o00002oooWGl4o`0002;ooiMo1?l0
000;oonMO`;o00002OooYWl00ol0003ook=oo`000007ooncO`;o00002?ooaGl00ol0003oomiooooN
O`07oooNO`03o`000?onogooo_mo00Ooo_mo00?o0000olkoOoo>ogl01oo>ogl2o`0000WoR_mo00?o
0000ogoodomoom<02Omoom<2o`0000OoOjWo00?o0000okmoooooool01?ooool1o`00007ooooo000K
ooooo`03o`000?oooooooooo00;ooooo0_noOol00ol0003oOjWoognYo`07ognYo`03o`000?moom?o
OooC00WoOooC00?o0000oh[oOon:ogl02?n:ogl00ol0003oc_moolkoO`08olkoO`03o`000?onogoo
o_mo00Ooo_mo00?o0000oooNOooogWl01ooogWl2o`0000WoolEo00?o0000ooncOooo/gl01_oo/gl2
o`0000[oojIo0_l0000:oonMO`Co0000:OooUgl2o`0000_ooieo0_l00008oonVO`;o00002?oo/gl2
o`0000SoolEo00?o0000oooNOooogWl01_oogWl2o`0000Soo_mo00?o0000olkoOoo>ogl02?o>ogl2
o`0000WoR_mo00?o0000ogoodomoom<02Omoom<00ol0003oOjWoognYo`05ognYo`03o`000?noOooo
oooo00Cooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`03okmoool0003oOjWo
00SoOjWo00?o0000ogoodomoom<02Omoom<00ol0003oR_mooh[oO`08oh[oO`03o`000?o>ogooc_mo
00Soc_mo00?o0000ookoOoonogl01oonogl00ol0003oomiooooNO`07oooNO`;o00002OooaGl00ol0
003ook=oooncO`06ooncO`;o00002OooYWl2o`0000[ooieo0ol0000CoonGO`[o00004OooUgl3o`00
00[ooieo0_l00008oonVO`03o`000?oo/goook=o00Kook=o0_l00008ooo5O`03o`000?oogWooomio
00Koomio0_l00008ookoO`03o`000?o>ogooc_mo00Soc_mo00?o0000oh[oOon:ogl02?n:ogl00ol0
003oOooCogood`08ogood`;o00001omoZOl00ol0003oooooooooo`03ooooo`7o00000Oooool001_o
oooo00?o0000ooooooooool00_ooool00onoOooo0000ognYo`08ognYo`03o`000?moom?oOooC00So
OooC00?o0000oh[oOon:ogl02On:ogl00ol0003oc_moolkoO`07olkoO`03o`000?onogooo_mo00So
o_mo00?o0000oooNOooogWl01_oogWl2o`0000SoolEo0_l00008ooncO`03o`000?ooYWooojIo00Oo
ojIo0_l0000:oonMO`;o00003oooUgl7o`0000[ooi9o1ol0000=oonGO`?o00002?ooWGl2o`0000So
ojIo0_l00007ooncO`;o00002?ooaGl00ol0003oomiooooNO`06oooNO`;o00002?onogl00ol0003o
c_moolkoO`07olkoO`;o00002On:ogl00ol0003oOooCogood`09ogood`03o`000?moZOooOjWo00Go
OjWo00?o0000ooooooooool00oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo
00?o_gooo`000?moZOl01omoZOl00ol0003oOooCogood`09ogood`03o`000?n:ogooR_mo00SoR_mo
00?o0000olkoOoo>ogl01oo>ogl2o`0000Woo_mo00?o0000oooNOooogWl01_oogWl2o`0000OoolEo
0_l00009ooncO`03o`000?ooYWooojIo00KoojIo0_l0000:oonMO`;o00003OooUgl4o`0001Sooi9o
1?l0000<oonGO`;o00002?ooWGl2o`0000SoojIo00?o0000ooncOooo/gl01_oo/gl00ol0003oolEo
ooo5O`06ooo5O`03o`000?oogWooomio00Koomio00?o0000ookoOoonogl01oonogl00ol0003oc_mo
olkoO`07olkoO`03o`000?n:ogooR_mo00SoR_mo00?o0000ogoodomoom<02?moom<2o`0000KoOjWo
00?o0000ooooooooool00oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo00?o
_gooo`000?moZOl01_moZOl2o`0000[oOooC00?o0000oh[oOon:ogl02?n:ogl00ol0003oc_moolko
O`08olkoO`03o`000?onogooo_mo00Ooo_mo00?o0000oooNOooogWl01_oogWl2o`0000OoolEo0_l0
0008ooncO`;o00002?ooYWl2o`0000Wooieo0_l0000:oonGO`Go00008?ooTWl4o`0000[ooiMo0_l0
0008oonMO`03o`000?ooYWooojIo00KoojIo0_l00007ooncO`03o`000?ooaGooolEo00KoolEo00?o
0000oooNOooogWl01_oogWl00ol0003oo_moookoO`07ookoO`03o`000?o>ogooc_mo00Ooc_mo00?o
0000oh[oOon:ogl02?n:ogl00ol0003oOooCogood`08ogood`03o`000?moZOooOjWo00CoOjWo00?o
0000ooooooooool00oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo00?o_goo
o`000?moZOl01_moZOl00ol0003oOooCogood`09ogood`03o`000?n:ogooR_mo00SoR_mo00?o0000
olkoOoo>ogl01oo>ogl00ol0003oo_moookoO`07ookoO`03o`000?oogWooomio00Ooomio00?o0000
ooo5OoooaGl01OooaGl2o`0000Sook=o00?o0000oonVOoooYWl01_ooYWl2o`0000Wooieo0_l0000:
oonGO`?o0000:?ooTWl3o`0000WooiMo0_l00007oonMO`;o00001oooYWl2o`0000Oook=o00?o0000
ooo5OoooaGl01OooaGl2o`0000Soomio00?o0000ookoOoonogl01_onogl2o`0000Soc_mo0_l00009
oh[oO`03o`000?moom?oOooC00WoOooC00?o0000ognYoomoZOl00omoZOl00ol0003oooooooooo`03
ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool00onoOooo0000ognYo`05ognY
o`;o00002_moom<00ol0003oR_mooh[oO`08oh[oO`03o`000?o>ogooc_mo00Ooc_mo00?o0000ooko
Ooonogl01oonogl00ol0003oomiooooNO`07oooNO`03o`000?ooaGooolEo00GoolEo0_l00008oonc
O`03o`000?ooYWooojIo00KoojIo00?o0000oonMOoooWGl01oooWGl2o`0000WooiMo0ol0000@oonB
Oa3o00003_ooTWl3o`0000SooiMo0_l00007oonMO`03o`000?ooYWooojIo00GoojIo0_l00007oonc
O`03o`000?ooaGooolEo00GoolEo0_l00008oooNO`03o`000?onogooo_mo00Koo_mo00?o0000olko
Ooo>ogl01oo>ogl00ol0003oR_mooh[oO`08oh[oO`03o`000?moom?oOooC00SoOooC00?o0000ognY
oomoZOl00omoZOl00ol0003oooooooooo`03ooooo`7o00000Oooool001_ooooo00?o0000oooooooo
ool00_ooool00ol0003oOjWoognYo`05ognYo`03o`000?moom?oOooC00SoOooC00?o0000oh[oOon:
ogl02?n:ogl2o`0000Woc_mo00?o0000ookoOoonogl01_onogl00ol0003oomiooooNO`07oooNO`03
o`000?ooaGooolEo00KoolEo00?o0000ooncOooo/gl01_oo/gl00ol0003oojIooonVO`06oonVO`03
o`000?ooWGoooieo00Oooieo00?o0000oonGOoooUgl01oooUgl2o`0000gooi9o1_l0000@oon?O`Ko
00002oooTWl2o`0000SooiMo00?o0000oonMOoooWGl01OooWGl00ol0003oojIooonVO`06oonVO`03
o`000?oo/goook=o00Gook=o00?o0000ooo5OoooaGl01_ooaGl00ol0003oomiooooNO`05oooNO`03
o`000?onogooo_mo00Ooo_mo00?o0000olkoOoo>ogl01oo>ogl00ol0003oR_mooh[oO`07oh[oO`03
o`000?moom?oOooC00WoOooC00?o0000ognYoomoZOl00omoZOl00ol0003oooooooooo`02ooooo`7o
00000Oooool001_ooooo00?o0000ooooooooool00_ooool00ol0003oOjWoognYo`04ognYo`03o`00
0?moom?oOooC00WoOooC00?o0000oh[oOon:ogl01on:ogl2o`0000Woc_mo00?o0000ookoOoonogl0
1_onogl2o`0000Soomio00?o0000ooo5OoooaGl01_ooaGl00ol0003ook=oooncO`06ooncO`03o`00
0?ooYWooojIo00GoojIo0_l00007oonMO`?o00002?ooUgl2o`0000cooi9o0ol0000Loon?O`Co0000
2OooTWl2o`0000OooiMo0_l00006oonMO`;o00001oooYWl00ol0003ook=oooncO`05ooncO`03o`00
0?ooaGooolEo00GoolEo0_l00007oooNO`03o`000?onogooo_mo00Koo_mo0_l00008olkoO`03o`00
0?n:ogooR_mo00SoR_mo00?o0000ogoodomoom<02?moom<00ol0003oOjWoognYo`03ognYo`03o`00
0?oooooooooo00;ooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`03o`000?mo
ZOooOjWo00CoOjWo00?o0000ogoodomoom<02?moom<00ol0003oR_mooh[oO`08oh[oO`03o`000?o>
ogooc_mo00Ooc_mo00?o0000ookoOoonogl01_onogl2o`0000Soomio00?o0000ooo5OoooaGl01_oo
aGl00ol0003ook=oooncO`05ooncO`;o00001oooYWl00ol0003ooieooonMO`06oonMO`03o`000?oo
UgoooiMo00OooiMo0_l0000:oonBO`Co00008oooSgl3o`0000Sooi9o0_l00007oonGO`03o`000?oo
WGoooieo00Gooieo0_l00006oonVO`03o`000?oo/goook=o00Gook=o00?o0000ooo5OoooaGl01Ooo
aGl2o`0000Ooomio00?o0000ookoOoonogl01_onogl00ol0003oc_moolkoO`07olkoO`03o`000?n:
ogooR_mo00OoR_mo0_l0000:ogood`03o`000?moZOooOjWo00;oOjWo00?o0000ooooooooool00_oo
ool1o`00007ooooo000Kooooo`;o00000oooool00ol0003oOjWoognYo`03ognYo`03o`000?moom?o
OooC00WoOooC00?o0000oh[oOon:ogl01on:ogl00ol0003oc_moolkoO`07olkoO`03o`000?onogoo
o_mo00Ooo_mo00?o0000oooNOooogWl01_oogWl00ol0003oolEoooo5O`06ooo5O`03o`000?oo/goo
ok=o00Gook=o0_l00007oonVO`03o`000?ooWGoooieo00Gooieo0_l00008oonGO`;o00002OooTWl3
o`00013oohmo3Ol0000=oon?O`;o00002?ooTWl2o`0000KooiMo0_l00007oonMO`03o`000?ooYWoo
ojIo00CoojIo00?o0000ooncOooo/gl01Ooo/gl00ol0003oolEoooo5O`05ooo5O`03o`000?oogWoo
omio00Koomio00?o0000ookoOoonogl01_onogl00ol0003oc_moolkoO`07olkoO`03o`000?n:ogoo
R_mo00OoR_mo00?o0000ogoodomoom<02?moom<00ol0003oOjWoognYo`02ognYo`04o`000?oooooo
ooooooooo`;o00000Oooool001_ooooo00?o0000ooooooooool00_ooool00ol0003oOjWoognYo`03
ognYo`03o`000?moom?oOooC00SoOooC00?o0000oh[oOon:ogl02?n:ogl00ol0003oc_moolkoO`07
olkoO`03o`000?onogooo_mo00Koo_mo00?o0000oooNOooogWl01_oogWl00ol0003oolEoooo5O`06
ooo5O`03o`000?oo/goook=o00Gook=o0_l00007oonVO`03o`000?ooWGoooieo00Gooieo00?o0000
oonGOoooUgl01_ooUgl2o`0000Wooi9o0_l0000=oon?O`Ko00003OooS7l6o`0000Woohmo1?l00006
oonBO`;o00001_ooUgl00ol0003ooieooonMO`05oonMO`03o`000?ooYWooojIo00CoojIo00?o0000
ooncOooo/gl01Ooo/gl00ol0003oolEoooo5O`05ooo5O`03o`000?oogWooomio00Koomio00?o0000
ookoOoonogl01_onogl00ol0003oc_moolkoO`06olkoO`03o`000?n:ogooR_mo00OoR_mo0_l0000:
ogood`05o`000?moZOooOjWoognYool000001?ooool1o`00007ooooo000Kooooo`03o`000?oooooo
oooo00;ooooo00?o0000ognYoomoZOl00_moZOl00ol0003oOooCogood`08ogood`03o`000?n:ogoo
R_mo00SoR_mo00?o0000olkoOoo>ogl01oo>ogl00ol0003oo_moookoO`06ookoO`03o`000?oogWoo
omio00Koomio0_l00007ooo5O`03o`000?oo/goook=o00Gook=o00?o0000oonVOoooYWl01OooYWl2
o`0000Oooieo00?o0000oonGOoooUgl01_ooUgl2o`0000Oooi9o0ol0000;oon?O`Co00006OooS7l4
o`0000Woohmo0_l00006oonBO`03o`000?ooUgoooiMo00CooiMo0_l00006oonMO`03o`000?ooYWoo
ojIo00CoojIo0_l00006ooncO`03o`000?ooaGooolEo00GoolEo00?o0000oooNOooogWl01OoogWl0
0ol0003oo_moookoO`06ookoO`;o00002?o>ogl00ol0003oR_mooh[oO`07oh[oO`03o`000?moom?o
OooC00SoOooC00Go0000ognYoomoZOooOjWoo`000004ooooo`7o00000Oooool001_ooooo00?o0000
ooooooooool00_ooool00ol0003oOjWoognYo`02ognYo`03o`000?moom?oOooC00SoOooC00?o0000
oh[oOon:ogl01on:ogl00ol0003oc_moolkoO`07olkoO`03o`000?onogooo_mo00Koo_mo00?o0000
oooNOooogWl01_oogWl2o`0000OoolEo00?o0000ooncOooo/gl01Ooo/gl00ol0003oojIooonVO`05
oonVO`;o00001_ooWGl2o`0000KooiMo0ol00007oonBO`;o00002_ooSgl4o`00027oohao0ol00008
oon?O`;o00001OooTWl2o`0000GooiMo0_l00006oonMO`03o`000?ooYWooojIo00CoojIo0_l00006
ooncO`03o`000?ooaGooolEo00GoolEo00?o0000oooNOooogWl01OoogWl00ol0003oo_moookoO`06
ookoO`03o`000?o>ogooc_mo00Ooc_mo00?o0000oh[oOon:ogl01on:ogl00ol0003oOooCogood`08
ogood`04o`000?moZOooOjWoo`0000Cooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02
ooooo`05o`000?moZOooOjWoognYool000002_moom<00ol0003oR_mooh[oO`08oh[oO`03o`000?o>
ogooc_mo00Koc_mo0_l00008ookoO`03o`000?oogWooomio00Goomio0_l00007ooo5O`03o`000?oo
/goook=o00Gook=o00?o0000oonVOoooYWl01OooYWl00ol0003ooieooonMO`05oonMO`03o`000?oo
UgoooiMo00GooiMo00?o0000oonBOoooTWl01_ooTWl2o`0000Woohmo0ol0000Boon<O`Wo00003Ooo
S7l4o`0000Koohmo0_l00005oonBO`;o00001OooUgl2o`0000Gooieo0_l00005oonVO`;o00001Ooo
/gl2o`0000OoolEo00?o0000oooNOooogWl01OoogWl00ol0003oo_moookoO`06ookoO`03o`000?o>
ogooc_mo00Koc_mo00?o0000oh[oOon:ogl02?n:ogl00ol0003oOooCogood`08ogood`03o`000?mo
ZOoo000000Cooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`04o`000?moZOoo
OjWoo`0000_oOooC00?o0000oh[oOon:ogl01on:ogl00ol0003oc_moolkoO`07olkoO`03o`000?on
ogooo_mo00Koo_mo00?o0000oooNOooogWl01_oogWl00ol0003oolEoooo5O`05ooo5O`03o`000?oo
/goook=o00Gook=o00?o0000oonVOoooYWl01OooYWl00ol0003ooieooonMO`04oonMO`;o00001_oo
Ugl2o`0000Oooi9o0ol00008oon?O`;o00003_ooS7l7o`0000Wooh]o1ol0000:oon<O`;o00001_oo
Sgl2o`0000Cooi9o0_l00006oonGO`03o`000?ooWGoooieo00Cooieo00?o0000oonVOoooYWl00ooo
YWl2o`0000Gook=o0_l00007ooo5O`03o`000?oogWooomio00Goomio00?o0000ookoOoonogl01_on
ogl00ol0003oc_moolkoO`06olkoO`03o`000?n:ogooR_mo00OoR_mo00?o0000ogoodomoom<02?mo
om<00ol0003oOjWoo`000004ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool0
1?l0003oOjWoognYool0000:ogood`03o`000?n:ogooR_mo00OoR_mo00?o0000olkoOoo>ogl01oo>
ogl00ol0003oo_moookoO`06ookoO`03o`000?oogWooomio00Koomio00?o0000ooo5OoooaGl01Ooo
aGl00ol0003ook=oooncO`05ooncO`03o`000?ooYWooojIo00CoojIo0_l00006oonMO`;o00001_oo
Ugl00ol0003ooi9ooonBO`06oonBO`;o00002?ooSgl2o`0000coohao1?l0000Goon;O`Co00002?oo
S7l2o`0000Goohmo0_l00005oonBO`;o00001OooUgl00ol0003ooieooonMO`04oonMO`03o`000?oo
YWooojIo00?oojIo0_l00006ooncO`03o`000?ooaGooolEo00CoolEo0_l00006oooNO`;o00001oon
ogl00ol0003oc_moolkoO`07olkoO`03o`000?n:ogooR_mo00OoR_mo00?o0000ogoodomoom<02?mo
om<2o`0000Cooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`03o`000?moZOoo
000000[oOooC0_l00009oh[oO`03o`000?o>ogooc_mo00Koc_mo0_l00007ookoO`03o`000?oogWoo
omio00Koomio00?o0000ooo5OoooaGl01OooaGl00ol0003ook=oooncO`05ooncO`03o`000?ooYWoo
ojIo00CoojIo0_l00006oonMO`;o00001_ooUgl00ol0003ooi9ooonBO`05oonBO`;o00002?ooSgl2
o`0000_oohao1?l0000Noon;O`Co00001_ooS7l2o`0000Goohmo0_l00004oonBO`;o00001OooUgl2
o`0000Gooieo00?o0000oonVOoooYWl00oooYWl2o`0000Kook=o00?o0000ooo5OoooaGl01?ooaGl0
0ol0003oomiooooNO`05oooNO`03o`000?onogooo_mo00Koo_mo00?o0000olkoOoo>ogl01_o>ogl0
0ol0003oR_mooh[oO`07oh[oO`03o`000?moom?oOooC00SoOooC0_l00004ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_ooool3o`0000[oOooC00?o0000oh[oOon:ogl01on:ogl00ol0
003oc_moolkoO`07olkoO`03o`000?onogooo_mo00Koo_mo00?o0000oooNOooogWl01OoogWl00ol0
003oolEoooo5O`05ooo5O`;o00001_oo/gl00ol0003oojIooonVO`04oonVO`;o00001_ooWGl00ol0
003ooiMooonGO`04oonGO`;o00001_ooTWl3o`0000Ooohmo0_l0000;oon<O`?o00009?ooRgl4o`00
00Goohao0_l00005oon?O`;o00001?ooTWl2o`0000GooiMo00?o0000oonMOoooWGl00oooWGl00ol0
003oojIooonVO`03oonVO`;o00001_oo/gl00ol0003oolEoooo5O`04ooo5O`03o`000?oogWooomio
00Goomio00?o0000ookoOoonogl01_onogl00ol0003oc_moolkoO`06olkoO`03o`000?n:ogooR_mo
00OoR_mo00?o0000ogoodomoom<01omoom<2o`0000Cooooo0Ol00001ooooo`006oooool00ol0003o
ooooooooo`02ooooo`;o00002omoom<00ol0003oR_mooh[oO`07oh[oO`03o`000?o>ogooc_mo00Oo
c_mo00?o0000ookoOoonogl01Oonogl00ol0003oomiooooNO`05oooNO`03o`000?ooaGooolEo00Ko
olEo00?o0000ooncOooo/gl01?oo/gl00ol0003oojIooonVO`04oonVO`03o`000?ooWGoooieo00Go
oieo00?o0000oonGOoooUgl01?ooUgl00ol0003ooi9ooonBO`06oonBO`03o`000?ooSgooohmo00Ko
ohmo00?o0000oon<OoooS7l02?ooS7l3o`0001;ooh]o3ol0000:oon;O`;o00001OooS7l2o`0000Co
ohmo0_l00004oonBO`03o`000?ooUgoooiMo00CooiMo00?o0000oonMOoooWGl00oooWGl00ol0003o
ojIooonVO`03oonVO`03o`000?oo/goook=o00Cook=o00?o0000ooo5OoooaGl01?ooaGl00ol0003o
omiooooNO`05oooNO`03o`000?onogooo_mo00Koo_mo00?o0000olkoOoo>ogl01_o>ogl00ol0003o
R_mooh[oO`07oh[oO`03o`000?moom?oOooC00OoOooC0_l00004ooooo`7o00000Oooool001_ooooo
00?o0000ooooooooool00_ooool2o`0000[oOooC00?o0000oh[oOon:ogl01on:ogl2o`0000Soc_mo
00?o0000ookoOoonogl01_onogl00ol0003oomiooooNO`05oooNO`03o`000?ooaGooolEo00GoolEo
00?o0000ooncOooo/gl01?oo/gl2o`0000GoojIo0_l00006oonMO`03o`000?ooUgoooiMo00CooiMo
0_l00005oonBO`?o00001oooSgl2o`0000[oohao0_l0000Aoon;O`Co00003_ooRGl5o`0000Kooh]o
0ol00004oon<O`?o00000oooSgl2o`0000Cooi9o0ol00003oonGO`;o00001?ooWGl2o`0000GoojIo
00?o0000ooncOooo/gl01?oo/gl00ol0003oolEoooo5O`04ooo5O`03o`000?oogWooomio00Goomio
00?o0000ookoOoonogl01Oonogl2o`0000Soc_mo00?o0000oh[oOon:ogl01_n:ogl2o`0000SoOooC
0_l00004ooooo`7o00000Oooool001Cooooo0_l00005ooooo`03o`000?oooooooooo00;ooooo0_l0
000:ogood`03o`000?n:ogooR_mo00OoR_mo00?o0000olkoOoo>ogl01_o>ogl00ol0003oo_moooko
O`06ookoO`03o`000?oogWooomio00Goomio00?o0000ooo5OoooaGl01OooaGl00ol0003ook=ooonc
O`04ooncO`;o00001OooYWl2o`0000Kooieo00?o0000oonGOoooUgl01?ooUgl00ol0003ooi9ooonB
O`04oonBO`;o00001oooSgl2o`0000[oohao0_l0000Aoon;O`;o00005oooRGl3o`0000Kooh]o0_l0
0004oon<O`;o00001?ooSgl00ol0003ooi9ooonBO`03oonBO`;o00000oooUgl2o`0000Cooieo0_l0
0005oonVO`03o`000?oo/goook=o00Cook=o00?o0000ooo5OoooaGl01?ooaGl00ol0003oomiooooN
O`05oooNO`03o`000?onogooo_mo00Goo_mo00?o0000olkoOoo>ogl01_o>ogl00ol0003oR_mooh[o
O`07oh[oO`03o`000?moom?oOooC00KoOooC0_l00004ooooo`7o00000Oooool001?ooooo00Co0000
oooooooooooo00001?ooool00ol0003oooooooooo`02ooooo`;o00002Omoom<00ol0003oR_mooh[o
O`07oh[oO`03o`000?o>ogooc_mo00Ooc_mo00?o0000ookoOoonogl01Oonogl00ol0003oomiooooN
O`05oooNO`;o00001_ooaGl00ol0003ook=oooncO`05ooncO`03o`000?ooYWooojIo00?oojIo0_l0
0006oonMO`03o`000?ooUgoooiMo00CooiMo00?o0000oonBOoooTWl01?ooTWl2o`0000Ooohmo00?o
0000oon<OoooS7l02OooS7l2o`00017ooh]o0_l0000Koon9O`Co00001?ooRgl2o`0000Coohao0_l0
0003oon?O`;o00001?ooTWl2o`0000CooiMo00?o0000oonMOoooWGl00oooWGl00ol0003oojIooonV
O`03oonVO`03o`000?oo/goook=o00?ook=o0_l00006ooo5O`03o`000?oogWooomio00Coomio00?o
0000ookoOoonogl01_onogl00ol0003oc_moolkoO`06olkoO`03o`000?n:ogooR_mo00OoR_mo00?o
0000ogoodomoom<01Omoom<2o`0000Cooooo0Ol00001ooooo`004oooool01?l0003oooooooooool0
0004ooooo`?o00000_ooool2o`0000WoOooC00?o0000oh[oOon:ogl01on:ogl00ol0003oc_moolko
O`06olkoO`03o`000?onogooo_mo00Koo_mo00?o0000oooNOooogWl01?oogWl2o`0000OoolEo00?o
0000ooncOooo/gl00ooo/gl2o`0000GoojIo0_l00006oonMO`03o`000?ooUgoooiMo00?ooiMo0_l0
0005oonBO`;o00002?ooSgl00ol0003oohaooon<O`08oon<O`;o00004oooRgl00ol0003oohUooon9
O`0Moon9O`?o00001?ooRgl2o`0000Coohao00?o0000oon?Ool000000_ooSgl00ol0003ooi9ooonB
O`02oonBO`;o00001?ooUgl00ol0003ooieooonMO`03oonMO`03o`000?ooYWooojIo00?oojIo00?o
0000ooncOooo/gl00ooo/gl2o`0000GoolEo00?o0000oooNOooogWl01OoogWl2o`0000Koo_mo0_l0
0007olkoO`03o`000?n:ogooR_mo00OoR_mo00?o0000ogoodomoom<01Omoom<2o`0000?ooooo0_l0
0001ooooo`004oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00;ooooo0_l0
0008ogood`03o`000?n:ogooR_mo00OoR_mo00?o0000olkoOoo>ogl01_o>ogl00ol0003oo_moooko
O`06ookoO`03o`000?oogWooomio00Goomio00?o0000ooo5OoooaGl01OooaGl00ol0003ook=ooonc
O`04ooncO`03o`000?ooYWooojIo00?oojIo0_l00006oonMO`03o`000?ooUgoooiMo00?ooiMo0_l0
0005oonBO`;o00001oooSgl2o`0000[oohao0_l0000Doon;O`03o`000?ooRGooohUo023oohUo0_l0
0004oon;O`;o00000oooS7l2o`0000?oohmo0_l00004oonBO`03o`000?ooUgoooiMo00;ooiMo00?o
0000oonMOoooWGl00oooWGl00ol0003oojIooonVO`03oonVO`03o`000?oo/goook=o00?ook=o00?o
0000ooo5OoooaGl01?ooaGl00ol0003oomiooooNO`05oooNO`03o`000?onogooo_mo00Goo_mo00?o
0000olkoOoo>ogl01_o>ogl00ol0003oR_mooh[oO`07oh[oO`03o`000?moom?oOooC00CoOooC0_l0
0004ooooo`7o00000Oooool001?ooooo00Co0000oooooooooooo00001?ooool00ol0003ooooooooo
o`02ooooo`;o00002?moom<00ol0003oR_mooh[oO`06oh[oO`03o`000?o>ogooc_mo00Koc_mo0_l0
0007ookoO`03o`000?oogWooomio00Goomio00?o0000ooo5OoooaGl01OooaGl00ol0003ook=ooonc
O`04ooncO`03o`000?ooYWooojIo00?oojIo0_l00005oonMO`;o00001OooUgl00ol0003ooi9ooonB
O`04oonBO`;o00001oooSgl00ol0003oohaooon<O`09oon<O`;o00005_ooRgl00ol0003oohUooon9
O`0@oon9O`_o00001_ooRGl2o`0000Cooh]o00?o0000oon<OoooS7l00_ooS7l00ol0003oohmooon?
O`02oon?O`;o00000oooTWl00ol0003ooiMooonGO`02oonGO`03o`000?ooWGoooieo00?ooieo00?o
0000oonVOoooYWl00oooYWl00ol0003ook=oooncO`03ooncO`03o`000?ooaGooolEo00CoolEo00?o
0000oooNOooogWl01OoogWl00ol0003oo_moookoO`05ookoO`03o`000?o>ogooc_mo00Koc_mo00?o
0000oh[oOon:ogl01_n:ogl00ol0003oOooCogood`04ogood`;o00001?ooool1o`00007ooooo000C
ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool00_ooool2o`0000OoOooC00?o
0000oh[oOon:ogl01on:ogl00ol0003oc_moolkoO`06olkoO`03o`000?onogooo_mo00Koo_mo00?o
0000oooNOooogWl01?oogWl2o`0000GoolEo0_l00006ooncO`03o`000?ooYWooojIo00CoojIo00?o
0000oonMOoooWGl00oooWGl2o`0000GooiMo00?o0000oonBOoooTWl01?ooTWl00ol0003oohmooon?
O`05oon?O`;o00003?ooS7l00ol0003ooh]ooon;O`0Foon;O`;o00004?ooRGl00ol0003oohQooon8
O`08oon8O`?o00001OooRGl2o`0000?ooh]o0_l00003oon<O`03o`000?ooSgooohmo00;oohmo0_l0
0003oonBO`03o`000?ooUgoooiMo00;ooiMo00?o0000oonMOoooWGl00_ooWGl2o`0000GoojIo00?o
0000ooncOooo/gl00ooo/gl00ol0003oolEoooo5O`04ooo5O`03o`000?oogWooomio00Coomio0_l0
0006ookoO`03o`000?o>ogooc_mo00Koc_mo00?o0000oh[oOon:ogl01on:ogl00ol0003oOooCogoo
d`04ogood`03o`000?oooooooooo00;ooooo0Ol00001ooooo`005?ooool2o`0000Gooooo00?o0000
ooooooooool00_ooool2o`0000KoOooC0_l00008oh[oO`03o`000?o>ogooc_mo00Koc_mo00?o0000
ookoOoonogl01_onogl00ol0003oomiooooNO`05oooNO`03o`000?ooaGooolEo00CoolEo00?o0000
ooncOooo/gl01?oo/gl00ol0003oojIooonVO`04oonVO`03o`000?ooWGoooieo00?ooieo0_l00005
oonGO`03o`000?ooTWoooi9o00Cooi9o00?o0000oon?OoooSgl01OooSgl00ol0003oohaooon<O`0;
oon<O`03o`000?ooRgoooh]o01Wooh]o0_l0000>oon9O`03o`000?ooR7ooohQo00_oohQo0ol00004
oon9O`;o00000oooRgl01?l0003oohaooon<OoooS7l3o`0000;oohmo0_l00003oonBO`03o`000?oo
UgoooiMo00;ooiMo00?o0000oonMOoooWGl00_ooWGl2o`0000CoojIo0_l00005ooncO`03o`000?oo
aGooolEo00?oolEo0_l00006oooNO`03o`000?onogooo_mo00Goo_mo00?o0000olkoOoo>ogl01_o>
ogl00ol0003oR_mooh[oO`06oh[oO`03o`000?moom?oOooC00CoOooC00?o0000ooooooooool00_oo
ool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo0_l00006ogood`03o`000?n:ogoo
R_mo00OoR_mo00?o0000olkoOoo>ogl01_o>ogl00ol0003oo_moookoO`05ookoO`03o`000?oogWoo
omio00Goomio00?o0000ooo5OoooaGl01?ooaGl00ol0003ook=oooncO`04ooncO`03o`000?ooYWoo
ojIo00CoojIo00?o0000oonMOoooWGl00oooWGl2o`0000GooiMo00?o0000oonBOoooTWl01?ooTWl0
0ol0003oohmooon?O`04oon?O`;o00003_ooS7l00ol0003ooh]ooon;O`0Koon;O`?o00003?ooRGl0
0ol0003oohQooon8O`0=oon8O`;o00001?ooRGl01?l0003ooh]ooon;OoooRgl2o`0000?oohao0_l0
0003oon?O`05o`000?ooTWoooi9ooonBOol000001?ooUgl00ol0003ooieooonMO`02oonMO`;o0000
1?ooYWl2o`0000Gook=o00?o0000ooo5OoooaGl00oooaGl00ol0003oomiooooNO`05oooNO`03o`00
0?onogooo_mo00Goo_mo00?o0000olkoOoo>ogl01Oo>ogl00ol0003oR_mooh[oO`07oh[oO`03o`00
0?moom?oOooC00?oOooC00?o0000ooooooooool00_ooool1o`00007ooooo000Kooooo`03o`000?oo
oooooooo00;ooooo0_l00005ogood`03o`000?n:ogooR_mo00OoR_mo00?o0000olkoOoo>ogl01_o>
ogl00ol0003oo_moookoO`05ookoO`;o00001_oogWl00ol0003oolEoooo5O`04ooo5O`;o00001Ooo
/gl2o`0000GoojIo00?o0000oonMOoooWGl00oooWGl2o`0000GooiMo00?o0000oonBOoooTWl01?oo
TWl00ol0003oohmooon?O`04oon?O`;o00004?ooS7l2o`0001kooh]o0ol00009oon9O`;o00004?oo
R7l2o`0000?oohUo0_l00003oon;O`03o`000?ooS7ooohao00;oohao00Go0000oon?OoooSgooohmo
o`000003oonBO`03o`000?ooUgoooiMo00;ooiMo00?o0000oonMOoooWGl00_ooWGl2o`0000CoojIo
00?o0000ooncOooo/gl00ooo/gl00ol0003oolEoooo5O`04ooo5O`03o`000?oogWooomio00Coomio
00?o0000ookoOoonogl01Oonogl00ol0003oc_moolkoO`06olkoO`03o`000?n:ogooR_mo00KoR_mo
00?o0000ogoodomoom<00omoom<00ol0003oooooooooo`02ooooo`7o00000Oooool001_ooooo00?o
0000ooooooooool00_ooool2o`0000GoOooC00?o0000oh[oOon:ogl01_n:ogl00ol0003oc_moolko
O`06olkoO`03o`000?onogooo_mo00Koo_mo00?o0000oooNOooogWl01?oogWl00ol0003oolEoooo5
O`04ooo5O`;o00001Ooo/gl2o`0000GoojIo00?o0000oonMOoooWGl00oooWGl2o`0000GooiMo00?o
0000oonBOoooTWl00oooTWl2o`0000Koohmo0_l0000Coon<O`ko00004oooRgl2o`0000WoohUo00?o
0000oon8OoooR7l03oooR7l2o`0000?oohUo00Co0000oon;OoooRgoooh]o0_l00003oon<O`05o`00
0?ooSgooohmooon?Ool000000oooTWl2o`0000?ooiMo00?o0000oonMOoooWGl00_ooWGl2o`0000Co
ojIo00?o0000ooncOooo/gl00ooo/gl00ol0003oolEoooo5O`04ooo5O`03o`000?oogWooomio00Co
omio00?o0000ookoOoonogl01Oonogl00ol0003oc_moolkoO`05olkoO`;o00002?n:ogl00ol0003o
OooCogood`02ogood`03o`000?oooooooooo00;ooooo0Ol00001ooooo`006oooool00ol0003ooooo
ooooo`02ooooo`;o00001?moom<00ol0003oR_mooh[oO`07oh[oO`03o`000?o>ogooc_mo00Koc_mo
00?o0000ookoOoonogl01Oonogl00ol0003oomiooooNO`05oooNO`03o`000?ooaGooolEo00CoolEo
00?o0000ooncOooo/gl01?oo/gl00ol0003oojIooonVO`03oonVO`03o`000?ooWGoooieo00?ooieo
00?o0000oonGOoooUgl00oooUgl2o`0000Gooi9o00?o0000oon?OoooSgl01OooSgl00ol0003oohao
oon<O`0Qoon<O`So00003OooRgl2o`0000SoohUo00?o0000oon8OoooR7l04?ooR7l2o`0000;oohUo
0_l00003oon;O`;o00000_ooS7l01Ol0003oohmooon?OoooSgoo000000?ooi9o0_l00003oonGO`;o
00000oooWGl2o`0000CoojIo00?o0000ooncOooo/gl00ooo/gl00ol0003oolEoooo5O`03ooo5O`;o
00001_oogWl00ol0003oo_moookoO`05ookoO`03o`000?o>ogooc_mo00Goc_mo00?o0000oh[oOon:
ogl01on:ogl01Ol0003oOooCogoodomoom?o000000Cooooo0Ol00001ooooo`006oooool00ol0003o
ooooooooo`02ooooo`;o00001?moom<00ol0003oR_mooh[oO`06oh[oO`03o`000?o>ogooc_mo00Ko
c_mo00?o0000ookoOoonogl01Oonogl2o`0000Koomio00?o0000ooo5OoooaGl01?ooaGl00ol0003o
ok=oooncO`04ooncO`03o`000?ooYWooojIo00?oojIo00?o0000oonMOoooWGl00oooWGl00ol0003o
oiMooonGO`03oonGO`03o`000?ooTWoooi9o00Cooi9o00?o0000oon?OoooSgl01OooSgl00ol0003o
ohaooon<O`0Zoon<O`Go00002_ooRgl3o`0000KoohUo0_l0000Boon8O`04o`000?ooRGooohUooon9
O`;o00000oooRgl00ol0003oohaooon<O`02o`0000;oohmo00Co0000oonBOoooTWoooi9o0_l00003
oonGO`03o`000?ooWGoooieo00;ooieo0_l00004oonVO`03o`000?oo/goook=o00?ook=o00?o0000
ooo5OoooaGl00oooaGl00ol0003oomiooooNO`04oooNO`03o`000?onogooo_mo00Goo_mo00?o0000
olkoOoo>ogl01_o>ogl00ol0003oR_mooh[oO`06oh[oO`05o`000?moom?oOooCogoodol000001?oo
ool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo0_l00003ogood`03o`000?n:ogoo
R_mo00OoR_mo00?o0000olkoOoo>ogl01_o>ogl00ol0003oo_moookoO`05ookoO`03o`000?oogWoo
omio00Coomio00?o0000ooo5OoooaGl01?ooaGl00ol0003ook=oooncO`04ooncO`03o`000?ooYWoo
ojIo00?oojIo00?o0000oonMOoooWGl00oooWGl00ol0003ooiMooonGO`03oonGO`03o`000?ooTWoo
oi9o00Cooi9o00?o0000oon?OoooSgl01OooSgl00ol0003oohaooon<O`0`oon<O`Co00002OooRgl2
o`0000KoohUo0_l00008oon8O`Go00001?ooR7l2o`0000;oohUo0ol00002oon;O`05o`000?ooS7oo
ohaooon<Ool000000_ooSgl2o`0000;ooi9o0_l00003oonGO`03o`000?ooWGoooieo00;ooieo00?o
0000oonVOoooYWl00oooYWl00ol0003ook=oooncO`02ooncO`;o00001OooaGl00ol0003oomiooooN
O`04oooNO`03o`000?onogooo_mo00Goo_mo00?o0000olkoOoo>ogl01Oo>ogl00ol0003oR_mooh[o
O`07oh[oO`04o`000?moom?oOooCo`0000Cooooo0Ol00001ooooo`006oooool00ol0003ooooooooo
o`02ooooo`;o00000omoom<00ol0003oR_mooh[oO`06oh[oO`03o`000?o>ogooc_mo00Koc_mo00?o
0000ookoOoonogl01Oonogl00ol0003oomiooooNO`05oooNO`03o`000?ooaGooolEo00CoolEo00?o
0000ooncOooo/gl00ooo/gl2o`0000CoojIo0_l00004oonMO`03o`000?ooUgoooiMo00?ooiMo00?o
0000oonBOoooTWl01?ooTWl00ol0003oohmooon?O`05oon?O`03o`000?ooS7ooohao03Goohao1?l0
0007oon;O`;o00001OooRGl2o`0000OoohQo00?o0000oon8OoooR7l00_ooR7l2o`0000CoohQo0_l0
0003oon9O`04o`000?ooRgoooh]oo`0000?oohao00?o0000oon?OoooSgl00_l00002oonBO`;o0000
0oooUgl00ol0003ooieooonMO`02oonMO`03o`000?ooYWooojIo00;oojIo00?o0000ooncOooo/gl0
0ooo/gl00ol0003oolEoooo5O`04ooo5O`03o`000?oogWooomio00Coomio00?o0000ookoOoonogl0
1?onogl00ol0003oc_moolkoO`06olkoO`03o`000?n:ogooR_mo00KoR_mo00Co0000ogoodomoom?o
00001?ooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo0_l00002ogood`03o`00
0?n:ogooR_mo00OoR_mo00?o0000olkoOoo>ogl01Oo>ogl00ol0003oo_moookoO`05ookoO`;o0000
1_oogWl00ol0003oolEoooo5O`04ooo5O`03o`000?oo/goook=o00?ook=o00?o0000oonVOoooYWl0
0oooYWl2o`0000Cooieo0_l00004oonGO`03o`000?ooTWoooi9o00Cooi9o00?o0000oon?OoooSgl0
1OooSgl2o`0002Goohao0_l0000Doon<O`;o00001oooRgl2o`0000GoohUo0_l00005oon8O`03o`00
0?ooR7ooohQo00CoohQo0_l00003oon8O`?o00000_ooRGl01?l0003ooh]ooon;Ool00003oon<O`03
o`000?ooSgooohmo00;o00000_ooTWl2o`0000?ooiMo00?o0000oonMOoooWGl00_ooWGl00ol0003o
ojIooonVO`02oonVO`03o`000?oo/goook=o00?ook=o00?o0000ooo5OoooaGl00oooaGl2o`0000Go
omio00?o0000ookoOoonogl01Oonogl00ol0003oc_moolkoO`06olkoO`03o`000?n:ogooR_mo00Ko
R_mo00?o0000ogoodol000001?ooool1o`00007ooooo000Kooooo`;o00000oooool2o`0000;oOooC
00?o0000oh[oOon:ogl01_n:ogl00ol0003oc_moolkoO`06olkoO`03o`000?onogooo_mo00Goo_mo
00?o0000oooNOooogWl01?oogWl00ol0003oolEoooo5O`04ooo5O`03o`000?oo/goook=o00?ook=o
00?o0000oonVOoooYWl01?ooYWl00ol0003ooieooonMO`02oonMO`;o00001?ooUgl00ol0003ooi9o
oonBO`04oonBO`;o00001_ooSgl2o`0001[oohao3?l00002oon?O`[o00003?ooS7l3o`0000Kooh]o
0_l00005oon9O`03o`000?ooR7ooohQo00?oohQo00?o0000oon8OoooR7l01OooR7l3o`0000?oohQo
00Co0000oon9OoooRGoo00000_ooRgl2o`0000;oohao00?o0000oon?OoooSgl00_l00002oonBO`;o
00000oooUgl00ol0003ooieooonMO`02oonMO`03o`000?ooYWooojIo00;oojIo00?o0000ooncOooo
/gl00ooo/gl00ol0003oolEoooo5O`03ooo5O`03o`000?oogWooomio00Coomio00?o0000ookoOoon
ogl01Oonogl00ol0003oc_moolkoO`05olkoO`03o`000?n:ogooR_mo00KoR_mo0ol00003ooooo`;o
00000Oooool001_ooooo00?o0000ooooooooool00_ooool2o`000003ogoodol0003oR_mo00OoR_mo
0_l00007olkoO`03o`000?onogooo_mo00Goo_mo00?o0000oooNOooogWl01?oogWl2o`0000GoolEo
00?o0000ooncOooo/gl01?oo/gl00ol0003oojIooonVO`03oonVO`03o`000?ooWGoooieo00?ooieo
00?o0000oonGOoooUgl00_ooUgl00ol0003ooi9ooonBO`04oonBO`;o00001oooSgl00ol0003oohao
oon<O`0Doon<O`Go00006?ooSgl6o`0000Woohao0_l00005oon;O`?o00001?ooRGl2o`0000CoohQo
00?o0000oon8OoooR7l01_ooR7l2o`0000?oohQo00?o0000oon9OoooRGl00_l00002oon;O`04o`00
0?ooS7ooohaoo`0000;oohmo0_l00002oonBO`;o00000oooUgl00ol0003ooieooonMO`02oonMO`03
o`000?ooYWooojIo00;oojIo00?o0000ooncOooo/gl00_oo/gl2o`0000GoolEo00?o0000oooNOooo
gWl01?oogWl00ol0003oo_moookoO`04ookoO`03o`000?o>ogooc_mo00Koc_mo00?o0000oh[oOon:
ogl01_n:ogl2o`0000Cooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`?o0000
2On:ogl00ol0003oc_moolkoO`05olkoO`03o`000?onogooo_mo00Goo_mo00?o0000oooNOooogWl0
1OoogWl00ol0003oolEoooo5O`03ooo5O`;o00001Ooo/gl00ol0003oojIooonVO`03oonVO`03o`00
0?ooWGoooieo00?ooieo00?o0000oonGOoooUgl00oooUgl00ol0003ooi9ooonBO`03oonBO`;o0000
1oooSgl00ol0003oohaooon<O`0Aoon<O`Co00008oooSgl4o`0000Ooohao0ol00004oon;O`?o0000
1?ooRGl00ol0003oohQooon8O`02oon8O`03o`000?ooR7ooohQo00OoohQo0_l00002oon8O`;o0000
0_ooRGl01?l0003ooh]ooon;Ool00002oon<O`03o`000?ooSgooohmo00;o00000_ooTWl2o`0000?o
oiMo00?o0000oonMOoooWGl00_ooWGl01?l0003oojIooonVOoooYWl2o`0000Cook=o0_l00005ooo5
O`03o`000?oogWooomio00?oomio00?o0000ookoOoonogl01Oonogl00ol0003oc_moolkoO`05olko
O`03o`000?n:ogooR_mo00KoR_mo0_l00004ooooo`7o00000Oooool001_ooooo00?o0000oooooooo
ool00_ooool3o`0000SoR_mo0_l00007olkoO`03o`000?onogooo_mo00Goo_mo00?o0000oooNOooo
gWl01?oogWl00ol0003oolEoooo5O`04ooo5O`03o`000?oo/goook=o00?ook=o00?o0000oonVOooo
YWl00oooYWl2o`0000Cooieo00?o0000oonGOoooUgl00oooUgl00ol0003ooi9ooonBO`03oonBO`03
o`000?ooSgooohmo00Koohmo00?o0000oon<OoooS7l03_ooS7l4o`0002_oohmo0ol00006oon<O`?o
00001OooRgl00ol0003oohUooon9O`02oon9O`03o`000?ooR7ooohQo00;oohQo00?o0000oon8Oooo
R7l02?ooR7l2o`0000;oohQo00Co0000oon9OoooRGoo00000_ooRgl00ol0003oohaooon<O`02o`00
0003oon?Ool0003o000000;ooi9o0_l00003oonGO`05o`000?ooWGoooieooonMOol000001?ooYWl2
o`0000Cook=o00?o0000ooo5OoooaGl00oooaGl00ol0003oomiooooNO`04oooNO`03o`000?onogoo
o_mo00Coo_mo0_l00007olkoO`03o`000?n:ogooR_mo00GoR_mo0_l00004ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_ooool00onoOooo0000o`000008oh[oO`03o`000?o>ogooc_mo
00Goc_mo00?o0000ookoOoonogl01Oonogl00ol0003oomiooooNO`04oooNO`;o00001OooaGl00ol0
003ook=oooncO`03ooncO`;o00001?ooYWl2o`0000Cooieo00?o0000oonGOoooUgl00oooUgl00ol0
003ooi9ooonBO`03oonBO`03o`000?ooSgooohmo00Koohmo0_l0000=oon<O`Co00004oooSgl@o`00
00koohmo0ol00005oon<O`?o00001?ooRgl2o`0000?oohUo0_l00003oon8O`03o`000?ooR7ooohQo
00WoohQo00Co0000oon8OoooR7oo00000_ooRGl01?l0003ooh]ooon;Ool00002oon<O`;o000000?o
ohmoo`000?l000000oooTWl01Ol0003ooiMooonGOoooUgoo000000?ooieo00?o0000oonVOoooYWl0
0_ooYWl00ol0003ook=oooncO`02ooncO`;o00001OooaGl00ol0003oomiooooNO`04oooNO`03o`00
0?onogooo_mo00Coo_mo00?o0000olkoOoo>ogl01Oo>ogl00ol0003oR_mooh[oO`04oh[oO`;o0000
1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo00?o_gooo`000?l000002?n:
ogl00ol0003oc_moolkoO`05olkoO`03o`000?onogooo_mo00Goo_mo00?o0000oooNOooogWl01?oo
gWl00ol0003oolEoooo5O`04ooo5O`03o`000?oo/goook=o00?ook=o00?o0000oonVOoooYWl00ooo
YWl00ol0003ooieooonMO`03oonMO`03o`000?ooUgoooiMo00;ooiMo00?o0000oonBOoooTWl00ooo
TWl00ol0003oohmooon?O`07oon?O`03o`000?ooS7ooohao00Woohao0ol0000@oon?O`So00003_oo
TWl7o`0000_oohmo0_l00005oon<O`;o00001OooRgl2o`0000?oohUo00Go0000oon8OoooR7ooohQo
o`00000;oon8O`04o`000?ooR7ooohQoo`0000;oohUo00Co0000oon;OoooRgoo00000_ooS7l01?l0
003oohmooon?Ool00004oonBO`04o`000?ooUgoooiMoo`0000Cooieo00Go0000oonVOoooYWooojIo
o`000005ooncO`03o`000?ooaGooolEo00?oolEo00?o0000oooNOooogWl01?oogWl00ol0003oo_mo
ookoO`04ookoO`03o`000?o>ogooc_mo00Koc_mo00?o0000oh[oOon:ogl00on:ogl2o`0000Gooooo
0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`03okmoool0003o000000OoR_mo00?o
0000olkoOoo>ogl01_o>ogl00ol0003oo_moookoO`04ookoO`03o`000?oogWooomio00Goomio00?o
0000ooo5OoooaGl00oooaGl00ol0003ook=oooncO`03ooncO`03o`000?ooYWooojIo00?oojIo00?o
0000oonMOoooWGl00oooWGl00ol0003ooiMooonGO`02oonGO`;o00001?ooTWl2o`0000Woohmo00?o
0000oon<OoooS7l01_ooS7l3o`0000ooohmo1Ol0000LoonBO`Co00002OooSgl2o`0000Goohao0ol0
0003oon;O`;o00000_ooRGl2o`0000?oohQo00?o0000oon8OoooR7l02OooR7l2o`000005oon8Ool0
003oohUooon9Ool000000_ooRgl01?l0003oohaooon<Ool00002oon?O`05o`000?ooTWoooi9ooonB
Ool000000oooUgl01Ol0003ooieooonMOoooWGoo000000CoojIo00?o0000ooncOooo/gl00ooo/gl0
0ol0003oolEoooo5O`03ooo5O`03o`000?oogWooomio00?oomio00?o0000ookoOoonogl01Oonogl0
0ol0003oc_moolkoO`05olkoO`03o`000?n:ogooR_mo00?oR_mo0_l00005ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_ooool00onoOooo0000o`000007oh[oO`03o`000?o>ogooc_mo
00Goc_mo00?o0000ookoOoonogl01?onogl2o`0000Koomio00?o0000ooo5OoooaGl01?ooaGl00ol0
003ook=oooncO`02ooncO`;o00001?ooYWl2o`0000Cooieo00?o0000oonGOoooUgl00oooUgl00ol0
003ooi9ooonBO`03oonBO`03o`000?ooSgooohmo00Ooohmo00?o0000oon<OoooS7l01?ooS7l3o`00
00ooohmo1?l0000ToonBO`Co00001oooSgl2o`0000Goohao0ol00002oon;O`?o00000_ooRGl01Ol0
003oohQooon8OoooR7oo000000KoohQo0ol00002oon8O`;o000000GoohQoo`000?l0003oohUoo`00
0002oon;O`04o`000?ooS7ooohaoo`0000;oohmo00Go0000oonBOoooTWoooi9oo`000003oonGO`05
o`000?ooWGoooieooonMOol000001?ooYWl00ol0003ook=oooncO`02ooncO`;o00001?ooaGl2o`00
00Goomio00?o0000ookoOoonogl01?onogl00ol0003oc_moolkoO`05olkoO`;o00001?n:ogl2o`00
00Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`03okmoool0003o000000Ko
R_mo00?o0000olkoOoo>ogl01Oo>ogl00ol0003oo_moookoO`05ookoO`03o`000?oogWooomio00Co
omio00?o0000ooo5OoooaGl01?ooaGl00ol0003ook=oooncO`03ooncO`03o`000?ooYWooojIo00;o
ojIo0_l00004oonMO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonBOoooTWl00oooTWl00ol0003o
ohmooon?O`08oon?O`04o`000?ooS7ooohaooon<O`?o00003oooSgl3o`0002cooi9o0ol00006oon?
O`;o00001OooS7l2o`0000?ooh]o0_l00002oon9O`05o`000?ooR7ooohQooon8Ool000001?ooR7l0
0ol0003oogmooomoO`02o`0000;oohQo0_l000001OooR7oo0000o`000?ooRGoo000000;ooh]o00Co
0000oon<OoooS7oo00000_ooSgl2o`000003oonBOol0003o000000;ooiMo0_l00003oonMO`03o`00
0?ooYWooojIo00;oojIo00?o0000ooncOooo/gl00_oo/gl2o`0000CoolEo00?o0000oooNOooogWl0
1?oogWl00ol0003oo_moookoO`04ookoO`03o`000?o>ogooc_mo00Goc_mo00?o0000oh[oOon:ogl0
0_n:ogl2o`0000Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`03okmoool0
003o000000GoR_mo0_l00007olkoO`03o`000?onogooo_mo00Coo_mo0_l00006oooNO`03o`000?oo
aGooolEo00?oolEo00?o0000ooncOooo/gl00ooo/gl00ol0003oojIooonVO`02oonVO`;o00001?oo
WGl00ol0003ooiMooonGO`03oonGO`03o`000?ooTWoooi9o00?ooi9o00?o0000oon?OoooSgl02_oo
Sgl3o`00013oohmo0_l0000@oonBOa?o00003oooTWl2o`0000Koohmo0ol00004oon<O`;o00000_oo
Rgl2o`0000;oohUo0_l00002oon8O`04o`000?ooR7ooohQooon8O`;o00000oooOgl2o`0000;oohQo
1?l000001OooRGoo0000oon;OoooRgoo000000;oohao00?o0000oon?OoooSgl00_l000000oooTWoo
0000o`000002oonGO`;o00000oooWGl01Ol0003oojIooonVOoooYWoo000000Gook=o00?o0000ooo5
OoooaGl00oooaGl00ol0003oomiooooNO`03oooNO`03o`000?onogooo_mo00Coo_mo0_l00007olko
O`04o`000?n:ogooR_mooh[oO`;o00001Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo
00;ooooo00?o_gooo`000?l000001On:ogl00ol0003oc_moolkoO`05olkoO`03o`000?onogooo_mo
00Goo_mo00?o0000oooNOooogWl01?oogWl00ol0003oolEoooo5O`03ooo5O`03o`000?oo/goook=o
00?ook=o00?o0000oonVOoooYWl00oooYWl00ol0003ooieooonMO`03oonMO`03o`000?ooUgoooiMo
00;ooiMo00?o0000oonBOoooTWl00oooTWl00ol0003oohmooon?O`0Joon?O`Co00003OooTWl5o`00
01?ooiMo1_l0000;oonBO`;o00001oooSgl2o`0000?oohao0_l00003oon;O`05o`000?ooRGooohUo
oon9Ool000000_ooR7l01?l0003oohQooon8OoooR7l2o`0000Coogmo00Co0000oon8OoooR7oo0000
0_ooR7l00ol0003oohUoo`000002oon;O`04o`000?ooS7ooohaoo`0000;oohmo00?o0000oonBOooo
TWl00_l00002oonGO`05o`000?ooWGoooieooonMOol000001?ooYWl00ol0003ook=oooncO`02oonc
O`;o00001?ooaGl00ol0003oomiooooNO`04oooNO`03o`000?onogooo_mo00Coo_mo0_l00006olko
O`04o`000?n:ogooR_mooh[oO`;o00001Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo
00;ooooo0_noOol2o`0000?oR_mo00?o0000olkoOoo>ogl01_o>ogl00ol0003oo_moookoO`04ooko
O`03o`000?oogWooomio00Coomio00?o0000ooo5OoooaGl01?ooaGl00ol0003ook=oooncO`03oonc
O`03o`000?ooYWooojIo00;oojIo0_l00004oonMO`03o`000?ooUgoooiMo00;ooiMo00?o0000oonB
OoooTWl00oooTWl2o`0001[oohmo0ol0000<oonBO`Co00007_ooUgl4o`0000Wooi9o0ol00005oon?
O`;o00001?ooS7l2o`0000;ooh]o0_l00002oon9O`04o`000?ooR7ooohQoo`0000?oohQo00?o0000
oomoOoooOgl00oooOgl2o`000007oon8Ool0003oohQooon8Ool0003oohUoo`000002oon;O`04o`00
0?ooS7oo0000o`0000;oohmo00Co0000oonBOoooTWoo00000oooUgl01Ol0003ooieooonMOoooWGoo
000000CoojIo00?o0000ooncOooo/gl00_oo/gl2o`0000CoolEo00?o0000oooNOooogWl01?oogWl0
0ol0003oo_moookoO`04ookoO`03o`000?o>ogooc_mo00Goc_mo00Go0000oh[oOol0003o0000okmo
o`05ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool2okmoo`;o00000on:ogl0
0ol0003oc_moolkoO`05olkoO`03o`000?onogooo_mo00Goo_mo00?o0000oooNOooogWl00ooogWl2
o`0000GoolEo00?o0000ooncOooo/gl00ooo/gl00ol0003oojIooonVO`02oonVO`;o00001?ooWGl0
0ol0003ooiMooonGO`02oonGO`03o`000?ooTWoooi9o00Cooi9o00?o0000oon?OoooSgl05oooSgl2
o`0000cooi9o0ol0000VoonGO`?o00002OooTWl00ol0003oohmooon?O`04oon?O`;o00001?ooS7l0
1Ol0003ooh]ooon;OoooRgoo000000;oohUo00?o0000oon8OoooR7l00_l00002oon8O`03o`000?oo
Ogooogmo00Coogmo00Oo0000oon8Ool0003o0000oon8Ool0003oohUo00;o000000Gooh]oo`000?oo
S7ooohaoo`000002oon?O`04o`000?ooTWoooi9oo`0000?ooiMo00Go0000oonMOoooWGoooieoo`00
0004oonVO`03o`000?oo/goook=o00;ook=o00?o0000ooo5OoooaGl00oooaGl00ol0003oomiooooN
O`03oooNO`03o`000?onogooo_mo00Coo_mo0_l00006olkoO`05o`000?n:ogoo0000o`000?noOol0
1Oooool1o`00007ooooo000Kooooo`;o00000oooool2okmoo`;o00000_n:ogl00ol0003oc_moolko
O`06olkoO`03o`000?onogooo_mo00Coo_mo00?o0000oooNOooogWl01?oogWl00ol0003oolEoooo5
O`03ooo5O`03o`000?oo/goook=o00?ook=o00?o0000oonVOoooYWl00oooYWl00ol0003ooieooonM
O`02oonMO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonBOoooTWl00oooTWl00ol0003oohmooon?
O`0Foon?O`;o00002oooTWl3o`0002cooiMo0ol00007oonBO`?o00001OooSgl2o`0000?oohao00Go
0000oon;OoooRgoooh]oo`000002oon9O`05o`000?ooR7ooohQooon8Ool000000_ooR7l00ol0003o
ogmooomoO`04oomoO`07o`000?ooR7ooohQoo`000?ooR7oo0000oon9O`02o`000005oon;Ool0003o
ohaooon<Ool000000_ooSgl01?l0003ooi9ooonBOol00003oonGO`05o`000?ooWGoooieooonMOol0
00000oooYWl00ol0003ook=oooncO`03ooncO`03o`000?ooaGooolEo00;oolEo00?o0000oooNOooo
gWl01?oogWl00ol0003oo_moookoO`04ookoO`03o`000?o>ogooc_mo00Goc_mo0ol000000onoOooo
ooooooooo`02ooooo`;o00000Oooool001_ooooo00?o0000ooooooooool00_ooool2okmoo`;o0000
0_n:ogl00ol0003oc_moolkoO`05olkoO`03o`000?onogooo_mo00Coo_mo00?o0000oooNOooogWl0
1?oogWl00ol0003oolEoooo5O`04ooo5O`03o`000?oo/goook=o00;ook=o00?o0000oonVOoooYWl0
0oooYWl00ol0003ooieooonMO`02oonMO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonBOoooTWl0
0oooTWl00ol0003oohmooon?O`0Eoon?O`;o00002oooTWl2o`0001?ooiMo3_l0000AoonGO`?o0000
1oooTWl2o`0000Goohmo00Co0000oon<OoooS7ooohao0_l00002oon;O`03o`000?ooRGooohUo00;o
00000_ooR7l01?l0003oohQooon8Ool00006oomoO`09o`000?ooR7ooohQoo`000?ooR7oo0000oon9
Ool0003ooh]o00;o000000Coohaoo`000?l0003oohmo0_l00002oonBO`04o`000?ooUgoooiMoo`00
00?ooieo0_l00003oonVO`;o00000ooo/gl00ol0003oolEoooo5O`03ooo5O`03o`000?oogWooomio
00?oomio00?o0000ookoOoonogl01?onogl2o`0000Ooc_mo0_l000000onoOoooooooooooo`03oooo
o`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool2okmoo`;o000000?oR_moo`000?o>
ogl01_o>ogl00ol0003oo_moookoO`05ookoO`03o`000?oogWooomio00?oomio0_l00005ooo5O`03
o`000?oo/goook=o00?ook=o00?o0000oonVOoooYWl00_ooYWl00ol0003ooieooonMO`02oonMO`;o
00001?ooUgl00ol0003ooi9ooonBO`03oonBO`03o`000?ooSgooohmo01Coohmo0_l0000:oonBO`?o
00003_ooUgl7o`0000kooieo1ol0000=oonGO`;o00001oooTWl2o`0000Coohmo0_l00003oon<O`03
o`000?ooRgoooh]o00;o000000?oohUoo`000?l000000_ooR7l01?l0003oohQooon8Ool00006oomo
O`08o`000?ooR7ooohQoo`000?ooR7oo0000oon9Ool00002oon;O`06o`000?ooS7oo0000o`000?oo
Sgoo00000oooTWl01?l0003ooiMooonGOol00003oonMO`03o`000?ooYWooojIo00;oojIo00?o0000
ooncOooo/gl00_oo/gl00ol0003oolEoooo5O`03ooo5O`03o`000?oogWooomio00?oomio00?o0000
ookoOoonogl01?onogl00ol0003oc_moolkoO`05olkoO`;o000000?o_gooooooooooool00oooool1
o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo0onoOol2o`0000Soc_mo00?o0000ooko
Ooonogl01?onogl00ol0003oomiooooNO`04oooNO`03o`000?ooaGooolEo00?oolEo00?o0000oonc
Oooo/gl00ooo/gl00ol0003oojIooonVO`02oonVO`03o`000?ooWGoooieo00?ooieo00?o0000oonG
OoooUgl00_ooUgl00ol0003ooi9ooonBO`03oonBO`03o`000?ooSgooohmo01Coohmo00?o0000oonB
OoooTWl01oooTWl3o`0000gooiMo1?l0000LoonMO`Co00002oooUgl2o`0000Oooi9o00?o0000oon?
OoooSgl00oooSgl01Ol0003oohaooon<OoooS7oo000000;ooh]o0_l00002oon9O`04o`000?ooR7oo
ohQoo`0000;oohQo00?o0000oomoOoooOgl01?ooOgl2o`000006oon8Ool0003oohQoo`000?ooRGoo
00000_ooRgl00ol0003oohaoo`000002oon?O`04o`000?ooTWoooi9oo`0000?ooiMo00Go0000oonM
OoooWGoooieoo`000004oonVO`03o`000?oo/goook=o00;ook=o00?o0000ooo5OoooaGl00_ooaGl0
0ol0003oomiooooNO`03oooNO`;o00001_onogl00ol0003oc_moolkoO`03olkoO`;o00000_noOol5
ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool3okmoo`;o00001oo>ogl00ol0
003oo_moookoO`05ookoO`03o`000?oogWooomio00?oomio0_l00005ooo5O`03o`000?oo/goook=o
00;ook=o00?o0000oonVOoooYWl00oooYWl00ol0003ooieooonMO`02oonMO`03o`000?ooUgoooiMo
00;ooiMo0_l00005oonBO`03o`000?ooSgooohmo01;oohmo0_l00008oonBO`;o00003OooUgl3o`00
02Cooieo0ol0000:oonGO`?o00001OooTWl2o`0000Coohmo00Co0000oon<OoooS7ooohao0_l00002
oon;O`03o`000?ooRGooohUo00;o000000CoohQoo`000?ooR7oo00002?ooOgl01_l0003oohQoo`00
0?ooR7oo0000oon9O`;o000000Cooh]oo`000?ooS7oo00000_ooSgl01?l0003ooi9ooonBOol00003
oonGO`05o`000?ooWGoooieooonMOol000000oooYWl00ol0003ook=oooncO`02ooncO`03o`000?oo
aGooolEo00?oolEo00?o0000oooNOooogWl00ooogWl00ol0003oo_moookoO`04ookoO`03o`000?o>
ogooc_mo00?oc_mo0_l00002okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02
ooooo`?o_goo0_l00007olkoO`03o`000?onogooo_mo00Coo_mo00?o0000oooNOooogWl01?oogWl0
0ol0003oolEoooo5O`03ooo5O`03o`000?oo/goook=o00?ook=o00?o0000oonVOoooYWl00_ooYWl0
0ol0003ooieooonMO`02oonMO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonBOoooTWl00oooTWl0
0ol0003oohmooon?O`0Aoon?O`;o00002?ooTWl2o`0000cooiMo0ol0000ZoonMO`?o00002_ooUgl2
o`0000Gooi9o00?o0000oon?OoooSgl00_ooSgl2o`0000;oohao0_l00002oon;O`;o000000OoohUo
o`000?l0003oohQoo`000?ooR7oo000000Soogmo00Ko0000oon8Ool0003oohQoo`000?ooRGl2o`00
0004oon;Ool0003oohaoo`0000;oohmo00Co0000oonBOoooTWoo00000_ooUgl2o`0000;ooieo0_l0
0003oonVO`03o`000?oo/goook=o00;ook=o00?o0000ooo5OoooaGl00oooaGl00ol0003oomiooooN
O`03oooNO`03o`000?onogooo_mo00Coo_mo00?o0000olkoOoo>ogl00_o>ogl2o`0000;o_goo1Ooo
ool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo0onoOol2o`0000Koc_mo00?o0000
ookoOoonogl01?onogl00ol0003oomiooooNO`04oooNO`03o`000?ooaGooolEo00?oolEo0_l00004
ooncO`03o`000?ooYWooojIo00;oojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonGO`03
oonGO`03o`000?ooTWoooi9o00?ooi9o00?o0000oon?OoooSgl04OooSgl2o`0000Sooi9o00?o0000
oonGOoooUgl02OooUgl3o`00033ooieo0ol00009oonGO`03o`000?ooTWoooi9o00?ooi9o0_l00004
oon?O`05o`000?ooS7ooohaooon<Ool000000oooRgl02?l0003oohUoo`000?l0003oohQoo`000?oo
R7oo00002?ooOgl01ol0003oohQoo`000?ooR7oo0000oon9Ool000000_ooRgl00ol0003oohaoo`00
0002oon?O`04o`000?ooTWoooi9oo`0000;ooiMo00Go0000oonMOoooWGoooieoo`000004oonVO`03
o`000?oo/goook=o00;ook=o00?o0000ooo5OoooaGl00_ooaGl00ol0003oomiooooNO`03oooNO`03
o`000?onogooo_mo00Coo_mo00?o0000olkoOoo>ogl00_o>ogl2o`0000;o_goo1Oooool1o`00007o
oooo000Kooooo`03o`000?oooooooooo00;ooooo1?noOol2o`0000Goc_mo00?o0000ookoOoonogl0
1?onogl00ol0003oomiooooNO`03oooNO`03o`000?ooaGooolEo00CoolEo00?o0000ooncOooo/gl0
0_oo/gl00ol0003oojIooonVO`03oonVO`03o`000?ooWGoooieo00;ooieo00?o0000oonGOoooUgl0
0_ooUgl00ol0003ooi9ooonBO`03oonBO`03o`000?ooSgooohmo013oohmo0_l00008oonBO`;o0000
2_ooUgl2o`0001Cooieo3ol0000CoonMO`;o00002?ooUgl2o`0000Gooi9o0_l00003oon?O`;o0000
0_ooS7l2o`0000;ooh]o00So0000oon9OoooRGoo0000oon8Ool0003oohQoo`0000Soogmo00Wo0000
oon8Ool0003oohQoo`000?ooRGoo0000oon;Ool000000_ooS7l01?l0003oohmooon?Ool00002oonB
O`04o`000?ooUgoooiMoo`0000?ooieo00Go0000oonVOoooYWooojIoo`000004ooncO`03o`000?oo
aGooolEo00?oolEo00?o0000oooNOooogWl00ooogWl00ol0003oo_moookoO`04ookoO`03o`000?o>
ogooc_mo00;o00000onoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool4
okmoo`;o00001?o>ogl00ol0003oo_moookoO`04ookoO`03o`000?oogWooomio00Coomio00?o0000
ooo5OoooaGl00oooaGl00ol0003ook=oooncO`03ooncO`03o`000?ooYWooojIo00;oojIo00?o0000
oonMOoooWGl00_ooWGl00ol0003ooiMooonGO`02oonGO`03o`000?ooTWoooi9o00Cooi9o00?o0000
oon?OoooSgl03oooSgl2o`0000Oooi9o0_l00009oonGO`?o00003oooWGl7o`0000ooojIo1ol0000>
oonMO`?o00001oooUgl2o`0000Cooi9o0_l00003oon?O`;o00000oooS7l01?l0003ooh]ooon;Ool0
0002oon9O`05o`000?ooR7oo0000oon8Ool000002?ooOgl3o`000006oon8Ool0003oohUoo`000?oo
Rgoo00000_ooS7l00ol0003oohmoo`000002oonBO`05o`000?ooUgoooiMooonGOol000000oooWGl0
1Ol0003oojIooonVOoooYWoo000000Cook=o00?o0000ooo5OoooaGl00_ooaGl00ol0003oomiooooN
O`03oooNO`;o00001Oonogl00ol0003oc_moolkoO`02o`0000?o_goo1Oooool1o`00007ooooo000K
ooooo`03o`000?oooooooooo00;ooooo1?noOol2o`0000?oc_mo0_l00006ookoO`03o`000?oogWoo
omio00?oomio00?o0000ooo5OoooaGl00oooaGl00ol0003ook=oooncO`03ooncO`03o`000?ooYWoo
ojIo00;oojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonGO`02oonGO`03o`000?ooTWoo
oi9o00Cooi9o00?o0000oon?OoooSgl03_ooSgl2o`0000Sooi9o00?o0000oonGOoooUgl01oooUgl3
o`0000gooieo1?l0000MoonVO`Co00003?ooWGl3o`0000OooiMo00?o0000oonBOoooTWl00oooTWl0
1?l0003oohmooon?OoooSgl2o`0000?oohao00Co0000oon;OoooRgoo00000_ooRGl01Ol0003oohQo
o`000?ooR7oo000000Soogmo00[o0000oon8Ool0003oohQoo`000?ooRGoo0000oon;Ool0003oohao
0_l000001OooSgoo0000oonBOoooTWoo000000;ooiMo0_l00002oonMO`;o00000oooYWl00ol0003o
ok=oooncO`02ooncO`03o`000?ooaGooolEo00;oolEo00?o0000oooNOooogWl00ooogWl00ol0003o
o_moookoO`04ookoO`04o`000?o>ogoo0000o`0000?o_goo1Oooool1o`00007ooooo000Kooooo`03
o`000?oooooooooo00;ooooo1?noOol2o`0000?oc_mo00?o0000ookoOoonogl01?onogl00ol0003o
omiooooNO`04oooNO`03o`000?ooaGooolEo00?oolEo00?o0000ooncOooo/gl00_oo/gl2o`0000?o
ojIo0_l00003oonMO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonBOoooTWl00oooTWl00ol0003o
ohmooon?O`0=oon?O`?o00001oooTWl2o`0000SooiMo0_l0000=oonMO`?o00009OooYWl3o`0000co
oieo0_l00006oonGO`;o00001?ooTWl2o`0000;oohmo0ol00002oon<O`05o`000?ooRgoooh]oo`00
0?ooRGl00_l000001?ooR7oo0000oon8Ool00008oomoO`0;o`000?ooR7oo0000oon8Ool0003oohUo
o`000?ooRgoo0000oon<Ool000000_ooSgl01?l0003ooi9ooonBOol00002oonGO`05o`000?ooWGoo
oieooonMOol000000oooYWl00ol0003ook=oooncO`02ooncO`03o`000?ooaGooolEo00;oolEo0_l0
0005oooNO`03o`000?onogooo_mo00Coo_mo0ol00003okmoo`Gooooo0Ol00001ooooo`006oooool0
0ol0003oooooooooo`02ooooo`Go_goo0_l000000oo>ogoo0000o`000005ookoO`;o00001OoogWl0
0ol0003oolEoooo5O`03ooo5O`03o`000?oo/goook=o00;ook=o0_l00004oonVO`03o`000?ooWGoo
oieo00;ooieo00?o0000oonGOoooUgl00_ooUgl00ol0003ooi9ooonBO`03oonBO`;o00003_ooSgl0
0ol0003ooi9ooonBO`06oonBO`;o00002?ooUgl2o`0000cooieo0ol0000[oonVO`?o00002oooWGl2
o`0000KooiMo00?o0000oonBOoooTWl00_ooTWl2o`0000Coohmo00Co0000oon<OoooS7oo00000_oo
Rgl02?l0003oohUoo`000?l0003oohQoo`000?ooR7oo00002?ooOgl02ol0003oohQoo`000?ooR7oo
0000oon9Ool0003ooh]oo`000?ooS7oo000000;oohmo00Co0000oonBOol0003o00000_ooUgl01Ol0
003ooieooonMOoooWGoo000000?oojIo00?o0000ooncOooo/gl00_oo/gl00ol0003oolEoooo5O`02
ooo5O`03o`000?oogWooomio00?oomio00?o0000ookoOoonogl01?onogl2o`0000Co_goo1Oooool1
o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo1OnoOol2o`000003olkoOol0003oo_mo
00Goo_mo00?o0000oooNOooogWl00ooogWl00ol0003oolEoooo5O`03ooo5O`03o`000?oo/goook=o
00?ook=o00?o0000oonVOoooYWl00_ooYWl00ol0003ooieooonMO`02oonMO`03o`000?ooUgoooiMo
00;ooiMo00?o0000oonBOoooTWl01?ooTWl00ol0003oohmooon?O`0<oon?O`03o`000?ooTWoooi9o
00Kooi9o0_l00007oonGO`;o00002oooWGl3o`00037oojIo0ol0000:oonMO`03o`000?ooUgoooiMo
00CooiMo0_l00004oonBO`;o00000oooSgl01?l0003oohaooon<Ool00002oon;O`03o`000?ooRGoo
000000Go00002?ooOgl03?l0003oohQoo`000?ooR7oo0000oon9Ool0003ooh]oo`000?ooS7oo0000
oon?O`;o000000Cooi9oo`000?l0003ooiMo0_l00003oonMO`05o`000?ooYWooojIooonVOol00000
0ooo/gl2o`0000CoolEo00?o0000oooNOooogWl00ooogWl00ol0003oo_moookoO`03ookoO`;o0000
1?noOol5ooooo`7o00000Oooool001_ooooo0_l00003ooooo`Go_goo0ol00007ookoO`03o`000?oo
gWooomio00?oomio00?o0000ooo5OoooaGl00oooaGl00ol0003ook=oooncO`03ooncO`03o`000?oo
YWooojIo00;oojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonGO`02oonGO`03o`000?oo
TWoooi9o00Cooi9o00?o0000oon?OoooSgl02_ooSgl2o`0000Sooi9o00?o0000oonGOoooUgl01_oo
Ugl2o`0000[ooieo0ol0000eoonVO`;o00002_ooWGl2o`0000GooiMo0_l00004oonBO`03o`000?oo
Sgooohmo00;oohmo00Co0000oon<OoooS7oo00000_ooRgl01ol0003oohUoo`000?ooR7oo0000oon8
Ool000002OooOgl02_l0003oohQoo`000?l0003oohUoo`000?ooRgoo0000oon<Ool00002oon?O`04
o`000?ooTWoooi9oo`0000?ooiMo00Co0000oonMOoooWGoo00000oooYWl00ol0003ook=oooncO`02
ooncO`03o`000?ooaGooolEo00;oolEo00?o0000oooNOooogWl00ooogWl00ol0003oo_moookoO`03
ookoO`;o00001?noOol4ooooo`;o00000Oooool001_ooooo00?o0000ooooooooool00_ooool5okmo
o`;o00001oonogl00ol0003oomiooooNO`04oooNO`03o`000?ooaGooolEo00;oolEo0_l00004oonc
O`03o`000?ooYWooojIo00;oojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonGO`02oonG
O`03o`000?ooTWoooi9o00Cooi9o00?o0000oon?OoooSgl02_ooSgl2o`0000Sooi9o00?o0000oonG
OoooUgl01OooUgl2o`0000[ooieo0ol0000EoonVOa3o00005?ooYWl3o`0000Sooieo0_l00005oonG
O`;o00001?ooTWl01?l0003oohmooon?OoooSgl2o`0000;oohao00[o0000oon;Ool0003o0000oon9
Ool0003oohQoo`000?ooR7oo00002?ooOgl5o`000008oon9Ool0003ooh]oo`000?ooS7oo0000oon?
Ool00002oonBO`05o`000?ooUgoooiMooonGOol000000_ooWGl2o`0000;oojIo0_l00003ooncO`03
o`000?ooaGooolEo00?oolEo00?o0000oooNOooogWl00ooogWl00ol0003oo_moookoO`02ookoO`;o
00001?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool6okmoo`;o0000
1_onogl00ol0003oomiooooNO`03oooNO`03o`000?ooaGooolEo00?oolEo00?o0000ooncOooo/gl0
0_oo/gl00ol0003oojIooonVO`03oonVO`04o`000?ooWGoooieooonMO`;o00000oooUgl2o`0000Go
oi9o00?o0000oon?OoooSgl02_ooSgl2o`0000Sooi9o00?o0000oonGOoooUgl01OooUgl2o`0000So
oieo0ol0000AoonVO`Oo00004?oo/gl7o`00013oojIo0_l00008oonMO`;o00001OooUgl00ol0003o
oi9ooonBO`02oonBO`;o00000_ooSgl2o`0000;oohao00[o0000oon;Ool0003o0000oon9Ool0003o
ohQoo`000?ooR7oo00002?ooOgl9o`000004oon<Ool0003oohmoo`0000;ooi9o00?o0000oonGOooo
Ugl00_l00002oonMO`05o`000?ooYWooojIooonVOol000001?oo/gl00ol0003oolEoooo5O`02ooo5
O`03o`000?oogWooomio00?oomio00Co0000ookoOoonogooo_mo0_l00005okmoo`Gooooo0Ol00001
ooooo`006oooool00ol0003oooooooooo`02ooooo`Ko_goo0_l00005ookoO`03o`000?oogWooomio
00Coomio00?o0000ooo5OoooaGl00_ooaGl00ol0003ook=oooncO`03ooncO`03o`000?ooYWooojIo
00;oojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonGO`02oonGO`03o`000?ooTWoooi9o
00Cooi9o00?o0000oon?OoooSgl02OooSgl2o`0000Oooi9o0_l00006oonGO`;o00002OooWGl2o`00
00ooojIo1?l0000MooncO`Go00003_ooYWl2o`0000Oooieo0_l00005oonGO`;o00000oooTWl2o`00
00;oohmo0_l00002oon<O`0:o`000?ooRgoo0000o`000?ooRGoo0000oon8Ool0003oohQoo`0000So
ogmo1_l000001?ooRgoo0000oon<Ool00002oon?O`04o`000?ooTWoooi9oo`0000;ooiMo0_l00002
oonMO`05o`000?ooYWooojIooonVOol000000ooo/gl00ol0003oolEoooo5O`03ooo5O`03o`000?oo
gWooomio00?oomio00?o0000ookoOoonogl00_l00005okmoo`Gooooo0Ol00001ooooo`006oooool0
0ol0003oooooooooo`02ooooo`Ko_goo0_l00005ookoO`03o`000?oogWooomio00?oomio00?o0000
ooo5OoooaGl00oooaGl00ol0003ook=oooncO`02ooncO`03o`000?ooYWooojIo00;oojIo00?o0000
oonMOoooWGl00_ooWGl00ol0003ooiMooonGO`02oonGO`03o`000?ooTWoooi9o00?ooi9o0_l0000;
oon?O`03o`000?ooTWoooi9o00Gooi9o0_l00007oonGO`;o00002?ooWGl2o`0000koojIo0ol0000V
ooncO`?o00003OooYWl2o`0000Oooieo0_l00005oonGO`03o`000?ooTWoooi9o00;ooi9o00Go0000
oon?OoooSgooohmoo`000002oon<O`07o`000?ooRgoo0000o`000?ooRGoo0000oon8O`02o`0000Wo
ogmo1_l000001?ooRgoo0000oon<Ool00002oon?O`04o`000?ooTWoo0000o`0000;ooiMo00?o0000
oonMOoooWGl00_l00002oonVO`;o00000ooo/gl00ol0003oolEoooo5O`02ooo5O`03o`000?oogWoo
omio00?oomio00?o0000ookoOoonogl00_l00005okmoo`Gooooo0Ol00001ooooo`006oooool00ol0
003oooooooooo`02ooooo`Oo_goo0_l00003ookoO`03o`000?oogWooomio00?oomio00?o0000ooo5
OoooaGl00oooaGl00ol0003ook=oooncO`02ooncO`;o00001?ooYWl01Ol0003ooieooonMOoooWGoo
000000CooiMo0_l00005oonBO`03o`000?ooSgooohmo00Soohmo0_l00007oonBO`;o00001oooUgl0
0ol0003ooieooonMO`06oonMO`;o00003OooYWl3o`0002cook=o0_l0000=oonVO`;o00001oooWGl0
0ol0003ooiMooonGO`03oonGO`03o`000?ooTWoooi9o00;ooi9o0_l00002oon?O`05o`000?ooS7oo
ohaoo`000?ooRgl00_l000000oooRGoo0000oon8O`02o`0000Woogmo00?o0000oon8Ool000000ol0
00001_ooRgoo0000oon<Ool0003oohmoo`0000;ooi9o0_l000000oooUgoo0000o`000002oonMO`05
o`000?ooYWooojIooonVOol000001?oo/gl00ol0003oolEoooo5O`02ooo5O`03o`000?oogWooomio
00?oomio0ol00006okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`Oo
_goo0_l00002ookoO`03o`000?oogWooomio00Coomio00?o0000ooo5OoooaGl00_ooaGl2o`0000?o
ok=o0_l00004oonVO`03o`000?ooWGoooieo00;ooieo00?o0000oonGOoooUgl00_ooUgl00ol0003o
oi9ooonBO`03oonBO`;o00002OooSgl2o`0000Oooi9o00?o0000oonGOoooUgl01OooUgl2o`0000So
oieo00?o0000oonVOoooYWl02oooYWl2o`00037ook=o0ol0000;oonVO`;o00001oooWGl00ol0003o
oiMooonGO`03oonGO`;o00000oooTWl2o`0000;oohmo00Ko0000oon<OoooS7oo0000oon;Ool00002
oon9O`Co00002OooOgl4o`000008oon9Ool0003ooh]oo`000?ooS7oo0000oon?Ool00002oonBO`04
o`000?ooUgoooiMoo`0000?ooieo00Go0000oonVOoooYWooojIoo`000003ooncO`03o`000?ooaGoo
olEo00;oolEo0_l00005oooNO`;o00001_noOol5ooooo`7o00000Oooool001_ooooo00?o0000oooo
ooooool00_ooool7okmoo`?o000000?oo_moo`000?oogWl01?oogWl00ol0003oolEoooo5O`03ooo5
O`03o`000?oo/goook=o00;ook=o00?o0000oonVOoooYWl00_ooYWl00ol0003ooieooonMO`02oonM
O`03o`000?ooUgoooiMo00;ooiMo00?o0000oonBOoooTWl01?ooTWl00ol0003oohmooon?O`07oon?
O`03o`000?ooTWoooi9o00Kooi9o00?o0000oonGOoooUgl01OooUgl00ol0003ooieooonMO`06oonM
O`;o00003?ooYWl2o`0003Kook=o0_l0000;oonVO`;o00001_ooWGl2o`0000GooiMo00Co0000oonB
OoooTWoooi9o0_l00002oon?O`06o`000?ooS7ooohaoo`000?ooRgoo00000_ooRGl2o`000003oon8
Ool0003oogmo00Soogmo0_l000000oooR7oo0000oon9O`02o`0000;oohao00?o0000oon?Ool00000
0_ooTWl01?l0003ooiMooonGOol00002oonMO`05o`000?ooYWooojIooonVOol000001?oo/gl00ol0
003oolEoooo5O`02ooo5O`03o`000?oogWooomio00?oomio0_l00006okmoo`Gooooo0Ol00001oooo
o`006oooool00ol0003oooooooooo`02ooooo`Wo_goo0_l00006oooNO`03o`000?ooaGooolEo00;o
olEo00?o0000ooncOooo/gl00_oo/gl2o`0000CoojIo00Go0000oonMOoooWGoooieoo`000004oonG
O`03o`000?ooTWoooi9o00Cooi9o0_l00008oon?O`03o`000?ooTWoooi9o00Gooi9o0_l00007oonG
O`03o`000?ooWGoooieo00Kooieo00?o0000oonVOoooYWl02_ooYWl2o`0003[ook=o0ol0000:oonV
O`03o`000?ooWGoooieo00Gooieo00?o0000oonGOoooUgl00oooUgl01?l0003ooi9ooonBOoooTWl2
o`0000;oohmo00Oo0000oon<OoooS7oo0000oon;Ool0003oohUo00?o000000?oohQoo`000?ooOgl0
2?ooOgl2o`000007oon8Ool0003o0000oon;Ool0003oohaoo`000002oon?O`04o`000?ooTWoo0000
o`0000;ooiMo00Co0000oonMOoooWGoo00000oooYWl00ol0003ook=oooncO`02ooncO`03o`000?oo
aGooolEo00;oolEo00Co0000oooNOooogWooomio0_l00007okmoo`Gooooo0Ol00001ooooo`006ooo
ool00ol0003oooooooooo`02ooooo`Wo_goo0_l00005oooNO`03o`000?ooaGooolEo00?oolEo00?o
0000ooncOooo/gl00_oo/gl00ol0003oojIooonVO`02oonVO`03o`000?ooWGoooieo00;ooieo00?o
0000oonGOoooUgl00_ooUgl00ol0003ooi9ooonBO`04oonBO`03o`000?ooSgooohmo00Koohmo00?o
0000oonBOoooTWl01OooTWl2o`0000KooiMo0_l00007oonMO`;o00002_ooYWl3o`0001Kook=o4_l0
000GooncO`;o00002OooYWl2o`0000Kooieo00?o0000oonGOoooUgl00oooUgl01?l0003ooi9ooonB
OoooTWl2o`0000;oohmo00co0000oon<OoooS7oo0000oon;Ool0003oohUoo`000?ooR7oo0000oon8
Ool00009oomoO`;o000000SoohQoo`000?l0003ooh]oo`000?ooS7oo0000oon?O`;o000000Gooi9o
o`000?ooUgoooiMoo`000003oonMO`05o`000?ooYWooojIooonVOol000000ooo/gl00ol0003oolEo
ooo5O`02ooo5O`;o00000_oogWl2o`0000Oo_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oo
oooooooo00;ooooo2_noOol2o`0000?oomio00?o0000ooo5OoooaGl00oooaGl00ol0003ook=ooonc
O`02ooncO`03o`000?ooYWooojIo00;oojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonG
O`02oonGO`03o`000?ooTWoooi9o00Cooi9o00?o0000oon?OoooSgl01OooSgl2o`0000Oooi9o00?o
0000oonGOoooUgl01?ooUgl3o`0000Oooieo00?o0000oonVOoooYWl02?ooYWl2o`0001?ook=o1_l0
000Booo5O`Ko00004ooo/gl2o`0000WoojIo00?o0000oonMOoooWGl01?ooWGl2o`0000CooiMo00?o
0000oonBOoooTWl00_ooTWl01?l0003oohmooon?Ool00002oon<O`03o`000?ooRgoo000000;o0000
00CoohQoo`000?l0003o00002OooOgl3o`000007oon9Ool0003ooh]oo`000?ooS7oo0000oon?O`02
o`000005oonBOol0003ooiMooonGOol000000_ooWGl01Ol0003oojIooonVOoooYWoo000000Cook=o
00?o0000ooo5OoooaGl00_ooaGl01?l0003oomioo`000?l00008okmoo`Gooooo0Ol00001ooooo`00
6oooool00ol0003oooooooooo`02ooooo`[o_goo0_l00003oooNO`03o`000?ooaGooolEo00;oolEo
00?o0000ooncOooo/gl00ooo/gl00ol0003oojIooonVO`02oonVO`05o`000?ooWGoooieooonMOol0
00001?ooUgl00ol0003ooi9ooonBO`05oonBO`03o`000?ooSgooohmo00Coohmo0_l00007oonBO`03
o`000?ooUgoooiMo00CooiMo0_l00007oonMO`;o00002OooYWl2o`00017ook=o1?l0000Nooo5O`Co
00004Ooo/gl2o`0000SoojIo0_l00006oonMO`03o`000?ooUgoooiMo00;ooiMo0_l00003oonBO`04
o`000?ooSgooohmoo`0000;oohao00Ko0000oon;Ool0003oohUoo`000?ooR7l3o`0000Soogmo00Go
0000oon8Ool0003o0000oon9O`05o`000005oon?Ool0003ooi9ooonBOol000000_ooUgl01?l0003o
oieooonMOol00003oonVO`05o`000?oo/goook=oooncOol000001?ooaGl4o`0000So_goo1Oooool1
o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo2_noOol2o`0000;oomio00?o0000ooo5
OoooaGl00oooaGl00ol0003ook=oooncO`02ooncO`03o`000?ooYWooojIo00;oojIo00?o0000oonM
OoooWGl00_ooWGl00ol0003ooiMooonGO`02oonGO`03o`000?ooTWoooi9o00Cooi9o00?o0000oon?
OoooSgl01?ooSgl00ol0003ooi9ooonBO`06oonBO`03o`000?ooUgoooiMo00CooiMo0_l00007oonM
O`03o`000?ooYWooojIo00OoojIo0_l0000@ooncO`?o00009_ooaGl3o`00013ook=o00?o0000oonV
OoooYWl01_ooYWl2o`0000Kooieo00?o0000oonGOoooUgl00_ooUgl2o`0000?ooi9o00Co0000oon?
OoooSgoo00000_ooS7l01_l0003ooh]oo`000?ooRGoo0000oon8O`;o00002OooOgl7o`000007oon<
Ool0003o0000oon?Ool0003ooi9oo`000002oonGO`05o`000?ooWGoooieooonMOol000000oooYWl0
1Ol0003ook=oooncOooo/goo000000GoolEo0_l00008okmoo`Gooooo0Ol00001ooooo`006oooool2
o`0000?ooooo2onoOol2o`000003oooNOol0003oolEo00?oolEo00?o0000ooncOooo/gl00_oo/gl0
0ol0003oojIooonVO`02oonVO`03o`000?ooWGoooieo00;ooieo00?o0000oonGOoooUgl00_ooUgl0
0ol0003ooi9ooonBO`05oonBO`03o`000?ooSgooohmo00;oohmo0_l00008oonBO`03o`000?ooUgoo
oiMo00CooiMo0_l00007oonMO`03o`000?ooYWooojIo00OoojIo00?o0000ooncOooo/gl03_oo/gl2
o`0002coolEo0ol0000>ooncO`;o00002?ooYWl2o`0000Gooieo0_l00004oonGO`05o`000?ooTWoo
oi9ooonBOol000000_ooSgl02Ol0003oohaoo`000?l0003ooh]oo`000?ooRGoo0000oon8O`02o`00
00Woogmo0_l000002OooR7oo0000o`000?ooRgoo0000oon<Ool0003oohmoo`000002oonBO`04o`00
0?ooUgoooiMoo`0000;ooieo00Go0000oonVOoooYWooojIoo`000003ooncO`;o00000oooaGl2o`00
00Wo_goo1?ooool2o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo2onoOol3o`0000Go
olEo00?o0000ooncOooo/gl00_oo/gl00ol0003oojIooonVO`02oonVO`04o`000?ooWGoooieooonM
O`;o00000oooUgl00ol0003ooi9ooonBO`05oonBO`03o`000?ooSgooohmo00;oohmo00?o0000oonB
OoooTWl01oooTWl00ol0003ooiMooonGO`04oonGO`03o`000?ooWGoooieo00Gooieo0_l00008oonV
O`;o00003_oo/gl3o`00037oolEo0_l0000>ooncO`03o`000?ooYWooojIo00KoojIo0_l00005oonM
O`;o00001?ooUgl00ol0003ooi9ooonBO`02o`0000;oohmo00?o0000oon<Ool000000ol000000ooo
RGoo0000oon8O`02o`0000Woogmo0ol000002?ooRGoo0000o`000?l0003oohaoo`000?ooSgoo0000
0_ooTWl01?l0003ooiMooonGOol00002oonMO`05o`000?ooYWooojIooonVOol000000ooo/gl01?l0
003oolEoooo5OoooaGl2o`0000Wo_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo
00;ooooo3?noOol2o`0000CoolEo00?o0000ooncOooo/gl00_oo/gl00ol0003oojIooonVO`02oonV
O`03o`000?ooWGoooieo00;ooieo00?o0000oonGOoooUgl00_ooUgl00ol0003ooi9ooonBO`05oonB
O`03o`000?ooSgooohmo00;o00002OooTWl00ol0003ooiMooonGO`04oonGO`03o`000?ooWGoooieo
00Gooieo0_l00008oonVO`03o`000?oo/goook=o00cook=o0_l0000fooo5O`?o00003?oo/gl2o`00
00OoojIo0_l00006oonMO`03o`000?ooUgoooiMo00;ooiMo00?o0000oonBOoooTWl00_l00002oon?
O`07o`000?ooS7oo0000o`000?ooRgoo0000oon9O`02o`000003oon8Ool0003oogmo00Ooogmo1_l0
00002?ooRgoo0000o`000?l0003oohmoo`000?ooTWoo00000_ooUgl01Ol0003ooieooonMOoooWGoo
000000;oojIo00Co0000ooncOooo/goook=o0_l000000oooaGoo0000o`00000:okmoo`Gooooo0Ol0
0001ooooo`006oooool00ol0003oooooooooo`02ooooo`co_goo0_l00004ooo5O`03o`000?oo/goo
ok=o00;ook=o00Go0000oonVOoooYWooojIoo`000004oonMO`03o`000?ooUgoooiMo00;ooiMo00?o
0000oonBOoooTWl01_ooTWl00ol0003oohmoo`00000:oonBO`03o`000?ooUgoooiMo00CooiMo00?o
0000oonMOoooWGl01?ooWGl2o`0000SoojIo0_l0000=ooncO`;o0000>oooaGl3o`0000_ook=o0_l0
0006oonVO`?o00001OooWGl00ol0003ooiMooonGO`02oonGO`03o`000?ooTWoooi9o00;o000000Co
ohmoo`000?l0003oohao0_l000000oooRgoo0000oon9O`02o`000003oon8Ool0003oogmo00Ooogmo
1ol000001?ooS7oo0000oon?Ool00002oonBO`04o`000?ooUgoooiMoo`0000;ooieo00Go0000oonV
OoooYWooojIoo`000003ooncO`Co00002_noOol5ooooo`7o00000Oooool001_ooooo00?o0000oooo
ooooool00_ooool=okmoo`;o00000_ooaGl00ol0003ook=oooncO`02ooncO`03o`000?ooYWooojIo
00;oojIo00Co0000oonMOoooWGoooieo0_l00003oonGO`;o00002OooTWl00ol0003ooi9ooonBO`08
oonBO`03o`000?ooUgoooiMo00CooiMo00?o0000oonMOoooWGl01?ooWGl00ol0003oojIooonVO`07
oonVO`03o`000?oo/goook=o00[ook=o0ol00010ooo5O`;o00002_oo/gl2o`0000SoojIo00?o0000
oonMOoooWGl00oooWGl01?l0003ooiMooonGOoooUgl2o`0000;ooi9o0_l000001?ooSgoo0000o`00
0?ooS7l2o`000004oon;Ool0003o0000oon8O`;o00002OooOgl5o`000006oon;Ool0003oohaoo`00
0?ooSgoo00000_ooTWl01?l0003ooiMooonGOol00002oonMO`03o`000?ooYWooojIo00;o00000ooo
/gl2o`0000_o_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo3OnoOol2
o`000003ooo5Ool0003ook=o00?ook=o00?o0000oonVOoooYWl00_ooYWl00ol0003ooieooonMO`02
oonMO`03o`000?ooUgoooiMo00;ooiMo00?o0000oonBOoooTWl04_ooTWl00ol0003ooiMooonGO`03
oonGO`;o00001_ooWGl00ol0003oojIooonVO`06oonVO`;o00002ooo/gl2o`0001_oolEo3ol0000K
ooo5O`03o`000?oo/goook=o00Wook=o0_l00007oonVO`03o`000?ooWGoooieo00?ooieo00Co0000
oonGOoooUgoooiMo0_l00002oonBO`;o000000[oohmoo`000?l0003oohaoo`000?ooRgoo0000oon9
Ool0003oohQo0_l00009oomoO`Go000000Sooh]oo`000?ooS7oo0000oon?Ool0003ooi9oo`0000;o
oiMo00?o0000oonMOoooWGl00_l00002oonVO`04o`000?oo/goook=oooncO`;o00002onoOol5oooo
o`7o00000Oooool001_ooooo00?o0000ooooooooool00_ooool>okmoo`?o00001?oo/gl00ol0003o
ojIooonVO`02oonVO`04o`000?ooWGoooieooonMO`;o00000oooUgl00ol0003ooi9ooonBO`0AoonB
O`;o00001OooUgl2o`0000Kooieo00?o0000oonVOoooYWl01_ooYWl2o`0000[ook=o0_l0000Fooo5
O`Oo00003ooogWl7o`0001GoolEo0_l0000:ooncO`;o00001oooYWl00ol0003ooieooonMO`03oonM
O`04o`000?ooUgoooiMooonGO`;o00000_ooTWl2o`00000:oon?Ool0003o0000oon<Ool0003ooh]o
o`000?ooRGoo0000oon8O`;o00002?ooOgl4o`000007oon9Ool0003o0000oon<Ool0003oohmoo`00
0002oonBO`04o`000?ooUgoooiMoo`0000;ooieo00?o0000oonVOoooYWl00_l000000ooo/goo0000
o`00000<okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`ko_goo0_l0
0004ooncO`03o`000?ooYWooojIo00;oojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonG
O`02oonGO`03o`000?ooTWoooi9o013ooi9o0_l00005oonGO`;o00001_ooWGl00ol0003oojIooonV
O`05oonVO`;o00002ooo/gl00ol0003oolEoooo5O`0Booo5O`Co00007OoogWl4o`0001?oolEo0_l0
0009ooncO`;o00001oooYWl00ol0003ooieooonMO`03oonMO`04o`000?ooUgoooiMooonGO`;o0000
0_ooTWl2o`0000;oohmo00Ko0000oon<Ool0003ooh]oo`000?ooRGl2o`000003oon8Ool0003oogmo
00Ooogmo1Ol000001_ooRgoo0000oon<Ool0003oohmoo`0000;ooi9o00?o0000oonGOol000000_oo
WGl2o`0000;oojIo1?l0000<okmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02
ooooo`oo_goo0_l00003ooncO`05o`000?ooYWooojIooonVOol000001?ooWGl00ol0003ooiMooonG
O`02oonGO`03o`000?ooTWoooi9o013ooi9o0_l00005oonGO`;o00001OooWGl2o`0000OoojIo0_l0
000:ooncO`;o00004_ooaGl3o`0002Goomio0ol0000Booo5O`;o00002Ooo/gl2o`0000KoojIo00?o
0000oonMOoooWGl00oooWGl01?l0003ooiMooonGOoooUgl2o`0000;ooi9o0_l00002oon?O`06o`00
0?ooS7oo0000oon;Ool0003oohUo0ol00009oomoO`;o000000_oohQoo`000?l0003ooh]oo`000?oo
S7oo0000oon?Ool0003ooi9oo`000002oonGO`04o`000?ooWGoooieoo`0000;oojIo0ol0000=okmo
o`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooo`oo_goo0_l00003ooncO`05
o`000?ooYWooojIooonVOol000000oooWGl00ol0003ooiMooonGO`03oonGO`03o`000?ooTWoooi9o
013ooi9o00?o0000oonGOoooUgl01?ooUgl00ol0003ooieooonMO`04oonMO`03o`000?ooYWooojIo
00KoojIo00?o0000ooncOooo/gl02?oo/gl00ol0003oolEoooo5O`0?ooo5O`?o0000:ooogWl3o`00
013oolEo0_l00009ooncO`03o`000?ooYWooojIo00GoojIo00?o0000oonMOoooWGl00oooWGl01Ol0
003ooiMooonGOoooUgoo000000?ooi9o00Co0000oon?OoooSgoo00000_ooS7l4o`000003oon8Ool0
003o000000Soogmo00Go0000oon8Ool0003o0000oon9O`02o`000006oon<Ool0003oohmoo`000?oo
TWoo00000_ooUgl01?l0003ooieooonMOol00002oonVO`;o00003_noOol5ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_ooool?okmoo`;o00000_oo/gl01?l0003oojIooonVOoooYWl2
o`0000?ooieo00?o0000oonGOoooUgl00_ooUgl00ol0003ooi9ooonBO`0@oonBO`03o`000?ooUgoo
oiMo00CooiMo00?o0000oonMOoooWGl01?ooWGl00ol0003oojIooonVO`05oonVO`;o00002Ooo/gl2
o`00013oolEo0ol0000_oooNO`?o00003oooaGl2o`0000Wook=o0_l00006oonVO`03o`000?ooWGoo
oieo00;ooieo0_l00003oonGO`04o`000?ooTWoooi9oo`0000;oohmo0_l000001OooS7oo0000oon;
Ool0003oohUo00?o00002OooOgl5o`000008oon;Ool0003o0000o`000?ooSgoo0000oonBOol00002
oonGO`05o`000?ooWGoooieoo`000?ooYWl00_l0000>okmoo`Gooooo0Ol00001ooooo`002?ooool2
o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool00_ooool@
okmoo`?o00001?ooYWl01?l0003ooieooonMOoooWGl2o`0000CooiMo00?o0000oonBOoooTWl03ooo
TWl00ol0003ooiMooonGO`04oonGO`03o`000?ooWGoooieo00Cooieo00?o0000oonVOoooYWl01?oo
YWl3o`0000Wook=o0_l0000>ooo5O`?o0000=OoogWl2o`0000ooolEo0_l00008ooncO`;o00001_oo
YWl00ol0003ooieooonMO`02oonMO`;o00000oooUgl00ol0003ooi9ooonBO`02o`000006oon?Ool0
003o0000oon<Ool0003ooh]o1Ol00009oomoO`So000000Ooohmoo`000?ooTWoooi9oo`000?ooUgoo
000000?ooieo0_l0000?okmoo`Gooooo0Ol00001ooooo`001oooool01?l0003oooooooooool00007
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`02oooooa3o_goo0_l0
0004oonVO`03o`000?ooWGoooieo00;ooieo00?o0000oonGOoooUgl00_ooUgl00ol0003ooi9ooonB
O`0?oonBO`03o`000?ooUgoooiMo00CooiMo00?o0000oonMOoooWGl01?ooWGl00ol0003oojIooonV
O`04oonVO`;o00002Ooo/gl2o`0000ooolEo0_l0000ioooNO`?o00003_ooaGl00ol0003ook=ooonc
O`07ooncO`03o`000?ooYWooojIo00CoojIo00?o0000oonMOoooWGl00_ooWGl00ol0003ooiMooonG
O`02oonGO`03o`000?ooTWoooi9o00;o000000Coohmoo`000?l0003oohao1?l000000oooR7oo0000
o`000009oomoO`Ko000000Koohaoo`000?ooSgoo0000oonBOol00002oonGO`03o`000?ooWGoooieo
00;o00003onoOol5ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00002oooool00ol0
003oooooooooo`02ooooo`?o00000_oooolAokmoo`;o00000oooYWl01Ol0003ooieooonMOoooWGoo
000000CooiMo0_l0000@oonBO`03o`000?ooUgoooiMo00CooiMo00?o0000oonMOoooWGl01?ooWGl0
0ol0003oojIooonVO`04oonVO`;o00002Ooo/gl2o`0000koolEo0_l0000noooNO`;o00003OooaGl0
0ol0003ook=oooncO`07ooncO`;o00001OooYWl00ol0003ooieooonMO`02oonMO`03o`000?ooUgoo
oiMo00;ooiMo00?o0000oonBOoooTWl00_l000000oooSgoo0000oon<O`03o`000005oon9Ool0003o
0000oon8Ool000002?ooOgl5o`000005oon;Ool0003o0000oon?Ool000000_ooTWl00ol0003ooiMo
oonGO`03o`00013o_goo1?ooool2o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000_ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`02oooooa7o_goo0_l00002oonVO`03o`00
0?ooWGoooieo00;ooieo00?o0000oonGOoooUgl00_ooUgl00ol0003ooi9ooonBO`0>oonBO`;o0000
1OooUgl00ol0003ooieooonMO`04oonMO`03o`000?ooYWooojIo00CoojIo0_l00009ooncO`03o`00
0?ooaGooolEo00_oolEo0ol00012oooNO`;o00003?ooaGl2o`0000Sook=o0_l00005oonVO`03o`00
0?ooWGoooieo00;ooieo00Co0000oonGOoooUgoooiMo0_l00002oonBO`09o`000?ooSgooohmoo`00
0?ooS7oo0000oon;Ool0003oohUo00?o00002OooOgl6o`000004oon<Ool0003oohmoo`0000;ooi9o
00?o0000oonGOol000000_l0000@okmoo`Gooooo0Ol00001ooooo`001oooool01?l0003ooooooooo
ool00007ooooo`Co00001Oooool00ol0003oooooooooo`02oooooa;o_goo0_l000000oooYWoo0000
oonMO`02oonMO`03o`000?ooUgoooiMo00;ooiMo00?o0000oonBOoooTWl03_ooTWl2o`0000GooiMo
00?o0000oonMOoooWGl01?ooWGl00ol0003oojIooonVO`04oonVO`;o00002Ooo/gl00ol0003oolEo
ooo5O`0:ooo5O`;o0000AooogWl2o`0000coolEo00?o0000ooncOooo/gl01_oo/gl2o`0000GoojIo
00?o0000oonMOoooWGl00_ooWGl2o`0000?ooiMo00Co0000oonBOoooTWoo00000_ooSgl01?l0003o
ohaoo`000?ooRgl2o`000003oon8Ool0003o000000Woogmo1?l000002OooRgoo0000oon<Ool0003o
ohmoo`000?ooTWoo0000oonGO`02o`00017o_goo1Oooool1o`00007ooooo0007ooooo`04o`000?oo
ooooooooo`0000Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02oooooa?o_goo
0_l00004oonMO`04o`000?ooUgoooiMooonGO`;o00003oooTWl2o`0000GooiMo00?o0000oonMOooo
WGl01?ooWGl00ol0003oojIooonVO`04oonVO`;o00002?oo/gl2o`0000_oolEo0_l0000MoooNOa7o
00007OoogWl2o`0000_oolEo00?o0000ooncOooo/gl01_oo/gl2o`0000GoojIo00?o0000oonMOooo
WGl00_ooWGl01?l0003ooiMooonGOoooUgl2o`0000;ooi9o00Oo0000oon?OoooSgoo0000oon<Ool0
003ooh]o00;o000000?oohQoo`000?l000002?ooOgl5o`000005oon;Ool0003o0000oon?Ool00000
0_ooTWl3o`00017o_goo1Oooool1o`00007ooooo0008ooooo`;o00002?ooool5o`0000Cooooo00?o
0000ooooooooool00_oooolCokmoo`;o00000oooWGl00ol0003ooiMooonGO`02oonGO`03o`000?oo
TWoooi9o00gooi9o0_l00005oonGO`03o`000?ooWGoooieo00Cooieo00?o0000oonVOoooYWl01?oo
YWl00ol0003ook=oooncO`07ooncO`03o`000?ooaGooolEo00[oolEo0_l0000HoooNO`Ko00004Oon
ogl7o`0001Soomio00?o0000ooo5OoooaGl02OooaGl2o`0000Oook=o0_l00005oonVO`03o`000?oo
WGoooieo00;ooieo00Co0000oonGOoooUgoooiMo0_l00002oonBO`03o`000?ooSgoo000000;oohao
0_l000001?ooRGoo0000o`000?l00009oomoO`?o000000SoohUoo`000?l0003oohaoo`000?ooSgoo
0000oonBO`;o00004_noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolD
okmoo`;o000000?ooieoo`000?ooUgl00oooUgl2o`0000oooi9o00?o0000oonGOoooUgl00oooUgl0
0ol0003ooieooonMO`04oonMO`03o`000?ooYWooojIo00CoojIo00?o0000ooncOooo/gl01ooo/gl0
0ol0003oolEoooo5O`09ooo5O`;o00005_oogWl4o`0001koo_mo0ol0000FoooNO`;o00002oooaGl2
o`0000Oook=o00?o0000oonVOoooYWl00oooYWl00ol0003ooieooonMO`02oonMO`05o`000?ooUgoo
oiMooonGOol000000_ooTWl2o`000007oon?Ool0003oohaoo`000?ooRgoo0000oon9O`03o`0000Wo
ogmo1?l000001OooRgoo0000oon<Ool0003oohmo00;o00004onoOol5ooooo`7o00000Oooool001_o
oooo00?o0000ooooooooool00_oooolDokmoo`;o000000?ooieoo`000?ooUgl00oooUgl00ol0003o
oi9ooonBO`0=oonBO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonMOoooWGl01?ooWGl00ol0003o
ojIooonVO`04oonVO`03o`000?oo/goook=o00Kook=o0_l0000;ooo5O`03o`000?oogWooomio01?o
omio0ol0000UookoO`Co00005?oogWl00ol0003oolEoooo5O`09ooo5O`;o00001ooo/gl00ol0003o
ojIooonVO`03oonVO`03o`000?ooWGoooieo00;ooieo0_l00002oonGO`04o`000?ooTWoooi9oo`00
00;oohmo00Co0000oon<Ool0003ooh]o1Ol00009oomoO`Co000000Cooh]oo`000?l0003oohmo0_l0
000Cokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooaGo_goo0_l00004
oonGO`03o`000?ooTWoooi9o00gooi9o00?o0000oonGOoooUgl00oooUgl2o`0000Gooieo00?o0000
oonVOoooYWl01?ooYWl00ol0003ook=oooncO`06ooncO`03o`000?ooaGooolEo00WoolEo0_l0000C
oooNO`?o0000;?onogl2o`0001?oomio0_l0000:ooo5O`;o00001ooo/gl00ol0003oojIooonVO`03
oonVO`03o`000?ooWGoooieo00;ooieo00Go0000oonGOoooUgoooiMoo`000002oonBO`07o`000?oo
Sgooohmoo`000?ooS7oo0000oon;O`05o`0000Soogmo0ol000001?ooRGoo0000o`000?ooS7l2o`00
01Co_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo5_noOol2o`0000?o
oiMo00?o0000oonBOoooTWl03?ooTWl00ol0003ooiMooonGO`03oonGO`03o`000?ooWGoooieo00Co
oieo00?o0000oonVOoooYWl01?ooYWl00ol0003ook=oooncO`06ooncO`03o`000?ooaGooolEo00Wo
olEo00?o0000oooNOooogWl04OoogWl2o`00037oo_mo0ol0000BoooNO`03o`000?ooaGooolEo00Wo
olEo00?o0000ooncOooo/gl01Ooo/gl00ol0003oojIooonVO`03oonVO`03o`000?ooWGoooieo00;o
oieo00Go0000oonGOoooUgoooiMoo`000002oonBO`05o`000?ooSgooohmoo`000?ooS7l00_l00000
1?ooRGoo0000o`000?l00009oomoO`Co000000?ooh]oo`000?l000005OnoOol5ooooo`7o00000Ooo
ool001_ooooo00?o0000ooooooooool00_oooolFokmoo`;o00000_ooUgl00ol0003ooi9ooonBO`0<
oonBO`03o`000?ooUgoooiMo00?ooiMo0_l00005oonMO`03o`000?ooYWooojIo00CoojIo00?o0000
ooncOooo/gl01_oo/gl00ol0003oolEoooo5O`09ooo5O`03o`000?oogWooomio013oomio0_l0000f
ookoO`;o00004OoogWl2o`0000[oolEo00?o0000ooncOooo/gl01Ooo/gl00ol0003oojIooonVO`03
oonVO`03o`000?ooWGoooieo00;ooieo00Go0000oonGOoooUgoooiMoo`000002oonBO`08o`000?oo
Sgoo0000oon<Ool0003ooh]oo`000?ooRGl3o`0000Woogmo1_l0000Eokmoo`Gooooo0Ol00001oooo
o`006oooool00ol0003oooooooooo`02oooooaOo_goo1?l0000=oonBO`03o`000?ooUgoooiMo00Co
oiMo00?o0000oonMOoooWGl00oooWGl00ol0003oojIooonVO`04oonVO`03o`000?oo/goook=o00Ko
ok=o00?o0000ooo5OoooaGl02?ooaGl2o`00013oomio0ol0000jookoO`?o00003ooogWl2o`0000[o
olEo00?o0000ooncOooo/gl01Ooo/gl00ol0003oojIooonVO`02oonVO`;o00001?ooWGl01?l0003o
oiMooonGOol00003oonBO`06o`000?ooSgoo0000oon<Ool0003ooh]o1Ol00008oomoO`;o000000?o
ohQoo`000?l000005_noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolH
okmoo`?o00003OooTWl00ol0003ooiMooonGO`03oonGO`03o`000?ooWGoooieo00?ooieo0_l00005
oonVO`03o`000?oo/goook=o00Gook=o0_l0000:ooo5O`03o`000?oogWooomio00koomio0ol0000o
ookoO`;o00003ooogWl2o`0000WoolEo00?o0000ooncOooo/gl01?oo/gl2o`0000CoojIo0_l00004
oonMO`04o`000?ooUgoooiMoo`0000;ooi9o00Go0000oon?OoooSgoo0000oon<O`07o`0000Soogmo
0ol0000Gokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooaWo_goo0_l0
000<oonBO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonMOoooWGl00oooWGl00ol0003oojIooonV
O`04oonVO`03o`000?oo/goook=o00Gook=o00?o0000ooo5OoooaGl02?ooaGl2o`0000ooomio0ol0
0013ookoO`;o00003_oogWl2o`0000WoolEo00?o0000ooncOooo/gl01?oo/gl2o`0000GoojIo00Go
0000oonMOoooWGoooieoo`000003oonGO`05o`000?ooTWoooi9oo`000?ooSgl02Ol00008oomoO`;o
00006?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolIokmoo`?o0000
2_ooTWl00ol0003ooiMooonGO`03oonGO`03o`000?ooWGoooieo00?ooieo00?o0000oonVOoooYWl0
1?ooYWl00ol0003ook=oooncO`05ooncO`03o`000?ooaGooolEo00SoolEo0_l0000>oooNO`;o0000
B?onogl00ol0003oomiooooNO`0<oooNO`;o00002OooaGl00ol0003ook=oooncO`04ooncO`;o0000
1OooYWl01Ol0003ooieooonMOoooWGoo000000?ooiMo00Wo0000oonBOoooTWoo0000oon?Ool0003o
ohaoo`000?ooRgl01Ol00007oomoO`;o00006?noOol5ooooo`7o00000Oooool001_ooooo0_l00003
oooooa[o_goo0ol00008oonBO`03o`000?ooUgoooiMo00?ooiMo00?o0000oonMOoooWGl00oooWGl0
0ol0003oojIooonVO`04oonVO`;o00001_oo/gl00ol0003oolEoooo5O`08ooo5O`;o00003OoogWl2
o`0004_oo_mo0_l0000>oooNO`03o`000?ooaGooolEo00OoolEo00?o0000ooncOooo/gl01?oo/gl2
o`0000GoojIo00Go0000oonMOoooWGoooieoo`000003oonGO`07o`000?ooTWoo0000o`000?ooSgoo
0000oon<O`04o`000003oon8Ool0003o000000Googmo0_l0000Iokmoo`Cooooo0_l00001ooooo`00
6oooool00ol0003oooooooooo`02oooooa_o_goo0ol00006oonBO`;o00001?ooUgl00ol0003ooieo
oonMO`03oonMO`;o00001OooYWl2o`0000Kook=o00?o0000ooo5OoooaGl01oooaGl3o`0000goomio
00?o0000ookoOoonogl0COonogl2o`0000goomio0_l00008ooo5O`03o`000?oo/goook=o00Cook=o
0_l00004oonVO`03o`000?ooWGoooieo00;ooieo00?o0000oonGOoooUgl00_l000001?ooTWoo0000
oon?OoooSgl8o`0000Coogmo0_l0000Jokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003ooooo
ooooo`02oooooaco_goo0_l00005oonBO`;o00001OooUgl00ol0003ooieooonMO`02oonMO`03o`00
0?ooYWooojIo00CoojIo0_l00006ooncO`;o00002?ooaGl00ol0003oomiooooNO`0<oooNO`;o0000
7_onoglFo`0001koo_mo0_l0000=oooNO`03o`000?ooaGooolEo00KoolEo0_l00005ooncO`;o0000
1?ooYWl00ol0003ooieooonMO`02oonMO`04o`000?ooUgoooiMoo`0000;ooi9o00?o0000oon?Ool0
00001?l000001?ooRGoo0000o`000?l00002oomoO`;o00006onoOol5ooooo`7o00000Oooool001_o
oooo00?o0000ooooooooool00_oooolLokmoo`?o00000oooTWl2o`0000GooiMo00?o0000oonMOooo
WGl00oooWGl00ol0003oojIooonVO`03oonVO`;o00001_oo/gl2o`0000SoolEo00?o0000oooNOooo
gWl02ooogWl2o`0001_oo_mo1Ol0000FolkoO`Go00006_onogl2o`0000goomio00?o0000ooo5Oooo
aGl01_ooaGl2o`0000Gook=o0_l00004oonVO`04o`000?ooWGoooieooonMO`;o00000_ooUgl02Ol0
003ooi9ooonBOol0003oohmoo`000?ooS7oo0000oon;O`02o`000004oon8Ool0003o0000oomoO`;o
00006onoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolLokmoo`Co0000
0_ooTWl00ol0003ooiMooonGO`03oonGO`03o`000?ooWGoooieo00?ooieo00?o0000oonVOoooYWl0
1?ooYWl00ol0003ook=oooncO`05ooncO`03o`000?ooaGooolEo00KoolEo00?o0000oooNOooogWl0
2ooogWl2o`0001Soo_mo1?l0000PolkoO`Co00006?onogl00ol0003oomiooooNO`0;oooNO`03o`00
0?ooaGooolEo00KoolEo00?o0000ooncOooo/gl01?oo/gl00ol0003oojIooonVO`03oonVO`05o`00
0?ooWGoooieooonMOol000000_ooUgl02?l0003ooi9ooonBOol0003oohmoo`000?ooS7oo00000_oo
Rgl7o`0001_o_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo7OnoOol4
o`000003oonBOol0003ooiMo00CooiMo00?o0000oonMOoooWGl00_ooWGl2o`0000CoojIo0_l00007
ooncO`03o`000?ooaGooolEo00KoolEo0_l0000<oooNO`;o00005_onogl4o`0002Koc_mo1?l0000F
ookoO`03o`000?oogWooomio00[oomio0_l00008ooo5O`03o`000?oo/goook=o00Cook=o00?o0000
oonVOoooYWl00_ooYWl01?l0003ooieooonMOoooWGl2o`0000;ooiMo00Oo0000oonBOoooTWoo0000
oon?Ool0003oohao00So00007?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool0
0_oooolOokmoo`?o00001OooUgl00ol0003ooieooonMO`03oonMO`03o`000?ooYWooojIo00?oojIo
00?o0000ooncOooo/gl01Ooo/gl00ol0003oolEoooo5O`06ooo5O`;o00003?oogWl00ol0003oo_mo
ookoO`0DookoO`?o0000;Oo>ogl2o`0001Goo_mo0_l0000;oooNO`;o00002?ooaGl00ol0003ook=o
ooncO`03ooncO`;o00001?ooYWl01Ol0003ooieooonMOoooWGoo000000?ooiMo00Oo0000oonBOooo
TWoo0000oon?Ool0003oohao00Ko00007OnoOol5ooooo`7o00000Oooool001_ooooo00?o0000oooo
ooooool00_oooolPokmoo`;o00001?ooUgl00ol0003ooieooonMO`03oonMO`03o`000?ooYWooojIo
00?oojIo00?o0000ooncOooo/gl01Ooo/gl00ol0003oolEoooo5O`06ooo5O`;o00003?oogWl00ol0
003oo_moookoO`0BookoO`?o0000<_o>ogl3o`0001Coo_mo00?o0000oooNOooogWl02_oogWl00ol0
003oolEoooo5O`06ooo5O`03o`000?oo/goook=o00?ook=o0_l00004oonVO`05o`000?ooWGoooieo
oonMOol000000_ooUgl01?l0003ooi9ooonBOol00002oon?O`03o`000?ooS7oo000000?o00007_no
Ool5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolQokmoo`?o000000?ooiMo
o`000?ooWGl01?ooWGl00ol0003oojIooonVO`03oonVO`;o00001_oo/gl00ol0003oolEoooo5O`06
ooo5O`;o00002ooogWl2o`0001?oo_mo0_l0000holkoO`;o00004oonogl00ol0003oomiooooNO`0:
oooNO`03o`000?ooaGooolEo00KoolEo00?o0000ooncOooo/gl00ooo/gl2o`0000CoojIo00Go0000
oonMOoooWGoooieoo`000002oonGO`05o`000?ooTWoooi9oo`000?ooSgl01Ol0000Ookmoo`Gooooo
0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooob;o_goo0_l000000oooUgoo0000oonM
O`03oonMO`03o`000?ooYWooojIo00?oojIo0_l00006ooncO`03o`000?ooaGooolEo00KoolEo00?o
0000oooNOooogWl02_oogWl00ol0003oo_moookoO`0AookoO`;o0000??o>ogl3o`00017oo_mo0_l0
000;oooNO`03o`000?ooaGooolEo00GoolEo0_l00005ooncO`;o00000oooYWl00ol0003ooieooonM
O`02oonMO`04o`000?ooUgoooiMoo`0000;ooi9o00?o0000oon?Ool000000_l0000Pokmoo`Gooooo
0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooob?o_goo0ol00004oonMO`03o`000?oo
YWooojIo00;oojIo0_l00006ooncO`03o`000?ooaGooolEo00KoolEo00?o0000oooNOooogWl02_oo
gWl00ol0003oo_moookoO`0@ookoO`;o0000@?o>ogl3o`00017oo_mo0_l0000:oooNO`03o`000?oo
aGooolEo00GoolEo0_l00005ooncO`03o`000?ooYWooojIo00;oojIo00Go0000oonMOoooWGoooieo
o`000003oonGO`03o`000?ooTWoo000000?o00008OnoOol5ooooo`7o00000Oooool001_ooooo00?o
0000ooooooooool00_oooolTokmoo`;o00000oooWGl00ol0003oojIooonVO`03oonVO`03o`000?oo
/goook=o00Cook=o00?o0000ooo5OoooaGl01_ooaGl00ol0003oomiooooNO`0:oooNO`03o`000?on
ogooo_mo00ooo_mo0_l00014olkoO`;o00004Oonogl2o`0000[oomio00?o0000ooo5OoooaGl01Ooo
aGl00ol0003ook=oooncO`04ooncO`03o`000?ooYWooojIo00;oojIo00Go0000oonMOoooWGoooieo
o`000002oonGO`03o`000?ooTWoo000000;o00008_noOol5ooooo`7o00000Oooool001_ooooo00?o
0000ooooooooool00_oooolTokmoo`;o00000_ooWGl00ol0003oojIooonVO`03oonVO`03o`000?oo
/goook=o00Cook=o0_l00007ooo5O`03o`000?oogWooomio00Woomio0_l0000@ookoO`;o0000B?o>
ogl2o`00013oo_mo0_l0000:oooNO`03o`000?ooaGooolEo00GoolEo0_l00005ooncO`03o`000?oo
YWooojIo00;oojIo00Go0000oonMOoooWGoooieoo`000002oonGO`?o00008onoOol5ooooo`7o0000
0Oooool001_ooooo0_l00003ooooobGo_goo0ol00005oonVO`03o`000?oo/goook=o00Cook=o0_l0
0007ooo5O`03o`000?oogWooomio00Soomio0ol0000?ookoO`;o0000C?o>ogl2o`00013oo_mo00?o
0000oooNOooogWl02?oogWl00ol0003oolEoooo5O`05ooo5O`;o00001Ooo/gl00ol0003oojIooonV
O`02oonVO`06o`000?ooWGoooieooonMOol0003ooiMo0ol0000Sokmoo`Cooooo0_l00001ooooo`00
6oooool00ol0003oooooooooo`02ooooobKo_goo0_l00004oonVO`03o`000?oo/goook=o00Cook=o
0_l00007ooo5O`03o`000?oogWooomio00Soomio0_l0000@ookoO`03o`000?o>ogooc_mo04koc_mo
00?o0000ookoOoonogl03_onogl00ol0003oomiooooNO`08oooNO`03o`000?ooaGooolEo00GoolEo
00?o0000ooncOooo/gl00ooo/gl00ol0003oojIooonVO`02oonVO`04o`000?ooWGoooieooonMO`Co
00009?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolWokmoo`?o0000
0_ooYWl00ol0003ook=oooncO`03ooncO`;o00001oooaGl00ol0003oomiooooNO`08oooNO`;o0000
3oonogl2o`0005;oc_mo0_l0000?ookoO`03o`000?oogWooomio00Soomio00?o0000ooo5OoooaGl0
1OooaGl00ol0003ook=oooncO`03ooncO`03o`000?ooYWooojIo00;oojIo00?o0000oonMOol00000
0ol0000Uokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooobSo_goo1?l0
0005ooncO`;o00001oooaGl00ol0003oomiooooNO`08oooNO`03o`000?onogooo_mo00koo_mo00?o
0000olkoOoo>ogl0E?o>ogl00ol0003oo_moookoO`0=ookoO`03o`000?oogWooomio00Soomio00?o
0000ooo5OoooaGl01OooaGl00ol0003ook=oooncO`03ooncO`04o`000?ooYWooojIooonVO`Co0000
9onoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooolZokmoo`;o00001Ooo
/gl00ol0003oolEoooo5O`05ooo5O`;o00002OoogWl00ol0003oo_moookoO`0=ookoO`;o00008Oo>
oglGo`00023oc_mo0_l0000>ookoO`03o`000?oogWooomio00Soomio00?o0000ooo5OoooaGl01Ooo
aGl00ol0003ook=oooncO`03ooncO`03o`000?ooYWooojIo00;o0000:OnoOol5ooooo`7o00000Ooo
ool001_ooooo00?o0000ooooooooool00_ooool[okmoo`;o00000ooo/gl00ol0003oolEoooo5O`05
ooo5O`;o00002OoogWl00ol0003oo_moookoO`0=ookoO`03o`000?o>ogooc_mo01coc_mo1Ol0000G
oh[oO`Go00007Oo>ogl00ol0003oo_moookoO`0<ookoO`03o`000?oogWooomio00Ooomio0_l00007
ooo5O`03o`000?oo/goook=o00?ook=o0ol0000Zokmoo`Gooooo0Ol00001ooooo`006oooool00ol0
003oooooooooo`02ooooobco_goo0_l000000ooo/goo0000ooo5O`06ooo5O`;o00002OoogWl00ol0
003oo_moookoO`0<ookoO`;o00006oo>ogl4o`00027oR_mo0ol0000KolkoO`;o00003Oonogl2o`00
00Soomio0_l00006ooo5O`03o`000?oo/goook=o00?ook=o0_l0000[okmoo`Gooooo0Ol00001oooo
o`006oooool00ol0003oooooooooo`02ooooobgo_goo0ol00006ooo5O`;o00002OoogWl00ol0003o
o_moookoO`0<ookoO`;o00006Oo>ogl3o`0002SoR_mo0ol0000IolkoO`;o00003Oonogl2o`0000So
omio0_l00006ooo5O`04o`000?oo/goook=oooncO`;o0000;?noOol5ooooo`7o00000Oooool001_o
oooo00?o0000ooooooooool00_ooool^okmoo`;o00001_ooaGl00ol0003oomiooooNO`07oooNO`03
o`000?onogooo_mo00coo_mo00?o0000olkoOoo>ogl05oo>ogl2o`0002koR_mo0ol0000HolkoO`;o
00003?onogl2o`0000Woomio00?o0000ooo5OoooaGl01?ooaGl01?l0003ook=oo`000?l0000]okmo
o`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooboo_goo0ol00003ooo5O`03
o`000?oogWooomio00Ooomio00?o0000ookoOoonogl02oonogl2o`0001Ooc_mo0ol0000coh[oO`;o
00005oo>ogl2o`0000coo_mo0_l00009oooNO`03o`000?ooaGooolEo00?oolEo0ol0000^okmoo`Go
oooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooooc3o_goo0ol000000oooaGoo0000
oooNO`08oooNO`03o`000?onogooo_mo00_oo_mo0_l0000FolkoO`;o0000>?n:ogl3o`0001Koc_mo
00?o0000ookoOoonogl02_onogl2o`0000Soomio00?o0000ooo5OoooaGl00_ooaGl3o`0002oo_goo
1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo<_noOol2o`0000Woomio00?o
0000ookoOoonogl02oonogl2o`0001Coc_mo0ol0000moh[oO`;o00005Oo>ogl00ol0003oo_moooko
O`0:ookoO`;o00002?oogWl00ol0003oolEoooo5O`02o`00037o_goo1Oooool1o`00007ooooo000K
ooooo`03o`000?oooooooooo00;ooooo<onoOol00ol0003oomiooooNO`07oooNO`03o`000?onogoo
o_mo00[oo_mo0_l0000DolkoO`;o0000@On:ogl2o`0001Coc_mo0_l0000;ookoO`03o`000?oogWoo
omio00Ooomio0ol0000bokmoo`Gooooo0Ol00001ooooo`006oooool2o`0000?ooooo=?noOol3o`00
00Goomio00?o0000ookoOoonogl02Oonogl2o`0001Coc_mo0_l00014oh[oO`?o00004oo>ogl2o`00
00_oo_mo00?o0000oooNOooogWl01_oogWl3o`0003;o_goo1?ooool2o`00007ooooo000Kooooo`03
o`000?oooooooooo00;ooooo=OnoOol4o`0000;oomio00?o0000ookoOoonogl02Oonogl2o`0001?o
c_mo0_l00018oh[oO`;o00004oo>ogl2o`0000_oo_mo00?o0000oooNOooogWl01?oogWl3o`0003?o
_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo=onoOol4o`0000_oo_mo
0_l0000BolkoO`?o0000Bon:ogl2o`0001;oc_mo0_l0000;ookoO`03o`000?oogWooomio00;oomio
0_l0000eokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooocSo_goo0ol0
000:ookoO`;o00004_o>ogl2o`0004ooR_mo0_l0000AolkoO`;o00002oonogl5o`0003Ko_goo1Ooo
ool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo>OnoOol3o`0000Soo_mo0_l0000A
olkoO`;o0000D_n:ogl2o`00017oc_mo0_l0000:ookoO`Co0000=onoOol5ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_oooolkokmoo`?o00001Oonogl2o`00017oc_mo00?o0000oh[o
Oon:ogl0E?n:ogl00ol0003oc_moolkoO`0@olkoO`03o`000?onogooo_mo00Goo_mo0ol0000jokmo
o`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooocco_goo1?l00002ookoO`;o
00004?o>ogl2o`0005SoR_mo0_l0000AolkoO`03o`000?onogooo_mo00;oo_mo1?l0000kokmoo`Go
oooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02ooooocko_goo1?l0000AolkoO`03o`00
0?n:ogooR_mo05[oR_mo00?o0000olkoOoo>ogl03oo>ogl00ol0003oo_moookoO`03o`0003go_goo
1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo@?noOol3o`0000ooc_mo00?o
0000oh[oOon:ogl09_n:ogl>o`0002SoR_mo0_l0000@olkoO`?o0000?onoOol5ooooo`7o00000Ooo
ool001_ooooo00?o0000ooooooooool00_oooom1okmoo`Co00002oo>ogl2o`0002;oR_mo1ol0000>
ogood`Oo00008on:ogl00ol0003oc_moolkoO`0;olkoO`Co0000@?noOol5ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_oooom3okmoo`Co00002?o>ogl00ol0003oR_mooh[oO`0Noh[o
O`Co00007?moom<4o`00023oR_mo00?o0000olkoOoo>ogl02?o>ogl4o`0004;o_goo1Oooool1o`00
007ooooo000Kooooo`03o`000?oooooooooo00;oooooAOnoOol4o`0000Goc_mo00?o0000oh[oOon:
ogl07?n:ogl3o`0002CoOooC1?l0000Moh[oO`;o00001_o>ogl4o`0004Co_goo1Oooool1o`00007o
oooo000Kooooo`03o`000?oooooooooo00;oooooAonoOol7o`0001coR_mo0ol0000[ogood`;o0000
7On:ogl01?l0003oc_moolkoOoo>ogl4o`0004Ko_goo1Oooool1o`00007ooooo000Kooooo`;o0000
0ooooom:okmoo`Co00006_n:ogl2o`00033oOooC0ol0000Koh[oO`Go0000B?noOol4ooooo`;o0000
0Oooool001_ooooo00?o0000ooooooooool00_oooom<okmoo`Co00005_n:ogl2o`0003GoOooC0_l0
000Hoh[oO`Co0000B_noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooom>
okmoo`Go00004?n:ogl3o`0003WoOooC0ol0000Aoh[oO`Ko0000C?noOol5ooooo`7o00000Oooool0
01_ooooo00?o0000ooooooooool00_oooom@okmoo`Go00003?n:ogl2o`0003ooOooC0_l0000=oh[o
O`Go0000ConoOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooomCokmoo`Go
00001on:ogl3o`0004;oOooC0_l00008oh[oO`Go0000D_noOol5ooooo`7o00000Oooool001_ooooo
00?o0000ooooooooool00_oooomEokmoo`Ko00000_n:ogl2o`0004OoOooC0_l00003oh[oO`Ko0000
E?noOol5ooooo`7o00000Oooool001_ooooo00?o0000ooooooooool00_oooomHokmoo`Go0000Bomo
om<6o`0005Oo_goo1Oooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;oooooFonoOol4
o`0004SoOooC1?l0001Jokmoo`Gooooo0Ol00001ooooo`006oooool00ol0003oooooooooo`02oooo
oeko_goo1Ol00011ogood`Co0000GOnoOol5ooooo`7o00000Oooool001_ooooo00?o0000oooooooo
ool00_oooomRokmoo`Go0000>?moom<6o`00063o_goo1Oooool1o`00007ooooo000Cooooo`?o0000
1Oooool00ol0003oooooooooo`02ooooof?o_goo2Ol0000^ogood`[o0000HOnoOol5ooooo`7o0000
0Oooool001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooofOo_goo2ol0
000Rogood`_o0000I_noOol5ooooo`7o00000Oooool001Cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`02ooooofco_goo;_l0001[okmoo`Gooooo0Ol00001ooooo`005?ooool00ol0
003oooooooooo`04ooooo`?o00000_oooombokmoob;o0000LOnoOol4ooooo`;o00000Oooool001Co
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooo`gooooo0Ol00001ooooo`00
4oooool2o`0000Kooooo00?o0000ooooooooool0ooooool=ooooo`7o00000Oooool001Cooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo03kooooo00?o
0000ooooooooool0?oooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo03kooooo00?o
0000ooooooooool00_ooool1o`00007ooooo000Kooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo0Ol00001
ooooo`006oooooooo`00017o00000Oooool00?oooooo;Oooool00?oooooo;Oooool00?oooooo;Ooo
ool00?oooooo;Oooool00?oooooo;Oooool00?oooooo;Oooool00?oooooo;Oooool00001\
\>"],
  ImageRangeCache->{{{0, 299}, {299, 0}} -> {-1.24989, -1.19291, 0.00766174, \
0.00766174}},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "Here we minimize the function inside the unit disk using ",
  StyleBox["NMinimize", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{100 \((y - x\^2)\)\^2 + \((1 - x)\)\^2, \ 
        x\^2 + y\^2 \[LessEqual] 1}, {x, y}]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.04567480849953801`, {x \[Rule] 0.7864151546826511`, 
        y \[Rule] 0.6176983133341889`}}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "Here we minimize the function inside the unit disk using ",
  StyleBox["Minimize", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Minimize[{100 \((y - x\^2)\)\^2 + \((1 - x)\)\^2, \ 
        x\^2 + y\^2 \[LessEqual] 1}, {x, y}]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({Root[
        6544214292004000000 - 144368235817268120000\ #1 + 
            24470854590692601200\ #1\^2 - 13682324808464174004\ #1\^3 + 
            6947692863550867001\ #1\^4 - 216684553251678400\ #1\^5 + 
            2560711072960000\ #1\^6 - 13311744000000\ #1\^7 + 
            25600000000\ #1\^8 &, 
        1], {x \[Rule] 
          Root[\(-1\) - 198\ #1 + 30200\ #1\^2 + 598\ #1\^3 - 70599\ #1\^4 - 
                400\ #1\^5 + 10400\ #1\^6 + 40000\ #1\^8 &, 5], 
        y \[Rule] 
          Root[\(-10000\) - 20200\ #1 + 59800\ #1\^2 + 120800\ #1\^3 - 
                99399\ #1\^4 - 220600\ #1\^5 + 9600\ #1\^6 + 120000\ #1\^7 + 
                40000\ #1\^8 &, 4]}}\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Minimize", "MR"],
  " answer is numerically the same as the ",
  StyleBox["NMinimize", "MR"],
  " answer."
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.04567480871950023`, {x \[Rule] 0.7864151541684276`, 
        y \[Rule] 0.6176983125233911`}}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DifferentialEvolution", "SubsubsectionIcon",
  CellGroupingRules->{"SectionGrouping", 73},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  StyleBox["DifferentialEvolution", "MR"],
  " is a genetic algorithm that maintains a population of specimens, ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1, \[Ellipsis], x\_n\)], "InlineFormula"],
  ", represented as vectors of real numbers (\[OpenCurlyDoubleQuote]genes\
\[CloseCurlyDoubleQuote]). Every iteration, each ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)], "InlineFormula"],
  " chooses random integers ",
  Cell[BoxData[
      \(TraditionalForm\`a\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`b\)], "InlineFormula"],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`c\)], "InlineFormula"],
  " and constructs the mate ",
  Cell[BoxData[
      \(TraditionalForm\`y\_i = x\_a + \[Gamma](x\_b - x\_c)\)], 
    "InlineFormula"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)], "InlineFormula"],
  " is the value of ",
  StyleBox["ScalingFactor", "MR"],
  ". Then ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)], "InlineFormula"],
  " is mated with ",
  Cell[BoxData[
      \(TraditionalForm\`y\_i\)], "InlineFormula"],
  " according to the value of ",
  StyleBox["CrossProbability", "MR"],
  ", giving us the child ",
  Cell[BoxData[
      \(TraditionalForm\`z\_i\)], "InlineFormula"],
  ". At this point ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)], "InlineFormula"],
  " competes against ",
  Cell[BoxData[
      \(TraditionalForm\`z\_i\)], "InlineFormula"],
  " for the position of ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)], "InlineFormula"],
  " in the population. The default value of ",
  StyleBox["SearchPoints", "MR"],
  " is ",
  StyleBox["Automatic", "MR"],
  ", which is ",
  StyleBox["Min[10*d,", "MR"],
  " ",
  StyleBox["50]", "MR"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`d\)], "InlineFormula"],
  " is the number of variables. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  StyleBox["DifferentialEvolution", "MR"],
  " is quite robust, but generally slower than other methods due to the \
relatively large set of points it maintains. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "Here we minimize the function inside the unit disk using ",
  StyleBox["DifferentialEvolution", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{100\ \((y - x\^2)\)\^2 + \((1 - x)\)\^2, 
        x\^2 + y\^2 \[LessEqual] 1}, {x, y}, 
      Method \[Rule] "\<DifferentialEvolution\>"]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.04567480849953801`, {x \[Rule] 0.7864151546826511`, 
        y \[Rule] 0.6176983133341889`}}\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "SO10"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "SO10"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"CrossProbability\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"0.5\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  
                  RowBox[{"\<\"probability that a gene is taken from \"\>", 
                    Cell[BoxData[
                        \(TraditionalForm\`x\_i\)], 
                      "InlineFormula"], "\<\" \"\>"}], TraditionalForm]]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"InitialPoints\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"set of initial points "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"PenaltyFunction\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`function\ applied\ to\ constraints\ to\ \
penalize\ invalid\ points\)]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"\\\"PostProcess\\\"\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"\<whether to post\[Hyphen]process using \
local search methods \>"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"RandomSeed\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"0\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`starting\ value\ for\ the\ random\ number\ \
generator\)]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"\\\"ScalingFactor\\\"\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"0.6\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"scale applied to the difference vector in \
creating a mate "\)]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"\\\"SearchPoints\\\"\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"size of the population used for evolution \
"\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"Tolerance\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"0.001\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"tolerance for accepting constraint \
violations "\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  StyleBox["DifferentialEvolution", "MR"],
  " specific options. "
}], "Caption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "The following constrained optimization problem has a global minimum of ",
  Cell[BoxData[
      \(TraditionalForm\`7.667180068813135`\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell["Clear[f,c,v,x1,x2,y1,y2,y3]", "Input",
  CellLabel->"In[22]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[{
    \(\(f = 
        2\ x1 + 3\ x2 + \(3\ y1\)\/2 + 2\ y2 - 
          y3\/2;\)\), "\[IndentingNewLine]", 
    \(\(c = {x1\^2 + y1 == 5\/4, x2\^\(3/2\) + \(3\ y2\)\/2 == 3, 
          x1 + y1 \[LessEqual] 8\/5, \(4\ x2\)\/3 + y2 \[LessEqual] 3, 
          y3 \[LessEqual] y1 + y2, 0 \[LessEqual] x1 \[LessEqual] 10, 
          0 \[LessEqual] x2 \[LessEqual] 10, 
          0 \[LessEqual] y1 \[LessEqual] 1, 0 \[LessEqual] y2 \[LessEqual] 1, 
          0 \[LessEqual] y3 \[LessEqual] 1, {y1, y2, y3} \[Element] 
            Integers\[IndentingNewLine]};\)\), "\[IndentingNewLine]", 
    \(\(v = {x1, x2, y1, y2, y3};\)\)}], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "With the default settings for ",
  StyleBox["DifferentialEvolution", "MR"],
  ", we get an unsatisfactory solution. "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{f, c}, v, 
      Method \[Rule] "\<DifferentialEvolution\>"]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({7.667180055988436`, {x1 \[Rule] 1.118033987037397`, 
        x2 \[Rule] 1.310370693971214`, y1 \[Rule] 0, y2 \[Rule] 1, 
        y3 \[Rule] 1}}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[TextData[{
  "By adjusting ",
  StyleBox["ScalingFactor", "MR"],
  ", we get a much better result. In this case, the increased ",
  StyleBox["ScalingFactor", "MR"],
  " gives ",
  StyleBox["DifferentialEvolution", "MR"],
  " better mobility with respect to the integer variables."
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{f, \ c}, \ v, \ 
      Method \[Rule] {"\<DifferentialEvolution\>", \ "\<ScalingFactor\>" \
\[Rule] 1}]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({7.66718006522491`, {x1 \[Rule] 1.1180339883773303`, 
        x2 \[Rule] 1.3103706961567498`, y1 \[Rule] 0, y2 \[Rule] 1, 
        y3 \[Rule] 1}}\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NelderMead", "SubsubsectionIcon",
  CellGroupingRules->{"SectionGrouping", 73},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  StyleBox["NelderMead", "MR"],
  " is an implementation of the Nelder-Mead simplex algorithm. For \
simplicity, we assume here that minimization is being done. We start with the \
highest vertex, ",
  Cell[BoxData[
      \(TraditionalForm\`v\_h\)], "InlineFormula"],
  ", of a simplex, and reflect it across the centroid, ",
  Cell[BoxData[
      \(TraditionalForm\`v\_c\)], "InlineFormula"],
  ", of the remaining points to a new point, ",
  Cell[BoxData[
      \(TraditionalForm\`v\_a\)], "InlineFormula"],
  ", such that ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]v\_a - 
            v\_c\[RightDoubleBracketingBar]/\[LeftDoubleBracketingBar]v\_h - 
            v\_c\[RightDoubleBracketingBar]\)], "InlineFormula"],
  " equals the ",
  StyleBox["ReflectRatio", "MR"],
  ". "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`v\_a\)], "InlineFormula"],
  " is lower than all other vertices, we expand reflection by finding the \
point ",
  Cell[BoxData[
      \(TraditionalForm\`v\_b\)], "InlineFormula"],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]v\_b - 
            v\_a\[RightDoubleBracketingBar]/\[LeftDoubleBracketingBar]v\_a - 
            v\_c\[RightDoubleBracketingBar]\)], "InlineFormula"],
  " equals the ",
  StyleBox["ExpandRatio", "MR"],
  ". Then the lower of ",
  Cell[BoxData[
      \(TraditionalForm\`v\_a\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`v\_b\)], "InlineFormula"],
  " replaces ",
  Cell[BoxData[
      \(TraditionalForm\`v\_h\)], "InlineFormula"],
  " in the simplex and the process starts over. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`v\_a\)], "InlineFormula"],
  " is lower than the highest vertex but not lower than the lowest vertex, ",
  Cell[BoxData[
      \(TraditionalForm\`v\_a\)], "InlineFormula"],
  " replaces ",
  Cell[BoxData[
      \(TraditionalForm\`v\_h\)], "InlineFormula"],
  " and the process starts over. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "Finally, if ",
  Cell[BoxData[
      \(TraditionalForm\`v\_a\)], "InlineFormula"],
  " is the highest vertex, we construct ",
  Cell[BoxData[
      \(TraditionalForm\`v\_b\)], "InlineFormula"],
  " so that ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]v\_c - 
            v\_b\[RightDoubleBracketingBar]/\[LeftDoubleBracketingBar]v\_c - 
            v\_h\[RightDoubleBracketingBar]\)], "InlineFormula"],
  " equals the ",
  StyleBox["ContractRatio", "MR"],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`v\_b\)], "InlineFormula"],
  " is lower than ",
  Cell[BoxData[
      \(TraditionalForm\`v\_h\)], "InlineFormula"],
  ", we replace ",
  Cell[BoxData[
      \(TraditionalForm\`v\_h\)], "InlineFormula"],
  " with ",
  Cell[BoxData[
      \(TraditionalForm\`v\_b\)], "InlineFormula"],
  " and start over; otherwise, we move each of the simplex vertices, ",
  Cell[BoxData[
      \(TraditionalForm\`v\_i\)], "InlineFormula"],
  ", toward the lowest vertex ",
  Cell[BoxData[
      \(TraditionalForm\`v\_l\)], "InlineFormula"],
  ", giving new vertices, ",
  Cell[BoxData[
      \(TraditionalForm\`v\_i\%\[Prime]\)], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftDoubleBracketingBar]v\_i - 
            v\_i\%\[Prime]\[RightDoubleBracketingBar]/\
\[LeftDoubleBracketingBar]v\_i - v\_l\[RightDoubleBracketingBar]\)], 
    "InlineFormula"],
  " matches the value of ",
  StyleBox["ShrinkRatio", "MR"],
  ", and start over. "
}], "Text",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  "Here we minimize the function inside the unit disk using ",
  StyleBox["NelderMead", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{100\ \((y - x\^2)\)\^2 + \((1 - x)\)\^2, 
        x\^2 + y\^2 \[LessEqual] 1}, {x, y}, 
      Method \[Rule] "\<NelderMead\>"]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[BoxData[
    \({0.04567480849953801`, {x \[Rule] 0.7864151546826511`, 
        y \[Rule] 0.6176983133341889`}}\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->{"NMinimize:Contents", "NMinimize"}]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"option name\"\>",
                      "SO10"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"default value\"\>",
                      "SO10"], "\<\" \"\>"}], TraditionalForm]]], Cell[
            BoxData[
                \(TraditionalForm\`\[Null]\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"ContractRatio\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"0.5\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"ratio used for contraction "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"ExpandRatio\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"2.0\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"ratio used for expansion "\)]]},
          {Cell[BoxData[
                FormBox[
                  StyleBox["\<\"\\\"InitialPoints\\\"\"\>",
                    "MR"], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"set of initial points "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"PenaltyFunction\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["Automatic",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`function\ applied\ to\ constraints\ to\ \
penalize\ invalid\ points\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"PostProcess\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"Automatic\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"whether to post\[Hyphen]process using \
local search methods "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"RandomSeed\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"0\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`starting\ value\ for\ the\ random\ number\ \
generator\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"ReflectRatio\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"1.0\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"ratio used for reflection "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"ShrinkRatio\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["0.5",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"ratio used for shrinking "\)]]},
          {Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"\\\"Tolerance\\\"\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                FormBox[
                  RowBox[{
                    StyleBox["\<\"0.001\"\>",
                      "MR"], "\<\" \"\>"}], TraditionalForm]]], Cell[BoxData[
                \(TraditionalForm\`"tolerance for accepting constraint \
violations "\)]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[TextData[{
  StyleBox["NelderMead", "MR"],
  " specific options. "
}], "Caption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell["\<\
Here is a function with several local minima that are all different \
depths and are generally difficult to optimize. \
\>", "MathCaption",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[a, f]; 
    a = Reverse /@ 
        Distribute[{{\(-32\), \(-16\), 0, 16, 32}, {\(-32\), \(-16\), 0, 16, 
              32}}, List]; 
    f = 1/\((0.002 + 
            Plus @@ MapIndexed[
                1/\((#2\[LeftDoubleBracket]1\[RightDoubleBracket] + 
                        Plus @@ \((\(({x, y} - #1)\)^6)\))\) &, a])\); 
    Plot3D[f, {x, \(-50\), 50}, {y, \(-50\), 50}, PlotPoints \[Rule] 50, 
      Mesh \[Rule] False];\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->{"NMinimize:Contents", "NMinimize"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.1978e-17 1.04977 -0.0679587 1.04977 [
[.08608 .22315 -18 -8.87306 ]
[.08608 .22315 0 .12694 ]
[.20731 .17545 -17.5107 -9 ]
[.20731 .17545 .48932 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.46808 .07289 -10.673 -9 ]
[.46808 .07289 1.32698 0 ]
[.60856 .01769 -10.1726 -9 ]
[.60856 .01769 1.82736 0 ]
[.73498 .04732 0 -6.2105 ]
[.73498 .04732 18 2.7895 ]
[.79846 .14452 0 -6.11593 ]
[.79846 .14452 18 2.88407 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.90976 .31495 0 -5.95504 ]
[.90976 .31495 12 3.04496 ]
[.95881 .39008 0 -5.88604 ]
[.95881 .39008 12 3.11396 ]
[.0172 .30843 -18 -2.77893 ]
[.0172 .30843 0 6.22107 ]
[.00801 .36606 -18 -2.82781 ]
[.00801 .36606 0 6.17219 ]
[-0.00154 .42587 -18 -2.87871 ]
[-0.00154 .42587 0 6.12129 ]
[-0.01144 .48796 -18 -2.93177 ]
[-0.01144 .48796 0 6.06823 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-40)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-20)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(20)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(40)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72272 .05198 m
.71658 .05431 L
s
[(-40)] .73498 .04732 -1 .38011 Mshowa
.78611 .14895 m
.77994 .15117 L
s
[(-20)] .79846 .14452 -1 .3591 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.89727 .31899 m
.89103 .32101 L
s
[(20)] .90976 .31495 -1 .32334 Mshowa
.94627 .39394 m
.94 .39587 L
s
[(40)] .95881 .39008 -1 .30801 Mshowa
.125 Mabswid
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.7708 .12553 m
.7671 .12688 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.9099 .3383 m
.90615 .3395 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.70593 .0263 m
.70226 .02771 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.02946 .30374 m
.03559 .3014 L
s
[(440)] .0172 .30843 1 -0.38246 Mshowa
.02031 .36149 m
.02646 .35921 L
s
[(460)] .00801 .36606 1 -0.3716 Mshowa
.01081 .42142 m
.01698 .41919 L
s
[(480)] -0.00154 .42587 1 -0.36029 Mshowa
.00095 .48364 m
.00714 .48149 L
s
[(500)] -0.01144 .48796 1 -0.3485 Mshowa
.125 Mabswid
.0272 .31798 m
.03088 .31658 L
s
.02492 .33235 m
.02861 .33096 L
s
.02263 .34685 m
.02631 .34547 L
s
.01796 .37627 m
.02166 .3749 L
s
.0156 .39118 m
.0193 .38982 L
s
.01322 .40623 m
.01692 .40488 L
s
.00838 .43675 m
.01209 .43543 L
s
.00593 .45224 m
.00964 .45092 L
s
.00345 .46787 m
.00716 .46656 L
s
.03169 .28963 m
.03537 .28821 L
s
.03391 .27564 m
.03758 .27422 L
s
.03611 .26178 m
.03977 .26035 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.646 .762 .934 r
.39144 .8004 .39806 .80578 .40912 .80287 .40252 .79747 Mtetra
.646 .762 .933 r
.40252 .79747 .40912 .80287 .42022 .79995 .41365 .79452 Mtetra
.41365 .79452 .42022 .79995 .43137 .79702 .42483 .79156 Mtetra
.42483 .79156 .43137 .79702 .44256 .79407 .43605 .78859 Mtetra
.43605 .78859 .44256 .79407 .4538 .79112 .44732 .78561 Mtetra
.44732 .78561 .4538 .79112 .46509 .78815 .45864 .78262 Mtetra
.45864 .78262 .46509 .78815 .47642 .78517 .47001 .77961 Mtetra
.47001 .77961 .47642 .78517 .48781 .78217 .48142 .77659 Mtetra
.48142 .77659 .48781 .78217 .49924 .77916 .49288 .77356 Mtetra
.646 .761 .933 r
.49288 .77356 .49924 .77916 .51071 .77615 .50439 .77051 Mtetra
.50439 .77051 .51071 .77615 .52224 .77311 .51594 .76745 Mtetra
.51594 .76745 .52224 .77311 .53381 .77007 .52755 .76438 Mtetra
.52755 .76438 .53381 .77007 .54544 .76701 .53921 .7613 Mtetra
.53921 .7613 .54544 .76701 .55711 .76395 .55091 .7582 Mtetra
.55091 .7582 .55711 .76395 .56883 .76086 .56266 .7551 Mtetra
.56266 .7551 .56883 .76086 .5806 .75777 .57447 .75198 Mtetra
.57447 .75198 .5806 .75777 .59242 .75466 .58632 .74885 Mtetra
.58632 .74885 .59242 .75466 .60429 .75154 .59823 .74571 Mtetra
.59823 .74571 .60429 .75154 .61622 .74841 .61019 .74255 Mtetra
.61019 .74255 .61622 .74841 .62819 .74526 .62219 .73937 Mtetra
.62219 .73937 .62819 .74526 .64022 .7421 .63425 .73619 Mtetra
.63425 .73619 .64022 .7421 .65229 .73893 .64637 .73299 Mtetra
.64637 .73299 .65229 .73893 .66442 .73574 .65853 .72978 Mtetra
.65853 .72978 .66442 .73574 .6766 .73254 .67075 .72655 Mtetra
.67075 .72655 .6766 .73254 .68884 .72932 .68302 .72331 Mtetra
.68302 .72331 .68884 .72932 .70112 .7261 .69534 .72006 Mtetra
.69534 .72006 .70112 .7261 .71347 .72285 .70772 .71678 Mtetra
.70772 .71678 .71347 .72285 .72586 .7196 .72015 .7135 Mtetra
.72015 .7135 .72586 .7196 .73831 .71633 .73264 .7102 Mtetra
.73264 .7102 .73831 .71633 .75081 .71304 .74518 .70689 Mtetra
.74518 .70689 .75081 .71304 .76337 .70974 .75778 .70357 Mtetra
.75778 .70357 .76337 .70974 .77598 .70642 .77043 .70023 Mtetra
.77043 .70023 .77598 .70642 .78865 .7031 .78314 .69687 Mtetra
.78314 .69687 .78865 .7031 .80137 .69975 .7959 .6935 Mtetra
.7959 .6935 .80137 .69975 .81416 .6964 .80872 .69011 Mtetra
.80872 .69011 .81416 .6964 .82699 .69302 .8216 .68671 Mtetra
.8216 .68671 .82699 .69302 .83989 .68964 .83453 .6833 Mtetra
.83453 .6833 .83989 .68964 .85284 .68623 .84753 .67987 Mtetra
.84753 .67987 .85284 .68623 .86585 .68282 .86058 .67643 Mtetra
.86058 .67643 .86585 .68282 .87892 .67939 .87369 .67297 Mtetra
.87369 .67297 .87892 .67939 .89205 .67594 .88686 .6695 Mtetra
.88686 .6695 .89205 .67594 .90523 .67248 .90009 .66602 Mtetra
.646 .762 .933 r
.90009 .66602 .90523 .67248 .91848 .669 .91338 .66251 Mtetra
.91338 .66251 .91848 .669 .93178 .66551 .92673 .65899 Mtetra
.92673 .65899 .93178 .66551 .94515 .662 .94014 .65545 Mtetra
.94014 .65545 .94515 .662 .95857 .65847 .95361 .6519 Mtetra
.95361 .6519 .95857 .65847 .97206 .65493 .96714 .64833 Mtetra
.96714 .64833 .97206 .65493 .98561 .65137 .98074 .64475 Mtetra
.646 .762 .934 r
.98074 .64475 .98561 .65137 .99922 .6478 .9944 .64115 Mtetra
.646 .762 .933 r
.38476 .79498 .39144 .8004 .40252 .79747 .39588 .79202 Mtetra
.647 .762 .933 r
.39588 .79202 .40252 .79747 .41365 .79452 .40704 .78904 Mtetra
.40704 .78904 .41365 .79452 .42483 .79156 .41824 .78604 Mtetra
.647 .761 .933 r
.41824 .78604 .42483 .79156 .43605 .78859 .4295 .78304 Mtetra
.646 .761 .932 r
.4295 .78304 .43605 .78859 .44732 .78561 .4408 .78003 Mtetra
.4408 .78003 .44732 .78561 .45864 .78262 .45214 .77701 Mtetra
.45214 .77701 .45864 .78262 .47001 .77961 .46354 .77398 Mtetra
.647 .761 .932 r
.46354 .77398 .47001 .77961 .48142 .77659 .47498 .77093 Mtetra
.47498 .77093 .48142 .77659 .49288 .77356 .48647 .76787 Mtetra
.647 .76 .932 r
.48647 .76787 .49288 .77356 .50439 .77051 .49801 .76478 Mtetra
.647 .76 .931 r
.49801 .76478 .50439 .77051 .51594 .76745 .5096 .76168 Mtetra
.5096 .76168 .51594 .76745 .52755 .76438 .52124 .75858 Mtetra
.647 .759 .931 r
.52124 .75858 .52755 .76438 .53921 .7613 .53293 .75547 Mtetra
.646 .759 .931 r
.53293 .75547 .53921 .7613 .55091 .7582 .54466 .75236 Mtetra
.54466 .75236 .55091 .7582 .56266 .7551 .55645 .74925 Mtetra
.646 .759 .932 r
.55645 .74925 .56266 .7551 .57447 .75198 .56829 .74612 Mtetra
.646 .76 .932 r
.56829 .74612 .57447 .75198 .58632 .74885 .58018 .74296 Mtetra
.647 .76 .932 r
.58018 .74296 .58632 .74885 .59823 .74571 .59212 .73978 Mtetra
.647 .76 .931 r
.59212 .73978 .59823 .74571 .61019 .74255 .60411 .73658 Mtetra
.647 .759 .931 r
.60411 .73658 .61019 .74255 .62219 .73937 .61615 .73338 Mtetra
.646 .759 .931 r
.61615 .73338 .62219 .73937 .63425 .73619 .62824 .73016 Mtetra
.62824 .73016 .63425 .73619 .64637 .73299 .64039 .72695 Mtetra
.64039 .72695 .64637 .73299 .65853 .72978 .65259 .72372 Mtetra
.646 .759 .932 r
.65259 .72372 .65853 .72978 .67075 .72655 .66485 .72048 Mtetra
.646 .76 .932 r
.66485 .72048 .67075 .72655 .68302 .72331 .67715 .71722 Mtetra
.647 .76 .932 r
.67715 .71722 .68302 .72331 .69534 .72006 .68951 .71392 Mtetra
.647 .76 .931 r
.68951 .71392 .69534 .72006 .70772 .71678 .70193 .71061 Mtetra
.647 .759 .931 r
.70193 .71061 .70772 .71678 .72015 .7135 .71439 .70729 Mtetra
.646 .759 .931 r
.71439 .70729 .72015 .7135 .73264 .7102 .72692 .70397 Mtetra
.72692 .70397 .73264 .7102 .74518 .70689 .7395 .70064 Mtetra
.7395 .70064 .74518 .70689 .75778 .70357 .75213 .6973 Mtetra
.646 .76 .932 r
.75213 .6973 .75778 .70357 .77043 .70023 .76482 .69394 Mtetra
.76482 .69394 .77043 .70023 .78314 .69687 .77757 .69056 Mtetra
.647 .76 .932 r
.77757 .69056 .78314 .69687 .7959 .6935 .79038 .68714 Mtetra
.647 .76 .931 r
.79038 .68714 .7959 .6935 .80872 .69011 .80323 .68372 Mtetra
.647 .759 .931 r
.80323 .68372 .80872 .69011 .8216 .68671 .81615 .68028 Mtetra
.646 .759 .931 r
.81615 .68028 .8216 .68671 .83453 .6833 .82913 .67684 Mtetra
.82913 .67684 .83453 .6833 .84753 .67987 .84217 .6734 Mtetra
.646 .759 .932 r
.84217 .6734 .84753 .67987 .86058 .67643 .85526 .66994 Mtetra
.646 .76 .932 r
.85526 .66994 .86058 .67643 .87369 .67297 .86842 .66647 Mtetra
.86842 .66647 .87369 .67297 .88686 .6695 .88163 .66298 Mtetra
.88163 .66298 .88686 .6695 .90009 .66602 .8949 .65947 Mtetra
.8949 .65947 .90009 .66602 .91338 .66251 .90824 .65593 Mtetra
.90824 .65593 .91338 .66251 .92673 .65899 .92163 .65238 Mtetra
.92163 .65238 .92673 .65899 .94014 .65545 .93509 .64882 Mtetra
.646 .761 .933 r
.93509 .64882 .94014 .65545 .95361 .6519 .9486 .64525 Mtetra
.645 .761 .933 r
.9486 .64525 .95361 .6519 .96714 .64833 .96218 .64167 Mtetra
.96218 .64167 .96714 .64833 .98074 .64475 .97583 .63807 Mtetra
.645 .762 .934 r
.97583 .63807 .98074 .64475 .9944 .64115 .98953 .63445 Mtetra
.647 .762 .933 r
.37804 .78952 .38476 .79498 .39588 .79202 .38918 .78653 Mtetra
.38918 .78653 .39588 .79202 .40704 .78904 .40037 .78351 Mtetra
.648 .762 .932 r
.40037 .78351 .40704 .78904 .41824 .78604 .41161 .78046 Mtetra
.649 .761 .931 r
.41161 .78046 .41824 .78604 .4295 .78304 .42289 .77738 Mtetra
.648 .759 .93 r
.42289 .77738 .4295 .78304 .4408 .78003 .43422 .77431 Mtetra
.647 .758 .93 r
.43422 .77431 .4408 .78003 .45214 .77701 .4456 .77126 Mtetra
.647 .757 .93 r
.4456 .77126 .45214 .77701 .46354 .77398 .45702 .7682 Mtetra
.45702 .7682 .46354 .77398 .47498 .77093 .4685 .76513 Mtetra
.647 .757 .929 r
.4685 .76513 .47498 .77093 .48647 .76787 .48002 .76203 Mtetra
.648 .757 .929 r
.48002 .76203 .48647 .76787 .49801 .76478 .49159 .75891 Mtetra
.649 .757 .928 r
.49159 .75891 .49801 .76478 .5096 .76168 .50321 .75575 Mtetra
.649 .756 .927 r
.50321 .75575 .5096 .76168 .52124 .75858 .51488 .75257 Mtetra
.648 .754 .927 r
.51488 .75257 .52124 .75858 .53293 .75547 .5266 .74943 Mtetra
.646 .753 .927 r
.5266 .74943 .53293 .75547 .54466 .75236 .53837 .74633 Mtetra
.645 .754 .928 r
.53837 .74633 .54466 .75236 .55645 .74925 .55019 .74323 Mtetra
.646 .755 .929 r
.55019 .74323 .55645 .74925 .56829 .74612 .56206 .7401 Mtetra
.647 .757 .929 r
.56206 .7401 .56829 .74612 .58018 .74296 .57398 .73692 Mtetra
.648 .757 .929 r
.57398 .73692 .58018 .74296 .59212 .73978 .58595 .7337 Mtetra
.649 .757 .928 r
.58595 .7337 .59212 .73978 .60411 .73658 .59798 .73044 Mtetra
.649 .755 .927 r
.59798 .73044 .60411 .73658 .61615 .73338 .61005 .72716 Mtetra
.647 .754 .927 r
.61005 .72716 .61615 .73338 .62824 .73016 .62218 .72392 Mtetra
.646 .753 .927 r
.62218 .72392 .62824 .73016 .64039 .72695 .63436 .72071 Mtetra
.645 .754 .928 r
.63436 .72071 .64039 .72695 .65259 .72372 .6466 .71751 Mtetra
.646 .756 .929 r
.6466 .71751 .65259 .72372 .66485 .72048 .65889 .71426 Mtetra
.647 .757 .929 r
.65889 .71426 .66485 .72048 .67715 .71722 .67123 .71097 Mtetra
.648 .757 .929 r
.67123 .71097 .67715 .71722 .68951 .71392 .68363 .70763 Mtetra
.649 .757 .928 r
.68363 .70763 .68951 .71392 .70193 .71061 .69608 .70424 Mtetra
.649 .755 .927 r
.69608 .70424 .70193 .71061 .71439 .70729 .70858 .70086 Mtetra
.647 .753 .927 r
.70858 .70086 .71439 .70729 .72692 .70397 .72114 .69751 Mtetra
.645 .753 .927 r
.72114 .69751 .72692 .70397 .7395 .70064 .73376 .6942 Mtetra
.645 .754 .928 r
.73376 .6942 .7395 .70064 .75213 .6973 .74644 .69087 Mtetra
.646 .756 .929 r
.74644 .69087 .75213 .6973 .76482 .69394 .75917 .6875 Mtetra
.647 .757 .929 r
.75917 .6875 .76482 .69394 .77757 .69056 .77196 .68409 Mtetra
.648 .757 .929 r
.77196 .68409 .77757 .69056 .79038 .68714 .7848 .68062 Mtetra
.649 .757 .928 r
.7848 .68062 .79038 .68714 .80323 .68372 .79769 .67712 Mtetra
.648 .755 .927 r
.79769 .67712 .80323 .68372 .81615 .68028 .81065 .67362 Mtetra
.647 .753 .927 r
.81065 .67362 .81615 .68028 .82913 .67684 .82367 .67016 Mtetra
.645 .753 .928 r
.82367 .67016 .82913 .67684 .84217 .6734 .83675 .66674 Mtetra
.645 .754 .929 r
.83675 .66674 .84217 .6734 .85526 .66994 .84989 .66329 Mtetra
.646 .756 .929 r
.84989 .66329 .85526 .66994 .86842 .66647 .86309 .65981 Mtetra
.646 .757 .93 r
.86309 .65981 .86842 .66647 .88163 .66298 .87634 .65629 Mtetra
.87634 .65629 .88163 .66298 .8949 .65947 .88966 .65275 Mtetra
.88966 .65275 .8949 .65947 .90824 .65593 .90304 .64919 Mtetra
.90304 .64919 .90824 .65593 .92163 .65238 .91648 .64563 Mtetra
.645 .757 .931 r
.91648 .64563 .92163 .65238 .93509 .64882 .92998 .64207 Mtetra
.644 .758 .932 r
.92998 .64207 .93509 .64882 .9486 .64525 .94355 .63852 Mtetra
.644 .76 .933 r
.94355 .63852 .9486 .64525 .96218 .64167 .95718 .63495 Mtetra
.645 .761 .933 r
.95718 .63495 .96218 .64167 .97583 .63807 .97087 .63133 Mtetra
.645 .762 .934 r
.97087 .63133 .97583 .63807 .98953 .63445 .98463 .62768 Mtetra
.647 .763 .933 r
.37126 .78402 .37804 .78952 .38918 .78653 .38243 .78101 Mtetra
.648 .763 .933 r
.38243 .78101 .38918 .78653 .40037 .78351 .39365 .77795 Mtetra
.65 .763 .932 r
.39365 .77795 .40037 .78351 .41161 .78046 .40492 .77482 Mtetra
.654 .762 .929 r
.40492 .77482 .41161 .78046 .42289 .77738 .41624 .77159 Mtetra
.656 .758 .925 r
.41624 .77159 .42289 .77738 .43422 .77431 .4276 .7683 Mtetra
.653 .751 .922 r
.4276 .7683 .43422 .77431 .4456 .77126 .43901 .76511 Mtetra
.649 .746 .92 r
.43901 .76511 .4456 .77126 .45702 .7682 .45047 .762 Mtetra
.649 .745 .92 r
.45047 .762 .45702 .7682 .4685 .76513 .46197 .7589 Mtetra
.46197 .7589 .4685 .76513 .48002 .76203 .47352 .75578 Mtetra
.65 .746 .919 r
.47352 .75578 .48002 .76203 .49159 .75891 .48512 .75261 Mtetra
.652 .746 .918 r
.48512 .75261 .49159 .75891 .50321 .75575 .49677 .74937 Mtetra
.654 .745 .916 r
.49677 .74937 .50321 .75575 .51488 .75257 .50847 .74606 Mtetra
.651 .74 .915 r
.50847 .74606 .51488 .75257 .5266 .74943 .52022 .74285 Mtetra
.644 .737 .916 r
.52022 .74285 .5266 .74943 .53837 .74633 .53202 .73982 Mtetra
.644 .74 .919 r
.53202 .73982 .53837 .74633 .55019 .74323 .54387 .73679 Mtetra
.646 .743 .92 r
.54387 .73679 .55019 .74323 .56206 .7401 .55578 .73366 Mtetra
.648 .745 .92 r
.55578 .73366 .56206 .7401 .57398 .73692 .56773 .73046 Mtetra
.65 .745 .919 r
.56773 .73046 .57398 .73692 .58595 .7337 .57973 .72719 Mtetra
.652 .746 .918 r
.57973 .72719 .58595 .7337 .59798 .73044 .59179 .72384 Mtetra
.654 .744 .916 r
.59179 .72384 .59798 .73044 .61005 .72716 .6039 .72042 Mtetra
.65 .739 .915 r
.6039 .72042 .61005 .72716 .62218 .72392 .61606 .71714 Mtetra
.644 .737 .917 r
.61606 .71714 .62218 .72392 .63436 .72071 .62828 .71402 Mtetra
.644 .74 .919 r
.62828 .71402 .63436 .72071 .6466 .71751 .64055 .71086 Mtetra
.647 .744 .92 r
.64055 .71086 .6466 .71751 .65889 .71426 .65287 .70761 Mtetra
.648 .745 .92 r
.65287 .70761 .65889 .71426 .67123 .71097 .66525 .70429 Mtetra
.65 .745 .919 r
.66525 .70429 .67123 .71097 .68363 .70763 .67768 .70089 Mtetra
.653 .746 .918 r
.67768 .70089 .68363 .70763 .69608 .70424 .69016 .69741 Mtetra
.654 .744 .916 r
.69016 .69741 .69608 .70424 .70858 .70086 .7027 .69389 Mtetra
.648 .739 .915 r
.7027 .69389 .70858 .70086 .72114 .69751 .71529 .69053 Mtetra
.644 .737 .917 r
.71529 .69053 .72114 .69751 .73376 .6942 .72796 .68729 Mtetra
.645 .741 .919 r
.72796 .68729 .73376 .6942 .74644 .69087 .74067 .684 Mtetra
.647 .744 .92 r
.74067 .684 .74644 .69087 .75917 .6875 .75344 .68063 Mtetra
.649 .745 .92 r
.75344 .68063 .75917 .6875 .77196 .68409 .76627 .67718 Mtetra
.651 .746 .919 r
.76627 .67718 .77196 .68409 .7848 .68062 .77914 .67365 Mtetra
.653 .746 .918 r
.77914 .67365 .7848 .68062 .79769 .67712 .79207 .67003 Mtetra
.653 .743 .916 r
.79207 .67003 .79769 .67712 .81065 .67362 .80506 .66641 Mtetra
.647 .738 .915 r
.80506 .66641 .81065 .67362 .82367 .67016 .81812 .66296 Mtetra
.644 .738 .917 r
.81812 .66296 .82367 .67016 .83675 .66674 .83125 .65961 Mtetra
.645 .741 .919 r
.83125 .65961 .83675 .66674 .84989 .66329 .84444 .65619 Mtetra
.647 .744 .92 r
.84444 .65619 .84989 .66329 .86309 .65981 .85768 .6527 Mtetra
.648 .745 .92 r
.85768 .6527 .86309 .65981 .87634 .65629 .87097 .64916 Mtetra
.87097 .64916 .87634 .65629 .88966 .65275 .88433 .64559 Mtetra
.647 .745 .921 r
.88433 .64559 .88966 .65275 .90304 .64919 .89776 .64202 Mtetra
.644 .744 .922 r
.89776 .64202 .90304 .64919 .91648 .64563 .91125 .63854 Mtetra
.64 .746 .926 r
.91125 .63854 .91648 .64563 .92998 .64207 .92482 .63516 Mtetra
.64 .753 .93 r
.92482 .63516 .92998 .64207 .94355 .63852 .93845 .63173 Mtetra
.643 .759 .933 r
.93845 .63173 .94355 .63852 .95718 .63495 .95214 .62817 Mtetra
.644 .761 .934 r
.95214 .62817 .95718 .63495 .97087 .63133 .96588 .62454 Mtetra
.645 .762 .934 r
.96588 .62454 .97087 .63133 .98463 .62768 .97968 .62086 Mtetra
.647 .763 .933 r
.36443 .77848 .37126 .78402 .38243 .78101 .37563 .77544 Mtetra
.648 .763 .933 r
.37563 .77544 .38243 .78101 .39365 .77795 .38688 .77235 Mtetra
.651 .763 .931 r
.38688 .77235 .39365 .77795 .40492 .77482 .39818 .76917 Mtetra
.661 .765 .927 r
.39818 .76917 .40492 .77482 .41624 .77159 .40953 .76571 Mtetra
.681 .763 .913 r
.40953 .76571 .41624 .77159 .4276 .7683 .42095 .76167 Mtetra
.685 .742 .894 r
.42095 .76167 .4276 .7683 .43901 .76511 .43241 .75743 Mtetra
.663 .707 .881 r
.43241 .75743 .43901 .76511 .45047 .762 .4439 .75391 Mtetra
.652 .694 .877 r
.4439 .75391 .45047 .762 .46197 .7589 .45543 .75075 Mtetra
.651 .693 .876 r
.45543 .75075 .46197 .7589 .47352 .75578 .467 .7476 Mtetra
.652 .693 .876 r
.467 .7476 .47352 .75578 .48512 .75261 .47863 .7444 Mtetra
.652 .693 .875 r
.47863 .7444 .48512 .75261 .49677 .74937 .4903 .74118 Mtetra
.644 .692 .88 r
.4903 .74118 .49677 .74937 .50847 .74606 .50203 .73823 Mtetra
.646 .702 .888 r
.50203 .73823 .50847 .74606 .52022 .74285 .5138 .73522 Mtetra
.66 .713 .887 r
.5138 .73522 .52022 .74285 .53202 .73982 .52563 .73168 Mtetra
.652 .698 .88 r
.52563 .73168 .53202 .73982 .54387 .73679 .5375 .72843 Mtetra
.649 .692 .877 r
.5375 .72843 .54387 .73679 .55578 .73366 .54943 .72528 Mtetra
.65 .692 .876 r
.54943 .72528 .55578 .73366 .56773 .73046 .56141 .72205 Mtetra
.652 .693 .876 r
.56141 .72205 .56773 .73046 .57973 .72719 .57344 .71875 Mtetra
.651 .693 .876 r
.57344 .71875 .57973 .72719 .59179 .72384 .58553 .71545 Mtetra
.642 .692 .881 r
.58553 .71545 .59179 .72384 .6039 .72042 .59767 .71246 Mtetra
.649 .705 .888 r
.59767 .71246 .6039 .72042 .61606 .71714 .60986 .70922 Mtetra
.66 .711 .886 r
.60986 .70922 .61606 .71714 .62828 .71402 .6221 .70559 Mtetra
.65 .696 .879 r
.6221 .70559 .62828 .71402 .64055 .71086 .63439 .70227 Mtetra
.649 .692 .877 r
.63439 .70227 .64055 .71086 .65287 .70761 .64675 .69899 Mtetra
.65 .693 .876 r
.64675 .69899 .65287 .70761 .66525 .70429 .65915 .69564 Mtetra
.652 .693 .876 r
.65915 .69564 .66525 .70429 .67768 .70089 .67161 .69221 Mtetra
.65 .693 .876 r
.67161 .69221 .67768 .70089 .69016 .69741 .68412 .68883 Mtetra
.641 .692 .882 r
.68412 .68883 .69016 .69741 .7027 .69389 .69671 .68576 Mtetra
.652 .709 .889 r
.69671 .68576 .7027 .69389 .71529 .69053 .70934 .68229 Mtetra
.658 .709 .885 r
.70934 .68229 .71529 .69053 .72796 .68729 .72201 .67857 Mtetra
.649 .694 .878 r
.72201 .67857 .72796 .68729 .74067 .684 .73475 .67517 Mtetra
.649 .692 .877 r
.73475 .67517 .74067 .684 .75344 .68063 .74755 .67176 Mtetra
.651 .693 .876 r
.74755 .67176 .75344 .68063 .76627 .67718 .7604 .66828 Mtetra
.652 .693 .876 r
.7604 .66828 .76627 .67718 .77914 .67365 .77331 .66473 Mtetra
.649 .692 .877 r
.77331 .66473 .77914 .67365 .79207 .67003 .78629 .66126 Mtetra
.641 .693 .883 r
.78629 .66126 .79207 .67003 .80506 .66641 .79934 .65809 Mtetra
.655 .711 .889 r
.79934 .65809 .80506 .66641 .81812 .66296 .81242 .65439 Mtetra
.657 .706 .884 r
.81242 .65439 .81812 .66296 .83125 .65961 .82555 .65061 Mtetra
.649 .693 .878 r
.82555 .65061 .83125 .65961 .84444 .65619 .83876 .6471 Mtetra
.649 .692 .877 r
.83876 .6471 .84444 .65619 .85768 .6527 .85204 .64358 Mtetra
.65 .692 .876 r
.85204 .64358 .85768 .6527 .87097 .64916 .86537 .64001 Mtetra
.649 .692 .877 r
.86537 .64001 .87097 .64916 .88433 .64559 .87877 .63644 Mtetra
.639 .689 .88 r
.87877 .63644 .88433 .64559 .89776 .64202 .89226 .63324 Mtetra
.617 .688 .894 r
.89226 .63324 .89776 .64202 .91125 .63854 .90592 .63081 Mtetra
.618 .719 .918 r
.90592 .63081 .91125 .63854 .92482 .63516 .91962 .62816 Mtetra
.633 .749 .931 r
.91962 .62816 .92482 .63516 .93845 .63173 .93332 .6249 Mtetra
.641 .759 .934 r
.93332 .6249 .93845 .63173 .95214 .62817 .94705 .62135 Mtetra
.644 .761 .934 r
.94705 .62135 .95214 .62817 .96588 .62454 .96084 .61769 Mtetra
.645 .762 .934 r
.96084 .61769 .96588 .62454 .97968 .62086 .97469 .61399 Mtetra
.647 .763 .933 r
.35755 .7729 .36443 .77848 .37563 .77544 .36878 .76983 Mtetra
.648 .763 .933 r
.36878 .76983 .37563 .77544 .38688 .77235 .38005 .76672 Mtetra
.652 .764 .931 r
.38005 .76672 .38688 .77235 .39818 .76917 .39138 .76349 Mtetra
.665 .766 .925 r
.39138 .76349 .39818 .76917 .40953 .76571 .40277 .7599 Mtetra
.711 .772 .9 r
.40277 .7599 .40953 .76571 .42095 .76167 .41425 .7548 Mtetra
.794 .753 .815 r
.41425 .7548 .42095 .76167 .43241 .75743 .42591 .7446 Mtetra
.755 .652 .747 r
.42591 .7446 .43241 .75743 .4439 .75391 .4376 .73307 Mtetra
.639 .532 .717 r
.4376 .73307 .4439 .75391 .45543 .75075 .44914 .72862 Mtetra
.621 .515 .712 r
.44914 .72862 .45543 .75075 .467 .7476 .4607 .72541 Mtetra
.62 .514 .712 r
.4607 .72541 .467 .7476 .47863 .7444 .4723 .72226 Mtetra
.578 .489 .718 r
.4723 .72226 .47863 .7444 .4903 .74118 .48392 .72218 Mtetra
.45 .432 .747 r
.48392 .72218 .4903 .74118 .50203 .73823 .49555 .72808 Mtetra
.586 .625 .858 r
.49555 .72808 .50203 .73823 .5138 .73522 .50734 .72714 Mtetra
.784 .735 .807 r
.50734 .72714 .5138 .73522 .52563 .73168 .5192 .71694 Mtetra
.73 .626 .743 r
.5192 .71694 .52563 .73168 .5375 .72843 .53107 .70672 Mtetra
.63 .524 .715 r
.53107 .70672 .5375 .72843 .54943 .72528 .54297 .70277 Mtetra
.62 .514 .712 r
.54297 .70277 .54943 .72528 .56141 .72205 .55493 .69949 Mtetra
.619 .513 .712 r
.55493 .69949 .56141 .72205 .57344 .71875 .56694 .69636 Mtetra
.561 .479 .72 r
.56694 .69636 .57344 .71875 .58553 .71545 .57907 .69742 Mtetra
.455 .447 .76 r
.57907 .69742 .58553 .71545 .59767 .71246 .59137 .703 Mtetra
.629 .663 .864 r
.59137 .703 .59767 .71246 .60986 .70922 .6036 .70045 Mtetra
.794 .732 .794 r
.6036 .70045 .60986 .70922 .6221 .70559 .61566 .68894 Mtetra
.707 .602 .737 r
.61566 .68894 .6221 .70559 .63439 .70227 .62779 .67985 Mtetra
.626 .52 .714 r
.62779 .67985 .63439 .70227 .64675 .69899 .64011 .6761 Mtetra
.621 .514 .712 r
.64011 .6761 .64675 .69899 .65915 .69564 .65249 .6727 Mtetra
.616 .512 .712 r
.65249 .6727 .65915 .69564 .67161 .69221 .66494 .66965 Mtetra
.543 .469 .723 r
.66494 .66965 .67161 .69221 .68412 .68883 .67769 .67198 Mtetra
.47 .47 .776 r
.67769 .67198 .68412 .68883 .69671 .68576 .69065 .67677 Mtetra
.67 .696 .865 r
.69065 .67677 .69671 .68576 .70934 .68229 .70326 .67255 Mtetra
.798 .724 .782 r
.70326 .67255 .70934 .68229 .72201 .67857 .71548 .66008 Mtetra
.685 .579 .731 r
.71548 .66008 .72201 .67857 .73475 .67517 .72796 .65216 Mtetra
.623 .517 .713 r
.72796 .65216 .73475 .67517 .74755 .67176 .74072 .64848 Mtetra
.621 .515 .712 r
.74072 .64848 .74755 .67176 .7604 .66828 .75355 .64495 Mtetra
.613 .51 .713 r
.75355 .64495 .7604 .66828 .77331 .66473 .76649 .64211 Mtetra
.525 .46 .726 r
.76649 .64211 .77331 .66473 .78629 .66126 .77996 .64571 Mtetra
.492 .5 .793 r
.77996 .64571 .78629 .66126 .79934 .65809 .79356 .64932 Mtetra
.706 .722 .861 r
.79356 .64932 .79934 .65809 .81242 .65439 .80649 .64341 Mtetra
.794 .71 .772 r
.80649 .64341 .81242 .65439 .82555 .65061 .81886 .63041 Mtetra
.665 .56 .726 r
.81886 .63041 .82555 .65061 .83876 .6471 .83177 .62357 Mtetra
.621 .515 .712 r
.83177 .62357 .83876 .6471 .85204 .64358 .84501 .6199 Mtetra
.62 .514 .712 r
.84501 .6199 .85204 .64358 .86537 .64001 .85832 .61629 Mtetra
.605 .505 .714 r
.85832 .61629 .86537 .64001 .87877 .63644 .87182 .61397 Mtetra
.503 .45 .731 r
.87182 .61397 .87877 .63644 .89226 .63324 .88617 .61906 Mtetra
.48 .514 .815 r
.88617 .61906 .89226 .63324 .90592 .63081 .90052 .62281 Mtetra
.584 .697 .92 r
.90052 .62281 .90592 .63081 .91962 .62816 .91438 .62121 Mtetra
.629 .751 .935 r
.91438 .62121 .91962 .62816 .93332 .6249 .92814 .61804 Mtetra
.641 .76 .935 r
.92814 .61804 .93332 .6249 .94705 .62135 .94192 .61447 Mtetra
.644 .761 .934 r
.94192 .61447 .94705 .62135 .96084 .61769 .95576 .61079 Mtetra
.645 .762 .934 r
.95576 .61079 .96084 .61769 .97469 .61399 .96965 .60705 Mtetra
.647 .763 .933 r
.35061 .76727 .35755 .7729 .36878 .76983 .36187 .76418 Mtetra
.648 .763 .933 r
.36187 .76418 .36878 .76983 .38005 .76672 .37318 .76104 Mtetra
.652 .764 .931 r
.37318 .76104 .38005 .76672 .39138 .76349 .38454 .75779 Mtetra
.666 .767 .925 r
.38454 .75779 .39138 .76349 .40277 .7599 .39596 .75414 Mtetra
.721 .776 .896 r
.39596 .75414 .40277 .7599 .41425 .7548 .40749 .74863 Mtetra
.864 .763 .749 r
.40749 .74863 .41425 .7548 .42591 .7446 .41942 .7304 Mtetra
.915 .687 .58 r
.41942 .7304 .42591 .7446 .4376 .73307 .43365 .62399 Mtetra
.749 .524 .59 r
.43365 .62399 .4376 .73307 .44914 .72862 .44695 .53059 Mtetra
.575 .377 .576 r
.44695 .53059 .44914 .72862 .4607 .72541 .45792 .52718 Mtetra
.563 .368 .574 r
.45792 .52718 .4607 .72541 .4723 .72226 .46882 .53038 Mtetra
.182 .076 .49 r
.46882 .53038 .4723 .72226 .48392 .72218 .47801 .66682 Mtetra
0 0 .49 r
.47801 .66682 .48392 .72218 .49555 .72808 .48903 .71927 Mtetra
.495 .617 .901 r
.48903 .71927 .49555 .72808 .50734 .72714 .50082 .72036 Mtetra
.885 .758 .716 r
.50082 .72036 .50734 .72714 .5192 .71694 .51277 .69731 Mtetra
.919 .68 .56 r
.51277 .69731 .5192 .71694 .53107 .70672 .52465 .56898 Mtetra
.692 .473 .586 r
.52465 .56898 .53107 .70672 .54297 .70277 .53593 .5029 Mtetra
.575 .377 .576 r
.53593 .5029 .54297 .70277 .55493 .69949 .54726 .49938 Mtetra
.542 .352 .573 r
.54726 .49938 .55493 .69949 .56694 .69636 .55883 .51481 Mtetra
.16 .067 .492 r
.55883 .51481 .56694 .69636 .57907 .69742 .57232 .6579 Mtetra
.053 .069 .557 r
.57232 .6579 .57907 .69742 .59137 .703 .58506 .69503 Mtetra
.606 .692 .904 r
.58506 .69503 .59137 .703 .6036 .70045 .59733 .69309 Mtetra
.914 .753 .669 r
.59733 .69309 .6036 .70045 .61566 .68894 .60894 .661 Mtetra
.918 .669 .545 r
.60894 .661 .61566 .68894 .62779 .67985 .61728 .516 Mtetra
.642 .431 .581 r
.61728 .516 .62779 .67985 .64011 .6761 .62789 .47429 Mtetra
.575 .377 .576 r
.62789 .47429 .64011 .6761 .65249 .6727 .6396 .47064 Mtetra
.508 .327 .57 r
.6396 .47064 .65249 .6727 .66494 .66965 .65282 .50518 Mtetra
.16 .076 .504 r
.65282 .50518 .66494 .66965 .67769 .67198 .67076 .64377 Mtetra
.128 .167 .633 r
.67076 .64377 .67769 .67198 .69065 .67677 .68461 .66921 Mtetra
.69 .74 .89 r
.68461 .66921 .69065 .67677 .70326 .67255 .69723 .66432 Mtetra
.938 .746 .617 r
.69723 .66432 .70326 .67255 .71548 .66008 .7078 .61982 Mtetra
.909 .651 .536 r
.7078 .61982 .71548 .66008 .72796 .65216 .712 .46779 Mtetra
.607 .402 .578 r
.712 .46779 .72796 .65216 .74072 .64848 .72296 .4447 Mtetra
.575 .377 .576 r
.72296 .4447 .74072 .64848 .75355 .64495 .73507 .44094 Mtetra
.463 .295 .568 r
.73507 .44094 .75355 .64495 .76649 .64211 .75159 .50101 Mtetra
.175 .097 .522 r
.75159 .50101 .76649 .64211 .77996 .64571 .77326 .62514 Mtetra
.218 .279 .713 r
.77326 .62514 .77996 .64571 .79356 .64932 .78783 .64188 Mtetra
.759 .773 .865 r
.78783 .64188 .79356 .64932 .80649 .64341 .80064 .63381 Mtetra
.957 .736 .563 r
.80064 .63381 .80649 .64341 .81886 .63041 .80903 .5727 Mtetra
.885 .622 .535 r
.80903 .5727 .81886 .63041 .83177 .62357 .80945 .42505 Mtetra
.586 .385 .576 r
.80945 .42505 .83177 .62357 .84501 .6199 .82131 .4141 Mtetra
.575 .377 .576 r
.82131 .4141 .84501 .6199 .85832 .61629 .83385 .4102 Mtetra
.412 .262 .565 r
.83385 .4102 .85832 .61629 .87182 .61397 .85574 .4997 Mtetra
.196 .125 .544 r
.85574 .4997 .87182 .61397 .88617 .61906 .87991 .60344 Mtetra
.261 .36 .776 r
.87991 .60344 .88617 .61906 .90052 .62281 .89516 .61553 Mtetra
.56 .71 .941 r
.89516 .61553 .90052 .62281 .91438 .62121 .90911 .61431 Mtetra
.627 .753 .938 r
.90911 .61431 .91438 .62121 .92814 .61804 .92292 .61113 Mtetra
.64 .76 .935 r
.92292 .61113 .92814 .61804 .94192 .61447 .93675 .60754 Mtetra
.644 .761 .934 r
.93675 .60754 .94192 .61447 .95576 .61079 .95063 .60382 Mtetra
.645 .762 .934 r
.95063 .60382 .95576 .61079 .96965 .60705 .96458 .60005 Mtetra
.647 .763 .933 r
.34362 .76159 .35061 .76727 .36187 .76418 .35491 .75847 Mtetra
.648 .763 .933 r
.35491 .75847 .36187 .76418 .37318 .76104 .36625 .75531 Mtetra
.652 .764 .931 r
.36625 .75531 .37318 .76104 .38454 .75779 .37764 .75203 Mtetra
.666 .767 .925 r
.37764 .75203 .38454 .75779 .39596 .75414 .38909 .74836 Mtetra
.722 .777 .896 r
.38909 .74836 .39596 .75414 .40749 .74863 .40065 .74279 Mtetra
.873 .767 .742 r
.40065 .74279 .40749 .74863 .41942 .7304 .41269 .72324 Mtetra
.939 .698 .548 r
.41269 .72324 .41942 .7304 .43365 .62399 .42968 .5277 Mtetra
.582 .395 .594 r
.42968 .5277 .43365 .62399 .44695 .53059 .44063 .52428 Mtetra
.664 .741 .907 r
.44063 .52428 .44695 .53059 .45792 .52718 .45162 .52084 Mtetra
.45162 .52084 .45792 .52718 .46882 .53038 .46266 .51739 Mtetra
.966 .671 .418 r
.46266 .51739 .46882 .53038 .47801 .66682 .4718 .64055 Mtetra
.932 .631 .164 r
.4718 .64055 .47801 .66682 .48903 .71927 .48244 .71292 Mtetra
.412 .657 .96 r
.48244 .71292 .48903 .71927 .50082 .72036 .49425 .71425 Mtetra
.9 .765 .704 r
.49425 .71425 .50082 .72036 .51277 .69731 .50628 .6887 Mtetra
.947 .7 .531 r
.50628 .6887 .51277 .69731 .52465 .56898 .51853 .49992 Mtetra
.588 .41 .609 r
.51853 .49992 .52465 .56898 .53593 .5029 .52984 .49638 Mtetra
.664 .741 .907 r
.52984 .49638 .53593 .5029 .54726 .49938 .5412 .49283 Mtetra
.5412 .49283 .54726 .49938 .55883 .51481 .55261 .48926 Mtetra
.979 .683 .344 r
.55261 .48926 .55883 .51481 .57232 .6579 .56591 .6416 Mtetra
.877 .529 .032 r
.56591 .6416 .57232 .6579 .58506 .69503 .57873 .68862 Mtetra
.59 .735 .944 r
.57873 .68862 .58506 .69503 .59733 .69309 .59104 .68672 Mtetra
.93 .759 .649 r
.59104 .68672 .59733 .69309 .60894 .661 .60262 .64966 Mtetra
.954 .7 .514 r
.60262 .64966 .60894 .661 .61728 .516 .61035 .47121 Mtetra
.598 .439 .636 r
.61035 .47121 .61728 .516 .62789 .47429 .62205 .46755 Mtetra
.664 .741 .907 r
.62205 .46755 .62789 .47429 .6396 .47064 .63379 .46388 Mtetra
.63379 .46388 .6396 .47064 .65282 .50518 .64558 .46019 Mtetra
.935 .654 .183 r
.64558 .46019 .65282 .50518 .67076 .64377 .66453 .63226 Mtetra
.736 .341 0 r
.66453 .63226 .67076 .64377 .68461 .66921 .67857 .66265 Mtetra
.694 .772 .912 r
.67857 .66265 .68461 .66921 .69723 .66432 .69123 .65764 Mtetra
.955 .75 .587 r
.69123 .65764 .69723 .66432 .7078 .61982 .70138 .60307 Mtetra
.954 .694 .503 r
.70138 .60307 .7078 .61982 .712 .46779 .7053 .44152 Mtetra
.617 .494 .689 r
.7053 .44152 .712 .46779 .72296 .4447 .71739 .43773 Mtetra
.664 .741 .907 r
.71739 .43773 .72296 .4447 .73507 .44094 .72954 .43394 Mtetra
.72954 .43394 .73507 .44094 .75159 .50101 .74174 .43012 Mtetra
.71 .499 0 r
.74174 .43012 .75159 .50101 .77326 .62514 .76736 .61587 Mtetra
0 0 .524 r
.76736 .61587 .77326 .62514 .78783 .64188 .78212 .63512 Mtetra
.769 .796 .875 r
.78212 .63512 .78783 .64188 .80064 .63381 .79495 .62675 Mtetra
.974 .738 .517 r
.79495 .62675 .80064 .63381 .80903 .5727 .80178 .54504 Mtetra
.937 .673 .511 r
.80178 .54504 .80903 .5727 .80945 .42505 .80353 .4108 Mtetra
.645 .594 .782 r
.80353 .4108 .80945 .42505 .82131 .4141 .81604 .40689 Mtetra
.664 .741 .907 r
.81604 .40689 .82131 .4141 .83385 .4102 .82862 .40295 Mtetra
.82862 .40295 .83385 .4102 .85574 .4997 .84124 .39901 Mtetra
0 0 .337 r
.84124 .39901 .85574 .4997 .87991 .60344 .87439 .59517 Mtetra
0 .215 .736 r
.87439 .59517 .87991 .60344 .89516 .61553 .8898 .60858 Mtetra
.553 .719 .95 r
.8898 .60858 .89516 .61553 .90911 .61431 .90379 .60736 Mtetra
.627 .754 .938 r
.90379 .60736 .90911 .61431 .92292 .61113 .91765 .60416 Mtetra
.64 .76 .935 r
.91765 .60416 .92292 .61113 .93675 .60754 .93153 .60054 Mtetra
.644 .761 .934 r
.93153 .60054 .93675 .60754 .95063 .60382 .94546 .59679 Mtetra
.645 .762 .934 r
.94546 .59679 .95063 .60382 .96458 .60005 .95945 .59299 Mtetra
.647 .763 .933 r
.33657 .75587 .34362 .76159 .35491 .75847 .34789 .75273 Mtetra
.648 .763 .933 r
.34789 .75273 .35491 .75847 .36625 .75531 .35926 .74953 Mtetra
.652 .763 .931 r
.35926 .74953 .36625 .75531 .37764 .75203 .37068 .74622 Mtetra
.666 .767 .925 r
.37068 .74622 .37764 .75203 .38909 .74836 .38217 .74252 Mtetra
.722 .777 .896 r
.38217 .74252 .38909 .74836 .40065 .74279 .39377 .73691 Mtetra
.874 .767 .742 r
.39377 .73691 .40065 .74279 .41269 .72324 .40587 .71729 Mtetra
.94 .7 .547 r
.40587 .71729 .41269 .72324 .42968 .5277 .42327 .52137 Mtetra
.664 .741 .907 r
.42327 .52137 .42968 .5277 .44063 .52428 .43425 .51792 Mtetra
.43425 .51792 .44063 .52428 .45162 .52084 .44527 .51446 Mtetra
.44527 .51446 .45162 .52084 .46266 .51739 .45634 .51098 Mtetra
.953 .659 .44 r
.45634 .51098 .46266 .51739 .4718 .64055 .46527 .6341 Mtetra
.952 .632 .384 r
.46527 .6341 .4718 .64055 .48244 .71292 .47579 .70683 Mtetra
.4 .662 .965 r
.47579 .70683 .48244 .71292 .49425 .71425 .48762 .70814 Mtetra
.9 .766 .704 r
.48762 .70814 .49425 .71425 .50628 .6887 .49973 .68249 Mtetra
.951 .704 .529 r
.49973 .68249 .50628 .6887 .51853 .49992 .51236 .49338 Mtetra
.664 .741 .907 r
.51236 .49338 .51853 .49992 .52984 .49638 .5237 .48981 Mtetra
.5237 .48981 .52984 .49638 .5412 .49283 .53509 .48623 Mtetra
.53509 .48623 .5412 .49283 .55261 .48926 .54653 .48264 Mtetra
.961 .661 .418 r
.54653 .48264 .55261 .48926 .56591 .6416 .55958 .63511 Mtetra
.94 .573 .252 r
.55958 .63511 .56591 .6416 .57873 .68862 .57235 .68231 Mtetra
.588 .74 .948 r
.57235 .68231 .57873 .68862 .59104 .68672 .58469 .68039 Mtetra
.931 .76 .649 r
.58469 .68039 .59104 .68672 .60262 .64966 .59637 .64319 Mtetra
.961 .708 .508 r
.59637 .64319 .60262 .64966 .61035 .47121 .60443 .46444 Mtetra
.664 .741 .907 r
.60443 .46444 .61035 .47121 .62205 .46755 .61616 .46076 Mtetra
.61616 .46076 .62205 .46755 .63379 .46388 .62794 .45706 Mtetra
.62794 .45706 .63379 .46388 .64558 .46019 .63976 .45334 Mtetra
.967 .658 .383 r
.63976 .45334 .64558 .46019 .66453 .63226 .65846 .62564 Mtetra
.864 .434 .01 r
.65846 .62564 .66453 .63226 .67857 .66265 .67249 .65612 Mtetra
.694 .775 .914 r
.67249 .65612 .67857 .66265 .69123 .65764 .68519 .65108 Mtetra
.956 .751 .586 r
.68519 .65108 .69123 .65764 .70138 .60307 .69545 .59627 Mtetra
.97 .712 .485 r
.69545 .59627 .70138 .60307 .7053 .44152 .69965 .43452 Mtetra
.664 .741 .907 r
.69965 .43452 .7053 .44152 .71739 .43773 .71178 .43071 Mtetra
.71178 .43071 .71739 .43773 .72954 .43394 .72397 .42688 Mtetra
.72397 .42688 .72954 .43394 .74174 .43012 .7362 .42304 Mtetra
.969 .65 .337 r
.7362 .42304 .74174 .43012 .76736 .61587 .76159 .60906 Mtetra
.61 .138 0 r
.76159 .60906 .76736 .61587 .78212 .63512 .77636 .62835 Mtetra
.77 .797 .875 r
.77636 .62835 .78212 .63512 .79495 .62675 .78924 .61994 Mtetra
.975 .739 .516 r
.78924 .61994 .79495 .62675 .80178 .54504 .7962 .53782 Mtetra
.978 .717 .464 r
.7962 .53782 .80178 .54504 .80353 .4108 .79818 .40356 Mtetra
.664 .741 .907 r
.79818 .40356 .80353 .4108 .81604 .40689 .81073 .39961 Mtetra
.81073 .39961 .81604 .40689 .82862 .40295 .82335 .39565 Mtetra
.82335 .39565 .82862 .40295 .84124 .39901 .83601 .39167 Mtetra
.964 .635 .278 r
.83601 .39167 .84124 .39901 .87439 .59517 .86896 .58816 Mtetra
0 .167 .687 r
.86896 .58816 .87439 .59517 .8898 .60858 .88439 .60159 Mtetra
.553 .72 .951 r
.88439 .60159 .8898 .60858 .90379 .60736 .89843 .60035 Mtetra
.627 .753 .938 r
.89843 .60035 .90379 .60736 .91765 .60416 .91234 .59712 Mtetra
.64 .759 .935 r
.91234 .59712 .91765 .60416 .93153 .60054 .92626 .59347 Mtetra
.644 .761 .934 r
.92626 .59347 .93153 .60054 .94546 .59679 .94024 .58969 Mtetra
.645 .762 .934 r
.94024 .58969 .94546 .59679 .95945 .59299 .95429 .58586 Mtetra
.647 .763 .933 r
.32947 .75011 .33657 .75587 .34789 .75273 .34082 .74693 Mtetra
.649 .763 .932 r
.34082 .74693 .34789 .75273 .35926 .74953 .35222 .7437 Mtetra
.653 .763 .93 r
.35222 .7437 .35926 .74953 .37068 .74622 .36367 .74035 Mtetra
.667 .766 .924 r
.36367 .74035 .37068 .74622 .38217 .74252 .37519 .7366 Mtetra
.722 .776 .895 r
.37519 .7366 .38217 .74252 .39377 .73691 .38682 .73096 Mtetra
.873 .767 .742 r
.38682 .73096 .39377 .73691 .40587 .71729 .39899 .71138 Mtetra
.94 .7 .548 r
.39899 .71138 .40587 .71729 .42327 .52137 .41661 .52164 Mtetra
.845 .967 .88 r
.41661 .52164 .42327 .52137 .43425 .51792 .42783 .51152 Mtetra
.664 .741 .907 r
.42783 .51152 .43425 .51792 .44527 .51446 .43888 .50803 Mtetra
.43888 .50803 .44527 .51446 .45634 .51098 .44998 .50452 Mtetra
.953 .659 .441 r
.44998 .50452 .45634 .51098 .46527 .6341 .45865 .62972 Mtetra
.946 .625 .394 r
.45865 .62972 .46527 .6341 .47579 .70683 .46909 .70064 Mtetra
.403 .662 .964 r
.46909 .70064 .47579 .70683 .48762 .70814 .48094 .70192 Mtetra
.899 .765 .705 r
.48094 .70192 .48762 .70814 .49973 .68249 .49313 .6764 Mtetra
.951 .704 .528 r
.49313 .6764 .49973 .68249 .51236 .49338 .50614 .48678 Mtetra
.664 .741 .907 r
.50614 .48678 .51236 .49338 .5237 .48981 .51752 .48319 Mtetra
.51752 .48319 .5237 .48981 .53509 .48623 .52894 .47959 Mtetra
.52894 .47959 .53509 .48623 .54653 .48264 .54041 .47596 Mtetra
.961 .661 .418 r
.54041 .47596 .54653 .48264 .55958 .63511 .55321 .62952 Mtetra
.938 .57 .262 r
.55321 .62952 .55958 .63511 .57235 .68231 .56592 .6759 Mtetra
.589 .738 .947 r
.56592 .6759 .57235 .68231 .58469 .68039 .57829 .67395 Mtetra
.93 .76 .65 r
.57829 .67395 .58469 .68039 .59637 .64319 .59007 .63707 Mtetra
.962 .708 .507 r
.59007 .63707 .59637 .64319 .60443 .46444 .59847 .45763 Mtetra
.664 .741 .907 r
.59847 .45763 .60443 .46444 .61616 .46076 .61023 .45391 Mtetra
.61023 .45391 .61616 .46076 .62794 .45706 .62204 .45018 Mtetra
.62204 .45018 .62794 .45706 .63976 .45334 .6339 .44644 Mtetra
.967 .658 .383 r
.6339 .44644 .63976 .45334 .65846 .62564 .65236 .61938 Mtetra
.866 .433 .019 r
.65236 .61938 .65846 .62564 .67249 .65612 .66635 .64947 Mtetra
.694 .773 .912 r
.66635 .64947 .67249 .65612 .68519 .65108 .67909 .64441 Mtetra
.956 .752 .588 r
.67909 .64441 .68519 .65108 .69545 .59627 .68952 .59037 Mtetra
.972 .713 .482 r
.68952 .59037 .69545 .59627 .69965 .43452 .69396 .42747 Mtetra
.664 .741 .907 r
.69396 .42747 .69965 .43452 .71178 .43071 .70613 .42363 Mtetra
.70613 .42363 .71178 .43071 .72397 .42688 .71835 .41977 Mtetra
.71835 .41977 .72397 .42688 .7362 .42304 .73062 .41589 Mtetra
.969 .65 .337 r
.73062 .41589 .7362 .42304 .76159 .60906 .75578 .60237 Mtetra
.613 .138 0 r
.75578 .60237 .76159 .60906 .77636 .62835 .77054 .62146 Mtetra
.769 .795 .874 r
.77054 .62146 .77636 .62835 .78924 .61994 .78348 .61303 Mtetra
.975 .74 .519 r
.78348 .61303 .78924 .61994 .7962 .53782 .79074 .53271 Mtetra
.982 .721 .456 r
.79074 .53271 .7962 .53782 .79818 .40356 .79279 .39626 Mtetra
.664 .741 .907 r
.79279 .39626 .79818 .40356 .81073 .39961 .80538 .39228 Mtetra
.80538 .39228 .81073 .39961 .82335 .39565 .81803 .38829 Mtetra
.36 .589 .932 r
.81803 .38829 .82335 .39565 .83601 .39167 .83142 .3914 Mtetra
.963 .632 .308 r
.83142 .3914 .83601 .39167 .86896 .58816 .86349 .58118 Mtetra
0 .169 .687 r
.86349 .58118 .86896 .58816 .88439 .60159 .87894 .5945 Mtetra
.553 .719 .95 r
.87894 .5945 .88439 .60159 .89843 .60035 .89302 .59324 Mtetra
.626 .752 .937 r
.89302 .59324 .89843 .60035 .91234 .59712 .90697 .59 Mtetra
.64 .758 .934 r
.90697 .59 .91234 .59712 .92626 .59347 .92095 .58633 Mtetra
.643 .761 .934 r
.92095 .58633 .92626 .59347 .94024 .58969 .93498 .58254 Mtetra
.645 .762 .934 r
.93498 .58254 .94024 .58969 .95429 .58586 .94908 .57868 Mtetra
.647 .763 .933 r
.32232 .7443 .32947 .75011 .34082 .74693 .33369 .74109 Mtetra
.649 .763 .932 r
.33369 .74109 .34082 .74693 .35222 .7437 .34512 .73782 Mtetra
.654 .764 .93 r
.34512 .73782 .35222 .7437 .36367 .74035 .35661 .7344 Mtetra
.669 .766 .923 r
.35661 .7344 .36367 .74035 .37519 .7366 .36816 .73058 Mtetra
.721 .774 .895 r
.36816 .73058 .37519 .7366 .38682 .73096 .37983 .72496 Mtetra
.857 .772 .767 r
.37983 .72496 .38682 .73096 .39899 .71138 .39194 .7085 Mtetra
.94 .751 .62 r
.39194 .7085 .39899 .71138 .41661 .52164 .40527 .65561 Mtetra
.493 .274 .509 r
.40527 .65561 .41661 .52164 .42783 .51152 .41741 .63204 Mtetra
.548 .317 .518 r
.41741 .63204 .42783 .51152 .43888 .50803 .42891 .62839 Mtetra
.553 .322 .519 r
.42891 .62839 .43888 .50803 .44998 .50452 .44041 .62685 Mtetra
.637 .393 .533 r
.44041 .62685 .44998 .50452 .45865 .62972 .45117 .66269 Mtetra
.737 .444 .484 r
.45117 .66269 .45865 .62972 .46909 .70064 .46232 .69508 Mtetra
.426 .698 .977 r
.46232 .69508 .46909 .70064 .48094 .70192 .47421 .69564 Mtetra
.877 .775 .744 r
.47421 .69564 .48094 .70192 .49313 .6764 .48641 .67606 Mtetra
.965 .775 .598 r
.48641 .67606 .49313 .6764 .50614 .48678 .49881 .62079 Mtetra
.516 .293 .515 r
.49881 .62079 .50614 .48678 .51752 .48319 .51076 .60431 Mtetra
.548 .318 .518 r
.51076 .60431 .51752 .48319 .52894 .47959 .52265 .60077 Mtetra
.559 .327 .52 r
.52265 .60077 .52894 .47959 .54041 .47596 .53461 .60128 Mtetra
.646 .4 .532 r
.53461 .60128 .54041 .47596 .55321 .62952 .54692 .64441 Mtetra
.778 .434 .404 r
.54692 .64441 .55321 .62952 .56592 .6759 .55943 .66974 Mtetra
.594 .751 .952 r
.55943 .66974 .56592 .6759 .57829 .67395 .57184 .66756 Mtetra
.908 .777 .705 r
.57184 .66756 .57829 .67395 .59007 .63707 .58391 .64194 Mtetra
.995 .819 .553 r
.58391 .64194 .59007 .63707 .59847 .45763 .59528 .58713 Mtetra
.53 .304 .517 r
.59528 .58713 .59847 .45763 .61023 .45391 .60738 .57586 Mtetra
.548 .318 .518 r
.60738 .57586 .61023 .45391 .62204 .45018 .6197 .57224 Mtetra
.567 .333 .52 r
.6197 .57224 .62204 .45018 .6339 .44644 .63232 .57629 Mtetra
.65 .401 .529 r
.63232 .57629 .6339 .44644 .65236 .61938 .64659 .62417 Mtetra
.797 .367 .227 r
.64659 .62417 .65236 .61938 .66635 .64947 .66017 .64287 Mtetra
.688 .774 .917 r
.66017 .64287 .66635 .64947 .67909 .64441 .67296 .63799 Mtetra
.936 .779 .662 r
.67296 .63799 .67909 .64441 .68952 .59037 .68451 .60522 Mtetra
.912 .82 .354 r
.68451 .60522 .68952 .59037 .69396 .42747 .69497 .55425 Mtetra
.539 .311 .518 r
.69497 .55425 .69396 .42747 .70613 .42363 .70747 .54643 Mtetra
.548 .318 .518 r
.70747 .54643 .70613 .42363 .71835 .41977 .72024 .54272 Mtetra
.579 .342 .521 r
.72024 .54272 .71835 .41977 .73062 .41589 .73389 .55223 Mtetra
.647 .397 .526 r
.73389 .55223 .73062 .41589 .75578 .60237 .75032 .60157 Mtetra
.686 .14 0 r
.75032 .60157 .75578 .60237 .77054 .62146 .76468 .6145 Mtetra
.754 .792 .883 r
.76468 .6145 .77054 .62146 .78348 .61303 .77772 .60676 Mtetra
.961 .782 .615 r
.77772 .60676 .78348 .61303 .79074 .53271 .78823 .5661 Mtetra
0 0 .244 r
.78823 .5661 .79074 .53271 .79279 .39626 .79821 .52178 Mtetra
.544 .315 .518 r
.79821 .52178 .79279 .39626 .80538 .39228 .81123 .51599 Mtetra
.549 .318 .518 r
.81123 .51599 .80538 .39228 .81803 .38829 .82449 .51237 Mtetra
.595 .353 .52 r
.82449 .51237 .81803 .38829 .83142 .3914 .83976 .52949 Mtetra
.643 .391 .523 r
.83976 .52949 .83142 .3914 .86349 .58118 .85829 .57736 Mtetra
0 .186 .625 r
.85829 .57736 .86349 .58118 .87894 .5945 .87343 .58735 Mtetra
.555 .719 .95 r
.87343 .58735 .87894 .5945 .89302 .59324 .88756 .58601 Mtetra
.625 .75 .936 r
.88756 .58601 .89302 .59324 .90697 .59 .90156 .58279 Mtetra
.638 .757 .934 r
.90156 .58279 .90697 .59 .92095 .58633 .91559 .57913 Mtetra
.643 .76 .934 r
.91559 .57913 .92095 .58633 .93498 .58254 .92967 .57532 Mtetra
.644 .762 .934 r
.92967 .57532 .93498 .58254 .94908 .57868 .94382 .57143 Mtetra
.648 .763 .933 r
.3151 .73845 .32232 .7443 .33369 .74109 .32651 .73521 Mtetra
.65 .763 .932 r
.32651 .73521 .33369 .74109 .34512 .73782 .33797 .7319 Mtetra
.656 .764 .929 r
.33797 .7319 .34512 .73782 .35661 .7344 .34949 .72842 Mtetra
.672 .767 .921 r
.34949 .72842 .35661 .7344 .36816 .73058 .36108 .72445 Mtetra
.71 .771 .9 r
.36108 .72445 .36816 .73058 .37983 .72496 .37276 .71919 Mtetra
.764 .788 .873 r
.37276 .71919 .37983 .72496 .39194 .7085 .38458 .71163 Mtetra
.411 .845 .716 r
.38458 .71163 .39194 .7085 .40527 .65561 .39637 .70546 Mtetra
.522 .263 .463 r
.39637 .70546 .40527 .65561 .41741 .63204 .4081 .70181 Mtetra
.536 .289 .489 r
.4081 .70181 .41741 .63204 .42891 .62839 .41988 .69844 Mtetra
.535 .289 .489 r
.41988 .69844 .42891 .62839 .44041 .62685 .43171 .69501 Mtetra
.538 .291 .488 r
.43171 .69501 .44041 .62685 .45117 .66269 .44357 .69225 Mtetra
.535 .24 .413 r
.44357 .69225 .45117 .66269 .46232 .69508 .45544 .69206 Mtetra
.516 .833 1 r
.45544 .69206 .46232 .69508 .47421 .69564 .46742 .68989 Mtetra
.739 .796 .898 r
.46742 .68989 .47421 .69564 .48641 .67606 .47951 .6834 Mtetra
.118 0 0 r
.47951 .6834 .48641 .67606 .49881 .62079 .49162 .67817 Mtetra
.53 .276 .475 r
.49162 .67817 .49881 .62079 .51076 .60431 .50376 .67472 Mtetra
.536 .29 .489 r
.50376 .67472 .51076 .60431 .52265 .60077 .51596 .6713 Mtetra
.51596 .6713 .52265 .60077 .53461 .60128 .52821 .6678 Mtetra
.539 .29 .486 r
.52821 .6678 .53461 .60128 .54692 .64441 .54052 .66528 Mtetra
.522 .194 .353 r
.54052 .66528 .54692 .64441 .55943 .66974 .55291 .66518 Mtetra
.61 .814 .979 r
.55291 .66518 .55943 .66974 .57184 .66756 .56535 .6621 Mtetra
.747 .817 .907 r
.56535 .6621 .57184 .66756 .58391 .64194 .57779 .65523 Mtetra
.354 0 .18 r
.57779 .65523 .58391 .64194 .59528 .58713 .59029 .65033 Mtetra
.533 .282 .481 r
.59029 .65033 .59528 .58713 .60738 .57586 .60288 .64681 Mtetra
.536 .29 .489 r
.60288 .64681 .60738 .57586 .6197 .57224 .61552 .64325 Mtetra
.61552 .64325 .6197 .57224 .63232 .57629 .62822 .63965 Mtetra
.54 .288 .483 r
.62822 .63965 .63232 .57629 .64659 .62417 .64102 .63743 Mtetra
.487 .105 .24 r
.64102 .63743 .64659 .62417 .66017 .64287 .65397 .63721 Mtetra
.656 .797 .95 r
.65397 .63721 .66017 .64287 .67296 .63799 .66685 .63318 Mtetra
.749 .85 .925 r
.66685 .63318 .67296 .63799 .68451 .60522 .67964 .62612 Mtetra
.447 .125 .326 r
.67964 .62612 .68451 .60522 .69497 .55425 .69259 .6215 Mtetra
.535 .286 .485 r
.69259 .6215 .69497 .55425 .70747 .54643 .70565 .61788 Mtetra
.536 .29 .489 r
.70565 .61788 .70747 .54643 .72024 .54272 .71876 .61417 Mtetra
.71876 .61417 .72024 .54272 .73389 .55223 .73193 .61049 Mtetra
.54 .284 .476 r
.73193 .61049 .73389 .55223 .75032 .60157 .74529 .60864 Mtetra
.393 0 .007 r
.74529 .60864 .75032 .60157 .76468 .6145 .75881 .60808 Mtetra
.685 .79 .93 r
.75881 .60808 .76468 .6145 .77772 .60676 .7721 .6031 Mtetra
.738 .901 .952 r
.7721 .6031 .77772 .60676 .78823 .5661 .78529 .59605 Mtetra
.489 .198 .398 r
.78529 .59605 .78823 .5661 .79821 .52178 .79873 .59165 Mtetra
.536 .288 .487 r
.79873 .59165 .79821 .52178 .81123 .51599 .81228 .58793 Mtetra
.536 .29 .489 r
.81228 .58793 .81123 .51599 .82449 .51237 .8259 .58415 Mtetra
.537 .291 .489 r
.8259 .58415 .82449 .51237 .83976 .52949 .83961 .58067 Mtetra
.543 .279 .465 r
.83961 .58067 .83976 .52949 .85829 .57736 .85364 .57982 Mtetra
.259 0 0 r
.85364 .57982 .85829 .57736 .87343 .58735 .86791 .58044 Mtetra
.567 .735 .955 r
.86791 .58044 .87343 .58735 .88756 .58601 .88204 .57866 Mtetra
.621 .746 .936 r
.88204 .57866 .88756 .58601 .90156 .58279 .8961 .57552 Mtetra
.637 .757 .935 r
.8961 .57552 .90156 .58279 .91559 .57913 .91019 .57188 Mtetra
.642 .76 .934 r
.91019 .57188 .91559 .57913 .92967 .57532 .92432 .56804 Mtetra
.644 .762 .934 r
.92432 .56804 .92967 .57532 .94382 .57143 .93851 .56412 Mtetra
.648 .763 .933 r
.30783 .73254 .3151 .73845 .32651 .73521 .31927 .72928 Mtetra
.65 .763 .932 r
.31927 .72928 .32651 .73521 .33797 .7319 .33076 .72595 Mtetra
.656 .765 .929 r
.33076 .72595 .33797 .7319 .34949 .72842 .34231 .72242 Mtetra
.674 .768 .922 r
.34231 .72242 .34949 .72842 .36108 .72445 .35393 .71839 Mtetra
.705 .773 .905 r
.35393 .71839 .36108 .72445 .37276 .71919 .36564 .71332 Mtetra
.716 .782 .904 r
.36564 .71332 .37276 .71919 .38458 .71163 .37741 .70785 Mtetra
.662 .844 .97 r
.37741 .70785 .38458 .71163 .39637 .70546 .38917 .70372 Mtetra
.556 .886 .988 r
.38917 .70372 .39637 .70546 .4081 .70181 .40094 .7003 Mtetra
.538 .887 .983 r
.40094 .7003 .4081 .70181 .41988 .69844 .41276 .69691 Mtetra
.544 .889 .983 r
.41276 .69691 .41988 .69844 .43171 .69501 .42464 .69344 Mtetra
.545 .888 .984 r
.42464 .69344 .43171 .69501 .44357 .69225 .43657 .68995 Mtetra
.538 .865 .995 r
.43657 .68995 .44357 .69225 .45544 .69206 .44854 .68703 Mtetra
.624 .796 .965 r
.44854 .68703 .45544 .69206 .46742 .68989 .46057 .68394 Mtetra
.669 .778 .931 r
.46057 .68394 .46742 .68989 .47951 .6834 .47266 .67986 Mtetra
.616 .85 .987 r
.47266 .67986 .47951 .6834 .49162 .67817 .4848 .67635 Mtetra
.533 .88 .986 r
.4848 .67635 .49162 .67817 .50376 .67472 .49699 .67303 Mtetra
.533 .884 .983 r
.49699 .67303 .50376 .67472 .51596 .6713 .50924 .66959 Mtetra
.542 .888 .983 r
.50924 .66959 .51596 .6713 .52821 .6678 .52155 .66602 Mtetra
.542 .887 .984 r
.52155 .66602 .52821 .6678 .54052 .66528 .5339 .66247 Mtetra
.546 .857 .997 r
.5339 .66247 .54052 .66528 .55291 .66518 .54632 .65954 Mtetra
.637 .786 .953 r
.54632 .65954 .55291 .66518 .56535 .6621 .55879 .65613 Mtetra
.667 .785 .937 r
.55879 .65613 .56535 .6621 .57779 .65523 .57131 .65195 Mtetra
.599 .861 .993 r
.57131 .65195 .57779 .65523 .59029 .65033 .5839 .64839 Mtetra
.531 .881 .985 r
.5839 .64839 .59029 .65033 .60288 .64681 .59654 .64494 Mtetra
.534 .885 .983 r
.59654 .64494 .60288 .64681 .61552 .64325 .60924 .64135 Mtetra
.543 .888 .983 r
.60924 .64135 .61552 .64325 .62822 .63965 .62199 .63763 Mtetra
.539 .884 .985 r
.62199 .63763 .62822 .63965 .64102 .63743 .6348 .63402 Mtetra
.56 .847 .997 r
.6348 .63402 .64102 .63743 .65397 .63721 .6477 .63104 Mtetra
.648 .779 .944 r
.6477 .63104 .65397 .63721 .66685 .63318 .66063 .62728 Mtetra
.663 .794 .945 r
.66063 .62728 .66685 .63318 .67964 .62612 .6736 .62303 Mtetra
.581 .869 .995 r
.6736 .62303 .67964 .62612 .69259 .6215 .68665 .61941 Mtetra
.53 .882 .984 r
.68665 .61941 .69259 .6215 .70565 .61788 .69977 .61581 Mtetra
.535 .885 .983 r
.69977 .61581 .70565 .61788 .71876 .61417 .71294 .61207 Mtetra
.543 .889 .983 r
.71294 .61207 .71876 .61417 .73193 .61049 .72617 .6082 Mtetra
.537 .881 .986 r
.72617 .6082 .73193 .61049 .74529 .60864 .73947 .60454 Mtetra
.576 .835 .994 r
.73947 .60454 .74529 .60864 .75881 .60808 .75288 .60146 Mtetra
.656 .775 .937 r
.75288 .60146 .75881 .60808 .7721 .6031 .76628 .59735 Mtetra
.656 .806 .955 r
.76628 .59735 .7721 .6031 .78529 .59605 .77973 .59307 Mtetra
.564 .874 .994 r
.77973 .59307 .78529 .59605 .79873 .59165 .79329 .58937 Mtetra
.527 .881 .983 r
.79329 .58937 .79873 .59165 .81228 .58793 .80691 .58565 Mtetra
.53 .883 .983 r
.80691 .58565 .81228 .58793 .8259 .58415 .82059 .58184 Mtetra
.527 .882 .983 r
.82059 .58184 .8259 .58415 .83961 .58067 .83434 .57807 Mtetra
.493 .858 .988 r
.83434 .57807 .83961 .58067 .85364 .57982 .84823 .57503 Mtetra
.508 .786 .995 r
.84823 .57503 .85364 .57982 .86791 .58044 .86234 .57341 Mtetra
.577 .738 .952 r
.86234 .57341 .86791 .58044 .88204 .57866 .87648 .57137 Mtetra
.619 .749 .939 r
.87648 .57137 .88204 .57866 .8961 .57552 .8906 .56823 Mtetra
.636 .758 .936 r
.8906 .56823 .8961 .57552 .91019 .57188 .90473 .56457 Mtetra
.642 .761 .935 r
.90473 .56457 .91019 .57188 .92432 .56804 .91892 .5607 Mtetra
.644 .762 .934 r
.91892 .5607 .92432 .56804 .93851 .56412 .93316 .55674 Mtetra
.648 .763 .933 r
.3005 .7266 .30783 .73254 .31927 .72928 .31197 .72331 Mtetra
.65 .763 .932 r
.31197 .72331 .31927 .72928 .33076 .72595 .32349 .71995 Mtetra
.655 .765 .93 r
.32349 .71995 .33076 .72595 .34231 .72242 .33507 .71644 Mtetra
.67 .769 .924 r
.33507 .71644 .34231 .72242 .35393 .71839 .34672 .71248 Mtetra
.718 .781 .902 r
.34672 .71248 .35393 .71839 .36564 .71332 .35849 .70689 Mtetra
.821 .773 .807 r
.35849 .70689 .36564 .71332 .37741 .70785 .37059 .69469 Mtetra
.797 .669 .723 r
.37059 .69469 .37741 .70785 .38917 .70372 .38288 .67762 Mtetra
.639 .51 .69 r
.38288 .67762 .38917 .70372 .40094 .7003 .39471 .6717 Mtetra
.609 .482 .682 r
.39471 .6717 .40094 .7003 .41276 .69691 .40649 .66823 Mtetra
.607 .481 .682 r
.40649 .66823 .41276 .69691 .42464 .69344 .41832 .66492 Mtetra
.536 .435 .687 r
.41832 .66492 .42464 .69344 .43657 .68995 .43004 .66742 Mtetra
.346 .343 .713 r
.43004 .66742 .43657 .68995 .44854 .68703 .44168 .67763 Mtetra
.561 .644 .889 r
.44168 .67763 .44854 .68703 .46057 .68394 .45368 .67697 Mtetra
.823 .771 .804 r
.45368 .67697 .46057 .68394 .47266 .67986 .46595 .6643 Mtetra
.771 .643 .72 r
.46595 .6643 .47266 .67986 .4848 .67635 .47826 .64886 Mtetra
.625 .497 .687 r
.47826 .64886 .4848 .67635 .49699 .67303 .49042 .64398 Mtetra
.608 .481 .682 r
.49042 .64398 .49699 .67303 .50924 .66959 .50263 .64047 Mtetra
.604 .479 .683 r
.50263 .64047 .50924 .66959 .52155 .66602 .51489 .63729 Mtetra
.509 .418 .689 r
.51489 .63729 .52155 .66602 .5339 .66247 .52721 .64182 Mtetra
.363 .372 .735 r
.52721 .64182 .5339 .66247 .54632 .65954 .53966 .65103 Mtetra
.622 .696 .897 r
.53966 .65103 .54632 .65954 .55879 .65613 .55217 .6484 Mtetra
.839 .767 .783 r
.55217 .6484 .55879 .65613 .57131 .65195 .5646 .63361 Mtetra
.742 .613 .714 r
.5646 .63361 .57131 .65195 .5839 .64839 .57702 .61979 Mtetra
.617 .49 .685 r
.57702 .61979 .5839 .64839 .59654 .64494 .58961 .61542 Mtetra
.608 .481 .682 r
.58961 .61542 .59654 .64494 .60924 .64135 .60226 .61178 Mtetra
.6 .477 .683 r
.60226 .61178 .60924 .64135 .62199 .63763 .61499 .60886 Mtetra
.481 .403 .691 r
.61499 .60886 .62199 .63763 .6348 .63402 .62807 .61546 Mtetra
.391 .412 .762 r
.62807 .61546 .6348 .63402 .6477 .63104 .64131 .62308 Mtetra
.676 .737 .896 r
.64131 .62308 .6477 .63104 .66063 .62728 .65425 .61847 Mtetra
.847 .759 .764 r
.65425 .61847 .66063 .62728 .6736 .62303 .66674 .60185 Mtetra
.711 .581 .708 r
.66674 .60185 .6736 .62303 .68665 .61941 .67941 .58993 Mtetra
.612 .486 .684 r
.67941 .58993 .68665 .61941 .69977 .61581 .69246 .58581 Mtetra
.608 .481 .682 r
.69246 .58581 .69977 .61581 .71294 .61207 .70558 .58203 Mtetra
.594 .473 .684 r
.70558 .58203 .71294 .61207 .72617 .6082 .71885 .57965 Mtetra
.457 .39 .694 r
.71885 .57965 .72617 .6082 .73947 .60454 .73285 .5881 Mtetra
.429 .461 .791 r
.73285 .5881 .73947 .60454 .75288 .60146 .74683 .59376 Mtetra
.724 .768 .887 r
.74683 .59376 .75288 .60146 .76628 .59735 .76009 .5871 Mtetra
.848 .745 .75 r
.76009 .5871 .76628 .59735 .77973 .59307 .77258 .56917 Mtetra
.682 .552 .701 r
.77258 .56917 .77973 .59307 .79329 .58937 .78563 .55917 Mtetra
.609 .483 .683 r
.78563 .55917 .79329 .58937 .80691 .58565 .79919 .55517 Mtetra
.607 .481 .682 r
.79919 .55517 .80691 .58565 .82059 .58184 .81282 .55132 Mtetra
.582 .465 .685 r
.81282 .55132 .82059 .58184 .83434 .57807 .82674 .55003 Mtetra
.431 .379 .699 r
.82674 .55003 .83434 .57807 .84823 .57503 .84185 .56042 Mtetra
.421 .483 .818 r
.84185 .56042 .84823 .57503 .86234 .57341 .85666 .56578 Mtetra
.564 .715 .942 r
.85666 .56578 .86234 .57341 .87648 .57137 .8709 .56421 Mtetra
.621 .756 .943 r
.8709 .56421 .87648 .57137 .8906 .56823 .88506 .56094 Mtetra
.637 .76 .937 r
.88506 .56094 .8906 .56823 .90473 .56457 .89923 .5572 Mtetra
.642 .761 .935 r
.89923 .5572 .90473 .56457 .91892 .5607 .91347 .55329 Mtetra
.644 .762 .934 r
.91347 .55329 .91892 .5607 .93316 .55674 .92776 .5493 Mtetra
.647 .763 .933 r
.29311 .7206 .3005 .7266 .31197 .72331 .30461 .71729 Mtetra
.649 .763 .932 r
.30461 .71729 .31197 .72331 .32349 .71995 .31616 .71392 Mtetra
.654 .765 .931 r
.31616 .71392 .32349 .71995 .33507 .71644 .32777 .71042 Mtetra
.667 .769 .926 r
.32777 .71042 .33507 .71644 .34672 .71248 .33945 .70652 Mtetra
.723 .782 .899 r
.33945 .70652 .34672 .71248 .35849 .70689 .35127 .70072 Mtetra
.87 .768 .747 r
.35127 .70072 .35849 .70689 .37059 .69469 .36374 .68147 Mtetra
.925 .691 .566 r
.36374 .68147 .37059 .69469 .38288 .67762 .38115 .54518 Mtetra
.695 .475 .584 r
.38115 .54518 .38288 .67762 .39471 .6717 .39498 .47875 Mtetra
.567 .366 .568 r
.39498 .47875 .39471 .6717 .40649 .66823 .40617 .47513 Mtetra
.40617 .47513 .40649 .66823 .41832 .66492 .41741 .47149 Mtetra
.133 .031 .463 r
.41741 .47149 .41832 .66492 .43004 .66742 .42458 .60895 Mtetra
0 0 .412 r
.42458 .60895 .43004 .66742 .44168 .67763 .43474 .66946 Mtetra
.465 .634 .928 r
.43474 .66946 .44168 .67763 .45368 .67697 .44672 .67051 Mtetra
.895 .768 .713 r
.44672 .67051 .45368 .67697 .46595 .6643 .45927 .6459 Mtetra
.932 .686 .543 r
.45927 .6459 .46595 .6643 .47826 .64886 .47406 .47069 Mtetra
.6 .393 .573 r
.47406 .47069 .47826 .64886 .49042 .64398 .48586 .44932 Mtetra
.567 .366 .568 r
.48586 .44932 .49042 .64398 .50263 .64047 .49744 .44557 Mtetra
.49744 .44557 .50263 .64047 .51489 .63729 .50906 .44181 Mtetra
.083 .001 .454 r
.50906 .44181 .51489 .63729 .52721 .64182 .52053 .60212 Mtetra
0 0 .497 r
.52053 .60212 .52721 .64182 .53966 .65103 .53295 .64353 Mtetra
.598 .716 .927 r
.53295 .64353 .53966 .65103 .55217 .6484 .5455 .64141 Mtetra
.924 .76 .661 r
.5455 .64141 .55217 .6484 .5646 .63361 .5578 .60665 Mtetra
.932 .676 .528 r
.5578 .60665 .5646 .63361 .57702 .61979 .56794 .42274 Mtetra
.567 .366 .568 r
.56794 .42274 .57702 .61979 .58961 .61542 .57987 .41888 Mtetra
.57987 .41888 .58961 .61542 .60226 .61178 .59185 .415 Mtetra
.59185 .415 .60226 .61178 .61499 .60886 .60388 .4111 Mtetra
.073 .001 .461 r
.60388 .4111 .61499 .60886 .62807 .61546 .62107 .58822 Mtetra
0 .08 .596 r
.62107 .58822 .62807 .61546 .64131 .62308 .63491 .61588 Mtetra
.692 .765 .907 r
.63491 .61588 .64131 .62308 .65425 .61847 .64786 .61069 Mtetra
.948 .751 .604 r
.64786 .61069 .65425 .61847 .66674 .60185 .65912 .56138 Mtetra
.918 .656 .525 r
.65912 .56138 .66674 .60185 .67941 .58993 .66483 .39136 Mtetra
.567 .366 .568 r
.66483 .39136 .67941 .58993 .69246 .58581 .67718 .38737 Mtetra
.67718 .38737 .69246 .58581 .70558 .58203 .68958 .38335 Mtetra
.535 .342 .566 r
.68958 .38335 .70558 .58203 .71885 .57965 .70304 .39738 Mtetra
.091 .024 .48 r
.70304 .39738 .71885 .57965 .73285 .5881 .72603 .56875 Mtetra
.108 .223 .702 r
.72603 .56875 .73285 .5881 .74683 .59376 .74076 .5866 Mtetra
.766 .795 .877 r
.74076 .5866 .74683 .59376 .76009 .5871 .75396 .5781 Mtetra
.966 .738 .544 r
.75396 .5781 .76009 .5871 .77258 .56917 .7628 .50821 Mtetra
.884 .618 .532 r
.7628 .50821 .77258 .56917 .78563 .55917 .76516 .35887 Mtetra
.567 .366 .568 r
.76516 .35887 .78563 .55917 .79919 .55517 .77795 .35473 Mtetra
.77795 .35473 .79919 .55517 .81282 .55132 .7908 .35057 Mtetra
.446 .28 .561 r
.7908 .35057 .81282 .55132 .82674 .55003 .80945 .41157 Mtetra
.121 .061 .509 r
.80945 .41157 .82674 .55003 .84185 .56042 .83544 .54573 Mtetra
.178 .329 .78 r
.83544 .54573 .84185 .56042 .85666 .56578 .85096 .5584 Mtetra
.553 .719 .951 r
.85096 .5584 .85666 .56578 .8709 .56421 .86527 .55699 Mtetra
.624 .758 .942 r
.86527 .55699 .8709 .56421 .88506 .56094 .87946 .5536 Mtetra
.639 .761 .937 r
.87946 .5536 .88506 .56094 .89923 .5572 .89369 .54978 Mtetra
.643 .762 .935 r
.89369 .54978 .89923 .5572 .91347 .55329 .90797 .54582 Mtetra
.644 .762 .934 r
.90797 .54582 .91347 .55329 .92776 .5493 .92231 .54179 Mtetra
.647 .763 .933 r
.28566 .71456 .29311 .7206 .30461 .71729 .29719 .71122 Mtetra
.649 .763 .933 r
.29719 .71122 .30461 .71729 .31616 .71392 .30877 .70784 Mtetra
.653 .764 .931 r
.30877 .70784 .31616 .71392 .32777 .71042 .32041 .70434 Mtetra
.666 .768 .926 r
.32041 .70434 .32777 .71042 .33945 .70652 .33212 .70043 Mtetra
.723 .78 .898 r
.33212 .70043 .33945 .70652 .35127 .70072 .34398 .6946 Mtetra
.875 .769 .742 r
.34398 .6946 .35127 .70072 .36374 .68147 .35655 .67453 Mtetra
.939 .699 .547 r
.35655 .67453 .36374 .68147 .38115 .54518 .37708 .47568 Mtetra
.581 .401 .603 r
.37708 .47568 .38115 .54518 .39498 .47875 .38826 .47205 Mtetra
.664 .741 .907 r
.38826 .47205 .39498 .47875 .40617 .47513 .39948 .46839 Mtetra
.39948 .46839 .40617 .47513 .41741 .47149 .41075 .46473 Mtetra
.953 .659 .44 r
.41075 .46473 .41741 .47149 .42458 .60895 .41805 .58934 Mtetra
.968 .652 .28 r
.41805 .58934 .42458 .60895 .43474 .66946 .4277 .66303 Mtetra
.399 .662 .965 r
.4277 .66303 .43474 .66946 .44672 .67051 .4397 .66422 Mtetra
.902 .768 .705 r
.4397 .66422 .44672 .67051 .45927 .6459 .45237 .63802 Mtetra
.949 .702 .53 r
.45237 .63802 .45927 .6459 .47406 .47069 .46782 .44615 Mtetra
.616 .499 .696 r
.46782 .44615 .47406 .47069 .48586 .44932 .47938 .44239 Mtetra
.664 .741 .907 r
.47938 .44239 .48586 .44932 .49744 .44557 .49099 .43861 Mtetra
.49099 .43861 .49744 .44557 .50906 .44181 .50265 .43481 Mtetra
.961 .661 .418 r
.50265 .43481 .50906 .44181 .52053 .60212 .51384 .58918 Mtetra
.927 .564 .144 r
.51384 .58918 .52053 .60212 .53295 .64353 .52619 .63696 Mtetra
.587 .743 .951 r
.52619 .63696 .53295 .64353 .5455 .64141 .53877 .63486 Mtetra
.932 .762 .648 r
.53877 .63486 .5455 .64141 .5578 .60665 .55115 .59692 Mtetra
.957 .703 .511 r
.55115 .59692 .5578 .60665 .56794 .42274 .56169 .41559 Mtetra
.664 .741 .907 r
.56169 .41559 .56794 .42274 .57987 .41888 .57366 .4117 Mtetra
.57366 .4117 .57987 .41888 .59185 .415 .58567 .40779 Mtetra
.58567 .40779 .59185 .415 .60388 .4111 .59774 .40386 Mtetra
.967 .658 .383 r
.59774 .40386 .60388 .4111 .62107 .58822 .61456 .57832 Mtetra
.812 .395 0 r
.61456 .57832 .62107 .58822 .63491 .61588 .62846 .60911 Mtetra
.694 .78 .917 r
.62846 .60911 .63491 .61588 .64786 .61069 .64146 .60384 Mtetra
.957 .752 .586 r
.64146 .60384 .64786 .61069 .65912 .56138 .65259 .54803 Mtetra
.961 .701 .495 r
.65259 .54803 .65912 .56138 .66483 .39136 .65886 .38397 Mtetra
.664 .741 .907 r
.65886 .38397 .66483 .39136 .67718 .38737 .67125 .37994 Mtetra
.67125 .37994 .67718 .38737 .68958 .38335 .68369 .37589 Mtetra
.68369 .37589 .68958 .38335 .70304 .39738 .69618 .37182 Mtetra
.965 .655 .259 r
.69618 .37182 .70304 .39738 .72603 .56875 .71982 .56018 Mtetra
0 0 .455 r
.71982 .56018 .72603 .56875 .74076 .5866 .73466 .5796 Mtetra
.771 .803 .878 r
.73466 .5796 .74076 .5866 .75396 .5781 .74789 .57089 Mtetra
.975 .739 .516 r
.74789 .57089 .75396 .5781 .7628 .50821 .75594 .48737 Mtetra
.954 .689 .495 r
.75594 .48737 .7628 .50821 .76516 .35887 .7595 .35121 Mtetra
.664 .741 .907 r
.7595 .35121 .76516 .35887 .77795 .35473 .77233 .34703 Mtetra
.77233 .34703 .77795 .35473 .7908 .35057 .78522 .34284 Mtetra
.78522 .34284 .7908 .35057 .80945 .41157 .79817 .33862 Mtetra
0 0 .134 r
.79817 .33862 .80945 .41157 .83544 .54573 .82961 .53761 Mtetra
0 .19 .712 r
.82961 .53761 .83544 .54573 .85096 .5584 .84522 .55106 Mtetra
.551 .722 .953 r
.84522 .55106 .85096 .5584 .86527 .55699 .85958 .54963 Mtetra
.626 .756 .94 r
.85958 .54963 .86527 .55699 .87946 .5536 .87382 .54617 Mtetra
.64 .761 .936 r
.87382 .54617 .87946 .5536 .89369 .54978 .88809 .54229 Mtetra
.643 .762 .935 r
.88809 .54229 .89369 .54978 .90797 .54582 .90242 .53828 Mtetra
.645 .762 .934 r
.90242 .53828 .90797 .54582 .92231 .54179 .91681 .53421 Mtetra
.647 .763 .933 r
.27816 .70847 .28566 .71456 .29719 .71122 .28971 .70511 Mtetra
.649 .763 .933 r
.28971 .70511 .29719 .71122 .30877 .70784 .30133 .7017 Mtetra
.653 .764 .931 r
.30133 .7017 .30877 .70784 .32041 .70434 .313 .69817 Mtetra
.666 .767 .925 r
.313 .69817 .32041 .70434 .33212 .70043 .32474 .69424 Mtetra
.722 .778 .897 r
.32474 .69424 .33212 .70043 .34398 .6946 .33663 .68837 Mtetra
.874 .768 .742 r
.33663 .68837 .34398 .6946 .35655 .67453 .34927 .66823 Mtetra
.94 .7 .547 r
.34927 .66823 .35655 .67453 .37708 .47568 .37028 .46896 Mtetra
.664 .741 .907 r
.37028 .46896 .37708 .47568 .38826 .47205 .38148 .46529 Mtetra
.38148 .46529 .38826 .47205 .39948 .46839 .39273 .46161 Mtetra
.39273 .46161 .39948 .46839 .41075 .46473 .40403 .45791 Mtetra
.953 .659 .44 r
.40403 .45791 .41075 .46473 .41805 .58934 .41109 .58271 Mtetra
.952 .632 .385 r
.41109 .58271 .41805 .58934 .4277 .66303 .4206 .65659 Mtetra
.397 .663 .966 r
.4206 .65659 .4277 .66303 .4397 .66422 .43263 .65777 Mtetra
.901 .767 .704 r
.43263 .65777 .4397 .66422 .45237 .63802 .44538 .63148 Mtetra
.951 .704 .529 r
.44538 .63148 .45237 .63802 .46782 .44615 .46126 .43919 Mtetra
.664 .741 .907 r
.46126 .43919 .46782 .44615 .47938 .44239 .47285 .4354 Mtetra
.47285 .4354 .47938 .44239 .49099 .43861 .48449 .43159 Mtetra
.48449 .43159 .49099 .43861 .50265 .43481 .49618 .42777 Mtetra
.961 .661 .418 r
.49618 .42777 .50265 .43481 .51384 .58918 .50709 .5824 Mtetra
.94 .573 .254 r
.50709 .5824 .51384 .58918 .52619 .63696 .51938 .63029 Mtetra
.587 .742 .95 r
.51938 .63029 .52619 .63696 .53877 .63486 .53199 .62817 Mtetra
.931 .761 .648 r
.53199 .62817 .53877 .63486 .55115 .59692 .54447 .59011 Mtetra
.961 .708 .507 r
.54447 .59011 .55115 .59692 .56169 .41559 .55539 .40839 Mtetra
.664 .741 .907 r
.55539 .40839 .56169 .41559 .57366 .4117 .56739 .40447 Mtetra
.56739 .40447 .57366 .4117 .58567 .40779 .57944 .40053 Mtetra
.57944 .40053 .58567 .40779 .59774 .40386 .59154 .39657 Mtetra
.967 .658 .383 r
.59154 .39657 .59774 .40386 .61456 .57832 .60807 .57135 Mtetra
.865 .435 .014 r
.60807 .57135 .61456 .57832 .62846 .60911 .62195 .6022 Mtetra
.694 .777 .915 r
.62195 .6022 .62846 .60911 .64146 .60384 .635 .59689 Mtetra
.957 .752 .586 r
.635 .59689 .64146 .60384 .65259 .54803 .64626 .5409 Mtetra
.971 .712 .484 r
.64626 .5409 .65259 .54803 .65886 .38397 .65284 .37651 Mtetra
.664 .741 .907 r
.65284 .37651 .65886 .38397 .67125 .37994 .66527 .37245 Mtetra
.66527 .37245 .67125 .37994 .68369 .37589 .67775 .36836 Mtetra
.67775 .36836 .68369 .37589 .69618 .37182 .69028 .36426 Mtetra
.969 .65 .337 r
.69028 .36426 .69618 .37182 .71982 .56018 .71365 .55297 Mtetra
.614 .141 0 r
.71365 .55297 .71982 .56018 .73466 .5796 .72849 .57242 Mtetra
.77 .8 .877 r
.72849 .57242 .73466 .5796 .74789 .57089 .74178 .56367 Mtetra
.976 .739 .515 r
.74178 .56367 .74789 .57089 .75594 .48737 .74999 .47987 Mtetra
.979 .717 .463 r
.74999 .47987 .75594 .48737 .7595 .35121 .75379 .34348 Mtetra
.664 .741 .907 r
.75379 .34348 .7595 .35121 .77233 .34703 .76666 .33927 Mtetra
.76666 .33927 .77233 .34703 .78522 .34284 .7796 .33504 Mtetra
.7796 .33504 .78522 .34284 .79817 .33862 .79259 .33079 Mtetra
.964 .635 .278 r
.79259 .33079 .79817 .33862 .82961 .53761 .82379 .53014 Mtetra
0 .165 .685 r
.82379 .53014 .82961 .53761 .84522 .55106 .83943 .5436 Mtetra
.552 .72 .952 r
.83943 .5436 .84522 .55106 .85958 .54963 .85383 .54214 Mtetra
.626 .754 .939 r
.85383 .54214 .85958 .54963 .87382 .54617 .86812 .53865 Mtetra
.64 .76 .935 r
.86812 .53865 .87382 .54617 .88809 .54229 .88244 .53472 Mtetra
.643 .761 .934 r
.88244 .53472 .88809 .54229 .90242 .53828 .89682 .53068 Mtetra
.645 .762 .934 r
.89682 .53068 .90242 .53828 .91681 .53421 .91127 .52657 Mtetra
.647 .763 .933 r
.27059 .70232 .27816 .70847 .28971 .70511 .28218 .69894 Mtetra
.649 .763 .932 r
.28218 .69894 .28971 .70511 .30133 .7017 .29382 .69549 Mtetra
.653 .764 .931 r
.29382 .69549 .30133 .7017 .313 .69817 .30552 .69191 Mtetra
.667 .766 .924 r
.30552 .69191 .313 .69817 .32474 .69424 .3173 .68794 Mtetra
.722 .776 .895 r
.3173 .68794 .32474 .69424 .33663 .68837 .32923 .68204 Mtetra
.873 .767 .743 r
.32923 .68204 .33663 .68837 .34927 .66823 .34193 .66205 Mtetra
.94 .702 .55 r
.34193 .66205 .34927 .66823 .37028 .46896 .36249 .48102 Mtetra
.772 .887 .473 r
.36249 .48102 .37028 .46896 .38148 .46529 .37465 .45848 Mtetra
.664 .741 .907 r
.37465 .45848 .38148 .46529 .39273 .46161 .38594 .45477 Mtetra
.38594 .45477 .39273 .46161 .40403 .45791 .39727 .45105 Mtetra
.953 .66 .442 r
.39727 .45105 .40403 .45791 .41109 .58271 .40392 .58012 Mtetra
.938 .617 .401 r
.40392 .58012 .41109 .58271 .4206 .65659 .41344 .65004 Mtetra
.403 .663 .965 r
.41344 .65004 .4206 .65659 .43263 .65777 .4255 .65115 Mtetra
.899 .766 .707 r
.4255 .65115 .43263 .65777 .44538 .63148 .43832 .62523 Mtetra
.951 .705 .528 r
.43832 .62523 .44538 .63148 .46126 .43919 .45464 .43218 Mtetra
.664 .741 .907 r
.45464 .43218 .46126 .43919 .47285 .4354 .46627 .42835 Mtetra
.46627 .42835 .47285 .4354 .48449 .43159 .47794 .42452 Mtetra
.47794 .42452 .48449 .43159 .49618 .42777 .48966 .42066 Mtetra
.961 .662 .419 r
.48966 .42066 .49618 .42777 .50709 .5824 .50027 .57742 Mtetra
.935 .565 .27 r
.50027 .57742 .50709 .5824 .51938 .63029 .5125 .62347 Mtetra
.589 .739 .947 r
.5125 .62347 .51938 .63029 .53199 .62817 .52515 .6213 Mtetra
.929 .761 .652 r
.52515 .6213 .53199 .62817 .54447 .59011 .53774 .58405 Mtetra
.962 .709 .506 r
.53774 .58405 .54447 .59011 .55539 .40839 .54904 .40113 Mtetra
.664 .741 .907 r
.54904 .40113 .55539 .40839 .56739 .40447 .56107 .39718 Mtetra
.56107 .39718 .56739 .40447 .57944 .40053 .57315 .3932 Mtetra
.57315 .3932 .57944 .40053 .59154 .39657 .58529 .38921 Mtetra
.967 .658 .383 r
.58529 .38921 .59154 .39657 .60807 .57135 .60155 .56514 Mtetra
.868 .432 .028 r
.60155 .56514 .60807 .57135 .62195 .6022 .61539 .59511 Mtetra
.694 .774 .913 r
.61539 .59511 .62195 .6022 .635 .59689 .62848 .58978 Mtetra
.955 .753 .591 r
.62848 .58978 .635 .59689 .64626 .5409 .63994 .53558 Mtetra
.973 .715 .48 r
.63994 .53558 .64626 .5409 .65284 .37651 .64678 .36899 Mtetra
.664 .741 .907 r
.64678 .36899 .65284 .37651 .66527 .37245 .65924 .3649 Mtetra
.65924 .3649 .66527 .37245 .67775 .36836 .67175 .36078 Mtetra
.67175 .36078 .67775 .36836 .69028 .36426 .68433 .35664 Mtetra
.969 .65 .337 r
.68433 .35664 .69028 .36426 .71365 .55297 .70744 .54606 Mtetra
.618 .138 0 r
.70744 .54606 .71365 .55297 .72849 .57242 .72227 .56506 Mtetra
.768 .796 .875 r
.72227 .56506 .72849 .57242 .74178 .56367 .73561 .55631 Mtetra
.975 .741 .522 r
.73561 .55631 .74178 .56367 .74999 .47987 .74426 .47655 Mtetra
.985 .724 .449 r
.74426 .47655 .74999 .47987 .75379 .34348 .74803 .33569 Mtetra
.664 .741 .907 r
.74803 .33569 .75379 .34348 .76666 .33927 .76095 .33145 Mtetra
.76095 .33145 .76666 .33927 .7796 .33504 .77392 .32718 Mtetra
0 .061 .603 r
.77392 .32718 .7796 .33504 .79259 .33079 .78859 .34259 Mtetra
.952 .618 .348 r
.78859 .34259 .79259 .33079 .82379 .53014 .81793 .52278 Mtetra
0 .169 .686 r
.81793 .52278 .82379 .53014 .83943 .5436 .83358 .53602 Mtetra
.553 .719 .95 r
.83358 .53602 .83943 .5436 .85383 .54214 .84802 .53452 Mtetra
.626 .752 .938 r
.84802 .53452 .85383 .54214 .86812 .53865 .86236 .53101 Mtetra
.639 .759 .935 r
.86236 .53101 .86812 .53865 .88244 .53472 .87674 .52707 Mtetra
.643 .761 .934 r
.87674 .52707 .88244 .53472 .89682 .53068 .89117 .523 Mtetra
.644 .762 .934 r
.89117 .523 .89682 .53068 .91127 .52657 .90567 .51885 Mtetra
.648 .763 .933 r
.26295 .69613 .27059 .70232 .28218 .69894 .27457 .69271 Mtetra
.65 .763 .932 r
.27457 .69271 .28218 .69894 .29382 .69549 .28625 .68923 Mtetra
.655 .764 .93 r
.28625 .68923 .29382 .69549 .30552 .69191 .29799 .68558 Mtetra
.669 .766 .923 r
.29799 .68558 .30552 .69191 .3173 .68794 .3098 .68151 Mtetra
.72 .774 .895 r
.3098 .68151 .3173 .68794 .32923 .68204 .32176 .67566 Mtetra
.849 .775 .779 r
.32176 .67566 .32923 .68204 .34193 .66205 .33429 .66008 Mtetra
.941 .786 .661 r
.33429 .66008 .34193 .66205 .36249 .48102 .34791 .62279 Mtetra
.511 .281 .502 r
.34791 .62279 .36249 .48102 .37465 .45848 .36022 .60908 Mtetra
.539 .306 .511 r
.36022 .60908 .37465 .45848 .38594 .45477 .37207 .60537 Mtetra
.541 .308 .511 r
.37207 .60537 .38594 .45477 .39727 .45105 .38392 .60258 Mtetra
.586 .346 .52 r
.38392 .60258 .39727 .45105 .40392 .58012 .39506 .62051 Mtetra
.683 .392 .475 r
.39506 .62051 .40392 .58012 .41344 .65004 .4062 .64443 Mtetra
.438 .715 .983 r
.4062 .64443 .41344 .65004 .4255 .65115 .41831 .64451 Mtetra
.867 .779 .763 r
.41831 .64451 .4255 .65115 .43832 .62523 .43099 .62668 Mtetra
.973 .836 .646 r
.43099 .62668 .43832 .62523 .45464 .43218 .44408 .5898 Mtetra
.526 .296 .509 r
.44408 .5898 .45464 .43218 .46627 .42835 .45644 .57986 Mtetra
.539 .307 .511 r
.45644 .57986 .46627 .42835 .47794 .42452 .46871 .57615 Mtetra
.544 .31 .512 r
.46871 .57615 .47794 .42452 .48966 .42066 .48102 .57427 Mtetra
.594 .352 .52 r
.48102 .57427 .48966 .42066 .50027 .57742 .49315 .59747 Mtetra
.719 .38 .403 r
.49315 .59747 .50027 .57742 .5125 .62347 .50557 .61709 Mtetra
.597 .758 .955 r
.50557 .61709 .5125 .62347 .52515 .6213 .51825 .61458 Mtetra
.896 .784 .73 r
.51825 .61458 .52515 .6213 .53774 .58405 .53097 .59212 Mtetra
.973 .907 .564 r
.53097 .59212 .53774 .58405 .54904 .40113 .54354 .55718 Mtetra
.532 .301 .51 r
.54354 .55718 .54904 .40113 .56107 .39718 .55619 .54977 Mtetra
.539 .307 .511 r
.55619 .54977 .56107 .39718 .57315 .3932 .56891 .54593 Mtetra
.547 .313 .512 r
.56891 .54593 .57315 .3932 .58529 .38921 .58176 .54568 Mtetra
.6 .356 .519 r
.58176 .54568 .58529 .38921 .60155 .56514 .59527 .57313 Mtetra
.738 .315 .244 r
.59527 .57313 .60155 .56514 .61539 .59511 .60877 .58817 Mtetra
.685 .777 .921 r
.60877 .58817 .61539 .59511 .62848 .58978 .62191 .58311 Mtetra
.924 .791 .696 r
.62191 .58311 .62848 .58978 .63994 .53558 .63438 .55562 Mtetra
0 0 0 r
.63438 .55562 .63994 .53558 .64678 .36899 .64659 .52441 Mtetra
.536 .304 .511 r
.64659 .52441 .64678 .36899 .65924 .3649 .65967 .51858 Mtetra
.539 .307 .511 r
.65967 .51858 .65924 .3649 .67175 .36078 .67287 .51461 Mtetra
.553 .317 .512 r
.67287 .51461 .67175 .36078 .68433 .35664 .68645 .51699 Mtetra
.601 .356 .517 r
.68645 .51699 .68433 .35664 .70744 .54606 .7016 .54704 Mtetra
.652 .102 0 r
.7016 .54704 .70744 .54606 .72227 .56506 .71599 .55768 Mtetra
.748 .792 .889 r
.71599 .55768 .72227 .56506 .73561 .55631 .72945 .54992 Mtetra
.95 .802 .661 r
.72945 .54992 .73561 .55631 .74426 .47655 .74135 .51752 Mtetra
.262 .034 .367 r
.74135 .51752 .74426 .47655 .74803 .33569 .7535 .49122 Mtetra
.538 .306 .511 r
.7535 .49122 .74803 .33569 .76095 .33145 .7671 .48627 Mtetra
.54 .307 .511 r
.7671 .48627 .76095 .33145 .77392 .32718 .78083 .48228 Mtetra
.56 .322 .512 r
.78083 .48228 .77392 .32718 .78859 .34259 .79547 .48869 Mtetra
.606 .356 .512 r
.79547 .48869 .78859 .34259 .81793 .52278 .8124 .51981 Mtetra
.356 0 0 r
.8124 .51981 .81793 .52278 .83358 .53602 .82767 .52837 Mtetra
.556 .721 .95 r
.82767 .52837 .83358 .53602 .84802 .53452 .84216 .52676 Mtetra
.624 .749 .937 r
.84216 .52676 .84802 .53452 .86236 .53101 .85655 .52328 Mtetra
.638 .757 .935 r
.85655 .52328 .86236 .53101 .87674 .52707 .87098 .51935 Mtetra
.643 .761 .934 r
.87098 .51935 .87674 .52707 .89117 .523 .88547 .51525 Mtetra
.644 .762 .934 r
.88547 .51525 .89117 .523 .90567 .51885 .90002 .51107 Mtetra
.648 .763 .933 r
.25526 .68989 .26295 .69613 .27457 .69271 .26691 .68644 Mtetra
.65 .763 .932 r
.26691 .68644 .27457 .69271 .28625 .68923 .27862 .68292 Mtetra
.656 .765 .929 r
.27862 .68292 .28625 .68923 .29799 .68558 .29039 .6792 Mtetra
.673 .767 .921 r
.29039 .6792 .29799 .68558 .3098 .68151 .30224 .67499 Mtetra
.708 .771 .901 r
.30224 .67499 .3098 .68151 .32176 .67566 .31421 .66956 Mtetra
.745 .789 .888 r
.31421 .66956 .32176 .67566 .33429 .66008 .32631 .66267 Mtetra
.388 .841 .756 r
.32631 .66267 .33429 .66008 .34791 .62279 .33835 .65732 Mtetra
.485 .194 .396 r
.33835 .65732 .34791 .62279 .36022 .60908 .35035 .65358 Mtetra
.503 .228 .43 r
.35035 .65358 .36022 .60908 .37207 .60537 .3624 .64999 Mtetra
.502 .227 .43 r
.3624 .64999 .37207 .60537 .38392 .60258 .3745 .64633 Mtetra
.504 .228 .428 r
.3745 .64633 .38392 .60258 .39506 .62051 .38665 .64296 Mtetra
.483 .152 .329 r
.38665 .64296 .39506 .62051 .4062 .64443 .39879 .64123 Mtetra
.547 .846 .998 r
.39879 .64123 .4062 .64443 .41831 .64451 .41104 .63846 Mtetra
.71 .794 .917 r
.41104 .63846 .41831 .64451 .43099 .62668 .42343 .63283 Mtetra
.057 0 0 r
.42343 .63283 .43099 .62668 .44408 .5898 .43583 .62826 Mtetra
.495 .211 .411 r
.43583 .62826 .44408 .5898 .45644 .57986 .44826 .62466 Mtetra
.503 .228 .43 r
.44826 .62466 .45644 .57986 .46871 .57615 .46075 .62101 Mtetra
.502 .228 .43 r
.46075 .62101 .46871 .57615 .48102 .57427 .47331 .61725 Mtetra
.505 .227 .426 r
.47331 .61725 .48102 .57427 .49315 .59747 .48591 .61395 Mtetra
.456 .089 .253 r
.48591 .61395 .49315 .59747 .50557 .61709 .49856 .61229 Mtetra
.616 .82 .979 r
.49856 .61229 .50557 .61709 .51825 .61458 .51129 .60884 Mtetra
.713 .814 .928 r
.51129 .60884 .51825 .61458 .53097 .59212 .52409 .60297 Mtetra
.289 0 .055 r
.52409 .60297 .53097 .59212 .54354 .55718 .53693 .59855 Mtetra
.499 .219 .42 r
.53693 .59855 .54354 .55718 .55619 .54977 .54983 .59484 Mtetra
.503 .228 .43 r
.54983 .59484 .55619 .54977 .56891 .54593 .5628 .59103 Mtetra
.5628 .59103 .56891 .54593 .58176 .54568 .57582 .58712 Mtetra
.504 .224 .422 r
.57582 .58712 .58176 .54568 .59527 .57313 .58892 .58393 Mtetra
.396 0 .11 r
.58892 .58393 .59527 .57313 .60877 .58817 .60212 .5822 Mtetra
.651 .8 .954 r
.60212 .5822 .60877 .58817 .62191 .58311 .61533 .57804 Mtetra
.709 .846 .948 r
.61533 .57804 .62191 .58311 .63438 .55562 .62855 .57206 Mtetra
.393 .03 .224 r
.62855 .57206 .63438 .55562 .64659 .52441 .64188 .56773 Mtetra
.502 .224 .425 r
.64188 .56773 .64659 .52441 .65967 .51858 .65528 .56387 Mtetra
.503 .228 .43 r
.65528 .56387 .65967 .51858 .67287 .51461 .66875 .5599 Mtetra
.66875 .5599 .67287 .51461 .68645 .51699 .68227 .55587 Mtetra
.503 .217 .413 r
.68227 .55587 .68645 .51699 .7016 .54704 .69591 .55283 Mtetra
.256 0 0 r
.69591 .55283 .7016 .54704 .71599 .55768 .70969 .55089 Mtetra
.672 .789 .937 r
.70969 .55089 .71599 .55768 .72945 .54992 .72338 .54601 Mtetra
.687 .891 .972 r
.72338 .54601 .72945 .54992 .74135 .51752 .73706 .54004 Mtetra
.444 .116 .313 r
.73706 .54004 .74135 .51752 .7535 .49122 .7509 .53576 Mtetra
.503 .227 .428 r
.7509 .53576 .7535 .49122 .7671 .48627 .76484 .53178 Mtetra
.504 .229 .43 r
.76484 .53178 .7671 .48627 .78083 .48228 .77884 .52773 Mtetra
.505 .229 .43 r
.77884 .52773 .78083 .48228 .79547 .48869 .79292 .52382 Mtetra
.506 .211 .4 r
.79292 .52382 .79547 .48869 .8124 .51981 .80722 .5216 Mtetra
.109 0 0 r
.80722 .5216 .8124 .51981 .82767 .52837 .82174 .52101 Mtetra
.57 .738 .955 r
.82174 .52101 .82767 .52837 .84216 .52676 .83623 .51888 Mtetra
.621 .746 .936 r
.83623 .51888 .84216 .52676 .85655 .52328 .85069 .51548 Mtetra
.637 .757 .935 r
.85069 .51548 .85655 .52328 .87098 .51935 .86517 .51156 Mtetra
.642 .761 .934 r
.86517 .51156 .87098 .51935 .88547 .51525 .87971 .50743 Mtetra
.644 .762 .934 r
.87971 .50743 .88547 .51525 .90002 .51107 .89432 .50321 Mtetra
.648 .763 .933 r
.2475 .6836 .25526 .68989 .26691 .68644 .25918 .68012 Mtetra
.65 .763 .932 r
.25918 .68012 .26691 .68644 .27862 .68292 .27092 .67657 Mtetra
.656 .765 .93 r
.27092 .67657 .27862 .68292 .29039 .6792 .28273 .67282 Mtetra
.673 .769 .922 r
.28273 .67282 .29039 .6792 .30224 .67499 .29461 .66856 Mtetra
.706 .775 .905 r
.29461 .66856 .30224 .67499 .31421 .66956 .30662 .66318 Mtetra
.727 .78 .895 r
.30662 .66318 .31421 .66956 .32631 .66267 .31871 .65697 Mtetra
.687 .795 .932 r
.31871 .65697 .32631 .66267 .33835 .65732 .33076 .65223 Mtetra
.643 .807 .961 r
.33076 .65223 .33835 .65732 .35035 .65358 .34279 .64854 Mtetra
.639 .808 .964 r
.34279 .64854 .35035 .65358 .3624 .64999 .35488 .64492 Mtetra
.642 .809 .963 r
.35488 .64492 .3624 .64999 .3745 .64633 .36702 .64122 Mtetra
.637 .807 .965 r
.36702 .64122 .3745 .64633 .38665 .64296 .37922 .63762 Mtetra
.593 .788 .973 r
.37922 .63762 .38665 .64296 .39879 .64123 .39143 .63499 Mtetra
.624 .768 .949 r
.39143 .63499 .39879 .64123 .41104 .63846 .40372 .63188 Mtetra
.686 .775 .919 r
.40372 .63188 .41104 .63846 .42343 .63283 .41612 .62703 Mtetra
.657 .793 .948 r
.41612 .62703 .42343 .63283 .43583 .62826 .42855 .62297 Mtetra
.633 .805 .965 r
.42855 .62297 .43583 .62826 .44826 .62466 .44102 .6194 Mtetra
.636 .807 .965 r
.44102 .6194 .44826 .62466 .46075 .62101 .45356 .61572 Mtetra
.641 .809 .964 r
.45356 .61572 .46075 .62101 .47331 .61725 .46615 .6119 Mtetra
.632 .806 .966 r
.46615 .6119 .47331 .61725 .48591 .61395 .4788 .60827 Mtetra
.589 .781 .972 r
.4788 .60827 .48591 .61395 .49856 .61229 .4915 .60567 Mtetra
.639 .768 .941 r
.4915 .60567 .49856 .61229 .51129 .60884 .50427 .60208 Mtetra
.686 .779 .922 r
.50427 .60208 .51129 .60884 .52409 .60297 .51711 .59708 Mtetra
.65 .797 .953 r
.51711 .59708 .52409 .60297 .53693 .59855 .53 .59304 Mtetra
.632 .805 .966 r
.53 .59304 .53693 .59855 .54983 .59484 .54295 .58933 Mtetra
.637 .807 .965 r
.54295 .58933 .54983 .59484 .5628 .59103 .55596 .58549 Mtetra
.641 .809 .964 r
.55596 .58549 .5628 .59103 .57582 .58712 .56903 .58152 Mtetra
.627 .804 .967 r
.56903 .58152 .57582 .58712 .58892 .58393 .58216 .57788 Mtetra
.589 .776 .969 r
.58216 .57788 .58892 .58393 .60212 .5822 .59539 .57522 Mtetra
.652 .769 .935 r
.59539 .57522 .60212 .5822 .61533 .57804 .60865 .57112 Mtetra
.683 .782 .926 r
.60865 .57112 .61533 .57804 .62855 .57206 .62194 .56603 Mtetra
.644 .799 .957 r
.62194 .56603 .62855 .57206 .64188 .56773 .63532 .56198 Mtetra
.633 .806 .966 r
.63532 .56198 .64188 .56773 .65528 .56387 .64878 .5581 Mtetra
.637 .808 .965 r
.64878 .5581 .65528 .56387 .66875 .5599 .66229 .5541 Mtetra
.641 .809 .964 r
.66229 .5541 .66875 .5599 .68227 .55587 .67587 .54998 Mtetra
.621 .8 .968 r
.67587 .54998 .68227 .55587 .69591 .55283 .68953 .54636 Mtetra
.593 .771 .965 r
.68953 .54636 .69591 .55283 .70969 .55089 .70331 .54355 Mtetra
.663 .771 .93 r
.70331 .54355 .70969 .55089 .72338 .54601 .71706 .53894 Mtetra
.678 .786 .931 r
.71706 .53894 .72338 .54601 .73706 .54004 .73085 .53384 Mtetra
.638 .801 .961 r
.73085 .53384 .73706 .54004 .7509 .53576 .74476 .52975 Mtetra
.632 .805 .966 r
.74476 .52975 .7509 .53576 .76484 .53178 .75875 .52574 Mtetra
.634 .807 .966 r
.75875 .52574 .76484 .53178 .77884 .52773 .77281 .52165 Mtetra
.631 .805 .966 r
.77281 .52165 .77884 .52773 .79292 .52382 .78694 .51763 Mtetra
.587 .785 .974 r
.78694 .51763 .79292 .52382 .80722 .5216 .80123 .5147 Mtetra
.53 .736 .969 r
.80123 .5147 .80722 .5216 .82174 .52101 .81574 .51333 Mtetra
.576 .734 .95 r
.81574 .51333 .82174 .52101 .83623 .51888 .83027 .51109 Mtetra
.619 .75 .94 r
.83027 .51109 .83623 .51888 .85069 .51548 .84478 .50767 Mtetra
.636 .758 .936 r
.84478 .50767 .85069 .51548 .86517 .51156 .85931 .50371 Mtetra
.642 .761 .935 r
.85931 .50371 .86517 .51156 .87971 .50743 .8739 .49954 Mtetra
.644 .762 .934 r
.8739 .49954 .87971 .50743 .89432 .50321 .88856 .49528 Mtetra
.648 .763 .933 r
.23968 .67725 .2475 .6836 .25918 .68012 .25139 .67375 Mtetra
.65 .763 .932 r
.25139 .67375 .25918 .68012 .27092 .67657 .26316 .67017 Mtetra
.655 .765 .93 r
.26316 .67017 .27092 .67657 .28273 .67282 .275 .66643 Mtetra
.67 .769 .925 r
.275 .66643 .28273 .67282 .29461 .66856 .28691 .66226 Mtetra
.72 .782 .901 r
.28691 .66226 .29461 .66856 .30662 .66318 .29898 .65635 Mtetra
.835 .771 .791 r
.29898 .65635 .30662 .66318 .31871 .65697 .3116 .64213 Mtetra
.83 .671 .687 r
.3116 .64213 .31871 .65697 .33076 .65223 .32487 .61648 Mtetra
.638 .482 .655 r
.32487 .61648 .33076 .65223 .34279 .64854 .33712 .60777 Mtetra
.591 .439 .644 r
.33712 .60777 .34279 .64854 .35488 .64492 .34912 .60403 Mtetra
.588 .437 .644 r
.34912 .60403 .35488 .64492 .36702 .64122 .36116 .6007 Mtetra
.472 .356 .64 r
.36116 .6007 .36702 .64122 .37922 .63762 .37276 .60852 Mtetra
.231 .228 .65 r
.37276 .60852 .37922 .63762 .39143 .63499 .38415 .62487 Mtetra
.542 .632 .89 r
.38415 .62487 .39143 .63499 .40372 .63188 .39636 .62448 Mtetra
.845 .771 .78 r
.39636 .62448 .40372 .63188 .41612 .62703 .40916 .60894 Mtetra
.808 .647 .682 r
.40916 .60894 .41612 .62703 .42855 .62297 .4222 .58476 Mtetra
.618 .464 .651 r
.4222 .58476 .42855 .62297 .44102 .6194 .43467 .57802 Mtetra
.59 .439 .644 r
.43467 .57802 .44102 .6194 .45356 .61572 .44712 .57425 Mtetra
.584 .434 .644 r
.44712 .57425 .45356 .61572 .46615 .6119 .45961 .57129 Mtetra
.433 .331 .639 r
.45961 .57129 .46615 .6119 .4788 .60827 .47194 .58253 Mtetra
.266 .276 .684 r
.47194 .58253 .4788 .60827 .4915 .60567 .4844 .59658 Mtetra
.616 .693 .899 r
.4844 .59658 .4915 .60567 .50427 .60208 .4972 .59386 Mtetra
.864 .767 .753 r
.4972 .59386 .50427 .60208 .51711 .59708 .51013 .57503 Mtetra
.778 .614 .677 r
.51013 .57503 .51711 .59708 .53 .59304 .52301 .55291 Mtetra
.605 .452 .648 r
.52301 .55291 .53 .59304 .54295 .58933 .53587 .54734 Mtetra
.59 .439 .644 r
.53587 .54734 .54295 .58933 .55596 .58549 .54879 .54343 Mtetra
.577 .43 .644 r
.54879 .54343 .55596 .58549 .56903 .58152 .56178 .54117 Mtetra
.398 .311 .64 r
.56178 .54117 .56903 .58152 .58216 .57788 .5751 .55557 Mtetra
.314 .336 .724 r
.5751 .55557 .58216 .57788 .59539 .57522 .58857 .56675 Mtetra
.68 .739 .895 r
.58857 .56675 .59539 .57522 .60865 .57112 .60184 .56171 Mtetra
.878 .759 .727 r
.60184 .56171 .60865 .57112 .62194 .56603 .61472 .53966 Mtetra
.741 .577 .671 r
.61472 .53966 .62194 .56603 .63532 .56198 .6276 .5204 Mtetra
.598 .445 .646 r
.6276 .5204 .63532 .56198 .64878 .5581 .64093 .51551 Mtetra
.59 .439 .644 r
.64093 .51551 .64878 .5581 .66229 .5541 .65434 .51144 Mtetra
.566 .423 .645 r
.65434 .51144 .66229 .5541 .67587 .54998 .66795 .51041 Mtetra
.371 .298 .643 r
.66795 .51041 .67587 .54998 .68953 .54636 .68249 .52726 Mtetra
.369 .403 .766 r
.68249 .52726 .68953 .54636 .70331 .54355 .69683 .53536 Mtetra
.735 .773 .883 r
.69683 .53536 .70331 .54355 .71706 .53894 .71047 .52788 Mtetra
.885 .748 .706 r
.71047 .52788 .71706 .53894 .73085 .53384 .72312 .5031 Mtetra
.702 .54 .665 r
.72312 .5031 .73085 .53384 .74476 .52975 .73622 .48705 Mtetra
.593 .441 .645 r
.73622 .48705 .74476 .52975 .75875 .52574 .75007 .48251 Mtetra
.59 .438 .644 r
.75007 .48251 .75875 .52574 .77281 .52165 .76402 .47839 Mtetra
.55 .412 .646 r
.76402 .47839 .77281 .52165 .78694 .51763 .77844 .47945 Mtetra
.35 .291 .65 r
.77844 .47945 .78694 .51763 .80123 .5147 .79441 .49823 Mtetra
.377 .442 .801 r
.79441 .49823 .80123 .5147 .81574 .51333 .80965 .50516 Mtetra
.561 .714 .943 r
.80965 .50516 .81574 .51333 .83027 .51109 .82427 .50341 Mtetra
.622 .757 .943 r
.82427 .50341 .83027 .51109 .84478 .50767 .83882 .49983 Mtetra
.637 .76 .937 r
.83882 .49983 .84478 .50767 .85931 .50371 .8534 .49579 Mtetra
.642 .761 .935 r
.8534 .49579 .85931 .50371 .8739 .49954 .86804 .49158 Mtetra
.644 .762 .934 r
.86804 .49158 .8739 .49954 .88856 .49528 .88275 .48728 Mtetra
.647 .763 .933 r
.23179 .67085 .23968 .67725 .25139 .67375 .24354 .66732 Mtetra
.649 .763 .932 r
.24354 .66732 .25139 .67375 .26316 .67017 .25534 .66373 Mtetra
.653 .765 .931 r
.25534 .66373 .26316 .67017 .275 .66643 .2672 .66001 Mtetra
.667 .769 .926 r
.2672 .66001 .275 .66643 .28691 .66226 .27914 .65587 Mtetra
.723 .781 .899 r
.27914 .65587 .28691 .66226 .29898 .65635 .29126 .6498 Mtetra
.872 .768 .745 r
.29126 .6498 .29898 .65635 .3116 .64213 .30432 .62968 Mtetra
.93 .693 .558 r
.30432 .62968 .3116 .64213 .32487 .61648 .32602 .46556 Mtetra
.642 .425 .573 r
.32602 .46556 .32487 .61648 .33712 .60777 .33971 .42363 Mtetra
.558 .353 .56 r
.33971 .42363 .33712 .60777 .34912 .60403 .35114 .41977 Mtetra
.35114 .41977 .34912 .60403 .36116 .6007 .36262 .41589 Mtetra
.063 0 .427 r
.36262 .41589 .36116 .6007 .37276 .60852 .36773 .54974 Mtetra
0 0 .307 r
.36773 .54974 .37276 .60852 .38415 .62487 .37674 .6167 Mtetra
.446 .641 .94 r
.37674 .6167 .38415 .62487 .39636 .62448 .38892 .61767 Mtetra
.898 .768 .709 r
.38892 .61767 .39636 .62448 .40916 .60894 .40216 .59175 Mtetra
.938 .689 .536 r
.40216 .59175 .40916 .60894 .4222 .58476 .42077 .39626 Mtetra
.557 .353 .559 r
.42077 .39626 .4222 .58476 .43467 .57802 .43256 .39228 Mtetra
.558 .354 .56 r
.43256 .39228 .43467 .57802 .44712 .57425 .44439 .38829 Mtetra
.44439 .38829 .44712 .57425 .45961 .57129 .45628 .38428 Mtetra
0 0 .41 r
.45628 .38428 .45961 .57129 .47194 .58253 .46532 .54417 Mtetra
.46532 .54417 .47194 .58253 .4844 .59658 .47724 .58889 Mtetra
.594 .724 .935 r
.47724 .58889 .4844 .59658 .4972 .59386 .49006 .58657 Mtetra
.927 .761 .655 r
.49006 .58657 .4972 .59386 .51013 .57503 .50318 .54961 Mtetra
.936 .68 .525 r
.50318 .54961 .51013 .57503 .52301 .55291 .5165 .36395 Mtetra
.558 .353 .56 r
.5165 .36395 .52301 .55291 .53587 .54734 .52871 .35983 Mtetra
.558 .354 .56 r
.52871 .35983 .53587 .54734 .54879 .54343 .54097 .35569 Mtetra
.54097 .35569 .54879 .54343 .56178 .54117 .55328 .35153 Mtetra
0 0 .417 r
.55328 .35153 .56178 .54117 .5751 .55557 .568 .52988 Mtetra
0 0 .54 r
.568 .52988 .5751 .55557 .58857 .56675 .58171 .55921 Mtetra
.693 .77 .91 r
.58171 .55921 .58857 .56675 .60184 .56171 .59502 .55371 Mtetra
.951 .751 .596 r
.59502 .55371 .60184 .56171 .61472 .53966 .6072 .50053 Mtetra
.923 .659 .52 r
.6072 .50053 .61472 .53966 .6276 .5204 .61569 .33046 Mtetra
.558 .353 .56 r
.61569 .33046 .6276 .5204 .64093 .51551 .62834 .32619 Mtetra
.62834 .32619 .64093 .51551 .65434 .51144 .64105 .3219 Mtetra
.64105 .3219 .65434 .51144 .66795 .51041 .65381 .31759 Mtetra
.001 0 .437 r
.65381 .31759 .66795 .51041 .68249 .52726 .67549 .5091 Mtetra
0 .16 .681 r
.67549 .5091 .68249 .52726 .69683 .53536 .69033 .52776 Mtetra
.768 .798 .877 r
.69033 .52776 .69683 .53536 .71047 .52788 .70394 .51882 Mtetra
.97 .737 .532 r
.70394 .51882 .71047 .52788 .72312 .5031 .71365 .44178 Mtetra
.885 .617 .528 r
.71365 .44178 .72312 .5031 .73622 .48705 .71852 .29575 Mtetra
.558 .353 .56 r
.71852 .29575 .73622 .48705 .75007 .48251 .73164 .29132 Mtetra
.73164 .29132 .75007 .48251 .76402 .47839 .74482 .28687 Mtetra
.479 .297 .555 r
.74482 .28687 .76402 .47839 .77844 .47945 .76104 .32195 Mtetra
.035 0 .468 r
.76104 .32195 .77844 .47945 .79441 .49823 .78778 .48425 Mtetra
.094 .298 .777 r
.78778 .48425 .79441 .49823 .80965 .50516 .80353 .49728 Mtetra
.552 .72 .952 r
.80353 .49728 .80965 .50516 .82427 .50341 .81821 .49563 Mtetra
.625 .758 .942 r
.81821 .49563 .82427 .50341 .83882 .49983 .8328 .49194 Mtetra
.639 .761 .937 r
.8328 .49194 .83882 .49983 .8534 .49579 .84743 .48781 Mtetra
.643 .762 .935 r
.84743 .48781 .8534 .49579 .86804 .49158 .86213 .48354 Mtetra
.644 .762 .934 r
.86213 .48354 .86804 .49158 .88275 .48728 .87689 .4792 Mtetra
.647 .763 .933 r
.22384 .6644 .23179 .67085 .24354 .66732 .23562 .66084 Mtetra
.649 .763 .933 r
.23562 .66084 .24354 .66732 .25534 .66373 .24745 .65723 Mtetra
.653 .764 .931 r
.24745 .65723 .25534 .66373 .2672 .66001 .25934 .6535 Mtetra
.666 .768 .926 r
.25934 .6535 .2672 .66001 .27914 .65587 .27131 .64936 Mtetra
.723 .779 .897 r
.27131 .64936 .27914 .65587 .29126 .6498 .28347 .64325 Mtetra
.874 .769 .742 r
.28347 .64325 .29126 .6498 .30432 .62968 .29663 .62264 Mtetra
.94 .699 .547 r
.29663 .62264 .30432 .62968 .32602 .46556 .32114 .42036 Mtetra
.586 .424 .629 r
.32114 .42036 .32602 .46556 .33971 .42363 .33255 .41649 Mtetra
.664 .741 .907 r
.33255 .41649 .33971 .42363 .35114 .41977 .34401 .4126 Mtetra
.34401 .4126 .35114 .41977 .36262 .41589 .35552 .40869 Mtetra
.953 .659 .44 r
.35552 .40869 .36262 .41589 .36773 .54974 .36072 .53498 Mtetra
.968 .649 .337 r
.36072 .53498 .36773 .54974 .37674 .6167 .36922 .60989 Mtetra
.397 .663 .966 r
.36922 .60989 .37674 .6167 .38892 .61767 .38141 .61093 Mtetra
.902 .768 .705 r
.38141 .61093 .38892 .61767 .40216 .59175 .39477 .58406 Mtetra
.95 .703 .529 r
.39477 .58406 .40216 .59175 .42077 .39626 .41384 .38891 Mtetra
.664 .741 .907 r
.41384 .38891 .42077 .39626 .43256 .39228 .42565 .3849 Mtetra
.42565 .3849 .43256 .39228 .44439 .38829 .43752 .38087 Mtetra
.43752 .38087 .44439 .38829 .45628 .38428 .44944 .37682 Mtetra
.961 .661 .418 r
.44944 .37682 .45628 .38428 .46532 .54417 .45822 .53339 Mtetra
.94 .574 .201 r
.45822 .53339 .46532 .54417 .47724 .58889 .47 .58187 Mtetra
.586 .743 .951 r
.47 .58187 .47724 .58889 .49006 .58657 .48286 .57954 Mtetra
.932 .762 .648 r
.48286 .57954 .49006 .58657 .50318 .54961 .4961 .54071 Mtetra
.959 .705 .509 r
.4961 .54071 .50318 .54961 .5165 .36395 .50983 .35633 Mtetra
.664 .741 .907 r
.50983 .35633 .5165 .36395 .52871 .35983 .52207 .35217 Mtetra
.52207 .35217 .52871 .35983 .54097 .35569 .53437 .348 Mtetra
.53437 .348 .54097 .35569 .55328 .35153 .54672 .34381 Mtetra
.967 .658 .383 r
.54672 .34381 .55328 .35153 .568 .52988 .56109 .52079 Mtetra
.843 .418 0 r
.56109 .52079 .568 .52988 .58171 .55921 .57479 .55195 Mtetra
.694 .78 .917 r
.57479 .55195 .58171 .55921 .59502 .55371 .58815 .54638 Mtetra
.957 .752 .586 r
.58815 .54638 .59502 .55371 .6072 .50053 .60039 .48932 Mtetra
.965 .706 .49 r
.60039 .48932 .6072 .50053 .61569 .33046 .60931 .32256 Mtetra
.664 .741 .907 r
.60931 .32256 .61569 .33046 .62834 .32619 .622 .31826 Mtetra
.622 .31826 .62834 .32619 .64105 .3219 .63475 .31393 Mtetra
.63475 .31393 .64105 .3219 .65381 .31759 .64756 .30959 Mtetra
.969 .65 .337 r
.64756 .30959 .65381 .31759 .67549 .5091 .66889 .50066 Mtetra
.576 .118 0 r
.66889 .50066 .67549 .5091 .69033 .52776 .68377 .52023 Mtetra
.771 .802 .878 r
.68377 .52023 .69033 .52776 .70394 .51882 .69744 .51114 Mtetra
.976 .739 .515 r
.69744 .51114 .70394 .51882 .71365 .44178 .70687 .42586 Mtetra
.965 .701 .482 r
.70687 .42586 .71365 .44178 .71852 .29575 .71247 .28756 Mtetra
.664 .741 .907 r
.71247 .28756 .71852 .29575 .73164 .29132 .72563 .28309 Mtetra
.72563 .28309 .73164 .29132 .74482 .28687 .73886 .2786 Mtetra
.73886 .2786 .74482 .28687 .76104 .32195 .75214 .27409 Mtetra
.876 .593 .071 r
.75214 .27409 .76104 .32195 .78778 .48425 .78155 .47591 Mtetra
0 .177 .699 r
.78155 .47591 .78778 .48425 .80353 .49728 .79736 .48939 Mtetra
.551 .722 .953 r
.79736 .48939 .80353 .49728 .81821 .49563 .81209 .4877 Mtetra
.626 .756 .94 r
.81209 .4877 .81821 .49563 .8328 .49194 .82673 .48394 Mtetra
.64 .761 .936 r
.82673 .48394 .8328 .49194 .84743 .48781 .84141 .47975 Mtetra
.643 .762 .935 r
.84141 .47975 .84743 .48781 .86213 .48354 .85616 .47543 Mtetra
.645 .762 .934 r
.85616 .47543 .86213 .48354 .87689 .4792 .87097 .47105 Mtetra
.647 .763 .933 r
.21582 .6579 .22384 .6644 .23562 .66084 .22763 .65431 Mtetra
.649 .763 .933 r
.22763 .65431 .23562 .66084 .24745 .65723 .23949 .65067 Mtetra
.653 .764 .931 r
.23949 .65067 .24745 .65723 .25934 .6535 .25142 .64691 Mtetra
.666 .767 .925 r
.25142 .64691 .25934 .6535 .27131 .64936 .26342 .64273 Mtetra
.722 .778 .896 r
.26342 .64273 .27131 .64936 .28347 .64325 .27562 .63659 Mtetra
.874 .768 .742 r
.27562 .63659 .28347 .64325 .29663 .62264 .28886 .61591 Mtetra
.94 .7 .547 r
.28886 .61591 .29663 .62264 .32114 .42036 .3139 .4132 Mtetra
.664 .741 .907 r
.3139 .4132 .32114 .42036 .33255 .41649 .32534 .4093 Mtetra
.32534 .4093 .33255 .41649 .34401 .4126 .33683 .40538 Mtetra
.33683 .40538 .34401 .4126 .35552 .40869 .34837 .40144 Mtetra
.953 .659 .44 r
.34837 .40144 .35552 .40869 .36072 .53498 .35328 .52794 Mtetra
.952 .632 .386 r
.35328 .52794 .36072 .53498 .36922 .60989 .36162 .60299 Mtetra
.398 .663 .966 r
.36162 .60299 .36922 .60989 .38141 .61093 .37385 .60401 Mtetra
.901 .767 .704 r
.37385 .60401 .38141 .61093 .39477 .58406 .38729 .57705 Mtetra
.951 .704 .529 r
.38729 .57705 .39477 .58406 .41384 .38891 .40684 .38149 Mtetra
.664 .741 .907 r
.40684 .38149 .41384 .38891 .42565 .3849 .41869 .37745 Mtetra
.41869 .37745 .42565 .3849 .43752 .38087 .43059 .37339 Mtetra
.43059 .37339 .43752 .38087 .44944 .37682 .44254 .36931 Mtetra
.961 .661 .418 r
.44254 .36931 .44944 .37682 .45822 .53339 .451 .52615 Mtetra
.94 .573 .254 r
.451 .52615 .45822 .53339 .47 .58187 .4627 .57472 Mtetra
.587 .741 .949 r
.4627 .57472 .47 .58187 .48286 .57954 .47559 .57236 Mtetra
.931 .761 .648 r
.47559 .57236 .48286 .57954 .4961 .54071 .48895 .53341 Mtetra
.961 .708 .507 r
.48895 .53341 .4961 .54071 .50983 .35633 .50311 .34864 Mtetra
.664 .741 .907 r
.50311 .34864 .50983 .35633 .52207 .35217 .51539 .34445 Mtetra
.51539 .34445 .52207 .35217 .53437 .348 .52772 .34025 Mtetra
.52772 .34025 .53437 .348 .54672 .34381 .5401 .33602 Mtetra
.967 .658 .383 r
.5401 .33602 .54672 .34381 .56109 .52079 .55414 .51331 Mtetra
.865 .435 .014 r
.55414 .51331 .56109 .52079 .57479 .55195 .56781 .54452 Mtetra
.694 .777 .915 r
.56781 .54452 .57479 .55195 .58815 .54638 .58122 .5389 Mtetra
.957 .752 .586 r
.58122 .5389 .58815 .54638 .60039 .48932 .5936 .4817 Mtetra
.971 .712 .484 r
.5936 .4817 .60039 .48932 .60931 .32256 .60289 .3146 Mtetra
.664 .741 .907 r
.60289 .3146 .60931 .32256 .622 .31826 .61561 .31026 Mtetra
.61561 .31026 .622 .31826 .63475 .31393 .6284 .30589 Mtetra
.6284 .30589 .63475 .31393 .64756 .30959 .64125 .30151 Mtetra
.969 .65 .337 r
.64125 .30151 .64756 .30959 .66889 .50066 .66226 .49292 Mtetra
.614 .141 0 r
.66226 .49292 .66889 .50066 .68377 .52023 .67715 .5125 Mtetra
.77 .799 .876 r
.67715 .5125 .68377 .52023 .69744 .51114 .69087 .50337 Mtetra
.975 .739 .515 r
.69087 .50337 .69744 .51114 .70687 .42586 .70049 .41787 Mtetra
.979 .717 .463 r
.70049 .41787 .70687 .42586 .71247 .28756 .70636 .27929 Mtetra
.664 .741 .907 r
.70636 .27929 .71247 .28756 .72563 .28309 .71957 .27479 Mtetra
.71957 .27479 .72563 .28309 .73886 .2786 .73284 .27026 Mtetra
.73284 .27026 .73886 .2786 .75214 .27409 .74616 .26571 Mtetra
.964 .635 .278 r
.74616 .26571 .75214 .27409 .78155 .47591 .77529 .46788 Mtetra
0 .165 .685 r
.77529 .46788 .78155 .47591 .79736 .48939 .79112 .48135 Mtetra
.552 .72 .952 r
.79112 .48135 .79736 .48939 .81209 .4877 .8059 .47963 Mtetra
.626 .754 .939 r
.8059 .47963 .81209 .4877 .82673 .48394 .8206 .47583 Mtetra
.64 .76 .935 r
.8206 .47583 .82673 .48394 .84141 .47975 .83533 .47161 Mtetra
.643 .761 .934 r
.83533 .47161 .84141 .47975 .85616 .47543 .85013 .46724 Mtetra
.645 .762 .934 r
.85013 .46724 .85616 .47543 .87097 .47105 .865 .46282 Mtetra
.647 .763 .933 r
.20774 .65134 .21582 .6579 .22763 .65431 .21957 .64772 Mtetra
.649 .763 .932 r
.21957 .64772 .22763 .65431 .23949 .65067 .23147 .64404 Mtetra
.653 .764 .93 r
.23147 .64404 .23949 .65067 .25142 .64691 .24343 .64022 Mtetra
.667 .766 .924 r
.24343 .64022 .25142 .64691 .26342 .64273 .25547 .63599 Mtetra
.722 .776 .895 r
.25547 .63599 .26342 .64273 .27562 .63659 .26771 .62981 Mtetra
.872 .767 .744 r
.26771 .62981 .27562 .63659 .28886 .61591 .28099 .60948 Mtetra
.94 .704 .554 r
.28099 .60948 .28886 .61591 .3139 .4132 .30401 .44427 Mtetra
0 0 0 r
.30401 .44427 .3139 .4132 .32534 .4093 .31807 .40204 Mtetra
.664 .741 .907 r
.31807 .40204 .32534 .4093 .33683 .40538 .32959 .39809 Mtetra
.32959 .39809 .33683 .40538 .34837 .40144 .34116 .39412 Mtetra
.953 .661 .444 r
.34116 .39412 .34837 .40144 .35328 .52794 .34536 .52867 Mtetra
.925 .601 .41 r
.34536 .52867 .35328 .52794 .36162 .60299 .35397 .596 Mtetra
.405 .665 .966 r
.35397 .596 .36162 .60299 .37385 .60401 .36622 .59691 Mtetra
.897 .766 .709 r
.36622 .59691 .37385 .60401 .38729 .57705 .37972 .57074 Mtetra
.952 .705 .528 r
.37972 .57074 .38729 .57705 .40684 .38149 .39979 .37401 Mtetra
.664 .741 .907 r
.39979 .37401 .40684 .38149 .41869 .37745 .41167 .36994 Mtetra
.41167 .36994 .41869 .37745 .43059 .37339 .4236 .36584 Mtetra
.4236 .36584 .43059 .37339 .44254 .36931 .43559 .36173 Mtetra
.961 .662 .419 r
.43559 .36173 .44254 .36931 .451 .52615 .44363 .52247 Mtetra
.928 .555 .28 r
.44363 .52247 .451 .52615 .4627 .57472 .45533 .56742 Mtetra
.589 .74 .947 r
.45533 .56742 .4627 .57472 .47559 .57236 .46827 .565 Mtetra
.928 .762 .655 r
.46827 .565 .47559 .57236 .48895 .53341 .48172 .52772 Mtetra
.963 .71 .505 r
.48172 .52772 .48895 .53341 .50311 .34864 .49633 .34089 Mtetra
.664 .741 .907 r
.49633 .34089 .50311 .34864 .51539 .34445 .50864 .33667 Mtetra
.50864 .33667 .51539 .34445 .52772 .34025 .52101 .33243 Mtetra
.52101 .33243 .52772 .34025 .5401 .33602 .53343 .32817 Mtetra
.967 .659 .384 r
.53343 .32817 .5401 .33602 .55414 .51331 .54714 .50746 Mtetra
.868 .428 .039 r
.54714 .50746 .55414 .51331 .56781 .54452 .56077 .53691 Mtetra
.693 .773 .913 r
.56077 .53691 .56781 .54452 .58122 .5389 .57422 .53129 Mtetra
.954 .755 .595 r
.57422 .53129 .58122 .5389 .5936 .4817 .58682 .47768 Mtetra
.975 .717 .477 r
.58682 .47768 .5936 .4817 .60289 .3146 .5964 .30657 Mtetra
.664 .741 .907 r
.5964 .30657 .60289 .3146 .61561 .31026 .60917 .30219 Mtetra
.60917 .30219 .61561 .31026 .6284 .30589 .622 .29779 Mtetra
.622 .29779 .6284 .30589 .64125 .30151 .63488 .29337 Mtetra
.969 .65 .337 r
.63488 .29337 .64125 .30151 .66226 .49292 .65561 .48589 Mtetra
.623 .135 0 r
.65561 .48589 .66226 .49292 .67715 .5125 .67046 .50458 Mtetra
.768 .795 .876 r
.67046 .50458 .67715 .5125 .69087 .50337 .68424 .49549 Mtetra
.974 .744 .527 r
.68424 .49549 .69087 .50337 .70049 .41787 .69447 .41787 Mtetra
.988 .73 .437 r
.69447 .41787 .70049 .41787 .70636 .27929 .70021 .27096 Mtetra
.664 .741 .907 r
.70021 .27096 .70636 .27929 .71957 .27479 .71345 .26641 Mtetra
.71345 .26641 .71957 .27479 .73284 .27026 .72676 .26185 Mtetra
.805 .382 0 r
.72676 .26185 .73284 .27026 .74616 .26571 .74291 .29701 Mtetra
.92 .586 .393 r
.74291 .29701 .74616 .26571 .77529 .46788 .769 .46016 Mtetra
0 .173 .686 r
.769 .46016 .77529 .46788 .79112 .48135 .78483 .47318 Mtetra
.553 .719 .95 r
.78483 .47318 .79112 .48135 .8059 .47963 .79965 .47142 Mtetra
.626 .752 .938 r
.79965 .47142 .8059 .47963 .8206 .47583 .8144 .46762 Mtetra
.639 .759 .935 r
.8144 .46762 .8206 .47583 .83533 .47161 .82919 .46337 Mtetra
.643 .761 .934 r
.82919 .46337 .83533 .47161 .85013 .46724 .84405 .45897 Mtetra
.644 .762 .934 r
.84405 .45897 .85013 .46724 .865 .46282 .85897 .45451 Mtetra
.648 .763 .933 r
.19958 .64472 .20774 .65134 .21957 .64772 .21145 .64107 Mtetra
.65 .763 .932 r
.21145 .64107 .21957 .64772 .23147 .64404 .22338 .63734 Mtetra
.655 .764 .93 r
.22338 .63734 .23147 .64404 .24343 .64022 .23537 .63345 Mtetra
.67 .766 .923 r
.23537 .63345 .24343 .64022 .25547 .63599 .24746 .62912 Mtetra
.719 .773 .896 r
.24746 .62912 .25547 .63599 .26771 .62981 .25972 .62303 Mtetra
.839 .778 .794 r
.25972 .62303 .26771 .62981 .28099 .60948 .27265 .60853 Mtetra
.938 .839 .72 r
.27265 .60853 .28099 .60948 .30401 .