(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   6239079,     264608]*)
(*NotebookOutlinePosition[   6251702,     264991]*)
(*  CellTagsIndexPosition[   6249025,     264900]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Unconstrained Optimization", "Chapter",
  CellTags->{"t:1", "c:1"}],

Cell[CellGroupData[{

Cell["Initialization", "Section",
  CellTags->{"t:2", "c:2"}],

Cell[TextData[{
  "This loads the ",
  StyleBox[ButtonBox["Optimization`UnconstrainedProblems`",
    ButtonData:>"UnconstrainedProblems",
    ButtonStyle->"Hyperlink"], "MR"],
  " package, which contains a number of examples for unconstrained \
optimization and some commands for visualizing searches."
}], "MathCaption"],

Cell[BoxData[
    \(Needs["\<Optimization`UnconstrainedProblems`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->{"t:3", "c:3"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has a collection of commands that do unconstrained optimization (",
  StyleBox["FindMinimum", "MR"],
  " and ",
  StyleBox["FindMaximum", "MR"],
  ") and solve nonlinear equations (",
  StyleBox["FindRoot", "MR"],
  ") and nonlinear fitting problems (",
  StyleBox["FindFit", "MR"],
  "). All of these",
  StyleBox[" ", "MR"],
  "functions work, in general, by doing a search, starting at some initial \
values and taking steps that decrease (or for ",
  StyleBox["FindMaximum", "MR"],
  ", increase) an objective or merit function. "
}], "Text"],

Cell[TextData[{
  "The search process for ",
  StyleBox["FindMaximum", "MR"],
  " is somewhat analogous to a climber trying to reach a mountain peak in a \
thick fog; at any given point, basically all that she knows is her position, \
how steep the slope is, and the direction of the fall line. One approach is \
always to go uphill. As long as she goes uphill steeply enough, she will \
eventually reach a peak, though it may not be the highest one. Similarly, in \
a search for a maximum, most methods are ascent methods where every step \
increases the height and stops when it reaches any peak, whether it is the \
highest one or not. "
}], "Text"],

Cell[TextData[{
  "The analogy with hill climbing can be reversed to consider descent methods \
for finding local minima. For the most part, the literature in optimization \
considers the problem of finding minima, and since this applies to more of \
the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands, from here on, this documentation will follow that convention. "
}], "Text"],

Cell[TextData[{
  "For example, the function ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(sin(x\  + \ 1)\)\)]],
  " is not bounded from below, so it has no global minimum, but it has an \
infinite number of local minima."
}], "Text"],

Cell[TextData[{
  "This shows a plot of the function ",
  StyleBox["x Sin[x + 1]", "MR"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[x\ Sin[x\  + \ 1], {x, \(-10\), 10}];\)\)], "Input",
  CellLabel->"In[1]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0476191 0.325985 0.0311273 [
[.02381 .31348 -9 -9 ]
[.02381 .31348 9 0 ]
[.2619 .31348 -6 -9 ]
[.2619 .31348 6 0 ]
[.7381 .31348 -3 -9 ]
[.7381 .31348 3 0 ]
[.97619 .31348 -6 -9 ]
[.97619 .31348 6 0 ]
[.4875 .01471 -18 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .09253 -24 -4.5 ]
[.4875 .09253 0 4.5 ]
[.4875 .17035 -12 -4.5 ]
[.4875 .17035 0 4.5 ]
[.4875 .24817 -24 -4.5 ]
[.4875 .24817 0 4.5 ]
[.4875 .4038 -18 -4.5 ]
[.4875 .4038 0 4.5 ]
[.4875 .48162 -6 -4.5 ]
[.4875 .48162 0 4.5 ]
[.4875 .55944 -18 -4.5 ]
[.4875 .55944 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .32598 m
.02381 .33223 L
s
[(-10)] .02381 .31348 0 1 Mshowa
.2619 .32598 m
.2619 .33223 L
s
[(-5)] .2619 .31348 0 1 Mshowa
.7381 .32598 m
.7381 .33223 L
s
[(5)] .7381 .31348 0 1 Mshowa
.97619 .32598 m
.97619 .33223 L
s
[(10)] .97619 .31348 0 1 Mshowa
.125 Mabswid
.07143 .32598 m
.07143 .32973 L
s
.11905 .32598 m
.11905 .32973 L
s
.16667 .32598 m
.16667 .32973 L
s
.21429 .32598 m
.21429 .32973 L
s
.30952 .32598 m
.30952 .32973 L
s
.35714 .32598 m
.35714 .32973 L
s
.40476 .32598 m
.40476 .32973 L
s
.45238 .32598 m
.45238 .32973 L
s
.54762 .32598 m
.54762 .32973 L
s
.59524 .32598 m
.59524 .32973 L
s
.64286 .32598 m
.64286 .32973 L
s
.69048 .32598 m
.69048 .32973 L
s
.78571 .32598 m
.78571 .32973 L
s
.83333 .32598 m
.83333 .32973 L
s
.88095 .32598 m
.88095 .32973 L
s
.92857 .32598 m
.92857 .32973 L
s
.25 Mabswid
0 .32598 m
1 .32598 L
s
.5 .01471 m
.50625 .01471 L
s
[(-10)] .4875 .01471 1 0 Mshowa
.5 .09253 m
.50625 .09253 L
s
[(-7.5)] .4875 .09253 1 0 Mshowa
.5 .17035 m
.50625 .17035 L
s
[(-5)] .4875 .17035 1 0 Mshowa
.5 .24817 m
.50625 .24817 L
s
[(-2.5)] .4875 .24817 1 0 Mshowa
.5 .4038 m
.50625 .4038 L
s
[(2.5)] .4875 .4038 1 0 Mshowa
.5 .48162 m
.50625 .48162 L
s
[(5)] .4875 .48162 1 0 Mshowa
.5 .55944 m
.50625 .55944 L
s
[(7.5)] .4875 .55944 1 0 Mshowa
.125 Mabswid
.5 .03028 m
.50375 .03028 L
s
.5 .04584 m
.50375 .04584 L
s
.5 .0614 m
.50375 .0614 L
s
.5 .07697 m
.50375 .07697 L
s
.5 .10809 m
.50375 .10809 L
s
.5 .12366 m
.50375 .12366 L
s
.5 .13922 m
.50375 .13922 L
s
.5 .15478 m
.50375 .15478 L
s
.5 .18591 m
.50375 .18591 L
s
.5 .20148 m
.50375 .20148 L
s
.5 .21704 m
.50375 .21704 L
s
.5 .2326 m
.50375 .2326 L
s
.5 .26373 m
.50375 .26373 L
s
.5 .27929 m
.50375 .27929 L
s
.5 .29486 m
.50375 .29486 L
s
.5 .31042 m
.50375 .31042 L
s
.5 .34155 m
.50375 .34155 L
s
.5 .35711 m
.50375 .35711 L
s
.5 .37268 m
.50375 .37268 L
s
.5 .38824 m
.50375 .38824 L
s
.5 .41937 m
.50375 .41937 L
s
.5 .43493 m
.50375 .43493 L
s
.5 .45049 m
.50375 .45049 L
s
.5 .46606 m
.50375 .46606 L
s
.5 .49719 m
.50375 .49719 L
s
.5 .51275 m
.50375 .51275 L
s
.5 .52831 m
.50375 .52831 L
s
.5 .54388 m
.50375 .54388 L
s
.5 .575 m
.50375 .575 L
s
.5 .59057 m
.50375 .59057 L
s
.5 .60613 m
.50375 .60613 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .45427 m
.03279 .50176 L
.04262 .54453 L
.04758 .56197 L
.05288 .57734 L
.05789 .58863 L
.06244 .59613 L
.06507 .59925 L
.0665 .60058 L
.06785 .60159 L
.06899 .60226 L
.07022 .6028 L
.07092 .60303 L
.07158 .60318 L
.07283 .60332 L
.07354 .60331 L
.07418 .60325 L
.07493 .60311 L
.07563 .60292 L
.07687 .60243 L
.07822 .60169 L
.07971 .60061 L
.08129 .59918 L
.0841 .59588 L
.08915 .5877 L
.09387 .57755 L
.10458 .54632 L
.12493 .46305 L
.14349 .3731 L
.16419 .27571 L
.17329 .23847 L
.18333 .2035 L
.19292 .17725 L
.1973 .16778 L
.20192 .1596 L
.20429 .15613 L
.20688 .15289 L
.20926 .15044 L
.21142 .14864 L
.21399 .14704 L
.2154 .14641 L
.21604 .14617 L
.21673 .14596 L
.21796 .14569 L
.2191 .14555 L
.22032 .14553 L
.22101 .14557 L
.22166 .14564 L
.22291 .14589 L
.22361 .14608 L
Mistroke
.22425 .14629 L
.22664 .14737 L
.22799 .14818 L
.22944 .14921 L
.23207 .15149 L
.23722 .15743 L
.24195 .16451 L
.25097 .18181 L
.26049 .2045 L
.29851 .31419 L
.3094 .34324 L
.3197 .36698 L
.32972 .38565 L
.33413 .39232 L
.33899 .39852 L
.34335 .40305 L
.34805 .40681 L
.35064 .4084 L
.35301 .40956 L
.35528 .4104 L
.35642 .41072 L
.35766 .41101 L
.35832 .41112 L
.35903 .41123 L
.36033 .41136 L
.36159 .41141 L
.36275 .41139 L
.36401 .41129 L
.36472 .41121 L
.36539 .41111 L
.36673 .41085 L
.36818 .41048 L
.3708 .40958 L
.37329 .40848 L
.37795 .40576 L
.38759 .39785 L
.39783 .38682 L
.41625 .36366 L
.43592 .34018 L
.44453 .33193 L
.44942 .32804 L
.45396 .32498 L
.45889 .32232 L
.46337 .32051 L
.46584 .31976 L
.46816 .31921 L
.46936 .31899 L
.47062 .31881 L
.47128 .31873 L
.47201 .31865 L
Mistroke
.47329 .31856 L
.47395 .31853 L
.47468 .31851 L
.476 .31852 L
.47728 .31857 L
.47848 .31865 L
.47921 .31873 L
.47989 .31881 L
.48118 .31899 L
.48405 .31955 L
.48658 .32021 L
.4889 .32095 L
.49414 .32304 L
.50388 .32822 L
.51297 .33409 L
.52359 .34136 L
.53364 .34777 L
.53838 .35038 L
.5434 .35272 L
.54602 .35374 L
.54891 .35469 L
.55154 .35536 L
.55272 .35561 L
.55401 .35583 L
.55511 .35599 L
.55628 .35612 L
.55752 .35621 L
.55867 .35625 L
.55982 .35626 L
.56091 .35622 L
.56189 .35616 L
.56294 .35606 L
.5641 .35591 L
.56538 .35569 L
.56795 .35509 L
.57034 .35434 L
.57257 .35346 L
.57756 .35086 L
.58299 .34705 L
.59287 .33752 L
.6025 .32526 L
.61141 .31165 L
.65062 .24202 L
.66094 .22655 L
.66636 .21983 L
.67208 .21404 L
.67711 .21022 L
.67995 .20862 L
.68132 .208 L
.68261 .20751 L
Mistroke
.68378 .20715 L
.68505 .20684 L
.68621 .20664 L
.68728 .20653 L
.68843 .20648 L
.6897 .20652 L
.69034 .20657 L
.69103 .20666 L
.69227 .20689 L
.69296 .20706 L
.6936 .20725 L
.69481 .20766 L
.69751 .20892 L
.69984 .21038 L
.70237 .21235 L
.70811 .21835 L
.7134 .22574 L
.72316 .24401 L
.73348 .26937 L
.77144 .39787 L
.79258 .47104 L
.80259 .4996 L
.81185 .52043 L
.81649 .52842 L
.82142 .53495 L
.82397 .53748 L
.82636 .53932 L
.82774 .54013 L
.82899 .54071 L
.82971 .54098 L
.83037 .54118 L
.83107 .54135 L
.83183 .54147 L
.83301 .54156 L
.83429 .54149 L
.8355 .54128 L
.83662 .54096 L
.83763 .54056 L
.83873 .54 L
.84097 .53848 L
.84341 .53626 L
.84602 .5332 L
.85075 .52588 L
.856 .5151 L
.86088 .50265 L
.87192 .46616 L
.89202 .375 L
.93118 .15991 L
.94149 .10984 L
.95263 .06499 L
Mistroke
.95774 .04845 L
.96314 .03418 L
.96775 .02478 L
.97037 .02065 L
.97281 .01761 L
.97458 .0159 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[1]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oT03oool0
0`000000oooo0?ooo`2=0?ooo`00T03oool00`000000oooo0?ooo`2=0?ooo`00PP3oool500000080
oooo0P0000050?ooo`030000003oool0oooo08d0oooo00240?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo08d0oooo00240?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`<00000Q@3oool00`000000
oooo0?ooo`050?ooo`00O03oool4000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?ooo`060?ooo`00
Q03oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`230?ooo`030000003oool0oooo00L0oooo00230?ooo`800000103oool2000000D0oooo
00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`080?ooo`00T03oool00`000000oooo0?oo
o`220?ooo`030000003oool0oooo00P0oooo002@0?ooo`800000PP3oool00`000000oooo0?ooo`09
0?ooo`00T03oool00`000000oooo0?ooo`210?ooo`030000003oool0oooo00T0oooo002@0?ooo`03
0000003oool0oooo0800oooo00<000000?ooo`3oool02P3oool00900oooo00<000000?ooo`3oool0
P03oool00`000000oooo0?ooo`0:0?ooo`00T03oool200000800oooo00<000000?ooo`3oool02`3o
ool00900oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`0;0?ooo`00T03oool00`00
0000oooo0?ooo`1o0?ooo`030000003oool0oooo00/0oooo002@0?ooo`030000003oool0oooo07l0
oooo00<000000?ooo`3oool02`3oool00900oooo00<000000?ooo`3oool0OP3oool00`000000oooo
0?ooo`0<0?ooo`00T03oool2000007l0oooo00<000000?ooo`3oool0303oool00900oooo00<00000
0?ooo`3oool0OP3oool00`000000oooo0?ooo`0<0?ooo`00T03oool00`000000oooo0?ooo`1n0?oo
o`030000003oool0oooo00`0oooo002@0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3o
ool03@3oool00900oooo0P00001n0?ooo`030000003oool0oooo00d0oooo002@0?ooo`030000003o
ool0oooo07d0oooo00<000000?ooo`3oool03@3oool00900oooo00<000000?ooo`3oool0O@3oool0
0`000000oooo0?ooo`0=0?ooo`00OP3oool00`000000oooo0?ooo`020?ooo`800000103oool20000
00D0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`0>0?ooo`00OP3oool00`000000
oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0O03oool00`00
0000oooo0?ooo`0>0?ooo`00OP3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080
oooo0`00001l0?ooo`030000003oool0oooo00h0oooo001f0?ooo`@000001@3oool00`000000oooo
0?ooo`070?ooo`8000001@3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo00h0oooo
001l0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`1k0?ooo`030000003oool0oooo00l0oooo001l0?ooo`@000002@3oool3000000@0oooo00<0
00000?ooo`3oool0N`3oool00`000000oooo0?ooo`0?0?ooo`00T03oool2000007`0oooo00<00000
0?ooo`3oool03`3oool00900oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`0?0?oo
o`00T03oool00`000000oooo0?ooo`1k0?ooo`030000003oool0oooo00l0oooo002@0?ooo`030000
003oool0oooo07X0oooo00<000000?ooo`3oool0403oool00900oooo0P00001k0?ooo`030000003o
ool0oooo0100oooo002@0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0403oool0
0900oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`0@0?ooo`00T03oool00`000000
oooo0?ooo`1j0?ooo`030000003oool0oooo0100oooo002@0?ooo`030000003oool0oooo07T0oooo
00<000000?ooo`3oool04@3oool00900oooo0P00001j0?ooo`030000003oool0oooo0140oooo002@
0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool04@3oool003l0oooo1@00001<0?oo
o`030000003oool0oooo07T0oooo00<000000?ooo`3oool04@3oool003d0oooo0P0000040?ooo`80
0000B`3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo0140oooo000m0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0B@3oool2000007T0oooo00<000000?ooo`3oool0
4P3oool003`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`180?ooo`030000003o
ool0oooo07P0oooo00<000000?ooo`3oool04P3oool003/0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`170?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool04P3oool0
03X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0o0?ooo`8000001@3oool00`00
0000oooo0?ooo`1h0?ooo`030000003oool0oooo0180oooo000j0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0?P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
07P0oooo00<000000?ooo`3oool04P3oool003X0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`100?ooo`030000003oool0oooo0080oooo0`00001g0?ooo`030000003oool0oooo01<0
oooo000i0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0=`3oool4000000<0oooo
0P0000050?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool04`3oool003T0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0M`3oool00`000000oooo0?ooo`0C0?ooo`00>@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo03d0oooo0`0000040?ooo`030000003oool0oooo07L0oooo00<00000
0?ooo`3oool04`3oool003P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`140?oo
o`800000N03oool00`000000oooo0?ooo`0C0?ooo`00>03oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo04<0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`0C0?ooo`00
=`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
MP3oool00`000000oooo0?ooo`0D0?ooo`00=`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0480oooo00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`0D0?ooo`00=P3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0MP3oool0
0`000000oooo0?ooo`0D0?ooo`00=P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
0440oooo0P00001g0?ooo`030000003oool0oooo01@0oooo000f0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0a0?ooo`D00000@03oool00`000000
oooo0?ooo`0D0?ooo`00=@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`020?ooo`800000?P3oool00`000000oooo
0?ooo`0E0?ooo`00=@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool0;P3oool2000000L0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?oo
o`0E0?ooo`00=@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0400oooo0P00000^
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0E
0?ooo`00=03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03l0oooo00<000000?oo
o`3oool0;03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03T0oooo00<000000?oo
o`3oool05@3oool003@0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0o0?ooo`03
0000003oool0oooo02/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0h0?ooo`03
0000003oool0oooo01D0oooo000d0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
>03oool00`000000oooo0?ooo`0E0?ooo`00=03oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo03h0oooo0P00000[0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0F0?ooo`00<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo03h0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool05P3oool003<0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0n0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0e0?ooo`030000003oool0oooo01H0oooo000c0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool0:@3oool4000000<0oooo0P0000040?ooo`8000001@3oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`0F0?ooo`00<P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02T0oooo
00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo02L0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01H0
oooo000b0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo0080oooo0`00000W0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0G0?ooo`00<P3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo0280oooo100000040?ooo`030000003oool0oooo00P0oooo0P00
00050?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0b0?ooo`030000003oool0oooo01L0oooo000b0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0:03oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0380oooo00<0
00000?ooo`3oool05`3oool00340oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0Y
0?ooo`8000002P3oool3000000@0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool05`3oool00340oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0k0?ooo`8000009P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool05`3oool00340oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01L0oooo000a0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0H0?ooo`00<03o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0603o
ool00300oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo0280oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo01P0oooo000`0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0>@3oool20000
02<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
01P0oooo00070?ooo`D000000P3oool200000200oooo00<000000?ooo`3oool06`3oool2000000@0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo01`0
oooo0P00000`0?ooo`030000003oool0oooo00/0oooo1@0000020?ooo`800000103oool000T0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool06`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo03T0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0K0?ooo`040000003oool00000000002l0oooo00<00000
0?ooo`3oool03@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00@3o
ool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool07P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03P0oooo00<0
00000?ooo`3oool0803oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
0@3oool000030?ooo`000000000000800000103oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0E0?ooo`@000000`3oool2000000D0oooo
00<000000?ooo`3oool0>03oool200000240oooo00<000000?ooo`3oool07@3oool3000002h0oooo
00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00@3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03P0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0000002h0
oooo00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool00@3oool000P0oooo0P0000040?ooo`8000007`3oool00`000000oooo0?ooo`0L0?ooo`<0
00001@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool07P3oool3000002h0oooo00<000000?ooo`3oool03@3oool2000000@0oooo0P0000040?ooo`00
;`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
6@3oool002h0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0g0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo01X0oooo000^0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0=P3oool2
000001h0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo01X0oooo000^0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0:@3oool00`00
0000oooo0?ooo`0J0?ooo`00;P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02`0
oooo1`0000030?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool09P3oool00`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo01X0oooo000^0?ooo`030000003oool0oooo02L0oooo
00<000000?ooo`3oool0:@3oool2000000L0oooo0P0000000`3oool000000?ooo`0L0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0J0?ooo`000P3o
oooo000001l0000000090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`000000303oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00X0oooo0P00000<0?ooo`<000002`3oool00`000000oooo0?oo
o`0:0?ooo`800000303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00D0
00000?ooo`3oool0oooo000000080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`050?ooo`002@3oool00`000000oooo0?ooo`0Q0?ooo`030000003o
ool0oooo01`0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0T0?ooo`8000003P3o
ool00`000000oooo0?ooo`02000001L0oooo00<000000?ooo`3oool09@3oool01@000000oooo0?oo
o`3oool0000002T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`00;@3o
ool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`020?ooo`800000503oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool06`3oool002d0oooo00<000000?ooo`3oool0:P3oool0
0`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00l0oooo0P0000050?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo01/0oooo000/0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00D0oooo0P00000?0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0K0?ooo`00;03oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo01`0oooo000/0?ooo`030000003oool0oooo02`0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0203oool200000340oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0L0?ooo`00;03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`090?ooo`@000000`3oool3000003@0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`0L0?ooo`00;03oool00`000000oooo0?ooo`0]
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool04`3oool2000000d0oooo1000000g
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0703oool002`0oooo00<000000?oo
o`3oool0;@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool0A`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01`0oooo000[0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0E0?ooo`03
0000003oool0oooo04L0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0L0?ooo`00
:`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0
7@3oool002/0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo01L0oooo0P0000190?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool07@3o
ool002/0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0R0?ooo`030000003oool0
oooo01d0oooo000[0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`0M0?ooo`00:P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0240
oooo00<000000?ooo`3oool07@3oool002X0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0B@3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo01h0oooo000Z0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0K0?ooo`800000BP3oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo01h0oooo000Z0?ooo`030000003oool0oooo03@0oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo04X0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`0N0?ooo`00:@3oool00`000000oooo0?ooo`0e0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool4000000<0oooo0P0000040?oo
o`8000001@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo01l0oooo00<000000?oo
o`3oool07P3oool002T0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo04X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0O0?oo
o`00:@3oool00`000000oooo0?ooo`0g0?ooo`8000002@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool3000004/0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`0O0?ooo`00:@3oool00`000000oooo0?ooo`0i0?ooo`800000
1P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000
003oool0oooo04/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0O0?ooo`00:03o
ool00`000000oooo0?ooo`0k0?ooo`L000003`3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo01l0oooo000X0?ooo`030000003oool0oooo0580oooo0P00000:0?ooo`<00000103o
ool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0803o
ool002P0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0803oool002P0oooo00<000000?ooo`3oool0I@3oool20000
04d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0P0?ooo`00:03oool00`000000
oooo0?ooo`1U0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0P0?ooo`009`3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo04d0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0P0?ooo`009`3oool00`000000oooo0?oo
o`1V0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0Q0?ooo`009`3oool00`000000oooo0?ooo`1V0?ooo`800000CP3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo0240oooo000W0?ooo`030000003oool0oooo06H0oooo00<000000?oo
o`3oool0C@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0240oooo000V0?ooo`03
0000003oool0oooo06L0oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo0240oooo000V0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0
CP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0280oooo000V0?ooo`030000003o
ool0oooo06L0oooo0P00001?0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool08P3o
ool002H0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool08P3oool000T0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`1X0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0R0?ooo`002@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02<0
oooo00090?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0J03oool00`000000oooo
0?ooo`1?0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool08`3oool000T0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`1X0?ooo`800000D@3oool00`000000oooo0?oo
o`0D0?ooo`030000003oool0oooo02<0oooo000:0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0J03oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool08`3oool000X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1R0?oo
o`8000001@3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0903oool000X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1Q0?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo02@0oooo000:0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0I03oool00`000000oooo0?ooo`020?ooo`<00000D@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo02@0oooo000:0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
HP3oool2000000D0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo02D0oooo000:0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0HP3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0U0?ooo`002`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo06<0oooo0`0000040?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0U0?ooo`002`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
06X0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
02D0oooo000;0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0JP3oool2000005@0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0V0?ooo`002`3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0D`3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo02H0oooo000;0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool0J`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool09`3oool000/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`1[
0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0W
0?ooo`00303oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo06/0oooo0P00001F0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0:03oool000`0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0X0?ooo`00303oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo06/0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo02P0oooo000<0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0K03o
ool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0:@3o
ool000d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0
oooo05L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0Y0?ooo`003@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo06`0oooo0P00001H0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0:P3oool000d0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`1/0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0Z0?ooo`003@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo06`0oooo
00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02/0oooo
000>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?oo
o`1J0?ooo`D00000;P3oool000h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1]
0?ooo`800000SP3oool000h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`1]0?oo
o`030000003oool0oooo08d0oooo000>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0K@3oool00`000000oooo0?ooo`2=0?ooo`003`3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo05`0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000050?ooo`030000
003oool0oooo08d0oooo000?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0G03o
ool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
S@3oool000l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1M0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool00P3oool3000008d0oooo000?0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`070?ooo`8000001@3oool0
0`000000oooo0?ooo`2=0?ooo`00403oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
05`0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo08d0oooo000@0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0G03oool40000
00T0oooo0`0000040?ooo`030000003oool0oooo08d0oooo000A0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0L@3oool2000008h0oooo000A0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`2=0?ooo`004@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0740oooo00<000000?ooo`3oool0S@3oool00180oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo08d0oooo000B0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0LP3oool2000008h0oooo000C0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`2=0?ooo`00
503oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo07<0oooo00<000000?ooo`3oool0
S@3oool001@0oooo0P0000020?ooo`800000MP3oool00`000000oooo0?ooo`2=0?ooo`005@3oool4
000007L0oooo00<000000?ooo`3oool0S@3oool00900oooo0P00002>0?ooo`00T03oool00`000000
oooo0?ooo`2=0?ooo`00T03oool00`000000oooo0?ooo`2=0?ooo`00T03oool00`000000oooo0?oo
o`2=0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-10, -10, 0, 0}}]
}, Open  ]],

Cell[TextData[{
  "This shows the steps taken by ",
  StyleBox["FindMinimum", "MR"],
  " for the function ",
  StyleBox["x Sin[x + 1]", "MR"],
  " starting at x = 0."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[x\ Sin[x\  + \ 1], {x, 0}]\)], "Input",
  CellLabel->"In[2]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 1.73821 0.603319 2.45124 [
[.10708 .59082 -12 -9 ]
[.10708 .59082 12 0 ]
[.2809 .59082 -12 -9 ]
[.2809 .59082 12 0 ]
[.45473 .59082 -12 -9 ]
[.45473 .59082 12 0 ]
[.62855 .59082 -12 -9 ]
[.62855 .59082 12 0 ]
[.80237 .59082 -12 -9 ]
[.80237 .59082 12 0 ]
[.96369 .11307 -24 -4.5 ]
[.96369 .11307 0 4.5 ]
[.96369 .23563 -30 -4.5 ]
[.96369 .23563 0 4.5 ]
[.96369 .3582 -24 -4.5 ]
[.96369 .3582 0 4.5 ]
[.96369 .48076 -30 -4.5 ]
[.96369 .48076 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10708 .60332 m
.10708 .60957 L
s
[(-0.5)] .10708 .59082 0 1 Mshowa
.2809 .60332 m
.2809 .60957 L
s
[(-0.4)] .2809 .59082 0 1 Mshowa
.45473 .60332 m
.45473 .60957 L
s
[(-0.3)] .45473 .59082 0 1 Mshowa
.62855 .60332 m
.62855 .60957 L
s
[(-0.2)] .62855 .59082 0 1 Mshowa
.80237 .60332 m
.80237 .60957 L
s
[(-0.1)] .80237 .59082 0 1 Mshowa
.125 Mabswid
.14185 .60332 m
.14185 .60707 L
s
.17661 .60332 m
.17661 .60707 L
s
.21138 .60332 m
.21138 .60707 L
s
.24614 .60332 m
.24614 .60707 L
s
.31567 .60332 m
.31567 .60707 L
s
.35043 .60332 m
.35043 .60707 L
s
.3852 .60332 m
.3852 .60707 L
s
.41996 .60332 m
.41996 .60707 L
s
.48949 .60332 m
.48949 .60707 L
s
.52425 .60332 m
.52425 .60707 L
s
.55902 .60332 m
.55902 .60707 L
s
.59378 .60332 m
.59378 .60707 L
s
.66331 .60332 m
.66331 .60707 L
s
.69808 .60332 m
.69808 .60707 L
s
.73284 .60332 m
.73284 .60707 L
s
.7676 .60332 m
.7676 .60707 L
s
.83713 .60332 m
.83713 .60707 L
s
.8719 .60332 m
.8719 .60707 L
s
.90666 .60332 m
.90666 .60707 L
s
.94143 .60332 m
.94143 .60707 L
s
.07232 .60332 m
.07232 .60707 L
s
.03755 .60332 m
.03755 .60707 L
s
.00279 .60332 m
.00279 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.97619 .11307 m
.98244 .11307 L
s
[(-0.2)] .96369 .11307 1 0 Mshowa
.97619 .23563 m
.98244 .23563 L
s
[(-0.15)] .96369 .23563 1 0 Mshowa
.97619 .3582 m
.98244 .3582 L
s
[(-0.1)] .96369 .3582 1 0 Mshowa
.97619 .48076 m
.98244 .48076 L
s
[(-0.05)] .96369 .48076 1 0 Mshowa
.125 Mabswid
.97619 .13758 m
.97994 .13758 L
s
.97619 .1621 m
.97994 .1621 L
s
.97619 .18661 m
.97994 .18661 L
s
.97619 .21112 m
.97994 .21112 L
s
.97619 .26015 m
.97994 .26015 L
s
.97619 .28466 m
.97994 .28466 L
s
.97619 .30917 m
.97994 .30917 L
s
.97619 .33368 m
.97994 .33368 L
s
.97619 .38271 m
.97994 .38271 L
s
.97619 .40722 m
.97994 .40722 L
s
.97619 .43173 m
.97994 .43173 L
s
.97619 .45624 m
.97994 .45624 L
s
.97619 .50527 m
.97994 .50527 L
s
.97619 .52978 m
.97994 .52978 L
s
.97619 .55429 m
.97994 .55429 L
s
.97619 .57881 m
.97994 .57881 L
s
.97619 .08856 m
.97994 .08856 L
s
.97619 .06405 m
.97994 .06405 L
s
.97619 .03953 m
.97994 .03953 L
s
.97619 .01502 m
.97994 .01502 L
s
.25 Mabswid
.97619 0 m
.97619 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01661 m
.03279 .01597 L
.04262 .01542 L
.04758 .0152 L
.05288 .01501 L
.05789 .01487 L
.06006 .01483 L
.06244 .01479 L
.06507 .01475 L
.0665 .01474 L
.06785 .01473 L
.0691 .01472 L
.07025 .01472 L
.07088 .01472 L
.07157 .01472 L
.07283 .01472 L
.07359 .01472 L
.07431 .01472 L
.07496 .01472 L
.07566 .01473 L
.07723 .01474 L
.07868 .01475 L
.08132 .01479 L
.0841 .01484 L
.08915 .01496 L
.09387 .01511 L
.10458 .01559 L
.11503 .01623 L
.12493 .01701 L
.14349 .01888 L
.1634 .02151 L
.18182 .02449 L
.22108 .03265 L
.25883 .04276 L
.29904 .05594 L
.33773 .07092 L
.37887 .08929 L
.41849 .10931 L
.4566 .13068 L
.49716 .15565 L
.5362 .1818 L
.5777 .21182 L
.61768 .24286 L
.65615 .27461 L
.69707 .31037 L
.73647 .34667 L
.77436 .38325 L
.8147 .42393 L
.85352 .46471 L
.8948 .50975 L
Mistroke
.93456 .55469 L
.97281 .59931 L
.97619 .60332 L
Mfstroke
0 0 0 r
.055 w
.07185 .01472 Mdot
1 0 0 r
.0325 w
.97619 .60332 Mdot
.24486 .03876 Mdot
.02381 .01661 Mdot
.07308 .01472 Mdot
.07186 .01472 Mdot
.07185 .01472 Mdot
0 1 0 r
.02 w
.97619 .60332 Mdot
.24486 .03876 Mdot
.02381 .01661 Mdot
.07308 .01472 Mdot
.07186 .01472 Mdot
.07185 .01472 Mdot
0 0 1 r
.5 Mabswid
.97619 .60332 m
.97619 .60332 L
.24486 .03876 L
.02381 .01661 L
.07308 .01472 L
.07186 .01472 L
.07185 .01472 L
s
.015 w
.97619 .60332 Mdot
.97619 .60332 Mdot
.24486 .03876 Mdot
.02381 .01661 Mdot
.07308 .01472 Mdot
.07186 .01472 Mdot
.07185 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o1P3oool3
0?l000D0oooo1@0000040?l000@00000o03oool00`000000oooo0?ooo`060?ooo`00103oool70?l0
00<0oooo0`0000080?l000800000o03oool00`000000oooo0?ooo`060?ooo`00103oool70?l00080
oooo100000020?l00003003o00000?l0003o00<0o`000`00003k0?ooo`030000003oool0oooo00H0
oooo00030?ooo`80o`0000<00?l00000o`000?l0103o0000103oool000000000000000020?l00003
003o00000?l0003o0080003o0`3o000200000?/0oooo00<000000?ooo`3oool01P3oool000<0oooo
00<0o`00003o00000?l04@000?l30?l000d00000l03oool2000000L0oooo00030?ooo`030?l00000
o`00003o00<0003o0`3o000:0000o`04003o003o0000o`000?l0008000002`3oool500000>/0oooo
00<000000?ooo`3oool01P3oool000@0oooo0P00o`020000o`03003o003o0000o`000080oooo1000
00020?l000800?l02@000?l>0?ooo`H00000i@3oool00`000000oooo0?ooo`060?ooo`00103oool0
103o00000?l0003o0000o`030?l000<0oooo0`0000080?l0008000000`3oool90000o`/0oooo1@00
000>0?ooo`<0o`00c`3oool00`000000oooo0?ooo`060?ooo`001P3oool30?l000D0oooo1@000004
0?l000@00000303oool90000o`L0oooo1P0000060?ooo`L0o`00c@3oool00`000000oooo0?ooo`06
0?ooo`003`3oool;000001H0oooo2@000?l40?ooo`@000000P3oool20?l00080003o00<00?l00?l0
003o0000c@3oool00`000000oooo0?ooo`060?ooo`00403oool900000200oooo2@000?l20?l000@0
003o00<00?l00?l0003o0000c03oool00`000000oooo0?ooo`060?ooo`004P3oool5000002/0oooo
1P000?l00`00o`00o`000?l0003<0?ooo`8000001`3oool00480oooo0P3o00001@00o`00003o0000
o`000?l00?l00080o`0000<000000?ooo`3oool0b@3oool00`000000oooo0?ooo`060?ooo`00@`3o
ool20?l000<00?l00P000?l20?ooo`<00000b03oool00`000000oooo0?ooo`060?ooo`00@`3oool7
0?l000030000o`3oool0oooo0080oooo0P0000360?ooo`030000003oool0oooo00H0oooo00150?oo
o`<0o`000`3oool00`000?l0oooo0?ooo`030?ooo`<00000``3oool00`000000oooo0?ooo`060?oo
o`00C03oool20000o`H0oooo0`0000300?ooo`030000003oool0oooo00H0oooo001>0?ooo`030000
o`3oool0oooo00H0oooo0`00002m0?ooo`030000003oool0oooo00H0oooo001?0?ooo`030000o`3o
ool0oooo00P0oooo0`00002j0?ooo`8000001`3oool00500oooo0P000?l;0?ooo`<00000]`3oool0
0`000000oooo0?ooo`060?ooo`00DP3oool00`000?l0oooo0?ooo`0;0?ooo`<00000]03oool00`00
0000oooo0?ooo`060?ooo`00D`3oool00`000?l0oooo0?ooo`0=0?ooo`800000/P3oool00`000000
oooo0?ooo`060?ooo`00E03oool00`000?l0oooo0?ooo`0>0?ooo`800000/03oool00`000000oooo
0?ooo`060?ooo`00E@3oool20000oa00oooo0P00002^0?ooo`030000003oool0oooo00H0oooo001G
0?ooo`030000o`3oool0oooo00l0oooo0P00002/0?ooo`030000003oool0oooo00H0oooo001H0?oo
o`030000o`3oool0oooo0100oooo0P00002Z0?ooo`8000001`3oool005T0oooo0P000?lB0?ooo`80
0000Z03oool00`000000oooo0?ooo`060?ooo`00F`3oool00`000?l0oooo0?ooo`0A0?ooo`800000
YP3oool00`000000oooo0?ooo`060?ooo`00G03oool00`000?l0oooo0?ooo`0B0?ooo`800000Y03o
ool00`000000oooo0?ooo`060?ooo`00G@3oool20000oa@0oooo0P00002R0?ooo`030000003oool0
oooo00H0oooo001O0?ooo`030000o`3oool0oooo01<0oooo0P00002=0?ooo`800000103oool20000
00<0oooo100000040?ooo`030000003oool0oooo00H0oooo001P0?ooo`030000o`3oool0oooo01@0
oooo0P00002:0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`060?ooo`00H@3oool00`000?l0oooo0?ooo`0E0?ooo`800000R03oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo00@0oooo0`0000060?ooo`00HP3oool20000oaL0
oooo0P0000200?ooo`@000000P3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool01P3oool006@0oooo00<0003o0?ooo`3oool05P3oool2000008@0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo00H0oooo001U0?ooo`030000o`3oool0oooo01L0oooo0P0000230?ooo`8000002P3oool20000
00D0oooo00<000000?ooo`3oool01P3oool006H0oooo0P000?lI0?ooo`800000U03oool00`000000
oooo0?ooo`060?ooo`00J03oool00`000?l0oooo0?ooo`0H0?ooo`030000003oool0oooo0940oooo
00<000000?ooo`3oool01P3oool006T0oooo00<0003o0?ooo`3oool0603oool200000940oooo00<0
00000?ooo`3oool01P3oool006X0oooo00<0003o0?ooo`3oool06@3oool00`000000oooo0?ooo`2>
0?ooo`8000001`3oool006/0oooo0P000?lJ0?ooo`800000SP3oool00`000000oooo0?ooo`060?oo
o`00K@3oool00`000?l0oooo0?ooo`0I0?ooo`800000S03oool00`000000oooo0?ooo`060?ooo`00
KP3oool00`000?l0oooo0?ooo`0J0?ooo`030000003oool0oooo08T0oooo00<000000?ooo`3oool0
1P3oool006l0oooo0P000?lK0?ooo`800000R@3oool00`000000oooo0?ooo`060?ooo`00L@3oool0
0`000?l0oooo0?ooo`0J0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool01P3oool0
0780oooo00<0003o0?ooo`3oool06P3oool2000008H0oooo00<000000?ooo`3oool01P3oool007<0
oooo0P000?lL0?ooo`030000003oool0oooo08<0oooo0P0000070?ooo`00M@3oool00`000?l0oooo
0?ooo`0J0?ooo`030000003oool0oooo0880oooo00<000000?ooo`3oool01P3oool007H0oooo00<0
003o0?ooo`3oool06P3oool200000880oooo00<000000?ooo`3oool01P3oool007L0oooo00<0003o
0?ooo`3oool06`3oool00`000000oooo0?ooo`1o0?ooo`030000003oool0oooo00H0oooo001h0?oo
o`80003o703oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo00H0oooo001j0?ooo`03
0000o`3oool0oooo01X0oooo0P00001n0?ooo`030000003oool0oooo00H0oooo001k0?ooo`030000
o`3oool0oooo01/0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`060?ooo`00O03o
ool20000oa`0oooo0P00001k0?ooo`8000001`3oool007h0oooo00<0003o0?ooo`3oool06`3oool0
0`000000oooo0?ooo`1h0?ooo`030000003oool0oooo00H0oooo001o0?ooo`030000o`3oool0oooo
01/0oooo0P00001h0?ooo`030000003oool0oooo00H0oooo00200?ooo`80003o7@3oool00`000000
oooo0?ooo`1e0?ooo`030000003oool0oooo00H0oooo00220?ooo`030000o`3oool0oooo01/0oooo
0P00001e0?ooo`030000003oool0oooo00H0oooo00230?ooo`030000o`3oool0oooo01`0oooo00<0
00000?ooo`3oool0LP3oool00`000000oooo0?ooo`060?ooo`00Q03oool00`000?l0oooo0?ooo`0L
0?ooo`800000LP3oool00`000000oooo0?ooo`060?ooo`00Q@3oool20000oah0oooo00<000000?oo
o`3oool0K`3oool2000000L0oooo00270?ooo`030000o`3oool0oooo01`0oooo00<000000?ooo`3o
ool0KP3oool00`000000oooo0?ooo`060?ooo`00R03oool00`000?l0oooo0?ooo`0L0?ooo`800000
KP3oool00`000000oooo0?ooo`060?ooo`00R@3oool20000oah0oooo00<000000?ooo`3oool0J`3o
ool00`000000oooo0?ooo`060?ooo`00R`3oool00`000?l0oooo0?ooo`0L0?ooo`030000003oool0
oooo06X0oooo00<000000?ooo`3oool01P3oool008`0oooo00<0003o0?ooo`3oool0703oool20000
0540oooo0P0000040?ooo`8000000`3oool500000080oooo0P0000050?ooo`030000003oool0oooo
00H0oooo002=0?ooo`80003o7P3oool00`000000oooo0?ooo`1=0?ooo`040000003oool0oooo0000
00X0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01P3oool008l0oooo00<0003o0?ooo`3oool0703oool00`000000oooo0?ooo`1<0?oo
o`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`02
0?ooo`<000001P3oool00900oooo00<0003o0?ooo`3oool0703oool2000004H0oooo100000020?oo
o`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool2000000D0oooo00<00000
0?ooo`3oool01P3oool00940oooo00<0003o0?ooo`3oool07@3oool00`000000oooo0?ooo`190?oo
o`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00H0oooo002B0?ooo`80003o7P3oool00`000000oooo0?ooo`190?oo
o`8000002P3oool2000000@0oooo0`0000040?ooo`030000003oool0oooo00H0oooo002D0?ooo`03
0000o`3oool0oooo01`0oooo0P00001R0?ooo`030000003oool0oooo00H0oooo002E0?ooo`030000
o`3oool0oooo01d0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`060?ooo`00UP3o
ool20000oah0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`060?ooo`00V03oool0
0`000?l0oooo0?ooo`0L0?ooo`030000003oool0oooo05d0oooo0P0000070?ooo`00V@3oool00`00
0?l0oooo0?ooo`0L0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool01P3oool009X0
oooo0P000?lM0?ooo`800000G03oool00`000000oooo0?ooo`060?ooo`00W03oool00`000?l0oooo
0?ooo`0L0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool01P3oool009d0oooo00<0
003o0?ooo`3oool0703oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo00H0oooo002N
0?ooo`030000o`3oool0oooo01`0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`06
0?ooo`00W`3oool20000oad0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`060?oo
o`00X@3oool00`000?l0oooo0?ooo`0K0?ooo`030000003oool0oooo05D0oooo0P0000070?ooo`00
XP3oool00`000?l0oooo0?ooo`0K0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0
1P3oool00:<0oooo0P000?lL0?ooo`800000E03oool00`000000oooo0?ooo`060?ooo`00Y@3oool0
0`000?l0oooo0?ooo`0K0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool01P3oool0
0:H0oooo00<0003o0?ooo`3oool06`3oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo
00H0oooo002W0?ooo`80003o703oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo00H0
oooo002Y0?ooo`030000o`3oool0oooo01X0oooo00<000000?ooo`3oool0CP3oool00`000000oooo
0?ooo`060?ooo`00ZP3oool00`000?l0oooo0?ooo`0J0?ooo`030000003oool0oooo04d0oooo0P00
00070?ooo`00Z`3oool00`000?l0oooo0?ooo`0J0?ooo`030000003oool0oooo04`0oooo00<00000
0?ooo`3oool01P3oool00:`0oooo0P000?lK0?ooo`030000003oool0oooo04/0oooo00<000000?oo
o`3oool01P3oool00:h0oooo00<0003o0?ooo`3oool06@3oool00`000000oooo0?ooo`1:0?ooo`03
0000003oool0oooo00H0oooo002_0?ooo`030000o`3oool0oooo01T0oooo00<000000?ooo`3oool0
B@3oool00`000000oooo0?ooo`060?ooo`00/03oool20000oaX0oooo00<000000?ooo`3oool0B03o
ool00`000000oooo0?ooo`060?ooo`00/P3oool00`000?l0oooo0?ooo`0H0?ooo`800000B03oool0
0`000000oooo0?ooo`060?ooo`00/`3oool00`000?l0oooo0?ooo`0I0?ooo`030000003oool0oooo
04D0oooo0P0000070?ooo`00]03oool00`000?l0oooo0?ooo`0I0?ooo`030000003oool0oooo04@0
oooo00<000000?ooo`3oool01P3oool00;D0oooo0P000?lJ0?ooo`030000003oool0oooo04<0oooo
00<000000?ooo`3oool01P3oool00;L0oooo00<0003o0?ooo`3oool0603oool00`000000oooo0?oo
o`120?ooo`030000003oool0oooo00H0oooo002h0?ooo`030000o`3oool0oooo01P0oooo00<00000
0?ooo`3oool0@@3oool00`000000oooo0?ooo`060?ooo`00^@3oool20000oaT0oooo00<000000?oo
o`3oool0;@3oool2000000@0oooo0P0000030?ooo`D000000`3oool00`000000oooo0?ooo`060?oo
o`00^`3oool00`000?l0oooo0?ooo`0G0?ooo`030000003oool0oooo02/0oooo00@000000?ooo`3o
ool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo002l0?ooo`03
0000o`3oool0oooo01L0oooo00<000000?ooo`3oool0:P3oool010000000oooo0?ooo`00000:0?oo
o`030000003oool0oooo00<0oooo0`0000060?ooo`00_@3oool20000oaP0oooo00<000000?ooo`3o
ool08`3oool400000080oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00H0oooo002o0?ooo`030000o`3oool0oooo01H0oooo0P00000Y0?ooo`04
0000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?oo
o`00`03oool00`000?l0oooo0?ooo`0G0?ooo`030000003oool0oooo02L0oooo0P00000:0?ooo`80
00001@3oool00`000000oooo0?ooo`060?ooo`00`@3oool00`000?l0oooo0?ooo`0G0?ooo`030000
003oool0oooo03T0oooo00<000000?ooo`3oool01P3oool00<80oooo0P000?lH0?ooo`030000003o
ool0oooo03P0oooo00<000000?ooo`3oool01P3oool00<@0oooo00<0003o0?ooo`3oool05P3oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00H0oooo00350?ooo`030000o`3oool0oooo
01H0oooo00<000000?ooo`3oool0=P3oool2000000L0oooo00360?ooo`80003o5`3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo00H0oooo00380?ooo`030000o`3oool0oooo01D0oooo
00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`060?ooo`00b@3oool00`000?l0oooo0?oo
o`0E0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool01P3oool00<X0oooo0P000?lF
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool01P3oool00<`0oooo00<0003o0?oo
o`3oool0503oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00H0oooo003=0?ooo`03
0000o`3oool0oooo01<0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`060?ooo`00
cP3oool00`000?l0oooo0?ooo`0C0?ooo`030000003oool0oooo0300oooo0P0000070?ooo`00c`3o
ool20000oa@0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`060?ooo`00d@3oool0
0`000?l0oooo0?ooo`0B0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool01P3oool0
0=80oooo00<0003o0?ooo`3oool04P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
00H0oooo003C0?ooo`80003o4`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00H0
oooo003E0?ooo`030000o`3oool0oooo0140oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`060?ooo`00eP3oool00`000?l0oooo0?ooo`0A0?ooo`030000003oool0oooo02X0oooo00<0
00000?ooo`3oool01P3oool00=L0oooo0P000?lB0?ooo`030000003oool0oooo02T0oooo0P000007
0?ooo`00f@3oool00`000?l0oooo0?ooo`0@0?ooo`030000003oool0oooo02P0oooo00<000000?oo
o`3oool01P3oool00=X0oooo00<0003o0?ooo`3oool0403oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo00H0oooo003K0?ooo`030000o`3oool0oooo0100oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`060?ooo`00g03oool20000oa00oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`060?ooo`00gP3oool00`000?l0oooo0?ooo`0>0?ooo`030000003oool0
oooo02D0oooo00<000000?ooo`3oool01P3oool00=l0oooo00<0003o0?ooo`3oool03P3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo00H0oooo003P0?ooo`80003o3`3oool00`000000
oooo0?ooo`0S0?ooo`8000001`3oool00>80oooo00<0003o0?ooo`3oool03@3oool00`000000oooo
0?ooo`0R0?ooo`030000003oool0oooo00H0oooo003S0?ooo`030000o`3oool0oooo00d0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`060?ooo`00i03oool20000o`h0oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`060?ooo`00iP3oool00`000?l0oooo0?ooo`0<0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool01P3oool00>L0oooo00<0003o0?ooo`3o
ool0303oool00`000000oooo0?ooo`050?ooo`800000103oool2000000@0oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`060?ooo`00j03oool00`000?l0oooo0?ooo`0<0?ooo`030000
003oool0oooo00<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01P3oool00>T0oooo0P000?l=0?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00050?ooo`030000003oool0oooo0080oooo0`0000060?ooo`00j`3oool00`000?l0oooo0?ooo`09
0?ooo`@000000P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo
0P0000050?ooo`030000003oool0oooo00H0oooo003/0?ooo`030000o`3oool0oooo00/0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`00k@3oool20000o``0oooo
00<000000?ooo`3oool00P00000:0?ooo`800000103oool3000000@0oooo00<000000?ooo`3oool0
1P3oool00>l0oooo00<0003o0?ooo`3oool02P3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo00H0oooo003`0?ooo`030000o`3oool0oooo00X0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`060?ooo`00l@3oool20000o`/0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`060?ooo`00l`3oool00`000?l0oooo0?ooo`090?ooo`030000003oool0oooo01D0
oooo0P0000070?ooo`00m03oool00`000?l0oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool01P3oool00?D0oooo00<0003o0?ooo`3oool02@3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo00H0oooo003f0?ooo`80003o2P3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo00H0oooo003h0?ooo`030000o`3oool0oooo00P0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`060?ooo`00n@3oool00`000?l0oooo0?ooo`070?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool01P3oool00?X0oooo0P000?l80?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool01P3oool00?`0oooo00<0003o0?ooo`3oool01P3o
ool00`000000oooo0?ooo`0?0?ooo`8000001`3oool00?d0oooo00<0003o0?ooo`3oool01P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00H0oooo003n0?ooo`030000o`3oool0oooo
00H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`00o`3oool20000o`L0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`00o`3oool20?ooo`030000
o`3oool0oooo00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`00o`3o
ool30?ooo`030000o`3oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`060?ooo`00o`3oool40?ooo`80003o1@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00H0oooo003o0?ooo`H0oooo00<0003o0?ooo`3oool00`3oool00`000000oooo0?ooo`090?oo
o`8000001`3oool00?l0oooo1`3oool00`000?l0oooo0?ooo`030?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01P3oool00?l0oooo203oool20000o`@0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`060?ooo`006`3oool2000000@0oooo0P0000040?ooo`8000008`3o
ool2000000@0oooo0P0000050?ooo`<000008P3oool2000000@0oooo0P0000040?ooo`800000903o
ool2000000@0oooo0P0000030?ooo`@000008`3oool2000000@0oooo0P0000030?ooo`D000005`3o
ool00`000?l0oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3o
ool001X0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000Q0?ooo`040000
003oool0oooo000000/0oooo00<000000?ooo`3oool0803oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000280oooo00@000000?ooo`3oool00000203oool00`000000oooo0?oo
o`0S0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0603oool01@000?l0oooo
0?ooo`3oool0000000P0oooo00<000000?ooo`3oool01P3oool001X0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`0O0?ooo`040000003oool0oooo000000P0oooo1@00000Q0?oo
o`040000003oool0oooo000000X0oooo00<000000?ooo`3oool08@3oool010000000oooo0?ooo`00
00090?ooo`030000003oool0oooo0280oooo00@000000?ooo`3oool000002P3oool00`000000oooo
0?ooo`0I0?ooo`050000o`3oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`00
503oool400000080oooo00@000000?ooo`3oool000002@3oool2000001`0oooo100000020?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool00000703oool400000080oooo00@00000
0?ooo`3oool000002`3oool00`000000oooo0?ooo`0J0?ooo`@000000P3oool010000000oooo0?oo
o`00000:0?ooo`030000003oool0oooo01/0oooo100000020?ooo`040000003oool0oooo000000X0
oooo00<000000?ooo`3oool06P3oool20000o`80oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`060?ooo`006P3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo0240
oooo00@000000?ooo`3oool000002@3oool00`000000oooo0000000R0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000008P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000280oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0L0?oo
o`040000o`3oool0oooo000000D0oooo0P0000070?ooo`006`3oool2000000X0oooo0`00000R0?oo
o`8000002`3oool2000002<0oooo0P00000:0?ooo`800000903oool2000000X0oooo0P00000T0?oo
o`8000002P3oool2000001l0oooo00@0003o0?ooo`3oool00000103oool00`000000oooo0?ooo`06
0?ooo`00o`3ooolA0?ooo`80003o00<0oooo0000003oool00P3oool00`000000oooo0?ooo`060?oo
o`00o`3ooolC0?ooo`030000o`000000oooo0080oooo00<000000?ooo`3oool01P3oool00?l0oooo
503oool00`000?l000000?ooo`030?l000L0oooo003o0?oooaD0oooo0P000?l50?l000D0oooo003o
0?oooaD0oooo0P3o00030000o`80o`001@3oool00?l00000500000020?l00003003o00000?l0003o
0080003o0P3o000300000040oooo00000`3oool000000?ooo`080?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`80o`0000<00?l00000o`00
0?l00P000?l20?l000@0oooo000O0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0
;`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0
:P3oool20?l000800?l00P000?l00`00o`00o`000?l000040?ooo`00o`3ooolE0?ooo`80o`000`00
o`020?l000D0oooo003o0?oooaD0oooo1`3o00050?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0, 0, 0, 0}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-0.24012524415530798`\), {x \[Rule] \(-0.5202689934103257`\
\)}}\), ",", \({"Steps" \[Rule] 5, "Function" \[Rule] 6, 
          "Gradient" \[Rule] 6}\), ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox[ButtonBox["FindMinimumPlot",
    ButtonData:>"FMRPlot",
    ButtonStyle->"Hyperlink"], "MR"],
  " command is defined in the ",
  ButtonBox["Optimization`UnconstrainedProblems`",
    ButtonData:>"UnconstrainedProblems",
    ButtonStyle->"Hyperlink"],
  " package loaded in the initialization for this notebook. It runs ",
  StyleBox["FindMinimum", "MR"],
  ", keeps track of the function and gradient evaluations and steps taken \
during the search (using the ",
  StyleBox["EvaluationMonitor", "MR"],
  " and ",
  StyleBox["StepMonitor", "MR"],
  " options), and shows them superimposed on a plot of the function. Steps \
are indicated with blue lines, function evaluations are shown with green \
points, and gradient evaluations are shown with red points. The minimum found \
is shown with a large black point. From the plot, it is clear that ",
  StyleBox["FindMinimum", "MR"],
  " has found a local minimum point. "
}], "Text"],

Cell[TextData[{
  "This shows the steps taken by ",
  StyleBox["FindMinimum", "MR"],
  " for the function ",
  StyleBox["x Sin[x + 1]", "MR"],
  " starting at x = 2."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[x\ Sin[x\  + \ 1], {x, 2}]\)], "Input",
  CellLabel->"In[3]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.357143 0.190476 0.224639 0.0546787 [
[.21429 .21214 -3 -9 ]
[.21429 .21214 3 0 ]
[.40476 .21214 -3 -9 ]
[.40476 .21214 3 0 ]
[.59524 .21214 -3 -9 ]
[.59524 .21214 3 0 ]
[.78571 .21214 -3 -9 ]
[.78571 .21214 3 0 ]
[.97619 .21214 -3 -9 ]
[.97619 .21214 3 0 ]
[.01131 .00592 -12 -4.5 ]
[.01131 .00592 0 4.5 ]
[.01131 .11528 -12 -4.5 ]
[.01131 .11528 0 4.5 ]
[.01131 .334 -6 -4.5 ]
[.01131 .334 0 4.5 ]
[.01131 .44335 -6 -4.5 ]
[.01131 .44335 0 4.5 ]
[.01131 .55271 -6 -4.5 ]
[.01131 .55271 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .22464 m
.21429 .23089 L
s
[(3)] .21429 .21214 0 1 Mshowa
.40476 .22464 m
.40476 .23089 L
s
[(4)] .40476 .21214 0 1 Mshowa
.59524 .22464 m
.59524 .23089 L
s
[(5)] .59524 .21214 0 1 Mshowa
.78571 .22464 m
.78571 .23089 L
s
[(6)] .78571 .21214 0 1 Mshowa
.97619 .22464 m
.97619 .23089 L
s
[(7)] .97619 .21214 0 1 Mshowa
.125 Mabswid
.0619 .22464 m
.0619 .22839 L
s
.1 .22464 m
.1 .22839 L
s
.1381 .22464 m
.1381 .22839 L
s
.17619 .22464 m
.17619 .22839 L
s
.25238 .22464 m
.25238 .22839 L
s
.29048 .22464 m
.29048 .22839 L
s
.32857 .22464 m
.32857 .22839 L
s
.36667 .22464 m
.36667 .22839 L
s
.44286 .22464 m
.44286 .22839 L
s
.48095 .22464 m
.48095 .22839 L
s
.51905 .22464 m
.51905 .22839 L
s
.55714 .22464 m
.55714 .22839 L
s
.63333 .22464 m
.63333 .22839 L
s
.67143 .22464 m
.67143 .22839 L
s
.70952 .22464 m
.70952 .22839 L
s
.74762 .22464 m
.74762 .22839 L
s
.82381 .22464 m
.82381 .22839 L
s
.8619 .22464 m
.8619 .22839 L
s
.9 .22464 m
.9 .22839 L
s
.9381 .22464 m
.9381 .22839 L
s
.25 Mabswid
0 .22464 m
1 .22464 L
s
.02381 .00592 m
.03006 .00592 L
s
[(-4)] .01131 .00592 1 0 Mshowa
.02381 .11528 m
.03006 .11528 L
s
[(-2)] .01131 .11528 1 0 Mshowa
.02381 .334 m
.03006 .334 L
s
[(2)] .01131 .334 1 0 Mshowa
.02381 .44335 m
.03006 .44335 L
s
[(4)] .01131 .44335 1 0 Mshowa
.02381 .55271 m
.03006 .55271 L
s
[(6)] .01131 .55271 1 0 Mshowa
.125 Mabswid
.02381 .03326 m
.02756 .03326 L
s
.02381 .0606 m
.02756 .0606 L
s
.02381 .08794 m
.02756 .08794 L
s
.02381 .14262 m
.02756 .14262 L
s
.02381 .16996 m
.02756 .16996 L
s
.02381 .1973 m
.02756 .1973 L
s
.02381 .25198 m
.02756 .25198 L
s
.02381 .27932 m
.02756 .27932 L
s
.02381 .30666 m
.02756 .30666 L
s
.02381 .36134 m
.02756 .36134 L
s
.02381 .38867 m
.02756 .38867 L
s
.02381 .41601 m
.02756 .41601 L
s
.02381 .47069 m
.02756 .47069 L
s
.02381 .49803 m
.02756 .49803 L
s
.02381 .52537 m
.02756 .52537 L
s
.02381 .58005 m
.02756 .58005 L
s
.02381 .60739 m
.02756 .60739 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24007 m
.06244 .21727 L
.10458 .1877 L
.14415 .15689 L
.18221 .12609 L
.22272 .09397 L
.26171 .06573 L
.30316 .04079 L
.32392 .03096 L
.34309 .02376 L
.35271 .02089 L
.36173 .01867 L
.37114 .01686 L
.37613 .01612 L
.3815 .0155 L
.38404 .01527 L
.38674 .01506 L
.38929 .01491 L
.3916 .01481 L
.39302 .01477 L
.39433 .01474 L
.39502 .01473 L
.39577 .01472 L
.39655 .01472 L
.39728 .01472 L
.39798 .01472 L
.39863 .01472 L
.39987 .01474 L
.40055 .01475 L
.40119 .01477 L
.40263 .01482 L
.40502 .01492 L
.40726 .01505 L
.41237 .01549 L
.41735 .01607 L
.42272 .0169 L
.43229 .01885 L
.44276 .02172 L
.46386 .02984 L
.48347 .04021 L
.50442 .05426 L
.54592 .09089 L
.5859 .13636 L
.62437 .18805 L
.66529 .24943 L
.70469 .31222 L
.74258 .37331 L
.78292 .43601 L
.82174 .49098 L
.86302 .54032 L
Mistroke
.88365 .56046 L
.90278 .576 L
.9213 .58793 L
.93078 .59278 L
.94103 .59702 L
.94562 .59857 L
.95047 .59998 L
.95496 .60107 L
.95914 .60189 L
.96307 .6025 L
.96509 .60274 L
.96728 .60296 L
.96852 .60306 L
.96967 .60314 L
.97075 .6032 L
.97194 .60325 L
.97301 .60329 L
.974 .60331 L
.97506 .60332 L
.97619 .60332 L
Mfstroke
0 0 0 r
.055 w
.3971 .01471 Mdot
1 0 0 r
.0325 w
.02381 .24007 Mdot
.21429 .1005 Mdot
.97619 .60332 Mdot
.30839 .03812 Mdot
.39272 .01478 Mdot
.41371 .01563 Mdot
.39707 .01471 Mdot
.3971 .01471 Mdot
.3971 .01471 Mdot
0 1 0 r
.02 w
.02381 .24007 Mdot
.21429 .1005 Mdot
.97619 .60332 Mdot
.30839 .03812 Mdot
.39272 .01478 Mdot
.41371 .01563 Mdot
.39707 .01471 Mdot
.3971 .01471 Mdot
.3971 .01471 Mdot
0 0 1 r
.5 Mabswid
.02381 .24007 m
.02381 .24007 L
.39272 .01478 L
.39707 .01471 L
.3971 .01471 L
.3971 .01471 L
s
.015 w
.02381 .24007 Mdot
.02381 .24007 Mdot
.39272 .01478 Mdot
.39707 .01471 Mdot
.3971 .01471 Mdot
.3971 .01471 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`002@3oool300000?l0oooo5@3oool000X0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1O0?ooo`@00000103o00001@000000o`000?l0
003o000000000:80oooo00070?ooo`D000000`3oool3000005l0oooo0P00000<0?l00:40oooo0000
0`3oool000000000000200000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`1N0?ooo`<0000000<0o`00003o00000?l00P000?l00`00o`00o`00003o0002003o0080o`00X@3o
ool000P0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`1N0?ooo`80000000<0o`00
003o00000?l010000?l5003o0080o`00X03oool000T0oooo0P0000040?ooo`030000003oool0oooo
05d0oooo0`0000000`3o00000?l00000o`040000o`D00?l00P3o002P0?ooo`003`3oool00`000000
oooo0?ooo`1H0?ooo`D0000000D0oooo000000000000o`00003o00040000o`H00?l00P3o00030000
09d0oooo000?0?ooo`030000003oool0oooo04/0oooo0`3o00070?ooo`<000001P3oool200000080
003o1@00o`00103o00000?l0003o0000o`020?l000@0oooo0`00002J0?ooo`003`3oool00`000000
oooo0?ooo`190?ooo`L0o`000P3oool3000000X0oooo00<0003o0000003o00002`3o00070?ooo`80
0000V03oool000l0oooo00<000000?ooo`3oool0B@3oool20?l000<00?l00P3o0002000000/0oooo
0P000?l4000000@0o`0000D000000?l0003o0000o`000000000:0?ooo`800000UP3oool000l0oooo
0P0000190?ooo`80o`001@00o`020?l000X0oooo0P000?l30?ooo`/000003@3oool2000009@0oooo
000?0?ooo`030000003oool0oooo04P0oooo0P3o0005003o0080o`002@3oool00`000?l0oooo0?oo
o`040?ooo`T00000403oool200000980oooo000?0?ooo`030000003oool0oooo04P0oooo0P3o0005
003o0080o`001`3oool20000o`T0oooo1@00000D0?ooo`800000T03oool000l0oooo00<000000?oo
o`3oool0B@3oool20?l000<00?l00P3o00060?ooo`80003o9P3oool2000008h0oooo000?0?ooo`03
0000003oool0oooo04L0oooo0P0000070?l000D0oooo00<0003o0?ooo`3oool0:03oool00`000000
oooo0?ooo`2;0?ooo`003`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo0080oooo
0`3o00050?ooo`80003o;03oool2000008/0oooo000?0?ooo`030000003oool0oooo04@0oooo0P00
000;0?ooo`80003o<03oool00`000000oooo0?ooo`280?ooo`003`3oool2000004<0oooo0P00000<
0?ooo`030000o`3oool0oooo0340oooo00<000000?ooo`3oool0Q`3oool000l0oooo00<000000?oo
o`3oool0@03oool2000000`0oooo0P000?le0?ooo`030000003oool0oooo08H0oooo000?0?ooo`03
0000003oool0oooo03l0oooo00<000000?ooo`3oool02P3oool20000ocP0oooo00<000000?ooo`3o
ool0Q@3oool000l0oooo00<000000?ooo`3oool0?@3oool2000000`0oooo00<0003o0?ooo`3oool0
>@3oool00`000000oooo0?ooo`240?ooo`003`3oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo00X0oooo0P000?lm0?ooo`800000Q03oool000l0oooo00<000000?ooo`3oool0>`3oool0
0`000000oooo0?ooo`090?ooo`80003o@@3oool00`000000oooo0?ooo`210?ooo`003`3oool00`00
0000oooo0?ooo`0i0?ooo`8000002`3oool00`000?l0oooo0?ooo`120?ooo`030000003oool0oooo
0800oooo000?0?ooo`030000003oool0oooo0340oooo0`3o00040?ooo`030000003oool0oooo00T0
oooo0P000?m60?ooo`030000003oool0oooo07l0oooo000?0?ooo`800000<03oool70?l000030?oo
o`000000oooo00T0oooo0P000?m90?ooo`030000003oool0oooo07h0oooo000?0?ooo`030000003o
ool0oooo02l0oooo1`3o00000`000000oooo0?ooo`080?ooo`030000o`3oool0oooo04X0oooo00<0
00000?ooo`3oool0O@3oool000l0oooo00<000000?ooo`3oool0;P3oool30?l000<00?l00`3o0008
0?ooo`80003oCP3oool00`000000oooo0?ooo`1l0?ooo`003`3oool00`000000oooo0?ooo`0^0?oo
o`80o`001@00o`020?l000H0oooo0P000?mA0?ooo`030000003oool0oooo07/0oooo000?0?ooo`03
0000003oool0oooo02h0oooo0P3o0005003o0080o`001@3oool00`000?l0oooo0?ooo`1B0?ooo`03
0000003oool0oooo07X0oooo000?0?ooo`030000003oool0oooo02l0oooo00<0o`00003o0000o`00
0`00o`000`3o0000oooo0?ooo`020?ooo`80003oEP3oool00`000000oooo0?ooo`1i0?ooo`001`3o
ool4000000@0oooo00<000000?ooo`3oool0;`3oool20?l000<00?l00P3o00020?ooo`80003oF@3o
ool00`000000oooo0?ooo`1h0?ooo`001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo02h0oooo00<000000?ooo`3oool00`3o00030?ooo`030000o`3oool0oooo05T0oooo00<00000
0?ooo`3oool0N03oool000P0oooo00<000000?ooo`3oool0103oool3000002d0oooo00<000000?oo
o`3oool01@3oool20000oed0oooo00<000000?ooo`3oool0M`3oool000030?ooo`00000000000080
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02/0oooo0P0000060?ooo`80
003oH03oool00`000000oooo0?ooo`1f0?ooo`001`3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo02X0oooo00<000000?ooo`3oool01@3oool00`000?l0oooo0?ooo`1Q0?ooo`03
0000003oool0oooo07D0oooo00080?ooo`8000001@3oool00`000000oooo0?ooo`0Y0?ooo`030000
003oool0oooo00@0oooo0P000?mU0?ooo`030000003oool0oooo07@0oooo000?0?ooo`030000003o
ool0oooo02L0oooo0P0000060?ooo`030000o`3oool0oooo06H0oooo00<000000?ooo`3oool0L`3o
ool000l0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`040?ooo`80003oJP3oool0
0`000000oooo0?ooo`1b0?ooo`003`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
00<0oooo0P000?m]0?ooo`030000003oool0oooo0740oooo000?0?ooo`800000903oool2000000D0
oooo00<0003o0?ooo`3oool0K@3oool00`000000oooo0?ooo`1a0?ooo`003`3oool00`000000oooo
0?ooo`0R0?ooo`030000003oool0oooo00<0oooo0P000?ma0?ooo`030000003oool0oooo0700oooo
000?0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool00P3oool20000og@0oooo00<0
00000?ooo`3oool0K`3oool000l0oooo00<000000?ooo`3oool07`3oool2000000@0oooo00<0003o
0?ooo`3oool0M@3oool00`000000oooo0?ooo`1^0?ooo`003`3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo0080oooo0P000?mh0?ooo`030000003oool0oooo06h0oooo000?0?ooo`03
0000003oool0oooo01d0oooo00@000000?ooo`3oool0oooo0P000?mk0?ooo`030000003oool0oooo
06d0oooo000?0?ooo`030000003oool0oooo01/0oooo0P0000030?ooo`030000o`3oool0oooo07`0
oooo00<000000?ooo`3oool0K03oool000l0oooo00<000000?ooo`3oool06P3oool010000000oooo
0?ooo`3oool20000oh00oooo00<000000?ooo`3oool0J`3oool000l0oooo0P00000J0?ooo`030000
003oool0oooo0080003oPP3oool00`000000oooo0?ooo`1[0?ooo`003`3oool00`000000oooo0?oo
o`0H0?ooo`040000003oool0oooo0000ohD0oooo00<000000?ooo`3oool0JP3oool000l0oooo00<0
00000?ooo`3oool05`3oool010000000oooo0000o`000?n70?ooo`030000003oool0oooo06T0oooo
000?0?ooo`030000003oool0oooo01D0oooo0P0000020000ohX0oooo00<000000?ooo`3oool0J03o
ool000l0oooo00<000000?ooo`3oool0503oool00`000000oooo0000o`0J0?ooo`800000=03oool3
00000340oooo0P0000060?ooo`030000003oool0oooo02T0oooo0`00000d0?ooo`030000003oool0
oooo00D0oooo000?0?ooo`030000003oool0oooo01<0oooo00<000000000o`000?l06P3oool01000
0000oooo0?ooo`00000d0?ooo`030000003oool0oooo02l0oooo00@000000?ooo`3oool000001P3o
ool00`000000oooo0?ooo`0X0?ooo`040000003oool0oooo000003<0oooo00<000000?ooo`3oool0
1@3oool000l0oooo00<000000?ooo`3oool04@3oool00`000000003o0000o`0N0?ooo`030000003o
ool0oooo0300oooo1@00000c0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09`3o
ool010000000oooo0?ooo`00000c0?ooo`030000003oool0oooo00D0oooo000?0?ooo`8000004@3o
ool00`000000003o0?ooo`0P0?ooo`030000003oool0oooo02l0oooo00@000000?ooo`3oool00000
<P3oool2000000P0oooo00<000000?ooo`3oool09`3oool3000003D0oooo00<000000?ooo`3oool0
103oool000l0oooo00<000000?ooo`3oool03`3oool20000oal0oooo00@000000?ooo`3oool00000
<P3oool00`000000oooo0000000b0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`0a0?ooo`040000003oool0oooo000000H0oooo000?0?ooo`030000
003oool0oooo00d0oooo0P000?lR0?ooo`800000=03oool200000380oooo0`0000090?ooo`030000
003oool0oooo02H0oooo0`00000a0?ooo`@000001P3oool000l0oooo00<000000?ooo`3oool0303o
ool00`000?l0oooo0?ooo`2H0?ooo`030000003oool0oooo06@0oooo000?0?ooo`030000003oool0
oooo00X0oooo0P000?nL0?ooo`030000003oool0oooo06<0oooo000?0?ooo`030000003oool0oooo
00P0oooo0P000?l00`000000oooo0?ooo`2L0?ooo`030000003oool0oooo0680oooo000?0?ooo`03
0000003oool0oooo00L0oooo00<0003o0000003oool0W`3oool00`000000oooo0?ooo`1R0?ooo`00
3`3oool00`000000oooo0?ooo`050?ooo`80003o00<000000?ooo`3oool0X03oool00`000000oooo
0?ooo`1Q0?ooo`00203oool6000000<0o`00100000020000ool000002P00000000`0oooo1`3o0000
0`3oool0003o000000040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool000`0oooo1P3o0002
0000oc00oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0
oooo00D0oooo000;0?ooo`<0o`0010000?l20?l00:X0oooo00<000000?ooo`3oool0G`3oool000/0
oooo0P3o00040000o`03003o003o0000o`000:/0oooo00<000000?ooo`3oool0GP3oool000/0oooo
0P3o00040000o`03003o003o0000o`000:`0oooo00<000000?ooo`3oool0G@3oool000`0oooo00@0
o`00003o00000?l0003o0P00o`000`3o0000oooo0?ooo`2[0?ooo`030000003oool0oooo05d0oooo
000<0?ooo`80o`000`00o`020?l00:h0oooo00<000000?ooo`3oool0G03oool000h0oooo0`3o002a
0?ooo`030000003oool0oooo05/0oooo000?0?ooo`030000003oool0oooo0;00oooo00<000000?oo
o`3oool0F`3oool000l0oooo00<000000?ooo`3oool0/@3oool00`000000oooo0?ooo`1J0?ooo`00
3`3oool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo05T0oooo000?0?ooo`030000003o
ool0oooo0;80oooo00<000000?ooo`3oool0F@3oool000l0oooo00<000000?ooo`3oool0/`3oool0
0`000000oooo0?ooo`1H0?ooo`003`3oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo
05L0oooo000?0?ooo`800000]@3oool00`000000oooo0?ooo`1G0?ooo`003`3oool00`000000oooo
0?ooo`2e0?ooo`030000003oool0oooo05H0oooo000?0?ooo`030000003oool0oooo0;D0oooo00<0
00000?ooo`3oool0EP3oool000l0oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`1E
0?ooo`003`3oool00`000000oooo0?ooo`2g0?ooo`030000003oool0oooo05@0oooo000?0?ooo`03
0000003oool0oooo0;L0oooo00<000000?ooo`3oool0E03oool000l0oooo00<000000?ooo`3oool0
^03oool00`000000oooo0?ooo`1C0?ooo`003`3oool00`000000oooo0?ooo`2i0?ooo`030000003o
ool0oooo0580oooo000?0?ooo`800000^P3oool00`000000oooo0?ooo`1B0?ooo`003`3oool00`00
0000oooo0?ooo`2j0?ooo`030000003oool0oooo0540oooo000?0?ooo`030000003oool0oooo0;/0
oooo00<000000?ooo`3oool0D03oool000l0oooo00<000000?ooo`3oool0^`3oool00`000000oooo
0?ooo`1@0?ooo`003`3oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo04l0oooo0007
0?ooo`@00000103oool00`000000oooo0?ooo`2m0?ooo`030000003oool0oooo04h0oooo00070?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0_@3oool00`000000oooo0?ooo`1>0?oo
o`00203oool00`000000oooo0?ooo`040?ooo`<00000_P3oool00`000000oooo0?ooo`1=0?ooo`00
2@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool0
C03oool000L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`2o0?ooo`030000
003oool0oooo04`0oooo00080?ooo`8000001@3oool00`000000oooo0?ooo`300?ooo`030000003o
ool0oooo04/0oooo000?0?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool0B`3oool0
00l0oooo00<000000?ooo`3oool0`@3oool00`000000oooo0?ooo`1:0?ooo`003`3oool00`000000
oooo0?ooo`320?ooo`030000003oool0oooo04T0oooo000?0?ooo`030000003oool0oooo0<80oooo
00<000000?ooo`3oool0B@3oool000l0oooo0P0000340?ooo`030000003oool0oooo04P0oooo000?
0?ooo`030000003oool0oooo0<@0oooo00<000000?ooo`3oool0A`3oool000l0oooo00<000000?oo
o`3oool0a03oool00`000000oooo0?ooo`170?ooo`003`3oool00`000000oooo0?ooo`350?ooo`03
0000003oool0oooo04H0oooo000?0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool0
A@3oool000l0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`150?ooo`003`3oool0
0`000000oooo0?ooo`370?ooo`030000003oool0oooo04@0oooo000?0?ooo`030000003oool0oooo
0<L0oooo00<000000?ooo`3oool0A03oool000l0oooo0P0000390?ooo`030000003oool0oooo04<0
oooo000?0?ooo`030000003oool0oooo0<T0oooo00<000000?ooo`3oool0@P3oool000l0oooo00<0
00000?ooo`3oool0b@3oool00`000000oooo0?ooo`120?ooo`003`3oool00`000000oooo0?ooo`3:
0?ooo`030000003oool0oooo0440oooo000?0?ooo`030000003oool0oooo0<X0oooo00<000000?oo
o`3oool0@@3oool000l0oooo00<000000?ooo`3oool0b`3oool00`000000oooo0?ooo`100?ooo`00
3`3oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo03l0oooo000?0?ooo`800000c@3o
ool00`000000oooo0?ooo`0o0?ooo`003`3oool00`000000oooo0?ooo`3=0?ooo`030000003oool0
oooo03h0oooo000?0?ooo`030000003oool0oooo0<h0oooo00<000000?ooo`3oool0?@3oool000l0
oooo00<000000?ooo`3oool0cP3oool00`000000oooo0?ooo`0m0?ooo`003`3oool00`000000oooo
0?ooo`3?0?ooo`030000003oool0oooo03`0oooo000?0?ooo`030000003oool0oooo0<l0oooo00<0
00000?ooo`3oool0?03oool000T0oooo0`0000030?ooo`030000003oool0oooo0=00oooo00<00000
0?ooo`3oool0>`3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3A0?oo
o`030000003oool0oooo03X0oooo00070?ooo`D000000`3oool300000=40oooo00<000000?ooo`3o
ool0>P3oool000L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3B0?ooo`03
0000003oool0oooo03T0oooo00080?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0
d`3oool00`000000oooo0?ooo`0h0?ooo`002@3oool2000000@0oooo00<000000?ooo`3oool0e03o
ool00`000000oooo0?ooo`0g0?ooo`003`3oool00`000000oooo0?ooo`3D0?ooo`030000003oool0
oooo03L0oooo000?0?ooo`030000003oool0oooo0=D0oooo00<000000?ooo`3oool0=P3oool000l0
oooo00<000000?ooo`3oool0eP3oool00`000000oooo0?ooo`0e0?ooo`003`3oool200000=P0oooo
00<000000?ooo`3oool0=03oool000l0oooo00<000000?ooo`3oool0e`3oool00`000000oooo0?oo
o`0d0?ooo`003`3oool00`000000oooo0?ooo`3H0?ooo`030000003oool0oooo03<0oooo000?0?oo
o`030000003oool0oooo0=T0oooo00<000000?ooo`3oool0<P3oool000l0oooo00<000000?ooo`3o
ool0fP3oool00`000000oooo0?ooo`0a0?ooo`003`3oool00`000000oooo0?ooo`3J0?ooo`030000
003oool0oooo0340oooo000?0?ooo`030000003oool0oooo0=/0oooo00<000000?ooo`3oool0<03o
ool000l0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`0_0?ooo`003`3oool20000
0=h0oooo00<000000?ooo`3oool0;P3oool000l0oooo00<000000?ooo`3oool0g@3oool00`000000
oooo0?ooo`0^0?ooo`003`3oool00`000000oooo0?ooo`3N0?ooo`030000003oool0oooo02d0oooo
000?0?ooo`030000003oool0oooo0=l0oooo00<000000?ooo`3oool0;03oool000l0oooo00<00000
0?ooo`3oool0h03oool00`000000oooo0?ooo`0[0?ooo`003`3oool00`000000oooo0?ooo`3P0?oo
o`030000003oool0oooo02/0oooo000?0?ooo`030000003oool0oooo0>40oooo00<000000?ooo`3o
ool0:P3oool000l0oooo00<000000?ooo`3oool0hP3oool00`000000oooo0?ooo`0Y0?ooo`003`3o
ool200000>@0oooo00<000000?ooo`3oool0:03oool000l0oooo00<000000?ooo`3oool0i03oool0
0`000000oooo0?ooo`0W0?ooo`003`3oool00`000000oooo0?ooo`3T0?ooo`030000003oool0oooo
02L0oooo000?0?ooo`030000003oool0oooo0>D0oooo00<000000?ooo`3oool09P3oool000l0oooo
00<000000?ooo`3oool0iP3oool00`000000oooo0?ooo`0U0?ooo`001`3oool3000000D0oooo00<0
00000?ooo`3oool0i`3oool00`000000oooo0?ooo`0T0?ooo`001`3oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo0>P0oooo00<000000?ooo`3oool08`3oool000L0oooo00@00000
0?ooo`3oool00000103oool300000>T0oooo0P00000S0?ooo`001`3oool3000000D0oooo00<00000
0?ooo`3oool0j`3oool00`000000oooo0?ooo`0P0?ooo`00203oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0>`0oooo00<000000?ooo`3oool07`3oool000P0oooo0`0000040?ooo`03
0000003oool0oooo0>d0oooo00<000000?ooo`3oool07P3oool000l0oooo00<000000?ooo`3oool0
kP3oool00`000000oooo0?ooo`0M0?ooo`003`3oool00`000000oooo0?ooo`3_0?ooo`030000003o
ool0oooo01`0oooo000?0?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3oool06`3oool0
00l0oooo00<000000?ooo`3oool0l@3oool00`000000oooo0?ooo`0J0?ooo`003`3oool200000?<0
oooo0P00000J0?ooo`003`3oool00`000000oooo0?ooo`3d0?ooo`800000603oool000l0oooo00<0
00000?ooo`3oool0mP3oool2000000d0oooo0`3o00060?ooo`003`3oool00`000000oooo0?ooo`3h
0?ooo`8000002@3oool70?l000@0oooo000?0?ooo`030000003oool0oooo0?X0oooo0P0000070?oo
o`L0o`00103oool000l0oooo00<000000?ooo`3oool0o03oool400000080oooo0`3o0003003o00<0
o`000`3oool000l0oooo00<000000?ooo`3oool0o`3oool10?ooo`8000000P3o0005003o0080o`00
0`3oool000l0oooo0P00003o0?ooo`@0oooo0P3o0005003o0080o`000`3oool000l0oooo00<00000
0?ooo`3oool0o`3oool40?ooo`030?l00000o`000?l000<00?l000<0o`000?ooo`3oool00P3oool0
00l0oooo00<000000?ooo`3oool0o`3oool40?ooo`80o`000`00o`020?l000@0oooo000?0?ooo`03
0000003oool0oooo0?l0oooo1P3oool30?l000H0oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {1, -4, 0, 0}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-3.8392228971517346`\), {x \[Rule] 3.959757475231027`}}\), 
        ",", \({"Steps" \[Rule] 4, "Function" \[Rule] 9, 
          "Gradient" \[Rule] 9}\), ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "Starting at 2, ",
  StyleBox["FindMinimum", "MR"],
  "\[CloseCurlyQuote]s search heads to different local minimum, at which the \
function is smaller than at the first minimum found."
}], "Text"],

Cell[TextData[{
  "From these two plots, you might come to the conclusion that if you start \
at a point where the function is sloping downwards, you will always head \
towards the next minimum in that direction. However, this is not always the \
case; the steps ",
  StyleBox["FindMinimum", "MR"],
  " takes are typically determined using the value of the function and its \
derivatives, so if the derivative is quite small, ",
  StyleBox["FindMinimum", "MR"],
  " may think it has to go quite a long way to find a minimum point."
}], "Text"],

Cell[TextData[{
  "This shows the steps taken by ",
  StyleBox["FindMinimum", "MR"],
  " for the function ",
  StyleBox["x Sin[x + 1]", "MR"],
  " starting at x = 7."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[x\ Sin[x\  + \ 1], {x, 7}]\)], "Input",
  CellLabel->"In[4]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.167866 0.0273822 0.320621 0.00738485 [
[.10596 .30812 -6 -9 ]
[.10596 .30812 6 0 ]
[.24287 .30812 -6 -9 ]
[.24287 .30812 6 0 ]
[.37978 .30812 -6 -9 ]
[.37978 .30812 6 0 ]
[.51669 .30812 -6 -9 ]
[.51669 .30812 6 0 ]
[.6536 .30812 -6 -9 ]
[.6536 .30812 6 0 ]
[.79051 .30812 -6 -9 ]
[.79051 .30812 6 0 ]
[.92742 .30812 -6 -9 ]
[.92742 .30812 6 0 ]
[.06607 .02523 -18 -4.5 ]
[.06607 .02523 0 4.5 ]
[.06607 .17292 -18 -4.5 ]
[.06607 .17292 0 4.5 ]
[.06607 .46832 -12 -4.5 ]
[.06607 .46832 0 4.5 ]
[.06607 .61602 -12 -4.5 ]
[.06607 .61602 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10596 .32062 m
.10596 .32687 L
s
[(10)] .10596 .30812 0 1 Mshowa
.24287 .32062 m
.24287 .32687 L
s
[(15)] .24287 .30812 0 1 Mshowa
.37978 .32062 m
.37978 .32687 L
s
[(20)] .37978 .30812 0 1 Mshowa
.51669 .32062 m
.51669 .32687 L
s
[(25)] .51669 .30812 0 1 Mshowa
.6536 .32062 m
.6536 .32687 L
s
[(30)] .6536 .30812 0 1 Mshowa
.79051 .32062 m
.79051 .32687 L
s
[(35)] .79051 .30812 0 1 Mshowa
.92742 .32062 m
.92742 .32687 L
s
[(40)] .92742 .30812 0 1 Mshowa
.125 Mabswid
.13334 .32062 m
.13334 .32437 L
s
.16072 .32062 m
.16072 .32437 L
s
.1881 .32062 m
.1881 .32437 L
s
.21549 .32062 m
.21549 .32437 L
s
.27025 .32062 m
.27025 .32437 L
s
.29763 .32062 m
.29763 .32437 L
s
.32501 .32062 m
.32501 .32437 L
s
.3524 .32062 m
.3524 .32437 L
s
.40716 .32062 m
.40716 .32437 L
s
.43454 .32062 m
.43454 .32437 L
s
.46193 .32062 m
.46193 .32437 L
s
.48931 .32062 m
.48931 .32437 L
s
.54407 .32062 m
.54407 .32437 L
s
.57145 .32062 m
.57145 .32437 L
s
.59884 .32062 m
.59884 .32437 L
s
.62622 .32062 m
.62622 .32437 L
s
.68098 .32062 m
.68098 .32437 L
s
.70837 .32062 m
.70837 .32437 L
s
.73575 .32062 m
.73575 .32437 L
s
.76313 .32062 m
.76313 .32437 L
s
.81789 .32062 m
.81789 .32437 L
s
.84528 .32062 m
.84528 .32437 L
s
.87266 .32062 m
.87266 .32437 L
s
.90004 .32062 m
.90004 .32437 L
s
.05119 .32062 m
.05119 .32437 L
s
.02381 .32062 m
.02381 .32437 L
s
.95481 .32062 m
.95481 .32437 L
s
.98219 .32062 m
.98219 .32437 L
s
.25 Mabswid
0 .32062 m
1 .32062 L
s
.07857 .02523 m
.08482 .02523 L
s
[(-40)] .06607 .02523 1 0 Mshowa
.07857 .17292 m
.08482 .17292 L
s
[(-20)] .06607 .17292 1 0 Mshowa
.07857 .46832 m
.08482 .46832 L
s
[(20)] .06607 .46832 1 0 Mshowa
.07857 .61602 m
.08482 .61602 L
s
[(40)] .06607 .61602 1 0 Mshowa
.125 Mabswid
.07857 .06215 m
.08232 .06215 L
s
.07857 .09908 m
.08232 .09908 L
s
.07857 .136 m
.08232 .136 L
s
.07857 .20985 m
.08232 .20985 L
s
.07857 .24677 m
.08232 .24677 L
s
.07857 .2837 m
.08232 .2837 L
s
.07857 .35755 m
.08232 .35755 L
s
.07857 .39447 m
.08232 .39447 L
s
.07857 .43139 m
.08232 .43139 L
s
.07857 .50524 m
.08232 .50524 L
s
.07857 .54217 m
.08232 .54217 L
s
.07857 .57909 m
.08232 .57909 L
s
.25 Mabswid
.07857 0 m
.07857 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .37177 m
.06244 .32148 L
.08255 .27606 L
.08806 .26563 L
.09396 .25655 L
.09682 .25308 L
.09952 .25042 L
.10195 .24859 L
.10332 .24779 L
.10458 .24722 L
.10577 .24682 L
.10685 .24658 L
.10811 .24645 L
.1093 .24647 L
.1104 .24661 L
.11141 .24686 L
.11253 .24725 L
.11372 .24781 L
.11503 .24858 L
.11644 .24962 L
.119 .25203 L
.12379 .25827 L
.12895 .26743 L
.13439 .27956 L
.14415 .30626 L
.16401 .3677 L
.17269 .39086 L
.17726 .40079 L
.18212 .40911 L
.1846 .41236 L
.18591 .41379 L
.18733 .41511 L
.18862 .41609 L
.18981 .41682 L
.19095 .41734 L
.19214 .41771 L
.19328 .41789 L
.19449 .4179 L
.19563 .41773 L
.19667 .41742 L
.1979 .41688 L
.19923 .41606 L
.20163 .41399 L
.20415 .41101 L
.20692 .40679 L
.21251 .39538 L
.22255 .36642 L
.24363 .28574 L
.25362 .24872 L
.26289 .22144 L
Mistroke
.2675 .21154 L
.27008 .20727 L
.27242 .20424 L
.27367 .20295 L
.27499 .20185 L
.27568 .20139 L
.27644 .20096 L
.27713 .20065 L
.27777 .20044 L
.27904 .2002 L
.2802 .20021 L
.28084 .20031 L
.28154 .2005 L
.2828 .20104 L
.28397 .20177 L
.28507 .20265 L
.28757 .2054 L
.29001 .20905 L
.29263 .21401 L
.29737 .22561 L
.30171 .23898 L
.32067 .31956 L
.33153 .37164 L
.34139 .41408 L
.34624 .43142 L
.3515 .44656 L
.35391 .45208 L
.35647 .45684 L
.35864 .46 L
.35979 .46132 L
.36104 .46248 L
.36177 .46302 L
.36244 .46344 L
.36309 .46375 L
.36377 .464 L
.36496 .46422 L
.36627 .46414 L
.36699 .46396 L
.36766 .4637 L
.36839 .46331 L
.36916 .4628 L
.37045 .46167 L
.37187 .46007 L
.37441 .45624 L
.37712 .45082 L
.382 .4377 L
.38732 .41887 L
.39223 .39783 L
.40332 .3408 L
.41373 .28203 L
Mistroke
.42347 .23 L
.4325 .19043 L
.43757 .1737 L
.43981 .16779 L
.44221 .16259 L
.44358 .16013 L
.44483 .15824 L
.4461 .15666 L
.44727 .15551 L
.44792 .155 L
.44863 .15454 L
.44935 .1542 L
.45011 .15396 L
.45078 .15386 L
.45149 .15386 L
.45279 .15414 L
.45408 .15481 L
.45481 .15535 L
.45549 .15596 L
.4567 .1573 L
.45804 .15917 L
.46037 .16335 L
.46284 .16907 L
.46776 .18427 L
.47294 .20531 L
.4822 .25359 L
.50306 .38597 L
.51262 .44142 L
.51786 .46665 L
.52282 .48586 L
.52744 .49915 L
.53004 .50448 L
.53128 .50644 L
.53245 .50794 L
.53342 .50895 L
.53447 .50976 L
.53563 .51034 L
.53669 .51057 L
.5378 .5105 L
.539 .51008 L
.54014 .50934 L
.54119 .50837 L
.54248 .50678 L
.54385 .50465 L
.54629 .49967 L
.54892 .49268 L
.55179 .48313 L
.56177 .43625 L
.57141 .37497 L
.58039 .31013 L
Mistroke
.58946 .24424 L
.59908 .18199 L
.6041 .15526 L
.60676 .14314 L
.60963 .1319 L
.61225 .12335 L
.61466 .11707 L
.61581 .1146 L
.61707 .11231 L
.61818 .11067 L
.61937 .10927 L
.62012 .10859 L
.62081 .10811 L
.62148 .10778 L
.62217 .10756 L
.62338 .10751 L
.62407 .10766 L
.62471 .10793 L
.62545 .10839 L
.62615 .10896 L
.62746 .11042 L
.62888 .11253 L
.63041 .11546 L
.63299 .12188 L
.63574 .13069 L
.64067 .15141 L
.65024 .20742 L
.6608 .28659 L
.67102 .37 L
.68177 .4524 L
.69095 .50876 L
.69346 .52094 L
.69615 .53216 L
.6985 .54036 L
.701 .54732 L
.70223 .5501 L
.7036 .55261 L
.70484 .55441 L
.70599 .55566 L
.70669 .55622 L
.70736 .5566 L
.70861 .55694 L
.7093 .55692 L
.70995 .55677 L
.71066 .55644 L
.71142 .55592 L
.71269 .55463 L
.71408 .55265 L
.71538 .55023 L
.71658 .54755 L
Mistroke
.72126 .53287 L
.72553 .51387 L
.73021 .48741 L
.73967 .41914 L
.76085 .2326 L
.77087 .15271 L
.77528 .1236 L
.78013 .09715 L
.78479 .07818 L
.78733 .07066 L
.78972 .06554 L
.791 .0636 L
.7917 .06277 L
.79234 .06215 L
.79349 .0614 L
.79474 .0611 L
.79545 .06117 L
.79611 .0614 L
.79736 .06223 L
.79805 .06293 L
.7987 .06373 L
.80015 .06605 L
.80241 .07112 L
.80453 .07743 L
.80935 .09727 L
.81404 .12347 L
.81908 .15833 L
.83886 .33869 L
.8493 .43939 L
.85502 .48905 L
.8604 .52954 L
.86552 .56098 L
.87022 .58272 L
.87275 .59137 L
.87405 .5949 L
.87543 .598 L
.87682 .60042 L
.87812 .60202 L
.87891 .60269 L
.87966 .60311 L
.88033 .6033 L
.88106 .60332 L
.88225 .60292 L
.88336 .60206 L
.88458 .60058 L
.88589 .59837 L
.88726 .59536 L
.88857 .59186 L
.89101 .58361 L
.89541 .56345 L
Mistroke
.9002 .53413 L
.91052 .4492 L
.91988 .35464 L
.9308 .23796 L
.94085 .13972 L
.94911 .07537 L
.95327 .05073 L
.95561 .03948 L
.95783 .03068 L
.96023 .02329 L
.96129 .02073 L
.96241 .01851 L
.96364 .01667 L
.96477 .0155 L
.96598 .01483 L
.96668 .01472 L
.96733 .01479 L
.96841 .01529 L
.96955 .01634 L
.97053 .01765 L
.97159 .01954 L
.97397 .0254 L
.97619 .0329 L
Mfstroke
0 0 0 r
.055 w
.96673 .01471 Mdot
1 0 0 r
.0325 w
.02381 .37177 Mdot
.0266 .37146 Mdot
.03777 .36457 Mdot
.08246 .27625 Mdot
.26121 .22571 Mdot
.97619 .0329 Mdot
.55343 .47688 Mdot
.83795 .32964 Mdot
.96397 .01627 Mdot
.96675 .01471 Mdot
.53595 .51044 Mdot
.96637 .01474 Mdot
.96673 .01471 Mdot
.96673 .01471 Mdot
0 1 0 r
.02 w
.02381 .37177 Mdot
.0266 .37146 Mdot
.03777 .36457 Mdot
.08246 .27625 Mdot
.26121 .22571 Mdot
.97619 .0329 Mdot
.55343 .47688 Mdot
.83795 .32964 Mdot
.96397 .01627 Mdot
.96675 .01471 Mdot
.53595 .51044 Mdot
.96637 .01474 Mdot
.96673 .01471 Mdot
.96673 .01471 Mdot
0 0 1 r
.5 Mabswid
.02381 .37177 m
.02381 .37177 L
.96675 .01471 L
.96673 .01471 L
.96673 .01471 L
s
.015 w
.02381 .37177 Mdot
.02381 .37177 Mdot
.96675 .01471 Mdot
.96673 .01471 Mdot
.96673 .01471 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o6@3oool0
0`000000oooo0?ooo`3_0?ooo`D00000103o0004000000P0oooo000I0?ooo`030000003oool0oooo
0>l0oooo0`0000080?l000800000203oool001T0oooo00<000000?ooo`3oool0kP3oool400000080
o`0000<00?l00000o`000?l00`3o0003000000L0oooo000I0?ooo`030000003oool0oooo0>h0oooo
0`0000020?l00003003o00000?l0003o0080003o0`3o0002000000L0oooo000I0?ooo`030000003o
ool0oooo0>h0oooo0`0000020?l00003003o00000?l0003o0080003o0`3o0002000000L0oooo000=
0?ooo`<000000P3oool2000000D0oooo00<000000?ooo`3oool0kP3oool300000080o`0010000?l0
1000o`00o`000?l0003o0002000000L0oooo000>0?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`3^0?ooo`8000000`000?l0103o00000?l0003o
0000o`050?l000030000003oool0oooo00D0oooo000;0?ooo`D0000000D0oooo0000003oool0oooo
000000040?ooo`<00000k@3oool30000o`8000001@3o0003003o0080o`00203oool000D0oooo1000
00020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`3[0?ooo`80003o0P3oool500000080o`001@00o`020?l000L0oooo000<0?ooo`030000
003oool000000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3X0?ooo`<0
003o1@3oool400000080o`001@00o`020?l000L0oooo000=0?ooo`8000000`3oool2000000D0oooo
00<000000?ooo`3oool0i@3oool30000o`T0oooo0`0000020?l000D00?l00P3o00070?ooo`006@3o
ool00`000000oooo0?ooo`3S0?ooo`80003o3P3oool200000080o`000`00o`020?l000P0oooo000I
0?ooo`030000003oool0oooo0>00oooo0`000?l@0?ooo`030000003oool0o`0000H0o`00203oool0
01T0oooo00<000000?ooo`3oool0g@3oool30000oa80oooo00<000000?ooo`3oool00P3oool30?l0
00X0oooo000I0?ooo`030000003oool0oooo0=/0oooo0P000?lE0?ooo`030000003oool0oooo00l0
oooo000I0?ooo`030000003oool0oooo0=P0oooo0`000?lG0?ooo`030000003oool0oooo00l0oooo
000I0?ooo`030000003oool0oooo0=H0oooo0P000?lJ0?ooo`030000003oool0oooo00l0oooo000I
0?ooo`800000a@3oool4000000/0oooo0`000?lL0?ooo`030000003oool0oooo00l0oooo000I0?oo
o`030000003oool0oooo0<@0oooo00@000000?ooo`3oool00000203oool30000oah0oooo00<00000
0?ooo`3oool0403oool001T0oooo00<000000?ooo`3oool0``3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo0P000?lQ0?ooo`030000003oool0oooo0100oooo000I0?ooo`03
0000003oool0oooo0<<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030000ob<0
oooo00<000000?ooo`3oool0403oool001T0oooo00<000000?ooo`3oool0``3oool00`000000oooo
0?ooo`020?ooo`<0003o9P3oool00`000000oooo0?ooo`0@0?ooo`006@3oool00`000000oooo0?oo
o`330?ooo`030000003oool0oooo0080003o00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0@0?ooo`006@3oool00`000000oooo0?ooo`320?ooo`04000000000?l0003o0000o`<0oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0@0?ooo`006@3oool00`000000oooo0?ooo`30
0?ooo`<0003o1P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0140oooo000I0?oo
o`030000003oool0oooo0;h0oooo0P000?l20?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`0A0?ooo`006@3oool00`000000oooo0?ooo`2k0?ooo`<0
003o0`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool04@3oool001T0oooo0P00002i0?ooo`<0003o1P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool04@3oool001T0oooo00<000000?ooo`3oool0]P3o
ool20000o`T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0S0?ooo`030000003o
ool0oooo0140oooo000I0?ooo`030000003oool0oooo0;<0oooo0`000?l;0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0A0?ooo`006@3oool00`00
0000oooo0?ooo`2D0?ooo`@000006@3oool20000o`h0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0R0?ooo`030000003oool0oooo0180oooo000I0?ooo`030000003oool0oooo09@0
oooo00@000000?ooo`3oool000005P3oool30000o`l0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`0Q0?ooo`030000003oool0oooo0180oooo000I0?ooo`030000003oool0oooo09<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@0?ooo`<0003o4P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool04P3oool001T0oooo
00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo
0P000?lE0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`0B0?ooo`006@3oool00`000000oooo0?ooo`2B0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool02`3oool30000oaL0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo0180oooo000I0?ooo`030000003oool0oooo0980oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`<0003o6P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool04P3oool001T0oooo00<000000?oo
o`3oool0TP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo0P000?lM0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0C0?oo
o`006@3oool00`000000oooo0?ooo`2B0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00P3oool30000oal0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo01<0oooo000I0?ooo`800000TP3oool00`000000oooo0?ooo`050?ooo`030000
003oool0003o0080003o8@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool04`3oool001T0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?oo
o`050?ooo`80003o903oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool04`3oool001T0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`02
0?ooo`<0003o00<0oooo0000003oool08`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool04`3oool001T0oooo00<000000?ooo`3oool0T@3oool00`00
0000oooo0?ooo`020000o`@0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool04`3oool001T0oooo00<000000?ooo`3o
ool0T03oool010000000003o0000o`000?l60?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01<0oooo000I0?ooo`03
0000003oool0oooo06@0oooo1000000V0?ooo`<0003o2@3oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0C0?ooo`00
6@3oool00`000000oooo0?ooo`1S0?ooo`8000000P3oool00`000000oooo0?ooo`0R0?ooo`80003o
0P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01<0oooo000I0?ooo`030000003o
ool0oooo06<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0N0?ooo`<0003o103o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01<0oooo000;0?ooo`@000000`3oool2
000000D0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01/0oooo0`000?l70?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0503oool0
00/0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0680oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0H0?ooo`80003o2@3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01@0oooo000<0?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool00000103oool300000680oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0E0?ooo`<0003o2`3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo01@0oooo00050?ooo`@00000103oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`1R0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool04P3oool30000o`h0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0D
0?ooo`002`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool0H@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00l0oooo0P00
0?lA0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0503oool000`0oooo0P000004
0?ooo`8000001@3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0303oool30000oa<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0D
0?ooo`006@3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool02@3oool30000oaH0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0O0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0D0?oo
o`006@3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01`3oool20000oaT0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0D0?ooo`00
6@3oool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
103oool30000oaX0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0N0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0D0?ooo`006@3o
ool00`000000oooo0?ooo`1P0?ooo`030000003oool0oooo00P0oooo00@000000?ooo`3oool0oooo
0P000?lM0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0503oool001T0oooo00<0
00000?ooo`3oool0=03oool4000002L0oooo00<000000?ooo`3oool02@3oool010000000003o0000
o`000?lO0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0503oool001T0oooo00<0
00000?ooo`3oool0<`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool01`3oool30000ob80oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0D0?ooo`006@3oool2000003@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo00D0oooo0P000?l20?ooo`030000003oool0oooo0200oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0D0?ooo`006@3oool00`000000oooo0?ooo`0_0?oo
o`<0o`0000<000000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
0080oooo0`000?l40?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`0D0?ooo`006@3oool00`000000oooo0?ooo`0]0?ooo`L0o`001@3oool00`000000
oooo0?ooo`0S0?ooo`030000003oool0003o0080003o203oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool05@3oool001T0oooo00<000000?ooo`3oool0
;@3oool20?l000<00?l00P3o00050?ooo`030000003oool0oooo02<0oooo0P000?l;0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0E0?ooo`006@3o
ool00`000000oooo0?ooo`0/0?ooo`80o`001@00o`020?l000D0oooo00<000000?ooo`3oool07`3o
ool30000o`d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo01D0oooo000I0?ooo`030000003oool0oooo02`0oooo0P3o0005003o0080o`001@3oool0
0`000000oooo0?ooo`0L0?ooo`<0003o0P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo01h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0E0?ooo`006@3oool00`00
0000oooo0?ooo`0/0?ooo`80o`001@00o`020?l000D0oooo00<000000?ooo`3oool06P3oool20000
o`D0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool05@3oool001T0oooo00<000000?ooo`3oool0;@3oool20?l000<0
0?l00P3o00070?ooo`030000003oool0oooo01H0oooo0`000?l70?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01D0
oooo000I0?ooo`030000003oool0oooo02d0oooo1`3o00070?ooo`030000003oool0oooo01@0oooo
0P000?l:0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo01D0oooo000I0?ooo`030000003oool0oooo02l0oooo0`3o
00090?ooo`030000003oool0oooo0140oooo0`000?l;0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0703oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01D0oooo000I
0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0=
0?ooo`<0003o3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0E0?ooo`006@3oool2000000D0oooo1@00000U0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3oool20000oa40oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool06`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool05@3oool001T0oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<000000?ooo`3o
ool08`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo0`000?lC0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo01D0oooo000I0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool30000oaH0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool05@3oool001T0oooo00D000000?ooo`3oool0oooo000000080?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`020?ooo`80
003o603oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0F0?ooo`006@3oool30?l000030000003oool0oooo00L0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0=0?ooo`030000003oool0003o0080003o
6P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0F0?ooo`005`3oool70?l000T0oooo00<000000?ooo`3oool07`3o
ool00`000000oooo0?ooo`0<0?ooo`<0003o7@3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`005`3oool2
0?l000<00?l00P3o00090?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02`3oool2
0000o`030?ooo`000000oooo01d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05P3oool001H0oooo0P3o0005003o
0080o`002@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00P0oooo0`000?l40?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool05P3oool001H0oooo0P3o0005003o0080
o`002@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00D0oooo0`000?l70?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool05P3oool001H0oooo0P3o0005003o0080o`00
0P0000020?ooo`800000103oool00`000000oooo0?ooo`0F0?ooo`D0000000@0oooo000000000000
00000`3oool20000o`X0oooo00<000000?ooo`3oool02`3oool4000000<0oooo0P0000060?ooo`03
0000003oool0oooo0140oooo00@000000?ooo`3oool0oooo100000030?ooo`8000003`3oool00`00
0000oooo0?ooo`0<0?ooo`800000103oool2000001P0oooo00<000000?ooo`3oool00`3oool20000
00@0oooo0P0000080?ooo`030000003oool0oooo01D0oooo100000000`3oool000000000000E0?oo
o`005`3oool20?l000<00?l00P3o00001@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo0000000J0?ooo`030000003oool0oooo008000000P3oool30000o``0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool04@3oool01@000000oooo0?ooo`3oool0000000D0oooo00@000000?ooo`3oool0
00003P3oool00`000000oooo0?ooo`0;0?ooo`040000003oool0oooo00000080oooo0P0000000`3o
ool000000?ooo`0F0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000070?ooo`030000003oool0oooo01H0oooo00@000000?ooo`0000000000
0P3oool00`000000oooo0?ooo`0B0?ooo`005`3oool70?l000050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01L0oooo00D000000?ooo`3oool0
00000?ooo`020000o`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0=0?ooo`040000003oool0oooo0?ooo`80000000<0oooo0000003oool05P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0C0?ooo`L000000P3oool00`000000oooo0?ooo`0B0?ooo`00603oool01000
0000o`000?l0003o00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo01L0oooo00<000000?ooo`000?l00P000?l200000100oooo00<0
00000?ooo`3oool0303oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0P3oool2000000l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`02000000030?oo
o`000000oooo01H0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool2000000P0
oooo00<000000?ooo`3oool04`3oool01@000000oooo0?ooo`000000oooo008000000P3oool00`00
0000oooo0?ooo`0B0?ooo`00603oool2000000@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool05P3oool30000o`040000003oool0oooo
00000140oooo00<000000?ooo`3oool02P3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool04`3oool010000000oooo0?ooo`0000020?ooo`05
0000003oool0oooo0?ooo`0000003`3oool00`000000oooo0?ooo`0<0?ooo`040000003oool0oooo
00000080oooo0P0000000`3oool000000?ooo`0F0?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01<0oooo00@0
00000?ooo`000000oooo0P0000020?ooo`030000003oool0oooo0180oooo000H0?ooo`8000000`3o
ool2000000@0oooo0P0000050?ooo`030000003oool0oooo01@0oooo0P000?l2000000040?ooo`00
0000oooo0?ooo`<000003`3oool00`000000oooo0?ooo`0;0?ooo`800000103oool2000000D0oooo
00<000000?ooo`3oool04`3oool010000000oooo0?ooo`3oool2000000@0oooo0`00000=0?ooo`03
0000003oool0oooo00d0oooo0P0000040?ooo`800000603oool00`000000oooo0?ooo`030?ooo`80
0000103oool3000000P0oooo00<000000?ooo`3oool0503oool300000080oooo0P00000E0?ooo`00
5`3oool00`000000oooo0000000A0?ooo`030000003oool0oooo0100oooo0`000?l50?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`005`3o
ool00`000000oooo0000000A0?ooo`030000003oool0oooo00d0oooo0`000?l80?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`005`3oool0
0`000000oooo0000000A0?ooo`030000003oool0oooo00/0oooo0P000?l:0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`005P3oool01000
0000oooo0?ooo`00000B0?ooo`030000003oool0oooo00L0oooo0`000?l<0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`005P3oool01000
0000oooo0?ooo`00000B0?ooo`030000003oool0oooo00@0oooo0`000?l?0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo01D0oooo0`3o000F0?ooo`030000003oool0oooo01L0oooo00030?ooobh000000P000?nh0000
00L0o`00:P0000040?ooo`002P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00P3oool010000000003o0000o`000?l70?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool2000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`8000001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool010000000oooo0?ooo`3o0003003o00<0o`001@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo0P0000060?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01`3oool001@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo0P000?lF0?ooo`040000003oool0oooo000001D0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0180oooo00@000000?oo
o`3oool000005`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0o`00
003o0000o`000`00o`030?l001<0oooo0P00000H0?ooo`004`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00d0oooo0`000?l00`3oool000000?ooo`0E0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
0180oooo00<0o`00003o0000o`000`00o`030?l001<0oooo00<000000?ooo`3oool05`3oool001<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`<0003o1@3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo0180oooo00<0o`00003o0000o`000`00o`030?l001<0
oooo00<000000?ooo`3oool05`3oool00180oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`080?ooo`80003o203oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01<0oooo
00@0o`00003o0000o`000?l00`3o000C0?ooo`030000003oool0oooo01P0oooo000A0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool30000o`/0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0C0?ooo`L0o`004`3oool00`000000oooo0?ooo`0H0?ooo`00403o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo0`000?l>0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool05P3oool30?l001D0oooo00<000000?ooo`3oool0603o
ool000l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020000oa40oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool0603oool000d0oooo0`3o00090?ooo`<0003o503oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0H0?oo
o`002`3oool70?l000@0oooo0`000?l00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01P0
oooo00090?ooo`<0o`000`00o`030?l00080oooo0P000?l30?ooo`8000005@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0H0?ooo`001`3oool40?l000D00?l000@0o`000000o`000?l0003o1@3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo01P0oooo00070?ooo`040?l00000o`00003o0000o`<00?l0
0`000?l20?l000H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0H0?ooo`001P3o
ool00`3o00000?l00000o`050000o`800?l00`3o00060?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0603oool000H0oooo00<0o`00003o00000?l00`000?l3003o00<0o`001`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01T0oooo00060?ooo`030?l00000o`000?l0
0080003o0P00o`050?l000L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0I0?oo
o`001`3oool00`3o00000?l0003o0002003o00@0o`002@3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo01T0oooo00070?ooo`L0o`002`3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo01T0oooo00090?ooo`<0o`003@3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo01T0oooo000I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0703oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool0
01T0oooo0P00000I0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo01T0oooo000I0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool06@3oool001T0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0J0?ooo`006@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo000I
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool06P3oool001T0oooo00<000000?oo
o`3oool06`3oool010000000oooo0?ooo`3oool2000002H0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0J0?ooo`006@3oool00`000000oooo0?ooo`0K0?ooo`D000009`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0oooo000I0?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01X0
oooo000I0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0J0?ooo`006@3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0803oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool06P3oool001T0oooo0P0000190?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool06P3oool001T0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01/0oooo000I0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0K0?ooo`006@3oool00`000000oooo0?ooo`190?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool001T0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01/0oooo000I0?ooo`030000003oool0
oooo04T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`006@3oool00`00
0000oooo0?ooo`1:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06`3oool001T0
oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01/0
oooo000I0?ooo`030000003oool0oooo04/0oooo00D000000?ooo`3oool0oooo0000000X0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`00
2`3oool4000000<0oooo0P0000050?ooo`030000003oool0oooo04`0oooo1000000X0?ooo`030000
003oool0oooo00H0oooo0`3o000R0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01`0oooo000;0?ooo`030000003o
ool0oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`1=0?ooo`030000
003oool0oooo02P0oooo00<000000?ooo`3oool0103oool70?l00200oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
703oool000`0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`<00000
N03oool00`000000oooo0?ooo`040?ooo`80o`000`00o`020?l00240oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
703oool000d0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`030?ooo`80o`001@00o`020?l00200oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0703oool000/0oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool00`3oool20?l000D0
0?l00P3o000P0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo01`0oooo000<0?ooo`800000103oool2000000D0oooo
00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`020?ooo`80o`001@00o`020?l00200oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0703oool001T0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?oo
o`030?ooo`80o`000`00o`020?l00240oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0703oool001T0oooo00<00000
0?ooo`3oool0N@3oool00`000000oooo0?ooo`030?ooo`L0o`008@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0L
0?ooo`006@3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo00@0oooo0`3o000S0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo01d0oooo000I0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3o
00000P3o00000`3oool000000?ooo`0U0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo000I0?ooo`030000
003oool0oooo07X0oooo1`3o000W0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
803oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01d0oooo000I0?ooo`030000003o
ool0oooo07X0oooo1`3o000W0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool08P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01d0oooo000I0?ooo`800000NP3oool3
0?l000<00?l00`3o000V0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool08P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01d0oooo000I0?ooo`030000003oool0oooo
07T0oooo0P3o0005003o0080o`009P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
0280oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0M0?ooo`006@3oool00`000000
oooo0?ooo`1i0?ooo`80o`001@00o`020?l002H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool07@3oool001T0oooo
00<000000?ooo`3oool0NP3oool00`3o00000?l0003o0003003o00030?l0003oool0oooo02H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool07@3oool001T0oooo00<000000?ooo`3oool0NP3oool20?l000<00?l00P3o
000X0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo01h0oooo000I0?ooo`030000003oool0oooo07`0oooo0`3o000Z
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo01h0oooo000I0?ooo`030000003oool0oooo0:T0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool07P3oool001T0oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0N0?ooo`00
6@3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
903oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01h0oooo000I0?ooo`030000003o
ool0oooo0:X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool07P3oool001T0oooo0P00002/0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo01h0oooo000I0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07P3oool001T0
oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0O0?ooo`006@3oool00`000000oooo
0?ooo`2/0?ooo`040000003oool0oooo000002T0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0O0?ooo`006@3oool00`000000oooo0?ooo`2/0?ooo`@00000:@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01l0oooo000I0?ooo`030000003oool0oooo0=T0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`0O0?ooo`006@3oool00`000000oooo0?ooo`3I
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool07`3oool001T0oooo00<000000?oo
o`3oool0f@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo01l0oooo000I0?ooo`03
0000003oool0oooo0=X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0P0?ooo`00
6@3oool00`000000oooo0?ooo`3J0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
803oool001T0oooo00<000000?ooo`3oool0fP3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0200oooo000I0?ooo`800000g03oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0240oooo000I0?ooo`030000003oool0oooo0=/0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0Q0?ooo`006@3oool00`000000oooo0?ooo`3K0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool08@3oool001T0oooo00<000000?ooo`3oool0f`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0240oooo000I0?ooo`030000003oool0oooo0=`0oooo00@0
00000?ooo`3oool00000903oool001T0oooo00<000000?ooo`3oool0g03oool010000000oooo0?oo
o`00000T0?ooo`006@3oool00`000000oooo0?ooo`3L0?ooo`@00000903oool001T0oooo00<00000
0?ooo`3oool0o`3oool50?ooo`003@3oool300000080oooo0P0000050?ooo`030000003oool0oooo
0?l0oooo1@3oool000h0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0?l0oooo1@3oool000/0oooo1@0000001@3oool000000?ooo`3oool00000
00@0oooo0`00003o0?ooo`D0oooo000;0?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`3o0?ooo`D0oooo000<0?ooo`030000003oool00000
0080oooo00@000000?ooo`3oool00000o`3oool<0?ooo`003@3oool2000000<0oooo0P00003o0?oo
o`d0oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {5, -43, 0, 0}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-41.42356831780811`\), {x \[Rule] 41.43562995874454`}}\), 
        ",", \({"Steps" \[Rule] 3, "Function" \[Rule] 14, 
          "Gradient" \[Rule] 14}\), ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "When starting at x = 7, which is near to local maximum, the first step is \
quite large and so ",
  StyleBox["FindMinimum", "MR"],
  " returns a completely different local minimum",
  ". "
}], "Text"],

Cell[TextData[{
  "All of these commands have \[OpenCurlyDoubleQuote]find\
\[CloseCurlyDoubleQuote] in their name because, in general, their design is \
to search to find any point where the desired condition is satisfied. The \
point found may not be the only one (in the case of roots) or even the best \
one (in the case of fits, minima or maxima), or, as you have seen, not even \
the closest one to the starting condition. In other words, the goal is to \
find any point at which there is a root or a local maximum or minimum. In \
contrast, the function ",
  ButtonBox["NMinimize",
    ButtonStyle->"RefGuideLink"],
  " tries harder to find the global minimum for the function, but ",
  StyleBox["NMinimize", "MR"],
  " is also generally given constraints to bound the problem domain. However, \
there is a price to pay for this generality, which is that ",
  StyleBox["NMinimize", "MR"],
  " has to do much more work and, in fact, may call one of the \
\[OpenCurlyDoubleQuote]",
  StyleBox["Find", "MR"],
  "\[CloseCurlyDoubleQuote] functions to polish a result at the end of its \
process, so it generally takes much more time than the \
\[OpenCurlyDoubleQuote]",
  StyleBox["Find", "MR"],
  "\[CloseCurlyDoubleQuote] functions."
}], "Text"],

Cell["\<\
In two dimensions, the minimization problem is more complicated \
because both a step direction and step length need to be determined.\
\>", \
"Text"],

Cell[TextData[{
  "This shows the steps taken by ",
  StyleBox["FindMinimum", "MR"],
  " to find a local minimum of the function ",
  Cell[BoxData[
      \(TraditionalForm\`cos(x\^2 - \ 3  y)\  + \ sin(x\^2 + y\^2)\)]],
  "starting at the point {x,y} = {1,1}."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[
      Cos[x^2\  - \ 3\ y]\  + \ 
        Sin[x^2\  + \ y^2], {{x, 1}, {y, 1}}]\)], "Input",
  CellLabel->"In[5]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.878148 1.10621 -0.911051 0.930282 [
[.00682 -0.0125 -9 -9 ]
[.00682 -0.0125 9 0 ]
[.22807 -0.0125 -3 -9 ]
[.22807 -0.0125 3 0 ]
[.44931 -0.0125 -9 -9 ]
[.44931 -0.0125 9 0 ]
[.67055 -0.0125 -9 -9 ]
[.67055 -0.0125 9 0 ]
[.89179 -0.0125 -9 -9 ]
[.89179 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .20529 -18 -4.5 ]
[-0.0125 .20529 0 4.5 ]
[-0.0125 .39134 -18 -4.5 ]
[-0.0125 .39134 0 4.5 ]
[-0.0125 .5774 -18 -4.5 ]
[-0.0125 .5774 0 4.5 ]
[-0.0125 .76346 -18 -4.5 ]
[-0.0125 .76346 0 4.5 ]
[-0.0125 .94951 -6 -4.5 ]
[-0.0125 .94951 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00682 0 m
.00682 .00625 L
s
[(0.8)] .00682 -0.0125 0 1 Mshowa
.22807 0 m
.22807 .00625 L
s
[(1)] .22807 -0.0125 0 1 Mshowa
.44931 0 m
.44931 .00625 L
s
[(1.2)] .44931 -0.0125 0 1 Mshowa
.67055 0 m
.67055 .00625 L
s
[(1.4)] .67055 -0.0125 0 1 Mshowa
.89179 0 m
.89179 .00625 L
s
[(1.6)] .89179 -0.0125 0 1 Mshowa
.125 Mabswid
.06213 0 m
.06213 .00375 L
s
.11744 0 m
.11744 .00375 L
s
.17276 0 m
.17276 .00375 L
s
.28338 0 m
.28338 .00375 L
s
.33869 0 m
.33869 .00375 L
s
.394 0 m
.394 .00375 L
s
.50462 0 m
.50462 .00375 L
s
.55993 0 m
.55993 .00375 L
s
.61524 0 m
.61524 .00375 L
s
.72586 0 m
.72586 .00375 L
s
.78117 0 m
.78117 .00375 L
s
.83648 0 m
.83648 .00375 L
s
.9471 0 m
.9471 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(1)] -0.0125 .01923 1 0 Mshowa
0 .20529 m
.00625 .20529 L
s
[(1.2)] -0.0125 .20529 1 0 Mshowa
0 .39134 m
.00625 .39134 L
s
[(1.4)] -0.0125 .39134 1 0 Mshowa
0 .5774 m
.00625 .5774 L
s
[(1.6)] -0.0125 .5774 1 0 Mshowa
0 .76346 m
.00625 .76346 L
s
[(1.8)] -0.0125 .76346 1 0 Mshowa
0 .94951 m
.00625 .94951 L
s
[(2)] -0.0125 .94951 1 0 Mshowa
.125 Mabswid
0 .06574 m
.00375 .06574 L
s
0 .11226 m
.00375 .11226 L
s
0 .15877 m
.00375 .15877 L
s
0 .2518 m
.00375 .2518 L
s
0 .29832 m
.00375 .29832 L
s
0 .34483 m
.00375 .34483 L
s
0 .43786 m
.00375 .43786 L
s
0 .48437 m
.00375 .48437 L
s
0 .53089 m
.00375 .53089 L
s
0 .62391 m
.00375 .62391 L
s
0 .67043 m
.00375 .67043 L
s
0 .71694 m
.00375 .71694 L
s
0 .80997 m
.00375 .80997 L
s
0 .85648 m
.00375 .85648 L
s
0 .903 m
.00375 .903 L
s
0 .99603 m
.00375 .99603 L
s
.25 Mabswid
0 0 m
0 1 L
s
.00682 .99375 m
.00682 1 L
s
.22807 .99375 m
.22807 1 L
s
.44931 .99375 m
.44931 1 L
s
.67055 .99375 m
.67055 1 L
s
.89179 .99375 m
.89179 1 L
s
.125 Mabswid
.06213 .99625 m
.06213 1 L
s
.11744 .99625 m
.11744 1 L
s
.17276 .99625 m
.17276 1 L
s
.28338 .99625 m
.28338 1 L
s
.33869 .99625 m
.33869 1 L
s
.394 .99625 m
.394 1 L
s
.50462 .99625 m
.50462 1 L
s
.55993 .99625 m
.55993 1 L
s
.61524 .99625 m
.61524 1 L
s
.72586 .99625 m
.72586 1 L
s
.78117 .99625 m
.78117 1 L
s
.83648 .99625 m
.83648 1 L
s
.9471 .99625 m
.9471 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .20529 m
1 .20529 L
s
.99375 .39134 m
1 .39134 L
s
.99375 .5774 m
1 .5774 L
s
.99375 .76346 m
1 .76346 L
s
.99375 .94951 m
1 .94951 L
s
.125 Mabswid
.99625 .06574 m
1 .06574 L
s
.99625 .11226 m
1 .11226 L
s
.99625 .15877 m
1 .15877 L
s
.99625 .2518 m
1 .2518 L
s
.99625 .29832 m
1 .29832 L
s
.99625 .34483 m
1 .34483 L
s
.99625 .43786 m
1 .43786 L
s
.99625 .48437 m
1 .48437 L
s
.99625 .53089 m
1 .53089 L
s
.99625 .62391 m
1 .62391 L
s
.99625 .67043 m
1 .67043 L
s
.99625 .71694 m
1 .71694 L
s
.99625 .80997 m
1 .80997 L
s
.99625 .85648 m
1 .85648 L
s
.99625 .903 m
1 .903 L
s
.99625 .99603 m
1 .99603 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.325 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 g
.01923 .03917 m
.02894 .04224 L
.03866 .04518 L
.04837 .04799 L
.04973 .04837 L
.05808 .05067 L
.06779 .05323 L
.07751 .05568 L
.08722 .05802 L
.08746 .05808 L
.09693 .06026 L
.10664 .06241 L
.11636 .06445 L
.12607 .06641 L
.13316 .06779 L
.13578 .06829 L
.14549 .07009 L
.15521 .07181 L
.16492 .07345 L
.17463 .07503 L
.18434 .07654 L
.1908 .07751 L
.19406 .07798 L
.20377 .07937 L
.21348 .0807 L
.22319 .08197 L
.23291 .08319 L
.24262 .08435 L
.25233 .08547 L
.26204 .08654 L
.26838 .08722 L
.27176 .08757 L
.28147 .08855 L
.29118 .0895 L
.30089 .0904 L
.31061 .09126 L
.32032 .09209 L
.33003 .09288 L
.33974 .09363 L
.34946 .09436 L
.35917 .09505 L
.36888 .0957 L
.37859 .09633 L
.38831 .09693 L
.38834 .09693 L
.39802 .0975 L
.40773 .09804 L
.41744 .09855 L
.42716 .09904 L
.43687 .0995 L
.44658 .09993 L
.45629 .10034 L
.46601 .10072 L
.47572 .10108 L
.48543 .10142 L
.49514 .10173 L
.50486 .10202 L
.51457 .10228 L
.52428 .10252 L
.53399 .10274 L
.54371 .10293 L
.55342 .1031 L
.56313 .10325 L
.57284 .10337 L
.58256 .10347 L
.59227 .10355 L
.60198 .1036 L
.61169 .10362 L
.62141 .10362 L
.63112 .1036 L
.64083 .10355 L
.65054 .10347 L
.66026 .10336 L
.66997 .10323 L
.67968 .10307 L
.68939 .10287 L
.69911 .10264 L
.70882 .10238 L
.71853 .10209 L
.72824 .10175 L
.73796 .10138 L
.74767 .10097 L
.75738 .10051 L
.76709 .10001 L
.77681 .09946 L
.78652 .09886 L
.79623 .0982 L
.80594 .09748 L
.8128 .09693 L
.81566 .09669 L
.82537 .09584 L
.83508 .0949 L
.84479 .09389 L
.85451 .09278 L
.86422 .09157 L
.87393 .09024 L
.88364 .08879 L
.89329 .08722 L
.89336 .08721 L
.90307 .08546 L
.91278 .08354 L
.92249 .08142 L
.93221 .07907 L
.93811 .07751 L
.94192 .07644 L
.95163 .07351 L
.96134 .07021 L
.96777 .06779 L
.97106 .06647 L
.98077 .0622 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .03917 m
.02894 .04224 L
.03866 .04518 L
.04837 .04799 L
.04973 .04837 L
.05808 .05067 L
.06779 .05323 L
.07751 .05568 L
.08722 .05802 L
.08746 .05808 L
.09693 .06026 L
.10664 .06241 L
.11636 .06445 L
.12607 .06641 L
.13316 .06779 L
.13578 .06829 L
.14549 .07009 L
.15521 .07181 L
.16492 .07345 L
.17463 .07503 L
.18434 .07654 L
.1908 .07751 L
.19406 .07798 L
.20377 .07937 L
.21348 .0807 L
.22319 .08197 L
.23291 .08319 L
.24262 .08435 L
.25233 .08547 L
.26204 .08654 L
.26838 .08722 L
.27176 .08757 L
.28147 .08855 L
.29118 .0895 L
.30089 .0904 L
.31061 .09126 L
.32032 .09209 L
.33003 .09288 L
.33974 .09363 L
.34946 .09436 L
.35917 .09505 L
.36888 .0957 L
.37859 .09633 L
.38831 .09693 L
.38834 .09693 L
.39802 .0975 L
.40773 .09804 L
.41744 .09855 L
.42716 .09904 L
.43687 .0995 L
Mistroke
.44658 .09993 L
.45629 .10034 L
.46601 .10072 L
.47572 .10108 L
.48543 .10142 L
.49514 .10173 L
.50486 .10202 L
.51457 .10228 L
.52428 .10252 L
.53399 .10274 L
.54371 .10293 L
.55342 .1031 L
.56313 .10325 L
.57284 .10337 L
.58256 .10347 L
.59227 .10355 L
.60198 .1036 L
.61169 .10362 L
.62141 .10362 L
.63112 .1036 L
.64083 .10355 L
.65054 .10347 L
.66026 .10336 L
.66997 .10323 L
.67968 .10307 L
.68939 .10287 L
.69911 .10264 L
.70882 .10238 L
.71853 .10209 L
.72824 .10175 L
.73796 .10138 L
.74767 .10097 L
.75738 .10051 L
.76709 .10001 L
.77681 .09946 L
.78652 .09886 L
.79623 .0982 L
.80594 .09748 L
.8128 .09693 L
.81566 .09669 L
.82537 .09584 L
.83508 .0949 L
.84479 .09389 L
.85451 .09278 L
.86422 .09157 L
.87393 .09024 L
.88364 .08879 L
.89329 .08722 L
.89336 .08721 L
.90307 .08546 L
Mistroke
.91278 .08354 L
.92249 .08142 L
.93221 .07907 L
.93811 .07751 L
.94192 .07644 L
.95163 .07351 L
.96134 .07021 L
.96777 .06779 L
.97106 .06647 L
.98077 .0622 L
Mfstroke
.475 g
.01923 .15177 m
.02894 .15165 L
.03866 .15154 L
.04837 .15143 L
.05808 .15133 L
.06779 .15123 L
.07751 .15114 L
.08722 .15105 L
.09693 .15097 L
.10664 .1509 L
.11636 .15083 L
.12607 .15076 L
.13578 .15069 L
.14549 .15063 L
.15521 .15057 L
.16492 .15052 L
.17463 .15046 L
.18434 .15041 L
.19406 .15036 L
.20377 .15032 L
.21348 .15027 L
.22319 .15023 L
.23291 .15019 L
.24262 .15015 L
.25233 .15012 L
.26204 .15008 L
.27176 .15005 L
.28147 .15002 L
.29118 .14999 L
.30089 .14996 L
.31061 .14993 L
.32032 .1499 L
.33003 .14988 L
.33974 .14986 L
.34946 .14983 L
.35917 .14981 L
.36888 .14979 L
.37859 .14977 L
.38831 .14975 L
.39802 .14973 L
.40773 .14972 L
.41744 .1497 L
.42716 .14968 L
.43687 .14967 L
.44658 .14966 L
.45629 .14964 L
.46601 .14963 L
.47572 .14962 L
.48543 .14961 L
.49514 .1496 L
.50486 .14959 L
.51457 .14958 L
.52428 .14957 L
.53399 .14957 L
.54371 .14956 L
.55342 .14955 L
.56313 .14955 L
.57284 .14954 L
.58256 .14954 L
.59227 .14954 L
.60198 .14954 L
.61169 .14953 L
.62141 .14953 L
.63112 .14953 L
.64083 .14954 L
.65054 .14954 L
.66026 .14954 L
.66997 .14954 L
.67968 .14955 L
.68939 .14955 L
.69911 .14956 L
.70882 .14956 L
.71853 .14957 L
.72824 .14958 L
.73796 .14959 L
.74767 .1496 L
.75738 .14962 L
.76709 .14963 L
.77681 .14964 L
.78652 .14966 L
.79623 .14968 L
.80594 .1497 L
.81566 .14972 L
.82537 .14974 L
.83508 .14977 L
.84479 .14979 L
.85451 .14982 L
.86422 .14986 L
.87393 .14989 L
.88364 .14993 L
.89336 .14997 L
.90307 .15002 L
.91278 .15007 L
.92249 .15012 L
.93221 .15018 L
.94192 .15025 L
.95163 .15032 L
.96134 .1504 L
.97106 .15049 L
.98077 .15059 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .15177 m
.02894 .15165 L
.03866 .15154 L
.04837 .15143 L
.05808 .15133 L
.06779 .15123 L
.07751 .15114 L
.08722 .15105 L
.09693 .15097 L
.10664 .1509 L
.11636 .15083 L
.12607 .15076 L
.13578 .15069 L
.14549 .15063 L
.15521 .15057 L
.16492 .15052 L
.17463 .15046 L
.18434 .15041 L
.19406 .15036 L
.20377 .15032 L
.21348 .15027 L
.22319 .15023 L
.23291 .15019 L
.24262 .15015 L
.25233 .15012 L
.26204 .15008 L
.27176 .15005 L
.28147 .15002 L
.29118 .14999 L
.30089 .14996 L
.31061 .14993 L
.32032 .1499 L
.33003 .14988 L
.33974 .14986 L
.34946 .14983 L
.35917 .14981 L
.36888 .14979 L
.37859 .14977 L
.38831 .14975 L
.39802 .14973 L
.40773 .14972 L
.41744 .1497 L
.42716 .14968 L
.43687 .14967 L
.44658 .14966 L
.45629 .14964 L
.46601 .14963 L
.47572 .14962 L
.48543 .14961 L
.49514 .1496 L
Mistroke
.50486 .14959 L
.51457 .14958 L
.52428 .14957 L
.53399 .14957 L
.54371 .14956 L
.55342 .14955 L
.56313 .14955 L
.57284 .14954 L
.58256 .14954 L
.59227 .14954 L
.60198 .14954 L
.61169 .14953 L
.62141 .14953 L
.63112 .14953 L
.64083 .14954 L
.65054 .14954 L
.66026 .14954 L
.66997 .14954 L
.67968 .14955 L
.68939 .14955 L
.69911 .14956 L
.70882 .14956 L
.71853 .14957 L
.72824 .14958 L
.73796 .14959 L
.74767 .1496 L
.75738 .14962 L
.76709 .14963 L
.77681 .14964 L
.78652 .14966 L
.79623 .14968 L
.80594 .1497 L
.81566 .14972 L
.82537 .14974 L
.83508 .14977 L
.84479 .14979 L
.85451 .14982 L
.86422 .14986 L
.87393 .14989 L
.88364 .14993 L
.89336 .14997 L
.90307 .15002 L
.91278 .15007 L
.92249 .15012 L
.93221 .15018 L
.94192 .15025 L
.95163 .15032 L
.96134 .1504 L
.97106 .15049 L
.98077 .15059 L
Mistroke
Mfstroke
.55 g
.01923 .28797 m
.02894 .28189 L
.02965 .28147 L
.03866 .27633 L
.04735 .27176 L
.04837 .27124 L
.05808 .26655 L
.06779 .26222 L
.0682 .26204 L
.07751 .2582 L
.08722 .25447 L
.09312 .25233 L
.09693 .25099 L
.10664 .24775 L
.11636 .24471 L
.12342 .24262 L
.12607 .24186 L
.13578 .23918 L
.14549 .23666 L
.15521 .23429 L
.16112 .23291 L
.16492 .23205 L
.17463 .22993 L
.18434 .22793 L
.19406 .22603 L
.20377 .22423 L
.20963 .22319 L
.21348 .22253 L
.22319 .22091 L
.23291 .21937 L
.24262 .21791 L
.25233 .21652 L
.26204 .2152 L
.27176 .21394 L
.27538 .21348 L
.28147 .21274 L
.29118 .21159 L
.30089 .2105 L
.31061 .20947 L
.32032 .20848 L
.33003 .20754 L
.33974 .20664 L
.34946 .20578 L
.35917 .20497 L
.36888 .20419 L
.37442 .20377 L
.37859 .20346 L
.38831 .20275 L
.39802 .20209 L
.40773 .20145 L
.41744 .20085 L
.42716 .20029 L
.43687 .19975 L
.44658 .19924 L
.45629 .19876 L
.46601 .19831 L
.47572 .19789 L
.48543 .19749 L
.49514 .19712 L
.50486 .19678 L
.51457 .19646 L
.52428 .19617 L
.53399 .1959 L
.54371 .19566 L
.55342 .19545 L
.56313 .19525 L
.57284 .19509 L
.58256 .19495 L
.59227 .19483 L
.60198 .19474 L
.61169 .19467 L
.62141 .19463 L
.63112 .19462 L
.64083 .19463 L
.65054 .19467 L
.66026 .19474 L
.66997 .19484 L
.67968 .19496 L
.68939 .19512 L
.69911 .1953 L
.70882 .19552 L
.71853 .19577 L
.72824 .19606 L
.73796 .19638 L
.74767 .19675 L
.75738 .19715 L
.76709 .19759 L
.77681 .19808 L
.78652 .19861 L
.79623 .1992 L
.80594 .19984 L
.81566 .20053 L
.82537 .20129 L
.83508 .20211 L
.84479 .203 L
.85254 .20377 L
.85451 .20397 L
.86422 .20502 L
.87393 .20616 L
.88364 .2074 L
.89336 .20875 L
.90307 .21021 L
.91278 .2118 L
.92217 .21348 L
.92249 .21354 L
.93221 .21544 L
.94192 .21751 L
.95163 .21979 L
.96134 .22229 L
.96463 .22319 L
.97106 .22505 L
.98077 .2281 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .28797 m
.02894 .28189 L
.02965 .28147 L
.03866 .27633 L
.04735 .27176 L
.04837 .27124 L
.05808 .26655 L
.06779 .26222 L
.0682 .26204 L
.07751 .2582 L
.08722 .25447 L
.09312 .25233 L
.09693 .25099 L
.10664 .24775 L
.11636 .24471 L
.12342 .24262 L
.12607 .24186 L
.13578 .23918 L
.14549 .23666 L
.15521 .23429 L
.16112 .23291 L
.16492 .23205 L
.17463 .22993 L
.18434 .22793 L
.19406 .22603 L
.20377 .22423 L
.20963 .22319 L
.21348 .22253 L
.22319 .22091 L
.23291 .21937 L
.24262 .21791 L
.25233 .21652 L
.26204 .2152 L
.27176 .21394 L
.27538 .21348 L
.28147 .21274 L
.29118 .21159 L
.30089 .2105 L
.31061 .20947 L
.32032 .20848 L
.33003 .20754 L
.33974 .20664 L
.34946 .20578 L
.35917 .20497 L
.36888 .20419 L
.37442 .20377 L
.37859 .20346 L
.38831 .20275 L
.39802 .20209 L
.40773 .20145 L
Mistroke
.41744 .20085 L
.42716 .20029 L
.43687 .19975 L
.44658 .19924 L
.45629 .19876 L
.46601 .19831 L
.47572 .19789 L
.48543 .19749 L
.49514 .19712 L
.50486 .19678 L
.51457 .19646 L
.52428 .19617 L
.53399 .1959 L
.54371 .19566 L
.55342 .19545 L
.56313 .19525 L
.57284 .19509 L
.58256 .19495 L
.59227 .19483 L
.60198 .19474 L
.61169 .19467 L
.62141 .19463 L
.63112 .19462 L
.64083 .19463 L
.65054 .19467 L
.66026 .19474 L
.66997 .19484 L
.67968 .19496 L
.68939 .19512 L
.69911 .1953 L
.70882 .19552 L
.71853 .19577 L
.72824 .19606 L
.73796 .19638 L
.74767 .19675 L
.75738 .19715 L
.76709 .19759 L
.77681 .19808 L
.78652 .19861 L
.79623 .1992 L
.80594 .19984 L
.81566 .20053 L
.82537 .20129 L
.83508 .20211 L
.84479 .203 L
.85254 .20377 L
.85451 .20397 L
.86422 .20502 L
.87393 .20616 L
.88364 .2074 L
Mistroke
.89336 .20875 L
.90307 .21021 L
.91278 .2118 L
.92217 .21348 L
.92249 .21354 L
.93221 .21544 L
.94192 .21751 L
.95163 .21979 L
.96134 .22229 L
.96463 .22319 L
.97106 .22505 L
.98077 .2281 L
Mfstroke
.625 g
.01923 .47442 m
.0233 .46601 L
.02831 .45629 L
.02894 .45511 L
.03369 .44658 L
.03866 .4382 L
.03947 .43687 L
.04571 .42716 L
.04837 .42323 L
.05245 .41744 L
.05808 .40988 L
.05975 .40773 L
.06768 .39802 L
.06779 .39789 L
.07632 .38831 L
.07751 .38704 L
.08578 .37859 L
.08722 .37719 L
.09615 .36888 L
.09693 .36819 L
.10664 .35994 L
.10759 .35917 L
.11636 .35233 L
.12025 .34946 L
.12607 .34531 L
.13433 .33974 L
.13578 .3388 L
.14549 .33275 L
.1501 .33003 L
.15521 .32712 L
.16492 .32185 L
.16787 .32032 L
.17463 .31692 L
.18434 .3123 L
.18807 .31061 L
.19406 .30796 L
.20377 .30388 L
.21126 .30089 L
.21348 .30003 L
.22319 .2964 L
.23291 .29298 L
.23822 .29118 L
.24262 .28974 L
.25233 .28667 L
.26204 .28376 L
.2701 .28147 L
.27176 .28101 L
.28147 .2784 L
.29118 .27592 L
.30089 .27357 L
.30872 .27176 L
.31061 .27133 L
.32032 .26921 L
.33003 .26719 L
.33974 .26527 L
.34946 .26345 L
.35728 .26204 L
.35917 .26171 L
.36888 .26007 L
.37859 .2585 L
.38831 .25702 L
.39802 .25561 L
.40773 .25427 L
.41744 .25301 L
.42287 .25233 L
.42716 .25181 L
.43687 .25068 L
.44658 .24961 L
.45629 .2486 L
.46601 .24765 L
.47572 .24676 L
.48543 .24593 L
.49514 .24515 L
.50486 .24442 L
.51457 .24375 L
.52428 .24313 L
.53309 .24262 L
.53399 .24257 L
.54371 .24205 L
.55342 .24159 L
.56313 .24117 L
.57284 .24081 L
.58256 .2405 L
.59227 .24024 L
.60198 .24002 L
.61169 .23986 L
.62141 .23975 L
.63112 .2397 L
.64083 .23969 L
.65054 .23974 L
.66026 .23984 L
.66997 .24 L
.67968 .24022 L
.68939 .24049 L
.69911 .24083 L
.70882 .24123 L
.71853 .24169 L
.72824 .24222 L
.73472 .24262 L
.73796 .24283 L
.74767 .2435 L
.75738 .24426 L
.76709 .2451 L
.77681 .24602 L
.78652 .24703 L
.79623 .24814 L
.80594 .24935 L
.81566 .25067 L
.82537 .25211 L
.82677 .25233 L
.83508 .25368 L
.84479 .25538 L
.85451 .25722 L
.86422 .25922 L
.87393 .2614 L
.87666 .26204 L
.88364 .26376 L
.89336 .26633 L
.90307 .26912 L
.91154 .27176 L
.91278 .27216 L
.92249 .27548 L
.93221 .2791 L
.93813 .28147 L
.94192 .28306 L
.95163 .28741 L
.95938 .29118 L
.96134 .29219 L
.97106 .29746 L
.97688 .30089 L
.98077 .30331 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .47442 m
.0233 .46601 L
.02831 .45629 L
.02894 .45511 L
.03369 .44658 L
.03866 .4382 L
.03947 .43687 L
.04571 .42716 L
.04837 .42323 L
.05245 .41744 L
.05808 .40988 L
.05975 .40773 L
.06768 .39802 L
.06779 .39789 L
.07632 .38831 L
.07751 .38704 L
.08578 .37859 L
.08722 .37719 L
.09615 .36888 L
.09693 .36819 L
.10664 .35994 L
.10759 .35917 L
.11636 .35233 L
.12025 .34946 L
.12607 .34531 L
.13433 .33974 L
.13578 .3388 L
.14549 .33275 L
.1501 .33003 L
.15521 .32712 L
.16492 .32185 L
.16787 .32032 L
.17463 .31692 L
.18434 .3123 L
.18807 .31061 L
.19406 .30796 L
.20377 .30388 L
.21126 .30089 L
.21348 .30003 L
.22319 .2964 L
.23291 .29298 L
.23822 .29118 L
.24262 .28974 L
.25233 .28667 L
.26204 .28376 L
.2701 .28147 L
.27176 .28101 L
.28147 .2784 L
.29118 .27592 L
.30089 .27357 L
Mistroke
.30872 .27176 L
.31061 .27133 L
.32032 .26921 L
.33003 .26719 L
.33974 .26527 L
.34946 .26345 L
.35728 .26204 L
.35917 .26171 L
.36888 .26007 L
.37859 .2585 L
.38831 .25702 L
.39802 .25561 L
.40773 .25427 L
.41744 .25301 L
.42287 .25233 L
.42716 .25181 L
.43687 .25068 L
.44658 .24961 L
.45629 .2486 L
.46601 .24765 L
.47572 .24676 L
.48543 .24593 L
.49514 .24515 L
.50486 .24442 L
.51457 .24375 L
.52428 .24313 L
.53309 .24262 L
.53399 .24257 L
.54371 .24205 L
.55342 .24159 L
.56313 .24117 L
.57284 .24081 L
.58256 .2405 L
.59227 .24024 L
.60198 .24002 L
.61169 .23986 L
.62141 .23975 L
.63112 .2397 L
.64083 .23969 L
.65054 .23974 L
.66026 .23984 L
.66997 .24 L
.67968 .24022 L
.68939 .24049 L
.69911 .24083 L
.70882 .24123 L
.71853 .24169 L
.72824 .24222 L
.73472 .24262 L
.73796 .24283 L
Mistroke
.74767 .2435 L
.75738 .24426 L
.76709 .2451 L
.77681 .24602 L
.78652 .24703 L
.79623 .24814 L
.80594 .24935 L
.81566 .25067 L
.82537 .25211 L
.82677 .25233 L
.83508 .25368 L
.84479 .25538 L
.85451 .25722 L
.86422 .25922 L
.87393 .2614 L
.87666 .26204 L
.88364 .26376 L
.89336 .26633 L
.90307 .26912 L
.91154 .27176 L
.91278 .27216 L
.92249 .27548 L
.93221 .2791 L
.93813 .28147 L
.94192 .28306 L
.95163 .28741 L
.95938 .29118 L
.96134 .29219 L
.97106 .29746 L
.97688 .30089 L
.98077 .30331 L
Mfstroke
.55 g
.01923 .89426 m
.02855 .90307 L
.02894 .90342 L
.03866 .91143 L
.04042 .91278 L
.04837 .91853 L
.05428 .92249 L
.05808 .92491 L
.06779 .93067 L
.07055 .93221 L
.07751 .93592 L
.08722 .94073 L
.08976 .94192 L
.09693 .94515 L
.10664 .94925 L
.11265 .95163 L
.11636 .95305 L
.12607 .95659 L
.13578 .95989 L
.14026 .96134 L
.14549 .96299 L
.15521 .96589 L
.16492 .96862 L
.17413 .97106 L
.17463 .97118 L
.18434 .97361 L
.19406 .97589 L
.20377 .97806 L
.21348 .9801 L
.21677 .98077 L
.01923 .98077 L
F
0 g
.01923 .89426 m
.02855 .90307 L
.02894 .90342 L
.03866 .91143 L
.04042 .91278 L
.04837 .91853 L
.05428 .92249 L
.05808 .92491 L
.06779 .93067 L
.07055 .93221 L
.07751 .93592 L
.08722 .94073 L
.08976 .94192 L
.09693 .94515 L
.10664 .94925 L
.11265 .95163 L
.11636 .95305 L
.12607 .95659 L
.13578 .95989 L
.14026 .96134 L
.14549 .96299 L
.15521 .96589 L
.16492 .96862 L
.17413 .97106 L
.17463 .97118 L
.18434 .97361 L
.19406 .97589 L
.20377 .97806 L
.21348 .9801 L
.21677 .98077 L
s
.7 g
.98077 .86724 m
.97453 .87393 L
.97106 .87744 L
.96453 .88364 L
.96134 .88651 L
.95322 .89336 L
.95163 .89462 L
.94192 .90191 L
.94029 .90307 L
.93221 .9085 L
.92533 .91278 L
.92249 .91447 L
.91278 .91989 L
.90779 .92249 L
.90307 .92484 L
.89336 .92936 L
.88678 .93221 L
.88364 .9335 L
.87393 .9373 L
.86422 .94079 L
.8609 .94192 L
.85451 .944 L
.84479 .94696 L
.83508 .94969 L
.82765 .95163 L
.82537 .9522 L
.81566 .95452 L
.80594 .95666 L
.79623 .95864 L
.78652 .96046 L
.78147 .96134 L
.77681 .96213 L
.76709 .96367 L
.75738 .96509 L
.74767 .96639 L
.73796 .96758 L
.72824 .96867 L
.71853 .96965 L
.70882 .97055 L
.70279 .97106 L
.69911 .97135 L
.68939 .97207 L
.67968 .97271 L
.66997 .97327 L
.66026 .97375 L
.65054 .97416 L
.64083 .97451 L
.63112 .97478 L
.62141 .97499 L
.61169 .97513 L
.60198 .97522 L
.59227 .97524 L
.58256 .97519 L
.57284 .97509 L
.56313 .97493 L
.55342 .97471 L
.54371 .97443 L
.53399 .9741 L
.52428 .9737 L
.51457 .97325 L
.50486 .97273 L
.49514 .97216 L
.48543 .97153 L
.47879 .97106 L
.47572 .97083 L
.46601 .97007 L
.45629 .96925 L
.44658 .96837 L
.43687 .96742 L
.42716 .9664 L
.41744 .96531 L
.40773 .96414 L
.39802 .9629 L
.38831 .96159 L
.38657 .96134 L
.37859 .96019 L
.36888 .95871 L
.35917 .95714 L
.34946 .95547 L
.33974 .95371 L
.33003 .95185 L
.32895 .95163 L
.32032 .94987 L
.31061 .94778 L
.30089 .94557 L
.29118 .94323 L
.28599 .94192 L
.28147 .94074 L
.27176 .93811 L
.26204 .93532 L
.25233 .93234 L
.2519 .93221 L
.24262 .92918 L
.23291 .92581 L
.22392 .92249 L
.22319 .92222 L
.21348 .91837 L
.20377 .91424 L
.2005 .91278 L
.19406 .9098 L
.18434 .90501 L
.18061 .90307 L
.17463 .89983 L
.16492 .89419 L
.16355 .89336 L
.15521 .88803 L
.14881 .88364 L
.14549 .88125 L
.13602 .87393 L
.13578 .87374 L
.12607 .86533 L
.12487 .86422 L
.11636 .8558 L
.11514 .85451 L
.10664 .84483 L
.10662 .84479 L
.09916 .83508 L
.09693 .8319 L
.09265 .82537 L
.08722 .81614 L
.08696 .81566 L
.082 .80594 L
.07771 .79623 L
.07751 .79573 L
.07401 .78652 L
.07085 .77681 L
.06818 .76709 L
.06779 .76555 L
.06595 .75738 L
.06414 .74767 L
.0627 .73796 L
.06161 .72824 L
.06085 .71853 L
.0604 .70882 L
.06023 .69911 L
.06034 .68939 L
.06071 .67968 L
.06133 .66997 L
.06219 .66026 L
.06329 .65054 L
.06462 .64083 L
.06617 .63112 L
.06779 .62224 L
.06796 .62141 L
.06996 .61169 L
.0722 .60198 L
.07467 .59227 L
.07738 .58256 L
.07751 .58213 L
.08033 .57284 L
.08354 .56313 L
.08701 .55342 L
.08722 .55285 L
.09075 .54371 L
.09479 .53399 L
.09693 .52912 L
.09914 .52428 L
.10381 .51457 L
.10664 .50902 L
.10884 .50486 L
.11425 .49514 L
.11636 .49156 L
.12008 .48543 L
.12607 .47613 L
.12634 .47572 L
.1331 .46601 L
.13578 .46235 L
.14039 .45629 L
.14549 .44992 L
.14827 .44658 L
.15521 .43863 L
.15681 .43687 L
.16492 .42832 L
.16607 .42716 L
.17463 .41885 L
.17615 .41744 L
.18434 .41012 L
.18714 .40773 L
.19406 .40205 L
.19918 .39802 L
.20377 .39455 L
.21242 .38831 L
.21348 .38757 L
.22319 .38105 L
.22704 .37859 L
.23291 .37496 L
.24262 .36925 L
.24327 .36888 L
.25233 .3639 L
.26143 .35917 L
.26204 .35886 L
.27176 .35412 L
.28147 .34965 L
.28189 .34946 L
.29118 .34543 L
.30089 .34145 L
.30522 .33974 L
.31061 .33768 L
.32032 .33412 L
.33003 .33075 L
.33218 .33003 L
.33974 .32756 L
.34946 .32454 L
.35917 .32168 L
.36397 .32032 L
.36888 .31897 L
.37859 .3164 L
.38831 .31397 L
.39802 .31166 L
.40267 .31061 L
.40773 .30948 L
.41744 .30742 L
.42716 .30547 L
.43687 .30364 L
.44658 .3019 L
.4525 .30089 L
.45629 .30027 L
.46601 .29873 L
.47572 .29729 L
.48543 .29594 L
.49514 .29468 L
.50486 .29351 L
.51457 .29242 L
.52428 .29141 L
.52666 .29118 L
.53399 .29049 L
.54371 .28965 L
.55342 .28889 L
.56313 .28821 L
.57284 .28761 L
.58256 .28709 L
.59227 .28664 L
.60198 .28627 L
.61169 .28599 L
.62141 .28578 L
.63112 .28565 L
.64083 .2856 L
.65054 .28563 L
.66026 .28575 L
.66997 .28596 L
.67968 .28625 L
.68939 .28663 L
.69911 .2871 L
.70882 .28767 L
.71853 .28834 L
.72824 .28911 L
.73796 .28999 L
.74767 .29098 L
.74951 .29118 L
.75738 .29209 L
.76709 .29332 L
.77681 .29469 L
.78652 .29619 L
.79623 .29784 L
.80594 .29964 L
.81222 .30089 L
.81566 .30161 L
.82537 .30376 L
.83508 .30611 L
.84479 .30866 L
.8517 .31061 L
.85451 .31143 L
.86422 .31445 L
.87393 .31774 L
.88101 .32032 L
.88364 .32132 L
.89336 .32522 L
.90307 .32948 L
.90426 .33003 L
.91278 .33414 L
.92249 .33924 L
.92341 .33974 L
.93221 .34484 L
.93957 .34946 L
.94192 .351 L
.95163 .35781 L
.95345 .35917 L
.96134 .36537 L
.96552 .36888 L
.97106 .37381 L
.97611 .37859 L
.98077 .38327 L
F
0 g
.98077 .86724 m
.97453 .87393 L
.97106 .87744 L
.96453 .88364 L
.96134 .88651 L
.95322 .89336 L
.95163 .89462 L
.94192 .90191 L
.94029 .90307 L
.93221 .9085 L
.92533 .91278 L
.92249 .91447 L
.91278 .91989 L
.90779 .92249 L
.90307 .92484 L
.89336 .92936 L
.88678 .93221 L
.88364 .9335 L
.87393 .9373 L
.86422 .94079 L
.8609 .94192 L
.85451 .944 L
.84479 .94696 L
.83508 .94969 L
.82765 .95163 L
.82537 .9522 L
.81566 .95452 L
.80594 .95666 L
.79623 .95864 L
.78652 .96046 L
.78147 .96134 L
.77681 .96213 L
.76709 .96367 L
.75738 .96509 L
.74767 .96639 L
.73796 .96758 L
.72824 .96867 L
.71853 .96965 L
.70882 .97055 L
.70279 .97106 L
.69911 .97135 L
.68939 .97207 L
.67968 .97271 L
.66997 .97327 L
.66026 .97375 L
.65054 .97416 L
.64083 .97451 L
.63112 .97478 L
.62141 .97499 L
.61169 .97513 L
Mistroke
.60198 .97522 L
.59227 .97524 L
.58256 .97519 L
.57284 .97509 L
.56313 .97493 L
.55342 .97471 L
.54371 .97443 L
.53399 .9741 L
.52428 .9737 L
.51457 .97325 L
.50486 .97273 L
.49514 .97216 L
.48543 .97153 L
.47879 .97106 L
.47572 .97083 L
.46601 .97007 L
.45629 .96925 L
.44658 .96837 L
.43687 .96742 L
.42716 .9664 L
.41744 .96531 L
.40773 .96414 L
.39802 .9629 L
.38831 .96159 L
.38657 .96134 L
.37859 .96019 L
.36888 .95871 L
.35917 .95714 L
.34946 .95547 L
.33974 .95371 L
.33003 .95185 L
.32895 .95163 L
.32032 .94987 L
.31061 .94778 L
.30089 .94557 L
.29118 .94323 L
.28599 .94192 L
.28147 .94074 L
.27176 .93811 L
.26204 .93532 L
.25233 .93234 L
.2519 .93221 L
.24262 .92918 L
.23291 .92581 L
.22392 .92249 L
.22319 .92222 L
.21348 .91837 L
.20377 .91424 L
.2005 .91278 L
.19406 .9098 L
Mistroke
.18434 .90501 L
.18061 .90307 L
.17463 .89983 L
.16492 .89419 L
.16355 .89336 L
.15521 .88803 L
.14881 .88364 L
.14549 .88125 L
.13602 .87393 L
.13578 .87374 L
.12607 .86533 L
.12487 .86422 L
.11636 .8558 L
.11514 .85451 L
.10664 .84483 L
.10662 .84479 L
.09916 .83508 L
.09693 .8319 L
.09265 .82537 L
.08722 .81614 L
.08696 .81566 L
.082 .80594 L
.07771 .79623 L
.07751 .79573 L
.07401 .78652 L
.07085 .77681 L
.06818 .76709 L
.06779 .76555 L
.06595 .75738 L
.06414 .74767 L
.0627 .73796 L
.06161 .72824 L
.06085 .71853 L
.0604 .70882 L
.06023 .69911 L
.06034 .68939 L
.06071 .67968 L
.06133 .66997 L
.06219 .66026 L
.06329 .65054 L
.06462 .64083 L
.06617 .63112 L
.06779 .62224 L
.06796 .62141 L
.06996 .61169 L
.0722 .60198 L
.07467 .59227 L
.07738 .58256 L
.07751 .58213 L
.08033 .57284 L
Mistroke
.08354 .56313 L
.08701 .55342 L
.08722 .55285 L
.09075 .54371 L
.09479 .53399 L
.09693 .52912 L
.09914 .52428 L
.10381 .51457 L
.10664 .50902 L
.10884 .50486 L
.11425 .49514 L
.11636 .49156 L
.12008 .48543 L
.12607 .47613 L
.12634 .47572 L
.1331 .46601 L
.13578 .46235 L
.14039 .45629 L
.14549 .44992 L
.14827 .44658 L
.15521 .43863 L
.15681 .43687 L
.16492 .42832 L
.16607 .42716 L
.17463 .41885 L
.17615 .41744 L
.18434 .41012 L
.18714 .40773 L
.19406 .40205 L
.19918 .39802 L
.20377 .39455 L
.21242 .38831 L
.21348 .38757 L
.22319 .38105 L
.22704 .37859 L
.23291 .37496 L
.24262 .36925 L
.24327 .36888 L
.25233 .3639 L
.26143 .35917 L
.26204 .35886 L
.27176 .35412 L
.28147 .34965 L
.28189 .34946 L
.29118 .34543 L
.30089 .34145 L
.30522 .33974 L
.31061 .33768 L
.32032 .33412 L
.33003 .33075 L
Mistroke
.33218 .33003 L
.33974 .32756 L
.34946 .32454 L
.35917 .32168 L
.36397 .32032 L
.36888 .31897 L
.37859 .3164 L
.38831 .31397 L
.39802 .31166 L
.40267 .31061 L
.40773 .30948 L
.41744 .30742 L
.42716 .30547 L
.43687 .30364 L
.44658 .3019 L
.4525 .30089 L
.45629 .30027 L
.46601 .29873 L
.47572 .29729 L
.48543 .29594 L
.49514 .29468 L
.50486 .29351 L
.51457 .29242 L
.52428 .29141 L
.52666 .29118 L
.53399 .29049 L
.54371 .28965 L
.55342 .28889 L
.56313 .28821 L
.57284 .28761 L
.58256 .28709 L
.59227 .28664 L
.60198 .28627 L
.61169 .28599 L
.62141 .28578 L
.63112 .28565 L
.64083 .2856 L
.65054 .28563 L
.66026 .28575 L
.66997 .28596 L
.67968 .28625 L
.68939 .28663 L
.69911 .2871 L
.70882 .28767 L
.71853 .28834 L
.72824 .28911 L
.73796 .28999 L
.74767 .29098 L
.74951 .29118 L
.75738 .29209 L
Mistroke
.76709 .29332 L
.77681 .29469 L
.78652 .29619 L
.79623 .29784 L
.80594 .29964 L
.81222 .30089 L
.81566 .30161 L
.82537 .30376 L
.83508 .30611 L
.84479 .30866 L
.8517 .31061 L
.85451 .31143 L
.86422 .31445 L
.87393 .31774 L
.88101 .32032 L
.88364 .32132 L
.89336 .32522 L
.90307 .32948 L
.90426 .33003 L
.91278 .33414 L
.92249 .33924 L
.92341 .33974 L
.93221 .34484 L
.93957 .34946 L
.94192 .351 L
.95163 .35781 L
.95345 .35917 L
.96134 .36537 L
.96552 .36888 L
.97106 .37381 L
.97611 .37859 L
.98077 .38327 L
Mfstroke
.775 g
.98077 .77494 m
.97985 .77681 L
.97475 .78652 L
.97106 .793 L
.96912 .79623 L
.96288 .80594 L
.96134 .80819 L
.95596 .81566 L
.95163 .82125 L
.94827 .82537 L
.94192 .83265 L
.93968 .83508 L
.93221 .84272 L
.93006 .84479 L
.92249 .85169 L
.91921 .85451 L
.91278 .85973 L
.90689 .86422 L
.90307 .86698 L
.89336 .87354 L
.89274 .87393 L
.88364 .8795 L
.87631 .88364 L
.87393 .88493 L
.86422 .88989 L
.85687 .89336 L
.85451 .89443 L
.84479 .89859 L
.83508 .90241 L
.83331 .90307 L
.82537 .90591 L
.81566 .90914 L
.80594 .9121 L
.80361 .91278 L
.79623 .91483 L
.78652 .91734 L
.77681 .91964 L
.76709 .92175 L
.76345 .92249 L
.75738 .92368 L
.74767 .92545 L
.73796 .92706 L
.72824 .92852 L
.71853 .92984 L
.70882 .93104 L
.69911 .9321 L
.69809 .93221 L
.68939 .93305 L
.67968 .93388 L
.66997 .9346 L
.66026 .93521 L
.65054 .93573 L
.64083 .93614 L
.63112 .93645 L
.62141 .93668 L
.61169 .9368 L
.60198 .93684 L
.59227 .93679 L
.58256 .93665 L
.57284 .93642 L
.56313 .93611 L
.55342 .93571 L
.54371 .93522 L
.53399 .93464 L
.52428 .93398 L
.51457 .93323 L
.50486 .93238 L
.50295 .93221 L
.49514 .93145 L
.48543 .93042 L
.47572 .92929 L
.46601 .92807 L
.45629 .92675 L
.44658 .92532 L
.43687 .92378 L
.42925 .92249 L
.42716 .92213 L
.41744 .92036 L
.40773 .91847 L
.39802 .91644 L
.38831 .91428 L
.3819 .91278 L
.37859 .91198 L
.36888 .90952 L
.35917 .9069 L
.34946 .9041 L
.34602 .90307 L
.33974 .90112 L
.33003 .89793 L
.32032 .89452 L
.31715 .89336 L
.31061 .89087 L
.30089 .88696 L
.29318 .88364 L
.29118 .88275 L
.28147 .87823 L
.2729 .87393 L
.27176 .87334 L
.26204 .86804 L
.25551 .86422 L
.25233 .86228 L
.24262 .85598 L
.24048 .85451 L
.23291 .84905 L
.2274 .84479 L
.22319 .84137 L
.21598 .83508 L
.21348 .83277 L
.20598 .82537 L
.20377 .82304 L
.19721 .81566 L
.19406 .81182 L
.18953 .80594 L
.18434 .79857 L
.18281 .79623 L
.17694 .78652 L
.17463 .7823 L
.17184 .77681 L
.16743 .76709 L
.16492 .7608 L
.16366 .75738 L
.16047 .74767 L
.15782 .73796 L
.15566 .72824 L
.15521 .72594 L
.15396 .71853 L
.15269 .70882 L
.15183 .69911 L
.15137 .68939 L
.15127 .67968 L
.15153 .66997 L
.15213 .66026 L
.15308 .65054 L
.15435 .64083 L
.15521 .63535 L
.15595 .63112 L
.15787 .62141 L
.16013 .61169 L
.16271 .60198 L
.16492 .59451 L
.16562 .59227 L
.16888 .58256 L
.1725 .57284 L
.17463 .56752 L
.17647 .56313 L
.18084 .55342 L
.18434 .54619 L
.1856 .54371 L
.19079 .53399 L
.19406 .52827 L
.19643 .52428 L
.20255 .51457 L
.20377 .51273 L
.20919 .50486 L
.21348 .49898 L
.2164 .49514 L
.22319 .48666 L
.22422 .48543 L
.23271 .47572 L
.23291 .4755 L
.24194 .46601 L
.24262 .46533 L
.252 .45629 L
.25233 .45599 L
.26204 .44738 L
.26298 .44658 L
.27176 .43941 L
.27501 .43687 L
.28147 .432 L
.28823 .42716 L
.29118 .42511 L
.30089 .41867 L
.30282 .41744 L
.31061 .41265 L
.31903 .40773 L
.32032 .40701 L
.33003 .40171 L
.33717 .39802 L
.33974 .39673 L
.34946 .39205 L
.35767 .38831 L
.35917 .38764 L
.36888 .38349 L
.37859 .37958 L
.38112 .37859 L
.38831 .37589 L
.39802 .37241 L
.40773 .36913 L
.40849 .36888 L
.41744 .36604 L
.42716 .36313 L
.43687 .36038 L
.44137 .35917 L
.44658 .3578 L
.45629 .35538 L
.46601 .3531 L
.47572 .35097 L
.48303 .34946 L
.48543 .34898 L
.49514 .34712 L
.50486 .34539 L
.51457 .34378 L
.52428 .3423 L
.53399 .34094 L
.54332 .33974 L
.54371 .3397 L
.55342 .33857 L
.56313 .33756 L
.57284 .33666 L
.58256 .33587 L
.59227 .33519 L
.60198 .33463 L
.61169 .33418 L
.62141 .33384 L
.63112 .33361 L
.64083 .3335 L
.65054 .3335 L
.66026 .33362 L
.66997 .33386 L
.67968 .33422 L
.68939 .3347 L
.69911 .33532 L
.70882 .33607 L
.71853 .33696 L
.72824 .338 L
.73796 .33918 L
.74216 .33974 L
.74767 .34053 L
.75738 .34204 L
.76709 .34372 L
.77681 .34559 L
.78652 .34766 L
.79427 .34946 L
.79623 .34993 L
.80594 .35243 L
.81566 .35518 L
.82537 .35818 L
.82839 .35917 L
.83508 .36146 L
.84479 .36506 L
.85426 .36888 L
.85451 .36898 L
.86422 .37328 L
.87393 .37799 L
.87512 .37859 L
.88364 .38315 L
.89252 .38831 L
.89336 .38882 L
.90307 .39506 L
.90735 .39802 L
.91278 .40197 L
.92018 .40773 L
.92249 .40963 L
.93141 .41744 L
.93221 .41818 L
.94133 .42716 L
.94192 .42778 L
.95013 .43687 L
.95163 .43865 L
.95797 .44658 L
.96134 .45111 L
.965 .45629 L
.97106 .46561 L
.9713 .46601 L
.97696 .47572 L
.98077 .48289 L
F
0 g
.98077 .77494 m
.97985 .77681 L
.97475 .78652 L
.97106 .793 L
.96912 .79623 L
.96288 .80594 L
.96134 .80819 L
.95596 .81566 L
.95163 .82125 L
.94827 .82537 L
.94192 .83265 L
.93968 .83508 L
.93221 .84272 L
.93006 .84479 L
.92249 .85169 L
.91921 .85451 L
.91278 .85973 L
.90689 .86422 L
.90307 .86698 L
.89336 .87354 L
.89274 .87393 L
.88364 .8795 L
.87631 .88364 L
.87393 .88493 L
.86422 .88989 L
.85687 .89336 L
.85451 .89443 L
.84479 .89859 L
.83508 .90241 L
.83331 .90307 L
.82537 .90591 L
.81566 .90914 L
.80594 .9121 L
.80361 .91278 L
.79623 .91483 L
.78652 .91734 L
.77681 .91964 L
.76709 .92175 L
.76345 .92249 L
.75738 .92368 L
.74767 .92545 L
.73796 .92706 L
.72824 .92852 L
.71853 .92984 L
.70882 .93104 L
.69911 .9321 L
.69809 .93221 L
.68939 .93305 L
.67968 .93388 L
.66997 .9346 L
Mistroke
.66026 .93521 L
.65054 .93573 L
.64083 .93614 L
.63112 .93645 L
.62141 .93668 L
.61169 .9368 L
.60198 .93684 L
.59227 .93679 L
.58256 .93665 L
.57284 .93642 L
.56313 .93611 L
.55342 .93571 L
.54371 .93522 L
.53399 .93464 L
.52428 .93398 L
.51457 .93323 L
.50486 .93238 L
.50295 .93221 L
.49514 .93145 L
.48543 .93042 L
.47572 .92929 L
.46601 .92807 L
.45629 .92675 L
.44658 .92532 L
.43687 .92378 L
.42925 .92249 L
.42716 .92213 L
.41744 .92036 L
.40773 .91847 L
.39802 .91644 L
.38831 .91428 L
.3819 .91278 L
.37859 .91198 L
.36888 .90952 L
.35917 .9069 L
.34946 .9041 L
.34602 .90307 L
.33974 .90112 L
.33003 .89793 L
.32032 .89452 L
.31715 .89336 L
.31061 .89087 L
.30089 .88696 L
.29318 .88364 L
.29118 .88275 L
.28147 .87823 L
.2729 .87393 L
.27176 .87334 L
.26204 .86804 L
.25551 .86422 L
Mistroke
.25233 .86228 L
.24262 .85598 L
.24048 .85451 L
.23291 .84905 L
.2274 .84479 L
.22319 .84137 L
.21598 .83508 L
.21348 .83277 L
.20598 .82537 L
.20377 .82304 L
.19721 .81566 L
.19406 .81182 L
.18953 .80594 L
.18434 .79857 L
.18281 .79623 L
.17694 .78652 L
.17463 .7823 L
.17184 .77681 L
.16743 .76709 L
.16492 .7608 L
.16366 .75738 L
.16047 .74767 L
.15782 .73796 L
.15566 .72824 L
.15521 .72594 L
.15396 .71853 L
.15269 .70882 L
.15183 .69911 L
.15137 .68939 L
.15127 .67968 L
.15153 .66997 L
.15213 .66026 L
.15308 .65054 L
.15435 .64083 L
.15521 .63535 L
.15595 .63112 L
.15787 .62141 L
.16013 .61169 L
.16271 .60198 L
.16492 .59451 L
.16562 .59227 L
.16888 .58256 L
.1725 .57284 L
.17463 .56752 L
.17647 .56313 L
.18084 .55342 L
.18434 .54619 L
.1856 .54371 L
.19079 .53399 L
.19406 .52827 L
Mistroke
.19643 .52428 L
.20255 .51457 L
.20377 .51273 L
.20919 .50486 L
.21348 .49898 L
.2164 .49514 L
.22319 .48666 L
.22422 .48543 L
.23271 .47572 L
.23291 .4755 L
.24194 .46601 L
.24262 .46533 L
.252 .45629 L
.25233 .45599 L
.26204 .44738 L
.26298 .44658 L
.27176 .43941 L
.27501 .43687 L
.28147 .432 L
.28823 .42716 L
.29118 .42511 L
.30089 .41867 L
.30282 .41744 L
.31061 .41265 L
.31903 .40773 L
.32032 .40701 L
.33003 .40171 L
.33717 .39802 L
.33974 .39673 L
.34946 .39205 L
.35767 .38831 L
.35917 .38764 L
.36888 .38349 L
.37859 .37958 L
.38112 .37859 L
.38831 .37589 L
.39802 .37241 L
.40773 .36913 L
.40849 .36888 L
.41744 .36604 L
.42716 .36313 L
.43687 .36038 L
.44137 .35917 L
.44658 .3578 L
.45629 .35538 L
.46601 .3531 L
.47572 .35097 L
.48303 .34946 L
.48543 .34898 L
.49514 .34712 L
Mistroke
.50486 .34539 L
.51457 .34378 L
.52428 .3423 L
.53399 .34094 L
.54332 .33974 L
.54371 .3397 L
.55342 .33857 L
.56313 .33756 L
.57284 .33666 L
.58256 .33587 L
.59227 .33519 L
.60198 .33463 L
.61169 .33418 L
.62141 .33384 L
.63112 .33361 L
.64083 .3335 L
.65054 .3335 L
.66026 .33362 L
.66997 .33386 L
.67968 .33422 L
.68939 .3347 L
.69911 .33532 L
.70882 .33607 L
.71853 .33696 L
.72824 .338 L
.73796 .33918 L
.74216 .33974 L
.74767 .34053 L
.75738 .34204 L
.76709 .34372 L
.77681 .34559 L
.78652 .34766 L
.79427 .34946 L
.79623 .34993 L
.80594 .35243 L
.81566 .35518 L
.82537 .35818 L
.82839 .35917 L
.83508 .36146 L
.84479 .36506 L
.85426 .36888 L
.85451 .36898 L
.86422 .37328 L
.87393 .37799 L
.87512 .37859 L
.88364 .38315 L
.89252 .38831 L
.89336 .38882 L
.90307 .39506 L
.90735 .39802 L
Mistroke
.91278 .40197 L
.92018 .40773 L
.92249 .40963 L
.93141 .41744 L
.93221 .41818 L
.94133 .42716 L
.94192 .42778 L
.95013 .43687 L
.95163 .43865 L
.95797 .44658 L
.96134 .45111 L
.965 .45629 L
.97106 .46561 L
.9713 .46601 L
.97696 .47572 L
.98077 .48289 L
Mfstroke
.85 g
.59227 .3877 m
.60198 .38687 L
.61169 .3862 L
.62141 .38568 L
.63112 .38532 L
.64083 .38512 L
.65054 .38507 L
.66026 .38518 L
.66997 .38546 L
.67968 .38591 L
.68939 .38653 L
.69911 .38732 L
.70882 .38831 L
.70882 .38831 L
.71853 .38948 L
.72824 .39085 L
.73796 .39244 L
.74767 .39424 L
.75738 .39628 L
.76485 .39802 L
.76709 .39857 L
.77681 .40112 L
.78652 .40396 L
.79623 .40711 L
.79805 .40773 L
.80594 .41058 L
.81566 .41442 L
.82269 .41744 L
.82537 .41866 L
.83508 .42333 L
.84237 .42716 L
.84479 .42849 L
.85451 .43421 L
.85871 .43687 L
.86422 .44054 L
.8726 .44658 L
.87393 .44759 L
.88364 .45548 L
.88458 .45629 L
.89336 .46436 L
.89503 .46601 L
.90307 .47444 L
.90421 .47572 L
.91232 .48543 L
.91278 .48603 L
.9195 .49514 L
.92249 .49957 L
.92586 .50486 L
.93151 .51457 L
.93221 .51585 L
.93651 .52428 L
.94093 .53399 L
.94192 .53635 L
.94481 .54371 L
.9482 .55342 L
.95112 .56313 L
.95163 .56498 L
.95362 .57284 L
.9557 .58256 L
.95739 .59227 L
.95871 .60198 L
.95966 .61169 L
.96026 .62141 L
.96051 .63112 L
.96041 .64083 L
.95996 .65054 L
.95917 .66026 L
.95802 .66997 L
.95651 .67968 L
.95463 .68939 L
.95237 .69911 L
.95163 .70196 L
.9497 .70882 L
.94661 .71853 L
.94307 .72824 L
.94192 .73116 L
.93905 .73796 L
.9345 .74767 L
.93221 .75217 L
.92939 .75738 L
.92364 .76709 L
.92249 .76891 L
.9172 .77681 L
.91278 .78289 L
.90998 .78652 L
.90307 .79486 L
.90186 .79623 L
.89336 .8053 L
.89271 .80594 L
.88364 .81451 L
.88235 .81566 L
.87393 .82272 L
.87055 .82537 L
.86422 .83007 L
.85697 .83508 L
.85451 .8367 L
.84479 .8427 L
.84116 .84479 L
.83508 .84814 L
.82537 .85309 L
.82241 .85451 L
.81566 .8576 L
.80594 .86171 L
.79957 .86422 L
.79623 .86547 L
.78652 .8689 L
.77681 .87204 L
.77046 .87393 L
.76709 .87489 L
.75738 .87749 L
.74767 .87985 L
.73796 .882 L
.72974 .88364 L
.72824 .88393 L
.71853 .88567 L
.70882 .88722 L
.69911 .8886 L
.68939 .88981 L
.67968 .89086 L
.66997 .89175 L
.66026 .8925 L
.65054 .8931 L
.64572 .89336 L
.64083 .89357 L
.63112 .8939 L
.62141 .8941 L
.61169 .89416 L
.60198 .8941 L
.59227 .89391 L
.58256 .8936 L
.57681 .89336 L
.57284 .89316 L
.56313 .89259 L
.55342 .89189 L
.54371 .89107 L
.53399 .89012 L
.52428 .88903 L
.51457 .88781 L
.50486 .88645 L
.49514 .88494 L
.48744 .88364 L
.48543 .88329 L
.47572 .88148 L
.46601 .87951 L
.45629 .87738 L
.44658 .87506 L
.4421 .87393 L
.43687 .87256 L
.42716 .86986 L
.41744 .86694 L
.40901 .86422 L
.40773 .86379 L
.39802 .86039 L
.38831 .85673 L
.38278 .85451 L
.37859 .85276 L
.36888 .84847 L
.36115 .84479 L
.35917 .84381 L
.34946 .83875 L
.34291 .83508 L
.33974 .83322 L
.33003 .82716 L
.32734 .82537 L
.32032 .82047 L
.31391 .81566 L
.31061 .81304 L
.30226 .80594 L
.30089 .80471 L
.29214 .79623 L
.29118 .79523 L
.28334 .78652 L
.28147 .78427 L
.27568 .77681 L
.27176 .77123 L
.26905 .76709 L
.26333 .75738 L
.26204 .75498 L
.25843 .74767 L
.25429 .73796 L
.25233 .7327 L
.25084 .72824 L
.24802 .71853 L
.2458 .70882 L
.24415 .69911 L
.24302 .68939 L
.24262 .68406 L
.2424 .67968 L
.24227 .66997 L
.2426 .66026 L
.24262 .65986 L
.24339 .65054 L
.24464 .64083 L
.24633 .63112 L
.24846 .62141 L
.25104 .61169 L
.25233 .60739 L
.25408 .60198 L
.25758 .59227 L
.26155 .58256 L
.26204 .58143 L
.26602 .57284 L
.271 .56313 L
.27176 .56174 L
.27652 .55342 L
.28147 .54547 L
.28262 .54371 L
.28934 .53399 L
.29118 .53148 L
.29671 .52428 L
.30089 .51916 L
.30481 .51457 L
.31061 .50813 L
.3137 .50486 L
.32032 .49817 L
.32346 .49514 L
.33003 .48909 L
.3342 .48543 L
.33974 .48076 L
.34604 .47572 L
.34946 .47309 L
.35915 .46601 L
.35917 .46599 L
.36888 .45941 L
.37373 .45629 L
.37859 .45329 L
.38831 .44758 L
.39008 .44658 L
.39802 .44226 L
.40773 .43729 L
.40858 .43687 L
.41744 .43264 L
.42716 .42829 L
.4298 .42716 L
.43687 .42422 L
.44658 .42042 L
.45466 .41744 L
.45629 .41686 L
.46601 .41354 L
.47572 .41044 L
.48478 .40773 L
.48543 .40755 L
.49514 .40486 L
.50486 .40236 L
.51457 .40005 L
.52384 .39802 L
.52428 .39793 L
.53399 .39597 L
.54371 .39419 L
.55342 .39257 L
.56313 .39112 L
.57284 .38982 L
.58256 .38868 L
.58609 .38831 L
F
0 g
.59227 .3877 m
.60198 .38687 L
.61169 .3862 L
.62141 .38568 L
.63112 .38532 L
.64083 .38512 L
.65054 .38507 L
.66026 .38518 L
.66997 .38546 L
.67968 .38591 L
.68939 .38653 L
.69911 .38732 L
.70882 .38831 L
.70882 .38831 L
.71853 .38948 L
.72824 .39085 L
.73796 .39244 L
.74767 .39424 L
.75738 .39628 L
.76485 .39802 L
.76709 .39857 L
.77681 .40112 L
.78652 .40396 L
.79623 .40711 L
.79805 .40773 L
.80594 .41058 L
.81566 .41442 L
.82269 .41744 L
.82537 .41866 L
.83508 .42333 L
.84237 .42716 L
.84479 .42849 L
.85451 .43421 L
.85871 .43687 L
.86422 .44054 L
.8726 .44658 L
.87393 .44759 L
.88364 .45548 L
.88458 .45629 L
.89336 .46436 L
.89503 .46601 L
.90307 .47444 L
.90421 .47572 L
.91232 .48543 L
.91278 .48603 L
.9195 .49514 L
.92249 .49957 L
.92586 .50486 L
.93151 .51457 L
.93221 .51585 L
Mistroke
.93651 .52428 L
.94093 .53399 L
.94192 .53635 L
.94481 .54371 L
.9482 .55342 L
.95112 .56313 L
.95163 .56498 L
.95362 .57284 L
.9557 .58256 L
.95739 .59227 L
.95871 .60198 L
.95966 .61169 L
.96026 .62141 L
.96051 .63112 L
.96041 .64083 L
.95996 .65054 L
.95917 .66026 L
.95802 .66997 L
.95651 .67968 L
.95463 .68939 L
.95237 .69911 L
.95163 .70196 L
.9497 .70882 L
.94661 .71853 L
.94307 .72824 L
.94192 .73116 L
.93905 .73796 L
.9345 .74767 L
.93221 .75217 L
.92939 .75738 L
.92364 .76709 L
.92249 .76891 L
.9172 .77681 L
.91278 .78289 L
.90998 .78652 L
.90307 .79486 L
.90186 .79623 L
.89336 .8053 L
.89271 .80594 L
.88364 .81451 L
.88235 .81566 L
.87393 .82272 L
.87055 .82537 L
.86422 .83007 L
.85697 .83508 L
.85451 .8367 L
.84479 .8427 L
.84116 .84479 L
.83508 .84814 L
.82537 .85309 L
Mistroke
.82241 .85451 L
.81566 .8576 L
.80594 .86171 L
.79957 .86422 L
.79623 .86547 L
.78652 .8689 L
.77681 .87204 L
.77046 .87393 L
.76709 .87489 L
.75738 .87749 L
.74767 .87985 L
.73796 .882 L
.72974 .88364 L
.72824 .88393 L
.71853 .88567 L
.70882 .88722 L
.69911 .8886 L
.68939 .88981 L
.67968 .89086 L
.66997 .89175 L
.66026 .8925 L
.65054 .8931 L
.64572 .89336 L
.64083 .89357 L
.63112 .8939 L
.62141 .8941 L
.61169 .89416 L
.60198 .8941 L
.59227 .89391 L
.58256 .8936 L
.57681 .89336 L
.57284 .89316 L
.56313 .89259 L
.55342 .89189 L
.54371 .89107 L
.53399 .89012 L
.52428 .88903 L
.51457 .88781 L
.50486 .88645 L
.49514 .88494 L
.48744 .88364 L
.48543 .88329 L
.47572 .88148 L
.46601 .87951 L
.45629 .87738 L
.44658 .87506 L
.4421 .87393 L
.43687 .87256 L
.42716 .86986 L
.41744 .86694 L
Mistroke
.40901 .86422 L
.40773 .86379 L
.39802 .86039 L
.38831 .85673 L
.38278 .85451 L
.37859 .85276 L
.36888 .84847 L
.36115 .84479 L
.35917 .84381 L
.34946 .83875 L
.34291 .83508 L
.33974 .83322 L
.33003 .82716 L
.32734 .82537 L
.32032 .82047 L
.31391 .81566 L
.31061 .81304 L
.30226 .80594 L
.30089 .80471 L
.29214 .79623 L
.29118 .79523 L
.28334 .78652 L
.28147 .78427 L
.27568 .77681 L
.27176 .77123 L
.26905 .76709 L
.26333 .75738 L
.26204 .75498 L
.25843 .74767 L
.25429 .73796 L
.25233 .7327 L
.25084 .72824 L
.24802 .71853 L
.2458 .70882 L
.24415 .69911 L
.24302 .68939 L
.24262 .68406 L
.2424 .67968 L
.24227 .66997 L
.2426 .66026 L
.24262 .65986 L
.24339 .65054 L
.24464 .64083 L
.24633 .63112 L
.24846 .62141 L
.25104 .61169 L
.25233 .60739 L
.25408 .60198 L
.25758 .59227 L
.26155 .58256 L
Mistroke
.26204 .58143 L
.26602 .57284 L
.271 .56313 L
.27176 .56174 L
.27652 .55342 L
.28147 .54547 L
.28262 .54371 L
.28934 .53399 L
.29118 .53148 L
.29671 .52428 L
.30089 .51916 L
.30481 .51457 L
.31061 .50813 L
.3137 .50486 L
.32032 .49817 L
.32346 .49514 L
.33003 .48909 L
.3342 .48543 L
.33974 .48076 L
.34604 .47572 L
.34946 .47309 L
.35915 .46601 L
.35917 .46599 L
.36888 .45941 L
.37373 .45629 L
.37859 .45329 L
.38831 .44758 L
.39008 .44658 L
.39802 .44226 L
.40773 .43729 L
.40858 .43687 L
.41744 .43264 L
.42716 .42829 L
.4298 .42716 L
.43687 .42422 L
.44658 .42042 L
.45466 .41744 L
.45629 .41686 L
.46601 .41354 L
.47572 .41044 L
.48478 .40773 L
.48543 .40755 L
.49514 .40486 L
.50486 .40236 L
.51457 .40005 L
.52384 .39802 L
.52428 .39793 L
.53399 .39597 L
.54371 .39419 L
.55342 .39257 L
Mistroke
.56313 .39112 L
.57284 .38982 L
.58256 .38868 L
.58609 .38831 L
.59227 .3877 L
Mfstroke
.25 g
.8854 .01923 m
.88364 .01993 L
.87393 .02359 L
.86422 .02689 L
.85766 .02894 L
.85451 .02988 L
.84479 .0326 L
.83508 .03506 L
.82537 .03731 L
.8191 .03866 L
.81566 .03936 L
.80594 .04123 L
.79623 .04294 L
.78652 .0445 L
.77681 .04593 L
.76709 .04722 L
.75769 .04837 L
.75738 .0484 L
.74767 .04948 L
.73796 .05045 L
.72824 .05133 L
.71853 .05211 L
.70882 .05282 L
.69911 .05344 L
.68939 .05399 L
.67968 .05447 L
.66997 .05488 L
.66026 .05522 L
.65054 .0555 L
.64083 .05572 L
.63112 .05588 L
.62141 .05599 L
.61169 .05604 L
.60198 .05603 L
.59227 .05597 L
.58256 .05586 L
.57284 .0557 L
.56313 .05549 L
.55342 .05523 L
.54371 .05492 L
.53399 .05457 L
.52428 .05416 L
.51457 .05371 L
.50486 .0532 L
.49514 .05265 L
.48543 .05205 L
.47572 .0514 L
.46601 .05071 L
.45629 .04996 L
.44658 .04916 L
.43744 .04837 L
.43687 .04832 L
.42716 .04742 L
.41744 .04647 L
.40773 .04546 L
.39802 .0444 L
.38831 .04329 L
.37859 .04212 L
.36888 .04089 L
.35917 .0396 L
.35229 .03866 L
.34946 .03826 L
.33974 .03685 L
.33003 .03537 L
.32032 .03383 L
.31061 .03222 L
.30089 .03055 L
.29199 .02894 L
.29118 .0288 L
.28147 .02697 L
.27176 .02507 L
.26204 .02309 L
.25233 .02103 L
.24414 .01923 L
F
0 g
.8854 .01923 m
.88364 .01993 L
.87393 .02359 L
.86422 .02689 L
.85766 .02894 L
.85451 .02988 L
.84479 .0326 L
.83508 .03506 L
.82537 .03731 L
.8191 .03866 L
.81566 .03936 L
.80594 .04123 L
.79623 .04294 L
.78652 .0445 L
.77681 .04593 L
.76709 .04722 L
.75769 .04837 L
.75738 .0484 L
.74767 .04948 L
.73796 .05045 L
.72824 .05133 L
.71853 .05211 L
.70882 .05282 L
.69911 .05344 L
.68939 .05399 L
.67968 .05447 L
.66997 .05488 L
.66026 .05522 L
.65054 .0555 L
.64083 .05572 L
.63112 .05588 L
.62141 .05599 L
.61169 .05604 L
.60198 .05603 L
.59227 .05597 L
.58256 .05586 L
.57284 .0557 L
.56313 .05549 L
.55342 .05523 L
.54371 .05492 L
.53399 .05457 L
.52428 .05416 L
.51457 .05371 L
.50486 .0532 L
.49514 .05265 L
.48543 .05205 L
.47572 .0514 L
.46601 .05071 L
.45629 .04996 L
.44658 .04916 L
Mistroke
.43744 .04837 L
.43687 .04832 L
.42716 .04742 L
.41744 .04647 L
.40773 .04546 L
.39802 .0444 L
.38831 .04329 L
.37859 .04212 L
.36888 .04089 L
.35917 .0396 L
.35229 .03866 L
.34946 .03826 L
.33974 .03685 L
.33003 .03537 L
.32032 .03383 L
.31061 .03222 L
.30089 .03055 L
.29199 .02894 L
.29118 .0288 L
.28147 .02697 L
.27176 .02507 L
.26204 .02309 L
.25233 .02103 L
.24414 .01923 L
Mfstroke
.925 g
.60198 .44649 m
.61169 .44549 L
.62141 .44471 L
.63112 .44415 L
.64083 .44382 L
.65054 .44371 L
.66026 .44382 L
.66997 .44417 L
.67968 .44476 L
.68939 .4456 L
.69825 .44658 L
.69911 .44669 L
.70882 .44805 L
.71853 .44968 L
.72824 .45162 L
.73796 .45386 L
.74715 .45629 L
.74767 .45644 L
.75738 .45938 L
.76709 .46271 L
.77568 .46601 L
.77681 .46646 L
.78652 .47069 L
.79623 .47544 L
.79677 .47572 L
.80594 .48078 L
.81355 .48543 L
.81566 .4868 L
.82537 .49359 L
.82742 .49514 L
.83508 .50132 L
.83912 .50486 L
.84479 .51018 L
.84912 .51457 L
.85451 .52048 L
.85773 .52428 L
.86422 .53267 L
.86517 .53399 L
.87161 .54371 L
.87393 .54758 L
.87717 .55342 L
.88194 .56313 L
.88364 .56701 L
.88599 .57284 L
.88939 .58256 L
.89218 .59227 L
.89336 .5971 L
.89439 .60198 L
.89605 .61169 L
.89718 .62141 L
.8978 .63112 L
.89792 .64083 L
.89753 .65054 L
.89664 .66026 L
.89523 .66997 L
.89336 .67941 L
.89329 .67968 L
.89081 .68939 L
.88776 .69911 L
.8841 .70882 L
.88364 .70992 L
.87978 .71853 L
.87476 .72824 L
.87393 .72972 L
.86895 .73796 L
.86422 .74498 L
.86228 .74767 L
.85462 .75738 L
.85451 .75751 L
.84581 .76709 L
.84479 .76813 L
.83567 .77681 L
.83508 .77733 L
.82537 .78538 L
.8239 .78652 L
.81566 .79251 L
.8101 .79623 L
.80594 .79886 L
.79623 .80454 L
.79365 .80594 L
.78652 .80963 L
.77681 .81421 L
.77352 .81566 L
.76709 .81833 L
.75738 .82204 L
.74767 .82537 L
.74767 .82537 L
.73796 .82835 L
.72824 .83102 L
.71853 .83339 L
.71077 .83508 L
.70882 .83548 L
.69911 .83731 L
.68939 .8389 L
.67968 .84025 L
.66997 .84138 L
.66026 .84229 L
.65054 .843 L
.64083 .8435 L
.63112 .84381 L
.62141 .84392 L
.61169 .84384 L
.60198 .84357 L
.59227 .84311 L
.58256 .84245 L
.57284 .84161 L
.56313 .84057 L
.55342 .83933 L
.54371 .83789 L
.53399 .83623 L
.52789 .83508 L
.52428 .83436 L
.51457 .83225 L
.50486 .8299 L
.49514 .8273 L
.48854 .82537 L
.48543 .82441 L
.47572 .82124 L
.46601 .81774 L
.46064 .81566 L
.45629 .81389 L
.44658 .80965 L
.43882 .80594 L
.43687 .80497 L
.42716 .79979 L
.42102 .79623 L
.41744 .79404 L
.40773 .78762 L
.40618 .78652 L
.39802 .78038 L
.39365 .77681 L
.38831 .77214 L
.38299 .76709 L
.37859 .76258 L
.37392 .75738 L
.36888 .75122 L
.36621 .74767 L
.35969 .73796 L
.35917 .7371 L
.35423 .72824 L
.34973 .71853 L
.34946 .71787 L
.34611 .70882 L
.34329 .69911 L
.34123 .68939 L
.33988 .67968 L
.33974 .67827 L
.33921 .66997 L
.3392 .66026 L
.33974 .65145 L
.33983 .65054 L
.34108 .64083 L
.34295 .63112 L
.34545 .62141 L
.34857 .61169 L
.34946 .60925 L
.35234 .60198 L
.35677 .59227 L
.35917 .58756 L
.3619 .58256 L
.36776 .57284 L
.36888 .57111 L
.3744 .56313 L
.37859 .55754 L
.38188 .55342 L
.38831 .54588 L
.39028 .54371 L
.39802 .53564 L
.3997 .53399 L
.40773 .52651 L
.41027 .52428 L
.41744 .51828 L
.42216 .51457 L
.42716 .51082 L
.4356 .50486 L
.43687 .504 L
.44658 .49776 L
.45092 .49514 L
.45629 .49203 L
.46601 .48676 L
.46858 .48543 L
.47572 .4819 L
.48543 .47743 L
.48937 .47572 L
.49514 .47331 L
.50486 .46952 L
.51457 .46604 L
.51466 .46601 L
.52428 .46285 L
.53399 .45994 L
.54371 .45729 L
.54763 .45629 L
.55342 .4549 L
.56313 .45275 L
.57284 .45084 L
.58256 .44916 L
.59227 .44772 L
.60121 .44658 L
F
0 g
.60198 .44649 m
.61169 .44549 L
.62141 .44471 L
.63112 .44415 L
.64083 .44382 L
.65054 .44371 L
.66026 .44382 L
.66997 .44417 L
.67968 .44476 L
.68939 .4456 L
.69825 .44658 L
.69911 .44669 L
.70882 .44805 L
.71853 .44968 L
.72824 .45162 L
.73796 .45386 L
.74715 .45629 L
.74767 .45644 L
.75738 .45938 L
.76709 .46271 L
.77568 .46601 L
.77681 .46646 L
.78652 .47069 L
.79623 .47544 L
.79677 .47572 L
.80594 .48078 L
.81355 .48543 L
.81566 .4868 L
.82537 .49359 L
.82742 .49514 L
.83508 .50132 L
.83912 .50486 L
.84479 .51018 L
.84912 .51457 L
.85451 .52048 L
.85773 .52428 L
.86422 .53267 L
.86517 .53399 L
.87161 .54371 L
.87393 .54758 L
.87717 .55342 L
.88194 .56313 L
.88364 .56701 L
.88599 .57284 L
.88939 .58256 L
.89218 .59227 L
.89336 .5971 L
.89439 .60198 L
.89605 .61169 L
.89718 .62141 L
Mistroke
.8978 .63112 L
.89792 .64083 L
.89753 .65054 L
.89664 .66026 L
.89523 .66997 L
.89336 .67941 L
.89329 .67968 L
.89081 .68939 L
.88776 .69911 L
.8841 .70882 L
.88364 .70992 L
.87978 .71853 L
.87476 .72824 L
.87393 .72972 L
.86895 .73796 L
.86422 .74498 L
.86228 .74767 L
.85462 .75738 L
.85451 .75751 L
.84581 .76709 L
.84479 .76813 L
.83567 .77681 L
.83508 .77733 L
.82537 .78538 L
.8239 .78652 L
.81566 .79251 L
.8101 .79623 L
.80594 .79886 L
.79623 .80454 L
.79365 .80594 L
.78652 .80963 L
.77681 .81421 L
.77352 .81566 L
.76709 .81833 L
.75738 .82204 L
.74767 .82537 L
.74767 .82537 L
.73796 .82835 L
.72824 .83102 L
.71853 .83339 L
.71077 .83508 L
.70882 .83548 L
.69911 .83731 L
.68939 .8389 L
.67968 .84025 L
.66997 .84138 L
.66026 .84229 L
.65054 .843 L
.64083 .8435 L
.63112 .84381 L
Mistroke
.62141 .84392 L
.61169 .84384 L
.60198 .84357 L
.59227 .84311 L
.58256 .84245 L
.57284 .84161 L
.56313 .84057 L
.55342 .83933 L
.54371 .83789 L
.53399 .83623 L
.52789 .83508 L
.52428 .83436 L
.51457 .83225 L
.50486 .8299 L
.49514 .8273 L
.48854 .82537 L
.48543 .82441 L
.47572 .82124 L
.46601 .81774 L
.46064 .81566 L
.45629 .81389 L
.44658 .80965 L
.43882 .80594 L
.43687 .80497 L
.42716 .79979 L
.42102 .79623 L
.41744 .79404 L
.40773 .78762 L
.40618 .78652 L
.39802 .78038 L
.39365 .77681 L
.38831 .77214 L
.38299 .76709 L
.37859 .76258 L
.37392 .75738 L
.36888 .75122 L
.36621 .74767 L
.35969 .73796 L
.35917 .7371 L
.35423 .72824 L
.34973 .71853 L
.34946 .71787 L
.34611 .70882 L
.34329 .69911 L
.34123 .68939 L
.33988 .67968 L
.33974 .67827 L
.33921 .66997 L
.3392 .66026 L
.33974 .65145 L
Mistroke
.33983 .65054 L
.34108 .64083 L
.34295 .63112 L
.34545 .62141 L
.34857 .61169 L
.34946 .60925 L
.35234 .60198 L
.35677 .59227 L
.35917 .58756 L
.3619 .58256 L
.36776 .57284 L
.36888 .57111 L
.3744 .56313 L
.37859 .55754 L
.38188 .55342 L
.38831 .54588 L
.39028 .54371 L
.39802 .53564 L
.3997 .53399 L
.40773 .52651 L
.41027 .52428 L
.41744 .51828 L
.42216 .51457 L
.42716 .51082 L
.4356 .50486 L
.43687 .504 L
.44658 .49776 L
.45092 .49514 L
.45629 .49203 L
.46601 .48676 L
.46858 .48543 L
.47572 .4819 L
.48543 .47743 L
.48937 .47572 L
.49514 .47331 L
.50486 .46952 L
.51457 .46604 L
.51466 .46601 L
.52428 .46285 L
.53399 .45994 L
.54371 .45729 L
.54763 .45629 L
.55342 .4549 L
.56313 .45275 L
.57284 .45084 L
.58256 .44916 L
.59227 .44772 L
.60121 .44658 L
.60198 .44649 L
Mfstroke
1 g
.60198 .52375 m
.61169 .52205 L
.62141 .52072 L
.63112 .51978 L
.64083 .51921 L
.65054 .51902 L
.66026 .51921 L
.66997 .5198 L
.67968 .5208 L
.68939 .52222 L
.69911 .5241 L
.69992 .52428 L
.70882 .52647 L
.71853 .52937 L
.72824 .53287 L
.73104 .53399 L
.73796 .53703 L
.74767 .54196 L
.75075 .54371 L
.75738 .5478 L
.76535 .55342 L
.76709 .55476 L
.77677 .56313 L
.77681 .56316 L
.78591 .57284 L
.78652 .57357 L
.79327 .58256 L
.79623 .58714 L
.79917 .59227 L
.80381 .60198 L
.80594 .60743 L
.80734 .61169 L
.80986 .62141 L
.81143 .63112 L
.81209 .64083 L
.81186 .65054 L
.81075 .66026 L
.80872 .66997 L
.80594 .67915 L
.80575 .67968 L
.80176 .68939 L
.79667 .69911 L
.79623 .69986 L
.79034 .70882 L
.78652 .71385 L
.78258 .71853 L
.77681 .72468 L
.77309 .72824 L
.76709 .7335 L
.76144 .73796 L
.75738 .7409 L
.74767 .7472 L
.74688 .74767 L
.73796 .7526 L
.72824 .75725 L
.72795 .75738 L
.71853 .76126 L
.70882 .7647 L
.70098 .76709 L
.69911 .76762 L
.68939 .77008 L
.67968 .77211 L
.66997 .77373 L
.66026 .77497 L
.65054 .77585 L
.64083 .77637 L
.63112 .77655 L
.62141 .77639 L
.61169 .77588 L
.60198 .77502 L
.59227 .77381 L
.58256 .77223 L
.57284 .77027 L
.56313 .76789 L
.56021 .76709 L
.55342 .76507 L
.54371 .76177 L
.53399 .75792 L
.53273 .75738 L
.52428 .75346 L
.51457 .74826 L
.51355 .74767 L
.50486 .74219 L
.49894 .73796 L
.49514 .735 L
.48745 .72824 L
.48543 .72629 L
.47832 .71853 L
.47572 .71531 L
.47109 .70882 L
.46601 .70016 L
.46547 .69911 L
.46126 .68939 L
.4583 .67968 L
.45651 .66997 L
.45629 .66813 L
.45581 .66026 L
.45615 .65054 L
.45629 .64909 L
.45752 .64083 L
.45992 .63112 L
.46335 .62141 L
.46601 .61537 L
.46786 .61169 L
.47352 .60198 L
.47572 .59867 L
.48042 .59227 L
.48543 .58618 L
.4887 .58256 L
.49514 .57603 L
.49858 .57284 L
.50486 .56746 L
.51038 .56313 L
.51457 .56007 L
.52428 .55362 L
.5246 .55342 L
.53399 .54795 L
.54215 .54371 L
.54371 .54295 L
.55342 .53854 L
.56313 .53467 L
.56497 .53399 L
.57284 .53129 L
.58256 .52835 L
.59227 .52585 L
.59934 .52428 L
F
0 g
.60198 .52375 m
.61169 .52205 L
.62141 .52072 L
.63112 .51978 L
.64083 .51921 L
.65054 .51902 L
.66026 .51921 L
.66997 .5198 L
.67968 .5208 L
.68939 .52222 L
.69911 .5241 L
.69992 .52428 L
.70882 .52647 L
.71853 .52937 L
.72824 .53287 L
.73104 .53399 L
.73796 .53703 L
.74767 .54196 L
.75075 .54371 L
.75738 .5478 L
.76535 .55342 L
.76709 .55476 L
.77677 .56313 L
.77681 .56316 L
.78591 .57284 L
.78652 .57357 L
.79327 .58256 L
.79623 .58714 L
.79917 .59227 L
.80381 .60198 L
.80594 .60743 L
.80734 .61169 L
.80986 .62141 L
.81143 .63112 L
.81209 .64083 L
.81186 .65054 L
.81075 .66026 L
.80872 .66997 L
.80594 .67915 L
.80575 .67968 L
.80176 .68939 L
.79667 .69911 L
.79623 .69986 L
.79034 .70882 L
.78652 .71385 L
.78258 .71853 L
.77681 .72468 L
.77309 .72824 L
.76709 .7335 L
.76144 .73796 L
Mistroke
.75738 .7409 L
.74767 .7472 L
.74688 .74767 L
.73796 .7526 L
.72824 .75725 L
.72795 .75738 L
.71853 .76126 L
.70882 .7647 L
.70098 .76709 L
.69911 .76762 L
.68939 .77008 L
.67968 .77211 L
.66997 .77373 L
.66026 .77497 L
.65054 .77585 L
.64083 .77637 L
.63112 .77655 L
.62141 .77639 L
.61169 .77588 L
.60198 .77502 L
.59227 .77381 L
.58256 .77223 L
.57284 .77027 L
.56313 .76789 L
.56021 .76709 L
.55342 .76507 L
.54371 .76177 L
.53399 .75792 L
.53273 .75738 L
.52428 .75346 L
.51457 .74826 L
.51355 .74767 L
.50486 .74219 L
.49894 .73796 L
.49514 .735 L
.48745 .72824 L
.48543 .72629 L
.47832 .71853 L
.47572 .71531 L
.47109 .70882 L
.46601 .70016 L
.46547 .69911 L
.46126 .68939 L
.4583 .67968 L
.45651 .66997 L
.45629 .66813 L
.45581 .66026 L
.45615 .65054 L
.45629 .64909 L
.45752 .64083 L
Mistroke
.45992 .63112 L
.46335 .62141 L
.46601 .61537 L
.46786 .61169 L
.47352 .60198 L
.47572 .59867 L
.48042 .59227 L
.48543 .58618 L
.4887 .58256 L
.49514 .57603 L
.49858 .57284 L
.50486 .56746 L
.51038 .56313 L
.51457 .56007 L
.52428 .55362 L
.5246 .55342 L
.53399 .54795 L
.54215 .54371 L
.54371 .54295 L
.55342 .53854 L
.56313 .53467 L
.56497 .53399 L
.57284 .53129 L
.58256 .52835 L
.59227 .52585 L
.59934 .52428 L
.60198 .52375 L
Mfstroke
.55 g
.98077 .93951 m
.9773 .94192 L
.97106 .94601 L
.96173 .95163 L
.96134 .95185 L
.95163 .95711 L
.94303 .96134 L
.94192 .96187 L
.93221 .96618 L
.92249 .97011 L
.92 .97106 L
.91278 .97368 L
.90307 .97695 L
.89336 .97995 L
.89055 .98077 L
.98077 .98077 L
F
0 g
.98077 .93951 m
.9773 .94192 L
.97106 .94601 L
.96173 .95163 L
.96134 .95185 L
.95163 .95711 L
.94303 .96134 L
.94192 .96187 L
.93221 .96618 L
.92249 .97011 L
.92 .97106 L
.91278 .97368 L
.90307 .97695 L
.89336 .97995 L
.89055 .98077 L
s
0 0 0 r
.055 w
.64443 .65059 Mdot
1 0 0 r
.0325 w
.22807 .01923 Mdot
.01923 .65316 Mdot
.42806 .98077 Mdot
.18303 .78442 Mdot
.98077 .78827 Mdot
.59895 .78643 Mdot
.85255 .55126 Mdot
.70506 .68803 Mdot
.59936 .63174 Mdot
.64182 .65005 Mdot
.64456 .65062 Mdot
.64443 .65059 Mdot
.64443 .65059 Mdot
0 1 0 r
.02 w
.22807 .01923 Mdot
.01923 .65316 Mdot
.42806 .98077 Mdot
.18303 .78442 Mdot
.98077 .78827 Mdot
.59895 .78643 Mdot
.85255 .55126 Mdot
.70506 .68803 Mdot
.59936 .63174 Mdot
.64182 .65005 Mdot
.64456 .65062 Mdot
.64443 .65059 Mdot
.64443 .65059 Mdot
0 0 1 r
.5 Mabswid
.22807 .01923 m
.22807 .01923 L
.01923 .65316 L
.18303 .78442 L
.59895 .78643 L
.70506 .68803 L
.59936 .63174 L
.64182 .65005 L
.64456 .65062 L
.64443 .65059 L
.64443 .65059 L
s
.015 w
.22807 .01923 Mdot
.22807 .01923 Mdot
.01923 .65316 Mdot
.18303 .78442 Mdot
.59895 .78643 Mdot
.70506 .68803 Mdot
.59936 .63174 Mdot
.64182 .65005 Mdot
.64456 .65062 Mdot
.64443 .65059 Mdot
.64443 .65059 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00403oool2000000@0oooo0P0000040?ooo`800000<@3oool500000300oooo1@0000020?oo
o`8000000`3oool4000002/0oooo1@0000020?ooo`8000001@3oool3000002X0oooo1@0000020?oo
o`8000000`3oool3000001L0oooo000?0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool00000<P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0;P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02/0oooo00<00000
0?ooo`3oool01`3oool010000000oooo0?ooo`00000F0?ooo`003`3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000380oooo00<000000?ooo`3oool0<P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool01`3oool5000002`0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000F0?ooo`003`3oool010000000oooo
0?ooo`0000090?ooo`800000<`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo0000
02d0oooo00<000000?ooo`3oool01`3oool3000001L0oooo000?0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool00000<P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0
oooo00L0oooo00@000000?ooo`3oool00000;@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0000002d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F0?ooo`00403oool2
000000X0oooo0P00000b0?ooo`800000<`3oool2000000X0oooo0P00000]0?ooo`8000002`3oool2
000002`0oooo0P00000:0?ooo`<000005P3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`00000;00000040oooo000E0?ooo`03
0000003oool0000000d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`40
00000@3oool001D0oooo00<000000?ooo`000000>@3oool20?l003T0oooo00<000000?ooo`3oool0
>03oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01T0oooo0@0000010?ooo`003@3o
ool5000000<0oooo00<000000?ooo`3oool0=`3oool60?l00<T0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo03L0oooo00@0o`00003o0000o`000?l00P3o
00390?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool2000003L0oooo00<0o`00
003o0000o`000P000?l01000o`00o`000?l00000002Y0?ooo`030000003oool0oooo01X0oooo0P00
00010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo=01CDe<0
0`3o00000?l00000o`020000o`04003o003o0000o`0005=CD`800000YP0o?cl00`000000De=C05=C
D`0G05=CD`D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo=@1CDe<00`00o`00003o0000o`02003o00030?l0001CDe<0De=C0080De=C1P00002M
03lo?`<000006P1CDe<50?ooo`4000000@3oool000h0oooo0P0000050?ooo`030000003oool0oooo
0080oooo=@1CDe<0103o0000003o003o0000o`020?l000X0De=C1`00002A03lo?`D000007@1CDe<5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolf05=CD`030000o`3o0000o`00
01<0De=C1@00002:03lo?`8000008P1CDe<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooole05=CD`030000o`1CDe<0De=C01T0De=C1P00001o03lo?`D00000901CDe<50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool2000003<0De=C00<0003o05=CD`1CDe<0
7`1CDe<700000780?clo1P00000Y05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`80IVIV1@00000^05=CD`030000o`1CDe<0De=C02H0De=C2`00001R03lo?`D00000;`1C
De<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool706IVIP800000:`1CDe<0
0`000?l0De=C05=CD`0b05=CD`X00000D00o?cl8000003@0De=C1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo2@1VIVH3000002P0De=C00<0003o05=CD`1CDe<0?01CDe<=0000
03H0?clo3@00000l05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo``0
IVIV1@00000S05=CD`030000o`1CDe<0De=C04T0De=C=P00001905=CD`D0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?oooa40IVIV1@00000M05=CD`030000o`1CDe<0De=C0<T0De=C
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo5P1VIVH5000001P0De=C00<0
003o05=CD`1CDe<0b@1CDe<00`000000oooo0?ooo`020?ooo`4000000@3oool001D0oooo0P000003
0?oooa/0IVIV1000000D05=CD`030000o`1CDe<0De=C0<H0De=C0`0000040?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolO06IVIPL00000301CDe<00`000?l0De=C05=CD`3505=C
D`8000000`1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolV06IVIPD0
00001`1CDe<00`000?l0De=C05=CD`3205=CD`<000001@1VIVH50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool[06IVIPL0000000<0003o05=CD`1CDe<0_@1CDe<5000000P0IVIV
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo<@1VIVH00`000?l0IVIV0000
000600000;D0De=C0`00000=06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?oooc40IVIV00<0003o06IVIP1VIVH01P1VIVH700000:L0De=C00<0000005=CD`0000001000000@
06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc40IVIV00<0003o06IV
IP1VIVH03@1VIVH;000009H0De=C2000000E06IVIPD0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?oooc00IVIV00<0003o06IVIP1VIVH06@1VIVH=00000880De=C1`00000M06IVIPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc00IVIV00<0003o06IVIP1VIVH0
9P1VIVH@000006D0De=C3@00000T06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?oooc00IVIV00<0003o06IVIP1VIVH0=P1VIVHI000003L0De=C5@00000a06IVIPD0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooc00IVIV00<0003o06IVIP1VIVH0C`1VIVHg
000004H0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;`1VIVH00`00
0?l0IVIV06IVIP3=06IVIPD0oooo0@0000010?ooo`005@3oool2000000<0oooo;`1VIVH00`000?l0
IVIV06IVIP3=06IVIP@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobl0IVIV
00<0003o06IVIP1VIVH0c@1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool^06IVIP030000o`1VIVH0IVIV0<h0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo;P1VIVH00`000?l0IVIV06IVIP3>06IVIPD0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooobh0IVIV00<0003o06IVIP1VIVH0cP1VIVH50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool]06IVIP030000o`1VIVH0IVIV0<l0IVIV1@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo;@1VIVH00`000?l0IVIV06IVIP3?06IVIPD0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobd0IVIV00<0003o06IVIP1VIVH0c`1V
IVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool/06IVIP030000o`1VIVH0
IVIV0=00IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;01VIVH00`00
0?l0IVIV06IVIP3@06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa40
IVIV6`0000000`000?l000000000003A000000@0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooa4000006P1iNGT00`000?l0NGUi07UiN@3A07UiN@D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooob/0NGUi00<0003o07UiN@1iNGT0d@1iNGT50?ooo`4000000@3o
ool001D0oooo0P0000030?ooob/0NGUi00<0003o07UiN@1iNGT0d@1iNGT40?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolZ07UiN@030000o`1iNGT0NGUi0=80NGUi1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo:P1iNGT00`000?l0NGUi07UiN@3B07UiN@D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobX0NGUi00<0003o07UiN@1iNGT0
dP1iNGT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolY07UiN@030000o`1i
NGT0NGUi0=<0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo:@1iNGT0
0`000?l0NGUi07UiN@3C07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
obT0NGUi00<0003o07UiN@1iNGT0d`1iNGT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolX07UiN@030000o`1iNGT0NGUi0=@0NGUi1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo:01iNGT00`000?l0NGUi07UiN@3D07UiN@D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooobP0NGUi00<0003o07UiN@1iNGT0FP1iNGTi00000440NGUi1@3o
ool100000040oooo00000`3oool000000000000300000080oooo0P0000030?ooo`@00000103oool0
0`000000oooo0?ooo`020?ooobL0NGUi00<0003o07UiN@1iNGT0A01iNGTG000003T0S8b<5000000]
07UiN@D0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00P3ooolW07UiN@030000o`1iNGT0NGUi03@0NGUi4000001T08b<
S0`000008@1iNGT50?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`040?ooo`8000000`3ooolW07UiN@030000o`1iNGT0NGUi02P0NGUi3000002008b<S0T0
0000601iNGT40?ooo`8000000@3oool000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo9P1iNGT00`000?l0NGUi07UiN@0Q07UiN@P00000
U@2<S8`5000001<0NGUi1@3oool100000040oooo00030?ooo`030000003oool0oooo00L0oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooobH0NGUi00<0003o07UiN@1iNGT0
6@1iNGT800000:80S8b<1@00000>07UiN@D0oooo0@0000010?ooo`000P3oool2000000X0oooo0P00
00050?ooo`030000003oool0oooo0080oooo9P1iNGT00`000?l0NGUi07UiN@0B07UiN@L00000[`2<
S8`6000000P0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo9@1iNGT0
0`000?l0NGUi07UiN@0<07UiN@L00000_02<S8`4000000@0NGUi1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo9@1iNGT00`000?l0NGUi07UiN@0607UiN@H00000a`2<S8`30000
000307UiN@3oool0oooo00<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobD0
NGUi00@0003o07UiN@1iNGT0NGUi1@00003@08b<S0800000103oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo901iNGT00`000?l0NGUi0000000200000=H0S8b<1@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo8@1iNGT3000000030000o`000000S8b<0=P0S8b<
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7P1iNGT3000000<0S8b<00<0
003o08b<S02<S8`0J@2<S8`Y000004H0S8b<1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo6@1iNGT5000000D0S8b<00<0003o08b<S02<S8`0F02<S8`B000002T0WinO3`00000g
08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0NGUi0P00000:08b<
S0030000o`2<S8`0S8b<04d0S8b<2`00001:09nOW`P00000;`2<S8`50?ooo`4000000@3oool001D0
oooo0P0000030?oooa@0NGUi0`00000<08b<S0030000o`2<S8`0S8b<04D0S8b<2000001M09nOW`P0
00009`2<S8`40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolA07UiN@<00000
3P2<S8`00`000?l0S8b<08b<S00o08b<S0L00000K@2OWil500000280S8b<1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo3`1iNGT200000140S8b<00<0003o08b<S02<S8`0=`2<
S8`8000007T0WinO1@00000M08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo``0NGUi0`00000C08b<S0030000o`2<S8`0S8b<0380S8b<1@00002609nOW`D00000602<S8`5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool:07UiN@8000005P2<S8`00`00
0?l0S8b<08b<S00]08b<S0D00000T02OWil3000001D0S8b<1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo201iNGT2000001L0S8b<00<0003o08b<S02<S8`0:@2<S8`5000009P0
WinO0P00000C08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`L0NGUi
00<0000008b<S02<S8`05`2<S8`00`000?l0S8b<08b<S00V08b<S0@00000WP2OWil300000100S8b<
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1@1iNGT2000001X0S8b<00<0
003o08b<S02<S8`08@2<S8`500000:D0WinO1000000<08b<S0D0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`<0NGUi0P00000K08b<S0030000o`2<S8`0S8b<01l0S8b<0`00002^
09nOW`8000002P2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`1i
NGT000000000000M08b<S0030000o`2<S8`0S8b<01d0S8b<0P00001F09nOWa/00000@P2OWil20000
00P0S8b<1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<0000008b<S02<
S8`07@2<S8`00`000?l0S8b<08b<S00H08b<S0D00000B`2OWil=000001/0/k>c3@00000g09nOW`80
00001P2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolO08b<S0030000
o`2<S8`0S8b<01H0S8b<0`00001509nOW`/00000=@2c/k<800000340WinO0`00000308b<S0D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooal0S8b<00<0003o08b<S02<S8`0502<
S8`200000440WinO1`0000180;>c/`P00000;02OWil20000000308b<S03oool0oooo00<0oooo0@00
00010?ooo`005@3oool2000000<0oooo7`2<S8`00`000?l0S8b<08b<S00A08b<S0<00000?@2OWil6
000005L0/k>c1@00000Y09nOW`030000003oool0oooo0080oooo0P0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooah0S8b<00<0003o08b<S02<S8`03`2<S8`3000003T0WinO1`00001R0;>c
/`<000009`2OWil00`000000oooo0?ooo`020?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolN08b<S0030000o`2<S8`0S8b<00d0S8b<0P00000i09nOW`<00000K02c/k<4000002<0
WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7P2<S8`00`000?l0S8b<
08b<S00;08b<S0800000=P2OWil5000007<0/k>c0`00000P09nOW`D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?oooad0S8b<00<0003o08b<S02<S8`02P2<S8`2000003<0WinO1@00
001k0;>c/`<000007@2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolM
08b<S0030000o`2<S8`0S8b<00L0S8b<0`00000a09nOW`@00000P`2c/k<4000001T0WinO1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo7@2<S8`00`000?l0S8b<08b<S00608b<
S0800000<P2OWil00`000000/k>c0;>c/`280;>c/`800000602OWil50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3ooolL08b<S0030000o`2<S8`0S8b<00D0S8b<0P00000_09nOW`D0
0000S@2c/k<3000001D0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
702<S8`00`000?l0S8b<08b<S00408b<S0030000002OWil0WinO02`0WinO0`00002E0;>c/`800000
4`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolL08b<S0030000o`2<
S8`0S8b<0080S8b<0P00000/09nOW`<00000AP2c/k<N000003H0/k>c0`00000@09nOW`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooa/0S8b<00@0003o08b<S02<S8`0S8b<0P00
000/09nOW`800000?P2c/k<;000001h0a/K62P00000_0;>c/`8000003P2OWil50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolK08b<S0040000o`2<S8`0S8b<000002/0WinO0`00
000h0;>c/`P00000<`36a/H6000002X0/k>c00<0000009nOW`2OWil0302OWil50?ooo`4000000@3o
ool001D0oooo0P0000030?oooa/0S8b<00<0003o000000000000:P2OWil2000003H0/k>c1@000011
0<K6aPD000009P2c/k<2000000`0WinO103oool200000040oooo000E0?ooo`030000003oool0oooo
0080oooo6P2<S8`00`000?l0000009nOW`0X09nOW`<00000<`2c/k<5000004/0a/K61@00000S0;>c
/`8000002P2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolJ08b<S003
0000o`2OWil0WinO02H0WinO0P00000a0;>c/`D00000E@36a/H2000002<0/k>c0P00000809nOW`D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaP0S8b<0P0000000`000?l0WinO
09nOW`0T09nOW`800000;P2c/k<5000005`0a/K61@00000P0;>c/`8000001P2OWil50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolG08b<S0030000002OWil0003o02H0WinO00<0
00000;>c/`2c/k<0:`2c/k<3000006H0a/K60`00000N0;>c/`030000002OWil0WinO00@0WinO1@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo5P2<S8`010000000WinO09nOW`00
0?lS09nOW`<00000;02c/k<2000006`0a/K60`00000L0;>c/`800000102OWil50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolD08b<S08000000`2OWil00`000?l0WinO09nOW`0O
09nOW`800000:P2c/k<500000740a/K60P00000L0;>c/`040000002OWil0WinO09nOW`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooa<0S8b<00<0000009nOW`2OWil00P2OWil0
0`000?l0WinO09nOW`0O09nOW`030000002c/k<0/k>c02L0/k>c0`00001h0<K6aP030000002c/k<0
/k>c01X0/k>c00<0000009nOW`2OWil01@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo4`2<S8`00`000000WinO09nOW`0209nOW`030000o`2OWil0WinO01h0WinO00<000000;>c
/`2c/k<09P2c/k<2000007`0a/K60P00000K0;>c/`030000002OWil0oooo00@0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooa80S8b<00<0000009nOW`2OWil00`2OWil00`000?l0
WinO09nOW`0L09nOW`8000009P2c/k<300000800a/K60P00000J0;>c/`030000003oool0oooo00<0
oooo0@0000010?ooo`0000<0oooo0000000000000`0000020?ooo`8000001@3oool3000000<0oooo
00<000000?ooo`3oool00P3oool@08b<S08000001@2OWil00`000?l0WinO09nOW`0L09nOW`030000
002c/k<0/k>c02<0/k>c0`0000250<K6aP<00000602c/k<00`000000oooo0?ooo`020?ooo`400000
0@3oool000<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo3`2<S8`00`000000WinO09nOW`0509nOW`030000o`2OWil0WinO01T0WinO0`00
000T0;>c/`800000>P36a/HS000002h0a/K60P00000F0;>c/`D0oooo0@0000010?ooo`000`3oool0
0`000000oooo0?ooo`070?ooo`D000000`3oool2000000<0oooo3P2<S8`00`000000WinO09nOW`06
09nOW`030000o`2OWil0WinO01P0WinO00<000000;>c/`2c/k<08`2c/k<2000003H0a/K61`00000R
0=WIf@D00000:P36a/H2000001D0/k>c103oool200000040oooo00030?ooo`030000003oool0oooo
00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`h0S8b<00<00000
09nOW`2OWil01@2OWil00`000?l0WinO09nOW`0H09nOW`030000002c/k<0/k>c0280/k>c0P00000c
0<K6aPD00000;P3IfMT5000002L0a/K60P00000C0;>c/`D0oooo0@0000010?ooo`000`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00P3oool=08b<
S0030000002OWil0WinO00H0WinO00<0003o09nOW`2OWil05`2OWil00`000000/k>c0;>c/`0Q0;>c
/`800000;`36a/H6000003P0fMWI1@00000T0<K6aP030000002c/k<0/k>c0100/k>c1@3oool10000
0040oooo00020?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool00P3oool<08b<S003
0000002OWil0WinO00L0WinO00<0003o09nOW`2OWil05@2OWil200000280/k>c0P00000/0<K6aPD0
0000@`3IfMT300000280a/K600<000000;>c/`2c/k<03`2c/k<50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool<08b<S0030000002OWil0WinO00H0WinO00<0003o09nOW`2OWil0
5@2OWil00`000000/k>c0;>c/`0P0;>c/`800000;036a/H2000004/0fMWI1000000O0<K6aP030000
002c/k<0/k>c00h0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2P2<
S8`2000000T0WinO00<0003o09nOW`2OWil0502OWil200000240/k>c0P00000X0<K6aPD00000D@3I
fMT3000001d0a/K60P00000>0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`T0S8b<00<0000009nOW`2OWil02@2OWil00`000?l0WinO09nOW`0C09nOW`030000002c/k<0
/k>c01l0/k>c0P00000W0<K6aP<00000F@3IfMT2000001d0a/K600<000000;>c/`2c/k<02`2c/k<5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool908b<S0030000002OWil0WinO
00T0WinO00<0003o09nOW`2OWil04P2OWil00`000000/k>c0;>c/`0N0;>c/`8000009P36a/H30000
05h0fMWI0P00000L0<K6aP030000002c/k<0/k>c00X0/k>c1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo202<S8`00`000000WinO09nOW`0909nOW`030000o`2OWil0WinO0180
WinO00<000000;>c/`2c/k<07P2c/k<2000002D0a/K60P00001S0=WIf@8000006`36a/H00`000000
/k>c0;>c/`090;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P0S8b<
00<0000009nOW`2OWil02@2OWil00`000?l0WinO09nOW`0A09nOW`030000002c/k<0/k>c01d0/k>c
0P00000U0<K6aP800000I`3IfMT2000001X0a/K600<000000;>c/`2c/k<0202c/k<50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool708b<S0030000002OWil0WinO00X0WinO00<0
003o09nOW`2OWil0402OWil00`000000/k>c0;>c/`0M0;>c/`0300000036a/H0a/K60280a/K60`00
001[0=WIf@8000006@36a/H00`000000/k>c0;>c/`070;>c/`D0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`H0S8b<00<0000009nOW`2OWil02P2OWil00`000?l0WinO09nOW`0?
09nOW`8000007`2c/k<00`000000a/K60<K6aP0P0<K6aP<00000L03IfMT2000001P0a/K600<00000
0;>c/`2c/k<01P2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool508b<
S0030000002OWil0WinO00/0WinO00<0003o09nOW`2OWil03P2OWil00`000000/k>c0;>c/`0M0;>c
/`8000008@36a/H2000007D0fMWI0P00000G0<K6aP030000002c/k<0/k>c00D0/k>c1@3oool10000
0040oooo000E0?ooo`8000000`3oool508b<S0030000002OWil0WinO00/0WinO00<0003o09nOW`2O
Wil03P2OWil00`000000/k>c0;>c/`0L0;>c/`0300000036a/H0a/K60240a/K600<000000=WIf@3I
fMT0MP3IfMT00`000000a/K60<K6aP0E0<K6aP030000002c/k<0/k>c00@0/k>c103oool200000040
oooo000E0?ooo`030000003oool0oooo0080oooo102<S8`00`000000WinO09nOW`0;09nOW`030000
o`2OWil0WinO00h0WinO00<000000;>c/`2c/k<0702c/k<00`000000a/K60<K6aP0O0<K6aP<00000
>03IfMTB00000300fMWI0P00000E0<K6aP030000002c/k<0/k>c00@0/k>c1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo102<S8`00`000000WinO09nOW`0;09nOW`030000o`2O
Wil0WinO00d0WinO00<000000;>c/`2c/k<06`2c/k<200000200a/K60P00000d0=WIf@L000004P3/
k>`8000002X0fMWI00<000000<K6aP36a/H04`36a/H00`000000/k>c0;>c/`030;>c/`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0S8b<00<0000009nOW`2OWil0302OWil0
0`000?l0WinO09nOW`0<09nOW`030000002c/k<0/k>c01/0/k>c00<000000<K6aP36a/H07P36a/H2
00000300fMWI1P00000Q0>c/k0D000009P3IfMT00`000000a/K60<K6aP0C0<K6aP030000002c/k<0
/k>c0080/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0`2<S8`00`00
0000WinO09nOW`0;09nOW`030000o`2OWil0WinO00`0WinO00<000000;>c/`2c/k<06`2c/k<00`00
0000a/K60<K6aP0N0<K6aP030000003IfMT0fMWI02`0fMWI1000000/0>c/k08000009@3IfMT00`00
0000a/K60<K6aP0B0<K6aP030000002c/k<0/k>c0080/k>c1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo0P2<S8`00`000000WinO09nOW`0<09nOW`030000o`2OWil0WinO00`0
WinO00<000000;>c/`2c/k<06`2c/k<00`000000a/K60<K6aP0L0<K6aP800000;03IfMT300000380
k>c/1P00000P0=WIf@0300000036a/H0a/K60180a/K600@000000;>c/`2c/k<0/k>c1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo00<0S8b<0000002OWil03P2OWil00`000?l0
WinO09nOW`0;09nOW`030000002c/k<0/k>c01X0/k>c0P00000M0<K6aP800000:03IfMT6000003/0
k>c/0P00000O0=WIf@0300000036a/H0a/K60180a/K600<000000;>c/`2c/k<01@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo00<0S8b<0000002OWil03@2OWil00`000?l0WinO
09nOW`0;09nOW`030000002c/k<0/k>c01X0/k>c00<000000<K6aP36a/H07036a/H00`000000fMWI
0=WIf@0V0=WIf@800000@`3/k>`3000001d0fMWI0P00000C0<K6aP030000002c/k<0oooo00@0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000002OWil0WinO00d0WinO00<0
003o09nOW`2OWil02P2OWil00`000000/k>c0;>c/`0J0;>c/`0300000036a/H0a/K601`0a/K600<0
00000=WIf@3IfMT0903IfMT3000004P0k>c/0P00000M0=WIf@0300000036a/H0a/K60100a/K600<0
00000;>c/`3oool0103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<00000
09nOW`2OWil03@2OWil00`000?l0WinO09nOW`0:09nOW`030000002c/k<0/k>c01X0/k>c00<00000
0<K6aP36a/H06`36a/H00`000000fMWI0=WIf@0S0=WIf@800000C@3/k>`00`000000fMWI0=WIf@0K
0=WIf@0300000036a/H0a/K60100a/K600<000000?ooo`3oool00`3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo3`2OWil00`000?l0WinO09nOW`0:09nOW`030000002c/k<0/k>c
01X0/k>c00<000000<K6aP36a/H06`36a/H00`000000fMWI0=WIf@0Q0=WIf@<00000D03/k>`20000
01/0fMWI00<000000<K6aP36a/H04036a/H00`000000oooo0?ooo`030?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool?09nOW`030000o`2OWil0WinO00T0WinO00<000000;>c/`2c
/k<06@2c/k<2000001`0a/K60P00000R0=WIf@800000E@3/k>`2000001X0fMWI00<000000<K6aP36
a/H03`36a/H00`000000oooo0?ooo`030?ooo`4000000@3oool001D0oooo0P0000030?ooo`l0WinO
00<0003o09nOW`2OWil02@2OWil00`000000/k>c0;>c/`0H0;>c/`0300000036a/H0a/K601/0a/K6
00<000000=WIf@3IfMT0803IfMT2000005T0k>c/0P00000I0=WIf@0300000036a/H0a/K600l0a/K6
00@000000?ooo`3oool0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h0WinO
00<0003o09nOW`2OWil02@2OWil00`000000/k>c0;>c/`0I0;>c/`0300000036a/H0a/K601T0a/K6
0P00000R0=WIf@800000F`3/k>`2000001T0fMWI00<000000<K6aP36a/H03P36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool>09nOW`030000o`2OWil0WinO00T0WinO00<0
00000;>c/`2c/k<0602c/k<00`000000a/K60<K6aP0I0<K6aP030000003IfMT0fMWI0200fMWI0P00
001O0>c/k08000005`3IfMT00`000000a/K60<K6aP0>0<K6aPD0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`h0WinO00<0003o09nOW`2OWil0202OWil00`000000/k>c0;>c/`0H
0;>c/`0300000036a/H0a/K601X0a/K600<000000=WIf@3IfMT07`3IfMT00`000000k>c/0>c/k01Q
0>c/k0030000003IfMT0fMWI01D0fMWI00<000000<K6aP36a/H03@36a/H50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool=09nOW`030000o`2OWil0WinO00P0WinO00<000000;>c
/`2c/k<06@2c/k<00`000000a/K60<K6aP0I0<K6aP030000003IfMT0fMWI01h0fMWI0P00001U0>c/
k0030000003IfMT0fMWI01D0fMWI00<000000<K6aP36a/H03036a/H50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool=09nOW`030000o`2OWil0WinO00P0WinO00<000000;>c/`2c
/k<05`2c/k<2000001X0a/K60P00000N0=WIf@<00000J03/k>`2000001H0fMWI00<000000<K6aP36
a/H02`36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool=09nOW`030000
o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<0602c/k<00`000000a/K60<K6aP0H0<K6aP030000
003IfMT0fMWI01d0fMWI00<000000>c/k03/k>`0JP3/k>`00`000000fMWI0=WIf@0D0=WIf@030000
0036a/H0a/K600/0a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo302O
Wil00`000?l0WinO09nOW`0809nOW`030000002c/k<0/k>c01L0/k>c00<000000<K6aP36a/H06036
a/H00`000000fMWI0=WIf@0M0=WIf@030000003/k>`0k>c/06`0k>c/00<000000=WIf@3IfMT0503I
fMT00`000000a/K60<K6aP0:0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo``0WinO00<0003o09nOW`2OWil01`2OWil00`000000/k>c0;>c/`0H0;>c/`0300000036a/H0
a/K601P0a/K600<000000=WIf@3IfMT0703IfMT00`000000k>c/0>c/k01^0>c/k0030000003IfMT0
fMWI01<0fMWI00<000000<K6aP36a/H02P36a/H50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool<09nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05`2c/k<00`00
0000a/K60<K6aP0H0<K6aP030000003IfMT0fMWI01`0fMWI00<000000>c/k03/k>`0=@3/k>`<0000
02l0k>c/00<000000=WIf@3IfMT04`3IfMT00`000000a/K60<K6aP090<K6aPD0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00<0003o09nOW`2OWil01`2OWil00`000000
/k>c0;>c/`0H0;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0703IfMT00`000000
k>c/0>c/k00_0>c/k0L00000303oool5000002/0k>c/00<000000=WIf@3IfMT04P3IfMT00`000000
a/K60<K6aP090<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO
00<0003o09nOW`2OWil01`2OWil00`000000/k>c0;>c/`0G0;>c/`0300000036a/H0a/K601P0a/K6
00<000000=WIf@3IfMT06P3IfMT2000002l0k>c/0`00000H0?ooo`H000009P3/k>`00`000000fMWI
0=WIf@0B0=WIf@0300000036a/H0a/K600P0a/K61@3oool100000040oooo000E0?ooo`8000000`3o
ool;09nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05P2c/k<00`000000a/K60<K6
aP0H0<K6aP030000003IfMT0fMWI01X0fMWI00<000000>c/k03/k>`0:P3/k>`500000240oooo0P00
000T0>c/k0030000003IfMT0fMWI0180fMWI00<000000<K6aP36a/H02036a/H40?ooo`8000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool:09nOW`030000o`2OWil0WinO00L0WinO00<00000
0;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0H0<K6aP030000003IfMT0fMWI01X0fMWI00<00000
0>c/k03/k>`0:03/k>`3000002P0oooo0`00000R0>c/k08000004`3IfMT00`000000a/K60<K6aP07
0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0WinO00<0003o09nO
W`2OWil01`2OWil00`000000/k>c0;>c/`0F0;>c/`0300000036a/H0a/K601L0a/K600<000000=WI
f@3IfMT06`3IfMT00`000000k>c/0>c/k00V0>c/k0800000;P3oool200000240k>c/00<000000=WI
f@3IfMT04@3IfMT00`000000a/K60<K6aP070<K6aPD0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooo`X0WinO00<0003o09nOW`2OWil01P2OWil00`000000/k>c0;>c/`0F0;>c/`03
00000036a/H0a/K601P0a/K600<000000=WIf@3IfMT06@3IfMT2000002L0k>c/0P00000b0?ooo`80
00006P3/k>`20?l000@0k>c/00<000000=WIf@3IfMT0403IfMT00`000000a/K60<K6aP070<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0WinO00<0003o09nOW`2OWil0
1`2OWil00`000000/k>c0;>c/`0F0;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0
6@3IfMT00`000000k>c/0>c/k00V0>c/k0030000003oool0oooo03@0oooo00<000000>c/k03/k>`0
5@3/k>`20?l000<00?l000@0o`000>c/k03/k>`000004`3IfMT00`000000a/K60<K6aP060<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0WinO00<0003o09nOW`2OWil0
1P2OWil00`000000/k>c0;>c/`0F0;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0
6@3IfMT00`000000k>c/0>c/k00T0>c/k0<00000>03oool2000001D0k>c/00<0o`00003o0000o`00
0`00o`030>c/k0030000003IfMT0fMWI0100fMWI00<000000<K6aP36a/H01P36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool909nOW`030000o`2OWil0WinO00H0WinO00<0
00000;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01T0fMWI00<0
00000>c/k03/k>`08`3/k>`2000003d0oooo0P00000B0>c/k080o`001@00o`001@3o0000k>c/0>c/
k03/k>`000000180fMWI00<000000<K6aP36a/H01@36a/H50?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool809nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05P2c
/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`08P3/
k>`200000440oooo00<000000>c/k03/k>`03`3/k>`20?l000D00?l000D0o`000>c/k03/k>`0k>c/
0000000B0=WIf@0300000036a/H0a/K600D0a/K61@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo202OWil00`000?l0WinO09nOW`0609nOW`030000002c/k<0/k>c01H0/k>c00<0
00000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/k>`0k>c/0280k>c/00<0
00000?ooo`3oool0@P3oool00`000000k>c/0>c/k00?0>c/k080o`000`00o`000`3o0000k>c/0>c/
k0030>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01@36a/H50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool809nOW`030000o`2OWil0WinO00H0WinO00<00000
0;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01P0fMWI00<00000
0>c/k03/k>`08@3/k>`00`000000oooo0?ooo`140?ooo`030000003/k>`0k>c/00h0k>c/1P3o0005
0>c/k0030000003IfMT0fMWI00l0fMWI0P0000060<K6aPD0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`L0WinO00<0003o09nOW`2OWil01`2OWil00`000000/k>c0;>c/`0E0;>c
/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT0603IfMT00`000000k>c/0>c/k00Q0>c/
k0030000003oool0oooo04H0oooo00<000000>c/k03/k>`03`3/k>`20?l000L0k>c/00<000000=WI
f@3IfMT0403IfMT00`000000a/K60<K6aP040<K6aPD0oooo0@0000010?ooo`0000<0oooo00000000
00000`0000020?ooo`8000000`3oool3000000D0oooo00<000000?ooo`3oool00P3oool709nOW`03
0000o`2OWil0WinO00H0WinO00<000000;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0F0<K6aP03
0000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`0803/k>`00`000000oooo0?ooo`180?ooo`03
0000003/k>`0k>c/01L0k>c/00<000000=WIf@3IfMT0403IfMT00`000000a/K60<K6aP040<K6aPD0
oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3oool709nOW`030000o`2OWil0WinO00H0WinO00<000000;>c/`2c
/k<05P2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/
k>`07`3/k>`2000004`0oooo00<000000>c/k03/k>`05`3/k>`00`000000fMWI0=WIf@0?0=WIf@03
00000036a/H0a/K600@0a/K61@3oool100000040oooo00030?ooo`030000003oool0oooo00L0oooo
00@000000?ooo`3oool00000103oool2000000<0oooo1`2OWil00`000?l0WinO09nOW`0509nOW`03
0000002c/k<0/k>c01H0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0H0=WIf@03
0000003/k>`0k>c/01l0k>c/00<000000?ooo`3oool0C03oool00`000000k>c/0>c/k00G0>c/k003
0000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01036a/H40?ooo`8000000@3oool000<0oooo
00<000000?ooo`3oool01`3oool3000000D0oooo00<000000?ooo`3oool00P3oool609nOW`030000
o`2OWil0WinO00H0WinO00<000000;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0E0<K6aP030000
003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`07`3/k>`00`000000oooo0?ooo`1=0?ooo`030000
003/k>`0k>c/01L0k>c/00<000000=WIf@3IfMT03`3IfMT00`000000a/K60<K6aP030<K6aPD0oooo
0@0000010?ooo`000`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00P3oool609nOW`030000o`2OWil0WinO00H0WinO00<000000;>c/`2c/k<05P2c
/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0fMWI00<000000>c/k03/k>`07`3/
k>`00`000000oooo0?ooo`1?0?ooo`030000003/k>`0k>c/01H0k>c/00<000000=WIf@3IfMT03`3I
fMT00`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`000P3oool2000000X0oooo0`000004
0?ooo`030000003oool0oooo0080oooo1P2OWil00`000?l0WinO09nOW`0609nOW`030000002c/k<0
/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/k>`0
k>c/01h0k>c/00<000000?ooo`3oool0D03oool00`000000k>c/0>c/k00G0>c/k0030000003IfMT0
fMWI00h0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool509nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05@2c/k<00`00
0000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`07@3/k>`00`00
0000oooo0?ooo`1B0?ooo`030000003/k>`0k>c/01H0k>c/00<000000=WIf@3IfMT03P3IfMT00`00
0000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`D0
WinO00<0003o09nOW`2OWil01P2OWil00`000000/k>c0;>c/`0E0;>c/`0300000036a/H0a/K601D0
a/K600<000000=WIf@3IfMT0603IfMT00`000000k>c/0>c/k00M0>c/k0030000003oool0oooo05<0
oooo00<000000>c/k03/k>`05P3/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600<0
a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1@2OWil00`000?l0WinO
09nOW`0609nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI
0=WIf@0G0=WIf@030000003/k>`0k>c/01h0k>c/00<000000?ooo`3oool0E03oool00`000000k>c/
0>c/k00E0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool409nOW`030000o`2OWil0WinO00L0WinO00<0
00000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0fMWI00<0
00000>c/k03/k>`07@3/k>`00`000000oooo0?ooo`1E0?ooo`030000003/k>`0k>c/01D0k>c/00<0
00000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`@0WinO00<0003o09nOW`2OWil01P2OWil00`000000/k>c0;>c/`0E
0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M
0>c/k0030000003oool0oooo05H0oooo00<000000>c/k03/k>`05@3/k>`00`000000fMWI0=WIf@0>
0=WIf@0300000036a/H0a/K60080a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo102OWil00`000?l0WinO09nOW`0609nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01d0k>c/00<000000?oo
o`3oool0E`3oool00`000000k>c/0>c/k00E0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6
aP36a/H00P36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool309nOW`03
0000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP03
0000003IfMT0fMWI01L0fMWI00<000000>c/k03/k>`07@3/k>`00`000000oooo0?ooo`1G0?ooo`03
0000003/k>`0k>c/01D0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP020<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0WinO00<0003o09nOW`2OWil0
1`2OWil00`000000/k>c0;>c/`0E0;>c/`0300000036a/H0a/K601D0a/K600<000000=WIf@3IfMT0
5`3IfMT00`000000k>c/0>c/k00L0>c/k0030000003oool0oooo0200oooo0P3o000g0?ooo`030000
003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP020<K6aPD0oooo
0@0000010?ooo`005@3oool2000000<0oooo0`2OWil00`000?l0WinO09nOW`0709nOW`030000002c
/k<0/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/
k>`0k>c/01`0k>c/00<000000?ooo`3oool07P3oool20?l000<00?l000<0o`000?ooo`3oool0<`3o
ool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00P36
a/H40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3oool209nOW`030000o`2OWil0
WinO00L0WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0
fMWI01L0fMWI00<000000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0O0?ooo`030?l00000o`00
0?l000<00?l01P3oool6000002T0oooo00<000000>c/k03/k>`0503/k>`00`000000fMWI0=WIf@0>
0=WIf@0300000036a/H0a/K60080a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo0P2OWil00`000?l0WinO09nOW`0709nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?oo
o`3oool07P3oool20?l000800?l00P000?l00`00o`00o`000?ooo`030?ooo`P00000:03oool00`00
0000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00P36a/H50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool209nOW`030000o`2OWil0WinO00L0
WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0
fMWI00<000000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0N0?ooo`80o`0000<00?l00000o`00
0?l00`000?l30?ooo`X000009`3oool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0
fMWI00<000000<K6aP36a/H00P36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3oool00`2OWil0003o09nOW`0909nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6aP36a/H0
5@36a/H00`000000fMWI0=WIf@0F0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?ooo`3oool0
803oool20?l00004003o00000?l00?l00?l000<0003o100000030?l000D000009P3oool00`000000
k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00P36a/H50?ooo`40
00000@3oool001D0oooo00@000000?ooo`3oool0oooo0P3o00000`000?l0WinO09nOW`0809nOW`03
0000002c/k<0/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0F0=WIf@03
0000003/k>`0k>c/01`0k>c/00<000000?ooo`3oool0803oool60?l00080oooo0`000?l20?l000@0
0?l000@0o`0000000000000000009P3oool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI
00h0fMWI00<000000<K6aP36a/H00P36a/H50?ooo`4000000@3oool001D0oooo00@000000?ooo`3o
0000o`000P00o`000`000?l0o`0009nOW`0809nOW`030000002c/k<0/k>c01@0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?oo
o`3oool08P3oool20?l000@0oooo0P0000030000o`03003o00000?l00?l000800?l01000000U0?oo
o`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP020<K6
aPD0oooo0@0000010?ooo`005@3oool010000000oooo0?l00000o`020000o`800?l02@2OWil00`00
0000/k>c0;>c/`0D0;>c/`0300000036a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`00
0000k>c/0>c/k00L0>c/k0030000003oool0oooo02P0oooo0P0000020?l000@0003o0P00o`00103o
0000000000000000000U0?ooo`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3IfMT0
0`000000a/K60<K6aP020<K6aPD0oooo0@0000010?ooo`005@3oool00`000000o`000?l000030000
o`800?l000<0o`0009nOW`2OWil01P2OWil00`000000/k>c0;>c/`0D0;>c/`0300000036a/H0a/K6
01D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00L0>c/k0030000003oool0oooo
02P0oooo0P0000020?l000800?l00`000?l00`00o`00o`0000000002000002D0oooo00<000000>c/
k03/k>`0503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K60080a/K61@3oool10000
0040oooo000E0?ooo`090000003o0000o`00003o00000?l00?l00000o`00o`00o`0000L0WinO00<0
00000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0fMWI00<0
00000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0X0?ooo`<000000P3o0002003o0080003o00<0
o`000000000000000P00000U0?ooo`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3I
fMT00`000000a/K60<K6aP020<K6aPD0oooo0@0000010?ooo`005@3oool010000000oooo0?l0003o
0003003o0080003o1`2OWil00`000000/k>c0;>c/`0E0;>c/`0300000036a/H0a/K601D0a/K600<0
00000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00L0>c/k0030000003oool0oooo02P0oooo0`00
00060?l00080003o0P00000V0?ooo`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3I
fMT00`000000a/K60<K6aP020<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?l00005
0?l0000309nOW`000?l0WinO00D0WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E
0<K6aP030000003IfMT0fMWI01L0fMWI00<000000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0Y
0?ooo`@000000`3o000300000080003o9P3oool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0
fMWI00d0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`4000000@3oool001D0oooo0P0000020?oo
o`80o`00102OWil00`000?l0WinO09nOW`0309nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?oo
o`3oool0:P3oool:000000030?ooo`000?l0003o02@0oooo00<000000>c/k03/k>`0503/k>`00`00
0000fMWI0=WIf@0=0=WIf@0300000036a/H0a/K600<0a/K6103oool200000040oooo000E0?ooo`03
0000003oool0oooo0080oooo1P2OWil00`000?l0WinO09nOW`0209nOW`030000002c/k<0/k>c01D0
/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0
k>c/00<000000?ooo`3oool0:`3oool8000000@0oooo0P000?lR0?ooo`030000003/k>`0k>c/01@0
k>c/00<000000=WIf@3IfMT03@3IfMT00`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooo`L0WinO00D0003o09nOW`2OWil0WinO0000000G0;>c/`03
00000036a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k003
0000003oool0oooo02/0oooo1P0000070?ooo`80003o0`3oool20?l001X0oooo00<000000>c/k03/
k>`0503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600<0a/K61@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo202OWil20000o`0309nOW`000000/k>c01H0/k>c
00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01d0k>c/
00<000000?ooo`3oool0>P3oool20000o`050?l00000o`000?l0003o003o0000603oool00`000000
k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool:09nOW`030000o`000000/k>c01H0/k>c
00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01d0k>c/
00<000000?ooo`3oool0>`3oool00`3o0000003o0000o`03003o01L0oooo00<000000>c/k03/k>`0
503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000?l0/k>c0;>c/`0E0;>c/`0300000036
a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k0030000003o
ool0oooo03X0oooo0P3o0002003o00040000o`00o`000?l00?l001H0oooo00<000000>c/k03/k>`0
503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000003o0;>c/`0E0;>c/`0300000036
a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k0030000003o
ool0oooo03X0oooo0P3o00001P00o`00003o0000o`000?l00?l00?l001D0oooo00<000000>c/k03/
k>`05@3/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo2`2OWil010000000/k>c0000o`000?lD0;>c/`03
00000036a/H0a/K601H0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k003
0000003oool0oooo03X0oooo00H0o`000000o`00o`00003o003o003o000F0?ooo`030000003/k>`0
k>c/01D0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP040<K6aPD0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00D000000;>c/`2c/k<0/k>c0000o`0C
0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M
0>c/k0800000>`3oool00`000?l0o`000?l000030?l001D0oooo00<000000>c/k03/k>`05P3/k>`0
0`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`020;>c/`030000o`2c/k<0/k>c
0100/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/
01h0k>c/00<000000?ooo`3oool0>03oool00`000?l0oooo0?ooo`020?l001L0oooo00<000000>c/
k03/k>`05P3/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`030;>c/`03
0000o`2c/k<0/k>c00l0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@03
0000003/k>`0k>c/01h0k>c/00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0I0?ooo`03
0000003/k>`0k>c/01H0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP050<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00<000000;>c/`2c/k<0
102c/k<20000o`l0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000
003/k>`0k>c/01h0k>c/00<000000?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0J0?ooo`030000
003/k>`0k>c/01D0k>c/0P00000@0=WIf@0300000036a/H0a/K600D0a/K61@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`060;>c/`030000o`2c
/k<0/k>c00`0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/
k>`0k>c/01l0k>c/00<000000?ooo`3oool0<P3oool20000oa`0oooo00<000000>c/k03/k>`05@3/
k>`00`000000fMWI0=WIf@0?0=WIf@0300000036a/H0a/K600H0a/K61@3oool100000040oooo000E
0?ooo`8000000`3oool;09nOW`030000002c/k<0/k>c00L0/k>c00<0003o0;>c/`2c/k<0302c/k<0
0`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`07`3/k>`0
0`000000oooo0?ooo`0`0?ooo`030000o`3oool0oooo01/0oooo00<000000>c/k03/k>`05P3/k>`0
0`000000fMWI0=WIf@0?0=WIf@0300000036a/H0a/K600H0a/K6103oool200000040oooo000E0?oo
o`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`080;>c/`030000o`2c/k<0/k>c
00/0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/k>`0k>c/
0200k>c/00<000000?ooo`3oool0;P3oool00`000?l0oooo0?ooo`0K0?ooo`030000003/k>`0k>c/
01L0k>c/00<000000=WIf@3IfMT03`3IfMT00`000000a/K60<K6aP060<K6aPD0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00<000000;>c/`2c/k<02@2c/k<00`000?l0
/k>c0;>c/`0:0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT06@3IfMT00`000000
k>c/0>c/k00P0>c/k0030000003oool0oooo02`0oooo00<0003o0?ooo`3oool06`3oool00`000000
k>c/0>c/k00G0>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01`36a/H50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool;09nOW`030000002c/k<0/k>c00X0/k>c
0P000?l:0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT06@3IfMT00`000000k>c/
0>c/k00P0>c/k0030000003oool0oooo02/0oooo00<0003o0?ooo`3oool06`3oool00`000000k>c/
0>c/k00H0>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01`36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool;09nOW`030000002c/k<0/k>c00`0/k>c00<0
003o0;>c/`2c/k<01`2c/k<00`000000a/K60<K6aP0G0<K6aP030000003IfMT0fMWI01P0fMWI00<0
00000>c/k03/k>`08@3/k>`00`000000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo01/0oooo00<0
00000>c/k03/k>`0603/k>`00`000000fMWI0=WIf@0@0=WIf@0300000036a/H0a/K600L0a/K61@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`0=
0;>c/`030000o`2c/k<0/k>c00L0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0I
0=WIf@030000003/k>`0k>c/0240k>c/0P00000X0?ooo`030000o`3oool0oooo01X0oooo0P00000K
0>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H02036a/H50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool;09nOW`030000002c/k<0/k>c00h0/k>c00<0003o0;>c
/`2c/k<01P2c/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01X0fMWI00<000000>c/
k03/k>`08P3/k>`2000002D0oooo00<0003o0?ooo`3oool06P3oool00`000000k>c/0>c/k00J0>c/
k0030000003IfMT0fMWI0100fMWI00<000000<K6aP36a/H02036a/H50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool<09nOW`030000002c/k<0/k>c00h0/k>c0P000?l60;>c/`03
00000036a/H0a/K601L0a/K600<000000=WIf@3IfMT06@3IfMT00`000000k>c/0>c/k00T0>c/k003
0000003oool0oooo0240oooo00<0003o0?ooo`3oool06@3oool2000001`0k>c/00<000000=WIf@3I
fMT0403IfMT00`000000a/K60<K6aP090<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooo``0WinO00<000000;>c/`2c/k<0402c/k<00`000?l0/k>c0;>c/`030;>c/`030000
0036a/H0a/K601L0a/K600<000000=WIf@3IfMT06P3IfMT00`000000k>c/0>c/k00T0>c/k0800000
803oool00`000?l0oooo0?ooo`0I0?ooo`030000003/k>`0k>c/01`0k>c/00<000000=WIf@3IfMT0
403IfMT00`000000a/K60<K6aP090<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo``0WinO00<000000;>c/`2c/k<04@2c/k<00`000?l0/k>c0;>c/`020;>c/`0300000036
a/H0a/K601L0a/K600<000000=WIf@3IfMT06`3IfMT00`000000k>c/0>c/k00U0>c/k08000007@3o
ool00`000?l0oooo0?ooo`0G0?ooo`<000007P3/k>`00`000000fMWI0=WIf@0@0=WIf@0300000036
a/H0a/K600X0a/K61@3oool100000040oooo00000`3oool000000000000300000080oooo0P000004
0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo``0WinO00<000000;>c/`2c/k<04P2c/k<0
0`000?l0/k>c0;>c/`020;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT06P3IfMT0
0`000000k>c/0>c/k00W0>c/k0030000003oool0oooo01T0oooo00<0003o0?ooo`3oool05P3oool2
00000240k>c/00<000000=WIf@3IfMT0403IfMT00`000000a/K60<K6aP0:0<K6aPD0oooo0@000001
0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00P3oool<09nOW`030000002c/k<0/k>c01<0/k>c0P000?l20;>c/`8000006@36a/H0
0`000000fMWI0=WIf@0J0=WIf@030000003/k>`0k>c/02L0k>c/0P00000H0?ooo`030000o`3oool0
oooo01L0oooo00<000000>c/k03/k>`07`3/k>`00`000000fMWI0=WIf@0A0=WIf@0300000036a/H0
a/K600X0a/K61@3oool100000040oooo00030?ooo`030000003oool0oooo00L0oooo00@000000?oo
o`3oool00000103oool2000000<0oooo302OWil00`000000/k>c0;>c/`0E0;>c/`040000o`2c/k<0
/k>c000001T0a/K600<000000=WIf@3IfMT06`3IfMT00`000000k>c/0>c/k00X0>c/k0<000004`3o
ool20000oaD0oooo1@00000P0>c/k08000004`3IfMT00`000000a/K60<K6aP0;0<K6aP@0oooo0P00
00010?ooo`000`3oool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`02
0?ooo`d0WinO00<000000;>c/`2c/k<05@2c/k<00`000?l0/k>c0000000J0<K6aP030000003IfMT0
fMWI01/0fMWI0P00000[0>c/k0D000003@3oool00`000?l0oooo0?ooo`0B0?ooo`<00000903/k>`0
0`000000fMWI0=WIf@0B0=WIf@0300000036a/H0a/K600`0a/K61@3oool100000040oooo00030?oo
o`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`02
0?ooo`d0WinO00<000000;>c/`2c/k<05P2c/k<00`000?l000000<K6aP020<K6aP80o`005P36a/H0
0`000000fMWI0=WIf@0L0=WIf@030000003/k>`0k>c/02d0k>c/1@0000070?ooo`030000o`3oool0
oooo00h0oooo1@00000V0>c/k0030000003IfMT0fMWI01<0fMWI00<000000<K6aP36a/H03036a/H5
0?ooo`4000000@3oool00080oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
o`h0WinO00<000000;>c/`2c/k<05P2c/k<00`000?l000000?l000050?l001@0a/K600<000000=WI
f@3IfMT0703IfMT00`000000k>c/0>c/k00b0>c/k08000000P3o0002000000030000o`000000oooo
00L0oooo2000000[0>c/k0030000003IfMT0fMWI0180fMWI00<000000<K6aP36a/H03@36a/H00`00
0000oooo0?ooo`020?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool>09nOW`03
0000002c/k<0/k>c01L0/k>c0P000?l3003o0080o`005@36a/H00`000000fMWI0=WIf@0L0=WIf@03
0000003/k>`0k>c/0340k>c/0P3o0003003o00030000o`3/k>`0k>c/00P00000<P3/k>`00`000000
fMWI0=WIf@0B0=WIf@0300000036a/H0a/K600d0a/K60P3o00040?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool>09nOW`030000002c/k<0/k>c01L0/k>c00@0o`00003o00000?l0
003o0P00o`020?l001D0a/K600<000000=WIf@3IfMT0703IfMT200000340k>c/00H0o`00003o0000
o`000?l00000o`00o`0j0>c/k0800000503IfMT00`000000a/K60<K6aP0<0<K6aP80o`000`00o`00
103o0000oooo0?ooo`0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h0WinO00<00000
0;>c/`2c/k<05`2c/k<00`3o00000?l00000o`1`0000o`800?l000<0o`000>c/k03/k>`0=P3/k>`0
0`000000fMWI0=WIf@0C0=WIf@0300000036a/H0a/K600d0a/K600<0o`00003o0000o`000`00o`02
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool>09nOW`030000002c/k<0/k>c
01P0/k>c0P00o`0010000?l00?l0003o003o000H0<K6aP030000003IfMT0fMWI01d0fMWI0P00000]
0>c/k080o`000`000?l2003o00030?l0003/k>`0k>c/03@0k>c/0P00000E0=WIf@0300000036a/H0
a/K600d0a/K60P3o0005003o00030?l0003oool000000040oooo000E0?ooo`030000003oool0oooo
0080oooo3`2OWil00`000000/k>c0;>c/`0G0;>c/`040?l00000o`000?l0003o0080o`006036a/H0
0`000000fMWI0=WIf@0O0=WIf@800000;03/k>`20?l000040000o`00o`000?l00?l003H0k>c/00<0
00000=WIf@3IfMT05@3IfMT00`000000a/K60<K6aP0=0<K6aP80o`001@00o`000`3o0000oooo0000
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`l0WinO00<000000;>c/`2c/k<06@2c/k<2
0?l001/0a/K600<000000=WIf@3IfMT0803IfMT00`000000k>c/0>c/k00Y0>c/k0H0o`00=@3/k>`0
0`000000fMWI0=WIf@0E0=WIf@0300000036a/H0a/K600l0a/K60P3o0003003o00040?l0003oool0
oooo00000040oooo000E0?ooo`030000003oool0oooo0080oooo402OWil00`000000/k>c0;>c/`0I
0;>c/`0300000036a/H0a/K601X0a/K60P00000Q0=WIf@800000:`3/k>`20?l003D0k>c/0P00000G
0=WIf@0300000036a/H0a/K600l0a/K600<000000?l0003o0000103o00020?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolA09nOW`030000002c/k<0/k>c01T0/k>c00<000000<K6
aP36a/H06`36a/H00`000000fMWI0=WIf@0P0=WIf@800000GP3/k>`2000001P0fMWI00<000000<K6
aP36a/H04036a/H00`000000/k>c0;>c/`020?l000@0oooo0@0000010?ooo`005@3oool2000000<0
oooo4@2OWil00`000000/k>c0;>c/`0I0;>c/`0300000036a/H0a/K601`0a/K600<000000=WIf@3I
fMT08@3IfMT2000005X0k>c/0P00000I0=WIf@0300000036a/H0a/K60100a/K600<000000;>c/`2c
/k<00P2c/k<40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolB09nOW`030000
002c/k<0/k>c01T0/k>c00<000000<K6aP36a/H07036a/H00`000000fMWI0=WIf@0R0=WIf@800000
EP3/k>`2000001X0fMWI00<000000<K6aP36a/H04036a/H00`000000/k>c0;>c/`030;>c/`D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa80WinO00<000000;>c/`2c/k<06P2c
/k<00`000000a/K60<K6aP0L0<K6aP030000003IfMT0fMWI02<0fMWI0P00001B0>c/k08000006`3I
fMT00`000000a/K60<K6aP0A0<K6aP030000002c/k<0/k>c00<0/k>c1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo4P2OWil00`000000/k>c0;>c/`0K0;>c/`0300000036a/H0
a/K601`0a/K60P00000U0=WIf@D00000B`3/k>`2000001`0fMWI00<000000<K6aP36a/H04@36a/H0
0`000000/k>c0;>c/`040;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa<0WinO00<000000;>c/`2c/k<06`2c/k<00`000000a/K60<K6aP0M0<K6aP030000003IfMT0fMWI
02L0fMWI0P0000150>c/k0@000007@3IfMT00`000000a/K60<K6aP0A0<K6aP030000002c/k<0/k>c
00D0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo4`2OWil00`000000
/k>c0;>c/`0L0;>c/`0300000036a/H0a/K601d0a/K600<000000=WIf@3IfMT0:03IfMT3000003h0
k>c/1@00000O0=WIf@0300000036a/H0a/K60180a/K600<000000;>c/`2c/k<01@2c/k<50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3ooolD09nOW`8000007@2c/k<00`000000a/K6
0<K6aP0M0<K6aP800000:`3IfMT5000003L0k>c/0P00000R0=WIf@8000004`36a/H2000000P0/k>c
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo5@2OWil00`000000/k>c0;>c
/`0L0;>c/`0300000036a/H0a/K601h0a/K60P00000^0=WIf@D00000;03/k>`600000280fMWI0P00
000D0<K6aP030000002c/k<0/k>c00P0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo5P2OWil00`000000/k>c0;>c/`0L0;>c/`0300000036a/H0a/K601l0a/K60P00000a
0=WIf@D000008P3/k>`5000002L0fMWI0P00000D0<K6aP030000002c/k<0/k>c00T0/k>c1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo5P2OWil2000001h0/k>c00<000000<K6
aP36a/H08036a/H2000003@0fMWI8P00000Z0=WIf@8000005@36a/H00`000000/k>c0;>c/`0:0;>c
/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0WinO00<000000;>c/`2c
/k<07@2c/k<00`000000a/K60<K6aP0Q0<K6aP030000003IfMT0fMWI07`0fMWI00<000000<K6aP36
a/H05@36a/H00`000000/k>c0;>c/`0:0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooaP0WinO00<000000;>c/`2c/k<07@2c/k<200000280a/K60P00001j0=WIf@800000
5`36a/H00`000000/k>c0;>c/`0;0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?oooaT0WinO00<000000;>c/`2c/k<07P2c/k<200000280a/K60`00001d0=WIf@<000005`36
a/H2000000h0/k>c1@3oool100000040oooo000E0?ooo`8000000`3ooolJ09nOW`030000002c/k<0
/k>c01h0/k>c0P00000T0<K6aP<00000K`3IfMT2000001T0a/K600<000000;>c/`2c/k<03P2c/k<4
0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolK09nOW`030000002c/k<0/k>c
01l0/k>c0P00000U0<K6aP800000J`3IfMT2000001X0a/K600<000000;>c/`2c/k<03`2c/k<50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolL09nOW`030000002c/k<0/k>c0200
/k>c00<000000<K6aP36a/H09036a/H3000006D0fMWI0`00000K0<K6aP030000002c/k<0/k>c0100
/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7@2OWil200000240/k>c
0P00000W0<K6aPD00000G@3IfMT3000001`0a/K60P00000C0;>c/`030000003oool0oooo0080oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooal0WinO00<000000;>c/`2c/k<0802c
/k<2000002X0a/K60`00001F0=WIf@@000007@36a/H2000001@0/k>c00<000000?ooo`3oool00`3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo802OWil00`000000/k>c0;>c/`0Q
0;>c/`800000:`36a/H5000004d0fMWI1@00000N0<K6aP8000005@2c/k<00`000000WinO0?ooo`04
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ09nOW`030000002c/k<0/k>c
0280/k>c00<000000<K6aP36a/H0;@36a/H5000004H0fMWI0P00000R0<K6aP030000002c/k<0/k>c
01@0/k>c00<0000009nOW`2OWil01@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo8P2OWil00`000000/k>c0;>c/`0R0;>c/`<00000<@36a/H5000003`0fMWI1@00000R0<K6aP80
00005P2c/k<010000000WinO09nOW`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolS09nOW`8000009@2c/k<2000003@0a/K62000000/0=WIf@P000009@36a/H2000001L0
/k>c00<0000009nOW`2OWil00P2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolU09nOW`030000002c/k<0/k>c02@0/k>c0P00000j0<K6aPX00000603IfMT:000002`0a/K6
00<000000;>c/`2c/k<05P2c/k<00`000000WinO09nOW`0309nOW`D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`030000002OWil0WinO02<0WinO0P00000V0;>c/`<00000@@36
a/HH000003<0a/K60`00000H0;>c/`030000002OWil0WinO00@0WinO1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo00<0S8b<0000002OWil09@2OWil2000002L0/k>c0`000027
0<K6aP8000006@2c/k<2000000L0WinO1@3oool100000040oooo000E0?ooo`8000000`3oool208b<
S08000009P2OWil2000002P0/k>c1@00001o0<K6aP<000006P2c/k<00`000000WinO09nOW`0709nO
W`@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`@0S8b<00<0000009nOW`2O
Wil09@2OWil00`000000/k>c0;>c/`0Z0;>c/`<00000N@36a/H3000001/0/k>c0P00000:09nOW`D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`D0S8b<00<0000009nOW`2OWil0
9@2OWil2000002d0/k>c0P00001e0<K6aP8000007@2c/k<00`000000WinO09nOW`0:09nOW`D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`H0S8b<00<0000009nOW`2OWil09P2O
Wil4000002/0/k>c1P00001Z0<K6aPD000007@2c/k<2000000d0WinO1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo1`2<S8`2000002X0WinO0P00000_0;>c/`D00000HP36a/H3
00000200/k>c0P00000?09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`T0S8b<00<0000009nOW`2OWil0:@2OWil300000340/k>c1@00001H0<K6aPD000008@2c/k<20000
0140WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2P2<S8`00`000000
WinO09nOW`0[09nOW`800000=02c/k<8000004/0a/K61@00000T0;>c/`8000004`2OWil50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool;08b<S0800000;@2OWil3000003T0/k>c
1`00000l0<K6aPP000009`2c/k<2000001D0WinO1@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo3@2<S8`2000002h0WinO0P00000n0;>c/`/000009`36a/H:000002`0/k>c0`00
000G09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`l0S8b<0P00000^
09nOW`H00000@`2c/k<W000003<0/k>c0`00000J09nOW`D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooa40S8b<0P00000b09nOW`800000V@2c/k<2000001d0WinO00<000000?oo
o`3oool00P3oool100000040oooo000=0?ooo`@00000103oool00`000000oooo0?ooo`020?oooa<0
S8b<0`00000a09nOW`D00000T@2c/k<3000001h0WinO00<000000?ooo`3oool00`3oool100000040
oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3ooolF08b<S0800000
=02OWil3000008`0/k>c0P00000O09nOW`80000000<0S8b<0?ooo`3oool00`3oool100000040oooo
000>0?ooo`030000003oool0oooo00@0oooo0P0000030?oooaP0S8b<0`00000d09nOW`D00000P@2c
/k<6000001l0WinO0P00000308b<S0@0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo6`2<S8`3000003H0WinO1@00001g0;>c/`D00000902OWil0
0`000000S8b<08b<S00308b<S0D0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo0080oooo7P2<S8`2000003T0WinO1`00001/0;>c/`@000009`2OWil2
000000H0S8b<1@3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
ob00S8b<0`00000m09nOW`T00000G@2c/k<6000002P0WinO0`00000808b<S0D0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooob<0S8b<0`00001309nOW`L00000CP2c/k<8000002`0
WinO0P00000;08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobH0S8b<
1@00001109nOW`80o`000P2OWil=000003L0/k>c2P00000a09nOW`<000003@2<S8`50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool[08b<S0800000?@2OWil0103o00000?l0003o
0000o`020?l000d0WinO=`00000i09nOW`800000402<S8`50?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool]08b<S0H00000=`2OWil5003o00030?l0002OWil0WinO07P0WinO0`00
000B08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc<0S8b<0P00000d
09nOW`030?l00000o`000?l000<00?l00P3o001f09nOW`<000005@2<S8`50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0J`3oool00`3o00000?l0003o0003003o0080o`00T`3oool10000
0040oooo000E0?ooo`030000003oool0oooo06`0oooo00@0o`00003o0000o`000?l00P3o002D0?oo
o`4000000@3oool001D0oooo00<000000?ooo`000000>@3oool00`000000oooo0?ooo`0`0?ooo`H0
o`000P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool06@3oool100000040oooo000E0?ooo`<000003@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`80o`00
103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0:0?ooo`8000000@3oool001D0ooooo`00000;00000040oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {0, 0, 0, 0}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-2.`\), {x \[Rule] 1.376384972443001`, 
            y \[Rule] 1.6786760817546211`}}\), 
        ",", \({"Steps" \[Rule] 9, "Function" \[Rule] 13, 
          "Gradient" \[Rule] 13}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox[ButtonBox["FindMinimumPlot",
    ButtonData:>"FMRPlot",
    ButtonStyle->"Hyperlink"], "MR"],
  " command for two dimensions is similar to the one-dimensional case, but it \
shows the steps and evaluations superimposed on a contour plot of the \
function. In this example, it is apparent that ",
  StyleBox["FindMinimum", "MR"],
  " needed to change direction several times to get to the local minimum. You \
may notice that the first step starts in the direction of steepest descent \
(i.e., perpendicular to the contour or parallel to the gradient). Steepest \
descent is indeed a possible strategy for local minimization, but it often \
does not converge quickly. In subsequent steps in this example, you may \
notice that the search direction is not exactly perpendicular to the \
contours. The search is using information from past steps to try to get \
information about the curvature of the function, which typically gives it a \
better direction to go. Another strategy, which usually converges faster, but \
can be more expensive, is to use the second derivative of the function. This \
is usually referred to as ",
  ButtonBox["Newton\[CloseCurlyQuote]s method",
    ButtonData:>"FMNewton",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text"],

Cell["\<\
This shows the steps taken using Newton\[CloseCurlyQuote]s \
method.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[
      Cos[x^2\  - \ 3\ y]\  + \ Sin[x^2\  + \ y^2], {{x, 1}, {y, 1}}, \ 
      Method \[Rule] Newton]\)], "Input",
  CellLabel->"In[6]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.43613 2.45536 -1.16934 1.18857 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.26477 -0.0125 -9 -9 ]
[.26477 -0.0125 9 0 ]
[.5103 -0.0125 -9 -9 ]
[.5103 -0.0125 9 0 ]
[.75584 -0.0125 -9 -9 ]
[.75584 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25694 -18 -4.5 ]
[-0.0125 .25694 0 4.5 ]
[-0.0125 .49466 -18 -4.5 ]
[-0.0125 .49466 0 4.5 ]
[-0.0125 .73237 -18 -4.5 ]
[-0.0125 .73237 0 4.5 ]
[-0.0125 .97009 -18 -4.5 ]
[-0.0125 .97009 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(1)] .01923 -0.0125 0 1 Mshowa
.26477 0 m
.26477 .00625 L
s
[(1.1)] .26477 -0.0125 0 1 Mshowa
.5103 0 m
.5103 .00625 L
s
[(1.2)] .5103 -0.0125 0 1 Mshowa
.75584 0 m
.75584 .00625 L
s
[(1.3)] .75584 -0.0125 0 1 Mshowa
.125 Mabswid
.06834 0 m
.06834 .00375 L
s
.11745 0 m
.11745 .00375 L
s
.16655 0 m
.16655 .00375 L
s
.21566 0 m
.21566 .00375 L
s
.31387 0 m
.31387 .00375 L
s
.36298 0 m
.36298 .00375 L
s
.41209 0 m
.41209 .00375 L
s
.4612 0 m
.4612 .00375 L
s
.55941 0 m
.55941 .00375 L
s
.60852 0 m
.60852 .00375 L
s
.65762 0 m
.65762 .00375 L
s
.70673 0 m
.70673 .00375 L
s
.80495 0 m
.80495 .00375 L
s
.85405 0 m
.85405 .00375 L
s
.90316 0 m
.90316 .00375 L
s
.95227 0 m
.95227 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(1)] -0.0125 .01923 1 0 Mshowa
0 .25694 m
.00625 .25694 L
s
[(1.2)] -0.0125 .25694 1 0 Mshowa
0 .49466 m
.00625 .49466 L
s
[(1.4)] -0.0125 .49466 1 0 Mshowa
0 .73237 m
.00625 .73237 L
s
[(1.6)] -0.0125 .73237 1 0 Mshowa
0 .97009 m
.00625 .97009 L
s
[(1.8)] -0.0125 .97009 1 0 Mshowa
.125 Mabswid
0 .07866 m
.00375 .07866 L
s
0 .13809 m
.00375 .13809 L
s
0 .19752 m
.00375 .19752 L
s
0 .31637 m
.00375 .31637 L
s
0 .3758 m
.00375 .3758 L
s
0 .43523 m
.00375 .43523 L
s
0 .55409 m
.00375 .55409 L
s
0 .61352 m
.00375 .61352 L
s
0 .67294 m
.00375 .67294 L
s
0 .7918 m
.00375 .7918 L
s
0 .85123 m
.00375 .85123 L
s
0 .91066 m
.00375 .91066 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.26477 .99375 m
.26477 1 L
s
.5103 .99375 m
.5103 1 L
s
.75584 .99375 m
.75584 1 L
s
.125 Mabswid
.06834 .99625 m
.06834 1 L
s
.11745 .99625 m
.11745 1 L
s
.16655 .99625 m
.16655 1 L
s
.21566 .99625 m
.21566 1 L
s
.31387 .99625 m
.31387 1 L
s
.36298 .99625 m
.36298 1 L
s
.41209 .99625 m
.41209 1 L
s
.4612 .99625 m
.4612 1 L
s
.55941 .99625 m
.55941 1 L
s
.60852 .99625 m
.60852 1 L
s
.65762 .99625 m
.65762 1 L
s
.70673 .99625 m
.70673 1 L
s
.80495 .99625 m
.80495 1 L
s
.85405 .99625 m
.85405 1 L
s
.90316 .99625 m
.90316 1 L
s
.95227 .99625 m
.95227 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25694 m
1 .25694 L
s
.99375 .49466 m
1 .49466 L
s
.99375 .73237 m
1 .73237 L
s
.99375 .97009 m
1 .97009 L
s
.125 Mabswid
.99625 .07866 m
1 .07866 L
s
.99625 .13809 m
1 .13809 L
s
.99625 .19752 m
1 .19752 L
s
.99625 .31637 m
1 .31637 L
s
.99625 .3758 m
1 .3758 L
s
.99625 .43523 m
1 .43523 L
s
.99625 .55409 m
1 .55409 L
s
.99625 .61352 m
1 .61352 L
s
.99625 .67294 m
1 .67294 L
s
.99625 .7918 m
1 .7918 L
s
.99625 .85123 m
1 .85123 L
s
.99625 .91066 m
1 .91066 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.325 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 g
.01923 .10018 m
.02894 .10087 L
.03866 .10155 L
.04837 .10222 L
.05808 .10288 L
.06779 .10352 L
.07751 .10415 L
.08722 .10477 L
.09693 .10538 L
.10664 .10597 L
.11636 .10655 L
.11785 .10664 L
.12607 .10713 L
.13578 .10769 L
.14549 .10824 L
.15521 .10878 L
.16492 .10931 L
.17463 .10983 L
.18434 .11034 L
.19406 .11084 L
.20377 .11133 L
.21348 .11181 L
.22319 .11228 L
.23291 .11274 L
.24262 .11319 L
.25233 .11364 L
.26204 .11407 L
.27176 .11449 L
.28147 .11491 L
.29118 .11532 L
.30089 .11572 L
.31061 .11611 L
.31678 .11636 L
.32032 .11649 L
.33003 .11687 L
.33974 .11724 L
.34946 .1176 L
.35917 .11795 L
.36888 .11829 L
.37859 .11863 L
.38831 .11896 L
.39802 .11928 L
.40773 .11959 L
.41744 .1199 L
.42716 .1202 L
.43687 .1205 L
.44658 .12078 L
.45629 .12106 L
.46601 .12133 L
.47572 .1216 L
.48543 .12186 L
.49514 .12211 L
.50486 .12235 L
.51457 .12259 L
.52428 .12283 L
.53399 .12305 L
.54371 .12327 L
.55342 .12348 L
.56313 .12369 L
.57284 .12389 L
.58256 .12408 L
.59227 .12427 L
.60198 .12445 L
.61169 .12463 L
.62141 .1248 L
.63112 .12496 L
.64083 .12512 L
.65054 .12527 L
.66026 .12542 L
.66997 .12555 L
.67968 .12569 L
.68939 .12581 L
.69911 .12593 L
.70882 .12605 L
.71054 .12607 L
.71853 .12616 L
.72824 .12626 L
.73796 .12636 L
.74767 .12645 L
.75738 .12653 L
.76709 .12661 L
.77681 .12668 L
.78652 .12675 L
.79623 .12681 L
.80594 .12686 L
.81566 .12691 L
.82537 .12695 L
.83508 .12698 L
.84479 .12701 L
.85451 .12703 L
.86422 .12705 L
.87393 .12706 L
.88364 .12706 L
.89336 .12706 L
.90307 .12704 L
.91278 .12703 L
.92249 .127 L
.93221 .12697 L
.94192 .12693 L
.95163 .12689 L
.96134 .12684 L
.97106 .12678 L
.98077 .12671 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .10018 m
.02894 .10087 L
.03866 .10155 L
.04837 .10222 L
.05808 .10288 L
.06779 .10352 L
.07751 .10415 L
.08722 .10477 L
.09693 .10538 L
.10664 .10597 L
.11636 .10655 L
.11785 .10664 L
.12607 .10713 L
.13578 .10769 L
.14549 .10824 L
.15521 .10878 L
.16492 .10931 L
.17463 .10983 L
.18434 .11034 L
.19406 .11084 L
.20377 .11133 L
.21348 .11181 L
.22319 .11228 L
.23291 .11274 L
.24262 .11319 L
.25233 .11364 L
.26204 .11407 L
.27176 .11449 L
.28147 .11491 L
.29118 .11532 L
.30089 .11572 L
.31061 .11611 L
.31678 .11636 L
.32032 .11649 L
.33003 .11687 L
.33974 .11724 L
.34946 .1176 L
.35917 .11795 L
.36888 .11829 L
.37859 .11863 L
.38831 .11896 L
.39802 .11928 L
.40773 .11959 L
.41744 .1199 L
.42716 .1202 L
.43687 .1205 L
.44658 .12078 L
.45629 .12106 L
.46601 .12133 L
.47572 .1216 L
Mistroke
.48543 .12186 L
.49514 .12211 L
.50486 .12235 L
.51457 .12259 L
.52428 .12283 L
.53399 .12305 L
.54371 .12327 L
.55342 .12348 L
.56313 .12369 L
.57284 .12389 L
.58256 .12408 L
.59227 .12427 L
.60198 .12445 L
.61169 .12463 L
.62141 .1248 L
.63112 .12496 L
.64083 .12512 L
.65054 .12527 L
.66026 .12542 L
.66997 .12555 L
.67968 .12569 L
.68939 .12581 L
.69911 .12593 L
.70882 .12605 L
.71054 .12607 L
.71853 .12616 L
.72824 .12626 L
.73796 .12636 L
.74767 .12645 L
.75738 .12653 L
.76709 .12661 L
.77681 .12668 L
.78652 .12675 L
.79623 .12681 L
.80594 .12686 L
.81566 .12691 L
.82537 .12695 L
.83508 .12698 L
.84479 .12701 L
.85451 .12703 L
.86422 .12705 L
.87393 .12706 L
.88364 .12706 L
.89336 .12706 L
.90307 .12704 L
.91278 .12703 L
.92249 .127 L
.93221 .12697 L
.94192 .12693 L
.95163 .12689 L
Mistroke
.96134 .12684 L
.97106 .12678 L
.98077 .12671 L
Mfstroke
.475 g
.01923 .18658 m
.02894 .18656 L
.03866 .18654 L
.04837 .18652 L
.05808 .18649 L
.06779 .18647 L
.07751 .18645 L
.08722 .18643 L
.09693 .18641 L
.10664 .18639 L
.11636 .18637 L
.12607 .18636 L
.13578 .18634 L
.14549 .18632 L
.15521 .1863 L
.16492 .18629 L
.17463 .18627 L
.18434 .18625 L
.19406 .18624 L
.20377 .18622 L
.21348 .18621 L
.22319 .18619 L
.23291 .18618 L
.24262 .18616 L
.25233 .18615 L
.26204 .18613 L
.27176 .18612 L
.28147 .18611 L
.29118 .18609 L
.30089 .18608 L
.31061 .18607 L
.32032 .18606 L
.33003 .18604 L
.33974 .18603 L
.34946 .18602 L
.35917 .18601 L
.36888 .186 L
.37859 .18599 L
.38831 .18598 L
.39802 .18597 L
.40773 .18596 L
.41744 .18595 L
.42716 .18594 L
.43687 .18593 L
.44658 .18592 L
.45629 .18591 L
.46601 .1859 L
.47572 .18589 L
.48543 .18589 L
.49514 .18588 L
.50486 .18587 L
.51457 .18586 L
.52428 .18585 L
.53399 .18585 L
.54371 .18584 L
.55342 .18583 L
.56313 .18583 L
.57284 .18582 L
.58256 .18581 L
.59227 .18581 L
.60198 .1858 L
.61169 .1858 L
.62141 .18579 L
.63112 .18579 L
.64083 .18578 L
.65054 .18578 L
.66026 .18577 L
.66997 .18577 L
.67968 .18576 L
.68939 .18576 L
.69911 .18576 L
.70882 .18575 L
.71853 .18575 L
.72824 .18574 L
.73796 .18574 L
.74767 .18574 L
.75738 .18574 L
.76709 .18573 L
.77681 .18573 L
.78652 .18573 L
.79623 .18573 L
.80594 .18572 L
.81566 .18572 L
.82537 .18572 L
.83508 .18572 L
.84479 .18572 L
.85451 .18572 L
.86422 .18572 L
.87393 .18572 L
.88364 .18572 L
.89336 .18571 L
.90307 .18571 L
.91278 .18571 L
.92249 .18572 L
.93221 .18572 L
.94192 .18572 L
.95163 .18572 L
.96134 .18572 L
.97106 .18572 L
.98077 .18572 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .18658 m
.02894 .18656 L
.03866 .18654 L
.04837 .18652 L
.05808 .18649 L
.06779 .18647 L
.07751 .18645 L
.08722 .18643 L
.09693 .18641 L
.10664 .18639 L
.11636 .18637 L
.12607 .18636 L
.13578 .18634 L
.14549 .18632 L
.15521 .1863 L
.16492 .18629 L
.17463 .18627 L
.18434 .18625 L
.19406 .18624 L
.20377 .18622 L
.21348 .18621 L
.22319 .18619 L
.23291 .18618 L
.24262 .18616 L
.25233 .18615 L
.26204 .18613 L
.27176 .18612 L
.28147 .18611 L
.29118 .18609 L
.30089 .18608 L
.31061 .18607 L
.32032 .18606 L
.33003 .18604 L
.33974 .18603 L
.34946 .18602 L
.35917 .18601 L
.36888 .186 L
.37859 .18599 L
.38831 .18598 L
.39802 .18597 L
.40773 .18596 L
.41744 .18595 L
.42716 .18594 L
.43687 .18593 L
.44658 .18592 L
.45629 .18591 L
.46601 .1859 L
.47572 .18589 L
.48543 .18589 L
.49514 .18588 L
Mistroke
.50486 .18587 L
.51457 .18586 L
.52428 .18585 L
.53399 .18585 L
.54371 .18584 L
.55342 .18583 L
.56313 .18583 L
.57284 .18582 L
.58256 .18581 L
.59227 .18581 L
.60198 .1858 L
.61169 .1858 L
.62141 .18579 L
.63112 .18579 L
.64083 .18578 L
.65054 .18578 L
.66026 .18577 L
.66997 .18577 L
.67968 .18576 L
.68939 .18576 L
.69911 .18576 L
.70882 .18575 L
.71853 .18575 L
.72824 .18574 L
.73796 .18574 L
.74767 .18574 L
.75738 .18574 L
.76709 .18573 L
.77681 .18573 L
.78652 .18573 L
.79623 .18573 L
.80594 .18572 L
.81566 .18572 L
.82537 .18572 L
.83508 .18572 L
.84479 .18572 L
.85451 .18572 L
.86422 .18572 L
.87393 .18572 L
.88364 .18572 L
.89336 .18571 L
.90307 .18571 L
.91278 .18571 L
.92249 .18572 L
.93221 .18572 L
.94192 .18572 L
.95163 .18572 L
.96134 .18572 L
.97106 .18572 L
.98077 .18572 L
Mistroke
Mfstroke
.55 g
.01923 .27591 m
.02894 .27504 L
.03866 .27418 L
.04837 .27335 L
.05808 .27253 L
.06748 .27176 L
.06779 .27173 L
.07751 .27095 L
.08722 .27018 L
.09693 .26944 L
.10664 .26871 L
.11636 .26799 L
.12607 .26729 L
.13578 .26661 L
.14549 .26594 L
.15521 .26528 L
.16492 .26464 L
.17463 .26401 L
.18434 .2634 L
.19406 .2628 L
.20377 .26221 L
.20658 .26204 L
.21348 .26164 L
.22319 .26107 L
.23291 .26052 L
.24262 .25998 L
.25233 .25946 L
.26204 .25894 L
.27176 .25844 L
.28147 .25794 L
.29118 .25746 L
.30089 .25699 L
.31061 .25653 L
.32032 .25607 L
.33003 .25563 L
.33974 .2552 L
.34946 .25478 L
.35917 .25436 L
.36888 .25396 L
.37859 .25356 L
.38831 .25318 L
.39802 .2528 L
.40773 .25243 L
.41048 .25233 L
.41744 .25207 L
.42716 .25172 L
.43687 .25138 L
.44658 .25105 L
.45629 .25072 L
.46601 .2504 L
.47572 .25009 L
.48543 .24979 L
.49514 .24949 L
.50486 .2492 L
.51457 .24892 L
.52428 .24865 L
.53399 .24839 L
.54371 .24813 L
.55342 .24788 L
.56313 .24763 L
.57284 .2474 L
.58256 .24717 L
.59227 .24695 L
.60198 .24673 L
.61169 .24652 L
.62141 .24632 L
.63112 .24613 L
.64083 .24594 L
.65054 .24576 L
.66026 .24558 L
.66997 .24541 L
.67968 .24525 L
.68939 .2451 L
.69911 .24495 L
.70882 .2448 L
.71853 .24467 L
.72824 .24454 L
.73796 .24442 L
.74767 .2443 L
.75738 .24419 L
.76709 .24409 L
.77681 .24399 L
.78652 .2439 L
.79623 .24382 L
.80594 .24374 L
.81566 .24367 L
.82537 .2436 L
.83508 .24355 L
.84479 .24349 L
.85451 .24345 L
.86422 .24341 L
.87393 .24338 L
.88364 .24336 L
.89336 .24334 L
.90307 .24333 L
.91278 .24332 L
.92249 .24332 L
.93221 .24333 L
.94192 .24335 L
.95163 .24337 L
.96134 .2434 L
.97106 .24344 L
.98077 .24349 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .27591 m
.02894 .27504 L
.03866 .27418 L
.04837 .27335 L
.05808 .27253 L
.06748 .27176 L
.06779 .27173 L
.07751 .27095 L
.08722 .27018 L
.09693 .26944 L
.10664 .26871 L
.11636 .26799 L
.12607 .26729 L
.13578 .26661 L
.14549 .26594 L
.15521 .26528 L
.16492 .26464 L
.17463 .26401 L
.18434 .2634 L
.19406 .2628 L
.20377 .26221 L
.20658 .26204 L
.21348 .26164 L
.22319 .26107 L
.23291 .26052 L
.24262 .25998 L
.25233 .25946 L
.26204 .25894 L
.27176 .25844 L
.28147 .25794 L
.29118 .25746 L
.30089 .25699 L
.31061 .25653 L
.32032 .25607 L
.33003 .25563 L
.33974 .2552 L
.34946 .25478 L
.35917 .25436 L
.36888 .25396 L
.37859 .25356 L
.38831 .25318 L
.39802 .2528 L
.40773 .25243 L
.41048 .25233 L
.41744 .25207 L
.42716 .25172 L
.43687 .25138 L
.44658 .25105 L
.45629 .25072 L
.46601 .2504 L
Mistroke
.47572 .25009 L
.48543 .24979 L
.49514 .24949 L
.50486 .2492 L
.51457 .24892 L
.52428 .24865 L
.53399 .24839 L
.54371 .24813 L
.55342 .24788 L
.56313 .24763 L
.57284 .2474 L
.58256 .24717 L
.59227 .24695 L
.60198 .24673 L
.61169 .24652 L
.62141 .24632 L
.63112 .24613 L
.64083 .24594 L
.65054 .24576 L
.66026 .24558 L
.66997 .24541 L
.67968 .24525 L
.68939 .2451 L
.69911 .24495 L
.70882 .2448 L
.71853 .24467 L
.72824 .24454 L
.73796 .24442 L
.74767 .2443 L
.75738 .24419 L
.76709 .24409 L
.77681 .24399 L
.78652 .2439 L
.79623 .24382 L
.80594 .24374 L
.81566 .24367 L
.82537 .2436 L
.83508 .24355 L
.84479 .24349 L
.85451 .24345 L
.86422 .24341 L
.87393 .24338 L
.88364 .24336 L
.89336 .24334 L
.90307 .24333 L
.91278 .24332 L
.92249 .24332 L
.93221 .24333 L
.94192 .24335 L
.95163 .24337 L
Mistroke
.96134 .2434 L
.97106 .24344 L
.98077 .24349 L
Mfstroke
.625 g
.01923 .37114 m
.02894 .3692 L
.03053 .36888 L
.03866 .3673 L
.04837 .36544 L
.05808 .36364 L
.06779 .36187 L
.07751 .36015 L
.08318 .35917 L
.08722 .35848 L
.09693 .35684 L
.10664 .35524 L
.11636 .35368 L
.12607 .35215 L
.13578 .35066 L
.14383 .34946 L
.14549 .34921 L
.15521 .34779 L
.16492 .3464 L
.17463 .34505 L
.18434 .34372 L
.19406 .34243 L
.20377 .34116 L
.21348 .33993 L
.21493 .33974 L
.22319 .33872 L
.23291 .33754 L
.24262 .33638 L
.25233 .33526 L
.26204 .33415 L
.27176 .33308 L
.28147 .33202 L
.29118 .331 L
.3005 .33003 L
.30089 .32999 L
.31061 .32901 L
.32032 .32805 L
.33003 .32711 L
.33974 .32619 L
.34946 .3253 L
.35917 .32442 L
.36888 .32357 L
.37859 .32273 L
.38831 .32192 L
.39802 .32112 L
.40773 .32034 L
.40805 .32032 L
.41744 .31959 L
.42716 .31884 L
.43687 .31812 L
.44658 .31742 L
.45629 .31673 L
.46601 .31606 L
.47572 .3154 L
.48543 .31477 L
.49514 .31415 L
.50486 .31354 L
.51457 .31295 L
.52428 .31238 L
.53399 .31182 L
.54371 .31128 L
.55342 .31075 L
.55611 .31061 L
.56313 .31024 L
.57284 .30974 L
.58256 .30926 L
.59227 .30879 L
.60198 .30833 L
.61169 .30789 L
.62141 .30747 L
.63112 .30706 L
.64083 .30666 L
.65054 .30627 L
.66026 .3059 L
.66997 .30555 L
.67968 .3052 L
.68939 .30487 L
.69911 .30456 L
.70882 .30425 L
.71853 .30396 L
.72824 .30369 L
.73796 .30342 L
.74767 .30317 L
.75738 .30293 L
.76709 .30271 L
.77681 .3025 L
.78652 .3023 L
.79623 .30211 L
.80594 .30194 L
.81566 .30178 L
.82537 .30164 L
.83508 .3015 L
.84479 .30138 L
.85451 .30128 L
.86422 .30118 L
.87393 .3011 L
.88364 .30103 L
.89336 .30098 L
.90307 .30094 L
.91278 .30091 L
.92249 .3009 L
.93221 .3009 L
.94192 .30092 L
.95163 .30095 L
.96134 .30099 L
.97106 .30105 L
.98077 .30112 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .37114 m
.02894 .3692 L
.03053 .36888 L
.03866 .3673 L
.04837 .36544 L
.05808 .36364 L
.06779 .36187 L
.07751 .36015 L
.08318 .35917 L
.08722 .35848 L
.09693 .35684 L
.10664 .35524 L
.11636 .35368 L
.12607 .35215 L
.13578 .35066 L
.14383 .34946 L
.14549 .34921 L
.15521 .34779 L
.16492 .3464 L
.17463 .34505 L
.18434 .34372 L
.19406 .34243 L
.20377 .34116 L
.21348 .33993 L
.21493 .33974 L
.22319 .33872 L
.23291 .33754 L
.24262 .33638 L
.25233 .33526 L
.26204 .33415 L
.27176 .33308 L
.28147 .33202 L
.29118 .331 L
.3005 .33003 L
.30089 .32999 L
.31061 .32901 L
.32032 .32805 L
.33003 .32711 L
.33974 .32619 L
.34946 .3253 L
.35917 .32442 L
.36888 .32357 L
.37859 .32273 L
.38831 .32192 L
.39802 .32112 L
.40773 .32034 L
.40805 .32032 L
.41744 .31959 L
.42716 .31884 L
.43687 .31812 L
Mistroke
.44658 .31742 L
.45629 .31673 L
.46601 .31606 L
.47572 .3154 L
.48543 .31477 L
.49514 .31415 L
.50486 .31354 L
.51457 .31295 L
.52428 .31238 L
.53399 .31182 L
.54371 .31128 L
.55342 .31075 L
.55611 .31061 L
.56313 .31024 L
.57284 .30974 L
.58256 .30926 L
.59227 .30879 L
.60198 .30833 L
.61169 .30789 L
.62141 .30747 L
.63112 .30706 L
.64083 .30666 L
.65054 .30627 L
.66026 .3059 L
.66997 .30555 L
.67968 .3052 L
.68939 .30487 L
.69911 .30456 L
.70882 .30425 L
.71853 .30396 L
.72824 .30369 L
.73796 .30342 L
.74767 .30317 L
.75738 .30293 L
.76709 .30271 L
.77681 .3025 L
.78652 .3023 L
.79623 .30211 L
.80594 .30194 L
.81566 .30178 L
.82537 .30164 L
.83508 .3015 L
.84479 .30138 L
.85451 .30128 L
.86422 .30118 L
.87393 .3011 L
.88364 .30103 L
.89336 .30098 L
.90307 .30094 L
.91278 .30091 L
Mistroke
.92249 .3009 L
.93221 .3009 L
.94192 .30092 L
.95163 .30095 L
.96134 .30099 L
.97106 .30105 L
.98077 .30112 L
Mfstroke
.7 g
.01923 .47756 m
.02437 .47572 L
.02894 .47411 L
.03866 .47075 L
.04837 .46749 L
.05289 .46601 L
.05808 .46433 L
.06779 .46125 L
.07751 .45825 L
.08402 .45629 L
.08722 .45534 L
.09693 .45251 L
.10664 .44975 L
.11636 .44707 L
.11815 .44658 L
.12607 .44445 L
.13578 .44191 L
.14549 .43943 L
.15521 .43701 L
.1558 .43687 L
.16492 .43466 L
.17463 .43237 L
.18434 .43013 L
.19406 .42795 L
.19764 .42716 L
.20377 .42582 L
.21348 .42375 L
.22319 .42173 L
.23291 .41975 L
.24262 .41783 L
.24458 .41744 L
.25233 .41595 L
.26204 .41412 L
.27176 .41233 L
.28147 .41058 L
.29118 .40888 L
.29789 .40773 L
.30089 .40722 L
.31061 .4056 L
.32032 .40402 L
.33003 .40247 L
.33974 .40097 L
.34946 .3995 L
.35917 .39806 L
.35946 .39802 L
.36888 .39666 L
.37859 .39529 L
.38831 .39396 L
.39802 .39266 L
.40773 .39139 L
.41744 .39015 L
.42716 .38895 L
.43242 .38831 L
.43687 .38777 L
.44658 .38662 L
.45629 .38551 L
.46601 .38442 L
.47572 .38335 L
.48543 .38232 L
.49514 .38131 L
.50486 .38033 L
.51457 .37938 L
.52274 .37859 L
.52428 .37845 L
.53399 .37754 L
.54371 .37667 L
.55342 .37581 L
.56313 .37498 L
.57284 .37418 L
.58256 .3734 L
.59227 .37264 L
.60198 .3719 L
.61169 .37119 L
.62141 .3705 L
.63112 .36983 L
.64083 .36919 L
.64556 .36888 L
.65054 .36856 L
.66026 .36796 L
.66997 .36738 L
.67968 .36683 L
.68939 .36629 L
.69911 .36577 L
.70882 .36528 L
.71853 .3648 L
.72824 .36435 L
.73796 .36392 L
.74767 .36351 L
.75738 .36312 L
.76709 .36275 L
.77681 .36239 L
.78652 .36207 L
.79623 .36176 L
.80594 .36147 L
.81566 .3612 L
.82537 .36095 L
.83508 .36072 L
.84479 .36051 L
.85451 .36032 L
.86422 .36016 L
.87393 .36001 L
.88364 .35988 L
.89336 .35978 L
.90307 .35969 L
.91278 .35963 L
.92249 .35959 L
.93221 .35957 L
.94192 .35957 L
.95163 .35959 L
.96134 .35963 L
.97106 .35969 L
.98077 .35978 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .47756 m
.02437 .47572 L
.02894 .47411 L
.03866 .47075 L
.04837 .46749 L
.05289 .46601 L
.05808 .46433 L
.06779 .46125 L
.07751 .45825 L
.08402 .45629 L
.08722 .45534 L
.09693 .45251 L
.10664 .44975 L
.11636 .44707 L
.11815 .44658 L
.12607 .44445 L
.13578 .44191 L
.14549 .43943 L
.15521 .43701 L
.1558 .43687 L
.16492 .43466 L
.17463 .43237 L
.18434 .43013 L
.19406 .42795 L
.19764 .42716 L
.20377 .42582 L
.21348 .42375 L
.22319 .42173 L
.23291 .41975 L
.24262 .41783 L
.24458 .41744 L
.25233 .41595 L
.26204 .41412 L
.27176 .41233 L
.28147 .41058 L
.29118 .40888 L
.29789 .40773 L
.30089 .40722 L
.31061 .4056 L
.32032 .40402 L
.33003 .40247 L
.33974 .40097 L
.34946 .3995 L
.35917 .39806 L
.35946 .39802 L
.36888 .39666 L
.37859 .39529 L
.38831 .39396 L
.39802 .39266 L
.40773 .39139 L
Mistroke
.41744 .39015 L
.42716 .38895 L
.43242 .38831 L
.43687 .38777 L
.44658 .38662 L
.45629 .38551 L
.46601 .38442 L
.47572 .38335 L
.48543 .38232 L
.49514 .38131 L
.50486 .38033 L
.51457 .37938 L
.52274 .37859 L
.52428 .37845 L
.53399 .37754 L
.54371 .37667 L
.55342 .37581 L
.56313 .37498 L
.57284 .37418 L
.58256 .3734 L
.59227 .37264 L
.60198 .3719 L
.61169 .37119 L
.62141 .3705 L
.63112 .36983 L
.64083 .36919 L
.64556 .36888 L
.65054 .36856 L
.66026 .36796 L
.66997 .36738 L
.67968 .36683 L
.68939 .36629 L
.69911 .36577 L
.70882 .36528 L
.71853 .3648 L
.72824 .36435 L
.73796 .36392 L
.74767 .36351 L
.75738 .36312 L
.76709 .36275 L
.77681 .36239 L
.78652 .36207 L
.79623 .36176 L
.80594 .36147 L
.81566 .3612 L
.82537 .36095 L
.83508 .36072 L
.84479 .36051 L
.85451 .36032 L
.86422 .36016 L
Mistroke
.87393 .36001 L
.88364 .35988 L
.89336 .35978 L
.90307 .35969 L
.91278 .35963 L
.92249 .35959 L
.93221 .35957 L
.94192 .35957 L
.95163 .35959 L
.96134 .35963 L
.97106 .35969 L
.98077 .35978 L
Mfstroke
.775 g
.01923 .60915 m
.02894 .60286 L
.03034 .60198 L
.03866 .59684 L
.04628 .59227 L
.04837 .59105 L
.05808 .58548 L
.06333 .58256 L
.06779 .58012 L
.07751 .57495 L
.08157 .57284 L
.08722 .56997 L
.09693 .56516 L
.10113 .56313 L
.10664 .56051 L
.11636 .55602 L
.12213 .55342 L
.12607 .55168 L
.13578 .54747 L
.14475 .54371 L
.14549 .5434 L
.15521 .53945 L
.16492 .53563 L
.16916 .53399 L
.17463 .53192 L
.18434 .52832 L
.19406 .52483 L
.19561 .52428 L
.20377 .52144 L
.21348 .51815 L
.22319 .51495 L
.22436 .51457 L
.23291 .51184 L
.24262 .50881 L
.25233 .50588 L
.25577 .50486 L
.26204 .50302 L
.27176 .50024 L
.28147 .49753 L
.29028 .49514 L
.29118 .4949 L
.30089 .49234 L
.31061 .48985 L
.32032 .48742 L
.32848 .48543 L
.33003 .48506 L
.33974 .48276 L
.34946 .48052 L
.35917 .47834 L
.36888 .47621 L
.37118 .47572 L
.37859 .47414 L
.38831 .47213 L
.39802 .47017 L
.40773 .46826 L
.41744 .4664 L
.41952 .46601 L
.42716 .46459 L
.43687 .46282 L
.44658 .46111 L
.45629 .45944 L
.46601 .45781 L
.47529 .45629 L
.47572 .45623 L
.48543 .45468 L
.49514 .45319 L
.50486 .45173 L
.51457 .45031 L
.52428 .44893 L
.53399 .44759 L
.54153 .44658 L
.54371 .44629 L
.55342 .44503 L
.56313 .4438 L
.57284 .44261 L
.58256 .44146 L
.59227 .44034 L
.60198 .43925 L
.61169 .4382 L
.62141 .43718 L
.62447 .43687 L
.63112 .4362 L
.64083 .43525 L
.65054 .43433 L
.66026 .43344 L
.66997 .43259 L
.67968 .43176 L
.68939 .43097 L
.69911 .43021 L
.70882 .42948 L
.71853 .42877 L
.72824 .4281 L
.73796 .42746 L
.74277 .42716 L
.74767 .42685 L
.75738 .42627 L
.76709 .42572 L
.77681 .42519 L
.78652 .4247 L
.79623 .42424 L
.80594 .4238 L
.81566 .42339 L
.82537 .42301 L
.83508 .42267 L
.84479 .42235 L
.85451 .42205 L
.86422 .42179 L
.87393 .42156 L
.88364 .42135 L
.89336 .42118 L
.90307 .42103 L
.91278 .42092 L
.92249 .42083 L
.93221 .42077 L
.94192 .42075 L
.95163 .42075 L
.96134 .42078 L
.97106 .42085 L
.98077 .42094 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .60915 m
.02894 .60286 L
.03034 .60198 L
.03866 .59684 L
.04628 .59227 L
.04837 .59105 L
.05808 .58548 L
.06333 .58256 L
.06779 .58012 L
.07751 .57495 L
.08157 .57284 L
.08722 .56997 L
.09693 .56516 L
.10113 .56313 L
.10664 .56051 L
.11636 .55602 L
.12213 .55342 L
.12607 .55168 L
.13578 .54747 L
.14475 .54371 L
.14549 .5434 L
.15521 .53945 L
.16492 .53563 L
.16916 .53399 L
.17463 .53192 L
.18434 .52832 L
.19406 .52483 L
.19561 .52428 L
.20377 .52144 L
.21348 .51815 L
.22319 .51495 L
.22436 .51457 L
.23291 .51184 L
.24262 .50881 L
.25233 .50588 L
.25577 .50486 L
.26204 .50302 L
.27176 .50024 L
.28147 .49753 L
.29028 .49514 L
.29118 .4949 L
.30089 .49234 L
.31061 .48985 L
.32032 .48742 L
.32848 .48543 L
.33003 .48506 L
.33974 .48276 L
.34946 .48052 L
.35917 .47834 L
.36888 .47621 L
Mistroke
.37118 .47572 L
.37859 .47414 L
.38831 .47213 L
.39802 .47017 L
.40773 .46826 L
.41744 .4664 L
.41952 .46601 L
.42716 .46459 L
.43687 .46282 L
.44658 .46111 L
.45629 .45944 L
.46601 .45781 L
.47529 .45629 L
.47572 .45623 L
.48543 .45468 L
.49514 .45319 L
.50486 .45173 L
.51457 .45031 L
.52428 .44893 L
.53399 .44759 L
.54153 .44658 L
.54371 .44629 L
.55342 .44503 L
.56313 .4438 L
.57284 .44261 L
.58256 .44146 L
.59227 .44034 L
.60198 .43925 L
.61169 .4382 L
.62141 .43718 L
.62447 .43687 L
.63112 .4362 L
.64083 .43525 L
.65054 .43433 L
.66026 .43344 L
.66997 .43259 L
.67968 .43176 L
.68939 .43097 L
.69911 .43021 L
.70882 .42948 L
.71853 .42877 L
.72824 .4281 L
.73796 .42746 L
.74277 .42716 L
.74767 .42685 L
.75738 .42627 L
.76709 .42572 L
.77681 .42519 L
.78652 .4247 L
.79623 .42424 L
Mistroke
.80594 .4238 L
.81566 .42339 L
.82537 .42301 L
.83508 .42267 L
.84479 .42235 L
.85451 .42205 L
.86422 .42179 L
.87393 .42156 L
.88364 .42135 L
.89336 .42118 L
.90307 .42103 L
.91278 .42092 L
.92249 .42083 L
.93221 .42077 L
.94192 .42075 L
.95163 .42075 L
.96134 .42078 L
.97106 .42085 L
.98077 .42094 L
Mfstroke
.85 g
.98077 .48683 m
.97106 .48673 L
.96134 .48667 L
.95163 .48665 L
.94192 .48668 L
.93221 .48674 L
.92249 .48685 L
.91278 .487 L
.90307 .48718 L
.89336 .48741 L
.88364 .48768 L
.87393 .48799 L
.86422 .48834 L
.85451 .48873 L
.84479 .48916 L
.83508 .48963 L
.82537 .49014 L
.81566 .49069 L
.80594 .49128 L
.79623 .49191 L
.78652 .49258 L
.77681 .49329 L
.76709 .49405 L
.75738 .49484 L
.75382 .49514 L
.74767 .49568 L
.73796 .49656 L
.72824 .49748 L
.71853 .49844 L
.70882 .49945 L
.69911 .5005 L
.68939 .50159 L
.67968 .50273 L
.66997 .50391 L
.66246 .50486 L
.66026 .50514 L
.65054 .50641 L
.64083 .50774 L
.63112 .50911 L
.62141 .51052 L
.61169 .51199 L
.60198 .51351 L
.5954 .51457 L
.59227 .51508 L
.58256 .5167 L
.57284 .51838 L
.56313 .52011 L
.55342 .52189 L
.54371 .52373 L
.54086 .52428 L
.53399 .52563 L
.52428 .52759 L
.51457 .52961 L
.50486 .53169 L
.49514 .53384 L
.49444 .53399 L
.48543 .53605 L
.47572 .53833 L
.46601 .54068 L
.45629 .5431 L
.45389 .54371 L
.44658 .54559 L
.43687 .54816 L
.42716 .55081 L
.41787 .55342 L
.41744 .55354 L
.40773 .55635 L
.39802 .55926 L
.38831 .56225 L
.38549 .56313 L
.37859 .56533 L
.36888 .56852 L
.35917 .5718 L
.35614 .57284 L
.34946 .57519 L
.33974 .57869 L
.33003 .5823 L
.32936 .58256 L
.32032 .58604 L
.31061 .5899 L
.30481 .59227 L
.30089 .5939 L
.29118 .59803 L
.2822 .60198 L
.28147 .60231 L
.27176 .60675 L
.26204 .61135 L
.26133 .61169 L
.25233 .61612 L
.24262 .62109 L
.24201 .62141 L
.23291 .62625 L
.22409 .63112 L
.22319 .63162 L
.21348 .63723 L
.20745 .64083 L
.20377 .64308 L
.19406 .64921 L
.19199 .65054 L
.18434 .65562 L
.17762 .66026 L
.17463 .66237 L
.16492 .66947 L
.16425 .66997 L
.15521 .67697 L
.15183 .67968 L
.14549 .68492 L
.14029 .68939 L
.13578 .6934 L
.12959 .69911 L
.12607 .70247 L
.11968 .70882 L
.11636 .71225 L
.11052 .71853 L
.10664 .7229 L
.10209 .72824 L
.09693 .73463 L
.09436 .73796 L
.08729 .74767 L
.08722 .74778 L
.08089 .75738 L
.07751 .76294 L
.07511 .76709 L
.06997 .77681 L
.06779 .7813 L
.06544 .78652 L
.06151 .79623 L
.0582 .80594 L
.05808 .80631 L
.05549 .81566 L
.05338 .82537 L
.05189 .83508 L
.05101 .84479 L
.05077 .85451 L
.05117 .86422 L
.05224 .87393 L
.05399 .88364 L
.05645 .89336 L
.05808 .89865 L
.05964 .90307 L
.06361 .91278 L
.06779 .92137 L
.06839 .92249 L
.07403 .93221 L
.07751 .93755 L
.08057 .94192 L
.08722 .95058 L
.08808 .95163 L
.09663 .96134 L
.09693 .96167 L
.10628 .97106 L
.10664 .9714 L
.11636 .9801 L
.11714 .98077 L
.98077 .98077 L
F
0 g
.98077 .48683 m
.97106 .48673 L
.96134 .48667 L
.95163 .48665 L
.94192 .48668 L
.93221 .48674 L
.92249 .48685 L
.91278 .487 L
.90307 .48718 L
.89336 .48741 L
.88364 .48768 L
.87393 .48799 L
.86422 .48834 L
.85451 .48873 L
.84479 .48916 L
.83508 .48963 L
.82537 .49014 L
.81566 .49069 L
.80594 .49128 L
.79623 .49191 L
.78652 .49258 L
.77681 .49329 L
.76709 .49405 L
.75738 .49484 L
.75382 .49514 L
.74767 .49568 L
.73796 .49656 L
.72824 .49748 L
.71853 .49844 L
.70882 .49945 L
.69911 .5005 L
.68939 .50159 L
.67968 .50273 L
.66997 .50391 L
.66246 .50486 L
.66026 .50514 L
.65054 .50641 L
.64083 .50774 L
.63112 .50911 L
.62141 .51052 L
.61169 .51199 L
.60198 .51351 L
.5954 .51457 L
.59227 .51508 L
.58256 .5167 L
.57284 .51838 L
.56313 .52011 L
.55342 .52189 L
.54371 .52373 L
.54086 .52428 L
Mistroke
.53399 .52563 L
.52428 .52759 L
.51457 .52961 L
.50486 .53169 L
.49514 .53384 L
.49444 .53399 L
.48543 .53605 L
.47572 .53833 L
.46601 .54068 L
.45629 .5431 L
.45389 .54371 L
.44658 .54559 L
.43687 .54816 L
.42716 .55081 L
.41787 .55342 L
.41744 .55354 L
.40773 .55635 L
.39802 .55926 L
.38831 .56225 L
.38549 .56313 L
.37859 .56533 L
.36888 .56852 L
.35917 .5718 L
.35614 .57284 L
.34946 .57519 L
.33974 .57869 L
.33003 .5823 L
.32936 .58256 L
.32032 .58604 L
.31061 .5899 L
.30481 .59227 L
.30089 .5939 L
.29118 .59803 L
.2822 .60198 L
.28147 .60231 L
.27176 .60675 L
.26204 .61135 L
.26133 .61169 L
.25233 .61612 L
.24262 .62109 L
.24201 .62141 L
.23291 .62625 L
.22409 .63112 L
.22319 .63162 L
.21348 .63723 L
.20745 .64083 L
.20377 .64308 L
.19406 .64921 L
.19199 .65054 L
.18434 .65562 L
Mistroke
.17762 .66026 L
.17463 .66237 L
.16492 .66947 L
.16425 .66997 L
.15521 .67697 L
.15183 .67968 L
.14549 .68492 L
.14029 .68939 L
.13578 .6934 L
.12959 .69911 L
.12607 .70247 L
.11968 .70882 L
.11636 .71225 L
.11052 .71853 L
.10664 .7229 L
.10209 .72824 L
.09693 .73463 L
.09436 .73796 L
.08729 .74767 L
.08722 .74778 L
.08089 .75738 L
.07751 .76294 L
.07511 .76709 L
.06997 .77681 L
.06779 .7813 L
.06544 .78652 L
.06151 .79623 L
.0582 .80594 L
.05808 .80631 L
.05549 .81566 L
.05338 .82537 L
.05189 .83508 L
.05101 .84479 L
.05077 .85451 L
.05117 .86422 L
.05224 .87393 L
.05399 .88364 L
.05645 .89336 L
.05808 .89865 L
.05964 .90307 L
.06361 .91278 L
.06779 .92137 L
.06839 .92249 L
.07403 .93221 L
.07751 .93755 L
.08057 .94192 L
.08722 .95058 L
.08808 .95163 L
.09663 .96134 L
.09693 .96167 L
Mistroke
.10628 .97106 L
.10664 .9714 L
.11636 .9801 L
.11714 .98077 L
Mfstroke
.25 g
.98077 .06517 m
.97106 .06535 L
.96134 .06551 L
.95163 .06565 L
.94192 .06578 L
.93221 .06589 L
.92249 .06599 L
.91278 .06607 L
.90307 .06614 L
.89336 .06619 L
.88364 .06623 L
.87393 .06625 L
.86422 .06626 L
.85451 .06626 L
.84479 .06624 L
.83508 .06621 L
.82537 .06616 L
.81566 .0661 L
.80594 .06603 L
.79623 .06595 L
.78652 .06585 L
.77681 .06574 L
.76709 .06562 L
.75738 .06548 L
.74767 .06533 L
.73796 .06517 L
.72824 .06499 L
.71853 .06481 L
.70882 .06461 L
.69911 .06439 L
.68939 .06417 L
.67968 .06393 L
.66997 .06368 L
.66026 .06342 L
.65054 .06314 L
.64083 .06286 L
.63112 .06256 L
.62141 .06224 L
.61169 .06192 L
.60198 .06158 L
.59227 .06123 L
.58256 .06087 L
.57284 .06049 L
.56313 .0601 L
.55342 .0597 L
.54371 .05929 L
.53399 .05886 L
.52428 .05842 L
.51692 .05808 L
.51457 .05797 L
.50486 .0575 L
.49514 .05703 L
.48543 .05653 L
.47572 .05603 L
.46601 .05551 L
.45629 .05498 L
.44658 .05443 L
.43687 .05387 L
.42716 .0533 L
.41744 .05271 L
.40773 .05211 L
.39802 .05149 L
.38831 .05086 L
.37859 .05022 L
.36888 .04956 L
.35917 .04889 L
.35186 .04837 L
.34946 .0482 L
.33974 .04749 L
.33003 .04677 L
.32032 .04604 L
.31061 .04529 L
.30089 .04452 L
.29118 .04374 L
.28147 .04294 L
.27176 .04213 L
.26204 .0413 L
.25233 .04045 L
.24262 .03959 L
.23291 .03871 L
.23235 .03866 L
.22319 .03781 L
.21348 .03689 L
.20377 .03596 L
.19406 .03501 L
.18434 .03404 L
.17463 .03305 L
.16492 .03204 L
.15521 .03101 L
.14549 .02997 L
.13616 .02894 L
.13578 .0289 L
.12607 .02782 L
.11636 .02671 L
.10664 .02558 L
.09693 .02444 L
.08722 .02327 L
.07751 .02208 L
.06779 .02087 L
.05808 .01964 L
.05491 .01923 L
.98077 .01923 L
F
0 g
.98077 .06517 m
.97106 .06535 L
.96134 .06551 L
.95163 .06565 L
.94192 .06578 L
.93221 .06589 L
.92249 .06599 L
.91278 .06607 L
.90307 .06614 L
.89336 .06619 L
.88364 .06623 L
.87393 .06625 L
.86422 .06626 L
.85451 .06626 L
.84479 .06624 L
.83508 .06621 L
.82537 .06616 L
.81566 .0661 L
.80594 .06603 L
.79623 .06595 L
.78652 .06585 L
.77681 .06574 L
.76709 .06562 L
.75738 .06548 L
.74767 .06533 L
.73796 .06517 L
.72824 .06499 L
.71853 .06481 L
.70882 .06461 L
.69911 .06439 L
.68939 .06417 L
.67968 .06393 L
.66997 .06368 L
.66026 .06342 L
.65054 .06314 L
.64083 .06286 L
.63112 .06256 L
.62141 .06224 L
.61169 .06192 L
.60198 .06158 L
.59227 .06123 L
.58256 .06087 L
.57284 .06049 L
.56313 .0601 L
.55342 .0597 L
.54371 .05929 L
.53399 .05886 L
.52428 .05842 L
.51692 .05808 L
.51457 .05797 L
Mistroke
.50486 .0575 L
.49514 .05703 L
.48543 .05653 L
.47572 .05603 L
.46601 .05551 L
.45629 .05498 L
.44658 .05443 L
.43687 .05387 L
.42716 .0533 L
.41744 .05271 L
.40773 .05211 L
.39802 .05149 L
.38831 .05086 L
.37859 .05022 L
.36888 .04956 L
.35917 .04889 L
.35186 .04837 L
.34946 .0482 L
.33974 .04749 L
.33003 .04677 L
.32032 .04604 L
.31061 .04529 L
.30089 .04452 L
.29118 .04374 L
.28147 .04294 L
.27176 .04213 L
.26204 .0413 L
.25233 .04045 L
.24262 .03959 L
.23291 .03871 L
.23235 .03866 L
.22319 .03781 L
.21348 .03689 L
.20377 .03596 L
.19406 .03501 L
.18434 .03404 L
.17463 .03305 L
.16492 .03204 L
.15521 .03101 L
.14549 .02997 L
.13616 .02894 L
.13578 .0289 L
.12607 .02782 L
.11636 .02671 L
.10664 .02558 L
.09693 .02444 L
.08722 .02327 L
.07751 .02208 L
.06779 .02087 L
.05808 .01964 L
Mistroke
.05491 .01923 L
Mfstroke
.925 g
.98077 .56176 m
.97106 .56164 L
.96134 .56159 L
.95163 .56159 L
.94192 .56165 L
.93221 .56177 L
.92249 .56194 L
.91278 .56218 L
.90307 .56247 L
.89336 .56282 L
.88586 .56313 L
.88364 .56323 L
.87393 .56369 L
.86422 .56422 L
.85451 .5648 L
.84479 .56543 L
.83508 .56613 L
.82537 .56688 L
.81566 .56769 L
.80594 .56856 L
.79623 .56949 L
.78652 .57048 L
.77681 .57153 L
.76709 .57264 L
.76538 .57284 L
.75738 .57381 L
.74767 .57505 L
.73796 .57634 L
.72824 .5777 L
.71853 .57913 L
.70882 .58062 L
.69911 .58218 L
.69683 .58256 L
.68939 .58381 L
.67968 .58551 L
.66997 .58727 L
.66026 .58912 L
.65054 .59103 L
.64448 .59227 L
.64083 .59303 L
.63112 .5951 L
.62141 .59725 L
.61169 .59949 L
.60198 .60181 L
.60126 .60198 L
.59227 .60422 L
.58256 .60672 L
.57284 .60931 L
.56423 .61169 L
.56313 .612 L
.55342 .6148 L
.54371 .61769 L
.53399 .6207 L
.53178 .62141 L
.52428 .62383 L
.51457 .62707 L
.50486 .63044 L
.50293 .63112 L
.49514 .63393 L
.48543 .63757 L
.47704 .64083 L
.47572 .64136 L
.46601 .64529 L
.45629 .6494 L
.45365 .65054 L
.44658 .65367 L
.43687 .65814 L
.4324 .66026 L
.42716 .6628 L
.41744 .66768 L
.41305 .66997 L
.40773 .6728 L
.39802 .67817 L
.39538 .67968 L
.38831 .68383 L
.37922 .68939 L
.37859 .68979 L
.36888 .6961 L
.36446 .69911 L
.35917 .70281 L
.35097 .70882 L
.34946 .70997 L
.33974 .71764 L
.33867 .71853 L
.33003 .72594 L
.32748 .72824 L
.32032 .735 L
.31734 .73796 L
.31061 .74501 L
.3082 .74767 L
.30089 .75628 L
.30001 .75738 L
.29275 .76709 L
.29118 .76936 L
.28639 .77681 L
.28147 .78542 L
.28089 .78652 L
.27626 .79623 L
.27247 .80594 L
.27176 .808 L
.26953 .81566 L
.26743 .82537 L
.26619 .83508 L
.2658 .84479 L
.2663 .85451 L
.26769 .86422 L
.27001 .87393 L
.27176 .87952 L
.2733 .88364 L
.27759 .89336 L
.28147 .9006 L
.28294 .90307 L
.28941 .91278 L
.29118 .91518 L
.29707 .92249 L
.30089 .92683 L
.306 .93221 L
.31061 .93671 L
.31632 .94192 L
.32032 .94536 L
.32813 .95163 L
.33003 .95309 L
.33974 .96009 L
.34159 .96134 L
.34946 .9665 L
.35687 .97106 L
.35917 .97242 L
.36888 .97791 L
.37421 .98077 L
.98077 .98077 L
F
0 g
.98077 .56176 m
.97106 .56164 L
.96134 .56159 L
.95163 .56159 L
.94192 .56165 L
.93221 .56177 L
.92249 .56194 L
.91278 .56218 L
.90307 .56247 L
.89336 .56282 L
.88586 .56313 L
.88364 .56323 L
.87393 .56369 L
.86422 .56422 L
.85451 .5648 L
.84479 .56543 L
.83508 .56613 L
.82537 .56688 L
.81566 .56769 L
.80594 .56856 L
.79623 .56949 L
.78652 .57048 L
.77681 .57153 L
.76709 .57264 L
.76538 .57284 L
.75738 .57381 L
.74767 .57505 L
.73796 .57634 L
.72824 .5777 L
.71853 .57913 L
.70882 .58062 L
.69911 .58218 L
.69683 .58256 L
.68939 .58381 L
.67968 .58551 L
.66997 .58727 L
.66026 .58912 L
.65054 .59103 L
.64448 .59227 L
.64083 .59303 L
.63112 .5951 L
.62141 .59725 L
.61169 .59949 L
.60198 .60181 L
.60126 .60198 L
.59227 .60422 L
.58256 .60672 L
.57284 .60931 L
.56423 .61169 L
.56313 .612 L
Mistroke
.55342 .6148 L
.54371 .61769 L
.53399 .6207 L
.53178 .62141 L
.52428 .62383 L
.51457 .62707 L
.50486 .63044 L
.50293 .63112 L
.49514 .63393 L
.48543 .63757 L
.47704 .64083 L
.47572 .64136 L
.46601 .64529 L
.45629 .6494 L
.45365 .65054 L
.44658 .65367 L
.43687 .65814 L
.4324 .66026 L
.42716 .6628 L
.41744 .66768 L
.41305 .66997 L
.40773 .6728 L
.39802 .67817 L
.39538 .67968 L
.38831 .68383 L
.37922 .68939 L
.37859 .68979 L
.36888 .6961 L
.36446 .69911 L
.35917 .70281 L
.35097 .70882 L
.34946 .70997 L
.33974 .71764 L
.33867 .71853 L
.33003 .72594 L
.32748 .72824 L
.32032 .735 L
.31734 .73796 L
.31061 .74501 L
.3082 .74767 L
.30089 .75628 L
.30001 .75738 L
.29275 .76709 L
.29118 .76936 L
.28639 .77681 L
.28147 .78542 L
.28089 .78652 L
.27626 .79623 L
.27247 .80594 L
.27176 .808 L
Mistroke
.26953 .81566 L
.26743 .82537 L
.26619 .83508 L
.2658 .84479 L
.2663 .85451 L
.26769 .86422 L
.27001 .87393 L
.27176 .87952 L
.2733 .88364 L
.27759 .89336 L
.28147 .9006 L
.28294 .90307 L
.28941 .91278 L
.29118 .91518 L
.29707 .92249 L
.30089 .92683 L
.306 .93221 L
.31061 .93671 L
.31632 .94192 L
.32032 .94536 L
.32813 .95163 L
.33003 .95309 L
.33974 .96009 L
.34159 .96134 L
.34946 .9665 L
.35687 .97106 L
.35917 .97242 L
.36888 .97791 L
.37421 .98077 L
Mfstroke
1 g
.98077 .65812 m
.97106 .65792 L
.96134 .65783 L
.95163 .65783 L
.94192 .65794 L
.93221 .65814 L
.92249 .65844 L
.91278 .65884 L
.90307 .65933 L
.89336 .65992 L
.8885 .66026 L
.88364 .66061 L
.87393 .6614 L
.86422 .66229 L
.85451 .66328 L
.84479 .66437 L
.83508 .66556 L
.82537 .66685 L
.81566 .66825 L
.80594 .66976 L
.80467 .66997 L
.79623 .67138 L
.78652 .67312 L
.77681 .67497 L
.76709 .67694 L
.75738 .67903 L
.75448 .67968 L
.74767 .68125 L
.73796 .68361 L
.72824 .68611 L
.71853 .68876 L
.71627 .68939 L
.70882 .69156 L
.69911 .69452 L
.68939 .69766 L
.68508 .69911 L
.67968 .70098 L
.66997 .70449 L
.66026 .70822 L
.65876 .70882 L
.65054 .71219 L
.64083 .7164 L
.63616 .71853 L
.63112 .7209 L
.62141 .72571 L
.61655 .72824 L
.61169 .73087 L
.60198 .73644 L
.59947 .73796 L
.59227 .74249 L
.58459 .74767 L
.58256 .7491 L
.57284 .75643 L
.57166 .75738 L
.56313 .76467 L
.56051 .76709 L
.55342 .77418 L
.55101 .77681 L
.54371 .78565 L
.54306 .78652 L
.53659 .79623 L
.53399 .80081 L
.53155 .80594 L
.5279 .81566 L
.52565 .82537 L
.52479 .83508 L
.52534 .84479 L
.52734 .85451 L
.53086 .86422 L
.53399 .87064 L
.53596 .87393 L
.54275 .88364 L
.54371 .88484 L
.55138 .89336 L
.55342 .89538 L
.56203 .90307 L
.56313 .90398 L
.57284 .91133 L
.57493 .91278 L
.58256 .91779 L
.59042 .92249 L
.59227 .92355 L
.60198 .92876 L
.60895 .93221 L
.61169 .93351 L
.62141 .93787 L
.63112 .94189 L
.6312 .94192 L
.64083 .94561 L
.65054 .94908 L
.6582 .95163 L
.66026 .9523 L
.66997 .9553 L
.67968 .95811 L
.68939 .96073 L
.69176 .96134 L
.69911 .96318 L
.70882 .96548 L
.71853 .96762 L
.72824 .96962 L
.73565 .97106 L
.73796 .97149 L
.74767 .97323 L
.75738 .97484 L
.76709 .97634 L
.77681 .97773 L
.78652 .97901 L
.79623 .98018 L
.80145 .98077 L
.98077 .98077 L
F
0 g
.98077 .65812 m
.97106 .65792 L
.96134 .65783 L
.95163 .65783 L
.94192 .65794 L
.93221 .65814 L
.92249 .65844 L
.91278 .65884 L
.90307 .65933 L
.89336 .65992 L
.8885 .66026 L
.88364 .66061 L
.87393 .6614 L
.86422 .66229 L
.85451 .66328 L
.84479 .66437 L
.83508 .66556 L
.82537 .66685 L
.81566 .66825 L
.80594 .66976 L
.80467 .66997 L
.79623 .67138 L
.78652 .67312 L
.77681 .67497 L
.76709 .67694 L
.75738 .67903 L
.75448 .67968 L
.74767 .68125 L
.73796 .68361 L
.72824 .68611 L
.71853 .68876 L
.71627 .68939 L
.70882 .69156 L
.69911 .69452 L
.68939 .69766 L
.68508 .69911 L
.67968 .70098 L
.66997 .70449 L
.66026 .70822 L
.65876 .70882 L
.65054 .71219 L
.64083 .7164 L
.63616 .71853 L
.63112 .7209 L
.62141 .72571 L
.61655 .72824 L
.61169 .73087 L
.60198 .73644 L
.59947 .73796 L
.59227 .74249 L
Mistroke
.58459 .74767 L
.58256 .7491 L
.57284 .75643 L
.57166 .75738 L
.56313 .76467 L
.56051 .76709 L
.55342 .77418 L
.55101 .77681 L
.54371 .78565 L
.54306 .78652 L
.53659 .79623 L
.53399 .80081 L
.53155 .80594 L
.5279 .81566 L
.52565 .82537 L
.52479 .83508 L
.52534 .84479 L
.52734 .85451 L
.53086 .86422 L
.53399 .87064 L
.53596 .87393 L
.54275 .88364 L
.54371 .88484 L
.55138 .89336 L
.55342 .89538 L
.56203 .90307 L
.56313 .90398 L
.57284 .91133 L
.57493 .91278 L
.58256 .91779 L
.59042 .92249 L
.59227 .92355 L
.60198 .92876 L
.60895 .93221 L
.61169 .93351 L
.62141 .93787 L
.63112 .94189 L
.6312 .94192 L
.64083 .94561 L
.65054 .94908 L
.6582 .95163 L
.66026 .9523 L
.66997 .9553 L
.67968 .95811 L
.68939 .96073 L
.69176 .96134 L
.69911 .96318 L
.70882 .96548 L
.71853 .96762 L
.72824 .96962 L
Mistroke
.73565 .97106 L
.73796 .97149 L
.74767 .97323 L
.75738 .97484 L
.76709 .97634 L
.77681 .97773 L
.78652 .97901 L
.79623 .98018 L
.80145 .98077 L
Mfstroke
0 0 0 r
.055 w
.94339 .82588 Mdot
0 1 1 r
.045 w
.01923 .01923 Mdot
.81501 .98077 Mdot
.98077 .82151 Mdot
.94397 .82587 Mdot
.94339 .82588 Mdot
.94339 .82588 Mdot
1 0 0 r
.0325 w
.01923 .01923 Mdot
.81501 .98077 Mdot
.98077 .82151 Mdot
.94397 .82587 Mdot
.94339 .82588 Mdot
.94339 .82588 Mdot
0 1 0 r
.02 w
.01923 .01923 Mdot
.81501 .98077 Mdot
.98077 .82151 Mdot
.94397 .82587 Mdot
.94339 .82588 Mdot
.94339 .82588 Mdot
0 0 1 r
.5 Mabswid
.01923 .01923 m
.01923 .01923 L
.81501 .98077 L
.98077 .82151 L
.94397 .82587 L
.94339 .82588 L
.94339 .82588 L
s
.015 w
.01923 .01923 Mdot
.01923 .01923 Mdot
.81501 .98077 Mdot
.98077 .82151 Mdot
.94397 .82587 Mdot
.94339 .82588 Mdot
.94339 .82588 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00603oool5000003H0oooo1@0000020?ooo`8000000`3oool500000300oooo1@0000020?oo
o`8000000`3oool400000380oooo1@0000020?ooo`800000103oool2000003/0oooo000J0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0b0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`070?ooo`04
0000003oool0oooo000003X0oooo000J0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0=03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03T0oooo000J0?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo03P0oooo000J0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000
=03oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000003X0oooo000I0?ooo`800000
>@3oool2000000X0oooo0P00000c0?ooo`8000002P3oool2000003@0oooo0P00000:0?ooo`800000
>`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool001D0ooooo`00000;00000040oooo000E0?ooo`030000003oool0oooo00<00?oo303oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`090?ooo`4000000@3oool001D0oooo00@00000003oo`00ool00?oo0P3o0002
003ooch0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0
oooo03d0oooo0@0000010?ooo`003@3oool5000000<0oooo0P00ool60?l00003003oo`3oool0oooo
0?h0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`800?oo0P3o0003003o0003
0?l00000ool0oooo0?l0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`04003o
o`3o0000o`00003o0080003o0P00o`000`3o00000?oo0?ooo`030?ooo`030000003oool0oooo0?L0
oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`03003oo`3o0000o`0000@0003o
00<00?l00?l00000ool01@1CDe<700000>h0?clo1@3oool100000040oooo000?0?ooo`030000003o
ool0oooo00<0oooo0P00ool00`3o00000?l00000o`02003o00030000o`00ool00?oo00`0De=C2P00
003T03lo?`D0oooo0@0000010?ooo`003P3oool2000000D0oooo0P00ool20?l000<00?l000<0003o
003oo`1CDe<05P1CDe<800000=`0?clo1@3oool100000040oooo000E0?ooo`@00?oo0P3o0002003o
o`030000o`1CDe<0De=C01d0De=C2P00003B03lo?`D0oooo0@0000010?ooo`005@3oool00`000000
0?oo003oo`05003oo`0305=CD`000?l0De=C02L0De=C2`00003703lo?`D0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`03003oo`@0De=C00<0003o05=CD`1CDe<0<01CDe<:00000;d0?clo
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1P1CDe<00`000?l0De=C05=C
D`0i05=CD`d00000/00o?cl50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool7
05=CD`030000o`1CDe<0De=C04D0De=C3@00002S03lo?`D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`L0De=C00<0003o05=CD`1CDe<0DP1CDe<?000009@0?clo1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo201CDe<00`000?l0De=C05=CD`1P05=CDa80
0000PP0o?cl50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool905=CD`030000
o`1CDe<0De=C0740De=C6000001Z03lo?`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`X0De=C00<0003o05=CD`1CDe<0R01CDe<Q000004T0?clo1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo2`1CDe<00`000?l0De=C05=CD`2X05=CDdX00000103oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo301CDe<00`000?l0De=C05=CD`3`05=C
D`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo``0De=C00<0003o05=CD`1C
De<0l01CDe<50?ooo`4000000@3oool001D0oooo0P0000030?ooo`d0De=C00<0003o05=CD`1CDe<0
k`1CDe<40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3oool>05=CD`030000o`1C
De<0De=C0>h0De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3`1CDe<0
0`000?l0De=C05=CD`3]05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa00De=C00<0003o05=CD`1CDe<0k01CDe<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool@05=CD`030000o`1CDe<0De=C0>`0De=C1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo4@1CDe<00`000?l0De=C05=CD`3[05=CD`D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`L000002`1CDe<00`000?l0De=C05=CD`3Z05=CD`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`L0IVIV300000000`000?l000000000003Y
05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa@0IVIV00<0003o06IV
IP0000004@00003G05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaD0
IVIV00<0003o06IVIP1VIVH0401VIVHE00000<80De=C1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo5@1VIVH00`000?l0IVIV06IVIP0U06IVIQL00000Z`1CDe<50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolF06IVIP030000o`1VIVH0IVIV03/0IVIV7`00
002<05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0IVIV00<0003o
06IVIP1VIVH0F@1VIVH/00000600De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo601VIVH00`000?l0IVIV06IVIP2406IVIV400000103oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo6@1VIVH00`000?l0IVIV06IVIP3S06IVIPD0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?oooaX0IVIV00<0003o06IVIP1VIVH0hP1VIVH50?ooo`400000
0@3oool001D0oooo0P0000030?oooaX0IVIV00<0003o06IVIP1VIVH0hP1VIVH40?ooo`8000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolK06IVIP030000o`1VIVH0IVIV0>40IVIV1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo701VIVH00`000?l0IVIV06IVIP3P06IV
IPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooad0IVIV00<0003o06IVIP1V
IVH0g`1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolN06IVIP030000
o`1VIVH0IVIV0=h0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7P1V
IVH00`000?l0IVIV06IVIP3N06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?oooal0IVIV00<0003o06IVIP1VIVH0g@1VIVH50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3ooolP06IVIP030000o`1VIVH0IVIV0=`0IVIV1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo8@1VIVH00`000?l0IVIV06IVIP3K06IVIPD0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooob80IVIV00<0003o06IVIP1VIVH0fP1VIVH50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolS06IVIP030000o`1VIVH0IVIV0=T0IVIV1@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo8`1VIVH00`000?l0IVIV06IVIP3I
06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooob@0IVIV00<0003o06IV
IP1VIVH0f01VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolU00000003
0000o`00000000000=P00000103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
9P1iNGT00`000?l0NGUi07UiN@3F07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooobL0NGUi00<0003o07UiN@1iNGT0e@1iNGT50?ooo`4000000@3oool001D0oooo0P000003
0?ooobP0NGUi00<0003o07UiN@1iNGT0e01iNGT40?ooo`8000000@3oool001D0oooo00<000000?oo
o`3oool00P3ooolX07UiN@030000o`1iNGT0NGUi0=@0NGUi1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo:@1iNGT00`000?l0NGUi07UiN@3C07UiN@D0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooobX0NGUi00<0003o07UiN@1iNGT0dP1iNGT50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool[07UiN@030000o`1iNGT0NGUi0=40NGUi1@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;01iNGT00`000?l0NGUi07UiN@3@
07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobd0NGUi00<0003o07Ui
N@1iNGT0c`1iNGT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool]07UiN@03
0000o`1iNGT0NGUi0<l0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
;P1iNGT00`000?l0NGUi07UiN@3>07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooobl0NGUi00<0003o07UiN@1iNGT0c@1iNGT50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool`07UiN@030000o`1iNGT0NGUi0<`0NGUi1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo<@1iNGT00`000?l0NGUi07UiN@3;07UiN@D0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooc40NGUi00<0003o07UiN@1iNGT0O@1iNGU?000000@0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc80NGUi00<0003o07UiN@1iNGT0
CP1iNGT^000004h0S8b<1@3oool100000040oooo00000`3oool000000000000300000080oooo0P00
00030?ooo`@00000103oool00`000000oooo0?ooo`020?oooc<0NGUi00<0003o07UiN@1iNGT0<@1i
NGTL000007`0S8b<1@3oool100000040oooo00030?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`020?oooc@0NGUi00<0003o07UiN@1iNGT0601iNGTH
000009P0S8b<1@3oool100000040oooo00030?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0103oool2000000<0oooo=@1iNGT00`000?l0NGUi07UiN@0307UiNA@00000/02<S8`40?oo
o`8000000@3oool000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo:@1iNGT=000000030000o`000000000000800000a02<S8`50?ooo`40
00000@3oool000<0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo0080oooo701iNGT=000000d0S8b<00<0003o08b<S02<S8`0aP2<S8`50?ooo`40
00000@3oool00080oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`l0NGUi
3@00000K08b<S0030000o`2<S8`0S8b<0<D0S8b<1@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo0P1iNGT=000002T0S8b<00<0003o08b<S02<S8`0a02<S8`50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool2000003L0S8b<00<0003o08b<S02<S8`0``2<S8`5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolj08b<S0030000o`2<S8`0S8b<
0<80S8b<1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo>`2<S8`00`000?l0
S8b<08b<S03108b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc/0S8b<
00<0003o08b<S02<S8`0`@2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ooll08b<S0030000o`2<S8`0S8b<0<00S8b<1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo?@2<S8`00`000?l0S8b<08b<S02o08b<S0D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooch0S8b<00<0003o08b<S02<S8`0U02<S8`[000000@0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooocl0S8b<00<0003o08b<S02<S8`0K@2<S8`V000002X0
WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo?`2<S8`00`000?l0S8b<
08b<S01F08b<S1L00000D02OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
oom008b<S0030000o`2<S8`0S8b<0400S8b<5@00001W09nOW`D0oooo0@0000010?ooo`005@3oool2
000000<0oooo@@2<S8`00`000?l0S8b<08b<S00_08b<S1000000O02OWil40?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooom208b<S0030000o`2<S8`0S8b<0280S8b<3000002<09nO
W`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oood<0S8b<00<0003o08b<S02<
S8`05P2<S8`;000009P0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
A02<S8`00`000?l0S8b<08b<S00808b<S0d00000X`2OWil50?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3ooom408b<S0040000o`2<S8`0S8b<08b<S0L00000/02OWil50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolm08b<S0P0000000<0003o000000000000]`2O
Wil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolf08b<S0L000002@2OWil0
0`000?l0WinO09nOW`2f09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
obh0S8b<2000000A09nOW`030000o`2OWil0WinO0;D0WinO1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo9P2<S8`8000001X0WinO00<0003o09nOW`2OWil0]02OWil50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ08b<S0D000008`2OWil00`000?l0WinO
09nOW`2c09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaT0S8b<2000
000X09nOW`030000o`2OWil0WinO0;<0WinO1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo502<S8`500000340WinO00<0003o09nOW`2OWil0/P2OWil50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool<08b<S0P00000=`2OWil00`000?l0WinO09nOW`2009nO
Wc800000103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1`2<S8`500000400
WinO00<0003o09nOW`2OWil0I`2OWilH00000340/k>c1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo0P2<S8`5000004H0WinO00<0003o09nOW`2OWil0E02OWilB000004T0/k>c
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0P00001;09nOW`030000o`2O
Wil0WinO04P0WinO3000001K0;>c/`D0oooo0@0000010?ooo`005@3oool2000000<0ooooCP2OWil0
0`000?l0WinO09nOW`0j09nOW`d00000I`2c/k<40?ooo`8000000@3oool001D0oooo00<000000?oo
o`3oool00P3ooom?09nOW`030000o`2OWil0WinO02h0WinO2`00001d0;>c/`D0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooe00WinO00<0003o09nOW`2OWil08`2OWil:000007l0
/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080ooooD@2OWil00`000?l0WinO
09nOW`0J09nOW`P00000R@2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
oomB09nOW`030000o`2OWil0WinO0180WinO1`00002A0;>c/`D0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?oooe80WinO00<0003o09nOW`2OWil02P2OWil8000009P0/k>c1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080ooooD`2OWil010000?l0WinO09nOW`2OWil8
00000:00/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080ooooDP2OWil20000
00030000o`00000000000:P0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
ooooC@2OWil5000000<0/k>c00<0003o0;>c/`2c/k<0Y`2c/k<50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooom509nOW`P000002@2c/k<00`000?l0/k>c0;>c/`2V0;>c/`D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oood00WinO1@00000B0;>c/`030000o`2c
/k<0/k>c0:D0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo>`2OWil5
000001L0/k>c00<0003o0;>c/`2c/k<0Y@2c/k<50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3ooolf09nOW`D000007@2c/k<00`000?l0/k>c0;>c/`220;>c/b<00000103oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo<@2OWil5000002<0/k>c00<0003o0;>c/`2c
/k<0JP2c/k<G00000280a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
;P2OWil3000002T0/k>c00<0003o0;>c/`2c/k<0F@2c/k<@000003T0a/K61@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo:@2OWil5000002d0/k>c00<0003o0;>c/`2c/k<0C02c
/k<<000004T0a/K61@3oool100000040oooo000E0?ooo`8000000`3ooolS09nOW`H00000<P2c/k<0
0`000?l0/k>c0;>c/`110;>c/`/00000E@36a/H40?ooo`8000000@3oool001D0oooo00<000000?oo
o`3oool00P3ooolQ09nOW`800000>@2c/k<00`000?l0/k>c0;>c/`0i0;>c/`L00000H036a/H50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolL09nOW`D00000?02c/k<00`000?l0
/k>c0;>c/`0`0;>c/`P00000I`36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolI09nOW`<00000@P2c/k<00`000?l0/k>c0;>c/`0W0;>c/`P00000K`36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolG09nOW`800000AP2c/k<00`000?l0/k>c0;>c
/`0N0;>c/`P00000M`36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolB
09nOW`D00000B@2c/k<00`000?l0/k>c0;>c/`0H0;>c/`D00000O`36a/H50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool?09nOW`<00000CP2c/k<00`000?l0/k>c0;>c/`0@0;>c
/`P00000Q036a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool<09nOW`<0
0000DP2c/k<00`000?l0/k>c0;>c/`0:0;>c/`D00000S036a/H50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool909nOW`<00000EP2c/k<00`000?l0/k>c0;>c/`040;>c/`D00000
T@36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool509nOW`@00000FP2c
/k<00`000?l0000000000003000009H0a/K61@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo0`2OWil2000005X0/k>c1@0000000`000?l0a/K60<K6aP2H0<K6aPD0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<00000E`2c/k<5000000H0a/K600<0003o0<K6
aP36a/H0U`36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooomG0;>c/`<0
00002`36a/H00`000?l0a/K60<K6aP2G0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooe80/k>c1@00000?0<K6aP030000o`36a/H0a/K609H0a/K61@3oool100000040oooo
00000`3oool000000000000300000080oooo0P0000050?ooo`<000000`3oool00`000000oooo0?oo
o`020?ooodd0/k>c1@00000E0<K6aP030000o`36a/H0a/K606h0a/K6:00000040?ooo`4000000@3o
ool000<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080ooooBP2c/k<3000001/0a/K600<0003o0<K6aP36a/H0GP36a/H?000002L0fMWI1@3oool1
00000040oooo00030?ooo`030000003oool0oooo00L0oooo1@0000030?ooo`8000000`3ooom80;>c
/`8000007`36a/H00`000?l0a/K60<K6aP1@0<K6aPd00000=P3IfMT40?ooo`8000000@3oool000<0
oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
0080oooo@P2c/k<600000240a/K600<0003o0<K6aP36a/H0B036a/H8000004<0fMWI1@3oool10000
0040oooo00030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`020?ooocl0/k>c0`00000X0<K6aP030000o`36a/H0a/K603h0a/K62@00001;0=WIf@D0
oooo0@0000010?ooo`000P3oool2000000/0oooo0P0000040?ooo`030000003oool0oooo0080oooo
>`2c/k<4000002`0a/K600<0003o0<K6aP36a/H0=P36a/H7000005@0fMWI1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo>02c/k<300000340a/K600<0003o0<K6aP36a/H0;P36
a/H7000005/0fMWI1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo=P2c/k<2
000003D0a/K600<0003o0<K6aP36a/H0:036a/H500000680fMWI1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo<`2c/k<3000003P0a/K600<0003o0<K6aP36a/H07`36a/H80000
06L0fMWI1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo<@2c/k<2000003/0
a/K600<0003o0<K6aP36a/H06P36a/H5000006l0fMWI1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo;P2c/k<3000003h0a/K600<0003o0<K6aP36a/H04`36a/H6000007@0fMWI
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo:`2c/k<300000480a/K600<0
003o0<K6aP36a/H04036a/H2000007X0fMWI1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo:02c/k<3000004H0a/K600<0003o0<K6aP36a/H02P36a/H5000007`0fMWI1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo9P2c/k<2000004X0a/K600<0003o0<K6
aP36a/H01036a/H500000840fMWI1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo8`2c/k<3000004d0a/K600<0003o0<K6aP36a/H00`0000260=WIf@D0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooob40/k>c0P00001>0<K6aP80000000<0003o000000000000
R@3IfMT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolN0;>c/`<00000C@36
a/H3000000<0fMWI00<0003o0=WIf@3IfMT0R03IfMT50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolK0;>c/`<00000B`36a/H5000000L0fMWI00<0003o0=WIf@3IfMT0Q`3IfMT5
0?ooo`4000000@3oool001D0oooo0P0000030?oooaT0/k>c0P00001<0<K6aP8000003@3IfMT00`00
0?l0fMWI0=WIf@260=WIf@@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0
/k>c0P00001;0<K6aP<00000403IfMT00`000?l0fMWI0=WIf@250=WIf@D0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?oooaD0/k>c0P00001:0<K6aP<00000503IfMT00`000?l0fMWI
0=WIf@1R0=WIfB<00000103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo4`2c
/k<2000004L0a/K61@00000G0=WIf@030000o`3IfMT0fMWI05D0fMWI3@00000R0>c/k0D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooa80/k>c00<000000<K6aP36a/H0A@36a/H2
000001d0fMWI00<0003o0=WIf@3IfMT0B`3IfMT9000002l0k>c/1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo3`2c/k<3000004D0a/K60`00000P0=WIf@030000o`3IfMT0fMWI
0440fMWI2@00000h0>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`d0
/k>c0P0000150<K6aP<00000903IfMT00`000?l0fMWI0=WIf@0k0=WIf@D00000@@3/k>`50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool<0;>c/`0300000036a/H0a/K604<0a/K6
0P00000X0=WIf@030000o`3IfMT0fMWI0380fMWI200000160>c/k0D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`X0/k>c0P0000130<K6aP<00000:P3IfMT00`000?l0fMWI0=WI
f@0]0=WIf@D00000CP3/k>`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool8
0;>c/`800000@`36a/H2000002h0fMWI00<0003o0=WIf@3IfMT0:03IfMT4000005<0k>c/1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo1`2c/k<00`000000a/K60<K6aP100<K6
aP<00000<@3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@H00000E`3/k>`50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool50;>c/`800000@@36a/H2000003D0fMWI00<0003o0=WIf@3I
fMT07@3IfMT3000005d0k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
0`2c/k<200000440a/K60P00000h0=WIf@030000o`3IfMT0fMWI01L0fMWI1@00001P0>c/k0D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030;>c/`00000000000440a/K60P00
000k0=WIf@030000o`3IfMT0fMWI0140fMWI1@00001U0>c/k0D0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`0300000036a/H0a/K603l0a/K60P00000m0=WIf@030000o`3IfMT0
fMWI00l0fMWI0P00001Z0>c/k0D0oooo0@0000010?ooo`005@3oool2000000<0oooo@036a/H20000
0400fMWI00<0003o0=WIf@3IfMT02`3IfMT3000006`0k>c/103oool200000040oooo000E0?ooo`03
0000003oool0oooo0080oooo?@36a/H3000004<0fMWI00<0003o0=WIf@3IfMT01@3IfMT5000006l0
k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo>`36a/H2000004L0fMWI
00@0003o0=WIf@3IfMT0fMWI0`00001d0>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooocX0a/K600<000000=WIf@3IfMT0B03IfMT00`000?l000000000001g0>c/k0D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooocP0a/K60P0000190=WIf@80000000<0
k>c/0000o`3/k>`0M`3/k>`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolf
0<K6aP800000B03IfMT3000000<0k>c/00<0003o0>c/k03/k>`0MP3/k>`50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooole0<K6aP030000003IfMT0fMWI04H0fMWI0P0000070>c/
k0030000o`3/k>`0k>c/07D0k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo=036a/H00`000000fMWI0=WIf@150=WIf@8000002P3/k>`00`000?l0k>c/0>c/k01d0>c/k0D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc40a/K60`0000150=WIf@<00000
3@3/k>`00`000?l0k>c/0>c/k01c0>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooobl0a/K60P0000150=WIf@<000004@3/k>`00`000?l0k>c/0>c/k01b0>c/k0D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooobh0a/K600<000000=WIf@3IfMT0@P3IfMT3
000001@0k>c/00<0003o0>c/k03/k>`0LP3/k>`50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool/0<K6aP800000@`3IfMT2000001P0k>c/00<0003o0>c/k03/k>`0L@3/k>`50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool[0<K6aP030000003IfMT0fMWI0440
fMWI0P00000K0>c/k0030000o`3/k>`0k>c/05/0k>c/5P0000040?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooolY0<K6aP800000@@3IfMT3000001h0k>c/00<0003o0>c/k03/k>`0
D03/k>`:000001X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobP0a/K600<0
00000=WIf@3IfMT0@03IfMT00`000000k>c/0>c/k00P0>c/k0030000o`3/k>`0k>c/04@0k>c/2`00
000T0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolV0<K6aP800000@@3IfMT2
000002@0k>c/00<0003o0>c/k03/k>`0?P3/k>`5000002l0oooo0@0000010?ooo`005@3oool20000
00<0oooo9@36a/H00`000000fMWI0=WIf@0o0=WIf@8000009P3/k>`00`000?l0k>c/0>c/k00i0>c/
k0D00000<`3oool200000040oooo000E0?ooo`030000003oool0oooo0080oooo9036a/H00`000000
fMWI0=WIf@0n0=WIf@800000:@3/k>`00`000?l0k>c/0>c/k00c0>c/k0D00000>@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo8`36a/H00`000000fMWI0=WIf@0n0=WIf@030000
003/k>`0k>c/02X0k>c/00<0003o0>c/k03/k>`0;@3/k>`5000003h0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooob40a/K60P00000o0=WIf@800000;P3/k>`00`000?l0k>c/0>c/
k00Y0>c/k0<00000@`3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo8036a/H0
0`000000fMWI0=WIf@0m0=WIf@800000<@3/k>`00`000?l0k>c/0>c/k00S0>c/k0D00000AP3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo7`36a/H00`000000fMWI0=WIf@0m0=WI
f@030000003/k>`0k>c/0380k>c/00<0003o0>c/k03/k>`07`3/k>`3000004/0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooal0a/K600<000000=WIf@3IfMT0>`3IfMT2000003D0
k>c/00<0003o0>c/k03/k>`07@3/k>`2000004h0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooad0a/K60P00000m0=WIf@030000003/k>`0k>c/03H0k>c/00<0003o0>c/k03/k>`0
6@3/k>`300000500oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa`0a/K600<0
00000=WIf@3IfMT0>`3IfMT2000003X0k>c/00<0003o0>c/k03/k>`04`3/k>`5000005<0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooa/0a/K600<000000=WIf@3IfMT0>`3IfMT0
0`000000k>c/0>c/k00k0>c/k0030000o`3/k>`0k>c/0100k>c/0P00001H0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolK0<K6aP030000003IfMT0fMWI03X0fMWI00<000000>c/
k03/k>`0?@3/k>`00`000?l0k>c/0>c/k00?0>c/k0030000003oool0oooo05L0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooaX0a/K600<000000=WIf@3IfMT0>@3IfMT200000400
k>c/00<0003o0>c/k03/k>`0303/k>`3000005X0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooaP0a/K60P00000k0=WIf@030000003/k>`0k>c/0440k>c/00<0003o0>c/k03/k>`0
203/k>`3000005d0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0a/K600<0
00000=WIf@3IfMT0>@3IfMT2000004D0k>c/00<0003o0>c/k03/k>`01@3/k>`200000600oooo0@00
00010?ooo`0000<0oooo0000000000000`0000020?ooo`8000000`3oool3000000D0oooo00<00000
0?ooo`3oool00P3ooolF0<K6aP030000003IfMT0fMWI03T0fMWI00<000000>c/k03/k>`0AP3/k>`0
0`000?l0k>c/0>c/k0020>c/k0800000HP3oool100000040oooo00030?ooo`030000003oool0oooo
00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?oooaH0a/K600<00000
0=WIf@3IfMT0>@3IfMT00`000000k>c/0>c/k0170>c/k0040000o`0000000000000006@0oooo0@00
00010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo0P00
00030?oooaD0a/K600<000000=WIf@3IfMT0>@3IfMT00`000000k>c/0>c/k0180>c/k00300000000
0?l0oooo06@0oooo0P0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`<000001@3oool0
0`000000oooo0?ooo`020?oooa@0a/K600<000000=WIf@3IfMT0>03IfMT2000004T0k>c/0P000000
0`3oool0003o0?ooo`1U0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo4`36a/H00`000000fMWI0=WIf@0h0=WI
f@030000003/k>`0k>c/04P0k>c/00<000000?ooo`3oool00P3oool00`000?l0oooo0?ooo`1S0?oo
o`4000000@3oool00080oooo0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`020?oooa<0
a/K600<000000=WIf@3IfMT0=`3IfMT00`000000k>c/0>c/k0180>c/k0030000003oool0oooo00@0
oooo00<0003o0?ooo`3oool0HP3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
4P36a/H00`000000fMWI0=WIf@0h0=WIf@030000003/k>`0k>c/04H0k>c/0P0000080?ooo`030000
o`3oool0oooo0640oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa40a/K600<0
00000=WIf@3IfMT0>03IfMT00`000000k>c/0>c/k0150>c/k08000002`3oool00`000?l0oooo0?oo
o`1P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolA0<K6aP030000003IfMT0
fMWI03L0fMWI00<000000>c/k03/k>`0A@3/k>`00`000000oooo0?ooo`0<0?ooo`030000o`3oool0
oooo05l0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa00a/K600<000000=WI
f@3IfMT0=`3IfMT00`000000k>c/0>c/k0150>c/k08000003P3oool00`000?l0oooo0?ooo`1O0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool?0<K6aP030000003IfMT0fMWI03L0
fMWI00<000000>c/k03/k>`0A03/k>`200000140oooo00<0003o0?ooo`3oool0GP3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo3`36a/H00`000000fMWI0=WIf@0g0=WIf@030000
003/k>`0k>c/04@0k>c/00<000000?ooo`3oool04@3oool00`000?l0oooo0?ooo`1M0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool>0<K6aP030000003IfMT0fMWI03L0fMWI00<0
00000>c/k03/k>`0A03/k>`00`000000oooo0?ooo`0C0?ooo`030000o`3oool0oooo05`0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h0a/K600<000000=WIf@3IfMT0=P3IfMT0
0`000000k>c/0>c/k0140>c/k0030000003oool0oooo01D0oooo00<0003o0?ooo`3oool0F`3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo3@36a/H00`000000fMWI0=WIf@0g0=WI
f@030000003/k>`0k>c/04<0k>c/00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`1K0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool=0<K6aP030000003IfMT0fMWI03H0
fMWI00<000000>c/k03/k>`0@`3/k>`00`000000oooo0?ooo`0H0?ooo`030000o`3oool0oooo05X0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo``0a/K600<000000=WIf@3IfMT0
=P3IfMT2000004@0k>c/00<000000?ooo`3oool06P3oool00`000?l0oooo0?ooo`1I0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool<0<K6aP030000003IfMT0fMWI03H0fMWI00<0
00000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0L0?ooo`030000o`3oool0oooo05P0oooo0@00
00010?ooo`005@3oool2000000<0oooo2`36a/H00`000000fMWI0=WIf@0f0=WIf@030000003/k>`0
k>c/04<0k>c/00<000000?ooo`3oool07@3oool00`000?l0oooo0?ooo`1F0?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool;0<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/
k03/k>`0@P3/k>`00`000000oooo0?ooo`0O0?ooo`030000o`3oool0oooo05H0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo`X0a/K600<000000=WIf@3IfMT0=P3IfMT00`000000
k>c/0>c/k0130>c/k0030000003oool0oooo01l0oooo00<0003o0?ooo`3oool0A@3oool6000000/0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0a/K600<000000=WIf@3IfMT0
=P3IfMT00`000000k>c/0>c/k0120>c/k0030000003oool0oooo0240oooo00<0003o0?ooo`3oool0
@`3oool8000000@0oooo0`00ool30?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool:0<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?oo
o`0R0?ooo`030000o`3oool0oooo0440oooo0`000003003oo`@0000000<0oooo003oo`00ool00P3o
0003003oo`40oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0a/K600<00000
0=WIf@3IfMT0=@3IfMT00`000000k>c/0>c/k0120>c/k0030000003oool0oooo02@0oooo00<0003o
0?ooo`3oool0?`3oool2000000L00?oo0P0000000`00ool0o`000?l000040?l000800?oo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0a/K600<000000=WIf@3IfMT0=@3IfMT00`00
0000k>c/0>c/k0120>c/k0030000003oool0oooo02D0oooo00<0003o0?ooo`3oool0?@3oool20000
00@00?oo0P3o0003003oo`0400000000ool0o`000?l000<00?l000@0o`00003oo`00ool000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool:0<K6aP030000003IfMT0fMWI03D0fMWI00<00000
0>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0V0?ooo`030000o`3oool0oooo03`0oooo0P000002
003oo`040?l00000o`000?l0003o0080o`000P00ool20?l000800?l000@0003o003o0000o`00o`00
0P00ool10?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0a/K600<000000=WIf@3IfMT0=P3I
fMT00`000000k>c/0>c/k0110>c/k0030000003oool0oooo02L0oooo00<0003o0?ooo`3oool0?03o
ool0100000000?oo003oo`00ool2003o0080003o00@00?l00?l00000ool00?oo1P000?l01000o`00
o`00003oo`00ool10?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0a/K600<000000=WIf@3I
fMT0=P3IfMT00`000000k>c/0>c/k0110>c/k0030000003oool0oooo02P0oooo00<0003o0?ooo`3o
ool0>`3oool01@0000000?oo003oo`3o00000?l000L0003o00<00?oo0?l00000o`000P000?l2003o
00<00?oo0@3oool001D0oooo00<000000?ooo`3oool00P3oool90<K6aP030000003IfMT0fMWI03H0
fMWI00<000000>c/k03/k>`0@@3/k>`00`000000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo03X0
oooo00@00000003oo`00ool0o`000P00o`000`000?l00?l0003o00020?l000800?oo00<0o`000000
o`00o`000P00o`00103o00000?oo003oo`0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`T0a/K600<000000=WIf@3IfMT0=P3IfMT00`000000k>c/0>c/k0110>c/k0030000003oool0oooo
02X0oooo00<0003o0?ooo`3oool0>@3oool2000000800?oo00@0o`00003o0000o`000?l00P3o0000
1@00ool00000003oo`000?l00?oo0080o`001000ool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo2@36a/H00`000000fMWI0=WIf@0f0=WIf@030000003/k>`0k>c/0440k>c/00<00000
0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0i0?ooo`0300000000ool00?oo00H0o`0000<00?oo
000000000?l01`00ool10?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6
aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0/0?oo
o`030000o`3oool0oooo03T0oooo00@00000003oo`00ool00?oo0P3o0002003oo`03000000000?l0
oooo0080oooo0`00ool30?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6
aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0/0?oo
o`030000o`3oool0oooo03X0oooo0P000003003oo`80000000<0003o0?ooo`3oool0203oool10000
0040oooo000E0?ooo`8000000`3oool80<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/
k>`0@P3/k>`00`000000oooo0?ooo`0]0?ooo`030000o`3oool0oooo03X0oooo1@0000000`000?l0
oooo0?ooo`080?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6aP030000
003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0]0?ooo`030000
o`3oool0oooo03d0oooo00<0003o0?ooo`3oool02P3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo2036a/H00`000000fMWI0=WIf@0g0=WIf@030000003/k>`0k>c/0480k>c/00<0
00000?ooo`3oool0;P3oool00`000?l0oooo0?ooo`0k0?ooo`030000o`3oool0oooo00/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P0a/K600<000000=WIf@3IfMT0=`3IfMT0
0`000000k>c/0>c/k0130>c/k0030000003oool0oooo02h0oooo00<0003o0?ooo`3oool0>@3oool0
0`000?l0oooo0?ooo`0<0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6
aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0@`3/k>`00`000000oooo0?ooo`0^0?oo
o`030000o`3oool0oooo03L0oooo0P000?l?0?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool80<K6aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0@`3/k>`00`000000
oooo0?ooo`0_0?ooo`030000o`3oool0oooo03D0oooo00<0003o0?ooo`3oool03`3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo2@36a/H00`000000fMWI0=WIf@0g0=WIf@030000
003/k>`0k>c/04<0k>c/00<000000?ooo`3oool0;`3oool00`000?l0oooo0?ooo`0c0?ooo`030000
o`3oool0oooo0100oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0a/K600<0
00000=WIf@3IfMT0=`3IfMT00`000000k>c/0>c/k0140>c/k0030000003oool0oooo02l0oooo00<0
003o0?ooo`3oool0<@3oool00`000?l0oooo0?ooo`0A0?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool90<K6aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0A03/k>`0
0`000000oooo0?ooo`0`0?ooo`030000o`3oool0oooo02l0oooo00<0003o0?ooo`3oool04P3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo2@36a/H00`000000fMWI0=WIf@0g0=WI
f@030000003/k>`0k>c/04D0k>c/00<000000?ooo`3oool0<03oool00`000?l0oooo0?ooo`0]0?oo
o`030000o`3oool0oooo01<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0
a/K600<000000=WIf@3IfMT0>03IfMT00`000000k>c/0>c/k0150>c/k0030000003oool0oooo02l0
oooo00<0003o0?ooo`3oool0;03oool00`000?l0oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool:0<K6aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0
A@3/k>`00`000000oooo0?ooo`0`0?ooo`030000o`3oool0oooo02X0oooo00<0003o0?ooo`3oool0
5@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2P36a/H00`000000fMWI0=WI
f@0h0=WIf@030000003/k>`0k>c/04D0k>c/0P00000a0?ooo`030000o`3oool0oooo02P0oooo00<0
003o0?ooo`3oool05P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2P36a/H0
0`000000fMWI0=WIf@0h0=WIf@030000003/k>`0k>c/04L0k>c/00<000000?ooo`3oool0;`3oool0
0`000?l0oooo0?ooo`0V0?ooo`030000o`3oool0oooo01L0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`/0a/K600<000000=WIf@3IfMT0>03IfMT00`000000k>c/0>c/k0170>c/
k0030000003oool0oooo02l0oooo00<0003o0?ooo`3oool0903oool00`000?l0oooo0?ooo`0H0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool;0<K6aP030000003IfMT0fMWI03T0
fMWI00<000000>c/k03/k>`0A`3/k>`200000300oooo00<0003o0?ooo`3oool08P3oool00`000?l0
oooo0?ooo`0I0?ooo`4000000@3oool001D0oooo0P0000030?ooo``0a/K600<000000=WIf@3IfMT0
>03IfMT00`000000k>c/0>c/k0190>c/k0030000003oool0oooo02d0oooo00<0003o0?ooo`3oool0
8@3oool00`000?l0oooo0?ooo`0I0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool<0<K6aP030000003IfMT0fMWI03T0fMWI00<000000>c/k03/k>`0B03/k>`2000002l0oooo00<0
003o0?ooo`3oool07`3oool00`000?l0oooo0?ooo`0K0?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool<0<K6aP030000003IfMT0fMWI03X0fMWI00<000000>c/k03/k>`0B@3/k>`2
000002h0oooo00<0003o0?ooo`3oool07@3oool00`000?l0oooo0?ooo`0L0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool=0<K6aP030000003IfMT0fMWI03X0fMWI00<000000>c/
k03/k>`0BP3/k>`2000002d0oooo00<0003o0?ooo`3oool06`3oool00`000?l0oooo0?ooo`0M0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool=0<K6aP030000003IfMT0fMWI03X0
fMWI00<000000>c/k03/k>`0B`3/k>`2000002d0oooo00<0003o0?ooo`3oool06@3oool00`000?l0
oooo0?ooo`0N0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool>0<K6aP030000
003IfMT0fMWI03X0fMWI00<000000>c/k03/k>`0C03/k>`2000002/0oooo00<0003o0?ooo`3oool0
603oool00`000?l0oooo0?ooo`0O0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool>0<K6aP030000003IfMT0fMWI03/0fMWI00<000000>c/k03/k>`0C@3/k>`3000002T0oooo00<0
003o0?ooo`3oool05P3oool00`000?l0oooo0?ooo`0P0?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool?0<K6aP030000003IfMT0fMWI03/0fMWI00<000000>c/k03/k>`0C`3/k>`2
000002P0oooo00<0003o0?ooo`3oool0503oool00`000?l0oooo0?ooo`0Q0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool?0<K6aP030000003IfMT0fMWI03`0fMWI00<000000>c/
k03/k>`0D03/k>`00`000000oooo0?ooo`0V0?ooo`030000o`3oool0oooo0180oooo00<0003o0?oo
o`3oool08P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo4036a/H00`000000
fMWI0=WIf@0l0=WIf@800000D@3/k>`5000002@0oooo00<0003o0?ooo`3oool03`3oool20000obD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa40a/K600<000000=WIf@3IfMT0
?@3IfMT00`000000k>c/0>c/k01C0>c/k08000008`3oool00`000?l0oooo0?ooo`0=0?ooo`030000
o`3oool0oooo02D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa80a/K600<0
00000=WIf@3IfMT0?@3IfMT00`000000k>c/0>c/k01D0>c/k0<00000803oool00`000?l0oooo0?oo
o`0<0?ooo`030000o`3oool0oooo02H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?oooa<0a/K600<000000=WIf@3IfMT0?@3IfMT2000005L0k>c/0P00000O0?ooo`030000o`3oool0
oooo00X0oooo00<0003o0?ooo`3oool09`3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo4`36a/H00`000000fMWI0=WIf@0o0=WIf@030000003/k>`0k>c/05H0k>c/0`00000M0?oo
o`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0:03oool100000040oooo00000`3oool0
00000000000300000080oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`020?oooa@0
a/K60P0000100=WIf@030000003/k>`0k>c/05P0k>c/1@00000I0?ooo`030000o`3oool0oooo00<0
0?oo0`3oool00`000?l0oooo0?ooo`0Y0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0
1`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo5P36a/H00`000000
fMWI0=WIf@0n0=WIf@800000G@3/k>`5000001D0oooo00<0003o003oo`00ool01000ool00`000?l0
oooo0?ooo`0Z0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool01`3oool010000000oooo
0?ooo`0000040?ooo`8000000`3ooolG0<K6aP030000003IfMT0fMWI03l0fMWI0P00001P0>c/k0D0
00003`3oool2003oo`030000o`3o0000o`0000800?oo00<0003o003oo`3oool0:P3oool200000040
oooo00030?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000003oool0oooo0080oooo
6036a/H00`000000fMWI0=WIf@0o0=WIf@800000I03/k>`6000000T0oooo00<00?oo0?l000000?l0
0`00o`000`000?l00?oo003oo`0/0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool01`3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo6@36a/H00`000000fMWI
0=WIf@100=WIf@800000J03/k>`7000000050?ooo`00ool00?oo0?l00000o`000`000?l01000o`00
0?oo003oo`00ool[0?ooo`4000000@3oool00080oooo0P00000:0?ooo`8000001@3oool00`000000
oooo0?ooo`020?oooaX0a/K600<000000=WIf@3IfMT0@@3IfMT00`000000k>c/0>c/k01/0>c/k005
00000000ool0o`000?l00000o`000`000?l01000o`00o`00003oo`00ool[0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0d03oool00`00ool0o`000?l00002003o00040000o`00o`000?l0
0?l000800?oo:`3oool100000040oooo000E0?ooo`030000003oool0oooo0=40oooo00<00?oo0?l0
003o00000`00o`000`3o00000?oo003oo`0/0?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3o
ool0?`3oool00`000000oooo0?ooo`080?ooo`03003oo`3o0000o`0000@0o`000P00ool/0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`090?ooo`800?oo
0P3o0003003oo`L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo0@0000010?ooo`005@3ooooG000000<00?oo<00000010?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {0, 0, 0, 0}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-2.`\), {x \[Rule] 1.3763849724065496`, 
            y \[Rule] 1.6786760819521203`}}\), 
        ",", \({"Steps" \[Rule] 5, "Function" \[Rule] 6, 
          "Gradient" \[Rule] 6, "Hessian" \[Rule] 6}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell["\<\
In this example, it is clear that the extra information, which \
Newton\[CloseCurlyQuote]s method has about the curvature of the function \
makes a big difference in how many steps it takes to get to the minimum. Even \
though Newton\[CloseCurlyQuote]s method takes fewer steps, it may take more \
total execution time since the symbolic Hessian has to be computed once and \
then evaluated numerically at each step. \
\>", "Text"],

Cell[TextData[{
  "Usually there are trade-offs between the rate of convergence or total \
number of steps taken and cost per step. Depending on the size of the \
problems you want to solve, you may want to pick a particular method to best \
match that trade-off for a particular problem. This documentation is intended \
to help you understand those choices as well as some ways to get the best \
results from the functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". For the most part, examples will be used to illustrate the ideas, but a \
limited exposition on the mathematical theory behind the methods will be \
given so that you can better understand how they work."
}], "Text"],

Cell[TextData[{
  "For the most part, local minimization methods for a function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " are based on a quadratic model"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(q\_k\)(p) = 
      f(x\_k)\  + \ \[Del]\(f(x\_k)\)\^T\ p + 
        1\/2\ \(p\^T\) B\_k\ \(\(p\)\(.\)\)\)], "NumberedEquation",
  CellTags->"QuadraticModel"],

Cell[TextData[{
  "The subscript ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " refers to the ",
  Cell[BoxData[
      \(TraditionalForm\`k\^th\)]],
  " iterative step. In Newton\[CloseCurlyQuote]s method, the model is based \
on the exact Hessian matrix, ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " = ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Del]\^2 f\) \((x\_k)\)\(\ \)\)\)]],
  ", but other methods use approximations to ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Del]\^2 f \((x\_k)\)\)\(,\)\(\ \)\)\)]],
  "which are typically less expensive to compute. A trial step ",
  Cell[BoxData[
      \(TraditionalForm\`s\_k\)]],
  "is typically computed to be the minimizer of the model, which satisfies \
the system of linear equations."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(B\_k\) 
        s\_k\ \  = \ \(-\ \[Del]\(f(x\_k)\)\)\)], "DisplayMath"],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is sufficiently smooth and ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  " is sufficiently close to a local minimum, then with ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  "= ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\^2 f \((x\_k)\)\)]],
  ", the sequence of steps ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(k + 1\)\  = \ s\_k\  + \ x\_k\)]],
  " is guaranteed to converge to the local minimum. However, in a typical \
search, the starting value is rarely close enough to give the desired \
convergence. Furthermore, ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " is often an approximation to the actual Hessian and, at the beginning of \
a search, the approximation is frequently quite inaccurate. Thus, it is \
necessary to provide additional control to the step sequence to improve the \
chance and rate of convergence. There are two frequently used types of \
methods for controlling the steps referred to as line search and trust region \
methods. "
}], "Text"],

Cell[TextData[{
  " In a ",
  ButtonBox["line search",
    ButtonData:>"LineSearch",
    ButtonStyle->"Hyperlink"],
  " method, for each trial step ",
  Cell[BoxData[
      \(TraditionalForm\`s\_k\)]],
  " found, a one-dimensional search is done along the direction of ",
  Cell[BoxData[
      \(TraditionalForm\`s\_k\)]],
  " so that ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(k + 1\)\  = \ x\_k\  + \ \[Alpha]\_k\ s\_k\)]],
  ". You could choose ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\_k\)]],
  " so that it minimizes ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_\(k + 1\))\)]],
  " in this direction, but this is excessive, and with conditions that \
require that ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_\(k + 1\))\)]],
  "decreases sufficiently in value and slope, convergence for reasonable \
approximations ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " can be proven. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses a formulation of these conditions called the ",
  ButtonBox["Wolfe",
    ButtonData:>"Wolfe",
    ButtonStyle->"Hyperlink"],
  " conditions."
}], "Text"],

Cell[TextData[{
  "In a ",
  ButtonBox["trust region",
    ButtonData:>"TrustRegion",
    ButtonStyle->"Hyperlink"],
  " method, a radius ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_k\)]],
  " within which the quadratic model ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(q\_k\)(p)\)\(\ \)\)\)]],
  " in equation (",
  ButtonBox["1",
    ButtonData:>"QuadraticModel",
    ButtonStyle->"Hyperlink"],
  ") is \[OpenCurlyDoubleQuote]trusted\[CloseCurlyDoubleQuote] to be \
reasonably representative of the function. Then, instead of solving for the \
unconstrained minimum of (",
  ButtonBox["1",
    ButtonData:>"QuadraticModel",
    ButtonStyle->"Hyperlink"],
  "), the trust region method tries to find the constrained minimum of (",
  ButtonBox["1",
    ButtonData:>"QuadraticModel",
    ButtonStyle->"Hyperlink"],
  ") with ||p|| \[LessEqual] ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_k\)]],
  ". If the ",
  Cell[BoxData[
      \(TraditionalForm\`x\_k\)]],
  " is sufficiently close to a minimum and the model is good, then often the \
minimum lies within the circle and convergence is quite rapid. However, near \
the start of a search, the minimum will lie on the boundary and there are a \
number of techniques to find an approximate solution to the constrained \
problem. Once an approximate solution is found, the actual reduction of the \
function value is compared to the predicted reduction in the function value \
and, depending on how close the actual was to the predicted, an adjustment is \
made for ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalDelta]\_\(k + 1\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "For symbolic minimization of a univariate smooth function, all that is \
necessary is to find a point at which the derivative is zero and where the \
second derivative is positive. In multiple dimensions, this means that the \
gradient vanishes and the Hessian need be positive definite (if the Hessian \
is positive semidefinite, the point is a minimizer, but is not necessarily a \
strict one). As a numerical algorithm converges, it is necessary to keep \
track of the convergence and make some judgement as to when a minimum has \
been approached closely enough. This is based on the sequence of steps taken \
and the values of the function, its gradient, and possibly its Hessian at \
these points. Usually, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Find...", "MR"],
  " functions will issue a message if they cannot be fairly certain that this \
judgement is correct. However, keep in mind that discontinuous functions or \
functions with rapid changes of scale can fool any numerical algorithm."
}], "Text"],

Cell["\<\
When solving nonlinear equations, many of the same issues arise as \
for finding a local minimum. In fact, by considering a so-called merit \
function, which is zero at the root of the equations, it is possible to use \
many of the same techniques as for minimization, but with advantage of the \
knowledge that the minimum value of the function is 0. It is not always \
advantageous to use this approach, and there are some methods specialized for \
nonlinear equations. \
\>", "Text"],

Cell[TextData[{
  "In the majority of this document, examples shown will be from one- and \
two-dimensions for the most part. This is by no means because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is restricted to computing with such small examples, but because it is \
much easier to visually illustrate the main principles behind the theory and \
methods with such examples."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Methods for Local Minimization", "Section",
  CellTags->{"t:4", "c:4"}],

Cell[TextData[{
  "The essence of most methods, as described above, is in the local model \
employed in equation ",
  "(",
  ButtonBox["1",
    ButtonData:>"QuadraticModel",
    ButtonStyle->"Hyperlink"],
  ")",
  " that is used to determine the next step. The ",
  StyleBox["FindMinimum", "MR"],
  " function in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has five essentially different ways of choosing this model, controlled by \
the method option. These methods are similarly used by ",
  StyleBox["FindMaximum", "MR"],
  " and ",
  StyleBox["FindFit", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["\"Newton\"", "MR"]]], 
            Cell["\<\
This uses the exact Hessian or a finite difference \
approximation if the symbolic derivative cannot be computed.\
\>", "Text"]},
          {Cell[TextData[StyleBox["\"QuasiNewton\"", "MR"]]], 
            Cell["\<\
This uses the quasi-Newton BFGS approximation to the \
Hessian built up by updates based on past steps.\
\>", "Text"]},
          {Cell[TextData[StyleBox["\"LevenbergMarquardt\"", "MR"]]], Cell[
            TextData[{
              
              "This is a Gauss-Newton method for least squares problems. The \
Hessian is approximated by ",
              Cell[BoxData[
                  \(TraditionalForm\`\(\(\(J\^T\) J\)\(,\)\)\)]],
              " where ",
              Cell[BoxData[
                  \(TraditionalForm\`J\)]],
              " is the Jacobian of the residual function."
            }], "Text"]},
          {Cell[TextData[StyleBox["\"ConjugateGradient\"", "MR"]]], 
            Cell["\<\
This is a nonlinear version of the conjugate gradient \
method for solving linear systems. A model Hessian is never formed \
explicitly.\
\>", "Text"]},
          {Cell[TextData[StyleBox["\"PrincipalAxis\"", "MR"]]], 
            Cell["\<\
This works without using any derivatives, not even the \
gradient, by keeping values from past steps. It requires two starting \
conditions in each variable.\
\>"]}
          }], TextForm]], "DefinitionBox"],

Cell[TextData[{
  "Basic method choices for ",
  StyleBox["FindMinimum", "MR"],
  "."
}], "Caption"],

Cell[TextData[{
  "With ",
  StyleBox["Method", "MR"],
  "\[Rule]",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the quasi-Newton method unless the problem is structurally a sum of \
squares, in which case the Levenberg-Marquardt variant of the Gauss-Newton \
method is used. When given two starting conditions in each variable, the \
principal axis method is used."
}], "Text"],

Cell[CellGroupData[{

Cell["Newton\[CloseCurlyQuote]s Method", "Subsection",
  CellTags->{"FMNewton", "t:5", "c:5"}],

Cell[TextData[{
  "One significant advantage ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides is that it can symbolically compute derivatives. This means that \
when you specify ",
  StyleBox["Method\[Rule]\"Newton\"", "MR"],
  " and the function is explicitly differentiable, the symbolic derivative \
will be computed automatically. On the other hand, if the function is not in \
a form that can be explicitly differentiated, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will use finite difference approximations to compute the Hessian, using \
structural information to minimize the number of evaluations required, or you \
can specify a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression, which will give the Hessian with numerical values of the \
variables. "
}], "Text"],

Cell[TextData[{
  "In this example, ",
  StyleBox["FindMinimum", "MR"],
  " computes the Hessian symbolically and substitutes numerical values for ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " when needed."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[
      Cos[x^2\  - \ 3\ y]\  + \ Sin[x^2\  + \ y^2], {{x, 1}, {y, 1}}, \ 
      Method -> "\<Newton\>"]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \({\(-2.`\), {x \[Rule] 1.3763849724065496`, 
        y \[Rule] 1.6786760819521203`}}\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell["\<\
This defines a function that is only intended to evaluate for \
numerical values of the variables.\
\>", "MathCaption"],

Cell[BoxData[
    \(f[x_?NumberQ, \ y_?NumberQ]\  := \ 
      Cos[x^2\  - \ 3\ y]\  + \ Sin[x^2\  + \ y^2]\)], "Input",
  CellLabel->"In[2]:="],

Cell["\<\
The derivative of this function cannot be found symbolically since \
the function has been defined only to evaluate with numerical values of the \
variables. \
\>", "Text"],

Cell[TextData[{
  "This shows the steps taken by ",
  StyleBox["FindMinimum", "MR"],
  " when it has to use finite differences to compute the gradient and \
Hessian."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[f[x, y], {{x, 1}, {y, 1}}, \ 
      Method -> "\<Newton\>"]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    RowBox[{\(FindMinimum::"lstol"\), \(\(:\)\(\ \)\), "\<\"The line search \
decreased the step size to within tolerance specified by AccuracyGoal and \
PrecisionGoal but was unable to find a sufficient decrease in the function.  \
You may need more than \\!\\(MachinePrecision\\) digits of working precision \
to meet these tolerances. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"FindMinimum::lstol\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[3]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.43606 2.45529 -1.16928 1.18852 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.26476 -0.0125 -9 -9 ]
[.26476 -0.0125 9 0 ]
[.51029 -0.0125 -9 -9 ]
[.51029 -0.0125 9 0 ]
[.75582 -0.0125 -9 -9 ]
[.75582 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25693 -18 -4.5 ]
[-0.0125 .25693 0 4.5 ]
[-0.0125 .49464 -18 -4.5 ]
[-0.0125 .49464 0 4.5 ]
[-0.0125 .73234 -18 -4.5 ]
[-0.0125 .73234 0 4.5 ]
[-0.0125 .97004 -18 -4.5 ]
[-0.0125 .97004 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(1)] .01923 -0.0125 0 1 Mshowa
.26476 0 m
.26476 .00625 L
s
[(1.1)] .26476 -0.0125 0 1 Mshowa
.51029 0 m
.51029 .00625 L
s
[(1.2)] .51029 -0.0125 0 1 Mshowa
.75582 0 m
.75582 .00625 L
s
[(1.3)] .75582 -0.0125 0 1 Mshowa
.125 Mabswid
.06834 0 m
.06834 .00375 L
s
.11744 0 m
.11744 .00375 L
s
.16655 0 m
.16655 .00375 L
s
.21565 0 m
.21565 .00375 L
s
.31387 0 m
.31387 .00375 L
s
.36297 0 m
.36297 .00375 L
s
.41208 0 m
.41208 .00375 L
s
.46118 0 m
.46118 .00375 L
s
.55939 0 m
.55939 .00375 L
s
.6085 0 m
.6085 .00375 L
s
.65761 0 m
.65761 .00375 L
s
.70671 0 m
.70671 .00375 L
s
.80492 0 m
.80492 .00375 L
s
.85403 0 m
.85403 .00375 L
s
.90314 0 m
.90314 .00375 L
s
.95224 0 m
.95224 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(1)] -0.0125 .01923 1 0 Mshowa
0 .25693 m
.00625 .25693 L
s
[(1.2)] -0.0125 .25693 1 0 Mshowa
0 .49464 m
.00625 .49464 L
s
[(1.4)] -0.0125 .49464 1 0 Mshowa
0 .73234 m
.00625 .73234 L
s
[(1.6)] -0.0125 .73234 1 0 Mshowa
0 .97004 m
.00625 .97004 L
s
[(1.8)] -0.0125 .97004 1 0 Mshowa
.125 Mabswid
0 .07866 m
.00375 .07866 L
s
0 .13808 m
.00375 .13808 L
s
0 .19751 m
.00375 .19751 L
s
0 .31636 m
.00375 .31636 L
s
0 .37579 m
.00375 .37579 L
s
0 .43521 m
.00375 .43521 L
s
0 .55406 m
.00375 .55406 L
s
0 .61349 m
.00375 .61349 L
s
0 .67291 m
.00375 .67291 L
s
0 .79177 m
.00375 .79177 L
s
0 .85119 m
.00375 .85119 L
s
0 .91062 m
.00375 .91062 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.26476 .99375 m
.26476 1 L
s
.51029 .99375 m
.51029 1 L
s
.75582 .99375 m
.75582 1 L
s
.125 Mabswid
.06834 .99625 m
.06834 1 L
s
.11744 .99625 m
.11744 1 L
s
.16655 .99625 m
.16655 1 L
s
.21565 .99625 m
.21565 1 L
s
.31387 .99625 m
.31387 1 L
s
.36297 .99625 m
.36297 1 L
s
.41208 .99625 m
.41208 1 L
s
.46118 .99625 m
.46118 1 L
s
.55939 .99625 m
.55939 1 L
s
.6085 .99625 m
.6085 1 L
s
.65761 .99625 m
.65761 1 L
s
.70671 .99625 m
.70671 1 L
s
.80492 .99625 m
.80492 1 L
s
.85403 .99625 m
.85403 1 L
s
.90314 .99625 m
.90314 1 L
s
.95224 .99625 m
.95224 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25693 m
1 .25693 L
s
.99375 .49464 m
1 .49464 L
s
.99375 .73234 m
1 .73234 L
s
.99375 .97004 m
1 .97004 L
s
.125 Mabswid
.99625 .07866 m
1 .07866 L
s
.99625 .13808 m
1 .13808 L
s
.99625 .19751 m
1 .19751 L
s
.99625 .31636 m
1 .31636 L
s
.99625 .37579 m
1 .37579 L
s
.99625 .43521 m
1 .43521 L
s
.99625 .55406 m
1 .55406 L
s
.99625 .61349 m
1 .61349 L
s
.99625 .67291 m
1 .67291 L
s
.99625 .79177 m
1 .79177 L
s
.99625 .85119 m
1 .85119 L
s
.99625 .91062 m
1 .91062 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.325 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 g
.01923 .10017 m
.02894 .10087 L
.03866 .10155 L
.04837 .10222 L
.05808 .10287 L
.06779 .10352 L
.07751 .10415 L
.08722 .10476 L
.09693 .10537 L
.10664 .10597 L
.11636 .10655 L
.11791 .10664 L
.12607 .10712 L
.13578 .10769 L
.14549 .10824 L
.15521 .10878 L
.16492 .10931 L
.17463 .10983 L
.18434 .11034 L
.19406 .11083 L
.20377 .11132 L
.21348 .1118 L
.22319 .11227 L
.23291 .11274 L
.24262 .11319 L
.25233 .11363 L
.26204 .11407 L
.27176 .11449 L
.28147 .11491 L
.29118 .11532 L
.30089 .11572 L
.31061 .11611 L
.31688 .11636 L
.32032 .11649 L
.33003 .11687 L
.33974 .11723 L
.34946 .11759 L
.35917 .11794 L
.36888 .11829 L
.37859 .11863 L
.38831 .11895 L
.39802 .11928 L
.40773 .11959 L
.41744 .1199 L
.42716 .1202 L
.43687 .12049 L
.44658 .12078 L
.45629 .12106 L
.46601 .12133 L
.47572 .12159 L
.48543 .12185 L
.49514 .1221 L
.50486 .12235 L
.51457 .12259 L
.52428 .12282 L
.53399 .12305 L
.54371 .12327 L
.55342 .12348 L
.56313 .12369 L
.57284 .12389 L
.58256 .12408 L
.59227 .12427 L
.60198 .12445 L
.61169 .12463 L
.62141 .12479 L
.63112 .12496 L
.64083 .12511 L
.65054 .12527 L
.66026 .12541 L
.66997 .12555 L
.67968 .12568 L
.68939 .12581 L
.69911 .12593 L
.70882 .12604 L
.71094 .12607 L
.71853 .12615 L
.72824 .12626 L
.73796 .12635 L
.74767 .12644 L
.75738 .12653 L
.76709 .1266 L
.77681 .12668 L
.78652 .12674 L
.79623 .1268 L
.80594 .12686 L
.81566 .1269 L
.82537 .12694 L
.83508 .12698 L
.84479 .12701 L
.85451 .12703 L
.86422 .12704 L
.87393 .12705 L
.88364 .12706 L
.89336 .12705 L
.90307 .12704 L
.91278 .12702 L
.92249 .127 L
.93221 .12697 L
.94192 .12693 L
.95163 .12688 L
.96134 .12683 L
.97106 .12677 L
.98077 .1267 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .10017 m
.02894 .10087 L
.03866 .10155 L
.04837 .10222 L
.05808 .10287 L
.06779 .10352 L
.07751 .10415 L
.08722 .10476 L
.09693 .10537 L
.10664 .10597 L
.11636 .10655 L
.11791 .10664 L
.12607 .10712 L
.13578 .10769 L
.14549 .10824 L
.15521 .10878 L
.16492 .10931 L
.17463 .10983 L
.18434 .11034 L
.19406 .11083 L
.20377 .11132 L
.21348 .1118 L
.22319 .11227 L
.23291 .11274 L
.24262 .11319 L
.25233 .11363 L
.26204 .11407 L
.27176 .11449 L
.28147 .11491 L
.29118 .11532 L
.30089 .11572 L
.31061 .11611 L
.31688 .11636 L
.32032 .11649 L
.33003 .11687 L
.33974 .11723 L
.34946 .11759 L
.35917 .11794 L
.36888 .11829 L
.37859 .11863 L
.38831 .11895 L
.39802 .11928 L
.40773 .11959 L
.41744 .1199 L
.42716 .1202 L
.43687 .12049 L
.44658 .12078 L
.45629 .12106 L
.46601 .12133 L
.47572 .12159 L
Mistroke
.48543 .12185 L
.49514 .1221 L
.50486 .12235 L
.51457 .12259 L
.52428 .12282 L
.53399 .12305 L
.54371 .12327 L
.55342 .12348 L
.56313 .12369 L
.57284 .12389 L
.58256 .12408 L
.59227 .12427 L
.60198 .12445 L
.61169 .12463 L
.62141 .12479 L
.63112 .12496 L
.64083 .12511 L
.65054 .12527 L
.66026 .12541 L
.66997 .12555 L
.67968 .12568 L
.68939 .12581 L
.69911 .12593 L
.70882 .12604 L
.71094 .12607 L
.71853 .12615 L
.72824 .12626 L
.73796 .12635 L
.74767 .12644 L
.75738 .12653 L
.76709 .1266 L
.77681 .12668 L
.78652 .12674 L
.79623 .1268 L
.80594 .12686 L
.81566 .1269 L
.82537 .12694 L
.83508 .12698 L
.84479 .12701 L
.85451 .12703 L
.86422 .12704 L
.87393 .12705 L
.88364 .12706 L
.89336 .12705 L
.90307 .12704 L
.91278 .12702 L
.92249 .127 L
.93221 .12697 L
.94192 .12693 L
.95163 .12688 L
Mistroke
.96134 .12683 L
.97106 .12677 L
.98077 .1267 L
Mfstroke
.475 g
.01923 .18657 m
.02894 .18655 L
.03866 .18653 L
.04837 .18651 L
.05808 .18649 L
.06779 .18647 L
.07751 .18645 L
.08722 .18643 L
.09693 .18641 L
.10664 .18639 L
.11636 .18637 L
.12607 .18635 L
.13578 .18633 L
.14549 .18631 L
.15521 .1863 L
.16492 .18628 L
.17463 .18626 L
.18434 .18625 L
.19406 .18623 L
.20377 .18621 L
.21348 .1862 L
.22319 .18618 L
.23291 .18617 L
.24262 .18615 L
.25233 .18614 L
.26204 .18613 L
.27176 .18611 L
.28147 .1861 L
.29118 .18609 L
.30089 .18607 L
.31061 .18606 L
.32032 .18605 L
.33003 .18604 L
.33974 .18602 L
.34946 .18601 L
.35917 .186 L
.36888 .18599 L
.37859 .18598 L
.38831 .18597 L
.39802 .18596 L
.40773 .18595 L
.41744 .18594 L
.42716 .18593 L
.43687 .18592 L
.44658 .18591 L
.45629 .1859 L
.46601 .18589 L
.47572 .18589 L
.48543 .18588 L
.49514 .18587 L
.50486 .18586 L
.51457 .18585 L
.52428 .18585 L
.53399 .18584 L
.54371 .18583 L
.55342 .18583 L
.56313 .18582 L
.57284 .18581 L
.58256 .18581 L
.59227 .1858 L
.60198 .1858 L
.61169 .18579 L
.62141 .18578 L
.63112 .18578 L
.64083 .18577 L
.65054 .18577 L
.66026 .18576 L
.66997 .18576 L
.67968 .18576 L
.68939 .18575 L
.69911 .18575 L
.70882 .18574 L
.71853 .18574 L
.72824 .18574 L
.73796 .18573 L
.74767 .18573 L
.75738 .18573 L
.76709 .18573 L
.77681 .18572 L
.78652 .18572 L
.79623 .18572 L
.80594 .18572 L
.81566 .18571 L
.82537 .18571 L
.83508 .18571 L
.84479 .18571 L
.85451 .18571 L
.86422 .18571 L
.87393 .18571 L
.88364 .18571 L
.89336 .18571 L
.90307 .18571 L
.91278 .18571 L
.92249 .18571 L
.93221 .18571 L
.94192 .18571 L
.95163 .18571 L
.96134 .18571 L
.97106 .18571 L
.98077 .18571 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .18657 m
.02894 .18655 L
.03866 .18653 L
.04837 .18651 L
.05808 .18649 L
.06779 .18647 L
.07751 .18645 L
.08722 .18643 L
.09693 .18641 L
.10664 .18639 L
.11636 .18637 L
.12607 .18635 L
.13578 .18633 L
.14549 .18631 L
.15521 .1863 L
.16492 .18628 L
.17463 .18626 L
.18434 .18625 L
.19406 .18623 L
.20377 .18621 L
.21348 .1862 L
.22319 .18618 L
.23291 .18617 L
.24262 .18615 L
.25233 .18614 L
.26204 .18613 L
.27176 .18611 L
.28147 .1861 L
.29118 .18609 L
.30089 .18607 L
.31061 .18606 L
.32032 .18605 L
.33003 .18604 L
.33974 .18602 L
.34946 .18601 L
.35917 .186 L
.36888 .18599 L
.37859 .18598 L
.38831 .18597 L
.39802 .18596 L
.40773 .18595 L
.41744 .18594 L
.42716 .18593 L
.43687 .18592 L
.44658 .18591 L
.45629 .1859 L
.46601 .18589 L
.47572 .18589 L
.48543 .18588 L
.49514 .18587 L
Mistroke
.50486 .18586 L
.51457 .18585 L
.52428 .18585 L
.53399 .18584 L
.54371 .18583 L
.55342 .18583 L
.56313 .18582 L
.57284 .18581 L
.58256 .18581 L
.59227 .1858 L
.60198 .1858 L
.61169 .18579 L
.62141 .18578 L
.63112 .18578 L
.64083 .18577 L
.65054 .18577 L
.66026 .18576 L
.66997 .18576 L
.67968 .18576 L
.68939 .18575 L
.69911 .18575 L
.70882 .18574 L
.71853 .18574 L
.72824 .18574 L
.73796 .18573 L
.74767 .18573 L
.75738 .18573 L
.76709 .18573 L
.77681 .18572 L
.78652 .18572 L
.79623 .18572 L
.80594 .18572 L
.81566 .18571 L
.82537 .18571 L
.83508 .18571 L
.84479 .18571 L
.85451 .18571 L
.86422 .18571 L
.87393 .18571 L
.88364 .18571 L
.89336 .18571 L
.90307 .18571 L
.91278 .18571 L
.92249 .18571 L
.93221 .18571 L
.94192 .18571 L
.95163 .18571 L
.96134 .18571 L
.97106 .18571 L
.98077 .18571 L
Mistroke
Mfstroke
.55 g
.01923 .2759 m
.02894 .27503 L
.03866 .27417 L
.04837 .27334 L
.05808 .27252 L
.06734 .27176 L
.06779 .27172 L
.07751 .27094 L
.08722 .27017 L
.09693 .26943 L
.10664 .26869 L
.11636 .26798 L
.12607 .26728 L
.13578 .2666 L
.14549 .26593 L
.15521 .26527 L
.16492 .26463 L
.17463 .264 L
.18434 .26339 L
.19406 .26279 L
.20377 .2622 L
.2064 .26204 L
.21348 .26163 L
.22319 .26106 L
.23291 .26051 L
.24262 .25997 L
.25233 .25945 L
.26204 .25893 L
.27176 .25843 L
.28147 .25793 L
.29118 .25745 L
.30089 .25698 L
.31061 .25651 L
.32032 .25606 L
.33003 .25562 L
.33974 .25519 L
.34946 .25477 L
.35917 .25435 L
.36888 .25395 L
.37859 .25355 L
.38831 .25317 L
.39802 .25279 L
.40773 .25242 L
.41019 .25233 L
.41744 .25206 L
.42716 .25171 L
.43687 .25137 L
.44658 .25103 L
.45629 .25071 L
.46601 .25039 L
.47572 .25008 L
.48543 .24978 L
.49514 .24948 L
.50486 .24919 L
.51457 .24891 L
.52428 .24864 L
.53399 .24838 L
.54371 .24812 L
.55342 .24787 L
.56313 .24762 L
.57284 .24739 L
.58256 .24716 L
.59227 .24694 L
.60198 .24672 L
.61169 .24651 L
.62141 .24631 L
.63112 .24612 L
.64083 .24593 L
.65054 .24575 L
.66026 .24557 L
.66997 .2454 L
.67968 .24524 L
.68939 .24508 L
.69911 .24494 L
.70882 .24479 L
.71853 .24466 L
.72824 .24453 L
.73796 .24441 L
.74767 .24429 L
.75738 .24418 L
.76709 .24408 L
.77681 .24398 L
.78652 .24389 L
.79623 .24381 L
.80594 .24373 L
.81566 .24366 L
.82537 .24359 L
.83508 .24354 L
.84479 .24348 L
.85451 .24344 L
.86422 .2434 L
.87393 .24337 L
.88364 .24335 L
.89336 .24333 L
.90307 .24332 L
.91278 .24331 L
.92249 .24331 L
.93221 .24332 L
.94192 .24334 L
.95163 .24336 L
.96134 .24339 L
.97106 .24343 L
.98077 .24348 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .2759 m
.02894 .27503 L
.03866 .27417 L
.04837 .27334 L
.05808 .27252 L
.06734 .27176 L
.06779 .27172 L
.07751 .27094 L
.08722 .27017 L
.09693 .26943 L
.10664 .26869 L
.11636 .26798 L
.12607 .26728 L
.13578 .2666 L
.14549 .26593 L
.15521 .26527 L
.16492 .26463 L
.17463 .264 L
.18434 .26339 L
.19406 .26279 L
.20377 .2622 L
.2064 .26204 L
.21348 .26163 L
.22319 .26106 L
.23291 .26051 L
.24262 .25997 L
.25233 .25945 L
.26204 .25893 L
.27176 .25843 L
.28147 .25793 L
.29118 .25745 L
.30089 .25698 L
.31061 .25651 L
.32032 .25606 L
.33003 .25562 L
.33974 .25519 L
.34946 .25477 L
.35917 .25435 L
.36888 .25395 L
.37859 .25355 L
.38831 .25317 L
.39802 .25279 L
.40773 .25242 L
.41019 .25233 L
.41744 .25206 L
.42716 .25171 L
.43687 .25137 L
.44658 .25103 L
.45629 .25071 L
.46601 .25039 L
Mistroke
.47572 .25008 L
.48543 .24978 L
.49514 .24948 L
.50486 .24919 L
.51457 .24891 L
.52428 .24864 L
.53399 .24838 L
.54371 .24812 L
.55342 .24787 L
.56313 .24762 L
.57284 .24739 L
.58256 .24716 L
.59227 .24694 L
.60198 .24672 L
.61169 .24651 L
.62141 .24631 L
.63112 .24612 L
.64083 .24593 L
.65054 .24575 L
.66026 .24557 L
.66997 .2454 L
.67968 .24524 L
.68939 .24508 L
.69911 .24494 L
.70882 .24479 L
.71853 .24466 L
.72824 .24453 L
.73796 .24441 L
.74767 .24429 L
.75738 .24418 L
.76709 .24408 L
.77681 .24398 L
.78652 .24389 L
.79623 .24381 L
.80594 .24373 L
.81566 .24366 L
.82537 .24359 L
.83508 .24354 L
.84479 .24348 L
.85451 .24344 L
.86422 .2434 L
.87393 .24337 L
.88364 .24335 L
.89336 .24333 L
.90307 .24332 L
.91278 .24331 L
.92249 .24331 L
.93221 .24332 L
.94192 .24334 L
.95163 .24336 L
Mistroke
.96134 .24339 L
.97106 .24343 L
.98077 .24348 L
Mfstroke
.625 g
.01923 .37113 m
.02894 .36918 L
.03045 .36888 L
.03866 .36728 L
.04837 .36543 L
.05808 .36362 L
.06779 .36186 L
.07751 .36014 L
.08309 .35917 L
.08722 .35846 L
.09693 .35682 L
.10664 .35522 L
.11636 .35366 L
.12607 .35214 L
.13578 .35065 L
.14372 .34946 L
.14549 .34919 L
.15521 .34777 L
.16492 .34639 L
.17463 .34503 L
.18434 .34371 L
.19406 .34241 L
.20377 .34115 L
.21348 .33991 L
.21481 .33974 L
.22319 .3387 L
.23291 .33752 L
.24262 .33637 L
.25233 .33524 L
.26204 .33414 L
.27176 .33306 L
.28147 .33201 L
.29118 .33098 L
.30036 .33003 L
.30089 .32998 L
.31061 .32899 L
.32032 .32803 L
.33003 .3271 L
.33974 .32618 L
.34946 .32528 L
.35917 .32441 L
.36888 .32355 L
.37859 .32272 L
.38831 .3219 L
.39802 .32111 L
.40773 .32033 L
.40787 .32032 L
.41744 .31957 L
.42716 .31883 L
.43687 .31811 L
.44658 .3174 L
.45629 .31671 L
.46601 .31604 L
.47572 .31539 L
.48543 .31475 L
.49514 .31413 L
.50486 .31353 L
.51457 .31294 L
.52428 .31236 L
.53399 .31181 L
.54371 .31126 L
.55342 .31074 L
.55585 .31061 L
.56313 .31022 L
.57284 .30973 L
.58256 .30924 L
.59227 .30877 L
.60198 .30832 L
.61169 .30788 L
.62141 .30745 L
.63112 .30704 L
.64083 .30664 L
.65054 .30626 L
.66026 .30589 L
.66997 .30553 L
.67968 .30519 L
.68939 .30486 L
.69911 .30454 L
.70882 .30424 L
.71853 .30395 L
.72824 .30367 L
.73796 .30341 L
.74767 .30316 L
.75738 .30292 L
.76709 .3027 L
.77681 .30248 L
.78652 .30229 L
.79623 .3021 L
.80594 .30193 L
.81566 .30177 L
.82537 .30162 L
.83508 .30149 L
.84479 .30137 L
.85451 .30126 L
.86422 .30117 L
.87393 .30109 L
.88364 .30102 L
.89336 .30097 L
.90307 .30093 L
.91278 .3009 L
.91785 .30089 L
.92249 .30089 L
.93221 .30089 L
.93555 .30089 L
.94192 .3009 L
.95163 .30093 L
.96134 .30098 L
.97106 .30103 L
.98077 .30111 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .37113 m
.02894 .36918 L
.03045 .36888 L
.03866 .36728 L
.04837 .36543 L
.05808 .36362 L
.06779 .36186 L
.07751 .36014 L
.08309 .35917 L
.08722 .35846 L
.09693 .35682 L
.10664 .35522 L
.11636 .35366 L
.12607 .35214 L
.13578 .35065 L
.14372 .34946 L
.14549 .34919 L
.15521 .34777 L
.16492 .34639 L
.17463 .34503 L
.18434 .34371 L
.19406 .34241 L
.20377 .34115 L
.21348 .33991 L
.21481 .33974 L
.22319 .3387 L
.23291 .33752 L
.24262 .33637 L
.25233 .33524 L
.26204 .33414 L
.27176 .33306 L
.28147 .33201 L
.29118 .33098 L
.30036 .33003 L
.30089 .32998 L
.31061 .32899 L
.32032 .32803 L
.33003 .3271 L
.33974 .32618 L
.34946 .32528 L
.35917 .32441 L
.36888 .32355 L
.37859 .32272 L
.38831 .3219 L
.39802 .32111 L
.40773 .32033 L
.40787 .32032 L
.41744 .31957 L
.42716 .31883 L
.43687 .31811 L
Mistroke
.44658 .3174 L
.45629 .31671 L
.46601 .31604 L
.47572 .31539 L
.48543 .31475 L
.49514 .31413 L
.50486 .31353 L
.51457 .31294 L
.52428 .31236 L
.53399 .31181 L
.54371 .31126 L
.55342 .31074 L
.55585 .31061 L
.56313 .31022 L
.57284 .30973 L
.58256 .30924 L
.59227 .30877 L
.60198 .30832 L
.61169 .30788 L
.62141 .30745 L
.63112 .30704 L
.64083 .30664 L
.65054 .30626 L
.66026 .30589 L
.66997 .30553 L
.67968 .30519 L
.68939 .30486 L
.69911 .30454 L
.70882 .30424 L
.71853 .30395 L
.72824 .30367 L
.73796 .30341 L
.74767 .30316 L
.75738 .30292 L
.76709 .3027 L
.77681 .30248 L
.78652 .30229 L
.79623 .3021 L
.80594 .30193 L
.81566 .30177 L
.82537 .30162 L
.83508 .30149 L
.84479 .30137 L
.85451 .30126 L
.86422 .30117 L
.87393 .30109 L
.88364 .30102 L
.89336 .30097 L
.90307 .30093 L
.91278 .3009 L
Mistroke
.91785 .30089 L
.92249 .30089 L
.93221 .30089 L
.93555 .30089 L
.94192 .3009 L
.95163 .30093 L
.96134 .30098 L
.97106 .30103 L
.98077 .30111 L
Mfstroke
.7 g
.01923 .47754 m
.02431 .47572 L
.02894 .47408 L
.03866 .47073 L
.04837 .46747 L
.05283 .46601 L
.05808 .46431 L
.06779 .46123 L
.07751 .45823 L
.08395 .45629 L
.08722 .45532 L
.09693 .45249 L
.10664 .44973 L
.11636 .44705 L
.11807 .44658 L
.12607 .44443 L
.13578 .44189 L
.14549 .43941 L
.15521 .43699 L
.15572 .43687 L
.16492 .43464 L
.17463 .43235 L
.18434 .43011 L
.19406 .42793 L
.19756 .42716 L
.20377 .4258 L
.21348 .42373 L
.22319 .42171 L
.23291 .41973 L
.24262 .41781 L
.24449 .41744 L
.25233 .41593 L
.26204 .4141 L
.27176 .41231 L
.28147 .41057 L
.29118 .40886 L
.29778 .40773 L
.30089 .4072 L
.31061 .40558 L
.32032 .404 L
.33003 .40245 L
.33974 .40095 L
.34946 .39948 L
.35917 .39804 L
.35933 .39802 L
.36888 .39664 L
.37859 .39528 L
.38831 .39394 L
.39802 .39264 L
.40773 .39137 L
.41744 .39014 L
.42716 .38893 L
.43227 .38831 L
.43687 .38775 L
.44658 .38661 L
.45629 .38549 L
.46601 .3844 L
.47572 .38334 L
.48543 .3823 L
.49514 .38129 L
.50486 .38031 L
.51457 .37936 L
.52255 .37859 L
.52428 .37843 L
.53399 .37753 L
.54371 .37665 L
.55342 .37579 L
.56313 .37497 L
.57284 .37416 L
.58256 .37338 L
.59227 .37262 L
.60198 .37188 L
.61169 .37117 L
.62141 .37048 L
.63112 .36982 L
.64083 .36917 L
.6453 .36888 L
.65054 .36855 L
.66026 .36795 L
.66997 .36737 L
.67968 .36681 L
.68939 .36627 L
.69911 .36576 L
.70882 .36526 L
.71853 .36479 L
.72824 .36433 L
.73796 .3639 L
.74767 .36349 L
.75738 .3631 L
.76709 .36273 L
.77681 .36238 L
.78652 .36205 L
.79623 .36174 L
.80594 .36145 L
.81566 .36118 L
.82537 .36093 L
.83508 .3607 L
.84479 .3605 L
.85451 .36031 L
.86422 .36014 L
.87393 .36 L
.88364 .35987 L
.89336 .35976 L
.90307 .35968 L
.91278 .35962 L
.92249 .35957 L
.93221 .35955 L
.94192 .35955 L
.95163 .35957 L
.96134 .35961 L
.97106 .35968 L
.98077 .35977 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .47754 m
.02431 .47572 L
.02894 .47408 L
.03866 .47073 L
.04837 .46747 L
.05283 .46601 L
.05808 .46431 L
.06779 .46123 L
.07751 .45823 L
.08395 .45629 L
.08722 .45532 L
.09693 .45249 L
.10664 .44973 L
.11636 .44705 L
.11807 .44658 L
.12607 .44443 L
.13578 .44189 L
.14549 .43941 L
.15521 .43699 L
.15572 .43687 L
.16492 .43464 L
.17463 .43235 L
.18434 .43011 L
.19406 .42793 L
.19756 .42716 L
.20377 .4258 L
.21348 .42373 L
.22319 .42171 L
.23291 .41973 L
.24262 .41781 L
.24449 .41744 L
.25233 .41593 L
.26204 .4141 L
.27176 .41231 L
.28147 .41057 L
.29118 .40886 L
.29778 .40773 L
.30089 .4072 L
.31061 .40558 L
.32032 .404 L
.33003 .40245 L
.33974 .40095 L
.34946 .39948 L
.35917 .39804 L
.35933 .39802 L
.36888 .39664 L
.37859 .39528 L
.38831 .39394 L
.39802 .39264 L
.40773 .39137 L
Mistroke
.41744 .39014 L
.42716 .38893 L
.43227 .38831 L
.43687 .38775 L
.44658 .38661 L
.45629 .38549 L
.46601 .3844 L
.47572 .38334 L
.48543 .3823 L
.49514 .38129 L
.50486 .38031 L
.51457 .37936 L
.52255 .37859 L
.52428 .37843 L
.53399 .37753 L
.54371 .37665 L
.55342 .37579 L
.56313 .37497 L
.57284 .37416 L
.58256 .37338 L
.59227 .37262 L
.60198 .37188 L
.61169 .37117 L
.62141 .37048 L
.63112 .36982 L
.64083 .36917 L
.6453 .36888 L
.65054 .36855 L
.66026 .36795 L
.66997 .36737 L
.67968 .36681 L
.68939 .36627 L
.69911 .36576 L
.70882 .36526 L
.71853 .36479 L
.72824 .36433 L
.73796 .3639 L
.74767 .36349 L
.75738 .3631 L
.76709 .36273 L
.77681 .36238 L
.78652 .36205 L
.79623 .36174 L
.80594 .36145 L
.81566 .36118 L
.82537 .36093 L
.83508 .3607 L
.84479 .3605 L
.85451 .36031 L
.86422 .36014 L
Mistroke
.87393 .36 L
.88364 .35987 L
.89336 .35976 L
.90307 .35968 L
.91278 .35962 L
.92249 .35957 L
.93221 .35955 L
.94192 .35955 L
.95163 .35957 L
.96134 .35961 L
.97106 .35968 L
.98077 .35977 L
Mfstroke
.775 g
.01923 .60912 m
.02894 .60284 L
.0303 .60198 L
.03866 .59681 L
.04624 .59227 L
.04837 .59102 L
.05808 .58545 L
.06328 .58256 L
.06779 .58009 L
.07751 .57492 L
.08152 .57284 L
.08722 .56994 L
.09693 .56513 L
.10107 .56313 L
.10664 .56049 L
.11636 .55599 L
.12208 .55342 L
.12607 .55165 L
.13578 .54745 L
.14469 .54371 L
.14549 .54337 L
.15521 .53943 L
.16492 .5356 L
.1691 .53399 L
.17463 .5319 L
.18434 .5283 L
.19406 .5248 L
.19554 .52428 L
.20377 .52141 L
.21348 .51812 L
.22319 .51492 L
.22428 .51457 L
.23291 .51181 L
.24262 .50879 L
.25233 .50585 L
.25569 .50486 L
.26204 .50299 L
.27176 .50021 L
.28147 .49751 L
.29019 .49514 L
.29118 .49488 L
.30089 .49232 L
.31061 .48982 L
.32032 .4874 L
.32839 .48543 L
.33003 .48504 L
.33974 .48274 L
.34946 .4805 L
.35917 .47831 L
.36888 .47619 L
.37107 .47572 L
.37859 .47412 L
.38831 .47211 L
.39802 .47015 L
.40773 .46824 L
.41744 .46638 L
.41941 .46601 L
.42716 .46456 L
.43687 .4628 L
.44658 .46108 L
.45629 .45941 L
.46601 .45779 L
.47516 .45629 L
.47572 .4562 L
.48543 .45466 L
.49514 .45316 L
.50486 .45171 L
.51457 .45029 L
.52428 .44891 L
.53399 .44757 L
.54137 .44658 L
.54371 .44627 L
.55342 .44501 L
.56313 .44378 L
.57284 .44259 L
.58256 .44144 L
.59227 .44032 L
.60198 .43923 L
.61169 .43818 L
.62141 .43716 L
.62427 .43687 L
.63112 .43618 L
.64083 .43523 L
.65054 .43431 L
.66026 .43342 L
.66997 .43257 L
.67968 .43174 L
.68939 .43095 L
.69911 .43019 L
.70882 .42946 L
.71853 .42875 L
.72824 .42808 L
.73796 .42744 L
.74246 .42716 L
.74767 .42683 L
.75738 .42625 L
.76709 .4257 L
.77681 .42517 L
.78652 .42468 L
.79623 .42422 L
.80594 .42378 L
.81566 .42337 L
.82537 .423 L
.83508 .42265 L
.84479 .42233 L
.85451 .42204 L
.86422 .42177 L
.87393 .42154 L
.88364 .42134 L
.89336 .42116 L
.90307 .42102 L
.91278 .4209 L
.92249 .42081 L
.93221 .42075 L
.94192 .42073 L
.95163 .42073 L
.96134 .42076 L
.97106 .42083 L
.98077 .42092 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .60912 m
.02894 .60284 L
.0303 .60198 L
.03866 .59681 L
.04624 .59227 L
.04837 .59102 L
.05808 .58545 L
.06328 .58256 L
.06779 .58009 L
.07751 .57492 L
.08152 .57284 L
.08722 .56994 L
.09693 .56513 L
.10107 .56313 L
.10664 .56049 L
.11636 .55599 L
.12208 .55342 L
.12607 .55165 L
.13578 .54745 L
.14469 .54371 L
.14549 .54337 L
.15521 .53943 L
.16492 .5356 L
.1691 .53399 L
.17463 .5319 L
.18434 .5283 L
.19406 .5248 L
.19554 .52428 L
.20377 .52141 L
.21348 .51812 L
.22319 .51492 L
.22428 .51457 L
.23291 .51181 L
.24262 .50879 L
.25233 .50585 L
.25569 .50486 L
.26204 .50299 L
.27176 .50021 L
.28147 .49751 L
.29019 .49514 L
.29118 .49488 L
.30089 .49232 L
.31061 .48982 L
.32032 .4874 L
.32839 .48543 L
.33003 .48504 L
.33974 .48274 L
.34946 .4805 L
.35917 .47831 L
.36888 .47619 L
Mistroke
.37107 .47572 L
.37859 .47412 L
.38831 .47211 L
.39802 .47015 L
.40773 .46824 L
.41744 .46638 L
.41941 .46601 L
.42716 .46456 L
.43687 .4628 L
.44658 .46108 L
.45629 .45941 L
.46601 .45779 L
.47516 .45629 L
.47572 .4562 L
.48543 .45466 L
.49514 .45316 L
.50486 .45171 L
.51457 .45029 L
.52428 .44891 L
.53399 .44757 L
.54137 .44658 L
.54371 .44627 L
.55342 .44501 L
.56313 .44378 L
.57284 .44259 L
.58256 .44144 L
.59227 .44032 L
.60198 .43923 L
.61169 .43818 L
.62141 .43716 L
.62427 .43687 L
.63112 .43618 L
.64083 .43523 L
.65054 .43431 L
.66026 .43342 L
.66997 .43257 L
.67968 .43174 L
.68939 .43095 L
.69911 .43019 L
.70882 .42946 L
.71853 .42875 L
.72824 .42808 L
.73796 .42744 L
.74246 .42716 L
.74767 .42683 L
.75738 .42625 L
.76709 .4257 L
.77681 .42517 L
.78652 .42468 L
.79623 .42422 L
Mistroke
.80594 .42378 L
.81566 .42337 L
.82537 .423 L
.83508 .42265 L
.84479 .42233 L
.85451 .42204 L
.86422 .42177 L
.87393 .42154 L
.88364 .42134 L
.89336 .42116 L
.90307 .42102 L
.91278 .4209 L
.92249 .42081 L
.93221 .42075 L
.94192 .42073 L
.95163 .42073 L
.96134 .42076 L
.97106 .42083 L
.98077 .42092 L
Mfstroke
.85 g
.98077 .48681 m
.97106 .48671 L
.96134 .48665 L
.95163 .48663 L
.94192 .48666 L
.93221 .48672 L
.92249 .48683 L
.91278 .48698 L
.90307 .48716 L
.89336 .48739 L
.88364 .48766 L
.87393 .48797 L
.86422 .48832 L
.85451 .48871 L
.84479 .48914 L
.83508 .48961 L
.82537 .49012 L
.81566 .49067 L
.80594 .49126 L
.79623 .49189 L
.78652 .49256 L
.77681 .49327 L
.76709 .49402 L
.75738 .49482 L
.75355 .49514 L
.74767 .49566 L
.73796 .49653 L
.72824 .49745 L
.71853 .49842 L
.70882 .49942 L
.69911 .50047 L
.68939 .50156 L
.67968 .5027 L
.66997 .50389 L
.66227 .50486 L
.66026 .50511 L
.65054 .50639 L
.64083 .50771 L
.63112 .50908 L
.62141 .5105 L
.61169 .51197 L
.60198 .51349 L
.59525 .51457 L
.59227 .51506 L
.58256 .51668 L
.57284 .51835 L
.56313 .52008 L
.55342 .52186 L
.54371 .52371 L
.54073 .52428 L
.53399 .5256 L
.52428 .52756 L
.51457 .52958 L
.50486 .53166 L
.49514 .53381 L
.49433 .53399 L
.48543 .53602 L
.47572 .5383 L
.46601 .54065 L
.45629 .54307 L
.45379 .54371 L
.44658 .54556 L
.43687 .54813 L
.42716 .55078 L
.41778 .55342 L
.41744 .55351 L
.40773 .55633 L
.39802 .55923 L
.38831 .56222 L
.38541 .56313 L
.37859 .56531 L
.36888 .56849 L
.35917 .57177 L
.35606 .57284 L
.34946 .57516 L
.33974 .57866 L
.33003 .58228 L
.32929 .58256 L
.32032 .58601 L
.31061 .58987 L
.30474 .59227 L
.30089 .59387 L
.29118 .598 L
.28214 .60198 L
.28147 .60228 L
.27176 .60672 L
.26204 .61132 L
.26127 .61169 L
.25233 .61609 L
.24262 .62106 L
.24195 .62141 L
.23291 .62622 L
.22404 .63112 L
.22319 .63159 L
.21348 .6372 L
.2074 .64083 L
.20377 .64305 L
.19406 .64918 L
.19195 .65054 L
.18434 .65559 L
.17757 .66026 L
.17463 .66233 L
.16492 .66944 L
.16421 .66997 L
.15521 .67694 L
.15179 .67968 L
.14549 .68489 L
.14025 .68939 L
.13578 .69336 L
.12955 .69911 L
.12607 .70244 L
.11964 .70882 L
.11636 .71222 L
.11049 .71853 L
.10664 .72286 L
.10206 .72824 L
.09693 .73459 L
.09433 .73796 L
.08727 .74767 L
.08722 .74774 L
.08086 .75738 L
.07751 .7629 L
.07509 .76709 L
.06995 .77681 L
.06779 .78126 L
.06542 .78652 L
.0615 .79623 L
.05819 .80594 L
.05808 .80628 L
.05548 .81566 L
.05337 .82537 L
.05188 .83508 L
.05101 .84479 L
.05077 .85451 L
.05118 .86422 L
.05224 .87393 L
.054 .88364 L
.05646 .89336 L
.05808 .89861 L
.05966 .90307 L
.06363 .91278 L
.06779 .92134 L
.06841 .92249 L
.07405 .93221 L
.07751 .93751 L
.0806 .94192 L
.08722 .95054 L
.08811 .95163 L
.09666 .96134 L
.09693 .96163 L
.10633 .97106 L
.10664 .97136 L
.11636 .98006 L
.11719 .98077 L
.98077 .98077 L
F
0 g
.98077 .48681 m
.97106 .48671 L
.96134 .48665 L
.95163 .48663 L
.94192 .48666 L
.93221 .48672 L
.92249 .48683 L
.91278 .48698 L
.90307 .48716 L
.89336 .48739 L
.88364 .48766 L
.87393 .48797 L
.86422 .48832 L
.85451 .48871 L
.84479 .48914 L
.83508 .48961 L
.82537 .49012 L
.81566 .49067 L
.80594 .49126 L
.79623 .49189 L
.78652 .49256 L
.77681 .49327 L
.76709 .49402 L
.75738 .49482 L
.75355 .49514 L
.74767 .49566 L
.73796 .49653 L
.72824 .49745 L
.71853 .49842 L
.70882 .49942 L
.69911 .50047 L
.68939 .50156 L
.67968 .5027 L
.66997 .50389 L
.66227 .50486 L
.66026 .50511 L
.65054 .50639 L
.64083 .50771 L
.63112 .50908 L
.62141 .5105 L
.61169 .51197 L
.60198 .51349 L
.59525 .51457 L
.59227 .51506 L
.58256 .51668 L
.57284 .51835 L
.56313 .52008 L
.55342 .52186 L
.54371 .52371 L
.54073 .52428 L
Mistroke
.53399 .5256 L
.52428 .52756 L
.51457 .52958 L
.50486 .53166 L
.49514 .53381 L
.49433 .53399 L
.48543 .53602 L
.47572 .5383 L
.46601 .54065 L
.45629 .54307 L
.45379 .54371 L
.44658 .54556 L
.43687 .54813 L
.42716 .55078 L
.41778 .55342 L
.41744 .55351 L
.40773 .55633 L
.39802 .55923 L
.38831 .56222 L
.38541 .56313 L
.37859 .56531 L
.36888 .56849 L
.35917 .57177 L
.35606 .57284 L
.34946 .57516 L
.33974 .57866 L
.33003 .58228 L
.32929 .58256 L
.32032 .58601 L
.31061 .58987 L
.30474 .59227 L
.30089 .59387 L
.29118 .598 L
.28214 .60198 L
.28147 .60228 L
.27176 .60672 L
.26204 .61132 L
.26127 .61169 L
.25233 .61609 L
.24262 .62106 L
.24195 .62141 L
.23291 .62622 L
.22404 .63112 L
.22319 .63159 L
.21348 .6372 L
.2074 .64083 L
.20377 .64305 L
.19406 .64918 L
.19195 .65054 L
.18434 .65559 L
Mistroke
.17757 .66026 L
.17463 .66233 L
.16492 .66944 L
.16421 .66997 L
.15521 .67694 L
.15179 .67968 L
.14549 .68489 L
.14025 .68939 L
.13578 .69336 L
.12955 .69911 L
.12607 .70244 L
.11964 .70882 L
.11636 .71222 L
.11049 .71853 L
.10664 .72286 L
.10206 .72824 L
.09693 .73459 L
.09433 .73796 L
.08727 .74767 L
.08722 .74774 L
.08086 .75738 L
.07751 .7629 L
.07509 .76709 L
.06995 .77681 L
.06779 .78126 L
.06542 .78652 L
.0615 .79623 L
.05819 .80594 L
.05808 .80628 L
.05548 .81566 L
.05337 .82537 L
.05188 .83508 L
.05101 .84479 L
.05077 .85451 L
.05118 .86422 L
.05224 .87393 L
.054 .88364 L
.05646 .89336 L
.05808 .89861 L
.05966 .90307 L
.06363 .91278 L
.06779 .92134 L
.06841 .92249 L
.07405 .93221 L
.07751 .93751 L
.0806 .94192 L
.08722 .95054 L
.08811 .95163 L
.09666 .96134 L
.09693 .96163 L
Mistroke
.10633 .97106 L
.10664 .97136 L
.11636 .98006 L
.11719 .98077 L
Mfstroke
.25 g
.98077 .06517 m
.97106 .06535 L
.96134 .0655 L
.95163 .06565 L
.94192 .06577 L
.93221 .06589 L
.92249 .06598 L
.91278 .06607 L
.90307 .06613 L
.89336 .06619 L
.88364 .06622 L
.87393 .06625 L
.86422 .06626 L
.85451 .06625 L
.84479 .06624 L
.83508 .06621 L
.82537 .06616 L
.81566 .0661 L
.80594 .06603 L
.79623 .06595 L
.78652 .06585 L
.77681 .06574 L
.76709 .06561 L
.75738 .06548 L
.74767 .06533 L
.73796 .06517 L
.72824 .06499 L
.71853 .06481 L
.70882 .06461 L
.69911 .06439 L
.68939 .06417 L
.67968 .06393 L
.66997 .06368 L
.66026 .06342 L
.65054 .06314 L
.64083 .06286 L
.63112 .06255 L
.62141 .06224 L
.61169 .06192 L
.60198 .06158 L
.59227 .06123 L
.58256 .06087 L
.57284 .06049 L
.56313 .0601 L
.55342 .0597 L
.54371 .05929 L
.53399 .05886 L
.52428 .05842 L
.51694 .05808 L
.51457 .05797 L
.50486 .0575 L
.49514 .05702 L
.48543 .05653 L
.47572 .05603 L
.46601 .05551 L
.45629 .05498 L
.44658 .05443 L
.43687 .05387 L
.42716 .0533 L
.41744 .05271 L
.40773 .05211 L
.39802 .05149 L
.38831 .05086 L
.37859 .05022 L
.36888 .04956 L
.35917 .04888 L
.35187 .04837 L
.34946 .0482 L
.33974 .04749 L
.33003 .04677 L
.32032 .04604 L
.31061 .04529 L
.30089 .04452 L
.29118 .04374 L
.28147 .04294 L
.27176 .04213 L
.26204 .0413 L
.25233 .04045 L
.24262 .03959 L
.23291 .03871 L
.23235 .03866 L
.22319 .03781 L
.21348 .03689 L
.20377 .03596 L
.19406 .03501 L
.18434 .03404 L
.17463 .03305 L
.16492 .03204 L
.15521 .03101 L
.14549 .02997 L
.13616 .02894 L
.13578 .0289 L
.12607 .02782 L
.11636 .02671 L
.10664 .02558 L
.09693 .02444 L
.08722 .02327 L
.07751 .02208 L
.06779 .02087 L
.05808 .01964 L
.05491 .01923 L
.98077 .01923 L
F
0 g
.98077 .06517 m
.97106 .06535 L
.96134 .0655 L
.95163 .06565 L
.94192 .06577 L
.93221 .06589 L
.92249 .06598 L
.91278 .06607 L
.90307 .06613 L
.89336 .06619 L
.88364 .06622 L
.87393 .06625 L
.86422 .06626 L
.85451 .06625 L
.84479 .06624 L
.83508 .06621 L
.82537 .06616 L
.81566 .0661 L
.80594 .06603 L
.79623 .06595 L
.78652 .06585 L
.77681 .06574 L
.76709 .06561 L
.75738 .06548 L
.74767 .06533 L
.73796 .06517 L
.72824 .06499 L
.71853 .06481 L
.70882 .06461 L
.69911 .06439 L
.68939 .06417 L
.67968 .06393 L
.66997 .06368 L
.66026 .06342 L
.65054 .06314 L
.64083 .06286 L
.63112 .06255 L
.62141 .06224 L
.61169 .06192 L
.60198 .06158 L
.59227 .06123 L
.58256 .06087 L
.57284 .06049 L
.56313 .0601 L
.55342 .0597 L
.54371 .05929 L
.53399 .05886 L
.52428 .05842 L
.51694 .05808 L
.51457 .05797 L
Mistroke
.50486 .0575 L
.49514 .05702 L
.48543 .05653 L
.47572 .05603 L
.46601 .05551 L
.45629 .05498 L
.44658 .05443 L
.43687 .05387 L
.42716 .0533 L
.41744 .05271 L
.40773 .05211 L
.39802 .05149 L
.38831 .05086 L
.37859 .05022 L
.36888 .04956 L
.35917 .04888 L
.35187 .04837 L
.34946 .0482 L
.33974 .04749 L
.33003 .04677 L
.32032 .04604 L
.31061 .04529 L
.30089 .04452 L
.29118 .04374 L
.28147 .04294 L
.27176 .04213 L
.26204 .0413 L
.25233 .04045 L
.24262 .03959 L
.23291 .03871 L
.23235 .03866 L
.22319 .03781 L
.21348 .03689 L
.20377 .03596 L
.19406 .03501 L
.18434 .03404 L
.17463 .03305 L
.16492 .03204 L
.15521 .03101 L
.14549 .02997 L
.13616 .02894 L
.13578 .0289 L
.12607 .02782 L
.11636 .02671 L
.10664 .02558 L
.09693 .02444 L
.08722 .02327 L
.07751 .02208 L
.06779 .02087 L
.05808 .01964 L
Mistroke
.05491 .01923 L
Mfstroke
.925 g
.98077 .56174 m
.97106 .56162 L
.96134 .56156 L
.95163 .56156 L
.94192 .56162 L
.93221 .56174 L
.92249 .56192 L
.91278 .56215 L
.90307 .56245 L
.89336 .5628 L
.88528 .56313 L
.88364 .5632 L
.87393 .56367 L
.86422 .56419 L
.85451 .56477 L
.84479 .56541 L
.83508 .5661 L
.82537 .56686 L
.81566 .56767 L
.80594 .56854 L
.79623 .56947 L
.78652 .57046 L
.77681 .5715 L
.76709 .57261 L
.76515 .57284 L
.75738 .57379 L
.74767 .57502 L
.73796 .57632 L
.72824 .57768 L
.71853 .5791 L
.70882 .58059 L
.69911 .58215 L
.69665 .58256 L
.68939 .58378 L
.67968 .58548 L
.66997 .58725 L
.66026 .58909 L
.65054 .591 L
.64433 .59227 L
.64083 .593 L
.63112 .59507 L
.62141 .59722 L
.61169 .59946 L
.60198 .60178 L
.60114 .60198 L
.59227 .60419 L
.58256 .60669 L
.57284 .60928 L
.56412 .61169 L
.56313 .61197 L
.55342 .61476 L
.54371 .61766 L
.53399 .62067 L
.53168 .62141 L
.52428 .62379 L
.51457 .62704 L
.50486 .6304 L
.50284 .63112 L
.49514 .6339 L
.48543 .63754 L
.47696 .64083 L
.47572 .64132 L
.46601 .64526 L
.45629 .64936 L
.45357 .65054 L
.44658 .65364 L
.43687 .6581 L
.43233 .66026 L
.42716 .66277 L
.41744 .66765 L
.41298 .66997 L
.40773 .67276 L
.39802 .67814 L
.39531 .67968 L
.38831 .68379 L
.37917 .68939 L
.37859 .68975 L
.36888 .69607 L
.3644 .69911 L
.35917 .70277 L
.35092 .70882 L
.34946 .70993 L
.33974 .71761 L
.33862 .71853 L
.33003 .7259 L
.32743 .72824 L
.32032 .73496 L
.3173 .73796 L
.31061 .74496 L
.30816 .74767 L
.30089 .75624 L
.29998 .75738 L
.29272 .76709 L
.29118 .76932 L
.28636 .77681 L
.28147 .78537 L
.28087 .78652 L
.27623 .79623 L
.27245 .80594 L
.27176 .80795 L
.26951 .81566 L
.26742 .82537 L
.26618 .83508 L
.26579 .84479 L
.26629 .85451 L
.26769 .86422 L
.27002 .87393 L
.27176 .87951 L
.27331 .88364 L
.2776 .89336 L
.28147 .90057 L
.28296 .90307 L
.28943 .91278 L
.29118 .91515 L
.2971 .92249 L
.30089 .9268 L
.30604 .93221 L
.31061 .93668 L
.31635 .94192 L
.32032 .94533 L
.32817 .95163 L
.33003 .95305 L
.33974 .96005 L
.34164 .96134 L
.34946 .96646 L
.35693 .97106 L
.35917 .97238 L
.36888 .97787 L
.37428 .98077 L
.98077 .98077 L
F
0 g
.98077 .56174 m
.97106 .56162 L
.96134 .56156 L
.95163 .56156 L
.94192 .56162 L
.93221 .56174 L
.92249 .56192 L
.91278 .56215 L
.90307 .56245 L
.89336 .5628 L
.88528 .56313 L
.88364 .5632 L
.87393 .56367 L
.86422 .56419 L
.85451 .56477 L
.84479 .56541 L
.83508 .5661 L
.82537 .56686 L
.81566 .56767 L
.80594 .56854 L
.79623 .56947 L
.78652 .57046 L
.77681 .5715 L
.76709 .57261 L
.76515 .57284 L
.75738 .57379 L
.74767 .57502 L
.73796 .57632 L
.72824 .57768 L
.71853 .5791 L
.70882 .58059 L
.69911 .58215 L
.69665 .58256 L
.68939 .58378 L
.67968 .58548 L
.66997 .58725 L
.66026 .58909 L
.65054 .591 L
.64433 .59227 L
.64083 .593 L
.63112 .59507 L
.62141 .59722 L
.61169 .59946 L
.60198 .60178 L
.60114 .60198 L
.59227 .60419 L
.58256 .60669 L
.57284 .60928 L
.56412 .61169 L
.56313 .61197 L
Mistroke
.55342 .61476 L
.54371 .61766 L
.53399 .62067 L
.53168 .62141 L
.52428 .62379 L
.51457 .62704 L
.50486 .6304 L
.50284 .63112 L
.49514 .6339 L
.48543 .63754 L
.47696 .64083 L
.47572 .64132 L
.46601 .64526 L
.45629 .64936 L
.45357 .65054 L
.44658 .65364 L
.43687 .6581 L
.43233 .66026 L
.42716 .66277 L
.41744 .66765 L
.41298 .66997 L
.40773 .67276 L
.39802 .67814 L
.39531 .67968 L
.38831 .68379 L
.37917 .68939 L
.37859 .68975 L
.36888 .69607 L
.3644 .69911 L
.35917 .70277 L
.35092 .70882 L
.34946 .70993 L
.33974 .71761 L
.33862 .71853 L
.33003 .7259 L
.32743 .72824 L
.32032 .73496 L
.3173 .73796 L
.31061 .74496 L
.30816 .74767 L
.30089 .75624 L
.29998 .75738 L
.29272 .76709 L
.29118 .76932 L
.28636 .77681 L
.28147 .78537 L
.28087 .78652 L
.27623 .79623 L
.27245 .80594 L
.27176 .80795 L
Mistroke
.26951 .81566 L
.26742 .82537 L
.26618 .83508 L
.26579 .84479 L
.26629 .85451 L
.26769 .86422 L
.27002 .87393 L
.27176 .87951 L
.27331 .88364 L
.2776 .89336 L
.28147 .90057 L
.28296 .90307 L
.28943 .91278 L
.29118 .91515 L
.2971 .92249 L
.30089 .9268 L
.30604 .93221 L
.31061 .93668 L
.31635 .94192 L
.32032 .94533 L
.32817 .95163 L
.33003 .95305 L
.33974 .96005 L
.34164 .96134 L
.34946 .96646 L
.35693 .97106 L
.35917 .97238 L
.36888 .97787 L
.37428 .98077 L
Mfstroke
1 g
.98077 .65809 m
.97106 .65789 L
.96134 .6578 L
.95163 .6578 L
.94192 .65791 L
.93221 .65811 L
.92249 .65841 L
.91278 .65881 L
.90307 .6593 L
.89336 .65989 L
.88807 .66026 L
.88364 .66058 L
.87393 .66137 L
.86422 .66226 L
.85451 .66325 L
.84479 .66433 L
.83508 .66552 L
.82537 .66682 L
.81566 .66822 L
.80594 .66973 L
.80447 .66997 L
.79623 .67135 L
.78652 .67308 L
.77681 .67493 L
.76709 .6769 L
.75738 .679 L
.75433 .67968 L
.74767 .68122 L
.73796 .68358 L
.72824 .68608 L
.71853 .68872 L
.71615 .68939 L
.70882 .69152 L
.69911 .69448 L
.68939 .69762 L
.68497 .69911 L
.67968 .70094 L
.66997 .70445 L
.66026 .70819 L
.65867 .70882 L
.65054 .71215 L
.64083 .71636 L
.63607 .71853 L
.63112 .72086 L
.62141 .72567 L
.61647 .72824 L
.61169 .73083 L
.60198 .7364 L
.5994 .73796 L
.59227 .74244 L
.58453 .74767 L
.58256 .74906 L
.57284 .75639 L
.5716 .75738 L
.56313 .76462 L
.56046 .76709 L
.55342 .77413 L
.55097 .77681 L
.54371 .7856 L
.54302 .78652 L
.53655 .79623 L
.53399 .80075 L
.53152 .80594 L
.52788 .81566 L
.52563 .82537 L
.52477 .83508 L
.52533 .84479 L
.52734 .85451 L
.53086 .86422 L
.53399 .87063 L
.53597 .87393 L
.54277 .88364 L
.54371 .88482 L
.55141 .89336 L
.55342 .89536 L
.56206 .90307 L
.56313 .90395 L
.57284 .9113 L
.57497 .91278 L
.58256 .91776 L
.59048 .92249 L
.59227 .92351 L
.60198 .92873 L
.60902 .93221 L
.61169 .93347 L
.62141 .93783 L
.63112 .94185 L
.63129 .94192 L
.64083 .94558 L
.65054 .94904 L
.65831 .95163 L
.66026 .95226 L
.66997 .95527 L
.67968 .95807 L
.68939 .96069 L
.69191 .96134 L
.69911 .96315 L
.70882 .96544 L
.71853 .96758 L
.72824 .96958 L
.73586 .97106 L
.73796 .97145 L
.74767 .97319 L
.75738 .9748 L
.76709 .9763 L
.77681 .97769 L
.78652 .97897 L
.79623 .98014 L
.80182 .98077 L
.98077 .98077 L
F
0 g
.98077 .65809 m
.97106 .65789 L
.96134 .6578 L
.95163 .6578 L
.94192 .65791 L
.93221 .65811 L
.92249 .65841 L
.91278 .65881 L
.90307 .6593 L
.89336 .65989 L
.88807 .66026 L
.88364 .66058 L
.87393 .66137 L
.86422 .66226 L
.85451 .66325 L
.84479 .66433 L
.83508 .66552 L
.82537 .66682 L
.81566 .66822 L
.80594 .66973 L
.80447 .66997 L
.79623 .67135 L
.78652 .67308 L
.77681 .67493 L
.76709 .6769 L
.75738 .679 L
.75433 .67968 L
.74767 .68122 L
.73796 .68358 L
.72824 .68608 L
.71853 .68872 L
.71615 .68939 L
.70882 .69152 L
.69911 .69448 L
.68939 .69762 L
.68497 .69911 L
.67968 .70094 L
.66997 .70445 L
.66026 .70819 L
.65867 .70882 L
.65054 .71215 L
.64083 .71636 L
.63607 .71853 L
.63112 .72086 L
.62141 .72567 L
.61647 .72824 L
.61169 .73083 L
.60198 .7364 L
.5994 .73796 L
.59227 .74244 L
Mistroke
.58453 .74767 L
.58256 .74906 L
.57284 .75639 L
.5716 .75738 L
.56313 .76462 L
.56046 .76709 L
.55342 .77413 L
.55097 .77681 L
.54371 .7856 L
.54302 .78652 L
.53655 .79623 L
.53399 .80075 L
.53152 .80594 L
.52788 .81566 L
.52563 .82537 L
.52477 .83508 L
.52533 .84479 L
.52734 .85451 L
.53086 .86422 L
.53399 .87063 L
.53597 .87393 L
.54277 .88364 L
.54371 .88482 L
.55141 .89336 L
.55342 .89536 L
.56206 .90307 L
.56313 .90395 L
.57284 .9113 L
.57497 .91278 L
.58256 .91776 L
.59048 .92249 L
.59227 .92351 L
.60198 .92873 L
.60902 .93221 L
.61169 .93347 L
.62141 .93783 L
.63112 .94185 L
.63129 .94192 L
.64083 .94558 L
.65054 .94904 L
.65831 .95163 L
.66026 .95226 L
.66997 .95527 L
.67968 .95807 L
.68939 .96069 L
.69191 .96134 L
.69911 .96315 L
.70882 .96544 L
.71853 .96758 L
.72824 .96958 L
Mistroke
.73586 .97106 L
.73796 .97145 L
.74767 .97319 L
.75738 .9748 L
.76709 .9763 L
.77681 .97769 L
.78652 .97897 L
.79623 .98014 L
.80182 .98077 L
Mfstroke
0 0 0 r
.055 w
.94336 .82584 Mdot
0 1 1 r
.045 w
.01923 .01923 Mdot
.81501 .98074 Mdot
.98073 .82147 Mdot
.94394 .82583 Mdot
.94336 .82584 Mdot
1 0 0 r
.0325 w
.01923 .01923 Mdot
.01923 .01923 Mdot
.01925 .01923 Mdot
.01923 .01924 Mdot
.81501 .98074 Mdot
.81501 .98074 Mdot
.81503 .98074 Mdot
.81501 .98076 Mdot
.98073 .82147 Mdot
.98073 .82147 Mdot
.98075 .82147 Mdot
.98073 .82148 Mdot
.94394 .82583 Mdot
.94394 .82583 Mdot
.94396 .82583 Mdot
.94394 .82584 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
0 1 0 r
.02 w
.01923 .01923 Mdot
.01923 .01923 Mdot
.01923 .01923 Mdot
.01923 .01923 Mdot
.01923 .01923 Mdot
.01925 .01923 Mdot
.01923 .01924 Mdot
.01925 .01923 Mdot
.01926 .01923 Mdot
.01925 .01924 Mdot
.01923 .01924 Mdot
.01925 .01924 Mdot
.01923 .01925 Mdot
.81501 .98074 Mdot
.81501 .98074 Mdot
.81503 .98074 Mdot
.81501 .98076 Mdot
.81501 .98074 Mdot
.81503 .98074 Mdot
.81501 .98076 Mdot
.81503 .98074 Mdot
.81505 .98074 Mdot
.81503 .98076 Mdot
.81501 .98076 Mdot
.81503 .98076 Mdot
.81501 .98077 Mdot
.98073 .82147 Mdot
.98073 .82147 Mdot
.98075 .82147 Mdot
.98073 .82148 Mdot
.98073 .82147 Mdot
.98075 .82147 Mdot
.98073 .82148 Mdot
.98075 .82147 Mdot
.98077 .82147 Mdot
.98075 .82148 Mdot
.98073 .82148 Mdot
.98075 .82148 Mdot
.98073 .82149 Mdot
.94394 .82583 Mdot
.94394 .82583 Mdot
.94396 .82583 Mdot
.94394 .82584 Mdot
.94394 .82583 Mdot
.94396 .82583 Mdot
.94394 .82584 Mdot
.94396 .82583 Mdot
.94398 .82583 Mdot
.94396 .82584 Mdot
.94394 .82584 Mdot
.94396 .82584 Mdot
.94394 .82585 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94338 .82584 Mdot
.9434 .82584 Mdot
.94338 .82585 Mdot
.94336 .82585 Mdot
.94338 .82585 Mdot
.94336 .82587 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
.94336 .82584 Mdot
.94336 .82584 Mdot
.94338 .82584 Mdot
.94336 .82585 Mdot
0 0 1 r
.5 Mabswid
.01923 .01923 m
.01923 .01923 L
.81501 .98074 L
.98073 .82147 L
.94394 .82583 L
.94336 .82584 L
s
.015 w
.01923 .01923 Mdot
.01923 .01923 Mdot
.81501 .98074 Mdot
.98073 .82147 Mdot
.94394 .82583 Mdot
.94336 .82584 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`005`3oool01P3ookl0M000000000000000001809cOocD0oooo00X0oono07@0000000000000
0000B02Lgol0oooo0?oo_`1d000004RL0P3oool01P3ookl0M000000000000000001809cOobl0oooo
00X0oono07@00000000000000000B02Lgol0oooo0?oo_`1d000004RL0P3oool01P3o_g@000000000
00000000001d0;oooc00oooo00X0oono07@00000000000000000B02Lgol0oooo0?oo_`1d000004RL
0`3oool0103OW4P0000000000000M;lj0?ooo`006@3oool00`3o_g@0B9cO0?ooo`0h0?ooo`030?no
M018W=l0oooo00T0oooo00<0okmd04RLg`3oool0<P3oool00`3o_g@0B9cO0?ooo`080?ooo`0309a8
000007@0_ooo03@0oooo00<0okmd04RLg`3oool01`3oool01P3ogi`0B4RL0?ooo`3ookl0M01809cO
ocT0oooo000I0?ooo`030?noM018W=l0oooo03P0oooo00<0okmd04RLg`3oool02@3oool00`3o_g@0
B9cO0?ooo`0b0?ooo`030?noM018W=l0oooo00T0oooo00<0okmd0000001d_ol0<`3oool00`3o_g@0
B9cO0?ooo`090?ooo`030;md00000000M;oo03X0oooo000I0?ooo`030?noM018W=l0oooo03P0oooo
00<0okmd04RLg`3oool02@3oool00`3o_g@0B9cO0?ooo`0b0?ooo`030?noM018W=l0oooo00X0oooo
00<0oono0;noo`3oool0<P3oool00`3o_g@0B9cO0?ooo`0:0?ooo`030?oo_`1dB9`0oooo03T0oooo
000H0?ooo`0309a8M02o_g@0B9cO03P0oooo00<0W4Qd0;noM018W=l02@3oool00`2LB7@0_kmd04RL
g`0b0?ooo`0309a8M02o_g@0B9cO00P0oooo00H0omnL04Q8W03oool0oono07@0M02ooola0?ooo`03
09a8M02o_g@0B9cO00P0oooo00H0oono07@0B02Lgol0oono07@0M02oooli0?ooo`00603oool00`3o
_g@0000004RLg`0h0?ooo`030?noM0000000B9cO00T0oooo00<0okmd00000018W=l0<P3oool00`3o
_g@0000004RLg`090?ooo`040=nLB0000000000004RLgc80oooo00<0okmd00000018W=l02@3oool0
103ogi`0B0000000001d_olj0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005@3ooooo000000/000000@3oool001D0oooo00<000000?oo
o`3oool00`00ool<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo0@0000010?ooo`005@3oool010000000
0?oo003oo`00ool20?l000800?oo?P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo
03l0oooo00<000000?ooo`3oool0?@3oool100000040oooo000<0?ooo`060?oo_`1d000000000000
000004P0W=oo0`3oool2003oo`H0o`0000<00?oo0?ooo`3oool0oP3oool100000040oooo000>0?oo
o`030?noM018W=l0oooo00@0oooo0P00ool20?l000<00?l000<0o`00003oo`3oool0o`3oool10000
0040oooo000>0?ooo`030?noM018W=l0oooo00@0oooo00@00?oo0?l0003o00000?l00P000?l2003o
00030?l00000ool0oooo00<0oooo00<000000?ooo`3oool0m`3oool200000040oooo000>0?ooo`03
0?noM018W=l0oooo00@0oooo00<00?oo0?l0003o000010000?l00`00o`00o`00003oo`0505=CD`L0
0000kP0o?cl50?ooo`4000000@3oool000d0oooo00<0W4Qd0;noM018W=l01@3oool2003oo`030?l0
0000o`00003o00800?l000<0003o003oo`00ool0301CDe<:00000>@0?clo1@3oool100000040oooo
000=0?ooo`030?noM0000000B9cO00D0oooo0P00ool20?l000<00?l000<0003o003oo`1CDe<05P1C
De<800000=`0?clo1@3oool100000040oooo000E0?ooo`@00?oo0P3o0002003oo`030000o`1CDe<0
De=C01d0De=C2P00003B03lo?`D0oooo0@0000010?ooo`005@3oool00`0000000?oo003oo`05003o
o`0305=CD`000?l0De=C02L0De=C2`00003703lo?`D0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`03003oo`@0De=C00<0003o05=CD`1CDe<0<01CDe<:00000;d0?clo1@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo1P1CDe<00`000?l0De=C05=CD`0i05=CD`d00000
/00o?cl50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool705=CD`030000o`1C
De<0De=C04D0De=C3@00002S03lo?`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`L0De=C00<0003o05=CD`1CDe<0DP1CDe<?000009@0?clo1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo201CDe<00`000?l0De=C05=CD`1P05=CDa800000PP0o?cl50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool905=CD`030000o`1CDe<0De=C0740
De=C6000001Z03lo?`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0De=C
00<0003o05=CD`1CDe<0R01CDe<Q000004T0?clo1@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo2`1CDe<00`000?l0De=C05=CD`2X05=CDdX00000103oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo301CDe<00`000?l0De=C05=CD`3`05=CD`D0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo``0De=C00<0003o05=CD`1CDe<0l01CDe<50?oo
o`4000000@3oool001D0oooo0P0000030?ooo`d0De=C00<0003o05=CD`1CDe<0k`1CDe<40?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool>05=CD`030000o`1CDe<0De=C0>h0De=C
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3`1CDe<00`000?l0De=C05=C
D`3]05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa00De=C00<0003o
05=CD`1CDe<0k01CDe<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool@05=C
D`030000o`1CDe<0De=C0>`0De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo4@1CDe<00`000?l0De=C05=CD`3[05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooo`L000002`1CDe<00`000?l0De=C05=CD`3Z05=CD`D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`L0IVIV300000000`000?l000000000003Y05=CD`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooa@0IVIV00<0003o06IVIP0000004@00003G
05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaD0IVIV00<0003o06IV
IP1VIVH0401VIVHE00000<80De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo5@1VIVH00`000?l0IVIV06IVIP0U06IVIQL00000Z`1CDe<50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooolF06IVIP030000o`1VIVH0IVIV03/0IVIV7`00002<05=CD`D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0IVIV00<0003o06IVIP1VIVH0F@1V
IVH/00000600De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo601VIVH0
0`000?l0IVIV06IVIP2406IVIV400000103oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo6@1VIVH00`000?l0IVIV06IVIP3S06IVIPD0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?oooaX0IVIV00<0003o06IVIP1VIVH0hP1VIVH50?ooo`4000000@3oool001D0oooo
0P0000030?oooaX0IVIV00<0003o06IVIP1VIVH0hP1VIVH40?ooo`8000000@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolK06IVIP030000o`1VIVH0IVIV0>40IVIV1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo701VIVH00`000?l0IVIV06IVIP3P06IVIPD0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?oooad0IVIV00<0003o06IVIP1VIVH0g`1VIVH50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolN06IVIP030000o`1VIVH0IVIV0=h0
IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7P1VIVH00`000?l0IVIV
06IVIP3N06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooal0IVIV00<0
003o06IVIP1VIVH0g@1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolP
06IVIP030000o`1VIVH0IVIV0=`0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo8@1VIVH00`000?l0IVIV06IVIP3K06IVIPD0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooob80IVIV00<0003o06IVIP1VIVH0fP1VIVH50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooolS06IVIP030000o`1VIVH0IVIV0=T0IVIV1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo8`1VIVH00`000?l0IVIV06IVIP3I06IVIPD0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooob@0IVIV00<0003o06IVIP1VIVH0f01VIVH5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolU000000030000o`0000000000
0=P00000103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo9P1iNGT00`000?l0
NGUi07UiN@3F07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobL0NGUi
00<0003o07UiN@1iNGT0e@1iNGT50?ooo`4000000@3oool001D0oooo0P0000030?ooobP0NGUi00<0
003o07UiN@1iNGT0e01iNGT40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolX
07UiN@030000o`1iNGT0NGUi0=@0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo:@1iNGT00`000?l0NGUi07UiN@3C07UiN@D0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooobX0NGUi00<0003o07UiN@1iNGT0dP1iNGT50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool[07UiN@030000o`1iNGT0NGUi0=40NGUi1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo;01iNGT00`000?l0NGUi07UiN@3@07UiN@D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooobd0NGUi00<0003o07UiN@1iNGT0c`1iNGT5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool]07UiN@030000o`1iNGT0NGUi
0<l0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;P1iNGT00`000?l0
NGUi07UiN@3>07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobl0NGUi
00<0003o07UiN@1iNGT0c@1iNGT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool`07UiN@030000o`1iNGT0NGUi0<`0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo<@1iNGT00`000?l0NGUi07UiN@3;07UiN@D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooc40NGUi00<0003o07UiN@1iNGT0O@1iNGU?000000@0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooc80NGUi00<0003o07UiN@1iNGT0CP1iNGT^000004h0
S8b<1@3oool100000040oooo00002P3ookl0M000000000000000001809cOo`3oool0oono07@00000
B9`20?ooo`060?noM000000000000000000007@0_ooo0`3oool00`000000oooo0?ooo`020?oooc<0
NGUi00<0003o07UiN@1iNGT0<@1iNGTL000007`0S8b<1@3oool100000040oooo00020?ooo`030?no
M018W=l0oooo00P0oooo00<0W4P00000M02oool01@3oool00`000000oooo0?ooo`020?oooc@0NGUi
00<0003o07UiN@1iNGT05P1iNGTJ000009P0S8b<1@3oool100000040oooo00020?ooo`030?noM018
W=l0oooo00T0oooo00<0okmd0000001d_ol0103oool2000000<0oooo=@1iNGT00`000?l0NGUi07Ui
N@0307UiNA800000/P2<S8`40?ooo`8000000@3oool00080oooo00<0okmd04RLg`3oool02P3oool0
0`3ookl0_koo0?ooo`030?ooo`030000003oool0oooo0080oooo:@1iNGT=000000030000o`000000
000000800000a02<S8`50?ooo`4000000@3oool000040?ooo`2LB7@0_kmd04RLg`P0oooo00H0omnL
04Q8W03oool0oono07@0M02oool30?ooo`030000003oool0oooo0080oooo701iNGT=000000d0S8b<
00<0003o08b<S02<S8`0aP2<S8`50?ooo`4000000@3oool000040?ooo`3o_g@0000004RLg`T0oooo
00@0gia8000000000000B9cO103oool00`000000oooo0?ooo`020?ooo`l0NGUi3@00000K08b<S003
0000o`2<S8`0S8b<0<D0S8b<1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
0P1iNGT=000002T0S8b<00<0003o08b<S02<S8`0a02<S8`50?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool2000003L0S8b<00<0003o08b<S02<S8`0``2<S8`50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolj08b<S0030000o`2<S8`0S8b<0<80S8b<1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo>`2<S8`00`000?l0S8b<08b<S03108b<
S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc/0S8b<00<0003o08b<S02<
S8`0`@2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oooll08b<S0030000
o`2<S8`0S8b<0<00S8b<1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo?@2<
S8`00`000?l0S8b<08b<S02o08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?oooch0S8b<00<0003o08b<S02<S8`0U02<S8`[000000@0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooocl0S8b<00<0003o08b<S02<S8`0K@2<S8`V000002X0WinO1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo?`2<S8`00`000?l0S8b<08b<S01F08b<S1L0
0000D02OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooom008b<S0030000
o`2<S8`0S8b<0400S8b<5@00001W09nOW`D0oooo0@0000010?ooo`005@3oool2000000<0oooo@@2<
S8`00`000?l0S8b<08b<S00_08b<S1000000O02OWil40?ooo`8000000@3oool001D0oooo00<00000
0?ooo`3oool00P3ooom208b<S0030000o`2<S8`0S8b<0280S8b<3000002<09nOW`D0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?oood<0S8b<00<0003o08b<S02<S8`05P2<S8`;0000
09P0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080ooooA02<S8`00`000?l0
S8b<08b<S00808b<S0d00000X`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3ooom408b<S0040000o`2<S8`0S8b<08b<S0L00000/02OWil50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooolm08b<S0P0000000<0003o000000000000]`2OWil50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolf08b<S0L000002@2OWil00`000?l0WinO09nO
W`2f09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobh0S8b<2000000A
09nOW`030000o`2OWil0WinO0;D0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo9P2<S8`8000001X0WinO00<0003o09nOW`2OWil0]02OWil50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3ooolN08b<S0P000008`2OWil00`000?l0WinO09nOW`2c09nOW`D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaT0S8b<1@00000[09nOW`030000
o`2OWil0WinO0;<0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo502<
S8`500000340WinO00<0003o09nOW`2OWil0/P2OWil50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool<08b<S0P00000=`2OWil00`000?l0WinO09nOW`2009nOWc800000103oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo1`2<S8`500000400WinO00<0003o09nO
W`2OWil0I`2OWilH00000340/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo0P2<S8`5000004H0WinO00<0003o09nOW`2OWil0E02OWilB000004T0/k>c1@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo0P00001;09nOW`030000o`2OWil0WinO04P0WinO
3000001K0;>c/`D0oooo0@0000010?ooo`005@3oool2000000<0ooooCP2OWil00`000?l0WinO09nO
W`0j09nOW`d00000I`2c/k<40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooom?
09nOW`030000o`2OWil0WinO02h0WinO2`00001d0;>c/`D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooe00WinO00<0003o09nOW`2OWil08`2OWil:000007l0/k>c1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080ooooD@2OWil00`000?l0WinO09nOW`0J09nOW`P0
0000R@2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooomB09nOW`030000
o`2OWil0WinO0180WinO1`00002A0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?oooe80WinO00<0003o09nOW`2OWil02P2OWil8000009P0/k>c1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080ooooD`2OWil010000?l0WinO09nOW`2OWil800000:00/k>c1@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080ooooDP2OWil2000000030000o`000000
00000:P0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080ooooC@2OWil50000
00<0/k>c00<0003o0;>c/`2c/k<0Y`2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooom509nOW`P000002@2c/k<00`000?l0/k>c0;>c/`2V0;>c/`D0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?oood00WinO1@00000B0;>c/`030000o`2c/k<0/k>c0:D0/k>c
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo>`2OWil5000001L0/k>c00<0
003o0;>c/`2c/k<0Y@2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolf
09nOW`D000007@2c/k<00`000?l0/k>c0;>c/`220;>c/b<00000103oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo<@2OWil5000002<0/k>c00<0003o0;>c/`2c/k<0JP2c/k<G0000
0280a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;P2OWil3000002T0
/k>c00<0003o0;>c/`2c/k<0F@2c/k<@000003T0a/K61@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo:@2OWil5000002d0/k>c00<0003o0;>c/`2c/k<0C02c/k<<000004T0a/K6
1@3oool100000040oooo000E0?ooo`8000000`3ooolS09nOW`H00000<P2c/k<00`000?l0/k>c0;>c
/`110;>c/`/00000E@36a/H40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ
09nOW`800000>@2c/k<00`000?l0/k>c0;>c/`0i0;>c/`L00000H036a/H50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolL09nOW`D00000?02c/k<00`000?l0/k>c0;>c/`0`0;>c
/`P00000I`36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolI09nOW`<0
0000@P2c/k<00`000?l0/k>c0;>c/`0W0;>c/`P00000K`36a/H50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooolG09nOW`800000AP2c/k<00`000?l0/k>c0;>c/`0N0;>c/`P00000
M`36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolB09nOW`D00000B@2c
/k<00`000?l0/k>c0;>c/`0H0;>c/`D00000O`36a/H50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool?09nOW`<00000CP2c/k<00`000?l0/k>c0;>c/`0@0;>c/`P00000Q036a/H5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool<09nOW`<00000DP2c/k<00`00
0?l0/k>c0;>c/`0:0;>c/`D00000S036a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool909nOW`<00000EP2c/k<00`000?l0/k>c0;>c/`040;>c/`D00000T@36a/H50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool509nOW`@00000FP2c/k<00`000?l00000
00000003000009H0a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0`2O
Wil2000005X0/k>c1@0000000`000?l0a/K60<K6aP2H0<K6aPD0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`<00000E`2c/k<5000000H0a/K600<0003o0<K6aP36a/H0U`36a/H5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooomG0;>c/`<000002`36a/H00`00
0?l0a/K60<K6aP2G0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooe80
/k>c1@00000?0<K6aP030000o`36a/H0a/K609H0a/K61@3oool100000040oooo00002P3ookl0M000
000000000000001809cOo`3oool0oono07@00000B9`40?ooo`040=nLB0000000001809cOo`<0oooo
00<000000?ooo`3oool00P3ooom=0;>c/`D000005@36a/H00`000?l0a/K60<K6aP1^0<K6aRP00000
103oool100000040oooo00020?ooo`030?noM018W=l0oooo00X0oooo00<0okmd04RLg`3oool00`3o
ool00`000000oooo0?ooo`020?ooodX0/k>c0`00000K0<K6aP030000o`36a/H0a/K605h0a/K63`00
000W0=WIf@D0oooo0@0000010?ooo`000P3oool00`3o_g@0B9cO0?ooo`070?ooo`060?oo_`1d0000
00000000000004P0W=oo0`3oool2000000<0ooooA@2c/k<5000001l0a/K600<0003o0<K6aP36a/H0
D036a/H=000003H0fMWI103oool200000040oooo00020?ooo`030?noM018W=l0oooo00P0oooo00@0
_g@007Boo`3o_g@0B9cO103oool00`000000oooo0?ooo`020?oood80/k>c0`00000T0<K6aP030000
o`36a/H0a/K604P0a/K6200000130=WIf@D0oooo0@0000010?ooo`0000@0oooo09a8M02o_g@0B9cO
2@3oool0103ookl0M01809bLM018W=l40?ooo`030000003oool0oooo0080oooo?`2c/k<3000002P0
a/K600<0003o0<K6aP36a/H0?P36a/H9000004/0fMWI1@3oool100000040oooo0000103oool0okmd
00000018W=l:0?ooo`030?oOW0180000B9cO00@0oooo00<000000?ooo`3oool00P3ooolk0;>c/`@0
0000;036a/H00`000?l0a/K60<K6aP0f0<K6aPL00000E03IfMT50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooolh0;>c/`<00000<@36a/H00`000?l0a/K60<K6aP0^0<K6aPL00000
F`3IfMT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolf0;>c/`800000=@36
a/H00`000?l0a/K60<K6aP0X0<K6aPD00000HP3IfMT50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolc0;>c/`<00000>036a/H00`000?l0a/K60<K6aP0O0<K6aPP00000I`3IfMT5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooola0;>c/`800000>`36a/H00`00
0?l0a/K60<K6aP0J0<K6aPD00000K`3IfMT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool^0;>c/`<00000?P36a/H00`000?l0a/K60<K6aP0C0<K6aPH00000M03IfMT50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool[0;>c/`<00000@P36a/H00`000?l0a/K6
0<K6aP0@0<K6aP800000NP3IfMT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
oolX0;>c/`<00000AP36a/H00`000?l0a/K60<K6aP0:0<K6aPD00000O03IfMT50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolV0;>c/`800000BP36a/H00`000?l0a/K60<K6aP04
0<K6aPD00000P@3IfMT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolS0;>c
/`<00000C@36a/H00`000?l0a/K60<K6aP03000008H0fMWI1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo8@2c/k<2000004h0a/K60P0000000`000?l00000000000290=WIf@D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooah0/k>c0`00001=0<K6aP<00000
0`3IfMT00`000?l0fMWI0=WIf@280=WIf@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?oooa/0/k>c0`00001;0<K6aPD000001`3IfMT00`000?l0fMWI0=WIf@270=WIf@D0oooo0@00
00010?ooo`005@3oool2000000<0oooo6@2c/k<2000004`0a/K60P00000=0=WIf@030000o`3IfMT0
fMWI08H0fMWI103oool200000040oooo000E0?ooo`030000003oool0oooo0080oooo5`2c/k<20000
04/0a/K60`00000@0=WIf@030000o`3IfMT0fMWI08D0fMWI1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo5@2c/k<2000004X0a/K60`00000D0=WIf@030000o`3IfMT0fMWI0680
fMWI8`0000040?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolC0;>c/`800000
A`36a/H5000001L0fMWI00<0003o0=WIf@3IfMT0E@3IfMT=00000280k>c/1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo4P2c/k<00`000000a/K60<K6aP150<K6aP8000007@3I
fMT00`000?l0fMWI0=WIf@1;0=WIf@T00000;`3/k>`50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool?0;>c/`<00000A@36a/H300000200fMWI00<0003o0=WIf@3IfMT0@@3IfMT9
000003P0k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3@2c/k<20000
04D0a/K60`00000T0=WIf@030000o`3IfMT0fMWI03/0fMWI1@0000110>c/k0D0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo``0/k>c00<000000<K6aP36a/H0@`36a/H2000002P0
fMWI00<0003o0=WIf@3IfMT0<P3IfMT8000004H0k>c/1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo2P2c/k<2000004<0a/K60`00000Z0=WIf@030000o`3IfMT0fMWI02d0fMWI
1@00001>0>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P0/k>c0P00
00130<K6aP800000;P3IfMT00`000?l0fMWI0=WIf@0X0=WIf@@00000D`3/k>`50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool70;>c/`0300000036a/H0a/K60400a/K60`00000a
0=WIf@030000o`3IfMT0fMWI0240fMWI1P00001G0>c/k0D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`D0/k>c0P0000110<K6aP800000=@3IfMT00`000?l0fMWI0=WIf@0M0=WI
f@<00000G@3/k>`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool30;>c/`80
0000@036a/H3000003P0fMWI00<0003o0=WIf@3IfMT05`3IfMT500000600k>c/1@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo00<0/k>c000000000000@036a/H2000003`0fMWI
00<0003o0=WIf@3IfMT04@3IfMT5000006D0k>c/1@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo00<000000<K6aP36a/H0?P36a/H2000003h0fMWI00<0003o0=WIf@3IfMT03`3I
fMT2000006X0k>c/1@3oool100000040oooo000E0?ooo`8000000`3ooom00<K6aP030000003IfMT0
fMWI03l0fMWI00<0003o0=WIf@3IfMT02`3IfMT3000006`0k>c/103oool200000040oooo000E0?oo
o`030000003oool0oooo0080oooo?@36a/H3000004<0fMWI00<0003o0=WIf@3IfMT01@3IfMT50000
06l0k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo>`36a/H2000004L0
fMWI00@0003o0=WIf@3IfMT0fMWI0`00001d0>c/k0D0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooocX0a/K600<000000=WIf@3IfMT0B03IfMT00`000?l000000000001g0>c/k0D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooocP0a/K60P0000190=WIf@800000
00<0k>c/0000o`3/k>`0M`3/k>`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
oolf0<K6aP800000B03IfMT3000000<0k>c/00<0003o0>c/k03/k>`0MP3/k>`50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooole0<K6aP030000003IfMT0fMWI04H0fMWI0P000007
0>c/k0030000o`3/k>`0k>c/07D0k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo=036a/H00`000000fMWI0=WIf@140=WIf@<000002P3/k>`00`000?l0k>c/0>c/k01d0>c/
k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc40a/K60`0000150=WIf@80
00003P3/k>`00`000?l0k>c/0>c/k01c0>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooobl0a/K60P0000150=WIf@<000004@3/k>`00`000?l0k>c/0>c/k01b0>c/k0D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobh0a/K600<000000=WIf@3IfMT0@P3I
fMT3000001@0k>c/00<0003o0>c/k03/k>`0LP3/k>`50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool/0<K6aP800000@`3IfMT2000001P0k>c/00<0003o0>c/k03/k>`0L@3/k>`5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool[0<K6aP030000003IfMT0fMWI
0440fMWI0P00000K0>c/k0030000o`3/k>`0k>c/05/0k>c/5P0000040?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3ooolY0<K6aP800000@@3IfMT3000001h0k>c/00<0003o0>c/k03/
k>`0D03/k>`:000001X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobP0a/K6
00<000000=WIf@3IfMT0@03IfMT00`000000k>c/0>c/k00P0>c/k0030000o`3/k>`0k>c/04@0k>c/
2`00000T0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolV0<K6aP800000@03I
fMT3000002@0k>c/00<0003o0>c/k03/k>`0?P3/k>`5000002l0oooo0@0000010?ooo`005@3oool2
000000<0oooo9@36a/H00`000000fMWI0=WIf@0o0=WIf@030000003/k>`0k>c/02D0k>c/00<0003o
0>c/k03/k>`0>@3/k>`5000003<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
ob@0a/K600<000000=WIf@3IfMT0?P3IfMT2000002T0k>c/00<0003o0>c/k03/k>`0<`3/k>`50000
03T0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooob<0a/K600<000000=WIf@3I
fMT0?P3IfMT00`000000k>c/0>c/k00Z0>c/k0030000o`3/k>`0k>c/02d0k>c/1@00000n0?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ0<K6aP800000?`3IfMT2000002h0k>c/
00<0003o0>c/k03/k>`0:@3/k>`3000004<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooob00a/K600<000000=WIf@3IfMT0?@3IfMT200000340k>c/00<0003o0>c/k03/k>`08`3/
k>`5000004H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooal0a/K600<00000
0=WIf@3IfMT0?@3IfMT00`000000k>c/0>c/k00b0>c/k0030000o`3/k>`0k>c/01l0k>c/0`00001;
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolO0<K6aP030000003IfMT0fMWI
03/0fMWI0P00000e0>c/k0030000o`3/k>`0k>c/01d0k>c/0P00001>0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3ooolM0<K6aP800000?@3IfMT00`000000k>c/0>c/k00f0>c/k003
0000o`3/k>`0k>c/01T0k>c/0`00001@0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolL0<K6aP030000003IfMT0fMWI03/0fMWI0P00000j0>c/k0030000o`3/k>`0k>c/01<0k>c/
1@00001C0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolK0<K6aP030000003I
fMT0fMWI03/0fMWI00<000000>c/k03/k>`0>`3/k>`00`000?l0k>c/0>c/k00@0>c/k0800000F03o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo6`36a/H00`000000fMWI0=WIf@0j
0=WIf@030000003/k>`0k>c/03d0k>c/00<0003o0>c/k03/k>`03@3/k>`3000005T0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?oooaX0a/K600<000000=WIf@3IfMT0>@3IfMT20000
0400k>c/00<0003o0>c/k03/k>`02`3/k>`2000005`0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?oooaP0a/K60P00000k0=WIf@030000003/k>`0k>c/0440k>c/00<0003o0>c/k03/
k>`0203/k>`2000005h0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0a/K6
00<000000=WIf@3IfMT0>@3IfMT2000004D0k>c/00<0003o0>c/k03/k>`01@3/k>`200000600oooo
0@0000010?ooo`0000X0oono07@00000000000000000B02Lgol0oooo0?oo_`1d000004RL0`3oool0
1@3ookl0M0000000000004P0W=oo00<0oooo00<000000?ooo`3oool00P3ooolF0<K6aP030000003I
fMT0fMWI03T0fMWI00<000000>c/k03/k>`0AP3/k>`00`000?l0k>c/0>c/k0020>c/k0800000HP3o
ool100000040oooo00020?ooo`030?noM018W=l0oooo00P0oooo00D0_g@007Boo`3oool0oono0;no
o`030?ooo`030000003oool0oooo0080oooo5P36a/H00`000000fMWI0=WIf@0i0=WIf@030000003/
k>`0k>c/04L0k>c/00@0003o0000000000000000I03oool100000040oooo00020?ooo`030?noM018
W=l0oooo00L0oooo00H0oono07@00018W=l0oooo0=nLB01d_ol30?ooo`8000000`3ooolE0<K6aP03
0000003IfMT0fMWI03T0fMWI00<000000>c/k03/k>`0B03/k>`00`000000003o0?ooo`1T0?ooo`80
00000@3oool00080oooo00<0okmd04RLg`3oool0203oool0102LB7@0B4P000000000B9`40?ooo`03
0000003oool0oooo0080oooo5036a/H00`000000fMWI0=WIf@0h0=WIf@800000B@3/k>`200000003
0?ooo`000?l0oooo06D0oooo0@0000010?ooo`0000@0oooo09a8M02o_g@0B9cO2@3oool00`3o_g@0
04RL0?ooo`050?ooo`030000003oool0oooo0080oooo4`36a/H00`000000fMWI0=WIf@0h0=WIf@03
0000003/k>`0k>c/04P0k>c/00<000000?ooo`3oool00P3oool00`000?l0oooo0?ooo`1S0?ooo`40
00000@3oool000040?ooo`3o_g@0000004RLg`X0oooo00@0gia8000000000000M;oo0`3oool00`00
0000oooo0?ooo`020?oooa<0a/K600<000000=WIf@3IfMT0=`3IfMT00`000000k>c/0>c/k0180>c/
k0030000003oool0oooo00@0oooo00<0003o0?ooo`3oool0HP3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo4P36a/H00`000000fMWI0=WIf@0h0=WIf@030000003/k>`0k>c/04H0
k>c/0P0000080?ooo`030000o`3oool0oooo0640oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooa40a/K600<000000=WIf@3IfMT0>03IfMT00`000000k>c/0>c/k0150>c/k0800000
2`3oool00`000?l0oooo0?ooo`1P0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
oolA0<K6aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0A@3/k>`00`000000oooo0?oo
o`0<0?ooo`030000o`3oool0oooo05l0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?oooa00a/K600<000000=WIf@3IfMT0=`3IfMT00`000000k>c/0>c/k0150>c/k08000003P3oool0
0`000?l0oooo0?ooo`1O0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool?0<K6
aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0A03/k>`200000140oooo00<0003o0?oo
o`3oool0GP3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3`36a/H00`000000
fMWI0=WIf@0g0=WIf@030000003/k>`0k>c/04@0k>c/00<000000?ooo`3oool04@3oool00`000?l0
oooo0?ooo`1M0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool>0<K6aP030000
003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0A03/k>`00`000000oooo0?ooo`0C0?ooo`030000
o`3oool0oooo05`0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h0a/K600<0
00000=WIf@3IfMT0=P3IfMT00`000000k>c/0>c/k0140>c/k0030000003oool0oooo01D0oooo00<0
003o0?ooo`3oool0F`3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3@36a/H0
0`000000fMWI0=WIf@0g0=WIf@030000003/k>`0k>c/04<0k>c/00<000000?ooo`3oool05P3oool0
0`000?l0oooo0?ooo`1K0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool=0<K6
aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0@`3/k>`00`000000oooo0?ooo`0H0?oo
o`030000o`3oool0oooo05X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo``0
a/K600<000000=WIf@3IfMT0=P3IfMT2000004@0k>c/00<000000?ooo`3oool06P3oool00`000?l0
oooo0?ooo`1I0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool<0<K6aP030000
003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0L0?ooo`030000
o`3oool0oooo05P0oooo0@0000010?ooo`005@3oool2000000<0oooo2`36a/H00`000000fMWI0=WI
f@0f0=WIf@030000003/k>`0k>c/04<0k>c/00<000000?ooo`3oool07@3oool00`000?l0oooo0?oo
o`1F0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3oool;0<K6aP030000003IfMT0
fMWI03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0O0?ooo`030000o`3oool0
oooo05H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0a/K600<000000=WI
f@3IfMT0=P3IfMT00`000000k>c/0>c/k0130>c/k0030000003oool0oooo01l0oooo00<0003o0?oo
o`3oool0A@3oool6000000/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0
a/K600<000000=WIf@3IfMT0=P3IfMT00`000000k>c/0>c/k0120>c/k0030000003oool0oooo0240
oooo00<0003o0?ooo`3oool0@`3oool8000000@0oooo0`00ool30?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool:0<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0
@P3/k>`00`000000oooo0?ooo`0R0?ooo`030000o`3oool0oooo0440oooo0`000003003oo`@00000
00<0oooo003oo`00ool00P3o0003003oo`40oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`X0a/K600<000000=WIf@3IfMT0=@3IfMT00`000000k>c/0>c/k0120>c/k0030000003o
ool0oooo02@0oooo00<0003o0?ooo`3oool0?`3oool2000000<00?oo0P3o0002003oo`80000000<0
0?oo0?l0003o0000103o0002003oo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool:
0<K6aP030000003IfMT0fMWI03D0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0U
0?ooo`030000o`3oool0oooo03d0oooo0P000002003oo`H0o`0000<00?oo00000000ool00P3o0003
003o00040?l00000ool00?oo00000040oooo000E0?ooo`030000003oool0oooo0080oooo2P36a/H0
0`000000fMWI0=WIf@0e0=WIf@030000003/k>`0k>c/0480k>c/00<000000?ooo`3oool09P3oool0
0`000?l0oooo0?ooo`0l0?ooo`8000000P00ool0103o00000?l0003o0000o`020?l000800?oo0P3o
0002003o00060000o`00o`000?l00?l00000ool000000@3oool001D0oooo00<000000?ooo`3oool0
0P3oool90<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0@@3/k>`00`000000oooo
0?ooo`0W0?ooo`030000o`3oool0oooo03`0oooo00@00000003oo`00ool0o`000P00o`000`000?l0
0?l0003o00020?l00003003oo`000?l0003o00@0003o00@00?l00?l00000ool000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool90<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/
k>`0@@3/k>`00`000000oooo0?ooo`0X0?ooo`030000o`3oool0oooo03/0oooo00D00000003oo`00
ool0o`00003o00070000o`03003oo`3o00000?l00080003o0P00o`02003oo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool90<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/
k>`0@@3/k>`00`000000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo03X0oooo00@00000003oo`00
ool0o`000P00o`000`000?l00?l0003o00020?l000800?oo00<0o`000000o`00o`000P00o`00103o
00000?oo003oo`0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0a/K600<000000=WI
f@3IfMT0=P3IfMT00`000000k>c/0>c/k0110>c/k0030000003oool0oooo02X0oooo00<0003o0?oo
o`3oool0>@3oool2000000800?oo00@0o`00003o0000o`000?l00P3o00001@00ool00000003oo`00
0?l00?oo0080o`001000ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2@36a/H0
0`000000fMWI0=WIf@0f0=WIf@030000003/k>`0k>c/0440k>c/00<000000?ooo`3oool0:`3oool0
0`000?l0oooo0?ooo`0i0?ooo`0300000000ool00?oo00H0o`0000<00?oo000000000?l01`00ool1
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6aP030000003IfMT0fMWI
03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0/0?ooo`030000o`3oool0oooo
03T0oooo00@00000003oo`00ool00?oo0P3o0002003oo`03000000000?l0oooo0080oooo0`00ool3
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6aP030000003IfMT0fMWI
03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0/0?ooo`030000o`3oool0oooo
03X0oooo0P000003003oo`80000000<0003o0?ooo`3oool0203oool100000040oooo000E0?ooo`80
00000`3oool80<K6aP030000003IfMT0fMWI03H0fMWI00<000000>c/k03/k>`0@P3/k>`00`000000
oooo0?ooo`0]0?ooo`030000o`3oool0oooo03X0oooo1@0000000`000?l0oooo0?ooo`080?ooo`80
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6aP030000003IfMT0fMWI03L0fMWI
00<000000>c/k03/k>`0@P3/k>`00`000000oooo0?ooo`0]0?ooo`030000o`3oool0oooo03d0oooo
00<0003o0?ooo`3oool02P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2036
a/H00`000000fMWI0=WIf@0g0=WIf@030000003/k>`0k>c/0480k>c/00<000000?ooo`3oool0;P3o
ool00`000?l0oooo0?ooo`0k0?ooo`030000o`3oool0oooo00/0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`P0a/K600<000000=WIf@3IfMT0=`3IfMT00`000000k>c/0>c/k013
0>c/k0030000003oool0oooo02h0oooo00<0003o0?ooo`3oool0>@3oool00`000?l0oooo0?ooo`0<
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6aP030000003IfMT0fMWI
03L0fMWI00<000000>c/k03/k>`0@`3/k>`00`000000oooo0?ooo`0^0?ooo`030000o`3oool0oooo
03L0oooo0P000?l?0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80<K6aP03
0000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0@`3/k>`00`000000oooo0?ooo`0_0?ooo`03
0000o`3oool0oooo03D0oooo00<0003o0?ooo`3oool03`3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo2@36a/H00`000000fMWI0=WIf@0g0=WIf@030000003/k>`0k>c/04<0k>c/
00<000000?ooo`3oool0;`3oool00`000?l0oooo0?ooo`0c0?ooo`030000o`3oool0oooo0100oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0a/K600<000000=WIf@3IfMT0=`3I
fMT00`000000k>c/0>c/k0140>c/k0030000003oool0oooo02l0oooo00<0003o0?ooo`3oool0<@3o
ool00`000?l0oooo0?ooo`0A0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool9
0<K6aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0A03/k>`00`000000oooo0?ooo`0`
0?ooo`030000o`3oool0oooo02l0oooo00<0003o0?ooo`3oool04P3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo2@36a/H00`000000fMWI0=WIf@0g0=WIf@030000003/k>`0k>c/
04D0k>c/00<000000?ooo`3oool0<03oool00`000?l0oooo0?ooo`0]0?ooo`030000o`3oool0oooo
01<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0a/K600<000000=WIf@3I
fMT0>03IfMT00`000000k>c/0>c/k0150>c/k0030000003oool0oooo02l0oooo00<0003o0?ooo`3o
ool0;03oool00`000?l0oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3oool:0<K6aP030000003IfMT0fMWI03L0fMWI00<000000>c/k03/k>`0A@3/k>`00`000000oooo
0?ooo`0`0?ooo`030000o`3oool0oooo02X0oooo00<0003o0?ooo`3oool05@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo2P36a/H00`000000fMWI0=WIf@0h0=WIf@030000003/
k>`0k>c/04D0k>c/0P00000a0?ooo`030000o`3oool0oooo02P0oooo00<0003o0?ooo`3oool05P3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2P36a/H00`000000fMWI0=WIf@0h
0=WIf@030000003/k>`0k>c/04L0k>c/00<000000?ooo`3oool0;`3oool00`000?l0oooo0?ooo`0V
0?ooo`030000o`3oool0oooo01L0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`/0a/K600<000000=WIf@3IfMT0>03IfMT00`000000k>c/0>c/k0170>c/k0030000003oool0oooo
02l0oooo00<0003o0?ooo`3oool0903oool00`000?l0oooo0?ooo`0H0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool;0<K6aP030000003IfMT0fMWI03T0fMWI00<000000>c/k03/
k>`0A`3/k>`200000300oooo00<0003o0?ooo`3oool08P3oool00`000?l0oooo0?ooo`0I0?ooo`40
00000@3oool001D0oooo0P0000030?ooo``0a/K600<000000=WIf@3IfMT0>03IfMT00`000000k>c/
0>c/k0190>c/k0030000003oool0oooo02d0oooo00<0003o0?ooo`3oool08@3oool00`000?l0oooo
0?ooo`0I0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3oool<0<K6aP030000003I
fMT0fMWI03T0fMWI00<000000>c/k03/k>`0B@3/k>`00`000000oooo0?ooo`0]0?ooo`030000o`3o
ool0oooo01l0oooo00<0003o0?ooo`3oool06`3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo3036a/H00`000000fMWI0=WIf@0j0=WIf@030000003/k>`0k>c/04T0k>c/0P00000^
0?ooo`030000o`3oool0oooo01d0oooo00<0003o0?ooo`3oool0703oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo3@36a/H00`000000fMWI0=WIf@0j0=WIf@030000003/k>`0k>c/
04X0k>c/0P00000]0?ooo`030000o`3oool0oooo01/0oooo00<0003o0?ooo`3oool07@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo3@36a/H00`000000fMWI0=WIf@0k0=WIf@03
0000003/k>`0k>c/04X0k>c/0P00000]0?ooo`030000o`3oool0oooo01T0oooo00<0003o0?ooo`3o
ool07P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3P36a/H00`000000fMWI
0=WIf@0j0=WIf@030000003/k>`0k>c/04`0k>c/0P00000[0?ooo`030000o`3oool0oooo01P0oooo
00<0003o0?ooo`3oool07`3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3P36
a/H00`000000fMWI0=WIf@0k0=WIf@030000003/k>`0k>c/04d0k>c/0`00000Y0?ooo`030000o`3o
ool0oooo01H0oooo00<0003o0?ooo`3oool0803oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo3`36a/H00`000000fMWI0=WIf@0k0=WIf@030000003/k>`0k>c/04l0k>c/0P00000X
0?ooo`030000o`3oool0oooo01@0oooo00<0003o0?ooo`3oool08@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo3`36a/H00`000000fMWI0=WIf@0l0=WIf@030000003/k>`0k>c/
0500k>c/0P00000W0?ooo`030000o`3oool0oooo0180oooo00<0003o0?ooo`3oool08P3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo4036a/H00`000000fMWI0=WIf@0l0=WIf@80
0000D@3/k>`5000002@0oooo00<0003o0?ooo`3oool03`3oool20000obD0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?oooa40a/K600<000000=WIf@3IfMT0?@3IfMT00`000000k>c/
0>c/k01C0>c/k08000008`3oool00`000?l0oooo0?ooo`0=0?ooo`030000o`3oool0oooo02D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa80a/K600<000000=WIf@3IfMT0?@3I
fMT00`000000k>c/0>c/k01D0>c/k0<00000803oool00`000?l0oooo0?ooo`0<0?ooo`030000o`3o
ool0oooo02H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa<0a/K600<00000
0=WIf@3IfMT0?@3IfMT2000005L0k>c/0P00000O0?ooo`030000o`3oool0oooo00X0oooo00<0003o
0?ooo`3oool09`3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo4`36a/H00`00
0000fMWI0=WIf@0o0=WIf@030000003/k>`0k>c/05H0k>c/1@00000K0?ooo`030000o`3oool0oooo
00P0oooo00<0003o0?ooo`3oool0:03oool100000040oooo00002P3ookl0M0000000000000000018
09cOo`3oool0oono07@00000B9`30?ooo`040;md00000000000004RLg`@0oooo00<000000?ooo`3o
ool00P3ooolD0<K6aP800000@03IfMT00`000000k>c/0>c/k01J0>c/k0<000006@3oool00`000?l0
oooo0?ooo`03003oo`<0oooo00<0003o0?ooo`3oool0:@3oool100000040oooo00020?ooo`030?no
M018W=l0oooo00L0oooo00D0oono07Ad_`3oool0oooo09adW0040?ooo`030000003oool0oooo0080
oooo5P36a/H00`000000fMWI0=WIf@0n0=WIf@800000G@3/k>`5000001D0oooo00<0003o003oo`00
ool01000ool00`000?l0oooo0?ooo`0Z0?ooo`4000000@3oool00080oooo00<0okmd04RLg`3oool0
203oool0102LM9`0oooo0?oo_`1dM;l40?ooo`8000000`3ooolG0<K6aP030000003IfMT0fMWI03l0
fMWI0P00001P0>c/k0D000003`3oool2003oo`030000o`3o0000o`0000800?oo00<0003o003oo`3o
ool0:P3oool200000040oooo00020?ooo`030?noM018W=l0oooo00P0oooo00@0_g@0000000000000
B9cO103oool00`000000oooo0?ooo`020?oooaP0a/K600<000000=WIf@3IfMT0?`3IfMT2000006@0
k>c/1P0000090?ooo`03003oo`3o0000003o00<00?l000<0003o003oo`00ool0;03oool100000040
oooo0000103oool0W4Qd0;noM018W=l80?ooo`050?oo_`1dB9`0oooo0?oo_`1dB9`0103oool00`00
0000oooo0?ooo`020?oooaT0a/K600<000000=WIf@3IfMT0@03IfMT2000006P0k>c/1`0000001@3o
ool00?oo003oo`3o00000?l000<0003o00@00?l0003oo`00ool00?oo:`3oool100000040oooo0000
103oool0okmd00000018W=l90?ooo`040=nLB0000000000007Boo`@0oooo00<000000?ooo`3oool0
0P3ooolJ0<K6aP030000003IfMT0fMWI0440fMWI00<000000>c/k03/k>`0K03/k>`01@0000000?oo
0?l0003o00000?l000<0003o00@00?l00?l00000ool00?oo:`3oool100000040oooo000E0?ooo`03
0000003oool0oooo0=00oooo00<00?oo0?l0003o00000P00o`0010000?l00?l0003o003o0002003o
ob/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`3A0?ooo`03003oo`3o0000o`0000<0
0?l000<0o`00003oo`00ool0;03oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo03l0oooo
00<000000?ooo`3oool0203oool00`00ool0o`000?l000040?l000800?oo;03oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3oool2003oo`80o`000`00
ool70?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`4000000@3oool001D0ooooe`000003003ooc0000000@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {0.959468, 0.930319, 0.00153372, \
0.00316842}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-1.999999999629905`\), {x \[Rule] 1.3763811859526882`, 
            y \[Rule] 1.6786711835273482`}}\), 
        ",", \({"Steps" \[Rule] 4, "Function" \[Rule] 89, 
          "Gradient" \[Rule] 26, "Hessian" \[Rule] 5}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  "When the gradient and Hessian are both computed using finite differences, \
the error in the Hessian may be quite large and it may be better to use a \
different method. In this case, ",
  StyleBox["FindMinimum", "MR"],
  " does find the minimum quite accurately, but cannot be sure because of \
inadequate derivative information. Also, the number of function and gradient \
evaluations is much greater than in the example with the symbolic derivatives \
computed automatically because extra evaluations are required to approximate \
the gradient and Hessian, respectively. "
}], "Text"],

Cell[TextData[{
  "If it is possible to supply the gradient (or the function is such that it \
can be computed automatically), the method will typically work much better. \
You can give the gradient using the ",
  StyleBox["Gradient", "MR"],
  " option.  A later ",
  ButtonBox["section",
    ButtonData:>"Derivatives",
    ButtonStyle->"Hyperlink"],
  " describes in some detail the options you can use for specifying \
derivatives."
}], "Text"],

Cell[TextData[{
  "This defines a function that returns the gradient for numerical values of \
",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[x_?NumberQ, \ y_?NumberQ]\  = \ 
      Map[D[Cos[x^2\  - \ 3\ y]\  + \ Sin[x^2\  + \ y^2], \ #] &, {x, 
          y}]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({2\ x\ Cos[x\^2 + y\^2] - 2\ x\ Sin[x\^2 - 3\ y], 
      2\ y\ Cos[x\^2 + y\^2] + 3\ Sin[x\^2 - 3\ y]}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["FindMinimum", "MR"],
  " to use the supplied gradient",
  ". ",
  "The Hessian is computed using finite differences of the gradient."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[f[x, y], \ {{x, 1}, {y, 1}}, \ Gradient \[Rule] g[x, y], \ 
      Method \[Rule] "\<Newton\>"]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({\(-2.`\), {x \[Rule] 1.376384972406551`, 
        y \[Rule] 1.67867608195212`}}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell["\<\
If you can provide a program which gives the Hessian, you can \
provide this also. Because the Hessian is only used by Newton\
\[CloseCurlyQuote]s method, it is given as a method option of Newton.\
\>", \
"Text"],

Cell["\<\
This defines a function which returns the Hessian for numerical \
values of x and y.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(h[x_?NumberQ, \ y_?NumberQ]\  = \ 
      Outer[D[Cos[x^2\  - \ 3\ y]\  + \ Sin[x^2\  + \ y^2], ##] &, {x, 
          y}, {x, y}]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({{\(-4\)\ x\^2\ Cos[x\^2 - 3\ y] + 2\ Cos[x\^2 + y\^2] - 
          2\ Sin[x\^2 - 3\ y] - 4\ x\^2\ Sin[x\^2 + y\^2], 
        6\ x\ Cos[x\^2 - 3\ y] - 
          4\ x\ y\ Sin[x\^2 + y\^2]}, {6\ x\ Cos[x\^2 - 3\ y] - 
          4\ x\ y\ Sin[x\^2 + y\^2], \(-9\)\ Cos[x\^2 - 3\ y] + 
          2\ Cos[x\^2 + y\^2] - 4\ y\^2\ Sin[x\^2 + y\^2]}}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["FindMinimum", "MR"],
  " to use the supplied gradient and Hessian."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[f[x, y], \ {{x, 1}, {y, 1}}, \ Gradient \[Rule] g[x, y], \ 
      Method \[Rule] {"\<Newton\>", \ Hessian \[Rule] h[x, y]}]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    \({\(-2.`\), {x \[Rule] 1.3763849724065496`, 
        y \[Rule] 1.6786760819521203`}}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell["\<\
In principle, Newton\[CloseCurlyQuote]s method uses the Hessian \
computed either by evaluating the symbolic derivative or by using finite \
differences. However, the convergence for the method computed this way \
depends on the function being convex, in which case the Hessian is always \
positive definite. However, it is common that a search will start at a \
location where this condition is violated.\
\>", "Text"],

Cell["\<\
Here is an example where the search starts near a local \
maximum.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[
      Cos[x^2\  - \ 3\ y]\  + \ Sin[x^2\  + \ y^2], {{x, 1.2}, {y,  .5}}, \ 
      Method -> "\<Newton\>"]\)], "Input",
  CellLabel->"In[8]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.32839 2.78968 -0.268265 0.574992 [
[.01923 -0.0125 -9 -9 ]
[.01923 -0.0125 9 0 ]
[.15871 -0.0125 -12 -9 ]
[.15871 -0.0125 12 0 ]
[.2982 -0.0125 -9 -9 ]
[.2982 -0.0125 9 0 ]
[.43768 -0.0125 -12 -9 ]
[.43768 -0.0125 12 0 ]
[.57717 -0.0125 -9 -9 ]
[.57717 -0.0125 9 0 ]
[.71665 -0.0125 -12 -9 ]
[.71665 -0.0125 12 0 ]
[.85614 -0.0125 -9 -9 ]
[.85614 -0.0125 9 0 ]
[.99562 -0.0125 -12 -9 ]
[.99562 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -18 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16298 -24 -4.5 ]
[-0.0125 .16298 0 4.5 ]
[-0.0125 .30673 -6 -4.5 ]
[-0.0125 .30673 0 4.5 ]
[-0.0125 .45047 -24 -4.5 ]
[-0.0125 .45047 0 4.5 ]
[-0.0125 .59422 -18 -4.5 ]
[-0.0125 .59422 0 4.5 ]
[-0.0125 .73797 -24 -4.5 ]
[-0.0125 .73797 0 4.5 ]
[-0.0125 .88172 -6 -4.5 ]
[-0.0125 .88172 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(1.2)] .01923 -0.0125 0 1 Mshowa
.15871 0 m
.15871 .00625 L
s
[(1.25)] .15871 -0.0125 0 1 Mshowa
.2982 0 m
.2982 .00625 L
s
[(1.3)] .2982 -0.0125 0 1 Mshowa
.43768 0 m
.43768 .00625 L
s
[(1.35)] .43768 -0.0125 0 1 Mshowa
.57717 0 m
.57717 .00625 L
s
[(1.4)] .57717 -0.0125 0 1 Mshowa
.71665 0 m
.71665 .00625 L
s
[(1.45)] .71665 -0.0125 0 1 Mshowa
.85614 0 m
.85614 .00625 L
s
[(1.5)] .85614 -0.0125 0 1 Mshowa
.99562 0 m
.99562 .00625 L
s
[(1.55)] .99562 -0.0125 0 1 Mshowa
.125 Mabswid
.04713 0 m
.04713 .00375 L
s
.07502 0 m
.07502 .00375 L
s
.10292 0 m
.10292 .00375 L
s
.13082 0 m
.13082 .00375 L
s
.18661 0 m
.18661 .00375 L
s
.21451 0 m
.21451 .00375 L
s
.24241 0 m
.24241 .00375 L
s
.2703 0 m
.2703 .00375 L
s
.3261 0 m
.3261 .00375 L
s
.35399 0 m
.35399 .00375 L
s
.38189 0 m
.38189 .00375 L
s
.40979 0 m
.40979 .00375 L
s
.46558 0 m
.46558 .00375 L
s
.49348 0 m
.49348 .00375 L
s
.52137 0 m
.52137 .00375 L
s
.54927 0 m
.54927 .00375 L
s
.60506 0 m
.60506 .00375 L
s
.63296 0 m
.63296 .00375 L
s
.66086 0 m
.66086 .00375 L
s
.68875 0 m
.68875 .00375 L
s
.74455 0 m
.74455 .00375 L
s
.77245 0 m
.77245 .00375 L
s
.80034 0 m
.80034 .00375 L
s
.82824 0 m
.82824 .00375 L
s
.88403 0 m
.88403 .00375 L
s
.91193 0 m
.91193 .00375 L
s
.93983 0 m
.93983 .00375 L
s
.96772 0 m
.96772 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0.5)] -0.0125 .01923 1 0 Mshowa
0 .16298 m
.00625 .16298 L
s
[(0.75)] -0.0125 .16298 1 0 Mshowa
0 .30673 m
.00625 .30673 L
s
[(1)] -0.0125 .30673 1 0 Mshowa
0 .45047 m
.00625 .45047 L
s
[(1.25)] -0.0125 .45047 1 0 Mshowa
0 .59422 m
.00625 .59422 L
s
[(1.5)] -0.0125 .59422 1 0 Mshowa
0 .73797 m
.00625 .73797 L
s
[(1.75)] -0.0125 .73797 1 0 Mshowa
0 .88172 m
.00625 .88172 L
s
[(2)] -0.0125 .88172 1 0 Mshowa
.125 Mabswid
0 .04798 m
.00375 .04798 L
s
0 .07673 m
.00375 .07673 L
s
0 .10548 m
.00375 .10548 L
s
0 .13423 m
.00375 .13423 L
s
0 .19173 m
.00375 .19173 L
s
0 .22048 m
.00375 .22048 L
s
0 .24923 m
.00375 .24923 L
s
0 .27798 m
.00375 .27798 L
s
0 .33548 m
.00375 .33548 L
s
0 .36423 m
.00375 .36423 L
s
0 .39298 m
.00375 .39298 L
s
0 .42172 m
.00375 .42172 L
s
0 .47922 m
.00375 .47922 L
s
0 .50797 m
.00375 .50797 L
s
0 .53672 m
.00375 .53672 L
s
0 .56547 m
.00375 .56547 L
s
0 .62297 m
.00375 .62297 L
s
0 .65172 m
.00375 .65172 L
s
0 .68047 m
.00375 .68047 L
s
0 .70922 m
.00375 .70922 L
s
0 .76672 m
.00375 .76672 L
s
0 .79547 m
.00375 .79547 L
s
0 .82422 m
.00375 .82422 L
s
0 .85297 m
.00375 .85297 L
s
0 .91047 m
.00375 .91047 L
s
0 .93922 m
.00375 .93922 L
s
0 .96797 m
.00375 .96797 L
s
0 .99672 m
.00375 .99672 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.15871 .99375 m
.15871 1 L
s
.2982 .99375 m
.2982 1 L
s
.43768 .99375 m
.43768 1 L
s
.57717 .99375 m
.57717 1 L
s
.71665 .99375 m
.71665 1 L
s
.85614 .99375 m
.85614 1 L
s
.99562 .99375 m
.99562 1 L
s
.125 Mabswid
.04713 .99625 m
.04713 1 L
s
.07502 .99625 m
.07502 1 L
s
.10292 .99625 m
.10292 1 L
s
.13082 .99625 m
.13082 1 L
s
.18661 .99625 m
.18661 1 L
s
.21451 .99625 m
.21451 1 L
s
.24241 .99625 m
.24241 1 L
s
.2703 .99625 m
.2703 1 L
s
.3261 .99625 m
.3261 1 L
s
.35399 .99625 m
.35399 1 L
s
.38189 .99625 m
.38189 1 L
s
.40979 .99625 m
.40979 1 L
s
.46558 .99625 m
.46558 1 L
s
.49348 .99625 m
.49348 1 L
s
.52137 .99625 m
.52137 1 L
s
.54927 .99625 m
.54927 1 L
s
.60506 .99625 m
.60506 1 L
s
.63296 .99625 m
.63296 1 L
s
.66086 .99625 m
.66086 1 L
s
.68875 .99625 m
.68875 1 L
s
.74455 .99625 m
.74455 1 L
s
.77245 .99625 m
.77245 1 L
s
.80034 .99625 m
.80034 1 L
s
.82824 .99625 m
.82824 1 L
s
.88403 .99625 m
.88403 1 L
s
.91193 .99625 m
.91193 1 L
s
.93983 .99625 m
.93983 1 L
s
.96772 .99625 m
.96772 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16298 m
1 .16298 L
s
.99375 .30673 m
1 .30673 L
s
.99375 .45047 m
1 .45047 L
s
.99375 .59422 m
1 .59422 L
s
.99375 .73797 m
1 .73797 L
s
.99375 .88172 m
1 .88172 L
s
.125 Mabswid
.99625 .04798 m
1 .04798 L
s
.99625 .07673 m
1 .07673 L
s
.99625 .10548 m
1 .10548 L
s
.99625 .13423 m
1 .13423 L
s
.99625 .19173 m
1 .19173 L
s
.99625 .22048 m
1 .22048 L
s
.99625 .24923 m
1 .24923 L
s
.99625 .27798 m
1 .27798 L
s
.99625 .33548 m
1 .33548 L
s
.99625 .36423 m
1 .36423 L
s
.99625 .39298 m
1 .39298 L
s
.99625 .42172 m
1 .42172 L
s
.99625 .47922 m
1 .47922 L
s
.99625 .50797 m
1 .50797 L
s
.99625 .53672 m
1 .53672 L
s
.99625 .56547 m
1 .56547 L
s
.99625 .62297 m
1 .62297 L
s
.99625 .65172 m
1 .65172 L
s
.99625 .68047 m
1 .68047 L
s
.99625 .70922 m
1 .70922 L
s
.99625 .76672 m
1 .76672 L
s
.99625 .79547 m
1 .79547 L
s
.99625 .82422 m
1 .82422 L
s
.99625 .85297 m
1 .85297 L
s
.99625 .91047 m
1 .91047 L
s
.99625 .93922 m
1 .93922 L
s
.99625 .96797 m
1 .96797 L
s
.99625 .99672 m
1 .99672 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.4 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.475 g
.01923 .26832 m
.02894 .26867 L
.03866 .269 L
.04837 .26932 L
.05808 .26964 L
.06779 .26994 L
.07751 .27024 L
.08722 .27053 L
.09693 .27081 L
.10664 .27107 L
.11636 .27133 L
.12607 .27158 L
.13304 .27176 L
.13578 .27182 L
.14549 .27205 L
.15521 .27228 L
.16492 .27249 L
.17463 .27269 L
.18434 .27288 L
.19406 .27307 L
.20377 .27324 L
.21348 .27341 L
.22319 .27356 L
.23291 .27371 L
.24262 .27385 L
.25233 .27397 L
.26204 .27409 L
.27176 .2742 L
.28147 .27429 L
.29118 .27438 L
.30089 .27446 L
.31061 .27453 L
.32032 .27458 L
.33003 .27463 L
.33974 .27467 L
.34946 .27469 L
.35917 .27471 L
.36888 .27471 L
.37859 .27471 L
.38831 .27469 L
.39802 .27466 L
.40773 .27462 L
.41744 .27457 L
.42716 .27451 L
.43687 .27444 L
.44658 .27435 L
.45629 .27425 L
.46601 .27414 L
.47572 .27402 L
.48543 .27389 L
.49514 .27374 L
.50486 .27358 L
.51457 .27341 L
.52428 .27322 L
.53399 .27302 L
.54371 .2728 L
.55342 .27257 L
.56313 .27233 L
.57284 .27207 L
.58256 .27179 L
.58384 .27176 L
.59227 .2715 L
.60198 .2712 L
.61169 .27087 L
.62141 .27053 L
.63112 .27017 L
.64083 .2698 L
.65054 .26941 L
.66026 .26899 L
.66997 .26856 L
.67968 .26811 L
.68939 .26763 L
.69911 .26714 L
.70882 .26662 L
.71853 .26608 L
.72824 .26552 L
.73796 .26493 L
.74767 .26432 L
.75738 .26368 L
.76709 .26301 L
.77681 .26232 L
.78055 .26204 L
.78652 .2616 L
.79623 .26084 L
.80594 .26005 L
.81566 .25923 L
.82537 .25838 L
.83508 .25748 L
.84479 .25655 L
.85451 .25558 L
.86422 .25457 L
.87393 .25351 L
.88364 .2524 L
.88424 .25233 L
.89336 .25124 L
.90307 .25004 L
.91278 .24877 L
.92249 .24744 L
.93221 .24605 L
.94192 .2446 L
.95163 .24306 L
.95437 .24262 L
.96134 .24146 L
.97106 .23976 L
.98077 .23797 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .26832 m
.02894 .26867 L
.03866 .269 L
.04837 .26932 L
.05808 .26964 L
.06779 .26994 L
.07751 .27024 L
.08722 .27053 L
.09693 .27081 L
.10664 .27107 L
.11636 .27133 L
.12607 .27158 L
.13304 .27176 L
.13578 .27182 L
.14549 .27205 L
.15521 .27228 L
.16492 .27249 L
.17463 .27269 L
.18434 .27288 L
.19406 .27307 L
.20377 .27324 L
.21348 .27341 L
.22319 .27356 L
.23291 .27371 L
.24262 .27385 L
.25233 .27397 L
.26204 .27409 L
.27176 .2742 L
.28147 .27429 L
.29118 .27438 L
.30089 .27446 L
.31061 .27453 L
.32032 .27458 L
.33003 .27463 L
.33974 .27467 L
.34946 .27469 L
.35917 .27471 L
.36888 .27471 L
.37859 .27471 L
.38831 .27469 L
.39802 .27466 L
.40773 .27462 L
.41744 .27457 L
.42716 .27451 L
.43687 .27444 L
.44658 .27435 L
.45629 .27425 L
.46601 .27414 L
.47572 .27402 L
.48543 .27389 L
Mistroke
.49514 .27374 L
.50486 .27358 L
.51457 .27341 L
.52428 .27322 L
.53399 .27302 L
.54371 .2728 L
.55342 .27257 L
.56313 .27233 L
.57284 .27207 L
.58256 .27179 L
.58384 .27176 L
.59227 .2715 L
.60198 .2712 L
.61169 .27087 L
.62141 .27053 L
.63112 .27017 L
.64083 .2698 L
.65054 .26941 L
.66026 .26899 L
.66997 .26856 L
.67968 .26811 L
.68939 .26763 L
.69911 .26714 L
.70882 .26662 L
.71853 .26608 L
.72824 .26552 L
.73796 .26493 L
.74767 .26432 L
.75738 .26368 L
.76709 .26301 L
.77681 .26232 L
.78055 .26204 L
.78652 .2616 L
.79623 .26084 L
.80594 .26005 L
.81566 .25923 L
.82537 .25838 L
.83508 .25748 L
.84479 .25655 L
.85451 .25558 L
.86422 .25457 L
.87393 .25351 L
.88364 .2524 L
.88424 .25233 L
.89336 .25124 L
.90307 .25004 L
.91278 .24877 L
.92249 .24744 L
.93221 .24605 L
.94192 .2446 L
Mistroke
.95163 .24306 L
.95437 .24262 L
.96134 .24146 L
.97106 .23976 L
.98077 .23797 L
Mfstroke
.55 g
.01923 .31795 m
.02894 .31817 L
.03866 .31838 L
.04837 .31859 L
.05808 .31879 L
.06779 .31898 L
.07751 .31917 L
.08722 .31936 L
.09693 .31953 L
.10664 .31971 L
.11636 .31988 L
.12607 .32004 L
.13578 .3202 L
.14354 .32032 L
.14549 .32035 L
.15521 .3205 L
.16492 .32064 L
.17463 .32077 L
.18434 .32091 L
.19406 .32103 L
.20377 .32115 L
.21348 .32127 L
.22319 .32138 L
.23291 .32148 L
.24262 .32158 L
.25233 .32168 L
.26204 .32177 L
.27176 .32185 L
.28147 .32193 L
.29118 .322 L
.30089 .32207 L
.31061 .32213 L
.32032 .32219 L
.33003 .32224 L
.33974 .32228 L
.34946 .32232 L
.35917 .32236 L
.36888 .32239 L
.37859 .32241 L
.38831 .32243 L
.39802 .32244 L
.40773 .32245 L
.41744 .32245 L
.42716 .32244 L
.43687 .32243 L
.44658 .32241 L
.45629 .32239 L
.46601 .32236 L
.47572 .32232 L
.48543 .32228 L
.49514 .32223 L
.50486 .32218 L
.51457 .32211 L
.52428 .32205 L
.53399 .32197 L
.54371 .32189 L
.55342 .3218 L
.56313 .3217 L
.57284 .3216 L
.58256 .32149 L
.59227 .32137 L
.60198 .32125 L
.61169 .32111 L
.62141 .32097 L
.63112 .32083 L
.64083 .32067 L
.65054 .3205 L
.66026 .32033 L
.6609 .32032 L
.66997 .32015 L
.67968 .31996 L
.68939 .31976 L
.69911 .31955 L
.70882 .31933 L
.71853 .3191 L
.72824 .31886 L
.73796 .31861 L
.74767 .31836 L
.75738 .31809 L
.76709 .31781 L
.77681 .31751 L
.78652 .31721 L
.79623 .3169 L
.80594 .31657 L
.81566 .31623 L
.82537 .31587 L
.83508 .31551 L
.84479 .31513 L
.85451 .31473 L
.86422 .31432 L
.87393 .3139 L
.88364 .31345 L
.89336 .313 L
.90307 .31252 L
.91278 .31203 L
.92249 .31152 L
.93221 .31099 L
.939 .31061 L
.94192 .31044 L
.95163 .30987 L
.96134 .30928 L
.97106 .30866 L
.98077 .30802 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .31795 m
.02894 .31817 L
.03866 .31838 L
.04837 .31859 L
.05808 .31879 L
.06779 .31898 L
.07751 .31917 L
.08722 .31936 L
.09693 .31953 L
.10664 .31971 L
.11636 .31988 L
.12607 .32004 L
.13578 .3202 L
.14354 .32032 L
.14549 .32035 L
.15521 .3205 L
.16492 .32064 L
.17463 .32077 L
.18434 .32091 L
.19406 .32103 L
.20377 .32115 L
.21348 .32127 L
.22319 .32138 L
.23291 .32148 L
.24262 .32158 L
.25233 .32168 L
.26204 .32177 L
.27176 .32185 L
.28147 .32193 L
.29118 .322 L
.30089 .32207 L
.31061 .32213 L
.32032 .32219 L
.33003 .32224 L
.33974 .32228 L
.34946 .32232 L
.35917 .32236 L
.36888 .32239 L
.37859 .32241 L
.38831 .32243 L
.39802 .32244 L
.40773 .32245 L
.41744 .32245 L
.42716 .32244 L
.43687 .32243 L
.44658 .32241 L
.45629 .32239 L
.46601 .32236 L
.47572 .32232 L
.48543 .32228 L
Mistroke
.49514 .32223 L
.50486 .32218 L
.51457 .32211 L
.52428 .32205 L
.53399 .32197 L
.54371 .32189 L
.55342 .3218 L
.56313 .3217 L
.57284 .3216 L
.58256 .32149 L
.59227 .32137 L
.60198 .32125 L
.61169 .32111 L
.62141 .32097 L
.63112 .32083 L
.64083 .32067 L
.65054 .3205 L
.66026 .32033 L
.6609 .32032 L
.66997 .32015 L
.67968 .31996 L
.68939 .31976 L
.69911 .31955 L
.70882 .31933 L
.71853 .3191 L
.72824 .31886 L
.73796 .31861 L
.74767 .31836 L
.75738 .31809 L
.76709 .31781 L
.77681 .31751 L
.78652 .31721 L
.79623 .3169 L
.80594 .31657 L
.81566 .31623 L
.82537 .31587 L
.83508 .31551 L
.84479 .31513 L
.85451 .31473 L
.86422 .31432 L
.87393 .3139 L
.88364 .31345 L
.89336 .313 L
.90307 .31252 L
.91278 .31203 L
.92249 .31152 L
.93221 .31099 L
.939 .31061 L
.94192 .31044 L
.95163 .30987 L
Mistroke
.96134 .30928 L
.97106 .30866 L
.98077 .30802 L
Mfstroke
.625 g
.01923 .36431 m
.02894 .36439 L
.03866 .36446 L
.04837 .36453 L
.05808 .3646 L
.06779 .36467 L
.07751 .36474 L
.08722 .3648 L
.09693 .36487 L
.10664 .36493 L
.11636 .36499 L
.12607 .36505 L
.13578 .3651 L
.14549 .36516 L
.15521 .36521 L
.16492 .36526 L
.17463 .36531 L
.18434 .36536 L
.19406 .3654 L
.20377 .36545 L
.21348 .36549 L
.22319 .36553 L
.23291 .36557 L
.24262 .36561 L
.25233 .36564 L
.26204 .36568 L
.27176 .36571 L
.28147 .36574 L
.29118 .36577 L
.30089 .36579 L
.31061 .36582 L
.32032 .36584 L
.33003 .36587 L
.33974 .36589 L
.34946 .3659 L
.35917 .36592 L
.36888 .36594 L
.37859 .36595 L
.38831 .36596 L
.39802 .36597 L
.40773 .36598 L
.41744 .36599 L
.42716 .36599 L
.43687 .36599 L
.44658 .366 L
.45629 .36599 L
.46601 .36599 L
.47572 .36599 L
.48543 .36598 L
.49514 .36597 L
.50486 .36596 L
.51457 .36595 L
.52428 .36594 L
.53399 .36592 L
.54371 .3659 L
.55342 .36588 L
.56313 .36586 L
.57284 .36584 L
.58256 .36581 L
.59227 .36578 L
.60198 .36575 L
.61169 .36572 L
.62141 .36568 L
.63112 .36564 L
.64083 .3656 L
.65054 .36556 L
.66026 .36552 L
.66997 .36547 L
.67968 .36542 L
.68939 .36537 L
.69911 .36532 L
.70882 .36526 L
.71853 .3652 L
.72824 .36514 L
.73796 .36507 L
.74767 .365 L
.75738 .36493 L
.76709 .36486 L
.77681 .36478 L
.78652 .3647 L
.79623 .36462 L
.80594 .36453 L
.81566 .36444 L
.82537 .36435 L
.83508 .36425 L
.84479 .36415 L
.85451 .36405 L
.86422 .36394 L
.87393 .36383 L
.88364 .36371 L
.89336 .36359 L
.90307 .36347 L
.91278 .36334 L
.92249 .36321 L
.93221 .36307 L
.94192 .36293 L
.95163 .36278 L
.96134 .36263 L
.97106 .36247 L
.98077 .36231 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .36431 m
.02894 .36439 L
.03866 .36446 L
.04837 .36453 L
.05808 .3646 L
.06779 .36467 L
.07751 .36474 L
.08722 .3648 L
.09693 .36487 L
.10664 .36493 L
.11636 .36499 L
.12607 .36505 L
.13578 .3651 L
.14549 .36516 L
.15521 .36521 L
.16492 .36526 L
.17463 .36531 L
.18434 .36536 L
.19406 .3654 L
.20377 .36545 L
.21348 .36549 L
.22319 .36553 L
.23291 .36557 L
.24262 .36561 L
.25233 .36564 L
.26204 .36568 L
.27176 .36571 L
.28147 .36574 L
.29118 .36577 L
.30089 .36579 L
.31061 .36582 L
.32032 .36584 L
.33003 .36587 L
.33974 .36589 L
.34946 .3659 L
.35917 .36592 L
.36888 .36594 L
.37859 .36595 L
.38831 .36596 L
.39802 .36597 L
.40773 .36598 L
.41744 .36599 L
.42716 .36599 L
.43687 .36599 L
.44658 .366 L
.45629 .36599 L
.46601 .36599 L
.47572 .36599 L
.48543 .36598 L
.49514 .36597 L
Mistroke
.50486 .36596 L
.51457 .36595 L
.52428 .36594 L
.53399 .36592 L
.54371 .3659 L
.55342 .36588 L
.56313 .36586 L
.57284 .36584 L
.58256 .36581 L
.59227 .36578 L
.60198 .36575 L
.61169 .36572 L
.62141 .36568 L
.63112 .36564 L
.64083 .3656 L
.65054 .36556 L
.66026 .36552 L
.66997 .36547 L
.67968 .36542 L
.68939 .36537 L
.69911 .36532 L
.70882 .36526 L
.71853 .3652 L
.72824 .36514 L
.73796 .36507 L
.74767 .365 L
.75738 .36493 L
.76709 .36486 L
.77681 .36478 L
.78652 .3647 L
.79623 .36462 L
.80594 .36453 L
.81566 .36444 L
.82537 .36435 L
.83508 .36425 L
.84479 .36415 L
.85451 .36405 L
.86422 .36394 L
.87393 .36383 L
.88364 .36371 L
.89336 .36359 L
.90307 .36347 L
.91278 .36334 L
.92249 .36321 L
.93221 .36307 L
.94192 .36293 L
.95163 .36278 L
.96134 .36263 L
.97106 .36247 L
.98077 .36231 L
Mistroke
Mfstroke
.7 g
.01923 .40955 m
.02894 .40946 L
.03866 .40938 L
.04837 .4093 L
.05808 .40922 L
.06779 .40914 L
.07751 .40907 L
.08722 .40899 L
.09693 .40892 L
.10664 .40885 L
.11636 .40878 L
.12607 .40872 L
.13578 .40865 L
.14549 .40859 L
.15521 .40853 L
.16492 .40847 L
.17463 .40842 L
.18434 .40836 L
.19406 .40831 L
.20377 .40826 L
.21348 .40821 L
.22319 .40816 L
.23291 .40812 L
.24262 .40807 L
.25233 .40803 L
.26204 .40799 L
.27176 .40795 L
.28147 .40792 L
.29118 .40788 L
.30089 .40785 L
.31061 .40782 L
.32032 .40779 L
.33003 .40776 L
.33974 .40773 L
.34023 .40773 L
.34946 .40771 L
.35917 .40769 L
.36888 .40766 L
.37859 .40765 L
.38831 .40763 L
.39802 .40761 L
.40773 .4076 L
.41744 .40759 L
.42716 .40758 L
.43687 .40757 L
.44658 .40756 L
.45629 .40756 L
.46601 .40756 L
.47572 .40756 L
.48543 .40756 L
.49514 .40756 L
.50486 .40757 L
.51457 .40757 L
.52428 .40758 L
.53399 .40759 L
.54371 .40761 L
.55342 .40762 L
.56313 .40764 L
.57284 .40766 L
.58256 .40768 L
.59227 .4077 L
.60198 .40773 L
.60319 .40773 L
.61169 .40776 L
.62141 .40779 L
.63112 .40782 L
.64083 .40785 L
.65054 .40789 L
.66026 .40793 L
.66997 .40797 L
.67968 .40801 L
.68939 .40806 L
.69911 .40811 L
.70882 .40816 L
.71853 .40821 L
.72824 .40827 L
.73796 .40833 L
.74767 .40839 L
.75738 .40845 L
.76709 .40852 L
.77681 .40859 L
.78652 .40866 L
.79623 .40874 L
.80594 .40882 L
.81566 .4089 L
.82537 .40898 L
.83508 .40907 L
.84479 .40917 L
.85451 .40926 L
.86422 .40936 L
.87393 .40946 L
.88364 .40957 L
.89336 .40968 L
.90307 .40979 L
.91278 .40991 L
.92249 .41003 L
.93221 .41016 L
.94192 .41029 L
.95163 .41042 L
.96134 .41056 L
.97106 .4107 L
.98077 .41085 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .40955 m
.02894 .40946 L
.03866 .40938 L
.04837 .4093 L
.05808 .40922 L
.06779 .40914 L
.07751 .40907 L
.08722 .40899 L
.09693 .40892 L
.10664 .40885 L
.11636 .40878 L
.12607 .40872 L
.13578 .40865 L
.14549 .40859 L
.15521 .40853 L
.16492 .40847 L
.17463 .40842 L
.18434 .40836 L
.19406 .40831 L
.20377 .40826 L
.21348 .40821 L
.22319 .40816 L
.23291 .40812 L
.24262 .40807 L
.25233 .40803 L
.26204 .40799 L
.27176 .40795 L
.28147 .40792 L
.29118 .40788 L
.30089 .40785 L
.31061 .40782 L
.32032 .40779 L
.33003 .40776 L
.33974 .40773 L
.34023 .40773 L
.34946 .40771 L
.35917 .40769 L
.36888 .40766 L
.37859 .40765 L
.38831 .40763 L
.39802 .40761 L
.40773 .4076 L
.41744 .40759 L
.42716 .40758 L
.43687 .40757 L
.44658 .40756 L
.45629 .40756 L
.46601 .40756 L
.47572 .40756 L
.48543 .40756 L
Mistroke
.49514 .40756 L
.50486 .40757 L
.51457 .40757 L
.52428 .40758 L
.53399 .40759 L
.54371 .40761 L
.55342 .40762 L
.56313 .40764 L
.57284 .40766 L
.58256 .40768 L
.59227 .4077 L
.60198 .40773 L
.60319 .40773 L
.61169 .40776 L
.62141 .40779 L
.63112 .40782 L
.64083 .40785 L
.65054 .40789 L
.66026 .40793 L
.66997 .40797 L
.67968 .40801 L
.68939 .40806 L
.69911 .40811 L
.70882 .40816 L
.71853 .40821 L
.72824 .40827 L
.73796 .40833 L
.74767 .40839 L
.75738 .40845 L
.76709 .40852 L
.77681 .40859 L
.78652 .40866 L
.79623 .40874 L
.80594 .40882 L
.81566 .4089 L
.82537 .40898 L
.83508 .40907 L
.84479 .40917 L
.85451 .40926 L
.86422 .40936 L
.87393 .40946 L
.88364 .40957 L
.89336 .40968 L
.90307 .40979 L
.91278 .40991 L
.92249 .41003 L
.93221 .41016 L
.94192 .41029 L
.95163 .41042 L
.96134 .41056 L
Mistroke
.97106 .4107 L
.98077 .41085 L
Mfstroke
.775 g
.01923 .45548 m
.02894 .45521 L
.03866 .45494 L
.04837 .45467 L
.05808 .45441 L
.06779 .45416 L
.07751 .45392 L
.08722 .45368 L
.09693 .45345 L
.10664 .45322 L
.11636 .453 L
.12607 .45279 L
.13578 .45258 L
.14549 .45237 L
.15521 .45218 L
.16492 .45199 L
.17463 .4518 L
.18434 .45162 L
.19406 .45145 L
.20377 .45128 L
.21348 .45112 L
.22319 .45096 L
.23291 .45081 L
.24262 .45066 L
.25233 .45052 L
.26204 .45039 L
.27176 .45026 L
.28147 .45014 L
.29118 .45002 L
.30089 .44991 L
.31061 .4498 L
.32032 .4497 L
.33003 .4496 L
.33974 .44951 L
.34946 .44942 L
.35917 .44934 L
.36888 .44927 L
.37859 .4492 L
.38831 .44914 L
.39802 .44908 L
.40773 .44902 L
.41744 .44898 L
.42716 .44893 L
.43687 .4489 L
.44658 .44887 L
.45629 .44884 L
.46601 .44882 L
.47572 .44881 L
.48543 .4488 L
.49514 .4488 L
.50486 .4488 L
.51457 .44881 L
.52428 .44882 L
.53399 .44884 L
.54371 .44887 L
.55342 .4489 L
.56313 .44894 L
.57284 .44898 L
.58256 .44903 L
.59227 .44909 L
.60198 .44915 L
.61169 .44922 L
.62141 .4493 L
.63112 .44938 L
.64083 .44947 L
.65054 .44957 L
.66026 .44967 L
.66997 .44978 L
.67968 .44989 L
.68939 .45002 L
.69911 .45015 L
.70882 .45028 L
.71853 .45043 L
.72824 .45058 L
.73796 .45074 L
.74767 .45091 L
.75738 .45109 L
.76709 .45127 L
.77681 .45146 L
.78652 .45166 L
.79623 .45187 L
.80594 .45209 L
.81566 .45232 L
.82537 .45255 L
.83508 .4528 L
.84479 .45305 L
.85451 .45332 L
.86422 .45359 L
.87393 .45388 L
.88364 .45417 L
.89336 .45448 L
.90307 .45479 L
.91278 .45512 L
.92249 .45546 L
.93221 .45581 L
.94192 .45618 L
.94499 .45629 L
.95163 .45655 L
.96134 .45694 L
.97106 .45734 L
.98077 .45776 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .45548 m
.02894 .45521 L
.03866 .45494 L
.04837 .45467 L
.05808 .45441 L
.06779 .45416 L
.07751 .45392 L
.08722 .45368 L
.09693 .45345 L
.10664 .45322 L
.11636 .453 L
.12607 .45279 L
.13578 .45258 L
.14549 .45237 L
.15521 .45218 L
.16492 .45199 L
.17463 .4518 L
.18434 .45162 L
.19406 .45145 L
.20377 .45128 L
.21348 .45112 L
.22319 .45096 L
.23291 .45081 L
.24262 .45066 L
.25233 .45052 L
.26204 .45039 L
.27176 .45026 L
.28147 .45014 L
.29118 .45002 L
.30089 .44991 L
.31061 .4498 L
.32032 .4497 L
.33003 .4496 L
.33974 .44951 L
.34946 .44942 L
.35917 .44934 L
.36888 .44927 L
.37859 .4492 L
.38831 .44914 L
.39802 .44908 L
.40773 .44902 L
.41744 .44898 L
.42716 .44893 L
.43687 .4489 L
.44658 .44887 L
.45629 .44884 L
.46601 .44882 L
.47572 .44881 L
.48543 .4488 L
.49514 .4488 L
Mistroke
.50486 .4488 L
.51457 .44881 L
.52428 .44882 L
.53399 .44884 L
.54371 .44887 L
.55342 .4489 L
.56313 .44894 L
.57284 .44898 L
.58256 .44903 L
.59227 .44909 L
.60198 .44915 L
.61169 .44922 L
.62141 .4493 L
.63112 .44938 L
.64083 .44947 L
.65054 .44957 L
.66026 .44967 L
.66997 .44978 L
.67968 .44989 L
.68939 .45002 L
.69911 .45015 L
.70882 .45028 L
.71853 .45043 L
.72824 .45058 L
.73796 .45074 L
.74767 .45091 L
.75738 .45109 L
.76709 .45127 L
.77681 .45146 L
.78652 .45166 L
.79623 .45187 L
.80594 .45209 L
.81566 .45232 L
.82537 .45255 L
.83508 .4528 L
.84479 .45305 L
.85451 .45332 L
.86422 .45359 L
.87393 .45388 L
.88364 .45417 L
.89336 .45448 L
.90307 .45479 L
.91278 .45512 L
.92249 .45546 L
.93221 .45581 L
.94192 .45618 L
.94499 .45629 L
.95163 .45655 L
.96134 .45694 L
.97106 .45734 L
Mistroke
.98077 .45776 L
Mfstroke
.85 g
.01923 .50445 m
.02894 .50392 L
.03866 .50341 L
.04837 .50291 L
.05808 .50242 L
.06779 .50194 L
.07751 .50147 L
.08722 .50102 L
.09693 .50058 L
.10664 .50015 L
.11636 .49973 L
.12607 .49932 L
.13578 .49892 L
.14549 .49854 L
.15521 .49817 L
.16492 .4978 L
.17463 .49745 L
.18434 .49711 L
.19406 .49678 L
.20377 .49646 L
.21348 .49615 L
.22319 .49585 L
.23291 .49556 L
.24262 .49528 L
.24764 .49514 L
.25233 .49502 L
.26204 .49476 L
.27176 .49451 L
.28147 .49427 L
.29118 .49404 L
.30089 .49382 L
.31061 .49361 L
.32032 .49342 L
.33003 .49323 L
.33974 .49305 L
.34946 .49288 L
.35917 .49272 L
.36888 .49257 L
.37859 .49243 L
.38831 .4923 L
.39802 .49218 L
.40773 .49207 L
.41744 .49197 L
.42716 .49188 L
.43687 .49179 L
.44658 .49172 L
.45629 .49166 L
.46601 .49161 L
.47572 .49157 L
.48543 .49153 L
.49514 .49151 L
.50486 .4915 L
.51457 .4915 L
.52428 .49151 L
.53399 .49153 L
.54371 .49156 L
.55342 .4916 L
.56313 .49165 L
.57284 .49171 L
.58256 .49178 L
.59227 .49186 L
.60198 .49195 L
.61169 .49206 L
.62141 .49217 L
.63112 .4923 L
.64083 .49244 L
.65054 .49259 L
.66026 .49275 L
.66997 .49293 L
.67968 .49311 L
.68939 .49331 L
.69911 .49352 L
.70882 .49374 L
.71853 .49398 L
.72824 .49423 L
.73796 .49449 L
.74767 .49477 L
.75738 .49506 L
.76009 .49514 L
.76709 .49536 L
.77681 .49568 L
.78652 .49602 L
.79623 .49637 L
.80594 .49673 L
.81566 .49711 L
.82537 .4975 L
.83508 .49792 L
.84479 .49834 L
.85451 .49879 L
.86422 .49925 L
.87393 .49974 L
.88364 .50023 L
.89336 .50075 L
.90307 .50129 L
.91278 .50185 L
.92249 .50243 L
.93221 .50303 L
.94192 .50365 L
.95163 .50429 L
.95984 .50486 L
.96134 .50496 L
.97106 .50565 L
.98077 .50637 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .50445 m
.02894 .50392 L
.03866 .50341 L
.04837 .50291 L
.05808 .50242 L
.06779 .50194 L
.07751 .50147 L
.08722 .50102 L
.09693 .50058 L
.10664 .50015 L
.11636 .49973 L
.12607 .49932 L
.13578 .49892 L
.14549 .49854 L
.15521 .49817 L
.16492 .4978 L
.17463 .49745 L
.18434 .49711 L
.19406 .49678 L
.20377 .49646 L
.21348 .49615 L
.22319 .49585 L
.23291 .49556 L
.24262 .49528 L
.24764 .49514 L
.25233 .49502 L
.26204 .49476 L
.27176 .49451 L
.28147 .49427 L
.29118 .49404 L
.30089 .49382 L
.31061 .49361 L
.32032 .49342 L
.33003 .49323 L
.33974 .49305 L
.34946 .49288 L
.35917 .49272 L
.36888 .49257 L
.37859 .49243 L
.38831 .4923 L
.39802 .49218 L
.40773 .49207 L
.41744 .49197 L
.42716 .49188 L
.43687 .49179 L
.44658 .49172 L
.45629 .49166 L
.46601 .49161 L
.47572 .49157 L
.48543 .49153 L
Mistroke
.49514 .49151 L
.50486 .4915 L
.51457 .4915 L
.52428 .49151 L
.53399 .49153 L
.54371 .49156 L
.55342 .4916 L
.56313 .49165 L
.57284 .49171 L
.58256 .49178 L
.59227 .49186 L
.60198 .49195 L
.61169 .49206 L
.62141 .49217 L
.63112 .4923 L
.64083 .49244 L
.65054 .49259 L
.66026 .49275 L
.66997 .49293 L
.67968 .49311 L
.68939 .49331 L
.69911 .49352 L
.70882 .49374 L
.71853 .49398 L
.72824 .49423 L
.73796 .49449 L
.74767 .49477 L
.75738 .49506 L
.76009 .49514 L
.76709 .49536 L
.77681 .49568 L
.78652 .49602 L
.79623 .49637 L
.80594 .49673 L
.81566 .49711 L
.82537 .4975 L
.83508 .49792 L
.84479 .49834 L
.85451 .49879 L
.86422 .49925 L
.87393 .49974 L
.88364 .50023 L
.89336 .50075 L
.90307 .50129 L
.91278 .50185 L
.92249 .50243 L
.93221 .50303 L
.94192 .50365 L
.95163 .50429 L
.95984 .50486 L
Mistroke
.96134 .50496 L
.97106 .50565 L
.98077 .50637 L
Mfstroke
.925 g
.01923 .5611 m
.02894 .56016 L
.03866 .55925 L
.04837 .55837 L
.05808 .55751 L
.06779 .55667 L
.07751 .55586 L
.08722 .55507 L
.09693 .5543 L
.10664 .55355 L
.10838 .55342 L
.11636 .55282 L
.12607 .55212 L
.13578 .55143 L
.14549 .55077 L
.15521 .55013 L
.16492 .5495 L
.17463 .54889 L
.18434 .54831 L
.19406 .54774 L
.20377 .54719 L
.21348 .54666 L
.22319 .54615 L
.23291 .54565 L
.24262 .54517 L
.25233 .54471 L
.26204 .54427 L
.27176 .54385 L
.27502 .54371 L
.28147 .54344 L
.29118 .54304 L
.30089 .54267 L
.31061 .54231 L
.32032 .54197 L
.33003 .54164 L
.33974 .54133 L
.34946 .54104 L
.35917 .54076 L
.36888 .5405 L
.37859 .54025 L
.38831 .54002 L
.39802 .53981 L
.40773 .53961 L
.41744 .53943 L
.42716 .53926 L
.43687 .53911 L
.44658 .53898 L
.45629 .53886 L
.46601 .53876 L
.47572 .53867 L
.48543 .5386 L
.49514 .53854 L
.50486 .53851 L
.51457 .53848 L
.52428 .53848 L
.53399 .53849 L
.54371 .53852 L
.55342 .53856 L
.56313 .53862 L
.57284 .5387 L
.58256 .5388 L
.59227 .53891 L
.60198 .53904 L
.61169 .53919 L
.62141 .53935 L
.63112 .53954 L
.64083 .53974 L
.65054 .53996 L
.66026 .5402 L
.66997 .54046 L
.67968 .54074 L
.68939 .54104 L
.69911 .54136 L
.70882 .5417 L
.71853 .54206 L
.72824 .54244 L
.73796 .54285 L
.74767 .54328 L
.75696 .54371 L
.75738 .54373 L
.76709 .5442 L
.77681 .5447 L
.78652 .54522 L
.79623 .54576 L
.80594 .54634 L
.81566 .54694 L
.82537 .54756 L
.83508 .54821 L
.84479 .5489 L
.85451 .54961 L
.86422 .55035 L
.87393 .55113 L
.88364 .55193 L
.89336 .55277 L
.90057 .55342 L
.90307 .55365 L
.91278 .55456 L
.92249 .5555 L
.93221 .55649 L
.94192 .55752 L
.95163 .55859 L
.96134 .5597 L
.97106 .56085 L
.98077 .56206 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .5611 m
.02894 .56016 L
.03866 .55925 L
.04837 .55837 L
.05808 .55751 L
.06779 .55667 L
.07751 .55586 L
.08722 .55507 L
.09693 .5543 L
.10664 .55355 L
.10838 .55342 L
.11636 .55282 L
.12607 .55212 L
.13578 .55143 L
.14549 .55077 L
.15521 .55013 L
.16492 .5495 L
.17463 .54889 L
.18434 .54831 L
.19406 .54774 L
.20377 .54719 L
.21348 .54666 L
.22319 .54615 L
.23291 .54565 L
.24262 .54517 L
.25233 .54471 L
.26204 .54427 L
.27176 .54385 L
.27502 .54371 L
.28147 .54344 L
.29118 .54304 L
.30089 .54267 L
.31061 .54231 L
.32032 .54197 L
.33003 .54164 L
.33974 .54133 L
.34946 .54104 L
.35917 .54076 L
.36888 .5405 L
.37859 .54025 L
.38831 .54002 L
.39802 .53981 L
.40773 .53961 L
.41744 .53943 L
.42716 .53926 L
.43687 .53911 L
.44658 .53898 L
.45629 .53886 L
.46601 .53876 L
.47572 .53867 L
Mistroke
.48543 .5386 L
.49514 .53854 L
.50486 .53851 L
.51457 .53848 L
.52428 .53848 L
.53399 .53849 L
.54371 .53852 L
.55342 .53856 L
.56313 .53862 L
.57284 .5387 L
.58256 .5388 L
.59227 .53891 L
.60198 .53904 L
.61169 .53919 L
.62141 .53935 L
.63112 .53954 L
.64083 .53974 L
.65054 .53996 L
.66026 .5402 L
.66997 .54046 L
.67968 .54074 L
.68939 .54104 L
.69911 .54136 L
.70882 .5417 L
.71853 .54206 L
.72824 .54244 L
.73796 .54285 L
.74767 .54328 L
.75696 .54371 L
.75738 .54373 L
.76709 .5442 L
.77681 .5447 L
.78652 .54522 L
.79623 .54576 L
.80594 .54634 L
.81566 .54694 L
.82537 .54756 L
.83508 .54821 L
.84479 .5489 L
.85451 .54961 L
.86422 .55035 L
.87393 .55113 L
.88364 .55193 L
.89336 .55277 L
.90057 .55342 L
.90307 .55365 L
.91278 .55456 L
.92249 .5555 L
.93221 .55649 L
.94192 .55752 L
Mistroke
.95163 .55859 L
.96134 .5597 L
.97106 .56085 L
.98077 .56206 L
Mfstroke
1 g
.01923 .64624 m
.02894 .6437 L
.03866 .64131 L
.04069 .64083 L
.04837 .63905 L
.05808 .63689 L
.06779 .63485 L
.07751 .63291 L
.0869 .63112 L
.08722 .63106 L
.09693 .62928 L
.10664 .62759 L
.11636 .62597 L
.12607 .62441 L
.13578 .62293 L
.14549 .6215 L
.14617 .62141 L
.15521 .62013 L
.16492 .61882 L
.17463 .61756 L
.18434 .61634 L
.19406 .61518 L
.20377 .61407 L
.21348 .613 L
.22319 .61197 L
.2259 .61169 L
.23291 .61099 L
.24262 .61004 L
.25233 .60913 L
.26204 .60827 L
.27176 .60744 L
.28147 .60664 L
.29118 .60589 L
.30089 .60516 L
.31061 .60448 L
.32032 .60382 L
.33003 .6032 L
.33974 .60261 L
.34946 .60205 L
.35072 .60198 L
.35917 .60152 L
.36888 .60103 L
.37859 .60056 L
.38831 .60013 L
.39802 .59972 L
.40773 .59935 L
.41744 .599 L
.42716 .59868 L
.43687 .5984 L
.44658 .59814 L
.45629 .59791 L
.46601 .59771 L
.47572 .59754 L
.48543 .5974 L
.49514 .59729 L
.50486 .5972 L
.51457 .59715 L
.52428 .59712 L
.53399 .59713 L
.54371 .59716 L
.55342 .59723 L
.56313 .59733 L
.57284 .59745 L
.58256 .59761 L
.59227 .5978 L
.60198 .59802 L
.61169 .59828 L
.62141 .59857 L
.63112 .59889 L
.64083 .59924 L
.65054 .59964 L
.66026 .60006 L
.66997 .60053 L
.67968 .60103 L
.68939 .60158 L
.69622 .60198 L
.69911 .60216 L
.70882 .60278 L
.71853 .60345 L
.72824 .60416 L
.73796 .60491 L
.74767 .60572 L
.75738 .60657 L
.76709 .60748 L
.77681 .60844 L
.78652 .60945 L
.79623 .61053 L
.80594 .61167 L
.80617 .61169 L
.81566 .61287 L
.82537 .61414 L
.83508 .61548 L
.84479 .61691 L
.85451 .61842 L
.86422 .62002 L
.87218 .62141 L
.87393 .62172 L
.88364 .62352 L
.89336 .62544 L
.90307 .62749 L
.91278 .62968 L
.91879 .63112 L
.92249 .63203 L
.93221 .63455 L
.94192 .63729 L
.95163 .64029 L
.9533 .64083 L
.96134 .64354 L
.97106 .64718 L
.97907 .65054 L
.98077 .65128 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .64624 m
.02894 .6437 L
.03866 .64131 L
.04069 .64083 L
.04837 .63905 L
.05808 .63689 L
.06779 .63485 L
.07751 .63291 L
.0869 .63112 L
.08722 .63106 L
.09693 .62928 L
.10664 .62759 L
.11636 .62597 L
.12607 .62441 L
.13578 .62293 L
.14549 .6215 L
.14617 .62141 L
.15521 .62013 L
.16492 .61882 L
.17463 .61756 L
.18434 .61634 L
.19406 .61518 L
.20377 .61407 L
.21348 .613 L
.22319 .61197 L
.2259 .61169 L
.23291 .61099 L
.24262 .61004 L
.25233 .60913 L
.26204 .60827 L
.27176 .60744 L
.28147 .60664 L
.29118 .60589 L
.30089 .60516 L
.31061 .60448 L
.32032 .60382 L
.33003 .6032 L
.33974 .60261 L
.34946 .60205 L
.35072 .60198 L
.35917 .60152 L
.36888 .60103 L
.37859 .60056 L
.38831 .60013 L
.39802 .59972 L
.40773 .59935 L
.41744 .599 L
.42716 .59868 L
.43687 .5984 L
.44658 .59814 L
Mistroke
.45629 .59791 L
.46601 .59771 L
.47572 .59754 L
.48543 .5974 L
.49514 .59729 L
.50486 .5972 L
.51457 .59715 L
.52428 .59712 L
.53399 .59713 L
.54371 .59716 L
.55342 .59723 L
.56313 .59733 L
.57284 .59745 L
.58256 .59761 L
.59227 .5978 L
.60198 .59802 L
.61169 .59828 L
.62141 .59857 L
.63112 .59889 L
.64083 .59924 L
.65054 .59964 L
.66026 .60006 L
.66997 .60053 L
.67968 .60103 L
.68939 .60158 L
.69622 .60198 L
.69911 .60216 L
.70882 .60278 L
.71853 .60345 L
.72824 .60416 L
.73796 .60491 L
.74767 .60572 L
.75738 .60657 L
.76709 .60748 L
.77681 .60844 L
.78652 .60945 L
.79623 .61053 L
.80594 .61167 L
.80617 .61169 L
.81566 .61287 L
.82537 .61414 L
.83508 .61548 L
.84479 .61691 L
.85451 .61842 L
.86422 .62002 L
.87218 .62141 L
.87393 .62172 L
.88364 .62352 L
.89336 .62544 L
.90307 .62749 L
Mistroke
.91278 .62968 L
.91879 .63112 L
.92249 .63203 L
.93221 .63455 L
.94192 .63729 L
.95163 .64029 L
.9533 .64083 L
.96134 .64354 L
.97106 .64718 L
.97907 .65054 L
.98077 .65128 L
Mfstroke
.925 g
.01923 .75586 m
.02612 .75738 L
.02894 .75799 L
.03866 .76 L
.04837 .76188 L
.05808 .76365 L
.06779 .76531 L
.07751 .76688 L
.07889 .76709 L
.08722 .76837 L
.09693 .76979 L
.10664 .77114 L
.11636 .77242 L
.12607 .77363 L
.13578 .77479 L
.14549 .77589 L
.15397 .77681 L
.15521 .77694 L
.16492 .77794 L
.17463 .7789 L
.18434 .7798 L
.19406 .78067 L
.20377 .7815 L
.21348 .78228 L
.22319 .78302 L
.23291 .78373 L
.24262 .7844 L
.25233 .78504 L
.26204 .78565 L
.27176 .78622 L
.27715 .78652 L
.28147 .78676 L
.29118 .78726 L
.30089 .78774 L
.31061 .78819 L
.32032 .78861 L
.33003 .789 L
.33974 .78936 L
.34946 .7897 L
.35917 .79 L
.36888 .79028 L
.37859 .79053 L
.38831 .79076 L
.39802 .79096 L
.40773 .79113 L
.41744 .79128 L
.42716 .7914 L
.43687 .79149 L
.44658 .79156 L
.45629 .7916 L
.46601 .79162 L
.47572 .79161 L
.48543 .79158 L
.49514 .79152 L
.50486 .79143 L
.51457 .79131 L
.52428 .79117 L
.53399 .79101 L
.54371 .79081 L
.55342 .79059 L
.56313 .79034 L
.57284 .79006 L
.58256 .78975 L
.59227 .78942 L
.60198 .78905 L
.61169 .78865 L
.62141 .78823 L
.63112 .78777 L
.64083 .78727 L
.65054 .78675 L
.65462 .78652 L
.66026 .78619 L
.66997 .7856 L
.67968 .78497 L
.68939 .78431 L
.69911 .7836 L
.70882 .78286 L
.71853 .78207 L
.72824 .78125 L
.73796 .78037 L
.74767 .77946 L
.75738 .77849 L
.76709 .77747 L
.77321 .77681 L
.77681 .77641 L
.78652 .77529 L
.79623 .77411 L
.80594 .77287 L
.81566 .77156 L
.82537 .77019 L
.83508 .76874 L
.84479 .76722 L
.84554 .76709 L
.85451 .76561 L
.86422 .76392 L
.87393 .76213 L
.88364 .76023 L
.89336 .75821 L
.89717 .75738 L
.90307 .75607 L
.91278 .7538 L
.92249 .75136 L
.93221 .74872 L
.9359 .74767 L
.94192 .7459 L
.95163 .74284 L
.96134 .73946 L
.96537 .73796 L
.97106 .73576 L
.98077 .73159 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .75586 m
.02612 .75738 L
.02894 .75799 L
.03866 .76 L
.04837 .76188 L
.05808 .76365 L
.06779 .76531 L
.07751 .76688 L
.07889 .76709 L
.08722 .76837 L
.09693 .76979 L
.10664 .77114 L
.11636 .77242 L
.12607 .77363 L
.13578 .77479 L
.14549 .77589 L
.15397 .77681 L
.15521 .77694 L
.16492 .77794 L
.17463 .7789 L
.18434 .7798 L
.19406 .78067 L
.20377 .7815 L
.21348 .78228 L
.22319 .78302 L
.23291 .78373 L
.24262 .7844 L
.25233 .78504 L
.26204 .78565 L
.27176 .78622 L
.27715 .78652 L
.28147 .78676 L
.29118 .78726 L
.30089 .78774 L
.31061 .78819 L
.32032 .78861 L
.33003 .789 L
.33974 .78936 L
.34946 .7897 L
.35917 .79 L
.36888 .79028 L
.37859 .79053 L
.38831 .79076 L
.39802 .79096 L
.40773 .79113 L
.41744 .79128 L
.42716 .7914 L
.43687 .79149 L
.44658 .79156 L
.45629 .7916 L
Mistroke
.46601 .79162 L
.47572 .79161 L
.48543 .79158 L
.49514 .79152 L
.50486 .79143 L
.51457 .79131 L
.52428 .79117 L
.53399 .79101 L
.54371 .79081 L
.55342 .79059 L
.56313 .79034 L
.57284 .79006 L
.58256 .78975 L
.59227 .78942 L
.60198 .78905 L
.61169 .78865 L
.62141 .78823 L
.63112 .78777 L
.64083 .78727 L
.65054 .78675 L
.65462 .78652 L
.66026 .78619 L
.66997 .7856 L
.67968 .78497 L
.68939 .78431 L
.69911 .7836 L
.70882 .78286 L
.71853 .78207 L
.72824 .78125 L
.73796 .78037 L
.74767 .77946 L
.75738 .77849 L
.76709 .77747 L
.77321 .77681 L
.77681 .77641 L
.78652 .77529 L
.79623 .77411 L
.80594 .77287 L
.81566 .77156 L
.82537 .77019 L
.83508 .76874 L
.84479 .76722 L
.84554 .76709 L
.85451 .76561 L
.86422 .76392 L
.87393 .76213 L
.88364 .76023 L
.89336 .75821 L
.89717 .75738 L
.90307 .75607 L
Mistroke
.91278 .7538 L
.92249 .75136 L
.93221 .74872 L
.9359 .74767 L
.94192 .7459 L
.95163 .74284 L
.96134 .73946 L
.96537 .73796 L
.97106 .73576 L
.98077 .73159 L
Mfstroke
.85 g
.01923 .83031 m
.02894 .83093 L
.03866 .83153 L
.04837 .83212 L
.05808 .83268 L
.06779 .83322 L
.07751 .83375 L
.08722 .83426 L
.09693 .83475 L
.1037 .83508 L
.10664 .83522 L
.11636 .83568 L
.12607 .83613 L
.13578 .83655 L
.14549 .83696 L
.15521 .83736 L
.16492 .83774 L
.17463 .8381 L
.18434 .83845 L
.19406 .83879 L
.20377 .83911 L
.21348 .83942 L
.22319 .83971 L
.23291 .83999 L
.24262 .84025 L
.25233 .84051 L
.26204 .84074 L
.27176 .84097 L
.28147 .84118 L
.29118 .84137 L
.30089 .84156 L
.31061 .84173 L
.32032 .84189 L
.33003 .84203 L
.33974 .84216 L
.34946 .84228 L
.35917 .84238 L
.36888 .84248 L
.37859 .84256 L
.38831 .84262 L
.39802 .84267 L
.40773 .84271 L
.41744 .84274 L
.42716 .84275 L
.43687 .84275 L
.44658 .84274 L
.45629 .84271 L
.46601 .84267 L
.47572 .84262 L
.48543 .84255 L
.49514 .84247 L
.50486 .84238 L
.51457 .84227 L
.52428 .84214 L
.53399 .84201 L
.54371 .84185 L
.55342 .84169 L
.56313 .84151 L
.57284 .84131 L
.58256 .8411 L
.59227 .84087 L
.60198 .84063 L
.61169 .84037 L
.62141 .8401 L
.63112 .83981 L
.64083 .8395 L
.65054 .83918 L
.66026 .83883 L
.66997 .83848 L
.67968 .8381 L
.68939 .8377 L
.69911 .83729 L
.70882 .83685 L
.71853 .8364 L
.72824 .83593 L
.73796 .83544 L
.74468 .83508 L
.74767 .83492 L
.75738 .83439 L
.76709 .83383 L
.77681 .83325 L
.78652 .83264 L
.79623 .83202 L
.80594 .83136 L
.81566 .83069 L
.82537 .82998 L
.83508 .82925 L
.84479 .82849 L
.85451 .82771 L
.86422 .82689 L
.87393 .82604 L
.88138 .82537 L
.88364 .82516 L
.89336 .82425 L
.90307 .8233 L
.91278 .82232 L
.92249 .8213 L
.93221 .82025 L
.94192 .81915 L
.95163 .81801 L
.96134 .81683 L
.97063 .81566 L
.97106 .8156 L
.98077 .81433 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .83031 m
.02894 .83093 L
.03866 .83153 L
.04837 .83212 L
.05808 .83268 L
.06779 .83322 L
.07751 .83375 L
.08722 .83426 L
.09693 .83475 L
.1037 .83508 L
.10664 .83522 L
.11636 .83568 L
.12607 .83613 L
.13578 .83655 L
.14549 .83696 L
.15521 .83736 L
.16492 .83774 L
.17463 .8381 L
.18434 .83845 L
.19406 .83879 L
.20377 .83911 L
.21348 .83942 L
.22319 .83971 L
.23291 .83999 L
.24262 .84025 L
.25233 .84051 L
.26204 .84074 L
.27176 .84097 L
.28147 .84118 L
.29118 .84137 L
.30089 .84156 L
.31061 .84173 L
.32032 .84189 L
.33003 .84203 L
.33974 .84216 L
.34946 .84228 L
.35917 .84238 L
.36888 .84248 L
.37859 .84256 L
.38831 .84262 L
.39802 .84267 L
.40773 .84271 L
.41744 .84274 L
.42716 .84275 L
.43687 .84275 L
.44658 .84274 L
.45629 .84271 L
.46601 .84267 L
.47572 .84262 L
.48543 .84255 L
Mistroke
.49514 .84247 L
.50486 .84238 L
.51457 .84227 L
.52428 .84214 L
.53399 .84201 L
.54371 .84185 L
.55342 .84169 L
.56313 .84151 L
.57284 .84131 L
.58256 .8411 L
.59227 .84087 L
.60198 .84063 L
.61169 .84037 L
.62141 .8401 L
.63112 .83981 L
.64083 .8395 L
.65054 .83918 L
.66026 .83883 L
.66997 .83848 L
.67968 .8381 L
.68939 .8377 L
.69911 .83729 L
.70882 .83685 L
.71853 .8364 L
.72824 .83593 L
.73796 .83544 L
.74468 .83508 L
.74767 .83492 L
.75738 .83439 L
.76709 .83383 L
.77681 .83325 L
.78652 .83264 L
.79623 .83202 L
.80594 .83136 L
.81566 .83069 L
.82537 .82998 L
.83508 .82925 L
.84479 .82849 L
.85451 .82771 L
.86422 .82689 L
.87393 .82604 L
.88138 .82537 L
.88364 .82516 L
.89336 .82425 L
.90307 .8233 L
.91278 .82232 L
.92249 .8213 L
.93221 .82025 L
.94192 .81915 L
.95163 .81801 L
Mistroke
.96134 .81683 L
.97063 .81566 L
.97106 .8156 L
.98077 .81433 L
Mfstroke
.775 g
.01923 .87569 m
.02894 .87599 L
.03866 .87628 L
.04837 .87657 L
.05808 .87685 L
.06779 .87711 L
.07751 .87737 L
.08722 .87763 L
.09693 .87787 L
.10664 .8781 L
.11636 .87833 L
.12607 .87855 L
.13578 .87876 L
.14549 .87896 L
.15521 .87916 L
.16492 .87934 L
.17463 .87952 L
.18434 .87969 L
.19406 .87986 L
.20377 .88001 L
.21348 .88016 L
.22319 .8803 L
.23291 .88044 L
.24262 .88056 L
.25233 .88068 L
.26204 .88079 L
.27176 .88089 L
.28147 .88099 L
.29118 .88108 L
.30089 .88116 L
.31061 .88123 L
.32032 .8813 L
.33003 .88136 L
.33974 .88141 L
.34946 .88145 L
.35917 .88149 L
.36888 .88151 L
.37859 .88153 L
.38831 .88155 L
.39802 .88155 L
.40773 .88155 L
.41744 .88154 L
.42716 .88152 L
.43687 .88149 L
.44658 .88146 L
.45629 .88142 L
.46601 .88137 L
.47572 .88131 L
.48543 .88124 L
.49514 .88117 L
.50486 .88108 L
.51457 .88099 L
.52428 .88089 L
.53399 .88078 L
.54371 .88066 L
.55342 .88054 L
.56313 .8804 L
.57284 .88025 L
.58256 .8801 L
.59227 .87994 L
.60198 .87976 L
.61169 .87958 L
.62141 .87939 L
.63112 .87919 L
.64083 .87897 L
.65054 .87875 L
.66026 .87852 L
.66997 .87827 L
.67968 .87802 L
.68939 .87775 L
.69911 .87747 L
.70882 .87718 L
.71853 .87688 L
.72824 .87657 L
.73796 .87624 L
.74767 .8759 L
.75738 .87555 L
.76709 .87519 L
.77681 .87481 L
.78652 .87442 L
.79623 .87401 L
.79813 .87393 L
.80594 .87359 L
.81566 .87316 L
.82537 .87271 L
.83508 .87224 L
.84479 .87176 L
.85451 .87126 L
.86422 .87074 L
.87393 .87021 L
.88364 .86966 L
.89336 .86909 L
.90307 .8685 L
.91278 .86789 L
.92249 .86726 L
.93221 .86661 L
.94192 .86594 L
.95163 .86524 L
.96134 .86453 L
.96541 .86422 L
.97106 .86379 L
.98077 .86302 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .87569 m
.02894 .87599 L
.03866 .87628 L
.04837 .87657 L
.05808 .87685 L
.06779 .87711 L
.07751 .87737 L
.08722 .87763 L
.09693 .87787 L
.10664 .8781 L
.11636 .87833 L
.12607 .87855 L
.13578 .87876 L
.14549 .87896 L
.15521 .87916 L
.16492 .87934 L
.17463 .87952 L
.18434 .87969 L
.19406 .87986 L
.20377 .88001 L
.21348 .88016 L
.22319 .8803 L
.23291 .88044 L
.24262 .88056 L
.25233 .88068 L
.26204 .88079 L
.27176 .88089 L
.28147 .88099 L
.29118 .88108 L
.30089 .88116 L
.31061 .88123 L
.32032 .8813 L
.33003 .88136 L
.33974 .88141 L
.34946 .88145 L
.35917 .88149 L
.36888 .88151 L
.37859 .88153 L
.38831 .88155 L
.39802 .88155 L
.40773 .88155 L
.41744 .88154 L
.42716 .88152 L
.43687 .88149 L
.44658 .88146 L
.45629 .88142 L
.46601 .88137 L
.47572 .88131 L
.48543 .88124 L
.49514 .88117 L
Mistroke
.50486 .88108 L
.51457 .88099 L
.52428 .88089 L
.53399 .88078 L
.54371 .88066 L
.55342 .88054 L
.56313 .8804 L
.57284 .88025 L
.58256 .8801 L
.59227 .87994 L
.60198 .87976 L
.61169 .87958 L
.62141 .87939 L
.63112 .87919 L
.64083 .87897 L
.65054 .87875 L
.66026 .87852 L
.66997 .87827 L
.67968 .87802 L
.68939 .87775 L
.69911 .87747 L
.70882 .87718 L
.71853 .87688 L
.72824 .87657 L
.73796 .87624 L
.74767 .8759 L
.75738 .87555 L
.76709 .87519 L
.77681 .87481 L
.78652 .87442 L
.79623 .87401 L
.79813 .87393 L
.80594 .87359 L
.81566 .87316 L
.82537 .87271 L
.83508 .87224 L
.84479 .87176 L
.85451 .87126 L
.86422 .87074 L
.87393 .87021 L
.88364 .86966 L
.89336 .86909 L
.90307 .8685 L
.91278 .86789 L
.92249 .86726 L
.93221 .86661 L
.94192 .86594 L
.95163 .86524 L
.96134 .86453 L
.96541 .86422 L
Mistroke
.97106 .86379 L
.98077 .86302 L
Mfstroke
.7 g
.01923 .91269 m
.02582 .91278 L
.02894 .91283 L
.03866 .91296 L
.04837 .9131 L
.05808 .91323 L
.06779 .91335 L
.07751 .91347 L
.08722 .91359 L
.09693 .9137 L
.10664 .91381 L
.11636 .91391 L
.12607 .91401 L
.13578 .91411 L
.14549 .9142 L
.15521 .91429 L
.16492 .91438 L
.17463 .91446 L
.18434 .91453 L
.19406 .91461 L
.20377 .91467 L
.21348 .91474 L
.22319 .9148 L
.23291 .91486 L
.24262 .91491 L
.25233 .91496 L
.26204 .91501 L
.27176 .91505 L
.28147 .91508 L
.29118 .91512 L
.30089 .91515 L
.31061 .91517 L
.32032 .91519 L
.33003 .91521 L
.33974 .91523 L
.34946 .91523 L
.35917 .91524 L
.36888 .91524 L
.37859 .91524 L
.38831 .91523 L
.39802 .91522 L
.40773 .9152 L
.41744 .91518 L
.42716 .91516 L
.43687 .91513 L
.44658 .9151 L
.45629 .91506 L
.46601 .91502 L
.47572 .91497 L
.48543 .91492 L
.49514 .91487 L
.50486 .91481 L
.51457 .91474 L
.52428 .91467 L
.53399 .9146 L
.54371 .91452 L
.55342 .91443 L
.56313 .91434 L
.57284 .91425 L
.58256 .91415 L
.59227 .91405 L
.60198 .91393 L
.61169 .91382 L
.62141 .9137 L
.63112 .91357 L
.64083 .91344 L
.65054 .9133 L
.66026 .91315 L
.66997 .913 L
.67968 .91285 L
.6835 .91278 L
.68939 .91268 L
.69911 .91251 L
.70882 .91234 L
.71853 .91215 L
.72824 .91196 L
.73796 .91176 L
.74767 .91156 L
.75738 .91135 L
.76709 .91113 L
.77681 .9109 L
.78652 .91067 L
.79623 .91042 L
.80594 .91017 L
.81566 .90991 L
.82537 .90965 L
.83508 .90937 L
.84479 .90908 L
.85451 .90879 L
.86422 .90848 L
.87393 .90816 L
.88364 .90784 L
.89336 .9075 L
.90307 .90715 L
.91278 .9068 L
.92249 .90643 L
.93221 .90604 L
.94192 .90565 L
.95163 .90524 L
.96134 .90482 L
.97106 .90439 L
.98077 .90394 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .91269 m
.02582 .91278 L
.02894 .91283 L
.03866 .91296 L
.04837 .9131 L
.05808 .91323 L
.06779 .91335 L
.07751 .91347 L
.08722 .91359 L
.09693 .9137 L
.10664 .91381 L
.11636 .91391 L
.12607 .91401 L
.13578 .91411 L
.14549 .9142 L
.15521 .91429 L
.16492 .91438 L
.17463 .91446 L
.18434 .91453 L
.19406 .91461 L
.20377 .91467 L
.21348 .91474 L
.22319 .9148 L
.23291 .91486 L
.24262 .91491 L
.25233 .91496 L
.26204 .91501 L
.27176 .91505 L
.28147 .91508 L
.29118 .91512 L
.30089 .91515 L
.31061 .91517 L
.32032 .91519 L
.33003 .91521 L
.33974 .91523 L
.34946 .91523 L
.35917 .91524 L
.36888 .91524 L
.37859 .91524 L
.38831 .91523 L
.39802 .91522 L
.40773 .9152 L
.41744 .91518 L
.42716 .91516 L
.43687 .91513 L
.44658 .9151 L
.45629 .91506 L
.46601 .91502 L
.47572 .91497 L
.48543 .91492 L
Mistroke
.49514 .91487 L
.50486 .91481 L
.51457 .91474 L
.52428 .91467 L
.53399 .9146 L
.54371 .91452 L
.55342 .91443 L
.56313 .91434 L
.57284 .91425 L
.58256 .91415 L
.59227 .91405 L
.60198 .91393 L
.61169 .91382 L
.62141 .9137 L
.63112 .91357 L
.64083 .91344 L
.65054 .9133 L
.66026 .91315 L
.66997 .913 L
.67968 .91285 L
.6835 .91278 L
.68939 .91268 L
.69911 .91251 L
.70882 .91234 L
.71853 .91215 L
.72824 .91196 L
.73796 .91176 L
.74767 .91156 L
.75738 .91135 L
.76709 .91113 L
.77681 .9109 L
.78652 .91067 L
.79623 .91042 L
.80594 .91017 L
.81566 .90991 L
.82537 .90965 L
.83508 .90937 L
.84479 .90908 L
.85451 .90879 L
.86422 .90848 L
.87393 .90816 L
.88364 .90784 L
.89336 .9075 L
.90307 .90715 L
.91278 .9068 L
.92249 .90643 L
.93221 .90604 L
.94192 .90565 L
.95163 .90524 L
.96134 .90482 L
Mistroke
.97106 .90439 L
.98077 .90394 L
Mfstroke
.625 g
.01923 .94578 m
.02894 .94582 L
.03866 .94585 L
.04837 .94589 L
.05808 .94593 L
.06779 .94596 L
.07751 .94599 L
.08722 .94603 L
.09693 .94606 L
.10664 .94609 L
.11636 .94611 L
.12607 .94614 L
.13578 .94617 L
.14549 .94619 L
.15521 .94621 L
.16492 .94624 L
.17463 .94626 L
.18434 .94628 L
.19406 .9463 L
.20377 .94631 L
.21348 .94633 L
.22319 .94634 L
.23291 .94636 L
.24262 .94637 L
.25233 .94638 L
.26204 .94639 L
.27176 .9464 L
.28147 .94641 L
.29118 .94641 L
.30089 .94642 L
.31061 .94642 L
.32032 .94642 L
.33003 .94643 L
.33974 .94643 L
.34946 .94642 L
.35917 .94642 L
.36888 .94642 L
.37859 .94641 L
.38831 .9464 L
.39802 .9464 L
.40773 .94639 L
.41744 .94638 L
.42716 .94636 L
.43687 .94635 L
.44658 .94633 L
.45629 .94632 L
.46601 .9463 L
.47572 .94628 L
.48543 .94626 L
.49514 .94624 L
.50486 .94621 L
.51457 .94619 L
.52428 .94616 L
.53399 .94613 L
.54371 .9461 L
.55342 .94607 L
.56313 .94603 L
.57284 .946 L
.58256 .94596 L
.59227 .94592 L
.60198 .94588 L
.61169 .94583 L
.62141 .94579 L
.63112 .94574 L
.64083 .94569 L
.65054 .94564 L
.66026 .94559 L
.66997 .94553 L
.67968 .94548 L
.68939 .94542 L
.69911 .94536 L
.70882 .94529 L
.71853 .94523 L
.72824 .94516 L
.73796 .94509 L
.74767 .94501 L
.75738 .94494 L
.76709 .94486 L
.77681 .94478 L
.78652 .94469 L
.79623 .94461 L
.80594 .94452 L
.81566 .94442 L
.82537 .94433 L
.83508 .94423 L
.84479 .94413 L
.85451 .94402 L
.86422 .94391 L
.87393 .9438 L
.88364 .94368 L
.89336 .94356 L
.90307 .94344 L
.91278 .94331 L
.92249 .94318 L
.93221 .94304 L
.94192 .9429 L
.95163 .94276 L
.96134 .94261 L
.97106 .94245 L
.98077 .94229 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .94578 m
.02894 .94582 L
.03866 .94585 L
.04837 .94589 L
.05808 .94593 L
.06779 .94596 L
.07751 .94599 L
.08722 .94603 L
.09693 .94606 L
.10664 .94609 L
.11636 .94611 L
.12607 .94614 L
.13578 .94617 L
.14549 .94619 L
.15521 .94621 L
.16492 .94624 L
.17463 .94626 L
.18434 .94628 L
.19406 .9463 L
.20377 .94631 L
.21348 .94633 L
.22319 .94634 L
.23291 .94636 L
.24262 .94637 L
.25233 .94638 L
.26204 .94639 L
.27176 .9464 L
.28147 .94641 L
.29118 .94641 L
.30089 .94642 L
.31061 .94642 L
.32032 .94642 L
.33003 .94643 L
.33974 .94643 L
.34946 .94642 L
.35917 .94642 L
.36888 .94642 L
.37859 .94641 L
.38831 .9464 L
.39802 .9464 L
.40773 .94639 L
.41744 .94638 L
.42716 .94636 L
.43687 .94635 L
.44658 .94633 L
.45629 .94632 L
.46601 .9463 L
.47572 .94628 L
.48543 .94626 L
.49514 .94624 L
Mistroke
.50486 .94621 L
.51457 .94619 L
.52428 .94616 L
.53399 .94613 L
.54371 .9461 L
.55342 .94607 L
.56313 .94603 L
.57284 .946 L
.58256 .94596 L
.59227 .94592 L
.60198 .94588 L
.61169 .94583 L
.62141 .94579 L
.63112 .94574 L
.64083 .94569 L
.65054 .94564 L
.66026 .94559 L
.66997 .94553 L
.67968 .94548 L
.68939 .94542 L
.69911 .94536 L
.70882 .94529 L
.71853 .94523 L
.72824 .94516 L
.73796 .94509 L
.74767 .94501 L
.75738 .94494 L
.76709 .94486 L
.77681 .94478 L
.78652 .94469 L
.79623 .94461 L
.80594 .94452 L
.81566 .94442 L
.82537 .94433 L
.83508 .94423 L
.84479 .94413 L
.85451 .94402 L
.86422 .94391 L
.87393 .9438 L
.88364 .94368 L
.89336 .94356 L
.90307 .94344 L
.91278 .94331 L
.92249 .94318 L
.93221 .94304 L
.94192 .9429 L
.95163 .94276 L
.96134 .94261 L
.97106 .94245 L
.98077 .94229 L
Mistroke
Mfstroke
.55 g
.01923 .97704 m
.02894 .977 L
.03866 .97697 L
.04837 .97695 L
.05808 .97692 L
.06779 .97689 L
.07751 .97686 L
.08722 .97684 L
.09693 .97682 L
.10664 .97679 L
.11636 .97677 L
.12607 .97675 L
.13578 .97673 L
.14549 .97671 L
.15521 .97669 L
.16492 .97668 L
.17463 .97666 L
.18434 .97665 L
.19406 .97664 L
.20377 .97662 L
.21348 .97661 L
.22319 .9766 L
.23291 .9766 L
.24262 .97659 L
.25233 .97658 L
.26204 .97658 L
.27176 .97657 L
.28147 .97657 L
.29118 .97657 L
.30089 .97657 L
.31061 .97657 L
.32032 .97657 L
.33003 .97658 L
.33974 .97658 L
.34946 .97659 L
.35917 .9766 L
.36888 .9766 L
.37859 .97661 L
.38831 .97662 L
.39802 .97664 L
.40773 .97665 L
.41744 .97667 L
.42716 .97668 L
.43687 .9767 L
.44658 .97672 L
.45629 .97674 L
.46601 .97676 L
.47572 .97679 L
.48543 .97681 L
.49514 .97684 L
.50486 .97687 L
.51457 .9769 L
.52428 .97693 L
.53399 .97696 L
.54371 .97699 L
.55342 .97703 L
.56313 .97707 L
.57284 .97711 L
.58256 .97715 L
.59227 .97719 L
.60198 .97724 L
.61169 .97729 L
.62141 .97734 L
.63112 .97739 L
.64083 .97744 L
.65054 .97749 L
.66026 .97755 L
.66997 .97761 L
.67968 .97767 L
.68939 .97774 L
.69911 .9778 L
.70882 .97787 L
.71853 .97794 L
.72824 .97802 L
.73796 .97809 L
.74767 .97817 L
.75738 .97825 L
.76709 .97834 L
.77681 .97842 L
.78652 .97851 L
.79623 .97861 L
.80594 .9787 L
.81566 .9788 L
.82537 .97891 L
.83508 .97901 L
.84479 .97912 L
.85451 .97924 L
.86422 .97935 L
.87393 .97948 L
.88364 .9796 L
.89336 .97973 L
.90307 .97986 L
.91278 .98 L
.92249 .98015 L
.93221 .98029 L
.94192 .98045 L
.95163 .9806 L
.96134 .98077 L
.96139 .98077 L
.01923 .98077 L
F
0 g
.01923 .97704 m
.02894 .977 L
.03866 .97697 L
.04837 .97695 L
.05808 .97692 L
.06779 .97689 L
.07751 .97686 L
.08722 .97684 L
.09693 .97682 L
.10664 .97679 L
.11636 .97677 L
.12607 .97675 L
.13578 .97673 L
.14549 .97671 L
.15521 .97669 L
.16492 .97668 L
.17463 .97666 L
.18434 .97665 L
.19406 .97664 L
.20377 .97662 L
.21348 .97661 L
.22319 .9766 L
.23291 .9766 L
.24262 .97659 L
.25233 .97658 L
.26204 .97658 L
.27176 .97657 L
.28147 .97657 L
.29118 .97657 L
.30089 .97657 L
.31061 .97657 L
.32032 .97657 L
.33003 .97658 L
.33974 .97658 L
.34946 .97659 L
.35917 .9766 L
.36888 .9766 L
.37859 .97661 L
.38831 .97662 L
.39802 .97664 L
.40773 .97665 L
.41744 .97667 L
.42716 .97668 L
.43687 .9767 L
.44658 .97672 L
.45629 .97674 L
.46601 .97676 L
.47572 .97679 L
.48543 .97681 L
.49514 .97684 L
Mistroke
.50486 .97687 L
.51457 .9769 L
.52428 .97693 L
.53399 .97696 L
.54371 .97699 L
.55342 .97703 L
.56313 .97707 L
.57284 .97711 L
.58256 .97715 L
.59227 .97719 L
.60198 .97724 L
.61169 .97729 L
.62141 .97734 L
.63112 .97739 L
.64083 .97744 L
.65054 .97749 L
.66026 .97755 L
.66997 .97761 L
.67968 .97767 L
.68939 .97774 L
.69911 .9778 L
.70882 .97787 L
.71853 .97794 L
.72824 .97802 L
.73796 .97809 L
.74767 .97817 L
.75738 .97825 L
.76709 .97834 L
.77681 .97842 L
.78652 .97851 L
.79623 .97861 L
.80594 .9787 L
.81566 .9788 L
.82537 .97891 L
.83508 .97901 L
.84479 .97912 L
.85451 .97924 L
.86422 .97935 L
.87393 .97948 L
.88364 .9796 L
.89336 .97973 L
.90307 .97986 L
.91278 .98 L
.92249 .98015 L
.93221 .98029 L
.94192 .98045 L
.95163 .9806 L
.96134 .98077 L
.96139 .98077 L
Mfstroke
.325 g
.01923 .21175 m
.02894 .2122 L
.03866 .21264 L
.04837 .21307 L
.05808 .21348 L
.05815 .21348 L
.06779 .21387 L
.07751 .21426 L
.08722 .21462 L
.09693 .21497 L
.10664 .21531 L
.11636 .21563 L
.12607 .21594 L
.13578 .21623 L
.14549 .21651 L
.15521 .21677 L
.16492 .21702 L
.17463 .21725 L
.18434 .21747 L
.19406 .21767 L
.20377 .21785 L
.21348 .21802 L
.22319 .21817 L
.23291 .21831 L
.24262 .21843 L
.25233 .21853 L
.26204 .21862 L
.27176 .21869 L
.28147 .21874 L
.29118 .21878 L
.30089 .2188 L
.31061 .2188 L
.32032 .21878 L
.33003 .21874 L
.33974 .21869 L
.34946 .21861 L
.35917 .21852 L
.36888 .21841 L
.37859 .21828 L
.38831 .21812 L
.39802 .21795 L
.40773 .21776 L
.41744 .21754 L
.42716 .2173 L
.43687 .21704 L
.44658 .21675 L
.45629 .21644 L
.46601 .21611 L
.47572 .21575 L
.48543 .21537 L
.49514 .21496 L
.50486 .21452 L
.51457 .21405 L
.52428 .21355 L
.52567 .21348 L
.53399 .21303 L
.54371 .21247 L
.55342 .21188 L
.56313 .21126 L
.57284 .2106 L
.58256 .2099 L
.59227 .20917 L
.60198 .2084 L
.61169 .20758 L
.62141 .20673 L
.63112 .20582 L
.64083 .20487 L
.65054 .20387 L
.65155 .20377 L
.66026 .20282 L
.66997 .20172 L
.67968 .20055 L
.68939 .19932 L
.69911 .19803 L
.70882 .19666 L
.71853 .19522 L
.72596 .19406 L
.72824 .19369 L
.73796 .19208 L
.74767 .19037 L
.75738 .18856 L
.76709 .18664 L
.77681 .18459 L
.77791 .18434 L
.78652 .1824 L
.79623 .18006 L
.80594 .17755 L
.81566 .17483 L
.81634 .17463 L
.82537 .1719 L
.83508 .1687 L
.84479 .16518 L
.84549 .16492 L
.85451 .1613 L
.86422 .15693 L
.86773 .15521 L
.87393 .15196 L
.88364 .14612 L
.88458 .14549 L
.89336 .13904 L
.89708 .13578 L
.90307 .12971 L
.90593 .12607 L
.91169 .11636 L
.91278 .11369 L
.91475 .10664 L
.91544 .09693 L
.914 .08722 L
.91278 .08189 L
.91063 .07751 L
.90549 .06779 L
.90307 .06399 L
.8987 .05808 L
.89336 .05162 L
.89037 .04837 L
.88364 .04153 L
.88058 .03866 L
.87393 .03272 L
.8694 .02894 L
.86422 .02482 L
.85688 .01923 L
.01923 .01923 L
F
0 g
.01923 .21175 m
.02894 .2122 L
.03866 .21264 L
.04837 .21307 L
.05808 .21348 L
.05815 .21348 L
.06779 .21387 L
.07751 .21426 L
.08722 .21462 L
.09693 .21497 L
.10664 .21531 L
.11636 .21563 L
.12607 .21594 L
.13578 .21623 L
.14549 .21651 L
.15521 .21677 L
.16492 .21702 L
.17463 .21725 L
.18434 .21747 L
.19406 .21767 L
.20377 .21785 L
.21348 .21802 L
.22319 .21817 L
.23291 .21831 L
.24262 .21843 L
.25233 .21853 L
.26204 .21862 L
.27176 .21869 L
.28147 .21874 L
.29118 .21878 L
.30089 .2188 L
.31061 .2188 L
.32032 .21878 L
.33003 .21874 L
.33974 .21869 L
.34946 .21861 L
.35917 .21852 L
.36888 .21841 L
.37859 .21828 L
.38831 .21812 L
.39802 .21795 L
.40773 .21776 L
.41744 .21754 L
.42716 .2173 L
.43687 .21704 L
.44658 .21675 L
.45629 .21644 L
.46601 .21611 L
.47572 .21575 L
.48543 .21537 L
Mistroke
.49514 .21496 L
.50486 .21452 L
.51457 .21405 L
.52428 .21355 L
.52567 .21348 L
.53399 .21303 L
.54371 .21247 L
.55342 .21188 L
.56313 .21126 L
.57284 .2106 L
.58256 .2099 L
.59227 .20917 L
.60198 .2084 L
.61169 .20758 L
.62141 .20673 L
.63112 .20582 L
.64083 .20487 L
.65054 .20387 L
.65155 .20377 L
.66026 .20282 L
.66997 .20172 L
.67968 .20055 L
.68939 .19932 L
.69911 .19803 L
.70882 .19666 L
.71853 .19522 L
.72596 .19406 L
.72824 .19369 L
.73796 .19208 L
.74767 .19037 L
.75738 .18856 L
.76709 .18664 L
.77681 .18459 L
.77791 .18434 L
.78652 .1824 L
.79623 .18006 L
.80594 .17755 L
.81566 .17483 L
.81634 .17463 L
.82537 .1719 L
.83508 .1687 L
.84479 .16518 L
.84549 .16492 L
.85451 .1613 L
.86422 .15693 L
.86773 .15521 L
.87393 .15196 L
.88364 .14612 L
.88458 .14549 L
.89336 .13904 L
Mistroke
.89708 .13578 L
.90307 .12971 L
.90593 .12607 L
.91169 .11636 L
.91278 .11369 L
.91475 .10664 L
.91544 .09693 L
.914 .08722 L
.91278 .08189 L
.91063 .07751 L
.90549 .06779 L
.90307 .06399 L
.8987 .05808 L
.89336 .05162 L
.89037 .04837 L
.88364 .04153 L
.88058 .03866 L
.87393 .03272 L
.8694 .02894 L
.86422 .02482 L
.85688 .01923 L
Mfstroke
.25 g
.01923 .13818 m
.02894 .13871 L
.03866 .13921 L
.04837 .13968 L
.05808 .14013 L
.06779 .14055 L
.07751 .14095 L
.08722 .14132 L
.09693 .14166 L
.10664 .14198 L
.11636 .14226 L
.12607 .14252 L
.13578 .14275 L
.14549 .14296 L
.15521 .14313 L
.16492 .14327 L
.17463 .14338 L
.18434 .14347 L
.19406 .14351 L
.20377 .14353 L
.21348 .14351 L
.22319 .14346 L
.23291 .14338 L
.24262 .14326 L
.25233 .1431 L
.26204 .1429 L
.27176 .14267 L
.28147 .14239 L
.29118 .14207 L
.30089 .14171 L
.31061 .14131 L
.32032 .14085 L
.33003 .14035 L
.33974 .1398 L
.34946 .13919 L
.35917 .13852 L
.36888 .1378 L
.37859 .13701 L
.38831 .13616 L
.39237 .13578 L
.39802 .13524 L
.40773 .13424 L
.41744 .13316 L
.42716 .132 L
.43687 .13074 L
.44658 .12938 L
.45629 .1279 L
.46601 .12631 L
.46738 .12607 L
.47572 .12458 L
.48543 .1227 L
.49514 .12065 L
.50486 .1184 L
.51289 .11636 L
.51457 .11591 L
.52428 .11318 L
.53399 .1101 L
.54359 .10664 L
.54371 .1066 L
.55342 .10261 L
.56313 .09783 L
.56474 .09693 L
.57284 .09201 L
.57897 .08722 L
.58256 .08422 L
.58782 .07751 L
.59227 .06779 L
.59227 .06779 L
.59298 .05808 L
.59227 .05393 L
.59043 .04837 L
.58497 .03866 L
.58256 .03526 L
.57684 .02894 L
.57284 .02542 L
.56623 .01923 L
.01923 .01923 L
F
0 g
.01923 .13818 m
.02894 .13871 L
.03866 .13921 L
.04837 .13968 L
.05808 .14013 L
.06779 .14055 L
.07751 .14095 L
.08722 .14132 L
.09693 .14166 L
.10664 .14198 L
.11636 .14226 L
.12607 .14252 L
.13578 .14275 L
.14549 .14296 L
.15521 .14313 L
.16492 .14327 L
.17463 .14338 L
.18434 .14347 L
.19406 .14351 L
.20377 .14353 L
.21348 .14351 L
.22319 .14346 L
.23291 .14338 L
.24262 .14326 L
.25233 .1431 L
.26204 .1429 L
.27176 .14267 L
.28147 .14239 L
.29118 .14207 L
.30089 .14171 L
.31061 .14131 L
.32032 .14085 L
.33003 .14035 L
.33974 .1398 L
.34946 .13919 L
.35917 .13852 L
.36888 .1378 L
.37859 .13701 L
.38831 .13616 L
.39237 .13578 L
.39802 .13524 L
.40773 .13424 L
.41744 .13316 L
.42716 .132 L
.43687 .13074 L
.44658 .12938 L
.45629 .1279 L
.46601 .12631 L
.46738 .12607 L
.47572 .12458 L
Mistroke
.48543 .1227 L
.49514 .12065 L
.50486 .1184 L
.51289 .11636 L
.51457 .11591 L
.52428 .11318 L
.53399 .1101 L
.54359 .10664 L
.54371 .1066 L
.55342 .10261 L
.56313 .09783 L
.56474 .09693 L
.57284 .09201 L
.57897 .08722 L
.58256 .08422 L
.58782 .07751 L
.59227 .06779 L
.59227 .06779 L
.59298 .05808 L
.59227 .05393 L
.59043 .04837 L
.58497 .03866 L
.58256 .03526 L
.57684 .02894 L
.57284 .02542 L
.56623 .01923 L
Mfstroke
0 0 0 r
.055 w
.51129 .69696 Mdot
0 1 1 r
.045 w
.01923 .01923 Mdot
.6819 .6819 Mdot
.51914 .69728 Mdot
.51131 .69696 Mdot
.51129 .69696 Mdot
1 0 0 r
.0325 w
.01923 .01923 Mdot
.03054 .03054 Mdot
.07579 .07579 Mdot
.25679 .25679 Mdot
.98077 .98077 Mdot
.56834 .56834 Mdot
.7368 .7368 Mdot
.6819 .6819 Mdot
.51914 .69728 Mdot
.51131 .69696 Mdot
.51129 .69696 Mdot
0 1 0 r
.02 w
.01923 .01923 Mdot
.03054 .03054 Mdot
.07579 .07579 Mdot
.25679 .25679 Mdot
.98077 .98077 Mdot
.56834 .56834 Mdot
.7368 .7368 Mdot
.6819 .6819 Mdot
.51914 .69728 Mdot
.51131 .69696 Mdot
.51129 .69696 Mdot
0 0 1 r
.5 Mabswid
.01923 .01923 m
.01923 .01923 L
.6819 .6819 L
.51914 .69728 L
.51131 .69696 L
.51129 .69696 L
s
.015 w
.01923 .01923 Mdot
.01923 .01923 Mdot
.6819 .6819 Mdot
.51914 .69728 Mdot
.51131 .69696 Mdot
.51129 .69696 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`005P3oool02P3ookl0M0000000
00000000001809cOo`3oool0oono07@00000B9`20?ooo`060?noM000000000000000000007@0_ooo
3P3oool02P3ookl0M000000000000000001809cOo`3oool0oono07@00000B9`20?ooo`080?noM000
000000000000000007@0_ooo0?ooo`3OW4P20000000304RLg`3oool0oooo00d0oooo00X0oono07@0
0000000000000000B02Lgol0oooo0?oo_`1d000004RL0`3oool0103OW4P0000000000000M;l?0?oo
o`0:0?oo_`1d000000000000000004P0W=oo0?ooo`3ookl0M0000018W0<0oooo00@0gia800000000
000007Bo0P3oool0103OW4P0000000000018W=l>0?ooo`0:0?oo_`1d000000000000000004P0W=oo
0?ooo`3ookl0M0000018W0@0oooo00@0gia80000000004P0W=oo3P3oool02P3ookl0M00000000000
0000001809cOo`3oool0oono07@00000B9`40?ooo`060=nLB0000000001809cOo`3oool0gia80P00
00000`18W=l0oooo0?ooo`0=0?ooo`0:0?oo_`1d000000000000000004P0W=oo0?ooo`3ookl0M000
0018W0<0oooo00@0gia8000000000000B9cO3`3oool02P3ookl0M000000000000000001809cOo`3o
ool0oono07@00000B9`30?ooo`040=nLB0000000000004RLg`80oooo00@0gia8000000000000B9cO
0P3oool001P0oooo00<0okmd04RLg`3oool0203oool00`2LB000001d0;ooo`0B0?ooo`030?noM018
W=l0oooo00P0oooo00<0W4P00000M02oool00P3oool01P3ogi`0B4RL0?ooo`3oool0W4Q809cOoa00
oooo00<0okmd04RLg`3oool01`3oool01P3ogi`0B4RL0?ooo`3ookl0M01809cOoa00oooo00<0okmd
04RLg`3oool01`3oool0203ogi`0B4RL0?ooo`3ookl0M01809cOo`3ogi`0B4RL0P3oool00`2LB4P0
W=oo0?ooo`0>0?ooo`030?noM018W=l0oooo00X0oooo00<0okmd04RLg`3oool0403oool00`3o_g@0
B9cO0?ooo`0:0?ooo`050?noM018W=l0oooo0?oOW018B9`00P3oool00`2LB4P0W=oo0?ooo`0?0?oo
o`030?noM018W=l0oooo00L0oooo00H0omnL04Q8W03oool0oooo09a8B02Lgol@0?ooo`030?noM018
W=l0oooo00L0oooo00P0omnL04Q8W03oool0oooo09a8B02Lgol0omnL04Q8W080oooo0@2LB4P109cO
o`40oooo000H0?ooo`030?noM018W=l0oooo00T0oooo00<0okmd0000001d_ol04@3oool00`3o_g@0
B9cO0?ooo`090?ooo`030?noM0000000M;oo00D0oooo00<0_gA809cOo`3oool03`3oool00`3o_g@0
B9cO0?ooo`090?ooo`030;md00000000M;oo0140oooo00<0okmd04RLg`3oool02@3oool00`2oM000
000007Boo`050?ooo`030;mdB02Lgol0oooo00h0oooo00<0okmd04RLg`3oool01`3oool01P3ookl0
M000000000000000001809cOoa00oooo00<0okmd04RLg`3oool01`3oool01P3ookl0M00000000000
0000001809cOo`@0oooo00<0_gA809cOo`3oool03`3oool00`3o_g@0B9cO0?ooo`0;0?ooo`030;md
B02Lgol0oooo00l0oooo00<0okmd04RLg`3oool02`3oool00`2oM4P0W=oo0?ooo`030?ooo`40_gA8
0@2Lgol10?ooo`00603oool00`3o_g@0B9cO0?ooo`0:0?ooo`030?oo_`2o_ol0oooo0100oooo00<0
okmd04RLg`3oool02P3oool01@3ookl0_koo0?ooo`3oool0_g@00080000000<007Bo0?ooo`3oool0
3`3oool00`3o_g@0B9cO0?ooo`0:0?ooo`030?oo_`1dB9`0oooo0100oooo00<0okmd04RLg`3oool0
2P3oool01@3ookl0M4RL0?ooo`3oool0_g@00080000000<007Bo0?ooo`3oool03P3oool00`3o_g@0
B9cO0?ooo`080?ooo`040;md001d_ol0okmd04RLga40oooo00<0okmd04RLg`3oool0203oool0102o
M000M;oo0?noM018W=l20?ooo`040;md000000000000001d_a40oooo00<0okmd04RLg`3oool0203o
ool0102oM000000000000000M;lA0?ooo`030?noM018W=l0oooo00P0oooo00@0_g@0000000000000
07Bo0P3oool0102oM000000000000000M;l20?ooo`005`3oool00`2LB7@0_kmd04RLg`080?ooo`06
0?oOW018B9`0oooo0?oo_`1d07@0_ooo3`3oool00`2LB7@0_kmd04RLg`080?ooo`090?oOW018B9`0
oooo0?oo_`1d07@0_ooo0?ooo`2oM4P0W=oo0180oooo00<0W4Qd0;noM018W=l0203oool01P3ookl0
M01809cOo`3ookl0M01d0;ooo`l0oooo00<0W4Qd0;noM018W=l0203oool02@3ookl0M01809cOo`3o
okl0M01d0;ooo`3oool0_gA809cOo`0A0?ooo`0309a8M02o_g@0B9cO00T0oooo00@0oono07@0B02L
W7@0B9cO403oool00`2LB7@0_kmd04RLg`090?ooo`040?oo_`1d04P0W9ad04RLg`80oooo00<0_gA8
09cOo`3oool04@3oool00`2LB7@0_kmd04RLg`090?ooo`030;mdB02Lgol0oooo0140oooo00<0W4Qd
0;noM018W=l02@3oool00`2oM4P0W=oo0?ooo`030?ooo`030;mdB02Lgol0oooo00<0oooo000G0?oo
o`030?noM0000000B9cO00T0oooo00@0gia8000000000000B9cO403oool00`3o_g@0000004RLg`09
0?ooo`040=nLB0000000000004RLg`80oooo00@0_g@000000000000007Bo403oool00`3o_g@00000
04RLg`090?ooo`040?oOW0180000000007Booa00oooo00<0okmd00000018W=l02@3oool0103ogi`0
B0000000001d_ol20?ooo`040;md000000000000001d_`l0oooo00<0okmd00000018W=l02P3oool0
0`3ogi`0B00004RLg`0@0?ooo`030?noM0000000B9cO00X0oooo00<0omnL04P00018W=l00P3oool0
102oM000000000000000M;l@0?ooo`030?noM0000000B9cO00T0oooo00@0_g@000000000000007Bo
403oool00`3o_g@0000004RLg`090?ooo`040;md000000000000001d_`80oooo00@0_g@000000000
000007Bo0P3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool001/0oooonP00000;0?ooo`006`3oool4003oo`80o`000`00
oolN0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`0P0?ooo`8000002`3oool000L0oooo00@0gia8000000000000B9cO0P3oool00`3ookl0M0000018
W0030?ooo`040=nLB0000000000004RLg`@0oooo0P00ool60?l00003003oo`3oool0oooo0>h0oooo
00<000000?ooo`3oool02@3oool000L0oooo00D0W7BL0?ooo`3oool0W4Qd0;ooo`060?ooo`060?oO
W018B9`0oooo0?ooo`2LB4P0W=oo0`3oool2003oo`030?l00000o`000?l000<0o`000P00ooo_0?oo
o`030000003oool0oooo00T0oooo00060?ooo`060?oo_`1dB9`0oooo0?ooo`2oM4P0W=oo2P3oool0
0`2oM4P0W=oo0?ooo`020?ooo`04003oo`3o00000?l0003o0080003o0`3o00000`00ool0oooo0?oo
o`210?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool07`3oool3000000/0oooo0006
0?ooo`060?oo_`1dB9`0oooo0?ooo`2oM4P0W=oo1`3oool0102oM000000000000000M;l40?ooo`03
003oo`3o00000?l000<0003o1@3o002203lo?`030000001CDe<0De=C04H0De=C00<0000006IVIP1V
IVH06`1VIVH50?ooo`030000003oool0oooo00T0oooo00070?ooo`0509a8B02Lgol0oono07@0M02o
ool01`3oool00`2oM4P0W=oo0?ooo`050?ooo`800?oo00H0o`00003o00000?l0o`000000o`00o`03
0?l008<0?clo00<0000005=CD`1CDe<0AP1CDe<00`000000IVIV06IVIP0J06IVIPD0oooo00<00000
0?ooo`3oool02@3oool000L0oooo00@0omnL04P000000000M;oo203oool0102oM000000000000000
M;l40?ooo`800?oo0`3o0002003o00030000o`00o`00o`000080o`00P`0o?cl00`000000De=C05=C
D`1605=CD`030000001VIVH0IVIV01T0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool0
1@0000000?oo003oo`00ool0o`0000<00?l000@0003o0?l0003o0000o`00Q00o?cl2000004L0De=C
00<0000006IVIP1VIVH0601VIVH50?ooo`030000003oool0oooo00T0oooo000K0?ooo`030000003o
ool0oooo00800?oo00H0o`00003o0000o`00o`000000o`3o002603lo?`030000001CDe<0De=C04H0
De=C0P00000H06IVIPD0oooo00<000000?ooo`3oool02@3oool001/0oooo00D000000?ooo`3oool0
oooo03lo?`050?l000030000o`0o?cl0?clo08D0?clo00<0000005=CD`1CDe<0A`1CDe<00`000000
IVIV06IVIP0E06IVIPD0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0
oooo0`0o?cl20?l00080?clo00<0003o03lo?`0o?cl0Q00o?cl00`000000De=C05=CD`1705=CD`03
0000001VIVH0IVIV01D0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool200000080oooo
200o?cl00`000?l0?clo03lo?`2403lo?`030000001CDe<0De=C04L0De=C0P00000E06IVIP@0oooo
0P00000;0?ooo`006`3oool010000000oooo0?ooo`3oool903lo?`030000o`0o?cl0?clo08<0?clo
00<0000005=CD`1CDe<0B01CDe<00`000000IVIV06IVIP0C06IVIPD0oooo00<000000?ooo`3oool0
2@3oool001/0oooo00@000000?ooo`3oool0oooo2P0o?cl00`000?l0?clo03lo?`2203lo?`030000
001CDe<0De=C04T0De=C00<0000006IVIP1VIVH04P1VIVH50?ooo`030000003oool0oooo00T0oooo
000K0?ooo`040000003oool0oooo0?ooo`/0?clo00<0003o03lo?`0o?cl00P3o001o03lo?`030000
001CDe<0De=C04X0De=C00<0000006IVIP1VIVH04@1VIVH50?ooo`030000003oool0oooo00T0oooo
000K0?ooo`040000003oool0oooo0?ooo``0?clo00<0003o0?l0003o00000`3o001m03lo?`030000
001CDe<0De=C04/0De=C00<0000006IVIP1VIVH0401VIVH50?ooo`030000003oool0oooo00T0oooo
000K0?ooo`040000003oool0oooo0?ooo``0?clo00@0o`000000o`00o`000?l00P3o001m03lo?`03
0000001CDe<0De=C04/0De=C00<0000006IVIP1VIVH0401VIVH50?ooo`030000003oool0oooo00T0
oooo000K0?ooo`040000003oool0oooo0?ooo`/0?clo0P3o00001000o`00003o003o0000o`020?l0
07/0?clo00<0000005=CD`1CDe<0C@1CDe<00`000000IVIV06IVIP0?06IVIPD0oooo00<000000?oo
o`3oool02@3oool001/0oooo0P0000020?ooo`/0?clo0P3o0002003o00040000o`00o`00o`000?l0
07/0?clo00<0000005=CD`1CDe<0C@1CDe<00`000000IVIV06IVIP0?06IVIP@0oooo0P00000;0?oo
o`006`3oool010000000oooo0?ooo`3oool<03lo?`80o`000P00o`000`000?l0o`0003lo?`1j03lo
?`030000001CDe<0De=C04l0De=C00<0000006IVIP1VIVH03P1VIVH50?ooo`030000003oool0oooo
00T0oooo000K0?ooo`040000003oool0oooo0?ooo``0?clo1@3o00000`000?l0?clo03lo?`1h03lo
?`800000D@1CDe<00`000000IVIV06IVIP0>06IVIPD0oooo00<000000?ooo`3oool02@3oool001/0
oooo00@000000?ooo`3oool0oooo3P0o?cl20?l00080?clo00<0003o03lo?`0o?cl0M@0o?cl20000
05<0De=C00<0000006IVIP1VIVH03P1VIVH50?ooo`030000003oool0oooo00T0oooo000K0?ooo`04
0000003oool0oooo0?oooa<0?clo00<0003o03lo?`0o?cl0L`0o?cl00`000000De=C05=CD`1D05=C
D`030000001VIVH0IVIV00d0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000
oooo0?ooo`3ooolD03lo?`030000o`0o?cl0?clo0700?clo0P00001G05=CD`030000001VIVH0IVIV
00d0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolE03lo
?`030000o`0o?cl0?clo06d0?clo0P00001H05=CD`030000001VIVH0IVIV00h0IVIV1@3oool00`00
0000oooo0?ooo`090?ooo`006`3oool200000080oooo5P0o?cl00`000?l0?clo03lo?`1Z03lo?`80
0000FP1CDe<00`000000IVIV06IVIP0>06IVIP@0oooo0P00000;0?ooo`006`3oool010000000oooo
0?ooo`3ooolG03lo?`030000o`0o?cl0?clo06H0?clo0`00001L05=CD`030000001VIVH0IVIV00h0
IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolH03lo?`03
0000o`0o?cl0?clo0640?clo1000001O05=CD`030000001VIVH0IVIV00h0IVIV1@3oool00`000000
oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolI03lo?`030000o`0o?cl0?clo05d0
?clo0`00001S05=CD`030000001VIVH0IVIV00h0IVIV1@3oool00`000000oooo0?ooo`090?ooo`00
6`3oool010000000oooo0?ooo`3ooolJ03lo?`030000o`0o?cl0?clo05L0?clo1@00001U05=CD`03
0000001VIVH0IVIV00l0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo
0?ooo`3ooolK03lo?`030000o`0o?cl0?clo04l0?clo1`00001Y05=CD`030000001VIVH0IVIV0100
IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolL03lo?`03
0000o`0o?cl0?clo04L0?clo1`00001_05=CD`030000001VIVH0IVIV0140IVIV1@3oool00`000000
oooo0?ooo`090?ooo`006`3oool200000080oooo7@0o?cl00`000?l0?clo03lo?`0l03lo?`X00000
M@1CDe<00`000000IVIV06IVIP0B06IVIP@0oooo0P00000;0?ooo`006`3oool010000000oooo0?oo
o`3oool;000001<0?clo00<0003o03lo?`0o?cl0;`0o?cl<000007h0De=C00<0000006IVIP1VIVH0
4`1VIVH50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooo`/0De=C
500000000`000?l000000000000^000008T0De=C00<0000006IVIP1VIVH0501VIVH50?ooo`030000
003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooob00De=C00<0003o05=CD`1CDe<0
]01CDe<2000001L0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?oo
o`3ooolQ05=CD`030000o`1CDe<0De=C0;40De=C0P00000I06IVIPD0oooo00<000000?ooo`3oool0
2@3oool000050?ooo`3OW4P0000000000018W=l00P3oool00`3ookl0M0000018W0040?ooo`030=nL
B01d_ol0oooo0080oooo00@0gia8000000000000B9cO103oool010000000oooo0?ooo`3ooolR05=C
D`030000o`1CDe<0De=C0:l0De=C00<0000006IVIP1VIVH06@1VIVH50?ooo`030000003oool0oooo
00T0oooo00001P3oool0W7BL0?ooo`3oool0W4Qd0;ooo`P0oooo00H0oono07Ad_`3oool0oooo0?oO
W018B9`20?ooo`0309a8B02Lgol0oooo0080oooo00@000000?ooo`3oool0oooo8`1CDe<00`000?l0
De=C05=CD`2/05=CD`800000701VIVH50?ooo`030000003oool0oooo00T0oooo00001P3ookl0M4RL
0?ooo`3oool0_gA809cOo`T0oooo00<0_gAd0;ooo`3oool0103oool00`2oM4P0W=oo0?ooo`020?oo
o`8000000P3ooolT05=CD`030000o`1CDe<0De=C0:T0De=C0P00000N06IVIP<0oooo0`00000;0?oo
o`0000H0oono07A8W03oool0oooo0;mdB02Lgol90?ooo`050?noM018W=l0oooo0?ooo`2oM0000P00
00000`00M;l0oooo0?ooo`020?ooo`040000003oool0oooo0?ooobD0De=C00<0003o05=CD`1CDe<0
YP1CDe<200000200IVIV1@3oool00`000000oooo0?ooo`090?ooo`0000H0oooo09a8B02Lgol0oono
07@0M02oool60?ooo`050?oOW018M;l0oooo0?oo_`1dB9`00P3oool00`2oM4P0W=oo0?ooo`050?oo
o`040000003oool0oooo0?ooobH0De=C00<0003o05=CD`1CDe<0X01CDe<500000280IVIV1@3oool0
0`000000oooo0?ooo`090?ooo`0000D0oooo0?oOW0180000000007Boo`070?ooo`080?oOW0180000
00000000000007@0_ooo0?ooo`2oM00200000003001d_`3oool0oooo0080oooo00@000000?ooo`3o
ool0oooo9`1CDe<00`000?l0De=C05=CD`2L05=CD`<000009`1VIVH50?ooo`030000003oool0oooo
00T0oooo000K0?ooo`040000003oool0oooo0?ooobP0De=C00<0003o05=CD`1CDe<0UP1CDe<50000
02X0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolY05=C
D`030000o`1CDe<0De=C0940De=C1000000_06IVIPD0oooo00<000000?ooo`3oool02@3oool001/0
oooo00@000000?ooo`3oool0oooo:P1CDe<00`000?l0De=C05=CD`2=05=CD`@00000<P1VIVH50?oo
o`030000003oool0oooo00T0oooo000K0?ooo`8000000P3oool[05=CD`030000o`1CDe<0De=C08D0
De=C1`00000f06IVIP@0oooo0P00000;0?ooo`006`3oool010000000oooo0?ooo`3oool/05=CD`03
0000o`1CDe<0De=C07l0De=C1@00000m06IVIPD0oooo00<000000?ooo`3oool02@3oool001/0oooo
00@000000?ooo`3oool0oooo;@1CDe<00`000?l0De=C05=CD`1d05=CD`X00000@P1VIVH50?ooo`03
0000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooobh0De=C00<0003o05=CD`1C
De<0K01CDe<7000004`0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo
0?ooo`3oool_05=CD`030000o`1CDe<0De=C05l0De=C3000001C06IVIPD0oooo00<000000?ooo`3o
ool02@3oool001/0oooo00@000000?ooo`3oool0oooo1000000605=CD`030000001CDe<0De=C02<0
De=C00<0003o05=CD`1CDe<0D01CDe<>000005l0IVIV1@3oool00`000000oooo0?ooo`090?ooo`00
6`3oool010000000oooo0?ooo`3oool406IVIQd00000401CDe<00`000?l0De=C05=CD`0i05=CDaH0
0000K@1VIVH50?ooo`030000003oool0oooo00T0oooo000K0?ooo`8000000P3ooolQ06IVIQ400000
00<0003o000000000000>000002306IVIP@0oooo0P00000;0?ooo`006`3oool010000000oooo0?oo
o`3ooolc06IVIP030000o`1VIVH0IVIV0;X0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3o
ool010000000oooo0?ooo`3ooold06IVIP030000o`1VIVH0IVIV0;T0IVIV1@3oool00`000000oooo
0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooole06IVIP030000o`1VIVH0IVIV0;P0IVIV
1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolf06IVIP030000
o`1VIVH0IVIV0;L0IVIV1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?oo
o`3ooolg06IVIP030000o`1VIVH0IVIV0;<0IVIV100000040?ooo`030000003oool0oooo00T0oooo
000K0?ooo`040000003oool0oooo0?ooocP0IVIV00<0003o06IVIP1VIVH00P3o002Y06IVIPL00000
0`1iNGT50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooocT0IVIV
00<0003o0?l0003o00000`3o002R06IVIPD000002P1iNGT50?ooo`030000003oool0oooo00T0oooo
000K0?ooo`8000000P3oooli06IVIP040?l000000?l00?l0003o0080o`00V01VIVH:000000l0NGUi
103oool2000000/0oooo000K0?ooo`040000003oool0oooo0?ooocP0IVIV0P3o00001000o`00003o
003o0000o`020?l008h0IVIV2@00000I07UiN@D0oooo00<000000?ooo`3oool02@3oool001/0oooo
00@000000?ooo`3oool0oooo>01VIVH20?l000800?l000@0003o003o003o0000o`00Q01VIVH:0000
0280NGUi1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3oooli06IV
IP80o`000P00o`000`000?l0o`0006IVIP1e06IVIPl00000;01iNGT50?ooo`030000003oool0oooo
00T0oooo000K0?ooo`040000003oool0oooo0?ooo`@00000=@1VIVH50?l000030000o`1VIVH0IVIV
0640IVIV4`00000k07UiN@D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3o
ool0oooo101iNGTU00000180IVIV0P3o000206IVIP030000o`1VIVH0IVIV0440IVIV7`00001>07Ui
N@D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0oooo:@1iNGTG0000
00030000o`000000000004000000K@1iNGT50?ooo`030000003oool0oooo00T0oooo000K0?ooo`80
00000P3ooom107UiN@030000o`1iNGT0NGUi0:`0NGUi103oool2000000/0oooo000K0?ooo`040000
003oool0oooo0?oood80NGUi00<0003o07UiN@1iNGT0Z`1iNGT50?ooo`030000003oool0oooo00T0
oooo000K0?ooo`040000003oool0oooo0?oood<0NGUi00<0003o07UiN@1iNGT0ZP1iNGT50?ooo`03
0000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oood@0NGUi00<0003o07UiN@1i
NGT0Z@1iNGT50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooodD0
NGUi00<0003o07UiN@1iNGT0Z01iNGT50?ooo`030000003oool0oooo00T0oooo000B0?ooo`060?oo
_`1d000000000000000004P0W=oo0`3oool010000000oooo0?ooo`3ooom607UiN@030000o`1iNGT0
NGUi0:L0NGUi1@3oool00`000000oooo0?ooo`090?ooo`00503oool00`3o_g@0B9cO0?ooo`040?oo
o`040000003oool0oooo0?ooodL0NGUi00<0003o07UiN@1iNGT0YP1iNGT50?ooo`030000003oool0
oooo00T0oooo000D0?ooo`030?noM018W=l0oooo00@0oooo0P0000020?ooodP0NGUi00<0003o07Ui
N@1iNGT0XP1iNGT400000080oooo0`00000;0?ooo`00503oool00`3o_g@0B9cO0?ooo`040?ooo`04
0000003oool0oooo0?ooodT0NGUi00<0003o07UiN@1iNGT0SP1iNGTC000000<0S8b<1@3oool00`00
0000oooo0?ooo`090?ooo`004`3oool00`2LB7@0_kmd04RLg`050?ooo`040000003oool0oooo0?oo
odX0NGUi00<0003o07UiN@1iNGT0M01iNGTI000001H0S8b<1@3oool00`000000oooo0?ooo`090?oo
o`004`3oool00`3o_g@0000004RLg`050?ooo`040000003oool0oooo0?ooobd000007P1iNGT00`00
0?l0NGUi07UiN@1807UiNB/00000;`2<S8`50?ooo`030000003oool0oooo00T0oooo000K0?ooo`04
0000003oool0oooo0?ooobd0S8b<7`0000000`000?l0000000000017000005X0S8b<1@3oool00`00
0000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooom=08b<S0030000o`2<S8`0S8b<
0:00S8b<1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooom>08b<
S0030000o`2<S8`0S8b<09l0S8b<1@3oool00`000000oooo0?ooo`090?ooo`006`3oool200000080
ooooC`2<S8`00`000?l0S8b<08b<S02N08b<S0@0oooo0P00000;0?ooo`006`3oool010000000oooo
0?ooo`3ooom@08b<S0030000o`2<S8`0S8b<09d0S8b<1@3oool00`000000oooo0?ooo`090?ooo`00
6`3oool010000000oooo0?ooo`3ooomA08b<S0030000o`2<S8`0S8b<09`0S8b<1@3oool00`000000
oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooomB08b<S0030000o`2<S8`0S8b<09/0
S8b<1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooomC08b<S003
0000o`2<S8`0S8b<09X0S8b<1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo
0?ooo`3ooomD08b<S0030000o`2<S8`0S8b<09T0S8b<1@3oool00`000000oooo0?ooo`090?ooo`00
6`3oool010000000oooo0?ooo`3ooomE08b<S0030000o`2<S8`0S8b<09P0S8b<1@3oool00`000000
oooo0?ooo`090?ooo`006`3oool200000080oooo9000000b08b<S0030000o`2<S8`0S8b<05D0S8b<
@`0000030?ooo`8000002`3oool001/0oooo00@000000?ooo`3oool0oooo902OWilc000000030000
o`000000000005@00000@P2OWil50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003o
ool0oooo0?oooeP0WinO00<0003o09nOW`2OWil0U@2OWil50?ooo`030000003oool0oooo00T0oooo
000K0?ooo`040000003oool0oooo0?oooeT0WinO00<0003o09nOW`2OWil0U02OWil50?ooo`030000
003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oooeX0WinO00<0003o09nOW`2OWil0
T`2OWil50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oooe/0WinO
00<0003o09nOW`2OWil0TP2OWil50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003o
ool0oooo0?oooe`0WinO00<0003o09nOW`2OWil0T@2OWil50?ooo`030000003oool0oooo00T0oooo
000K0?ooo`8000000P3ooomM09nOW`030000o`2OWil0WinO0900WinO103oool2000000/0oooo000K
0?ooo`040000003oool0oooo0?oooeh0WinO00<0003o09nOW`2OWil0S`2OWil50?ooo`030000003o
ool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oooel0WinO00<0003o09nOW`2OWil0SP2O
Wil50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooof00WinO00<0
003o09nOW`2OWil0S@2OWil50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0
oooo0?ooo`D0WinOG00000000`000?l000000000001`000001`0WinO1@3oool00`000000oooo0?oo
o`090?ooo`006`3oool010000000oooo0?ooo`3oool5000005d0/k>c00<0003o0;>c/`2c/k<0K`2c
/k<M000000@0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooH`2c
/k<00`000?l0/k>c0;>c/`2:0;>c/`D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@00000
0?ooo`3oool0ooooI02c/k<00`000?l0/k>c0;>c/`290;>c/`D0oooo00<000000?ooo`3oool02@3o
ool001/0oooo0P0000020?ooofD0/k>c00<0003o0;>c/`2c/k<0R02c/k<40?ooo`8000002`3oool0
01/0oooo00@000000?ooo`3oool0ooooIP2c/k<00`000?l0/k>c0;>c/`270;>c/`D0oooo00<00000
0?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooI`2c/k<00`000?l0/k>c0;>c/`26
0;>c/`D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooJ02c/k<0
0`000?l0/k>c0;>c/`250;>c/`D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?oo
o`3oool0ooooJ@2c/k<00`000?l0/k>c0;>c/`240;>c/`D0oooo00<000000?ooo`3oool02@3oool0
000:0?oo_`1d000000000000000004P0W=oo0?ooo`3ookl0M0000018W080oooo00P0okmd00000000
000000000000M02oool0oooo0=nLB080000000<0B9cO0?ooo`3oool00P3oool010000000oooo0?oo
o`3ooomZ0;>c/`030000o`2c/k<0/k>c08<0/k>c1@3oool00`000000oooo0?ooo`090?ooo`000P3o
ool00`3o_g@0B9cO0?ooo`080?ooo`0309a8000007@0_ooo0080oooo00H0omnL04Q8W03oool0oooo
09a8B02Lgol30?ooo`040000003oool0oooo0?oooe00/k>c6`0000000`000?l000000000000a0000
0540/k>c1@3oool00`000000oooo0?ooo`090?ooo`000P3oool00`3o_g@0B9cO0?ooo`090?ooo`03
0?noM0000000M;oo00D0oooo00<0_gA809cOo`3oool00P3oool200000080oooo4`2c/k<m000001`0
a/K600<0003o0<K6aP36a/H0<036a/He000001`0/k>c0`3oool3000000/0oooo00020?ooo`030?no
M018W=l0oooo00X0oooo00D0oono0;noo`3oool0oooo0;md000200000003001d_`3oool0oooo0080
oooo00@000000?ooo`3oool0oooo4`00001J0<K6aP030000o`36a/H0a/K606@0a/K66`0000000`2c
/k<0oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0000103oool0W4Qd0;noM018W=l80?oo
o`090?oOW018B9`0oooo0?oo_`1d07@0_ooo0?ooo`2oM4P0W=oo00H0oooo00@000000?ooo`3oool0
ooooKP36a/H00`000?l0a/K60<K6aP1n0<K6aP800000103oool00`000000oooo0?ooo`090?ooo`00
00@0oooo0?noM0000000B9cO2@3oool0103OW4P0000000000018W=l20?ooo`040;md000000000000
001d_`@0oooo00@000000?ooo`3oool0ooooK`36a/H00`000?l0a/K60<K6aP1n0<K6aPD0oooo00<0
00000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooL036a/H00`000?l0a/K60<K6
aP1m0<K6aPD0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooL@36
a/H00`000?l0a/K60<K6aP1l0<K6aPD0oooo00<000000?ooo`3oool02@3oool001/0oooo00@00000
0?ooo`3oool0ooooLP36a/H00`000?l0a/K60<K6aP1k0<K6aPD0oooo00<000000?ooo`3oool02@3o
ool001/0oooo0P0000020?ooog<0a/K600<0003o0<K6aP36a/H0NP36a/H40?ooo`8000002`3oool0
01/0oooo00@000000?ooo`3oool0ooooM036a/H00`000?l0a/K60<K6aP1i0<K6aPD0oooo00<00000
0?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooM@36a/H00`000?l0a/K60<K6aP1h
0<K6aPD0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooB@36a/H]
000000030000o`000000000003D00000@P36a/H50?ooo`030000003oool0oooo00T0oooo000K0?oo
o`040000003oool0oooo0?ooobL0a/K68P00000^0=WIf@030000o`3IfMT0fMWI03@0fMWI7@00000U
0<K6aPD0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0oooo3P36a/HI
00000540fMWI00<0003o0=WIf@3IfMT0D03IfMTC00000180a/K61@3oool00`000000oooo0?ooo`09
0?ooo`006`3oool010000000oooo0?ooo`3oool>000006/0fMWI00<0003o0=WIf@3IfMT0HP3IfMTA
000000030<K6aP3oool0oooo00<0oooo00<000000?ooo`3oool02@3oool001/0oooo0P0000020?oo
ogX0fMWI00<0003o0=WIf@3IfMT0LP3IfMT2000000<0oooo0P00000;0?ooo`006`3oool010000000
oooo0?ooo`3ooomk0=WIf@030000o`3IfMT0fMWI0780fMWI1@3oool00`000000oooo0?ooo`090?oo
o`006`3oool010000000oooo0?ooo`3oooml0=WIf@030000o`3IfMT0fMWI0740fMWI1@3oool00`00
0000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooomm0=WIf@030000o`3IfMT0fMWI
0700fMWI1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooomn0=WI
f@030000o`3IfMT0fMWI06l0fMWI1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000
oooo0?ooo`3ooomo0=WIf@030000o`3IfMT0fMWI06h0fMWI1@3oool00`000000oooo0?ooo`090?oo
o`006`3oool010000000oooo0?ooo`3ooon00=WIf@030000o`3IfMT0fMWI06d0fMWI1@3oool00`00
0000oooo0?ooo`090?ooo`006`3oool200000080ooooP@3IfMT00`000?l0fMWI0=WIf@1/0=WIf@@0
oooo0P00000;0?ooo`006`3oool010000000oooo0?ooo`3ooom=0=WIfCD0000000<0003o00000000
0000:@0000120=WIf@D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0
oooo=@3IfMTH000003H0k>c/00<0003o0>c/k03/k>`0:03/k>`E000002d0fMWI1@3oool00`000000
oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolT0=WIfA400000C`3/k>`00`000?l0
k>c/0>c/k00l0>c/k0l000007P3IfMT50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000
003oool0oooo0?oooaH0fMWI3P00001Q0>c/k0030000o`3/k>`0k>c/04X0k>c/3000000B0=WIf@D0
oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0oooo2P3IfMT<00000700
k>c/00<0003o0>c/k03/k>`00P3o001C0>c/k0X00000203IfMT50?ooo`030000003oool0oooo00T0
oooo000K0?ooo`040000003oool0oooo0?ooo`X00000O@3/k>`00`000?l0o`000?l000030?l005/0
k>c/1`0000000`3IfMT0oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo000K0?ooo`800000
0P3ooon70>c/k0030?l000000?l00?l000<0o`00HP3/k>`2000000<0oooo0P00000;0?ooo`006`3o
ool010000000oooo0?ooo`3ooon60>c/k0050?l00000o`000?l00000o`00o`000`3o001R0>c/k0D0
oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooQP3/k>`01@3o0000
0?l0003o0000o`00003o00<0o`00HP3/k>`50?ooo`030000003oool0oooo00T0oooo000K0?ooo`04
0000003oool0oooo0?ooohL0k>c/00H0o`00003o0000o`00o`000000o`3o001S0>c/k0D0oooo00<0
00000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooooQ`3/k>`50?l000030000o`3/
k>`0k>c/0640k>c/1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3o
oon90>c/k080o`000P3/k>`00`000?l0k>c/0>c/k01P0>c/k0D0oooo00<000000?ooo`3oool02@3o
ool000H0oooo00X0oono07@00000000000000000B02Lgol0oooo0?oo_`1d000004RL0`3oool0103O
W4P0000000000018W=l40?ooo`040000003oool0oooo0?ooohh0k>c/00<0003o0>c/k03/k>`0G`3/
k>`50?ooo`030000003oool0oooo00T0oooo00080?ooo`030?noM018W=l0oooo00L0oooo00H0omnL
04Q8W03oool0oooo09a8B02Lgol30?ooo`040000003oool0oooo0?ooohl0k>c/00<0003o0>c/k03/
k>`0GP3/k>`50?ooo`030000003oool0oooo00T0oooo00080?ooo`030?noM018W=l0oooo00/0oooo
00<0_gA809cOo`3oool00P3oool200000080ooooJP3/k>`V000000030000o`000000000005d0k>c/
0`3oool3000000/0oooo00080?ooo`030?noM018W=l0oooo00P0oooo00@0_g@000000000000007Bo
103oool010000000oooo0?ooo`3ooomB0>c/k1P000009`3oool00`000?l0oooo0000000G000004D0
k>c/1@3oool00`000000oooo0?ooo`090?ooo`001`3oool00`2LB7@0_kmd04RLg`090?ooo`030;md
B02Lgol0oooo00D0oooo00@000000?ooo`3oool0ooooA03/k>`>00000400oooo00<0003o0?ooo`3o
ool05P3oool<000003T0k>c/1@3oool00`000000oooo0?ooo`090?ooo`001`3oool00`3o_g@00000
04RLg`090?ooo`040;md000000000000001d_`@0oooo00@000000?ooo`3oool0oooo>03/k>`<0000
04l0oooo00<0003o0?ooo`3oool08@3oool:000002l0k>c/1@3oool00`000000oooo0?ooo`090?oo
o`006`3oool010000000oooo0?ooo`3oool^0>c/k0X00000G03oool00`000?l0oooo0?ooo`0Z0?oo
o`X000009@3/k>`50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oo
obL0k>c/1`00001W0?ooo`030000o`3oool0oooo03<0oooo1000000Q0>c/k0D0oooo00<000000?oo
o`3oool02@3oool001/0oooo00@000000?ooo`3oool0oooo7`3/k>`8000006l0oooo00<0003o0?oo
o`3oool0=P3oool8000001T0k>c/1@3oool00`000000oooo0?ooo`090?ooo`006`3oool200000080
oooo603/k>`7000007P0oooo00<0003o0?ooo`3oool0?@3oool4000001D0k>c/103oool2000000/0
oooo000K0?ooo`040000003oool0oooo0?oooa<0k>c/1@0000200?ooo`030000o`3oool0oooo0400
oooo1@00000@0>c/k0D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0
oooo3P3/k>`5000008H0oooo00<0003o0?ooo`3oool0A03oool3000000d0k>c/1@3oool00`000000
oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3oool:0>c/k0@00000S03oool00`000?l0
oooo0?ooo`160?ooo`D00000203/k>`50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000
003oool0oooo0?ooo`D0k>c/1@00002A0?ooo`030000o`3oool0oooo04X0oooo0P0000060>c/k0D0
oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0oooo1@00002G0?ooo`03
0000o`3oool0oooo04/0oooo0P0000040>c/k0D0oooo00<000000?ooo`3oool02@3oool001/0oooo
00<000000?ooo`3oool0WP3oool00`000?l0oooo0?ooo`1<0?ooo`8000000P3/k>`50?ooo`030000
003oool0oooo00T0oooo000K0?ooo`800000X03oool00`000?l0oooo0?ooo`1=0?ooo`<000000`3o
ool2000000/0oooo000K0?ooo`030000003oool0oooo0:00oooo00<0003o0?ooo`3oool0D`3oool0
0`000000oooo0?ooo`090?ooo`006`3oool00`000000oooo0?ooo`2Q0?ooo`040000o`3oool0oooo
0?ooo`<00?ooCP3oool00`000000oooo0?ooo`090?ooo`006`3oool00`000000oooo0?ooo`2R0?oo
o`030000o`00ool00?oo00D00?ooC03oool00`000000oooo0?ooo`090?ooo`006`3oool00`000000
oooo0?ooo`2R0?ooo`04003oo`000?l00?oo003oo`80o`000`00oom;0?ooo`030000003oool0oooo
00T0oooo000K0?ooo`030000003oool0oooo07X0oooo1@00000S0?ooo`800?oo00<0003o0?l0003o
00000`3o00000`00ool0oooo0?ooo`190?ooo`030000003oool0oooo00T0oooo000K0?ooo`030000
003oool0oooo07T0oooo0P000005003oob40oooo0`00ool00`3o0000003o003o00030?l000800?oo
BP3oool00`000000oooo0?ooo`090?ooo`006`3oool2000007T0oooo00<00000003oo`00ool01`00
oolO0?ooo`03003oo`000?l0003o00<0003o00D00?l00?l0003o0000o`00003oo`190?ooo`800000
2`3oool001/0oooo00<000000?ooo`3oool0M`3oool0100000000?oo003oo`00ool40?l000@00?oo
5@3oool:0000o`03003oo`3o00000?l000<0003o0`3o00000`00ool0oooo0?ooo`180?ooo`030000
003oool0oooo00T0oooo000K0?ooo`030000003oool0oooo07L0oooo00<00000003oo`3o00001`3o
0002003oo`/0oooo2P000?l:0?ooo`800?oo00<0o`00003o00000?l00`3o00000`00ool0oooo0?oo
o`190?ooo`030000003oool0oooo00T0oooo000K0?ooo`030000003oool0oooo07H0oooo00<00000
003oo`00ool00P3o00001000o`00003o003o00000?l20?l000<00?oo2P000?lD0?ooo`800?oo1P3o
00000`00ool0oooo0?ooo`190?ooo`030000003oool0oooo00T0oooo000K0?ooo`030000003oool0
oooo07H0oooo00D00000003oo`3o0000o`00003o00090000oal0oooo0`00ool20?l000800?ooC03o
ool00`000000oooo0?ooo`090?ooo`006`3oool00`000000oooo0?ooo`1f0?ooo`0400000000ool0
o`000?l000800?l000@0003o003o00000?l00?l00P3o0002003oob40oooo0`00oom>0?ooo`030000
003oool0oooo00T0oooo000K0?ooo`030000003oool0oooo07L0oooo00@00000003oo`3o0000o`00
1000o`020?l000800?ooL`3oool00`000000oooo0?ooo`090?ooo`006`3oool2000007P0oooo00<0
0000003oo`3o00001`3o0002003oog80oooo0P00000;0?ooo`006`3oool00`000000oooo0?ooo`1h
0?ooo`0300000000ool00?oo00@0o`000`00oomd0?ooo`030000003oool0oooo00T0oooo000K0?oo
o`030000003oool0oooo07T0oooo0P000005003oogH0oooo00<000000?ooo`3oool02@3oool001/0
oooo00<000000?ooo`3oool0NP3oool5000007L0oooo00<000000?ooo`3oool02@3oool001/0oooo
00<000000?ooo`3oool0]03oool20?l00400oooo00<000000?ooo`3oool02@3oool0000:0?oo_`1d
000000000000000004P0W=oo0?ooo`3ookl0M0000018W0@0oooo00<0gia807Boo`3oool00P3oool0
103OW4P0000000000018W=l40?ooo`030000003oool0oooo0;80oooo1P3o000n0?ooo`030000003o
ool0oooo00T0oooo00020?ooo`030?noM018W=l0oooo00T0oooo00H0oono07Ad_`3oool0oooo0?oO
W018B9`20?ooo`0309a8B02Lgol0oooo0080oooo00<000000?ooo`3oool0/P3oool00`3o00000?l0
003o00030?l003P0oooo0P0000040?ooo`030000003oool0oooo00T0oooo00020?ooo`030?noM018
W=l0oooo00X0oooo00<0_gAd0;ooo`3oool0103oool00`2oM4P0W=oo0?ooo`020?ooo`800000/P3o
ool00`3o00000?l0003o0002003o00<0o`00=03oool3000000040>c/k03oool0oooo0?ooo`<00000
2`3oool00080oooo00<0okmd04RLg`3oool02P3oool01@3o_g@0B9cO0?ooo`3oool0_g@000800000
00<007Bo0?ooo`3oool00P3oool00`000000oooo0?ooo`2a0?ooo`030?l00000o`000?l000800?l0
0`3o000c0?ooo`030000003/k>`0k>c/0080k>c/1@3oool00`000000oooo0?ooo`090?ooo`0000@0
oooo09a8M02o_g@0B9cO203oool01@3ogi`0B7Bo0?ooo`3ookl0M4RL0080oooo00<0_gA809cOo`3o
ool01@3oool00`000000oooo0?ooo`2b0?ooo`030?l00000o`000?l000<0o`00;`3oool5000000D0
k>c/1@3oool00`000000oooo0?ooo`090?ooo`0000@0oooo0?noM0000000B9cO203oool0203ogi`0
B000000000000000001d0;ooo`3oool0_g@00P0000000`00M;l0oooo0?ooo`020?ooo`030000003o
ool0oooo0;80oooo1P3o000/0?ooo`<000002P3/k>`50?ooo`030000003oool0oooo00T0oooo000K
0?ooo`030000003oool0oooo0;@0oooo0P3o000Y0?ooo`D000003@3/k>`50?ooo`030000003oool0
oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooo`@00000eP3oool400000180k>c/1@3oool0
0`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3oool40>c/k0D00000c03oool5
000001H0k>c/1@3oool00`000000oooo0?ooo`090?ooo`006`3oool200000080oooo2@3/k>`50000
0<80oooo1@00000K0>c/k0@0oooo0P00000;0?ooo`006`3oool010000000oooo0?ooo`3oool>0>c/
k0L00000]03oool700000200k>c/1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000
oooo0?ooo`3ooolE0>c/k0X00000XP3oool8000002L0k>c/1@3oool00`000000oooo0?ooo`090?oo
o`006`3oool010000000oooo0?ooo`3ooolO0>c/k0X00000S`3oool9000002l0k>c/1@3oool00`00
0000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolY0>c/k0T00000NP3oool<0000
03P0k>c/1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooolb0>c/
k1400000FP3oool?000004@0k>c/1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000
oooo0?ooo`3ooom30>c/k1d000008`3ooolJ000005<0k>c/1@3oool00`000000oooo0?ooo`090?oo
o`006`3oool010000000oooo0?ooo`3ooomP0>c/k2<00000K@3/k>`50?ooo`030000003oool0oooo
00T0oooo000K0?ooo`8000000P3oooo`0>c/k0@0oooo0P00000;0?ooo`006`3oool010000000oooo
0?ooo`3oooo`0>c/k0D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0
ooool03/k>`50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oooo00
k>c/1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3oooo_0>c/k080
0000103oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3ooooX0>c/k0L0
000000<0fMWI0?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo
0?ooo`3ooooN0>c/k0X00000203IfMT50?ooo`030000003oool0oooo00T0oooo000K0?ooo`800000
0P3ooooB0>c/k0`000004P3IfMT40?ooo`8000002`3oool001/0oooo00@000000?ooo`3oool0oooo
100000320>c/k0`000007P3IfMT50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003o
ool0oooo0?ooo`@0fMWI4P00002O0>c/k1400000:P3IfMT50?ooo`030000003oool0oooo00T0oooo
000K0?ooo`040000003oool0oooo0?oooaH0fMWI6P00001`0>c/k1D00000>`3IfMT50?ooo`030000
003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oooc00fMWIL000001@0=WIf@D0oooo
00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooool03IfMT50?ooo`030000
003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oooo00fMWI1@3oool00`000000oooo
0?ooo`090?ooo`006`3oool200000080ooool03IfMT40?ooo`8000002`3oool001/0oooo00@00000
0?ooo`3oool0ooool03IfMT50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0
oooo0?ooonl0fMWI0P0000040?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0
oooo0?ooon40fMWI3P0000000`36a/H0oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo000K
0?ooo`040000003oool0oooo0?ooom00fMWI4@00000?0<K6aPD0oooo00<000000?ooo`3oool02@3o
ool00180oooo00H0okmd00000000000000000000M02oool30?ooo`040000003oool0oooo0?oookX0
fMWI5P00000P0<K6aPD0oooo00<000000?ooo`3oool02@3oool001<0oooo00<0W4P00000M02oool0
1@3oool010000000oooo0?ooo`3ooolT000007@0fMWI8P00000f0<K6aPD0oooo00<000000?ooo`3o
ool02@3oool001@0oooo00<0okmd0000001d_ol0103oool200000080oooo9036a/Id000005P0a/K6
0`3oool3000000/0oooo000E0?ooo`030?oo_`2o_ol0oooo00<0oooo00@000000?ooo`3oool0oooo
l036a/H50?ooo`030000003oool0oooo00T0oooo000B0?ooo`060?oOW018B9`0oooo0?oo_`1d07@0
_ooo0`3oool010000000oooo0?ooo`3oooo`0<K6aPD0oooo00<000000?ooo`3oool02@3oool001<0
oooo00@0gia8000000000000B9cO103oool010000000oooo0?ooo`3oooo`0<K6aPD0oooo00<00000
0?ooo`3oool02@3oool001/0oooo00@000000?ooo`3oool0ooool036a/H50?ooo`030000003oool0
oooo00T0oooo000K0?ooo`040000003oool0oooo0?oooo00a/K61@3oool00`000000oooo0?ooo`09
0?ooo`006`3oool010000000oooo0?ooo`3ooooL0<K6aQD00000103oool00`000000oooo0?ooo`09
0?ooo`006`3oool200000080oooo^036a/HT000001@0/k>c103oool2000000/0oooo000K0?ooo`04
0000003oool0oooo0?oookP00000>02c/k<50?ooo`030000003oool0oooo00T0oooo000K0?ooo`04
0000003oool0oooo0?oooo00/k>c1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000
oooo0?ooo`3oooo`0;>c/`D0oooo00<000000?ooo`3oool02@3oool001/0oooo00@000000?ooo`3o
ool0ooool02c/k<50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?oo
oo00/k>c1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo0?ooo`3oooo`0;>c
/`D0oooo00<000000?ooo`3oool02@3oool001/0oooo0P0000020?oooo00/k>c103oool2000000/0
oooo000K0?ooo`040000003oool0oooo0?ooomX0/k>c5`0000040?ooo`030000003oool0oooo00T0
oooo000K0?ooo`040000003oool0oooo0?ooomX000005P2OWil50?ooo`030000003oool0oooo00T0
oooo000K0?ooo`040000003oool0oooo0?oooo00WinO1@3oool00`000000oooo0?ooo`090?ooo`00
6`3oool010000000oooo0?ooo`3oooo`09nOW`D0oooo00<000000?ooo`3oool02@3oool001/0oooo
00@000000?ooo`3oool0ooool02OWil50?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000
003oool0oooo0?oooo00WinO1@3oool00`000000oooo0?ooo`090?ooo`006`3oool010000000oooo
0?ooo`3oooo_09nOW`80o`00103oool00`000000oooo0?ooo`090?ooo`006`3oool200000080oooo
k@2OWil60?l000030?ooo`000000000000/0oooo000K0?ooo`040000003oool0oooo0?ooond0WinO
1P3o00020?ooo`030000003oool0oooo00T0oooo000K0?ooo`040000003oool0oooo0?ooom/00000
4@2OWil30?l000800?l00`3o00000`3oool000000?ooo`0:0?ooo`006`3oool010000000oooo0?oo
o`3ooooK08b<S14000000P3o0004003o0080o`0000<0oooo0000003oool02P3oool001/0oooo00<0
00000?ooo`3oool0kP3oool00`3o00000?l0003o0002003o00040?l0003oool0oooo000000/0oooo
000K0?ooo`030000003oool0oooo0>h0oooo0P3o0002003o0080o`000P3oool00`000000oooo0?oo
o`090?ooo`006`3oool01@000000oooo0?ooo`3oool000000280oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01/0oooo0P3o00030?ooo`8000002`3o
ool001/0oooo0P0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool2
000000/0oooo000K0?ooooX000002`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {1.15407, 0.291447, 0.00143975, \
0.00698524}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-2.`\), {x \[Rule] 1.3763849724881405`, 
            y \[Rule] 1.6786760819501383`}}\), 
        ",", \({"Steps" \[Rule] 4, "Function" \[Rule] 11, 
          "Gradient" \[Rule] 11, "Hessian" \[Rule] 5}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell["\<\
When sufficiently near a local maximum, the Hessian is actually \
negative definite. \
\>", "Text"],

Cell["\<\
This computes the eigenvalues of the Hessian near the local \
maximum.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Eigenvalues[h[1.2,  .5]]\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \({\(-15.753428991915928`\), \(-6.0477979231514825`\)}\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
If you were to only apply the Newton step formula in cases where \
the Hessian is not positive definite, it is possible to get a step direction \
that does not lead to a decrease in the function value. \
\>", "Text"],

Cell[TextData[{
  "This computes the directional derivative for the direction found by \
solving ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Del]\^2\( f(x\_k)\) 
          s\_0 = \ \(\(-\ \[Del]f\) \((x\_k)\)\(\ \)\)\)\)\)]],
  ". ",
  "Since it is positive, moving in this direction will locally increase the \
function value."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[h[1.2,  .5], \ \(-g[1.2,  .5]\)] . g[1.2,  .5]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(0.017269532810829928`\)], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "It is crucial for the convergence of line-search methods that the \
direction be computed using a positive definite quadratic model ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " since the search process and convergence results derived from it depend \
on a direction with sufficient descent. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " modifies the Hessian by a diagonal matrix ",
  Cell[BoxData[
      \(TraditionalForm\`E\_k\)]],
  " with entries large enough so that ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\  = \ \[Del]\^2\( f(x\_k)\) + \ E\_k\)]],
  "is positive definite. Such methods are sometimes referred to as modified \
Newton methods. The modification to ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  "is done during the process of computing a Cholesky decomposition somewhat \
along the lines described in [",
  ButtonBox["GMW81",
    ButtonData:>"GMW81",
    ButtonStyle->"Hyperlink"],
  "], both for dense and sparse Hessians. The modification is only done if ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\^2\( f(x\_k)\)\)]],
  " is not positive definite. This decomposition method is accessible through \
",
  StyleBox["LinearSolve", "MR"],
  " if you want to use it independently. "
}], "Text"],

Cell[TextData[{
  "This computes the step using ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(B\_0\) 
          s\_0 = \ \(-\ \[Del]f\) \((x\_k)\)\)\(,\)\(\ \)\)\)]],
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`B\_0\)]],
  "is determined as the Cholesky factors of the Hessian are being computed."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[h[1.2,  .5], \ \(-g[1.2,  .5]\), \ 
      Method \[Rule] {Cholesky, \ Modification \[Rule] Minimal}]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \({0.004055019027569954`, 0.01967370610035272`}\)], "Output",
  CellLabel->"Out[11]="]
}, Open  ]],

Cell["The computed step is in a descent direction.", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% . g[1.2,  .5]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(\(-0.006452548417265636`\)\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell[TextData[{
  "Besides the robustness of the (modified) Newton method, another key aspect \
is its convergence rate. Once a search is close enough to a quadratic \
minimum, the convergence is said to be ",
  StyleBox["q",
    FontSlant->"Italic"],
  "-quadratic, which means that if ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\^*\)\)]],
  "is the local minimum point, then "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[LeftDoubleBracketingBar]x\_\(k + 1\) - \(x\^*\)\
\[RightDoubleBracketingBar] \[LessEqual] \[Beta]\ \[LeftDoubleBracketingBar]x\
\_k - \(x\^*\)\[RightDoubleBracketingBar]\^2\)], "DisplayMath"],

Cell["for some constant \[Beta] > 0.", "Text"],

Cell["\<\
At machine precision, this does not always make a substantial \
difference since commonly, that most of the steps are spent getting near to \
the local minimum. However, if you want a root to extremely high precision, \
Newton\[CloseCurlyQuote]s method is usually the best choice because of the \
rapid convergence. \
\>", "Text"],

Cell[TextData[{
  "This computes a very high-precision solution using Newton",
  "\[CloseCurlyQuote]",
  "s method. The precision is adaptively increased from machine precision \
(the precision of the starting point) to the maximal working precision of \
100000 digits. ",
  StyleBox["Reap", "MR"],
  " is used with ",
  StyleBox["Sow", "MR"],
  " to save the steps taken. Counters are used to keep track of and print the \
number of function evaluations and steps used."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[
      Timing[Block[{e\  = \ 0, \ 
            s\  = \ 0}, {{min, \ minpoint}, {points}}\ \  = \ 
            Reap[FindMinimum[
                Cos[x^2\  - \ 3\ y]\  + \ 
                  Sin[x^2\  + \ y^2], {{x, 1. }, {y, 1. }}, \ 
                Method -> "\<Newton\>", \ WorkingPrecision \[Rule] 100000, 
                StepMonitor \[RuleDelayed] \((\(s++\); Sow[{x, y}])\), \ 
                EvaluationMonitor \[RuleDelayed] \(e++\)]]; 
          Print[s, "\< steps and \>", e, "\< evaluations\>"]]]]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"qQuadraticExample"],

Cell[BoxData[
    InterpretationBox[\(17\[InvisibleSpace]" steps and "\[InvisibleSpace]27\
\[InvisibleSpace]" evaluations"\),
      SequenceForm[ 17, " steps and ", 27, " evaluations"],
      Editable->False]], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \(18.527`\ Second\)], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell[TextData[{
  "When the option ",
  StyleBox["WorkingPrecision\[Rule]", "MR"],
  StyleBox["prec", "TI"],
  " is used, the ",
  ButtonBox["default",
    ButtonData:>"WPAGPG",
    ButtonStyle->"Hyperlink"],
  " for the ",
  StyleBox["AccuracyGoal", "MR"],
  " and ",
  StyleBox["PrecisionGoal", "MR"],
  " is ",
  StyleBox["prec", "TI"],
  StyleBox["/2", "MR"],
  ". Thus, this example should find the minimum to at least 50000 digits."
}], "Text"],

Cell["\<\
This computes a symbolic solution for the position of the minimum \
which the search approaches.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exact\  = \ {x, \ y}\  /. \ 
        Last[Solve[{x^2\  + \ y^2\  \[Equal] 3\ \ Pi/2, \ 
              x^2\  - \ 3\ y\  \[Equal] \ \(-Pi\)}, {x, y}]]\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    \({\@\(\(-\(9\/2\)\) - \[Pi] + 3\/2\ \@\(9 + 10\ \[Pi]\)\), 
      1\/2\ \((\(-3\) + \@\(9 + 10\ \[Pi]\))\)}\)], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["\<\
This computes the norm of the distance from the search points at \
the ends of each step to the exact minimum.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Map[Norm[exact\  - \ #] &, \ \ points]]\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    \({0.14041075294947544`, 0.01566073857042689`, 0.00023655769627756428`, 
      6.094442481525617`*^-8, 3.8254975154979795`*^-15, 
      1.5965297513154377`*^-29, 2.413710509050523`*^-58, 
      3.0891227756329787`*^-108, 1.0029477232850986`*^-212, 
      6.555511635135568053629211207`15.954589770191005*^-406, 
      6.97065864221170510254353855`15.954589770191005*^-792, 
      3.0956036095964646130060830884`15.954589770191005*^-1580, 
      7.985584721469988033473163564`15.954589770191005*^-3142, 
      4.216588274684706675738999004`15.954589770191005*^-6263, 
      5.411816957082772118607614751`15.954589770191005*^-12515, 
      1.37690560798023913289480509245`15.954589770191005*^-25016, 
      1.1900052421299204924057662621`15.954589770191005*^-50015}\)], "Output",\

  CellLabel->"Out[15]="]
}, Open  ]],

Cell[TextData[{
  "The reason that more function evaluations were required than the number of \
steps is that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " adaptively increases the precision from the precision of the initial \
value to the requested maximum ",
  StyleBox["WorkingPrecision", "MR"],
  ". The sequence of precisions used is chosen so that as few computations \
are done at the most expensive final precision as possible under the \
assumption that the points are converging to the minimum",
  ". ",
  "Sometimes when ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " changes precision, it is necessary to reevaluate the function at the \
higher precision."
}], "Text"],

Cell["\<\
This shows a table with the precision of each of the points with \
the norm of their errors.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[
      Transpose[{Map[Precision, \ points], \ 
          N[Map[Norm[exact\  - \ #] &, \ \ points]]}]]\)], "Input",
  CellLabel->"In[16]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {"MachinePrecision", "0.14041075294947544`"},
          {"MachinePrecision", "0.01566073857042689`"},
          {"MachinePrecision", "0.00023655769627756428`"},
          {"MachinePrecision", "6.094442481525617`*^-8"},
          {"24.414135993651286`", "3.8254975154979795`*^-15"},
          {"48.82827198730257`", "1.5965297513154377`*^-29"},
          {"97.65654397460514`", "2.413710509050523`*^-58"},
          {"195.31308794921028`", "3.0891227756329787`*^-108"},
          {"390.62617589842057`", "1.0029477232850986`*^-212"},
          {"781.2523517968411`", 
            "6.555511635135568053629211207`15.954589770191005*^-406"},
          {"1562.5047035936823`", 
            "6.97065864221170510254353855`15.954589770191005*^-792"},
          {"3125.0094071873646`", 
            "3.0956036095964646130060830884`15.954589770191005*^-1580"},
          {"6250.018814374729`", 
            "7.985584721469988033473163564`15.954589770191005*^-3142"},
          {"12500.037628749458`", 
            "4.216588274684706675738999004`15.954589770191005*^-6263"},
          {"25000.075257498916`", 
            "5.411816957082772118607614751`15.954589770191005*^-12515"},
          {"50000.15051499783`", 
            "1.37690560798023913289480509245`15.954589770191005*^-25016"},
          {"100000.`", 
            "1.1900052421299204924057662621`15.954589770191005*^-50015"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[16]//TableForm="]
}, Open  ]],

Cell[TextData[{
  "Note that typically the precision is roughly double the scale ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((log\_10)\)\(\ \)\)\)]],
  "of the error. For Newton\[CloseCurlyQuote]s method this is appropriate \
since when the step is computed, the scale of the error will effectively \
double according to the quadratic convergence."
}], "Text"],

Cell[TextData[{
  StyleBox["FindMinimum", "MR"],
  " always starts with the precision of the starting values you gave it. \
Thus, if you do not want it to use adaptive precision control, you can start \
with values, which are exact or have at least the maximum ",
  StyleBox["WorkingPrecision", "MR"],
  ". "
}], "Text"],

Cell["\<\
This computes the solution using only precision 100000 throughout \
the computation. (Warning: this takes a very long time to complete.)\
\>", \
"MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[
      Timing[Block[{e\  = \ 0, \ 
            s\  = \ 0}, {{min, \ minpoint}, {points}}\ \  = \ 
            Reap[FindMinimum[
                Cos[x^2\  - \ 3\ y]\  + \ 
                  Sin[x^2\  + \ y^2], {{x, 1}, {y, 1}}, \ 
                Method -> "\<Newton\>", \ WorkingPrecision \[Rule] 100000, 
                StepMonitor \[RuleDelayed] \((\(s++\); Sow[{x, y}])\), \ 
                EvaluationMonitor \[RuleDelayed] \(e++\)]]; 
          Print[s, "\< steps and \>", e, "\< evaluations\>"]]]]\)], "Input",
  CellLabel->"In[17]:=",
  Evaluatable->False],

Cell[BoxData[
    InterpretationBox[\(17\[InvisibleSpace]" steps and "\[InvisibleSpace]18\
\[InvisibleSpace]" evaluations"\),
      SequenceForm[ 17, " steps and ", 18, " evaluations"],
      Editable->False]], "Print",
  CellLabel->"From In[19]:="],

Cell[BoxData[
    \(1259.84`\ Second\)], "Output",
  CellLabel->"Out[17]="]
}, Open  ]],

Cell["\<\
However, even though this may use fewer function evaluations, they \
are all done at the highest precision, so typically adaptive precision saves \
a lot of time. For example, the previous command without adaptive precision \
takes more than 50 times as long as when starting from machine \
precision.\
\>", "Text"],

Cell[TextData[{
  "With Newton\[CloseCurlyQuote]s method, both ",
  ButtonBox["line search",
    ButtonData:>"LineSearch",
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["trust region",
    ButtonData:>"TrustRegion",
    ButtonStyle->"Hyperlink"],
  " step control are implemented. The default, which is used in the examples \
above is the line search. However, any of them may be done with the trust \
region approach. The approach typically requires more numerical linear \
algebra per step, but, because steps are better controlled, may converge in \
fewer iterations."
}], "Text"],

Cell["\<\
This uses the unconstrained problems package to set up the classic \
Rosenbrock function, which has a narrow curved valley.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p\  = \ GetFindMinimumProblem[Rosenbrock]\)], "Input",
  CellLabel->"In[18]:="],

Cell[BoxData[
    \(FindMinimumProblem[\((1 - X\_1)\)\^2 + 
        100\ \((\(-X\_1\%2\) + X\_2)\)\^2, {{X\_1, \(-1.2`\)}, {X\_2, 
          1.`}}, {}, Rosenbrock, {2, 2}]\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[TextData[{
  "This shows the steps taken by ",
  StyleBox["FindMinimum", "MR"],
  " with a trust region Newton method for a Rosenbrock\[CloseCurlyQuote]s \
function."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[p, \ 
      Method \[Rule] {"\<Newton\>", \ "\<StepControl\>" -> \
"\<TrustRegion\>"}]\)], "Input",
  CellLabel->"In[19]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.543706 0.437063 0.0358745 0.684372 [
[.10664 -0.0125 -6 -9 ]
[.10664 -0.0125 6 0 ]
[.32517 -0.0125 -12 -9 ]
[.32517 -0.0125 12 0 ]
[.54371 -0.0125 -3 -9 ]
[.54371 -0.0125 3 0 ]
[.76224 -0.0125 -9 -9 ]
[.76224 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03587 -6 -4.5 ]
[-0.0125 .03587 0 4.5 ]
[-0.0125 .17275 -18 -4.5 ]
[-0.0125 .17275 0 4.5 ]
[-0.0125 .30962 -18 -4.5 ]
[-0.0125 .30962 0 4.5 ]
[-0.0125 .4465 -18 -4.5 ]
[-0.0125 .4465 0 4.5 ]
[-0.0125 .58337 -18 -4.5 ]
[-0.0125 .58337 0 4.5 ]
[-0.0125 .72025 -6 -4.5 ]
[-0.0125 .72025 0 4.5 ]
[-0.0125 .85712 -18 -4.5 ]
[-0.0125 .85712 0 4.5 ]
[-0.0125 .994 -18 -4.5 ]
[-0.0125 .994 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10664 0 m
.10664 .00625 L
s
[(-1)] .10664 -0.0125 0 1 Mshowa
.32517 0 m
.32517 .00625 L
s
[(-0.5)] .32517 -0.0125 0 1 Mshowa
.54371 0 m
.54371 .00625 L
s
[(0)] .54371 -0.0125 0 1 Mshowa
.76224 0 m
.76224 .00625 L
s
[(0.5)] .76224 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(1)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.15035 0 m
.15035 .00375 L
s
.19406 0 m
.19406 .00375 L
s
.23776 0 m
.23776 .00375 L
s
.28147 0 m
.28147 .00375 L
s
.36888 0 m
.36888 .00375 L
s
.41259 0 m
.41259 .00375 L
s
.45629 0 m
.45629 .00375 L
s
.5 0 m
.5 .00375 L
s
.58741 0 m
.58741 .00375 L
s
.63112 0 m
.63112 .00375 L
s
.67483 0 m
.67483 .00375 L
s
.71853 0 m
.71853 .00375 L
s
.80594 0 m
.80594 .00375 L
s
.84965 0 m
.84965 .00375 L
s
.89336 0 m
.89336 .00375 L
s
.93706 0 m
.93706 .00375 L
s
.06294 0 m
.06294 .00375 L
s
.01923 0 m
.01923 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .03587 m
.00625 .03587 L
s
[(0)] -0.0125 .03587 1 0 Mshowa
0 .17275 m
.00625 .17275 L
s
[(0.2)] -0.0125 .17275 1 0 Mshowa
0 .30962 m
.00625 .30962 L
s
[(0.4)] -0.0125 .30962 1 0 Mshowa
0 .4465 m
.00625 .4465 L
s
[(0.6)] -0.0125 .4465 1 0 Mshowa
0 .58337 m
.00625 .58337 L
s
[(0.8)] -0.0125 .58337 1 0 Mshowa
0 .72025 m
.00625 .72025 L
s
[(1)] -0.0125 .72025 1 0 Mshowa
0 .85712 m
.00625 .85712 L
s
[(1.2)] -0.0125 .85712 1 0 Mshowa
0 .994 m
.00625 .994 L
s
[(1.4)] -0.0125 .994 1 0 Mshowa
.125 Mabswid
0 .07009 m
.00375 .07009 L
s
0 .10431 m
.00375 .10431 L
s
0 .13853 m
.00375 .13853 L
s
0 .20697 m
.00375 .20697 L
s
0 .24119 m
.00375 .24119 L
s
0 .2754 m
.00375 .2754 L
s
0 .34384 m
.00375 .34384 L
s
0 .37806 m
.00375 .37806 L
s
0 .41228 m
.00375 .41228 L
s
0 .48072 m
.00375 .48072 L
s
0 .51493 m
.00375 .51493 L
s
0 .54915 m
.00375 .54915 L
s
0 .61759 m
.00375 .61759 L
s
0 .65181 m
.00375 .65181 L
s
0 .68603 m
.00375 .68603 L
s
0 .75447 m
.00375 .75447 L
s
0 .78868 m
.00375 .78868 L
s
0 .8229 m
.00375 .8229 L
s
0 .89134 m
.00375 .89134 L
s
0 .92556 m
.00375 .92556 L
s
0 .95978 m
.00375 .95978 L
s
0 .00166 m
.00375 .00166 L
s
.25 Mabswid
0 0 m
0 1 L
s
.10664 .99375 m
.10664 1 L
s
.32517 .99375 m
.32517 1 L
s
.54371 .99375 m
.54371 1 L
s
.76224 .99375 m
.76224 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.15035 .99625 m
.15035 1 L
s
.19406 .99625 m
.19406 1 L
s
.23776 .99625 m
.23776 1 L
s
.28147 .99625 m
.28147 1 L
s
.36888 .99625 m
.36888 1 L
s
.41259 .99625 m
.41259 1 L
s
.45629 .99625 m
.45629 1 L
s
.5 .99625 m
.5 1 L
s
.58741 .99625 m
.58741 1 L
s
.63112 .99625 m
.63112 1 L
s
.67483 .99625 m
.67483 1 L
s
.71853 .99625 m
.71853 1 L
s
.80594 .99625 m
.80594 1 L
s
.84965 .99625 m
.84965 1 L
s
.89336 .99625 m
.89336 1 L
s
.93706 .99625 m
.93706 1 L
s
.06294 .99625 m
.06294 1 L
s
.01923 .99625 m
.01923 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .03587 m
1 .03587 L
s
.99375 .17275 m
1 .17275 L
s
.99375 .30962 m
1 .30962 L
s
.99375 .4465 m
1 .4465 L
s
.99375 .58337 m
1 .58337 L
s
.99375 .72025 m
1 .72025 L
s
.99375 .85712 m
1 .85712 L
s
.99375 .994 m
1 .994 L
s
.125 Mabswid
.99625 .07009 m
1 .07009 L
s
.99625 .10431 m
1 .10431 L
s
.99625 .13853 m
1 .13853 L
s
.99625 .20697 m
1 .20697 L
s
.99625 .24119 m
1 .24119 L
s
.99625 .2754 m
1 .2754 L
s
.99625 .34384 m
1 .34384 L
s
.99625 .37806 m
1 .37806 L
s
.99625 .41228 m
1 .41228 L
s
.99625 .48072 m
1 .48072 L
s
.99625 .51493 m
1 .51493 L
s
.99625 .54915 m
1 .54915 L
s
.99625 .61759 m
1 .61759 L
s
.99625 .65181 m
1 .65181 L
s
.99625 .68603 m
1 .68603 L
s
.99625 .75447 m
1 .75447 L
s
.99625 .78868 m
1 .78868 L
s
.99625 .8229 m
1 .8229 L
s
.99625 .89134 m
1 .89134 L
s
.99625 .92556 m
1 .92556 L
s
.99625 .95978 m
1 .95978 L
s
.99625 .00166 m
1 .00166 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.925 g
.01923 .79847 m
.01983 .79623 L
.02239 .78652 L
.02491 .77681 L
.02743 .76709 L
.02894 .76129 L
.02997 .75738 L
.03253 .74767 L
.03512 .73796 L
.03773 .72824 L
.03866 .7248 L
.04033 .71853 L
.04295 .70882 L
.0456 .69911 L
.04826 .68939 L
.04837 .689 L
.05092 .67968 L
.0536 .66997 L
.0563 .66026 L
.05808 .65389 L
.05901 .65054 L
.06173 .64083 L
.06447 .63112 L
.06724 .62141 L
.06779 .61947 L
.07001 .61169 L
.07279 .60198 L
.0756 .59227 L
.07751 .58574 L
.07843 .58256 L
.08126 .57284 L
.08412 .56313 L
.087 .55342 L
.08722 .5527 L
.08989 .54371 L
.0928 .53399 L
.09574 .52428 L
.09693 .52035 L
.09868 .51457 L
.10165 .50486 L
.10464 .49514 L
.10664 .48869 L
.10765 .48543 L
.11068 .47572 L
.11373 .46601 L
.11636 .45772 L
.11681 .45629 L
.11989 .44658 L
.12301 .43687 L
.12607 .42744 L
.12616 .42716 L
.12932 .41744 L
.1325 .40773 L
.13572 .39802 L
.13578 .39784 L
.13895 .38831 L
.14222 .37859 L
.14549 .36894 L
.14551 .36888 L
.14882 .35917 L
.15217 .34946 L
.15521 .34073 L
.15555 .33974 L
.15894 .33003 L
.16238 .32032 L
.16492 .3132 L
.16584 .31061 L
.16934 .30089 L
.17287 .29118 L
.17463 .28636 L
.17643 .28147 L
.18002 .27176 L
.18365 .26204 L
.18434 .26021 L
.18732 .25233 L
.19102 .24262 L
.19406 .23475 L
.19477 .23291 L
.19855 .22319 L
.20238 .21348 L
.20377 .20998 L
.20624 .20377 L
.21016 .19406 L
.21348 .1859 L
.21412 .18434 L
.21812 .17463 L
.22217 .16492 L
.22319 .1625 L
.22628 .15521 L
.23044 .14549 L
.23291 .13979 L
.23465 .13578 L
.23892 .12607 L
.24262 .11777 L
.24325 .11636 L
.24764 .10664 L
.2521 .09693 L
.25233 .09643 L
.25662 .08722 L
.26122 .07751 L
.26204 .07579 L
.26589 .06779 L
.27064 .05808 L
.27176 .05583 L
.27547 .04837 L
.28039 .03866 L
.28147 .03656 L
.2854 .02894 L
.29051 .01923 L
.01923 .01923 L
F
0 g
.01923 .79847 m
.01983 .79623 L
.02239 .78652 L
.02491 .77681 L
.02743 .76709 L
.02894 .76129 L
.02997 .75738 L
.03253 .74767 L
.03512 .73796 L
.03773 .72824 L
.03866 .7248 L
.04033 .71853 L
.04295 .70882 L
.0456 .69911 L
.04826 .68939 L
.04837 .689 L
.05092 .67968 L
.0536 .66997 L
.0563 .66026 L
.05808 .65389 L
.05901 .65054 L
.06173 .64083 L
.06447 .63112 L
.06724 .62141 L
.06779 .61947 L
.07001 .61169 L
.07279 .60198 L
.0756 .59227 L
.07751 .58574 L
.07843 .58256 L
.08126 .57284 L
.08412 .56313 L
.087 .55342 L
.08722 .5527 L
.08989 .54371 L
.0928 .53399 L
.09574 .52428 L
.09693 .52035 L
.09868 .51457 L
.10165 .50486 L
.10464 .49514 L
.10664 .48869 L
.10765 .48543 L
.11068 .47572 L
.11373 .46601 L
.11636 .45772 L
.11681 .45629 L
.11989 .44658 L
.12301 .43687 L
.12607 .42744 L
Mistroke
.12616 .42716 L
.12932 .41744 L
.1325 .40773 L
.13572 .39802 L
.13578 .39784 L
.13895 .38831 L
.14222 .37859 L
.14549 .36894 L
.14551 .36888 L
.14882 .35917 L
.15217 .34946 L
.15521 .34073 L
.15555 .33974 L
.15894 .33003 L
.16238 .32032 L
.16492 .3132 L
.16584 .31061 L
.16934 .30089 L
.17287 .29118 L
.17463 .28636 L
.17643 .28147 L
.18002 .27176 L
.18365 .26204 L
.18434 .26021 L
.18732 .25233 L
.19102 .24262 L
.19406 .23475 L
.19477 .23291 L
.19855 .22319 L
.20238 .21348 L
.20377 .20998 L
.20624 .20377 L
.21016 .19406 L
.21348 .1859 L
.21412 .18434 L
.21812 .17463 L
.22217 .16492 L
.22319 .1625 L
.22628 .15521 L
.23044 .14549 L
.23291 .13979 L
.23465 .13578 L
.23892 .12607 L
.24262 .11777 L
.24325 .11636 L
.24764 .10664 L
.2521 .09693 L
.25233 .09643 L
.25662 .08722 L
.26122 .07751 L
Mistroke
.26204 .07579 L
.26589 .06779 L
.27064 .05808 L
.27176 .05583 L
.27547 .04837 L
.28039 .03866 L
.28147 .03656 L
.2854 .02894 L
.29051 .01923 L
Mfstroke
.85 g
.01923 .63704 m
.02079 .63112 L
.02335 .62141 L
.02591 .61169 L
.02849 .60198 L
.02894 .60028 L
.03108 .59227 L
.03369 .58256 L
.03631 .57284 L
.03866 .56421 L
.03895 .56313 L
.0416 .55342 L
.04426 .54371 L
.04694 .53399 L
.04837 .52882 L
.04963 .52428 L
.05233 .51457 L
.05505 .50486 L
.05779 .49514 L
.05808 .49412 L
.06054 .48543 L
.06331 .47572 L
.06609 .46601 L
.06779 .46009 L
.06889 .45629 L
.0717 .44658 L
.07454 .43687 L
.07739 .42716 L
.07751 .42675 L
.08025 .41744 L
.08314 .40773 L
.08604 .39802 L
.08722 .3941 L
.08896 .38831 L
.0919 .37859 L
.09486 .36888 L
.09693 .36212 L
.09784 .35917 L
.10083 .34946 L
.10385 .33974 L
.10664 .33083 L
.10689 .33003 L
.10995 .32032 L
.11303 .31061 L
.11614 .30089 L
.11636 .30022 L
.11926 .29118 L
.12241 .28147 L
.12559 .27176 L
.12607 .27029 L
.12878 .26204 L
.132 .25233 L
.13525 .24262 L
.13578 .24105 L
.13852 .23291 L
.14182 .22319 L
.14515 .21348 L
.14549 .21248 L
.1485 .20377 L
.15189 .19406 L
.15521 .18461 L
.1553 .18434 L
.15874 .17463 L
.16221 .16492 L
.16492 .15741 L
.16572 .15521 L
.16925 .14549 L
.17282 .13578 L
.17463 .13089 L
.17642 .12607 L
.18006 .11636 L
.18374 .10664 L
.18434 .10506 L
.18745 .09693 L
.19121 .08722 L
.19406 .07991 L
.195 .07751 L
.19883 .06779 L
.20271 .05808 L
.20377 .05544 L
.20663 .04837 L
.21059 .03866 L
.21348 .03166 L
.21461 .02894 L
.21867 .01923 L
.01923 .01923 L
F
0 g
.01923 .63704 m
.02079 .63112 L
.02335 .62141 L
.02591 .61169 L
.02849 .60198 L
.02894 .60028 L
.03108 .59227 L
.03369 .58256 L
.03631 .57284 L
.03866 .56421 L
.03895 .56313 L
.0416 .55342 L
.04426 .54371 L
.04694 .53399 L
.04837 .52882 L
.04963 .52428 L
.05233 .51457 L
.05505 .50486 L
.05779 .49514 L
.05808 .49412 L
.06054 .48543 L
.06331 .47572 L
.06609 .46601 L
.06779 .46009 L
.06889 .45629 L
.0717 .44658 L
.07454 .43687 L
.07739 .42716 L
.07751 .42675 L
.08025 .41744 L
.08314 .40773 L
.08604 .39802 L
.08722 .3941 L
.08896 .38831 L
.0919 .37859 L
.09486 .36888 L
.09693 .36212 L
.09784 .35917 L
.10083 .34946 L
.10385 .33974 L
.10664 .33083 L
.10689 .33003 L
.10995 .32032 L
.11303 .31061 L
.11614 .30089 L
.11636 .30022 L
.11926 .29118 L
.12241 .28147 L
.12559 .27176 L
.12607 .27029 L
Mistroke
.12878 .26204 L
.132 .25233 L
.13525 .24262 L
.13578 .24105 L
.13852 .23291 L
.14182 .22319 L
.14515 .21348 L
.14549 .21248 L
.1485 .20377 L
.15189 .19406 L
.15521 .18461 L
.1553 .18434 L
.15874 .17463 L
.16221 .16492 L
.16492 .15741 L
.16572 .15521 L
.16925 .14549 L
.17282 .13578 L
.17463 .13089 L
.17642 .12607 L
.18006 .11636 L
.18374 .10664 L
.18434 .10506 L
.18745 .09693 L
.19121 .08722 L
.19406 .07991 L
.195 .07751 L
.19883 .06779 L
.20271 .05808 L
.20377 .05544 L
.20663 .04837 L
.21059 .03866 L
.21348 .03166 L
.21461 .02894 L
.21867 .01923 L
Mfstroke
.775 g
.01923 .52565 m
.01959 .52428 L
.02215 .51457 L
.02473 .50486 L
.02731 .49514 L
.02894 .48903 L
.02991 .48543 L
.03252 .47572 L
.03514 .46601 L
.03778 .45629 L
.03866 .45309 L
.04043 .44658 L
.0431 .43687 L
.04578 .42716 L
.04837 .41783 L
.04848 .41744 L
.05118 .40773 L
.05391 .39802 L
.05665 .38831 L
.05808 .38325 L
.0594 .37859 L
.06217 .36888 L
.06496 .35917 L
.06776 .34946 L
.06779 .34935 L
.07058 .33974 L
.07342 .33003 L
.07627 .32032 L
.07751 .31614 L
.07914 .31061 L
.08203 .30089 L
.08494 .29118 L
.08722 .2836 L
.08786 .28147 L
.0908 .27176 L
.09377 .26204 L
.09675 .25233 L
.09693 .25175 L
.09975 .24262 L
.10277 .23291 L
.10582 .22319 L
.10664 .22057 L
.10888 .21348 L
.11197 .20377 L
.11508 .19406 L
.11636 .19008 L
.11821 .18434 L
.12136 .17463 L
.12454 .16492 L
.12607 .16027 L
.12774 .15521 L
.13097 .14549 L
.13422 .13578 L
.13578 .13114 L
.13749 .12607 L
.1408 .11636 L
.14413 .10664 L
.14549 .10269 L
.14749 .09693 L
.15087 .08722 L
.15429 .07751 L
.15521 .07492 L
.15774 .06779 L
.16121 .05808 L
.16472 .04837 L
.16492 .04783 L
.16826 .03866 L
.17184 .02894 L
.17463 .02142 L
.17545 .01923 L
.01923 .01923 L
F
0 g
.01923 .52565 m
.01959 .52428 L
.02215 .51457 L
.02473 .50486 L
.02731 .49514 L
.02894 .48903 L
.02991 .48543 L
.03252 .47572 L
.03514 .46601 L
.03778 .45629 L
.03866 .45309 L
.04043 .44658 L
.0431 .43687 L
.04578 .42716 L
.04837 .41783 L
.04848 .41744 L
.05118 .40773 L
.05391 .39802 L
.05665 .38831 L
.05808 .38325 L
.0594 .37859 L
.06217 .36888 L
.06496 .35917 L
.06776 .34946 L
.06779 .34935 L
.07058 .33974 L
.07342 .33003 L
.07627 .32032 L
.07751 .31614 L
.07914 .31061 L
.08203 .30089 L
.08494 .29118 L
.08722 .2836 L
.08786 .28147 L
.0908 .27176 L
.09377 .26204 L
.09675 .25233 L
.09693 .25175 L
.09975 .24262 L
.10277 .23291 L
.10582 .22319 L
.10664 .22057 L
.10888 .21348 L
.11197 .20377 L
.11508 .19406 L
.11636 .19008 L
.11821 .18434 L
.12136 .17463 L
.12454 .16492 L
.12607 .16027 L
Mistroke
.12774 .15521 L
.13097 .14549 L
.13422 .13578 L
.13578 .13114 L
.13749 .12607 L
.1408 .11636 L
.14413 .10664 L
.14549 .10269 L
.14749 .09693 L
.15087 .08722 L
.15429 .07751 L
.15521 .07492 L
.15774 .06779 L
.16121 .05808 L
.16472 .04837 L
.16492 .04783 L
.16826 .03866 L
.17184 .02894 L
.17463 .02142 L
.17545 .01923 L
Mfstroke
.7 g
.01923 .43505 m
.02132 .42716 L
.02389 .41744 L
.02648 .40773 L
.02894 .3985 L
.02907 .39802 L
.03168 .38831 L
.03431 .37859 L
.03695 .36888 L
.03866 .36263 L
.0396 .35917 L
.04227 .34946 L
.04495 .33974 L
.04765 .33003 L
.04837 .32744 L
.05036 .32032 L
.05308 .31061 L
.05582 .30089 L
.05808 .29293 L
.05858 .29118 L
.06135 .28147 L
.06414 .27176 L
.06694 .26204 L
.06779 .2591 L
.06976 .25233 L
.0726 .24262 L
.07545 .23291 L
.07751 .22595 L
.07832 .22319 L
.08121 .21348 L
.08412 .20377 L
.08705 .19406 L
.08722 .19348 L
.08999 .18434 L
.09295 .17463 L
.09594 .16492 L
.09693 .16169 L
.09894 .15521 L
.10196 .14549 L
.10501 .13578 L
.10664 .13059 L
.10807 .12607 L
.11116 .11636 L
.11427 .10664 L
.11636 .10016 L
.1174 .09693 L
.12055 .08722 L
.12373 .07751 L
.12607 .07041 L
.12693 .06779 L
.13016 .05808 L
.13341 .04837 L
.13578 .04134 L
.13669 .03866 L
.13999 .02894 L
.14332 .01923 L
.01923 .01923 L
F
0 g
.01923 .43505 m
.02132 .42716 L
.02389 .41744 L
.02648 .40773 L
.02894 .3985 L
.02907 .39802 L
.03168 .38831 L
.03431 .37859 L
.03695 .36888 L
.03866 .36263 L
.0396 .35917 L
.04227 .34946 L
.04495 .33974 L
.04765 .33003 L
.04837 .32744 L
.05036 .32032 L
.05308 .31061 L
.05582 .30089 L
.05808 .29293 L
.05858 .29118 L
.06135 .28147 L
.06414 .27176 L
.06694 .26204 L
.06779 .2591 L
.06976 .25233 L
.0726 .24262 L
.07545 .23291 L
.07751 .22595 L
.07832 .22319 L
.08121 .21348 L
.08412 .20377 L
.08705 .19406 L
.08722 .19348 L
.08999 .18434 L
.09295 .17463 L
.09594 .16492 L
.09693 .16169 L
.09894 .15521 L
.10196 .14549 L
.10501 .13578 L
.10664 .13059 L
.10807 .12607 L
.11116 .11636 L
.11427 .10664 L
.11636 .10016 L
.1174 .09693 L
.12055 .08722 L
.12373 .07751 L
.12607 .07041 L
.12693 .06779 L
Mistroke
.13016 .05808 L
.13341 .04837 L
.13578 .04134 L
.13669 .03866 L
.13999 .02894 L
.14332 .01923 L
Mfstroke
.625 g
.01923 .35669 m
.02114 .34946 L
.02372 .33974 L
.02631 .33003 L
.02891 .32032 L
.02894 .32019 L
.03152 .31061 L
.03415 .30089 L
.03679 .29118 L
.03866 .28437 L
.03945 .28147 L
.04212 .27176 L
.0448 .26204 L
.0475 .25233 L
.04837 .24922 L
.05021 .24262 L
.05294 .23291 L
.05568 .22319 L
.05808 .21475 L
.05844 .21348 L
.06122 .20377 L
.06401 .19406 L
.06681 .18434 L
.06779 .18097 L
.06964 .17463 L
.07248 .16492 L
.07533 .15521 L
.07751 .14786 L
.07821 .14549 L
.0811 .13578 L
.08401 .12607 L
.08694 .11636 L
.08722 .11543 L
.08989 .10664 L
.09285 .09693 L
.09584 .08722 L
.09693 .08369 L
.09885 .07751 L
.10187 .06779 L
.10492 .05808 L
.10664 .05262 L
.10799 .04837 L
.11108 .03866 L
.11419 .02894 L
.11636 .02223 L
.11733 .01923 L
.01923 .01923 L
F
0 g
.01923 .35669 m
.02114 .34946 L
.02372 .33974 L
.02631 .33003 L
.02891 .32032 L
.02894 .32019 L
.03152 .31061 L
.03415 .30089 L
.03679 .29118 L
.03866 .28437 L
.03945 .28147 L
.04212 .27176 L
.0448 .26204 L
.0475 .25233 L
.04837 .24922 L
.05021 .24262 L
.05294 .23291 L
.05568 .22319 L
.05808 .21475 L
.05844 .21348 L
.06122 .20377 L
.06401 .19406 L
.06681 .18434 L
.06779 .18097 L
.06964 .17463 L
.07248 .16492 L
.07533 .15521 L
.07751 .14786 L
.07821 .14549 L
.0811 .13578 L
.08401 .12607 L
.08694 .11636 L
.08722 .11543 L
.08989 .10664 L
.09285 .09693 L
.09584 .08722 L
.09693 .08369 L
.09885 .07751 L
.10187 .06779 L
.10492 .05808 L
.10664 .05262 L
.10799 .04837 L
.11108 .03866 L
.11419 .02894 L
.11636 .02223 L
.11733 .01923 L
s
.55 g
.01923 .28665 m
.0206 .28147 L
.02318 .27176 L
.02576 .26204 L
.02836 .25233 L
.02894 .25017 L
.03098 .24262 L
.03361 .23291 L
.03625 .22319 L
.03866 .21438 L
.0389 .21348 L
.04157 .20377 L
.04425 .19406 L
.04695 .18434 L
.04837 .17927 L
.04966 .17463 L
.05239 .16492 L
.05513 .15521 L
.05789 .14549 L
.05808 .14483 L
.06067 .13578 L
.06346 .12607 L
.06626 .11636 L
.06779 .11108 L
.06908 .10664 L
.07192 .09693 L
.07478 .08722 L
.07751 .078 L
.07765 .07751 L
.08054 .06779 L
.08345 .05808 L
.08638 .04837 L
.08722 .0456 L
.08933 .03866 L
.09229 .02894 L
.09528 .01923 L
.01923 .01923 L
F
0 g
.01923 .28665 m
.0206 .28147 L
.02318 .27176 L
.02576 .26204 L
.02836 .25233 L
.02894 .25017 L
.03098 .24262 L
.03361 .23291 L
.03625 .22319 L
.03866 .21438 L
.0389 .21348 L
.04157 .20377 L
.04425 .19406 L
.04695 .18434 L
.04837 .17927 L
.04966 .17463 L
.05239 .16492 L
.05513 .15521 L
.05789 .14549 L
.05808 .14483 L
.06067 .13578 L
.06346 .12607 L
.06626 .11636 L
.06779 .11108 L
.06908 .10664 L
.07192 .09693 L
.07478 .08722 L
.07751 .078 L
.07765 .07751 L
.08054 .06779 L
.08345 .05808 L
.08638 .04837 L
.08722 .0456 L
.08933 .03866 L
.09229 .02894 L
.09528 .01923 L
s
.475 g
.01923 .22272 m
.02168 .21348 L
.02426 .20377 L
.02685 .19406 L
.02894 .18627 L
.02946 .18434 L
.03208 .17463 L
.03472 .16492 L
.03737 .15521 L
.03866 .1505 L
.04003 .14549 L
.04271 .13578 L
.0454 .12607 L
.0481 .11636 L
.04837 .11541 L
.05082 .10664 L
.05356 .09693 L
.05631 .08722 L
.05808 .081 L
.05908 .07751 L
.06186 .06779 L
.06466 .05808 L
.06747 .04837 L
.06779 .04727 L
.07031 .03866 L
.07315 .02894 L
.07602 .01923 L
.01923 .01923 L
F
0 g
.01923 .22272 m
.02168 .21348 L
.02426 .20377 L
.02685 .19406 L
.02894 .18627 L
.02946 .18434 L
.03208 .17463 L
.03472 .16492 L
.03737 .15521 L
.03866 .1505 L
.04003 .14549 L
.04271 .13578 L
.0454 .12607 L
.0481 .11636 L
.04837 .11541 L
.05082 .10664 L
.05356 .09693 L
.05631 .08722 L
.05808 .081 L
.05908 .07751 L
.06186 .06779 L
.06466 .05808 L
.06747 .04837 L
.06779 .04727 L
.07031 .03866 L
.07315 .02894 L
.07602 .01923 L
s
.4 g
.01923 .16354 m
.02144 .15521 L
.02402 .14549 L
.02662 .13578 L
.02894 .12711 L
.02922 .12607 L
.03185 .11636 L
.03448 .10664 L
.03713 .09693 L
.03866 .09136 L
.03979 .08722 L
.04247 .07751 L
.04516 .06779 L
.04787 .05808 L
.04837 .05629 L
.05059 .04837 L
.05332 .03866 L
.05608 .02894 L
.05808 .0219 L
.05884 .01923 L
.01923 .01923 L
F
0 g
.01923 .16354 m
.02144 .15521 L
.02402 .14549 L
.02662 .13578 L
.02894 .12711 L
.02922 .12607 L
.03185 .11636 L
.03448 .10664 L
.03713 .09693 L
.03866 .09136 L
.03979 .08722 L
.04247 .07751 L
.04516 .06779 L
.04787 .05808 L
.04837 .05629 L
.05059 .04837 L
.05332 .03866 L
.05608 .02894 L
.05808 .0219 L
.05884 .01923 L
s
.325 g
.01923 .10819 m
.01964 .10664 L
.02221 .09693 L
.0248 .08722 L
.0274 .07751 L
.02894 .07178 L
.03002 .06779 L
.03264 .05808 L
.03528 .04837 L
.03794 .03866 L
.03866 .03604 L
.04061 .02894 L
.04329 .01923 L
.01923 .01923 L
F
0 g
.01923 .10819 m
.01964 .10664 L
.02221 .09693 L
.0248 .08722 L
.0274 .07751 L
.02894 .07178 L
.03002 .06779 L
.03264 .05808 L
.03528 .04837 L
.03794 .03866 L
.03866 .03604 L
.04061 .02894 L
.04329 .01923 L
s
.25 g
.01923 .056 m
.02125 .04837 L
.02384 .03866 L
.02644 .02894 L
.02894 .01961 L
.02904 .01923 L
.01923 .01923 L
F
0 g
.01923 .056 m
.02125 .04837 L
.02384 .03866 L
.02644 .02894 L
.02894 .01961 L
.02904 .01923 L
s
.925 g
.97806 .98077 m
.97493 .97106 L
.97177 .96134 L
.97106 .95915 L
.96859 .95163 L
.96539 .94192 L
.96217 .93221 L
.96134 .92973 L
.95892 .92249 L
.95564 .91278 L
.95234 .90307 L
.95163 .90099 L
.94901 .89336 L
.94566 .88364 L
.94228 .87393 L
.94192 .8729 L
.93886 .86422 L
.93542 .85451 L
.93221 .84549 L
.93196 .84479 L
.92845 .83508 L
.92492 .82537 L
.92249 .81875 L
.92136 .81566 L
.91776 .80594 L
.91412 .79623 L
.91278 .79267 L
.91045 .78652 L
.90675 .77681 L
.90307 .76725 L
.90301 .76709 L
.89922 .75738 L
.8954 .74767 L
.89336 .74251 L
.89154 .73796 L
.88763 .72824 L
.88368 .71853 L
.88364 .71843 L
.87969 .70882 L
.87564 .69911 L
.87393 .69502 L
.87155 .68939 L
.86741 .67968 L
.86422 .67228 L
.86322 .66997 L
.85896 .66026 L
.85466 .65054 L
.85451 .65021 L
.85029 .64083 L
.84586 .63112 L
.84479 .6288 L
.84137 .62141 L
.83681 .61169 L
.83508 .60806 L
.83218 .60198 L
.82747 .59227 L
.82537 .58798 L
.82269 .58256 L
.81782 .57284 L
.81566 .56858 L
.81287 .56313 L
.80783 .55342 L
.80594 .54984 L
.80269 .54371 L
.79745 .53399 L
.79623 .53177 L
.7921 .52428 L
.78664 .51457 L
.78652 .51436 L
.78105 .50486 L
.77681 .49762 L
.77533 .49514 L
.76947 .48543 L
.76709 .48155 L
.76346 .47572 L
.75738 .46615 L
.75729 .46601 L
.75093 .45629 L
.74767 .45141 L
.74438 .44658 L
.73796 .43734 L
.73762 .43687 L
.73062 .42716 L
.72824 .42394 L
.72335 .41744 L
.71853 .41121 L
.71579 .40773 L
.70882 .39914 L
.70789 .39802 L
.6996 .38831 L
.69911 .38774 L
.69087 .37859 L
.68939 .377 L
.68161 .36888 L
.67968 .36694 L
.67171 .35917 L
.66997 .35754 L
.66101 .34946 L
.66026 .3488 L
.65054 .34074 L
.64929 .33974 L
.64083 .33334 L
.63618 .33003 L
.63112 .3266 L
.62141 .32054 L
.62103 .32032 L
.61169 .31514 L
.60242 .31061 L
.60198 .31041 L
.59227 .30634 L
.58256 .30294 L
.57556 .30089 L
.57284 .30021 L
.56313 .29814 L
.55342 .29674 L
.54371 .29601 L
.53399 .29594 L
.52428 .29654 L
.51457 .29781 L
.50486 .29974 L
.50017 .30089 L
.49514 .30234 L
.48543 .3056 L
.47572 .30953 L
.47331 .31061 L
.46601 .31413 L
.45629 .31939 L
.4547 .32032 L
.44658 .32532 L
.43954 .33003 L
.43687 .33192 L
.42716 .33918 L
.42643 .33974 L
.41744 .3471 L
.41471 .34946 L
.40773 .35569 L
.404 .35917 L
.39802 .36495 L
.39409 .36888 L
.38831 .37487 L
.38482 .37859 L
.37859 .38546 L
.37609 .38831 L
.36888 .39672 L
.36779 .39802 L
.35989 .40773 L
.35917 .40864 L
.35232 .41744 L
.34946 .42122 L
.34505 .42716 L
.33974 .43447 L
.33804 .43687 L
.33127 .44658 L
.33003 .44839 L
.32471 .45629 L
.32032 .46297 L
.31835 .46601 L
.31217 .47572 L
.31061 .47821 L
.30615 .48543 L
.30089 .49412 L
.30028 .49514 L
.29456 .50486 L
.29118 .5107 L
.28897 .51457 L
.2835 .52428 L
.28147 .52794 L
.27814 .53399 L
.2729 .54371 L
.27176 .54584 L
.26775 .55342 L
.2627 .56313 L
.26204 .56441 L
.25775 .57284 L
.25287 .58256 L
.25233 .58364 L
.24808 .59227 L
.24337 .60198 L
.24262 .60354 L
.23873 .61169 L
.23416 .62141 L
.23291 .6241 L
.22966 .63112 L
.22523 .64083 L
.22319 .64533 L
.22086 .65054 L
.21654 .66026 L
.21348 .66722 L
.21228 .66997 L
.20808 .67968 L
.20393 .68939 L
.20377 .68977 L
.19983 .69911 L
.19578 .70882 L
.19406 .71299 L
.19178 .71853 L
.18783 .72824 L
.18434 .73687 L
.18391 .73796 L
.18004 .74767 L
.17621 .75738 L
.17463 .76142 L
.17243 .76709 L
.16868 .77681 L
.16496 .78652 L
.16492 .78663 L
.16129 .79623 L
.15765 .80594 L
.15521 .8125 L
.15404 .81566 L
.15047 .82537 L
.14693 .83508 L
.14549 .83904 L
.14342 .84479 L
.13994 .85451 L
.13649 .86422 L
.13578 .86623 L
.13308 .87393 L
.12969 .88364 L
.12632 .89336 L
.12607 .89409 L
.12299 .90307 L
.11969 .91278 L
.1164 .92249 L
.11636 .92262 L
.11315 .93221 L
.10991 .94192 L
.1067 .95163 L
.10664 .9518 L
.10352 .96134 L
.10036 .97106 L
.09722 .98077 L
F
0 g
.97806 .98077 m
.97493 .97106 L
.97177 .96134 L
.97106 .95915 L
.96859 .95163 L
.96539 .94192 L
.96217 .93221 L
.96134 .92973 L
.95892 .92249 L
.95564 .91278 L
.95234 .90307 L
.95163 .90099 L
.94901 .89336 L
.94566 .88364 L
.94228 .87393 L
.94192 .8729 L
.93886 .86422 L
.93542 .85451 L
.93221 .84549 L
.93196 .84479 L
.92845 .83508 L
.92492 .82537 L
.92249 .81875 L
.92136 .81566 L
.91776 .80594 L
.91412 .79623 L
.91278 .79267 L
.91045 .78652 L
.90675 .77681 L
.90307 .76725 L
.90301 .76709 L
.89922 .75738 L
.8954 .74767 L
.89336 .74251 L
.89154 .73796 L
.88763 .72824 L
.88368 .71853 L
.88364 .71843 L
.87969 .70882 L
.87564 .69911 L
.87393 .69502 L
.87155 .68939 L
.86741 .67968 L
.86422 .67228 L
.86322 .66997 L
.85896 .66026 L
.85466 .65054 L
.85451 .65021 L
.85029 .64083 L
.84586 .63112 L
Mistroke
.84479 .6288 L
.84137 .62141 L
.83681 .61169 L
.83508 .60806 L
.83218 .60198 L
.82747 .59227 L
.82537 .58798 L
.82269 .58256 L
.81782 .57284 L
.81566 .56858 L
.81287 .56313 L
.80783 .55342 L
.80594 .54984 L
.80269 .54371 L
.79745 .53399 L
.79623 .53177 L
.7921 .52428 L
.78664 .51457 L
.78652 .51436 L
.78105 .50486 L
.77681 .49762 L
.77533 .49514 L
.76947 .48543 L
.76709 .48155 L
.76346 .47572 L
.75738 .46615 L
.75729 .46601 L
.75093 .45629 L
.74767 .45141 L
.74438 .44658 L
.73796 .43734 L
.73762 .43687 L
.73062 .42716 L
.72824 .42394 L
.72335 .41744 L
.71853 .41121 L
.71579 .40773 L
.70882 .39914 L
.70789 .39802 L
.6996 .38831 L
.69911 .38774 L
.69087 .37859 L
.68939 .377 L
.68161 .36888 L
.67968 .36694 L
.67171 .35917 L
.66997 .35754 L
.66101 .34946 L
.66026 .3488 L
.65054 .34074 L
Mistroke
.64929 .33974 L
.64083 .33334 L
.63618 .33003 L
.63112 .3266 L
.62141 .32054 L
.62103 .32032 L
.61169 .31514 L
.60242 .31061 L
.60198 .31041 L
.59227 .30634 L
.58256 .30294 L
.57556 .30089 L
.57284 .30021 L
.56313 .29814 L
.55342 .29674 L
.54371 .29601 L
.53399 .29594 L
.52428 .29654 L
.51457 .29781 L
.50486 .29974 L
.50017 .30089 L
.49514 .30234 L
.48543 .3056 L
.47572 .30953 L
.47331 .31061 L
.46601 .31413 L
.45629 .31939 L
.4547 .32032 L
.44658 .32532 L
.43954 .33003 L
.43687 .33192 L
.42716 .33918 L
.42643 .33974 L
.41744 .3471 L
.41471 .34946 L
.40773 .35569 L
.404 .35917 L
.39802 .36495 L
.39409 .36888 L
.38831 .37487 L
.38482 .37859 L
.37859 .38546 L
.37609 .38831 L
.36888 .39672 L
.36779 .39802 L
.35989 .40773 L
.35917 .40864 L
.35232 .41744 L
.34946 .42122 L
.34505 .42716 L
Mistroke
.33974 .43447 L
.33804 .43687 L
.33127 .44658 L
.33003 .44839 L
.32471 .45629 L
.32032 .46297 L
.31835 .46601 L
.31217 .47572 L
.31061 .47821 L
.30615 .48543 L
.30089 .49412 L
.30028 .49514 L
.29456 .50486 L
.29118 .5107 L
.28897 .51457 L
.2835 .52428 L
.28147 .52794 L
.27814 .53399 L
.2729 .54371 L
.27176 .54584 L
.26775 .55342 L
.2627 .56313 L
.26204 .56441 L
.25775 .57284 L
.25287 .58256 L
.25233 .58364 L
.24808 .59227 L
.24337 .60198 L
.24262 .60354 L
.23873 .61169 L
.23416 .62141 L
.23291 .6241 L
.22966 .63112 L
.22523 .64083 L
.22319 .64533 L
.22086 .65054 L
.21654 .66026 L
.21348 .66722 L
.21228 .66997 L
.20808 .67968 L
.20393 .68939 L
.20377 .68977 L
.19983 .69911 L
.19578 .70882 L
.19406 .71299 L
.19178 .71853 L
.18783 .72824 L
.18434 .73687 L
.18391 .73796 L
.18004 .74767 L
Mistroke
.17621 .75738 L
.17463 .76142 L
.17243 .76709 L
.16868 .77681 L
.16496 .78652 L
.16492 .78663 L
.16129 .79623 L
.15765 .80594 L
.15521 .8125 L
.15404 .81566 L
.15047 .82537 L
.14693 .83508 L
.14549 .83904 L
.14342 .84479 L
.13994 .85451 L
.13649 .86422 L
.13578 .86623 L
.13308 .87393 L
.12969 .88364 L
.12632 .89336 L
.12607 .89409 L
.12299 .90307 L
.11969 .91278 L
.1164 .92249 L
.11636 .92262 L
.11315 .93221 L
.10991 .94192 L
.1067 .95163 L
.10664 .9518 L
.10352 .96134 L
.10036 .97106 L
.09722 .98077 L
Mfstroke
.85 g
.92913 .98077 m
.9256 .97106 L
.92249 .96259 L
.92204 .96134 L
.91844 .95163 L
.91481 .94192 L
.91278 .93653 L
.91115 .93221 L
.90745 .92249 L
.90371 .91278 L
.90307 .91114 L
.89993 .90307 L
.89611 .89336 L
.89336 .88642 L
.89225 .88364 L
.88835 .87393 L
.8844 .86422 L
.88364 .86237 L
.88041 .85451 L
.87637 .84479 L
.87393 .83899 L
.87228 .83508 L
.86814 .82537 L
.86422 .81628 L
.86395 .81566 L
.8597 .80594 L
.85539 .79623 L
.85451 .79425 L
.85103 .78652 L
.8466 .77681 L
.84479 .77288 L
.84211 .76709 L
.83755 .75738 L
.83508 .75218 L
.83292 .74767 L
.82822 .73796 L
.82537 .73215 L
.82343 .72824 L
.81857 .71853 L
.81566 .7128 L
.81362 .70882 L
.80857 .69911 L
.80594 .69411 L
.80344 .68939 L
.79819 .67968 L
.79623 .6761 L
.79284 .66997 L
.78738 .66026 L
.78652 .65875 L
.78179 .65054 L
.77681 .64207 L
.77607 .64083 L
.7702 .63112 L
.76709 .62607 L
.76418 .62141 L
.758 .61169 L
.75738 .61074 L
.75164 .60198 L
.74767 .59607 L
.74508 .59227 L
.7383 .58256 L
.73796 .58208 L
.73128 .57284 L
.72824 .56875 L
.72399 .56313 L
.71853 .5561 L
.71641 .55342 L
.70882 .54411 L
.70848 .54371 L
.70016 .53399 L
.69911 .5328 L
.69138 .52428 L
.68939 .52216 L
.68206 .51457 L
.67968 .51219 L
.67209 .50486 L
.66997 .50288 L
.6613 .49514 L
.66026 .49425 L
.65054 .48629 L
.64945 .48543 L
.64083 .479 L
.63615 .47572 L
.63112 .47237 L
.62141 .46642 L
.62068 .46601 L
.61169 .46114 L
.60198 .45653 L
.60145 .45629 L
.59227 .45259 L
.58256 .44932 L
.57284 .44672 L
.5723 .44658 L
.56313 .44479 L
.55342 .44352 L
.54371 .44293 L
.53399 .44301 L
.52428 .44376 L
.51457 .44518 L
.50763 .44658 L
.50486 .44727 L
.49514 .45003 L
.48543 .45346 L
.47854 .45629 L
.47572 .45756 L
.46601 .46233 L
.45931 .46601 L
.45629 .46777 L
.44658 .47388 L
.44385 .47572 L
.43687 .48066 L
.43054 .48543 L
.42716 .48811 L
.41869 .49514 L
.41744 .49623 L
.4079 .50486 L
.40773 .50502 L
.39802 .51448 L
.39793 .51457 L
.38861 .52428 L
.38831 .5246 L
.37983 .53399 L
.37859 .5354 L
.37151 .54371 L
.36888 .54687 L
.36358 .55342 L
.35917 .55901 L
.35599 .56313 L
.34946 .57182 L
.3487 .57284 L
.34168 .58256 L
.33974 .5853 L
.3349 .59227 L
.33003 .59945 L
.32834 .60198 L
.32197 .61169 L
.32032 .61426 L
.31579 .62141 L
.31061 .62975 L
.30977 .63112 L
.3039 .64083 L
.30089 .64591 L
.29818 .65054 L
.29259 .66026 L
.29118 .66273 L
.28712 .66997 L
.28177 .67968 L
.28147 .68023 L
.27653 .68939 L
.27176 .6984 L
.27138 .69911 L
.26634 .70882 L
.26204 .71723 L
.26139 .71853 L
.25652 .72824 L
.25233 .73674 L
.25174 .73796 L
.24703 .74767 L
.24262 .75691 L
.2424 .75738 L
.23784 .76709 L
.23334 .77681 L
.23291 .77776 L
.22892 .78652 L
.22455 .79623 L
.22319 .79927 L
.22024 .80594 L
.21599 .81566 L
.21348 .82146 L
.2118 .82537 L
.20766 .83508 L
.20377 .84431 L
.20357 .84479 L
.19953 .85451 L
.19553 .86422 L
.19406 .86783 L
.19158 .87393 L
.18768 .88364 L
.18434 .89203 L
.18382 .89336 L
.18 .90307 L
.17622 .91278 L
.17463 .91689 L
.17248 .92249 L
.16877 .93221 L
.16511 .94192 L
.16492 .94242 L
.16148 .95163 L
.15788 .96134 L
.15521 .96862 L
.15432 .97106 L
.15079 .98077 L
F
0 g
.92913 .98077 m
.9256 .97106 L
.92249 .96259 L
.92204 .96134 L
.91844 .95163 L
.91481 .94192 L
.91278 .93653 L
.91115 .93221 L
.90745 .92249 L
.90371 .91278 L
.90307 .91114 L
.89993 .90307 L
.89611 .89336 L
.89336 .88642 L
.89225 .88364 L
.88835 .87393 L
.8844 .86422 L
.88364 .86237 L
.88041 .85451 L
.87637 .84479 L
.87393 .83899 L
.87228 .83508 L
.86814 .82537 L
.86422 .81628 L
.86395 .81566 L
.8597 .80594 L
.85539 .79623 L
.85451 .79425 L
.85103 .78652 L
.8466 .77681 L
.84479 .77288 L
.84211 .76709 L
.83755 .75738 L
.83508 .75218 L
.83292 .74767 L
.82822 .73796 L
.82537 .73215 L
.82343 .72824 L
.81857 .71853 L
.81566 .7128 L
.81362 .70882 L
.80857 .69911 L
.80594 .69411 L
.80344 .68939 L
.79819 .67968 L
.79623 .6761 L
.79284 .66997 L
.78738 .66026 L
.78652 .65875 L
.78179 .65054 L
Mistroke
.77681 .64207 L
.77607 .64083 L
.7702 .63112 L
.76709 .62607 L
.76418 .62141 L
.758 .61169 L
.75738 .61074 L
.75164 .60198 L
.74767 .59607 L
.74508 .59227 L
.7383 .58256 L
.73796 .58208 L
.73128 .57284 L
.72824 .56875 L
.72399 .56313 L
.71853 .5561 L
.71641 .55342 L
.70882 .54411 L
.70848 .54371 L
.70016 .53399 L
.69911 .5328 L
.69138 .52428 L
.68939 .52216 L
.68206 .51457 L
.67968 .51219 L
.67209 .50486 L
.66997 .50288 L
.6613 .49514 L
.66026 .49425 L
.65054 .48629 L
.64945 .48543 L
.64083 .479 L
.63615 .47572 L
.63112 .47237 L
.62141 .46642 L
.62068 .46601 L
.61169 .46114 L
.60198 .45653 L
.60145 .45629 L
.59227 .45259 L
.58256 .44932 L
.57284 .44672 L
.5723 .44658 L
.56313 .44479 L
.55342 .44352 L
.54371 .44293 L
.53399 .44301 L
.52428 .44376 L
.51457 .44518 L
.50763 .44658 L
Mistroke
.50486 .44727 L
.49514 .45003 L
.48543 .45346 L
.47854 .45629 L
.47572 .45756 L
.46601 .46233 L
.45931 .46601 L
.45629 .46777 L
.44658 .47388 L
.44385 .47572 L
.43687 .48066 L
.43054 .48543 L
.42716 .48811 L
.41869 .49514 L
.41744 .49623 L
.4079 .50486 L
.40773 .50502 L
.39802 .51448 L
.39793 .51457 L
.38861 .52428 L
.38831 .5246 L
.37983 .53399 L
.37859 .5354 L
.37151 .54371 L
.36888 .54687 L
.36358 .55342 L
.35917 .55901 L
.35599 .56313 L
.34946 .57182 L
.3487 .57284 L
.34168 .58256 L
.33974 .5853 L
.3349 .59227 L
.33003 .59945 L
.32834 .60198 L
.32197 .61169 L
.32032 .61426 L
.31579 .62141 L
.31061 .62975 L
.30977 .63112 L
.3039 .64083 L
.30089 .64591 L
.29818 .65054 L
.29259 .66026 L
.29118 .66273 L
.28712 .66997 L
.28177 .67968 L
.28147 .68023 L
.27653 .68939 L
.27176 .6984 L
Mistroke
.27138 .69911 L
.26634 .70882 L
.26204 .71723 L
.26139 .71853 L
.25652 .72824 L
.25233 .73674 L
.25174 .73796 L
.24703 .74767 L
.24262 .75691 L
.2424 .75738 L
.23784 .76709 L
.23334 .77681 L
.23291 .77776 L
.22892 .78652 L
.22455 .79623 L
.22319 .79927 L
.22024 .80594 L
.21599 .81566 L
.21348 .82146 L
.2118 .82537 L
.20766 .83508 L
.20377 .84431 L
.20357 .84479 L
.19953 .85451 L
.19553 .86422 L
.19406 .86783 L
.19158 .87393 L
.18768 .88364 L
.18434 .89203 L
.18382 .89336 L
.18 .90307 L
.17622 .91278 L
.17463 .91689 L
.17248 .92249 L
.16877 .93221 L
.16511 .94192 L
.16492 .94242 L
.16148 .95163 L
.15788 .96134 L
.15521 .96862 L
.15432 .97106 L
.15079 .98077 L
Mfstroke
.775 g
.88894 .98077 m
.885 .97106 L
.88364 .96774 L
.88102 .96134 L
.87698 .95163 L
.87393 .94437 L
.8729 .94192 L
.86876 .93221 L
.86458 .92249 L
.86422 .92167 L
.86033 .91278 L
.85603 .90307 L
.85451 .89965 L
.85168 .89336 L
.84725 .88364 L
.84479 .8783 L
.84277 .87393 L
.83822 .86422 L
.83508 .85762 L
.83359 .85451 L
.82889 .84479 L
.82537 .83761 L
.82412 .83508 L
.81926 .82537 L
.81566 .81827 L
.81432 .81566 L
.80928 .80594 L
.80594 .79961 L
.80415 .79623 L
.79892 .78652 L
.79623 .78161 L
.79358 .77681 L
.78812 .76709 L
.78652 .76429 L
.78254 .75738 L
.77683 .74767 L
.77681 .74764 L
.77097 .73796 L
.76709 .73166 L
.76497 .72824 L
.75879 .71853 L
.75738 .71635 L
.75244 .70882 L
.74767 .70171 L
.74589 .69911 L
.73913 .68939 L
.73796 .68774 L
.73213 .67968 L
.72824 .67445 L
.72486 .66997 L
.71853 .66183 L
.71729 .66026 L
.70938 .65054 L
.70882 .64987 L
.70108 .64083 L
.69911 .63859 L
.69233 .63112 L
.68939 .62798 L
.68304 .62141 L
.67968 .61805 L
.6731 .61169 L
.66997 .60878 L
.66235 .60198 L
.66026 .60019 L
.65055 .59227 L
.65054 .59226 L
.64083 .58501 L
.63733 .58256 L
.63112 .57843 L
.62197 .57284 L
.62141 .57252 L
.61169 .56728 L
.60293 .56313 L
.60198 .56272 L
.59227 .55882 L
.58256 .5556 L
.57448 .55342 L
.57284 .55304 L
.56313 .55116 L
.55342 .54995 L
.54371 .54942 L
.53399 .54955 L
.52428 .55035 L
.51457 .55183 L
.50702 .55342 L
.50486 .55398 L
.49514 .55679 L
.48543 .56028 L
.47861 .56313 L
.47572 .56444 L
.46601 .56928 L
.45957 .57284 L
.45629 .57478 L
.44658 .58095 L
.44422 .58256 L
.43687 .5878 L
.43099 .59227 L
.42716 .59532 L
.41919 .60198 L
.41744 .60351 L
.40844 .61169 L
.40773 .61237 L
.3985 .62141 L
.39802 .6219 L
.38921 .63112 L
.38831 .6321 L
.38046 .64083 L
.37859 .64297 L
.37216 .65054 L
.36888 .65452 L
.36425 .66026 L
.35917 .66673 L
.35668 .66997 L
.34946 .67962 L
.34941 .67968 L
.34241 .68939 L
.33974 .69318 L
.33564 .69911 L
.33003 .70741 L
.32909 .70882 L
.32274 .71853 L
.32032 .72231 L
.31657 .72824 L
.31061 .73788 L
.31056 .73796 L
.30471 .74767 L
.30089 .75413 L
.29899 .75738 L
.29341 .76709 L
.29118 .77104 L
.28796 .77681 L
.28261 .78652 L
.28147 .78863 L
.27738 .79623 L
.27225 .80594 L
.27176 .80688 L
.26721 .81566 L
.26227 .82537 L
.26204 .82581 L
.25741 .83508 L
.25263 .84479 L
.25233 .84541 L
.24793 .85451 L
.24331 .86422 L
.24262 .86568 L
.23875 .87393 L
.23427 .88364 L
.23291 .88662 L
.22985 .89336 L
.22549 .90307 L
.22319 .90823 L
.22119 .91278 L
.21694 .92249 L
.21348 .93052 L
.21276 .93221 L
.20862 .94192 L
.20454 .95163 L
.20377 .95347 L
.2005 .96134 L
.19651 .97106 L
.19406 .9771 L
.19257 .98077 L
F
0 g
.88894 .98077 m
.885 .97106 L
.88364 .96774 L
.88102 .96134 L
.87698 .95163 L
.87393 .94437 L
.8729 .94192 L
.86876 .93221 L
.86458 .92249 L
.86422 .92167 L
.86033 .91278 L
.85603 .90307 L
.85451 .89965 L
.85168 .89336 L
.84725 .88364 L
.84479 .8783 L
.84277 .87393 L
.83822 .86422 L
.83508 .85762 L
.83359 .85451 L
.82889 .84479 L
.82537 .83761 L
.82412 .83508 L
.81926 .82537 L
.81566 .81827 L
.81432 .81566 L
.80928 .80594 L
.80594 .79961 L
.80415 .79623 L
.79892 .78652 L
.79623 .78161 L
.79358 .77681 L
.78812 .76709 L
.78652 .76429 L
.78254 .75738 L
.77683 .74767 L
.77681 .74764 L
.77097 .73796 L
.76709 .73166 L
.76497 .72824 L
.75879 .71853 L
.75738 .71635 L
.75244 .70882 L
.74767 .70171 L
.74589 .69911 L
.73913 .68939 L
.73796 .68774 L
.73213 .67968 L
.72824 .67445 L
.72486 .66997 L
Mistroke
.71853 .66183 L
.71729 .66026 L
.70938 .65054 L
.70882 .64987 L
.70108 .64083 L
.69911 .63859 L
.69233 .63112 L
.68939 .62798 L
.68304 .62141 L
.67968 .61805 L
.6731 .61169 L
.66997 .60878 L
.66235 .60198 L
.66026 .60019 L
.65055 .59227 L
.65054 .59226 L
.64083 .58501 L
.63733 .58256 L
.63112 .57843 L
.62197 .57284 L
.62141 .57252 L
.61169 .56728 L
.60293 .56313 L
.60198 .56272 L
.59227 .55882 L
.58256 .5556 L
.57448 .55342 L
.57284 .55304 L
.56313 .55116 L
.55342 .54995 L
.54371 .54942 L
.53399 .54955 L
.52428 .55035 L
.51457 .55183 L
.50702 .55342 L
.50486 .55398 L
.49514 .55679 L
.48543 .56028 L
.47861 .56313 L
.47572 .56444 L
.46601 .56928 L
.45957 .57284 L
.45629 .57478 L
.44658 .58095 L
.44422 .58256 L
.43687 .5878 L
.43099 .59227 L
.42716 .59532 L
.41919 .60198 L
.41744 .60351 L
Mistroke
.40844 .61169 L
.40773 .61237 L
.3985 .62141 L
.39802 .6219 L
.38921 .63112 L
.38831 .6321 L
.38046 .64083 L
.37859 .64297 L
.37216 .65054 L
.36888 .65452 L
.36425 .66026 L
.35917 .66673 L
.35668 .66997 L
.34946 .67962 L
.34941 .67968 L
.34241 .68939 L
.33974 .69318 L
.33564 .69911 L
.33003 .70741 L
.32909 .70882 L
.32274 .71853 L
.32032 .72231 L
.31657 .72824 L
.31061 .73788 L
.31056 .73796 L
.30471 .74767 L
.30089 .75413 L
.29899 .75738 L
.29341 .76709 L
.29118 .77104 L
.28796 .77681 L
.28261 .78652 L
.28147 .78863 L
.27738 .79623 L
.27225 .80594 L
.27176 .80688 L
.26721 .81566 L
.26227 .82537 L
.26204 .82581 L
.25741 .83508 L
.25263 .84479 L
.25233 .84541 L
.24793 .85451 L
.24331 .86422 L
.24262 .86568 L
.23875 .87393 L
.23427 .88364 L
.23291 .88662 L
.22985 .89336 L
.22549 .90307 L
Mistroke
.22319 .90823 L
.22119 .91278 L
.21694 .92249 L
.21348 .93052 L
.21276 .93221 L
.20862 .94192 L
.20454 .95163 L
.20377 .95347 L
.2005 .96134 L
.19651 .97106 L
.19406 .9771 L
.19257 .98077 L
Mfstroke
.7 g
.85172 .98077 m
.8473 .97106 L
.84479 .96562 L
.84281 .96134 L
.83826 .95163 L
.83508 .94495 L
.83363 .94192 L
.82893 .93221 L
.82537 .92495 L
.82415 .92249 L
.81929 .91278 L
.81566 .90562 L
.81435 .90307 L
.80931 .89336 L
.80594 .88697 L
.80418 .88364 L
.79894 .87393 L
.79623 .86899 L
.79359 .86422 L
.78813 .85451 L
.78652 .85167 L
.78255 .84479 L
.77683 .83508 L
.77681 .83504 L
.77098 .82537 L
.76709 .81907 L
.76496 .81566 L
.75879 .80594 L
.75738 .80378 L
.75243 .79623 L
.74767 .78915 L
.74587 .78652 L
.7391 .77681 L
.73796 .7752 L
.73208 .76709 L
.72824 .76192 L
.7248 .75738 L
.71853 .74932 L
.71722 .74767 L
.7093 .73796 L
.70882 .73738 L
.70098 .72824 L
.69911 .72612 L
.69221 .71853 L
.68939 .71553 L
.68289 .70882 L
.67968 .70562 L
.67292 .69911 L
.66997 .69637 L
.66213 .68939 L
.66026 .6878 L
.65054 .67989 L
.65027 .67968 L
.64083 .67266 L
.63696 .66997 L
.63112 .66611 L
.62147 .66026 L
.62141 .66022 L
.61169 .65501 L
.60216 .65054 L
.60198 .65047 L
.59227 .6466 L
.58256 .6434 L
.57284 .64088 L
.57266 .64083 L
.56313 .63902 L
.55342 .63784 L
.54371 .63733 L
.53399 .6375 L
.52428 .63833 L
.51457 .63984 L
.50965 .64083 L
.50486 .64202 L
.49514 .64487 L
.48543 .64839 L
.48024 .65054 L
.47572 .65259 L
.46601 .65745 L
.46094 .66026 L
.45629 .66299 L
.44658 .6692 L
.44545 .66997 L
.43687 .67609 L
.43214 .67968 L
.42716 .68364 L
.42028 .68939 L
.41744 .69187 L
.40949 .69911 L
.40773 .70077 L
.39952 .70882 L
.39802 .71034 L
.3902 .71853 L
.38831 .72058 L
.38142 .72824 L
.37859 .7315 L
.37311 .73796 L
.36888 .74308 L
.36518 .74767 L
.35917 .75534 L
.3576 .75738 L
.35032 .76709 L
.34946 .76827 L
.34331 .77681 L
.33974 .78187 L
.33653 .78652 L
.33003 .79615 L
.32998 .79623 L
.32362 .80594 L
.32032 .8111 L
.31744 .81566 L
.31143 .82537 L
.31061 .82671 L
.30557 .83508 L
.30089 .843 L
.29985 .84479 L
.29427 .85451 L
.29118 .85997 L
.2888 .86422 L
.28346 .87393 L
.28147 .8776 L
.27822 .88364 L
.27309 .89336 L
.27176 .89591 L
.26805 .90307 L
.2631 .91278 L
.26204 .91489 L
.25824 .92249 L
.25346 .93221 L
.25233 .93454 L
.24876 .94192 L
.24414 .95163 L
.24262 .95486 L
.23958 .96134 L
.2351 .97106 L
.23291 .97585 L
.23067 .98077 L
F
0 g
.85172 .98077 m
.8473 .97106 L
.84479 .96562 L
.84281 .96134 L
.83826 .95163 L
.83508 .94495 L
.83363 .94192 L
.82893 .93221 L
.82537 .92495 L
.82415 .92249 L
.81929 .91278 L
.81566 .90562 L
.81435 .90307 L
.80931 .89336 L
.80594 .88697 L
.80418 .88364 L
.79894 .87393 L
.79623 .86899 L
.79359 .86422 L
.78813 .85451 L
.78652 .85167 L
.78255 .84479 L
.77683 .83508 L
.77681 .83504 L
.77098 .82537 L
.76709 .81907 L
.76496 .81566 L
.75879 .80594 L
.75738 .80378 L
.75243 .79623 L
.74767 .78915 L
.74587 .78652 L
.7391 .77681 L
.73796 .7752 L
.73208 .76709 L
.72824 .76192 L
.7248 .75738 L
.71853 .74932 L
.71722 .74767 L
.7093 .73796 L
.70882 .73738 L
.70098 .72824 L
.69911 .72612 L
.69221 .71853 L
.68939 .71553 L
.68289 .70882 L
.67968 .70562 L
.67292 .69911 L
.66997 .69637 L
.66213 .68939 L
Mistroke
.66026 .6878 L
.65054 .67989 L
.65027 .67968 L
.64083 .67266 L
.63696 .66997 L
.63112 .66611 L
.62147 .66026 L
.62141 .66022 L
.61169 .65501 L
.60216 .65054 L
.60198 .65047 L
.59227 .6466 L
.58256 .6434 L
.57284 .64088 L
.57266 .64083 L
.56313 .63902 L
.55342 .63784 L
.54371 .63733 L
.53399 .6375 L
.52428 .63833 L
.51457 .63984 L
.50965 .64083 L
.50486 .64202 L
.49514 .64487 L
.48543 .64839 L
.48024 .65054 L
.47572 .65259 L
.46601 .65745 L
.46094 .66026 L
.45629 .66299 L
.44658 .6692 L
.44545 .66997 L
.43687 .67609 L
.43214 .67968 L
.42716 .68364 L
.42028 .68939 L
.41744 .69187 L
.40949 .69911 L
.40773 .70077 L
.39952 .70882 L
.39802 .71034 L
.3902 .71853 L
.38831 .72058 L
.38142 .72824 L
.37859 .7315 L
.37311 .73796 L
.36888 .74308 L
.36518 .74767 L
.35917 .75534 L
.3576 .75738 L
Mistroke
.35032 .76709 L
.34946 .76827 L
.34331 .77681 L
.33974 .78187 L
.33653 .78652 L
.33003 .79615 L
.32998 .79623 L
.32362 .80594 L
.32032 .8111 L
.31744 .81566 L
.31143 .82537 L
.31061 .82671 L
.30557 .83508 L
.30089 .843 L
.29985 .84479 L
.29427 .85451 L
.29118 .85997 L
.2888 .86422 L
.28346 .87393 L
.28147 .8776 L
.27822 .88364 L
.27309 .89336 L
.27176 .89591 L
.26805 .90307 L
.2631 .91278 L
.26204 .91489 L
.25824 .92249 L
.25346 .93221 L
.25233 .93454 L
.24876 .94192 L
.24414 .95163 L
.24262 .95486 L
.23958 .96134 L
.2351 .97106 L
.23291 .97585 L
.23067 .98077 L
Mfstroke
.625 g
.8151 .98077 m
.81007 .97106 L
.80594 .96321 L
.80495 .96134 L
.79973 .95163 L
.79623 .94524 L
.7944 .94192 L
.78895 .93221 L
.78652 .92794 L
.78338 .92249 L
.77768 .91278 L
.77681 .91131 L
.77184 .90307 L
.76709 .89535 L
.76585 .89336 L
.7597 .88364 L
.75738 .88006 L
.75336 .87393 L
.74767 .86545 L
.74683 .86422 L
.74008 .85451 L
.73796 .85151 L
.7331 .84479 L
.72824 .83825 L
.72585 .83508 L
.71853 .82565 L
.71831 .82537 L
.71043 .81566 L
.70882 .81373 L
.70216 .80594 L
.69911 .80248 L
.69345 .79623 L
.68939 .7919 L
.6842 .78652 L
.67968 .782 L
.67431 .77681 L
.66997 .77277 L
.66362 .76709 L
.66026 .76421 L
.6519 .75738 L
.65054 .75632 L
.64083 .7491 L
.63879 .74767 L
.63112 .74256 L
.6236 .73796 L
.62141 .73669 L
.61169 .73149 L
.60488 .72824 L
.60198 .72697 L
.59227 .72312 L
.58256 .71994 L
.5775 .71853 L
.57284 .71743 L
.56313 .7156 L
.55342 .71443 L
.54371 .71394 L
.53399 .71413 L
.52428 .71498 L
.51457 .71651 L
.50552 .71853 L
.50486 .71871 L
.49514 .72158 L
.48543 .72513 L
.4781 .72824 L
.47572 .72935 L
.46601 .73424 L
.45938 .73796 L
.45629 .7398 L
.44658 .74603 L
.44419 .74767 L
.43687 .75294 L
.43107 .75738 L
.42716 .76052 L
.41936 .76709 L
.41744 .76877 L
.40867 .77681 L
.40773 .7777 L
.39878 .78652 L
.39802 .78729 L
.38953 .79623 L
.38831 .79756 L
.38081 .80594 L
.37859 .80851 L
.37255 .81566 L
.36888 .82012 L
.36467 .82537 L
.35917 .83241 L
.35712 .83508 L
.34987 .84479 L
.34946 .84537 L
.34289 .85451 L
.33974 .859 L
.33615 .86422 L
.33003 .8733 L
.32961 .87393 L
.32328 .88364 L
.32032 .88828 L
.31712 .89336 L
.31113 .90307 L
.31061 .90393 L
.30529 .91278 L
.30089 .92025 L
.29959 .92249 L
.29402 .93221 L
.29118 .93724 L
.28857 .94192 L
.28324 .95163 L
.28147 .95491 L
.27802 .96134 L
.2729 .97106 L
.27176 .97325 L
.26787 .98077 L
F
0 g
.8151 .98077 m
.81007 .97106 L
.80594 .96321 L
.80495 .96134 L
.79973 .95163 L
.79623 .94524 L
.7944 .94192 L
.78895 .93221 L
.78652 .92794 L
.78338 .92249 L
.77768 .91278 L
.77681 .91131 L
.77184 .90307 L
.76709 .89535 L
.76585 .89336 L
.7597 .88364 L
.75738 .88006 L
.75336 .87393 L
.74767 .86545 L
.74683 .86422 L
.74008 .85451 L
.73796 .85151 L
.7331 .84479 L
.72824 .83825 L
.72585 .83508 L
.71853 .82565 L
.71831 .82537 L
.71043 .81566 L
.70882 .81373 L
.70216 .80594 L
.69911 .80248 L
.69345 .79623 L
.68939 .7919 L
.6842 .78652 L
.67968 .782 L
.67431 .77681 L
.66997 .77277 L
.66362 .76709 L
.66026 .76421 L
.6519 .75738 L
.65054 .75632 L
.64083 .7491 L
.63879 .74767 L
.63112 .74256 L
.6236 .73796 L
.62141 .73669 L
.61169 .73149 L
.60488 .72824 L
.60198 .72697 L
.59227 .72312 L
Mistroke
.58256 .71994 L
.5775 .71853 L
.57284 .71743 L
.56313 .7156 L
.55342 .71443 L
.54371 .71394 L
.53399 .71413 L
.52428 .71498 L
.51457 .71651 L
.50552 .71853 L
.50486 .71871 L
.49514 .72158 L
.48543 .72513 L
.4781 .72824 L
.47572 .72935 L
.46601 .73424 L
.45938 .73796 L
.45629 .7398 L
.44658 .74603 L
.44419 .74767 L
.43687 .75294 L
.43107 .75738 L
.42716 .76052 L
.41936 .76709 L
.41744 .76877 L
.40867 .77681 L
.40773 .7777 L
.39878 .78652 L
.39802 .78729 L
.38953 .79623 L
.38831 .79756 L
.38081 .80594 L
.37859 .80851 L
.37255 .81566 L
.36888 .82012 L
.36467 .82537 L
.35917 .83241 L
.35712 .83508 L
.34987 .84479 L
.34946 .84537 L
.34289 .85451 L
.33974 .859 L
.33615 .86422 L
.33003 .8733 L
.32961 .87393 L
.32328 .88364 L
.32032 .88828 L
.31712 .89336 L
.31113 .90307 L
.31061 .90393 L
Mistroke
.30529 .91278 L
.30089 .92025 L
.29959 .92249 L
.29402 .93221 L
.29118 .93724 L
.28857 .94192 L
.28324 .95163 L
.28147 .95491 L
.27802 .96134 L
.2729 .97106 L
.27176 .97325 L
.26787 .98077 L
Mfstroke
.55 g
.77735 .98077 m
.77681 .97985 L
.7715 .97106 L
.76709 .9639 L
.7655 .96134 L
.75933 .95163 L
.75738 .94862 L
.75298 .94192 L
.74767 .93402 L
.74643 .93221 L
.73967 .92249 L
.73796 .92009 L
.73267 .91278 L
.72824 .90683 L
.7254 .90307 L
.71853 .89424 L
.71783 .89336 L
.70992 .88364 L
.70882 .88233 L
.70162 .87393 L
.69911 .87109 L
.69287 .86422 L
.68939 .86052 L
.68357 .85451 L
.67968 .85062 L
.67362 .84479 L
.66997 .8414 L
.66286 .83508 L
.66026 .83285 L
.65105 .82537 L
.65054 .82498 L
.64083 .81777 L
.6378 .81566 L
.63112 .81124 L
.62239 .80594 L
.62141 .80538 L
.61169 .8002 L
.60324 .79623 L
.60198 .79569 L
.59227 .79185 L
.58256 .78868 L
.57435 .78652 L
.57284 .78618 L
.56313 .78436 L
.55342 .78321 L
.54371 .78274 L
.53399 .78294 L
.52428 .78381 L
.51457 .78535 L
.50897 .78652 L
.50486 .78756 L
.49514 .79045 L
.48543 .79401 L
.48014 .79623 L
.47572 .79825 L
.46601 .80315 L
.461 .80594 L
.45629 .80873 L
.44658 .81498 L
.4456 .81566 L
.43687 .82191 L
.43234 .82537 L
.42716 .82951 L
.42052 .83508 L
.41744 .83778 L
.40976 .84479 L
.40773 .84672 L
.39982 .85451 L
.39802 .85634 L
.39052 .86422 L
.38831 .86663 L
.38177 .87393 L
.37859 .87759 L
.37347 .88364 L
.36888 .88922 L
.36556 .89336 L
.35917 .90153 L
.35799 .90307 L
.35072 .91278 L
.34946 .91451 L
.34372 .92249 L
.33974 .92816 L
.33695 .93221 L
.33041 .94192 L
.33003 .94249 L
.32406 .95163 L
.32032 .95749 L
.31789 .96134 L
.31188 .97106 L
.31061 .97316 L
.30603 .98077 L
F
0 g
.77735 .98077 m
.77681 .97985 L
.7715 .97106 L
.76709 .9639 L
.7655 .96134 L
.75933 .95163 L
.75738 .94862 L
.75298 .94192 L
.74767 .93402 L
.74643 .93221 L
.73967 .92249 L
.73796 .92009 L
.73267 .91278 L
.72824 .90683 L
.7254 .90307 L
.71853 .89424 L
.71783 .89336 L
.70992 .88364 L
.70882 .88233 L
.70162 .87393 L
.69911 .87109 L
.69287 .86422 L
.68939 .86052 L
.68357 .85451 L
.67968 .85062 L
.67362 .84479 L
.66997 .8414 L
.66286 .83508 L
.66026 .83285 L
.65105 .82537 L
.65054 .82498 L
.64083 .81777 L
.6378 .81566 L
.63112 .81124 L
.62239 .80594 L
.62141 .80538 L
.61169 .8002 L
.60324 .79623 L
.60198 .79569 L
.59227 .79185 L
.58256 .78868 L
.57435 .78652 L
.57284 .78618 L
.56313 .78436 L
.55342 .78321 L
.54371 .78274 L
.53399 .78294 L
.52428 .78381 L
.51457 .78535 L
.50897 .78652 L
Mistroke
.50486 .78756 L
.49514 .79045 L
.48543 .79401 L
.48014 .79623 L
.47572 .79825 L
.46601 .80315 L
.461 .80594 L
.45629 .80873 L
.44658 .81498 L
.4456 .81566 L
.43687 .82191 L
.43234 .82537 L
.42716 .82951 L
.42052 .83508 L
.41744 .83778 L
.40976 .84479 L
.40773 .84672 L
.39982 .85451 L
.39802 .85634 L
.39052 .86422 L
.38831 .86663 L
.38177 .87393 L
.37859 .87759 L
.37347 .88364 L
.36888 .88922 L
.36556 .89336 L
.35917 .90153 L
.35799 .90307 L
.35072 .91278 L
.34946 .91451 L
.34372 .92249 L
.33974 .92816 L
.33695 .93221 L
.33041 .94192 L
.33003 .94249 L
.32406 .95163 L
.32032 .95749 L
.31789 .96134 L
.31188 .97106 L
.31061 .97316 L
.30603 .98077 L
Mfstroke
.475 g
.73643 .98077 m
.72931 .97106 L
.72824 .96964 L
.7219 .96134 L
.71853 .95706 L
.71417 .95163 L
.70882 .94515 L
.70608 .94192 L
.69911 .93392 L
.69757 .93221 L
.68939 .92336 L
.68857 .92249 L
.67968 .91347 L
.67898 .91278 L
.66997 .90425 L
.66867 .90307 L
.66026 .89571 L
.65744 .89336 L
.65054 .88784 L
.64499 .88364 L
.64083 .88065 L
.63112 .87413 L
.63082 .87393 L
.62141 .86828 L
.61391 .86422 L
.61169 .8631 L
.60198 .8586 L
.59227 .85477 L
.59155 .85451 L
.58256 .85161 L
.57284 .84912 L
.56313 .84731 L
.55342 .84617 L
.54371 .84571 L
.53399 .84592 L
.52428 .8468 L
.51457 .84835 L
.50486 .85058 L
.49514 .85348 L
.49214 .85451 L
.48543 .85705 L
.47572 .8613 L
.46979 .86422 L
.46601 .86622 L
.45629 .87181 L
.45288 .87393 L
.44658 .87808 L
.43871 .88364 L
.43687 .88502 L
.42716 .89263 L
.42627 .89336 L
.41744 .90091 L
.41503 .90307 L
.40773 .90987 L
.40472 .91278 L
.39802 .9195 L
.39513 .92249 L
.38831 .9298 L
.38613 .93221 L
.37859 .94078 L
.37762 .94192 L
.36953 .95163 L
.36888 .95243 L
.3618 .96134 L
.35917 .96475 L
.35439 .97106 L
.34946 .97775 L
.34727 .98077 L
F
0 g
.73643 .98077 m
.72931 .97106 L
.72824 .96964 L
.7219 .96134 L
.71853 .95706 L
.71417 .95163 L
.70882 .94515 L
.70608 .94192 L
.69911 .93392 L
.69757 .93221 L
.68939 .92336 L
.68857 .92249 L
.67968 .91347 L
.67898 .91278 L
.66997 .90425 L
.66867 .90307 L
.66026 .89571 L
.65744 .89336 L
.65054 .88784 L
.64499 .88364 L
.64083 .88065 L
.63112 .87413 L
.63082 .87393 L
.62141 .86828 L
.61391 .86422 L
.61169 .8631 L
.60198 .8586 L
.59227 .85477 L
.59155 .85451 L
.58256 .85161 L
.57284 .84912 L
.56313 .84731 L
.55342 .84617 L
.54371 .84571 L
.53399 .84592 L
.52428 .8468 L
.51457 .84835 L
.50486 .85058 L
.49514 .85348 L
.49214 .85451 L
.48543 .85705 L
.47572 .8613 L
.46979 .86422 L
.46601 .86622 L
.45629 .87181 L
.45288 .87393 L
.44658 .87808 L
.43871 .88364 L
.43687 .88502 L
.42716 .89263 L
Mistroke
.42627 .89336 L
.41744 .90091 L
.41503 .90307 L
.40773 .90987 L
.40472 .91278 L
.39802 .9195 L
.39513 .92249 L
.38831 .9298 L
.38613 .93221 L
.37859 .94078 L
.37762 .94192 L
.36953 .95163 L
.36888 .95243 L
.3618 .96134 L
.35917 .96475 L
.35439 .97106 L
.34946 .97775 L
.34727 .98077 L
Mfstroke
.4 g
.68854 .98077 m
.67968 .97178 L
.67894 .97106 L
.66997 .96257 L
.66862 .96134 L
.66026 .95404 L
.65737 .95163 L
.65054 .94618 L
.64491 .94192 L
.64083 .93899 L
.63112 .93247 L
.6307 .93221 L
.62141 .92663 L
.61375 .92249 L
.61169 .92146 L
.60198 .91696 L
.59227 .91314 L
.59127 .91278 L
.58256 .90999 L
.57284 .90752 L
.56313 .90571 L
.55342 .90458 L
.54371 .90413 L
.53399 .90434 L
.52428 .90523 L
.51457 .9068 L
.50486 .90903 L
.49514 .91194 L
.49268 .91278 L
.48543 .91553 L
.47572 .91978 L
.4702 .92249 L
.46601 .92471 L
.45629 .93031 L
.45325 .93221 L
.44658 .93659 L
.43905 .94192 L
.43687 .94354 L
.42716 .95116 L
.42658 .95163 L
.41744 .95946 L
.41534 .96134 L
.40773 .96842 L
.40501 .97106 L
.39802 .97807 L
.39541 .98077 L
F
0 g
.68854 .98077 m
.67968 .97178 L
.67894 .97106 L
.66997 .96257 L
.66862 .96134 L
.66026 .95404 L
.65737 .95163 L
.65054 .94618 L
.64491 .94192 L
.64083 .93899 L
.63112 .93247 L
.6307 .93221 L
.62141 .92663 L
.61375 .92249 L
.61169 .92146 L
.60198 .91696 L
.59227 .91314 L
.59127 .91278 L
.58256 .90999 L
.57284 .90752 L
.56313 .90571 L
.55342 .90458 L
.54371 .90413 L
.53399 .90434 L
.52428 .90523 L
.51457 .9068 L
.50486 .90903 L
.49514 .91194 L
.49268 .91278 L
.48543 .91553 L
.47572 .91978 L
.4702 .92249 L
.46601 .92471 L
.45629 .93031 L
.45325 .93221 L
.44658 .93659 L
.43905 .94192 L
.43687 .94354 L
.42716 .95116 L
.42658 .95163 L
.41744 .95946 L
.41534 .96134 L
.40773 .96842 L
.40501 .97106 L
.39802 .97807 L
.39541 .98077 L
s
.325 g
.62046 .98077 m
.61169 .97614 L
.60198 .97165 L
.60059 .97106 L
.59227 .96783 L
.58256 .96469 L
.57284 .96222 L
.56876 .96134 L
.56313 .96042 L
.55342 .9593 L
.54371 .95885 L
.53399 .95908 L
.52428 .95997 L
.51548 .96134 L
.51457 .96154 L
.50486 .96379 L
.49514 .96671 L
.48543 .9703 L
.48357 .97106 L
.47572 .97456 L
.46601 .9795 L
.4637 .98077 L
F
0 g
.62046 .98077 m
.61169 .97614 L
.60198 .97165 L
.60059 .97106 L
.59227 .96783 L
.58256 .96469 L
.57284 .96222 L
.56876 .96134 L
.56313 .96042 L
.55342 .9593 L
.54371 .95885 L
.53399 .95908 L
.52428 .95997 L
.51548 .96134 L
.51457 .96154 L
.50486 .96379 L
.49514 .96671 L
.48543 .9703 L
.48357 .97106 L
.47572 .97456 L
.46601 .9795 L
.4637 .98077 L
s
.925 g
.98077 .45126 m
.97926 .44658 L
.97613 .43687 L
.973 .42716 L
.97106 .42119 L
.96984 .41744 L
.96664 .40773 L
.96342 .39802 L
.96134 .3918 L
.96018 .38831 L
.95691 .37859 L
.95361 .36888 L
.95163 .36309 L
.95029 .35917 L
.94694 .34946 L
.94356 .33974 L
.94192 .33507 L
.94015 .33003 L
.93671 .32032 L
.93324 .31061 L
.93221 .30773 L
.92974 .30089 L
.92621 .29118 L
.92264 .28147 L
.92249 .28108 L
.91904 .27176 L
.9154 .26204 L
.91278 .25512 L
.91173 .25233 L
.90802 .24262 L
.90427 .23291 L
.90307 .22983 L
.90048 .22319 L
.89665 .21348 L
.89336 .20524 L
.89277 .20377 L
.88885 .19406 L
.88489 .18434 L
.88364 .18132 L
.88088 .17463 L
.87682 .16492 L
.87393 .15809 L
.87271 .15521 L
.86854 .14549 L
.86432 .13578 L
.86422 .13555 L
.86005 .12607 L
.85571 .11636 L
.85451 .11369 L
.85131 .10664 L
.84685 .09693 L
.84479 .09251 L
.84232 .08722 L
.83771 .07751 L
.83508 .07202 L
.83304 .06779 L
.82828 .05808 L
.82537 .05222 L
.82344 .04837 L
.81852 .03866 L
.81566 .0331 L
.8135 .02894 L
.80839 .01923 L
.98077 .01923 L
F
0 g
.98077 .45126 m
.97926 .44658 L
.97613 .43687 L
.973 .42716 L
.97106 .42119 L
.96984 .41744 L
.96664 .40773 L
.96342 .39802 L
.96134 .3918 L
.96018 .38831 L
.95691 .37859 L
.95361 .36888 L
.95163 .36309 L
.95029 .35917 L
.94694 .34946 L
.94356 .33974 L
.94192 .33507 L
.94015 .33003 L
.93671 .32032 L
.93324 .31061 L
.93221 .30773 L
.92974 .30089 L
.92621 .29118 L
.92264 .28147 L
.92249 .28108 L
.91904 .27176 L
.9154 .26204 L
.91278 .25512 L
.91173 .25233 L
.90802 .24262 L
.90427 .23291 L
.90307 .22983 L
.90048 .22319 L
.89665 .21348 L
.89336 .20524 L
.89277 .20377 L
.88885 .19406 L
.88489 .18434 L
.88364 .18132 L
.88088 .17463 L
.87682 .16492 L
.87393 .15809 L
.87271 .15521 L
.86854 .14549 L
.86432 .13578 L
.86422 .13555 L
.86005 .12607 L
.85571 .11636 L
.85451 .11369 L
.85131 .10664 L
Mistroke
.84685 .09693 L
.84479 .09251 L
.84232 .08722 L
.83771 .07751 L
.83508 .07202 L
.83304 .06779 L
.82828 .05808 L
.82537 .05222 L
.82344 .04837 L
.81852 .03866 L
.81566 .0331 L
.8135 .02894 L
.80839 .01923 L
Mfstroke
.85 g
.98077 .30747 m
.97866 .30089 L
.97553 .29118 L
.97238 .28147 L
.97106 .2774 L
.96921 .27176 L
.96601 .26204 L
.96279 .25233 L
.96134 .248 L
.95954 .24262 L
.95627 .23291 L
.95297 .22319 L
.95163 .21929 L
.94964 .21348 L
.94628 .20377 L
.9429 .19406 L
.94192 .19126 L
.93949 .18434 L
.93604 .17463 L
.93257 .16492 L
.93221 .16391 L
.92906 .15521 L
.92553 .14549 L
.92249 .13724 L
.92195 .13578 L
.91835 .12607 L
.91471 .11636 L
.91278 .11126 L
.91103 .10664 L
.90732 .09693 L
.90356 .08722 L
.90307 .08595 L
.89977 .07751 L
.89593 .06779 L
.89336 .06133 L
.89206 .05808 L
.88814 .04837 L
.88417 .03866 L
.88364 .03739 L
.88015 .02894 L
.87609 .01923 L
.98077 .01923 L
F
0 g
.98077 .30747 m
.97866 .30089 L
.97553 .29118 L
.97238 .28147 L
.97106 .2774 L
.96921 .27176 L
.96601 .26204 L
.96279 .25233 L
.96134 .248 L
.95954 .24262 L
.95627 .23291 L
.95297 .22319 L
.95163 .21929 L
.94964 .21348 L
.94628 .20377 L
.9429 .19406 L
.94192 .19126 L
.93949 .18434 L
.93604 .17463 L
.93257 .16492 L
.93221 .16391 L
.92906 .15521 L
.92553 .14549 L
.92249 .13724 L
.92195 .13578 L
.91835 .12607 L
.91471 .11636 L
.91278 .11126 L
.91103 .10664 L
.90732 .09693 L
.90356 .08722 L
.90307 .08595 L
.89977 .07751 L
.89593 .06779 L
.89336 .06133 L
.89206 .05808 L
.88814 .04837 L
.88417 .03866 L
.88364 .03739 L
.88015 .02894 L
.87609 .01923 L
s
.775 g
.98077 .20217 m
.97817 .19406 L
.97504 .18434 L
.97189 .17463 L
.97106 .17209 L
.96871 .16492 L
.96551 .15521 L
.96228 .14549 L
.96134 .14269 L
.95903 .13578 L
.95575 .12607 L
.95245 .11636 L
.95163 .11398 L
.94911 .10664 L
.94576 .09693 L
.94237 .08722 L
.94192 .08594 L
.93895 .07751 L
.9355 .06779 L
.93221 .05859 L
.93202 .05808 L
.92852 .04837 L
.92497 .03866 L
.92249 .03191 L
.9214 .02894 L
.91779 .01923 L
.98077 .01923 L
F
0 g
.98077 .20217 m
.97817 .19406 L
.97504 .18434 L
.97189 .17463 L
.97106 .17209 L
.96871 .16492 L
.96551 .15521 L
.96228 .14549 L
.96134 .14269 L
.95903 .13578 L
.95575 .12607 L
.95245 .11636 L
.95163 .11398 L
.94911 .10664 L
.94576 .09693 L
.94237 .08722 L
.94192 .08594 L
.93895 .07751 L
.9355 .06779 L
.93221 .05859 L
.93202 .05808 L
.92852 .04837 L
.92497 .03866 L
.92249 .03191 L
.9214 .02894 L
.91779 .01923 L
s
.7 g
.98077 .11491 m
.97812 .10664 L
.97499 .09693 L
.97184 .08722 L
.97106 .08483 L
.96866 .07751 L
.96546 .06779 L
.96223 .05808 L
.96134 .05543 L
.95898 .04837 L
.9557 .03866 L
.95239 .02894 L
.95163 .02672 L
.94906 .01923 L
.98077 .01923 L
F
0 g
.98077 .11491 m
.97812 .10664 L
.97499 .09693 L
.97184 .08722 L
.97106 .08483 L
.96866 .07751 L
.96546 .06779 L
.96223 .05808 L
.96134 .05543 L
.95898 .04837 L
.9557 .03866 L
.95239 .02894 L
.95163 .02672 L
.94906 .01923 L
s
.625 g
.98077 .03873 m
.98074 .03866 L
.97763 .02894 L
.9745 .01923 L
.98077 .01923 L
F
0 g
.98077 .03873 m
.98074 .03866 L
.97763 .02894 L
.9745 .01923 L
s
0 0 0 r
.055 w
.98077 .72025 Mdot
0 1 1 r
.045 w
.01923 .72025 Mdot
.03003 .98077 Mdot
.12709 .62649 Mdot
.21143 .40595 Mdot
.30251 .21458 Mdot
.37254 .12328 Mdot
.47169 .01923 Mdot
.51677 .0312 Mdot
.60709 .02107 Mdot
.64629 .06807 Mdot
.72652 .1324 Mdot
.75919 .19841 Mdot
.82713 .30697 Mdot
.85326 .37673 Mdot
.90792 .50032 Mdot
.92546 .55688 Mdot
.9625 .6593 Mdot
.96998 .68668 Mdot
.98017 .71801 Mdot
.98071 .72006 Mdot
.98077 .72025 Mdot
.98077 .72025 Mdot
1 0 0 r
.0325 w
.01923 .72025 Mdot
.03003 .98077 Mdot
.12709 .62649 Mdot
.21143 .40595 Mdot
.30251 .21458 Mdot
.37254 .12328 Mdot
.47169 .01923 Mdot
.51677 .0312 Mdot
.60709 .02107 Mdot
.64629 .06807 Mdot
.72652 .1324 Mdot
.75919 .19841 Mdot
.82713 .30697 Mdot
.85326 .37673 Mdot
.90792 .50032 Mdot
.92546 .55688 Mdot
.9625 .6593 Mdot
.96998 .68668 Mdot
.98017 .71801 Mdot
.98071 .72006 Mdot
.98077 .72025 Mdot
.98077 .72025 Mdot
0 1 0 r
.02 w
.01923 .72025 Mdot
.03003 .98077 Mdot
.12709 .62649 Mdot
.21143 .40595 Mdot
.30251 .21458 Mdot
.37254 .12328 Mdot
.47169 .01923 Mdot
.51677 .0312 Mdot
.60709 .02107 Mdot
.64629 .06807 Mdot
.72652 .1324 Mdot
.75919 .19841 Mdot
.82713 .30697 Mdot
.85326 .37673 Mdot
.90792 .50032 Mdot
.92546 .55688 Mdot
.9625 .6593 Mdot
.96998 .68668 Mdot
.98017 .71801 Mdot
.98071 .72006 Mdot
.98077 .72025 Mdot
.98077 .72025 Mdot
0 0 1 r
.5 Mabswid
.01923 .72025 m
.01923 .72025 L
.03003 .98077 L
.12709 .62649 L
.21143 .40595 L
.30251 .21458 L
.37254 .12328 L
.47169 .01923 L
.51677 .0312 L
.60709 .02107 L
.64629 .06807 L
.72652 .1324 L
.75919 .19841 L
.82713 .30697 L
.85326 .37673 L
.90792 .50032 L
.92546 .55688 L
.9625 .6593 L
.96998 .68668 L
.98017 .71801 L
.98071 .72006 L
.98077 .72025 L
.98077 .72025 L
s
.015 w
.01923 .72025 Mdot
.01923 .72025 Mdot
.03003 .98077 Mdot
.12709 .62649 Mdot
.21143 .40595 Mdot
.30251 .21458 Mdot
.37254 .12328 Mdot
.47169 .01923 Mdot
.51677 .0312 Mdot
.60709 .02107 Mdot
.64629 .06807 Mdot
.72652 .1324 Mdot
.75919 .19841 Mdot
.82713 .30697 Mdot
.85326 .37673 Mdot
.90792 .50032 Mdot
.92546 .55688 Mdot
.9625 .6593 Mdot
.96998 .68668 Mdot
.98017 .71801 Mdot
.98071 .72006 Mdot
.98077 .72025 Mdot
.98077 .72025 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[19]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00<P3oool5
00000300oooo0P0000040?ooo`800000103oool2000002l0oooo0P00000b0?ooo`800000103oool2
000000@0oooo0P00000a0?ooo`D00000103oool003@0oooo00<000000?ooo`3oool0;`3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000002d0oooo00@000000?ooo`3oool00000
<03oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000380oooo00<000000?oo
o`3oool0103oool003@0oooo00<000000?ooo`3oool0;`3oool010000000oooo0?ooo`00000;0?oo
o`030000003oool0oooo02/0oooo00@000000?ooo`3oool00000<03oool010000000oooo0?ooo`00
000;0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0103oool002`0oooo10000004
0?ooo`030000003oool0oooo02T0oooo100000020?ooo`040000003oool0oooo000000T0oooo0P00
000^0?ooo`040000003oool0oooo00000300oooo00@000000?ooo`3oool000002@3oool2000003<0
oooo00<000000?ooo`3oool0103oool003@0oooo00<000000?ooo`3oool0;`3oool010000000oooo
0?ooo`0000090?ooo`030000003oool0oooo02d0oooo00@000000?ooo`3oool00000<03oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0103oool0
03<0oooo0P00000b0?ooo`8000002P3oool3000002h0oooo0P00000b0?ooo`8000002P3oool30000
0340oooo0P0000060?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`005@3oooml000000<00?ooR`0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00T0oooo00<00000003oo`00ool01@00ool40?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`3oool3003oo`@0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0080
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo03L0oooo
00<000000?ooo`3oool0803oool3003oo`80o`001000ool>0?ooo`030000003oool0oooo00/0oooo
0P00ool20?l000<00?oo9@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0080oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`1f0?ooo`03003oo`3o0000o`0000<00?l000<0
o`00003oo`00ool06`3oool00`00ool0o`000?l000040?l000800?ooH`3oool100000040oooo000E
0?ooo`030000003oool0oooo07D0oooo0P00ool0103o00000?l0003o00000?l2003o00<00?oo1@3o
ool3003ooa80oooo00<00?oo0?l0003o00000`00o`000`3o00000?oo003oo`1S0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0:03oool01000ool0o`000?l00000o`030000o`04003o
003o00000?oo003oo`<0oooo0P00ool20?l000<00?oo3`3oool00`00ool0o`000?l00002003o0004
0000o`00o`000?l00?l000800?oo;`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0?clo00@0000005=CD`1C
De<000000`1VIVH00`000000NGUi07UiN@0207UiN@030000002<S8`0S8b<0080S8b<00<0000009nO
W`2OWil00`2OWil00`000000/k>c0;>c/`040;>c/`0300000036a/H0a/K600D0a/K600<000000=WI
f@3IfMT02@3IfMT00`000000k>c/0>c/k00@0>c/k0030000003oool0oooo02P0oooo00@00?oo0?l0
003o00000?l00P000?l00`00o`00003o0000o`020000o`80oooo00<00?oo0?l0003o00000`00o`00
0`3o00000?oo003oo`0>0?ooo`L0003o00@00?l00?l00000ool00?oo<03oool00`000000k>c/0>c/
k00?0>c/k0030000003IfMT0fMWI00P0fMWI00<000000<K6aP36a/H01@36a/H00`000000/k>c0;>c
/`040;>c/`030000003oool0oooo00<0oooo0@0000010?ooo`003P3oool2000000D0oooo00<00000
0?ooo`3oool00P3oool203lo?`050000001CDe<0De=C05=CD`0000000`1VIVH01@000000NGUi07Ui
N@1iNGT0000000@0S8b<00<0000009nOW`2OWil00`2OWil00`000000/k>c0;>c/`040;>c/`030000
0036a/H0a/K600D0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00@0>c/k0030000
003oool0oooo02X0oooo00<00?oo0?l000000?l00`00o`00103o00000?oo003oo`3oool40000o`D0
0?l00P00ool20?ooo``0003o0P00ool00`3o00000?l0003o00020000o`04003o0000ool00?oo003o
oc00oooo00<000000>c/k03/k>`03`3/k>`00`000000fMWI0=WIf@090=WIf@0300000036a/H0a/K6
00D0a/K600<000000;>c/`2c/k<00`2c/k<00`000000oooo0?ooo`030?ooo`4000000@3oool000d0
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`80?clo00D0000005=C
D`1CDe<0De=C0000000306IVIP050000001iNGT0NGUi07UiN@000000102<S8`00`000000WinO09nO
W`0309nOW`030000002c/k<0/k>c00@0/k>c00<000000<K6aP36a/H01@36a/H00`000000fMWI0=WI
f@090=WIf@030000003/k>`0k>c/0100k>c/00<000000?ooo`3oool0:P3oool00`00ool0003o0?l0
00040?l000800?oo0P3oool00`00ool0o`000?l000090000o`d0oooo00<00?oo0?l0003o00000`00
o`000`000?l00?oo003oo`0b0?ooo`030000003/k>`0k>c/00l0k>c/00<000000=WIf@3IfMT0203I
fMT00`000000a/K60<K6aP050<K6aP030000002c/k<0/k>c00<0/k>c00<000000?ooo`3oool00`3o
ool100000040oooo000=0?ooo`040000003oool0oooo000000@0oooo0P0000030?ooo`0303lo?`00
0000De=C0080De=C00D0000006IVIP1VIVH0IVIV0000000307UiN@030000002<S8`0S8b<00<0S8b<
00<0000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`040;>c/`0300000036a/H0a/K600H0a/K6
00<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00@0>c/k0030000003oool0oooo02/0oooo
00<0003o003oo`00ool00P3o0003003oo`<0oooo00@00?oo0?l0003o00000?l00`000?l01000o`00
o`00003oo`00ool>0?ooo`<00?oo0P3o00001000ool0003o003oo`00oolb0?ooo`030000003/k>`0
k>c/00l0k>c/00<000000=WIf@3IfMT0203IfMT00`000000a/K60<K6aP050<K6aP030000002c/k<0
/k>c00<0/k>c00<000000?ooo`3oool00P3oool200000040oooo000=0?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool00P3oool00`0o?cl0000005=CD`0205=CD`050000001VIVH0
IVIV06IVIP0000000`1iNGT00`000000S8b<08b<S00308b<S0030000002OWil0WinO0080WinO00<0
00000;>c/`2c/k<0102c/k<00`000000a/K60<K6aP060<K6aP030000003IfMT0fMWI00P0fMWI00<0
00000>c/k03/k>`03`3/k>`2000002`0oooo00@0003o0?ooo`3oool0oooo0`00ool50?ooo`800?oo
0P3o00001000o`00003o003o003o0003003oo`l0oooo1P00ool00`000?l0oooo0?ooo`0b0?ooo`03
0000003/k>`0k>c/00h0k>c/0P0000090=WIf@0300000036a/H0a/K600H0a/K600<000000;>c/`2c
/k<00`2c/k<2000000<0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`03
0000003oool0oooo0080oooo00<0?clo0000001CDe<00P1CDe<01@000000IVIV06IVIP1VIVH00000
00<0NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`0309nOW`030000002c/k<0/k>c
00@0/k>c00<000000<K6aP36a/H01P36a/H00`000000fMWI0=WIf@080=WIf@030000003/k>`0k>c/
00l0k>c/00<000000?ooo`3oool0:P3oool00`000?l0oooo0?ooo`0;0?ooo`03003oo`3o0000o`00
00@0o`000P00oolB0?ooo`<00?oo0P3oool00`000?l0oooo0?ooo`0a0?ooo`030000003/k>`0k>c/
00l0k>c/00<000000=WIf@3IfMT01`3IfMT00`000000a/K60<K6aP060<K6aP030000002c/k<0/k>c
00<0/k>c1@3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`05
0000001CDe<0De=C05=CD`0000000`1VIVH00`000000NGUi07UiN@0207UiN@030000002<S8`0S8b<
0080S8b<00<0000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`040;>c/`0300000036a/H0a/K6
00H0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00?0>c/k0030000003oool0oooo
02X0oooo00<0003o0?ooo`3oool0303oool3003oo`80o`001000oolH0?ooo`030000o`3oool0oooo
0340oooo00<000000>c/k03/k>`03`3/k>`00`000000fMWI0=WIf@070=WIf@0300000036a/H0a/K6
00D0a/K600<000000;>c/`2c/k<00`2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool01@000000De=C05=CD`1CDe<0000000<0IVIV00<0000007UiN@1iNGT00P1iNGT00`00
0000S8b<08b<S00208b<S0030000002OWil0WinO0080WinO00<000000;>c/`2c/k<0102c/k<00`00
0000a/K60<K6aP060<K6aP030000003IfMT0fMWI00P0fMWI00<000000>c/k03/k>`03`3/k>`00`00
0000oooo0?ooo`0Z0?ooo`030000o`3oool0oooo00d0oooo1`00oolJ0?ooo`030000o`3oool0oooo
00<00?oo;@3oool00`000000k>c/0>c/k00?0>c/k0030000003IfMT0fMWI00L0fMWI00<000000<K6
aP36a/H01@36a/H00`000000/k>c0;>c/`030;>c/`D0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooo`040000001CDe<0De=C000000@0IVIV00D0000007UiN@1iNGT0NGUi00000004
08b<S0030000002OWil0WinO00<0WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP06
0<K6aP030000003IfMT0fMWI00P0fMWI00<000000>c/k03/k>`03`3/k>`00`000000oooo0?ooo`0Z
0?ooo`030000o`3oool0oooo0100oooo0`00oolM0?ooo`030000o`00ool00?oo00@00?oo;03oool0
0`000000k>c/0>c/k00>0>c/k0030000003IfMT0fMWI00L0fMWI00<000000<K6aP36a/H01@36a/H0
0`000000/k>c0;>c/`030;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`040000001CDe<0De=C000000@0IVIV00D0000007UiN@1iNGT0NGUi0000000408b<S0030000002O
Wil0WinO00<0WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP060<K6aP030000003I
fMT0fMWI00P0fMWI00<000000>c/k03/k>`03`3/k>`00`000000oooo0?ooo`0Y0?ooo`030000o`3o
ool0oooo0300oooo00@00?oo0000o`00ool00?oo0P3o0003003oob`0oooo00<000000>c/k03/k>`0
3P3/k>`00`000000fMWI0=WIf@070=WIf@0300000036a/H0a/K600D0a/K600<000000;>c/`2c/k<0
0P2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool305=CD`030000001V
IVH0IVIV0080IVIV00D0000007UiN@1iNGT0NGUi0000000408b<S0030000002OWil0WinO00<0WinO
00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP060<K6aP030000003IfMT0fMWI00P0fMWI
00<000000>c/k03/k>`03P3/k>`00`000000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo0340oooo
0P00ool010000?l00?l0003o0000o`020?l00003003oo`3oool0oooo02X0oooo00<000000>c/k03/
k>`03P3/k>`00`000000fMWI0=WIf@070=WIf@0300000036a/H0a/K600D0a/K600<000000;>c/`2c
/k<00P2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool305=CD`050000
001VIVH0IVIV06IVIP0000000`1iNGT00`000000S8b<08b<S00208b<S0030000002OWil0WinO00<0
WinO00<000000;>c/`2c/k<0102c/k<00`000000a/K60<K6aP050<K6aP030000003IfMT0fMWI00P0
fMWI00<000000>c/k03/k>`03`3/k>`00`000000oooo0?ooo`0X0?ooo`030000o`3oool0oooo0340
oooo0`00ool00`00o`00003o0000o`02003o00030?l00000ool00?oo02`0oooo00<000000>c/k03/
k>`03@3/k>`00`000000fMWI0=WIf@080=WIf@0300000036a/H0a/K600D0a/K600@000000;>c/`2c
/k<0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0`1CDe<01@000000
IVIV06IVIP1VIVH0000000<0NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`0309nO
W`030000002c/k<0/k>c00@0/k>c00<000000<K6aP36a/H01@36a/H00`000000fMWI0=WIf@080=WI
f@030000003/k>`0k>c/00h0k>c/00<000000?ooo`3oool0:03oool00`000?l0oooo0?ooo`0b0?oo
o`800?oo00<0o`00003o00000?l00P000?l01000o`00o`000?l00000ool/0?ooo`030000003/k>`0
k>c/00h0k>c/00<000000=WIf@3IfMT01`3IfMT00`000000a/K60<K6aP050<K6aP040000002c/k<0
/k>c0;>c/`D0oooo0@0000010?ooo`005@3oool2000000<0oooo0`1CDe<01@000000IVIV06IVIP1V
IVH0000000<0NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`0309nOW`030000002c
/k<0/k>c00<0/k>c00<000000<K6aP36a/H01@36a/H00`000000fMWI0=WIf@090=WIf@030000003/
k>`0k>c/00d0k>c/00<000000?ooo`3oool0:03oool00`000?l0oooo0?ooo`0c0?ooo`800?oo00<0
o`00003o0000o`000P000?l01000o`00o`000?l00000ool]0?ooo`030000003/k>`0k>c/00d0k>c/
00<000000=WIf@3IfMT01`3IfMT00`000000a/K60<K6aP050<K6aP040000002c/k<0/k>c0;>c/`@0
oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`80De=C00D0000006IVIP1VIVH0
IVIV0000000407UiN@050000002<S8`0S8b<08b<S00000001@2OWil00`000000/k>c0;>c/`040;>c
/`0300000036a/H0a/K600D0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00>0>c/
k0030000003oool0oooo02L0oooo00<0003o0?ooo`3oool0=@3oool2003oo`040?l00000o`000?l0
003o0080003o00<00?oo0?ooo`3oool0;03oool00`000000k>c/0>c/k00>0>c/k0030000003IfMT0
fMWI00L0fMWI00<000000<K6aP36a/H01@36a/H00`000000/k>c0;>c/`050?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool205=CD`050000001VIVH0IVIV06IVIP0000000`1iNGT2
000000<0S8b<00<0000009nOW`2OWil00`2OWil00`000000/k>c0;>c/`040;>c/`0300000036a/H0
a/K600D0a/K600<000000=WIf@3IfMT01`3IfMT200000100k>c/00<000000?ooo`3oool09P3oool0
0`000?l0oooo0?ooo`0f0?ooo`800?oo1P3o00000`000?l0oooo0?ooo`0/0?ooo`030000003/k>`0
k>c/00h0k>c/00<000000=WIf@3IfMT01`3IfMT00`000000a/K60<K6aP050<K6aP030000002c/k<0
/k>c00D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`0305=CD`000000IVIV
0080IVIV00<0000007UiN@1iNGT00P1iNGT00`000000S8b<08b<S00208b<S0030000002OWil0WinO
00<0WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP050<K6aP030000003IfMT0fMWI
00P0fMWI00<000000>c/k03/k>`03P3/k>`00`000000oooo0?ooo`0V0?ooo`030000o`3oool0oooo
03P0oooo0`00ool20?l000800?oo00<0oooo0000o`3oool0;@3oool00`000000k>c/0>c/k00=0>c/
k0030000003IfMT0fMWI00L0fMWI00<000000<K6aP36a/H01P36a/H00`000000/k>c0?ooo`040?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`1CDe<0000006IVIP0206IVIP03
0000001iNGT0NGUi0080NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`0209nOW`03
0000002c/k<0/k>c00@0/k>c00<000000<K6aP36a/H01@36a/H00`000000fMWI0=WIf@080=WIf@03
0000003/k>`0k>c/00h0k>c/00<000000?ooo`3oool09@3oool00`000?l0oooo0?ooo`0k0?ooo`<0
0?oo103oool20000obd0oooo00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@070=WIf@03
00000036a/H0a/K600D0a/K600<000000;>c/`3oool0103oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo00<0De=C0000001VIVH00P1VIVH00`000000NGUi07UiN@0207UiN@030000
002<S8`0S8b<0080S8b<00<0000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`040;>c/`030000
0036a/H0a/K600D0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00>0>c/k0030000
003oool0oooo02@0oooo00<0003o0?ooo`3oool0A@3oool00`000?l0oooo0?ooo`0Z0?ooo`030000
003/k>`0k>c/00d0k>c/00<000000=WIf@3IfMT01`3IfMT00`000000a/K60<K6aP050<K6aP030000
002c/k<0oooo00@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`0305=CD`00
0000IVIV0080IVIV00D0000007UiN@1iNGT0NGUi0000000408b<S0030000002OWil0WinO0080WinO
00<000000;>c/`2c/k<0102c/k<00`000000a/K60<K6aP050<K6aP030000003IfMT0fMWI00P0fMWI
00<000000>c/k03/k>`03P3/k>`00`000000oooo0?ooo`0T0?ooo`030000o`3oool0oooo04L0oooo
00<0003o0?ooo`3oool0:@3oool00`000000k>c/0>c/k00>0>c/k0030000003IfMT0fMWI00L0fMWI
00<000000<K6aP36a/H01@36a/H00`000000oooo0?ooo`030?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool00`1CDe<0000006IVIP0206IVIP050000001iNGT0NGUi07UiN@000000
102<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0/k>c00@0/k>c00<000000<K6aP36a/H0
1@36a/H00`000000fMWI0=WIf@080=WIf@030000003/k>`0k>c/00h0k>c/00<000000?ooo`3oool0
8`3oool00`000?l0oooo0?ooo`190?ooo`030000o`3oool0oooo02T0oooo00<000000>c/k03/k>`0
3@3/k>`00`000000fMWI0=WIf@070=WIf@0300000036a/H0a/K600D0a/K600<000000?ooo`3oool0
0`3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00D0000006IVIP1VIVH0IVIV
0000000307UiN@030000002<S8`0S8b<0080S8b<00<0000009nOW`2OWil00`2OWil00`000000/k>c
0;>c/`040;>c/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/
0>c/k00>0>c/k0030000003oool0oooo02@0oooo00<0003o0?ooo`3oool0BP3oool20000obT0oooo
00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@070=WIf@0300000036a/H0a/K600D0a/K6
00<000000?ooo`3oool00`3oool100000040oooo000E0?ooo`8000000`3oool01@000000IVIV06IV
IP1VIVH0000000<0NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`0309nOW`030000
002c/k<0/k>c00<0/k>c00<000000<K6aP36a/H01@36a/H00`000000fMWI0=WIf@080=WIf@030000
003/k>`0k>c/00h0k>c/00<000000?ooo`3oool0703oool3003oo`@0oooo00<0003o0?ooo`3oool0
C@3oool00`000?l0oooo0?ooo`0W0?ooo`030000003/k>`0k>c/00d0k>c/00<000000=WIf@3IfMT0
1`3IfMT00`000000a/K60<K6aP050<K6aP040000003oool0oooo0?ooo`8000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool01@000000IVIV06IVIP1VIVH0000000<0NGUi00<0000008b<S02<
S8`00P2<S8`00`000000WinO09nOW`0309nOW`030000002c/k<0/k>c00<0/k>c00<000000<K6aP36
a/H01@36a/H00`000000fMWI0=WIf@080=WIf@030000003/k>`0k>c/00d0k>c/00<000000?ooo`3o
ool06`3oool3003oo`80o`000P00ool00`3oool0003o0?ooo`1@0?ooo`030000o`3oool0oooo02H0
oooo00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@070=WIf@0300000036a/H0a/K600D0
a/K600<000000?ooo`3oool00P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
0`1VIVH00`000000NGUi07UiN@0207UiN@050000002<S8`0S8b<08b<S00000001@2OWil00`000000
/k>c0;>c/`030;>c/`0300000036a/H0a/K600D0a/K600<000000=WIf@3IfMT0203IfMT00`000000
k>c/0>c/k00>0>c/k0030000003oool0oooo01X0oooo0P00ool60?l000030000o`3oool0oooo0540
oooo0P000?lW0?ooo`030000003/k>`0k>c/00`0k>c/00<000000=WIf@3IfMT0203IfMT00`000000
a/K60<K6aP040<K6aP030000003oool0oooo0080oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooo`<0IVIV00<0000007UiN@1iNGT00P1iNGT01@000000S8b<08b<S02<S8`0000000D0
WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP050<K6aP030000003IfMT0fMWI00P0
fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0K0?ooo`800?oo0P3o0003003o0003
0000o`00ool0oooo05@0oooo00<0003o0?ooo`3oool00`00oolQ0?ooo`030000003/k>`0k>c/00d0
k>c/00<000000=WIf@3IfMT01`3IfMT00`000000a/K60<K6aP040<K6aPD0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooo`<0IVIV00D0000007UiN@1iNGT0NGUi0000000408b<S003
0000002OWil0WinO0080WinO00<000000;>c/`2c/k<0102c/k<00`000000a/K60<K6aP040<K6aP03
0000003IfMT0fMWI00P0fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0K0?ooo`80
0?oo0P3o00001`00o`00003o003o00000?l00?l00?l00000ool0E@3oool00`000?l00?oo003oo`02
0?l000800?oo7`3oool00`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI00L0fMWI00<00000
0<K6aP36a/H01036a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool306IV
IP050000001iNGT0NGUi07UiN@000000102<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0
/k>c00@0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@080=WIf@030000003/k>`0
k>c/00d0k>c/00<000000?ooo`3oool06`3oool2003oo`80o`000`000?l2003o00030?l00000ool0
oooo05<0oooo0P00ool20000o`<00?l000<0o`00003oo`3oool07P3oool00`000000k>c/0>c/k00=
0>c/k0030000003IfMT0fMWI00L0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool306IVIP050000001iNGT0NGUi07UiN@000000102<S8`0
0`000000WinO09nOW`0209nOW`030000002c/k<0/k>c00<0/k>c00<000000<K6aP36a/H01@36a/H0
0`000000fMWI0=WIf@070=WIf@030000003/k>`0k>c/00h0k>c/00<000000?ooo`3oool06`3oool3
003oo`030?l00000o`00003o00<00?l00P00oomD0?ooo`800?oo00<0o`00003o00000?l00`00o`00
0`00ool0oooo0?ooo`0M0?ooo`030000003/k>`0k>c/00d0k>c/00<000000=WIf@3IfMT01`3IfMT0
0`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`80IVIV00D0000007UiN@1iNGT0NGUi0000000408b<S0030000002OWil0WinO0080WinO00<00000
0;>c/`2c/k<0102c/k<00`000000a/K60<K6aP050<K6aP030000003IfMT0fMWI00L0fMWI00<00000
0>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0M0?ooo`800?oo00<0o`000000o`00o`000P00o`00
0`3o00000?oo0?ooo`1C0?ooo`800?oo0P3o00000`00o`00003o0000o`02003o00030?l00000ool0
oooo01h0oooo00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@060=WIf@0300000036a/H0
a/K600<0a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0P1VIVH01@00
0000NGUi07UiN@1iNGT0000000@0S8b<00<0000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`04
0;>c/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00=
0>c/k0030000003oool0oooo01d0oooo0`00ool00`000?l0o`000?l00003003ooe@0oooo0P00ool2
0?l000<0003o0P00o`000`3o00000?oo0?ooo`0N0?ooo`030000003/k>`0k>c/00d0k>c/00<00000
0=WIf@3IfMT01P3IfMT00`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`005@3oool20000
00<0oooo0P1VIVH01@000000NGUi07UiN@1iNGT0000000<0S8b<00<0000009nOW`2OWil00`2OWil0
0`000000/k>c0;>c/`040;>c/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT0203IfMT0
0`000000k>c/0>c/k00=0>c/k0030000003oool0oooo01h0oooo00<00?oo0000o`00ool01000oomE
0?ooo`<00?oo0P3o000010000?l00?l00000o`3o0002003ooal0oooo00<000000>c/k03/k>`03@3/
k>`00`000000fMWI0=WIf@060=WIf@0300000036a/H0a/K600<0a/K6103oool200000040oooo000E
0?ooo`030000003oool0oooo0080oooo00<0IVIV0000001iNGT00P1iNGT00`000000S8b<08b<S002
08b<S0030000002OWil0WinO00<0WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP05
0<K6aP030000003IfMT0fMWI00L0fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0O
0?ooo`030000o`3oool00?oo00800?ooF03oool2003oo`@0o`0000<0003o0?l00000ool08@3oool0
0`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI00H0fMWI00<000000<K6aP36a/H00P36a/H5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`1VIVH0000007UiN@0207Ui
N@030000002<S8`0S8b<0080S8b<00<0000009nOW`2OWil00P2OWil2000000D0/k>c00<000000<K6
aP36a/H01@36a/H00`000000fMWI0=WIf@070=WIf@030000003/k>`0k>c/00d0k>c/00<000000?oo
o`3oool07P3oool00`000?l0oooo0?ooo`1K0?ooo`@00?oo0P3o00000`00ool0003o003oo`0Q0?oo
o`030000003/k>`0k>c/00d0k>c/00<000000=WIf@3IfMT01P3IfMT00`000000a/K60<K6aP020<K6
aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`0306IVIP000000NGUi0080
NGUi00D0000008b<S02<S8`0S8b<0000000509nOW`030000002c/k<0/k>c00<0/k>c00<000000<K6
aP36a/H01@36a/H00`000000fMWI0=WIf@070=WIf@030000003/k>`0k>c/00d0k>c/00<000000?oo
o`3oool07P3oool00`000?l0oooo0?ooo`1M0?ooo`H00?oo00<0003o0?ooo`3oool08@3oool00`00
0000k>c/0>c/k00<0>c/k0030000003IfMT0fMWI00H0fMWI00<000000<K6aP36a/H00P36a/H50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`1VIVH0000007UiN@0207UiN@05
0000002<S8`0S8b<08b<S00000001@2OWil00`000000/k>c0;>c/`030;>c/`0300000036a/H0a/K6
00D0a/K600<000000=WIf@3IfMT01`3IfMT00`000000k>c/0>c/k00=0>c/k0030000003oool0oooo
01h0oooo00<0003o0?ooo`3oool0G`3oool3003oo`80oooo00<0003o0?ooo`3oool08@3oool00`00
0000k>c/0>c/k00<0>c/k0030000003IfMT0fMWI00H0fMWI00@000000<K6aP36a/H0a/K61@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo00<0000007UiN@1iNGT00P1iNGT01@00
0000S8b<08b<S02<S8`0000000D0WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP04
0<K6aP030000003IfMT0fMWI00P0fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0N
0?ooo`030000o`3oool0oooo06D0oooo00<0003o0?ooo`3oool08@3oool00`000000k>c/0>c/k00<
0>c/k0030000003IfMT0fMWI00H0fMWI00@000000<K6aP36a/H0a/K61@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo00D0000007UiN@1iNGT0NGUi0000000408b<S0030000002O
Wil0WinO0080WinO00<000000;>c/`2c/k<0102c/k<00`000000a/K60<K6aP040<K6aP030000003I
fMT0fMWI00L0fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0M0?ooo`030000o`3o
ool0oooo06L0oooo00<0003o0?ooo`3oool0803oool00`000000k>c/0>c/k00<0>c/k0030000003I
fMT0fMWI00L0fMWI00<000000<K6aP36a/H01@3oool100000040oooo00020?ooo`800000103oool2
000000<0oooo100000040?ooo`030000003oool0oooo0080oooo101iNGT00`000000S8b<08b<S002
08b<S0030000002OWil0WinO0080WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP05
0<K6aP030000003IfMT0fMWI00L0fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0L
0?ooo`030000o`3oool0oooo06P0oooo00<0003o0?ooo`3oool08@3oool00`000000k>c/0>c/k00;
0>c/k0030000003IfMT0fMWI00L0fMWI00<000000<K6aP36a/H01@3oool100000040oooo00001@3o
ool000000?ooo`3oool0000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02
0?ooo`<0NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0
/k>c00@0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@070=WIf@030000003/k>`0
k>c/00d0k>c/00<000000?ooo`3oool0703oool00`000?l0oooo0?ooo`1Y0?ooo`030000o`3oool0
oooo0240oooo00<000000>c/k03/k>`02`3/k>`00`000000fMWI0=WIf@070=WIf@0300000036a/H0
a/K600D0oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003oool0
oooo00@0oooo0P0000030?ooo`<0NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`02
09nOW`030000002c/k<0/k>c00@0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@07
0=WIf@030000003/k>`0k>c/00d0k>c/00<000000?ooo`3oool0703oool00`000?l0oooo0?ooo`1Z
0?ooo`030000o`3oool0oooo0240oooo00<000000>c/k03/k>`02`3/k>`00`000000fMWI0=WIf@07
0=WIf@0300000036a/H0oooo00<0oooo0P0000010?ooo`0000D0oooo0000003oool0oooo0000000:
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool307UiN@030000002<S8`0
S8b<0080S8b<00<0000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`040;>c/`0300000036a/H0
a/K600@0a/K600<000000=WIf@3IfMT01`3IfMT00`000000k>c/0>c/k00=0>c/k0030000003oool0
oooo01/0oooo00<0003o0?ooo`3oool0J`3oool00`000?l0oooo0?ooo`0Q0?ooo`030000003/k>`0
k>c/00/0k>c/00<000000=WIf@3IfMT01`3IfMT00`000000a/K60?ooo`040?ooo`4000000@3oool0
00050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0080oooo0`1iNGT00`000000S8b<08b<S00208b<S0030000002OWil0WinO0080WinO00<0
00000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00L0fMWI00<0
00000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0K0?ooo`030000o`3oool0oooo06d0oooo00@0
003o003oo`00ool00?oo7`3oool00`000000k>c/0>c/k00<0>c/k0030000003IfMT0fMWI00L0fMWI
00<000000?ooo`3oool00`3oool100000040oooo00020?ooo`8000002P3oool2000000D0oooo00<0
00000?ooo`3oool00P3oool307UiN@050000002<S8`0S8b<08b<S00000001@2OWil00`000000/k>c
0;>c/`030;>c/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT01`3IfMT00`000000k>c/
0>c/k00=0>c/k0030000003oool0oooo01X0oooo00<0003o0?ooo`3oool0K@3oool00`00ool0003o
003oo`020?l000800?oo7P3oool00`000000k>c/0>c/k00;0>c/k0030000003IfMT0fMWI00L0fMWI
00<000000?ooo`3oool00`3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0P1i
NGT00`000000S8b<08b<S00208b<S0030000002OWil0WinO0080WinO00<000000;>c/`2c/k<00`2c
/k<00`000000a/K60<K6aP050<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`03@3/
k>`00`000000oooo0?ooo`0K0?ooo`030000o`3oool0oooo06`0oooo0P00ool00`3o0000003o0?l0
00030?l00003003oo`3oool0oooo01/0oooo00<000000>c/k03/k>`02`3/k>`00`000000fMWI0=WI
f@070=WIf@030000003oool0oooo00<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`80NGUi00<0000008b<S02<S8`00P2<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0
/k>c00<0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@070=WIf@030000003/k>`0
k>c/00d0k>c/00<000000?ooo`3oool06P3oool00`000?l0oooo0?ooo`1]0?ooo`800?oo00@0o`00
0000o`00o`000?l00P3o00000`00ool0oooo0?ooo`0L0?ooo`030000003/k>`0k>c/00/0k>c/00<0
00000=WIf@3IfMT01`3IfMT00`000000oooo0?ooo`020?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool207UiN@030000002<S8`0S8b<0080S8b<00<0000009nOW`2OWil00P2OWil0
0`000000/k>c0;>c/`030;>c/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT01`3IfMT0
0`000000k>c/0>c/k00=0>c/k0030000003oool0oooo01@0oooo0`00ool20?ooo`030000o`3oool0
oooo06d0oooo0P00ool0103o00000?l0003o00000?l2003o0080o`0000<00?oo0?ooo`3oool06`3o
ool00`000000k>c/0>c/k00;0>c/k0030000003IfMT0fMWI00L0fMWI00<000000?ooo`3oool00P3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<0NGUi0000002<S8`00`2<S8`0
0`000000WinO09nOW`0209nOW`030000002c/k<0/k>c00<0/k>c00<000000<K6aP36a/H01@36a/H0
0`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00d0k>c/00<000000?ooo`3oool04`3oool6
003oo`030000o`3oool0oooo06h0oooo0P00ool00`3o00000?l00000o`020000o`04003o003o0000
o`00003ooah0oooo00<000000>c/k03/k>`02`3/k>`00`000000fMWI0=WIf@060=WIf@030000003o
ool0oooo0080oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`0307UiN@000000
S8b<00<0S8b<00<0000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`030;>c/`0300000036a/H0
a/K600D0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/0>c/k00=0>c/k0030000003oool0
oooo0180oooo0`00ool20?l00004003oo`000?l00?oo003oofl0oooo0`00ool2003o0080003o00@0
0?l00?l00000ool00?oo7P3oool00`000000k>c/0>c/k00;0>c/k0030000003IfMT0fMWI00H0fMWI
00<000000?ooo`3oool00P3oool100000040oooo000E0?ooo`8000000`3oool00`1iNGT0000008b<
S00308b<S0030000002OWil0WinO0080WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6
aP050<K6aP030000003IfMT0fMWI00D0fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?oo
o`0C0?ooo`03003oo`3o0000o`0000<00?l000<0003o003oo`00ool0L03oool2003oo`040?l00000
o`000?l00000o`80o`0000<00?oo0?ooo`3oool07@3oool00`000000k>c/0>c/k00;0>c/k0030000
003IfMT0fMWI00H0fMWI103oool200000040oooo000E0?ooo`030000003oool0oooo0080oooo00<0
NGUi0000002<S8`00P2<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0/k>c00<0/k>c00<0
00000<K6aP36a/H01@36a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00d0k>c/00<0
00000?ooo`3oool04P3oool2003oo`030?l00000o`000?l00080003o00@00?l0003oo`00ool00?oo
K`3oool4003oo`80o`0000<0003o003oo`00ool0803oool00`000000k>c/0>c/k00;0>c/k0030000
003IfMT0fMWI00D0fMWI1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<0
NGUi0000002<S8`00P2<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0/k>c00<0/k>c00<0
00000<K6aP36a/H01@36a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00d0k>c/00<0
00000?ooo`3oool04P3oool01000ool0o`000?l00000o`030000o`04003o003o00000?oo003oog00
oooo1P00ool00`000?l0oooo0?ooo`0O0?ooo`030000003/k>`0k>c/00/0k>c/00<000000=WIf@3I
fMT01@3IfMT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool01@000000S8b<
08b<S02<S8`0000000D0WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP040<K6aP03
0000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0C0?ooo`03
003oo`3o0000o`0000800?l000@0003o003o0000o`00o`000P00oomb0?ooo`<00?oo00<0oooo0000
o`3oool0803oool00`000000k>c/0>c/k00<0>c/k0030000003IfMT0fMWI00@0fMWI1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo00D0000008b<S02<S8`0S8b<0000000509nO
W`030000002c/k<0/k>c00<0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@060=WI
f@030000003/k>`0k>c/00d0k>c/00<000000?ooo`3oool0503oool01000ool0o`000?l000000?l2
003o00030?l00000ool00?oo07P0oooo00<0003o0?ooo`3oool07`3oool00`000000k>c/0>c/k00;
0>c/k0030000003IfMT0fMWI00@0fMWI1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo102<S8`00`000000WinO09nOW`0309nOW`030000002c/k<0/k>c0080/k>c00<000000<K6
aP36a/H01@36a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00d0k>c/00<000000?oo
o`3oool0503oool01000ool0o`000?l000000?l30?l000800?ooN03oool00`000?l0oooo0?ooo`0O
0?ooo`030000003/k>`0k>c/00/0k>c/00<000000=WIf@3IfMT0103IfMT50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool408b<S0030000002OWil0WinO0080WinO00<000000;>c
/`2c/k<00`2c/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00L0fMWI00<000000>c/
k03/k>`0303/k>`00`000000oooo0?ooo`0F0?ooo`04003oo`000?l0o`000?l000<00?ooNP3oool0
0`000?l0oooo0?ooo`0O0?ooo`030000003/k>`0k>c/00/0k>c/00<000000=WIf@3IfMT00`3IfMT5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool408b<S0030000002OWil0WinO
0080WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI
00L0fMWI00<000000>c/k03/k>`02`3/k>`2000001T0oooo00@0003o003oo`00ool00?ooO@3oool0
0`000?l0oooo0?ooo`0N0?ooo`030000003/k>`0k>c/00/0k>c/00<000000=WIf@3IfMT00`3IfMT5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool308b<S0030000002OWil0WinO
0080WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI
00L0fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0G0?ooo`030000o`3oool0oooo
07l0oooo00<0003o0?ooo`3oool07P3oool00`000000k>c/0>c/k00;0>c/k0030000003IfMT0fMWI
00<0fMWI1@3oool100000040oooo000E0?ooo`8000000`3oool308b<S0030000002OWil0WinO0080
WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00L0
fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0G0?ooo`030000o`3oool0oooo0800
oooo00<0003o0?ooo`3oool07P3oool00`000000k>c/0>c/k00;0>c/k0030000003IfMT0fMWI0080
fMWI103oool200000040oooo000E0?ooo`030000003oool0oooo0080oooo0`2<S8`00`000000WinO
09nOW`0209nOW`030000002c/k<0/k>c00<0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI
0=WIf@070=WIf@030000003/k>`0k>c/00`0k>c/00<000000?ooo`3oool05P3oool00`000?l0oooo
0?ooo`220?ooo`030000o`3oool0oooo01d0oooo00<000000>c/k03/k>`02`3/k>`00`000000fMWI
0=WIf@020=WIf@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0S8b<00<0
000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`020;>c/`0300000036a/H0a/K600D0a/K600<0
00000=WIf@3IfMT01P3IfMT00`000000k>c/0>c/k00<0>c/k0030000003oool0oooo01L0oooo00<0
003o0?ooo`3oool0PP3oool00`000?l0oooo0?ooo`0N0?ooo`030000003/k>`0k>c/00X0k>c/00<0
00000=WIf@3IfMT00P3IfMT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool2
08b<S0030000002OWil0WinO0080WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP05
0<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0F
0?ooo`030000o`3oool0oooo08@0oooo00<0003o0?ooo`3oool07@3oool00`000000k>c/0>c/k00:
0>c/k0030000003IfMT0fMWI0080fMWI1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo0P2<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0/k>c00<0/k>c00<000000<K6
aP36a/H01@36a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00/0k>c/00<000000?oo
o`3oool05`3oool00`000?l0oooo0?ooo`250?ooo`030000o`3oool0oooo01`0oooo00<000000>c/
k03/k>`02P3/k>`00`000000fMWI0=WIf@020=WIf@D0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooo`80S8b<00<0000009nOW`2OWil00P2OWil00`000000/k>c0;>c/`030;>c/`03
00000036a/H0a/K600@0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/0>c/k00<0>c/k003
0000003oool0oooo01H0oooo00<0003o0?ooo`3oool0QP3oool00`000?l0oooo0?ooo`0L0?ooo`03
0000003/k>`0k>c/00/0k>c/00@000000=WIf@3IfMT0fMWI1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo0P2<S8`00`000000WinO09nOW`0209nOW`030000002c/k<0/k>c00<0
/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00`0
k>c/00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`270?ooo`030000o`3oool0oooo01`0
oooo00<000000>c/k03/k>`02P3/k>`010000000fMWI0=WIf@3IfMT50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool00`2<S8`0000009nOW`0309nOW`030000002c/k<0/k>c00<0
/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00`0
k>c/00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`290?ooo`030000o`3oool0oooo01/0
oooo00<000000>c/k03/k>`02P3/k>`010000000fMWI0=WIf@3IfMT50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool00`2<S8`0000009nOW`0309nOW`030000002c/k<0/k>c00<0
/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00`0
k>c/00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`290?ooo`030000o`3oool0oooo01`0
oooo00<000000>c/k03/k>`02P3/k>`00`000000fMWI0=WIf@050?ooo`4000000@3oool001D0oooo
0P0000030?ooo`0308b<S0000000WinO00<0WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K6
0<K6aP040<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo
0?ooo`0E0?ooo`030000o`3oool0oooo08/0oooo00<0003o0?ooo`3oool06`3oool00`000000k>c/
0>c/k00:0>c/k0030000003IfMT0fMWI00@0oooo0P0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`030000002OWil0WinO0080WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6
aP040<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?oo
o`0F0?ooo`030000o`3oool0oooo08/0oooo00<0003o0?ooo`3oool0703oool00`000000k>c/0>c/
k00:0>c/k0030000003IfMT0oooo00@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`030000002OWil0WinO0080WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP04
0<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0F
0?ooo`030000o`3oool0oooo08`0oooo00<0003o0?ooo`3oool06`3oool00`000000k>c/0>c/k00:
0>c/k0030000003IfMT0oooo00@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`030000002OWil0WinO0080WinO00<000000;>c/`2c/k<00P2c/k<00`000000a/K60<K6aP040<K6
aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0F0?oo
o`030000o`3oool0oooo08h0oooo00<0003o0?ooo`3oool06P3oool00`000000k>c/0>c/k00:0>c/
k0030000003IfMT0oooo00@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`D0
WinO00<000000;>c/`2c/k<00P2c/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00H0
fMWI00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0F0?ooo`030000o`3oool0oooo08h0
oooo00<0003o0?ooo`00ool00P00oolI0?ooo`030000003/k>`0k>c/00X0k>c/00<000000?ooo`3o
ool00`3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1@2OWil00`000000/k>c
0;>c/`020;>c/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/
0>c/k00<0>c/k0030000003oool0oooo01D0oooo00<0003o0?ooo`3oool0S`3oool00`00ool0003o
003oo`020?l000800?oo5`3oool00`000000k>c/0>c/k00:0>c/k0030000003oool0oooo00<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`@0WinO00<000000;>c/`2c/k<00`2c
/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`02`3/
k>`00`000000oooo0?ooo`0F0?ooo`030000o`3oool0oooo03l0oooo3`0000100?ooo`800?oo00<0
o`000000o`3o00000`3o00000`00ool0oooo0?ooo`0E0?ooo`030000003/k>`0k>c/00X0k>c/00<0
00000?ooo`3oool00P3oool100000040oooo00020?ooo`800000103oool2000000D0oooo0`000003
0?ooo`030000003oool0oooo0080oooo102OWil00`000000/k>c0;>c/`030;>c/`0300000036a/H0
a/K600@0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/0>c/k00;0>c/k0030000003oool0
oooo01D0oooo00<0003o0?ooo`3oool0>`3oool5000000l0k>c/1@00000k0?ooo`800?oo00@0o`00
0000o`00o`000?l00P3o00000`00ool0oooo0?ooo`0E0?ooo`030000003/k>`0k>c/00X0k>c/00<0
00000?ooo`3oool00P3oool100000040oooo00001@3oool000000?ooo`3oool0000000/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`<0WinO00<000000;>c/`2c/k<00`2c
/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`02`3/
k>`00`000000oooo0?ooo`0F0?ooo`030000o`3oool0oooo03P0oooo0`00000I0>c/k0<00000=`3o
ool2003oo`040?l00000o`000?l00000o`800?l00P3o00000`00ool0oooo0?ooo`0D0?ooo`030000
003/k>`0k>c/00X0k>c/00<000000?ooo`3oool00P3oool100000040oooo00001@3oool000000?oo
o`3oool0000000P0oooo1@0000030?ooo`8000000`3oool309nOW`030000002c/k<0/k>c00<0/k>c
00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00/0k>c/
00<000000?ooo`3oool05@3oool00`000?l0oooo0?ooo`0g0?ooo`8000007`3/k>`2000003D0oooo
0P00ool00`3o00000?l00000o`020000o`04003o003o0000o`00003ooaH0oooo0P00000;0>c/k004
0000003oool0oooo0?ooo`8000000@3oool000050?ooo`000000oooo0?ooo`000000203oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo0`2OWil00`000000/k>c0;>c/`03
0;>c/`0300000036a/H0a/K600<0a/K600<000000=WIf@3IfMT01`3IfMT00`000000k>c/0>c/k00;
0>c/k0030000003oool0oooo01D0oooo00<0003o0?ooo`3oool0=@3oool2000002<0k>c/00<00000
0?ooo`3oool0<P3oool3003oo`800?l00P000?l01000o`00o`00003oo`00oolG0?ooo`030000003/
k>`0k>c/00T0k>c/1@3oool100000040oooo00001@3oool000000?ooo`3oool0000000T0oooo00<0
00000?ooo`000000103oool00`000000oooo0?ooo`020?ooo`<0WinO00<000000;>c/`2c/k<00P2c
/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`02`3/
k>`00`000000oooo0?ooo`0E0?ooo`030000o`3oool0oooo03@0oooo0P00000V0>c/k0800000<`3o
ool2003oo`040?l00000o`000?l00000o`80o`0000<00?oo0?ooo`3oool05`3oool00`000000k>c/
0>c/k0080>c/k0D0oooo0@0000010?ooo`000P3oool2000000/0oooo0P0000040?ooo`030000003o
ool0oooo0080oooo0P2OWil2000000@0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WI
f@060=WIf@030000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool05@3oool00`000?l0oooo0?oo
o`0b0?ooo`800000:P3/k>`200000340oooo1000ool00`3o0000003o003oo`02003ooaT0oooo00<0
00000>c/k03/k>`0203/k>`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool2
09nOW`030000002c/k<0/k>c00<0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@06
0=WIf@030000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool0503oool00`000?l0oooo0?ooo`0a
0?ooo`800000;P3/k>`00`000000oooo0?ooo`0_0?ooo`D00?oo00<0003o003oo`3oool06@3oool0
0`000000k>c/0>c/k0080>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`80WinO00<000000;>c/`2c/k<00`2c/k<00`000000a/K60<K6aP030<K6aP030000003IfMT0fMWI
00H0fMWI00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0E0?ooo`030000o`3oool0oooo
0300oooo00<000000>c/k03/k>`0;`3/k>`00`000000oooo0?ooo`0`0?ooo`<00?oo00<0003o0?oo
o`3oool06@3oool00`000000k>c/0>c/k0080>c/k0D0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooo`80WinO00<000000;>c/`2c/k<00P2c/k<00`000000a/K60<K6aP040<K6aP03
0000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0D0?ooo`03
0000o`3oool0oooo0300oooo0P00000b0>c/k0<00000<`3oool00`000?l0oooo0?ooo`0H0?ooo`03
0000003/k>`0k>c/00P0k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
00<0WinO0000002c/k<0102c/k<00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00D0fMWI
00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0E0?ooo`030000o`3oool0oooo02h0oooo
0P00000g0>c/k0030000003oool0oooo0300oooo00<0003o0?ooo`3oool06@3oool00`000000k>c/
0>c/k0070>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`0309nOW`00
0000/k>c00@0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@050=WIf@030000003/
k>`0k>c/00/0k>c/00<000000?ooo`3oool0503oool00`000?l0oooo0?ooo`0^0?ooo`030000003/
k>`0k>c/03P0k>c/0P00000`0?ooo`030000o`3oool0oooo01T0oooo00<000000>c/k03/k>`01`3/
k>`50?ooo`4000000@3oool001D0oooo0P0000030?ooo`0309nOW`000000/k>c00@0/k>c00<00000
0<K6aP36a/H01036a/H00`000000fMWI0=WIf@050=WIf@030000003/k>`0k>c/00/0k>c/00<00000
0?ooo`3oool0503oool00`000?l0oooo0?ooo`0]0?ooo`030000003/k>`0k>c/03/0k>c/00<00000
0?ooo`3oool0;P3oool00`000?l0oooo0?ooo`0H0?ooo`030000003/k>`0k>c/00L0k>c/103oool2
00000040oooo000E0?ooo`030000003oool0oooo0080oooo00<000000;>c/`2c/k<00`2c/k<00`00
0000a/K60<K6aP040<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/k>`02P3/k>`00`00
0000oooo0?ooo`0E0?ooo`030000o`3oool0oooo02`0oooo00<000000>c/k03/k>`0?03/k>`00`00
0000oooo0?ooo`0^0?ooo`030000o`3oool0oooo01T0oooo00<000000>c/k03/k>`01P3/k>`50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`000000/k>c0;>c/`030;>c/`03
00000036a/H0a/K600@0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/0>c/k00:0>c/k003
0000003oool0oooo01@0oooo00<0003o0?ooo`3oool0;03oool00`000000k>c/0>c/k00n0>c/k003
0000003oool0oooo02d0oooo00<0003o0?ooo`3oool06@3oool00`000000k>c/0>c/k0060>c/k0D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000002c/k<0/k>c0080/k>c
00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00X0k>c/
00<000000?ooo`3oool05@3oool00`000?l0oooo0?ooo`0Z0?ooo`800000@P3/k>`2000002h0oooo
00<0003o0?ooo`3oool0603oool00`000000k>c/0>c/k0060>c/k0D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`030000002c/k<0/k>c0080/k>c00<000000<K6aP36a/H01036
a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00X0k>c/00<000000?ooo`3oool0503o
ool00`000?l0oooo0?ooo`0Z0?ooo`030000003/k>`0k>c/04@0k>c/00<000000?ooo`3oool0:`3o
ool010000?l00?oo003oo`00oolH0?ooo`030000003/k>`0k>c/00D0k>c/1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo1@2c/k<00`000000a/K60<K6aP040<K6aP030000003I
fMT0fMWI00H0fMWI00<000000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0D0?ooo`030000o`3o
ool0oooo02T0oooo00<000000>c/k03/k>`0AP3/k>`00`000000oooo0?ooo`0Y0?ooo`800?oo00<0
003o003oo`00ool00P00oolG0?ooo`030000003/k>`0k>c/00@0k>c/1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo1@2c/k<00`000000a/K60<K6aP030<K6aP030000003IfMT0
fMWI00H0fMWI00<000000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0D0?ooo`030000o`3oool0
oooo02X0oooo00<000000>c/k03/k>`0A`3/k>`00`000000oooo0?ooo`0W0?ooo`<00?oo00<0003o
0?l0003o00000`00oolF0?ooo`030000003/k>`0k>c/00@0k>c/1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo1@2c/k<00`000000a/K60<K6aP030<K6aP030000003IfMT0fMWI
00H0fMWI00<000000>c/k03/k>`02P3/k>`2000001D0oooo00<0003o0?ooo`3oool0:03oool20000
04/0k>c/00<000000?ooo`3oool09P3oool2003oo`040?l000000?l00?l0003o0080o`0000<00?oo
0?ooo`3oool0503oool00`000000k>c/0>c/k0040>c/k0D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`@0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@050=WI
f@030000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool04`3oool00`000?l0oooo0?ooo`0X0?oo
o`030000003/k>`0k>c/04`0k>c/00<000000?ooo`3oool0903oool3003oo`800?l000@0003o003o
0000o`00o`000P00oolE0?ooo`030000003/k>`0k>c/00@0k>c/1@3oool100000040oooo000E0?oo
o`8000000`3oool40;>c/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT01@3IfMT00`00
0000k>c/0>c/k00;0>c/k0030000003oool0oooo01<0oooo00<0003o0?ooo`3oool09`3oool00`00
0000k>c/0>c/k01>0>c/k0030000003oool0oooo02<0oooo0P00ool00`3o00000?l00000o`020000
o`04003o003o0000o`00003ooaH0oooo00<000000>c/k03/k>`00`3/k>`40?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool40;>c/`0300000036a/H0a/K600<0a/K600<000000=WI
f@3IfMT01P3IfMT00`000000k>c/0>c/k00;0>c/k0030000003oool0oooo0180oooo00<0003o0?oo
o`3oool09`3oool00`000000k>c/0>c/k01@0>c/k0030000003oool0oooo0280oooo0P00ool0103o
00000?l0003o00000?l2003o0080o`0000<00?oo0?ooo`3oool0503oool00`000000k>c/0>c/k003
0>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0/k>c00<000000<K6
aP36a/H01036a/H00`000000fMWI0=WIf@050=WIf@030000003/k>`0k>c/00/0k>c/00<000000?oo
o`3oool04`3oool00`000?l0oooo0?ooo`0V0?ooo`030000003/k>`0k>c/0540k>c/00<000000?oo
o`3oool08`3oool2003oo`040?l00000o`000?l00000o`80o`0000<00?oo0?ooo`3oool05P3oool0
0`000000k>c/0>c/k0020>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`<0/k>c00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@050=WIf@030000003/k>`0k>c/
00/0k>c/00<000000?ooo`3oool03`3oool3003oo`030000o`3oool0oooo02L0oooo00<000000>c/
k03/k>`0DP3/k>`2000002<0oooo0P00ool30?l000040000o`3o0000o`00003ooaP0oooo00<00000
0>c/k03/k>`00P3/k>`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool30;>c
/`0300000036a/H0a/K600@0a/K600<000000=WIf@3IfMT01@3IfMT00`000000k>c/0>c/k00;0>c/
k0030000003oool0oooo00d0oooo1@00ool00`000?l00?oo0?ooo`0V0?ooo`030000003/k>`0k>c/
05D0k>c/00<000000?ooo`3oool08@3oool3003oo`80o`0000<0003o003oo`3oool0603oool00`00
0000k>c/0>c/k0020>c/k0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0
/k>c00<000000<K6aP36a/H00`36a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00X0
k>c/00<000000?ooo`3oool03@3oool3003oo`80o`0000@0003o003oo`00ool00?oo9@3oool00`00
0000k>c/0>c/k01F0>c/k0030000003oool0oooo02<0oooo0`00ool00`000?l0oooo0?ooo`0H0?oo
o`030000003/k>`0k>c/0080k>c/1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo0`2c/k<00`000000a/K60<K6aP030<K6aP030000003IfMT0fMWI00H0fMWI00<000000>c/k03/
k>`02P3/k>`00`000000oooo0?ooo`0=0?ooo`03003oo`3o0000o`0000800?l000@0003o0?l00000
ool00?oo903oool00`000000k>c/0>c/k01H0>c/k0030000003oool0oooo02H0oooo00<0003o0?oo
o`3oool0603oool010000000k>c/0>c/k03/k>`50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool20;>c/`0300000036a/H0a/K600<0a/K600<000000=WIf@3IfMT01P3IfMT00`00
0000k>c/0>c/k00:0>c/k0030000003oool0oooo00d0oooo0P00ool0103o00000?l0003o00000?l2
003o00<00?oo8P3oool00`000000k>c/0>c/k01J0>c/k0030000003oool0oooo02D0oooo00<0003o
0?ooo`3oool0603oool010000000k>c/0>c/k03/k>`50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool20;>c/`0300000036a/H0a/K600<0a/K600<000000=WIf@3IfMT01P3IfMT0
0`000000k>c/0>c/k00:0>c/k0030000003oool0oooo00d0oooo00@00?oo0?l0003o00000?l00`00
0?l01000o`00o`00003oo`00oolQ0?ooo`030000003/k>`0k>c/05`0k>c/00<000000?ooo`3oool0
9@3oool00`000?l0oooo0?ooo`0H0?ooo`030000003/k>`0k>c/00D0oooo0@0000010?ooo`005@3o
ool2000000<0oooo0P2c/k<00`000000a/K60<K6aP030<K6aP030000003IfMT0fMWI00H0fMWI00<0
00000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0=0?ooo`03003oo`3o0000o`0000800?l000@0
003o003o0000o`00o`000P00oolP0?ooo`030000003/k>`0k>c/05h0k>c/00<000000?ooo`3oool0
903oool00`000?l0oooo0?ooo`0H0?ooo`030000003/k>`0k>c/00@0oooo0P0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`030;>c/`000000a/K600D0a/K600<000000=WIf@3IfMT01@3I
fMT00`000000k>c/0>c/k00:0>c/k0030000003oool0oooo00l0oooo00@00?oo0?l0003o0000003o
0P00o`000`3o00000?oo003oo`0Q0?ooo`030000003/k>`0k>c/05h0k>c/00<000000?ooo`3oool0
9@3oool00`000?l0oooo0?ooo`0G0?ooo`030000003/k>`0k>c/00D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`030;>c/`000000a/K600D0a/K600<000000=WIf@3IfMT01@3I
fMT00`000000k>c/0>c/k00:0>c/k0030000003oool0oooo00l0oooo00@00?oo0?l0003o0000003o
0`3o0002003oob00oooo00<000000>c/k03/k>`0H03/k>`00`000000oooo0?ooo`0T0?ooo`030000
o`3oool0oooo01L0oooo00<000000>c/k03/k>`01@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo00<000000<K6aP36a/H01036a/H00`000000fMWI0=WIf@050=WIf@030000003/
k>`0k>c/00X0k>c/00<000000?ooo`3oool04@3oool01000ool0003o0?l0003o0003003oob40oooo
00<000000>c/k03/k>`0H03/k>`00`000000oooo0?ooo`0T0?ooo`030000o`3oool0oooo01P0oooo
00<000000>c/k03oool0103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<0
00000<K6aP36a/H01036a/H00`000000fMWI0=WIf@050=WIf@030000003/k>`0k>c/00X0k>c/00<0
00000?ooo`3oool04P3oool010000?l00?oo003oo`00oolQ0?ooo`800000I03/k>`2000002D0oooo
00<0003o0?ooo`3oool05`3oool00`000000k>c/0?ooo`040?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool00`000000a/K60<K6aP040<K6aP030000003IfMT0fMWI00D0fMWI00<0
00000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0B0?ooo`030000o`3oool0oooo0240oooo00<0
00000>c/k03/k>`0IP3/k>`00`000000oooo0?ooo`0R0?ooo`030000o`3oool0oooo01L0oooo00<0
00000>c/k03oool0103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<00000
0<K6aP36a/H00`36a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00T0k>c/00<00000
0?ooo`3oool04P3oool00`000?l0oooo0?ooo`0R0?ooo`030000003/k>`0k>c/06H0k>c/00<00000
0?ooo`3oool08`3oool00`000?l0oooo0?ooo`0G0?ooo`030000003oool0oooo00<0oooo0@000001
0?ooo`000P3oool2000000@0oooo0P0000030?ooo`<000001@3oool00`000000oooo0?ooo`020?oo
o`H0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/0>c/k0090>c/k0030000003oool0oooo
0180oooo00<0003o0?ooo`3oool08P3oool00`000000k>c/0>c/k01W0>c/k0030000003oool0oooo
0280oooo00<0003o0?ooo`3oool05`3oool00`000000oooo0?ooo`030?ooo`4000000@3oool00005
0?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0080oooo1P36a/H00`000000fMWI0=WIf@060=WIf@030000003/k>`0k>c/00T0k>c/00<00000
0?ooo`3oool04P3oool00`000?l0oooo0?ooo`0Q0?ooo`030000003/k>`0k>c/06P0k>c/00<00000
0?ooo`3oool08`3oool00`000?l0oooo0?ooo`0F0?ooo`030000003oool0oooo00<0oooo0@000001
0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000@0oooo0P00
00030?ooo`H0a/K600<000000=WIf@3IfMT01@3IfMT00`000000k>c/0>c/k00:0>c/k0030000003o
ool0oooo0140oooo00<0003o0?ooo`3oool08P3oool00`000000k>c/0>c/k00/0>c/k0l00000;P3/
k>`00`000000oooo0?ooo`0R0?ooo`030000o`3oool0oooo01L0oooo00@000000?ooo`3oool0oooo
0P0000010?ooo`0000D0oooo0000003oool0oooo000000080?ooo`<000001@3oool00`000000oooo
0?ooo`020?ooo`H0a/K600<000000=WIf@3IfMT01@3IfMT00`000000k>c/0>c/k00:0>c/k0030000
003oool0oooo0140oooo00<0003o0?ooo`3oool0803oool2000002X0k>c/1@00000?0=WIf@D00000
:@3/k>`00`000000oooo0?ooo`0S0?ooo`030000o`3oool0oooo01H0oooo00<000000?ooo`3oool0
0P3oool100000040oooo00001@3oool000000?ooo`3oool0000000T0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`D0a/K600<000000=WIf@3IfMT01@3IfMT00`000000k>c/
0>c/k00:0>c/k0030000003oool0oooo0140oooo00<0003o0?ooo`3oool0803oool00`000000k>c/
0>c/k00X0>c/k08000006@3IfMT3000002L0k>c/00<000000?ooo`3oool08P3oool00`000?l0oooo
0?ooo`0F0?ooo`030000003oool0oooo0080oooo0@0000010?ooo`000P3oool2000000X0oooo0`00
00040?ooo`030000003oool0oooo0080oooo1@36a/H00`000000fMWI0=WIf@050=WIf@030000003/
k>`0k>c/00X0k>c/00<000000?ooo`3oool04@3oool00`000?l0oooo0?ooo`0P0?ooo`030000003/
k>`0k>c/02D0k>c/0`00000N0=WIf@8000009P3/k>`00`000000oooo0?ooo`0R0?ooo`030000o`3o
ool0oooo01X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`D0a/K600<00000
0=WIf@3IfMT01@3IfMT00`000000k>c/0>c/k00:0>c/k0030000003oool0oooo0140oooo00<0003o
0?ooo`3oool07`3oool00`000000k>c/0>c/k00U0>c/k0030000003IfMT0fMWI0240fMWI0P00000U
0>c/k0030000003oool0oooo0240oooo00<0003o0?ooo`3oool06P3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo1036a/H00`000000fMWI0=WIf@050=WIf@030000003/k>`0k>c/
00X0k>c/00<000000?ooo`3oool04@3oool00`000?l0oooo0?ooo`0P0?ooo`030000003/k>`0k>c/
02@0k>c/00<000000=WIf@3IfMT0903IfMT2000002<0k>c/00<000000?ooo`3oool08@3oool00`00
0?l0oooo0?ooo`0J0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool40<K6aP03
0000003IfMT0fMWI00D0fMWI00<000000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0A0?ooo`03
0000o`3oool0oooo01l0oooo00<000000>c/k03/k>`08P3/k>`3000002T0fMWI00<000000>c/k03/
k>`08@3/k>`00`000000oooo0?ooo`0Q0?ooo`030000o`3oool0oooo01T0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooo`<0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/
0>c/k0090>c/k0030000003oool0oooo0180oooo00<0003o0?ooo`3oool07P3oool00`000000k>c/
0>c/k00Q0>c/k0800000;@3IfMT200000280k>c/00<000000?ooo`3oool0803oool00`000?l0oooo
0?ooo`0I0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool30<K6aP030000003I
fMT0fMWI00H0fMWI00<000000>c/k03/k>`02@3/k>`00`000000oooo0?ooo`0A0?ooo`030000o`3o
ool0oooo01l0oooo00<000000>c/k03/k>`0803/k>`00`000000fMWI0=WIf@0_0=WIf@8000008@3/
k>`00`000000oooo0?ooo`0P0?ooo`030000o`3oool0oooo01P0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`<0a/K600<000000=WIf@3IfMT01P3IfMT00`000000k>c/0>c/k009
0>c/k0030000003oool0oooo0140oooo00<0003o0?ooo`3oool07P3oool00`000000k>c/0>c/k00P
0>c/k0030000003IfMT0fMWI0380fMWI00<000000>c/k03/k>`07P3/k>`00`000000oooo0?ooo`0P
0?ooo`030000o`3oool0oooo01P0oooo0@0000010?ooo`005@3oool2000000<0oooo0`36a/H00`00
0000fMWI0=WIf@050=WIf@030000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool04@3oool00`00
0?l0oooo0?ooo`0N0?ooo`030000003/k>`0k>c/0200k>c/00<000000=WIf@3IfMT0=03IfMT00`00
0000k>c/0>c/k00N0>c/k0030000003oool0oooo0200oooo00<0003o003oo`00ool05P3oool20000
0040oooo000E0?ooo`030000003oool0oooo0080oooo0`36a/H00`000000fMWI0=WIf@050=WIf@03
0000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool04@3oool00`000?l0oooo0?ooo`0N0?ooo`03
0000003/k>`0k>c/01h0k>c/0P00000h0=WIf@8000007P3/k>`00`000000oooo0?ooo`0N0?ooo`80
0?oo00<0003o003oo`00ool00P00oolE0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3oool30<K6aP030000003IfMT0fMWI00@0fMWI00<000000>c/k03/k>`02P3/k>`00`000000oooo
0?ooo`0A0?ooo`030000o`3oool0oooo01d0oooo00<000000>c/k03/k>`07P3/k>`00`000000fMWI
0=WIf@0j0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?ooo`3oool0703oool4003oo`030000
o`3o00000?oo00800?oo503oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0P36
a/H00`000000fMWI0=WIf@050=WIf@030000003/k>`0k>c/00X0k>c/00<000000?ooo`3oool0403o
ool00`000?l0oooo0?ooo`0N0?ooo`030000003/k>`0k>c/01`0k>c/0P00000n0=WIf@030000003/
k>`0k>c/01`0k>c/00<000000?ooo`3oool06`3oool2003oo`80o`0000D0003o003o0000o`00o`00
003oo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool20<K6aP030000003I
fMT0fMWI00D0fMWI00<000000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0@0?ooo`030000o`3o
ool0oooo01d0oooo00<000000>c/k03/k>`07@3/k>`00`000000fMWI0=WIf@0n0=WIf@800000703/
k>`00`000000oooo0?ooo`0J0?ooo`<00?oo00@0o`00003o00000?l0003o0P00o`02003ooa<0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030<K6aP000000fMWI00H0fMWI00<0
00000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0A0?ooo`030000o`3oool0oooo01d0oooo00<0
00000>c/k03/k>`06`3/k>`2000004<0fMWI00<000000>c/k03/k>`06@3/k>`00`000000oooo0?oo
o`0J0?ooo`800?oo0P3o00030000o`800?l000<0o`00003oo`3oool04P3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo00<0a/K60000003IfMT01P3IfMT00`000000k>c/0>c/k00:
0>c/k0030000003oool0oooo0100oooo00<0003o0?ooo`3oool07@3oool00`000000k>c/0>c/k00K
0>c/k0030000003IfMT0fMWI04<0fMWI00<000000>c/k03/k>`06P3/k>`00`000000oooo0?ooo`0I
0?ooo`800?oo0P3o00000`00o`00003o0000o`02003o00030?l00000ool0oooo0180oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030<K6aP000000fMWI00H0fMWI00<000000>c/
k03/k>`02P3/k>`00`000000oooo0?ooo`0@0?ooo`030000o`3oool0oooo01`0oooo00<000000>c/
k03/k>`06`3/k>`00`000000fMWI0=WIf@150=WIf@030000003/k>`0k>c/01X0k>c/00<000000?oo
o`3oool06@3oool2003oo`80o`000P00o`000`000?l0o`00003oo`0D0?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool00`36a/H000000=WIf@060=WIf@030000003/k>`0k>c/00T0
k>c/00<000000?ooo`3oool0403oool00`000?l0oooo0?ooo`0M0?ooo`030000003/k>`0k>c/01/0
k>c/00<000000=WIf@3IfMT0AP3IfMT00`000000k>c/0>c/k00I0>c/k0030000003oool0oooo01T0
oooo0P00ool40?l000030000o`3o00000?oo01@0oooo0@0000010?ooo`005@3oool2000000<0oooo
00<0a/K60000003IfMT01P3IfMT00`000000k>c/0>c/k0090>c/k0030000003oool0oooo0100oooo
00<0003o0?ooo`3oool07@3oool00`000000k>c/0>c/k00I0>c/k0800000BP3IfMT00`000000k>c/
0>c/k00I0>c/k0030000003oool0oooo01T0oooo0`00ool20?l000030000o`00ool0oooo01<0oooo
0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000003IfMT0fMWI00D0fMWI00<0
00000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`0@0?ooo`030000o`3oool0oooo01`0oooo00<0
00000>c/k03/k>`06@3/k>`00`000000fMWI0=WIf@1;0=WIf@030000003/k>`0k>c/01P0k>c/00<0
00000?ooo`3oool06`3oool3003oo`030?ooo`000?l0oooo01@0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`030000003IfMT0fMWI00D0fMWI00<000000>c/k03/k>`02@3/k>`0
0`000000oooo0?ooo`0@0?ooo`030000o`3oool0oooo01`0oooo00<000000>c/k03/k>`06@3/k>`0
0`000000fMWI0=WIf@1=0=WIf@030000003/k>`0k>c/01P0k>c/00<000000?ooo`3oool07P3oool0
0`000?l0oooo0?ooo`0C0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`00
0000fMWI0=WIf@050=WIf@030000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool0403oool00`00
0?l0oooo0?ooo`0L0?ooo`030000003/k>`0k>c/01P0k>c/00<000000=WIf@3IfMT0C`3IfMT00`00
0000k>c/0>c/k00G0>c/k0030000003oool0oooo01h0oooo00<0003o0?ooo`3oool04`3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo1`3IfMT00`000000k>c/0>c/k0090>c/k003
0000003oool0oooo0100oooo00<0003o0?ooo`3oool0703oool00`000000k>c/0>c/k00I0>c/k003
0000003IfMT0fMWI0500fMWI00<000000>c/k03/k>`05`3/k>`00`000000oooo0?ooo`0N0?ooo`03
0000o`3oool0oooo0180oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`L0fMWI
00<000000>c/k03/k>`02@3/k>`00`000000oooo0?ooo`0@0?ooo`030000o`3oool0oooo01`0oooo
00<000000>c/k03/k>`05`3/k>`2000005@0fMWI00<000000>c/k03/k>`05`3/k>`00`000000oooo
0?ooo`0M0?ooo`030000o`3oool0oooo0180oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`L0fMWI00<000000>c/k03/k>`02@3/k>`00`000000oooo0?ooo`0@0?ooo`030000o`3o
ool0oooo01/0oooo00<000000>c/k03/k>`05`3/k>`00`000000fMWI0=WIf@1E0=WIf@030000003/
k>`0k>c/01H0k>c/00<000000?ooo`3oool07@3oool00`000?l00?oo003oo`0B0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool70=WIf@030000003/k>`0k>c/00T0k>c/00<00000
0?ooo`3oool03`3oool00`000?l0oooo0?ooo`0K0?ooo`030000003/k>`0k>c/01L0k>c/00<00000
0=WIf@3IfMT0E`3IfMT00`000000k>c/0>c/k00F0>c/k0030000003oool0oooo01X0oooo0`00ool0
10000?l00?oo003oo`00ool@0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool7
0=WIf@030000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`0K
0?ooo`030000003/k>`0k>c/01L0k>c/00<000000=WIf@3IfMT0F03IfMT00`000000k>c/0>c/k00E
0>c/k0030000003oool0oooo01T0oooo1000ool00`000?l0o`00003oo`02003oo`l0oooo0@000001
0?ooo`005@3oool2000000<0oooo1P3IfMT00`000000k>c/0>c/k0090>c/k0030000003oool0oooo
0100oooo00<0003o0?ooo`3oool06P3oool00`000000k>c/0>c/k00G0>c/k0030000003IfMT0fMWI
02@0fMWI3`00000V0=WIf@030000003/k>`0k>c/01H0k>c/00<000000?ooo`3oool0603oool2003o
o`040?l00000o`00003o003o0080o`0000<00?oo0?ooo`3oool0303oool200000040oooo000E0?oo
o`030000003oool0oooo0080oooo1P3IfMT00`000000k>c/0>c/k0090>c/k0030000003oool0oooo
00l0oooo00<0003o0?ooo`3oool06`3oool00`000000k>c/0>c/k00F0>c/k0030000003IfMT0fMWI
0280fMWI0`00000?0<K6aPD000008P3IfMT00`000000k>c/0>c/k00E0>c/k0030000003oool0oooo
01L0oooo0`00ool2003o0080003o00@00?l00?l00000ool00?oo3P3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo1@3IfMT00`000000k>c/0>c/k0090>c/k0030000003oool0oooo
0100oooo00<0003o0?ooo`3oool06P3oool00`000000k>c/0>c/k00F0>c/k0030000003IfMT0fMWI
0240fMWI0P00000G0<K6aP<00000803IfMT00`000000k>c/0>c/k00E0>c/k0030000003oool0oooo
01H0oooo0P00ool00`3o00000?l00000o`020000o`04003o003o0000o`00003oo`h0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`D0fMWI00<000000>c/k03/k>`02@3/k>`00`00
0000oooo0?ooo`0?0?ooo`030000o`3oool0oooo01/0oooo00<000000>c/k03/k>`05@3/k>`00`00
0000fMWI0=WIf@0N0=WIf@@000007036a/H2000001l0fMWI00<000000>c/k03/k>`05@3/k>`00`00
0000oooo0?ooo`0E0?ooo`800?oo00<0o`00003o0000o`000P000?l01000o`00o`000?l00000ool>
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool50=WIf@030000003/k>`0k>c/
00T0k>c/00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`0J0?ooo`030000003/k>`0k>c/
01H0k>c/00<000000=WIf@3IfMT07@3IfMT00`000000a/K60<K6aP0P0<K6aP030000003IfMT0fMWI
01`0fMWI00<000000>c/k03/k>`05@3/k>`00`000000oooo0?ooo`0F0?ooo`800?oo00L0o`00003o
0000o`000?l00000o`3o00000?oo00l0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`@0fMWI00<000000>c/k03/k>`02@3/k>`00`000000oooo0?ooo`0@0?ooo`030000o`3oool0
oooo01T0oooo00<000000>c/k03/k>`05P3/k>`00`000000fMWI0=WIf@0L0=WIf@8000009036a/H2
000001d0fMWI00<000000>c/k03/k>`0503/k>`00`000000oooo0?ooo`0F0?ooo`800?oo103o0000
0`000?l0o`00003oo`0?0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool40=WI
f@030000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`0J0?oo
o`030000003/k>`0k>c/01D0k>c/0P00000L0=WIf@800000:036a/H2000001`0fMWI00<000000>c/
k03/k>`0503/k>`00`000000oooo0?ooo`0F0?ooo`<00?oo0P3o00000`000?l00?oo0?ooo`0?0?oo
o`4000000@3oool00080oooo0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3o
ool00P3oool40=WIf@030000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool03`3oool00`000?l0
oooo0?ooo`0J0?ooo`030000003/k>`0k>c/01D0k>c/00<000000=WIf@3IfMT06@3IfMT2000002`0
a/K600<000000=WIf@3IfMT06P3IfMT00`000000k>c/0>c/k00C0>c/k0030000003oool0oooo01P0
oooo0`00ool00`3oool0003o0?ooo`0?0?ooo`4000000@3oool000050?ooo`000000oooo0?ooo`00
0000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo103IfMT00`00
0000k>c/0>c/k0090>c/k0030000003oool0oooo00l0oooo00<0003o0?ooo`3oool06@3oool00`00
0000k>c/0>c/k00E0>c/k0030000003IfMT0fMWI01P0fMWI0P00000_0<K6aP030000003IfMT0fMWI
01T0fMWI00<000000>c/k03/k>`0503/k>`00`000000oooo0?ooo`0K0?ooo`030000o`3oool0oooo
00h0oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo
000000@0oooo0P0000030?ooo`@0fMWI00<000000>c/k03/k>`0203/k>`200000100oooo00<0003o
0?ooo`3oool06P3oool00`000000k>c/0>c/k00D0>c/k08000006P3IfMT00`000000a/K60<K6aP0_
0<K6aP<000006@3IfMT00`000000k>c/0>c/k00C0>c/k0030000003oool0oooo01/0oooo00<0003o
0?ooo`3oool03@3oool200000040oooo00001@3oool000000?ooo`3oool0000000T0oooo0P000005
0?ooo`030000003oool0oooo0080oooo0`3IfMT00`000000k>c/0>c/k0090>c/k0030000003oool0
oooo00l0oooo00<0003o0?ooo`3oool06@3oool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0
fMWI01P0fMWI0P00000e0<K6aP800000603IfMT00`000000k>c/0>c/k00C0>c/k0030000003oool0
oooo01/0oooo00<0003o0?ooo`3oool03@3oool100000040oooo00001@3oool000000?ooo`3oool0
000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`<0fMWI00<0
00000>c/k03/k>`02@3/k>`00`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo01X0oooo00<0
00000>c/k03/k>`0503/k>`00`000000fMWI0=WIf@0F0=WIf@800000>@36a/H00`000000fMWI0=WI
f@0F0=WIf@030000003/k>`0k>c/01<0k>c/00<000000?ooo`3oool06P3oool00`000?l0oooo0?oo
o`0=0?ooo`4000000@3oool00080oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`02
0?ooo`<0fMWI00<000000>c/k03/k>`02@3/k>`00`000000oooo0?ooo`0>0?ooo`030000o`3oool0
oooo01T0oooo00<000000>c/k03/k>`0503/k>`00`000000fMWI0=WIf@0F0=WIf@0300000036a/H0
a/K603X0a/K600<000000=WIf@3IfMT05@3IfMT00`000000k>c/0>c/k00C0>c/k0030000003oool0
oooo01X0oooo00<0003o0?ooo`3oool03@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo0`3IfMT00`000000k>c/0>c/k0080>c/k0030000003oool0oooo00l0oooo00<0003o0?oo
o`3oool06@3oool00`000000k>c/0>c/k00C0>c/k0030000003IfMT0fMWI01H0fMWI00<000000<K6
aP36a/H0?036a/H00`000000fMWI0=WIf@0D0=WIf@030000003/k>`0k>c/01@0k>c/00<000000?oo
o`3oool06P3oool00`000?l0oooo0?ooo`0<0?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool20=WIf@030000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool03P3oool00`000?l0
oooo0?ooo`0I0?ooo`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT05@3IfMT00`000000
a/K60<K6aP0n0<K6aP030000003IfMT0fMWI01@0fMWI00<000000>c/k03/k>`04`3/k>`00`000000
oooo0?ooo`0J0?ooo`030000o`3oool0oooo00`0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooo`80fMWI00<000000>c/k03/k>`0203/k>`00`000000oooo0?ooo`0?0?ooo`030000
o`3oool0oooo01P0oooo00<000000>c/k03/k>`0503/k>`00`000000fMWI0=WIf@0D0=WIf@800000
@P36a/H00`000000fMWI0=WIf@0D0=WIf@030000003/k>`0k>c/01<0k>c/00<000000?ooo`3oool0
6@3oool00`000?l0oooo0?ooo`0<0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool20=WIf@030000003/k>`0k>c/00P0k>c/00<000000?ooo`3oool02`3oool3003oo`030?ooo`00
0?l0oooo01T0oooo00<000000>c/k03/k>`04`3/k>`00`000000fMWI0=WIf@0D0=WIf@0300000036
a/H0a/K604<0a/K60P00000E0=WIf@030000003/k>`0k>c/0180k>c/00<000000?ooo`3oool06P3o
ool00`000?l0oooo0?ooo`0;0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool2
0=WIf@030000003/k>`0k>c/00P0k>c/00<000000?ooo`3oool02@3oool3003oo`80o`0000<0003o
003oo`3oool06@3oool00`000000k>c/0>c/k00C0>c/k0030000003IfMT0fMWI01@0fMWI00<00000
0<K6aP36a/H0A036a/H00`000000fMWI0=WIf@0D0=WIf@030000003/k>`0k>c/0140k>c/00<00000
0?ooo`3oool06P3oool00`000?l0oooo0?ooo`0;0?ooo`4000000@3oool001D0oooo0P0000030?oo
o`030=WIf@000000k>c/00X0k>c/00<000000?ooo`3oool0203oool2003oo`070?l00000o`000?l0
003o00000?l0o`00003oo`0H0?ooo`030000003/k>`0k>c/01<0k>c/00<000000=WIf@3IfMT0503I
fMT00`000000a/K60<K6aP160<K6aP030000003IfMT0fMWI01<0fMWI00<000000>c/k03/k>`04P3/
k>`00`000000oooo0?ooo`0I0?ooo`030000o`3oool0oooo00X0oooo0P0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`030=WIf@000000k>c/00X0k>c/00<000000?ooo`3oool0203oool2
003oo`<00?l000@0003o003o003o00000?oo603oool00`000000k>c/0>c/k00C0>c/k0030000003I
fMT0fMWI01<0fMWI00<000000<K6aP36a/H0B036a/H00`000000fMWI0=WIf@0C0=WIf@030000003/
k>`0k>c/0140k>c/00<000000?ooo`3oool06P3oool00`000?l0oooo0?ooo`0:0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool00`3IfMT000000>c/k00:0>c/k0030000003oool0
oooo00L0oooo0P00ool00`3o00000?l0003o00020000o`04003o003o0000o`00003ooaL0oooo00<0
00000>c/k03/k>`04P3/k>`00`000000fMWI0=WIf@0C0=WIf@0300000036a/H0a/K604X0a/K600<0
00000=WIf@3IfMT04`3IfMT00`000000k>c/0>c/k00@0>c/k0030000003oool0oooo01X0oooo00<0
003o0?ooo`3oool02P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<00000
0>c/k03/k>`02@3/k>`00`000000oooo0?ooo`080?ooo`800?oo00<0o`00003o00000?l00P000?l0
1000o`00o`000?l00000oolF0?ooo`030000003/k>`0k>c/0180k>c/00<000000=WIf@3IfMT04`3I
fMT00`000000a/K60<K6aP1<0<K6aP030000003IfMT0fMWI0180fMWI00<000000>c/k03/k>`04@3/
k>`00`000000oooo0?ooo`0I0?ooo`030000o`3oool0oooo00X0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`030000003/k>`0k>c/00T0k>c/00<000000?ooo`3oool0203oool3
003oo`040?l00000o`00003o003o0080o`000P00oolF0?ooo`030000003/k>`0k>c/0180k>c/00<0
00000=WIf@3IfMT04P3IfMT00`000000a/K60<K6aP1>0<K6aP030000003IfMT0fMWI0140fMWI00<0
00000>c/k03/k>`04@3/k>`00`000000oooo0?ooo`0J0?ooo`030000o`3oool0oooo00T0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000003/k>`0k>c/00P0k>c/00<00000
0?ooo`3oool02P3oool2003oo`80o`0000D0003o0?l0003o0000o`00003oo`0F0?ooo`030000003/
k>`0k>c/0180k>c/00<000000=WIf@3IfMT04P3IfMT00`000000a/K60<K6aP0Q0<K6aPX000009036
a/H00`000000fMWI0=WIf@0B0=WIf@030000003/k>`0k>c/0140k>c/00<000000?ooo`3oool06@3o
ool00`000?l0oooo0?ooo`090?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool;
0>c/k0030000003oool0oooo00X0oooo1000ool00`000?l0o`00003oo`02003ooaH0oooo00<00000
0>c/k03/k>`04P3/k>`00`000000fMWI0=WIf@0A0=WIf@0300000036a/H0a/K601d0a/K61@00000:
0;>c/`H000007`36a/H2000001<0fMWI00<000000>c/k03/k>`04@3/k>`00`000000oooo0?ooo`0H
0?ooo`040000o`00ool00?oo003oo`P0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`/0k>c/00<000000?ooo`3oool02`3oool3003oo`040000o`00ool00?oo003ooaH0oooo00<0
00000>c/k03/k>`04P3/k>`00`000000fMWI0=WIf@0A0=WIf@0300000036a/H0a/K601`0a/K60P00
000E0;>c/`8000007`36a/H00`000000fMWI0=WIf@0@0=WIf@030000003/k>`0k>c/0140k>c/00<0
00000?ooo`3oool05`3oool2003oo`030000o`00ool00?oo00800?oo1P3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo2P3/k>`00`000000oooo0?ooo`0>0?ooo`030000o`00ool0
0?oo01L0oooo00<000000>c/k03/k>`04P3/k>`00`000000fMWI0=WIf@0A0=WIf@0300000036a/H0
a/K601/0a/K60P00000I0;>c/`<000007036a/H00`000000fMWI0=WIf@0A0=WIf@030000003/k>`0
k>c/0140k>c/00<000000?ooo`3oool05@3oool3003oo`030000o`3o0000o`0000<00?oo1@3oool1
00000040oooo000E0?ooo`8000000`3oool:0>c/k0030000003oool0oooo00h0oooo00<0003o0?oo
o`3oool05`3oool00`000000k>c/0>c/k00B0>c/k0030000003IfMT0fMWI0140fMWI00<000000<K6
aP36a/H06036a/H3000001h0/k>c0P00000K0<K6aP030000003IfMT0fMWI0100fMWI00<000000>c/
k03/k>`04@3/k>`00`000000oooo0?ooo`0E0?ooo`800?oo00@0o`000000o`00o`000?l00P3o0000
0`00ool0oooo0?ooo`020?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3oool:0>c/
k0030000003oool0oooo00h0oooo00<0003o0?ooo`3oool05P3oool00`000000k>c/0>c/k00B0>c/
k0030000003IfMT0fMWI0140fMWI00<000000<K6aP36a/H06036a/H00`000000/k>c0;>c/`0Q0;>c
/`<000006@36a/H00`000000fMWI0=WIf@0@0=WIf@030000003/k>`0k>c/0100k>c/00<000000?oo
o`3oool0503oool3003oo`800?l000@0003o003o0000o`00o`000P00ool40?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool:0>c/k0030000003oool0oooo00h0oooo00<0003o0?oo
o`3oool05P3oool00`000000k>c/0>c/k00B0>c/k0030000003IfMT0fMWI0100fMWI00<000000<K6
aP36a/H05P36a/H3000002L0/k>c0P00000H0<K6aP030000003IfMT0fMWI0100fMWI00<000000>c/
k03/k>`0403/k>`00`000000oooo0?ooo`0C0?ooo`800?oo00<0o`00003o00000?l00P000?l01000
o`00o`000?l00000ool40?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool:0>c/
k0030000003oool0oooo00d0oooo00<0003o0?ooo`3oool05`3oool00`000000k>c/0>c/k00A0>c/
k0030000003IfMT0fMWI0100fMWI00<000000<K6aP36a/H05P36a/H00`000000/k>c0;>c/`0Z0;>c
/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT03`3IfMT00`000000k>c/0>c/k00@0>c/
k0030000003oool0oooo01<0oooo0P00ool0103o00000?l0003o00000?l2003o0080o`0000<00?oo
0?ooo`3oool00P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2@3/k>`00`00
0000oooo0?ooo`0>0?ooo`030000o`3oool0oooo01L0oooo00<000000>c/k03/k>`0403/k>`00`00
0000fMWI0=WIf@0@0=WIf@0300000036a/H0a/K601D0a/K60P00000^0;>c/`0300000036a/H0a/K6
01D0a/K600<000000=WIf@3IfMT0403IfMT00`000000k>c/0>c/k00@0>c/k0030000003oool0oooo
01<0oooo0P00ool0103o00000?l0003o00000?l20?l00003003oo`3oool0oooo00<0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0k>c/00<000000?ooo`3oool03P3oool00`00
0?l0oooo0?ooo`0F0?ooo`030000003/k>`0k>c/0140k>c/00<000000=WIf@3IfMT0403IfMT00`00
0000a/K60<K6aP0D0<K6aP030000002c/k<0/k>c02l0/k>c0P00000F0<K6aP030000003IfMT0fMWI
00l0fMWI00<000000>c/k03/k>`0403/k>`00`000000oooo0?ooo`0C0?ooo`800?oo0`3o00001000
0?l0o`000?l00000ool50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool80>c/
k0030000003oool0oooo00h0oooo00<0003o0?ooo`3oool05P3oool00`000000k>c/0>c/k00A0>c/
k0030000003IfMT0fMWI0100fMWI00<000000<K6aP36a/H04`36a/H2000003@0/k>c0P00000E0<K6
aP030000003IfMT0fMWI00l0fMWI00<000000>c/k03/k>`03`3/k>`00`000000oooo0?ooo`0D0?oo
o`<00?oo00@0o`000000o`3o0000o`000P00ool40?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool80>c/k0030000003oool0oooo00h0oooo00<0003o0?ooo`3oool05P3oool00`00
0000k>c/0>c/k00A0>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H04`36a/H00`00
0000/k>c0;>c/`0f0;>c/`8000005036a/H00`000000fMWI0=WIf@0?0=WIf@030000003/k>`0k>c/
00l0k>c/00<000000?ooo`3oool0503oool2003oo`040?l000000?l00?l0003o0080o`0000D00?oo
0?ooo`3oool0oooo000000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P0k>c/00<00000
0?ooo`3oool03P3oool00`000?l0oooo0?ooo`0F0?ooo`030000003/k>`0k>c/0140k>c/00<00000
0=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP0B0<K6aP800000>`2c/k<00`000000a/K60<K6aP0B
0<K6aP030000003IfMT0fMWI00h0fMWI00<000000>c/k03/k>`03`3/k>`00`000000oooo0?ooo`0D
0?ooo`800?oo0P00o`001@000?l00?l0003o003o00000?oo00<0oooo0@0000010?ooo`005@3oool2
000000<0oooo203/k>`00`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo01D0oooo00<00000
0>c/k03/k>`04@3/k>`00`000000fMWI0=WIf@0?0=WIf@0300000036a/H0a/K60140a/K600<00000
0;>c/`2c/k<0>`2c/k<00`000000a/K60<K6aP0B0<K6aP030000003IfMT0fMWI00l0fMWI00<00000
0>c/k03/k>`03`3/k>`00`000000oooo0?ooo`0B0?ooo`800?oo00@0o`00003o0000o`00003o0P00
o`020?l00004003oo`3oool0000000000040oooo000E0?ooo`030000003oool0oooo0080oooo203/
k>`00`000000oooo0?ooo`0=0?ooo`030000o`3oool0oooo01H0oooo00<000000>c/k03/k>`0403/
k>`00`000000fMWI0=WIf@0?0=WIf@0300000036a/H0a/K60140a/K600<000000;>c/`2c/k<0?@2c
/k<2000001<0a/K600<000000=WIf@3IfMT03P3IfMT00`000000k>c/0>c/k00?0>c/k0030000003o
ool0oooo0180oooo0P00ool00`3o00000?l00000o`020000o`04003o003o0000o`00003oo`80oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P0k>c/00<000000?ooo`3oool03@3o
ool00`000?l0oooo0?ooo`0F0?ooo`030000003/k>`0k>c/00l0k>c/00<000000=WIf@3IfMT03`3I
fMT00`000000a/K60<K6aP0B0<K6aP030000002c/k<0/k>c03l0/k>c00<000000<K6aP36a/H04@36
a/H00`000000fMWI0=WIf@0>0=WIf@030000003/k>`0k>c/00l0k>c/00<000000?ooo`3oool04@3o
ool3003oo`040?l00000o`00003o0000o`80o`000P00ool20?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool70>c/k0030000003oool0oooo00h0oooo00<0003o0?ooo`3oool05@3o
ool00`000000k>c/0>c/k00@0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H04P36
a/H00`000000/k>c0;>c/`110;>c/`0300000036a/H0a/K60100a/K600<000000=WIf@3IfMT03P3I
fMT00`000000k>c/0>c/k00?0>c/k0030000003oool0oooo0180oooo0P00ool30?l000040000o`3o
0000o`00003oo`8000000@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1`3/
k>`00`000000oooo0?ooo`0=0?ooo`030000o`3oool0oooo01H0oooo00<000000>c/k03/k>`0403/
k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K60100a/K60P0000150;>c/`0300000036
a/H0a/K60100a/K600<000000=WIf@3IfMT03P3IfMT00`000000k>c/0>c/k00>0>c/k0030000003o
ool0oooo0180oooo1000ool00`3o0000003o003oo`02003oo`@000000@3oool001D0oooo00<00000
0?ooo`3oool00`00ool50>c/k0030000003oool0oooo00h0oooo00<0003o0?ooo`3oool05@3oool0
0`000000k>c/0>c/k00@0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H04036a/H0
0`000000/k>c0;>c/`160;>c/`0300000036a/H0a/K60100a/K600<000000=WIf@3IfMT03@3IfMT0
0`000000k>c/0>c/k00>0>c/k0030000003oool0oooo01<0oooo1@00ool00`000?l0o`00003oo`02
003oo`8000000@3oool001D0oooo00@00000003oo`00ool00?oo0P3o0002003oo`<0k>c/00<00000
0?ooo`3oool03P3oool00`000?l0oooo0?ooo`0E0?ooo`030000003/k>`0k>c/0100k>c/00<00000
0=WIf@3IfMT03@3IfMT00`000000a/K60<K6aP0@0<K6aP030000002c/k<0/k>c04P0/k>c00<00000
0<K6aP36a/H04036a/H00`000000fMWI0=WIf@0=0=WIf@030000003/k>`0k>c/00h0k>c/00<00000
0?ooo`3oool04`3oool01@0000000?oo0?l0003o0000003o00<0o`000P00ool100000040oooo000=
0?ooo`D000000`3oool2003oo`80o`000`00o`001@3o00000?oo0>c/k03/k>`000000100oooo00<0
003o0?ooo`3oool0503oool00`000000k>c/0>c/k00@0>c/k0030000003IfMT0fMWI00h0fMWI00<0
00000<K6aP36a/H04036a/H00`000000/k>c0;>c/`190;>c/`0300000036a/H0a/K600l0a/K600<0
00000=WIf@3IfMT03@3IfMT00`000000k>c/0>c/k00>0>c/k0030000003oool0oooo0180oooo0P00
00001000ool0o`000?l000000?l2003o00040?l00000ool00?oo00000040oooo000?0?ooo`030000
003oool0oooo00<0oooo0P00ool00`3o00000?l0003o0003003o0004003oo`3/k>`0k>c/000000l0
oooo00<0003o0?ooo`3oool05@3oool00`000000k>c/0>c/k00?0>c/k0030000003IfMT0fMWI00h0
fMWI00<000000<K6aP36a/H03`36a/H2000001h0/k>c4@00000N0;>c/`0300000036a/H0a/K600l0
a/K600<000000=WIf@3IfMT0303IfMT00`000000k>c/0>c/k00?0>c/k08000004P3oool010000000
0?oo0?l0003o0002003o00040000o`00o`000?l00?l000800?oo0@3oool000l0oooo00<000000?oo
o`3oool00`3oool01000ool0o`000?l00000o`020000o`800?l000@0o`00003oo`3/k>`000003`3o
ool00`000?l0oooo0?ooo`0E0?ooo`030000003/k>`0k>c/00l0k>c/00<000000=WIf@3IfMT03P3I
fMT00`000000a/K60<K6aP0>0<K6aP030000002c/k<0/k>c01/0/k>c0`00000A09nOW`<00000702c
/k<00`000000a/K60<K6aP0>0<K6aP030000003IfMT0fMWI00d0fMWI00<000000>c/k03/k>`03P3/
k>`00`000000oooo0?ooo`0A0?ooo`0500000000ool0o`000?l00000o`000`000?l01000o`00o`00
003oo`00ool10?ooo`003`3oool00`000000oooo0?ooo`030?ooo`03003oo`3o0000o`0000<0003o
0P00o`000`3o00000?oo0000000@0?ooo`030000o`3oool0oooo01@0oooo00<000000>c/k03/k>`0
3`3/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600h0a/K600<000000;>c/`2c/k<0
602c/k<4000001L0WinO0`00000I0;>c/`0300000036a/H0a/K600l0a/K600<000000=WIf@3IfMT0
303IfMT00`000000k>c/0>c/k00?0>c/k0030000003oool0oooo0100oooo00D00000003oo`3o0000
o`00003o00030000o`04003o003o00000?oo003oo`40oooo000?0?ooo`030000003oool0oooo00<0
oooo0P00ool20?l00080003o00D00?l00?l00000ool00?oo0000000@0?ooo`030000o`3oool0oooo
01@0oooo00<000000>c/k03/k>`03`3/k>`00`000000fMWI0=WIf@0=0=WIf@0300000036a/H0a/K6
00h0a/K600<000000;>c/`2c/k<05`2c/k<2000001h0WinO0P00000H0;>c/`8000004036a/H00`00
0000fMWI0=WIf@0<0=WIf@030000003/k>`0k>c/00l0k>c/00<000000?ooo`3oool03`3oool00`00
00000?oo003oo`020?l00004003o00000?l00?l00?l000<00?oo0@3oool000h0oooo0P0000050?oo
o`800?oo0`3o00001P000?l0o`000?l00000ool0k>c/000000l0oooo00<0003o0?ooo`3oool05@3o
ool00`000000k>c/0>c/k00?0>c/k0030000003IfMT0fMWI00`0fMWI00<000000<K6aP36a/H03P36
a/H00`000000/k>c0;>c/`0G0;>c/`030000002OWil0WinO0200WinO0P00000H0;>c/`0300000036
a/H0a/K600h0a/K600<000000=WIf@3IfMT0303IfMT00`000000k>c/0>c/k00>0>c/k0030000003o
ool0oooo00l0oooo0P0000000`00ool0o`000?l000040?l000800?oo0@0000010?ooo`005@3oool4
003oo`030?l000000?l00?oo00800?oo00<000000?ooo`3oool03P3oool00`000?l0oooo0?ooo`0D
0?ooo`030000003/k>`0k>c/00l0k>c/00<000000=WIf@3IfMT03@3IfMT00`000000a/K60<K6aP0=
0<K6aP030000002c/k<0/k>c01H0/k>c0P00000U09nOW`8000005P2c/k<00`000000a/K60<K6aP0>
0<K6aP030000003IfMT0fMWI00`0fMWI00<000000>c/k03/k>`03`3/k>`00`000000oooo0?ooo`0?
0?ooo`0400000000ool00?oo003oo`80o`001000ool100000040oooo000E0?ooo`0300000000ool0
0?oo00800?oo00D0003o003oo`00ool0k>c/0000000@0?ooo`030000o`3oool0oooo01@0oooo00<0
00000>c/k03/k>`03`3/k>`00`000000fMWI0=WIf@0<0=WIf@0300000036a/H0a/K600h0a/K600<0
00000;>c/`2c/k<04`2c/k<3000002T0WinO00<000000;>c/`2c/k<0502c/k<00`000000a/K60<K6
aP0>0<K6aP030000003IfMT0fMWI00`0fMWI00<000000>c/k03/k>`03P3/k>`00`000000oooo0?oo
o`0@0?ooo`0300000000ool00?oo00D00?oo0P0000010?ooo`005@3oool00`000000oooo0?ooo`02
003oo`040000o`3/k>`0k>c/00000100oooo00<0003o0?ooo`3oool0503oool00`000000k>c/0>c/
k00?0>c/k0030000003IfMT0fMWI00`0fMWI00<000000<K6aP36a/H03P36a/H00`000000/k>c0;>c
/`0B0;>c/`800000;@2OWil2000001D0/k>c00<000000<K6aP36a/H03@36a/H00`000000fMWI0=WI
f@0<0=WIf@030000003/k>`0k>c/00h0k>c/00<000000?ooo`3oool04@3oool2000000<00?oo1000
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`040000o`3/k>`0k>c/00000100oooo00<0
003o0?ooo`3oool0503oool00`000000k>c/0>c/k00>0>c/k0030000003IfMT0fMWI00d0fMWI00<0
00000<K6aP36a/H03@36a/H00`000000/k>c0;>c/`0B0;>c/`030000002OWil0WinO02l0WinO0P00
000D0;>c/`0300000036a/H0a/K600d0a/K600<000000=WIf@3IfMT0303IfMT00`000000k>c/0>c/
k00>0>c/k0030000003oool0oooo0140oooo1P0000010?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool010000?l0k>c/0>c/k000000@0?ooo`030000o`3oool0oooo01@0oooo00<0
00000>c/k03/k>`03P3/k>`00`000000fMWI0=WIf@0<0=WIf@0300000036a/H0a/K600d0a/K600<0
00000;>c/`2c/k<04P2c/k<00`000000WinO09nOW`0b09nOW`030000002c/k<0/k>c0180/k>c00<0
00000<K6aP36a/H03@36a/H00`000000fMWI0=WIf@0;0=WIf@030000003/k>`0k>c/00h0k>c/00<0
00000?ooo`3oool0603oool100000040oooo000E0?ooo`8000000`3oool010000?l0k>c/0>c/k000
000@0?ooo`030000o`3oool0oooo01<0oooo00<000000>c/k03/k>`03P3/k>`00`000000fMWI0=WI
f@0=0=WIf@0300000036a/H0a/K600d0a/K600<000000;>c/`2c/k<04@2c/k<00`000000WinO09nO
W`0d09nOW`8000004P2c/k<00`000000a/K60<K6aP0=0<K6aP030000003IfMT0fMWI00`0fMWI00<0
00000>c/k03/k>`03P3/k>`00`000000oooo0?ooo`0F0?ooo`8000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool010000?l0k>c/0>c/k000000?0?ooo`030000o`3oool0oooo01@0oooo00<0
00000>c/k03/k>`03P3/k>`00`000000fMWI0=WIf@0<0=WIf@0300000036a/H0a/K600d0a/K600<0
00000;>c/`2c/k<0402c/k<2000003T0WinO00<000000;>c/`2c/k<0402c/k<00`000000a/K60<K6
aP0=0<K6aP030000003IfMT0fMWI00/0fMWI00<000000>c/k03/k>`03P3/k>`00`000000oooo0?oo
o`0G0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool010000?l0k>c/0>c/k000
000?0?ooo`030000o`3oool0oooo01<0oooo00<000000>c/k03/k>`03`3/k>`00`000000fMWI0=WI
f@0<0=WIf@0300000036a/H0a/K600`0a/K600<000000;>c/`2c/k<0402c/k<00`000000WinO09nO
W`0j09nOW`030000002c/k<0/k>c0100/k>c00<000000<K6aP36a/H03036a/H00`000000fMWI0=WI
f@0;0=WIf@030000003/k>`0k>c/00h0k>c/00<000000?ooo`3oool05`3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo00<0k>c/0000o`000000403oool00`000?l0oooo0?ooo`0C
0?ooo`030000003/k>`0k>c/00h0k>c/00<000000=WIf@3IfMT0303IfMT00`000000a/K60<K6aP0=
0<K6aP030000002c/k<0/k>c00l0/k>c00<0000009nOW`2OWil0?02OWil00`000000/k>c0;>c/`0?
0;>c/`0300000036a/H0a/K600d0a/K600<000000=WIf@3IfMT02`3IfMT00`000000k>c/0>c/k00>
0>c/k0030000003oool0oooo01H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`030>c/k0000?l0000000l0oooo00<0003o0?ooo`3oool0503oool00`000000k>c/0>c/k00>0>c/
k0030000003IfMT0fMWI00`0fMWI00<000000<K6aP36a/H03036a/H00`000000/k>c0;>c/`0?0;>c
/`030000002OWil0WinO03h0WinO00<000000;>c/`2c/k<03`2c/k<00`000000a/K60<K6aP0<0<K6
aP030000003IfMT0fMWI00/0fMWI00<000000>c/k03/k>`03P3/k>`00`000000oooo0?ooo`0F0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`3/k>`0003o0?ooo`0?0?ooo`03
0000o`3oool0oooo01<0oooo00<000000>c/k03/k>`03P3/k>`00`000000fMWI0=WIf@0<0=WIf@03
00000036a/H0a/K600`0a/K600<000000;>c/`2c/k<03P2c/k<200000480WinO0P00000@0;>c/`03
00000036a/H0a/K600`0a/K600<000000=WIf@3IfMT02`3IfMT00`000000k>c/0>c/k00=0>c/k003
0000003oool0oooo01H0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030>c/
k0000?l0oooo00l0oooo00<0003o0?ooo`3oool04`3oool00`000000k>c/0>c/k00>0>c/k0030000
003IfMT0fMWI00/0fMWI00<000000<K6aP36a/H03036a/H00`000000/k>c0;>c/`0>0;>c/`030000
002OWil0WinO04@0WinO00<000000;>c/`2c/k<03P2c/k<00`000000a/K60<K6aP0<0<K6aP030000
003IfMT0fMWI00/0fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0E0?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool00`3/k>`0003o0?ooo`0?0?ooo`030000o`3o
ool0oooo01<0oooo00<000000>c/k03/k>`03P3/k>`00`000000fMWI0=WIf@0;0=WIf@0300000036
a/H0a/K600/0a/K600<000000;>c/`2c/k<03P2c/k<00`000000WinO09nOW`1509nOW`030000002c
/k<0/k>c00l0/k>c00<000000<K6aP36a/H02`36a/H00`000000fMWI0=WIf@0;0=WIf@030000003/
k>`0k>c/00d0k>c/00<000000?ooo`3oool05@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo00<0k>c/0000o`3oool03P3oool00`000?l0oooo0?ooo`0C0?ooo`030000003/k>`0
k>c/00h0k>c/00<000000=WIf@3IfMT02`3IfMT00`000000a/K60<K6aP0<0<K6aP030000002c/k<0
/k>c00h0/k>c00<0000009nOW`2OWil06P2OWil?000001d0WinO00<000000;>c/`2c/k<03P2c/k<0
0`000000a/K60<K6aP0;0<K6aP030000003IfMT0fMWI00`0fMWI00<000000>c/k03/k>`03@3/k>`0
0`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo0P0000030?ooo`030>c/k0000?l0oooo
00h0oooo00<0003o0?ooo`3oool04`3oool00`000000k>c/0>c/k00>0>c/k0030000003IfMT0fMWI
00/0fMWI00<000000<K6aP36a/H02`36a/H00`000000/k>c0;>c/`0>0;>c/`030000002OWil0WinO
01P0WinO0`00000?08b<S0D000006@2OWil2000000l0/k>c00<000000<K6aP36a/H02`36a/H00`00
0000fMWI0=WIf@0;0=WIf@030000003/k>`0k>c/00d0k>c/00<000000?ooo`3oool04`3oool20000
0040oooo000E0?ooo`030000003oool0oooo0080oooo00<000000000o`3oool03P3oool00`000?l0
oooo0?ooo`0B0?ooo`030000003/k>`0k>c/00h0k>c/00<000000=WIf@3IfMT02`3IfMT00`000000
a/K60<K6aP0;0<K6aP030000002c/k<0/k>c00d0/k>c0P00000I09nOW`8000005`2<S8`3000001P0
WinO00<000000;>c/`2c/k<03@2c/k<00`000000a/K60<K6aP0:0<K6aP030000003IfMT0fMWI00/0
fMWI00<000000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool00`000000003o0?ooo`0>0?ooo`030000o`3oool0oooo0180oooo
00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@0;0=WIf@0300000036a/H0a/K600/0a/K6
0P00000>0;>c/`030000002OWil0WinO01D0WinO1000000L08b<S08000005`2OWil00`000000/k>c
0;>c/`0=0;>c/`0300000036a/H0a/K600X0a/K600<000000=WIf@3IfMT02`3IfMT00`000000k>c/
0>c/k00=0>c/k0030000003oool0oooo01<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`03000000000?l0oooo00d0oooo00<0003o0?ooo`3oool04`3oool00`000000k>c/0>c/
k00=0>c/k0030000003IfMT0fMWI00/0fMWI00<000000<K6aP36a/H02`36a/H00`000000/k>c0;>c
/`0=0;>c/`030000002OWil0WinO01@0WinO00<0000008b<S02<S8`0802<S8`2000001D0WinO00<0
00000;>c/`2c/k<03@2c/k<00`000000a/K60<K6aP0;0<K6aP030000003IfMT0fMWI00X0fMWI00<0
00000>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0C0?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`0<0?ooo`030000o`3oool0oooo0180oooo00<00000
0>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@0;0=WIf@0300000036a/H0a/K600/0a/K600<00000
0;>c/`2c/k<03@2c/k<00`000000WinO09nOW`0C09nOW`8000009@2<S8`2000001@0WinO00<00000
0;>c/`2c/k<03@2c/k<00`000000a/K60<K6aP0:0<K6aP030000003IfMT0fMWI00/0fMWI00<00000
0>c/k03/k>`03@3/k>`00`000000oooo0?ooo`0B0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00`3oool00`000?l0oooo0?ooo`0<0?ooo`030000o`3oool0oooo0180oooo00<000000>c/
k03/k>`03@3/k>`00`000000fMWI0=WIf@0;0=WIf@0300000036a/H0a/K600/0a/K600<000000;>c
/`2c/k<0302c/k<00`000000WinO09nOW`0B09nOW`800000:@2<S8`00`000000WinO09nOW`0B09nO
W`030000002c/k<0/k>c00`0/k>c00<000000<K6aP36a/H02`36a/H00`000000fMWI0=WIf@0:0=WI
f@030000003/k>`0k>c/00d0k>c/00<000000?ooo`3oool04P3oool100000040oooo000E0?ooo`03
0000003oool0oooo00<0oooo00<0003o0?ooo`3oool02`3oool00`000?l0oooo0?ooo`0B0?ooo`03
0000003/k>`0k>c/00h0k>c/00<000000=WIf@3IfMT02`3IfMT00`000000a/K60<K6aP0:0<K6aP03
0000002c/k<0/k>c00`0/k>c00<0000009nOW`2OWil04@2OWil2000002`0S8b<0P00000C09nOW`03
0000002c/k<0/k>c00`0/k>c00<000000<K6aP36a/H02P36a/H00`000000fMWI0=WIf@0:0=WIf@03
0000003/k>`0k>c/00d0k>c/00<000000?ooo`3oool04P3oool100000040oooo000E0?ooo`030000
003oool0oooo00<0oooo00<0003o0?ooo`3oool02`3oool00`000?l0oooo0?ooo`0B0?ooo`030000
003/k>`0k>c/00d0k>c/00<000000=WIf@3IfMT02`3IfMT00`000000a/K60<K6aP0:0<K6aP030000
002c/k<0/k>c00`0/k>c00<0000009nOW`2OWil0402OWil200000300S8b<00<0000009nOW`2OWil0
4@2OWil00`000000/k>c0;>c/`0;0;>c/`0300000036a/H0a/K600/0a/K600<000000=WIf@3IfMT0
2P3IfMT00`000000k>c/0>c/k00<0>c/k0030000003oool0oooo0180oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`030?ooo`030000o`3oool0oooo00/0oooo00<0003o0?ooo`3oool04P3o
ool00`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI00/0fMWI00<000000<K6aP36a/H02P36
a/H00`000000/k>c0;>c/`0<0;>c/`030000002OWil0WinO0100WinO00<0000008b<S02<S8`0<02<
S8`200000140WinO00<000000;>c/`2c/k<0302c/k<2000000/0a/K600<000000=WIf@3IfMT02P3I
fMT00`000000k>c/0>c/k00<0>c/k08000004`3oool100000040oooo000E0?ooo`800000103oool0
0`000?l0oooo0?ooo`0;0?ooo`030000o`3oool0oooo0140oooo00<000000>c/k03/k>`03P3/k>`0
0`000000fMWI0=WIf@0:0=WIf@0300000036a/H0a/K600X0a/K600<000000;>c/`2c/k<0302c/k<0
0`000000WinO09nOW`0?09nOW`800000=@2<S8`200000100WinO0P00000=0;>c/`0300000036a/H0
a/K600T0a/K600<000000=WIf@3IfMT02P3IfMT00`000000k>c/0>c/k00=0>c/k0030000003oool0
oooo0100oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000o`3oool0oooo
00X0oooo00<0003o0?ooo`3oool04P3oool00`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI
00X0fMWI00<000000<K6aP36a/H02P36a/H2000000d0/k>c00<0000009nOW`2OWil03`2OWil00`00
0000S8b<08b<S00g08b<S0030000002OWil0WinO00l0WinO00<000000;>c/`2c/k<02`2c/k<00`00
0000a/K60<K6aP090<K6aP030000003IfMT0fMWI00X0fMWI00<000000>c/k03/k>`0303/k>`00`00
0000oooo0?ooo`0A0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00`3oool00`000?l0
oooo0?ooo`0:0?ooo`030000o`3oool0oooo0180oooo00<000000>c/k03/k>`03@3/k>`00`000000
fMWI0=WIf@0:0=WIf@0300000036a/H0a/K600X0a/K600<000000;>c/`2c/k<02`2c/k<00`000000
WinO09nOW`0>09nOW`800000>`2<S8`00`000000WinO09nOW`0?09nOW`030000002c/k<0/k>c00X0
/k>c00<000000<K6aP36a/H02P36a/H00`000000fMWI0=WIf@090=WIf@030000003/k>`0k>c/00`0
k>c/00<000000?ooo`3oool04@3oool100000040oooo000E0?ooo`030000003oool0oooo00<0oooo
00<0003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`0A0?ooo`030000003/k>`0k>c/00d0k>c/
00<000000=WIf@3IfMT02P3IfMT00`000000a/K60<K6aP0:0<K6aP030000002c/k<0/k>c00/0/k>c
00<0000009nOW`2OWil03P2OWil00`000000S8b<08b<S00l08b<S0030000002OWil0WinO00h0WinO
00<000000;>c/`2c/k<02`2c/k<00`000000a/K60<K6aP090<K6aP030000003IfMT0fMWI00X0fMWI
00<000000>c/k03/k>`0303/k>`00`000000oooo0?ooo`0@0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00`3oool00`000?l0oooo0?ooo`0:0?ooo`030000o`3oool0oooo0140oooo00<0
00000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@0:0=WIf@0300000036a/H0a/K600X0a/K600<0
00000;>c/`2c/k<02`2c/k<00`000000WinO09nOW`0=09nOW`030000002<S8`0S8b<03h0S8b<00<0
000009nOW`2OWil03P2OWil00`000000/k>c0;>c/`0:0;>c/`0300000036a/H0a/K600X0a/K600<0
00000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00<0>c/k0030000003oool0oooo0100oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000o`3oool0oooo00T0oooo00<0003o
0?ooo`3oool04@3oool00`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI00X0fMWI00<00000
0<K6aP36a/H02P36a/H00`000000/k>c0;>c/`0;0;>c/`030000002OWil0WinO00d0WinO00<00000
08b<S02<S8`0@02<S8`2000000h0WinO00<000000;>c/`2c/k<02`2c/k<00`000000a/K60<K6aP09
0<K6aP030000003IfMT0fMWI00X0fMWI00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0@
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00`3oool00`000?l0oooo0?ooo`090?oo
o`030000o`3oool0oooo0140oooo00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@0:0=WI
f@0300000036a/H0a/K600T0a/K60P00000<0;>c/`030000002OWil0WinO00d0WinO00<0000008b<
S02<S8`0@`2<S8`00`000000WinO09nOW`0<09nOW`030000002c/k<0/k>c00/0/k>c00<000000<K6
aP36a/H02@36a/H00`000000fMWI0=WIf@0:0=WIf@030000003/k>`0k>c/00/0k>c/00<000000?oo
o`3oool03`3oool100000040oooo000E0?ooo`030000003oool0oooo00<0oooo00<0003o0?ooo`3o
ool02@3oool00`000?l0oooo0?ooo`0A0?ooo`030000003/k>`0k>c/00d0k>c/00<000000=WIf@3I
fMT02P3IfMT00`000000a/K60<K6aP090<K6aP030000002c/k<0/k>c00X0/k>c00<0000009nOW`2O
Wil03@2OWil00`000000S8b<08b<S00I08b<S18000006@2<S8`00`000000WinO09nOW`0=09nOW`03
0000002c/k<0/k>c00X0/k>c00<000000<K6aP36a/H02@36a/H00`000000fMWI0=WIf@0:0=WIf@03
0000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool03`3oool100000040oooo00000`3oool00000
0000000300000080oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`040?ooo`030000
o`3oool0oooo00L0oooo00<0003o0?ooo`3oool04@3oool00`000000k>c/0>c/k00=0>c/k0030000
003IfMT0fMWI00X0fMWI00<000000<K6aP36a/H02@36a/H00`000000/k>c0;>c/`0;0;>c/`030000
002OWil0WinO00`0WinO00<0000008b<S02<S8`05`2<S8`300000180NGUi0P00000H08b<S0030000
002OWil0WinO00d0WinO00<000000;>c/`2c/k<02P2c/k<00`000000a/K60<K6aP090<K6aP030000
003IfMT0fMWI00X0fMWI00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0>0?ooo`400000
0@3oool000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00@0oooo00<0003o0?ooo`3oool01`3oool00`000?l0oooo0?ooo`0A0?ooo`030000003/
k>`0k>c/00d0k>c/00<000000=WIf@3IfMT02P3IfMT00`000000a/K60<K6aP090<K6aP030000002c
/k<0/k>c00X0/k>c00<0000009nOW`2OWil0302OWil00`000000S8b<08b<S00F08b<S08000005`1i
NGT3000001H0S8b<00<0000009nOW`2OWil0302OWil00`000000/k>c0;>c/`0:0;>c/`0300000036
a/H0a/K600T0a/K600<000000=WIf@3IfMT02P3IfMT00`000000k>c/0>c/k00;0>c/k0030000003o
ool0oooo00h0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00@0oooo0P0000050?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool0403oool0
0`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI00X0fMWI00<000000<K6aP36a/H02@36a/H0
0`000000/k>c0;>c/`0:0;>c/`030000002OWil0WinO00`0WinO00<0000008b<S02<S8`0502<S8`3
000001`0NGUi0P00000E08b<S08000003@2OWil00`000000/k>c0;>c/`0:0;>c/`0300000036a/H0
a/K600T0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00;0>c/k0030000003oool0
oooo00d0oooo0P0000010?ooo`000`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0103oool00`000?l0oooo0?ooo`070?ooo`030000o`3oool0oooo
0100oooo00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@090=WIf@0300000036a/H0a/K6
00X0a/K600<000000;>c/`2c/k<02@2c/k<00`000000WinO09nOW`0<09nOW`030000002<S8`0S8b<
0180S8b<0`00000Q07UiN@<00000502<S8`00`000000WinO09nOW`0;09nOW`030000002c/k<0/k>c
00X0/k>c00<000000<K6aP36a/H02036a/H00`000000fMWI0=WIf@090=WIf@8000003@3/k>`00`00
0000oooo0?ooo`0=0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool01`3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`00
0?l0oooo0?ooo`0A0?ooo`030000003/k>`0k>c/00`0k>c/00<000000=WIf@3IfMT02P3IfMT00`00
0000a/K60<K6aP090<K6aP030000002c/k<0/k>c00T0/k>c00<0000009nOW`2OWil0302OWil00`00
0000S8b<08b<S00A08b<S08000009`1iNGT00`000000S8b<08b<S00A08b<S0030000002OWil0WinO
00/0WinO00<000000;>c/`2c/k<02P2c/k<00`000000a/K60<K6aP090<K6aP030000003IfMT0fMWI
00T0fMWI00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0=0?ooo`4000000@3oool00080
oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`030000o`3oool0oooo00H0
oooo00<0003o0?ooo`3oool0403oool00`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI00T0
fMWI00<000000<K6aP36a/H02P36a/H00`000000/k>c0;>c/`090;>c/`030000002OWil0WinO00/0
WinO00<0000008b<S02<S8`0402<S8`2000002X0NGUi00<0000008b<S02<S8`04@2<S8`00`000000
WinO09nOW`0;09nOW`030000002c/k<0/k>c00T0/k>c00<000000<K6aP36a/H02@36a/H00`000000
fMWI0=WIf@0:0=WIf@030000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool0303oool100000040
oooo000E0?ooo`030000003oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo
0?ooo`0@0?ooo`030000003/k>`0k>c/00d0k>c/00<000000=WIf@3IfMT02@3IfMT00`000000a/K6
0<K6aP090<K6aP030000002c/k<0/k>c00T0/k>c00<0000009nOW`2OWil02`2OWil00`000000S8b<
08b<S00@08b<S0030000001iNGT0NGUi02/0NGUi0P00000B08b<S0030000002OWil0WinO00/0WinO
00<000000;>c/`2c/k<02@2c/k<00`000000a/K60<K6aP090<K6aP030000003IfMT0fMWI00T0fMWI
00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0<0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo0140oooo00<0
00000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@090=WIf@0300000036a/H0a/K600T0a/K600<0
00000;>c/`2c/k<02@2c/k<00`000000WinO09nOW`0:09nOW`030000002<S8`0S8b<00l0S8b<0P00
000`07UiN@8000004@2<S8`00`000000WinO09nOW`0:09nOW`030000002c/k<0/k>c00T0/k>c00<0
00000<K6aP36a/H02@36a/H00`000000fMWI0=WIf@090=WIf@030000003/k>`0k>c/00/0k>c/00<0
00000?ooo`3oool0303oool100000040oooo000E0?ooo`030000003oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool00`000?l0oooo0?ooo`0@0?ooo`030000003/k>`0k>c/00d0k>c/00<00000
0=WIf@3IfMT02@3IfMT00`000000a/K60<K6aP090<K6aP030000002c/k<0/k>c00T0/k>c00<00000
09nOW`2OWil02P2OWil00`000000S8b<08b<S00?08b<S0030000001iNGT0NGUi0380NGUi00<00000
08b<S02<S8`03`2<S8`00`000000WinO09nOW`0:09nOW`030000002c/k<0/k>c00T0/k>c00<00000
0<K6aP36a/H02036a/H00`000000fMWI0=WIf@0:0=WIf@030000003/k>`0k>c/00/0k>c/00<00000
0?ooo`3oool02`3oool100000040oooo000E0?ooo`030000003oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool00`000?l0oooo0?ooo`0@0?ooo`030000003/k>`0k>c/00d0k>c/00<000000=WI
f@3IfMT02@3IfMT00`000000a/K60<K6aP090<K6aP030000002c/k<0/k>c00T0/k>c00<0000009nO
W`2OWil02P2OWil00`000000S8b<08b<S00>08b<S0030000001iNGT0NGUi03@0NGUi00<0000008b<
S02<S8`03P2<S8`00`000000WinO09nOW`0;09nOW`030000002c/k<0/k>c00P0/k>c0P00000:0<K6
aP030000003IfMT0fMWI00T0fMWI00<000000>c/k03/k>`02`3/k>`00`000000oooo0?ooo`0;0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`03
0000o`3oool0oooo00l0oooo00<000000>c/k03/k>`03@3/k>`00`000000fMWI0=WIf@090=WIf@03
00000036a/H0a/K600T0a/K600<000000;>c/`2c/k<02@2c/k<00`000000WinO09nOW`0:09nOW`03
0000002<S8`0S8b<00d0S8b<0P00000h07UiN@8000003`2<S8`00`000000WinO09nOW`0:09nOW`03
0000002c/k<0/k>c00T0/k>c00<000000<K6aP36a/H02036a/H00`000000fMWI0=WIf@090=WIf@03
0000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool02`3oool100000040oooo000E0?ooo`800000
1@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo0100oooo00<000000>c/k03/k>`0
3@3/k>`00`000000fMWI0=WIf@090=WIf@0300000036a/H0a/K600P0a/K600<000000;>c/`2c/k<0
2@2c/k<00`000000WinO09nOW`0:09nOW`030000002<S8`0S8b<00d0S8b<00<0000007UiN@1iNGT0
>P1iNGT00`000000S8b<08b<S00=08b<S08000002`2OWil00`000000/k>c0;>c/`090;>c/`030000
0036a/H0a/K600P0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00;0>c/k0030000
003oool0oooo00T0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0403oool00`000000k>c/0>c/k00=0>c/k0030000003I
fMT0fMWI00T0fMWI00<000000<K6aP36a/H02036a/H00`000000/k>c0;>c/`080;>c/`030000002O
Wil0WinO00X0WinO00<0000008b<S02<S8`03@2<S8`00`000000NGUi07UiN@0l07UiN@030000002<
S8`0S8b<00d0S8b<00<0000009nOW`2OWil02P2OWil00`000000/k>c0;>c/`080;>c/`0300000036
a/H0a/K600P0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00;0>c/k0030000003o
ool0oooo00X0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool03`3oool00`000000k>c/0>c/k00=0>c/k0030000003IfMT0
fMWI00T0fMWI00<000000<K6aP36a/H02036a/H00`000000/k>c0;>c/`090;>c/`030000002OWil0
WinO00T0WinO00<0000008b<S02<S8`03@2<S8`00`000000NGUi07UiN@0n07UiN@030000002<S8`0
S8b<00d0S8b<00<0000009nOW`2OWil02@2OWil00`000000/k>c0;>c/`090;>c/`0300000036a/H0
a/K600P0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00;0>c/k0030000003oool0
oooo00T0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`040?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool03`3oool00`000000k>c/0>c/k00=0>c/k0030000003IfMT0fMWI
00T0fMWI00<000000<K6aP36a/H02036a/H00`000000/k>c0;>c/`080;>c/`030000002OWil0WinO
00X0WinO00<0000008b<S02<S8`0302<S8`00`000000NGUi07UiN@0I07UiN@d000006P1iNGT20000
00d0S8b<00<0000009nOW`2OWil02P2OWil00`000000/k>c0;>c/`080;>c/`0300000036a/H0a/K6
00P0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00;0>c/k0030000003oool0oooo
00T0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00<0003o0?ooo`3oool0403oool00`000000k>c/0>c/k00<0>c/k0030000003IfMT0fMWI00T0
fMWI00<000000<K6aP36a/H02036a/H00`000000/k>c0;>c/`080;>c/`030000002OWil0WinO00X0
WinO00<0000008b<S02<S8`0302<S8`00`000000NGUi07UiN@0E07UiN@D000003@1VIVH3000001T0
NGUi00<0000008b<S02<S8`02`2<S8`00`000000WinO09nOW`0909nOW`030000002c/k<0/k>c00P0
/k>c00<000000<K6aP36a/H02036a/H00`000000fMWI0=WIf@090=WIf@030000003/k>`0k>c/00/0
k>c/00<000000?ooo`3oool02@3oool100000040oooo000E0?ooo`030000003oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`0@0?ooo`030000003/k>`0k>c/00`0k>c/
00<000000=WIf@3IfMT02@3IfMT00`000000a/K60<K6aP080<K6aP030000002c/k<0/k>c00P0/k>c
00<0000009nOW`2OWil02@2OWil00`000000S8b<08b<S00;08b<S08000005P1iNGT2000001D0IVIV
1@00000E07UiN@030000002<S8`0S8b<00/0S8b<00<0000009nOW`2OWil02@2OWil00`000000/k>c
0;>c/`080;>c/`0300000036a/H0a/K600P0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/
0>c/k00;0>c/k0030000003oool0oooo00P0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0403oool00`000000k>c/0>c/
k00;0>c/k0030000003IfMT0fMWI00T0fMWI00<000000<K6aP36a/H02036a/H00`000000/k>c0;>c
/`080;>c/`030000002OWil0WinO00X0WinO00<0000008b<S02<S8`02P2<S8`00`000000NGUi07Ui
N@0C07UiN@<00000701VIVH2000001<0NGUi00<0000008b<S02<S8`0302<S8`00`000000WinO09nO
W`0909nOW`030000002c/k<0/k>c00P0/k>c00<000000<K6aP36a/H01`36a/H00`000000fMWI0=WI
f@090=WIf@030000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool0203oool100000040oooo000E
0?ooo`030000003oool0oooo00@0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`0@
0?ooo`030000003/k>`0k>c/00`0k>c/00<000000=WIf@3IfMT02@3IfMT00`000000a/K60<K6aP07
0<K6aP030000002c/k<0/k>c00T0/k>c00<0000009nOW`2OWil02@2OWil00`000000S8b<08b<S00;
08b<S0030000001iNGT0NGUi0140NGUi0P00000Q06IVIP030000001iNGT0NGUi0140NGUi0P00000=
08b<S0030000002OWil0WinO00P0WinO00<000000;>c/`2c/k<0202c/k<00`000000a/K60<K6aP08
0<K6aP030000003IfMT0fMWI00T0fMWI00<000000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`08
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0103oool00`000?l0oooo0?ooo`020?oo
o`030000o`3oool0oooo0100oooo00<000000>c/k03/k>`0303/k>`00`000000fMWI0=WIf@080=WI
f@0300000036a/H0a/K600P0a/K600<000000;>c/`2c/k<0202c/k<00`000000WinO09nOW`0909nO
W`030000002<S8`0S8b<00/0S8b<00<0000007UiN@1iNGT0401iNGT2000002@0IVIV0P00000C07Ui
N@030000002<S8`0S8b<00X0S8b<00<0000009nOW`2OWil02@2OWil00`000000/k>c0;>c/`080;>c
/`0300000036a/H0a/K600L0a/K600<000000=WIf@3IfMT02@3IfMT00`000000k>c/0>c/k00:0>c/
k0030000003oool0oooo00P0oooo0@0000010?ooo`005@3oool2000000D0oooo00<0003o0?ooo`3o
ool00P3oool00`000?l0oooo0?ooo`0?0?ooo`030000003/k>`0k>c/00`0k>c/00<000000=WIf@3I
fMT02@3IfMT00`000000a/K60<K6aP070<K6aP030000002c/k<0/k>c00P0/k>c00<0000009nOW`2O
Wil02@2OWil00`000000S8b<08b<S00;08b<S0030000001iNGT0NGUi00l0NGUi0P00000X06IVIP80
00004P1iNGT00`000000S8b<08b<S00:08b<S0030000002OWil0WinO00T0WinO00<000000;>c/`2c
/k<01`2c/k<00`000000a/K60<K6aP080<K6aP030000003IfMT0fMWI00P0fMWI00<000000>c/k03/
k>`02P3/k>`00`000000oooo0?ooo`070?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0
103oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0oooo00l0oooo00<000000>c/k03/k>`0
303/k>`00`000000fMWI0=WIf@080=WIf@8000002@36a/H00`000000/k>c0;>c/`080;>c/`030000
002OWil0WinO00P0WinO00<0000008b<S02<S8`02P2<S8`200000100NGUi0P00000/06IVIP800000
4@1iNGT00`000000S8b<08b<S00:08b<S0030000002OWil0WinO00P0WinO00<000000;>c/`2c/k<0
202c/k<00`000000a/K60<K6aP080<K6aP030000003IfMT0fMWI00P0fMWI00<000000>c/k03/k>`0
2P3/k>`00`000000oooo0?ooo`070?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0103o
ool01@000?l0oooo0?ooo`3oool0003o0180oooo00<000000>c/k03/k>`0303/k>`00`000000fMWI
0=WIf@080=WIf@0300000036a/H0a/K600P0a/K600<000000;>c/`2c/k<01`2c/k<00`000000WinO
09nOW`0909nOW`030000002<S8`0S8b<00T0S8b<00<0000007UiN@1iNGT03`1iNGT00`000000IVIV
06IVIP0]06IVIP800000401iNGT00`000000S8b<08b<S00:08b<S0030000002OWil0WinO00T0WinO
00<000000;>c/`2c/k<01`2c/k<00`000000a/K60<K6aP080<K6aP030000003IfMT0fMWI00P0fMWI
00<000000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`070?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool01@3oool010000?l0oooo0?ooo`000?lA0?ooo`030000003/k>`0k>c/00`0k>c/
00<000000=WIf@3IfMT0203IfMT00`000000a/K60<K6aP080<K6aP030000002c/k<0/k>c00P0/k>c
00<0000009nOW`2OWil0202OWil00`000000S8b<08b<S00:08b<S0030000001iNGT0NGUi00h0NGUi
00<0000006IVIP1VIVH0<01VIVH2000000l0NGUi00<0000008b<S02<S8`02P2<S8`00`000000WinO
09nOW`0809nOW`030000002c/k<0/k>c00P0/k>c00<000000<K6aP36a/H02036a/H00`000000fMWI
0=WIf@070=WIf@030000003/k>`0k>c/00/0k>c/00<000000?ooo`3oool01P3oool100000040oooo
000E0?ooo`030000003oool0oooo00D0oooo00@0003o0?ooo`3oool0003o4@3oool00`000000k>c/
0>c/k00<0>c/k0030000003IfMT0fMWI00P0fMWI00<000000<K6aP36a/H02036a/H00`000000/k>c
0;>c/`070;>c/`030000002OWil0WinO00P0WinO0P00000;08b<S0030000001iNGT0NGUi00d0NGUi
0P00000e06IVIP030000001iNGT0NGUi00d0NGUi00<0000008b<S02<S8`02P2<S8`00`000000WinO
09nOW`0809nOW`030000002c/k<0/k>c00L0/k>c00<000000<K6aP36a/H02036a/H00`000000fMWI
0=WIf@080=WIf@030000003/k>`0k>c/00X0k>c/00<000000?ooo`3oool01P3oool100000040oooo
000E0?ooo`030000003oool0oooo00D0oooo00<0003o0?ooo`000?l04P3oool00`000000k>c/0>c/
k00<0>c/k0030000003IfMT0fMWI00P0fMWI00<000000<K6aP36a/H02036a/H00`000000/k>c0;>c
/`070;>c/`030000002OWil0WinO00P0WinO00<0000008b<S02<S8`02@2<S8`00`000000NGUi07Ui
N@0=07UiN@030000001VIVH0IVIV03H0IVIV0P00000>07UiN@030000002<S8`0S8b<00T0S8b<00<0
000009nOW`2OWil0202OWil00`000000/k>c0;>c/`080;>c/`0300000036a/H0a/K600L0a/K600<0
00000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00:0>c/k0030000003oool0oooo00H0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`050?ooo`030000o`3oool0003o0140oooo00<00000
0>c/k03/k>`0303/k>`00`000000fMWI0=WIf@080=WIf@0300000036a/H0a/K600P0a/K600<00000
0;>c/`2c/k<01`2c/k<00`000000WinO09nOW`0809nOW`030000002<S8`0S8b<00X0S8b<00<00000
07UiN@1iNGT0301iNGT00`000000IVIV06IVIP0h06IVIP030000001iNGT0NGUi00`0NGUi00<00000
08b<S02<S8`02P2<S8`00`000000WinO09nOW`0709nOW`030000002c/k<0/k>c00P0/k>c00<00000
0<K6aP36a/H01`36a/H00`000000fMWI0=WIf@090=WIf@030000003/k>`0k>c/00X0k>c/00<00000
0?ooo`3oool01@3oool100000040oooo000E0?ooo`030000003oool0oooo00D0oooo00<0003o0?oo
o`000?l04@3oool00`000000k>c/0>c/k00<0>c/k0030000003IfMT0fMWI00P0fMWI00<000000<K6
aP36a/H01`36a/H2000000T0/k>c00<0000009nOW`2OWil0202OWil00`000000S8b<08b<S00908b<
S0030000001iNGT0NGUi00`0NGUi00<0000006IVIP1VIVH0>P1VIVH2000000d0NGUi00<0000008b<
S02<S8`02@2<S8`00`000000WinO09nOW`0809nOW`030000002c/k<0/k>c00L0/k>c00<000000<K6
aP36a/H02036a/H00`000000fMWI0=WIf@080=WIf@030000003/k>`0k>c/00X0k>c/00<000000?oo
o`3oool01@3oool100000040oooo000E0?ooo`030000003oool0oooo00D0oooo00<0003o0?ooo`00
0?l0403oool00`000000k>c/0>c/k00<0>c/k0030000003IfMT0fMWI00P0fMWI00<000000<K6aP36
a/H01`36a/H00`000000/k>c0;>c/`090;>c/`030000002OWil0WinO00L0WinO00<0000008b<S02<
S8`02@2<S8`00`000000NGUi07UiN@0<07UiN@030000001VIVH0IVIV03d0IVIV00<0000007UiN@1i
NGT02`1iNGT2000000X0S8b<00<0000009nOW`2OWil0202OWil00`000000/k>c0;>c/`070;>c/`03
00000036a/H0a/K600L0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00:0>c/k003
0000003oool0oooo00D0oooo0@0000010?ooo`005@3oool2000000H0oooo0P000?lA0?ooo`030000
003/k>`0k>c/00`0k>c/00<000000=WIf@3IfMT0203IfMT00`000000a/K60<K6aP070<K6aP030000
002c/k<0/k>c00P0/k>c00<0000009nOW`2OWil01`2OWil00`000000S8b<08b<S00908b<S0030000
001iNGT0NGUi00/0NGUi0P00000H06IVIQ8000005`1VIVH00`000000NGUi07UiN@0<07UiN@030000
002<S8`0S8b<00P0S8b<00<0000009nOW`2OWil0202OWil00`000000/k>c0;>c/`070;>c/`030000
0036a/H0a/K600L0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00:0>c/k0030000
003oool0oooo00<0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`030?ooo`800?oo0P00
0?lA0?ooo`030000003/k>`0k>c/00/0k>c/00<000000=WIf@3IfMT02@3IfMT00`000000a/K60<K6
aP070<K6aP030000002c/k<0/k>c00L0/k>c00<0000009nOW`2OWil0202OWil00`000000S8b<08b<
S00808b<S0030000001iNGT0NGUi00/0NGUi00<0000006IVIP1VIVH05@1VIVH300000180De=C0P00
000F06IVIP030000001iNGT0NGUi00/0NGUi00<0000008b<S02<S8`02@2<S8`00`000000WinO09nO
W`0709nOW`030000002c/k<0/k>c00L0/k>c00<000000<K6aP36a/H01`36a/H00`000000fMWI0=WI
f@080=WIf@030000003/k>`0k>c/00X0k>c/00<000000?ooo`3oool0103oool100000040oooo000E
0?ooo`040000003oool0oooo0?ooo`<00?oo00@0o`000000o`000?l00?oo3`3oool00`000000k>c/
0>c/k00<0>c/k0030000003IfMT0fMWI00P0fMWI00<000000<K6aP36a/H01`36a/H00`000000/k>c
0;>c/`080;>c/`030000002OWil0WinO00L0WinO00<0000008b<S02<S8`0202<S8`00`000000NGUi
07UiN@0;07UiN@030000001VIVH0IVIV01@0IVIV0P00000G05=CD`8000005@1VIVH00`000000NGUi
07UiN@0;07UiN@030000002<S8`0S8b<00P0S8b<00<0000009nOW`2OWil01`2OWil00`000000/k>c
0;>c/`070;>c/`0300000036a/H0a/K600L0a/K600<000000=WIf@3IfMT0203IfMT00`000000k>c/
0>c/k00;0>c/k0030000003oool0oooo00<0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`02003oo`80o`0000D00?l00000o`000?l0o`00003oo`0>0?ooo`030000003/k>`0k>c/00`0k>c/
00<000000=WIf@3IfMT0203IfMT00`000000a/K60<K6aP070<K6aP030000002c/k<0/k>c00L0/k>c
00<0000009nOW`2OWil01`2OWil2000000X0S8b<00<0000007UiN@1iNGT02P1iNGT00`000000IVIV
06IVIP0B06IVIP<000006`1CDe<3000001<0IVIV00<0000007UiN@1iNGT02P1iNGT00`000000S8b<
08b<S00908b<S0030000002OWil0WinO00L0WinO00<000000;>c/`2c/k<01`2c/k<00`000000a/K6
0<K6aP070<K6aP030000003IfMT0fMWI00P0fMWI00<000000>c/k03/k>`02P3/k>`00`000000oooo
0?ooo`030?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P00ool0103o00000?l0003o
00000?l2003o0003003oo`3oool0oooo00`0oooo00<000000>c/k03/k>`02`3/k>`00`000000fMWI
0=WIf@080=WIf@0300000036a/H0a/K600P0a/K600<000000;>c/`2c/k<01P2c/k<00`000000WinO
09nOW`0709nOW`030000002<S8`0S8b<00T0S8b<00<0000007UiN@1iNGT02P1iNGT00`000000IVIV
06IVIP0A06IVIP8000008@1CDe<300000140IVIV0P00000;07UiN@030000002<S8`0S8b<00P0S8b<
00<0000009nOW`2OWil01`2OWil00`000000/k>c0;>c/`070;>c/`0300000036a/H0a/K600L0a/K6
00<000000=WIf@3IfMT0203IfMT00`000000k>c/0>c/k00:0>c/k0030000003oool0oooo00<0oooo
0@0000010?ooo`005@3oool010000000oooo003oo`00ool20?l00003003o00000?l0003o00800?l0
00<0o`00003oo`3oool0303oool00`000000k>c/0>c/k00;0>c/k0030000003IfMT0fMWI00P0fMWI
00<000000<K6aP36a/H01`36a/H00`000000/k>c0;>c/`070;>c/`030000002OWil0WinO00L0WinO
00<0000008b<S02<S8`0202<S8`2000000/0NGUi0P00000@06IVIP<000009P1CDe<200000140IVIV
00<0000007UiN@1iNGT02@1iNGT00`000000S8b<08b<S00808b<S0030000002OWil0WinO00L0WinO
00<000000;>c/`2c/k<01`2c/k<00`000000a/K60<K6aP070<K6aP030000003IfMT0fMWI00P0fMWI
00<000000>c/k03/k>`02P3/k>`00`000000oooo0?ooo`020?ooo`4000000@3oool001D0oooo00@0
00000?ooo`00ool00?oo0P3o00030000o`800?l000<0o`00003oo`3oool0n`3oool100000040oooo
00000`3oool000000000000300000080oooo0P0000050?ooo`<000000`3oool00`000000oooo003o
o`02003oo`80o`0000@0003o003o0000o`00o`000P00oool0?ooo`4000000@3oool000<0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00800?oo1P3o
00000`00ool0oooo0?ooo`3k0?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool01`3oool5
000000<0oooo0P0000000`3oool00?oo003oo`02003oo`80o`000`00ool50?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`040000003oool0
oooo0?ooo`8000000@3oool000<0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00
00040?ooo`@000001`00oooo00000040oooo00030?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`000000o`3oool@0?ooo`000P3oool2000000/0oooo0P00003o0?oooa00oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.4277, -0.137322, 0.00861598, \
0.00550246}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({2.1468109978491192`*^-26, {X\_1 \[Rule] 0.9999999999998546`, 
            X\_2 \[Rule] 0.9999999999997073`}}\), 
        ",", \({"Steps" \[Rule] 21, "Function" \[Rule] 22, 
          "Gradient" \[Rule] 22, "Hessian" \[Rule] 22}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[19]="]
}, Open  ]],

Cell[TextData[{
  "This shows the steps taken by ",
  StyleBox["FindMinimum", "MR"],
  " with a line search",
  " ",
  "Newton method for the same function."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[p, \ Method \[Rule] "\<Newton\>"]\)], "Input",
  CellLabel->"In[20]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.543706 0.437063 0.689361 0.211062 [
[.10664 -0.0125 -6 -9 ]
[.10664 -0.0125 6 0 ]
[.32517 -0.0125 -12 -9 ]
[.32517 -0.0125 12 0 ]
[.54371 -0.0125 -3 -9 ]
[.54371 -0.0125 3 0 ]
[.76224 -0.0125 -9 -9 ]
[.76224 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .05617 -12 -4.5 ]
[-0.0125 .05617 0 4.5 ]
[-0.0125 .26724 -12 -4.5 ]
[-0.0125 .26724 0 4.5 ]
[-0.0125 .4783 -12 -4.5 ]
[-0.0125 .4783 0 4.5 ]
[-0.0125 .68936 -6 -4.5 ]
[-0.0125 .68936 0 4.5 ]
[-0.0125 .90042 -6 -4.5 ]
[-0.0125 .90042 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10664 0 m
.10664 .00625 L
s
[(-1)] .10664 -0.0125 0 1 Mshowa
.32517 0 m
.32517 .00625 L
s
[(-0.5)] .32517 -0.0125 0 1 Mshowa
.54371 0 m
.54371 .00625 L
s
[(0)] .54371 -0.0125 0 1 Mshowa
.76224 0 m
.76224 .00625 L
s
[(0.5)] .76224 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(1)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.15035 0 m
.15035 .00375 L
s
.19406 0 m
.19406 .00375 L
s
.23776 0 m
.23776 .00375 L
s
.28147 0 m
.28147 .00375 L
s
.36888 0 m
.36888 .00375 L
s
.41259 0 m
.41259 .00375 L
s
.45629 0 m
.45629 .00375 L
s
.5 0 m
.5 .00375 L
s
.58741 0 m
.58741 .00375 L
s
.63112 0 m
.63112 .00375 L
s
.67483 0 m
.67483 .00375 L
s
.71853 0 m
.71853 .00375 L
s
.80594 0 m
.80594 .00375 L
s
.84965 0 m
.84965 .00375 L
s
.89336 0 m
.89336 .00375 L
s
.93706 0 m
.93706 .00375 L
s
.06294 0 m
.06294 .00375 L
s
.01923 0 m
.01923 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .05617 m
.00625 .05617 L
s
[(-3)] -0.0125 .05617 1 0 Mshowa
0 .26724 m
.00625 .26724 L
s
[(-2)] -0.0125 .26724 1 0 Mshowa
0 .4783 m
.00625 .4783 L
s
[(-1)] -0.0125 .4783 1 0 Mshowa
0 .68936 m
.00625 .68936 L
s
[(0)] -0.0125 .68936 1 0 Mshowa
0 .90042 m
.00625 .90042 L
s
[(1)] -0.0125 .90042 1 0 Mshowa
.125 Mabswid
0 .09839 m
.00375 .09839 L
s
0 .1406 m
.00375 .1406 L
s
0 .18281 m
.00375 .18281 L
s
0 .22502 m
.00375 .22502 L
s
0 .30945 m
.00375 .30945 L
s
0 .35166 m
.00375 .35166 L
s
0 .39387 m
.00375 .39387 L
s
0 .43609 m
.00375 .43609 L
s
0 .52051 m
.00375 .52051 L
s
0 .56272 m
.00375 .56272 L
s
0 .60494 m
.00375 .60494 L
s
0 .64715 m
.00375 .64715 L
s
0 .73157 m
.00375 .73157 L
s
0 .77379 m
.00375 .77379 L
s
0 .816 m
.00375 .816 L
s
0 .85821 m
.00375 .85821 L
s
0 .01396 m
.00375 .01396 L
s
0 .94264 m
.00375 .94264 L
s
0 .98485 m
.00375 .98485 L
s
.25 Mabswid
0 0 m
0 1 L
s
.10664 .99375 m
.10664 1 L
s
.32517 .99375 m
.32517 1 L
s
.54371 .99375 m
.54371 1 L
s
.76224 .99375 m
.76224 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.15035 .99625 m
.15035 1 L
s
.19406 .99625 m
.19406 1 L
s
.23776 .99625 m
.23776 1 L
s
.28147 .99625 m
.28147 1 L
s
.36888 .99625 m
.36888 1 L
s
.41259 .99625 m
.41259 1 L
s
.45629 .99625 m
.45629 1 L
s
.5 .99625 m
.5 1 L
s
.58741 .99625 m
.58741 1 L
s
.63112 .99625 m
.63112 1 L
s
.67483 .99625 m
.67483 1 L
s
.71853 .99625 m
.71853 1 L
s
.80594 .99625 m
.80594 1 L
s
.84965 .99625 m
.84965 1 L
s
.89336 .99625 m
.89336 1 L
s
.93706 .99625 m
.93706 1 L
s
.06294 .99625 m
.06294 1 L
s
.01923 .99625 m
.01923 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .05617 m
1 .05617 L
s
.99375 .26724 m
1 .26724 L
s
.99375 .4783 m
1 .4783 L
s
.99375 .68936 m
1 .68936 L
s
.99375 .90042 m
1 .90042 L
s
.125 Mabswid
.99625 .09839 m
1 .09839 L
s
.99625 .1406 m
1 .1406 L
s
.99625 .18281 m
1 .18281 L
s
.99625 .22502 m
1 .22502 L
s
.99625 .30945 m
1 .30945 L
s
.99625 .35166 m
1 .35166 L
s
.99625 .39387 m
1 .39387 L
s
.99625 .43609 m
1 .43609 L
s
.99625 .52051 m
1 .52051 L
s
.99625 .56272 m
1 .56272 L
s
.99625 .60494 m
1 .60494 L
s
.99625 .64715 m
1 .64715 L
s
.99625 .73157 m
1 .73157 L
s
.99625 .77379 m
1 .77379 L
s
.99625 .816 m
1 .816 L
s
.99625 .85821 m
1 .85821 L
s
.99625 .01396 m
1 .01396 L
s
.99625 .94264 m
1 .94264 L
s
.99625 .98485 m
1 .98485 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.625 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.7 g
.01923 .33913 m
.02711 .33003 L
.02894 .32794 L
.03567 .32032 L
.03866 .31696 L
.04437 .31061 L
.04837 .3062 L
.05322 .30089 L
.05808 .29564 L
.06224 .29118 L
.06779 .28529 L
.07143 .28147 L
.07751 .27514 L
.0808 .27176 L
.08722 .26521 L
.09036 .26204 L
.09693 .25549 L
.10013 .25233 L
.10664 .24597 L
.11012 .24262 L
.11636 .23667 L
.12034 .23291 L
.12607 .22757 L
.13082 .22319 L
.13578 .21868 L
.14157 .21348 L
.14549 .21 L
.15261 .20377 L
.15521 .20153 L
.16398 .19406 L
.16492 .19327 L
.17463 .18521 L
.17569 .18434 L
.18434 .17737 L
.18779 .17463 L
.19406 .16973 L
.20032 .16492 L
.20377 .1623 L
.21332 .15521 L
.21348 .15509 L
.22319 .14808 L
.22685 .14549 L
.23291 .14127 L
.24098 .13578 L
.24262 .13468 L
.25233 .1283 L
.2558 .12607 L
.26204 .12212 L
.27143 .11636 L
.27176 .11616 L
.28147 .1104 L
.28801 .10664 L
.29118 .10485 L
.30089 .09951 L
.30574 .09693 L
.31061 .09438 L
.32032 .08946 L
.32489 .08722 L
.33003 .08475 L
.33974 .08025 L
.34588 .07751 L
.34946 .07595 L
.35917 .07186 L
.36888 .06799 L
.36938 .06779 L
.37859 .06432 L
.38831 .06086 L
.39656 .05808 L
.39802 .05761 L
.40773 .05456 L
.41744 .05173 L
.42716 .0491 L
.43002 .04837 L
.43687 .04669 L
.44658 .04448 L
.45629 .04248 L
.46601 .04069 L
.47572 .03911 L
.47877 .03866 L
.48543 .03774 L
.49514 .03657 L
.50486 .03562 L
.51457 .03487 L
.52428 .03434 L
.53399 .03401 L
.54371 .03389 L
.55342 .03398 L
.56313 .03428 L
.57284 .03478 L
.58256 .0355 L
.59227 .03642 L
.60198 .03756 L
.61005 .03866 L
.61169 .0389 L
.62141 .04045 L
.63112 .04221 L
.64083 .04418 L
.65054 .04636 L
.65879 .04837 L
.66026 .04874 L
.66997 .05134 L
.67968 .05414 L
.68939 .05715 L
.69226 .05808 L
.69911 .06037 L
.70882 .0638 L
.71853 .06744 L
.71944 .06779 L
.72824 .07129 L
.73796 .07535 L
.74293 .07751 L
.74767 .07961 L
.75738 .08409 L
.76393 .08722 L
.76709 .08877 L
.77681 .09366 L
.78308 .09693 L
.78652 .09876 L
.79623 .10407 L
.80081 .10664 L
.80594 .10959 L
.81566 .11531 L
.81739 .11636 L
.82537 .12125 L
.83302 .12607 L
.83508 .12739 L
.84479 .13375 L
.84784 .13578 L
.85451 .14031 L
.86197 .14549 L
.86422 .14708 L
.87393 .15406 L
.8755 .15521 L
.88364 .16125 L
.8885 .16492 L
.89336 .16864 L
.90103 .17463 L
.90307 .17625 L
.91278 .18406 L
.91312 .18434 L
.92249 .19209 L
.92484 .19406 L
.93221 .20032 L
.9362 .20377 L
.94192 .20876 L
.94725 .21348 L
.95163 .21741 L
.958 .22319 L
.96134 .22627 L
.96848 .23291 L
.97106 .23534 L
.9787 .24262 L
.98077 .24461 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .33913 m
.02711 .33003 L
.02894 .32794 L
.03567 .32032 L
.03866 .31696 L
.04437 .31061 L
.04837 .3062 L
.05322 .30089 L
.05808 .29564 L
.06224 .29118 L
.06779 .28529 L
.07143 .28147 L
.07751 .27514 L
.0808 .27176 L
.08722 .26521 L
.09036 .26204 L
.09693 .25549 L
.10013 .25233 L
.10664 .24597 L
.11012 .24262 L
.11636 .23667 L
.12034 .23291 L
.12607 .22757 L
.13082 .22319 L
.13578 .21868 L
.14157 .21348 L
.14549 .21 L
.15261 .20377 L
.15521 .20153 L
.16398 .19406 L
.16492 .19327 L
.17463 .18521 L
.17569 .18434 L
.18434 .17737 L
.18779 .17463 L
.19406 .16973 L
.20032 .16492 L
.20377 .1623 L
.21332 .15521 L
.21348 .15509 L
.22319 .14808 L
.22685 .14549 L
.23291 .14127 L
.24098 .13578 L
.24262 .13468 L
.25233 .1283 L
.2558 .12607 L
.26204 .12212 L
.27143 .11636 L
.27176 .11616 L
Mistroke
.28147 .1104 L
.28801 .10664 L
.29118 .10485 L
.30089 .09951 L
.30574 .09693 L
.31061 .09438 L
.32032 .08946 L
.32489 .08722 L
.33003 .08475 L
.33974 .08025 L
.34588 .07751 L
.34946 .07595 L
.35917 .07186 L
.36888 .06799 L
.36938 .06779 L
.37859 .06432 L
.38831 .06086 L
.39656 .05808 L
.39802 .05761 L
.40773 .05456 L
.41744 .05173 L
.42716 .0491 L
.43002 .04837 L
.43687 .04669 L
.44658 .04448 L
.45629 .04248 L
.46601 .04069 L
.47572 .03911 L
.47877 .03866 L
.48543 .03774 L
.49514 .03657 L
.50486 .03562 L
.51457 .03487 L
.52428 .03434 L
.53399 .03401 L
.54371 .03389 L
.55342 .03398 L
.56313 .03428 L
.57284 .03478 L
.58256 .0355 L
.59227 .03642 L
.60198 .03756 L
.61005 .03866 L
.61169 .0389 L
.62141 .04045 L
.63112 .04221 L
.64083 .04418 L
.65054 .04636 L
.65879 .04837 L
.66026 .04874 L
Mistroke
.66997 .05134 L
.67968 .05414 L
.68939 .05715 L
.69226 .05808 L
.69911 .06037 L
.70882 .0638 L
.71853 .06744 L
.71944 .06779 L
.72824 .07129 L
.73796 .07535 L
.74293 .07751 L
.74767 .07961 L
.75738 .08409 L
.76393 .08722 L
.76709 .08877 L
.77681 .09366 L
.78308 .09693 L
.78652 .09876 L
.79623 .10407 L
.80081 .10664 L
.80594 .10959 L
.81566 .11531 L
.81739 .11636 L
.82537 .12125 L
.83302 .12607 L
.83508 .12739 L
.84479 .13375 L
.84784 .13578 L
.85451 .14031 L
.86197 .14549 L
.86422 .14708 L
.87393 .15406 L
.8755 .15521 L
.88364 .16125 L
.8885 .16492 L
.89336 .16864 L
.90103 .17463 L
.90307 .17625 L
.91278 .18406 L
.91312 .18434 L
.92249 .19209 L
.92484 .19406 L
.93221 .20032 L
.9362 .20377 L
.94192 .20876 L
.94725 .21348 L
.95163 .21741 L
.958 .22319 L
.96134 .22627 L
.96848 .23291 L
Mistroke
.97106 .23534 L
.9787 .24262 L
.98077 .24461 L
Mfstroke
.775 g
.01923 .41264 m
.02347 .40773 L
.02894 .40145 L
.03196 .39802 L
.03866 .39047 L
.04059 .38831 L
.04837 .37969 L
.04937 .37859 L
.05808 .36913 L
.05831 .36888 L
.06742 .35917 L
.06779 .35878 L
.07671 .34946 L
.07751 .34863 L
.08618 .33974 L
.08722 .33869 L
.09586 .33003 L
.09693 .32897 L
.10574 .32032 L
.10664 .31945 L
.11586 .31061 L
.11636 .31014 L
.12607 .30103 L
.12622 .30089 L
.13578 .29214 L
.13684 .29118 L
.14549 .28346 L
.14775 .28147 L
.15521 .27498 L
.15897 .27176 L
.16492 .26672 L
.17052 .26204 L
.17463 .25866 L
.18244 .25233 L
.18434 .25081 L
.19406 .24317 L
.19477 .24262 L
.20377 .23574 L
.20755 .23291 L
.21348 .22852 L
.22083 .22319 L
.22319 .22151 L
.23291 .2147 L
.23468 .21348 L
.24262 .20811 L
.24918 .20377 L
.25233 .20172 L
.26204 .19554 L
.26443 .19406 L
.27176 .18957 L
.28056 .18434 L
.28147 .18381 L
.29118 .17826 L
.29774 .17463 L
.30089 .17292 L
.31061 .16779 L
.31621 .16492 L
.32032 .16286 L
.33003 .15815 L
.33632 .15521 L
.33974 .15364 L
.34946 .14934 L
.35858 .14549 L
.35917 .14525 L
.36888 .14137 L
.37859 .1377 L
.38391 .13578 L
.38831 .13424 L
.39802 .13098 L
.40773 .12794 L
.41405 .12607 L
.41744 .1251 L
.42716 .12248 L
.43687 .12006 L
.44658 .11785 L
.45372 .11636 L
.45629 .11585 L
.46601 .11405 L
.47572 .11247 L
.48543 .1111 L
.49514 .10993 L
.50486 .10897 L
.51457 .10823 L
.52428 .10769 L
.53399 .10736 L
.54371 .10724 L
.55342 .10732 L
.56313 .10762 L
.57284 .10812 L
.58256 .10884 L
.59227 .10976 L
.60198 .11089 L
.61169 .11223 L
.62141 .11378 L
.63112 .11554 L
.63528 .11636 L
.64083 .11751 L
.65054 .11968 L
.66026 .12207 L
.66997 .12466 L
.67494 .12607 L
.67968 .12746 L
.68939 .13047 L
.69911 .13369 L
.70509 .13578 L
.70882 .13712 L
.71853 .14076 L
.72824 .14461 L
.73041 .14549 L
.73796 .14866 L
.74767 .15293 L
.75268 .15521 L
.75738 .1574 L
.76709 .16208 L
.77278 .16492 L
.77681 .16697 L
.78652 .17207 L
.79125 .17463 L
.79623 .17738 L
.80594 .1829 L
.80843 .18434 L
.81566 .18862 L
.82456 .19406 L
.82537 .19456 L
.83508 .2007 L
.83981 .20377 L
.84479 .20705 L
.85431 .21348 L
.85451 .21361 L
.86422 .22038 L
.86816 .22319 L
.87393 .22736 L
.88145 .23291 L
.88364 .23455 L
.89336 .24195 L
.89422 .24262 L
.90307 .24955 L
.90655 .25233 L
.91278 .25737 L
.91847 .26204 L
.92249 .26539 L
.93003 .27176 L
.93221 .27362 L
.94124 .28147 L
.94192 .28206 L
.95163 .29071 L
.95215 .29118 L
.96134 .29957 L
.96277 .30089 L
.97106 .30864 L
.97313 .31061 L
.98077 .31792 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .41264 m
.02347 .40773 L
.02894 .40145 L
.03196 .39802 L
.03866 .39047 L
.04059 .38831 L
.04837 .37969 L
.04937 .37859 L
.05808 .36913 L
.05831 .36888 L
.06742 .35917 L
.06779 .35878 L
.07671 .34946 L
.07751 .34863 L
.08618 .33974 L
.08722 .33869 L
.09586 .33003 L
.09693 .32897 L
.10574 .32032 L
.10664 .31945 L
.11586 .31061 L
.11636 .31014 L
.12607 .30103 L
.12622 .30089 L
.13578 .29214 L
.13684 .29118 L
.14549 .28346 L
.14775 .28147 L
.15521 .27498 L
.15897 .27176 L
.16492 .26672 L
.17052 .26204 L
.17463 .25866 L
.18244 .25233 L
.18434 .25081 L
.19406 .24317 L
.19477 .24262 L
.20377 .23574 L
.20755 .23291 L
.21348 .22852 L
.22083 .22319 L
.22319 .22151 L
.23291 .2147 L
.23468 .21348 L
.24262 .20811 L
.24918 .20377 L
.25233 .20172 L
.26204 .19554 L
.26443 .19406 L
.27176 .18957 L
Mistroke
.28056 .18434 L
.28147 .18381 L
.29118 .17826 L
.29774 .17463 L
.30089 .17292 L
.31061 .16779 L
.31621 .16492 L
.32032 .16286 L
.33003 .15815 L
.33632 .15521 L
.33974 .15364 L
.34946 .14934 L
.35858 .14549 L
.35917 .14525 L
.36888 .14137 L
.37859 .1377 L
.38391 .13578 L
.38831 .13424 L
.39802 .13098 L
.40773 .12794 L
.41405 .12607 L
.41744 .1251 L
.42716 .12248 L
.43687 .12006 L
.44658 .11785 L
.45372 .11636 L
.45629 .11585 L
.46601 .11405 L
.47572 .11247 L
.48543 .1111 L
.49514 .10993 L
.50486 .10897 L
.51457 .10823 L
.52428 .10769 L
.53399 .10736 L
.54371 .10724 L
.55342 .10732 L
.56313 .10762 L
.57284 .10812 L
.58256 .10884 L
.59227 .10976 L
.60198 .11089 L
.61169 .11223 L
.62141 .11378 L
.63112 .11554 L
.63528 .11636 L
.64083 .11751 L
.65054 .11968 L
.66026 .12207 L
.66997 .12466 L
Mistroke
.67494 .12607 L
.67968 .12746 L
.68939 .13047 L
.69911 .13369 L
.70509 .13578 L
.70882 .13712 L
.71853 .14076 L
.72824 .14461 L
.73041 .14549 L
.73796 .14866 L
.74767 .15293 L
.75268 .15521 L
.75738 .1574 L
.76709 .16208 L
.77278 .16492 L
.77681 .16697 L
.78652 .17207 L
.79125 .17463 L
.79623 .17738 L
.80594 .1829 L
.80843 .18434 L
.81566 .18862 L
.82456 .19406 L
.82537 .19456 L
.83508 .2007 L
.83981 .20377 L
.84479 .20705 L
.85431 .21348 L
.85451 .21361 L
.86422 .22038 L
.86816 .22319 L
.87393 .22736 L
.88145 .23291 L
.88364 .23455 L
.89336 .24195 L
.89422 .24262 L
.90307 .24955 L
.90655 .25233 L
.91278 .25737 L
.91847 .26204 L
.92249 .26539 L
.93003 .27176 L
.93221 .27362 L
.94124 .28147 L
.94192 .28206 L
.95163 .29071 L
.95215 .29118 L
.96134 .29957 L
.96277 .30089 L
.97106 .30864 L
Mistroke
.97313 .31061 L
.98077 .31792 L
Mfstroke
.85 g
.01923 .49692 m
.02076 .49514 L
.02894 .48572 L
.0292 .48543 L
.03778 .47572 L
.03866 .47473 L
.04651 .46601 L
.04837 .46395 L
.05539 .45629 L
.05808 .45339 L
.06444 .44658 L
.06779 .44303 L
.07366 .43687 L
.07751 .43287 L
.08307 .42716 L
.08722 .42293 L
.09267 .41744 L
.09693 .4132 L
.10248 .40773 L
.10664 .40367 L
.11251 .39802 L
.11636 .39436 L
.12278 .38831 L
.12607 .38525 L
.13331 .37859 L
.13578 .37635 L
.14412 .36888 L
.14549 .36766 L
.15521 .35918 L
.15522 .35917 L
.16492 .35091 L
.16665 .34946 L
.17463 .34285 L
.17844 .33974 L
.18434 .33499 L
.19062 .33003 L
.19406 .32735 L
.20323 .32032 L
.20377 .31991 L
.21348 .31269 L
.21633 .31061 L
.22319 .30567 L
.22997 .30089 L
.23291 .29886 L
.24262 .29226 L
.24423 .29118 L
.25233 .28587 L
.25921 .28147 L
.26204 .27969 L
.27176 .27371 L
.27501 .27176 L
.28147 .26795 L
.29118 .26239 L
.2918 .26204 L
.30089 .25704 L
.30979 .25233 L
.31061 .25191 L
.32032 .24698 L
.32927 .24262 L
.33003 .24226 L
.33974 .23775 L
.34946 .23344 L
.3507 .23291 L
.35917 .22935 L
.36888 .22547 L
.37482 .22319 L
.37859 .22179 L
.38831 .21832 L
.39802 .21507 L
.40298 .21348 L
.40773 .21202 L
.41744 .20918 L
.42716 .20655 L
.43687 .20412 L
.43837 .20377 L
.44658 .20191 L
.45629 .19991 L
.46601 .19811 L
.47572 .19652 L
.48543 .19515 L
.49443 .19406 L
.49514 .19398 L
.50486 .19302 L
.51457 .19227 L
.52428 .19172 L
.53399 .19139 L
.54371 .19127 L
.55342 .19135 L
.56313 .19164 L
.57284 .19215 L
.58256 .19286 L
.59227 .19378 L
.59485 .19406 L
.60198 .19491 L
.61169 .19625 L
.62141 .19779 L
.63112 .19955 L
.64083 .20151 L
.65054 .20369 L
.65089 .20377 L
.66026 .20607 L
.66997 .20866 L
.67968 .21146 L
.68628 .21348 L
.68939 .21447 L
.69911 .21769 L
.70882 .22111 L
.71444 .22319 L
.71853 .22475 L
.72824 .2286 L
.73796 .23265 L
.73856 .23291 L
.74767 .23691 L
.75738 .24138 L
.75999 .24262 L
.76709 .24606 L
.77681 .25095 L
.77947 .25233 L
.78652 .25605 L
.79623 .26136 L
.79746 .26204 L
.80594 .26687 L
.81425 .27176 L
.81566 .2726 L
.82537 .27853 L
.83005 .28147 L
.83508 .28467 L
.84479 .29103 L
.84503 .29118 L
.85451 .29759 L
.85929 .30089 L
.86422 .30436 L
.87293 .31061 L
.87393 .31133 L
.88364 .31852 L
.88603 .32032 L
.89336 .32592 L
.89864 .33003 L
.90307 .33352 L
.91082 .33974 L
.91278 .34134 L
.92249 .34936 L
.92261 .34946 L
.93221 .35759 L
.93404 .35917 L
.94192 .36603 L
.94515 .36888 L
.95163 .37468 L
.95595 .37859 L
.96134 .38354 L
.96648 .38831 L
.97106 .39261 L
.97675 .39802 L
.98077 .40188 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .49692 m
.02076 .49514 L
.02894 .48572 L
.0292 .48543 L
.03778 .47572 L
.03866 .47473 L
.04651 .46601 L
.04837 .46395 L
.05539 .45629 L
.05808 .45339 L
.06444 .44658 L
.06779 .44303 L
.07366 .43687 L
.07751 .43287 L
.08307 .42716 L
.08722 .42293 L
.09267 .41744 L
.09693 .4132 L
.10248 .40773 L
.10664 .40367 L
.11251 .39802 L
.11636 .39436 L
.12278 .38831 L
.12607 .38525 L
.13331 .37859 L
.13578 .37635 L
.14412 .36888 L
.14549 .36766 L
.15521 .35918 L
.15522 .35917 L
.16492 .35091 L
.16665 .34946 L
.17463 .34285 L
.17844 .33974 L
.18434 .33499 L
.19062 .33003 L
.19406 .32735 L
.20323 .32032 L
.20377 .31991 L
.21348 .31269 L
.21633 .31061 L
.22319 .30567 L
.22997 .30089 L
.23291 .29886 L
.24262 .29226 L
.24423 .29118 L
.25233 .28587 L
.25921 .28147 L
.26204 .27969 L
.27176 .27371 L
Mistroke
.27501 .27176 L
.28147 .26795 L
.29118 .26239 L
.2918 .26204 L
.30089 .25704 L
.30979 .25233 L
.31061 .25191 L
.32032 .24698 L
.32927 .24262 L
.33003 .24226 L
.33974 .23775 L
.34946 .23344 L
.3507 .23291 L
.35917 .22935 L
.36888 .22547 L
.37482 .22319 L
.37859 .22179 L
.38831 .21832 L
.39802 .21507 L
.40298 .21348 L
.40773 .21202 L
.41744 .20918 L
.42716 .20655 L
.43687 .20412 L
.43837 .20377 L
.44658 .20191 L
.45629 .19991 L
.46601 .19811 L
.47572 .19652 L
.48543 .19515 L
.49443 .19406 L
.49514 .19398 L
.50486 .19302 L
.51457 .19227 L
.52428 .19172 L
.53399 .19139 L
.54371 .19127 L
.55342 .19135 L
.56313 .19164 L
.57284 .19215 L
.58256 .19286 L
.59227 .19378 L
.59485 .19406 L
.60198 .19491 L
.61169 .19625 L
.62141 .19779 L
.63112 .19955 L
.64083 .20151 L
.65054 .20369 L
.65089 .20377 L
Mistroke
.66026 .20607 L
.66997 .20866 L
.67968 .21146 L
.68628 .21348 L
.68939 .21447 L
.69911 .21769 L
.70882 .22111 L
.71444 .22319 L
.71853 .22475 L
.72824 .2286 L
.73796 .23265 L
.73856 .23291 L
.74767 .23691 L
.75738 .24138 L
.75999 .24262 L
.76709 .24606 L
.77681 .25095 L
.77947 .25233 L
.78652 .25605 L
.79623 .26136 L
.79746 .26204 L
.80594 .26687 L
.81425 .27176 L
.81566 .2726 L
.82537 .27853 L
.83005 .28147 L
.83508 .28467 L
.84479 .29103 L
.84503 .29118 L
.85451 .29759 L
.85929 .30089 L
.86422 .30436 L
.87293 .31061 L
.87393 .31133 L
.88364 .31852 L
.88603 .32032 L
.89336 .32592 L
.89864 .33003 L
.90307 .33352 L
.91082 .33974 L
.91278 .34134 L
.92249 .34936 L
.92261 .34946 L
.93221 .35759 L
.93404 .35917 L
.94192 .36603 L
.94515 .36888 L
.95163 .37468 L
.95595 .37859 L
.96134 .38354 L
Mistroke
.96648 .38831 L
.97106 .39261 L
.97675 .39802 L
.98077 .40188 L
Mfstroke
.925 g
.01923 .59881 m
.02488 .59227 L
.02894 .5876 L
.03338 .58256 L
.03866 .5766 L
.04202 .57284 L
.04837 .56582 L
.05081 .56313 L
.05808 .55523 L
.05977 .55342 L
.06779 .54486 L
.06889 .54371 L
.07751 .5347 L
.07819 .53399 L
.08722 .52475 L
.08768 .52428 L
.09693 .515 L
.09737 .51457 L
.10664 .50547 L
.10727 .50486 L
.11636 .49614 L
.11741 .49514 L
.12607 .48703 L
.12779 .48543 L
.13578 .47812 L
.13844 .47572 L
.14549 .46942 L
.14937 .46601 L
.15521 .46093 L
.16061 .45629 L
.16492 .45265 L
.17219 .44658 L
.17463 .44457 L
.18415 .43687 L
.18434 .43671 L
.19406 .42906 L
.19651 .42716 L
.20377 .42161 L
.20933 .41744 L
.21348 .41438 L
.22266 .40773 L
.22319 .40735 L
.23291 .40053 L
.23656 .39802 L
.24262 .39392 L
.25113 .38831 L
.25233 .38752 L
.26204 .38133 L
.26645 .37859 L
.27176 .37535 L
.28147 .36958 L
.28266 .36888 L
.29118 .36401 L
.29995 .35917 L
.30089 .35866 L
.31061 .35351 L
.31856 .34946 L
.32032 .34858 L
.33003 .34385 L
.33883 .33974 L
.33974 .33933 L
.34946 .33502 L
.35917 .33092 L
.36134 .33003 L
.36888 .32703 L
.37859 .32334 L
.38702 .32032 L
.38831 .31987 L
.39802 .31661 L
.40773 .31355 L
.41744 .3107 L
.41779 .31061 L
.42716 .30807 L
.43687 .30564 L
.44658 .30342 L
.45629 .30141 L
.45895 .30089 L
.46601 .29961 L
.47572 .29801 L
.48543 .29663 L
.49514 .29546 L
.50486 .29449 L
.51457 .29373 L
.52428 .29319 L
.53399 .29285 L
.54371 .29272 L
.55342 .2928 L
.56313 .29309 L
.57284 .29358 L
.58256 .29429 L
.59227 .29521 L
.60198 .29633 L
.61169 .29766 L
.62141 .29921 L
.63078 .30089 L
.63112 .30096 L
.64083 .30292 L
.65054 .30509 L
.66026 .30747 L
.66997 .31006 L
.67194 .31061 L
.67968 .31285 L
.68939 .31586 L
.69911 .31907 L
.70271 .32032 L
.70882 .3225 L
.71853 .32613 L
.72824 .32997 L
.72839 .33003 L
.73796 .33402 L
.74767 .33828 L
.7509 .33974 L
.75738 .34275 L
.76709 .34743 L
.77118 .34946 L
.77681 .35231 L
.78652 .35741 L
.78978 .35917 L
.79623 .36272 L
.80594 .36823 L
.80707 .36888 L
.81566 .37395 L
.82329 .37859 L
.82537 .37988 L
.83508 .38602 L
.83861 .38831 L
.84479 .39237 L
.85317 .39802 L
.85451 .39893 L
.86422 .4057 L
.86708 .40773 L
.87393 .41268 L
.8804 .41744 L
.88364 .41986 L
.89322 .42716 L
.89336 .42726 L
.90307 .43486 L
.90559 .43687 L
.91278 .44268 L
.91754 .44658 L
.92249 .4507 L
.92912 .45629 L
.93221 .45893 L
.94037 .46601 L
.94192 .46737 L
.9513 .47572 L
.95163 .47602 L
.96134 .48488 L
.96195 .48543 L
.97106 .49394 L
.97233 .49514 L
.98077 .50322 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .59881 m
.02488 .59227 L
.02894 .5876 L
.03338 .58256 L
.03866 .5766 L
.04202 .57284 L
.04837 .56582 L
.05081 .56313 L
.05808 .55523 L
.05977 .55342 L
.06779 .54486 L
.06889 .54371 L
.07751 .5347 L
.07819 .53399 L
.08722 .52475 L
.08768 .52428 L
.09693 .515 L
.09737 .51457 L
.10664 .50547 L
.10727 .50486 L
.11636 .49614 L
.11741 .49514 L
.12607 .48703 L
.12779 .48543 L
.13578 .47812 L
.13844 .47572 L
.14549 .46942 L
.14937 .46601 L
.15521 .46093 L
.16061 .45629 L
.16492 .45265 L
.17219 .44658 L
.17463 .44457 L
.18415 .43687 L
.18434 .43671 L
.19406 .42906 L
.19651 .42716 L
.20377 .42161 L
.20933 .41744 L
.21348 .41438 L
.22266 .40773 L
.22319 .40735 L
.23291 .40053 L
.23656 .39802 L
.24262 .39392 L
.25113 .38831 L
.25233 .38752 L
.26204 .38133 L
.26645 .37859 L
.27176 .37535 L
Mistroke
.28147 .36958 L
.28266 .36888 L
.29118 .36401 L
.29995 .35917 L
.30089 .35866 L
.31061 .35351 L
.31856 .34946 L
.32032 .34858 L
.33003 .34385 L
.33883 .33974 L
.33974 .33933 L
.34946 .33502 L
.35917 .33092 L
.36134 .33003 L
.36888 .32703 L
.37859 .32334 L
.38702 .32032 L
.38831 .31987 L
.39802 .31661 L
.40773 .31355 L
.41744 .3107 L
.41779 .31061 L
.42716 .30807 L
.43687 .30564 L
.44658 .30342 L
.45629 .30141 L
.45895 .30089 L
.46601 .29961 L
.47572 .29801 L
.48543 .29663 L
.49514 .29546 L
.50486 .29449 L
.51457 .29373 L
.52428 .29319 L
.53399 .29285 L
.54371 .29272 L
.55342 .2928 L
.56313 .29309 L
.57284 .29358 L
.58256 .29429 L
.59227 .29521 L
.60198 .29633 L
.61169 .29766 L
.62141 .29921 L
.63078 .30089 L
.63112 .30096 L
.64083 .30292 L
.65054 .30509 L
.66026 .30747 L
.66997 .31006 L
Mistroke
.67194 .31061 L
.67968 .31285 L
.68939 .31586 L
.69911 .31907 L
.70271 .32032 L
.70882 .3225 L
.71853 .32613 L
.72824 .32997 L
.72839 .33003 L
.73796 .33402 L
.74767 .33828 L
.7509 .33974 L
.75738 .34275 L
.76709 .34743 L
.77118 .34946 L
.77681 .35231 L
.78652 .35741 L
.78978 .35917 L
.79623 .36272 L
.80594 .36823 L
.80707 .36888 L
.81566 .37395 L
.82329 .37859 L
.82537 .37988 L
.83508 .38602 L
.83861 .38831 L
.84479 .39237 L
.85317 .39802 L
.85451 .39893 L
.86422 .4057 L
.86708 .40773 L
.87393 .41268 L
.8804 .41744 L
.88364 .41986 L
.89322 .42716 L
.89336 .42726 L
.90307 .43486 L
.90559 .43687 L
.91278 .44268 L
.91754 .44658 L
.92249 .4507 L
.92912 .45629 L
.93221 .45893 L
.94037 .46601 L
.94192 .46737 L
.9513 .47572 L
.95163 .47602 L
.96134 .48488 L
.96195 .48543 L
.97106 .49394 L
Mistroke
.97233 .49514 L
.98077 .50322 L
Mfstroke
1 g
.01923 .73865 m
.01982 .73796 L
.02822 .72824 L
.02894 .72741 L
.03675 .71853 L
.03866 .71638 L
.04543 .70882 L
.04837 .70556 L
.05426 .69911 L
.05808 .69495 L
.06325 .68939 L
.06779 .68455 L
.07241 .67968 L
.07751 .67436 L
.08176 .66997 L
.08722 .66438 L
.09129 .66026 L
.09693 .65461 L
.10103 .65054 L
.10664 .64505 L
.11099 .64083 L
.11636 .63569 L
.12119 .63112 L
.12607 .62655 L
.13163 .62141 L
.13578 .61762 L
.14235 .61169 L
.14549 .60889 L
.15335 .60198 L
.15521 .60037 L
.16468 .59227 L
.16492 .59207 L
.17463 .58397 L
.17635 .58256 L
.18434 .57608 L
.18841 .57284 L
.19406 .5684 L
.20088 .56313 L
.20377 .56093 L
.21348 .55367 L
.21383 .55342 L
.22319 .54662 L
.2273 .54371 L
.23291 .53978 L
.24136 .53399 L
.24262 .53315 L
.25233 .52673 L
.25611 .52428 L
.26204 .52051 L
.27166 .51457 L
.27176 .51451 L
.28147 .50871 L
.28814 .50486 L
.29118 .50313 L
.30089 .49775 L
.30575 .49514 L
.31061 .49259 L
.32032 .48763 L
.32476 .48543 L
.33003 .48288 L
.33974 .47834 L
.34557 .47572 L
.34946 .47401 L
.35917 .46989 L
.36882 .46601 L
.36888 .46598 L
.37859 .46228 L
.38831 .45879 L
.39563 .45629 L
.39802 .45551 L
.40773 .45243 L
.41744 .44957 L
.42716 .44691 L
.42843 .44658 L
.43687 .44447 L
.44658 .44223 L
.45629 .4402 L
.46601 .43839 L
.47514 .43687 L
.47572 .43678 L
.48543 .43538 L
.49514 .43419 L
.50486 .43321 L
.51457 .43244 L
.52428 .43188 L
.53399 .43152 L
.54371 .43138 L
.55342 .43145 L
.56313 .43172 L
.57284 .43221 L
.58256 .4329 L
.59227 .43381 L
.60198 .43492 L
.61169 .43624 L
.61584 .43687 L
.62141 .43777 L
.63112 .43951 L
.64083 .44146 L
.65054 .44362 L
.66026 .44599 L
.66255 .44658 L
.66997 .44857 L
.67968 .45136 L
.68939 .45435 L
.69535 .45629 L
.69911 .45756 L
.70882 .46098 L
.71853 .4646 L
.72216 .46601 L
.72824 .46843 L
.73796 .47248 L
.7454 .47572 L
.74767 .47673 L
.75738 .48119 L
.76622 .48543 L
.76709 .48586 L
.77681 .49074 L
.78523 .49514 L
.78652 .49583 L
.79623 .50113 L
.80284 .50486 L
.80594 .50664 L
.81566 .51236 L
.81932 .51457 L
.82537 .51828 L
.83486 .52428 L
.83508 .52442 L
.84479 .53077 L
.84961 .53399 L
.85451 .53732 L
.86368 .54371 L
.86422 .54409 L
.87393 .55106 L
.87715 .55342 L
.88364 .55824 L
.8901 .56313 L
.89336 .56563 L
.90258 .57284 L
.90307 .57324 L
.91278 .58105 L
.91463 .58256 L
.92249 .58907 L
.9263 .59227 L
.93221 .5973 L
.93763 .60198 L
.94192 .60573 L
.94864 .61169 L
.95163 .61438 L
.95935 .62141 L
.96134 .62324 L
.9698 .63112 L
.97106 .63231 L
.97999 .64083 L
.98077 .64158 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .73865 m
.01982 .73796 L
.02822 .72824 L
.02894 .72741 L
.03675 .71853 L
.03866 .71638 L
.04543 .70882 L
.04837 .70556 L
.05426 .69911 L
.05808 .69495 L
.06325 .68939 L
.06779 .68455 L
.07241 .67968 L
.07751 .67436 L
.08176 .66997 L
.08722 .66438 L
.09129 .66026 L
.09693 .65461 L
.10103 .65054 L
.10664 .64505 L
.11099 .64083 L
.11636 .63569 L
.12119 .63112 L
.12607 .62655 L
.13163 .62141 L
.13578 .61762 L
.14235 .61169 L
.14549 .60889 L
.15335 .60198 L
.15521 .60037 L
.16468 .59227 L
.16492 .59207 L
.17463 .58397 L
.17635 .58256 L
.18434 .57608 L
.18841 .57284 L
.19406 .5684 L
.20088 .56313 L
.20377 .56093 L
.21348 .55367 L
.21383 .55342 L
.22319 .54662 L
.2273 .54371 L
.23291 .53978 L
.24136 .53399 L
.24262 .53315 L
.25233 .52673 L
.25611 .52428 L
.26204 .52051 L
.27166 .51457 L
Mistroke
.27176 .51451 L
.28147 .50871 L
.28814 .50486 L
.29118 .50313 L
.30089 .49775 L
.30575 .49514 L
.31061 .49259 L
.32032 .48763 L
.32476 .48543 L
.33003 .48288 L
.33974 .47834 L
.34557 .47572 L
.34946 .47401 L
.35917 .46989 L
.36882 .46601 L
.36888 .46598 L
.37859 .46228 L
.38831 .45879 L
.39563 .45629 L
.39802 .45551 L
.40773 .45243 L
.41744 .44957 L
.42716 .44691 L
.42843 .44658 L
.43687 .44447 L
.44658 .44223 L
.45629 .4402 L
.46601 .43839 L
.47514 .43687 L
.47572 .43678 L
.48543 .43538 L
.49514 .43419 L
.50486 .43321 L
.51457 .43244 L
.52428 .43188 L
.53399 .43152 L
.54371 .43138 L
.55342 .43145 L
.56313 .43172 L
.57284 .43221 L
.58256 .4329 L
.59227 .43381 L
.60198 .43492 L
.61169 .43624 L
.61584 .43687 L
.62141 .43777 L
.63112 .43951 L
.64083 .44146 L
.65054 .44362 L
.66026 .44599 L
Mistroke
.66255 .44658 L
.66997 .44857 L
.67968 .45136 L
.68939 .45435 L
.69535 .45629 L
.69911 .45756 L
.70882 .46098 L
.71853 .4646 L
.72216 .46601 L
.72824 .46843 L
.73796 .47248 L
.7454 .47572 L
.74767 .47673 L
.75738 .48119 L
.76622 .48543 L
.76709 .48586 L
.77681 .49074 L
.78523 .49514 L
.78652 .49583 L
.79623 .50113 L
.80284 .50486 L
.80594 .50664 L
.81566 .51236 L
.81932 .51457 L
.82537 .51828 L
.83486 .52428 L
.83508 .52442 L
.84479 .53077 L
.84961 .53399 L
.85451 .53732 L
.86368 .54371 L
.86422 .54409 L
.87393 .55106 L
.87715 .55342 L
.88364 .55824 L
.8901 .56313 L
.89336 .56563 L
.90258 .57284 L
.90307 .57324 L
.91278 .58105 L
.91463 .58256 L
.92249 .58907 L
.9263 .59227 L
.93221 .5973 L
.93763 .60198 L
.94192 .60573 L
.94864 .61169 L
.95163 .61438 L
.95935 .62141 L
.96134 .62324 L
Mistroke
.9698 .63112 L
.97106 .63231 L
.97999 .64083 L
.98077 .64158 L
Mfstroke
.55 g
.01923 .27308 m
.02037 .27176 L
.02881 .26204 L
.02894 .2619 L
.0374 .25233 L
.03866 .25092 L
.04613 .24262 L
.04837 .24016 L
.05502 .23291 L
.05808 .2296 L
.06407 .22319 L
.06779 .21925 L
.0733 .21348 L
.07751 .20912 L
.08271 .20377 L
.08722 .19919 L
.09232 .19406 L
.09693 .18946 L
.10213 .18434 L
.10664 .17995 L
.11217 .17463 L
.11636 .17065 L
.12245 .16492 L
.12607 .16155 L
.13298 .15521 L
.13578 .15267 L
.14379 .14549 L
.14549 .14399 L
.1549 .13578 L
.15521 .13552 L
.16492 .12726 L
.16634 .12607 L
.17463 .11921 L
.17814 .11636 L
.18434 .11137 L
.19032 .10664 L
.19406 .10373 L
.20295 .09693 L
.20377 .09631 L
.21348 .08909 L
.21605 .08722 L
.22319 .08209 L
.2297 .07751 L
.23291 .07529 L
.24262 .0687 L
.24398 .06779 L
.25233 .06232 L
.25896 .05808 L
.26204 .05615 L
.27176 .05018 L
.27478 .04837 L
.28147 .04443 L
.29118 .03888 L
.29158 .03866 L
.30089 .03354 L
.30959 .02894 L
.31061 .02842 L
.32032 .0235 L
.32909 .01923 L
.01923 .01923 L
F
0 g
.01923 .27308 m
.02037 .27176 L
.02881 .26204 L
.02894 .2619 L
.0374 .25233 L
.03866 .25092 L
.04613 .24262 L
.04837 .24016 L
.05502 .23291 L
.05808 .2296 L
.06407 .22319 L
.06779 .21925 L
.0733 .21348 L
.07751 .20912 L
.08271 .20377 L
.08722 .19919 L
.09232 .19406 L
.09693 .18946 L
.10213 .18434 L
.10664 .17995 L
.11217 .17463 L
.11636 .17065 L
.12245 .16492 L
.12607 .16155 L
.13298 .15521 L
.13578 .15267 L
.14379 .14549 L
.14549 .14399 L
.1549 .13578 L
.15521 .13552 L
.16492 .12726 L
.16634 .12607 L
.17463 .11921 L
.17814 .11636 L
.18434 .11137 L
.19032 .10664 L
.19406 .10373 L
.20295 .09693 L
.20377 .09631 L
.21348 .08909 L
.21605 .08722 L
.22319 .08209 L
.2297 .07751 L
.23291 .07529 L
.24262 .0687 L
.24398 .06779 L
.25233 .06232 L
.25896 .05808 L
.26204 .05615 L
.27176 .05018 L
Mistroke
.27478 .04837 L
.28147 .04443 L
.29118 .03888 L
.29158 .03866 L
.30089 .03354 L
.30959 .02894 L
.31061 .02842 L
.32032 .0235 L
.32909 .01923 L
Mfstroke
.475 g
.01923 .2126 m
.02689 .20377 L
.02894 .20142 L
.03544 .19406 L
.03866 .19045 L
.04414 .18434 L
.04837 .17969 L
.053 .17463 L
.05808 .16913 L
.06201 .16492 L
.06779 .15879 L
.0712 .15521 L
.07751 .14865 L
.08057 .14549 L
.08722 .13872 L
.09014 .13578 L
.09693 .129 L
.09991 .12607 L
.10664 .11949 L
.1099 .11636 L
.11636 .11019 L
.12012 .10664 L
.12607 .1011 L
.1306 .09693 L
.13578 .09222 L
.14135 .08722 L
.14549 .08354 L
.15239 .07751 L
.15521 .07507 L
.16376 .06779 L
.16492 .06682 L
.17463 .05877 L
.17547 .05808 L
.18434 .05093 L
.18757 .04837 L
.19406 .04329 L
.20009 .03866 L
.20377 .03587 L
.21309 .02894 L
.21348 .02866 L
.22319 .02165 L
.22662 .01923 L
.01923 .01923 L
F
0 g
.01923 .2126 m
.02689 .20377 L
.02894 .20142 L
.03544 .19406 L
.03866 .19045 L
.04414 .18434 L
.04837 .17969 L
.053 .17463 L
.05808 .16913 L
.06201 .16492 L
.06779 .15879 L
.0712 .15521 L
.07751 .14865 L
.08057 .14549 L
.08722 .13872 L
.09014 .13578 L
.09693 .129 L
.09991 .12607 L
.10664 .11949 L
.1099 .11636 L
.11636 .11019 L
.12012 .10664 L
.12607 .1011 L
.1306 .09693 L
.13578 .09222 L
.14135 .08722 L
.14549 .08354 L
.15239 .07751 L
.15521 .07507 L
.16376 .06779 L
.16492 .06682 L
.17463 .05877 L
.17547 .05808 L
.18434 .05093 L
.18757 .04837 L
.19406 .04329 L
.20009 .03866 L
.20377 .03587 L
.21309 .02894 L
.21348 .02866 L
.22319 .02165 L
.22662 .01923 L
s
.4 g
.01923 .15648 m
.02033 .15521 L
.02878 .14549 L
.02894 .1453 L
.03736 .13578 L
.03866 .13433 L
.0461 .12607 L
.04837 .12357 L
.05499 .11636 L
.05808 .11302 L
.06405 .10664 L
.06779 .10268 L
.07328 .09693 L
.07751 .09254 L
.08269 .08722 L
.08722 .08262 L
.0923 .07751 L
.09693 .0729 L
.10212 .06779 L
.10664 .06339 L
.11216 .05808 L
.11636 .05409 L
.12244 .04837 L
.12607 .045 L
.13298 .03866 L
.13578 .03612 L
.1438 .02894 L
.14549 .02744 L
.15491 .01923 L
.01923 .01923 L
F
0 g
.01923 .15648 m
.02033 .15521 L
.02878 .14549 L
.02894 .1453 L
.03736 .13578 L
.03866 .13433 L
.0461 .12607 L
.04837 .12357 L
.05499 .11636 L
.05808 .11302 L
.06405 .10664 L
.06779 .10268 L
.07328 .09693 L
.07751 .09254 L
.08269 .08722 L
.08722 .08262 L
.0923 .07751 L
.09693 .0729 L
.10212 .06779 L
.10664 .06339 L
.11216 .05808 L
.11636 .05409 L
.12244 .04837 L
.12607 .045 L
.13298 .03866 L
.13578 .03612 L
.1438 .02894 L
.14549 .02744 L
.15491 .01923 L
s
.325 g
.01923 .1039 m
.02526 .09693 L
.02894 .09272 L
.03379 .08722 L
.03866 .08175 L
.04247 .07751 L
.04837 .07099 L
.05129 .06779 L
.05808 .06044 L
.06028 .05808 L
.06779 .0501 L
.06944 .04837 L
.07751 .03997 L
.07878 .03866 L
.08722 .03004 L
.08831 .02894 L
.09693 .02033 L
.09804 .01923 L
.01923 .01923 L
F
0 g
.01923 .1039 m
.02526 .09693 L
.02894 .09272 L
.03379 .08722 L
.03866 .08175 L
.04247 .07751 L
.04837 .07099 L
.05129 .06779 L
.05808 .06044 L
.06028 .05808 L
.06779 .0501 L
.06944 .04837 L
.07751 .03997 L
.07878 .03866 L
.08722 .03004 L
.08831 .02894 L
.09693 .02033 L
.09804 .01923 L
s
.25 g
.01923 .05425 m
.02432 .04837 L
.02894 .04308 L
.03284 .03866 L
.03866 .03211 L
.04149 .02894 L
.04837 .02135 L
.05031 .01923 L
.01923 .01923 L
F
0 g
.01923 .05425 m
.02432 .04837 L
.02894 .04308 L
.03284 .03866 L
.03866 .03211 L
.04149 .02894 L
.04837 .02135 L
.05031 .01923 L
s
.925 g
.71622 .98077 m
.70882 .97799 L
.69911 .97453 L
.68939 .97127 L
.68873 .97106 L
.67968 .96822 L
.66997 .96538 L
.66026 .96275 L
.65474 .96134 L
.65054 .96032 L
.64083 .9581 L
.63112 .95609 L
.62141 .95429 L
.61169 .95269 L
.6044 .95163 L
.60198 .95131 L
.59227 .95013 L
.58256 .94915 L
.57284 .94839 L
.56313 .94783 L
.55342 .94748 L
.54371 .94734 L
.53399 .94741 L
.52428 .94768 L
.51457 .94816 L
.50486 .94885 L
.49514 .94974 L
.48543 .95085 L
.47942 .95163 L
.47572 .95216 L
.46601 .95368 L
.45629 .9554 L
.44658 .95734 L
.43687 .95948 L
.42908 .96134 L
.42716 .96183 L
.41744 .96438 L
.40773 .96715 L
.39802 .97012 L
.39509 .97106 L
.38831 .9733 L
.37859 .97668 L
.36888 .98028 L
.3676 .98077 L
F
0 g
.71622 .98077 m
.70882 .97799 L
.69911 .97453 L
.68939 .97127 L
.68873 .97106 L
.67968 .96822 L
.66997 .96538 L
.66026 .96275 L
.65474 .96134 L
.65054 .96032 L
.64083 .9581 L
.63112 .95609 L
.62141 .95429 L
.61169 .95269 L
.6044 .95163 L
.60198 .95131 L
.59227 .95013 L
.58256 .94915 L
.57284 .94839 L
.56313 .94783 L
.55342 .94748 L
.54371 .94734 L
.53399 .94741 L
.52428 .94768 L
.51457 .94816 L
.50486 .94885 L
.49514 .94974 L
.48543 .95085 L
.47942 .95163 L
.47572 .95216 L
.46601 .95368 L
.45629 .9554 L
.44658 .95734 L
.43687 .95948 L
.42908 .96134 L
.42716 .96183 L
.41744 .96438 L
.40773 .96715 L
.39802 .97012 L
.39509 .97106 L
.38831 .9733 L
.37859 .97668 L
.36888 .98028 L
.3676 .98077 L
s
.55 g
.98077 .17872 m
.97652 .17463 L
.97106 .16944 L
.96624 .16492 L
.96134 .16037 L
.95571 .15521 L
.95163 .15151 L
.9449 .14549 L
.94192 .14286 L
.93379 .13578 L
.93221 .13442 L
.92249 .12619 L
.92235 .12607 L
.91278 .11817 L
.91055 .11636 L
.90307 .11035 L
.89837 .10664 L
.89336 .10275 L
.88574 .09693 L
.88364 .09535 L
.87393 .08816 L
.87264 .08722 L
.86422 .08118 L
.85899 .07751 L
.85451 .07441 L
.84479 .06785 L
.84471 .06779 L
.83508 .06149 L
.82973 .05808 L
.82537 .05535 L
.81566 .04941 L
.81391 .04837 L
.80594 .04369 L
.79711 .03866 L
.79623 .03817 L
.78652 .03286 L
.7791 .02894 L
.77681 .02776 L
.76709 .02286 L
.7596 .01923 L
.98077 .01923 L
F
0 g
.98077 .17872 m
.97652 .17463 L
.97106 .16944 L
.96624 .16492 L
.96134 .16037 L
.95571 .15521 L
.95163 .15151 L
.9449 .14549 L
.94192 .14286 L
.93379 .13578 L
.93221 .13442 L
.92249 .12619 L
.92235 .12607 L
.91278 .11817 L
.91055 .11636 L
.90307 .11035 L
.89837 .10664 L
.89336 .10275 L
.88574 .09693 L
.88364 .09535 L
.87393 .08816 L
.87264 .08722 L
.86422 .08118 L
.85899 .07751 L
.85451 .07441 L
.84479 .06785 L
.84471 .06779 L
.83508 .06149 L
.82973 .05808 L
.82537 .05535 L
.81566 .04941 L
.81391 .04837 L
.80594 .04369 L
.79711 .03866 L
.79623 .03817 L
.78652 .03286 L
.7791 .02894 L
.77681 .02776 L
.76709 .02286 L
.7596 .01923 L
s
.475 g
.98077 .11835 m
.9787 .11636 L
.97106 .10908 L
.96847 .10664 L
.96134 .10001 L
.95799 .09693 L
.95163 .09115 L
.94724 .08722 L
.94192 .0825 L
.9362 .07751 L
.93221 .07406 L
.92484 .06779 L
.92249 .06583 L
.91312 .05808 L
.91278 .0578 L
.90307 .04999 L
.90102 .04837 L
.89336 .04238 L
.8885 .03866 L
.88364 .03498 L
.8755 .02894 L
.87393 .0278 L
.86422 .02082 L
.86197 .01923 L
.98077 .01923 L
F
0 g
.98077 .11835 m
.9787 .11636 L
.97106 .10908 L
.96847 .10664 L
.96134 .10001 L
.95799 .09693 L
.95163 .09115 L
.94724 .08722 L
.94192 .0825 L
.9362 .07751 L
.93221 .07406 L
.92484 .06779 L
.92249 .06583 L
.91312 .05808 L
.91278 .0578 L
.90307 .04999 L
.90102 .04837 L
.89336 .04238 L
.8885 .03866 L
.88364 .03498 L
.8755 .02894 L
.87393 .0278 L
.86422 .02082 L
.86197 .01923 L
s
.4 g
.98077 .06233 m
.97635 .05808 L
.97106 .05305 L
.96607 .04837 L
.96134 .04398 L
.95553 .03866 L
.95163 .03512 L
.94472 .02894 L
.94192 .02647 L
.9336 .01923 L
.98077 .01923 L
F
0 g
.98077 .06233 m
.97635 .05808 L
.97106 .05305 L
.96607 .04837 L
.96134 .04398 L
.95553 .03866 L
.95163 .03512 L
.94472 .02894 L
.94192 .02647 L
.9336 .01923 L
s
0 0 0 r
.055 w
.98077 .90042 Mdot
0 1 1 r
.045 w
.01923 .90042 Mdot
.03003 .98077 Mdot
.07211 .93302 Mdot
.13859 .86419 Mdot
.25607 .76553 Mdot
.30297 .75096 Mdot
.36146 .72054 Mdot
.4609 .68601 Mdot
.50669 .68856 Mdot
.56182 .68491 Mdot
.63714 .69274 Mdot
.68666 .70923 Mdot
.76911 .73799 Mdot
.79519 .75849 Mdot
.83361 .7801 Mdot
.88258 .81359 Mdot
.91054 .83718 Mdot
.94916 .86935 Mdot
.9615 .88205 Mdot
.97812 .89757 Mdot
.98017 .89984 Mdot
.98077 .90042 Mdot
.98077 .90042 Mdot
1 0 0 r
.0325 w
.01923 .90042 Mdot
.03003 .98077 Mdot
.87724 .01923 Mdot
.17336 .81811 Mdot
.07211 .93302 Mdot
.37811 .6162 Mdot
.13859 .86419 Mdot
.25607 .76553 Mdot
.30297 .75096 Mdot
.50814 .64425 Mdot
.36146 .72054 Mdot
.4609 .68601 Mdot
.50669 .68856 Mdot
.65504 .67874 Mdot
.56182 .68491 Mdot
.63714 .69274 Mdot
.68666 .70923 Mdot
.76911 .73799 Mdot
.79519 .75849 Mdot
.90361 .81949 Mdot
.83361 .7801 Mdot
.88258 .81359 Mdot
.91054 .83718 Mdot
.94916 .86935 Mdot
.9615 .88205 Mdot
.97812 .89757 Mdot
.98017 .89984 Mdot
.98077 .90042 Mdot
.98077 .90042 Mdot
0 1 0 r
.02 w
.01923 .90042 Mdot
.03003 .98077 Mdot
.87724 .01923 Mdot
.17336 .81811 Mdot
.07211 .93302 Mdot
.37811 .6162 Mdot
.13859 .86419 Mdot
.25607 .76553 Mdot
.30297 .75096 Mdot
.50814 .64425 Mdot
.36146 .72054 Mdot
.4609 .68601 Mdot
.50669 .68856 Mdot
.65504 .67874 Mdot
.56182 .68491 Mdot
.63714 .69274 Mdot
.68666 .70923 Mdot
.76911 .73799 Mdot
.79519 .75849 Mdot
.90361 .81949 Mdot
.83361 .7801 Mdot
.88258 .81359 Mdot
.91054 .83718 Mdot
.94916 .86935 Mdot
.9615 .88205 Mdot
.97812 .89757 Mdot
.98017 .89984 Mdot
.98077 .90042 Mdot
.98077 .90042 Mdot
0 0 1 r
.5 Mabswid
.01923 .90042 m
.01923 .90042 L
.03003 .98077 L
.07211 .93302 L
.13859 .86419 L
.25607 .76553 L
.30297 .75096 L
.36146 .72054 L
.4609 .68601 L
.50669 .68856 L
.56182 .68491 L
.63714 .69274 L
.68666 .70923 L
.76911 .73799 L
.79519 .75849 L
.83361 .7801 L
.88258 .81359 L
.91054 .83718 L
.94916 .86935 L
.9615 .88205 L
.97812 .89757 L
.98017 .89984 L
.98077 .90042 L
.98077 .90042 L
s
.015 w
.01923 .90042 Mdot
.01923 .90042 Mdot
.03003 .98077 Mdot
.07211 .93302 Mdot
.13859 .86419 Mdot
.25607 .76553 Mdot
.30297 .75096 Mdot
.36146 .72054 Mdot
.4609 .68601 Mdot
.50669 .68856 Mdot
.56182 .68491 Mdot
.63714 .69274 Mdot
.68666 .70923 Mdot
.76911 .73799 Mdot
.79519 .75849 Mdot
.83361 .7801 Mdot
.88258 .81359 Mdot
.91054 .83718 Mdot
.94916 .86935 Mdot
.9615 .88205 Mdot
.97812 .89757 Mdot
.98017 .89984 Mdot
.98077 .90042 Mdot
.98077 .90042 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[20]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00;@3oool500000340oooo0P0000040?ooo`800000
103oool200000340oooo0P00000c0?ooo`800000103oool2000000@0oooo0P00000b0?ooo`D00000
103oool002l0oooo00<000000?ooo`3oool0<03oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000002l0oooo00@000000?ooo`3oool00000<@3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000003<0oooo00<000000?ooo`3oool0103oool002l0oooo00<00000
0?ooo`3oool0<03oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo02d0oooo00@0
00000?ooo`3oool00000<@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0340
oooo00<000000?ooo`3oool0103oool002L0oooo100000040?ooo`030000003oool0oooo02X0oooo
100000020?ooo`040000003oool0oooo000000T0oooo0P00000`0?ooo`040000003oool0oooo0000
0340oooo00@000000?ooo`3oool000002@3oool2000003@0oooo00<000000?ooo`3oool0103oool0
02l0oooo00<000000?ooo`3oool0<03oool010000000oooo0?ooo`0000090?ooo`030000003oool0
oooo02l0oooo00@000000?ooo`3oool00000<@3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool0103oool002h0oooo0P00000c0?ooo`8000002P3o
ool300000300oooo0P00000c0?ooo`8000002P3oool300000380oooo0P0000060?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`003`3ooooo
0000014000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo0080oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0h0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool00P3oool100000040oooo000?0?ooo`030000
003oool0oooo0>X0oooo0P3o000P0?ooo`4000000@3oool000l0oooo0P00003Y0?ooo`80o`000`00
o`000`3o0000oooo0?ooo`0K0?ooo`8000000@3oool000l0oooo00<000000?ooo`3oool0j03oool0
0`3o00000?l0003o0003003o01h0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`0:0?oo
o`8000002`3oool2000000h0oooo00<000000?ooo`3oool03`3oool2000001/0oooo00<000000?oo
o`3oool0LP3oool00`000000oooo0?ooo`0I0?ooo`80o`001@00o`000`3o0000oooo0?ooo`090?oo
o`030000003oool0oooo00l0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`L0
?clo00<0000005=CD`1CDe<02P1CDe<00`000000IVIV06IVIP0<06IVIP8000004@1iNGT00`000000
S8b<08b<S00H08b<S0<00000MP2OWil3000001P0S8b<0P3o0005003o00030?l0001iNGT0NGUi00X0
NGUi0P00000:06IVIPD0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`H0?clo
00<0000005=CD`1CDe<02P1CDe<00`000000IVIV06IVIP0<06IVIP030000001iNGT0NGUi0100NGUi
00<0000008b<S02<S8`05`2<S8`2000007`0WinO0P00000G08b<S080o`000`00o`000`3o0000NGUi
07UiN@0=07UiN@030000001VIVH0IVIV00L0IVIV1@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo1@0o?cl00`000000De=C05=CD`0;05=CD`030000001VIVH0IVIV00/0IVIV00<0
000007UiN@1iNGT03`1iNGT2000001T0S8b<00<0000009nOW`2OWil0OP2OWil2000001D0S8b<1P3o
000@07UiN@030000001VIVH0IVIV00H0IVIV1@3oool100000040oooo000?0?ooo`030000003oool0
oooo0080oooo100o?cl00`000000De=C05=CD`0:05=CD`8000003@1VIVH00`000000NGUi07UiN@0?
07UiN@030000002<S8`0S8b<01L0S8b<0P00000c09nOWa`00000=02OWil2000001D0S8b<0P3o0000
0`2<S8`0000007UiN@0@07UiN@030000001VIVH0IVIV00D0IVIV1@3oool100000040oooo000?0?oo
o`030000003oool0oooo0080oooo100o?cl00`000000De=C05=CD`0905=CD`030000001VIVH0IVIV
00`0IVIV00<0000007UiN@1iNGT03`1iNGT00`000000S8b<08b<S00F08b<S0800000;`2OWil60000
01`0/k>c2000000^09nOW`8000005`2<S8`00`000000NGUi07UiN@0?07UiN@030000001VIVH0IVIV
00@0IVIV1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo0`0o?cl00`000000
De=C05=CD`0905=CD`030000001VIVH0IVIV00`0IVIV00<0000007UiN@1iNGT03`1iNGT00`000000
S8b<08b<S00E08b<S0800000;02OWil5000002X0/k>c1P00000Z09nOW`8000005P2<S8`00`000000
NGUi07UiN@0?07UiN@800000101VIVH50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0
0P3oool203lo?`030000001CDe<0De=C00X0De=C00<0000006IVIP1VIVH02`1VIVH00`000000NGUi
07UiN@0?07UiN@030000002<S8`0S8b<01D0S8b<00<0000009nOW`2OWil09`2OWil5000003D0/k>c
0P00000Z09nOW`030000002<S8`0S8b<01@0S8b<0P00000@07UiN@030000001VIVH0IVIV0080IVIV
1@3oool100000040oooo00080?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`0303lo?`00
0000De=C00X0De=C0P00000=06IVIP030000001iNGT0NGUi00h0NGUi0P00000F08b<S08000009@2O
Wil5000003`0/k>c1@00000V09nOW`8000005P2<S8`00`000000NGUi07UiN@0>07UiN@040000001V
IVH0IVIV06IVIPD0oooo0@0000010?ooo`001`3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo0080oooo00<0000005=CD`1CDe<02@1CDe<00`000000IVIV06IVIP0;06IVIP800000
401iNGT00`000000S8b<08b<S00D08b<S0800000902OWil3000004H0/k>c0`00000U09nOW`800000
5@2<S8`2000000l0NGUi0P0000000`1VIVH0oooo0?ooo`030?ooo`4000000@3oool000T0oooo00<0
00000?ooo`3oool00`3oool300000080oooo2`1CDe<00`000000IVIV06IVIP0;06IVIP030000001i
NGT0NGUi00h0NGUi0P00000E08b<S08000008`2OWil3000004`0/k>c0`00000T09nOW`030000002<
S8`0S8b<01@0S8b<00<0000007UiN@1iNGT03P1iNGT00`000000oooo0?ooo`020?ooo`8000000@3o
ool000030?ooo`0000000000008000001@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080oooo2`1CDe<00`000000IVIV06IVIP0:06IVIP030000001iNGT0NGUi00h0NGUi00<00000
08b<S02<S8`04`2<S8`2000002<0WinO0P00001B0;>c/`8000008`2OWil2000001D0S8b<00<00000
07UiN@1iNGT03P1iNGT00`000000oooo0?ooo`020?ooo`4000000@3oool000L0oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`020?ooo`X0De=C00<0000006IVIP1VIVH02`1VIVH0
0`000000NGUi07UiN@0>07UiN@030000002<S8`0S8b<0180S8b<00<0000009nOW`2OWil0802OWil3
000005H0/k>c0`00000R09nOW`030000002<S8`0S8b<01<0S8b<00<0000007UiN@1iNGT03@1iNGT5
0?ooo`4000000@3oool000P0oooo0P0000050?ooo`030000003oool0oooo0080oooo2@1CDe<00`00
0000IVIV06IVIP0;06IVIP030000001iNGT0NGUi00d0NGUi0P00000D08b<S0030000002OWil0WinO
01h0WinO0`00001L0;>c/`<00000802OWil00`000000S8b<08b<S00C08b<S0030000001iNGT0NGUi
00`0NGUi1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo201CDe<00`000000
IVIV06IVIP0:06IVIP8000003`1iNGT00`000000S8b<08b<S00B08b<S08000007`2OWil200000680
/k>c0P00000O09nOW`800000502<S8`00`000000NGUi07UiN@0;07UiN@D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`H0De=C0P00000<06IVIP030000001iNGT0NGUi00d0NGUi
0P00000C08b<S08000007P2OWil3000006H0/k>c1000000M09nOW`8000004`2<S8`2000000/0NGUi
1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1@1CDe<00`000000IVIV06IV
IP0;06IVIP030000001iNGT0NGUi00d0NGUi00<0000008b<S02<S8`04P2<S8`00`000000WinO09nO
W`0K09nOW`<00000K@2c/k<2000001d0WinO0P00000C08b<S0030000001iNGT0NGUi00P0NGUi1@3o
ool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1@1CDe<00`000000IVIV06IVIP0;
06IVIP030000001iNGT0NGUi00`0NGUi00<0000008b<S02<S8`04P2<S8`00`000000WinO09nOW`0J
09nOW`800000LP2c/k<2000001d0WinO00<0000008b<S02<S8`04@2<S8`00`000000NGUi07UiN@07
07UiN@D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`@0De=C00<0000006IV
IP1VIVH02P1VIVH2000000h0NGUi00<0000008b<S02<S8`04P2<S8`00`000000WinO09nOW`0J09nO
W`030000002c/k<0/k>c07@0/k>c00<0000009nOW`2OWil06`2OWil00`000000S8b<08b<S00A08b<
S0030000001iNGT0NGUi00H0NGUi1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080
oooo0`1CDe<00`000000IVIV06IVIP0:06IVIP030000001iNGT0NGUi00d0NGUi00<0000008b<S02<
S8`04P2<S8`00`000000WinO09nOW`0I09nOW`800000N02c/k<2000001`0WinO0P00000B08b<S003
0000001iNGT0NGUi00D0NGUi1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
0`1CDe<00`000000IVIV06IVIP0:06IVIP030000001iNGT0NGUi00`0NGUi00<0000008b<S02<S8`0
4@2<S8`2000001X0WinO0P00001l0;>c/`800000702OWil00`000000S8b<08b<S00@08b<S0030000
001iNGT0NGUi00@0NGUi1@3oool100000040oooo000?0?ooo`8000000`3oool205=CD`030000001V
IVH0IVIV00X0IVIV00<0000007UiN@1iNGT0301iNGT00`000000S8b<08b<S00A08b<S0030000002O
Wil0WinO01P0WinO0P0000200;>c/`8000006P2OWil00`000000S8b<08b<S00A08b<S0030000001i
NGT0NGUi00<0NGUi103oool200000040oooo000?0?ooo`030000003oool0oooo0080oooo00<0De=C
0000001VIVH02P1VIVH2000000h0NGUi00<0000008b<S02<S8`04@2<S8`00`000000WinO09nOW`0G
09nOW`800000Q02c/k<2000001T0WinO0P00000B08b<S0030000001iNGT0NGUi0080NGUi1@3oool1
00000040oooo000?0?ooo`030000003oool0oooo0080oooo00<0000006IVIP1VIVH02@1VIVH00`00
0000NGUi07UiN@0=07UiN@030000002<S8`0S8b<0100S8b<0P00000H09nOW`800000R02c/k<20000
01T0WinO0P00000A08b<S08000000P1iNGT50?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool;06IVIP030000001iNGT0NGUi00`0NGUi0P00000B08b<S0030000002OWil0WinO01H0
WinO0P00000h0;>c/a`00000>02c/k<2000001T0WinO00<0000008b<S02<S8`0402<S8`00`000000
NGUi0?ooo`040?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool;06IVIP030000
001iNGT0NGUi00/0NGUi00<0000008b<S02<S8`04@2<S8`00`000000WinO09nOW`0F09nOW`030000
002c/k<0/k>c0300/k>c2000000L0<K6aPP00000<P2c/k<00`000000WinO09nOW`0G09nOW`030000
002<S8`0S8b<0100S8b<00<000000?ooo`3oool00`3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo2P1VIVH00`000000NGUi07UiN@0<07UiN@030000002<S8`0S8b<00l0S8b<0P00
000H09nOW`030000002c/k<0/k>c02/0/k>c1P00000/0<K6aPH00000;@2c/k<2000001P0WinO00<0
000008b<S02<S8`0402<S8`00`000000oooo0?ooo`020?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool906IVIP030000001iNGT0NGUi00`0NGUi00<0000008b<S02<S8`03`2<S8`0
0`000000WinO09nOW`0F09nOW`800000;02c/k<2000003P0a/K60P00000]0;>c/`8000005`2OWil0
0`000000S8b<08b<S00?08b<S0030000003oool0oooo0080oooo0@0000010?ooo`003`3oool00`00
0000oooo0?ooo`020?ooo`P0IVIV00<0000007UiN@1iNGT0301iNGT00`000000S8b<08b<S00?08b<
S0030000002OWil0WinO01H0WinO00<000000;>c/`2c/k<09`2c/k<5000003`0a/K61@00000Z0;>c
/`030000002OWil0WinO01D0WinO00<0000008b<S02<S8`03P2<S8`50?ooo`4000000@3oool000l0
oooo00<000000?ooo`3oool00P3oool706IVIP030000001iNGT0NGUi00/0NGUi0P00000A08b<S003
0000002OWil0WinO01@0WinO0`00000W0;>c/`<00000AP36a/H3000002P0/k>c0P00000F09nOW`03
0000002<S8`0S8b<00d0S8b<1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
1P1VIVH00`000000NGUi07UiN@0;07UiN@030000002<S8`0S8b<00l0S8b<0P00000F09nOW`030000
002c/k<0/k>c02D0/k>c0`00001<0<K6aP<000009`2c/k<00`000000WinO09nOW`0D09nOW`800000
3@2<S8`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool506IVIP030000001i
NGT0NGUi00/0NGUi00<0000008b<S02<S8`03`2<S8`00`000000WinO09nOW`0D09nOW`8000009@2c
/k<300000580a/K60`00000U0;>c/`8000005P2OWil00`000000S8b<08b<S00:08b<S0D0oooo0@00
00010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`@0IVIV00<0000007UiN@1iNGT0301iNGT0
0`000000S8b<08b<S00>08b<S0030000002OWil0WinO01@0WinO00<000000;>c/`2c/k<08`2c/k<2
000005P0a/K60P00000U0;>c/`030000002OWil0WinO01@0WinO0P00000:08b<S0D0oooo0@000001
0?ooo`003`3oool2000000<0oooo101VIVH00`000000NGUi07UiN@0;07UiN@030000002<S8`0S8b<
00h0S8b<00<0000009nOW`2OWil0502OWil00`000000/k>c0;>c/`0Q0;>c/`<00000G036a/H30000
02<0/k>c00<0000009nOW`2OWil05@2OWil00`000000S8b<08b<S00708b<S0@0oooo0P0000010?oo
o`003`3oool00`000000oooo0?ooo`020?ooo`<0IVIV00<0000007UiN@1iNGT02`1iNGT00`000000
S8b<08b<S00>08b<S0030000002OWil0WinO01<0WinO0P00000R0;>c/`800000HP36a/H200000280
/k>c0`00000D09nOW`030000002<S8`0S8b<00L0S8b<1@3oool100000040oooo000?0?ooo`030000
003oool0oooo0080oooo0P1VIVH00`000000NGUi07UiN@0;07UiN@030000002<S8`0S8b<00h0S8b<
00<0000009nOW`2OWil04`2OWil00`000000/k>c0;>c/`0O0;>c/`<00000IP36a/H300000280/k>c
00<0000009nOW`2OWil04P2OWil00`000000S8b<08b<S00608b<S0D0oooo0@0000010?ooo`003`3o
ool00`000000oooo0?ooo`020?ooo`0306IVIP000000NGUi00`0NGUi00<0000008b<S02<S8`03P2<
S8`00`000000WinO09nOW`0C09nOW`030000002c/k<0/k>c01h0/k>c0P00001/0<K6aP8000008@2c
/k<00`000000WinO09nOW`0B09nOW`030000002<S8`0S8b<00D0S8b<1@3oool100000040oooo000?
0?ooo`030000003oool0oooo0080oooo00<0000007UiN@1iNGT02`1iNGT00`000000S8b<08b<S00>
08b<S0030000002OWil0WinO01<0WinO00<000000;>c/`2c/k<0702c/k<300000700a/K60`00000O
0;>c/`030000002OWil0WinO0180WinO00<0000008b<S02<S8`0102<S8`50?ooo`4000000@3oool0
00l0oooo00<000000?ooo`3oool00P3oool=07UiN@030000002<S8`0S8b<00d0S8b<0P00000D09nO
W`8000007P2c/k<00`000000a/K60<K6aP1d0<K6aP8000007P2c/k<2000001<0WinO0P00000408b<
S0D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo``0NGUi00<0000008b<S02<
S8`03@2<S8`00`000000WinO09nOW`0B09nOW`8000007P2c/k<2000007T0a/K60P00000N0;>c/`03
0000002OWil0WinO0180WinO00@0000008b<S02<S8`0S8b<1@3oool100000040oooo000?0?ooo`03
0000003oool0oooo0080oooo2`1iNGT00`000000S8b<08b<S00=08b<S0030000002OWil0WinO0180
WinO00<000000;>c/`2c/k<0702c/k<2000007d0a/K600<000000;>c/`2c/k<0702c/k<00`000000
WinO09nOW`0B09nOW`80000000<0S8b<0?ooo`3oool00`3oool100000040oooo000?0?ooo`030000
003oool0oooo0080oooo2P1iNGT00`000000S8b<08b<S00=08b<S0030000002OWil0WinO01<0WinO
00<000000;>c/`2c/k<06P2c/k<200000800a/K60P00000M0;>c/`8000004`2OWil00`000000S8b<
0?ooo`040?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool907UiN@030000002<
S8`0S8b<00d0S8b<00<0000009nOW`2OWil04P2OWil2000001`0/k>c00<000000<K6aP36a/H0PP36
a/H2000001d0/k>c00<0000009nOW`2OWil04@2OWil00`000000oooo0?ooo`030?ooo`4000000@3o
ool000l0oooo00<000000?ooo`3oool00P3oool807UiN@030000002<S8`0S8b<00d0S8b<00<00000
09nOW`2OWil04P2OWil00`000000/k>c0;>c/`0I0;>c/`<00000Q`36a/H2000001`0/k>c0P00000B
09nOW`030000003oool0oooo0080oooo0@0000010?ooo`003`3oool2000000<0oooo1`1iNGT00`00
0000S8b<08b<S00=08b<S0030000002OWil0WinO0140WinO0P00000J0;>c/`800000S036a/H20000
01`0/k>c00<0000009nOW`2OWil03`2OWil40?ooo`8000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool607UiN@030000002<S8`0S8b<00d0S8b<00<0000009nOW`2OWil04@2OWil00`000000
/k>c0;>c/`0I0;>c/`0300000036a/H0a/K608h0a/K600<000000;>c/`2c/k<06P2c/k<00`000000
WinO09nOW`0>09nOW`D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`D0NGUi
00<0000008b<S02<S8`03@2<S8`00`000000WinO09nOW`0A09nOW`030000002c/k<0/k>c01T0/k>c
00<000000<K6aP36a/H0@`36a/H:000004<0a/K60P00000J0;>c/`030000002OWil0WinO00h0WinO
1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1@1iNGT00`000000S8b<08b<
S00<08b<S0030000002OWil0WinO0100WinO0P00000J0;>c/`800000>@36a/H=000000X0fMWI2`00
000j0<K6aP8000006@2c/k<2000000h0WinO1@3oool100000040oooo000?0?ooo`030000003oool0
oooo0080oooo101iNGT00`000000S8b<08b<S00<08b<S0030000002OWil0WinO0100WinO00<00000
0;>c/`2c/k<0602c/k<2000003H0a/K61@00000R0=WIf@D00000=`36a/H2000001T0/k>c00<00000
09nOW`2OWil02`2OWil50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool307Ui
N@030000002<S8`0S8b<00d0S8b<00<0000009nOW`2OWil03`2OWil00`000000/k>c0;>c/`0G0;>c
/`800000<`36a/H5000002`0fMWI1P00000c0<K6aP030000002c/k<0/k>c01L0/k>c00<0000009nO
W`2OWil02P2OWil50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool207UiN@03
0000002<S8`0S8b<00`0S8b<0P00000A09nOW`030000002c/k<0/k>c01P0/k>c00<000000<K6aP36
a/H0;`36a/H3000003L0fMWI1@00000_0<K6aP030000002c/k<0/k>c01L0/k>c00<0000009nOW`2O
Wil02@2OWil50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`1iNGT00000
08b<S00=08b<S0030000002OWil0WinO00l0WinO0P00000I0;>c/`800000;@36a/H5000003l0fMWI
0P00000^0<K6aP800000602c/k<2000000T0WinO1@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo00<0000008b<S02<S8`0302<S8`00`000000WinO09nOW`0?09nOW`030000002c
/k<0/k>c01L0/k>c0P00000[0<K6aP@00000AP3IfMT4000002`0a/K60P00000H0;>c/`030000002O
Wil0WinO00H0WinO1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo3P2<S8`0
0`000000WinO09nOW`0?09nOW`030000002c/k<0/k>c01L0/k>c00<000000<K6aP36a/H0:@36a/H2
000004h0fMWI0P00000/0<K6aP8000005`2c/k<00`000000WinO09nOW`0509nOW`D0oooo0@000001
0?ooo`003`3oool00`000000oooo0?ooo`020?ooo`d0S8b<00<0000009nOW`2OWil0402OWil00`00
0000/k>c0;>c/`0E0;>c/`800000:P36a/H200000580fMWI1000000Z0<K6aP030000002c/k<0/k>c
01D0/k>c00<0000009nOW`2OWil0102OWil50?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool<08b<S0030000002OWil0WinO00l0WinO0P00000G0;>c/`0300000036a/H0a/K602L0
a/K60`00001H0=WIf@<00000:036a/H00`000000/k>c0;>c/`0E0;>c/`030000002OWil0WinO00<0
WinO1@3oool100000040oooo000?0?ooo`8000000`3oool;08b<S0030000002OWil0WinO00l0WinO
00<000000;>c/`2c/k<05@2c/k<2000002L0a/K60`00001N0=WIf@8000009`36a/H00`000000/k>c
0;>c/`0E0;>c/`030000002OWil0WinO0080WinO103oool200000040oooo000?0?ooo`030000003o
ool0oooo0080oooo2`2<S8`00`000000WinO09nOW`0>09nOW`030000002c/k<0/k>c01D0/k>c00<0
00000<K6aP36a/H09@36a/H2000006<0fMWI00<000000<K6aP36a/H09@36a/H00`000000/k>c0;>c
/`0E0;>c/`040000002OWil0WinO09nOW`D0oooo0@0000010?ooo`003`3oool00`000000oooo0?oo
o`020?ooo`X0S8b<00<0000009nOW`2OWil03`2OWil00`000000/k>c0;>c/`0C0;>c/`8000009@36
a/H3000006H0fMWI0`00000U0<K6aP8000005P2c/k<20000000309nOW`3oool0oooo00<0oooo0@00
00010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`T0S8b<00<0000009nOW`2OWil03P2OWil2
000001D0/k>c00<000000<K6aP36a/H08P36a/H3000006`0fMWI0`00000T0<K6aP030000002c/k<0
/k>c01D0/k>c00<000000?ooo`3oool00`3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo1`2<S8`200000100WinO00<000000;>c/`2c/k<0502c/k<00`000000a/K60<K6aP0Q0<K6
aP800000LP3IfMT2000002<0a/K60P00000F0;>c/`030000003oool0oooo0080oooo0@0000010?oo
o`003`3oool00`000000oooo0?ooo`020?ooo`H0S8b<00<0000009nOW`2OWil03`2OWil00`000000
/k>c0;>c/`0D0;>c/`0300000036a/H0a/K60240a/K600<000000=WIf@3IfMT0M03IfMT2000002<0
a/K600<000000;>c/`2c/k<04`2c/k<00`000000oooo0?ooo`020?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool00P3oool608b<S0030000002OWil0WinO00h0WinO00<000000;>c/`2c/k<0
502c/k<00`000000a/K60<K6aP0P0<K6aP800000N@3IfMT200000280a/K600<000000;>c/`2c/k<0
4P2c/k<50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool508b<S0030000002O
Wil0WinO00h0WinO00<000000;>c/`2c/k<04`2c/k<200000240a/K60P00001m0=WIf@8000008@36
a/H00`000000/k>c0;>c/`0A0;>c/`D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`02
0?ooo`@0S8b<00<0000009nOW`2OWil03P2OWil00`000000/k>c0;>c/`0C0;>c/`0300000036a/H0
a/K601l0a/K60P0000210=WIf@8000008036a/H200000140/k>c1@3oool100000040oooo00070?oo
o`@00000103oool00`000000oooo0?ooo`020?ooo`@0S8b<00<0000009nOW`2OWil03@2OWil00`00
0000/k>c0;>c/`0C0;>c/`0300000036a/H0a/K601h0a/K60P0000250=WIf@8000007`36a/H00`00
0000/k>c0;>c/`0?0;>c/`D0oooo0@0000010?ooo`001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0080oooo0`2<S8`00`000000WinO09nOW`0=09nOW`030000002c/k<0/k>c01<0
/k>c00<000000<K6aP36a/H07@36a/H2000008P0fMWI0P00000O0<K6aP030000002c/k<0/k>c00h0
/k>c1@3oool100000040oooo00080?ooo`030000003oool0oooo00@0oooo0`0000020?ooo`0308b<
S0000000000000l0WinO00<000000;>c/`2c/k<04`2c/k<00`000000a/K60<K6aP0L0<K6aP800000
S03IfMT2000001h0a/K600<000000;>c/`2c/k<03@2c/k<40?ooo`8000000@3oool000030?ooo`00
0000000000800000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<0
000009nOW`2OWil03P2OWil00`000000/k>c0;>c/`0B0;>c/`8000007P36a/H00`000000fMWI0=WI
f@2>0=WIf@8000007@36a/H2000000d0/k>c1@3oool100000040oooo00070?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00P3oool00`000000WinO09nOW`0=09nOW`030000002c
/k<0/k>c0180/k>c00<000000<K6aP36a/H07036a/H2000009<0fMWI0P00000M0<K6aP030000002c
/k<0/k>c00X0/k>c1@3oool100000040oooo00080?ooo`8000001@3oool00`000000oooo0?ooo`02
0?ooo`l0WinO00<000000;>c/`2c/k<04P2c/k<00`000000a/K60<K6aP0K0<K6aP800000U`3IfMT0
0`000000a/K60<K6aP0K0<K6aP030000002c/k<0/k>c00T0/k>c1@3oool100000040oooo000?0?oo
o`030000003oool0oooo0080oooo3P2OWil00`000000/k>c0;>c/`0A0;>c/`8000007@36a/H00`00
0000fMWI0=WIf@2H0=WIf@0300000036a/H0a/K601/0a/K60P0000090;>c/`D0oooo0@0000010?oo
o`003`3oool00`000000oooo0?ooo`020?ooo`d0WinO00<000000;>c/`2c/k<04@2c/k<00`000000
a/K60<K6aP0K0<K6aP800000W03IfMT2000001d0a/K600<000000;>c/`2c/k<01P2c/k<50?ooo`40
00000@3oool000l0oooo00<000000?ooo`3oool00P3oool<09nOW`030000002c/k<0/k>c0180/k>c
00<000000<K6aP36a/H06P36a/H00`000000fMWI0=WIf@2N0=WIf@8000007036a/H00`000000/k>c
0;>c/`050;>c/`D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo``0WinO00<0
00000;>c/`2c/k<04@2c/k<00`000000a/K60<K6aP0J0<K6aP030000003IfMT0fMWI04<0fMWI6000
00150=WIf@8000006`36a/H00`000000/k>c0;>c/`050;>c/`D0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`/0WinO00<000000;>c/`2c/k<0402c/k<2000001/0a/K60P00000n
0=WIf@P00000603/k>`8000003l0fMWI0P00000J0<K6aP8000001@2c/k<50?ooo`4000000@3oool0
00l0oooo00<000000?ooo`3oool00P3oool909nOW`8000004P2c/k<00`000000a/K60<K6aP0I0<K6
aP800000>`3IfMT5000002P0k>c/1@00000l0=WIf@0300000036a/H0a/K601T0a/K600<000000;>c
/`2c/k<00P2c/k<50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool809nOW`03
0000002c/k<0/k>c0140/k>c00<000000<K6aP36a/H06036a/H2000003P0fMWI1@00000b0>c/k0D0
0000>03IfMT2000001X0a/K60P0000020;>c/`D0oooo0@0000010?ooo`003`3oool2000000<0oooo
202OWil00`000000/k>c0;>c/`0@0;>c/`0300000036a/H0a/K601P0a/K600<000000=WIf@3IfMT0
=@3IfMT3000003`0k>c/0`00000g0=WIf@0300000036a/H0a/K601T0a/K600<000000;>c/`3oool0
0`3oool200000040oooo000?0?ooo`030000003oool0oooo0080oooo1`2OWil00`000000/k>c0;>c
/`0@0;>c/`0300000036a/H0a/K601P0a/K60P00000e0=WIf@800000@P3/k>`5000003<0fMWI00<0
00000<K6aP36a/H06036a/H00`000000/k>c0?ooo`040?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool609nOW`030000002c/k<0/k>c0100/k>c00<000000<K6aP36a/H05`36a/H2
00000340fMWI1P0000190>c/k0<00000<@3IfMT2000001T0a/K600<000000?ooo`3oool00`3oool1
00000040oooo000?0?ooo`030000003oool0oooo0080oooo1@2OWil00`000000/k>c0;>c/`0@0;>c
/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0;`3IfMT200000580k>c/0`00000`0=WI
f@0300000036a/H0a/K601L0a/K600<000000?ooo`3oool00P3oool100000040oooo000?0?ooo`03
0000003oool0oooo0080oooo102OWil00`000000/k>c0;>c/`0@0;>c/`0300000036a/H0a/K601L0
a/K600<000000=WIf@3IfMT0;@3IfMT3000005L0k>c/0P00000_0=WIf@0300000036a/H0a/K601H0
a/K61@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo0`2OWil00`000000/k>c
0;>c/`0@0;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0;03IfMT2000005`0k>c/
0`00000]0=WIf@0300000036a/H0a/K601D0a/K61@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo0P2OWil00`000000/k>c0;>c/`0@0;>c/`0300000036a/H0a/K601L0a/K600<0
00000=WIf@3IfMT0:P3IfMT300000640k>c/0P00000/0=WIf@8000005@36a/H50?ooo`4000000@3o
ool000l0oooo00<000000?ooo`3oool00P3oool00`2OWil000000;>c/`0A0;>c/`0300000036a/H0
a/K601H0a/K60P00000[0=WIf@800000IP3/k>`3000002/0fMWI00<000000<K6aP36a/H04P36a/H5
0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`2OWil000000;>c/`0@0;>c
/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT0:@3IfMT2000006/0k>c/0P00000Z0=WI
f@0300000036a/H0a/K60140a/K61@3oool100000040oooo000?0?ooo`030000003oool0oooo0080
oooo00<000000;>c/`2c/k<03`2c/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI02P0
fMWI0P00001_0>c/k0030000003IfMT0fMWI02P0fMWI0P00000A0<K6aPD0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?oooa40/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI
0=WIf@0W0=WIf@800000LP3/k>`2000002X0fMWI00<000000<K6aP36a/H03P36a/H50?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool@0;>c/`0300000036a/H0a/K601D0a/K60P00
000W0=WIf@<00000MP3/k>`3000002P0fMWI00<000000<K6aP36a/H03@36a/H50?ooo`4000000@3o
ool000l0oooo0P0000030?ooo`l0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0T
0=WIf@800000O03/k>`2000002L0fMWI00<000000<K6aP36a/H03036a/H40?ooo`8000000@3oool0
00l0oooo00<000000?ooo`3oool00P3oool>0;>c/`0300000036a/H0a/K601D0a/K60P00000V0=WI
f@030000003/k>`0k>c/07h0k>c/0P00000V0=WIf@0300000036a/H0a/K600/0a/K61@3oool10000
0040oooo000?0?ooo`030000003oool0oooo0080oooo3@2c/k<00`000000a/K60<K6aP0E0<K6aP03
0000003IfMT0fMWI02@0fMWI0P0000230>c/k0030000003IfMT0fMWI02@0fMWI00<000000<K6aP36
a/H02P36a/H50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool<0;>c/`030000
0036a/H0a/K601@0a/K60P00000U0=WIf@800000QP3/k>`3000002@0fMWI0P00000:0<K6aPD0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo``0/k>c00<000000<K6aP36a/H04`36
a/H00`000000fMWI0=WIf@0T0=WIf@030000003/k>`0k>c/08T0k>c/0P00000T0=WIf@0300000036
a/H0a/K600L0a/K61@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2`2c/k<0
0`000000a/K60<K6aP0D0<K6aP030000003IfMT0fMWI0280fMWI0P00002=0>c/k0030000003IfMT0
fMWI0280fMWI00<000000<K6aP36a/H01`36a/H50?ooo`4000000@3oool000l0oooo00<000000?oo
o`3oool00P3oool90;>c/`8000005P36a/H00`000000fMWI0=WIf@0Q0=WIf@800000T03/k>`20000
02<0fMWI0P0000070<K6aPD0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`P0
/k>c00<000000<K6aP36a/H05036a/H200000280fMWI0P00002D0>c/k08000008`3IfMT00`000000
a/K60<K6aP040<K6aPD0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`P0/k>c
00<000000<K6aP36a/H04`36a/H00`000000fMWI0=WIf@0Q0=WIf@030000003/k>`0k>c/09H0k>c/
0P00000R0=WIf@0300000036a/H0a/K600<0a/K61@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo1`2c/k<00`000000a/K60<K6aP0C0<K6aP030000003IfMT0fMWI0200fMWI0P00
002K0>c/k08000008@3IfMT00`000000a/K60<K6aP020<K6aPD0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`D0/k>c0P00000E0<K6aP030000003IfMT0fMWI0200fMWI00<00000
0>c/k03/k>`0W@3/k>`00`000000fMWI0=WIf@0O0=WIf@0400000036a/H0a/K60<K6aPD0oooo0@00
00010?ooo`003`3oool2000000<0oooo1@2c/k<00`000000a/K60<K6aP0C0<K6aP030000003IfMT0
fMWI01l0fMWI0P00002Q0>c/k0030000003IfMT0fMWI01l0fMWI0P0000000`36a/H0oooo0?ooo`02
0?ooo`8000000@3oool000l0oooo00<000000?ooo`3oool00P3oool40;>c/`0300000036a/H0a/K6
01<0a/K600<000000=WIf@3IfMT07`3IfMT00`000000k>c/0>c/k02R0>c/k0800000803IfMT00`00
0000a/K60?ooo`040?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool30;>c/`80
00005036a/H00`000000fMWI0=WIf@0N0=WIf@800000Y`3/k>`00`000000fMWI0=WIf@0N0=WIf@03
0000003oool0oooo00<0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`80/k>c
00<000000<K6aP36a/H04`36a/H00`000000fMWI0=WIf@0M0=WIf@800000ZP3/k>`2000001l0fMWI
00<000000?ooo`3oool00P3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo00<0
/k>c00000036a/H05036a/H00`000000fMWI0=WIf@0M0=WIf@030000003/k>`0k>c/0:`0k>c/00<0
00000=WIf@3IfMT0703IfMT50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool0
0`000000a/K60<K6aP0C0<K6aP030000003IfMT0fMWI01d0fMWI00<000000>c/k03/k>`0[P3/k>`2
000001`0fMWI1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo5@36a/H00`00
0000fMWI0=WIf@0M0=WIf@030000003/k>`0k>c/0;40k>c/00<000000=WIf@3IfMT06@3IfMT50?oo
o`4000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolD0<K6aP030000003IfMT0fMWI01d0
fMWI00<000000>c/k03/k>`0/`3/k>`2000001T0fMWI1@3oool100000040oooo000?0?ooo`030000
003oool0oooo0080oooo4`36a/H00`000000fMWI0=WIf@0L0=WIf@800000^03/k>`00`000000fMWI
0=WIf@0F0=WIf@D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?oooa40a/K60P00
000M0=WIf@800000^`3/k>`00`000000fMWI0=WIf@0E0=WIf@D0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?oooa00a/K600<000000=WIf@3IfMT07@3IfMT00`000000k>c/0>c/k02k
0>c/k0030000003IfMT0fMWI01@0fMWI1@3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo4036a/H00`000000fMWI0=WIf@0K0=WIf@800000D@3/k>`L00000580k>c/00<000000=WI
f@3IfMT04`3IfMT50?ooo`4000000@3oool000l0oooo0P0000030?ooo`l0a/K600<000000=WIf@3I
fMT06`3IfMT00`000000k>c/0>c/k0190>c/k0P00000703oool8000004/0k>c/0P00000C0=WIf@@0
oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`h0a/K600<000000=WIf@3IfMT0
6P3IfMT2000004T0k>c/0`00000/0?ooo`H00000A`3/k>`00`000000fMWI0=WIf@0@0=WIf@D0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`d0a/K600<000000=WIf@3IfMT06P3I
fMT00`000000k>c/0>c/k0140>c/k0D00000=@3oool2000004H0k>c/00<000000=WIf@3IfMT03`3I
fMT50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool<0<K6aP030000003IfMT0
fMWI01/0fMWI00<000000>c/k03/k>`0@@3/k>`3000003`0oooo1@0000120>c/k0030000003IfMT0
fMWI00h0fMWI1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2`36a/H00`00
0000fMWI0=WIf@0J0=WIf@800000?`3/k>`5000004@0oooo0`0000100>c/k0030000003IfMT0fMWI
00d0fMWI1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2P36a/H2000001X0
fMWI0P00000n0>c/k0<00000C03oool4000003d0k>c/0P00000=0=WIf@D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?ooo`T0a/K600<000000=WIf@3IfMT06@3IfMT00`000000k>c/
0>c/k00l0>c/k0800000D`3oool00`000000k>c/0>c/k00l0>c/k0030000003IfMT0fMWI00X0fMWI
1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo2036a/H00`000000fMWI0=WI
f@0J0=WIf@030000003/k>`0k>c/03T0k>c/0`00001F0?ooo`<00000?03/k>`00`000000fMWI0=WI
f@090=WIf@D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`P0a/K600<00000
0=WIf@3IfMT0603IfMT2000003T0k>c/0`00001L0?ooo`<00000>P3/k>`2000000T0fMWI1@3oool1
00000040oooo00070?ooo`D000000`3oool00`000000oooo0?ooo`020?ooo`H0a/K60P00000J0=WI
f@030000003/k>`0k>c/03L0k>c/0P00001R0?ooo`800000>P3/k>`00`000000fMWI0=WIf@060=WI
f@D0oooo0@0000010?ooo`002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo1@36a/H00`000000fMWI0=WIf@0I0=WIf@030000003/k>`0k>c/03H0k>c/0P00001V0?ooo`80
0000>03/k>`00`000000fMWI0=WIf@060=WIf@D0oooo0@0000010?ooo`002@3oool00`000000oooo
0?ooo`030?ooo`<000000P3oool50<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`0
=03/k>`3000006X0oooo1000000e0>c/k0030000003IfMT0fMWI00D0fMWI103oool200000040oooo
00000`3oool0000000000002000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`020?ooo`@0a/K600<000000=WIf@3IfMT0603IfMT00`000000k>c/0>c/k00c0>c/k0800000L@3o
ool2000003@0k>c/0P0000050=WIf@D0oooo0@0000010?ooo`002@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo0`36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/k>`0
k>c/0380k>c/0P00001e0?ooo`800000=03/k>`00`000000fMWI0=WIf@020=WIf@D0oooo0@000001
0?ooo`00203oool2000000D0oooo00<000000?ooo`3oool00P3oool20<K6aP030000003IfMT0fMWI
01P0fMWI00<000000>c/k03/k>`0<@3/k>`2000007T0oooo0P00000c0>c/k0040000003IfMT0fMWI
0=WIf@D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`80a/K600<000000=WI
f@3IfMT05`3IfMT00`000000k>c/0>c/k00`0>c/k0800000O@3oool00`000000k>c/0>c/k00a0>c/
k0030000003IfMT0fMWI00D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`80
0000603IfMT200000380k>c/00<000000?ooo`3oool0OP3oool200000380k>c/00<000000=WIf@3o
ool0103oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo6@3IfMT00`000000k>c/
0>c/k00`0>c/k0800000P`3oool200000340k>c/00<000000?ooo`3oool00`3oool100000040oooo
000?0?ooo`030000003oool0oooo0080oooo6@3IfMT00`000000k>c/0>c/k00^0>c/k0800000Q`3o
ool00`000000k>c/0>c/k00_0>c/k0030000003oool0oooo0080oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?oooaP0fMWI00<000000>c/k03/k>`0;P3/k>`00`000000oooo0?ooo`28
0?ooo`<00000;P3/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolF0=WI
f@800000;`3/k>`2000008h0oooo00<000000>c/k03/k>`0:`3/k>`50?ooo`4000000@3oool000l0
oooo00<000000?ooo`3oool00P3ooolE0=WIf@030000003/k>`0k>c/02d0k>c/0P00002A0?ooo`80
0000:`3/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolD0=WIf@030000
003/k>`0k>c/02`0k>c/0P00002E0?ooo`800000:@3/k>`50?ooo`4000000@3oool000l0oooo0P00
00030?oooa@0fMWI00<000000>c/k03/k>`0:`3/k>`00`000000oooo0?ooo`2G0?ooo`8000009`3/
k>`40?ooo`8000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolC0=WIf@030000003/k>`0
k>c/02T0k>c/0`00002L0?ooo`030000003/k>`0k>c/02@0k>c/1@3oool100000040oooo000?0?oo
o`030000003oool0oooo0080oooo4@3IfMT2000002/0k>c/00<000000?ooo`3oool0WP3oool00`00
0000k>c/0>c/k00S0>c/k0D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?oooa00
fMWI00<000000>c/k03/k>`0:@3/k>`200000:80oooo0`00000R0>c/k0D0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`020?oooa00fMWI00<000000>c/k03/k>`0:03/k>`00`000000oooo
0?ooo`2U0?ooo`030000003/k>`0k>c/01l0k>c/1@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo3`3IfMT00`000000k>c/0>c/k00X0>c/k0030000003oool0oooo0:L0oooo00<0
00000>c/k03/k>`07P3/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool=
0=WIf@800000:P3/k>`00`000000oooo0?ooo`2Y0?ooo`8000007P3/k>`50?ooo`4000000@3oool0
00l0oooo00<000000?ooo`3oool00P3oool<0=WIf@030000003/k>`0k>c/02P0k>c/0P00002^0?oo
o`030000003/k>`0k>c/01/0k>c/1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080
oooo303IfMT00`000000k>c/0>c/k00W0>c/k0030000003oool0oooo0:l0oooo00<000000>c/k03/
k>`06P3/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool;0=WIf@030000
003/k>`0k>c/02L0k>c/00<000000?ooo`3oool0/@3oool00`000000k>c/0>c/k00I0>c/k0D0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`X0fMWI00<000000>c/k03/k>`09P3/
k>`200000;D0oooo0P00000I0>c/k0D0oooo0@0000010?ooo`003`3oool2000000<0oooo2@3IfMT0
0`000000k>c/0>c/k00U0>c/k0800000^@3oool2000001L0k>c/103oool200000040oooo000?0?oo
o`030000003oool0oooo0080oooo203IfMT00`000000k>c/0>c/k00U0>c/k0030000003oool0oooo
0;X0oooo00<000000>c/k03/k>`05@3/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool70=WIf@030000003/k>`0k>c/02H0k>c/00<000000?ooo`3oool0^`3oool2000001D0
k>c/1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo1P3IfMT00`000000k>c/
0>c/k00U0>c/k0800000`03oool00`000000k>c/0>c/k00B0>c/k0D0oooo0@0000010?ooo`003`3o
ool00`000000oooo0?ooo`020?ooo`D0fMWI00<000000>c/k03/k>`09@3/k>`00`000000oooo0?oo
o`310?ooo`8000004P3/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool4
0=WIf@030000003/k>`0k>c/02D0k>c/00<000000?ooo`3oool0a03oool00`000000k>c/0>c/k00?
0>c/k0D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`@0fMWI00<000000>c/
k03/k>`08`3/k>`200000<L0oooo00<000000>c/k03/k>`03`3/k>`50?ooo`4000000@3oool000l0
oooo00<000000?ooo`3oool00P3oool30=WIf@030000003/k>`0k>c/02<0k>c/00<000000?ooo`3o
ool0b03oool2000000l0k>c/1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo
0P3IfMT00`000000k>c/0>c/k00S0>c/k0030000003oool0oooo0</0oooo00<000000>c/k03/k>`0
303/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool00`3IfMT000000>c/
k00S0>c/k0800000c`3oool00`000000k>c/0>c/k00;0>c/k0D0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`030000003/k>`0k>c/0280k>c/00<000000?ooo`3oool0d03oool0
0`000000k>c/0>c/k00:0>c/k0D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?oo
obD0k>c/00<000000?ooo`3oool0d@3oool00`000000k>c/0>c/k0090>c/k0D0oooo0@0000010?oo
o`003`3oool2000000<0oooo8`3/k>`2000003`0oooo0P3o002G0?ooo`8000002@3/k>`40?ooo`80
00000@3oool000l0oooo00<000000?ooo`3oool00P3ooolR0>c/k0030000003oool0oooo03X0oooo
00@0o`00003o0000o`000?l00P3o002F0?ooo`030000003/k>`0k>c/00L0k>c/1@3oool100000040
oooo000?0?ooo`030000003oool0oooo0080oooo8P3/k>`00`000000oooo0?ooo`0j0?ooo`D00?l0
00<0o`000?ooo`3oool0U@3oool2000000L0k>c/1@3oool100000040oooo000?0?ooo`030000003o
ool0oooo0080oooo803/k>`2000003`0oooo00<0o`00003o0000o`000`00o`020?l009P0oooo00<0
00000>c/k03/k>`0103/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolO
0>c/k0030000003oool0oooo03`0oooo00<0o`00003o0000o`000`00o`020?l009T0oooo00<00000
0>c/k03/k>`00`3/k>`50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolN0>c/
k0030000003oool0oooo03h0oooo00@0o`00003o0000o`000?l00P3o002K0?ooo`030000003/k>`0
k>c/0080k>c/1@3oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo7@3/k>`00`00
0000oooo0?ooo`0o0?ooo`H0o`00W03oool010000000k>c/0>c/k03/k>`50?ooo`4000000@3oool0
00l0oooo00<000000?ooo`3oool00P3ooolL0>c/k0030000003oool0oooo0480oooo0P3o000Q0?oo
o`80o`00O03oool2000000030>c/k03oool0oooo00<0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`020?oooaX0k>c/0P00001V0?ooo`H0o`00O03oool00`000000oooo0?ooo`030?ooo`40
00000@3oool000l0oooo00<000000?ooo`3oool00P3ooolI0>c/k0030000003oool0oooo06H0oooo
0P3o0003003o00030?l0003oool0oooo07/0oooo00<000000?ooo`3oool00P3oool100000040oooo
000?0?ooo`030000003oool0oooo0080oooo603/k>`00`000000oooo0?ooo`1V0?ooo`80o`001@00
o`000`3o0000oooo0?ooo`1j0?ooo`030000003oool0oooo0080oooo0@0000010?ooo`003`3oool2
000000<0oooo603/k>`00`000000oooo0?ooo`1V0?ooo`80o`001@00o`000`3o0000oooo0?ooo`1n
0?ooo`8000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolF0>c/k0800000JP3oool00`3o
00000?l0003o0003003o0880oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?oooaD0
k>c/00<000000?ooo`3oool0JP3oool20?l000<00?l000<0o`000?ooo`3oool0P03oool100000040
oooo000?0?ooo`030000003oool0oooo0080oooo503/k>`00`000000oooo0?ooo`1]0?ooo`80o`00
Q03oool100000040oooo000?0?ooo`030000003oool0oooo0080oooo503/k>`00`000000oooo0?oo
o`3c0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3ooolC0>c/k0030000003oool0
oooo0640oooo0P00oolJ0?ooo`800?ooM@3oool100000040oooo000?0?ooo`030000003oool0oooo
0080oooo4@3/k>`200000640oooo2000ool80?ooo`800?oo2P3oool8003ooa@0oooo0P3o001L0?oo
o`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool@0>c/k0030000003oool0oooo0600
oooo2P00ool40?ooo`P00?oo1P3oool4003oo`80o`001000ool>0?ooo`800?oo00<0oooo0?l0003o
00000`00o`000`3o0000oooo0?ooo`1H0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0
0P3oool@0>c/k0030000003oool0oooo0600oooo1000ool20?l000@00?oo0`3oool4003oo`80o`00
1000ool50?ooo`800?oo1P3o0002003oo`/0oooo1P00ool00`3o00000?l0003o0003003o05X0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`020?ooo`l0k>c/00<000000?ooo`3oool0H@3o
ool2003oo`80o`0000@00?l00000o`000?l0o`000P00ool30?ooo`800?oo1P3o0002003oo`D0oooo
0P00ool0103o00000?l00000o`000?l20?l000800?oo2P3oool4003oo`@0o`001@00o`000`3o0000
oooo0?ooo`1G0?ooo`4000000@3oool000P0oooo0P0000050?ooo`030000003oool0oooo0080oooo
3@3/k>`2000006<0oooo0`00ool00`3o00000?l00000o`030000o`<00?oo0P3oool2003oo`040?l0
0000o`00003o0000o`80o`000P00ool20?ooo`/0003o00<0o`00003oo`00ool02@3oool2003oo`H0
o`001@00o`000`3o0000oooo0?ooo`1G0?ooo`4000000@3oool000L0oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`020?ooo``0k>c/00<000000?ooo`3oool0H`3oool2003oo`80
o`0000<00?l00000o`000?l04`000?l20?ooo`800?oo00<0o`00003o00000?l00`000?l00`3o0000
003o0000o`050000o`D0oooo0P00ool20?l00080003o00<00?l00?l0003o00000`00o`000`3o0000
oooo0?ooo`1H0?ooo`4000000@3oool000L0oooo00@000000?ooo`3oool00000103oool300000080
oooo303/k>`00`000000oooo0?ooo`1T0?ooo`05003oo`000?l0003o0000o`00o`000P000?l00`00
o`00o`00003oo`020?ooo`800?oo00<0o`00003o00000?l00`000?l20?l000800?oo103oool2003o
o`800?l00P000?l01000o`00o`00003oo`00ool50?ooo`L0003o00<0o`000000o`000?l00P000?l0
0`00o`00o`000?l000030?l000D0oooo0P00oomB0?ooo`8000000@3oool000L0oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`020?ooo`/0k>c/00<000000?ooo`3oool0H`3oool3
0000o`03003oo`3o0000o`0000<00?l000<0o`00003oo`00ool00`3oool2003oo`800?l00P000?l0
1000o`00o`00003oo`00ool50?ooo`800?oo00@0o`00003o0000o`000?l00P3o0002003oo`T0oooo
0P00ool00`3o0000003o0000o`030000o`04003o003o0000o`000?l000@0oooo2000oom@0?ooo`40
00000@3oool000L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`X0
k>c/00<000000?ooo`3oool0H@3oool30000o`80oooo0P00ool60?l000800?oo0`3oool2003oo`04
0?l00000o`000?l0003o0080o`000P00ool50?ooo`@00?oo0P3o0004003oo`X0oooo0P00ool01@3o
00000?l00000o`000?l00?l000<0003o103oool3003oo`80o`001@00oom?0?ooo`4000000@3oool0
00P0oooo0P0000050?ooo`030000003oool0oooo0080oooo2@3/k>`00`000000oooo0?ooo`1@0?oo
o`800?oo3@3oool30000o`H0oooo0`00ool20?l000<00?oo103oool4003oo`80o`001000ool60?oo
o`P00?oo2`3oool2003oo`80o`000`00o`000`3o00000?oo003oo`040000o`04003oo`3o0000o`00
003o0080003o00@0o`00003oo`00ool00?ooC`3oool100000040oooo000?0?ooo`030000003oool0
oooo0080oooo203/k>`00`000000oooo0?ooo`1>0?ooo`P00?oo1`3oool30000o``0oooo0P00ool8
0?ooo`P00?oo2P3oool2003oo`h0oooo1000ool20?l000@00?oo103oool70000o`<00?ooC`3oool1
00000040oooo000?0?ooo`030000003oool0oooo0080oooo1`3/k>`00`000000oooo0?ooo`1>0?oo
o`@00?oo0P3o0004003oo`<0oooo0`000?lL0?ooo`800?oo7P3oool8003oo`@0oooo00@00?oo0?l0
003o00000?l010000?l0103o00000?oo003oo`00oom>0?ooo`4000000@3oool000l0oooo00<00000
0?ooo`3oool00P3oool60>c/k0030000003oool0oooo04l0oooo0P00ool20?l000<00?l000<0o`00
003oo`00ool00`000?m20?ooo`800?oo1`3oool00`00ool0o`000?l00002003o00D0003o0P00oom>
0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool50>c/k0030000003oool0oooo
0500oooo0P00ool00`3o00000?l0003o00050000odl0oooo00<00?oo0?l0003o00000`00o`000`3o
00000?oo003oo`030000o`h0oooo0P00oolm0?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00P3oool50>c/k0030000003oool0oooo04l0oooo0P00ool20?l00003003o00000?l0003o0080
003o00<0o`00003oo`00ool0CP3oool00`00ool0o`000?l000040?l000<00?oo0P3oool30000o`P0
oooo2000oolj0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00P3oool40>c/k0030000
003oool0oooo0500oooo0P00ool20?l000D0003o00<0o`00003oo`00ool0CP3oool3003oo`80o`00
1@00ool50?ooo`80003o1@3oool:003oocT0oooo0@0000010?ooo`003`3oool00`000000oooo0?oo
o`020?ooo`<0k>c/00<000000?ooo`3oool0DP3oool01@00ool0003o0000o`3o00000?l00080003o
00<0o`00003oo`00ool0D03oool8003oo`P0oooo0`000?l20?ooo`@00?oo0P3o0004003oocT0oooo
0@0000010?ooo`003`3oool2000000<0oooo0P3/k>`00`000000oooo0?ooo`180?ooo`800?oo203o
ool20000o`03003oo`3o0000o`0000@0o`000P00oomC0?ooo`800?oo3P3oool30000o`03003oo`3o
0000o`000080003o00@00?l00?l00000ool00?oo>03oool200000040oooo000?0?ooo`030000003o
ool0oooo0080oooo00<0k>c/0000003oool0A`3oool8003oo`<0oooo0P000?l00`3oool00?oo003o
o`02003oo`80o`001000oomT0?ooo`800?oo1P000?l01000o`000?oo003oo`00oolh0?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`160?ooo`<00?oo0P3o
0005003oo`80003o103oool8003oofD0oooo0P00ool20?l000@0003o00<00?l00?l00000ool00`00
oolf0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0B`3oool00`00ool0o`000?l00004
0?l00003003oo`000?l0003o00T0oooo0P00oomY0?ooo`04003oo`3o0000o`00003o00@0003o00<0
o`00003oo`00ool01@00oolc0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0@P3oool2
003oo`L0oooo00@00?oo0?l0003o00000?l010000?l2003oog@0oooo0P00ool20?l000<00?l000@0
o`000000o`00ool00?oo0P3o0004003ooc80oooo0@0000010?ooo`003`3oool00`000000oooo0?oo
o`0o0?ooo`P00?oo0`3oool01000ool0o`000?l00000o`040000o`040?l00000ool00?oo003oog<0
oooo0P00ool60?l00003003oo`000?l0o`0000@0o`000P00oolb0?ooo`4000000@3oool000l0oooo
00<000000?ooo`3oool0?P3oool4003oo`80o`001000ool20?ooo`03003oo`000?l0003o00D0003o
00@0o`00003oo`00ool00?ooM03oool3003oo`80o`000`00ool01P3o0000003o0000o`000?l00?l0
0?l000800?oo<P3oool100000040oooo000?0?ooo`030000003oool0oooo03h0oooo0P00ool0103o
00000?l0003o0000o`020?l00003003oo`000?l0003o0080003o00@00?oo0?l00000o`000?l00P00
0?l01000o`000?oo003oo`00oomh0?ooo`@00?oo0P3o00040000o`04003o003o00000?oo003ooc40
oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`0n0?ooo`800?oo0P00o`050000o`05003o
o`3oool0oooo0?ooo`00ool00P3o0003003o00040?l00000ool00?oo003oogX0oooo0P00ool20?l0
00D0003o00<0o`00003oo`00ool0103oool2003oob/0oooo0@0000010?ooo`003`3oool00`000000
oooo0?ooo`0m0?ooo`800?oo00<0o`00003o00000?l00`000?l20?l000800?oo0P3oool3003oo`80
o`001@00oomk0?ooo`800?oo00@0o`00003o00000?l0003o0P00o`020000o`80oooo2000oolX0?oo
o`4000000@3oool000l0oooo00<000000?ooo`3oool0?@3oool2003oo`030?l00000o`00003o00<0
003o0P3o0002003oo`<0oooo2000ooml0?ooo`800?oo0P3o0003003o00040?l00000ool00?oo0000
o`<00?oo0P3o0005003oobL0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`0n0?ooo`80
0?oo00@0003o003o00000?l0003o0P3o0002003oo`L0oooo0P00oomo0?ooo`@00?oo0P3o0004003o
o`040?ooo`000?l0003o0?l000<00?l000@0o`00003oo`00ool00?oo9`3oool100000040oooo000?
0?ooo`800000?`3oool20000o`H0o`000P00oon90?ooo`P00?oo0P3oool00`00ool0o`000000o`03
0000o`04003o0000ool00?oo003oobH0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`0m
0?ooo`030000o`00ool00?oo00800?oo0P3o0004003ooh`0oooo0P00ool40?ooo`04003oo`3o0000
o`00003o00@0003o00@0o`00003oo`00ool00?oo9P3oool100000040oooo000?0?ooo`030000003o
ool0oooo03`0oooo00<0003o0?ooo`3oool02000oonC0?ooo`04003oo`3o0000o`00003o00@0003o
00@0o`00003oo`00ool00?oo9P3oool100000040oooo000?0?ooo`030000003oool0oooo03/0oooo
00<0003o0?ooo`3oool0103oool2003ooiL0oooo00@00?oo0?l0003o00000?l00P000?l0103o0000
003o003oo`00oolW0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0>P3oool00`000?l0
oooo0?ooo`2N0?ooo`03003oo`3o0000o`0000@0o`0000<00?oo0000o`000?l09`3oool100000040
oooo000?0?ooo`030000003oool0oooo03T0oooo00<0003o0?ooo`3oool0W`3oool3003oo`80o`00
1@00ool00`000?l0oooo0?ooo`040?ooo`800?oo7P3oool100000040oooo000?0?ooo`030000003o
ool0oooo03P0oooo00<0003o0?ooo`3oool0X@3oool8003oo`80oooo00<0003o0?ooo`3oool02000
oolK0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool0=P3oool20000ojL0oooo0P00ool6
0?ooo`80003o0`00ool20?l000@00?oo6P3oool100000040oooo000?0?ooo`030000003oool0oooo
02/0oooo0P3o00080?ooo`030000o`3oool0oooo0;00oooo00<00?oo0000o`3o00001@3o0002003o
oaX0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`0Y0?ooo`H0o`001@3oool00`000?l0
oooo0?ooo`2a0?ooo`800?oo10000?l20?l00003003oo`3o0000o`0001T0oooo0@0000010?ooo`00
3`3oool00`000000oooo0?ooo`0Y0?ooo`80o`000`00o`000`3o0000oooo0?ooo`020?ooo`030000
o`3oool0oooo0;40oooo0P00ool00`3o00000?l00000o`030000o`80o`000`00o`000`3o0000oooo
0?ooo`0E0?ooo`4000000@3oool000l0oooo0P00000Y0?ooo`80o`001@00o`00103o0000oooo0?oo
o`000?nd0?ooo`800?oo00<0o`00003o00000?l00`000?l00`3o00000?l0003o0003003o0003003o
o`3oool0oooo01<0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`0X0?ooo`80o`001@00
o`000`3o0000oooo0000o`2f0?ooo`800?oo0P00o`030000o`030?l00000o`000?l000<00?l000@0
o`00003oo`00ool00?oo4`3oool100000040oooo000?0?ooo`030000003oool0oooo02T0oooo00<0
o`00003o0000o`000`00o`000`3oool0003o0?ooo`2f0?ooo`800?oo00H0o`00003o0000o`000?l0
0?l000000?l5003o00030?l00000ool00?oo00800?oo4P3oool100000040oooo000?0?ooo`030000
003oool0oooo02T0oooo0P3o0003003o0080003o^03oool4003oo`80o`0000@00?oo0?l000000?l0
003o0P00o`000`3o00000?oo003oo`03003ooa80oooo0@0000010?ooo`003`3oool00`000000oooo
0?ooo`0[0?ooo`80o`0000<0003o0?ooo`3oool0^@3oool6003oo`<0o`0000D0003o003o00000?l0
003o0?l00003003ooa80oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`0/0?ooo`030000
o`3oool0oooo0;d0oooo0P00ool01@3oool00?oo003oo`3o00000?l000@0003o1000oolA0?ooo`40
00000@3oool000l0oooo00<000000?ooo`3oool0:`3oool00`000?l0oooo0?ooo`310?ooo`04003o
o`3o0000o`00003o00@0003o00@0o`00003oo`00ool00?oo4@3oool100000040oooo000?0?ooo`03
0000003oool0oooo02X0oooo00<0003o0?ooo`3oool0``3oool20?l000800?l00`000?l00`3o0000
0?oo003oo`0B0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool08P3oool2003oo`D0oooo
00<0003o0?ooo`3oool0a03oool00`00ool0o`000?l00003003o00040?l000000?l00?oo003ooa80
oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`0O0?ooo`P00?oo00<0oooo0000o`3oool0
aP3oool00`00ool0o`000?l000040?l00003003oo`000?l00?oo00@0oooo0P00ool<0?ooo`400000
0@3oool000l0oooo00<000000?ooo`3oool07P3oool4003oo`80o`000P00ool20000olT0oooo0P00
ool20?l000@00?oo0P000?l8003oo`T0oooo0@0000010?ooo`003`3oool2000001l0oooo0P00ool0
1P3o00000?l0003o0000o`00o`000000o`800?ooc03oool2003oo`@0oooo00@00?oo0000o`00ool0
0?oo0P3o0004003oo`L0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`0N0?ooo`800?oo
0P00o`030000o`030?l00000ool00?oo0=80oooo0P00ool00`000?l0o`000?l000030?l000800?oo
203oool100000040oooo000?0?ooo`030000003oool0oooo01d0oooo0P00ool00`3o00000?l00000
o`030000o`80o`000P00oooA0?ooo`800?oo00@0o`000000o`000?l0003o0P3o0004003oo`H0oooo
0@0000010?ooo`003`3oool00`000000oooo0?ooo`0M0?ooo`800?oo00<0o`00003o00000?l00`00
0?l20?l000800?ood03oool2003oo`030?l00000o`00003o00<0003o0P3o0004003oo`D0oooo0@00
00010?ooo`003`3oool00`000000oooo0?ooo`0N0?ooo`800?oo00@0o`000000o`000?l0003o0P3o
0002003oom40oooo0P00ool00`3o00000?l00000o`030000o`80o`001000ool50?ooo`4000000@3o
ool000l0oooo00<000000?ooo`3oool07P3oool2003oo`030000o`3o0000o`0000<0o`000P00oooB
0?ooo`800?oo0P00o`050000o`04003o003o00000?oo003oo`D0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`800?oo6P3oool01000ool0003o003oo`00ool20?l000@00?oodP3o
ool2003oo`040?l00000o`000?l0003o00@0003o00<00?l0003oo`00ool00P00ool010000000oooo
0?ooo`0000010?ooo`003`3oool00`000000oooo003oo`07003ooaL0oooo00<0003o003oo`00ool0
1P00oooC0?ooo`@00?oo0P3o00040000o`03003o003o00000?oo00D00?oo0@0000010?ooo`003`3o
ool00`0000000?oo003oo`08003ooaD0oooo00<0003o0?ooo`3oool00P3oool2003oomL0oooo0`00
ool20?l00005003o00000?l0003o0000o`00o`000`3o0005003oo`40oooo000?0?ooo`0400000000
ool00?oo003oo`80o`001@00oolD0?ooo`030000o`3oool0oooo0=h0oooo0P00ool20?l000<00?l0
00@0003o003o0000o`000?l00P3o0003003oo`40oooo00070?ooo`D000000`3oool01@0000000?oo
0?l0003o00000?l00080003o00@0o`00003oo`00ool00?oo4`3oool00`000?l0oooo0?ooo`3O0?oo
o`800?oo1@3o00000`00o`00003o0000o`020000o`040?l00000ool00?oo003oo`40oooo00090?oo
o`030000003oool0oooo00<0oooo0P00ool00`3o00000?l00000o`030000o`@00?oo4@3oool00`00
0?l0oooo0?ooo`3Q0?ooo`<00?oo0`3o00000`00o`00003o0000o`030000o`030?l00000ool00?oo
0040oooo00090?ooo`030000003oool0oooo00<0oooo00@00?oo0?l0003o00000?l010000?l0103o
00000?oo003oo`00ool@0?ooo`030000o`3oool0oooo0>@0oooo00D00000003oo`00ool0o`00003o
00050000o`030?l00000ool00?oo0040oooo00090?ooo`030000003oool0oooo00<0oooo00<00000
0?l0003o00000P00o`020000o`04003o003o00000?oo003ooa00oooo00<0003o0?ooo`3oool0i@3o
ool200000004003oo`3o0000o`00003o00<0003o00@00?l00?l00000ool00?oo0@3oool000T0oooo
00<000000?ooo`3oool00`3oool0200000000?oo0?l0003o00000?l00000o`00o`00o`000`00ool?
0?ooo`030000o`3oool0oooo0>H0oooo0P000002003oo`80o`000`00o`00103o00000?oo003oo`00
ool10?ooo`00203oool2000000D0oooo00<00000003oo`3o00000P3o00000`000?l0o`000?l00003
003oo`P0oooo0P00ool40?ooo`030000o`3oool0oooo0>L0oooo0P000002003oo`H0o`000`00ool1
0?ooo`003`3oool010000000oooo003oo`00ool20?l000040000o`00ool00?oo003oo`H0oooo2000
ool00`000?l0oooo0?ooo`3Y0?ooo`8000000`00ool20?l000@00?oo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`020?ooo`03003oo`000?l0oooo00L0oooo2000ool00`000?l00?oo0?ooo`3[
0?ooo`@000000`00ool400000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<0003o0?oo
o`3oool01P3oool4003oo`80o`0000@00?oo0000o`00ool00?ook@3oool800000040oooo0@000001
0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000o`3oool0oooo00H0oooo0P00ool00`3o
00000?l00000o`020000o`030?l00000ool00?oo0>h0oooo1P0000020?ooo`4000000@3oool000l0
oooo00<000000?ooo`3oool00`3oool00`000?l0oooo0?ooo`050?ooo`<00?oo00<00?l00000o`00
0?l00P000?l0103o00000?oo003oo`00oooe0?ooo`4000000@3oool000l0oooo00<000000?ooo`3o
ool00`3oool00`000?l0oooo0?ooo`050?ooo`800?oo00<0o`00003o00000?l00`000?l20?l00080
0?oom@3oool100000040oooo000?0?ooo`030000003oool0oooo00<0oooo00<0003o0?ooo`3oool0
1P3oool00`00ool0o`00003o00030000o`04003o003o0000o`00003oooH0oooo0@0000010?ooo`00
3`3oool2000000@0oooo00<0003o0?ooo`3oool01P3oool2003oo`040000o`00o`000?l0003o0080
o`000P00oooe0?ooo`8000000@3oool000l0oooo00<000000?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`03003oo`000?l0o`0000D0o`000P00ooof0?ooo`4000000@3oool000l0oooo00<0
00000?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`00ool00?oo0080o`000`00
oom^0?oooa`00000K@3oool100000040oooo000?0?ooo`030000003oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool010000?l0oooo0?ooo`3oool2003oofT0oooo2000000L0>c/k0H00000I`3o
ool100000040oooo000?0?ooo`030000003oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`1W0?ooo`H00000:P3/k>`500000680oooo0@0000010?ooo`003`3oool00`00
0000oooo0?ooo`040?ooo`030000o`00ool0oooo00<0oooo00<0003o0?ooo`3oool0I03oool40000
03D0k>c/1P00001L0?ooo`4000000@3oool000l0oooo00@000000?ooo`3oool0oooo0`00ool00`00
0?l00?oo003oo`02003oo`030000o`3oool0oooo0680oooo1000000n0>c/k0800000FP3oool10000
0040oooo000?0?ooo`030000003oool0oooo00@00?oo00H0003o003oo`00ool00?oo0000o`00oomQ
0?ooo`<00000A03/k>`5000005D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`04003o
o`060?l000000?l00?oo003oo`000?l00?ooGP3oool3000004`0k>c/0`00001B0?ooo`4000000@3o
ool000l0oooo00<000000?ooo`3oool00P00ool20?l00004003o00000?l0003o0000o`800?ooG03o
ool200000580k>c/0P00001@0?ooo`4000000@3oool000l0oooo00<000000?ooo`00ool00P00ool0
0`3o00000?l00000o`030000o`<00?ooF03oool3000005H0k>c/0P00001>0?ooo`4000000@3oool0
00l0oooo00@000000?ooo`00ool00?oo0P3o00000`00o`00003o0000o`020000o`030?l00000ool0
0?oo05H0oooo0P00001K0>c/k0800000C03oool100000040oooo000?0?ooo`80000000@0oooo003o
o`3o0000o`000P00o`020000o`03003o003o00000?oo0?l0oooo0P3oool200000040oooo000?0?oo
o`030000003oool0oooo00800?oo0P3o0003003o00030?l00000ool00?oo0?l0oooo0`3oool10000
0040oooo000?0?ooo`030000003oool0oooo00800?oo1P3o0002003ooa00oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`020?ooo`4000000@3oool000l0oooo00@000000?ooo`3oool0
oooo0`00ool20?l000<00?oo1@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`4000000@3oool000l0oooo
1`000002003oool00000200000010?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.37375, -3.50974, 0.00842791, \
0.0174524}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({4.9696177196758636`*^-18, {X\_1 \[Rule] 0.9999999977999193`, 
            X\_2 \[Rule] 0.9999999955638855`}}\), 
        ",", \({"Steps" \[Rule] 22, "Function" \[Rule] 29, 
          "Gradient" \[Rule] 29, "Hessian" \[Rule] 23}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell["\<\
You can see from the comparison of the two plots that the trust \
region method has kept the steps within better control as the search follows \
the valley and consequently converges with fewer function evaluations.\
\>", \
"Text"],

Cell["\<\
The following table below summarizes the options you can use with \
Newton\[CloseCurlyQuote]s method.\
\>", "Text"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[StyleBox["option name", "SO10"]]], Cell[TextData[
            StyleBox["default value", "SO10"]]], " "},
          {
            StyleBox[Cell[TextData[StyleBox["\"Hessian\"", "MR"]]],
              "MR"], 
            StyleBox["Automatic",
              "MR"], Cell[
            "An expression to use for computing the Hessian matrix. ", 
              "Text"]},
          {Cell[TextData[StyleBox["\"StepControl\"", "MR"]]], 
            StyleBox[Cell["\"LineSearch\""],
              "MR"], Cell[TextData[{
              "How to control steps. May be ",
              StyleBox["\"LineSearch\"", "MR"],
              ", ",
              StyleBox["\"TrustRegion\"", "MR"],
              ", or ",
              StyleBox["None", "MR"],
              "."
            }], "Text"]}
          }], TextForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{0.5, False}}],

Cell[TextData[{
  "Method options for ",
  StyleBox["Method\[Rule]\"Newton\"", "MR"],
  ". "
}], "Caption"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quasi-Newton Methods", "Subsection",
  CellTags->{"quasiNewton", "t:6", "c:6"}],

Cell[TextData[{
  "There are many variants of quasi-Newton methods. In all of them, the idea \
is to base the quadratic model ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  "in equation (",
  ButtonBox["1",
    ButtonData:>"QuadraticModel",
    ButtonStyle->"Hyperlink"],
  ") on an approximation of the Hessian matrix built up from the function and \
gradient values from some or all of the steps previously taken."
}], "Text"],

Cell[TextData[{
  "This shows a plot of the steps taken by the quasi-Newton method. The path \
is much less direct than for Newton\[CloseCurlyQuote]s method. The \
quasi-Newton method is used by default by ",
  StyleBox["FindMinimu", "MR"],
  "m for problems that are not sums of squares."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[
      Cos[x^2\  - \ 3\ y]\  + \ 
        Sin[x^2\  + \ y^2], {{x, 1}, {y, 1}}]\)], "Input",
  CellLabel->"In[21]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.878148 1.10621 -0.911051 0.930282 [
[.00682 -0.0125 -9 -9 ]
[.00682 -0.0125 9 0 ]
[.22807 -0.0125 -3 -9 ]
[.22807 -0.0125 3 0 ]
[.44931 -0.0125 -9 -9 ]
[.44931 -0.0125 9 0 ]
[.67055 -0.0125 -9 -9 ]
[.67055 -0.0125 9 0 ]
[.89179 -0.0125 -9 -9 ]
[.89179 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .20529 -18 -4.5 ]
[-0.0125 .20529 0 4.5 ]
[-0.0125 .39134 -18 -4.5 ]
[-0.0125 .39134 0 4.5 ]
[-0.0125 .5774 -18 -4.5 ]
[-0.0125 .5774 0 4.5 ]
[-0.0125 .76346 -18 -4.5 ]
[-0.0125 .76346 0 4.5 ]
[-0.0125 .94951 -6 -4.5 ]
[-0.0125 .94951 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00682 0 m
.00682 .00625 L
s
[(0.8)] .00682 -0.0125 0 1 Mshowa
.22807 0 m
.22807 .00625 L
s
[(1)] .22807 -0.0125 0 1 Mshowa
.44931 0 m
.44931 .00625 L
s
[(1.2)] .44931 -0.0125 0 1 Mshowa
.67055 0 m
.67055 .00625 L
s
[(1.4)] .67055 -0.0125 0 1 Mshowa
.89179 0 m
.89179 .00625 L
s
[(1.6)] .89179 -0.0125 0 1 Mshowa
.125 Mabswid
.06213 0 m
.06213 .00375 L
s
.11744 0 m
.11744 .00375 L
s
.17276 0 m
.17276 .00375 L
s
.28338 0 m
.28338 .00375 L
s
.33869 0 m
.33869 .00375 L
s
.394 0 m
.394 .00375 L
s
.50462 0 m
.50462 .00375 L
s
.55993 0 m
.55993 .00375 L
s
.61524 0 m
.61524 .00375 L
s
.72586 0 m
.72586 .00375 L
s
.78117 0 m
.78117 .00375 L
s
.83648 0 m
.83648 .00375 L
s
.9471 0 m
.9471 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(1)] -0.0125 .01923 1 0 Mshowa
0 .20529 m
.00625 .20529 L
s
[(1.2)] -0.0125 .20529 1 0 Mshowa
0 .39134 m
.00625 .39134 L
s
[(1.4)] -0.0125 .39134 1 0 Mshowa
0 .5774 m
.00625 .5774 L
s
[(1.6)] -0.0125 .5774 1 0 Mshowa
0 .76346 m
.00625 .76346 L
s
[(1.8)] -0.0125 .76346 1 0 Mshowa
0 .94951 m
.00625 .94951 L
s
[(2)] -0.0125 .94951 1 0 Mshowa
.125 Mabswid
0 .06574 m
.00375 .06574 L
s
0 .11226 m
.00375 .11226 L
s
0 .15877 m
.00375 .15877 L
s
0 .2518 m
.00375 .2518 L
s
0 .29832 m
.00375 .29832 L
s
0 .34483 m
.00375 .34483 L
s
0 .43786 m
.00375 .43786 L
s
0 .48437 m
.00375 .48437 L
s
0 .53089 m
.00375 .53089 L
s
0 .62391 m
.00375 .62391 L
s
0 .67043 m
.00375 .67043 L
s
0 .71694 m
.00375 .71694 L
s
0 .80997 m
.00375 .80997 L
s
0 .85648 m
.00375 .85648 L
s
0 .903 m
.00375 .903 L
s
0 .99603 m
.00375 .99603 L
s
.25 Mabswid
0 0 m
0 1 L
s
.00682 .99375 m
.00682 1 L
s
.22807 .99375 m
.22807 1 L
s
.44931 .99375 m
.44931 1 L
s
.67055 .99375 m
.67055 1 L
s
.89179 .99375 m
.89179 1 L
s
.125 Mabswid
.06213 .99625 m
.06213 1 L
s
.11744 .99625 m
.11744 1 L
s
.17276 .99625 m
.17276 1 L
s
.28338 .99625 m
.28338 1 L
s
.33869 .99625 m
.33869 1 L
s
.394 .99625 m
.394 1 L
s
.50462 .99625 m
.50462 1 L
s
.55993 .99625 m
.55993 1 L
s
.61524 .99625 m
.61524 1 L
s
.72586 .99625 m
.72586 1 L
s
.78117 .99625 m
.78117 1 L
s
.83648 .99625 m
.83648 1 L
s
.9471 .99625 m
.9471 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .20529 m
1 .20529 L
s
.99375 .39134 m
1 .39134 L
s
.99375 .5774 m
1 .5774 L
s
.99375 .76346 m
1 .76346 L
s
.99375 .94951 m
1 .94951 L
s
.125 Mabswid
.99625 .06574 m
1 .06574 L
s
.99625 .11226 m
1 .11226 L
s
.99625 .15877 m
1 .15877 L
s
.99625 .2518 m
1 .2518 L
s
.99625 .29832 m
1 .29832 L
s
.99625 .34483 m
1 .34483 L
s
.99625 .43786 m
1 .43786 L
s
.99625 .48437 m
1 .48437 L
s
.99625 .53089 m
1 .53089 L
s
.99625 .62391 m
1 .62391 L
s
.99625 .67043 m
1 .67043 L
s
.99625 .71694 m
1 .71694 L
s
.99625 .80997 m
1 .80997 L
s
.99625 .85648 m
1 .85648 L
s
.99625 .903 m
1 .903 L
s
.99625 .99603 m
1 .99603 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.325 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 g
.01923 .03917 m
.02894 .04224 L
.03866 .04518 L
.04837 .04799 L
.04973 .04837 L
.05808 .05067 L
.06779 .05323 L
.07751 .05568 L
.08722 .05802 L
.08746 .05808 L
.09693 .06026 L
.10664 .06241 L
.11636 .06445 L
.12607 .06641 L
.13316 .06779 L
.13578 .06829 L
.14549 .07009 L
.15521 .07181 L
.16492 .07345 L
.17463 .07503 L
.18434 .07654 L
.1908 .07751 L
.19406 .07798 L
.20377 .07937 L
.21348 .0807 L
.22319 .08197 L
.23291 .08319 L
.24262 .08435 L
.25233 .08547 L
.26204 .08654 L
.26838 .08722 L
.27176 .08757 L
.28147 .08855 L
.29118 .0895 L
.30089 .0904 L
.31061 .09126 L
.32032 .09209 L
.33003 .09288 L
.33974 .09363 L
.34946 .09436 L
.35917 .09505 L
.36888 .0957 L
.37859 .09633 L
.38831 .09693 L
.38834 .09693 L
.39802 .0975 L
.40773 .09804 L
.41744 .09855 L
.42716 .09904 L
.43687 .0995 L
.44658 .09993 L
.45629 .10034 L
.46601 .10072 L
.47572 .10108 L
.48543 .10142 L
.49514 .10173 L
.50486 .10202 L
.51457 .10228 L
.52428 .10252 L
.53399 .10274 L
.54371 .10293 L
.55342 .1031 L
.56313 .10325 L
.57284 .10337 L
.58256 .10347 L
.59227 .10355 L
.60198 .1036 L
.61169 .10362 L
.62141 .10362 L
.63112 .1036 L
.64083 .10355 L
.65054 .10347 L
.66026 .10336 L
.66997 .10323 L
.67968 .10307 L
.68939 .10287 L
.69911 .10264 L
.70882 .10238 L
.71853 .10209 L
.72824 .10175 L
.73796 .10138 L
.74767 .10097 L
.75738 .10051 L
.76709 .10001 L
.77681 .09946 L
.78652 .09886 L
.79623 .0982 L
.80594 .09748 L
.8128 .09693 L
.81566 .09669 L
.82537 .09584 L
.83508 .0949 L
.84479 .09389 L
.85451 .09278 L
.86422 .09157 L
.87393 .09024 L
.88364 .08879 L
.89329 .08722 L
.89336 .08721 L
.90307 .08546 L
.91278 .08354 L
.92249 .08142 L
.93221 .07907 L
.93811 .07751 L
.94192 .07644 L
.95163 .07351 L
.96134 .07021 L
.96777 .06779 L
.97106 .06647 L
.98077 .0622 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .03917 m
.02894 .04224 L
.03866 .04518 L
.04837 .04799 L
.04973 .04837 L
.05808 .05067 L
.06779 .05323 L
.07751 .05568 L
.08722 .05802 L
.08746 .05808 L
.09693 .06026 L
.10664 .06241 L
.11636 .06445 L
.12607 .06641 L
.13316 .06779 L
.13578 .06829 L
.14549 .07009 L
.15521 .07181 L
.16492 .07345 L
.17463 .07503 L
.18434 .07654 L
.1908 .07751 L
.19406 .07798 L
.20377 .07937 L
.21348 .0807 L
.22319 .08197 L
.23291 .08319 L
.24262 .08435 L
.25233 .08547 L
.26204 .08654 L
.26838 .08722 L
.27176 .08757 L
.28147 .08855 L
.29118 .0895 L
.30089 .0904 L
.31061 .09126 L
.32032 .09209 L
.33003 .09288 L
.33974 .09363 L
.34946 .09436 L
.35917 .09505 L
.36888 .0957 L
.37859 .09633 L
.38831 .09693 L
.38834 .09693 L
.39802 .0975 L
.40773 .09804 L
.41744 .09855 L
.42716 .09904 L
.43687 .0995 L
Mistroke
.44658 .09993 L
.45629 .10034 L
.46601 .10072 L
.47572 .10108 L
.48543 .10142 L
.49514 .10173 L
.50486 .10202 L
.51457 .10228 L
.52428 .10252 L
.53399 .10274 L
.54371 .10293 L
.55342 .1031 L
.56313 .10325 L
.57284 .10337 L
.58256 .10347 L
.59227 .10355 L
.60198 .1036 L
.61169 .10362 L
.62141 .10362 L
.63112 .1036 L
.64083 .10355 L
.65054 .10347 L
.66026 .10336 L
.66997 .10323 L
.67968 .10307 L
.68939 .10287 L
.69911 .10264 L
.70882 .10238 L
.71853 .10209 L
.72824 .10175 L
.73796 .10138 L
.74767 .10097 L
.75738 .10051 L
.76709 .10001 L
.77681 .09946 L
.78652 .09886 L
.79623 .0982 L
.80594 .09748 L
.8128 .09693 L
.81566 .09669 L
.82537 .09584 L
.83508 .0949 L
.84479 .09389 L
.85451 .09278 L
.86422 .09157 L
.87393 .09024 L
.88364 .08879 L
.89329 .08722 L
.89336 .08721 L
.90307 .08546 L
Mistroke
.91278 .08354 L
.92249 .08142 L
.93221 .07907 L
.93811 .07751 L
.94192 .07644 L
.95163 .07351 L
.96134 .07021 L
.96777 .06779 L
.97106 .06647 L
.98077 .0622 L
Mfstroke
.475 g
.01923 .15177 m
.02894 .15165 L
.03866 .15154 L
.04837 .15143 L
.05808 .15133 L
.06779 .15123 L
.07751 .15114 L
.08722 .15105 L
.09693 .15097 L
.10664 .1509 L
.11636 .15083 L
.12607 .15076 L
.13578 .15069 L
.14549 .15063 L
.15521 .15057 L
.16492 .15052 L
.17463 .15046 L
.18434 .15041 L
.19406 .15036 L
.20377 .15032 L
.21348 .15027 L
.22319 .15023 L
.23291 .15019 L
.24262 .15015 L
.25233 .15012 L
.26204 .15008 L
.27176 .15005 L
.28147 .15002 L
.29118 .14999 L
.30089 .14996 L
.31061 .14993 L
.32032 .1499 L
.33003 .14988 L
.33974 .14986 L
.34946 .14983 L
.35917 .14981 L
.36888 .14979 L
.37859 .14977 L
.38831 .14975 L
.39802 .14973 L
.40773 .14972 L
.41744 .1497 L
.42716 .14968 L
.43687 .14967 L
.44658 .14966 L
.45629 .14964 L
.46601 .14963 L
.47572 .14962 L
.48543 .14961 L
.49514 .1496 L
.50486 .14959 L
.51457 .14958 L
.52428 .14957 L
.53399 .14957 L
.54371 .14956 L
.55342 .14955 L
.56313 .14955 L
.57284 .14954 L
.58256 .14954 L
.59227 .14954 L
.60198 .14954 L
.61169 .14953 L
.62141 .14953 L
.63112 .14953 L
.64083 .14954 L
.65054 .14954 L
.66026 .14954 L
.66997 .14954 L
.67968 .14955 L
.68939 .14955 L
.69911 .14956 L
.70882 .14956 L
.71853 .14957 L
.72824 .14958 L
.73796 .14959 L
.74767 .1496 L
.75738 .14962 L
.76709 .14963 L
.77681 .14964 L
.78652 .14966 L
.79623 .14968 L
.80594 .1497 L
.81566 .14972 L
.82537 .14974 L
.83508 .14977 L
.84479 .14979 L
.85451 .14982 L
.86422 .14986 L
.87393 .14989 L
.88364 .14993 L
.89336 .14997 L
.90307 .15002 L
.91278 .15007 L
.92249 .15012 L
.93221 .15018 L
.94192 .15025 L
.95163 .15032 L
.96134 .1504 L
.97106 .15049 L
.98077 .15059 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .15177 m
.02894 .15165 L
.03866 .15154 L
.04837 .15143 L
.05808 .15133 L
.06779 .15123 L
.07751 .15114 L
.08722 .15105 L
.09693 .15097 L
.10664 .1509 L
.11636 .15083 L
.12607 .15076 L
.13578 .15069 L
.14549 .15063 L
.15521 .15057 L
.16492 .15052 L
.17463 .15046 L
.18434 .15041 L
.19406 .15036 L
.20377 .15032 L
.21348 .15027 L
.22319 .15023 L
.23291 .15019 L
.24262 .15015 L
.25233 .15012 L
.26204 .15008 L
.27176 .15005 L
.28147 .15002 L
.29118 .14999 L
.30089 .14996 L
.31061 .14993 L
.32032 .1499 L
.33003 .14988 L
.33974 .14986 L
.34946 .14983 L
.35917 .14981 L
.36888 .14979 L
.37859 .14977 L
.38831 .14975 L
.39802 .14973 L
.40773 .14972 L
.41744 .1497 L
.42716 .14968 L
.43687 .14967 L
.44658 .14966 L
.45629 .14964 L
.46601 .14963 L
.47572 .14962 L
.48543 .14961 L
.49514 .1496 L
Mistroke
.50486 .14959 L
.51457 .14958 L
.52428 .14957 L
.53399 .14957 L
.54371 .14956 L
.55342 .14955 L
.56313 .14955 L
.57284 .14954 L
.58256 .14954 L
.59227 .14954 L
.60198 .14954 L
.61169 .14953 L
.62141 .14953 L
.63112 .14953 L
.64083 .14954 L
.65054 .14954 L
.66026 .14954 L
.66997 .14954 L
.67968 .14955 L
.68939 .14955 L
.69911 .14956 L
.70882 .14956 L
.71853 .14957 L
.72824 .14958 L
.73796 .14959 L
.74767 .1496 L
.75738 .14962 L
.76709 .14963 L
.77681 .14964 L
.78652 .14966 L
.79623 .14968 L
.80594 .1497 L
.81566 .14972 L
.82537 .14974 L
.83508 .14977 L
.84479 .14979 L
.85451 .14982 L
.86422 .14986 L
.87393 .14989 L
.88364 .14993 L
.89336 .14997 L
.90307 .15002 L
.91278 .15007 L
.92249 .15012 L
.93221 .15018 L
.94192 .15025 L
.95163 .15032 L
.96134 .1504 L
.97106 .15049 L
.98077 .15059 L
Mistroke
Mfstroke
.55 g
.01923 .28797 m
.02894 .28189 L
.02965 .28147 L
.03866 .27633 L
.04735 .27176 L
.04837 .27124 L
.05808 .26655 L
.06779 .26222 L
.0682 .26204 L
.07751 .2582 L
.08722 .25447 L
.09312 .25233 L
.09693 .25099 L
.10664 .24775 L
.11636 .24471 L
.12342 .24262 L
.12607 .24186 L
.13578 .23918 L
.14549 .23666 L
.15521 .23429 L
.16112 .23291 L
.16492 .23205 L
.17463 .22993 L
.18434 .22793 L
.19406 .22603 L
.20377 .22423 L
.20963 .22319 L
.21348 .22253 L
.22319 .22091 L
.23291 .21937 L
.24262 .21791 L
.25233 .21652 L
.26204 .2152 L
.27176 .21394 L
.27538 .21348 L
.28147 .21274 L
.29118 .21159 L
.30089 .2105 L
.31061 .20947 L
.32032 .20848 L
.33003 .20754 L
.33974 .20664 L
.34946 .20578 L
.35917 .20497 L
.36888 .20419 L
.37442 .20377 L
.37859 .20346 L
.38831 .20275 L
.39802 .20209 L
.40773 .20145 L
.41744 .20085 L
.42716 .20029 L
.43687 .19975 L
.44658 .19924 L
.45629 .19876 L
.46601 .19831 L
.47572 .19789 L
.48543 .19749 L
.49514 .19712 L
.50486 .19678 L
.51457 .19646 L
.52428 .19617 L
.53399 .1959 L
.54371 .19566 L
.55342 .19545 L
.56313 .19525 L
.57284 .19509 L
.58256 .19495 L
.59227 .19483 L
.60198 .19474 L
.61169 .19467 L
.62141 .19463 L
.63112 .19462 L
.64083 .19463 L
.65054 .19467 L
.66026 .19474 L
.66997 .19484 L
.67968 .19496 L
.68939 .19512 L
.69911 .1953 L
.70882 .19552 L
.71853 .19577 L
.72824 .19606 L
.73796 .19638 L
.74767 .19675 L
.75738 .19715 L
.76709 .19759 L
.77681 .19808 L
.78652 .19861 L
.79623 .1992 L
.80594 .19984 L
.81566 .20053 L
.82537 .20129 L
.83508 .20211 L
.84479 .203 L
.85254 .20377 L
.85451 .20397 L
.86422 .20502 L
.87393 .20616 L
.88364 .2074 L
.89336 .20875 L
.90307 .21021 L
.91278 .2118 L
.92217 .21348 L
.92249 .21354 L
.93221 .21544 L
.94192 .21751 L
.95163 .21979 L
.96134 .22229 L
.96463 .22319 L
.97106 .22505 L
.98077 .2281 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .28797 m
.02894 .28189 L
.02965 .28147 L
.03866 .27633 L
.04735 .27176 L
.04837 .27124 L
.05808 .26655 L
.06779 .26222 L
.0682 .26204 L
.07751 .2582 L
.08722 .25447 L
.09312 .25233 L
.09693 .25099 L
.10664 .24775 L
.11636 .24471 L
.12342 .24262 L
.12607 .24186 L
.13578 .23918 L
.14549 .23666 L
.15521 .23429 L
.16112 .23291 L
.16492 .23205 L
.17463 .22993 L
.18434 .22793 L
.19406 .22603 L
.20377 .22423 L
.20963 .22319 L
.21348 .22253 L
.22319 .22091 L
.23291 .21937 L
.24262 .21791 L
.25233 .21652 L
.26204 .2152 L
.27176 .21394 L
.27538 .21348 L
.28147 .21274 L
.29118 .21159 L
.30089 .2105 L
.31061 .20947 L
.32032 .20848 L
.33003 .20754 L
.33974 .20664 L
.34946 .20578 L
.35917 .20497 L
.36888 .20419 L
.37442 .20377 L
.37859 .20346 L
.38831 .20275 L
.39802 .20209 L
.40773 .20145 L
Mistroke
.41744 .20085 L
.42716 .20029 L
.43687 .19975 L
.44658 .19924 L
.45629 .19876 L
.46601 .19831 L
.47572 .19789 L
.48543 .19749 L
.49514 .19712 L
.50486 .19678 L
.51457 .19646 L
.52428 .19617 L
.53399 .1959 L
.54371 .19566 L
.55342 .19545 L
.56313 .19525 L
.57284 .19509 L
.58256 .19495 L
.59227 .19483 L
.60198 .19474 L
.61169 .19467 L
.62141 .19463 L
.63112 .19462 L
.64083 .19463 L
.65054 .19467 L
.66026 .19474 L
.66997 .19484 L
.67968 .19496 L
.68939 .19512 L
.69911 .1953 L
.70882 .19552 L
.71853 .19577 L
.72824 .19606 L
.73796 .19638 L
.74767 .19675 L
.75738 .19715 L
.76709 .19759 L
.77681 .19808 L
.78652 .19861 L
.79623 .1992 L
.80594 .19984 L
.81566 .20053 L
.82537 .20129 L
.83508 .20211 L
.84479 .203 L
.85254 .20377 L
.85451 .20397 L
.86422 .20502 L
.87393 .20616 L
.88364 .2074 L
Mistroke
.89336 .20875 L
.90307 .21021 L
.91278 .2118 L
.92217 .21348 L
.92249 .21354 L
.93221 .21544 L
.94192 .21751 L
.95163 .21979 L
.96134 .22229 L
.96463 .22319 L
.97106 .22505 L
.98077 .2281 L
Mfstroke
.625 g
.01923 .47442 m
.0233 .46601 L
.02831 .45629 L
.02894 .45511 L
.03369 .44658 L
.03866 .4382 L
.03947 .43687 L
.04571 .42716 L
.04837 .42323 L
.05245 .41744 L
.05808 .40988 L
.05975 .40773 L
.06768 .39802 L
.06779 .39789 L
.07632 .38831 L
.07751 .38704 L
.08578 .37859 L
.08722 .37719 L
.09615 .36888 L
.09693 .36819 L
.10664 .35994 L
.10759 .35917 L
.11636 .35233 L
.12025 .34946 L
.12607 .34531 L
.13433 .33974 L
.13578 .3388 L
.14549 .33275 L
.1501 .33003 L
.15521 .32712 L
.16492 .32185 L
.16787 .32032 L
.17463 .31692 L
.18434 .3123 L
.18807 .31061 L
.19406 .30796 L
.20377 .30388 L
.21126 .30089 L
.21348 .30003 L
.22319 .2964 L
.23291 .29298 L
.23822 .29118 L
.24262 .28974 L
.25233 .28667 L
.26204 .28376 L
.2701 .28147 L
.27176 .28101 L
.28147 .2784 L
.29118 .27592 L
.30089 .27357 L
.30872 .27176 L
.31061 .27133 L
.32032 .26921 L
.33003 .26719 L
.33974 .26527 L
.34946 .26345 L
.35728 .26204 L
.35917 .26171 L
.36888 .26007 L
.37859 .2585 L
.38831 .25702 L
.39802 .25561 L
.40773 .25427 L
.41744 .25301 L
.42287 .25233 L
.42716 .25181 L
.43687 .25068 L
.44658 .24961 L
.45629 .2486 L
.46601 .24765 L
.47572 .24676 L
.48543 .24593 L
.49514 .24515 L
.50486 .24442 L
.51457 .24375 L
.52428 .24313 L
.53309 .24262 L
.53399 .24257 L
.54371 .24205 L
.55342 .24159 L
.56313 .24117 L
.57284 .24081 L
.58256 .2405 L
.59227 .24024 L
.60198 .24002 L
.61169 .23986 L
.62141 .23975 L
.63112 .2397 L
.64083 .23969 L
.65054 .23974 L
.66026 .23984 L
.66997 .24 L
.67968 .24022 L
.68939 .24049 L
.69911 .24083 L
.70882 .24123 L
.71853 .24169 L
.72824 .24222 L
.73472 .24262 L
.73796 .24283 L
.74767 .2435 L
.75738 .24426 L
.76709 .2451 L
.77681 .24602 L
.78652 .24703 L
.79623 .24814 L
.80594 .24935 L
.81566 .25067 L
.82537 .25211 L
.82677 .25233 L
.83508 .25368 L
.84479 .25538 L
.85451 .25722 L
.86422 .25922 L
.87393 .2614 L
.87666 .26204 L
.88364 .26376 L
.89336 .26633 L
.90307 .26912 L
.91154 .27176 L
.91278 .27216 L
.92249 .27548 L
.93221 .2791 L
.93813 .28147 L
.94192 .28306 L
.95163 .28741 L
.95938 .29118 L
.96134 .29219 L
.97106 .29746 L
.97688 .30089 L
.98077 .30331 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .47442 m
.0233 .46601 L
.02831 .45629 L
.02894 .45511 L
.03369 .44658 L
.03866 .4382 L
.03947 .43687 L
.04571 .42716 L
.04837 .42323 L
.05245 .41744 L
.05808 .40988 L
.05975 .40773 L
.06768 .39802 L
.06779 .39789 L
.07632 .38831 L
.07751 .38704 L
.08578 .37859 L
.08722 .37719 L
.09615 .36888 L
.09693 .36819 L
.10664 .35994 L
.10759 .35917 L
.11636 .35233 L
.12025 .34946 L
.12607 .34531 L
.13433 .33974 L
.13578 .3388 L
.14549 .33275 L
.1501 .33003 L
.15521 .32712 L
.16492 .32185 L
.16787 .32032 L
.17463 .31692 L
.18434 .3123 L
.18807 .31061 L
.19406 .30796 L
.20377 .30388 L
.21126 .30089 L
.21348 .30003 L
.22319 .2964 L
.23291 .29298 L
.23822 .29118 L
.24262 .28974 L
.25233 .28667 L
.26204 .28376 L
.2701 .28147 L
.27176 .28101 L
.28147 .2784 L
.29118 .27592 L
.30089 .27357 L
Mistroke
.30872 .27176 L
.31061 .27133 L
.32032 .26921 L
.33003 .26719 L
.33974 .26527 L
.34946 .26345 L
.35728 .26204 L
.35917 .26171 L
.36888 .26007 L
.37859 .2585 L
.38831 .25702 L
.39802 .25561 L
.40773 .25427 L
.41744 .25301 L
.42287 .25233 L
.42716 .25181 L
.43687 .25068 L
.44658 .24961 L
.45629 .2486 L
.46601 .24765 L
.47572 .24676 L
.48543 .24593 L
.49514 .24515 L
.50486 .24442 L
.51457 .24375 L
.52428 .24313 L
.53309 .24262 L
.53399 .24257 L
.54371 .24205 L
.55342 .24159 L
.56313 .24117 L
.57284 .24081 L
.58256 .2405 L
.59227 .24024 L
.60198 .24002 L
.61169 .23986 L
.62141 .23975 L
.63112 .2397 L
.64083 .23969 L
.65054 .23974 L
.66026 .23984 L
.66997 .24 L
.67968 .24022 L
.68939 .24049 L
.69911 .24083 L
.70882 .24123 L
.71853 .24169 L
.72824 .24222 L
.73472 .24262 L
.73796 .24283 L
Mistroke
.74767 .2435 L
.75738 .24426 L
.76709 .2451 L
.77681 .24602 L
.78652 .24703 L
.79623 .24814 L
.80594 .24935 L
.81566 .25067 L
.82537 .25211 L
.82677 .25233 L
.83508 .25368 L
.84479 .25538 L
.85451 .25722 L
.86422 .25922 L
.87393 .2614 L
.87666 .26204 L
.88364 .26376 L
.89336 .26633 L
.90307 .26912 L
.91154 .27176 L
.91278 .27216 L
.92249 .27548 L
.93221 .2791 L
.93813 .28147 L
.94192 .28306 L
.95163 .28741 L
.95938 .29118 L
.96134 .29219 L
.97106 .29746 L
.97688 .30089 L
.98077 .30331 L
Mfstroke
.55 g
.01923 .89426 m
.02855 .90307 L
.02894 .90342 L
.03866 .91143 L
.04042 .91278 L
.04837 .91853 L
.05428 .92249 L
.05808 .92491 L
.06779 .93067 L
.07055 .93221 L
.07751 .93592 L
.08722 .94073 L
.08976 .94192 L
.09693 .94515 L
.10664 .94925 L
.11265 .95163 L
.11636 .95305 L
.12607 .95659 L
.13578 .95989 L
.14026 .96134 L
.14549 .96299 L
.15521 .96589 L
.16492 .96862 L
.17413 .97106 L
.17463 .97118 L
.18434 .97361 L
.19406 .97589 L
.20377 .97806 L
.21348 .9801 L
.21677 .98077 L
.01923 .98077 L
F
0 g
.01923 .89426 m
.02855 .90307 L
.02894 .90342 L
.03866 .91143 L
.04042 .91278 L
.04837 .91853 L
.05428 .92249 L
.05808 .92491 L
.06779 .93067 L
.07055 .93221 L
.07751 .93592 L
.08722 .94073 L
.08976 .94192 L
.09693 .94515 L
.10664 .94925 L
.11265 .95163 L
.11636 .95305 L
.12607 .95659 L
.13578 .95989 L
.14026 .96134 L
.14549 .96299 L
.15521 .96589 L
.16492 .96862 L
.17413 .97106 L
.17463 .97118 L
.18434 .97361 L
.19406 .97589 L
.20377 .97806 L
.21348 .9801 L
.21677 .98077 L
s
.7 g
.98077 .86724 m
.97453 .87393 L
.97106 .87744 L
.96453 .88364 L
.96134 .88651 L
.95322 .89336 L
.95163 .89462 L
.94192 .90191 L
.94029 .90307 L
.93221 .9085 L
.92533 .91278 L
.92249 .91447 L
.91278 .91989 L
.90779 .92249 L
.90307 .92484 L
.89336 .92936 L
.88678 .93221 L
.88364 .9335 L
.87393 .9373 L
.86422 .94079 L
.8609 .94192 L
.85451 .944 L
.84479 .94696 L
.83508 .94969 L
.82765 .95163 L
.82537 .9522 L
.81566 .95452 L
.80594 .95666 L
.79623 .95864 L
.78652 .96046 L
.78147 .96134 L
.77681 .96213 L
.76709 .96367 L
.75738 .96509 L
.74767 .96639 L
.73796 .96758 L
.72824 .96867 L
.71853 .96965 L
.70882 .97055 L
.70279 .97106 L
.69911 .97135 L
.68939 .97207 L
.67968 .97271 L
.66997 .97327 L
.66026 .97375 L
.65054 .97416 L
.64083 .97451 L
.63112 .97478 L
.62141 .97499 L
.61169 .97513 L
.60198 .97522 L
.59227 .97524 L
.58256 .97519 L
.57284 .97509 L
.56313 .97493 L
.55342 .97471 L
.54371 .97443 L
.53399 .9741 L
.52428 .9737 L
.51457 .97325 L
.50486 .97273 L
.49514 .97216 L
.48543 .97153 L
.47879 .97106 L
.47572 .97083 L
.46601 .97007 L
.45629 .96925 L
.44658 .96837 L
.43687 .96742 L
.42716 .9664 L
.41744 .96531 L
.40773 .96414 L
.39802 .9629 L
.38831 .96159 L
.38657 .96134 L
.37859 .96019 L
.36888 .95871 L
.35917 .95714 L
.34946 .95547 L
.33974 .95371 L
.33003 .95185 L
.32895 .95163 L
.32032 .94987 L
.31061 .94778 L
.30089 .94557 L
.29118 .94323 L
.28599 .94192 L
.28147 .94074 L
.27176 .93811 L
.26204 .93532 L
.25233 .93234 L
.2519 .93221 L
.24262 .92918 L
.23291 .92581 L
.22392 .92249 L
.22319 .92222 L
.21348 .91837 L
.20377 .91424 L
.2005 .91278 L
.19406 .9098 L
.18434 .90501 L
.18061 .90307 L
.17463 .89983 L
.16492 .89419 L
.16355 .89336 L
.15521 .88803 L
.14881 .88364 L
.14549 .88125 L
.13602 .87393 L
.13578 .87374 L
.12607 .86533 L
.12487 .86422 L
.11636 .8558 L
.11514 .85451 L
.10664 .84483 L
.10662 .84479 L
.09916 .83508 L
.09693 .8319 L
.09265 .82537 L
.08722 .81614 L
.08696 .81566 L
.082 .80594 L
.07771 .79623 L
.07751 .79573 L
.07401 .78652 L
.07085 .77681 L
.06818 .76709 L
.06779 .76555 L
.06595 .75738 L
.06414 .74767 L
.0627 .73796 L
.06161 .72824 L
.06085 .71853 L
.0604 .70882 L
.06023 .69911 L
.06034 .68939 L
.06071 .67968 L
.06133 .66997 L
.06219 .66026 L
.06329 .65054 L
.06462 .64083 L
.06617 .63112 L
.06779 .62224 L
.06796 .62141 L
.06996 .61169 L
.0722 .60198 L
.07467 .59227 L
.07738 .58256 L
.07751 .58213 L
.08033 .57284 L
.08354 .56313 L
.08701 .55342 L
.08722 .55285 L
.09075 .54371 L
.09479 .53399 L
.09693 .52912 L
.09914 .52428 L
.10381 .51457 L
.10664 .50902 L
.10884 .50486 L
.11425 .49514 L
.11636 .49156 L
.12008 .48543 L
.12607 .47613 L
.12634 .47572 L
.1331 .46601 L
.13578 .46235 L
.14039 .45629 L
.14549 .44992 L
.14827 .44658 L
.15521 .43863 L
.15681 .43687 L
.16492 .42832 L
.16607 .42716 L
.17463 .41885 L
.17615 .41744 L
.18434 .41012 L
.18714 .40773 L
.19406 .40205 L
.19918 .39802 L
.20377 .39455 L
.21242 .38831 L
.21348 .38757 L
.22319 .38105 L
.22704 .37859 L
.23291 .37496 L
.24262 .36925 L
.24327 .36888 L
.25233 .3639 L
.26143 .35917 L
.26204 .35886 L
.27176 .35412 L
.28147 .34965 L
.28189 .34946 L
.29118 .34543 L
.30089 .34145 L
.30522 .33974 L
.31061 .33768 L
.32032 .33412 L
.33003 .33075 L
.33218 .33003 L
.33974 .32756 L
.34946 .32454 L
.35917 .32168 L
.36397 .32032 L
.36888 .31897 L
.37859 .3164 L
.38831 .31397 L
.39802 .31166 L
.40267 .31061 L
.40773 .30948 L
.41744 .30742 L
.42716 .30547 L
.43687 .30364 L
.44658 .3019 L
.4525 .30089 L
.45629 .30027 L
.46601 .29873 L
.47572 .29729 L
.48543 .29594 L
.49514 .29468 L
.50486 .29351 L
.51457 .29242 L
.52428 .29141 L
.52666 .29118 L
.53399 .29049 L
.54371 .28965 L
.55342 .28889 L
.56313 .28821 L
.57284 .28761 L
.58256 .28709 L
.59227 .28664 L
.60198 .28627 L
.61169 .28599 L
.62141 .28578 L
.63112 .28565 L
.64083 .2856 L
.65054 .28563 L
.66026 .28575 L
.66997 .28596 L
.67968 .28625 L
.68939 .28663 L
.69911 .2871 L
.70882 .28767 L
.71853 .28834 L
.72824 .28911 L
.73796 .28999 L
.74767 .29098 L
.74951 .29118 L
.75738 .29209 L
.76709 .29332 L
.77681 .29469 L
.78652 .29619 L
.79623 .29784 L
.80594 .29964 L
.81222 .30089 L
.81566 .30161 L
.82537 .30376 L
.83508 .30611 L
.84479 .30866 L
.8517 .31061 L
.85451 .31143 L
.86422 .31445 L
.87393 .31774 L
.88101 .32032 L
.88364 .32132 L
.89336 .32522 L
.90307 .32948 L
.90426 .33003 L
.91278 .33414 L
.92249 .33924 L
.92341 .33974 L
.93221 .34484 L
.93957 .34946 L
.94192 .351 L
.95163 .35781 L
.95345 .35917 L
.96134 .36537 L
.96552 .36888 L
.97106 .37381 L
.97611 .37859 L
.98077 .38327 L
F
0 g
.98077 .86724 m
.97453 .87393 L
.97106 .87744 L
.96453 .88364 L
.96134 .88651 L
.95322 .89336 L
.95163 .89462 L
.94192 .90191 L
.94029 .90307 L
.93221 .9085 L
.92533 .91278 L
.92249 .91447 L
.91278 .91989 L
.90779 .92249 L
.90307 .92484 L
.89336 .92936 L
.88678 .93221 L
.88364 .9335 L
.87393 .9373 L
.86422 .94079 L
.8609 .94192 L
.85451 .944 L
.84479 .94696 L
.83508 .94969 L
.82765 .95163 L
.82537 .9522 L
.81566 .95452 L
.80594 .95666 L
.79623 .95864 L
.78652 .96046 L
.78147 .96134 L
.77681 .96213 L
.76709 .96367 L
.75738 .96509 L
.74767 .96639 L
.73796 .96758 L
.72824 .96867 L
.71853 .96965 L
.70882 .97055 L
.70279 .97106 L
.69911 .97135 L
.68939 .97207 L
.67968 .97271 L
.66997 .97327 L
.66026 .97375 L
.65054 .97416 L
.64083 .97451 L
.63112 .97478 L
.62141 .97499 L
.61169 .97513 L
Mistroke
.60198 .97522 L
.59227 .97524 L
.58256 .97519 L
.57284 .97509 L
.56313 .97493 L
.55342 .97471 L
.54371 .97443 L
.53399 .9741 L
.52428 .9737 L
.51457 .97325 L
.50486 .97273 L
.49514 .97216 L
.48543 .97153 L
.47879 .97106 L
.47572 .97083 L
.46601 .97007 L
.45629 .96925 L
.44658 .96837 L
.43687 .96742 L
.42716 .9664 L
.41744 .96531 L
.40773 .96414 L
.39802 .9629 L
.38831 .96159 L
.38657 .96134 L
.37859 .96019 L
.36888 .95871 L
.35917 .95714 L
.34946 .95547 L
.33974 .95371 L
.33003 .95185 L
.32895 .95163 L
.32032 .94987 L
.31061 .94778 L
.30089 .94557 L
.29118 .94323 L
.28599 .94192 L
.28147 .94074 L
.27176 .93811 L
.26204 .93532 L
.25233 .93234 L
.2519 .93221 L
.24262 .92918 L
.23291 .92581 L
.22392 .92249 L
.22319 .92222 L
.21348 .91837 L
.20377 .91424 L
.2005 .91278 L
.19406 .9098 L
Mistroke
.18434 .90501 L
.18061 .90307 L
.17463 .89983 L
.16492 .89419 L
.16355 .89336 L
.15521 .88803 L
.14881 .88364 L
.14549 .88125 L
.13602 .87393 L
.13578 .87374 L
.12607 .86533 L
.12487 .86422 L
.11636 .8558 L
.11514 .85451 L
.10664 .84483 L
.10662 .84479 L
.09916 .83508 L
.09693 .8319 L
.09265 .82537 L
.08722 .81614 L
.08696 .81566 L
.082 .80594 L
.07771 .79623 L
.07751 .79573 L
.07401 .78652 L
.07085 .77681 L
.06818 .76709 L
.06779 .76555 L
.06595 .75738 L
.06414 .74767 L
.0627 .73796 L
.06161 .72824 L
.06085 .71853 L
.0604 .70882 L
.06023 .69911 L
.06034 .68939 L
.06071 .67968 L
.06133 .66997 L
.06219 .66026 L
.06329 .65054 L
.06462 .64083 L
.06617 .63112 L
.06779 .62224 L
.06796 .62141 L
.06996 .61169 L
.0722 .60198 L
.07467 .59227 L
.07738 .58256 L
.07751 .58213 L
.08033 .57284 L
Mistroke
.08354 .56313 L
.08701 .55342 L
.08722 .55285 L
.09075 .54371 L
.09479 .53399 L
.09693 .52912 L
.09914 .52428 L
.10381 .51457 L
.10664 .50902 L
.10884 .50486 L
.11425 .49514 L
.11636 .49156 L
.12008 .48543 L
.12607 .47613 L
.12634 .47572 L
.1331 .46601 L
.13578 .46235 L
.14039 .45629 L
.14549 .44992 L
.14827 .44658 L
.15521 .43863 L
.15681 .43687 L
.16492 .42832 L
.16607 .42716 L
.17463 .41885 L
.17615 .41744 L
.18434 .41012 L
.18714 .40773 L
.19406 .40205 L
.19918 .39802 L
.20377 .39455 L
.21242 .38831 L
.21348 .38757 L
.22319 .38105 L
.22704 .37859 L
.23291 .37496 L
.24262 .36925 L
.24327 .36888 L
.25233 .3639 L
.26143 .35917 L
.26204 .35886 L
.27176 .35412 L
.28147 .34965 L
.28189 .34946 L
.29118 .34543 L
.30089 .34145 L
.30522 .33974 L
.31061 .33768 L
.32032 .33412 L
.33003 .33075 L
Mistroke
.33218 .33003 L
.33974 .32756 L
.34946 .32454 L
.35917 .32168 L
.36397 .32032 L
.36888 .31897 L
.37859 .3164 L
.38831 .31397 L
.39802 .31166 L
.40267 .31061 L
.40773 .30948 L
.41744 .30742 L
.42716 .30547 L
.43687 .30364 L
.44658 .3019 L
.4525 .30089 L
.45629 .30027 L
.46601 .29873 L
.47572 .29729 L
.48543 .29594 L
.49514 .29468 L
.50486 .29351 L
.51457 .29242 L
.52428 .29141 L
.52666 .29118 L
.53399 .29049 L
.54371 .28965 L
.55342 .28889 L
.56313 .28821 L
.57284 .28761 L
.58256 .28709 L
.59227 .28664 L
.60198 .28627 L
.61169 .28599 L
.62141 .28578 L
.63112 .28565 L
.64083 .2856 L
.65054 .28563 L
.66026 .28575 L
.66997 .28596 L
.67968 .28625 L
.68939 .28663 L
.69911 .2871 L
.70882 .28767 L
.71853 .28834 L
.72824 .28911 L
.73796 .28999 L
.74767 .29098 L
.74951 .29118 L
.75738 .29209 L
Mistroke
.76709 .29332 L
.77681 .29469 L
.78652 .29619 L
.79623 .29784 L
.80594 .29964 L
.81222 .30089 L
.81566 .30161 L
.82537 .30376 L
.83508 .30611 L
.84479 .30866 L
.8517 .31061 L
.85451 .31143 L
.86422 .31445 L
.87393 .31774 L
.88101 .32032 L
.88364 .32132 L
.89336 .32522 L
.90307 .32948 L
.90426 .33003 L
.91278 .33414 L
.92249 .33924 L
.92341 .33974 L
.93221 .34484 L
.93957 .34946 L
.94192 .351 L
.95163 .35781 L
.95345 .35917 L
.96134 .36537 L
.96552 .36888 L
.97106 .37381 L
.97611 .37859 L
.98077 .38327 L
Mfstroke
.775 g
.98077 .77494 m
.97985 .77681 L
.97475 .78652 L
.97106 .793 L
.96912 .79623 L
.96288 .80594 L
.96134 .80819 L
.95596 .81566 L
.95163 .82125 L
.94827 .82537 L
.94192 .83265 L
.93968 .83508 L
.93221 .84272 L
.93006 .84479 L
.92249 .85169 L
.91921 .85451 L
.91278 .85973 L
.90689 .86422 L
.90307 .86698 L
.89336 .87354 L
.89274 .87393 L
.88364 .8795 L
.87631 .88364 L
.87393 .88493 L
.86422 .88989 L
.85687 .89336 L
.85451 .89443 L
.84479 .89859 L
.83508 .90241 L
.83331 .90307 L
.82537 .90591 L
.81566 .90914 L
.80594 .9121 L
.80361 .91278 L
.79623 .91483 L
.78652 .91734 L
.77681 .91964 L
.76709 .92175 L
.76345 .92249 L
.75738 .92368 L
.74767 .92545 L
.73796 .92706 L
.72824 .92852 L
.71853 .92984 L
.70882 .93104 L
.69911 .9321 L
.69809 .93221 L
.68939 .93305 L
.67968 .93388 L
.66997 .9346 L
.66026 .93521 L
.65054 .93573 L
.64083 .93614 L
.63112 .93645 L
.62141 .93668 L
.61169 .9368 L
.60198 .93684 L
.59227 .93679 L
.58256 .93665 L
.57284 .93642 L
.56313 .93611 L
.55342 .93571 L
.54371 .93522 L
.53399 .93464 L
.52428 .93398 L
.51457 .93323 L
.50486 .93238 L
.50295 .93221 L
.49514 .93145 L
.48543 .93042 L
.47572 .92929 L
.46601 .92807 L
.45629 .92675 L
.44658 .92532 L
.43687 .92378 L
.42925 .92249 L
.42716 .92213 L
.41744 .92036 L
.40773 .91847 L
.39802 .91644 L
.38831 .91428 L
.3819 .91278 L
.37859 .91198 L
.36888 .90952 L
.35917 .9069 L
.34946 .9041 L
.34602 .90307 L
.33974 .90112 L
.33003 .89793 L
.32032 .89452 L
.31715 .89336 L
.31061 .89087 L
.30089 .88696 L
.29318 .88364 L
.29118 .88275 L
.28147 .87823 L
.2729 .87393 L
.27176 .87334 L
.26204 .86804 L
.25551 .86422 L
.25233 .86228 L
.24262 .85598 L
.24048 .85451 L
.23291 .84905 L
.2274 .84479 L
.22319 .84137 L
.21598 .83508 L
.21348 .83277 L
.20598 .82537 L
.20377 .82304 L
.19721 .81566 L
.19406 .81182 L
.18953 .80594 L
.18434 .79857 L
.18281 .79623 L
.17694 .78652 L
.17463 .7823 L
.17184 .77681 L
.16743 .76709 L
.16492 .7608 L
.16366 .75738 L
.16047 .74767 L
.15782 .73796 L
.15566 .72824 L
.15521 .72594 L
.15396 .71853 L
.15269 .70882 L
.15183 .69911 L
.15137 .68939 L
.15127 .67968 L
.15153 .66997 L
.15213 .66026 L
.15308 .65054 L
.15435 .64083 L
.15521 .63535 L
.15595 .63112 L
.15787 .62141 L
.16013 .61169 L
.16271 .60198 L
.16492 .59451 L
.16562 .59227 L
.16888 .58256 L
.1725 .57284 L
.17463 .56752 L
.17647 .56313 L
.18084 .55342 L
.18434 .54619 L
.1856 .54371 L
.19079 .53399 L
.19406 .52827 L
.19643 .52428 L
.20255 .51457 L
.20377 .51273 L
.20919 .50486 L
.21348 .49898 L
.2164 .49514 L
.22319 .48666 L
.22422 .48543 L
.23271 .47572 L
.23291 .4755 L
.24194 .46601 L
.24262 .46533 L
.252 .45629 L
.25233 .45599 L
.26204 .44738 L
.26298 .44658 L
.27176 .43941 L
.27501 .43687 L
.28147 .432 L
.28823 .42716 L
.29118 .42511 L
.30089 .41867 L
.30282 .41744 L
.31061 .41265 L
.31903 .40773 L
.32032 .40701 L
.33003 .40171 L
.33717 .39802 L
.33974 .39673 L
.34946 .39205 L
.35767 .38831 L
.35917 .38764 L
.36888 .38349 L
.37859 .37958 L
.38112 .37859 L
.38831 .37589 L
.39802 .37241 L
.40773 .36913 L
.40849 .36888 L
.41744 .36604 L
.42716 .36313 L
.43687 .36038 L
.44137 .35917 L
.44658 .3578 L
.45629 .35538 L
.46601 .3531 L
.47572 .35097 L
.48303 .34946 L
.48543 .34898 L
.49514 .34712 L
.50486 .34539 L
.51457 .34378 L
.52428 .3423 L
.53399 .34094 L
.54332 .33974 L
.54371 .3397 L
.55342 .33857 L
.56313 .33756 L
.57284 .33666 L
.58256 .33587 L
.59227 .33519 L
.60198 .33463 L
.61169 .33418 L
.62141 .33384 L
.63112 .33361 L
.64083 .3335 L
.65054 .3335 L
.66026 .33362 L
.66997 .33386 L
.67968 .33422 L
.68939 .3347 L
.69911 .33532 L
.70882 .33607 L
.71853 .33696 L
.72824 .338 L
.73796 .33918 L
.74216 .33974 L
.74767 .34053 L
.75738 .34204 L
.76709 .34372 L
.77681 .34559 L
.78652 .34766 L
.79427 .34946 L
.79623 .34993 L
.80594 .35243 L
.81566 .35518 L
.82537 .35818 L
.82839 .35917 L
.83508 .36146 L
.84479 .36506 L
.85426 .36888 L
.85451 .36898 L
.86422 .37328 L
.87393 .37799 L
.87512 .37859 L
.88364 .38315 L
.89252 .38831 L
.89336 .38882 L
.90307 .39506 L
.90735 .39802 L
.91278 .40197 L
.92018 .40773 L
.92249 .40963 L
.93141 .41744 L
.93221 .41818 L
.94133 .42716 L
.94192 .42778 L
.95013 .43687 L
.95163 .43865 L
.95797 .44658 L
.96134 .45111 L
.965 .45629 L
.97106 .46561 L
.9713 .46601 L
.97696 .47572 L
.98077 .48289 L
F
0 g
.98077 .77494 m
.97985 .77681 L
.97475 .78652 L
.97106 .793 L
.96912 .79623 L
.96288 .80594 L
.96134 .80819 L
.95596 .81566 L
.95163 .82125 L
.94827 .82537 L
.94192 .83265 L
.93968 .83508 L
.93221 .84272 L
.93006 .84479 L
.92249 .85169 L
.91921 .85451 L
.91278 .85973 L
.90689 .86422 L
.90307 .86698 L
.89336 .87354 L
.89274 .87393 L
.88364 .8795 L
.87631 .88364 L
.87393 .88493 L
.86422 .88989 L
.85687 .89336 L
.85451 .89443 L
.84479 .89859 L
.83508 .90241 L
.83331 .90307 L
.82537 .90591 L
.81566 .90914 L
.80594 .9121 L
.80361 .91278 L
.79623 .91483 L
.78652 .91734 L
.77681 .91964 L
.76709 .92175 L
.76345 .92249 L
.75738 .92368 L
.74767 .92545 L
.73796 .92706 L
.72824 .92852 L
.71853 .92984 L
.70882 .93104 L
.69911 .9321 L
.69809 .93221 L
.68939 .93305 L
.67968 .93388 L
.66997 .9346 L
Mistroke
.66026 .93521 L
.65054 .93573 L
.64083 .93614 L
.63112 .93645 L
.62141 .93668 L
.61169 .9368 L
.60198 .93684 L
.59227 .93679 L
.58256 .93665 L
.57284 .93642 L
.56313 .93611 L
.55342 .93571 L
.54371 .93522 L
.53399 .93464 L
.52428 .93398 L
.51457 .93323 L
.50486 .93238 L
.50295 .93221 L
.49514 .93145 L
.48543 .93042 L
.47572 .92929 L
.46601 .92807 L
.45629 .92675 L
.44658 .92532 L
.43687 .92378 L
.42925 .92249 L
.42716 .92213 L
.41744 .92036 L
.40773 .91847 L
.39802 .91644 L
.38831 .91428 L
.3819 .91278 L
.37859 .91198 L
.36888 .90952 L
.35917 .9069 L
.34946 .9041 L
.34602 .90307 L
.33974 .90112 L
.33003 .89793 L
.32032 .89452 L
.31715 .89336 L
.31061 .89087 L
.30089 .88696 L
.29318 .88364 L
.29118 .88275 L
.28147 .87823 L
.2729 .87393 L
.27176 .87334 L
.26204 .86804 L
.25551 .86422 L
Mistroke
.25233 .86228 L
.24262 .85598 L
.24048 .85451 L
.23291 .84905 L
.2274 .84479 L
.22319 .84137 L
.21598 .83508 L
.21348 .83277 L
.20598 .82537 L
.20377 .82304 L
.19721 .81566 L
.19406 .81182 L
.18953 .80594 L
.18434 .79857 L
.18281 .79623 L
.17694 .78652 L
.17463 .7823 L
.17184 .77681 L
.16743 .76709 L
.16492 .7608 L
.16366 .75738 L
.16047 .74767 L
.15782 .73796 L
.15566 .72824 L
.15521 .72594 L
.15396 .71853 L
.15269 .70882 L
.15183 .69911 L
.15137 .68939 L
.15127 .67968 L
.15153 .66997 L
.15213 .66026 L
.15308 .65054 L
.15435 .64083 L
.15521 .63535 L
.15595 .63112 L
.15787 .62141 L
.16013 .61169 L
.16271 .60198 L
.16492 .59451 L
.16562 .59227 L
.16888 .58256 L
.1725 .57284 L
.17463 .56752 L
.17647 .56313 L
.18084 .55342 L
.18434 .54619 L
.1856 .54371 L
.19079 .53399 L
.19406 .52827 L
Mistroke
.19643 .52428 L
.20255 .51457 L
.20377 .51273 L
.20919 .50486 L
.21348 .49898 L
.2164 .49514 L
.22319 .48666 L
.22422 .48543 L
.23271 .47572 L
.23291 .4755 L
.24194 .46601 L
.24262 .46533 L
.252 .45629 L
.25233 .45599 L
.26204 .44738 L
.26298 .44658 L
.27176 .43941 L
.27501 .43687 L
.28147 .432 L
.28823 .42716 L
.29118 .42511 L
.30089 .41867 L
.30282 .41744 L
.31061 .41265 L
.31903 .40773 L
.32032 .40701 L
.33003 .40171 L
.33717 .39802 L
.33974 .39673 L
.34946 .39205 L
.35767 .38831 L
.35917 .38764 L
.36888 .38349 L
.37859 .37958 L
.38112 .37859 L
.38831 .37589 L
.39802 .37241 L
.40773 .36913 L
.40849 .36888 L
.41744 .36604 L
.42716 .36313 L
.43687 .36038 L
.44137 .35917 L
.44658 .3578 L
.45629 .35538 L
.46601 .3531 L
.47572 .35097 L
.48303 .34946 L
.48543 .34898 L
.49514 .34712 L
Mistroke
.50486 .34539 L
.51457 .34378 L
.52428 .3423 L
.53399 .34094 L
.54332 .33974 L
.54371 .3397 L
.55342 .33857 L
.56313 .33756 L
.57284 .33666 L
.58256 .33587 L
.59227 .33519 L
.60198 .33463 L
.61169 .33418 L
.62141 .33384 L
.63112 .33361 L
.64083 .3335 L
.65054 .3335 L
.66026 .33362 L
.66997 .33386 L
.67968 .33422 L
.68939 .3347 L
.69911 .33532 L
.70882 .33607 L
.71853 .33696 L
.72824 .338 L
.73796 .33918 L
.74216 .33974 L
.74767 .34053 L
.75738 .34204 L
.76709 .34372 L
.77681 .34559 L
.78652 .34766 L
.79427 .34946 L
.79623 .34993 L
.80594 .35243 L
.81566 .35518 L
.82537 .35818 L
.82839 .35917 L
.83508 .36146 L
.84479 .36506 L
.85426 .36888 L
.85451 .36898 L
.86422 .37328 L
.87393 .37799 L
.87512 .37859 L
.88364 .38315 L
.89252 .38831 L
.89336 .38882 L
.90307 .39506 L
.90735 .39802 L
Mistroke
.91278 .40197 L
.92018 .40773 L
.92249 .40963 L
.93141 .41744 L
.93221 .41818 L
.94133 .42716 L
.94192 .42778 L
.95013 .43687 L
.95163 .43865 L
.95797 .44658 L
.96134 .45111 L
.965 .45629 L
.97106 .46561 L
.9713 .46601 L
.97696 .47572 L
.98077 .48289 L
Mfstroke
.85 g
.59227 .3877 m
.60198 .38687 L
.61169 .3862 L
.62141 .38568 L
.63112 .38532 L
.64083 .38512 L
.65054 .38507 L
.66026 .38518 L
.66997 .38546 L
.67968 .38591 L
.68939 .38653 L
.69911 .38732 L
.70882 .38831 L
.70882 .38831 L
.71853 .38948 L
.72824 .39085 L
.73796 .39244 L
.74767 .39424 L
.75738 .39628 L
.76485 .39802 L
.76709 .39857 L
.77681 .40112 L
.78652 .40396 L
.79623 .40711 L
.79805 .40773 L
.80594 .41058 L
.81566 .41442 L
.82269 .41744 L
.82537 .41866 L
.83508 .42333 L
.84237 .42716 L
.84479 .42849 L
.85451 .43421 L
.85871 .43687 L
.86422 .44054 L
.8726 .44658 L
.87393 .44759 L
.88364 .45548 L
.88458 .45629 L
.89336 .46436 L
.89503 .46601 L
.90307 .47444 L
.90421 .47572 L
.91232 .48543 L
.91278 .48603 L
.9195 .49514 L
.92249 .49957 L
.92586 .50486 L
.93151 .51457 L
.93221 .51585 L
.93651 .52428 L
.94093 .53399 L
.94192 .53635 L
.94481 .54371 L
.9482 .55342 L
.95112 .56313 L
.95163 .56498 L
.95362 .57284 L
.9557 .58256 L
.95739 .59227 L
.95871 .60198 L
.95966 .61169 L
.96026 .62141 L
.96051 .63112 L
.96041 .64083 L
.95996 .65054 L
.95917 .66026 L
.95802 .66997 L
.95651 .67968 L
.95463 .68939 L
.95237 .69911 L
.95163 .70196 L
.9497 .70882 L
.94661 .71853 L
.94307 .72824 L
.94192 .73116 L
.93905 .73796 L
.9345 .74767 L
.93221 .75217 L
.92939 .75738 L
.92364 .76709 L
.92249 .76891 L
.9172 .77681 L
.91278 .78289 L
.90998 .78652 L
.90307 .79486 L
.90186 .79623 L
.89336 .8053 L
.89271 .80594 L
.88364 .81451 L
.88235 .81566 L
.87393 .82272 L
.87055 .82537 L
.86422 .83007 L
.85697 .83508 L
.85451 .8367 L
.84479 .8427 L
.84116 .84479 L
.83508 .84814 L
.82537 .85309 L
.82241 .85451 L
.81566 .8576 L
.80594 .86171 L
.79957 .86422 L
.79623 .86547 L
.78652 .8689 L
.77681 .87204 L
.77046 .87393 L
.76709 .87489 L
.75738 .87749 L
.74767 .87985 L
.73796 .882 L
.72974 .88364 L
.72824 .88393 L
.71853 .88567 L
.70882 .88722 L
.69911 .8886 L
.68939 .88981 L
.67968 .89086 L
.66997 .89175 L
.66026 .8925 L
.65054 .8931 L
.64572 .89336 L
.64083 .89357 L
.63112 .8939 L
.62141 .8941 L
.61169 .89416 L
.60198 .8941 L
.59227 .89391 L
.58256 .8936 L
.57681 .89336 L
.57284 .89316 L
.56313 .89259 L
.55342 .89189 L
.54371 .89107 L
.53399 .89012 L
.52428 .88903 L
.51457 .88781 L
.50486 .88645 L
.49514 .88494 L
.48744 .88364 L
.48543 .88329 L
.47572 .88148 L
.46601 .87951 L
.45629 .87738 L
.44658 .87506 L
.4421 .87393 L
.43687 .87256 L
.42716 .86986 L
.41744 .86694 L
.40901 .86422 L
.40773 .86379 L
.39802 .86039 L
.38831 .85673 L
.38278 .85451 L
.37859 .85276 L
.36888 .84847 L
.36115 .84479 L
.35917 .84381 L
.34946 .83875 L
.34291 .83508 L
.33974 .83322 L
.33003 .82716 L
.32734 .82537 L
.32032 .82047 L
.31391 .81566 L
.31061 .81304 L
.30226 .80594 L
.30089 .80471 L
.29214 .79623 L
.29118 .79523 L
.28334 .78652 L
.28147 .78427 L
.27568 .77681 L
.27176 .77123 L
.26905 .76709 L
.26333 .75738 L
.26204 .75498 L
.25843 .74767 L
.25429 .73796 L
.25233 .7327 L
.25084 .72824 L
.24802 .71853 L
.2458 .70882 L
.24415 .69911 L
.24302 .68939 L
.24262 .68406 L
.2424 .67968 L
.24227 .66997 L
.2426 .66026 L
.24262 .65986 L
.24339 .65054 L
.24464 .64083 L
.24633 .63112 L
.24846 .62141 L
.25104 .61169 L
.25233 .60739 L
.25408 .60198 L
.25758 .59227 L
.26155 .58256 L
.26204 .58143 L
.26602 .57284 L
.271 .56313 L
.27176 .56174 L
.27652 .55342 L
.28147 .54547 L
.28262 .54371 L
.28934 .53399 L
.29118 .53148 L
.29671 .52428 L
.30089 .51916 L
.30481 .51457 L
.31061 .50813 L
.3137 .50486 L
.32032 .49817 L
.32346 .49514 L
.33003 .48909 L
.3342 .48543 L
.33974 .48076 L
.34604 .47572 L
.34946 .47309 L
.35915 .46601 L
.35917 .46599 L
.36888 .45941 L
.37373 .45629 L
.37859 .45329 L
.38831 .44758 L
.39008 .44658 L
.39802 .44226 L
.40773 .43729 L
.40858 .43687 L
.41744 .43264 L
.42716 .42829 L
.4298 .42716 L
.43687 .42422 L
.44658 .42042 L
.45466 .41744 L
.45629 .41686 L
.46601 .41354 L
.47572 .41044 L
.48478 .40773 L
.48543 .40755 L
.49514 .40486 L
.50486 .40236 L
.51457 .40005 L
.52384 .39802 L
.52428 .39793 L
.53399 .39597 L
.54371 .39419 L
.55342 .39257 L
.56313 .39112 L
.57284 .38982 L
.58256 .38868 L
.58609 .38831 L
F
0 g
.59227 .3877 m
.60198 .38687 L
.61169 .3862 L
.62141 .38568 L
.63112 .38532 L
.64083 .38512 L
.65054 .38507 L
.66026 .38518 L
.66997 .38546 L
.67968 .38591 L
.68939 .38653 L
.69911 .38732 L
.70882 .38831 L
.70882 .38831 L
.71853 .38948 L
.72824 .39085 L
.73796 .39244 L
.74767 .39424 L
.75738 .39628 L
.76485 .39802 L
.76709 .39857 L
.77681 .40112 L
.78652 .40396 L
.79623 .40711 L
.79805 .40773 L
.80594 .41058 L
.81566 .41442 L
.82269 .41744 L
.82537 .41866 L
.83508 .42333 L
.84237 .42716 L
.84479 .42849 L
.85451 .43421 L
.85871 .43687 L
.86422 .44054 L
.8726 .44658 L
.87393 .44759 L
.88364 .45548 L
.88458 .45629 L
.89336 .46436 L
.89503 .46601 L
.90307 .47444 L
.90421 .47572 L
.91232 .48543 L
.91278 .48603 L
.9195 .49514 L
.92249 .49957 L
.92586 .50486 L
.93151 .51457 L
.93221 .51585 L
Mistroke
.93651 .52428 L
.94093 .53399 L
.94192 .53635 L
.94481 .54371 L
.9482 .55342 L
.95112 .56313 L
.95163 .56498 L
.95362 .57284 L
.9557 .58256 L
.95739 .59227 L
.95871 .60198 L
.95966 .61169 L
.96026 .62141 L
.96051 .63112 L
.96041 .64083 L
.95996 .65054 L
.95917 .66026 L
.95802 .66997 L
.95651 .67968 L
.95463 .68939 L
.95237 .69911 L
.95163 .70196 L
.9497 .70882 L
.94661 .71853 L
.94307 .72824 L
.94192 .73116 L
.93905 .73796 L
.9345 .74767 L
.93221 .75217 L
.92939 .75738 L
.92364 .76709 L
.92249 .76891 L
.9172 .77681 L
.91278 .78289 L
.90998 .78652 L
.90307 .79486 L
.90186 .79623 L
.89336 .8053 L
.89271 .80594 L
.88364 .81451 L
.88235 .81566 L
.87393 .82272 L
.87055 .82537 L
.86422 .83007 L
.85697 .83508 L
.85451 .8367 L
.84479 .8427 L
.84116 .84479 L
.83508 .84814 L
.82537 .85309 L
Mistroke
.82241 .85451 L
.81566 .8576 L
.80594 .86171 L
.79957 .86422 L
.79623 .86547 L
.78652 .8689 L
.77681 .87204 L
.77046 .87393 L
.76709 .87489 L
.75738 .87749 L
.74767 .87985 L
.73796 .882 L
.72974 .88364 L
.72824 .88393 L
.71853 .88567 L
.70882 .88722 L
.69911 .8886 L
.68939 .88981 L
.67968 .89086 L
.66997 .89175 L
.66026 .8925 L
.65054 .8931 L
.64572 .89336 L
.64083 .89357 L
.63112 .8939 L
.62141 .8941 L
.61169 .89416 L
.60198 .8941 L
.59227 .89391 L
.58256 .8936 L
.57681 .89336 L
.57284 .89316 L
.56313 .89259 L
.55342 .89189 L
.54371 .89107 L
.53399 .89012 L
.52428 .88903 L
.51457 .88781 L
.50486 .88645 L
.49514 .88494 L
.48744 .88364 L
.48543 .88329 L
.47572 .88148 L
.46601 .87951 L
.45629 .87738 L
.44658 .87506 L
.4421 .87393 L
.43687 .87256 L
.42716 .86986 L
.41744 .86694 L
Mistroke
.40901 .86422 L
.40773 .86379 L
.39802 .86039 L
.38831 .85673 L
.38278 .85451 L
.37859 .85276 L
.36888 .84847 L
.36115 .84479 L
.35917 .84381 L
.34946 .83875 L
.34291 .83508 L
.33974 .83322 L
.33003 .82716 L
.32734 .82537 L
.32032 .82047 L
.31391 .81566 L
.31061 .81304 L
.30226 .80594 L
.30089 .80471 L
.29214 .79623 L
.29118 .79523 L
.28334 .78652 L
.28147 .78427 L
.27568 .77681 L
.27176 .77123 L
.26905 .76709 L
.26333 .75738 L
.26204 .75498 L
.25843 .74767 L
.25429 .73796 L
.25233 .7327 L
.25084 .72824 L
.24802 .71853 L
.2458 .70882 L
.24415 .69911 L
.24302 .68939 L
.24262 .68406 L
.2424 .67968 L
.24227 .66997 L
.2426 .66026 L
.24262 .65986 L
.24339 .65054 L
.24464 .64083 L
.24633 .63112 L
.24846 .62141 L
.25104 .61169 L
.25233 .60739 L
.25408 .60198 L
.25758 .59227 L
.26155 .58256 L
Mistroke
.26204 .58143 L
.26602 .57284 L
.271 .56313 L
.27176 .56174 L
.27652 .55342 L
.28147 .54547 L
.28262 .54371 L
.28934 .53399 L
.29118 .53148 L
.29671 .52428 L
.30089 .51916 L
.30481 .51457 L
.31061 .50813 L
.3137 .50486 L
.32032 .49817 L
.32346 .49514 L
.33003 .48909 L
.3342 .48543 L
.33974 .48076 L
.34604 .47572 L
.34946 .47309 L
.35915 .46601 L
.35917 .46599 L
.36888 .45941 L
.37373 .45629 L
.37859 .45329 L
.38831 .44758 L
.39008 .44658 L
.39802 .44226 L
.40773 .43729 L
.40858 .43687 L
.41744 .43264 L
.42716 .42829 L
.4298 .42716 L
.43687 .42422 L
.44658 .42042 L
.45466 .41744 L
.45629 .41686 L
.46601 .41354 L
.47572 .41044 L
.48478 .40773 L
.48543 .40755 L
.49514 .40486 L
.50486 .40236 L
.51457 .40005 L
.52384 .39802 L
.52428 .39793 L
.53399 .39597 L
.54371 .39419 L
.55342 .39257 L
Mistroke
.56313 .39112 L
.57284 .38982 L
.58256 .38868 L
.58609 .38831 L
.59227 .3877 L
Mfstroke
.25 g
.8854 .01923 m
.88364 .01993 L
.87393 .02359 L
.86422 .02689 L
.85766 .02894 L
.85451 .02988 L
.84479 .0326 L
.83508 .03506 L
.82537 .03731 L
.8191 .03866 L
.81566 .03936 L
.80594 .04123 L
.79623 .04294 L
.78652 .0445 L
.77681 .04593 L
.76709 .04722 L
.75769 .04837 L
.75738 .0484 L
.74767 .04948 L
.73796 .05045 L
.72824 .05133 L
.71853 .05211 L
.70882 .05282 L
.69911 .05344 L
.68939 .05399 L
.67968 .05447 L
.66997 .05488 L
.66026 .05522 L
.65054 .0555 L
.64083 .05572 L
.63112 .05588 L
.62141 .05599 L
.61169 .05604 L
.60198 .05603 L
.59227 .05597 L
.58256 .05586 L
.57284 .0557 L
.56313 .05549 L
.55342 .05523 L
.54371 .05492 L
.53399 .05457 L
.52428 .05416 L
.51457 .05371 L
.50486 .0532 L
.49514 .05265 L
.48543 .05205 L
.47572 .0514 L
.46601 .05071 L
.45629 .04996 L
.44658 .04916 L
.43744 .04837 L
.43687 .04832 L
.42716 .04742 L
.41744 .04647 L
.40773 .04546 L
.39802 .0444 L
.38831 .04329 L
.37859 .04212 L
.36888 .04089 L
.35917 .0396 L
.35229 .03866 L
.34946 .03826 L
.33974 .03685 L
.33003 .03537 L
.32032 .03383 L
.31061 .03222 L
.30089 .03055 L
.29199 .02894 L
.29118 .0288 L
.28147 .02697 L
.27176 .02507 L
.26204 .02309 L
.25233 .02103 L
.24414 .01923 L
F
0 g
.8854 .01923 m
.88364 .01993 L
.87393 .02359 L
.86422 .02689 L
.85766 .02894 L
.85451 .02988 L
.84479 .0326 L
.83508 .03506 L
.82537 .03731 L
.8191 .03866 L
.81566 .03936 L
.80594 .04123 L
.79623 .04294 L
.78652 .0445 L
.77681 .04593 L
.76709 .04722 L
.75769 .04837 L
.75738 .0484 L
.74767 .04948 L
.73796 .05045 L
.72824 .05133 L
.71853 .05211 L
.70882 .05282 L
.69911 .05344 L
.68939 .05399 L
.67968 .05447 L
.66997 .05488 L
.66026 .05522 L
.65054 .0555 L
.64083 .05572 L
.63112 .05588 L
.62141 .05599 L
.61169 .05604 L
.60198 .05603 L
.59227 .05597 L
.58256 .05586 L
.57284 .0557 L
.56313 .05549 L
.55342 .05523 L
.54371 .05492 L
.53399 .05457 L
.52428 .05416 L
.51457 .05371 L
.50486 .0532 L
.49514 .05265 L
.48543 .05205 L
.47572 .0514 L
.46601 .05071 L
.45629 .04996 L
.44658 .04916 L
Mistroke
.43744 .04837 L
.43687 .04832 L
.42716 .04742 L
.41744 .04647 L
.40773 .04546 L
.39802 .0444 L
.38831 .04329 L
.37859 .04212 L
.36888 .04089 L
.35917 .0396 L
.35229 .03866 L
.34946 .03826 L
.33974 .03685 L
.33003 .03537 L
.32032 .03383 L
.31061 .03222 L
.30089 .03055 L
.29199 .02894 L
.29118 .0288 L
.28147 .02697 L
.27176 .02507 L
.26204 .02309 L
.25233 .02103 L
.24414 .01923 L
Mfstroke
.925 g
.60198 .44649 m
.61169 .44549 L
.62141 .44471 L
.63112 .44415 L
.64083 .44382 L
.65054 .44371 L
.66026 .44382 L
.66997 .44417 L
.67968 .44476 L
.68939 .4456 L
.69825 .44658 L
.69911 .44669 L
.70882 .44805 L
.71853 .44968 L
.72824 .45162 L
.73796 .45386 L
.74715 .45629 L
.74767 .45644 L
.75738 .45938 L
.76709 .46271 L
.77568 .46601 L
.77681 .46646 L
.78652 .47069 L
.79623 .47544 L
.79677 .47572 L
.80594 .48078 L
.81355 .48543 L
.81566 .4868 L
.82537 .49359 L
.82742 .49514 L
.83508 .50132 L
.83912 .50486 L
.84479 .51018 L
.84912 .51457 L
.85451 .52048 L
.85773 .52428 L
.86422 .53267 L
.86517 .53399 L
.87161 .54371 L
.87393 .54758 L
.87717 .55342 L
.88194 .56313 L
.88364 .56701 L
.88599 .57284 L
.88939 .58256 L
.89218 .59227 L
.89336 .5971 L
.89439 .60198 L
.89605 .61169 L
.89718 .62141 L
.8978 .63112 L
.89792 .64083 L
.89753 .65054 L
.89664 .66026 L
.89523 .66997 L
.89336 .67941 L
.89329 .67968 L
.89081 .68939 L
.88776 .69911 L
.8841 .70882 L
.88364 .70992 L
.87978 .71853 L
.87476 .72824 L
.87393 .72972 L
.86895 .73796 L
.86422 .74498 L
.86228 .74767 L
.85462 .75738 L
.85451 .75751 L
.84581 .76709 L
.84479 .76813 L
.83567 .77681 L
.83508 .77733 L
.82537 .78538 L
.8239 .78652 L
.81566 .79251 L
.8101 .79623 L
.80594 .79886 L
.79623 .80454 L
.79365 .80594 L
.78652 .80963 L
.77681 .81421 L
.77352 .81566 L
.76709 .81833 L
.75738 .82204 L
.74767 .82537 L
.74767 .82537 L
.73796 .82835 L
.72824 .83102 L
.71853 .83339 L
.71077 .83508 L
.70882 .83548 L
.69911 .83731 L
.68939 .8389 L
.67968 .84025 L
.66997 .84138 L
.66026 .84229 L
.65054 .843 L
.64083 .8435 L
.63112 .84381 L
.62141 .84392 L
.61169 .84384 L
.60198 .84357 L
.59227 .84311 L
.58256 .84245 L
.57284 .84161 L
.56313 .84057 L
.55342 .83933 L
.54371 .83789 L
.53399 .83623 L
.52789 .83508 L
.52428 .83436 L
.51457 .83225 L
.50486 .8299 L
.49514 .8273 L
.48854 .82537 L
.48543 .82441 L
.47572 .82124 L
.46601 .81774 L
.46064 .81566 L
.45629 .81389 L
.44658 .80965 L
.43882 .80594 L
.43687 .80497 L
.42716 .79979 L
.42102 .79623 L
.41744 .79404 L
.40773 .78762 L
.40618 .78652 L
.39802 .78038 L
.39365 .77681 L
.38831 .77214 L
.38299 .76709 L
.37859 .76258 L
.37392 .75738 L
.36888 .75122 L
.36621 .74767 L
.35969 .73796 L
.35917 .7371 L
.35423 .72824 L
.34973 .71853 L
.34946 .71787 L
.34611 .70882 L
.34329 .69911 L
.34123 .68939 L
.33988 .67968 L
.33974 .67827 L
.33921 .66997 L
.3392 .66026 L
.33974 .65145 L
.33983 .65054 L
.34108 .64083 L
.34295 .63112 L
.34545 .62141 L
.34857 .61169 L
.34946 .60925 L
.35234 .60198 L
.35677 .59227 L
.35917 .58756 L
.3619 .58256 L
.36776 .57284 L
.36888 .57111 L
.3744 .56313 L
.37859 .55754 L
.38188 .55342 L
.38831 .54588 L
.39028 .54371 L
.39802 .53564 L
.3997 .53399 L
.40773 .52651 L
.41027 .52428 L
.41744 .51828 L
.42216 .51457 L
.42716 .51082 L
.4356 .50486 L
.43687 .504 L
.44658 .49776 L
.45092 .49514 L
.45629 .49203 L
.46601 .48676 L
.46858 .48543 L
.47572 .4819 L
.48543 .47743 L
.48937 .47572 L
.49514 .47331 L
.50486 .46952 L
.51457 .46604 L
.51466 .46601 L
.52428 .46285 L
.53399 .45994 L
.54371 .45729 L
.54763 .45629 L
.55342 .4549 L
.56313 .45275 L
.57284 .45084 L
.58256 .44916 L
.59227 .44772 L
.60121 .44658 L
F
0 g
.60198 .44649 m
.61169 .44549 L
.62141 .44471 L
.63112 .44415 L
.64083 .44382 L
.65054 .44371 L
.66026 .44382 L
.66997 .44417 L
.67968 .44476 L
.68939 .4456 L
.69825 .44658 L
.69911 .44669 L
.70882 .44805 L
.71853 .44968 L
.72824 .45162 L
.73796 .45386 L
.74715 .45629 L
.74767 .45644 L
.75738 .45938 L
.76709 .46271 L
.77568 .46601 L
.77681 .46646 L
.78652 .47069 L
.79623 .47544 L
.79677 .47572 L
.80594 .48078 L
.81355 .48543 L
.81566 .4868 L
.82537 .49359 L
.82742 .49514 L
.83508 .50132 L
.83912 .50486 L
.84479 .51018 L
.84912 .51457 L
.85451 .52048 L
.85773 .52428 L
.86422 .53267 L
.86517 .53399 L
.87161 .54371 L
.87393 .54758 L
.87717 .55342 L
.88194 .56313 L
.88364 .56701 L
.88599 .57284 L
.88939 .58256 L
.89218 .59227 L
.89336 .5971 L
.89439 .60198 L
.89605 .61169 L
.89718 .62141 L
Mistroke
.8978 .63112 L
.89792 .64083 L
.89753 .65054 L
.89664 .66026 L
.89523 .66997 L
.89336 .67941 L
.89329 .67968 L
.89081 .68939 L
.88776 .69911 L
.8841 .70882 L
.88364 .70992 L
.87978 .71853 L
.87476 .72824 L
.87393 .72972 L
.86895 .73796 L
.86422 .74498 L
.86228 .74767 L
.85462 .75738 L
.85451 .75751 L
.84581 .76709 L
.84479 .76813 L
.83567 .77681 L
.83508 .77733 L
.82537 .78538 L
.8239 .78652 L
.81566 .79251 L
.8101 .79623 L
.80594 .79886 L
.79623 .80454 L
.79365 .80594 L
.78652 .80963 L
.77681 .81421 L
.77352 .81566 L
.76709 .81833 L
.75738 .82204 L
.74767 .82537 L
.74767 .82537 L
.73796 .82835 L
.72824 .83102 L
.71853 .83339 L
.71077 .83508 L
.70882 .83548 L
.69911 .83731 L
.68939 .8389 L
.67968 .84025 L
.66997 .84138 L
.66026 .84229 L
.65054 .843 L
.64083 .8435 L
.63112 .84381 L
Mistroke
.62141 .84392 L
.61169 .84384 L
.60198 .84357 L
.59227 .84311 L
.58256 .84245 L
.57284 .84161 L
.56313 .84057 L
.55342 .83933 L
.54371 .83789 L
.53399 .83623 L
.52789 .83508 L
.52428 .83436 L
.51457 .83225 L
.50486 .8299 L
.49514 .8273 L
.48854 .82537 L
.48543 .82441 L
.47572 .82124 L
.46601 .81774 L
.46064 .81566 L
.45629 .81389 L
.44658 .80965 L
.43882 .80594 L
.43687 .80497 L
.42716 .79979 L
.42102 .79623 L
.41744 .79404 L
.40773 .78762 L
.40618 .78652 L
.39802 .78038 L
.39365 .77681 L
.38831 .77214 L
.38299 .76709 L
.37859 .76258 L
.37392 .75738 L
.36888 .75122 L
.36621 .74767 L
.35969 .73796 L
.35917 .7371 L
.35423 .72824 L
.34973 .71853 L
.34946 .71787 L
.34611 .70882 L
.34329 .69911 L
.34123 .68939 L
.33988 .67968 L
.33974 .67827 L
.33921 .66997 L
.3392 .66026 L
.33974 .65145 L
Mistroke
.33983 .65054 L
.34108 .64083 L
.34295 .63112 L
.34545 .62141 L
.34857 .61169 L
.34946 .60925 L
.35234 .60198 L
.35677 .59227 L
.35917 .58756 L
.3619 .58256 L
.36776 .57284 L
.36888 .57111 L
.3744 .56313 L
.37859 .55754 L
.38188 .55342 L
.38831 .54588 L
.39028 .54371 L
.39802 .53564 L
.3997 .53399 L
.40773 .52651 L
.41027 .52428 L
.41744 .51828 L
.42216 .51457 L
.42716 .51082 L
.4356 .50486 L
.43687 .504 L
.44658 .49776 L
.45092 .49514 L
.45629 .49203 L
.46601 .48676 L
.46858 .48543 L
.47572 .4819 L
.48543 .47743 L
.48937 .47572 L
.49514 .47331 L
.50486 .46952 L
.51457 .46604 L
.51466 .46601 L
.52428 .46285 L
.53399 .45994 L
.54371 .45729 L
.54763 .45629 L
.55342 .4549 L
.56313 .45275 L
.57284 .45084 L
.58256 .44916 L
.59227 .44772 L
.60121 .44658 L
.60198 .44649 L
Mfstroke
1 g
.60198 .52375 m
.61169 .52205 L
.62141 .52072 L
.63112 .51978 L
.64083 .51921 L
.65054 .51902 L
.66026 .51921 L
.66997 .5198 L
.67968 .5208 L
.68939 .52222 L
.69911 .5241 L
.69992 .52428 L
.70882 .52647 L
.71853 .52937 L
.72824 .53287 L
.73104 .53399 L
.73796 .53703 L
.74767 .54196 L
.75075 .54371 L
.75738 .5478 L
.76535 .55342 L
.76709 .55476 L
.77677 .56313 L
.77681 .56316 L
.78591 .57284 L
.78652 .57357 L
.79327 .58256 L
.79623 .58714 L
.79917 .59227 L
.80381 .60198 L
.80594 .60743 L
.80734 .61169 L
.80986 .62141 L
.81143 .63112 L
.81209 .64083 L
.81186 .65054 L
.81075 .66026 L
.80872 .66997 L
.80594 .67915 L
.80575 .67968 L
.80176 .68939 L
.79667 .69911 L
.79623 .69986 L
.79034 .70882 L
.78652 .71385 L
.78258 .71853 L
.77681 .72468 L
.77309 .72824 L
.76709 .7335 L
.76144 .73796 L
.75738 .7409 L
.74767 .7472 L
.74688 .74767 L
.73796 .7526 L
.72824 .75725 L
.72795 .75738 L
.71853 .76126 L
.70882 .7647 L
.70098 .76709 L
.69911 .76762 L
.68939 .77008 L
.67968 .77211 L
.66997 .77373 L
.66026 .77497 L
.65054 .77585 L
.64083 .77637 L
.63112 .77655 L
.62141 .77639 L
.61169 .77588 L
.60198 .77502 L
.59227 .77381 L
.58256 .77223 L
.57284 .77027 L
.56313 .76789 L
.56021 .76709 L
.55342 .76507 L
.54371 .76177 L
.53399 .75792 L
.53273 .75738 L
.52428 .75346 L
.51457 .74826 L
.51355 .74767 L
.50486 .74219 L
.49894 .73796 L
.49514 .735 L
.48745 .72824 L
.48543 .72629 L
.47832 .71853 L
.47572 .71531 L
.47109 .70882 L
.46601 .70016 L
.46547 .69911 L
.46126 .68939 L
.4583 .67968 L
.45651 .66997 L
.45629 .66813 L
.45581 .66026 L
.45615 .65054 L
.45629 .64909 L
.45752 .64083 L
.45992 .63112 L
.46335 .62141 L
.46601 .61537 L
.46786 .61169 L
.47352 .60198 L
.47572 .59867 L
.48042 .59227 L
.48543 .58618 L
.4887 .58256 L
.49514 .57603 L
.49858 .57284 L
.50486 .56746 L
.51038 .56313 L
.51457 .56007 L
.52428 .55362 L
.5246 .55342 L
.53399 .54795 L
.54215 .54371 L
.54371 .54295 L
.55342 .53854 L
.56313 .53467 L
.56497 .53399 L
.57284 .53129 L
.58256 .52835 L
.59227 .52585 L
.59934 .52428 L
F
0 g
.60198 .52375 m
.61169 .52205 L
.62141 .52072 L
.63112 .51978 L
.64083 .51921 L
.65054 .51902 L
.66026 .51921 L
.66997 .5198 L
.67968 .5208 L
.68939 .52222 L
.69911 .5241 L
.69992 .52428 L
.70882 .52647 L
.71853 .52937 L
.72824 .53287 L
.73104 .53399 L
.73796 .53703 L
.74767 .54196 L
.75075 .54371 L
.75738 .5478 L
.76535 .55342 L
.76709 .55476 L
.77677 .56313 L
.77681 .56316 L
.78591 .57284 L
.78652 .57357 L
.79327 .58256 L
.79623 .58714 L
.79917 .59227 L
.80381 .60198 L
.80594 .60743 L
.80734 .61169 L
.80986 .62141 L
.81143 .63112 L
.81209 .64083 L
.81186 .65054 L
.81075 .66026 L
.80872 .66997 L
.80594 .67915 L
.80575 .67968 L
.80176 .68939 L
.79667 .69911 L
.79623 .69986 L
.79034 .70882 L
.78652 .71385 L
.78258 .71853 L
.77681 .72468 L
.77309 .72824 L
.76709 .7335 L
.76144 .73796 L
Mistroke
.75738 .7409 L
.74767 .7472 L
.74688 .74767 L
.73796 .7526 L
.72824 .75725 L
.72795 .75738 L
.71853 .76126 L
.70882 .7647 L
.70098 .76709 L
.69911 .76762 L
.68939 .77008 L
.67968 .77211 L
.66997 .77373 L
.66026 .77497 L
.65054 .77585 L
.64083 .77637 L
.63112 .77655 L
.62141 .77639 L
.61169 .77588 L
.60198 .77502 L
.59227 .77381 L
.58256 .77223 L
.57284 .77027 L
.56313 .76789 L
.56021 .76709 L
.55342 .76507 L
.54371 .76177 L
.53399 .75792 L
.53273 .75738 L
.52428 .75346 L
.51457 .74826 L
.51355 .74767 L
.50486 .74219 L
.49894 .73796 L
.49514 .735 L
.48745 .72824 L
.48543 .72629 L
.47832 .71853 L
.47572 .71531 L
.47109 .70882 L
.46601 .70016 L
.46547 .69911 L
.46126 .68939 L
.4583 .67968 L
.45651 .66997 L
.45629 .66813 L
.45581 .66026 L
.45615 .65054 L
.45629 .64909 L
.45752 .64083 L
Mistroke
.45992 .63112 L
.46335 .62141 L
.46601 .61537 L
.46786 .61169 L
.47352 .60198 L
.47572 .59867 L
.48042 .59227 L
.48543 .58618 L
.4887 .58256 L
.49514 .57603 L
.49858 .57284 L
.50486 .56746 L
.51038 .56313 L
.51457 .56007 L
.52428 .55362 L
.5246 .55342 L
.53399 .54795 L
.54215 .54371 L
.54371 .54295 L
.55342 .53854 L
.56313 .53467 L
.56497 .53399 L
.57284 .53129 L
.58256 .52835 L
.59227 .52585 L
.59934 .52428 L
.60198 .52375 L
Mfstroke
.55 g
.98077 .93951 m
.9773 .94192 L
.97106 .94601 L
.96173 .95163 L
.96134 .95185 L
.95163 .95711 L
.94303 .96134 L
.94192 .96187 L
.93221 .96618 L
.92249 .97011 L
.92 .97106 L
.91278 .97368 L
.90307 .97695 L
.89336 .97995 L
.89055 .98077 L
.98077 .98077 L
F
0 g
.98077 .93951 m
.9773 .94192 L
.97106 .94601 L
.96173 .95163 L
.96134 .95185 L
.95163 .95711 L
.94303 .96134 L
.94192 .96187 L
.93221 .96618 L
.92249 .97011 L
.92 .97106 L
.91278 .97368 L
.90307 .97695 L
.89336 .97995 L
.89055 .98077 L
s
0 0 0 r
.055 w
.64443 .65059 Mdot
1 0 0 r
.0325 w
.22807 .01923 Mdot
.01923 .65316 Mdot
.42806 .98077 Mdot
.18303 .78442 Mdot
.98077 .78827 Mdot
.59895 .78643 Mdot
.85255 .55126 Mdot
.70506 .68803 Mdot
.59936 .63174 Mdot
.64182 .65005 Mdot
.64456 .65062 Mdot
.64443 .65059 Mdot
.64443 .65059 Mdot
0 1 0 r
.02 w
.22807 .01923 Mdot
.01923 .65316 Mdot
.42806 .98077 Mdot
.18303 .78442 Mdot
.98077 .78827 Mdot
.59895 .78643 Mdot
.85255 .55126 Mdot
.70506 .68803 Mdot
.59936 .63174 Mdot
.64182 .65005 Mdot
.64456 .65062 Mdot
.64443 .65059 Mdot
.64443 .65059 Mdot
0 0 1 r
.5 Mabswid
.22807 .01923 m
.22807 .01923 L
.01923 .65316 L
.18303 .78442 L
.59895 .78643 L
.70506 .68803 L
.59936 .63174 L
.64182 .65005 L
.64456 .65062 L
.64443 .65059 L
.64443 .65059 L
s
.015 w
.22807 .01923 Mdot
.22807 .01923 Mdot
.01923 .65316 Mdot
.18303 .78442 Mdot
.59895 .78643 Mdot
.70506 .68803 Mdot
.59936 .63174 Mdot
.64182 .65005 Mdot
.64456 .65062 Mdot
.64443 .65059 Mdot
.64443 .65059 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00403oool2000000@0oooo0P0000040?ooo`800000<@3oool500000300oooo1@0000020?oo
o`8000000`3oool4000002/0oooo1@0000020?ooo`8000001@3oool3000002X0oooo1@0000020?oo
o`8000000`3oool3000001L0oooo000?0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool00000<P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0;P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02/0oooo00<00000
0?ooo`3oool01`3oool010000000oooo0?ooo`00000F0?ooo`003`3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo00000380oooo00<000000?ooo`3oool0<P3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool01`3oool5000002`0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000F0?ooo`003`3oool010000000oooo
0?ooo`0000090?ooo`800000<`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo0000
02d0oooo00<000000?ooo`3oool01`3oool3000001L0oooo000?0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool00000<P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0
oooo00L0oooo00@000000?ooo`3oool00000;@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0000002d0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0F0?ooo`00403oool2
000000X0oooo0P00000b0?ooo`800000<`3oool2000000X0oooo0P00000]0?ooo`8000002`3oool2
000002`0oooo0P00000:0?ooo`<000005P3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`00000;00000040oooo000E0?ooo`03
0000003oool0000000d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0;0?ooo`40
00000@3oool001D0oooo00<000000?ooo`000000>@3oool20?l003T0oooo00<000000?ooo`3oool0
>03oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01T0oooo0@0000010?ooo`003@3o
ool5000000<0oooo00<000000?ooo`3oool0=`3oool60?l00<T0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo03L0oooo00@0o`00003o0000o`000?l00P3o
00390?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool2000003L0oooo00<0o`00
003o0000o`000P000?l01000o`00o`000?l00000002Y0?ooo`030000003oool0oooo01X0oooo0P00
00010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo=01CDe<0
0`3o00000?l00000o`020000o`04003o003o0000o`0005=CD`800000YP0o?cl00`000000De=C05=C
D`0G05=CD`D0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo=@1CDe<00`00o`00003o0000o`02003o00030?l0001CDe<0De=C0080De=C1P00002M
03lo?`<000006P1CDe<50?ooo`4000000@3oool000h0oooo0P0000050?ooo`030000003oool0oooo
0080oooo=@1CDe<0103o0000003o003o0000o`020?l000X0De=C1`00002A03lo?`D000007@1CDe<5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolf05=CD`030000o`3o0000o`00
01<0De=C1@00002:03lo?`8000008P1CDe<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooole05=CD`030000o`1CDe<0De=C01T0De=C1P00001o03lo?`D00000901CDe<50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool2000003<0De=C00<0003o05=CD`1CDe<0
7`1CDe<700000780?clo1P00000Y05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`80IVIV1@00000^05=CD`030000o`1CDe<0De=C02H0De=C2`00001R03lo?`D00000;`1C
De<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool706IVIP800000:`1CDe<0
0`000?l0De=C05=CD`0b05=CD`X00000D00o?cl8000003@0De=C1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo2@1VIVH3000002P0De=C00<0003o05=CD`1CDe<0?01CDe<=0000
03H0?clo3@00000l05=CD`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo``0
IVIV1@00000S05=CD`030000o`1CDe<0De=C04T0De=C=P00001905=CD`D0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?oooa40IVIV1@00000M05=CD`030000o`1CDe<0De=C0<T0De=C
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo5P1VIVH5000001P0De=C00<0
003o05=CD`1CDe<0b@1CDe<00`000000oooo0?ooo`020?ooo`4000000@3oool001D0oooo0P000003
0?oooa/0IVIV1000000D05=CD`030000o`1CDe<0De=C0<H0De=C0`0000040?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolO06IVIPL00000301CDe<00`000?l0De=C05=CD`3505=C
D`8000000`1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolV06IVIPD0
00001`1CDe<00`000?l0De=C05=CD`3205=CD`<000001@1VIVH50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool[06IVIPL0000000<0003o05=CD`1CDe<0_@1CDe<5000000P0IVIV
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo<@1VIVH00`000?l0IVIV0000
000600000;D0De=C0`00000=06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?oooc40IVIV00<0003o06IVIP1VIVH01P1VIVH700000:L0De=C00<0000005=CD`0000001000000@
06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc40IVIV00<0003o06IV
IP1VIVH03@1VIVH;000009H0De=C2000000E06IVIPD0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?oooc00IVIV00<0003o06IVIP1VIVH06@1VIVH=00000880De=C1`00000M06IVIPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc00IVIV00<0003o06IVIP1VIVH0
9P1VIVH@000006D0De=C3@00000T06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?oooc00IVIV00<0003o06IVIP1VIVH0=P1VIVHI000003L0De=C5@00000a06IVIPD0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooc00IVIV00<0003o06IVIP1VIVH0C`1VIVHg
000004H0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;`1VIVH00`00
0?l0IVIV06IVIP3=06IVIPD0oooo0@0000010?ooo`005@3oool2000000<0oooo;`1VIVH00`000?l0
IVIV06IVIP3=06IVIP@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobl0IVIV
00<0003o06IVIP1VIVH0c@1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool^06IVIP030000o`1VIVH0IVIV0<h0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo;P1VIVH00`000?l0IVIV06IVIP3>06IVIPD0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooobh0IVIV00<0003o06IVIP1VIVH0cP1VIVH50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool]06IVIP030000o`1VIVH0IVIV0<l0IVIV1@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo;@1VIVH00`000?l0IVIV06IVIP3?06IVIPD0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobd0IVIV00<0003o06IVIP1VIVH0c`1V
IVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool/06IVIP030000o`1VIVH0
IVIV0=00IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;01VIVH00`00
0?l0IVIV06IVIP3@06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa40
IVIV6`0000000`000?l000000000003A000000@0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooa4000006P1iNGT00`000?l0NGUi07UiN@3A07UiN@D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooob/0NGUi00<0003o07UiN@1iNGT0d@1iNGT50?ooo`4000000@3o
ool001D0oooo0P0000030?ooob/0NGUi00<0003o07UiN@1iNGT0d@1iNGT40?ooo`8000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolZ07UiN@030000o`1iNGT0NGUi0=80NGUi1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo:P1iNGT00`000?l0NGUi07UiN@3B07UiN@D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobX0NGUi00<0003o07UiN@1iNGT0
dP1iNGT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolY07UiN@030000o`1i
NGT0NGUi0=<0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo:@1iNGT0
0`000?l0NGUi07UiN@3C07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
obT0NGUi00<0003o07UiN@1iNGT0d`1iNGT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolX07UiN@030000o`1iNGT0NGUi0=@0NGUi1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo:01iNGT00`000?l0NGUi07UiN@3D07UiN@D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooobP0NGUi00<0003o07UiN@1iNGT0FP1iNGTi00000440NGUi1@3o
ool100000040oooo00000`3oool000000000000300000080oooo0P0000030?ooo`@00000103oool0
0`000000oooo0?ooo`020?ooobL0NGUi00<0003o07UiN@1iNGT0A01iNGTG000003T0S8b<5000000]
07UiN@D0oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00P3ooolW07UiN@030000o`1iNGT0NGUi03@0NGUi4000001T08b<
S0`000008@1iNGT50?ooo`4000000@3oool000<0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`040?ooo`8000000`3ooolW07UiN@030000o`1iNGT0NGUi02P0NGUi3000002008b<S0T0
0000601iNGT40?ooo`8000000@3oool000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo9P1iNGT00`000?l0NGUi07UiN@0Q07UiN@P00000
U@2<S8`5000001<0NGUi1@3oool100000040oooo00030?ooo`030000003oool0oooo00L0oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooobH0NGUi00<0003o07UiN@1iNGT0
6@1iNGT800000:80S8b<1@00000>07UiN@D0oooo0@0000010?ooo`000P3oool2000000X0oooo0P00
00050?ooo`030000003oool0oooo0080oooo9P1iNGT00`000?l0NGUi07UiN@0B07UiN@L00000[`2<
S8`6000000P0NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo9@1iNGT0
0`000?l0NGUi07UiN@0<07UiN@L00000_02<S8`4000000@0NGUi1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo9@1iNGT00`000?l0NGUi07UiN@0607UiN@H00000a`2<S8`30000
000307UiN@3oool0oooo00<0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobD0
NGUi00@0003o07UiN@1iNGT0NGUi1@00003@08b<S0800000103oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo901iNGT00`000?l0NGUi0000000200000=H0S8b<1@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo8@1iNGT3000000030000o`000000S8b<0=P0S8b<
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7P1iNGT3000000<0S8b<00<0
003o08b<S02<S8`0J@2<S8`Y000004H0S8b<1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo6@1iNGT5000000D0S8b<00<0003o08b<S02<S8`0F02<S8`B000002T0WinO3`00000g
08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0NGUi0P00000:08b<
S0030000o`2<S8`0S8b<04d0S8b<2`00001:09nOW`P00000;`2<S8`50?ooo`4000000@3oool001D0
oooo0P0000030?oooa@0NGUi0`00000<08b<S0030000o`2<S8`0S8b<04D0S8b<2000001M09nOW`P0
00009`2<S8`40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolA07UiN@<00000
3P2<S8`00`000?l0S8b<08b<S00o08b<S0L00000K@2OWil500000280S8b<1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo3`1iNGT200000140S8b<00<0003o08b<S02<S8`0=`2<
S8`8000007T0WinO1@00000M08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo``0NGUi0`00000C08b<S0030000o`2<S8`0S8b<0380S8b<1@00002609nOW`D00000602<S8`5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool:07UiN@8000005P2<S8`00`00
0?l0S8b<08b<S00]08b<S0D00000T02OWil3000001D0S8b<1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo201iNGT2000001L0S8b<00<0003o08b<S02<S8`0:@2<S8`5000009P0
WinO0P00000C08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`L0NGUi
00<0000008b<S02<S8`05`2<S8`00`000?l0S8b<08b<S00V08b<S0@00000WP2OWil300000100S8b<
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1@1iNGT2000001X0S8b<00<0
003o08b<S02<S8`08@2<S8`500000:D0WinO1000000<08b<S0D0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`<0NGUi0P00000K08b<S0030000o`2<S8`0S8b<01l0S8b<0`00002^
09nOW`8000002P2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool00`1i
NGT000000000000M08b<S0030000o`2<S8`0S8b<01d0S8b<0P00001F09nOWa/00000@P2OWil20000
00P0S8b<1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<0000008b<S02<
S8`07@2<S8`00`000?l0S8b<08b<S00H08b<S0D00000B`2OWil=000001/0/k>c3@00000g09nOW`80
00001P2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolO08b<S0030000
o`2<S8`0S8b<01H0S8b<0`00001509nOW`/00000=@2c/k<800000340WinO0`00000308b<S0D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooal0S8b<00<0003o08b<S02<S8`0502<
S8`200000440WinO1`0000180;>c/`P00000;02OWil20000000308b<S03oool0oooo00<0oooo0@00
00010?ooo`005@3oool2000000<0oooo7`2<S8`00`000?l0S8b<08b<S00A08b<S0<00000?@2OWil6
000005L0/k>c1@00000Y09nOW`030000003oool0oooo0080oooo0P0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooah0S8b<00<0003o08b<S02<S8`03`2<S8`3000003T0WinO1`00001R0;>c
/`<000009`2OWil00`000000oooo0?ooo`020?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolN08b<S0030000o`2<S8`0S8b<00d0S8b<0P00000i09nOW`<00000K02c/k<4000002<0
WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7P2<S8`00`000?l0S8b<
08b<S00;08b<S0800000=P2OWil5000007<0/k>c0`00000P09nOW`D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?oooad0S8b<00<0003o08b<S02<S8`02P2<S8`2000003<0WinO1@00
001k0;>c/`<000007@2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolM
08b<S0030000o`2<S8`0S8b<00L0S8b<0`00000a09nOW`@00000P`2c/k<4000001T0WinO1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo7@2<S8`00`000?l0S8b<08b<S00608b<
S0800000<P2OWil00`000000/k>c0;>c/`280;>c/`800000602OWil50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3ooolL08b<S0030000o`2<S8`0S8b<00D0S8b<0P00000_09nOW`D0
0000S@2c/k<3000001D0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
702<S8`00`000?l0S8b<08b<S00408b<S0030000002OWil0WinO02`0WinO0`00002E0;>c/`800000
4`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolL08b<S0030000o`2<
S8`0S8b<0080S8b<0P00000/09nOW`<00000AP2c/k<N000003H0/k>c0`00000@09nOW`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooa/0S8b<00@0003o08b<S02<S8`0S8b<0P00
000/09nOW`800000?P2c/k<;000001h0a/K62P00000_0;>c/`8000003P2OWil50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolK08b<S0040000o`2<S8`0S8b<000002/0WinO0`00
000h0;>c/`P00000<`36a/H6000002X0/k>c00<0000009nOW`2OWil0302OWil50?ooo`4000000@3o
ool001D0oooo0P0000030?oooa/0S8b<00<0003o000000000000:P2OWil2000003H0/k>c1@000011
0<K6aPD000009P2c/k<2000000`0WinO103oool200000040oooo000E0?ooo`030000003oool0oooo
0080oooo6P2<S8`00`000?l0000009nOW`0X09nOW`<00000<`2c/k<5000004/0a/K61@00000S0;>c
/`8000002P2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolJ08b<S003
0000o`2OWil0WinO02H0WinO0P00000a0;>c/`D00000E@36a/H2000002<0/k>c0P00000809nOW`D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaP0S8b<0P0000000`000?l0WinO
09nOW`0T09nOW`800000;P2c/k<5000005`0a/K61@00000P0;>c/`8000001P2OWil50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolG08b<S0030000002OWil0003o02H0WinO00<0
00000;>c/`2c/k<0:`2c/k<3000006H0a/K60`00000N0;>c/`030000002OWil0WinO00@0WinO1@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo5P2<S8`010000000WinO09nOW`00
0?lS09nOW`<00000;02c/k<2000006`0a/K60`00000L0;>c/`800000102OWil50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolD08b<S08000000`2OWil00`000?l0WinO09nOW`0O
09nOW`800000:P2c/k<500000740a/K60P00000L0;>c/`040000002OWil0WinO09nOW`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?oooa<0S8b<00<0000009nOW`2OWil00P2OWil0
0`000?l0WinO09nOW`0O09nOW`030000002c/k<0/k>c02L0/k>c0`00001h0<K6aP030000002c/k<0
/k>c01X0/k>c00<0000009nOW`2OWil01@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo4`2<S8`00`000000WinO09nOW`0209nOW`030000o`2OWil0WinO01h0WinO00<000000;>c
/`2c/k<09P2c/k<2000007`0a/K60P00000K0;>c/`030000002OWil0oooo00@0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooa80S8b<00<0000009nOW`2OWil00`2OWil00`000?l0
WinO09nOW`0L09nOW`8000009P2c/k<300000800a/K60P00000J0;>c/`030000003oool0oooo00<0
oooo0@0000010?ooo`0000<0oooo0000000000000`0000020?ooo`8000001@3oool3000000<0oooo
00<000000?ooo`3oool00P3oool@08b<S08000001@2OWil00`000?l0WinO09nOW`0L09nOW`030000
002c/k<0/k>c02<0/k>c0`0000250<K6aP<00000602c/k<00`000000oooo0?ooo`020?ooo`400000
0@3oool000<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo3`2<S8`00`000000WinO09nOW`0509nOW`030000o`2OWil0WinO01T0WinO0`00
000T0;>c/`800000>P36a/HS000002h0a/K60P00000F0;>c/`D0oooo0@0000010?ooo`000`3oool0
0`000000oooo0?ooo`070?ooo`D000000`3oool2000000<0oooo3P2<S8`00`000000WinO09nOW`06
09nOW`030000o`2OWil0WinO01P0WinO00<000000;>c/`2c/k<08`2c/k<2000003H0a/K61`00000R
0=WIf@D00000:P36a/H2000001D0/k>c103oool200000040oooo00030?ooo`030000003oool0oooo
00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`h0S8b<00<00000
09nOW`2OWil01@2OWil00`000?l0WinO09nOW`0H09nOW`030000002c/k<0/k>c0280/k>c0P00000c
0<K6aPD00000;P3IfMT5000002L0a/K60P00000C0;>c/`D0oooo0@0000010?ooo`000`3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00P3oool=08b<
S0030000002OWil0WinO00H0WinO00<0003o09nOW`2OWil05`2OWil00`000000/k>c0;>c/`0Q0;>c
/`800000;`36a/H6000003P0fMWI1@00000T0<K6aP030000002c/k<0/k>c0100/k>c1@3oool10000
0040oooo00020?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool00P3oool<08b<S003
0000002OWil0WinO00L0WinO00<0003o09nOW`2OWil05@2OWil200000280/k>c0P00000/0<K6aPD0
0000@`3IfMT300000280a/K600<000000;>c/`2c/k<03`2c/k<50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool<08b<S0030000002OWil0WinO00H0WinO00<0003o09nOW`2OWil0
5@2OWil00`000000/k>c0;>c/`0P0;>c/`800000;036a/H2000004/0fMWI1000000O0<K6aP030000
002c/k<0/k>c00h0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2P2<
S8`2000000T0WinO00<0003o09nOW`2OWil0502OWil200000240/k>c0P00000X0<K6aPD00000D@3I
fMT3000001d0a/K60P00000>0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`T0S8b<00<0000009nOW`2OWil02@2OWil00`000?l0WinO09nOW`0C09nOW`030000002c/k<0
/k>c01l0/k>c0P00000W0<K6aP<00000F@3IfMT2000001d0a/K600<000000;>c/`2c/k<02`2c/k<5
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool908b<S0030000002OWil0WinO
00T0WinO00<0003o09nOW`2OWil04P2OWil00`000000/k>c0;>c/`0N0;>c/`8000009P36a/H30000
05h0fMWI0P00000L0<K6aP030000002c/k<0/k>c00X0/k>c1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo202<S8`00`000000WinO09nOW`0909nOW`030000o`2OWil0WinO0180
WinO00<000000;>c/`2c/k<07P2c/k<2000002D0a/K60P00001S0=WIf@8000006`36a/H00`000000
/k>c0;>c/`090;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P0S8b<
00<0000009nOW`2OWil02@2OWil00`000?l0WinO09nOW`0A09nOW`030000002c/k<0/k>c01d0/k>c
0P00000U0<K6aP800000I`3IfMT2000001X0a/K600<000000;>c/`2c/k<0202c/k<50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool708b<S0030000002OWil0WinO00X0WinO00<0
003o09nOW`2OWil0402OWil00`000000/k>c0;>c/`0M0;>c/`0300000036a/H0a/K60280a/K60`00
001[0=WIf@8000006@36a/H00`000000/k>c0;>c/`070;>c/`D0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`H0S8b<00<0000009nOW`2OWil02P2OWil00`000?l0WinO09nOW`0?
09nOW`8000007`2c/k<00`000000a/K60<K6aP0P0<K6aP<00000L03IfMT2000001P0a/K600<00000
0;>c/`2c/k<01P2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool508b<
S0030000002OWil0WinO00/0WinO00<0003o09nOW`2OWil03P2OWil00`000000/k>c0;>c/`0M0;>c
/`8000008@36a/H2000007D0fMWI0P00000G0<K6aP030000002c/k<0/k>c00D0/k>c1@3oool10000
0040oooo000E0?ooo`8000000`3oool508b<S0030000002OWil0WinO00/0WinO00<0003o09nOW`2O
Wil03P2OWil00`000000/k>c0;>c/`0L0;>c/`0300000036a/H0a/K60240a/K600<000000=WIf@3I
fMT0MP3IfMT00`000000a/K60<K6aP0E0<K6aP030000002c/k<0/k>c00@0/k>c103oool200000040
oooo000E0?ooo`030000003oool0oooo0080oooo102<S8`00`000000WinO09nOW`0;09nOW`030000
o`2OWil0WinO00h0WinO00<000000;>c/`2c/k<0702c/k<00`000000a/K60<K6aP0O0<K6aP<00000
>03IfMTB00000300fMWI0P00000E0<K6aP030000002c/k<0/k>c00@0/k>c1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo102<S8`00`000000WinO09nOW`0;09nOW`030000o`2O
Wil0WinO00d0WinO00<000000;>c/`2c/k<06`2c/k<200000200a/K60P00000d0=WIf@L000004P3/
k>`8000002X0fMWI00<000000<K6aP36a/H04`36a/H00`000000/k>c0;>c/`030;>c/`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0S8b<00<0000009nOW`2OWil0302OWil0
0`000?l0WinO09nOW`0<09nOW`030000002c/k<0/k>c01/0/k>c00<000000<K6aP36a/H07P36a/H2
00000300fMWI1P00000Q0>c/k0D000009P3IfMT00`000000a/K60<K6aP0C0<K6aP030000002c/k<0
/k>c0080/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0`2<S8`00`00
0000WinO09nOW`0;09nOW`030000o`2OWil0WinO00`0WinO00<000000;>c/`2c/k<06`2c/k<00`00
0000a/K60<K6aP0N0<K6aP030000003IfMT0fMWI02`0fMWI1000000/0>c/k08000009@3IfMT00`00
0000a/K60<K6aP0B0<K6aP030000002c/k<0/k>c0080/k>c1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo0P2<S8`00`000000WinO09nOW`0<09nOW`030000o`2OWil0WinO00`0
WinO00<000000;>c/`2c/k<06`2c/k<00`000000a/K60<K6aP0L0<K6aP800000;03IfMT300000380
k>c/1P00000P0=WIf@0300000036a/H0a/K60180a/K600@000000;>c/`2c/k<0/k>c1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo00<0S8b<0000002OWil03P2OWil00`000?l0
WinO09nOW`0;09nOW`030000002c/k<0/k>c01X0/k>c0P00000M0<K6aP800000:03IfMT6000003/0
k>c/0P00000O0=WIf@0300000036a/H0a/K60180a/K600<000000;>c/`2c/k<01@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo00<0S8b<0000002OWil03@2OWil00`000?l0WinO
09nOW`0;09nOW`030000002c/k<0/k>c01X0/k>c00<000000<K6aP36a/H07036a/H00`000000fMWI
0=WIf@0V0=WIf@800000@`3/k>`3000001d0fMWI0P00000C0<K6aP030000002c/k<0oooo00@0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000002OWil0WinO00d0WinO00<0
003o09nOW`2OWil02P2OWil00`000000/k>c0;>c/`0J0;>c/`0300000036a/H0a/K601`0a/K600<0
00000=WIf@3IfMT0903IfMT3000004P0k>c/0P00000M0=WIf@0300000036a/H0a/K60100a/K600<0
00000;>c/`3oool0103oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo00<00000
09nOW`2OWil03@2OWil00`000?l0WinO09nOW`0:09nOW`030000002c/k<0/k>c01X0/k>c00<00000
0<K6aP36a/H06`36a/H00`000000fMWI0=WIf@0S0=WIf@800000C@3/k>`00`000000fMWI0=WIf@0K
0=WIf@0300000036a/H0a/K60100a/K600<000000?ooo`3oool00`3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo3`2OWil00`000?l0WinO09nOW`0:09nOW`030000002c/k<0/k>c
01X0/k>c00<000000<K6aP36a/H06`36a/H00`000000fMWI0=WIf@0Q0=WIf@<00000D03/k>`20000
01/0fMWI00<000000<K6aP36a/H04036a/H00`000000oooo0?ooo`030?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool?09nOW`030000o`2OWil0WinO00T0WinO00<000000;>c/`2c
/k<06@2c/k<2000001`0a/K60P00000R0=WIf@800000E@3/k>`2000001X0fMWI00<000000<K6aP36
a/H03`36a/H00`000000oooo0?ooo`030?ooo`4000000@3oool001D0oooo0P0000030?ooo`l0WinO
00<0003o09nOW`2OWil02@2OWil00`000000/k>c0;>c/`0H0;>c/`0300000036a/H0a/K601/0a/K6
00<000000=WIf@3IfMT0803IfMT2000005T0k>c/0P00000I0=WIf@0300000036a/H0a/K600l0a/K6
00@000000?ooo`3oool0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h0WinO
00<0003o09nOW`2OWil02@2OWil00`000000/k>c0;>c/`0I0;>c/`0300000036a/H0a/K601T0a/K6
0P00000R0=WIf@800000F`3/k>`2000001T0fMWI00<000000<K6aP36a/H03P36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool>09nOW`030000o`2OWil0WinO00T0WinO00<0
00000;>c/`2c/k<0602c/k<00`000000a/K60<K6aP0I0<K6aP030000003IfMT0fMWI0200fMWI0P00
001O0>c/k08000005`3IfMT00`000000a/K60<K6aP0>0<K6aPD0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`h0WinO00<0003o09nOW`2OWil0202OWil00`000000/k>c0;>c/`0H
0;>c/`0300000036a/H0a/K601X0a/K600<000000=WIf@3IfMT07`3IfMT00`000000k>c/0>c/k01Q
0>c/k0030000003IfMT0fMWI01D0fMWI00<000000<K6aP36a/H03@36a/H50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool=09nOW`030000o`2OWil0WinO00P0WinO00<000000;>c
/`2c/k<06@2c/k<00`000000a/K60<K6aP0I0<K6aP030000003IfMT0fMWI01h0fMWI0P00001U0>c/
k0030000003IfMT0fMWI01D0fMWI00<000000<K6aP36a/H03036a/H50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool=09nOW`030000o`2OWil0WinO00P0WinO00<000000;>c/`2c
/k<05`2c/k<2000001X0a/K60P00000N0=WIf@<00000J03/k>`2000001H0fMWI00<000000<K6aP36
a/H02`36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool=09nOW`030000
o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<0602c/k<00`000000a/K60<K6aP0H0<K6aP030000
003IfMT0fMWI01d0fMWI00<000000>c/k03/k>`0JP3/k>`00`000000fMWI0=WIf@0D0=WIf@030000
0036a/H0a/K600/0a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo302O
Wil00`000?l0WinO09nOW`0809nOW`030000002c/k<0/k>c01L0/k>c00<000000<K6aP36a/H06036
a/H00`000000fMWI0=WIf@0M0=WIf@030000003/k>`0k>c/06`0k>c/00<000000=WIf@3IfMT0503I
fMT00`000000a/K60<K6aP0:0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo``0WinO00<0003o09nOW`2OWil01`2OWil00`000000/k>c0;>c/`0H0;>c/`0300000036a/H0
a/K601P0a/K600<000000=WIf@3IfMT0703IfMT00`000000k>c/0>c/k01^0>c/k0030000003IfMT0
fMWI01<0fMWI00<000000<K6aP36a/H02P36a/H50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool<09nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05`2c/k<00`00
0000a/K60<K6aP0H0<K6aP030000003IfMT0fMWI01`0fMWI00<000000>c/k03/k>`0=@3/k>`<0000
02l0k>c/00<000000=WIf@3IfMT04`3IfMT00`000000a/K60<K6aP090<K6aPD0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00<0003o09nOW`2OWil01`2OWil00`000000
/k>c0;>c/`0H0;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0703IfMT00`000000
k>c/0>c/k00_0>c/k0L00000303oool5000002/0k>c/00<000000=WIf@3IfMT04P3IfMT00`000000
a/K60<K6aP090<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO
00<0003o09nOW`2OWil01`2OWil00`000000/k>c0;>c/`0G0;>c/`0300000036a/H0a/K601P0a/K6
00<000000=WIf@3IfMT06P3IfMT2000002l0k>c/0`00000H0?ooo`H000009P3/k>`00`000000fMWI
0=WIf@0B0=WIf@0300000036a/H0a/K600P0a/K61@3oool100000040oooo000E0?ooo`8000000`3o
ool;09nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05P2c/k<00`000000a/K60<K6
aP0H0<K6aP030000003IfMT0fMWI01X0fMWI00<000000>c/k03/k>`0:P3/k>`500000240oooo0P00
000T0>c/k0030000003IfMT0fMWI0180fMWI00<000000<K6aP36a/H02036a/H40?ooo`8000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool:09nOW`030000o`2OWil0WinO00L0WinO00<00000
0;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0H0<K6aP030000003IfMT0fMWI01X0fMWI00<00000
0>c/k03/k>`0:03/k>`3000002P0oooo0`00000R0>c/k08000004`3IfMT00`000000a/K60<K6aP07
0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`X0WinO00<0003o09nO
W`2OWil01`2OWil00`000000/k>c0;>c/`0F0;>c/`0300000036a/H0a/K601L0a/K600<000000=WI
f@3IfMT06`3IfMT00`000000k>c/0>c/k00V0>c/k0800000;P3oool200000240k>c/00<000000=WI
f@3IfMT04@3IfMT00`000000a/K60<K6aP070<K6aPD0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooo`X0WinO00<0003o09nOW`2OWil01P2OWil00`000000/k>c0;>c/`0F0;>c/`03
00000036a/H0a/K601P0a/K600<000000=WIf@3IfMT06@3IfMT2000002L0k>c/0P00000b0?ooo`80
00006P3/k>`20?l000@0k>c/00<000000=WIf@3IfMT0403IfMT00`000000a/K60<K6aP070<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0WinO00<0003o09nOW`2OWil0
1`2OWil00`000000/k>c0;>c/`0F0;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0
6@3IfMT00`000000k>c/0>c/k00V0>c/k0030000003oool0oooo03@0oooo00<000000>c/k03/k>`0
5@3/k>`20?l000<00?l000@0o`000>c/k03/k>`000004`3IfMT00`000000a/K60<K6aP060<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0WinO00<0003o09nOW`2OWil0
1P2OWil00`000000/k>c0;>c/`0F0;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT0
6@3IfMT00`000000k>c/0>c/k00T0>c/k0<00000>03oool2000001D0k>c/00<0o`00003o0000o`00
0`00o`030>c/k0030000003IfMT0fMWI0100fMWI00<000000<K6aP36a/H01P36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool909nOW`030000o`2OWil0WinO00H0WinO00<0
00000;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01T0fMWI00<0
00000>c/k03/k>`08`3/k>`2000003d0oooo0P00000B0>c/k080o`001@00o`001@3o0000k>c/0>c/
k03/k>`000000180fMWI00<000000<K6aP36a/H01@36a/H50?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool809nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05P2c
/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`08P3/
k>`200000440oooo00<000000>c/k03/k>`03`3/k>`20?l000D00?l000D0o`000>c/k03/k>`0k>c/
0000000B0=WIf@0300000036a/H0a/K600D0a/K61@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo202OWil00`000?l0WinO09nOW`0609nOW`030000002c/k<0/k>c01H0/k>c00<0
00000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/k>`0k>c/0280k>c/00<0
00000?ooo`3oool0@P3oool00`000000k>c/0>c/k00?0>c/k080o`000`00o`000`3o0000k>c/0>c/
k0030>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01@36a/H50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool809nOW`030000o`2OWil0WinO00H0WinO00<00000
0;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01P0fMWI00<00000
0>c/k03/k>`08@3/k>`00`000000oooo0?ooo`140?ooo`030000003/k>`0k>c/00h0k>c/1P3o0005
0>c/k0030000003IfMT0fMWI00l0fMWI0P0000060<K6aPD0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`L0WinO00<0003o09nOW`2OWil01`2OWil00`000000/k>c0;>c/`0E0;>c
/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT0603IfMT00`000000k>c/0>c/k00Q0>c/
k0030000003oool0oooo04H0oooo00<000000>c/k03/k>`03`3/k>`20?l000L0k>c/00<000000=WI
f@3IfMT0403IfMT00`000000a/K60<K6aP040<K6aPD0oooo0@0000010?ooo`0000<0oooo00000000
00000`0000020?ooo`8000000`3oool3000000D0oooo00<000000?ooo`3oool00P3oool709nOW`03
0000o`2OWil0WinO00H0WinO00<000000;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0F0<K6aP03
0000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`0803/k>`00`000000oooo0?ooo`180?ooo`03
0000003/k>`0k>c/01L0k>c/00<000000=WIf@3IfMT0403IfMT00`000000a/K60<K6aP040<K6aPD0
oooo0@0000010?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3oool709nOW`030000o`2OWil0WinO00H0WinO00<000000;>c/`2c
/k<05P2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/
k>`07`3/k>`2000004`0oooo00<000000>c/k03/k>`05`3/k>`00`000000fMWI0=WIf@0?0=WIf@03
00000036a/H0a/K600@0a/K61@3oool100000040oooo00030?ooo`030000003oool0oooo00L0oooo
00@000000?ooo`3oool00000103oool2000000<0oooo1`2OWil00`000?l0WinO09nOW`0509nOW`03
0000002c/k<0/k>c01H0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0H0=WIf@03
0000003/k>`0k>c/01l0k>c/00<000000?ooo`3oool0C03oool00`000000k>c/0>c/k00G0>c/k003
0000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01036a/H40?ooo`8000000@3oool000<0oooo
00<000000?ooo`3oool01`3oool3000000D0oooo00<000000?ooo`3oool00P3oool609nOW`030000
o`2OWil0WinO00H0WinO00<000000;>c/`2c/k<05P2c/k<00`000000a/K60<K6aP0E0<K6aP030000
003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`07`3/k>`00`000000oooo0?ooo`1=0?ooo`030000
003/k>`0k>c/01L0k>c/00<000000=WIf@3IfMT03`3IfMT00`000000a/K60<K6aP030<K6aPD0oooo
0@0000010?ooo`000`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00P3oool609nOW`030000o`2OWil0WinO00H0WinO00<000000;>c/`2c/k<05P2c
/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0fMWI00<000000>c/k03/k>`07`3/
k>`00`000000oooo0?ooo`1?0?ooo`030000003/k>`0k>c/01H0k>c/00<000000=WIf@3IfMT03`3I
fMT00`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`000P3oool2000000X0oooo0`000004
0?ooo`030000003oool0oooo0080oooo1P2OWil00`000?l0WinO09nOW`0609nOW`030000002c/k<0
/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/k>`0
k>c/01h0k>c/00<000000?ooo`3oool0D03oool00`000000k>c/0>c/k00G0>c/k0030000003IfMT0
fMWI00h0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool509nOW`030000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05@2c/k<00`00
0000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`07@3/k>`00`00
0000oooo0?ooo`1B0?ooo`030000003/k>`0k>c/01H0k>c/00<000000=WIf@3IfMT03P3IfMT00`00
0000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`D0
WinO00<0003o09nOW`2OWil01P2OWil00`000000/k>c0;>c/`0E0;>c/`0300000036a/H0a/K601D0
a/K600<000000=WIf@3IfMT0603IfMT00`000000k>c/0>c/k00M0>c/k0030000003oool0oooo05<0
oooo00<000000>c/k03/k>`05P3/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600<0
a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1@2OWil00`000?l0WinO
09nOW`0609nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI
0=WIf@0G0=WIf@030000003/k>`0k>c/01h0k>c/00<000000?ooo`3oool0E03oool00`000000k>c/
0>c/k00E0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool409nOW`030000o`2OWil0WinO00L0WinO00<0
00000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0fMWI00<0
00000>c/k03/k>`07@3/k>`00`000000oooo0?ooo`1E0?ooo`030000003/k>`0k>c/01D0k>c/00<0
00000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`@0WinO00<0003o09nOW`2OWil01P2OWil00`000000/k>c0;>c/`0E
0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M
0>c/k0030000003oool0oooo05H0oooo00<000000>c/k03/k>`05@3/k>`00`000000fMWI0=WIf@0>
0=WIf@0300000036a/H0a/K60080a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo102OWil00`000?l0WinO09nOW`0609nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01d0k>c/00<000000?oo
o`3oool0E`3oool00`000000k>c/0>c/k00E0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6
aP36a/H00P36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool309nOW`03
0000o`2OWil0WinO00L0WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP03
0000003IfMT0fMWI01L0fMWI00<000000>c/k03/k>`07@3/k>`00`000000oooo0?ooo`1G0?ooo`03
0000003/k>`0k>c/01D0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP020<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0WinO00<0003o09nOW`2OWil0
1`2OWil00`000000/k>c0;>c/`0E0;>c/`0300000036a/H0a/K601D0a/K600<000000=WIf@3IfMT0
5`3IfMT00`000000k>c/0>c/k00L0>c/k0030000003oool0oooo0200oooo0P3o000g0?ooo`030000
003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP020<K6aPD0oooo
0@0000010?ooo`005@3oool2000000<0oooo0`2OWil00`000?l0WinO09nOW`0709nOW`030000002c
/k<0/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/
k>`0k>c/01`0k>c/00<000000?ooo`3oool07P3oool20?l000<00?l000<0o`000?ooo`3oool0<`3o
ool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00P36
a/H40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3oool209nOW`030000o`2OWil0
WinO00L0WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0
fMWI01L0fMWI00<000000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0O0?ooo`030?l00000o`00
0?l000<00?l01P3oool6000002T0oooo00<000000>c/k03/k>`0503/k>`00`000000fMWI0=WIf@0>
0=WIf@0300000036a/H0a/K60080a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo0P2OWil00`000?l0WinO09nOW`0709nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?oo
o`3oool07P3oool20?l000800?l00P000?l00`00o`00o`000?ooo`030?ooo`P00000:03oool00`00
0000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00P36a/H50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool209nOW`030000o`2OWil0WinO00L0
WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0
fMWI00<000000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0N0?ooo`80o`0000<00?l00000o`00
0?l00`000?l30?ooo`X000009`3oool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0
fMWI00<000000<K6aP36a/H00P36a/H50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3oool00`2OWil0003o09nOW`0909nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6aP36a/H0
5@36a/H00`000000fMWI0=WIf@0F0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?ooo`3oool0
803oool20?l00004003o00000?l00?l00?l000<0003o100000030?l000D000009P3oool00`000000
k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00P36a/H50?ooo`40
00000@3oool001D0oooo00@000000?ooo`3oool0oooo0P3o00000`000?l0WinO09nOW`0809nOW`03
0000002c/k<0/k>c01D0/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0F0=WIf@03
0000003/k>`0k>c/01`0k>c/00<000000?ooo`3oool0803oool60?l00080oooo0`000?l20?l000@0
0?l000@0o`0000000000000000009P3oool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0fMWI
00h0fMWI00<000000<K6aP36a/H00P36a/H50?ooo`4000000@3oool001D0oooo00@000000?ooo`3o
0000o`000P00o`000`000?l0o`0009nOW`0809nOW`030000002c/k<0/k>c01@0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?oo
o`3oool08P3oool20?l000@0oooo0P0000030000o`03003o00000?l00?l000800?l01000000U0?oo
o`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP020<K6
aPD0oooo0@0000010?ooo`005@3oool010000000oooo0?l00000o`020000o`800?l02@2OWil00`00
0000/k>c0;>c/`0D0;>c/`0300000036a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`00
0000k>c/0>c/k00L0>c/k0030000003oool0oooo02P0oooo0P0000020?l000@0003o0P00o`00103o
0000000000000000000U0?ooo`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3IfMT0
0`000000a/K60<K6aP020<K6aPD0oooo0@0000010?ooo`005@3oool00`000000o`000?l000030000
o`800?l000<0o`0009nOW`2OWil01P2OWil00`000000/k>c0;>c/`0D0;>c/`0300000036a/H0a/K6
01D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00L0>c/k0030000003oool0oooo
02P0oooo0P0000020?l000800?l00`000?l00`00o`00o`0000000002000002D0oooo00<000000>c/
k03/k>`0503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K60080a/K61@3oool10000
0040oooo000E0?ooo`090000003o0000o`00003o00000?l00?l00000o`00o`00o`0000L0WinO00<0
00000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E0<K6aP030000003IfMT0fMWI01L0fMWI00<0
00000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0X0?ooo`<000000P3o0002003o0080003o00<0
o`000000000000000P00000U0?ooo`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3I
fMT00`000000a/K60<K6aP020<K6aPD0oooo0@0000010?ooo`005@3oool010000000oooo0?l0003o
0003003o0080003o1`2OWil00`000000/k>c0;>c/`0E0;>c/`0300000036a/H0a/K601D0a/K600<0
00000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00L0>c/k0030000003oool0oooo02P0oooo0`00
00060?l00080003o0P00000V0?ooo`030000003/k>`0k>c/01@0k>c/00<000000=WIf@3IfMT03P3I
fMT00`000000a/K60<K6aP020<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?l00005
0?l0000309nOW`000?l0WinO00D0WinO00<000000;>c/`2c/k<05@2c/k<00`000000a/K60<K6aP0E
0<K6aP030000003IfMT0fMWI01L0fMWI00<000000>c/k03/k>`0703/k>`00`000000oooo0?ooo`0Y
0?ooo`@000000`3o000300000080003o9P3oool00`000000k>c/0>c/k00D0>c/k0030000003IfMT0
fMWI00d0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`4000000@3oool001D0oooo0P0000020?oo
o`80o`00102OWil00`000?l0WinO09nOW`0309nOW`030000002c/k<0/k>c01D0/k>c00<000000<K6
aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0k>c/00<000000?oo
o`3oool0:P3oool:000000030?ooo`000?l0003o02@0oooo00<000000>c/k03/k>`0503/k>`00`00
0000fMWI0=WIf@0=0=WIf@0300000036a/H0a/K600<0a/K6103oool200000040oooo000E0?ooo`03
0000003oool0oooo0080oooo1P2OWil00`000?l0WinO09nOW`0209nOW`030000002c/k<0/k>c01D0
/k>c00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01`0
k>c/00<000000?ooo`3oool0:`3oool8000000@0oooo0P000?lR0?ooo`030000003/k>`0k>c/01@0
k>c/00<000000=WIf@3IfMT03@3IfMT00`000000a/K60<K6aP030<K6aPD0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooo`L0WinO00D0003o09nOW`2OWil0WinO0000000G0;>c/`03
00000036a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k003
0000003oool0oooo02/0oooo1P0000070?ooo`80003o0`3oool20?l001X0oooo00<000000>c/k03/
k>`0503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600<0a/K61@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo202OWil20000o`0309nOW`000000/k>c01H0/k>c
00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01d0k>c/
00<000000?ooo`3oool0>P3oool20000o`050?l00000o`000?l0003o003o0000603oool00`000000
k>c/0>c/k00D0>c/k0030000003IfMT0fMWI00h0fMWI00<000000<K6aP36a/H00`36a/H50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool:09nOW`030000o`000000/k>c01H0/k>c
00<000000<K6aP36a/H05@36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/01d0k>c/
00<000000?ooo`3oool0>`3oool00`3o0000003o0000o`03003o01L0oooo00<000000>c/k03/k>`0
503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000?l0/k>c0;>c/`0E0;>c/`0300000036
a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k0030000003o
ool0oooo03X0oooo0P3o0002003o00040000o`00o`000?l00?l001H0oooo00<000000>c/k03/k>`0
503/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000003o0;>c/`0E0;>c/`0300000036
a/H0a/K601D0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k0030000003o
ool0oooo03X0oooo0P3o00001P00o`00003o0000o`000?l00?l00?l001D0oooo00<000000>c/k03/
k>`05@3/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo2`2OWil010000000/k>c0000o`000?lD0;>c/`03
00000036a/H0a/K601H0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M0>c/k003
0000003oool0oooo03X0oooo00H0o`000000o`00o`00003o003o003o000F0?ooo`030000003/k>`0
k>c/01D0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP040<K6aPD0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00D000000;>c/`2c/k<0/k>c0000o`0C
0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT05`3IfMT00`000000k>c/0>c/k00M
0>c/k0800000>`3oool00`000?l0o`000?l000030?l001D0oooo00<000000>c/k03/k>`05P3/k>`0
0`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`020;>c/`030000o`2c/k<0/k>c
0100/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0G0=WIf@030000003/k>`0k>c/
01h0k>c/00<000000?ooo`3oool0>03oool00`000?l0oooo0?ooo`020?l001L0oooo00<000000>c/
k03/k>`05P3/k>`00`000000fMWI0=WIf@0>0=WIf@0300000036a/H0a/K600@0a/K61@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`030;>c/`03
0000o`2c/k<0/k>c00l0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@03
0000003/k>`0k>c/01h0k>c/00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0I0?ooo`03
0000003/k>`0k>c/01H0k>c/00<000000=WIf@3IfMT03P3IfMT00`000000a/K60<K6aP050<K6aPD0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00<000000;>c/`2c/k<0
102c/k<20000o`l0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000
003/k>`0k>c/01h0k>c/00<000000?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0J0?ooo`030000
003/k>`0k>c/01D0k>c/0P00000@0=WIf@0300000036a/H0a/K600D0a/K61@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`060;>c/`030000o`2c
/k<0/k>c00`0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/
k>`0k>c/01l0k>c/00<000000?ooo`3oool0<P3oool20000oa`0oooo00<000000>c/k03/k>`05@3/
k>`00`000000fMWI0=WIf@0?0=WIf@0300000036a/H0a/K600H0a/K61@3oool100000040oooo000E
0?ooo`8000000`3oool;09nOW`030000002c/k<0/k>c00L0/k>c00<0003o0;>c/`2c/k<0302c/k<0
0`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01P0fMWI00<000000>c/k03/k>`07`3/k>`0
0`000000oooo0?ooo`0`0?ooo`030000o`3oool0oooo01/0oooo00<000000>c/k03/k>`05P3/k>`0
0`000000fMWI0=WIf@0?0=WIf@0300000036a/H0a/K600H0a/K6103oool200000040oooo000E0?oo
o`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`080;>c/`030000o`2c/k<0/k>c
00/0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0H0=WIf@030000003/k>`0k>c/
0200k>c/00<000000?ooo`3oool0;P3oool00`000?l0oooo0?ooo`0K0?ooo`030000003/k>`0k>c/
01L0k>c/00<000000=WIf@3IfMT03`3IfMT00`000000a/K60<K6aP060<K6aPD0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo`/0WinO00<000000;>c/`2c/k<02@2c/k<00`000?l0
/k>c0;>c/`0:0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT06@3IfMT00`000000
k>c/0>c/k00P0>c/k0030000003oool0oooo02`0oooo00<0003o0?ooo`3oool06`3oool00`000000
k>c/0>c/k00G0>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01`36a/H50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool;09nOW`030000002c/k<0/k>c00X0/k>c
0P000?l:0;>c/`0300000036a/H0a/K601H0a/K600<000000=WIf@3IfMT06@3IfMT00`000000k>c/
0>c/k00P0>c/k0030000003oool0oooo02/0oooo00<0003o0?ooo`3oool06`3oool00`000000k>c/
0>c/k00H0>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H01`36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool;09nOW`030000002c/k<0/k>c00`0/k>c00<0
003o0;>c/`2c/k<01`2c/k<00`000000a/K60<K6aP0G0<K6aP030000003IfMT0fMWI01P0fMWI00<0
00000>c/k03/k>`08@3/k>`00`000000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo01/0oooo00<0
00000>c/k03/k>`0603/k>`00`000000fMWI0=WIf@0@0=WIf@0300000036a/H0a/K600L0a/K61@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2`2OWil00`000000/k>c0;>c/`0=
0;>c/`030000o`2c/k<0/k>c00L0/k>c00<000000<K6aP36a/H05P36a/H00`000000fMWI0=WIf@0I
0=WIf@030000003/k>`0k>c/0240k>c/0P00000X0?ooo`030000o`3oool0oooo01X0oooo0P00000K
0>c/k0030000003IfMT0fMWI00l0fMWI00<000000<K6aP36a/H02036a/H50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3oool;09nOW`030000002c/k<0/k>c00h0/k>c00<0003o0;>c
/`2c/k<01P2c/k<00`000000a/K60<K6aP0F0<K6aP030000003IfMT0fMWI01X0fMWI00<000000>c/
k03/k>`08P3/k>`2000002D0oooo00<0003o0?ooo`3oool06P3oool00`000000k>c/0>c/k00J0>c/
k0030000003IfMT0fMWI0100fMWI00<000000<K6aP36a/H02036a/H50?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool<09nOW`030000002c/k<0/k>c00h0/k>c0P000?l60;>c/`03
00000036a/H0a/K601L0a/K600<000000=WIf@3IfMT06@3IfMT00`000000k>c/0>c/k00T0>c/k003
0000003oool0oooo0240oooo00<0003o0?ooo`3oool06@3oool2000001`0k>c/00<000000=WIf@3I
fMT0403IfMT00`000000a/K60<K6aP090<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?ooo``0WinO00<000000;>c/`2c/k<0402c/k<00`000?l0/k>c0;>c/`030;>c/`030000
0036a/H0a/K601L0a/K600<000000=WIf@3IfMT06P3IfMT00`000000k>c/0>c/k00T0>c/k0800000
803oool00`000?l0oooo0?ooo`0I0?ooo`030000003/k>`0k>c/01`0k>c/00<000000=WIf@3IfMT0
403IfMT00`000000a/K60<K6aP090<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo``0WinO00<000000;>c/`2c/k<04@2c/k<00`000?l0/k>c0;>c/`020;>c/`0300000036
a/H0a/K601L0a/K600<000000=WIf@3IfMT06`3IfMT00`000000k>c/0>c/k00U0>c/k08000007@3o
ool00`000?l0oooo0?ooo`0G0?ooo`<000007P3/k>`00`000000fMWI0=WIf@0@0=WIf@0300000036
a/H0a/K600X0a/K61@3oool100000040oooo00000`3oool000000000000300000080oooo0P000004
0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo``0WinO00<000000;>c/`2c/k<04P2c/k<0
0`000?l0/k>c0;>c/`020;>c/`0300000036a/H0a/K601L0a/K600<000000=WIf@3IfMT06P3IfMT0
0`000000k>c/0>c/k00W0>c/k0030000003oool0oooo01T0oooo00<0003o0?ooo`3oool05P3oool2
00000240k>c/00<000000=WIf@3IfMT0403IfMT00`000000a/K60<K6aP0:0<K6aPD0oooo0@000001
0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00P3oool<09nOW`030000002c/k<0/k>c01<0/k>c0P000?l20;>c/`8000006@36a/H0
0`000000fMWI0=WIf@0J0=WIf@030000003/k>`0k>c/02L0k>c/0P00000H0?ooo`030000o`3oool0
oooo01L0oooo00<000000>c/k03/k>`07`3/k>`00`000000fMWI0=WIf@0A0=WIf@0300000036a/H0
a/K600X0a/K61@3oool100000040oooo00030?ooo`030000003oool0oooo00L0oooo00@000000?oo
o`3oool00000103oool2000000<0oooo302OWil00`000000/k>c0;>c/`0E0;>c/`040000o`2c/k<0
/k>c000001T0a/K600<000000=WIf@3IfMT06`3IfMT00`000000k>c/0>c/k00X0>c/k0<000004`3o
ool20000oaD0oooo1@00000P0>c/k08000004`3IfMT00`000000a/K60<K6aP0;0<K6aP@0oooo0P00
00010?ooo`000`3oool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`02
0?ooo`d0WinO00<000000;>c/`2c/k<05@2c/k<00`000?l0/k>c0000000J0<K6aP030000003IfMT0
fMWI01/0fMWI0P00000[0>c/k0D000003@3oool00`000?l0oooo0?ooo`0B0?ooo`<00000903/k>`0
0`000000fMWI0=WIf@0B0=WIf@0300000036a/H0a/K600`0a/K61@3oool100000040oooo00030?oo
o`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`02
0?ooo`d0WinO00<000000;>c/`2c/k<05P2c/k<00`000?l000000<K6aP020<K6aP80o`005P36a/H0
0`000000fMWI0=WIf@0L0=WIf@030000003/k>`0k>c/02d0k>c/1@0000070?ooo`030000o`3oool0
oooo00h0oooo1@00000V0>c/k0030000003IfMT0fMWI01<0fMWI00<000000<K6aP36a/H03036a/H5
0?ooo`4000000@3oool00080oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
o`h0WinO00<000000;>c/`2c/k<05P2c/k<00`000?l000000?l000050?l001@0a/K600<000000=WI
f@3IfMT0703IfMT00`000000k>c/0>c/k00b0>c/k08000000P3o0002000000030000o`000000oooo
00L0oooo2000000[0>c/k0030000003IfMT0fMWI0180fMWI00<000000<K6aP36a/H03@36a/H00`00
0000oooo0?ooo`020?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool>09nOW`03
0000002c/k<0/k>c01L0/k>c0P000?l3003o0080o`005@36a/H00`000000fMWI0=WIf@0L0=WIf@03
0000003/k>`0k>c/0340k>c/0P3o0003003o00030000o`3/k>`0k>c/00P00000<P3/k>`00`000000
fMWI0=WIf@0B0=WIf@0300000036a/H0a/K600d0a/K60P3o00040?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool>09nOW`030000002c/k<0/k>c01L0/k>c00@0o`00003o00000?l0
003o0P00o`020?l001D0a/K600<000000=WIf@3IfMT0703IfMT200000340k>c/00H0o`00003o0000
o`000?l00000o`00o`0j0>c/k0800000503IfMT00`000000a/K60<K6aP0<0<K6aP80o`000`00o`00
103o0000oooo0?ooo`0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h0WinO00<00000
0;>c/`2c/k<05`2c/k<00`3o00000?l00000o`1`0000o`800?l000<0o`000>c/k03/k>`0=P3/k>`0
0`000000fMWI0=WIf@0C0=WIf@0300000036a/H0a/K600d0a/K600<0o`00003o0000o`000`00o`02
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool>09nOW`030000002c/k<0/k>c
01P0/k>c0P00o`0010000?l00?l0003o003o000H0<K6aP030000003IfMT0fMWI01d0fMWI0P00000]
0>c/k080o`000`000?l2003o00030?l0003/k>`0k>c/03@0k>c/0P00000E0=WIf@0300000036a/H0
a/K600d0a/K60P3o0005003o00030?l0003oool000000040oooo000E0?ooo`030000003oool0oooo
0080oooo3`2OWil00`000000/k>c0;>c/`0G0;>c/`040?l00000o`000?l0003o0080o`006036a/H0
0`000000fMWI0=WIf@0O0=WIf@800000;03/k>`20?l000040000o`00o`000?l00?l003H0k>c/00<0
00000=WIf@3IfMT05@3IfMT00`000000a/K60<K6aP0=0<K6aP80o`001@00o`000`3o0000oooo0000
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`l0WinO00<000000;>c/`2c/k<06@2c/k<2
0?l001/0a/K600<000000=WIf@3IfMT0803IfMT00`000000k>c/0>c/k00Y0>c/k0H0o`00=@3/k>`0
0`000000fMWI0=WIf@0E0=WIf@0300000036a/H0a/K600l0a/K60P3o0003003o00040?l0003oool0
oooo00000040oooo000E0?ooo`030000003oool0oooo0080oooo402OWil00`000000/k>c0;>c/`0I
0;>c/`0300000036a/H0a/K601X0a/K60P00000Q0=WIf@800000:`3/k>`20?l003D0k>c/0P00000G
0=WIf@0300000036a/H0a/K600l0a/K600<000000?l0003o0000103o00020?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolA09nOW`030000002c/k<0/k>c01T0/k>c00<000000<K6
aP36a/H06`36a/H00`000000fMWI0=WIf@0P0=WIf@800000GP3/k>`2000001P0fMWI00<000000<K6
aP36a/H04036a/H00`000000/k>c0;>c/`020?l000@0oooo0@0000010?ooo`005@3oool2000000<0
oooo4@2OWil00`000000/k>c0;>c/`0I0;>c/`0300000036a/H0a/K601`0a/K600<000000=WIf@3I
fMT08@3IfMT2000005X0k>c/0P00000I0=WIf@0300000036a/H0a/K60100a/K600<000000;>c/`2c
/k<00P2c/k<40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolB09nOW`030000
002c/k<0/k>c01T0/k>c00<000000<K6aP36a/H07036a/H00`000000fMWI0=WIf@0R0=WIf@800000
EP3/k>`2000001X0fMWI00<000000<K6aP36a/H04036a/H00`000000/k>c0;>c/`030;>c/`D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa80WinO00<000000;>c/`2c/k<06P2c
/k<00`000000a/K60<K6aP0L0<K6aP030000003IfMT0fMWI02<0fMWI0P00001B0>c/k08000006`3I
fMT00`000000a/K60<K6aP0A0<K6aP030000002c/k<0/k>c00<0/k>c1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo4P2OWil00`000000/k>c0;>c/`0K0;>c/`0300000036a/H0
a/K601`0a/K60P00000U0=WIf@D00000B`3/k>`2000001`0fMWI00<000000<K6aP36a/H04@36a/H0
0`000000/k>c0;>c/`040;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa<0WinO00<000000;>c/`2c/k<06`2c/k<00`000000a/K60<K6aP0M0<K6aP030000003IfMT0fMWI
02L0fMWI0P0000150>c/k0@000007@3IfMT00`000000a/K60<K6aP0A0<K6aP030000002c/k<0/k>c
00D0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo4`2OWil00`000000
/k>c0;>c/`0L0;>c/`0300000036a/H0a/K601d0a/K600<000000=WIf@3IfMT0:03IfMT3000003h0
k>c/1@00000O0=WIf@0300000036a/H0a/K60180a/K600<000000;>c/`2c/k<01@2c/k<50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3ooolD09nOW`8000007@2c/k<00`000000a/K6
0<K6aP0M0<K6aP800000:`3IfMT5000003L0k>c/0P00000R0=WIf@8000004`36a/H2000000P0/k>c
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo5@2OWil00`000000/k>c0;>c
/`0L0;>c/`0300000036a/H0a/K601h0a/K60P00000^0=WIf@D00000;03/k>`600000280fMWI0P00
000D0<K6aP030000002c/k<0/k>c00P0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo5P2OWil00`000000/k>c0;>c/`0L0;>c/`0300000036a/H0a/K601l0a/K60P00000a
0=WIf@D000008P3/k>`5000002L0fMWI0P00000D0<K6aP030000002c/k<0/k>c00T0/k>c1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo5P2OWil2000001h0/k>c00<000000<K6
aP36a/H08036a/H2000003@0fMWI8P00000Z0=WIf@8000005@36a/H00`000000/k>c0;>c/`0:0;>c
/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0WinO00<000000;>c/`2c
/k<07@2c/k<00`000000a/K60<K6aP0Q0<K6aP030000003IfMT0fMWI07`0fMWI00<000000<K6aP36
a/H05@36a/H00`000000/k>c0;>c/`0:0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`020?oooaP0WinO00<000000;>c/`2c/k<07@2c/k<200000280a/K60P00001j0=WIf@800000
5`36a/H00`000000/k>c0;>c/`0;0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?oooaT0WinO00<000000;>c/`2c/k<07P2c/k<200000280a/K60`00001d0=WIf@<000005`36
a/H2000000h0/k>c1@3oool100000040oooo000E0?ooo`8000000`3ooolJ09nOW`030000002c/k<0
/k>c01h0/k>c0P00000T0<K6aP<00000K`3IfMT2000001T0a/K600<000000;>c/`2c/k<03P2c/k<4
0?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolK09nOW`030000002c/k<0/k>c
01l0/k>c0P00000U0<K6aP800000J`3IfMT2000001X0a/K600<000000;>c/`2c/k<03`2c/k<50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolL09nOW`030000002c/k<0/k>c0200
/k>c00<000000<K6aP36a/H09036a/H3000006D0fMWI0`00000K0<K6aP030000002c/k<0/k>c0100
/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7@2OWil200000240/k>c
0P00000W0<K6aPD00000G@3IfMT3000001`0a/K60P00000C0;>c/`030000003oool0oooo0080oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooal0WinO00<000000;>c/`2c/k<0802c
/k<2000002X0a/K60`00001F0=WIf@@000007@36a/H2000001@0/k>c00<000000?ooo`3oool00`3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo802OWil00`000000/k>c0;>c/`0Q
0;>c/`800000:`36a/H5000004d0fMWI1@00000N0<K6aP8000005@2c/k<00`000000WinO0?ooo`04
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ09nOW`030000002c/k<0/k>c
0280/k>c00<000000<K6aP36a/H0;@36a/H5000004H0fMWI0P00000R0<K6aP030000002c/k<0/k>c
01@0/k>c00<0000009nOW`2OWil01@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo8P2OWil00`000000/k>c0;>c/`0R0;>c/`<00000<@36a/H5000003`0fMWI1@00000R0<K6aP80
00005P2c/k<010000000WinO09nOW`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolS09nOW`8000009@2c/k<2000003@0a/K62000000/0=WIf@P000009@36a/H2000001L0
/k>c00<0000009nOW`2OWil00P2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolU09nOW`030000002c/k<0/k>c02@0/k>c0P00000j0<K6aPX00000603IfMT:000002`0a/K6
00<000000;>c/`2c/k<05P2c/k<00`000000WinO09nOW`0309nOW`D0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`030000002OWil0WinO02<0WinO0P00000V0;>c/`<00000@@36
a/HH000003<0a/K60`00000H0;>c/`030000002OWil0WinO00@0WinO1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo00<0S8b<0000002OWil09@2OWil2000002L0/k>c0`000027
0<K6aP8000006@2c/k<2000000L0WinO1@3oool100000040oooo000E0?ooo`8000000`3oool208b<
S08000009P2OWil2000002P0/k>c1@00001o0<K6aP<000006P2c/k<00`000000WinO09nOW`0709nO
W`@0oooo0P0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`@0S8b<00<0000009nOW`2O
Wil09@2OWil00`000000/k>c0;>c/`0Z0;>c/`<00000N@36a/H3000001/0/k>c0P00000:09nOW`D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`D0S8b<00<0000009nOW`2OWil0
9@2OWil2000002d0/k>c0P00001e0<K6aP8000007@2c/k<00`000000WinO09nOW`0:09nOW`D0oooo
0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`H0S8b<00<0000009nOW`2OWil09P2O
Wil4000002/0/k>c1P00001Z0<K6aPD000007@2c/k<2000000d0WinO1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo1`2<S8`2000002X0WinO0P00000_0;>c/`D00000HP36a/H3
00000200/k>c0P00000?09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`T0S8b<00<0000009nOW`2OWil0:@2OWil300000340/k>c1@00001H0<K6aPD000008@2c/k<20000
0140WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2P2<S8`00`000000
WinO09nOW`0[09nOW`800000=02c/k<8000004/0a/K61@00000T0;>c/`8000004`2OWil50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool;08b<S0800000;@2OWil3000003T0/k>c
1`00000l0<K6aPP000009`2c/k<2000001D0WinO1@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo3@2<S8`2000002h0WinO0P00000n0;>c/`/000009`36a/H:000002`0/k>c0`00
000G09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`l0S8b<0P00000^
09nOW`H00000@`2c/k<W000003<0/k>c0`00000J09nOW`D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooa40S8b<0P00000b09nOW`800000V@2c/k<2000001d0WinO00<000000?oo
o`3oool00P3oool100000040oooo000=0?ooo`@00000103oool00`000000oooo0?ooo`020?oooa<0
S8b<0`00000a09nOW`D00000T@2c/k<3000001h0WinO00<000000?ooo`3oool00`3oool100000040
oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3ooolF08b<S0800000
=02OWil3000008`0/k>c0P00000O09nOW`80000000<0S8b<0?ooo`3oool00`3oool100000040oooo
000>0?ooo`030000003oool0oooo00@0oooo0P0000030?oooaP0S8b<0`00000d09nOW`D00000P@2c
/k<6000001l0WinO0P00000308b<S0@0oooo0P0000010?ooo`003`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo6`2<S8`3000003H0WinO1@00001g0;>c/`D00000902OWil0
0`000000S8b<08b<S00308b<S0D0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo0080oooo7P2<S8`2000003T0WinO1`00001/0;>c/`@000009`2OWil2
000000H0S8b<1@3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
ob00S8b<0`00000m09nOW`T00000G@2c/k<6000002P0WinO0`00000808b<S0D0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooob<0S8b<0`00001309nOW`L00000CP2c/k<8000002`0
WinO0P00000;08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobH0S8b<
1@00001109nOW`80o`000P2OWil=000003L0/k>c2P00000a09nOW`<000003@2<S8`50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool[08b<S0800000?@2OWil0103o00000?l0003o
0000o`020?l000d0WinO=`00000i09nOW`800000402<S8`50?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool00P3oool]08b<S0H00000=`2OWil5003o00030?l0002OWil0WinO07P0WinO0`00
000B08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooc<0S8b<0P00000d
09nOW`030?l00000o`000?l000<00?l00P3o001f09nOW`<000005@2<S8`50?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0J`3oool00`3o00000?l0003o0003003o0080o`00T`3oool10000
0040oooo000E0?ooo`030000003oool0oooo06`0oooo00@0o`00003o0000o`000?l00P3o002D0?oo
o`4000000@3oool001D0oooo00<000000?ooo`000000>@3oool00`000000oooo0?ooo`0`0?ooo`H0
o`000P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3o
ool06@3oool100000040oooo000E0?ooo`<000003@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`060?ooo`80o`00
103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0:0?ooo`8000000@3oool001D0ooooo`00000;00000040oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {0.721255, 0.910985, 0.00340417, \
0.00404794}}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-2.`\), {x \[Rule] 1.376384972443001`, 
            y \[Rule] 1.6786760817546211`}}\), 
        ",", \({"Steps" \[Rule] 9, "Function" \[Rule] 13, 
          "Gradient" \[Rule] 13}\), ",", 
        TagBox[\(\[SkeletonIndicator]  
            ContourGraphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "}"}]], "Output",
  CellLabel->"Out[21]="]
}, Open  ]],

Cell["\<\
The first thing to notice about the path taken above is that it \
starts out in the wrong direction. This direction is chosen because at the \
first step all the method has to go by is the gradient, and so it takes the \
direction of steepest descent. However, in subsequent steps, it incorporates \
information from the values of the function and gradient at the steps taken \
to build up an approximate model of the Hessian. \
\>", "Text"],

Cell[TextData[{
  "The methods used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are the Broyden Fletcher Goldfarb and Shanno (BFGS) updates and, for \
large systems, the limited memory BFGS (L-BFGS) methods, in which the model \
",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " is not stored explicitly, but rather ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            FormBox[\(B\_k\),
              "TraditionalForm"], \(-1\)], "  ", \(\[Del]\(f(x\_k)\)\)}], 
        TraditionalForm]]],
  " is calculated by gradients and step directions stored from past steps."
}], "Text"],

Cell[TextData[{
  "The BFGS method is implemented such that instead of forming the model \
Hessian ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " at each step, Cholesky factors ",
  Cell[BoxData[
      \(TraditionalForm\`L\_k\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`L\_k . L\_k\^T\)]],
  "= ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " are computed so that only ",
  Cell[BoxData[
      \(TraditionalForm\`O(n\^2)\)]],
  " operations are needed to solve the system ",
  Cell[BoxData[
      \(TraditionalForm\`\(B\_k\) s\_k\ \  = \ \(-\ \[Del]\(f(x\_k)\)\)\)]],
  " [",
  ButtonBox["DS96",
    ButtonData:>"DS96",
    ButtonStyle->"Hyperlink"],
  "] for a problem with ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " variables."
}], "Text"],

Cell[TextData[{
  "For large scale sparse problems, the BFGS method can be problematic \
because, in general, the Cholesky factors (or the Hessian approximation ",
  Cell[BoxData[
      \(TraditionalForm\`B\_k\)]],
  " or its inverse) are dense, so the ",
  Cell[BoxData[
      \(TraditionalForm\`O(n\^2)\)]],
  " memory and operations requirements become prohibitive compared to \
algorithms that take advantage of sparseness. The L-BFGS algorithm [",
  ButtonBox["NW99",
    ButtonData:>"NW99",
    ButtonStyle->"Hyperlink"],
  "] forms an approximation to the inverse Hessian based on a the last ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " past steps, which are stored. The Hessian approximation may not be as \
complete, but the memory and order of operations are limited to ",
  Cell[BoxData[
      \(TraditionalForm\`O(n\ m)\)]],
  " for a problem with ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " variables. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5, for problems over 250 variables, the algorithm is switched \
automatically to L-BFGS. You can control this with the method option ",
  StyleBox["\"StepMemory\"->", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ". With ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "=\[Infinity], the full BFGS method will always be used. Choosing an \
appropriate value of ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " is a trade-off between speed of convergence and the work done per step. \
With ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "<3, you are most likely better off using a conjugate gradient algorithm."
}], "Text"],

Cell[TextData[{
  "This shows the same aforementioned example function with the minimum \
computed using L-BFGS with ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  "= 5."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimumPlot[
      Cos[x^2\  - \ 3\ y]\  + \ Sin[x^2\  + \ y^2], {{x, 1}, {y, 1}}, \ 
      Method \[Rule] {"\<QuasiNewton\>", \ "\<StepMemory\>" \[Rule] 
            5}]\)], "Input",
  CellLabel->"In[22]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.907277 1.14212 -1.06807 1.0873 [
[.00642 -0.0125 -9 -9 ]
[.00642 -0.0125 9 0 ]
[.23484 -0.0125 -3 -9 ]
[.23484 -0.0125 3 0 ]
[.46327 -0.0125 -9 -9 ]
[.46327 -0.0125 9 0 ]
[.69169 -0.0125 -9 -9 ]
[.69169 -0.0125 9 0 ]
[.92012 -0.0125 -9 -9 ]
[.92012 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .23669 -18 -4.5 ]
[-0.0125 .23669 0 4.5 ]
[-0.0125 .45415 -18 -4.5 ]
[-0.0125 .45415 0 4.5 ]
[-0.0125 .67161 -18 -4.5 ]
[-0.0125 .67161 0 4.5 ]
[-0.0125 .88907 -18 -4.5 ]
[-0.0125 .88907 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00642 0 m
.00642 .00625 L
s
[(0.8)] .00642 -0.0125 0 1 Mshowa
.23484 0 m
.23484 .00625 L
s
[(1)] .23484 -0.0125 0 1 Mshowa
.46327 0 m
.46327 .00625 L
s
[(1.2)] .46327 -0.0125 0 1 Mshowa
.69169 0 m
.69169 .00625 L
s
[(1.4)] .69169 -0.0125 0 1 Mshowa
.92012 0 m
.92012 .00625 L
s
[(1.6)] .92012 -0.0125 0 1 Mshowa
.125 Mabswid
.06353 0 m
.06353 .00375 L
s
.12063 0 m
.12063 .00375 L
s
.17774 0 m
.17774 .00375 L
s
.29195 0 m
.29195 .00375 L
s
.34906 0 m
.34906 .00375 L
s
.40616 0 m
.40616 .00375 L
s
.52038 0 m
.52038 .00375 L
s
.57748 0 m
.57748 .00375 L
s
.63459 0 m
.63459 .00375 L
s
.7488 0 m
.7488 .00375 L
s
.80591 0 m
.80591 .00375 L
s
.86301 0 m
.86301 .00375 L
s
.97722 0 m
.97722 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(1)] -0.0125 .01923 1 0 Mshowa
0 .23669 m
.00625 .23669 L
s
[(1.2)] -0.0125 .23669 1 0 Mshowa
0 .45415 m
.00625 .45415 L
s
[(1.4)] -0.0125 .45415 1 0 Mshowa
0 .67161 m
.00625 .67161 L
s
[(1.6)] -0.0125 .67161 1 0 Mshowa
0 .88907 m
.00625 .88907 L
s
[(1.8)] -0.0125 .88907 1 0 Mshowa
.125 Mabswid
0 .0736 m
.00375 .0736 L
s
0 .12796 m
.00375 .12796 L
s
0 .18233 m
.00375 .18233 L
s
0 .29106 m
.00375 .29106 L
s
0 .34542 m
.00375 .34542 L
s
0 .39979 m
.00375 .39979 L
s
0 .50852 m
.00375 .50852 L
s
0 .56288 m
.00375 .56288 L
s
0 .61725 m
.00375 .61725 L
s
0 .72598 m
.00375 .72598 L
s
0 .78034 m
.00375 .78034 L
s
0 .83471 m
.00375 .83471 L
s
0 .94344 m
.00375 .94344 L
s
0 .9978 m
.00375 .9978 L
s
.25 Mabswid
0 0 m
0 1 L
s
.00642 .99375 m
.00642 1 L
s
.23484 .99375 m
.23484 1 L
s
.46327 .99375 m
.46327 1 L
s
.69169 .99375 m
.69169 1 L
s
.92012 .99375 m
.92012 1 L
s
.125 Mabswid
.06353 .99625 m
.06353 1 L
s
.12063 .99625 m
.12063 1 L
s
.17774 .99625 m
.17774 1 L
s
.29195 .99625 m
.29195 1 L
s
.34906 .99625 m
.34906 1 L
s
.40616 .99625 m
.40616 1 L
s
.52038 .99625 m
.52038 1 L
s
.57748 .99625 m
.57748 1 L
s
.63459 .99625 m
.63459 1 L
s
.7488 .99625 m
.7488 1 L
s
.80591 .99625 m
.80591 1 L
s
.86301 .99625 m
.86301 1 L
s
.97722 .99625 m
.97722 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .23669 m
1 .23669 L
s
.99375 .45415 m
1 .45415 L
s
.99375 .67161 m
1 .67161 L
s
.99375 .88907 m
1 .88907 L
s
.125 Mabswid
.99625 .0736 m
1 .0736 L
s
.99625 .12796 m
1 .12796 L
s
.99625 .18233 m
1 .18233 L
s
.99625 .29106 m
1 .29106 L
s
.99625 .34542 m
1 .34542 L
s
.99625 .39979 m
1 .39979 L
s
.99625 .50852 m
1 .50852 L
s
.99625 .56288 m
1 .56288 L
s
.99625 .61725 m
1 .61725 L
s
.99625 .72598 m
1 .72598 L
s
.99625 .78034 m
1 .78034 L
s
.99625 .83471 m
1 .83471 L
s
.99625 .94344 m
1 .94344 L
s
.99625 .9978 m
1 .9978 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.325 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.4 g
.01923 .04253 m
.02894 .04602 L
.03576 .04837 L
.03866 .04935 L
.04837 .05254 L
.05808 .05559 L
.06635 .05808 L
.06779 .05851 L
.07751 .0613 L
.08722 .06398 L
.09693 .06654 L
.10184 .06779 L
.10664 .06899 L
.11636 .07135 L
.12607 .0736 L
.13578 .07575 L
.14398 .07751 L
.14549 .07782 L
.15521 .07981 L
.16492 .08171 L
.17463 .08353 L
.18434 .08528 L
.19406 .08695 L
.19564 .08722 L
.20377 .08856 L
.21348 .0901 L
.22319 .09158 L
.23291 .093 L
.24262 .09436 L
.25233 .09567 L
.26204 .09692 L
.2621 .09693 L
.27176 .09813 L
.28147 .09928 L
.29118 .10039 L
.30089 .10145 L
.31061 .10247 L
.32032 .10344 L
.33003 .10438 L
.33974 .10527 L
.34946 .10613 L
.35546 .10664 L
.35917 .10695 L
.36888 .10774 L
.37859 .10849 L
.38831 .1092 L
.39802 .10989 L
.40773 .11054 L
.41744 .11116 L
.42716 .11175 L
.43687 .11231 L
.44658 .11284 L
.45629 .11335 L
.46601 .11382 L
.47572 .11427 L
.48543 .11469 L
.49514 .11508 L
.50486 .11545 L
.51457 .11579 L
.52428 .1161 L
.53265 .11636 L
.53399 .11639 L
.54371 .11666 L
.55342 .1169 L
.56313 .11711 L
.57284 .11729 L
.58256 .11746 L
.59227 .11759 L
.60198 .1177 L
.61169 .11778 L
.62141 .11784 L
.63112 .11787 L
.64083 .11787 L
.65054 .11784 L
.66026 .11778 L
.66997 .1177 L
.67968 .11758 L
.68939 .11744 L
.69911 .11726 L
.70882 .11704 L
.71853 .11679 L
.72824 .11651 L
.73303 .11636 L
.73796 .11619 L
.74767 .11583 L
.75738 .11542 L
.76709 .11497 L
.77681 .11448 L
.78652 .11394 L
.79623 .11334 L
.80594 .11269 L
.81566 .11198 L
.82537 .11121 L
.83508 .11036 L
.84479 .10945 L
.85451 .10845 L
.86422 .10737 L
.87031 .10664 L
.87393 .10619 L
.88364 .10491 L
.89336 .10352 L
.90307 .102 L
.91278 .10034 L
.92249 .09853 L
.93039 .09693 L
.93221 .09654 L
.94192 .09436 L
.95163 .09196 L
.96134 .08931 L
.96834 .08722 L
.97106 .08636 L
.98077 .08308 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .04253 m
.02894 .04602 L
.03576 .04837 L
.03866 .04935 L
.04837 .05254 L
.05808 .05559 L
.06635 .05808 L
.06779 .05851 L
.07751 .0613 L
.08722 .06398 L
.09693 .06654 L
.10184 .06779 L
.10664 .06899 L
.11636 .07135 L
.12607 .0736 L
.13578 .07575 L
.14398 .07751 L
.14549 .07782 L
.15521 .07981 L
.16492 .08171 L
.17463 .08353 L
.18434 .08528 L
.19406 .08695 L
.19564 .08722 L
.20377 .08856 L
.21348 .0901 L
.22319 .09158 L
.23291 .093 L
.24262 .09436 L
.25233 .09567 L
.26204 .09692 L
.2621 .09693 L
.27176 .09813 L
.28147 .09928 L
.29118 .10039 L
.30089 .10145 L
.31061 .10247 L
.32032 .10344 L
.33003 .10438 L
.33974 .10527 L
.34946 .10613 L
.35546 .10664 L
.35917 .10695 L
.36888 .10774 L
.37859 .10849 L
.38831 .1092 L
.39802 .10989 L
.40773 .11054 L
.41744 .11116 L
.42716 .11175 L
Mistroke
.43687 .11231 L
.44658 .11284 L
.45629 .11335 L
.46601 .11382 L
.47572 .11427 L
.48543 .11469 L
.49514 .11508 L
.50486 .11545 L
.51457 .11579 L
.52428 .1161 L
.53265 .11636 L
.53399 .11639 L
.54371 .11666 L
.55342 .1169 L
.56313 .11711 L
.57284 .11729 L
.58256 .11746 L
.59227 .11759 L
.60198 .1177 L
.61169 .11778 L
.62141 .11784 L
.63112 .11787 L
.64083 .11787 L
.65054 .11784 L
.66026 .11778 L
.66997 .1177 L
.67968 .11758 L
.68939 .11744 L
.69911 .11726 L
.70882 .11704 L
.71853 .11679 L
.72824 .11651 L
.73303 .11636 L
.73796 .11619 L
.74767 .11583 L
.75738 .11542 L
.76709 .11497 L
.77681 .11448 L
.78652 .11394 L
.79623 .11334 L
.80594 .11269 L
.81566 .11198 L
.82537 .11121 L
.83508 .11036 L
.84479 .10945 L
.85451 .10845 L
.86422 .10737 L
.87031 .10664 L
.87393 .10619 L
.88364 .10491 L
Mistroke
.89336 .10352 L
.90307 .102 L
.91278 .10034 L
.92249 .09853 L
.93039 .09693 L
.93221 .09654 L
.94192 .09436 L
.95163 .09196 L
.96134 .08931 L
.96834 .08722 L
.97106 .08636 L
.98077 .08308 L
Mfstroke
.475 g
.01923 .17414 m
.02894 .174 L
.03866 .17387 L
.04837 .17375 L
.05808 .17363 L
.06779 .17352 L
.07751 .17342 L
.08722 .17332 L
.09693 .17323 L
.10664 .17314 L
.11636 .17306 L
.12607 .17298 L
.13578 .17291 L
.14549 .17284 L
.15521 .17277 L
.16492 .1727 L
.17463 .17264 L
.18434 .17258 L
.19406 .17253 L
.20377 .17247 L
.21348 .17242 L
.22319 .17237 L
.23291 .17233 L
.24262 .17228 L
.25233 .17224 L
.26204 .1722 L
.27176 .17216 L
.28147 .17212 L
.29118 .17209 L
.30089 .17205 L
.31061 .17202 L
.32032 .17199 L
.33003 .17196 L
.33974 .17193 L
.34946 .1719 L
.35917 .17188 L
.36888 .17185 L
.37859 .17183 L
.38831 .17181 L
.39802 .17178 L
.40773 .17176 L
.41744 .17174 L
.42716 .17173 L
.43687 .17171 L
.44658 .17169 L
.45629 .17167 L
.46601 .17166 L
.47572 .17165 L
.48543 .17163 L
.49514 .17162 L
.50486 .17161 L
.51457 .1716 L
.52428 .17159 L
.53399 .17158 L
.54371 .17157 L
.55342 .17156 L
.56313 .17155 L
.57284 .17155 L
.58256 .17154 L
.59227 .17154 L
.60198 .17153 L
.61169 .17153 L
.62141 .17153 L
.63112 .17153 L
.64083 .17153 L
.65054 .17153 L
.66026 .17153 L
.66997 .17153 L
.67968 .17153 L
.68939 .17154 L
.69911 .17154 L
.70882 .17155 L
.71853 .17155 L
.72824 .17156 L
.73796 .17157 L
.74767 .17158 L
.75738 .17159 L
.76709 .1716 L
.77681 .17161 L
.78652 .17163 L
.79623 .17165 L
.80594 .17166 L
.81566 .17168 L
.82537 .1717 L
.83508 .17173 L
.84479 .17175 L
.85451 .17178 L
.86422 .17181 L
.87393 .17184 L
.88364 .17187 L
.89336 .17191 L
.90307 .17195 L
.91278 .17199 L
.92249 .17204 L
.93221 .17209 L
.94192 .17215 L
.95163 .17221 L
.96134 .17228 L
.97106 .17235 L
.98077 .17243 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .17414 m
.02894 .174 L
.03866 .17387 L
.04837 .17375 L
.05808 .17363 L
.06779 .17352 L
.07751 .17342 L
.08722 .17332 L
.09693 .17323 L
.10664 .17314 L
.11636 .17306 L
.12607 .17298 L
.13578 .17291 L
.14549 .17284 L
.15521 .17277 L
.16492 .1727 L
.17463 .17264 L
.18434 .17258 L
.19406 .17253 L
.20377 .17247 L
.21348 .17242 L
.22319 .17237 L
.23291 .17233 L
.24262 .17228 L
.25233 .17224 L
.26204 .1722 L
.27176 .17216 L
.28147 .17212 L
.29118 .17209 L
.30089 .17205 L
.31061 .17202 L
.32032 .17199 L
.33003 .17196 L
.33974 .17193 L
.34946 .1719 L
.35917 .17188 L
.36888 .17185 L
.37859 .17183 L
.38831 .17181 L
.39802 .17178 L
.40773 .17176 L
.41744 .17174 L
.42716 .17173 L
.43687 .17171 L
.44658 .17169 L
.45629 .17167 L
.46601 .17166 L
.47572 .17165 L
.48543 .17163 L
.49514 .17162 L
Mistroke
.50486 .17161 L
.51457 .1716 L
.52428 .17159 L
.53399 .17158 L
.54371 .17157 L
.55342 .17156 L
.56313 .17155 L
.57284 .17155 L
.58256 .17154 L
.59227 .17154 L
.60198 .17153 L
.61169 .17153 L
.62141 .17153 L
.63112 .17153 L
.64083 .17153 L
.65054 .17153 L
.66026 .17153 L
.66997 .17153 L
.67968 .17153 L
.68939 .17154 L
.69911 .17154 L
.70882 .17155 L
.71853 .17155 L
.72824 .17156 L
.73796 .17157 L
.74767 .17158 L
.75738 .17159 L
.76709 .1716 L
.77681 .17161 L
.78652 .17163 L
.79623 .17165 L
.80594 .17166 L
.81566 .17168 L
.82537 .1717 L
.83508 .17173 L
.84479 .17175 L
.85451 .17178 L
.86422 .17181 L
.87393 .17184 L
.88364 .17187 L
.89336 .17191 L
.90307 .17195 L
.91278 .17199 L
.92249 .17204 L
.93221 .17209 L
.94192 .17215 L
.95163 .17221 L
.96134 .17228 L
.97106 .17235 L
.98077 .17243 L
Mistroke
Mfstroke
.55 g
.01923 .33333 m
.02376 .33003 L
.02894 .32643 L
.03833 .32032 L
.03866 .32011 L
.04837 .31431 L
.055 .31061 L
.05808 .30895 L
.06779 .30399 L
.07426 .30089 L
.07751 .29939 L
.08722 .2951 L
.09674 .29118 L
.09693 .2911 L
.10664 .28736 L
.11636 .28385 L
.12332 .28147 L
.12607 .28056 L
.13578 .27746 L
.14549 .27454 L
.15521 .27178 L
.1553 .27176 L
.16492 .26918 L
.17463 .26672 L
.18434 .26438 L
.19406 .26217 L
.19463 .26204 L
.20377 .26007 L
.21348 .25808 L
.22319 .25618 L
.23291 .25438 L
.24262 .25267 L
.24458 .25233 L
.25233 .25103 L
.26204 .24948 L
.27176 .24799 L
.28147 .24658 L
.29118 .24523 L
.30089 .24394 L
.31061 .24272 L
.31139 .24262 L
.32032 .24154 L
.33003 .24042 L
.33974 .23936 L
.34946 .23834 L
.35917 .23737 L
.36888 .23644 L
.37859 .23555 L
.38831 .23471 L
.39802 .23391 L
.40773 .23315 L
.41088 .23291 L
.41744 .23242 L
.42716 .23173 L
.43687 .23107 L
.44658 .23045 L
.45629 .22986 L
.46601 .2293 L
.47572 .22878 L
.48543 .22829 L
.49514 .22782 L
.50486 .22739 L
.51457 .22698 L
.52428 .2266 L
.53399 .22625 L
.54371 .22593 L
.55342 .22564 L
.56313 .22538 L
.57284 .22514 L
.58256 .22493 L
.59227 .22474 L
.60198 .22459 L
.61169 .22446 L
.62141 .22436 L
.63112 .22428 L
.64083 .22424 L
.65054 .22422 L
.66026 .22423 L
.66997 .22428 L
.67968 .22435 L
.68939 .22445 L
.69911 .22459 L
.70882 .22476 L
.71853 .22496 L
.72824 .2252 L
.73796 .22547 L
.74767 .22578 L
.75738 .22613 L
.76709 .22652 L
.77681 .22696 L
.78652 .22744 L
.79623 .22796 L
.80594 .22854 L
.81566 .22917 L
.82537 .22986 L
.83508 .2306 L
.84479 .23141 L
.85451 .23229 L
.86087 .23291 L
.86422 .23324 L
.87393 .23427 L
.88364 .23539 L
.89336 .2366 L
.90307 .23791 L
.91278 .23932 L
.92249 .24086 L
.93221 .24252 L
.93274 .24262 L
.94192 .24433 L
.95163 .2463 L
.96134 .24844 L
.97106 .25077 L
.97708 .25233 L
.98077 .25333 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .33333 m
.02376 .33003 L
.02894 .32643 L
.03833 .32032 L
.03866 .32011 L
.04837 .31431 L
.055 .31061 L
.05808 .30895 L
.06779 .30399 L
.07426 .30089 L
.07751 .29939 L
.08722 .2951 L
.09674 .29118 L
.09693 .2911 L
.10664 .28736 L
.11636 .28385 L
.12332 .28147 L
.12607 .28056 L
.13578 .27746 L
.14549 .27454 L
.15521 .27178 L
.1553 .27176 L
.16492 .26918 L
.17463 .26672 L
.18434 .26438 L
.19406 .26217 L
.19463 .26204 L
.20377 .26007 L
.21348 .25808 L
.22319 .25618 L
.23291 .25438 L
.24262 .25267 L
.24458 .25233 L
.25233 .25103 L
.26204 .24948 L
.27176 .24799 L
.28147 .24658 L
.29118 .24523 L
.30089 .24394 L
.31061 .24272 L
.31139 .24262 L
.32032 .24154 L
.33003 .24042 L
.33974 .23936 L
.34946 .23834 L
.35917 .23737 L
.36888 .23644 L
.37859 .23555 L
.38831 .23471 L
.39802 .23391 L
Mistroke
.40773 .23315 L
.41088 .23291 L
.41744 .23242 L
.42716 .23173 L
.43687 .23107 L
.44658 .23045 L
.45629 .22986 L
.46601 .2293 L
.47572 .22878 L
.48543 .22829 L
.49514 .22782 L
.50486 .22739 L
.51457 .22698 L
.52428 .2266 L
.53399 .22625 L
.54371 .22593 L
.55342 .22564 L
.56313 .22538 L
.57284 .22514 L
.58256 .22493 L
.59227 .22474 L
.60198 .22459 L
.61169 .22446 L
.62141 .22436 L
.63112 .22428 L
.64083 .22424 L
.65054 .22422 L
.66026 .22423 L
.66997 .22428 L
.67968 .22435 L
.68939 .22445 L
.69911 .22459 L
.70882 .22476 L
.71853 .22496 L
.72824 .2252 L
.73796 .22547 L
.74767 .22578 L
.75738 .22613 L
.76709 .22652 L
.77681 .22696 L
.78652 .22744 L
.79623 .22796 L
.80594 .22854 L
.81566 .22917 L
.82537 .22986 L
.83508 .2306 L
.84479 .23141 L
.85451 .23229 L
.86087 .23291 L
.86422 .23324 L
Mistroke
.87393 .23427 L
.88364 .23539 L
.89336 .2366 L
.90307 .23791 L
.91278 .23932 L
.92249 .24086 L
.93221 .24252 L
.93274 .24262 L
.94192 .24433 L
.95163 .2463 L
.96134 .24844 L
.97106 .25077 L
.97708 .25233 L
.98077 .25333 L
Mfstroke
.625 g
.01923 .55123 m
.02242 .54371 L
.02677 .53399 L
.02894 .52934 L
.03138 .52428 L
.03628 .51457 L
.03866 .51007 L
.0415 .50486 L
.04707 .49514 L
.04837 .49297 L
.05303 .48543 L
.05808 .47768 L
.0594 .47572 L
.06624 .46601 L
.06779 .4639 L
.0736 .45629 L
.07751 .45141 L
.08153 .44658 L
.08722 .44004 L
.09009 .43687 L
.09693 .42964 L
.09938 .42716 L
.10664 .42008 L
.10947 .41744 L
.11636 .41127 L
.12048 .40773 L
.12607 .40311 L
.13252 .39802 L
.13578 .39554 L
.14549 .38849 L
.14576 .38831 L
.15521 .38192 L
.16038 .37859 L
.16492 .37577 L
.17463 .37002 L
.17662 .36888 L
.18434 .36461 L
.19406 .35953 L
.19476 .35917 L
.20377 .35474 L
.21348 .35022 L
.21518 .34946 L
.22319 .34596 L
.23291 .34192 L
.23839 .33974 L
.24262 .33811 L
.25233 .33449 L
.26204 .33106 L
.26507 .33003 L
.27176 .32781 L
.28147 .32472 L
.29118 .32178 L
.29622 .32032 L
.30089 .31899 L
.31061 .31634 L
.32032 .31381 L
.33003 .31141 L
.33339 .31061 L
.33974 .30912 L
.34946 .30694 L
.35917 .30487 L
.36888 .3029 L
.37859 .30102 L
.37927 .30089 L
.38831 .29924 L
.39802 .29754 L
.40773 .29592 L
.41744 .29439 L
.42716 .29293 L
.43687 .29155 L
.43953 .29118 L
.44658 .29024 L
.45629 .289 L
.46601 .28783 L
.47572 .28672 L
.48543 .28568 L
.49514 .2847 L
.50486 .28379 L
.51457 .28293 L
.52428 .28214 L
.53302 .28147 L
.53399 .2814 L
.54371 .28072 L
.55342 .28009 L
.56313 .27952 L
.57284 .27901 L
.58256 .27855 L
.59227 .27815 L
.60198 .27781 L
.61169 .27751 L
.62141 .27728 L
.63112 .2771 L
.64083 .27697 L
.65054 .27691 L
.66026 .2769 L
.66997 .27695 L
.67968 .27705 L
.68939 .27722 L
.69911 .27746 L
.70882 .27775 L
.71853 .27812 L
.72824 .27855 L
.73796 .27905 L
.74767 .27963 L
.75738 .28028 L
.76709 .28101 L
.77265 .28147 L
.77681 .28183 L
.78652 .28273 L
.79623 .28373 L
.80594 .28482 L
.81566 .28601 L
.82537 .28731 L
.83508 .28873 L
.84479 .29027 L
.85018 .29118 L
.85451 .29194 L
.86422 .29375 L
.87393 .29572 L
.88364 .29784 L
.89336 .30015 L
.89635 .30089 L
.90307 .30264 L
.91278 .30534 L
.92249 .30827 L
.92971 .31061 L
.93221 .31145 L
.94192 .3149 L
.95163 .31865 L
.9557 .32032 L
.96134 .32273 L
.97106 .32719 L
.97681 .33003 L
.98077 .33207 L
.98077 .98077 L
.01923 .98077 L
F
0 g
.01923 .55123 m
.02242 .54371 L
.02677 .53399 L
.02894 .52934 L
.03138 .52428 L
.03628 .51457 L
.03866 .51007 L
.0415 .50486 L
.04707 .49514 L
.04837 .49297 L
.05303 .48543 L
.05808 .47768 L
.0594 .47572 L
.06624 .46601 L
.06779 .4639 L
.0736 .45629 L
.07751 .45141 L
.08153 .44658 L
.08722 .44004 L
.09009 .43687 L
.09693 .42964 L
.09938 .42716 L
.10664 .42008 L
.10947 .41744 L
.11636 .41127 L
.12048 .40773 L
.12607 .40311 L
.13252 .39802 L
.13578 .39554 L
.14549 .38849 L
.14576 .38831 L
.15521 .38192 L
.16038 .37859 L
.16492 .37577 L
.17463 .37002 L
.17662 .36888 L
.18434 .36461 L
.19406 .35953 L
.19476 .35917 L
.20377 .35474 L
.21348 .35022 L
.21518 .34946 L
.22319 .34596 L
.23291 .34192 L
.23839 .33974 L
.24262 .33811 L
.25233 .33449 L
.26204 .33106 L
.26507 .33003 L
.27176 .32781 L
Mistroke
.28147 .32472 L
.29118 .32178 L
.29622 .32032 L
.30089 .31899 L
.31061 .31634 L
.32032 .31381 L
.33003 .31141 L
.33339 .31061 L
.33974 .30912 L
.34946 .30694 L
.35917 .30487 L
.36888 .3029 L
.37859 .30102 L
.37927 .30089 L
.38831 .29924 L
.39802 .29754 L
.40773 .29592 L
.41744 .29439 L
.42716 .29293 L
.43687 .29155 L
.43953 .29118 L
.44658 .29024 L
.45629 .289 L
.46601 .28783 L
.47572 .28672 L
.48543 .28568 L
.49514 .2847 L
.50486 .28379 L
.51457 .28293 L
.52428 .28214 L
.53302 .28147 L
.53399 .2814 L
.54371 .28072 L
.55342 .28009 L
.56313 .27952 L
.57284 .27901 L
.58256 .27855 L
.59227 .27815 L
.60198 .27781 L
.61169 .27751 L
.62141 .27728 L
.63112 .2771 L
.64083 .27697 L
.65054 .27691 L
.66026 .2769 L
.66997 .27695 L
.67968 .27705 L
.68939 .27722 L
.69911 .27746 L
.70882 .27775 L
Mistroke
.71853 .27812 L
.72824 .27855 L
.73796 .27905 L
.74767 .27963 L
.75738 .28028 L
.76709 .28101 L
.77265 .28147 L
.77681 .28183 L
.78652 .28273 L
.79623 .28373 L
.80594 .28482 L
.81566 .28601 L
.82537 .28731 L
.83508 .28873 L
.84479 .29027 L
.85018 .29118 L
.85451 .29194 L
.86422 .29375 L
.87393 .29572 L
.88364 .29784 L
.89336 .30015 L
.89635 .30089 L
.90307 .30264 L
.91278 .30534 L
.92249 .30827 L
.92971 .31061 L
.93221 .31145 L
.94192 .3149 L
.95163 .31865 L
.9557 .32032 L
.96134 .32273 L
.97106 .32719 L
.97681 .33003 L
.98077 .33207 L
Mfstroke
.7 g
.98077 .41402 m
.97284 .40773 L
.97106 .40638 L
.96134 .39945 L
.95922 .39802 L
.95163 .39313 L
.94357 .38831 L
.94192 .38736 L
.93221 .38208 L
.92531 .37859 L
.92249 .37723 L
.91278 .37278 L
.90356 .36888 L
.90307 .36868 L
.89336 .36491 L
.88364 .36144 L
.87684 .35917 L
.87393 .35824 L
.86422 .35529 L
.85451 .35257 L
.84479 .35007 L
.84228 .34946 L
.83508 .34777 L
.82537 .34566 L
.81566 .34372 L
.80594 .34195 L
.79623 .34033 L
.79245 .33974 L
.78652 .33886 L
.77681 .33754 L
.76709 .33634 L
.75738 .33527 L
.74767 .33432 L
.73796 .33349 L
.72824 .33277 L
.71853 .33215 L
.70882 .33164 L
.69911 .33123 L
.68939 .33092 L
.67968 .33071 L
.66997 .33059 L
.66026 .33056 L
.65054 .33062 L
.64083 .33076 L
.63112 .331 L
.62141 .33132 L
.61169 .33173 L
.60198 .33223 L
.59227 .33281 L
.58256 .33348 L
.57284 .33423 L
.56313 .33507 L
.55342 .336 L
.54371 .33702 L
.53399 .33812 L
.52428 .33932 L
.52101 .33974 L
.51457 .34061 L
.50486 .342 L
.49514 .34348 L
.48543 .34506 L
.47572 .34675 L
.46601 .34854 L
.46122 .34946 L
.45629 .35043 L
.44658 .35244 L
.43687 .35457 L
.42716 .35682 L
.41754 .35917 L
.41744 .35919 L
.40773 .3617 L
.39802 .36434 L
.38831 .36712 L
.38243 .36888 L
.37859 .37006 L
.36888 .37315 L
.35917 .37641 L
.35294 .37859 L
.34946 .37985 L
.33974 .38347 L
.33003 .38729 L
.32753 .38831 L
.32032 .39132 L
.31061 .39557 L
.30524 .39802 L
.30089 .40006 L
.29118 .4048 L
.28545 .40773 L
.28147 .40982 L
.27176 .41514 L
.26771 .41744 L
.26204 .42077 L
.25233 .42675 L
.2517 .42716 L
.24262 .43311 L
.23714 .43687 L
.23291 .43987 L
.22385 .44658 L
.22319 .44708 L
.21348 .45479 L
.21166 .45629 L
.20377 .46305 L
.20044 .46601 L
.19406 .47191 L
.19009 .47572 L
.18434 .48144 L
.18049 .48543 L
.17463 .49175 L
.17159 .49514 L
.16492 .50291 L
.16331 .50486 L
.15559 .51457 L
.15521 .51507 L
.14838 .52428 L
.14549 .52837 L
.14165 .53399 L
.13578 .54301 L
.13534 .54371 L
.12943 .55342 L
.12607 .55923 L
.12389 .56313 L
.11868 .57284 L
.11636 .5774 L
.1138 .58256 L
.10921 .59227 L
.10664 .59797 L
.10489 .60198 L
.10084 .61169 L
.09704 .62141 L
.09693 .62168 L
.09346 .63112 L
.09011 .64083 L
.08722 .64975 L
.08697 .65054 L
.08403 .66026 L
.08129 .66997 L
.07874 .67968 L
.07751 .68465 L
.07637 .68939 L
.07418 .69911 L
.07217 .70882 L
.07033 .71853 L
.06866 .72824 L
.06779 .73371 L
.06716 .73796 L
.06583 .74767 L
.06468 .75738 L
.0637 .76709 L
.0629 .77681 L
.06228 .78652 L
.06185 .79623 L
.06161 .80594 L
.06156 .81566 L
.06173 .82537 L
.06212 .83508 L
.06273 .84479 L
.06359 .85451 L
.0647 .86422 L
.06609 .87393 L
.06777 .88364 L
.06779 .88375 L
.06977 .89336 L
.0721 .90307 L
.0748 .91278 L
.07751 .92137 L
.07789 .92249 L
.08141 .93221 L
.0854 .94192 L
.08722 .94599 L
.0899 .95163 L
.09497 .96134 L
.09693 .96482 L
.10067 .97106 L
.10664 .98018 L
.10705 .98077 L
.98077 .98077 L
F
0 g
.98077 .41402 m
.97284 .40773 L
.97106 .40638 L
.96134 .39945 L
.95922 .39802 L
.95163 .39313 L
.94357 .38831 L
.94192 .38736 L
.93221 .38208 L
.92531 .37859 L
.92249 .37723 L
.91278 .37278 L
.90356 .36888 L
.90307 .36868 L
.89336 .36491 L
.88364 .36144 L
.87684 .35917 L
.87393 .35824 L
.86422 .35529 L
.85451 .35257 L
.84479 .35007 L
.84228 .34946 L
.83508 .34777 L
.82537 .34566 L
.81566 .34372 L
.80594 .34195 L
.79623 .34033 L
.79245 .33974 L
.78652 .33886 L
.77681 .33754 L
.76709 .33634 L
.75738 .33527 L
.74767 .33432 L
.73796 .33349 L
.72824 .33277 L
.71853 .33215 L
.70882 .33164 L
.69911 .33123 L
.68939 .33092 L
.67968 .33071 L
.66997 .33059 L
.66026 .33056 L
.65054 .33062 L
.64083 .33076 L
.63112 .331 L
.62141 .33132 L
.61169 .33173 L
.60198 .33223 L
.59227 .33281 L
.58256 .33348 L
Mistroke
.57284 .33423 L
.56313 .33507 L
.55342 .336 L
.54371 .33702 L
.53399 .33812 L
.52428 .33932 L
.52101 .33974 L
.51457 .34061 L
.50486 .342 L
.49514 .34348 L
.48543 .34506 L
.47572 .34675 L
.46601 .34854 L
.46122 .34946 L
.45629 .35043 L
.44658 .35244 L
.43687 .35457 L
.42716 .35682 L
.41754 .35917 L
.41744 .35919 L
.40773 .3617 L
.39802 .36434 L
.38831 .36712 L
.38243 .36888 L
.37859 .37006 L
.36888 .37315 L
.35917 .37641 L
.35294 .37859 L
.34946 .37985 L
.33974 .38347 L
.33003 .38729 L
.32753 .38831 L
.32032 .39132 L
.31061 .39557 L
.30524 .39802 L
.30089 .40006 L
.29118 .4048 L
.28545 .40773 L
.28147 .40982 L
.27176 .41514 L
.26771 .41744 L
.26204 .42077 L
.25233 .42675 L
.2517 .42716 L
.24262 .43311 L
.23714 .43687 L
.23291 .43987 L
.22385 .44658 L
.22319 .44708 L
.21348 .45479 L
Mistroke
.21166 .45629 L
.20377 .46305 L
.20044 .46601 L
.19406 .47191 L
.19009 .47572 L
.18434 .48144 L
.18049 .48543 L
.17463 .49175 L
.17159 .49514 L
.16492 .50291 L
.16331 .50486 L
.15559 .51457 L
.15521 .51507 L
.14838 .52428 L
.14549 .52837 L
.14165 .53399 L
.13578 .54301 L
.13534 .54371 L
.12943 .55342 L
.12607 .55923 L
.12389 .56313 L
.11868 .57284 L
.11636 .5774 L
.1138 .58256 L
.10921 .59227 L
.10664 .59797 L
.10489 .60198 L
.10084 .61169 L
.09704 .62141 L
.09693 .62168 L
.09346 .63112 L
.09011 .64083 L
.08722 .64975 L
.08697 .65054 L
.08403 .66026 L
.08129 .66997 L
.07874 .67968 L
.07751 .68465 L
.07637 .68939 L
.07418 .69911 L
.07217 .70882 L
.07033 .71853 L
.06866 .72824 L
.06779 .73371 L
.06716 .73796 L
.06583 .74767 L
.06468 .75738 L
.0637 .76709 L
.0629 .77681 L
.06228 .78652 L
Mistroke
.06185 .79623 L
.06161 .80594 L
.06156 .81566 L
.06173 .82537 L
.06212 .83508 L
.06273 .84479 L
.06359 .85451 L
.0647 .86422 L
.06609 .87393 L
.06777 .88364 L
.06779 .88375 L
.06977 .89336 L
.0721 .90307 L
.0748 .91278 L
.07751 .92137 L
.07789 .92249 L
.08141 .93221 L
.0854 .94192 L
.08722 .94599 L
.0899 .95163 L
.09497 .96134 L
.09693 .96482 L
.10067 .97106 L
.10664 .98018 L
.10705 .98077 L
Mfstroke
.775 g
.98077 .50792 m
.97843 .50486 L
.97106 .49576 L
.97053 .49514 L
.96177 .48543 L
.96134 .48498 L
.95203 .47572 L
.95163 .47534 L
.94192 .46667 L
.94113 .46601 L
.93221 .45884 L
.92884 .45629 L
.92249 .45172 L
.91486 .44658 L
.91278 .44525 L
.90307 .43934 L
.89874 .43687 L
.89336 .43394 L
.88364 .42899 L
.87982 .42716 L
.87393 .42446 L
.86422 .4203 L
.85703 .41744 L
.85451 .41649 L
.84479 .41299 L
.83508 .40979 L
.82837 .40773 L
.82537 .40685 L
.81566 .40418 L
.80594 .40174 L
.79623 .39952 L
.7891 .39802 L
.78652 .39751 L
.77681 .39569 L
.76709 .39407 L
.75738 .39262 L
.74767 .39134 L
.73796 .39023 L
.72824 .38927 L
.71853 .38846 L
.71643 .38831 L
.70882 .3878 L
.69911 .38728 L
.68939 .3869 L
.67968 .38665 L
.66997 .38653 L
.66026 .38654 L
.65054 .38668 L
.64083 .38694 L
.63112 .38732 L
.62141 .38783 L
.6139 .38831 L
.61169 .38846 L
.60198 .38921 L
.59227 .39009 L
.58256 .39109 L
.57284 .39221 L
.56313 .39345 L
.55342 .39483 L
.54371 .39633 L
.53399 .39796 L
.53367 .39802 L
.52428 .39973 L
.51457 .40163 L
.50486 .40368 L
.49514 .40587 L
.48735 .40773 L
.48543 .40821 L
.47572 .4107 L
.46601 .41335 L
.45629 .41617 L
.4521 .41744 L
.44658 .41916 L
.43687 .42234 L
.42716 .4257 L
.42313 .42716 L
.41744 .42927 L
.40773 .43304 L
.3984 .43687 L
.39802 .43703 L
.38831 .44126 L
.37859 .44574 L
.37682 .44658 L
.36888 .45048 L
.35917 .4555 L
.35769 .45629 L
.34946 .46083 L
.34054 .46601 L
.33974 .46648 L
.33003 .47249 L
.32504 .47572 L
.32032 .47887 L
.31094 .48543 L
.31061 .48567 L
.30089 .49292 L
.29804 .49514 L
.29118 .50067 L
.2862 .50486 L
.28147 .50897 L
.27528 .51457 L
.27176 .51788 L
.2652 .52428 L
.26204 .52748 L
.25585 .53399 L
.25233 .53785 L
.24717 .54371 L
.24262 .54911 L
.23911 .55342 L
.23291 .56139 L
.2316 .56313 L
.2246 .57284 L
.22319 .57488 L
.21808 .58256 L
.21348 .58983 L
.21199 .59227 L
.20632 .60198 L
.20377 .60657 L
.20102 .61169 L
.19609 .62141 L
.19406 .62562 L
.1915 .63112 L
.18723 .64083 L
.18434 .64783 L
.18326 .65054 L
.1796 .66026 L
.17621 .66997 L
.17463 .6748 L
.1731 .67968 L
.17025 .68939 L
.16767 .69911 L
.16533 .70882 L
.16492 .71066 L
.16325 .71853 L
.16141 .72824 L
.15982 .73796 L
.15848 .74767 L
.15738 .75738 L
.15654 .76709 L
.15595 .77681 L
.15561 .78652 L
.15555 .79623 L
.15575 .80594 L
.15624 .81566 L
.15703 .82537 L
.15813 .83508 L
.15955 .84479 L
.16131 .85451 L
.16344 .86422 L
.16492 .87013 L
.16595 .87393 L
.16888 .88364 L
.17225 .89336 L
.17463 .89951 L
.1761 .90307 L
.18047 .91278 L
.18434 .92051 L
.1854 .92249 L
.19095 .93221 L
.19406 .9372 L
.19717 .94192 L
.20377 .95113 L
.20415 .95163 L
.21196 .96134 L
.21348 .96312 L
.2207 .97106 L
.22319 .97364 L
.23048 .98077 L
.98077 .98077 L
F
0 g
.98077 .50792 m
.97843 .50486 L
.97106 .49576 L
.97053 .49514 L
.96177 .48543 L
.96134 .48498 L
.95203 .47572 L
.95163 .47534 L
.94192 .46667 L
.94113 .46601 L
.93221 .45884 L
.92884 .45629 L
.92249 .45172 L
.91486 .44658 L
.91278 .44525 L
.90307 .43934 L
.89874 .43687 L
.89336 .43394 L
.88364 .42899 L
.87982 .42716 L
.87393 .42446 L
.86422 .4203 L
.85703 .41744 L
.85451 .41649 L
.84479 .41299 L
.83508 .40979 L
.82837 .40773 L
.82537 .40685 L
.81566 .40418 L
.80594 .40174 L
.79623 .39952 L
.7891 .39802 L
.78652 .39751 L
.77681 .39569 L
.76709 .39407 L
.75738 .39262 L
.74767 .39134 L
.73796 .39023 L
.72824 .38927 L
.71853 .38846 L
.71643 .38831 L
.70882 .3878 L
.69911 .38728 L
.68939 .3869 L
.67968 .38665 L
.66997 .38653 L
.66026 .38654 L
.65054 .38668 L
.64083 .38694 L
.63112 .38732 L
Mistroke
.62141 .38783 L
.6139 .38831 L
.61169 .38846 L
.60198 .38921 L
.59227 .39009 L
.58256 .39109 L
.57284 .39221 L
.56313 .39345 L
.55342 .39483 L
.54371 .39633 L
.53399 .39796 L
.53367 .39802 L
.52428 .39973 L
.51457 .40163 L
.50486 .40368 L
.49514 .40587 L
.48735 .40773 L
.48543 .40821 L
.47572 .4107 L
.46601 .41335 L
.45629 .41617 L
.4521 .41744 L
.44658 .41916 L
.43687 .42234 L
.42716 .4257 L
.42313 .42716 L
.41744 .42927 L
.40773 .43304 L
.3984 .43687 L
.39802 .43703 L
.38831 .44126 L
.37859 .44574 L
.37682 .44658 L
.36888 .45048 L
.35917 .4555 L
.35769 .45629 L
.34946 .46083 L
.34054 .46601 L
.33974 .46648 L
.33003 .47249 L
.32504 .47572 L
.32032 .47887 L
.31094 .48543 L
.31061 .48567 L
.30089 .49292 L
.29804 .49514 L
.29118 .50067 L
.2862 .50486 L
.28147 .50897 L
.27528 .51457 L
Mistroke
.27176 .51788 L
.2652 .52428 L
.26204 .52748 L
.25585 .53399 L
.25233 .53785 L
.24717 .54371 L
.24262 .54911 L
.23911 .55342 L
.23291 .56139 L
.2316 .56313 L
.2246 .57284 L
.22319 .57488 L
.21808 .58256 L
.21348 .58983 L
.21199 .59227 L
.20632 .60198 L
.20377 .60657 L
.20102 .61169 L
.19609 .62141 L
.19406 .62562 L
.1915 .63112 L
.18723 .64083 L
.18434 .64783 L
.18326 .65054 L
.1796 .66026 L
.17621 .66997 L
.17463 .6748 L
.1731 .67968 L
.17025 .68939 L
.16767 .69911 L
.16533 .70882 L
.16492 .71066 L
.16325 .71853 L
.16141 .72824 L
.15982 .73796 L
.15848 .74767 L
.15738 .75738 L
.15654 .76709 L
.15595 .77681 L
.15561 .78652 L
.15555 .79623 L
.15575 .80594 L
.15624 .81566 L
.15703 .82537 L
.15813 .83508 L
.15955 .84479 L
.16131 .85451 L
.16344 .86422 L
.16492 .87013 L
.16595 .87393 L
Mistroke
.16888 .88364 L
.17225 .89336 L
.17463 .89951 L
.1761 .90307 L
.18047 .91278 L
.18434 .92051 L
.1854 .92249 L
.19095 .93221 L
.19406 .9372 L
.19717 .94192 L
.20377 .95113 L
.20415 .95163 L
.21196 .96134 L
.21348 .96312 L
.2207 .97106 L
.22319 .97364 L
.23048 .98077 L
Mfstroke
.85 g
.98077 .6525 m
.98026 .65054 L
.97755 .64083 L
.97449 .63112 L
.97106 .62142 L
.97105 .62141 L
.96721 .61169 L
.96293 .60198 L
.96134 .59862 L
.95818 .59227 L
.95292 .58256 L
.95163 .58032 L
.94709 .57284 L
.94192 .565 L
.94063 .56313 L
.93346 .55342 L
.93221 .55183 L
.92548 .54371 L
.92249 .54032 L
.91658 .53399 L
.91278 .53016 L
.9066 .52428 L
.90307 .52111 L
.89533 .51457 L
.89336 .51299 L
.88364 .50567 L
.8825 .50486 L
.87393 .49906 L
.86769 .49514 L
.86422 .49307 L
.85451 .48763 L
.85031 .48543 L
.84479 .48268 L
.83508 .47819 L
.82932 .47572 L
.82537 .4741 L
.81566 .4704 L
.80594 .46704 L
.80276 .46601 L
.79623 .464 L
.78652 .46126 L
.77681 .4588 L
.76709 .45661 L
.76558 .45629 L
.75738 .45467 L
.74767 .45297 L
.73796 .45149 L
.72824 .45023 L
.71853 .44918 L
.70882 .44833 L
.69911 .44767 L
.68939 .4472 L
.67968 .44691 L
.66997 .44681 L
.66026 .44688 L
.65054 .44712 L
.64083 .44754 L
.63112 .44812 L
.62141 .44888 L
.61169 .4498 L
.60198 .45089 L
.59227 .45216 L
.58256 .4536 L
.57284 .45521 L
.56685 .45629 L
.56313 .457 L
.55342 .45897 L
.54371 .46113 L
.53399 .46347 L
.5243 .46601 L
.52428 .46601 L
.51457 .46875 L
.50486 .47171 L
.49514 .47488 L
.49267 .47572 L
.48543 .47827 L
.47572 .48191 L
.46687 .48543 L
.46601 .48579 L
.45629 .48993 L
.44658 .49436 L
.44492 .49514 L
.43687 .49908 L
.42716 .50411 L
.42577 .50486 L
.41744 .50948 L
.40879 .51457 L
.40773 .51521 L
.39802 .52134 L
.39358 .52428 L
.38831 .52789 L
.37982 .53399 L
.37859 .53491 L
.36888 .54244 L
.36732 .54371 L
.35917 .55055 L
.3559 .55342 L
.34946 .55929 L
.34542 .56313 L
.33974 .56876 L
.33579 .57284 L
.33003 .57906 L
.32692 .58256 L
.32032 .59033 L
.31874 .59227 L
.31118 .60198 L
.31061 .60275 L
.3042 .61169 L
.30089 .61658 L
.29776 .62141 L
.29181 .63112 L
.29118 .6322 L
.28633 .64083 L
.28147 .6502 L
.2813 .65054 L
.27668 .66026 L
.27246 .66997 L
.27176 .67169 L
.26863 .67968 L
.26517 .68939 L
.26206 .69911 L
.26204 .69917 L
.25931 .70882 L
.2569 .71853 L
.25483 .72824 L
.25309 .73796 L
.25233 .74291 L
.2517 .74767 L
.25064 .75738 L
.24992 .76709 L
.24954 .77681 L
.24952 .78652 L
.24986 .79623 L
.25057 .80594 L
.25167 .81566 L
.25233 .8203 L
.25318 .82537 L
.25511 .83508 L
.25748 .84479 L
.26033 .85451 L
.26204 .85966 L
.26368 .86422 L
.26758 .87393 L
.27176 .88303 L
.27206 .88364 L
.27717 .89336 L
.28147 .90067 L
.28297 .90307 L
.28953 .91278 L
.29118 .91506 L
.29693 .92249 L
.30089 .92726 L
.30526 .93221 L
.31061 .93788 L
.31465 .94192 L
.32032 .94727 L
.32524 .95163 L
.33003 .95567 L
.33721 .96134 L
.33974 .96326 L
.34946 .97015 L
.3508 .97106 L
.35917 .97646 L
.36632 .98077 L
.98077 .98077 L
F
0 g
.98077 .6525 m
.98026 .65054 L
.97755 .64083 L
.97449 .63112 L
.97106 .62142 L
.97105 .62141 L
.96721 .61169 L
.96293 .60198 L
.96134 .59862 L
.95818 .59227 L
.95292 .58256 L
.95163 .58032 L
.94709 .57284 L
.94192 .565 L
.94063 .56313 L
.93346 .55342 L
.93221 .55183 L
.92548 .54371 L
.92249 .54032 L
.91658 .53399 L
.91278 .53016 L
.9066 .52428 L
.90307 .52111 L
.89533 .51457 L
.89336 .51299 L
.88364 .50567 L
.8825 .50486 L
.87393 .49906 L
.86769 .49514 L
.86422 .49307 L
.85451 .48763 L
.85031 .48543 L
.84479 .48268 L
.83508 .47819 L
.82932 .47572 L
.82537 .4741 L
.81566 .4704 L
.80594 .46704 L
.80276 .46601 L
.79623 .464 L
.78652 .46126 L
.77681 .4588 L
.76709 .45661 L
.76558 .45629 L
.75738 .45467 L
.74767 .45297 L
.73796 .45149 L
.72824 .45023 L
.71853 .44918 L
.70882 .44833 L
Mistroke
.69911 .44767 L
.68939 .4472 L
.67968 .44691 L
.66997 .44681 L
.66026 .44688 L
.65054 .44712 L
.64083 .44754 L
.63112 .44812 L
.62141 .44888 L
.61169 .4498 L
.60198 .45089 L
.59227 .45216 L
.58256 .4536 L
.57284 .45521 L
.56685 .45629 L
.56313 .457 L
.55342 .45897 L
.54371 .46113 L
.53399 .46347 L
.5243 .46601 L
.52428 .46601 L
.51457 .46875 L
.50486 .47171 L
.49514 .47488 L
.49267 .47572 L
.48543 .47827 L
.47572 .48191 L
.46687 .48543 L
.46601 .48579 L
.45629 .48993 L
.44658 .49436 L
.44492 .49514 L
.43687 .49908 L
.42716 .50411 L
.42577 .50486 L
.41744 .50948 L
.40879 .51457 L
.40773 .51521 L
.39802 .52134 L
.39358 .52428 L
.38831 .52789 L
.37982 .53399 L
.37859 .53491 L
.36888 .54244 L
.36732 .54371 L
.35917 .55055 L
.3559 .55342 L
.34946 .55929 L
.34542 .56313 L
.33974 .56876 L
Mistroke
.33579 .57284 L
.33003 .57906 L
.32692 .58256 L
.32032 .59033 L
.31874 .59227 L
.31118 .60198 L
.31061 .60275 L
.3042 .61169 L
.30089 .61658 L
.29776 .62141 L
.29181 .63112 L
.29118 .6322 L
.28633 .64083 L
.28147 .6502 L
.2813 .65054 L
.27668 .66026 L
.27246 .66997 L
.27176 .67169 L
.26863 .67968 L
.26517 .68939 L
.26206 .69911 L
.26204 .69917 L
.25931 .70882 L
.2569 .71853 L
.25483 .72824 L
.25309 .73796 L
.25233 .74291 L
.2517 .74767 L
.25064 .75738 L
.24992 .76709 L
.24954 .77681 L
.24952 .78652 L
.24986 .79623 L
.25057 .80594 L
.25167 .81566 L
.25233 .8203 L
.25318 .82537 L
.25511 .83508 L
.25748 .84479 L
.26033 .85451 L
.26204 .85966 L
.26368 .86422 L
.26758 .87393 L
.27176 .88303 L
.27206 .88364 L
.27717 .89336 L
.28147 .90067 L
.28297 .90307 L
.28953 .91278 L
.29118 .91506 L
Mistroke
.29693 .92249 L
.30089 .92726 L
.30526 .93221 L
.31061 .93788 L
.31465 .94192 L
.32032 .94727 L
.32524 .95163 L
.33003 .95567 L
.33721 .96134 L
.33974 .96326 L
.34946 .97015 L
.3508 .97106 L
.35917 .97646 L
.36632 .98077 L
Mfstroke
.25 g
.91351 .01923 m
.91278 .01956 L
.90307 .02376 L
.89336 .02756 L
.88956 .02894 L
.88364 .031 L
.87393 .03414 L
.86422 .037 L
.85816 .03866 L
.85451 .03961 L
.84479 .042 L
.83508 .04418 L
.82537 .04619 L
.81566 .04802 L
.8137 .04837 L
.80594 .0497 L
.79623 .05123 L
.78652 .05263 L
.77681 .05391 L
.76709 .05507 L
.75738 .05613 L
.74767 .05708 L
.73796 .05794 L
.7363 .05808 L
.72824 .05871 L
.71853 .0594 L
.70882 .06 L
.69911 .06052 L
.68939 .06097 L
.67968 .06135 L
.66997 .06166 L
.66026 .0619 L
.65054 .06208 L
.64083 .06219 L
.63112 .06225 L
.62141 .06225 L
.61169 .06218 L
.60198 .06206 L
.59227 .06189 L
.58256 .06166 L
.57284 .06138 L
.56313 .06104 L
.55342 .06065 L
.54371 .0602 L
.53399 .05971 L
.52428 .05916 L
.51457 .05856 L
.50746 .05808 L
.50486 .0579 L
.49514 .05719 L
.48543 .05643 L
.47572 .05561 L
.46601 .05474 L
.45629 .05381 L
.44658 .05283 L
.43687 .05179 L
.42716 .0507 L
.41744 .04954 L
.40807 .04837 L
.40773 .04832 L
.39802 .04705 L
.38831 .04571 L
.37859 .04431 L
.36888 .04284 L
.35917 .04131 L
.34946 .0397 L
.34333 .03866 L
.33974 .03803 L
.33003 .03628 L
.32032 .03446 L
.31061 .03257 L
.30089 .03059 L
.29306 .02894 L
.29118 .02854 L
.28147 .0264 L
.27176 .02418 L
.26204 .02186 L
.25233 .01946 L
.25144 .01923 L
F
0 g
.91351 .01923 m
.91278 .01956 L
.90307 .02376 L
.89336 .02756 L
.88956 .02894 L
.88364 .031 L
.87393 .03414 L
.86422 .037 L
.85816 .03866 L
.85451 .03961 L
.84479 .042 L
.83508 .04418 L
.82537 .04619 L
.81566 .04802 L
.8137 .04837 L
.80594 .0497 L
.79623 .05123 L
.78652 .05263 L
.77681 .05391 L
.76709 .05507 L
.75738 .05613 L
.74767 .05708 L
.73796 .05794 L
.7363 .05808 L
.72824 .05871 L
.71853 .0594 L
.70882 .06 L
.69911 .06052 L
.68939 .06097 L
.67968 .06135 L
.66997 .06166 L
.66026 .0619 L
.65054 .06208 L
.64083 .06219 L
.63112 .06225 L
.62141 .06225 L
.61169 .06218 L
.60198 .06206 L
.59227 .06189 L
.58256 .06166 L
.57284 .06138 L
.56313 .06104 L
.55342 .06065 L
.54371 .0602 L
.53399 .05971 L
.52428 .05916 L
.51457 .05856 L
.50746 .05808 L
.50486 .0579 L
.49514 .05719 L
Mistroke
.48543 .05643 L
.47572 .05561 L
.46601 .05474 L
.45629 .05381 L
.44658 .05283 L
.43687 .05179 L
.42716 .0507 L
.41744 .04954 L
.40807 .04837 L
.40773 .04832 L
.39802 .04705 L
.38831 .04571 L
.37859 .04431 L
.36888 .04284 L
.35917 .04131 L
.34946 .0397 L
.34333 .03866 L
.33974 .03803 L
.33003 .03628 L
.32032 .03446 L
.31061 .03257 L
.30089 .03059 L
.29306 .02894 L
.29118 .02854 L
.28147 .0264 L
.27176 .02418 L
.26204 .02186 L
.25233 .01946 L
.25144 .01923 L
Mfstroke
.925 g
.68565 .98077 m
.68939 .98035 L
.69911 .97912 L
.70882 .97765 L
.71853 .97592 L
.72824 .97392 L
.73796 .97165 L
.74029 .97106 L
.74767 .96907 L
.75738 .96618 L
.76709 .96296 L
.77158 .96134 L
.77681 .95936 L
.78652 .95537 L
.79479 .95163 L
.79623 .95095 L
.80594 .94605 L
.81341 .94192 L
.81566 .94061 L
.82537 .93459 L
.82894 .93221 L
.83508 .92789 L
.8422 .92249 L
.84479 .92042 L
.85369 .91278 L
.85451 .91204 L
.86375 .90307 L
.86422 .90259 L
.87263 .89336 L
.87393 .89182 L
.88048 .88364 L
.88364 .87938 L
.88746 .87393 L
.89336 .86472 L
.89366 .86422 L
.89916 .85451 L
.90307 .84683 L
.90404 .84479 L
.90835 .83508 L
.91212 .82537 L
.91278 .82353 L
.91541 .81566 L
.91822 .80594 L
.9206 .79623 L
.92249 .78687 L
.92256 .78652 L
.92411 .77681 L
.92526 .76709 L
.92603 .75738 L
.92642 .74767 L
.92642 .73796 L
.92605 .72824 L
.92529 .71853 L
.92414 .70882 L
.92258 .69911 L
.92249 .69862 L
.92061 .68939 L
.91821 .67968 L
.91535 .66997 L
.91278 .66239 L
.912 .66026 L
.90814 .65054 L
.90372 .64083 L
.90307 .63951 L
.89868 .63112 L
.89336 .62202 L
.89297 .62141 L
.88651 .61169 L
.88364 .60774 L
.8792 .60198 L
.87393 .59568 L
.87089 .59227 L
.86422 .58528 L
.86143 .58256 L
.85451 .5762 L
.85058 .57284 L
.84479 .5682 L
.83798 .56313 L
.83508 .5611 L
.82537 .55478 L
.82312 .55342 L
.81566 .54914 L
.80594 .54411 L
.80512 .54371 L
.79623 .53962 L
.78652 .53561 L
.78225 .53399 L
.77681 .53205 L
.76709 .52891 L
.75738 .52614 L
.74999 .52428 L
.74767 .52374 L
.73796 .52167 L
.72824 .51991 L
.71853 .51846 L
.70882 .5173 L
.69911 .51642 L
.68939 .5158 L
.67968 .51545 L
.66997 .51534 L
.66026 .51549 L
.65054 .51589 L
.64083 .51653 L
.63112 .51741 L
.62141 .51853 L
.61169 .5199 L
.60198 .52152 L
.59227 .52338 L
.58799 .52428 L
.58256 .5255 L
.57284 .52788 L
.56313 .53052 L
.55342 .53344 L
.55169 .53399 L
.54371 .53665 L
.53399 .54016 L
.52496 .54371 L
.52428 .54399 L
.51457 .54814 L
.50486 .55265 L
.50327 .55342 L
.49514 .55753 L
.48543 .56282 L
.48487 .56313 L
.47572 .56854 L
.46889 .57284 L
.46601 .57474 L
.45629 .58147 L
.4548 .58256 L
.44658 .58878 L
.44223 .59227 L
.43687 .59675 L
.43094 .60198 L
.42716 .60548 L
.42076 .61169 L
.41744 .61509 L
.41156 .62141 L
.40773 .62574 L
.40321 .63112 L
.39802 .63768 L
.39564 .64083 L
.38879 .65054 L
.38831 .65127 L
.38259 .66026 L
.37859 .66711 L
.37701 .66997 L
.372 .67968 L
.36888 .68635 L
.36754 .68939 L
.36361 .69911 L
.36017 .70882 L
.35917 .71195 L
.35723 .71853 L
.35477 .72824 L
.35277 .73796 L
.35125 .74767 L
.3502 .75738 L
.34962 .76709 L
.34952 .77681 L
.34991 .78652 L
.35081 .79623 L
.35223 .80594 L
.3542 .81566 L
.35675 .82537 L
.35917 .83298 L
.35991 .83508 L
.36372 .84479 L
.36824 .85451 L
.36888 .85577 L
.37353 .86422 L
.37859 .87235 L
.37965 .87393 L
.38671 .88364 L
.38831 .88567 L
.39482 .89336 L
.39802 .89685 L
.40412 .90307 L
.40773 .90651 L
.41481 .91278 L
.41744 .91498 L
.42713 .92249 L
.42716 .92251 L
.43687 .92927 L
.44144 .93221 L
.44658 .93535 L
.45629 .94086 L
.45827 .94192 L
.46601 .94587 L
.47572 .95043 L
.47844 .95163 L
.48543 .95458 L
.49514 .95836 L
.50349 .96134 L
.50486 .96181 L
.51457 .96494 L
.52428 .96778 L
.53399 .97034 L
.53692 .97106 L
.54371 .97264 L
.55342 .97469 L
.56313 .9765 L
.57284 .97808 L
.58256 .97944 L
.59227 .98058 L
.59405 .98077 L
F
0 g
.68565 .98077 m
.68939 .98035 L
.69911 .97912 L
.70882 .97765 L
.71853 .97592 L
.72824 .97392 L
.73796 .97165 L
.74029 .97106 L
.74767 .96907 L
.75738 .96618 L
.76709 .96296 L
.77158 .96134 L
.77681 .95936 L
.78652 .95537 L
.79479 .95163 L
.79623 .95095 L
.80594 .94605 L
.81341 .94192 L
.81566 .94061 L
.82537 .93459 L
.82894 .93221 L
.83508 .92789 L
.8422 .92249 L
.84479 .92042 L
.85369 .91278 L
.85451 .91204 L
.86375 .90307 L
.86422 .90259 L
.87263 .89336 L
.87393 .89182 L
.88048 .88364 L
.88364 .87938 L
.88746 .87393 L
.89336 .86472 L
.89366 .86422 L
.89916 .85451 L
.90307 .84683 L
.90404 .84479 L
.90835 .83508 L
.91212 .82537 L
.91278 .82353 L
.91541 .81566 L
.91822 .80594 L
.9206 .79623 L
.92249 .78687 L
.92256 .78652 L
.92411 .77681 L
.92526 .76709 L
.92603 .75738 L
.92642 .74767 L
Mistroke
.92642 .73796 L
.92605 .72824 L
.92529 .71853 L
.92414 .70882 L
.92258 .69911 L
.92249 .69862 L
.92061 .68939 L
.91821 .67968 L
.91535 .66997 L
.91278 .66239 L
.912 .66026 L
.90814 .65054 L
.90372 .64083 L
.90307 .63951 L
.89868 .63112 L
.89336 .62202 L
.89297 .62141 L
.88651 .61169 L
.88364 .60774 L
.8792 .60198 L
.87393 .59568 L
.87089 .59227 L
.86422 .58528 L
.86143 .58256 L
.85451 .5762 L
.85058 .57284 L
.84479 .5682 L
.83798 .56313 L
.83508 .5611 L
.82537 .55478 L
.82312 .55342 L
.81566 .54914 L
.80594 .54411 L
.80512 .54371 L
.79623 .53962 L
.78652 .53561 L
.78225 .53399 L
.77681 .53205 L
.76709 .52891 L
.75738 .52614 L
.74999 .52428 L
.74767 .52374 L
.73796 .52167 L
.72824 .51991 L
.71853 .51846 L
.70882 .5173 L
.69911 .51642 L
.68939 .5158 L
.67968 .51545 L
.66997 .51534 L
Mistroke
.66026 .51549 L
.65054 .51589 L
.64083 .51653 L
.63112 .51741 L
.62141 .51853 L
.61169 .5199 L
.60198 .52152 L
.59227 .52338 L
.58799 .52428 L
.58256 .5255 L
.57284 .52788 L
.56313 .53052 L
.55342 .53344 L
.55169 .53399 L
.54371 .53665 L
.53399 .54016 L
.52496 .54371 L
.52428 .54399 L
.51457 .54814 L
.50486 .55265 L
.50327 .55342 L
.49514 .55753 L
.48543 .56282 L
.48487 .56313 L
.47572 .56854 L
.46889 .57284 L
.46601 .57474 L
.45629 .58147 L
.4548 .58256 L
.44658 .58878 L
.44223 .59227 L
.43687 .59675 L
.43094 .60198 L
.42716 .60548 L
.42076 .61169 L
.41744 .61509 L
.41156 .62141 L
.40773 .62574 L
.40321 .63112 L
.39802 .63768 L
.39564 .64083 L
.38879 .65054 L
.38831 .65127 L
.38259 .66026 L
.37859 .66711 L
.37701 .66997 L
.372 .67968 L
.36888 .68635 L
.36754 .68939 L
.36361 .69911 L
Mistroke
.36017 .70882 L
.35917 .71195 L
.35723 .71853 L
.35477 .72824 L
.35277 .73796 L
.35125 .74767 L
.3502 .75738 L
.34962 .76709 L
.34952 .77681 L
.34991 .78652 L
.35081 .79623 L
.35223 .80594 L
.3542 .81566 L
.35675 .82537 L
.35917 .83298 L
.35991 .83508 L
.36372 .84479 L
.36824 .85451 L
.36888 .85577 L
.37353 .86422 L
.37859 .87235 L
.37965 .87393 L
.38671 .88364 L
.38831 .88567 L
.39482 .89336 L
.39802 .89685 L
.40412 .90307 L
.40773 .90651 L
.41481 .91278 L
.41744 .91498 L
.42713 .92249 L
.42716 .92251 L
.43687 .92927 L
.44144 .93221 L
.44658 .93535 L
.45629 .94086 L
.45827 .94192 L
.46601 .94587 L
.47572 .95043 L
.47844 .95163 L
.48543 .95458 L
.49514 .95836 L
.50349 .96134 L
.50486 .96181 L
.51457 .96494 L
.52428 .96778 L
.53399 .97034 L
.53692 .97106 L
.54371 .97264 L
.55342 .97469 L
Mistroke
.56313 .9765 L
.57284 .97808 L
.58256 .97944 L
.59227 .98058 L
.59405 .98077 L
Mfstroke
1 g
.61169 .61113 m
.62141 .60878 L
.63112 .60687 L
.64083 .60537 L
.65054 .60429 L
.66026 .60362 L
.66997 .60337 L
.67968 .60353 L
.68939 .60413 L
.69911 .60517 L
.70882 .60667 L
.71853 .60867 L
.72824 .61119 L
.72996 .61169 L
.73796 .61429 L
.74767 .618 L
.7553 .62141 L
.75738 .62242 L
.76709 .62763 L
.77281 .63112 L
.77681 .63377 L
.78629 .64083 L
.78652 .64101 L
.79623 .64965 L
.79714 .65054 L
.80594 .66012 L
.80606 .66026 L
.81346 .66997 L
.81566 .67323 L
.81961 .67968 L
.82469 .68939 L
.82537 .69084 L
.82883 .69911 L
.83212 .70882 L
.83463 .71853 L
.83508 .72053 L
.8364 .72824 L
.83747 .73796 L
.83787 .74767 L
.83759 .75738 L
.83664 .76709 L
.83508 .77649 L
.83501 .77681 L
.83267 .78652 L
.82959 .79623 L
.82571 .80594 L
.82537 .80672 L
.82098 .81566 L
.81566 .82479 L
.81529 .82537 L
.80851 .83508 L
.80594 .83837 L
.80047 .84479 L
.79623 .84932 L
.79091 .85451 L
.78652 .85844 L
.77943 .86422 L
.77681 .8662 L
.76709 .87286 L
.76538 .87393 L
.75738 .87861 L
.74767 .88359 L
.74756 .88364 L
.73796 .8879 L
.72824 .8916 L
.72305 .89336 L
.71853 .89476 L
.70882 .89742 L
.69911 .89961 L
.68939 .90137 L
.67968 .90271 L
.6767 .90307 L
.66997 .90365 L
.66026 .90421 L
.65054 .90439 L
.64083 .90419 L
.63112 .90362 L
.62487 .90307 L
.62141 .90266 L
.61169 .90132 L
.60198 .89957 L
.59227 .89741 L
.58256 .89479 L
.57784 .89336 L
.57284 .89171 L
.56313 .88809 L
.55342 .8839 L
.55286 .88364 L
.54371 .87906 L
.53476 .87393 L
.53399 .87346 L
.52428 .86696 L
.5206 .86422 L
.51457 .85934 L
.50917 .85451 L
.50486 .85027 L
.49981 .84479 L
.49514 .83913 L
.49212 .83508 L
.48583 .82537 L
.48543 .82468 L
.48076 .81566 L
.47676 .80594 L
.47572 .80299 L
.47375 .79623 L
.47164 .78652 L
.47039 .77681 L
.46995 .76709 L
.4703 .75738 L
.47142 .74767 L
.47331 .73796 L
.47572 .72908 L
.47599 .72824 L
.47946 .71853 L
.48377 .70882 L
.48543 .70551 L
.48896 .69911 L
.49509 .68939 L
.49514 .68932 L
.50227 .67968 L
.50486 .67651 L
.51061 .66997 L
.51457 .66583 L
.52032 .66026 L
.52428 .65668 L
.53164 .65054 L
.53399 .64871 L
.54371 .6417 L
.545 .64083 L
.55342 .63551 L
.56112 .63112 L
.56313 .63004 L
.57284 .62519 L
.58138 .62141 L
.58256 .62092 L
.59227 .61717 L
.60198 .61392 L
.60958 .61169 L
F
0 g
.61169 .61113 m
.62141 .60878 L
.63112 .60687 L
.64083 .60537 L
.65054 .60429 L
.66026 .60362 L
.66997 .60337 L
.67968 .60353 L
.68939 .60413 L
.69911 .60517 L
.70882 .60667 L
.71853 .60867 L
.72824 .61119 L
.72996 .61169 L
.73796 .61429 L
.74767 .618 L
.7553 .62141 L
.75738 .62242 L
.76709 .62763 L
.77281 .63112 L
.77681 .63377 L
.78629 .64083 L
.78652 .64101 L
.79623 .64965 L
.79714 .65054 L
.80594 .66012 L
.80606 .66026 L
.81346 .66997 L
.81566 .67323 L
.81961 .67968 L
.82469 .68939 L
.82537 .69084 L
.82883 .69911 L
.83212 .70882 L
.83463 .71853 L
.83508 .72053 L
.8364 .72824 L
.83747 .73796 L
.83787 .74767 L
.83759 .75738 L
.83664 .76709 L
.83508 .77649 L
.83501 .77681 L
.83267 .78652 L
.82959 .79623 L
.82571 .80594 L
.82537 .80672 L
.82098 .81566 L
.81566 .82479 L
.81529 .82537 L
Mistroke
.80851 .83508 L
.80594 .83837 L
.80047 .84479 L
.79623 .84932 L
.79091 .85451 L
.78652 .85844 L
.77943 .86422 L
.77681 .8662 L
.76709 .87286 L
.76538 .87393 L
.75738 .87861 L
.74767 .88359 L
.74756 .88364 L
.73796 .8879 L
.72824 .8916 L
.72305 .89336 L
.71853 .89476 L
.70882 .89742 L
.69911 .89961 L
.68939 .90137 L
.67968 .90271 L
.6767 .90307 L
.66997 .90365 L
.66026 .90421 L
.65054 .90439 L
.64083 .90419 L
.63112 .90362 L
.62487 .90307 L
.62141 .90266 L
.61169 .90132 L
.60198 .89957 L
.59227 .89741 L
.58256 .89479 L
.57784 .89336 L
.57284 .89171 L
.56313 .88809 L
.55342 .8839 L
.55286 .88364 L
.54371 .87906 L
.53476 .87393 L
.53399 .87346 L
.52428 .86696 L
.5206 .86422 L
.51457 .85934 L
.50917 .85451 L
.50486 .85027 L
.49981 .84479 L
.49514 .83913 L
.49212 .83508 L
.48583 .82537 L
Mistroke
.48543 .82468 L
.48076 .81566 L
.47676 .80594 L
.47572 .80299 L
.47375 .79623 L
.47164 .78652 L
.47039 .77681 L
.46995 .76709 L
.4703 .75738 L
.47142 .74767 L
.47331 .73796 L
.47572 .72908 L
.47599 .72824 L
.47946 .71853 L
.48377 .70882 L
.48543 .70551 L
.48896 .69911 L
.49509 .68939 L
.49514 .68932 L
.50227 .67968 L
.50486 .67651 L
.51061 .66997 L
.51457 .66583 L
.52032 .66026 L
.52428 .65668 L
.53164 .65054 L
.53399 .64871 L
.54371 .6417 L
.545 .64083 L
.55342 .63551 L
.56112 .63112 L
.56313 .63004 L
.57284 .62519 L
.58138 .62141 L
.58256 .62092 L
.59227 .61717 L
.60198 .61392 L
.60958 .61169 L
.61169 .61113 L
Mfstroke
.775 g
.98077 .82187 m
.97987 .82537 L
.97716 .83508 L
.97412 .84479 L
.97106 .85358 L
.97072 .85451 L
.96693 .86422 L
.96274 .87393 L
.96134 .87696 L
.95811 .88364 L
.95299 .89336 L
.95163 .89578 L
.94735 .90307 L
.94192 .91159 L
.94112 .91278 L
.93425 .92249 L
.93221 .9252 L
.92664 .93221 L
.92249 .93711 L
.91821 .94192 L
.91278 .94766 L
.90881 .95163 L
.90307 .95707 L
.89829 .96134 L
.89336 .96554 L
.88644 .97106 L
.88364 .97318 L
.87393 .98012 L
.87297 .98077 L
.98077 .98077 L
F
0 g
.98077 .82187 m
.97987 .82537 L
.97716 .83508 L
.97412 .84479 L
.97106 .85358 L
.97072 .85451 L
.96693 .86422 L
.96274 .87393 L
.96134 .87696 L
.95811 .88364 L
.95299 .89336 L
.95163 .89578 L
.94735 .90307 L
.94192 .91159 L
.94112 .91278 L
.93425 .92249 L
.93221 .9252 L
.92664 .93221 L
.92249 .93711 L
.91821 .94192 L
.91278 .94766 L
.90881 .95163 L
.90307 .95707 L
.89829 .96134 L
.89336 .96554 L
.88644 .97106 L
.88364 .97318 L
.87393 .98012 L
.87297 .98077 L
s
.7 g
.98077 .95821 m
.97849 .96134 L
.97106 .97096 L
.97098 .97106 L
.9627 .98077 L
.98077 .98077 L
F
0 g
.98077 .95821 m
.97849 .96134 L
.97106 .97096 L
.97098 .97106 L
.9627 .98077 L
s
0 0 0 r
.055 w
.66472 .75716 Mdot
1 0 0 r
.0325 w
.23484 .01923 Mdot
.01923 .76016 Mdot
.30515 .98077 Mdot
.98077 .78497 Mdot
.56853 .90444 Mdot
.87844 .57303 Mdot
.68696 .77779 Mdot
.64082 .74726 Mdot
.6645 .75669 Mdot
.66471 .75718 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
0 1 0 r
.02 w
.23484 .01923 Mdot
.01923 .76016 Mdot
.30515 .98077 Mdot
.98077 .78497 Mdot
.56853 .90444 Mdot
.87844 .57303 Mdot
.68696 .77779 Mdot
.64082 .74726 Mdot
.6645 .75669 Mdot
.66471 .75718 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
0 0 1 r
.5 Mabswid
.23484 .01923 m
.23484 .01923 L
.01923 .76016 L
.30515 .98077 L
.56853 .90444 L
.68696 .77779 L
.64082 .74726 L
.6645 .75669 L
.66471 .75718 L
.66472 .75716 L
.66472 .75716 L
.66472 .75716 L
s
.015 w
.23484 .01923 Mdot
.23484 .01923 Mdot
.01923 .76016 Mdot
.30515 .98077 Mdot
.56853 .90444 Mdot
.68696 .77779 Mdot
.64082 .74726 Mdot
.6645 .75669 Mdot
.66471 .75718 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
.66472 .75716 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[22]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00403oool2000000@0oooo0P0000040?ooo`800000<`3oool500000380oooo1@0000020?oo
o`8000000`3oool4000002d0oooo1@0000020?ooo`8000001@3oool3000002/0oooo1@0000020?oo
o`8000000`3oool300000100oooo000?0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool00000=03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0<03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02`0oooo00<00000
0?ooo`3oool01`3oool010000000oooo0?ooo`00000?0?ooo`003`3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo000003@0oooo00<000000?ooo`3oool0=03oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool01`3oool5000002d0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000?0?ooo`003`3oool010000000oooo
0?ooo`0000090?ooo`800000=@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo0000
02h0oooo00<000000?ooo`3oool01`3oool300000100oooo000?0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool00000=03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0
oooo00L0oooo00@000000?ooo`3oool00000;`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0000002h0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0?0?ooo`00403oool2
000000X0oooo0P00000d0?ooo`800000=@3oool2000000X0oooo0P00000_0?ooo`8000002`3oool2
000002d0oooo0P00000:0?ooo`<000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`00000;00000040oooo000E0?ooo`03
0000003oool0000000h0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`40
00000@3oool001D0oooo00<000000?ooo`000000>P3oool20?l003`0oooo00<000000?ooo`3oool0
>P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo0180oooo0@0000010?ooo`003@3o
ool5000000<0oooo00<000000?ooo`3oool0>03oool60?l00<P0oooo0@0000010?ooo`003`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo03P0oooo0P3o0003003o00030?l0003oool0
oooo0<H0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`800000>03oool20?l0
00800?l000H0003o003o0000o`00o`000?ooo`00002^0?ooo`030000003oool0oooo01<0oooo0P00
00010?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo=@1CDe<2
0?l00007003o00000?l0003o0000o`00o`00o`0005=CD`0400000:/0?clo00<0000005=CD`1CDe<0
3`1CDe<50?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`020?ooocH0De=C00@0o`00003o00000?l0003o0P00o`0605=CD`D00000X`0o?cl300000180De=C
1@3oool100000040oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooocH0De=C0P3o
000010000?l00?l0003o003o000;05=CD`<00000W@0o?cl3000001D0De=C1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo>01CDe<00`000?l0o`0005=CD`0?05=CD`D00000T`0o
?cl5000001P0De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo>01CDe<0
0`000?l0De=C05=CD`0D05=CD`L00000RP0o?cl2000001d0De=C1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo=`1CDe<00`000?l0De=C05=CD`0L05=CD`H00000P@0o?cl30000
01l0De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo0P00000e05=CD`03
0000o`1CDe<0De=C0280De=C1@00001g03lo?`D000008P1CDe<50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool206IVIPD00000<01CDe<00`000?l0De=C05=CD`0W05=CD`P00000
JP0o?cl5000002L0De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1`1V
IVH2000002d0De=C00<0003o05=CD`1CDe<0<01CDe<:000005P0?clo2000000/05=CD`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T0IVIV0P00000[05=CD`030000o`1CDe<0
De=C03X0De=C2P00001603lo?`P00000=01CDe<50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool;06IVIP<00000:01CDe<00`000?l0De=C05=CD`1405=CDa8000009@0o?cl?0000
03`0De=C1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3P1VIVH600000280
De=C00<0003o05=CD`1CDe<0EP1CDe<U000004/0De=C1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo501VIVH3000001h0De=C00<0003o05=CD`1CDe<0a`1CDe<50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolG06IVIP@000006P1CDe<00`000?l0De=C05=C
D`3705=CD`D0oooo0@0000010?ooo`005@3oool2000000<0oooo6`1VIVH5000001D0De=C00<0003o
05=CD`1CDe<0a`1CDe<40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolP06IV
IP<000004@1CDe<00`000?l0De=C05=CD`3805=CD`D0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooob<0IVIV1@00000<05=CD`030000o`1CDe<0De=C0<P0De=C00<000000?ooo`3o
ool00P3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo:01VIVH7000000D0De=C
00<0003o05=CD`1CDe<0aP1CDe<2000000D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooobl0IVIV1@0000000`000?l0De=C05=CD`3305=CD`<000000P1VIVH50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolc06IVIP030000o`1VIVH0000000L00000]`1CDe<6
000000D0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo<`1VIVH00`00
0?l0IVIV06IVIP0706IVIPP00000[@1CDe<2000000/0IVIV1@3oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo<`1VIVH00`000?l0IVIV06IVIP0?06IVIPL00000WP1CDe<8000000d0
IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo<P1VIVH00`000?l0IVIV
06IVIP0G06IVIP/00000SP1CDe<5000001D0IVIV1@3oool100000040oooo000E0?ooo`030000003o
ool0oooo0080oooo<P1VIVH00`000?l0IVIV06IVIP0R06IVIPd00000M`1CDe<:000001X0IVIV1@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo<P1VIVH00`000?l0IVIV06IVIP0_
06IVIQ800000F01CDe<=000002@0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo<@1VIVH00`000?l0IVIV06IVIP1206IVIQ`00000901CDe<H00000340IVIV1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo<@1VIVH00`000?l0IVIV06IVIP1N06IVIR@0
0000B@1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooola06IVIP030000
o`1VIVH0IVIV0</0IVIV1@3oool100000040oooo000E0?ooo`8000000`3ooola06IVIP030000o`1V
IVH0IVIV0</0IVIV103oool200000040oooo000E0?ooo`030000003oool0oooo0080oooo<01VIVH0
0`000?l0IVIV06IVIP3<06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
oc00IVIV00<0003o06IVIP1VIVH0c01VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3oool`06IVIP030000o`1VIVH0IVIV0<`0IVIV1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo;`1VIVH00`000?l0IVIV06IVIP3=06IVIPD0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`020?ooobl0IVIV00<0003o06IVIP1VIVH0c@1VIVH50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3oool_06IVIP030000o`1VIVH0IVIV0<d0IVIV1@3oool1
00000040oooo000E0?ooo`030000003oool0oooo0080oooo;`1VIVH00`000?l0IVIV06IVIP3=06IV
IPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobh0IVIV00<0003o06IVIP1V
IVH0cP1VIVH50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool^06IVIP030000
o`1VIVH0IVIV0<h0IVIV1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo;P1V
IVH00`000?l0IVIV06IVIP3>06IVIPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`02
0?ooobd0IVIV00<0003o06IVIP1VIVH0c`1VIVH50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool:06IVIR<0000000<0003o000000000000d00000040?ooo`4000000@3oool001D0
oooo00<000000?ooo`3oool00P3oool:000002<0NGUi00<0003o07UiN@1iNGT0c`1iNGT50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3oool]07UiN@030000o`1iNGT0NGUi0<l0NGUi
1@3oool100000040oooo000E0?ooo`8000000`3oool/07UiN@030000o`1iNGT0NGUi0=00NGUi103o
ool200000040oooo000E0?ooo`030000003oool0oooo0080oooo;01iNGT00`000?l0NGUi07UiN@3@
07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooob`0NGUi00<0003o07Ui
N@1iNGT0d01iNGT50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool[07UiN@03
0000o`1iNGT0NGUi0=40NGUi1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo
:`1iNGT00`000?l0NGUi07UiN@3A07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooob/0NGUi00<0003o07UiN@1iNGT0d@1iNGT50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool[07UiN@030000o`1iNGT0NGUi0=40NGUi1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo:P1iNGT00`000?l0NGUi07UiN@3B07UiN@D0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooobX0NGUi00<0003o07UiN@1iNGT0dP1iNGT50?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool00P3ooolZ07UiN@030000o`1iNGT0NGUi0=80NGUi
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo:@1iNGT00`000?l0NGUi07Ui
N@3C07UiN@D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobT0NGUi00<0003o
07UiN@1iNGT0G01iNGTn000003T0NGUi1@3oool100000040oooo00000`3oool00000000000030000
0080oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`020?ooobT0NGUi00<0003o07Ui
N@1iNGT0A`1iNGTE000003h0S8b<4P00000W07UiN@D0oooo0@0000010?ooo`000`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3ooolY07UiN@03
0000o`1iNGT0NGUi03P0NGUi3`00001U08b<S0X000007@1iNGT50?ooo`4000000@3oool000<0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`8000000`3ooolX07UiN@030000
o`1iNGT0NGUi02l0NGUi2P00001n08b<S0P000005@1iNGT40?ooo`8000000@3oool000<0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo:01i
NGT00`000?l0NGUi07UiN@0W07UiN@P00000T02<S8`7000000h0NGUi1@3oool100000040oooo0003
0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`020?ooobP0NGUi00<0003o07UiN@1iNGT07`1iNGT8000009l0S8b<1P00000807UiN@D0oooo0@00
00010?ooo`000P3oool2000000X0oooo0P0000050?ooo`030000003oool0oooo0080oooo9`1iNGT0
0`000?l0NGUi07UiN@0H07UiN@P00000[@2<S8`5000000<0NGUi1@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo9`1iNGT00`000?l0NGUi07UiN@0A07UiN@L00000^P2<S8`30000
00D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobL0NGUi00<0003o07UiN@1i
NGT0301iNGT500000<@0S8b<00<000000?ooo`3oool00P3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo9P1iNGT00`000?l0NGUi07UiN@0807UiN@D00000b@2<S8`50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolV07UiN@030000o`1iNGT0NGUi00D0NGUi0`00
003>08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooobH0NGUi00<0003o
07UiN@1iNGT01@00003A08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
obH0NGUi00<0003o000000000000eP2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolQ07UiN@@0000000<0003o08b<S02<S8`0e`2<S8`50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3ooolN07UiN@<00000102<S8`00`000?l0S8b<08b<S01Z08b<S2h00000
?`2<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolL07UiN@8000001`2<
S8`00`000?l0S8b<08b<S01M08b<S0d00000;P2OWil=00000380S8b<1@3oool100000040oooo000E
0?ooo`030000003oool0oooo0080oooo6@1iNGT3000000P0S8b<00<0003o08b<S02<S8`0E02<S8`:
000004P0WinO2000000Z08b<S0D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oo
oaL0NGUi0P00000;08b<S0030000o`2<S8`0S8b<04X0S8b<2P00001J09nOW`L000008`2<S8`50?oo
o`4000000@3oool001D0oooo0P0000030?oooa@0NGUi0`00000=08b<S0030000o`2<S8`0S8b<04D0
S8b<1@00001[09nOW`H000007@2<S8`40?ooo`8000000@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolA07UiN@<00000402<S8`00`000?l0S8b<08b<S00m08b<S0P00000MP2OWil5000001P0S8b<
1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo3`1iNGT200000180S8b<00<0
003o08b<S02<S8`0>@2<S8`5000008<0WinO0`00000E08b<S0D0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo``0NGUi0`00000D08b<S0030000o`2<S8`0S8b<03@0S8b<1@00002;
09nOW`D00000402<S8`50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool:07Ui
N@8000005`2<S8`00`000?l0S8b<08b<S00_08b<S0D00000U@2OWil2000000h0S8b<1@3oool10000
0040oooo000E0?ooo`030000003oool0oooo0080oooo2@1iNGT00`000000S8b<08b<S00F08b<S003
0000o`2<S8`0S8b<02d0S8b<0`00002L09nOW`<000002`2<S8`50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool707UiN@8000006@2<S8`00`000?l0S8b<08b<S00X08b<S0D00000
XP2OWil3000000P0S8b<1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo1@1i
NGT2000001/0S8b<00<0003o08b<S02<S8`0902<S8`400000:X0WinO0`00000508b<S0D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`@0NGUi00<0000008b<S02<S8`06`2<S8`0
0`000?l0S8b<08b<S00S08b<S0030000002OWil0WinO0:l0WinO0P00000308b<S0D0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<0NGUi00<0000008b<S02<S8`06`2<S8`00`00
0?l0S8b<08b<S00O08b<S0D00000]02OWil20000000308b<S03oool0oooo00<0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo`0307UiN@000000000001h0S8b<00<0003o08b<S02<
S8`0702<S8`3000005X0WinO7000001509nOW`030000003oool0oooo00<0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`020?ooo`030000002<S8`0S8b<01h0S8b<00<0003o08b<S02<S8`0
6@2<S8`300000500WinO3@00000L0;>c/`d00000>@2OWil00`000000oooo0?ooo`020?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3ooolP08b<S0030000o`2<S8`0S8b<01P0S8b<0P00
001909nOW`X00000=P2c/k<700000380WinO1@3oool100000040oooo000E0?ooo`030000003oool0
oooo0080oooo802<S8`00`000?l0S8b<08b<S00E08b<S0<00000A@2OWil6000004L0/k>c1@00000]
09nOW`D0oooo0@0000010?ooo`005@3oool2000000<0oooo802<S8`00`000?l0S8b<08b<S00C08b<
S0800000@@2OWil700000580/k>c1P00000W09nOW`@0oooo0P0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooob00S8b<00<0003o08b<S02<S8`04@2<S8`2000003d0WinO1P00001O0;>c/`D0
00008P2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolO08b<S0030000
o`2<S8`0S8b<0100S8b<0P00000m09nOW`800000JP2c/k<200000200WinO1@3oool100000040oooo
000E0?ooo`030000003oool0oooo0080oooo7`2<S8`00`000?l0S8b<08b<S00?08b<S0030000002O
Wil0WinO03P0WinO1@00001^0;>c/`<000007@2OWil50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolO08b<S0030000o`2<S8`0S8b<00`0S8b<0`00000f09nOW`D00000MP2c/k<5
000001P0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo7P2<S8`00`00
0?l0S8b<08b<S00;08b<S0800000=P2OWil300000800/k>c0`00000E09nOW`D0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?oooah0S8b<00<0003o08b<S02<S8`02@2<S8`2000003@0
WinO100000260;>c/`8000004`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolN08b<S0030000o`2<S8`0S8b<00P0S8b<00<0000009nOW`2OWil0<02OWil4000008`0/k>c
0P00000A09nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooah0S8b<00<0
003o08b<S02<S8`01P2<S8`200000340WinO0P00002B0;>c/`8000003`2OWil50?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolM08b<S0030000o`2<S8`0S8b<00D0S8b<0P00000`
09nOW`<00000UP2c/k<2000000d0WinO1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo7@2<S8`00`000?l0S8b<08b<S00408b<S0030000002OWil0WinO02d0WinO0`00002K0;>c
/`8000002`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolM08b<S003
0000o`2<S8`0S8b<0080S8b<0P00000^09nOW`800000BP2c/k<L000003X0/k>c0P00000909nOW`D0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa`0S8b<00<0003o08b<S02<S8`0
0P2<S8`00`000000WinO09nOW`0[09nOW`<00000@`2c/k<9000001`0a/K62@00000c0;>c/`800000
1`2OWil50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3ooolL08b<S0030000o`2<
S8`0S8b<00800000;02OWil2000003h0/k>c2000000^0<K6aPP00000;@2c/k<00`000000WinO09nO
W`0409nOW`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa`0S8b<00<0003o
08b<S0000000;@2OWil00`000000/k>c0;>c/`0i0;>c/`D00000?P36a/H5000002T0/k>c0P000004
09nOW`D0oooo0@0000010?ooo`005@3oool2000000<0oooo6`2<S8`00`000?l000000000000/09nO
W`800000=`2c/k<5000004P0a/K60P00000Y0;>c/`8000000P2OWil40?ooo`8000000@3oool001D0
oooo00<000000?ooo`3oool00P3ooolK08b<S0030000o`2OWil0WinO02X0WinO0P00000d0;>c/`D0
0000C`36a/H5000002H0/k>c00<0000009nOW`3oool0103oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo6`2<S8`00`000?l0WinO09nOW`0X09nOW`800000<@2c/k<5000005T0a/K6
0`00000S0;>c/`030000002OWil0oooo00@0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?oooaX0S8b<00<000000000o`2OWil09`2OWil200000300/k>c0`00001Q0<K6aP<000008@2c
/k<2000000@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooaP0S8b<0P000000
0`000?l0WinO09nOW`0U09nOW`800000;`2c/k<3000006L0a/K60P00000P0;>c/`D0oooo0@000001
0?ooo`005@3oool00`000000oooo0?ooo`020?oooaL0S8b<00@0000009nOW`2OWil0003o9@2OWil2
000002l0/k>c0P00001/0<K6aP<000007@2c/k<50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3ooolF08b<S0050000002OWil0WinO09nOW`000?l0902OWil00`000000/k>c0;>c/`0Z
0;>c/`D00000L@36a/H2000001/0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo5@2<S8`01@000000WinO09nOW`2OWil0003o02<0WinO0P00000Z0;>c/`<00000N036a/H2
000001T0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo502<S8`00`00
0000WinO09nOW`0209nOW`030000o`2OWil0WinO01l0WinO0P00000Z0;>c/`800000O@36a/H20000
01L0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo4`2<S8`00`000000
WinO09nOW`0309nOW`030000o`2OWil0WinO01h0WinO00<000000;>c/`2c/k<0:02c/k<200000840
a/K60P00000E0;>c/`D0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?oooa80S8b<
00<0000009nOW`2OWil0102OWil00`000?l0WinO09nOW`0M09nOW`030000002c/k<0/k>c02L0/k>c
0P0000250<K6aP8000004`2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
oolA08b<S0030000002OWil0WinO00@0WinO00<0003o09nOW`2OWil0702OWil2000002P0/k>c0P00
00290<K6aP030000002c/k<0/k>c0100/k>c1@3oool100000040oooo00000`3oool0000000000003
00000080oooo0P0000050?ooo`<000000`3oool00`000000oooo0?ooo`020?oooa00S8b<00<00000
09nOW`2OWil01@2OWil00`000?l0WinO09nOW`0K09nOW`030000002c/k<0/k>c02H0/k>c0P000011
0<K6aQL00000=036a/H200000100/k>c1@3oool100000040oooo00030?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`l0S8b<00<0000009nO
W`2OWil01P2OWil00`000?l0WinO09nOW`0J09nOW`030000002c/k<0/k>c02@0/k>c0`00000i0<K6
aPX000005`3IfMT7000002l0a/K60P00000>0;>c/`D0oooo0@0000010?ooo`000`3oool00`000000
oooo0?ooo`070?ooo`D000000`3oool2000000<0oooo3P2<S8`00`000000WinO09nOW`0609nOW`03
0000o`2OWil0WinO01X0WinO00<000000;>c/`2c/k<08`2c/k<2000003L0a/K61@00000X0=WIf@D0
0000:`36a/H00`000000/k>c0;>c/`0<0;>c/`@0oooo0P0000010?ooo`000`3oool00`000000oooo
0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool>08b<S003
0000002OWil0WinO00H0WinO00<0003o09nOW`2OWil06@2OWil00`000000/k>c0;>c/`0T0;>c/`03
00000036a/H0a/K60300a/K61P00000b0=WIf@H000009P36a/H2000000`0/k>c1@3oool100000040
oooo00030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`000000103oool00`000000oooo
0?ooo`020?ooo`d0S8b<00<0000009nOW`2OWil01`2OWil00`000?l0WinO09nOW`0G09nOW`800000
902c/k<3000002h0a/K61@00000n0=WIf@8000009P36a/H2000000X0/k>c1@3oool100000040oooo
00020?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool00P3oool<08b<S08000002@2O
Wil00`000?l0WinO09nOW`0F09nOW`030000002c/k<0/k>c0280/k>c0P00000^0<K6aP<00000A@3I
fMT5000002<0a/K600<000000;>c/`2c/k<01`2c/k<50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool<08b<S0030000002OWil0WinO00L0WinO00<0003o09nOW`2OWil05P2OWil0
0`000000/k>c0;>c/`0Q0;>c/`800000;P36a/H2000004d0fMWI0`00000Q0<K6aP030000002c/k<0
/k>c00H0/k>c1@3oool100000040oooo000E0?ooo`030000003oool0oooo0080oooo2`2<S8`00`00
0000WinO09nOW`0809nOW`030000o`2OWil0WinO01D0WinO00<000000;>c/`2c/k<08@2c/k<00`00
0000a/K60<K6aP0Y0<K6aPD00000DP3IfMT200000200a/K600<000000;>c/`2c/k<01@2c/k<50?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool:08b<S08000002P2OWil00`000?l0
WinO09nOW`0D09nOW`030000002c/k<0/k>c0240/k>c00<000000<K6aP36a/H09`36a/H4000005P0
fMWI0`00000N0<K6aP030000002c/k<0/k>c00@0/k>c1@3oool100000040oooo000E0?ooo`030000
003oool0oooo0080oooo2@2<S8`00`000000WinO09nOW`0909nOW`030000o`2OWil0WinO01@0WinO
00<000000;>c/`2c/k<0802c/k<2000002P0a/K60P00001O0=WIf@0300000036a/H0a/K601`0a/K6
00<000000;>c/`2c/k<00`2c/k<50?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3o
ool908b<S0030000002OWil0WinO00T0WinO00<0003o09nOW`2OWil04`2OWil00`000000/k>c0;>c
/`0O0;>c/`8000009`36a/H300000680fMWI0`00000L0<K6aP030000002c/k<0/k>c0080/k>c1@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo202<S8`00`000000WinO09nOW`0:
09nOW`030000o`2OWil0WinO0180WinO00<000000;>c/`2c/k<07`2c/k<00`000000a/K60<K6aP0U
0<K6aP800000J03IfMT00`000000a/K60<K6aP0J0<K6aP040000002c/k<0/k>c0;>c/`D0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P0S8b<00<0000009nOW`2OWil02P2OWil0
0`000?l0WinO09nOW`0A09nOW`030000002c/k<0/k>c01l0/k>c00<000000<K6aP36a/H09036a/H2
000006/0fMWI0P00000K0<K6aP030000002c/k<0/k>c00D0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`L0S8b<00<0000009nOW`2OWil02P2OWil00`000?l0WinO09nOW`0A09nO
W`030000002c/k<0/k>c01l0/k>c00<000000<K6aP36a/H09036a/H00`000000fMWI0=WIf@1]0=WI
f@0300000036a/H0a/K601T0a/K600<000000;>c/`3oool0103oool100000040oooo000E0?ooo`03
0000003oool0oooo0080oooo1P2<S8`00`000000WinO09nOW`0;09nOW`030000o`2OWil0WinO0100
WinO00<000000;>c/`2c/k<07P2c/k<2000002@0a/K60`00001a0=WIf@8000006P36a/H00`000000
oooo0?ooo`030?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool00P3oool608b<S0030000
002OWil0WinO00/0WinO00<0003o09nOW`2OWil03`2OWil2000001l0/k>c00<000000<K6aP36a/H0
8P36a/H2000007H0fMWI0P00000I0<K6aP030000003oool0oooo0080oooo0@0000010?ooo`005@3o
ool2000000<0oooo1@2<S8`00`000000WinO09nOW`0;09nOW`030000o`2OWil0WinO00l0WinO00<0
00000;>c/`2c/k<07P2c/k<00`000000a/K60<K6aP0R0<K6aP030000003IfMT0fMWI07L0fMWI00<0
00000<K6aP36a/H05`36a/H010000000oooo0?ooo`3oool200000040oooo000E0?ooo`030000003o
ool0oooo0080oooo1@2<S8`00`000000WinO09nOW`0;09nOW`030000o`2OWil0WinO00l0WinO00<0
00000;>c/`2c/k<07P2c/k<00`000000a/K60<K6aP0P0<K6aP800000N`3IfMT2000001L0a/K61@3o
ool100000040oooo000E0?ooo`030000003oool0oooo0080oooo102<S8`00`000000WinO09nOW`0<
09nOW`030000o`2OWil0WinO00h0WinO00<000000;>c/`2c/k<07@2c/k<200000240a/K60P00000n
0=WIf@`00000=@3IfMT2000001D0a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo
0080oooo102<S8`00`000000WinO09nOW`0<09nOW`030000o`2OWil0WinO00d0WinO00<000000;>c
/`2c/k<07@2c/k<00`000000a/K60<K6aP0P0<K6aP030000003IfMT0fMWI03@0fMWI2P00000<0>c/
k0/00000;03IfMT00`000000a/K60<K6aP0B0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`020?ooo`<0S8b<00<0000009nOW`2OWil0302OWil00`000?l0WinO09nOW`0>09nOW`03
0000002c/k<0/k>c01`0/k>c00<000000<K6aP36a/H08036a/H00`000000fMWI0=WIf@0`0=WIf@D0
00008@3/k>`4000002T0fMWI00<000000<K6aP36a/H04@36a/H50?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool00P3oool308b<S0030000002OWil0WinO00`0WinO00<0003o09nOW`2OWil0
3@2OWil00`000000/k>c0;>c/`0K0;>c/`8000008@36a/H200000300fMWI0`00000Z0>c/k0@00000
9P3IfMT00`000000a/K60<K6aP0@0<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`<0S8b<00<0000009nOW`2OWil0302OWil00`000?l0WinO09nOW`0<09nOW`030000002c
/k<0/k>c01/0/k>c00<000000<K6aP36a/H08036a/H00`000000fMWI0=WIf@0[0=WIf@D00000<@3/
k>`2000002D0fMWI00<000000<K6aP36a/H03`36a/H50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool208b<S0030000002OWil0WinO00`0WinO00<0003o09nOW`2OWil0302OWil0
0`000000/k>c0;>c/`0L0;>c/`0300000036a/H0a/K601d0a/K60`00000[0=WIf@<00000>03/k>`4
00000280fMWI00<000000<K6aP36a/H03P36a/H50?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool00P3oool208b<S0030000002OWil0WinO00`0WinO00<0003o09nOW`2OWil0302OWil00`00
0000/k>c0;>c/`0K0;>c/`0300000036a/H0a/K601d0a/K600<000000=WIf@3IfMT0:P3IfMT20000
03l0k>c/00<000000=WIf@3IfMT0803IfMT00`000000a/K60<K6aP0=0<K6aPD0oooo0@0000010?oo
o`005@3oool00`000000oooo0?ooo`020?ooo`0308b<S0000000WinO00h0WinO00<0003o09nOW`2O
Wil02`2OWil00`000000/k>c0;>c/`0K0;>c/`0300000036a/H0a/K601d0a/K600<000000=WIf@3I
fMT0:03IfMT300000480k>c/0`00000P0=WIf@0300000036a/H0a/K600`0a/K61@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo00<0S8b<0000002OWil03@2OWil00`000?l0WinO
09nOW`0<09nOW`030000002c/k<0/k>c01X0/k>c00<000000<K6aP36a/H07@36a/H00`000000fMWI
0=WIf@0V0=WIf@<00000B03/k>`2000001l0fMWI00<000000<K6aP36a/H02`36a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P3oool00`000000WinO09nOW`0=09nOW`030000o`2O
Wil0WinO00/0WinO00<000000;>c/`2c/k<06P2c/k<00`000000a/K60<K6aP0M0<K6aP030000003I
fMT0fMWI02D0fMWI0P00001=0>c/k08000007@3IfMT00`000000a/K60<K6aP0;0<K6aPD0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000002OWil0WinO00d0WinO00<0003o
09nOW`2OWil02P2OWil00`000000/k>c0;>c/`0J0;>c/`0300000036a/H0a/K601`0a/K60P00000U
0=WIf@<00000D@3/k>`2000001`0fMWI0P00000;0<K6aPD0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`020?oooa00WinO00<0003o09nOW`2OWil02@2OWil00`000000/k>c0;>c/`0J0;>c
/`0300000036a/H0a/K601`0a/K600<000000=WIf@3IfMT08`3IfMT2000005H0k>c/0P00000L0=WI
f@0300000036a/H0a/K600P0a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo3`2OWil00`000?l0WinO09nOW`0:09nOW`030000002c/k<0/k>c01X0/k>c00<000000<K6aP36
a/H07036a/H00`000000fMWI0=WIf@0R0=WIf@030000003/k>`0k>c/05P0k>c/0P0000090=WIf@80
o`003`3IfMT00`000000a/K60<K6aP080<K6aPD0oooo0@0000010?ooo`005@3oool2000000<0oooo
3`2OWil00`000?l0WinO09nOW`0:09nOW`030000002c/k<0/k>c01T0/k>c00<000000<K6aP36a/H0
7036a/H00`000000fMWI0=WIf@0Q0=WIf@800000G03/k>`00`000000fMWI0=WIf@050=WIf@H0o`00
3P3IfMT00`000000a/K60<K6aP070<K6aP@0oooo0P0000010?ooo`005@3oool00`000000oooo0?oo
o`020?ooo`l0WinO00<0003o09nOW`2OWil02@2OWil00`000000/k>c0;>c/`0I0;>c/`0300000036
a/H0a/K601/0a/K60P00000R0=WIf@800000G`3/k>`2000000D0fMWI0P3o0003003o00030?l0003I
fMT0fMWI00`0fMWI00<000000<K6aP36a/H01`36a/H50?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool00P3oool>09nOW`030000o`2OWil0WinO00X0WinO00<000000;>c/`2c/k<06@2c/k<0
0`000000a/K60<K6aP0J0<K6aP030000003IfMT0fMWI0240fMWI00<000000>c/k03/k>`0H@3/k>`0
10000000fMWI0=WIf@3IfMT20?l000D00?l000<0o`000=WIf@3IfMT0303IfMT00`000000a/K60<K6
aP060<K6aPD0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h0WinO00<0003o
09nOW`2OWil02@2OWil00`000000/k>c0;>c/`0I0;>c/`0300000036a/H0a/K601/0a/K600<00000
0=WIf@3IfMT0803IfMT00`000000k>c/0>c/k01S0>c/k080000000<0fMWI0?l0003o00001@00o`00
0`3o0000fMWI0=WIf@0<0=WIf@0300000036a/H0a/K600H0a/K61@3oool100000040oooo000E0?oo
o`030000003oool0oooo0080oooo3P2OWil00`000?l0WinO09nOW`0909nOW`030000002c/k<0/k>c
01P0/k>c00<000000<K6aP36a/H06P36a/H200000240fMWI0P00001X0>c/k0030000003IfMT0o`00
00D00?l0403IfMT2000000H0a/K61@3oool100000040oooo000E0?ooo`030000003oool0oooo0080
oooo3P2OWil00`000?l0WinO09nOW`0809nOW`030000002c/k<0/k>c01T0/k>c00<000000<K6aP36
a/H06P36a/H00`000000fMWI0=WIf@0O0=WIf@030000003/k>`0k>c/06T0k>c/00<000000?l0003o
00000`00o`000`3o0000fMWI0=WIf@0?0=WIf@0300000036a/H0a/K600@0a/K61@3oool100000040
oooo000E0?ooo`030000003oool0oooo0080oooo3@2OWil00`000?l0WinO09nOW`0909nOW`030000
002c/k<0/k>c01P0/k>c00<000000<K6aP36a/H06P36a/H00`000000fMWI0=WIf@0N0=WIf@800000
K03/k>`00`000000fMWI0=WIf@020?l001<0fMWI00<000000<K6aP36a/H01036a/H50?ooo`400000
0@3oool001D0oooo00<000000?ooo`3oool00P