BrowserCategory["Built-in Functions", None, 
  {
    BrowserCategory["Numerical Computation", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_NumericalComputation", IndexTag -> "Numerical Computation (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["Numerical Evaluation", None, 
          {
            Item["N", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Equation Solving", None, 
          {
            Item["Solve", "RefGuide.nb"],
            Item["NSolve", "RefGuide.nb"],
            Item["NDSolve", "RefGuide.nb", MainEntry -> True],
            Item["FindRoot", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Sums and Products", None, 
          {
            Item["Sum", "RefGuide.nb"],
            Item["Product", "RefGuide.nb"],
            Item[Delimiter],
            Item["NSum", "RefGuide.nb"],
            Item["NProduct", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Integration", None, 
          {
            Item["Integrate", "RefGuide.nb"],
            Item["NIntegrate", "RefGuide.nb"],
            Item["NDSolve", "RefGuide.nb"],
            Item[Delimiter],
            Item["InterpolatingFunction", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Optimization", None, 
          {
            Item["NMaximize", "RefGuide.nb"],
            Item["NMinimize", "RefGuide.nb"],
            Item["FindMaximum", "RefGuide.nb"],
            Item["FindMinimum", "RefGuide.nb"],
            Item["FindFit", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinearProgramming", "RefGuide.nb", MainEntry -> True],
            Item["LatticeReduce", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Data Manipulation", None, 
          {
            Item["Mean", "RefGuide.nb"],
            Item["Variance", "RefGuide.nb"],
            Item["StandardDeviation", "RefGuide.nb"],
            Item["Median", "RefGuide.nb"],
            Item["Quantile", "RefGuide.nb"],
            Item[Delimiter],
            Item["Fit", "RefGuide.nb"],
            Item["FindFit", "RefGuide.nb", MainEntry -> True],
            Item["Interpolation", "RefGuide.nb"],
            Item["ListInterpolation", "RefGuide.nb"],
            Item["FunctionInterpolation", "RefGuide.nb"],
            Item[Delimiter],
            Item["Fourier", "RefGuide.nb"],
            Item["InverseFourier", "RefGuide.nb"],
            Item["ListConvolve", "RefGuide.nb"],
            Item["ListCorrelate", "RefGuide.nb"],
            Item["CellularAutomaton", "RefGuide.nb"],
            Item[Delimiter],
            Item["Total", "RefGuide.nb"],
            Item["Min", "RefGuide.nb"],
            Item["Max", "RefGuide.nb"],
            Item["Select", "RefGuide.nb"],
            Item["Take", "RefGuide.nb"],
            Item["Count", "RefGuide.nb"],
            Item["Sort", "RefGuide.nb"],
            Item[Delimiter],
            Item["Union", "RefGuide.nb"],
            Item["Intersection", "RefGuide.nb"],
            Item["Complement", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Matrix Operations", None, 
          {
            Item["Dot (.)", "RefGuide.nb", IndexTag -> {"Dot", "."}],
            Item["Inverse", "RefGuide.nb"],
            Item["Transpose", "RefGuide.nb"],
            Item["ConjugateTranspose", "RefGuide.nb"],
            Item["Det", "RefGuide.nb"],
            Item["Tr", "RefGuide.nb"],
            Item["Eigenvalues", "RefGuide.nb"],
            Item["Eigenvectors", "RefGuide.nb"],
            Item["Eigensystem", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinearSolve", "RefGuide.nb"],
            Item["NullSpace", "RefGuide.nb"],
            Item["MatrixRank", "RefGuide.nb"],
            Item["RowReduce", "RefGuide.nb"],
            Item["Minors", "RefGuide.nb"],
            Item["LinearSolveFunction", "RefGuide.nb"],
            Item[Delimiter],
            Item["MatrixPower", "RefGuide.nb"],
            Item["MatrixExp", "RefGuide.nb"],
            Item["Outer", "RefGuide.nb"],
            Item[Delimiter],
            Item["Norm", "RefGuide.nb"],
            Item["SingularValueList", "RefGuide.nb"],
            Item["SingularValueDecomposition", "RefGuide.nb"],
            Item["PseudoInverse", "RefGuide.nb"],
            Item["QRDecomposition", "RefGuide.nb"],
            Item["LUDecomposition", "RefGuide.nb"],
            Item["CholeskyDecomposition", "RefGuide.nb"],
            Item["SchurDecomposition", "RefGuide.nb"],
            Item["JordanDecomposition", "RefGuide.nb"],
            Item["HessenbergDecomposition", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinearProgramming", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Complex Numbers", None, 
          {
            Item["I", "RefGuide.nb", MainEntry -> True],
            Item["Complex", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Re", "RefGuide.nb", MainEntry -> True],
            Item["Im", "RefGuide.nb", MainEntry -> True],
            Item["Abs", "RefGuide.nb", MainEntry -> True],
            Item["Arg", "RefGuide.nb", MainEntry -> True],
            Item["Conjugate", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Number Representation", None, 
          {
            Item["Integer", "RefGuide.nb", MainEntry -> True],
            Item["Rational", "RefGuide.nb"],
            Item["Real", "RefGuide.nb", MainEntry -> True],
            Item["Complex", "RefGuide.nb"],
            Item["Root", "RefGuide.nb"],
            Item[Delimiter],
            Item["IntegerDigits", "RefGuide.nb", MainEntry -> True],
            Item["RealDigits", "RefGuide.nb"],
            Item["FromDigits", "RefGuide.nb"],
            Item["IntegerExponent", "RefGuide.nb"],
            Item["MantissaExponent", "RefGuide.nb"],
            Item[Delimiter],
            Item["Rationalize", "RefGuide.nb"],
            Item["IntegerPart", "RefGuide.nb", MainEntry -> True],
            Item["Chop", "RefGuide.nb"],
            Item[Delimiter],
            Item["Numerator", "RefGuide.nb"],
            Item["Denominator", "RefGuide.nb"],
            Item[Delimiter],
            Item["ContinuedFraction", "RefGuide.nb", MainEntry -> True],
            Item["FromContinuedFraction", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["BitAnd", "RefGuide.nb", MainEntry -> True],
            Item["BitOr", "RefGuide.nb", MainEntry -> True],
            Item["BitXor", "RefGuide.nb", MainEntry -> True],
            Item["BitNot", "RefGuide.nb", MainEntry -> True],
            Item["DigitCount", "RefGuide.nb"],
            Item[Delimiter],
            Item["Infinity", "RefGuide.nb", MainEntry -> True],
            Item["Indeterminate", "RefGuide.nb", MainEntry -> True],
            Item["ComplexInfinity", "RefGuide.nb"],
            Item["DirectedInfinity", "RefGuide.nb"],
            Item[Delimiter],
            Item["NumberMarks", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Numerical Precision", None, 
          {
            Item["N", "RefGuide.nb"],
            Item["Accuracy", "RefGuide.nb"],
            Item["Precision", "RefGuide.nb"],
            Item["SetAccuracy", "RefGuide.nb"],
            Item["SetPrecision", "RefGuide.nb"],
            Item["$MaxPrecision", "RefGuide.nb", MainEntry -> True, MainEntry -> True],
            Item["$MinPrecision", "RefGuide.nb", MainEntry -> True, MainEntry -> True],
            Item["$MaxExtraPrecision", "RefGuide.nb", MainEntry -> True, MainEntry -> True],
            Item[Delimiter],
            Item["Interval", "RefGuide.nb"],
            Item["IntervalMemberQ", "RefGuide.nb"],
            Item["IntervalUnion", "RefGuide.nb"],
            Item["IntervalIntersection", "RefGuide.nb"],
            Item[Delimiter],
            Item["MachineNumberQ", "RefGuide.nb", MainEntry -> True],
            Item["MachinePrecision", "RefGuide.nb"],
            Item["$MachinePrecision", "RefGuide.nb", MainEntry -> True],
            Item["$MachineEpsilon", "RefGuide.nb", MainEntry -> True],
            Item["$MaxMachineNumber", "RefGuide.nb", MainEntry -> True],
            Item["$MinMachineNumber", "RefGuide.nb", MainEntry -> True],
            Item["$MaxNumber", "RefGuide.nb", MainEntry -> True, MainEntry -> True],
            Item["$MinNumber", "RefGuide.nb", MainEntry -> True, MainEntry -> True]
          }
        ],
        BrowserCategory["Options", None, 
          {
            Item["AccuracyGoal", "RefGuide.nb"],
            Item["PrecisionGoal", "RefGuide.nb"],
            Item["WorkingPrecision", "RefGuide.nb"],
            Item[Delimiter],
            Item["StepMonitor", "RefGuide.nb"],
            Item["EvaluationMonitor", "RefGuide.nb"],
            Item[Delimiter],
            Item["Compiled", "RefGuide.nb", MainEntry -> True]
          }
        ]
      }
    ],
    BrowserCategory["Algebraic Computation", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_AlgebraicComputation", IndexTag -> "Algebraic Computation (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["Basic Algebra", None, 
          {
            Item["Expand", "RefGuide.nb"],
            Item["Factor", "RefGuide.nb", MainEntry -> True],
            Item["Simplify", "RefGuide.nb", MainEntry -> True],
            Item["ReplaceAll (/.)", "RefGuide.nb", IndexTag -> {"ReplaceAll", "/."}]
          }
        ],
        BrowserCategory["Formula Manipulation", None, 
          {
            Item["Simplify", "RefGuide.nb"],
            Item["FullSimplify", "RefGuide.nb"],
            Item[Delimiter],
            Item["Refine", "RefGuide.nb"],
            Item["PowerExpand", "RefGuide.nb"],
            Item["ComplexExpand", "RefGuide.nb"],
            Item["FunctionExpand", "RefGuide.nb"],
            Item["PiecewiseExpand", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Element", "RefGuide.nb"],
            Item["Integers", "RefGuide.nb"],
            Item["Reals", "RefGuide.nb"],
            Item["Complexes", "RefGuide.nb"],
            Item["Algebraics", "RefGuide.nb"],
            Item["Rationals", "RefGuide.nb"],
            Item["Primes", "RefGuide.nb"],
            Item["Booleans", "RefGuide.nb"],
            Item[Delimiter],
            Item["Assuming", "RefGuide.nb"],
            Item["ForAll", "RefGuide.nb"],
            Item["Exists", "RefGuide.nb"],
            Item[Delimiter],
            Item["Collect", "RefGuide.nb"],
            Item["Together", "RefGuide.nb"],
            Item["Apart", "RefGuide.nb"],
            Item["Cancel", "RefGuide.nb"],
            Item["ExpandAll", "RefGuide.nb"],
            Item["FactorTerms", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Coefficient", "RefGuide.nb"],
            Item["Exponent", "RefGuide.nb"],
            Item["Numerator", "RefGuide.nb", MainEntry -> True],
            Item["Denominator", "RefGuide.nb", MainEntry -> True],
            Item["Part", "RefGuide.nb"],
            Item[Delimiter],
            Item["ExpandNumerator", "RefGuide.nb"],
            Item["ExpandDenominator", "RefGuide.nb"],
            Item[Delimiter],
            Item["TrigExpand", "RefGuide.nb"],
            Item["TrigFactor", "RefGuide.nb"],
            Item["TrigFactorList", "RefGuide.nb"],
            Item["TrigReduce", "RefGuide.nb"],
            Item["TrigToExp", "RefGuide.nb"],
            Item["ExpToTrig", "RefGuide.nb"],
            Item[Delimiter],
            Item["RootReduce", "RefGuide.nb", MainEntry -> True],
            Item["ToRadicals", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["$Assumptions", "RefGuide.nb"],
            Item["ExcludedForms", "RefGuide.nb"],
            Item["ComplexityFunction", "RefGuide.nb"],
            Item["TimeConstraint", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Equation Solving", None, 
          {
            Item["Solve", "RefGuide.nb", MainEntry -> True],
            Item["DSolve", "RefGuide.nb", MainEntry -> True],
            Item["RSolve", "RefGuide.nb", MainEntry -> True],
            Item["Equal", "RefGuide.nb"],
            Item["ReplaceAll (/.)", "RefGuide.nb", IndexTag -> {"ReplaceAll", "/."}],
            Item[Delimiter],
            Item["Reduce", "RefGuide.nb"],
            Item["Resolve", "RefGuide.nb"],
            Item["FindInstance", "RefGuide.nb"],
            Item["Eliminate", "RefGuide.nb"],
            Item["SolveAlways", "RefGuide.nb"],
            Item["LogicalExpand", "RefGuide.nb"],
            Item[Delimiter],
            Item["InverseFunction", "RefGuide.nb"],
            Item["Root", "RefGuide.nb"],
            Item[Delimiter],
            Item["GeneratedParameters", "RefGuide.nb"],
            Item["InverseFunctions", "RefGuide.nb"],
            Item["Roots", "RefGuide.nb"],
            Item["ToRules", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Calculus", None, 
          {
            Item["D", "RefGuide.nb"],
            Item["Dt", "RefGuide.nb"],
            Item["Integrate", "RefGuide.nb", MainEntry -> True],
            Item["DSolve", "RefGuide.nb"],
            Item[Delimiter],
            Item["Limit", "RefGuide.nb"],
            Item["Residue", "RefGuide.nb"],
            Item["Series", "RefGuide.nb"],
            Item["Normal", "RefGuide.nb"],
            Item["SeriesCoefficient", "RefGuide.nb"],
            Item[Delimiter],
            Item["Maximize", "RefGuide.nb"],
            Item["Minimize", "RefGuide.nb"],
            Item[Delimiter],
            Item["Derivative (')", "RefGuide.nb", IndexTag -> {"Derivative", "'"}],
            Item["InverseSeries", "RefGuide.nb"],
            Item["ComposeSeries", "RefGuide.nb"],
            Item["SeriesData", "RefGuide.nb"],
            Item["O", "RefGuide.nb"],
            Item[Delimiter],
            Item["LaplaceTransform", "RefGuide.nb"],
            Item["FourierTransform", "RefGuide.nb"],
            Item["FourierSinTransform", "RefGuide.nb"],
            Item["FourierCosTransform", "RefGuide.nb"],
            Item["ZTransform", "RefGuide.nb"],
            Item[Delimiter],
            Item["InverseLaplaceTransform", "RefGuide.nb"],
            Item["InverseFourierTransform", "RefGuide.nb"],
            Item["InverseFourierSinTransform", "RefGuide.nb"],
            Item["InverseFourierCosTransform", "RefGuide.nb"],
            Item["InverseZTransform", "RefGuide.nb"],
            Item[Delimiter],
            Item["PrincipalValue", "RefGuide.nb"],
            Item["Assumptions", "RefGuide.nb"],
            Item["GenerateConditions", "RefGuide.nb"],
            Item[Delimiter],
            Item["Constants", "RefGuide.nb"],
            Item["NonConstants", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Polynomial Functions", None, 
          {
            Item["PolynomialQ", "RefGuide.nb", MainEntry -> True],
            Item["Variables", "RefGuide.nb"],
            Item["CoefficientList", "RefGuide.nb", MainEntry -> True],
            Item["CoefficientArrays", "RefGuide.nb"],
            Item[Delimiter],
            Item["PolynomialMod", "RefGuide.nb"],
            Item["PolynomialQuotient", "RefGuide.nb"],
            Item["PolynomialRemainder", "RefGuide.nb"],
            Item["PolynomialGCD", "RefGuide.nb"],
            Item["PolynomialLCM", "RefGuide.nb"],
            Item["PolynomialReduce", "RefGuide.nb"],
            Item["Resultant", "RefGuide.nb"],
            Item["Subresultants", "RefGuide.nb"],
            Item[Delimiter],
            Item["Factor", "RefGuide.nb"],
            Item["FactorSquareFree", "RefGuide.nb"],
            Item["FactorTerms", "RefGuide.nb"],
            Item["FactorList", "RefGuide.nb"],
            Item["FactorSquareFreeList", "RefGuide.nb"],
            Item["FactorTermsList", "RefGuide.nb"],
            Item[Delimiter],
            Item["Cyclotomic", "RefGuide.nb"],
            Item[Delimiter],
            Item["Decompose", "RefGuide.nb"],
            Item["InterpolatingPolynomial", "RefGuide.nb"],
            Item[Delimiter],
            Item["GroebnerBasis", "RefGuide.nb"],
            Item["CylindricalDecomposition", "RefGuide.nb"],
            Item[Delimiter],
            Item["Modulus", "RefGuide.nb", MainEntry -> True],
            Item["GaussianIntegers", "RefGuide.nb"],
            Item["Extension", "RefGuide.nb"],
            Item[Delimiter],
            Item["Root", "RefGuide.nb", MainEntry -> True],
            Item["RootSum", "RefGuide.nb"],
            Item["RootReduce", "RefGuide.nb"],
            Item["ToRadicals", "RefGuide.nb"]
          }
        ]
      }
    ],
    BrowserCategory["Mathematical Functions", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_MathematicalFunctions", IndexTag -> "Mathematical Functions (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["Basic Arithmetic", None, 
          {
            Item["Plus (+)", "RefGuide.nb", IndexTag -> {"Plus", "+"}],
            Item["Subtract (-)", "RefGuide.nb", IndexTag -> {"Subtract", "-"}],
            Item["Minus (-)", "RefGuide.nb", IndexTag -> {"Minus", "-"}],
            Item["Times ( )", "RefGuide.nb", IndexTag -> {"Times", "*"}],
            Item["Divide (/)", "RefGuide.nb", IndexTag -> {"Divide", "/"}],
            Item["Power (^)", "RefGuide.nb", IndexTag -> {"Power", "^"}, MainEntry -> True],
            Item["NonCommutativeMultiply (**)", "RefGuide.nb", IndexTag -> {"NonCommutativeMultiply", "**"}]
          }
        ],
        BrowserCategory["Mathematical Constants", None, 
          {
            Item["Pi", "RefGuide.nb"],
            Item["E", "RefGuide.nb"],
            Item["Degree", "RefGuide.nb"],
            Item["GoldenRatio", "RefGuide.nb"],
            Item["EulerGamma", "RefGuide.nb"],
            Item["Catalan", "RefGuide.nb"],
            Item["Khinchin", "RefGuide.nb", MainEntry -> True],
            Item["Glaisher", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["I", "RefGuide.nb"],
            Item["Infinity", "RefGuide.nb"],
            Item["Indeterminate", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Numerical Functions", None, 
          {
            Item["Abs", "RefGuide.nb"],
            Item["Sign", "RefGuide.nb"],
            Item[Delimiter],
            Item["Round", "RefGuide.nb", MainEntry -> True],
            Item["IntegerPart", "RefGuide.nb"],
            Item["FractionalPart", "RefGuide.nb"],
            Item["Floor", "RefGuide.nb"],
            Item["Ceiling", "RefGuide.nb"],
            Item["Chop", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Max", "RefGuide.nb", MainEntry -> True],
            Item["Min", "RefGuide.nb", MainEntry -> True],
            Item["Clip", "RefGuide.nb"],
            Item["Rescale", "RefGuide.nb"],
            Item["UnitStep", "RefGuide.nb"],
            Item[Delimiter],
            Item["Boole", "RefGuide.nb"],
            Item["Piecewise", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Re", "RefGuide.nb"],
            Item["Im", "RefGuide.nb"],
            Item["Conjugate", "RefGuide.nb"],
            Item["Arg", "RefGuide.nb"],
            Item[Delimiter],
            Item["Mod", "RefGuide.nb"],
            Item["Quotient", "RefGuide.nb"],
            Item["IntegerDigits", "RefGuide.nb"],
            Item["IntegerExponent", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Random Numbers", None, 
          {
            Item["Random", "RefGuide.nb"],
            Item["SeedRandom", "RefGuide.nb"],
            Item["$RandomState", "RefGuide.nb", MainEntry -> True, MainEntry -> True]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Elementary Functions", None, 
          {
            Item["Log", "RefGuide.nb"],
            Item["Exp", "RefGuide.nb"],
            Item["Power (^)", "RefGuide.nb", IndexTag -> {"Power", "^"}],
            Item["Sqrt", "RefGuide.nb"],
            Item[Delimiter],
            Item["Sin", "RefGuide.nb"],
            Item["Cos", "RefGuide.nb"],
            Item["Tan", "RefGuide.nb"],
            Item["Csc", "RefGuide.nb"],
            Item["Sec", "RefGuide.nb"],
            Item["Cot", "RefGuide.nb"],
            Item[Delimiter],
            Item["ArcSin", "RefGuide.nb"],
            Item["ArcCos", "RefGuide.nb"],
            Item["ArcTan", "RefGuide.nb"],
            Item["ArcCsc", "RefGuide.nb"],
            Item["ArcSec", "RefGuide.nb"],
            Item["ArcCot", "RefGuide.nb"],
            Item[Delimiter],
            Item["Sinh", "RefGuide.nb"],
            Item["Cosh", "RefGuide.nb"],
            Item["Tanh", "RefGuide.nb"],
            Item["Csch", "RefGuide.nb"],
            Item["Sech", "RefGuide.nb"],
            Item["Coth", "RefGuide.nb"],
            Item[Delimiter],
            Item["ArcSinh", "RefGuide.nb"],
            Item["ArcCosh", "RefGuide.nb"],
            Item["ArcTanh", "RefGuide.nb"],
            Item["ArcCsch", "RefGuide.nb"],
            Item["ArcSech", "RefGuide.nb"],
            Item["ArcCoth", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Factorial Related", None, 
          {
            Item["Factorial (!)", "RefGuide.nb", IndexTag -> {"Factorial", "!"}],
            Item["Factorial2 (!!)", "RefGuide.nb", IndexTag -> {"Factorial2", "!!"}],
            Item["Binomial", "RefGuide.nb"],
            Item["Multinomial", "RefGuide.nb"],
            Item["Pochhammer", "RefGuide.nb"],
            Item[Delimiter],
            Item["Gamma", "RefGuide.nb", MainEntry -> True],
            Item["Beta", "RefGuide.nb", MainEntry -> True],
            Item["GammaRegularized", "RefGuide.nb", MainEntry -> True],
            Item["BetaRegularized", "RefGuide.nb", MainEntry -> True],
            Item["InverseGammaRegularized", "RefGuide.nb", MainEntry -> True],
            Item["InverseBetaRegularized", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["LogGamma", "RefGuide.nb"],
            Item["PolyGamma", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Combinatorial", None, 
          {
            Item["Fibonacci", "RefGuide.nb"],
            Item["HarmonicNumber", "RefGuide.nb"],
            Item["BernoulliB", "RefGuide.nb"],
            Item["EulerE", "RefGuide.nb"],
            Item["StirlingS1", "RefGuide.nb"],
            Item["StirlingS2", "RefGuide.nb"],
            Item["PartitionsP", "RefGuide.nb"],
            Item["PartitionsQ", "RefGuide.nb"],
            Item["Signature", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["ClebschGordan", "RefGuide.nb"],
            Item["ThreeJSymbol", "RefGuide.nb"],
            Item["SixJSymbol", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Number Theory", None, 
          {
            Item["FactorInteger", "RefGuide.nb"],
            Item["Prime", "RefGuide.nb"],
            Item["PrimeQ", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Mod", "RefGuide.nb", MainEntry -> True],
            Item["PowerMod", "RefGuide.nb"],
            Item["Quotient", "RefGuide.nb", MainEntry -> True],
            Item["GCD", "RefGuide.nb"],
            Item["LCM", "RefGuide.nb"],
            Item["IntegerDigits", "RefGuide.nb"],
            Item["IntegerExponent", "RefGuide.nb"],
            Item["DigitCount", "RefGuide.nb", MainEntry -> True],
            Item["ContinuedFraction", "RefGuide.nb"],
            Item[Delimiter],
            Item["PrimePi", "RefGuide.nb"],
            Item["Divisors", "RefGuide.nb"],
            Item["EulerPhi", "RefGuide.nb"],
            Item["MoebiusMu", "RefGuide.nb"],
            Item["DivisorSigma", "RefGuide.nb"],
            Item["JacobiSymbol", "RefGuide.nb"],
            Item["MultiplicativeOrder", "RefGuide.nb"],
            Item["CarmichaelLambda", "RefGuide.nb"],
            Item["ExtendedGCD", "RefGuide.nb"],
            Item["ArithmeticGeometricMean", "RefGuide.nb"],
            Item["LatticeReduce", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Zeta Related", None, 
          {
            Item["Zeta", "RefGuide.nb"],
            Item["PolyLog", "RefGuide.nb"],
            Item["LerchPhi", "RefGuide.nb"],
            Item[Delimiter],
            Item["RiemannSiegelTheta", "RefGuide.nb"],
            Item["RiemannSiegelZ", "RefGuide.nb"],
            Item["StieltjesGamma", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Hypergeometric Related", None, 
          {
            Item["AiryAi", "RefGuide.nb"],
            Item["AiryAiPrime", "RefGuide.nb"],
            Item["AiryBi", "RefGuide.nb"],
            Item["AiryBiPrime", "RefGuide.nb"],
            Item["BesselJ", "RefGuide.nb"],
            Item["BesselK", "RefGuide.nb"],
            Item["BesselI", "RefGuide.nb"],
            Item["BesselY", "RefGuide.nb"],
            Item["StruveH", "RefGuide.nb"],
            Item["StruveL", "RefGuide.nb"],
            Item["Hypergeometric0F1", "RefGuide.nb"],
            Item["Hypergeometric0F1Regularized", "RefGuide.nb"],
            Item[Delimiter],
            Item["Erf", "RefGuide.nb"],
            Item["Erfc", "RefGuide.nb"],
            Item["Erfi", "RefGuide.nb"],
            Item["LaguerreL", "RefGuide.nb"],
            Item["Hypergeometric1F1", "RefGuide.nb"],
            Item["Hypergeometric1F1Regularized", "RefGuide.nb"],
            Item[Delimiter],
            Item["Gamma", "RefGuide.nb"],
            Item["GammaRegularized", "RefGuide.nb"],
            Item["ExpIntegralE", "RefGuide.nb"],
            Item["ExpIntegralEi", "RefGuide.nb"],
            Item["LogIntegral", "RefGuide.nb"],
            Item["HermiteH", "RefGuide.nb"],
            Item["HypergeometricU", "RefGuide.nb"],
            Item[Delimiter],
            Item["EllipticK", "RefGuide.nb"],
            Item["EllipticE", "RefGuide.nb"],
            Item["Beta", "RefGuide.nb"],
            Item["BetaRegularized", "RefGuide.nb"],
            Item["ChebyshevT", "RefGuide.nb"],
            Item["ChebyshevU", "RefGuide.nb"],
            Item["GegenbauerC", "RefGuide.nb"],
            Item["JacobiP", "RefGuide.nb"],
            Item["LegendreP", "RefGuide.nb"],
            Item["LegendreQ", "RefGuide.nb"],
            Item["SphericalHarmonicY", "RefGuide.nb"],
            Item["Hypergeometric2F1", "RefGuide.nb"],
            Item["Hypergeometric2F1Regularized", "RefGuide.nb"],
            Item[Delimiter],
            Item["FresnelS", "RefGuide.nb"],
            Item["FresnelC", "RefGuide.nb"],
            Item["SinIntegral", "RefGuide.nb"],
            Item["CosIntegral", "RefGuide.nb"],
            Item["SinhIntegral", "RefGuide.nb"],
            Item["CoshIntegral", "RefGuide.nb"],
            Item[Delimiter],
            Item["HypergeometricPFQ", "RefGuide.nb"],
            Item["HypergeometricPFQRegularized", "RefGuide.nb"],
            Item["MeijerG", "RefGuide.nb"],
            Item["AppellF1", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Orthogonal Polynomials", None, 
          {
            Item["LegendreP", "RefGuide.nb", MainEntry -> True],
            Item["SphericalHarmonicY", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["GegenbauerC", "RefGuide.nb", MainEntry -> True],
            Item["ChebyshevT", "RefGuide.nb", MainEntry -> True],
            Item["ChebyshevU", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["HermiteH", "RefGuide.nb", MainEntry -> True],
            Item["LaguerreL", "RefGuide.nb", MainEntry -> True],
            Item["JacobiP", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Inverse Functions", None, 
          {
            Item["InverseErf", "RefGuide.nb"],
            Item["InverseErfc", "RefGuide.nb"],
            Item["InverseGammaRegularized", "RefGuide.nb"],
            Item["InverseBetaRegularized", "RefGuide.nb"],
            Item[Delimiter],
            Item["ProductLog", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Elliptic Integrals", None, 
          {
            Item["EllipticK", "RefGuide.nb", MainEntry -> True],
            Item["EllipticF", "RefGuide.nb"],
            Item["EllipticE", "RefGuide.nb", MainEntry -> True],
            Item["EllipticPi", "RefGuide.nb"],
            Item["JacobiZeta", "RefGuide.nb"],
            Item["EllipticNomeQ", "RefGuide.nb"],
            Item["EllipticLog", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Elliptic Functions", None, 
          {
            Item["InverseEllipticNomeQ", "RefGuide.nb"],
            Item["JacobiAmplitude", "RefGuide.nb"],
            Item["JacobiSN", "RefGuide.nb"],
            Item[Delimiter],
            Item["InverseJacobiSN", "RefGuide.nb"],
            Item[Delimiter],
            Item["WeierstrassP", "RefGuide.nb"],
            Item["WeierstrassPPrime", "RefGuide.nb"],
            Item["InverseWeierstrassP", "RefGuide.nb"],
            Item["WeierstrassInvariants", "RefGuide.nb"],
            Item["WeierstrassHalfPeriods", "RefGuide.nb"],
            Item["WeierstrassSigma", "RefGuide.nb"],
            Item["WeierstrassZeta", "RefGuide.nb"],
            Item[Delimiter],
            Item["EllipticTheta", "RefGuide.nb"],
            Item["EllipticThetaPrime", "RefGuide.nb"],
            Item[Delimiter],
            Item["DedekindEta", "RefGuide.nb"],
            Item["KleinInvariantJ", "RefGuide.nb"],
            Item["ModularLambda", "RefGuide.nb"],
            Item[Delimiter],
            Item["EllipticExp", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Mathieu Functions", None, 
          {
            Item["MathieuC", "RefGuide.nb"],
            Item["MathieuS", "RefGuide.nb"],
            Item["MathieuCPrime", "RefGuide.nb"],
            Item["MathieuSPrime", "RefGuide.nb"],
            Item["MathieuCharacteristicA", "RefGuide.nb"],
            Item["MathieuCharacteristicB", "RefGuide.nb"],
            Item["MathieuCharacteristicExponent", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Generalized and Related Functions", None, 
          {
            Item["DiracDelta", "RefGuide.nb", MainEntry -> True],
            Item["DiscreteDelta", "RefGuide.nb", MainEntry -> True],
            Item["KroneckerDelta", "RefGuide.nb", MainEntry -> True],
            Item["UnitStep", "RefGuide.nb", MainEntry -> True]
          }
        ]
      }
    ],
    BrowserCategory["Lists and Matrices", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_ListsAndMatrices", IndexTag -> "Lists and Matrices (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["List Construction", None, 
          {
            Item["List", "RefGuide.nb"],
            Item["Table", "RefGuide.nb"],
            Item["Range", "RefGuide.nb"],
            Item["Array", "RefGuide.nb", MainEntry -> True],
            Item["SparseArray", "RefGuide.nb"],
            Item[Delimiter],
            Item["Reap", "RefGuide.nb"],
            Item["Sow", "RefGuide.nb"],
            Item[Delimiter],
            Item["IdentityMatrix", "RefGuide.nb"],
            Item["DiagonalMatrix", "RefGuide.nb"],
            Item[Delimiter],
            Item["CoefficientList", "RefGuide.nb"],
            Item["CoefficientArrays", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Element Extraction", None, 
          {
            Item["Part", "RefGuide.nb", MainEntry -> True],
            Item["First", "RefGuide.nb"],
            Item["Last", "RefGuide.nb"],
            Item["Head", "RefGuide.nb"],
            Item["Extract", "RefGuide.nb"],
            Item[Delimiter],
            Item["Take", "RefGuide.nb", MainEntry -> True],
            Item["Drop", "RefGuide.nb", MainEntry -> True],
            Item["Rest", "RefGuide.nb"],
            Item["Most", "RefGuide.nb"],
            Item[Delimiter],
            Item["Select", "RefGuide.nb", MainEntry -> True],
            Item["Cases", "RefGuide.nb", MainEntry -> True],
            Item["Pick", "RefGuide.nb"],
            Item[Delimiter],
            Item["ArrayRules", "RefGuide.nb"]
          }
        ],
        BrowserCategory["List Testing", None, 
          {
            Item["Length", "RefGuide.nb"],
            Item["Dimensions", "RefGuide.nb"],
            Item["VectorQ", "RefGuide.nb", MainEntry -> True],
            Item["MatrixQ", "RefGuide.nb", MainEntry -> True],
            Item["ArrayQ", "RefGuide.nb"],
            Item["ArrayDepth", "RefGuide.nb"],
            Item["Depth", "RefGuide.nb"],
            Item[Delimiter],
            Item["Count", "RefGuide.nb", MainEntry -> True],
            Item["MemberQ", "RefGuide.nb", MainEntry -> True],
            Item["FreeQ", "RefGuide.nb", MainEntry -> True],
            Item["Position", "RefGuide.nb", MainEntry -> True],
            Item["Cases", "RefGuide.nb"],
            Item["Select", "RefGuide.nb"]
          }
        ],
        BrowserCategory["List Operations", None, 
          {
            Item["Append", "RefGuide.nb"],
            Item["Prepend", "RefGuide.nb"],
            Item["Insert", "RefGuide.nb"],
            Item["Delete", "RefGuide.nb"],
            Item["DeleteCases", "RefGuide.nb", MainEntry -> True],
            Item["ReplacePart", "RefGuide.nb"],
            Item[Delimiter],
            Item["Join", "RefGuide.nb"],
            Item["Union", "RefGuide.nb", MainEntry -> True],
            Item["Intersection", "RefGuide.nb", MainEntry -> True],
            Item["Complement", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Sort", "RefGuide.nb", MainEntry -> True],
            Item["Ordering", "RefGuide.nb", MainEntry -> True],
            Item["Reverse", "RefGuide.nb"],
            Item["RotateLeft", "RefGuide.nb"],
            Item["RotateRight", "RefGuide.nb"],
            Item["PadLeft", "RefGuide.nb"],
            Item["PadRight", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Structure Manipulation", None, 
          {
            Item["Partition", "RefGuide.nb"],
            Item["Flatten", "RefGuide.nb"],
            Item["Split", "RefGuide.nb"],
            Item["FlattenAt", "RefGuide.nb"],
            Item["Thread", "RefGuide.nb", MainEntry -> True],
            Item["Sequence", "RefGuide.nb"],
            Item[Delimiter],
            Item["Tuples", "RefGuide.nb"],
            Item["Outer", "RefGuide.nb", MainEntry -> True],
            Item["Inner", "RefGuide.nb", MainEntry -> True],
            Item["ListConvolve", "RefGuide.nb", MainEntry -> True],
            Item["ListCorrelate", "RefGuide.nb", MainEntry -> True],
            Item["Transpose", "RefGuide.nb"],
            Item["Tr", "RefGuide.nb"],
            Item["Level", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Permutations", "RefGuide.nb"],
            Item["Subsets", "RefGuide.nb"],
            Item["OrderedQ", "RefGuide.nb"],
            Item["Order", "RefGuide.nb"],
            Item["Signature", "RefGuide.nb"],
            Item[Delimiter],
            Item["CellularAutomaton", "RefGuide.nb", MainEntry -> True]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Vector Operations", None, 
          {
            Item["Dot (.)", "RefGuide.nb", IndexTag -> {"Dot", "."}],
            Item["Cross", "RefGuide.nb"],
            Item["Total", "RefGuide.nb", MainEntry -> True],
            Item["Norm", "RefGuide.nb", MainEntry -> True]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Matrix Operations", None, 
          {
            Item["Dot (.)", "RefGuide.nb", IndexTag -> {"Dot", "."}, MainEntry -> True],
            Item["Inverse", "RefGuide.nb", MainEntry -> True],
            Item["Transpose", "RefGuide.nb", MainEntry -> True],
            Item["ConjugateTranspose", "RefGuide.nb", MainEntry -> True],
            Item["Det", "RefGuide.nb", MainEntry -> True],
            Item["Tr", "RefGuide.nb", MainEntry -> True],
            Item["Eigenvalues", "RefGuide.nb", MainEntry -> True],
            Item["Eigenvectors", "RefGuide.nb", MainEntry -> True],
            Item["Eigensystem", "RefGuide.nb", MainEntry -> True],
            Item["CharacteristicPolynomial", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["LinearSolve", "RefGuide.nb", MainEntry -> True],
            Item["NullSpace", "RefGuide.nb", MainEntry -> True],
            Item["MatrixRank", "RefGuide.nb", MainEntry -> True],
            Item["RowReduce", "RefGuide.nb", MainEntry -> True],
            Item["Minors", "RefGuide.nb", MainEntry -> True],
            Item["LinearSolveFunction", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["MatrixPower", "RefGuide.nb", MainEntry -> True],
            Item["MatrixExp", "RefGuide.nb", MainEntry -> True],
            Item["Outer", "RefGuide.nb"],
            Item[Delimiter],
            Item["Norm", "RefGuide.nb"],
            Item["SingularValueList", "RefGuide.nb", MainEntry -> True],
            Item["SingularValueDecomposition", "RefGuide.nb", MainEntry -> True],
            Item["PseudoInverse", "RefGuide.nb", MainEntry -> True],
            Item["QRDecomposition", "RefGuide.nb", MainEntry -> True],
            Item["LUDecomposition", "RefGuide.nb", MainEntry -> True],
            Item["CholeskyDecomposition", "RefGuide.nb", MainEntry -> True],
            Item["SchurDecomposition", "RefGuide.nb", MainEntry -> True],
            Item["JordanDecomposition", "RefGuide.nb", MainEntry -> True],
            Item["HessenbergDecomposition", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["LinearProgramming", "RefGuide.nb"],
            Item["LatticeReduce", "RefGuide.nb"]
          }
        ]
      }
    ],
    BrowserCategory["Graphics and Sound", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_GraphicsAndSound", IndexTag -> "Graphics and Sound (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["2D Plots", None, 
          {
            Item["Plot", "RefGuide.nb"],
            Item["ListPlot", "RefGuide.nb"],
            Item["ParametricPlot", "RefGuide.nb"]
          }
        ],
        BrowserCategory["3D Plots", None, 
          {
            Item["Plot3D", "RefGuide.nb"],
            Item["ListPlot3D", "RefGuide.nb"],
            Item["ParametricPlot3D", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Contour Plots", None, 
          {
            Item["ContourPlot", "RefGuide.nb"],
            Item["ListContourPlot", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Density Plots", None, 
          {
            Item["DensityPlot", "RefGuide.nb"],
            Item["ListDensityPlot", "RefGuide.nb"],
            Item["ArrayPlot", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Sound Generation", None, 
          {
            Item["Play", "RefGuide.nb"],
            Item["ListPlay", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Combinations", None, 
          {
            Item["Show", "RefGuide.nb"],
            Item["GraphicsArray", "RefGuide.nb", MainEntry -> True],
            Item["GraphicsSpacing", "RefGuide.nb"],
            Item[Delimiter],
            Item["Epilog", "RefGuide.nb"],
            Item["Rectangle", "RefGuide.nb"],
            Item[Delimiter],
            Item["SelectionAnimate", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Basic Options", None, 
          {
            Item["PlotRange", "RefGuide.nb"],
            Item["AspectRatio", "RefGuide.nb"],
            Item["PlotLabel", "RefGuide.nb"],
            Item[Delimiter],
            Item["Axes", "RefGuide.nb"],
            Item["AxesLabel", "RefGuide.nb"],
            Item["Ticks", "RefGuide.nb"],
            Item["AxesOrigin", "RefGuide.nb"],
            Item["AxesStyle", "RefGuide.nb"],
            Item[Delimiter],
            Item["Frame", "RefGuide.nb"],
            Item["FrameLabel", "RefGuide.nb"],
            Item["FrameTicks", "RefGuide.nb", MainEntry -> True],
            Item["GridLines", "RefGuide.nb"],
            Item["FrameStyle", "RefGuide.nb"],
            Item[Delimiter],
            Item["PlotJoined", "RefGuide.nb"],
            Item["PlotStyle", "RefGuide.nb"],
            Item["PlotPoints", "RefGuide.nb"],
            Item["Compiled", "RefGuide.nb"]
          }
        ],
        BrowserCategory["3D Options", None, 
          {
            Item["ViewPoint", "RefGuide.nb"],
            Item[Delimiter],
            Item["Boxed", "RefGuide.nb"],
            Item["BoxRatios", "RefGuide.nb"],
            Item["FaceGrids", "RefGuide.nb"],
            Item["AxesEdge", "RefGuide.nb"],
            Item["BoxStyle", "RefGuide.nb"],
            Item[Delimiter],
            Item["Lighting", "RefGuide.nb"],
            Item["LightSources", "RefGuide.nb"],
            Item["AmbientLight", "RefGuide.nb"],
            Item[Delimiter],
            Item["Mesh", "RefGuide.nb"],
            Item["MeshStyle", "RefGuide.nb"],
            Item["MeshRange", "RefGuide.nb"],
            Item["ClipFill", "RefGuide.nb"],
            Item["Shading", "RefGuide.nb"],
            Item["HiddenSurface", "RefGuide.nb"],
            Item[Delimiter],
            Item["ViewCenter", "RefGuide.nb"],
            Item["ViewVertical", "RefGuide.nb"],
            Item["SphericalRegion", "RefGuide.nb"],
            Item["PolygonIntersections", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Contour Options", None, 
          {
            Item["Contours", "RefGuide.nb"],
            Item["ContourShading", "RefGuide.nb"],
            Item["ContourLines", "RefGuide.nb"],
            Item["ContourStyle", "RefGuide.nb"],
            Item[Delimiter],
            Item["FrameTicks", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Advanced Options", None, 
          {
            Item["Options", "RefGuide.nb", MainEntry -> True],
            Item["SetOptions", "RefGuide.nb"],
            Item["AbsoluteOptions", "RefGuide.nb"],
            Item["FullGraphics", "RefGuide.nb"],
            Item[Delimiter],
            Item["Prolog", "RefGuide.nb"],
            Item["Epilog", "RefGuide.nb", MainEntry -> True],
            Item["Background", "RefGuide.nb"],
            Item["DefaultColor", "RefGuide.nb"],
            Item[Delimiter],
            Item["PlotRegion", "RefGuide.nb"],
            Item["RotateLabel", "RefGuide.nb"],
            Item[Delimiter],
            Item["TextStyle", "RefGuide.nb"],
            Item["FormatType", "RefGuide.nb"],
            Item["ColorFunction", "RefGuide.nb"],
            Item["ColorFunctionScaling", "RefGuide.nb"],
            Item["DisplayFunction", "RefGuide.nb"],
            Item["RenderAll", "RefGuide.nb"],
            Item["ColorOutput", "RefGuide.nb"],
            Item[Delimiter],
            Item["MaxBend", "RefGuide.nb"],
            Item["PlotDivision", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Graphics Primitives", None, 
          {
            Item["Graphics", "RefGuide.nb"],
            Item["Graphics3D", "RefGuide.nb"],
            Item["SurfaceGraphics", "RefGuide.nb"],
            Item["ContourGraphics", "RefGuide.nb"],
            Item["DensityGraphics", "RefGuide.nb"],
            Item["GraphicsArray", "RefGuide.nb"],
            Item[Delimiter],
            Item["Point", "RefGuide.nb"],
            Item["Line", "RefGuide.nb"],
            Item["Rectangle", "RefGuide.nb", MainEntry -> True],
            Item["Cuboid", "RefGuide.nb"],
            Item["Polygon", "RefGuide.nb"],
            Item["Circle", "RefGuide.nb"],
            Item["Disk", "RefGuide.nb"],
            Item["Raster", "RefGuide.nb"],
            Item["RasterArray", "RefGuide.nb"],
            Item[Delimiter],
            Item["Text", "RefGuide.nb"],
            Item["StyleForm", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Scaled", "RefGuide.nb"],
            Item["Offset", "RefGuide.nb"],
            Item[Delimiter],
            BrowserCategory["Colors", None, 
              {
                Item["Black", "RefGuide.nb"],
                Item["Blue", "RefGuide.nb"],
                Item["Brown", "RefGuide.nb"],
                Item["Cyan", "RefGuide.nb"],
                Item["Gray", "RefGuide.nb"],
                Item["Green", "RefGuide.nb"],
                Item["Magenta", "RefGuide.nb"],
                Item["Orange", "RefGuide.nb"],
                Item["Pink", "RefGuide.nb"],
                Item["Purple", "RefGuide.nb"],
                Item["Red", "RefGuide.nb"],
                Item["White", "RefGuide.nb"],
                Item["Yellow", "RefGuide.nb"]
              }
            ],
            Item["GrayLevel", "RefGuide.nb"],
            Item["RGBColor", "RefGuide.nb"],
            Item["Hue", "RefGuide.nb"],
            Item["CMYKColor", "RefGuide.nb"],
            Item[Delimiter],
            Item["Thickness", "RefGuide.nb"],
            Item["PointSize", "RefGuide.nb"],
            Item["Dashing", "RefGuide.nb"],
            Item["AbsoluteThickness", "RefGuide.nb"],
            Item["AbsolutePointSize", "RefGuide.nb"],
            Item["AbsoluteDashing", "RefGuide.nb"],
            Item[Delimiter],
            Item["SurfaceColor", "RefGuide.nb"],
            Item["FaceForm", "RefGuide.nb"],
            Item["EdgeForm", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Sound Primitives", None, 
          {
            Item["Sound", "RefGuide.nb"],
            Item["SampledSoundList", "RefGuide.nb"],
            Item["SampledSoundFunction", "RefGuide.nb"],
            Item[Delimiter],
            Item["PlayRange", "RefGuide.nb"],
            Item["SampleRate", "RefGuide.nb"],
            Item["SampleDepth", "RefGuide.nb"],
            Item[Delimiter],
            Item["$SoundDisplayFunction", "RefGuide.nb", MainEntry -> True]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Import and Export", None, 
          {
            Item["Import", "RefGuide.nb"],
            Item["Export", "RefGuide.nb"],
            Item["ImportString", "RefGuide.nb"],
            Item["ExportString", "RefGuide.nb"],
            Item[Delimiter],
            Item["Display", "RefGuide.nb", MainEntry -> True],
            Item["DisplayString", "RefGuide.nb"],
            Item[Delimiter],
            Item["ImageSize", "RefGuide.nb", MainEntry -> True],
            Item["ImageResolution", "RefGuide.nb"],
            Item["ImageRotated", "RefGuide.nb"]
          }
        ]
      }
    ],
    Item[Delimiter],
    BrowserCategory["Programming", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_Programming", IndexTag -> "Programming (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["Assignments", None, 
          {
            Item["Set (=)", "RefGuide.nb", IndexTag -> {"Set", "="}],
            Item["SetDelayed (:=)", "RefGuide.nb", IndexTag -> {"SetDelayed", ":="}],
            Item["Unset (=.)", "RefGuide.nb", IndexTag -> {"Unset", "=."}],
            Item["Clear", "RefGuide.nb"],
            Item[Delimiter],
            Item["Increment (++)", "RefGuide.nb", IndexTag -> {"Increment", "++"}],
            Item["AddTo (+=)", "RefGuide.nb", IndexTag -> {"AddTo", "+="}],
            Item["Decrement (--)", "RefGuide.nb", IndexTag -> {"Decrement", "--"}],
            Item["SubtractFrom (-=)", "RefGuide.nb", IndexTag -> {"SubtractFrom", "-="}],
            Item["PreIncrement (++)", "RefGuide.nb", IndexTag -> {"PreIncrement", "++"}],
            Item["PreDecrement (--)", "RefGuide.nb", IndexTag -> {"PreDecrement", "--"}],
            Item["TimesBy (*=)", "RefGuide.nb", IndexTag -> {"TimesBy", "*="}],
            Item["DivideBy (/=)", "RefGuide.nb", IndexTag -> {"DivideBy", "/="}],
            Item["AppendTo", "RefGuide.nb"],
            Item["PrependTo", "RefGuide.nb"],
            Item[Delimiter],
            Item["TagSet", "RefGuide.nb"],
            Item["TagSetDelayed", "RefGuide.nb"],
            Item["TagUnset", "RefGuide.nb"],
            Item["UpSet (^=)", "RefGuide.nb", IndexTag -> {"UpSet", "^="}],
            Item["UpSetDelayed (^:=)", "RefGuide.nb", IndexTag -> {"UpSetDelayed", "^:="}],
            Item[Delimiter],
            Item["Protect", "RefGuide.nb"],
            Item["Unprotect", "RefGuide.nb"],
            Item[Delimiter],
            Item["Save", "RefGuide.nb"],
            Item["DumpSave", "RefGuide.nb", MainEntry -> True],
            Item["Definition", "RefGuide.nb"],
            Item["FullDefinition", "RefGuide.nb"],
            Item["DownValues", "RefGuide.nb"],
            Item["UpValues", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Tests", None, 
          {
            Item["Equal (==)", "RefGuide.nb", IndexTag -> {"Equal", "=="}],
            Item["Unequal (!=)", "RefGuide.nb", IndexTag -> {"Unequal", "!="}],
            Item["SameQ (===)", "RefGuide.nb", IndexTag -> {"SameQ", "==="}, MainEntry -> True],
            Item["UnsameQ (=!=)", "RefGuide.nb", IndexTag -> {"UnsameQ", "=!="}],
            Item[Delimiter],
            Item["Less (<)", "RefGuide.nb", IndexTag -> {"Less", "<"}],
            Item["Greater (>)", "RefGuide.nb", IndexTag -> {"Greater", ">"}],
            Item["LessEqual (<=)", "RefGuide.nb", IndexTag -> {"LessEqual", "<="}],
            Item["GreaterEqual (>=)", "RefGuide.nb", IndexTag -> {"GreaterEqual", ">="}],
            Item[Delimiter],
            Item["NumberQ", "RefGuide.nb"],
            Item["NumericQ", "RefGuide.nb"],
            Item["IntegerQ", "RefGuide.nb"],
            Item["EvenQ", "RefGuide.nb"],
            Item["OddQ", "RefGuide.nb"],
            Item["PrimeQ", "RefGuide.nb"],
            Item["Positive", "RefGuide.nb"],
            Item["Negative", "RefGuide.nb"],
            Item["NonPositive", "RefGuide.nb"],
            Item["NonNegative", "RefGuide.nb"],
            Item[Delimiter],
            Item["VectorQ", "RefGuide.nb"],
            Item["MatrixQ", "RefGuide.nb"],
            Item["ArrayQ", "RefGuide.nb"],
            Item["PolynomialQ", "RefGuide.nb"],
            Item[Delimiter],
            Item["MemberQ", "RefGuide.nb"],
            Item["FreeQ", "RefGuide.nb"],
            Item[Delimiter],
            Item["TrueQ", "RefGuide.nb"],
            Item["AtomQ", "RefGuide.nb"],
            Item["MatchQ", "RefGuide.nb"],
            Item["ValueQ", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Logical Operations", None, 
          {
            Item["Not (!)", "RefGuide.nb", IndexTag -> {"Not", "!"}],
            Item["And (&&)", "RefGuide.nb", IndexTag -> {"And", "&&"}],
            Item["Or (||)", "RefGuide.nb", IndexTag -> {"Or", "||"}],
            Item["Nand", "RefGuide.nb", MainEntry -> True],
            Item["Nor", "RefGuide.nb"],
            Item["Xor", "RefGuide.nb"],
            Item["Implies", "RefGuide.nb"],
            Item[Delimiter],
            Item["True", "RefGuide.nb", MainEntry -> True],
            Item["False", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["LogicalExpand", "RefGuide.nb", MainEntry -> True],
            Item["PiecewiseExpand", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Flow Control", None, 
          {
            Item["If", "RefGuide.nb"],
            Item["Which", "RefGuide.nb"],
            Item["Piecewise", "RefGuide.nb"],
            Item["Switch", "RefGuide.nb"],
            Item[Delimiter],
            Item["CompoundExpression (;)", "RefGuide.nb", IndexTag -> {"CompoundExpression", ";"}],
            Item[Delimiter],
            Item["Do", "RefGuide.nb"],
            Item["While", "RefGuide.nb"],
            Item["For", "RefGuide.nb"],
            Item[Delimiter],
            Item["Return", "RefGuide.nb"],
            Item["Throw", "RefGuide.nb"],
            Item["Catch", "RefGuide.nb"],
            Item[Delimiter],
            Item["Sow", "RefGuide.nb", MainEntry -> True],
            Item["Reap", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Break", "RefGuide.nb"],
            Item["Continue", "RefGuide.nb"],
            Item["Goto", "RefGuide.nb"],
            Item["Label", "RefGuide.nb"],
            Item[Delimiter],
            Item["Check", "RefGuide.nb", MainEntry -> True],
            Item["CheckAbort", "RefGuide.nb"],
            Item[Delimiter],
            Item["Interrupt", "RefGuide.nb"],
            Item["Abort", "RefGuide.nb"],
            Item["TimeConstrained", "RefGuide.nb"],
            Item["MemoryConstrained", "RefGuide.nb"],
            Item["AbortProtect", "RefGuide.nb"],
            Item[Delimiter],
            Item["Print", "RefGuide.nb"],
            Item["StylePrint", "RefGuide.nb", MainEntry -> True],
            Item["Input", "RefGuide.nb"],
            Item[Delimiter],
            Item["Pause", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Functional Programming", None, 
          {
            Item["Function (&)", "RefGuide.nb", IndexTag -> {"Function", "&"}],
            Item["Slot (#)", "RefGuide.nb", IndexTag -> {"Slot", "#"}],
            Item["SlotSequence (##)", "RefGuide.nb", IndexTag -> {"SlotSequence", "##"}],
            Item[Delimiter],
            Item["Map (/@)", "RefGuide.nb", IndexTag -> {"Map", "/@"}],
            Item["Apply (@@)", "RefGuide.nb", IndexTag -> {"Apply", "@@"}],
            Item["MapAll (//@)", "RefGuide.nb", IndexTag -> {"MapAll", "//@"}],
            Item["MapAt", "RefGuide.nb"],
            Item["MapIndexed", "RefGuide.nb"],
            Item["MapThread", "RefGuide.nb"],
            Item["Scan", "RefGuide.nb"],
            Item[Delimiter],
            Item["Nest", "RefGuide.nb"],
            Item["NestList", "RefGuide.nb"],
            Item["FixedPoint", "RefGuide.nb"],
            Item["FixedPointList", "RefGuide.nb"],
            Item["NestWhile", "RefGuide.nb"],
            Item["NestWhileList", "RefGuide.nb"],
            Item["Fold", "RefGuide.nb"],
            Item["FoldList", "RefGuide.nb"],
            Item["ComposeList", "RefGuide.nb"],
            Item[Delimiter],
            Item["Select", "RefGuide.nb", MainEntry -> True],
            Item["Cases", "RefGuide.nb"],
            Item["Array", "RefGuide.nb"],
            Item[Delimiter],
            Item["Thread", "RefGuide.nb"],
            Item["Inner", "RefGuide.nb"],
            Item["Outer", "RefGuide.nb"],
            Item["Distribute", "RefGuide.nb"],
            Item[Delimiter],
            Item["Identity", "RefGuide.nb"],
            Item["Composition", "RefGuide.nb"],
            Item["Operate", "RefGuide.nb"],
            Item["Through", "RefGuide.nb"],
            Item[Delimiter],
            Item["Compile", "RefGuide.nb"],
            Item["CompiledFunction", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Pattern Matching", None, 
          {
            Item["Blank (_)", "RefGuide.nb", IndexTag -> {"Blank", "_"}],
            Item["BlankSequence (__)", "RefGuide.nb", IndexTag -> {"BlankSequence", "__"}],
            Item["BlankNullSequence (___)", "RefGuide.nb", IndexTag -> {"BlankNullSequence", "___"}],
            Item["Alternatives (|)", "RefGuide.nb", IndexTag -> {"Alternatives", "|"}],
            Item["Pattern (:)", "RefGuide.nb", IndexTag -> {"Pattern", ":"}],
            Item["Optional (_.)", "RefGuide.nb", IndexTag -> {"Optional", "_."}],
            Item["Repeated (..)", "RefGuide.nb", IndexTag -> {"Repeated", ".."}],
            Item["RepeatedNull (...)", "RefGuide.nb", IndexTag -> {"RepeatedNull", "..."}],
            Item["Condition (/;)", "RefGuide.nb", IndexTag -> {"Condition", "/;"}],
            Item["Except", "RefGuide.nb"],
            Item["PatternTest (?)", "RefGuide.nb", IndexTag -> {"PatternTest", "?"}],
            Item["Verbatim", "RefGuide.nb"],
            Item["HoldPattern", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Orderless", "RefGuide.nb", MainEntry -> True],
            Item["Flat", "RefGuide.nb", MainEntry -> True],
            Item["OneIdentity", "RefGuide.nb", MainEntry -> True],
            Item["Default", "RefGuide.nb"],
            Item[Delimiter],
            Item["Cases", "RefGuide.nb"],
            Item["Position", "RefGuide.nb"],
            Item["Select", "RefGuide.nb"],
            Item["Pick", "RefGuide.nb"],
            Item["DeleteCases", "RefGuide.nb"],
            Item["Count", "RefGuide.nb"],
            Item["MatchQ", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Rule Application", None, 
          {
            Item["Rule (->)", "RefGuide.nb", IndexTag -> {"Rule", "->"}],
            Item["RuleDelayed (:>)", "RefGuide.nb", IndexTag -> {"RuleDelayed", ":>"}],
            Item[Delimiter],
            Item["Replace", "RefGuide.nb"],
            Item["ReplaceAll (/.)", "RefGuide.nb", IndexTag -> {"ReplaceAll", "/."}, MainEntry -> True],
            Item["ReplaceRepeated (//.)", "RefGuide.nb", IndexTag -> {"ReplaceRepeated", "//."}],
            Item["ReplaceList", "RefGuide.nb"],
            Item[Delimiter],
            Item["Dispatch", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["String Manipulation", None, 
          {
            Item["String", "RefGuide.nb", MainEntry -> True],
            Item["StringJoin (<>)", "RefGuide.nb", IndexTag -> {"StringJoin", "<>"}],
            Item["StringLength", "RefGuide.nb"],
            Item["StringReverse", "RefGuide.nb"],
            Item["StringTake", "RefGuide.nb"],
            Item["StringDrop", "RefGuide.nb"],
            Item["StringInsert", "RefGuide.nb"],
            Item[Delimiter],
            Item["StringExpression", "RefGuide.nb"],
            Item["RegularExpression", "RefGuide.nb"],
            Item[Delimiter],
            Item["StringReplace", "RefGuide.nb"],
            Item["StringReplacePart", "RefGuide.nb"],
            Item["StringReplaceList", "RefGuide.nb"],
            Item[Delimiter],
            Item["StringPosition", "RefGuide.nb"],
            Item["StringCases", "RefGuide.nb"],
            Item["StringCount", "RefGuide.nb"],
            Item["StringSplit", "RefGuide.nb"],
            Item[Delimiter],
            Item["SameQ (===)", "RefGuide.nb", IndexTag -> {"SameQ", "==="}],
            Item["StringMatchQ", "RefGuide.nb"],
            Item["StringFreeQ", "RefGuide.nb"],
            Item[Delimiter],
            Item["Characters", "RefGuide.nb"],
            Item["ToCharacterCode", "RefGuide.nb"],
            Item["FromCharacterCode", "RefGuide.nb"],
            Item["DigitQ", "RefGuide.nb"],
            Item["LetterQ", "RefGuide.nb"],
            Item["UpperCaseQ", "RefGuide.nb"],
            Item["LowerCaseQ", "RefGuide.nb"],
            Item["ToUpperCase", "RefGuide.nb"],
            Item["ToLowerCase", "RefGuide.nb"],
            Item["CharacterRange", "RefGuide.nb"],
            Item[Delimiter],
            Item["ToString", "RefGuide.nb", MainEntry -> True],
            Item["ToExpression", "RefGuide.nb", MainEntry -> True],
            Item["SyntaxQ", "RefGuide.nb"],
            Item["SyntaxLength", "RefGuide.nb"],
            Item["StringToStream", "RefGuide.nb"],
            Item[Delimiter],
            Item["Names", "RefGuide.nb"],
            Item["NameQ", "RefGuide.nb"],
            Item[Delimiter],
            Item["IgnoreCase", "RefGuide.nb"],
            Item["SpellingCorrection", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Scoping", None, 
          {
            Item["Module", "RefGuide.nb"],
            Item["With", "RefGuide.nb"],
            Item[Delimiter],
            Item["Block", "RefGuide.nb"],
            Item[Delimiter],
            Item["BeginPackage", "RefGuide.nb"],
            Item["EndPackage", "RefGuide.nb"],
            Item["Begin", "RefGuide.nb"],
            Item["End", "RefGuide.nb"],
            Item["Remove", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Context", "RefGuide.nb", MainEntry -> True],
            Item["$ContextPath", "RefGuide.nb", MainEntry -> True],
            Item["$Packages", "RefGuide.nb"],
            Item["DeclarePackage", "RefGuide.nb"],
            Item["Needs", "RefGuide.nb"],
            Item[Delimiter],
            Item["Names", "RefGuide.nb", MainEntry -> True],
            Item["Context", "RefGuide.nb"],
            Item["Contexts", "RefGuide.nb"],
            Item[Delimiter],
            Item["Unique", "RefGuide.nb"],
            Item["$ModuleNumber", "RefGuide.nb"],
            Item["$SessionID", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Evaluation Control", None, 
          {
            Item["Evaluate", "RefGuide.nb"],
            Item["Unevaluated", "RefGuide.nb"],
            Item["HoldPattern", "RefGuide.nb"],
            Item[Delimiter],
            Item["Hold", "RefGuide.nb"],
            Item["HoldComplete", "RefGuide.nb"],
            Item["HoldForm", "RefGuide.nb", MainEntry -> True],
            Item["ReleaseHold", "RefGuide.nb"],
            Item[Delimiter],
            Item["ToString", "RefGuide.nb"],
            Item["ToExpression", "RefGuide.nb"],
            Item[Delimiter],
            Item["$IterationLimit", "RefGuide.nb", MainEntry -> True],
            Item["$RecursionLimit", "RefGuide.nb", MainEntry -> True],
            Item["$MaxPrecision", "RefGuide.nb"],
            Item[Delimiter],
            Item["Update", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Debugging", None, 
          {
            Item["Trace", "RefGuide.nb"],
            Item["TraceDialog", "RefGuide.nb"],
            Item["TracePrint", "RefGuide.nb"],
            Item["TraceScan", "RefGuide.nb"],
            Item[Delimiter],
            Item["Dialog", "RefGuide.nb", MainEntry -> True],
            Item["Print", "RefGuide.nb"],
            Item["Reap", "RefGuide.nb"],
            Item["Sow", "RefGuide.nb"],
            Item[Delimiter],
            Item["Stack", "RefGuide.nb"],
            Item["StackBegin", "RefGuide.nb"],
            Item["StackInhibit", "RefGuide.nb"],
            Item["StackComplete", "RefGuide.nb"],
            Item[Delimiter],
            Item["TraceDepth", "RefGuide.nb"],
            Item["TraceForward", "RefGuide.nb"],
            Item["TraceBackward", "RefGuide.nb"],
            Item["TraceAbove", "RefGuide.nb"],
            Item["TraceOriginal", "RefGuide.nb"],
            Item["TraceOn", "RefGuide.nb"],
            Item["TraceOff", "RefGuide.nb"],
            Item["MatchLocalNames", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Attributes", None, 
          {
            Item["Attributes", "RefGuide.nb"],
            Item["SetAttributes", "RefGuide.nb"],
            Item["ClearAttributes", "RefGuide.nb"],
            Item["ClearAll", "RefGuide.nb"],
            Item[Delimiter],
            Item["Orderless", "RefGuide.nb"],
            Item["Flat", "RefGuide.nb"],
            Item["OneIdentity", "RefGuide.nb"],
            Item["Listable", "RefGuide.nb"],
            Item["Constant", "RefGuide.nb"],
            Item["NumericFunction", "RefGuide.nb"],
            Item["Protected", "RefGuide.nb"],
            Item["Locked", "RefGuide.nb"],
            Item["ReadProtected", "RefGuide.nb"],
            Item["HoldFirst", "RefGuide.nb"],
            Item["HoldRest", "RefGuide.nb"],
            Item["HoldAll", "RefGuide.nb"],
            Item["HoldAllComplete", "RefGuide.nb"],
            Item["SequenceHold", "RefGuide.nb"],
            Item["NHoldFirst", "RefGuide.nb"],
            Item["NHoldRest", "RefGuide.nb"],
            Item["NHoldAll", "RefGuide.nb"],
            Item["Temporary", "RefGuide.nb"],
            Item["Stub", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Expression Structure", None, 
          {
            Item["Head", "RefGuide.nb", MainEntry -> True],
            Item["Part", "RefGuide.nb"],
            Item["FullForm", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Symbol", "RefGuide.nb"],
            Item["String", "RefGuide.nb"],
            Item["Integer", "RefGuide.nb"],
            Item["Real", "RefGuide.nb"],
            Item["Raw", "RefGuide.nb"],
            Item[Delimiter],
            Item["Level", "RefGuide.nb"],
            Item["Heads", "RefGuide.nb"],
            Item["SymbolName", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Fixed Symbols", None, 
          {
            Item["Automatic", "RefGuide.nb"],
            Item["All", "RefGuide.nb"],
            Item["None", "RefGuide.nb"],
            Item["True", "RefGuide.nb"],
            Item["False", "RefGuide.nb"],
            Item[Delimiter],
            Item["Null", "RefGuide.nb"],
            Item["$Failed", "RefGuide.nb"],
            Item["$Aborted", "RefGuide.nb"],
            Item[Delimiter],
            Item["General", "RefGuide.nb"],
            Item["C", "RefGuide.nb"]
          }
        ]
      }
    ],
    BrowserCategory["Input and Output", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_InputOutput", IndexTag -> "Input and Output (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["Basic Operations", None, 
          {
            Item["Print", "RefGuide.nb", MainEntry -> True],
            Item["StylePrint", "RefGuide.nb"],
            Item["Input", "RefGuide.nb", MainEntry -> True],
            Item["InputString", "RefGuide.nb"],
            Item[Delimiter],
            Item["Get (<<)", "RefGuide.nb", IndexTag -> {"Get", "<<"}, MainEntry -> True],
            Item["Put (>>)", "RefGuide.nb", IndexTag -> {"Put", ">>"}, MainEntry -> True],
            Item["PutAppend (>>>)", "RefGuide.nb", IndexTag -> {"PutAppend", ">>>"}, MainEntry -> True],
            Item["Save", "RefGuide.nb", MainEntry -> True],
            Item["DumpSave", "RefGuide.nb"]
          }
        ],
        BrowserCategory["File Input", None, 
          {
            Item["Get (<<)", "RefGuide.nb", IndexTag -> {"Get", "<<"}],
            Item["Needs", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["ReadList", "RefGuide.nb"],
            Item["Read", "RefGuide.nb", MainEntry -> True],
            Item["BinaryRead", "RefGuide.nb"],
            Item["BinaryReadList", "RefGuide.nb"],
            Item[Delimiter],
            Item["FindList", "RefGuide.nb"],
            Item["Find", "RefGuide.nb"],
            Item["Skip", "RefGuide.nb"],
            Item[Delimiter],
            Item["OpenRead", "RefGuide.nb"],
            Item["Close", "RefGuide.nb", MainEntry -> True],
            Item["StreamPosition", "RefGuide.nb"],
            Item["SetStreamPosition", "RefGuide.nb"],
            Item["EndOfFile", "RefGuide.nb"]
          }
        ],
        BrowserCategory["File Output", None, 
          {
            Item["Put (>>)", "RefGuide.nb", IndexTag -> {"Put", ">>"}],
            Item["PutAppend (>>>)", "RefGuide.nb", IndexTag -> {"PutAppend", ">>>"}],
            Item["Save", "RefGuide.nb"],
            Item[Delimiter],
            Item["Splice", "RefGuide.nb"],
            Item["Display", "RefGuide.nb"],
            Item["Encode", "RefGuide.nb"],
            Item[Delimiter],
            Item["Write", "RefGuide.nb"],
            Item["WriteString", "RefGuide.nb"],
            Item["BinaryWrite", "RefGuide.nb"],
            Item["OpenWrite", "RefGuide.nb"],
            Item["OpenAppend", "RefGuide.nb"],
            Item["Close", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Import and Export", None, 
          {
            Item["Import", "RefGuide.nb", MainEntry -> True],
            Item["Export", "RefGuide.nb", MainEntry -> True],
            Item["ImportString", "RefGuide.nb", MainEntry -> True],
            Item["ExportString", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["HTMLSave", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Format Types", None, 
          {
            Item["StandardForm", "RefGuide.nb"],
            Item["TraditionalForm", "RefGuide.nb"],
            Item["InputForm", "RefGuide.nb"],
            Item["OutputForm", "RefGuide.nb"],
            Item[Delimiter],
            Item["CForm", "RefGuide.nb"],
            Item["FortranForm", "RefGuide.nb"],
            Item["TeXForm", "RefGuide.nb"],
            Item["MathMLForm", "RefGuide.nb"],
            Item["DisplayForm", "RefGuide.nb"],
            Item["FullForm", "RefGuide.nb"],
            Item["TreeForm", "RefGuide.nb"],
            Item[Delimiter],
            Item["MatrixForm", "RefGuide.nb"],
            Item["TableForm", "RefGuide.nb"],
            Item[Delimiter],
            Item["Short", "RefGuide.nb"],
            Item["Shallow", "RefGuide.nb"],
            Item[Delimiter],
            Item["Format", "RefGuide.nb"],
            Item[Delimiter],
            Item["TableAlignments", "RefGuide.nb"],
            Item["TableDepth", "RefGuide.nb"],
            Item["TableDirections", "RefGuide.nb"],
            Item["TableHeadings", "RefGuide.nb"],
            Item["TableSpacing", "RefGuide.nb"],
            Item["Skeleton", "RefGuide.nb"],
            Item["StringSkeleton", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Box Types", None, 
          {
            Item["RowBox", "RefGuide.nb"],
            Item["GridBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["SuperscriptBox (\\^)", "RefGuide.nb", IndexTag -> {"SuperscriptBox", "\\^"}],
            Item["SubscriptBox (\\_)", "RefGuide.nb", IndexTag -> {"SubscriptBox", "\\_"}],
            Item["SubsuperscriptBox", "RefGuide.nb"],
            Item["OverscriptBox (\\&)", "RefGuide.nb", IndexTag -> {"OverscriptBox", "\\&"}],
            Item["UnderscriptBox (\\+)", "RefGuide.nb", IndexTag -> {"UnderscriptBox", "\\+"}],
            Item["UnderoverscriptBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["FractionBox (\\/)", "RefGuide.nb", IndexTag -> {"FractionBox", "\\/"}],
            Item["SqrtBox (\\@)", "RefGuide.nb", IndexTag -> {"SqrtBox", "\\@"}],
            Item["RadicalBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["StyleBox", "RefGuide.nb"],
            Item["FrameBox", "RefGuide.nb"],
            Item["AdjustmentBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["ButtonBox", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["FormBox (\\`)", "RefGuide.nb", IndexTag -> {"FormBox", "\\`"}],
            Item["InterpretationBox", "RefGuide.nb"],
            Item["TagBox", "RefGuide.nb"],
            Item["ErrorBox", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Box Options", None, 
          {
            Item["ColumnAlignments", "RefGuide.nb"],
            Item["RowAlignments", "RefGuide.nb"],
            Item["ColumnSpacings", "RefGuide.nb"],
            Item["RowSpacings", "RefGuide.nb"],
            Item["ColumnsEqual", "RefGuide.nb"],
            Item["RowsEqual", "RefGuide.nb"],
            Item["ColumnWidths", "RefGuide.nb"],
            Item["RowMinHeight", "RefGuide.nb"],
            Item["GridBaseline", "RefGuide.nb"],
            Item[Delimiter],
            Item["ColumnLines", "RefGuide.nb"],
            Item["RowLines", "RefGuide.nb"],
            Item["GridDefaultElement", "RefGuide.nb"],
            Item[Delimiter],
            Item["ButtonStyle", "RefGuide.nb", MainEntry -> True],
            Item["ButtonFrame", "RefGuide.nb"],
            Item["ButtonExpandable", "RefGuide.nb"],
            Item["ButtonMargins", "RefGuide.nb"],
            Item["ButtonMinHeight", "RefGuide.nb"],
            Item[Delimiter],
            Item["ScriptSizeMultipliers", "RefGuide.nb"],
            Item["ScriptMinSize", "RefGuide.nb"],
            Item["ScriptBaselineShifts", "RefGuide.nb"],
            Item["LimitsPositioning", "RefGuide.nb"],
            Item[Delimiter],
            Item["Editable", "RefGuide.nb"],
            Item["Selectable", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Number Formatting", None, 
          {
            Item["NumberForm", "RefGuide.nb"],
            Item["ScientificForm", "RefGuide.nb"],
            Item["EngineeringForm", "RefGuide.nb"],
            Item["AccountingForm", "RefGuide.nb"],
            Item["BaseForm", "RefGuide.nb"],
            Item["PaddedForm", "RefGuide.nb"],
            Item["ColumnForm", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["DigitBlock", "RefGuide.nb"],
            Item["NumberSeparator", "RefGuide.nb"],
            Item["NumberPoint", "RefGuide.nb"],
            Item["NumberMultiplier", "RefGuide.nb"],
            Item["NumberSigns", "RefGuide.nb"],
            Item["NumberPadding", "RefGuide.nb"],
            Item["SignPadding", "RefGuide.nb"],
            Item["NumberFormat", "RefGuide.nb"],
            Item["ExponentFunction", "RefGuide.nb"],
            Item["NumberMarks", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Formatting Functions", None, 
          {
            Item["StyleForm", "RefGuide.nb"],
            Item["StringForm", "RefGuide.nb"],
            Item["SequenceForm", "RefGuide.nb"],
            Item["HoldForm", "RefGuide.nb"],
            Item["ColumnForm", "RefGuide.nb"],
            Item[Delimiter],
            Item["Infix", "RefGuide.nb"],
            Item["Prefix", "RefGuide.nb"],
            Item["Postfix", "RefGuide.nb"],
            Item["PrecedenceForm", "RefGuide.nb"],
            Item[Delimiter],
            Item["ToString", "RefGuide.nb"],
            Item["ToBoxes", "RefGuide.nb"],
            Item["ToExpression", "RefGuide.nb"],
            Item["MakeBoxes", "RefGuide.nb"],
            Item["MakeExpression", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Messages", None, 
          {
            Item["On", "RefGuide.nb"],
            Item["Off", "RefGuide.nb"],
            Item["Check", "RefGuide.nb"],
            Item[Delimiter],
            Item["Message", "RefGuide.nb"],
            Item["$Language", "RefGuide.nb", MainEntry -> True],
            Item["MessageName (::)", "RefGuide.nb", IndexTag -> {"MessageName", "::"}],
            Item["Messages", "RefGuide.nb"],
            Item["Information", "RefGuide.nb"],
            Item[Delimiter],
            Item["MessageList", "RefGuide.nb", MainEntry -> True],
            Item["$MessageList", "RefGuide.nb"],
            Item["$NewSymbol", "RefGuide.nb"],
            Item["$NewMessage", "RefGuide.nb"],
            Item["$MessagePrePrint", "RefGuide.nb", MainEntry -> True]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Data Reading Options", None, 
          {
            Item["RecordLists", "RefGuide.nb"],
            Item[Delimiter],
            Item["RecordSeparators", "RefGuide.nb"],
            Item["WordSeparators", "RefGuide.nb"],
            Item["NullRecords", "RefGuide.nb"],
            Item["NullWords", "RefGuide.nb"],
            Item["TokenWords", "RefGuide.nb"],
            Item[Delimiter],
            Item["Byte", "RefGuide.nb"],
            Item["Character", "RefGuide.nb"],
            Item["Expression", "RefGuide.nb"],
            Item["Number", "RefGuide.nb"],
            Item["Real", "RefGuide.nb"],
            Item["Record", "RefGuide.nb"],
            Item["String", "RefGuide.nb"],
            Item["Word", "RefGuide.nb"],
            Item[Delimiter],
            Item["WordSearch", "RefGuide.nb"],
            Item["AnchoredSearch", "RefGuide.nb"],
            Item["IgnoreCase", "RefGuide.nb"],
            Item[Delimiter],
            Item["InputStream", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Output Options", None, 
          {
            Item["PageWidth", "RefGuide.nb"],
            Item["TotalWidth", "RefGuide.nb"],
            Item[Delimiter],
            Item["FormatType", "RefGuide.nb", MainEntry -> True],
            Item["$PrePrint", "RefGuide.nb"],
            Item[Delimiter],
            Item["CharacterEncoding", "RefGuide.nb"],
            Item["$CharacterEncoding", "RefGuide.nb", MainEntry -> True],
            Item["$NumberMarks", "RefGuide.nb"],
            Item[Delimiter],
            Item["OutputStream", "RefGuide.nb"],
            Item["Options", "RefGuide.nb"],
            Item["SetOptions", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["$Output", "RefGuide.nb", MainEntry -> True],
            Item["$Echo", "RefGuide.nb", MainEntry -> True],
            Item["$Messages", "RefGuide.nb", MainEntry -> True],
            Item["$Urgent", "RefGuide.nb", MainEntry -> True],
            Item["$Display", "RefGuide.nb", MainEntry -> True],
            Item["$DisplayFunction", "RefGuide.nb", MainEntry -> True],
            Item["$TextStyle", "RefGuide.nb", MainEntry -> True],
            Item["$FormatType", "RefGuide.nb", MainEntry -> True]
          }
        ]
      }
    ],
    BrowserCategory["Notebooks", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_Notebooks", IndexTag -> "Notebooks (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["Basic Objects", None, 
          {
            Item["Cell", "RefGuide.nb"],
            Item["Notebook", "RefGuide.nb"],
            Item["CellGroupData", "RefGuide.nb"],
            Item[Delimiter],
            Item["Notebooks", "RefGuide.nb"],
            Item["SelectedNotebook", "RefGuide.nb"],
            Item["EvaluationNotebook", "RefGuide.nb"],
            Item["InputNotebook", "RefGuide.nb"],
            Item["ButtonNotebook", "RefGuide.nb"],
            Item[Delimiter],
            Item["NotebookObject", "RefGuide.nb"],
            Item["NotebookSelection", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Notebook Operations", None, 
          {
            Item["NotebookGet", "RefGuide.nb"],
            Item["NotebookPut", "RefGuide.nb"],
            Item[Delimiter],
            Item["NotebookCreate", "RefGuide.nb"],
            Item["NotebookOpen", "RefGuide.nb"],
            Item["NotebookLocate", "RefGuide.nb"],
            Item["NotebookClose", "RefGuide.nb"],
            Item[Delimiter],
            Item["NotebookSave", "RefGuide.nb"],
            Item["NotebookPrint", "RefGuide.nb"],
            Item[Delimiter],
            Item["Options", "RefGuide.nb"],
            Item["SetOptions", "RefGuide.nb"],
            Item["SetSelectedNotebook", "RefGuide.nb"],
            Item[Delimiter],
            Item["FrontEndExecute", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Notebook Manipulation", None, 
          {
            Item["CellPrint", "RefGuide.nb"],
            Item["NotebookApply", "RefGuide.nb"],
            Item["NotebookWrite", "RefGuide.nb"],
            Item["NotebookRead", "RefGuide.nb"],
            Item["NotebookDelete", "RefGuide.nb"],
            Item[Delimiter],
            Item["NotebookFind", "RefGuide.nb"],
            Item["SelectionMove", "RefGuide.nb"],
            Item[Delimiter],
            Item["SelectionEvaluate", "RefGuide.nb"],
            Item["SelectionCreateCell", "RefGuide.nb"],
            Item["SelectionEvaluateCreateCell", "RefGuide.nb"],
            Item["SelectionAnimate", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Active Elements", None, 
          {
            Item["ButtonBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["Active", "RefGuide.nb"],
            Item[Delimiter],
            Item["ButtonStyle", "RefGuide.nb"],
            Item["ButtonFunction", "RefGuide.nb"],
            Item["ButtonSource", "RefGuide.nb"],
            Item["ButtonData", "RefGuide.nb"],
            Item["ButtonEvaluator", "RefGuide.nb"],
            Item["ButtonNote", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Cell Options", None, 
          {
            Item["CellFrame", "RefGuide.nb"],
            Item["CellDingbat", "RefGuide.nb"],
            Item["Background", "RefGuide.nb"],
            Item["Magnification", "RefGuide.nb"],
            Item["ShowCellBracket", "RefGuide.nb"],
            Item["CellOpen", "RefGuide.nb"],
            Item[Delimiter],
            Item["CellMargins", "RefGuide.nb"],
            Item["CellFrameMargins", "RefGuide.nb"],
            Item["CellBaseline", "RefGuide.nb"],
            Item[Delimiter],
            Item["CellLabel", "RefGuide.nb"],
            Item["ShowCellLabel", "RefGuide.nb"],
            Item["CellLabelAutoDelete", "RefGuide.nb"],
            Item["CellTags", "RefGuide.nb"],
            Item["ShowCellTags", "RefGuide.nb"],
            Item["ConversionRules", "RefGuide.nb"],
            Item[Delimiter],
            Item["Editable", "RefGuide.nb"],
            Item["Selectable", "RefGuide.nb"],
            Item["Copyable", "RefGuide.nb"],
            Item["Deletable", "RefGuide.nb"],
            Item["Evaluatable", "RefGuide.nb"],
            Item["Active", "RefGuide.nb"],
            Item["CellEditDuplicate", "RefGuide.nb"],
            Item["CellEvaluationDuplicate", "RefGuide.nb"],
            Item["CellAutoOverwrite", "RefGuide.nb"],
            Item[Delimiter],
            Item["Evaluator", "RefGuide.nb"],
            Item["GeneratedCell", "RefGuide.nb"],
            Item["InitializationCell", "RefGuide.nb"],
            Item[Delimiter],
            Item["PageBreakAbove", "RefGuide.nb"],
            Item["PageBreakWithin", "RefGuide.nb"],
            Item["PageBreakBelow", "RefGuide.nb"],
            Item["GroupPageBreakWithin", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Font and Text Options", None, 
          {
            Item["FontSize", "RefGuide.nb"],
            Item["FontWeight", "RefGuide.nb"],
            Item["FontSlant", "RefGuide.nb"],
            Item["FontFamily", "RefGuide.nb"],
            Item["FontTracking", "RefGuide.nb"],
            Item["FontSubstitutions", "RefGuide.nb"],
            Item["FontColor", "RefGuide.nb"],
            Item["Background", "RefGuide.nb"],
            Item[Delimiter],
            Item["PageWidth", "RefGuide.nb"],
            Item["TextAlignment", "RefGuide.nb"],
            Item["TextJustification", "RefGuide.nb"],
            Item["Hyphenation", "RefGuide.nb"],
            Item["LanguageCategory", "RefGuide.nb"],
            Item[Delimiter],
            Item["LineSpacing", "RefGuide.nb"],
            Item["ParagraphSpacing", "RefGuide.nb"],
            Item["ParagraphIndent", "RefGuide.nb"],
            Item["LineIndent", "RefGuide.nb"],
            Item["LineIndentMaxFraction", "RefGuide.nb"],
            Item[Delimiter],
            Item["AutoSpacing", "RefGuide.nb"],
            Item["AutoItalicWords", "RefGuide.nb"],
            Item["SingleLetterItalics", "RefGuide.nb"],
            Item["ShowStringCharacters", "RefGuide.nb"],
            Item["ShowSpecialCharacters", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Graphics Options", None, 
          {
            Item["ImageSize", "RefGuide.nb"],
            Item["ImageMargins", "RefGuide.nb"],
            Item["AspectRatioFixed", "RefGuide.nb"],
            Item[Delimiter],
            Item["AnimationDisplayTime", "RefGuide.nb"],
            Item["AnimationDirection", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Notebook Options", None, 
          {
            Item["WindowSize", "RefGuide.nb"],
            Item["WindowMargins", "RefGuide.nb"],
            Item["WindowFrame", "RefGuide.nb"],
            Item["WindowElements", "RefGuide.nb"],
            Item["WindowTitle", "RefGuide.nb"],
            Item["WindowToolbars", "RefGuide.nb"],
            Item["WindowMovable", "RefGuide.nb"],
            Item["WindowFloating", "RefGuide.nb"],
            Item["WindowClickSelect", "RefGuide.nb"],
            Item[Delimiter],
            Item["Visible", "RefGuide.nb"],
            Item["Editable", "RefGuide.nb"],
            Item["Selectable", "RefGuide.nb"],
            Item["Deletable", "RefGuide.nb"],
            Item["Background", "RefGuide.nb"],
            Item["Magnification", "RefGuide.nb"],
            Item["PageWidth", "RefGuide.nb"],
            Item["CellGrouping", "RefGuide.nb"],
            Item["ShowPageBreaks", "RefGuide.nb"],
            Item["NotebookAutoSave", "RefGuide.nb"],
            Item[Delimiter],
            Item["ScreenStyleEnvironment", "RefGuide.nb"],
            Item["PrintingStyleEnvironment", "RefGuide.nb"],
            Item["StyleDefinitions", "RefGuide.nb"],
            Item["DefaultNewCellStyle", "RefGuide.nb"],
            Item["DefaultDuplicateCellStyle", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Editing Options", None, 
          {
            Item["AutoIndent", "RefGuide.nb"],
            Item["DelimiterFlashTime", "RefGuide.nb"],
            Item["ShowCursorTracker", "RefGuide.nb"],
            Item["ShowAutoStyles", "RefGuide.nb"],
            Item["InputAliases", "RefGuide.nb"],
            Item["InputAutoReplacements", "RefGuide.nb"],
            Item["DragAndDrop", "RefGuide.nb"],
            Item["StructuredSelection", "RefGuide.nb"]
          }
        ]
      }
    ],
    BrowserCategory["System Interface", None, 
      {
        Item["(Alphabetical Listing)", "MathematicaFunctionList.nb", CopyTag -> "FunctionList_SystemInterface", IndexTag -> "System Interface (Alphabetical Listing)"],
        Item[Delimiter],
        BrowserCategory["File System", None, 
          {
            Item["Directory", "RefGuide.nb"],
            Item["SetDirectory", "RefGuide.nb"],
            Item["ResetDirectory", "RefGuide.nb"],
            Item["DirectoryStack", "RefGuide.nb"],
            Item["ParentDirectory", "RefGuide.nb"],
            Item["Path", "RefGuide.nb"],
            Item["$Path", "RefGuide.nb", MainEntry -> True],
            Item["$HomeDirectory", "RefGuide.nb"],
            Item["$BaseDirectory", "RefGuide.nb"],
            Item["$UserBaseDirectory", "RefGuide.nb"],
            Item["$InitialDirectory", "RefGuide.nb"],
            Item["$InstallationDirectory", "RefGuide.nb"],
            Item[Delimiter],
            Item["FileNames", "RefGuide.nb"],
            Item["DirectoryName", "RefGuide.nb"],
            Item["ToFileName", "RefGuide.nb"],
            Item[Delimiter],
            Item["CopyFile", "RefGuide.nb"],
            Item["RenameFile", "RefGuide.nb"],
            Item["DeleteFile", "RefGuide.nb"],
            Item["FileByteCount", "RefGuide.nb"],
            Item["FileDate", "RefGuide.nb"],
            Item["SetFileDate", "RefGuide.nb"],
            Item["FileType", "RefGuide.nb"],
            Item[Delimiter],
            Item["CreateDirectory", "RefGuide.nb"],
            Item["DeleteDirectory", "RefGuide.nb"],
            Item["RenameDirectory", "RefGuide.nb"],
            Item["CopyDirectory", "RefGuide.nb"],
            Item[Delimiter],
            Item["OpenTemporary", "RefGuide.nb"]
          }
        ],
        BrowserCategory["External Commands", None, 
          {
            Item["Get (<<)", "RefGuide.nb", IndexTag -> {"Get", "<<"}],
            Item["Put (>>)", "RefGuide.nb", IndexTag -> {"Put", ">>"}],
            Item["Read", "RefGuide.nb"],
            Item[Delimiter],
            Item["Run", "RefGuide.nb"],
            Item["RunThrough", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["MathLink", None, 
          {
            Item["Install", "RefGuide.nb"],
            Item["Uninstall", "RefGuide.nb"],
            Item["Links", "RefGuide.nb", MainEntry -> True],
            Item["LinkPatterns", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinkLaunch", "RefGuide.nb"],
            Item["LinkCreate", "RefGuide.nb"],
            Item["LinkConnect", "RefGuide.nb"],
            Item["LinkClose", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinkWrite", "RefGuide.nb"],
            Item["LinkRead", "RefGuide.nb"],
            Item["LinkInterrupt", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinkObject", "RefGuide.nb"],
            Item["LinkReadyQ", "RefGuide.nb"],
            Item["LinkProtocol", "RefGuide.nb"],
            Item["$ParentLink", "RefGuide.nb"],
            Item["$CurrentLink", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Mathematica Sessions", None, 
          {
            Item["In", "RefGuide.nb"],
            Item["Out (%)", "RefGuide.nb", IndexTag -> {"Out", "%"}],
            Item["InString", "RefGuide.nb"],
            Item["MessageList", "RefGuide.nb"],
            Item["$Line", "RefGuide.nb"],
            Item["$HistoryLength", "RefGuide.nb"],
            Item[Delimiter],
            Item["Exit", "RefGuide.nb"],
            Item["Quit", "RefGuide.nb"],
            Item["$Epilog", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Dialog", "RefGuide.nb"],
            Item["DialogSymbols", "RefGuide.nb"],
            Item["DialogProlog", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Pre", "RefGuide.nb", MainEntry -> True],
            Item["$Post", "RefGuide.nb", MainEntry -> True],
            Item["$PrePrint", "RefGuide.nb", MainEntry -> True],
            Item["$MessagePrePrint", "RefGuide.nb"],
            Item["$PreRead", "RefGuide.nb", MainEntry -> True],
            Item["$SyntaxHandler", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["$Display", "RefGuide.nb"],
            Item["$Output", "RefGuide.nb"],
            Item["$Input", "RefGuide.nb"],
            Item["$FrontEnd", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Time and Date", None, 
          {
            Item["Timing", "RefGuide.nb"],
            Item["AbsoluteTiming", "RefGuide.nb"],
            Item["TimeUsed", "RefGuide.nb"],
            Item["SessionTime", "RefGuide.nb"],
            Item["TimeConstrained", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Date", "RefGuide.nb"],
            Item["AbsoluteTime", "RefGuide.nb"],
            Item["FromDate", "RefGuide.nb"],
            Item["ToDate", "RefGuide.nb"],
            Item["TimeZone", "RefGuide.nb"],
            Item[Delimiter],
            Item["Pause", "RefGuide.nb", MainEntry -> True]
          }
        ],
        BrowserCategory["Memory Usage", None, 
          {
            Item["MemoryInUse", "RefGuide.nb"],
            Item["MaxMemoryUsed", "RefGuide.nb"],
            Item["MemoryConstrained", "RefGuide.nb", MainEntry -> True],
            Item[Delimiter],
            Item["Share", "RefGuide.nb"],
            Item["ByteCount", "RefGuide.nb"],
            Item["LeafCount", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Global Parameters", None, 
          {
            Item["Streams", "RefGuide.nb"],
            Item["Links", "RefGuide.nb"],
            Item["Names", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Linked", "RefGuide.nb"],
            Item["$Notebooks", "RefGuide.nb"],
            Item["$CommandLine", "RefGuide.nb"],
            Item["$BatchInput", "RefGuide.nb"],
            Item["$BatchOutput", "RefGuide.nb"],
            Item["$SessionID", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Display", "RefGuide.nb"],
            Item["$DisplayFunction", "RefGuide.nb"],
            Item["$Echo", "RefGuide.nb"],
            Item["$Messages", "RefGuide.nb"],
            Item["$Output", "RefGuide.nb"],
            Item["$SoundDisplayFunction", "RefGuide.nb"],
            Item["$Urgent", "RefGuide.nb"],
            Item["$FrontEnd", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Pre", "RefGuide.nb"],
            Item["$Post", "RefGuide.nb"],
            Item["$PrePrint", "RefGuide.nb"],
            Item["$PreRead", "RefGuide.nb"],
            Item["$SyntaxHandler", "RefGuide.nb"],
            Item["$Inspector", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Language", "RefGuide.nb"],
            Item["$CharacterEncoding", "RefGuide.nb"],
            Item["$TextStyle", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Context", "RefGuide.nb"],
            Item["$ContextPath", "RefGuide.nb"],
            Item["$Path", "RefGuide.nb"],
            Item[Delimiter],
            Item["$RecursionLimit", "RefGuide.nb"],
            Item["$IterationLimit", "RefGuide.nb"],
            Item["$RandomState", "RefGuide.nb"],
            Item["$MaxPrecision", "RefGuide.nb"],
            Item["$MinPrecision", "RefGuide.nb"],
            Item["$MaxExtraPrecision", "RefGuide.nb"],
            Item["$MaxPiecewiseCases", "RefGuide.nb"],
            Item[Delimiter],
            Item["$Epilog", "RefGuide.nb"],
            Item["$IgnoreEOF", "RefGuide.nb"]
          }
        ],
        BrowserCategory["System Parameters", None, 
          {
            Item["$Version", "RefGuide.nb"],
            Item["$VersionNumber", "RefGuide.nb"],
            Item["$ReleaseNumber", "RefGuide.nb"],
            Item["$CreationDate", "RefGuide.nb"],
            Item["$InstallationDate", "RefGuide.nb"],
            Item["$ProductInformation", "RefGuide.nb"],
            Item[Delimiter],
            Item["Environment", "RefGuide.nb"],
            Item[Delimiter],
            Item["$System", "RefGuide.nb"],
            Item["$SystemID", "RefGuide.nb"],
            Item["$OperatingSystem", "RefGuide.nb"],
            Item["$SystemCharacterEncoding", "RefGuide.nb"],
            Item["$MachineType", "RefGuide.nb"],
            Item["$ProcessorType", "RefGuide.nb"],
            Item["$ByteOrdering", "RefGuide.nb"],
            Item["$MachineName", "RefGuide.nb"],
            Item["$MachineDomain", "RefGuide.nb"],
            Item["$MachineID", "RefGuide.nb"],
            Item[Delimiter],
            Item["$UserName", "RefGuide.nb"],
            Item["$ProcessID", "RefGuide.nb"],
            Item["$ParentProcessID", "RefGuide.nb"],
            Item[Delimiter],
            Item["$TimeUnit", "RefGuide.nb"],
            Item[Delimiter],
            Item["$MachineEpsilon", "RefGuide.nb"],
            Item["$MaxMachineNumber", "RefGuide.nb"],
            Item["$MinMachineNumber", "RefGuide.nb"],
            Item["$MaxNumber", "RefGuide.nb"],
            Item["$MinNumber", "RefGuide.nb"]
          }
        ]
      }
    ],
    Item[Delimiter],
    BrowserCategory["New in Version 5.2", None, 
      {
        Item["Highlights", "WhatsNew52.nb", CopyTag -> "S0.0.2", IndexTag -> "Highlights: New in Mathematica 5.2"]
      }
    ],
    BrowserCategory["New in Version 5.1", None, 
      {
        BrowserCategory["Highlights", None, 
          {
            Item["Numerical computation", "WhatsNew51.nb", CopyTag -> "S0.0.2", IndexTag -> "Highlights: Numerical computation"],
            Item["Symbolic computation", "WhatsNew51.nb", CopyTag -> "S0.0.3", IndexTag -> "Highlights: Symbolic computation"],
            Item["Language and core system", "WhatsNew51.nb", CopyTag -> "S0.0.4", IndexTag -> "Highlights: Language and core system"],
            Item["Data handling and visualization", "WhatsNew51.nb", CopyTag -> "S0.0.5", IndexTag -> "Highlights: Data handling and visualization"],
            Item["Database access", "WhatsNew51.nb", CopyTag -> "S0.0.6", IndexTag -> "Highlights: Database access"],
            Item["GUI tools", "WhatsNew51.nb", CopyTag -> "S0.0.7", IndexTag -> "Highlights: GUI tools"],
            Item["Web Services", "WhatsNew51.nb", CopyTag -> "S0.0.8", IndexTag -> "Highlights: Web Services"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Numerical Computation", None, 
          {
            Item["HessenbergDecomposition", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Algebraic Computation", None, 
          {
            Item["D (modified)", "RefGuide.nb", IndexTag -> "D"],
            Item["Piecewise", "RefGuide.nb"],
            Item["PiecewiseExpand", "RefGuide.nb"],
            Item["$MaxPiecewiseCases", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Mathematical Functions", None, 
          {
            Item["Clip", "RefGuide.nb"],
            Item["Rescale", "RefGuide.nb"],
            Item[Delimiter],
            Item["Boole", "RefGuide.nb"],
            Item["Piecewise", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Lists and Matrices", None, 
          {
            Item["Transpose (modified)", "RefGuide.nb", IndexTag -> "Transpose"],
            Item["ConjugateTranspose", "RefGuide.nb"],
            Item["HessenbergDecomposition", "RefGuide.nb"],
            Item[Delimiter],
            Item["Pick", "RefGuide.nb"],
            Item["Tuples", "RefGuide.nb"],
            Item["Subsets", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Graphics", None, 
          {
            Item["ArrayPlot", "RefGuide.nb"],
            Item[Delimiter],
            BrowserCategory["Colors", None, 
              {
                Item["Black", "RefGuide.nb"],
                Item["Blue", "RefGuide.nb"],
                Item["Brown", "RefGuide.nb"],
                Item["Cyan", "RefGuide.nb"],
                Item["Gray", "RefGuide.nb"],
                Item["Green", "RefGuide.nb"],
                Item["Magenta", "RefGuide.nb"],
                Item["Orange", "RefGuide.nb"],
                Item["Pink", "RefGuide.nb"],
                Item["Purple", "RefGuide.nb"],
                Item["Red", "RefGuide.nb"],
                Item["White", "RefGuide.nb"],
                Item["Yellow", "RefGuide.nb"]
              }
            ]
          }
        ],
        BrowserCategory["Programming", None, 
          {
            Item["Except", "RefGuide.nb"],
            Item[Delimiter],
            Item["StringExpression", "RefGuide.nb"],
            Item["RegularExpression", "RefGuide.nb"],
            Item["StringReplace (modified)", "RefGuide.nb", IndexTag -> "StringReplace"],
            Item["StringReplaceList", "RefGuide.nb"],
            Item["StringPosition (modified)", "RefGuide.nb", IndexTag -> "StringPosition"],
            Item["StringCases", "RefGuide.nb"],
            Item["StringCount", "RefGuide.nb"],
            Item["StringSplit", "RefGuide.nb"],
            Item["StringMatchQ (modified)", "RefGuide.nb", IndexTag -> "StringMatchQ"],
            Item["StringFreeQ", "RefGuide.nb"],
            Item[Delimiter],
            Item["ToExpression (modified)", "RefGuide.nb", IndexTag -> {"ToExpression"}]
          }
        ],
        BrowserCategory["Input and Output", None, 
          {
            Item["BinaryRead", "RefGuide.nb"],
            Item["BinaryReadList", "RefGuide.nb"],
            Item["BinaryWrite", "RefGuide.nb"],
            Item[Delimiter],
            Item["Import (modified)", "RefGuide.nb", IndexTag -> "Import"],
            Item["Export (modified)", "RefGuide.nb", IndexTag -> "Export"],
            Item["ImportString (modified)", "RefGuide.nb", IndexTag -> "ImportString"],
            Item["ExportString (modified)", "RefGuide.nb", IndexTag -> "ExportString"],
            Item[Delimiter],
            Item["TeXForm (modified)", "RefGuide.nb", IndexTag -> "TeXForm"]
          }
        ]
      }
    ],
    BrowserCategory["New in Version 5.0", None, 
      {
        BrowserCategory["Highlights", None, 
          {
            Item["Numerical Computation", "WhatsNew50.nb", CopyTag -> "S0.0.2"],
            Item["Symbolic Computation", "WhatsNew50.nb", CopyTag -> "S0.0.3"],
            Item["Programming and Core System", "WhatsNew50.nb", CopyTag -> "S0.0.4"],
            Item["Interfaces", "WhatsNew50.nb", CopyTag -> "S0.0.5"],
            Item["Notebook Interface", "WhatsNew50.nb", CopyTag -> "S0.0.6"],
            Item["Standard Add-on Packages", "WhatsNew50.nb", CopyTag -> "S0.0.7"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Numerical Computation", None, 
          {
            Item["N (modified)", "RefGuide.nb", IndexTag -> "N"],
            Item[Delimiter],
            Item["NDSolve (modified)", "RefGuide.nb", IndexTag -> "NDSolve"],
            Item["NIntegrate (modified)", "RefGuide.nb", IndexTag -> "NIntegrate"],
            Item["FindRoot (modified)", "RefGuide.nb", IndexTag -> "FindRoot"],
            Item[Delimiter],
            Item["NMaximize", "RefGuide.nb"],
            Item["NMinimize", "RefGuide.nb"],
            Item["FindMaximum", "RefGuide.nb"],
            Item["FindMinimum (modified)", "RefGuide.nb", IndexTag -> "FindMinimum"],
            Item["FindFit", "RefGuide.nb"],
            Item["LinearProgramming (modified)", "RefGuide.nb", IndexTag -> "LinearProgramming"],
            Item[Delimiter],
            Item["Mean", "RefGuide.nb"],
            Item["Variance", "RefGuide.nb"],
            Item["StandardDeviation", "RefGuide.nb"],
            Item["Median", "RefGuide.nb"],
            Item["Quantile", "RefGuide.nb"],
            Item[Delimiter],
            Item["Accuracy (modified)", "RefGuide.nb", IndexTag -> "Accuracy"],
            Item["Precision (modified)", "RefGuide.nb", IndexTag -> "Precision"],
            Item["MachinePrecision", "RefGuide.nb"],
            Item[Delimiter],
            Item["StepMonitor", "RefGuide.nb"],
            Item["EvaluationMonitor", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Algebraic Computation", None, 
          {
            Item["Refine", "RefGuide.nb"],
            Item["Assuming", "RefGuide.nb"],
            Item["ForAll", "RefGuide.nb"],
            Item["Exists", "RefGuide.nb"],
            Item[Delimiter],
            Item["Reduce (modified)", "RefGuide.nb", IndexTag -> "Reduce"],
            Item["FindInstance", "RefGuide.nb"],
            Item["Resolve", "RefGuide.nb"],
            Item["CylindricalDecomposition", "RefGuide.nb"],
            Item[Delimiter],
            Item["Maximize", "RefGuide.nb"],
            Item["Minimize", "RefGuide.nb"],
            Item[Delimiter],
            Item["Integrate (modified)", "RefGuide.nb", IndexTag -> "Integrate"],
            Item["DSolve (modified)", "RefGuide.nb", IndexTag -> "DSolve"],
            Item["RSolve", "RefGuide.nb"],
            Item[Delimiter],
            Item["GeneratedParameters", "RefGuide.nb"],
            Item["$Assumptions", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Lists and Matrices", None, 
          {
            Item["SparseArray", "RefGuide.nb"],
            Item["ArrayRules", "RefGuide.nb"],
            Item["CoefficientArrays", "RefGuide.nb"],
            Item["ArrayQ", "RefGuide.nb"],
            Item["ArrayDepth", "RefGuide.nb"],
            Item[Delimiter],
            Item["Most", "RefGuide.nb"],
            Item["Total", "RefGuide.nb"],
            Item["Norm", "RefGuide.nb"],
            Item[Delimiter],
            Item["Eigenvalues (modified)", "RefGuide.nb", IndexTag -> "Eigenvalues"],
            Item["Eigenvectors (modified)", "RefGuide.nb", IndexTag -> "Eigenvectors"],
            Item["Eigensystem (modified)", "RefGuide.nb", IndexTag -> "Eigensystem"],
            Item["CharacteristicPolynomial", "RefGuide.nb"],
            Item["MatrixRank", "RefGuide.nb"],
            Item["SingularValueList", "RefGuide.nb"],
            Item["SingularValueDecomposition", "RefGuide.nb"],
            Item["CholeskyDecomposition", "RefGuide.nb"],
            Item["SchurDecomposition (modified)", "RefGuide.nb", IndexTag -> "SchurDecomposition"],
            Item["LinearSolve (modified)", "RefGuide.nb", IndexTag -> "LinearSolve"],
            Item["LinearSolveFunction", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Programming", None, 
          {
            Item["Sow", "RefGuide.nb"],
            Item["Reap", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Input and Output", None, 
          {
            Item["Import (modified)", "RefGuide.nb", IndexTag -> "Import"],
            Item["Export (modified)", "RefGuide.nb", IndexTag -> "Export"],
            Item["ImportString (modified)", "RefGuide.nb", IndexTag -> "ImportString"],
            Item["ExportString (modified)", "RefGuide.nb", IndexTag -> "ExportString"],
            Item["HTMLSave (modified)", "RefGuide.nb", IndexTag -> "HTMLSave"]
          }
        ],
        BrowserCategory["System Interface", None, 
          {
            Item["AbsoluteTiming", "RefGuide.nb"],
            Item["$BaseDirectory", "RefGuide.nb"],
            Item["$UserBaseDirectory", "RefGuide.nb"],
            Item["$InstallationDirectory", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Obsolete in Version 5", None, 
          {
            Item["ConstrainedMax", "Obsolete.nb", CopyTag -> None],
            Item["ConstrainedMin", "Obsolete.nb", CopyTag -> None],
            Item["SingularValues", "Obsolete.nb", CopyTag -> None],
            Item["TensorRank", "Obsolete.nb", CopyTag -> None]
          }
        ]
      }
    ],
    BrowserCategory["New in Version 4.x", None, 
      {
        BrowserCategory["Highlights", None, 
          {
            BrowserCategory["Version 4.2", None, 
              {
                Item["Numerical Computation", "WhatsNew42.nb", CopyTag -> "S0.0.2"],
                Item["Algebraic Computation", "WhatsNew42.nb", CopyTag -> "S0.0.3"],
                Item["Notebook Interface", "WhatsNew42.nb", CopyTag -> "S0.0.4"],
                Item["System Interface", "WhatsNew42.nb", CopyTag -> "S0.0.5"],
                Item["Add-ons", "WhatsNew42.nb", CopyTag -> "S0.0.6"]
              }
            ],
            BrowserCategory["Version 4.1", None, 
              {
                Item["Numerical Computation", "WhatsNew41.nb", CopyTag -> "S0.0.2"],
                Item["Algebraic Computation", "WhatsNew41.nb", CopyTag -> "S0.0.3"],
                Item["Graphics", "WhatsNew41.nb", CopyTag -> "S0.0.4"],
                Item["Programming and Core System", "WhatsNew41.nb", CopyTag -> "S0.0.5"],
                Item["Input and Output", "WhatsNew41.nb", CopyTag -> "S0.0.6"],
                Item["Notebook Interface", "WhatsNew41.nb", CopyTag -> "S0.0.7"],
                Item["System Interface", "WhatsNew41.nb", CopyTag -> "S0.0.8"]
              }
            ],
            BrowserCategory["Version 4.0", None, 
              {
                Item["Numerical Computation", "WhatsNew40.nb", CopyTag -> "S0.0.2"],
                Item["Algebraic Computation", "WhatsNew40.nb", CopyTag -> "S0.0.3"],
                Item["Mathematical Functions", "WhatsNew40.nb", CopyTag -> "S0.0.4"],
                Item["Graphics", "WhatsNew40.nb", CopyTag -> "S0.0.5"],
                Item["Programming and Core System", "WhatsNew40.nb", CopyTag -> "S0.0.6"],
                Item["Input and Output", "WhatsNew40.nb", CopyTag -> "S0.0.7"],
                Item["Notebook Interface", "WhatsNew40.nb", CopyTag -> "S0.0.8"],
                Item["System Interface", "WhatsNew40.nb", CopyTag -> "S0.0.9"],
                Item["Standard Add-on Packages", "WhatsNew40.nb", CopyTag -> "S0.0.10"]
              }
            ]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Numerical Computation", None, 
          {
            Item["ContinuedFraction", "RefGuide.nb"],
            Item["FromContinuedFraction", "RefGuide.nb"],
            Item["RealDigits (modified)", "RefGuide.nb", IndexTag -> "RealDigits"],
            Item["MantissaExponent (modified)", "RefGuide.nb", IndexTag -> "MantissaExponent"]
          }
        ],
        BrowserCategory["Algebraic Computation", None, 
          {
            Item["Simplify (modified)", "RefGuide.nb", IndexTag -> "Simplify"],
            Item["FullSimplify (modified)", "RefGuide.nb", IndexTag -> "FullSimplify"],
            Item["FunctionExpand (modified)", "RefGuide.nb", IndexTag -> "FunctionExpand"],
            Item[Delimiter],
            Item["Element", "RefGuide.nb"],
            Item["Integers", "RefGuide.nb"],
            Item["Reals", "RefGuide.nb"],
            Item["Complexes", "RefGuide.nb"],
            Item["Algebraics", "RefGuide.nb"],
            Item["Rationals", "RefGuide.nb"],
            Item["Primes", "RefGuide.nb"],
            Item["Booleans", "RefGuide.nb"],
            Item[Delimiter],
            Item["LaplaceTransform", "RefGuide.nb"],
            Item["FourierTransform", "RefGuide.nb"],
            Item["FourierSinTransform", "RefGuide.nb"],
            Item["FourierCosTransform", "RefGuide.nb"],
            Item["ZTransform", "RefGuide.nb"],
            Item[Delimiter],
            Item["InverseLaplaceTransform", "RefGuide.nb"],
            Item["InverseFourierTransform", "RefGuide.nb"],
            Item["InverseFourierSinTransform", "RefGuide.nb"],
            Item["InverseFourierCosTransform", "RefGuide.nb"],
            Item["InverseZTransform", "RefGuide.nb"],
            Item[Delimiter],
            Item["Subresultants", "RefGuide.nb"],
            Item["TransformationFunctions", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Mathematical Functions", None, 
          {
            Item["Khinchin", "RefGuide.nb"],
            Item["Glaisher", "RefGuide.nb"],
            Item["HarmonicNumber", "RefGuide.nb"],
            Item[Delimiter],
            Item["Mod (modified)", "RefGuide.nb", IndexTag -> "Mod"],
            Item["Quotient (modified)", "RefGuide.nb", IndexTag -> "Quotient"],
            Item["IntegerExponent", "RefGuide.nb"],
            Item["MultiplicativeOrder", "RefGuide.nb"],
            Item["CarmichaelLambda", "RefGuide.nb"],
            Item["DigitCount", "RefGuide.nb"],
            Item["BitAnd", "RefGuide.nb"],
            Item["BitOr", "RefGuide.nb"],
            Item["BitXor", "RefGuide.nb"],
            Item["BitNot", "RefGuide.nb"],
            Item[Delimiter],
            Item["PolyLog (modified)", "RefGuide.nb", IndexTag -> "PolyLog"],
            Item["StruveH", "RefGuide.nb"],
            Item["StruveL", "RefGuide.nb"],
            Item["AppellF1", "RefGuide.nb"],
            Item[Delimiter],
            Item["DiracDelta", "RefGuide.nb"],
            Item["DiscreteDelta", "RefGuide.nb"],
            Item["KroneckerDelta", "RefGuide.nb"],
            Item["UnitStep", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Lists and Matrices", None, 
          {
            Item["Part (modified)", "RefGuide.nb", IndexTag -> "Part"],
            Item["Take (modified)", "RefGuide.nb", IndexTag -> "Take"],
            Item["Drop (modified)", "RefGuide.nb", IndexTag -> "Drop"],
            Item["Partition (modified)", "RefGuide.nb", IndexTag -> "Partition"],
            Item["PadLeft", "RefGuide.nb"],
            Item["PadRight", "RefGuide.nb"],
            Item["Ordering (4.1)", "RefGuide.nb", IndexTag -> "Ordering"],
            Item[Delimiter],
            Item["Minors (modified)", "RefGuide.nb", IndexTag -> "Minors"],
            Item["Tr", "RefGuide.nb"],
            Item["ListConvolve", "RefGuide.nb"],
            Item["ListCorrelate", "RefGuide.nb"],
            Item["CellularAutomaton (4.2)", "RefGuide.nb", IndexTag -> "CellularAutomaton"]
          }
        ],
        BrowserCategory["Graphics and Sound", None, 
          {
            Item["AbsoluteOptions", "RefGuide.nb"],
            Item["ColorFunctionScaling", "RefGuide.nb"],
            Item["Raster (modified)", "RefGuide.nb", IndexTag -> "Raster"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Programming", None, 
          {
            Item["Apply (modified)", "RefGuide.nb", IndexTag -> "Apply"],
            Item["NestWhile", "RefGuide.nb"],
            Item["NestWhileList", "RefGuide.nb"],
            Item["StringTake (modified)", "RefGuide.nb", IndexTag -> "StringTake"],
            Item["StringDrop (modified)", "RefGuide.nb", IndexTag -> "StringDrop"],
            Item["Nand (4.1)", "RefGuide.nb", IndexTag -> "Nand"]
          }
        ],
        BrowserCategory["Input and Output", None, 
          {
            Item["Import", "RefGuide.nb"],
            Item["Export", "RefGuide.nb"],
            Item["ImportString", "RefGuide.nb"],
            Item["ExportString", "RefGuide.nb"],
            Item[Delimiter],
            Item["ShowCursorTracker", "RefGuide.nb"],
            Item["ShowAutoStyles", "RefGuide.nb"],
            Item["InputAliases", "RefGuide.nb"],
            Item["InputAutoReplacements", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Notebooks", None, 
          {
            Item["Hyphenation", "RefGuide.nb"],
            Item["LanguageCategory", "RefGuide.nb"],
            Item["ShowSelection", "RefGuide.nb"]
          }
        ],
        BrowserCategory["System Interface", None, 
          {
            Item["Path", "RefGuide.nb"],
            Item["$ImportFormats", "RefGuide.nb"],
            Item["$ExportFormats", "RefGuide.nb"],
            Item["$ByteOrdering", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Obsolete in Version 4", None, 
          {
            Item["FullOptions", "Obsolete.nb", CopyTag -> None]
          }
        ]
      }
    ],
    BrowserCategory["New in Version 3.x", None, 
      {
        BrowserCategory["Highlights", None, 
          {
            Item["Numerical Computation", "WhatsNew30.nb", CopyTag -> "S0.0.2"],
            Item["Algebraic Computation", "WhatsNew30.nb", CopyTag -> "S0.0.3"],
            Item["Mathematical Functions", "WhatsNew30.nb", CopyTag -> "S0.0.4"],
            Item["Graphics", "WhatsNew30.nb", CopyTag -> "S0.0.5"],
            Item["Programming and Core System", "WhatsNew30.nb", CopyTag -> "S0.0.6"],
            Item["Input and Output", "WhatsNew30.nb", CopyTag -> "S0.0.7"],
            Item["Notebook Interface", "WhatsNew30.nb", CopyTag -> "S0.0.8"],
            Item["System Interface", "WhatsNew30.nb", CopyTag -> "S0.0.9"],
            Item["Standard Add-on Packages", "WhatsNew30.nb", CopyTag -> "S0.0.10"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Numerical Computation", None, 
          {
            Item["N (modified)", "RefGuide.nb", IndexTag -> {"N"}],
            Item["NumericQ", "RefGuide.nb"],
            Item["NumericFunction", "RefGuide.nb"],
            Item[Delimiter],
            Item["Compile (modified)", "RefGuide.nb", IndexTag -> {"Compile"}],
            Item[Delimiter],
            Item["NDSolve (modified)", "RefGuide.nb", IndexTag -> {"NDSolve"}],
            Item["ListInterpolation", "RefGuide.nb"],
            Item["FunctionInterpolation", "RefGuide.nb"],
            Item[Delimiter],
            Item["IntegerDigits (modified)", "RefGuide.nb", IndexTag -> {"IntegerDigits"}],
            Item["RealDigits (modified)", "RefGuide.nb", IndexTag -> {"RealDigits"}],
            Item["FromDigits", "RefGuide.nb"],
            Item["IntegerPart", "RefGuide.nb"],
            Item["FractionalPart", "RefGuide.nb"],
            Item["NonPositive", "RefGuide.nb"],
            Item[Delimiter],
            Item["Interval", "RefGuide.nb"],
            Item["IntervalMemberQ", "RefGuide.nb"],
            Item["IntervalUnion", "RefGuide.nb"],
            Item["IntervalIntersection", "RefGuide.nb"],
            Item[Delimiter],
            Item["$MaxExtraPrecision", "RefGuide.nb"],
            Item["NumberMarks", "RefGuide.nb"],
            Item["$MaxPrecision", "RefGuide.nb"],
            Item["$MinPrecision", "RefGuide.nb"],
            Item["$MaxNumber", "RefGuide.nb"],
            Item["$MinNumber", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Algebraic Computation", None, 
          {
            Item["Simplify (modified)", "RefGuide.nb", IndexTag -> {"Simplify"}],
            Item["FullSimplify", "RefGuide.nb"],
            Item["FunctionExpand", "RefGuide.nb"],
            Item[Delimiter],
            Item["Root", "RefGuide.nb"],
            Item["RootSum", "RefGuide.nb"],
            Item["RootReduce", "RefGuide.nb"],
            Item["ToRadicals", "RefGuide.nb"],
            Item["Extension", "RefGuide.nb"],
            Item["Factor (modified)", "RefGuide.nb", IndexTag -> {"Factor"}],
            Item["GroebnerBasis (modified)", "RefGuide.nb", IndexTag -> {"GroebnerBasis"}],
            Item["PolynomialReduce", "RefGuide.nb"],
            Item[Delimiter],
            Item["Integrate (modified)", "RefGuide.nb", IndexTag -> {"Integrate"}],
            Item["DSolve (modified)", "RefGuide.nb", IndexTag -> {"DSolve"}],
            Item["Sum (modified)", "RefGuide.nb", IndexTag -> {"Sum"}],
            Item["Product (modified)", "RefGuide.nb", IndexTag -> {"Product"}],
            Item["Assumptions", "RefGuide.nb"],
            Item["GenerateConditions", "RefGuide.nb"],
            Item["PrincipalValue", "RefGuide.nb"],
            Item[Delimiter],
            Item["Coefficient (modified)", "RefGuide.nb", IndexTag -> {"Coefficient"}],
            Item["SeriesCoefficient", "RefGuide.nb"],
            Item["ComposeSeries", "RefGuide.nb"],
            Item[Delimiter],
            Item["TrigExpand", "RefGuide.nb"],
            Item["TrigFactor", "RefGuide.nb"],
            Item["TrigFactorList", "RefGuide.nb"],
            Item["TrigReduce", "RefGuide.nb"],
            Item["TrigToExp", "RefGuide.nb"],
            Item["ExpToTrig", "RefGuide.nb"],
            Item[Delimiter],
            Item["ExcludedForms", "RefGuide.nb"],
            Item["TransformationFunctions", "RefGuide.nb"],
            Item["ComplexityFunction", "RefGuide.nb"],
            Item["TimeConstraint", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Mathematical Functions", None, 
          {
            Item["FresnelS", "RefGuide.nb"],
            Item["FresnelC", "RefGuide.nb"],
            Item["SinhIntegral", "RefGuide.nb"],
            Item["CoshIntegral", "RefGuide.nb"],
            Item["ProductLog", "RefGuide.nb"],
            Item["Erfi", "RefGuide.nb"],
            Item[Delimiter],
            Item["InverseErf", "RefGuide.nb"],
            Item["InverseErfc", "RefGuide.nb"],
            Item["InverseGammaRegularized", "RefGuide.nb"],
            Item["InverseBetaRegularized", "RefGuide.nb"],
            Item[Delimiter],
            Item["Hypergeometric0F1Regularized", "RefGuide.nb"],
            Item["Hypergeometric1F1Regularized", "RefGuide.nb"],
            Item["Hypergeometric2F1Regularized", "RefGuide.nb"],
            Item["HypergeometricPFQ", "RefGuide.nb"],
            Item["HypergeometricPFQRegularized", "RefGuide.nb"],
            Item["MeijerG", "RefGuide.nb"],
            Item[Delimiter],
            Item["EllipticNomeQ", "RefGuide.nb"],
            Item["InverseEllipticNomeQ", "RefGuide.nb"],
            Item["WeierstrassInvariants", "RefGuide.nb"],
            Item["WeierstrassHalfPeriods", "RefGuide.nb"],
            Item["InverseWeierstrassP", "RefGuide.nb"],
            Item["WeierstrassSigma", "RefGuide.nb"],
            Item["WeierstrassZeta", "RefGuide.nb"],
            Item[Delimiter],
            Item["EllipticThetaPrime", "RefGuide.nb"],
            Item["DedekindEta", "RefGuide.nb"],
            Item["KleinInvariantJ", "RefGuide.nb"],
            Item["ModularLambda", "RefGuide.nb"],
            Item[Delimiter],
            Item["MathieuS", "RefGuide.nb"],
            Item["MathieuC", "RefGuide.nb"],
            Item["MathieuSPrime", "RefGuide.nb"],
            Item["MathieuCPrime", "RefGuide.nb"],
            Item["MathieuCharacteristicA", "RefGuide.nb"],
            Item["MathieuCharacteristicB", "RefGuide.nb"],
            Item["MathieuCharacteristicExponent", "RefGuide.nb"],
            Item[Delimiter],
            Item["StieltjesGamma", "RefGuide.nb"],
            Item["Fibonacci", "RefGuide.nb"],
            Item[Delimiter],
            Item["$RandomState", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Lists and Matrices", None, 
          {
            Item["Split", "RefGuide.nb"],
            Item["Extract", "RefGuide.nb"],
            Item["Sequence", "RefGuide.nb"],
            Item[Delimiter],
            Item["Cross", "RefGuide.nb"],
            Item["Outer (modified)", "RefGuide.nb", IndexTag -> {"Outer"}],
            Item["ReplacePart (modified)", "RefGuide.nb", IndexTag -> {"ReplacePart"}],
            Item[Delimiter],
            Item["LUDecomposition", "RefGuide.nb"],
            Item["JordanDecomposition", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Graphics and Sound", None, 
          {
            Item["Display (modified)", "RefGuide.nb", IndexTag -> {"Display"}],
            Item["DisplayString", "RefGuide.nb"],
            Item["SelectionAnimate", "RefGuide.nb"],
            Item[Delimiter],
            Item["Offset", "RefGuide.nb"],
            Item["TextStyle", "RefGuide.nb"],
            Item["StyleForm", "RefGuide.nb"],
            Item[Delimiter],
            Item["ImageSize", "RefGuide.nb"],
            Item["ImageResolution", "RefGuide.nb"],
            Item["ImageMargins", "RefGuide.nb"],
            Item["ImageRotated", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Programming", None, 
          {
            Item["ReplaceList", "RefGuide.nb"],
            Item["Throw (modified)", "RefGuide.nb", IndexTag -> {"Throw"}],
            Item["Catch (modified)", "RefGuide.nb", IndexTag -> {"Catch"}],
            Item[Delimiter],
            Item["Symbol (modified)", "RefGuide.nb", IndexTag -> {"Symbol"}],
            Item["SymbolName", "RefGuide.nb"],
            Item[Delimiter],
            Item["StringReplacePart", "RefGuide.nb"],
            Item["StringInsert (modified)", "RefGuide.nb", IndexTag -> {"StringInsert"}],
            Item["ToCharacterCode (modified)", "RefGuide.nb", IndexTag -> {"ToCharacterCode"}],
            Item["FromCharacterCode (modified)", "RefGuide.nb", IndexTag -> {"FromCharacterCode"}],
            Item["CharacterRange", "RefGuide.nb"],
            Item["ToExpression (modified)", "RefGuide.nb", IndexTag -> {"ToExpression"}],
            Item[Delimiter],
            Item["Verbatim", "RefGuide.nb"],
            Item["HoldPattern", "RefGuide.nb"],
            Item["HoldComplete", "RefGuide.nb"],
            Item["HoldAllComplete", "RefGuide.nb"],
            Item["SequenceHold", "RefGuide.nb"],
            Item["NHoldFirst", "RefGuide.nb"],
            Item["NHoldRest", "RefGuide.nb"],
            Item["NHoldAll", "RefGuide.nb"],
            Item[Delimiter],
            Item["Compile (modified)", "RefGuide.nb", IndexTag -> {"Compile"}]
          }
        ],
        BrowserCategory["Input and Output", None, 
          {
            Item["HTMLSave", "RefGuide.nb"],
            Item[Delimiter],
            Item["StandardForm", "RefGuide.nb"],
            Item["TraditionalForm", "RefGuide.nb"],
            Item["DisplayForm", "RefGuide.nb"],
            Item[Delimiter],
            Item["StylePrint", "RefGuide.nb"],
            Item[Delimiter],
            Item["RowBox", "RefGuide.nb"],
            Item["GridBox", "RefGuide.nb"],
            Item["SuperscriptBox (\\^)", "RefGuide.nb", IndexTag -> {"SuperscriptBox", "\\^"}],
            Item["SubscriptBox (\\_)", "RefGuide.nb", IndexTag -> {"SubscriptBox", "\\_"}],
            Item["SubsuperscriptBox", "RefGuide.nb"],
            Item["OverscriptBox (\\&)", "RefGuide.nb", IndexTag -> {"OverscriptBox", "\\&"}],
            Item["UnderscriptBox (\\+)", "RefGuide.nb", IndexTag -> {"UnderscriptBox", "\\+"}],
            Item["UnderoverscriptBox", "RefGuide.nb"],
            Item["FractionBox (\\/)", "RefGuide.nb", IndexTag -> {"FractionBox", "\\/"}],
            Item["SqrtBox (\\@)", "RefGuide.nb", IndexTag -> {"SqrtBox", "\\@"}],
            Item["RadicalBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["StyleBox", "RefGuide.nb"],
            Item["FrameBox", "RefGuide.nb"],
            Item["AdjustmentBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["ButtonBox", "RefGuide.nb"],
            Item["FormBox (\\`)", "RefGuide.nb", IndexTag -> {"FormBox", "\\`"}],
            Item["InterpretationBox", "RefGuide.nb"],
            Item["TagBox", "RefGuide.nb"],
            Item["ErrorBox", "RefGuide.nb"],
            Item[Delimiter],
            Item["ToBoxes", "RefGuide.nb"],
            Item["MakeBoxes", "RefGuide.nb"],
            Item["MakeExpression", "RefGuide.nb"],
            Item[Delimiter],
            Item["CharacterEncoding", "RefGuide.nb"],
            Item["$CharacterEncoding", "RefGuide.nb"],
            Item["NumberMarks", "RefGuide.nb"],
            Item["$NumberMarks", "RefGuide.nb"],
            Item["NumberMultiplier", "RefGuide.nb"],
            Item[Delimiter],
            Item["StyleForm", "RefGuide.nb"],
            Item["$TextStyle", "RefGuide.nb"],
            Item["$FormatType", "RefGuide.nb"],
            Item[Delimiter],
            Item["ColumnAlignments", "RefGuide.nb"],
            Item["RowAlignments", "RefGuide.nb"],
            Item["ColumnSpacings", "RefGuide.nb"],
            Item["RowSpacings", "RefGuide.nb"],
            Item["ColumnsEqual", "RefGuide.nb"],
            Item["RowsEqual", "RefGuide.nb"],
            Item["ColumnWidths", "RefGuide.nb"],
            Item["RowMinHeight", "RefGuide.nb"],
            Item["GridBaseline", "RefGuide.nb"],
            Item["ColumnLines", "RefGuide.nb"],
            Item["RowLines", "RefGuide.nb"],
            Item["GridDefaultElement", "RefGuide.nb"],
            Item[Delimiter],
            Item["ButtonStyle", "RefGuide.nb"],
            Item["ButtonFrame", "RefGuide.nb"],
            Item["ButtonExpandable", "RefGuide.nb"],
            Item["ButtonMargins", "RefGuide.nb"],
            Item["ButtonMinHeight", "RefGuide.nb"],
            Item[Delimiter],
            Item["ScriptSizeMultipliers", "RefGuide.nb"],
            Item["ScriptMinSize", "RefGuide.nb"],
            Item["ScriptBaselineShifts", "RefGuide.nb"],
            Item["LimitsPositioning", "RefGuide.nb"],
            Item[Delimiter],
            Item["Editable", "RefGuide.nb"],
            Item[Delimiter],
            Item["Skeleton", "RefGuide.nb"]
          }
        ],
        BrowserCategory["Notebooks", None, 
          {
            Item["Cell", "RefGuide.nb"],
            Item["Notebook", "RefGuide.nb"],
            Item["CellGroupData", "RefGuide.nb"],
            Item["Notebooks", "RefGuide.nb"],
            Item["SelectedNotebook", "RefGuide.nb"],
            Item["EvaluationNotebook", "RefGuide.nb"],
            Item["InputNotebook", "RefGuide.nb"],
            Item["ButtonNotebook", "RefGuide.nb"],
            Item["NotebookObject", "RefGuide.nb"],
            Item["NotebookSelection", "RefGuide.nb"],
            Item[Delimiter],
            Item["NotebookGet", "RefGuide.nb"],
            Item["NotebookPut", "RefGuide.nb"],
            Item["NotebookCreate", "RefGuide.nb"],
            Item["NotebookOpen", "RefGuide.nb"],
            Item["NotebookLocate", "RefGuide.nb"],
            Item["NotebookClose", "RefGuide.nb"],
            Item["NotebookSave", "RefGuide.nb"],
            Item["NotebookPrint", "RefGuide.nb"],
            Item["SetSelectedNotebook", "RefGuide.nb"],
            Item["FrontEndExecute", "RefGuide.nb"],
            Item[Delimiter],
            Item["CellPrint", "RefGuide.nb"],
            Item["NotebookApply", "RefGuide.nb"],
            Item["NotebookWrite", "RefGuide.nb"],
            Item["NotebookRead", "RefGuide.nb"],
            Item["NotebookDelete", "RefGuide.nb"],
            Item["NotebookFind", "RefGuide.nb"],
            Item["SelectionMove", "RefGuide.nb"],
            Item["SelectionEvaluate", "RefGuide.nb"],
            Item["SelectionCreateCell", "RefGuide.nb"],
            Item["SelectionEvaluateCreateCell", "RefGuide.nb"],
            Item["SelectionAnimate", "RefGuide.nb"],
            Item[Delimiter],
            Item["ButtonBox", "RefGuide.nb"],
            Item["Active", "RefGuide.nb"],
            Item["ButtonStyle", "RefGuide.nb"],
            Item["ButtonFunction", "RefGuide.nb"],
            Item["ButtonSource", "RefGuide.nb"],
            Item["ButtonData", "RefGuide.nb"],
            Item["ButtonEvaluator", "RefGuide.nb"],
            Item["ButtonNote", "RefGuide.nb"],
            Item[Delimiter],
            Item["CellFrame", "RefGuide.nb"],
            Item["CellDingbat", "RefGuide.nb"],
            Item["Magnification", "RefGuide.nb"],
            Item["ShowCellBracket", "RefGuide.nb"],
            Item["ShowSelection", "RefGuide.nb"],
            Item["CellOpen", "RefGuide.nb"],
            Item["CellMargins", "RefGuide.nb"],
            Item["CellFrameMargins", "RefGuide.nb"],
            Item["CellBaseline", "RefGuide.nb"],
            Item["CellLabel", "RefGuide.nb"],
            Item["ShowCellLabel", "RefGuide.nb"],
            Item["CellLabelAutoDelete", "RefGuide.nb"],
            Item["CellTags", "RefGuide.nb"],
            Item["ShowCellTags", "RefGuide.nb"],
            Item["ConversionRules", "RefGuide.nb"],
            Item["Editable", "RefGuide.nb"],
            Item["Selectable", "RefGuide.nb"],
            Item["Copyable", "RefGuide.nb"],
            Item["Deletable", "RefGuide.nb"],
            Item["Evaluatable", "RefGuide.nb"],
            Item["Active", "RefGuide.nb"],
            Item["CellEditDuplicate", "RefGuide.nb"],
            Item["CellEvaluationDuplicate", "RefGuide.nb"],
            Item["CellAutoOverwrite", "RefGuide.nb"],
            Item["Evaluator", "RefGuide.nb"],
            Item["GeneratedCell", "RefGuide.nb"],
            Item["InitializationCell", "RefGuide.nb"],
            Item["PageBreakAbove", "RefGuide.nb"],
            Item["PageBreakWithin", "RefGuide.nb"],
            Item["PageBreakBelow", "RefGuide.nb"],
            Item["GroupPageBreakWithin", "RefGuide.nb"],
            Item[Delimiter],
            Item["FontSize", "RefGuide.nb"],
            Item["FontWeight", "RefGuide.nb"],
            Item["FontSlant", "RefGuide.nb"],
            Item["FontFamily", "RefGuide.nb"],
            Item["FontTracking", "RefGuide.nb"],
            Item["FontSubstitutions", "RefGuide.nb"],
            Item["FontColor", "RefGuide.nb"],
            Item["Background", "RefGuide.nb"],
            Item["PageWidth", "RefGuide.nb"],
            Item["TextAlignment", "RefGuide.nb"],
            Item["TextJustification", "RefGuide.nb"],
            Item["LineSpacing", "RefGuide.nb"],
            Item["ParagraphSpacing", "RefGuide.nb"],
            Item["ParagraphIndent", "RefGuide.nb"],
            Item["LineIndent", "RefGuide.nb"],
            Item["LineIndentMaxFraction", "RefGuide.nb"],
            Item["AutoSpacing", "RefGuide.nb"],
            Item["AutoItalicWords", "RefGuide.nb"],
            Item["SingleLetterItalics", "RefGuide.nb"],
            Item["ShowStringCharacters", "RefGuide.nb"],
            Item["ShowSpecialCharacters", "RefGuide.nb"],
            Item[Delimiter],
            Item["ImageSize", "RefGuide.nb"],
            Item["ImageMargins", "RefGuide.nb"],
            Item["AspectRatioFixed", "RefGuide.nb"],
            Item["AnimationDisplayTime", "RefGuide.nb"],
            Item["AnimationDirection", "RefGuide.nb"],
            Item[Delimiter],
            Item["WindowSize", "RefGuide.nb"],
            Item["WindowMargins", "RefGuide.nb"],
            Item["WindowFrame", "RefGuide.nb"],
            Item["WindowElements", "RefGuide.nb"],
            Item["WindowTitle", "RefGuide.nb"],
            Item["WindowToolbars", "RefGuide.nb"],
            Item["WindowMovable", "RefGuide.nb"],
            Item["WindowFloating", "RefGuide.nb"],
            Item["WindowClickSelect", "RefGuide.nb"],
            Item["Visible", "RefGuide.nb"],
            Item["Editable", "RefGuide.nb"],
            Item["Selectable", "RefGuide.nb"],
            Item["Deletable", "RefGuide.nb"],
            Item["Background", "RefGuide.nb"],
            Item["Magnification", "RefGuide.nb"],
            Item["PageWidth", "RefGuide.nb"],
            Item["CellGrouping", "RefGuide.nb"],
            Item["ShowPageBreaks", "RefGuide.nb"],
            Item["NotebookAutoSave", "RefGuide.nb"],
            Item["ScreenStyleEnvironment", "RefGuide.nb"],
            Item["PrintingStyleEnvironment", "RefGuide.nb"],
            Item["StyleDefinitions", "RefGuide.nb"],
            Item["DefaultNewCellStyle", "RefGuide.nb"],
            Item["DefaultDuplicateCellStyle", "RefGuide.nb"],
            Item[Delimiter],
            Item["AutoIndent", "RefGuide.nb"],
            Item["DelimiterFlashTime", "RefGuide.nb"],
            Item["DragAndDrop", "RefGuide.nb"],
            Item["StructuredSelection", "RefGuide.nb"]
          }
        ],
        BrowserCategory["System Interface", None, 
          {
            Item["DumpSave", "RefGuide.nb"],
            Item["Get (modified)", "RefGuide.nb", IndexTag -> {"Get"}],
            Item[Delimiter],
            Item["DirectoryName", "RefGuide.nb"],
            Item["ToFileName", "RefGuide.nb"],
            Item["$HomeDirectory", "RefGuide.nb"],
            Item["$InitialDirectory", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinkLaunch", "RefGuide.nb"],
            Item["LinkCreate", "RefGuide.nb"],
            Item["LinkConnect", "RefGuide.nb"],
            Item["LinkClose", "RefGuide.nb"],
            Item[Delimiter],
            Item["LinkWrite", "RefGuide.nb"],
            Item["LinkRead", "RefGuide.nb"],
            Item["LinkInterrupt", "RefGuide.nb"],
            Item[Delimiter],
            Item["Links", "RefGuide.nb"],
            Item["LinkPatterns", "RefGuide.nb"],
            Item["LinkObject", "RefGuide.nb"],
            Item["LinkReadyQ", "RefGuide.nb"],
            Item["LinkProtocol", "RefGuide.nb"],
            Item["$ParentLink", "RefGuide.nb"],
            Item["$CurrentLink", "RefGuide.nb"],
            Item["$FrontEnd", "RefGuide.nb"],
            Item[Delimiter],
            Item["$MachineDomain", "RefGuide.nb"],
            Item["$UserName", "RefGuide.nb"],
            Item["$ProcessID", "RefGuide.nb"],
            Item["$ParentProcessID", "RefGuide.nb"],
            Item["$SystemID", "RefGuide.nb"],
            Item["$SystemCharacterEncoding", "RefGuide.nb"],
            Item["$ProcessorType", "RefGuide.nb"],
            Item["$HistoryLength", "RefGuide.nb"]
          }
        ],
        Item[Delimiter],
        BrowserCategory["Obsolete in Version 3", None, 
          {
            Item["HeldPart", "Obsolete.nb", CopyTag -> None],
            Item["ReplaceHeldPart", "Obsolete.nb", CopyTag -> None],
            Item["ToHeldExpression", "Obsolete.nb", CopyTag -> None],
            Item[Delimiter],
            Item["StringConversion", "Obsolete.nb", CopyTag -> None],
            Item["$StringConversion", "Obsolete.nb", CopyTag -> None],
            Item["$StringOrder", "Obsolete.nb", CopyTag -> None],
            Item["$Letters", "Obsolete.nb", CopyTag -> None],
            Item["StringByteCount", "Obsolete.nb", CopyTag -> None],
            Item[Delimiter],
            Item["DefaultFont", "Obsolete.nb", CopyTag -> None],
            Item["FontForm", "Obsolete.nb", CopyTag -> None],
            Item["Subscripted", "Obsolete.nb", CopyTag -> None],
            Item[Delimiter],
            Item["Dump", "Obsolete.nb", CopyTag -> None],
            Item["HomeDirectory", "Obsolete.nb", CopyTag -> None],
            Item["ContextToFilename", "Obsolete.nb", CopyTag -> None],
            Item["$PipeSupported", "Obsolete.nb", CopyTag -> None],
            Item["$LinkSupported", "Obsolete.nb", CopyTag -> None],
            Item[Delimiter],
            Item["AlgebraicRules", "Obsolete.nb", CopyTag -> None]
          }
        ]
      }
    ],
    Item[Delimiter],
    BrowserCategory["Additional Functions", None, 
      {
        BrowserCategory["Developer Context", None, 
          {
            Item["Introduction", "Developer.nb", CopyTag -> "SA.14.1"],
            Item[Delimiter],
            BrowserCategory["Numerical Computation", None, 
              {
                Item["MachineIntegerQ", "Developer.nb", IndexTag -> "Developer`MachineIntegerQ"],
                Item["BitLength", "Developer.nb", IndexTag -> "Developer`BitLength"],
                Item["BitShiftLeft", "Developer.nb", IndexTag -> "Developer`BitShiftLeft"],
                Item["BitShiftRight", "Developer.nb", IndexTag -> "Developer`BitShiftRight"]
              }
            ],
            BrowserCategory["Algebraic Computation", None, 
              {
                Item["ZeroQ", "Developer.nb", IndexTag -> "Developer`ZeroQ"],
                Item["PolynomialDivision", "Developer.nb", IndexTag -> "Developer`PolynomialDivision"],
                Item[Delimiter],
                Item["TrigToRadicals", "Developer.nb", IndexTag -> "Developer`TrigToRadicals"],
                Item["BesselSimplify", "Developer.nb", IndexTag -> "Developer`BesselSimplify"],
                Item["GammaSimplify", "Developer.nb", IndexTag -> "Developer`GammaSimplify"],
                Item["PolyGammaSimplify", "Developer.nb", IndexTag -> "Developer`PolyGammaSimplify"],
                Item["PolyLogSimplify", "Developer.nb", IndexTag -> "Developer`PolyLogSimplify"],
                Item["ZetaSimplify", "Developer.nb", IndexTag -> "Developer`ZetaSimplify"],
                Item["FibonacciSimplify", "Developer.nb", IndexTag -> "Developer`FibonacciSimplify"]
              }
            ],
            BrowserCategory["Lists and Matrices", None, 
              {
                Item["PartitionMap", "Developer.nb", IndexTag -> "Developer`PartitionMap"],
                Item[Delimiter],
                Item["HermiteNormalForm", "Developer.nb", IndexTag -> "Developer`HermiteNormalForm"],
                Item[Delimiter],
                Item["ToPackedArray", "Developer.nb", IndexTag -> "Developer`ToPackedArray"],
                Item["FromPackedArray", "Developer.nb", IndexTag -> "Developer`FromPackedArray"],
                Item["PackedArrayQ", "Developer.nb", IndexTag -> "Developer`PackedArrayQ"],
                Item["PackedArrayForm", "Developer.nb", IndexTag -> "Developer`PackedArrayForm"]
              }
            ],
            Item[Delimiter],
            BrowserCategory["Programming", None, 
              {
                Item["ReplaceAllUnheld", "Developer.nb", IndexTag -> "Developer`ReplaceAllUnheld"]
              }
            ],
            BrowserCategory["Notebooks", None, 
              {
                Item["ClipboardNotebook", "Developer.nb", IndexTag -> "Developer`ClipboardNotebook"],
                Item["MessagesNotebook", "Developer.nb", IndexTag -> "Developer`MessagesNotebook"],
                Item["HelpBrowserNotebook", "Developer.nb", IndexTag -> "Developer`HelpBrowserNotebook"],
                Item["NotebookInformation", "Developer.nb", IndexTag -> "Developer`NotebookInformation"],
                Item[Delimiter],
                Item["NotebookConvert", "Developer.nb", IndexTag -> "Developer`NotebookConvert"]
              }
            ],
            BrowserCategory["System Interface", None, 
              {
                Item["SystemOptions", "Developer.nb", IndexTag -> "Developer`SystemOptions"],
                Item["SetSystemOptions", "Developer.nb", IndexTag -> "Developer`SetSystemOptions"],
                Item["ClearCache", "Developer.nb", IndexTag -> "Developer`ClearCache"],
                Item[Delimiter],
                Item["FileInformation", "Developer.nb", IndexTag -> "Developer`FileInformation"]
              }
            ]
          }
        ],
        BrowserCategory["Experimental Context", None, 
          {
            Item["Introduction", "Experimental.nb", CopyTag -> "SA.15.1"],
            Item[Delimiter],
            BrowserCategory["Numerical Computation", None, 
              {
                Item["$EqualTolerance", "Experimental.nb", IndexTag -> "Experimental`$EqualTolerance"],
                Item["$SameQTolerance", "Experimental.nb", IndexTag -> "Experimental`$SameQTolerance"]
              }
            ],
            BrowserCategory["Algebraic Computation", None, 
              {
                Item["ImpliesQ", "Experimental.nb", IndexTag -> "Experimental`ImpliesQ"],
                Item["ExistsRealQ", "Experimental.nb", IndexTag -> "Experimental`ExistsRealQ"],
                Item["ForAllRealQ", "Experimental.nb", IndexTag -> "Experimental`ForAllRealQ"],
                Item["ImpliesRealQ", "Experimental.nb", IndexTag -> "Experimental`ImpliesRealQ"]
              }
            ],
            Item[Delimiter],
            BrowserCategory["Programming", None, 
              {
                Item["ValueFunction", "Experimental.nb", IndexTag -> "Experimental`ValueFunction"],
                Item[Delimiter],
                Item["CompileEvaluate", "Experimental.nb", IndexTag -> "Experimental`CompileEvaluate"]
              }
            ],
            BrowserCategory["Notebooks", None, 
              {
                Item["FileBrowse", "Experimental.nb", IndexTag -> "Experimental`FileBrowse"]
              }
            ]
          }
        ]
      }
    ],
    Item[Delimiter],
    HelpDirectoryListing[{FrontEnd`FileName[{"RefGuide", "AdvancedDocumentation"}]}, False],
    Item[Delimiter],
    HelpDirectoryListing[{FrontEnd`FileName[{"RefGuide", "MessageInformation"}]}, False]
  }
]
