(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    358054,      12664]*)
(*NotebookOutlinePosition[    942666,      24872]*)
(*  CellTagsIndexPosition[    923499,      24414]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Algebraic Computation", "Title"],

Cell[CellGroupData[{

Cell["Limit::ldir", "ObjectNameWarningMessages",
  CellTags->"Limit::ldir"],

Cell[BoxData[
    RowBox[{\(Limit::"ldir"\), \(\(:\)\(\ \)\), \(\(\(\(Value\)\(\ \)\(of\)\(\
\ \)\(option\)\(\ \)\(Direction\)\(\ \)\)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ number\ or\ \
\(\(Automatic\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Limit::ldir"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Direction", "MR"],
  " option in ",
  StyleBox["Limit", "MR"],
  " is not a number or ",
  StyleBox["Automatic", "MR"],
  ".\n\[FilledSmallSquare] The default value of the ",
  StyleBox["Direction", "MR"],
  " option is ",
  StyleBox["Automatic", "MR"],
  ", which is equivalent to ",
  StyleBox["Direction->-1", "MR"],
  " for finite limits points."
}], "Notes",
  CellTags->"Limit::ldir"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Limit::ldir"],

Cell[TextData[{
  "The symbol ",
  StyleBox["Negative", "MR"],
  " is not a valid value for the ",
  StyleBox["Direction", "MR"],
  " option in ",
  StyleBox["Limit", "MR"],
  "."
}], "Text",
  CellTags->"Limit::ldir"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[1/x, x -> 0, Direction -> Negative]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Limit::ldir"],

Cell[BoxData[
    \(Limit::"ldir" \(\(:\)\(\ \)\) 
      "Value of option Direction -> \!\(Negative\) should be a number or \
Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Limit::ldir"],

Cell[BoxData[
    \(Limit[1\/x, x \[Rule] 0, Direction \[Rule] Negative]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Limit::ldir"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Direction->1", "MR"],
  " causes the limit point to be approached from the negative side."
}], "Text",
  CellTags->"Limit::ldir"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[1/x, x -> 0, Direction -> 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Limit::ldir"],

Cell[BoxData[
    \(\(-\[Infinity]\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Limit::ldir"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limit::lim", "ObjectNameWarningMessages",
  CellTags->"Limit::lim"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Limit::"lim"\), ":", " ", 
        RowBox[{"Limit", " ", "specification", " ", 
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
          " ", "x"}]}], " ", "->", " ", \(\(x0\)\(.\)\)}]], "Message",
  CellTags->"Limit::lim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in Limit is not a \
rule ",
  StyleBox["x", "TI"],
  StyleBox[" -> ", "MR"],
  StyleBox["x0", "TI"],
  " or when ",
  StyleBox["x", "TI"],
  " is not a valid variable.\n\[FilledSmallSquare] In most examples the \
variable is a symbol.\n\[FilledSmallSquare] The variable can be an expression \
other than a symbol, but it cannot be an expression that would interfere with \
the meaning of the limit, such as a number, a sum, a product, a power, a \
series expansion, or an inequality."
}], "Notes",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Limit::lim"],

Cell[TextData[{
  "The second argument in ",
  StyleBox["Limit", "MR"],
  " is expected to be a rule."
}], "Text",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[x\ Log[x], {x, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Limit::lim"],

Cell[BoxData[
    \(Limit::"lim" \(\(:\)\(\ \)\) 
      "Limit specification \!\(x\) is not of the form x -> x0."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Limit::lim"],

Cell[BoxData[
    \(Limit::"lim" \(\(:\)\(\ \)\) 
      "Limit specification \!\(0\) is not of the form x -> x0."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Limit::lim"],

Cell[BoxData[
    \({Limit[x\ Log[x], x], Limit[x\ Log[x], 0]}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Limit::lim"]
}, Open  ]],

Cell[TextData[{
  "This calculates the limit as ",
  StyleBox["x", "MR"],
  " approaches ",
  StyleBox["0", "MR"],
  "."
}], "Text",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[x\ Log[x], x -> 0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Limit::lim"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Limit::lim"]
}, Open  ]],

Cell["The limit variable cannot be a product.", "Text",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[Sin[2\ x]/x, 2\ x -> 0]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Limit::lim"],

Cell[BoxData[
    \(General::"ivar" \(\(:\)\(\ \)\) 
      "\!\(2\\ x\) is not a valid variable."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Limit::lim"],

Cell[BoxData[
    \(Limit[Sin[2\ x]\/x, 2\ x \[Rule] 0]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Limit::lim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$MaxRootDegree::npi", "ObjectNameWarningMessages",
  CellTags->"$MaxRootDegree::npi"],

Cell[BoxData[
    RowBox[{\($MaxRootDegree::"npi"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(new\)\(\ \)\(value\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(of\ $MaxRootDegree\ is\ not\ a\ positive\ machine - 
        size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  CellTags->"$MaxRootDegree::npi"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set ",
  StyleBox["$MaxRootDegree", "MR"],
  " to a value that does not have the indicated form."
}], "Notes",
  CellTags->"$MaxRootDegree::npi"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$MaxRootDegree::npi"],

Cell[TextData[{
  "The value of ",
  StyleBox["$MaxRootDegree", "MR"],
  " must be positive.  When this error occurs, the value of ",
  StyleBox["$MaxRootDegree", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->"$MaxRootDegree::npi"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MaxRootDegree = 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$MaxRootDegree::npi"],

Cell[BoxData[
    \($MaxRootDegree::"npi" \(\(:\)\(\ \)\) 
      "The new value \!\(0\) of $MaxRootDegree is not a positive machine-size \
integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$MaxRootDegree::npi"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$MaxRootDegree::npi"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LogicalExpand::elist
MainSolve::elist
Roots::elist
ToRules::elist
Solve::elist
Reduce::elist
System`Private`OldReduce::elist
Eliminate::elist
SolveAlways::elist
AlgebraicRules::elist
GroebnerBasis::elist
PolynomialReduce::elist\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"elist\"\>"}], \(\(:\)\(\ \)\), "List", " ", 
      "encountered", " ", "during", " ", "logical", " ", "expansion", " ", 
      "of", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the internal ",
  StyleBox["LogicalExpand", "MR"],
  " function encounters a list rather a combination of equations and logical \
functions."
}], "Notes",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[TextData[{
  "Equations in ",
  StyleBox["ToRules", "MR"],
  " should be entered using ",
  StyleBox["And", "MR"],
  ", rather than as a list."
}], "Text",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToRules[{x == 1, x == 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[BoxData[
    \(ToRules::"elist" \(\(:\)\(\ \)\) 
      "List encountered during logical expansion of \!\({\(\(x \[Equal] \
1\)\), \(\(x \[Equal] 2\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
    "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist", 
    "Reduce::elist", "Roots::elist", "SolveAlways::elist", "Solve::elist", 
    "System`Private`OldReduce::elist", "ToRules::elist"}],

Cell[BoxData[
    \(ToRules[{x \[Equal] 1, x \[Equal] 2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
    "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist", 
    "Reduce::elist", "Roots::elist", "SolveAlways::elist", "Solve::elist", 
    "System`Private`OldReduce::elist", "ToRules::elist"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToRules[x == 1 && x == 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[BoxData[
    \({x \[Rule] 1, x \[Rule] 2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
    "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist", 
    "Reduce::elist", "Roots::elist", "SolveAlways::elist", "Solve::elist", 
    "System`Private`OldReduce::elist", "ToRules::elist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LogicalExpand::eqf
MainSolve::eqf
Roots::eqf
ToRules::eqf
Solve::eqf
Reduce::eqf
Eliminate::eqf
SolveAlways::eqf
AlgebraicRules::eqf
GroebnerBasis::eqf
PolynomialReduce::eqf
Internal`DistributedTermsList::eqf
System`Private`OldReduce::eqf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"eqf\"\>"}], ":", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "well"}], 
        "-", \(formed\ \(\(equation\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be an equation.\n\[FilledSmallSquare] An equation is an expression of the \
form ",
  StyleBox["lhs", "TI"],
  StyleBox["==", "MR"],
  StyleBox["rhs", "TI"],
  " or ",
  StyleBox["Equal[", "MR"],
  StyleBox["lhs", "TI"],
  StyleBox[",", "MR"],
  StyleBox["rhs", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell["A polynomial is not by itself an equation.", "Text",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[x^2 - 5  x + 6, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[BoxData[
    \(Solve::"eqf" \(\(:\)\(\ \)\) 
      "\!\(6 - \(\(5\\ x\)\) + x\^2\) is not a well-formed equation."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}],

Cell[BoxData[
    \(Solve::"eqf" \(\(:\)\(\ \)\) 
      "\!\(6 - \(\(5\\ x\)\) + x\^2\) is not a well-formed equation."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}],

Cell[BoxData[
    \(Solve[6 - 5\ x + x\^2, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}]
}, Open  ]],

Cell["\<\
An equation can be entered by setting this polynomial equal to \
zero.\
\>", "Text",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[x^2 - 5  x + 6 == 0, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[BoxData[
    \({{x \[Rule] 2}, {x \[Rule] 3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce::bdomv", "ObjectNameWarningMessages",
  CellTags->"Reduce::bdomv"],

Cell[BoxData[
    \(Reduce::"bdomv" \(\(:\)\(\ \)\) \(Warning : \ `1`\ is\ not\ a\ valid\ \
domain\ specification . \ 
            Assuming\ it\ is\ a\ variable\ to\ \(\(eliminate\)\(.\)\)\)\)], \
"Message",
  CellTags->"Reduce::bdomv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Reduce::bdomv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce::nsmet", "ObjectNameWarningMessages",
  CellTags->"Reduce::nsmet"],

Cell[BoxData[
    \(Reduce::"nsmet" \(\(:\)\(\ \)\) \(This\ system\ cannot\ be\ solved\ \
with\ the\ methods\ available\ to\ \(\(Reduce\)\(.\)\)\)\)], "Message",
  CellTags->"Reduce::nsmet"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Reduce", "MR"],
  " detects a problem it is not designed to handle."
}], "Notes",
  CellTags->"Reduce::nsmet"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Reduce::nsmet"],

Cell[TextData[{
  "Here is an example of an input that ",
  StyleBox["Reduce", "MR"],
  " is not able to solve."
}], "Text",
  CellTags->"Reduce::nsmet"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[Re[Log[x]] \[Equal] 0, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Reduce::nsmet"],

Cell["\<\
Reduce::nsmet: This system cannot be solved with the methods \
available to
     Reduce.\
\>", "Message",
  CellLabel->"From In[1]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Reduce::nsmet"],

Cell[OutputFormData["\<\
Reduce[Re[Log[x]] == 0, x]\
\>", \
"\<\
Reduce[Re[Log[x]] == 0, x]\
\>"], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Reduce::nsmet"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " is able to handle some closely related examples."
}], "Text",
  CellTags->"Reduce::nsmet"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[Im[Log[x]] \[Equal] 0, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Reduce::nsmet"],

Cell[OutputFormData["\<\
x > 0\
\>", "\<\
x > 0\
\>"], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Reduce::nsmet"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::mdeg", "ObjectNameWarningMessages",
  CellTags->"Root::mdeg"],

Cell[BoxData[
    RowBox[{\(Root::"mdeg"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \)\(degree\)\(\ \
\)\), 
      StyleBox["n",
        "TI"], \(\(\ \)\(\(of\)\(\ \)\(the\)\(\ \)\(input\)\(\ \)\(polynomial\
\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ an\ integer\ between\ 1\ and\ \
\(\($MaxRootDegree\)\(.\)\)\)\)}]], "Message",
  CellTags->"Root::mdeg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Root", "MR"],
  " is used with a polynomial for which the polynomial degree does not have \
the indicated form.\n\[FilledSmallSquare] The limit ",
  StyleBox["$MaxRootDegree", "MR"],
  " on the degree of a polynomial in ",
  StyleBox["Root", "MR"],
  " is included to prevent calculations that would otherwise be prohibitively \
time-consuming."
}], "Notes",
  CellTags->"Root::mdeg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Root::mdeg"],

Cell[TextData[{
  "With the default value of ",
  StyleBox["$MaxRootDegree", "MR"],
  ", this input will generate an error and the root will not be computed."
}], "Text",
  CellTags->"Root::mdeg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[2 + x^1000000, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Root::mdeg"],

Cell[BoxData[
    \(Root::"mdeg" \(\(:\)\(\ \)\) 
      "The degree \!\(1000000\) of the input polynomial \!\(2 + x\^1000000\) \
is not an integer between 1 and $MaxRootDegree."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Root::mdeg"],

Cell[BoxData[
    \(Root[2 + x\^1000000, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Root::mdeg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::npoly", "ObjectNameWarningMessages",
  CellTags->"Root::npoly"],

Cell[BoxData[
    RowBox[{\(Root::"npoly"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(is\)\(\ \)\(not\)\(\ \)\(a\)\(\ \)\(polynomial\)\(\
\ \)\(in\)\(\ \)\)\), 
      StyleBox["var",
        "TI"], "."}]], "Message",
  CellTags->"Root::npoly"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Root", "MR"],
  " is not a polynomial in the indicated variable."
}], "Notes",
  CellTags->"Root::npoly"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Root::npoly"],

Cell[TextData[{
  "The ",
  StyleBox["Root", "MR"],
  " function is intended only for use with univariate polynomials \
(expressions with a single variable and integer exponents)."
}], "Text",
  CellTags->"Root::npoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[2 - Sqrt[x], 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Root::npoly"],

Cell[BoxData[
    \(Root::"npoly" \(\(:\)\(\ \)\) 
      "\!\(2 - \@x\) is not a polynomial in \!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Root::npoly"],

Cell[BoxData[
    \(Root[2 - \@x, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Root::npoly"]
}, Open  ]],

Cell[TextData[{
  "The root of this expression can be computed using ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->"Root::npoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[2 - Sqrt[x] == 0, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Root::npoly"],

Cell[BoxData[
    \({{x \[Rule] 4}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Root::npoly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::nup", "ObjectNameWarningMessages",
  CellTags->"Root::nup"],

Cell[BoxData[
    RowBox[{\(Root::"nup"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ univariate\ \
\(\(polynomial\)\(.\)\)\)\)}]], "Message",
  CellTags->"Root::nup"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression involves more \
than one variable.\n\[FilledSmallSquare] The ",
  StyleBox["Root", "MR"],
  " function is only intended for use with univariate polynomials."
}], "Notes",
  CellTags->"Root::nup"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Root::nup"],

Cell[TextData[{
  "The expression ",
  StyleBox["c+x+x^5", "MR"],
  " is treated as a polynomial in the two variables ",
  StyleBox["c", "MR"],
  " and ",
  StyleBox["x", "MR"],
  "."
}], "Text",
  CellTags->"Root::nup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[c + x + x^5, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Root::nup"],

Cell[BoxData[
    \(Root::"nup" \(\(:\)\(\ \)\) 
      "\!\(c + x + x\^5\) is not a univariate polynomial."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Root::nup"],

Cell[BoxData[
    \(Root[c + x + x\^5, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Root::nup"]
}, Open  ]],

Cell["\<\
You can use a pure function to indicate a univariate polynomial \
with symbolic coefficients.\
\>", "Text",
  CellTags->"Root::nup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[\((c + # + #^5)\)\  &, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Root::nup"],

Cell[BoxData[
    \(Root[c + #1 + #1\^5 &, 1]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Root::nup"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::tdep
MainSolve::tdep
Roots::tdep
Reduce::tdep
System`Private`OldReduce::tdep
Eliminate::tdep
SolveAlways::tdep
AlgebraicRules::tdep
GroebnerBasis::tdep
PolynomialReduce::tdep\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"tdep\"\>"}], \(\(:\)\(\ \)\), \(The\ equations\ appear\ to\
\ involve\ the\ variables\ to\ be\ solved\ for\ in\ an\ essentially\ non - 
        algebraic\ \(\(way\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell[TextData[{
  "\[FilledSmallSquare] This message is generated when the indicated function \
encounters a transcendental equation.\n\[FilledSmallSquare] ",
  StyleBox["Solve", "MR"],
  " and related functions are primarily designed for solving polynomial \
equations and equations that can be readily translated into polynomial \
equations."
}], "Notes",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell["\<\
This transcendental equation cannot be solved by algebraic methods.\
\
\>", "Text",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Sin[x] == Log[x], x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell[BoxData[
    \(Solve::"tdep" \(\(:\)\(\ \)\) 
      "The equations appear to involve the variables to be solved for in an \
essentially non-algebraic way."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
    "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
    "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
    "System`Private`OldReduce::tdep"}],

Cell[BoxData[
    \(Solve[Sin[x] \[Equal] Log[x], x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
    "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
    "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
    "System`Private`OldReduce::tdep"}]
}, Open  ]],

Cell[TextData[{
  "In this example you can use ",
  StyleBox["FindRoot", "MR"],
  " to get a numerical approximation for the solution."
}], "Text",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sin[x]\  == \ Log[x], \ {x, \ 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", "PolynomialReduce::tdep"}],

Cell[BoxData[
    \({x \[Rule] 2.2191071489137495`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
    "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
    "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
    "System`Private`OldReduce::tdep"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::varsrt
PolynomialReduce::varsrt
Internal`DistributedTermsList::varsrt
Internal`GroebnerWalk::varsrt\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", "Internal`GroebnerWalk::varsrt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"varsrt\"\>"}], \(\(:\)\(\ \)\), \(Sorting\ of\ variables\ \
is\ not\ compatible\ with\ the\ given\ term\ \(\(ordering\)\(.\)\)\)}]], \
"Message",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", "Internal`GroebnerWalk::varsrt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by ",
  StyleBox["GroebnerBasis", "MR"],
  " and related functions when the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option is a weight matrix and the value of the ",
  StyleBox["Sort", "MR"],
  " option is ",
  StyleBox["True", "MR"],
  "."
}], "Notes",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", "Internal`GroebnerWalk::varsrt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", "Internal`GroebnerWalk::varsrt"}],

Cell[TextData[{
  "If the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option is a weight matrix, then the value of the ",
  StyleBox["Sort", "MR"],
  " option must be ",
  StyleBox["False", "MR"],
  ".  The default value of the ",
  StyleBox["Sort", "MR"],
  " option is ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", "Internal`GroebnerWalk::varsrt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\ y + y^2, x - y}, {x, y}, 
      MonomialOrder -> {{1, 0}, {0, 1}}, Sort -> True]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", "Internal`GroebnerWalk::varsrt"}],

Cell[BoxData[
    \(GroebnerBasis::"varsrt" \(\(:\)\(\ \)\) 
      "Sorting of variables is not compatible with the given term \
ordering."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}],

Cell[BoxData[
    \({y\^2, x - y}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PolynomialMod::polym", "ObjectNameWarningMessages",
  CellTags->"PolynomialMod::polym"],

Cell[BoxData[
    RowBox[{\(PolynomialMod::"polym"\), \(\(:\)\(\ \)\), \(\(Modulus\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ \(\(integer\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"PolynomialMod::polym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["PolynomialMod", "MR"],
  " includes a modulus that is a number other than integer."
}], "Notes",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PolynomialMod::polym"],

Cell[TextData[{
  "This input generates an error because ",
  StyleBox["7.5", "MR"],
  " is not an integer."
}], "Text",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialMod[11\  + \ 37\ x, \ 7.5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PolynomialMod::polym"],

Cell[BoxData[
    \(PolynomialMod::"polym" \(\(:\)\(\ \)\) 
      "Modulus \!\(15\/2\) is not a positive integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PolynomialMod::polym"],

Cell[BoxData[
    \(PolynomialMod[11 + 37\ x, 7.5`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PolynomialMod::polym"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["PolynomialMod", "MR"],
  "."
}], "Text",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialMod[11 + 37  x, 7]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PolynomialMod::polym"],

Cell[BoxData[
    \(4 + 2\ x\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PolynomialMod::polym"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Mod", "MR"],
  " to reduce coefficients modulo a non-integer modulus."
}], "Text",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Mod[CoefficientList[11 + 37  x, x], 7.5]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"PolynomialMod::polym"],

Cell[BoxData[
    \({3.5`, 7.`}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"PolynomialMod::polym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::sbr", "ObjectNameWarningMessages",
  CellTags->"Root::sbr"],

Cell[BoxData[
    RowBox[{\(Root::"sbr"\), \(\(:\)\(\ \)\), \(Because\ of\ branch\ cuts, \ \
\(\(the\)\(\ \)\(series\)\(\ \)\(may\)\(\ \)\(represent\)\(\ \)\(a\)\(\ \
\)\(different\)\(\ \)\(root\)\(\ \)\(of\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], " ", "for", " ", "some", " ", "values", " ", "of", " ", 
      RowBox[{
        StyleBox["x",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Root::sbr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by series expansions of ",
  StyleBox["Root", "MR"],
  " expressions."
}], "Notes",
  CellTags->"Root::sbr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Root::sbr"],

Cell["\<\
A warning message is generated in this example because the series \
expansion may correspond to a root other than the root specified in the \
input.\
\>", "Text",
  CellTags->"Root::sbr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Root[x^3 + \ 1 + y^2, x, 2], {y, 0, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Root::sbr"],

Cell[BoxData[
    \(Root::"sbr" \(\(:\)\(\ \)\) 
      "Because of branch cuts, the series may represent a different root of \
\!\(\(\(1 + y\^2 + #1\^3\)\) &\) for some values of \!\(y\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Root::sbr"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(1\/2\ \((1 - \[ImaginaryI]\ \@3)\)\), 
        "-", \(\(4\ y\^2\)\/\(3\ \((1 - \[ImaginaryI]\ \@3)\)\^2\)\), "+", 
        InterpretationBox[\(O[y]\^3\),
          SeriesData[ y, 0, {}, 0, 3, 1],
          Editable->False]}],
      SeriesData[ y, 0, {
        Times[ 
          Rational[ 1, 2], 
          Plus[ 1, 
            Times[ 
              Complex[ 0, -1], 
              Power[ 3, 
                Rational[ 1, 2]]]]], 0, 
        Times[ 
          Rational[ -4, 3], 
          Power[ 
            Plus[ 1, 
              Times[ 
                Complex[ 0, -1], 
                Power[ 3, 
                  Rational[ 1, 2]]]], -2]]}, 0, 3, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Root::sbr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AlgebraicRules::algdat", "ObjectNameWarningMessages",
  CellTags->"AlgebraicRules::algdat"],

Cell[BoxData[
    RowBox[{\(AlgebraicRules::"algdat"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ AlgebraicRules\ object\ obtained\ \
from\ \(\(AlgebraicRules\)\(.\)\)\)\)}]], "Message",
  CellTags->"AlgebraicRules::algdat"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated ",
  StyleBox["AlgebraicRules", "MR"],
  " expression is not valid.\n\[FilledSmallSquare] A valid ",
  StyleBox["AlgebraicRulesData", "MR"],
  " expression can only be generated by ",
  StyleBox["AlgebraicRules", "MR"],
  " or by ",
  StyleBox["Solve", "MR"],
  " and related functions with the ",
  StyleBox["MakeRules->True", "MR"],
  " option.  A valid ",
  StyleBox["AlgebraicRulesData", "MR"],
  " expression cannot be entered directly.\n\[FilledSmallSquare] ",
  StyleBox["AlgebraicRules", "MR"],
  " and ",
  StyleBox["AlgebraicRulesData", "MR"],
  " are not documented in the current version of ",
  StyleBox["Mathematica", "MR"],
  ", and may not be supported in future releases.  These functions have been \
superseded by ",
  StyleBox["GroebnerBasis", "MR"],
  " and ",
  StyleBox["PolynomialReduce", "MR"],
  "."
}], "Notes",
  CellTags->"AlgebraicRules::algdat"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"AlgebraicRules::algdat"],

Cell[TextData[{
  "An error occurs in this example because the given ",
  StyleBox["AlgebraicRulesData", "MR"],
  " expression is not valid."
}], "Text",
  CellTags->"AlgebraicRules::algdat"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x /. AlgebraicRulesData[x -> y]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"AlgebraicRules::algdat"],

Cell[BoxData[
    \(AlgebraicRules::"algdat" \(\(:\)\(\ \)\) 
      "\!\(AlgebraicRulesData[\(\(x \[Rule] y\)\)]\) is not a valid \
AlgebraicRules object obtained from AlgebraicRules."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"AlgebraicRules::algdat"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"AlgebraicRules::algdat"]
}, Open  ]],

Cell[TextData[{
  "A valid ",
  StyleBox["AlgebraicRulesData", "MR"],
  " expression can be constructed using ",
  StyleBox["AlgebraicRules", "MR"],
  "."
}], "Text",
  CellTags->"AlgebraicRules::algdat"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x /. AlgebraicRules[x == y, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"AlgebraicRules::algdat"],

Cell[BoxData[
    \(y\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"AlgebraicRules::algdat"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AlgebraicRules::newv", "ObjectNameWarningMessages",
  CellTags->"AlgebraicRules::newv"],

Cell[BoxData[
    RowBox[{\(AlgebraicRules::"newv"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "involves", " ", "variables", " ", "not", " ", "among", 
      " ", 
      RowBox[{
        StyleBox["vars",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"AlgebraicRules::newv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an ",
  StyleBox["AlgebraicRulesData", "MR"],
  " expression is used to transform an expression containing variables that \
are not among the variables that were listed when the ",
  StyleBox["AlgebraicRulesData", "MR"],
  " expression was constructed.\n\[FilledSmallSquare] ",
  StyleBox["AlgebraicRules", "MR"],
  " and ",
  StyleBox["AlgebraicRulesData", "MR"],
  " are not documented in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and may not be supported in future releases.  These functions have been \
superseded by ",
  StyleBox["GroebnerBasis", "MR"],
  " and ",
  StyleBox["PolynomialReduce", "MR"],
  "."
}], "Notes",
  CellTags->"AlgebraicRules::newv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"AlgebraicRules::newv"],

Cell[TextData[{
  "A warning is generated in this example because the expression to be \
transformed includes a variable that is not listed in the input to ",
  StyleBox["AlgebraicRules", "MR"],
  "."
}], "Text",
  CellTags->"AlgebraicRules::newv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\ z /. AlgebraicRules[x == y, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"AlgebraicRules::newv"],

Cell[BoxData[
    \(AlgebraicRules::"newv" \(\(:\)\(\ \)\) 
      "\!\(x\\ z\) involves variables not among \!\({x, y}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"AlgebraicRules::newv"],

Cell[BoxData[
    \(y\^2\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"AlgebraicRules::newv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve::incnst", "ObjectNameWarningMessages",
  CellTags->"Solve::incnst"],

Cell[BoxData[
    RowBox[{\(Solve::"incnst"\), \(\(:\)\(\ \)\), \(Inconsistent\ or\ \
redundant\ transcendental\ equation . \ 
          After\ reduction, \ \(\(the\)\(\ \)\(bad\)\(\ \)\(equation\)\(\ \
\)\(is\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(==\)\(\ \)\(0.\)\)\)}]], "Message",
  CellTags->"Solve::incnst"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Solve", "MR"],
  " is used with degenerate transcendental equations or with transcendental \
equations that have no solution."
}], "Notes",
  CellTags->"Solve::incnst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Solve::incnst"],

Cell["\<\
An error is generated in this example because these transcendental \
equations do not have a solution.\
\>", "Text",
  CellTags->"Solve::incnst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{Sin[x + y] == 0, x + y == 1}, {x, y}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Solve::incnst"],

Cell[BoxData[
    \(Solve::"incnst" \(\(:\)\(\ \)\) 
      "Inconsistent or redundant transcendental equation. After reduction, \
the bad equation is \!\(1 - \(\(ArcSin[\(\(Sin[\(\(x + y\)\)]\)\)]\)\)\) == \
0."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Solve::incnst"],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found; use Reduce for complete solution information."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Solve::incnst"],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Solve::incnst"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Solve::incnst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Coefficient::numv
Exponent::numv\
\>", "ObjectNameWarningMessages",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"numv\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "takes", " ", "exactly", " ", "one", 
        " ", \(\(variable\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Coefficient", "MR"],
  " or ",
  StyleBox["Exponent", "MR"],
  " is used with more than one variable.\n\[FilledSmallSquare] Since ",
  StyleBox["Coefficient", "MR"],
  " and ",
  StyleBox["Exponent", "MR"],
  " have the ",
  StyleBox["Listable", "MR"],
  " attribute by default, this message is typically seen only if the ",
  StyleBox["Listable", "MR"],
  " attribute has been cleared or is not used."
}], "Notes",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Exponent", "MR"],
  " is used with more than one variable."
}], "Text",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Exponent[{x}, {x, y}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[BoxData[
    \(Thread::"tdlen" \(\(:\)\(\ \)\) 
      "Objects of unequal length in \!\(Exponent[\(\(\(\({x}\)\), \(\({x, \
y}\)\)\)\)]\) cannot be combined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[BoxData[
    \(Exponent::"numv" \(\(:\)\(\ \)\) 
      "\!\(Exponent\) takes exactly one variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[BoxData[
    \(Exponent[{x}, {x, y}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Coefficient::numv", "Exponent::numv"}]
}, Open  ]],

Cell["\<\
If the arguments have the same length, they are threaded together, \
so only one variable is used at a time.\
\>", "Text",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Exponent[{x, y}, {x, y}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[BoxData[
    \({1, 1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Coefficient::numv", "Exponent::numv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ComplexExpand::exf", "ObjectNameWarningMessages",
  CellTags->"ComplexExpand::exf"],

Cell[BoxData[
    RowBox[{\(ComplexExpand::"exf"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ \
option\ TargetFunctions\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(does\)\(\ \)\(not\)\(\ \)\(contain\)\(\ \
\)\(any\)\(\ \)\(of\)\(\ \)\(the\)\(\ \)\(allowed\)\(\ \)\(functions\)\(\ \
\)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"ComplexExpand::exf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TargetFunctions", "MR"],
  " option in ",
  StyleBox["ComplexExpand", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The value of the \
",
  StyleBox["TargetFunctions", "MR"],
  " option is expected to be ",
  StyleBox["Re", "MR"],
  ", ",
  StyleBox["Im", "MR"],
  ", ",
  StyleBox["Abs", "MR"],
  ", ",
  StyleBox["Arg", "MR"],
  ", ",
  StyleBox["Conjugate", "MR"],
  ", ",
  StyleBox["Sign", "MR"],
  ", or a list containing one or more of these functions."
}], "Notes",
  CellTags->"ComplexExpand::exf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ComplexExpand::exf"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["TargetFunctions", "MR"],
  " option does not contain any of the expected functions."
}], "Text",
  CellTags->"ComplexExpand::exf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComplexExpand[Abs[x + I\ y], TargetFunctions -> {Exp, Log}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"ComplexExpand::exf"],

Cell[BoxData[
    \(ComplexExpand::"exf" \(\(:\)\(\ \)\) 
      "Value of option TargetFunctions -> \!\({Exp, Log}\) does not contain \
any of the allowed functions \!\({Re, Im, Abs, Arg, Conjugate, Sign}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"ComplexExpand::exf"],

Cell[BoxData[
    \(Abs[x + \[ImaginaryI]\ y]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ComplexExpand::exf"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the ",
  StyleBox["TargetFunctions", "MR"],
  " option."
}], "Text",
  CellTags->"ComplexExpand::exf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComplexExpand[Abs[x + I\ y], TargetFunctions -> {Re, Im}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ComplexExpand::exf"],

Cell[BoxData[
    \(\@\(x\^2 + y\^2\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ComplexExpand::exf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["D::dvar", "ObjectNameWarningMessages",
  CellTags->"D::dvar"],

Cell[BoxData[
    \(D::"dvar" \(\(:\)\(\ \)\) 
      "Multiple derivative specifier `1` does not have the form {variable, n} \
where n is a nonnegative machine integer."\)], "Message",
  CellLabel->"From In[27]:=",
  CellTags->"D::dvar"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a list argument in ",
  StyleBox["D", "MR"],
  " has length other than 2.\n\[FilledSmallSquare] List arguments after the \
first argument in ",
  StyleBox["D", "MR"],
  " are assumed to indicate multiple derivatives.\n\[FilledSmallSquare] A \
multiple derivative is specified in ",
  StyleBox["D", "MR"],
  " using a list of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  ", where ",
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  " is the differentiation variable and ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is the number of derivatives."
}], "Notes",
  CellTags->"D::dvar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"D::dvar"],

Cell["\<\
An error occurs in this example because the second argument is a \
list but does not have the proper form to specify a multiple \
derivative.\
\>", "Text",
  CellTags->"D::dvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[Sin[x\ y\ z], {x, x, z}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"D::dvar"],

Cell[BoxData[
    \(D::"dvar" \(\(:\)\(\ \)\) 
      "Multiple derivative specifier \!\({x, x, z}\) does not have the form \
{variable, n} where n is a nonnegative machine integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"D::dvar"],

Cell[BoxData[
    \(\[PartialD]\_{x, x, z}Sin[x\ y\ z]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"D::dvar"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid differentiation specification in ",
  StyleBox["D", "MR"],
  "."
}], "Text",
  CellTags->"D::dvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[Sin[x\ y\ z], {x, 2}, y]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"D::dvar"],

Cell[BoxData[
    \(\(-x\)\ y\^2\ z\^3\ Cos[x\ y\ z] - 2\ y\ z\^2\ Sin[x\ y\ z]\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->"D::dvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::deqn
NDSolve::deqn
RSolve::deqn
NRSolve::deqn\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"deqn\"\>"}], ":", " ", 
      RowBox[{
      "Equation", " ", "or", " ", "list", " ", "of", " ", "equations", " ", 
        "expected", " ", "instead", " ", "of", " ", 
        StyleBox["expr",
          "TI"], " ", "in", " ", "the", " ", "first", " ", "argument", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression from the \
first argument of ",
  StyleBox["DSolve", "MR"],
  " is not an equation.\n\[FilledSmallSquare] The first argument in ",
  StyleBox["DSolve", "MR"],
  " is expected to be an equation or a list of equations.\n\
\[FilledSmallSquare] Equations can be entered using the notation ",
  StyleBox["lhs", "MR",
    FontSlant->"Italic"],
  StyleBox["==", "MR"],
  StyleBox["rhs", "MR",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] The notation ",
  StyleBox["lhs", "MR",
    FontSlant->"Italic"],
  StyleBox["=", "MR"],
  StyleBox["rhs", "MR",
    FontSlant->"Italic"],
  " is used for assignments rather than for equations.  Evaluation of an \
expression of this form will attempt to assign a value to ",
  StyleBox["lhs", "MR",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell["\<\
An error occurs in this example because one of the elements listed \
in the first argument is not an equation.\
\>", "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(f'\)[x] == 1, 1 - f[0]}, f[x], x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[BoxData[
    RowBox[{\(DSolve::"deqn"\), \(\(:\)\(\ \)\), "\<\"Equation or list of \
equations expected instead of \\!\\(1 - \\(\\(f[0]\\)\\)\\) in the first \
argument \\!\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\
\", Rule[MultilineFunction, None]]\\)\\)[x]\\)\\) \[Equal] 1\\)\\), \\(\\(1 - \
\\(\\(f[0]\\)\\)\\)\\)}\\).\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
              "1"}], ",", \(1 - f[0]\)}], "}"}], ",", \(f[x]\), ",", "x"}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid specification of equations in ",
  StyleBox["DSolve", "MR"],
  "."
}], "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(f'\)[x] == 1, 1 - f[0] == 0}, f[x], x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[BoxData[
    \({{f[x] \[Rule] 1 + x}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]],

Cell["\<\
An error occurs in this example because the first argument is not \
an equation or a list.\
\>", "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[1 - \(f'\)[x], f[x], x]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[BoxData[
    RowBox[{\(DSolve::"deqn"\), \(\(:\)\(\ \)\), "\<\"Equation or list of \
equations expected instead of \\!\\(1 - \\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\
\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[x]\\)\\)\\) in the \
first argument \\!\\(1 - \\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \
\\\"\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[x]\\)\\)\\).\"\>"}]], \
"Message",
  CellLabel->"From In[3]:=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"1", "-", 
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], ",", \(f[x]\), ",",
         "x"}], "]"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid input for ",
  StyleBox["DSolve", "MR"],
  "."
}], "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[1 - \(f'\)[x] == 0, f[x], x]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[BoxData[
    \({{f[x] \[Rule] x + C[1]}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::deqx
NDSolve::deqx\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::deqx", "NDSolve::deqx"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"deqx\"\>"}], ":", 
      " ", \(Supplied\ equations\ are\ not\ differential\ equations\ of\ the\ \
given\ \(\(functions\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::deqx", "NDSolve::deqx"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["DSolve", "MR"],
  " or ",
  StyleBox["NDSolve", "MR"],
  " does not recognize the first argument as a valid specification of a \
differential equation."
}], "Notes",
  CellTags->{"DSolve::deqx", "NDSolve::deqx"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RSolve::deqx", "ObjectNameWarningMessages",
  CellTags->"RSolve::deqx"],

Cell[BoxData[
    \(RSolve::"deqx" \(\(:\)\(\ \)\) \(Supplied\ equations\ are\ not\ \
difference\ equations\ of\ the\ given\ \(\(functions\)\(.\)\)\)\)], "Message",\

  CellTags->"RSolve::deqx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["RSolve", "MR"],
  " does not recognize the first argument as a valid specification of a \
differential equation."
}], "Notes",
  CellTags->"RSolve::deqx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"RSolve::deqx"],

Cell[TextData[{
  "An error occurs in this example because the function specified in the \
second argument of ",
  StyleBox["RSolve", "MR"],
  " is not the same as the function used in the equations."
}], "Text",
  CellTags->"RSolve::deqx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RSolve[{f[n] \[Equal] n\ f[n - 1], f[1] == 1}, g[n], n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"RSolve::deqx"],

Cell[BoxData[
    \(RSolve::"deqx" \(\(:\)\(\ \)\) 
      "Supplied equations are not difference equations of the given \
functions."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"RSolve::deqx"],

Cell[BoxData[
    \(RSolve[{f[n] \[Equal] n\ f[\(-1\) + n], f[1] \[Equal] 1}, g[n], 
      n]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"RSolve::deqx"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid input to ",
  StyleBox["RSolve", "MR"],
  "."
}], "Text",
  CellTags->"RSolve::deqx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RSolve[{f[n] \[Equal] n\ f[n - 1], f[1] == 1}, f[n], n]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"RSolve::deqx"],

Cell[BoxData[
    \({{f[n] \[Rule] Gamma[1 + n]}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"RSolve::deqx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::dsmsm
RSolve::dsmsm\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dsmsm\"\>"}], \(\(:\)\(\ \)\), \(Built - 
        in\ routines\ cannot\ solve\ this\ problem . \ 
            There\ is\ an\ equation\ that\ involves\ none\ of\ the\ dependent\
\ variables, \ 
      or\ there\ is\ a\ dependent\ variable\ that\ does\ not\ appear\ in\ any\
\ \(\(equation\)\(.\)\)\)}]], "Message",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the input to ",
  StyleBox["DSolve", "MR"],
  " or ",
  StyleBox["RSolve", "MR"],
  " appears to represent an ill-posed problem."
}], "Notes",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[TextData[{
  "An error occurs in this example because there is no equation for ",
  StyleBox["g[x]", "MR"],
  "."
}], "Text",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(f'\)[x] \[Equal] f[x], \(f'\)[x] \[Equal] 2}, {f[x], g[x]}, 
      x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[BoxData[
    \(DSolve::"dsmsm" \(\(:\)\(\ \)\) 
      "Built-in routines cannot solve this problem. There is an equation that \
involves none of the dependent variables, or there is a dependent variable \
that does not appear in any equation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
              "2"}]}], "}"}], ",", \({f[x], g[x]}\), ",", "x"}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::underdet
NDSolve::underdet
RSolve::underdet
NRSolve::underdet\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"underdet\"\>"}], \(\(:\)\(\ \)\), \(The\ system\ has\ more\
\ dependent\ variables\ than\ equations, \ 
      so\ is\ \(\(underdetermined\)\(.\)\)\)}]], "Message",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell["\<\
\[FilledSmallSquare] Generated when the first argument of the \
indicated function does not include enough equations to specify a solution.\
\
\>", "Notes",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell["\<\
This input will generate a warning message because the apparent \
order of the differential equation is greater than the number of boundary \
conditions.\
\>", "Text",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] \[Equal] \(g'''\)[x], f[1] == 1, 
        f[2] == 2}, f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[BoxData[
    \(NDSolve::"underdet" \(\(:\)\(\ \)\) 
      "The system has more dependent variables than equations, so is \
underdetermined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
    "RSolve::underdet"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(f[x]\), "+", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
              RowBox[{
                SuperscriptBox["g", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], 
            ",", \(f[1] \[Equal] 1\), ",", \(f[2] \[Equal] 2\)}], "}"}], ",", 
        "f", ",", \({x, 1, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
    "RSolve::underdet"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NDSolve", "MR"],
  " to solve a boundary value problem."
}], "Text",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[1] == 1, f[2] == 2}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
    "RSolve::underdet"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::overdet
NDSolve::overdet
RSolve::overdet
NRSolve::overdet\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"overdet\"\>"}], \(\(:\)\(\ \)\), \(The\ system\ has\ fewer\
\ dependent\ variables\ than\ equations, \ 
      so\ is\ \(\(overdetermined\)\(.\)\)\)}]], "Message",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell["\<\
\[FilledSmallSquare] Generated when the first argument of the \
indicated function includes inconsistent equations.\
\>", "Notes",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell["\<\
An error occurs in this example because of conflicting equations \
for f'[x].\
\>", "Text",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(f'\)[x] \[Equal] f[x], \(f'\)[x] \[Equal] 2}, f[x], 
      x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell[BoxData[
    \(DSolve::"overdet" \(\(:\)\(\ \)\) 
      "The system has fewer dependent variables than equations, so is \
overdetermined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
    "RSolve::overdet"}],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
              "2"}]}], "}"}], ",", \(f[x]\), ",", "x"}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
    "RSolve::overdet"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::ivar2
NDSolve::ivar2
RSolve::ivar2
NRSolve::ivar2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ivar2\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "independent", " ", "variable", " ", 
      StyleBox["var",
        "TI"], " ", "should", " ", "not", " ", "appear", " ", "in", " ", 
      "two", " ", "different", " ", "arguments", " ", "of", " ", "the", " ", 
      "dependent", " ", "variable", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::dsfun
NDSolve::dsfun
RSolve::dsfun\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dsfun\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "cannot", " ", "be", " ", "used", " ", "as", " ", "a", 
        " ", \(\(function\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a number or a string is used as the \
name of a function in ",
  StyleBox["DSolve", "MR"],
  " or ",
  StyleBox["NDSolve", "MR"],
  ".\n\[FilledSmallSquare] The function to solve for is given in the second \
argument of ",
  StyleBox["DSolve", "MR"],
  " or ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Notes",
  CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::dsvar
NDSolve::dsvar\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dsvar\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "cannot", " ", "be", " ", "used", " ", "as", " ", "a", 
        " ", \(\(variable\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression cannot be \
used as a variable in ",
  StyleBox["DSolve", "MR"],
  " or ",
  StyleBox["NDSolve", "MR"],
  ".\n\[FilledSmallSquare] Most expressions other than numbers, strings, \
products, sums, and powers can be used as variables.\n\[FilledSmallSquare] \
The variable is specified in the third argument of ",
  StyleBox["DSolve", "MR"],
  " or ",
  StyleBox["NDSolve", "MR"],
  " for ordinary differential equations."
}], "Notes",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell["\<\
An error occurs in this example because a product cannot be used as \
a variable.\
\>", "Text",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[\(f'\)[2  x] == 1, f, 2  x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[BoxData[
    \(DSolve::"dsvar" \(\(:\)\(\ \)\) 
      "\!\(2\\ x\) cannot be used as a variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", \(2\ x\), "]"}], "\[Equal]", 
          "1"}], ",", "f", ",", \(2\ x\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::derlen
NDSolve::derlen\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"derlen\"\>"}], \(\(:\)\(\ \)\), \(The\ length\ of\ the\ \
derivative\ operator\ `1`\ in\ `2`\ is\ not\ the\ same\ as\ the\ number\ of\ \
\(\(arguments\)\(.\)\)\)}]], "Message",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell["\<\
\[FilledSmallSquare] Generated when the number of independent \
variables does not match the number of arguments in the solution function in \
the specification of the equations.\
\>", "Notes",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell["\<\
An error occurs in this example because two variables are specified \
in the third argument, suggesting that the input may represent a partial \
differential equation.\
\>", "Text",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(f'\)[x] == f[x], f[1] == 1}, f, {x, y}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell[BoxData[
    RowBox[{\(DSolve::"derlen"\), \(\(:\)\(\ \)\), "\<\"The length of the \
derivative operator \\!\\(Derivative[1]\\) in \
\\!\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\) is not the same as the number of \
arguments.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[1] \[Equal] 1\)}], "}"}], ",", 
        "f", ",", \({x, y}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DSolve::pde", "ObjectNameWarningMessages",
  CellTags->"DSolve::pde"],

Cell[BoxData[
    \(DSolve::"pde" \(\(:\)\(\ \)\) \(Partial\ differential\ equation\ may\ \
not\ have\ a\ general\ solution . \ 
          Try\ loading\ Calculus`DSolveIntegrals`\ to\ find\ special\ \
\(\(solutions\)\(.\)\)\)\)], "Message",
  CellTags->"DSolve::pde"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the input to ",
  StyleBox["DSolve", "MR"],
  " appears to involve more than one variable.\n\[FilledSmallSquare] The ",
  StyleBox["DSolve", "MR"],
  " function in current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is not designed to solve general partial differential equations.  Partial \
differential equations can be solved numerically using ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Notes",
  CellTags->"DSolve::pde"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::twoivarg
NDSolve::twoivarg
RSolve::twoivarg\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"twoivarg\"\>"}], \(\(:\)\(\ \)\), "\<\"The function `1` \
has two independent variables in one argument. The independent variables \
should be in separate arguments.\"\>"}]], "Message",
  CellLabel->"From In[69]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RSolve::rord", "ObjectNameWarningMessages",
  CellTags->"RSolve::rord"],

Cell[BoxData[
    RowBox[{\(RSolve::"rord"\), ":", " ", 
      RowBox[{"Recurrence", " ", "order", " ", 
        StyleBox["expr",
          "TI"], " ", "of", " ", "equation", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "machine", " ", 
        "sized", " ", \(\(integer\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"RSolve::rord"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RSolve::rord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RSolve::piarg", "ObjectNameWarningMessages",
  CellTags->"RSolve::piarg"],

Cell[BoxData[
    RowBox[{\(RSolve::"piarg"\), ":", " ", 
      RowBox[{
        RowBox[{"An", " ", "argument", " ", "in", " ", "position", " ", 
          StyleBox["expr",
            "TI"], " ", "in", " ", 
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
          " ", 
          StyleBox["expr",
            "TI"]}], " ", "+", " ", 
        RowBox[{"Integer", " ", "or", " ", \(q^Integer\), " ", "*", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"RSolve::piarg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RSolve::piarg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DSolve::pdord", "ObjectNameWarningMessages",
  CellTags->"DSolve::pdord"],

Cell[BoxData[
    RowBox[{\(DSolve::"pdord"\), ":", " ", 
      RowBox[{
      "The", " ", "differential", " ", "order", " ", "of", " ", "functions", 
        " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "0.", " ", "All", " ", "the", " ", 
        "functions", " ", "must", " ", "have", " ", "positive", " ", 
        "differential", " ", \(\(order\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"DSolve::pdord"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the equations do not include \
derivatives of one or more of the functions specified in the second argument \
of ",
  StyleBox["DSolve", "MR"],
  "."
}], "Notes",
  CellTags->"DSolve::pdord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RSolve::pdord", "ObjectNameWarningMessages",
  CellTags->"RSolve::pdord"],

Cell[BoxData[
    RowBox[{\(RSolve::"pdord"\), ":", " ", 
      RowBox[{
      "The", " ", "recurrence", " ", "order", " ", "of", " ", "functions", 
        " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "0.", " ", "All", " ", "the", " ", 
        "functions", " ", "must", " ", "have", " ", "positive", " ", 
        "recurrence", " ", \(\(order\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"RSolve::pdord"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the equations do not include any \
differences for one or more of the functions specified in the second argument \
of R",
  StyleBox["Solve", "MR"],
  "."
}], "Notes",
  CellTags->"RSolve::pdord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::alliv
NDSolve::alliv
RSolve::alliv\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"alliv\"\>"}], ":", " ", 
      RowBox[{"The", " ", "function", " ", 
        StyleBox["expr",
          "TI"], " ", "was", " ", "specified", " ", "without", " ", 
        "dependence", " ", "on", " ", "all", " ", "of", " ", "the", " ", 
        "independent", " ", \(variables . \ Each\), " ", "function", " ", 
        "must", " ", "depend", " ", "on", " ", "all", " ", "of", " ", "the", 
        " ", "independent", " ", \(\(variables\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::baddv
NDSolve::baddv
RSolve::baddv
NRSolve::baddv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"baddv\"\>"}], ":", " ", 
      RowBox[{"The", " ", "dependent", " ", "variable", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "clearly", " ", "specified", " ",
         "in", " ", "the", " ", "form", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::litarg
NDSolve::litarg
RSolve::litarg\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"litarg\"\>"}], \(\(:\)\(\ \)\), "\<\"To avoid possible \
ambiguity, the arguments of the dependent variable in `1` should literally \
match the independent variables.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell["\<\
\[FilledSmallSquare] Generated when the independent variables are \
not specified with consistent names and positions.\
\>", "Notes",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell["\<\
An error occurs in this example because not all of the equations \
for the unknown function are differential equations.\
\>", "Text",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(f'\)[x] == f[x], f[1] == f[x]}, f, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[BoxData[
    RowBox[{\(DSolve::"litarg"\), \(\(:\)\(\ \)\), "\<\"To avoid possible \
ambiguity, the arguments of the dependent variable in \
\\!\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\)\\) \[Equal] \
\\(\\(f[x]\\)\\)\\)\\), \\(\\(\\(\\(f[1]\\)\\) \[Equal] \
\\(\\(f[x]\\)\\)\\)\\)}\\) should literally match the independent \
variables.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[1] \[Equal] f[x]\)}], "}"}], 
        ",", "f", ",", "x"}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]
}, Open  ]],

Cell["\<\
This shows a valid specification of the solution of a differential \
equation.\
\>", "Text",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(f'\)[x] == f[x], f[1] == 1}, f, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[BoxData[
    \({{f \[Rule] 
          Function[{x}, \[ExponentialE]\^\(\(-1\) + x\)]}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]
}, Open  ]],

Cell["\<\
An error occurs in this example because one of the boundary \
conditions is not given directly as a function of the variables.\
\>", "Text",\

  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 2]\)[f]\)[x, 
            t], \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0, f[0, 2  t] == 0, 
        f[1, t] == 0, f[x, 0] == x \((1 - x)\)}, 
      f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[BoxData[
    \(NDSolve::"litarg" \(\(:\)\(\ \)\) 
      "To avoid possible ambiguity, the arguments of the dependent variable \
in \!\(\(\(f[\(\(0, \(\(2\\ t\)\)\)\)]\)\) \[Equal] 0\) should literally \
match the independent variables."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 2)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, 0\), "]"}], "\[Equal]", 
              "0"}], ",", \(f[0, 2\ t] \[Equal] 0\), 
            ",", \(f[1, t] \[Equal] 0\), 
            ",", \(f[x, 0] \[Equal] \((1 - x)\)\ x\)}], "}"}], ",", "f", 
        ",", \({x, 0, 1}\), ",", \({t, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::bvimp
RSolve::bvimp\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bvimp\"\>"}], \(\(:\)\(\ \)\), "\<\"General solution \
contains implicit solutions. In the boundary value problem these solutions \
will be ignored, so some of the solutions will be lost.\"\>"}]], "Message",
  CellLabel->"From In[96]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::bvimp", "RSolve::bvimp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::bvlim
RSolve::bvlim\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bvlim\"\>"}], \(\(:\)\(\ \)\), "\<\"For some branches of \
the general solution, unable to compute the limit at the given points. Some \
of the solutions may be lost.\"\>"}]], "Message",
  CellLabel->"From In[100]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::bvlim", "RSolve::bvlim"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::bvfail
RSolve::bvfail\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bvfail\"\>"}], \(\(:\)\(\ \)\), "\<\"For some branches of \
the general solution, unable to solve the conditions.\"\>"}]], "Message",
  CellLabel->"From In[107]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::bvfail", "RSolve::bvfail"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::bvnul
RSolve::bvnul\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bvnul\"\>"}], \(\(:\)\(\ \)\), "\<\"For some branches of \
the general solution, the given boundary conditions lead to an empty \
solution.\"\>"}]], "Message",
  CellLabel->"From In[114]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell["\<\
\[FilledSmallSquare] Generated when the equations are not complete \
to specify a solution, or are inconsistent.\
\>", "Notes",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["DSolve", "MR"],
  " is unable to find a unique solution that satisfies this differential \
equation with this boundary condition. This particular example actually has \
an infinite number of solutions, but the ",
  StyleBox["DSolve", "MR"],
  " function is not designed to find them."
}], "Text",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ x[0]\  \[Equal] \ 0, \ 
        x[2\ Pi]\  \[Equal] \ 1}, x, t]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[BoxData[
    \(DSolve::"bvnul" \(\(:\)\(\ \)\) 
      "For some branches of the general solution, the given boundary \
conditions lead to an empty solution."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::bvnr
RSolve::bvnr\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bvnr\"\>"}], \(\(:\)\(\ \)\), "\<\"For some branches of \
the general solution, the given boundary conditions does not restrict the \
existing freedom in the general solution.\"\>"}]], "Message",
  CellLabel->"From In[118]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::bvnr", "RSolve::bvnr"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::ifun
Eliminate::ifun
SolveAlways::ifun\
\>", "ObjectNameWarningMessages",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ifun\"\>"}], \(\(:\)\(\ \)\), "\<\"Inverse functions are \
being used by `1`, so some solutions may not be found; use Reduce for \
complete solution information.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Solve", "MR"],
  " and related functions use inverse functions to represent a solution.\n\
\[FilledSmallSquare] Inverse functions normally give one branch of a general \
inverse, so equations that are solved in terms of inverse functions may omit \
solutions associated with other branches."
}], "Notes",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell["\<\
A warning message is generated in this example because the inverse \
function that is used to represent the solution gives only one of the \
solutions to this equation.  This equation has an infinite number of \
solutions.\
\>", "Text",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Sin[x] == b, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found; use Reduce for complete solution information."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],

Cell[BoxData[
    \({{x \[Rule] ArcSin[b]}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}]
}, Open  ]],

Cell[TextData[{
  "Other solutions to this equation can be constructed by adding multiples of \
",
  StyleBox["Pi", "MR"],
  "."
}], "Text",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((Sin[x] == 
          b)\) /. {{x -> ArcSin[b]}, {x -> ArcSin[b] + 2  Pi}, {x -> 
            ArcSin[b] - 8  Pi}}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[BoxData[
    \({True, True, True}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Reduce::ifun
System`Private`OldReduce::ifun
MainSolve::ifun
AlgebraicRules::ifun\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
    "AlgebraicRules::ifun"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ifun\"\>"}], \(\(:\)\(\ \)\), "\<\"Inverse functions are \
being used by `1`, so some solutions may not be found.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
    "AlgebraicRules::ifun"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Reduce", "MR"],
  " and related functions use inverse functions to represent a solution.\n\
\[FilledSmallSquare] Inverse functions normally give one branch of a general \
inverse, so equations that are solved in terms of inverse functions may omit \
solutions associated with other branches."
}], "Notes",
  CellTags->{
  "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
    "AlgebraicRules::ifun"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Factor::facmm", "ObjectNameWarningMessages",
  CellTags->"Factor::facmm"],

Cell[BoxData[
    \(Factor::"facmm" \(\(:\)\(\ \)\) \(Factoring\ multivariate\ polynomials\ \
with\ respect\ to\ a\ modulus\ is\ not\ yet\ implemented; \ 
      using\ FactorSquareFree\ \(\(instead\)\(.\)\)\)\)], "Message",
  CellTags->"Factor::facmm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a non-zero value is used for the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["Factor", "MR"],
  " and the polynomial to be factored includes more than one variable."
}], "Notes",
  CellTags->"Factor::facmm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Factor::facmm"],

Cell[TextData[{
  "A warning message is generated in this example because modular factoring \
of multivariate polynomials is not implemented in this version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"Factor::facmm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[x - x\ y, Modulus -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Factor::facmm"],

Cell[BoxData[
    \(Factor::"facmm" \(\(:\)\(\ \)\) 
      "Factoring multivariate polynomials with respect to a modulus is not \
yet implemented; using FactorSquareFree instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Factor::facmm"],

Cell[BoxData[
    \(x\ \((1 + y)\)\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Factor::facmm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Factor::priml", "ObjectNameWarningMessages",
  CellTags->"Factor::priml"],

Cell[BoxData[
    RowBox[{\(Factor::"priml"\), \(\(:\)\(\ \)\), \(\(Prime\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ too\ large\ for\ this\ \(\(implementation\)\(.\)\
\)\)\)}]], "Message",
  CellTags->"Factor::priml"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["Factor", "MR"],
  " exceeds the largest value supported in this version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] This message is not normally used in the current \
version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " since other messages will be generated and the calculation will fail \
before this message is generated.\n\[FilledSmallSquare] In most versions of \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the largest supported value of the ",
  StyleBox["Modulus", "MR"],
  " option is 46337, which is the largest prime number that is less than the \
square root of the largest machine integer on most computers."
}], "Notes",
  CellTags->"Factor::priml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Factor::ufac
FactorSquareFree::ufac\
\>", "ObjectNameWarningMessages",
  CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ufac\"\>"}], \(\(:\)\(\ \)\), \(Unable\ to\ perform\ the\ \
square - free\ \(\(factorization\)\(.\)\)\)}]], "Message",
  CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],

Cell["\<\
\[FilledSmallSquare] Generated by an internal failure in the \
algorithm used for factoring polynomials.
\[FilledSmallSquare] If you see this message in a situation in which it is \
not expected, please contact Technical Support.\
\>", "Notes",
  CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::mult", "ObjectNameWarningMessages",
  CellTags->"General::mult"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"mult\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Multiplicity\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "positive", 
        " ", \(\(integer\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::mult"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Multiplicity", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] This \
message can be generated by ",
  StyleBox["Roots", "MR"],
  " and by functions such as ",
  StyleBox["Solve", "MR"],
  " that use ",
  StyleBox["Roots", "MR"],
  " internally."
}], "Notes",
  CellTags->"General::mult"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::mult"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Multiplicity", "MR"],
  " option cannot be zero."
}], "Text",
  CellTags->"General::mult"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Roots[x^2 == 5, x, Multiplicity -> 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::mult"],

Cell[BoxData[
    \(Roots::"mult" \(\(:\)\(\ \)\) 
      "Value of option Multiplicity -> \!\(0\) is not a positive \
integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::mult"],

Cell[BoxData[
    \(Roots[x\^2 \[Equal] 5, x, Multiplicity \[Rule] 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::mult"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Multiplicity", "MR"],
  " option in ",
  StyleBox["Roots", "MR"],
  "."
}], "Text",
  CellTags->"General::mult"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Roots[x^2 == 5, x, Multiplicity -> 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::mult"],

Cell[BoxData[
    \(x \[Equal] \@5 || x \[Equal] \@5 || x \[Equal] \@5 || 
      x \[Equal] \(-\@5\) || x \[Equal] \(-\@5\) || 
      x \[Equal] \(-\@5\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::mult"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::modint", "ObjectNameWarningMessages",
  CellTags->"General::modint"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"modint\"\>"}], \(\(:\)\(\ \)\), "Modulus", " ", 
      StyleBox["expr",
        "TI"], " ", "must", " ", "be", " ", "an", 
      " ", \(\(integer\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::modint"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option in the indicated function is not an integer."
}], "Notes",
  CellTags->"General::modint"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::modgp", "ObjectNameWarningMessages",
  CellTags->"General::modgp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"modgp\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "Gaussian", " ", 
        "prime", " ", \(\(number\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::modgp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option in the indicated function is expected to be a Gaussian prime \
number.\n\[FilledSmallSquare] A Gaussian prime number is an integer that \
cannot be factored using complex numbers with integer real and imaginary \
parts.\n\[FilledSmallSquare] You can find out if a number is a Gaussian prime \
number using ",
  StyleBox["PrimeQ", "MR"],
  " with the ",
  StyleBox["GaussianIntegers->True", "MR"],
  " option."
}], "Notes",
  CellTags->"General::modgp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::modgp"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Modulus", "MR"],
  " option is not a Gaussian prime number."
}], "Text",
  CellTags->"General::modgp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorTerms[22\ I\  + \ 31\ x^2, x, Modulus -> 17]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::modgp"],

Cell[BoxData[
    \(FactorTerms::"modgp" \(\(:\)\(\ \)\) 
      "Value of option \!\(Modulus\) -> \!\(17\) should be a Gaussian prime \
number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::modgp"],

Cell[BoxData[
    \(FactorTerms[22\ \[ImaginaryI] + 31\ x\^2, x, 
      Modulus \[Rule] 17]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::modgp"]
}, Open  ]],

Cell["The integer 17 can be factored using Gaussian integers.", "Text",
  CellTags->"General::modgp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrimeQ[17, GaussianIntegers -> True]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::modgp"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::modgp"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[17, GaussianIntegers -> True]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::modgp"],

Cell[BoxData[
    \({{\(-\[ImaginaryI]\), 1}, {1 + 4\ \[ImaginaryI], 
        1}, {4 + \[ImaginaryI], 1}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::modgp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Modulus", "MR"],
  " option in this example."
}], "Text",
  CellTags->"General::modgp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorTerms[22\ I\  + \ 31\ x^2, x, Modulus -> 19]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::modgp"],

Cell[BoxData[
    \(12\ \((5\ \[ImaginaryI] + x\^2)\)\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::modgp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::modm", "ObjectNameWarningMessages",
  CellTags->"General::modm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"modm\"\>"}], \(\(:\)\(\ \)\), "Modulus", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "too", " ", "large", " ", "for", " ", "this", 
      " ", \(\(implementation\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::modm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option exceeds the largest value that is supported in the indicated \
function."
}], "Notes",
  CellTags->"General::modm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::modn", "ObjectNameWarningMessages",
  CellTags->"General::modn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"modn\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "an", 
        " ", \(\(integer\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::modn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option is not an integer."
}], "Notes",
  CellTags->"General::modn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::modn"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["FactorTerms", "MR"],
  " is expected to be an integer."
}], "Text",
  CellTags->"General::modn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorTerms[37\ x^2 - 1, x, Modulus -> 5/2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::modn"],

Cell[BoxData[
    \(FactorTerms::"modn" \(\(:\)\(\ \)\) 
      "Value of option \!\(Modulus\) -> \!\(5\/2\) should be an integer."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::modn"],

Cell[BoxData[
    \(FactorTerms[\(-1\) + 37\ x\^2, x, Modulus \[Rule] 5\/2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::modn"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["FactorTerms", "MR"],
  "."
}], "Text",
  CellTags->"General::modn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorTerms[37\ x^2 - 1, x, Modulus -> 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::modn"],

Cell[BoxData[
    \(2\ \((2 + x\^2)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::modn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::modp", "ObjectNameWarningMessages",
  CellTags->"General::modp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"modp\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "prime", " ", 
        "number", " ", "or", " ", \(\(zero\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::modp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option is not a prime number."
}], "Notes",
  CellTags->"General::modp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::modp"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Modulus", "MR"],
  " option is expected to be an integer."
}], "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[3/x + 1/\((x + 5)\), Modulus -> \ 5/2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(Together::"modp" \(\(:\)\(\ \)\) 
      "Value of option \!\(Modulus\) -> \!\(5\/2\) should be a prime number \
or zero."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(Together[3\/x + 1\/\(5 + x\), Modulus \[Rule] 5\/2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::modp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid ",
  StyleBox["Modulus", "MR"],
  " specification in ",
  StyleBox["Together", "MR"],
  "."
}], "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[3/x + 1/\((x + 5)\), Modulus -> \ 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(1\/\(x\ \((1 + x)\)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::modp"]
}, Open  ]],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["Together", "MR"],
  " is expected to be a prime number."
}], "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[923/\((807 + x)\) + 1/x, Modulus -> 583]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(Together::"modp" \(\(:\)\(\ \)\) 
      "Value of option \!\(Modulus\) -> \!\(583\) should be a prime number or \
zero."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(Together[1\/x + 923\/\(807 + x\), Modulus \[Rule] 583]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::modp"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["PrimeQ", "MR"],
  " to determine if a number is prime."
}], "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrimeQ[583]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::modp"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrimeQ[587]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"General::modp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["Together", "MR"],
  "."
}], "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[923/\((807 + x)\) + 1/x, Modulus -> 587]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"General::modp"],

Cell[BoxData[
    \(\(337\ \((140 + x)\)\)\/\(x\ \((220 + x)\)\)\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"General::modp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nalg", "ObjectNameWarningMessages",
  CellTags->"General::nalg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nalg\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "an", " ", "explicit", " ", 
        "algebraic", " ", \(\(number\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nalg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be an algebraic number.\n\[FilledSmallSquare] The value of the ",
  StyleBox["Extension", "MR"],
  " option in ",
  StyleBox["Factor", "MR"],
  " and related functions is expected to be an algebraic number or a list of \
algebraic numbers.\n\[FilledSmallSquare] An algebraic number is a number that \
can occur as the root of a polynomial with integer coefficients.  Integers, \
rational numbers, roots of integers, and ",
  StyleBox["Root", "MR"],
  " expressions are algebraic numbers."
}], "Notes",
  CellTags->"General::nalg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nalg"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is a symbol rather than an algebraic number."
}], "Text",
  CellTags->"General::nalg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[2 - x^2, Extension -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nalg"],

Cell[BoxData[
    \(Factor::"nalg" \(\(:\)\(\ \)\) 
      "\!\(All\) is not an explicit algebraic number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nalg"],

Cell[BoxData[
    \(Factor[2 - x\^2, Extension \[Rule] All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nalg"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Extension", "MR"],
  " option in ",
  StyleBox["Factor", "MR"],
  "."
}], "Text",
  CellTags->"General::nalg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[2 - x^2, Extension -> Sqrt[2]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nalg"],

Cell[BoxData[
    \(\((\@2 - x)\)\ \((\@2 + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nalg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nmod", "ObjectNameWarningMessages",
  CellTags->"General::nmod"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nmod\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "valid", " ", "modulo", " ", 
        RowBox[{
          StyleBox["n",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nmod"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is not \
valid in the indicated modulus.\
\>", "Notes",
  CellTags->"General::nmod"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nmod"],

Cell["\<\
An error occurs in this example because the given polynomial is not \
defined in the specified modulus.\
\>", "Text",
  CellTags->"General::nmod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[1 + x/8, Modulus -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nmod"],

Cell[BoxData[
    \(Together::"nmod" \(\(:\)\(\ \)\) 
      "\!\(1 + x\/8\) is not valid modulo \!\(2\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nmod"],

Cell[BoxData[
    \(Together[1 + x\/8, Modulus \[Rule] 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nmod"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Modulus", "MR"],
  " option for this polynomial."
}], "Text",
  CellTags->"General::nmod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Together[1 + x/8, Modulus \[Rule] 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nmod"],

Cell[BoxData[
    \(1 + 2\ x\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nmod"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::npoly", "ObjectNameWarningMessages",
  CellTags->"General::npoly"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"npoly\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "polynomial", " ", 
        "with", " ", "rational", " ", "number", 
        " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::npoly"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is \
expected to be a polynomial in which all of the coefficients are integers or \
rational numbers.\
\>", "Notes",
  CellTags->"General::npoly"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::npoly"],

Cell["\<\
An error occurs in this example because the argument is not a \
polynomial in the indicated variable.\
\>", "Text",
  CellTags->"General::npoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[2 - Sin[x]^2, x, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::npoly"],

Cell[BoxData[
    \(Root::"npoly" \(\(:\)\(\ \)\) 
      "\!\(2 - \(Sin[x]\)\^2\) is not a polynomial in \!\(x\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"General::npoly"],

Cell[BoxData[
    \(Root[2 - Sin[x]\^2, x, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::npoly"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Root", "MR"],
  "."
}], "Text",
  CellTags->"General::npoly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[2 - x^2, x, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::npoly"],

Cell[BoxData[
    \(\(-\@2\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::npoly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::npolys", "ObjectNameWarningMessages",
  CellTags->"General::npolys"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"npolys\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", " ",
         "polynomials", " ", "with", " ", "rational", " ", "number", 
        " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::npolys"],

Cell["\<\
\[FilledSmallSquare] Generated when the polynomials shown in the \
message are expected to be polynomials with coefficients that are integers or \
rational numbers.
\[FilledSmallSquare] The polynomials reported in the message will sometimes \
be derived in a non-trivial way from the input.\
\>", "Notes",
  CellTags->"General::npolys"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::npolys"],

Cell["\<\
An error occurs in this example because one of the coefficients in \
the input is not a rational number.\
\>", "Text",
  CellTags->"General::npolys"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[3\ y + Sqrt[2], Modulus -> x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::npolys"],

Cell[BoxData[
    \(Factor::"npolys" \(\(:\)\(\ \)\) 
      "\!\({\(\(\@2 + \(\(3\\ y\)\)\)\), x}\) is not a list of polynomials \
with rational number coefficients."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::npolys"],

Cell[BoxData[
    \(Factor[\@2 + 3\ y, Modulus \[Rule] x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::npolys"]
}, Open  ]],

Cell[TextData[{
  "This shows valid input in ",
  StyleBox["Factor", "MR"],
  "."
}], "Text",
  CellTags->"General::npolys"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[3\ y + x, Modulus -> \ \ x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::npolys"],

Cell[BoxData[
    \(3\ y\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::npolys"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::poly", "ObjectNameWarningMessages",
  CellTags->"General::poly"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"poly\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", 
        " ", \(\(polynomial\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::poly"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is \
expected to be a polynomial.\
\>", "Notes",
  CellTags->"General::poly"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::poly"],

Cell[TextData[{
  "An error occurs in this example because the first two arguments in ",
  StyleBox["PolynomialDivision", "MR"],
  " are expected to be polynomials in the variable given in the third \
argument."
}], "Text",
  CellTags->"General::poly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialQuotient[Sin[x], 1 + Sin[x], x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::poly"],

Cell[BoxData[
    \(PolynomialQuotient::"poly" \(\(:\)\(\ \)\) 
      "\!\(Sin[x]\) is not a polynomial."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::poly"],

Cell[BoxData[
    \(PolynomialQuotient[Sin[x], 1 + Sin[x], x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::poly"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["PolynomialDivision", "MR"],
  "."
}], "Text",
  CellTags->"General::poly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialQuotient[Sin[x], 1 + Sin[x], Sin[x]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::poly"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::poly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::polyx", "ObjectNameWarningMessages",
  CellTags->"General::polyx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"polyx\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "polynomial", " ", 
        "with", " ", "exact", " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::polyx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated polynomial includes \
coefficients that are inexact numbers.\n\[FilledSmallSquare] Some operations \
may require that all of the coefficients in a polynomial be exact.\n\
\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::polyx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::primm", "ObjectNameWarningMessages",
  CellTags->"General::primm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"primm\"\>"}], \(\(:\)\(\ \)\), "Tried", " ", 
        StyleBox["n",
          "TI"], " ", "primes"}], ",", 
      " ", \(algorithm\ \(\(failed\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::primm"],

Cell["\<\
\[FilledSmallSquare] Generated when the algorithm for computing \
polynomial resultants fails.\
\>", "Notes",
  CellTags->"General::primm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::prims", "ObjectNameWarningMessages",
  CellTags->"General::prims"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"prims\"\>"}], \(\(:\)\(\ \)\), "Prime", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "too", " ", "small"}], ",", 
      " ", \(algorithm\ \(\(failed\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::prims"],

Cell["\<\
\[FilledSmallSquare] Generated by a failure in an algorithm for \
computing polynomial results.\
\>", "Notes",
  CellTags->"General::prims"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::badcf
PolynomialReduce::badcf
Internal`GroebnerWalk::badcf
Internal`DistributedTermsList::badcf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
    "Internal`GroebnerWalk::badcf", "Internal`DistributedTermsList::badcf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"badcf\"\>"}], \(\(:\)\(\ \)\), \(Encountered\ bad\ \
coefficient\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
    "Internal`GroebnerWalk::badcf", "Internal`DistributedTermsList::badcf"}],

Cell["\<\
\[FilledSmallSquare] Generated when an infinite or indeterminate \
expression is encountered while processing the coefficients in the indicated \
polynomial operation.\
\>", "Notes",
  CellTags->{
  "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
    "Internal`GroebnerWalk::badcf", "Internal`DistributedTermsList::badcf"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::coef
PolynomialReduce::coef
Internal`GroebnerWalk::coef
Internal`DistributedTermsList::coef\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"coef\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
CoefficientDomain\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "not", " ", \(\(valid\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["CoefficientDomain", "MR"],
  " option does not match any of the expected forms.\n\[FilledSmallSquare] \
For information about valid values of the ",
  StyleBox["CoefficientDomain", "MR"],
  " option, see the documentation for ",
  StyleBox["CoefficientDomain", "MR"],
  " and for ",
  StyleBox["GroebnerBasis", "MR"],
  ".\n\[FilledSmallSquare] Valid values for the ",
  StyleBox["CoefficientDomain", "MR"],
  " option include ",
  StyleBox["Rationals", "MR"],
  ", ",
  StyleBox["Integers", "MR"],
  ", ",
  StyleBox["InexactNumbers", "MR"],
  ", and ",
  StyleBox["Polynomials[", "MR"],
  StyleBox["var", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["CoefficientDomain", "MR"],
  " option is not valid."
}], "Text",
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialReduce[1 + 4\ x, {2 + 3  x, 3 + 4  x}, 
      CoefficientDomain -> Integers[2, 3, 4]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[BoxData[
    \(PolynomialReduce::"coef" \(\(:\)\(\ \)\) 
      "Value of option CoefficientDomain -> \!\(Integers[\(\(2, 3, 4\)\)]\) \
not valid."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
    "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],

Cell[BoxData[
    \(PolynomialReduce[1 + 4\ x, {2 + 3\ x, 3 + 4\ x}, 
      CoefficientDomain \[Rule] Integers[2, 3, 4]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
    "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["CoefficientDomain", "MR"],
  " option."
}], "Text",
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialReduce[1 + 4\ x, {2 + 3  x, 3 + 4  x}, 
      CoefficientDomain -> Integers]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "GroebnerBasis::coef", "PolynomialReduce::coef", 
    "Internal`GroebnerWalk::coef", "Internal`DistributedTermsList::coef"}],

Cell[BoxData[
    \({{1, 0}, \(-1\) + x}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
    "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::elmvar
PolynomialReduce::elmvar
Internal`GroebnerWalk::elmvar
Internal`DistributedTermsList::elmvar\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
    "Internal`GroebnerWalk::elmvar", "Internal`DistributedTermsList::elmvar"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"elmvar\"\>"}], \(\(:\)\(\ \)\), "Term", " ", 
      "ordering", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "compatible", " ", "with", " ", 
      "elimination", " ", \(\(variables\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
    "Internal`GroebnerWalk::elmvar", "Internal`DistributedTermsList::elmvar"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option is not compatible with a specification of elimination variables.\n\
\[FilledSmallSquare] Elimination variables are specified in the third \
argument of ",
  StyleBox["GroebnerBasis", "MR"],
  ", the fourth argument of ",
  StyleBox["PolynomialReduce", "MR"],
  ", or the third argument of ",
  StyleBox["MonomialList", "MR"],
  "."
}], "Notes",
  CellTags->{
  "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
    "Internal`GroebnerWalk::elmvar", "Internal`DistributedTermsList::elmvar"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::fltgb
PolynomialReduce::fltgb
Internal`GroebnerWalk::fltgb
Internal`DistributedTermsList::fltgb\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
    "Internal`GroebnerWalk::fltgb", "Internal`DistributedTermsList::fltgb"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fltgb\"\>"}], \(\(:\)\(\ \)\), \(Excessive\ loss\ of\ \
precision\ during\ \(\(computation\)\(.\)\)\)}]], "Message",
  CellTags->{
  "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
    "Internal`GroebnerWalk::fltgb", "Internal`DistributedTermsList::fltgb"}],

Cell["\<\
\[FilledSmallSquare] Generated when numerical error may lead to \
significant errors in the result of the indicated polynomial operation.
\[FilledSmallSquare] This message should occur only in degenerate examples.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support.\
\>", "Notes",
  CellTags->{
  "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
    "Internal`GroebnerWalk::fltgb", "Internal`DistributedTermsList::fltgb"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::intgb
PolynomialReduce::intgb
Internal`GroebnerWalk::intgb
Internal`DistributedTermsList::intgb\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"intgb\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "specify", " ", "the", " ", "polynomial", " ", 
      StyleBox["expr",
        "TI"], " ", "with", " ", "nontrivial", " ", "denominator", " ", "as", 
      " ", "input", " ", "for", " ", "Groebner", " ", "basis", " ", "over", 
      " ", "the", " ", \(\(integers\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell["\<\
\[FilledSmallSquare] Generated when an integer coefficient domain \
is specified and the indicated polynomial cannot be represented using integer \
coefficients.\
\>", "Notes",
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell[TextData[{
  "An error occurs in this example because the coefficients in the \
polynomials in the first argument of ",
  StyleBox["GroebnerBasis", "MR"],
  " are not integers."
}], "Text",
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{2/3 + x, x}, x, 
      CoefficientDomain -> Integers]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell[BoxData[
    \(GroebnerBasis::"intgb" \(\(:\)\(\ \)\) 
      "Cannot specify the polynomial \!\(1\/3\\ \(\((2 + \(\(3\\ \
\(\(Solve`SolvVar[x]\)\)\)\))\)\)\) with nontrivial denominator as input for \
Groebner basis over the integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
    "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],

Cell[BoxData[
    \(GroebnerBasis[{2\/3 + x, x}, x, 
      CoefficientDomain \[Rule] Integers]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
    "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}]
}, Open  ]],

Cell["\<\
This computation can be done if the coefficient domain is expanded \
to include rational numbers.\
\>", "Text",
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{2/3 + x, x}, x, 
      CoefficientDomain -> Rationals]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
    "Internal`GroebnerWalk::intgb", "Internal`DistributedTermsList::intgb"}],

Cell[BoxData[
    \({1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
    "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::mnmord1
PolynomialReduce::mnmord1
Internal`GroebnerWalk::mnmord1
Internal`DistributedTermsList::mnmord1\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"mnmord1\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
MonomialOrder\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "not", " ", \(\(valid\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option does not match any of the expected forms.\n\[FilledSmallSquare] \
For information about valid values of the ",
  StyleBox["MonomialOrder", "MR"],
  " option, see the documentation for ",
  StyleBox["MonomialOrder", "MR"],
  " and ",
  StyleBox["GroebnerBasis", "MR"],
  ".\n\[FilledSmallSquare] The value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option can be ",
  StyleBox["Lexicographic", "MR"],
  ", ",
  StyleBox["DegreeLexicographic", "MR"],
  ", ",
  StyleBox["DegreeReverseLexicographic", "MR"],
  ", ",
  StyleBox["EliminationOrder", "MR"],
  ", or a weight matrix."
}], "Notes",
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["MonomialOrder", "MR"],
  " option."
}], "Text",
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\ y + y^2, x - y}, {x, y}, 
      MonomialOrder -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[BoxData[
    \(GroebnerBasis::"mnmord1" \(\(:\)\(\ \)\) 
      "Value of option MonomialOrder -> \!\(Automatic\) not valid."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],

Cell[BoxData[
    \(GroebnerBasis[{x\ y + y\^2, x - y}, {x, y}, 
      MonomialOrder \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["MonomialOrder", "MR"],
  " option in ",
  StyleBox["GroebnerBasis", "MR"],
  "."
}], "Text",
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\ y + y^2, x - y}, {x, y}, 
      MonomialOrder -> DegreeLexicographic]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", 
    "Internal`DistributedTermsList::mnmord1"}],

Cell[BoxData[
    \({x - y, y\^2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
    "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::mnmord2
PolynomialReduce::mnmord2
Internal`GroebnerWalk::mnmord2
Internal`DistributedTermsList::mnmord2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"mnmord2\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["optval",
          "TI"], " ", "does", " ", "not", " ", "order", " ", "all", " ", 
        "terms", " ", "formed", " ", "from", " ", "variables", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option is a weight matrix and that weight matrix does not specify the \
order for all of the variables in the argument polynomials."
}], "Notes",
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[TextData[{
  "An error occurs in this example because the weight matrix given as the \
value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option does not specify ordering for all of the variables."
}], "Text",
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\ y + 1, x^2 + y\ z, z^2\ x^2 + x + y}, {x, y, z}, 
      MonomialOrder -> {{1, 0}, {0, 1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[BoxData[
    \(GroebnerBasis::"mnmord2" \(\(:\)\(\ \)\) 
      "\!\({\(\({1, 0}\)\), \(\({0, 1}\)\)}\) does not order all terms formed \
from variables \!\({x, y, z}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],

Cell[BoxData[
    \(GroebnerBasis[{1 + x\ y, x\^2 + y\ z, x + y + x\^2\ z\^2}, {x, y, z}, 
      MonomialOrder \[Rule] {{1, 0}, {0, 1}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}]
}, Open  ]],

Cell["This shows a valid weight matrix for these polynomials.", "Text",
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x\ y + 1, x^2 + y\ z, z^2\ x^2 + x + y}, {x, y, z}, 
      MonomialOrder -> {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", 
    "Internal`DistributedTermsList::mnmord2"}],

Cell[BoxData[
    \({\(-1\) + z\^2 + 3\ z\^3 - 3\ z\^6 + z\^9, \(-y\) - z - 2\ z\^2 + 
        3\ z\^5 - z\^8, \(-x\) + z + z\^2 - 2\ z\^5 + z\^8}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
    "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::modflt
PolynomialReduce::modflt
Internal`GroebnerWalk::modflt
Internal`DistributedTermsList::modflt\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
    "Internal`GroebnerWalk::modflt", "Internal`DistributedTermsList::modflt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"modflt\"\>"}], \(\(:\)\(\ \)\), \(Cannot\ specify\ nonzero\
\ modulus\ when\ working\ with\ inexact\ \(\(coefficients\)\(.\)\)\)}]], \
"Message",
  CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
    "Internal`GroebnerWalk::modflt", "Internal`DistributedTermsList::modflt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option is nonzero and the value of the ",
  StyleBox["CoefficientDomain", "MR"],
  " option is ",
  StyleBox["InexactNumbers", "MR"],
  "."
}], "Notes",
  CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
    "Internal`GroebnerWalk::modflt", "Internal`DistributedTermsList::modflt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
    "Internal`GroebnerWalk::modflt", "Internal`DistributedTermsList::modflt"}],

Cell[TextData[{
  "An error occurs in this example because a nonzero value for the ",
  StyleBox["Modulus", "MR"],
  " option is not compatible with ",
  StyleBox["CoefficientDomain->InexactNumbers", "MR"],
  "."
}], "Text",
  CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
    "Internal`GroebnerWalk::modflt", "Internal`DistributedTermsList::modflt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialReduce[5.7  x^2 + 3.3  y^2, x + y, 
      CoefficientDomain -> InexactNumbers, Modulus -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
    "Internal`GroebnerWalk::modflt", "Internal`DistributedTermsList::modflt"}],

Cell[BoxData[
    \(PolynomialReduce::"modflt" \(\(:\)\(\ \)\) 
      "Cannot specify nonzero modulus when working with inexact \
coefficients."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
    "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}],

Cell[BoxData[
    \({{1.`\ \((5.7`\ x - 5.7`\ y)\)}, 9.`\ y\^2}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
    "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inequality::ineq", "ObjectNameWarningMessages",
  CellTags->"Inequality::ineq"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Inequality::"ineq"\), \(\(:\)\(\ \)\), "Inequality", " ", 
        "called", " ", "with", " ", 
        StyleBox["n",
          "TI"], " ", "arguments"}], ";", 
      " ", \(the\ number\ of\ arguments\ is\ expected\ to\ be\ an\ odd\ \
number\  >= \ 3. \)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Inequality::ineq"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of arguments in ",
  StyleBox["Inequality", "MR"],
  " is not valid.\n\[FilledSmallSquare] Arguments at even positions in ",
  StyleBox["Inequality", "MR"],
  " are expected to be comparison operators (",
  StyleBox["Less", "MR"],
  ", ",
  StyleBox["LessEqual", "MR"],
  ", ",
  StyleBox["Equal", "MR"],
  ", ",
  StyleBox["Unequal", "MR"],
  ", ",
  StyleBox["SameQ", "MR"],
  ", ",
  StyleBox["UnsameQ", "MR"],
  ", ",
  StyleBox["Greater", "MR"],
  ", or ",
  StyleBox["GreaterEqual", "MR"],
  "), and arguments at odd positions are treated as operands."
}], "Notes",
  CellTags->"Inequality::ineq"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Inequality::ineq"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Inequality", "MR"],
  " is used with an unexpected number of arguments."
}], "Text",
  CellTags->"Inequality::ineq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inequality[Pi, Greater]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Inequality::ineq"],

Cell[BoxData[
    \(Inequality::"ineq" \(\(:\)\(\ \)\) 
      "Inequality called with \!\(2\) arguments; the number of arguments is \
expected to be an odd number >= 3."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Inequality::ineq"],

Cell[BoxData[
    \(\(\(\[Pi]\)\(>\)\)\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Inequality::ineq"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Inequality", "MR"],
  "."
}], "Text",
  CellTags->"Inequality::ineq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inequality[Pi, Greater, E]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Inequality::ineq"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Inequality::ineq"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::pdvar2
PolynomialReduce::pdvar2
Internal`GroebnerWalk::pdvar2
Internal`DistributedTermsList::pdvar2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "Internal`DistributedTermsList::pdvar2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"pdvar2\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "polynomial", " ", "domain", " ", "variable", " ", 
      StyleBox["var",
        "TI"], " ", "is", " ", "improperly", " ", "used", " ", "in", " ", 
      "polynomial", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "Internal`DistributedTermsList::pdvar2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["CoefficientDomain", "MR"],
  " option is ",
  StyleBox["Polynomials[", "MR"],
  StyleBox["var", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["var", "MR",
    FontSlant->"Italic"],
  " is used in the indicated expression in a position that is not part of a \
polynomial coefficient."
}], "Notes",
  CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "Internal`DistributedTermsList::pdvar2"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "Internal`DistributedTermsList::pdvar2"}],

Cell["\<\
An error occurs in this example because the expressions listed in \
the first argument are not polynomials in the specified variable with \
coefficients in the specified domain.\
\>", "Text",
  CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "Internal`DistributedTermsList::pdvar2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{y + y^x, 1 - x\ y}, y, 
      CoefficientDomain -> Polynomials[x]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "Internal`DistributedTermsList::pdvar2"}],

Cell[BoxData[
    \(GroebnerBasis::"pdvar2" \(\(:\)\(\ \)\) 
      "The polynomial domain variable \!\(x\) is improperly used in \
polynomial \!\(y + y\^x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}],

Cell[BoxData[
    \(GroebnerBasis[{y + y\^x, 1 - x\ y}, y, 
      CoefficientDomain \[Rule] Polynomials[x]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
    "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::poly2
PolynomialReduce::poly2
Resultant::poly2
Internal`GroebnerWalk::poly2
Internal`DistributedTermsList::poly2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
    "Internal`GroebnerWalk::poly2", "Internal`DistributedTermsList::poly2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"poly2\"\>"}], ":", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "well"}], "-", 
        RowBox[{"formed", " ", "polynomial", " ", "in", " ", 
          RowBox[{
            StyleBox["var",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
    "Internal`GroebnerWalk::poly2", "Internal`DistributedTermsList::poly2"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is not \
recognized as a polynomial.\
\>", "Notes",
  CellTags->{
  "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
    "Internal`GroebnerWalk::poly2", "Internal`DistributedTermsList::poly2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::wgtmat1
PolynomialReduce::wgtmat1
Internal`GroebnerWalk::wgtmat1
Internal`DistributedTermsList::wgtmat1\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"wgtmat1\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", "weight",
         " ", \(\(matrix\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option is not a valid weight matrix.\n\[FilledSmallSquare] A weight \
matrix used as the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option is expected to be a non-degenerate matrix with positive integer or \
rational elements."
}], "Notes",
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell["\<\
An error occurs in this example because the weight matrix includes \
elements that are not integers or rational numbers.\
\>", "Text",
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x + 3  x\ y, y - 2  x}, {x, y}, 
      MonomialOrder -> {{Pi, 0}, {0, Pi}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell[BoxData[
    \(GroebnerBasis::"wgtmat1" \(\(:\)\(\ \)\) 
      "\!\({\(\({\[Pi], 0}\)\), \(\({0, \[Pi]}\)\)}\) is not a valid weight \
matrix."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],

Cell[BoxData[
    \(GroebnerBasis[{x + 3\ x\ y, \(-2\)\ x + y}, {x, y}, 
      MonomialOrder \[Rule] {{\[Pi], 0}, {0, \[Pi]}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid weight matrix as the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option."
}], "Text",
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroebnerBasis[{x + 3  x\ y, y - 2  x}, {x, y}, 
      MonomialOrder -> {{1, 0}, {0, 1}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", 
    "Internal`DistributedTermsList::wgtmat1"}],

Cell[BoxData[
    \({y + 3\ y\^2, \(-2\)\ x + y}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
    "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::wgtmat2
PolynomialReduce::wgtmat2
Internal`GroebnerWalk::wgtmat2
Internal`DistributedTermsList::wgtmat2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
    "Internal`GroebnerWalk::wgtmat2", 
    "Internal`DistributedTermsList::wgtmat2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"wgtmat2\"\>"}], \(\(:\)\(\ \)\), "Weight", " ", 
      "matrix", " ", "based", " ", "on", " ", "variable", " ", "list", " ", 
      StyleBox["vars",
        "TI"], " ", "is", " ", "invalidated", " ", "by", " ", "the", " ", 
      "internal", " ", "variable", " ", "list", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
    "Internal`GroebnerWalk::wgtmat2", 
    "Internal`DistributedTermsList::wgtmat2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MonomialOrder", "MR"],
  " option is a weight matrix that is incompatible with other variable \
specifications."
}], "Notes",
  CellTags->{
  "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
    "Internal`GroebnerWalk::wgtmat2", 
    "Internal`DistributedTermsList::wgtmat2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::gener", "ObjectNameWarningMessages",
  CellTags->"Integrate::gener"],

Cell[BoxData[
    \(Integrate::"gener" \(\(:\)\(\ \)\) \(Unable\ to\ check\ \(\(convergence\
\)\(.\)\)\)\)], "Message",
  CellTags->"Integrate::gener"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["Integrate", "MR"],
  " function is unable to determine whether or not there are any \
singularities in the range of integration that may affect the result, or is \
unable to analyze the effect of the singularities that are found.\n\
\[FilledSmallSquare] This message does not necessarily indicate that the \
result is incorrect, but results that are accompanied by this message should \
be checked.\n\[FilledSmallSquare] This message normally indicates that a \
definite integral was computed by taking limits of the corresponding \
indefinite integral (antiderivative), and that ",
  StyleBox["Integrate", "MR"],
  " was unable to verify continuity of the indefinite integral."
}], "Notes",
  CellTags->"Integrate::gener"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::idiv", "ObjectNameWarningMessages",
  CellTags->"Integrate::idiv"],

Cell[BoxData[
    RowBox[{\(Integrate::"idiv"\), \(\(:\)\(\ \)\), \(\(Integral\)\(\ \
\)\(of\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "does", " ", "not", " ", "converge", " ", "on", " ", 
      RowBox[{
        StyleBox["range",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Integrate::idiv"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated definite integral \
does not converge.\
\>", "Notes",
  CellTags->"Integrate::idiv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::idiv"],

Cell["\<\
A message is generated in this example because this integral is \
divergent.\
\>", "Text",
  CellTags->"Integrate::idiv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Exp[x], {x, 0, Infinity}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::idiv"],

Cell[BoxData[
    \(Integrate::"idiv" \(\(:\)\(\ \)\) 
      "Integral of \!\(\[ExponentialE]\^x\) does not converge on \!\({0, \
\[Infinity]}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::idiv"],

Cell[BoxData[
    \(\[Integral]\_0\%\[Infinity]\( \[ExponentialE]\^x\) \
\[DifferentialD]x\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::idiv"]
}, Open  ]],

Cell["This shows a similar integral that is convergent.", "Text",
  CellTags->"Integrate::idiv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Exp[\(-x\)], {x, 0, Infinity}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Integrate::idiv"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Integrate::idiv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::ilim", "ObjectNameWarningMessages",
  CellTags->"Integrate::ilim"],

Cell[BoxData[
    RowBox[{\(Integrate::"ilim"\), \(\(:\)\(\ \)\), "Invalid", " ", 
      "integration", " ", "variable", " ", "or", " ", "limit", \((s)\), " ", 
      "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Integrate::ilim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in a definite \
integral is a list with less than three elements.\n\[FilledSmallSquare] The \
first argument in ",
  StyleBox["Integrate", "MR"],
  " gives the integrand, and remaining arguments are expected to be variables \
(for indefinite integration) or lists of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xmin", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xmax", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " (for definite integration)."
}], "Notes",
  CellTags->"Integrate::ilim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::ilim"],

Cell["\<\
An error occurs in this example because only one of the limits of \
integration is specified.\
\>", "Text",
  CellTags->"Integrate::ilim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Exp[\(-x\)], {x, Infinity}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::ilim"],

Cell[BoxData[
    \(Integrate::"ilim" \(\(:\)\(\ \)\) 
      "Invalid integration variable or limit(s) in \!\({x, \
\[Infinity]}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::ilim"],

Cell[BoxData[
    \(\[Integral]\(\[ExponentialE]\^\(-x\)\) \[DifferentialD]{x, \[Infinity]}\
\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::ilim"]
}, Open  ]],

Cell["This shows a valid specification of a definite integral.", "Text",
  CellTags->"Integrate::ilim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Exp[\(-x\)], {x, 0, Infinity}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Integrate::ilim"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Integrate::ilim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterpolatingPolynomial::ipdat", "ObjectNameWarningMessages",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[BoxData[
    RowBox[{\(InterpolatingPolynomial::"ipdat"\), \(\(:\)\(\ \)\), \
\(\(First\)\(\ \)\(argument\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ list\ of\ non - 
        lists\ or\ a\ list\ of\ \(\(pairs\)\(.\)\)\)\)}]], "Message",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell["\<\
An error occurs in this example because the first argument does not \
have the expected form.\
\>", "Text",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{2, 3, 1}}, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[BoxData[
    \(InterpolatingPolynomial::"ipdat" \(\(:\)\(\ \)\) 
      "First argument \!\({\({2, 3, 1}\)}\) should be a list of non-lists or \
a list of pairs."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[BoxData[
    \(InterpolatingPolynomial[{{2, 3, 1}}, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InterpolatingPolynomial::ipdat"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  "."
}], "Text",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{2, 3, 1}, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingPolynomial::ipdat"],

Cell[BoxData[
    \(2 + \((1 - 3\/2\ \((\(-2\) + x)\))\)\ \((\(-1\) + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingPolynomial::ipdat"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterpolatingPolynomial::ipdup", "ObjectNameWarningMessages",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[BoxData[
    \(InterpolatingPolynomial::"ipdup" \(\(:\)\(\ \)\) \(The\ abscissae\ are\ \
not\ \(\(distinct\)\(.\)\)\)\)], "Message",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  " is a list of pairs and at least two pairs have the same first element."
}], "Notes",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell["\<\
An error occurs in this example because the first and last pair \
have the same first element.\
\>", "Text",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{2, 0}, {3, 1}, {2, 2}}, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[BoxData[
    \(InterpolatingPolynomial::"ipdup" \(\(:\)\(\ \)\) 
      "The abscissae are not distinct."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[BoxData[
    \(InterpolatingPolynomial[{{2, 0}, {3, 1}, {2, 2}}, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InterpolatingPolynomial::ipdup"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  "."
}], "Text",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{2, 0}, {3, 1}, {0, 2}}, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingPolynomial::ipdup"],

Cell[BoxData[
    \(\((1 + 2\/3\ \((\(-3\) + x)\))\)\ \((\(-2\) + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingPolynomial::ipdup"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterpolatingPolynomial::ipf", "ObjectNameWarningMessages",
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(InterpolatingPolynomial::"ipf"\), \(\(:\)\(\ \)\), \
\(\(Ordinate\)\(\ \)\), 
        StyleBox["expr",
          "TI"], " ", "from", " ", "data", " ", "element", " ", "number", " ",
         
        StyleBox["n",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "non"}], 
      "-", \(list\ or\ a\ non\), 
      "-", \(empty\ \(\(vector\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  " is list of pairs and the second element in the indicated pair is an empty \
list or a list with list elements.\n\[FilledSmallSquare] When the second \
element in a coordinate pair is a list, that element specifies both the value \
and derivatives for the interpolating polynomial."
}], "Notes",
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[TextData[{
  "An error occurs in this example because the last element from the first \
argument of the ",
  StyleBox["InterpolatingPolynomial", "MR"],
  " expression is a pair in which the second element does not have the \
expected form."
}], "Text",
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{1, 2}, {3, 1}, {4, {0, {0}}}}, x]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[BoxData[
    \(InterpolatingPolynomial::"ipf" \(\(:\)\(\ \)\) 
      "Ordinate \!\({0, \(\({0}\)\)}\) from data element number \!\(3\) \
should be a non-list or a non-empty vector."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[BoxData[
    \(InterpolatingPolynomial[{{1, 2}, {3, 1}, {4, {0, {0}}}}, x]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"InterpolatingPolynomial::ipf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{1, 2}, {3, 1}, {4, {0, 0}}}, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingPolynomial::ipf"],

Cell[BoxData[
    \(2 + \((\(-\(1\/2\)\) + \((\(-\(1\/6\)\) + 
                  7\/18\ \((\(-4\) + x)\))\)\ \((\(-3\) + 
                  x)\))\)\ \((\(-1\) + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingPolynomial::ipf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterpolatingPolynomial::ipval", "ObjectNameWarningMessages",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(InterpolatingPolynomial::"ipval"\), \(\(:\)\(\ \)\), \
\(\(Abscissa\)\(\ \)\), 
        StyleBox["expr",
          "TI"], " ", "from", " ", "data", " ", "element", " ", "number", " ",
         
        StyleBox["n",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "non"}], 
      "-", \(\(list\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  " is a list of pairs and the first element in one of those pairs is a \
list."
}], "Notes",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell["\<\
An error occurs in this example because the first element in the \
second pair is a list.\
\>", "Text",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{1, 2}, {{3, 3}, 1}, {4, 1}}, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[BoxData[
    \(InterpolatingPolynomial::"ipval" \(\(:\)\(\ \)\) 
      "Abscissa \!\({3, 3}\) from data element number \!\(2\) should be a \
non-list."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[BoxData[
    \(InterpolatingPolynomial[{{1, 2}, {{3, 3}, 1}, {4, 1}}, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InterpolatingPolynomial::ipval"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  "."
}], "Text",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{1, 2}, {3, {3, 1}}, {4, 1}}, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingPolynomial::ipval"],

Cell[BoxData[
    \(2 + \((1\/2 + \((1\/4 - 13\/12\ \((\(-3\) + x)\))\)\ \((\(-3\) + 
                  x)\))\)\ \((\(-1\) + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingPolynomial::ipval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterpolatingPolynomial::ipvar", "ObjectNameWarningMessages",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[BoxData[
    RowBox[{\(InterpolatingPolynomial::"ipvar"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ used\ as\ the\ variable\ in\ a\ \
\(\(polynomial\)\(.\)\)\)\)}]], "Message",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  " is not a valid variable.\n\[FilledSmallSquare] Most expressions other \
than sums, products, powers, numbers, lists, rules, logical operations, and \
inequalities can be used as variables."
}], "Notes",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  " is a number."
}], "Text",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{2, 3, 5}, 4]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[BoxData[
    \(InterpolatingPolynomial::"ipvar" \(\(:\)\(\ \)\) 
      "\!\(4\) cannot be used as the variable in a polynomial."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[BoxData[
    \(InterpolatingPolynomial[{2, 3, 5}, 4]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InterpolatingPolynomial::ipvar"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["InterpolatingPolynomial", "MR"],
  "."
}], "Text",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{2, 3, 5}, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingPolynomial::ipvar"],

Cell[BoxData[
    \(2 + \((1 + 1\/2\ \((\(-2\) + x)\))\)\ \((\(-1\) + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingPolynomial::ipvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InverseFunction::ifun", "ObjectNameWarningMessages",
  CellTags->"InverseFunction::ifun"],

Cell[BoxData[
    \(InverseFunction::"ifun" \(\(:\)\(\ \)\) \(Inverse\ functions\ are\ \
being\ used . \ 
          Values\ may\ be\ lost\ for\ multivalued\ \
\(\(inverses\)\(.\)\)\)\)], "Message",
  CellTags->"InverseFunction::ifun"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the built-in rules for the inverse of \
an unknown function are applied.\n\[FilledSmallSquare] This message is \
typically generated when ",
  StyleBox["InverseFunction", "MR"],
  " is called by functions such as ",
  StyleBox["Solve", "MR"],
  "."
}], "Notes",
  CellTags->"InverseFunction::ifun"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InverseFunction::ifun"],

Cell[TextData[{
  "This example will generate a warning message if ",
  StyleBox["f", "MR"],
  " is an unknown function."
}], "Text",
  CellTags->"InverseFunction::ifun"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[f[x] \[Equal] 1, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InverseFunction::ifun"],

Cell["\<\
InverseFunction::ifun : Inverse functions are being used. Values \
may be lost for multivalued inverses.\
\>", "Message",
  CellLabel->"From In[1]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"InverseFunction::ifun"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          RowBox[{
            TagBox[\(f\^\((\(-1\))\)\),
              {InverseFunction, 1, 1},
              Editable->False], "[", "1", "]"}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InverseFunction::ifun"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InverseFunction::noinv", "ObjectNameWarningMessages",
  CellTags->"InverseFunction::noinv"],

Cell[BoxData[
    RowBox[{\(InverseFunction::"noinv"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(function\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ \(\(invertible\)\(.\)\)\)\)}]], "Message",
  CellTags->"InverseFunction::noinv"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function does not \
have an inverse.
\[FilledSmallSquare] This message is used for selected Jacobi elliptic \
functions.\
\>", "Notes",
  CellTags->"InverseFunction::noinv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InverseFunction::noinv"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["InverseJacobiDN[", "MR"],
  StyleBox["v", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["m", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " is undefined when ",
  StyleBox["m", "MR",
    FontSlant->"Italic"],
  " is zero."
}], "Text",
  CellTags->"InverseFunction::noinv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseJacobiDN[1, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InverseFunction::noinv"],

Cell[BoxData[
    \(InverseFunction::"noinv" \(\(:\)\(\ \)\) 
      "The function \!\(\(\(JacobiDN[\(\(#1, 0\)\)]\)\) &\) is not \
invertible."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"InverseFunction::noinv"],

Cell[BoxData[
    \(InverseJacobiDN[1, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InverseFunction::noinv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limit::limf", "ObjectNameWarningMessages",
  CellTags->"Limit::limf"],

Cell[BoxData[
    RowBox[{\(Limit::"limf"\), \(\(:\)\(\ \)\), \(\(Unable\)\(\ \)\(to\)\(\ \
\)\(determine\)\(\ \)\(limit\)\(\ \)\(direction\)\(\ \)\(from\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Limit::limf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the limit point is ",
  StyleBox["DirectedInfinity[", "MR"],
  StyleBox["b", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " with a symbolic value of ",
  StyleBox["b", "MR",
    FontSlant->"Italic"],
  ", and the value of the ",
  StyleBox["Direction", "MR"],
  " option is ",
  StyleBox["Automatic", "MR"],
  "."
}], "Notes",
  CellTags->"Limit::limf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Limit::limf"],

Cell[TextData[{
  "An error occurs in this example because the direction of the limit is not \
determined automatically if the limit point is a symbolic ",
  StyleBox["DirectedInfinity", "MR"],
  "."
}], "Text",
  CellTags->"Limit::limf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[Exp[x], x -> DirectedInfinity[b]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Limit::limf"],

Cell[BoxData[
    \(Limit::"limf" \(\(:\)\(\ \)\) 
      "Unable to determine limit direction from \!\(x \[Rule] \
\(\(DirectedInfinity[b]\)\)\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Limit::limf"],

Cell[BoxData[
    \(Limit[\[ExponentialE]\^x, x \[Rule] DirectedInfinity[b]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Limit::limf"]
}, Open  ]],

Cell[TextData[{
  "This limit can be computed if the direction is specified explicitly using \
the ",
  StyleBox["Direction", "MR"],
  " option."
}], "Text",
  CellTags->"Limit::limf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[Exp[x], x -> DirectedInfinity[b], Direction -> \(-1\)]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"Limit::limf"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Limit::limf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::ibool
Reduce::ibool
System`Private`OldReduce::ibool
Eliminate::ibool
SolveAlways::ibool
MainSolve::ibool
AlgebraicRules::ibool\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"ibool\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
InverseFunctions\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "should", " ", "be", " ", "True"}]}], ",", " ", 
      "False", ",", " ", \(or\ \(\(Automatic\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["InverseFunctions", "MR"],
  " option in the indicated function does not have one of the expected \
values."
}], "Notes",
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["InverseFunctions", "MR"],
  " option."
}], "Text",
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Exp[x] == 2, x, InverseFunctions -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[BoxData[
    \(Solve::"ibool" \(\(:\)\(\ \)\) 
      "Value of option InverseFunctions -> \!\(None\) should be True, False, \
or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
    "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
    "System`Private`OldReduce::ibool"}],

Cell[BoxData[
    \(Solve[\[ExponentialE]\^x \[Equal] 2, x, 
      InverseFunctions \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
    "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
    "System`Private`OldReduce::ibool"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["InverseFunctions", "MR"],
  " option in ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Exp[x] == 2, x, InverseFunctions -> True]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
    "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
    "AlgebraicRules::ibool"}],

Cell[BoxData[
    \({{x \[Rule] Log[2]}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
    "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
    "System`Private`OldReduce::ibool"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::method
Reduce::method
System`Private`OldReduce::method
Eliminate::method
SolveAlways::method
MainSolve::method
AlgebraicRules::method\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"method\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Method\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "should", " ", "be", " ", "1"}]}], ",", " ", "2", ",",
       " ", \(or\ 3. \)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option does not have one the expected values for the indicated function."
}], "Notes",
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x\ y + 1 == 0, x + 2  y == 1}, {x, y}, 
      Method -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[BoxData[
    \(Solve::"method" \(\(:\)\(\ \)\) 
      "Value of option Method -> \!\(Automatic\) should be 1, 2, or 3."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
    "Reduce::method", "SolveAlways::method", "Solve::method", 
    "System`Private`OldReduce::method"}],

Cell[BoxData[
    \(Solve[{1 + x\ y \[Equal] 0, x + 2\ y \[Equal] 1}, {x, y}, 
      Method \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
    "Reduce::method", "SolveAlways::method", "Solve::method", 
    "System`Private`OldReduce::method"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x\ y + 1 == 0, x + 2  y == 1}, {x, y}, Method -> 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
    "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
    "AlgebraicRules::method"}],

Cell[BoxData[
    \({{\(-y\) + 2\ y\^2 \[Rule] 1, x \[Rule] 1 - 2\ y}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
    "Reduce::method", "SolveAlways::method", "Solve::method", 
    "System`Private`OldReduce::method"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::mode
Reduce::mode
System`Private`OldReduce::mode
Eliminate::mode
SolveAlways::mode
MainSolve::mode
AlgebraicRules::mode\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
    "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
    "AlgebraicRules::mode"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"mode\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Mode\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "should", " ", "be", " ", "Generic"}]}], ",", " ", 
      "Modular", ",", " ", \(or\ \(\(Rational\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
    "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
    "AlgebraicRules::mode"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Mode", "MR"],
  " option does not have one of the expected values."
}], "Notes",
  CellTags->{
  "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
    "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
    "AlgebraicRules::mode"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
    "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
    "AlgebraicRules::mode"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["Mode", "MR"],
  " option."
}], "Text",
  CellTags->{
  "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
    "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
    "AlgebraicRules::mode"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x + 14 == y, 5\ x\ y == 30}, {x, y}, 
      Mode -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
    "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
    "AlgebraicRules::mode"}],

Cell[BoxData[
    \(Solve::"mode" \(\(:\)\(\ \)\) 
      "Value of option Mode -> \!\(Automatic\) should be Generic, Modular, or \
Rational."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
    "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
    "System`Private`OldReduce::mode"}],

Cell[BoxData[
    \(Solve[{14 + x \[Equal] y, 5\ x\ y \[Equal] 30}, {x, y}, 
      Mode \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
    "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
    "System`Private`OldReduce::mode"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x + 14 == y, 5\ x\ y == 30}, {x, y}, Mode -> Generic]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{
  "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
    "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
    "AlgebraicRules::mode"}],

Cell[BoxData[
    \({{x \[Rule] \(-7\) - \@55, 
        y \[Rule] 7 - \@55}, {x \[Rule] \(-7\) + \@55, 
        y \[Rule] 7 + \@55}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
    "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
    "System`Private`OldReduce::mode"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::verif
Reduce::verif
System`Private`OldReduce::verif
Eliminate::verif
MainSolve::verif
AlgebraicRules::verif\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
    "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"verif\"\>"}], \(\(:\)\(\ \)\), "Potential", " ", 
      "solution", " ", 
      StyleBox["expr",
        "TI"], " ", \((possibly\ discarded\ by\ verifier)\), " ", "should", 
      " ", "be", " ", "checked", " ", "by", " ", \(hand . \ May\), " ", 
      "require", " ", "use", " ", "of", " ", \(\(limits\)\(.\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
    "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],

Cell["\<\
\[FilledSmallSquare] Generated when a singularity is encountered \
when potential solutions are substituted back into the equations.\
\>", \
"Notes",
  CellTags->{
  "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
    "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
    "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],

Cell["\<\
A message is generated in this example because the indicated trial \
solution cannot be verified by simply substituting the solution into the \
equation.\
\>", "Text",
  CellTags->{
  "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
    "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Sin[x^2]/x == 0, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
    "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],

Cell[BoxData[
    \(Solve::"verif" \(\(:\)\(\ \)\) 
      "Potential solution \!\({x \[Rule] 0}\) (possibly discarded by \
verifier) should be checked by hand. May require use of limits."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
    "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found; use Reduce for complete solution information."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
    "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
    "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::amb", "ObjectNameWarningMessages",
  CellTags->"Root::amb"],

Cell[BoxData[
    RowBox[{\(Root::"amb"\), \(\(:\)\(\ \)\), \(\(Root\)\(\ \)\(object\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(may\ be\ ambiguous . \ 
          Changing\ the\ value\ of\ ExactRootIsolation\ option\ to\ Root\ to\ \
True\ and\ redoing\ the\ computations\ is\ \(\(recommended\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Root::amb"],

Cell["\<\
\[FilledSmallSquare] Generated when the algorithm based on inexact \
arithmetic is not able to isolate the roots in the indicated \
polynomial.\
\>", "Notes",
  CellTags->"Root::amb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::deg", "ObjectNameWarningMessages",
  CellTags->"Root::deg"],

Cell[BoxData[
    RowBox[{\(Root::"deg"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "has", " ", "less", " ", "than", " ", 
      StyleBox["n",
        "TI"], " ", "root", \((s)\), " ", "as", " ", "a", " ", "polynomial", 
      " ", "in", " ", 
      RowBox[{
        StyleBox["var",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Root::deg"],

Cell["\<\
\[FilledSmallSquare] Generated when a requested root number exceeds \
the number of roots in the polynomial.\
\>", "Notes",
  CellTags->"Root::deg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Root::deg"],

Cell["\<\
An error occurs in this example because this polynomial does not \
have a third root.\
\>", "Text",
  CellTags->"Root::deg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2, 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Root::deg"],

Cell[BoxData[
    \(Root::"deg" \(\(:\)\(\ \)\) 
      "\!\(\(\(-2\)\) + x\^2\) has less than \!\(3\) root(s) as a polynomial \
in \!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Root::deg"],

Cell[BoxData[
    \(Root[\(-2\) + x\^2, 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Root::deg"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Root", "MR"],
  "."
}], "Text",
  CellTags->"Root::deg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Root::deg"],

Cell[BoxData[
    \(\@2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Root::deg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::rnum", "ObjectNameWarningMessages",
  CellTags->"General::rnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"rnum\"\>"}], \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ root\ \(\(number\)\(.\)\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::rnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression other than a positive \
integer is encountered where a root number is expected.\n\[FilledSmallSquare] \
This message can be generated by functions that use root numbers, such as ",
  StyleBox["Root", "MR"],
  ", ",
  StyleBox["Algebraic", "MR"],
  ", and ",
  StyleBox["FundamentalUnits", "MR"],
  "."
}], "Notes",
  CellTags->"General::rnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::rnum"],

Cell["\<\
An error occurs in this example because zero is not a valid root \
number.\
\>", "Text",
  CellTags->"General::rnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::rnum"],

Cell[BoxData[
    \(Root::"rnum" \(\(:\)\(\ \)\) 
      "\!\(0\) is not a valid root number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::rnum"],

Cell[BoxData[
    \(Root[\(-2\) + x\^2, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::rnum"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Root", "MR"],
  "."
}], "Text",
  CellTags->"General::rnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::rnum"],

Cell[BoxData[
    \(\@2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::rnum"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::rnv", "ObjectNameWarningMessages",
  CellTags->"Root::rnv"],

Cell[BoxData[
    RowBox[{\(Root::"rnv"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ neither\ a\ valid\ variable\ nor\ a\ valid\ root\
\ \(\(number\)\(.\)\)\)\)}]], "Message",
  CellTags->"Root::rnv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Root", "MR"],
  " is used with three arguments and the second argument is not a positive \
integer or a valid variable."
}], "Notes",
  CellTags->"Root::rnv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Root::rnv"],

Cell["\<\
An error occurs in this example because a power is not a valid \
variable.\
\>", "Text",
  CellTags->"Root::rnv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2, x^2, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Root::rnv"],

Cell[BoxData[
    \(Root::"rnv" \(\(:\)\(\ \)\) 
      "\!\(x\^2\) is neither a valid variable nor a valid root number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Root::rnv"],

Cell[BoxData[
    \(Root[\(-2\) + x\^2, x\^2, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Root::rnv"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Root", "MR"],
  "."
}], "Text",
  CellTags->"Root::rnv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2, x, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Root::rnv"],

Cell[BoxData[
    \(\@2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Root::rnv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::var", "ObjectNameWarningMessages",
  CellTags->"Root::var"],

Cell[BoxData[
    RowBox[{\(Root::"var"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ \(\(variable\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Root::var"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Root", "MR"],
  " is used with three arguments and the second argument is not a valid \
variable."
}], "Notes",
  CellTags->"Root::var"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Root::var"],

Cell["\<\
An error occurs in this example because the second argument is a \
number. A number is not a valid variable.\
\>", "Text",
  CellTags->"Root::var"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2  y^2, 2, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Root::var"],

Cell[BoxData[
    \(Root::"var" \(\(:\)\(\ \)\) 
      "\!\(2\) is not a valid variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Root::var"],

Cell[BoxData[
    \(Root[x\^2 - 2\ y\^2, 2, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Root::var"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Root", "MR"],
  "."
}], "Text",
  CellTags->"Root::var"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Root[x^2 - 2  y^2, x, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Root::var"],

Cell[BoxData[
    \(\@2\ \@y\^2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Root::var"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RootSum::pfn", "ObjectNameWarningMessages",
  CellTags->"RootSum::pfn"],

Cell[BoxData[
    RowBox[{\(RootSum::"pfn"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ pure\ \(\(function\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"RootSum::pfn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["RootSum", "MR"],
  " is not a ",
  StyleBox["Function", "MR"],
  " expression."
}], "Notes",
  CellTags->"RootSum::pfn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"RootSum::pfn"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["RootSum", "MR"],
  " is a polynomial rather than a ",
  StyleBox["Function", "MR"],
  " expression."
}], "Text",
  CellTags->"RootSum::pfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RootSum[2 + x - x^2, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"RootSum::pfn"],

Cell[BoxData[
    \(RootSum::"pfn" \(\(:\)\(\ \)\) 
      "\!\(2 + x - x\^2\) is not a pure function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"RootSum::pfn"],

Cell[BoxData[
    \(RootSum[2 + x - x\^2, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"RootSum::pfn"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["RootSum", "MR"],
  "."
}], "Text",
  CellTags->"RootSum::pfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RootSum[2 + # - #1\^2 &, Identity]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"RootSum::pfn"],

Cell[BoxData[
    \(RootSum[2 + #1 - #1\^2 &, Identity]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"RootSum::pfn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Roots::badmod", "ObjectNameWarningMessages",
  CellTags->"Roots::badmod"],

Cell[BoxData[
    RowBox[{\(Roots::"badmod"\), \(\(:\)\(\ \)\), "Cannot", " ", "extract", 
      " ", "roots", " ", "of", " ", "input", " ", "modulo", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Roots::badmod"],

Cell["\<\
\[FilledSmallSquare] Generated by a failure to factor a nonzero \
modulus.
\[FilledSmallSquare] This error can occur if the modulus is a large prime \
number or an integer with large prime factors.\
\>", "Notes",
  CellTags->"Roots::badmod"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::esss", "ObjectNameWarningMessages",
  CellTags->"Series::esss"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), \(\(Essential\)\(\ \
\)\(singularity\)\(\ \)\(encountered\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Series::esss"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Series", "MR"],
  " includes a subexpression that has an essential singularity.\n\
\[FilledSmallSquare] This error can occur if an attempt is made to compute a \
power or a trigonometric or hyperbolic function of a series expansion in \
which the leading exponent is negative."
}], "Notes",
  CellTags->"Series::esss"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Series::esss"],

Cell["\<\
An error occurs in this example because the argument function has \
an essential singularity at the expansion point.\
\>", "Text",
  CellTags->"Series::esss"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Sin[1/x], {x, 0, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Series::esss"],

Cell[BoxData[
    RowBox[{\(Series::"esss"\), \(\(:\)\(\ \)\), "\<\"Essential singularity \
encountered in \\!\\(Sin[\\(\\(\\*InterpretationBox[\\(1\\/x + \
\\*InterpretationBox[\\(\\(O[x]\\)\\^4\\), SeriesData[x, 0, List[], -1, 4, \
1], Rule[Editable, False]]\\), SeriesData[x, 0, List[1], -1, 4, 1], \
Rule[Editable, False]]\\)\\)]\\).\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Series::esss"],

Cell[BoxData[
    \(Sin[1\/x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Series::esss"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::icm", "ObjectNameWarningMessages",
  CellTags->"Series::icm"],

Cell[BoxData[
    RowBox[{\(Series::"icm"\), \(\(:\)\(\ \)\), \(\(Series\)\(\ \)\(in\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], " ", "to", " ", "be", " ", "combined", " ", "have", " ", 
      "unequal", " ", "expansion", " ", "points", " ", 
      StyleBox["x1",
        "TI"], " ", "and", " ", 
      RowBox[{
        StyleBox["x2",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Series::icm"],

Cell["\<\
\[FilledSmallSquare] Generated when two series expansions to be \
added, multiplied, or otherwise combined do not have the same expansion \
point.\
\>", "Notes",
  CellTags->"Series::icm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Series::icm"],

Cell["\<\
An error occurs in this example because series expansions around \
different expansion points cannot be added together.\
\>", "Text",
  CellTags->"Series::icm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Sin[x], {x, 1, 2}] + Series[Cos[x], {x, 2, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Series::icm"],

Cell[BoxData[
    \(Series::"icm" \(\(:\)\(\ \)\) 
      "Series in \!\(x\) to be combined have unequal expansion points \!\(1\) \
and \!\(2\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Series::icm"],

Cell[BoxData[
    RowBox[{
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(Sin[1]\), "+", \(Cos[1]\ \((x - 1)\)\), 
            "-", \(1\/2\ Sin[1]\ \((x - 1)\)\^2\), "+", 
            InterpretationBox[\(O[x - 1]\^3\),
              SeriesData[ x, 1, {}, 0, 3, 1],
              Editable->False]}],
          SeriesData[ x, 1, {
            Sin[ 1], 
            Cos[ 1], 
            Times[ 
              Rational[ -1, 2], 
              Sin[ 1]]}, 0, 3, 1],
          Editable->False], ")"}], "+", 
      RowBox[{"(", 
        InterpretationBox[
          
          RowBox[{\(Cos[2]\), "-", \(Sin[2]\ \((x - 2)\)\), 
            "-", \(1\/2\ Cos[2]\ \((x - 2)\)\^2\), "+", 
            InterpretationBox[\(O[x - 2]\^3\),
              SeriesData[ x, 2, {}, 0, 3, 1],
              Editable->False]}],
          SeriesData[ x, 2, {
            Cos[ 2], 
            Times[ -1, 
              Sin[ 2]], 
            Times[ 
              Rational[ -1, 2], 
              Cos[ 2]]}, 0, 3, 1],
          Editable->False], ")"}]}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Series::icm"]
}, Open  ]],

Cell["\<\
This shows addition of series expansions with the same expansion \
point.\
\>", "Text",
  CellTags->"Series::icm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Sin[x], {x, 1, 2}] + Series[Cos[x], {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Series::icm"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\((Cos[1] + Sin[1])\), 
        "+", \(\((Cos[1] - Sin[1])\)\ \((x - 1)\)\), 
        "+", \(\((\(-\(Cos[1]\/2\)\) - Sin[1]\/2)\)\ \((x - 1)\)\^2\), "+", 
        InterpretationBox[\(O[x - 1]\^3\),
          SeriesData[ x, 1, {}, 0, 3, 1],
          Editable->False]}],
      SeriesData[ x, 1, {
        Plus[ 
          Cos[ 1], 
          Sin[ 1]], 
        Plus[ 
          Cos[ 1], 
          Times[ -1, 
            Sin[ 1]]], 
        Plus[ 
          Times[ 
            Rational[ -1, 2], 
            Cos[ 1]], 
          Times[ 
            Rational[ -1, 2], 
            Sin[ 1]]]}, 0, 3, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Series::icm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::lss", "ObjectNameWarningMessages",
  CellTags->"Series::lss"],

Cell[BoxData[
    RowBox[{\(Series::"lss"\), \(\(:\)\(\ \)\), \(\(Logarithmic\)\(\ \
\)\(singularity\)\(\ \)\(encountered\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Series::lss"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to take the logarithm of a \
series expansion in which the coefficients depend on the expansion variable.\n\
\[FilledSmallSquare] The ",
  StyleBox["Series", "MR"],
  " algorithm is designed primarily for handling power series expansions.  \
This algorithm will fail for most expansions that cannot be approximated as \
power series."
}], "Notes",
  CellTags->"Series::lss"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::nmer", "ObjectNameWarningMessages",
  CellTags->"Series::nmer"],

Cell[BoxData[
    RowBox[{\(Series::"nmer"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "meromorphic", " ", 
      "function", " ", "of", " ", 
      StyleBox["var",
        "TI"], " ", "at", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Series::nmer"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an error while computing a series \
expansion for a ",
  StyleBox["Root", "MR"],
  " or ",
  StyleBox["RootSum", "MR"],
  " expression."
}], "Notes",
  CellTags->"Series::nmer"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::sbyc", "ObjectNameWarningMessages",
  CellTags->"Series::sbyc"],

Cell[BoxData[
    RowBox[{\(Series::"sbyc"\), \(\(:\)\(\ \)\), \(\(Division\)\(\ \)\(by\)\(\
\ \)\(a\)\(\ \)\(series\)\(\ \)\(with\)\(\ \)\(no\)\(\ \)\(coefficients\)\(\ \
\)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Series::sbyc"],

Cell["\<\
\[FilledSmallSquare] Generated when a series expansion with no \
coefficients is encountered in the denominator of an expression.\
\>", "Notes",\

  CellTags->"Series::sbyc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Series::sbyc"],

Cell["\<\
An error occurs in this example because this division is not well \
defined.\
\>", "Text",
  CellTags->"Series::sbyc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/O[x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Series::sbyc"],

Cell[BoxData[
    RowBox[{\(Series::"sbyc"\), \(\(:\)\(\ \)\), "\<\"Division by a series \
with no coefficients in \\!\\(1\\/\\*InterpretationBox[\\(\\(O[x]\\)\\^1\\), \
SeriesData[x, 0, List[], 1, 1, 1], Rule[Editable, False]]\\).\"\>"}]], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Series::sbyc"],

Cell[BoxData[
    InterpretationBox[\(1\/O[x]\),
      SeriesData[ x, 0, {}, -1, -1, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Series::sbyc"]
}, Open  ]],

Cell["This example shows a similar error.", "Text",
  CellTags->"Series::sbyc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((1 - Series[Cos[x], {x, 0, 1}])\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Series::sbyc"],

Cell[BoxData[
    RowBox[{\(Series::"sbyc"\), \(\(:\)\(\ \)\), "\<\"Division by a series \
with no coefficients in \\!\\(1\\/\\*InterpretationBox[\\(\\(O[x]\\)\\^2\\), \
SeriesData[x, 0, List[], 2, 2, 1], Rule[Editable, False]]\\).\"\>"}]], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"Series::sbyc"],

Cell[BoxData[
    InterpretationBox[\(1\/O[x]\^2\),
      SeriesData[ x, 0, {}, -2, -2, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Series::sbyc"]
}, Open  ]],

Cell["\<\
This reciprocal can be computed if more terms are kept in the \
original series.\
\>", "Text",
  CellTags->"Series::sbyc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/\((1 - Series[Cos[x], {x, 0, 3}])\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Series::sbyc"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(2\/x\^2\), "+", 
        InterpretationBox[\(O[x]\^0\),
          SeriesData[ x, 0, {}, -2, 0, 1],
          Editable->False]}],
      SeriesData[ x, 0, {2}, -2, 0, 1],
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Series::sbyc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::serlim", "ObjectNameWarningMessages",
  CellTags->"Series::serlim"],

Cell[BoxData[
    RowBox[{\(Series::"serlim"\), \(\(:\)\(\ \)\), "Series", " ", "order", 
      " ", "specification", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ machine - 
        size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Series::serlim"],

Cell["\<\
\[FilledSmallSquare] Generated when the specification of the number \
of terms to compute in a series is not an integer or cannot be represented as \
a machine integer on your computer.\
\>", "Notes",
  CellTags->"Series::serlim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Series::serlim"],

Cell["\<\
An error occurs in this example because the limit specification is \
a symbol rather than an integer.\
\>", "Text",
  CellTags->"Series::serlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Cos[x], {x, 0, x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Series::serlim"],

Cell[BoxData[
    \(Series::"serlim" \(\(:\)\(\ \)\) 
      "Series order specification \!\(x\) is not a machine-size integer."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Series::serlim"],

Cell[BoxData[
    \(Series[Cos[x], {x, 0, x}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Series::serlim"]
}, Open  ]],

Cell["\<\
This shows a valid specification for the number of terms in a \
series.\
\>", "Text",
  CellTags->"Series::serlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Cos[x], {x, 0, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Series::serlim"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"1", "-", \(x\^2\/2\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -1, 2]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Series::serlim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::sspec", "ObjectNameWarningMessages",
  CellTags->"Series::sspec"],

Cell[BoxData[
    RowBox[{\(Series::"sspec"\), \(\(:\)\(\ \)\), \(\(Series\)\(\ \
\)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ list\ with\ three\ \(\(elements\)\(.\)\)\
\)\)}]], "Message",
  CellTags->"Series::sspec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Series", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The second \
argument in ",
  StyleBox["Series", "MR"],
  " is expected to be a list giving the expansion variable, the expansion \
point, and the number of terms to compute."
}], "Notes",
  CellTags->"Series::sspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Series::sspec"],

Cell["\<\
An error occurs in this example because the second argument is a \
symbol rather than a list with three elements.\
\>", "Text",
  CellTags->"Series::sspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Cos[x], \ x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Series::sspec"],

Cell[BoxData[
    \(Series::"sspec" \(\(:\)\(\ \)\) 
      "Series specification \!\(x\) is not a list with three elements."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Series::sspec"],

Cell[BoxData[
    \(Series[Cos[x], x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Series::sspec"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Series", "MR"],
  "."
}], "Text",
  CellTags->"Series::sspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Cos[x], {x, 0, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Series::sspec"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"1", "-", \(x\^2\/2\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ -1, 2]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Series::sspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series::vcnt", "ObjectNameWarningMessages",
  CellTags->"Series::vcnt"],

Cell[BoxData[
    RowBox[{\(Series::"vcnt"\), \(\(:\)\(\ \)\), \(\(Center\)\(\ \
\)\(point\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "of", " ", "power", " ", "series", " ", "expansion", " ", 
      "involves", " ", "the", " ", "variable", " ", 
      RowBox[{
        StyleBox["var",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Series::vcnt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Series", "MR"],
  " specifies an expansion point that is not independent of the expansion \
variable."
}], "Notes",
  CellTags->"Series::vcnt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Series::vcnt"],

Cell["\<\
An error occurs in this example because the expansion point is the \
same symbol as the expansion variable.\
\>", "Text",
  CellTags->"Series::vcnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Cos[x], {x, x, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Series::vcnt"],

Cell[BoxData[
    \(Series::"vcnt" \(\(:\)\(\ \)\) 
      "Center point \!\(x\) of power series expansion involves the variable \
\!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Series::vcnt"],

Cell[BoxData[
    \(Series[Cos[x], {x, x, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Series::vcnt"]
}, Open  ]],

Cell["\<\
This shows a valid expansion point for this series expansion.\
\>", \
"Text",
  CellTags->"Series::vcnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Cos[x], {x, x0, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Series::vcnt"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(Cos[x0]\), "-", \(Sin[x0]\ \((x - x0)\)\), 
        "-", \(1\/2\ Cos[x0]\ \((x - x0)\)\^2\), 
        "+", \(1\/6\ Sin[x0]\ \((x - x0)\)\^3\), "+", 
        InterpretationBox[\(O[x - x0]\^4\),
          SeriesData[ x, x0, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, x0, {
        Cos[ x0], 
        Times[ -1, 
          Sin[ x0]], 
        Times[ 
          Rational[ -1, 2], 
          Cos[ x0]], 
        Times[ 
          Rational[ 1, 6], 
          Sin[ x0]]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Series::vcnt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::csa", "ObjectNameWarningMessages",
  CellTags->"SeriesData::csa"],

Cell[BoxData[
    RowBox[{\(SeriesData::"csa"\), \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["e",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ power\ \(\(series\)\(.\)\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SeriesData::csa"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument from ",
  StyleBox["ComposeSeries", "MR"],
  " is not a valid series expansion.\n\[FilledSmallSquare] A series expansion \
is an expression with a head of ",
  StyleBox["SeriesData", "MR"],
  "."
}], "Notes",
  CellTags->"SeriesData::csa"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::csa"],

Cell["\<\
An error occurs in this example because the second argument is not \
a series expansion.\
\>", "Text",
  CellTags->"SeriesData::csa"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComposeSeries[Series[Cos[x], {x, 0, 3}], x^2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::csa"],

Cell[BoxData[
    RowBox[{\(SeriesData::"csa"\), \(\(:\)\(\ \)\), "\<\"Argument \\!\\(x\\^2\
\\) in \\!\\(ComposeSeries[\\(\\(\\*InterpretationBox[\\(1 - x\\^2\\/2 + \
\\*InterpretationBox[\\(\\(O[x]\\)\\^4\\), SeriesData[x, 0, List[], 0, 4, 1], \
Rule[Editable, False]]\\), SeriesData[x, 0, List[1, 0, Rational[-1, 2]], 0, \
4, 1], Rule[Editable, False]], x\\^2\\)\\)]\\) is not a power \
series.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::csa"],

Cell[BoxData[
    RowBox[{"ComposeSeries", "[", 
      RowBox[{
        InterpretationBox[
          RowBox[{"1", "-", \(x\^2\/2\), "+", 
            InterpretationBox[\(O[x]\^4\),
              SeriesData[ x, 0, {}, 0, 4, 1],
              Editable->False]}],
          SeriesData[ x, 0, {1, 0, 
            Rational[ -1, 2]}, 0, 4, 1],
          Editable->False], ",", \(x\^2\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::csa"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ComposeSeries", "MR"],
  "."
}], "Text",
  CellTags->"SeriesData::csa"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComposeSeries[Series[Cos[x], {x, 0, 3}], 
      Series[x^2, {x, 0, 2}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::csa"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"1", "-", \(x\^4\/2\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 0, 0, 0, 
        Rational[ -1, 2]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::csa"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::scmn", "ObjectNameWarningMessages",
  CellTags->"SeriesData::scmn"],

Cell[BoxData[
    RowBox[{\(SeriesData::"scmn"\), \(\(:\)\(\ \)\), \(\(Order\)\(\ \
\)\(of\)\(\ \)\(series\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ \(\(negative\)\(.\)\)\)\)}]], "Message",
  CellTags->"SeriesData::scmn"],

Cell["\<\
\[FilledSmallSquare] Generated when the order of the inner series \
in series composition is negative.\
\>", "Notes",
  CellTags->"SeriesData::scmn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::scmn"],

Cell["\<\
An error occurs in this example because the order of the leading \
term in the second series expansion is negative.\
\>", "Text",
  CellTags->"SeriesData::scmn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComposeSeries[Series[x, {x, 0, 1}], Series[1/t, {t, 0, 4}]]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"SeriesData::scmn"],

Cell[BoxData[
    RowBox[{\(SeriesData::"scmn"\), \(\(:\)\(\ \)\), "\<\"Order of series \\!\
\\(\\*InterpretationBox[\\(1\\/t + \\*InterpretationBox[\\(\\(O[t]\\)\\^5\\), \
SeriesData[t, 0, List[], -1, 5, 1], Rule[Editable, False]]\\), SeriesData[t, \
0, List[1], -1, 5, 1], Rule[Editable, False]]\\) is negative.\"\>"}]], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::scmn"],

Cell[BoxData[
    RowBox[{"ComposeSeries", "[", 
      RowBox[{
        InterpretationBox[
          RowBox[{"x", "+", 
            InterpretationBox[\(O[x]\^2\),
              SeriesData[ x, 0, {}, 1, 2, 1],
              Editable->False]}],
          SeriesData[ x, 0, {1}, 1, 2, 1],
          Editable->False], ",", 
        InterpretationBox[
          RowBox[{\(1\/t\), "+", 
            InterpretationBox[\(O[t]\^5\),
              SeriesData[ t, 0, {}, -1, 5, 1],
              Editable->False]}],
          SeriesData[ t, 0, {1}, -1, 5, 1],
          Editable->False]}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::scmn"]
}, Open  ]],

Cell["\<\
A similar error will occur if a series expansion with negative \
order is substituted into another series expansion.\
\>", "Text",
  CellTags->"SeriesData::scmn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[x, {x, 0, 1}] /. x -> Series[1/t, {t, 0, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::scmn"],

Cell[BoxData[
    RowBox[{\(SeriesData::"scmn"\), \(\(:\)\(\ \)\), "\<\"Order of series \\!\
\\(\\*InterpretationBox[\\(1\\/t + \\*InterpretationBox[\\(\\(O[t]\\)\\^3\\), \
SeriesData[t, 0, List[], -1, 3, 1], Rule[Editable, False]]\\), SeriesData[t, \
0, List[1], -1, 3, 1], Rule[Editable, False]]\\) is negative.\"\>"}]], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"SeriesData::scmn"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{"(", 
          InterpretationBox[
            RowBox[{\(1\/t\), "+", 
              InterpretationBox[\(O[t]\^3\),
                SeriesData[ t, 0, {}, -1, 3, 1],
                Editable->False]}],
            SeriesData[ t, 0, {1}, -1, 3, 1],
            Editable->False], ")"}], "+", 
        InterpretationBox[
          SuperscriptBox[
            RowBox[{"O", "[", 
              InterpretationBox[
                RowBox[{\(1\/t\), "+", 
                  InterpretationBox[\(O[t]\^3\),
                    SeriesData[ t, 0, {}, -1, 3, 1],
                    Editable->False]}],
                SeriesData[ t, 0, {1}, -1, 3, 1],
                Editable->False], "]"}], "2"],
          SeriesData[ 
            SeriesData[ t, 0, {1}, -1, 3, 1], 0, {}, 1, 2, 1],
          Editable->False]}],
      SeriesData[ 
        SeriesData[ t, 0, {1}, -1, 3, 1], 0, {1}, 1, 2, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::scmn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::scmp", "ObjectNameWarningMessages",
  CellTags->"SeriesData::scmp"],

Cell[BoxData[
    RowBox[{\(SeriesData::"scmp"\), \(\(:\)\(\ \)\), "The", " ", "constant", 
      " ", "term", " ", "of", " ", "series", " ", 
      StyleBox["ser1",
        "TI"], " ", "does", " ", "not", " ", "match", " ", "the", " ", 
      "expansion", " ", "point", " ", "of", " ", 
      RowBox[{
        StyleBox["ser2",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SeriesData::scmp"],

Cell["\<\
\[FilledSmallSquare] Generated in series composition when the \
constant term of the second series is not the same as the expansion point in \
the first series.\
\>", "Notes",
  CellTags->"SeriesData::scmp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::scmp"],

Cell["\<\
An error occurs in this example because the constant term in the \
second series does not match the expansion point of the first series.\
\>", \
"Text",
  CellTags->"SeriesData::scmp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComposeSeries[Series[Cos[x], {x, 0, 3}], 
      Series[x, {x, 1, 2}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::scmp"],

Cell[BoxData[
    RowBox[{\(SeriesData::"scmp"\), \(\(:\)\(\ \)\), "\<\"The constant term \
of series \\!\\(\\*InterpretationBox[\\(\\(\\((x - 1)\\)\\) + \
\\*InterpretationBox[\\(\\(O[\\(\\(x - 1\\)\\)]\\)\\^3\\), SeriesData[x, 1, \
List[], 1, 3, 1], Rule[Editable, False]]\\), SeriesData[x, 1, List[1], 1, 3, \
1], Rule[Editable, False]]\\) does not match the expansion point of \
\\!\\(\\*InterpretationBox[\\(1 - x\\^2\\/2 + \\*InterpretationBox[\\(\\(O[x]\
\\)\\^4\\), SeriesData[x, 0, List[], 0, 4, 1], Rule[Editable, False]]\\), \
SeriesData[x, 0, List[1, 0, Rational[-1, 2]], 0, 4, 1], Rule[Editable, \
False]]\\).\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::scmp"],

Cell[BoxData[
    RowBox[{"ComposeSeries", "[", 
      RowBox[{
        InterpretationBox[
          RowBox[{"1", "-", \(x\^2\/2\), "+", 
            InterpretationBox[\(O[x]\^4\),
              SeriesData[ x, 0, {}, 0, 4, 1],
              Editable->False]}],
          SeriesData[ x, 0, {1, 0, 
            Rational[ -1, 2]}, 0, 4, 1],
          Editable->False], ",", 
        InterpretationBox[
          RowBox[{"1", "+", \((x - 1)\), "+", 
            InterpretationBox[\(O[x - 1]\^3\),
              SeriesData[ x, 1, {}, 0, 3, 1],
              Editable->False]}],
          SeriesData[ x, 1, {1, 1}, 0, 3, 1],
          Editable->False]}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::scmp"]
}, Open  ]],

Cell["This shows a valid series composition.", "Text",
  CellTags->"SeriesData::scmp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComposeSeries[Series[Cos[x], {x, 0, 3}], 
      Series[x - 1, {x, 1, 2}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::scmp"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"1", "-", \(1\/2\ \((x - 1)\)\^2\), "+", 
        InterpretationBox[\(O[x - 1]\^4\),
          SeriesData[ x, 1, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 1, {1, 0, 
        Rational[ -1, 2]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::scmp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::sdatc", "ObjectNameWarningMessages",
  CellTags->"SeriesData::sdatc"],

Cell[BoxData[
    RowBox[{\(SeriesData::"sdatc"\), \(\(:\)\(\ \)\), "Coefficient", " ", 
      "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(list\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SeriesData::sdatc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["SeriesData", "MR"],
  " is not a list.\n\[FilledSmallSquare] This message is normally seen only \
when ",
  StyleBox["SeriesData", "MR"],
  " expressions are constructed directly, rather than constructed \
automatically by ",
  StyleBox["Series", "MR"],
  ".\n\[FilledSmallSquare] This third argument in ",
  StyleBox["SeriesData", "MR"],
  " is expected to be a list of coefficients."
}], "Notes",
  CellTags->"SeriesData::sdatc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::sdatc"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["SeriesData", "MR"],
  " is a number rather than a list."
}], "Text",
  CellTags->"SeriesData::sdatc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x, b, 3, 7, 12, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::sdatc"],

Cell[BoxData[
    \(SeriesData::"sdatc" \(\(:\)\(\ \)\) 
      "Coefficient specification \!\(3\) in \!\(SeriesData[\(\(x, b, 3, 7, \
12, 1\)\)]\) is not a list."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::sdatc"],

Cell[BoxData[
    \(SeriesData[x, b, 3, 7, 12, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::sdatc"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid ",
  StyleBox["SeriesData", "MR"],
  " expression."
}], "Text",
  CellTags->"SeriesData::sdatc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x, b, {3}, 7, 12, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::sdatc"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(3\ \((x - b)\)\^7\), "+", 
        InterpretationBox[\(O[x - b]\^12\),
          SeriesData[ x, b, {}, 7, 12, 1],
          Editable->False]}],
      SeriesData[ x, b, {3}, 7, 12, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::sdatc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::sdatd", "ObjectNameWarningMessages",
  CellTags->"SeriesData::sdatd"],

Cell[BoxData[
    RowBox[{\(SeriesData::"sdatd"\), \(\(:\)\(\ \)\), "Power", " ", 
      "denominator", " ", "specification", " ", 
      StyleBox["d",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ machine - 
        size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SeriesData::sdatd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the sixth argument in ",
  StyleBox["SeriesData", "MR"],
  " is not a positive integer or is too large to be represented as a machine \
integer on your computer.\n\[FilledSmallSquare] This message is normally seen \
only if a ",
  StyleBox["SeriesData", "MR"],
  " expression is constructed directly, rather than constructed internally by \
",
  StyleBox["Series", "MR"],
  "."
}], "Notes",
  CellTags->"SeriesData::sdatd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::sdatd"],

Cell[TextData[{
  "An error occurs in this example because a list is not a valid value for \
the sixth argument in ",
  StyleBox["SeriesData", "MR"],
  "."
}], "Text",
  CellTags->"SeriesData::sdatd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x, 0, {3}, 17, 17, {}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::sdatd"],

Cell[BoxData[
    \(SeriesData::"sdatd" \(\(:\)\(\ \)\) 
      "Power denominator specification \!\({}\) in \!\(SeriesData[\(\(x, 0, \
\(\({3}\)\), 17, 17, \(\({}\)\)\)\)]\) is not a positive machine-size \
integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::sdatd"],

Cell[BoxData[
    \(SeriesData[x, 0, {3}, 17, 17, {}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::sdatd"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SeriesData", "MR"],
  "."
}], "Text",
  CellTags->"SeriesData::sdatd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x, 0, {3, 7, 5}, 17, 23, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::sdatd"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(3\ x\^\(17/2\)\), "+", \(7\ x\^9\), "+", \(5\ x\^\(19/2\)\), 
        "+", 
        InterpretationBox[\(O[x]\^\(23/2\)\),
          SeriesData[ x, 0, {}, 17, 23, 2],
          Editable->False]}],
      SeriesData[ x, 0, {3, 7, 5}, 17, 23, 2],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::sdatd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::sdatn", "ObjectNameWarningMessages",
  CellTags->"SeriesData::sdatn"],

Cell[BoxData[
    RowBox[{\(SeriesData::"sdatn"\), \(\(:\)\(\ \)\), "Order", " ", 
      "specification", " ", 
      StyleBox["ord",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ machine - 
        size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SeriesData::sdatn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when either the fourth argument or the \
fifth argument in a ",
  StyleBox["SeriesData", "MR"],
  " expression is not an integer or is an integer that cannot be represented \
as a machine integer on your computer."
}], "Notes",
  CellTags->"SeriesData::sdatn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::sdatn"],

Cell[TextData[{
  "An error occurs in this example because a list is not a valid value for \
the fifth argument in ",
  StyleBox["SeriesData", "MR"],
  "."
}], "Text",
  CellTags->"SeriesData::sdatn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x, 1, {5, 6, 7}, 5, {}, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::sdatn"],

Cell[BoxData[
    \(SeriesData::"sdatn" \(\(:\)\(\ \)\) 
      "Order specification \!\({}\) in \!\(SeriesData[\(\(x, 1, \(\({5, 6, 7}\
\)\), 5, \(\({}\)\), 1\)\)]\) is not a machine-size integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::sdatn"],

Cell[BoxData[
    \(SeriesData[x, 1, {5, 6, 7}, 5, {}, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::sdatn"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SeriesData", "MR"],
  "."
}], "Text",
  CellTags->"SeriesData::sdatn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x, 1, {5, 6, 7}, 5, 8, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::sdatn"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(5\ \((x - 1)\)\^5\), "+", \(6\ \((x - 1)\)\^6\), 
        "+", \(7\ \((x - 1)\)\^7\), "+", 
        InterpretationBox[\(O[x - 1]\^8\),
          SeriesData[ x, 1, {}, 5, 8, 1],
          Editable->False]}],
      SeriesData[ x, 1, {5, 6, 7}, 5, 8, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::sdatn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::sdatv", "ObjectNameWarningMessages",
  CellTags->"SeriesData::sdatv"],

Cell[BoxData[
    RowBox[{\(SeriesData::"sdatv"\), \(\(:\)\(\ \)\), \(\(First\)\(\ \
\)\(argument\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ \(\(variable\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"SeriesData::sdatv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the expression that occurs as the \
expansion variable in a ",
  StyleBox["SeriesData", "MR"],
  " expression cannot be used as a variable.\n\[FilledSmallSquare] Most \
expressions other than numbers, sums, products, powers, inequalities, and \
logical expressions can be used as variables."
}], "Notes",
  CellTags->"SeriesData::sdatv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::sdatv"],

Cell[TextData[{
  "An error occurs in this example because a product cannot be used as a \
variable in ",
  StyleBox["SeriesData", "MR"],
  "."
}], "Text",
  CellTags->"SeriesData::sdatv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x\ y, 0, {0, 3, 5, 6}, 5, 9, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::sdatv"],

Cell[BoxData[
    \(SeriesData::"sdatv" \(\(:\)\(\ \)\) 
      "First argument \!\(x\\ y\) is not a valid variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::sdatv"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(3\ \((x\ y)\)\^6\), "+", \(5\ \((x\ y)\)\^7\), 
        "+", \(6\ \((x\ y)\)\^8\), "+", 
        InterpretationBox[\(O[x\ y]\^9\),
          SeriesData[ 
            Times[ x, y], 0, {}, 6, 9, 1],
          Editable->False]}],
      SeriesData[ 
        Times[ x, y], 0, {3, 5, 6}, 6, 9, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::sdatv"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SeriesData", "MR"],
  "."
}], "Text",
  CellTags->"SeriesData::sdatv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesData[x, 0, {0, 3, 5, 6}, 5, 9, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::sdatv"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(3\ x\^6\), "+", \(5\ x\^7\), "+", \(6\ x\^8\), "+", 
        InterpretationBox[\(O[x]\^9\),
          SeriesData[ x, 0, {}, 6, 9, 1],
          Editable->False]}],
      SeriesData[ x, 0, {3, 5, 6}, 6, 9, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::sdatv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::slnc", "ObjectNameWarningMessages",
  CellTags->"SeriesData::slnc"],

Cell[BoxData[
    RowBox[{\(SeriesData::"slnc"\), \(\(:\)\(\ \)\), \(\(Argument\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(in\ Log\ is\ a\ series\ with\ no\ \(\(coefficients\)\
\(.\)\)\)\)}]], "Message",
  CellTags->"SeriesData::slnc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Log", "MR"],
  " is a ",
  StyleBox["SeriesData", "MR"],
  " expression with no coefficients.\n\[FilledSmallSquare] ",
  StyleBox["SeriesData", "MR"],
  " expressions are designed for representing power series expansions and can \
represent logarithmic singularities only in special cases."
}], "Notes",
  CellTags->"SeriesData::slnc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::slnc"],

Cell["\<\
An error occurs in this example because the the series has an \
indeterminate singularity.\
\>", "Text",
  CellTags->"SeriesData::slnc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[Series[x\ Cos[x], {x, 0, 0}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::slnc"],

Cell[BoxData[
    RowBox[{\(SeriesData::"slnc"\), \(\(:\)\(\ \)\), "\<\"Argument \
\\!\\(\\*InterpretationBox[\\(\\(O[x]\\)\\^1\\), SeriesData[x, 0, List[], 1, \
1, 1], Rule[Editable, False]]\\) in Log is a series with no \
coefficients.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::slnc"],

Cell[BoxData[
    RowBox[{"Log", "[", 
      InterpretationBox[\(O[x]\^1\),
        SeriesData[ x, 0, {}, 1, 1, 1],
        Editable->False], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::slnc"]
}, Open  ]],

Cell["\<\
The logarithm of a series can be computed if the leading term in \
the series is known.\
\>", "Text",
  CellTags->"SeriesData::slnc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[Series[Cos[x], {x, 0, 3}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::slnc"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(-\(x\^2\/2\)\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 2, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {
        Rational[ -1, 2]}, 2, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::slnc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeriesData::ssdn", "ObjectNameWarningMessages",
  CellTags->"SeriesData::ssdn"],

Cell[BoxData[
    RowBox[{\(SeriesData::"ssdn"\), \(\(:\)\(\ \)\), \(\(Attempt\)\(\ \
\)\(to\)\(\ \)\(evaluate\)\(\ \)\(a\)\(\ \)\(series\)\(\ \)\(at\)\(\ \
\)\(the\)\(\ \)\(number\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(;\)\(\ \)\(returning\ \(\(Indeterminate\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"SeriesData::ssdn"],

Cell["\<\
\[FilledSmallSquare] Generated when a numeric quantity occurs as \
the variable in a series expansion.\
\>", "Notes",
  CellTags->"SeriesData::ssdn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeriesData::ssdn"],

Cell["\<\
An error occurs in this example because a number cannot be used as \
the variable in a series expansion.\
\>", "Text",
  CellTags->"SeriesData::ssdn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Cos[x], {x, 0, 5}] /. x -> 1\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeriesData::ssdn"],

Cell[BoxData[
    \(SeriesData::"ssdn" \(\(:\)\(\ \)\) 
      "Attempt to evaluate a series at the number \!\(1\); returning \
Indeterminate."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeriesData::ssdn"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeriesData::ssdn"]
}, Open  ]],

Cell["\<\
A numerical value for the partial series can be computed by first \
converting the series into an ordinary polynomial.\
\>", "Text",
  CellTags->"SeriesData::ssdn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Normal[Series[Cos[x], {x, 0, 5}]] /. x -> 1\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeriesData::ssdn"],

Cell[BoxData[
    \(13\/24\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SeriesData::ssdn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FullSimplify::cfn
Simplify::cfn\
\>", "ObjectNameWarningMessages",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cfn\"\>"}], \(\(:\)\(\ \)\), "The", " ", "cost", 
      " ", "function", " ", 
      StyleBox["cf",
        "TI"], " ", "does", " ", "not", " ", "evaluate", " ", "to", " ", "a", 
      " ", "real", " ", "number", " ", "at", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ComplexityFunction", "MR"],
  " option in ",
  StyleBox["Simplify", "MR"],
  " or ",
  StyleBox["FullSimplify", "MR"],
  " does not give a real number when it is applied to the indicated \
expression."
}], "Notes",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ComplexityFunction", "MR"],
  " does not give a real number when it is applied to expressions."
}], "Text",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[1 + x + y \((1 + x)\), 
      ComplexityFunction -> \(-Length\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[BoxData[
    \(Simplify::"cfn" \(\(:\)\(\ \)\) 
      "The cost function \!\(-Length\) does not evaluate to a real number at \
\!\(1 + x + \(\(\(\((1 + x)\)\)\\ y\)\)\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[BoxData[
    \(Simplify::"cfn" \(\(:\)\(\ \)\) 
      "The cost function \!\(-Length\) does not evaluate to a real number at \
\!\(1 + x + y + \(\(x\\ y\)\)\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[BoxData[
    \(Simplify::"cfn" \(\(:\)\(\ \)\) 
      "The cost function \!\(-Length\) does not evaluate to a real number at \
\!\(1 + x + y + \(\(x\\ y\)\)\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Simplify :: \"cfn\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[BoxData[
    \(\((1 + x)\)\ \((1 + y)\)\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["ComplexityFunction", "MR"],
  " option in ",
  StyleBox["Simplify", "MR"],
  "."
}], "Text",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[1 + x + y \((1 + x)\), 
      ComplexityFunction -> \((\(-Length[#]\) &)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],

Cell[BoxData[
    \(1 + x + y + x\ y\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FullSimplify::cfn", "Simplify::cfn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FullSimplify::time
Simplify::time\
\>", "ObjectNameWarningMessages",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"time\"\>"}], \(\(:\)\(\ \)\), \(\(Time\)\(\ \)\(spent\)\(\ \
\)\(on\)\(\ \)\(a\)\(\ \)\(transformation\)\(\ \)\(exceeded\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(seconds, \ 
      and\ the\ transformation\ was\ aborted . \ 
          Increasing\ the\ value\ of\ TimeConstraint\ option\ may\ improve\ \
the\ result\ of\ \(\(simplification\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a transformation applied by ",
  StyleBox["Simplify", "MR"],
  " or ",
  StyleBox["FullSimplify", "MR"],
  " was aborted before returning.\n\[FilledSmallSquare] This message warns \
that ",
  StyleBox["Simplify", "MR"],
  " or ",
  StyleBox["FullSimplify", "MR"],
  " did not use all of the transformations that it would normally apply.\n\
\[FilledSmallSquare] This message does not necessarily indicate an error."
}], "Notes",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell["\<\
A warning message is generated in this example because one of the \
transformations that is used in an attempt to simplify this expression \
requires more than one second on the computer that was used for this example. \
 \
\>", "Text",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[1 + Cos[x]^99 - Sin[x]^99, TimeConstraint -> 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[BoxData[
    \(Simplify::"time" \(\(:\)\(\ \)\) 
      "Time spent on a transformation exceeded \!\(1\) seconds, and the \
transformation was aborted. Increasing the value of TimeConstraint option may \
improve the result of simplification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[BoxData[
    \(1 + Cos[x]\^99 - Sin[x]\^99\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FullSimplify::time", "Simplify::time"}]
}, Open  ]],

Cell[TextData[{
  "Trigonometric transformations can be excluded using the ",
  StyleBox["Trig->False", "MR"],
  " option."
}], "Text",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[1 + Cos[x]^99 - Sin[x]^99, TimeConstraint -> 1, 
      Trig -> False]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[BoxData[
    \(1 + Cos[x]\^99 - Sin[x]\^99\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FullSimplify::time", "Simplify::time"}]
}, Open  ]],

Cell[TextData[{
  "The same message can be generated by ",
  StyleBox["FullSimplify", "MR"],
  "."
}], "Text",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[1 + Cos[x]^99 - Sin[x]^99, TimeConstraint -> 1]\)], "Input",\

  CellLabel->"In[3]:=",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[BoxData[
    \(FullSimplify::"time" \(\(:\)\(\ \)\) 
      "Time spent on a transformation exceeded \!\(1\) seconds, and the \
transformation was aborted. Increasing the value of TimeConstraint option may \
improve the result of simplification."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[BoxData[
    \(1 + Cos[x]\^99 - Sin[x]\^99\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"FullSimplify::time", "Simplify::time"}]
}, Open  ]],

Cell[TextData[{
  "Specific transformations can be excluded in ",
  StyleBox["FullSimplify", "MR"],
  " using the ",
  StyleBox["ExcludedForms", "MR"],
  " option."
}], "Text",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[1 + Cos[x]^99 - Sin[x]^99, TimeConstraint -> 1, 
      ExcludedForms -> {_Cos, _Sin}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"FullSimplify::time", "Simplify::time"}],

Cell[BoxData[
    \(1 + Cos[x]\^99 - Sin[x]\^99\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"FullSimplify::time", "Simplify::time"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::circ
Roots::circ
Reduce::circ
System`Private`OldReduce::circ
Eliminate::circ
SolveAlways::circ
MainSolve::circ
AlgebraicRules::circ\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::circ", "Roots::circ", "Reduce::circ", 
    "System`Private`OldReduce::circ", "Eliminate::circ", "SolveAlways::circ", 
    "MainSolve::circ", "AlgebraicRules::circ"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"circ\"\>"}], \(\(:\)\(\ \)\), "Removing", " ", 
      "solution", " ", 
      StyleBox["expr",
        "TI"], " ", "from", " ", "list", " ", "of", " ", \(solutions . \ It\),
       " ", "results", " ", "from", " ", "an", " ", "underdetermined", " ", 
      "system", " ", "of", " ", "equations", " ", "involving", " ", 
      "transcendental", " ", \(\(functions\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Solve::circ", "Roots::circ", "Reduce::circ", 
    "System`Private`OldReduce::circ", "Eliminate::circ", "SolveAlways::circ", 
    "MainSolve::circ", "AlgebraicRules::circ"}],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{
  "Solve::circ", "Roots::circ", "Reduce::circ", 
    "System`Private`OldReduce::circ", "Eliminate::circ", "SolveAlways::circ", 
    "MainSolve::circ", "AlgebraicRules::circ"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::dinv
Eliminate::dinv
Roots::dinv
Reduce::dinv
System`Private`OldReduce::dinv
SolveAlways::dinv
GroebnerBasis::dinv
PolynomialReduce::dinv
MainSolve::dinv
AlgebraicRules::dinv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"dinv\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "expression", " ", 
        StyleBox["expr",
          "TI"], " ", "involves", " ", "unknowns", " ", "in", " ", "more", 
        " ", "than", " ", "one", " ", "argument"}], ",", 
      " ", \(so\ inverse\ functions\ cannot\ be\ \(\(used\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell["\<\
\[FilledSmallSquare] Generated when the inverse of a function is \
needed to represent a solution and the solution variable occurs in more than \
one argument of that function.\
\>", "Notes",
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell["\<\
A warning message is generated in this example because the solution \
to this equation cannot be represented using an inverse with respect to one \
of the function arguments.\
\>", "Text",
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[testf[x, x] == 1, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell[BoxData[
    \(Solve::"dinv" \(\(:\)\(\ \)\) 
      "The expression \!\(testf[\(\(x, x\)\)]\) involves unknowns in more \
than one argument, so inverse functions cannot be used."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
    "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
    "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
    "System`Private`OldReduce::dinv"}],

Cell[BoxData[
    \(Solve[testf[x, x] \[Equal] 1, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
    "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
    "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
    "System`Private`OldReduce::dinv"}]
}, Open  ]],

Cell[TextData[{
  "If the variable occurs in only one argument of the test function, the \
solution can be represented as an ",
  StyleBox["InverseFunction", "MR"],
  " expression."
}], "Text",
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[testf[x, 0] == 1, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
    "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
    "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
    "AlgebraicRules::dinv"}],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found; use Reduce for complete solution information."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{
  "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
    "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
    "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
    "System`Private`OldReduce::dinv"}],

Cell[BoxData[
    \({{x \[Rule] \(InverseFunction[testf, 1, 2]\)[1, 0]}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
    "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
    "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
    "System`Private`OldReduce::dinv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve::smod", "ObjectNameWarningMessages",
  CellTags->"Solve::smod"],

Cell[BoxData[
    \(Solve::"smod" \(\(:\)\(\ \)\) \(Unable\ to\ solve\ equations\ for\ \
\(\(modulus\)\(.\)\)\)\)], "Message",
  CellTags->"Solve::smod"],

Cell["\<\
\[FilledSmallSquare] Generated when a modulus implied by the \
equations could not be determined.\
\>", "Notes",
  CellTags->"Solve::smod"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Solve::smod"],

Cell["\<\
A warning occurs in this example because the equations are \
degenerate.\
\>", "Text",
  CellTags->"Solve::smod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x == 1, 2  x == 2}, x, Mode -> Modular]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Solve::smod"],

Cell[BoxData[
    \(Solve::"smod" \(\(:\)\(\ \)\) 
      "Unable to solve equations for modulus."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Solve::smod"],

Cell[BoxData[
    \({{x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Solve::smod"]
}, Open  ]],

Cell["The modulus is computed in this example.", "Text",
  CellTags->"Solve::smod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x == 1, 7  x == 1}, x, Mode -> Modular]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Solve::smod"],

Cell[BoxData[
    \({{Modulus \[Rule] 6, x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Solve::smod"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::solex
Roots::solex
Reduce::solex
System`Private`OldReduce::solex
Eliminate::solex
SolveAlways::solex
GroebnerBasis::solex
PolynomialReduce::solex
MainSolve::solex
AlgebraicRules::solex\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::solex", "Roots::solex", "Reduce::solex", 
    "System`Private`OldReduce::solex", "Eliminate::solex", 
    "SolveAlways::solex", "GroebnerBasis::solex", "PolynomialReduce::solex", 
    "MainSolve::solex", "AlgebraicRules::solex"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"solex\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "cannot", " ", "handle", " ", "one", " ", "of", " ", 
        "the", " ", \(\(exponents\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Solve::solex", "Roots::solex", "Reduce::solex", 
    "System`Private`OldReduce::solex", "Eliminate::solex", 
    "SolveAlways::solex", "GroebnerBasis::solex", "PolynomialReduce::solex", 
    "MainSolve::solex", "AlgebraicRules::solex"}],

Cell["\<\
\[FilledSmallSquare] Generated when the input includes an exponent \
that is too large for the current version of the indicated function or that \
the algorithm is otherwise not programmed to handle.\
\>", "Notes",
  CellTags->{
  "Solve::solex", "Roots::solex", "Reduce::solex", 
    "System`Private`OldReduce::solex", "Eliminate::solex", 
    "SolveAlways::solex", "GroebnerBasis::solex", "PolynomialReduce::solex", 
    "MainSolve::solex", "AlgebraicRules::solex"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve::svars", "ObjectNameWarningMessages",
  CellTags->"Solve::svars"],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message",
  CellLabel->"From In[28]:=",
  CellTags->"Solve::svars"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of variables listed in the \
second argument of ",
  StyleBox["Solve", "MR"],
  " is greater than the number of variables that could be determined from the \
equations."
}], "Notes",
  CellTags->"Solve::svars"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Solve::svars"],

Cell["\<\
An error occurs in this example because the number of variables is \
greater than the number of equations.\
\>", "Text",
  CellTags->"Solve::svars"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x == y + 1, y^2 == z}, {x, y, z}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Solve::svars"],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Solve::svars"],

Cell[BoxData[
    \({{x \[Rule] 1 + y, z \[Rule] y\^2}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Solve::svars"]
}, Open  ]],

Cell["\<\
Solutions are obtained for all of the variables in this \
example.\
\>", "Text",
  CellTags->"Solve::svars"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x == y + 1, y^2 == z, z == 9}, {x, y, z}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Solve::svars"],

Cell[BoxData[
    \({{x \[Rule] \(-2\), z \[Rule] 9, y \[Rule] \(-3\)}, {x \[Rule] 4, 
        z \[Rule] 9, y \[Rule] 3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Solve::svars"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TimeConstraint::nvc", "ObjectNameWarningMessages",
  CellTags->"TimeConstraint::nvc"],

Cell[BoxData[
    \(TimeConstraint::"nvc" \(\(:\)\(\ \)\) \(The\ value\ of\ TimeConstraint\ \
option\ should\ be\ a\ positive\ integer\ or\ \(\(Infinity\)\(.\)\)\)\)], \
"Message",
  CellTags->"TimeConstraint::nvc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TimeConstraint", "MR"],
  " option in ",
  StyleBox["Simplify", "MR"],
  " or ",
  StyleBox["FullSimplify", "MR"],
  " is not a positive real number."
}], "Notes",
  CellTags->"TimeConstraint::nvc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TimeConstraint::nvc"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["TimeConstraint", "MR"],
  " option."
}], "Text",
  CellTags->"TimeConstraint::nvc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Cos[37]^2 - Sin[37]^2, TimeConstraint -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TimeConstraint::nvc"],

Cell[BoxData[
    \(TimeConstraint::"nvc" \(\(:\)\(\ \)\) 
      "The value of TimeConstraint option should be a positive integer or \
Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TimeConstraint::nvc"],

Cell[BoxData[
    \(Simplify[Cos[37]\^2 - Sin[37]\^2, 
      TimeConstraint \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"TimeConstraint::nvc"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TimeConstraint", "MR"],
  " option in ",
  StyleBox["Simplify", "MR"],
  "."
}], "Text",
  CellTags->"TimeConstraint::nvc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Cos[37]^2 - Sin[37]^2, TimeConstraint -> 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TimeConstraint::nvc"],

Cell[BoxData[
    \(Cos[74]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"TimeConstraint::nvc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bmod", "ObjectNameWarningMessages",
  CellTags->"General::bmod"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"bmod\"\>"}], \(\(:\)\(\ \)\), "Modulus", " ", 
      StyleBox["expr",
        "TI"], " ", "must", " ", "be", " ", "an", " ", "integer", " ", "or", 
      " ", "an", " ", "irreducible", " ", "univariate", 
      " ", \(\(polynomial\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bmod"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["Factor", "MR"],
  " and related functions does not have the expected form."
}], "Notes",
  CellTags->"General::bmod"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bmod"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Modulus", "MR"],
  " option is not irreducible."
}], "Text",
  CellTags->"General::bmod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[2\ x^3 + 3  x + 5, Modulus -> x^2 - 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bmod"],

Cell[BoxData[
    \(Factor::"bmod" \(\(:\)\(\ \)\) 
      "Modulus \!\(\(\(-1\)\) + x\^2\) must be an integer or an irreducible \
univariate polynomial."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bmod"],

Cell[BoxData[
    \(Factor[5 + 3\ x + 2\ x\^3, Modulus \[Rule] \(-1\) + x\^2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::bmod"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Modulus", "MR"],
  " option in ",
  StyleBox["Factor", "MR"],
  "."
}], "Text",
  CellTags->"General::bmod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[2\ x^3 + 3  x + 5, Modulus -> x^2 + 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::bmod"],

Cell[BoxData[
    \(5 + x\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::bmod"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ivar", "ObjectNameWarningMessages",
  CellTags->"General::ivar"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ivar\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", 
        " ", \(\(variable\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ivar"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression cannot \
be used as a variable.
\[FilledSmallSquare] Expressions other than strings, numbers, sums, products, \
and integer powers can usually be used as variables.\
\>", "Notes",
  CellTags->"General::ivar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ivar"],

Cell[TextData[{
  "A product cannot be used as a variable in ",
  StyleBox["PolynomialQ", "MR"],
  "."
}], "Text",
  CellTags->"General::ivar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolynomialQ[x, \ 2\ x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ivar"],

Cell[BoxData[
    \(General::"ivar" \(\(:\)\(\ \)\) 
      "\!\(2\\ x\) is not a valid variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ivar"],

Cell[BoxData[
    \(PolynomialQ[x, 2\ x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ivar"]
}, Open  ]],

Cell["A number also cannot be used as a variable.", "Text",
  CellTags->"General::ivar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConstrainedMin[1 + x, {x > 3}, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ivar"],

Cell[BoxData[
    \(ConstrainedMin::"namedep" \(\(:\)\(\ \)\) 
      "The function \!\(\"ConstrainedMin\"\) has been deprecated and will be \
removed in a future version. Use the function \!\(\"NMinimize or Minimize\"\) \
instead."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::ivar"],

Cell[BoxData[
    \(ConstrainedMin::"ivar" \(\(:\)\(\ \)\) 
      "\!\(1\) is not a valid variable."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::ivar"],

Cell[BoxData[
    \(ConstrainedMin[1 + x, {x > 3}, 1]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ivar"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["ConstrainedMin", "MR"],
  "."
}], "Text",
  CellTags->"General::ivar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConstrainedMin[1 + x, {x > 3}, x]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::ivar"],

Cell[BoxData[
    \(ConstrainedMin::"namedep" \(\(:\)\(\ \)\) 
      "The function \!\(\"ConstrainedMin\"\) has been deprecated and will be \
removed in a future version. Use the function \!\(\"NMinimize or Minimize\"\) \
instead."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::ivar"],

Cell[BoxData[
    \({4, {x \[Rule] 3}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::ivar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::mext", "ObjectNameWarningMessages",
  CellTags->"General::mext"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mext\"\>"}], \(\(:\)\(\ \)\), \(Conflicting\ option\ \
setting . \ If\ Modulus\ is\ not\ 0, \ 
      then\ Extension\ should\ be\ \(\(None\)\(.\)\)\)}]], "Message",
  CellTags->"General::mext"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when both the ",
  StyleBox["Modulus", "MR"],
  " and ",
  StyleBox["Extension", "MR"],
  " options are set to non-default values.\n\[FilledSmallSquare] This message \
can be generated by ",
  StyleBox["Factor", "MR"],
  ", ",
  StyleBox["FactorList", "MR"],
  ", ",
  StyleBox["FactorSquareFree", "MR"],
  ", ",
  StyleBox["FactorSquareFreeList", "MR"],
  ", ",
  StyleBox["PolynomialGCD", "MR"],
  ", and ",
  StyleBox["Together", "MR"],
  "."
}], "Notes",
  CellTags->"General::mext"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::mext"],

Cell[TextData[{
  "The ",
  StyleBox["Modulus", "MR"],
  " and ",
  StyleBox["Extension", "MR"],
  " options cannot in general be used at the same time."
}], "Text",
  CellTags->"General::mext"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[x^2 - 2, Modulus -> 2, Extension -> Sqrt[2]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::mext"],

Cell[BoxData[
    \(Factor::"mext" \(\(:\)\(\ \)\) 
      "Conflicting option setting. If Modulus is not 0, then Extension should \
be None."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::mext"],

Cell[BoxData[
    \(Factor[\(-2\) + x\^2, Modulus \[Rule] 2, 
      Extension \[Rule] \@2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::mext"]
}, Open  ]],

Cell["Both options can be used separately.", "Text",
  CellTags->"General::mext"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[x^2 - 2, Modulus -> 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::mext"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::mext"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[x^2 - 2, Extension -> Sqrt[2]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::mext"],

Cell[BoxData[
    \(\(-\((\@2 - x)\)\)\ \((\@2 + x)\)\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::mext"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nord", "ObjectNameWarningMessages",
  CellTags->"General::nord"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nord\"\>"}], \(\(:\)\(\ \)\), "Invalid", " ", 
      "comparison", " ", "with", " ", 
      StyleBox["expr",
        "TI"], " ", \(\(attempted\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nord"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when complex numbers occur in functions \
such as ",
  StyleBox["Min", "MR"],
  " or ",
  StyleBox["Greater", "MR"],
  " that make numerical comparisons of real numbers.\n\[FilledSmallSquare] \
This message is often generated indirectly by other functions that internally \
make comparisons of real numbers."
}], "Notes",
  CellTags->"General::nord"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nord"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Min", "MR"],
  " is not defined for complex numbers."
}], "Text",
  CellTags->"General::nord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Min[{3 + I, 3 - I, 4 + I, 4 - I}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nord"],

Cell[BoxData[
    \(Min::"nord" \(\(:\)\(\ \)\) 
      "Invalid comparison with \!\(4 + \[ImaginaryI]\) attempted."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nord"],

Cell[BoxData[
    \(Min::"nord" \(\(:\)\(\ \)\) 
      "Invalid comparison with \!\(4 - \[ImaginaryI]\) attempted."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nord"],

Cell[BoxData[
    \(Min::"nord" \(\(:\)\(\ \)\) 
      "Invalid comparison with \!\(3 + \[ImaginaryI]\) attempted."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nord"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Min :: \"nord\"\) will be suppressed during this \
calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nord"],

Cell[BoxData[
    \(Min[3 - \[ImaginaryI], 3 + \[ImaginaryI], 4 - \[ImaginaryI], 
      4 + \[ImaginaryI]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nord"]
}, Open  ]],

Cell[TextData[{
  "Complex numbers can be ordered in other ways, such as using ",
  StyleBox["Sort", "MR"],
  " or ",
  StyleBox["OrderedQ", "MR"],
  ".  This ordering is based on canonical ordering of all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions rather than on mathematical ordering of real numbers."
}], "Text",
  CellTags->"General::nord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[{3 + I, 3 - I, 4 + I, 4 - I}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nord"],

Cell[BoxData[
    \({3 - \[ImaginaryI], 3 + \[ImaginaryI], 4 - \[ImaginaryI], 
      4 + \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nord"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderedQ[{3 + I, 3 - I, 4 + I, 4 - I}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::nord"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::nord"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Element::bset", "ObjectNameWarningMessages",
  CellTags->"Element::bset"],

Cell[BoxData[
    \(Element::"bset" \(\(:\)\(\ \)\) 
      "The second argument `1` of Element should be one of: Primes, Integers, \
Rationals, Algebraics, Reals, Complexes, or Booleans."\)], "Message",
  CellLabel->"From In[28]:=",
  CellTags->"Element::bset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Element", "MR"],
  " does not have one of the indicated values.\n\[FilledSmallSquare] This \
message is generated only for selected invalid values of the second argument \
in ",
  StyleBox["Element", "MR"],
  "."
}], "Notes",
  CellTags->"Element::bset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Element::bset"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["PrimeQ", "MR"],
  " is not a valid value for the second argument in ",
  StyleBox["Element", "MR"],
  "."
}], "Text",
  CellTags->"Element::bset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Element[3, PrimeQ]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Element::bset"],

Cell[BoxData[
    \(Element::"bset" \(\(:\)\(\ \)\) 
      "The second argument \!\(PrimeQ\) of Element should be one of: Primes, \
Integers, Rationals, Algebraics, Reals, Complexes, or Booleans."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Element::bset"],

Cell[BoxData[
    \(3 \[Element] PrimeQ\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Element::bset"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Element", "MR"],
  "."
}], "Text",
  CellTags->"Element::bset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Element[3, Primes]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Element::bset"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Element::bset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotElement::bset", "ObjectNameWarningMessages",
  CellTags->"NotElement::bset"],

Cell[BoxData[
    \(NotElement::"bset" \(\(:\)\(\ \)\) \(The\ second\ argument\ `1`\ of\ \
NotElement\ should\ be\ one\ \(of : \ Primes\), \ Integers, \ Rationals, \ 
      Algebraics, \ Reals, \ Complexes, \ 
      or\ \(\(Booleans\)\(.\)\)\)\)], "Message",
  CellTags->"NotElement::bset"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NotElement::bset"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bass", "ObjectNameWarningMessages",
  CellTags->"General::bass"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"bass\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "well", " ", "formed", 
        " ", \(\(assumption\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bass"],

Cell["\<\
\[FilledSmallSquare] Generated when a number or other other \
expression that cannot be used as an assumption is encountered in a position \
where a valid assumption is expected.\
\>", "Notes",
  CellTags->"General::bass"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bass"],

Cell["\<\
An error occurs in this example because a number is not a valid \
assumption.\
\>", "Text",
  CellTags->"General::bass"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Sin[n\ \[Pi]], 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bass"],

Cell[BoxData[
    \(Simplify::"bass" \(\(:\)\(\ \)\) 
      "\!\(0\) is not a well formed assumption."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bass"],

Cell[BoxData[
    \(Sin[n\ \[Pi]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::bass"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid assumption in ",
  StyleBox["Simplify", "MR"],
  "."
}], "Text",
  CellTags->"General::bass"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Sin[n\ Pi], n \[Element] Integers]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::bass"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::bass"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::altel", "ObjectNameWarningMessages",
  CellTags->"General::altel"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"altel\"\>"}], \(\(:\)\(\ \)\), "Use", " ", 
      StyleBox["expr",
        "TI"], " ", "to", " ", "specify", " ", "assumptions", " ", "for", " ",
       "multiple", " ", \(\(variables\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::altel"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an unusual expression based on ",
  StyleBox["Alternatives", "MR"],
  " is encountered in a position where an assumption is expected.\n\
\[FilledSmallSquare] This message is most often caused by an incorrect use of \
",
  StyleBox["Alternatives", "MR"],
  " in an assumption.\n\[FilledSmallSquare] ",
  StyleBox["Alternatives[p,q,r]", "MR"],
  " can be entered using the notation ",
  StyleBox["p|q|r", "MR"],
  "."
}], "Notes",
  CellTags->"General::altel"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::altel"],

Cell[TextData[{
  "A warning message is generated in this example because the second argument \
in ",
  StyleBox["Simplify", "MR"],
  " involves an unusual use of ",
  StyleBox["Alternatives", "MR"],
  "."
}], "Text",
  CellTags->"General::altel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Cos[n\ \[Pi]] + Sin[m\ \[Pi]], 
      m | n \[Element] Integers]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::altel"],

Cell[BoxData[
    \(Simplify::"altel" \(\(:\)\(\ \)\) 
      "Use \!\(\(\((m | n)\)\) \[Element] Integers\) to specify assumptions \
for multiple variables."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::altel"],

Cell[BoxData[
    \(Cos[n\ \[Pi]] + Sin[\[Pi]\ True]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::altel"]
}, Open  ]],

Cell[TextData[{
  "This shows a typical use of ",
  StyleBox["Alternatives", "MR"],
  " in the specification of assumptions."
}], "Text",
  CellTags->"General::altel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
      Cos[n\ \[Pi]] + Sin[m\ \[Pi]], \((m | n)\) \[Element] 
        Integers]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::altel"],

Cell[BoxData[
    \(\((\(-1\))\)\^n\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::altel"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::fas", "ObjectNameWarningMessages",
  CellTags->"General::fas"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fas\"\>"}], \(\(:\)\(\ \)\), \(Warning : \ 
        One\ or\ more\ assumptions\ evaluated\ to\ \(\(False\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::fas"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the symbol ",
  StyleBox["False", "MR"],
  " is encountered in a position where valid assumptions are expected."
}], "Notes",
  CellTags->"General::fas"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::fas"],

Cell[TextData[{
  "A warning message is generated in this example because the second argument \
in ",
  StyleBox["Simplify", "MR"],
  " evaluates to ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->"General::fas"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Cos[n\ \[Pi]] + Sin[n\ \[Pi]], 
      Element[n, Integers] === True]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::fas"],

Cell[BoxData[
    \(Simplify::"fas" \(\(:\)\(\ \)\) 
      "Warning: One or more assumptions evaluated to False."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::fas"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::fas"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid assumption in ",
  StyleBox["Simplify", "MR"],
  "."
}], "Text",
  CellTags->"General::fas"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Cos[n\ \[Pi]] + Sin[n\ \[Pi]], 
      Element[n, Integers]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::fas"],

Cell[BoxData[
    \(\((\(-1\))\)\^n\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::fas"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::cas", "ObjectNameWarningMessages",
  CellTags->"General::cas"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cas\"\>"}], \(\(:\)\(\ \)\), \(Warning : \ 
        Contradictory\ assumption \((s)\)\ `1`\ \
\(\(encountered\)\(.\)\)\)}]], "Message",
  CellTags->"General::cas"],

Cell["\<\
\[FilledSmallSquare] Generated when contradictory assumptions are \
encounted.\
\>", "Notes",
  CellTags->"General::cas"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::cas"],

Cell[TextData[{
  "A warning message is generated in this example because the two assumptions \
in the second argument of ",
  StyleBox["Simplify", "MR"],
  " are inconsistent with each other."
}], "Text",
  CellTags->"General::cas"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Sqrt[x^2], x < 0 && x \[Equal] 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::cas"],

Cell[BoxData[
    \(Simplify::"cas" \(\(:\)\(\ \)\) 
      "Warning: Contradictory assumption(s) \!\(\(\(x < 0\)\) && \(\(x \
\[Equal] 0\)\)\) encountered."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::cas"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::cas"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Developer`InequalityInstance::nrpi
Experimental`ExistsRealQ::nrpi
Experimental`ForAllRealQ::nrpi
Experimental`ImpliesRealQ::nrpi\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nrpi\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "logical", " ", 
        "formula", " ", "consisting", " ", "of", " ", "polynomial", " ", 
        "equations", " ", "and", " ", "inequalities", " ", "in", " ", 
        StyleBox["vars",
          "TI"], " ", "with", " ", "real", " ", "number", 
        " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated inequalities are \
expected to be described using polynomials with real coefficients.\
\>", \
"Notes",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell["\<\
An error occurs in this example because not all of the variables \
are specified.\
\>", "Text",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`InequalityInstance[x > 0\  && \ x < y, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell[BoxData[
    \(Developer`InequalityInstance::"nrpi" \(\(:\)\(\ \)\) 
      "\!\(\(\(x > 0\)\) && \(\(x < y\)\)\) is not a logical formula \
consisting of polynomial equations and inequalities in \!\({x}\) with real \
number coefficients."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell[BoxData[
    \(Developer`InequalityInstance[x > 0 && x < y, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Developer`InequalityInstance", "MR"],
  "."
}], "Text",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`InequalityInstance[x > 0\  && \ x < y, {x, y}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],

Cell[BoxData[
    \({x \[Rule] 1, y \[Rule] 2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
    "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CylindricalDecomposition::nrtpi
Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi\
\>", \
"ObjectNameWarningMessages",
  CellTags->{
  "CylindricalDecomposition::nrtpi", 
    "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nrtpi\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "logical", " ", 
        "formula", " ", "consisting", " ", "of", " ", "polynomial", " ", 
        "equations", " ", "and", " ", "inequalities", " ", "in", " ", 
        StyleBox["vars",
          "TI"], " ", "with", " ", "rational", " ", "number", 
        " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "CylindricalDecomposition::nrtpi", 
    "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}],

Cell["\<\
\[FilledSmallSquare] Generated in functions that expect \
inequalities of the indicated form.\
\>", "Notes",
  CellTags->{
  "CylindricalDecomposition::nrtpi", 
    "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Developer`InequalityInstance::weak
Experimental`ExistsRealQ::weak
Experimental`ForAllRealQ::weak
Experimental`ImpliesRealQ::weak\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
    "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"weak\"\>"}], \(\(:\)\(\ \)\), "\<\"No solution of the \
system of inequalities with inexact coefficients has been found. The solution \
`1` of the system with strong inequalities replaced by weak inequalities has \
been found. This means the original system may have solutions for some values \
of inexact coefficients within the error bounds.\"\>"}]], "Message",
  CellLabel->"From In[28]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
    "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],

Cell["\<\
\[FilledSmallSquare] Generated by difficulty in handling of \
inequalities.\
\>", "Notes",
  CellTags->{
  "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
    "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Roots::lexp", "ObjectNameWarningMessages",
  CellTags->"Roots::lexp"],

Cell[BoxData[
    \(Roots::"lexp" \(\(:\)\(\ \)\) 
      "Exponent of `1` in `2` is too large."\)], "Message",
  CellLabel->"From In[28]:=",
  CellTags->"Roots::lexp"],

Cell["\<\
\[FilledSmallSquare] Notes about this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Roots::lexp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Subresultants::slpr", "ObjectNameWarningMessages",
  CellTags->"Subresultants::slpr"],

Cell[BoxData[
    \(Subresultants::"slpr" \(\(:\)\(\ \)\) 
      "The algorithm failed due to a too low precision of input."\)], \
"Message",
  CellTags->"Subresultants::slpr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Subresultants::slpr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`CylindricalAlgebraicDecomposition::deprec", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CylindricalAlgebraicDecomposition::deprec"],

Cell[BoxData[
    \(Experimental`CylindricalAlgebraicDecomposition::"deprec" \(\(:\)\(\ \
\)\) \(Experimental`CylindricalAlgebraicDecomposition\ will\ not\ be\ \
supported\ in\ future\ versions\ of\ Mathematica . \ 
          Use\ System`CylindricalDecomposition\ \(\(instead\)\(.\)\)\)\)], \
"Message",
  CellTags->"Experimental`CylindricalAlgebraicDecomposition::deprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CylindricalAlgebraicDecomposition::deprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`Resolve::deprec", "ObjectNameWarningMessages",
  CellTags->"Experimental`Resolve::deprec"],

Cell[BoxData[
    \(Experimental`Resolve::"deprec" \(\(:\)\(\ \)\) \(Experimental`Resolve\ \
will\ not\ be\ supported\ in\ future\ versions\ of\ Mathematica . \ 
          Use\ System`Resolve\ \(\(instead\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`Resolve::deprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`Resolve::deprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::gmeth1
Internal`GroebnerWalk::gmeth1\
\>", "ObjectNameWarningMessages",
  CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"gmeth1\"\>"}], \(\(:\)\(\ \)\), \(Recursive\ use\ of\ `1`\ \
is\ \(\(invalid\)\(.\)\)\)}]], "Message",
  CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GroebnerBasis::gmeth2
Internal`GroebnerWalk::gmeth2\
\>", "ObjectNameWarningMessages",
  CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"gmeth2\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Method\  -> \ `1`\ should\ be\ Buchberger\ or\ \(\(Internal`GroebnerWalk\)\(.\
\)\)\)}]], "Message",
  CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Internal`GroebnerWalk::gstrat
GroebnerBasis::gstrat\
\>", "ObjectNameWarningMessages",
  CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"gstrat\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Strategy\  -> \ `1`\ should\ be\ SugarCube, \ 
      NormalSelection\ or\ \(\(None\)\(.\)\)\)}]], "Message",
  CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internal`GroebnerWalk::parmvar", "ObjectNameWarningMessages",
  CellTags->"Internal`GroebnerWalk::parmvar"],

Cell[BoxData[
    \(Internal`GroebnerWalk::"parmvar" \(\(:\)\(\ \)\) \(Use\ weight\ matrix\ \
instead\ of\ parameter \((s)\)\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"Internal`GroebnerWalk::parmvar"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Internal`GroebnerWalk::parmvar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterpolatingPolynomial::moddata", "ObjectNameWarningMessages",
  CellTags->"InterpolatingPolynomial::moddata"],

Cell[BoxData[
    \(InterpolatingPolynomial::"moddata" \(\(:\)\(\ \)\) \(When\ \
interpolating\ data\ with\ a\ prime\ modulus\ p, \ 
      values\ must\ be\ exact\ and\ valid\ modulo\ \(\(p\)\(.\)\)\)\)], \
"Message",
  CellTags->"InterpolatingPolynomial::moddata"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"InterpolatingPolynomial::moddata"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::dvnoarg
NDSolve::dvnoarg
RSolve::dvnoarg\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dvnoarg\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ `1`\ \
appears\ with\ no\ \(\(arguments\)\(.\)\)\)}]], "Message",
  CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function occurs \
in an equation and no arguments are given for the function.\
\>", "Notes",
  CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::ivhead
NDSolve::ivhead
RSolve::ivhead\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ivhead\"\>"}], \(\(:\)\(\ \)\), \(The\ independent\ \
variable\ `1`\ appears\ in\ the\ head\ of\ the\ expression\ `2` . \ 
          The\ independent\ variables\ should\ always\ be\ \(\(arguments\)\(.\
\)\)\)}]], "Message",
  CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::dvleaf
NDSolve::dvleaf
RSolve::dvleaf\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dvleaf\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ `1`\ \
appears\ as\ the\ head\ of\ the\ expression\ \(\(`2`\)\(.\)\)\)}]], "Message",\

  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell["\<\
\[FilledSmallSquare] Generated when a function is used incorrectly \
in an equation.\
\>", "Notes",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell["\<\
An error occurs in this example because the initial condition is \
not given in a valid form.\
\>", "Text",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] + f[x] == 0, \(f[0]\)[0] == 1}, 
      f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell[BoxData[
    \(NDSolve::"dvleaf" \(\(:\)\(\ \)\) 
      "The function \!\(f[0]\) appears as the head of the expression \
\!\(\(\(f[0]\)\)[0]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(f[x]\), "+", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
              "0"}], ",", \(\(f[0]\)[0] \[Equal] 1\)}], "}"}], ",", "f", 
        ",", \({x, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}]
}, Open  ]],

Cell["\<\
This shows a valid initial condition for this differential \
equation.\
\>", "Text",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] + f[x] == 0, f[0] == 1}, f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::der1
NDSolve::der1\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::der1", "NDSolve::der1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"der1\"\>"}], \(\(:\)\(\ \)\), \(The\ derivative\ operator\ \
`1`\ in\ `2`\ should\ operate\ on\ only\ one\ \(\(function\)\(.\)\)\)}]], \
"Message",
  CellTags->{"DSolve::der1", "NDSolve::der1"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::der1", "NDSolve::der1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::derarg
NDSolve::derarg\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::derarg", "NDSolve::derarg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"derarg\"\>"}], \(\(:\)\(\ \)\), \(The\ derivative\ \
operator\ `1`\ in\ `2`\ should\ act\ on\ the\ pure\ \
\(\(function\)\(.\)\)\)}]], "Message",
  CellTags->{"DSolve::derarg", "NDSolve::derarg"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::derarg", "NDSolve::derarg"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::nestdv
NDSolve::nestdv
RSolve::nestdv\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nestdv\"\>"}], \(\(:\)\(\ \)\), \(The\ expression\ `1`\ \
has\ nested\ dependent\ \(\(variables\)\(.\)\)\)}]], "Message",
  CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::dvlen
NDSolve::dvlen
RSolve::dvlen\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dvlen\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ `1`\ does\ \
not\ have\ the\ same\ number\ of\ arguments\ as\ independent\ variables\ \
\(\((`2`)\)\(.\)\)\)}]], "Message",
  CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialGCDModList::nogcd", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialGCDModList::nogcd"],

Cell[BoxData[
    \(Algebra`PolynomialGCDModList::"nogcd" \(\(:\)\(\ \)\) \(Cannot\ compute\
\ the\ GCD\ of\ `1`\ and\ `2`\ mod\ \(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialGCDModList::nogcd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialGCDModList::nogcd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PolynomialMod::coef", "ObjectNameWarningMessages",
  CellTags->"PolynomialMod::coef"],

Cell[BoxData[
    \(PolynomialMod::"coef" \(\(:\)\(\ \)\) \(Value\ of\ option\ \
CoefficientDomain\  -> \ `1`\ should\ be\ Integers\ or\ \
\(\(Rationals\)\(.\)\)\)\)], "Message",
  CellTags->"PolynomialMod::coef"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"PolynomialMod::coef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialMakeMonicModList::nprimemod", \
"ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialMakeMonicModList::nprimemod"],

Cell[BoxData[
    \(Algebra`PolynomialMakeMonicModList::"nprimemod" \(\(:\)\(\ \)\) \
\(Modulus\ `1`\ is\ not\ \(\(prime\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialMakeMonicModList::nprimemod"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialMakeMonicModList::nprimemod"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialModList::badmod", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialModList::badmod"],

Cell[BoxData[
    \(Algebra`PolynomialModList::"badmod" \(\(:\)\(\ \)\) \(Modulus\ `1`\ is\ \
not\ a\ positive\ \(\(integer\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialModList::badmod"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialModList::badmod"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialModList::divby0", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialModList::divby0"],

Cell[BoxData[
    \(Algebra`PolynomialModList::"divby0" \(\(:\)\(\ \)\) \(Cannot\ divide\ a\
\ univariate\ polynomial\ by\ \(\(zero\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialModList::divby0"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialModList::divby0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialModList::ninv", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialModList::ninv"],

Cell[BoxData[
    \(Algebra`PolynomialModList::"ninv" \(\(:\)\(\ \)\) \(Cannot\ invert\ `1`\
\ modulo\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialModList::ninv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialModList::ninv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialModList::nsfmod", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialModList::nsfmod"],

Cell[BoxData[
    \(Algebra`PolynomialModList::"nsfmod" \(\(:\)\(\ \)\) \(The\ polynomial\ \
`1`\ is\ not\ squarefree\ modulo\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialModList::nsfmod"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialModList::nsfmod"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialModList::unipoly", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialModList::unipoly"],

Cell[BoxData[
    \(Algebra`PolynomialModList::"unipoly" \(\(:\)\(\ \)\) \(The\ argument\ \
`1`\ is\ not\ an\ integer\ \(\(vector\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialModList::unipoly"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialModList::unipoly"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialPthRootModList::noroot", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialPthRootModList::noroot"],

Cell[BoxData[
    \(Algebra`PolynomialPthRootModList::"noroot" \(\(:\)\(\ \)\) \(The\ `1`th\
\ root\ of\ `2`\ modulo\ `1`\ does\ not\ \(\(exist\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialPthRootModList::noroot"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialPthRootModList::noroot"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`PolynomialQuotientModList::divby0", "ObjectNameWarningMessages",
  CellTags->"Algebra`PolynomialQuotientModList::divby0"],

Cell[BoxData[
    \(Algebra`PolynomialQuotientModList::"divby0" \(\(:\)\(\ \)\) \(Cannot\ \
divide\ a\ univariate\ polynomial\ by\ \(\(zero\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`PolynomialQuotientModList::divby0"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`PolynomialQuotientModList::divby0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberTheory`AlgebraicNumberFields`Algebraic::cfls", \
"ObjectNameWarningMessages",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`Algebraic::"cfls" \(\(:\)\(\ \)\) 
      "`1` is not a list of rational numbers."\)], "Message",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Algebraic", "MR"],
  " is not a list of rational numbers."
}], "Notes",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[TextData[{
  "An error is generated in this example because the second argument in ",
  StyleBox["Algebraic", "MR"],
  " is expected to be a list."
}], "Text",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`Algebraic[\((1 + #^3)\) &, 1, 
      2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`Algebraic::"cfls" \(\(:\)\(\ \)\) 
      "\!\(1\) is not a list of rational numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`Algebraic[1 + #1\^3 &, 1, 
      2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Algebraic", "MR"],
  "."
}], "Text",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`Algebraic[\((1 + #^3)\) &, {0, 1}, 
      2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`Algebraic[1 - #1 + #1\^2 &, {0, 1}, 
      1]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu\
\>", \
"ObjectNameWarningMessages",
  CellTags->"NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::"nofu" \(\(:\)\
\(\ \)\) "The number field given by `1` contains no units of infinite order."\
\)], "Message",
  CellTags->"NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel\
\>",\
 "ObjectNameWarningMessages",
  CellTags->"NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::"nnfel" \
\(\(:\)\(\ \)\) 
      "`1` does not belong to the algebraic number field generated by \
`2`."\)], "Message",
  CellTags->"NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce::bddom", "ObjectNameWarningMessages",
  CellTags->"Reduce::bddom"],

Cell[BoxData[
    \(Reduce::"bddom" \(\(:\)\(\ \)\) \(Value\ `1`\ of\ the\ domain\ argument\
\ should\ be\ Complexes, \ Reals, \ Algebraics, \ Rationals, \ Integers, \ 
      Primes, \ or\ \(\(Automatic\)\(.\)\)\)\)], "Message",
  CellTags->"Reduce::bddom"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Reduce::bddom"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::vlist
Minimize::vlist
Experimental`Infimum::vlist
Experimental`Supremum::vlist
FindInstance::vlist\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
    "Experimental`Supremum::vlist", "FindInstance::vlist"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"vlist\"\>"}], \(\(:\)\(\ \)\), \(The\ variable\ list\ `1`\ \
should\ be\ \(\(nonempty\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
    "Experimental`Supremum::vlist", "FindInstance::vlist"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
    "Experimental`Supremum::vlist", "FindInstance::vlist"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Reduce::mdom
FindInstance::mdom\
\>", "ObjectNameWarningMessages",
  CellTags->{"Reduce::mdom", "FindInstance::mdom"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"mdom\"\>"}], \(\(:\)\(\ \)\), \(Warning : \ 
        ignoring\ domain\ specification\ `1`; \ 
      option\ setting\ Modulus\  -> \ `2`\ implies\ domain\ integers\ modulo\ \
\(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->{"Reduce::mdom", "FindInstance::mdom"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Reduce::mdom", "FindInstance::mdom"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Resolve::bddom
FindInstance::bddom\
\>", "ObjectNameWarningMessages",
  CellTags->{"Resolve::bddom", "FindInstance::bddom"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bddom\"\>"}], \(\(:\)\(\ \)\), \(Value\ `1`\ of\ the\ \
domain\ argument\ should\ be\ Complexes, \ Reals, \ Algebraics, \ 
      Rationals, \ Integers, \ Primes, \ Booleans, \ 
      or\ \(\(Automatic\)\(.\)\)\)}]], "Message",
  CellTags->{"Resolve::bddom", "FindInstance::bddom"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Resolve::bddom", "FindInstance::bddom"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internal`FundamentalDiscriminantQ::nargs", "ObjectNameWarningMessages",
  CellTags->"Internal`FundamentalDiscriminantQ::nargs"],

Cell[BoxData[
    \(Internal`FundamentalDiscriminantQ::"nargs" \(\(:\)\(\ \)\) \
\(FundamentalDiscriminantQ\ called\ with\ `1`\ arguments, \ 
      1\ is\ \(\(expected\)\(.\)\)\)\)], "Message",
  CellTags->"Internal`FundamentalDiscriminantQ::nargs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Internal`FundamentalDiscriminantQ::nargs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internal`QuadraticFundamentalUnit::nargs", "ObjectNameWarningMessages",
  CellTags->"Internal`QuadraticFundamentalUnit::nargs"],

Cell[BoxData[
    \(Internal`QuadraticFundamentalUnit::"nargs" \(\(:\)\(\ \)\) \
\(QuadraticFundamentalUnit\ called\ with\ `1`\ arguments, \ 
      1\ is\ \(\(expected\)\(.\)\)\)\)], "Message",
  CellTags->"Internal`QuadraticFundamentalUnit::nargs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Internal`QuadraticFundamentalUnit::nargs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internal`QuadraticFundamentalUnit::pint", "ObjectNameWarningMessages",
  CellTags->"Internal`QuadraticFundamentalUnit::pint"],

Cell[BoxData[
    \(Internal`QuadraticFundamentalUnit::"pint" \(\(:\)\(\ \)\) 
      "The argument `1` of QuadraticFundamentalUnit is not a positive \
integer."\)], "Message",
  CellLabel->"From In[29]:=",
  CellTags->"Internal`QuadraticFundamentalUnit::pint"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Internal`QuadraticFundamentalUnit::pint"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::naqs
Reduce::naqs\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::naqs", "Reduce::naqs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"naqs\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ a\ \
quantified\ system\ of\ equations\ and\ \(\(inequalities\)\(.\)\)\)}]], \
"Message",
  CellTags->{"FindInstance::naqs", "Reduce::naqs"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::naqs", "Reduce::naqs"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce::ratnz", "ObjectNameWarningMessages",
  CellTags->"Reduce::ratnz"],

Cell[BoxData[
    \(Reduce::"ratnz" \(\(:\)\(\ \)\) \(Reduce\ was\ unable\ to\ solve\ the\ \
system\ with\ inexact\ coefficients . \ 
          The\ answer\ was\ obtained\ by\ solving\ a\ corresponding\ exact\ \
system\ and\ numericizing\ the\ \(\(result\)\(.\)\)\)\)], "Message",
  CellTags->"Reduce::ratnz"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Reduce::ratnz"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce::inex", "ObjectNameWarningMessages",
  CellTags->"Reduce::inex"],

Cell[BoxData[
    \(Reduce::"inex" \(\(:\)\(\ \)\) \(Reduce\ was\ unable\ to\ solve\ the\ \
system\ with\ inexact\ coefficients\ or\ the\ system\ obtained\ by\ direct\ \
rationalization\ of\ inexact\ numbers\ present\ in\ the\ system . \ 
          Since\ many\ of\ the\ methods\ used\ by\ Reduce\ require\ exact\ \
input, \ providing\ Reduce\ with\ an\ exact\ version\ of\ the\ system\ may\ \
\(\(help\)\(.\)\)\)\)], "Message",
  CellTags->"Reduce::inex"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Reduce::inex"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Reduce::cpow
Resolve::cpow
FindInstance::cpow\
\>", "ObjectNameWarningMessages",
  CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cpow\"\>"}], \(\(:\)\(\ \)\), \(`1`\ was\ unable\ to\ \
prove\ that\ a\ radical\ of\ an\ expression\ containing\ only\ real\ \
variables\ and\ parameters\ is\ real\ valued . \ 
          If\ you\ are\ interested\ only\ in\ solutions\ for\ which\ all\ \
radicals\ contained\ in\ the\ input\ are\ real\ valued\ use\ `1`\ with\ \
domain\ argument\ \(\(Reals\)\(.\)\)\)}]], "Message",
  CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Reduce::croot
Resolve::croot
FindInstance::croot\
\>", "ObjectNameWarningMessages",
  CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"croot\"\>"}], \(\(:\)\(\ \)\), \(`1`\ was\ unable\ to\ \
prove\ that\ a\ Root\ object\ containing\ only\ real\ variables\ and\ \
parameters\ is\ real\ valued . \ 
          If\ you\ are\ interested\ only\ in\ solutions\ for\ which\ all\ \
Root\ objects\ contained\ in\ the\ input\ are\ real\ valued\ use\ `1`\ with\ \
domain\ argument\ \(\(Reals\)\(.\)\)\)}]], "Message",
  CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::nric
Reduce::nric
Resolve::nric\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nric\"\>"}], \(\(:\)\(\ \)\), \(The\ system\ `1`\ contains\
\ a\ nonreal\ constant\ `2`\ inside\ an\ inequality . \ 
          With\ no\ domain\ argument\ given\ all\ constants\ appearing\ in\ \
inequalities\ should\ be\ \(\(real\)\(.\)\)\)}]], "Message",
  CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::nddc
Reduce::nddc
Resolve::nddc\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nddc\"\>"}], \(\(:\)\(\ \)\), \(The\ system\ `1`\ contains\
\ a\ nonreal\ constant\ `2` . \ 
          With\ the\ domain\ `3`\ specified\ all\ constants\ should\ be\ \
\(\(real\)\(.\)\)\)}]], "Message",
  CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reduce::useq", "ObjectNameWarningMessages",
  CellTags->"Reduce::useq"],

Cell[BoxData[
    \(Reduce::"useq" \(\(:\)\(\ \)\) \(The\ answer\ found\ by\ Reduce\ \
contains\ unsolved\ equation \((s)\)\ `1` . \ 
          A\ likely\ reason\ for\ this\ is\ that\ the\ solution\ set\ depends\
\ on\ branch\ cuts\ of\ Mathematica\ \(\(functions\)\(.\)\)\)\)], "Message",
  CellTags->"Reduce::useq"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Reduce::useq"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::rmod
Reduce::rmod\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::rmod", "Reduce::rmod"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"rmod\"\>"}], \(\(:\)\(\ \)\), \(Modulus\ `1`\ must\ be\ a\ \
nonnegative\ integer\ other\ than\ 1. \)}]], "Message",
  CellTags->{"FindInstance::rmod", "Reduce::rmod"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::rmod", "Reduce::rmod"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::melem
Reduce::melem\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::melem", "Reduce::melem"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"melem\"\>"}], \(\(:\)\(\ \)\), \(Cannot\ use\ Element\ \
statements\ with\ option\ setting\ Modulus\  -> \ \(\(`1`\)\(.\)\)\)}]], \
"Message",
  CellTags->{"FindInstance::melem", "Reduce::melem"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::melem", "Reduce::melem"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::mineq
Reduce::mineq\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::mineq", "Reduce::mineq"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mineq\"\>"}], \(\(:\)\(\ \)\), \(Cannot\ use\ inequalities\
\ with\ option\ setting\ Modulus\  -> \ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->{"FindInstance::mineq", "Reduce::mineq"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::mineq", "Reduce::mineq"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::mcoef
Reduce::mcoef\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mcoef\"\>"}], \(\(:\)\(\ \)\), \(The\ system\ `1`\ \
contains\ a\ nonrational\ constant\ `2` . \ 
            With\ Modulus\  -> \ `3`\ all\ constants\ should\ be\ integers\ \
or\ rational\ numbers\ with\ denominators\ invertible\ modulo\ \(\(`3`\)\(.\)\
\)\)}]], "Message",
  CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindInstance::munsp
Reduce::munsp\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindInstance::munsp", "Reduce::munsp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"munsp\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["f",
          "TI"], " ", "was", " ", "unable", " ", "to", " ", "solve", " ", 
        "the", " ", \(system . \ Increasing\), " ", "the", " ", "value", " ", 
        "of", " ", "SystemOption", " ", "MaxModularPoints", " ", "may", 
        " ", \(\(help\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindInstance::munsp", "Reduce::munsp"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindInstance::munsp", "Reduce::munsp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resultant::method", "ObjectNameWarningMessages",
  CellTags->"Resultant::method"],

Cell[BoxData[
    \(Resultant::"method" \(\(:\)\(\ \)\) \(Invalid\ method\ for\ the\ \
resultant\ \(\(computation\)\(.\)\)\)\)], "Message",
  CellTags->"Resultant::method"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Resultant::method"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resultant::var", "ObjectNameWarningMessages",
  CellTags->"Resultant::var"],

Cell[BoxData[
    \(Resultant::"var" \(\(:\)\(\ \)\) \(Not\ a\ valid\ variable\ in\ \(\(`1`\
\)\(.\)\)\)\)], "Message",
  CellTags->"Resultant::var"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Resultant::var"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root::overfl", "ObjectNameWarningMessages",
  CellTags->"Root::overfl"],

Cell[BoxData[
    \(Root::"overfl" \(\(:\)\(\ \)\) \(Overflow\ occurred\ during\ root\ \
isolation . \ The\ result\ may\ be\ \(\(incorrect\)\(.\)\)\)\)], "Message",
  CellTags->"Root::overfl"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Root::overfl"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Simplify::infd
FullSimplify::infd\
\>", "ObjectNameWarningMessages",
  CellTags->{"Simplify::infd", "FullSimplify::infd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"infd\"\>"}], \(\(:\)\(\ \)\), \(Expression\ `1`\ \
simplified\ to\ \(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->{"Simplify::infd", "FullSimplify::infd"}],

Cell["\<\
\[FilledSmallSquare] Generated when simplfication of an expression \
that does not contain infinite or indeterminate expressions simplifies to an \
infinite or indeterminate result.\
\>", "Notes",
  CellTags->{"Simplify::infd", "FullSimplify::infd"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Simplify::infd", "FullSimplify::infd"}],

Cell[TextData[{
  "A warning message is generated in this example because the first argument \
in ",
  StyleBox["Simplify", "MR"],
  " is infinite when the condition specified by the second argument is \
satisfied."
}], "Text",
  CellTags->{"Simplify::infd", "FullSimplify::infd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[1/x, x \[Equal] 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Simplify::infd", "FullSimplify::infd"}],

Cell[BoxData[
    \(Simplify::"infd" \(\(:\)\(\ \)\) 
      "Expression \!\(1\/x\) simplified to \!\(ComplexInfinity\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FullSimplify::infd", "Simplify::infd"}],

Cell[BoxData[
    \(ComplexInfinity\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FullSimplify::infd", "Simplify::infd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solve::ifun2
Eliminate::ifun2
Reduce::ifun2
SolveAlways::ifun2
MainSolve::ifun2
AlgebraicRules::ifun2
System`Private`OldReduce::ifun2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", "SolveAlways::ifun2", 
    "MainSolve::ifun2", "AlgebraicRules::ifun2", 
    "System`Private`OldReduce::ifun2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ifun2\"\>"}], \(\(:\)\(\ \)\), \(Cannot\ obtain\ solution\ \
with\ InverseFunctions -> False\ option\ \(\(setting\)\(.\)\)\)}]], "Message",\

  CellTags->{
  "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", "SolveAlways::ifun2", 
    "MainSolve::ifun2", "AlgebraicRules::ifun2", 
    "System`Private`OldReduce::ifun2"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", "SolveAlways::ifun2", 
    "MainSolve::ifun2", "AlgebraicRules::ifun2", 
    "System`Private`OldReduce::ifun2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig", \
"ObjectNameWarningMessages",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig"],

Cell[BoxData[
    \(Algebra`SymmetricPolynomials`SymmetricPolynomial::"toobig" \(\(:\)\(\ \
\)\) \(Cannot\ create\ a\ polynomial\ with\ `1`\ \(\(terms\)\(.\)\)\)\)], \
"Message",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint", \
"ObjectNameWarningMessages",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint"],

Cell[BoxData[
    \(Algebra`SymmetricPolynomials`SymmetricPolynomial::"nmint" \(\(:\)\(\ \)\
\) \(`1`\ is\ not\ a\ nonnegative\ machine\ \(\(integer\)\(.\)\)\)\)], \
"Message",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg", \
"ObjectNameWarningMessages",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg"],

Cell[BoxData[
    \(Algebra`SymmetricPolynomials`SymmetricPolynomial::"hideg" \(\(:\)\(\ \)\
\) \(The\ degree\ `1`\ of\ an\ elementary\ symmetric\ polynomial\ cannot\ be\ \
higher\ that\ the\ number\ of\ variables\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl
Algebra`SymmetricPolynomials`SymmetricReduction::nvarl\
\>", \
"ObjectNameWarningMessages",
  CellTags->{
  "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
    "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nvarl\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ a\ list\ of\
\ \(\(variables\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
    "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
    "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`SymmetricPolynomials`SymmetricReduction::neql", \
"ObjectNameWarningMessages",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricReduction::neql"],

Cell[BoxData[
    \(Algebra`SymmetricPolynomials`SymmetricReduction::"neql" \(\(:\)\(\ \)\) \
\(Lists\ `1`\ and\ `2`\ have\ different\ \(\(lengths\)\(.\)\)\)\)], "Message",\

  CellTags->"Algebra`SymmetricPolynomials`SymmetricReduction::neql"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`SymmetricPolynomials`SymmetricReduction::neql"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::cadpr", "ObjectNameWarningMessages",
  CellTags->"General::cadpr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cadpr\"\>"}], \(\(:\)\(\ \)\), \(The\ cylindrical\ \
algebraic\ decomposition\ algorithm\ used\ by\ `1`\ failed\ due\ to\ a\ too\ \
low\ WorkingPrecision . \ 
          Increasing\ the\ value\ of\ WorkingPrecision\ may\ allow\ the\ \
algorithm\ to\ \(\(succeed\)\(.\)\)\)}]], "Message",
  CellTags->"General::cadpr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by functions such as ",
  StyleBox["Resolve", "MR"],
  " and ",
  StyleBox["CylindricalAlgebraicDecomposition", "MR"],
  ". This message can also be generated by functions such as ",
  StyleBox["Reduce", "MR"],
  " that use cylindrical algebraic decomposition."
}], "Notes",
  CellTags->"General::cadpr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::naobj", "ObjectNameWarningMessages",
  CellTags->"General::naobj"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"naobj\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", 
        "Algebraic", " ", \(\(object\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::naobj"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by number field functions that expect an \
valid ",
  StyleBox["Algebraic", "MR"],
  " expression in input."
}], "Notes",
  CellTags->"General::naobj"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::naobj"],

Cell[TextData[{
  "An error message is generated in this example because the argument in ",
  StyleBox["NumberFieldNorm", "MR"],
  " evaluates to ",
  StyleBox["0", "MR"],
  ", which is not an ",
  StyleBox["Algebraic", "MR"],
  " expression."
}], "Text",
  CellTags->"General::naobj"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`NumberFieldNorm[
      NumberTheory`AlgebraicNumberFields`Algebraic[1 - #1^2 &, {1, 1}, 
        1]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::naobj"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`NumberFieldNorm::"naobj" \(\(:\)\(\ \
\)\) "\!\(0\) is not a valid Algebraic object."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::naobj"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`NumberFieldNorm[0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::naobj"]
}, Open  ]],

Cell[TextData[{
  "This shows an intended use of ",
  StyleBox["NumberFieldNorm", "MR"],
  "."
}], "Text",
  CellTags->"General::naobj"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`NumberFieldNorm[
      NumberTheory`AlgebraicNumberFields`Algebraic[1 + #1^2 &, {1, 1}, 
        1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::naobj"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::naobj"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::niupf", "ObjectNameWarningMessages",
  CellTags->"General::niupf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"niupf\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "an", " ", "irreducible", " ", 
        "univariate", " ", "polynomial", " ", "function", " ", "with", " ", 
        "rational", " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::niupf"],

Cell["\<\
\[FilledSmallSquare] Generated by number field functions that \
expect an irreducible univariate polynomial as an argument.\
\>", "Notes",
  CellTags->"General::niupf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::niupf"],

Cell[TextData[{
  "An error message is generated in this example because the argument in ",
  StyleBox["IntegralBasis", "MR"],
  " represents a reducible polynomial."
}], "Text",
  CellTags->"General::niupf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`IntegralBasis[\((#^2 - 
            4)\) &]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::niupf"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`IntegralBasis::"niupf" \(\(:\)\(\ \)\
\) "\!\(\(\(#1\^2 - 4\)\) &\) is not an irreducible univariate polynomial \
function with rational coefficients."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::niupf"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`IntegralBasis[#1\^2 - 
          4 &]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::niupf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[\(\((#^2 - 4)\) &\)[x]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::niupf"],

Cell[BoxData[
    \(\((\(-2\) + x)\)\ \((2 + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::niupf"]
}, Open  ]],

Cell[TextData[{
  "This shows an intended use of ",
  StyleBox["IntegralBasis", "MR"],
  " for a polynomial that cannot be factored over the integers."
}], "Text",
  CellTags->"General::niupf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`IntegralBasis[\((#^2 - 
            5)\) &]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::niupf"],

Cell[BoxData[
    \({1, 
      NumberTheory`AlgebraicNumberFields`Algebraic[\(-5\) + #1\^2 &, {1\/2, 
          1\/2}, 1]}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::niupf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nupf", "ObjectNameWarningMessages",
  CellTags->"General::nupf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nupf\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "univariate", " ", 
        "polynomial", " ", "function", " ", "with", " ", "rational", 
        " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nupf"],

Cell["\<\
\[FilledSmallSquare] Generated by number field functions that \
expect an argument that is a function corresponding to univariate polynomial \
with rational coefficients.\
\>", "Notes",
  CellTags->"General::nupf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nupf"],

Cell[TextData[{
  "An error message is generated in this example because the argument of ",
  StyleBox["FundamentalUnits", "MR"],
  " is not a function."
}], "Text",
  CellTags->"General::nupf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`FundamentalUnits[\((1 + # - #^4)\), 
      1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nupf"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`FundamentalUnits::"nupf" \(\(:\)\(\ \
\)\) "\!\(1 + #1 - #1\^4\) is not a univariate polynomial function with \
rational coefficients."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nupf"],

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`FundamentalUnits[1 + #1 - #1\^4, 
      1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nupf"]
}, Open  ]],

Cell[TextData[{
  "This shows an intended use of ",
  StyleBox["FundamentalUnits", "MR"],
  "."
}], "Text",
  CellTags->"General::nupf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberTheory`AlgebraicNumberFields`FundamentalUnits[\((1 + # - #^4)\) \
&, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nupf"],

Cell[BoxData[
    \({NumberTheory`AlgebraicNumberFields`Algebraic[\(-1\) - #1 + #1\^4 &, \
{0, \(-1\), 0, 0}, 1], 
      NumberTheory`AlgebraicNumberFields`Algebraic[\(-1\) - #1 + #1\^4 &, {0, 
          1, \(-1\), 0}, 1]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nupf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Factor::facim
FactorSquareFree::facim\
\>", "ObjectNameWarningMessages",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"facim\"\>"}], \(\(:\)\(\ \)\), \(Factoring\ non - 
        integer\ polynomials\ with\ respect\ to\ a\ modulus\ is\ not\ \
\(\(implemented\)\(.\)\)\)}]], "Message",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a nonzero value for the ",
  StyleBox["Modulus", "MR"],
  " option is used in ",
  StyleBox["Factor", "MR"],
  " or ",
  StyleBox["FactorSquareFree", "MR"],
  ", and the polynomial to be factored includes coefficients that are not \
integers."
}], "Notes",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}],

Cell["\<\
An error occurs in this example because one of the coefficients in \
the polynomial to be factored is a complex number rather than an \
integer.\
\>", "Text",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[I\  - x, Modulus -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}],

Cell[BoxData[
    \(Factor::"facim" \(\(:\)\(\ \)\) 
      "Factoring non-integer polynomials with respect to a modulus is not \
implemented."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}],

Cell[BoxData[
    \(Factor[\[ImaginaryI] - x, Modulus \[Rule] 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Factor::facim", "FactorSquareFree::facim"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindInstance::boolv", "ObjectNameWarningMessages",
  CellTags->"FindInstance::boolv"],

Cell[BoxData[
    \(FindInstance::"boolv" \(\(:\)\(\ \)\) \(The\ system\ is\ not\ Boolean\ \
valued\ at\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"FindInstance::boolv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindInstance::boolv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindInstance::exvar", "ObjectNameWarningMessages",
  CellTags->"FindInstance::exvar"],

Cell[BoxData[
    \(FindInstance::"exvar" \(\(:\)\(\ \)\) \(The\ system\ contains\ a\ \
nonconstant\ expression\ `1`\ independent\ of\ variables\ \
\(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"FindInstance::exvar"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindInstance::exvar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindInstance::fwsol", "ObjectNameWarningMessages",
  CellTags->"FindInstance::fwsol"],

Cell[BoxData[
    \(FindInstance::"fwsol" \(\(:\)\(\ \)\) \(Warning : \ 
        FindInstance\ found\ only\ `1`\ instance \((s)\), \ 
      but\ it\ was\ not\ able\ to\ prove\ `2`\ instances\ do\ not\ \
\(\(exist\)\(.\)\)\)\)], "Message",
  CellTags->"FindInstance::fwsol"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindInstance::fwsol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindInstance::nsmet", "ObjectNameWarningMessages",
  CellTags->"FindInstance::nsmet"],

Cell[BoxData[
    \(FindInstance::"nsmet" \(\(:\)\(\ \)\) \(The\ methods\ available\ to\ \
FindInstance\ are\ insufficient\ to\ find\ the\ requested\ instances\ or\ \
prove\ they\ do\ not\ \(\(exist\)\(.\)\)\)\)], "Message",
  CellTags->"FindInstance::nsmet"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindInstance::nsmet"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ncomp", "ObjectNameWarningMessages",
  CellTags->"General::ncomp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ncomp\"\>"}], \(\(:\)\(\ \)\), \(Unable\ to\ decide\ \
whether\ `1`\ and\ `2`\ are\ equal . \ 
          Assuming\ they\ \(\(are\)\(.\)\)\)}]], "Message",
  CellTags->"General::ncomp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::ncomp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PolynomialMod::polyi", "ObjectNameWarningMessages",
  CellTags->"PolynomialMod::polyi"],

Cell[BoxData[
    \(PolynomialMod::"polyi" \(\(:\)\(\ \)\) \(`1`\ is\ not\ valid\ input\ \
for\ \(\(PolynomialMod\)\(.\)\)\)\)], "Message",
  CellTags->"PolynomialMod::polyi"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"PolynomialMod::polyi"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::consc
Minimize::consc
Experimental`Infimum::consc
Experimental`Supremum::consc\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
    "Experimental`Supremum::consc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"consc\"\>"}], \(\(:\)\(\ \)\), \(The\ constraint\ `1`\ \
contains\ a\ nonreal\ constant\ \(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
    "Experimental`Supremum::consc"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
    "Experimental`Supremum::consc"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::consf
Minimize::consf
Experimental`Infimum::consf
Experimental`Supremum::consf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
    "Experimental`Supremum::consf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"consf\"\>"}], \(\(:\)\(\ \)\), \(Invalid\ constraint\ `1`\ \
encountered . \ Constraints\ should\ be\ equations, \ 
      inequalities\ or\ variable\ domain\ \(\(specifications\)\(.\)\)\)}]], \
"Message",
  CellTags->{
  "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
    "Experimental`Supremum::consf"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
    "Experimental`Supremum::consf"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::consv
Minimize::consv
Experimental`Infimum::consv
Experimental`Supremum::consv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
    "Experimental`Supremum::consv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"consv\"\>"}], \(\(:\)\(\ \)\), \(The\ constraint\ `1`\ \
contains\ a\ nonconstant\ expression\ `2`\ independent\ of\ variables\ \
\(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
    "Experimental`Supremum::consv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
    "Experimental`Supremum::consv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::mixdom
Minimize::mixdom
Experimental`Infimum::mixdom
Experimental`Supremum::mixdom\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
    "Experimental`Supremum::mixdom"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mixdom\"\>"}], \(\(:\)\(\ \)\), \(Exact\ optimization\ \
with\ mixed\ real\ and\ integer\ variables\ is\ not\ yet\ \
\(\(implemented\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
    "Experimental`Supremum::mixdom"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
    "Experimental`Supremum::mixdom"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::objc
Minimize::objc
Experimental`Infimum::objc
Experimental`Supremum::objc\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
    "Experimental`Supremum::objc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"objc\"\>"}], \(\(:\)\(\ \)\), \(The\ objective\ function\ \
`1`\ contains\ a\ nonreal\ constant\ \(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
    "Experimental`Supremum::objc"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
    "Experimental`Supremum::objc"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::objv
Minimize::objv
Experimental`Infimum::objv
Experimental`Supremum::objv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
    "Experimental`Supremum::objv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"objv\"\>"}], \(\(:\)\(\ \)\), \(The\ objective\ function\ \
`1`\ contains\ a\ nonconstant\ expression\ `2`\ independent\ of\ variables\ \
\(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
    "Experimental`Supremum::objv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
    "Experimental`Supremum::objv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::vdom
Minimize::vdom
Experimental`Infimum::vdom
Experimental`Supremum::vdom\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
    "Experimental`Supremum::vdom"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"vdom\"\>"}], \(\(:\)\(\ \)\), \(Variable\ domain\ `1`\ \
should\ be\ either\ Reals\ or\ \(\(Integers\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
    "Experimental`Supremum::vdom"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
    "Experimental`Supremum::vdom"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`MatrixPowerMod::arg1", "ObjectNameWarningMessages",
  CellTags->"Algebra`MatrixPowerMod::arg1"],

Cell[BoxData[
    \(Algebra`MatrixPowerMod::"arg1" \(\(:\)\(\ \)\) 
      "The first argument `1` of MatrixPowerMod is not a square matrix with \
integer coefficients."\)], "Message",
  CellLabel->"From In[112]:=",
  CellTags->"Algebra`MatrixPowerMod::arg1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`MatrixPowerMod::arg1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`MatrixPowerMod::arg2", "ObjectNameWarningMessages",
  CellTags->"Algebra`MatrixPowerMod::arg2"],

Cell[BoxData[
    \(Algebra`MatrixPowerMod::"arg2" \(\(:\)\(\ \)\) 
      "The second argument `1` of MatrixPowerMod is not an integer."\)], \
"Message",
  CellLabel->"From In[112]:=",
  CellTags->"Algebra`MatrixPowerMod::arg2"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`MatrixPowerMod::arg2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebra`MatrixPowerMod::arg3", "ObjectNameWarningMessages",
  CellTags->"Algebra`MatrixPowerMod::arg3"],

Cell[BoxData[
    \(Algebra`MatrixPowerMod::"arg3" \(\(:\)\(\ \)\) 
      "The third argument `1` of MatrixPowerMod is not a nonzero \
integer."\)], "Message",
  CellLabel->"From In[112]:=",
  CellTags->"Algebra`MatrixPowerMod::arg3"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Algebra`MatrixPowerMod::arg3"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1344}, {0, 986}},
ScreenStyleEnvironment->"Brackets",
Evaluator->"V5",
WindowSize->{689, 635},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Limit::ldir"->{
    Cell[1839, 57, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Limit::ldir"],
    Cell[1917, 60, 350, 8, 19, "Message",
      CellTags->"Limit::ldir"],
    Cell[2270, 70, 477, 15, 57, "Notes",
      CellTags->"Limit::ldir"],
    Cell[2772, 89, 61, 1, 38, "ExampleSection",
      CellTags->"Limit::ldir"],
    Cell[2836, 92, 218, 9, 23, "Text",
      CellTags->"Limit::ldir"],
    Cell[3079, 105, 125, 3, 26, "Input",
      CellTags->"Limit::ldir"],
    Cell[3207, 110, 208, 5, 19, "Message",
      CellTags->"Limit::ldir"],
    Cell[3418, 117, 137, 3, 40, "Output",
      CellTags->"Limit::ldir"],
    Cell[3570, 123, 157, 4, 23, "Text",
      CellTags->"Limit::ldir"],
    Cell[3752, 131, 118, 3, 26, "Input",
      CellTags->"Limit::ldir"],
    Cell[3873, 136, 101, 3, 25, "Output",
      CellTags->"Limit::ldir"]},
  "Limit::lim"->{
    Cell[4035, 146, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Limit::lim"],
    Cell[4111, 149, 325, 7, 19, "Message",
      CellTags->"Limit::lim"],
    Cell[4439, 158, 598, 14, 78, "Notes",
      CellTags->"Limit::lim"],
    Cell[5062, 176, 60, 1, 38, "ExampleSection",
      CellTags->"Limit::lim"],
    Cell[5125, 179, 140, 5, 23, "Text",
      CellTags->"Limit::lim"],
    Cell[5290, 188, 107, 3, 26, "Input",
      CellTags->"Limit::lim"],
    Cell[5400, 193, 185, 5, 19, "Message",
      CellTags->"Limit::lim"],
    Cell[5588, 200, 185, 5, 19, "Message",
      CellTags->"Limit::lim"],
    Cell[5776, 207, 126, 3, 25, "Output",
      CellTags->"Limit::lim"],
    Cell[5917, 213, 158, 7, 23, "Text",
      CellTags->"Limit::lim"],
    Cell[6100, 224, 107, 3, 26, "Input",
      CellTags->"Limit::lim"],
    Cell[6210, 229, 85, 3, 25, "Output",
      CellTags->"Limit::lim"],
    Cell[6310, 235, 81, 1, 22, "Text",
      CellTags->"Limit::lim"],
    Cell[6416, 240, 112, 3, 26, "Input",
      CellTags->"Limit::lim"],
    Cell[6531, 245, 167, 4, 19, "Message",
      CellTags->"Limit::lim"],
    Cell[6701, 251, 119, 3, 40, "Output",
      CellTags->"Limit::lim"]},
  "$MaxRootDegree::npi"->{
    Cell[6881, 261, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$MaxRootDegree::npi"],
    Cell[6975, 264, 309, 6, 19, "Message",
      CellTags->"$MaxRootDegree::npi"],
    Cell[7287, 272, 212, 5, 23, "Notes",
      CellTags->"$MaxRootDegree::npi"],
    Cell[7524, 281, 69, 1, 38, "ExampleSection",
      CellTags->"$MaxRootDegree::npi"],
    Cell[7596, 284, 240, 7, 37, "Text",
      CellTags->"$MaxRootDegree::npi"],
    Cell[7861, 295, 110, 3, 26, "Input",
      CellTags->"$MaxRootDegree::npi"],
    Cell[7974, 300, 227, 5, 33, "Message",
      CellTags->"$MaxRootDegree::npi"],
    Cell[8204, 307, 94, 3, 25, "Output",
      CellTags->"$MaxRootDegree::npi"]},
  "LogicalExpand::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "MainSolve::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "Roots::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "ToRules::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "Solve::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "Reduce::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "Eliminate::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "SolveAlways::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "AlgebraicRules::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "GroebnerBasis::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "PolynomialReduce::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "System`Private`OldReduce::elist"->{
    Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[8930, 337, 663, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[9596, 355, 505, 10, 37, "Notes",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10126, 369, 330, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10459, 376, 456, 11, 23, "Text",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[10940, 391, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[11321, 400, 500, 9, 19, "Message",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[11824, 411, 391, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", "ToRules::elist"}],
    
    Cell[12252, 423, 378, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
        "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist",
         "SolveAlways::elist", "AlgebraicRules::elist", 
        "GroebnerBasis::elist", "PolynomialReduce::elist", 
        "System`Private`OldReduce::elist"}],
    Cell[12633, 432, 380, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
        "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist",
         "Reduce::elist", "Roots::elist", "SolveAlways::elist", 
        "Solve::elist", "System`Private`OldReduce::elist", 
        "ToRules::elist"}]},
  "LogicalExpand::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "MainSolve::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "Roots::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "ToRules::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "Solve::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "Reduce::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "Eliminate::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "SolveAlways::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "AlgebraicRules::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "GroebnerBasis::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "PolynomialReduce::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "Internal`DistributedTermsList::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "System`Private`OldReduce::eqf"->{
    Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[13670, 467, 674, 16, 19, "Message",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[14347, 485, 717, 19, 42, "Notes",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15089, 508, 344, 5, 38, "ExampleSection",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15436, 515, 368, 5, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[15829, 524, 391, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[16223, 533, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[16706, 545, 480, 10, 21, "Message",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17189, 557, 398, 8, 27, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}],
    Cell[17602, 568, 404, 8, 22, "Text",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18031, 580, 396, 7, 26, "Input",
      CellTags->{
      "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
        "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
        "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
        "Internal`DistributedTermsList::eqf", 
        "System`Private`OldReduce::eqf"}],
    Cell[18430, 589, 403, 8, 25, "Output",
      CellTags->{
      "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
        "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
        "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", 
        "Roots::eqf", "SolveAlways::eqf", "Solve::eqf", 
        "System`Private`OldReduce::eqf", "ToRules::eqf"}]},
  "Reduce::bdomv"->{
    Cell[18894, 604, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Reduce::bdomv"],
    Cell[18976, 607, 236, 5, 33, "Message",
      CellTags->"Reduce::bdomv"],
    Cell[19215, 614, 124, 4, 22, "Notes",
      CellTags->"Reduce::bdomv"]},
  "Reduce::nsmet"->{
    Cell[19376, 623, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Reduce::nsmet"],
    Cell[19458, 626, 190, 3, 19, "Message",
      CellTags->"Reduce::nsmet"],
    Cell[19651, 631, 180, 5, 23, "Notes",
      CellTags->"Reduce::nsmet"],
    Cell[19856, 640, 63, 1, 38, "ExampleSection",
      CellTags->"Reduce::nsmet"],
    Cell[19922, 643, 153, 5, 23, "Text",
      CellTags->"Reduce::nsmet"],
    Cell[20100, 652, 118, 3, 26, "Input",
      CellTags->"Reduce::nsmet"],
    Cell[20221, 657, 225, 8, 32, "Message",
      CellTags->"Reduce::nsmet"],
    Cell[20449, 667, 161, 7, 23, "Output",
      CellTags->"Reduce::nsmet"],
    Cell[20625, 677, 138, 4, 23, "Text",
      CellTags->"Reduce::nsmet"],
    Cell[20788, 685, 118, 3, 26, "Input",
      CellTags->"Reduce::nsmet"],
    Cell[20909, 690, 117, 6, 23, "Output",
      CellTags->"Reduce::nsmet"]},
  "Root::mdeg"->{
    Cell[21087, 703, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::mdeg"],
    Cell[21163, 706, 374, 9, 19, "Message",
      CellTags->"Root::mdeg"],
    Cell[21540, 717, 454, 11, 57, "Notes",
      CellTags->"Root::mdeg"],
    Cell[22019, 732, 60, 1, 38, "ExampleSection",
      CellTags->"Root::mdeg"],
    Cell[22082, 735, 196, 5, 23, "Text",
      CellTags->"Root::mdeg"],
    Cell[22303, 744, 105, 3, 26, "Input",
      CellTags->"Root::mdeg"],
    Cell[22411, 749, 247, 5, 34, "Message",
      CellTags->"Root::mdeg"],
    Cell[22661, 756, 107, 3, 27, "Output",
      CellTags->"Root::mdeg"]},
  "Root::npoly"->{
    Cell[22829, 766, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::npoly"],
    Cell[22907, 769, 270, 7, 19, "Message",
      CellTags->"Root::npoly"],
    Cell[23180, 778, 191, 5, 23, "Notes",
      CellTags->"Root::npoly"],
    Cell[23396, 787, 61, 1, 38, "ExampleSection",
      CellTags->"Root::npoly"],
    Cell[23460, 790, 219, 6, 37, "Text",
      CellTags->"Root::npoly"],
    Cell[23704, 800, 104, 3, 26, "Input",
      CellTags->"Root::npoly"],
    Cell[23811, 805, 175, 4, 27, "Message",
      CellTags->"Root::npoly"],
    Cell[23989, 811, 101, 3, 30, "Output",
      CellTags->"Root::npoly"],
    Cell[24105, 817, 143, 5, 23, "Text",
      CellTags->"Root::npoly"],
    Cell[24273, 826, 110, 3, 26, "Input",
      CellTags->"Root::npoly"],
    Cell[24386, 831, 100, 3, 25, "Output",
      CellTags->"Root::npoly"]},
  "Root::nup"->{
    Cell[24547, 841, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::nup"],
    Cell[24621, 844, 202, 5, 19, "Message",
      CellTags->"Root::nup"],
    Cell[24826, 851, 275, 6, 42, "Notes",
      CellTags->"Root::nup"],
    Cell[25126, 861, 59, 1, 38, "ExampleSection",
      CellTags->"Root::nup"],
    Cell[25188, 864, 220, 9, 23, "Text",
      CellTags->"Root::nup"],
    Cell[25433, 877, 102, 3, 26, "Input",
      CellTags->"Root::nup"],
    Cell[25538, 882, 176, 4, 21, "Message",
      CellTags->"Root::nup"],
    Cell[25717, 888, 104, 3, 27, "Output",
      CellTags->"Root::nup"],
    Cell[25836, 894, 142, 4, 22, "Text",
      CellTags->"Root::nup"],
    Cell[26003, 902, 112, 3, 26, "Input",
      CellTags->"Root::nup"],
    Cell[26118, 907, 108, 3, 27, "Output",
      CellTags->"Root::nup"]},
  "Solve::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "MainSolve::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "Roots::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "Reduce::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "System`Private`OldReduce::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "Eliminate::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "SolveAlways::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "AlgebraicRules::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "GroebnerBasis::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "PolynomialReduce::tdep"->{
    Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[26755, 934, 535, 11, 33, "Message",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27293, 947, 596, 11, 56, "Notes",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[27914, 962, 273, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28190, 968, 332, 7, 22, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28547, 979, 322, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[28872, 987, 448, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29323, 998, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}],
    Cell[29672, 1008, 386, 8, 23, "Text",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30083, 1020, 338, 6, 26, "Input",
      CellTags->{
      "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
        "System`Private`OldReduce::tdep", "Eliminate::tdep", 
        "SolveAlways::tdep", "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
        "PolynomialReduce::tdep"}],
    Cell[30424, 1028, 333, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
        "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
        "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
        "System`Private`OldReduce::tdep"}]},
  "GroebnerBasis::varsrt"->{
    Cell[30818, 1042, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31129, 1052, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31534, 1064, 467, 13, 38, "Notes",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32026, 1081, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32212, 1086, 478, 15, 38, "Text",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32715, 1105, 304, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[33022, 1113, 332, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}],
    Cell[33357, 1122, 220, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}]},
  "PolynomialReduce::varsrt"->{
    Cell[30818, 1042, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31129, 1052, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31534, 1064, 467, 13, 38, "Notes",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32026, 1081, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32212, 1086, 478, 15, 38, "Text",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32715, 1105, 304, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[33022, 1113, 332, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}],
    Cell[33357, 1122, 220, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}]},
  "Internal`DistributedTermsList::varsrt"->{
    Cell[30818, 1042, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31129, 1052, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31534, 1064, 467, 13, 38, "Notes",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32026, 1081, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32212, 1086, 478, 15, 38, "Text",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32715, 1105, 304, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[33022, 1113, 332, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}],
    Cell[33357, 1122, 220, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}]},
  "Internal`GroebnerWalk::varsrt"->{
    Cell[30818, 1042, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31129, 1052, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[31534, 1064, 467, 13, 38, "Notes",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32026, 1081, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32212, 1086, 478, 15, 38, "Text",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[32715, 1105, 304, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
        "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt"}],
    Cell[33022, 1113, 332, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}],
    Cell[33357, 1122, 220, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
        "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}]},
  "PolynomialMod::polym"->{
    Cell[33638, 1134, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PolynomialMod::polym"],
    Cell[33734, 1137, 244, 6, 19, "Message",
      CellTags->"PolynomialMod::polym"],
    Cell[33981, 1145, 225, 5, 23, "Notes",
      CellTags->"PolynomialMod::polym"],
    Cell[34231, 1154, 70, 1, 38, "ExampleSection",
      CellTags->"PolynomialMod::polym"],
    Cell[34304, 1157, 156, 5, 23, "Text",
      CellTags->"PolynomialMod::polym"],
    Cell[34485, 1166, 129, 3, 26, "Input",
      CellTags->"PolynomialMod::polym"],
    Cell[34617, 1171, 194, 4, 34, "Message",
      CellTags->"PolynomialMod::polym"],
    Cell[34814, 1177, 125, 3, 25, "Output",
      CellTags->"PolynomialMod::polym"],
    Cell[34954, 1183, 136, 5, 23, "Text",
      CellTags->"PolynomialMod::polym"],
    Cell[35115, 1192, 121, 3, 26, "Input",
      CellTags->"PolynomialMod::polym"],
    Cell[35239, 1197, 102, 3, 25, "Output",
      CellTags->"PolynomialMod::polym"],
    Cell[35356, 1203, 164, 5, 23, "Text",
      CellTags->"PolynomialMod::polym"],
    Cell[35545, 1212, 133, 3, 26, "Input",
      CellTags->"PolynomialMod::polym"],
    Cell[35681, 1217, 105, 3, 25, "Output",
      CellTags->"PolynomialMod::polym"]},
  "Root::sbr"->{
    Cell[35847, 1227, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::sbr"],
    Cell[35921, 1230, 467, 11, 33, "Message",
      CellTags->"Root::sbr"],
    Cell[36391, 1243, 158, 5, 23, "Notes",
      CellTags->"Root::sbr"],
    Cell[36574, 1252, 59, 1, 38, "ExampleSection",
      CellTags->"Root::sbr"],
    Cell[36636, 1255, 197, 5, 36, "Text",
      CellTags->"Root::sbr"],
    Cell[36858, 1264, 128, 3, 26, "Input",
      CellTags->"Root::sbr"],
    Cell[36989, 1269, 257, 5, 34, "Message",
      CellTags->"Root::sbr"],
    Cell[37249, 1276, 793, 25, 52, "Output",
      CellTags->"Root::sbr"]},
  "AlgebraicRules::algdat"->{
    Cell[38103, 1308, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"AlgebraicRules::algdat"],
    Cell[38203, 1311, 267, 5, 19, "Message",
      CellTags->"AlgebraicRules::algdat"],
    Cell[38473, 1318, 944, 26, 108, "Notes",
      CellTags->"AlgebraicRules::algdat"],
    Cell[39442, 1348, 72, 1, 38, "ExampleSection",
      CellTags->"AlgebraicRules::algdat"],
    Cell[39517, 1351, 191, 5, 23, "Text",
      CellTags->"AlgebraicRules::algdat"],
    Cell[39733, 1360, 126, 3, 26, "Input",
      CellTags->"AlgebraicRules::algdat"],
    Cell[39862, 1365, 266, 5, 33, "Message",
      CellTags->"AlgebraicRules::algdat"],
    Cell[40131, 1372, 97, 3, 25, "Output",
      CellTags->"AlgebraicRules::algdat"],
    Cell[40243, 1378, 204, 7, 23, "Text",
      CellTags->"AlgebraicRules::algdat"],
    Cell[40472, 1389, 125, 3, 26, "Input",
      CellTags->"AlgebraicRules::algdat"],
    Cell[40600, 1394, 97, 3, 25, "Output",
      CellTags->"AlgebraicRules::algdat"]},
  "AlgebraicRules::newv"->{
    Cell[40758, 1404, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"AlgebraicRules::newv"],
    Cell[40854, 1407, 349, 10, 19, "Message",
      CellTags->"AlgebraicRules::newv"],
    Cell[41206, 1419, 757, 20, 73, "Notes",
      CellTags->"AlgebraicRules::newv"],
    Cell[41988, 1443, 70, 1, 38, "ExampleSection",
      CellTags->"AlgebraicRules::newv"],
    Cell[42061, 1446, 248, 6, 37, "Text",
      CellTags->"AlgebraicRules::newv"],
    Cell[42334, 1456, 126, 3, 26, "Input",
      CellTags->"AlgebraicRules::newv"],
    Cell[42463, 1461, 202, 4, 19, "Message",
      CellTags->"AlgebraicRules::newv"],
    Cell[42668, 1467, 98, 3, 27, "Output",
      CellTags->"AlgebraicRules::newv"]},
  "Solve::incnst"->{
    Cell[42827, 1477, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Solve::incnst"],
    Cell[42909, 1480, 338, 7, 33, "Message",
      CellTags->"Solve::incnst"],
    Cell[43250, 1489, 238, 6, 37, "Notes",
      CellTags->"Solve::incnst"],
    Cell[43513, 1499, 63, 1, 38, "ExampleSection",
      CellTags->"Solve::incnst"],
    Cell[43579, 1502, 155, 4, 22, "Text",
      CellTags->"Solve::incnst"],
    Cell[43759, 1510, 130, 3, 26, "Input",
      CellTags->"Solve::incnst"],
    Cell[43892, 1515, 284, 6, 33, "Message",
      CellTags->"Solve::incnst"],
    Cell[44179, 1523, 264, 5, 33, "Message",
      CellTags->"Solve::incnst"],
    Cell[44446, 1530, 196, 5, 19, "Message",
      CellTags->"Solve::incnst"],
    Cell[44645, 1537, 89, 3, 25, "Output",
      CellTags->"Solve::incnst"]},
  "Coefficient::numv"->{
    Cell[44795, 1547, 130, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[44928, 1553, 379, 11, 19, "Message",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[45310, 1566, 538, 15, 58, "Notes",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[45873, 1585, 87, 1, 38, "ExampleSection",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[45963, 1588, 198, 5, 23, "Text",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46186, 1597, 131, 3, 26, "Input",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46320, 1602, 260, 5, 19, "Message",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46583, 1609, 201, 4, 19, "Message",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46787, 1615, 132, 3, 25, "Output",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46934, 1621, 185, 4, 22, "Text",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[47144, 1629, 134, 3, 26, "Input",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[47281, 1634, 117, 3, 25, "Output",
      CellTags->{"Coefficient::numv", "Exponent::numv"}]},
  "Exponent::numv"->{
    Cell[44795, 1547, 130, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[44928, 1553, 379, 11, 19, "Message",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[45310, 1566, 538, 15, 58, "Notes",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[45873, 1585, 87, 1, 38, "ExampleSection",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[45963, 1588, 198, 5, 23, "Text",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46186, 1597, 131, 3, 26, "Input",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46320, 1602, 260, 5, 19, "Message",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46583, 1609, 201, 4, 19, "Message",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46787, 1615, 132, 3, 25, "Output",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[46934, 1621, 185, 4, 22, "Text",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[47144, 1629, 134, 3, 26, "Input",
      CellTags->{"Coefficient::numv", "Exponent::numv"}],
    Cell[47281, 1634, 117, 3, 25, "Output",
      CellTags->{"Coefficient::numv", "Exponent::numv"}]},
  "ComplexExpand::exf"->{
    Cell[47459, 1644, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ComplexExpand::exf"],
    Cell[47551, 1647, 405, 9, 33, "Message",
      CellTags->"ComplexExpand::exf"],
    Cell[47959, 1658, 614, 22, 57, "Notes",
      CellTags->"ComplexExpand::exf"],
    Cell[48598, 1684, 68, 1, 38, "ExampleSection",
      CellTags->"ComplexExpand::exf"],
    Cell[48669, 1687, 221, 5, 37, "Text",
      CellTags->"ComplexExpand::exf"],
    Cell[48915, 1696, 152, 4, 26, "Input",
      CellTags->"ComplexExpand::exf"],
    Cell[49070, 1702, 288, 6, 33, "Message",
      CellTags->"ComplexExpand::exf"],
    Cell[49361, 1710, 117, 3, 25, "Output",
      CellTags->"ComplexExpand::exf"],
    Cell[49493, 1716, 147, 5, 23, "Text",
      CellTags->"ComplexExpand::exf"],
    Cell[49665, 1725, 148, 3, 26, "Input",
      CellTags->"ComplexExpand::exf"],
    Cell[49816, 1730, 109, 3, 33, "Output",
      CellTags->"ComplexExpand::exf"]},
  "D::dvar"->{
    Cell[49986, 1740, 67, 1, 31, "ObjectNameWarningMessages",
      CellTags->"D::dvar"],
    Cell[50056, 1743, 237, 5, 33, "Message",
      CellTags->"D::dvar"],
    Cell[50296, 1750, 780, 25, 77, "Notes",
      CellTags->"D::dvar"],
    Cell[51101, 1779, 57, 1, 38, "ExampleSection",
      CellTags->"D::dvar"],
    Cell[51161, 1782, 188, 5, 36, "Text",
      CellTags->"D::dvar"],
    Cell[51374, 1791, 106, 3, 26, "Input",
      CellTags->"D::dvar"],
    Cell[51483, 1796, 248, 5, 33, "Message",
      CellTags->"D::dvar"],
    Cell[51734, 1803, 115, 3, 26, "Output",
      CellTags->"D::dvar"],
    Cell[51864, 1809, 137, 5, 23, "Text",
      CellTags->"D::dvar"],
    Cell[52026, 1818, 106, 3, 26, "Input",
      CellTags->"D::dvar"],
    Cell[52135, 1823, 142, 4, 27, "Output",
      CellTags->"D::dvar"]},
  "DSolve::deqn"->{
    Cell[52338, 1834, 181, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[52522, 1843, 590, 16, 19, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[53115, 1861, 945, 26, 98, "Notes",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54085, 1891, 117, 2, 38, "ExampleSection",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54205, 1895, 217, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54447, 1904, 183, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54633, 1910, 483, 8, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55119, 1920, 471, 13, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55605, 1936, 199, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[55829, 1946, 188, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56020, 1952, 163, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[56198, 1959, 197, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56420, 1968, 170, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56593, 1974, 518, 9, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57114, 1985, 366, 10, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57495, 1998, 177, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57697, 2008, 175, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57875, 2014, 166, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]},
  "NDSolve::deqn"->{
    Cell[52338, 1834, 181, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[52522, 1843, 590, 16, 19, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[53115, 1861, 945, 26, 98, "Notes",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54085, 1891, 117, 2, 38, "ExampleSection",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54205, 1895, 217, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54447, 1904, 183, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54633, 1910, 483, 8, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55119, 1920, 471, 13, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55605, 1936, 199, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[55829, 1946, 188, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56020, 1952, 163, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[56198, 1959, 197, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56420, 1968, 170, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56593, 1974, 518, 9, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57114, 1985, 366, 10, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57495, 1998, 177, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57697, 2008, 175, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57875, 2014, 166, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]},
  "RSolve::deqn"->{
    Cell[52338, 1834, 181, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[52522, 1843, 590, 16, 19, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[53115, 1861, 945, 26, 98, "Notes",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54085, 1891, 117, 2, 38, "ExampleSection",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54205, 1895, 217, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54447, 1904, 183, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54633, 1910, 483, 8, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55119, 1920, 471, 13, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55605, 1936, 199, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[55829, 1946, 188, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56020, 1952, 163, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[56198, 1959, 197, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56420, 1968, 170, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56593, 1974, 518, 9, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57114, 1985, 366, 10, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57495, 1998, 177, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57697, 2008, 175, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57875, 2014, 166, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]},
  "NRSolve::deqn"->{
    Cell[52338, 1834, 181, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[52522, 1843, 590, 16, 19, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[53115, 1861, 945, 26, 98, "Notes",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54085, 1891, 117, 2, 38, "ExampleSection",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54205, 1895, 217, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54447, 1904, 183, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[54633, 1910, 483, 8, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55119, 1920, 471, 13, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[55605, 1936, 199, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[55829, 1946, 188, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56020, 1952, 163, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[56198, 1959, 197, 5, 22, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56420, 1968, 170, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[56593, 1974, 518, 9, 33, "Message",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57114, 1985, 366, 10, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
    Cell[57495, 1998, 177, 6, 23, "Text",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57697, 2008, 175, 4, 26, "Input",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
    Cell[57875, 2014, 166, 4, 25, "Output",
      CellTags->{
      "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]},
  "DSolve::deqx"->{
    Cell[58102, 2025, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::deqx", "NDSolve::deqx"}],
    Cell[58223, 2031, 343, 9, 19, "Message",
      CellTags->{"DSolve::deqx", "NDSolve::deqx"}],
    Cell[58569, 2042, 282, 8, 37, "Notes",
      CellTags->{"DSolve::deqx", "NDSolve::deqx"}]},
  "NDSolve::deqx"->{
    Cell[58102, 2025, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::deqx", "NDSolve::deqx"}],
    Cell[58223, 2031, 343, 9, 19, "Message",
      CellTags->{"DSolve::deqx", "NDSolve::deqx"}],
    Cell[58569, 2042, 282, 8, 37, "Notes",
      CellTags->{"DSolve::deqx", "NDSolve::deqx"}]},
  "RSolve::deqx"->{
    Cell[58888, 2055, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RSolve::deqx"],
    Cell[58968, 2058, 194, 4, 19, "Message",
      CellTags->"RSolve::deqx"],
    Cell[59165, 2064, 224, 6, 23, "Notes",
      CellTags->"RSolve::deqx"],
    Cell[59414, 2074, 62, 1, 38, "ExampleSection",
      CellTags->"RSolve::deqx"],
    Cell[59479, 2077, 240, 6, 37, "Text",
      CellTags->"RSolve::deqx"],
    Cell[59744, 2087, 140, 3, 26, "Input",
      CellTags->"RSolve::deqx"],
    Cell[59887, 2092, 205, 5, 19, "Message",
      CellTags->"RSolve::deqx"],
    Cell[60095, 2099, 159, 4, 25, "Output",
      CellTags->"RSolve::deqx"],
    Cell[60269, 2106, 123, 5, 23, "Text",
      CellTags->"RSolve::deqx"],
    Cell[60417, 2115, 140, 3, 26, "Input",
      CellTags->"RSolve::deqx"],
    Cell[60560, 2120, 115, 3, 25, "Output",
      CellTags->"RSolve::deqx"]},
  "DSolve::dsmsm"->{
    Cell[60736, 2130, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[60859, 2136, 459, 10, 47, "Message",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61321, 2148, 245, 7, 23, "Notes",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61591, 2159, 82, 1, 38, "ExampleSection",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61676, 2162, 178, 5, 23, "Text",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61879, 2171, 184, 4, 26, "Input",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[62066, 2177, 340, 6, 47, "Message",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[62409, 2185, 623, 17, 25, "Output",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}]},
  "RSolve::dsmsm"->{
    Cell[60736, 2130, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[60859, 2136, 459, 10, 47, "Message",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61321, 2148, 245, 7, 23, "Notes",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61591, 2159, 82, 1, 38, "ExampleSection",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61676, 2162, 178, 5, 23, "Text",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[61879, 2171, 184, 4, 26, "Input",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[62066, 2177, 340, 6, 47, "Message",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
    Cell[62409, 2185, 623, 17, 25, "Output",
      CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}]},
  "DSolve::underdet"->{
    Cell[63093, 2209, 218, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63314, 2219, 375, 10, 19, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63692, 2231, 270, 7, 22, "Notes",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63987, 2242, 138, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64128, 2247, 281, 7, 36, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64434, 2258, 259, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64696, 2266, 293, 7, 33, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[64992, 2275, 769, 20, 27, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[65776, 2298, 234, 7, 23, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66035, 2309, 241, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66279, 2317, 352, 10, 25, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}]},
  "NDSolve::underdet"->{
    Cell[63093, 2209, 218, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63314, 2219, 375, 10, 19, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63692, 2231, 270, 7, 22, "Notes",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63987, 2242, 138, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64128, 2247, 281, 7, 36, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64434, 2258, 259, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64696, 2266, 293, 7, 33, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[64992, 2275, 769, 20, 27, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[65776, 2298, 234, 7, 23, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66035, 2309, 241, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66279, 2317, 352, 10, 25, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}]},
  "RSolve::underdet"->{
    Cell[63093, 2209, 218, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63314, 2219, 375, 10, 19, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63692, 2231, 270, 7, 22, "Notes",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63987, 2242, 138, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64128, 2247, 281, 7, 36, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64434, 2258, 259, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64696, 2266, 293, 7, 33, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[64992, 2275, 769, 20, 27, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[65776, 2298, 234, 7, 23, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66035, 2309, 241, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66279, 2317, 352, 10, 25, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}]},
  "NRSolve::underdet"->{
    Cell[63093, 2209, 218, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63314, 2219, 375, 10, 19, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63692, 2231, 270, 7, 22, "Notes",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[63987, 2242, 138, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64128, 2247, 281, 7, 36, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64434, 2258, 259, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[64696, 2266, 293, 7, 33, "Message",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[64992, 2275, 769, 20, 27, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}],
    Cell[65776, 2298, 234, 7, 23, "Text",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66035, 2309, 241, 6, 26, "Input",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
        "NRSolve::underdet"}],
    Cell[66279, 2317, 352, 10, 25, "Output",
      CellTags->{
      "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
        "RSolve::underdet"}]},
  "DSolve::overdet"->{
    Cell[66692, 2334, 210, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[66905, 2344, 370, 10, 19, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67278, 2356, 240, 6, 22, "Notes",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67543, 2366, 134, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67680, 2371, 201, 6, 22, "Text",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67906, 2381, 228, 6, 26, "Input",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[68137, 2389, 287, 7, 33, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}],
    Cell[68427, 2398, 660, 18, 25, "Output",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}]},
  "NDSolve::overdet"->{
    Cell[66692, 2334, 210, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[66905, 2344, 370, 10, 19, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67278, 2356, 240, 6, 22, "Notes",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67543, 2366, 134, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67680, 2371, 201, 6, 22, "Text",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67906, 2381, 228, 6, 26, "Input",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[68137, 2389, 287, 7, 33, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}],
    Cell[68427, 2398, 660, 18, 25, "Output",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}]},
  "RSolve::overdet"->{
    Cell[66692, 2334, 210, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[66905, 2344, 370, 10, 19, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67278, 2356, 240, 6, 22, "Notes",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67543, 2366, 134, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67680, 2371, 201, 6, 22, "Text",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67906, 2381, 228, 6, 26, "Input",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[68137, 2389, 287, 7, 33, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}],
    Cell[68427, 2398, 660, 18, 25, "Output",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}]},
  "NRSolve::overdet"->{
    Cell[66692, 2334, 210, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[66905, 2344, 370, 10, 19, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67278, 2356, 240, 6, 22, "Notes",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67543, 2366, 134, 3, 38, "ExampleSection",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67680, 2371, 201, 6, 22, "Text",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[67906, 2381, 228, 6, 26, "Input",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
        "NRSolve::overdet"}],
    Cell[68137, 2389, 287, 7, 33, "Message",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}],
    Cell[68427, 2398, 660, 18, 25, "Output",
      CellTags->{
      "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
        "RSolve::overdet"}]},
  "DSolve::ivar2"->{
    Cell[69148, 2423, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69340, 2432, 619, 16, 33, "Message",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69962, 2450, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", 
        "NRSolve::ivar2"}]},
  "NDSolve::ivar2"->{
    Cell[69148, 2423, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69340, 2432, 619, 16, 33, "Message",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69962, 2450, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", 
        "NRSolve::ivar2"}]},
  "RSolve::ivar2"->{
    Cell[69148, 2423, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69340, 2432, 619, 16, 33, "Message",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69962, 2450, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", 
        "NRSolve::ivar2"}]},
  "NRSolve::ivar2"->{
    Cell[69148, 2423, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69340, 2432, 619, 16, 33, "Message",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
    Cell[69962, 2450, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", 
        "NRSolve::ivar2"}]},
  "DSolve::dsfun"->{
    Cell[70181, 2460, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
    Cell[70337, 2467, 411, 11, 19, "Message",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
    Cell[70751, 2480, 429, 13, 43, "Notes",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}]},
  "NDSolve::dsfun"->{
    Cell[70181, 2460, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
    Cell[70337, 2467, 411, 11, 19, "Message",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
    Cell[70751, 2480, 429, 13, 43, "Notes",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}]},
  "RSolve::dsfun"->{
    Cell[70181, 2460, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
    Cell[70337, 2467, 411, 11, 19, "Message",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
    Cell[70751, 2480, 429, 13, 43, "Notes",
      CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}]},
  "DSolve::dsvar"->{
    Cell[71217, 2498, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[71342, 2504, 394, 11, 19, "Message",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[71739, 2517, 560, 14, 63, "Notes",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72324, 2535, 83, 1, 38, "ExampleSection",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72410, 2538, 154, 4, 22, "Text",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72589, 2546, 140, 3, 26, "Input",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72732, 2551, 195, 4, 19, "Message",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72930, 2557, 346, 9, 25, "Output",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}]},
  "NDSolve::dsvar"->{
    Cell[71217, 2498, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[71342, 2504, 394, 11, 19, "Message",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[71739, 2517, 560, 14, 63, "Notes",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72324, 2535, 83, 1, 38, "ExampleSection",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72410, 2538, 154, 4, 22, "Text",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72589, 2546, 140, 3, 26, "Input",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72732, 2551, 195, 4, 19, "Message",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
    Cell[72930, 2557, 346, 9, 25, "Output",
      CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}]},
  "DSolve::derlen"->{
    Cell[73337, 2573, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[73466, 2579, 335, 8, 33, "Message",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[73804, 2589, 254, 5, 36, "Notes",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74083, 2598, 85, 1, 38, "ExampleSection",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74171, 2601, 242, 5, 36, "Text",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74438, 2610, 157, 3, 26, "Input",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74598, 2615, 387, 7, 33, "Message",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74988, 2624, 455, 12, 25, "Output",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}]},
  "NDSolve::derlen"->{
    Cell[73337, 2573, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[73466, 2579, 335, 8, 33, "Message",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[73804, 2589, 254, 5, 36, "Notes",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74083, 2598, 85, 1, 38, "ExampleSection",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74171, 2601, 242, 5, 36, "Text",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74438, 2610, 157, 3, 26, "Input",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74598, 2615, 387, 7, 33, "Message",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
    Cell[74988, 2624, 455, 12, 25, "Output",
      CellTags->{"DSolve::derlen", "NDSolve::derlen"}]},
  "DSolve::pde"->{
    Cell[75504, 2643, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DSolve::pde"],
    Cell[75582, 2646, 267, 5, 33, "Message",
      CellTags->"DSolve::pde"],
    Cell[75852, 2653, 506, 13, 58, "Notes",
      CellTags->"DSolve::pde"]},
  "DSolve::twoivarg"->{
    Cell[76395, 2671, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
    Cell[76569, 2678, 450, 11, 33, "Message",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
    Cell[77022, 2691, 170, 4, 22, "Notes",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}]},
  "NDSolve::twoivarg"->{
    Cell[76395, 2671, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
    Cell[76569, 2678, 450, 11, 33, "Message",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
    Cell[77022, 2691, 170, 4, 22, "Notes",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}]},
  "RSolve::twoivarg"->{
    Cell[76395, 2671, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
    Cell[76569, 2678, 450, 11, 33, "Message",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
    Cell[77022, 2691, 170, 4, 22, "Notes",
      CellTags->{
      "DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}]},
  "RSolve::rord"->{
    Cell[77229, 2700, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RSolve::rord"],
    Cell[77309, 2703, 417, 10, 19, "Message",
      CellTags->"RSolve::rord"],
    Cell[77729, 2715, 123, 4, 22, "Notes",
      CellTags->"RSolve::rord"]},
  "RSolve::piarg"->{
    Cell[77889, 2724, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RSolve::piarg"],
    Cell[77971, 2727, 643, 17, 19, "Message",
      CellTags->"RSolve::piarg"],
    Cell[78617, 2746, 124, 4, 22, "Notes",
      CellTags->"RSolve::piarg"]},
  "DSolve::pdord"->{
    Cell[78778, 2755, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DSolve::pdord"],
    Cell[78860, 2758, 474, 11, 33, "Message",
      CellTags->"DSolve::pdord"],
    Cell[79337, 2771, 246, 7, 37, "Notes",
      CellTags->"DSolve::pdord"]},
  "RSolve::pdord"->{
    Cell[79620, 2783, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RSolve::pdord"],
    Cell[79702, 2786, 470, 11, 33, "Message",
      CellTags->"RSolve::pdord"],
    Cell[80175, 2799, 251, 7, 37, "Notes",
      CellTags->"RSolve::pdord"]},
  "DSolve::alliv"->{
    Cell[80463, 2811, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
    Cell[80619, 2818, 679, 14, 33, "Message",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
    Cell[81301, 2834, 161, 4, 22, "Notes",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}]},
  "NDSolve::alliv"->{
    Cell[80463, 2811, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
    Cell[80619, 2818, 679, 14, 33, "Message",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
    Cell[81301, 2834, 161, 4, 22, "Notes",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}]},
  "RSolve::alliv"->{
    Cell[80463, 2811, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
    Cell[80619, 2818, 679, 14, 33, "Message",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
    Cell[81301, 2834, 161, 4, 22, "Notes",
      CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}]},
  "DSolve::baddv"->{
    Cell[81499, 2843, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[81691, 2852, 560, 15, 19, "Message",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[82254, 2869, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", 
        "NRSolve::baddv"}]},
  "NDSolve::baddv"->{
    Cell[81499, 2843, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[81691, 2852, 560, 15, 19, "Message",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[82254, 2869, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", 
        "NRSolve::baddv"}]},
  "RSolve::baddv"->{
    Cell[81499, 2843, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[81691, 2852, 560, 15, 19, "Message",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[82254, 2869, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", 
        "NRSolve::baddv"}]},
  "NRSolve::baddv"->{
    Cell[81499, 2843, 189, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[81691, 2852, 560, 15, 19, "Message",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
    Cell[82254, 2869, 182, 5, 22, "Notes",
      CellTags->{
      "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", 
        "NRSolve::baddv"}]},
  "DSolve::litarg"->{
    Cell[82473, 2879, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[82635, 2886, 445, 11, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83083, 2899, 212, 4, 22, "Notes",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83320, 2907, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83426, 2910, 212, 4, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83663, 2918, 173, 3, 26, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83839, 2923, 531, 9, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[84373, 2934, 469, 12, 25, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[84857, 2949, 171, 4, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85053, 2957, 170, 3, 26, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85226, 2962, 198, 4, 27, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85439, 2969, 221, 5, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85685, 2978, 371, 7, 58, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[86059, 2987, 354, 6, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[86416, 2995, 1108, 28, 43, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]},
  "NDSolve::litarg"->{
    Cell[82473, 2879, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[82635, 2886, 445, 11, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83083, 2899, 212, 4, 22, "Notes",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83320, 2907, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83426, 2910, 212, 4, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83663, 2918, 173, 3, 26, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83839, 2923, 531, 9, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[84373, 2934, 469, 12, 25, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[84857, 2949, 171, 4, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85053, 2957, 170, 3, 26, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85226, 2962, 198, 4, 27, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85439, 2969, 221, 5, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85685, 2978, 371, 7, 58, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[86059, 2987, 354, 6, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[86416, 2995, 1108, 28, 43, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]},
  "RSolve::litarg"->{
    Cell[82473, 2879, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[82635, 2886, 445, 11, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83083, 2899, 212, 4, 22, "Notes",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83320, 2907, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83426, 2910, 212, 4, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83663, 2918, 173, 3, 26, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[83839, 2923, 531, 9, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[84373, 2934, 469, 12, 25, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[84857, 2949, 171, 4, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85053, 2957, 170, 3, 26, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85226, 2962, 198, 4, 27, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85439, 2969, 221, 5, 22, "Text",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[85685, 2978, 371, 7, 58, "Input",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[86059, 2987, 354, 6, 33, "Message",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
    Cell[86416, 2995, 1108, 28, 43, "Output",
      CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]},
  "DSolve::bvimp"->{
    Cell[87585, 3030, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],
    Cell[87708, 3036, 445, 11, 33, "Message",
      CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],
    Cell[88156, 3049, 143, 4, 22, "Notes",
      CellTags->{"DSolve::bvimp", "RSolve::bvimp"}]},
  "RSolve::bvimp"->{
    Cell[87585, 3030, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],
    Cell[87708, 3036, 445, 11, 33, "Message",
      CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],
    Cell[88156, 3049, 143, 4, 22, "Notes",
      CellTags->{"DSolve::bvimp", "RSolve::bvimp"}]},
  "DSolve::bvlim"->{
    Cell[88336, 3058, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],
    Cell[88459, 3064, 425, 11, 33, "Message",
      CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],
    Cell[88887, 3077, 143, 4, 22, "Notes",
      CellTags->{"DSolve::bvlim", "RSolve::bvlim"}]},
  "RSolve::bvlim"->{
    Cell[88336, 3058, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],
    Cell[88459, 3064, 425, 11, 33, "Message",
      CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],
    Cell[88887, 3077, 143, 4, 22, "Notes",
      CellTags->{"DSolve::bvlim", "RSolve::bvlim"}]},
  "DSolve::bvfail"->{
    Cell[89067, 3086, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],
    Cell[89194, 3092, 374, 10, 19, "Message",
      CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],
    Cell[89571, 3104, 145, 4, 22, "Notes",
      CellTags->{"DSolve::bvfail", "RSolve::bvfail"}]},
  "RSolve::bvfail"->{
    Cell[89067, 3086, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],
    Cell[89194, 3092, 374, 10, 19, "Message",
      CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],
    Cell[89571, 3104, 145, 4, 22, "Notes",
      CellTags->{"DSolve::bvfail", "RSolve::bvfail"}]},
  "DSolve::bvnul"->{
    Cell[89753, 3113, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[89876, 3119, 398, 11, 33, "Message",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[90277, 3132, 185, 4, 22, "Notes",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[90487, 3140, 82, 1, 38, "ExampleSection",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[90572, 3143, 418, 9, 52, "Text",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[91015, 3156, 210, 4, 26, "Input",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[91228, 3162, 254, 5, 33, "Message",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[91485, 3169, 108, 3, 25, "Output",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}]},
  "RSolve::bvnul"->{
    Cell[89753, 3113, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[89876, 3119, 398, 11, 33, "Message",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[90277, 3132, 185, 4, 22, "Notes",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[90487, 3140, 82, 1, 38, "ExampleSection",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[90572, 3143, 418, 9, 52, "Text",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[91015, 3156, 210, 4, 26, "Input",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[91228, 3162, 254, 5, 33, "Message",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
    Cell[91485, 3169, 108, 3, 25, "Output",
      CellTags->{"DSolve::bvnul", "RSolve::bvnul"}]},
  "DSolve::bvnr"->{
    Cell[91654, 3179, 116, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],
    Cell[91773, 3185, 432, 11, 33, "Message",
      CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],
    Cell[92208, 3198, 141, 4, 22, "Notes",
      CellTags->{"DSolve::bvnr", "RSolve::bvnr"}]},
  "RSolve::bvnr"->{
    Cell[91654, 3179, 116, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],
    Cell[91773, 3185, 432, 11, 33, "Message",
      CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],
    Cell[92208, 3198, 141, 4, 22, "Notes",
      CellTags->{"DSolve::bvnr", "RSolve::bvnr"}]},
  "Solve::ifun"->{
    Cell[92386, 3207, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[92548, 3214, 440, 11, 33, "Message",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[92991, 3227, 443, 8, 57, "Notes",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93459, 3239, 103, 1, 38, "ExampleSection",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93565, 3242, 315, 6, 36, "Text",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93905, 3252, 147, 3, 26, "Input",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[94055, 3257, 304, 5, 33, "Message",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],
    Cell[94362, 3264, 150, 3, 25, "Output",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],
    Cell[94527, 3270, 209, 6, 23, "Text",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[94761, 3280, 241, 5, 42, "Input",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[95005, 3287, 145, 3, 25, "Output",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}]},
  "Eliminate::ifun"->{
    Cell[92386, 3207, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[92548, 3214, 440, 11, 33, "Message",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[92991, 3227, 443, 8, 57, "Notes",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93459, 3239, 103, 1, 38, "ExampleSection",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93565, 3242, 315, 6, 36, "Text",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93905, 3252, 147, 3, 26, "Input",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[94055, 3257, 304, 5, 33, "Message",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],
    Cell[94362, 3264, 150, 3, 25, "Output",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],
    Cell[94527, 3270, 209, 6, 23, "Text",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[94761, 3280, 241, 5, 42, "Input",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[95005, 3287, 145, 3, 25, "Output",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}]},
  "SolveAlways::ifun"->{
    Cell[92386, 3207, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[92548, 3214, 440, 11, 33, "Message",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[92991, 3227, 443, 8, 57, "Notes",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93459, 3239, 103, 1, 38, "ExampleSection",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93565, 3242, 315, 6, 36, "Text",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[93905, 3252, 147, 3, 26, "Input",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[94055, 3257, 304, 5, 33, "Message",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],
    Cell[94362, 3264, 150, 3, 25, "Output",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],
    Cell[94527, 3270, 209, 6, 23, "Text",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[94761, 3280, 241, 5, 42, "Input",
      CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
    Cell[95005, 3287, 145, 3, 25, "Output",
      CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}]},
  "Reduce::ifun"->{
    Cell[95211, 3297, 240, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95454, 3307, 438, 12, 19, "Message",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95895, 3321, 490, 10, 57, "Notes",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}]},
  "System`Private`OldReduce::ifun"->{
    Cell[95211, 3297, 240, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95454, 3307, 438, 12, 19, "Message",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95895, 3321, 490, 10, 57, "Notes",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}]},
  "MainSolve::ifun"->{
    Cell[95211, 3297, 240, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95454, 3307, 438, 12, 19, "Message",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95895, 3321, 490, 10, 57, "Notes",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}]},
  "AlgebraicRules::ifun"->{
    Cell[95211, 3297, 240, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95454, 3307, 438, 12, 19, "Message",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}],
    Cell[95895, 3321, 490, 10, 57, "Notes",
      CellTags->{
      "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
        "AlgebraicRules::ifun"}]},
  "Factor::facmm"->{
    Cell[96422, 3336, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Factor::facmm"],
    Cell[96504, 3339, 252, 4, 33, "Message",
      CellTags->"Factor::facmm"],
    Cell[96759, 3345, 278, 7, 37, "Notes",
      CellTags->"Factor::facmm"],
    Cell[97062, 3356, 63, 1, 38, "ExampleSection",
      CellTags->"Factor::facmm"],
    Cell[97128, 3359, 261, 7, 38, "Text",
      CellTags->"Factor::facmm"],
    Cell[97414, 3370, 116, 3, 26, "Input",
      CellTags->"Factor::facmm"],
    Cell[97533, 3375, 252, 5, 33, "Message",
      CellTags->"Factor::facmm"],
    Cell[97788, 3382, 101, 3, 25, "Output",
      CellTags->"Factor::facmm"]},
  "Factor::priml"->{
    Cell[97950, 3392, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Factor::priml"],
    Cell[98032, 3395, 238, 5, 19, "Message",
      CellTags->"Factor::priml"],
    Cell[98273, 3402, 870, 22, 107, "Notes",
      CellTags->"Factor::priml"]},
  "Factor::ufac"->{
    Cell[99180, 3429, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],
    Cell[99319, 3435, 282, 7, 19, "Message",
      CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],
    Cell[99604, 3444, 310, 6, 42, "Notes",
      CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}]},
  "FactorSquareFree::ufac"->{
    Cell[99180, 3429, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],
    Cell[99319, 3435, 282, 7, 19, "Message",
      CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],
    Cell[99604, 3444, 310, 6, 42, "Notes",
      CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}]},
  "General::mult"->{
    Cell[99951, 3455, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::mult"],
    Cell[100033, 3458, 458, 14, 19, "Message",
      CellTags->"General::mult"],
    Cell[100494, 3474, 400, 12, 43, "Notes",
      CellTags->"General::mult"],
    Cell[100919, 3490, 63, 1, 38, "ExampleSection",
      CellTags->"General::mult"],
    Cell[100985, 3493, 181, 5, 23, "Text",
      CellTags->"General::mult"],
    Cell[101191, 3502, 123, 3, 26, "Input",
      CellTags->"General::mult"],
    Cell[101317, 3507, 200, 5, 19, "Message",
      CellTags->"General::mult"],
    Cell[101520, 3514, 136, 3, 27, "Output",
      CellTags->"General::mult"],
    Cell[101671, 3520, 179, 7, 23, "Text",
      CellTags->"General::mult"],
    Cell[101875, 3531, 123, 3, 26, "Input",
      CellTags->"General::mult"],
    Cell[102001, 3536, 220, 5, 28, "Output",
      CellTags->"General::mult"]},
  "General::modint"->{
    Cell[102282, 3548, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::modint"],
    Cell[102368, 3551, 351, 10, 19, "Message",
      CellTags->"General::modint"],
    Cell[102722, 3563, 204, 5, 23, "Notes",
      CellTags->"General::modint"]},
  "General::modgp"->{
    Cell[102963, 3573, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::modgp"],
    Cell[103047, 3576, 516, 15, 19, "Message",
      CellTags->"General::modgp"],
    Cell[103566, 3593, 567, 13, 63, "Notes",
      CellTags->"General::modgp"],
    Cell[104158, 3610, 64, 1, 38, "ExampleSection",
      CellTags->"General::modgp"],
    Cell[104225, 3613, 193, 5, 23, "Text",
      CellTags->"General::modgp"],
    Cell[104443, 3622, 137, 3, 26, "Input",
      CellTags->"General::modgp"],
    Cell[104583, 3627, 218, 5, 19, "Message",
      CellTags->"General::modgp"],
    Cell[104804, 3634, 159, 4, 27, "Output",
      CellTags->"General::modgp"],
    Cell[104978, 3641, 101, 1, 22, "Text",
      CellTags->"General::modgp"],
    Cell[105104, 3646, 123, 3, 26, "Input",
      CellTags->"General::modgp"],
    Cell[105230, 3651, 93, 3, 25, "Output",
      CellTags->"General::modgp"],
    Cell[105360, 3659, 130, 3, 26, "Input",
      CellTags->"General::modgp"],
    Cell[105493, 3664, 173, 4, 25, "Output",
      CellTags->"General::modgp"],
    Cell[105681, 3671, 154, 5, 23, "Text",
      CellTags->"General::modgp"],
    Cell[105860, 3680, 137, 3, 26, "Input",
      CellTags->"General::modgp"],
    Cell[106000, 3685, 121, 3, 27, "Output",
      CellTags->"General::modgp"]},
  "General::modm"->{
    Cell[106182, 3695, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::modm"],
    Cell[106264, 3698, 381, 10, 19, "Message",
      CellTags->"General::modm"],
    Cell[106648, 3710, 230, 6, 23, "Notes",
      CellTags->"General::modm"]},
  "General::modn"->{
    Cell[106915, 3721, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::modn"],
    Cell[106997, 3724, 485, 15, 19, "Message",
      CellTags->"General::modn"],
    Cell[107485, 3741, 176, 5, 23, "Notes",
      CellTags->"General::modn"],
    Cell[107686, 3750, 63, 1, 38, "ExampleSection",
      CellTags->"General::modn"],
    Cell[107752, 3753, 233, 7, 23, "Text",
      CellTags->"General::modn"],
    Cell[108010, 3764, 129, 3, 26, "Input",
      CellTags->"General::modn"],
    Cell[108142, 3769, 205, 5, 34, "Message",
      CellTags->"General::modn"],
    Cell[108350, 3776, 142, 3, 40, "Output",
      CellTags->"General::modn"],
    Cell[108507, 3782, 180, 7, 23, "Text",
      CellTags->"General::modn"],
    Cell[108712, 3793, 127, 3, 26, "Input",
      CellTags->"General::modn"],
    Cell[108842, 3798, 104, 3, 27, "Output",
      CellTags->"General::modn"]},
  "General::modp"->{
    Cell[109007, 3808, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::modp"],
    Cell[109089, 3811, 521, 15, 19, "Message",
      CellTags->"General::modp"],
    Cell[109613, 3828, 180, 5, 23, "Notes",
      CellTags->"General::modp"],
    Cell[109818, 3837, 63, 1, 38, "ExampleSection",
      CellTags->"General::modp"],
    Cell[109884, 3840, 190, 5, 23, "Text",
      CellTags->"General::modp"],
    Cell[110099, 3849, 133, 3, 26, "Input",
      CellTags->"General::modp"],
    Cell[110235, 3854, 214, 5, 34, "Message",
      CellTags->"General::modp"],
    Cell[110452, 3861, 138, 3, 40, "Output",
      CellTags->"General::modp"],
    Cell[110605, 3867, 170, 7, 23, "Text",
      CellTags->"General::modp"],
    Cell[110800, 3878, 131, 3, 26, "Input",
      CellTags->"General::modp"],
    Cell[110934, 3883, 108, 3, 42, "Output",
      CellTags->"General::modp"],
    Cell[111057, 3889, 234, 7, 23, "Text",
      CellTags->"General::modp"],
    Cell[111316, 3900, 135, 3, 26, "Input",
      CellTags->"General::modp"],
    Cell[111454, 3905, 213, 5, 19, "Message",
      CellTags->"General::modp"],
    Cell[111670, 3912, 141, 3, 40, "Output",
      CellTags->"General::modp"],
    Cell[111826, 3918, 142, 5, 23, "Text",
      CellTags->"General::modp"],
    Cell[111993, 3927, 97, 3, 26, "Input",
      CellTags->"General::modp"],
    Cell[112093, 3932, 92, 3, 25, "Output",
      CellTags->"General::modp"],
    Cell[112222, 3940, 97, 3, 26, "Input",
      CellTags->"General::modp"],
    Cell[112322, 3945, 91, 3, 25, "Output",
      CellTags->"General::modp"],
    Cell[112428, 3951, 177, 7, 23, "Text",
      CellTags->"General::modp"],
    Cell[112630, 3962, 135, 3, 26, "Input",
      CellTags->"General::modp"],
    Cell[112768, 3967, 131, 3, 42, "Output",
      CellTags->"General::modp"]},
  "General::nalg"->{
    Cell[112960, 3977, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nalg"],
    Cell[113042, 3980, 380, 11, 19, "Message",
      CellTags->"General::nalg"],
    Cell[113425, 3993, 627, 13, 91, "Notes",
      CellTags->"General::nalg"],
    Cell[114077, 4010, 63, 1, 38, "ExampleSection",
      CellTags->"General::nalg"],
    Cell[114143, 4013, 177, 5, 23, "Text",
      CellTags->"General::nalg"],
    Cell[114345, 4022, 119, 3, 26, "Input",
      CellTags->"General::nalg"],
    Cell[114467, 4027, 179, 4, 19, "Message",
      CellTags->"General::nalg"],
    Cell[114649, 4033, 126, 3, 27, "Output",
      CellTags->"General::nalg"],
    Cell[114790, 4039, 177, 7, 23, "Text",
      CellTags->"General::nalg"],
    Cell[114992, 4050, 123, 3, 26, "Input",
      CellTags->"General::nalg"],
    Cell[115118, 4055, 115, 3, 30, "Output",
      CellTags->"General::nalg"]},
  "General::nmod"->{
    Cell[115294, 4065, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nmod"],
    Cell[115376, 4068, 401, 13, 19, "Message",
      CellTags->"General::nmod"],
    Cell[115780, 4083, 155, 4, 22, "Notes",
      CellTags->"General::nmod"],
    Cell[115960, 4091, 63, 1, 38, "ExampleSection",
      CellTags->"General::nmod"],
    Cell[116026, 4094, 156, 4, 22, "Text",
      CellTags->"General::nmod"],
    Cell[116207, 4102, 117, 3, 26, "Input",
      CellTags->"General::nmod"],
    Cell[116327, 4107, 178, 4, 32, "Message",
      CellTags->"General::nmod"],
    Cell[116508, 4113, 124, 3, 38, "Output",
      CellTags->"General::nmod"],
    Cell[116647, 4119, 157, 5, 23, "Text",
      CellTags->"General::nmod"],
    Cell[116829, 4128, 122, 3, 26, "Input",
      CellTags->"General::nmod"],
    Cell[116954, 4133, 95, 3, 25, "Output",
      CellTags->"General::nmod"]},
  "General::npoly"->{
    Cell[117110, 4143, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::npoly"],
    Cell[117194, 4146, 425, 12, 19, "Message",
      CellTags->"General::npoly"],
    Cell[117622, 4160, 217, 5, 36, "Notes",
      CellTags->"General::npoly"],
    Cell[117864, 4169, 64, 1, 38, "ExampleSection",
      CellTags->"General::npoly"],
    Cell[117931, 4172, 155, 4, 22, "Text",
      CellTags->"General::npoly"],
    Cell[118111, 4180, 111, 3, 26, "Input",
      CellTags->"General::npoly"],
    Cell[118225, 4185, 190, 5, 21, "Message",
      CellTags->"General::npoly"],
    Cell[118418, 4192, 113, 3, 27, "Output",
      CellTags->"General::npoly"],
    Cell[118546, 4198, 125, 5, 23, "Text",
      CellTags->"General::npoly"],
    Cell[118696, 4207, 106, 3, 26, "Input",
      CellTags->"General::npoly"],
    Cell[118805, 4212, 96, 3, 28, "Output",
      CellTags->"General::npoly"]},
  "General::npolys"->{
    Cell[118962, 4222, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::npolys"],
    Cell[119048, 4225, 452, 12, 19, "Message",
      CellTags->"General::npolys"],
    Cell[119503, 4239, 346, 7, 56, "Notes",
      CellTags->"General::npolys"],
    Cell[119874, 4250, 65, 1, 38, "ExampleSection",
      CellTags->"General::npolys"],
    Cell[119942, 4253, 159, 4, 22, "Text",
      CellTags->"General::npolys"],
    Cell[120126, 4261, 124, 3, 26, "Input",
      CellTags->"General::npolys"],
    Cell[120253, 4266, 241, 5, 27, "Message",
      CellTags->"General::npolys"],
    Cell[120497, 4273, 126, 3, 30, "Output",
      CellTags->"General::npolys"],
    Cell[120638, 4279, 124, 5, 23, "Text",
      CellTags->"General::npolys"],
    Cell[120787, 4288, 122, 3, 26, "Input",
      CellTags->"General::npolys"],
    Cell[120912, 4293, 93, 3, 25, "Output",
      CellTags->"General::npolys"]},
  "General::poly"->{
    Cell[121066, 4303, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::poly"],
    Cell[121148, 4306, 348, 11, 19, "Message",
      CellTags->"General::poly"],
    Cell[121499, 4319, 148, 4, 22, "Notes",
      CellTags->"General::poly"],
    Cell[121672, 4327, 63, 1, 38, "ExampleSection",
      CellTags->"General::poly"],
    Cell[121738, 4330, 252, 6, 37, "Text",
      CellTags->"General::poly"],
    Cell[122015, 4340, 127, 3, 26, "Input",
      CellTags->"General::poly"],
    Cell[122145, 4345, 178, 4, 19, "Message",
      CellTags->"General::poly"],
    Cell[122326, 4351, 128, 3, 25, "Output",
      CellTags->"General::poly"],
    Cell[122469, 4357, 138, 5, 23, "Text",
      CellTags->"General::poly"],
    Cell[122632, 4366, 132, 3, 26, "Input",
      CellTags->"General::poly"],
    Cell[122767, 4371, 88, 3, 25, "Output",
      CellTags->"General::poly"]},
  "General::polyx"->{
    Cell[122916, 4381, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::polyx"],
    Cell[123000, 4384, 398, 11, 19, "Message",
      CellTags->"General::polyx"],
    Cell[123401, 4397, 415, 9, 62, "Notes",
      CellTags->"General::polyx"]},
  "General::primm"->{
    Cell[123853, 4411, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::primm"],
    Cell[123937, 4414, 370, 11, 19, "Message",
      CellTags->"General::primm"],
    Cell[124310, 4427, 149, 4, 22, "Notes",
      CellTags->"General::primm"]},
  "General::prims"->{
    Cell[124496, 4436, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::prims"],
    Cell[124580, 4439, 395, 11, 19, "Message",
      CellTags->"General::prims"],
    Cell[124978, 4452, 150, 4, 22, "Notes",
      CellTags->"General::prims"]},
  "GroebnerBasis::badcf"->{
    Cell[125165, 4461, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125468, 4471, 352, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125823, 4482, 337, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}]},
  "PolynomialReduce::badcf"->{
    Cell[125165, 4461, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125468, 4471, 352, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125823, 4482, 337, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}]},
  "Internal`GroebnerWalk::badcf"->{
    Cell[125165, 4461, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125468, 4471, 352, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125823, 4482, 337, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}]},
  "Internal`DistributedTermsList::badcf"->{
    Cell[125165, 4461, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125468, 4471, 352, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}],
    Cell[125823, 4482, 337, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::badcf", "PolynomialReduce::badcf", 
        "Internal`GroebnerWalk::badcf", 
        "Internal`DistributedTermsList::badcf"}]},
  "GroebnerBasis::coef"->{
    Cell[126197, 4494, 292, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[126492, 4504, 526, 15, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127021, 4521, 908, 27, 93, "Notes",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127954, 4552, 175, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128132, 4557, 296, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128453, 4568, 293, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128749, 4576, 336, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129088, 4585, 299, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129402, 4594, 259, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129686, 4605, 284, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129973, 4613, 219, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}]},
  "PolynomialReduce::coef"->{
    Cell[126197, 4494, 292, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[126492, 4504, 526, 15, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127021, 4521, 908, 27, 93, "Notes",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127954, 4552, 175, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128132, 4557, 296, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128453, 4568, 293, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128749, 4576, 336, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129088, 4585, 299, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129402, 4594, 259, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129686, 4605, 284, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129973, 4613, 219, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}]},
  "Internal`GroebnerWalk::coef"->{
    Cell[126197, 4494, 292, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[126492, 4504, 526, 15, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127021, 4521, 908, 27, 93, "Notes",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127954, 4552, 175, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128132, 4557, 296, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128453, 4568, 293, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128749, 4576, 336, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129088, 4585, 299, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129402, 4594, 259, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129686, 4605, 284, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129973, 4613, 219, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}]},
  "Internal`DistributedTermsList::coef"->{
    Cell[126197, 4494, 292, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[126492, 4504, 526, 15, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127021, 4521, 908, 27, 93, "Notes",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[127954, 4552, 175, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128132, 4557, 296, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128453, 4568, 293, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[128749, 4576, 336, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129088, 4585, 299, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}],
    Cell[129402, 4594, 259, 7, 23, "Text",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129686, 4605, 284, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::coef", "PolynomialReduce::coef", 
        "Internal`GroebnerWalk::coef", 
        "Internal`DistributedTermsList::coef"}],
    Cell[129973, 4613, 219, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::coef", "Internal`DistributedTermsList::coef", 
        "Internal`GroebnerWalk::coef", "PolynomialReduce::coef"}]},
  "GroebnerBasis::elmvar"->{
    Cell[130253, 4625, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[130564, 4635, 532, 13, 19, "Message",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[131099, 4650, 614, 15, 58, "Notes",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}]},
  "PolynomialReduce::elmvar"->{
    Cell[130253, 4625, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[130564, 4635, 532, 13, 19, "Message",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[131099, 4650, 614, 15, 58, "Notes",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}]},
  "Internal`GroebnerWalk::elmvar"->{
    Cell[130253, 4625, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[130564, 4635, 532, 13, 19, "Message",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[131099, 4650, 614, 15, 58, "Notes",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}]},
  "Internal`DistributedTermsList::elmvar"->{
    Cell[130253, 4625, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[130564, 4635, 532, 13, 19, "Message",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}],
    Cell[131099, 4650, 614, 15, 58, "Notes",
      CellTags->{
      "GroebnerBasis::elmvar", "PolynomialReduce::elmvar", 
        "Internal`GroebnerWalk::elmvar", 
        "Internal`DistributedTermsList::elmvar"}]},
  "GroebnerBasis::fltgb"->{
    Cell[131750, 4670, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132053, 4680, 369, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132425, 4691, 504, 9, 62, "Notes",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}]},
  "PolynomialReduce::fltgb"->{
    Cell[131750, 4670, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132053, 4680, 369, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132425, 4691, 504, 9, 62, "Notes",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}]},
  "Internal`GroebnerWalk::fltgb"->{
    Cell[131750, 4670, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132053, 4680, 369, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132425, 4691, 504, 9, 62, "Notes",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}]},
  "Internal`DistributedTermsList::fltgb"->{
    Cell[131750, 4670, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132053, 4680, 369, 9, 19, "Message",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}],
    Cell[132425, 4691, 504, 9, 62, "Notes",
      CellTags->{
      "GroebnerBasis::fltgb", "PolynomialReduce::fltgb", 
        "Internal`GroebnerWalk::fltgb", 
        "Internal`DistributedTermsList::fltgb"}]},
  "GroebnerBasis::intgb"->{
    Cell[132966, 4705, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133269, 4715, 635, 14, 33, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133907, 4731, 331, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134263, 4742, 179, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134445, 4747, 339, 8, 37, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134809, 4759, 270, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[135082, 4767, 429, 8, 65, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135514, 4777, 277, 6, 40, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135806, 4786, 266, 6, 22, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136097, 4796, 271, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136371, 4804, 206, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}]},
  "PolynomialReduce::intgb"->{
    Cell[132966, 4705, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133269, 4715, 635, 14, 33, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133907, 4731, 331, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134263, 4742, 179, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134445, 4747, 339, 8, 37, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134809, 4759, 270, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[135082, 4767, 429, 8, 65, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135514, 4777, 277, 6, 40, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135806, 4786, 266, 6, 22, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136097, 4796, 271, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136371, 4804, 206, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}]},
  "Internal`GroebnerWalk::intgb"->{
    Cell[132966, 4705, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133269, 4715, 635, 14, 33, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133907, 4731, 331, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134263, 4742, 179, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134445, 4747, 339, 8, 37, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134809, 4759, 270, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[135082, 4767, 429, 8, 65, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135514, 4777, 277, 6, 40, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135806, 4786, 266, 6, 22, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136097, 4796, 271, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136371, 4804, 206, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}]},
  "Internal`DistributedTermsList::intgb"->{
    Cell[132966, 4705, 300, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133269, 4715, 635, 14, 33, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[133907, 4731, 331, 7, 36, "Notes",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134263, 4742, 179, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134445, 4747, 339, 8, 37, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[134809, 4759, 270, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[135082, 4767, 429, 8, 65, "Message",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135514, 4777, 277, 6, 40, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}],
    Cell[135806, 4786, 266, 6, 22, "Text",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136097, 4796, 271, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::intgb", "PolynomialReduce::intgb", 
        "Internal`GroebnerWalk::intgb", 
        "Internal`DistributedTermsList::intgb"}],
    Cell[136371, 4804, 206, 5, 25, "Output",
      CellTags->{
      "GroebnerBasis::intgb", "Internal`DistributedTermsList::intgb", 
        "Internal`GroebnerWalk::intgb", "PolynomialReduce::intgb"}]},
  "GroebnerBasis::mnmord1"->{
    Cell[136638, 4816, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[136962, 4827, 542, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[137507, 4845, 874, 25, 93, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138406, 4874, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138601, 4880, 346, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138972, 4894, 292, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[139267, 4903, 328, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139598, 4912, 294, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139907, 4921, 317, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140249, 4935, 302, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140554, 4944, 224, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}]},
  "PolynomialReduce::mnmord1"->{
    Cell[136638, 4816, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[136962, 4827, 542, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[137507, 4845, 874, 25, 93, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138406, 4874, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138601, 4880, 346, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138972, 4894, 292, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[139267, 4903, 328, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139598, 4912, 294, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139907, 4921, 317, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140249, 4935, 302, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140554, 4944, 224, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}]},
  "Internal`GroebnerWalk::mnmord1"->{
    Cell[136638, 4816, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[136962, 4827, 542, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[137507, 4845, 874, 25, 93, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138406, 4874, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138601, 4880, 346, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138972, 4894, 292, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[139267, 4903, 328, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139598, 4912, 294, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139907, 4921, 317, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140249, 4935, 302, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140554, 4944, 224, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}]},
  "Internal`DistributedTermsList::mnmord1"->{
    Cell[136638, 4816, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[136962, 4827, 542, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[137507, 4845, 874, 25, 93, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138406, 4874, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138601, 4880, 346, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[138972, 4894, 292, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[139267, 4903, 328, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139598, 4912, 294, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}],
    Cell[139907, 4921, 317, 10, 23, "Text",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140249, 4935, 302, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord1", "PolynomialReduce::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", 
        "Internal`DistributedTermsList::mnmord1"}],
    Cell[140554, 4944, 224, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord1", "Internal`DistributedTermsList::mnmord1", 
        "Internal`GroebnerWalk::mnmord1", "PolynomialReduce::mnmord1"}]},
  "GroebnerBasis::mnmord2"->{
    Cell[140839, 4956, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141163, 4967, 606, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141772, 4986, 417, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142214, 4999, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142409, 5005, 376, 9, 37, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142810, 5018, 323, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[143136, 5027, 371, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143510, 5036, 327, 6, 43, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143852, 5045, 229, 4, 22, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144106, 5053, 340, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144449, 5062, 337, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}]},
  "PolynomialReduce::mnmord2"->{
    Cell[140839, 4956, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141163, 4967, 606, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141772, 4986, 417, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142214, 4999, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142409, 5005, 376, 9, 37, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142810, 5018, 323, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[143136, 5027, 371, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143510, 5036, 327, 6, 43, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143852, 5045, 229, 4, 22, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144106, 5053, 340, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144449, 5062, 337, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}]},
  "Internal`GroebnerWalk::mnmord2"->{
    Cell[140839, 4956, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141163, 4967, 606, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141772, 4986, 417, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142214, 4999, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142409, 5005, 376, 9, 37, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142810, 5018, 323, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[143136, 5027, 371, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143510, 5036, 327, 6, 43, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143852, 5045, 229, 4, 22, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144106, 5053, 340, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144449, 5062, 337, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}]},
  "Internal`DistributedTermsList::mnmord2"->{
    Cell[140839, 4956, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141163, 4967, 606, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[141772, 4986, 417, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142214, 4999, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142409, 5005, 376, 9, 37, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[142810, 5018, 323, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[143136, 5027, 371, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143510, 5036, 327, 6, 43, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}],
    Cell[143852, 5045, 229, 4, 22, "Text",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144106, 5053, 340, 7, 42, "Input",
      CellTags->{
      "GroebnerBasis::mnmord2", "PolynomialReduce::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", 
        "Internal`DistributedTermsList::mnmord2"}],
    Cell[144449, 5062, 337, 6, 27, "Output",
      CellTags->{
      "GroebnerBasis::mnmord2", "Internal`DistributedTermsList::mnmord2", 
        "Internal`GroebnerWalk::mnmord2", "PolynomialReduce::mnmord2"}]},
  "GroebnerBasis::modflt"->{
    Cell[144847, 5075, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145158, 5085, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145563, 5097, 409, 11, 38, "Notes",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145997, 5112, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146183, 5117, 373, 9, 38, "Text",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146581, 5130, 308, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146892, 5138, 337, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}],
    Cell[147232, 5147, 250, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}]},
  "PolynomialReduce::modflt"->{
    Cell[144847, 5075, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145158, 5085, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145563, 5097, 409, 11, 38, "Notes",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145997, 5112, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146183, 5117, 373, 9, 38, "Text",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146581, 5130, 308, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146892, 5138, 337, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}],
    Cell[147232, 5147, 250, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}]},
  "Internal`GroebnerWalk::modflt"->{
    Cell[144847, 5075, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145158, 5085, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145563, 5097, 409, 11, 38, "Notes",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145997, 5112, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146183, 5117, 373, 9, 38, "Text",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146581, 5130, 308, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146892, 5138, 337, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}],
    Cell[147232, 5147, 250, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}]},
  "Internal`DistributedTermsList::modflt"->{
    Cell[144847, 5075, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145158, 5085, 402, 10, 19, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145563, 5097, 409, 11, 38, "Notes",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[145997, 5112, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146183, 5117, 373, 9, 38, "Text",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146581, 5130, 308, 6, 42, "Input",
      CellTags->{
      "GroebnerBasis::modflt", "PolynomialReduce::modflt", 
        "Internal`GroebnerWalk::modflt", 
        "Internal`DistributedTermsList::modflt"}],
    Cell[146892, 5138, 337, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}],
    Cell[147232, 5147, 250, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::modflt", "Internal`DistributedTermsList::modflt", 
        "Internal`GroebnerWalk::modflt", "PolynomialReduce::modflt"}]},
  "Inequality::ineq"->{
    Cell[147543, 5159, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Inequality::ineq"],
    Cell[147631, 5162, 396, 10, 33, "Message",
      CellTags->"Inequality::ineq"],
    Cell[148030, 5174, 669, 23, 58, "Notes",
      CellTags->"Inequality::ineq"],
    Cell[148724, 5201, 66, 1, 38, "ExampleSection",
      CellTags->"Inequality::ineq"],
    Cell[148793, 5204, 190, 5, 23, "Text",
      CellTags->"Inequality::ineq"],
    Cell[149008, 5213, 112, 3, 26, "Input",
      CellTags->"Inequality::ineq"],
    Cell[149123, 5218, 245, 5, 33, "Message",
      CellTags->"Inequality::ineq"],
    Cell[149371, 5225, 108, 3, 25, "Output",
      CellTags->"Inequality::ineq"],
    Cell[149494, 5231, 129, 5, 23, "Text",
      CellTags->"Inequality::ineq"],
    Cell[149648, 5240, 115, 3, 26, "Input",
      CellTags->"Inequality::ineq"],
    Cell[149766, 5245, 94, 3, 25, "Output",
      CellTags->"Inequality::ineq"]},
  "GroebnerBasis::pdvar2"->{
    Cell[149921, 5255, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150232, 5265, 603, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150838, 5283, 563, 16, 37, "Notes",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151426, 5303, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151612, 5308, 350, 7, 36, "Text",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151987, 5319, 287, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[152277, 5327, 351, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}],
    Cell[152631, 5336, 294, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}]},
  "PolynomialReduce::pdvar2"->{
    Cell[149921, 5255, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150232, 5265, 603, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150838, 5283, 563, 16, 37, "Notes",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151426, 5303, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151612, 5308, 350, 7, 36, "Text",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151987, 5319, 287, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[152277, 5327, 351, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}],
    Cell[152631, 5336, 294, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}]},
  "Internal`GroebnerWalk::pdvar2"->{
    Cell[149921, 5255, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150232, 5265, 603, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150838, 5283, 563, 16, 37, "Notes",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151426, 5303, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151612, 5308, 350, 7, 36, "Text",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151987, 5319, 287, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[152277, 5327, 351, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}],
    Cell[152631, 5336, 294, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}]},
  "Internal`DistributedTermsList::pdvar2"->{
    Cell[149921, 5255, 308, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150232, 5265, 603, 16, 19, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[150838, 5283, 563, 16, 37, "Notes",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151426, 5303, 183, 3, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151612, 5308, 350, 7, 36, "Text",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[151987, 5319, 287, 6, 26, "Input",
      CellTags->{
      "GroebnerBasis::pdvar2", "PolynomialReduce::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", 
        "Internal`DistributedTermsList::pdvar2"}],
    Cell[152277, 5327, 351, 7, 33, "Message",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}],
    Cell[152631, 5336, 294, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::pdvar2", "Internal`DistributedTermsList::pdvar2", 
        "Internal`GroebnerWalk::pdvar2", "PolynomialReduce::pdvar2"}]},
  "GroebnerBasis::poly2"->{
    Cell[152986, 5349, 337, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153326, 5360, 627, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153956, 5379, 287, 6, 22, "Notes",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}]},
  "PolynomialReduce::poly2"->{
    Cell[152986, 5349, 337, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153326, 5360, 627, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153956, 5379, 287, 6, 22, "Notes",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}]},
  "Resultant::poly2"->{
    Cell[152986, 5349, 337, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153326, 5360, 627, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153956, 5379, 287, 6, 22, "Notes",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}]},
  "Internal`GroebnerWalk::poly2"->{
    Cell[152986, 5349, 337, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153326, 5360, 627, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153956, 5379, 287, 6, 22, "Notes",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}]},
  "Internal`DistributedTermsList::poly2"->{
    Cell[152986, 5349, 337, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153326, 5360, 627, 17, 19, "Message",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}],
    Cell[153956, 5379, 287, 6, 22, "Notes",
      CellTags->{
      "GroebnerBasis::poly2", "PolynomialReduce::poly2", "Resultant::poly2", 
        "Internal`GroebnerWalk::poly2", 
        "Internal`DistributedTermsList::poly2"}]},
  "GroebnerBasis::wgtmat1"->{
    Cell[154280, 5390, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[154604, 5401, 505, 14, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155112, 5417, 524, 12, 57, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155661, 5433, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155856, 5439, 302, 7, 22, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156183, 5450, 305, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156491, 5459, 345, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[156839, 5468, 317, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[157171, 5477, 292, 8, 23, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157488, 5489, 303, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157794, 5498, 239, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}]},
  "PolynomialReduce::wgtmat1"->{
    Cell[154280, 5390, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[154604, 5401, 505, 14, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155112, 5417, 524, 12, 57, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155661, 5433, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155856, 5439, 302, 7, 22, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156183, 5450, 305, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156491, 5459, 345, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[156839, 5468, 317, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[157171, 5477, 292, 8, 23, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157488, 5489, 303, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157794, 5498, 239, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}]},
  "Internal`GroebnerWalk::wgtmat1"->{
    Cell[154280, 5390, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[154604, 5401, 505, 14, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155112, 5417, 524, 12, 57, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155661, 5433, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155856, 5439, 302, 7, 22, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156183, 5450, 305, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156491, 5459, 345, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[156839, 5468, 317, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[157171, 5477, 292, 8, 23, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157488, 5489, 303, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157794, 5498, 239, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}]},
  "Internal`DistributedTermsList::wgtmat1"->{
    Cell[154280, 5390, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[154604, 5401, 505, 14, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155112, 5417, 524, 12, 57, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155661, 5433, 192, 4, 38, "ExampleSection",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[155856, 5439, 302, 7, 22, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156183, 5450, 305, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[156491, 5459, 345, 7, 19, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[156839, 5468, 317, 6, 25, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}],
    Cell[157171, 5477, 292, 8, 23, "Text",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157488, 5489, 303, 7, 26, "Input",
      CellTags->{
      "GroebnerBasis::wgtmat1", "PolynomialReduce::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", 
        "Internal`DistributedTermsList::wgtmat1"}],
    Cell[157794, 5498, 239, 5, 27, "Output",
      CellTags->{
      "GroebnerBasis::wgtmat1", "Internal`DistributedTermsList::wgtmat1", 
        "Internal`GroebnerWalk::wgtmat1", "PolynomialReduce::wgtmat1"}]},
  "GroebnerBasis::wgtmat2"->{
    Cell[158094, 5510, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[158418, 5521, 664, 17, 33, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[159085, 5540, 370, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}]},
  "PolynomialReduce::wgtmat2"->{
    Cell[158094, 5510, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[158418, 5521, 664, 17, 33, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[159085, 5540, 370, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}]},
  "Internal`GroebnerWalk::wgtmat2"->{
    Cell[158094, 5510, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[158418, 5521, 664, 17, 33, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[159085, 5540, 370, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}]},
  "Internal`DistributedTermsList::wgtmat2"->{
    Cell[158094, 5510, 321, 9, 91, "ObjectNameWarningMessages",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[158418, 5521, 664, 17, 33, "Message",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}],
    Cell[159085, 5540, 370, 9, 37, "Notes",
      CellTags->{
      "GroebnerBasis::wgtmat2", "PolynomialReduce::wgtmat2", 
        "Internal`GroebnerWalk::wgtmat2", 
        "Internal`DistributedTermsList::wgtmat2"}]},
  "Integrate::gener"->{
    Cell[159492, 5554, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::gener"],
    Cell[159580, 5557, 151, 3, 19, "Message",
      CellTags->"Integrate::gener"],
    Cell[159734, 5562, 797, 14, 106, "Notes",
      CellTags->"Integrate::gener"]},
  "Integrate::idiv"->{
    Cell[160568, 5581, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::idiv"],
    Cell[160654, 5584, 363, 10, 19, "Message",
      CellTags->"Integrate::idiv"],
    Cell[161020, 5596, 144, 4, 22, "Notes",
      CellTags->"Integrate::idiv"],
    Cell[161189, 5604, 65, 1, 38, "ExampleSection",
      CellTags->"Integrate::idiv"],
    Cell[161257, 5607, 131, 4, 22, "Text",
      CellTags->"Integrate::idiv"],
    Cell[161413, 5615, 123, 3, 26, "Input",
      CellTags->"Integrate::idiv"],
    Cell[161539, 5620, 221, 5, 19, "Message",
      CellTags->"Integrate::idiv"],
    Cell[161763, 5627, 159, 4, 40, "Output",
      CellTags->"Integrate::idiv"],
    Cell[161937, 5634, 96, 1, 22, "Text",
      CellTags->"Integrate::idiv"],
    Cell[162058, 5639, 128, 3, 26, "Input",
      CellTags->"Integrate::idiv"],
    Cell[162189, 5644, 90, 3, 25, "Output",
      CellTags->"Integrate::idiv"]},
  "Integrate::ilim"->{
    Cell[162340, 5654, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::ilim"],
    Cell[162426, 5657, 339, 9, 19, "Message",
      CellTags->"Integrate::ilim"],
    Cell[162768, 5668, 674, 19, 57, "Notes",
      CellTags->"Integrate::ilim"],
    Cell[163467, 5691, 65, 1, 38, "ExampleSection",
      CellTags->"Integrate::ilim"],
    Cell[163535, 5694, 148, 4, 22, "Text",
      CellTags->"Integrate::ilim"],
    Cell[163708, 5702, 125, 3, 26, "Input",
      CellTags->"Integrate::ilim"],
    Cell[163836, 5707, 207, 5, 19, "Message",
      CellTags->"Integrate::ilim"],
    Cell[164046, 5714, 162, 4, 39, "Output",
      CellTags->"Integrate::ilim"],
    Cell[164223, 5721, 103, 1, 22, "Text",
      CellTags->"Integrate::ilim"],
    Cell[164351, 5726, 128, 3, 26, "Input",
      CellTags->"Integrate::ilim"],
    Cell[164482, 5731, 90, 3, 25, "Output",
      CellTags->"Integrate::ilim"]},
  "InterpolatingPolynomial::ipdat"->{
    Cell[164633, 5741, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[164749, 5744, 318, 6, 19, "Message",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[165070, 5752, 222, 5, 23, "Notes",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[165317, 5761, 80, 1, 38, "ExampleSection",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[165400, 5764, 163, 4, 22, "Text",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[165588, 5772, 142, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[165733, 5777, 256, 5, 33, "Message",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[165992, 5784, 143, 3, 25, "Output",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[166150, 5790, 160, 5, 23, "Text",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[166335, 5799, 140, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipdat"],
    Cell[166478, 5804, 158, 3, 40, "Output",
      CellTags->"InterpolatingPolynomial::ipdat"]},
  "InterpolatingPolynomial::ipdup"->{
    Cell[166697, 5814, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[166813, 5817, 183, 3, 19, "Message",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[166999, 5822, 259, 5, 37, "Notes",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[167283, 5831, 80, 1, 38, "ExampleSection",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[167366, 5834, 164, 4, 22, "Text",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[167555, 5842, 155, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[167713, 5847, 199, 4, 19, "Message",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[167915, 5853, 156, 3, 25, "Output",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[168086, 5859, 160, 5, 23, "Text",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[168271, 5868, 155, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipdup"],
    Cell[168429, 5873, 154, 3, 40, "Output",
      CellTags->"InterpolatingPolynomial::ipdup"]},
  "InterpolatingPolynomial::ipf"->{
    Cell[168644, 5883, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[168756, 5886, 511, 13, 33, "Message",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[169270, 5901, 467, 8, 71, "Notes",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[169762, 5913, 78, 1, 38, "ExampleSection",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[169843, 5916, 301, 7, 37, "Text",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[170169, 5927, 162, 4, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[170334, 5933, 274, 5, 33, "Message",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[170611, 5940, 163, 4, 25, "Output",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[170811, 5949, 158, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipf"],
    Cell[170972, 5954, 247, 5, 40, "Output",
      CellTags->"InterpolatingPolynomial::ipf"]},
  "InterpolatingPolynomial::ipval"->{
    Cell[171280, 5966, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[171396, 5969, 468, 12, 19, "Message",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[171867, 5983, 264, 6, 37, "Notes",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[172156, 5993, 80, 1, 38, "ExampleSection",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[172239, 5996, 159, 4, 22, "Text",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[172423, 6004, 160, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[172586, 6009, 246, 5, 33, "Message",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[172835, 6016, 161, 3, 25, "Output",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[173011, 6022, 160, 5, 23, "Text",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[173196, 6031, 160, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipval"],
    Cell[173359, 6036, 213, 4, 40, "Output",
      CellTags->"InterpolatingPolynomial::ipval"]},
  "InterpolatingPolynomial::ipvar"->{
    Cell[173633, 6047, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[173749, 6050, 264, 5, 19, "Message",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[174016, 6057, 378, 7, 57, "Notes",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[174419, 6068, 80, 1, 38, "ExampleSection",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[174502, 6071, 205, 5, 23, "Text",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[174732, 6080, 140, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[174875, 6085, 225, 5, 19, "Message",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[175103, 6092, 141, 3, 25, "Output",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[175259, 6098, 160, 5, 23, "Text",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[175444, 6107, 140, 3, 26, "Input",
      CellTags->"InterpolatingPolynomial::ipvar"],
    Cell[175587, 6112, 158, 3, 40, "Output",
      CellTags->"InterpolatingPolynomial::ipvar"]},
  "InverseFunction::ifun"->{
    Cell[175806, 6122, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InverseFunction::ifun"],
    Cell[175904, 6125, 234, 5, 33, "Message",
      CellTags->"InverseFunction::ifun"],
    Cell[176141, 6132, 353, 9, 42, "Notes",
      CellTags->"InverseFunction::ifun"],
    Cell[176519, 6145, 71, 1, 38, "ExampleSection",
      CellTags->"InverseFunction::ifun"],
    Cell[176593, 6148, 170, 5, 23, "Text",
      CellTags->"InverseFunction::ifun"],
    Cell[176788, 6157, 119, 3, 26, "Input",
      CellTags->"InverseFunction::ifun"],
    Cell[176910, 6162, 249, 7, 32, "Message",
      CellTags->"InverseFunction::ifun"],
    Cell[177162, 6171, 319, 9, 27, "Output",
      CellTags->"InverseFunction::ifun"]},
  "InverseFunction::noinv"->{
    Cell[177542, 6187, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InverseFunction::noinv"],
    Cell[177642, 6190, 250, 5, 19, "Message",
      CellTags->"InverseFunction::noinv"],
    Cell[177895, 6197, 233, 6, 42, "Notes",
      CellTags->"InverseFunction::noinv"],
    Cell[178153, 6207, 72, 1, 38, "ExampleSection",
      CellTags->"InverseFunction::noinv"],
    Cell[178228, 6210, 379, 14, 23, "Text",
      CellTags->"InverseFunction::noinv"],
    Cell[178632, 6228, 116, 3, 26, "Input",
      CellTags->"InverseFunction::noinv"],
    Cell[178751, 6233, 225, 5, 19, "Message",
      CellTags->"InverseFunction::noinv"],
    Cell[178979, 6240, 117, 3, 25, "Output",
      CellTags->"InverseFunction::noinv"]},
  "Limit::limf"->{
    Cell[179157, 6250, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Limit::limf"],
    Cell[179235, 6253, 249, 5, 19, "Message",
      CellTags->"Limit::limf"],
    Cell[179487, 6260, 420, 15, 38, "Notes",
      CellTags->"Limit::limf"],
    Cell[179932, 6279, 61, 1, 38, "ExampleSection",
      CellTags->"Limit::limf"],
    Cell[179996, 6282, 238, 6, 37, "Text",
      CellTags->"Limit::limf"],
    Cell[180259, 6292, 123, 3, 26, "Input",
      CellTags->"Limit::limf"],
    Cell[180385, 6297, 217, 5, 19, "Message",
      CellTags->"Limit::limf"],
    Cell[180605, 6304, 141, 3, 25, "Output",
      CellTags->"Limit::limf"],
    Cell[180761, 6310, 184, 6, 23, "Text",
      CellTags->"Limit::limf"],
    Cell[180970, 6320, 146, 4, 26, "Input",
      CellTags->"Limit::limf"],
    Cell[181119, 6326, 86, 3, 25, "Output",
      CellTags->"Limit::limf"]},
  "Solve::ibool"->{
    Cell[181266, 6336, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[181629, 6350, 670, 18, 19, "Message",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182302, 6370, 389, 9, 37, "Notes",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182716, 6383, 216, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182935, 6389, 368, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183328, 6403, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183617, 6411, 371, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[183991, 6421, 317, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[184323, 6431, 336, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184684, 6445, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184973, 6453, 260, 6, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}]},
  "Reduce::ibool"->{
    Cell[181266, 6336, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[181629, 6350, 670, 18, 19, "Message",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182302, 6370, 389, 9, 37, "Notes",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182716, 6383, 216, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182935, 6389, 368, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183328, 6403, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183617, 6411, 371, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[183991, 6421, 317, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[184323, 6431, 336, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184684, 6445, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184973, 6453, 260, 6, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}]},
  "System`Private`OldReduce::ibool"->{
    Cell[181266, 6336, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[181629, 6350, 670, 18, 19, "Message",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182302, 6370, 389, 9, 37, "Notes",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182716, 6383, 216, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182935, 6389, 368, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183328, 6403, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183617, 6411, 371, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[183991, 6421, 317, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[184323, 6431, 336, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184684, 6445, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184973, 6453, 260, 6, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}]},
  "Eliminate::ibool"->{
    Cell[181266, 6336, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[181629, 6350, 670, 18, 19, "Message",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182302, 6370, 389, 9, 37, "Notes",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182716, 6383, 216, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182935, 6389, 368, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183328, 6403, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183617, 6411, 371, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[183991, 6421, 317, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[184323, 6431, 336, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184684, 6445, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184973, 6453, 260, 6, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}]},
  "SolveAlways::ibool"->{
    Cell[181266, 6336, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[181629, 6350, 670, 18, 19, "Message",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182302, 6370, 389, 9, 37, "Notes",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182716, 6383, 216, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182935, 6389, 368, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183328, 6403, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183617, 6411, 371, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[183991, 6421, 317, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[184323, 6431, 336, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184684, 6445, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184973, 6453, 260, 6, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}]},
  "MainSolve::ibool"->{
    Cell[181266, 6336, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[181629, 6350, 670, 18, 19, "Message",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182302, 6370, 389, 9, 37, "Notes",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182716, 6383, 216, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182935, 6389, 368, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183328, 6403, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183617, 6411, 371, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[183991, 6421, 317, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[184323, 6431, 336, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184684, 6445, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184973, 6453, 260, 6, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}]},
  "AlgebraicRules::ibool"->{
    Cell[181266, 6336, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[181629, 6350, 670, 18, 19, "Message",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182302, 6370, 389, 9, 37, "Notes",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182716, 6383, 216, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[182935, 6389, 368, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183328, 6403, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[183617, 6411, 371, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[183991, 6421, 317, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}],
    Cell[184323, 6431, 336, 10, 23, "Text",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184684, 6445, 286, 6, 26, "Input",
      CellTags->{
      "Solve::ibool", "Reduce::ibool", "System`Private`OldReduce::ibool", 
        "Eliminate::ibool", "SolveAlways::ibool", "MainSolve::ibool", 
        "AlgebraicRules::ibool"}],
    Cell[184973, 6453, 260, 6, 25, "Output",
      CellTags->{
      "AlgebraicRules::ibool", "Eliminate::ibool", "MainSolve::ibool", 
        "Reduce::ibool", "SolveAlways::ibool", "Solve::ibool", 
        "System`Private`OldReduce::ibool"}]},
  "Solve::method"->{
    Cell[185294, 6466, 374, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[185671, 6480, 642, 18, 19, "Message",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186316, 6500, 382, 8, 23, "Notes",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186723, 6512, 223, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186949, 6518, 407, 12, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187381, 6534, 319, 7, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187703, 6543, 359, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188065, 6553, 337, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188417, 6563, 333, 10, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[188775, 6577, 304, 6, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[189082, 6585, 297, 6, 27, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}]},
  "Reduce::method"->{
    Cell[185294, 6466, 374, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[185671, 6480, 642, 18, 19, "Message",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186316, 6500, 382, 8, 23, "Notes",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186723, 6512, 223, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186949, 6518, 407, 12, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187381, 6534, 319, 7, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187703, 6543, 359, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188065, 6553, 337, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188417, 6563, 333, 10, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[188775, 6577, 304, 6, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[189082, 6585, 297, 6, 27, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}]},
  "System`Private`OldReduce::method"->{
    Cell[185294, 6466, 374, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[185671, 6480, 642, 18, 19, "Message",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186316, 6500, 382, 8, 23, "Notes",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186723, 6512, 223, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186949, 6518, 407, 12, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187381, 6534, 319, 7, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187703, 6543, 359, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188065, 6553, 337, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188417, 6563, 333, 10, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[188775, 6577, 304, 6, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[189082, 6585, 297, 6, 27, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}]},
  "Eliminate::method"->{
    Cell[185294, 6466, 374, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[185671, 6480, 642, 18, 19, "Message",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186316, 6500, 382, 8, 23, "Notes",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186723, 6512, 223, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186949, 6518, 407, 12, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187381, 6534, 319, 7, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187703, 6543, 359, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188065, 6553, 337, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188417, 6563, 333, 10, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[188775, 6577, 304, 6, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[189082, 6585, 297, 6, 27, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}]},
  "SolveAlways::method"->{
    Cell[185294, 6466, 374, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[185671, 6480, 642, 18, 19, "Message",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186316, 6500, 382, 8, 23, "Notes",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186723, 6512, 223, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186949, 6518, 407, 12, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187381, 6534, 319, 7, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187703, 6543, 359, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188065, 6553, 337, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188417, 6563, 333, 10, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[188775, 6577, 304, 6, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[189082, 6585, 297, 6, 27, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}]},
  "MainSolve::method"->{
    Cell[185294, 6466, 374, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[185671, 6480, 642, 18, 19, "Message",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186316, 6500, 382, 8, 23, "Notes",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186723, 6512, 223, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186949, 6518, 407, 12, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187381, 6534, 319, 7, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187703, 6543, 359, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188065, 6553, 337, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188417, 6563, 333, 10, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[188775, 6577, 304, 6, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[189082, 6585, 297, 6, 27, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}]},
  "AlgebraicRules::method"->{
    Cell[185294, 6466, 374, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[185671, 6480, 642, 18, 19, "Message",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186316, 6500, 382, 8, 23, "Notes",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186723, 6512, 223, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[186949, 6518, 407, 12, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187381, 6534, 319, 7, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[187703, 6543, 359, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188065, 6553, 337, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}],
    Cell[188417, 6563, 333, 10, 23, "Text",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[188775, 6577, 304, 6, 26, "Input",
      CellTags->{
      "Solve::method", "Reduce::method", "System`Private`OldReduce::method", 
        "Eliminate::method", "SolveAlways::method", "MainSolve::method", 
        "AlgebraicRules::method"}],
    Cell[189082, 6585, 297, 6, 27, "Output",
      CellTags->{
      "AlgebraicRules::method", "Eliminate::method", "MainSolve::method", 
        "Reduce::method", "SolveAlways::method", "Solve::method", 
        "System`Private`OldReduce::method"}]},
  "Solve::mode"->{
    Cell[189440, 6598, 346, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[189789, 6612, 654, 18, 19, "Message",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190446, 6632, 342, 8, 23, "Notes",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190813, 6644, 209, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191025, 6650, 354, 10, 23, "Text",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191404, 6664, 301, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191708, 6673, 360, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192071, 6683, 319, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192427, 6695, 294, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[192724, 6704, 345, 8, 30, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}]},
  "Reduce::mode"->{
    Cell[189440, 6598, 346, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[189789, 6612, 654, 18, 19, "Message",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190446, 6632, 342, 8, 23, "Notes",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190813, 6644, 209, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191025, 6650, 354, 10, 23, "Text",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191404, 6664, 301, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191708, 6673, 360, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192071, 6683, 319, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192427, 6695, 294, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[192724, 6704, 345, 8, 30, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}]},
  "System`Private`OldReduce::mode"->{
    Cell[189440, 6598, 346, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[189789, 6612, 654, 18, 19, "Message",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190446, 6632, 342, 8, 23, "Notes",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190813, 6644, 209, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191025, 6650, 354, 10, 23, "Text",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191404, 6664, 301, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191708, 6673, 360, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192071, 6683, 319, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192427, 6695, 294, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[192724, 6704, 345, 8, 30, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}]},
  "Eliminate::mode"->{
    Cell[189440, 6598, 346, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[189789, 6612, 654, 18, 19, "Message",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190446, 6632, 342, 8, 23, "Notes",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190813, 6644, 209, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191025, 6650, 354, 10, 23, "Text",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191404, 6664, 301, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191708, 6673, 360, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192071, 6683, 319, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192427, 6695, 294, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[192724, 6704, 345, 8, 30, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}]},
  "SolveAlways::mode"->{
    Cell[189440, 6598, 346, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[189789, 6612, 654, 18, 19, "Message",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190446, 6632, 342, 8, 23, "Notes",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190813, 6644, 209, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191025, 6650, 354, 10, 23, "Text",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191404, 6664, 301, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191708, 6673, 360, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192071, 6683, 319, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192427, 6695, 294, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[192724, 6704, 345, 8, 30, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}]},
  "MainSolve::mode"->{
    Cell[189440, 6598, 346, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[189789, 6612, 654, 18, 19, "Message",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190446, 6632, 342, 8, 23, "Notes",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190813, 6644, 209, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191025, 6650, 354, 10, 23, "Text",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191404, 6664, 301, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191708, 6673, 360, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192071, 6683, 319, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192427, 6695, 294, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[192724, 6704, 345, 8, 30, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}]},
  "AlgebraicRules::mode"->{
    Cell[189440, 6598, 346, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[189789, 6612, 654, 18, 19, "Message",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190446, 6632, 342, 8, 23, "Notes",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[190813, 6644, 209, 4, 38, "ExampleSection",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191025, 6650, 354, 10, 23, "Text",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191404, 6664, 301, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[191708, 6673, 360, 8, 19, "Message",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192071, 6683, 319, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}],
    Cell[192427, 6695, 294, 7, 26, "Input",
      CellTags->{
      "Solve::mode", "Reduce::mode", "System`Private`OldReduce::mode", 
        "Eliminate::mode", "SolveAlways::mode", "MainSolve::mode", 
        "AlgebraicRules::mode"}],
    Cell[192724, 6704, 345, 8, 30, "Output",
      CellTags->{
      "AlgebraicRules::mode", "Eliminate::mode", "MainSolve::mode", 
        "Reduce::mode", "SolveAlways::mode", "Solve::mode", 
        "System`Private`OldReduce::mode"}]},
  "Solve::verif"->{
    Cell[193130, 6719, 314, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[193447, 6731, 634, 15, 33, "Message",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194084, 6748, 314, 7, 22, "Notes",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194423, 6759, 189, 3, 38, "ExampleSection",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194615, 6764, 332, 7, 36, "Text",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194972, 6775, 237, 5, 26, "Input",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[195212, 6782, 388, 8, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195603, 6792, 390, 7, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195996, 6801, 215, 5, 25, "Output",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", 
        "System`Private`OldReduce::verif"}]},
  "Reduce::verif"->{
    Cell[193130, 6719, 314, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[193447, 6731, 634, 15, 33, "Message",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194084, 6748, 314, 7, 22, "Notes",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194423, 6759, 189, 3, 38, "ExampleSection",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194615, 6764, 332, 7, 36, "Text",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194972, 6775, 237, 5, 26, "Input",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[195212, 6782, 388, 8, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195603, 6792, 390, 7, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195996, 6801, 215, 5, 25, "Output",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", 
        "System`Private`OldReduce::verif"}]},
  "System`Private`OldReduce::verif"->{
    Cell[193130, 6719, 314, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[193447, 6731, 634, 15, 33, "Message",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194084, 6748, 314, 7, 22, "Notes",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194423, 6759, 189, 3, 38, "ExampleSection",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194615, 6764, 332, 7, 36, "Text",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194972, 6775, 237, 5, 26, "Input",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[195212, 6782, 388, 8, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195603, 6792, 390, 7, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195996, 6801, 215, 5, 25, "Output",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", 
        "System`Private`OldReduce::verif"}]},
  "Eliminate::verif"->{
    Cell[193130, 6719, 314, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[193447, 6731, 634, 15, 33, "Message",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194084, 6748, 314, 7, 22, "Notes",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194423, 6759, 189, 3, 38, "ExampleSection",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194615, 6764, 332, 7, 36, "Text",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194972, 6775, 237, 5, 26, "Input",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[195212, 6782, 388, 8, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195603, 6792, 390, 7, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195996, 6801, 215, 5, 25, "Output",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", 
        "System`Private`OldReduce::verif"}]},
  "MainSolve::verif"->{
    Cell[193130, 6719, 314, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[193447, 6731, 634, 15, 33, "Message",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194084, 6748, 314, 7, 22, "Notes",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194423, 6759, 189, 3, 38, "ExampleSection",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194615, 6764, 332, 7, 36, "Text",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194972, 6775, 237, 5, 26, "Input",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[195212, 6782, 388, 8, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195603, 6792, 390, 7, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195996, 6801, 215, 5, 25, "Output",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", 
        "System`Private`OldReduce::verif"}]},
  "AlgebraicRules::verif"->{
    Cell[193130, 6719, 314, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[193447, 6731, 634, 15, 33, "Message",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194084, 6748, 314, 7, 22, "Notes",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194423, 6759, 189, 3, 38, "ExampleSection",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194615, 6764, 332, 7, 36, "Text",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[194972, 6775, 237, 5, 26, "Input",
      CellTags->{
      "Solve::verif", "Reduce::verif", "System`Private`OldReduce::verif", 
        "Eliminate::verif", "MainSolve::verif", "AlgebraicRules::verif"}],
    Cell[195212, 6782, 388, 8, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195603, 6792, 390, 7, 33, "Message",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", "System`Private`OldReduce::verif"}],
    Cell[195996, 6801, 215, 5, 25, "Output",
      CellTags->{
      "AlgebraicRules::verif", "Eliminate::verif", "MainSolve::verif", 
        "Reduce::verif", "Solve::verif", 
        "System`Private`OldReduce::verif"}]},
  "Root::amb"->{
    Cell[196272, 6813, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::amb"],
    Cell[196346, 6816, 364, 8, 33, "Message",
      CellTags->"Root::amb"],
    Cell[196713, 6826, 193, 5, 22, "Notes",
      CellTags->"Root::amb"]},
  "Root::deg"->{
    Cell[196943, 6836, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::deg"],
    Cell[197017, 6839, 417, 12, 19, "Message",
      CellTags->"Root::deg"],
    Cell[197437, 6853, 158, 4, 22, "Notes",
      CellTags->"Root::deg"],
    Cell[197620, 6861, 59, 1, 38, "ExampleSection",
      CellTags->"Root::deg"],
    Cell[197682, 6864, 134, 4, 22, "Text",
      CellTags->"Root::deg"],
    Cell[197841, 6872, 98, 3, 26, "Input",
      CellTags->"Root::deg"],
    Cell[197942, 6877, 209, 5, 21, "Message",
      CellTags->"Root::deg"],
    Cell[198154, 6884, 105, 3, 27, "Output",
      CellTags->"Root::deg"],
    Cell[198274, 6890, 120, 5, 23, "Text",
      CellTags->"Root::deg"],
    Cell[198419, 6899, 98, 3, 26, "Input",
      CellTags->"Root::deg"],
    Cell[198520, 6904, 86, 3, 28, "Output",
      CellTags->"Root::deg"]},
  "General::rnum"->{
    Cell[198667, 6914, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::rnum"],
    Cell[198749, 6917, 324, 10, 19, "Message",
      CellTags->"General::rnum"],
    Cell[199076, 6929, 412, 11, 57, "Notes",
      CellTags->"General::rnum"],
    Cell[199513, 6944, 63, 1, 38, "ExampleSection",
      CellTags->"General::rnum"],
    Cell[199579, 6947, 127, 4, 22, "Text",
      CellTags->"General::rnum"],
    Cell[199731, 6955, 102, 3, 26, "Input",
      CellTags->"General::rnum"],
    Cell[199836, 6960, 166, 4, 19, "Message",
      CellTags->"General::rnum"],
    Cell[200005, 6966, 109, 3, 27, "Output",
      CellTags->"General::rnum"],
    Cell[200129, 6972, 124, 5, 23, "Text",
      CellTags->"General::rnum"],
    Cell[200278, 6981, 102, 3, 26, "Input",
      CellTags->"General::rnum"],
    Cell[200383, 6986, 90, 3, 28, "Output",
      CellTags->"General::rnum"]},
  "Root::rnv"->{
    Cell[200534, 6996, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::rnv"],
    Cell[200608, 6999, 228, 5, 19, "Message",
      CellTags->"Root::rnv"],
    Cell[200839, 7006, 228, 6, 23, "Notes",
      CellTags->"Root::rnv"],
    Cell[201092, 7016, 59, 1, 38, "ExampleSection",
      CellTags->"Root::rnv"],
    Cell[201154, 7019, 123, 4, 22, "Text",
      CellTags->"Root::rnv"],
    Cell[201302, 7027, 103, 3, 26, "Input",
      CellTags->"Root::rnv"],
    Cell[201408, 7032, 191, 5, 21, "Message",
      CellTags->"Root::rnv"],
    Cell[201602, 7039, 111, 3, 27, "Output",
      CellTags->"Root::rnv"],
    Cell[201728, 7045, 120, 5, 23, "Text",
      CellTags->"Root::rnv"],
    Cell[201873, 7054, 101, 3, 26, "Input",
      CellTags->"Root::rnv"],
    Cell[201977, 7059, 86, 3, 28, "Output",
      CellTags->"Root::rnv"]},
  "Root::var"->{
    Cell[202124, 7069, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::var"],
    Cell[202198, 7072, 195, 5, 19, "Message",
      CellTags->"Root::var"],
    Cell[202396, 7079, 206, 6, 23, "Notes",
      CellTags->"Root::var"],
    Cell[202627, 7089, 59, 1, 38, "ExampleSection",
      CellTags->"Root::var"],
    Cell[202689, 7092, 157, 4, 22, "Text",
      CellTags->"Root::var"],
    Cell[202871, 7100, 106, 3, 26, "Input",
      CellTags->"Root::var"],
    Cell[202980, 7105, 158, 4, 19, "Message",
      CellTags->"Root::var"],
    Cell[203141, 7111, 109, 3, 27, "Output",
      CellTags->"Root::var"],
    Cell[203265, 7117, 120, 5, 23, "Text",
      CellTags->"Root::var"],
    Cell[203410, 7126, 106, 3, 26, "Input",
      CellTags->"Root::var"],
    Cell[203519, 7131, 94, 3, 33, "Output",
      CellTags->"Root::var"]},
  "RootSum::pfn"->{
    Cell[203674, 7141, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RootSum::pfn"],
    Cell[203754, 7144, 200, 5, 19, "Message",
      CellTags->"RootSum::pfn"],
    Cell[203957, 7151, 212, 7, 23, "Notes",
      CellTags->"RootSum::pfn"],
    Cell[204194, 7162, 62, 1, 38, "ExampleSection",
      CellTags->"RootSum::pfn"],
    Cell[204259, 7165, 236, 7, 37, "Text",
      CellTags->"RootSum::pfn"],
    Cell[204520, 7176, 108, 3, 26, "Input",
      CellTags->"RootSum::pfn"],
    Cell[204631, 7181, 174, 4, 21, "Message",
      CellTags->"RootSum::pfn"],
    Cell[204808, 7187, 110, 3, 27, "Output",
      CellTags->"RootSum::pfn"],
    Cell[204933, 7193, 126, 5, 23, "Text",
      CellTags->"RootSum::pfn"],
    Cell[205084, 7202, 119, 3, 30, "Input",
      CellTags->"RootSum::pfn"],
    Cell[205206, 7207, 121, 3, 27, "Output",
      CellTags->"RootSum::pfn"]},
  "Roots::badmod"->{
    Cell[205388, 7217, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Roots::badmod"],
    Cell[205470, 7220, 315, 8, 19, "Message",
      CellTags->"Roots::badmod"],
    Cell[205788, 7230, 251, 6, 42, "Notes",
      CellTags->"Roots::badmod"]},
  "Series::esss"->{
    Cell[206076, 7241, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::esss"],
    Cell[206156, 7244, 229, 5, 19, "Message",
      CellTags->"Series::esss"],
    Cell[206388, 7251, 410, 8, 57, "Notes",
      CellTags->"Series::esss"],
    Cell[206823, 7263, 62, 1, 38, "ExampleSection",
      CellTags->"Series::esss"],
    Cell[206888, 7266, 168, 4, 22, "Text",
      CellTags->"Series::esss"],
    Cell[207081, 7274, 112, 3, 26, "Input",
      CellTags->"Series::esss"],
    Cell[207196, 7279, 414, 7, 34, "Message",
      CellTags->"Series::esss"],
    Cell[207613, 7288, 95, 3, 40, "Output",
      CellTags->"Series::esss"]},
  "Series::icm"->{
    Cell[207769, 7298, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::icm"],
    Cell[207847, 7301, 459, 13, 19, "Message",
      CellTags->"Series::icm"],
    Cell[208309, 7316, 198, 5, 22, "Notes",
      CellTags->"Series::icm"],
    Cell[208532, 7325, 61, 1, 38, "ExampleSection",
      CellTags->"Series::icm"],
    Cell[208596, 7328, 170, 4, 22, "Text",
      CellTags->"Series::icm"],
    Cell[208791, 7336, 137, 3, 26, "Input",
      CellTags->"Series::icm"],
    Cell[208931, 7341, 215, 5, 19, "Message",
      CellTags->"Series::icm"],
    Cell[209149, 7348, 1123, 34, 74, "Output",
      CellTags->"Series::icm"],
    Cell[210287, 7385, 124, 4, 22, "Text",
      CellTags->"Series::icm"],
    Cell[210436, 7393, 137, 3, 26, "Input",
      CellTags->"Series::icm"],
    Cell[210576, 7398, 739, 25, 40, "Output",
      CellTags->"Series::icm"]},
  "Series::lss"->{
    Cell[211376, 7430, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::lss"],
    Cell[211454, 7433, 229, 5, 19, "Message",
      CellTags->"Series::lss"],
    Cell[211686, 7440, 438, 9, 70, "Notes",
      CellTags->"Series::lss"]},
  "Series::nmer"->{
    Cell[212161, 7454, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::nmer"],
    Cell[212241, 7457, 406, 12, 19, "Message",
      CellTags->"Series::nmer"],
    Cell[212650, 7471, 230, 8, 23, "Notes",
      CellTags->"Series::nmer"]},
  "Series::sbyc"->{
    Cell[212917, 7484, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::sbyc"],
    Cell[212997, 7487, 275, 6, 19, "Message",
      CellTags->"Series::sbyc"],
    Cell[213275, 7495, 184, 5, 22, "Notes",
      CellTags->"Series::sbyc"],
    Cell[213484, 7504, 62, 1, 38, "ExampleSection",
      CellTags->"Series::sbyc"],
    Cell[213549, 7507, 128, 4, 22, "Text",
      CellTags->"Series::sbyc"],
    Cell[213702, 7515, 91, 3, 26, "Input",
      CellTags->"Series::sbyc"],
    Cell[213796, 7520, 310, 6, 36, "Message",
      CellTags->"Series::sbyc"],
    Cell[214109, 7528, 175, 5, 42, "Output",
      CellTags->"Series::sbyc"],
    Cell[214299, 7536, 79, 1, 22, "Text",
      CellTags->"Series::sbyc"],
    Cell[214403, 7541, 122, 3, 26, "Input",
      CellTags->"Series::sbyc"],
    Cell[214528, 7546, 310, 6, 36, "Message",
      CellTags->"Series::sbyc"],
    Cell[214841, 7554, 178, 5, 42, "Output",
      CellTags->"Series::sbyc"],
    Cell[215034, 7562, 132, 4, 22, "Text",
      CellTags->"Series::sbyc"],
    Cell[215191, 7570, 122, 3, 26, "Input",
      CellTags->"Series::sbyc"],
    Cell[215316, 7575, 308, 9, 40, "Output",
      CellTags->"Series::sbyc"]},
  "Series::serlim"->{
    Cell[215685, 7591, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::serlim"],
    Cell[215769, 7594, 330, 8, 19, "Message",
      CellTags->"Series::serlim"],
    Cell[216102, 7604, 240, 5, 36, "Notes",
      CellTags->"Series::serlim"],
    Cell[216367, 7613, 64, 1, 38, "ExampleSection",
      CellTags->"Series::serlim"],
    Cell[216434, 7616, 155, 4, 22, "Text",
      CellTags->"Series::serlim"],
    Cell[216614, 7624, 112, 3, 26, "Input",
      CellTags->"Series::serlim"],
    Cell[216729, 7629, 203, 5, 19, "Message",
      CellTags->"Series::serlim"],
    Cell[216935, 7636, 113, 3, 25, "Output",
      CellTags->"Series::serlim"],
    Cell[217063, 7642, 125, 4, 22, "Text",
      CellTags->"Series::serlim"],
    Cell[217213, 7650, 112, 3, 26, "Input",
      CellTags->"Series::serlim"],
    Cell[217328, 7655, 348, 10, 43, "Output",
      CellTags->"Series::serlim"]},
  "Series::sspec"->{
    Cell[217737, 7672, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::sspec"],
    Cell[217819, 7675, 262, 6, 19, "Message",
      CellTags->"Series::sspec"],
    Cell[218084, 7683, 385, 9, 57, "Notes",
      CellTags->"Series::sspec"],
    Cell[218494, 7696, 63, 1, 38, "ExampleSection",
      CellTags->"Series::sspec"],
    Cell[218560, 7699, 166, 4, 22, "Text",
      CellTags->"Series::sspec"],
    Cell[218751, 7707, 105, 3, 26, "Input",
      CellTags->"Series::sspec"],
    Cell[218859, 7712, 199, 5, 19, "Message",
      CellTags->"Series::sspec"],
    Cell[219061, 7719, 104, 3, 25, "Output",
      CellTags->"Series::sspec"],
    Cell[219180, 7725, 126, 5, 23, "Text",
      CellTags->"Series::sspec"],
    Cell[219331, 7734, 111, 3, 26, "Input",
      CellTags->"Series::sspec"],
    Cell[219445, 7739, 347, 10, 43, "Output",
      CellTags->"Series::sspec"]},
  "Series::vcnt"->{
    Cell[219853, 7756, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Series::vcnt"],
    Cell[219933, 7759, 414, 11, 19, "Message",
      CellTags->"Series::vcnt"],
    Cell[220350, 7772, 236, 6, 37, "Notes",
      CellTags->"Series::vcnt"],
    Cell[220611, 7782, 62, 1, 38, "ExampleSection",
      CellTags->"Series::vcnt"],
    Cell[220676, 7785, 159, 4, 22, "Text",
      CellTags->"Series::vcnt"],
    Cell[220860, 7793, 110, 3, 26, "Input",
      CellTags->"Series::vcnt"],
    Cell[220973, 7798, 211, 5, 19, "Message",
      CellTags->"Series::vcnt"],
    Cell[221187, 7805, 111, 3, 25, "Output",
      CellTags->"Series::vcnt"],
    Cell[221313, 7811, 115, 4, 22, "Text",
      CellTags->"Series::vcnt"],
    Cell[221453, 7819, 111, 3, 26, "Input",
      CellTags->"Series::vcnt"],
    Cell[221567, 7824, 636, 20, 40, "Output",
      CellTags->"Series::vcnt"]},
  "SeriesData::csa"->{
    Cell[222264, 7851, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::csa"],
    Cell[222350, 7854, 326, 9, 19, "Message",
      CellTags->"SeriesData::csa"],
    Cell[222679, 7865, 317, 8, 43, "Notes",
      CellTags->"SeriesData::csa"],
    Cell[223021, 7877, 65, 1, 38, "ExampleSection",
      CellTags->"SeriesData::csa"],
    Cell[223089, 7880, 143, 4, 22, "Text",
      CellTags->"SeriesData::csa"],
    Cell[223257, 7888, 133, 3, 26, "Input",
      CellTags->"SeriesData::csa"],
    Cell[223393, 7893, 477, 8, 37, "Message",
      CellTags->"SeriesData::csa"],
    Cell[223873, 7903, 455, 12, 43, "Output",
      CellTags->"SeriesData::csa"],
    Cell[224343, 7918, 135, 5, 23, "Text",
      CellTags->"SeriesData::csa"],
    Cell[224503, 7927, 159, 4, 26, "Input",
      CellTags->"SeriesData::csa"],
    Cell[224665, 7933, 355, 10, 43, "Output",
      CellTags->"SeriesData::csa"]},
  "SeriesData::scmn"->{
    Cell[225081, 7950, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::scmn"],
    Cell[225169, 7953, 243, 5, 19, "Message",
      CellTags->"SeriesData::scmn"],
    Cell[225415, 7960, 159, 4, 22, "Notes",
      CellTags->"SeriesData::scmn"],
    Cell[225599, 7968, 66, 1, 38, "ExampleSection",
      CellTags->"SeriesData::scmn"],
    Cell[225668, 7971, 171, 4, 22, "Text",
      CellTags->"SeriesData::scmn"],
    Cell[225864, 7979, 150, 4, 26, "Input",
      CellTags->"SeriesData::scmn"],
    Cell[226017, 7985, 396, 7, 34, "Message",
      CellTags->"SeriesData::scmn"],
    Cell[226416, 7994, 652, 18, 40, "Output",
      CellTags->"SeriesData::scmn"],
    Cell[227083, 8015, 172, 4, 22, "Text",
      CellTags->"SeriesData::scmn"],
    Cell[227280, 8023, 140, 3, 26, "Input",
      CellTags->"SeriesData::scmn"],
    Cell[227423, 8028, 396, 7, 34, "Message",
      CellTags->"SeriesData::scmn"],
    Cell[227822, 8037, 1039, 28, 41, "Output",
      CellTags->"SeriesData::scmn"]},
  "SeriesData::scmp"->{
    Cell[228922, 8072, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::scmp"],
    Cell[229010, 8075, 449, 11, 19, "Message",
      CellTags->"SeriesData::scmp"],
    Cell[229462, 8088, 217, 5, 36, "Notes",
      CellTags->"SeriesData::scmp"],
    Cell[229704, 8097, 66, 1, 38, "ExampleSection",
      CellTags->"SeriesData::scmp"],
    Cell[229773, 8100, 194, 5, 36, "Text",
      CellTags->"SeriesData::scmp"],
    Cell[229992, 8109, 158, 4, 26, "Input",
      CellTags->"SeriesData::scmp"],
    Cell[230153, 8115, 703, 11, 53, "Message",
      CellTags->"SeriesData::scmp"],
    Cell[230859, 8128, 722, 19, 43, "Output",
      CellTags->"SeriesData::scmp"],
    Cell[231596, 8150, 86, 1, 22, "Text",
      CellTags->"SeriesData::scmp"],
    Cell[231707, 8155, 162, 4, 26, "Input",
      CellTags->"SeriesData::scmp"],
    Cell[231872, 8161, 367, 10, 40, "Output",
      CellTags->"SeriesData::scmp"]},
  "SeriesData::sdatc"->{
    Cell[232300, 8178, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::sdatc"],
    Cell[232390, 8181, 354, 9, 19, "Message",
      CellTags->"SeriesData::sdatc"],
    Cell[232747, 8192, 523, 13, 78, "Notes",
      CellTags->"SeriesData::sdatc"],
    Cell[233295, 8209, 67, 1, 38, "ExampleSection",
      CellTags->"SeriesData::sdatc"],
    Cell[233365, 8212, 197, 5, 23, "Text",
      CellTags->"SeriesData::sdatc"],
    Cell[233587, 8221, 119, 3, 26, "Input",
      CellTags->"SeriesData::sdatc"],
    Cell[233709, 8226, 239, 5, 19, "Message",
      CellTags->"SeriesData::sdatc"],
    Cell[233951, 8233, 120, 3, 25, "Output",
      CellTags->"SeriesData::sdatc"],
    Cell[234086, 8239, 134, 5, 23, "Text",
      CellTags->"SeriesData::sdatc"],
    Cell[234245, 8248, 121, 3, 26, "Input",
      CellTags->"SeriesData::sdatc"],
    Cell[234369, 8253, 328, 9, 27, "Output",
      CellTags->"SeriesData::sdatc"]},
  "SeriesData::sdatd"->{
    Cell[234758, 8269, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::sdatd"],
    Cell[234848, 8272, 403, 10, 19, "Message",
      CellTags->"SeriesData::sdatd"],
    Cell[235254, 8284, 478, 12, 72, "Notes",
      CellTags->"SeriesData::sdatd"],
    Cell[235757, 8300, 67, 1, 38, "ExampleSection",
      CellTags->"SeriesData::sdatd"],
    Cell[235827, 8303, 200, 6, 23, "Text",
      CellTags->"SeriesData::sdatd"],
    Cell[236052, 8313, 123, 3, 26, "Input",
      CellTags->"SeriesData::sdatd"],
    Cell[236178, 8318, 293, 6, 33, "Message",
      CellTags->"SeriesData::sdatd"],
    Cell[236474, 8326, 124, 3, 25, "Output",
      CellTags->"SeriesData::sdatd"],
    Cell[236613, 8332, 134, 5, 23, "Text",
      CellTags->"SeriesData::sdatd"],
    Cell[236772, 8341, 128, 3, 26, "Input",
      CellTags->"SeriesData::sdatd"],
    Cell[236903, 8346, 387, 10, 27, "Output",
      CellTags->"SeriesData::sdatd"]},
  "SeriesData::sdatn"->{
    Cell[237351, 8363, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::sdatn"],
    Cell[237441, 8366, 375, 10, 19, "Message",
      CellTags->"SeriesData::sdatn"],
    Cell[237819, 8378, 310, 7, 37, "Notes",
      CellTags->"SeriesData::sdatn"],
    Cell[238154, 8389, 67, 1, 38, "ExampleSection",
      CellTags->"SeriesData::sdatn"],
    Cell[238224, 8392, 200, 6, 23, "Text",
      CellTags->"SeriesData::sdatn"],
    Cell[238449, 8402, 127, 3, 26, "Input",
      CellTags->"SeriesData::sdatn"],
    Cell[238579, 8407, 274, 5, 33, "Message",
      CellTags->"SeriesData::sdatn"],
    Cell[238856, 8414, 128, 3, 25, "Output",
      CellTags->"SeriesData::sdatn"],
    Cell[238999, 8420, 134, 5, 23, "Text",
      CellTags->"SeriesData::sdatn"],
    Cell[239158, 8429, 126, 3, 26, "Input",
      CellTags->"SeriesData::sdatn"],
    Cell[239287, 8434, 396, 10, 27, "Output",
      CellTags->"SeriesData::sdatn"]},
  "SeriesData::sdatv"->{
    Cell[239744, 8451, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::sdatv"],
    Cell[239834, 8454, 252, 6, 19, "Message",
      CellTags->"SeriesData::sdatv"],
    Cell[240089, 8462, 392, 8, 57, "Notes",
      CellTags->"SeriesData::sdatv"],
    Cell[240506, 8474, 67, 1, 38, "ExampleSection",
      CellTags->"SeriesData::sdatv"],
    Cell[240576, 8477, 188, 6, 23, "Text",
      CellTags->"SeriesData::sdatv"],
    Cell[240789, 8487, 132, 3, 26, "Input",
      CellTags->"SeriesData::sdatv"],
    Cell[240924, 8492, 193, 4, 19, "Message",
      CellTags->"SeriesData::sdatv"],
    Cell[241120, 8498, 436, 12, 27, "Output",
      CellTags->"SeriesData::sdatv"],
    Cell[241571, 8513, 134, 5, 23, "Text",
      CellTags->"SeriesData::sdatv"],
    Cell[241730, 8522, 129, 3, 26, "Input",
      CellTags->"SeriesData::sdatv"],
    Cell[241862, 8527, 353, 9, 27, "Output",
      CellTags->"SeriesData::sdatv"]},
  "SeriesData::slnc"->{
    Cell[242276, 8543, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::slnc"],
    Cell[242364, 8546, 252, 5, 19, "Message",
      CellTags->"SeriesData::slnc"],
    Cell[242619, 8553, 421, 10, 57, "Notes",
      CellTags->"SeriesData::slnc"],
    Cell[243065, 8567, 66, 1, 38, "ExampleSection",
      CellTags->"SeriesData::slnc"],
    Cell[243134, 8570, 146, 4, 22, "Text",
      CellTags->"SeriesData::slnc"],
    Cell[243305, 8578, 122, 3, 26, "Input",
      CellTags->"SeriesData::slnc"],
    Cell[243430, 8583, 318, 6, 21, "Message",
      CellTags->"SeriesData::slnc"],
    Cell[243751, 8591, 215, 6, 27, "Output",
      CellTags->"SeriesData::slnc"],
    Cell[243981, 8600, 143, 4, 22, "Text",
      CellTags->"SeriesData::slnc"],
    Cell[244149, 8608, 119, 3, 26, "Input",
      CellTags->"SeriesData::slnc"],
    Cell[244271, 8613, 339, 10, 43, "Output",
      CellTags->"SeriesData::slnc"]},
  "SeriesData::ssdn"->{
    Cell[244671, 8630, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeriesData::ssdn"],
    Cell[244759, 8633, 336, 7, 19, "Message",
      CellTags->"SeriesData::ssdn"],
    Cell[245098, 8642, 159, 4, 22, "Notes",
      CellTags->"SeriesData::ssdn"],
    Cell[245282, 8650, 66, 1, 38, "ExampleSection",
      CellTags->"SeriesData::ssdn"],
    Cell[245351, 8653, 160, 4, 22, "Text",
      CellTags->"SeriesData::ssdn"],
    Cell[245536, 8661, 124, 3, 26, "Input",
      CellTags->"SeriesData::ssdn"],
    Cell[245663, 8666, 218, 5, 19, "Message",
      CellTags->"SeriesData::ssdn"],
    Cell[245884, 8673, 103, 3, 25, "Output",
      CellTags->"SeriesData::ssdn"],
    Cell[246002, 8679, 174, 4, 22, "Text",
      CellTags->"SeriesData::ssdn"],
    Cell[246201, 8687, 132, 3, 26, "Input",
      CellTags->"SeriesData::ssdn"],
    Cell[246336, 8692, 96, 3, 40, "Output",
      CellTags->"SeriesData::ssdn"]},
  "FullSimplify::cfn"->{
    Cell[246493, 8702, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[246624, 8708, 510, 14, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247137, 8724, 353, 10, 37, "Notes",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247515, 8738, 86, 1, 38, "ExampleSection",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247604, 8741, 250, 5, 37, "Text",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247879, 8750, 182, 4, 26, "Input",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248064, 8756, 271, 5, 33, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248338, 8763, 261, 5, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248602, 8770, 261, 5, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248866, 8777, 246, 5, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249115, 8784, 134, 3, 25, "Output",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249264, 8790, 211, 7, 23, "Text",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249500, 8801, 193, 4, 26, "Input",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249696, 8807, 126, 3, 25, "Output",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}]},
  "Simplify::cfn"->{
    Cell[246493, 8702, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[246624, 8708, 510, 14, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247137, 8724, 353, 10, 37, "Notes",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247515, 8738, 86, 1, 38, "ExampleSection",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247604, 8741, 250, 5, 37, "Text",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[247879, 8750, 182, 4, 26, "Input",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248064, 8756, 271, 5, 33, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248338, 8763, 261, 5, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248602, 8770, 261, 5, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[248866, 8777, 246, 5, 19, "Message",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249115, 8784, 134, 3, 25, "Output",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249264, 8790, 211, 7, 23, "Text",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249500, 8801, 193, 4, 26, "Input",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}],
    Cell[249696, 8807, 126, 3, 25, "Output",
      CellTags->{"FullSimplify::cfn", "Simplify::cfn"}]},
  "FullSimplify::time"->{
    Cell[249883, 8817, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[250018, 8823, 598, 14, 47, "Message",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[250619, 8839, 536, 13, 77, "Notes",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251180, 8856, 88, 1, 38, "ExampleSection",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251271, 8859, 300, 6, 36, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251596, 8869, 167, 3, 26, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251766, 8874, 344, 6, 47, "Message",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252113, 8882, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252267, 8888, 189, 5, 23, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252481, 8897, 189, 4, 26, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252673, 8903, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252827, 8909, 164, 5, 23, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253016, 8918, 173, 4, 26, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253192, 8924, 348, 6, 47, "Message",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253543, 8932, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253697, 8938, 230, 7, 23, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253952, 8949, 209, 4, 42, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[254164, 8955, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}]},
  "Simplify::time"->{
    Cell[249883, 8817, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[250018, 8823, 598, 14, 47, "Message",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[250619, 8839, 536, 13, 77, "Notes",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251180, 8856, 88, 1, 38, "ExampleSection",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251271, 8859, 300, 6, 36, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251596, 8869, 167, 3, 26, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[251766, 8874, 344, 6, 47, "Message",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252113, 8882, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252267, 8888, 189, 5, 23, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252481, 8897, 189, 4, 26, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252673, 8903, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[252827, 8909, 164, 5, 23, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253016, 8918, 173, 4, 26, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253192, 8924, 348, 6, 47, "Message",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253543, 8932, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253697, 8938, 230, 7, 23, "Text",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[253952, 8949, 209, 4, 42, "Input",
      CellTags->{"FullSimplify::time", "Simplify::time"}],
    Cell[254164, 8955, 139, 3, 27, "Output",
      CellTags->{"FullSimplify::time", "Simplify::time"}]},
  "Solve::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "Roots::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "Reduce::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "System`Private`OldReduce::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "Eliminate::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "SolveAlways::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "MainSolve::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "AlgebraicRules::circ"->{
    Cell[254364, 8965, 373, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[254740, 8980, 727, 16, 33, "Message",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}],
    Cell[255470, 8998, 354, 9, 24, "Notes",
      CellTags->{
      "Solve::circ", "Roots::circ", "Reduce::circ", 
        "System`Private`OldReduce::circ", "Eliminate::circ", 
        "SolveAlways::circ", "MainSolve::circ", "AlgebraicRules::circ"}]},
  "Solve::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "Eliminate::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "Roots::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "Reduce::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "System`Private`OldReduce::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "SolveAlways::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "GroebnerBasis::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "PolynomialReduce::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "MainSolve::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "AlgebraicRules::dinv"->{
    Cell[255861, 9012, 470, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[256334, 9030, 731, 18, 33, "Message",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257068, 9050, 445, 9, 36, "Notes",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257538, 9063, 278, 5, 38, "ExampleSection",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[257819, 9070, 442, 9, 36, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258286, 9083, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[258616, 9092, 471, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259090, 9103, 334, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[259439, 9113, 437, 10, 37, "Text",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[259901, 9127, 327, 7, 26, "Input",
      CellTags->{
      "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
        "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
        "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
        "AlgebraicRules::dinv"}],
    Cell[260231, 9136, 479, 9, 33, "Message",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}],
    Cell[260713, 9147, 354, 7, 25, "Output",
      CellTags->{
      "AlgebraicRules::dinv", "Eliminate::dinv", "GroebnerBasis::dinv", 
        "MainSolve::dinv", "PolynomialReduce::dinv", "Reduce::dinv", 
        "Roots::dinv", "SolveAlways::dinv", "Solve::dinv", 
        "System`Private`OldReduce::dinv"}]},
  "Solve::smod"->{
    Cell[261128, 9161, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Solve::smod"],
    Cell[261206, 9164, 153, 3, 19, "Message",
      CellTags->"Solve::smod"],
    Cell[261362, 9169, 149, 4, 22, "Notes",
      CellTags->"Solve::smod"],
    Cell[261536, 9177, 61, 1, 38, "ExampleSection",
      CellTags->"Solve::smod"],
    Cell[261600, 9180, 123, 4, 22, "Text",
      CellTags->"Solve::smod"],
    Cell[261748, 9188, 130, 3, 26, "Input",
      CellTags->"Solve::smod"],
    Cell[261881, 9193, 168, 4, 19, "Message",
      CellTags->"Solve::smod"],
    Cell[262052, 9199, 100, 3, 25, "Output",
      CellTags->"Solve::smod"],
    Cell[262167, 9205, 83, 1, 22, "Text",
      CellTags->"Solve::smod"],
    Cell[262275, 9210, 130, 3, 26, "Input",
      CellTags->"Solve::smod"],
    Cell[262408, 9215, 119, 3, 25, "Output",
      CellTags->"Solve::smod"]},
  "Solve::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "Roots::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "Reduce::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "System`Private`OldReduce::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "Eliminate::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "SolveAlways::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "GroebnerBasis::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "PolynomialReduce::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "MainSolve::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "AlgebraicRules::solex"->{
    Cell[262588, 9225, 490, 16, 211, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263081, 9243, 605, 15, 19, "Message",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}],
    Cell[263689, 9260, 478, 9, 36, "Notes",
      CellTags->{
      "Solve::solex", "Roots::solex", "Reduce::solex", 
        "System`Private`OldReduce::solex", "Eliminate::solex", 
        "SolveAlways::solex", "GroebnerBasis::solex", 
        "PolynomialReduce::solex", "MainSolve::solex", 
        "AlgebraicRules::solex"}]},
  "Solve::svars"->{
    Cell[264204, 9274, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Solve::svars"],
    Cell[264284, 9277, 196, 5, 19, "Message",
      CellTags->"Solve::svars"],
    Cell[264483, 9284, 276, 7, 37, "Notes",
      CellTags->"Solve::svars"],
    Cell[264784, 9295, 62, 1, 38, "ExampleSection",
      CellTags->"Solve::svars"],
    Cell[264849, 9298, 158, 4, 22, "Text",
      CellTags->"Solve::svars"],
    Cell[265032, 9306, 125, 3, 26, "Input",
      CellTags->"Solve::svars"],
    Cell[265160, 9311, 195, 5, 19, "Message",
      CellTags->"Solve::svars"],
    Cell[265358, 9318, 121, 3, 27, "Output",
      CellTags->"Solve::svars"],
    Cell[265494, 9324, 118, 4, 22, "Text",
      CellTags->"Solve::svars"],
    Cell[265637, 9332, 133, 3, 26, "Input",
      CellTags->"Solve::svars"],
    Cell[265773, 9337, 187, 4, 25, "Output",
      CellTags->"Solve::svars"]},
  "TimeConstraint::nvc"->{
    Cell[266021, 9348, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TimeConstraint::nvc"],
    Cell[266115, 9351, 215, 4, 19, "Message",
      CellTags->"TimeConstraint::nvc"],
    Cell[266333, 9357, 285, 9, 37, "Notes",
      CellTags->"TimeConstraint::nvc"],
    Cell[266643, 9370, 69, 1, 38, "ExampleSection",
      CellTags->"TimeConstraint::nvc"],
    Cell[266715, 9373, 219, 7, 23, "Text",
      CellTags->"TimeConstraint::nvc"],
    Cell[266959, 9384, 147, 3, 26, "Input",
      CellTags->"TimeConstraint::nvc"],
    Cell[267109, 9389, 224, 5, 33, "Message",
      CellTags->"TimeConstraint::nvc"],
    Cell[267336, 9396, 162, 4, 27, "Output",
      CellTags->"TimeConstraint::nvc"],
    Cell[267513, 9403, 190, 7, 23, "Text",
      CellTags->"TimeConstraint::nvc"],
    Cell[267728, 9414, 144, 3, 26, "Input",
      CellTags->"TimeConstraint::nvc"],
    Cell[267875, 9419, 100, 3, 25, "Output",
      CellTags->"TimeConstraint::nvc"]},
  "General::bmod"->{
    Cell[268036, 9429, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bmod"],
    Cell[268118, 9432, 434, 11, 19, "Message",
      CellTags->"General::bmod"],
    Cell[268555, 9445, 250, 7, 23, "Notes",
      CellTags->"General::bmod"],
    Cell[268830, 9456, 63, 1, 38, "ExampleSection",
      CellTags->"General::bmod"],
    Cell[268896, 9459, 180, 5, 23, "Text",
      CellTags->"General::bmod"],
    Cell[269101, 9468, 131, 3, 26, "Input",
      CellTags->"General::bmod"],
    Cell[269235, 9473, 226, 5, 21, "Message",
      CellTags->"General::bmod"],
    Cell[269464, 9480, 144, 3, 27, "Output",
      CellTags->"General::bmod"],
    Cell[269623, 9486, 175, 7, 23, "Text",
      CellTags->"General::bmod"],
    Cell[269823, 9497, 131, 3, 26, "Input",
      CellTags->"General::bmod"],
    Cell[269957, 9502, 92, 3, 25, "Output",
      CellTags->"General::bmod"]},
  "General::ivar"->{
    Cell[270110, 9512, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ivar"],
    Cell[270192, 9515, 360, 11, 19, "Message",
      CellTags->"General::ivar"],
    Cell[270555, 9528, 279, 6, 42, "Notes",
      CellTags->"General::ivar"],
    Cell[270859, 9538, 63, 1, 38, "ExampleSection",
      CellTags->"General::ivar"],
    Cell[270925, 9541, 143, 5, 23, "Text",
      CellTags->"General::ivar"],
    Cell[271093, 9550, 108, 3, 26, "Input",
      CellTags->"General::ivar"],
    Cell[271204, 9555, 170, 4, 19, "Message",
      CellTags->"General::ivar"],
    Cell[271377, 9561, 107, 3, 25, "Output",
      CellTags->"General::ivar"],
    Cell[271499, 9567, 88, 1, 22, "Text",
      CellTags->"General::ivar"],
    Cell[271612, 9572, 119, 3, 26, "Input",
      CellTags->"General::ivar"],
    Cell[271734, 9577, 304, 6, 47, "Message",
      CellTags->"General::ivar"],
    Cell[272041, 9585, 173, 4, 19, "Message",
      CellTags->"General::ivar"],
    Cell[272217, 9591, 120, 3, 25, "Output",
      CellTags->"General::ivar"],
    Cell[272352, 9597, 132, 5, 23, "Text",
      CellTags->"General::ivar"],
    Cell[272509, 9606, 119, 3, 26, "Input",
      CellTags->"General::ivar"],
    Cell[272631, 9611, 304, 6, 47, "Message",
      CellTags->"General::ivar"],
    Cell[272938, 9619, 105, 3, 25, "Output",
      CellTags->"General::ivar"]},
  "General::mext"->{
    Cell[273104, 9629, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::mext"],
    Cell[273186, 9632, 301, 8, 19, "Message",
      CellTags->"General::mext"],
    Cell[273490, 9642, 537, 20, 58, "Notes",
      CellTags->"General::mext"],
    Cell[274052, 9666, 63, 1, 38, "ExampleSection",
      CellTags->"General::mext"],
    Cell[274118, 9669, 194, 7, 23, "Text",
      CellTags->"General::mext"],
    Cell[274337, 9680, 137, 3, 26, "Input",
      CellTags->"General::mext"],
    Cell[274477, 9685, 214, 5, 33, "Message",
      CellTags->"General::mext"],
    Cell[274694, 9692, 157, 4, 30, "Output",
      CellTags->"General::mext"],
    Cell[274866, 9699, 81, 1, 22, "Text",
      CellTags->"General::mext"],
    Cell[274972, 9704, 115, 3, 26, "Input",
      CellTags->"General::mext"],
    Cell[275090, 9709, 91, 3, 27, "Output",
      CellTags->"General::mext"],
    Cell[275218, 9717, 123, 3, 26, "Input",
      CellTags->"General::mext"],
    Cell[275344, 9722, 120, 3, 30, "Output",
      CellTags->"General::mext"]},
  "General::nord"->{
    Cell[275525, 9732, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nord"],
    Cell[275607, 9735, 346, 10, 19, "Message",
      CellTags->"General::nord"],
    Cell[275956, 9747, 400, 10, 57, "Notes",
      CellTags->"General::nord"],
    Cell[276381, 9761, 63, 1, 38, "ExampleSection",
      CellTags->"General::nord"],
    Cell[276447, 9764, 168, 5, 23, "Text",
      CellTags->"General::nord"],
    Cell[276640, 9773, 119, 3, 26, "Input",
      CellTags->"General::nord"],
    Cell[276762, 9778, 190, 5, 19, "Message",
      CellTags->"General::nord"],
    Cell[276955, 9785, 190, 5, 19, "Message",
      CellTags->"General::nord"],
    Cell[277148, 9792, 190, 5, 19, "Message",
      CellTags->"General::nord"],
    Cell[277341, 9799, 219, 5, 19, "Message",
      CellTags->"General::nord"],
    Cell[277563, 9806, 173, 4, 25, "Output",
      CellTags->"General::nord"],
    Cell[277751, 9813, 372, 10, 39, "Text",
      CellTags->"General::nord"],
    Cell[278148, 9827, 120, 3, 26, "Input",
      CellTags->"General::nord"],
    Cell[278271, 9832, 170, 4, 25, "Output",
      CellTags->"General::nord"],
    Cell[278478, 9841, 124, 3, 26, "Input",
      CellTags->"General::nord"],
    Cell[278605, 9846, 92, 3, 25, "Output",
      CellTags->"General::nord"]},
  "Element::bset"->{
    Cell[278758, 9856, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Element::bset"],
    Cell[278840, 9859, 261, 5, 33, "Message",
      CellTags->"Element::bset"],
    Cell[279104, 9866, 347, 9, 43, "Notes",
      CellTags->"Element::bset"],
    Cell[279476, 9879, 63, 1, 38, "ExampleSection",
      CellTags->"Element::bset"],
    Cell[279542, 9882, 220, 7, 23, "Text",
      CellTags->"Element::bset"],
    Cell[279787, 9893, 104, 3, 26, "Input",
      CellTags->"Element::bset"],
    Cell[279894, 9898, 271, 6, 33, "Message",
      CellTags->"Element::bset"],
    Cell[280168, 9906, 106, 3, 25, "Output",
      CellTags->"Element::bset"],
    Cell[280289, 9912, 127, 5, 23, "Text",
      CellTags->"Element::bset"],
    Cell[280441, 9921, 104, 3, 26, "Input",
      CellTags->"Element::bset"],
    Cell[280548, 9926, 91, 3, 25, "Output",
      CellTags->"Element::bset"]},
  "NotElement::bset"->{
    Cell[280700, 9936, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NotElement::bset"],
    Cell[280788, 9939, 290, 5, 33, "Message",
      CellTags->"NotElement::bset"],
    Cell[281081, 9946, 127, 4, 22, "Notes",
      CellTags->"NotElement::bset"]},
  "General::bass"->{
    Cell[281245, 9955, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bass"],
    Cell[281327, 9958, 376, 11, 19, "Message",
      CellTags->"General::bass"],
    Cell[281706, 9971, 232, 5, 36, "Notes",
      CellTags->"General::bass"],
    Cell[281963, 9980, 63, 1, 38, "ExampleSection",
      CellTags->"General::bass"],
    Cell[282029, 9983, 130, 4, 22, "Text",
      CellTags->"General::bass"],
    Cell[282184, 9991, 112, 3, 26, "Input",
      CellTags->"General::bass"],
    Cell[282299, 9996, 175, 4, 19, "Message",
      CellTags->"General::bass"],
    Cell[282477, 10002, 100, 3, 25, "Output",
      CellTags->"General::bass"],
    Cell[282592, 10008, 131, 5, 23, "Text",
      CellTags->"General::bass"],
    Cell[282748, 10017, 129, 3, 26, "Input",
      CellTags->"General::bass"],
    Cell[282880, 10022, 88, 3, 25, "Output",
      CellTags->"General::bass"]},
  "General::altel"->{
    Cell[283029, 10032, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::altel"],
    Cell[283113, 10035, 388, 10, 19, "Message",
      CellTags->"General::altel"],
    Cell[283504, 10047, 513, 13, 77, "Notes",
      CellTags->"General::altel"],
    Cell[284042, 10064, 64, 1, 38, "ExampleSection",
      CellTags->"General::altel"],
    Cell[284109, 10067, 247, 8, 38, "Text",
      CellTags->"General::altel"],
    Cell[284381, 10079, 160, 4, 26, "Input",
      CellTags->"General::altel"],
    Cell[284544, 10085, 231, 5, 19, "Message",
      CellTags->"General::altel"],
    Cell[284778, 10092, 120, 3, 25, "Output",
      CellTags->"General::altel"],
    Cell[284913, 10098, 167, 5, 23, "Text",
      CellTags->"General::altel"],
    Cell[285105, 10107, 175, 5, 26, "Input",
      CellTags->"General::altel"],
    Cell[285283, 10114, 103, 3, 25, "Output",
      CellTags->"General::altel"]},
  "General::fas"->{
    Cell[285447, 10124, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::fas"],
    Cell[285527, 10127, 259, 7, 19, "Message",
      CellTags->"General::fas"],
    Cell[285789, 10136, 208, 5, 23, "Notes",
      CellTags->"General::fas"],
    Cell[286022, 10145, 62, 1, 38, "ExampleSection",
      CellTags->"General::fas"],
    Cell[286087, 10148, 224, 8, 23, "Text",
      CellTags->"General::fas"],
    Cell[286336, 10160, 162, 4, 26, "Input",
      CellTags->"General::fas"],
    Cell[286501, 10166, 185, 4, 19, "Message",
      CellTags->"General::fas"],
    Cell[286689, 10172, 87, 3, 25, "Output",
      CellTags->"General::fas"],
    Cell[286791, 10178, 130, 5, 23, "Text",
      CellTags->"General::fas"],
    Cell[286946, 10187, 153, 4, 26, "Input",
      CellTags->"General::fas"],
    Cell[287102, 10193, 101, 3, 25, "Output",
      CellTags->"General::fas"]},
  "General::cas"->{
    Cell[287264, 10203, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::cas"],
    Cell[287344, 10206, 262, 7, 19, "Message",
      CellTags->"General::cas"],
    Cell[287609, 10215, 131, 4, 22, "Notes",
      CellTags->"General::cas"],
    Cell[287765, 10223, 62, 1, 38, "ExampleSection",
      CellTags->"General::cas"],
    Cell[287830, 10226, 233, 6, 37, "Text",
      CellTags->"General::cas"],
    Cell[288088, 10236, 127, 3, 26, "Input",
      CellTags->"General::cas"],
    Cell[288218, 10241, 228, 5, 19, "Message",
      CellTags->"General::cas"],
    Cell[288449, 10248, 87, 3, 25, "Output",
      CellTags->"General::cas"]},
  "Developer`InequalityInstance::nrpi"->{
    Cell[288597, 10258, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[288936, 10268, 734, 17, 33, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[289673, 10287, 325, 7, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290023, 10298, 197, 3, 38, "ExampleSection",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290223, 10303, 268, 6, 22, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290516, 10313, 271, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290790, 10320, 450, 8, 47, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291243, 10330, 268, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291526, 10338, 282, 7, 23, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291833, 10349, 276, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[292112, 10356, 247, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", 
        "Experimental`ImpliesRealQ::nrpi"}]},
  "Experimental`ExistsRealQ::nrpi"->{
    Cell[288597, 10258, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[288936, 10268, 734, 17, 33, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[289673, 10287, 325, 7, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290023, 10298, 197, 3, 38, "ExampleSection",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290223, 10303, 268, 6, 22, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290516, 10313, 271, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290790, 10320, 450, 8, 47, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291243, 10330, 268, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291526, 10338, 282, 7, 23, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291833, 10349, 276, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[292112, 10356, 247, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", 
        "Experimental`ImpliesRealQ::nrpi"}]},
  "Experimental`ForAllRealQ::nrpi"->{
    Cell[288597, 10258, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[288936, 10268, 734, 17, 33, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[289673, 10287, 325, 7, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290023, 10298, 197, 3, 38, "ExampleSection",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290223, 10303, 268, 6, 22, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290516, 10313, 271, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290790, 10320, 450, 8, 47, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291243, 10330, 268, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291526, 10338, 282, 7, 23, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291833, 10349, 276, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[292112, 10356, 247, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", 
        "Experimental`ImpliesRealQ::nrpi"}]},
  "Experimental`ImpliesRealQ::nrpi"->{
    Cell[288597, 10258, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[288936, 10268, 734, 17, 33, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[289673, 10287, 325, 7, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290023, 10298, 197, 3, 38, "ExampleSection",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290223, 10303, 268, 6, 22, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290516, 10313, 271, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[290790, 10320, 450, 8, 47, "Message",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291243, 10330, 268, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291526, 10338, 282, 7, 23, "Text",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[291833, 10349, 276, 5, 26, "Input",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", "Experimental`ImpliesRealQ::nrpi"}],
    
    Cell[292112, 10356, 247, 5, 25, "Output",
      CellTags->{
      "Developer`InequalityInstance::nrpi", "Experimental`ExistsRealQ::nrpi", 
        "Experimental`ForAllRealQ::nrpi", 
        "Experimental`ImpliesRealQ::nrpi"}]},
  "CylindricalDecomposition::nrtpi"->{
    Cell[292420, 10368, 260, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CylindricalDecomposition::nrtpi", 
        "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}],
    Cell[292683, 10377, 697, 17, 33, "Message",
      CellTags->{
      "CylindricalDecomposition::nrtpi", 
        "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}],
    Cell[293383, 10396, 239, 6, 22, "Notes",
      CellTags->{
      "CylindricalDecomposition::nrtpi", 
        "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}]},
  "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"->{
    Cell[292420, 10368, 260, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CylindricalDecomposition::nrtpi", 
        "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}],
    Cell[292683, 10377, 697, 17, 33, "Message",
      CellTags->{
      "CylindricalDecomposition::nrtpi", 
        "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}],
    Cell[293383, 10396, 239, 6, 22, "Notes",
      CellTags->{
      "CylindricalDecomposition::nrtpi", 
        "Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi"}]},
  "Developer`InequalityInstance::weak"->{
    Cell[293659, 10407, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[293998, 10417, 716, 15, 75, "Message",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[294717, 10434, 263, 6, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", 
        "Experimental`ImpliesRealQ::weak"}]},
  "Experimental`ExistsRealQ::weak"->{
    Cell[293659, 10407, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[293998, 10417, 716, 15, 75, "Message",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[294717, 10434, 263, 6, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", 
        "Experimental`ImpliesRealQ::weak"}]},
  "Experimental`ForAllRealQ::weak"->{
    Cell[293659, 10407, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[293998, 10417, 716, 15, 75, "Message",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[294717, 10434, 263, 6, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", 
        "Experimental`ImpliesRealQ::weak"}]},
  "Experimental`ImpliesRealQ::weak"->{
    Cell[293659, 10407, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[293998, 10417, 716, 15, 75, "Message",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", "Experimental`ImpliesRealQ::weak"}],
    
    Cell[294717, 10434, 263, 6, 22, "Notes",
      CellTags->{
      "Developer`InequalityInstance::weak", "Experimental`ExistsRealQ::weak", 
        "Experimental`ForAllRealQ::weak", 
        "Experimental`ImpliesRealQ::weak"}]},
  "Roots::lexp"->{
    Cell[295017, 10445, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Roots::lexp"],
    Cell[295095, 10448, 167, 4, 19, "Message",
      CellTags->"Roots::lexp"],
    Cell[295265, 10454, 124, 4, 22, "Notes",
      CellTags->"Roots::lexp"]},
  "Subresultants::slpr"->{
    Cell[295426, 10463, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Subresultants::slpr"],
    Cell[295520, 10466, 176, 4, 19, "Message",
      CellTags->"Subresultants::slpr"],
    Cell[295699, 10472, 130, 4, 22, "Notes",
      CellTags->"Subresultants::slpr"]},
  "Experimental`CylindricalAlgebraicDecomposition::deprec"->{
    Cell[295866, 10481, 163, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CylindricalAlgebraicDecomposition::deprec"],
    Cell[296032, 10485, 373, 6, 47, "Message",
      CellTags->"Experimental`CylindricalAlgebraicDecomposition::deprec"],
    Cell[296408, 10493, 165, 4, 22, "Notes",
      CellTags->"Experimental`CylindricalAlgebraicDecomposition::deprec"]},
  "Experimental`Resolve::deprec"->{
    Cell[296610, 10502, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`Resolve::deprec"],
    Cell[296722, 10505, 274, 4, 33, "Message",
      CellTags->"Experimental`Resolve::deprec"],
    Cell[296999, 10511, 139, 4, 22, "Notes",
      CellTags->"Experimental`Resolve::deprec"]},
  "GroebnerBasis::gmeth1"->{
    Cell[297175, 10520, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}],
    Cell[297346, 10526, 282, 7, 19, "Message",
      CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}],
    Cell[297631, 10535, 167, 4, 22, "Notes",
      CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}]},
  "Internal`GroebnerWalk::gmeth1"->{
    Cell[297175, 10520, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}],
    Cell[297346, 10526, 282, 7, 19, "Message",
      CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}],
    Cell[297631, 10535, 167, 4, 22, "Notes",
      CellTags->{"GroebnerBasis::gmeth1", "Internal`GroebnerWalk::gmeth1"}]},
  "GroebnerBasis::gmeth2"->{
    Cell[297835, 10544, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}],
    Cell[298006, 10550, 335, 8, 19, "Message",
      CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}],
    Cell[298344, 10560, 167, 4, 22, "Notes",
      CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}]},
  "Internal`GroebnerWalk::gmeth2"->{
    Cell[297835, 10544, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}],
    Cell[298006, 10550, 335, 8, 19, "Message",
      CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}],
    Cell[298344, 10560, 167, 4, 22, "Notes",
      CellTags->{"GroebnerBasis::gmeth2", "Internal`GroebnerWalk::gmeth2"}]},
  "Internal`GroebnerWalk::gstrat"->{
    Cell[298548, 10569, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}],
    Cell[298719, 10575, 343, 8, 19, "Message",
      CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}],
    Cell[299065, 10585, 167, 4, 22, "Notes",
      CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}]},
  "GroebnerBasis::gstrat"->{
    Cell[298548, 10569, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}],
    Cell[298719, 10575, 343, 8, 19, "Message",
      CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}],
    Cell[299065, 10585, 167, 4, 22, "Notes",
      CellTags->{"Internal`GroebnerWalk::gstrat", "GroebnerBasis::gstrat"}]},
  "Internal`GroebnerWalk::parmvar"->{
    Cell[299269, 10594, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Internal`GroebnerWalk::parmvar"],
    Cell[299385, 10597, 205, 3, 19, "Message",
      CellTags->"Internal`GroebnerWalk::parmvar"],
    Cell[299593, 10602, 141, 4, 22, "Notes",
      CellTags->"Internal`GroebnerWalk::parmvar"]},
  "InterpolatingPolynomial::moddata"->{
    Cell[299771, 10611, 117, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingPolynomial::moddata"],
    Cell[299891, 10614, 265, 5, 33, "Message",
      CellTags->"InterpolatingPolynomial::moddata"],
    Cell[300159, 10621, 143, 4, 22, "Notes",
      CellTags->"InterpolatingPolynomial::moddata"]},
  "DSolve::dvnoarg"->{
    Cell[300339, 10630, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],
    Cell[300507, 10637, 295, 7, 19, "Message",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],
    Cell[300805, 10646, 224, 4, 22, "Notes",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}]},
  "NDSolve::dvnoarg"->{
    Cell[300339, 10630, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],
    Cell[300507, 10637, 295, 7, 19, "Message",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],
    Cell[300805, 10646, 224, 4, 22, "Notes",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}]},
  "RSolve::dvnoarg"->{
    Cell[300339, 10630, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],
    Cell[300507, 10637, 295, 7, 19, "Message",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}],
    Cell[300805, 10646, 224, 4, 22, "Notes",
      CellTags->{"DSolve::dvnoarg", "NDSolve::dvnoarg", "RSolve::dvnoarg"}]},
  "DSolve::ivhead"->{
    Cell[301066, 10655, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],
    Cell[301228, 10662, 400, 9, 33, "Message",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],
    Cell[301631, 10673, 164, 4, 22, "Notes",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}]},
  "NDSolve::ivhead"->{
    Cell[301066, 10655, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],
    Cell[301228, 10662, 400, 9, 33, "Message",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],
    Cell[301631, 10673, 164, 4, 22, "Notes",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}]},
  "RSolve::ivhead"->{
    Cell[301066, 10655, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],
    Cell[301228, 10662, 400, 9, 33, "Message",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}],
    Cell[301631, 10673, 164, 4, 22, "Notes",
      CellTags->{"DSolve::ivhead", "NDSolve::ivhead", "RSolve::ivhead"}]},
  "DSolve::dvleaf"->{
    Cell[301832, 10682, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[301994, 10689, 313, 8, 19, "Message",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302310, 10699, 178, 4, 22, "Notes",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302513, 10707, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302619, 10710, 186, 4, 22, "Text",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302830, 10718, 197, 4, 26, "Input",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303030, 10724, 262, 5, 19, "Message",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303295, 10731, 525, 13, 25, "Output",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303835, 10747, 163, 4, 22, "Text",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[304023, 10755, 183, 3, 26, "Input",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[304209, 10760, 317, 8, 25, "Output",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}]},
  "NDSolve::dvleaf"->{
    Cell[301832, 10682, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[301994, 10689, 313, 8, 19, "Message",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302310, 10699, 178, 4, 22, "Notes",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302513, 10707, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302619, 10710, 186, 4, 22, "Text",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302830, 10718, 197, 4, 26, "Input",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303030, 10724, 262, 5, 19, "Message",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303295, 10731, 525, 13, 25, "Output",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303835, 10747, 163, 4, 22, "Text",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[304023, 10755, 183, 3, 26, "Input",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[304209, 10760, 317, 8, 25, "Output",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}]},
  "RSolve::dvleaf"->{
    Cell[301832, 10682, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[301994, 10689, 313, 8, 19, "Message",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302310, 10699, 178, 4, 22, "Notes",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302513, 10707, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302619, 10710, 186, 4, 22, "Text",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[302830, 10718, 197, 4, 26, "Input",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303030, 10724, 262, 5, 19, "Message",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303295, 10731, 525, 13, 25, "Output",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[303835, 10747, 163, 4, 22, "Text",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[304023, 10755, 183, 3, 26, "Input",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}],
    Cell[304209, 10760, 317, 8, 25, "Output",
      CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"}]},
  "DSolve::der1"->{
    Cell[304587, 10775, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::der1", "NDSolve::der1"}],
    Cell[304708, 10781, 302, 8, 19, "Message",
      CellTags->{"DSolve::der1", "NDSolve::der1"}],
    Cell[305013, 10791, 142, 4, 22, "Notes",
      CellTags->{"DSolve::der1", "NDSolve::der1"}]},
  "NDSolve::der1"->{
    Cell[304587, 10775, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::der1", "NDSolve::der1"}],
    Cell[304708, 10781, 302, 8, 19, "Message",
      CellTags->{"DSolve::der1", "NDSolve::der1"}],
    Cell[305013, 10791, 142, 4, 22, "Notes",
      CellTags->{"DSolve::der1", "NDSolve::der1"}]},
  "DSolve::derarg"->{
    Cell[305192, 10800, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::derarg", "NDSolve::derarg"}],
    Cell[305321, 10806, 304, 8, 19, "Message",
      CellTags->{"DSolve::derarg", "NDSolve::derarg"}],
    Cell[305628, 10816, 146, 4, 22, "Notes",
      CellTags->{"DSolve::derarg", "NDSolve::derarg"}]},
  "NDSolve::derarg"->{
    Cell[305192, 10800, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DSolve::derarg", "NDSolve::derarg"}],
    Cell[305321, 10806, 304, 8, 19, "Message",
      CellTags->{"DSolve::derarg", "NDSolve::derarg"}],
    Cell[305628, 10816, 146, 4, 22, "Notes",
      CellTags->{"DSolve::derarg", "NDSolve::derarg"}]},
  "DSolve::nestdv"->{
    Cell[305811, 10825, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],
    Cell[305973, 10832, 298, 7, 19, "Message",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],
    Cell[306274, 10841, 164, 4, 22, "Notes",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}]},
  "NDSolve::nestdv"->{
    Cell[305811, 10825, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],
    Cell[305973, 10832, 298, 7, 19, "Message",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],
    Cell[306274, 10841, 164, 4, 22, "Notes",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}]},
  "RSolve::nestdv"->{
    Cell[305811, 10825, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],
    Cell[305973, 10832, 298, 7, 19, "Message",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}],
    Cell[306274, 10841, 164, 4, 22, "Notes",
      CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"}]},
  "DSolve::dvlen"->{
    Cell[306475, 10850, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],
    Cell[306631, 10857, 345, 8, 33, "Message",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],
    Cell[306979, 10867, 161, 4, 22, "Notes",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}]},
  "NDSolve::dvlen"->{
    Cell[306475, 10850, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],
    Cell[306631, 10857, 345, 8, 33, "Message",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],
    Cell[306979, 10867, 161, 4, 22, "Notes",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}]},
  "RSolve::dvlen"->{
    Cell[306475, 10850, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],
    Cell[306631, 10857, 345, 8, 33, "Message",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}],
    Cell[306979, 10867, 161, 4, 22, "Notes",
      CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"}]},
  "Algebra`PolynomialGCDModList::nogcd"->{
    Cell[307177, 10876, 123, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialGCDModList::nogcd"],
    Cell[307303, 10879, 213, 3, 19, "Message",
      CellTags->"Algebra`PolynomialGCDModList::nogcd"],
    Cell[307519, 10884, 146, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialGCDModList::nogcd"]},
  "PolynomialMod::coef"->{
    Cell[307702, 10893, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PolynomialMod::coef"],
    Cell[307796, 10896, 213, 4, 19, "Message",
      CellTags->"PolynomialMod::coef"],
    Cell[308012, 10902, 130, 4, 22, "Notes",
      CellTags->"PolynomialMod::coef"]},
  "Algebra`PolynomialMakeMonicModList::nprimemod"->{
    Cell[308179, 10911, 145, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialMakeMonicModList::nprimemod"],
    Cell[308327, 10915, 207, 3, 19, "Message",
      CellTags->"Algebra`PolynomialMakeMonicModList::nprimemod"],
    Cell[308537, 10920, 156, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialMakeMonicModList::nprimemod"]},
  "Algebra`PolynomialModList::badmod"->{
    Cell[308730, 10929, 119, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialModList::badmod"],
    Cell[308852, 10932, 198, 3, 19, "Message",
      CellTags->"Algebra`PolynomialModList::badmod"],
    Cell[309053, 10937, 144, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialModList::badmod"]},
  "Algebra`PolynomialModList::divby0"->{
    Cell[309234, 10946, 119, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialModList::divby0"],
    Cell[309356, 10949, 206, 3, 19, "Message",
      CellTags->"Algebra`PolynomialModList::divby0"],
    Cell[309565, 10954, 144, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialModList::divby0"]},
  "Algebra`PolynomialModList::ninv"->{
    Cell[309746, 10963, 115, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialModList::ninv"],
    Cell[309864, 10966, 183, 3, 19, "Message",
      CellTags->"Algebra`PolynomialModList::ninv"],
    Cell[310050, 10971, 142, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialModList::ninv"]},
  "Algebra`PolynomialModList::nsfmod"->{
    Cell[310229, 10980, 119, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialModList::nsfmod"],
    Cell[310351, 10983, 209, 3, 19, "Message",
      CellTags->"Algebra`PolynomialModList::nsfmod"],
    Cell[310563, 10988, 144, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialModList::nsfmod"]},
  "Algebra`PolynomialModList::unipoly"->{
    Cell[310744, 10997, 121, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialModList::unipoly"],
    Cell[310868, 11000, 205, 3, 19, "Message",
      CellTags->"Algebra`PolynomialModList::unipoly"],
    Cell[311076, 11005, 145, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialModList::unipoly"]},
  "Algebra`PolynomialPthRootModList::noroot"->{
    Cell[311258, 11014, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialPthRootModList::noroot"],
    Cell[311394, 11017, 225, 3, 19, "Message",
      CellTags->"Algebra`PolynomialPthRootModList::noroot"],
    Cell[311622, 11022, 151, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialPthRootModList::noroot"]},
  "Algebra`PolynomialQuotientModList::divby0"->{
    Cell[311810, 11031, 135, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`PolynomialQuotientModList::divby0"],
    Cell[311948, 11034, 222, 3, 19, "Message",
      CellTags->"Algebra`PolynomialQuotientModList::divby0"],
    Cell[312173, 11039, 152, 4, 22, "Notes",
      CellTags->"Algebra`PolynomialQuotientModList::divby0"]},
  "NumberTheory`AlgebraicNumberFields`Algebraic::cfls"->{
    Cell[312362, 11048, 155, 2, 31, "ObjectNameWarningMessages",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[312520, 11052, 217, 3, 19, "Message",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[312740, 11057, 230, 5, 23, "Notes",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[312995, 11066, 100, 1, 38, "ExampleSection",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[313098, 11069, 230, 5, 23, "Text",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[313353, 11078, 197, 4, 26, "Input",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[313553, 11084, 250, 4, 19, "Message",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[313806, 11090, 194, 4, 27, "Output",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[314015, 11097, 162, 5, 23, "Text",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[314202, 11106, 202, 4, 26, "Input",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"],
    Cell[314407, 11112, 204, 4, 27, "Output",
      CellTags->"NumberTheory`AlgebraicNumberFields`Algebraic::cfls"]},
  "NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu"->{
    Cell[314672, 11123, 185, 4, 51, "ObjectNameWarningMessages",
      CellTags->
      "NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu"],
    Cell[314860, 11129, 264, 4, 33, "Message",
      CellTags->
      "NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu"],
    Cell[315127, 11135, 172, 4, 22, "Notes",
      CellTags->
      "NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu"]},
  "NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel"->{
    Cell[315336, 11144, 187, 4, 51, "ObjectNameWarningMessages",
      CellTags->
      "NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel"],
    Cell[315526, 11150, 274, 5, 33, "Message",
      CellTags->
      "NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel"],
    Cell[315803, 11157, 173, 4, 22, "Notes",
      CellTags->
      "NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel"]},
  "Reduce::bddom"->{
    Cell[316013, 11166, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Reduce::bddom"],
    Cell[316095, 11169, 257, 4, 33, "Message",
      CellTags->"Reduce::bddom"],
    Cell[316355, 11175, 124, 4, 22, "Notes",
      CellTags->"Reduce::bddom"]},
  "Maximize::vlist"->{
    Cell[316516, 11184, 299, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[316818, 11195, 365, 9, 19, "Message",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[317186, 11206, 241, 6, 22, "Notes",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}]},
  "Minimize::vlist"->{
    Cell[316516, 11184, 299, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[316818, 11195, 365, 9, 19, "Message",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[317186, 11206, 241, 6, 22, "Notes",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}]},
  "Experimental`Infimum::vlist"->{
    Cell[316516, 11184, 299, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[316818, 11195, 365, 9, 19, "Message",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[317186, 11206, 241, 6, 22, "Notes",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}]},
  "Experimental`Supremum::vlist"->{
    Cell[316516, 11184, 299, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[316818, 11195, 365, 9, 19, "Message",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[317186, 11206, 241, 6, 22, "Notes",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}]},
  "FindInstance::vlist"->{
    Cell[316516, 11184, 299, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[316818, 11195, 365, 9, 19, "Message",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}],
    Cell[317186, 11206, 241, 6, 22, "Notes",
      CellTags->{
      "Maximize::vlist", "Minimize::vlist", "Experimental`Infimum::vlist", 
        "Experimental`Supremum::vlist", "FindInstance::vlist"}]},
  "Reduce::mdom"->{
    Cell[317464, 11217, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Reduce::mdom", "FindInstance::mdom"}],
    Cell[317595, 11223, 358, 8, 33, "Message",
      CellTags->{"Reduce::mdom", "FindInstance::mdom"}],
    Cell[317956, 11233, 147, 4, 22, "Notes",
      CellTags->{"Reduce::mdom", "FindInstance::mdom"}]},
  "FindInstance::mdom"->{
    Cell[317464, 11217, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Reduce::mdom", "FindInstance::mdom"}],
    Cell[317595, 11223, 358, 8, 33, "Message",
      CellTags->{"Reduce::mdom", "FindInstance::mdom"}],
    Cell[317956, 11233, 147, 4, 22, "Notes",
      CellTags->{"Reduce::mdom", "FindInstance::mdom"}]},
  "Resolve::bddom"->{
    Cell[318140, 11242, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Resolve::bddom", "FindInstance::bddom"}],
    Cell[318277, 11248, 389, 9, 33, "Message",
      CellTags->{"Resolve::bddom", "FindInstance::bddom"}],
    Cell[318669, 11259, 150, 4, 22, "Notes",
      CellTags->{"Resolve::bddom", "FindInstance::bddom"}]},
  "FindInstance::bddom"->{
    Cell[318140, 11242, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Resolve::bddom", "FindInstance::bddom"}],
    Cell[318277, 11248, 389, 9, 33, "Message",
      CellTags->{"Resolve::bddom", "FindInstance::bddom"}],
    Cell[318669, 11259, 150, 4, 22, "Notes",
      CellTags->{"Resolve::bddom", "FindInstance::bddom"}]},
  "Internal`FundamentalDiscriminantQ::nargs"->{
    Cell[318856, 11268, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Internal`FundamentalDiscriminantQ::nargs"],
    Cell[318992, 11271, 249, 4, 33, "Message",
      CellTags->"Internal`FundamentalDiscriminantQ::nargs"],
    Cell[319244, 11277, 151, 4, 22, "Notes",
      CellTags->"Internal`FundamentalDiscriminantQ::nargs"]},
  "Internal`QuadraticFundamentalUnit::nargs"->{
    Cell[319432, 11286, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Internal`QuadraticFundamentalUnit::nargs"],
    Cell[319568, 11289, 249, 4, 33, "Message",
      CellTags->"Internal`QuadraticFundamentalUnit::nargs"],
    Cell[319820, 11295, 151, 4, 22, "Notes",
      CellTags->"Internal`QuadraticFundamentalUnit::nargs"]},
  "Internal`QuadraticFundamentalUnit::pint"->{
    Cell[320008, 11304, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Internal`QuadraticFundamentalUnit::pint"],
    Cell[320142, 11307, 260, 5, 33, "Message",
      CellTags->"Internal`QuadraticFundamentalUnit::pint"],
    Cell[320405, 11314, 150, 4, 22, "Notes",
      CellTags->"Internal`QuadraticFundamentalUnit::pint"]},
  "FindInstance::naqs"->{
    Cell[320592, 11323, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::naqs", "Reduce::naqs"}],
    Cell[320723, 11329, 295, 8, 19, "Message",
      CellTags->{"FindInstance::naqs", "Reduce::naqs"}],
    Cell[321021, 11339, 147, 4, 22, "Notes",
      CellTags->{"FindInstance::naqs", "Reduce::naqs"}]},
  "Reduce::naqs"->{
    Cell[320592, 11323, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::naqs", "Reduce::naqs"}],
    Cell[320723, 11329, 295, 8, 19, "Message",
      CellTags->{"FindInstance::naqs", "Reduce::naqs"}],
    Cell[321021, 11339, 147, 4, 22, "Notes",
      CellTags->{"FindInstance::naqs", "Reduce::naqs"}]},
  "Reduce::ratnz"->{
    Cell[321205, 11348, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Reduce::ratnz"],
    Cell[321287, 11351, 309, 5, 33, "Message",
      CellTags->"Reduce::ratnz"],
    Cell[321599, 11358, 124, 4, 22, "Notes",
      CellTags->"Reduce::ratnz"]},
  "Reduce::inex"->{
    Cell[321760, 11367, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Reduce::inex"],
    Cell[321840, 11370, 456, 7, 61, "Message",
      CellTags->"Reduce::inex"],
    Cell[322299, 11379, 123, 4, 22, "Notes",
      CellTags->"Reduce::inex"]},
  "Reduce::cpow"->{
    Cell[322459, 11388, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],
    Cell[322621, 11395, 557, 11, 47, "Message",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],
    Cell[323181, 11408, 164, 4, 22, "Notes",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}]},
  "Resolve::cpow"->{
    Cell[322459, 11388, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],
    Cell[322621, 11395, 557, 11, 47, "Message",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],
    Cell[323181, 11408, 164, 4, 22, "Notes",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}]},
  "FindInstance::cpow"->{
    Cell[322459, 11388, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],
    Cell[322621, 11395, 557, 11, 47, "Message",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}],
    Cell[323181, 11408, 164, 4, 22, "Notes",
      CellTags->{"Reduce::cpow", "Resolve::cpow", "FindInstance::cpow"}]},
  "Reduce::croot"->{
    Cell[323382, 11417, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],
    Cell[323550, 11424, 551, 11, 47, "Message",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],
    Cell[324104, 11437, 167, 4, 22, "Notes",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}]},
  "Resolve::croot"->{
    Cell[323382, 11417, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],
    Cell[323550, 11424, 551, 11, 47, "Message",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],
    Cell[324104, 11437, 167, 4, 22, "Notes",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}]},
  "FindInstance::croot"->{
    Cell[323382, 11417, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],
    Cell[323550, 11424, 551, 11, 47, "Message",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}],
    Cell[324104, 11437, 167, 4, 22, "Notes",
      CellTags->{"Reduce::croot", "Resolve::croot", "FindInstance::croot"}]},
  "FindInstance::nric"->{
    Cell[324308, 11446, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],
    Cell[324470, 11453, 432, 9, 33, "Message",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],
    Cell[324905, 11464, 164, 4, 22, "Notes",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}]},
  "Reduce::nric"->{
    Cell[324308, 11446, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],
    Cell[324470, 11453, 432, 9, 33, "Message",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],
    Cell[324905, 11464, 164, 4, 22, "Notes",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}]},
  "Resolve::nric"->{
    Cell[324308, 11446, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],
    Cell[324470, 11453, 432, 9, 33, "Message",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}],
    Cell[324905, 11464, 164, 4, 22, "Notes",
      CellTags->{"FindInstance::nric", "Reduce::nric", "Resolve::nric"}]},
  "FindInstance::nddc"->{
    Cell[325106, 11473, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],
    Cell[325268, 11480, 379, 9, 33, "Message",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],
    Cell[325650, 11491, 164, 4, 22, "Notes",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}]},
  "Reduce::nddc"->{
    Cell[325106, 11473, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],
    Cell[325268, 11480, 379, 9, 33, "Message",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],
    Cell[325650, 11491, 164, 4, 22, "Notes",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}]},
  "Resolve::nddc"->{
    Cell[325106, 11473, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],
    Cell[325268, 11480, 379, 9, 33, "Message",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}],
    Cell[325650, 11491, 164, 4, 22, "Notes",
      CellTags->{"FindInstance::nddc", "Reduce::nddc", "Resolve::nddc"}]},
  "Reduce::useq"->{
    Cell[325851, 11500, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Reduce::useq"],
    Cell[325931, 11503, 317, 5, 33, "Message",
      CellTags->"Reduce::useq"],
    Cell[326251, 11510, 123, 4, 22, "Notes",
      CellTags->"Reduce::useq"]},
  "FindInstance::rmod"->{
    Cell[326411, 11519, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::rmod", "Reduce::rmod"}],
    Cell[326542, 11525, 276, 7, 19, "Message",
      CellTags->{"FindInstance::rmod", "Reduce::rmod"}],
    Cell[326821, 11534, 147, 4, 22, "Notes",
      CellTags->{"FindInstance::rmod", "Reduce::rmod"}]},
  "Reduce::rmod"->{
    Cell[326411, 11519, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::rmod", "Reduce::rmod"}],
    Cell[326542, 11525, 276, 7, 19, "Message",
      CellTags->{"FindInstance::rmod", "Reduce::rmod"}],
    Cell[326821, 11534, 147, 4, 22, "Notes",
      CellTags->{"FindInstance::rmod", "Reduce::rmod"}]},
  "FindInstance::melem"->{
    Cell[327005, 11543, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::melem", "Reduce::melem"}],
    Cell[327140, 11549, 304, 8, 19, "Message",
      CellTags->{"FindInstance::melem", "Reduce::melem"}],
    Cell[327447, 11559, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::melem", "Reduce::melem"}]},
  "Reduce::melem"->{
    Cell[327005, 11543, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::melem", "Reduce::melem"}],
    Cell[327140, 11549, 304, 8, 19, "Message",
      CellTags->{"FindInstance::melem", "Reduce::melem"}],
    Cell[327447, 11559, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::melem", "Reduce::melem"}]},
  "FindInstance::mineq"->{
    Cell[327633, 11568, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::mineq", "Reduce::mineq"}],
    Cell[327768, 11574, 295, 7, 19, "Message",
      CellTags->{"FindInstance::mineq", "Reduce::mineq"}],
    Cell[328066, 11583, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::mineq", "Reduce::mineq"}]},
  "Reduce::mineq"->{
    Cell[327633, 11568, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::mineq", "Reduce::mineq"}],
    Cell[327768, 11574, 295, 7, 19, "Message",
      CellTags->{"FindInstance::mineq", "Reduce::mineq"}],
    Cell[328066, 11583, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::mineq", "Reduce::mineq"}]},
  "FindInstance::mcoef"->{
    Cell[328252, 11592, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}],
    Cell[328387, 11598, 436, 10, 33, "Message",
      CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}],
    Cell[328826, 11610, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}]},
  "Reduce::mcoef"->{
    Cell[328252, 11592, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}],
    Cell[328387, 11598, 436, 10, 33, "Message",
      CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}],
    Cell[328826, 11610, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::mcoef", "Reduce::mcoef"}]},
  "FindInstance::munsp"->{
    Cell[329012, 11619, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::munsp", "Reduce::munsp"}],
    Cell[329147, 11625, 541, 13, 33, "Message",
      CellTags->{"FindInstance::munsp", "Reduce::munsp"}],
    Cell[329691, 11640, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::munsp", "Reduce::munsp"}]},
  "Reduce::munsp"->{
    Cell[329012, 11619, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindInstance::munsp", "Reduce::munsp"}],
    Cell[329147, 11625, 541, 13, 33, "Message",
      CellTags->{"FindInstance::munsp", "Reduce::munsp"}],
    Cell[329691, 11640, 149, 4, 22, "Notes",
      CellTags->{"FindInstance::munsp", "Reduce::munsp"}]},
  "Resultant::method"->{
    Cell[329877, 11649, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Resultant::method"],
    Cell[329967, 11652, 172, 3, 19, "Message",
      CellTags->"Resultant::method"],
    Cell[330142, 11657, 128, 4, 22, "Notes",
      CellTags->"Resultant::method"]},
  "Resultant::var"->{
    Cell[330307, 11666, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Resultant::var"],
    Cell[330391, 11669, 149, 3, 19, "Message",
      CellTags->"Resultant::var"],
    Cell[330543, 11674, 125, 4, 22, "Notes",
      CellTags->"Resultant::var"]},
  "Root::overfl"->{
    Cell[330705, 11683, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Root::overfl"],
    Cell[330785, 11686, 192, 3, 19, "Message",
      CellTags->"Root::overfl"],
    Cell[330980, 11691, 123, 4, 22, "Notes",
      CellTags->"Root::overfl"]},
  "Simplify::infd"->{
    Cell[331140, 11700, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331275, 11706, 262, 7, 19, "Message",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331540, 11715, 260, 5, 36, "Notes",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331825, 11724, 88, 1, 38, "ExampleSection",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331916, 11727, 281, 7, 37, "Text",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[332222, 11738, 138, 3, 26, "Input",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[332363, 11743, 220, 5, 34, "Message",
      CellTags->{"FullSimplify::infd", "Simplify::infd"}],
    Cell[332586, 11750, 127, 3, 25, "Output",
      CellTags->{"FullSimplify::infd", "Simplify::infd"}]},
  "FullSimplify::infd"->{
    Cell[331140, 11700, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331275, 11706, 262, 7, 19, "Message",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331540, 11715, 260, 5, 36, "Notes",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331825, 11724, 88, 1, 38, "ExampleSection",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[331916, 11727, 281, 7, 37, "Text",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[332222, 11738, 138, 3, 26, "Input",
      CellTags->{"Simplify::infd", "FullSimplify::infd"}],
    Cell[332363, 11743, 220, 5, 34, "Message",
      CellTags->{"FullSimplify::infd", "Simplify::infd"}],
    Cell[332586, 11750, 127, 3, 25, "Output",
      CellTags->{"FullSimplify::infd", "Simplify::infd"}]},
  "Solve::ifun2"->{
    Cell[332774, 11760, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333137, 11774, 431, 11, 19, "Message",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333571, 11787, 277, 7, 22, "Notes",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}]},
  "Eliminate::ifun2"->{
    Cell[332774, 11760, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333137, 11774, 431, 11, 19, "Message",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333571, 11787, 277, 7, 22, "Notes",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}]},
  "Reduce::ifun2"->{
    Cell[332774, 11760, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333137, 11774, 431, 11, 19, "Message",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333571, 11787, 277, 7, 22, "Notes",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}]},
  "SolveAlways::ifun2"->{
    Cell[332774, 11760, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333137, 11774, 431, 11, 19, "Message",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333571, 11787, 277, 7, 22, "Notes",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}]},
  "MainSolve::ifun2"->{
    Cell[332774, 11760, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333137, 11774, 431, 11, 19, "Message",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333571, 11787, 277, 7, 22, "Notes",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}]},
  "AlgebraicRules::ifun2"->{
    Cell[332774, 11760, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333137, 11774, 431, 11, 19, "Message",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333571, 11787, 277, 7, 22, "Notes",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}]},
  "System`Private`OldReduce::ifun2"->{
    Cell[332774, 11760, 360, 12, 151, "ObjectNameWarningMessages",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333137, 11774, 431, 11, 19, "Message",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}],
    Cell[333571, 11787, 277, 7, 22, "Notes",
      CellTags->{
      "Solve::ifun2", "Eliminate::ifun2", "Reduce::ifun2", 
        "SolveAlways::ifun2", "MainSolve::ifun2", "AlgebraicRules::ifun2", 
        "System`Private`OldReduce::ifun2"}]},
  "Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig"->{
    Cell[333885, 11799, 167, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig"],
    Cell[334055, 11803, 250, 4, 33, "Message",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig"],
    Cell[334308, 11809, 167, 4, 22, "Notes",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig"]},
  "Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint"->{
    Cell[334512, 11818, 165, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint"],
    Cell[334680, 11822, 247, 4, 19, "Message",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint"],
    Cell[334930, 11828, 166, 4, 22, "Notes",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint"]},
  "Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg"->{
    Cell[335133, 11837, 165, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg"],
    Cell[335301, 11841, 319, 4, 33, "Message",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg"],
    Cell[335623, 11847, 166, 4, 22, "Notes",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg"]},
  "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl"->{
    Cell[335826, 11856, 296, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
        "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}],
    Cell[336125, 11865, 348, 9, 19, "Message",
      CellTags->{
      "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
        "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}],
    Cell[336476, 11876, 234, 6, 22, "Notes",
      CellTags->{
      "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
        "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}]},
  "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"->{
    Cell[335826, 11856, 296, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
        "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}],
    Cell[336125, 11865, 348, 9, 19, "Message",
      CellTags->{
      "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
        "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}],
    Cell[336476, 11876, 234, 6, 22, "Notes",
      CellTags->{
      "Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 
        "Algebra`SymmetricPolynomials`SymmetricReduction::nvarl"}]},
  "Algebra`SymmetricPolynomials`SymmetricReduction::neql"->{
    Cell[336747, 11887, 161, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricReduction::neql"],
    Cell[336911, 11891, 243, 4, 19, "Message",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricReduction::neql"],
    Cell[337157, 11897, 164, 4, 22, "Notes",
      CellTags->"Algebra`SymmetricPolynomials`SymmetricReduction::neql"]},
  "General::cadpr"->{
    Cell[337358, 11906, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::cadpr"],
    Cell[337442, 11909, 424, 10, 33, "Message",
      CellTags->"General::cadpr"],
    Cell[337869, 11921, 354, 9, 38, "Notes",
      CellTags->"General::cadpr"]},
  "General::naobj"->{
    Cell[338260, 11935, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::naobj"],
    Cell[338344, 11938, 378, 11, 19, "Message",
      CellTags->"General::naobj"],
    Cell[338725, 11951, 201, 6, 23, "Notes",
      CellTags->"General::naobj"],
    Cell[338951, 11961, 64, 1, 38, "ExampleSection",
      CellTags->"General::naobj"],
    Cell[339018, 11964, 285, 9, 38, "Text",
      CellTags->"General::naobj"],
    Cell[339328, 11977, 222, 5, 42, "Input",
      CellTags->"General::naobj"],
    Cell[339553, 11984, 214, 4, 33, "Message",
      CellTags->"General::naobj"],
    Cell[339770, 11990, 141, 3, 25, "Output",
      CellTags->"General::naobj"],
    Cell[339926, 11996, 136, 5, 23, "Text",
      CellTags->"General::naobj"],
    Cell[340087, 12005, 222, 5, 42, "Input",
      CellTags->"General::naobj"],
    Cell[340312, 12012, 89, 3, 25, "Output",
      CellTags->"General::naobj"]},
  "General::niupf"->{
    Cell[340462, 12022, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::niupf"],
    Cell[340546, 12025, 467, 12, 19, "Message",
      CellTags->"General::niupf"],
    Cell[341016, 12039, 178, 4, 22, "Notes",
      CellTags->"General::niupf"],
    Cell[341219, 12047, 64, 1, 38, "ExampleSection",
      CellTags->"General::niupf"],
    Cell[341286, 12050, 208, 5, 37, "Text",
      CellTags->"General::niupf"],
    Cell[341519, 12059, 165, 4, 26, "Input",
      CellTags->"General::niupf"],
    Cell[341687, 12065, 280, 5, 34, "Message",
      CellTags->"General::niupf"],
    Cell[341970, 12072, 160, 4, 27, "Output",
      CellTags->"General::niupf"],
    Cell[342167, 12081, 117, 3, 26, "Input",
      CellTags->"General::niupf"],
    Cell[342287, 12086, 117, 3, 25, "Output",
      CellTags->"General::niupf"],
    Cell[342419, 12092, 193, 5, 23, "Text",
      CellTags->"General::niupf"],
    Cell[342637, 12101, 165, 4, 26, "Input",
      CellTags->"General::niupf"],
    Cell[342805, 12107, 190, 5, 40, "Output",
      CellTags->"General::niupf"]},
  "General::nupf"->{
    Cell[343056, 12119, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nupf"],
    Cell[343138, 12122, 444, 12, 19, "Message",
      CellTags->"General::nupf"],
    Cell[343585, 12136, 224, 5, 36, "Notes",
      CellTags->"General::nupf"],
    Cell[343834, 12145, 63, 1, 38, "ExampleSection",
      CellTags->"General::nupf"],
    Cell[343900, 12148, 194, 5, 23, "Text",
      CellTags->"General::nupf"],
    Cell[344119, 12157, 166, 4, 26, "Input",
      CellTags->"General::nupf"],
    Cell[344288, 12163, 263, 5, 34, "Message",
      CellTags->"General::nupf"],
    Cell[344554, 12170, 164, 4, 27, "Output",
      CellTags->"General::nupf"],
    Cell[344733, 12177, 136, 5, 23, "Text",
      CellTags->"General::nupf"],
    Cell[344894, 12186, 163, 4, 26, "Input",
      CellTags->"General::nupf"],
    Cell[345060, 12192, 289, 6, 45, "Output",
      CellTags->"General::nupf"]},
  "Factor::facim"->{
    Cell[345410, 12205, 140, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[345553, 12211, 321, 7, 19, "Message",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[345877, 12220, 369, 10, 37, "Notes",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346271, 12234, 92, 1, 38, "ExampleSection",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346366, 12237, 226, 5, 36, "Text",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346617, 12246, 144, 3, 26, "Input",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346764, 12251, 244, 5, 33, "Message",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[347011, 12258, 160, 3, 25, "Output",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}]},
  "FactorSquareFree::facim"->{
    Cell[345410, 12205, 140, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[345553, 12211, 321, 7, 19, "Message",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[345877, 12220, 369, 10, 37, "Notes",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346271, 12234, 92, 1, 38, "ExampleSection",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346366, 12237, 226, 5, 36, "Text",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346617, 12246, 144, 3, 26, "Input",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[346764, 12251, 244, 5, 33, "Message",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}],
    Cell[347011, 12258, 160, 3, 25, "Output",
      CellTags->{"Factor::facim", "FactorSquareFree::facim"}]},
  "FindInstance::boolv"->{
    Cell[347232, 12268, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindInstance::boolv"],
    Cell[347326, 12271, 173, 3, 19, "Message",
      CellTags->"FindInstance::boolv"],
    Cell[347502, 12276, 130, 4, 22, "Notes",
      CellTags->"FindInstance::boolv"]},
  "FindInstance::exvar"->{
    Cell[347669, 12285, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindInstance::exvar"],
    Cell[347763, 12288, 216, 4, 19, "Message",
      CellTags->"FindInstance::exvar"],
    Cell[347982, 12294, 130, 4, 22, "Notes",
      CellTags->"FindInstance::exvar"]},
  "FindInstance::fwsol"->{
    Cell[348149, 12303, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindInstance::fwsol"],
    Cell[348243, 12306, 273, 5, 33, "Message",
      CellTags->"FindInstance::fwsol"],
    Cell[348519, 12313, 130, 4, 22, "Notes",
      CellTags->"FindInstance::fwsol"]},
  "FindInstance::nsmet"->{
    Cell[348686, 12322, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindInstance::nsmet"],
    Cell[348780, 12325, 259, 4, 33, "Message",
      CellTags->"FindInstance::nsmet"],
    Cell[349042, 12331, 130, 4, 22, "Notes",
      CellTags->"FindInstance::nsmet"]},
  "General::ncomp"->{
    Cell[349209, 12340, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ncomp"],
    Cell[349293, 12343, 292, 8, 19, "Message",
      CellTags->"General::ncomp"],
    Cell[349588, 12353, 125, 4, 22, "Notes",
      CellTags->"General::ncomp"]},
  "PolynomialMod::polyi"->{
    Cell[349750, 12362, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PolynomialMod::polyi"],
    Cell[349846, 12365, 175, 3, 19, "Message",
      CellTags->"PolynomialMod::polyi"],
    Cell[350024, 12370, 131, 4, 22, "Notes",
      CellTags->"PolynomialMod::polyi"]},
  "Maximize::consc"->{
    Cell[350192, 12379, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350451, 12389, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350807, 12400, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}]},
  "Minimize::consc"->{
    Cell[350192, 12379, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350451, 12389, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350807, 12400, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}]},
  "Experimental`Infimum::consc"->{
    Cell[350192, 12379, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350451, 12389, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350807, 12400, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}]},
  "Experimental`Supremum::consc"->{
    Cell[350192, 12379, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350451, 12389, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}],
    Cell[350807, 12400, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consc", "Minimize::consc", "Experimental`Infimum::consc", 
        "Experimental`Supremum::consc"}]},
  "Maximize::consf"->{
    Cell[351062, 12411, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351321, 12421, 435, 11, 33, "Message",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351759, 12434, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}]},
  "Minimize::consf"->{
    Cell[351062, 12411, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351321, 12421, 435, 11, 33, "Message",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351759, 12434, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}]},
  "Experimental`Infimum::consf"->{
    Cell[351062, 12411, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351321, 12421, 435, 11, 33, "Message",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351759, 12434, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}]},
  "Experimental`Supremum::consf"->{
    Cell[351062, 12411, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351321, 12421, 435, 11, 33, "Message",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}],
    Cell[351759, 12434, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consf", "Minimize::consf", "Experimental`Infimum::consf", 
        "Experimental`Supremum::consf"}]},
  "Maximize::consv"->{
    Cell[352014, 12445, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352273, 12455, 394, 10, 33, "Message",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352670, 12467, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}]},
  "Minimize::consv"->{
    Cell[352014, 12445, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352273, 12455, 394, 10, 33, "Message",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352670, 12467, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}]},
  "Experimental`Infimum::consv"->{
    Cell[352014, 12445, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352273, 12455, 394, 10, 33, "Message",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352670, 12467, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}]},
  "Experimental`Supremum::consv"->{
    Cell[352014, 12445, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352273, 12455, 394, 10, 33, "Message",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}],
    Cell[352670, 12467, 218, 6, 22, "Notes",
      CellTags->{
      "Maximize::consv", "Minimize::consv", "Experimental`Infimum::consv", 
        "Experimental`Supremum::consv"}]},
  "Maximize::mixdom"->{
    Cell[352925, 12478, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353192, 12488, 393, 10, 19, "Message",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353588, 12500, 222, 6, 22, "Notes",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}]},
  "Minimize::mixdom"->{
    Cell[352925, 12478, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353192, 12488, 393, 10, 19, "Message",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353588, 12500, 222, 6, 22, "Notes",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}]},
  "Experimental`Infimum::mixdom"->{
    Cell[352925, 12478, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353192, 12488, 393, 10, 19, "Message",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353588, 12500, 222, 6, 22, "Notes",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}]},
  "Experimental`Supremum::mixdom"->{
    Cell[352925, 12478, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353192, 12488, 393, 10, 19, "Message",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}],
    Cell[353588, 12500, 222, 6, 22, "Notes",
      CellTags->{
      "Maximize::mixdom", "Minimize::mixdom", "Experimental`Infimum::mixdom", 
        "Experimental`Supremum::mixdom"}]},
  "Maximize::objc"->{
    Cell[353847, 12511, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354098, 12521, 357, 9, 19, "Message",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354458, 12532, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}]},
  "Minimize::objc"->{
    Cell[353847, 12511, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354098, 12521, 357, 9, 19, "Message",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354458, 12532, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}]},
  "Experimental`Infimum::objc"->{
    Cell[353847, 12511, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354098, 12521, 357, 9, 19, "Message",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354458, 12532, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}]},
  "Experimental`Supremum::objc"->{
    Cell[353847, 12511, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354098, 12521, 357, 9, 19, "Message",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}],
    Cell[354458, 12532, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objc", "Minimize::objc", "Experimental`Infimum::objc", 
        "Experimental`Supremum::objc"}]},
  "Maximize::objv"->{
    Cell[354709, 12543, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[354960, 12553, 398, 10, 33, "Message",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[355361, 12565, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}]},
  "Minimize::objv"->{
    Cell[354709, 12543, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[354960, 12553, 398, 10, 33, "Message",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[355361, 12565, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}]},
  "Experimental`Infimum::objv"->{
    Cell[354709, 12543, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[354960, 12553, 398, 10, 33, "Message",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[355361, 12565, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}]},
  "Experimental`Supremum::objv"->{
    Cell[354709, 12543, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[354960, 12553, 398, 10, 33, "Message",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}],
    Cell[355361, 12565, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::objv", "Minimize::objv", "Experimental`Infimum::objv", 
        "Experimental`Supremum::objv"}]},
  "Maximize::vdom"->{
    Cell[355612, 12576, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[355863, 12586, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[356219, 12597, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}]},
  "Minimize::vdom"->{
    Cell[355612, 12576, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[355863, 12586, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[356219, 12597, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}]},
  "Experimental`Infimum::vdom"->{
    Cell[355612, 12576, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[355863, 12586, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[356219, 12597, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}]},
  "Experimental`Supremum::vdom"->{
    Cell[355612, 12576, 248, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[355863, 12586, 353, 9, 19, "Message",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}],
    Cell[356219, 12597, 214, 6, 22, "Notes",
      CellTags->{
      "Maximize::vdom", "Minimize::vdom", "Experimental`Infimum::vdom", 
        "Experimental`Supremum::vdom"}]},
  "Algebra`MatrixPowerMod::arg1"->{
    Cell[356470, 12608, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`MatrixPowerMod::arg1"],
    Cell[356582, 12611, 258, 5, 33, "Message",
      CellTags->"Algebra`MatrixPowerMod::arg1"],
    Cell[356843, 12618, 139, 4, 22, "Notes",
      CellTags->"Algebra`MatrixPowerMod::arg1"]},
  "Algebra`MatrixPowerMod::arg2"->{
    Cell[357019, 12627, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`MatrixPowerMod::arg2"],
    Cell[357131, 12630, 228, 5, 19, "Message",
      CellTags->"Algebra`MatrixPowerMod::arg2"],
    Cell[357362, 12637, 139, 4, 22, "Notes",
      CellTags->"Algebra`MatrixPowerMod::arg2"]},
  "Algebra`MatrixPowerMod::arg3"->{
    Cell[357538, 12646, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Algebra`MatrixPowerMod::arg3"],
    Cell[357650, 12649, 234, 5, 33, "Message",
      CellTags->"Algebra`MatrixPowerMod::arg3"],
    Cell[357887, 12656, 139, 4, 22, "Notes",
      CellTags->"Algebra`MatrixPowerMod::arg3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Limit::ldir", 358733, 12682},
  {"Limit::lim", 359582, 12705},
  {"$MaxRootDegree::npi", 360796, 12738},
  {"LogicalExpand::elist", 361503, 12755},
  {"MainSolve::elist", 365236, 12826},
  {"Roots::elist", 368965, 12897},
  {"ToRules::elist", 372696, 12968},
  {"Solve::elist", 376425, 13039},
  {"Reduce::elist", 380155, 13110},
  {"Eliminate::elist", 383888, 13181},
  {"SolveAlways::elist", 387623, 13252},
  {"AlgebraicRules::elist", 391361, 13323},
  {"GroebnerBasis::elist", 395098, 13394},
  {"PolynomialReduce::elist", 398838, 13465},
  {"System`Private`OldReduce::elist", 402586, 13536},
  {"LogicalExpand::eqf", 406321, 13607},
  {"MainSolve::eqf", 410969, 13692},
  {"Roots::eqf", 415613, 13777},
  {"ToRules::eqf", 420259, 13862},
  {"Solve::eqf", 424903, 13947},
  {"Reduce::eqf", 429548, 14032},
  {"Eliminate::eqf", 434196, 14117},
  {"SolveAlways::eqf", 438846, 14202},
  {"AlgebraicRules::eqf", 443499, 14287},
  {"GroebnerBasis::eqf", 448151, 14372},
  {"PolynomialReduce::eqf", 452806, 14457},
  {"Internal`DistributedTermsList::eqf", 457474, 14542},
  {"System`Private`OldReduce::eqf", 462137, 14627},
  {"Reduce::bdomv", 466784, 14712},
  {"Reduce::nsmet", 467055, 14719},
  {"Root::mdeg", 467941, 14742},
  {"Root::npoly", 468577, 14759},
  {"Root::nup", 469440, 14782},
  {"Solve::tdep", 470283, 14805},
  {"MainSolve::tdep", 473724, 14872},
  {"Roots::tdep", 477161, 14939},
  {"Reduce::tdep", 480599, 15006},
  {"System`Private`OldReduce::tdep", 484055, 15073},
  {"Eliminate::tdep", 487496, 15140},
  {"SolveAlways::tdep", 490939, 15207},
  {"AlgebraicRules::tdep", 494385, 15274},
  {"GroebnerBasis::tdep", 497830, 15341},
  {"PolynomialReduce::tdep", 501278, 15408},
  {"GroebnerBasis::varsrt", 504725, 15475},
  {"PolynomialReduce::varsrt", 506488, 15514},
  {"Internal`DistributedTermsList::varsrt", 508264, 15553},
  {"Internal`GroebnerWalk::varsrt", 510032, 15592},
  {"PolynomialMod::polym", 511791, 15631},
  {"Root::sbr", 513016, 15660},
  {"AlgebraicRules::algdat", 513664, 15677},
  {"AlgebraicRules::newv", 514670, 15700},
  {"Solve::incnst", 515396, 15717},
  {"Coefficient::numv", 516226, 15738},
  {"Exponent::numv", 517497, 15763},
  {"ComplexExpand::exf", 518772, 15788},
  {"D::dvar", 519722, 15811},
  {"DSolve::deqn", 520556, 15834},
  {"NDSolve::deqn", 523047, 15889},
  {"RSolve::deqn", 525537, 15944},
  {"NRSolve::deqn", 528028, 15999},
  {"DSolve::deqx", 530518, 16054},
  {"NDSolve::deqx", 530847, 16061},
  {"RSolve::deqx", 531175, 16068},
  {"DSolve::dsmsm", 532064, 16091},
  {"RSolve::dsmsm", 532888, 16108},
  {"DSolve::underdet", 533715, 16125},
  {"NDSolve::underdet", 535537, 16170},
  {"RSolve::underdet", 537358, 16215},
  {"NRSolve::underdet", 539180, 16260},
  {"DSolve::overdet", 541000, 16305},
  {"NDSolve::overdet", 542308, 16338},
  {"RSolve::overdet", 543615, 16371},
  {"NRSolve::overdet", 544923, 16404},
  {"DSolve::ivar2", 546228, 16437},
  {"NDSolve::ivar2", 546700, 16448},
  {"RSolve::ivar2", 547171, 16459},
  {"NRSolve::ivar2", 547643, 16470},
  {"DSolve::dsfun", 548114, 16481},
  {"NDSolve::dsfun", 548503, 16488},
  {"RSolve::dsfun", 548891, 16495},
  {"DSolve::dsvar", 549279, 16502},
  {"NDSolve::dsvar", 550112, 16519},
  {"DSolve::derlen", 550945, 16536},
  {"NDSolve::derlen", 551794, 16553},
  {"DSolve::pde", 552639, 16570},
  {"DSolve::twoivarg", 552911, 16577},
  {"NDSolve::twoivarg", 553350, 16587},
  {"RSolve::twoivarg", 553788, 16597},
  {"RSolve::rord", 554222, 16607},
  {"RSolve::piarg", 554494, 16614},
  {"DSolve::pdord", 554769, 16621},
  {"RSolve::pdord", 555044, 16628},
  {"DSolve::alliv", 555319, 16635},
  {"NDSolve::alliv", 555707, 16642},
  {"RSolve::alliv", 556094, 16649},
  {"DSolve::baddv", 556481, 16656},
  {"NDSolve::baddv", 556953, 16667},
  {"RSolve::baddv", 557424, 16678},
  {"NRSolve::baddv", 557896, 16689},
  {"DSolve::litarg", 558368, 16700},
  {"NDSolve::litarg", 560186, 16731},
  {"RSolve::litarg", 562003, 16762},
  {"DSolve::bvimp", 563819, 16793},
  {"RSolve::bvimp", 564152, 16800},
  {"DSolve::bvlim", 564485, 16807},
  {"RSolve::bvlim", 564818, 16814},
  {"DSolve::bvfail", 565152, 16821},
  {"RSolve::bvfail", 565492, 16828},
  {"DSolve::bvnul", 565831, 16835},
  {"RSolve::bvnul", 566654, 16852},
  {"DSolve::bvnr", 567476, 16869},
  {"RSolve::bvnr", 567802, 16876},
  {"Solve::ifun", 568127, 16883},
  {"Eliminate::ifun", 569472, 16906},
  {"SolveAlways::ifun", 570819, 16929},
  {"Reduce::ifun", 572161, 16952},
  {"System`Private`OldReduce::ifun", 572737, 16965},
  {"MainSolve::ifun", 573298, 16978},
  {"AlgebraicRules::ifun", 573864, 16991},
  {"Factor::facmm", 574423, 17004},
  {"Factor::priml", 575092, 17021},
  {"Factor::ufac", 575367, 17028},
  {"FactorSquareFree::ufac", 575732, 17035},
  {"General::mult", 576088, 17042},
  {"General::modint", 577002, 17065},
  {"General::modgp", 577287, 17072},
  {"General::modm", 578606, 17105},
  {"General::modn", 578884, 17112},
  {"General::modp", 579796, 17135},
  {"General::nalg", 581643, 17182},
  {"General::nmod", 582556, 17205},
  {"General::npoly", 583468, 17228},
  {"General::npolys", 584392, 17251},
  {"General::poly", 585325, 17274},
  {"General::polyx", 586237, 17297},
  {"General::primm", 586519, 17304},
  {"General::prims", 586801, 17311},
  {"GroebnerBasis::badcf", 587089, 17318},
  {"PolynomialReduce::badcf", 587776, 17334},
  {"Internal`GroebnerWalk::badcf", 588468, 17350},
  {"Internal`DistributedTermsList::badcf", 589168, 17366},
  {"GroebnerBasis::coef", 589851, 17382},
  {"PolynomialReduce::coef", 592167, 17435},
  {"Internal`GroebnerWalk::coef", 594488, 17488},
  {"Internal`DistributedTermsList::coef", 596817, 17541},
  {"GroebnerBasis::elmvar", 599132, 17594},
  {"PolynomialReduce::elmvar", 599834, 17610},
  {"Internal`GroebnerWalk::elmvar", 600541, 17626},
  {"Internal`DistributedTermsList::elmvar", 601256, 17642},
  {"GroebnerBasis::fltgb", 601954, 17658},
  {"PolynomialReduce::fltgb", 602641, 17674},
  {"Internal`GroebnerWalk::fltgb", 603333, 17690},
  {"Internal`DistributedTermsList::fltgb", 604033, 17706},
  {"GroebnerBasis::intgb", 604717, 17722},
  {"PolynomialReduce::intgb", 607077, 17775},
  {"Internal`GroebnerWalk::intgb", 609442, 17828},
  {"Internal`DistributedTermsList::intgb", 611815, 17881},
  {"GroebnerBasis::mnmord1", 614174, 17934},
  {"PolynomialReduce::mnmord1", 616627, 17987},
  {"Internal`GroebnerWalk::mnmord1", 619085, 18040},
  {"Internal`DistributedTermsList::mnmord1", 621551, 18093},
  {"GroebnerBasis::mnmord2", 624001, 18146},
  {"PolynomialReduce::mnmord2", 626451, 18199},
  {"Internal`GroebnerWalk::mnmord2", 628906, 18252},
  {"Internal`DistributedTermsList::mnmord2", 631369, 18305},
  {"GroebnerBasis::modflt", 633815, 18358},
  {"PolynomialReduce::modflt", 635585, 18397},
  {"Internal`GroebnerWalk::modflt", 637360, 18436},
  {"Internal`DistributedTermsList::modflt", 639143, 18475},
  {"Inequality::ineq", 640905, 18514},
  {"GroebnerBasis::pdvar2", 641858, 18537},
  {"PolynomialReduce::pdvar2", 643628, 18576},
  {"Internal`GroebnerWalk::pdvar2", 645403, 18615},
  {"Internal`DistributedTermsList::pdvar2", 647186, 18654},
  {"GroebnerBasis::poly2", 648952, 18693},
  {"PolynomialReduce::poly2", 649701, 18709},
  {"Resultant::poly2", 650443, 18725},
  {"Internal`GroebnerWalk::poly2", 651197, 18741},
  {"Internal`DistributedTermsList::poly2", 651959, 18757},
  {"GroebnerBasis::wgtmat1", 652707, 18773},
  {"PolynomialReduce::wgtmat1", 655158, 18826},
  {"Internal`GroebnerWalk::wgtmat1", 657614, 18879},
  {"Internal`DistributedTermsList::wgtmat1", 660078, 18932},
  {"GroebnerBasis::wgtmat2", 662526, 18985},
  {"PolynomialReduce::wgtmat2", 663240, 19001},
  {"Internal`GroebnerWalk::wgtmat2", 663959, 19017},
  {"Internal`DistributedTermsList::wgtmat2", 664686, 19033},
  {"Integrate::gener", 665391, 19049},
  {"Integrate::idiv", 665681, 19056},
  {"Integrate::ilim", 666615, 19079},
  {"InterpolatingPolynomial::ipdat", 667565, 19102},
  {"InterpolatingPolynomial::ipdup", 668681, 19125},
  {"InterpolatingPolynomial::ipf", 669795, 19148},
  {"InterpolatingPolynomial::ipval", 670798, 19169},
  {"InterpolatingPolynomial::ipvar", 671915, 19192},
  {"InverseFunction::ifun", 673022, 19215},
  {"InverseFunction::noinv", 673772, 19232},
  {"Limit::limf", 674520, 19249},
  {"Solve::ibool", 675408, 19272},
  {"Reduce::ibool", 678141, 19328},
  {"System`Private`OldReduce::ibool", 680892, 19384},
  {"Eliminate::ibool", 683628, 19440},
  {"SolveAlways::ibool", 686366, 19496},
  {"MainSolve::ibool", 689102, 19552},
  {"AlgebraicRules::ibool", 691843, 19608},
  {"Solve::method", 694576, 19664},
  {"Reduce::method", 697387, 19720},
  {"System`Private`OldReduce::method", 700216, 19776},
  {"Eliminate::method", 703030, 19832},
  {"SolveAlways::method", 705846, 19888},
  {"MainSolve::method", 708660, 19944},
  {"AlgebraicRules::method", 711479, 20000},
  {"Solve::mode", 714287, 20056},
  {"Reduce::mode", 716706, 20107},
  {"System`Private`OldReduce::mode", 719143, 20158},
  {"Eliminate::mode", 721565, 20209},
  {"SolveAlways::mode", 723989, 20260},
  {"MainSolve::mode", 726411, 20311},
  {"AlgebraicRules::mode", 728838, 20362},
  {"Solve::verif", 731257, 20413},
  {"Reduce::verif", 733234, 20451},
  {"System`Private`OldReduce::verif", 735229, 20489},
  {"Eliminate::verif", 737209, 20527},
  {"MainSolve::verif", 739189, 20565},
  {"AlgebraicRules::verif", 741174, 20603},
  {"Root::amb", 743147, 20641},
  {"Root::deg", 743408, 20648},
  {"General::rnum", 744273, 20671},
  {"Root::rnv", 745181, 20694},
  {"Root::var", 746043, 20717},
  {"RootSum::pfn", 746908, 20740},
  {"Roots::badmod", 747808, 20763},
  {"Series::esss", 748084, 20770},
  {"Series::icm", 748750, 20787},
  {"Series::lss", 749641, 20810},
  {"Series::nmer", 749911, 20817},
  {"Series::sbyc", 750185, 20824},
  {"Series::serlim", 751394, 20855},
  {"Series::sspec", 752317, 20878},
  {"Series::vcnt", 753228, 20901},
  {"SeriesData::csa", 754132, 20924},
  {"SeriesData::scmn", 755070, 20947},
  {"SeriesData::scmp", 756103, 20972},
  {"SeriesData::sdatc", 757054, 20995},
  {"SeriesData::sdatd", 758014, 21018},
  {"SeriesData::sdatn", 758976, 21041},
  {"SeriesData::sdatv", 759937, 21064},
  {"SeriesData::slnc", 760896, 21087},
  {"SeriesData::ssdn", 761845, 21110},
  {"FullSimplify::cfn", 762792, 21133},
  {"Simplify::cfn", 764268, 21162},
  {"FullSimplify::time", 765749, 21191},
  {"Simplify::time", 767662, 21228},
  {"Solve::circ", 769572, 21265},
  {"Roots::circ", 770370, 21281},
  {"Reduce::circ", 771169, 21297},
  {"System`Private`OldReduce::circ", 771986, 21313},
  {"Eliminate::circ", 772788, 21329},
  {"SolveAlways::circ", 773592, 21345},
  {"MainSolve::circ", 774394, 21361},
  {"AlgebraicRules::circ", 775201, 21377},
  {"Solve::dinv", 775999, 21393},
  {"Eliminate::dinv", 779770, 21466},
  {"Roots::dinv", 783537, 21539},
  {"Reduce::dinv", 787305, 21612},
  {"System`Private`OldReduce::dinv", 791091, 21685},
  {"SolveAlways::dinv", 794864, 21758},
  {"GroebnerBasis::dinv", 798639, 21831},
  {"PolynomialReduce::dinv", 802417, 21904},
  {"MainSolve::dinv", 806188, 21977},
  {"AlgebraicRules::dinv", 809964, 22050},
  {"Solve::smod", 813731, 22123},
  {"Solve::solex", 814618, 22146},
  {"Roots::solex", 815648, 22168},
  {"Reduce::solex", 816679, 22190},
  {"System`Private`OldReduce::solex", 817728, 22212},
  {"Eliminate::solex", 818762, 22234},
  {"SolveAlways::solex", 819798, 22256},
  {"GroebnerBasis::solex", 820836, 22278},
  {"PolynomialReduce::solex", 821877, 22300},
  {"MainSolve::solex", 822911, 22322},
  {"AlgebraicRules::solex", 823950, 22344},
  {"Solve::svars", 824980, 22366},
  {"TimeConstraint::nvc", 825886, 22389},
  {"General::bmod", 826863, 22412},
  {"General::ivar", 827774, 22435},
  {"General::mext", 829159, 22470},
  {"General::nord", 830226, 22497},
  {"Element::bset", 831536, 22530},
  {"NotElement::bset", 832449, 22553},
  {"General::bass", 832735, 22560},
  {"General::altel", 833651, 22583},
  {"General::fas", 834585, 22606},
  {"General::cas", 835494, 22629},
  {"Developer`InequalityInstance::nrpi", 836191, 22646},
  {"Experimental`ExistsRealQ::nrpi", 838754, 22702},
  {"Experimental`ForAllRealQ::nrpi", 841317, 22758},
  {"Experimental`ImpliesRealQ::nrpi", 843881, 22814},
  {"CylindricalDecomposition::nrtpi", 846445, 22870},
  {"Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi", 847074, \
22883},
  {"Developer`InequalityInstance::weak", 847677, 22896},
  {"Experimental`ExistsRealQ::weak", 848421, 22912},
  {"Experimental`ForAllRealQ::weak", 849165, 22928},
  {"Experimental`ImpliesRealQ::weak", 849910, 22944},
  {"Roots::lexp", 850635, 22960},
  {"Subresultants::slpr", 850915, 22967},
  {"Experimental`CylindricalAlgebraicDecomposition::deprec", 851254, 22974},
  {"Experimental`Resolve::deprec", 851673, 22981},
  {"GroebnerBasis::gmeth1", 852007, 22988},
  {"Internal`GroebnerWalk::gmeth1", 852433, 22995},
  {"GroebnerBasis::gmeth2", 852851, 23002},
  {"Internal`GroebnerWalk::gmeth2", 853277, 23009},
  {"Internal`GroebnerWalk::gstrat", 853703, 23016},
  {"GroebnerBasis::gstrat", 854121, 23023},
  {"Internal`GroebnerWalk::parmvar", 854548, 23030},
  {"InterpolatingPolynomial::moddata", 854899, 23037},
  {"DSolve::dvnoarg", 855239, 23044},
  {"NDSolve::dvnoarg", 855652, 23051},
  {"RSolve::dvnoarg", 856064, 23058},
  {"DSolve::ivhead", 856475, 23065},
  {"NDSolve::ivhead", 856878, 23072},
  {"RSolve::ivhead", 857280, 23079},
  {"DSolve::dvleaf", 857682, 23086},
  {"NDSolve::dvleaf", 859049, 23109},
  {"RSolve::dvleaf", 860415, 23132},
  {"DSolve::der1", 861779, 23155},
  {"NDSolve::der1", 862114, 23162},
  {"DSolve::derarg", 862450, 23169},
  {"NDSolve::derarg", 862799, 23176},
  {"DSolve::nestdv", 863147, 23183},
  {"NDSolve::nestdv", 863550, 23190},
  {"RSolve::nestdv", 863952, 23197},
  {"DSolve::dvlen", 864353, 23204},
  {"NDSolve::dvlen", 864746, 23211},
  {"RSolve::dvlen", 865138, 23218},
  {"Algebra`PolynomialGCDModList::nogcd", 865552, 23225},
  {"PolynomialMod::coef", 865905, 23232},
  {"Algebra`PolynomialMakeMonicModList::nprimemod", 866235, 23239},
  {"Algebra`PolynomialModList::badmod", 866632, 23246},
  {"Algebra`PolynomialModList::divby0", 866993, 23253},
  {"Algebra`PolynomialModList::ninv", 867352, 23260},
  {"Algebra`PolynomialModList::nsfmod", 867707, 23267},
  {"Algebra`PolynomialModList::unipoly", 868069, 23274},
  {"Algebra`PolynomialPthRootModList::noroot", 868440, 23281},
  {"Algebra`PolynomialQuotientModList::divby0", 868830, 23288},
  {"NumberTheory`AlgebraicNumberFields`Algebraic::cfls", 869232, 23295},
  {"NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu", 870611, \
23318},
  {"NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel", 871106, \
23328},
  {"Reduce::bddom", 871555, 23338},
  {"Maximize::vlist", 871837, 23345},
  {"Minimize::vlist", 872496, 23358},
  {"Experimental`Infimum::vlist", 873167, 23371},
  {"Experimental`Supremum::vlist", 873839, 23384},
  {"FindInstance::vlist", 874502, 23397},
  {"Reduce::mdom", 875158, 23410},
  {"FindInstance::mdom", 875513, 23417},
  {"Resolve::bddom", 875864, 23424},
  {"FindInstance::bddom", 876229, 23431},
  {"Internal`FundamentalDiscriminantQ::nargs", 876615, 23438},
  {"Internal`QuadraticFundamentalUnit::nargs", 877004, 23445},
  {"Internal`QuadraticFundamentalUnit::pint", 877392, 23452},
  {"FindInstance::naqs", 877756, 23459},
  {"Reduce::naqs", 878105, 23466},
  {"Reduce::ratnz", 878455, 23473},
  {"Reduce::inex", 878734, 23480},
  {"Reduce::cpow", 879010, 23487},
  {"Resolve::cpow", 879412, 23494},
  {"FindInstance::cpow", 879819, 23501},
  {"Reduce::croot", 880221, 23508},
  {"Resolve::croot", 880633, 23515},
  {"FindInstance::croot", 881050, 23522},
  {"FindInstance::nric", 881466, 23529},
  {"Reduce::nric", 881866, 23536},
  {"Resolve::nric", 882267, 23543},
  {"FindInstance::nddc", 882673, 23550},
  {"Reduce::nddc", 883073, 23557},
  {"Resolve::nddc", 883474, 23564},
  {"Reduce::useq", 883874, 23571},
  {"FindInstance::rmod", 884156, 23578},
  {"Reduce::rmod", 884505, 23585},
  {"FindInstance::melem", 884861, 23592},
  {"Reduce::melem", 885217, 23599},
  {"FindInstance::mineq", 885579, 23606},
  {"Reduce::mineq", 885935, 23613},
  {"FindInstance::mcoef", 886297, 23620},
  {"Reduce::mcoef", 886654, 23627},
  {"FindInstance::munsp", 887017, 23634},
  {"Reduce::munsp", 887374, 23641},
  {"Resultant::method", 887735, 23648},
  {"Resultant::var", 888028, 23655},
  {"Root::overfl", 888310, 23662},
  {"Simplify::infd", 888588, 23669},
  {"FullSimplify::infd", 889479, 23686},
  {"Solve::ifun2", 890364, 23703},
  {"Eliminate::ifun2", 891146, 23719},
  {"Reduce::ifun2", 891925, 23735},
  {"SolveAlways::ifun2", 892709, 23751},
  {"MainSolve::ifun2", 893491, 23767},
  {"AlgebraicRules::ifun2", 894278, 23783},
  {"System`Private`OldReduce::ifun2", 895075, 23799},
  {"Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig", 895897, \
23815},
  {"Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint", 896349, 23822},
  {"Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg", 896798, 23829},
  {"Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl", 897247, 23836},
  {"Algebra`SymmetricPolynomials`SymmetricReduction::nvarl", 897923, 23849},
  {"Algebra`SymmetricPolynomials`SymmetricReduction::neql", 898598, 23862},
  {"General::cadpr", 899000, 23869},
  {"General::naobj", 899285, 23876},
  {"General::niupf", 900219, 23899},
  {"General::nupf", 901314, 23926},
  {"Factor::facim", 902237, 23949},
  {"FactorSquareFree::facim", 903166, 23966},
  {"FindInstance::boolv", 904091, 23983},
  {"FindInstance::exvar", 904395, 23990},
  {"FindInstance::fwsol", 904699, 23997},
  {"FindInstance::nsmet", 905003, 24004},
  {"General::ncomp", 905302, 24011},
  {"PolynomialMod::polyi", 905592, 24018},
  {"Maximize::consc", 905895, 24025},
  {"Minimize::consc", 906484, 24038},
  {"Experimental`Infimum::consc", 907085, 24051},
  {"Experimental`Supremum::consc", 907687, 24064},
  {"Maximize::consf", 908276, 24077},
  {"Minimize::consf", 908866, 24090},
  {"Experimental`Infimum::consf", 909468, 24103},
  {"Experimental`Supremum::consf", 910071, 24116},
  {"Maximize::consv", 910661, 24129},
  {"Minimize::consv", 911251, 24142},
  {"Experimental`Infimum::consv", 911853, 24155},
  {"Experimental`Supremum::consv", 912456, 24168},
  {"Maximize::mixdom", 913047, 24181},
  {"Minimize::mixdom", 913650, 24194},
  {"Experimental`Infimum::mixdom", 914265, 24207},
  {"Experimental`Supremum::mixdom", 914881, 24220},
  {"Maximize::objc", 915482, 24233},
  {"Minimize::objc", 916058, 24246},
  {"Experimental`Infimum::objc", 916646, 24259},
  {"Experimental`Supremum::objc", 917235, 24272},
  {"Maximize::objv", 917811, 24285},
  {"Minimize::objv", 918388, 24298},
  {"Experimental`Infimum::objv", 918977, 24311},
  {"Experimental`Supremum::objv", 919567, 24324},
  {"Maximize::vdom", 920144, 24337},
  {"Minimize::vdom", 920720, 24350},
  {"Experimental`Infimum::vdom", 921308, 24363},
  {"Experimental`Supremum::vdom", 921897, 24376},
  {"Algebra`MatrixPowerMod::arg1", 922487, 24389},
  {"Algebra`MatrixPowerMod::arg2", 922828, 24396},
  {"Algebra`MatrixPowerMod::arg3", 923169, 24403}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 38, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1839, 57, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Limit::ldir"],
Cell[1917, 60, 350, 8, 19, "Message",
  CellTags->"Limit::ldir"],
Cell[2270, 70, 477, 15, 57, "Notes",
  CellTags->"Limit::ldir"],

Cell[CellGroupData[{
Cell[2772, 89, 61, 1, 38, "ExampleSection",
  CellTags->"Limit::ldir"],
Cell[2836, 92, 218, 9, 23, "Text",
  CellTags->"Limit::ldir"],

Cell[CellGroupData[{
Cell[3079, 105, 125, 3, 26, "Input",
  CellTags->"Limit::ldir"],
Cell[3207, 110, 208, 5, 19, "Message",
  CellTags->"Limit::ldir"],
Cell[3418, 117, 137, 3, 40, "Output",
  CellTags->"Limit::ldir"]
}, Open  ]],
Cell[3570, 123, 157, 4, 23, "Text",
  CellTags->"Limit::ldir"],

Cell[CellGroupData[{
Cell[3752, 131, 118, 3, 26, "Input",
  CellTags->"Limit::ldir"],
Cell[3873, 136, 101, 3, 25, "Output",
  CellTags->"Limit::ldir"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4035, 146, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Limit::lim"],
Cell[4111, 149, 325, 7, 19, "Message",
  CellTags->"Limit::lim"],
Cell[4439, 158, 598, 14, 78, "Notes",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{
Cell[5062, 176, 60, 1, 38, "ExampleSection",
  CellTags->"Limit::lim"],
Cell[5125, 179, 140, 5, 23, "Text",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{
Cell[5290, 188, 107, 3, 26, "Input",
  CellTags->"Limit::lim"],
Cell[5400, 193, 185, 5, 19, "Message",
  CellTags->"Limit::lim"],
Cell[5588, 200, 185, 5, 19, "Message",
  CellTags->"Limit::lim"],
Cell[5776, 207, 126, 3, 25, "Output",
  CellTags->"Limit::lim"]
}, Open  ]],
Cell[5917, 213, 158, 7, 23, "Text",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{
Cell[6100, 224, 107, 3, 26, "Input",
  CellTags->"Limit::lim"],
Cell[6210, 229, 85, 3, 25, "Output",
  CellTags->"Limit::lim"]
}, Open  ]],
Cell[6310, 235, 81, 1, 22, "Text",
  CellTags->"Limit::lim"],

Cell[CellGroupData[{
Cell[6416, 240, 112, 3, 26, "Input",
  CellTags->"Limit::lim"],
Cell[6531, 245, 167, 4, 19, "Message",
  CellTags->"Limit::lim"],
Cell[6701, 251, 119, 3, 40, "Output",
  CellTags->"Limit::lim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6881, 261, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$MaxRootDegree::npi"],
Cell[6975, 264, 309, 6, 19, "Message",
  CellTags->"$MaxRootDegree::npi"],
Cell[7287, 272, 212, 5, 23, "Notes",
  CellTags->"$MaxRootDegree::npi"],

Cell[CellGroupData[{
Cell[7524, 281, 69, 1, 38, "ExampleSection",
  CellTags->"$MaxRootDegree::npi"],
Cell[7596, 284, 240, 7, 37, "Text",
  CellTags->"$MaxRootDegree::npi"],

Cell[CellGroupData[{
Cell[7861, 295, 110, 3, 26, "Input",
  CellTags->"$MaxRootDegree::npi"],
Cell[7974, 300, 227, 5, 33, "Message",
  CellTags->"$MaxRootDegree::npi"],
Cell[8204, 307, 94, 3, 25, "Output",
  CellTags->"$MaxRootDegree::npi"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8359, 317, 568, 18, 251, "ObjectNameWarningMessages",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],
Cell[8930, 337, 663, 16, 19, "Message",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],
Cell[9596, 355, 505, 10, 37, "Notes",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[CellGroupData[{
Cell[10126, 369, 330, 5, 38, "ExampleSection",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],
Cell[10459, 376, 456, 11, 23, "Text",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],

Cell[CellGroupData[{
Cell[10940, 391, 378, 7, 26, "Input",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],
Cell[11321, 400, 500, 9, 19, "Message",
  CellTags->{
  "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
    "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist", 
    "Reduce::elist", "Roots::elist", "SolveAlways::elist", "Solve::elist", 
    "System`Private`OldReduce::elist", "ToRules::elist"}],
Cell[11824, 411, 391, 7, 25, "Output",
  CellTags->{
  "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
    "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist", 
    "Reduce::elist", "Roots::elist", "SolveAlways::elist", "Solve::elist", 
    "System`Private`OldReduce::elist", "ToRules::elist"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12252, 423, 378, 7, 26, "Input",
  CellTags->{
  "LogicalExpand::elist", "MainSolve::elist", "Roots::elist", 
    "ToRules::elist", "Solve::elist", "Reduce::elist", "Eliminate::elist", 
    "SolveAlways::elist", "AlgebraicRules::elist", "GroebnerBasis::elist", 
    "PolynomialReduce::elist", "System`Private`OldReduce::elist"}],
Cell[12633, 432, 380, 7, 25, "Output",
  CellTags->{
  "AlgebraicRules::elist", "Eliminate::elist", "GroebnerBasis::elist", 
    "LogicalExpand::elist", "MainSolve::elist", "PolynomialReduce::elist", 
    "Reduce::elist", "Roots::elist", "SolveAlways::elist", "Solve::elist", 
    "System`Private`OldReduce::elist", "ToRules::elist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13074, 446, 593, 19, 271, "ObjectNameWarningMessages",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],
Cell[13670, 467, 674, 16, 19, "Message",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],
Cell[14347, 485, 717, 19, 42, "Notes",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[CellGroupData[{
Cell[15089, 508, 344, 5, 38, "ExampleSection",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],
Cell[15436, 515, 368, 5, 22, "Text",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[CellGroupData[{
Cell[15829, 524, 391, 7, 26, "Input",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],
Cell[16223, 533, 480, 10, 21, "Message",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}],
Cell[16706, 545, 480, 10, 21, "Message",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}],
Cell[17189, 557, 398, 8, 27, "Output",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}]
}, Open  ]],
Cell[17602, 568, 404, 8, 22, "Text",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],

Cell[CellGroupData[{
Cell[18031, 580, 396, 7, 26, "Input",
  CellTags->{
  "LogicalExpand::eqf", "MainSolve::eqf", "Roots::eqf", "ToRules::eqf", 
    "Solve::eqf", "Reduce::eqf", "Eliminate::eqf", "SolveAlways::eqf", 
    "AlgebraicRules::eqf", "GroebnerBasis::eqf", "PolynomialReduce::eqf", 
    "Internal`DistributedTermsList::eqf", "System`Private`OldReduce::eqf"}],
Cell[18430, 589, 403, 8, 25, "Output",
  CellTags->{
  "AlgebraicRules::eqf", "Eliminate::eqf", "GroebnerBasis::eqf", 
    "Internal`DistributedTermsList::eqf", "LogicalExpand::eqf", 
    "MainSolve::eqf", "PolynomialReduce::eqf", "Reduce::eqf", "Roots::eqf", 
    "SolveAlways::eqf", "Solve::eqf", "System`Private`OldReduce::eqf", 
    "ToRules::eqf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18894, 604, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Reduce::bdomv"],
Cell[18976, 607, 236, 5, 33, "Message",
  CellTags->"Reduce::bdomv"],
Cell[19215, 614, 124, 4, 22, "Notes",
  CellTags->"Reduce::bdomv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19376, 623, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Reduce::nsmet"],
Cell[19458, 626, 190, 3, 19, "Message",
  CellTags->"Reduce::nsmet"],
Cell[19651, 631, 180, 5, 23, "Notes",
  CellTags->"Reduce::nsmet"],

Cell[CellGroupData[{
Cell[19856, 640, 63, 1, 38, "ExampleSection",
  CellTags->"Reduce::nsmet"],
Cell[19922, 643, 153, 5, 23, "Text",
  CellTags->"Reduce::nsmet"],

Cell[CellGroupData[{
Cell[20100, 652, 118, 3, 26, "Input",
  CellTags->"Reduce::nsmet"],
Cell[20221, 657, 225, 8, 32, "Message",
  CellTags->"Reduce::nsmet"],
Cell[20449, 667, 161, 7, 23, "Output",
  CellTags->"Reduce::nsmet"]
}, Open  ]],
Cell[20625, 677, 138, 4, 23, "Text",
  CellTags->"Reduce::nsmet"],

Cell[CellGroupData[{
Cell[20788, 685, 118, 3, 26, "Input",
  CellTags->"Reduce::nsmet"],
Cell[20909, 690, 117, 6, 23, "Output",
  CellTags->"Reduce::nsmet"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21087, 703, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Root::mdeg"],
Cell[21163, 706, 374, 9, 19, "Message",
  CellTags->"Root::mdeg"],
Cell[21540, 717, 454, 11, 57, "Notes",
  CellTags->"Root::mdeg"],

Cell[CellGroupData[{
Cell[22019, 732, 60, 1, 38, "ExampleSection",
  CellTags->"Root::mdeg"],
Cell[22082, 735, 196, 5, 23, "Text",
  CellTags->"Root::mdeg"],

Cell[CellGroupData[{
Cell[22303, 744, 105, 3, 26, "Input",
  CellTags->"Root::mdeg"],
Cell[22411, 749, 247, 5, 34, "Message",
  CellTags->"Root::mdeg"],
Cell[22661, 756, 107, 3, 27, "Output",
  CellTags->"Root::mdeg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22829, 766, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Root::npoly"],
Cell[22907, 769, 270, 7, 19, "Message",
  CellTags->"Root::npoly"],
Cell[23180, 778, 191, 5, 23, "Notes",
  CellTags->"Root::npoly"],

Cell[CellGroupData[{
Cell[23396, 787, 61, 1, 38, "ExampleSection",
  CellTags->"Root::npoly"],
Cell[23460, 790, 219, 6, 37, "Text",
  CellTags->"Root::npoly"],

Cell[CellGroupData[{
Cell[23704, 800, 104, 3, 26, "Input",
  CellTags->"Root::npoly"],
Cell[23811, 805, 175, 4, 27, "Message",
  CellTags->"Root::npoly"],
Cell[23989, 811, 101, 3, 30, "Output",
  CellTags->"Root::npoly"]
}, Open  ]],
Cell[24105, 817, 143, 5, 23, "Text",
  CellTags->"Root::npoly"],

Cell[CellGroupData[{
Cell[24273, 826, 110, 3, 26, "Input",
  CellTags->"Root::npoly"],
Cell[24386, 831, 100, 3, 25, "Output",
  CellTags->"Root::npoly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24547, 841, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Root::nup"],
Cell[24621, 844, 202, 5, 19, "Message",
  CellTags->"Root::nup"],
Cell[24826, 851, 275, 6, 42, "Notes",
  CellTags->"Root::nup"],

Cell[CellGroupData[{
Cell[25126, 861, 59, 1, 38, "ExampleSection",
  CellTags->"Root::nup"],
Cell[25188, 864, 220, 9, 23, "Text",
  CellTags->"Root::nup"],

Cell[CellGroupData[{
Cell[25433, 877, 102, 3, 26, "Input",
  CellTags->"Root::nup"],
Cell[25538, 882, 176, 4, 21, "Message",
  CellTags->"Root::nup"],
Cell[25717, 888, 104, 3, 27, "Output",
  CellTags->"Root::nup"]
}, Open  ]],
Cell[25836, 894, 142, 4, 22, "Text",
  CellTags->"Root::nup"],

Cell[CellGroupData[{
Cell[26003, 902, 112, 3, 26, "Input",
  CellTags->"Root::nup"],
Cell[26118, 907, 108, 3, 27, "Output",
  CellTags->"Root::nup"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26287, 917, 465, 15, 211, "ObjectNameWarningMessages",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],
Cell[26755, 934, 535, 11, 33, "Message",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],
Cell[27293, 947, 596, 11, 56, "Notes",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],

Cell[CellGroupData[{
Cell[27914, 962, 273, 4, 38, "ExampleSection",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],
Cell[28190, 968, 332, 7, 22, "Text",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],

Cell[CellGroupData[{
Cell[28547, 979, 322, 6, 26, "Input",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],
Cell[28872, 987, 448, 9, 33, "Message",
  CellTags->{
  "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
    "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
    "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
    "System`Private`OldReduce::tdep"}],
Cell[29323, 998, 334, 7, 25, "Output",
  CellTags->{
  "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
    "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
    "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
    "System`Private`OldReduce::tdep"}]
}, Open  ]],
Cell[29672, 1008, 386, 8, 23, "Text",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],

Cell[CellGroupData[{
Cell[30083, 1020, 338, 6, 26, "Input",
  CellTags->{
  "Solve::tdep", "MainSolve::tdep", "Roots::tdep", "Reduce::tdep", 
    "System`Private`OldReduce::tdep", "Eliminate::tdep", "SolveAlways::tdep", 
    "AlgebraicRules::tdep", "GroebnerBasis::tdep", 
    "PolynomialReduce::tdep"}],
Cell[30424, 1028, 333, 7, 25, "Output",
  CellTags->{
  "AlgebraicRules::tdep", "Eliminate::tdep", "GroebnerBasis::tdep", 
    "MainSolve::tdep", "PolynomialReduce::tdep", "Reduce::tdep", 
    "Roots::tdep", "SolveAlways::tdep", "Solve::tdep", 
    "System`Private`OldReduce::tdep"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30818, 1042, 308, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt"}],
Cell[31129, 1052, 402, 10, 19, "Message",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt"}],
Cell[31534, 1064, 467, 13, 38, "Notes",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt"}],

Cell[CellGroupData[{
Cell[32026, 1081, 183, 3, 38, "ExampleSection",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt"}],
Cell[32212, 1086, 478, 15, 38, "Text",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt"}],

Cell[CellGroupData[{
Cell[32715, 1105, 304, 6, 42, "Input",
  CellTags->{
  "GroebnerBasis::varsrt", "PolynomialReduce::varsrt", 
    "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt"}],
Cell[33022, 1113, 332, 7, 19, "Message",
  CellTags->{
  "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}],
Cell[33357, 1122, 220, 5, 27, "Output",
  CellTags->{
  "GroebnerBasis::varsrt", "Internal`DistributedTermsList::varsrt", 
    "Internal`GroebnerWalk::varsrt", "PolynomialReduce::varsrt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33638, 1134, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PolynomialMod::polym"],
Cell[33734, 1137, 244, 6, 19, "Message",
  CellTags->"PolynomialMod::polym"],
Cell[33981, 1145, 225, 5, 23, "Notes",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{
Cell[34231, 1154, 70, 1, 38, "ExampleSection",
  CellTags->"PolynomialMod::polym"],
Cell[34304, 1157, 156, 5, 23, "Text",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{
Cell[34485, 1166, 129, 3, 26, "Input",
  CellTags->"PolynomialMod::polym"],
Cell[34617, 1171, 194, 4, 34, "Message",
  CellTags->"PolynomialMod::polym"],
Cell[34814, 1177, 125, 3, 25, "Output",
  CellTags->"PolynomialMod::polym"]
}, Open  ]],
Cell[34954, 1183, 136, 5, 23, "Text",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{
Cell[35115, 1192, 121, 3, 26, "Input",
  CellTags->"PolynomialMod::polym"],
Cell[35239, 1197, 102, 3, 25, "Output",
  CellTags->"PolynomialMod::polym"]
}, Open  ]],
Cell[35356, 1203, 164, 5, 23, "Text",
  CellTags->"PolynomialMod::polym"],

Cell[CellGroupData[{
Cell[35545, 1212, 133, 3, 26, "Input",
  CellTags->"PolynomialMod::polym"],
Cell[35681, 1217, 105, 3, 25, "Output",
  CellTags->"PolynomialMod::polym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35847, 1227, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Root::sbr"],
Cell[35921, 1230, 467, 11, 33, "Message",
  CellTags->"Root::sbr"],
Cell[36391, 1243, 158, 5, 23, "Notes",
  CellTags->"Root::sbr"],

Cell[CellGroupData[{
Cell[36574, 1252, 59, 1, 38, "ExampleSection",
  CellTags->"Root::sbr"],
Cell[36636, 1255, 197, 5, 36, "Text",
  CellTags->"Root::sbr"],

Cell[CellGroupData[{
Cell[36858, 1264, 128, 3, 26, "Input",
  CellTags->"Root::sbr"],
Cell[36989, 1269, 257, 5, 34, "Message",
  CellTags->"Root::sbr"],
Cell[37249, 1276, 793, 25, 52, "Output",
  CellTags->"Root::sbr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38103, 1308, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"AlgebraicRules::algdat"],
Cell[38203, 1311, 267, 5, 19, "Message",
  CellTags->"AlgebraicRules::algdat"],
Cell[38473, 1318, 944, 26, 108, "Notes",
  CellTags->"AlgebraicRules::algdat"],

Cell[CellGroupData[{
Cell[39442, 1348, 72, 1, 38, "ExampleSection",
  CellTags->"AlgebraicRules::algdat"],
Cell[39517, 1351, 191, 5, 23, "Text",
  CellTags->"AlgebraicRules::algdat"],

Cell[CellGroupData[{
Cell[39733, 1360, 126, 3, 26, "Input",
  CellTags->"AlgebraicRules::algdat"],
Cell[39862, 1365, 266, 5, 33, "Message",
  CellTags->"AlgebraicRules::algdat"],
Cell[40131, 1372, 97, 3, 25, "Output",
  CellTags->"AlgebraicRules::algdat"]
}, Open  ]],
Cell[40243, 1378, 204, 7, 23, "Text",
  CellTags->"AlgebraicRules::algdat"],

Cell[CellGroupData[{
Cell[40472, 1389, 125, 3, 26, "Input",
  CellTags->"AlgebraicRules::algdat"],
Cell[40600, 1394, 97, 3, 25, "Output",
  CellTags->"AlgebraicRules::algdat"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40758, 1404, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"AlgebraicRules::newv"],
Cell[40854, 1407, 349, 10, 19, "Message",
  CellTags->"AlgebraicRules::newv"],
Cell[41206, 1419, 757, 20, 73, "Notes",
  CellTags->"AlgebraicRules::newv"],

Cell[CellGroupData[{
Cell[41988, 1443, 70, 1, 38, "ExampleSection",
  CellTags->"AlgebraicRules::newv"],
Cell[42061, 1446, 248, 6, 37, "Text",
  CellTags->"AlgebraicRules::newv"],

Cell[CellGroupData[{
Cell[42334, 1456, 126, 3, 26, "Input",
  CellTags->"AlgebraicRules::newv"],
Cell[42463, 1461, 202, 4, 19, "Message",
  CellTags->"AlgebraicRules::newv"],
Cell[42668, 1467, 98, 3, 27, "Output",
  CellTags->"AlgebraicRules::newv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42827, 1477, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Solve::incnst"],
Cell[42909, 1480, 338, 7, 33, "Message",
  CellTags->"Solve::incnst"],
Cell[43250, 1489, 238, 6, 37, "Notes",
  CellTags->"Solve::incnst"],

Cell[CellGroupData[{
Cell[43513, 1499, 63, 1, 38, "ExampleSection",
  CellTags->"Solve::incnst"],
Cell[43579, 1502, 155, 4, 22, "Text",
  CellTags->"Solve::incnst"],

Cell[CellGroupData[{
Cell[43759, 1510, 130, 3, 26, "Input",
  CellTags->"Solve::incnst"],
Cell[43892, 1515, 284, 6, 33, "Message",
  CellTags->"Solve::incnst"],
Cell[44179, 1523, 264, 5, 33, "Message",
  CellTags->"Solve::incnst"],
Cell[44446, 1530, 196, 5, 19, "Message",
  CellTags->"Solve::incnst"],
Cell[44645, 1537, 89, 3, 25, "Output",
  CellTags->"Solve::incnst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[44795, 1547, 130, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],
Cell[44928, 1553, 379, 11, 19, "Message",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],
Cell[45310, 1566, 538, 15, 58, "Notes",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[CellGroupData[{
Cell[45873, 1585, 87, 1, 38, "ExampleSection",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],
Cell[45963, 1588, 198, 5, 23, "Text",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[CellGroupData[{
Cell[46186, 1597, 131, 3, 26, "Input",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],
Cell[46320, 1602, 260, 5, 19, "Message",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],
Cell[46583, 1609, 201, 4, 19, "Message",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],
Cell[46787, 1615, 132, 3, 25, "Output",
  CellTags->{"Coefficient::numv", "Exponent::numv"}]
}, Open  ]],
Cell[46934, 1621, 185, 4, 22, "Text",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],

Cell[CellGroupData[{
Cell[47144, 1629, 134, 3, 26, "Input",
  CellTags->{"Coefficient::numv", "Exponent::numv"}],
Cell[47281, 1634, 117, 3, 25, "Output",
  CellTags->{"Coefficient::numv", "Exponent::numv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47459, 1644, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ComplexExpand::exf"],
Cell[47551, 1647, 405, 9, 33, "Message",
  CellTags->"ComplexExpand::exf"],
Cell[47959, 1658, 614, 22, 57, "Notes",
  CellTags->"ComplexExpand::exf"],

Cell[CellGroupData[{
Cell[48598, 1684, 68, 1, 38, "ExampleSection",
  CellTags->"ComplexExpand::exf"],
Cell[48669, 1687, 221, 5, 37, "Text",
  CellTags->"ComplexExpand::exf"],

Cell[CellGroupData[{
Cell[48915, 1696, 152, 4, 26, "Input",
  CellTags->"ComplexExpand::exf"],
Cell[49070, 1702, 288, 6, 33, "Message",
  CellTags->"ComplexExpand::exf"],
Cell[49361, 1710, 117, 3, 25, "Output",
  CellTags->"ComplexExpand::exf"]
}, Open  ]],
Cell[49493, 1716, 147, 5, 23, "Text",
  CellTags->"ComplexExpand::exf"],

Cell[CellGroupData[{
Cell[49665, 1725, 148, 3, 26, "Input",
  CellTags->"ComplexExpand::exf"],
Cell[49816, 1730, 109, 3, 33, "Output",
  CellTags->"ComplexExpand::exf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49986, 1740, 67, 1, 31, "ObjectNameWarningMessages",
  CellTags->"D::dvar"],
Cell[50056, 1743, 237, 5, 33, "Message",
  CellTags->"D::dvar"],
Cell[50296, 1750, 780, 25, 77, "Notes",
  CellTags->"D::dvar"],

Cell[CellGroupData[{
Cell[51101, 1779, 57, 1, 38, "ExampleSection",
  CellTags->"D::dvar"],
Cell[51161, 1782, 188, 5, 36, "Text",
  CellTags->"D::dvar"],

Cell[CellGroupData[{
Cell[51374, 1791, 106, 3, 26, "Input",
  CellTags->"D::dvar"],
Cell[51483, 1796, 248, 5, 33, "Message",
  CellTags->"D::dvar"],
Cell[51734, 1803, 115, 3, 26, "Output",
  CellTags->"D::dvar"]
}, Open  ]],
Cell[51864, 1809, 137, 5, 23, "Text",
  CellTags->"D::dvar"],

Cell[CellGroupData[{
Cell[52026, 1818, 106, 3, 26, "Input",
  CellTags->"D::dvar"],
Cell[52135, 1823, 142, 4, 27, "Output",
  CellTags->"D::dvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52338, 1834, 181, 7, 91, "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
Cell[52522, 1843, 590, 16, 19, "Message",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
Cell[53115, 1861, 945, 26, 98, "Notes",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{
Cell[54085, 1891, 117, 2, 38, "ExampleSection",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
Cell[54205, 1895, 217, 5, 22, "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{
Cell[54447, 1904, 183, 4, 26, "Input",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
Cell[54633, 1910, 483, 8, 33, "Message",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
Cell[55119, 1920, 471, 13, 25, "Output",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]],
Cell[55605, 1936, 199, 6, 23, "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{
Cell[55829, 1946, 188, 4, 26, "Input",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
Cell[56020, 1952, 163, 4, 25, "Output",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]],
Cell[56198, 1959, 197, 5, 22, "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{
Cell[56420, 1968, 170, 4, 26, "Input",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
Cell[56593, 1974, 518, 9, 33, "Message",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}],
Cell[57114, 1985, 366, 10, 25, "Output",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]],
Cell[57495, 1998, 177, 6, 23, "Text",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],

Cell[CellGroupData[{
Cell[57697, 2008, 175, 4, 26, "Input",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "RSolve::deqn", "NRSolve::deqn"}],
Cell[57875, 2014, 166, 4, 25, "Output",
  CellTags->{
  "DSolve::deqn", "NDSolve::deqn", "NRSolve::deqn", "RSolve::deqn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58102, 2025, 118, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::deqx", "NDSolve::deqx"}],
Cell[58223, 2031, 343, 9, 19, "Message",
  CellTags->{"DSolve::deqx", "NDSolve::deqx"}],
Cell[58569, 2042, 282, 8, 37, "Notes",
  CellTags->{"DSolve::deqx", "NDSolve::deqx"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[58888, 2055, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RSolve::deqx"],
Cell[58968, 2058, 194, 4, 19, "Message",
  CellTags->"RSolve::deqx"],
Cell[59165, 2064, 224, 6, 23, "Notes",
  CellTags->"RSolve::deqx"],

Cell[CellGroupData[{
Cell[59414, 2074, 62, 1, 38, "ExampleSection",
  CellTags->"RSolve::deqx"],
Cell[59479, 2077, 240, 6, 37, "Text",
  CellTags->"RSolve::deqx"],

Cell[CellGroupData[{
Cell[59744, 2087, 140, 3, 26, "Input",
  CellTags->"RSolve::deqx"],
Cell[59887, 2092, 205, 5, 19, "Message",
  CellTags->"RSolve::deqx"],
Cell[60095, 2099, 159, 4, 25, "Output",
  CellTags->"RSolve::deqx"]
}, Open  ]],
Cell[60269, 2106, 123, 5, 23, "Text",
  CellTags->"RSolve::deqx"],

Cell[CellGroupData[{
Cell[60417, 2115, 140, 3, 26, "Input",
  CellTags->"RSolve::deqx"],
Cell[60560, 2120, 115, 3, 25, "Output",
  CellTags->"RSolve::deqx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[60736, 2130, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
Cell[60859, 2136, 459, 10, 47, "Message",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
Cell[61321, 2148, 245, 7, 23, "Notes",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[CellGroupData[{
Cell[61591, 2159, 82, 1, 38, "ExampleSection",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
Cell[61676, 2162, 178, 5, 23, "Text",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],

Cell[CellGroupData[{
Cell[61879, 2171, 184, 4, 26, "Input",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
Cell[62066, 2177, 340, 6, 47, "Message",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}],
Cell[62409, 2185, 623, 17, 25, "Output",
  CellTags->{"DSolve::dsmsm", "RSolve::dsmsm"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[63093, 2209, 218, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],
Cell[63314, 2219, 375, 10, 19, "Message",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],
Cell[63692, 2231, 270, 7, 22, "Notes",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[CellGroupData[{
Cell[63987, 2242, 138, 3, 38, "ExampleSection",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],
Cell[64128, 2247, 281, 7, 36, "Text",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[CellGroupData[{
Cell[64434, 2258, 259, 6, 26, "Input",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],
Cell[64696, 2266, 293, 7, 33, "Message",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
    "RSolve::underdet"}],
Cell[64992, 2275, 769, 20, 27, "Output",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
    "RSolve::underdet"}]
}, Open  ]],
Cell[65776, 2298, 234, 7, 23, "Text",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],

Cell[CellGroupData[{
Cell[66035, 2309, 241, 6, 26, "Input",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "RSolve::underdet", 
    "NRSolve::underdet"}],
Cell[66279, 2317, 352, 10, 25, "Output",
  CellTags->{
  "DSolve::underdet", "NDSolve::underdet", "NRSolve::underdet", 
    "RSolve::underdet"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[66692, 2334, 210, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],
Cell[66905, 2344, 370, 10, 19, "Message",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],
Cell[67278, 2356, 240, 6, 22, "Notes",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell[CellGroupData[{
Cell[67543, 2366, 134, 3, 38, "ExampleSection",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],
Cell[67680, 2371, 201, 6, 22, "Text",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],

Cell[CellGroupData[{
Cell[67906, 2381, 228, 6, 26, "Input",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "RSolve::overdet", 
    "NRSolve::overdet"}],
Cell[68137, 2389, 287, 7, 33, "Message",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
    "RSolve::overdet"}],
Cell[68427, 2398, 660, 18, 25, "Output",
  CellTags->{
  "DSolve::overdet", "NDSolve::overdet", "NRSolve::overdet", 
    "RSolve::overdet"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69148, 2423, 189, 7, 91, "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
Cell[69340, 2432, 619, 16, 33, "Message",
  CellTags->{
  "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}],
Cell[69962, 2450, 182, 5, 22, "Notes",
  CellTags->{
  "DSolve::ivar2", "NDSolve::ivar2", "RSolve::ivar2", "NRSolve::ivar2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[70181, 2460, 153, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
Cell[70337, 2467, 411, 11, 19, "Message",
  CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}],
Cell[70751, 2480, 429, 13, 43, "Notes",
  CellTags->{"DSolve::dsfun", "NDSolve::dsfun", "RSolve::dsfun"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[71217, 2498, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
Cell[71342, 2504, 394, 11, 19, "Message",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
Cell[71739, 2517, 560, 14, 63, "Notes",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[CellGroupData[{
Cell[72324, 2535, 83, 1, 38, "ExampleSection",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
Cell[72410, 2538, 154, 4, 22, "Text",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],

Cell[CellGroupData[{
Cell[72589, 2546, 140, 3, 26, "Input",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
Cell[72732, 2551, 195, 4, 19, "Message",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}],
Cell[72930, 2557, 346, 9, 25, "Output",
  CellTags->{"DSolve::dsvar", "NDSolve::dsvar"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[73337, 2573, 126, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
Cell[73466, 2579, 335, 8, 33, "Message",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
Cell[73804, 2589, 254, 5, 36, "Notes",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell[CellGroupData[{
Cell[74083, 2598, 85, 1, 38, "ExampleSection",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
Cell[74171, 2601, 242, 5, 36, "Text",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],

Cell[CellGroupData[{
Cell[74438, 2610, 157, 3, 26, "Input",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
Cell[74598, 2615, 387, 7, 33, "Message",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}],
Cell[74988, 2624, 455, 12, 25, "Output",
  CellTags->{"DSolve::derlen", "NDSolve::derlen"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[75504, 2643, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DSolve::pde"],
Cell[75582, 2646, 267, 5, 33, "Message",
  CellTags->"DSolve::pde"],
Cell[75852, 2653, 506, 13, 58, "Notes",
  CellTags->"DSolve::pde"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76395, 2671, 171, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
Cell[76569, 2678, 450, 11, 33, "Message",
  CellTags->{"DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}],
Cell[77022, 2691, 170, 4, 22, "Notes",
  CellTags->{"DSolve::twoivarg", "NDSolve::twoivarg", "RSolve::twoivarg"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[77229, 2700, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RSolve::rord"],
Cell[77309, 2703, 417, 10, 19, "Message",
  CellTags->"RSolve::rord"],
Cell[77729, 2715, 123, 4, 22, "Notes",
  CellTags->"RSolve::rord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77889, 2724, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RSolve::piarg"],
Cell[77971, 2727, 643, 17, 19, "Message",
  CellTags->"RSolve::piarg"],
Cell[78617, 2746, 124, 4, 22, "Notes",
  CellTags->"RSolve::piarg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78778, 2755, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DSolve::pdord"],
Cell[78860, 2758, 474, 11, 33, "Message",
  CellTags->"DSolve::pdord"],
Cell[79337, 2771, 246, 7, 37, "Notes",
  CellTags->"DSolve::pdord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79620, 2783, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RSolve::pdord"],
Cell[79702, 2786, 470, 11, 33, "Message",
  CellTags->"RSolve::pdord"],
Cell[80175, 2799, 251, 7, 37, "Notes",
  CellTags->"RSolve::pdord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80463, 2811, 153, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
Cell[80619, 2818, 679, 14, 33, "Message",
  CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}],
Cell[81301, 2834, 161, 4, 22, "Notes",
  CellTags->{"DSolve::alliv", "NDSolve::alliv", "RSolve::alliv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[81499, 2843, 189, 7, 91, "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
Cell[81691, 2852, 560, 15, 19, "Message",
  CellTags->{
  "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}],
Cell[82254, 2869, 182, 5, 22, "Notes",
  CellTags->{
  "DSolve::baddv", "NDSolve::baddv", "RSolve::baddv", "NRSolve::baddv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[82473, 2879, 159, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[82635, 2886, 445, 11, 33, "Message",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[83083, 2899, 212, 4, 22, "Notes",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{
Cell[83320, 2907, 103, 1, 38, "ExampleSection",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[83426, 2910, 212, 4, 22, "Text",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{
Cell[83663, 2918, 173, 3, 26, "Input",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[83839, 2923, 531, 9, 33, "Message",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[84373, 2934, 469, 12, 25, "Output",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]
}, Open  ]],
Cell[84857, 2949, 171, 4, 22, "Text",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{
Cell[85053, 2957, 170, 3, 26, "Input",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[85226, 2962, 198, 4, 27, "Output",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]
}, Open  ]],
Cell[85439, 2969, 221, 5, 22, "Text",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],

Cell[CellGroupData[{
Cell[85685, 2978, 371, 7, 58, "Input",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[86059, 2987, 354, 6, 33, "Message",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}],
Cell[86416, 2995, 1108, 28, 43, "Output",
  CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[87585, 3030, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],
Cell[87708, 3036, 445, 11, 33, "Message",
  CellTags->{"DSolve::bvimp", "RSolve::bvimp"}],
Cell[88156, 3049, 143, 4, 22, "Notes",
  CellTags->{"DSolve::bvimp", "RSolve::bvimp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[88336, 3058, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],
Cell[88459, 3064, 425, 11, 33, "Message",
  CellTags->{"DSolve::bvlim", "RSolve::bvlim"}],
Cell[88887, 3077, 143, 4, 22, "Notes",
  CellTags->{"DSolve::bvlim", "RSolve::bvlim"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[89067, 3086, 124, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],
Cell[89194, 3092, 374, 10, 19, "Message",
  CellTags->{"DSolve::bvfail", "RSolve::bvfail"}],
Cell[89571, 3104, 145, 4, 22, "Notes",
  CellTags->{"DSolve::bvfail", "RSolve::bvfail"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[89753, 3113, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
Cell[89876, 3119, 398, 11, 33, "Message",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
Cell[90277, 3132, 185, 4, 22, "Notes",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[CellGroupData[{
Cell[90487, 3140, 82, 1, 38, "ExampleSection",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
Cell[90572, 3143, 418, 9, 52, "Text",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],

Cell[CellGroupData[{
Cell[91015, 3156, 210, 4, 26, "Input",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
Cell[91228, 3162, 254, 5, 33, "Message",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}],
Cell[91485, 3169, 108, 3, 25, "Output",
  CellTags->{"DSolve::bvnul", "RSolve::bvnul"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[91654, 3179, 116, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],
Cell[91773, 3185, 432, 11, 33, "Message",
  CellTags->{"DSolve::bvnr", "RSolve::bvnr"}],
Cell[92208, 3198, 141, 4, 22, "Notes",
  CellTags->{"DSolve::bvnr", "RSolve::bvnr"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[92386, 3207, 159, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
Cell[92548, 3214, 440, 11, 33, "Message",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
Cell[92991, 3227, 443, 8, 57, "Notes",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[CellGroupData[{
Cell[93459, 3239, 103, 1, 38, "ExampleSection",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
Cell[93565, 3242, 315, 6, 36, "Text",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[CellGroupData[{
Cell[93905, 3252, 147, 3, 26, "Input",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
Cell[94055, 3257, 304, 5, 33, "Message",
  CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}],
Cell[94362, 3264, 150, 3, 25, "Output",
  CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}]
}, Open  ]],
Cell[94527, 3270, 209, 6, 23, "Text",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],

Cell[CellGroupData[{
Cell[94761, 3280, 241, 5, 42, "Input",
  CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"}],
Cell[95005, 3287, 145, 3, 25, "Output",
  CellTags->{"Eliminate::ifun", "SolveAlways::ifun", "Solve::ifun"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95211, 3297, 240, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
    "AlgebraicRules::ifun"}],
Cell[95454, 3307, 438, 12, 19, "Message",
  CellTags->{
  "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
    "AlgebraicRules::ifun"}],
Cell[95895, 3321, 490, 10, 57, "Notes",
  CellTags->{
  "Reduce::ifun", "System`Private`OldReduce::ifun", "MainSolve::ifun", 
    "AlgebraicRules::ifun"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[96422, 3336, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Factor::facmm"],
Cell[96504, 3339, 252, 4, 33, "Message",
  CellTags->"Factor::facmm"],
Cell[96759, 3345, 278, 7, 37, "Notes",
  CellTags->"Factor::facmm"],

Cell[CellGroupData[{
Cell[97062, 3356, 63, 1, 38, "ExampleSection",
  CellTags->"Factor::facmm"],
Cell[97128, 3359, 261, 7, 38, "Text",
  CellTags->"Factor::facmm"],

Cell[CellGroupData[{
Cell[97414, 3370, 116, 3, 26, "Input",
  CellTags->"Factor::facmm"],
Cell[97533, 3375, 252, 5, 33, "Message",
  CellTags->"Factor::facmm"],
Cell[97788, 3382, 101, 3, 25, "Output",
  CellTags->"Factor::facmm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[97950, 3392, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Factor::priml"],
Cell[98032, 3395, 238, 5, 19, "Message",
  CellTags->"Factor::priml"],
Cell[98273, 3402, 870, 22, 107, "Notes",
  CellTags->"Factor::priml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99180, 3429, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],
Cell[99319, 3435, 282, 7, 19, "Message",
  CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}],
Cell[99604, 3444, 310, 6, 42, "Notes",
  CellTags->{"Factor::ufac", "FactorSquareFree::ufac"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[99951, 3455, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::mult"],
Cell[100033, 3458, 458, 14, 19, "Message",
  CellTags->"General::mult"],
Cell[100494, 3474, 400, 12, 43, "Notes",
  CellTags->"General::mult"],

Cell[CellGroupData[{
Cell[100919, 3490, 63, 1, 38, "ExampleSection",
  CellTags->"General::mult"],
Cell[100985, 3493, 181, 5, 23, "Text",
  CellTags->"General::mult"],

Cell[CellGroupData[{
Cell[101191, 3502, 123, 3, 26, "Input",
  CellTags->"General::mult"],
Cell[101317, 3507, 200, 5, 19, "Message",
  CellTags->"General::mult"],
Cell[101520, 3514, 136, 3, 27, "Output",
  CellTags->"General::mult"]
}, Open  ]],
Cell[101671, 3520, 179, 7, 23, "Text",
  CellTags->"General::mult"],

Cell[CellGroupData[{
Cell[101875, 3531, 123, 3, 26, "Input",
  CellTags->"General::mult"],
Cell[102001, 3536, 220, 5, 28, "Output",
  CellTags->"General::mult"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[102282, 3548, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::modint"],
Cell[102368, 3551, 351, 10, 19, "Message",
  CellTags->"General::modint"],
Cell[102722, 3563, 204, 5, 23, "Notes",
  CellTags->"General::modint"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102963, 3573, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::modgp"],
Cell[103047, 3576, 516, 15, 19, "Message",
  CellTags->"General::modgp"],
Cell[103566, 3593, 567, 13, 63, "Notes",
  CellTags->"General::modgp"],

Cell[CellGroupData[{
Cell[104158, 3610, 64, 1, 38, "ExampleSection",
  CellTags->"General::modgp"],
Cell[104225, 3613, 193, 5, 23, "Text",
  CellTags->"General::modgp"],

Cell[CellGroupData[{
Cell[104443, 3622, 137, 3, 26, "Input",
  CellTags->"General::modgp"],
Cell[104583, 3627, 218, 5, 19, "Message",
  CellTags->"General::modgp"],
Cell[104804, 3634, 159, 4, 27, "Output",
  CellTags->"General::modgp"]
}, Open  ]],
Cell[104978, 3641, 101, 1, 22, "Text",
  CellTags->"General::modgp"],

Cell[CellGroupData[{
Cell[105104, 3646, 123, 3, 26, "Input",
  CellTags->"General::modgp"],
Cell[105230, 3651, 93, 3, 25, "Output",
  CellTags->"General::modgp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105360, 3659, 130, 3, 26, "Input",
  CellTags->"General::modgp"],
Cell[105493, 3664, 173, 4, 25, "Output",
  CellTags->"General::modgp"]
}, Open  ]],
Cell[105681, 3671, 154, 5, 23, "Text",
  CellTags->"General::modgp"],

Cell[CellGroupData[{
Cell[105860, 3680, 137, 3, 26, "Input",
  CellTags->"General::modgp"],
Cell[106000, 3685, 121, 3, 27, "Output",
  CellTags->"General::modgp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[106182, 3695, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::modm"],
Cell[106264, 3698, 381, 10, 19, "Message",
  CellTags->"General::modm"],
Cell[106648, 3710, 230, 6, 23, "Notes",
  CellTags->"General::modm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[106915, 3721, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::modn"],
Cell[106997, 3724, 485, 15, 19, "Message",
  CellTags->"General::modn"],
Cell[107485, 3741, 176, 5, 23, "Notes",
  CellTags->"General::modn"],

Cell[CellGroupData[{
Cell[107686, 3750, 63, 1, 38, "ExampleSection",
  CellTags->"General::modn"],
Cell[107752, 3753, 233, 7, 23, "Text",
  CellTags->"General::modn"],

Cell[CellGroupData[{
Cell[108010, 3764, 129, 3, 26, "Input",
  CellTags->"General::modn"],
Cell[108142, 3769, 205, 5, 34, "Message",
  CellTags->"General::modn"],
Cell[108350, 3776, 142, 3, 40, "Output",
  CellTags->"General::modn"]
}, Open  ]],
Cell[108507, 3782, 180, 7, 23, "Text",
  CellTags->"General::modn"],

Cell[CellGroupData[{
Cell[108712, 3793, 127, 3, 26, "Input",
  CellTags->"General::modn"],
Cell[108842, 3798, 104, 3, 27, "Output",
  CellTags->"General::modn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[109007, 3808, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::modp"],
Cell[109089, 3811, 521, 15, 19, "Message",
  CellTags->"General::modp"],
Cell[109613, 3828, 180, 5, 23, "Notes",
  CellTags->"General::modp"],

Cell[CellGroupData[{
Cell[109818, 3837, 63, 1, 38, "ExampleSection",
  CellTags->"General::modp"],
Cell[109884, 3840, 190, 5, 23, "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{
Cell[110099, 3849, 133, 3, 26, "Input",
  CellTags->"General::modp"],
Cell[110235, 3854, 214, 5, 34, "Message",
  CellTags->"General::modp"],
Cell[110452, 3861, 138, 3, 40, "Output",
  CellTags->"General::modp"]
}, Open  ]],
Cell[110605, 3867, 170, 7, 23, "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{
Cell[110800, 3878, 131, 3, 26, "Input",
  CellTags->"General::modp"],
Cell[110934, 3883, 108, 3, 42, "Output",
  CellTags->"General::modp"]
}, Open  ]],
Cell[111057, 3889, 234, 7, 23, "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{
Cell[111316, 3900, 135, 3, 26, "Input",
  CellTags->"General::modp"],
Cell[111454, 3905, 213, 5, 19, "Message",
  CellTags->"General::modp"],
Cell[111670, 3912, 141, 3, 40, "Output",
  CellTags->"General::modp"]
}, Open  ]],
Cell[111826, 3918, 142, 5, 23, "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{
Cell[111993, 3927, 97, 3, 26, "Input",
  CellTags->"General::modp"],
Cell[112093, 3932, 92, 3, 25, "Output",
  CellTags->"General::modp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112222, 3940, 97, 3, 26, "Input",
  CellTags->"General::modp"],
Cell[112322, 3945, 91, 3, 25, "Output",
  CellTags->"General::modp"]
}, Open  ]],
Cell[112428, 3951, 177, 7, 23, "Text",
  CellTags->"General::modp"],

Cell[CellGroupData[{
Cell[112630, 3962, 135, 3, 26, "Input",
  CellTags->"General::modp"],
Cell[112768, 3967, 131, 3, 42, "Output",
  CellTags->"General::modp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[112960, 3977, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nalg"],
Cell[113042, 3980, 380, 11, 19, "Message",
  CellTags->"General::nalg"],
Cell[113425, 3993, 627, 13, 91, "Notes",
  CellTags->"General::nalg"],

Cell[CellGroupData[{
Cell[114077, 4010, 63, 1, 38, "ExampleSection",
  CellTags->"General::nalg"],
Cell[114143, 4013, 177, 5, 23, "Text",
  CellTags->"General::nalg"],

Cell[CellGroupData[{
Cell[114345, 4022, 119, 3, 26, "Input",
  CellTags->"General::nalg"],
Cell[114467, 4027, 179, 4, 19, "Message",
  CellTags->"General::nalg"],
Cell[114649, 4033, 126, 3, 27, "Output",
  CellTags->"General::nalg"]
}, Open  ]],
Cell[114790, 4039, 177, 7, 23, "Text",
  CellTags->"General::nalg"],

Cell[CellGroupData[{
Cell[114992, 4050, 123, 3, 26, "Input",
  CellTags->"General::nalg"],
Cell[115118, 4055, 115, 3, 30, "Output",
  CellTags->"General::nalg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[115294, 4065, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nmod"],
Cell[115376, 4068, 401, 13, 19, "Message",
  CellTags->"General::nmod"],
Cell[115780, 4083, 155, 4, 22, "Notes",
  CellTags->"General::nmod"],

Cell[CellGroupData[{
Cell[115960, 4091, 63, 1, 38, "ExampleSection",
  CellTags->"General::nmod"],
Cell[116026, 4094, 156, 4, 22, "Text",
  CellTags->"General::nmod"],

Cell[CellGroupData[{
Cell[116207, 4102, 117, 3, 26, "Input",
  CellTags->"General::nmod"],
Cell[116327, 4107, 178, 4, 32, "Message",
  CellTags->"General::nmod"],
Cell[116508, 4113, 124, 3, 38, "Output",
  CellTags->"General::nmod"]
}, Open  ]],
Cell[116647, 4119, 157, 5, 23, "Text",
  CellTags->"General::nmod"],

Cell[CellGroupData[{
Cell[116829, 4128, 122, 3, 26, "Input",
  CellTags->"General::nmod"],
Cell[116954, 4133, 95, 3, 25, "Output",
  CellTags->"General::nmod"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[117110, 4143, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::npoly"],
Cell[117194, 4146, 425, 12, 19, "Message",
  CellTags->"General::npoly"],
Cell[117622, 4160, 217, 5, 36, "Notes",
  CellTags->"General::npoly"],

Cell[CellGroupData[{
Cell[117864, 4169, 64, 1, 38, "ExampleSection",
  CellTags->"General::npoly"],
Cell[117931, 4172, 155, 4, 22, "Text",
  CellTags->"General::npoly"],

Cell[CellGroupData[{
Cell[118111, 4180, 111, 3, 26, "Input",
  CellTags->"General::npoly"],
Cell[118225, 4185, 190, 5, 21, "Message",
  CellTags->"General::npoly"],
Cell[118418, 4192, 113, 3, 27, "Output",
  CellTags->"General::npoly"]
}, Open  ]],
Cell[118546, 4198, 125, 5, 23, "Text",
  CellTags->"General::npoly"],

Cell[CellGroupData[{
Cell[118696, 4207, 106, 3, 26, "Input",
  CellTags->"General::npoly"],
Cell[118805, 4212, 96, 3, 28, "Output",
  CellTags->"General::npoly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[118962, 4222, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::npolys"],
Cell[119048, 4225, 452, 12, 19, "Message",
  CellTags->"General::npolys"],
Cell[119503, 4239, 346, 7, 56, "Notes",
  CellTags->"General::npolys"],

Cell[CellGroupData[{
Cell[119874, 4250, 65, 1, 38, "ExampleSection",
  CellTags->"General::npolys"],
Cell[119942, 4253, 159, 4, 22, "Text",
  CellTags->"General::npolys"],

Cell[CellGroupData[{
Cell[120126, 4261, 124, 3, 26, "Input",
  CellTags->"General::npolys"],
Cell[120253, 4266, 241, 5, 27, "Message",
  CellTags->"General::npolys"],
Cell[120497, 4273, 126, 3, 30, "Output",
  CellTags->"General::npolys"]
}, Open  ]],
Cell[120638, 4279, 124, 5, 23, "Text",
  CellTags->"General::npolys"],

Cell[CellGroupData[{
Cell[120787, 4288, 122, 3, 26, "Input",
  CellTags->"General::npolys"],
Cell[120912, 4293, 93, 3, 25, "Output",
  CellTags->"General::npolys"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[121066, 4303, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::poly"],
Cell[121148, 4306, 348, 11, 19, "Message",
  CellTags->"General::poly"],
Cell[121499, 4319, 148, 4, 22, "Notes",
  CellTags->"General::poly"],

Cell[CellGroupData[{
Cell[121672, 4327, 63, 1, 38, "ExampleSection",
  CellTags->"General::poly"],
Cell[121738, 4330, 252, 6, 37, "Text",
  CellTags->"General::poly"],

Cell[CellGroupData[{
Cell[122015, 4340, 127, 3, 26, "Input",
  CellTags->"General::poly"],
Cell[122145, 4345, 178, 4, 19, "Message",
  CellTags->"General::poly"],
Cell[122326, 4351, 128, 3, 25, "Output",
  CellTags->"General::poly"]
}, Open  ]],
Cell[122469, 4357, 138, 5, 23, "Text",
  CellTags->"General::poly"],

Cell[CellGroupData[{
Cell[122632, 4366, 132, 3, 26, "Input",
  CellTags->"General::poly"],
Cell[122767, 4371, 88, 3, 25, "Output",
  CellTags->"General::poly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[122916, 4381, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::polyx"],
Cell[123000, 4384, 398, 11, 19, "Message",
  CellTags->"Gen