(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    131930,       5233]*)
(*NotebookOutlinePosition[    190276,       6721]*)
(*  CellTagsIndexPosition[    187423,       6638]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Argument Checking", "Title"],

Cell[CellGroupData[{

Cell["General::argf", "ObjectNameWarningMessages",
  CellTags->"General::argf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argf\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", 
          StyleBox["n",
            "TI"], " ", "arguments"}]}], ";", " ", 
      RowBox[{
        StyleBox["nmax",
          "TI"], " ", "or", " ", "fewer", " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argf"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with more than the expected number of arguments.\
\>", "Notes",
  CellTags->"General::argf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argb", "ObjectNameWarningMessages",
  CellTags->"General::argb"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argb\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", 
          StyleBox["n",
            "TI"], " ", "arguments"}]}], ";", " ", 
      RowBox[{"between", " ", 
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["1",
              "MR"]}]], " ", "and", " ", 
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["2",
              "MR"]}]], " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argb"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is \
called with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argb"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Position", "MR"],
  " expects between two and four arguments."
}], "Text",
  CellTags->"General::argb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Position[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argb"],

Cell[BoxData[
    \(Position::"argb" \(\(:\)\(\ \)\) 
      "\!\(Position\) called with \!\(0\) arguments; between \!\(2\) and \
\!\(4\) arguments are expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argb"],

Cell[BoxData[
    \(Position[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argb"]
}, Open  ]],

Cell[TextData[{
  "This example shows valid arguments in ",
  StyleBox["Position", "MR"],
  "."
}], "Text",
  CellTags->"General::argb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Position[{3, 7, 4}, 4]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argb"],

Cell[BoxData[
    \({{3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argbu", "ObjectNameWarningMessages",
  CellTags->"General::argbu"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argbu\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", "1", " ", "argument"}]}], 
      ";", " ", 
      RowBox[{"between", " ", 
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["1",
              "MR"]}]], " ", "and", " ", 
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["2",
              "MR"]}]], " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argbu"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is \
called with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argbu"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argbu"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Position", "MR"],
  " requires at least two arguments."
}], "Text",
  CellTags->"General::argbu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Position[{2, 1, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argbu"],

Cell[BoxData[
    \(Position::"argbu" \(\(:\)\(\ \)\) 
      "\!\(Position\) called with 1 argument; between \!\(2\) and \!\(4\) \
arguments are expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argbu"],

Cell[BoxData[
    \(Position[{2, 1, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argbu"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Position", "MR"],
  "."
}], "Text",
  CellTags->"General::argbu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Position[{2, 1, 3}, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argbu"],

Cell[BoxData[
    \({{1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argbu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argct", "ObjectNameWarningMessages",
  CellTags->"General::argct"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"argct\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "called", " ", "with", " ", 
        StyleBox["n",
          "TI"], " ", \(\(arguments\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argct"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argct"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argct"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["ComplexExpand", "MR"],
  " requires at least one argument."
}], "Text",
  CellTags->"General::argct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComplexExpand[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argct"],

Cell[BoxData[
    \(General::"argct" \(\(:\)\(\ \)\) 
      "\!\(ComplexExpand\) called with \!\(0\) arguments."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argct"],

Cell[BoxData[
    \(ComplexExpand[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argct"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["ComplexExpand", "MR"],
  "."
}], "Text",
  CellTags->"General::argct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComplexExpand[Exp[I\ x]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argct"],

Cell[BoxData[
    \(Cos[x] + \[ImaginaryI]\ Sin[x]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argct"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argctu", "ObjectNameWarningMessages",
  CellTags->"General::argctu"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"argctu\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "called", " ", "with", " ", "1", 
        " ", \(\(argument\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argctu"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argctu"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argctu"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Which", "MR"],
  " expects an even number of arguments."
}], "Text",
  CellTags->"General::argctu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Which[E > 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argctu"],

Cell[BoxData[
    \(Which::"argctu" \(\(:\)\(\ \)\) 
      "\!\(Which\) called with 1 argument."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argctu"],

Cell[BoxData[
    \(Which[\[ExponentialE] > 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argctu"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Which", "MR"],
  "."
}], "Text",
  CellTags->"General::argctu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Which[E > 3, 0, E < 3, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argctu"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argctu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argm", "ObjectNameWarningMessages",
  CellTags->"General::argm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argm\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", 
          StyleBox["n",
            "TI"], " ", "arguments"}]}], ";", " ", 
      RowBox[{
        StyleBox["nmin",
          "TI"], " ", "or", " ", "more", " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argm"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is \
used with fewer than the expected number of arguments.\
\>", "Notes",
  CellTags->"General::argm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argm"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["LCM", "MR"],
  " expects at least one argument."
}], "Text",
  CellTags->"General::argm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LCM[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argm"],

Cell[BoxData[
    \(LCM::"argm" \(\(:\)\(\ \)\) 
      "\!\(LCM\) called with \!\(0\) arguments; \!\(1\) or more arguments are \
expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argm"],

Cell[BoxData[
    \(LCM[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argm"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["LCM", "MR"],
  "."
}], "Text",
  CellTags->"General::argm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LCM[6, 8]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argm"],

Cell[BoxData[
    \(24\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argmu", "ObjectNameWarningMessages",
  CellTags->"General::argmu"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argmu\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", "1", " ", "argument"}]}], 
      ";", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], " ", "or", " ", "more", " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argmu"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with fewer that the expected number of arguments.\
\>", "Notes",
  CellTags->"General::argmu"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argmu"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["NIntegrate", "MR"],
  " expects at least two arguments."
}], "Text",
  CellTags->"General::argmu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argmu"],

Cell[BoxData[
    \(NIntegrate::"argmu" \(\(:\)\(\ \)\) 
      "\!\(NIntegrate\) called with 1 argument; \!\(2\) or more arguments are \
expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argmu"],

Cell[BoxData[
    \(NIntegrate[Sin[x]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argmu"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::argmu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, Pi}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argmu"],

Cell[BoxData[
    \(2.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argmu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argr", "ObjectNameWarningMessages",
  CellTags->"General::argr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argr\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", "1", " ", "argument"}]}], 
      ";", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argr"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argr"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["SeriesCoefficient", "MR"],
  " requires two arguments."
}], "Text",
  CellTags->"General::argr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesCoefficient[3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argr"],

Cell[BoxData[
    \(SeriesCoefficient::"argr" \(\(:\)\(\ \)\) 
      "\!\(SeriesCoefficient[3]\) called with 1 argument; \!\(2\) arguments \
are expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argr"],

Cell[BoxData[
    \(SeriesCoefficient[3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argr"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SeriesCoefficient", "MR"],
  "."
}], "Text",
  CellTags->"General::argr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesCoefficient[Series[Exp[1 + x], {x, 0, 5}], 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argr"],

Cell[BoxData[
    \(\[ExponentialE]\/6\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argrx", "ObjectNameWarningMessages",
  CellTags->"General::argrx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argrx\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", 
          StyleBox[
            RowBox[{
              StyleBox["n",
                "TI"], 
              StyleBox["1",
                "MR"]}]], " ", "arguments"}]}], ";", " ", 
      RowBox[{
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["2",
              "MR"]}]], " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argrx"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argrx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argrx"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["SeriesCoefficient", "MR"],
  " expects two arguments."
}], "Text",
  CellTags->"General::argrx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesCoefficient[s, 3, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argrx"],

Cell[BoxData[
    \(SeriesCoefficient::"argrx" \(\(:\)\(\ \)\) 
      "\!\(SeriesCoefficient[\(\(s, 3, 5\)\)]\) called with \!\(3\) \
arguments; \!\(2\) arguments are expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argrx"],

Cell[BoxData[
    \(SeriesCoefficient[s, 3, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argrx"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SeriesCoefficient", "MR"],
  "."
}], "Text",
  CellTags->"General::argrx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeriesCoefficient[Series[Log[1 + x], {x, 0, 5}], 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argrx"],

Cell[BoxData[
    \(1\/3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argrx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argt", "ObjectNameWarningMessages",
  CellTags->"General::argt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argt\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", 
          StyleBox["n",
            "TI"], " ", "arguments"}]}], ";", " ", 
      RowBox[{
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["1",
              "MR"]}]], " ", "or", " ", 
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["2",
              "MR"]}]], " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argt"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argt"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Extract", "MR"],
  " requires two or three arguments."
}], "Text",
  CellTags->"General::argt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extract[{4, 1, 7, 9, 5}, {1}, {2}, {\(-1\)}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argt"],

Cell[BoxData[
    \(Extract::"argt" \(\(:\)\(\ \)\) 
      "\!\(Extract\) called with \!\(4\) arguments; \!\(2\) or \!\(3\) \
arguments are expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argt"],

Cell[BoxData[
    \(Extract[{4, 1, 7, 9, 5}, {1}, {2}, {\(-1\)}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argt"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Extract", "MR"],
  "."
}], "Text",
  CellTags->"General::argt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extract[{4, 1, 7, 9, 5}, {{1}, {2}, {\(-1\)}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argt"],

Cell[BoxData[
    \({4, 1, 5}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argtu", "ObjectNameWarningMessages",
  CellTags->"General::argtu"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"argtu\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "called", " ", "with", " ", "1", " ", "argument"}]}], 
      ";", " ", 
      RowBox[{
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["1",
              "MR"]}]], " ", "or", " ", 
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], 
            StyleBox["2",
              "MR"]}]], " ", "arguments", " ", "are", 
        " ", \(\(expected\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argtu"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is used \
with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argtu"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argtu"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Extract", "MR"],
  " requires two or three arguments."
}], "Text",
  CellTags->"General::argtu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extract[{5, 7, 1, 2, 8}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argtu"],

Cell[BoxData[
    \(Extract::"argtu" \(\(:\)\(\ \)\) 
      "\!\(Extract\) called with 1 argument; \!\(2\) or \!\(3\) arguments are \
expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argtu"],

Cell[BoxData[
    \(Extract[{5, 7, 1, 2, 8}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argtu"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Extract", "MR"],
  "."
}], "Text",
  CellTags->"General::argtu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extract[{5, 7, 1, 2, 8}, {{1}, {\(-1\)}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::argtu"],

Cell[BoxData[
    \({5, 8}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::argtu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::argx", "ObjectNameWarningMessages",
  CellTags->"General::argx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", 
        RowBox[{"\<\"argx\"\>", ":", " ", 
          RowBox[{
            StyleBox["function",
              "TI"], " ", "called", " ", "with", " ", 
            StyleBox["n",
              "TI"], " ", "arguments"}]}]}], ";", 
      " ", \(1\ argument\ is\ \(\(expected\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::argx"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function is \
called with an incorrect number of arguments.\
\>", "Notes",
  CellTags->"General::argx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::argx"],

Cell[TextData[{
  "Calling the ",
  StyleBox["Cos", "MR"],
  " function with no arguments will generate a warning message."
}], "Text",
  CellTags->"General::argx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cos[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::argx"],

Cell[BoxData[
    \(Cos::"argx" \(\(:\)\(\ \)\) 
      "\!\(Cos\) called with \!\(0\) arguments; 1 argument is expected."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::argx"],

Cell[BoxData[
    \(Cos[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::argx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bool", "ObjectNameWarningMessages",
  CellTags->"General::bool"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"bool\"\>"}], \(\(:\)\(\ \)\), "True", " ", "or", 
      " ", "False", " ", "expected", " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bool"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Notes",
  CellTags->"General::bool"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bool"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["LinkWrite", "MR"],
  " is expected to be ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->"General::bool"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinkWrite[$ParentLink, Null, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bool"],

Cell[BoxData[
    \(LinkWrite::"bool" \(\(:\)\(\ \)\) 
      "True or False expected at position \!\(3\) in \
\!\(LinkWrite[\(\(\(\(LinkObject[\(\(\"ParentLink\", 1, 1\)\)]\)\), Null, 0\)\
\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bool"],

Cell[BoxData[
    \(LinkWrite[LinkObject["ParentLink", 1, 1], Null, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::bool"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::fnsym", "ObjectNameWarningMessages",
  CellTags->"General::fnsym"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fnsym\"\>"}], \(\(:\)\(\ \)\), "First", " ", 
      "argument", " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "symbol", " ", "or", " ",
       "a", " ", "string", " ", "naming", " ", "a", 
      " ", \(\(symbol\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::fnsym"],

Cell["\<\
\[FilledSmallSquare] Generated when the first argument in the \
indicated expression is expected to be a symbol.\
\>", "Notes",
  CellTags->"General::fnsym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::fnsym"],

Cell[TextData[{
  "An error occurs in this example because assignments to ",
  StyleBox["Default", "MR"],
  " only apply if the argument is a symbol."
}], "Text",
  CellTags->"General::fnsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Default[f[]] = 1\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::fnsym"],

Cell[BoxData[
    \(Default::"fnsym" \(\(:\)\(\ \)\) 
      "First argument in \!\(Default[\(\(f[]\)\)]\) is not a symbol or a \
string naming a symbol."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::fnsym"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::fnsym"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid assignment for ",
  StyleBox["Default", "MR"],
  "."
}], "Text",
  CellTags->"General::fnsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{f}, Default[f] = 1; f[] /. f[p_. ] -> p]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::fnsym"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::fnsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::heads", "ObjectNameWarningMessages",
  CellTags->"General::heads"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"heads\"\>"}], \(\(:\)\(\ \)\), "Heads", " ", 
      StyleBox["h1",
        "TI"], " ", "and", " ", 
      StyleBox["h2",
        "TI"], " ", "at", " ", "positions", " ", 
      StyleBox[
        RowBox[{
          StyleBox["n",
            "TI"], 
          StyleBox["1",
            "MR"]}]], " ", "and", " ", 
      StyleBox[
        RowBox[{
          StyleBox["n",
            "TI"], 
          StyleBox["2",
            "MR"]}]], " ", "are", " ", "expected", " ", "to", " ", "be", " ", 
      "the", " ", \(\(same\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::heads"],

Cell["\<\
\[FilledSmallSquare] Generated when the heads of the indicated \
function arguments are expected to be the same.\
\>", "Notes",
  CellTags->"General::heads"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::heads"],

Cell[TextData[{
  "An error occurs in this example because all of the arguments in ",
  StyleBox["Union", "MR"],
  " are required to have the same head."
}], "Text",
  CellTags->"General::heads"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[{f[1], f[2], f[1], f[3]}, f[4]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::heads"],

Cell[BoxData[
    \(Union::"heads" \(\(:\)\(\ \)\) 
      "Heads \!\(f\) and \!\(List\) at positions \!\(2\) and \!\(1\) are \
expected to be the same."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::heads"],

Cell[BoxData[
    \({f[1], f[2], f[1], f[3]} \[Union] f[4]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::heads"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Union", "MR"],
  "."
}], "Text",
  CellTags->"General::heads"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[{f[1], f[2], f[1], f[3]}, {f[4]}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::heads"],

Cell[BoxData[
    \({f[1], f[2], f[3], f[4]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::heads"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ilsm", "ObjectNameWarningMessages",
  CellTags->"General::ilsm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ilsm\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(List\ of\ machine\), "-", 
        RowBox[{
        "size", " ", "integers", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ilsm"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not a list of machine-size integers.\
\>", "Notes",
  CellTags->"General::ilsm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ilsm"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the second argument in ",
  StyleBox["PadLeft", "MR"],
  "."
}], "Text",
  CellTags->"General::ilsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadLeft[{{1, 2}, {3, 4, 5}}, Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ilsm"],

Cell[BoxData[
    \(PadLeft::"ilsm" \(\(:\)\(\ \)\) 
      "List of machine-size integers expected at position \!\(2\) in \
\!\(PadLeft[\(\(\(\({\(\({1, 2}\)\), \(\({3, 4, 5}\)\)}\)\), \
Automatic\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ilsm"],

Cell[BoxData[
    \(PadLeft[{{1, 2}, {3, 4, 5}}, Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ilsm"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["PadLeft", "MR"],
  "."
}], "Text",
  CellTags->"General::ilsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadLeft[{{1, 2}, {3, 4, 5}}, {3, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ilsm"],

Cell[BoxData[
    \({{0, 0, 0}, {0, 1, 2}, {3, 4, 5}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ilsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ilsmn", "ObjectNameWarningMessages",
  CellTags->"General::ilsmn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ilsmn\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Single\ or\ non\), "-", \(empty\ list\ of\ non\), 
        "-", \(negative\ machine\), "-", 
        RowBox[{
        "size", " ", "integers", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "of", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ilsmn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a list of non-negative machine-size integers.\n\[FilledSmallSquare] \
This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::ilsmn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ipnfm", "ObjectNameWarningMessages",
  CellTags->"General::ipnfm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ipnfm\"\>"}], \(\(:\)\(\ \)\), \(Positive\ machine - 
        size\ integer\ or\ Infinity\ expected\ at\ position\ `2`\ in\ \(\(`1`\
\)\(.\)\)\)}]], "Message",
  CellTags->"General::ipnfm"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
does not have the specified form.\
\>", "Notes",
  CellTags->"General::ipnfm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ipnfm"],

Cell[TextData[{
  "An error occurs in this example because the arguments after the first \
argument in ",
  StyleBox["Outer", "MR"],
  " are expected to be positive integers or normal expressions."
}], "Text",
  CellTags->"General::ipnfm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[List, {{1, 2}}, {8, 9}, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ipnfm"],

Cell[BoxData[
    \(Outer::"ipnfm" \(\(:\)\(\ \)\) 
      "Positive machine-size integer or Infinity expected at position \!\(4\) \
in \!\(Outer[\(\(List, \(\({\({1, 2}\)}\)\), \(\({8, 9}\)\), 0\)\)]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ipnfm"],

Cell[BoxData[
    \(Outer[List, {{1, 2}}, {8, 9}, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ipnfm"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Outer", "MR"],
  "."
}], "Text",
  CellTags->"General::ipnfm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[List, {{1, 2}}, {8, 9}, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ipnfm"],

Cell[BoxData[
    \({{{{1, 2}, 8}, {{1, 2}, 9}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ipnfm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ilsmp", "ObjectNameWarningMessages",
  CellTags->"General::ilsmp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ilsmp\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Single\ or\ non\), 
        "-", \(empty\ list\ of\ positive\ machine\), "-", 
        RowBox[{
        "size", " ", "integers", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "of", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ilsmp"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not a list of positive machine-size integers.\
\>", "Notes",
  CellTags->"General::ilsmp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ilsmp"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Array", "MR"],
  " is expected to be a list of non-negative machine-size integers."
}], "Text",
  CellTags->"General::ilsmp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[{2, \ 3}, \ f]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ilsmp"],

Cell[BoxData[
    \(Array::"ilsmp" \(\(:\)\(\ \)\) 
      "Single or non-empty list of positive machine-size integers expected at \
position \!\(2\) of \!\(Array[\(\(\(\({2, 3}\)\), f\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ilsmp"],

Cell[BoxData[
    \(Array[{2, 3}, f]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ilsmp"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Array", "MR"],
  "."
}], "Text",
  CellTags->"General::ilsmp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[f, {2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ilsmp"],

Cell[BoxData[
    \({{f[1, 1], f[1, 2], f[1, 3]}, {f[2, 1], f[2, 2], f[2, 3]}}\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->"General::ilsmp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::innf", "ObjectNameWarningMessages",
  CellTags->"General::innf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"innf\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{"Non", "-", 
        RowBox[{
        "negative", " ", "integer", " ", "or", " ", "Infinity", " ", 
          "expected", " ", "at", " ", "position", " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::innf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated function argument is not \
a non-negative integer or ",
  StyleBox["Infinity", "MR"],
  "."
}], "Notes",
  CellTags->"General::innf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::innf"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["Select", "MR"],
  " is not an integer."
}], "Text",
  CellTags->"General::innf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[{1, 2, \(-1\), 3, 2, \(-5\)}, 3, Positive]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::innf"],

Cell[BoxData[
    \(Select::"innf" \(\(:\)\(\ \)\) 
      "Non-negative integer or Infinity expected at position \!\(3\) in \
\!\(Select[\(\(\(\({1, 2, \(\(-1\)\), 3, 2, \(\(-5\)\)}\)\), 3, Positive\)\)]\
\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::innf"],

Cell[BoxData[
    \(Select[{1, 2, \(-1\), 3, 2, \(-5\)}, 3, Positive]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::innf"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Select", "MR"],
  "."
}], "Text",
  CellTags->"General::innf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[{1, 2, \(-1\), 3, 2, \(-5\)}, Positive, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::innf"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::innf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::int", "ObjectNameWarningMessages",
  CellTags->"General::int"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"int\"\>"}], \(\(:\)\(\ \)\), "Integer", " ", 
      "expected", " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::int"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not an integer.\
\>", "Notes",
  CellTags->"General::int"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::int"],

Cell["\<\
An error occurs in this example because the argument is not an \
integer.\
\>", "Text",
  CellTags->"General::int"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[27.3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::int"],

Cell[BoxData[
    \(IntegerDigits::"int" \(\(:\)\(\ \)\) 
      "Integer expected at position \!\(1\) in \
\!\(IntegerDigits[27.3`]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::int"],

Cell[BoxData[
    \(IntegerDigits[27.3`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::int"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["RealDigits", "MR"],
  " function can be used to get the digits in an inexact number."
}], "Text",
  CellTags->"General::int"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[27.3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::int"],

Cell[BoxData[
    \({{2, 7, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::int"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::intm", "ObjectNameWarningMessages",
  CellTags->"General::intm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"intm\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{"Machine", "-", 
        RowBox[{
        "size", " ", "integer", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::intm"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not an integer or is outside of the range of integers that can be \
represented using machine integers on your computer.\
\>", "Notes",
  CellTags->"General::intm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::intm"],

Cell[TextData[{
  "An error occurs in this example because the first argument in the ",
  StyleBox["ProductLog", "MR"],
  " function is an inexact number rather than an integer."
}], "Text",
  CellTags->"General::intm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ProductLog[1.7, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::intm"],

Cell[BoxData[
    \(ProductLog::"intm" \(\(:\)\(\ \)\) 
      "Machine-size integer expected at position \!\(1\) in \!\(ProductLog[\(\
\(1.7`, 2\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::intm"],

Cell[BoxData[
    \(ProductLog[1.7`, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::intm"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ProductLog", "MR"],
  "."
}], "Text",
  CellTags->"General::intm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ProductLog[2, 1.7]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::intm"],

Cell[BoxData[
    \(\(-1.865858183908213`\) + 10.82488403447196`\ \[ImaginaryI]\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->"General::intm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::intnm", "ObjectNameWarningMessages",
  CellTags->"General::intnm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"intnm\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{"Non", "-", \(negative\ machine\), "-", 
        RowBox[{
        "size", " ", "integer", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::intnm"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not a non-negative integer or is not in the range of integers that can be \
represented using machine integers on your computer.\
\>", "Notes",
  CellTags->"General::intnm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::intnm"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["FixedPoint", "MR"],
  " is expected to be an integer."
}], "Text",
  CellTags->"General::intnm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPoint[Sin, \ 99, 1.3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::intnm"],

Cell[BoxData[
    \(FixedPoint::"intnm" \(\(:\)\(\ \)\) 
      "Non-negative machine-size integer expected at position \!\(3\) in \
\!\(FixedPoint[\(\(Sin, 99, 1.3`\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::intnm"],

Cell[BoxData[
    \(FixedPoint[Sin, 99, 1.3`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::intnm"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["FixedPoint", "MR"],
  "."
}], "Text",
  CellTags->"General::intnm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPoint[Sin, 1.3, 99]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::intnm"],

Cell[BoxData[
    \(0.17034151831907146`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::intnm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::intnz", "ObjectNameWarningMessages",
  CellTags->"General::intnz"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"intnz\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{"Non", "-", 
        RowBox[{
        "zero", " ", "integer", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::intnz"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not an integer or is zero.\
\>", "Notes",
  CellTags->"General::intnz"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::intnz"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Stack", "MR"],
  " is expected to be a non-zero integer."
}], "Text",
  CellTags->"General::intnz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Print[Stack[_, _]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::intnz"],

Cell[BoxData[
    \(Stack::"intnz" \(\(:\)\(\ \)\) 
      "Non-zero integer expected at position \!\(2\) in \!\(Stack[\(\(_, \
_\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::intnz"],

Cell[BoxData[
    \(Stack[_, _]\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"General::intnz"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Stack", "MR"],
  "."
}], "Text",
  CellTags->"General::intnz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(7 + \((Print[Stack[_, 2]]; 9)\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::intnz"],

Cell[BoxData[
    TagBox[\(Print[Stack[_, 2]]; 9\),
      HoldForm]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"General::intnz"],

Cell[BoxData[
    \(16\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::intnz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::intpm", "ObjectNameWarningMessages",
  CellTags->"General::intpm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"intpm\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Positive\ machine\), "-", 
        RowBox[{
        "size", " ", "integer", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::intpm"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not a positive integer or is too large to be represented using a machine \
integer on your computer.\
\>", "Notes",
  CellTags->"General::intpm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::intpm"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["MemoryConstrained", "MR"],
  " is expected to be a positive integer."
}], "Text",
  CellTags->"General::intpm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryConstrained[Range[1000], 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::intpm"],

Cell[BoxData[
    \(MemoryConstrained::"intpm" \(\(:\)\(\ \)\) 
      "Positive machine-size integer expected at position \!\(2\) in \
\!\(MemoryConstrained[\(\(\(\(Range[1000]\)\), 0\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::intpm"],

Cell[BoxData[
    \(MemoryConstrained[Range[1000], 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::intpm"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["MemoryConstrained", "MR"],
  "."
}], "Text",
  CellTags->"General::intpm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemoryConstrained[Range[1000], 10]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::intpm"],

Cell[BoxData[
    \($Aborted\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::intpm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ioppfa", "ObjectNameWarningMessages",
  CellTags->"General::ioppfa"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ioppfa\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ `1`\  \
-> \ `2`\ should\ be\ a\ positive\ integer, \ Infinity, \ 
      or\ \(\(Automatic\)\(.\)\)\)}]], "Message",
  CellTags->"General::ioppfa"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::ioppfa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::iopf", "ObjectNameWarningMessages",
  CellTags->"General::iopf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"iopf\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "an", " ", "integer", " ", 
        "or", " ", \(\(Infinity\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::iopf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the indicated option does \
not have the expected form.\n\[FilledSmallSquare] This message is not used in \
the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::iopf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::iopnf", "ObjectNameWarningMessages",
  CellTags->"General::iopnf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"iopnf\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["val",
            "TI"], " ", "should", " ", "be", " ", "a", " ", "non"}], 
        "-", \(negative\ integer\ or\ \(\(Infinity\)\(.\)\)\)}]}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::iopnf"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is not an integer or is negative.\
\>", "Notes",
  CellTags->"General::iopnf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::iopnf"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["MaxIterations", "MR"],
  " option is expected to be an integer."
}], "Text",
  CellTags->"General::iopnf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplaceRepeated[{2, 3}, \ p_ -> {p}, \ 
      MaxIterations\  -> \ None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::iopnf"],

Cell[BoxData[
    \(ReplaceRepeated::"iopnf" \(\(:\)\(\ \)\) 
      "Value of option \!\(MaxIterations\) -> \!\(None\) should be a \
non-negative integer or Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::iopnf"],

Cell[BoxData[
    \(ReplaceRepeated[{2, 3}, p_ \[Rule] {p}, 
      MaxIterations \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::iopnf"]
}, Open  ]],

Cell["\<\
A separate warning is generated in this example if the specified \
maximum number of iterations is exceeded.\
\>", "Text",
  CellTags->"General::iopnf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplaceRepeated[{2, 3}, \ p_ -> {p}, \ 
      MaxIterations\  -> \ 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::iopnf"],

Cell[BoxData[
    \(ReplaceRepeated::"rrlim" \(\(:\)\(\ \)\) 
      "Exiting after \!\({2, 3}\) scanned \!\(5\) times."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::iopnf"],

Cell[BoxData[
    \({{{{{{2, 3}}}}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::iopnf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::iopnm", "ObjectNameWarningMessages",
  CellTags->"General::iopnm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"iopnm\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["val",
            "TI"], " ", "should", " ", "be", " ", "a", " ", "non"}], 
        "-", \(negative\ machine\), 
        "-", \(size\ \(\(integer\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::iopnm"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is a negative integer or is too large to be represented as a machine \
integer on your computer.\
\>", "Notes",
  CellTags->"General::iopnm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ioppf", "ObjectNameWarningMessages",
  CellTags->"General::ioppf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"ioppf\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "positive", " ", 
        "integer", " ", "or", " ", \(\(Infinity\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ioppf"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is not an integer or is not positive.\
\>", "Notes",
  CellTags->"General::ioppf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ioppf"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["PageWidth", "MR"],
  " option in ",
  StyleBox["ToString", "MR"],
  " cannot be zero."
}], "Text",
  CellTags->"General::ioppf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToString[Range[25], PageWidth -> 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ioppf"],

Cell[BoxData[
    \(ToString::"ioppf" \(\(:\)\(\ \)\) 
      "Value of option \!\(PageWidth\) -> \!\(0\) should be a positive \
integer or Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ioppf"],

Cell[BoxData[
    \(ToString[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
        18, 19, 20, 21, 22, 23, 24, 25}, PageWidth \[Rule] 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ioppf"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PageWidth", "MR"],
  " option in ",
  StyleBox["ToString", "MR"],
  "."
}], "Text",
  CellTags->"General::ioppf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToString[Range[25], PageWidth -> 35]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ioppf"],

Cell[BoxData[
    \("{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, \n \n  11, 12, 13, 14, 15, 16, 17, 18, \
\n \n  19, 20, 21, 22, 23, 24, 25}"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ioppf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ipnf", "ObjectNameWarningMessages",
  CellTags->"General::ipnf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ipnf\"\>"}], \(\(:\)\(\ \)\), "Positive", " ", 
      "integer", " ", "or", " ", "Infinity", " ", "expected", " ", "at", " ", 
      "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ipnf"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not an integer or is not positive.\
\>", "Notes",
  CellTags->"General::ipnf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::iterb", "ObjectNameWarningMessages",
  CellTags->"General::iterb"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"iterb\"\>"}], \(\(:\)\(\ \)\), "Iterator", " ", 
      StyleBox["expr",
        "TI"], " ", "does", " ", "not", " ", "have", " ", "appropriate", 
      " ", \(\(bounds\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::iterb"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an iterator specification includes an \
invalid lower limit, upper limit, or step size.\n\[FilledSmallSquare] \
Iterators are used in ",
  StyleBox["Do", "MR"],
  ", ",
  StyleBox["Table", "MR"],
  ", ",
  StyleBox["Sum", "MR"],
  ", ",
  StyleBox["Product", "MR"],
  ", and other functions that perform explicit iteration."
}], "Notes",
  CellTags->"General::iterb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::iterb"],

Cell["\<\
An error occurs in this example because the limit does not evaluate \
to a real number.\
\>", "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[k, {k, kmax}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    \(Table::"iterb" \(\(:\)\(\ \)\) 
      "Iterator \!\({k, kmax}\) does not have appropriate bounds."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    \(Table[k, {k, kmax}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::iterb"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid iteration specification in ",
  StyleBox["Table", "MR"],
  "."
}], "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{kmax = 10}, Table[k, {k, kmax}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::iterb"]
}, Open  ]],

Cell["\<\
An error occurs in this example because the iteration bound is not \
a real number and so cannot be reached using the default step size (the \
default step size is 1).\
\>", "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<z = \>", z], {z, 0, 3  I}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    \(Do::"iterb" \(\(:\)\(\ \)\) 
      "Iterator \!\({z, 0, \(\(3\\ \[ImaginaryI]\)\)}\) does not have \
appropriate bounds."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    \(Do[Print["z = ", z], {z, 0, 3\ \[ImaginaryI]}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::iterb"]
}, Open  ]],

Cell["\<\
This shows a valid iteration specification using a complex step \
size.\
\>", "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print["\<z = \>", z], {z, 0, 3  I, I}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    InterpretationBox[\("z = "\[InvisibleSpace]0\),
      SequenceForm[ "z = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[4]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    InterpretationBox[\("z = "\[InvisibleSpace]\[ImaginaryI]\),
      SequenceForm[ "z = ", 
        Complex[ 0, 1]],
      Editable->False]], "Print",
  CellLabel->"From In[4]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    InterpretationBox[\("z = "\[InvisibleSpace]\(2\ \[ImaginaryI]\)\),
      SequenceForm[ "z = ", 
        Complex[ 0, 2]],
      Editable->False]], "Print",
  CellLabel->"From In[4]:=",
  CellTags->"General::iterb"],

Cell[BoxData[
    InterpretationBox[\("z = "\[InvisibleSpace]\(3\ \[ImaginaryI]\)\),
      SequenceForm[ "z = ", 
        Complex[ 0, 3]],
      Editable->False]], "Print",
  CellLabel->"From In[4]:=",
  CellTags->"General::iterb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::itform", "ObjectNameWarningMessages",
  CellTags->"General::itform"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"itform\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["expr",
        "TI"], " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "does", " ", "not", " ", "have", " ", "the", " ", 
      "correct", " ", "form", " ", "for", " ", "an", 
      " ", \(\(iterator\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::itform"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated function argument is not \
a list with 1, 2, 3, or 4 elements.\n\[FilledSmallSquare] This message can be \
generated by iteration functions such as ",
  StyleBox["Do", "MR"],
  ", ",
  StyleBox["Table", "MR"],
  ", ",
  StyleBox["Sum", "MR"],
  ", and ",
  StyleBox["Product", "MR"],
  ".\n\[FilledSmallSquare] An iterator is a list that indicates the iteration \
variable and the iteration limits or the number of iterations if no iteration \
variable is explicitly specified."
}], "Notes",
  CellTags->"General::itform"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::itform"],

Cell[TextData[{
  "An empty list is not a valid iteration specification in ",
  StyleBox["Do", "MR"],
  "."
}], "Text",
  CellTags->"General::itform"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[2 + 2, {}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::itform"],

Cell[BoxData[
    \(Do::"itform" \(\(:\)\(\ \)\) 
      "Argument \!\({}\) at position \!\(2\) does not have the correct form \
for an iterator."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::itform"],

Cell[BoxData[
    \(Do[2 + 2, {}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::itform"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::itraw", "ObjectNameWarningMessages",
  CellTags->"General::itraw"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"itraw\"\>"}], \(\(:\)\(\ \)\), "Raw", " ", 
      "object", " ", 
      StyleBox["expr",
        "TI"], " ", "cannot", " ", "be", " ", "used", " ", "as", " ", "an", 
      " ", \(\(iterator\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::itraw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a number or a string is used as an \
iteration variable.\n\[FilledSmallSquare] Iteration variables are used in \
functions such as ",
  StyleBox["Table", "MR"],
  " and ",
  StyleBox["Sum", "MR"],
  " that do explicit iteration."
}], "Notes",
  CellTags->"General::itraw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::itraw"],

Cell["\<\
An error occurs in this example because a number cannot be used as \
an iterator.\
\>", "Text",
  CellTags->"General::itraw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[k, {5, 10}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::itraw"],

Cell[BoxData[
    \(Table::"itraw" \(\(:\)\(\ \)\) 
      "Raw object \!\(5\) cannot be used as an iterator."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::itraw"],

Cell[BoxData[
    \(Table[k, {5, 10}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::itraw"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid iteration specification in ",
  StyleBox["Table", "MR"],
  "."
}], "Text",
  CellTags->"General::itraw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[k, {k, 5, 10}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::itraw"],

Cell[BoxData[
    \({5, 6, 7, 8, 9, 10}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::itraw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ittag", "ObjectNameWarningMessages",
  CellTags->"General::ittag"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"ittag\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
        "use", " ", 
        StyleBox["expr",
          "TI"], " ", "as", " ", "an", " ", "iterator"}], ",", 
      " ", \(since\ it\ contains\ no\ assignment\ \(\(tag\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ittag"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression with no \
assignment tag is used as an iteration variable.
\[FilledSmallSquare] This error will normally occur only if the iteration \
variable is a special pattern expression.
\[FilledSmallSquare] Most iterative functions work by temporarily assigning \
values to the iteration variable.
\[FilledSmallSquare] An assignment tag is a symbol with which rules \
introduced by assignments are associated.\
\>", "Notes",
  CellTags->"General::ittag"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ittag"],

Cell["\<\
An error occurs in this example because a pattern expression cannot \
be used as an iterator.\
\>", "Text",
  CellTags->"General::ittag"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[x, {x_, 5}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ittag"],

Cell[BoxData[
    \(Table::"ittag" \(\(:\)\(\ \)\) 
      "Cannot use \!\(x_\) as an iterator, since it contains no assignment \
tag."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ittag"],

Cell[BoxData[
    \(Table[x, {x_, 5}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ittag"]
}, Open  ]],

Cell["This shows a valid iteration specification.", "Text",
  CellTags->"General::ittag"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[x, {x, 5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ittag"],

Cell[BoxData[
    \({1, 2, 3, 4, 5}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ittag"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::level", "ObjectNameWarningMessages",
  CellTags->"General::level"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"level\"\>"}], \(\(:\)\(\ \)\), "Level", " ", 
        "specification", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
        " ", "n"}], ",", " ", \({n}\), ",", 
      " ", \(or\ \(\({m, \ n}\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::level"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a level specification does not have \
the expected form.\n\[FilledSmallSquare] A level specification is normally \
expected to be either an integer or a list of one or two integers.\n\
\[FilledSmallSquare] Level specifications are used by ",
  StyleBox["Apply", "MR"],
  ", ",
  StyleBox["Cases", "MR"],
  ", ",
  StyleBox["Count", "MR"],
  ", ",
  StyleBox["DeleteCases", "MR"],
  ", ",
  StyleBox["FreeQ", "MR"],
  ", ",
  StyleBox["Level", "MR"],
  ", ",
  StyleBox["Map", "MR"],
  ", ",
  StyleBox["MapIndexed", "MR"],
  ", ",
  StyleBox["MemberQ", "MR"],
  ", ",
  StyleBox["Pad", "MR"],
  ", ",
  StyleBox["Position", "MR"],
  ", ",
  StyleBox["Scan", "MR"],
  ", ",
  StyleBox["Select", "MR"],
  ", and other functions.\n\[FilledSmallSquare] Level specifications indicate \
the depth within an expression that should be inspected or modified."
}], "Notes",
  CellTags->"General::level"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::level"],

Cell[TextData[{
  "The third element in ",
  StyleBox["MemberQ", "MR"],
  " is a level specification.  The level specification in this example does \
not have a correct form."
}], "Text",
  CellTags->"General::level"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemberQ[{28, 11, 15, {2, \ 7, \ 13}, 11}, 7, {0, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::level"],

Cell[BoxData[
    \(MemberQ::"level" \(\(:\)\(\ \)\) 
      "Level specification \!\({0, 1, 2}\) is not of the form n, {n}, or {m, \
n}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::level"],

Cell[BoxData[
    \(MemberQ[{28, 11, 15, {2, 7, 13}, 11}, 7, {0, 1, 2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::level"]
}, Open  ]],

Cell["\<\
This shows a correct way to specify levels 0, 1, and 2 in an \
expression.\
\>", "Text",
  CellTags->"General::level"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemberQ[{28, 11, 15, {2, \ 7, \ 13}, 11}, 7, {0, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::level"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::level"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::list", "ObjectNameWarningMessages",
  CellTags->"General::list"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"list\"\>"}], \(\(:\)\(\ \)\), "List", " ", 
      "expected", " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::list"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is expected to be a list.\
\>", "Notes",
  CellTags->"General::list"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::list"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["ComposeList", "MR"],
  " is expected to be a list."
}], "Text",
  CellTags->"General::list"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComposeList[0, Table[List, {5}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::list"],

Cell[BoxData[
    \(ComposeList::"list" \(\(:\)\(\ \)\) 
      "List expected at position \!\(1\) in \!\(ComposeList[\(\(0, \(\({List, \
List, List, List, List}\)\)\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::list"],

Cell[BoxData[
    \(ComposeList[0, {List, List, List, List, List}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::list"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ComposeList", "MR"],
  "."
}], "Text",
  CellTags->"General::list"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComposeList[Table[List, {5}], 0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::list"],

Cell[BoxData[
    \({0, {0}, {{0}}, {{{0}}}, {{{{0}}}}, {{{{{0}}}}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::list"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nonopt", "ObjectNameWarningMessages",
  CellTags->"General::nonopt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nonopt\"\>"}], \(\(:\)\(\ \)\), "Options", " ", 
      "expected", " ", 
      RowBox[{"(", 
        RowBox[{"instead", " ", "of", " ", 
          StyleBox["e",
            "TI"]}], ")"}], " ", "beyond", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], ".", " ", "An"}], " ", "option", " ", "must", " ", "be", " ",
       "a", " ", "rule", " ", "or", " ", "a", " ", "list", " ", "of", 
      " ", \(\(rules\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nonopt"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression other than an \
option is encountered in a position where an option is expected.
\[FilledSmallSquare] Most functions that use options expect all of the \
arguments beyond a certain position to be options.
\[FilledSmallSquare] This message usually indicates that a function has been \
called with too many arguments.\
\>", "Notes",
  CellTags->"General::nonopt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nonopt"],

Cell[TextData[{
  "An error occurs in this example because any arguments after the first \
argument in ",
  StyleBox["Factor", "MR"],
  " are expected to be options."
}], "Text",
  CellTags->"General::nonopt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[11 + 5  x, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nonopt"],

Cell[BoxData[
    \(Factor::"nonopt" \(\(:\)\(\ \)\) 
      "Options expected (instead of \!\(x\)) beyond position \!\(1\) in \
\!\(Factor[\(\(\(\(11 + \(\(5\\ x\)\)\)\), x\)\)]\). An option must be a rule \
or a list of rules."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nonopt"],

Cell[BoxData[
    \(Factor[11 + 5\ x, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nonopt"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of arguments and options in ",
  StyleBox["Factor", "MR"],
  "."
}], "Text",
  CellTags->"General::nonopt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[11 + 5  x, Modulus -> 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nonopt"],

Cell[BoxData[
    \(2\ \((1 + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nonopt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::normal", "ObjectNameWarningMessages",
  CellTags->"General::normal"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"normal\"\>"}], \(\(:\)\(\ \)\), "Nonatomic", " ", 
      "expression", " ", "expected", " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::normal"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is an atom rather than a normal expression.
\[FilledSmallSquare] A normal expression is an expression with a head and \
zero or more elements.
\[FilledSmallSquare] Numbers and strings are atoms.  All other expressions \
are normal expressions.\
\>", "Notes",
  CellTags->"General::normal"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::normal"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Reverse", "MR"],
  " is expected to be an expression that has elements to be reversed."
}], "Text",
  CellTags->"General::normal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[123]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::normal"],

Cell[BoxData[
    \(Reverse::"normal" \(\(:\)\(\ \)\) 
      "Nonatomic expression expected at position \!\(1\) in \
\!\(Reverse[123]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::normal"],

Cell[BoxData[
    \(Reverse[123]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::normal"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Reverse", "MR"],
  "."
}], "Text",
  CellTags->"General::normal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[IntegerDigits[123]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::normal"],

Cell[BoxData[
    \({3, 2, 1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::normal"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::notnorm", "ObjectNameWarningMessages",
  CellTags->"General::notnorm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"notnorm\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      
      StyleBox["expr",
        "TI"], " ", "must", " ", "be", " ", "a", " ", "nonatomic", 
      " ", \(\(expression\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::notnorm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be an expression that is not an atom.\n\[FilledSmallSquare] Numbers and \
strings are atoms.  All other expressions are normal expressions.\n\
\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::notnorm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::opstl", "ObjectNameWarningMessages",
  CellTags->"General::opstl"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"opstl\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "string", " ", "or",
         " ", "a", " ", "list", " ", "of", 
        " ", \(\(strings\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::opstl"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is not a string or a list of strings.\
\>", "Notes",
  CellTags->"General::opstl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::opstl"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["RecordSeparators", "MR"],
  " option in ",
  StyleBox["ReadList", "MR"],
  " is a list of numbers rather than a list of strings."
}], "Text",
  CellTags->"General::opstl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s, result}, \n\ts = StringToStream["\<This1is2a3string\>"]; \n\t
      result = ReadList[s, Record, RecordSeparators -> {1, 2, 3}]; \n\t
      Close[s]; \n\tresult\n\t]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::opstl"],

Cell[BoxData[
    \(ReadList::"opstl" \(\(:\)\(\ \)\) 
      "Value of option \!\(RecordSeparators\) -> \!\({1, 2, 3}\) should be a \
string or a list of strings."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::opstl"],

Cell[BoxData[
    \(ReadList[InputStream[String, 632], Record, 
      RecordSeparators \[Rule] {1, 2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::opstl"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["RecordSeparators", "MR"],
  " option in ",
  StyleBox["ReadList", "MR"],
  "."
}], "Text",
  CellTags->"General::opstl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s, result}, \n\ts = StringToStream["\<This1is2a3string\>"]; \n\t
      result = ReadList[s, Record, 
          RecordSeparators -> {"\<1\>", "\<2\>", "\<3\>"}]; \n\tClose[s]; \n\t
      result\n\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::opstl"],

Cell[BoxData[
    \({"This", "is", "a", "string"}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::opstl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::optrs", "ObjectNameWarningMessages",
  CellTags->"General::optrs"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"optrs\"\>"}], \(\(:\)\(\ \)\), "Option", " ", 
      "specification", " ", 
      StyleBox["opt",
        "TI"], " ", "in", " ", 
      StyleBox["val",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "rule", " ", "for", " ", 
      "a", " ", "symbol", " ", "or", " ", \(\(string\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::optrs"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression does \
not have the form of an option.
\[FilledSmallSquare] A valid option is a rule in which the left-hand side is \
a symbol or string.\
\>", "Notes",
  CellTags->"General::optrs"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::optrs"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Factor", "MR"],
  " does not have the correct form to be an option."
}], "Text",
  CellTags->"General::optrs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[2 - x^2, Sqrt[2] -> Extension]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::optrs"],

Cell[BoxData[
    \(Factor::"optrs" \(\(:\)\(\ \)\) 
      "Option specification \!\(\@2 \[Rule] Extension\) in \
\!\(Factor[\(\(\(\(2 - x\^2\)\), \(\(\@2 \[Rule] Extension\)\)\)\)]\) is not \
a rule for a symbol or string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::optrs"],

Cell[BoxData[
    \(Factor[2 - x\^2, \@2 \[Rule] Extension]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::optrs"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid option specification in ",
  StyleBox["Factor", "MR"],
  "."
}], "Text",
  CellTags->"General::optrs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[2 - x^2, Extension -> Sqrt[2]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::optrs"],

Cell[BoxData[
    \(\((\@2 - x)\)\ \((\@2 + x)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::optrs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::opttf", "ObjectNameWarningMessages",
  CellTags->"General::opttf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"opttf\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "True", " ", "or", 
        " ", \(\(False\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::opttf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the indicated option is \
expected to be ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Notes",
  CellTags->"General::opttf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::opttf"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["Compiled", "MR"],
  " option in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::opttf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, Pi}, Compiled -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::opttf"],

Cell[BoxData[
    \(NIntegrate::"opttf" \(\(:\)\(\ \)\) 
      "Value of option \!\(Compiled\) -> \!\(Automatic\) should be True or \
False."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::opttf"],

Cell[BoxData[
    \(2.`\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::opttf"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Compiled", "MR"],
  " option in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::opttf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, Pi}, Compiled -> False]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::opttf"],

Cell[BoxData[
    \(2.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::opttf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::opttfa", "ObjectNameWarningMessages",
  CellTags->"General::opttfa"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], "::", "\<\"opttfa\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
          "of", " ", "option", " ", 
          StyleBox["opt",
            "TI"]}], " ", "->", " ", 
        RowBox[{
          StyleBox["val",
            "TI"], " ", "should", " ", "be", " ", "True"}]}], ",", " ", 
      "False", ",", " ", \(or\ \(\(Automatic\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::opttfa"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is not one of the values specified in the message.\
\>", "Notes",
  CellTags->"General::opttfa"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::opttfa"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["TraceInternal", "MR"],
  " option in ",
  StyleBox["Trace", "MR"],
  "."
}], "Text",
  CellTags->"General::opttfa"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[Fit[{1, 2, 1}, {1, x}, x], TraceInternal -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::opttfa"],

Cell[BoxData[
    \(Trace::"opttfa" \(\(:\)\(\ \)\) 
      "Value of option \!\(TraceInternal\) -> \!\(None\) should be True, \
False, or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::opttfa"],

Cell[BoxData[
    \(Trace[Fit[{1, 2, 1}, {1, x}, x], 
      TraceInternal \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::opttfa"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TraceInternal", "MR"],
  " option in ",
  StyleBox["Trace", "MR"],
  "."
}], "Text",
  CellTags->"General::opttfa"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[Fit[{1, 2, 1}, {1, x}, x], TraceInternal -> True]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::opttfa"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(Fit[{1, 2, 1}, {1, x}, x]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\($MessageList = {}\),
              HoldForm], ",", 
            TagBox[\({}\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox["$MessageList",
              HoldForm], ",", 
            TagBox[\({}\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\($MessageList = {}\),
              HoldForm], ",", 
            TagBox[\({}\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox["$MessageList",
              HoldForm], ",", 
            TagBox[\({}\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\($MessageList = {}\),
              HoldForm], ",", 
            TagBox[\({}\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox["$MessageList",
              HoldForm], ",", 
            TagBox[\({}\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            
            TagBox[\(PseudoInverse[{{0.5773502691896258`, 
                    0.2672612419124244`}, {0.5773502691896258`, 
                    0.5345224838248488`}, {0.5773502691896258`, 
                    0.8017837257372732`}}]\),
              HoldForm], ",", 
            
            TagBox[\({{2.309401076758504`, 
                  0.577350269189627`, \(-1.1547005383792528`\)}, \
{\(-1.8708286933869704`\), \(-1.044251974650318`*^-15\), 
                  1.8708286933869713`}}\),
              HoldForm]}], "}"}], ",", 
        TagBox[\(\(\(1.3333333333333348`\)\(\[InvisibleSpace]\)\) - 
            2.9671958436108745`*^-16\ x\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::opttfa"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::optx", "ObjectNameWarningMessages",
  CellTags->"General::optx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"optx\"\>"}], \(\(:\)\(\ \)\), "Unknown", " ", 
      "option", " ", 
      StyleBox["opt",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::optx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an option passed to a function is not \
one of the known options for that function.\n\[FilledSmallSquare] This error \
can occur if the name of an option is not spelled correctly in input.\n\
\[FilledSmallSquare] The known options for a function ",
  StyleBox["f", "MR",
    FontSlant->"Italic"],
  " can be found by evaluating ",
  StyleBox["Options[", "MR"],
  StyleBox["f", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->"General::optx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::optx"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Tol", "MR"],
  " is not a known option in ",
  StyleBox["SingularValueList", "MR"],
  "."
}], "Text",
  CellTags->"General::optx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SingularValueList[{{1.2, 3.4}, {1.2, 3.5}}, Tol -> 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::optx"],

Cell[BoxData[
    \(SingularValueList::"optx" \(\(:\)\(\ \)\) 
      "Unknown option \!\(Tol\) in \!\(SingularValueList[\(\(\(\({\(\({1.2`, \
3.4`}\)\), \(\({1.2`, 3.5`}\)\)}\)\), \(\(Tol \[Rule] 1\)\)\)\)]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::optx"],

Cell[BoxData[
    \(SingularValueList[{{1.2`, 3.4`}, {1.2`, 3.5`}}, 
      Tol \[Rule] 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::optx"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid option specification in ",
  StyleBox["SingularValues", "MR"],
  "."
}], "Text",
  CellTags->"General::optx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SingularValues[{{1.2, 3.4}, {1.2, 3.5}}, Tolerance -> 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::optx"],

Cell[BoxData[
    \({{{\(-0.6979063603295619`\), \(-0.7161890198903805`\)}}, \
{5.166184323190582`}, {{\(-0.32846572056026346`\), \
\(-0.9445158920933133`\)}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::optx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::par", "ObjectNameWarningMessages",
  CellTags->"General::par"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"par\"\>"}], \(\(:\)\(\ \)\), "Inappropriate", 
        " ", 
        RowBox[{"parameter", ":", " ", 
          StyleBox["opt",
            "TI"]}]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::par"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option does not have the expected form.
\[FilledSmallSquare] The expected form for options can normally be found in \
the documentation for the corresponding function.\
\>", "Notes",
  CellTags->"General::par"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::par"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["NSumTerms", "MR"],
  " option in ",
  StyleBox["NSum", "MR"],
  "."
}], "Text",
  CellTags->"General::par"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[k, {k, 100}, NSumTerms -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::par"],

Cell[BoxData[
    \(NSum::"par" \(\(:\)\(\ \)\) 
      "Inappropriate parameter: \!\(NSumTerms\) -> \!\(Automatic\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::par"],

Cell[BoxData[
    \(NSum[k, {k, 100}, NSumTerms \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::par"]
}, Open  ]],

Cell[TextData[{
  "The value of the ",
  StyleBox["NSumTerms", "MR"],
  " option in ",
  StyleBox["NSum", "MR"],
  " is expected to be a non-negative machine-size real number."
}], "Text",
  CellTags->"General::par"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[k, {k, 100}, NSumTerms -> 10]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::par"],

Cell[BoxData[
    \(5050.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::par"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::string", "ObjectNameWarningMessages",
  CellTags->"General::string"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"string\"\>"}], \(\(:\)\(\ \)\), "String", " ", 
      "expected", " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::string"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is expected to be a string.\
\>", "Notes",
  CellTags->"General::string"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::string"],

Cell["\<\
An error occurs in this example because the first argument is a \
number rather than a string.\
\>", "Text",
  CellTags->"General::string"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringMatchQ[123, "\<*2*\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::string"],

Cell[BoxData[
    \(StringMatchQ::"string" \(\(:\)\(\ \)\) 
      "String expected at position \!\(1\) in \!\(StringMatchQ[\(\(123, \"*2*\
\"\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::string"],

Cell[BoxData[
    \(StringMatchQ[123, "*2*"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::string"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["StringMatchQ", "MR"],
  "."
}], "Text",
  CellTags->"General::string"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringMatchQ["\<123\>", "\<*2*\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::string"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::string"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::strs", "ObjectNameWarningMessages",
  CellTags->"General::strs"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"strs\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(String\ or\ non\), "-", 
        RowBox[{
        "empty", " ", "list", " ", "of", " ", "strings", " ", "expected", " ",
           "at", " ", "position", " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::strs"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
does not have the form specified in the message.\
\>", "Notes",
  CellTags->"General::strs"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::strs"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Find", "MR"],
  " is a number rather than a string or list of strings."
}], "Text",
  CellTags->"General::strs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(strm = StringToStream["\<line 1\nline 2\nline 3\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::strs"],

Cell[BoxData[
    \(InputStream[String, 634]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::strs"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Find[strm, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::strs"],

Cell[BoxData[
    \(Find::"strs" \(\(:\)\(\ \)\) 
      "String or non-empty list of strings expected at position \!\(2\) in \!\
\(Find[\(\(\(\(InputStream[\(\(String, 634\)\)]\)\), 2\)\)]\)."\)], "Message",\

  CellLabel->"From In[2]:=",
  CellTags->"General::strs"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::strs"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Find", "MR"],
  "."
}], "Text",
  CellTags->"General::strs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Find[strm, "\<2\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::strs"],

Cell[BoxData[
    \("line 2"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::strs"]
}, Open  ]],

Cell["Close the stream.", "Text",
  CellTags->"General::strs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[strm]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::strs"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::strs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::strse", "ObjectNameWarningMessages",
  CellTags->"General::strse"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"strse\"\>"}], \(\(:\)\(\ \)\), "String", " ", 
      "or", " ", "list", " ", "of", " ", "strings", " ", "expected", " ", 
      "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::strse"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not a string or a list of strings.\
\>", "Notes",
  CellTags->"General::strse"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::strse"],

Cell["\<\
An error occurs in this example because the arguments are symbols \
rather than strings.\
\>", "Text",
  CellTags->"General::strse"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToFileName[DIR, FILE]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::strse"],

Cell[BoxData[
    \(ToFileName::"strse" \(\(:\)\(\ \)\) 
      "String or list of strings expected at position \!\(1\) in \
\!\(ToFileName[\(\(DIR, FILE\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::strse"],

Cell[BoxData[
    \(ToFileName[DIR, FILE]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::strse"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ToFileName", "MR"],
  ".  (The result will be different on different types of computers.)"
}], "Text",
  CellTags->"General::strse"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToFileName["\<DIR\>", "\<FILE\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::strse"],

Cell[BoxData[
    \("DIR/FILE"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::strse"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sym", "ObjectNameWarningMessages",
  CellTags->"General::sym"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"sym\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["expr",
        "TI"], " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "is", " ", "expected", " ", "to", " ", "be", " ", "a", 
      " ", \(\(symbol\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sym"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is not a symbol.\
\>", "Notes",
  CellTags->"General::sym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sym"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["SymbolName", "MR"],
  " is a normal expression rather than a symbol."
}], "Text",
  CellTags->"General::sym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SymbolName[Cos[1]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sym"],

Cell[BoxData[
    \(SymbolName::"sym" \(\(:\)\(\ \)\) 
      "Argument \!\(Cos[1]\) at position \!\(1\) is expected to be a symbol."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sym"],

Cell[BoxData[
    \(SymbolName[Cos[1]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sym"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["SymbolName", "MR"],
  "."
}], "Text",
  CellTags->"General::sym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SymbolName[Cos]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sym"],

Cell[BoxData[
    \("Cos"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::sym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::seqs", "ObjectNameWarningMessages",
  CellTags->"General::seqs"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"seqs\"\>"}], \(\(:\)\(\ \)\), "Sequence", " ", 
      "specification", 
      " ", \((\(+n\), \ \(-n\), \ {\(+n\)}, \ {\(-n\)}, \ {m, \ n}, \ 
        or\ {m, \ n, \ s})\), " ", "expected", " ", "at", " ", "position", 
      " ", 
      StyleBox["pos",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::seqs"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated function argument does \
not have the correct form to be a sequence specification.\n\
\[FilledSmallSquare] Sequence specifications are used in ",
  StyleBox["Drop", "MR"],
  " and ",
  StyleBox["Take", "MR"],
  " to indicate sequences of subexpressions, and in ",
  StyleBox["StringDrop", "MR"],
  " and ",
  StyleBox["StringTake", "MR"],
  " to indicate sequences of characters."
}], "Notes",
  CellTags->"General::seqs"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::seqs"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["{i,1,2}", "MR"],
  " is not a valid sequence specification."
}], "Text",
  CellTags->"General::seqs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[{11, 12, 13, 14, 15, 16}, {i, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::seqs"],

Cell[BoxData[
    \(Drop::"seqs" \(\(:\)\(\ \)\) 
      "Sequence specification (+n, -n, {+n}, {-n}, {m, n}, or {m, n, s}) \
expected at position \!\(2\) in \!\(Drop[\(\(\(\({11, 12, 13, 14, 15, \
16}\)\), \(\({i, 1, 2}\)\)\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::seqs"],

Cell[BoxData[
    \(Drop[{11, 12, 13, 14, 15, 16}, {i, 1, 2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::seqs"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid sequence specification in ",
  StyleBox["Drop", "MR"],
  "."
}], "Text",
  CellTags->"General::seqs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[{11, 12, 13, 14, 15, 16}, {1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::seqs"],

Cell[BoxData[
    \({13, 14, 15, 16}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::seqs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ilsmi", "ObjectNameWarningMessages",
  CellTags->"General::ilsmi"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ilsmi\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Single\ or\ non\), "-", \(empty\ list\ of\ machine\), "-", 
        RowBox[{
        "size", " ", "integers", " ", "expected", " ", "at", " ", "position", 
          " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ilsmi"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::ilsmi"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::itflrw", "ObjectNameWarningMessages",
  CellTags->"General::itflrw"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"itflrw\"\>"}], \(\(:\)\(\ \)\), 
        RowBox[{"Warning", ":", " ", 
          RowBox[{"In", " ", "evaluating", " ", 
            StyleBox["expr",
              "TI"], " ", "to", " ", "find", " ", "the", " ", "number", " ", 
            "of", " ", "iterations", " ", "to", " ", "use", " ", "for", " ", 
            StyleBox["f",
              "TI"]}]}]}], ",", " ", 
      RowBox[{"$MaxExtraPrecision", " ", "=", " ", 
        RowBox[{
          StyleBox["max",
            "TI"], " ", "was", " ", \(encountered . \ An\), " ", "upper", " ",
           "estimate", " ", "will", " ", "be", " ", "used", " ", "for", " ", 
          "the", " ", "number", " ", "of", 
          " ", \(\(iterations\)\(.\)\)}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::itflrw"],

Cell["\<\
\[FilledSmallSquare] Generated by numerical difficulties while \
computing the number of iterations to use in the indicated iterative \
operation.\
\>", "Notes",
  CellTags->"General::itflrw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::itflrw"],

Cell[TextData[{
  "A warning message is generated in this example because it is not possible, \
using the indicated value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  ", to unambiguously determine the number of iterations."
}], "Text",
  CellTags->"General::itflrw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[0, Pi - 1*^-100, Degree] // Length\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::itflrw"],

Cell[BoxData[
    \(Range::"itflrw" \(\(:\)\(\ \)\) 
      "Warning: In evaluating \!\(Floor[\(\(1 + \(\(\(-\(\(1\/\(100 \(\(\
\[LeftSkeleton] 94 \[RightSkeleton]\)\) 0000\)\)\)\)\) + \[Pi]\)\/\[Degree]\)\
\)]\) to find the number of iterations to use for \!\(Range\), \
$MaxExtraPrecision = \!\(50.`\) was encountered. An upper estimate will be \
used for the number of iterations."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::itflrw"],

Cell[BoxData[
    \(181\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::itflrw"]
}, Open  ]],

Cell[TextData[{
  "The warning in this example can be avoided by increasing the value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  "."
}], "Text",
  CellTags->"General::itflrw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxExtraPrecision = 1000}, 
      Range[0, Pi - 1*^-100, Degree] // Length]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::itflrw"],

Cell[BoxData[
    \(180\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::itflrw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::mbrpos", "ObjectNameWarningMessages",
  CellTags->"General::mbrpos"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"mbrpos\"\>"}], \(\(:\)\(\ \)\), "Position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "must", " ", "be", " ", "one", " ", "of", " ", 
      RowBox[{
        StyleBox["typelist",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::mbrpos"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression does \
not have one of the expected forms.
\[FilledSmallSquare] The expected forms are listed in the message.\
\>", \
"Notes",
  CellTags->"General::mbrpos"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::mbrpos"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Developer`PackedArrayQ", "MR"],
  " is expected to match one of the supported array types."
}], "Text",
  CellTags->"General::mbrpos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`PackedArrayQ[Range[5], All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::mbrpos"],

Cell[BoxData[
    \(Developer`PackedArrayQ::"mbrpos" \(\(:\)\(\ \)\) 
      "Position \!\(2\) in \!\(Developer`PackedArrayQ[\(\(\(\({1, 2, 3, 4, 5}\
\)\), All\)\)]\) must be one of \!\({Integer, Real, Complex}\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"General::mbrpos"],

Cell[BoxData[
    \(Developer`PackedArrayQ[{1, 2, 3, 4, 5}, All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::mbrpos"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Developer`PackedArrayQ", "MR"],
  "."
}], "Text",
  CellTags->"General::mbrpos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`PackedArrayQ[Range[5], Integer]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::mbrpos"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::mbrpos"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::seqso", "ObjectNameWarningMessages",
  CellTags->"General::seqso"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"seqso\"\>"}], \(\(:\)\(\ \)\), "Sequence", " ", 
      "specification", 
      " ", \((\(+n\), \ \(-n\), \ {\(+n\)}, \ {\(-n\)}, \ or\ {m, \ n})\), 
      " ", "expected", " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::seqso"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::seqso"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sysname", "ObjectNameWarningMessages",
  CellTags->"General::sysname"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sysname\"\>"}], \(\(:\)\(\ \)\), "\<\"`1` is not a known \
SystemOption.\"\>"}]], "Message",
  CellLabel->"From In[71]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sysname"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Developer`SetSystemOptions", "MR"],
  " is used with an option name that is not a known system option.\n\
\[FilledSmallSquare] Known system options can be listed by evaluating ",
  StyleBox["Developer`SystemOptions[]", "MR"],
  "."
}], "Notes",
  CellTags->"General::sysname"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sysname"],

Cell[TextData[{
  "An error occurs in this example because the name given in the argument of \
",
  StyleBox["Developer`SetSystemOptions", "MR"],
  " is not a known system option."
}], "Text",
  CellTags->"General::sysname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessageFlat\>" \[Rule] 
        True]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sysname"],

Cell[BoxData[
    \(Developer`SetSystemOptions::"sysname" \(\(:\)\(\ \)\) 
      "\!\(\"UnpackMessageFlat\"\) is not a known SystemOption."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"General::sysname"],

Cell[BoxData[
    \(Developer`SetSystemOptions[
      "UnpackMessageFlat" \[Rule] True]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sysname"]
}, Open  ]],

Cell["\<\
This sets a system option that enables certain diagnostic messages.\
\
\>", "Text",
  CellTags->"General::sysname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] True]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"General::sysname"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::sysname"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{expr = Range[5]}, expr + Null]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::sysname"],

Cell[BoxData[
    \(Developer`FromPackedArray::"unpack1" \(\(:\)\(\ \)\) 
      "Unpacking array."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::sysname"],

Cell[BoxData[
    \({1 + Null, 2 + Null, 3 + Null, 4 + Null, 5 + Null}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::sysname"]
}, Open  ]],

Cell["Turn this system option off.", "Text",
  CellTags->"General::sysname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] 
        False]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::sysname"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] False\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::sysname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::systrg", "ObjectNameWarningMessages",
  CellTags->"General::systrg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"systrg\"\>"}], \(\(:\)\(\ \)\), "\<\"`1` is not a string. \
SystemOptions must be strings.\"\>"}]], "Message",
  CellLabel->"From In[71]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::systrg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Developer`SetSystemOptions", "MR"],
  " includes rules in which the left side is not a string."
}], "Notes",
  CellTags->"General::systrg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::systrg"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Developer`SetSystemOptions", "MR"],
  " is not a rule for a string."
}], "Text",
  CellTags->"General::systrg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions[UnpackMessage \[Rule] True]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::systrg"],

Cell[BoxData[
    \(Developer`SetSystemOptions::"systrg" \(\(:\)\(\ \)\) 
      "\!\(UnpackMessage\) is not a string. SystemOptions must be \
strings."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::systrg"],

Cell[BoxData[
    \(Developer`SetSystemOptions[UnpackMessage \[Rule] True]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::systrg"]
}, Open  ]],

Cell["\<\
This sets a system option that enables certain diagnostic messages.\
\
\>", "Text",
  CellTags->"General::systrg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] True]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"General::systrg"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::systrg"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{expr = Range[5]}, expr + Null]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::systrg"],

Cell[BoxData[
    \(Developer`FromPackedArray::"unpack1" \(\(:\)\(\ \)\) 
      "Unpacking array."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::systrg"],

Cell[BoxData[
    \({1 + Null, 2 + Null, 3 + Null, 4 + Null, 5 + Null}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::systrg"]
}, Open  ]],

Cell["Turn this system option off.", "Text",
  CellTags->"General::systrg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] 
        False]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::systrg"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] False\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::systrg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ioppm", "ObjectNameWarningMessages",
  CellTags->"General::ioppm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ioppm\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ `1`\  \
-> \ `2`\ should\ be\ a\ positive\ machine - 
          size\ \(\(integer\)\(.\)\)\)}]], "Message",
  CellTags->"General::ioppm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::ioppm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nptg", "ObjectNameWarningMessages",
  CellTags->"General::nptg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nptg\"\>"}], \(\(:\)\(\ \)\), \(Value\ for\ option\ `1`\  \
-> \ `2`\ is\ expected\ to\ be\ a\ \(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->"General::nptg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nptg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nptn", "ObjectNameWarningMessages",
  CellTags->"General::nptn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nptn\"\>"}], \(\(:\)\(\ \)\), \(Value\ for\ option\ `1`\  \
-> \ `2`\ is\ expected\ to\ be\ a\ \(\(number\)\(.\)\)\)}]], "Message",
  CellTags->"General::nptn"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nptn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::numberm", "ObjectNameWarningMessages",
  CellTags->"General::numberm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"numberm\"\>"}], \(\(:\)\(\ \)\), \(Machine - 
        size\ number\ expected\ at\ position\ `2`\ in\ \(\(`1`\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::numberm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::numberm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::moptrs", "ObjectNameWarningMessages",
  CellTags->"General::moptrs"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"moptrs\"\>"}], \(\(:\)\(\ \)\), \(Method\ option\ \
specification\ `1`\ in\ `2`\ is\ not\ a\ rule\ for\ a\ symbol\ or\ \(\(string\
\)\(.\)\)\)}]], "Message",
  CellTags->"General::moptrs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::moptrs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::optv", "ObjectNameWarningMessages",
  CellTags->"General::optv"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"optv\"\>"}], \(\(:\)\(\ \)\), \(The\ value\ of\ option\ \
`1`\ in\ `2`\ is\ not\ \(\(valid\)\(.\)\)\)}]], "Message",
  CellTags->"General::optv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::optv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::optvg", "ObjectNameWarningMessages",
  CellTags->"General::optvg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"optvg\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ `1`\  \
-> \ `2`\ should\ be\ \(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->"General::optvg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::optvg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::optvp", "ObjectNameWarningMessages",
  CellTags->"General::optvp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"optvp\"\>"}], \(\(:\)\(\ \)\), \(Invalid\ option\ value\ \
at\ position\ `1`\ in\ `2` . \ \ Allowed\ values\ are\ \(\(`3`\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::optvp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::optvp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::moptx", "ObjectNameWarningMessages",
  CellTags->"General::moptx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"moptx\"\>"}], \(\(:\)\(\ \)\), "\<\"Method option `1` in \
`2` is not one of `3`.\"\>"}]], "Message",
  CellLabel->"From In[71]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::moptx"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::moptx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::stringopt", "ObjectNameWarningMessages",
  CellTags->"General::stringopt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"stringopt\"\>"}], \(\(:\)\(\ \)\), \(`1`\ in\ `2`\ is\ not\
\ a\ string . \ 
          All\ options\ to\ `3`\ must\ be\ \(\(strings\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::stringopt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::stringopt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::unique", "ObjectNameWarningMessages",
  CellTags->"General::unique"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"unique\"\>"}], \(\(:\)\(\ \)\), \(There\ is\ more\ than\ \
one\ occurence\ of\ `1`\ in\ `2` . \ \ `1`\ is\ required\ to\ be\ \
\(\(unique\)\(.\)\)\)}]], "Message",
  CellTags->"General::unique"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::unique"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::dupv", "ObjectNameWarningMessages",
  CellTags->"General::dupv"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dupv\"\>"}], \(\(:\)\(\ \)\), \(Duplicate\ variable\ `1`\ \
found\ in\ \(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->"General::dupv"],

Cell["\<\
\[FilledSmallSquare] Generated when the same name is used to \
specify two variables that are required to be distinct.\
\>", "Notes",
  CellTags->"General::dupv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::dupv"],

Cell[TextData[{
  "An error occurs in this example because the same symbol is used in both of \
the range specifications (the third and fourth arguments) in this input to ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 1]\)[f]\)[x, t], f[0, t] == 0, 
        f[1, t] == 1, f[x, 0] == x^2}, f, {x, 0, 1}, {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::dupv"],

Cell[BoxData[
    RowBox[{\(NDSolve::"dupv"\), \(\(:\)\(\ \)\), "\<\"Duplicate variable \\!\
\\(x\\) found in \
\\!\\(NDSolve[\\(\\(\\(\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \
TagBox[\\((2, 0)\\), Derivative], Rule[MultilineFunction, \
None]]\\)\\)[\\(\\(x, t\\)\\)]\\)\\) \[Equal] \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", TagBox[\\((0, 1)\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(x, t\\)\\)]\\)\\)\\)\\), \\(\\(\\(\
\\(f[\\(\\(0, t\\)\\)]\\)\\) \[Equal] 0\\)\\), \\(\\(\\(\\(f[\\(\\(1, \
t\\)\\)]\\)\\) \[Equal] 1\\)\\), \\(\\(\\(\\(f[\\(\\(x, 0\\)\\)]\\)\\) \
\[Equal] x\\^2\\)\\)}\\)\\), f, \\(\\({\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)}\\)\\), \\(\\({x, 0, 1}\\)\\)\\)\\)]\\).\"\>"}]], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::dupv"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(f[0, t] \[Equal] 0\), ",", \(f[1, t] \[Equal] 1\), 
            ",", \(f[x, 0] \[Equal] x\^2\)}], "}"}], ",", "f", 
        ",", \({x, 0, 1}\), ",", \({x, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::dupv"]
}, Open  ]],

Cell[TextData[{
  "This shows valid input to ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 1]\)[f]\)[x, t], f[0, t] == 0, 
        f[1, t] == 1, f[x, 0] == x^2}, f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::dupv"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::dupv"]
}, Open  ]],

Cell["\<\
An error occurs in this example because the same symbol is used for \
both variables of integration.\
\>", "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[x\ y, {x, 0, 1}, {x, 0, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::dupv"],

Cell[BoxData[
    \(NIntegrate::"dupv" \(\(:\)\(\ \)\) 
      "Duplicate variable \!\(x\) found in \!\(NIntegrate[\(\(\(\(x\\ y\)\), \
\(\({x, 0, 1}\)\), \(\({x, 0, 1}\)\)\)\)]\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::dupv"],

Cell[BoxData[
    \(NIntegrate[x\ y, {x, 0, 1}, {x, 0, 1}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::dupv"]
}, Open  ]],

Cell[TextData[{
  "This shows valid variable specifications in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[x\ y, {x, 0, 1}, {y, 0, 1}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::dupv"],

Cell[BoxData[
    \(0.24999999999999994`\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::dupv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::notperm", "ObjectNameWarningMessages",
  CellTags->"General::notperm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"notperm\"\>"}], \(\(:\)\(\ \)\), \(The\ permutation\ \
vector\ `1`\ is\ \(\(incorrect\)\(.\)\)\)}]], "Message",
  CellTags->"General::notperm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::notperm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::oflow", "ObjectNameWarningMessages",
  CellTags->"General::oflow"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"oflow\"\>"}], \(\(:\)\(\ \)\), \(Machine\ overflow\ \
encountered\ during\ \(\(computations\)\(.\)\)\)}]], "Message",
  CellTags->"General::oflow"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::oflow"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nomthd", "ObjectNameWarningMessages",
  CellTags->"General::nomthd"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nomthd\"\>"}], \(\(:\)\(\ \)\), \(There\ is\ no\ method\ \
`1`\ for\ `2`\ \(\(objects\)\(.\)\)\)}]], "Message",
  CellTags->"General::nomthd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nomthd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nnum", "ObjectNameWarningMessages",
  CellTags->"General::nnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nnum\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ `3`\ \
is\ not\ a\ number\ at\ `2`\  = \ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::nnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nnum"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nnum1", "ObjectNameWarningMessages",
  CellTags->"General::nnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nnum1\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ `2`\
\ is\ not\ a\ number\ when\ the\ arguments\ are\ \(\(`1`\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::nnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nnum1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ptlen", "ObjectNameWarningMessages",
  CellTags->"General::ptlen"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ptlen\"\>"}], \(\(:\)\(\ \)\), \(Objects\ of\ unequal\ \
length\ in\ `1`\ cannot\ be\ \(\(combined\)\(.\)\)\)}]], "Message",
  CellTags->"General::ptlen"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::ptlen"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::shlen", "ObjectNameWarningMessages",
  CellTags->"General::shlen"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"shlen\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
should\ have\ at\ least\ two\ \(\(elements\)\(.\)\)\)}]], "Message",
  CellTags->"General::shlen"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::shlen"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::numnm", "ObjectNameWarningMessages",
  CellTags->"General::numnm"],

Cell[BoxData[
    \(General::\(numnm : \ 
        Non - negative\ machine - 
          size\ number\ expected\ at\ position\ `2`\ in\ \
\(\(`1`\)\(.\)\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::numnm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::numnm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::deprec", "ObjectNameWarningMessages",
  CellTags->"General::deprec"],

Cell[BoxData[
    \(General::"deprec" \(\(:\)\(\ \)\) 
      "`1` is deprecated and will not be supported in future versions of \
Mathematica.  Use `2` instead."\)], "Message",
  CellLabel->"From In[45]:=",
  CellTags->"General::deprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::deprec"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 973}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{700, 660},
WindowMargins->{{Automatic, 14}, {31, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "General::argf"->{
    Cell[1835, 57, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argf"],
    Cell[1917, 60, 562, 17, 21, "Message",
      CellTags->"General::argf"],
    Cell[2482, 79, 171, 4, 24, "Notes",
      CellTags->"General::argf"]},
  "General::argb"->{
    Cell[2690, 88, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argb"],
    Cell[2772, 91, 799, 27, 21, "Message",
      CellTags->"General::argb"],
    Cell[3574, 120, 165, 4, 24, "Notes",
      CellTags->"General::argb"],
    Cell[3764, 128, 63, 1, 38, "ExampleSection",
      CellTags->"General::argb"],
    Cell[3830, 131, 177, 5, 24, "Text",
      CellTags->"General::argb"],
    Cell[4032, 140, 96, 3, 26, "Input",
      CellTags->"General::argb"],
    Cell[4131, 145, 234, 5, 37, "Message",
      CellTags->"General::argb"],
    Cell[4368, 152, 97, 3, 21, "Output",
      CellTags->"General::argb"],
    Cell[4480, 158, 136, 5, 24, "Text",
      CellTags->"General::argb"],
    Cell[4641, 167, 108, 3, 26, "Input",
      CellTags->"General::argb"],
    Cell[4752, 172, 92, 3, 21, "Output",
      CellTags->"General::argb"]},
  "General::argbu"->{
    Cell[4905, 182, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argbu"],
    Cell[4989, 185, 768, 26, 21, "Message",
      CellTags->"General::argbu"],
    Cell[5760, 213, 164, 4, 24, "Notes",
      CellTags->"General::argbu"],
    Cell[5949, 221, 64, 1, 38, "ExampleSection",
      CellTags->"General::argbu"],
    Cell[6016, 224, 171, 5, 24, "Text",
      CellTags->"General::argbu"],
    Cell[6212, 233, 106, 3, 26, "Input",
      CellTags->"General::argbu"],
    Cell[6321, 238, 229, 5, 37, "Message",
      CellTags->"General::argbu"],
    Cell[6553, 245, 107, 3, 21, "Output",
      CellTags->"General::argbu"],
    Cell[6675, 251, 125, 5, 24, "Text",
      CellTags->"General::argbu"],
    Cell[6825, 260, 109, 3, 26, "Input",
      CellTags->"General::argbu"],
    Cell[6937, 265, 93, 3, 21, "Output",
      CellTags->"General::argbu"]},
  "General::argct"->{
    Cell[7091, 275, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argct"],
    Cell[7175, 278, 380, 12, 21, "Message",
      CellTags->"General::argct"],
    Cell[7558, 292, 162, 4, 24, "Notes",
      CellTags->"General::argct"],
    Cell[7745, 300, 64, 1, 38, "ExampleSection",
      CellTags->"General::argct"],
    Cell[7812, 303, 175, 5, 24, "Text",
      CellTags->"General::argct"],
    Cell[8012, 312, 102, 3, 26, "Input",
      CellTags->"General::argct"],
    Cell[8117, 317, 186, 4, 21, "Message",
      CellTags->"General::argct"],
    Cell[8306, 323, 103, 3, 21, "Output",
      CellTags->"General::argct"],
    Cell[8424, 329, 130, 5, 24, "Text",
      CellTags->"General::argct"],
    Cell[8579, 338, 111, 3, 26, "Input",
      CellTags->"General::argct"],
    Cell[8693, 343, 118, 3, 21, "Output",
      CellTags->"General::argct"]},
  "General::argctu"->{
    Cell[8872, 353, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argctu"],
    Cell[8958, 356, 355, 11, 21, "Message",
      CellTags->"General::argctu"],
    Cell[9316, 369, 163, 4, 24, "Notes",
      CellTags->"General::argctu"],
    Cell[9504, 377, 65, 1, 38, "ExampleSection",
      CellTags->"General::argctu"],
    Cell[9572, 380, 173, 5, 24, "Text",
      CellTags->"General::argctu"],
    Cell[9770, 389, 100, 3, 26, "Input",
      CellTags->"General::argctu"],
    Cell[9873, 394, 171, 4, 21, "Message",
      CellTags->"General::argctu"],
    Cell[10047, 400, 115, 3, 21, "Output",
      CellTags->"General::argctu"],
    Cell[10177, 406, 127, 5, 24, "Text",
      CellTags->"General::argctu"],
    Cell[10329, 415, 113, 3, 26, "Input",
      CellTags->"General::argctu"],
    Cell[10445, 420, 90, 3, 21, "Output",
      CellTags->"General::argctu"]},
  "General::argm"->{
    Cell[10596, 430, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argm"],
    Cell[10678, 433, 561, 17, 21, "Message",
      CellTags->"General::argm"],
    Cell[11242, 452, 174, 4, 24, "Notes",
      CellTags->"General::argm"],
    Cell[11441, 460, 63, 1, 38, "ExampleSection",
      CellTags->"General::argm"],
    Cell[11507, 463, 163, 5, 24, "Text",
      CellTags->"General::argm"],
    Cell[11695, 472, 91, 3, 26, "Input",
      CellTags->"General::argm"],
    Cell[11789, 477, 212, 5, 21, "Message",
      CellTags->"General::argm"],
    Cell[12004, 484, 92, 3, 21, "Output",
      CellTags->"General::argm"],
    Cell[12111, 490, 123, 5, 24, "Text",
      CellTags->"General::argm"],
    Cell[12259, 499, 95, 3, 26, "Input",
      CellTags->"General::argm"],
    Cell[12357, 504, 89, 3, 21, "Output",
      CellTags->"General::argm"]},
  "General::argmu"->{
    Cell[12507, 514, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argmu"],
    Cell[12591, 517, 527, 16, 21, "Message",
      CellTags->"General::argmu"],
    Cell[13121, 535, 173, 4, 24, "Notes",
      CellTags->"General::argmu"],
    Cell[13319, 543, 64, 1, 38, "ExampleSection",
      CellTags->"General::argmu"],
    Cell[13386, 546, 172, 5, 24, "Text",
      CellTags->"General::argmu"],
    Cell[13583, 555, 105, 3, 26, "Input",
      CellTags->"General::argmu"],
    Cell[13691, 560, 221, 5, 37, "Message",
      CellTags->"General::argmu"],
    Cell[13915, 567, 106, 3, 21, "Output",
      CellTags->"General::argmu"],
    Cell[14036, 573, 131, 5, 24, "Text",
      CellTags->"General::argmu"],
    Cell[14192, 582, 117, 3, 26, "Input",
      CellTags->"General::argmu"],
    Cell[14312, 587, 91, 3, 21, "Output",
      CellTags->"General::argmu"]},
  "General::argr"->{
    Cell[14464, 597, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argr"],
    Cell[14546, 600, 501, 16, 21, "Message",
      CellTags->"General::argr"],
    Cell[15050, 618, 161, 4, 24, "Notes",
      CellTags->"General::argr"],
    Cell[15236, 626, 63, 1, 38, "ExampleSection",
      CellTags->"General::argr"],
    Cell[15302, 629, 170, 5, 24, "Text",
      CellTags->"General::argr"],
    Cell[15497, 638, 106, 3, 26, "Input",
      CellTags->"General::argr"],
    Cell[15606, 643, 228, 5, 37, "Message",
      CellTags->"General::argr"],
    Cell[15837, 650, 107, 3, 21, "Output",
      CellTags->"General::argr"],
    Cell[15959, 656, 137, 5, 24, "Text",
      CellTags->"General::argr"],
    Cell[16121, 665, 137, 3, 26, "Input",
      CellTags->"General::argr"],
    Cell[16261, 670, 105, 3, 33, "Output",
      CellTags->"General::argr"]},
  "General::argrx"->{
    Cell[16427, 680, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argrx"],
    Cell[16511, 683, 736, 25, 21, "Message",
      CellTags->"General::argrx"],
    Cell[17250, 710, 162, 4, 24, "Notes",
      CellTags->"General::argrx"],
    Cell[17437, 718, 64, 1, 38, "ExampleSection",
      CellTags->"General::argrx"],
    Cell[17504, 721, 170, 5, 24, "Text",
      CellTags->"General::argrx"],
    Cell[17699, 730, 113, 3, 26, "Input",
      CellTags->"General::argrx"],
    Cell[17815, 735, 251, 5, 37, "Message",
      CellTags->"General::argrx"],
    Cell[18069, 742, 114, 3, 21, "Output",
      CellTags->"General::argrx"],
    Cell[18198, 748, 138, 5, 24, "Text",
      CellTags->"General::argrx"],
    Cell[18361, 757, 138, 3, 26, "Input",
      CellTags->"General::argrx"],
    Cell[18502, 762, 92, 3, 36, "Output",
      CellTags->"General::argrx"]},
  "General::argt"->{
    Cell[18655, 772, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argt"],
    Cell[18737, 775, 782, 27, 21, "Message",
      CellTags->"General::argt"],
    Cell[19522, 804, 161, 4, 24, "Notes",
      CellTags->"General::argt"],
    Cell[19708, 812, 63, 1, 38, "ExampleSection",
      CellTags->"General::argt"],
    Cell[19774, 815, 169, 5, 24, "Text",
      CellTags->"General::argt"],
    Cell[19968, 824, 130, 3, 26, "Input",
      CellTags->"General::argt"],
    Cell[20101, 829, 223, 5, 21, "Message",
      CellTags->"General::argt"],
    Cell[20327, 836, 131, 3, 21, "Output",
      CellTags->"General::argt"],
    Cell[20473, 842, 127, 5, 24, "Text",
      CellTags->"General::argt"],
    Cell[20625, 851, 132, 3, 26, "Input",
      CellTags->"General::argt"],
    Cell[20760, 856, 96, 3, 21, "Output",
      CellTags->"General::argt"]},
  "General::argtu"->{
    Cell[20917, 866, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argtu"],
    Cell[21001, 869, 751, 26, 21, "Message",
      CellTags->"General::argtu"],
    Cell[21755, 897, 162, 4, 24, "Notes",
      CellTags->"General::argtu"],
    Cell[21942, 905, 64, 1, 38, "ExampleSection",
      CellTags->"General::argtu"],
    Cell[22009, 908, 170, 5, 24, "Text",
      CellTags->"General::argtu"],
    Cell[22204, 917, 111, 3, 26, "Input",
      CellTags->"General::argtu"],
    Cell[22318, 922, 218, 5, 21, "Message",
      CellTags->"General::argtu"],
    Cell[22539, 929, 112, 3, 21, "Output",
      CellTags->"General::argtu"],
    Cell[22666, 935, 128, 5, 24, "Text",
      CellTags->"General::argtu"],
    Cell[22819, 944, 128, 3, 26, "Input",
      CellTags->"General::argtu"],
    Cell[22950, 949, 94, 3, 21, "Output",
      CellTags->"General::argtu"]},
  "General::argx"->{
    Cell[23105, 959, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::argx"],
    Cell[23187, 962, 471, 14, 21, "Message",
      CellTags->"General::argx"],
    Cell[23661, 978, 163, 4, 24, "Notes",
      CellTags->"General::argx"],
    Cell[23849, 986, 63, 1, 38, "ExampleSection",
      CellTags->"General::argx"],
    Cell[23915, 989, 164, 5, 24, "Text",
      CellTags->"General::argx"],
    Cell[24104, 998, 91, 3, 26, "Input",
      CellTags->"General::argx"],
    Cell[24198, 1003, 196, 5, 21, "Message",
      CellTags->"General::argx"],
    Cell[24397, 1010, 92, 3, 21, "Output",
      CellTags->"General::argx"]},
  "General::bool"->{
    Cell[24550, 1020, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bool"],
    Cell[24632, 1023, 430, 13, 21, "Message",
      CellTags->"General::bool"],
    Cell[25065, 1038, 213, 8, 24, "Notes",
      CellTags->"General::bool"],
    Cell[25303, 1050, 63, 1, 38, "ExampleSection",
      CellTags->"General::bool"],
    Cell[25369, 1053, 249, 9, 24, "Text",
      CellTags->"General::bool"],
    Cell[25643, 1066, 117, 3, 26, "Input",
      CellTags->"General::bool"],
    Cell[25763, 1071, 269, 6, 37, "Message",
      CellTags->"General::bool"],
    Cell[26035, 1079, 137, 3, 21, "Output",
      CellTags->"General::bool"]},
  "General::fnsym"->{
    Cell[26233, 1089, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::fnsym"],
    Cell[26317, 1092, 462, 12, 21, "Message",
      CellTags->"General::fnsym"],
    Cell[26782, 1106, 167, 4, 24, "Notes",
      CellTags->"General::fnsym"],
    Cell[26974, 1114, 64, 1, 38, "ExampleSection",
      CellTags->"General::fnsym"],
    Cell[27041, 1117, 192, 5, 24, "Text",
      CellTags->"General::fnsym"],
    Cell[27258, 1126, 103, 3, 26, "Input",
      CellTags->"General::fnsym"],
    Cell[27364, 1131, 227, 5, 37, "Message",
      CellTags->"General::fnsym"],
    Cell[27594, 1138, 89, 3, 21, "Output",
      CellTags->"General::fnsym"],
    Cell[27698, 1144, 132, 5, 24, "Text",
      CellTags->"General::fnsym"],
    Cell[27855, 1153, 134, 3, 26, "Input",
      CellTags->"General::fnsym"],
    Cell[27992, 1158, 89, 3, 21, "Output",
      CellTags->"General::fnsym"]},
  "General::heads"->{
    Cell[28142, 1168, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::heads"],
    Cell[28226, 1171, 723, 24, 21, "Message",
      CellTags->"General::heads"],
    Cell[28952, 1197, 167, 4, 24, "Notes",
      CellTags->"General::heads"],
    Cell[29144, 1205, 64, 1, 38, "ExampleSection",
      CellTags->"General::heads"],
    Cell[29211, 1208, 195, 5, 24, "Text",
      CellTags->"General::heads"],
    Cell[29431, 1217, 124, 3, 26, "Input",
      CellTags->"General::heads"],
    Cell[29558, 1222, 226, 5, 21, "Message",
      CellTags->"General::heads"],
    Cell[29787, 1229, 126, 3, 21, "Output",
      CellTags->"General::heads"],
    Cell[29928, 1235, 126, 5, 24, "Text",
      CellTags->"General::heads"],
    Cell[30079, 1244, 126, 3, 26, "Input",
      CellTags->"General::heads"],
    Cell[30208, 1249, 112, 3, 21, "Output",
      CellTags->"General::heads"]},
  "General::ilsm"->{
    Cell[30381, 1259, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ilsm"],
    Cell[30463, 1262, 519, 16, 21, "Message",
      CellTags->"General::ilsm"],
    Cell[30985, 1280, 163, 4, 24, "Notes",
      CellTags->"General::ilsm"],
    Cell[31173, 1288, 63, 1, 38, "ExampleSection",
      CellTags->"General::ilsm"],
    Cell[31239, 1291, 223, 7, 24, "Text",
      CellTags->"General::ilsm"],
    Cell[31487, 1302, 125, 3, 26, "Input",
      CellTags->"General::ilsm"],
    Cell[31615, 1307, 278, 6, 37, "Message",
      CellTags->"General::ilsm"],
    Cell[31896, 1315, 126, 3, 21, "Output",
      CellTags->"General::ilsm"],
    Cell[32037, 1321, 127, 5, 24, "Text",
      CellTags->"General::ilsm"],
    Cell[32189, 1330, 122, 3, 26, "Input",
      CellTags->"General::ilsm"],
    Cell[32314, 1335, 120, 3, 21, "Output",
      CellTags->"General::ilsm"]},
  "General::ilsmn"->{
    Cell[32495, 1345, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ilsmn"],
    Cell[32579, 1348, 587, 17, 37, "Message",
      CellTags->"General::ilsmn"],
    Cell[33169, 1367, 324, 8, 46, "Notes",
      CellTags->"General::ilsmn"]},
  "General::ipnfm"->{
    Cell[33530, 1380, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ipnfm"],
    Cell[33614, 1383, 297, 8, 37, "Message",
      CellTags->"General::ipnfm"],
    Cell[33914, 1393, 158, 4, 24, "Notes",
      CellTags->"General::ipnfm"],
    Cell[34097, 1401, 64, 1, 38, "ExampleSection",
      CellTags->"General::ipnfm"],
    Cell[34164, 1404, 239, 6, 40, "Text",
      CellTags->"General::ipnfm"],
    Cell[34428, 1414, 119, 3, 26, "Input",
      CellTags->"General::ipnfm"],
    Cell[34550, 1419, 279, 6, 37, "Message",
      CellTags->"General::ipnfm"],
    Cell[34832, 1427, 120, 3, 21, "Output",
      CellTags->"General::ipnfm"],
    Cell[34967, 1433, 126, 5, 24, "Text",
      CellTags->"General::ipnfm"],
    Cell[35118, 1442, 119, 3, 26, "Input",
      CellTags->"General::ipnfm"],
    Cell[35240, 1447, 116, 3, 21, "Output",
      CellTags->"General::ipnfm"]},
  "General::ilsmp"->{
    Cell[35417, 1457, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ilsmp"],
    Cell[35501, 1460, 573, 17, 37, "Message",
      CellTags->"General::ilsmp"],
    Cell[36077, 1479, 173, 4, 24, "Notes",
      CellTags->"General::ilsmp"],
    Cell[36275, 1487, 64, 1, 38, "ExampleSection",
      CellTags->"General::ilsmp"],
    Cell[36342, 1490, 222, 5, 40, "Text",
      CellTags->"General::ilsmp"],
    Cell[36589, 1499, 107, 3, 26, "Input",
      CellTags->"General::ilsmp"],
    Cell[36699, 1504, 266, 5, 37, "Message",
      CellTags->"General::ilsmp"],
    Cell[36968, 1511, 104, 3, 21, "Output",
      CellTags->"General::ilsmp"],
    Cell[37087, 1517, 126, 5, 24, "Text",
      CellTags->"General::ilsmp"],
    Cell[37238, 1526, 103, 3, 26, "Input",
      CellTags->"General::ilsmp"],
    Cell[37344, 1531, 148, 4, 21, "Output",
      CellTags->"General::ilsmp"]},
  "General::innf"->{
    Cell[37553, 1542, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::innf"],
    Cell[37635, 1545, 534, 16, 21, "Message",
      CellTags->"General::innf"],
    Cell[38172, 1563, 202, 6, 24, "Notes",
      CellTags->"General::innf"],
    Cell[38399, 1573, 63, 1, 38, "ExampleSection",
      CellTags->"General::innf"],
    Cell[38465, 1576, 176, 5, 24, "Text",
      CellTags->"General::innf"],
    Cell[38666, 1585, 135, 3, 26, "Input",
      CellTags->"General::innf"],
    Cell[38804, 1590, 282, 6, 37, "Message",
      CellTags->"General::innf"],
    Cell[39089, 1598, 136, 3, 21, "Output",
      CellTags->"General::innf"],
    Cell[39240, 1604, 126, 5, 24, "Text",
      CellTags->"General::innf"],
    Cell[39391, 1613, 135, 3, 26, "Input",
      CellTags->"General::innf"],
    Cell[39529, 1618, 96, 3, 21, "Output",
      CellTags->"General::innf"]},
  "General::int"->{
    Cell[39686, 1628, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::int"],
    Cell[39766, 1631, 406, 13, 21, "Message",
      CellTags->"General::int"],
    Cell[40175, 1646, 141, 4, 24, "Notes",
      CellTags->"General::int"],
    Cell[40341, 1654, 62, 1, 38, "ExampleSection",
      CellTags->"General::int"],
    Cell[40406, 1657, 125, 4, 24, "Text",
      CellTags->"General::int"],
    Cell[40556, 1665, 104, 3, 26, "Input",
      CellTags->"General::int"],
    Cell[40663, 1670, 207, 5, 21, "Message",
      CellTags->"General::int"],
    Cell[40873, 1677, 106, 3, 21, "Output",
      CellTags->"General::int"],
    Cell[40994, 1683, 163, 5, 24, "Text",
      CellTags->"General::int"],
    Cell[41182, 1692, 101, 3, 26, "Input",
      CellTags->"General::int"],
    Cell[41286, 1697, 139, 3, 21, "Output",
      CellTags->"General::int"]},
  "General::intm"->{
    Cell[41486, 1707, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::intm"],
    Cell[41568, 1710, 506, 16, 21, "Message",
      CellTags->"General::intm"],
    Cell[42077, 1728, 247, 5, 40, "Notes",
      CellTags->"General::intm"],
    Cell[42349, 1737, 63, 1, 38, "ExampleSection",
      CellTags->"General::intm"],
    Cell[42415, 1740, 219, 5, 40, "Text",
      CellTags->"General::intm"],
    Cell[42659, 1749, 104, 3, 26, "Input",
      CellTags->"General::intm"],
    Cell[42766, 1754, 226, 5, 37, "Message",
      CellTags->"General::intm"],
    Cell[42995, 1761, 106, 3, 21, "Output",
      CellTags->"General::intm"],
    Cell[43116, 1767, 130, 5, 24, "Text",
      CellTags->"General::intm"],
    Cell[43271, 1776, 104, 3, 26, "Input",
      CellTags->"General::intm"],
    Cell[43378, 1781, 148, 4, 21, "Output",
      CellTags->"General::intm"]},
  "General::intnm"->{
    Cell[43587, 1792, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::intnm"],
    Cell[43671, 1795, 532, 16, 21, "Message",
      CellTags->"General::intnm"],
    Cell[44206, 1813, 256, 5, 40, "Notes",
      CellTags->"General::intnm"],
    Cell[44487, 1822, 64, 1, 38, "ExampleSection",
      CellTags->"General::intnm"],
    Cell[44554, 1825, 192, 5, 24, "Text",
      CellTags->"General::intnm"],
    Cell[44771, 1834, 113, 3, 26, "Input",
      CellTags->"General::intnm"],
    Cell[44887, 1839, 247, 5, 37, "Message",
      CellTags->"General::intnm"],
    Cell[45137, 1846, 113, 3, 21, "Output",
      CellTags->"General::intnm"],
    Cell[45265, 1852, 131, 5, 24, "Text",
      CellTags->"General::intnm"],
    Cell[45421, 1861, 111, 3, 26, "Input",
      CellTags->"General::intnm"],
    Cell[45535, 1866, 108, 3, 21, "Output",
      CellTags->"General::intnm"]},
  "General::intnz"->{
    Cell[45704, 1876, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::intnz"],
    Cell[45788, 1879, 504, 16, 21, "Message",
      CellTags->"General::intnz"],
    Cell[46295, 1897, 154, 4, 24, "Notes",
      CellTags->"General::intnz"],
    Cell[46474, 1905, 64, 1, 38, "ExampleSection",
      CellTags->"General::intnz"],
    Cell[46541, 1908, 196, 5, 24, "Text",
      CellTags->"General::intnz"],
    Cell[46762, 1917, 105, 3, 26, "Input",
      CellTags->"General::intnz"],
    Cell[46870, 1922, 211, 5, 21, "Message",
      CellTags->"General::intnz"],
    Cell[47084, 1929, 103, 3, 21, "Print",
      CellTags->"General::intnz"],
    Cell[47202, 1935, 126, 5, 24, "Text",
      CellTags->"General::intnz"],
    Cell[47353, 1944, 118, 3, 26, "Input",
      CellTags->"General::intnz"],
    Cell[47474, 1949, 137, 4, 21, "Print",
      CellTags->"General::intnz"],
    Cell[47614, 1955, 90, 3, 21, "Output",
      CellTags->"General::intnz"]},
  "General::intpm"->{
    Cell[47765, 1965, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::intpm"],
    Cell[47849, 1968, 520, 16, 21, "Message",
      CellTags->"General::intpm"],
    Cell[48372, 1986, 228, 5, 40, "Notes",
      CellTags->"General::intpm"],
    Cell[48625, 1995, 64, 1, 38, "ExampleSection",
      CellTags->"General::intpm"],
    Cell[48692, 1998, 208, 5, 24, "Text",
      CellTags->"General::intpm"],
    Cell[48925, 2007, 120, 3, 26, "Input",
      CellTags->"General::intpm"],
    Cell[49048, 2012, 266, 5, 37, "Message",
      CellTags->"General::intpm"],
    Cell[49317, 2019, 121, 3, 21, "Output",
      CellTags->"General::intpm"],
    Cell[49453, 2025, 138, 5, 24, "Text",
      CellTags->"General::intpm"],
    Cell[49616, 2034, 121, 3, 26, "Input",
      CellTags->"General::intpm"],
    Cell[49740, 2039, 96, 3, 21, "Output",
      CellTags->"General::intpm"]},
  "General::ioppfa"->{
    Cell[49897, 2049, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ioppfa"],
    Cell[49983, 2052, 308, 8, 37, "Message",
      CellTags->"General::ioppfa"],
    Cell[50294, 2062, 126, 4, 24, "Notes",
      CellTags->"General::ioppfa"]},
  "General::iopf"->{
    Cell[50457, 2071, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::iopf"],
    Cell[50539, 2074, 513, 15, 21, "Message",
      CellTags->"General::iopf"],
    Cell[51055, 2091, 301, 8, 46, "Notes",
      CellTags->"General::iopf"]},
  "General::iopnf"->{
    Cell[51393, 2104, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::iopnf"],
    Cell[51477, 2107, 551, 17, 21, "Message",
      CellTags->"General::iopnf"],
    Cell[52031, 2126, 160, 4, 24, "Notes",
      CellTags->"General::iopnf"],
    Cell[52216, 2134, 64, 1, 38, "ExampleSection",
      CellTags->"General::iopnf"],
    Cell[52283, 2137, 197, 5, 24, "Text",
      CellTags->"General::iopnf"],
    Cell[52505, 2146, 159, 4, 26, "Input",
      CellTags->"General::iopnf"],
    Cell[52667, 2152, 241, 5, 37, "Message",
      CellTags->"General::iopnf"],
    Cell[52911, 2159, 162, 4, 21, "Output",
      CellTags->"General::iopnf"],
    Cell[53088, 2166, 162, 4, 24, "Text",
      CellTags->"General::iopnf"],
    Cell[53275, 2174, 156, 4, 26, "Input",
      CellTags->"General::iopnf"],
    Cell[53434, 2180, 193, 4, 21, "Message",
      CellTags->"General::iopnf"],
    Cell[53630, 2186, 104, 3, 21, "Output",
      CellTags->"General::iopnf"]},
  "General::iopnm"->{
    Cell[53795, 2196, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::iopnm"],
    Cell[53879, 2199, 568, 17, 21, "Message",
      CellTags->"General::iopnm"],
    Cell[54450, 2218, 223, 5, 40, "Notes",
      CellTags->"General::iopnm"]},
  "General::ioppf"->{
    Cell[54710, 2228, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ioppf"],
    Cell[54794, 2231, 531, 15, 21, "Message",
      CellTags->"General::ioppf"],
    Cell[55328, 2248, 164, 4, 24, "Notes",
      CellTags->"General::ioppf"],
    Cell[55517, 2256, 64, 1, 38, "ExampleSection",
      CellTags->"General::ioppf"],
    Cell[55584, 2259, 219, 7, 24, "Text",
      CellTags->"General::ioppf"],
    Cell[55828, 2270, 122, 3, 26, "Input",
      CellTags->"General::ioppf"],
    Cell[55953, 2275, 223, 5, 37, "Message",
      CellTags->"General::ioppf"],
    Cell[56179, 2282, 219, 4, 37, "Output",
      CellTags->"General::ioppf"],
    Cell[56413, 2289, 180, 7, 24, "Text",
      CellTags->"General::ioppf"],
    Cell[56618, 2300, 123, 3, 26, "Input",
      CellTags->"General::ioppf"],
    Cell[56744, 2305, 197, 4, 85, "Output",
      CellTags->"General::ioppf"]},
  "General::ipnf"->{
    Cell[57002, 2316, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ipnf"],
    Cell[57084, 2319, 460, 14, 21, "Message",
      CellTags->"General::ipnf"],
    Cell[57547, 2335, 161, 4, 24, "Notes",
      CellTags->"General::ipnf"]},
  "General::iterb"->{
    Cell[57745, 2344, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::iterb"],
    Cell[57829, 2347, 372, 10, 21, "Message",
      CellTags->"General::iterb"],
    Cell[58204, 2359, 422, 13, 46, "Notes",
      CellTags->"General::iterb"],
    Cell[58651, 2376, 64, 1, 38, "ExampleSection",
      CellTags->"General::iterb"],
    Cell[58718, 2379, 141, 4, 24, "Text",
      CellTags->"General::iterb"],
    Cell[58884, 2387, 106, 3, 26, "Input",
      CellTags->"General::iterb"],
    Cell[58993, 2392, 194, 5, 21, "Message",
      CellTags->"General::iterb"],
    Cell[59190, 2399, 107, 3, 21, "Output",
      CellTags->"General::iterb"],
    Cell[59312, 2405, 142, 5, 24, "Text",
      CellTags->"General::iterb"],
    Cell[59479, 2414, 125, 3, 26, "Input",
      CellTags->"General::iterb"],
    Cell[59607, 2419, 119, 3, 21, "Output",
      CellTags->"General::iterb"],
    Cell[59741, 2425, 221, 5, 40, "Text",
      CellTags->"General::iterb"],
    Cell[59987, 2434, 125, 3, 26, "Input",
      CellTags->"General::iterb"],
    Cell[60115, 2439, 215, 5, 21, "Message",
      CellTags->"General::iterb"],
    Cell[60333, 2446, 134, 3, 21, "Output",
      CellTags->"General::iterb"],
    Cell[60482, 2452, 125, 4, 24, "Text",
      CellTags->"General::iterb"],
    Cell[60632, 2460, 128, 3, 26, "Input",
      CellTags->"General::iterb"],
    Cell[60763, 2465, 190, 5, 21, "Print",
      CellTags->"General::iterb"],
    Cell[60956, 2472, 224, 6, 21, "Print",
      CellTags->"General::iterb"],
    Cell[61183, 2480, 231, 6, 21, "Print",
      CellTags->"General::iterb"],
    Cell[61417, 2488, 231, 6, 21, "Print",
      CellTags->"General::iterb"]},
  "General::itform"->{
    Cell[61709, 2501, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::itform"],
    Cell[61795, 2504, 496, 13, 21, "Message",
      CellTags->"General::itform"],
    Cell[62294, 2519, 591, 15, 84, "Notes",
      CellTags->"General::itform"],
    Cell[62910, 2538, 65, 1, 38, "ExampleSection",
      CellTags->"General::itform"],
    Cell[62978, 2541, 150, 5, 24, "Text",
      CellTags->"General::itform"],
    Cell[63153, 2550, 101, 3, 26, "Input",
      CellTags->"General::itform"],
    Cell[63257, 2555, 220, 5, 37, "Message",
      CellTags->"General::itform"],
    Cell[63480, 2562, 102, 3, 21, "Output",
      CellTags->"General::itform"]},
  "General::itraw"->{
    Cell[63643, 2572, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::itraw"],
    Cell[63727, 2575, 394, 11, 21, "Message",
      CellTags->"General::itraw"],
    Cell[64124, 2588, 327, 9, 46, "Notes",
      CellTags->"General::itraw"],
    Cell[64476, 2601, 64, 1, 38, "ExampleSection",
      CellTags->"General::itraw"],
    Cell[64543, 2604, 135, 4, 24, "Text",
      CellTags->"General::itraw"],
    Cell[64703, 2612, 104, 3, 26, "Input",
      CellTags->"General::itraw"],
    Cell[64810, 2617, 183, 4, 21, "Message",
      CellTags->"General::itraw"],
    Cell[64996, 2623, 105, 3, 21, "Output",
      CellTags->"General::itraw"],
    Cell[65116, 2629, 142, 5, 24, "Text",
      CellTags->"General::itraw"],
    Cell[65283, 2638, 107, 3, 26, "Input",
      CellTags->"General::itraw"],
    Cell[65393, 2643, 107, 3, 21, "Output",
      CellTags->"General::itraw"]},
  "General::ittag"->{
    Cell[65561, 2653, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ittag"],
    Cell[65645, 2656, 444, 13, 21, "Message",
      CellTags->"General::ittag"],
    Cell[66092, 2671, 505, 10, 90, "Notes",
      CellTags->"General::ittag"],
    Cell[66622, 2685, 64, 1, 38, "ExampleSection",
      CellTags->"General::ittag"],
    Cell[66689, 2688, 147, 4, 24, "Text",
      CellTags->"General::ittag"],
    Cell[66861, 2696, 104, 3, 26, "Input",
      CellTags->"General::ittag"],
    Cell[66968, 2701, 208, 5, 21, "Message",
      CellTags->"General::ittag"],
    Cell[67179, 2708, 105, 3, 21, "Output",
      CellTags->"General::ittag"],
    Cell[67299, 2714, 89, 1, 24, "Text",
      CellTags->"General::ittag"],
    Cell[67413, 2719, 103, 3, 26, "Input",
      CellTags->"General::ittag"],
    Cell[67519, 2724, 103, 3, 21, "Output",
      CellTags->"General::ittag"]},
  "General::level"->{
    Cell[67683, 2734, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::level"],
    Cell[67767, 2737, 481, 13, 21, "Message",
      CellTags->"General::level"],
    Cell[68251, 2752, 948, 33, 106, "Notes",
      CellTags->"General::level"],
    Cell[69224, 2789, 64, 1, 38, "ExampleSection",
      CellTags->"General::level"],
    Cell[69291, 2792, 217, 6, 24, "Text",
      CellTags->"General::level"],
    Cell[69533, 2802, 142, 3, 26, "Input",
      CellTags->"General::level"],
    Cell[69678, 2807, 211, 5, 37, "Message",
      CellTags->"General::level"],
    Cell[69892, 2814, 139, 3, 21, "Output",
      CellTags->"General::level"],
    Cell[70046, 2820, 128, 4, 24, "Text",
      CellTags->"General::level"],
    Cell[70199, 2828, 139, 3, 26, "Input",
      CellTags->"General::level"],
    Cell[70341, 2833, 92, 3, 21, "Output",
      CellTags->"General::level"]},
  "General::list"->{
    Cell[70494, 2843, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::list"],
    Cell[70576, 2846, 405, 13, 21, "Message",
      CellTags->"General::list"],
    Cell[70984, 2861, 149, 4, 24, "Notes",
      CellTags->"General::list"],
    Cell[71158, 2869, 63, 1, 38, "ExampleSection",
      CellTags->"General::list"],
    Cell[71224, 2872, 188, 5, 24, "Text",
      CellTags->"General::list"],
    Cell[71437, 2881, 118, 3, 26, "Input",
      CellTags->"General::list"],
    Cell[71558, 2886, 246, 5, 37, "Message",
      CellTags->"General::list"],
    Cell[71807, 2893, 133, 3, 21, "Output",
      CellTags->"General::list"],
    Cell[71955, 2899, 131, 5, 24, "Text",
      CellTags->"General::list"],
    Cell[72111, 2908, 118, 3, 26, "Input",
      CellTags->"General::list"],
    Cell[72232, 2913, 135, 3, 21, "Output",
      CellTags->"General::list"]},
  "General::nonopt"->{
    Cell[72428, 2923, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nonopt"],
    Cell[72514, 2926, 695, 19, 37, "Message",
      CellTags->"General::nonopt"],
    Cell[73212, 2947, 421, 8, 68, "Notes",
      CellTags->"General::nonopt"],
    Cell[73658, 2959, 65, 1, 38, "ExampleSection",
      CellTags->"General::nonopt"],
    Cell[73726, 2962, 209, 6, 24, "Text",
      CellTags->"General::nonopt"],
    Cell[73960, 2972, 108, 3, 26, "Input",
      CellTags->"General::nonopt"],
    Cell[74071, 2977, 303, 6, 37, "Message",
      CellTags->"General::nonopt"],
    Cell[74377, 2985, 109, 3, 21, "Output",
      CellTags->"General::nonopt"],
    Cell[74501, 2991, 149, 5, 24, "Text",
      CellTags->"General::nonopt"],
    Cell[74675, 3000, 119, 3, 26, "Input",
      CellTags->"General::nonopt"],
    Cell[74797, 3005, 103, 3, 21, "Output",
      CellTags->"General::nonopt"]},
  "General::normal"->{
    Cell[74961, 3015, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::normal"],
    Cell[75047, 3018, 433, 13, 21, "Message",
      CellTags->"General::normal"],
    Cell[75483, 3033, 369, 8, 68, "Notes",
      CellTags->"General::normal"],
    Cell[75877, 3045, 65, 1, 38, "ExampleSection",
      CellTags->"General::normal"],
    Cell[75945, 3048, 220, 5, 40, "Text",
      CellTags->"General::normal"],
    Cell[76190, 3057, 100, 3, 26, "Input",
      CellTags->"General::normal"],
    Cell[76293, 3062, 212, 5, 21, "Message",
      CellTags->"General::normal"],
    Cell[76508, 3069, 101, 3, 21, "Output",
      CellTags->"General::normal"],
    Cell[76624, 3075, 130, 5, 24, "Text",
      CellTags->"General::normal"],
    Cell[76779, 3084, 115, 3, 26, "Input",
      CellTags->"General::normal"],
    Cell[76897, 3089, 98, 3, 21, "Output",
      CellTags->"General::normal"]},
  "General::notnorm"->{
    Cell[77056, 3099, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::notnorm"],
    Cell[77144, 3102, 381, 11, 21, "Message",
      CellTags->"General::notnorm"],
    Cell[77528, 3115, 417, 9, 68, "Notes",
      CellTags->"General::notnorm"]},
  "General::opstl"->{
    Cell[77982, 3129, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::opstl"],
    Cell[78066, 3132, 555, 16, 21, "Message",
      CellTags->"General::opstl"],
    Cell[78624, 3150, 164, 4, 24, "Notes",
      CellTags->"General::opstl"],
    Cell[78813, 3158, 64, 1, 38, "ExampleSection",
      CellTags->"General::opstl"],
    Cell[78880, 3161, 262, 7, 40, "Text",
      CellTags->"General::opstl"],
    Cell[79167, 3172, 263, 5, 106, "Input",
      CellTags->"General::opstl"],
    Cell[79433, 3179, 237, 5, 37, "Message",
      CellTags->"General::opstl"],
    Cell[79673, 3186, 173, 4, 21, "Output",
      CellTags->"General::opstl"],
    Cell[79861, 3193, 187, 7, 24, "Text",
      CellTags->"General::opstl"],
    Cell[80073, 3204, 292, 6, 106, "Input",
      CellTags->"General::opstl"],
    Cell[80368, 3212, 117, 3, 21, "Output",
      CellTags->"General::opstl"]},
  "General::optrs"->{
    Cell[80546, 3222, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::optrs"],
    Cell[80630, 3225, 488, 13, 21, "Message",
      CellTags->"General::optrs"],
    Cell[81121, 3240, 253, 6, 46, "Notes",
      CellTags->"General::optrs"],
    Cell[81399, 3250, 64, 1, 38, "ExampleSection",
      CellTags->"General::optrs"],
    Cell[81466, 3253, 207, 5, 24, "Text",
      CellTags->"General::optrs"],
    Cell[81698, 3262, 124, 3, 26, "Input",
      CellTags->"General::optrs"],
    Cell[81825, 3267, 298, 6, 46, "Message",
      CellTags->"General::optrs"],
    Cell[82126, 3275, 127, 3, 26, "Output",
      CellTags->"General::optrs"],
    Cell[82268, 3281, 140, 5, 24, "Text",
      CellTags->"General::optrs"],
    Cell[82433, 3290, 124, 3, 26, "Input",
      CellTags->"General::optrs"],
    Cell[82560, 3295, 116, 3, 26, "Output",
      CellTags->"General::optrs"]},
  "General::opttf"->{
    Cell[82737, 3305, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::opttf"],
    Cell[82821, 3308, 498, 15, 21, "Message",
      CellTags->"General::opttf"],
    Cell[83322, 3325, 223, 8, 24, "Notes",
      CellTags->"General::opttf"],
    Cell[83570, 3337, 64, 1, 38, "ExampleSection",
      CellTags->"General::opttf"],
    Cell[83637, 3340, 255, 9, 24, "Text",
      CellTags->"General::opttf"],
    Cell[83917, 3353, 140, 3, 26, "Input",
      CellTags->"General::opttf"],
    Cell[84060, 3358, 215, 5, 21, "Message",
      CellTags->"General::opttf"],
    Cell[84278, 3365, 91, 3, 21, "Output",
      CellTags->"General::opttf"],
    Cell[84384, 3371, 181, 7, 24, "Text",
      CellTags->"General::opttf"],
    Cell[84590, 3382, 136, 3, 26, "Input",
      CellTags->"General::opttf"],
    Cell[84729, 3387, 91, 3, 21, "Output",
      CellTags->"General::opttf"]},
  "General::opttfa"->{
    Cell[84881, 3397, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::opttfa"],
    Cell[84967, 3400, 560, 16, 21, "Message",
      CellTags->"General::opttfa"],
    Cell[85530, 3418, 178, 4, 24, "Notes",
      CellTags->"General::opttfa"],
    Cell[85733, 3426, 65, 1, 38, "ExampleSection",
      CellTags->"General::opttfa"],
    Cell[85801, 3429, 251, 9, 24, "Text",
      CellTags->"General::opttfa"],
    Cell[86077, 3442, 143, 3, 26, "Input",
      CellTags->"General::opttfa"],
    Cell[86223, 3447, 224, 5, 37, "Message",
      CellTags->"General::opttfa"],
    Cell[86450, 3454, 156, 4, 21, "Output",
      CellTags->"General::opttfa"],
    Cell[86621, 3461, 182, 7, 24, "Text",
      CellTags->"General::opttfa"],
    Cell[86828, 3472, 143, 3, 26, "Input",
      CellTags->"General::opttfa"],
    Cell[86974, 3477, 1977, 59, 105, "Output",
      CellTags->"General::opttfa"]},
  "General::optx"->{
    Cell[89012, 3543, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::optx"],
    Cell[89094, 3546, 380, 13, 21, "Message",
      CellTags->"General::optx"],
    Cell[89477, 3561, 534, 14, 68, "Notes",
      CellTags->"General::optx"],
    Cell[90036, 3579, 63, 1, 38, "ExampleSection",
      CellTags->"General::optx"],
    Cell[90102, 3582, 204, 7, 24, "Text",
      CellTags->"General::optx"],
    Cell[90331, 3593, 139, 3, 26, "Input",
      CellTags->"General::optx"],
    Cell[90473, 3598, 285, 6, 37, "Message",
      CellTags->"General::optx"],
    Cell[90761, 3606, 156, 4, 21, "Output",
      CellTags->"General::optx"],
    Cell[90932, 3613, 147, 5, 24, "Text",
      CellTags->"General::optx"],
    Cell[91104, 3622, 142, 3, 26, "Input",
      CellTags->"General::optx"],
    Cell[91249, 3627, 226, 5, 21, "Output",
      CellTags->"General::optx"]},
  "General::par"->{
    Cell[91536, 3639, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::par"],
    Cell[91616, 3642, 443, 15, 21, "Message",
      CellTags->"General::par"],
    Cell[92062, 3659, 285, 6, 46, "Notes",
      CellTags->"General::par"],
    Cell[92372, 3669, 62, 1, 38, "ExampleSection",
      CellTags->"General::par"],
    Cell[92437, 3672, 248, 9, 24, "Text",
      CellTags->"General::par"],
    Cell[92710, 3685, 126, 3, 26, "Input",
      CellTags->"General::par"],
    Cell[92839, 3690, 191, 5, 21, "Message",
      CellTags->"General::par"],
    Cell[93033, 3697, 132, 3, 21, "Output",
      CellTags->"General::par"],
    Cell[93180, 3703, 216, 7, 24, "Text",
      CellTags->"General::par"],
    Cell[93421, 3714, 119, 3, 26, "Input",
      CellTags->"General::par"],
    Cell[93543, 3719, 92, 3, 21, "Output",
      CellTags->"General::par"]},
  "General::string"->{
    Cell[93696, 3729, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::string"],
    Cell[93782, 3732, 411, 13, 21, "Message",
      CellTags->"General::string"],
    Cell[94196, 3747, 153, 4, 24, "Notes",
      CellTags->"General::string"],
    Cell[94374, 3755, 65, 1, 38, "ExampleSection",
      CellTags->"General::string"],
    Cell[94442, 3758, 149, 4, 24, "Text",
      CellTags->"General::string"],
    Cell[94616, 3766, 116, 3, 26, "Input",
      CellTags->"General::string"],
    Cell[94735, 3771, 225, 5, 21, "Message",
      CellTags->"General::string"],
    Cell[94963, 3778, 113, 3, 21, "Output",
      CellTags->"General::string"],
    Cell[95091, 3784, 134, 5, 24, "Text",
      CellTags->"General::string"],
    Cell[95250, 3793, 122, 3, 26, "Input",
      CellTags->"General::string"],
    Cell[95375, 3798, 93, 3, 21, "Output",
      CellTags->"General::string"]},
  "General::strs"->{
    Cell[95529, 3808, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::strs"],
    Cell[95611, 3811, 541, 16, 21, "Message",
      CellTags->"General::strs"],
    Cell[96155, 3829, 172, 4, 24, "Notes",
      CellTags->"General::strs"],
    Cell[96352, 3837, 63, 1, 38, "ExampleSection",
      CellTags->"General::strs"],
    Cell[96418, 3840, 209, 5, 24, "Text",
      CellTags->"General::strs"],
    Cell[96652, 3849, 137, 3, 26, "Input",
      CellTags->"General::strs"],
    Cell[96792, 3854, 111, 3, 21, "Output",
      CellTags->"General::strs"],
    Cell[96940, 3862, 99, 3, 26, "Input",
      CellTags->"General::strs"],
    Cell[97042, 3867, 267, 6, 37, "Message",
      CellTags->"General::strs"],
    Cell[97312, 3875, 94, 3, 21, "Output",
      CellTags->"General::strs"],
    Cell[97421, 3881, 124, 5, 24, "Text",
      CellTags->"General::strs"],
    Cell[97570, 3890, 105, 3, 26, "Input",
      CellTags->"General::strs"],
    Cell[97678, 3895, 95, 3, 21, "Output",
      CellTags->"General::strs"],
    Cell[97788, 3901, 62, 1, 24, "Text",
      CellTags->"General::strs"],
    Cell[97875, 3906, 97, 3, 26, "Input",
      CellTags->"General::strs"],
    Cell[97975, 3911, 93, 3, 21, "Output",
      CellTags->"General::strs"]},
  "General::strse"->{
    Cell[98129, 3921, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::strse"],
    Cell[98213, 3924, 467, 14, 21, "Message",
      CellTags->"General::strse"],
    Cell[98683, 3940, 162, 4, 24, "Notes",
      CellTags->"General::strse"],
    Cell[98870, 3948, 64, 1, 38, "ExampleSection",
      CellTags->"General::strse"],
    Cell[98937, 3951, 142, 4, 24, "Text",
      CellTags->"General::strse"],
    Cell[99104, 3959, 108, 3, 26, "Input",
      CellTags->"General::strse"],
    Cell[99215, 3964, 235, 5, 37, "Message",
      CellTags->"General::strse"],
    Cell[99453, 3971, 109, 3, 21, "Output",
      CellTags->"General::strse"],
    Cell[99577, 3977, 196, 5, 24, "Text",
      CellTags->"General::strse"],
    Cell[99798, 3986, 120, 3, 26, "Input",
      CellTags->"General::strse"],
    Cell[99921, 3991, 98, 3, 21, "Output",
      CellTags->"General::strse"]},
  "General::sym"->{
    Cell[100080, 4001, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sym"],
    Cell[100160, 4004, 439, 12, 21, "Message",
      CellTags->"General::sym"],
    Cell[100602, 4018, 139, 4, 24, "Notes",
      CellTags->"General::sym"],
    Cell[100766, 4026, 62, 1, 38, "ExampleSection",
      CellTags->"General::sym"],
    Cell[100831, 4029, 199, 5, 24, "Text",
      CellTags->"General::sym"],
    Cell[101055, 4038, 103, 3, 26, "Input",
      CellTags->"General::sym"],
    Cell[101161, 4043, 206, 5, 21, "Message",
      CellTags->"General::sym"],
    Cell[101370, 4050, 104, 3, 21, "Output",
      CellTags->"General::sym"],
    Cell[101489, 4056, 130, 5, 24, "Text",
      CellTags->"General::sym"],
    Cell[101644, 4065, 100, 3, 26, "Input",
      CellTags->"General::sym"],
    Cell[101747, 4070, 91, 3, 21, "Output",
      CellTags->"General::sym"]},
  "General::seqs"->{
    Cell[101899, 4080, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::seqs"],
    Cell[101981, 4083, 542, 16, 37, "Message",
      CellTags->"General::seqs"],
    Cell[102526, 4101, 491, 13, 62, "Notes",
      CellTags->"General::seqs"],
    Cell[103042, 4118, 63, 1, 38, "ExampleSection",
      CellTags->"General::seqs"],
    Cell[103108, 4121, 175, 5, 24, "Text",
      CellTags->"General::seqs"],
    Cell[103308, 4130, 127, 3, 26, "Input",
      CellTags->"General::seqs"],
    Cell[103438, 4135, 305, 6, 37, "Message",
      CellTags->"General::seqs"],
    Cell[103746, 4143, 128, 3, 21, "Output",
      CellTags->"General::seqs"],
    Cell[103889, 4149, 139, 5, 24, "Text",
      CellTags->"General::seqs"],
    Cell[104053, 4158, 124, 3, 26, "Input",
      CellTags->"General::seqs"],
    Cell[104180, 4163, 103, 3, 21, "Output",
      CellTags->"General::seqs"]},
  "General::ilsmi"->{
    Cell[104344, 4173, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ilsmi"],
    Cell[104428, 4176, 554, 16, 37, "Message",
      CellTags->"General::ilsmi"],
    Cell[104985, 4194, 194, 6, 24, "Notes",
      CellTags->"General::ilsmi"]},
  "General::itflrw"->{
    Cell[105216, 4205, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::itflrw"],
    Cell[105302, 4208, 925, 22, 53, "Message",
      CellTags->"General::itflrw"],
    Cell[106230, 4232, 202, 5, 24, "Notes",
      CellTags->"General::itflrw"],
    Cell[106457, 4241, 65, 1, 38, "ExampleSection",
      CellTags->"General::itflrw"],
    Cell[106525, 4244, 269, 6, 40, "Text",
      CellTags->"General::itflrw"],
    Cell[106819, 4254, 128, 3, 26, "Input",
      CellTags->"General::itflrw"],
    Cell[106950, 4259, 458, 8, 93, "Message",
      CellTags->"General::itflrw"],
    Cell[107411, 4269, 92, 3, 21, "Output",
      CellTags->"General::itflrw"],
    Cell[107518, 4275, 180, 5, 24, "Text",
      CellTags->"General::itflrw"],
    Cell[107723, 4284, 171, 4, 26, "Input",
      CellTags->"General::itflrw"],
    Cell[107897, 4290, 92, 3, 21, "Output",
      CellTags->"General::itflrw"]},
  "General::mbrpos"->{
    Cell[108050, 4300, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::mbrpos"],
    Cell[108136, 4303, 456, 14, 21, "Message",
      CellTags->"General::mbrpos"],
    Cell[108595, 4319, 228, 6, 46, "Notes",
      CellTags->"General::mbrpos"],
    Cell[108848, 4329, 65, 1, 38, "ExampleSection",
      CellTags->"General::mbrpos"],
    Cell[108916, 4332, 231, 5, 40, "Text",
      CellTags->"General::mbrpos"],
    Cell[109172, 4341, 125, 3, 26, "Input",
      CellTags->"General::mbrpos"],
    Cell[109300, 4346, 290, 6, 53, "Message",
      CellTags->"General::mbrpos"],
    Cell[109593, 4354, 133, 3, 21, "Output",
      CellTags->"General::mbrpos"],
    Cell[109741, 4360, 144, 5, 24, "Text",
      CellTags->"General::mbrpos"],
    Cell[109910, 4369, 129, 3, 26, "Input",
      CellTags->"General::mbrpos"],
    Cell[110042, 4374, 93, 3, 21, "Output",
      CellTags->"General::mbrpos"]},
  "General::seqso"->{
    Cell[110196, 4384, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::seqso"],
    Cell[110280, 4387, 516, 15, 37, "Message",
      CellTags->"General::seqso"],
    Cell[110799, 4404, 194, 6, 24, "Notes",
      CellTags->"General::seqso"]},
  "General::sysname"->{
    Cell[111030, 4415, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sysname"],
    Cell[111118, 4418, 314, 10, 21, "Message",
      CellTags->"General::sysname"],
    Cell[111435, 4430, 346, 8, 46, "Notes",
      CellTags->"General::sysname"],
    Cell[111806, 4442, 66, 1, 38, "ExampleSection",
      CellTags->"General::sysname"],
    Cell[111875, 4445, 224, 6, 40, "Text",
      CellTags->"General::sysname"],
    Cell[112124, 4455, 162, 4, 26, "Input",
      CellTags->"General::sysname"],
    Cell[112289, 4461, 217, 5, 37, "Message",
      CellTags->"General::sysname"],
    Cell[112509, 4468, 157, 4, 21, "Output",
      CellTags->"General::sysname"],
    Cell[112681, 4475, 125, 4, 24, "Text",
      CellTags->"General::sysname"],
    Cell[112831, 4483, 151, 4, 26, "Input",
      CellTags->"General::sysname"],
    Cell[112985, 4489, 118, 3, 21, "Output",
      CellTags->"General::sysname"],
    Cell[113140, 4497, 126, 3, 26, "Input",
      CellTags->"General::sysname"],
    Cell[113269, 4502, 174, 4, 21, "Message",
      CellTags->"General::sysname"],
    Cell[113446, 4508, 140, 3, 21, "Output",
      CellTags->"General::sysname"],
    Cell[113601, 4514, 76, 1, 24, "Text",
      CellTags->"General::sysname"],
    Cell[113702, 4519, 159, 4, 26, "Input",
      CellTags->"General::sysname"],
    Cell[113864, 4525, 119, 3, 21, "Output",
      CellTags->"General::sysname"]},
  "General::systrg"->{
    Cell[114044, 4535, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::systrg"],
    Cell[114130, 4538, 331, 10, 21, "Message",
      CellTags->"General::systrg"],
    Cell[114464, 4550, 225, 5, 24, "Notes",
      CellTags->"General::systrg"],
    Cell[114714, 4559, 65, 1, 38, "ExampleSection",
      CellTags->"General::systrg"],
    Cell[114782, 4562, 201, 5, 24, "Text",
      CellTags->"General::systrg"],
    Cell[115008, 4571, 142, 3, 26, "Input",
      CellTags->"General::systrg"],
    Cell[115153, 4576, 226, 5, 37, "Message",
      CellTags->"General::systrg"],
    Cell[115382, 4583, 143, 3, 21, "Output",
      CellTags->"General::systrg"],
    Cell[115540, 4589, 124, 4, 24, "Text",
      CellTags->"General::systrg"],
    Cell[115689, 4597, 150, 4, 26, "Input",
      CellTags->"General::systrg"],
    Cell[115842, 4603, 117, 3, 21, "Output",
      CellTags->"General::systrg"],
    Cell[115996, 4611, 125, 3, 26, "Input",
      CellTags->"General::systrg"],
    Cell[116124, 4616, 173, 4, 21, "Message",
      CellTags->"General::systrg"],
    Cell[116300, 4622, 139, 3, 21, "Output",
      CellTags->"General::systrg"],
    Cell[116454, 4628, 75, 1, 24, "Text",
      CellTags->"General::systrg"],
    Cell[116554, 4633, 158, 4, 26, "Input",
      CellTags->"General::systrg"],
    Cell[116715, 4639, 118, 3, 21, "Output",
      CellTags->"General::systrg"]},
  "General::ioppm"->{
    Cell[116894, 4649, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ioppm"],
    Cell[116978, 4652, 297, 8, 21, "Message",
      CellTags->"General::ioppm"],
    Cell[117278, 4662, 125, 4, 24, "Notes",
      CellTags->"General::ioppm"]},
  "General::nptg"->{
    Cell[117440, 4671, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nptg"],
    Cell[117522, 4674, 265, 7, 21, "Message",
      CellTags->"General::nptg"],
    Cell[117790, 4683, 124, 4, 24, "Notes",
      CellTags->"General::nptg"]},
  "General::nptn"->{
    Cell[117951, 4692, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nptn"],
    Cell[118033, 4695, 268, 7, 21, "Message",
      CellTags->"General::nptn"],
    Cell[118304, 4704, 124, 4, 24, "Notes",
      CellTags->"General::nptn"]},
  "General::numberm"->{
    Cell[118465, 4713, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::numberm"],
    Cell[118553, 4716, 267, 7, 21, "Message",
      CellTags->"General::numberm"],
    Cell[118823, 4725, 127, 4, 24, "Notes",
      CellTags->"General::numberm"]},
  "General::moptrs"->{
    Cell[118987, 4734, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::moptrs"],
    Cell[119073, 4737, 296, 8, 37, "Message",
      CellTags->"General::moptrs"],
    Cell[119372, 4747, 126, 4, 24, "Notes",
      CellTags->"General::moptrs"]},
  "General::optv"->{
    Cell[119535, 4756, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::optv"],
    Cell[119617, 4759, 253, 7, 21, "Message",
      CellTags->"General::optv"],
    Cell[119873, 4768, 124, 4, 24, "Notes",
      CellTags->"General::optv"]},
  "General::optvg"->{
    Cell[120034, 4777, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::optvg"],
    Cell[120118, 4780, 253, 7, 21, "Message",
      CellTags->"General::optvg"],
    Cell[120374, 4789, 125, 4, 24, "Notes",
      CellTags->"General::optvg"]},
  "General::optvp"->{
    Cell[120536, 4798, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::optvp"],
    Cell[120620, 4801, 287, 8, 21, "Message",
      CellTags->"General::optvp"],
    Cell[120910, 4811, 125, 4, 24, "Notes",
      CellTags->"General::optvp"]},
  "General::moptx"->{
    Cell[121072, 4820, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::moptx"],
    Cell[121156, 4823, 321, 10, 21, "Message",
      CellTags->"General::moptx"],
    Cell[121480, 4835, 125, 4, 24, "Notes",
      CellTags->"General::moptx"]},
  "General::stringopt"->{
    Cell[121642, 4844, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::stringopt"],
    Cell[121734, 4847, 301, 9, 21, "Message",
      CellTags->"General::stringopt"],
    Cell[122038, 4858, 129, 4, 24, "Notes",
      CellTags->"General::stringopt"]},
  "General::unique"->{
    Cell[122204, 4867, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::unique"],
    Cell[122290, 4870, 302, 8, 37, "Message",
      CellTags->"General::unique"],
    Cell[122595, 4880, 126, 4, 24, "Notes",
      CellTags->"General::unique"]},
  "General::dupv"->{
    Cell[122758, 4889, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::dupv"],
    Cell[122840, 4892, 241, 7, 21, "Message",
      CellTags->"General::dupv"],
    Cell[123084, 4901, 172, 4, 24, "Notes",
      CellTags->"General::dupv"],
    Cell[123281, 4909, 63, 1, 38, "ExampleSection",
      CellTags->"General::dupv"],
    Cell[123347, 4912, 249, 6, 40, "Text",
      CellTags->"General::dupv"],
    Cell[123621, 4922, 258, 5, 42, "Input",
      CellTags->"General::dupv"],
    Cell[123882, 4929, 799, 14, 57, "Message",
      CellTags->"General::dupv"],
    Cell[124684, 4945, 798, 21, 39, "Output",
      CellTags->"General::dupv"],
    Cell[125497, 4969, 123, 5, 24, "Text",
      CellTags->"General::dupv"],
    Cell[125645, 4978, 258, 5, 42, "Input",
      CellTags->"General::dupv"],
    Cell[125906, 4985, 289, 8, 21, "Output",
      CellTags->"General::dupv"],
    Cell[126210, 4996, 153, 4, 24, "Text",
      CellTags->"General::dupv"],
    Cell[126388, 5004, 124, 3, 26, "Input",
      CellTags->"General::dupv"],
    Cell[126515, 5009, 253, 5, 37, "Message",
      CellTags->"General::dupv"],
    Cell[126771, 5016, 125, 3, 21, "Output",
      CellTags->"General::dupv"],
    Cell[126911, 5022, 144, 5, 24, "Text",
      CellTags->"General::dupv"],
    Cell[127080, 5031, 124, 3, 26, "Input",
      CellTags->"General::dupv"],
    Cell[127207, 5036, 107, 3, 21, "Output",
      CellTags->"General::dupv"]},
  "General::notperm"->{
    Cell[127375, 5046, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::notperm"],
    Cell[127463, 5049, 251, 7, 21, "Message",
      CellTags->"General::notperm"],
    Cell[127717, 5058, 127, 4, 24, "Notes",
      CellTags->"General::notperm"]},
  "General::oflow"->{
    Cell[127881, 5067, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::oflow"],
    Cell[127965, 5070, 255, 7, 21, "Message",
      CellTags->"General::oflow"],
    Cell[128223, 5079, 125, 4, 24, "Notes",
      CellTags->"General::oflow"]},
  "General::nomthd"->{
    Cell[128385, 5088, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nomthd"],
    Cell[128471, 5091, 250, 7, 21, "Message",
      CellTags->"General::nomthd"],
    Cell[128724, 5100, 126, 4, 24, "Notes",
      CellTags->"General::nomthd"]},
  "General::nnum"->{
    Cell[128887, 5109, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nnum"],
    Cell[128969, 5112, 265, 7, 21, "Message",
      CellTags->"General::nnum"],
    Cell[129237, 5121, 124, 4, 24, "Notes",
      CellTags->"General::nnum"]},
  "General::nnum1"->{
    Cell[129398, 5130, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nnum1"],
    Cell[129482, 5133, 282, 8, 21, "Message",
      CellTags->"General::nnum1"],
    Cell[129767, 5143, 125, 4, 24, "Notes",
      CellTags->"General::nnum1"]},
  "General::ptlen"->{
    Cell[129929, 5152, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ptlen"],
    Cell[130013, 5155, 262, 7, 21, "Message",
      CellTags->"General::ptlen"],
    Cell[130278, 5164, 125, 4, 24, "Notes",
      CellTags->"General::ptlen"]},
  "General::shlen"->{
    Cell[130440, 5173, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::shlen"],
    Cell[130524, 5176, 261, 7, 21, "Message",
      CellTags->"General::shlen"],
    Cell[130788, 5185, 125, 4, 24, "Notes",
      CellTags->"General::shlen"]},
  "General::numnm"->{
    Cell[130950, 5194, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::numnm"],
    Cell[131034, 5197, 251, 7, 21, "Message",
      CellTags->"General::numnm"],
    Cell[131288, 5206, 125, 4, 24, "Notes",
      CellTags->"General::numnm"]},
  "General::deprec"->{
    Cell[131450, 5215, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::deprec"],
    Cell[131536, 5218, 237, 5, 37, "Message",
      CellTags->"General::deprec"],
    Cell[131776, 5225, 126, 4, 24, "Notes",
      CellTags->"General::deprec"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"General::argf", 132594, 5250},
  {"General::argb", 132860, 5257},
  {"General::argbu", 133735, 5280},
  {"General::argct", 134625, 5303},
  {"General::argctu", 135517, 5326},
  {"General::argm", 136421, 5349},
  {"General::argmu", 137308, 5372},
  {"General::argr", 138208, 5395},
  {"General::argrx", 139099, 5418},
  {"General::argt", 139999, 5441},
  {"General::argtu", 140889, 5464},
  {"General::argx", 141789, 5487},
  {"General::bool", 142451, 5504},
  {"General::fnsym", 143122, 5521},
  {"General::heads", 144033, 5544},
  {"General::ilsm", 144945, 5567},
  {"General::ilsmn", 145847, 5590},
  {"General::ipnfm", 146126, 5597},
  {"General::ilsmp", 147038, 5620},
  {"General::innf", 147950, 5643},
  {"General::int", 148849, 5666},
  {"General::intm", 149739, 5689},
  {"General::intnm", 150641, 5712},
  {"General::intnz", 151554, 5735},
  {"General::intpm", 152543, 5760},
  {"General::ioppfa", 153456, 5783},
  {"General::iopf", 153736, 5790},
  {"General::iopnf", 154012, 5797},
  {"General::iopnm", 155005, 5822},
  {"General::ioppf", 155284, 5829},
  {"General::ipnf", 156196, 5852},
  {"General::iterb", 156472, 5859},
  {"General::itform", 158168, 5902},
  {"General::itraw", 158856, 5919},
  {"General::ittag", 159769, 5942},
  {"General::level", 160682, 5965},
  {"General::list", 161595, 5988},
  {"General::nonopt", 162498, 6011},
  {"General::normal", 163423, 6034},
  {"General::notnorm", 164348, 6057},
  {"General::opstl", 164633, 6064},
  {"General::optrs", 165548, 6087},
  {"General::opttf", 166461, 6110},
  {"General::opttfa", 167373, 6133},
  {"General::optx", 168299, 6156},
  {"General::par", 169200, 6179},
  {"General::string", 170091, 6202},
  {"General::strs", 171013, 6225},
  {"General::strse", 172295, 6258},
  {"General::sym", 173205, 6281},
  {"General::seqs", 174105, 6304},
  {"General::ilsmi", 175019, 6327},
  {"General::itflrw", 175302, 6334},
  {"General::mbrpos", 176236, 6357},
  {"General::seqso", 177170, 6380},
  {"General::sysname", 177454, 6387},
  {"General::systrg", 178889, 6422},
  {"General::ioppm", 180306, 6457},
  {"General::nptg", 180586, 6464},
  {"General::nptn", 180863, 6471},
  {"General::numberm", 181143, 6478},
  {"General::moptrs", 181431, 6485},
  {"General::optv", 181714, 6492},
  {"General::optvg", 181992, 6499},
  {"General::optvp", 182273, 6506},
  {"General::moptx", 182554, 6513},
  {"General::stringopt", 182840, 6520},
  {"General::unique", 183134, 6527},
  {"General::dupv", 183417, 6534},
  {"General::notperm", 184881, 6571},
  {"General::oflow", 185168, 6578},
  {"General::nomthd", 185450, 6585},
  {"General::nnum", 185733, 6592},
  {"General::nnum1", 186011, 6599},
  {"General::ptlen", 186292, 6606},
  {"General::shlen", 186573, 6613},
  {"General::numnm", 186854, 6620},
  {"General::deprec", 187136, 6627}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1835, 57, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argf"],
Cell[1917, 60, 562, 17, 21, "Message",
  CellTags->"General::argf"],
Cell[2482, 79, 171, 4, 24, "Notes",
  CellTags->"General::argf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2690, 88, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argb"],
Cell[2772, 91, 799, 27, 21, "Message",
  CellTags->"General::argb"],
Cell[3574, 120, 165, 4, 24, "Notes",
  CellTags->"General::argb"],

Cell[CellGroupData[{
Cell[3764, 128, 63, 1, 38, "ExampleSection",
  CellTags->"General::argb"],
Cell[3830, 131, 177, 5, 24, "Text",
  CellTags->"General::argb"],

Cell[CellGroupData[{
Cell[4032, 140, 96, 3, 26, "Input",
  CellTags->"General::argb"],
Cell[4131, 145, 234, 5, 37, "Message",
  CellTags->"General::argb"],
Cell[4368, 152, 97, 3, 21, "Output",
  CellTags->"General::argb"]
}, Open  ]],
Cell[4480, 158, 136, 5, 24, "Text",
  CellTags->"General::argb"],

Cell[CellGroupData[{
Cell[4641, 167, 108, 3, 26, "Input",
  CellTags->"General::argb"],
Cell[4752, 172, 92, 3, 21, "Output",
  CellTags->"General::argb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4905, 182, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argbu"],
Cell[4989, 185, 768, 26, 21, "Message",
  CellTags->"General::argbu"],
Cell[5760, 213, 164, 4, 24, "Notes",
  CellTags->"General::argbu"],

Cell[CellGroupData[{
Cell[5949, 221, 64, 1, 38, "ExampleSection",
  CellTags->"General::argbu"],
Cell[6016, 224, 171, 5, 24, "Text",
  CellTags->"General::argbu"],

Cell[CellGroupData[{
Cell[6212, 233, 106, 3, 26, "Input",
  CellTags->"General::argbu"],
Cell[6321, 238, 229, 5, 37, "Message",
  CellTags->"General::argbu"],
Cell[6553, 245, 107, 3, 21, "Output",
  CellTags->"General::argbu"]
}, Open  ]],
Cell[6675, 251, 125, 5, 24, "Text",
  CellTags->"General::argbu"],

Cell[CellGroupData[{
Cell[6825, 260, 109, 3, 26, "Input",
  CellTags->"General::argbu"],
Cell[6937, 265, 93, 3, 21, "Output",
  CellTags->"General::argbu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7091, 275, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argct"],
Cell[7175, 278, 380, 12, 21, "Message",
  CellTags->"General::argct"],
Cell[7558, 292, 162, 4, 24, "Notes",
  CellTags->"General::argct"],

Cell[CellGroupData[{
Cell[7745, 300, 64, 1, 38, "ExampleSection",
  CellTags->"General::argct"],
Cell[7812, 303, 175, 5, 24, "Text",
  CellTags->"General::argct"],

Cell[CellGroupData[{
Cell[8012, 312, 102, 3, 26, "Input",
  CellTags->"General::argct"],
Cell[8117, 317, 186, 4, 21, "Message",
  CellTags->"General::argct"],
Cell[8306, 323, 103, 3, 21, "Output",
  CellTags->"General::argct"]
}, Open  ]],
Cell[8424, 329, 130, 5, 24, "Text",
  CellTags->"General::argct"],

Cell[CellGroupData[{
Cell[8579, 338, 111, 3, 26, "Input",
  CellTags->"General::argct"],
Cell[8693, 343, 118, 3, 21, "Output",
  CellTags->"General::argct"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8872, 353, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argctu"],
Cell[8958, 356, 355, 11, 21, "Message",
  CellTags->"General::argctu"],
Cell[9316, 369, 163, 4, 24, "Notes",
  CellTags->"General::argctu"],

Cell[CellGroupData[{
Cell[9504, 377, 65, 1, 38, "ExampleSection",
  CellTags->"General::argctu"],
Cell[9572, 380, 173, 5, 24, "Text",
  CellTags->"General::argctu"],

Cell[CellGroupData[{
Cell[9770, 389, 100, 3, 26, "Input",
  CellTags->"General::argctu"],
Cell[9873, 394, 171, 4, 21, "Message",
  CellTags->"General::argctu"],
Cell[10047, 400, 115, 3, 21, "Output",
  CellTags->"General::argctu"]
}, Open  ]],
Cell[10177, 406, 127, 5, 24, "Text",
  CellTags->"General::argctu"],

Cell[CellGroupData[{
Cell[10329, 415, 113, 3, 26, "Input",
  CellTags->"General::argctu"],
Cell[10445, 420, 90, 3, 21, "Output",
  CellTags->"General::argctu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10596, 430, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argm"],
Cell[10678, 433, 561, 17, 21, "Message",
  CellTags->"General::argm"],
Cell[11242, 452, 174, 4, 24, "Notes",
  CellTags->"General::argm"],

Cell[CellGroupData[{
Cell[11441, 460, 63, 1, 38, "ExampleSection",
  CellTags->"General::argm"],
Cell[11507, 463, 163, 5, 24, "Text",
  CellTags->"General::argm"],

Cell[CellGroupData[{
Cell[11695, 472, 91, 3, 26, "Input",
  CellTags->"General::argm"],
Cell[11789, 477, 212, 5, 21, "Message",
  CellTags->"General::argm"],
Cell[12004, 484, 92, 3, 21, "Output",
  CellTags->"General::argm"]
}, Open  ]],
Cell[12111, 490, 123, 5, 24, "Text",
  CellTags->"General::argm"],

Cell[CellGroupData[{
Cell[12259, 499, 95, 3, 26, "Input",
  CellTags->"General::argm"],
Cell[12357, 504, 89, 3, 21, "Output",
  CellTags->"General::argm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12507, 514, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argmu"],
Cell[12591, 517, 527, 16, 21, "Message",
  CellTags->"General::argmu"],
Cell[13121, 535, 173, 4, 24, "Notes",
  CellTags->"General::argmu"],

Cell[CellGroupData[{
Cell[13319, 543, 64, 1, 38, "ExampleSection",
  CellTags->"General::argmu"],
Cell[13386, 546, 172, 5, 24, "Text",
  CellTags->"General::argmu"],

Cell[CellGroupData[{
Cell[13583, 555, 105, 3, 26, "Input",
  CellTags->"General::argmu"],
Cell[13691, 560, 221, 5, 37, "Message",
  CellTags->"General::argmu"],
Cell[13915, 567, 106, 3, 21, "Output",
  CellTags->"General::argmu"]
}, Open  ]],
Cell[14036, 573, 131, 5, 24, "Text",
  CellTags->"General::argmu"],

Cell[CellGroupData[{
Cell[14192, 582, 117, 3, 26, "Input",
  CellTags->"General::argmu"],
Cell[14312, 587, 91, 3, 21, "Output",
  CellTags->"General::argmu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14464, 597, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argr"],
Cell[14546, 600, 501, 16, 21, "Message",
  CellTags->"General::argr"],
Cell[15050, 618, 161, 4, 24, "Notes",
  CellTags->"General::argr"],

Cell[CellGroupData[{
Cell[15236, 626, 63, 1, 38, "ExampleSection",
  CellTags->"General::argr"],
Cell[15302, 629, 170, 5, 24, "Text",
  CellTags->"General::argr"],

Cell[CellGroupData[{
Cell[15497, 638, 106, 3, 26, "Input",
  CellTags->"General::argr"],
Cell[15606, 643, 228, 5, 37, "Message",
  CellTags->"General::argr"],
Cell[15837, 650, 107, 3, 21, "Output",
  CellTags->"General::argr"]
}, Open  ]],
Cell[15959, 656, 137, 5, 24, "Text",
  CellTags->"General::argr"],

Cell[CellGroupData[{
Cell[16121, 665, 137, 3, 26, "Input",
  CellTags->"General::argr"],
Cell[16261, 670, 105, 3, 33, "Output",
  CellTags->"General::argr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16427, 680, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argrx"],
Cell[16511, 683, 736, 25, 21, "Message",
  CellTags->"General::argrx"],
Cell[17250, 710, 162, 4, 24, "Notes",
  CellTags->"General::argrx"],

Cell[CellGroupData[{
Cell[17437, 718, 64, 1, 38, "ExampleSection",
  CellTags->"General::argrx"],
Cell[17504, 721, 170, 5, 24, "Text",
  CellTags->"General::argrx"],

Cell[CellGroupData[{
Cell[17699, 730, 113, 3, 26, "Input",
  CellTags->"General::argrx"],
Cell[17815, 735, 251, 5, 37, "Message",
  CellTags->"General::argrx"],
Cell[18069, 742, 114, 3, 21, "Output",
  CellTags->"General::argrx"]
}, Open  ]],
Cell[18198, 748, 138, 5, 24, "Text",
  CellTags->"General::argrx"],

Cell[CellGroupData[{
Cell[18361, 757, 138, 3, 26, "Input",
  CellTags->"General::argrx"],
Cell[18502, 762, 92, 3, 36, "Output",
  CellTags->"General::argrx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18655, 772, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argt"],
Cell[18737, 775, 782, 27, 21, "Message",
  CellTags->"General::argt"],
Cell[19522, 804, 161, 4, 24, "Notes",
  CellTags->"General::argt"],

Cell[CellGroupData[{
Cell[19708, 812, 63, 1, 38, "ExampleSection",
  CellTags->"General::argt"],
Cell[19774, 815, 169, 5, 24, "Text",
  CellTags->"General::argt"],

Cell[CellGroupData[{
Cell[19968, 824, 130, 3, 26, "Input",
  CellTags->"General::argt"],
Cell[20101, 829, 223, 5, 21, "Message",
  CellTags->"General::argt"],
Cell[20327, 836, 131, 3, 21, "Output",
  CellTags->"General::argt"]
}, Open  ]],
Cell[20473, 842, 127, 5, 24, "Text",
  CellTags->"General::argt"],

Cell[CellGroupData[{
Cell[20625, 851, 132, 3, 26, "Input",
  CellTags->"General::argt"],
Cell[20760, 856, 96, 3, 21, "Output",
  CellTags->"General::argt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20917, 866, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argtu"],
Cell[21001, 869, 751, 26, 21, "Message",
  CellTags->"General::argtu"],
Cell[21755, 897, 162, 4, 24, "Notes",
  CellTags->"General::argtu"],

Cell[CellGroupData[{
Cell[21942, 905, 64, 1, 38, "ExampleSection",
  CellTags->"General::argtu"],
Cell[22009, 908, 170, 5, 24, "Text",
  CellTags->"General::argtu"],

Cell[CellGroupData[{
Cell[22204, 917, 111, 3, 26, "Input",
  CellTags->"General::argtu"],
Cell[22318, 922, 218, 5, 21, "Message",
  CellTags->"General::argtu"],
Cell[22539, 929, 112, 3, 21, "Output",
  CellTags->"General::argtu"]
}, Open  ]],
Cell[22666, 935, 128, 5, 24, "Text",
  CellTags->"General::argtu"],

Cell[CellGroupData[{
Cell[22819, 944, 128, 3, 26, "Input",
  CellTags->"General::argtu"],
Cell[22950, 949, 94, 3, 21, "Output",
  CellTags->"General::argtu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23105, 959, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::argx"],
Cell[23187, 962, 471, 14, 21, "Message",
  CellTags->"General::argx"],
Cell[23661, 978, 163, 4, 24, "Notes",
  CellTags->"General::argx"],

Cell[CellGroupData[{
Cell[23849, 986, 63, 1, 38, "ExampleSection",
  CellTags->"General::argx"],
Cell[23915, 989, 164, 5, 24, "Text",
  CellTags->"General::argx"],

Cell[CellGroupData[{
Cell[24104, 998, 91, 3, 26, "Input",
  CellTags->"General::argx"],
Cell[24198, 1003, 196, 5, 21, "Message",
  CellTags->"General::argx"],
Cell[24397, 1010, 92, 3, 21, "Output",
  CellTags->"General::argx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24550, 1020, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bool"],
Cell[24632, 1023, 430, 13, 21, "Message",
  CellTags->"General::bool"],
Cell[25065, 1038, 213, 8, 24, "Notes",
  CellTags->"General::bool"],

Cell[CellGroupData[{
Cell[25303, 1050, 63, 1, 38, "ExampleSection",
  CellTags->"General::bool"],
Cell[25369, 1053, 249, 9, 24, "Text",
  CellTags->"General::bool"],

Cell[CellGroupData[{
Cell[25643, 1066, 117, 3, 26, "Input",
  CellTags->"General::bool"],
Cell[25763, 1071, 269, 6, 37, "Message",
  CellTags->"General::bool"],
Cell[26035, 1079, 137, 3, 21, "Output",
  CellTags->"General::bool"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26233, 1089, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::fnsym"],
Cell[26317, 1092, 462, 12, 21, "Message",
  CellTags->"General::fnsym"],
Cell[26782, 1106, 167, 4, 24, "Notes",
  CellTags->"General::fnsym"],

Cell[CellGroupData[{
Cell[26974, 1114, 64, 1, 38, "ExampleSection",
  CellTags->"General::fnsym"],
Cell[27041, 1117, 192, 5, 24, "Text",
  CellTags->"General::fnsym"],

Cell[CellGroupData[{
Cell[27258, 1126, 103, 3, 26, "Input",
  CellTags->"General::fnsym"],
Cell[27364, 1131, 227, 5, 37, "Message",
  CellTags->"General::fnsym"],
Cell[27594, 1138, 89, 3, 21, "Output",
  CellTags->"General::fnsym"]
}, Open  ]],
Cell[27698, 1144, 132, 5, 24, "Text",
  CellTags->"General::fnsym"],

Cell[CellGroupData[{
Cell[27855, 1153, 134, 3, 26, "Input",
  CellTags->"General::fnsym"],
Cell[27992, 1158, 89, 3, 21, "Output",
  CellTags->"General::fnsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28142, 1168, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::heads"],
Cell[28226, 1171, 723, 24, 21, "Message",
  CellTags->"General::heads"],
Cell[28952, 1197, 167, 4, 24, "Notes",
  CellTags->"General::heads"],

Cell[CellGroupData[{
Cell[29144, 1205, 64, 1, 38, "ExampleSection",
  CellTags->"General::heads"],
Cell[29211, 1208, 195, 5, 24, "Text",
  CellTags->"General::heads"],

Cell[CellGroupData[{
Cell[29431, 1217, 124, 3, 26, "Input",
  CellTags->"General::heads"],
Cell[29558, 1222, 226, 5, 21, "Message",
  CellTags->"General::heads"],
Cell[29787, 1229, 126, 3, 21, "Output",
  CellTags->"General::heads"]
}, Open  ]],
Cell[29928, 1235, 126, 5, 24, "Text",
  CellTags->"General::heads"],

Cell[CellGroupData[{
Cell[30079, 1244, 126, 3, 26, "Input",
  CellTags->"General::heads"],
Cell[30208, 1249, 112, 3, 21, "Output",
  CellTags->"General::heads"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30381, 1259, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ilsm"],
Cell[30463, 1262, 519, 16, 21, "Message",
  CellTags->"General::ilsm"],
Cell[30985, 1280, 163, 4, 24, "Notes",
  CellTags->"General::ilsm"],

Cell[CellGroupData[{
Cell[31173, 1288, 63, 1, 38, "ExampleSection",
  CellTags->"General::ilsm"],
Cell[31239, 1291, 223, 7, 24, "Text",
  CellTags->"General::ilsm"],

Cell[CellGroupData[{
Cell[31487, 1302, 125, 3, 26, "Input",
  CellTags->"General::ilsm"],
Cell[31615, 1307, 278, 6, 37, "Message",
  CellTags->"General::ilsm"],
Cell[31896, 1315, 126, 3, 21, "Output",
  CellTags->"General::ilsm"]
}, Open  ]],
Cell[32037, 1321, 127, 5, 24, "Text",
  CellTags->"General::ilsm"],

Cell[CellGroupData[{
Cell[32189, 1330, 122, 3, 26, "Input",
  CellTags->"General::ilsm"],
Cell[32314, 1335, 120, 3, 21, "Output",
  CellTags->"General::ilsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32495, 1345, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ilsmn"],
Cell[32579, 1348, 587, 17, 37, "Message",
  CellTags->"General::ilsmn"],
Cell[33169, 1367, 324, 8, 46, "Notes",
  CellTags->"General::ilsmn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33530, 1380, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ipnfm"],
Cell[33614, 1383, 297, 8, 37, "Message",
  CellTags->"General::ipnfm"],
Cell[33914, 1393, 158, 4, 24, "Notes",
  CellTags->"General::ipnfm"],

Cell[CellGroupData[{
Cell[34097, 1401, 64, 1, 38, "ExampleSection",
  CellTags->"General::ipnfm"],
Cell[34164, 1404, 239, 6, 40, "Text",
  CellTags->"General::ipnfm"],

Cell[CellGroupData[{
Cell[34428, 1414, 119, 3, 26, "Input",
  CellTags->"General::ipnfm"],
Cell[34550, 1419, 279, 6, 37, "Message",
  CellTags->"General::ipnfm"],
Cell[34832, 1427, 120, 3, 21, "Output",
  CellTags->"General::ipnfm"]
}, Open  ]],
Cell[34967, 1433, 126, 5, 24, "Text",
  CellTags->"General::ipnfm"],

Cell[CellGroupData[{
Cell[35118, 1442, 119, 3, 26, "Input",
  CellTags->"General::ipnfm"],
Cell[35240, 1447, 116, 3, 21, "Output",
  CellTags->"General::ipnfm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35417, 1457, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ilsmp"],
Cell[35501, 1460, 573, 17, 37, "Message",
  CellTags->"General::ilsmp"],
Cell[36077, 1479, 173, 4, 24, "Notes",
  CellTags->"General::ilsmp"],

Cell[CellGroupData[{
Cell[36275, 1487, 64, 1, 38, "ExampleSection",
  CellTags->"General::ilsmp"],
Cell[36342, 1490, 222, 5, 40, "Text",
  CellTags->"General::ilsmp"],

Cell[CellGroupData[{
Cell[36589, 1499, 107, 3, 26, "Input",
  CellTags->"General::ilsmp"],
Cell[36699, 1504, 266, 5, 37, "Message",
  CellTags->"General::ilsmp"],
Cell[36968, 1511, 104, 3, 21, "Output",
  CellTags->"General::ilsmp"]
}, Open  ]],
Cell[37087, 1517, 126, 5, 24, "Text",
  CellTags->"General::ilsmp"],

Cell[CellGroupData[{
Cell[37238, 1526, 103, 3, 26, "Input",
  CellTags->"General::ilsmp"],
Cell[37344, 1531, 148, 4, 21, "Output",
  CellTags->"General::ilsmp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37553, 1542, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::innf"],
Cell[37635, 1545, 534, 16, 21, "Message",
  CellTags->"General::innf"],
Cell[38172, 1563, 202, 6, 24, "Notes",
  CellTags->"General::innf"],

Cell[CellGroupData[{
Cell[38399, 1573, 63, 1, 38, "ExampleSection",
  CellTags->"General::innf"],
Cell[38465, 1576, 176, 5, 24, "Text",
  CellTags->"General::innf"],

Cell[CellGroupData[{
Cell[38666, 1585, 135, 3, 26, "Input",
  CellTags->"General::innf"],
Cell[38804, 1590, 282, 6, 37, "Message",
  CellTags->"General::innf"],
Cell[39089, 1598, 136, 3, 21, "Output",
  CellTags->"General::innf"]
}, Open  ]],
Cell[39240, 1604, 126, 5, 24, "Text",
  CellTags->"General::innf"],

Cell[CellGroupData[{
Cell[39391, 1613, 135, 3, 26, "Input",
  CellTags->"General::innf"],
Cell[39529, 1618, 96, 3, 21, "Output",
  CellTags->"General::innf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39686, 1628, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::int"],
Cell[39766, 1631, 406, 13, 21, "Message",
  CellTags->"General::int"],
Cell[40175, 1646, 141, 4, 24, "Notes",
  CellTags->"General::int"],

Cell[CellGroupData[{
Cell[40341, 1654, 62, 1, 38, "ExampleSection",
  CellTags->"General::int"],
Cell[40406, 1657, 125, 4, 24, "Text",
  CellTags->"General::int"],

Cell[CellGroupData[{
Cell[40556, 1665, 104, 3, 26, "Input",
  CellTags->"General::int"],
Cell[40663, 1670, 207, 5, 21, "Message",
  CellTags->"General::int"],
Cell[40873, 1677, 106, 3, 21, "Output",
  CellTags->"General::int"]
}, Open  ]],
Cell[40994, 1683, 163, 5, 24, "Text",
  CellTags->"General::int"],

Cell[CellGroupData[{
Cell[41182, 1692, 101, 3, 26, "Input",
  CellTags->"General::int"],
Cell[41286, 1697, 139, 3, 21, "Output",
  CellTags->"General::int"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[41486, 1707, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::intm"],
Cell[41568, 1710, 506, 16, 21, "Message",
  CellTags->"General::intm"],
Cell[42077, 1728, 247, 5, 40, "Notes",
  CellTags->"General::intm"],

Cell[CellGroupData[{
Cell[42349, 1737, 63, 1, 38, "ExampleSection",
  CellTags->"General::intm"],
Cell[42415, 1740, 219, 5, 40, "Text",
  CellTags->"General::intm"],

Cell[CellGroupData[{
Cell[42659, 1749, 104, 3, 26, "Input",
  CellTags->"General::intm"],
Cell[42766, 1754, 226, 5, 37, "Message",
  CellTags->"General::intm"],
Cell[42995, 1761, 106, 3, 21, "Output",
  CellTags->"General::intm"]
}, Open  ]],
Cell[43116, 1767, 130, 5, 24, "Text",
  CellTags->"General::intm"],

Cell[CellGroupData[{
Cell[43271, 1776, 104, 3, 26, "Input",
  CellTags->"General::intm"],
Cell[43378, 1781, 148, 4, 21, "Output",
  CellTags->"General::intm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43587, 1792, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::intnm"],
Cell[43671, 1795, 532, 16, 21, "Message",
  CellTags->"General::intnm"],
Cell[44206, 1813, 256, 5, 40, "Notes",
  CellTags->"General::intnm"],

Cell[CellGroupData[{
Cell[44487, 1822, 64, 1, 38, "ExampleSection",
  CellTags->"General::intnm"],
Cell[44554, 1825, 192, 5, 24, "Text",
  CellTags->"General::intnm"],

Cell[CellGroupData[{
Cell[44771, 1834, 113, 3, 26, "Input",
  CellTags->"General::intnm"],
Cell[44887, 1839, 247, 5, 37, "Message",
  CellTags->"General::intnm"],
Cell[45137, 1846, 113, 3, 21, "Output",
  CellTags->"General::intnm"]
}, Open  ]],
Cell[45265, 1852, 131, 5, 24, "Text",
  CellTags->"General::intnm"],

Cell[CellGroupData[{
Cell[45421, 1861, 111, 3, 26, "Input",
  CellTags->"General::intnm"],
Cell[45535, 1866, 108, 3, 21, "Output",
  CellTags->"General::intnm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45704, 1876, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::intnz"],
Cell[45788, 1879, 504, 16, 21, "Message",
  CellTags->"General::intnz"],
Cell[46295, 1897, 154, 4, 24, "Notes",
  CellTags->"General::intnz"],

Cell[CellGroupData[{
Cell[46474, 1905, 64, 1, 38, "ExampleSection",
  CellTags->"General::intnz"],
Cell[46541, 1908, 196, 5, 24, "Text",
  CellTags->"General::intnz"],

Cell[CellGroupData[{
Cell[46762, 1917, 105, 3, 26, "Input",
  CellTags->"General::intnz"],
Cell[46870, 1922, 211, 5, 21, "Message",
  CellTags->"General::intnz"],
Cell[47084, 1929, 103, 3, 21, "Print",
  CellTags->"General::intnz"]
}, Open  ]],
Cell[47202, 1935, 126, 5, 24, "Text",
  CellTags->"General::intnz"],

Cell[CellGroupData[{
Cell[47353, 1944, 118, 3, 26, "Input",
  CellTags->"General::intnz"],
Cell[47474, 1949, 137, 4, 21, "Print",
  CellTags->"General::intnz"],
Cell[47614, 1955, 90, 3, 21, "Output",
  CellTags->"General::intnz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47765, 1965, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::intpm"],
Cell[47849, 1968, 520, 16, 21, "Message",
  CellTags->"General::intpm"],
Cell[48372, 1986, 228, 5, 40, "Notes",
  CellTags->"General::intpm"],

Cell[CellGroupData[{
Cell[48625, 1995, 64, 1, 38, "ExampleSection",
  CellTags->"General::intpm"],
Cell[48692, 1998, 208, 5, 24, "Text",
  CellTags->"General::intpm"],

Cell[CellGroupData[{
Cell[48925, 2007, 120, 3, 26, "Input",
  CellTags->"General::intpm"],
Cell[49048, 2012, 266, 5, 37, "Message",
  CellTags->"General::intpm"],
Cell[49317, 2019, 121, 3, 21, "Output",
  CellTags->"General::intpm"]
}, Open  ]],
Cell[49453, 2025, 138, 5, 24, "Text",
  CellTags->"General::intpm"],

Cell[CellGroupData[{
Cell[49616, 2034, 121, 3, 26, "Input",
  CellTags->"General::intpm"],
Cell[49740, 2039, 96, 3, 21, "Output",
  CellTags->"General::intpm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49897, 2049, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ioppfa"],
Cell[49983, 2052, 308, 8, 37, "Message",
  CellTags->"General::ioppfa"],
Cell[50294, 2062, 126, 4, 24, "Notes",
  CellTags->"General::ioppfa"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50457, 2071, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::iopf"],
Cell[50539, 2074, 513, 15, 21, "Message",
  CellTags->"General::iopf"],
Cell[51055, 2091, 301, 8, 46, "Notes",
  CellTags->"General::iopf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51393, 2104, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::iopnf"],
Cell[51477, 2107, 551, 17, 21, "Message",
  CellTags->"General::iopnf"],
Cell[52031, 2126, 160, 4, 24, "Notes",
  CellTags->"General::iopnf"],

Cell[CellGroupData[{
Cell[52216, 2134, 64, 1, 38, "ExampleSection",
  CellTags->"General::iopnf"],
Cell[52283, 2137, 197, 5, 24, "Text",
  CellTags->"General::iopnf"],

Cell[CellGroupData[{
Cell[52505, 2146, 159, 4, 26, "Input",
  CellTags->"General::iopnf"],
Cell[52667, 2152, 241, 5, 37, "Message",
  CellTags->"General::iopnf"],
Cell[52911, 2159, 162, 4, 21, "Output",
  CellTags->"General::iopnf"]
}, Open  ]],
Cell[53088, 2166, 162, 4, 24, "Text",
  CellTags->"General::iopnf"],

Cell[CellGroupData[{
Cell[53275, 2174, 156, 4, 26, "Input",
  CellTags->"General::iopnf"],
Cell[53434, 2180, 193, 4, 21, "Message",
  CellTags->"General::iopnf"],
Cell[53630, 2186, 104, 3, 21, "Output",
  CellTags->"General::iopnf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53795, 2196, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::iopnm"],
Cell[53879, 2199, 568, 17, 21, "Message",
  CellTags->"General::iopnm"],
Cell[54450, 2218, 223, 5, 40, "Notes",
  CellTags->"General::iopnm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54710, 2228, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ioppf"],
Cell[54794, 2231, 531, 15, 21, "Message",
  CellTags->"General::ioppf"],
Cell[55328, 2248, 164, 4, 24, "Notes",
  CellTags->"General::ioppf"],

Cell[CellGroupData[{
Cell[55517, 2256, 64, 1, 38, "ExampleSection",
  CellTags->"General::ioppf"],
Cell[55584, 2259, 219, 7, 24, "Text",
  CellTags->"General::ioppf"],

Cell[CellGroupData[{
Cell[55828, 2270, 122, 3, 26, "Input",
  CellTags->"General::ioppf"],
Cell[55953, 2275, 223, 5, 37, "Message",
  CellTags->"General::ioppf"],
Cell[56179, 2282, 219, 4, 37, "Output",
  CellTags->"General::ioppf"]
}, Open  ]],
Cell[56413, 2289, 180, 7, 24, "Text",
  CellTags->"General::ioppf"],

Cell[CellGroupData[{
Cell[56618, 2300, 123, 3, 26, "Input",
  CellTags->"General::ioppf"],
Cell[56744, 2305, 197, 4, 85, "Output",
  CellTags->"General::ioppf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[57002, 2316, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ipnf"],
Cell[57084, 2319, 460, 14, 21, "Message",
  CellTags->"General::ipnf"],
Cell[57547, 2335, 161, 4, 24, "Notes",
  CellTags->"General::ipnf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[57745, 2344, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::iterb"],
Cell[57829, 2347, 372, 10, 21, "Message",
  CellTags->"General::iterb"],
Cell[58204, 2359, 422, 13, 46, "Notes",
  CellTags->"General::iterb"],

Cell[CellGroupData[{
Cell[58651, 2376, 64, 1, 38, "ExampleSection",
  CellTags->"General::iterb"],
Cell[58718, 2379, 141, 4, 24, "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{
Cell[58884, 2387, 106, 3, 26, "Input",
  CellTags->"General::iterb"],
Cell[58993, 2392, 194, 5, 21, "Message",
  CellTags->"General::iterb"],
Cell[59190, 2399, 107, 3, 21, "Output",
  CellTags->"General::iterb"]
}, Open  ]],
Cell[59312, 2405, 142, 5, 24, "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{
Cell[59479, 2414, 125, 3, 26, "Input",
  CellTags->"General::iterb"],
Cell[59607, 2419, 119, 3, 21, "Output",
  CellTags->"General::iterb"]
}, Open  ]],
Cell[59741, 2425, 221, 5, 40, "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{
Cell[59987, 2434, 125, 3, 26, "Input",
  CellTags->"General::iterb"],
Cell[60115, 2439, 215, 5, 21, "Message",
  CellTags->"General::iterb"],
Cell[60333, 2446, 134, 3, 21, "Output",
  CellTags->"General::iterb"]
}, Open  ]],
Cell[60482, 2452, 125, 4, 24, "Text",
  CellTags->"General::iterb"],

Cell[CellGroupData[{
Cell[60632, 2460, 128, 3, 26, "Input",
  CellTags->"General::iterb"],
Cell[60763, 2465, 190, 5, 21, "Print",
  CellTags->"General::iterb"],
Cell[60956, 2472, 224, 6, 21, "Print",
  CellTags->"General::iterb"],
Cell[61183, 2480, 231, 6, 21, "Print",
  CellTags->"General::iterb"],
Cell[61417, 2488, 231, 6, 21, "Print",
  CellTags->"General::iterb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[61709, 2501, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::itform"],
Cell[61795, 2504, 496, 13, 21, "Message",
  CellTags->"General::itform"],
Cell[62294, 2519, 591, 15, 84, "Notes",
  CellTags->"General::itform"],

Cell[CellGroupData[{
Cell[62910, 2538, 65, 1, 38, "ExampleSection",
  CellTags->"General::itform"],
Cell[62978, 2541, 150, 5, 24, "Text",
  CellTags->"General::itform"],

Cell[CellGroupData[{
Cell[63153, 2550, 101, 3, 26, "Input",
  CellTags->"General::itform"],
Cell[63257, 2555, 220, 5, 37, "Message",
  CellTags->"General::itform"],
Cell[63480, 2562, 102, 3, 21, "Output",
  CellTags->"General::itform"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[63643, 2572, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::itraw"],
Cell[63727, 2575, 394, 11, 21, "Message",
  CellTags->"General::itraw"],
Cell[64124, 2588, 327, 9, 46, "Notes",
  CellTags->"General::itraw"],

Cell[CellGroupData[{
Cell[64476, 2601, 64, 1, 38, "ExampleSection",
  CellTags->"General::itraw"],
Cell[64543, 2604, 135, 4, 24, "Text",
  CellTags->"General::itraw"],

Cell[CellGroupData[{
Cell[64703, 2612, 104, 3, 26, "Input",
  CellTags->"General::itraw"],
Cell[64810, 2617, 183, 4, 21, "Message",
  CellTags->"General::itraw"],
Cell[64996, 2623, 105, 3, 21, "Output",
  CellTags->"General::itraw"]
}, Open  ]],
Cell[65116, 2629, 142, 5, 24, "Text",
  CellTags->"General::itraw"],

Cell[CellGroupData[{
Cell[65283, 2638, 107, 3, 26, "Input",
  CellTags->"General::itraw"],
Cell[65393, 2643, 107, 3, 21, "Output",
  CellTags->"General::itraw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65561, 2653, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ittag"],
Cell[65645, 2656, 444, 13, 21, "Message",
  CellTags->"General::ittag"],
Cell[66092, 2671, 505, 10, 90, "Notes",
  CellTags->"General::ittag"],

Cell[CellGroupData[{
Cell[66622, 2685, 64, 1, 38, "ExampleSection",
  CellTags->"General::ittag"],
Cell[66689, 2688, 147, 4, 24, "Text",
  CellTags->"General::ittag"],

Cell[CellGroupData[{
Cell[66861, 2696, 104, 3, 26, "Input",
  CellTags->"General::ittag"],
Cell[66968, 2701, 208, 5, 21, "Message",
  CellTags->"General::ittag"],
Cell[67179, 2708, 105, 3, 21, "Output",
  CellTags->"General::ittag"]
}, Open  ]],
Cell[67299, 2714, 89, 1, 24, "Text",
  CellTags->"General::ittag"],

Cell[CellGroupData[{
Cell[67413, 2719, 103, 3, 26, "Input",
  CellTags->"General::ittag"],
Cell[67519, 2724, 103, 3, 21, "Output",
  CellTags->"General::ittag"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67683, 2734, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::level"],
Cell[67767, 2737, 481, 13, 21, "Message",
  CellTags->"General::level"],
Cell[68251, 2752, 948, 33, 106, "Notes",
  CellTags->"General::level"],

Cell[CellGroupData[{
Cell[69224, 2789, 64, 1, 38, "ExampleSection",
  CellTags->"General::level"],
Cell[69291, 2792, 217, 6, 24, "Text",
  CellTags->"General::level"],

Cell[CellGroupData[{
Cell[69533, 2802, 142, 3, 26, "Input",
  CellTags->"General::level"],
Cell[69678, 2807, 211, 5, 37, "Message",
  CellTags->"General::level"],
Cell[69892, 2814, 139, 3, 21, "Output",
  CellTags->"General::level"]
}, Open  ]],
Cell[70046, 2820, 128, 4, 24, "Text",
  CellTags->"General::level"],

Cell[CellGroupData[{
Cell[70199, 2828, 139, 3, 26, "Input",
  CellTags->"General::level"],
Cell[70341, 2833, 92, 3, 21, "Output",
  CellTags->"General::level"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[70494, 2843, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::list"],
Cell[70576, 2846, 405, 13, 21, "Message",
  CellTags->"General::list"],
Cell[70984, 2861, 149, 4, 24, "Notes",
  CellTags->"General::list"],

Cell[CellGroupData[{
Cell[71158, 2869, 63, 1, 38, "ExampleSection",
  CellTags->"General::list"],
Cell[71224, 2872, 188, 5, 24, "Text",
  CellTags->"General::list"],

Cell[CellGroupData[{
Cell[71437, 2881, 118, 3, 26, "Input",
  CellTags->"General::list"],
Cell[71558, 2886, 246, 5, 37, "Message",
  CellTags->"General::list"],
Cell[71807, 2893, 133, 3, 21, "Output",
  CellTags->"General::list"]
}, Open  ]],
Cell[71955, 2899, 131, 5, 24, "Text",
  CellTags->"General::list"],

Cell[CellGroupData[{
Cell[72111, 2908, 118, 3, 26, "Input",
  CellTags->"General::list"],
Cell[72232, 2913, 135, 3, 21, "Output",
  CellTags->"General::list"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72428, 2923, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nonopt"],
Cell[72514, 2926, 695, 19, 37, "Message",
  CellTags->"General::nonopt"],
Cell[73212, 2947, 421, 8, 68, "Notes",
  CellTags->"General::nonopt"],

Cell[CellGroupData[{
Cell[73658, 2959, 65, 1, 38, "ExampleSection",
  CellTags->"General::nonopt"],
Cell[73726, 2962, 209, 6, 24, "Text",
  CellTags->"General::nonopt"],

Cell[CellGroupData[{
Cell[73960, 2972, 108, 3, 26, "Input",
  CellTags->"General::nonopt"],
Cell[74071, 2977, 303, 6, 37, "Message",
  CellTags->"General::nonopt"],
Cell[74377, 2985, 109, 3, 21, "Output",
  CellTags->"General::nonopt"]
}, Open  ]],
Cell[74501, 2991, 149, 5, 24, "Text",
  CellTags->"General::nonopt"],

Cell[CellGroupData[{
Cell[74675, 3000, 119, 3, 26, "Input",
  CellTags->"General::nonopt"],
Cell[74797, 3005, 103, 3, 21, "Output",
  CellTags->"General::nonopt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[74961, 3015, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::normal"],
Cell[75047, 3018, 433, 13, 21, "Message",
  CellTags->"General::normal"],
Cell[75483, 3033, 369, 8, 68, "Notes",
  CellTags->"General::normal"],

Cell[CellGroupData[{
Cell[75877, 3045, 65, 1, 38, "ExampleSection",
  CellTags->"General::normal"],
Cell[75945, 3048, 220, 5, 40, "Text",
  CellTags->"General::normal"],

Cell[CellGroupData[{
Cell[76190, 3057, 100, 3, 26, "Input",
  CellTags->"General::normal"],
Cell[76293, 3062, 212, 5, 21, "Message",
  CellTags->"General::normal"],
Cell[76508, 3069, 101, 3, 21, "Output",
  CellTags->"General::normal"]
}, Open  ]],
Cell[76624, 3075, 130, 5, 24, "Text",
  CellTags->"General::normal"],

Cell[CellGroupData[{
Cell[76779, 3084, 115, 3, 26, "Input",
  CellTags->"General::normal"],
Cell[76897, 3089, 98, 3, 21, "Output",
  CellTags->"General::normal"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[77056, 3099, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::notnorm"],
Cell[77144, 3102, 381, 11, 21, "Message",
  CellTags->"General::notnorm"],
Cell[77528, 3115, 417, 9, 68, "Notes",
  CellTags->"General::notnorm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77982, 3129, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::opstl"],
Cell[78066, 3132, 555, 16, 21, "Message",
  CellTags->"General::opstl"],
Cell[78624, 3150, 164, 4, 24, "Notes",
  CellTags->"General::opstl"],

Cell[CellGroupData[{
Cell[78813, 3158, 64, 1, 38, "ExampleSection",
  CellTags->"General::opstl"],
Cell[78880, 3161, 262, 7, 40, "Text",
  CellTags->"General::opstl"],

Cell[CellGroupData[{
Cell[79167, 3172, 263, 5, 106, "Input",
  CellTags->"General::opstl"],
Cell[79433, 3179, 237, 5, 37, "Message",
  CellTags->"General::opstl"],
Cell[79673, 3186, 173, 4, 21, "Output",
  CellTags->"General::opstl"]
}, Open  ]],
Cell[79861, 3193, 187, 7, 24, "Text",
  CellTags->"General::opstl"],

Cell[CellGroupData[{
Cell[80073, 3204, 292, 6, 106, "Input",
  CellTags->"General::opstl"],
Cell[80368, 3212, 117, 3, 21, "Output",
  CellTags->"General::opstl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[80546, 3222, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::optrs"],
Cell[80630, 3225, 488, 13, 21, "Message",
  CellTags->"General::optrs"],
Cell[81121, 3240, 253, 6, 46, "Notes",
  CellTags->"General::optrs"],

Cell[CellGroupData[{
Cell[81399, 3250, 64, 1, 38, "ExampleSection",
  CellTags->"General::optrs"],
Cell[81466, 3253, 207, 5, 24, "Text",
  CellTags->"General::optrs"],

Cell[CellGroupData[{
Cell[81698, 3262, 124, 3, 26, "Input",
  CellTags->"General::optrs"],
Cell[81825, 3267, 298, 6, 46, "Message",
  CellTags->"General::optrs"],
Cell[82126, 3275, 127, 3, 26, "Output",
  CellTags->"General::optrs"]
}, Open  ]],
Cell[82268, 3281, 140, 5, 24, "Text",
  CellTags->"General::optrs"],

Cell[CellGroupData[{
Cell[82433, 3290, 124, 3, 26, "Input",
  CellTags->"General::optrs"],
Cell[82560, 3295, 116, 3, 26, "Output",
  CellTags->"General::optrs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[82737, 3305, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::opttf"],
Cell[82821, 3308, 498, 15, 21, "Message",
  CellTags->"General::opttf"],
Cell[83322, 3325, 223, 8, 24, "Notes",
  CellTags->"General::opttf"],

Cell[CellGroupData[{
Cell[83570, 3337, 64, 1, 38, "ExampleSection",
  CellTags->"General::opttf"],
Cell[83637, 3340, 255, 9, 24, "Text",
  CellTags->"General::opttf"],

Cell[CellGroupData[{
Cell[83917, 3353, 140, 3, 26, "Input",
  CellTags->"General::opttf"],
Cell[84060, 3358, 215, 5, 21, "Message",
  CellTags->"General::opttf"],
Cell[84278, 3365, 91, 3, 21, "Output",
  CellTags->"General::opttf"]
}, Open  ]],
Cell[84384, 3371, 181, 7, 24, "Text",
  CellTags->"General::opttf"],

Cell[CellGroupData[{
Cell[84590, 3382, 136, 3, 26, "Input",
  CellTags->"General::opttf"],
Cell[84729, 3387, 91, 3, 21, "Output",
  CellTags->"General::opttf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[84881, 3397, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::opttfa"],
Cell[84967, 3400, 560, 16, 21, "Message",
  CellTags->"General::opttfa"],
Cell[85530, 3418, 178, 4, 24, "Notes",
  CellTags->"General::opttfa"],

Cell[CellGroupData[{
Cell[85733, 3426, 65, 1, 38, "ExampleSection",
  CellTags->"General::opttfa"],
Cell[85801, 3429, 251, 9, 24, "Text",
  CellTags->"General::opttfa"],

Cell[CellGroupData[{
Cell[86077, 3442, 143, 3, 26, "Input",
  CellTags->"General::opttfa"],
Cell[86223, 3447, 224, 5, 37, "Message",
  CellTags->"General::opttfa"],
Cell[86450, 3454, 156, 4, 21, "Output",
  CellTags->"General::opttfa"]
}, Open  ]],
Cell[86621, 3461, 182, 7, 24, "Text",
  CellTags->"General::opttfa"],

Cell[CellGroupData[{
Cell[86828, 3472, 143, 3, 26, "Input",
  CellTags->"General::opttfa"],
Cell[86974, 3477, 1977, 59, 105, "Output",
  CellTags->"General::opttfa"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[89012, 3543, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::optx"],
Cell[89094, 3546, 380, 13, 21, "Message",
  CellTags->"General::optx"],
Cell[89477, 3561, 534, 14, 68, "Notes",
  CellTags->"General::optx"],

Cell[CellGroupData[{
Cell[90036, 3579, 63, 1, 38, "ExampleSection",
  CellTags->"General::optx"],
Cell[90102, 3582, 204, 7, 24, "Text",
  CellTags->"General::optx"],

Cell[CellGroupData[{
Cell[90331, 3593, 139, 3, 26, "Input",
  CellTags->"General::optx"],
Cell[90473, 3598, 285, 6, 37, "Message",
  CellTags->"General::optx"],
Cell[90761, 3606, 156, 4, 21, "Output",
  CellTags->"General::optx"]
}, Open  ]],
Cell[90932, 3613, 147, 5, 24, "Text",
  CellTags->"General::optx"],

Cell[CellGroupData[{
Cell[91104, 3622, 142, 3, 26, "Input",
  CellTags->"General::optx"],
Cell[91249, 3627, 226, 5, 21, "Output",
  CellTags->"General::optx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[91536, 3639, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::par"],
Cell[91616, 3642, 443, 15, 21, "Message",
  CellTags->"General::par"],
Cell[92062, 3659, 285, 6, 46, "Notes",
  CellTags->"General::par"],

Cell[CellGroupData[{
Cell[92372, 3669, 62, 1, 38, "ExampleSection",
  CellTags->"General::par"],
Cell[92437, 3672, 248, 9, 24, "Text",
  CellTags->"General::par"],

Cell[CellGroupData[{
Cell[92710, 3685, 126, 3, 26, "Input",
  CellTags->"General::par"],
Cell[92839, 3690, 191, 5, 21, "Message",
  CellTags->"General::par"],
Cell[93033, 3697, 132, 3, 21, "Output",
  CellTags->"General::par"]
}, Open  ]],
Cell[93180, 3703, 216, 7, 24, "Text",
  CellTags->"General::par"],

Cell[CellGroupData[{
Cell[93421, 3714, 119, 3, 26, "Input",
  CellTags->"General::par"],
Cell[93543, 3719, 92, 3, 21, "Output",
  CellTags->"General::par"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[93696, 3729, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::string"],
Cell[93782, 3732, 411, 13, 21, "Message",
  CellTags->"General::string"],
Cell[94196, 3747, 153, 4, 24, "Notes",
  CellTags->"General::string"],

Cell[CellGroupData[{
Cell[94374, 3755, 65, 1, 38, "ExampleSection",
  CellTags->"General::string"],
Cell[94442, 3758, 149, 4, 24, "Text",
  CellTags->"General::string"],

Cell[CellGroupData[{
Cell[94616, 3766, 116, 3, 26, "Input",
  CellTags->"General::string"],
Cell[94735, 3771, 225, 5, 21, "Message",
  CellTags->"General::string"],
Cell[94963, 3778, 113, 3, 21, "Output",
  CellTags->"General::string"]
}, Open  ]],
Cell[95091, 3784, 134, 5, 24, "Text",
  CellTags->"General::string"],

Cell[CellGroupData[{
Cell[95250, 3793, 122, 3, 26, "Input",
  CellTags->"General::string"],
Cell[95375, 3798, 93, 3, 21, "Output",
  CellTags->"General::string"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95529, 3808, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::strs"],
Cell[95611, 3811, 541, 16, 21, "Message",
  CellTags->"General::strs"],
Cell[96155, 3829, 172, 4, 24, "Notes",
  CellTags->"General::strs"],

Cell[CellGroupData[{
Cell[96352, 3837, 63, 1, 38, "ExampleSection",
  CellTags->"General::strs"],
Cell[96418, 3840, 209, 5, 24, "Text",
  CellTags->"General::strs"],

Cell[CellGroupData[{
Cell[96652, 3849, 137, 3, 26, "Input",
  CellTags->"General::strs"],
Cell[96792, 3854, 111, 3, 21, "Output",
  CellTags->"General::strs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[96940, 3862, 99, 3, 26, "Input",
  CellTags->"General::strs"],
Cell[97042, 3867, 267, 6, 37, "Message",
  CellTags->"General::strs"],
Cell[97312, 3875, 94, 3, 21, "Output",
  CellTags->"General::strs"]
}, Open  ]],
Cell[97421, 3881, 124, 5, 24, "Text",
  CellTags->"General::strs"],

Cell[CellGroupData[{
Cell[97570, 3890, 105, 3, 26, "Input",
  CellTags->"General::strs"],
Cell[97678, 3895, 95, 3, 21, "Output",
  CellTags->"General::strs"]
}, Open  ]],
Cell[97788, 3901, 62, 1, 24, "Text",
  CellTags->"General::strs"],

Cell[CellGroupData[{
Cell[97875, 3906, 97, 3, 26, "Input",
  CellTags->"General::strs"],
Cell[97975, 3911, 93, 3, 21, "Output",
  CellTags->"General::strs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[98129, 3921, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::strse"],
Cell[98213, 3924, 467, 14, 21, "Message",
  CellTags->"General::strse"],
Cell[98683, 3940, 162, 4, 24, "Notes",
  CellTags->"General::strse"],

Cell[CellGroupData[{
Cell[98870, 3948, 64, 1, 38, "ExampleSection",
  CellTags->"General::strse"],
Cell[98937, 3951, 142, 4, 24, "Text",
  CellTags->"General::strse"],

Cell[CellGroupData[{
Cell[99104, 3959, 108, 3, 26, "Input",
  CellTags->"General::strse"],
Cell[99215, 3964, 235, 5, 37, "Message",
  CellTags->"General::strse"],
Cell[99453, 3971, 109, 3, 21, "Output",
  CellTags->"General::strse"]
}, Open  ]],
Cell[99577, 3977, 196, 5, 24, "Text",
  CellTags->"General::strse"],

Cell[CellGroupData[{
Cell[99798, 3986, 120, 3, 26, "Input",
  CellTags->"General::strse"],
Cell[99921, 3991, 98, 3, 21, "Output",
  CellTags->"General::strse"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[100080, 4001, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sym"],
Cell[100160, 4004, 439, 12, 21, "Message",
  CellTags->"General::sym"],
Cell[100602, 4018, 139, 4, 24, "Notes",
  CellTags->"General::sym"],

Cell[CellGroupData[{
Cell[100766, 4026, 62, 1, 38, "ExampleSection",
  CellTags->"General::sym"],
Cell[100831, 4029, 199, 5, 24, "Text",
  CellTags->"General::sym"],

Cell[CellGroupData[{
Cell[101055, 4038, 103, 3, 26, "Input",
  CellTags->"General::sym"],
Cell[101161, 4043, 206, 5, 21, "Message",
  CellTags->"General::sym"],
Cell[101370, 4050, 104, 3, 21, "Output",
  CellTags->"General::sym"]
}, Open  ]],
Cell[101489, 4056, 130, 5, 24, "Text",
  CellTags->"General::sym"],

Cell[CellGroupData[{
Cell[101644, 4065, 100, 3, 26, "Input",
  CellTags->"General::sym"],
Cell[101747, 4070, 91, 3, 21, "Output",
  CellTags->"General::sym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[101899, 4080, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::seqs"],
Cell[101981, 4083, 542, 16, 37, "Message",
  CellTags->"General::seqs"],
Cell[102526, 4101, 491, 13, 62, "Notes",
  CellTags->"General::seqs"],

Cell[CellGroupData[{
Cell[103042, 4118, 63, 1, 38, "ExampleSection",
  CellTags->"General::seqs"],
Cell[103108, 4121, 175, 5, 24, "Text",
  CellTags->"General::seqs"],

Cell[CellGroupData[{
Cell[103308, 4130, 127, 3, 26, "Input",
  CellTags->"General::seqs"],
Cell[103438, 4135, 305, 6, 37, "Message",
  CellTags->"General::seqs"],
Cell[103746, 4143, 128, 3, 21, "Output",
  CellTags->"General::seqs"]
}, Open  ]],
Cell[103889, 4149, 139, 5, 24, "Text",
  CellTags->"General::seqs"],

Cell[CellGroupData[{
Cell[104053, 4158, 124, 3, 26, "Input",
  CellTags->"General::seqs"],
Cell[104180, 4163, 103, 3, 21, "Output",
  CellTags->"General::seqs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104344, 4173, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ilsmi"],
Cell[104428, 4176, 554, 16, 37, "Message",
  CellTags->"General::ilsmi"],
Cell[104985, 4194, 194, 6, 24, "Notes",
  CellTags->"General::ilsmi"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105216, 4205, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::itflrw"],
Cell[105302, 4208, 925, 22, 53, "Message",
  CellTags->"General::itflrw"],
Cell[106230, 4232, 202, 5, 24, "Notes",
  CellTags->"General::itflrw"],

Cell[CellGroupData[{
Cell[106457, 4241, 65, 1, 38, "ExampleSection",
  CellTags->"General::itflrw"],
Cell[106525, 4244, 269, 6, 40, "Text",
  CellTags->"General::itflrw"],

Cell[CellGroupData[{
Cell[106819, 4254, 128, 3, 26, "Input",
  CellTags->"General::itflrw"],
Cell[106950, 4259, 458, 8, 93, "Message",
  CellTags->"General::itflrw"],
Cell[107411, 4269, 92, 3, 21, "Output",
  CellTags->"General::itflrw"]
}, Open  ]],
Cell[107518, 4275, 180, 5, 24, "Text",
  CellTags->"General::itflrw"],

Cell[CellGroupData[{
Cell[107723, 4284, 171, 4, 26, "Input",
  CellTags->"General::itflrw"],
Cell[107897, 4290, 92, 3, 21, "Output",
  CellTags->"General::itflrw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[108050, 4300, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::mbrpos"],
Cell[108136, 4303, 456, 14, 21, "Message",
  CellTags->"General::mbrpos"],
Cell[108595, 4319, 228, 6, 46, "Notes",
  CellTags->"General::mbrpos"],

Cell[CellGroupData[{
Cell[108848, 4329, 65, 1, 38, "ExampleSection",
  CellTags->"General::mbrpos"],
Cell[108916, 4332, 231, 5, 40, "Text",
  CellTags->"General::mbrpos"],

Cell[CellGroupData[{
Cell[109172, 4341, 125, 3, 26, "Input",
  CellTags->"General::mbrpos"],
Cell[109300, 4346, 290, 6, 53, "Message",
  CellTags->"General::mbrpos"],
Cell[109593, 4354, 133, 3, 21, "Output",
  CellTags->"General::mbrpos"]
}, Open  ]],
Cell[109741, 4360, 144, 5, 24, "Text",
  CellTags->"General::mbrpos"],

Cell[CellGroupData[{
Cell[109910, 4369, 129, 3, 26, "Input",
  CellTags->"General::mbrpos"],
Cell[110042, 4374, 93, 3, 21, "Output",
  CellTags->"General::mbrpos"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[110196, 4384, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::seqso"],
Cell[110280, 4387, 516, 15, 37, "Message",
  CellTags->"General::seqso"],
Cell[110799, 4404, 194, 6, 24, "Notes",
  CellTags->"General::seqso"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111030, 4415, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sysname"],
Cell[111118, 4418, 314, 10, 21, "Message",
  CellTags->"General::sysname"],
Cell[111435, 4430, 346, 8, 46, "Notes",
  CellTags->"General::sysname"],

Cell[CellGroupData[{
Cell[111806, 4442, 66, 1, 38, "ExampleSection",
  CellTags->"General::sysname"],
Cell[111875, 4445, 224, 6, 40, "Text",
  CellTags->"General::sysname"],

Cell[CellGroupData[{
Cell[112124, 4455, 162, 4, 26, "Input",
  CellTags->"General::sysname"],
Cell[112289, 4461, 217, 5, 37, "Message",
  CellTags->"General::sysname"],
Cell[112509, 4468, 157, 4, 21, "Output",
  CellTags->"General::sysname"]
}, Open  ]],
Cell[112681, 4475, 125, 4, 24, "Text",
  CellTags->"General::sysname"],

Cell[CellGroupData[{
Cell[112831, 4483, 151, 4, 26, "Input",
  CellTags->"General::sysname"],
Cell[112985, 4489, 118, 3, 21, "Output",
  CellTags->"General::sysname"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113140, 4497, 126, 3, 26, "Input",
  CellTags->"General::sysname"],
Cell[113269, 4502, 174, 4, 21, "Message",
  CellTags->"General::sysname"],
Cell[113446, 4508, 140, 3, 21, "Output",
  CellTags->"General::sysname"]
}, Open  ]],
Cell[113601, 4514, 76, 1, 24, "Text",
  CellTags->"General::sysname"],

Cell[CellGroupData[{
Cell[113702, 4519, 159, 4, 26, "Input",
  CellTags->"General::sysname"],
Cell[113864, 4525, 119, 3, 21, "Output",
  CellTags->"General::sysname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114044, 4535, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::systrg"],
Cell[114130, 4538, 331, 10, 21, "Message",
  CellTags->"General::systrg"],
Cell[114464, 4550, 225, 5, 24, "Notes",
  CellTags->"General::systrg"],

Cell[CellGroupData[{
Cell[114714, 4559, 65, 1, 38, "ExampleSection",
  CellTags->"General::systrg"],
Cell[114782, 4562, 201, 5, 24, "Text",
  CellTags->"General::systrg"],

Cell[CellGroupData[{
Cell[115008, 4571, 142, 3, 26, "Input",
  CellTags->"General::systrg"],
Cell[115153, 4576, 226, 5, 37, "Message",
  CellTags->"General::systrg"],
Cell[115382, 4583, 143, 3, 21, "Output",
  CellTags->"General::systrg"]
}, Open  ]],
Cell[115540, 4589, 124, 4, 24, "Text",
  CellTags->"General::systrg"],

Cell[CellGroupData[{
Cell[115689, 4597, 150, 4, 26, "Input",
  CellTags->"General::systrg"],
Cell[115842, 4603, 117, 3, 21, "Output",
  CellTags->"General::systrg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115996, 4611, 125, 3, 26, "Input",
  CellTags->"General::systrg"],
Cell[116124, 4616, 173, 4, 21, "Message",
  CellTags->"General::systrg"],
Cell[116300, 4622, 139, 3, 21, "Output",
  CellTags->"General::systrg"]
}, Open  ]],
Cell[116454, 4628, 75, 1, 24, "Text",
  CellTags->"General::systrg"],

Cell[CellGroupData[{
Cell[116554, 4633, 158, 4, 26, "Input",
  CellTags->"General::systrg"],
Cell[116715, 4639, 118, 3, 21, "Output",
  CellTags->"General::systrg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[116894, 4649, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ioppm"],
Cell[116978, 4652, 297, 8, 21, "Message",
  CellTags->"General::ioppm"],
Cell[117278, 4662, 125, 4, 24, "Notes",
  CellTags->"General::ioppm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117440, 4671, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nptg"],
Cell[117522, 4674, 265, 7, 21, "Message",
  CellTags->"General::nptg"],
Cell[117790, 4683, 124, 4, 24, "Notes",
  CellTags->"General::nptg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117951, 4692, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nptn"],
Cell[118033, 4695, 268, 7, 21, "Message",
  CellTags->"General::nptn"],
Cell[118304, 4704, 124, 4, 24, "Notes",
  CellTags->"General::nptn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[118465, 4713, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::numberm"],
Cell[118553, 4716, 267, 7, 21, "Message",
  CellTags->"General::numberm"],
Cell[118823, 4725, 127, 4, 24, "Notes",
  CellTags->"General::numberm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[118987, 4734, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::moptrs"],
Cell[119073, 4737, 296, 8, 37, "Message",
  CellTags->"General::moptrs"],
Cell[119372, 4747, 126, 4, 24, "Notes",
  CellTags->"General::moptrs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119535, 4756, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::optv"],
Cell[119617, 4759, 253, 7, 21, "Message",
  CellTags->"General::optv"],
Cell[119873, 4768, 124, 4, 24, "Notes",
  CellTags->"General::optv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[120034, 4777, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::optvg"],
Cell[120118, 4780, 253, 7, 21, "Message",
  CellTags->"General::optvg"],
Cell[120374, 4789, 125, 4, 24, "Notes",
  CellTags->"General::optvg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[120536, 4798, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::optvp"],
Cell[120620, 4801, 287, 8, 21, "Message",
  CellTags->"General::optvp"],
Cell[120910, 4811, 125, 4, 24, "Notes",
  CellTags->"General::optvp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[121072, 4820, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::moptx"],
Cell[121156, 4823, 321, 10, 21, "Message",
  CellTags->"General::moptx"],
Cell[121480, 4835, 125, 4, 24, "Notes",
  CellTags->"General::moptx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[121642, 4844, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::stringopt"],
Cell[121734, 4847, 301, 9, 21, "Message",
  CellTags->"General::stringopt"],
Cell[122038, 4858, 129, 4, 24, "Notes",
  CellTags->"General::stringopt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122204, 4867, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::unique"],
Cell[122290, 4870, 302, 8, 37, "Message",
  CellTags->"General::unique"],
Cell[122595, 4880, 126, 4, 24, "Notes",
  CellTags->"General::unique"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122758, 4889, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::dupv"],
Cell[122840, 4892, 241, 7, 21, "Message",
  CellTags->"General::dupv"],
Cell[123084, 4901, 172, 4, 24, "Notes",
  CellTags->"General::dupv"],

Cell[CellGroupData[{
Cell[123281, 4909, 63, 1, 38, "ExampleSection",
  CellTags->"General::dupv"],
Cell[123347, 4912, 249, 6, 40, "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{
Cell[123621, 4922, 258, 5, 42, "Input",
  CellTags->"General::dupv"],
Cell[123882, 4929, 799, 14, 57, "Message",
  CellTags->"General::dupv"],
Cell[124684, 4945, 798, 21, 39, "Output",
  CellTags->"General::dupv"]
}, Open  ]],
Cell[125497, 4969, 123, 5, 24, "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{
Cell[125645, 4978, 258, 5, 42, "Input",
  CellTags->"General::dupv"],
Cell[125906, 4985, 289, 8, 21, "Output",
  CellTags->"General::dupv"]
}, Open  ]],
Cell[126210, 4996, 153, 4, 24, "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{
Cell[126388, 5004, 124, 3, 26, "Input",
  CellTags->"General::dupv"],
Cell[126515, 5009, 253, 5, 37, "Message",
  CellTags->"General::dupv"],
Cell[126771, 5016, 125, 3, 21, "Output",
  CellTags->"General::dupv"]
}, Open  ]],
Cell[126911, 5022, 144, 5, 24, "Text",
  CellTags->"General::dupv"],

Cell[CellGroupData[{
Cell[127080, 5031, 124, 3, 26, "Input",
  CellTags->"General::dupv"],
Cell[127207, 5036, 107, 3, 21, "Output",
  CellTags->"General::dupv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[127375, 5046, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::notperm"],
Cell[127463, 5049, 251, 7, 21, "Message",
  CellTags->"General::notperm"],
Cell[127717, 5058, 127, 4, 24, "Notes",
  CellTags->"General::notperm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[127881, 5067, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::oflow"],
Cell[127965, 5070, 255, 7, 21, "Message",
  CellTags->"General::oflow"],
Cell[128223, 5079, 125, 4, 24, "Notes",
  CellTags->"General::oflow"]
}, Open  ]],

Cell[CellGroupData[{
Cell[128385, 5088, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nomthd"],
Cell[128471, 5091, 250, 7, 21, "Message",
  CellTags->"General::nomthd"],
Cell[128724, 5100, 126, 4, 24, "Notes",
  CellTags->"General::nomthd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[128887, 5109, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nnum"],
Cell[128969, 5112, 265, 7, 21, "Message",
  CellTags->"General::nnum"],
Cell[129237, 5121, 124, 4, 24, "Notes",
  CellTags->"General::nnum"]
}, Open  ]],

Cell[CellGroupData[{
Cell[129398, 5130, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nnum1"],
Cell[129482, 5133, 282, 8, 21, "Message",
  CellTags->"General::nnum1"],
Cell[129767, 5143, 125, 4, 24, "Notes",
  CellTags->"General::nnum1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[129929, 5152, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ptlen"],
Cell[130013, 5155, 262, 7, 21, "Message",
  CellTags->"General::ptlen"],
Cell[130278, 5164, 125, 4, 24, "Notes",
  CellTags->"General::ptlen"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130440, 5173, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::shlen"],
Cell[130524, 5176, 261, 7, 21, "Message",
  CellTags->"General::shlen"],
Cell[130788, 5185, 125, 4, 24, "Notes",
  CellTags->"General::shlen"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130950, 5194, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::numnm"],
Cell[131034, 5197, 251, 7, 21, "Message",
  CellTags->"General::numnm"],
Cell[131288, 5206, 125, 4, 24, "Notes",
  CellTags->"General::numnm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131450, 5215, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::deprec"],
Cell[131536, 5218, 237, 5, 37, "Message",
  CellTags->"General::deprec"],
Cell[131776, 5225, 126, 4, 24, "Notes",
  CellTags->"General::deprec"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

