(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     51924,       1748]*)
(*NotebookOutlinePosition[     74108,       2254]*)
(*  CellTagsIndexPosition[     73112,       2228]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Cellular Automata", "Title"],

Cell[CellGroupData[{

Cell["CellularAutomaton::rspec", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::rspec"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"rspec"\), \(\(:\)\(\ \)\), "Neighbor", " ", 
      "specification", 
      " ", \((r, \ {r1, \ r2, \  ... }, \ or\ {off1, \ off2, \  ... })\), " ",
       "expected", " ", "at", " ", "position", " ", "3", " ", "in", " ", 
      "the", " ", "rule", " ", "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::rspec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " is a list, and the third element in that list does not have the indicated \
form."
}], "Notes",
  CellTags->"CellularAutomaton::rspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::rspec"],

Cell[TextData[{
  "The third element in the first argument of ",
  StyleBox["CellularAutomaton", "MR"],
  " cannot be an empty list."
}], "Text",
  CellTags->"CellularAutomaton::rspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{3, 2, {}}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::rspec"],

Cell[BoxData[
    \(CellularAutomaton::"rspec" \(\(:\)\(\ \)\) 
      "Neighbor specification (r, {r1, r2, ...}, or {off1, off2, ...}) \
expected at position 3 in the rule specification \!\({3, 2, \
\(\({}\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::rspec"],

Cell[BoxData[
    \(CellularAutomaton[{3, 2, {}}, {0, 1, 0}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::rspec"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::rspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{3, 2, 1}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::rspec"],

Cell[BoxData[
    \({{0, 1, 0}, {1, 0, 0}, {0, 0, 1}, {0, 1, 0}, {1, 0, 0}, {0, 0, 
        1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::rspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::wtspec", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::wtspec"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"wtspec"\), \(\(:\)\(\ \)\), "Weights", " ", 
      "specification", " ", \((1\ or\ {wt1, \ wt2, \  ... })\), " ", 
      "expected", " ", "at", " ", "position", " ", "2", " ", "of", " ", "the",
       " ", "color", " ", "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "in", " ", "the", " ", "rule", " ", "specification", "  ",
       
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::wtspec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the weight specification in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the indicated form.\n\[FilledSmallSquare] The weight \
specification is the second element in the color specification. The color \
specification is the second element in the first argument of ",
  StyleBox["CellularAutomaton", "MR"],
  ".\n\[FilledSmallSquare] The weight specification can be a list of \
non-negative integers."
}], "Notes",
  CellTags->"CellularAutomaton::wtspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::wtspec"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid weight specification."
}], "Text",
  CellTags->"CellularAutomaton::wtspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2, {3, None}}, {1, 0, 2}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::wtspec"],

Cell[BoxData[
    \(CellularAutomaton::"wtspec" \(\(:\)\(\ \)\) 
      "Weights specification (1 or {wt1, wt2, ...}) expected at position 2 of \
the color specification \!\({3, None}\) in the rule specification  \!\({2, \(\
\({3, None}\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::wtspec"],

Cell[BoxData[
    \(CellularAutomaton[{2, {3, None}}, {1, 0, 2}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::wtspec"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid weight specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::wtspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2, {3, {0, 1, 0}}}, {1, 0, 2}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::wtspec"],

Cell[BoxData[
    \({{1, 0, 2}, {0, 2, 0}, {2, 0, 2}, {0, 2, 0}, {2, 0, 2}, {0, 2, 
        0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::wtspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::kspec", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::kspec"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"kspec"\), \(\(:\)\(\ \)\), "Positive", " ", 
      "integer", " ", "greater", " ", "than", " ", "1", " ", "expected", " ", 
      "for", " ", "the", " ", "color", " ", "specification", " ", "at", " ", 
      "position", " ", "1", " ", "of", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", "the", " ", "rule", " ", "specification", " ", 
      
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::kspec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the color specification in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the indicated form.\n\[FilledSmallSquare] The color \
specification is the second element in the first argument of ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Notes",
  CellTags->"CellularAutomaton::kspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::kspec"],

Cell["\<\
An error is generated in this example because 0 is not a valid \
color specification.\
\>", "Text",
  CellTags->"CellularAutomaton::kspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{1, 0}, {1, 1, 0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::kspec"],

Cell[BoxData[
    \(CellularAutomaton::"kspec" \(\(:\)\(\ \)\) 
      "Positive integer greater than 1 expected for the color specification \
at position 1 of \!\(0\) in the rule specification \!\({1, 0}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::kspec"],

Cell[BoxData[
    \(CellularAutomaton[{1, 0}, {1, 1, 0}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::kspec"]
}, Open  ]],

Cell["This input shows a valid color specification.", "Text",
  CellTags->"CellularAutomaton::kspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{1, 2}, {0, 1, 1}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::kspec"],

Cell[BoxData[
    \({{0, 1, 1}, {0, 0, 0}, {1, 1, 1}, {0, 0, 0}, {1, 1, 1}, {0, 0, 
        0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::kspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::nocol", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::nocol"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"nocol"\), \(\(:\)\(\ \)\), "Color", " ", 
      "specification", " ", \(({})\), " ", "expected", " ", "at", " ", 
      "position", " ", "2", " ", "in", " ", "the", " ", "rule", " ", 
      "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::nocol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first element in the rule \
specification is a function, and the second element is not the empty list ",
  StyleBox["{}", "MR"],
  ".\n\[FilledSmallSquare] The rule specification is the first argument in ",
  StyleBox["CellularAutomaton", "MR"],
  ". The color specification is the second element in the rule \
specification."
}], "Notes",
  CellTags->"CellularAutomaton::nocol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::nocol"],

Cell[TextData[{
  "An error occurs in this example because the first element in the first \
argument of ",
  StyleBox["CellularAutomaton", "MR"],
  " is a function, and the second element is not ",
  StyleBox["{}", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::nocol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{Mod[#[\([1]\)] + #[\([3]\)], 2] &, None, 1}, {{1}, 
        0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::nocol"],

Cell[BoxData[
    \(CellularAutomaton::"nocol" \(\(:\)\(\ \)\) 
      "Color specification ({}) expected at position 2 in the rule \
specification \!\({\(\(\(\(Mod[\(\(\(\(\(\(#1 \[LeftDoubleBracket] 1 \
\[RightDoubleBracket]\)\) + \(\(#1 \[LeftDoubleBracket] 3 \
\[RightDoubleBracket]\)\)\)\), 2\)\)]\)\) &\)\), None, 1}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::nocol"],

Cell[BoxData[
    \(CellularAutomaton[{Mod[#1\[LeftDoubleBracket]1\[RightDoubleBracket] + \
#1\[LeftDoubleBracket]3\[RightDoubleBracket], 2] &, None, 1}, {{1}, 0}, 
      5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::nocol"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["{}", "MR"],
  " as a color specification when the rule is specified as a function."
}], "Text",
  CellTags->"CellularAutomaton::nocol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{Mod[#[\([1]\)] + #[\([3]\)], 2] &, {}, 1}, {{1}, 0}, 
      5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::nocol"],

Cell[BoxData[
    \({{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
        0}, {0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
        0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 
        1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::nocol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::gkspec", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::gkspec"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"gkspec"\), \(\(:\)\(\ \)\), "Color", " ", 
      "specification", 
      " ", \((k, \ {k, \ 1}, \ or\ {k, \ {wt1, \ wt2, \  ... }})\), " ", 
      "expected", " ", "at", " ", "position", " ", "2", " ", "in", " ", "the",
       " ", "rule", " ", "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::gkspec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when color specification in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the indicated form.\n\[FilledSmallSquare] The color \
specification is the second element in the first argument of ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Notes",
  CellTags->"CellularAutomaton::gkspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::gkspec"],

Cell["\<\
An error is generated in this example because a list with three \
elements is not a valid color specification.\
\>", "Text",
  CellTags->"CellularAutomaton::gkspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2, {2, 2, 1}}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::gkspec"],

Cell[BoxData[
    \(CellularAutomaton::"gkspec" \(\(:\)\(\ \)\) 
      "Color specification (k, {k, 1}, or {k, {wt1, wt2, ...}}) expected at \
position 2 in the rule specification \!\({2, \(\({2, 2, 1}\)\)}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::gkspec"],

Cell[BoxData[
    \(CellularAutomaton[{2, {2, 2, 1}}, {0, 1, 0}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::gkspec"]
}, Open  ]],

Cell["This input includes a valid color specifcation.", "Text",
  CellTags->"CellularAutomaton::gkspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2, {2, {2, 2, 1}}}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::gkspec"],

Cell[BoxData[
    \({{0, 1, 0}, {1, 0, 0}, {0, 0, 1}, {0, 1, 0}, {1, 0, 0}, {0, 0, 
        1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::gkspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::rnum", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::rnum"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"rnum"\), \(\(:\)\(\ \)\), "List", " ", "of",
       " ", "length", " ", "between", " ", "1", " ", "and", " ", "3", " ", 
      "expected", " ", "for", " ", "the", " ", "rule", " ", "specification", 
      " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::rnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the rule specification in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the indicated form.\n\[FilledSmallSquare] The rule \
specification is the first argument in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Notes",
  CellTags->"CellularAutomaton::rnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::rnum"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["{}", "MR"],
  " is not a valid rule specification."
}], "Text",
  CellTags->"CellularAutomaton::rnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::rnum"],

Cell[BoxData[
    \(CellularAutomaton::"rnum" \(\(:\)\(\ \)\) 
      "List of length between 1 and 3 expected for the rule specification \
\!\({}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::rnum"],

Cell[BoxData[
    \(CellularAutomaton[{}, {0, 1, 0}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::rnum"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid rule specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::rnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::rnum"],

Cell[BoxData[
    \({{0, 1, 0}, {1, 0, 0}, {0, 0, 1}, {0, 1, 0}, {1, 0, 0}, {0, 0, 
        1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::rnum"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::rsize", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::rsize"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"rsize"\), \(\(:\)\(\ \)\), "The", " ", 
      "specified", " ", "rule", " ", "number", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "greater", " ", "than", " ", "the", " ", 
      "largest", " ", "possible", " ", "rule", " ", "number", " ", 
      RowBox[{
        RowBox[{"(", 
          StyleBox["max",
            "TI"], ")"}], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::rsize"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated rule number is larger \
than the maximum value.\n\[FilledSmallSquare] The rule number is first \
argument in ",
  StyleBox["CellularAutomaton", "MR"],
  ", or the first element of the first argument if that argument is a list."
}], "Notes",
  CellTags->"CellularAutomaton::rsize"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::rsize"],

Cell["\<\
An error occurs in this example because the rule number is too \
large.\
\>", "Text",
  CellTags->"CellularAutomaton::rsize"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[999, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::rsize"],

Cell[BoxData[
    \(CellularAutomaton::"rsize" \(\(:\)\(\ \)\) 
      "The specified rule number \!\(999\) is greater than the largest \
possible rule number (\!\(255\))."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::rsize"],

Cell[BoxData[
    \(CellularAutomaton[999, {0, 1, 0}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::rsize"]
}, Open  ]],

Cell[TextData[{
  "This shows an input to ",
  StyleBox["CellularAutomaton", "MR"],
  " with a valid rule number."
}], "Text",
  CellTags->"CellularAutomaton::rsize"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[157, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::rsize"],

Cell[BoxData[
    \({{0, 1, 0}, {0, 1, 1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 0}, {0, 1, 
        1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::rsize"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::nspec", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::nspec"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"nspec"\), \(\(:\)\(\ \)\), "Rule", " ", 
      "number", " ", "specification", " ", 
      RowBox[{"(", 
        RowBox[{"n", " ", "or", " ", 
          RowBox[{\({n1, \ n2, \  ... }\), " ", "[", 
            RowBox[{"0", " ", "<=", " ", "ni", " ", "<", " ", 
              StyleBox["nmax",
                "TI"]}], "]"}]}], ")"}], " ", "expected", " ", "at", " ", 
      "position", " ", "1", " ", "in", " ", "the", " ", "rule", " ", 
      "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::nspec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the rule number specified in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the required form.\n\[FilledSmallSquare] The rule number is \
specified in the first argument of ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Notes",
  CellTags->"CellularAutomaton::nspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::nspec"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid rule number."
}], "Text",
  CellTags->"CellularAutomaton::nspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{None, 2}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::nspec"],

Cell[BoxData[
    \(CellularAutomaton::"nspec" \(\(:\)\(\ \)\) 
      "Rule number specification (n or {n1, n2, ...} [0 <= ni < \!\(1\)]) \
expected at position 1 in the rule specification \!\({None, 2}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::nspec"],

Cell[BoxData[
    \(CellularAutomaton[{None, 2}, {0, 1, 0}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::nspec"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid rule specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::nspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{1, 2}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::nspec"],

Cell[BoxData[
    \({{0, 1, 0}, {0, 0, 0}, {1, 1, 1}, {0, 0, 0}, {1, 1, 1}, {0, 0, 
        0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::nspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::wtlen", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::wtlen"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"wtlen"\), \(\(:\)\(\ \)\), "The", " ", 
      "number", " ", "of", " ", "weights", " ", "specified", " ", 
      RowBox[{"(", 
        StyleBox["n1",
          "TI"], ")"}], " ", "does", " ", "not", " ", "match", " ", "the", 
      " ", "number", " ", "of", " ", "kernel", " ", "elements", " ", 
      RowBox[{
        RowBox[{"(", 
          StyleBox["n2",
            "TI"], ")"}], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::wtlen"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the length of the weight specification \
does not match the length of the initial condition.\n\[FilledSmallSquare] The \
weight specification is the second element in the color specification. The \
color specification is the second element in the first argument of ",
  StyleBox["CellularAutomaton", "MR"],
  ".\n\[FilledSmallSquare] The initial condition is the second argument in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Notes",
  CellTags->"CellularAutomaton::wtlen"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::wtlen"],

Cell["\<\
An error occurs in this example because there are three kernel \
elements and only two weights are specified.\
\>", "Text",
  CellTags->"CellularAutomaton::wtlen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2, {2, {2, 1}}}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::wtlen"],

Cell[BoxData[
    \(CellularAutomaton::"wtlen" \(\(:\)\(\ \)\) 
      "The number of weights specified (\!\(2\)) does not match the number of \
kernel elements (\!\(3\))."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::wtlen"],

Cell[BoxData[
    \(CellularAutomaton[{2, {2, {2, 1}}}, {0, 1, 0}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::wtlen"]
}, Open  ]],

Cell[TextData[{
  "This shows an input to ",
  StyleBox["CellularAutomaton", "MR"],
  " with a valid weight specification."
}], "Text",
  CellTags->"CellularAutomaton::wtlen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2, {2, {2, 1, 2}}}, {0, 1, 0}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::wtlen"],

Cell[BoxData[
    \({{0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
        0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::wtlen"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::initg", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::initg"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"initg"\), \(\(:\)\(\ \)\), "Initial", " ", 
      "condition", " ", "specification", 
      " ", \((aspec\ or\ {aspec, \ bspec})\), " ", "expected", " ", "for", 
      " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::initg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the initial condition specification in \
",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the correct form.\n\[FilledSmallSquare] The initial \
condition specification is the second argument in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Notes",
  CellTags->"CellularAutomaton::initg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::initg"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["{}", "MR"],
  " is not a valid initial condition."
}], "Text",
  CellTags->"CellularAutomaton::initg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[3, {}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::initg"],

Cell[BoxData[
    \(CellularAutomaton::"initg" \(\(:\)\(\ \)\) 
      "Initial condition specification (aspec or {aspec, bspec}) expected for \
\!\({}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::initg"],

Cell[BoxData[
    \(CellularAutomaton[3, {}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::initg"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid initial condition specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::initg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[3, {1, 0, 1}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::initg"],

Cell[BoxData[
    \({{1, 0, 1}, {0, 0, 0}, {1, 1, 1}, {0, 0, 0}, {1, 1, 1}, {0, 0, 
        0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::initg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::bgrnd", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(CellularAutomaton::"bgrnd"\), \(\(:\)\(\ \)\), "Tensor", " ", 
        "of", " ", "rank", " ", 
        StyleBox["r",
          "TI"], " ", "with", " ", "elements", " ", "0"}], " ", "<=", " ", 
      "e", " ", "<", " ", 
      RowBox[{
        StyleBox["max",
          "TI"], " ", "expected", " ", "at", " ", "position", " ", "2", " ", 
        "of", " ", "the", " ", "initial", " ", "condition", " ", 
        "specification", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::bgrnd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the initial condition specification in \
",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the correct form.\n\[FilledSmallSquare] The initial \
condition specification is the second argument in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Notes",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::bgrnd"],

Cell["\<\
This input generates an error because the elements in the initial \
condition specification are too large.\
\>", "Text",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[2, {2, 3}, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[BoxData[
    \(CellularAutomaton::"bgrnd" \(\(:\)\(\ \)\) 
      "Tensor of rank \!\(1\) with elements 0 <= e < \!\(2\) expected at \
position 2 of the initial condition specification \!\({2, 3}\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[BoxData[
    \(CellularAutomaton[2, {2, 3}, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::bgrnd"]
}, Open  ]],

Cell["\<\
The same initial condition specification can be used if the number \
of colors is sufficiently large.\
\>", "Text",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{2, 4}, {2, 3}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[BoxData[
    \({{2, 3}, {0, 0}, {2, 2}, {0, 0}, {2, 2}, {0, 0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::bgrnd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::stateg", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::stateg"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"stateg"\), \(\(:\)\(\ \)\), "State", " ", 
      "specification", 
      " ", \((aspec\ or\ {{aspec1, \ off1}, \ {aspec2, \ off2}, \  ... })\), 
      " ", "expected", " ", "at", " ", "position", " ", "1", " ", "of", " ", 
      "the", " ", "initial", " ", "condition", " ", "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::stateg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " is a list with two elements, and the first of those elements does not \
have an expected form.\n\[FilledSmallSquare] The second argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " is the initial condition specification. The first element in the initial \
condition specification is the state specification.\n\[FilledSmallSquare] \
Valid  forms for the initial condition and state specifications are described \
in the documentation for the ",
  StyleBox["CellularAutomaton", "MR"],
  " function."
}], "Notes",
  CellTags->"CellularAutomaton::stateg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::stateg"],

Cell[TextData[{
  "An error occurs in this example because the first element in the second \
argument of ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have an expected form."
}], "Text",
  CellTags->"CellularAutomaton::stateg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {1, {0}}, 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::stateg"],

Cell[BoxData[
    \(CellularAutomaton::"stateg" \(\(:\)\(\ \)\) 
      "State specification (aspec or {{aspec1, off1}, {aspec2, off2}, ...}) \
expected at position 1 of the initial condition specification \!\({1, \(\({0}\
\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::stateg"],

Cell[BoxData[
    \(CellularAutomaton[30, {1, {0}}, 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::stateg"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid initial condition specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::stateg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{1, 0, 1}, {1}}, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::stateg"],

Cell[BoxData[
    \({{1, 0, 1, 1, 1}, {0, 0, 1, 0, 0}, {0, 1, 1, 1, 0}, {1, 1, 0, 0, 
        1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::stateg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::state", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::state"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(CellularAutomaton::"state"\), \(\(:\)\(\ \)\), "Tensor", " ", 
        "of", " ", "rank", " ", 
        StyleBox["n",
          "TI"], " ", "with", " ", "elements", " ", "0"}], " ", "<=", " ", 
      "e", " ", "<", " ", 
      RowBox[{
        StyleBox["max",
          "TI"], " ", "expected", " ", "for", " ", "the", " ", "state", " ", 
        "in", " ", "element", " ", 
        StyleBox["elem",
          "TI"], " ", "of", " ", "the", " ", "state", " ", "block", " ", 
        "specification", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::state"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first element in the second \
argument of ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have an expected form.\n\[FilledSmallSquare] The second argument \
in ",
  StyleBox["CellularAutomaton", "MR"],
  " is the initial condition specification. The first element in the initial \
condition specification is the state specification.\n\[FilledSmallSquare] \
Valid  forms for the initial condition and state specifications are described \
in the documentation for the ",
  StyleBox["CellularAutomaton", "MR"],
  " function."
}], "Notes",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::state"],

Cell[TextData[{
  "An error occurs in this example because of the inconsistent depth of the \
nested lists in the first element of the second argument of ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{{{1}, {1}}, {1, 3}}, {0}}, 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::state"],

Cell[BoxData[
    \(CellularAutomaton::"state" \(\(:\)\(\ \)\) 
      "Tensor of rank \!\(1\) with elements 0 <= e < \!\(2\) expected for the \
state in element \!\(2\) of the state block specification \!\({\(\({\(\({1}\)\
\), \(\({1}\)\)}\)\), \(\({1, 3}\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::state"],

Cell[BoxData[
    \(CellularAutomaton[30, {{{{1}, {1}}, {1, 3}}, {0}}, 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::state"]
}, Open  ]],

Cell["\<\
This message can also be generated if one of the values in the \
state specification is not in the expected range.\
\>", "Text",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{{{2}, {1}}, {{1}, {3}}}, {0}}, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::state"],

Cell[BoxData[
    \(CellularAutomaton::"state" \(\(:\)\(\ \)\) 
      "Tensor of rank \!\(1\) with elements 0 <= e < \!\(2\) expected for the \
state in element \!\(1\) of the state block specification \!\({\(\({\(\({2}\)\
\), \(\({1}\)\)}\)\), \(\({\(\({1}\)\), \(\({3}\)\)}\)\)}\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CellularAutomaton::state"],

Cell[BoxData[
    \(CellularAutomaton[30, {{{{2}, {1}}, {{1}, {3}}}, {0}}, 3]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::state"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid initial condition and state specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{{{1}, {1}}, {{1}, {3}}}, {0}}, 3]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CellularAutomaton::state"],

Cell[BoxData[
    \({{0, 0, 0, 1, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 1, 0, 0}, {0, 1, 1, 0, 
        0, 1, 0, 1, 0}, {1, 1, 0, 1, 1, 1, 0, 1, 1}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CellularAutomaton::state"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::offg", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::offg"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"offg"\), \(\(:\)\(\ \)\), "Offset", " ", 
      "specification", " ", \(({offt, \ offx1, \ offx2, \  ... })\), " ", 
      "expected", " ", "for", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::offg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the fourth argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have an expected form.\n\[FilledSmallSquare] The fourth argument \
in ",
  StyleBox["CellularAutomaton", "MR"],
  " is the offset specification."
}], "Notes",
  CellTags->"CellularAutomaton::offg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::offg"],

Cell["\<\
An error is generated in this example because an empty list is not \
a valid offset specification.\
\>", "Text",
  CellTags->"CellularAutomaton::offg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{1}, {0}}, 3, {}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::offg"],

Cell[BoxData[
    \(CellularAutomaton::"offg" \(\(:\)\(\ \)\) 
      "Offset specification ({offt, offx1, offx2, ...}) expected for \
\!\({}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::offg"],

Cell[BoxData[
    \(CellularAutomaton[30, {{1}, {0}}, 3, {}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::offg"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct offset specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::offg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{1}, {0}}, 3, {3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::offg"],

Cell[BoxData[
    \({{0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0}, {0, 1, 1, 0, 0, 1, 
        0}, {1, 1, 0, 1, 1, 1, 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::offg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::ovflw", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::ovflw"],

Cell[BoxData[
    \(CellularAutomaton::"ovflw" \(\(:\)\(\ \)\) \(The\ specified\ automaton\ \
rule\ is\ too\ large\ to\ be\ \(\(computed\)\(.\)\)\)\)], "Message",
  CellTags->"CellularAutomaton::ovflw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the rule specified in the first \
argument of ",
  StyleBox["CellularAutomaton", "MR"],
  " corresponds to an internal table that would exceed the capacity of the \
computer."
}], "Notes",
  CellTags->"CellularAutomaton::ovflw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::ovflw"],

Cell[TextData[{
  "An error occurs in this example because the number of colors and the range \
specified in the first argument of ",
  StyleBox["CellularAutomaton", "MR"],
  " would require a very large rule lookup table."
}], "Text",
  CellTags->"CellularAutomaton::ovflw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{4, 30, 30}, {1, 2, 1}, 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::ovflw"],

Cell[BoxData[
    \(CellularAutomaton::"ovflw" \(\(:\)\(\ \)\) 
      "The specified automaton rule is too large to be computed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::ovflw"],

Cell[BoxData[
    \(CellularAutomaton[{4, 30, 30}, {1, 2, 1}, 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::ovflw"]
}, Open  ]],

Cell[TextData[{
  "This shows a viable rule specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::ovflw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[{30, 4, 4}, {0, 2, 1}, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::ovflw"],

Cell[BoxData[
    \({{0, 2, 1}, {0, 0, 0}, {2, 2, 2}, {0, 0, 0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::ovflw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::steps", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::steps"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"steps"\), \(\(:\)\(\ \)\), "Positive", " ", 
      "integer", " ", "expected", " ", "for", " ", "the", " ", "number", " ", 
      "of", " ", "steps", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::steps"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"CellularAutomaton::steps"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::steps"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the number of steps in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::steps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[3, {1, 0, 1}, None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::steps"],

Cell[BoxData[
    \(CellularAutomaton::"steps" \(\(:\)\(\ \)\) 
      "Positive integer expected for the number of steps \!\(None\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::steps"],

Cell[BoxData[
    \(CellularAutomaton[3, {1, 0, 1}, None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::steps"]
}, Open  ]],

Cell["The number of steps can be a positive integer.", "Text",
  CellTags->"CellularAutomaton::steps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[3, {1, 0, 1}, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::steps"],

Cell[BoxData[
    \({{1, 0, 1}, {0, 0, 0}, {1, 1, 1}, {0, 0, 0}, {1, 1, 1}, {0, 0, 
        0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::steps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::stoff", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::stoff"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"stoff"\), \(\(:\)\(\ \)\), "Offset", " ", 
      "specification", " ", \(({n1, \ n2, \  ... })\), " ", "of", " ", 
      "length", " ", 
      StyleBox["len",
        "TI"], " ", "expected", " ", "in", " ", "element", " ", 
      StyleBox["expr",
        "TI"], " ", "of", " ", "the", " ", "state", " ", "block", " ", 
      "specification", " ", \(\(`3`\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::stoff"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first part of the second argument \
in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have an expected form.\n\[FilledSmallSquare] The second argument \
in ",
  StyleBox["CellularAutomaton", "MR"],
  " is the initial condition specification. The first element in the initial \
condition specification is the state specification, which can include both \
the initial state and a spatial offset specification.\n\[FilledSmallSquare] \
See the documentation for ",
  StyleBox["CellularAutomaton", "MR"],
  " for information on valid forms for the initial condition and state \
specifications."
}], "Notes",
  CellTags->"CellularAutomaton::stoff"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::stoff"],

Cell[TextData[{
  "An error occurs in this example because the structure of the offset \
specification in the first part of the second argument of ",
  StyleBox["CellularAutomaton", "MR"],
  " does not match the structure of the state specification."
}], "Text",
  CellTags->"CellularAutomaton::stoff"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{{{1}, {1}}, {{1}, 0}}, {0}}, 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::stoff"],

Cell[BoxData[
    \(CellularAutomaton::"stoff" \(\(:\)\(\ \)\) 
      "Offset specification ({n1, n2, ...}) of length \!\(1\) expected in \
element \!\(2\) of the state block specification \!\({\(\({\(\({1}\)\), \
\(\({1}\)\)}\)\), \(\({\(\({1}\)\), 0}\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::stoff"],

Cell[BoxData[
    \(CellularAutomaton[30, {{{{1}, {1}}, {{1}, 0}}, {0}}, 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::stoff"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid state and offset specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::stoff"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CellularAutomaton[30, {{{{1}, {1}}, {{1}, {0}}}, {0}}, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::stoff"],

Cell[BoxData[
    \({{0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 1, 0, 0}, {0, 1, 1, 0, 0, 1, 
        1, 0}, {1, 1, 0, 1, 1, 1, 0, 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::stoff"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::offtsqs", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"offtsqs"\), \(\(:\)\(\ \)\), "Sequence", 
      " ", "specification", 
      " ", \((\(+n\), \ \(-n\), \ {\(+n\)}, \ {\(-n\)}, \ {m, \ n}, \ 
        or\ {m, \ n, \ s})\), " ", "expected", " ", "for", " ", "the", " ", 
      "temporal", " ", "offset", " ", "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::offtsqs"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the fourth argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " does not have an expected form.\n\[FilledSmallSquare] The fourth argument \
in ",
  StyleBox["CellularAutomaton", "MR"],
  " is the temporal offset specification."
}], "Notes",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid temporal offset specification."
}], "Text",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CellularAutomaton", "[", 
      RowBox[{"30", ",", \({{1}, {0}}\), ",", "3", ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["None",
              FontColor->RGBColor[1, 0, 0]], ",", "1"}], "}"}]}], 
      "]"}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[BoxData[
    \(CellularAutomaton::"offtsqs" \(\(:\)\(\ \)\) 
      "Sequence specification (+n, -n, {+n}, {-n}, {m, n}, or {m, n, s}) \
expected for the temporal offset specification \!\(None\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[BoxData[
    \(CellularAutomaton[30, {{1}, {0}}, 3, {None, 1}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::offtsqs"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the fourth argument in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CellularAutomaton", "[", 
      RowBox[{"30", ",", \({{1}, {0}}\), ",", "3", ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["Automatic",
              FontColor->RGBColor[1, 0, 0]], ",", "1"}], "}"}]}], 
      "]"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[BoxData[
    \({{1, 0}, {1, 1}, {0, 0}, {1, 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::offtsqs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::xtake", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::xtake"],

Cell[BoxData[
    RowBox[{\(CellularAutomaton::"xtake"\), \(\(:\)\(\ \)\), "Cannot", " ", 
      "take", " ", "elements", " ", 
      StyleBox["n1",
        "TI"], " ", "through", " ", 
      RowBox[{
        StyleBox["n2",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CellularAutomaton::xtake"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the fourth argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " includes an invalid offset specification."
}], "Notes",
  CellTags->"CellularAutomaton::xtake"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::ttake", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::ttake"],

Cell[BoxData[
    \(CellularAutomaton::"ttake" \(\(:\)\(\ \)\) \(Cannot\ take\ steps\ `1`\ \
through\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"CellularAutomaton::ttake"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the fourth argument in ",
  StyleBox["CellularAutomaton", "MR"],
  " includes an invalid offset specification."
}], "Notes",
  CellTags->"CellularAutomaton::ttake"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CellularAutomaton::ttake"],

Cell["\<\
An error is generated in this example because the temporal offset \
specification includes elements that are not in a valid order.\
\>", "Text",
  CellTags->"CellularAutomaton::ttake"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CellularAutomaton", "[", 
      RowBox[{"30", ",", \({{1}, {0}}\), ",", "3", ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox[\({3, 2}\),
              FontColor->RGBColor[1, 0, 0]], ",", "Automatic"}], "}"}]}], 
      "]"}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CellularAutomaton::ttake"],

Cell[BoxData[
    \(CellularAutomaton::"ttake" \(\(:\)\(\ \)\) 
      "Cannot take steps \!\(3\) through \!\(2\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CellularAutomaton::ttake"],

Cell[BoxData[
    \(CellularAutomaton[30, {{1}, {0}}, 3, {{3, 2}, Automatic}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CellularAutomaton::ttake"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid temporal offset specification in ",
  StyleBox["CellularAutomaton", "MR"],
  "."
}], "Text",
  CellTags->"CellularAutomaton::ttake"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"CellularAutomaton", "[", 
      RowBox[{"30", ",", \({{1}, {0}}\), ",", "3", ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox[\({2, 3}\),
              FontColor->RGBColor[1, 0, 0]], ",", "Automatic"}], "}"}]}], 
      "]"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CellularAutomaton::ttake"],

Cell[BoxData[
    \({{0, 1, 1, 0, 0, 1, 0}, {1, 1, 0, 1, 1, 1, 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CellularAutomaton::ttake"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CellularAutomaton::offxsqs", "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::offxsqs"],

Cell[BoxData[
    \(CellularAutomaton::"offxsqs" \(\(:\)\(\ \)\) \(Sequence\ specification\ \
\((\(+n\), \ \(-n\), \ {\(+n\)}, \ {\(-n\)}, \ {m, \ n}, \ 
          or\ {m, \ n, \ 
              s})\)\ expected\ for\ the\ spatial\ offset\ specification\ \
\(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"CellularAutomaton::offxsqs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"CellularAutomaton::offxsqs"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 977}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{641, 517},
WindowMargins->{{Automatic, 21}, {Automatic, 93}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "CellularAutomaton::rspec"->{
    Cell[1835, 57, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::rspec"],
    Cell[1939, 60, 493, 11, 53, "Message",
      CellTags->"CellularAutomaton::rspec"],
    Cell[2435, 73, 258, 6, 40, "Notes",
      CellTags->"CellularAutomaton::rspec"],
    Cell[2718, 83, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::rspec"],
    Cell[2795, 86, 185, 5, 24, "Text",
      CellTags->"CellularAutomaton::rspec"],
    Cell[3005, 95, 140, 3, 26, "Input",
      CellTags->"CellularAutomaton::rspec"],
    Cell[3148, 100, 298, 6, 53, "Message",
      CellTags->"CellularAutomaton::rspec"],
    Cell[3449, 108, 141, 3, 21, "Output",
      CellTags->"CellularAutomaton::rspec"],
    Cell[3605, 114, 148, 5, 24, "Text",
      CellTags->"CellularAutomaton::rspec"],
    Cell[3778, 123, 139, 3, 26, "Input",
      CellTags->"CellularAutomaton::rspec"],
    Cell[3920, 128, 173, 4, 21, "Output",
      CellTags->"CellularAutomaton::rspec"]},
  "CellularAutomaton::wtspec"->{
    Cell[4154, 139, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[4260, 142, 571, 13, 53, "Message",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[4834, 157, 525, 10, 84, "Notes",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[5384, 171, 75, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[5462, 174, 182, 5, 24, "Text",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[5669, 183, 145, 3, 26, "Input",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[5817, 188, 329, 6, 69, "Message",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[6149, 196, 146, 3, 21, "Output",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[6310, 202, 162, 5, 24, "Text",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[6497, 211, 150, 3, 26, "Input",
      CellTags->"CellularAutomaton::wtspec"],
    Cell[6650, 216, 174, 4, 21, "Output",
      CellTags->"CellularAutomaton::wtspec"]},
  "CellularAutomaton::kspec"->{
    Cell[6885, 227, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::kspec"],
    Cell[6989, 230, 570, 13, 37, "Message",
      CellTags->"CellularAutomaton::kspec"],
    Cell[7562, 245, 357, 8, 46, "Notes",
      CellTags->"CellularAutomaton::kspec"],
    Cell[7944, 257, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::kspec"],
    Cell[8021, 260, 149, 4, 24, "Text",
      CellTags->"CellularAutomaton::kspec"],
    Cell[8195, 268, 136, 3, 26, "Input",
      CellTags->"CellularAutomaton::kspec"],
    Cell[8334, 273, 293, 6, 53, "Message",
      CellTags->"CellularAutomaton::kspec"],
    Cell[8630, 281, 137, 3, 21, "Output",
      CellTags->"CellularAutomaton::kspec"],
    Cell[8782, 287, 101, 1, 24, "Text",
      CellTags->"CellularAutomaton::kspec"],
    Cell[8908, 292, 136, 3, 26, "Input",
      CellTags->"CellularAutomaton::kspec"],
    Cell[9047, 297, 173, 4, 21, "Output",
      CellTags->"CellularAutomaton::kspec"]},
  "CellularAutomaton::nocol"->{
    Cell[9281, 308, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::nocol"],
    Cell[9385, 311, 430, 10, 37, "Message",
      CellTags->"CellularAutomaton::nocol"],
    Cell[9818, 323, 438, 9, 78, "Notes",
      CellTags->"CellularAutomaton::nocol"],
    Cell[10281, 336, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::nocol"],
    Cell[10358, 339, 279, 8, 40, "Text",
      CellTags->"CellularAutomaton::nocol"],
    Cell[10662, 351, 182, 4, 26, "Input",
      CellTags->"CellularAutomaton::nocol"],
    Cell[10847, 357, 409, 7, 53, "Message",
      CellTags->"CellularAutomaton::nocol"],
    Cell[11259, 366, 251, 5, 21, "Output",
      CellTags->"CellularAutomaton::nocol"],
    Cell[11525, 374, 197, 5, 24, "Text",
      CellTags->"CellularAutomaton::nocol"],
    Cell[11747, 383, 178, 4, 26, "Input",
      CellTags->"CellularAutomaton::nocol"],
    Cell[11928, 389, 335, 6, 53, "Output",
      CellTags->"CellularAutomaton::nocol"]},
  "CellularAutomaton::gkspec"->{
    Cell[12324, 402, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[12430, 405, 486, 11, 53, "Message",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[12919, 418, 354, 8, 46, "Notes",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[13298, 430, 75, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[13376, 433, 175, 4, 24, "Text",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[13576, 441, 145, 3, 26, "Input",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[13724, 446, 297, 6, 53, "Message",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[14024, 454, 146, 3, 21, "Output",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[14185, 460, 104, 1, 24, "Text",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[14314, 465, 150, 3, 26, "Input",
      CellTags->"CellularAutomaton::gkspec"],
    Cell[14467, 470, 174, 4, 21, "Output",
      CellTags->"CellularAutomaton::gkspec"]},
  "CellularAutomaton::rnum"->{
    Cell[14702, 481, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::rnum"],
    Cell[14804, 484, 427, 10, 37, "Message",
      CellTags->"CellularAutomaton::rnum"],
    Cell[15234, 496, 332, 8, 46, "Notes",
      CellTags->"CellularAutomaton::rnum"],
    Cell[15591, 508, 73, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::rnum"],
    Cell[15667, 511, 176, 5, 24, "Text",
      CellTags->"CellularAutomaton::rnum"],
    Cell[15868, 520, 131, 3, 26, "Input",
      CellTags->"CellularAutomaton::rnum"],
    Cell[16002, 525, 232, 5, 37, "Message",
      CellTags->"CellularAutomaton::rnum"],
    Cell[16237, 532, 132, 3, 21, "Output",
      CellTags->"CellularAutomaton::rnum"],
    Cell[16384, 538, 158, 5, 24, "Text",
      CellTags->"CellularAutomaton::rnum"],
    Cell[16567, 547, 132, 3, 26, "Input",
      CellTags->"CellularAutomaton::rnum"],
    Cell[16702, 552, 172, 4, 21, "Output",
      CellTags->"CellularAutomaton::rnum"]},
  "CellularAutomaton::rsize"->{
    Cell[16935, 563, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::rsize"],
    Cell[17039, 566, 506, 12, 37, "Message",
      CellTags->"CellularAutomaton::rsize"],
    Cell[17548, 580, 349, 7, 62, "Notes",
      CellTags->"CellularAutomaton::rsize"],
    Cell[17922, 591, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::rsize"],
    Cell[17999, 594, 135, 4, 24, "Text",
      CellTags->"CellularAutomaton::rsize"],
    Cell[18159, 602, 133, 3, 26, "Input",
      CellTags->"CellularAutomaton::rsize"],
    Cell[18295, 607, 255, 5, 37, "Message",
      CellTags->"CellularAutomaton::rsize"],
    Cell[18553, 614, 134, 3, 21, "Output",
      CellTags->"CellularAutomaton::rsize"],
    Cell[18702, 620, 166, 5, 24, "Text",
      CellTags->"CellularAutomaton::rsize"],
    Cell[18893, 629, 133, 3, 26, "Input",
      CellTags->"CellularAutomaton::rsize"],
    Cell[19029, 634, 173, 4, 21, "Output",
      CellTags->"CellularAutomaton::rsize"]},
  "CellularAutomaton::nspec"->{
    Cell[19263, 645, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::nspec"],
    Cell[19367, 648, 682, 16, 53, "Message",
      CellTags->"CellularAutomaton::nspec"],
    Cell[20052, 666, 341, 8, 46, "Notes",
      CellTags->"CellularAutomaton::nspec"],
    Cell[20418, 678, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::nspec"],
    Cell[20495, 681, 172, 5, 24, "Text",
      CellTags->"CellularAutomaton::nspec"],
    Cell[20692, 690, 139, 3, 26, "Input",
      CellTags->"CellularAutomaton::nspec"],
    Cell[20834, 695, 292, 6, 53, "Message",
      CellTags->"CellularAutomaton::nspec"],
    Cell[21129, 703, 140, 3, 21, "Output",
      CellTags->"CellularAutomaton::nspec"],
    Cell[21284, 709, 159, 5, 24, "Text",
      CellTags->"CellularAutomaton::nspec"],
    Cell[21468, 718, 136, 3, 26, "Input",
      CellTags->"CellularAutomaton::nspec"],
    Cell[21607, 723, 173, 4, 21, "Output",
      CellTags->"CellularAutomaton::nspec"]},
  "CellularAutomaton::wtlen"->{
    Cell[21841, 734, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[21945, 737, 544, 13, 37, "Message",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[22492, 752, 537, 10, 84, "Notes",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[23054, 766, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[23131, 769, 173, 4, 24, "Text",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[23329, 777, 146, 3, 26, "Input",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[23478, 782, 255, 5, 37, "Message",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[23736, 789, 147, 3, 21, "Output",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[23898, 795, 175, 5, 24, "Text",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[24098, 804, 149, 3, 26, "Input",
      CellTags->"CellularAutomaton::wtlen"],
    Cell[24250, 809, 173, 4, 21, "Output",
      CellTags->"CellularAutomaton::wtlen"]},
  "CellularAutomaton::initg"->{
    Cell[24484, 820, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::initg"],
    Cell[24588, 823, 391, 10, 37, "Message",
      CellTags->"CellularAutomaton::initg"],
    Cell[24982, 835, 360, 9, 46, "Notes",
      CellTags->"CellularAutomaton::initg"],
    Cell[25367, 848, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::initg"],
    Cell[25444, 851, 176, 5, 24, "Text",
      CellTags->"CellularAutomaton::initg"],
    Cell[25645, 860, 124, 3, 26, "Input",
      CellTags->"CellularAutomaton::initg"],
    Cell[25772, 865, 238, 5, 37, "Message",
      CellTags->"CellularAutomaton::initg"],
    Cell[26013, 872, 125, 3, 21, "Output",
      CellTags->"CellularAutomaton::initg"],
    Cell[26153, 878, 172, 5, 24, "Text",
      CellTags->"CellularAutomaton::initg"],
    Cell[26350, 887, 131, 3, 26, "Input",
      CellTags->"CellularAutomaton::initg"],
    Cell[26484, 892, 173, 4, 21, "Output",
      CellTags->"CellularAutomaton::initg"]},
  "CellularAutomaton::bgrnd"->{
    Cell[26718, 903, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[26822, 906, 655, 17, 37, "Message",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[27480, 925, 360, 9, 46, "Notes",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[27865, 938, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[27942, 941, 170, 4, 24, "Text",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[28137, 949, 128, 3, 26, "Input",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[28268, 954, 289, 6, 53, "Message",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[28560, 962, 129, 3, 21, "Output",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[28704, 968, 165, 4, 24, "Text",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[28894, 976, 133, 3, 26, "Input",
      CellTags->"CellularAutomaton::bgrnd"],
    Cell[29030, 981, 146, 3, 21, "Output",
      CellTags->"CellularAutomaton::bgrnd"]},
  "CellularAutomaton::stateg"->{
    Cell[29237, 991, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::stateg"],
    Cell[29343, 994, 516, 11, 53, "Message",
      CellTags->"CellularAutomaton::stateg"],
    Cell[29862, 1007, 680, 13, 116, "Notes",
      CellTags->"CellularAutomaton::stateg"],
    Cell[30567, 1024, 75, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::stateg"],
    Cell[30645, 1027, 236, 6, 40, "Text",
      CellTags->"CellularAutomaton::stateg"],
    Cell[30906, 1037, 132, 3, 26, "Input",
      CellTags->"CellularAutomaton::stateg"],
    Cell[31041, 1042, 316, 6, 53, "Message",
      CellTags->"CellularAutomaton::stateg"],
    Cell[31360, 1050, 133, 3, 21, "Output",
      CellTags->"CellularAutomaton::stateg"],
    Cell[31508, 1056, 173, 5, 24, "Text",
      CellTags->"CellularAutomaton::stateg"],
    Cell[31706, 1065, 140, 3, 26, "Input",
      CellTags->"CellularAutomaton::stateg"],
    Cell[31849, 1070, 176, 4, 21, "Output",
      CellTags->"CellularAutomaton::stateg"]},
  "CellularAutomaton::state"->{
    Cell[32086, 1081, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::state"],
    Cell[32190, 1084, 724, 19, 37, "Message",
      CellTags->"CellularAutomaton::state"],
    Cell[32917, 1105, 641, 14, 116, "Notes",
      CellTags->"CellularAutomaton::state"],
    Cell[33583, 1123, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::state"],
    Cell[33660, 1126, 253, 6, 40, "Text",
      CellTags->"CellularAutomaton::state"],
    Cell[33938, 1136, 150, 3, 26, "Input",
      CellTags->"CellularAutomaton::state"],
    Cell[34091, 1141, 348, 6, 53, "Message",
      CellTags->"CellularAutomaton::state"],
    Cell[34442, 1149, 151, 3, 21, "Output",
      CellTags->"CellularAutomaton::state"],
    Cell[34608, 1155, 178, 4, 24, "Text",
      CellTags->"CellularAutomaton::state"],
    Cell[34811, 1163, 154, 3, 26, "Input",
      CellTags->"CellularAutomaton::state"],
    Cell[34968, 1168, 368, 6, 53, "Message",
      CellTags->"CellularAutomaton::state"],
    Cell[35339, 1176, 155, 3, 21, "Output",
      CellTags->"CellularAutomaton::state"],
    Cell[35509, 1182, 182, 5, 24, "Text",
      CellTags->"CellularAutomaton::state"],
    Cell[35716, 1191, 154, 3, 26, "Input",
      CellTags->"CellularAutomaton::state"],
    Cell[35873, 1196, 223, 4, 37, "Output",
      CellTags->"CellularAutomaton::state"]},
  "CellularAutomaton::offg"->{
    Cell[36157, 1207, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::offg"],
    Cell[36259, 1210, 369, 9, 37, "Message",
      CellTags->"CellularAutomaton::offg"],
    Cell[36631, 1221, 330, 8, 46, "Notes",
      CellTags->"CellularAutomaton::offg"],
    Cell[36986, 1233, 73, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::offg"],
    Cell[37062, 1236, 161, 4, 24, "Text",
      CellTags->"CellularAutomaton::offg"],
    Cell[37248, 1244, 136, 3, 26, "Input",
      CellTags->"CellularAutomaton::offg"],
    Cell[37387, 1249, 227, 5, 37, "Message",
      CellTags->"CellularAutomaton::offg"],
    Cell[37617, 1256, 137, 3, 21, "Output",
      CellTags->"CellularAutomaton::offg"],
    Cell[37769, 1262, 162, 5, 24, "Text",
      CellTags->"CellularAutomaton::offg"],
    Cell[37956, 1271, 137, 3, 26, "Input",
      CellTags->"CellularAutomaton::offg"],
    Cell[38096, 1276, 198, 4, 37, "Output",
      CellTags->"CellularAutomaton::offg"]},
  "CellularAutomaton::ovflw"->{
    Cell[38355, 1287, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[38459, 1290, 202, 3, 37, "Message",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[38664, 1295, 283, 7, 40, "Notes",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[38972, 1306, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[39049, 1309, 275, 6, 40, "Text",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[39349, 1319, 141, 3, 26, "Input",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[39493, 1324, 215, 5, 37, "Message",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[39711, 1331, 142, 3, 21, "Output",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[39868, 1337, 160, 5, 24, "Text",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[40053, 1346, 140, 3, 26, "Input",
      CellTags->"CellularAutomaton::ovflw"],
    Cell[40196, 1351, 142, 3, 21, "Output",
      CellTags->"CellularAutomaton::ovflw"]},
  "CellularAutomaton::steps"->{
    Cell[40399, 1361, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::steps"],
    Cell[40503, 1364, 373, 9, 37, "Message",
      CellTags->"CellularAutomaton::steps"],
    Cell[40879, 1375, 210, 5, 24, "Notes",
      CellTags->"CellularAutomaton::steps"],
    Cell[41114, 1384, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::steps"],
    Cell[41191, 1387, 239, 7, 40, "Text",
      CellTags->"CellularAutomaton::steps"],
    Cell[41455, 1398, 134, 3, 26, "Input",
      CellTags->"CellularAutomaton::steps"],
    Cell[41592, 1403, 219, 5, 37, "Message",
      CellTags->"CellularAutomaton::steps"],
    Cell[41814, 1410, 135, 3, 21, "Output",
      CellTags->"CellularAutomaton::steps"],
    Cell[41964, 1416, 102, 1, 24, "Text",
      CellTags->"CellularAutomaton::steps"],
    Cell[42091, 1421, 131, 3, 26, "Input",
      CellTags->"CellularAutomaton::steps"],
    Cell[42225, 1426, 173, 4, 21, "Output",
      CellTags->"CellularAutomaton::steps"]},
  "CellularAutomaton::stoff"->{
    Cell[42459, 1437, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::stoff"],
    Cell[42563, 1440, 518, 11, 37, "Message",
      CellTags->"CellularAutomaton::stoff"],
    Cell[43084, 1453, 709, 15, 132, "Notes",
      CellTags->"CellularAutomaton::stoff"],
    Cell[43818, 1472, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::stoff"],
    Cell[43895, 1475, 302, 6, 40, "Text",
      CellTags->"CellularAutomaton::stoff"],
    Cell[44222, 1485, 152, 3, 26, "Input",
      CellTags->"CellularAutomaton::stoff"],
    Cell[44377, 1490, 345, 6, 53, "Message",
      CellTags->"CellularAutomaton::stoff"],
    Cell[44725, 1498, 153, 3, 21, "Output",
      CellTags->"CellularAutomaton::stoff"],
    Cell[44893, 1504, 171, 5, 24, "Text",
      CellTags->"CellularAutomaton::stoff"],
    Cell[45089, 1513, 154, 3, 26, "Input",
      CellTags->"CellularAutomaton::stoff"],
    Cell[45246, 1518, 211, 4, 37, "Output",
      CellTags->"CellularAutomaton::stoff"]},
  "CellularAutomaton::offtsqs"->{
    Cell[45518, 1529, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[45626, 1532, 499, 11, 53, "Message",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[46128, 1545, 342, 8, 46, "Notes",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[46495, 1557, 76, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[46574, 1560, 192, 5, 24, "Text",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[46791, 1569, 335, 9, 26, "Input",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[47129, 1580, 286, 5, 53, "Message",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[47418, 1587, 147, 3, 21, "Output",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[47580, 1593, 172, 5, 24, "Text",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[47777, 1602, 340, 9, 26, "Input",
      CellTags->"CellularAutomaton::offtsqs"],
    Cell[48120, 1613, 132, 3, 21, "Output",
      CellTags->"CellularAutomaton::offtsqs"]},
  "CellularAutomaton::xtake"->{
    Cell[48313, 1623, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::xtake"],
    Cell[48417, 1626, 353, 10, 21, "Message",
      CellTags->"CellularAutomaton::xtake"],
    Cell[48773, 1638, 219, 5, 24, "Notes",
      CellTags->"CellularAutomaton::xtake"]},
  "CellularAutomaton::ttake"->{
    Cell[49029, 1648, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::ttake"],
    Cell[49133, 1651, 175, 3, 21, "Message",
      CellTags->"CellularAutomaton::ttake"],
    Cell[49311, 1656, 219, 5, 24, "Notes",
      CellTags->"CellularAutomaton::ttake"],
    Cell[49555, 1665, 74, 1, 38, "ExampleSection",
      CellTags->"CellularAutomaton::ttake"],
    Cell[49632, 1668, 194, 4, 40, "Text",
      CellTags->"CellularAutomaton::ttake"],
    Cell[49851, 1676, 345, 9, 26, "Input",
      CellTags->"CellularAutomaton::ttake"],
    Cell[50199, 1687, 198, 4, 21, "Message",
      CellTags->"CellularAutomaton::ttake"],
    Cell[50400, 1693, 155, 3, 21, "Output",
      CellTags->"CellularAutomaton::ttake"],
    Cell[50570, 1699, 170, 5, 24, "Text",
      CellTags->"CellularAutomaton::ttake"],
    Cell[50765, 1708, 345, 9, 26, "Input",
      CellTags->"CellularAutomaton::ttake"],
    Cell[51113, 1719, 144, 3, 21, "Output",
      CellTags->"CellularAutomaton::ttake"]},
  "CellularAutomaton::offxsqs"->{
    Cell[51318, 1729, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CellularAutomaton::offxsqs"],
    Cell[51426, 1732, 330, 6, 53, "Message",
      CellTags->"CellularAutomaton::offxsqs"],
    Cell[51759, 1740, 137, 4, 24, "Notes",
      CellTags->"CellularAutomaton::offxsqs"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"CellularAutomaton::rspec", 52599, 1765},
  {"CellularAutomaton::wtspec", 53606, 1788},
  {"CellularAutomaton::kspec", 54630, 1811},
  {"CellularAutomaton::nocol", 55642, 1834},
  {"CellularAutomaton::gkspec", 56663, 1857},
  {"CellularAutomaton::rnum", 57696, 1880},
  {"CellularAutomaton::rsize", 58707, 1903},
  {"CellularAutomaton::nspec", 59730, 1926},
  {"CellularAutomaton::wtlen", 60753, 1949},
  {"CellularAutomaton::initg", 61777, 1972},
  {"CellularAutomaton::bgrnd", 62800, 1995},
  {"CellularAutomaton::stateg", 63824, 2018},
  {"CellularAutomaton::state", 64869, 2041},
  {"CellularAutomaton::offg", 66258, 2072},
  {"CellularAutomaton::ovflw", 67279, 2095},
  {"CellularAutomaton::steps", 68312, 2118},
  {"CellularAutomaton::stoff", 69345, 2141},
  {"CellularAutomaton::offtsqs", 70383, 2164},
  {"CellularAutomaton::xtake", 71439, 2187},
  {"CellularAutomaton::ttake", 71759, 2194},
  {"CellularAutomaton::offxsqs", 72794, 2217}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 34, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1835, 57, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::rspec"],
Cell[1939, 60, 493, 11, 53, "Message",
  CellTags->"CellularAutomaton::rspec"],
Cell[2435, 73, 258, 6, 40, "Notes",
  CellTags->"CellularAutomaton::rspec"],

Cell[CellGroupData[{
Cell[2718, 83, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::rspec"],
Cell[2795, 86, 185, 5, 24, "Text",
  CellTags->"CellularAutomaton::rspec"],

Cell[CellGroupData[{
Cell[3005, 95, 140, 3, 26, "Input",
  CellTags->"CellularAutomaton::rspec"],
Cell[3148, 100, 298, 6, 53, "Message",
  CellTags->"CellularAutomaton::rspec"],
Cell[3449, 108, 141, 3, 21, "Output",
  CellTags->"CellularAutomaton::rspec"]
}, Open  ]],
Cell[3605, 114, 148, 5, 24, "Text",
  CellTags->"CellularAutomaton::rspec"],

Cell[CellGroupData[{
Cell[3778, 123, 139, 3, 26, "Input",
  CellTags->"CellularAutomaton::rspec"],
Cell[3920, 128, 173, 4, 21, "Output",
  CellTags->"CellularAutomaton::rspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4154, 139, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::wtspec"],
Cell[4260, 142, 571, 13, 53, "Message",
  CellTags->"CellularAutomaton::wtspec"],
Cell[4834, 157, 525, 10, 84, "Notes",
  CellTags->"CellularAutomaton::wtspec"],

Cell[CellGroupData[{
Cell[5384, 171, 75, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::wtspec"],
Cell[5462, 174, 182, 5, 24, "Text",
  CellTags->"CellularAutomaton::wtspec"],

Cell[CellGroupData[{
Cell[5669, 183, 145, 3, 26, "Input",
  CellTags->"CellularAutomaton::wtspec"],
Cell[5817, 188, 329, 6, 69, "Message",
  CellTags->"CellularAutomaton::wtspec"],
Cell[6149, 196, 146, 3, 21, "Output",
  CellTags->"CellularAutomaton::wtspec"]
}, Open  ]],
Cell[6310, 202, 162, 5, 24, "Text",
  CellTags->"CellularAutomaton::wtspec"],

Cell[CellGroupData[{
Cell[6497, 211, 150, 3, 26, "Input",
  CellTags->"CellularAutomaton::wtspec"],
Cell[6650, 216, 174, 4, 21, "Output",
  CellTags->"CellularAutomaton::wtspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6885, 227, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::kspec"],
Cell[6989, 230, 570, 13, 37, "Message",
  CellTags->"CellularAutomaton::kspec"],
Cell[7562, 245, 357, 8, 46, "Notes",
  CellTags->"CellularAutomaton::kspec"],

Cell[CellGroupData[{
Cell[7944, 257, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::kspec"],
Cell[8021, 260, 149, 4, 24, "Text",
  CellTags->"CellularAutomaton::kspec"],

Cell[CellGroupData[{
Cell[8195, 268, 136, 3, 26, "Input",
  CellTags->"CellularAutomaton::kspec"],
Cell[8334, 273, 293, 6, 53, "Message",
  CellTags->"CellularAutomaton::kspec"],
Cell[8630, 281, 137, 3, 21, "Output",
  CellTags->"CellularAutomaton::kspec"]
}, Open  ]],
Cell[8782, 287, 101, 1, 24, "Text",
  CellTags->"CellularAutomaton::kspec"],

Cell[CellGroupData[{
Cell[8908, 292, 136, 3, 26, "Input",
  CellTags->"CellularAutomaton::kspec"],
Cell[9047, 297, 173, 4, 21, "Output",
  CellTags->"CellularAutomaton::kspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9281, 308, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::nocol"],
Cell[9385, 311, 430, 10, 37, "Message",
  CellTags->"CellularAutomaton::nocol"],
Cell[9818, 323, 438, 9, 78, "Notes",
  CellTags->"CellularAutomaton::nocol"],

Cell[CellGroupData[{
Cell[10281, 336, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::nocol"],
Cell[10358, 339, 279, 8, 40, "Text",
  CellTags->"CellularAutomaton::nocol"],

Cell[CellGroupData[{
Cell[10662, 351, 182, 4, 26, "Input",
  CellTags->"CellularAutomaton::nocol"],
Cell[10847, 357, 409, 7, 53, "Message",
  CellTags->"CellularAutomaton::nocol"],
Cell[11259, 366, 251, 5, 21, "Output",
  CellTags->"CellularAutomaton::nocol"]
}, Open  ]],
Cell[11525, 374, 197, 5, 24, "Text",
  CellTags->"CellularAutomaton::nocol"],

Cell[CellGroupData[{
Cell[11747, 383, 178, 4, 26, "Input",
  CellTags->"CellularAutomaton::nocol"],
Cell[11928, 389, 335, 6, 53, "Output",
  CellTags->"CellularAutomaton::nocol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12324, 402, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::gkspec"],
Cell[12430, 405, 486, 11, 53, "Message",
  CellTags->"CellularAutomaton::gkspec"],
Cell[12919, 418, 354, 8, 46, "Notes",
  CellTags->"CellularAutomaton::gkspec"],

Cell[CellGroupData[{
Cell[13298, 430, 75, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::gkspec"],
Cell[13376, 433, 175, 4, 24, "Text",
  CellTags->"CellularAutomaton::gkspec"],

Cell[CellGroupData[{
Cell[13576, 441, 145, 3, 26, "Input",
  CellTags->"CellularAutomaton::gkspec"],
Cell[13724, 446, 297, 6, 53, "Message",
  CellTags->"CellularAutomaton::gkspec"],
Cell[14024, 454, 146, 3, 21, "Output",
  CellTags->"CellularAutomaton::gkspec"]
}, Open  ]],
Cell[14185, 460, 104, 1, 24, "Text",
  CellTags->"CellularAutomaton::gkspec"],

Cell[CellGroupData[{
Cell[14314, 465, 150, 3, 26, "Input",
  CellTags->"CellularAutomaton::gkspec"],
Cell[14467, 470, 174, 4, 21, "Output",
  CellTags->"CellularAutomaton::gkspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14702, 481, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::rnum"],
Cell[14804, 484, 427, 10, 37, "Message",
  CellTags->"CellularAutomaton::rnum"],
Cell[15234, 496, 332, 8, 46, "Notes",
  CellTags->"CellularAutomaton::rnum"],

Cell[CellGroupData[{
Cell[15591, 508, 73, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::rnum"],
Cell[15667, 511, 176, 5, 24, "Text",
  CellTags->"CellularAutomaton::rnum"],

Cell[CellGroupData[{
Cell[15868, 520, 131, 3, 26, "Input",
  CellTags->"CellularAutomaton::rnum"],
Cell[16002, 525, 232, 5, 37, "Message",
  CellTags->"CellularAutomaton::rnum"],
Cell[16237, 532, 132, 3, 21, "Output",
  CellTags->"CellularAutomaton::rnum"]
}, Open  ]],
Cell[16384, 538, 158, 5, 24, "Text",
  CellTags->"CellularAutomaton::rnum"],

Cell[CellGroupData[{
Cell[16567, 547, 132, 3, 26, "Input",
  CellTags->"CellularAutomaton::rnum"],
Cell[16702, 552, 172, 4, 21, "Output",
  CellTags->"CellularAutomaton::rnum"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16935, 563, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::rsize"],
Cell[17039, 566, 506, 12, 37, "Message",
  CellTags->"CellularAutomaton::rsize"],
Cell[17548, 580, 349, 7, 62, "Notes",
  CellTags->"CellularAutomaton::rsize"],

Cell[CellGroupData[{
Cell[17922, 591, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::rsize"],
Cell[17999, 594, 135, 4, 24, "Text",
  CellTags->"CellularAutomaton::rsize"],

Cell[CellGroupData[{
Cell[18159, 602, 133, 3, 26, "Input",
  CellTags->"CellularAutomaton::rsize"],
Cell[18295, 607, 255, 5, 37, "Message",
  CellTags->"CellularAutomaton::rsize"],
Cell[18553, 614, 134, 3, 21, "Output",
  CellTags->"CellularAutomaton::rsize"]
}, Open  ]],
Cell[18702, 620, 166, 5, 24, "Text",
  CellTags->"CellularAutomaton::rsize"],

Cell[CellGroupData[{
Cell[18893, 629, 133, 3, 26, "Input",
  CellTags->"CellularAutomaton::rsize"],
Cell[19029, 634, 173, 4, 21, "Output",
  CellTags->"CellularAutomaton::rsize"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19263, 645, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::nspec"],
Cell[19367, 648, 682, 16, 53, "Message",
  CellTags->"CellularAutomaton::nspec"],
Cell[20052, 666, 341, 8, 46, "Notes",
  CellTags->"CellularAutomaton::nspec"],

Cell[CellGroupData[{
Cell[20418, 678, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::nspec"],
Cell[20495, 681, 172, 5, 24, "Text",
  CellTags->"CellularAutomaton::nspec"],

Cell[CellGroupData[{
Cell[20692, 690, 139, 3, 26, "Input",
  CellTags->"CellularAutomaton::nspec"],
Cell[20834, 695, 292, 6, 53, "Message",
  CellTags->"CellularAutomaton::nspec"],
Cell[21129, 703, 140, 3, 21, "Output",
  CellTags->"CellularAutomaton::nspec"]
}, Open  ]],
Cell[21284, 709, 159, 5, 24, "Text",
  CellTags->"CellularAutomaton::nspec"],

Cell[CellGroupData[{
Cell[21468, 718, 136, 3, 26, "Input",
  CellTags->"CellularAutomaton::nspec"],
Cell[21607, 723, 173, 4, 21, "Output",
  CellTags->"CellularAutomaton::nspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21841, 734, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::wtlen"],
Cell[21945, 737, 544, 13, 37, "Message",
  CellTags->"CellularAutomaton::wtlen"],
Cell[22492, 752, 537, 10, 84, "Notes",
  CellTags->"CellularAutomaton::wtlen"],

Cell[CellGroupData[{
Cell[23054, 766, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::wtlen"],
Cell[23131, 769, 173, 4, 24, "Text",
  CellTags->"CellularAutomaton::wtlen"],

Cell[CellGroupData[{
Cell[23329, 777, 146, 3, 26, "Input",
  CellTags->"CellularAutomaton::wtlen"],
Cell[23478, 782, 255, 5, 37, "Message",
  CellTags->"CellularAutomaton::wtlen"],
Cell[23736, 789, 147, 3, 21, "Output",
  CellTags->"CellularAutomaton::wtlen"]
}, Open  ]],
Cell[23898, 795, 175, 5, 24, "Text",
  CellTags->"CellularAutomaton::wtlen"],

Cell[CellGroupData[{
Cell[24098, 804, 149, 3, 26, "Input",
  CellTags->"CellularAutomaton::wtlen"],
Cell[24250, 809, 173, 4, 21, "Output",
  CellTags->"CellularAutomaton::wtlen"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24484, 820, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::initg"],
Cell[24588, 823, 391, 10, 37, "Message",
  CellTags->"CellularAutomaton::initg"],
Cell[24982, 835, 360, 9, 46, "Notes",
  CellTags->"CellularAutomaton::initg"],

Cell[CellGroupData[{
Cell[25367, 848, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::initg"],
Cell[25444, 851, 176, 5, 24, "Text",
  CellTags->"CellularAutomaton::initg"],

Cell[CellGroupData[{
Cell[25645, 860, 124, 3, 26, "Input",
  CellTags->"CellularAutomaton::initg"],
Cell[25772, 865, 238, 5, 37, "Message",
  CellTags->"CellularAutomaton::initg"],
Cell[26013, 872, 125, 3, 21, "Output",
  CellTags->"CellularAutomaton::initg"]
}, Open  ]],
Cell[26153, 878, 172, 5, 24, "Text",
  CellTags->"CellularAutomaton::initg"],

Cell[CellGroupData[{
Cell[26350, 887, 131, 3, 26, "Input",
  CellTags->"CellularAutomaton::initg"],
Cell[26484, 892, 173, 4, 21, "Output",
  CellTags->"CellularAutomaton::initg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26718, 903, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::bgrnd"],
Cell[26822, 906, 655, 17, 37, "Message",
  CellTags->"CellularAutomaton::bgrnd"],
Cell[27480, 925, 360, 9, 46, "Notes",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[CellGroupData[{
Cell[27865, 938, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::bgrnd"],
Cell[27942, 941, 170, 4, 24, "Text",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[CellGroupData[{
Cell[28137, 949, 128, 3, 26, "Input",
  CellTags->"CellularAutomaton::bgrnd"],
Cell[28268, 954, 289, 6, 53, "Message",
  CellTags->"CellularAutomaton::bgrnd"],
Cell[28560, 962, 129, 3, 21, "Output",
  CellTags->"CellularAutomaton::bgrnd"]
}, Open  ]],
Cell[28704, 968, 165, 4, 24, "Text",
  CellTags->"CellularAutomaton::bgrnd"],

Cell[CellGroupData[{
Cell[28894, 976, 133, 3, 26, "Input",
  CellTags->"CellularAutomaton::bgrnd"],
Cell[29030, 981, 146, 3, 21, "Output",
  CellTags->"CellularAutomaton::bgrnd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29237, 991, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::stateg"],
Cell[29343, 994, 516, 11, 53, "Message",
  CellTags->"CellularAutomaton::stateg"],
Cell[29862, 1007, 680, 13, 116, "Notes",
  CellTags->"CellularAutomaton::stateg"],

Cell[CellGroupData[{
Cell[30567, 1024, 75, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::stateg"],
Cell[30645, 1027, 236, 6, 40, "Text",
  CellTags->"CellularAutomaton::stateg"],

Cell[CellGroupData[{
Cell[30906, 1037, 132, 3, 26, "Input",
  CellTags->"CellularAutomaton::stateg"],
Cell[31041, 1042, 316, 6, 53, "Message",
  CellTags->"CellularAutomaton::stateg"],
Cell[31360, 1050, 133, 3, 21, "Output",
  CellTags->"CellularAutomaton::stateg"]
}, Open  ]],
Cell[31508, 1056, 173, 5, 24, "Text",
  CellTags->"CellularAutomaton::stateg"],

Cell[CellGroupData[{
Cell[31706, 1065, 140, 3, 26, "Input",
  CellTags->"CellularAutomaton::stateg"],
Cell[31849, 1070, 176, 4, 21, "Output",
  CellTags->"CellularAutomaton::stateg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32086, 1081, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::state"],
Cell[32190, 1084, 724, 19, 37, "Message",
  CellTags->"CellularAutomaton::state"],
Cell[32917, 1105, 641, 14, 116, "Notes",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{
Cell[33583, 1123, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::state"],
Cell[33660, 1126, 253, 6, 40, "Text",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{
Cell[33938, 1136, 150, 3, 26, "Input",
  CellTags->"CellularAutomaton::state"],
Cell[34091, 1141, 348, 6, 53, "Message",
  CellTags->"CellularAutomaton::state"],
Cell[34442, 1149, 151, 3, 21, "Output",
  CellTags->"CellularAutomaton::state"]
}, Open  ]],
Cell[34608, 1155, 178, 4, 24, "Text",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{
Cell[34811, 1163, 154, 3, 26, "Input",
  CellTags->"CellularAutomaton::state"],
Cell[34968, 1168, 368, 6, 53, "Message",
  CellTags->"CellularAutomaton::state"],
Cell[35339, 1176, 155, 3, 21, "Output",
  CellTags->"CellularAutomaton::state"]
}, Open  ]],
Cell[35509, 1182, 182, 5, 24, "Text",
  CellTags->"CellularAutomaton::state"],

Cell[CellGroupData[{
Cell[35716, 1191, 154, 3, 26, "Input",
  CellTags->"CellularAutomaton::state"],
Cell[35873, 1196, 223, 4, 37, "Output",
  CellTags->"CellularAutomaton::state"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36157, 1207, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::offg"],
Cell[36259, 1210, 369, 9, 37, "Message",
  CellTags->"CellularAutomaton::offg"],
Cell[36631, 1221, 330, 8, 46, "Notes",
  CellTags->"CellularAutomaton::offg"],

Cell[CellGroupData[{
Cell[36986, 1233, 73, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::offg"],
Cell[37062, 1236, 161, 4, 24, "Text",
  CellTags->"CellularAutomaton::offg"],

Cell[CellGroupData[{
Cell[37248, 1244, 136, 3, 26, "Input",
  CellTags->"CellularAutomaton::offg"],
Cell[37387, 1249, 227, 5, 37, "Message",
  CellTags->"CellularAutomaton::offg"],
Cell[37617, 1256, 137, 3, 21, "Output",
  CellTags->"CellularAutomaton::offg"]
}, Open  ]],
Cell[37769, 1262, 162, 5, 24, "Text",
  CellTags->"CellularAutomaton::offg"],

Cell[CellGroupData[{
Cell[37956, 1271, 137, 3, 26, "Input",
  CellTags->"CellularAutomaton::offg"],
Cell[38096, 1276, 198, 4, 37, "Output",
  CellTags->"CellularAutomaton::offg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38355, 1287, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::ovflw"],
Cell[38459, 1290, 202, 3, 37, "Message",
  CellTags->"CellularAutomaton::ovflw"],
Cell[38664, 1295, 283, 7, 40, "Notes",
  CellTags->"CellularAutomaton::ovflw"],

Cell[CellGroupData[{
Cell[38972, 1306, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::ovflw"],
Cell[39049, 1309, 275, 6, 40, "Text",
  CellTags->"CellularAutomaton::ovflw"],

Cell[CellGroupData[{
Cell[39349, 1319, 141, 3, 26, "Input",
  CellTags->"CellularAutomaton::ovflw"],
Cell[39493, 1324, 215, 5, 37, "Message",
  CellTags->"CellularAutomaton::ovflw"],
Cell[39711, 1331, 142, 3, 21, "Output",
  CellTags->"CellularAutomaton::ovflw"]
}, Open  ]],
Cell[39868, 1337, 160, 5, 24, "Text",
  CellTags->"CellularAutomaton::ovflw"],

Cell[CellGroupData[{
Cell[40053, 1346, 140, 3, 26, "Input",
  CellTags->"CellularAutomaton::ovflw"],
Cell[40196, 1351, 142, 3, 21, "Output",
  CellTags->"CellularAutomaton::ovflw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40399, 1361, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::steps"],
Cell[40503, 1364, 373, 9, 37, "Message",
  CellTags->"CellularAutomaton::steps"],
Cell[40879, 1375, 210, 5, 24, "Notes",
  CellTags->"CellularAutomaton::steps"],

Cell[CellGroupData[{
Cell[41114, 1384, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::steps"],
Cell[41191, 1387, 239, 7, 40, "Text",
  CellTags->"CellularAutomaton::steps"],

Cell[CellGroupData[{
Cell[41455, 1398, 134, 3, 26, "Input",
  CellTags->"CellularAutomaton::steps"],
Cell[41592, 1403, 219, 5, 37, "Message",
  CellTags->"CellularAutomaton::steps"],
Cell[41814, 1410, 135, 3, 21, "Output",
  CellTags->"CellularAutomaton::steps"]
}, Open  ]],
Cell[41964, 1416, 102, 1, 24, "Text",
  CellTags->"CellularAutomaton::steps"],

Cell[CellGroupData[{
Cell[42091, 1421, 131, 3, 26, "Input",
  CellTags->"CellularAutomaton::steps"],
Cell[42225, 1426, 173, 4, 21, "Output",
  CellTags->"CellularAutomaton::steps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42459, 1437, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::stoff"],
Cell[42563, 1440, 518, 11, 37, "Message",
  CellTags->"CellularAutomaton::stoff"],
Cell[43084, 1453, 709, 15, 132, "Notes",
  CellTags->"CellularAutomaton::stoff"],

Cell[CellGroupData[{
Cell[43818, 1472, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::stoff"],
Cell[43895, 1475, 302, 6, 40, "Text",
  CellTags->"CellularAutomaton::stoff"],

Cell[CellGroupData[{
Cell[44222, 1485, 152, 3, 26, "Input",
  CellTags->"CellularAutomaton::stoff"],
Cell[44377, 1490, 345, 6, 53, "Message",
  CellTags->"CellularAutomaton::stoff"],
Cell[44725, 1498, 153, 3, 21, "Output",
  CellTags->"CellularAutomaton::stoff"]
}, Open  ]],
Cell[44893, 1504, 171, 5, 24, "Text",
  CellTags->"CellularAutomaton::stoff"],

Cell[CellGroupData[{
Cell[45089, 1513, 154, 3, 26, "Input",
  CellTags->"CellularAutomaton::stoff"],
Cell[45246, 1518, 211, 4, 37, "Output",
  CellTags->"CellularAutomaton::stoff"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45518, 1529, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::offtsqs"],
Cell[45626, 1532, 499, 11, 53, "Message",
  CellTags->"CellularAutomaton::offtsqs"],
Cell[46128, 1545, 342, 8, 46, "Notes",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[CellGroupData[{
Cell[46495, 1557, 76, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::offtsqs"],
Cell[46574, 1560, 192, 5, 24, "Text",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[CellGroupData[{
Cell[46791, 1569, 335, 9, 26, "Input",
  CellTags->"CellularAutomaton::offtsqs"],
Cell[47129, 1580, 286, 5, 53, "Message",
  CellTags->"CellularAutomaton::offtsqs"],
Cell[47418, 1587, 147, 3, 21, "Output",
  CellTags->"CellularAutomaton::offtsqs"]
}, Open  ]],
Cell[47580, 1593, 172, 5, 24, "Text",
  CellTags->"CellularAutomaton::offtsqs"],

Cell[CellGroupData[{
Cell[47777, 1602, 340, 9, 26, "Input",
  CellTags->"CellularAutomaton::offtsqs"],
Cell[48120, 1613, 132, 3, 21, "Output",
  CellTags->"CellularAutomaton::offtsqs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[48313, 1623, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::xtake"],
Cell[48417, 1626, 353, 10, 21, "Message",
  CellTags->"CellularAutomaton::xtake"],
Cell[48773, 1638, 219, 5, 24, "Notes",
  CellTags->"CellularAutomaton::xtake"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49029, 1648, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::ttake"],
Cell[49133, 1651, 175, 3, 21, "Message",
  CellTags->"CellularAutomaton::ttake"],
Cell[49311, 1656, 219, 5, 24, "Notes",
  CellTags->"CellularAutomaton::ttake"],

Cell[CellGroupData[{
Cell[49555, 1665, 74, 1, 38, "ExampleSection",
  CellTags->"CellularAutomaton::ttake"],
Cell[49632, 1668, 194, 4, 40, "Text",
  CellTags->"CellularAutomaton::ttake"],

Cell[CellGroupData[{
Cell[49851, 1676, 345, 9, 26, "Input",
  CellTags->"CellularAutomaton::ttake"],
Cell[50199, 1687, 198, 4, 21, "Message",
  CellTags->"CellularAutomaton::ttake"],
Cell[50400, 1693, 155, 3, 21, "Output",
  CellTags->"CellularAutomaton::ttake"]
}, Open  ]],
Cell[50570, 1699, 170, 5, 24, "Text",
  CellTags->"CellularAutomaton::ttake"],

Cell[CellGroupData[{
Cell[50765, 1708, 345, 9, 26, "Input",
  CellTags->"CellularAutomaton::ttake"],
Cell[51113, 1719, 144, 3, 21, "Output",
  CellTags->"CellularAutomaton::ttake"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51318, 1729, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CellularAutomaton::offxsqs"],
Cell[51426, 1732, 330, 6, 53, "Message",
  CellTags->"CellularAutomaton::offxsqs"],
Cell[51759, 1740, 137, 4, 24, "Notes",
  CellTags->"CellularAutomaton::offxsqs"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

