(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    112811,       4068]*)
(*NotebookOutlinePosition[    161310,       5248]*)
(*  CellTagsIndexPosition[    159049,       5187]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Compile", "Title"],

Cell[CellGroupData[{

Cell["Compile::argset", "ObjectNameWarningMessages",
  CellTags->"Compile::argset"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Compile::"argset"\), ":", " ", 
        RowBox[{"The", " ", "assignment", " ", "to", " ", 
          StyleBox["expr",
            "TI"], " ", "is", " ", "illegal"}]}], ";", 
      " ", \(it\ is\ not\ valid\ to\ assign\ a\ value\ to\ an\ \(\(argument\)\
\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::argset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression to be compiled contains \
an assignment to one of the arguments of the compiled function.\n\
\[FilledSmallSquare] The first argument in ",
  StyleBox["Compile", "MR"],
  " gives the list of arguments of the compiled function."
}], "Notes",
  CellTags->"Compile::argset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::argset"],

Cell[TextData[{
  "An error occurs in this example because of the assignment to ",
  StyleBox["x", "MR"],
  "."
}], "Text",
  CellTags->"Compile::argset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{x, y}, x = 5; x + y]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::argset"],

Cell[BoxData[
    \(Compile::"argset" \(\(:\)\(\ \)\) 
      "The assignment to \!\(x\) is illegal; it is not valid to assign a \
value to an argument."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::argset"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x, y}, x = 5; x + y, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::argset"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["Compile", "MR"],
  ", with an assignment to a local variable."
}], "Text",
  CellTags->"Compile::argset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Compile[{y}, Module[{x}, x = 5; x + y]]\)[2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::argset"],

Cell[BoxData[
    \(7.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::argset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::iterset", "ObjectNameWarningMessages",
  CellTags->"Compile::iterset"],

Cell[BoxData[
    \(Compile::"iterset" \(\(:\)\(\ \)\) 
      "The assignment to `1` is illegal; the compiler cannot assign a value \
to an iterator variable."\)], "Message",
  CellLabel->"From In[402]:=",
  CellTags->"Compile::iterset"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Compile::iterset"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::compfail", "ObjectNameWarningMessages",
  CellTags->"Compile::compfail"],

Cell[BoxData[
    \(Compile::"compfail" \(\(:\)\(\ \)\) 
      "Compilation of `1` failed because `2` was not a form suitable for the \
compiler."\)], "Message",
  CellLabel->"From In[406]:=",
  CellTags->"Compile::compfail"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Compile::compfail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::ccon", "ObjectNameWarningMessages",
  CellTags->"Compile::ccon"],

Cell[BoxData[
    RowBox[{\(Compile::"ccon"\), \(\(:\)\(\ \)\), \(Non - \(\(numerical\)\(\ \
\)\(object\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(with\ attribute\ Constant\ cannot\ be\ \
\(\(compiled\)\(.\)\)\)\)}]], "Message",
  CellTags->"Compile::ccon"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression to be compiled contains  \
a symbol with the ",
  StyleBox["Constant", "MR"],
  " attribute does not evaluate to a number and does not have any rules for \
computing numerical  approximations using ",
  StyleBox["N", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::ccon"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::ccon"],

Cell[TextData[{
  "An error occurs in this example because there is a symbol to be compiled  \
that has the ",
  StyleBox["Constant", "MR"],
  " attribute but no ",
  StyleBox["NValues", "MR"],
  "."
}], "Text",
  CellTags->"Compile::ccon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{c}, \n\tSetAttributes[c, \ Constant]; \n\t
      Compile[{x}, c\ Sin[x]]\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::ccon"],

Cell[BoxData[
    \(Compile::"ccon" \(\(:\)\(\ \)\) 
      "Non-numerical object \!\(c\) with attribute Constant cannot be \
compiled."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::ccon"],

Cell[BoxData[
    \(Compile::"ccon" \(\(:\)\(\ \)\) 
      "Non-numerical object \!\(c\) with attribute Constant cannot be \
compiled."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::ccon"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, c\ Sin[x], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::ccon"]
}, Open  ]],

Cell[TextData[{
  "If a symbol to be compiled must have the ",
  StyleBox["Constant", "MR"],
  " attribute, compilation can proceed without error if the symbol also has a \
 rule for numerical approximation using ",
  StyleBox["N", "MR"],
  ".  The numerical value of the constant is incorporated into the resulting  \
",
  StyleBox["CompiledFunction", "MR"],
  " expression."
}], "Text",
  CellTags->"Compile::ccon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = 
      Block[{c}, \n\tSetAttributes[c, \ Constant]; \n\tN[c] = 5.7; \n\t
        Compile[{x}, c\ Sin[x]]\n]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::ccon"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, c\ Sin[x], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::ccon"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[Pi/2]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Compile::ccon"],

Cell[BoxData[
    \(5.7`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Compile::ccon"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["cf", "MR"],
  "."
}], "Text",
  CellTags->"Compile::ccon"],

Cell[BoxData[
    \(Clear[cf]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Compile::ccon"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cif", "ObjectNameWarningMessages",
  CellTags->"Compile::cif"],

Cell[BoxData[
    RowBox[{\(Compile::"cif"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \)\(type\)\(\ \
\)\(of\)\(\ \)\(the\)\(\ \)\(two\)\(\ \)\(results\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "are", " ", "incompatible", " ", "because", " ", "the", 
      " ", "rank", " ", "of", " ", "each", " ", "is", 
      " ", \(different . \ Evaluation\), " ", "will", " ", "use", " ", "the", 
      " ", "uncompiled", " ", \(\(function\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cif"],

Cell["\<\
\[FilledSmallSquare] Generated when the tensor rank of a result in \
an expression to be compiled could have two different values.
\[FilledSmallSquare] An expression can be compiled only if the type of the \
result is known and is always the same.\
\>", "Notes",
  CellTags->"Compile::cif"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cif"],

Cell["\<\
An error occurs in this example because the tensor rank of the \
result can have two different values depending on the values of the \
arguments.\
\>", "Text",
  CellTags->"Compile::cif"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{x, _Real, 1}, {y, _Real, 2}, {t, True | False}}, 
      If[t, x, y]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cif"],

Cell[BoxData[
    \(Compile::"cif" \(\(:\)\(\ \)\) 
      "The type of the two results in \!\(If[\(\(t, x, y\)\)]\) are \
incompatible because the rank of each is different. Evaluation will use the \
uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cif"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x, y, t}, If[t, x, y], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cif"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpapot", "ObjectNameWarningMessages",
  CellTags->"Compile::cpapot"],

Cell[BoxData[
    \(Compile::"cpapot" \(\(:\)\(\ \)\) 
      "Compilation of `1` can only proceed when `2` is Times, Plus or List; \
evaluation will use the uncompiled function."\)], "Message",
  CellLabel->"From In[74]:=",
  CellTags->"Compile::cpapot"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when compiled evaluation of the indicated  \
subexpression is not supported.\n\[FilledSmallSquare] This message occurs  \
when the first argument in ",
  StyleBox["Apply", "MR"],
  ", the first argument in ",
  StyleBox["Outer", "MR"],
  ", or the second argument in ",
  StyleBox["Tr", "MR"],
  " in an expression to be compiled is not ",
  StyleBox["Times", "MR"],
  ", ",
  StyleBox["Plus", "MR"],
  ", or ",
  StyleBox["List", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cpapot"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpapot"],

Cell[TextData[{
  "Applying ",
  StyleBox["Power", "MR"],
  " to a list is not supported for compiled evaluation."
}], "Text",
  CellTags->"Compile::cpapot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{x, _Real, 1}}, Apply[Power, x]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpapot"],

Cell[BoxData[
    \(Compile::"cpapot" \(\(:\)\(\ \)\) 
      "Compilation of \!\(Power @@ x\) can only proceed when \!\(Power\) is \
Times, Plus or List; evaluation will use the uncompiled function."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpapot"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, Power @@ x, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpapot"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpbool", "ObjectNameWarningMessages",
  CellTags->"Compile::cpbool"],

Cell[BoxData[
    RowBox[{\(Compile::"cpbool"\), ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "at", " ", "position", " ", 
        StyleBox["n",
          "TI"], " ", "of", " ", 
        StyleBox["expr",
          "TI"], \(\(\ \)\(should\ be\ of\ True\  | \ False\ type; \ 
        evaluation\ will\ use\ the\ uncompiled\ \
\(\(function\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cpbool"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the type of an argument in ",
  StyleBox["Xor", "MR"],
  " is not ",
  StyleBox["True|False", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cpbool"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpbool"],

Cell[TextData[{
  "An error occurs in this example because one of the arguments in ",
  StyleBox["Xor", "MR"],
  " will not evaluate to ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->"Compile::cpbool"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{x, y}, If[Xor[x > 0, y], x, y]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpbool"],

Cell[BoxData[
    \(Compile::"cpbool" \(\(:\)\(\ \)\) 
      "\!\(y\) at position \!\(2\) of \!\(\(\(x > 0\)\) \[Xor] y\) should be \
of True | False type; evaluation will use the uncompiled function."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpbool"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x, y}, If[x > 0 \[Xor] y, x, y], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpbool"]
}, Open  ]],

Cell[TextData[{
  "Compilation proceeds without error if all of the arguments in ",
  StyleBox["Xor", "MR"],
  " are of type ",
  StyleBox["True|False", "MR"],
  "."
}], "Text",
  CellTags->"Compile::cpbool"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{x, y}, If[Xor[x > 0, y < 0], x, y]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cpbool"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x, y}, If[x > 0 \[Xor] y < 0, x, y], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cpbool"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpdsts", "ObjectNameWarningMessages",
  CellTags->"Compile::cpdsts"],

Cell[BoxData[
    RowBox[{\(Compile::"cpdsts"\), \(\(:\)\(\ \)\), \(\(Compile\)\(\ \
\)\(cannot\)\(\ \)\(determine\)\(\ \)\(the\)\(\ \)\(rank\)\(\ \)\(of\)\(\ \
\)\(the\)\(\ \)\(result\)\(\ \)\(of\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(;\)\(\ \)\(evaluation\ will\ use\ the\ uncompiled\ \
\(\(function\)\(.\)\)\)\)}]], "Message",
  CellTags->"Compile::cpdsts"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Compile", "MR"],
  " is unable to determine the rank of a result from ",
  StyleBox["Partition", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cpdsts"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpdsts"],

Cell[TextData[{
  "An error occurs in this example because the rank of the result from ",
  StyleBox["Partition", "MR"],
  " cannot be determined without knowing the length of the second argument."
}], "Text",
  CellTags->"Compile::cpdsts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Partition[{1, 2, 3, 4}, x], {{x, _Integer, 1}}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"Compile::cpdsts"],

Cell[BoxData[
    \(Compile::"cpdsts" \(\(:\)\(\ \)\) 
      "Compile cannot determine the rank of the result of \
\!\(Partition[\(\(\(\({1, 2, 3, 4}\)\), x\)\)]\); evaluation will use the \
uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpdsts"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Partition[{1, 2, 3, 4}, x], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpdsts"]
}, Open  ]],

Cell[TextData[{
  "Compilation proceeds without error if the rank of the result from ",
  StyleBox["Partition", "MR"],
  " can be determined from the form of the arguments."
}], "Text",
  CellTags->"Compile::cpdsts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, 
      Partition[{1, 2, 3, 4}, {n1, 
          n2}], {{n1, _Integer}, {n2, _Integer}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cpdsts"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Partition[{1, 2, 3, 4}, {n1, n2}], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cpdsts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpint", "ObjectNameWarningMessages",
  CellTags->"Compile::cpint"],

Cell[BoxData[
    RowBox[{\(Compile::"cpint"\), ":", " ", 
      RowBox[{
        StyleBox["en",
          "TI"], " ", "at", " ", "position", " ", 
        StyleBox["n",
          "TI"], " ", "of", " ", 
        StyleBox["expr",
          "TI"], \(\(\ \)\(should\ be\ a\ machine - size\ integer; \ 
        evaluation\ will\ use\ the\ uncompiled\ \
\(\(function\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cpint"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected  \
to be an integer.\n\[FilledSmallSquare] This message can be generated when  \
compiling functions such as ",
  StyleBox["Flatten", "MR"],
  " in which some of the arguments are required to be integers."
}], "Notes",
  CellTags->"Compile::cpint"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpint"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Flatten", "MR"],
  " cannot be a list."
}], "Text",
  CellTags->"Compile::cpint"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Flatten[{{{1}, {2}}, {{3}, {4}}}, {}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpint"],

Cell[BoxData[
    \(Compile::"cpint" \(\(:\)\(\ \)\) 
      "\!\({}\) at position \!\(2\) of \!\(Flatten[\(\(\(\({\(\({\(\({1}\)\), \
\(\({2}\)\)}\)\), \(\({\(\({3}\)\), \(\({4}\)\)}\)\)}\)\), \(\({}\)\)\)\)]\) \
should be a machine-size integer; evaluation will use the uncompiled \
function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpint"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Flatten[{{{1}, {2}}, {{3}, {4}}}, {}], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpint"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpintlt", "ObjectNameWarningMessages",
  CellTags->"Compile::cpintlt"],

Cell[BoxData[
    RowBox[{\(Compile::"cpintlt"\), ":", " ", 
      RowBox[{
        StyleBox["en",
          "TI"], " ", "at", " ", "position", " ", 
        StyleBox["n",
          "TI"], " ", "of", " ", 
        StyleBox["expr",
          "TI"], \(\(\ \)\(should\ be\ either\ a\ non - 
          zero\ integer\ or\ a\ vector\ of\ non - zero\ integers; \ 
        evaluation\ will\ use\ the\ uncompiled\ \
\(\(function\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cpintlt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected  \
to be an integer or a list of integers.\n\[FilledSmallSquare] This message  \
can occur when compiling functions such as ",
  StyleBox["Part", "MR"],
  " in which some of the arguments can be either integers or lists of  \
integers."
}], "Notes",
  CellTags->"Compile::cpintlt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpintlt"],

Cell["\<\
An error occurs in this example because the symbolic part \
specification is not an integer.\
\>", "Text",
  CellTags->"Compile::cpintlt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, {10, 11, 12, 13}[\([n]\)]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpintlt"],

Cell[BoxData[
    \(Compile::"cpintlt" \(\(:\)\(\ \)\) 
      "\!\(n\) at position \!\(2\) of \!\(\(\({10, 11, 12, 13}\)\) \
\[LeftDoubleBracket] n \[RightDoubleBracket]\) should be either a non-zero \
integer or a vector of non-zero integers; evaluation will use the uncompiled \
function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpintlt"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, {10, 11, 12, 13}\[LeftDoubleBracket]
          n\[RightDoubleBracket], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpintlt"]
}, Open  ]],

Cell[TextData[{
  "If the symbolic part specification will evaluate to an integer or list of  \
integers, that information can be included in the third argument of ",
  StyleBox["Compile", "MR"],
  "."
}], "Text",
  CellTags->"Compile::cpintlt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, {10, 11, 12, 13}[\([n]\)], {{n, _Integer}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cpintlt"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, {10, 11, 12, 13}\[LeftDoubleBracket]
          n\[RightDoubleBracket], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cpintlt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpintlt2", "ObjectNameWarningMessages",
  CellTags->"Compile::cpintlt2"],

Cell[BoxData[
    RowBox[{\(Compile::"cpintlt2"\), ":", " ", 
      RowBox[{
        StyleBox["en",
          "TI"], " ", "at", " ", "position", " ", 
        StyleBox["n",
          "TI"], " ", "of", " ", 
        StyleBox["expr",
          "TI"], \(\(\ \)\(should\ be\ a\ non - zero\ integer, \ 
        or\ a\ vector\ or\ matrix\ of\ non - zero\ integers; \ 
        evaluation\ will\ use\ the\ uncompiled\ \
\(\(function\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cpintlt2"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected  \
to be an integer or a list of integers.\n\[FilledSmallSquare] This message  \
can occur when compiling functions such as ",
  StyleBox["Insert", "MR"],
  " in which some of the arguments can be either integers or lists of  \
integers."
}], "Notes",
  CellTags->"Compile::cpintlt2"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpintlt2"],

Cell["\<\
An error occurs in this example because the symbolic part \
specification is not an integer.\
\>", "Text",
  CellTags->"Compile::cpintlt2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Insert[{10, 12, 13}, 11, n]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpintlt2"],

Cell[BoxData[
    \(Compile::"cpintlt2" \(\(:\)\(\ \)\) 
      "\!\(n\) at position \!\(3\) of \!\(Insert[\(\(\(\({10, 12, 13}\)\), \
11, n\)\)]\) should be a non-zero integer, or a vector or matrix of non-zero \
integers; evaluation will use the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpintlt2"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Insert[{10, 12, 13}, 11, n], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpintlt2"]
}, Open  ]],

Cell[TextData[{
  "If the symbolic part specification will evaluate to an integer or list of  \
integers, that information can be included in the third argument of ",
  StyleBox["Compile", "MR"],
  "."
}], "Text",
  CellTags->"Compile::cpintlt2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Insert[{10, 12, 13}, 11, n], {{n, _Integer}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cpintlt2"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Insert[{10, 12, 13}, 11, n], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cpintlt2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpiter", "ObjectNameWarningMessages",
  CellTags->"Compile::cpiter"],

Cell[BoxData[
    RowBox[{\(Compile::"cpiter"\), \(\(:\)\(\ \)\), "Iterator", " ", "at", 
      " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "of", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ compiled; \ 
      evaluation\ will\ use\ the\ uncompiled\ \(\(function\)\(.\)\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cpiter"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression does not have \
 the form of an iterator.\n\[FilledSmallSquare] An iterator is a list that  \
gives the number of iterations, or the iteration variable and the range of  \
iteration, in functions such as ",
  StyleBox["Do", "MR"],
  " and ",
  StyleBox["Table", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cpiter"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpiter"],

Cell["\<\
An error occurs in this example because an integer is not a valid \
iteration specification.\
\>", "Text",
  CellTags->"Compile::cpiter"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Table[0, 5]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpiter"],

Cell[BoxData[
    \(Compile::"cpiter" \(\(:\)\(\ \)\) 
      "Iterator at position \!\(2\) of \!\(Table[\(\(0, 5\)\)]\) cannot be \
compiled; evaluation will use the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpiter"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Table[0, 5], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpiter"]
}, Open  ]],

Cell["This shows a valid iteration specification.", "Text",
  CellTags->"Compile::cpiter"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Table[0, {5}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cpiter"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Table[0, {5}], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cpiter"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cplist", "ObjectNameWarningMessages",
  CellTags->"Compile::cplist"],

Cell[BoxData[
    RowBox[{\(Compile::"cplist"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ tensor\ of\ type\ Integer, \ Real, \ 
      or\ Complex; \ 
      evaluation\ will\ use\ the\ uncompiled\ \(\(function\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Compile::cplist"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected  \
to be a list.\n\[FilledSmallSquare] This message can occur when compiling  \
expressions such as ",
  StyleBox["Delete", "MR"],
  " for which the compiler requires that certain arguments be lists."
}], "Notes",
  CellTags->"Compile::cplist"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cplist"],

Cell[TextData[{
  "An error occurs in this example because the type of the first argument in  \
",
  StyleBox["Delete", "MR"],
  " is not a list."
}], "Text",
  CellTags->"Compile::cplist"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{x, _Real, 1}}, Delete[x[\([2]\)], 1]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cplist"],

Cell[BoxData[
    \(Compile::"cplist" \(\(:\)\(\ \)\) 
      "\!\(x \[LeftDoubleBracket] 2 \[RightDoubleBracket]\) should be a \
tensor of type Integer, Real, or Complex; evaluation will use the uncompiled \
function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cplist"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, 
        Delete[x\[LeftDoubleBracket]2\[RightDoubleBracket], 1], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cplist"]
}, Open  ]],

Cell[TextData[{
  "Compilation proceeds without error if the type of the first argument in ",
  StyleBox["Delete", "MR"],
  " is a tensor."
}], "Text",
  CellTags->"Compile::cplist"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{x, _Real, 1}}, Delete[x, 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cplist"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, Delete[x, 1], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cplist"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpout", "ObjectNameWarningMessages",
  CellTags->"Compile::cpout"],

Cell[BoxData[
    \(Compile::"cpout" \(\(:\)\(\ \)\) \(Compile\ cannot\ work\ on\ Outer\ \
for\ tensors\ of\ different\ rank; \ 
      evaluation\ will\ use\ the\ uncompiled\ \(\(function\)\(.\)\)\)\)], \
"Message",
  CellTags->"Compile::cpout"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the level specifications in ",
  StyleBox["Outer", "MR"],
  " are such that the elements that will be used as function arguments do not \
 have the same tensor rank."
}], "Notes",
  CellTags->"Compile::cpout"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpout"],

Cell[TextData[{
  "An error occurs in this example because the level specification in the  \
last argument of ",
  StyleBox["Outer", "MR"],
  " will lead to expressions with unequal tensor rank being used as arguments \
 in ",
  StyleBox["Plus", "MR"],
  "."
}], "Text",
  CellTags->"Compile::cpout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Outer[Plus, {1}, {{2}}, 1]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpout"],

Cell[BoxData[
    \(Compile::"cpout" \(\(:\)\(\ \)\) 
      "Compile cannot work on Outer for tensors of different rank; evaluation \
will use the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpout"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Outer[Plus, {1}, {{2}}, 1], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpout"]
}, Open  ]],

Cell["This shows an expression that is compiled without error.", "Text",
  CellTags->"Compile::cpout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Outer[Plus, {{3}}, {{2}}, 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cpout"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Outer[Plus, {{3}}, {{2}}, 1], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cpout"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cppat", "ObjectNameWarningMessages",
  CellTags->"Compile::cppat"],

Cell[BoxData[
    RowBox[{\(Compile::"cppat"\), \(\(:\)\(\ \)\), \(\(Compile\)\(\ \
\)\(does\)\(\ \)\(not\)\(\ \)\(support\)\(\ \)\(\(patterns\)\(:\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ compiled; \ 
      evaluation\ will\ use\ the\ uncompiled\ \(\(function\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Compile::cppat"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Cases", "MR"],
  " or ",
  StyleBox["DeleteCases", "MR"],
  " is used with pattern expressions in an expression that is compiled.\n\
\[FilledSmallSquare] Pattern expressions include expressions based on ",
  StyleBox["Blank", "MR"],
  ", ",
  StyleBox["BlankSequence", "MR"],
  ", ",
  StyleBox["BlankNullSequence", "MR"],
  ", ",
  StyleBox["Repeated", "MR"],
  ", and ",
  StyleBox["RepeatedNull", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cppat"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cppat"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["Compile", "MR"],
  " is not designed to handle ",
  StyleBox["DeleteCases", "MR"],
  " when the arguments involve pattern expressions."
}], "Text",
  CellTags->"Compile::cppat"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, DeleteCases[{1, 2, 3, 4, 5}, _?EvenQ]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cppat"],

Cell[BoxData[
    \(Compile::"cppat" \(\(:\)\(\ \)\) 
      "Compile does not support patterns: \!\(DeleteCases[\(\(\(\({1, 2, 3, \
4, 5}\)\), \(\(_ ? EvenQ\)\)\)\)]\) cannot be compiled; evaluation will use \
the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cppat"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, DeleteCases[{1, 2, 3, 4, 5}, _?EvenQ], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cppat"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cprank", "ObjectNameWarningMessages",
  CellTags->"Compile::cprank"],

Cell[BoxData[
    RowBox[{\(Compile::"cprank"\), \(\(:\)\(\ \)\), "Compile", " ", "cannot", 
      " ", "determine", " ", "the", " ", "rank", " ", "of", " ", "result", 
      " ", \(tensor . \ The\), " ", "length", " ", "of", " ", 
      StyleBox["ep",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ unknown\ at\ compiling\ time; \ 
      evaluation\ will\ use\ the\ uncompiled\ \(\(function\)\(.\)\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cprank"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the rank of the indicated result  \
cannot be determined.\n\[FilledSmallSquare] Compiled evaluation requires that \
 the tensor rank of every expression be known.\n\[FilledSmallSquare] This  \
message can be generated by compilation of ",
  StyleBox["MapThread", "MR"],
  ", ",
  StyleBox["MapAt", "MR"],
  ", and ",
  StyleBox["Outer", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cprank"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cprank"],

Cell[TextData[{
  "A warning is generated in this example because the rank of the result from \
 ",
  StyleBox["Outer", "MR"],
  " cannot be determined."
}], "Text",
  CellTags->"Compile::cprank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, 
      Outer[List, {{1}, {2}}, {{4}, {5}}, n], {{n, _Integer}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cprank"],

Cell[BoxData[
    \(Compile::"cprank" \(\(:\)\(\ \)\) 
      "Compile cannot determine the rank of result tensor. The length of \
\!\(n\) in \!\(Outer[\(\(List, \(\({\(\({1}\)\), \(\({2}\)\)}\)\), \
\(\({\(\({4}\)\), \(\({5}\)\)}\)\), n\)\)]\) is unknown at compiling time; \
evaluation will use the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cprank"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Outer[List, {{1}, {2}}, {{4}, {5}}, n], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cprank"]
}, Open  ]],

Cell[TextData[{
  "The warning is avoided if the arguments in ",
  StyleBox["Outer", "MR"],
  " are given explicitly, so that the rank of the result can be determined."
}], "Text",
  CellTags->"Compile::cprank"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Outer[List, {{1}, {2}}, {{4}, {5}}, 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cprank"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Outer[List, {{1}, {2}}, {{4}, {5}}, 1], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cprank"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpts", "ObjectNameWarningMessages",
  CellTags->"Compile::cpts"],

Cell[BoxData[
    RowBox[{\(Compile::"cpts"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \)\(result\)\(\
\ \)\(after\)\(\ \)\(evaluating\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ tensor . \ Non - 
        tensor\ lists\ are\ not\ supported\ at\ present; \ 
      evaluation\ will\ proceed\ with\ the\ uncompiled\ \(\(function\)\(.\)\)\
\)\)}]], "Message",
  CellTags->"Compile::cpts"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated result will not be a  \
tensor and so cannot be compiled.\n\[FilledSmallSquare] This message can be  \
generated by compilation of ",
  StyleBox["Insert", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cpts"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpts"],

Cell["\<\
An error occurs in this example because the result will not be a \
tensor.\
\>", "Text",
  CellTags->"Compile::cpts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Insert[{1, 2, 3}, {4}, 4]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpts"],

Cell[BoxData[
    \(Compile::"cpts" \(\(:\)\(\ \)\) 
      "The result after evaluating \!\(Insert[\(\(\(\({1, 2, 3}\)\), \
\(\({4}\)\), 4\)\)]\) should be a tensor. Non-tensor lists are not supported \
at present; evaluation will proceed with the uncompiled function."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpts"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Insert[{1, 2, 3}, {4}, 4], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpts"]
}, Open  ]],

Cell["Uncompiled evaluation shows that the result is not a tensor.", "Text",
  CellTags->"Compile::cpts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Insert[{1, 2, 3}, {4}, 4]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cpts"],

Cell[BoxData[
    \({1, 2, 3, {4}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cpts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cptype", "ObjectNameWarningMessages",
  CellTags->"Compile::cptype"],

Cell[BoxData[
    RowBox[{\(Compile::"cptype"\), ":", " ", 
      RowBox[{
        StyleBox["func",
          "TI"], " ", "not", " ", "supported", " ", "for", " ", "type", " ", 
        StyleBox["expr",
          
          "TI"], \(\(;\)\(\ \)\(evaluation\ will\ use\ the\ uncompiled\ \
\(\(function\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cptype"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when compiled evaluation of the indicated  \
function for arguments of the given type is not supported.\n\
\[FilledSmallSquare] This message can be generated by compilation of a  \
variety of functions, such as ",
  StyleBox["Floor", "MR"],
  " and ",
  StyleBox["Im", "MR"],
  ", that are meaningful only for certain types of arguments."
}], "Notes",
  CellTags->"Compile::cptype"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cptype"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["Floor", "MR"],
  " cannot be compiled if the argument is complex."
}], "Text",
  CellTags->"Compile::cptype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, _Complex}}, Floor[p]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cptype"],

Cell[BoxData[
    \(Compile::"cptype" \(\(:\)\(\ \)\) 
      "\!\(Floor\) not supported for type \!\(Complex\); evaluation will use \
the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cptype"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, Floor[p], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cptype"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Im", "MR"],
  " function is not compiled if the argument is a logical variable."
}], "Text",
  CellTags->"Compile::cptype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, True | False}}, Im[p]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cptype"],

Cell[BoxData[
    \(Compile::"cptype" \(\(:\)\(\ \)\) 
      "\!\(Im\) not supported for type \!\(True | False\); evaluation will \
use the uncompiled function."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Compile::cptype"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, Im[p], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cptype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cpw", "ObjectNameWarningMessages",
  CellTags->"Compile::cpw"],

Cell[BoxData[
    RowBox[{\(Compile::"cpw"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \
\)\(compile\)\(\ \)\(raw\)\(\ \)\(expression\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "of", " ", "type", " ", 
      RowBox[{
        StyleBox["t",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cpw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by compilation of an expression constructed \
 using ",
  StyleBox["Raw", "MR"],
  ".\n\[FilledSmallSquare] The function ",
  StyleBox["Raw", "MR"],
  " is not supported in current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Compile::cpw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cpw"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["Compile", "MR"],
  " is not designed to handle expressions constructed using ",
  StyleBox["Raw", "MR"],
  "."
}], "Text",
  CellTags->"Compile::cpw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Evaluate[Raw[x, "\<1\>"]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cpw"],

Cell[BoxData[
    \(Compile::"cpw" \(\(:\)\(\ \)\) 
      "Cannot compile raw expression \!0 of type \!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cpw"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, 0, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cpw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cret", "ObjectNameWarningMessages",
  CellTags->"Compile::cret"],

Cell[BoxData[
    \(Compile::"cret" \(\(:\)\(\ \)\) 
      "The type of return values in `1` are different. Evaluation will use \
the uncompiled function."\)], "Message",
  CellLabel->"From In[74]:=",
  CellTags->"Compile::cret"],

Cell["\<\
\[FilledSmallSquare] Generated when the possible return values for \
a compiled expression do not all have the same tensor rank.\
\>", "Notes",
  CellTags->"Compile::cret"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cret"],

Cell["\<\
A warning is generated in this example because the tensor rank of \
the return value will be different depending on the value of the \
argument.\
\>", "Text",
  CellTags->"Compile::cret"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{p}, If[p > 0, Return[1]]; {2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cret"],

Cell[BoxData[
    \(Compile::"cret" \(\(:\)\(\ \)\) 
      "The type of return values in \!\(\(\(If[\(\(\(\(p > 0\)\), \
\(\(Return[1]\)\)\)\)]\)\) ; \(\({2}\)\)\) are different. Evaluation will use \
the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cret"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, If[p > 0, Return[1]]; {2}, 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cret"]
}, Open  ]],

Cell["\<\
Compilation proceeds without difficulty if all of the return values \
have the same tensor rank.\
\>", "Text",
  CellTags->"Compile::cret"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{p}, If[p > 0, Return[{1}]]; {2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cret"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, If[p > 0, Return[{1}]]; {2}, 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cret"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cret1", "ObjectNameWarningMessages",
  CellTags->"Compile::cret1"],

Cell[BoxData[
    RowBox[{\(Compile::"cret1"\), ":", " ", 
      RowBox[{
      "The", " ", "type", " ", "of", " ", "Return", " ", "expression", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "incompatible", " ", "with", " ", "a", " ", 
        "previous", " ", "Return", 
        " ", \(\(expression\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cret1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression to be compiled includes \
more than one point of return, and not all of the points return an expression \
of the same type.\n\[FilledSmallSquare] The return type can be ",
  StyleBox["_Integer", "MR"],
  ", ",
  StyleBox["_Real", "MR"],
  ", ",
  StyleBox["_Complex", "MR"],
  ", or ",
  StyleBox["True|False", "MR"],
  ", or arrays of ",
  StyleBox["_Integer", "MR"],
  ", ",
  StyleBox["_Real", "MR"],
  ", ",
  StyleBox["_Complex", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::cret1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cret1"],

Cell[TextData[{
  "An error occurs in this example because one of the possible return types \
is an integer, and the other possible return type is boolean (",
  StyleBox["False", "MR"],
  ")."
}], "Text",
  CellTags->"Compile::cret1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{x}, If[x > 0, Return[1], Return[False]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cret1"],

Cell[BoxData[
    \(Compile::"cret1" \(\(:\)\(\ \)\) 
      "The type of Return expression \!\(Return[False]\) is incompatible with \
a previous Return expression."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cret1"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, If[x > 0, Return[1], Return[False]], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cret1"]
}, Open  ]],

Cell["\<\
The compilation succeeds if all of the possible return values have \
the same type.\
\>", "Text",
  CellTags->"Compile::cret1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{x}, If[x > 0, Return[True], Return[False]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cret1"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, If[x > 0, Return[True], Return[False]], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cret1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cset", "ObjectNameWarningMessages",
  CellTags->"Compile::cset"],

Cell[BoxData[
    RowBox[{\(Compile::"cset"\), \(\(:\)\(\ \)\), "Variable", " ", 
      StyleBox["var",
        "TI"], " ", "of", " ", "type", " ", 
      StyleBox["t1",
        "TI"], " ", "encountered", " ", "in", " ", "assignment", " ", "of", 
      " ", "type", " ", 
      RowBox[{
        StyleBox["t2",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::cset"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression to be compiled \
involves assignments of the same variable to different types of expressions.
\[FilledSmallSquare] The type of a variable must the the same throughout a \
compiled evaluation.\
\>", "Notes",
  CellTags->"Compile::cset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cset"],

Cell["\<\
A warning is generated in this example because expressions of \
different types are assigned at different times to the same variable.\
\>", \
"Text",
  CellTags->"Compile::cset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, _Complex}}, Module[{x}, x = 1; x = p]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cset"],

Cell[BoxData[
    \(Compile::"cset" \(\(:\)\(\ \)\) 
      "Variable \!\(x\) of type \!\(\"_Integer\"\) encountered in assignment \
of type \!\(\"_Complex\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::cset"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, Module[{x}, x = 1; x = p], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::cset"]
}, Open  ]],

Cell["\<\
The type conflict can be avoided by using expressions of the same \
type in all assignments to the variable.\
\>", "Text",
  CellTags->"Compile::cset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, _Complex}}, 
      Module[{x}, x = 1.0 + 0.0  I; x = p]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cset"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, 
        Module[{x}, 
          x = \(\(1.`\)\(\[InvisibleSpace]\)\) + 0.`\ \[ImaginaryI]; x = p], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::ctyp1", "ObjectNameWarningMessages",
  CellTags->"Compile::ctyp1"],

Cell[BoxData[
    \(Compile::"ctyp1" \(\(:\)\(\ \)\) 
      "Number `1` in `2` is an invalid compiler variable. A symbol can be \
used as a valid variable."\)], "Message",
  CellLabel->"From In[74]:=",
  CellTags->"Compile::ctyp1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an invalid specification for a parameter \
 used in ",
  StyleBox["Compile", "MR"],
  ".\n\[FilledSmallSquare] Parameter specifications are listed in the first  \
argument of ",
  StyleBox["Compile", "MR"],
  ".\n\[FilledSmallSquare] A valid parameter specification gives the symbolic \
 name of the parameter or a list giving the name and the type of the  \
parameter.  If only the name of the parameter is given, the type is assumed  \
to be ",
  StyleBox["_Real", "MR"],
  ".\n\[FilledSmallSquare] An explicit type specification should be a list of \
 the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " giving the name ",
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  " and the type ",
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  " of the parameter, or a list of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " which includes the tensor rank ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " of the parameter if the parameter is a tensor.\n\[FilledSmallSquare] The  \
type of a parameter can be ",
  StyleBox["_Integer", "MR"],
  ", ",
  StyleBox["_Real", "MR"],
  ", ",
  StyleBox["_Complex", "MR"],
  ", or ",
  StyleBox["True|False", "MR"],
  ".\n\[FilledSmallSquare] This particular message is generated if a number  \
is encountered in a position where the name of a parameter is expected."
}], "Notes",
  CellTags->"Compile::ctyp1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::ctyp1"],

Cell[TextData[{
  "An error occurs in this example because a number cannot be used as the  \
name of a parameter in ",
  StyleBox["Compile", "MR"],
  "."
}], "Text",
  CellTags->"Compile::ctyp1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{p, _Real, 1}, Length[p]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::ctyp1"],

Cell[BoxData[
    \(Compile::"ctyp1" \(\(:\)\(\ \)\) 
      "Number \!\(1\) in \!\({p, _Real, 1}\) is an invalid compiler variable. \
A symbol can be used as a valid variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::ctyp1"],

Cell[BoxData[
    \(Compile[{p, _Real, 1}, Length[p]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::ctyp1"]
}, Open  ]],

Cell["\<\
An explicit type specification for a parameter should be given by \
including the name and the type of the parameter in a list.\
\>", "Text",
  CellTags->"Compile::ctyp1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, _Real, 1}}, Length[p]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::ctyp1"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, Length[p], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::ctyp1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::ctyp2", "ObjectNameWarningMessages",
  CellTags->"Compile::ctyp2"],

Cell[BoxData[
    RowBox[{\(Compile::"ctyp2"\), \(\(:\)\(\ \)\), \(\(Invalid\)\(\ \
\)\(type\)\(\ \)\(or\)\(\ \)\(rank\)\(\ \)\(specification\)\(\ \)\(in\)\(\ \)\
\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Compile::ctyp2"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the type specification for a parameter \
 in ",
  StyleBox["Compile", "MR"],
  " does not have the correct form.\n\[FilledSmallSquare] An explicit type  \
specification should be a list of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " giving the name ",
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  " and the type ",
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  " of the parameter, or a list of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " which includes the tensor rank ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " of the parameter if the parameter is a tensor.\n\[FilledSmallSquare] The  \
type of a parameter can be ",
  StyleBox["_Integer", "MR"],
  ", ",
  StyleBox["_Real", "MR"],
  ", ",
  StyleBox["_Complex", "MR"],
  ", or ",
  StyleBox["True|False", "MR"],
  ".\n\[FilledSmallSquare] Parameter type and rank specifications are listed  \
in the first argument of ",
  StyleBox["Compile", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::ctyp2"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::ctyp2"],

Cell["\<\
An error occurs in this example because the parameter type \
specification does not match any of the required forms.\
\>", "Text",
  CellTags->"Compile::ctyp2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, 1}}, Length[p]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::ctyp2"],

Cell[BoxData[
    \(Compile::"ctyp2" \(\(:\)\(\ \)\) 
      "Invalid type or rank specification in \!\({p, 1}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::ctyp2"],

Cell[BoxData[
    \(Compile[{{p, 1}}, Length[p]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::ctyp2"]
}, Open  ]],

Cell["\<\
If a parameter is a tensor, the type and the rank of the tensor \
must both be specified explicitly.\
\>", "Text",
  CellTags->"Compile::ctyp2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, _Real, 1}}, Length[p]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::ctyp2"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, Length[p], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::ctyp2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::ctyps", "ObjectNameWarningMessages",
  CellTags->"Compile::ctyps"],

Cell[BoxData[
    RowBox[{\(Compile::"ctyps"\), \(\(:\)\(\ \)\), \(\(Invalid\)\(\ \
\)\(subexpression\)\(\ \)\(type\)\(\ \)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Compile::ctyps"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the type or rank specification for a  \
subexpression in ",
  StyleBox["Compile", "MR"],
  " does not have a valid form.\n\[FilledSmallSquare] Type and rank  \
specifications for subexpressions are listed in the third argument of ",
  StyleBox["Compile", "MR"],
  ".\n\[FilledSmallSquare] A type specification for a subexpression should be \
 a list of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " giving the name ",
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  " and the type ",
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  " of the subexpression, or a list of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["t", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " which includes the tensor rank ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " of the subexpression if the subexpression is a tensor.\n\
\[FilledSmallSquare] The type can be ",
  StyleBox["_Integer", "MR"],
  ", ",
  StyleBox["_Real", "MR"],
  ", ",
  StyleBox["_Complex", "MR"],
  ", or ",
  StyleBox["True|False", "MR"],
  "."
}], "Notes",
  CellTags->"Compile::ctyps"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::ctyps"],

Cell["\<\
An error occurs in this example because the subexpression type \
specification does not have a valid form.\
\>", "Text",
  CellTags->"Compile::ctyps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, _Real, 1}}, p\ q, {q, _Real}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::ctyps"],

Cell[BoxData[
    \(Compile::"ctyps" \(\(:\)\(\ \)\) 
      "Invalid subexpression type specification \!\(q\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::ctyps"],

Cell[BoxData[
    \(Compile::"ctyps" \(\(:\)\(\ \)\) 
      "Invalid subexpression type specification \!\(_Real\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::ctyps"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, p\ q, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::ctyps"]
}, Open  ]],

Cell["Subexpression type specifications should be given as lists.", "Text",
  CellTags->"Compile::ctyps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{p, _Real, 1}}, p\ q, {{q, _Real}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::ctyps"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p}, p\ q, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::ctyps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::cxcoerce", "ObjectNameWarningMessages",
  CellTags->"Compile::cxcoerce"],

Cell[BoxData[
    \(Compile::"cxcoerce" \(\(:\)\(\ \)\) 
      "Warning, compilation of `1` has coerced an exact number to an \
approximate complex number."\)], "Message",
  CellLabel->"From In[74]:=",
  CellTags->"Compile::cxcoerce"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Compile", "MR"],
  " converts an exact number into an inexact complex number.\n\
\[FilledSmallSquare] This message is used only if a special option for that  \
purpose has been set."
}], "Notes",
  CellTags->"Compile::cxcoerce"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::cxcoerce"],

Cell["\<\
A message about coercion is generated if the corresponding option \
has been set.\
\>", "Text",
  CellTags->"Compile::cxcoerce"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::cxcoerce"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, 1 + I]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::cxcoerce"],

Cell[BoxData[
    \(Compile::"realcoerce" \(\(:\)\(\ \)\) 
      "Warning, compilation of \!\(1 + \[ImaginaryI]\) has coerced an exact \
number to an approximate real number."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Compile::cxcoerce"],

Cell[BoxData[
    \(Compile::"cxcoerce" \(\(:\)\(\ \)\) 
      "Warning, compilation of \!\(1 + \[ImaginaryI]\) has coerced an exact \
number to an approximate complex number."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Compile::cxcoerce"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, 1 + \[ImaginaryI], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::cxcoerce"]
}, Open  ]],

Cell["Reset the option.", "Text",
  CellTags->"Compile::cxcoerce"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] False}];\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Compile::cxcoerce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::defn", "ObjectNameWarningMessages",
  CellTags->"Compile::defn"],

Cell[BoxData[
    \(Compile::"defn" \(\(:\)\(\ \)\) 
      "CompileValue `1` for `2` is not an expression of length 2."\)], \
"Message",
  CellLabel->"From In[446]:=",
  CellTags->"Compile::defn"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Compile::defn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::part", "ObjectNameWarningMessages",
  CellTags->"Compile::part"],

Cell[BoxData[
    \(Compile::"part" \(\(:\)\(\ \)\) 
      "Part specification `1` cannot be compiled since the argument is not a \
tensor of sufficent rank. Evaluation will use the uncompiled function."\)], \
"Message",
  CellLabel->"From In[450]:=",
  CellTags->"Compile::part"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Compile::part"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::symdef", "ObjectNameWarningMessages",
  CellTags->"Compile::symdef"],

Cell[BoxData[
    \(Compile::"symdef" \(\(:\)\(\ \)\) 
      "The symbol `1` used in assignment `2` has not been declared as a local \
variable."\)], "Message",
  CellLabel->"From In[454]:=",
  CellTags->"Compile::symdef"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Compile::symdef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::nocomp", "ObjectNameWarningMessages",
  CellTags->"Compile::nocomp"],

Cell[BoxData[
    \(Compile::"nocomp" \(\(:\)\(\ \)\) 
      "The expression `1` cannot be compiled due to the presence of `2`. \
Evaluation will use the uncompiled function."\)], "Message",
  CellLabel->"From In[458]:=",
  CellTags->"Compile::nocomp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Compile::nocomp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::extscalar", "ObjectNameWarningMessages",
  CellTags->"Compile::extscalar"],

Cell[BoxData[
    \(Compile::"extscalar" \(\(:\)\(\ \)\) 
      "`1` cannot be compiled and will be evaluated externally. The result is \
assumed to be of type `2`."\)], "Message",
  CellLabel->"From In[75]:=",
  CellTags->"Compile::extscalar"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression will \
be handled by external evaluation, and the result is assumed to be a scalar.
\[FilledSmallSquare] This message is generated only if a special option for \
that purpose has been set.\
\>", "Notes",
  CellTags->"Compile::extscalar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::extscalar"],

Cell["\<\
A message is generated in this example after the corresponding \
option has been set.\
\>", "Text",
  CellTags->"Compile::extscalar"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportExternal\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::extscalar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{x}, f[x] + x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::extscalar"],

Cell[BoxData[
    \(Compile::"extscalar" \(\(:\)\(\ \)\) 
      "\!\(f[x]\) cannot be compiled and will be evaluated externally. The \
result is assumed to be of type \!\(Real\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Compile::extscalar"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, f[x] + x, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::extscalar"]
}, Open  ]],

Cell["Reset the option.", "Text",
  CellTags->"Compile::extscalar"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportExternal\>" \[Rule] False}];\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Compile::extscalar"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::exttensor", "ObjectNameWarningMessages",
  CellTags->"Compile::exttensor"],

Cell[BoxData[
    \(Compile::"exttensor" \(\(:\)\(\ \)\) 
      "`1` cannot be compiled and will be evaluated externally. The result is \
assumed to be a rank `3` tensor of type `2`."\)], "Message",
  CellLabel->"From In[75]:=",
  CellTags->"Compile::exttensor"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression will \
be handled by external evaluation and the result is assumed to be a tensor.
\[FilledSmallSquare] This message is generated only if a special option for \
that purpose has been set.\
\>", "Notes",
  CellTags->"Compile::exttensor"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::exttensor"],

Cell["\<\
A message is generated in this example after the corresponding \
option has been set.\
\>", "Text",
  CellTags->"Compile::exttensor"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportExternal\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::exttensor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{{x, _Real, 1}}, f[x] + x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::exttensor"],

Cell[BoxData[
    \(Compile::"exttensor" \(\(:\)\(\ \)\) 
      "\!\(f[x]\) cannot be compiled and will be evaluated externally. The \
result is assumed to be a rank \!\(1\) tensor of type \!\(Real\)."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"Compile::exttensor"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, f[x] + x, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::exttensor"]
}, Open  ]],

Cell["Reset the option.", "Text",
  CellTags->"Compile::exttensor"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportExternal\>" \[Rule] False}];\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Compile::exttensor"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::initvar", "ObjectNameWarningMessages",
  CellTags->"Compile::initvar"],

Cell[BoxData[
    \(Compile::"initvar" \(\(:\)\(\ \)\) 
      "The variable `1` has not been initialized or has been initialized to \
Null."\)], "Message",
  CellLabel->"From In[75]:=",
  CellTags->"Compile::initvar"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression with an \
uninitialized local variable is compiled.\
\>", "Notes",
  CellTags->"Compile::initvar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::initvar"],

Cell[TextData[{
  "An error occurs in this example because the local variable in ",
  StyleBox["Block", "MR"],
  " is not assigned a value."
}], "Text",
  CellTags->"Compile::initvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Block[{x}, x + 1]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::initvar"],

Cell[BoxData[
    \(Compile::"initvar" \(\(:\)\(\ \)\) 
      "The variable \!\(x\) has not been initialized or has been initialized \
to Null."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::initvar"],

Cell[BoxData[
    \(Compile::"cptype" \(\(:\)\(\ \)\) 
      "\!\(Plus\) not supported for type \!\(\"Void\"\); evaluation will use \
the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Compile::initvar"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Block[{x}, x + 1], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Compile::initvar"]
}, Open  ]],

Cell["This shows one way to initialize a local variable.", "Text",
  CellTags->"Compile::initvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, Block[{x = 2}, x + 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::initvar"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, Block[{x = 2}, x + 1], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::initvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::maxrank", "ObjectNameWarningMessages",
  CellTags->"Compile::maxrank"],

Cell[BoxData[
    RowBox[{\(Compile::"maxrank"\), \(\(:\)\(\ \)\), "Rank", " ", 
      "specification", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "exceeds", " ", "the", " ", "rank", " ", "limit", " ", 
      RowBox[{
        RowBox[{"(", 
          StyleBox["max",
            "TI"], ")"}], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Compile::maxrank"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Compile::maxrank"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::realcoerce", "ObjectNameWarningMessages",
  CellTags->"Compile::realcoerce"],

Cell[BoxData[
    \(Compile::"realcoerce" \(\(:\)\(\ \)\) 
      "Warning, compilation of `1` has coerced an exact number to an \
approximate real number."\)], "Message",
  CellLabel->"From In[75]:=",
  CellTags->"Compile::realcoerce"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Compile", "MR"],
  " converts an exact number into an inexact real number.\n\
\[FilledSmallSquare] This message is used only if a special option for that  \
purpose has been set."
}], "Notes",
  CellTags->"Compile::realcoerce"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Compile::realcoerce"],

Cell["\<\
A message about coercion is generated in this example if the \
corresponding option has been set.\
\>", "Text",
  CellTags->"Compile::realcoerce"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Compile::realcoerce"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Compile[{}, 1 + Pi]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Compile::realcoerce"],

Cell[BoxData[
    \(Compile::"realcoerce" \(\(:\)\(\ \)\) 
      "Warning, compilation of \!\(1 + \[Pi]\) has coerced an exact number to \
an approximate real number."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Compile::realcoerce"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, 1 + \[Pi], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Compile::realcoerce"]
}, Open  ]],

Cell["Reset the option.", "Text",
  CellTags->"Compile::realcoerce"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] False}];\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Compile::realcoerce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compile::type", "ObjectNameWarningMessages",
  CellTags->"Compile::type"],

Cell[BoxData[
    \(Compile::"type" \(\(:\)\(\ \)\) 
      "Type specification `1` is not legal. A legal type is of the form \
{name, typepattern} or {name, typepattern, rank}."\)], "Message",
  CellLabel->"From In[76]:=",
  CellTags->"Compile::type"],

Cell["\<\
\[FilledSmallSquare] This message is associated with experimental \
functionality that is not yet intended for general use.\
\>", "Notes",
  CellTags->"Compile::type"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::ccf", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::ccf"],

Cell[BoxData[
    RowBox[{\(CompiledFunction::"ccf"\), \(\(:\)\(\ \)\), \(\(Result\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(of\ external\ evaluation\ does\ not\ have\ the\ \
correct\ \(\(form\)\(.\)\)\)\)}]], "Message",
  CellTags->"CompiledFunction::ccf"],

Cell["\<\
\[FilledSmallSquare] Generated when compiled evaluation calls \
uncompiled evaluation and the uncompiled evaluation returns an expression \
with an unexpected form.
\[FilledSmallSquare] Compiled evaluation calls external (uncompiled) \
evaluation to compute values for expressions that are not recognized by the \
compiler.\
\>", "Notes",
  CellTags->"CompiledFunction::ccf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::ccf"],

Cell["\<\
An error occurs in this example because of a special evaluation \
rule associated with a parameter that is computed using uncompiled \
evaluation.\
\>", "Text",
  CellTags->"CompiledFunction::ccf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x}, x /: {x} = 99; \(Compile[{}, Print[1 + x]]\)[]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::ccf"],

Cell[BoxData[
    \(CompiledFunction::"ccf" \(\(:\)\(\ \)\) 
      "Result \!\(99\) of external evaluation does not have the correct \
form."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::ccf"],

Cell[BoxData[
    \(CompiledFunction::"cfex" \(\(:\)\(\ \)\) 
      "External evaluation error at instruction \!\(3\); proceeding with \
uncompiled evaluation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::ccf"],

Cell[BoxData[
    \(1 + x\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::ccf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfcode", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfcode"],

Cell[BoxData[
    RowBox[{\(CompiledFunction::"cfcode"\), \(\(:\)\(\ \)\), \(\(Invalid\)\(\ \
\)\(opcode\)\(\ \)\), 
      StyleBox["expr",
        "TI"], 
      RowBox[{";", " ", 
        RowBox[{\(a\ non\), "-", 
          RowBox[{"negative", " ", "integer", " ", "less", " ", "than", " ", 
            StyleBox["n",
              "TI"], " ", "is", " ", \(\(expected\)\(.\)\)}]}]}]}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CompiledFunction::cfcode"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a ",
  StyleBox["CompiledFunction", "MR"],
  " expression is constructed incorrectly.\n\[FilledSmallSquare] ",
  StyleBox["CompiledFunction", "MR"],
  " expressions are generated by ",
  StyleBox["Compile", "MR"],
  ", and are not often entered directly.\n\[FilledSmallSquare] If you see  \
this message for a ",
  StyleBox["CompiledFunction", "MR"],
  " expression generated by ",
  StyleBox["Compile", "MR"],
  " please contact Technical Support."
}], "Notes",
  CellTags->"CompiledFunction::cfcode"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfct", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfct"],

Cell[BoxData[
    RowBox[{\(CompiledFunction::"cfct"\), \(\(:\)\(\ \)\), "Number", " ", 
      "of", " ", "arguments", " ", 
      StyleBox["n1",
        "TI"], " ", "does", " ", "not", " ", "match", " ", "the", " ", 
      "length", " ", 
      StyleBox["n2",
        "TI"], " ", "of", " ", "the", " ", "argument", 
      " ", \(\(template\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CompiledFunction::cfct"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of arguments passed to a ",
  StyleBox["CompiledFunction", "MR"],
  " expression does not match the expected number of arguments."
}], "Notes",
  CellTags->"CompiledFunction::cfct"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfct"],

Cell[TextData[{
  "An error occurs in this example because the ",
  StyleBox["CompiledFunction", "MR"],
  " expression constructed by ",
  StyleBox["Compile", "MR"],
  " expects two arguments."
}], "Text",
  CellTags->"CompiledFunction::cfct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = Compile[{p, q}, p + q]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfct"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{p, q}, p + q, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfct"],

Cell[BoxData[
    \(CompiledFunction::"cfct" \(\(:\)\(\ \)\) 
      "Number of arguments \!\(1\) does not match the length \!\(2\) of the \
argument template."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfct"],

Cell[BoxData[
    RowBox[{
      TagBox[\(CompiledFunction[{p, q}, p + q, "-CompiledCode-"]\),
        False,
        Editable->False], "[", "2", "]"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]],

Cell["\<\
Compiled evaluation proceeds without error if the required number \
of arguments is given.\
\>", "Text",
  CellTags->"CompiledFunction::cfct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[2, 3]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cfct"],

Cell[BoxData[
    \(5.`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["cf", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cfct"],

Cell[BoxData[
    \(Clear[cf]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfex", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(CompiledFunction::"cfex"\), \(\(:\)\(\ \)\), "External", " ", 
        "evaluation", " ", "error", " ", "at", " ", "instruction", " ", 
        StyleBox["n",
          "TI"]}], ";", 
      " ", \(proceeding\ with\ uncompiled\ \(\(evaluation\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CompiledFunction::cfex"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the compiler calls external  \
(uncompiled) evaluation to compute the value of an expression and the result  \
does not have the expected form.\n\[FilledSmallSquare] This message will  \
often be preceded by other messages that provide additional details about the \
 error.\n\[FilledSmallSquare] External evaluation is evaluation that is done  \
outside of the compiler.\n\[FilledSmallSquare] External evaluation is used  \
for expressions that are not recognized by the compiler, such as symbolic  \
global variables.\n\[FilledSmallSquare] The instruction referred to in the  \
warning message can be found in the fourth argument of the ",
  StyleBox["CompiledFunction", "MR"],
  " expression.  This instruction will always correspond to external  \
evaluation."
}], "Notes",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfex"],

Cell[TextData[{
  "An error occurs in this example because the global variable in the ",
  StyleBox["CompiledFunction", "MR"],
  " expression is expected to evaluate to a real number."
}], "Text",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = Compile[{}, x + 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, x + 1, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    \(CompiledFunction::"cfse" \(\(:\)\(\ \)\) 
      "Compiled expression \!\(x\) should be a \!\(\"machine-size real number\
\"\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    \(CompiledFunction::"cfex" \(\(:\)\(\ \)\) 
      "External evaluation error at instruction \!\(2\); proceeding with \
uncompiled evaluation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    \(1 + x\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],

Cell["\<\
Compiled evaluation proceeds without difficulty if the result of \
external evaluation is a real number.\
\>", "Text",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x = 1.2}, cf[]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    \(2.2`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],

Cell[TextData[{
  "The specific instruction that led to the error can be obtained from the ",
  StyleBox["CompiledFunction", "MR"],
  " expression.  This instruction will always correspond to external  \
evaluation.  It is sometimes possible to determine the cause of the error by  \
looking at the arguments of this instruction."
}], "Text",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[\([4, 2]\)]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    \({21, Function[{}, x], 3, 0, 0}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["cf", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cfex"],

Cell[BoxData[
    \(Clear[cf]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfff", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfff"],

Cell[BoxData[
    RowBox[{\(CompiledFunction::"cfff"\), ":", " ", 
      RowBox[{"Fifth", " ", "argument", " ", 
        StyleBox["expr",
          
          "TI"], \(\(\ \)\(should\ be\ of\ the\ form\ \(\(Function[{args}, \ 
              expr]\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CompiledFunction::cfff"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a ",
  StyleBox["CompiledFunction", "MR"],
  " expression is constructed incorrectly.\n\[FilledSmallSquare] ",
  StyleBox["CompiledFunction", "MR"],
  " expressions are generated by ",
  StyleBox["Compile", "MR"],
  " and are not often entered directly.\n\[FilledSmallSquare] The fifth  \
argument in ",
  StyleBox["CompiledFunction", "MR"],
  " is expected to be a ",
  StyleBox["Function", "MR"],
  " expression.\n\[FilledSmallSquare] If you see this message for a ",
  StyleBox["CompiledFunction", "MR"],
  " expression generated by ",
  StyleBox["Compile", "MR"],
  ", please contact Technical Support."
}], "Notes",
  CellTags->"CompiledFunction::cfff"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cffv", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cffv"],

Cell[BoxData[
    RowBox[{\(CompiledFunction::"cffv"\), \(\(:\)\(\ \)\), \(\(First\)\(\ \
\)\(operation\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(does\ not\ check\ for\ correct\ version\ \
\(\(number\)\(.\)\)\)\)}]], "Message",
  CellTags->"CompiledFunction::cffv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a ",
  StyleBox["CompiledFunction", "MR"],
  " expression is constructed incorrectly.\n\[FilledSmallSquare] The first  \
instruction in a ",
  StyleBox["CompiledFunction", "MR"],
  " expression should be the instruction that checks the version of the  \
compiler.  Instructions are listed in the third element of a ",
  StyleBox["CompiledFunction", "MR"],
  " expression.\n\[FilledSmallSquare] ",
  StyleBox["CompiledFunction", "MR"],
  " expressions are generated by ",
  StyleBox["Compile", "MR"],
  " and are not often entered directly.\n\[FilledSmallSquare] If you see this \
 message for a ",
  StyleBox["CompiledFunction", "MR"],
  " expression generated by ",
  StyleBox["Compile", "MR"],
  ", please contact Technical Support."
}], "Notes",
  CellTags->"CompiledFunction::cffv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfins", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfins"],

Cell[BoxData[
    RowBox[{\(CompiledFunction::"cfins"\), \(\(:\)\(\ \)\), "Arguments", " ", 
      "in", " ", "instruction", " ", "number", " ", 
      StyleBox["n",
        "TI"], " ", "do", " ", "not", " ", "have", " ", "the", " ", "correct",
       " ", \(\(form\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CompiledFunction::cfins"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a ",
  StyleBox["CompiledFunction", "MR"],
  " expression is constructed incorrectly.\n\[FilledSmallSquare] ",
  StyleBox["CompiledFunction", "MR"],
  " expressions are generated by ",
  StyleBox["Compile", "MR"],
  " and are not often entered directly.\n\[FilledSmallSquare] If you see this \
 message for a ",
  StyleBox["CompiledFunction", "MR"],
  " expression generated by ",
  StyleBox["Compile", "MR"],
  ", please contact Technical Support.\n\[FilledSmallSquare] Instructions are \
 specified in a list in the fourth argument of the ",
  StyleBox["CompiledFunction", "MR"],
  " expression.\n\[FilledSmallSquare] This error occurs if the arguments of  \
the indicated instruction do not have the expected form for that  \
instruction."
}], "Notes",
  CellTags->"CompiledFunction::cfins"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cflist", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cflist"],

Cell[BoxData[
    \(CompiledFunction::"cflist" \(\(:\)\(\ \)\) \(Non - 
        tensor\ object\ generated; \ 
      proceeding\ with\ uncompiled\ \(\(evaluation\)\(.\)\)\)\)], "Message",
  CellTags->"CompiledFunction::cflist"],

Cell["\<\
\[FilledSmallSquare] Generated during compiled evaluation when an \
expression that is not a tensor occurs as an intermediate result that is \
expected to be a tensor.
\[FilledSmallSquare] This error usually indicates a mismatch of tensor \
dimensions in addition, multiplication, or other operations that construct \
tensor results.
\[FilledSmallSquare] A matching error will often occur during the subsequent \
uncompiled evaluation.  The problem can then be identified by analyzing the \
corresponding uncompiled program.\
\>", "Notes",
  CellTags->"CompiledFunction::cflist"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cflist"],

Cell["\<\
An error occurs in this example because tensors of unequal length \
cannot be added.\
\>", "Text",
  CellTags->"CompiledFunction::cflist"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Compile[{}, {1, 2, 3} + {4, 5}]\)[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cflist"],

Cell[BoxData[
    \(CompiledFunction::"cflist" \(\(:\)\(\ \)\) 
      "Non-tensor object generated; proceeding with uncompiled \
evaluation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::cflist"],

Cell[BoxData[
    \(Thread::"tdlen" \(\(:\)\(\ \)\) 
      "Objects of unequal length in \!\(\(\({1, 2, 3}\)\) + \(\({4, 5}\)\)\) \
cannot be combined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::cflist"],

Cell[BoxData[
    \({4, 5} + {1, 2, 3}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cflist"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfn", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfn"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(CompiledFunction::"cfn"\), \(\(:\)\(\ \)\), "Numerical", " ", 
        "error", " ", "encountered", " ", "at", " ", "instruction", " ", 
        StyleBox["n",
          "TI"]}], ";", 
      " ", \(proceeding\ with\ uncompiled\ \(\(evaluation\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CompiledFunction::cfn"],

Cell["\<\
\[FilledSmallSquare] Generated by various numerical errors during \
compiled evaluation, such as numerical overflow and underflow, or invalid \
numerical function arguments.
\[FilledSmallSquare] This message can also be generated by errors in the \
construction of tensors.\
\>", "Notes",
  CellTags->"CompiledFunction::cfn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfn"],

Cell["\<\
An error occurs in this example because the result exceeds the \
largest machine number on this computer.\
\>", "Text",
  CellTags->"CompiledFunction::cfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Compile[{}, 999.9^999]\)[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfn"],

Cell[BoxData[
    \(CompiledFunction::"cfn" \(\(:\)\(\ \)\) 
      "Numerical error encountered at instruction \!\(12\); proceeding with \
uncompiled evaluation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::cfn"],

Cell[BoxData[
    \(9.04923385897117284919543336541`14.592861934173412*^2996\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfn"]
}, Open  ]],

Cell[TextData[{
  "This example generates an error because the integer result from ",
  StyleBox["Floor", "MR"],
  " is larger than the largest machine integer on this computer."
}], "Text",
  CellTags->"CompiledFunction::cfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Compile[{}, Module[{x = 2.7*^35}, Floor[x]]]\)[]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfn"],

Cell[BoxData[
    \(CompiledFunction::"cfn" \(\(:\)\(\ \)\) 
      "Numerical error encountered at instruction \!\(3\); proceeding with \
uncompiled evaluation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfn"],

Cell[BoxData[
    \(270000000000000002599134935604264960\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CompiledFunction::cfn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfnlts", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfnlts"],

Cell[BoxData[
    RowBox[{\(CompiledFunction::"cfnlts"\), \(\(:\)\(\ \)\), \(Null\ tensor\ \
with\ rank\  > \ \(\(1\)\(\ \)\(encountered\)\(\ \)\(at\)\(\ \
\)\(instruction\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\(;\)\(\ \)\(proceeding\ with\ uncompiled\ \
\(\(evaluation\)\(.\)\)\)\)}]], "Message",
  CellTags->"CompiledFunction::cfnlts"],

Cell["\<\
\[FilledSmallSquare] Generated during compiled evaluation when a \
tensor with no elements is encountered.\
\>", "Notes",
  CellTags->"CompiledFunction::cfnlts"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfnlts"],

Cell["\<\
An error is generated in this example because the result is a \
tensor with no elements in one of the expected dimensions.\
\>", "Text",
  CellTags->"CompiledFunction::cfnlts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Compile[{}, Table[{1}, {0}]]\)\ []\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfnlts"],

Cell[BoxData[
    \(CompiledFunction::"cfnlts" \(\(:\)\(\ \)\) 
      "Null tensor with rank > 1 encountered at instruction \!\(4\); \
proceeding with uncompiled evaluation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::cfnlts"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfnlts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfnv", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfnv"],

Cell[BoxData[
    \(CompiledFunction::"cfnv" \(\(:\)\(\ \)\) \(CompiledFunction\ object\ is\
\ invalid\ and\ cannot\ be\ \(\(used\)\(.\)\)\)\)], "Message",
  CellTags->"CompiledFunction::cfnv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an invalid ",
  StyleBox["CompiledFunction", "MR"],
  " expression is used.\n\[FilledSmallSquare] ",
  StyleBox["CompiledFunction", "MR"],
  " expressions are generated by ",
  StyleBox["Compile", "MR"],
  " and are not often entered directly.\n\[FilledSmallSquare] If you see this \
 message for a ",
  StyleBox["CompiledFunction", "MR"],
  " expression generated by ",
  StyleBox["Compile", "MR"],
  ", please contact Technical Support.\n\[FilledSmallSquare] This message  \
will normally be preceded by messages that are generated when the invalid ",
  StyleBox["CompiledFunction", "MR"],
  " expression is entered."
}], "Notes",
  CellTags->"CompiledFunction::cfnv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfnv"],

Cell[TextData[{
  "An error is generated in this example because the ",
  StyleBox["CompiledFunction", "MR"],
  " expression does not have a valid form.  "
}], "Text",
  CellTags->"CompiledFunction::cfnv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CompiledFunction[]\)[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfnv"],

Cell[BoxData[
    \(CompiledFunction::"argrx" \(\(:\)\(\ \)\) 
      "\!\(CompiledFunction\) called with \!\(0\) arguments; \!\(6\) \
arguments are expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::cfnv"],

Cell[BoxData[
    \(CompiledFunction::"argrx" \(\(:\)\(\ \)\) 
      "\!\(CompiledFunction\) called with \!\(0\) arguments; \!\(6\) \
arguments are expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::cfnv"],

Cell[BoxData[
    \(CompiledFunction::"cfnv" \(\(:\)\(\ \)\) 
      "CompiledFunction object is invalid and cannot be used."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CompiledFunction::cfnv"],

Cell[BoxData[
    RowBox[{
      TagBox[\(CompiledFunction[]\),
        False,
        Editable->False], "[", "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfnv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfsa", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfsa"],

Cell[BoxData[
    \(CompiledFunction::"cfsa" \(\(:\)\(\ \)\) 
      "Argument `1` at position `2` should be a `3`."\)], "Message",
  CellLabel->"From In[76]:=",
  CellTags->"CompiledFunction::cfsa"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument passed to a ",
  StyleBox["CompiledFunction", "MR"],
  " expression does not have the expected type."
}], "Notes",
  CellTags->"CompiledFunction::cfsa"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfsa"],

Cell[TextData[{
  "An error occurs in this example because the argument passed to the ",
  StyleBox["CompiledFunction", "MR"],
  " expression is an inexact real number rather than an integer."
}], "Text",
  CellTags->"CompiledFunction::cfsa"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = Compile[{{x, _Integer}}, x + 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfsa"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, x + 1, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[1.5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfsa"],

Cell[BoxData[
    \(CompiledFunction::"cfsa" \(\(:\)\(\ \)\) 
      "Argument \!\(1.5`\) at position \!\(1\) should be a \!\(\"machine-size \
integer\"\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfsa"],

Cell[BoxData[
    \(2.5`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]],

Cell["\<\
Compiled evaluation proceeds without error if the argument has the \
expected type.\
\>", "Text",
  CellTags->"CompiledFunction::cfsa"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[5]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cfsa"],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["cf", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cfsa"],

Cell[BoxData[
    \(Clear[cf]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfse", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    \(CompiledFunction::"cfse" \(\(:\)\(\ \)\) 
      "Compiled expression `1` should be a `2`."\)], "Message",
  CellLabel->"From In[76]:=",
  CellTags->"CompiledFunction::cfse"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when external evaluation leads to an  \
expression of an unexpected type.\n\[FilledSmallSquare] External evaluation  \
is used to obtain values for symbols and functions that are not handled  \
within the ",
  StyleBox["CompiledFunction", "MR"],
  " interpreter."
}], "Notes",
  CellTags->"CompiledFunction::cfse"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfse"],

Cell["\<\
An error occurs in this example because the compiler assumes by \
default that the value of the global symbol will be a real number.\
\>", \
"Text",
  CellTags->"CompiledFunction::cfse"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = Compile[{}, x + 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, x + 1, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x = 1.7 + 3.2  I}, cf[]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    \(CompiledFunction::"cfse" \(\(:\)\(\ \)\) 
      "Compiled expression \!\(\(\(1.7`\[InvisibleSpace]\)\) + \(\(3.2`\\ \
\[ImaginaryI]\)\)\) should be a \!\(\"machine-size real number\"\)."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    \(CompiledFunction::"cfex" \(\(:\)\(\ \)\) 
      "External evaluation error at instruction \!\(2\); proceeding with \
uncompiled evaluation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    \(\(\(2.7`\)\(\[InvisibleSpace]\)\) + 3.2`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],

Cell[TextData[{
  "The third argument in ",
  StyleBox["Compile", "MR"],
  " can be used to specify the return type of external evaluations."
}], "Text",
  CellTags->"CompiledFunction::cfse"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = Compile[{}, x + 1, {{x, _Complex}}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{}, x + 1, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x = 1.7 + 3.2  I}, cf[]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    \(\(\(2.7`\)\(\[InvisibleSpace]\)\) + 3.2`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["cf", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cfse"],

Cell[BoxData[
    \(Clear[cf]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfsec", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfsec"],

Cell[BoxData[
    \(CompiledFunction::"cfsec" \(\(:\)\(\ \)\) 
      "Warning: Compiled expression `1` was coerced to a `2`."\)], "Message",
  CellLabel->"From In[76]:=",
  CellTags->"CompiledFunction::cfsec"],

Cell["\<\
\[FilledSmallSquare] Generated when type coercion occurs for the \
indicated expression during compiled evaluation.
\[FilledSmallSquare] This message is generated only if a special option for \
that purpose has been set.\
\>", "Notes",
  CellTags->"CompiledFunction::cfsec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfsec"],

Cell["\<\
A message is generated in this example after an option to generate \
that message has been set.\
\>", "Text",
  CellTags->"CompiledFunction::cfsec"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfsec"],

Cell[BoxData[
    \(ftest[x_] := 1\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfsec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Compile[{x}, ftest[x]]\)[99]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cfsec"],

Cell[BoxData[
    \(CompiledFunction::"cfsec" \(\(:\)\(\ \)\) 
      "Warning: Compiled expression \!\(1\) was coerced to a \
\!\(\"machine-size real number\"\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"CompiledFunction::cfsec"],

Cell[BoxData[
    \(1.`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cfsec"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["ftest", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cfsec"],

Cell[BoxData[
    \(Clear[ftest]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cfsec"],

Cell["Reset the option.", "Text",
  CellTags->"CompiledFunction::cfsec"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] False}];\)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"CompiledFunction::cfsec"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfta", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfta"],

Cell[BoxData[
    \(CompiledFunction::"cfta" \(\(:\)\(\ \)\) 
      "Argument `1` at position `2` should be a rank `3` tensor of `4`s."\)], \
"Message",
  CellLabel->"From In[77]:=",
  CellTags->"CompiledFunction::cfta"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument passed to a ",
  StyleBox["CompiledFunction", "MR"],
  " expression does not have the expected tensor type."
}], "Notes",
  CellTags->"CompiledFunction::cfta"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfta"],

Cell[TextData[{
  "An error occurs in this example because the argument passed to the ",
  StyleBox["CompiledFunction", "MR"],
  " expression is a number rather than a vector."
}], "Text",
  CellTags->"CompiledFunction::cfta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = Compile[{{x, _Real, 1}}, Length[x]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfta"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, Length[x], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[1.7]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfta"],

Cell[BoxData[
    \(CompiledFunction::"cfta" \(\(:\)\(\ \)\) 
      "Argument \!\(1.7`\) at position \!\(1\) should be a rank \!\(1\) \
tensor of \!\(\"machine-size real number\"\)s."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfta"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]],

Cell["\<\
Compiled evaluation proceeds without error if the argument has the \
expected type.\
\>", "Text",
  CellTags->"CompiledFunction::cfta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[{1.7}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cfta"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["cf", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cfta"],

Cell[BoxData[
    \(Clear[cf]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfte", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfte"],

Cell[BoxData[
    \(CompiledFunction::"cfte" \(\(:\)\(\ \)\) 
      "Compiled expression `1` should be a rank `2` tensor of `3`s."\)], \
"Message",
  CellLabel->"From In[77]:=",
  CellTags->"CompiledFunction::cfte"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when external evaluation leads to an  \
expression of an unexpected type.\n\[FilledSmallSquare] External evaluation  \
is used to obtain values for symbols and functions that are not handled  \
within the ",
  StyleBox["CompiledFunction", "MR"],
  " interpreter.\n\[FilledSmallSquare] The return type of an external  \
evaluation can be specified using the third argument in ",
  StyleBox["Compile", "MR"],
  "."
}], "Notes",
  CellTags->"CompiledFunction::cfte"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cfte"],

Cell["\<\
An error occurs in this example because the compiler assumes by \
default that the value of the global symbol will be a vector with real \
elements.\
\>", "Text",
  CellTags->"CompiledFunction::cfte"],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf = Compile[{{x, _Real, 1}}, x . y, {{y, _Real, 1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cfte"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, x . y, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(cf[{1, 2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cfte"],

Cell[BoxData[
    \(CompiledFunction::"cfte" \(\(:\)\(\ \)\) 
      "Compiled expression \!\(y\) should be a rank \!\(1\) tensor of \
\!\(\"machine-size real number\"\)s."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfte"],

Cell[BoxData[
    \(CompiledFunction::"cfex" \(\(:\)\(\ \)\) 
      "External evaluation error at instruction \!\(2\); proceeding with \
uncompiled evaluation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"CompiledFunction::cfte"],

Cell[BoxData[
    \({1, 2, 3} . y\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]],

Cell["\<\
Compiled evaluation proceeds without error if external evaluation \
gives an expression of the expected type.\
\>", "Text",
  CellTags->"CompiledFunction::cfte"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{y = {3, 2, 1}}, cf[{1, 2, 3}]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cfte"],

Cell[BoxData[
    \(10.`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["cf", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cfte"],

Cell[BoxData[
    \(Clear[cf]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cftec", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cftec"],

Cell[BoxData[
    \(CompiledFunction::"cftec" \(\(:\)\(\ \)\) 
      "Warning: Compiled expression `1` was coerced to a rank `2` tensor of \
`3`s."\)], "Message",
  CellLabel->"From In[77]:=",
  CellTags->"CompiledFunction::cftec"],

Cell["\<\
\[FilledSmallSquare] Generated when type coercion occurs for the \
indicated expression during compiled evaluation.
\[FilledSmallSquare] This message is generated only if a special option for \
that purpose has been set.\
\>", "Notes",
  CellTags->"CompiledFunction::cftec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CompiledFunction::cftec"],

Cell["\<\
A message is generated in this example after an option to generate \
that message has been set.\
\>", "Text",
  CellTags->"CompiledFunction::cftec"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] True}];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CompiledFunction::cftec"],

Cell[BoxData[
    \(ftest[x_] := {1}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CompiledFunction::cftec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Compile[{{x, _Real, 1}}, ftest[x]]\)[{5.6}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"CompiledFunction::cftec"],

Cell[BoxData[
    \(CompiledFunction::"cftec" \(\(:\)\(\ \)\) 
      "Warning: Compiled expression \!\({1}\) was coerced to a rank \!\(1\) \
tensor of \!\(\"machine-size real number\"\)s."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"CompiledFunction::cftec"],

Cell[BoxData[
    \({1.`}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"CompiledFunction::cftec"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["ftest", "MR"],
  "."
}], "Text",
  CellTags->"CompiledFunction::cftec"],

Cell[BoxData[
    \(Clear[ftest]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"CompiledFunction::cftec"],

Cell["Reset the option.", "Text",
  CellTags->"CompiledFunction::cftec"],

Cell[BoxData[
    \(\(Developer`SetSystemOptions["\<CompileOptions\>" \[Rule] \
{"\<CompileReportCoercion\>" \[Rule] False}];\)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"CompiledFunction::cftec"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::cfver", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfver"],

Cell[BoxData[
    \(CompiledFunction::"cfver" \(\(:\)\(\ \)\) \(Incorrect\ version\ number; \
\ CompiledFunction\ object\ cannot\ be\ \(\(used\)\(.\)\)\)\)], "Message",
  CellTags->"CompiledFunction::cfver"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the instruction that checks the  \
version in a ",
  StyleBox["CompiledFunction", "MR"],
  " expression gives a version that is not the same as the version of the ",
  StyleBox["CompiledFunction", "MR"],
  " interpreter that is being used.\n\[FilledSmallSquare] This error will not \
 occur in a standard version of ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " as the incorrect version instruction will prevent the construction of a  \
valid ",
  StyleBox["CompiledFunction", "MR"],
  " expression.\n\[FilledSmallSquare] If you see this message in a standard  \
version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", please contact Technical Support."
}], "Notes",
  CellTags->"CompiledFunction::cfver"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::mldot", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::mldot"],

Cell[BoxData[
    \(CompiledFunction::"mldot" \(\(:\)\(\ \)\) \(MathLink\ compiler\ cannot\ \
interpret\ Dot, \ Det, \ and\ Inverse\ operations; \ 
      proceeding\ with\ uncompiled\ \(\(evaluation\)\(.\)\)\)\)], "Message",
  CellTags->"CompiledFunction::mldot"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in standard versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] This message is intended for use with an  \
interpreter than uses ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " to send ",
  StyleBox["CompiledFunction", "MR"],
  " instructions to an external program."
}], "Notes",
  CellTags->"CompiledFunction::mldot"]
}, Open  ]],

Cell[CellGroupData[{

Cell["CompiledFunction::orank", "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::orank"],

Cell[BoxData[
    \(CompiledFunction::"orank" \(\(:\)\(\ \)\) 
      "The result of compiled Outer has encountered a result of lower rank \
than expected, due to a zero-length list; evaluation will use the uncompiled \
function."\)], "Message",
  CellLabel->"From In[547]:=",
  CellTags->"CompiledFunction::orank"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"CompiledFunction::orank"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 977}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{585, 593},
WindowMargins->{{Automatic, 174}, {Automatic, 21}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Compile::argset"->{
    Cell[1825, 57, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::argset"],
    Cell[1911, 60, 403, 10, 37, "Message",
      CellTags->"Compile::argset"],
    Cell[2317, 72, 339, 7, 62, "Notes",
      CellTags->"Compile::argset"],
    Cell[2681, 83, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::argset"],
    Cell[2749, 86, 154, 5, 24, "Text",
      CellTags->"Compile::argset"],
    Cell[2928, 95, 117, 3, 26, "Input",
      CellTags->"Compile::argset"],
    Cell[3048, 100, 227, 5, 37, "Message",
      CellTags->"Compile::argset"],
    Cell[3278, 107, 189, 5, 21, "Output",
      CellTags->"Compile::argset"],
    Cell[3482, 115, 167, 5, 24, "Text",
      CellTags->"Compile::argset"],
    Cell[3674, 124, 134, 3, 26, "Input",
      CellTags->"Compile::argset"],
    Cell[3811, 129, 92, 3, 21, "Output",
      CellTags->"Compile::argset"]},
  "Compile::iterset"->{
    Cell[3964, 139, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::iterset"],
    Cell[4052, 142, 237, 5, 53, "Message",
      CellTags->"Compile::iterset"],
    Cell[4292, 149, 127, 4, 24, "Notes",
      CellTags->"Compile::iterset"]},
  "Compile::compfail"->{
    Cell[4456, 158, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::compfail"],
    Cell[4546, 161, 225, 5, 37, "Message",
      CellTags->"Compile::compfail"],
    Cell[4774, 168, 128, 4, 24, "Notes",
      CellTags->"Compile::compfail"]},
  "Compile::ccon"->{
    Cell[4939, 177, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::ccon"],
    Cell[5021, 180, 276, 6, 37, "Message",
      CellTags->"Compile::ccon"],
    Cell[5300, 188, 340, 9, 56, "Notes",
      CellTags->"Compile::ccon"],
    Cell[5665, 201, 63, 1, 38, "ExampleSection",
      CellTags->"Compile::ccon"],
    Cell[5731, 204, 240, 8, 40, "Text",
      CellTags->"Compile::ccon"],
    Cell[5996, 216, 168, 4, 74, "Input",
      CellTags->"Compile::ccon"],
    Cell[6167, 222, 208, 5, 37, "Message",
      CellTags->"Compile::ccon"],
    Cell[6378, 229, 208, 5, 37, "Message",
      CellTags->"Compile::ccon"],
    Cell[6589, 236, 181, 5, 21, "Output",
      CellTags->"Compile::ccon"],
    Cell[6785, 244, 417, 11, 56, "Text",
      CellTags->"Compile::ccon"],
    Cell[7227, 259, 198, 5, 90, "Input",
      CellTags->"Compile::ccon"],
    Cell[7428, 266, 181, 5, 21, "Output",
      CellTags->"Compile::ccon"],
    Cell[7646, 276, 94, 3, 26, "Input",
      CellTags->"Compile::ccon"],
    Cell[7743, 281, 91, 3, 21, "Output",
      CellTags->"Compile::ccon"],
    Cell[7849, 287, 111, 5, 24, "Text",
      CellTags->"Compile::ccon"],
    Cell[7963, 294, 95, 3, 26, "Input",
      CellTags->"Compile::ccon"]},
  "Compile::cif"->{
    Cell[8107, 303, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cif"],
    Cell[8187, 306, 546, 10, 53, "Message",
      CellTags->"Compile::cif"],
    Cell[8736, 318, 300, 6, 62, "Notes",
      CellTags->"Compile::cif"],
    Cell[9061, 328, 62, 1, 38, "ExampleSection",
      CellTags->"Compile::cif"],
    Cell[9126, 331, 197, 5, 40, "Text",
      CellTags->"Compile::cif"],
    Cell[9348, 340, 163, 4, 42, "Input",
      CellTags->"Compile::cif"],
    Cell[9514, 346, 293, 6, 69, "Message",
      CellTags->"Compile::cif"],
    Cell[9810, 354, 188, 5, 21, "Output",
      CellTags->"Compile::cif"]},
  "Compile::cpapot"->{
    Cell[10059, 366, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpapot"],
    Cell[10145, 369, 254, 5, 53, "Message",
      CellTags->"Compile::cpapot"],
    Cell[10402, 376, 537, 17, 62, "Notes",
      CellTags->"Compile::cpapot"],
    Cell[10964, 397, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::cpapot"],
    Cell[11032, 400, 157, 5, 24, "Text",
      CellTags->"Compile::cpapot"],
    Cell[11214, 409, 129, 3, 26, "Input",
      CellTags->"Compile::cpapot"],
    Cell[11346, 414, 276, 6, 53, "Message",
      CellTags->"Compile::cpapot"],
    Cell[11625, 422, 184, 5, 21, "Output",
      CellTags->"Compile::cpapot"]},
  "Compile::cpbool"->{
    Cell[11870, 434, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpbool"],
    Cell[11956, 437, 477, 13, 53, "Message",
      CellTags->"Compile::cpbool"],
    Cell[12436, 452, 205, 7, 24, "Notes",
      CellTags->"Compile::cpbool"],
    Cell[12666, 463, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::cpbool"],
    Cell[12734, 466, 250, 9, 40, "Text",
      CellTags->"Compile::cpbool"],
    Cell[13009, 479, 128, 3, 26, "Input",
      CellTags->"Compile::cpbool"],
    Cell[13140, 484, 278, 6, 53, "Message",
      CellTags->"Compile::cpbool"],
    Cell[13421, 492, 210, 6, 21, "Output",
      CellTags->"Compile::cpbool"],
    Cell[13646, 501, 208, 7, 24, "Text",
      CellTags->"Compile::cpbool"],
    Cell[13879, 512, 132, 3, 26, "Input",
      CellTags->"Compile::cpbool"],
    Cell[14014, 517, 214, 6, 21, "Output",
      CellTags->"Compile::cpbool"]},
  "Compile::cpdsts"->{
    Cell[14289, 530, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpdsts"],
    Cell[14375, 533, 375, 7, 37, "Message",
      CellTags->"Compile::cpdsts"],
    Cell[14753, 542, 223, 7, 24, "Notes",
      CellTags->"Compile::cpdsts"],
    Cell[15001, 553, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::cpdsts"],
    Cell[15069, 556, 240, 5, 40, "Text",
      CellTags->"Compile::cpdsts"],
    Cell[15334, 565, 149, 4, 26, "Input",
      CellTags->"Compile::cpdsts"],
    Cell[15486, 571, 287, 6, 53, "Message",
      CellTags->"Compile::cpdsts"],
    Cell[15776, 579, 208, 6, 21, "Output",
      CellTags->"Compile::cpdsts"],
    Cell[15999, 588, 216, 5, 40, "Text",
      CellTags->"Compile::cpdsts"],
    Cell[16240, 597, 186, 5, 42, "Input",
      CellTags->"Compile::cpdsts"],
    Cell[16429, 604, 215, 6, 37, "Output",
      CellTags->"Compile::cpdsts"]},
  "Compile::cpint"->{
    Cell[16705, 617, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpint"],
    Cell[16789, 620, 473, 13, 53, "Message",
      CellTags->"Compile::cpint"],
    Cell[17265, 635, 340, 7, 62, "Notes",
      CellTags->"Compile::cpint"],
    Cell[17630, 646, 64, 1, 38, "ExampleSection",
      CellTags->"Compile::cpint"],
    Cell[17697, 649, 178, 5, 24, "Text",
      CellTags->"Compile::cpint"],
    Cell[17900, 658, 137, 3, 26, "Input",
      CellTags->"Compile::cpint"],
    Cell[18040, 663, 368, 7, 69, "Message",
      CellTags->"Compile::cpint"],
    Cell[18411, 672, 218, 6, 37, "Output",
      CellTags->"Compile::cpint"]},
  "Compile::cpintlt"->{
    Cell[18690, 685, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpintlt"],
    Cell[18778, 688, 533, 14, 53, "Message",
      CellTags->"Compile::cpintlt"],
    Cell[19314, 704, 373, 8, 62, "Notes",
      CellTags->"Compile::cpintlt"],
    Cell[19712, 716, 66, 1, 38, "ExampleSection",
      CellTags->"Compile::cpintlt"],
    Cell[19781, 719, 148, 4, 24, "Text",
      CellTags->"Compile::cpintlt"],
    Cell[19954, 727, 127, 3, 26, "Input",
      CellTags->"Compile::cpintlt"],
    Cell[20084, 732, 367, 7, 69, "Message",
      CellTags->"Compile::cpintlt"],
    Cell[20454, 741, 243, 6, 21, "Output",
      CellTags->"Compile::cpintlt"],
    Cell[20712, 750, 245, 6, 40, "Text",
      CellTags->"Compile::cpintlt"],
    Cell[20982, 760, 144, 3, 26, "Input",
      CellTags->"Compile::cpintlt"],
    Cell[21129, 765, 243, 6, 21, "Output",
      CellTags->"Compile::cpintlt"]},
  "Compile::cpintlt2"->{
    Cell[21433, 778, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpintlt2"],
    Cell[21523, 781, 539, 14, 69, "Message",
      CellTags->"Compile::cpintlt2"],
    Cell[22065, 797, 376, 8, 62, "Notes",
      CellTags->"Compile::cpintlt2"],
    Cell[22466, 809, 67, 1, 38, "ExampleSection",
      CellTags->"Compile::cpintlt2"],
    Cell[22536, 812, 149, 4, 24, "Text",
      CellTags->"Compile::cpintlt2"],
    Cell[22710, 820, 130, 3, 26, "Input",
      CellTags->"Compile::cpintlt2"],
    Cell[22843, 825, 345, 6, 69, "Message",
      CellTags->"Compile::cpintlt2"],
    Cell[23191, 833, 211, 6, 21, "Output",
      CellTags->"Compile::cpintlt2"],
    Cell[23417, 842, 246, 6, 40, "Text",
      CellTags->"Compile::cpintlt2"],
    Cell[23688, 852, 147, 3, 26, "Input",
      CellTags->"Compile::cpintlt2"],
    Cell[23838, 857, 211, 6, 21, "Output",
      CellTags->"Compile::cpintlt2"]},
  "Compile::cpiter"->{
    Cell[24110, 870, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpiter"],
    Cell[24196, 873, 415, 11, 37, "Message",
      CellTags->"Compile::cpiter"],
    Cell[24614, 886, 398, 10, 62, "Notes",
      CellTags->"Compile::cpiter"],
    Cell[25037, 900, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::cpiter"],
    Cell[25105, 903, 147, 4, 24, "Text",
      CellTags->"Compile::cpiter"],
    Cell[25277, 911, 112, 3, 26, "Input",
      CellTags->"Compile::cpiter"],
    Cell[25392, 916, 262, 5, 53, "Message",
      CellTags->"Compile::cpiter"],
    Cell[25657, 923, 184, 5, 21, "Output",
      CellTags->"Compile::cpiter"],
    Cell[25856, 931, 90, 1, 24, "Text",
      CellTags->"Compile::cpiter"],
    Cell[25971, 936, 114, 3, 26, "Input",
      CellTags->"Compile::cpiter"],
    Cell[26088, 941, 186, 5, 21, "Output",
      CellTags->"Compile::cpiter"]},
  "Compile::cplist"->{
    Cell[26335, 953, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cplist"],
    Cell[26421, 956, 309, 7, 37, "Message",
      CellTags->"Compile::cplist"],
    Cell[26733, 965, 336, 7, 62, "Notes",
      CellTags->"Compile::cplist"],
    Cell[27094, 976, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::cplist"],
    Cell[27162, 979, 189, 6, 24, "Text",
      CellTags->"Compile::cplist"],
    Cell[27376, 989, 135, 3, 26, "Input",
      CellTags->"Compile::cplist"],
    Cell[27514, 994, 293, 6, 53, "Message",
      CellTags->"Compile::cplist"],
    Cell[27810, 1002, 246, 7, 21, "Output",
      CellTags->"Compile::cplist"],
    Cell[28071, 1012, 182, 5, 24, "Text",
      CellTags->"Compile::cplist"],
    Cell[28278, 1021, 126, 3, 26, "Input",
      CellTags->"Compile::cplist"],
    Cell[28407, 1026, 186, 5, 21, "Output",
      CellTags->"Compile::cplist"]},
  "Compile::cpout"->{
    Cell[28654, 1038, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpout"],
    Cell[28738, 1041, 245, 5, 53, "Message",
      CellTags->"Compile::cpout"],
    Cell[28986, 1048, 264, 6, 40, "Notes",
      CellTags->"Compile::cpout"],
    Cell[29275, 1058, 64, 1, 38, "ExampleSection",
      CellTags->"Compile::cpout"],
    Cell[29342, 1061, 300, 9, 40, "Text",
      CellTags->"Compile::cpout"],
    Cell[29667, 1074, 126, 3, 26, "Input",
      CellTags->"Compile::cpout"],
    Cell[29796, 1079, 242, 5, 53, "Message",
      CellTags->"Compile::cpout"],
    Cell[30041, 1086, 207, 6, 21, "Output",
      CellTags->"Compile::cpout"],
    Cell[30263, 1095, 102, 1, 24, "Text",
      CellTags->"Compile::cpout"],
    Cell[30390, 1100, 128, 3, 26, "Input",
      CellTags->"Compile::cpout"],
    Cell[30521, 1105, 209, 6, 21, "Output",
      CellTags->"Compile::cpout"]},
  "Compile::cppat"->{
    Cell[30791, 1118, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cppat"],
    Cell[30875, 1121, 353, 7, 37, "Message",
      CellTags->"Compile::cppat"],
    Cell[31231, 1130, 525, 18, 78, "Notes",
      CellTags->"Compile::cppat"],
    Cell[31781, 1152, 64, 1, 38, "ExampleSection",
      CellTags->"Compile::cppat"],
    Cell[31848, 1155, 258, 7, 40, "Text",
      CellTags->"Compile::cppat"],
    Cell[32131, 1166, 137, 3, 26, "Input",
      CellTags->"Compile::cppat"],
    Cell[32271, 1171, 309, 6, 53, "Message",
      CellTags->"Compile::cppat"],
    Cell[32583, 1179, 218, 6, 37, "Output",
      CellTags->"Compile::cppat"]},
  "Compile::cprank"->{
    Cell[32862, 1192, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cprank"],
    Cell[32948, 1195, 541, 12, 53, "Message",
      CellTags->"Compile::cprank"],
    Cell[33492, 1209, 448, 12, 68, "Notes",
      CellTags->"Compile::cprank"],
    Cell[33965, 1225, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::cprank"],
    Cell[34033, 1228, 196, 6, 40, "Text",
      CellTags->"Compile::cprank"],
    Cell[34254, 1238, 163, 4, 42, "Input",
      CellTags->"Compile::cprank"],
    Cell[34420, 1244, 396, 7, 69, "Message",
      CellTags->"Compile::cprank"],
    Cell[34819, 1253, 220, 6, 37, "Output",
      CellTags->"Compile::cprank"],
    Cell[35054, 1262, 211, 5, 40, "Text",
      CellTags->"Compile::cprank"],
    Cell[35290, 1271, 139, 3, 26, "Input",
      CellTags->"Compile::cprank"],
    Cell[35432, 1276, 220, 6, 37, "Output",
      CellTags->"Compile::cprank"]},
  "Compile::cpts"->{
    Cell[35713, 1289, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpts"],
    Cell[35795, 1292, 405, 8, 53, "Message",
      CellTags->"Compile::cpts"],
    Cell[36203, 1302, 278, 7, 46, "Notes",
      CellTags->"Compile::cpts"],
    Cell[36506, 1313, 63, 1, 38, "ExampleSection",
      CellTags->"Compile::cpts"],
    Cell[36572, 1316, 127, 4, 24, "Text",
      CellTags->"Compile::cpts"],
    Cell[36724, 1324, 124, 3, 26, "Input",
      CellTags->"Compile::cpts"],
    Cell[36851, 1329, 344, 7, 69, "Message",
      CellTags->"Compile::cpts"],
    Cell[37198, 1338, 205, 6, 21, "Output",
      CellTags->"Compile::cpts"],
    Cell[37418, 1347, 105, 1, 24, "Text",
      CellTags->"Compile::cpts"],
    Cell[37548, 1352, 111, 3, 26, "Input",
      CellTags->"Compile::cpts"],
    Cell[37662, 1357, 101, 3, 21, "Output",
      CellTags->"Compile::cpts"]},
  "Compile::cptype"->{
    Cell[37824, 1367, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cptype"],
    Cell[37910, 1370, 413, 11, 37, "Message",
      CellTags->"Compile::cptype"],
    Cell[38326, 1383, 432, 10, 78, "Notes",
      CellTags->"Compile::cptype"],
    Cell[38783, 1397, 65, 1, 38, "ExampleSection",
      CellTags->"Compile::cptype"],
    Cell[38851, 1400, 190, 5, 40, "Text",
      CellTags->"Compile::cptype"],
    Cell[39066, 1409, 122, 3, 26, "Input",
      CellTags->"Compile::cptype"],
    Cell[39191, 1414, 234, 5, 37, "Message",
      CellTags->"Compile::cptype"],
    Cell[39428, 1421, 182, 5, 21, "Output",
      CellTags->"Compile::cptype"],
    Cell[39625, 1429, 161, 5, 24, "Text",
      CellTags->"Compile::cptype"],
    Cell[39811, 1438, 123, 3, 26, "Input",
      CellTags->"Compile::cptype"],
    Cell[39937, 1443, 236, 5, 37, "Message",
      CellTags->"Compile::cptype"],
    Cell[40176, 1450, 179, 5, 21, "Output",
      CellTags->"Compile::cptype"]},
  "Compile::cpw"->{
    Cell[40416, 1462, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cpw"],
    Cell[40496, 1465, 360, 10, 21, "Message",
      CellTags->"Compile::cpw"],
    Cell[40859, 1477, 344, 11, 46, "Notes",
      CellTags->"Compile::cpw"],
    Cell[41228, 1492, 62, 1, 38, "ExampleSection",
      CellTags->"Compile::cpw"],
    Cell[41293, 1495, 231, 7, 40, "Text",
      CellTags->"Compile::cpw"],
    Cell[41549, 1506, 123, 3, 26, "Input",
      CellTags->"Compile::cpw"],
    Cell[41675, 1511, 182, 4, 21, "Message",
      CellTags->"Compile::cpw"],
    Cell[41860, 1517, 171, 5, 21, "Output",
      CellTags->"Compile::cpw"]},
  "Compile::cret"->{
    Cell[42092, 1529, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cret"],
    Cell[42174, 1532, 229, 5, 37, "Message",
      CellTags->"Compile::cret"],
    Cell[42406, 1539, 182, 4, 40, "Notes",
      CellTags->"Compile::cret"],
    Cell[42613, 1547, 63, 1, 38, "ExampleSection",
      CellTags->"Compile::cret"],
    Cell[42679, 1550, 197, 5, 40, "Text",
      CellTags->"Compile::cret"],
    Cell[42901, 1559, 125, 3, 26, "Input",
      CellTags->"Compile::cret"],
    Cell[43029, 1564, 299, 6, 53, "Message",
      CellTags->"Compile::cret"],
    Cell[43331, 1572, 206, 6, 21, "Output",
      CellTags->"Compile::cret"],
    Cell[43552, 1581, 149, 4, 24, "Text",
      CellTags->"Compile::cret"],
    Cell[43726, 1589, 127, 3, 26, "Input",
      CellTags->"Compile::cret"],
    Cell[43856, 1594, 208, 6, 21, "Output",
      CellTags->"Compile::cret"]},
  "Compile::cret1"->{
    Cell[44125, 1607, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cret1"],
    Cell[44209, 1610, 425, 10, 37, "Message",
      CellTags->"Compile::cret1"],
    Cell[44637, 1622, 559, 19, 78, "Notes",
      CellTags->"Compile::cret1"],
    Cell[45221, 1645, 64, 1, 38, "ExampleSection",
      CellTags->"Compile::cret1"],
    Cell[45288, 1648, 234, 6, 40, "Text",
      CellTags->"Compile::cret1"],
    Cell[45547, 1658, 136, 3, 26, "Input",
      CellTags->"Compile::cret1"],
    Cell[45686, 1663, 238, 5, 37, "Message",
      CellTags->"Compile::cret1"],
    Cell[45927, 1670, 217, 6, 37, "Output",
      CellTags->"Compile::cret1"],
    Cell[46159, 1679, 137, 4, 24, "Text",
      CellTags->"Compile::cret1"],
    Cell[46321, 1687, 139, 3, 26, "Input",
      CellTags->"Compile::cret1"],
    Cell[46463, 1692, 220, 6, 37, "Output",
      CellTags->"Compile::cret1"]},
  "Compile::cset"->{
    Cell[46744, 1705, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cset"],
    Cell[46826, 1708, 428, 12, 37, "Message",
      CellTags->"Compile::cset"],
    Cell[47257, 1722, 295, 6, 62, "Notes",
      CellTags->"Compile::cset"],
    Cell[47577, 1732, 63, 1, 38, "ExampleSection",
      CellTags->"Compile::cset"],
    Cell[47643, 1735, 188, 5, 40, "Text",
      CellTags->"Compile::cset"],
    Cell[47856, 1744, 137, 3, 26, "Input",
      CellTags->"Compile::cset"],
    Cell[47996, 1749, 233, 5, 37, "Message",
      CellTags->"Compile::cset"],
    Cell[48232, 1756, 206, 6, 21, "Output",
      CellTags->"Compile::cset"],
    Cell[48453, 1765, 161, 4, 40, "Text",
      CellTags->"Compile::cset"],
    Cell[48639, 1773, 155, 4, 26, "Input",
      CellTags->"Compile::cset"],
    Cell[48797, 1779, 278, 8, 37, "Output",
      CellTags->"Compile::cset"]},
  "Compile::ctyp1"->{
    Cell[49136, 1794, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::ctyp1"],
    Cell[49220, 1797, 231, 5, 53, "Message",
      CellTags->"Compile::ctyp1"],
    Cell[49454, 1804, 1743, 53, 214, "Notes",
      CellTags->"Compile::ctyp1"],
    Cell[51222, 1861, 64, 1, 38, "ExampleSection",
      CellTags->"Compile::ctyp1"],
    Cell[51289, 1864, 195, 6, 40, "Text",
      CellTags->"Compile::ctyp1"],
    Cell[51509, 1874, 120, 3, 26, "Input",
      CellTags->"Compile::ctyp1"],
    Cell[51632, 1879, 250, 5, 53, "Message",
      CellTags->"Compile::ctyp1"],
    Cell[51885, 1886, 121, 3, 21, "Output",
      CellTags->"Compile::ctyp1"],
    Cell[52021, 1892, 181, 4, 40, "Text",
      CellTags->"Compile::ctyp1"],
    Cell[52227, 1900, 122, 3, 26, "Input",
      CellTags->"Compile::ctyp1"],
    Cell[52352, 1905, 182, 5, 21, "Output",
      CellTags->"Compile::ctyp1"]},
  "Compile::ctyp2"->{
    Cell[52595, 1917, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::ctyp2"],
    Cell[52679, 1920, 254, 6, 21, "Message",
      CellTags->"Compile::ctyp2"],
    Cell[52936, 1928, 1370, 47, 122, "Notes",
      CellTags->"Compile::ctyp2"],
    Cell[54331, 1979, 64, 1, 38, "ExampleSection",
      CellTags->"Compile::ctyp2"],
    Cell[54398, 1982, 170, 4, 40, "Text",
      CellTags->"Compile::ctyp2"],
    Cell[54593, 1990, 115, 3, 26, "Input",
      CellTags->"Compile::ctyp2"],
    Cell[54711, 1995, 187, 4, 21, "Message",
      CellTags->"Compile::ctyp2"],
    Cell[54901, 2001, 116, 3, 21, "Output",
      CellTags->"Compile::ctyp2"],
    Cell[55032, 2007, 154, 4, 24, "Text",
      CellTags->"Compile::ctyp2"],
    Cell[55211, 2015, 122, 3, 26, "Input",
      CellTags->"Compile::ctyp2"],
    Cell[55336, 2020, 182, 5, 21, "Output",
      CellTags->"Compile::ctyp2"]},
  "Compile::ctyps"->{
    Cell[55579, 2032, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::ctyps"],
    Cell[55663, 2035, 237, 5, 21, "Message",
      CellTags->"Compile::ctyps"],
    Cell[55903, 2042, 1393, 47, 138, "Notes",
      CellTags->"Compile::ctyps"],
    Cell[57321, 2093, 64, 1, 38, "ExampleSection",
      CellTags->"Compile::ctyps"],
    Cell[57388, 2096, 160, 4, 40, "Text",
      CellTags->"Compile::ctyps"],
    Cell[57573, 2104, 129, 3, 26, "Input",
      CellTags->"Compile::ctyps"],
    Cell[57705, 2109, 185, 4, 21, "Message",
      CellTags->"Compile::ctyps"],
    Cell[57893, 2115, 189, 4, 21, "Message",
      CellTags->"Compile::ctyps"],
    Cell[58085, 2121, 177, 5, 21, "Output",
      CellTags->"Compile::ctyps"],
    Cell[58277, 2129, 105, 1, 24, "Text",
      CellTags->"Compile::ctyps"],
    Cell[58407, 2134, 131, 3, 26, "Input",
      CellTags->"Compile::ctyps"],
    Cell[58541, 2139, 177, 5, 21, "Output",
      CellTags->"Compile::ctyps"]},
  "Compile::cxcoerce"->{
    Cell[58779, 2151, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::cxcoerce"],
    Cell[58869, 2154, 234, 5, 53, "Message",
      CellTags->"Compile::cxcoerce"],
    Cell[59106, 2161, 298, 7, 46, "Notes",
      CellTags->"Compile::cxcoerce"],
    Cell[59429, 2172, 67, 1, 38, "ExampleSection",
      CellTags->"Compile::cxcoerce"],
    Cell[59499, 2175, 138, 4, 24, "Text",
      CellTags->"Compile::cxcoerce"],
    Cell[59640, 2181, 196, 4, 42, "Input",
      CellTags->"Compile::cxcoerce"],
    Cell[59861, 2189, 108, 3, 26, "Input",
      CellTags->"Compile::cxcoerce"],
    Cell[59972, 2194, 252, 5, 53, "Message",
      CellTags->"Compile::cxcoerce"],
    Cell[60227, 2201, 253, 5, 53, "Message",
      CellTags->"Compile::cxcoerce"],
    Cell[60483, 2208, 192, 5, 21, "Output",
      CellTags->"Compile::cxcoerce"],
    Cell[60690, 2216, 66, 1, 24, "Text",
      CellTags->"Compile::cxcoerce"],
    Cell[60759, 2219, 197, 4, 42, "Input",
      CellTags->"Compile::cxcoerce"]},
  "Compile::defn"->{
    Cell[61005, 2229, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::defn"],
    Cell[61087, 2232, 196, 5, 37, "Message",
      CellTags->"Compile::defn"],
    Cell[61286, 2239, 124, 4, 24, "Notes",
      CellTags->"Compile::defn"]},
  "Compile::part"->{
    Cell[61447, 2248, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::part"],
    Cell[61529, 2251, 280, 6, 69, "Message",
      CellTags->"Compile::part"],
    Cell[61812, 2259, 124, 4, 24, "Notes",
      CellTags->"Compile::part"]},
  "Compile::symdef"->{
    Cell[61973, 2268, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::symdef"],
    Cell[62059, 2271, 222, 5, 37, "Message",
      CellTags->"Compile::symdef"],
    Cell[62284, 2278, 126, 4, 24, "Notes",
      CellTags->"Compile::symdef"]},
  "Compile::nocomp"->{
    Cell[62447, 2287, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::nocomp"],
    Cell[62533, 2290, 252, 5, 53, "Message",
      CellTags->"Compile::nocomp"],
    Cell[62788, 2297, 126, 4, 24, "Notes",
      CellTags->"Compile::nocomp"]},
  "Compile::extscalar"->{
    Cell[62951, 2306, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::extscalar"],
    Cell[63043, 2309, 244, 5, 53, "Message",
      CellTags->"Compile::extscalar"],
    Cell[63290, 2316, 308, 6, 62, "Notes",
      CellTags->"Compile::extscalar"],
    Cell[63623, 2326, 68, 1, 38, "ExampleSection",
      CellTags->"Compile::extscalar"],
    Cell[63694, 2329, 143, 4, 24, "Text",
      CellTags->"Compile::extscalar"],
    Cell[63840, 2335, 197, 4, 42, "Input",
      CellTags->"Compile::extscalar"],
    Cell[64062, 2343, 113, 3, 26, "Input",
      CellTags->"Compile::extscalar"],
    Cell[64178, 2348, 257, 5, 53, "Message",
      CellTags->"Compile::extscalar"],
    Cell[64438, 2355, 185, 5, 21, "Output",
      CellTags->"Compile::extscalar"],
    Cell[64638, 2363, 67, 1, 24, "Text",
      CellTags->"Compile::extscalar"],
    Cell[64708, 2366, 198, 4, 42, "Input",
      CellTags->"Compile::extscalar"]},
  "Compile::exttensor"->{
    Cell[64955, 2376, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::exttensor"],
    Cell[65047, 2379, 262, 5, 53, "Message",
      CellTags->"Compile::exttensor"],
    Cell[65312, 2386, 307, 6, 62, "Notes",
      CellTags->"Compile::exttensor"],
    Cell[65644, 2396, 68, 1, 38, "ExampleSection",
      CellTags->"Compile::exttensor"],
    Cell[65715, 2399, 143, 4, 24, "Text",
      CellTags->"Compile::exttensor"],
    Cell[65861, 2405, 197, 4, 42, "Input",
      CellTags->"Compile::exttensor"],
    Cell[66083, 2413, 125, 3, 26, "Input",
      CellTags->"Compile::exttensor"],
    Cell[66211, 2418, 281, 6, 53, "Message",
      CellTags->"Compile::exttensor"],
    Cell[66495, 2426, 185, 5, 21, "Output",
      CellTags->"Compile::exttensor"],
    Cell[66695, 2434, 67, 1, 24, "Text",
      CellTags->"Compile::exttensor"],
    Cell[66765, 2437, 198, 4, 42, "Input",
      CellTags->"Compile::exttensor"]},
  "Compile::initvar"->{
    Cell[67012, 2447, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::initvar"],
    Cell[67100, 2450, 217, 5, 37, "Message",
      CellTags->"Compile::initvar"],
    Cell[67320, 2457, 158, 4, 24, "Notes",
      CellTags->"Compile::initvar"],
    Cell[67503, 2465, 66, 1, 38, "ExampleSection",
      CellTags->"Compile::initvar"],
    Cell[67572, 2468, 184, 5, 24, "Text",
      CellTags->"Compile::initvar"],
    Cell[67781, 2477, 119, 3, 26, "Input",
      CellTags->"Compile::initvar"],
    Cell[67903, 2482, 220, 5, 37, "Message",
      CellTags->"Compile::initvar"],
    Cell[68126, 2489, 235, 5, 37, "Message",
      CellTags->"Compile::initvar"],
    Cell[68364, 2496, 191, 5, 21, "Output",
      CellTags->"Compile::initvar"],
    Cell[68570, 2504, 98, 1, 24, "Text",
      CellTags->"Compile::initvar"],
    Cell[68693, 2509, 123, 3, 26, "Input",
      CellTags->"Compile::initvar"],
    Cell[68819, 2514, 195, 5, 21, "Output",
      CellTags->"Compile::initvar"]},
  "Compile::maxrank"->{
    Cell[69075, 2526, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::maxrank"],
    Cell[69163, 2529, 454, 13, 37, "Message",
      CellTags->"Compile::maxrank"],
    Cell[69620, 2544, 127, 4, 24, "Notes",
      CellTags->"Compile::maxrank"]},
  "Compile::realcoerce"->{
    Cell[69784, 2553, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::realcoerce"],
    Cell[69878, 2556, 235, 5, 53, "Message",
      CellTags->"Compile::realcoerce"],
    Cell[70116, 2563, 297, 7, 46, "Notes",
      CellTags->"Compile::realcoerce"],
    Cell[70438, 2574, 69, 1, 38, "ExampleSection",
      CellTags->"Compile::realcoerce"],
    Cell[70510, 2577, 156, 4, 24, "Text",
      CellTags->"Compile::realcoerce"],
    Cell[70669, 2583, 198, 4, 42, "Input",
      CellTags->"Compile::realcoerce"],
    Cell[70892, 2591, 111, 3, 26, "Input",
      CellTags->"Compile::realcoerce"],
    Cell[71006, 2596, 246, 5, 53, "Message",
      CellTags->"Compile::realcoerce"],
    Cell[71255, 2603, 186, 5, 21, "Output",
      CellTags->"Compile::realcoerce"],
    Cell[71456, 2611, 68, 1, 24, "Text",
      CellTags->"Compile::realcoerce"],
    Cell[71527, 2614, 199, 4, 42, "Input",
      CellTags->"Compile::realcoerce"]},
  "Compile::type"->{
    Cell[71775, 2624, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Compile::type"],
    Cell[71857, 2627, 251, 5, 53, "Message",
      CellTags->"Compile::type"],
    Cell[72111, 2634, 177, 4, 24, "Notes",
      CellTags->"Compile::type"]},
  "CompiledFunction::ccf"->{
    Cell[72325, 2643, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::ccf"],
    Cell[72423, 2646, 277, 6, 37, "Message",
      CellTags->"CompiledFunction::ccf"],
    Cell[72703, 2654, 385, 8, 78, "Notes",
      CellTags->"CompiledFunction::ccf"],
    Cell[73113, 2666, 71, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::ccf"],
    Cell[73187, 2669, 207, 5, 40, "Text",
      CellTags->"CompiledFunction::ccf"],
    Cell[73419, 2678, 152, 3, 26, "Input",
      CellTags->"CompiledFunction::ccf"],
    Cell[73574, 2683, 222, 5, 37, "Message",
      CellTags->"CompiledFunction::ccf"],
    Cell[73799, 2690, 241, 5, 53, "Message",
      CellTags->"CompiledFunction::ccf"],
    Cell[74043, 2697, 104, 3, 21, "Print",
      CellTags->"CompiledFunction::ccf"]},
  "CompiledFunction::cfcode"->{
    Cell[74208, 2707, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfcode"],
    Cell[74312, 2710, 492, 13, 37, "Message",
      CellTags->"CompiledFunction::cfcode"],
    Cell[74807, 2725, 557, 14, 84, "Notes",
      CellTags->"CompiledFunction::cfcode"]},
  "CompiledFunction::cfct"->{
    Cell[75401, 2744, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfct"],
    Cell[75501, 2747, 454, 11, 37, "Message",
      CellTags->"CompiledFunction::cfct"],
    Cell[75958, 2760, 247, 5, 40, "Notes",
      CellTags->"CompiledFunction::cfct"],
    Cell[76230, 2769, 72, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfct"],
    Cell[76305, 2772, 243, 7, 40, "Text",
      CellTags->"CompiledFunction::cfct"],
    Cell[76573, 2783, 122, 3, 26, "Input",
      CellTags->"CompiledFunction::cfct"],
    Cell[76698, 2788, 189, 5, 21, "Output",
      CellTags->"CompiledFunction::cfct"],
    Cell[76924, 2798, 100, 3, 26, "Input",
      CellTags->"CompiledFunction::cfct"],
    Cell[77027, 2803, 241, 5, 53, "Message",
      CellTags->"CompiledFunction::cfct"],
    Cell[77271, 2810, 225, 6, 21, "Output",
      CellTags->"CompiledFunction::cfct"],
    Cell[77511, 2819, 152, 4, 24, "Text",
      CellTags->"CompiledFunction::cfct"],
    Cell[77688, 2827, 103, 3, 26, "Input",
      CellTags->"CompiledFunction::cfct"],
    Cell[77794, 2832, 99, 3, 21, "Output",
      CellTags->"CompiledFunction::cfct"],
    Cell[77908, 2838, 120, 5, 24, "Text",
      CellTags->"CompiledFunction::cfct"],
    Cell[78031, 2845, 104, 3, 26, "Input",
      CellTags->"CompiledFunction::cfct"]},
  "CompiledFunction::cfex"->{
    Cell[78184, 2854, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfex"],
    Cell[78284, 2857, 401, 10, 37, "Message",
      CellTags->"CompiledFunction::cfex"],
    Cell[78688, 2869, 870, 14, 160, "Notes",
      CellTags->"CompiledFunction::cfex"],
    Cell[79583, 2887, 72, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfex"],
    Cell[79658, 2890, 234, 5, 40, "Text",
      CellTags->"CompiledFunction::cfex"],
    Cell[79917, 2899, 118, 3, 26, "Input",
      CellTags->"CompiledFunction::cfex"],
    Cell[80038, 2904, 185, 5, 21, "Output",
      CellTags->"CompiledFunction::cfex"],
    Cell[80260, 2914, 99, 3, 26, "Input",
      CellTags->"CompiledFunction::cfex"],
    Cell[80362, 2919, 229, 5, 37, "Message",
      CellTags->"CompiledFunction::cfex"],
    Cell[80594, 2926, 242, 5, 53, "Message",
      CellTags->"CompiledFunction::cfex"],
    Cell[80839, 2933, 101, 3, 21, "Output",
      CellTags->"CompiledFunction::cfex"],
    Cell[80955, 2939, 166, 4, 24, "Text",
      CellTags->"CompiledFunction::cfex"],
    Cell[81146, 2947, 117, 3, 26, "Input",
      CellTags->"CompiledFunction::cfex"],
    Cell[81266, 2952, 100, 3, 21, "Output",
      CellTags->"CompiledFunction::cfex"],
    Cell[81381, 2958, 380, 7, 56, "Text",
      CellTags->"CompiledFunction::cfex"],
    Cell[81786, 2969, 109, 3, 26, "Input",
      CellTags->"CompiledFunction::cfex"],
    Cell[81898, 2974, 126, 3, 21, "Output",
      CellTags->"CompiledFunction::cfex"],
    Cell[82039, 2980, 120, 5, 24, "Text",
      CellTags->"CompiledFunction::cfex"],
    Cell[82162, 2987, 104, 3, 26, "Input",
      CellTags->"CompiledFunction::cfex"]},
  "CompiledFunction::cfff"->{
    Cell[82315, 2996, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfff"],
    Cell[82415, 2999, 366, 9, 37, "Message",
      CellTags->"CompiledFunction::cfff"],
    Cell[82784, 3010, 713, 18, 106, "Notes",
      CellTags->"CompiledFunction::cfff"]},
  "CompiledFunction::cffv"->{
    Cell[83534, 3033, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cffv"],
    Cell[83634, 3036, 283, 6, 37, "Message",
      CellTags->"CompiledFunction::cffv"],
    Cell[83920, 3044, 841, 20, 138, "Notes",
      CellTags->"CompiledFunction::cffv"]},
  "CompiledFunction::cfins"->{
    Cell[84798, 3069, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfins"],
    Cell[84900, 3072, 380, 8, 37, "Message",
      CellTags->"CompiledFunction::cfins"],
    Cell[85283, 3082, 849, 19, 144, "Notes",
      CellTags->"CompiledFunction::cfins"]},
  "CompiledFunction::cflist"->{
    Cell[86169, 3106, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cflist"],
    Cell[86273, 3109, 226, 4, 37, "Message",
      CellTags->"CompiledFunction::cflist"],
    Cell[86502, 3115, 589, 11, 116, "Notes",
      CellTags->"CompiledFunction::cflist"],
    Cell[87116, 3130, 74, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cflist"],
    Cell[87193, 3133, 148, 4, 24, "Text",
      CellTags->"CompiledFunction::cflist"],
    Cell[87366, 3141, 134, 3, 26, "Input",
      CellTags->"CompiledFunction::cflist"],
    Cell[87503, 3146, 225, 5, 37, "Message",
      CellTags->"CompiledFunction::cflist"],
    Cell[87731, 3153, 236, 5, 37, "Message",
      CellTags->"CompiledFunction::cflist"],
    Cell[87970, 3160, 116, 3, 21, "Output",
      CellTags->"CompiledFunction::cflist"]},
  "CompiledFunction::cfn"->{
    Cell[88147, 3170, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfn"],
    Cell[88245, 3173, 401, 10, 37, "Message",
      CellTags->"CompiledFunction::cfn"],
    Cell[88649, 3185, 335, 7, 62, "Notes",
      CellTags->"CompiledFunction::cfn"],
    Cell[89009, 3196, 71, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfn"],
    Cell[89083, 3199, 166, 4, 40, "Text",
      CellTags->"CompiledFunction::cfn"],
    Cell[89274, 3207, 122, 3, 26, "Input",
      CellTags->"CompiledFunction::cfn"],
    Cell[89399, 3212, 243, 5, 53, "Message",
      CellTags->"CompiledFunction::cfn"],
    Cell[89645, 3219, 151, 3, 23, "Output",
      CellTags->"CompiledFunction::cfn"],
    Cell[89811, 3225, 227, 5, 40, "Text",
      CellTags->"CompiledFunction::cfn"],
    Cell[90063, 3234, 144, 3, 26, "Input",
      CellTags->"CompiledFunction::cfn"],
    Cell[90210, 3239, 242, 5, 53, "Message",
      CellTags->"CompiledFunction::cfn"],
    Cell[90455, 3246, 131, 3, 21, "Output",
      CellTags->"CompiledFunction::cfn"]},
  "CompiledFunction::cfnlts"->{
    Cell[90647, 3256, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfnlts"],
    Cell[90751, 3259, 353, 7, 53, "Message",
      CellTags->"CompiledFunction::cfnlts"],
    Cell[91107, 3268, 171, 4, 24, "Notes",
      CellTags->"CompiledFunction::cfnlts"],
    Cell[91303, 3276, 74, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfnlts"],
    Cell[91380, 3279, 186, 4, 40, "Text",
      CellTags->"CompiledFunction::cfnlts"],
    Cell[91591, 3287, 133, 3, 26, "Input",
      CellTags->"CompiledFunction::cfnlts"],
    Cell[91727, 3292, 258, 5, 53, "Message",
      CellTags->"CompiledFunction::cfnlts"],
    Cell[91988, 3299, 100, 3, 21, "Output",
      CellTags->"CompiledFunction::cfnlts"]},
  "CompiledFunction::cfnv"->{
    Cell[92149, 3309, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfnv"],
    Cell[92249, 3312, 193, 3, 37, "Message",
      CellTags->"CompiledFunction::cfnv"],
    Cell[92445, 3317, 725, 17, 122, "Notes",
      CellTags->"CompiledFunction::cfnv"],
    Cell[93195, 3338, 72, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfnv"],
    Cell[93270, 3341, 205, 5, 40, "Text",
      CellTags->"CompiledFunction::cfnv"],
    Cell[93500, 3350, 119, 3, 26, "Input",
      CellTags->"CompiledFunction::cfnv"],
    Cell[93622, 3355, 240, 5, 37, "Message",
      CellTags->"CompiledFunction::cfnv"],
    Cell[93865, 3362, 240, 5, 37, "Message",
      CellTags->"CompiledFunction::cfnv"],
    Cell[94108, 3369, 206, 4, 37, "Message",
      CellTags->"CompiledFunction::cfnv"],
    Cell[94317, 3375, 189, 6, 21, "Output",
      CellTags->"CompiledFunction::cfnv"]},
  "CompiledFunction::cfsa"->{
    Cell[94567, 3388, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfsa"],
    Cell[94667, 3391, 198, 4, 37, "Message",
      CellTags->"CompiledFunction::cfsa"],
    Cell[94868, 3397, 230, 5, 40, "Notes",
      CellTags->"CompiledFunction::cfsa"],
    Cell[95123, 3406, 72, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfsa"],
    Cell[95198, 3409, 242, 5, 40, "Text",
      CellTags->"CompiledFunction::cfsa"],
    Cell[95465, 3418, 131, 3, 26, "Input",
      CellTags->"CompiledFunction::cfsa"],
    Cell[95599, 3423, 186, 5, 21, "Output",
      CellTags->"CompiledFunction::cfsa"],
    Cell[95822, 3433, 102, 3, 26, "Input",
      CellTags->"CompiledFunction::cfsa"],
    Cell[95927, 3438, 237, 5, 37, "Message",
      CellTags->"CompiledFunction::cfsa"],
    Cell[96167, 3445, 100, 3, 21, "Output",
      CellTags->"CompiledFunction::cfsa"],
    Cell[96282, 3451, 145, 4, 24, "Text",
      CellTags->"CompiledFunction::cfsa"],
    Cell[96452, 3459, 100, 3, 26, "Input",
      CellTags->"CompiledFunction::cfsa"],
    Cell[96555, 3464, 97, 3, 21, "Output",
      CellTags->"CompiledFunction::cfsa"],
    Cell[96667, 3470, 120, 5, 24, "Text",
      CellTags->"CompiledFunction::cfsa"],
    Cell[96790, 3477, 104, 3, 26, "Input",
      CellTags->"CompiledFunction::cfsa"]},
  "CompiledFunction::cfse"->{
    Cell[96943, 3486, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfse"],
    Cell[97043, 3489, 193, 4, 21, "Message",
      CellTags->"CompiledFunction::cfse"],
    Cell[97239, 3495, 364, 8, 62, "Notes",
      CellTags->"CompiledFunction::cfse"],
    Cell[97628, 3507, 72, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfse"],
    Cell[97703, 3510, 196, 5, 40, "Text",
      CellTags->"CompiledFunction::cfse"],
    Cell[97924, 3519, 118, 3, 26, "Input",
      CellTags->"CompiledFunction::cfse"],
    Cell[98045, 3524, 185, 5, 21, "Output",
      CellTags->"CompiledFunction::cfse"],
    Cell[98267, 3534, 126, 3, 26, "Input",
      CellTags->"CompiledFunction::cfse"],
    Cell[98396, 3539, 290, 6, 37, "Message",
      CellTags->"CompiledFunction::cfse"],
    Cell[98689, 3547, 242, 5, 53, "Message",
      CellTags->"CompiledFunction::cfse"],
    Cell[98934, 3554, 151, 3, 21, "Output",
      CellTags->"CompiledFunction::cfse"],
    Cell[99100, 3560, 191, 5, 24, "Text",
      CellTags->"CompiledFunction::cfse"],
    Cell[99316, 3569, 135, 3, 26, "Input",
      CellTags->"CompiledFunction::cfse"],
    Cell[99454, 3574, 185, 5, 21, "Output",
      CellTags->"CompiledFunction::cfse"],
    Cell[99676, 3584, 126, 3, 26, "Input",
      CellTags->"CompiledFunction::cfse"],
    Cell[99805, 3589, 151, 3, 21, "Output",
      CellTags->"CompiledFunction::cfse"],
    Cell[99971, 3595, 120, 5, 24, "Text",
      CellTags->"CompiledFunction::cfse"],
    Cell[100094, 3602, 104, 3, 26, "Input",
      CellTags->"CompiledFunction::cfse"]},
  "CompiledFunction::cfsec"->{
    Cell[100247, 3611, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfsec"],
    Cell[100349, 3614, 209, 4, 37, "Message",
      CellTags->"CompiledFunction::cfsec"],
    Cell[100561, 3620, 284, 6, 46, "Notes",
      CellTags->"CompiledFunction::cfsec"],
    Cell[100870, 3630, 73, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfsec"],
    Cell[100946, 3633, 158, 4, 24, "Text",
      CellTags->"CompiledFunction::cfsec"],
    Cell[101107, 3639, 202, 4, 42, "Input",
      CellTags->"CompiledFunction::cfsec"],
    Cell[101312, 3645, 110, 3, 26, "Input",
      CellTags->"CompiledFunction::cfsec"],
    Cell[101447, 3652, 126, 3, 26, "Input",
      CellTags->"CompiledFunction::cfsec"],
    Cell[101576, 3657, 245, 5, 37, "Message",
      CellTags->"CompiledFunction::cfsec"],
    Cell[101824, 3664, 100, 3, 21, "Output",
      CellTags->"CompiledFunction::cfsec"],
    Cell[101939, 3670, 124, 5, 24, "Text",
      CellTags->"CompiledFunction::cfsec"],
    Cell[102066, 3677, 108, 3, 26, "Input",
      CellTags->"CompiledFunction::cfsec"],
    Cell[102177, 3682, 72, 1, 24, "Text",
      CellTags->"CompiledFunction::cfsec"],
    Cell[102252, 3685, 203, 4, 42, "Input",
      CellTags->"CompiledFunction::cfsec"]},
  "CompiledFunction::cfta"->{
    Cell[102504, 3695, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfta"],
    Cell[102604, 3698, 220, 5, 37, "Message",
      CellTags->"CompiledFunction::cfta"],
    Cell[102827, 3705, 237, 5, 40, "Notes",
      CellTags->"CompiledFunction::cfta"],
    Cell[103089, 3714, 72, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfta"],
    Cell[103164, 3717, 226, 5, 40, "Text",
      CellTags->"CompiledFunction::cfta"],
    Cell[103415, 3726, 135, 3, 26, "Input",
      CellTags->"CompiledFunction::cfta"],
    Cell[103553, 3731, 190, 5, 21, "Output",
      CellTags->"CompiledFunction::cfta"],
    Cell[103780, 3741, 102, 3, 26, "Input",
      CellTags->"CompiledFunction::cfta"],
    Cell[103885, 3746, 265, 5, 53, "Message",
      CellTags->"CompiledFunction::cfta"],
    Cell[104153, 3753, 97, 3, 21, "Output",
      CellTags->"CompiledFunction::cfta"],
    Cell[104265, 3759, 145, 4, 24, "Text",
      CellTags->"CompiledFunction::cfta"],
    Cell[104435, 3767, 104, 3, 26, "Input",
      CellTags->"CompiledFunction::cfta"],
    Cell[104542, 3772, 97, 3, 21, "Output",
      CellTags->"CompiledFunction::cfta"],
    Cell[104654, 3778, 120, 5, 24, "Text",
      CellTags->"CompiledFunction::cfta"],
    Cell[104777, 3785, 104, 3, 26, "Input",
      CellTags->"CompiledFunction::cfta"]},
  "CompiledFunction::cfte"->{
    Cell[104930, 3794, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfte"],
    Cell[105030, 3797, 215, 5, 37, "Message",
      CellTags->"CompiledFunction::cfte"],
    Cell[105248, 3804, 513, 11, 84, "Notes",
      CellTags->"CompiledFunction::cfte"],
    Cell[105786, 3819, 72, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cfte"],
    Cell[105861, 3822, 210, 5, 40, "Text",
      CellTags->"CompiledFunction::cfte"],
    Cell[106096, 3831, 148, 3, 26, "Input",
      CellTags->"CompiledFunction::cfte"],
    Cell[106247, 3836, 186, 5, 21, "Output",
      CellTags->"CompiledFunction::cfte"],
    Cell[106470, 3846, 108, 3, 26, "Input",
      CellTags->"CompiledFunction::cfte"],
    Cell[106581, 3851, 253, 5, 53, "Message",
      CellTags->"CompiledFunction::cfte"],
    Cell[106837, 3858, 242, 5, 53, "Message",
      CellTags->"CompiledFunction::cfte"],
    Cell[107082, 3865, 109, 3, 21, "Output",
      CellTags->"CompiledFunction::cfte"],
    Cell[107206, 3871, 171, 4, 40, "Text",
      CellTags->"CompiledFunction::cfte"],
    Cell[107402, 3879, 132, 3, 26, "Input",
      CellTags->"CompiledFunction::cfte"],
    Cell[107537, 3884, 100, 3, 21, "Output",
      CellTags->"CompiledFunction::cfte"],
    Cell[107652, 3890, 120, 5, 24, "Text",
      CellTags->"CompiledFunction::cfte"],
    Cell[107775, 3897, 104, 3, 26, "Input",
      CellTags->"CompiledFunction::cfte"]},
  "CompiledFunction::cftec"->{
    Cell[107928, 3906, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cftec"],
    Cell[108030, 3909, 231, 5, 37, "Message",
      CellTags->"CompiledFunction::cftec"],
    Cell[108264, 3916, 284, 6, 46, "Notes",
      CellTags->"CompiledFunction::cftec"],
    Cell[108573, 3926, 73, 1, 38, "ExampleSection",
      CellTags->"CompiledFunction::cftec"],
    Cell[108649, 3929, 158, 4, 24, "Text",
      CellTags->"CompiledFunction::cftec"],
    Cell[108810, 3935, 202, 4, 42, "Input",
      CellTags->"CompiledFunction::cftec"],
    Cell[109015, 3941, 112, 3, 26, "Input",
      CellTags->"CompiledFunction::cftec"],
    Cell[109152, 3948, 141, 3, 26, "Input",
      CellTags->"CompiledFunction::cftec"],
    Cell[109296, 3953, 271, 5, 53, "Message",
      CellTags->"CompiledFunction::cftec"],
    Cell[109570, 3960, 102, 3, 21, "Output",
      CellTags->"CompiledFunction::cftec"],
    Cell[109687, 3966, 124, 5, 24, "Text",
      CellTags->"CompiledFunction::cftec"],
    Cell[109814, 3973, 108, 3, 26, "Input",
      CellTags->"CompiledFunction::cftec"],
    Cell[109925, 3978, 72, 1, 24, "Text",
      CellTags->"CompiledFunction::cftec"],
    Cell[110000, 3981, 203, 4, 42, "Input",
      CellTags->"CompiledFunction::cftec"]},
  "CompiledFunction::cfver"->{
    Cell[110252, 3991, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::cfver"],
    Cell[110354, 3994, 207, 3, 37, "Message",
      CellTags->"CompiledFunction::cfver"],
    Cell[110564, 3999, 789, 19, 116, "Notes",
      CellTags->"CompiledFunction::cfver"]},
  "CompiledFunction::mldot"->{
    Cell[111390, 4023, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::mldot"],
    Cell[111492, 4026, 263, 4, 37, "Message",
      CellTags->"CompiledFunction::mldot"],
    Cell[111758, 4032, 435, 12, 62, "Notes",
      CellTags->"CompiledFunction::mldot"]},
  "CompiledFunction::orank"->{
    Cell[112230, 4049, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CompiledFunction::orank"],
    Cell[112332, 4052, 314, 6, 69, "Message",
      CellTags->"CompiledFunction::orank"],
    Cell[112649, 4060, 134, 4, 24, "Notes",
      CellTags->"CompiledFunction::orank"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Compile::argset", 113478, 4085},
  {"Compile::iterset", 114375, 4108},
  {"Compile::compfail", 114656, 4115},
  {"Compile::ccon", 114936, 4122},
  {"Compile::cif", 116188, 4155},
  {"Compile::cpapot", 116836, 4172},
  {"Compile::cpbool", 117516, 4189},
  {"Compile::cpdsts", 118430, 4212},
  {"Compile::cpint", 119342, 4235},
  {"Compile::cpintlt", 120015, 4252},
  {"Compile::cpintlt2", 120942, 4275},
  {"Compile::cpiter", 121878, 4298},
  {"Compile::cplist", 122792, 4321},
  {"Compile::cpout", 123708, 4344},
  {"Compile::cppat", 124620, 4367},
  {"Compile::cprank", 125300, 4384},
  {"Compile::cpts", 126224, 4407},
  {"Compile::cptype", 127126, 4430},
  {"Compile::cpw", 128130, 4455},
  {"Compile::cret", 128793, 4472},
  {"Compile::cret1", 129694, 4495},
  {"Compile::cset", 130607, 4518},
  {"Compile::ctyp1", 131509, 4541},
  {"Compile::ctyp2", 132424, 4564},
  {"Compile::ctyps", 133339, 4587},
  {"Compile::cxcoerce", 134337, 4612},
  {"Compile::defn", 135362, 4637},
  {"Compile::part", 135636, 4644},
  {"Compile::symdef", 135912, 4651},
  {"Compile::nocomp", 136194, 4658},
  {"Compile::extscalar", 136479, 4665},
  {"Compile::exttensor", 137437, 4688},
  {"Compile::initvar", 138393, 4711},
  {"Compile::maxrank", 139410, 4736},
  {"Compile::realcoerce", 139700, 4743},
  {"Compile::type", 140664, 4766},
  {"CompiledFunction::ccf", 140946, 4773},
  {"CompiledFunction::cfcode", 141776, 4792},
  {"CompiledFunction::cfct", 142095, 4799},
  {"CompiledFunction::cfex", 143447, 4830},
  {"CompiledFunction::cfff", 145147, 4869},
  {"CompiledFunction::cffv", 145459, 4876},
  {"CompiledFunction::cfins", 145772, 4883},
  {"CompiledFunction::cflist", 146089, 4890},
  {"CompiledFunction::cfn", 146947, 4909},
  {"CompiledFunction::cfnlts", 148034, 4934},
  {"CompiledFunction::cfnv", 148801, 4951},
  {"CompiledFunction::cfsa", 149729, 4972},
  {"CompiledFunction::cfse", 151080, 5003},
  {"CompiledFunction::cfsec", 152695, 5040},
  {"CompiledFunction::cfta", 153986, 5069},
  {"CompiledFunction::cfte", 155351, 5100},
  {"CompiledFunction::cftec", 156809, 5133},
  {"CompiledFunction::cfver", 158101, 5162},
  {"CompiledFunction::mldot", 158420, 5169},
  {"CompiledFunction::orank", 158738, 5176}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 24, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1825, 57, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::argset"],
Cell[1911, 60, 403, 10, 37, "Message",
  CellTags->"Compile::argset"],
Cell[2317, 72, 339, 7, 62, "Notes",
  CellTags->"Compile::argset"],

Cell[CellGroupData[{
Cell[2681, 83, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::argset"],
Cell[2749, 86, 154, 5, 24, "Text",
  CellTags->"Compile::argset"],

Cell[CellGroupData[{
Cell[2928, 95, 117, 3, 26, "Input",
  CellTags->"Compile::argset"],
Cell[3048, 100, 227, 5, 37, "Message",
  CellTags->"Compile::argset"],
Cell[3278, 107, 189, 5, 21, "Output",
  CellTags->"Compile::argset"]
}, Open  ]],
Cell[3482, 115, 167, 5, 24, "Text",
  CellTags->"Compile::argset"],

Cell[CellGroupData[{
Cell[3674, 124, 134, 3, 26, "Input",
  CellTags->"Compile::argset"],
Cell[3811, 129, 92, 3, 21, "Output",
  CellTags->"Compile::argset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3964, 139, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::iterset"],
Cell[4052, 142, 237, 5, 53, "Message",
  CellTags->"Compile::iterset"],
Cell[4292, 149, 127, 4, 24, "Notes",
  CellTags->"Compile::iterset"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4456, 158, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::compfail"],
Cell[4546, 161, 225, 5, 37, "Message",
  CellTags->"Compile::compfail"],
Cell[4774, 168, 128, 4, 24, "Notes",
  CellTags->"Compile::compfail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4939, 177, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::ccon"],
Cell[5021, 180, 276, 6, 37, "Message",
  CellTags->"Compile::ccon"],
Cell[5300, 188, 340, 9, 56, "Notes",
  CellTags->"Compile::ccon"],

Cell[CellGroupData[{
Cell[5665, 201, 63, 1, 38, "ExampleSection",
  CellTags->"Compile::ccon"],
Cell[5731, 204, 240, 8, 40, "Text",
  CellTags->"Compile::ccon"],

Cell[CellGroupData[{
Cell[5996, 216, 168, 4, 74, "Input",
  CellTags->"Compile::ccon"],
Cell[6167, 222, 208, 5, 37, "Message",
  CellTags->"Compile::ccon"],
Cell[6378, 229, 208, 5, 37, "Message",
  CellTags->"Compile::ccon"],
Cell[6589, 236, 181, 5, 21, "Output",
  CellTags->"Compile::ccon"]
}, Open  ]],
Cell[6785, 244, 417, 11, 56, "Text",
  CellTags->"Compile::ccon"],

Cell[CellGroupData[{
Cell[7227, 259, 198, 5, 90, "Input",
  CellTags->"Compile::ccon"],
Cell[7428, 266, 181, 5, 21, "Output",
  CellTags->"Compile::ccon"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7646, 276, 94, 3, 26, "Input",
  CellTags->"Compile::ccon"],
Cell[7743, 281, 91, 3, 21, "Output",
  CellTags->"Compile::ccon"]
}, Open  ]],
Cell[7849, 287, 111, 5, 24, "Text",
  CellTags->"Compile::ccon"],
Cell[7963, 294, 95, 3, 26, "Input",
  CellTags->"Compile::ccon"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8107, 303, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cif"],
Cell[8187, 306, 546, 10, 53, "Message",
  CellTags->"Compile::cif"],
Cell[8736, 318, 300, 6, 62, "Notes",
  CellTags->"Compile::cif"],

Cell[CellGroupData[{
Cell[9061, 328, 62, 1, 38, "ExampleSection",
  CellTags->"Compile::cif"],
Cell[9126, 331, 197, 5, 40, "Text",
  CellTags->"Compile::cif"],

Cell[CellGroupData[{
Cell[9348, 340, 163, 4, 42, "Input",
  CellTags->"Compile::cif"],
Cell[9514, 346, 293, 6, 69, "Message",
  CellTags->"Compile::cif"],
Cell[9810, 354, 188, 5, 21, "Output",
  CellTags->"Compile::cif"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10059, 366, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpapot"],
Cell[10145, 369, 254, 5, 53, "Message",
  CellTags->"Compile::cpapot"],
Cell[10402, 376, 537, 17, 62, "Notes",
  CellTags->"Compile::cpapot"],

Cell[CellGroupData[{
Cell[10964, 397, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::cpapot"],
Cell[11032, 400, 157, 5, 24, "Text",
  CellTags->"Compile::cpapot"],

Cell[CellGroupData[{
Cell[11214, 409, 129, 3, 26, "Input",
  CellTags->"Compile::cpapot"],
Cell[11346, 414, 276, 6, 53, "Message",
  CellTags->"Compile::cpapot"],
Cell[11625, 422, 184, 5, 21, "Output",
  CellTags->"Compile::cpapot"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11870, 434, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpbool"],
Cell[11956, 437, 477, 13, 53, "Message",
  CellTags->"Compile::cpbool"],
Cell[12436, 452, 205, 7, 24, "Notes",
  CellTags->"Compile::cpbool"],

Cell[CellGroupData[{
Cell[12666, 463, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::cpbool"],
Cell[12734, 466, 250, 9, 40, "Text",
  CellTags->"Compile::cpbool"],

Cell[CellGroupData[{
Cell[13009, 479, 128, 3, 26, "Input",
  CellTags->"Compile::cpbool"],
Cell[13140, 484, 278, 6, 53, "Message",
  CellTags->"Compile::cpbool"],
Cell[13421, 492, 210, 6, 21, "Output",
  CellTags->"Compile::cpbool"]
}, Open  ]],
Cell[13646, 501, 208, 7, 24, "Text",
  CellTags->"Compile::cpbool"],

Cell[CellGroupData[{
Cell[13879, 512, 132, 3, 26, "Input",
  CellTags->"Compile::cpbool"],
Cell[14014, 517, 214, 6, 21, "Output",
  CellTags->"Compile::cpbool"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14289, 530, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpdsts"],
Cell[14375, 533, 375, 7, 37, "Message",
  CellTags->"Compile::cpdsts"],
Cell[14753, 542, 223, 7, 24, "Notes",
  CellTags->"Compile::cpdsts"],

Cell[CellGroupData[{
Cell[15001, 553, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::cpdsts"],
Cell[15069, 556, 240, 5, 40, "Text",
  CellTags->"Compile::cpdsts"],

Cell[CellGroupData[{
Cell[15334, 565, 149, 4, 26, "Input",
  CellTags->"Compile::cpdsts"],
Cell[15486, 571, 287, 6, 53, "Message",
  CellTags->"Compile::cpdsts"],
Cell[15776, 579, 208, 6, 21, "Output",
  CellTags->"Compile::cpdsts"]
}, Open  ]],
Cell[15999, 588, 216, 5, 40, "Text",
  CellTags->"Compile::cpdsts"],

Cell[CellGroupData[{
Cell[16240, 597, 186, 5, 42, "Input",
  CellTags->"Compile::cpdsts"],
Cell[16429, 604, 215, 6, 37, "Output",
  CellTags->"Compile::cpdsts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16705, 617, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpint"],
Cell[16789, 620, 473, 13, 53, "Message",
  CellTags->"Compile::cpint"],
Cell[17265, 635, 340, 7, 62, "Notes",
  CellTags->"Compile::cpint"],

Cell[CellGroupData[{
Cell[17630, 646, 64, 1, 38, "ExampleSection",
  CellTags->"Compile::cpint"],
Cell[17697, 649, 178, 5, 24, "Text",
  CellTags->"Compile::cpint"],

Cell[CellGroupData[{
Cell[17900, 658, 137, 3, 26, "Input",
  CellTags->"Compile::cpint"],
Cell[18040, 663, 368, 7, 69, "Message",
  CellTags->"Compile::cpint"],
Cell[18411, 672, 218, 6, 37, "Output",
  CellTags->"Compile::cpint"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18690, 685, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpintlt"],
Cell[18778, 688, 533, 14, 53, "Message",
  CellTags->"Compile::cpintlt"],
Cell[19314, 704, 373, 8, 62, "Notes",
  CellTags->"Compile::cpintlt"],

Cell[CellGroupData[{
Cell[19712, 716, 66, 1, 38, "ExampleSection",
  CellTags->"Compile::cpintlt"],
Cell[19781, 719, 148, 4, 24, "Text",
  CellTags->"Compile::cpintlt"],

Cell[CellGroupData[{
Cell[19954, 727, 127, 3, 26, "Input",
  CellTags->"Compile::cpintlt"],
Cell[20084, 732, 367, 7, 69, "Message",
  CellTags->"Compile::cpintlt"],
Cell[20454, 741, 243, 6, 21, "Output",
  CellTags->"Compile::cpintlt"]
}, Open  ]],
Cell[20712, 750, 245, 6, 40, "Text",
  CellTags->"Compile::cpintlt"],

Cell[CellGroupData[{
Cell[20982, 760, 144, 3, 26, "Input",
  CellTags->"Compile::cpintlt"],
Cell[21129, 765, 243, 6, 21, "Output",
  CellTags->"Compile::cpintlt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21433, 778, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpintlt2"],
Cell[21523, 781, 539, 14, 69, "Message",
  CellTags->"Compile::cpintlt2"],
Cell[22065, 797, 376, 8, 62, "Notes",
  CellTags->"Compile::cpintlt2"],

Cell[CellGroupData[{
Cell[22466, 809, 67, 1, 38, "ExampleSection",
  CellTags->"Compile::cpintlt2"],
Cell[22536, 812, 149, 4, 24, "Text",
  CellTags->"Compile::cpintlt2"],

Cell[CellGroupData[{
Cell[22710, 820, 130, 3, 26, "Input",
  CellTags->"Compile::cpintlt2"],
Cell[22843, 825, 345, 6, 69, "Message",
  CellTags->"Compile::cpintlt2"],
Cell[23191, 833, 211, 6, 21, "Output",
  CellTags->"Compile::cpintlt2"]
}, Open  ]],
Cell[23417, 842, 246, 6, 40, "Text",
  CellTags->"Compile::cpintlt2"],

Cell[CellGroupData[{
Cell[23688, 852, 147, 3, 26, "Input",
  CellTags->"Compile::cpintlt2"],
Cell[23838, 857, 211, 6, 21, "Output",
  CellTags->"Compile::cpintlt2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24110, 870, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpiter"],
Cell[24196, 873, 415, 11, 37, "Message",
  CellTags->"Compile::cpiter"],
Cell[24614, 886, 398, 10, 62, "Notes",
  CellTags->"Compile::cpiter"],

Cell[CellGroupData[{
Cell[25037, 900, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::cpiter"],
Cell[25105, 903, 147, 4, 24, "Text",
  CellTags->"Compile::cpiter"],

Cell[CellGroupData[{
Cell[25277, 911, 112, 3, 26, "Input",
  CellTags->"Compile::cpiter"],
Cell[25392, 916, 262, 5, 53, "Message",
  CellTags->"Compile::cpiter"],
Cell[25657, 923, 184, 5, 21, "Output",
  CellTags->"Compile::cpiter"]
}, Open  ]],
Cell[25856, 931, 90, 1, 24, "Text",
  CellTags->"Compile::cpiter"],

Cell[CellGroupData[{
Cell[25971, 936, 114, 3, 26, "Input",
  CellTags->"Compile::cpiter"],
Cell[26088, 941, 186, 5, 21, "Output",
  CellTags->"Compile::cpiter"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26335, 953, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cplist"],
Cell[26421, 956, 309, 7, 37, "Message",
  CellTags->"Compile::cplist"],
Cell[26733, 965, 336, 7, 62, "Notes",
  CellTags->"Compile::cplist"],

Cell[CellGroupData[{
Cell[27094, 976, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::cplist"],
Cell[27162, 979, 189, 6, 24, "Text",
  CellTags->"Compile::cplist"],

Cell[CellGroupData[{
Cell[27376, 989, 135, 3, 26, "Input",
  CellTags->"Compile::cplist"],
Cell[27514, 994, 293, 6, 53, "Message",
  CellTags->"Compile::cplist"],
Cell[27810, 1002, 246, 7, 21, "Output",
  CellTags->"Compile::cplist"]
}, Open  ]],
Cell[28071, 1012, 182, 5, 24, "Text",
  CellTags->"Compile::cplist"],

Cell[CellGroupData[{
Cell[28278, 1021, 126, 3, 26, "Input",
  CellTags->"Compile::cplist"],
Cell[28407, 1026, 186, 5, 21, "Output",
  CellTags->"Compile::cplist"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28654, 1038, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpout"],
Cell[28738, 1041, 245, 5, 53, "Message",
  CellTags->"Compile::cpout"],
Cell[28986, 1048, 264, 6, 40, "Notes",
  CellTags->"Compile::cpout"],

Cell[CellGroupData[{
Cell[29275, 1058, 64, 1, 38, "ExampleSection",
  CellTags->"Compile::cpout"],
Cell[29342, 1061, 300, 9, 40, "Text",
  CellTags->"Compile::cpout"],

Cell[CellGroupData[{
Cell[29667, 1074, 126, 3, 26, "Input",
  CellTags->"Compile::cpout"],
Cell[29796, 1079, 242, 5, 53, "Message",
  CellTags->"Compile::cpout"],
Cell[30041, 1086, 207, 6, 21, "Output",
  CellTags->"Compile::cpout"]
}, Open  ]],
Cell[30263, 1095, 102, 1, 24, "Text",
  CellTags->"Compile::cpout"],

Cell[CellGroupData[{
Cell[30390, 1100, 128, 3, 26, "Input",
  CellTags->"Compile::cpout"],
Cell[30521, 1105, 209, 6, 21, "Output",
  CellTags->"Compile::cpout"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30791, 1118, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cppat"],
Cell[30875, 1121, 353, 7, 37, "Message",
  CellTags->"Compile::cppat"],
Cell[31231, 1130, 525, 18, 78, "Notes",
  CellTags->"Compile::cppat"],

Cell[CellGroupData[{
Cell[31781, 1152, 64, 1, 38, "ExampleSection",
  CellTags->"Compile::cppat"],
Cell[31848, 1155, 258, 7, 40, "Text",
  CellTags->"Compile::cppat"],

Cell[CellGroupData[{
Cell[32131, 1166, 137, 3, 26, "Input",
  CellTags->"Compile::cppat"],
Cell[32271, 1171, 309, 6, 53, "Message",
  CellTags->"Compile::cppat"],
Cell[32583, 1179, 218, 6, 37, "Output",
  CellTags->"Compile::cppat"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32862, 1192, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cprank"],
Cell[32948, 1195, 541, 12, 53, "Message",
  CellTags->"Compile::cprank"],
Cell[33492, 1209, 448, 12, 68, "Notes",
  CellTags->"Compile::cprank"],

Cell[CellGroupData[{
Cell[33965, 1225, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::cprank"],
Cell[34033, 1228, 196, 6, 40, "Text",
  CellTags->"Compile::cprank"],

Cell[CellGroupData[{
Cell[34254, 1238, 163, 4, 42, "Input",
  CellTags->"Compile::cprank"],
Cell[34420, 1244, 396, 7, 69, "Message",
  CellTags->"Compile::cprank"],
Cell[34819, 1253, 220, 6, 37, "Output",
  CellTags->"Compile::cprank"]
}, Open  ]],
Cell[35054, 1262, 211, 5, 40, "Text",
  CellTags->"Compile::cprank"],

Cell[CellGroupData[{
Cell[35290, 1271, 139, 3, 26, "Input",
  CellTags->"Compile::cprank"],
Cell[35432, 1276, 220, 6, 37, "Output",
  CellTags->"Compile::cprank"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35713, 1289, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpts"],
Cell[35795, 1292, 405, 8, 53, "Message",
  CellTags->"Compile::cpts"],
Cell[36203, 1302, 278, 7, 46, "Notes",
  CellTags->"Compile::cpts"],

Cell[CellGroupData[{
Cell[36506, 1313, 63, 1, 38, "ExampleSection",
  CellTags->"Compile::cpts"],
Cell[36572, 1316, 127, 4, 24, "Text",
  CellTags->"Compile::cpts"],

Cell[CellGroupData[{
Cell[36724, 1324, 124, 3, 26, "Input",
  CellTags->"Compile::cpts"],
Cell[36851, 1329, 344, 7, 69, "Message",
  CellTags->"Compile::cpts"],
Cell[37198, 1338, 205, 6, 21, "Output",
  CellTags->"Compile::cpts"]
}, Open  ]],
Cell[37418, 1347, 105, 1, 24, "Text",
  CellTags->"Compile::cpts"],

Cell[CellGroupData[{
Cell[37548, 1352, 111, 3, 26, "Input",
  CellTags->"Compile::cpts"],
Cell[37662, 1357, 101, 3, 21, "Output",
  CellTags->"Compile::cpts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37824, 1367, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cptype"],
Cell[37910, 1370, 413, 11, 37, "Message",
  CellTags->"Compile::cptype"],
Cell[38326, 1383, 432, 10, 78, "Notes",
  CellTags->"Compile::cptype"],

Cell[CellGroupData[{
Cell[38783, 1397, 65, 1, 38, "ExampleSection",
  CellTags->"Compile::cptype"],
Cell[38851, 1400, 190, 5, 40, "Text",
  CellTags->"Compile::cptype"],

Cell[CellGroupData[{
Cell[39066, 1409, 122, 3, 26, "Input",
  CellTags->"Compile::cptype"],
Cell[39191, 1414, 234, 5, 37, "Message",
  CellTags->"Compile::cptype"],
Cell[39428, 1421, 182, 5, 21, "Output",
  CellTags->"Compile::cptype"]
}, Open  ]],
Cell[39625, 1429, 161, 5, 24, "Text",
  CellTags->"Compile::cptype"],

Cell[CellGroupData[{
Cell[39811, 1438, 123, 3, 26, "Input",
  CellTags->"Compile::cptype"],
Cell[39937, 1443, 236, 5, 37, "Message",
  CellTags->"Compile::cptype"],
Cell[40176, 1450, 179, 5, 21, "Output",
  CellTags->"Compile::cptype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40416, 1462, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cpw"],
Cell[40496, 1465, 360, 10, 21, "Message",
  CellTags->"Compile::cpw"],
Cell[40859, 1477, 344, 11, 46, "Notes",
  CellTags->"Compile::cpw"],

Cell[CellGroupData[{
Cell[41228, 1492, 62, 1, 38, "ExampleSection",
  CellTags->"Compile::cpw"],
Cell[41293, 1495, 231, 7, 40, "Text",
  CellTags->"Compile::cpw"],

Cell[CellGroupData[{
Cell[41549, 1506, 123, 3, 26, "Input",
  CellTags->"Compile::cpw"],
Cell[41675, 1511, 182, 4, 21, "Message",
  CellTags->"Compile::cpw"],
Cell[41860, 1517, 171, 5, 21, "Output",
  CellTags->"Compile::cpw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42092, 1529, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cret"],
Cell[42174, 1532, 229, 5, 37, "Message",
  CellTags->"Compile::cret"],
Cell[42406, 1539, 182, 4, 40, "Notes",
  CellTags->"Compile::cret"],

Cell[CellGroupData[{
Cell[42613, 1547, 63, 1, 38, "ExampleSection",
  CellTags->"Compile::cret"],
Cell[42679, 1550, 197, 5, 40, "Text",
  CellTags->"Compile::cret"],

Cell[CellGroupData[{
Cell[42901, 1559, 125, 3, 26, "Input",
  CellTags->"Compile::cret"],
Cell[43029, 1564, 299, 6, 53, "Message",
  CellTags->"Compile::cret"],
Cell[43331, 1572, 206, 6, 21, "Output",
  CellTags->"Compile::cret"]
}, Open  ]],
Cell[43552, 1581, 149, 4, 24, "Text",
  CellTags->"Compile::cret"],

Cell[CellGroupData[{
Cell[43726, 1589, 127, 3, 26, "Input",
  CellTags->"Compile::cret"],
Cell[43856, 1594, 208, 6, 21, "Output",
  CellTags->"Compile::cret"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[44125, 1607, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cret1"],
Cell[44209, 1610, 425, 10, 37, "Message",
  CellTags->"Compile::cret1"],
Cell[44637, 1622, 559, 19, 78, "Notes",
  CellTags->"Compile::cret1"],

Cell[CellGroupData[{
Cell[45221, 1645, 64, 1, 38, "ExampleSection",
  CellTags->"Compile::cret1"],
Cell[45288, 1648, 234, 6, 40, "Text",
  CellTags->"Compile::cret1"],

Cell[CellGroupData[{
Cell[45547, 1658, 136, 3, 26, "Input",
  CellTags->"Compile::cret1"],
Cell[45686, 1663, 238, 5, 37, "Message",
  CellTags->"Compile::cret1"],
Cell[45927, 1670, 217, 6, 37, "Output",
  CellTags->"Compile::cret1"]
}, Open  ]],
Cell[46159, 1679, 137, 4, 24, "Text",
  CellTags->"Compile::cret1"],

Cell[CellGroupData[{
Cell[46321, 1687, 139, 3, 26, "Input",
  CellTags->"Compile::cret1"],
Cell[46463, 1692, 220, 6, 37, "Output",
  CellTags->"Compile::cret1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[46744, 1705, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cset"],
Cell[46826, 1708, 428, 12, 37, "Message",
  CellTags->"Compile::cset"],
Cell[47257, 1722, 295, 6, 62, "Notes",
  CellTags->"Compile::cset"],

Cell[CellGroupData[{
Cell[47577, 1732, 63, 1, 38, "ExampleSection",
  CellTags->"Compile::cset"],
Cell[47643, 1735, 188, 5, 40, "Text",
  CellTags->"Compile::cset"],

Cell[CellGroupData[{
Cell[47856, 1744, 137, 3, 26, "Input",
  CellTags->"Compile::cset"],
Cell[47996, 1749, 233, 5, 37, "Message",
  CellTags->"Compile::cset"],
Cell[48232, 1756, 206, 6, 21, "Output",
  CellTags->"Compile::cset"]
}, Open  ]],
Cell[48453, 1765, 161, 4, 40, "Text",
  CellTags->"Compile::cset"],

Cell[CellGroupData[{
Cell[48639, 1773, 155, 4, 26, "Input",
  CellTags->"Compile::cset"],
Cell[48797, 1779, 278, 8, 37, "Output",
  CellTags->"Compile::cset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49136, 1794, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::ctyp1"],
Cell[49220, 1797, 231, 5, 53, "Message",
  CellTags->"Compile::ctyp1"],
Cell[49454, 1804, 1743, 53, 214, "Notes",
  CellTags->"Compile::ctyp1"],

Cell[CellGroupData[{
Cell[51222, 1861, 64, 1, 38, "ExampleSection",
  CellTags->"Compile::ctyp1"],
Cell[51289, 1864, 195, 6, 40, "Text",
  CellTags->"Compile::ctyp1"],

Cell[CellGroupData[{
Cell[51509, 1874, 120, 3, 26, "Input",
  CellTags->"Compile::ctyp1"],
Cell[51632, 1879, 250, 5, 53, "Message",
  CellTags->"Compile::ctyp1"],
Cell[51885, 1886, 121, 3, 21, "Output",
  CellTags->"Compile::ctyp1"]
}, Open  ]],
Cell[52021, 1892, 181, 4, 40, "Text",
  CellTags->"Compile::ctyp1"],

Cell[CellGroupData[{
Cell[52227, 1900, 122, 3, 26, "Input",
  CellTags->"Compile::ctyp1"],
Cell[52352, 1905, 182, 5, 21, "Output",
  CellTags->"Compile::ctyp1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52595, 1917, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::ctyp2"],
Cell[52679, 1920, 254, 6, 21, "Message",
  CellTags->"Compile::ctyp2"],
Cell[52936, 1928, 1370, 47, 122, "Notes",
  CellTags->"Compile::ctyp2"],

Cell[CellGroupData[{
Cell[54331, 1979, 64, 1, 38, "ExampleSection",
  CellTags->"Compile::ctyp2"],
Cell[54398, 1982, 170, 4, 40, "Text",
  CellTags->"Compile::ctyp2"],

Cell[CellGroupData[{
Cell[54593, 1990, 115, 3, 26, "Input",
  CellTags->"Compile::ctyp2"],
Cell[54711, 1995, 187, 4, 21, "Message",
  CellTags->"Compile::ctyp2"],
Cell[54901, 2001, 116, 3, 21, "Output",
  CellTags->"Compile::ctyp2"]
}, Open  ]],
Cell[55032, 2007, 154, 4, 24, "Text",
  CellTags->"Compile::ctyp2"],

Cell[CellGroupData[{
Cell[55211, 2015, 122, 3, 26, "Input",
  CellTags->"Compile::ctyp2"],
Cell[55336, 2020, 182, 5, 21, "Output",
  CellTags->"Compile::ctyp2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55579, 2032, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::ctyps"],
Cell[55663, 2035, 237, 5, 21, "Message",
  CellTags->"Compile::ctyps"],
Cell[55903, 2042, 1393, 47, 138, "Notes",
  CellTags->"Compile::ctyps"],

Cell[CellGroupData[{
Cell[57321, 2093, 64, 1, 38, "ExampleSection",
  CellTags->"Compile::ctyps"],
Cell[57388, 2096, 160, 4, 40, "Text",
  CellTags->"Compile::ctyps"],

Cell[CellGroupData[{
Cell[57573, 2104, 129, 3, 26, "Input",
  CellTags->"Compile::ctyps"],
Cell[57705, 2109, 185, 4, 21, "Message",
  CellTags->"Compile::ctyps"],
Cell[57893, 2115, 189, 4, 21, "Message",
  CellTags->"Compile::ctyps"],
Cell[58085, 2121, 177, 5, 21, "Output",
  CellTags->"Compile::ctyps"]
}, Open  ]],
Cell[58277, 2129, 105, 1, 24, "Text",
  CellTags->"Compile::ctyps"],

Cell[CellGroupData[{
Cell[58407, 2134, 131, 3, 26, "Input",
  CellTags->"Compile::ctyps"],
Cell[58541, 2139, 177, 5, 21, "Output",
  CellTags->"Compile::ctyps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58779, 2151, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::cxcoerce"],
Cell[58869, 2154, 234, 5, 53, "Message",
  CellTags->"Compile::cxcoerce"],
Cell[59106, 2161, 298, 7, 46, "Notes",
  CellTags->"Compile::cxcoerce"],

Cell[CellGroupData[{
Cell[59429, 2172, 67, 1, 38, "ExampleSection",
  CellTags->"Compile::cxcoerce"],
Cell[59499, 2175, 138, 4, 24, "Text",
  CellTags->"Compile::cxcoerce"],
Cell[59640, 2181, 196, 4, 42, "Input",
  CellTags->"Compile::cxcoerce"],

Cell[CellGroupData[{
Cell[59861, 2189, 108, 3, 26, "Input",
  CellTags->"Compile::cxcoerce"],
Cell[59972, 2194, 252, 5, 53, "Message",
  CellTags->"Compile::cxcoerce"],
Cell[60227, 2201, 253, 5, 53, "Message",
  CellTags->"Compile::cxcoerce"],
Cell[60483, 2208, 192, 5, 21, "Output",
  CellTags->"Compile::cxcoerce"]
}, Open  ]],
Cell[60690, 2216, 66, 1, 24, "Text",
  CellTags->"Compile::cxcoerce"],
Cell[60759, 2219, 197, 4, 42, "Input",
  CellTags->"Compile::cxcoerce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[61005, 2229, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::defn"],
Cell[61087, 2232, 196, 5, 37, "Message",
  CellTags->"Compile::defn"],
Cell[61286, 2239, 124, 4, 24, "Notes",
  CellTags->"Compile::defn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61447, 2248, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::part"],
Cell[61529, 2251, 280, 6, 69, "Message",
  CellTags->"Compile::part"],
Cell[61812, 2259, 124, 4, 24, "Notes",
  CellTags->"Compile::part"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61973, 2268, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::symdef"],
Cell[62059, 2271, 222, 5, 37, "Message",
  CellTags->"Compile::symdef"],
Cell[62284, 2278, 126, 4, 24, "Notes",
  CellTags->"Compile::symdef"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62447, 2287, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::nocomp"],
Cell[62533, 2290, 252, 5, 53, "Message",
  CellTags->"Compile::nocomp"],
Cell[62788, 2297, 126, 4, 24, "Notes",
  CellTags->"Compile::nocomp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62951, 2306, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::extscalar"],
Cell[63043, 2309, 244, 5, 53, "Message",
  CellTags->"Compile::extscalar"],
Cell[63290, 2316, 308, 6, 62, "Notes",
  CellTags->"Compile::extscalar"],

Cell[CellGroupData[{
Cell[63623, 2326, 68, 1, 38, "ExampleSection",
  CellTags->"Compile::extscalar"],
Cell[63694, 2329, 143, 4, 24, "Text",
  CellTags->"Compile::extscalar"],
Cell[63840, 2335, 197, 4, 42, "Input",
  CellTags->"Compile::extscalar"],

Cell[CellGroupData[{
Cell[64062, 2343, 113, 3, 26, "Input",
  CellTags->"Compile::extscalar"],
Cell[64178, 2348, 257, 5, 53, "Message",
  CellTags->"Compile::extscalar"],
Cell[64438, 2355, 185, 5, 21, "Output",
  CellTags->"Compile::extscalar"]
}, Open  ]],
Cell[64638, 2363, 67, 1, 24, "Text",
  CellTags->"Compile::extscalar"],
Cell[64708, 2366, 198, 4, 42, "Input",
  CellTags->"Compile::extscalar"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[64955, 2376, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::exttensor"],
Cell[65047, 2379, 262, 5, 53, "Message",
  CellTags->"Compile::exttensor"],
Cell[65312, 2386, 307, 6, 62, "Notes",
  CellTags->"Compile::exttensor"],

Cell[CellGroupData[{
Cell[65644, 2396, 68, 1, 38, "ExampleSection",
  CellTags->"Compile::exttensor"],
Cell[65715, 2399, 143, 4, 24, "Text",
  CellTags->"Compile::exttensor"],
Cell[65861, 2405, 197, 4, 42, "Input",
  CellTags->"Compile::exttensor"],

Cell[CellGroupData[{
Cell[66083, 2413, 125, 3, 26, "Input",
  CellTags->"Compile::exttensor"],
Cell[66211, 2418, 281, 6, 53, "Message",
  CellTags->"Compile::exttensor"],
Cell[66495, 2426, 185, 5, 21, "Output",
  CellTags->"Compile::exttensor"]
}, Open  ]],
Cell[66695, 2434, 67, 1, 24, "Text",
  CellTags->"Compile::exttensor"],
Cell[66765, 2437, 198, 4, 42, "Input",
  CellTags->"Compile::exttensor"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67012, 2447, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::initvar"],
Cell[67100, 2450, 217, 5, 37, "Message",
  CellTags->"Compile::initvar"],
Cell[67320, 2457, 158, 4, 24, "Notes",
  CellTags->"Compile::initvar"],

Cell[CellGroupData[{
Cell[67503, 2465, 66, 1, 38, "ExampleSection",
  CellTags->"Compile::initvar"],
Cell[67572, 2468, 184, 5, 24, "Text",
  CellTags->"Compile::initvar"],

Cell[CellGroupData[{
Cell[67781, 2477, 119, 3, 26, "Input",
  CellTags->"Compile::initvar"],
Cell[67903, 2482, 220, 5, 37, "Message",
  CellTags->"Compile::initvar"],
Cell[68126, 2489, 235, 5, 37, "Message",
  CellTags->"Compile::initvar"],
Cell[68364, 2496, 191, 5, 21, "Output",
  CellTags->"Compile::initvar"]
}, Open  ]],
Cell[68570, 2504, 98, 1, 24, "Text",
  CellTags->"Compile::initvar"],

Cell[CellGroupData[{
Cell[68693, 2509, 123, 3, 26, "Input",
  CellTags->"Compile::initvar"],
Cell[68819, 2514, 195, 5, 21, "Output",
  CellTags->"Compile::initvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69075, 2526, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::maxrank"],
Cell[69163, 2529, 454, 13, 37, "Message",
  CellTags->"Compile::maxrank"],
Cell[69620, 2544, 127, 4, 24, "Notes",
  CellTags->"Compile::maxrank"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69784, 2553, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::realcoerce"],
Cell[69878, 2556, 235, 5, 53, "Message",
  CellTags->"Compile::realcoerce"],
Cell[70116, 2563, 297, 7, 46, "Notes",
  CellTags->"Compile::realcoerce"],

Cell[CellGroupData[{
Cell[70438, 2574, 69, 1, 38, "ExampleSection",
  CellTags->"Compile::realcoerce"],
Cell[70510, 2577, 156, 4, 24, "Text",
  CellTags->"Compile::realcoerce"],
Cell[70669, 2583, 198, 4, 42, "Input",
  CellTags->"Compile::realcoerce"],

Cell[CellGroupData[{
Cell[70892, 2591, 111, 3, 26, "Input",
  CellTags->"Compile::realcoerce"],
Cell[71006, 2596, 246, 5, 53, "Message",
  CellTags->"Compile::realcoerce"],
Cell[71255, 2603, 186, 5, 21, "Output",
  CellTags->"Compile::realcoerce"]
}, Open  ]],
Cell[71456, 2611, 68, 1, 24, "Text",
  CellTags->"Compile::realcoerce"],
Cell[71527, 2614, 199, 4, 42, "Input",
  CellTags->"Compile::realcoerce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71775, 2624, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Compile::type"],
Cell[71857, 2627, 251, 5, 53, "Message",
  CellTags->"Compile::type"],
Cell[72111, 2634, 177, 4, 24, "Notes",
  CellTags->"Compile::type"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72325, 2643, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::ccf"],
Cell[72423, 2646, 277, 6, 37, "Message",
  CellTags->"CompiledFunction::ccf"],
Cell[72703, 2654, 385, 8, 78, "Notes",
  CellTags->"CompiledFunction::ccf"],

Cell[CellGroupData[{
Cell[73113, 2666, 71, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::ccf"],
Cell[73187, 2669, 207, 5, 40, "Text",
  CellTags->"CompiledFunction::ccf"],

Cell[CellGroupData[{
Cell[73419, 2678, 152, 3, 26, "Input",
  CellTags->"CompiledFunction::ccf"],
Cell[73574, 2683, 222, 5, 37, "Message",
  CellTags->"CompiledFunction::ccf"],
Cell[73799, 2690, 241, 5, 53, "Message",
  CellTags->"CompiledFunction::ccf"],
Cell[74043, 2697, 104, 3, 21, "Print",
  CellTags->"CompiledFunction::ccf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[74208, 2707, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfcode"],
Cell[74312, 2710, 492, 13, 37, "Message",
  CellTags->"CompiledFunction::cfcode"],
Cell[74807, 2725, 557, 14, 84, "Notes",
  CellTags->"CompiledFunction::cfcode"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75401, 2744, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfct"],
Cell[75501, 2747, 454, 11, 37, "Message",
  CellTags->"CompiledFunction::cfct"],
Cell[75958, 2760, 247, 5, 40, "Notes",
  CellTags->"CompiledFunction::cfct"],

Cell[CellGroupData[{
Cell[76230, 2769, 72, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfct"],
Cell[76305, 2772, 243, 7, 40, "Text",
  CellTags->"CompiledFunction::cfct"],

Cell[CellGroupData[{
Cell[76573, 2783, 122, 3, 26, "Input",
  CellTags->"CompiledFunction::cfct"],
Cell[76698, 2788, 189, 5, 21, "Output",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76924, 2798, 100, 3, 26, "Input",
  CellTags->"CompiledFunction::cfct"],
Cell[77027, 2803, 241, 5, 53, "Message",
  CellTags->"CompiledFunction::cfct"],
Cell[77271, 2810, 225, 6, 21, "Output",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]],
Cell[77511, 2819, 152, 4, 24, "Text",
  CellTags->"CompiledFunction::cfct"],

Cell[CellGroupData[{
Cell[77688, 2827, 103, 3, 26, "Input",
  CellTags->"CompiledFunction::cfct"],
Cell[77794, 2832, 99, 3, 21, "Output",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]],
Cell[77908, 2838, 120, 5, 24, "Text",
  CellTags->"CompiledFunction::cfct"],
Cell[78031, 2845, 104, 3, 26, "Input",
  CellTags->"CompiledFunction::cfct"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[78184, 2854, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfex"],
Cell[78284, 2857, 401, 10, 37, "Message",
  CellTags->"CompiledFunction::cfex"],
Cell[78688, 2869, 870, 14, 160, "Notes",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{
Cell[79583, 2887, 72, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfex"],
Cell[79658, 2890, 234, 5, 40, "Text",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{
Cell[79917, 2899, 118, 3, 26, "Input",
  CellTags->"CompiledFunction::cfex"],
Cell[80038, 2904, 185, 5, 21, "Output",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80260, 2914, 99, 3, 26, "Input",
  CellTags->"CompiledFunction::cfex"],
Cell[80362, 2919, 229, 5, 37, "Message",
  CellTags->"CompiledFunction::cfex"],
Cell[80594, 2926, 242, 5, 53, "Message",
  CellTags->"CompiledFunction::cfex"],
Cell[80839, 2933, 101, 3, 21, "Output",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],
Cell[80955, 2939, 166, 4, 24, "Text",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{
Cell[81146, 2947, 117, 3, 26, "Input",
  CellTags->"CompiledFunction::cfex"],
Cell[81266, 2952, 100, 3, 21, "Output",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],
Cell[81381, 2958, 380, 7, 56, "Text",
  CellTags->"CompiledFunction::cfex"],

Cell[CellGroupData[{
Cell[81786, 2969, 109, 3, 26, "Input",
  CellTags->"CompiledFunction::cfex"],
Cell[81898, 2974, 126, 3, 21, "Output",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]],
Cell[82039, 2980, 120, 5, 24, "Text",
  CellTags->"CompiledFunction::cfex"],
Cell[82162, 2987, 104, 3, 26, "Input",
  CellTags->"CompiledFunction::cfex"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[82315, 2996, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfff"],
Cell[82415, 2999, 366, 9, 37, "Message",
  CellTags->"CompiledFunction::cfff"],
Cell[82784, 3010, 713, 18, 106, "Notes",
  CellTags->"CompiledFunction::cfff"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83534, 3033, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cffv"],
Cell[83634, 3036, 283, 6, 37, "Message",
  CellTags->"CompiledFunction::cffv"],
Cell[83920, 3044, 841, 20, 138, "Notes",
  CellTags->"CompiledFunction::cffv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84798, 3069, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfins"],
Cell[84900, 3072, 380, 8, 37, "Message",
  CellTags->"CompiledFunction::cfins"],
Cell[85283, 3082, 849, 19, 144, "Notes",
  CellTags->"CompiledFunction::cfins"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86169, 3106, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cflist"],
Cell[86273, 3109, 226, 4, 37, "Message",
  CellTags->"CompiledFunction::cflist"],
Cell[86502, 3115, 589, 11, 116, "Notes",
  CellTags->"CompiledFunction::cflist"],

Cell[CellGroupData[{
Cell[87116, 3130, 74, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cflist"],
Cell[87193, 3133, 148, 4, 24, "Text",
  CellTags->"CompiledFunction::cflist"],

Cell[CellGroupData[{
Cell[87366, 3141, 134, 3, 26, "Input",
  CellTags->"CompiledFunction::cflist"],
Cell[87503, 3146, 225, 5, 37, "Message",
  CellTags->"CompiledFunction::cflist"],
Cell[87731, 3153, 236, 5, 37, "Message",
  CellTags->"CompiledFunction::cflist"],
Cell[87970, 3160, 116, 3, 21, "Output",
  CellTags->"CompiledFunction::cflist"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[88147, 3170, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfn"],
Cell[88245, 3173, 401, 10, 37, "Message",
  CellTags->"CompiledFunction::cfn"],
Cell[88649, 3185, 335, 7, 62, "Notes",
  CellTags->"CompiledFunction::cfn"],

Cell[CellGroupData[{
Cell[89009, 3196, 71, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfn"],
Cell[89083, 3199, 166, 4, 40, "Text",
  CellTags->"CompiledFunction::cfn"],

Cell[CellGroupData[{
Cell[89274, 3207, 122, 3, 26, "Input",
  CellTags->"CompiledFunction::cfn"],
Cell[89399, 3212, 243, 5, 53, "Message",
  CellTags->"CompiledFunction::cfn"],
Cell[89645, 3219, 151, 3, 23, "Output",
  CellTags->"CompiledFunction::cfn"]
}, Open  ]],
Cell[89811, 3225, 227, 5, 40, "Text",
  CellTags->"CompiledFunction::cfn"],

Cell[CellGroupData[{
Cell[90063, 3234, 144, 3, 26, "Input",
  CellTags->"CompiledFunction::cfn"],
Cell[90210, 3239, 242, 5, 53, "Message",
  CellTags->"CompiledFunction::cfn"],
Cell[90455, 3246, 131, 3, 21, "Output",
  CellTags->"CompiledFunction::cfn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[90647, 3256, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfnlts"],
Cell[90751, 3259, 353, 7, 53, "Message",
  CellTags->"CompiledFunction::cfnlts"],
Cell[91107, 3268, 171, 4, 24, "Notes",
  CellTags->"CompiledFunction::cfnlts"],

Cell[CellGroupData[{
Cell[91303, 3276, 74, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfnlts"],
Cell[91380, 3279, 186, 4, 40, "Text",
  CellTags->"CompiledFunction::cfnlts"],

Cell[CellGroupData[{
Cell[91591, 3287, 133, 3, 26, "Input",
  CellTags->"CompiledFunction::cfnlts"],
Cell[91727, 3292, 258, 5, 53, "Message",
  CellTags->"CompiledFunction::cfnlts"],
Cell[91988, 3299, 100, 3, 21, "Output",
  CellTags->"CompiledFunction::cfnlts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[92149, 3309, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfnv"],
Cell[92249, 3312, 193, 3, 37, "Message",
  CellTags->"CompiledFunction::cfnv"],
Cell[92445, 3317, 725, 17, 122, "Notes",
  CellTags->"CompiledFunction::cfnv"],

Cell[CellGroupData[{
Cell[93195, 3338, 72, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfnv"],
Cell[93270, 3341, 205, 5, 40, "Text",
  CellTags->"CompiledFunction::cfnv"],

Cell[CellGroupData[{
Cell[93500, 3350, 119, 3, 26, "Input",
  CellTags->"CompiledFunction::cfnv"],
Cell[93622, 3355, 240, 5, 37, "Message",
  CellTags->"CompiledFunction::cfnv"],
Cell[93865, 3362, 240, 5, 37, "Message",
  CellTags->"CompiledFunction::cfnv"],
Cell[94108, 3369, 206, 4, 37, "Message",
  CellTags->"CompiledFunction::cfnv"],
Cell[94317, 3375, 189, 6, 21, "Output",
  CellTags->"CompiledFunction::cfnv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[94567, 3388, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfsa"],
Cell[94667, 3391, 198, 4, 37, "Message",
  CellTags->"CompiledFunction::cfsa"],
Cell[94868, 3397, 230, 5, 40, "Notes",
  CellTags->"CompiledFunction::cfsa"],

Cell[CellGroupData[{
Cell[95123, 3406, 72, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfsa"],
Cell[95198, 3409, 242, 5, 40, "Text",
  CellTags->"CompiledFunction::cfsa"],

Cell[CellGroupData[{
Cell[95465, 3418, 131, 3, 26, "Input",
  CellTags->"CompiledFunction::cfsa"],
Cell[95599, 3423, 186, 5, 21, "Output",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]],

Cell[CellGroupData[{
Cell[95822, 3433, 102, 3, 26, "Input",
  CellTags->"CompiledFunction::cfsa"],
Cell[95927, 3438, 237, 5, 37, "Message",
  CellTags->"CompiledFunction::cfsa"],
Cell[96167, 3445, 100, 3, 21, "Output",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]],
Cell[96282, 3451, 145, 4, 24, "Text",
  CellTags->"CompiledFunction::cfsa"],

Cell[CellGroupData[{
Cell[96452, 3459, 100, 3, 26, "Input",
  CellTags->"CompiledFunction::cfsa"],
Cell[96555, 3464, 97, 3, 21, "Output",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]],
Cell[96667, 3470, 120, 5, 24, "Text",
  CellTags->"CompiledFunction::cfsa"],
Cell[96790, 3477, 104, 3, 26, "Input",
  CellTags->"CompiledFunction::cfsa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[96943, 3486, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfse"],
Cell[97043, 3489, 193, 4, 21, "Message",
  CellTags->"CompiledFunction::cfse"],
Cell[97239, 3495, 364, 8, 62, "Notes",
  CellTags->"CompiledFunction::cfse"],

Cell[CellGroupData[{
Cell[97628, 3507, 72, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfse"],
Cell[97703, 3510, 196, 5, 40, "Text",
  CellTags->"CompiledFunction::cfse"],

Cell[CellGroupData[{
Cell[97924, 3519, 118, 3, 26, "Input",
  CellTags->"CompiledFunction::cfse"],
Cell[98045, 3524, 185, 5, 21, "Output",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],

Cell[CellGroupData[{
Cell[98267, 3534, 126, 3, 26, "Input",
  CellTags->"CompiledFunction::cfse"],
Cell[98396, 3539, 290, 6, 37, "Message",
  CellTags->"CompiledFunction::cfse"],
Cell[98689, 3547, 242, 5, 53, "Message",
  CellTags->"CompiledFunction::cfse"],
Cell[98934, 3554, 151, 3, 21, "Output",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],
Cell[99100, 3560, 191, 5, 24, "Text",
  CellTags->"CompiledFunction::cfse"],

Cell[CellGroupData[{
Cell[99316, 3569, 135, 3, 26, "Input",
  CellTags->"CompiledFunction::cfse"],
Cell[99454, 3574, 185, 5, 21, "Output",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99676, 3584, 126, 3, 26, "Input",
  CellTags->"CompiledFunction::cfse"],
Cell[99805, 3589, 151, 3, 21, "Output",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]],
Cell[99971, 3595, 120, 5, 24, "Text",
  CellTags->"CompiledFunction::cfse"],
Cell[100094, 3602, 104, 3, 26, "Input",
  CellTags->"CompiledFunction::cfse"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[100247, 3611, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfsec"],
Cell[100349, 3614, 209, 4, 37, "Message",
  CellTags->"CompiledFunction::cfsec"],
Cell[100561, 3620, 284, 6, 46, "Notes",
  CellTags->"CompiledFunction::cfsec"],

Cell[CellGroupData[{
Cell[100870, 3630, 73, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfsec"],
Cell[100946, 3633, 158, 4, 24, "Text",
  CellTags->"CompiledFunction::cfsec"],
Cell[101107, 3639, 202, 4, 42, "Input",
  CellTags->"CompiledFunction::cfsec"],
Cell[101312, 3645, 110, 3, 26, "Input",
  CellTags->"CompiledFunction::cfsec"],

Cell[CellGroupData[{
Cell[101447, 3652, 126, 3, 26, "Input",
  CellTags->"CompiledFunction::cfsec"],
Cell[101576, 3657, 245, 5, 37, "Message",
  CellTags->"CompiledFunction::cfsec"],
Cell[101824, 3664, 100, 3, 21, "Output",
  CellTags->"CompiledFunction::cfsec"]
}, Open  ]],
Cell[101939, 3670, 124, 5, 24, "Text",
  CellTags->"CompiledFunction::cfsec"],
Cell[102066, 3677, 108, 3, 26, "Input",
  CellTags->"CompiledFunction::cfsec"],
Cell[102177, 3682, 72, 1, 24, "Text",
  CellTags->"CompiledFunction::cfsec"],
Cell[102252, 3685, 203, 4, 42, "Input",
  CellTags->"CompiledFunction::cfsec"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[102504, 3695, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfta"],
Cell[102604, 3698, 220, 5, 37, "Message",
  CellTags->"CompiledFunction::cfta"],
Cell[102827, 3705, 237, 5, 40, "Notes",
  CellTags->"CompiledFunction::cfta"],

Cell[CellGroupData[{
Cell[103089, 3714, 72, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfta"],
Cell[103164, 3717, 226, 5, 40, "Text",
  CellTags->"CompiledFunction::cfta"],

Cell[CellGroupData[{
Cell[103415, 3726, 135, 3, 26, "Input",
  CellTags->"CompiledFunction::cfta"],
Cell[103553, 3731, 190, 5, 21, "Output",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]],

Cell[CellGroupData[{
Cell[103780, 3741, 102, 3, 26, "Input",
  CellTags->"CompiledFunction::cfta"],
Cell[103885, 3746, 265, 5, 53, "Message",
  CellTags->"CompiledFunction::cfta"],
Cell[104153, 3753, 97, 3, 21, "Output",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]],
Cell[104265, 3759, 145, 4, 24, "Text",
  CellTags->"CompiledFunction::cfta"],

Cell[CellGroupData[{
Cell[104435, 3767, 104, 3, 26, "Input",
  CellTags->"CompiledFunction::cfta"],
Cell[104542, 3772, 97, 3, 21, "Output",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]],
Cell[104654, 3778, 120, 5, 24, "Text",
  CellTags->"CompiledFunction::cfta"],
Cell[104777, 3785, 104, 3, 26, "Input",
  CellTags->"CompiledFunction::cfta"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104930, 3794, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfte"],
Cell[105030, 3797, 215, 5, 37, "Message",
  CellTags->"CompiledFunction::cfte"],
Cell[105248, 3804, 513, 11, 84, "Notes",
  CellTags->"CompiledFunction::cfte"],

Cell[CellGroupData[{
Cell[105786, 3819, 72, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cfte"],
Cell[105861, 3822, 210, 5, 40, "Text",
  CellTags->"CompiledFunction::cfte"],

Cell[CellGroupData[{
Cell[106096, 3831, 148, 3, 26, "Input",
  CellTags->"CompiledFunction::cfte"],
Cell[106247, 3836, 186, 5, 21, "Output",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]],

Cell[CellGroupData[{
Cell[106470, 3846, 108, 3, 26, "Input",
  CellTags->"CompiledFunction::cfte"],
Cell[106581, 3851, 253, 5, 53, "Message",
  CellTags->"CompiledFunction::cfte"],
Cell[106837, 3858, 242, 5, 53, "Message",
  CellTags->"CompiledFunction::cfte"],
Cell[107082, 3865, 109, 3, 21, "Output",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]],
Cell[107206, 3871, 171, 4, 40, "Text",
  CellTags->"CompiledFunction::cfte"],

Cell[CellGroupData[{
Cell[107402, 3879, 132, 3, 26, "Input",
  CellTags->"CompiledFunction::cfte"],
Cell[107537, 3884, 100, 3, 21, "Output",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]],
Cell[107652, 3890, 120, 5, 24, "Text",
  CellTags->"CompiledFunction::cfte"],
Cell[107775, 3897, 104, 3, 26, "Input",
  CellTags->"CompiledFunction::cfte"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[107928, 3906, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cftec"],
Cell[108030, 3909, 231, 5, 37, "Message",
  CellTags->"CompiledFunction::cftec"],
Cell[108264, 3916, 284, 6, 46, "Notes",
  CellTags->"CompiledFunction::cftec"],

Cell[CellGroupData[{
Cell[108573, 3926, 73, 1, 38, "ExampleSection",
  CellTags->"CompiledFunction::cftec"],
Cell[108649, 3929, 158, 4, 24, "Text",
  CellTags->"CompiledFunction::cftec"],
Cell[108810, 3935, 202, 4, 42, "Input",
  CellTags->"CompiledFunction::cftec"],
Cell[109015, 3941, 112, 3, 26, "Input",
  CellTags->"CompiledFunction::cftec"],

Cell[CellGroupData[{
Cell[109152, 3948, 141, 3, 26, "Input",
  CellTags->"CompiledFunction::cftec"],
Cell[109296, 3953, 271, 5, 53, "Message",
  CellTags->"CompiledFunction::cftec"],
Cell[109570, 3960, 102, 3, 21, "Output",
  CellTags->"CompiledFunction::cftec"]
}, Open  ]],
Cell[109687, 3966, 124, 5, 24, "Text",
  CellTags->"CompiledFunction::cftec"],
Cell[109814, 3973, 108, 3, 26, "Input",
  CellTags->"CompiledFunction::cftec"],
Cell[109925, 3978, 72, 1, 24, "Text",
  CellTags->"CompiledFunction::cftec"],
Cell[110000, 3981, 203, 4, 42, "Input",
  CellTags->"CompiledFunction::cftec"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[110252, 3991, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::cfver"],
Cell[110354, 3994, 207, 3, 37, "Message",
  CellTags->"CompiledFunction::cfver"],
Cell[110564, 3999, 789, 19, 116, "Notes",
  CellTags->"CompiledFunction::cfver"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111390, 4023, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::mldot"],
Cell[111492, 4026, 263, 4, 37, "Message",
  CellTags->"CompiledFunction::mldot"],
Cell[111758, 4032, 435, 12, 62, "Notes",
  CellTags->"CompiledFunction::mldot"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112230, 4049, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CompiledFunction::orank"],
Cell[112332, 4052, 314, 6, 69, "Message",
  CellTags->"CompiledFunction::orank"],
Cell[112649, 4060, 134, 4, 24, "Notes",
  CellTags->"CompiledFunction::orank"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

