(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    108764,       3821]*)
(*NotebookOutlinePosition[    262609,       7535]*)
(*  CellTagsIndexPosition[    256053,       7358]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["FindMinimum and FindRoot", "Title"],

Cell[CellGroupData[{

Cell["\<\
FindFit::bdmtd
FindMinimum::bdmtd
FindMaximum::bdmtd\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bdmtd\"\>"}], \(\(:\)\(\ \)\), "\<\"Value of option Method \
-> `1` is not Automatic, PrincipalAxis, Gradient, Newton, QuasiNewton, \
ConjugateGradient, or LevenbergMarquardt.\"\>"}]], "Message",
  CellLabel->"From In[22]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option in the indicated function is not among the expected values."
}], "Notes",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[TextData[{
  "An error occurs in this example because a number is not a valid value for \
the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["FindMinimum", "MR"],
  "."
}], "Text",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 10}, Method -> 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[BoxData[
    \(FindMinimum::"bdmtd" \(\(:\)\(\ \)\) 
      "Value of option Method -> \!\(0\) is not Automatic, PrincipalAxis, \
Gradient, Newton, QuasiNewton, ConjugateGradient, or LevenbergMarquardt."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 10}, Method \[Rule] 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["FindMinimum", "MR"],
  "."
}], "Text",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 10}, Method -> Newton]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 10.995574287564125`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::initf
FindMaximum::initf
FindFit::initf
NDSolve::initf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
    "NDSolve::initf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"initf\"\>"}], \(\(:\)\(\ \)\), \(The\ initialization\ of\ \
the\ method\ `1`\ \(\(failed\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
    "NDSolve::initf"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
    "NDSolve::initf"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fddis
FindMaximum::fddis
FindFit::fddis
FindRoot::fddis\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fddis\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "starting", " ", "values", " ", 
      StyleBox["x1",
        "TI"], " ", "and", " ", 
      StyleBox["x2",
        "TI"], " ", "are", " ", "not", " ", "sufficiently", " ", "distinct", 
      " ", "to", " ", "begin", " ", "a", 
      " ", \(\(search\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell["\<\
\[FilledSmallSquare] Generated when two starting values are given \
for a variable and the values are the same.\
\>", "Notes",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell["\<\
An error occurs in this example because the two starting values for \
the variable are the same.\
\>", "Text",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sin[x], {x, 10, 10}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[BoxData[
    \(FindRoot::"fddis" \(\(:\)\(\ \)\) 
      "The starting values \!\({10.`}\) and \!\({10.`}\) are not sufficiently \
distinct to begin a search."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
    "FindRoot::fddis"}],

Cell[BoxData[
    \(FindRoot[Sin[x], {x, 10, 10}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
    "FindRoot::fddis"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid starting values in ",
  StyleBox["FindRoot", "MR"],
  "."
}], "Text",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sin[x], {x, 10, 11}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[BoxData[
    \({x \[Rule] 9.42477796076938`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
    "FindRoot::fddis"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fdin
FindMaximum::fdin
FindFit::fdin
FindRoot::fdin\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fdin\"\>"}], \(\(:\)\(\ \)\), "Form", " ", "of", 
      " ", "start", " ", "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "inconsistent", " ", "with", " ", "other", " ",
       "start", " ", \(\(specifications\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell[TextData[{
  "\[FilledSmallSquare] Generated in multidimensional ",
  StyleBox["FindMinimum", "MR"],
  ", ",
  StyleBox["FindMaximum", "MR"],
  ", or ",
  StyleBox["FindRoot", "MR"],
  " when one starting value is specified for some of the variables and two \
starting values are specified for other variables.\n\[FilledSmallSquare] \
Different algorithms are used depending on whether the variables are \
specified with one starting value or with two starting values."
}], "Notes",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell["\<\
An error occurs in this example because the first variable is \
specified with one starting value and the second variable is specified with \
two starting values.\
\>", "Text",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x] + Sin[y], {x, 4}, {y, 8, 9}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell[BoxData[
    \(FindMinimum::"fdin" \(\(:\)\(\ \)\) 
      "Form of start specification \!\({x, 4}\) in \!\(FindMinimum[\(\(\(\(\(\
\(Sin[x]\)\) + \(\(Sin[y]\)\)\)\), \(\({x, 4}\)\), \(\({y, 8, 9}\)\)\)\)]\) \
is inconsistent with other start specifications."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", "FindRoot::fdin"}
    ],

Cell[BoxData[
    \(FindMinimum[Sin[x] + Sin[y], {x, 4}, {y, 8, 9}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", "FindRoot::fdin"}
    ]
}, Open  ]],

Cell[TextData[{
  "This shows valid start specifications in ",
  StyleBox["FindMinimum", "MR"],
  "."
}], "Text",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x\ ] + Sin[y], {x, 4, 5}, {y, 8, 9}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", "FindRoot::fdin"}
    ],

Cell[BoxData[
    \({\(-2.`\), {x \[Rule] 4.712388982594708`, 
        y \[Rule] 10.995574286903649`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", "FindRoot::fdin"}
    ]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindFit::fdss", "ObjectNameWarningMessages",
  CellTags->"FindFit::fdss"],

Cell[BoxData[
    \(FindFit::"fdss" \(\(:\)\(\ \)\) \(Search\ specification\ `1`\ should\ \
be\ a\ list\ with\ 1 - 5\ \(\(elements\)\(.\)\)\)\)], "Message",
  CellTags->"FindFit::fdss"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindFit::fdss"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fdss
FindMaximum::fdss
FindRoot::fdss\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"fdss\"\>"}], \(\(:\)\(\ \)\), "Search", " ", 
        "specification", " ", 
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "list", " ", "with",
         " ", "a", " ", "2"}], "-", \(5\ \(\(elements\)\(.\)\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell["\<\
\[FilledSmallSquare] Generated when the search specification in the \
indicated function does not have the expected form.\
\>", "Notes",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["FindRoot", "MR"],
  " does not have one of the expected forms."
}], "Text",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sin[x] + 1 == x, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[BoxData[
    \(FindRoot::"fdss" \(\(:\)\(\ \)\) 
      "Search specification \!\(x\) should be a list with a 2-5 \
elements."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],

Cell[BoxData[
    \(FindRoot[Sin[x] + 1 \[Equal] x, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid starting specification in ",
  StyleBox["FindRoot", "MR"],
  "."
}], "Text",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sin[x] + 1 == x, {x, 5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[BoxData[
    \({x \[Rule] 1.9345632107520243`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fmgl
FindMaximum::fmgl
FindFit::fmgl\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"fmgl\"\>"}], ":", " ", 
        RowBox[{"Gradient", " ", 
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "length", " ", 
          StyleBox["n",
            "TI"], " ", "list", " ", "of", " ", "real", " ", "numbers", " ", 
          "at", " ", 
          StyleBox["var",
            "TI"]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],

Cell["\<\
\[FilledSmallSquare] Generated when the gradient of the objective \
function is not a real number or a list of real numbers at the indicated \
point.
\[FilledSmallSquare] This error can usually be corrected by checking for \
singularities or non-numerical subexpressions in the derivatives of the \
objective function, or by choosing different starting values.\
\>", "Notes",
  CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::nzres
FindMaximum::nzres
FindFit::nzres\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nzres\"\>"}], \(\(:\)\(\ \)\), \(The\ step\ size\ for\ \
Method -> 
        LevenbergMarquardt\ has\ become\ nearly\ zero\ at\ working\ precision\
\ `1` . \ \ The\ residual\ appears\ to\ be\ nonzero, \ 
      which\ can\ lead\ to\ poor\ convergence\ of\ the\ method . \ \ It\ is\ \
recommended\ that\ you\ try\ Method -> \(Newton\ or\ Method -> 
          QuasiNewton\ for\ better\ \(\(convergence\)\(.\)\)\)\)}]], "Message",\

  CellTags->{"FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::sctl
FindMaximum::sctl
FindFit::sctl\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sctl\"\>"}], \(\(:\)\(\ \)\), \(The\ value\ of\ the\ \
option\ StepControl -> `1`\ is\ not\ one\ of\ Automatic, \ LineSearch, \ 
      TrustRegion, \ or\ \(\(None\)\(.\)\)\)}]], "Message",
  CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::sctl", "ObjectNameWarningMessages",
  CellTags->"FindRoot::sctl"],

Cell[BoxData[
    \(FindRoot::"sctl" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ \
StepControl -> `1`\ is\ not\ one\ of\ Automatic, \ LineSearch, \ 
      or\ \(\(None\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::sctl"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::sctl"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::lmtrst
FindMaximum::lmtrst
FindFit::lmtrst\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lmtrst\"\>"}], \(\(:\)\(\ \)\), \(The\ Levenberg\ \
Marquardt\ method\ is\ a\ trust\ region\ method . \ \ The\ value\ of\ \
StepControl -> `1`\ will\ be\ \(\(ignored\)\(.\)\)\)}]], "Message",
  CellTags->{"FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::lmotrst
FindMaximum::lmotrst
FindFit::lmotrst\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lmotrst\"\>"}], \(\(:\)\(\ \)\), \(The\ Levenberg\ \
Marquardt\ method\ is\ currently\ the\ only\ trust\ region\ method . \ \ The\ \
value\ of\ StepControl -> `1`\ will\ be\ \(\(ignored\)\(.\)\)\)}]], "Message",\

  CellTags->{
  "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindFit::sdprec
FindMinimum::sdprec\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sdprec\"\>"}], \(\(:\)\(\ \)\), \(Line\ search\ unable\ to\
\ find\ a\ sufficient\ decrease\ in\ the\ function\ value\ with\ `1`\ digit\ \
\(\(precision\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::sdprec", "ObjectNameWarningMessages",
  CellTags->"FindRoot::sdprec"],

Cell[BoxData[
    \(FindRoot::"sdprec" \(\(:\)\(\ \)\) \(Line\ search\ unable\ to\ find\ a\ \
sufficient\ decrease\ in\ the\ merit\ function\ value\ with\ `1`\ digit\ \
\(\(precision\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::sdprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::sdprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMinimum::lstol", "ObjectNameWarningMessages",
  CellTags->"FindMinimum::lstol"],

Cell[BoxData[
    \(FindMinimum::"lstol" \(\(:\)\(\ \)\) \(The\ line\ search\ decreased\ \
the\ step\ size\ to\ within\ tolerance\ specified\ by\ AccuracyGoal\ and\ \
PrecisionGoal\ but\ was\ unable\ to\ find\ a\ sufficient\ decrease\ in\ the\ \
function . \ \ You\ may\ need\ more\ than\ `1`\ digits\ of\ working\ \
precision\ to\ meet\ these\ \(\(tolerances\)\(.\)\)\)\)], "Message",
  CellTags->"FindMinimum::lstol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the tolerances specified through the \
",
  StyleBox["AccuracyGoal", "MR"],
  " or ",
  StyleBox["PrecisionGoal", "MR"],
  " options cannot be reached using the indicated working precision.\n\
\[FilledSmallSquare] This message can be generated if the objective function \
is singular or has other sharp features."
}], "Notes",
  CellTags->"FindMinimum::lstol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FindMinimum::lstol"],

Cell["\<\
A warning message is generated in this example because the \
objective function does not have a smooth minimum.\
\>", "Text",
  CellTags->"FindMinimum::lstol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Abs[Sin[x]], {x, 6}, 
      Gradient -> {Sign[Sin[x]]\ Cos[x]}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FindMinimum::lstol"],

Cell[BoxData[
    \(FindMinimum::"lstol" \(\(:\)\(\ \)\) 
      "The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the function.  You may need more than \!\(MachinePrecision\) \
digits of working precision to meet these tolerances."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FindMinimum::lstol"],

Cell[BoxData[
    \({5.084141158371281`*^-15, {x \[Rule] 6.283185307179592`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FindMinimum::lstol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindFit::lstol", "ObjectNameWarningMessages",
  CellTags->"FindFit::lstol"],

Cell[BoxData[
    \(FindFit::"lstol" \(\(:\)\(\ \)\) \(The\ line\ search\ decreased\ the\ \
step\ size\ to\ within\ tolerance\ specified\ by\ AccuracyGoal\ and\ \
PrecisionGoal\ but\ was\ unable\ to\ find\ a\ sufficient\ decrease\ in\ the\ \
norm\ of\ the\ residual . \ \ You\ may\ need\ more\ than\ `1`\ digits\ of\ \
working\ precision\ to\ meet\ these\ \(\(tolerances\)\(.\)\)\)\)], "Message",
  CellTags->"FindFit::lstol"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindFit::lstol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::lstol", "ObjectNameWarningMessages",
  CellTags->"FindRoot::lstol"],

Cell[BoxData[
    \(FindRoot::"lstol" \(\(:\)\(\ \)\) \(The\ line\ search\ decreased\ the\ \
step\ size\ to\ within\ tolerance\ specified\ by\ AccuracyGoal\ and\ \
PrecisionGoal\ but\ was\ unable\ to\ find\ a\ sufficient\ decrease\ in\ the\ \
merit\ function . \ \ You\ may\ need\ more\ than\ `1`\ digits\ of\ working\ \
precision\ to\ meet\ these\ \(\(tolerances\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::lstol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the algorithm used by ",
  StyleBox["FindRoot", "MR"],
  " does not find a root within the indicated number of iterations.\n\
\[FilledSmallSquare] If a root exists, this error can often be corrected by \
giving better starting values, or by changing the values of the ",
  StyleBox["AccuracyGoal", "MR"],
  " or ",
  StyleBox["MaxIterations", "MR"],
  " options."
}], "Notes",
  CellTags->"FindRoot::lstol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FindRoot::lstol"],

Cell["\<\
An error occurs in this example because the objective function does \
not have a real root.\
\>", "Text",
  CellTags->"FindRoot::lstol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 + x + 1, {x, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FindRoot::lstol"],

Cell[BoxData[
    \(FindRoot::"lstol" \(\(:\)\(\ \)\) 
      "The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function.  You may need more than \
\!\(MachinePrecision\) digits of working precision to meet these tolerances."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FindRoot::lstol"],

Cell[BoxData[
    \({x \[Rule] \(-0.49999999385432176`\)}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FindRoot::lstol"]
}, Open  ]],

Cell["\<\
The complex roots can be found by using complex starting \
values.\
\>", "Text",
  CellTags->"FindRoot::lstol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 + x + 1, {x, I}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FindRoot::lstol"],

Cell[BoxData[
    \({x \[Rule] \(-0.5`\) + 0.8660254037844386`\ \[ImaginaryI]}\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->"FindRoot::lstol"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 + x + 1, {x, \(-I\)}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"FindRoot::lstol"],

Cell[BoxData[
    \({x \[Rule] \(-0.5`\) - 0.8660254037844386`\ \[ImaginaryI]}\)], "Output",\

  CellLabel->"Out[3]=",
  CellTags->"FindRoot::lstol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMinimum::lsbrak", "ObjectNameWarningMessages",
  CellTags->"FindMinimum::lsbrak"],

Cell[BoxData[
    \(FindMinimum::"lsbrak" \(\(:\)\(\ \)\) \(Unable\ to\ bracket\ a\ minimum\
\ along\ the\ direction\ `2`\ from\ the\ point\ \(\(`1`\)\(.\)\)\)\)], \
"Message",
  CellTags->"FindMinimum::lsbrak"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindMinimum::lsbrak"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindRoot::btf
FindMinimum::btf
FindMaximum::btf
FindFit::btf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", "FindFit::btf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"btf\"\>"}], \(\(:\)\(\ \)\), \(The\ value\ of\ the\ option\
\ BacktrackingFactors -> `1`\ should\ be\ a\ list\ {amin, \ 
              amax}\ with\ 0\  < \ amin\  <= \ amax\  < \ 1. \)}]], "Message",\

  CellTags->{
  "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", "FindFit::btf"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", "FindFit::btf"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::bddir
FindFit::bddir\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bddir\"\>"}], \(\(:\)\(\ \)\), \(The\ search\ direction\ \
`1`\ is\ not\ a\ descent\ direction\ for\ the\ function . \ \ Typically\ this\
\ occurs\ when\ the\ function\ is\ not\ smooth\ or\ the\ values\ of\ the\ \
function\ are\ much\ less\ accurate\ than\ the\ \(\(WorkingPrecision\)\(.\)\)\
\)}]], "Message",
  CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindMinimum::bddir", "FindFit::bddir"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMaximum::bddir", "ObjectNameWarningMessages",
  CellTags->"FindMaximum::bddir"],

Cell[BoxData[
    \(FindMaximum::"bddir" \(\(:\)\(\ \)\) \(The\ search\ direction\ `1`\ is\ \
not\ a\ ascent\ direction\ for\ the\ function . \ \ Typically\ this\ occurs\ \
when\ the\ function\ is\ not\ smooth\ or\ the\ values\ of\ the\ function\ are\
\ much\ less\ accurate\ than\ the\ \(\(WorkingPrecision\)\(.\)\)\)\)], \
"Message",
  CellTags->"FindMaximum::bddir"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindMaximum::bddir"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::bddir", "ObjectNameWarningMessages",
  CellTags->"FindRoot::bddir"],

Cell[BoxData[
    \(FindRoot::"bddir" \(\(:\)\(\ \)\) \(The\ search\ direction\ `1`\ is\ \
not\ a\ descent\ direction\ for\ the\ merit\ function . \ 
          The\ step\ will\ be\ taken\ without\ the\ line\ \(\(search\)\(.\)\)\
\)\)], "Message",
  CellTags->"FindRoot::bddir"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::bddir"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMaximum::fmgz", "ObjectNameWarningMessages",
  CellTags->"FindMaximum::fmgz"],

Cell[BoxData[
    \(FindMaximum::"fmgz" \(\(:\)\(\ \)\) 
      "Encountered a gradient which is effectively zero. The result returned \
may not be a maximum; it may be a minimum or a saddle point."\)], "Message",
  CellLabel->"From In[141]:=",
  CellTags->"FindMaximum::fmgz"],

Cell["\<\
\[FilledSmallSquare] Generated when the gradient of the objective \
function is zero to within numerical error at a point that is checked by the \
algorithm.
\[FilledSmallSquare] If the function has a maximum, this error can often be \
corrected by choosing different starting values, or by giving two starting \
values for each variable.\
\>", "Notes",
  CellTags->"FindMaximum::fmgz"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FindMaximum::fmgz"],

Cell["\<\
An error occurs in this example because the starting point \
corresponds to a saddle point.\
\>", "Text",
  CellTags->"FindMaximum::fmgz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMaximum[1 - x^2 + y^2 - y^4, {x, 0}, {y, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FindMaximum::fmgz"],

Cell[BoxData[
    \(FindMaximum::"fmgz" \(\(:\)\(\ \)\) 
      "Encountered a gradient which is effectively zero. The result returned \
may not be a maximum; it may be a minimum or a saddle point."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FindMaximum::fmgz"],

Cell[BoxData[
    \({1.`, {x \[Rule] 0.`, y \[Rule] 0.`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FindMaximum::fmgz"]
}, Open  ]],

Cell["\<\
The maximum is computed without difficulty if different starting \
values are used.\
\>", "Text",
  CellTags->"FindMaximum::fmgz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMaximum[1 - x^2 + y^2 - y^4, {x, 0}, {y, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FindMaximum::fmgz"],

Cell[BoxData[
    \({1.25`, {x \[Rule] 0.`, y \[Rule] 0.7071067811869867`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FindMaximum::fmgz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMinimum::fmgz", "ObjectNameWarningMessages",
  CellTags->"FindMinimum::fmgz"],

Cell[BoxData[
    \(FindMinimum::"fmgz" \(\(:\)\(\ \)\) 
      "Encountered a gradient which is effectively zero. The result returned \
may not be a minimum; it may be a maximum or a saddle point."\)], "Message",
  CellLabel->"From In[143]:=",
  CellTags->"FindMinimum::fmgz"],

Cell["\<\
\[FilledSmallSquare] Generated when the gradient of the objective \
function is zero to within numerical error at a point that is checked by the \
algorithm.
\[FilledSmallSquare] If the function has a minimum, this error can often be \
corrected by choosing different starting values, or by giving two starting \
values for each variable.\
\>", "Notes",
  CellTags->"FindMinimum::fmgz"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FindMinimum::fmgz"],

Cell["\<\
An error occurs in this example because the starting point \
corresponds to a saddle point.\
\>", "Text",
  CellTags->"FindMinimum::fmgz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[1 + x^2 - y^2 + y^4, {x, 0}, {y, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FindMinimum::fmgz"],

Cell[BoxData[
    \(FindMinimum::"fmgz" \(\(:\)\(\ \)\) 
      "Encountered a gradient which is effectively zero. The result returned \
may not be a minimum; it may be a maximum or a saddle point."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FindMinimum::fmgz"],

Cell[BoxData[
    \({1.`, {x \[Rule] 0.`, y \[Rule] 0.`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FindMinimum::fmgz"]
}, Open  ]],

Cell["\<\
The minimum is computed without difficulty if different starting \
values are used.\
\>", "Text",
  CellTags->"FindMinimum::fmgz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[1 + x^2 - y^2 + y^4, {x, 0}, {y, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FindMinimum::fmgz"],

Cell[BoxData[
    \({0.75`, {x \[Rule] 0.`, y \[Rule] 0.7071067811869867`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FindMinimum::fmgz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fmmp
FindMaximum::fmmp
FindFit::fmmp\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fmmp\"\>"}], \(\(:\)\(\ \)\), \(Machine\ precision\ is\ \
insufficient\ to\ achieve\ the\ requested\ accuracy\ or\ \(\(precision\)\(.\)\
\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the tolerances specified by the ",
  StyleBox["PrecisionGoal", "MR"],
  " and ",
  StyleBox["AccuracyGoal", "MR"],
  " options cannot be reached using machine arithmetic.\n\[FilledSmallSquare] \
This message is not normally used in current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  If you see this message in a situation in which it is not expected, \
please contact Technical Support."
}], "Notes",
  CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindRoot::fdst
FindMinimum::fdst
FindMaximum::fdst
FindFit::fdst\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", "FindFit::fdst"}
    ],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fdst\"\>"}], \(\(:\)\(\ \)\), "\<\"Expression `1` in `2` \
is not a valid start specification; a number or pair of numbers is \
expected.\"\>"}]], "Message",
  CellLabel->"From In[22]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "FindFit::fdst", "FindMaximum::fdst", "FindMinimum::fdst", "FindRoot::fdst"}
    ],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the start specification in the \
indicated argument of the indicated function is not a number or a pair of \
numbers.\n\[FilledSmallSquare] Search specifications can be of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["0}", "MR"],
  ", ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["0, ", "MR"],
  StyleBox["x", "TI"],
  StyleBox["1}", "MR"],
  ", or ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["xstart", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["xmin", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["xmax", "TI"],
  StyleBox["}", "MR"],
  "."
}], "Notes",
  CellTags->{
  "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", "FindFit::fdst"}
    ]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::frdig", "ObjectNameWarningMessages",
  CellTags->"FindRoot::frdig"],

Cell[BoxData[
    RowBox[{\(FindRoot::"frdig"\), ":", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], " ", "working", " ", "digits", " ", "is", " ", 
        "insufficient", " ", "to", " ", "achieve", " ", "the", " ", 
        "absolute", " ", "tolerance", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FindRoot::frdig"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the specified accuracy cannot be \
reached using the indicated working precision.\n\[FilledSmallSquare] Absolute \
tolerance is specified using the ",
  StyleBox["AccuracyGoal", "MR"],
  " option, and the number of digits of working precision is specified using \
the ",
  StyleBox["WorkingPrecision", "MR"],
  " option.\n\[FilledSmallSquare] This message is not normally used in \
current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  If you see this message in a situation in which it is not expected, \
please contact Technical Support."
}], "Notes",
  CellTags->"FindRoot::frdig"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::frmp", "ObjectNameWarningMessages",
  CellTags->"FindRoot::frmp"],

Cell[BoxData[
    RowBox[{\(FindRoot::"frmp"\), \(\(:\)\(\ \)\), \(\(Machine\)\(\ \
\)\(precision\)\(\ \)\(is\)\(\ \)\(insufficient\)\(\ \)\(to\)\(\ \
\)\(achieve\)\(\ \)\(the\)\(\ \)\(accuracy\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"FindRoot::frmp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["AccuracyGoal", "MR"],
  " option is too large to be reached using machine precision.\n\
\[FilledSmallSquare] This error can usually be corrected by raising the value \
of the ",
  StyleBox["WorkingPrecision", "MR"],
  " option, lowering the value of the ",
  StyleBox["AccuracyGoal", "MR"],
  " option, or using better starting values.\n\[FilledSmallSquare] In \
high-precision calculations, the precision of any numbers in the input should \
be as high or higher than the value of the ",
  StyleBox["WorkingPrecision", "MR"],
  " option."
}], "Notes",
  CellTags->"FindRoot::frmp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::jsing", "ObjectNameWarningMessages",
  CellTags->"FindRoot::jsing"],

Cell[BoxData[
    \(FindRoot::"jsing" \(\(:\)\(\ \)\) 
      "Encountered a singular Jacobian at the point `1` = `2`. Try perturbing \
the initial point(s)."\)], "Message",
  CellLabel->"From In[23]:=",
  CellTags->"FindRoot::jsing"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the derivatives of the first argument \
in ",
  StyleBox["FindRoot", "MR"],
  " are singular at the indicated point.\n\[FilledSmallSquare] This error can \
occur if the starting point is a minimum or a maximum of one of the functions \
for which roots are to be computed."
}], "Notes",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FindRoot::jsing"],

Cell["\<\
An error occurs in this example because the starting point is a \
minimum of the function in the first argument.\
\>", "Text",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 - 3 == 0, {x, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FindRoot::jsing"],

Cell[BoxData[
    \(FindRoot::"jsing" \(\(:\)\(\ \)\) 
      "Encountered a singular Jacobian at the point \!\({x}\) = \!\({0.`}\). \
Try perturbing the initial point(s)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FindRoot::jsing"],

Cell[BoxData[
    \({x \[Rule] 0.`}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FindRoot::jsing"]
}, Open  ]],

Cell["\<\
A root is found without difficulty if a different starting value is \
used.\
\>", "Text",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 - 3 == 0, {x, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FindRoot::jsing"],

Cell[BoxData[
    \({x \[Rule] 1.7320508075688772`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FindRoot::jsing"]
}, Open  ]],

Cell["\<\
This error can also occur if the first argument is constant.  The \
function in this example does not have a root.\
\>", "Text",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[1, {x, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"FindRoot::jsing"],

Cell[BoxData[
    \(FindRoot::"jsing" \(\(:\)\(\ \)\) 
      "Encountered a singular Jacobian at the point \!\({x}\) = \!\({1.`}\). \
Try perturbing the initial point(s)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"FindRoot::jsing"],

Cell[BoxData[
    \({x \[Rule] 1.`}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"FindRoot::jsing"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::lss
FindMaximum::lss
FindRoot::lss\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lss\"\>"}], \(\(:\)\(\ \)\), \(`1`\ should\ be\ a\ \
nonempty\ list\ of\ search\ specifications, \ 
      each\ consisting\ of\ a\ variable\ and\ starting\ \
\(\(values\)\(.\)\)\)}]], "Message",
  CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindFit::lss", "ObjectNameWarningMessages",
  CellTags->"FindFit::lss"],

Cell[BoxData[
    \(FindFit::"lss" \(\(:\)\(\ \)\) \(`1`\ should\ be\ a\ nonempty\ list\ of\
\ search\ specifications, \ 
      each\ consisting\ of\ a\ variable\ and\ possibly\ starting\ \
\(\(values\)\(.\)\)\)\)], "Message",
  CellTags->"FindFit::lss"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindFit::lss"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindFit::precw", "ObjectNameWarningMessages",
  CellTags->"FindFit::precw"],

Cell[BoxData[
    \(FindFit::"precw" \(\(:\)\(\ \)\) \(The\ precision\ of\ the\ data\ and\ \
model\ function\ \((`1`)\)\ is\ less\ than\ the\ specified\ WorkingPrecision\ \
\(\((`2`)\)\(.\)\)\)\)], "Message",
  CellTags->"FindFit::precw"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindFit::precw"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::srect
FindMaximum::srect
FindFit::srect
FindRoot::srect\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"srect\"\>"}], \(\(:\)\(\ \)\), \(Value\ `1`\ in\ search\ \
specification\ `2`\ is\ not\ a\ number\ or\ array\ of\ \
\(\(numbers\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the search specification in the \
indicated function does not have the required form.\n\[FilledSmallSquare] The \
search specification is the second argument in ",
  StyleBox["FindMinimum", "MR"],
  ", ",
  StyleBox["FindMaximum", "MR"],
  ", and ",
  StyleBox["FindRoot", "MR"],
  ", and the third argument in ",
  StyleBox["FindFit", "MR"],
  ".\n\[FilledSmallSquare] This error can often be corrected by verifying \
that any parameters or symbolic expressions used to specify starting values \
evaluate to numbers."
}], "Notes",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell["\<\
An error occurs in this example if the indicated starting value \
does not evaluate to a number.\
\>", "Text",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, x0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[BoxData[
    \(FindMinimum::"srect" \(\(:\)\(\ \)\) 
      "Value \!\(x0\) in search specification \!\({x, x0}\) is not a number \
or array of numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
    "FindRoot::srect"}],

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, x0}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
    "FindRoot::srect"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid specification of a starting value in ",
  StyleBox["FindMinimum", "MR"],
  "."
}], "Text",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x0 = 6}, FindMinimum[Sin[x], {x, x0}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 4.712388979746753`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
    "FindRoot::srect"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::scdims
FindMaximum::scdims
FindFit::scdims
FindRoot::scdims\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
    "FindRoot::scdims"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"scdims\"\>"}], \(\(:\)\(\ \)\), \(Values\ given\ in\ \
search\ specification\ `1`\ do\ not\ have\ consistent\ \
\(\(dimensions\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
    "FindRoot::scdims"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
    "FindRoot::scdims"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::snum
FindMaximum::snum
FindFit::snum
FindRoot::snum\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", "FindRoot::snum"}
    ],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"snum\"\>"}], \(\(:\)\(\ \)\), \(Value\ `1`\ in\ search\ \
specification\ `2`\ is\ not\ a\ \(\(number\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", "FindRoot::snum"}
    ],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", "FindRoot::snum"}
    ]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fdssnv
FindMaximum::fdssnv
FindRoot::fdssnv
FindFit::fdssnv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
    "FindFit::fdssnv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fdssnv\"\>"}], \(\(:\)\(\ \)\), \(Search\ specification\ \
`1`\ without\ variables\ should\ be\ a\ list\ with\ a\ 1 - 
        4\ \(\(elements\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
    "FindFit::fdssnv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
    "FindFit::fdssnv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::bbound
FindMaximum::bbound
FindFit::bbound
FindRoot::bbound\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bbound\"\>"}], \(\(:\)\(\ \)\), \(Search\ region\ bound\ \
`1`\ for\ variable\ number\ `2`\ is\ not\ a\ number\ or\ \
\(\(Infinity\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression that is not a number is \
encountered in a position where the specification for the limits of the \
search region is expected.\n\[FilledSmallSquare] The search specification is \
the second argument in ",
  StyleBox["FindMinimum", "MR"],
  ", ",
  StyleBox["FindMaximum", "MR"],
  ", and ",
  StyleBox["FindRoot", "MR"],
  ", and the third argument in ",
  StyleBox["FindFit", "MR"],
  "."
}], "Notes",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell["\<\
An error occurs in this example because one of the limits on the \
search region is not a number.\
\>", "Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 6, 4, x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[BoxData[
    \(FindMinimum::"bbound" \(\(:\)\(\ \)\) 
      "Search region bound \!\(x\) for variable number \!\(1\) is not a \
number or Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}],

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 6, 4, x}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid specification of limits on the search region in ",
  StyleBox["FindMinimum", "MR"],
  ". "
}], "Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 6, 4, 7}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 4.712388980281893`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]],

Cell["\<\
An error occurs in this example because the variables used to \
specify the limits on the search region do not have numerical values.\
\>", \
"Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[3\ Sin[x] == 1, {x, 6, xmin, xmax}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[BoxData[
    \(FindRoot::"bbound" \(\(:\)\(\ \)\) 
      "Search region bound \!\(xmin\) for variable number \!\(1\) is not a \
number or Infinity."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}],

Cell[BoxData[
    \(FindRoot[3\ Sin[x] \[Equal] 1, {x, 6, xmin, xmax}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]],

Cell["\<\
A root is computed if numerical values are assigned for the \
symbolic parameters.\
\>", "Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{xmin = 4, xmax = 8}, 
      FindRoot[3\ Sin[x] == 1, {x, 6, xmin, xmax}]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[BoxData[
    \({x \[Rule] 6.623022216633708`}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::linf
FindMaximum::linf
FindFit::linf
FindRoot::linf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", "FindRoot::linf"}
    ],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"linf\"\>"}], \(\(:\)\(\ \)\), \(Lower\ bound\ for\ search\ \
region\ for\ variable\ number\ `1`\ is\ Infinity, \ 
      leaving\ no\ values\ in\ the\ \(\(region\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", "FindRoot::linf"}
    ],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", "FindRoot::linf"}
    ]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::uinf
FindMaximum::uinf
FindFit::uinf
FindRoot::uinf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", "FindRoot::uinf"}
    ],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"uinf\"\>"}], \(\(:\)\(\ \)\), \(Upper\ bound\ for\ search\ \
region\ for\ variable\ number\ `1`\ is\  - Infinity, \ 
      leaving\ no\ values\ in\ the\ \(\(region\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", "FindRoot::uinf"}
    ],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", "FindRoot::uinf"}
    ]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::cvmit
FindMaximum::cvmit
FindFit::cvmit
FindRoot::cvmit\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cvmit\"\>"}], \(\(:\)\(\ \)\), \(Failed\ to\ converge\ to\ \
the\ requested\ accuracy\ or\ precision\ within\ `1`\ \(\(iterations\)\(.\)\)\
\)}]], "Message",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated limit on the \
number of iterations is reached before finding a region that contain the \
requested result.
\[FilledSmallSquare] This error can occur if the objective function does not \
have the required minimum, maximum, or root.
\[FilledSmallSquare] This error can often be corrected by choosing better \
starting values.
\[FilledSmallSquare] Good starting values can often be chosen by evaluating \
the function at selected points, or by looking at a plot of the \
function.\
\>", "Notes",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell["\<\
An error occurs in this example because the starting value is not \
near the local minimum of this function.\
\>", "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[1/x - 2  Exp[\(-x\)], {x, 5}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \(FindMinimum::"cvmit" \(\(:\)\(\ \)\) 
      "Failed to converge to the requested accuracy or precision within \
\!\(100\) iterations."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \({6.028039469000428`*^-14, {x \[Rule] 
          1.6589141546643197`*^13}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],

Cell["\<\
A minimum is computed without difficulty if the starting value is \
closer to the solution.\
\>", "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[1/x - 2  Exp[\(-x\)], {x, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \({0.22039530684791164`, {x \[Rule] 1.48796206549405`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],

Cell["A plot of the function shows the location of the minimum.", "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[1/x - 2  Exp[\(-x\)], {x, 1, 5}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["FindRoot", "MR"],
  " does not have a real root."
}], "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 + x + 1, {x, 4, 10}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \(FindRoot::"cvmit" \(\(:\)\(\ \)\) 
      "Failed to converge to the requested accuracy or precision within \
\!\(100\) iterations."\)], "Message",
  CellLabel->"From In[4]:=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \({x \[Rule] 131640.64090509777`}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],

Cell["\<\
A complex root of this equation can be computed by giving complex \
starting values.\
\>", "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 + x + 1, {x, 0, I}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \({x \[Rule] \(-0.49999999999999994`\) + 
          0.8660254037844386`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[x^2 + x + 1, {x, 0, \(-I\)}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \({x \[Rule] \(-0.49999999999999994`\) - 
          0.8660254037844386`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["FindMinimum", "MR"],
  " does not have a minimum."
}], "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[x, {x, 1}]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \(FindMinimum::"cvmit" \(\(:\)\(\ \)\) 
      "Failed to converge to the requested accuracy or precision within \
\!\(100\) iterations."\)], "Message",
  CellLabel->"From In[7]:=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}],

Cell[BoxData[
    \({\(-994999.`\), {x \[Rule] \(-994999.`\)}}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMaximum::sdprec", "ObjectNameWarningMessages",
  CellTags->"FindMaximum::sdprec"],

Cell[BoxData[
    \(FindMaximum::"sdprec" \(\(:\)\(\ \)\) \(Line\ search\ unable\ to\ find\ \
a\ sufficient\ increase\ in\ the\ function\ value\ with\ `1`\ digit\ \
\(\(precision\)\(.\)\)\)\)], "Message",
  CellTags->"FindMaximum::sdprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindMaximum::sdprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMaximum::lstol", "ObjectNameWarningMessages",
  CellTags->"FindMaximum::lstol"],

Cell[BoxData[
    \(FindMaximum::"lstol" \(\(:\)\(\ \)\) \(The\ line\ search\ decreased\ \
the\ step\ size\ to\ within\ tolerance\ specified\ by\ AccuracyGoal\ and\ \
PrecisionGoal\ but\ was\ unable\ to\ find\ a\ sufficient\ increase\ in\ the\ \
function . \ \ You\ may\ need\ more\ than\ `1`\ digits\ of\ working\ \
precision\ to\ meet\ these\ \(\(tolerances\)\(.\)\)\)\)], "Message",
  CellTags->"FindMaximum::lstol"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindMaximum::lstol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMaximum::lsbrak", "ObjectNameWarningMessages",
  CellTags->"FindMaximum::lsbrak"],

Cell[BoxData[
    \(FindMaximum::"lsbrak" \(\(:\)\(\ \)\) \(Unable\ to\ bracket\ a\ maximum\
\ along\ the\ direction\ `2`\ from\ the\ point\ \(\(`1`\)\(.\)\)\)\)], \
"Message",
  CellTags->"FindMaximum::lsbrak"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindMaximum::lsbrak"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::prax2
FindMaximum::prax2
FindFit::prax2\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"prax2\"\>"}], \(\(:\)\(\ \)\), \(Method -> 
        PrincipalAxis\ requires\ two\ starting\ values\ in\ each\ \
\(\(variable\)\(.\)\)\)}]], "Message",
  CellTags->{"FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::regex1
FindMaximum::regex1
FindFit::regex1
FindRoot::regex1\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
    "FindRoot::regex1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"regex1\"\>"}], \(\(:\)\(\ \)\), "\<\"Reached the point `1` \
which has component `2` equal to `3` which is outside the range `4`.\"\>"}]], \
"Message",
  CellLabel->"From In[30]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
    "FindRoot::regex1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the algorithm used by the indicated \
function reaches a point that is outside of the region specified in the \
input.\n\[FilledSmallSquare] Limits can be specified for a search region by \
using a limit specification of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xstart", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xmin", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xmax", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  "."
}], "Notes",
  CellTags->{
  "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
    "FindRoot::regex1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::reged
FindMaximum::reged
FindFit::reged
FindRoot::reged\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"reged\"\>"}], \(\(:\)\(\ \)\), \(The\ point\ `1`\ is\ at\ \
the\ edge\ of\ the\ search\ region\ `3`\ in\ coordinate\ `2`\ and\ the\ \
computed\ search\ direction\ points\ outside\ the\ \(\(region\)\(.\)\)\)}]], \
"Message",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated function does not find a \
solution within the specified search region.\n\[FilledSmallSquare] The search \
region is specified in the second argument of ",
  StyleBox["FindMinimum", "MR"],
  ", ",
  StyleBox["FindMaximum", "MR"],
  ", or ",
  StyleBox["FindRoot", "MR"],
  ", and in the third argument of ",
  StyleBox["FindFit", "MR"],
  "."
}], "Notes",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell["\<\
A warning message is generated in this example because the search \
reaches a point outside the search region.\
\>", "Text",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 6, 5, 7}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[BoxData[
    \(FindMinimum::"reged" \(\(:\)\(\ \)\) 
      "The point \!\({5.`}\) is at the edge of the search region \!\({5.`, \
7.`}\) in coordinate \!\(1\) and the computed search direction points outside \
the region."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
    "FindRoot::reged"}],

Cell[BoxData[
    \({\(-0.9589242746631385`\), {x \[Rule] 5.`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
    "FindRoot::reged"}]
}, Open  ]],

Cell["\<\
A minimum is computed without difficulty if the search region is \
expanded to include a minimum.\
\>", "Text",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 6, 4, 7}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 4.712388980281893`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
    "FindRoot::reged"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::streg
FindMaximum::streg
FindFit::streg
FindRoot::streg\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
    "FindRoot::streg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"streg\"\>"}], \(\(:\)\(\ \)\), \(The\ starting\ point\ `1`\
\ is\ not\ in\ the\ search\ region\ \(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
    "FindRoot::streg"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
    "FindRoot::streg"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindFit::sszero
FindMinimum::sszero\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sszero\"\>"}], \(\(:\)\(\ \)\), \(The\ step\ size\ in\ the\
\ search\ has\ become\ less\ than\ the\ tolerance\ prescribed\ by\ the\ \
PrecisionGoal\ option, \ 
      but\ the\ gradient\ is\ larger\ than\ the\ tolerance\ specified\ by\ \
the\ AccuracyGoal\ option . \ 
          There\ is\ a\ possibility\ that\ the\ method\ has\ stalled\ at\ a\ \
point\ which\ is\ not\ a\ local\ \(\(minimum\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindFit::sszero", "FindMinimum::sszero"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMaximum::sszero", "ObjectNameWarningMessages",
  CellTags->"FindMaximum::sszero"],

Cell[BoxData[
    \(FindMaximum::"sszero" \(\(:\)\(\ \)\) \(The\ step\ size\ in\ the\ \
search\ has\ become\ less\ than\ the\ tolerance\ prescribed\ by\ the\ \
PrecisionGoal\ option, \ 
      but\ the\ gradient\ is\ larger\ than\ the\ tolerance\ specified\ by\ \
the\ AccuracyGoal\ option . \ 
          There\ is\ a\ possibility\ that\ the\ method\ has\ stalled\ at\ a\ \
point\ which\ is\ not\ a\ local\ \(\(maximum\)\(.\)\)\)\)], "Message",
  CellTags->"FindMaximum::sszero"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindMaximum::sszero"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::sszero", "ObjectNameWarningMessages",
  CellTags->"FindRoot::sszero"],

Cell[BoxData[
    \(FindRoot::"sszero" \(\(:\)\(\ \)\) \(The\ step\ size\ in\ the\ search\ \
has\ become\ less\ than\ the\ tolerance\ prescribed\ by\ the\ PrecisionGoal\ \
option, \ 
      but\ the\ function\ value\ is\ still\ greater\ than\ the\ tolerance\ \
prescribed\ by\ the\ AccuracyGoal\ \(\(option\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::sszero"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::sszero"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::stfail
FindMaximum::stfail
FindFit::stfail
FindRoot::stfail\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
    "FindRoot::stfail"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"stfail\"\>"}], \(\(:\)\(\ \)\), \(The\ method\ `1`\ failed\
\ to\ compute\ the\ next\ \(\(step\)\(.\)\)\)}]], "Message",
  CellTags->{
  "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
    "FindRoot::stfail"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
    "FindRoot::stfail"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::umtd
FindMaximum::umtd
FindFit::umtd\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"umtd\"\>"}], \(\(:\)\(\ \)\), \(The\ method\ `1`\ has\ \
returned\ `2`\ instead\ of\ a\ step\ for\ FindMinimum\ to\ use\ or\ a\ list\ \
\(\({step, \ state}\)\(.\)\)\)}]], "Message",
  CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::umtd", "ObjectNameWarningMessages",
  CellTags->"FindRoot::umtd"],

Cell[BoxData[
    \(FindRoot::"umtd" \(\(:\)\(\ \)\) \(The\ method\ `1`\ has\ returned\ `2`\
\ instead\ of\ a\ step\ for\ FindRoot\ to\ use\ or\ a\ list\ \(\({step, \ 
            state}\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::umtd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::umtd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::bdmtd", "ObjectNameWarningMessages",
  CellTags->"FindRoot::bdmtd"],

Cell[BoxData[
    \(FindRoot::"bdmtd" \(\(:\)\(\ \)\) \(Value\ of\ option\ Method\  -> \ \
`1`\ is\ not\ Automatic, \ Brent, \ Secant, \ 
      or\ \(\(Newton\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::bdmtd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::bdmtd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::eqlist", "ObjectNameWarningMessages",
  CellTags->"FindRoot::eqlist"],

Cell[BoxData[
    \(FindRoot::"eqlist" \(\(:\)\(\ \)\) \(In\ the\ first\ argument\ `1`\ \
only\ some\ of\ the\ components\ are\ \(\(equations\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::eqlist"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::eqlist"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::sec2", "ObjectNameWarningMessages",
  CellTags->"FindRoot::sec2"],

Cell[BoxData[
    \(FindRoot::"sec2" \(\(:\)\(\ \)\) \(Method -> 
        Secant\ requires\ two\ starting\ values\ for\ each\ \
\(\(dimension\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::sec2"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::sec2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::bbrac", "ObjectNameWarningMessages",
  CellTags->"FindRoot::bbrac"],

Cell[BoxData[
    \(FindRoot::"bbrac" \(\(:\)\(\ \)\) \(Method -> 
        Brent\ is\ only\ applicable\ to\ univariate\ real\ functions\ and\ \
requires\ two\ real\ starting\ values\ which\ bracket\ the\ \(\(root\)\(.\)\)\
\)\)], "Message",
  CellTags->"FindRoot::bbrac"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::bbrac"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::frn2", "ObjectNameWarningMessages",
  CellTags->"FindRoot::frn2"],

Cell[BoxData[
    \(FindRoot::"frn2" \(\(:\)\(\ \)\) \(With\ Method -> 
        Newton\ only\ the\ first\ starting\ value\ in\ each\ dimension\ will\ \
be\ \(\(used\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::frn2"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::frn2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::jsing1", "ObjectNameWarningMessages",
  CellTags->"FindRoot::jsing1"],

Cell[BoxData[
    \(FindRoot::"jsing1" \(\(:\)\(\ \)\) \(Encountered\ a\ singular\ Jacobian\
\ at\ the\ point\ `1` . \ 
          Try\ perturbing\ the\ initial\ point \(\((s)\)\(.\)\)\)\)], \
"Message",
  CellTags->"FindRoot::jsing1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::jsing1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::nveq", "ObjectNameWarningMessages",
  CellTags->"FindRoot::nveq"],

Cell[BoxData[
    \(FindRoot::"nveq" \(\(:\)\(\ \)\) \(The\ number\ of\ equations\ does\ \
not\ match\ the\ number\ of\ variables\ in\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"FindRoot::nveq"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindRoot::nveq"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindFit::nlnrm", "ObjectNameWarningMessages",
  CellTags->"FindFit::nlnrm"],

Cell[BoxData[
    \(FindFit::"nlnrm" \(\(:\)\(\ \)\) \(The\ model\ `1`\ is\ linear\ in\ the\
\ parameters\ `2`, \ 
      but\ the\ norm\ specified\ with\ NormFunction -> \(`3`\ is\ non - 
            Euclidean\ so\ the\ linear\ least - 
            squares\ method\ specified\ with\ Method -> `4`\ cannot\ be\ be\ \
\(\(used\)\(.\)\)\)\)\)], "Message",
  CellTags->"FindFit::nlnrm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindFit::nlnrm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindFit::lmnl", "ObjectNameWarningMessages",
  CellTags->"FindFit::lmnl"],

Cell[BoxData[
    \(FindFit::"lmnl" \(\(:\)\(\ \)\) \(The\ model\ `1`\ is\ linear\ in\ the\ \
parameters\ `2`, \ 
      but\ a\ nonlinear\ method\ or\ non - Euclidean\ norm\ was\ specified, \ 
      so\ nonlinear\ methods\ will\ be\ \(\(used\)\(.\)\)\)\)], "Message",
  CellTags->"FindFit::lmnl"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindFit::lmnl"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindFit::nlmod", "ObjectNameWarningMessages",
  CellTags->"FindFit::nlmod"],

Cell[BoxData[
    \(FindFit::"nlmod" \(\(:\)\(\ \)\) \(The\ model\ `1`\ is\ not\ linear\ in\
\ the\ parameters\ `2`\ so\ the\ linear - 
          least\ squares\ method\ specified\ with\ Method -> `3`\ cannot\ be\ \
\(\(used\)\(.\)\)\)\)], "Message",
  CellTags->"FindFit::nlmod"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FindFit::nlmod"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::frns", "ObjectNameWarningMessages",
  CellTags->"FindRoot::frns"],

Cell[BoxData[
    RowBox[{\(FindRoot::"frns"\), \(\(:\)\(\ \)\), "Starting", " ", "value", 
      " ", 
      StyleBox["val",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(number\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FindRoot::frns"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression that is used as a \
starting value for a variable in ",
  StyleBox["FindRoot", "MR"],
  " does not evaluate to a number."
}], "Notes",
  CellTags->"FindRoot::frns"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fdvc
FindMaximum::fdvc
FindFit::fdvc
FindRoot::fdvc\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", "FindRoot::fdvc"}
    ],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fdvc\"\>"}], \(\(:\)\(\ \)\), "Variable", " ", 
      "number", " ", 
      StyleBox["n",
        "TI"], " ", "has", " ", "value", " ", 
      StyleBox["val",
        "TI"], " ", "which", " ", "cannot", " ", "be", " ", "compared", " ", 
      "with", " ", "the", " ", "bounds", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", "FindRoot::fdvc"}
    ],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated variable assumes a \
non-numerical value while being compared with the bounds on the search \
region.\n\[FilledSmallSquare] This message is not normally used in current \
versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  If you see this message in a situation where it is not expected, please \
contact Technical Support."
}], "Notes",
  CellTags->{
  "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", "FindRoot::fdvc"}
    ]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fmdig
FindMaximum::fmdig
FindFit::fmdig\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fmdig\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], " ", "working", " ", "digits", " ", "is", " ", 
        "insufficient", " ", "to", " ", "achieve", " ", "the", " ", 
        "requested", " ", "accuracy", " ", "or", 
        " ", \(\(precision\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the tolerances specified through the \
",
  StyleBox["AccuracyGoal", "MR"],
  " or ",
  StyleBox["PrecisionGoal", "MR"],
  " options cannot be reached using the indicated working precision.\n\
\[FilledSmallSquare] This message can be generated if the objective function \
is singular or has some other sharp feature."
}], "Notes",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell["\<\
An error occurs in this example because this function does not have \
a smooth minimum.\
\>", "Text",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Abs[Sin[x]], {x, 6}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[BoxData[
    \(FindMinimum::"fmdig" \(\(:\)\(\ \)\) 
      "\!\(MachinePrecision\) working digits is insufficient to achieve the \
requested accuracy or precision."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],

Cell[BoxData[
    \({4.681337830782255`*^-8, {x \[Rule] 6.283185260366208`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}]
}, Open  ]],

Cell["\<\
A minimum can be computed by giving two starting values for the \
variable.\
\>", "Text",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Abs[Sin[x]], {x, 6, 7}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[BoxData[
    \({6.432490598706545`*^-16, {x \[Rule] 6.283185307179587`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fit::fitc
FindFit::fitc\
\>", "ObjectNameWarningMessages",
  CellTags->{"Fit::fitc", "FindFit::fitc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fitc\"\>"}], \(\(:\)\(\ \)\), "Number", " ", "of",
       " ", "coordinates", " ", 
      RowBox[{"(", 
        StyleBox[
          RowBox[{
            StyleBox["n",
              "TI"], "1"}]], ")"}], " ", "is", " ", "not", " ", "equal", " ", 
      "to", " ", "the", " ", "number", " ", "of", " ", "variables", " ", 
      RowBox[{
        RowBox[{"(", 
          StyleBox[
            RowBox[{
              StyleBox["n",
                "TI"], "1"}]], ")"}], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Fit::fitc", "FindFit::fitc"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of independent variables \
implied by the first argument in ",
  StyleBox["Fit", "MR"],
  " is not the same as the number of variables listed in the third argument \
of ",
  StyleBox["Fit", "MR"],
  ".\n\[FilledSmallSquare] The first argument in ",
  StyleBox["Fit", "MR"],
  " is expected to be a list of data points, with each data point specified \
as a list of elements in which the last element gives the value of the \
response (dependent variable) and the remaining elements give values for the \
independent variables."
}], "Notes",
  CellTags->{"Fit::fitc", "FindFit::fitc"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fit::fitd
FindFit::fitd\
\>", "ObjectNameWarningMessages",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fitd\"\>"}], \(\(:\)\(\ \)\), \(\(First\)\(\ \
\)\(argument\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(in\ Fit\ is\ not\ a\ list\ or\ a\ rectangular\ \
\(\(array\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Fit", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The first argument \
in ",
  StyleBox["Fit", "MR"],
  " is expected to be a list giving the values of the dependent variable or \
an array giving values for the independent and dependent variables."
}], "Notes",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell["\<\
An error occurs in this example because the first argument is not a \
list.\
\>", "Text",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fit[x, \ {1, 2, 3, 3, 5}, \ x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[BoxData[
    \(Fit::"fitd" \(\(:\)\(\ \)\) 
      "First argument \!\(x\) in Fit is not a list or a rectangular \
array."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FindFit::fitd", "Fit::fitd"}],

Cell[BoxData[
    \(Fit[x, {1, 2, 3, 3, 5}, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FindFit::fitd", "Fit::fitd"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Fit", "MR"],
  "."
}], "Text",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fit[{1, 2, 3, 3, 5}, {1, x}, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[BoxData[
    \(\(\(0.09999999999999973`\)\(\[InvisibleSpace]\)\) + 
      0.9000000000000005`\ x\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FindFit::fitd", "Fit::fitd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fmgs
FindMaximum::fmgs
FindFit::fmgs\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fmgs\"\>"}], \(\(:\)\(\ \)\), "\<\"Could not symbolically \
find the gradient of `1`. Try using the default method, giving two starting \
values for each variable.\"\>"}]], "Message",
  CellLabel->"From In[23]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the objective function in ",
  StyleBox["FindMinimum", "MR"],
  " is not symbolically differentiable.\n\[FilledSmallSquare] In most cases \
the easiest way to avoid this error is to give two starting values for each \
variable, so that symbolic derivatives are not needed.\n\[FilledSmallSquare] \
This error can also be corrected by giving an explicit value for the ",
  StyleBox["Gradient", "MR"],
  " option or by introducing corresponding rules for ",
  StyleBox["D", "MR"],
  " or ",
  StyleBox["Derivative", "MR"],
  "."
}], "Notes",
  CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fmwar
FindMaximum::fmwar
FindFit::fmwar\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fmwar\"\>"}], \(\(:\)\(\ \)\), "\<\"When Method -> \
LevenbergMarquardt, Newton or QuasiNewton only the first starting value in \
each dimension will be used.\"\>"}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated function is used with ",
  StyleBox["Method\[Rule]LevenbergMarquardt", "MR"],
  ", ",
  StyleBox["Method\[Rule]Newton", "MR"],
  ", or ",
  StyleBox["Method\[Rule]QuasiNewton", "MR"],
  ", and more than one starting value is specified for the variable or \
variables.\n\[FilledSmallSquare] Only one starting value is needed for each \
variable if the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["LevenbergMarquardt", "MR"],
  ", ",
  StyleBox["Newton", "MR"],
  ", or ",
  StyleBox["QuasiNewton", "MR"],
  "."
}], "Notes",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell["\<\
A warning message is generated in this example because only one of \
the specified starting values will be used.\
\>", "Text",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 3, 4}, Method -> Newton]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[BoxData[
    \(FindMinimum::"fmwar" \(\(:\)\(\ \)\) 
      "When Method -> LevenbergMarquardt, Newton or QuasiNewton only the \
first starting value in each dimension will be used."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 10.995574287564276`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct specification of a starting value for ",
  StyleBox["Method->Newton", "MR"],
  "."
}], "Text",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 3}, Method -> Newton]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 10.995574287564276`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::regex
FindMaximum::regex
FindFit::regex
FindRoot::regex\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"regex\"\>"}], \(\(:\)\(\ \)\), "\<\"Reached the point `1` \
which is outside the region `2`.\"\>"}]], "Message",
  CellLabel->"From In[30]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the algorithm used by the indicated \
function reaches a point that is outside of the region specified in the \
input.\n\[FilledSmallSquare] Limits can be specified for a search region by \
using a limit specification of the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xstart", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xmin", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["xmax", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  "."
}], "Notes",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell["\<\
An error occurs in this example because the function does not have \
a minumum in the search region.\
\>", "Text",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 7, 6, 8}, Method \[Rule] Gradient]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[BoxData[
    \(FindMinimum::"regex" \(\(:\)\(\ \)\) 
      "Reached the point \!\({\(-3.183992740461578`\)}\) which is outside the \
region \!\({\(\({6.`}\)\), \(\({8.`}\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 7, 6, 8}, Method \[Rule] Gradient]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}]
}, Open  ]],

Cell["\<\
A solution is computed without difficulty if the search region \
includes a minimum.\
\>", "Text",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Sin[x], {x, 7, 4, 8}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 4.7123889803653904`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Fit::fitm
FindFit::fitm\
\>", "ObjectNameWarningMessages",
  CellTags->{"Fit::fitm", "FindFit::fitm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fitm\"\>"}], \(\(:\)\(\ \)\), "\<\"Unable to solve for the \
fit parameters; the design matrix is non-rectangular, non-numerical, or could \
not be inverted.\"\>"}]], "Message",
  CellLabel->"From In[23]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindFit::fitm", "Fit::fitm"}],

Cell["\<\
\[FilledSmallSquare] Generated by failure in the algorithm that is \
used for computing fit coefficients.
\[FilledSmallSquare] This message should not occur in examples that are \
mathematically well defined.  If you see this message in a situation where it \
is not expected, please contact Technical Support.\
\>", "Notes",
  CellTags->{"Fit::fitm", "FindFit::fitm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindMinimum::fmhs
FindMaximum::fmhs
FindFit::fmhs\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fmhs\"\>"}], \(\(:\)\(\ \)\), "\<\"Could not symbolically \
find the Hessian by differentiating the gradient `1`. Try using \
Method->QuasiNewton instead.\"\>"}]], "Message",
  CellLabel->"From In[2]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["FindMinimum", "MR"],
  " is used with ",
  StyleBox["Method->Newton", "MR"],
  ", and differentiation of the value of the ",
  StyleBox["Gradient", "MR"],
  " option leaves unevaluated symbolic derivatives.\n\[FilledSmallSquare] \
Difficulties related to derivatives in ",
  StyleBox["FindMinimum", "MR"],
  " can often be resolved by giving two starting values for each variable, so \
that derivatives are not needed."
}], "Notes",
  CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ngnum", "ObjectNameWarningMessages",
  CellTags->"General::ngnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ngnum\"\>"}], \(\(:\)\(\ \)\), "\<\"The gradient is not a \
vector of numbers at `2` = `1`.\"\>"}]], "Message",
  CellLabel->"From In[30]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ngnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Gradient", "MR"],
  " option or the corresponding derivatives do not have the indicated form.\n\
\[FilledSmallSquare] This error can occur if a point is encountered where the \
derivatives of the equations are singular or non-numerical, or if the value \
of the ",
  StyleBox["Gradient", "MR"],
  " option includes symbolic parameters that do not have numerical values."
}], "Notes",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ngnum"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Sign", "MR"],
  " is not a differentiable function."
}], "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Abs[x], {x, 2}, Method \[Rule] Newton, 
      Gradient \[Rule] Sign[x]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ngnum"],

Cell[BoxData[
    \(FindMinimum::"ngnum" \(\(:\)\(\ \)\) 
      "The gradient is not a vector of numbers at \!\({x}\) = \
\!\({2.`}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ngnum"],

Cell[BoxData[
    \({2.`, {x \[Rule] 2.`}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ngnum"]
}, Open  ]],

Cell["\<\
In this example the minimum can be found by giving two starting \
values for the variable, so that derivatives are not needed.\
\>", "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[Abs[x], {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ngnum"],

Cell[BoxData[
    \({0.`, {x \[Rule] 0.`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ngnum"]
}, Open  ]],

Cell["\<\
An error occurs in this example because the derivative of the first \
argument is singular at the starting point.\
\>", "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sqrt[x] == 2, {x, 0}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::ngnum"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/\@0.`\) encountered."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::ngnum"],

Cell[BoxData[
    \(FindRoot::"ngnum" \(\(:\)\(\ \)\) 
      "The gradient is not a vector of numbers at \!\({x}\) = \
\!\({0.`}\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::ngnum"],

Cell[BoxData[
    \({x \[Rule] 0.`}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::ngnum"]
}, Open  ]],

Cell["\<\
This error can be avoided by choosing a different starting value.\
\
\>", "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sqrt[x] == 2, {x, 1}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::ngnum"],

Cell[BoxData[
    \({x \[Rule] 4.`}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::ngnum"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ngnum1", "ObjectNameWarningMessages",
  CellTags->"General::ngnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ngnum1\"\>"}], \(\(:\)\(\ \)\), "\<\"The gradient is not a \
vector of numbers when the arguments are `1`.\"\>"}]], "Message",
  CellLabel->"From In[30]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ngnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::ngnum1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FindFit::notlm
FindMinimum::notlm\
\>", "ObjectNameWarningMessages",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"notlm\"\>"}], \(\(:\)\(\ \)\), "\<\"The objective function \
for the method LevenbergMarquardt must be in a least-squares form: \
Sum[f[i][x]^2,{i,1,n}] or Sum[w[i] f[i][x]^2,{i,1,n}] with positive \
w[i].\"\>"}]], "Message",
  CellLabel->"From In[2]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated ",
  StyleBox["FindMinimum", "MR"],
  " or ",
  StyleBox["FindFit", "MR"],
  " is used with ",
  StyleBox["Method->LevenbergMarquardt", "MR"],
  ", and the first argument is not given as a sum of squares."
}], "Notes",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["FindMinimum", "MR"],
  " does not have the required form for use with ",
  StyleBox["Method->LevenbergMarquardt", "MR"],
  " ",
  "."
}], "Text",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[9 + x^2 - 4  x + \((y - 3)\)^2, {x, 1}, {y, 1}, 
      Method \[Rule] LevenbergMarquardt]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[BoxData[
    \(FindMinimum::"notlm" \(\(:\)\(\ \)\) 
      "The objective function for the method LevenbergMarquardt must be in a \
least-squares form: Sum[f[i][x]^2,{i,1,n}] or Sum[w[i] f[i][x]^2,{i,1,n}] \
with positive w[i]."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[BoxData[
    \(FindMinimum[9 + x\^2 - 4\ x + \((y - 3)\)\^2, {x, 1}, {y, 1}, 
      Method \[Rule] LevenbergMarquardt]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid objective function for use with ",
  StyleBox["Method->LevenbergMarquardt", "MR"],
  "."
}], "Text",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMinimum[4 + \((x - 2)\)^2 + \((y - 3)\)^2, {x, 1}, {y, 1}, 
      Method \[Rule] LevenbergMarquardt]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[BoxData[
    \({4.`, {x \[Rule] 2.`, y \[Rule] 3.`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindMaximum::notlm", "ObjectNameWarningMessages",
  CellTags->"FindMaximum::notlm"],

Cell[BoxData[
    \(FindMaximum::"notlm" \(\(:\)\(\ \)\) \(The\ objective\ function\ for\ \
the\ method\ LevenbergMarquardt\ must\ be\ in\ a\ least - 
        squares\ \(form : \ 
            Sum[\(-\(f[i]\)[x]^2\), {i, 1, n}]\ or\ Sum[
                w[i]\ \(f[i]\)[x]^2, {i, 1, n}]\ with\ negative\ \(\(w[
                  i]\)\(.\)\)\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FindMaximum::notlm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when F",
  StyleBox["indMaximum", "MR"],
  " is used with ",
  StyleBox["Method->LevenbergMarquardt", "MR"],
  ", and the first argument is not given as a sum of squares."
}], "Notes",
  CellTags->"FindMaximum::notlm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FindMaximum::notlm"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["FindMaximum", "MR"],
  " does not have the required form for use with ",
  StyleBox["Method->LevenbergMarquardt", "MR"],
  " ."
}], "Text",
  CellTags->"FindMaximum::notlm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMaximum[x^2 - 4  x - \((y - 3)\)^2, {x, 1}, {y, 1}, 
      Method \[Rule] LevenbergMarquardt]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FindMaximum::notlm"],

Cell[BoxData[
    \(FindMaximum::"notlm" \(\(:\)\(\ \)\) 
      "The objective function for the method LevenbergMarquardt must be in a \
least-squares form: Sum[-f[i][x]^2,{i,1,n}] or Sum[w[i] f[i][x]^2,{i,1,n}] \
with negative w[i]."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FindMaximum::notlm"],

Cell[BoxData[
    \(FindMaximum[x\^2 - 4\ x - \((y - 3)\)\^2, {x, 1}, {y, 1}, 
      Method \[Rule] LevenbergMarquardt]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FindMaximum::notlm"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid objective function for use with ",
  StyleBox["Method->LevenbergMarquardt", "MR"],
  "."
}], "Text",
  CellTags->"FindMaximum::notlm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindMaximum[4 - \((x - 2)\)^2 - \((y - 3)\)^2, {x, 1}, {y, 1}, 
      Method \[Rule] LevenbergMarquardt]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FindMaximum::notlm"],

Cell[BoxData[
    \({4.`, {x \[Rule] 2.`, y \[Rule] 3.`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FindMaximum::notlm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FindRoot::zdamp", "ObjectNameWarningMessages",
  CellTags->"FindRoot::zdamp"],

Cell[BoxData[
    \(FindRoot::"zdamp" \(\(:\)\(\ \)\) 
      "The factors given in DampingFactor->`1` must all be strictly \
positive."\)], "Message",
  CellLabel->"From In[4]:=",
  CellTags->"FindRoot::zdamp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["DampingFactor", "MR"],
  " option in ",
  StyleBox["FindRoot", "MR"],
  " is zero or negative."
}], "Notes",
  CellTags->"FindRoot::zdamp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FindRoot::zdamp"],

Cell[TextData[{
  "A warning message is generated in this example because the value of the ",
  StyleBox["DampingFactor", "MR"],
  " option is zero."
}], "Text",
  CellTags->"FindRoot::zdamp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sin[x], {x, 10, 11}, DampingFactor \[Rule] 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FindRoot::zdamp"],

Cell[BoxData[
    \(FindRoot::"zdamp" \(\(:\)\(\ \)\) 
      "The factors given in DampingFactor->\!\(0\) must all be strictly \
positive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FindRoot::zdamp"],

Cell[BoxData[
    \(FindRoot[Sin[x], {x, 10, 11}, DampingFactor \[Rule] 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FindRoot::zdamp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["DampingFactor", "MR"],
  " option."
}], "Text",
  CellTags->"FindRoot::zdamp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Sin[x], {x, 9, 10}, DampingFactor \[Rule] 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FindRoot::zdamp"],

Cell[BoxData[
    \({x \[Rule] 9.42477796076938`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FindRoot::zdamp"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{717, 620},
WindowMargins->{{Automatic, 12}, {Automatic, 29}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "FindFit::bdmtd"->{
    Cell[1842, 57, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2018, 64, 461, 11, 53, "Message",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[2482, 77, 263, 5, 24, "Notes",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2770, 86, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2883, 89, 273, 8, 24, "Text",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[3181, 101, 174, 3, 26, "Input",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[3358, 106, 329, 6, 53, "Message",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[3690, 114, 180, 3, 21, "Output",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[3885, 120, 223, 7, 24, "Text",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[4133, 131, 179, 3, 26, "Input",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[4315, 136, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}]},
  "FindMinimum::bdmtd"->{
    Cell[1842, 57, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2018, 64, 461, 11, 53, "Message",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[2482, 77, 263, 5, 24, "Notes",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2770, 86, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2883, 89, 273, 8, 24, "Text",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[3181, 101, 174, 3, 26, "Input",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[3358, 106, 329, 6, 53, "Message",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[3690, 114, 180, 3, 21, "Output",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[3885, 120, 223, 7, 24, "Text",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[4133, 131, 179, 3, 26, "Input",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[4315, 136, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}]},
  "FindMaximum::bdmtd"->{
    Cell[1842, 57, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2018, 64, 461, 11, 53, "Message",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[2482, 77, 263, 5, 24, "Notes",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2770, 86, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[2883, 89, 273, 8, 24, "Text",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[3181, 101, 174, 3, 26, "Input",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[3358, 106, 329, 6, 53, "Message",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[3690, 114, 180, 3, 21, "Output",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
    Cell[3885, 120, 223, 7, 24, "Text",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[4133, 131, 179, 3, 26, "Input",
      CellTags->{
      "FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
    Cell[4315, 136, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}]},
  "FindMinimum::initf"->{
    Cell[4553, 146, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[4770, 156, 324, 9, 21, "Message",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[5097, 167, 197, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}]},
  "FindMaximum::initf"->{
    Cell[4553, 146, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[4770, 156, 324, 9, 21, "Message",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[5097, 167, 197, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}]},
  "FindFit::initf"->{
    Cell[4553, 146, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[4770, 156, 324, 9, 21, "Message",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[5097, 167, 197, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}]},
  "NDSolve::initf"->{
    Cell[4553, 146, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[4770, 156, 324, 9, 21, "Message",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}],
    Cell[5097, 167, 197, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
        "NDSolve::initf"}]},
  "FindMinimum::fddis"->{
    Cell[5331, 178, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[5550, 188, 577, 16, 21, "Message",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6130, 206, 239, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6394, 216, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6534, 221, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6782, 231, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6974, 238, 310, 7, 37, "Message",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7287, 247, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7492, 255, 208, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7725, 266, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7917, 273, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}]},
  "FindMaximum::fddis"->{
    Cell[5331, 178, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[5550, 188, 577, 16, 21, "Message",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6130, 206, 239, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6394, 216, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6534, 221, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6782, 231, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6974, 238, 310, 7, 37, "Message",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7287, 247, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7492, 255, 208, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7725, 266, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7917, 273, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}]},
  "FindFit::fddis"->{
    Cell[5331, 178, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[5550, 188, 577, 16, 21, "Message",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6130, 206, 239, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6394, 216, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6534, 221, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6782, 231, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6974, 238, 310, 7, 37, "Message",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7287, 247, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7492, 255, 208, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7725, 266, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7917, 273, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}]},
  "FindRoot::fddis"->{
    Cell[5331, 178, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[5550, 188, 577, 16, 21, "Message",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6130, 206, 239, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6394, 216, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6534, 221, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6782, 231, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[6974, 238, 310, 7, 37, "Message",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7287, 247, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}],
    Cell[7492, 255, 208, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7725, 266, 189, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
        "FindRoot::fddis"}],
    Cell[7917, 273, 190, 5, 21, "Output",
      CellTags->{
      "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
        "FindRoot::fddis"}]},
  "FindMinimum::fdin"->{
    Cell[8168, 285, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8379, 295, 568, 15, 37, "Message",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8950, 312, 586, 14, 62, "Notes",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9561, 330, 133, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9697, 335, 285, 7, 40, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10007, 346, 203, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10213, 353, 406, 8, 53, "Message",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10622, 363, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10841, 371, 212, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11078, 382, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11289, 389, 239, 6, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}]},
  "FindMaximum::fdin"->{
    Cell[8168, 285, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8379, 295, 568, 15, 37, "Message",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8950, 312, 586, 14, 62, "Notes",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9561, 330, 133, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9697, 335, 285, 7, 40, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10007, 346, 203, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10213, 353, 406, 8, 53, "Message",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10622, 363, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10841, 371, 212, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11078, 382, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11289, 389, 239, 6, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}]},
  "FindFit::fdin"->{
    Cell[8168, 285, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8379, 295, 568, 15, 37, "Message",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8950, 312, 586, 14, 62, "Notes",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9561, 330, 133, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9697, 335, 285, 7, 40, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10007, 346, 203, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10213, 353, 406, 8, 53, "Message",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10622, 363, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10841, 371, 212, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11078, 382, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11289, 389, 239, 6, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}]},
  "FindRoot::fdin"->{
    Cell[8168, 285, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8379, 295, 568, 15, 37, "Message",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[8950, 312, 586, 14, 62, "Notes",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9561, 330, 133, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[9697, 335, 285, 7, 40, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10007, 346, 203, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[10213, 353, 406, 8, 53, "Message",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10622, 363, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}],
    Cell[10841, 371, 212, 7, 24, "Text",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11078, 382, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
        "FindRoot::fdin"}],
    Cell[11289, 389, 239, 6, 21, "Output",
      CellTags->{
      "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
        "FindRoot::fdin"}]},
  "FindFit::fdss"->{
    Cell[11589, 402, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindFit::fdss"],
    Cell[11671, 405, 185, 3, 21, "Message",
      CellTags->"FindFit::fdss"],
    Cell[11859, 410, 124, 4, 24, "Notes",
      CellTags->"FindFit::fdss"]},
  "FindMinimum::fdss"->{
    Cell[12020, 419, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12192, 426, 508, 13, 21, "Message",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12703, 441, 220, 4, 24, "Notes",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12948, 449, 108, 1, 38, "ExampleSection",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13059, 452, 246, 5, 24, "Text",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13330, 461, 159, 3, 26, "Input",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13492, 466, 248, 5, 21, "Message",
      CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],
    
    Cell[13743, 473, 166, 3, 21, "Output",
      CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],
    
    Cell[13924, 479, 188, 5, 24, "Text",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[14137, 488, 164, 3, 26, "Input",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[14304, 493, 163, 3, 21, "Output",
      CellTags->{
      "FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}]},
  "FindMaximum::fdss"->{
    Cell[12020, 419, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12192, 426, 508, 13, 21, "Message",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12703, 441, 220, 4, 24, "Notes",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12948, 449, 108, 1, 38, "ExampleSection",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13059, 452, 246, 5, 24, "Text",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13330, 461, 159, 3, 26, "Input",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13492, 466, 248, 5, 21, "Message",
      CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],
    
    Cell[13743, 473, 166, 3, 21, "Output",
      CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],
    
    Cell[13924, 479, 188, 5, 24, "Text",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[14137, 488, 164, 3, 26, "Input",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[14304, 493, 163, 3, 21, "Output",
      CellTags->{
      "FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}]},
  "FindRoot::fdss"->{
    Cell[12020, 419, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12192, 426, 508, 13, 21, "Message",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12703, 441, 220, 4, 24, "Notes",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[12948, 449, 108, 1, 38, "ExampleSection",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13059, 452, 246, 5, 24, "Text",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13330, 461, 159, 3, 26, "Input",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[13492, 466, 248, 5, 21, "Message",
      CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],
    
    Cell[13743, 473, 166, 3, 21, "Output",
      CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],
    
    Cell[13924, 479, 188, 5, 24, "Text",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[14137, 488, 164, 3, 26, "Input",
      CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
    
    Cell[14304, 493, 163, 3, 21, "Output",
      CellTags->{
      "FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}]},
  "FindMinimum::fmgl"->{
    Cell[14528, 503, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
    Cell[14698, 510, 668, 19, 21, "Message",
      CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
    Cell[15369, 531, 458, 8, 62, "Notes",
      CellTags->{
      "FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}]},
  "FindMaximum::fmgl"->{
    Cell[14528, 503, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
    Cell[14698, 510, 668, 19, 21, "Message",
      CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
    Cell[15369, 531, 458, 8, 62, "Notes",
      CellTags->{
      "FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}]},
  "FindFit::fmgl"->{
    Cell[14528, 503, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
    Cell[14698, 510, 668, 19, 21, "Message",
      CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
    Cell[15369, 531, 458, 8, 62, "Notes",
      CellTags->{
      "FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}]},
  "FindMinimum::nzres"->{
    Cell[15864, 544, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
    Cell[16040, 551, 611, 13, 69, "Message",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
    Cell[16654, 566, 171, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}]},
  "FindMaximum::nzres"->{
    Cell[15864, 544, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
    Cell[16040, 551, 611, 13, 69, "Message",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
    Cell[16654, 566, 171, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}]},
  "FindFit::nzres"->{
    Cell[15864, 544, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
    Cell[16040, 551, 611, 13, 69, "Message",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
    Cell[16654, 566, 171, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}]},
  "FindMinimum::sctl"->{
    Cell[16862, 575, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
    Cell[17032, 582, 369, 8, 37, "Message",
      CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
    Cell[17404, 592, 168, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}]},
  "FindMaximum::sctl"->{
    Cell[16862, 575, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
    Cell[17032, 582, 369, 8, 37, "Message",
      CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
    Cell[17404, 592, 168, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}]},
  "FindFit::sctl"->{
    Cell[16862, 575, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
    Cell[17032, 582, 369, 8, 37, "Message",
      CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
    Cell[17404, 592, 168, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}]},
  "FindRoot::sctl"->{
    Cell[17609, 601, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::sctl"],
    Cell[17693, 604, 226, 4, 37, "Message",
      CellTags->"FindRoot::sctl"],
    Cell[17922, 610, 125, 4, 24, "Notes",
      CellTags->"FindRoot::sctl"]},
  "FindMinimum::lmtrst"->{
    Cell[18084, 619, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
    Cell[18266, 626, 378, 8, 53, "Message",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
    Cell[18647, 636, 174, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}]},
  "FindMaximum::lmtrst"->{
    Cell[18084, 619, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
    Cell[18266, 626, 378, 8, 53, "Message",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
    Cell[18647, 636, 174, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}]},
  "FindFit::lmtrst"->{
    Cell[18084, 619, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
    Cell[18266, 626, 378, 8, 53, "Message",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
    Cell[18647, 636, 174, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}]},
  "FindMinimum::lmotrst"->{
    Cell[18858, 645, 188, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
    Cell[19049, 653, 406, 10, 37, "Message",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
    Cell[19458, 665, 180, 5, 24, "Notes",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}]},
  "FindMaximum::lmotrst"->{
    Cell[18858, 645, 188, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
    Cell[19049, 653, 406, 10, 37, "Message",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
    Cell[19458, 665, 180, 5, 24, "Notes",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}]},
  "FindFit::lmotrst"->{
    Cell[18858, 645, 188, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
    Cell[19049, 653, 406, 10, 37, "Message",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
    Cell[19458, 665, 180, 5, 24, "Notes",
      CellTags->{
      "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}]},
  "FindFit::sdprec"->{
    Cell[19675, 675, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],
    Cell[19814, 681, 394, 10, 37, "Message",
      CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],
    Cell[20211, 693, 151, 4, 24, "Notes",
      CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}]},
  "FindMinimum::sdprec"->{
    Cell[19675, 675, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],
    Cell[19814, 681, 394, 10, 37, "Message",
      CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],
    Cell[20211, 693, 151, 4, 24, "Notes",
      CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}]},
  "FindRoot::sdprec"->{
    Cell[20399, 702, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::sdprec"],
    Cell[20487, 705, 240, 4, 37, "Message",
      CellTags->"FindRoot::sdprec"],
    Cell[20730, 711, 127, 4, 24, "Notes",
      CellTags->"FindRoot::sdprec"]},
  "FindMinimum::lstol"->{
    Cell[20894, 720, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMinimum::lstol"],
    Cell[20986, 723, 419, 6, 53, "Message",
      CellTags->"FindMinimum::lstol"],
    Cell[21408, 731, 415, 10, 62, "Notes",
      CellTags->"FindMinimum::lstol"],
    Cell[21848, 745, 68, 1, 38, "ExampleSection",
      CellTags->"FindMinimum::lstol"],
    Cell[21919, 748, 169, 4, 24, "Text",
      CellTags->"FindMinimum::lstol"],
    Cell[22113, 756, 166, 4, 26, "Input",
      CellTags->"FindMinimum::lstol"],
    Cell[22282, 762, 416, 7, 85, "Message",
      CellTags->"FindMinimum::lstol"],
    Cell[22701, 771, 149, 3, 23, "Output",
      CellTags->"FindMinimum::lstol"]},
  "FindFit::lstol"->{
    Cell[22911, 781, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindFit::lstol"],
    Cell[22995, 784, 426, 6, 69, "Message",
      CellTags->"FindFit::lstol"],
    Cell[23424, 792, 125, 4, 24, "Notes",
      CellTags->"FindFit::lstol"]},
  "FindRoot::lstol"->{
    Cell[23586, 801, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::lstol"],
    Cell[23672, 804, 420, 6, 53, "Message",
      CellTags->"FindRoot::lstol"],
    Cell[24095, 812, 462, 11, 62, "Notes",
      CellTags->"FindRoot::lstol"],
    Cell[24582, 827, 65, 1, 38, "ExampleSection",
      CellTags->"FindRoot::lstol"],
    Cell[24650, 830, 146, 4, 24, "Text",
      CellTags->"FindRoot::lstol"],
    Cell[24821, 838, 117, 3, 26, "Input",
      CellTags->"FindRoot::lstol"],
    Cell[24941, 843, 418, 8, 85, "Message",
      CellTags->"FindRoot::lstol"],
    Cell[25362, 853, 126, 3, 21, "Output",
      CellTags->"FindRoot::lstol"],
    Cell[25503, 859, 121, 4, 24, "Text",
      CellTags->"FindRoot::lstol"],
    Cell[25649, 867, 117, 3, 26, "Input",
      CellTags->"FindRoot::lstol"],
    Cell[25769, 872, 149, 4, 21, "Output",
      CellTags->"FindRoot::lstol"],
    Cell[25955, 881, 122, 3, 26, "Input",
      CellTags->"FindRoot::lstol"],
    Cell[26080, 886, 149, 4, 21, "Output",
      CellTags->"FindRoot::lstol"]},
  "FindMinimum::lsbrak"->{
    Cell[26290, 897, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMinimum::lsbrak"],
    Cell[26384, 900, 211, 4, 21, "Message",
      CellTags->"FindMinimum::lsbrak"],
    Cell[26598, 906, 130, 4, 24, "Notes",
      CellTags->"FindMinimum::lsbrak"]},
  "FindRoot::btf"->{
    Cell[26765, 915, 195, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[26963, 924, 399, 10, 37, "Message",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[27365, 936, 185, 5, 24, "Notes",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}]},
  "FindMinimum::btf"->{
    Cell[26765, 915, 195, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[26963, 924, 399, 10, 37, "Message",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[27365, 936, 185, 5, 24, "Notes",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}]},
  "FindMaximum::btf"->{
    Cell[26765, 915, 195, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[26963, 924, 399, 10, 37, "Message",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[27365, 936, 185, 5, 24, "Notes",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}]},
  "FindFit::btf"->{
    Cell[26765, 915, 195, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[26963, 924, 399, 10, 37, "Message",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}],
    Cell[27365, 936, 185, 5, 24, "Notes",
      CellTags->{
      "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", 
        "FindFit::btf"}]},
  "FindMinimum::bddir"->{
    Cell[27587, 946, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],
    Cell[27722, 952, 472, 10, 53, "Message",
      CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],
    Cell[28197, 964, 149, 4, 24, "Notes",
      CellTags->{"FindMinimum::bddir", "FindFit::bddir"}]},
  "FindFit::bddir"->{
    Cell[27587, 946, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],
    Cell[27722, 952, 472, 10, 53, "Message",
      CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],
    Cell[28197, 964, 149, 4, 24, "Notes",
      CellTags->{"FindMinimum::bddir", "FindFit::bddir"}]},
  "FindMaximum::bddir"->{
    Cell[28383, 973, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMaximum::bddir"],
    Cell[28475, 976, 369, 6, 53, "Message",
      CellTags->"FindMaximum::bddir"],
    Cell[28847, 984, 129, 4, 24, "Notes",
      CellTags->"FindMaximum::bddir"]},
  "FindRoot::bddir"->{
    Cell[29013, 993, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::bddir"],
    Cell[29099, 996, 277, 5, 37, "Message",
      CellTags->"FindRoot::bddir"],
    Cell[29379, 1003, 126, 4, 24, "Notes",
      CellTags->"FindRoot::bddir"]},
  "FindMaximum::fmgz"->{
    Cell[29542, 1012, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMaximum::fmgz"],
    Cell[29632, 1015, 276, 5, 53, "Message",
      CellTags->"FindMaximum::fmgz"],
    Cell[29911, 1022, 396, 8, 62, "Notes",
      CellTags->"FindMaximum::fmgz"],
    Cell[30332, 1034, 67, 1, 38, "ExampleSection",
      CellTags->"FindMaximum::fmgz"],
    Cell[30402, 1037, 148, 4, 24, "Text",
      CellTags->"FindMaximum::fmgz"],
    Cell[30575, 1045, 138, 3, 26, "Input",
      CellTags->"FindMaximum::fmgz"],
    Cell[30716, 1050, 274, 5, 53, "Message",
      CellTags->"FindMaximum::fmgz"],
    Cell[30993, 1057, 128, 3, 21, "Output",
      CellTags->"FindMaximum::fmgz"],
    Cell[31136, 1063, 140, 4, 24, "Text",
      CellTags->"FindMaximum::fmgz"],
    Cell[31301, 1071, 138, 3, 26, "Input",
      CellTags->"FindMaximum::fmgz"],
    Cell[31442, 1076, 146, 3, 21, "Output",
      CellTags->"FindMaximum::fmgz"]},
  "FindMinimum::fmgz"->{
    Cell[31649, 1086, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMinimum::fmgz"],
    Cell[31739, 1089, 276, 5, 53, "Message",
      CellTags->"FindMinimum::fmgz"],
    Cell[32018, 1096, 396, 8, 62, "Notes",
      CellTags->"FindMinimum::fmgz"],
    Cell[32439, 1108, 67, 1, 38, "ExampleSection",
      CellTags->"FindMinimum::fmgz"],
    Cell[32509, 1111, 148, 4, 24, "Text",
      CellTags->"FindMinimum::fmgz"],
    Cell[32682, 1119, 138, 3, 26, "Input",
      CellTags->"FindMinimum::fmgz"],
    Cell[32823, 1124, 274, 5, 53, "Message",
      CellTags->"FindMinimum::fmgz"],
    Cell[33100, 1131, 128, 3, 21, "Output",
      CellTags->"FindMinimum::fmgz"],
    Cell[33243, 1137, 140, 4, 24, "Text",
      CellTags->"FindMinimum::fmgz"],
    Cell[33408, 1145, 138, 3, 26, "Input",
      CellTags->"FindMinimum::fmgz"],
    Cell[33549, 1150, 146, 3, 21, "Output",
      CellTags->"FindMinimum::fmgz"]},
  "FindMinimum::fmmp"->{
    Cell[33756, 1160, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
    Cell[33926, 1167, 389, 10, 37, "Message",
      CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
    Cell[34318, 1179, 558, 12, 78, "Notes",
      CellTags->{
      "FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}]},
  "FindMaximum::fmmp"->{
    Cell[33756, 1160, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
    Cell[33926, 1167, 389, 10, 37, "Message",
      CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
    Cell[34318, 1179, 558, 12, 78, "Notes",
      CellTags->{
      "FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}]},
  "FindFit::fmmp"->{
    Cell[33756, 1160, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
    Cell[33926, 1167, 389, 10, 37, "Message",
      CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
    Cell[34318, 1179, 558, 12, 78, "Notes",
      CellTags->{
      "FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}]},
  "FindRoot::fdst"->{
    Cell[34913, 1196, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}],
    Cell[35124, 1206, 446, 13, 37, "Message",
      CellTags->{
      "FindFit::fdst", "FindMaximum::fdst", "FindMinimum::fdst", 
        "FindRoot::fdst"}],
    Cell[35573, 1221, 878, 31, 46, "Notes",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}]},
  "FindMinimum::fdst"->{
    Cell[34913, 1196, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}],
    Cell[35124, 1206, 446, 13, 37, "Message",
      CellTags->{
      "FindFit::fdst", "FindMaximum::fdst", "FindMinimum::fdst", 
        "FindRoot::fdst"}],
    Cell[35573, 1221, 878, 31, 46, "Notes",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}]},
  "FindMaximum::fdst"->{
    Cell[34913, 1196, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}],
    Cell[35124, 1206, 446, 13, 37, "Message",
      CellTags->{
      "FindFit::fdst", "FindMaximum::fdst", "FindMinimum::fdst", 
        "FindRoot::fdst"}],
    Cell[35573, 1221, 878, 31, 46, "Notes",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}]},
  "FindFit::fdst"->{
    Cell[34913, 1196, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}],
    Cell[35124, 1206, 446, 13, 37, "Message",
      CellTags->{
      "FindFit::fdst", "FindMaximum::fdst", "FindMinimum::fdst", 
        "FindRoot::fdst"}],
    Cell[35573, 1221, 878, 31, 46, "Notes",
      CellTags->{
      "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
        "FindFit::fdst"}]},
  "FindRoot::frdig"->{
    Cell[36488, 1257, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::frdig"],
    Cell[36574, 1260, 443, 12, 21, "Message",
      CellTags->"FindRoot::frdig"],
    Cell[37020, 1274, 666, 15, 100, "Notes",
      CellTags->"FindRoot::frdig"]},
  "FindRoot::frmp"->{
    Cell[37723, 1294, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::frmp"],
    Cell[37807, 1297, 292, 6, 21, "Message",
      CellTags->"FindRoot::frmp"],
    Cell[38102, 1305, 669, 15, 100, "Notes",
      CellTags->"FindRoot::frmp"]},
  "FindRoot::jsing"->{
    Cell[38808, 1325, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::jsing"],
    Cell[38894, 1328, 233, 5, 37, "Message",
      CellTags->"FindRoot::jsing"],
    Cell[39130, 1335, 371, 8, 46, "Notes",
      CellTags->"FindRoot::jsing"],
    Cell[39526, 1347, 65, 1, 38, "ExampleSection",
      CellTags->"FindRoot::jsing"],
    Cell[39594, 1350, 167, 4, 24, "Text",
      CellTags->"FindRoot::jsing"],
    Cell[39786, 1358, 118, 3, 26, "Input",
      CellTags->"FindRoot::jsing"],
    Cell[39907, 1363, 246, 5, 37, "Message",
      CellTags->"FindRoot::jsing"],
    Cell[40156, 1370, 104, 3, 21, "Output",
      CellTags->"FindRoot::jsing"],
    Cell[40275, 1376, 130, 4, 24, "Text",
      CellTags->"FindRoot::jsing"],
    Cell[40430, 1384, 118, 3, 26, "Input",
      CellTags->"FindRoot::jsing"],
    Cell[40551, 1389, 120, 3, 21, "Output",
      CellTags->"FindRoot::jsing"],
    Cell[40686, 1395, 169, 4, 24, "Text",
      CellTags->"FindRoot::jsing"],
    Cell[40880, 1403, 107, 3, 26, "Input",
      CellTags->"FindRoot::jsing"],
    Cell[40990, 1408, 246, 5, 37, "Message",
      CellTags->"FindRoot::jsing"],
    Cell[41239, 1415, 104, 3, 21, "Output",
      CellTags->"FindRoot::jsing"]},
  "FindMinimum::lss"->{
    Cell[41404, 1425, 163, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
    Cell[41570, 1432, 373, 9, 37, "Message",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
    Cell[41946, 1443, 166, 4, 24, "Notes",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}]},
  "FindMaximum::lss"->{
    Cell[41404, 1425, 163, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
    Cell[41570, 1432, 373, 9, 37, "Message",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
    Cell[41946, 1443, 166, 4, 24, "Notes",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}]},
  "FindRoot::lss"->{
    Cell[41404, 1425, 163, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
    Cell[41570, 1432, 373, 9, 37, "Message",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
    Cell[41946, 1443, 166, 4, 24, "Notes",
      CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}]},
  "FindFit::lss"->{
    Cell[42149, 1452, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindFit::lss"],
    Cell[42229, 1455, 254, 5, 37, "Message",
      CellTags->"FindFit::lss"],
    Cell[42486, 1462, 123, 4, 24, "Notes",
      CellTags->"FindFit::lss"]},
  "FindFit::precw"->{
    Cell[42646, 1471, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindFit::precw"],
    Cell[42730, 1474, 238, 4, 37, "Message",
      CellTags->"FindFit::precw"],
    Cell[42971, 1480, 125, 4, 24, "Notes",
      CellTags->"FindFit::precw"]},
  "FindMinimum::srect"->{
    Cell[43133, 1489, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43352, 1499, 364, 10, 21, "Message",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43719, 1511, 689, 17, 100, "Notes",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44433, 1532, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44573, 1537, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44821, 1547, 188, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45012, 1554, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45319, 1563, 189, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45523, 1571, 231, 7, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45779, 1582, 205, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45987, 1589, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}]},
  "FindMaximum::srect"->{
    Cell[43133, 1489, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43352, 1499, 364, 10, 21, "Message",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43719, 1511, 689, 17, 100, "Notes",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44433, 1532, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44573, 1537, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44821, 1547, 188, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45012, 1554, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45319, 1563, 189, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45523, 1571, 231, 7, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45779, 1582, 205, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45987, 1589, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}]},
  "FindFit::srect"->{
    Cell[43133, 1489, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43352, 1499, 364, 10, 21, "Message",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43719, 1511, 689, 17, 100, "Notes",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44433, 1532, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44573, 1537, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44821, 1547, 188, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45012, 1554, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45319, 1563, 189, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45523, 1571, 231, 7, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45779, 1582, 205, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45987, 1589, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}]},
  "FindRoot::srect"->{
    Cell[43133, 1489, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43352, 1499, 364, 10, 21, "Message",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[43719, 1511, 689, 17, 100, "Notes",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44433, 1532, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44573, 1537, 223, 6, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[44821, 1547, 188, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45012, 1554, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45319, 1563, 189, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}],
    Cell[45523, 1571, 231, 7, 24, "Text",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45779, 1582, 205, 5, 26, "Input",
      CellTags->{
      "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
        "FindRoot::srect"}],
    Cell[45987, 1589, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
        "FindRoot::srect"}]},
  "FindMinimum::scdims"->{
    Cell[46251, 1601, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46478, 1611, 367, 10, 21, "Message",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46848, 1623, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}]},
  "FindMaximum::scdims"->{
    Cell[46251, 1601, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46478, 1611, 367, 10, 21, "Message",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46848, 1623, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}]},
  "FindFit::scdims"->{
    Cell[46251, 1601, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46478, 1611, 367, 10, 21, "Message",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46848, 1623, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}]},
  "FindRoot::scdims"->{
    Cell[46251, 1601, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46478, 1611, 367, 10, 21, "Message",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}],
    Cell[46848, 1623, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
        "FindRoot::scdims"}]},
  "FindMinimum::snum"->{
    Cell[47087, 1634, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47298, 1644, 333, 9, 21, "Message",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47634, 1655, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}]},
  "FindMaximum::snum"->{
    Cell[47087, 1634, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47298, 1644, 333, 9, 21, "Message",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47634, 1655, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}]},
  "FindFit::snum"->{
    Cell[47087, 1634, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47298, 1644, 333, 9, 21, "Message",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47634, 1655, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}]},
  "FindRoot::snum"->{
    Cell[47087, 1634, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47298, 1644, 333, 9, 21, "Message",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}],
    Cell[47634, 1655, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
        "FindRoot::snum"}]},
  "FindMinimum::fdssnv"->{
    Cell[47865, 1666, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48092, 1676, 383, 10, 37, "Message",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48478, 1688, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}]},
  "FindMaximum::fdssnv"->{
    Cell[47865, 1666, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48092, 1676, 383, 10, 37, "Message",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48478, 1688, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}]},
  "FindRoot::fdssnv"->{
    Cell[47865, 1666, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48092, 1676, 383, 10, 37, "Message",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48478, 1688, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}]},
  "FindFit::fdssnv"->{
    Cell[47865, 1666, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48092, 1676, 383, 10, 37, "Message",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}],
    Cell[48478, 1688, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
        "FindFit::fdssnv"}]},
  "FindMinimum::bbound"->{
    Cell[48717, 1699, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[48944, 1709, 371, 10, 21, "Message",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49318, 1721, 578, 16, 78, "Notes",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49921, 1741, 141, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50065, 1746, 228, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50318, 1756, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50518, 1763, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[50825, 1772, 198, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51038, 1780, 247, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51310, 1791, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51510, 1798, 207, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51732, 1806, 266, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52023, 1817, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52234, 1824, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52541, 1833, 215, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52771, 1841, 213, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53009, 1851, 243, 6, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53255, 1859, 195, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}]},
  "FindMaximum::bbound"->{
    Cell[48717, 1699, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[48944, 1709, 371, 10, 21, "Message",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49318, 1721, 578, 16, 78, "Notes",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49921, 1741, 141, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50065, 1746, 228, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50318, 1756, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50518, 1763, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[50825, 1772, 198, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51038, 1780, 247, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51310, 1791, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51510, 1798, 207, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51732, 1806, 266, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52023, 1817, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52234, 1824, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52541, 1833, 215, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52771, 1841, 213, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53009, 1851, 243, 6, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53255, 1859, 195, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}]},
  "FindFit::bbound"->{
    Cell[48717, 1699, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[48944, 1709, 371, 10, 21, "Message",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49318, 1721, 578, 16, 78, "Notes",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49921, 1741, 141, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50065, 1746, 228, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50318, 1756, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50518, 1763, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[50825, 1772, 198, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51038, 1780, 247, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51310, 1791, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51510, 1798, 207, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51732, 1806, 266, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52023, 1817, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52234, 1824, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52541, 1833, 215, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52771, 1841, 213, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53009, 1851, 243, 6, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53255, 1859, 195, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}]},
  "FindRoot::bbound"->{
    Cell[48717, 1699, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[48944, 1709, 371, 10, 21, "Message",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49318, 1721, 578, 16, 78, "Notes",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[49921, 1741, 141, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50065, 1746, 228, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50318, 1756, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[50518, 1763, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[50825, 1772, 198, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51038, 1780, 247, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51310, 1791, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[51510, 1798, 207, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[51732, 1806, 266, 7, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52023, 1817, 208, 5, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[52234, 1824, 304, 7, 37, "Message",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52541, 1833, 215, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}],
    Cell[52771, 1841, 213, 6, 24, "Text",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53009, 1851, 243, 6, 26, "Input",
      CellTags->{
      "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
        "FindRoot::bbound"}],
    Cell[53255, 1859, 195, 5, 21, "Output",
      CellTags->{
      "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
        "FindRoot::bbound"}]},
  "FindMinimum::linf"->{
    Cell[53511, 1871, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[53722, 1881, 393, 10, 37, "Message",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[54118, 1893, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}]},
  "FindMaximum::linf"->{
    Cell[53511, 1871, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[53722, 1881, 393, 10, 37, "Message",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[54118, 1893, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}]},
  "FindFit::linf"->{
    Cell[53511, 1871, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[53722, 1881, 393, 10, 37, "Message",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[54118, 1893, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}]},
  "FindRoot::linf"->{
    Cell[53511, 1871, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[53722, 1881, 393, 10, 37, "Message",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}],
    Cell[54118, 1893, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
        "FindRoot::linf"}]},
  "FindMinimum::uinf"->{
    Cell[54349, 1904, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54560, 1914, 396, 10, 37, "Message",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54959, 1926, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}]},
  "FindMaximum::uinf"->{
    Cell[54349, 1904, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54560, 1914, 396, 10, 37, "Message",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54959, 1926, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}]},
  "FindFit::uinf"->{
    Cell[54349, 1904, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54560, 1914, 396, 10, 37, "Message",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54959, 1926, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}]},
  "FindRoot::uinf"->{
    Cell[54349, 1904, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54560, 1914, 396, 10, 37, "Message",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}],
    Cell[54959, 1926, 194, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
        "FindRoot::uinf"}]},
  "FindMinimum::cvmit"->{
    Cell[55190, 1937, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55409, 1947, 368, 10, 37, "Message",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55780, 1959, 656, 14, 90, "Notes",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56461, 1977, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56601, 1982, 235, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56861, 1992, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57065, 1999, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57369, 2008, 234, 6, 23, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57618, 2017, 218, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57861, 2027, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58065, 2034, 214, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58294, 2042, 176, 3, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58495, 2049, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58695, 2056, 257, 7, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58967, 2066, 260, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59252, 2077, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59448, 2084, 298, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59749, 2093, 192, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59956, 2101, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60192, 2111, 192, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60387, 2118, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60670, 2129, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60870, 2136, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61131, 2145, 261, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61417, 2156, 182, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61602, 2163, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61906, 2172, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}]},
  "FindMaximum::cvmit"->{
    Cell[55190, 1937, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55409, 1947, 368, 10, 37, "Message",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55780, 1959, 656, 14, 90, "Notes",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56461, 1977, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56601, 1982, 235, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56861, 1992, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57065, 1999, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57369, 2008, 234, 6, 23, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57618, 2017, 218, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57861, 2027, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58065, 2034, 214, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58294, 2042, 176, 3, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58495, 2049, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58695, 2056, 257, 7, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58967, 2066, 260, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59252, 2077, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59448, 2084, 298, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59749, 2093, 192, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59956, 2101, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60192, 2111, 192, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60387, 2118, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60670, 2129, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60870, 2136, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61131, 2145, 261, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61417, 2156, 182, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61602, 2163, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61906, 2172, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}]},
  "FindFit::cvmit"->{
    Cell[55190, 1937, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55409, 1947, 368, 10, 37, "Message",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55780, 1959, 656, 14, 90, "Notes",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56461, 1977, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56601, 1982, 235, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56861, 1992, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57065, 1999, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57369, 2008, 234, 6, 23, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57618, 2017, 218, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57861, 2027, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58065, 2034, 214, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58294, 2042, 176, 3, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58495, 2049, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58695, 2056, 257, 7, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58967, 2066, 260, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59252, 2077, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59448, 2084, 298, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59749, 2093, 192, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59956, 2101, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60192, 2111, 192, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60387, 2118, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60670, 2129, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60870, 2136, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61131, 2145, 261, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61417, 2156, 182, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61602, 2163, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61906, 2172, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}]},
  "FindRoot::cvmit"->{
    Cell[55190, 1937, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55409, 1947, 368, 10, 37, "Message",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[55780, 1959, 656, 14, 90, "Notes",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56461, 1977, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56601, 1982, 235, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[56861, 1992, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57065, 1999, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57369, 2008, 234, 6, 23, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57618, 2017, 218, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[57861, 2027, 201, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58065, 2034, 214, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58294, 2042, 176, 3, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58495, 2049, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58695, 2056, 257, 7, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[58967, 2066, 260, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59252, 2077, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59448, 2084, 298, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59749, 2093, 192, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[59956, 2101, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60192, 2111, 192, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60387, 2118, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60670, 2129, 197, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[60870, 2136, 246, 6, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61131, 2145, 261, 7, 24, "Text",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61417, 2156, 182, 5, 26, "Input",
      CellTags->{
      "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61602, 2163, 301, 7, 37, "Message",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}],
    Cell[61906, 2172, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
        "FindRoot::cvmit"}]},
  "FindMaximum::sdprec"->{
    Cell[62170, 2184, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMaximum::sdprec"],
    Cell[62264, 2187, 239, 4, 37, "Message",
      CellTags->"FindMaximum::sdprec"],
    Cell[62506, 2193, 130, 4, 24, "Notes",
      CellTags->"FindMaximum::sdprec"]},
  "FindMaximum::lstol"->{
    Cell[62673, 2202, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMaximum::lstol"],
    Cell[62765, 2205, 419, 6, 53, "Message",
      CellTags->"FindMaximum::lstol"],
    Cell[63187, 2213, 129, 4, 24, "Notes",
      CellTags->"FindMaximum::lstol"]},
  "FindMaximum::lsbrak"->{
    Cell[63353, 2222, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMaximum::lsbrak"],
    Cell[63447, 2225, 211, 4, 21, "Message",
      CellTags->"FindMaximum::lsbrak"],
    Cell[63661, 2231, 130, 4, 24, "Notes",
      CellTags->"FindMaximum::lsbrak"]},
  "FindMinimum::prax2"->{
    Cell[63828, 2240, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
    Cell[64004, 2247, 325, 7, 21, "Message",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
    Cell[64332, 2256, 171, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}]},
  "FindMaximum::prax2"->{
    Cell[63828, 2240, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
    Cell[64004, 2247, 325, 7, 21, "Message",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
    Cell[64332, 2256, 171, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}]},
  "FindFit::prax2"->{
    Cell[63828, 2240, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
    Cell[64004, 2247, 325, 7, 21, "Message",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
    Cell[64332, 2256, 171, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}]},
  "FindMinimum::regex1"->{
    Cell[64540, 2265, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[64767, 2275, 448, 13, 37, "Message",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[65218, 2290, 734, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}]},
  "FindMaximum::regex1"->{
    Cell[64540, 2265, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[64767, 2275, 448, 13, 37, "Message",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[65218, 2290, 734, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}]},
  "FindFit::regex1"->{
    Cell[64540, 2265, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[64767, 2275, 448, 13, 37, "Message",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[65218, 2290, 734, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}]},
  "FindRoot::regex1"->{
    Cell[64540, 2265, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[64767, 2275, 448, 13, 37, "Message",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}],
    Cell[65218, 2290, 734, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
        "FindRoot::regex1"}]},
  "FindMinimum::reged"->{
    Cell[65989, 2317, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66208, 2327, 434, 11, 37, "Message",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66645, 2340, 527, 15, 62, "Notes",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67197, 2359, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67337, 2364, 237, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67599, 2374, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67795, 2381, 374, 8, 53, "Message",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68172, 2391, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68391, 2399, 224, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68640, 2409, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68836, 2416, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}]},
  "FindMaximum::reged"->{
    Cell[65989, 2317, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66208, 2327, 434, 11, 37, "Message",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66645, 2340, 527, 15, 62, "Notes",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67197, 2359, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67337, 2364, 237, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67599, 2374, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67795, 2381, 374, 8, 53, "Message",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68172, 2391, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68391, 2399, 224, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68640, 2409, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68836, 2416, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}]},
  "FindFit::reged"->{
    Cell[65989, 2317, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66208, 2327, 434, 11, 37, "Message",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66645, 2340, 527, 15, 62, "Notes",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67197, 2359, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67337, 2364, 237, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67599, 2374, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67795, 2381, 374, 8, 53, "Message",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68172, 2391, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68391, 2399, 224, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68640, 2409, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68836, 2416, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}]},
  "FindRoot::reged"->{
    Cell[65989, 2317, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66208, 2327, 434, 11, 37, "Message",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[66645, 2340, 527, 15, 62, "Notes",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67197, 2359, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67337, 2364, 237, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67599, 2374, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[67795, 2381, 374, 8, 53, "Message",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68172, 2391, 204, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}],
    Cell[68391, 2399, 224, 6, 24, "Text",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68640, 2409, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
        "FindRoot::reged"}],
    Cell[68836, 2416, 203, 5, 21, "Output",
      CellTags->{
      "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
        "FindRoot::reged"}]},
  "FindMinimum::streg"->{
    Cell[69100, 2428, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69319, 2438, 340, 9, 21, "Message",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69662, 2449, 198, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}]},
  "FindMaximum::streg"->{
    Cell[69100, 2428, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69319, 2438, 340, 9, 21, "Message",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69662, 2449, 198, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}]},
  "FindFit::streg"->{
    Cell[69100, 2428, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69319, 2438, 340, 9, 21, "Message",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69662, 2449, 198, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}]},
  "FindRoot::streg"->{
    Cell[69100, 2428, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69319, 2438, 340, 9, 21, "Message",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}],
    Cell[69662, 2449, 198, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
        "FindRoot::streg"}]},
  "FindFit::sszero"->{
    Cell[69897, 2460, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],
    Cell[70036, 2466, 633, 14, 69, "Message",
      CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],
    Cell[70672, 2482, 151, 4, 24, "Notes",
      CellTags->{"FindFit::sszero", "FindMinimum::sszero"}]},
  "FindMinimum::sszero"->{
    Cell[69897, 2460, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],
    Cell[70036, 2466, 633, 14, 69, "Message",
      CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],
    Cell[70672, 2482, 151, 4, 24, "Notes",
      CellTags->{"FindFit::sszero", "FindMinimum::sszero"}]},
  "FindMaximum::sszero"->{
    Cell[70860, 2491, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMaximum::sszero"],
    Cell[70954, 2494, 478, 8, 69, "Message",
      CellTags->"FindMaximum::sszero"],
    Cell[71435, 2504, 130, 4, 24, "Notes",
      CellTags->"FindMaximum::sszero"]},
  "FindRoot::sszero"->{
    Cell[71602, 2513, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::sszero"],
    Cell[71690, 2516, 363, 6, 53, "Message",
      CellTags->"FindRoot::sszero"],
    Cell[72056, 2524, 127, 4, 24, "Notes",
      CellTags->"FindRoot::sszero"]},
  "FindMinimum::stfail"->{
    Cell[72220, 2533, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72447, 2543, 335, 9, 21, "Message",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72785, 2554, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}]},
  "FindMaximum::stfail"->{
    Cell[72220, 2533, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72447, 2543, 335, 9, 21, "Message",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72785, 2554, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}]},
  "FindFit::stfail"->{
    Cell[72220, 2533, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72447, 2543, 335, 9, 21, "Message",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72785, 2554, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}]},
  "FindRoot::stfail"->{
    Cell[72220, 2533, 224, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72447, 2543, 335, 9, 21, "Message",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}],
    Cell[72785, 2554, 202, 6, 24, "Notes",
      CellTags->{
      "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
        "FindRoot::stfail"}]},
  "FindMinimum::umtd"->{
    Cell[73024, 2565, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
    Cell[73194, 2572, 362, 8, 37, "Message",
      CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
    Cell[73559, 2582, 168, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}]},
  "FindMaximum::umtd"->{
    Cell[73024, 2565, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
    Cell[73194, 2572, 362, 8, 37, "Message",
      CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
    Cell[73559, 2582, 168, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}]},
  "FindFit::umtd"->{
    Cell[73024, 2565, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
    Cell[73194, 2572, 362, 8, 37, "Message",
      CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
    Cell[73559, 2582, 168, 4, 24, "Notes",
      CellTags->{
      "FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}]},
  "FindRoot::umtd"->{
    Cell[73764, 2591, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::umtd"],
    Cell[73848, 2594, 242, 4, 37, "Message",
      CellTags->"FindRoot::umtd"],
    Cell[74093, 2600, 125, 4, 24, "Notes",
      CellTags->"FindRoot::umtd"]},
  "FindRoot::bdmtd"->{
    Cell[74255, 2609, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::bdmtd"],
    Cell[74341, 2612, 215, 4, 37, "Message",
      CellTags->"FindRoot::bdmtd"],
    Cell[74559, 2618, 126, 4, 24, "Notes",
      CellTags->"FindRoot::bdmtd"]},
  "FindRoot::eqlist"->{
    Cell[74722, 2627, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::eqlist"],
    Cell[74810, 2630, 199, 3, 21, "Message",
      CellTags->"FindRoot::eqlist"],
    Cell[75012, 2635, 127, 4, 24, "Notes",
      CellTags->"FindRoot::eqlist"]},
  "FindRoot::sec2"->{
    Cell[75176, 2644, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::sec2"],
    Cell[75260, 2647, 197, 4, 21, "Message",
      CellTags->"FindRoot::sec2"],
    Cell[75460, 2653, 125, 4, 24, "Notes",
      CellTags->"FindRoot::sec2"]},
  "FindRoot::bbrac"->{
    Cell[75622, 2662, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::bbrac"],
    Cell[75708, 2665, 271, 5, 37, "Message",
      CellTags->"FindRoot::bbrac"],
    Cell[75982, 2672, 126, 4, 24, "Notes",
      CellTags->"FindRoot::bbrac"]},
  "FindRoot::frn2"->{
    Cell[76145, 2681, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::frn2"],
    Cell[76229, 2684, 220, 4, 37, "Message",
      CellTags->"FindRoot::frn2"],
    Cell[76452, 2690, 125, 4, 24, "Notes",
      CellTags->"FindRoot::frn2"]},
  "FindRoot::jsing1"->{
    Cell[76614, 2699, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::jsing1"],
    Cell[76702, 2702, 234, 5, 37, "Message",
      CellTags->"FindRoot::jsing1"],
    Cell[76939, 2709, 127, 4, 24, "Notes",
      CellTags->"FindRoot::jsing1"]},
  "FindRoot::nveq"->{
    Cell[77103, 2718, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::nveq"],
    Cell[77187, 2721, 198, 3, 21, "Message",
      CellTags->"FindRoot::nveq"],
    Cell[77388, 2726, 125, 4, 24, "Notes",
      CellTags->"FindRoot::nveq"]},
  "FindFit::nlnrm"->{
    Cell[77550, 2735, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindFit::nlnrm"],
    Cell[77634, 2738, 382, 7, 53, "Message",
      CellTags->"FindFit::nlnrm"],
    Cell[78019, 2747, 125, 4, 24, "Notes",
      CellTags->"FindFit::nlnrm"]},
  "FindFit::lmnl"->{
    Cell[78181, 2756, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindFit::lmnl"],
    Cell[78263, 2759, 296, 5, 53, "Message",
      CellTags->"FindFit::lmnl"],
    Cell[78562, 2766, 124, 4, 24, "Notes",
      CellTags->"FindFit::lmnl"]},
  "FindFit::nlmod"->{
    Cell[78723, 2775, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindFit::nlmod"],
    Cell[78807, 2778, 280, 5, 37, "Message",
      CellTags->"FindFit::nlmod"],
    Cell[79090, 2785, 125, 4, 24, "Notes",
      CellTags->"FindFit::nlmod"]},
  "FindRoot::frns"->{
    Cell[79252, 2794, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::frns"],
    Cell[79336, 2797, 338, 9, 21, "Message",
      CellTags->"FindRoot::frns"],
    Cell[79677, 2808, 233, 6, 24, "Notes",
      CellTags->"FindRoot::frns"]},
  "FindMinimum::fdvc"->{
    Cell[79947, 2819, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80158, 2829, 611, 18, 21, "Message",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80772, 2849, 526, 12, 78, "Notes",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}]},
  "FindMaximum::fdvc"->{
    Cell[79947, 2819, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80158, 2829, 611, 18, 21, "Message",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80772, 2849, 526, 12, 78, "Notes",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}]},
  "FindFit::fdvc"->{
    Cell[79947, 2819, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80158, 2829, 611, 18, 21, "Message",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80772, 2849, 526, 12, 78, "Notes",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}]},
  "FindRoot::fdvc"->{
    Cell[79947, 2819, 208, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80158, 2829, 611, 18, 21, "Message",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}],
    Cell[80772, 2849, 526, 12, 78, "Notes",
      CellTags->{
      "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
        "FindRoot::fdvc"}]},
  "FindMinimum::fmdig"->{
    Cell[81335, 2866, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[81511, 2873, 525, 13, 37, "Message",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82039, 2888, 461, 10, 62, "Notes",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82525, 2902, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82638, 2905, 187, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82850, 2913, 165, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83018, 2918, 289, 5, 37, "Message",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],
    Cell[83310, 2925, 190, 3, 23, "Output",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],
    Cell[83515, 2931, 175, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83715, 2939, 168, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83886, 2944, 191, 3, 23, "Output",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}]},
  "FindMaximum::fmdig"->{
    Cell[81335, 2866, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[81511, 2873, 525, 13, 37, "Message",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82039, 2888, 461, 10, 62, "Notes",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82525, 2902, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82638, 2905, 187, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82850, 2913, 165, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83018, 2918, 289, 5, 37, "Message",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],
    Cell[83310, 2925, 190, 3, 23, "Output",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],
    Cell[83515, 2931, 175, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83715, 2939, 168, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83886, 2944, 191, 3, 23, "Output",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}]},
  "FindFit::fmdig"->{
    Cell[81335, 2866, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[81511, 2873, 525, 13, 37, "Message",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82039, 2888, 461, 10, 62, "Notes",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82525, 2902, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82638, 2905, 187, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[82850, 2913, 165, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83018, 2918, 289, 5, 37, "Message",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],
    Cell[83310, 2925, 190, 3, 23, "Output",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],
    Cell[83515, 2931, 175, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83715, 2939, 168, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
    Cell[83886, 2944, 191, 3, 23, "Output",
      CellTags->{
      "FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}]},
  "Fit::fitc"->{
    Cell[84138, 2954, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fit::fitc", "FindFit::fitc"}],
    Cell[84253, 2960, 679, 20, 21, "Message",
      CellTags->{"Fit::fitc", "FindFit::fitc"}],
    Cell[84935, 2982, 650, 14, 94, "Notes",
      CellTags->{"Fit::fitc", "FindFit::fitc"}]},
  "FindFit::fitc"->{
    Cell[84138, 2954, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fit::fitc", "FindFit::fitc"}],
    Cell[84253, 2960, 679, 20, 21, "Message",
      CellTags->{"Fit::fitc", "FindFit::fitc"}],
    Cell[84935, 2982, 650, 14, 94, "Notes",
      CellTags->{"Fit::fitc", "FindFit::fitc"}]},
  "Fit::fitd"->{
    Cell[85622, 3001, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[85737, 3007, 410, 12, 21, "Message",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86150, 3021, 419, 9, 62, "Notes",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86594, 3034, 78, 1, 38, "ExampleSection",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86675, 3037, 143, 4, 24, "Text",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86843, 3045, 131, 3, 26, "Input",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86977, 3050, 214, 5, 21, "Message",
      CellTags->{"FindFit::fitd", "Fit::fitd"}],
    Cell[87194, 3057, 128, 3, 21, "Output",
      CellTags->{"FindFit::fitd", "Fit::fitd"}],
    Cell[87337, 3063, 138, 5, 24, "Text",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[87500, 3072, 132, 3, 26, "Input",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[87635, 3077, 183, 4, 21, "Output",
      CellTags->{"FindFit::fitd", "Fit::fitd"}]},
  "FindFit::fitd"->{
    Cell[85622, 3001, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[85737, 3007, 410, 12, 21, "Message",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86150, 3021, 419, 9, 62, "Notes",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86594, 3034, 78, 1, 38, "ExampleSection",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86675, 3037, 143, 4, 24, "Text",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86843, 3045, 131, 3, 26, "Input",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[86977, 3050, 214, 5, 21, "Message",
      CellTags->{"FindFit::fitd", "Fit::fitd"}],
    Cell[87194, 3057, 128, 3, 21, "Output",
      CellTags->{"FindFit::fitd", "Fit::fitd"}],
    Cell[87337, 3063, 138, 5, 24, "Text",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[87500, 3072, 132, 3, 26, "Input",
      CellTags->{"Fit::fitd", "FindFit::fitd"}],
    Cell[87635, 3077, 183, 4, 21, "Output",
      CellTags->{"FindFit::fitd", "Fit::fitd"}]},
  "FindMinimum::fmgs"->{
    Cell[87879, 3088, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
    Cell[88049, 3095, 446, 11, 37, "Message",
      CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
    Cell[88498, 3108, 666, 14, 100, "Notes",
      CellTags->{
      "FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}]},
  "FindMaximum::fmgs"->{
    Cell[87879, 3088, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
    Cell[88049, 3095, 446, 11, 37, "Message",
      CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
    Cell[88498, 3108, 666, 14, 100, "Notes",
      CellTags->{
      "FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}]},
  "FindFit::fmgs"->{
    Cell[87879, 3088, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
    Cell[88049, 3095, 446, 11, 37, "Message",
      CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
    Cell[88498, 3108, 666, 14, 100, "Notes",
      CellTags->{
      "FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}]},
  "FindMinimum::fmwar"->{
    Cell[89201, 3127, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[89377, 3134, 414, 10, 37, "Message",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[89794, 3146, 695, 19, 78, "Notes",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90514, 3169, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90627, 3172, 212, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90864, 3180, 181, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91048, 3185, 306, 5, 53, "Message",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],
    Cell[91357, 3192, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],
    Cell[91549, 3198, 210, 5, 24, "Text",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91784, 3207, 178, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91965, 3212, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}]},
  "FindMaximum::fmwar"->{
    Cell[89201, 3127, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[89377, 3134, 414, 10, 37, "Message",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[89794, 3146, 695, 19, 78, "Notes",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90514, 3169, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90627, 3172, 212, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90864, 3180, 181, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91048, 3185, 306, 5, 53, "Message",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],
    Cell[91357, 3192, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],
    Cell[91549, 3198, 210, 5, 24, "Text",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91784, 3207, 178, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91965, 3212, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}]},
  "FindFit::fmwar"->{
    Cell[89201, 3127, 173, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[89377, 3134, 414, 10, 37, "Message",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[89794, 3146, 695, 19, 78, "Notes",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90514, 3169, 110, 1, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90627, 3172, 212, 4, 24, "Text",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[90864, 3180, 181, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91048, 3185, 306, 5, 53, "Message",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],
    Cell[91357, 3192, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],
    Cell[91549, 3198, 210, 5, 24, "Text",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91784, 3207, 178, 3, 26, "Input",
      CellTags->{
      "FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
    Cell[91965, 3212, 177, 3, 21, "Output",
      CellTags->{
      "FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}]},
  "FindMinimum::regex"->{
    Cell[92203, 3222, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92422, 3232, 405, 12, 21, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92830, 3246, 730, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93585, 3272, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93725, 3277, 227, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93977, 3287, 218, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94198, 3294, 330, 7, 37, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94531, 3303, 221, 6, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94767, 3312, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95003, 3322, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95199, 3329, 204, 5, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}]},
  "FindMaximum::regex"->{
    Cell[92203, 3222, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92422, 3232, 405, 12, 21, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92830, 3246, 730, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93585, 3272, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93725, 3277, 227, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93977, 3287, 218, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94198, 3294, 330, 7, 37, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94531, 3303, 221, 6, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94767, 3312, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95003, 3322, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95199, 3329, 204, 5, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}]},
  "FindFit::regex"->{
    Cell[92203, 3222, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92422, 3232, 405, 12, 21, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92830, 3246, 730, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93585, 3272, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93725, 3277, 227, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93977, 3287, 218, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94198, 3294, 330, 7, 37, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94531, 3303, 221, 6, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94767, 3312, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95003, 3322, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95199, 3329, 204, 5, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}]},
  "FindRoot::regex"->{
    Cell[92203, 3222, 216, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92422, 3232, 405, 12, 21, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[92830, 3246, 730, 22, 46, "Notes",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93585, 3272, 137, 3, 38, "ExampleSection",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93725, 3277, 227, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[93977, 3287, 218, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94198, 3294, 330, 7, 37, "Message",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94531, 3303, 221, 6, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[94767, 3312, 211, 6, 24, "Text",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95003, 3322, 193, 5, 26, "Input",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}],
    Cell[95199, 3329, 204, 5, 21, "Output",
      CellTags->{
      "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
        "FindRoot::regex"}]},
  "Fit::fitm"->{
    Cell[95464, 3341, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fit::fitm", "FindFit::fitm"}],
    Cell[95579, 3347, 411, 11, 37, "Message",
      CellTags->{"FindFit::fitm", "Fit::fitm"}],
    Cell[95993, 3360, 379, 7, 62, "Notes",
      CellTags->{"Fit::fitm", "FindFit::fitm"}]},
  "FindFit::fitm"->{
    Cell[95464, 3341, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fit::fitm", "FindFit::fitm"}],
    Cell[95579, 3347, 411, 11, 37, "Message",
      CellTags->{"FindFit::fitm", "Fit::fitm"}],
    Cell[95993, 3360, 379, 7, 62, "Notes",
      CellTags->{"Fit::fitm", "FindFit::fitm"}]},
  "FindMinimum::fmhs"->{
    Cell[96409, 3372, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
    Cell[96579, 3379, 436, 11, 37, "Message",
      CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
    Cell[97018, 3392, 575, 13, 78, "Notes",
      CellTags->{
      "FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}]},
  "FindMaximum::fmhs"->{
    Cell[96409, 3372, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
    Cell[96579, 3379, 436, 11, 37, "Message",
      CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
    Cell[97018, 3392, 575, 13, 78, "Notes",
      CellTags->{
      "FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}]},
  "FindFit::fmhs"->{
    Cell[96409, 3372, 167, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
    Cell[96579, 3379, 436, 11, 37, "Message",
      CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
    Cell[97018, 3392, 575, 13, 78, "Notes",
      CellTags->{
      "FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}]},
  "General::ngnum"->{
    Cell[97630, 3410, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ngnum"],
    Cell[97714, 3413, 331, 10, 21, "Message",
      CellTags->"General::ngnum"],
    Cell[98048, 3425, 500, 10, 62, "Notes",
      CellTags->"General::ngnum"],
    Cell[98573, 3439, 64, 1, 38, "ExampleSection",
      CellTags->"General::ngnum"],
    Cell[98640, 3442, 168, 5, 24, "Text",
      CellTags->"General::ngnum"],
    Cell[98833, 3451, 170, 4, 26, "Input",
      CellTags->"General::ngnum"],
    Cell[99006, 3457, 209, 5, 21, "Message",
      CellTags->"General::ngnum"],
    Cell[99218, 3464, 110, 3, 21, "Output",
      CellTags->"General::ngnum"],
    Cell[99343, 3470, 180, 4, 24, "Text",
      CellTags->"General::ngnum"],
    Cell[99548, 3478, 117, 3, 26, "Input",
      CellTags->"General::ngnum"],
    Cell[99668, 3483, 110, 3, 21, "Output",
      CellTags->"General::ngnum"],
    Cell[99793, 3489, 167, 4, 24, "Text",
      CellTags->"General::ngnum"],
    Cell[99985, 3497, 117, 3, 26, "Input",
      CellTags->"General::ngnum"],
    Cell[100105, 3502, 180, 4, 40, "Message",
      CellTags->"General::ngnum"],
    Cell[100288, 3508, 206, 5, 21, "Message",
      CellTags->"General::ngnum"],
    Cell[100497, 3515, 103, 3, 21, "Output",
      CellTags->"General::ngnum"],
    Cell[100615, 3521, 121, 4, 24, "Text",
      CellTags->"General::ngnum"],
    Cell[100761, 3529, 117, 3, 26, "Input",
      CellTags->"General::ngnum"],
    Cell[100881, 3534, 103, 3, 21, "Output",
      CellTags->"General::ngnum"]},
  "General::ngnum1"->{
    Cell[101045, 3544, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ngnum1"],
    Cell[101131, 3547, 347, 10, 21, "Message",
      CellTags->"General::ngnum1"],
    Cell[101481, 3559, 126, 4, 24, "Notes",
      CellTags->"General::ngnum1"]},
  "FindFit::notlm"->{
    Cell[101644, 3568, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[101779, 3574, 468, 12, 53, "Message",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[102250, 3588, 322, 9, 40, "Notes",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[102597, 3601, 88, 1, 38, "ExampleSection",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[102688, 3604, 295, 8, 40, "Text",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103008, 3616, 212, 4, 26, "Input",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103223, 3622, 331, 6, 69, "Message",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103557, 3630, 215, 4, 23, "Output",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103787, 3637, 192, 5, 24, "Text",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[104004, 3646, 215, 4, 42, "Input",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[104222, 3652, 149, 3, 21, "Output",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}]},
  "FindMinimum::notlm"->{
    Cell[101644, 3568, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[101779, 3574, 468, 12, 53, "Message",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[102250, 3588, 322, 9, 40, "Notes",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[102597, 3601, 88, 1, 38, "ExampleSection",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[102688, 3604, 295, 8, 40, "Text",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103008, 3616, 212, 4, 26, "Input",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103223, 3622, 331, 6, 69, "Message",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103557, 3630, 215, 4, 23, "Output",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[103787, 3637, 192, 5, 24, "Text",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[104004, 3646, 215, 4, 42, "Input",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
    Cell[104222, 3652, 149, 3, 21, "Output",
      CellTags->{"FindFit::notlm", "FindMinimum::notlm"}]},
  "FindMaximum::notlm"->{
    Cell[104432, 3662, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindMaximum::notlm"],
    Cell[104524, 3665, 443, 9, 53, "Message",
      CellTags->"FindMaximum::notlm"],
    Cell[104970, 3676, 268, 7, 40, "Notes",
      CellTags->"FindMaximum::notlm"],
    Cell[105263, 3687, 68, 1, 38, "ExampleSection",
      CellTags->"FindMaximum::notlm"],
    Cell[105334, 3690, 269, 7, 40, "Text",
      CellTags->"FindMaximum::notlm"],
    Cell[105628, 3701, 188, 4, 26, "Input",
      CellTags->"FindMaximum::notlm"],
    Cell[105819, 3707, 312, 6, 69, "Message",
      CellTags->"FindMaximum::notlm"],
    Cell[106134, 3715, 191, 4, 23, "Output",
      CellTags->"FindMaximum::notlm"],
    Cell[106340, 3722, 172, 5, 24, "Text",
      CellTags->"FindMaximum::notlm"],
    Cell[106537, 3731, 195, 4, 42, "Input",
      CellTags->"FindMaximum::notlm"],
    Cell[106735, 3737, 129, 3, 21, "Output",
      CellTags->"FindMaximum::notlm"]},
  "FindRoot::zdamp"->{
    Cell[106925, 3747, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FindRoot::zdamp"],
    Cell[107011, 3750, 210, 5, 37, "Message",
      CellTags->"FindRoot::zdamp"],
    Cell[107224, 3757, 226, 7, 24, "Notes",
      CellTags->"FindRoot::zdamp"],
    Cell[107475, 3768, 65, 1, 38, "ExampleSection",
      CellTags->"FindRoot::zdamp"],
    Cell[107543, 3771, 192, 5, 24, "Text",
      CellTags->"FindRoot::zdamp"],
    Cell[107760, 3780, 142, 3, 26, "Input",
      CellTags->"FindRoot::zdamp"],
    Cell[107905, 3785, 214, 5, 37, "Message",
      CellTags->"FindRoot::zdamp"],
    Cell[108122, 3792, 143, 3, 21, "Output",
      CellTags->"FindRoot::zdamp"],
    Cell[108280, 3798, 145, 5, 24, "Text",
      CellTags->"FindRoot::zdamp"],
    Cell[108450, 3807, 141, 3, 26, "Input",
      CellTags->"FindRoot::zdamp"],
    Cell[108594, 3812, 118, 3, 21, "Output",
      CellTags->"FindRoot::zdamp"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"FindFit::bdmtd", 109429, 3838},
  {"FindMinimum::bdmtd", 110904, 3872},
  {"FindMaximum::bdmtd", 112379, 3906},
  {"FindMinimum::initf", 113854, 3940},
  {"FindMaximum::initf", 114371, 3953},
  {"FindFit::initf", 114884, 3966},
  {"NDSolve::initf", 115397, 3979},
  {"FindMinimum::fddis", 115914, 3992},
  {"FindMaximum::fddis", 117702, 4037},
  {"FindFit::fddis", 119486, 4082},
  {"FindRoot::fddis", 121271, 4127},
  {"FindMinimum::fdin", 123058, 4172},
  {"FindMaximum::fdin", 124808, 4217},
  {"FindFit::fdin", 126554, 4262},
  {"FindRoot::fdin", 128301, 4307},
  {"FindFit::fdss", 130047, 4352},
  {"FindMinimum::fdss", 130322, 4359},
  {"FindMaximum::fdss", 131770, 4393},
  {"FindRoot::fdss", 133215, 4427},
  {"FindMinimum::fmgl", 134663, 4461},
  {"FindMaximum::fmgl", 135079, 4469},
  {"FindFit::fmgl", 135491, 4477},
  {"FindMinimum::nzres", 135908, 4485},
  {"FindMaximum::nzres", 136348, 4495},
  {"FindFit::nzres", 136784, 4505},
  {"FindMinimum::sctl", 137223, 4515},
  {"FindMaximum::sctl", 137638, 4523},
  {"FindFit::sctl", 138049, 4531},
  {"FindRoot::sctl", 138461, 4539},
  {"FindMinimum::lmtrst", 138741, 4546},
  {"FindMaximum::lmtrst", 139190, 4556},
  {"FindFit::lmtrst", 139635, 4566},
  {"FindMinimum::lmotrst", 140085, 4576},
  {"FindMaximum::lmotrst", 140545, 4586},
  {"FindFit::lmotrst", 141001, 4596},
  {"FindFit::sdprec", 141456, 4606},
  {"FindMinimum::sdprec", 141816, 4613},
  {"FindRoot::sdprec", 142173, 4620},
  {"FindMinimum::lstol", 142458, 4627},
  {"FindFit::lstol", 143161, 4644},
  {"FindRoot::lstol", 143437, 4651},
  {"FindMinimum::lsbrak", 144512, 4678},
  {"FindRoot::btf", 144801, 4685},
  {"FindMinimum::btf", 145299, 4698},
  {"FindMaximum::btf", 145797, 4711},
  {"FindFit::btf", 146291, 4724},
  {"FindMinimum::bddir", 146791, 4737},
  {"FindFit::bddir", 147140, 4744},
  {"FindMaximum::bddir", 147493, 4751},
  {"FindRoot::bddir", 147781, 4758},
  {"FindMaximum::fmgz", 148063, 4765},
  {"FindMinimum::fmgz", 149011, 4788},
  {"FindMinimum::fmmp", 149959, 4811},
  {"FindMaximum::fmmp", 150379, 4819},
  {"FindFit::fmmp", 150795, 4827},
  {"FindRoot::fdst", 151212, 4835},
  {"FindMinimum::fdst", 151727, 4848},
  {"FindMaximum::fdst", 152242, 4861},
  {"FindFit::fdst", 152753, 4874},
  {"FindRoot::frdig", 153266, 4887},
  {"FindRoot::frmp", 153550, 4894},
  {"FindRoot::jsing", 153831, 4901},
  {"FindMinimum::lss", 155074, 4932},
  {"FindMaximum::lss", 155478, 4939},
  {"FindRoot::lss", 155879, 4946},
  {"FindFit::lss", 156279, 4953},
  {"FindFit::precw", 156551, 4960},
  {"FindMinimum::srect", 156833, 4967},
  {"FindMaximum::srect", 158645, 5012},
  {"FindFit::srect", 160453, 5057},
  {"FindRoot::srect", 162262, 5102},
  {"FindMinimum::scdims", 164075, 5147},
  {"FindMaximum::scdims", 164615, 5160},
  {"FindFit::scdims", 165151, 5173},
  {"FindRoot::scdims", 165688, 5186},
  {"FindMinimum::snum", 166226, 5199},
  {"FindMaximum::snum", 166739, 5212},
  {"FindFit::snum", 167248, 5225},
  {"FindRoot::snum", 167758, 5238},
  {"FindMinimum::fdssnv", 168273, 5251},
  {"FindMaximum::fdssnv", 168813, 5264},
  {"FindRoot::fdssnv", 169350, 5277},
  {"FindFit::fdssnv", 169886, 5290},
  {"FindMinimum::bbound", 170426, 5303},
  {"FindMaximum::bbound", 173425, 5376},
  {"FindFit::bbound", 176420, 5449},
  {"FindRoot::bbound", 179416, 5522},
  {"FindMinimum::linf", 182413, 5595},
  {"FindMaximum::linf", 182927, 5608},
  {"FindFit::linf", 183437, 5621},
  {"FindRoot::linf", 183948, 5634},
  {"FindMinimum::uinf", 184462, 5647},
  {"FindMaximum::uinf", 184976, 5660},
  {"FindFit::uinf", 185486, 5673},
  {"FindRoot::uinf", 185997, 5686},
  {"FindMinimum::cvmit", 186512, 5699},
  {"FindMaximum::cvmit", 190872, 5808},
  {"FindFit::cvmit", 195228, 5917},
  {"FindRoot::cvmit", 199585, 6026},
  {"FindMaximum::sdprec", 203946, 6135},
  {"FindMaximum::lstol", 204243, 6142},
  {"FindMaximum::lsbrak", 204538, 6149},
  {"FindMinimum::prax2", 204835, 6156},
  {"FindMaximum::prax2", 205277, 6166},
  {"FindFit::prax2", 205715, 6176},
  {"FindMinimum::regex1", 206158, 6186},
  {"FindMaximum::regex1", 206699, 6199},
  {"FindFit::regex1", 207236, 6212},
  {"FindRoot::regex1", 207774, 6225},
  {"FindMinimum::reged", 208314, 6238},
  {"FindMaximum::reged", 210125, 6283},
  {"FindFit::reged", 211932, 6328},
  {"FindRoot::reged", 213740, 6373},
  {"FindMinimum::streg", 215551, 6418},
  {"FindMaximum::streg", 216077, 6431},
  {"FindFit::streg", 216599, 6444},
  {"FindRoot::streg", 217122, 6457},
  {"FindFit::sszero", 217645, 6470},
  {"FindMinimum::sszero", 218008, 6477},
  {"FindMaximum::sszero", 218371, 6484},
  {"FindRoot::sszero", 218666, 6491},
  {"FindMinimum::stfail", 218955, 6498},
  {"FindMaximum::stfail", 219494, 6511},
  {"FindFit::stfail", 220029, 6524},
  {"FindRoot::stfail", 220565, 6537},
  {"FindMinimum::umtd", 221102, 6550},
  {"FindMaximum::umtd", 221520, 6558},
  {"FindFit::umtd", 221934, 6566},
  {"FindRoot::umtd", 222349, 6574},
  {"FindRoot::bdmtd", 222628, 6581},
  {"FindRoot::eqlist", 222911, 6588},
  {"FindRoot::sec2", 223195, 6595},
  {"FindRoot::bbrac", 223474, 6602},
  {"FindRoot::frn2", 223755, 6609},
  {"FindRoot::jsing1", 224035, 6616},
  {"FindRoot::nveq", 224319, 6623},
  {"FindFit::nlnrm", 224597, 6630},
  {"FindFit::lmnl", 224874, 6637},
  {"FindFit::nlmod", 225149, 6644},
  {"FindRoot::frns", 225427, 6651},
  {"FindMinimum::fdvc", 225708, 6658},
  {"FindMaximum::fdvc", 226223, 6671},
  {"FindFit::fdvc", 226734, 6684},
  {"FindRoot::fdvc", 227246, 6697},
  {"FindMinimum::fmdig", 227762, 6710},
  {"FindMaximum::fmdig", 229265, 6744},
  {"FindFit::fmdig", 230764, 6778},
  {"Fit::fitc", 232258, 6812},
  {"FindFit::fitc", 232580, 6819},
  {"Fit::fitd", 232898, 6826},
  {"FindFit::fitd", 233965, 6849},
  {"FindMinimum::fmgs", 235036, 6872},
  {"FindMaximum::fmgs", 235457, 6880},
  {"FindFit::fmgs", 235874, 6888},
  {"FindMinimum::fmwar", 236296, 6896},
  {"FindMaximum::fmwar", 237799, 6930},
  {"FindFit::fmwar", 239298, 6964},
  {"FindMinimum::regex", 240801, 6998},
  {"FindMaximum::regex", 242612, 7043},
  {"FindFit::regex", 244419, 7088},
  {"FindRoot::regex", 246227, 7133},
  {"Fit::fitm", 248029, 7178},
  {"FindFit::fitm", 248350, 7185},
  {"FindMinimum::fmhs", 248675, 7192},
  {"FindMaximum::fmhs", 249095, 7200},
  {"FindFit::fmhs", 249511, 7208},
  {"General::ngnum", 249928, 7216},
  {"General::ngnum1", 251477, 7255},
  {"FindFit::notlm", 251762, 7262},
  {"FindMinimum::notlm", 252955, 7285},
  {"FindMaximum::notlm", 254148, 7308},
  {"FindRoot::zdamp", 255116, 7331}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 41, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1842, 57, 173, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
Cell[2018, 64, 461, 11, 53, "Message",
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
Cell[2482, 77, 263, 5, 24, "Notes",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[CellGroupData[{
Cell[2770, 86, 110, 1, 38, "ExampleSection",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
Cell[2883, 89, 273, 8, 24, "Text",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[CellGroupData[{
Cell[3181, 101, 174, 3, 26, "Input",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
Cell[3358, 106, 329, 6, 53, "Message",
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}],
Cell[3690, 114, 180, 3, 21, "Output",
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}]
}, Open  ]],
Cell[3885, 120, 223, 7, 24, "Text",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],

Cell[CellGroupData[{
Cell[4133, 131, 179, 3, 26, "Input",
  CellTags->{"FindFit::bdmtd", "FindMinimum::bdmtd", "FindMaximum::bdmtd"}],
Cell[4315, 136, 177, 3, 21, "Output",
  CellTags->{"FindFit::bdmtd", "FindMaximum::bdmtd", "FindMinimum::bdmtd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4553, 146, 214, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
    "NDSolve::initf"}],
Cell[4770, 156, 324, 9, 21, "Message",
  CellTags->{
  "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
    "NDSolve::initf"}],
Cell[5097, 167, 197, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::initf", "FindMaximum::initf", "FindFit::initf", 
    "NDSolve::initf"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5331, 178, 216, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],
Cell[5550, 188, 577, 16, 21, "Message",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],
Cell[6130, 206, 239, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[CellGroupData[{
Cell[6394, 216, 137, 3, 38, "ExampleSection",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],
Cell[6534, 221, 223, 6, 24, "Text",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[CellGroupData[{
Cell[6782, 231, 189, 5, 26, "Input",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],
Cell[6974, 238, 310, 7, 37, "Message",
  CellTags->{
  "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
    "FindRoot::fddis"}],
Cell[7287, 247, 190, 5, 21, "Output",
  CellTags->{
  "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
    "FindRoot::fddis"}]
}, Open  ]],
Cell[7492, 255, 208, 7, 24, "Text",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],

Cell[CellGroupData[{
Cell[7725, 266, 189, 5, 26, "Input",
  CellTags->{
  "FindMinimum::fddis", "FindMaximum::fddis", "FindFit::fddis", 
    "FindRoot::fddis"}],
Cell[7917, 273, 190, 5, 21, "Output",
  CellTags->{
  "FindFit::fddis", "FindMaximum::fddis", "FindMinimum::fddis", 
    "FindRoot::fddis"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8168, 285, 208, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],
Cell[8379, 295, 568, 15, 37, "Message",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],
Cell[8950, 312, 586, 14, 62, "Notes",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],

Cell[CellGroupData[{
Cell[9561, 330, 133, 3, 38, "ExampleSection",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],
Cell[9697, 335, 285, 7, 40, "Text",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],

Cell[CellGroupData[{
Cell[10007, 346, 203, 5, 26, "Input",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],
Cell[10213, 353, 406, 8, 53, "Message",
  CellTags->{
  "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
    "FindRoot::fdin"}],
Cell[10622, 363, 204, 5, 21, "Output",
  CellTags->{
  "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
    "FindRoot::fdin"}]
}, Open  ]],
Cell[10841, 371, 212, 7, 24, "Text",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],

Cell[CellGroupData[{
Cell[11078, 382, 208, 5, 26, "Input",
  CellTags->{
  "FindMinimum::fdin", "FindMaximum::fdin", "FindFit::fdin", 
    "FindRoot::fdin"}],
Cell[11289, 389, 239, 6, 21, "Output",
  CellTags->{
  "FindFit::fdin", "FindMaximum::fdin", "FindMinimum::fdin", 
    "FindRoot::fdin"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11589, 402, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindFit::fdss"],
Cell[11671, 405, 185, 3, 21, "Message",
  CellTags->"FindFit::fdss"],
Cell[11859, 410, 124, 4, 24, "Notes",
  CellTags->"FindFit::fdss"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12020, 419, 169, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
Cell[12192, 426, 508, 13, 21, "Message",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
Cell[12703, 441, 220, 4, 24, "Notes",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[CellGroupData[{
Cell[12948, 449, 108, 1, 38, "ExampleSection",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
Cell[13059, 452, 246, 5, 24, "Text",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[CellGroupData[{
Cell[13330, 461, 159, 3, 26, "Input",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
Cell[13492, 466, 248, 5, 21, "Message",
  CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}],
Cell[13743, 473, 166, 3, 21, "Output",
  CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}]
}, Open  ]],
Cell[13924, 479, 188, 5, 24, "Text",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],

Cell[CellGroupData[{
Cell[14137, 488, 164, 3, 26, "Input",
  CellTags->{"FindMinimum::fdss", "FindMaximum::fdss", "FindRoot::fdss"}],
Cell[14304, 493, 163, 3, 21, "Output",
  CellTags->{"FindMaximum::fdss", "FindMinimum::fdss", "FindRoot::fdss"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14528, 503, 167, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
Cell[14698, 510, 668, 19, 21, "Message",
  CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}],
Cell[15369, 531, 458, 8, 62, "Notes",
  CellTags->{"FindMinimum::fmgl", "FindMaximum::fmgl", "FindFit::fmgl"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15864, 544, 173, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
Cell[16040, 551, 611, 13, 69, "Message",
  CellTags->{"FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}],
Cell[16654, 566, 171, 4, 24, "Notes",
  CellTags->{"FindMinimum::nzres", "FindMaximum::nzres", "FindFit::nzres"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16862, 575, 167, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
Cell[17032, 582, 369, 8, 37, "Message",
  CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}],
Cell[17404, 592, 168, 4, 24, "Notes",
  CellTags->{"FindMinimum::sctl", "FindMaximum::sctl", "FindFit::sctl"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17609, 601, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::sctl"],
Cell[17693, 604, 226, 4, 37, "Message",
  CellTags->"FindRoot::sctl"],
Cell[17922, 610, 125, 4, 24, "Notes",
  CellTags->"FindRoot::sctl"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18084, 619, 179, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
Cell[18266, 626, 378, 8, 53, "Message",
  CellTags->{
  "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}],
Cell[18647, 636, 174, 4, 24, "Notes",
  CellTags->{
  "FindMinimum::lmtrst", "FindMaximum::lmtrst", "FindFit::lmtrst"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[18858, 645, 188, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
Cell[19049, 653, 406, 10, 37, "Message",
  CellTags->{
  "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}],
Cell[19458, 665, 180, 5, 24, "Notes",
  CellTags->{
  "FindMinimum::lmotrst", "FindMaximum::lmotrst", "FindFit::lmotrst"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19675, 675, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],
Cell[19814, 681, 394, 10, 37, "Message",
  CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}],
Cell[20211, 693, 151, 4, 24, "Notes",
  CellTags->{"FindFit::sdprec", "FindMinimum::sdprec"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20399, 702, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::sdprec"],
Cell[20487, 705, 240, 4, 37, "Message",
  CellTags->"FindRoot::sdprec"],
Cell[20730, 711, 127, 4, 24, "Notes",
  CellTags->"FindRoot::sdprec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20894, 720, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMinimum::lstol"],
Cell[20986, 723, 419, 6, 53, "Message",
  CellTags->"FindMinimum::lstol"],
Cell[21408, 731, 415, 10, 62, "Notes",
  CellTags->"FindMinimum::lstol"],

Cell[CellGroupData[{
Cell[21848, 745, 68, 1, 38, "ExampleSection",
  CellTags->"FindMinimum::lstol"],
Cell[21919, 748, 169, 4, 24, "Text",
  CellTags->"FindMinimum::lstol"],

Cell[CellGroupData[{
Cell[22113, 756, 166, 4, 26, "Input",
  CellTags->"FindMinimum::lstol"],
Cell[22282, 762, 416, 7, 85, "Message",
  CellTags->"FindMinimum::lstol"],
Cell[22701, 771, 149, 3, 23, "Output",
  CellTags->"FindMinimum::lstol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22911, 781, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindFit::lstol"],
Cell[22995, 784, 426, 6, 69, "Message",
  CellTags->"FindFit::lstol"],
Cell[23424, 792, 125, 4, 24, "Notes",
  CellTags->"FindFit::lstol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23586, 801, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::lstol"],
Cell[23672, 804, 420, 6, 53, "Message",
  CellTags->"FindRoot::lstol"],
Cell[24095, 812, 462, 11, 62, "Notes",
  CellTags->"FindRoot::lstol"],

Cell[CellGroupData[{
Cell[24582, 827, 65, 1, 38, "ExampleSection",
  CellTags->"FindRoot::lstol"],
Cell[24650, 830, 146, 4, 24, "Text",
  CellTags->"FindRoot::lstol"],

Cell[CellGroupData[{
Cell[24821, 838, 117, 3, 26, "Input",
  CellTags->"FindRoot::lstol"],
Cell[24941, 843, 418, 8, 85, "Message",
  CellTags->"FindRoot::lstol"],
Cell[25362, 853, 126, 3, 21, "Output",
  CellTags->"FindRoot::lstol"]
}, Open  ]],
Cell[25503, 859, 121, 4, 24, "Text",
  CellTags->"FindRoot::lstol"],

Cell[CellGroupData[{
Cell[25649, 867, 117, 3, 26, "Input",
  CellTags->"FindRoot::lstol"],
Cell[25769, 872, 149, 4, 21, "Output",
  CellTags->"FindRoot::lstol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25955, 881, 122, 3, 26, "Input",
  CellTags->"FindRoot::lstol"],
Cell[26080, 886, 149, 4, 21, "Output",
  CellTags->"FindRoot::lstol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26290, 897, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMinimum::lsbrak"],
Cell[26384, 900, 211, 4, 21, "Message",
  CellTags->"FindMinimum::lsbrak"],
Cell[26598, 906, 130, 4, 24, "Notes",
  CellTags->"FindMinimum::lsbrak"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26765, 915, 195, 7, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", "FindFit::btf"}],
Cell[26963, 924, 399, 10, 37, "Message",
  CellTags->{
  "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", "FindFit::btf"}],
Cell[27365, 936, 185, 5, 24, "Notes",
  CellTags->{
  "FindRoot::btf", "FindMinimum::btf", "FindMaximum::btf", "FindFit::btf"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[27587, 946, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],
Cell[27722, 952, 472, 10, 53, "Message",
  CellTags->{"FindMinimum::bddir", "FindFit::bddir"}],
Cell[28197, 964, 149, 4, 24, "Notes",
  CellTags->{"FindMinimum::bddir", "FindFit::bddir"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[28383, 973, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMaximum::bddir"],
Cell[28475, 976, 369, 6, 53, "Message",
  CellTags->"FindMaximum::bddir"],
Cell[28847, 984, 129, 4, 24, "Notes",
  CellTags->"FindMaximum::bddir"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29013, 993, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::bddir"],
Cell[29099, 996, 277, 5, 37, "Message",
  CellTags->"FindRoot::bddir"],
Cell[29379, 1003, 126, 4, 24, "Notes",
  CellTags->"FindRoot::bddir"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29542, 1012, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMaximum::fmgz"],
Cell[29632, 1015, 276, 5, 53, "Message",
  CellTags->"FindMaximum::fmgz"],
Cell[29911, 1022, 396, 8, 62, "Notes",
  CellTags->"FindMaximum::fmgz"],

Cell[CellGroupData[{
Cell[30332, 1034, 67, 1, 38, "ExampleSection",
  CellTags->"FindMaximum::fmgz"],
Cell[30402, 1037, 148, 4, 24, "Text",
  CellTags->"FindMaximum::fmgz"],

Cell[CellGroupData[{
Cell[30575, 1045, 138, 3, 26, "Input",
  CellTags->"FindMaximum::fmgz"],
Cell[30716, 1050, 274, 5, 53, "Message",
  CellTags->"FindMaximum::fmgz"],
Cell[30993, 1057, 128, 3, 21, "Output",
  CellTags->"FindMaximum::fmgz"]
}, Open  ]],
Cell[31136, 1063, 140, 4, 24, "Text",
  CellTags->"FindMaximum::fmgz"],

Cell[CellGroupData[{
Cell[31301, 1071, 138, 3, 26, "Input",
  CellTags->"FindMaximum::fmgz"],
Cell[31442, 1076, 146, 3, 21, "Output",
  CellTags->"FindMaximum::fmgz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31649, 1086, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMinimum::fmgz"],
Cell[31739, 1089, 276, 5, 53, "Message",
  CellTags->"FindMinimum::fmgz"],
Cell[32018, 1096, 396, 8, 62, "Notes",
  CellTags->"FindMinimum::fmgz"],

Cell[CellGroupData[{
Cell[32439, 1108, 67, 1, 38, "ExampleSection",
  CellTags->"FindMinimum::fmgz"],
Cell[32509, 1111, 148, 4, 24, "Text",
  CellTags->"FindMinimum::fmgz"],

Cell[CellGroupData[{
Cell[32682, 1119, 138, 3, 26, "Input",
  CellTags->"FindMinimum::fmgz"],
Cell[32823, 1124, 274, 5, 53, "Message",
  CellTags->"FindMinimum::fmgz"],
Cell[33100, 1131, 128, 3, 21, "Output",
  CellTags->"FindMinimum::fmgz"]
}, Open  ]],
Cell[33243, 1137, 140, 4, 24, "Text",
  CellTags->"FindMinimum::fmgz"],

Cell[CellGroupData[{
Cell[33408, 1145, 138, 3, 26, "Input",
  CellTags->"FindMinimum::fmgz"],
Cell[33549, 1150, 146, 3, 21, "Output",
  CellTags->"FindMinimum::fmgz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33756, 1160, 167, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
Cell[33926, 1167, 389, 10, 37, "Message",
  CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}],
Cell[34318, 1179, 558, 12, 78, "Notes",
  CellTags->{"FindMinimum::fmmp", "FindMaximum::fmmp", "FindFit::fmmp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[34913, 1196, 208, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
    "FindFit::fdst"}],
Cell[35124, 1206, 446, 13, 37, "Message",
  CellTags->{
  "FindFit::fdst", "FindMaximum::fdst", "FindMinimum::fdst", 
    "FindRoot::fdst"}],
Cell[35573, 1221, 878, 31, 46, "Notes",
  CellTags->{
  "FindRoot::fdst", "FindMinimum::fdst", "FindMaximum::fdst", 
    "FindFit::fdst"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[36488, 1257, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::frdig"],
Cell[36574, 1260, 443, 12, 21, "Message",
  CellTags->"FindRoot::frdig"],
Cell[37020, 1274, 666, 15, 100, "Notes",
  CellTags->"FindRoot::frdig"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37723, 1294, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::frmp"],
Cell[37807, 1297, 292, 6, 21, "Message",
  CellTags->"FindRoot::frmp"],
Cell[38102, 1305, 669, 15, 100, "Notes",
  CellTags->"FindRoot::frmp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38808, 1325, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::jsing"],
Cell[38894, 1328, 233, 5, 37, "Message",
  CellTags->"FindRoot::jsing"],
Cell[39130, 1335, 371, 8, 46, "Notes",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{
Cell[39526, 1347, 65, 1, 38, "ExampleSection",
  CellTags->"FindRoot::jsing"],
Cell[39594, 1350, 167, 4, 24, "Text",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{
Cell[39786, 1358, 118, 3, 26, "Input",
  CellTags->"FindRoot::jsing"],
Cell[39907, 1363, 246, 5, 37, "Message",
  CellTags->"FindRoot::jsing"],
Cell[40156, 1370, 104, 3, 21, "Output",
  CellTags->"FindRoot::jsing"]
}, Open  ]],
Cell[40275, 1376, 130, 4, 24, "Text",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{
Cell[40430, 1384, 118, 3, 26, "Input",
  CellTags->"FindRoot::jsing"],
Cell[40551, 1389, 120, 3, 21, "Output",
  CellTags->"FindRoot::jsing"]
}, Open  ]],
Cell[40686, 1395, 169, 4, 24, "Text",
  CellTags->"FindRoot::jsing"],

Cell[CellGroupData[{
Cell[40880, 1403, 107, 3, 26, "Input",
  CellTags->"FindRoot::jsing"],
Cell[40990, 1408, 246, 5, 37, "Message",
  CellTags->"FindRoot::jsing"],
Cell[41239, 1415, 104, 3, 21, "Output",
  CellTags->"FindRoot::jsing"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[41404, 1425, 163, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
Cell[41570, 1432, 373, 9, 37, "Message",
  CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}],
Cell[41946, 1443, 166, 4, 24, "Notes",
  CellTags->{"FindMinimum::lss", "FindMaximum::lss", "FindRoot::lss"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42149, 1452, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindFit::lss"],
Cell[42229, 1455, 254, 5, 37, "Message",
  CellTags->"FindFit::lss"],
Cell[42486, 1462, 123, 4, 24, "Notes",
  CellTags->"FindFit::lss"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42646, 1471, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindFit::precw"],
Cell[42730, 1474, 238, 4, 37, "Message",
  CellTags->"FindFit::precw"],
Cell[42971, 1480, 125, 4, 24, "Notes",
  CellTags->"FindFit::precw"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43133, 1489, 216, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],
Cell[43352, 1499, 364, 10, 21, "Message",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],
Cell[43719, 1511, 689, 17, 100, "Notes",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[CellGroupData[{
Cell[44433, 1532, 137, 3, 38, "ExampleSection",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],
Cell[44573, 1537, 223, 6, 24, "Text",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[CellGroupData[{
Cell[44821, 1547, 188, 5, 26, "Input",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],
Cell[45012, 1554, 304, 7, 37, "Message",
  CellTags->{
  "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
    "FindRoot::srect"}],
Cell[45319, 1563, 189, 5, 21, "Output",
  CellTags->{
  "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
    "FindRoot::srect"}]
}, Open  ]],
Cell[45523, 1571, 231, 7, 24, "Text",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],

Cell[CellGroupData[{
Cell[45779, 1582, 205, 5, 26, "Input",
  CellTags->{
  "FindMinimum::srect", "FindMaximum::srect", "FindFit::srect", 
    "FindRoot::srect"}],
Cell[45987, 1589, 203, 5, 21, "Output",
  CellTags->{
  "FindFit::srect", "FindMaximum::srect", "FindMinimum::srect", 
    "FindRoot::srect"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[46251, 1601, 224, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
    "FindRoot::scdims"}],
Cell[46478, 1611, 367, 10, 21, "Message",
  CellTags->{
  "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
    "FindRoot::scdims"}],
Cell[46848, 1623, 202, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::scdims", "FindMaximum::scdims", "FindFit::scdims", 
    "FindRoot::scdims"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47087, 1634, 208, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
    "FindRoot::snum"}],
Cell[47298, 1644, 333, 9, 21, "Message",
  CellTags->{
  "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
    "FindRoot::snum"}],
Cell[47634, 1655, 194, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::snum", "FindMaximum::snum", "FindFit::snum", 
    "FindRoot::snum"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47865, 1666, 224, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
    "FindFit::fdssnv"}],
Cell[48092, 1676, 383, 10, 37, "Message",
  CellTags->{
  "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
    "FindFit::fdssnv"}],
Cell[48478, 1688, 202, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::fdssnv", "FindMaximum::fdssnv", "FindRoot::fdssnv", 
    "FindFit::fdssnv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[48717, 1699, 224, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],
Cell[48944, 1709, 371, 10, 21, "Message",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],
Cell[49318, 1721, 578, 16, 78, "Notes",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{
Cell[49921, 1741, 141, 3, 38, "ExampleSection",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],
Cell[50065, 1746, 228, 6, 24, "Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{
Cell[50318, 1756, 197, 5, 26, "Input",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],
Cell[50518, 1763, 304, 7, 37, "Message",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}],
Cell[50825, 1772, 198, 5, 21, "Output",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]],
Cell[51038, 1780, 247, 7, 24, "Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{
Cell[51310, 1791, 197, 5, 26, "Input",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],
Cell[51510, 1798, 207, 5, 21, "Output",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]],
Cell[51732, 1806, 266, 7, 24, "Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{
Cell[52023, 1817, 208, 5, 26, "Input",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],
Cell[52234, 1824, 304, 7, 37, "Message",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}],
Cell[52541, 1833, 215, 5, 21, "Output",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]],
Cell[52771, 1841, 213, 6, 24, "Text",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],

Cell[CellGroupData[{
Cell[53009, 1851, 243, 6, 26, "Input",
  CellTags->{
  "FindMinimum::bbound", "FindMaximum::bbound", "FindFit::bbound", 
    "FindRoot::bbound"}],
Cell[53255, 1859, 195, 5, 21, "Output",
  CellTags->{
  "FindFit::bbound", "FindMaximum::bbound", "FindMinimum::bbound", 
    "FindRoot::bbound"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53511, 1871, 208, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
    "FindRoot::linf"}],
Cell[53722, 1881, 393, 10, 37, "Message",
  CellTags->{
  "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
    "FindRoot::linf"}],
Cell[54118, 1893, 194, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::linf", "FindMaximum::linf", "FindFit::linf", 
    "FindRoot::linf"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[54349, 1904, 208, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
    "FindRoot::uinf"}],
Cell[54560, 1914, 396, 10, 37, "Message",
  CellTags->{
  "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
    "FindRoot::uinf"}],
Cell[54959, 1926, 194, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::uinf", "FindMaximum::uinf", "FindFit::uinf", 
    "FindRoot::uinf"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[55190, 1937, 216, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[55409, 1947, 368, 10, 37, "Message",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[55780, 1959, 656, 14, 90, "Notes",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{
Cell[56461, 1977, 137, 3, 38, "ExampleSection",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[56601, 1982, 235, 6, 24, "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{
Cell[56861, 1992, 201, 5, 26, "Input",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[57065, 1999, 301, 7, 37, "Message",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}],
Cell[57369, 2008, 234, 6, 23, "Output",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],
Cell[57618, 2017, 218, 6, 24, "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{
Cell[57861, 2027, 201, 5, 26, "Input",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[58065, 2034, 214, 5, 21, "Output",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],
Cell[58294, 2042, 176, 3, 24, "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{
Cell[58495, 2049, 197, 5, 26, "Input",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[58695, 2056, 257, 7, 21, "Output",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],
Cell[58967, 2066, 260, 7, 24, "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{
Cell[59252, 2077, 193, 5, 26, "Input",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[59448, 2084, 298, 7, 37, "Message",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}],
Cell[59749, 2093, 192, 5, 21, "Output",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],
Cell[59956, 2101, 211, 6, 24, "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{
Cell[60192, 2111, 192, 5, 26, "Input",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[60387, 2118, 246, 6, 21, "Output",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[60670, 2129, 197, 5, 26, "Input",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[60870, 2136, 246, 6, 21, "Output",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]],
Cell[61131, 2145, 261, 7, 24, "Text",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],

Cell[CellGroupData[{
Cell[61417, 2156, 182, 5, 26, "Input",
  CellTags->{
  "FindMinimum::cvmit", "FindMaximum::cvmit", "FindFit::cvmit", 
    "FindRoot::cvmit"}],
Cell[61602, 2163, 301, 7, 37, "Message",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}],
Cell[61906, 2172, 203, 5, 21, "Output",
  CellTags->{
  "FindFit::cvmit", "FindMaximum::cvmit", "FindMinimum::cvmit", 
    "FindRoot::cvmit"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62170, 2184, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMaximum::sdprec"],
Cell[62264, 2187, 239, 4, 37, "Message",
  CellTags->"FindMaximum::sdprec"],
Cell[62506, 2193, 130, 4, 24, "Notes",
  CellTags->"FindMaximum::sdprec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62673, 2202, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMaximum::lstol"],
Cell[62765, 2205, 419, 6, 53, "Message",
  CellTags->"FindMaximum::lstol"],
Cell[63187, 2213, 129, 4, 24, "Notes",
  CellTags->"FindMaximum::lstol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63353, 2222, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMaximum::lsbrak"],
Cell[63447, 2225, 211, 4, 21, "Message",
  CellTags->"FindMaximum::lsbrak"],
Cell[63661, 2231, 130, 4, 24, "Notes",
  CellTags->"FindMaximum::lsbrak"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63828, 2240, 173, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
Cell[64004, 2247, 325, 7, 21, "Message",
  CellTags->{"FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}],
Cell[64332, 2256, 171, 4, 24, "Notes",
  CellTags->{"FindMinimum::prax2", "FindMaximum::prax2", "FindFit::prax2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[64540, 2265, 224, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
    "FindRoot::regex1"}],
Cell[64767, 2275, 448, 13, 37, "Message",
  CellTags->{
  "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
    "FindRoot::regex1"}],
Cell[65218, 2290, 734, 22, 46, "Notes",
  CellTags->{
  "FindMinimum::regex1", "FindMaximum::regex1", "FindFit::regex1", 
    "FindRoot::regex1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[65989, 2317, 216, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],
Cell[66208, 2327, 434, 11, 37, "Message",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],
Cell[66645, 2340, 527, 15, 62, "Notes",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[CellGroupData[{
Cell[67197, 2359, 137, 3, 38, "ExampleSection",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],
Cell[67337, 2364, 237, 6, 24, "Text",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[CellGroupData[{
Cell[67599, 2374, 193, 5, 26, "Input",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],
Cell[67795, 2381, 374, 8, 53, "Message",
  CellTags->{
  "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
    "FindRoot::reged"}],
Cell[68172, 2391, 204, 5, 21, "Output",
  CellTags->{
  "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
    "FindRoot::reged"}]
}, Open  ]],
Cell[68391, 2399, 224, 6, 24, "Text",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],

Cell[CellGroupData[{
Cell[68640, 2409, 193, 5, 26, "Input",
  CellTags->{
  "FindMinimum::reged", "FindMaximum::reged", "FindFit::reged", 
    "FindRoot::reged"}],
Cell[68836, 2416, 203, 5, 21, "Output",
  CellTags->{
  "FindFit::reged", "FindMaximum::reged", "FindMinimum::reged", 
    "FindRoot::reged"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69100, 2428, 216, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
    "FindRoot::streg"}],
Cell[69319, 2438, 340, 9, 21, "Message",
  CellTags->{
  "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
    "FindRoot::streg"}],
Cell[69662, 2449, 198, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::streg", "FindMaximum::streg", "FindFit::streg", 
    "FindRoot::streg"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[69897, 2460, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],
Cell[70036, 2466, 633, 14, 69, "Message",
  CellTags->{"FindFit::sszero", "FindMinimum::sszero"}],
Cell[70672, 2482, 151, 4, 24, "Notes",
  CellTags->{"FindFit::sszero", "FindMinimum::sszero"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[70860, 2491, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMaximum::sszero"],
Cell[70954, 2494, 478, 8, 69, "Message",
  CellTags->"FindMaximum::sszero"],
Cell[71435, 2504, 130, 4, 24, "Notes",
  CellTags->"FindMaximum::sszero"]
}, Open  ]],

Cell[CellGroupData[{
Cell[71602, 2513, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::sszero"],
Cell[71690, 2516, 363, 6, 53, "Message",
  CellTags->"FindRoot::sszero"],
Cell[72056, 2524, 127, 4, 24, "Notes",
  CellTags->"FindRoot::sszero"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72220, 2533, 224, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
    "FindRoot::stfail"}],
Cell[72447, 2543, 335, 9, 21, "Message",
  CellTags->{
  "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
    "FindRoot::stfail"}],
Cell[72785, 2554, 202, 6, 24, "Notes",
  CellTags->{
  "FindMinimum::stfail", "FindMaximum::stfail", "FindFit::stfail", 
    "FindRoot::stfail"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[73024, 2565, 167, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
Cell[73194, 2572, 362, 8, 37, "Message",
  CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}],
Cell[73559, 2582, 168, 4, 24, "Notes",
  CellTags->{"FindMinimum::umtd", "FindMaximum::umtd", "FindFit::umtd"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[73764, 2591, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::umtd"],
Cell[73848, 2594, 242, 4, 37, "Message",
  CellTags->"FindRoot::umtd"],
Cell[74093, 2600, 125, 4, 24, "Notes",
  CellTags->"FindRoot::umtd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74255, 2609, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::bdmtd"],
Cell[74341, 2612, 215, 4, 37, "Message",
  CellTags->"FindRoot::bdmtd"],
Cell[74559, 2618, 126, 4, 24, "Notes",
  CellTags->"FindRoot::bdmtd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74722, 2627, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::eqlist"],
Cell[74810, 2630, 199, 3, 21, "Message",
  CellTags->"FindRoot::eqlist"],
Cell[75012, 2635, 127, 4, 24, "Notes",
  CellTags->"FindRoot::eqlist"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75176, 2644, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::sec2"],
Cell[75260, 2647, 197, 4, 21, "Message",
  CellTags->"FindRoot::sec2"],
Cell[75460, 2653, 125, 4, 24, "Notes",
  CellTags->"FindRoot::sec2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75622, 2662, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::bbrac"],
Cell[75708, 2665, 271, 5, 37, "Message",
  CellTags->"FindRoot::bbrac"],
Cell[75982, 2672, 126, 4, 24, "Notes",
  CellTags->"FindRoot::bbrac"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76145, 2681, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::frn2"],
Cell[76229, 2684, 220, 4, 37, "Message",
  CellTags->"FindRoot::frn2"],
Cell[76452, 2690, 125, 4, 24, "Notes",
  CellTags->"FindRoot::frn2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76614, 2699, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::jsing1"],
Cell[76702, 2702, 234, 5, 37, "Message",
  CellTags->"FindRoot::jsing1"],
Cell[76939, 2709, 127, 4, 24, "Notes",
  CellTags->"FindRoot::jsing1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77103, 2718, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::nveq"],
Cell[77187, 2721, 198, 3, 21, "Message",
  CellTags->"FindRoot::nveq"],
Cell[77388, 2726, 125, 4, 24, "Notes",
  CellTags->"FindRoot::nveq"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77550, 2735, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindFit::nlnrm"],
Cell[77634, 2738, 382, 7, 53, "Message",
  CellTags->"FindFit::nlnrm"],
Cell[78019, 2747, 125, 4, 24, "Notes",
  CellTags->"FindFit::nlnrm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78181, 2756, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindFit::lmnl"],
Cell[78263, 2759, 296, 5, 53, "Message",
  CellTags->"FindFit::lmnl"],
Cell[78562, 2766, 124, 4, 24, "Notes",
  CellTags->"FindFit::lmnl"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78723, 2775, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindFit::nlmod"],
Cell[78807, 2778, 280, 5, 37, "Message",
  CellTags->"FindFit::nlmod"],
Cell[79090, 2785, 125, 4, 24, "Notes",
  CellTags->"FindFit::nlmod"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79252, 2794, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::frns"],
Cell[79336, 2797, 338, 9, 21, "Message",
  CellTags->"FindRoot::frns"],
Cell[79677, 2808, 233, 6, 24, "Notes",
  CellTags->"FindRoot::frns"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79947, 2819, 208, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
    "FindRoot::fdvc"}],
Cell[80158, 2829, 611, 18, 21, "Message",
  CellTags->{
  "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
    "FindRoot::fdvc"}],
Cell[80772, 2849, 526, 12, 78, "Notes",
  CellTags->{
  "FindMinimum::fdvc", "FindMaximum::fdvc", "FindFit::fdvc", 
    "FindRoot::fdvc"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[81335, 2866, 173, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
Cell[81511, 2873, 525, 13, 37, "Message",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
Cell[82039, 2888, 461, 10, 62, "Notes",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[CellGroupData[{
Cell[82525, 2902, 110, 1, 38, "ExampleSection",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
Cell[82638, 2905, 187, 4, 24, "Text",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[CellGroupData[{
Cell[82850, 2913, 165, 3, 26, "Input",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
Cell[83018, 2918, 289, 5, 37, "Message",
  CellTags->{"FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}],
Cell[83310, 2925, 190, 3, 23, "Output",
  CellTags->{"FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}]
}, Open  ]],
Cell[83515, 2931, 175, 4, 24, "Text",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],

Cell[CellGroupData[{
Cell[83715, 2939, 168, 3, 26, "Input",
  CellTags->{"FindMinimum::fmdig", "FindMaximum::fmdig", "FindFit::fmdig"}],
Cell[83886, 2944, 191, 3, 23, "Output",
  CellTags->{"FindFit::fmdig", "FindMaximum::fmdig", "FindMinimum::fmdig"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[84138, 2954, 112, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Fit::fitc", "FindFit::fitc"}],
Cell[84253, 2960, 679, 20, 21, "Message",
  CellTags->{"Fit::fitc", "FindFit::fitc"}],
Cell[84935, 2982, 650, 14, 94, "Notes",
  CellTags->{"Fit::fitc", "FindFit::fitc"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[85622, 3001, 112, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],
Cell[85737, 3007, 410, 12, 21, "Message",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],
Cell[86150, 3021, 419, 9, 62, "Notes",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[CellGroupData[{
Cell[86594, 3034, 78, 1, 38, "ExampleSection",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],
Cell[86675, 3037, 143, 4, 24, "Text",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[CellGroupData[{
Cell[86843, 3045, 131, 3, 26, "Input",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],
Cell[86977, 3050, 214, 5, 21, "Message",
  CellTags->{"FindFit::fitd", "Fit::fitd"}],
Cell[87194, 3057, 128, 3, 21, "Output",
  CellTags->{"FindFit::fitd", "Fit::fitd"}]
}, Open  ]],
Cell[87337, 3063, 138, 5, 24, "Text",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],

Cell[CellGroupData[{
Cell[87500, 3072, 132, 3, 26, "Input",
  CellTags->{"Fit::fitd", "FindFit::fitd"}],
Cell[87635, 3077, 183, 4, 21, "Output",
  CellTags->{"FindFit::fitd", "Fit::fitd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[87879, 3088, 167, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
Cell[88049, 3095, 446, 11, 37, "Message",
  CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}],
Cell[88498, 3108, 666, 14, 100, "Notes",
  CellTags->{"FindMinimum::fmgs", "FindMaximum::fmgs", "FindFit::fmgs"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[89201, 3127, 173, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
Cell[89377, 3134, 414, 10, 37, "Message",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
Cell[89794, 3146, 695, 19, 78, "Notes",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[CellGroupData[{
Cell[90514, 3169, 110, 1, 38, "ExampleSection",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
Cell[90627, 3172, 212, 4, 24, "Text",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[CellGroupData[{
Cell[90864, 3180, 181, 3, 26, "Input",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
Cell[91048, 3185, 306, 5, 53, "Message",
  CellTags->{"FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}],
Cell[91357, 3192, 177, 3, 21, "Output",
  CellTags->{"FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}]
}, Open  ]],
Cell[91549, 3198, 210, 5, 24, "Text",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],

Cell[CellGroupData[{
Cell[91784, 3207, 178, 3, 26, "Input",
  CellTags->{"FindMinimum::fmwar", "FindMaximum::fmwar", "FindFit::fmwar"}],
Cell[91965, 3212, 177, 3, 21, "Output",
  CellTags->{"FindFit::fmwar", "FindMaximum::fmwar", "FindMinimum::fmwar"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[92203, 3222, 216, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],
Cell[92422, 3232, 405, 12, 21, "Message",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],
Cell[92830, 3246, 730, 22, 46, "Notes",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[CellGroupData[{
Cell[93585, 3272, 137, 3, 38, "ExampleSection",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],
Cell[93725, 3277, 227, 6, 24, "Text",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[CellGroupData[{
Cell[93977, 3287, 218, 5, 26, "Input",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],
Cell[94198, 3294, 330, 7, 37, "Message",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],
Cell[94531, 3303, 221, 6, 21, "Output",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}]
}, Open  ]],
Cell[94767, 3312, 211, 6, 24, "Text",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],

Cell[CellGroupData[{
Cell[95003, 3322, 193, 5, 26, "Input",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}],
Cell[95199, 3329, 204, 5, 21, "Output",
  CellTags->{
  "FindMinimum::regex", "FindMaximum::regex", "FindFit::regex", 
    "FindRoot::regex"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95464, 3341, 112, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Fit::fitm", "FindFit::fitm"}],
Cell[95579, 3347, 411, 11, 37, "Message",
  CellTags->{"FindFit::fitm", "Fit::fitm"}],
Cell[95993, 3360, 379, 7, 62, "Notes",
  CellTags->{"Fit::fitm", "FindFit::fitm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[96409, 3372, 167, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
Cell[96579, 3379, 436, 11, 37, "Message",
  CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}],
Cell[97018, 3392, 575, 13, 78, "Notes",
  CellTags->{"FindMinimum::fmhs", "FindMaximum::fmhs", "FindFit::fmhs"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[97630, 3410, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ngnum"],
Cell[97714, 3413, 331, 10, 21, "Message",
  CellTags->"General::ngnum"],
Cell[98048, 3425, 500, 10, 62, "Notes",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{
Cell[98573, 3439, 64, 1, 38, "ExampleSection",
  CellTags->"General::ngnum"],
Cell[98640, 3442, 168, 5, 24, "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{
Cell[98833, 3451, 170, 4, 26, "Input",
  CellTags->"General::ngnum"],
Cell[99006, 3457, 209, 5, 21, "Message",
  CellTags->"General::ngnum"],
Cell[99218, 3464, 110, 3, 21, "Output",
  CellTags->"General::ngnum"]
}, Open  ]],
Cell[99343, 3470, 180, 4, 24, "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{
Cell[99548, 3478, 117, 3, 26, "Input",
  CellTags->"General::ngnum"],
Cell[99668, 3483, 110, 3, 21, "Output",
  CellTags->"General::ngnum"]
}, Open  ]],
Cell[99793, 3489, 167, 4, 24, "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{
Cell[99985, 3497, 117, 3, 26, "Input",
  CellTags->"General::ngnum"],
Cell[100105, 3502, 180, 4, 40, "Message",
  CellTags->"General::ngnum"],
Cell[100288, 3508, 206, 5, 21, "Message",
  CellTags->"General::ngnum"],
Cell[100497, 3515, 103, 3, 21, "Output",
  CellTags->"General::ngnum"]
}, Open  ]],
Cell[100615, 3521, 121, 4, 24, "Text",
  CellTags->"General::ngnum"],

Cell[CellGroupData[{
Cell[100761, 3529, 117, 3, 26, "Input",
  CellTags->"General::ngnum"],
Cell[100881, 3534, 103, 3, 21, "Output",
  CellTags->"General::ngnum"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[101045, 3544, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ngnum1"],
Cell[101131, 3547, 347, 10, 21, "Message",
  CellTags->"General::ngnum1"],
Cell[101481, 3559, 126, 4, 24, "Notes",
  CellTags->"General::ngnum1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101644, 3568, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
Cell[101779, 3574, 468, 12, 53, "Message",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
Cell[102250, 3588, 322, 9, 40, "Notes",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[CellGroupData[{
Cell[102597, 3601, 88, 1, 38, "ExampleSection",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
Cell[102688, 3604, 295, 8, 40, "Text",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[CellGroupData[{
Cell[103008, 3616, 212, 4, 26, "Input",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
Cell[103223, 3622, 331, 6, 69, "Message",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
Cell[103557, 3630, 215, 4, 23, "Output",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}]
}, Open  ]],
Cell[103787, 3637, 192, 5, 24, "Text",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],

Cell[CellGroupData[{
Cell[104004, 3646, 215, 4, 42, "Input",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}],
Cell[104222, 3652, 149, 3, 21, "Output",
  CellTags->{"FindFit::notlm", "FindMinimum::notlm"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104432, 3662, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindMaximum::notlm"],
Cell[104524, 3665, 443, 9, 53, "Message",
  CellTags->"FindMaximum::notlm"],
Cell[104970, 3676, 268, 7, 40, "Notes",
  CellTags->"FindMaximum::notlm"],

Cell[CellGroupData[{
Cell[105263, 3687, 68, 1, 38, "ExampleSection",
  CellTags->"FindMaximum::notlm"],
Cell[105334, 3690, 269, 7, 40, "Text",
  CellTags->"FindMaximum::notlm"],

Cell[CellGroupData[{
Cell[105628, 3701, 188, 4, 26, "Input",
  CellTags->"FindMaximum::notlm"],
Cell[105819, 3707, 312, 6, 69, "Message",
  CellTags->"FindMaximum::notlm"],
Cell[106134, 3715, 191, 4, 23, "Output",
  CellTags->"FindMaximum::notlm"]
}, Open  ]],
Cell[106340, 3722, 172, 5, 24, "Text",
  CellTags->"FindMaximum::notlm"],

Cell[CellGroupData[{
Cell[106537, 3731, 195, 4, 42, "Input",
  CellTags->"FindMaximum::notlm"],
Cell[106735, 3737, 129, 3, 21, "Output",
  CellTags->"FindMaximum::notlm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[106925, 3747, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FindRoot::zdamp"],
Cell[107011, 3750, 210, 5, 37, "Message",
  CellTags->"FindRoot::zdamp"],
Cell[107224, 3757, 226, 7, 24, "Notes",
  CellTags->"FindRoot::zdamp"],

Cell[CellGroupData[{
Cell[107475, 3768, 65, 1, 38, "ExampleSection",
  CellTags->"FindRoot::zdamp"],
Cell[107543, 3771, 192, 5, 24, "Text",
  CellTags->"FindRoot::zdamp"],

Cell[CellGroupData[{
Cell[107760, 3780, 142, 3, 26, "Input",
  CellTags->"FindRoot::zdamp"],
Cell[107905, 3785, 214, 5, 37, "Message",
  CellTags->"FindRoot::zdamp"],
Cell[108122, 3792, 143, 3, 21, "Output",
  CellTags->"FindRoot::zdamp"]
}, Open  ]],
Cell[108280, 3798, 145, 5, 24, "Text",
  CellTags->"FindRoot::zdamp"],

Cell[CellGroupData[{
Cell[108450, 3807, 141, 3, 26, "Input",
  CellTags->"FindRoot::zdamp"],
Cell[108594, 3812, 118, 3, 21, "Output",
  CellTags->"FindRoot::zdamp"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

