(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    292562,      10307]*)
(*NotebookOutlinePosition[    513480,      15254]*)
(*  CellTagsIndexPosition[    506998,      15084]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Graphics", "Title"],

Cell[CellGroupData[{

Cell["SurfaceColor::albedo", "ObjectNameWarningMessages",
  CellTags->"SurfaceColor::albedo"],

Cell[BoxData[
    RowBox[{\(SurfaceColor::"albedo"\), \(\(:\)\(\ \)\), \(\(Albedo\)\(\ \
\)\(specification\)\(\ \)\), 
      StyleBox["spec",
        "TI"], \(\(\ \)\(\(in\)\(\ \)\(first\)\(\ \)\(argument\)\(\ \
\)\(of\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ GrayLevel\ or\ RGBColor\ \
\(\(directive\)\(.\)\)\)\)}]], "Message",
  CellTags->"SurfaceColor::albedo"],

Cell[TextData[{
  "\[FilledSmallSquare] This message indicates that the first argument in ",
  StyleBox["SurfaceColor", "MR"],
  " is not a valid color specification.\n\[FilledSmallSquare] A valid color \
specification has the form ",
  StyleBox["GrayLevel[", "MR"],
  StyleBox["level", "TI"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["RGBColor[", "MR"],
  StyleBox["red", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["green", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["blue", "TI"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["CMYKColor[", "MR"],
  StyleBox["cyan", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["magenta", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["yellow", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["black", "TI"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  ", or ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  ".\n\[FilledSmallSquare] The first argument in ",
  StyleBox["SurfaceColor", "MR"],
  " specifies the albedo of a surface."
}], "Notes",
  CellTags->"SurfaceColor::albedo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SurfaceColor::albedo"],

Cell[TextData[{
  "Evaluation of this input will generate a message because a valid ",
  StyleBox["GrayLevel", "MR"],
  " specification requires one argument.  The image is rendered using ",
  StyleBox["RGBColor[1,1,1]", "MR"],
  " by default."
}], "Text",
  CellTags->"SurfaceColor::albedo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{SurfaceColor[GrayLevel[]], \ 
          Polygon[{{0, 0, 0}, {1, 0, 0}, {0, 1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SurfaceColor::albedo"],

Cell[BoxData[
    \(SurfaceColor::"albedo" \(\(:\)\(\ \)\) 
      "Albedo specification \!\(GrayLevel[]\) in first argument of \
\!\(SurfaceColor[\(\(GrayLevel[]\)\)]\) is not a valid GrayLevel or RGBColor \
directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SurfaceColor::albedo"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SurfaceColor::albedo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SurfaceGraphics::clip", "ObjectNameWarningMessages",
  CellTags->"SurfaceGraphics::clip"],

Cell[BoxData[
    RowBox[{\(SurfaceGraphics::"clip"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ \
option\ ClipFill\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ None, \ Automatic, \ a\ color, \ 
      or\ a\ list\ of\ two\ such\ \(\(values\)\(.\)\)\)\)}]], "Message",
  CellTags->"SurfaceGraphics::clip"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the form of the value of the ",
  StyleBox["ClipFill", "MR"],
  " option is not valid.\n\[FilledSmallSquare] The value of the ",
  StyleBox["ClipFill", "MR"],
  " option is expected to be ",
  StyleBox["None", "MR"],
  ", ",
  StyleBox["Automatic", "MR"],
  ", a valid color directive, or a list of zero, one, or two such values.\n\
\[FilledSmallSquare] ",
  StyleBox["ClipFill->GrayLevel[0]", "MR"],
  " is an example of a valid ",
  StyleBox["ClipFill", "MR"],
  " specification."
}], "Notes",
  CellTags->"SurfaceGraphics::clip"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SurfaceGraphics::clip"],

Cell[TextData[{
  "Evaluation of this input will generate a message because a valid ",
  StyleBox["GrayLevel", "MR"],
  " specification requires one argument.  The image is rendered as if the \
value of the ",
  StyleBox["ClipFill", "MR"],
  " option had been ",
  StyleBox["None", "MR"],
  "."
}], "Text",
  CellTags->"SurfaceGraphics::clip"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Exp[\(-x\) - y], {x, 0, 10}, {y, 0, 10}, \n\t
      ClipFill -> {GrayLevel}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SurfaceGraphics::clip"],

Cell[BoxData[
    \(SurfaceGraphics::"clip" \(\(:\)\(\ \)\) 
      "Value of option ClipFill -> \!\({GrayLevel}\) is not None, Automatic, \
a color, or a list of two such values."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SurfaceGraphics::clip"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SurfaceGraphics::clip"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics3D::ltcol", "ObjectNameWarningMessages",
  CellTags->"Graphics3D::ltcol"],

Cell[BoxData[
    RowBox[{\(Graphics3D::"ltcol"\), \(\(:\)\(\ \)\), "Element", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", "LightSources", " ", "option", " ", "contains",
       " ", 
      StyleBox["expr",
        "TI"], \(\(,\)\(\ \)\(which\ is\ not\ a\ valid\ GrayLevel\ or\ \
RGBColor\ \(\(directive\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Graphics3D::ltcol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["LightSources", "MR"],
  " option has the correct form (a list of pairs), but when the second \
element in each pair is not a valid color directive.\n\[FilledSmallSquare] A \
valid color directive has the form ",
  StyleBox["GrayLevel[", "MR"],
  StyleBox["level", "TI"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["RGBColor[", "MR"],
  StyleBox["red", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["green", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["blue", "TI"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["CMYKColor[", "MR"],
  StyleBox["cyan", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["magenta", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["yellow", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["black", "TI"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  ", or ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  ".\n\[FilledSmallSquare] This message can occur when using ",
  StyleBox["Graphics3D", "MR"],
  " or ",
  StyleBox["SurfaceGraphics", "MR"],
  " expressions, or functions such as ",
  StyleBox["Plot3D", "MR"],
  ", ",
  StyleBox["ListPlot3D", "MR"],
  ", or ",
  StyleBox["ParametricPlot3D", "MR"],
  " that generate such expressions."
}], "Notes",
  CellTags->"Graphics3D::ltcol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics3D::ltcol"],

Cell[TextData[{
  "Evaluation of this input will generate a message because a valid ",
  StyleBox["RGBColor", "MR"],
  " directive requires three arguments."
}], "Text",
  CellTags->"Graphics3D::ltcol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 10}, {y, 0, 1}, \n\t
      LightSources -> {{{1, 1, 1}, RGBColor[]}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics3D::ltcol"],

Cell[BoxData[
    \(Graphics3D::"ltcol" \(\(:\)\(\ \)\) 
      "Element \!\(1\) in LightSources option contains \!\({\({\(\({1, 1, \
1}\)\), \(\(RGBColor[]\)\)}\)}\), which is not a valid GrayLevel or RGBColor \
directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics3D::ltcol"],

Cell[BoxData[
    \(Graphics3D::"lights" \(\(:\)\(\ \)\) 
      "Value of option \!\(LightSources\) -> \!\({\({\(\({1, 1, 1}\)\), \
\(\(RGBColor[]\)\)}\)}\) is not of the form {{pos, col}, {pos, col}, \
...}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics3D::ltcol"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics3D::ltcol"]
}, Open  ]],

Cell[TextData[{
  "If a correct ",
  StyleBox["RGBColor", "MR"],
  " directive is used, then a plot will be generated using the specified \
value of the ",
  StyleBox["LightSources", "MR"],
  " option."
}], "Text",
  CellTags->"Graphics3D::ltcol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 10}, {y, 0, 1}, \n\t
      LightSources -> {{{1, 1, 1}, RGBColor[1, 0, 0]}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Graphics3D::ltcol"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Graphics3D::ltcol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Raster::rslim", "ObjectNameWarningMessages",
  CellTags->"Raster::rslim"],

Cell[BoxData[
    RowBox[{\(Raster::"rslim"\), \(\(:\)\(\ \)\), \(\(Third\)\(\ \)\(argument\
\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(to\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ list\ of\ two\ distinct\ real\ \
\(\(numbers\)\(.\)\)\)\)}]], "Message",
  CellTags->"Raster::rslim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["Raster", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The third argument \
in ",
  StyleBox["Raster", "MR"],
  " gives the minimum and maximum cell values to display."
}], "Notes",
  CellTags->"Raster::rslim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Raster::rslim"],

Cell[TextData[{
  "Evaluation of this input will generate a message since the minimum and \
maximum cell values given in the third argument of ",
  StyleBox["Raster", "MR"],
  " are not distinct."
}], "Text",
  CellTags->"Raster::rslim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[\n\ \ \ \ Raster[{{1, 2, 3}, {2, 9, 1}, {0, 3, 
              1}}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {{0, 0}, {10, 10}}, {4, 
            4}]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Raster::rslim"],

Cell[BoxData[
    \(Raster::"rslim" \(\(:\)\(\ \)\) 
      "Third argument \!\({4, 4}\) to \!\(Raster\) is not a list of two \
distinct real numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Raster::rslim"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Raster::rslim"]
}, Open  ]],

Cell["This will generate a plot without error.", "Text",
  CellTags->"Raster::rslim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[\n\ \ \ \ Raster[{{1, 2, 3}, {2, 9, 1}, {0, 3, 
              1}}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {{0, 0}, {10, 10}}, {0, 
            4}]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Raster::rslim"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Raster::rslim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphicsArray::arrsp", "ObjectNameWarningMessages",
  CellTags->"GraphicsArray::arrsp"],

Cell[BoxData[
    RowBox[{\(GraphicsArray::"arrsp"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ \
option\ GraphicsSpacing\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ number\ greater\ than\ 0\ or\ a\ list\
\ of\ two\ such\ \(\(numbers\)\(.\)\)\)\)}]], "Message",
  CellTags->"GraphicsArray::arrsp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["GraphicsSpacing", "MR"],
  " option in ",
  StyleBox["GraphicsArray", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"GraphicsArray::arrsp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"GraphicsArray::arrsp"],

Cell[TextData[{
  "Evaluation of this input will generate a message because the value of the \
",
  StyleBox["GraphicsSpacing", "MR"],
  " option cannot be a list of three numbers.  An image will be generated \
using a default value."
}], "Text",
  CellTags->"GraphicsArray::arrsp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\n\t\tTable[
          Graphics[
            Circle[{0, 0}, 
              1]], {2}, {2}], \n\t\t\ \ \ \ GraphicsSpacing\  -> \ {1, \ 1, \ 
            1}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"GraphicsArray::arrsp"],

Cell[BoxData[
    \(GraphicsArray::"arrsp" \(\(:\)\(\ \)\) 
      "Value of option GraphicsSpacing -> \!\({1, 1, 1}\) should be a number \
greater than 0 or a list of two such numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"GraphicsArray::arrsp"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"GraphicsArray::arrsp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the ",
  StyleBox["GraphicsSpacing", "MR"],
  " option."
}], "Text",
  CellTags->"GraphicsArray::arrsp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[\n\t\tTable[
          Graphics[
            Circle[{0, 0}, 
              1]], {2}, {2}], \n\t\t\ \ \ \ GraphicsSpacing\  -> \ {0, \ 
            1}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"GraphicsArray::arrsp"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"GraphicsArray::arrsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contours::ctnl", "ObjectNameWarningMessages",
  CellTags->"Contours::ctnl"],

Cell[BoxData[
    RowBox[{\(Contours::"ctnl"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
Contours\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ integer\ or\ a\ list\ of\ \
\(\(numbers\)\(.\)\)\)\)}]], "Message",
  CellTags->"Contours::ctnl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Contours", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["Contours", "MR"],
  " option can be a positive integer or a list of real numbers.\n\
\[FilledSmallSquare] The ",
  StyleBox["Contours", "MR"],
  " option is used by ",
  StyleBox["ContourPlot", "MR"],
  ", ",
  StyleBox["ListContourPlot", "MR"],
  ", and ",
  StyleBox["ContourGraphics", "MR"],
  "."
}], "Notes",
  CellTags->"Contours::ctnl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Contours::ctnl"],

Cell[TextData[{
  "The value of the ",
  StyleBox["Contours", "MR"],
  " option cannot be a number other than a positive integer."
}], "Text",
  CellTags->"Contours::ctnl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[x\ y, {x, \(-1\), 1}, {y, \(-1\), 1}, 
      Contours -> 0.1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Contours::ctnl"],

Cell[BoxData[
    \(Contours::"ctnl" \(\(:\)\(\ \)\) 
      "Value of option Contours -> \!\(0.1`\) is not a positive integer or a \
list of numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Contours::ctnl"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Contours::ctnl"]
}, Open  ]],

Cell["\<\
Evaluation of this input will generate a contour plot with a single \
contour level.\
\>", "Text",
  CellTags->"Contours::ctnl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[x\ y, {x, \(-1\), 1}, {y, \(-1\), 1}, 
      Contours -> {0.1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Contours::ctnl"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Contours::ctnl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nlist3", "ObjectNameWarningMessages",
  CellTags->"General::nlist3"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nlist3\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", " ",
         "three", " ", \(\(numbers\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nlist3"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression does \
not have the expected form.
\[FilledSmallSquare] This message is generated by three-dimensional graphics \
functions, options, primitives, and directives that use a list of three \
numbers to indicate a point in space.\
\>", "Notes",
  CellTags->"General::nlist3"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nlist3"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ViewPoint", "MR"],
  " option should be a list of three numbers."
}], "Text",
  CellTags->"General::nlist3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 3}, {y, 0, 3}, ViewPoint -> {1, 1}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"General::nlist3"],

Cell[BoxData[
    \(ViewPoint::"nlist3" \(\(:\)\(\ \)\) 
      "\!\({1, 1}\) is not a list of three numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nlist3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nlist3"]
}, Open  ]],

Cell[TextData[{
  "Evaluation of this input will give a plot using the specified value of the \
",
  StyleBox["ViewPoint", "MR"],
  " option."
}], "Text",
  CellTags->"General::nlist3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 3}, {y, 0, 3}, 
      ViewPoint -> {1, 1, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nlist3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nlist3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot3D::glims
ContourPlot::glims
DensityPlot::glims
Plot3D::glims\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"glims\"\>"}], \(\(:\)\(\ \)\), "Range", " ", 
      "specifications", " ", 
      StyleBox["r1",
        "TI"], " ", "and", " ", 
      StyleBox["r2",
        "TI"], " ", "contain", " ", "the", " ", "same", " ", "iteration", 
      " ", \(\(variable\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell["\<\
\[FilledSmallSquare] Generated when the variables in \
three-dimensional plotting functions are not distinct.\
\>", "Notes",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell["\<\
This generates a message because the same symbol is used for both \
iteration variables.\
\>", "Text",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 3}, {x, 0, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[BoxData[
    \(Plot3D::"glims" \(\(:\)\(\ \)\) 
      "Range specifications \!\({x, 0, 3}\) and \!\({x, 0, 3}\) contain the \
same iteration variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
    "Plot3D::glims"}],

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 3}, {x, 0, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
    "Plot3D::glims"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["Plot3D", "MR"],
  "."
}], "Text",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 3}, {y, 0, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
    "Plot3D::glims"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics::realp", "ObjectNameWarningMessages",
  CellTags->"Graphics::realp"],

Cell[BoxData[
    RowBox[{\(Graphics::"realp"\), \(\(:\)\(\ \)\), \(\(Argument\)\(\ \
\)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ real\ \
\(\(number\)\(.\)\)\)\)}]], "Message",
  CellTags->"Graphics::realp"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated argument in \
various graphics primitives and graphics directives does not have the \
expected form.
\[FilledSmallSquare] This message is generated when the enclosing graphics \
expression is displayed.\
\>", "Notes",
  CellTags->"Graphics::realp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics::realp"],

Cell[TextData[{
  "This generates a message because the argument in ",
  StyleBox["AbsoluteThickness", "MR"],
  " is not a positive real number.  The message appears when the image is \
displayed."
}], "Text",
  CellTags->"Graphics::realp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x, {x, 0, 1}, PlotStyle -> AbsoluteThickness[Null]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics::realp"],

Cell[BoxData[
    \(Graphics::"realp" \(\(:\)\(\ \)\) 
      "Argument in \!\(AbsoluteThickness[Null]\) is not a positive real \
number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::realp"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics::realp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics::realu", "ObjectNameWarningMessages",
  CellTags->"Graphics::realu"],

Cell[BoxData[
    RowBox[{\(Graphics::"realu"\), \(\(:\)\(\ \)\), \(\(Argument\)\(\ \
\)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ real\ number\ between\ 0\ and\ 1. \
\)\)}]], "Message",
  CellTags->"Graphics::realu"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated argument in \
various graphics primitives and graphics directives does not have the \
expected form.
\[FilledSmallSquare] This message is generated when the enclosing graphics \
expression is displayed.\
\>", "Notes",
  CellTags->"Graphics::realu"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics::realu"],

Cell[TextData[{
  "This generates a message because the argument in ",
  StyleBox["Thickness", "MR"],
  " is not between zero and one.  The message appears when the image is \
displayed."
}], "Text",
  CellTags->"Graphics::realu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x, {x, 0, 1}, PlotStyle -> Thickness[10]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics::realu"],

Cell[BoxData[
    \(Graphics::"realu" \(\(:\)\(\ \)\) 
      "Argument in \!\(Thickness[10]\) is not a real number between 0 and 1."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::realu"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics::realu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MeshStyle::mesh", "ObjectNameWarningMessages",
  CellTags->"MeshStyle::mesh"],

Cell[BoxData[
    RowBox[{\(MeshStyle::"mesh"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ MeshStyle\ specification; \ 
      using\ the\ \(\(default\)\(.\)\)\)\)}]], "Message",
  CellTags->"MeshStyle::mesh"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MeshStyle", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["MeshStyle", "MR"],
  " option is expected to be a list of graphics directives specifying the \
style to use for mesh lines.\n\[FilledSmallSquare] This message is generated \
when the enclosing graphics expression is displayed."
}], "Notes",
  CellTags->"MeshStyle::mesh"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"MeshStyle::mesh"],

Cell[TextData[{
  "Evaluation of the following input generates a warning message because the \
value of the ",
  StyleBox["MeshStyle", "MR"],
  " option is expected to be a list.  The message appears when the image is \
displayed."
}], "Text",
  CellTags->"MeshStyle::mesh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DensityPlot[x + y, {x, 0, 1}, {y, 0, 1}, 
      MeshStyle -> Dashing[{0.01, 0.01}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"MeshStyle::mesh"],

Cell[BoxData[
    \(MeshStyle::"mesh" \(\(:\)\(\ \)\) 
      "\!\(Dashing[\(\({0.01`, 0.01`}\)\)]\) is not a valid MeshStyle \
specification; using the default."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"MeshStyle::mesh"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"MeshStyle::mesh"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of the ",
  StyleBox["MeshStyle", "MR"],
  " option."
}], "Text",
  CellTags->"MeshStyle::mesh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DensityPlot[x + y, {x, 0, 1}, {y, 0, 1}, 
      MeshStyle -> {Dashing[{0.01, 0.01}]}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"MeshStyle::mesh"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"MeshStyle::mesh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotRange::prng", "ObjectNameWarningMessages",
  CellTags->"PlotRange::prng"],

Cell[BoxData[
    RowBox[{\(PlotRange::"prng"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
PlotRange\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ All, \ Automatic, \ 
      or\ an\ appropriate\ list\ of\ range\ \
\(\(specifications\)\(.\)\)\)\)}]], "Message",
  CellTags->"PlotRange::prng"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PlotRange", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["PlotRange", "MR"],
  " option should be ",
  StyleBox["All", "MR"],
  ", ",
  StyleBox["Automatic", "MR"],
  ", a list of two numbers, or a list of pairs of numbers that give the range \
to use in each dimension."
}], "Notes",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PlotRange::prng"],

Cell[TextData[{
  "A number is not a valid value for the ",
  StyleBox["PlotRange", "MR"],
  " option."
}], "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], {x, 0, 5}, PlotRange -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PlotRange::prng"],

Cell[BoxData[
    \(PlotRange::"prng" \(\(:\)\(\ \)\) 
      "Value of option PlotRange -> \!\(2\) is not All, Automatic, or an \
appropriate list of range specifications."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PlotRange::prng"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PlotRange::prng"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of the ",
  StyleBox["PlotRange", "MR"],
  " option."
}], "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], {x, 0, 5}, PlotRange -> {0, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PlotRange::prng"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PlotRange::prng"]
}, Open  ]],

Cell[TextData[{
  "In a three-dimensional plot, range specifications can be given for one \
dimension (the ",
  StyleBox["z", "TI"],
  "-axis) or all three dimensions, but not just two dimensions."
}], "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x + y], {x, 0, 6}, {y, 0, 6}, 
      PlotRange -> {{0, 10}, {0, 6}}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"PlotRange::prng"],

Cell[BoxData[
    \(PlotRange::"prng" \(\(:\)\(\ \)\) 
      "Value of option PlotRange -> \!\({\(\({0, 10}\)\), \(\({0, 6}\)\)}\) \
is not All, Automatic, or an appropriate list of range specifications."\)], \
"Message",
  CellLabel->"From In[3]:=",
  CellTags->"PlotRange::prng"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"PlotRange::prng"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["PlotRange", "MR"],
  " to specify the range for all three dimensions in a three-dimensional \
plot."
}], "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x + y], {x, 0, 6}, {y, 0, 6}, 
      PlotRange -> {{0, 10}, {0, 6}, {0, 1}}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"PlotRange::prng"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"PlotRange::prng"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ViewCenter::viewc", "ObjectNameWarningMessages",
  CellTags->"ViewCenter::viewc"],

Cell[BoxData[
    \(ViewCenter::"viewc" \(\(:\)\(\ \)\) \(A\ projection\ cannot\ be\ \
constructed\ for\ a\ ViewCenter\ which\ coincides\ with\ a\ \
\(\(ViewPoint\)\(.\)\)\)\)], "Message",
  CellTags->"ViewCenter::viewc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ViewCenter", "MR"],
  " option and the value of the ",
  StyleBox["ViewPoint", "MR"],
  " option describe the same location.\n\[FilledSmallSquare] The ",
  StyleBox["ViewCenter", "MR"],
  " and ",
  StyleBox["ViewPoint", "MR"],
  " options use different scaled coordinate systems.\n\[FilledSmallSquare] \
This message is normally seen only when selecting unusual projections.  If \
you see this message in a situation in which it is not expected, please \
contact Technical Support."
}], "Notes",
  CellTags->"ViewCenter::viewc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ViewCenter::viewc"],

Cell[TextData[{
  "The values for the ",
  StyleBox["ViewCenter", "MR"],
  " and ",
  StyleBox["ViewPoint", "MR"],
  " options in this example correspond to the same point after scaling."
}], "Text",
  CellTags->"ViewCenter::viewc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Graphics[
      Graphics3D[
        Line[{{0, 0, 0}, {1, 1, 1}}], \n\ \ \ \ ViewPoint\  -> \ {1, 1, 
            1}, \n\ \ \ \ ViewCenter\  -> \ {1.5, 1.5, 1.5}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ViewCenter::viewc"],

Cell[BoxData[
    \(ViewCenter::"viewc" \(\(:\)\(\ \)\) 
      "A projection cannot be constructed for a ViewCenter which coincides \
with a ViewPoint."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ViewCenter::viewc"],

Cell[BoxData[
    \(Graphics3D::"noproj" \(\(:\)\(\ \)\) 
      "Mathematica is unable to make a projection matrix; check the settings \
of ViewPoint, ViewCenter, and ViewVertical."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ViewCenter::viewc"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ViewCenter::viewc"]
}, Open  ]],

Cell[TextData[{
  "A small change in the value of either the ",
  StyleBox["ViewCenter", "MR"],
  " option or the ",
  StyleBox["ViewPoint", "MR"],
  " option will correct the error."
}], "Text",
  CellTags->"ViewCenter::viewc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{Thickness[0.02], 
          Line[{{1, 0, 0}, {0, 1, 1}}]}, \n\ \ \ \ ViewPoint\  -> \ {1, 1, 
            1}, \n\ \ \ \ ViewCenter\  -> \ {1.6, 1.5, 1.6}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ViewCenter::viewc"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ViewCenter::viewc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ViewPoint::viewp", "ObjectNameWarningMessages",
  CellTags->"ViewPoint::viewp"],

Cell[BoxData[
    \(ViewPoint::"viewp" \(\(:\)\(\ \)\) \(A\ projection\ cannot\ be\ \
constructed\ for\ a\ ViewPoint\ inside\ the\ bounding\ \(\(box\)\(.\)\)\)\)], \
"Message",
  CellTags->"ViewPoint::viewp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ViewPoint", "MR"],
  " option falls inside of the bounding box in scaled coordinates.\n\
\[FilledSmallSquare] In the scaled coordinates used for the ",
  StyleBox["ViewPoint", "MR"],
  " option, the magnitude of at least one of the numbers in the value of the \
option must be greater than ",
  StyleBox["0.5", "MR"],
  " for the point to be outside of the bounding box."
}], "Notes",
  CellTags->"ViewPoint::viewp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ViewPoint::viewp"],

Cell[TextData[{
  "The point ",
  StyleBox["{0,0,0}", "MR"],
  " lies inside of the bounding box in scaled coordinates."
}], "Text",
  CellTags->"ViewPoint::viewp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[
        Line[{{1, 1, 1}, {10, 10, 10}}], \n\t\tViewPoint\  -> \ {0, 0, 
            0}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ViewPoint::viewp"],

Cell[BoxData[
    \(ViewPoint::"viewp" \(\(:\)\(\ \)\) 
      "A projection cannot be constructed for a ViewPoint inside the bounding \
box."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ViewPoint::viewp"],

Cell[BoxData[
    \(Graphics3D::"noproj" \(\(:\)\(\ \)\) 
      "Mathematica is unable to make a projection matrix; check the settings \
of ViewPoint, ViewCenter, and ViewVertical."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ViewPoint::viewp"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ViewPoint::viewp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the ",
  StyleBox["ViewPoint", "MR"],
  " option."
}], "Text",
  CellTags->"ViewPoint::viewp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[
        Line[{{1, 1, 1}, {10, 10, 10}}], \n\t\tViewPoint\  -> \ {0, 0, 
            0.6}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ViewPoint::viewp"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ViewPoint::viewp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SurfaceGraphics::noproj
Graphics3D::noproj\
\>", "ObjectNameWarningMessages",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"noproj\"\>"}], \(\(:\)\(\ \)\), \(Mathematica\ is\ unable\ \
to\ make\ a\ projection\ matrix; \ check\ the\ settings\ of\ ViewPoint, \ 
      ViewCenter, \ and\ \(\(ViewVertical\)\(.\)\)\)}]], "Message",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell["\<\
\[FilledSmallSquare] Generated by mathematical conditions that \
prevent the construction of a projection matrix for projecting a \
three-dimensional graphic into two dimensions.
\[FilledSmallSquare] A projection into two dimensions is needed in order to \
display a three-dimensional graphic on a two-dimensional device, such as a \
computer screen, or to print the image on paper.
\[FilledSmallSquare] This message is often preceded by other messages that \
provide additional details about the error.\
\>", "Notes",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[TextData[{
  "The value of the ",
  StyleBox["ViewPoint", "MR"],
  " option must be outside of the bounding box for the graphic."
}], "Text",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 3}, {y, 0, 3}, 
      ViewPoint -> {0, 0, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[BoxData[
    \(ViewPoint::"viewp" \(\(:\)\(\ \)\) 
      "A projection cannot be constructed for a ViewPoint inside the bounding \
box."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],

Cell[BoxData[
    \(SurfaceGraphics::"noproj" \(\(:\)\(\ \)\) 
      "Mathematica is unable to make a projection matrix; check the settings \
of ViewPoint, ViewCenter, and ViewVertical."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the ",
  StyleBox["ViewPoint", "MR"],
  " option."
}], "Text",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x\ y], {x, 0, 3}, {y, 0, 3}, 
      ViewPoint -> {0, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Graphics3D::gsing
Plot3D::gsing\
\>", "ObjectNameWarningMessages",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"gsing\"\>"}], \(\(:\)\(\ \)\), \(Singular\ homogeneous\ \
transformation\ \(\(generated\)\(.\)\)\)}]], "Message",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by mathematical conditions that prevent the \
construction of a projection matrix for projecting a three-dimensional \
graphic into two dimensions.\n\[FilledSmallSquare] If you see this message, \
check the values of the ",
  StyleBox["ViewCenter", "MR"],
  ", ",
  StyleBox["ViewPoint", "MR"],
  ", and ",
  StyleBox["ViewVertical", "MR"],
  " options.\n\[FilledSmallSquare] A projection into two dimensions is needed \
in order to display a three-dimensional graphic on a two-dimensional device, \
such as a computer screen, or to print the image on paper."
}], "Notes",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[TextData[{
  "These values of the ",
  StyleBox["ViewPoint", "MR"],
  " and ",
  StyleBox["ViewCenter", "MR"],
  " options give a singular projection matrix."
}], "Text",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Graphics[
      Graphics3D[
        Point[{1, 1, 1}], \n\ \ \ \ ViewPoint\  -> \ {0, 0, 
            1}, \n\ \ \ \ ViewCenter\  -> \ {0, 0, 1.5}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[BoxData[
    \(Graphics3D::"gsing" \(\(:\)\(\ \)\) 
      "Singular homogeneous transformation generated."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[BoxData[
    \(Graphics3D::"gsing" \(\(:\)\(\ \)\) 
      "Singular homogeneous transformation generated."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[BoxData[
    \(Graphics3D::"gsing" \(\(:\)\(\ \)\) 
      "Singular homogeneous transformation generated."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Graphics3D :: \"gsing\"\) will be suppressed \
during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}]
}, Open  ]],

Cell[TextData[{
  "A small change in the value of either the ",
  StyleBox["ViewPoint", "MR"],
  " option or the value of the ",
  StyleBox["ViewCenter", "MR"],
  " option will correct the error."
}], "Text",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Graphics[
      Graphics3D[
        Point[{1, 1, 1}], \n\ \ \ \ ViewPoint\  -> \ {0, 0, 
            1}, \n\ \ \ \ ViewCenter\  -> \ {0, 0, 1.6}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotRegion::plotr", "ObjectNameWarningMessages",
  CellTags->"PlotRegion::plotr"],

Cell[BoxData[
    RowBox[{\(PlotRegion::"plotr"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\
\ PlotRegion\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ two\ pairs\ of\ real\ numbers\ in\ the\ \
form\ \(\({{xmin, \ xmax}, \ {ymin, \ ymax}}\)\(.\)\)\)\)}]], "Message",
  CellTags->"PlotRegion::plotr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PlotRegion", "MR"],
  " option does not have the indicated form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["PlotRegion", "MR"],
  " option is expected to be two pairs of real numbers, with the second \
element in each pair larger than the first element in that pair."
}], "Notes",
  CellTags->"PlotRegion::plotr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PlotRegion::plotr"],

Cell[TextData[{
  "Evaluation of this input generates an error because the value of the ",
  StyleBox["PlotRegion", "MR"],
  " option includes a pair in which the second element is not larger than the \
first.  A plot will be generated using the default value of the ",
  StyleBox["PlotRegion", "MR"],
  " option."
}], "Text",
  CellTags->"PlotRegion::plotr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Thickness[0.05], 
          Line[{{0, 0}, {1, 1}}]}, \n\t\tBackground\  -> \ 
          GrayLevel[
            0.5], \n\t\tPlotRegion -> {{0.5, 1}, {1, 0.5}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PlotRegion::plotr"],

Cell[BoxData[
    \(PlotRegion::"plotr" \(\(:\)\(\ \)\) 
      "Value of option PlotRegion -> \!\({\(\({0.5`, 1}\)\), \(\({1, \
0.5`}\)\)}\) is not two pairs of real numbers in the form {{xmin, xmax}, \
{ymin, ymax}}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PlotRegion::plotr"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PlotRegion::plotr"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the ",
  StyleBox["PlotRegion", "MR"],
  " option."
}], "Text",
  CellTags->"PlotRegion::plotr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Thickness[0.05], 
          Line[{{0, 0}, {1, 1}}]}, \n\t\tBackground\  -> \ 
          GrayLevel[
            0.5], \n\t\tPlotRegion -> {{0, 0.5}, {0.5, 1}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PlotRegion::plotr"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PlotRegion::plotr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ViewVertical::viewv", "ObjectNameWarningMessages",
  CellTags->"ViewVertical::viewv"],

Cell[BoxData[
    \(ViewVertical::"viewv" \(\(:\)\(\ \)\) \(The\ ViewVertical\ vector\ must\
\ have\ a\ non - 
        zero\ component\ perpendicular\ to\ a\ line\ from\ the\ ViewPoint\ to\
\ the\ \(\(ViewCenter\)\(.\)\)\)\)], "Message",
  CellTags->"ViewVertical::viewv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ViewVertical", "MR"],
  " option does not have the indicated property.\n\[FilledSmallSquare] The ",
  StyleBox["ViewCenter", "MR"],
  ", ",
  StyleBox["ViewPoint", "MR"],
  " , and ",
  StyleBox["ViewVertical", "MR"],
  " options use different scaled coordinate systems.\n\[FilledSmallSquare] \
This message is normally seen only when selecting unusual projections.  If \
you see this message in a situation in which it is not expected, please \
contact Technical Support."
}], "Notes",
  CellTags->"ViewVertical::viewv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ViewVertical::viewv"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ViewVertical", "MR"],
  " option falls on a line between the value of the ",
  StyleBox["ViewCenter", "MR"],
  " option and the value of the ",
  StyleBox["ViewPoint", "MR"],
  " option, in scaled coordinates."
}], "Text",
  CellTags->"ViewVertical::viewv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[
        Line[{{0, 0, 0}, {1, 1, 1}}], \n\t\tViewCenter -> {0.5, 0.5, 0.5}, 
        ViewPoint -> {0, 0, 1}, \n\t\tViewVertical\  -> \ {0, 0, 
            1}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ViewVertical::viewv"],

Cell[BoxData[
    \(ViewVertical::"viewv" \(\(:\)\(\ \)\) 
      "The ViewVertical vector must have a non-zero component perpendicular \
to a line from the ViewPoint to the ViewCenter."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ViewVertical::viewv"],

Cell[BoxData[
    \(Graphics3D::"noproj" \(\(:\)\(\ \)\) 
      "Mathematica is unable to make a projection matrix; check the settings \
of ViewPoint, ViewCenter, and ViewVertical."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ViewVertical::viewv"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ViewVertical::viewv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AspectRatio::aspr", "ObjectNameWarningMessages",
  CellTags->"AspectRatio::aspr"],

Cell[BoxData[
    RowBox[{\(AspectRatio::"aspr"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\
\ AspectRatio\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ finite\ positive\ number\ or\ \
\(\(Automatic\)\(.\)\)\)\)}]], "Message",
  CellTags->"AspectRatio::aspr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["AspectRatio", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"AspectRatio::aspr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"AspectRatio::aspr"],

Cell[TextData[{
  "The value of the ",
  StyleBox["AspectRatio", "MR"],
  " option cannot be a list.  When this error occurs, an image is generated \
using a default aspect ratio."
}], "Text",
  CellTags->"AspectRatio::aspr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], {x, 0, 2}, AspectRatio -> {1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"AspectRatio::aspr"],

Cell[BoxData[
    \(AspectRatio::"aspr" \(\(:\)\(\ \)\) 
      "Value of option AspectRatio -> \!\({1}\) is not a finite positive \
number or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"AspectRatio::aspr"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"AspectRatio::aspr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Axes::axes", "ObjectNameWarningMessages",
  CellTags->"Axes::axes"],

Cell[BoxData[
    RowBox[{\(Axes::"axes"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ axis\ \
\(\(specification\)\(.\)\)\)\)}]], "Message",
  CellTags->"Axes::axes"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Axes", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["Axes", "MR"],
  " option can be ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["False", "MR"],
  ", or a list specifying ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  " for each axis."
}], "Notes",
  CellTags->"Axes::axes"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Axes::axes"],

Cell[TextData[{
  "This generates an error because the value of the ",
  StyleBox["Axes", "MR"],
  " option cannot be a list of numbers.  When this error occurs, no axes are \
drawn."
}], "Text",
  CellTags->"Axes::axes"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], \ {x, 0, 2}, Axes -> {1, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Axes::axes"],

Cell[BoxData[
    \(Axes::"axes" \(\(:\)\(\ \)\) 
      "\!\({1, 0}\) is not a valid axis specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Axes::axes"],

Cell[BoxData[
    \(Axes::"axes" \(\(:\)\(\ \)\) 
      "\!\({1, 0}\) is not a valid axis specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Axes::axes"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Axes::axes"]
}, Open  ]],

Cell["\<\
This shows a valid way to specify that only one axis should be \
drawn.\
\>", "Text",
  CellTags->"Axes::axes"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], \ {x, 0, 2}, Axes -> {True, False}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Axes::axes"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Axes::axes"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AxesEdge::axedg", "ObjectNameWarningMessages",
  CellTags->"AxesEdge::axedg"],

Cell[BoxData[
    RowBox[{\(AxesEdge::"axedg"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ axis\ edge\ \
\(\(specification\)\(.\)\)\)\)}]], "Message",
  CellTags->"AxesEdge::axedg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["AxesEdge", "MR"],
  " option does not have an expected form.\n\[FilledSmallSquare] The value of \
the ",
  StyleBox["AxesEdge", "MR"],
  " option is expected to be ",
  StyleBox["None", "MR"],
  ", ",
  StyleBox["Automatic", "MR"],
  ", or a list with three elements.\n\[FilledSmallSquare] If the value is a \
list, each element of that list describes the axis edge in a particular \
direction.  Each element should be ",
  StyleBox["None", "MR"],
  ", ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["{1,1}", "MR"],
  ", ",
  StyleBox["{1,-1}", "MR"],
  ", ",
  StyleBox["{-1, 1}", "MR"],
  ", or ",
  StyleBox["{-1, -1}", "MR"],
  "."
}], "Notes",
  CellTags->"AxesEdge::axedg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"AxesEdge::axedg"],

Cell[TextData[{
  "An error is generated in this example because the value of the ",
  StyleBox["AxesEdge", "MR"],
  " option does not match one of the expected forms.  When this error occurs, \
no axes are drawn."
}], "Text",
  CellTags->"AxesEdge::axedg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 1}, 
      AxesEdge -> {None, None, {0, 1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"AxesEdge::axedg"],

Cell[BoxData[
    \(AxesEdge::"axedg" \(\(:\)\(\ \)\) 
      "\!\({0, 1}\) is not a valid axis edge specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"AxesEdge::axedg"],

Cell[BoxData[
    \(AxesEdge::"axedg" \(\(:\)\(\ \)\) 
      "\!\({0, 1}\) is not a valid axis edge specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"AxesEdge::axedg"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"AxesEdge::axedg"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value of the ",
  StyleBox["AxesEdge", "MR"],
  " option."
}], "Text",
  CellTags->"AxesEdge::axedg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 1}, 
      AxesEdge -> {None, None, {1, 1}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"AxesEdge::axedg"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"AxesEdge::axedg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot::pldiv
Plot::pldiv\
\>", "ObjectNameWarningMessages",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"pldiv\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
PlotDivision\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "greater", " ", "than", " ", 
        "or", " ", "equal", " ", "to", " ", "1."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PlotDivision", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[TextData[{
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["PlotDivision", "MR"],
  " option."
}], "Text",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], {x, 0, 2}, PlotDivision -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[BoxData[
    \(Plot::"pldiv" \(\(:\)\(\ \)\) 
      "Value of option PlotDivision -> \!\(Automatic\) is not greater than or \
equal to 1."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[BoxData[
    \(Plot[Sin[\[Pi]\ x], {x, 0, 2}, 
      PlotDivision \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PlotDivision", "MR"],
  " option."
}], "Text",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], {x, 0, 2}, PlotDivision -> 1, 
      PlotPoints -> 4]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GridLines::grid", "ObjectNameWarningMessages",
  CellTags->"GridLines::grid"],

Cell[BoxData[
    RowBox[{\(GridLines::"grid"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ grid\ \
\(\(specification\)\(.\)\)\)\)}]], "Message",
  CellTags->"GridLines::grid"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["GridLines", "MR"],
  " option does not match an expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["GridLines", "MR"],
  " option is expected to be ",
  StyleBox["None", "MR"],
  ", ",
  StyleBox["Automatic", "MR"],
  ", or a list ",
  StyleBox["{", "MR"],
  StyleBox["xgrid", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["ygrid", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " specifying the grid in each direction.\n\[FilledSmallSquare] Each grid \
line is described either by a number giving the position of the line or by \
using a list ",
  StyleBox["{", "MR"],
  StyleBox["pos", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["style", "MR",
    FontSlant->"Italic"],
  StyleBox["}", "MR"],
  " indicating the position and style of the line.\n\[FilledSmallSquare] The \
value of the ",
  StyleBox["GridLines", "MR"],
  " option can also be a function that returns a grid specification when \
applied to the minimum and maximum values of the plot range."
}], "Notes",
  CellTags->"GridLines::grid"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"GridLines::grid"],

Cell[TextData[{
  "An error occurs in this example because the first element in the value of \
the ",
  StyleBox["GridLines", "MR"],
  " option is a specification for a single grid line rather than a list of \
such specifications."
}], "Text",
  CellTags->"GridLines::grid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 7}, 
      GridLines -> {{Pi, {Dashing[{ .01,  .01}]}}, None}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"GridLines::grid"],

Cell[BoxData[
    \(GridLines::"grid" \(\(:\)\(\ \)\) 
      "\!\({\[Pi], \(\({\(Dashing[\(\({0.01`, 0.01`}\)\)]\)}\)\)}\) is not a \
valid grid specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"GridLines::grid"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"GridLines::grid"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["GridLines", "MR"],
  " option specifying a single grid line."
}], "Text",
  CellTags->"GridLines::grid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 7}, 
      GridLines -> {{{Pi, {Dashing[{ .01,  .01}]}}}, None}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"GridLines::grid"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"GridLines::grid"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Circle::angle", "ObjectNameWarningMessages",
  CellTags->"Circle::angle"],

Cell[BoxData[
    RowBox[{\(Circle::"angle"\), \(\(:\)\(\ \)\), \(\(Starting\)\(\ \)\(angle\
\)\(\ \)\(is\)\(\ \)\(larger\)\(\ \)\(than\)\(\ \)\(ending\)\(\ \)\(angle\)\(\
\ \)\(in\)\(\ \)\(angle\)\(\ \)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Circle::angle"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["Circle", "MR"],
  " is a pair of numbers and the second number is not larger than the first \
number."
}], "Notes",
  CellTags->"Circle::angle"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Circle::angle"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["Circle", "MR"],
  " does not have the expected form."
}], "Text",
  CellTags->"Circle::angle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Circle[{0, 0}, 1, {3, 1}], 
          Line[{{\(-1\), \(-1\)}, {1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Circle::angle"],

Cell[BoxData[
    \(Circle::"angle" \(\(:\)\(\ \)\) 
      "Starting angle is larger than ending angle in angle specification \
\!\({3, 1}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Circle::angle"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Circle::angle"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Circle", "MR"],
  "."
}], "Text",
  CellTags->"Circle::angle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Circle[{0, 0}, 1, {1, 3}], Line[{{\(-1\), \(-1\)}, {1, 1}}]}, 
        AspectRatio -> 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Circle::angle"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Circle::angle"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disk::angle", "ObjectNameWarningMessages",
  CellTags->"Disk::angle"],

Cell[BoxData[
    RowBox[{\(Disk::"angle"\), \(\(:\)\(\ \)\), \(\(Starting\)\(\ \)\(angle\)\
\(\ \)\(is\)\(\ \)\(larger\)\(\ \)\(than\)\(\ \)\(ending\)\(\ \)\(angle\)\(\ \
\)\(in\)\(\ \)\(angle\)\(\ \)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Disk::angle"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["Disk", "MR"],
  " is a pair of numbers and the second number is not larger than the first \
number."
}], "Notes",
  CellTags->"Disk::angle"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Disk::angle"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["Disk", "MR"],
  " does not have the expected form."
}], "Text",
  CellTags->"Disk::angle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Disk[{0, 0}, 1, {3, 1}], 
          Line[{{\(-1\), \(-1\)}, {1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Disk::angle"],

Cell[BoxData[
    \(Disk::"angle" \(\(:\)\(\ \)\) 
      "Starting angle is larger than ending angle in angle specification \
\!\({3, 1}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Disk::angle"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Disk::angle"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Disk", "MR"],
  "."
}], "Text",
  CellTags->"Disk::angle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Disk[{0, 0}, 1, {1, 3}], Line[{{\(-1\), \(-1\)}, {1, 1}}]}, 
        AspectRatio -> 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Disk::angle"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Disk::angle"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Circle::radius", "ObjectNameWarningMessages",
  CellTags->"Circle::radius"],

Cell[BoxData[
    RowBox[{\(Circle::"radius"\), \(\(:\)\(\ \)\), \(\(Radius\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ number\ or\ a\ pair\ of\ \
positive\ \(\(numbers\)\(.\)\)\)\)}]], "Message",
  CellTags->"Circle::radius"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Circle", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"Circle::radius"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Circle::radius"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Circle", "MR"],
  " cannot be negative."
}], "Text",
  CellTags->"Circle::radius"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Circle[{0, 0}, \(-2\)], 
          Line[{{\(-1\), \(-1\)}, {1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Circle::radius"],

Cell[BoxData[
    \(Circle::"radius" \(\(:\)\(\ \)\) 
      "Radius \!\(-2\) is not a positive number or a pair of positive \
numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Circle::radius"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Circle::radius"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Circle", "MR"],
  "."
}], "Text",
  CellTags->"Circle::radius"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Circle[{0, 0}, 2], Line[{{\(-1\), \(-1\)}, {1, 1}}]}, 
        AspectRatio -> 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Circle::radius"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Circle::radius"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disk::radius", "ObjectNameWarningMessages",
  CellTags->"Disk::radius"],

Cell[BoxData[
    RowBox[{\(Disk::"radius"\), \(\(:\)\(\ \)\), \(\(Radius\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ number\ or\ a\ pair\ of\ \
positive\ \(\(numbers\)\(.\)\)\)\)}]], "Message",
  CellTags->"Disk::radius"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Disk", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"Disk::radius"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Disk::radius"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Disk", "MR"],
  " cannot be negative."
}], "Text",
  CellTags->"Disk::radius"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Disk[{0, 0}, \(-2\)], 
          Line[{{\(-1\), \(-1\)}, {1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Disk::radius"],

Cell[BoxData[
    \(Disk::"radius" \(\(:\)\(\ \)\) 
      "Radius \!\(-2\) is not a positive number or a pair of positive \
numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Disk::radius"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Disk::radius"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Disk", "MR"],
  "."
}], "Text",
  CellTags->"Disk::radius"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Disk[{0, 0}, 0.5], Line[{{\(-1\), \(-1\)}, {1, 1}}]}, 
        AspectRatio -> 1]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Disk::radius"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Disk::radius"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ColorOutput::colpn
ToColor::colpn\
\>", "ObjectNameWarningMessages",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"colpn\"\>"}], \(\(:\)\(\ \)\), "Result", " ", 
        StyleBox["expr",
          "TI"], " ", "obtained", " ", "during", " ", "color", " ", 
        "conversion", " ", "by", " ", "applying", " ", "function", " ", 
        StyleBox["f",
          "TI"], " ", "to", " ", "color", " ", 
        StyleBox["c",
          "TI"], " ", "contains", " ", "a", " ", "non"}], 
      "-", \(numerical\ \(\(argument\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell["\<\
\[FilledSmallSquare] Generated when color conversion using the \
indicated function results in a color directive with a non-numerical \
argument.\
\>", "Notes",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ColorOutput", "MR"],
  " option does not give a valid color specification when applied to a color \
directive."
}], "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x, \ {x, \ 0, \ 1}, \ 
      ColorOutput\  -> \ \((RGBColor[0, x, 0]\  &)\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[BoxData[
    \(ColorOutput::"colpn" \(\(:\)\(\ \)\) 
      "Result \!\(RGBColor[\(\(0, x, 0\)\)]\) obtained during color \
conversion by applying function \!\(\(\(RGBColor[\(\(0, x, 0\)\)]\)\) &\) to \
color \!\(GrayLevel[0.`]\) contains a non-numerical argument."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["ColorOutput", "MR"],
  " option."
}], "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x, \ {x, \ 0, \ 1}, \ 
      ColorOutput\  -> \ \((RGBColor[0, #[\([1]\)], 1]\  &)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]],

Cell[TextData[{
  "A similar message can also be generated by the ",
  StyleBox["ToColor", "MR"],
  " function."
}], "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToColor[GrayLevel[0.5], CMYKColor[0, 1, 1, #] &]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[BoxData[
    \(ToColor::"colpn" \(\(:\)\(\ \)\) 
      "Result \!\(CMYKColor[\(\(0, 1, 1, \(\(GrayLevel[0.5`]\)\)\)\)]\) \
obtained during color conversion by applying function \
\!\(\(\(CMYKColor[\(\(0, 1, 1, #1\)\)]\)\) &\) to color \!\(GrayLevel[0.5`]\) \
contains a non-numerical argument."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[BoxData[
    \(GrayLevel[0.`]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ToColor", "MR"],
  "."
}], "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToColor[GrayLevel[0.5], CMYKColor[0, 1, 1, #[\([1]\)]] &]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[BoxData[
    \(CMYKColor[0.`, 1.`, 1.`, 0.5`]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ContourGraphics::ctpnt", "ObjectNameWarningMessages",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) \(The\ contour\ is\ attempting\
\ to\ traverse\ a\ cell\ in\ which\ some\ of\ the\ points\ have\ not\ \
evaluated\ to\ numbers, \ 
      and\ it\ will\ be\ \(\(dropped\)\(.\)\)\)\)], "Message",
  CellTags->"ContourGraphics::ctpnt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an element that is not a real number \
is encountered while generating contour lines for a ",
  StyleBox["ContourGraphics", "MR"],
  " expression.\n\[FilledSmallSquare] The first argument in ",
  StyleBox["ContourGraphics", "MR"],
  " is expected to be an array of real numbers.\n\[FilledSmallSquare] This \
message can result from evaluating ",
  StyleBox["ContourPlot", "MR"],
  " or any other function that constructs a ",
  StyleBox["ContourGraphics", "MR"],
  " expression and causes contours to be computed for that expression."
}], "Notes",
  CellTags->"ContourGraphics::ctpnt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContourGraphics::ctpnt"],

Cell[TextData[{
  "An error occurs in this example because one of the elements in the first \
argument of ",
  StyleBox["ContourGraphics", "MR"],
  " is not a number."
}], "Text",
  CellTags->"ContourGraphics::ctpnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Graphics[
      ContourGraphics[{\n\t\t\t{Null, 2, 3, 4}, \n\t\t\t{2, 3, 5, 
            6}, \n\t\t\t{3, 4, 6, 8}, \n\t\t\t{4, 5, 8, 10}}, 
        ContourShading -> False]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ContourGraphics :: \"ctpnt\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContourGraphics::ctpnt"]
}, Open  ]],

Cell[TextData[{
  "Similar messages can be generated if ",
  StyleBox["ContourPlot", "MR"],
  " is used to plot a function that does not evaluate to a real number at \
some or all points in the range of the plotting variables."
}], "Text",
  CellTags->"ContourGraphics::ctpnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[Sqrt[x - 2], {x, 1, 3}, {y, 1, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctsm" \(\(:\)\(\ \)\) 
      "It is not possible to shade a ContourGraphics object if some of the \
mesh points do not evaluate to numbers."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ContourGraphics :: \"ctpnt\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctpnt"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ContourGraphics::ctpnt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ContourGraphics::ctsm", "ObjectNameWarningMessages",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctsm" \(\(:\)\(\ \)\) \(It\ is\ not\ possible\ to\ \
shade\ a\ ContourGraphics\ object\ if\ some\ of\ the\ mesh\ points\ do\ not\ \
evaluate\ to\ \(\(numbers\)\(.\)\)\)\)], "Message",
  CellTags->"ContourGraphics::ctsm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an element that is not a real number \
is encountered while shading contours for a ",
  StyleBox["ContourGraphics", "MR"],
  " expression.\n\[FilledSmallSquare] This message is usually accompanied by \
other messages that are generated when contour lines are computed.\n\
\[FilledSmallSquare] Contour shading is controlled by the ",
  StyleBox["ContourShading", "MR"],
  " option, which is ",
  StyleBox["True", "MR"],
  " by default.\n\[FilledSmallSquare] The first argument in ",
  StyleBox["ContourGraphics", "MR"],
  " is expected to be an array of real numbers.\n\[FilledSmallSquare] This \
message can result from evaluating ",
  StyleBox["ContourPlot", "MR"],
  " or any other function that constructs a ",
  StyleBox["ContourGraphics", "MR"],
  " expression and causes contours to be computed for that expression."
}], "Notes",
  CellTags->"ContourGraphics::ctsm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContourGraphics::ctsm"],

Cell[TextData[{
  "Warning messages are generated in this example because one of the elements \
in the first argument of ",
  StyleBox["ContourGraphics", "MR"],
  " is not a real number."
}], "Text",
  CellTags->"ContourGraphics::ctsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Graphics[
      ContourGraphics[{\n\t\t\t{Null, 2, 3, 4}, \n\t\t\t{2, 3, 5, 
            6}, \n\t\t\t{3, 4, 6, 8}, \n\t\t\t{4, 5, 8, 10}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctsm" \(\(:\)\(\ \)\) 
      "It is not possible to shade a ContourGraphics object if some of the \
mesh points do not evaluate to numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ContourGraphics :: \"ctpnt\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContourGraphics::ctsm"]
}, Open  ]],

Cell[TextData[{
  "Similar messages can result if ",
  StyleBox["ContourPlot", "MR"],
  " is used to plot a function that does not evaluate to a real number at \
each point in the range."
}], "Text",
  CellTags->"ContourGraphics::ctsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[ArcSin[x + y], {x, 0, 1}, {y, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctsm" \(\(:\)\(\ \)\) 
      "It is not possible to shade a ContourGraphics object if some of the \
mesh points do not evaluate to numbers."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(ContourGraphics::"ctpnt" \(\(:\)\(\ \)\) 
      "The contour is attempting to traverse a cell in which some of the \
points have not evaluated to numbers, and it will be dropped."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ContourGraphics :: \"ctpnt\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContourGraphics::ctsm"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ContourGraphics::ctsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ContourGraphics::gmat
DensityGraphics::gmat
SurfaceGraphics::gmat\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"gmat\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "rectangular", " ", 
        "array", " ", "larger", " ", "than", " ", "2", " ", "x", " ", 
        "2."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated if the first argument in ",
  StyleBox["ContourGraphics", "MR"],
  ", ",
  StyleBox["DensityGraphics", "MR"],
  ", or ",
  StyleBox["SurfaceGraphics", "MR"],
  " is not an array or does not have two or more elements in each dimension.\n\
\[FilledSmallSquare] This message is generated when the ",
  StyleBox["ContourGraphics", "MR"],
  ", ",
  StyleBox["DensityGraphics", "MR"],
  ", or ",
  StyleBox["SurfaceGraphics", "MR"],
  " expression is displayed or converted to another form."
}], "Notes",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[TextData[{
  "An error occurs in this example because the first element in the ",
  StyleBox["DensityGraphics", "MR"],
  " expression is not an array."
}], "Text",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[DensityGraphics[{1, 2, 3, 4, 5, 6}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[BoxData[
    \(DensityGraphics::"gmat" \(\(:\)\(\ \)\) 
      "\!\({1, 2, 3, 4, 5, 6}\) is not a rectangular array larger than 2 x \
2."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["DensityGraphics", "MR"],
  "."
}], "Text",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[DensityGraphics[{{1, 2, 3}, {4, 5, 6}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ContourGraphics::meshr
DensityGraphics::meshr
SurfaceGraphics::meshr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"meshr\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
MeshRange\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
        " ", \(\({{xmin, \ xmax}, \ {ymin, \ ymax}}\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MeshRange", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["MeshRange", "MR"],
  " option is expected to be either ",
  StyleBox["Automatic", "MR"],
  " or a list of two pairs giving the minimum and maximum values for the \
range to use in each dimension.\n\[FilledSmallSquare] This message is \
generated when the ",
  StyleBox["ContourGraphics", "MR"],
  ", ",
  StyleBox["DensityGraphics", "MR"],
  ", or ",
  StyleBox["SurfaceGraphics", "MR"],
  " expression is displayed or coerced to a different type of graphics \
expression."
}], "Notes",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["MeshRange", "MR"],
  " option is not a list of two pairs of real numbers."
}], "Text",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      ContourGraphics[{\n\t\t{1, 2, 3, 4}, \n\t\t{2, 3, 5, 7}, \n\t\t{3, 4, 
            8, 10}, \n\t\t{4, 5, 11, 14}}, MeshRange -> {0, 1}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[BoxData[
    \(ContourGraphics::"meshr" \(\(:\)\(\ \)\) 
      "Value of option MeshRange -> \!\({0, 1}\) is not of the form {{xmin, \
xmax}, {ymin, ymax}}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["MeshRange", "MR"],
  " option."
}], "Text",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      ContourGraphics[{\n\t\t{1, 2, 3, 4}, \n\t\t{2, 3, 5, 7}, \n\t\t{3, 4, 
            8, 10}, \n\t\t{4, 5, 11, 14}}, 
        MeshRange -> {{0, 1}, {0, 1}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ContourPlot::pllim
DensityPlot::pllim
ParametricPlot::pllim
Plot3D::pllim
Plot::pllim
ParametricPlot3D::pllim
Play::pllim\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"pllim\"\>"}], \(\(:\)\(\ \)\), "Range", " ", 
      "specification", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
      " ", \(\({x, \ xmin, \ xmax}\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated plot limits do \
not have the expected form.\
\>", "Notes",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Plot", "MR"],
  " is expected to be a list giving the variable and the range of the \
variable."
}], "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[BoxData[
    \(Plot::"pllim" \(\(:\)\(\ \)\) 
      "Range specification \!\(x\) is not of the form {x, xmin, xmax}."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}],

Cell[BoxData[
    \(Plot[Sin[x], x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Plot", "MR"],
  "."
}], "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]],

Cell[TextData[{
  "This generates an error because the form of the arguments in ",
  StyleBox["Plot", "MR"],
  " is checked before those arguments are evaluated."
}], "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{lims, x}, lims = {x, 0, 2}; Plot[Sin[Pi\ x], lims]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[BoxData[
    \(Plot::"pllim" \(\(:\)\(\ \)\) 
      "Range specification \!\(lims\) is not of the form {x, xmin, \
xmax}."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}],

Cell[BoxData[
    \(Plot::"pllim" \(\(:\)\(\ \)\) 
      "Range specification \!\(lims\) is not of the form {x, xmin, \
xmax}."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}],

Cell[BoxData[
    \(Plot[Sin[\[Pi]\ x], lims]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]],

Cell[TextData[{
  "If a value for the plot limits is defined outside of the ",
  StyleBox["Plot", "MR"],
  ", you can use ",
  StyleBox["Evaluate", "MR"],
  " to cause that value to be used."
}], "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{lims, x}, lims = {x, 0, 2}; 
      Plot[Sin[Pi\ x], Evaluate[lims]]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Play::plx", "ObjectNameWarningMessages",
  CellTags->"Play::plx"],

Cell[BoxData[
    RowBox[{\(Play::"plx"\), \(\(:\)\(\ \)\), \(\(First\)\(\ \)\(argument\)\(\
\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(does\ not\ contain\ any\ functions\ to\ \
\(\(play\)\(.\)\)\)\)}]], "Message",
  CellTags->"Play::plx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first in argument ",
  StyleBox["Play", "MR"],
  " is a list with no elements."
}], "Notes",
  CellTags->"Play::plx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Play::plx"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Play", "MR"],
  " is an empty list."
}], "Text",
  CellTags->"Play::plx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[{}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Play::plx"],

Cell[BoxData[
    \(Play::"plx" \(\(:\)\(\ \)\) 
      "First argument \!\({}\) does not contain any functions to play."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Play::plx"],

Cell[BoxData[
    \(Play[{}, {t, 0, 1}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Play::plx"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Play", "MR"],
  "."
}], "Text",
  CellTags->"Play::plx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sin[440  t], {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Play::plx"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Play::plx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ContourPlot::plnr
DensityPlot::plnr
Plot::plnr\
\>", "ObjectNameWarningMessages",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"plnr\"\>"}], ":", " ", 
        RowBox[{
          RowBox[{
            StyleBox["expr",
              "TI"], " ", "is", " ", "not", " ", "a", " ", "machine"}], "-", 
          RowBox[{"size", " ", "real", " ", "number", " ", "at", " ", 
            StyleBox["var",
              "TI"]}]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ContourPlot", "MR"],
  ", ",
  StyleBox["DensityPlot", "MR"],
  ", or ",
  StyleBox["Plot", "MR"],
  " does not evaluate to a machine-size real number at the indicated point.\n\
\[FilledSmallSquare] The cause of this error can often be determined by \
temporarily assigning the indicated value to the plot variable, evaluating \
the first argument of the plotting function, and observing whether or not the \
result is a real number.\n\[FilledSmallSquare] If ",
  StyleBox["Plot", "MR"],
  " is used to plot a list of functions, that list should appear explicitly \
as the first argument in ",
  StyleBox["Plot", "MR"],
  " or should be introduced using ",
  StyleBox["Evaluate", "MR"],
  " or other means."
}], "Notes",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell["\<\
Error messages are generated in this example because the symbolic \
parameters in the function to be plotted do not have numerical values.\
\>", \
"Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[c\ x\  + \ d, {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(\(\(c\\ x\)\) + d\) is not a machine-size real number at \!\(x\) = \
\!\(4.166666666666666`*^-8\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(\(\(c\\ x\)\) + d\) is not a machine-size real number at \!\(x\) = \
\!\(0.04056699157291579`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(\(\(c\\ x\)\) + d\) is not a machine-size real number at \!\(x\) = \
\!\(0.08480879985937367`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot :: \"plnr\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],

Cell["\<\
The plot is constructed without difficulty if numerical values are \
added for all of the symbolic parameters.\
\>", "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{c = 1, d = 2}, Plot[c\ x\  + \ d, {x, 0, 1}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],

Cell[TextData[{
  "This generates an error because the arguments in ",
  StyleBox["Plot", "MR"],
  " are not evaluated before ",
  StyleBox["Plot", "MR"],
  " checks to determine if the first argument is a list."
}], "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{expr = {Sin[x], Cos[x]}}, Plot[expr, {x, 0, 7}]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(expr\) is not a machine-size real number at \!\(x\) = \
\!\(2.916666666666667`*^-7\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(expr\) is not a machine-size real number at \!\(x\) = \
\!\(0.28396894101041054`\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(expr\) is not a machine-size real number at \!\(x\) = \
\!\(0.5936615990156159`\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot :: \"plnr\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],

Cell[TextData[{
  "If a value of the function to be plotted is defined outside of ",
  StyleBox["Plot", "MR"],
  ", you can use ",
  StyleBox["Evaluate", "MR"],
  " to cause that value to be used."
}], "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{expr = {Sin[x], Cos[x]}}, 
      Plot[Evaluate[expr], {x, 0, 7}]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],

Cell["\<\
An error occurs in this example because the principle value of the \
cube root function is not a real number if the argument is negative.\
\>", \
"Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[x^\((1/3)\), {x, \(-1\), 1}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(x\^\(1/3\)\) is not a machine-size real number at \!\(x\) = \
\!\(-0.9999999166666667`\)."\)], "Message",
  CellLabel->"From In[5]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(x\^\(1/3\)\) is not a machine-size real number at \!\(x\) = \
\!\(-0.9188660168541684`\)."\)], "Message",
  CellLabel->"From In[5]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(Plot::"plnr" \(\(:\)\(\ \)\) 
      "\!\(x\^\(1/3\)\) is not a machine-size real number at \!\(x\) = \
\!\(-0.8303824002812525`\)."\)], "Message",
  CellLabel->"From In[5]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot :: \"plnr\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[5]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],

Cell["\<\
The numerical value of the function to be plotted can be seen by \
assigning a value to the variable and evaluating the function.  In this \
example, the result is not a real number.\
\>", "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x = \(-1. \)}, x^\((1/3)\)]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    \(\(\(0.5000000000000001`\)\(\[InvisibleSpace]\)\) + 
      0.8660254037844386`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],

Cell[TextData[{
  "Other constructions can be used to select a different branch of the cube \
root function.  (See also the standard add-on package ",
  StyleBox["Miscellaneous`RealOnly`", "MR"],
  ".)"
}], "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sign[x]\ Abs[x]^\((1/3)\), {x, \(-1\), 1}]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ContourPlot::pptt
DensityPlot::pptt
Plot3D::pptt\
\>", "ObjectNameWarningMessages",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"pptt\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
PlotPoints\)}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "an", " ", "integer"}], " ", ">=",
         " ", \(2\ or\ a\ list\ of\ two\ such\ \(\(integers\)\(.\)\)\)}]}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PlotPoints", "MR"],
  " option does not have the indicated form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["PlotPoints", "MR"],
  " option in ",
  StyleBox["ContourPlot", "MR"],
  ", ",
  StyleBox["DensityPlot", "MR"],
  ", and ",
  StyleBox["Plot3D", "MR"],
  " is expected to be an integer greater than or equal to 2, or a list of two \
such integers that specify the number of points to use in each dimension."
}], "Notes",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["PlotPoints", "MR"],
  " option in ",
  StyleBox["DensityPlot", "MR"],
  "."
}], "Text",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DensityPlot[x\ y, {x, 0, 1}, {y, 0, 1}, 
      PlotPoints -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[BoxData[
    \(DensityPlot::"pptt" \(\(:\)\(\ \)\) 
      "Value of option PlotPoints -> \!\(Automatic\) is not an integer >= 2 \
or a list of two such integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[BoxData[
    \(DensityPlot[x\ y, {x, 0, 1}, {y, 0, 1}, 
      PlotPoints \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PlotPoints", "MR"],
  " option in ",
  StyleBox["DensityPlot", "MR"],
  "."
}], "Text",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DensityPlot[x\ y, {x, 1, 2}, {y, 1, 2}, 
      PlotPoints -> {3, 4}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ContourSmoothing::ctnsm", "ObjectNameWarningMessages",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[BoxData[
    RowBox[{\(ContourSmoothing::"ctnsm"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ \
option\ ContourSmoothing\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ True, \ Automatic, \ False, \ 
      or\ \(\(None\)\(.\)\)\)\)}]], "Message",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ContourSmoothing", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["ContourSmoothing", "MR"],
  " option."
}], "Text",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContourPlot[Sin[x]\ Sin[y], {x, 0, 6}, {y, 0, 3}, 
      ContourShading -> False, ContourSmoothing -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[BoxData[
    \(ContourSmoothing::"ctnsm" \(\(:\)\(\ \)\) 
      "Value of option ContourSmoothing -> \!\(All\) is not True, Automatic, \
False, or None."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContourSmoothing::ctnsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Dashing::dshn
AbsoluteDashing::dshn\
\>", "ObjectNameWarningMessages",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dshn\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", 
      " ", \(\(numbers\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression from the \
argument of ",
  StyleBox["Dashing", "MR"],
  " or ",
  StyleBox["AbsoluteDashing", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] This message is \
generated when the enclosing graphics expression is rendered, rather than \
when the graphics expression is constructed.\n\[FilledSmallSquare] This \
message can be generated by style specifications in the value of the ",
  StyleBox["FaceGrids", "MR"],
  " option."
}], "Notes",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["FaceGrids", "MR"],
  " option includes an incorrect dashing specification.  When this error \
occurs, the grid lines are drawn using a default line style."
}], "Text",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 3}, {y, 0, 1}, PlotPoints -> 4, 
      FaceGrids -> {{{\(-1\), 0, 
              0}, {None, {{1, Dashing[0.02]}, {2, 
                  Dashing[0.02]}}}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[BoxData[
    \(Dashing::"dshn" \(\(:\)\(\ \)\) 
      "Argument in \!\(Dashing[0.02`]\) is not a list of numbers."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],

Cell[BoxData[
    \(Dashing::"dshn" \(\(:\)\(\ \)\) 
      "Argument in \!\(Dashing[0.02`]\) is not a list of numbers."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid dashing specification in the value of the ",
  StyleBox["FaceGrids", "MR"],
  " option."
}], "Text",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 3}, {y, 0, 1}, PlotPoints -> 4, 
      FaceGrids -> {{{\(-1\), 0, 
              0}, {None, {{1, Dashing[{0.02}]}, {2, 
                  Dashing[{0.02}]}}}}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DefaultFont::dfont", "ObjectNameWarningMessages",
  CellTags->"DefaultFont::dfont"],

Cell[BoxData[
    \(DefaultFont::"dfont" \(\(:\)\(\ \)\) 
      "$DefaultFont specification `1` is not of the form {\"name\", \
size}."\)], "Message",
  CellLabel->"From In[44]:=",
  CellTags->"DefaultFont::dfont"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated value of the ",
  StyleBox["DefaultFont", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["DefaultFont", "MR"],
  " option is expected to be a string giving the name of a font, a number \
giving the size of a font, or a list giving both the name and the size of a \
font.\n\[FilledSmallSquare] The default value of the ",
  StyleBox["DefaultFont", "MR"],
  " option is the value of the global variable ",
  StyleBox["$DefaultFont", "MR"],
  "."
}], "Notes",
  CellTags->"DefaultFont::dfont"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DefaultFont::dfont"],

Cell[TextData[{
  "A warning message is generated in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid font specification."
}], "Text",
  CellTags->"DefaultFont::dfont"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], {x, 0, 2}, DefaultFont -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DefaultFont::dfont"],

Cell[BoxData[
    \(DefaultFont::"dfont" \(\(:\)\(\ \)\) 
      "$DefaultFont specification \!\(Automatic\) is not of the form \
{\"name\", size}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DefaultFont::dfont"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DefaultFont::dfont"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["DefaultFont", "MR"],
  " option."
}], "Text",
  CellTags->"DefaultFont::dfont"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[Pi\ x], {x, 0, 2}, 
      DefaultFont -> {"\<Courier\>", \ 20}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"DefaultFont::dfont"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"DefaultFont::dfont"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DefaultFont::font", "ObjectNameWarningMessages",
  CellTags->"DefaultFont::font"],

Cell[BoxData[
    RowBox[{\(DefaultFont::"font"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\
\ DefaultFont\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ used\ as\ a\ font; \ 
      using\ global\ $DefaultFont\ \(\(instead\)\(.\)\)\)\)}]], "Message",
  CellTags->"DefaultFont::font"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"DefaultFont::font"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::zval", "ObjectNameWarningMessages",
  CellTags->"General::zval"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"zval\"\>"}], \(\(:\)\(\ \)\), "Non"}], "-", 
      RowBox[{"numerical", " ", "value", " ", 
        StyleBox["expr",
          "TI"], " ", "found", " ", "at", " ", "position", " ", 
        StyleBox["pos",
          "TI"], " ", "in", " ", "first", 
        " ", \(\(argument\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::zval"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression that is not a real \
number is found at the indicated position in the first argument of ",
  StyleBox["ContourGraphics", "MR"],
  " or ",
  StyleBox["DensityGraphics", "MR"],
  ".\n\[FilledSmallSquare] This message is generated when the ",
  StyleBox["ContourGraphics", "MR"],
  " or ",
  StyleBox["DensityGraphics", "MR"],
  " expression is displayed or rendered, rather than when it is constructed."
}], "Notes",
  CellTags->"General::zval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::zval"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["DensityGraphics", "MR"],
  " includes a complex number."
}], "Text",
  CellTags->"General::zval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[DensityGraphics[{{1, 2, 3}, {2, I, 2}, {3, 2, 1}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::zval"],

Cell[BoxData[
    \(DensityGraphics::"zval" \(\(:\)\(\ \)\) 
      "Non-numerical value \!\(\[ImaginaryI]\) found at position \!\({2, 2}\) \
in first argument."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::zval"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::zval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::badargs", "ObjectNameWarningMessages",
  CellTags->"Display::badargs"],

Cell[BoxData[
    RowBox[{\(Display::"badargs"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"]}]], "Message",
  CellTags->"Display::badargs"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Display::badargs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::dispgif", "ObjectNameWarningMessages",
  CellTags->"Display::dispgif"],

Cell[BoxData[
    \(Display::"dispgif" \(\(:\)\(\ \)\) \(Too\ many\ arguments\ for\ GIF\ \(\
\(conversion\)\(.\)\)\)\)], "Message",
  CellTags->"Display::dispgif"],

Cell["\<\
\[FilledSmallSquare] Generated by an internal error while rendering \
a graphics expression in GIF format.
\[FilledSmallSquare] If you see this message in an example where it should be \
possible to generate the requested GIF file, please contact Technical \
Support.\
\>", "Notes",
  CellTags->"Display::dispgif"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::dopen", "ObjectNameWarningMessages",
  CellTags->"Display::dopen"],

Cell[BoxData[
    \(Display::"dopen" \(\(:\)\(\ \)\) 
      "There is an error opening the output file \"`1`\"."\)], "Message",
  CellLabel->"From In[44]:=",
  CellTags->"Display::dopen"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Display", "MR"],
  " is unable to open the indicated file.\n\[FilledSmallSquare] An error \
opening a file can occur if the name of this file is not appropriate for the \
operating system that you are using, or file protections or system errors \
prevent opening the file.\n\[FilledSmallSquare] This message is normally seen \
only when rendering graphics in a non-default format."
}], "Notes",
  CellTags->"Display::dopen"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Display::dopen"],

Cell["\<\
An error will occur in this example if the specified file cannot be \
opened.  Note that this input is otherwise entirely valid and will open and \
write to a file if it is possible to do so on your computer.\
\>", "Text",
  CellTags->"Display::dopen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<DFILE\>", \ Graphics[Point[{0, 0}]], \ "\<GIF\>"]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"Display::dopen"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Display::dopen"],

Cell["\<\
Display::dopen: There is an error opening output file \
\"DFILE\".\
\>", "Message",
  CellLabel->"From In[1]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Display::dopen"],

Cell[OutputFormData["\<\
Graphics[Point[{0, 0}]]\
\>", "\<\
-Graphics-\
\>"], \
"Output",
  CellLabel->"Out[1]=",
  FormatType->StandardForm,
  CellTags->"Display::dopen"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::dwrite", "ObjectNameWarningMessages",
  CellTags->"Display::dwrite"],

Cell[BoxData[
    \(Display::"dwrite" \(\(:\)\(\ \)\) 
      "There is an error writing to the output file \"`1`\"."\)], "Message",
  CellLabel->"From In[44]:=",
  CellTags->"Display::dwrite"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Display", "MR"],
  " is unable to write to the indicated file.\n\[FilledSmallSquare] An error \
writing to a file can occur if file protections or system errors prevent this \
operation.\n\[FilledSmallSquare] This message is normally seen only when \
rendering graphics in a non-default format."
}], "Notes",
  CellTags->"Display::dwrite"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Display::dwrite"],

Cell["\<\
An error will occur in this example if it is not possible to write \
to the indicated file.  Note that this input is otherwise entirely valid and \
will open and write to a file if it is possible to do so on your \
computer.\
\>", "Text",
  CellTags->"Display::dwrite"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<DFILE\>", \ Graphics[Point[{0, 0}]], \ "\<GIF\>"]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"Display::dwrite"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Display::dwrite"],

Cell["\<\
Display::dwrite: There is an error writing to output file \
\"DFILE\".\
\>", "Message",
  CellLabel->"From In[1]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Display::dwrite"],

Cell[OutputFormData["\<\
Graphics[Point[{0, 0}]]\
\>", "\<\
-Graphics-\
\>"], \
"Output",
  CellLabel->"Out[1]=",
  FormatType->StandardForm,
  CellTags->"Display::dwrite"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::fname", "ObjectNameWarningMessages",
  CellTags->"Display::fname"],

Cell[BoxData[
    RowBox[{\(Display::"fname"\), \(\(:\)\(\ \)\), \(\(Filename\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(string\)\(.\)\)\)\)}]], "Message",
  CellTags->"Display::fname"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Display", "MR"],
  " is not a string.\n\[FilledSmallSquare] The first argument in ",
  StyleBox["Display", "MR"],
  " should give the name of a file or other suitable output channel.\n\
\[FilledSmallSquare] This message is normally seen only when rendering \
graphics in a non-default format."
}], "Notes",
  CellTags->"Display::fname"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Display::fname"],

Cell[TextData[{
  "An error may occur if the arguments in ",
  StyleBox["Display", "MR"],
  " are not in the correct order.  In this example, the name of the file \
should be the first argument rather than the second argument."
}], "Text",
  CellTags->"Display::fname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display[Graphics[Point[{0, 0}]], "\<DFILE\>", "\<GIF\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Display::fname"],

Cell[BoxData[
    RowBox[{\(Display::"fname"\), \(\(:\)\(\ \)\), "\<\"Filename \
\\!\\(\\*TagBox[\\(\[SkeletonIndicator] Graphics \[SkeletonIndicator]\\), \
False, Rule[Editable, False]]\\) is not a string.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Display::fname"],

Cell[BoxData[
    \("DFILE"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Display::fname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::gfile", "ObjectNameWarningMessages",
  CellTags->"Display::gfile"],

Cell[BoxData[
    RowBox[{\(Display::"gfile"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ \(\(filename\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Display::gfile"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression does \
not correspond to a valid file or output channel.
\[FilledSmallSquare] A valid output channel can be an output stream or a \
string giving the name of an output file.\
\>", "Notes",
  CellTags->"Display::gfile"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Display::gfile"],

Cell["\<\
An error occurs in this example because the name of the output file \
cannot be a number.\
\>", "Text",
  CellTags->"Display::gfile"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display[7, Graphics[Point[{0, 0}]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Display::gfile"],

Cell[BoxData[
    \(Display::"gfile" \(\(:\)\(\ \)\) 
      "\!\(7\) is not a valid filename."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Display::gfile"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Display::gfile"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Display::image
Export::image
ExportString::image\
\>", "ObjectNameWarningMessages",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"image\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", " ",
         "two", " ", "numbers", " ", "or", 
        " ", \(\(Automatic\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ImageOffset", "MR"],
  ", ",
  StyleBox["ImageResolution", "MR"],
  ", or ",
  StyleBox["ImageSize", "MR"],
  " option in ",
  StyleBox["Display", "MR"],
  " does not have the indicated form.\n\[FilledSmallSquare] This message \
normally occurs only for display formats that use these options."
}], "Notes",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[TextData[{
  "An error occurs in this example because an empty list is not a valid value \
for the ",
  StyleBox["ImageSize", "MR"],
  " option in ",
  StyleBox["Display", "MR"],
  "."
}], "Text",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<DFILE.gif\>", Graphics[Point[{0, 0}]], "\<GIF\>", 
      ImageSize -> {}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[BoxData[
    \(Display::"image" \(\(:\)\(\ \)\) 
      "Value of option \!\(ImageSize\) -> \!\({\(\({}\)\), Automatic}\) is \
not a list of two numbers or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::noform", "ObjectNameWarningMessages",
  CellTags->"Display::noform"],

Cell[BoxData[
    RowBox[{\(Display::"noform"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "recognized", " ", 
      "Display", " ", \(format . \ The\), " ", "available", " ", "formats", 
      " ", "include", " ", 
      RowBox[{
        StyleBox["forms",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Display::noform"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated dislay format is not \
available in this version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] The display format is specified in the third \
argument of ",
  StyleBox["Display", "MR"],
  "."
}], "Notes",
  CellTags->"Display::noform"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Display::noform"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["Display", "MR"],
  " does not correspond to a recognized display format.  The available \
formats are listed in the warning message."
}], "Text",
  CellTags->"Display::noform"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<DFILE\>", Graphics[Point[{0, 0}]], "\<dform\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Display::noform"],

Cell[BoxData[
    \(Display::"noform" \(\(:\)\(\ \)\) 
      "\!\(\"dform\"\) is not a recognized Display format. The available \
formats include \!\(\"EPS, EpsonFX, EpsonLQ, GIF, IBMPr\"\[Ellipsis]\"ter, \
Tektronix, TIFF, TTY, XBitmap\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Display::noform"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Display::noform"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::nolink", "ObjectNameWarningMessages",
  CellTags->"Display::nolink"],

Cell[BoxData[
    \(Display::"nolink" \(\(:\)\(\ \)\) \(Link\ to\ display\ device\ could\ \
not\ be\ \(\(opened\)\(.\)\)\)\)], "Message",
  CellTags->"Display::nolink"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection to the external program that handles ",
  StyleBox["Display", "MR"],
  " cannot be opened.\n\[FilledSmallSquare] This message normally indicates a \
problem with the system facilities required by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  ", or a missing or corrupted display program.\n\[FilledSmallSquare] If you \
see this message in a situation in which it is not expected, please contact \
Technical Support."
}], "Notes",
  CellTags->"Display::nolink"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::pserr", "ObjectNameWarningMessages",
  CellTags->"Display::pserr"],

Cell[BoxData[
    RowBox[{\(Display::"pserr"\), ":", " ", 
      StyleBox["message",
        "TI"]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Display::pserr"],

Cell["\<\
\[FilledSmallSquare] Generated by an internal error while rendering \
a graphics expression.
\[FilledSmallSquare] This message normally indicates that an error has \
occurred within the external program that handles rendering in non-default \
graphics formats.  The text of the message originates in the external program \
and may be different on different systems.
\[FilledSmallSquare] If you see this message in a situation where it should \
be possible to render the specified graphics expression in the requested \
format, please contact Technical Support.\
\>", "Notes",
  CellTags->"Display::pserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display::type", "ObjectNameWarningMessages",
  CellTags->"Display::type"],

Cell[BoxData[
    RowBox[{\(Display::"type"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ graphics, \ notebook, \ cell, \ 
      or\ box\ \(\(expression\)\(.\)\)\)\)}]], "Message",
  CellTags->"Display::type"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Display", "MR"],
  " does not match one of the expected forms.\n\[FilledSmallSquare] ",
  StyleBox["Display", "MR"],
  " is designed primarily for rendering graphics expressions, such as \
expressions based on ",
  StyleBox["Graphics", "MR"],
  " or ",
  StyleBox["Graphics3D", "MR"],
  ", and typeset expressions."
}], "Notes",
  CellTags->"Display::type"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Display::type"],

Cell[TextData[{
  "An error occurs in this example because a number is not one of the types \
of expressions that can be rendered using ",
  StyleBox["Display", "MR"],
  "."
}], "Text",
  CellTags->"Display::type"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<DFILE\>", \ 7]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Display::type"],

Cell[BoxData[
    \(Display::"type" \(\(:\)\(\ \)\) 
      "\!\(7\) is not a graphics, notebook, cell, or box expression."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Display::type"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Display::type"]
}, Open  ]],

Cell[TextData[{
  "A number can be rendered if it is part of a ",
  StyleBox["Graphics", "MR"],
  " expression.  (Note that evaluation of this input will open and write to a \
file on your computer system.)"
}], "Text",
  CellTags->"Display::type"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<DFILE\>", Graphics[Text[7, {0, 0}]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Display::type"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Display::type"]
}, Open  ]],

Cell["Delete the file.", "Text",
  CellTags->"Display::type"],

Cell[BoxData[
    \(DeleteFile["\<DFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Display::type"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FaceGrids::fglst", "ObjectNameWarningMessages",
  CellTags->"FaceGrids::fglst"],

Cell[BoxData[
    RowBox[{\(FaceGrids::"fglst"\), \(\(:\)\(\ \)\), \(\(\(Value\ for\ option\
\ FaceGrids\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ None, \ All, \ 
      or\ a\ list\ with\ 6\ or\ fewer\ \(\(elements\)\(.\)\)\)\)}]], "Message",\

  CellTags->"FaceGrids::fglst"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["FaceGrids", "MR"],
  " option does not have a valid form.\n\[FilledSmallSquare] The value of the \
",
  StyleBox["FaceGrids", "MR"],
  " option is expected to be ",
  StyleBox["None", "MR"],
  " (for no grids), ",
  StyleBox["All", "MR"],
  " (for a grid on each face), or a list specifying grids for selected \
faces."
}], "Notes",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FaceGrids::fglst"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["FaceGrids", "MR"],
  " option does not match any of the forms described in the message."
}], "Text",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, PlotPoints -> 4, 
      FaceGrids -> Thickness[0.02]\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FaceGrids::fglst"],

Cell[BoxData[
    \(FaceGrids::"fglst" \(\(:\)\(\ \)\) 
      "Value for option FaceGrids -> \!\(Thickness[0.02`]\) is not None, All, \
or a list with 6 or fewer elements."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FaceGrids::fglst"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FaceGrids::fglst"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["FaceGrids", "MR"],
  " option."
}], "Text",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, PlotPoints -> 4, 
      FaceGrids -> {{\(-1\), 0, 0}}\n]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FaceGrids::fglst"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FaceGrids::fglst"]
}, Open  ]],

Cell[TextData[{
  "The style and position of grid lines can also be specified in the ",
  StyleBox["FaceGrids", "MR"],
  " option."
}], "Text",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, PlotPoints -> 4, 
      FaceGrids -> {{{\(-1\), 0, 
              0}, {None, {{1, Thickness[0.02]}}}}}\n]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"FaceGrids::fglst"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"FaceGrids::fglst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FaceGrids::fgstl", "ObjectNameWarningMessages",
  CellTags->"FaceGrids::fgstl"],

Cell[BoxData[
    RowBox[{\(FaceGrids::"fgstl"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ grid\ style\ \
\(\(specification\)\(.\)\)\)\)}]], "Message",
  CellTags->"FaceGrids::fgstl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["FaceGrids", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] If the \
value of the ",
  StyleBox["FaceGrids", "MR"],
  " option is a list, each element in the list should specify a face on which \
to draw grid lines, and (optionally) the position and style of individual \
grid lines."
}], "Notes",
  CellTags->"FaceGrids::fgstl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FaceGrids::fgstl"],

Cell["\<\
An error occurs in this example because the style specification for \
grid lines does not have an expected form.\
\>", "Text",
  CellTags->"FaceGrids::fgstl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, \ {x, 0, 1}, {y, 0, 3}, PlotPoints -> 4, 
      FaceGrids -> {{{\(-1\), 0, 
              0}, {None, {1, Thickness[0.02]}}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FaceGrids::fgstl"],

Cell[BoxData[
    \(FaceGrids::"fgstl" \(\(:\)\(\ \)\) 
      "\!\({1, \(\(Thickness[0.02`]\)\)}\) is not a valid grid style \
specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FaceGrids::fgstl"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FaceGrids::fgstl"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value of the ",
  StyleBox["FaceGrids", "MR"],
  " option."
}], "Text",
  CellTags->"FaceGrids::fgstl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, \ {x, 0, 1}, {y, 0, 3}, PlotPoints -> 4, 
      FaceGrids -> {{{\(-1\), 0, 
              0}, {None, {{1, Thickness[0.02]}}}}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FaceGrids::fgstl"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FaceGrids::fgstl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FaceGrids::gface", "ObjectNameWarningMessages",
  CellTags->"FaceGrids::gface"],

Cell[BoxData[
    RowBox[{\(FaceGrids::"gface"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ face\ \
\(\(specification\)\(.\)\)\)\)}]], "Message",
  CellTags->"FaceGrids::gface"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a face specification in the value of \
the ",
  StyleBox["FaceGrids", "MR"],
  " option is not valid.\n\[FilledSmallSquare] If the value of the ",
  StyleBox["FaceGrids", "MR"],
  " option is a list, each element in the list should specify a face on which \
to draw grid lines, and (optionally) the position and style of individual \
grid lines.\n\[FilledSmallSquare] The face specification in the value of the \
",
  StyleBox["FaceGrids", "MR"],
  " option is expected to be ",
  StyleBox["{-1,0,0}", "MR"],
  ", ",
  StyleBox["{1,0,0}", "MR"],
  ", ",
  StyleBox["{0,-1,0}", "MR"],
  ", ",
  StyleBox["{0,1,0}", "MR"],
  ", ",
  StyleBox["{0,0,-1}", "MR"],
  ", or ",
  StyleBox["{0,0,1}", "MR"],
  "."
}], "Notes",
  CellTags->"FaceGrids::gface"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FaceGrids::gface"],

Cell[TextData[{
  "An error occurs in this example because the elements in the value of the \
",
  StyleBox["FaceGrids", "MR"],
  " option are numbers rather than face specifications."
}], "Text",
  CellTags->"FaceGrids::gface"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, PlotPoints -> 4, 
      FaceGrids -> {\(-1\), 0, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FaceGrids::gface"],

Cell[BoxData[
    \(FaceGrids::"gface" \(\(:\)\(\ \)\) 
      "\!\(-1\) is not a valid face specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FaceGrids::gface"],

Cell[BoxData[
    \(FaceGrids::"gface" \(\(:\)\(\ \)\) 
      "\!\(0\) is not a valid face specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FaceGrids::gface"],

Cell[BoxData[
    \(FaceGrids::"gface" \(\(:\)\(\ \)\) 
      "\!\(0\) is not a valid face specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FaceGrids::gface"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(FaceGrids :: \"gface\"\) will be suppressed \
during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FaceGrids::gface"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FaceGrids::gface"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value of the ",
  StyleBox["FaceGrids", "MR"],
  " option."
}], "Text",
  CellTags->"FaceGrids::gface"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, PlotPoints -> 4, 
      FaceGrids -> {{\(-1\), 0, 0}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FaceGrids::gface"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FaceGrids::gface"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FontForm::ffsp", "ObjectNameWarningMessages",
  CellTags->"FontForm::ffsp"],

Cell[BoxData[
    \(FontForm::"ffsp" \(\(:\)\(\ \)\) 
      "`1` is not a valid font specification of the form {\"font\", \
size}."\)], "Message",
  CellLabel->"From In[44]:=",
  CellTags->"FontForm::ffsp"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] The second argument in ",
  StyleBox["FontForm", "MR"],
  " is expected to be a list ",
  StyleBox["{", "MR"],
  StyleBox["font", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["size", "TI"],
  StyleBox["}", "MR"],
  ", where ",
  StyleBox["font", "TI"],
  " is a string and ",
  StyleBox["size", "TI"],
  " is a real number."
}], "Notes",
  CellTags->"FontForm::ffsp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FontForm::ffsp"],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["FontForm", "MR"],
  "."
}], "Text",
  CellTags->"FontForm::ffsp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[Text[
          FontForm["\<abc\>", {"\<Courier\>", 100}], {1, 1}]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FontForm::ffsp"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FontForm::ffsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FrameLabel::fmlab", "ObjectNameWarningMessages",
  CellTags->"FrameLabel::fmlab"],

Cell[BoxData[
    RowBox[{\(FrameLabel::"fmlab"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\
\ FrameLabel\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ None\ or\ a\ label\ or\ a\ list\ with\ 2\
\ or\ 4\ \(\(labels\)\(.\)\)\)\)}]], "Message",
  CellTags->"FrameLabel::fmlab"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["FrameLabel", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["FrameLabel", "MR"],
  " option is expected to be a list with length equal to the number of frame \
axes."
}], "Notes",
  CellTags->"FrameLabel::fmlab"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FrameLabel::fmlab"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["FrameLabel", "MR"],
  " option is a list with only one element."
}], "Text",
  CellTags->"FrameLabel::fmlab"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 9}, Frame -> True, 
      FrameLabel -> {"\<horizontal\>"}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FrameLabel::fmlab"],

Cell[BoxData[
    \(FrameLabel::"fmlab" \(\(:\)\(\ \)\) 
      "Value of option FrameLabel -> \!\({\"horizontal\"}\) should be None or \
a label or a list with 2 or 4 labels."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FrameLabel::fmlab"],

Cell[BoxData[
    \(FrameLabel::"fmlab" \(\(:\)\(\ \)\) 
      "Value of option FrameLabel -> \!\({\"horizontal\"}\) should be None or \
a label or a list with 2 or 4 labels."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FrameLabel::fmlab"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FrameLabel::fmlab"]
}, Open  ]],

Cell[TextData[{
  "The value ",
  StyleBox["None", "MR"],
  " can be given when no label should be shown."
}], "Text",
  CellTags->"FrameLabel::fmlab"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 9}, Frame -> True, 
      FrameLabel -> {"\<horizontal\>", None}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FrameLabel::fmlab"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FrameLabel::fmlab"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::lspec", "ObjectNameWarningMessages",
  CellTags->"General::lspec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"lspec\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", 
          "color"}]}], ",", " ", "thickness", ",", 
      " ", \(or\ dashing\ \(\(specification\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::lspec"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is \
expected to be a valid color, thickness, or dashing directive.
\[FilledSmallSquare] This error can occur if an invalid style specification \
is used for the lines in a grid.\
\>", "Notes",
  CellTags->"General::lspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::lspec"],

Cell["\<\
An error occurs in this example because the style specification for \
one of the grid lines is not a valid color directive.\
\>", "Text",
  CellTags->"General::lspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, 
      FaceGrids -> {{{\(-1\), 0, 0}, {{{1, RGBColor}, 2}, None}}}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"General::lspec"],

Cell[BoxData[
    \(FaceGrids::"lspec" \(\(:\)\(\ \)\) 
      "\!\(RGBColor\) is not a valid color, thickness, or dashing \
specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::lspec"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::lspec"]
}, Open  ]],

Cell["This shows a valid style specification for a grid line.", "Text",
  CellTags->"General::lspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, 
      FaceGrids -> {{{\(-1\), 0, 0}, {{{1, RGBColor[1, 0, 0]}, 2}, 
              None}}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::lspec"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::lspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics3D::ambnt", "ObjectNameWarningMessages",
  CellTags->"Graphics3D::ambnt"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Graphics3D::"ambnt"\), \(\(:\)\(\ \)\), "Value", " ", "of", 
        " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", 
        "GrayLevel", " ", "or", " ", "RGBColor", 
        " ", \(\(specification\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Graphics3D::ambnt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["AmbientLight", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"Graphics3D::ambnt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics3D::ambnt"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["AmbientLight", "MR"],
  " option is expected to be a single color directive rather than a list of \
color directives."
}], "Text",
  CellTags->"Graphics3D::ambnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, 
      AmbientLight -> {RGBColor[1, 0, 0], RGBColor[0, 1, 0]}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics3D::ambnt"],

Cell[BoxData[
    \(Graphics3D::"ambnt" \(\(:\)\(\ \)\) 
      "Value of option \!\(AmbientLight\) -> \!\({\(\(RGBColor[\(\(1, 0, \
0\)\)]\)\), \(\(RGBColor[\(\(0, 1, 0\)\)]\)\)}\) is not a valid GrayLevel or \
RGBColor specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics3D::ambnt"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics3D::ambnt"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["AmbientLight", "MR"],
  " option in ",
  StyleBox["Plot3D", "MR"],
  "."
}], "Text",
  CellTags->"Graphics3D::ambnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 3}, 
      AmbientLight -> RGBColor[0, 1, 0]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Graphics3D::ambnt"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Graphics3D::ambnt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::color", "ObjectNameWarningMessages",
  CellTags->"General::color"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"color\"\>"}], ":", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", 
          "color", " ", "or", " ", "gray"}], 
        "-", \(level\ \(\(specification\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::color"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is not a \
valid color or gray-level specification.\n\[FilledSmallSquare] A valid color \
specification is an expression of the form ",
  StyleBox["RGBColor[", "MR"],
  StyleBox["r", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["g", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["b", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["s", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["b", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  ", or ",
  StyleBox["CMYKColor[", "MR"],
  StyleBox["c", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["m", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["y", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["k", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  ", where all of the arguments are positive real numbers.\n\
\[FilledSmallSquare] A valid gray-level specification is an expression of the \
form ",
  StyleBox["GrayLevel[", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  ", where ",
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  " is a real number between zero and one."
}], "Notes",
  CellTags->"General::color"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::color"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["RGBColor", "MR"],
  " is used with only one argument."
}], "Text",
  CellTags->"General::color"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{RGBColor[ .5], \ 
          Polygon[{{0, 0, 0}, {1, 1, 1}, {0, 1, 1}}]}, 
        Lighting -> False]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::color"],

Cell[BoxData[
    \(RGBColor::"color" \(\(:\)\(\ \)\) 
      "\!\(RGBColor[0.5`]\) is not a valid color or gray-level \
specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::color"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::color"]
}, Open  ]],

Cell["This demonstrates the effect of a valid color directive.", "Text",
  CellTags->"General::color"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{RGBColor[ .5, 0, 0], \ 
          Polygon[{{0, 0, 0}, {1, 1, 1}, {0, 1, 1}}]}, 
        Lighting -> False]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::color"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::color"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::gprim", "ObjectNameWarningMessages",
  CellTags->"General::gprim"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"gprim\"\>"}], \(\(:\)\(\ \)\), "\<\"`2` was encountered \
where a `1` primitive or directive was expected.\"\>"}]], "Message",
  CellLabel->"From In[45]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::gprim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression is encountered that is \
not a known graphics primitive in the indicated type of graphics expression.\n\
\[FilledSmallSquare] Valid graphics primitives are expressions such as ",
  StyleBox["Point[{0,0}]", "MR"],
  " or ",
  StyleBox["Line[{{0,0},{1,1}}]", "MR"],
  " that represent elements in an image."
}], "Notes",
  CellTags->"General::gprim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::gprim"],

Cell["\<\
An error occurs in this example because an array of numbers is not \
a valid graphics primitive.\
\>", "Text",
  CellTags->"General::gprim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[{{0, 0}, {1, 1}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::gprim"],

Cell[BoxData[
    \(Graphics::"gprim" \(\(:\)\(\ \)\) 
      "\!\(0\) was encountered where a \!\(Graphics\) primitive or directive \
was expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::gprim"],

Cell[BoxData[
    \(Graphics::"gprim" \(\(:\)\(\ \)\) 
      "\!\(0\) was encountered where a \!\(Graphics\) primitive or directive \
was expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::gprim"],

Cell[BoxData[
    \(Graphics::"gprim" \(\(:\)\(\ \)\) 
      "\!\(1\) was encountered where a \!\(Graphics\) primitive or directive \
was expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::gprim"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Graphics :: \"gprim\"\) will be suppressed \
during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::gprim"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::gprim"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid ",
  StyleBox["Line", "MR"],
  " primitive in a ",
  StyleBox["Graphics", "MR"],
  " expression."
}], "Text",
  CellTags->"General::gprim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{{0, 0}, {1, 1}}]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::gprim"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::gprim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::pcolor", "ObjectNameWarningMessages",
  CellTags->"General::pcolor"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"pcolor\"\>"}], \(\(:\)\(\ \)\), \(The\ shading\ function\ \
has\ produced\ colors\ of\ different\ \(\(types\)\(.\)\)\)}]], "Message",
  CellTags->"General::pcolor"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the shading function specification in \
the first argument of ",
  StyleBox["Plot3D", "MR"],
  " or ",
  StyleBox["ParametricPlot3D", "MR"],
  " or in a ",
  StyleBox["SurfaceGraphics", "MR"],
  " expression produces color directives of different types.\n\
\[FilledSmallSquare] If ",
  StyleBox["ParametricPlot3D", "MR"],
  " is used to draw a surface, and the first argument is a list with four \
elements, the fourth element is used as a shading specification.\n\
\[FilledSmallSquare] The shading specification is expected to evaluate to the \
same type of color directive (",
  StyleBox["GrayLevel", "MR"],
  ", ",
  StyleBox["CMYKColor", "MR"],
  ", ",
  StyleBox["Hue", "MR"],
  ", or ",
  StyleBox["RGBColor", "MR"],
  ") for each element in the plot."
}], "Notes",
  CellTags->"General::pcolor"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::pcolor"],

Cell["\<\
An error occurs in this example because the shading specification \
gives color directives of two different types.\
\>", "Text",
  CellTags->"General::pcolor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{x, y, x\ y, 
        If[x\ y < 1, GrayLevel[0], RGBColor[1, 0, 0]]}, {x, 0, 3}, {y, 0, 3}, 
      PlotPoints -> 6, Lighting -> False, BoxRatios -> {1, 1, 1}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"General::pcolor"],

Cell[BoxData[
    \(ParametricPlot3D::"pcolor" \(\(:\)\(\ \)\) 
      "The shading function has produced colors of different types."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::pcolor"],

Cell[BoxData[
    \(ParametricPlot3D::"pcolor" \(\(:\)\(\ \)\) 
      "The shading function has produced colors of different types."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::pcolor"],

Cell[BoxData[
    \(ParametricPlot3D::"pcolor" \(\(:\)\(\ \)\) 
      "The shading function has produced colors of different types."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::pcolor"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ParametricPlot3D :: \"pcolor\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::pcolor"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::pcolor"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid shading specification in ",
  StyleBox["ParametricPlot3D", "MR"],
  "."
}], "Text",
  CellTags->"General::pcolor"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{x, y, x\ y, 
        If[x\ y < 1, RGBColor[0, 0, 0], RGBColor[1, 0, 0]]}, {x, 0, 3}, {y, 
        0, 3}, PlotPoints -> 6, Lighting -> False, 
      BoxRatios -> {1, 1, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::pcolor"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::pcolor"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::plln", "ObjectNameWarningMessages",
  CellTags->"General::plln"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"plln\"\>"}], \(\(:\)\(\ \)\), "Limiting", " ", 
        "value", " ", 
        StyleBox["expr",
          "TI"], " ", "in", " ", 
        StyleBox["lims",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "machine"}], 
      "-", \(size\ real\ \(\(number\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::plln"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated limit on the variable \
does not evaluate to a real number or is outside of the range of machine \
numbers on your computer.\n\[FilledSmallSquare] This message is used \
primarily by plotting functions.\n\[FilledSmallSquare] Limits on variables in \
plotting functions are expected to be given in the form ",
  StyleBox["{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["xmin", "TI"],
  StyleBox[",", "MR"],
  StyleBox["xmax", "TI"],
  StyleBox["}", "MR"],
  " where ",
  StyleBox["xmin", "TI"],
  " and ",
  StyleBox["xmax", "TI"],
  " are real numbers."
}], "Notes",
  CellTags->"General::plln"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::plln"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid limit for the plotting variable."
}], "Text",
  CellTags->"General::plln"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Cos[Pi\ x], {x, 0, Automatic}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::plln"],

Cell[BoxData[
    \(Plot::"plln" \(\(:\)\(\ \)\) 
      "Limiting value \!\(Automatic\) in \!\({x, 0, Automatic}\) is not a \
machine-size real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::plln"],

Cell[BoxData[
    \(Plot[Cos[\[Pi]\ x], {x, 0, Automatic}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::plln"]
}, Open  ]],

Cell[TextData[{
  "This shows valid limit specification in ",
  StyleBox["Plot", "MR"],
  "."
}], "Text",
  CellTags->"General::plln"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Cos[Pi\ x], {x, 0, 5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::plln"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::plln"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::rawvar", "ObjectNameWarningMessages",
  CellTags->"General::rawvar"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"rawvar\"\>"}], \(\(:\)\(\ \)\), "Parameter", " ", 
      
      StyleBox["var",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "a", " ", "raw", " ", "expression", " ", "and",
       " ", "cannot", " ", "be", " ", "used", " ", "as", " ", "a", 
      " ", \(\(variable\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::rawvar"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::rawvar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics3D::lights", "ObjectNameWarningMessages",
  CellTags->"Graphics3D::lights"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Graphics3D::"lights"\), \(\(:\)\(\ \)\), "Value", " ", "of", 
        " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
        " ", \(\({{pos, \ col}, \ {pos, \ 
              col}, \  ... }\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Graphics3D::lights"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["LightSources", "MR"],
  " option does not have the expected form.\n\[FilledSmallSquare] The value \
of the ",
  StyleBox["LightSources", "MR"],
  " option is expected to be a list of pairs, where the first element in each \
pair is a position specification given as a list of three real numbers, and \
the second element in each pair is a valid color specification."
}], "Notes",
  CellTags->"Graphics3D::lights"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics3D::lights"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["LightSources", "MR"],
  " option gives a single light source rather than a list of light sources."
}], "Text",
  CellTags->"Graphics3D::lights"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x + y], {x, 0, 10}, {y, 0, 10}, 
      LightSources -> {{1, 1, 2}, RGBColor[1, 0, 1]}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics3D::lights"],

Cell[BoxData[
    \(Graphics3D::"lights" \(\(:\)\(\ \)\) 
      "Value of option \!\(LightSources\) -> \!\({\(\({1, 1, 2}\)\), \
\(\(RGBColor[\(\(1, 0, 1\)\)]\)\)}\) is not of the form {{pos, col}, {pos, \
col}, ...}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics3D::lights"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics3D::lights"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["LightSources", "MR"],
  " option."
}], "Text",
  CellTags->"Graphics3D::lights"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Sin[x + y], {x, 0, 10}, {y, 0, 10}, 
      LightSources -> {{{1, 1, 2}, RGBColor[1, 0, 1]}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Graphics3D::lights"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Graphics3D::lights"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics3D::boxz", "ObjectNameWarningMessages",
  CellTags->"Graphics3D::boxz"],

Cell[BoxData[
    \(Graphics3D::"boxz" \(\(:\)\(\ \)\) \(Box\ for\ 3  
        D\ graphics\ has\ zero\ \(\(size\)\(.\)\)\)\)], "Message",
  CellTags->"Graphics3D::boxz"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the box computed to display \
three-dimensional graphics has zero volume.\n\[FilledSmallSquare] This error \
can normally be avoided by setting the value of the ",
  StyleBox["BoxRatios", "MR"],
  " option to a list with three non-zero numbers.\n\[FilledSmallSquare] If \
you see this message in a situation where it is not expected, please contact \
Technical Support."
}], "Notes",
  CellTags->"Graphics3D::boxz"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics3D::gsort", "ObjectNameWarningMessages",
  CellTags->"Graphics3D::gsort"],

Cell[BoxData[
    \(Graphics3D::"gsort" \(\(:\)\(\ \)\) \(More\ than\ 10^9\ polygons\ to\ \
\(\(sort\)\(.\)\)\)\)], "Message",
  CellTags->"Graphics3D::gsort"],

Cell["\<\
\[FilledSmallSquare] Generated when the number of polygons to be \
sorted to display a graphics expression is prohibitively large.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support.\
\>", "Notes",
  CellTags->"Graphics3D::gsort"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics3D::psvf", "ObjectNameWarningMessages",
  CellTags->"Graphics3D::psvf"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Graphics3D::\("psvf" : \ Function\ value\ at\ x\)\), " ", "=",
         " ", 
        StyleBox["xval",
          "TI"]}], ",", " ", 
      RowBox[{"y", " ", "=", " ", 
        RowBox[{
          StyleBox["yval",
            "TI"], " ", "was", " ", "sent", " ", "to", " ", "infinity", " ", 
          "by", " ", "perspective", 
          " ", \(\(transformation\)\(.\)\)}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Graphics3D::psvf"],

Cell["\<\
\[FilledSmallSquare] Generated when a point in a three-dimensional \
image is mapped to infinity when a graphics expression is rendered in \
perspective.
\[FilledSmallSquare] This message should occur only for unusual images or \
option values.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support.\
\>", "Notes",
  CellTags->"Graphics3D::psvf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics::gpt", "ObjectNameWarningMessages",
  CellTags->"Graphics::gpt"],

Cell[BoxData[
    RowBox[{\(Graphics::"gpt"\), \(\(:\)\(\ \)\), \(\(Coordinate\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ of\ the\ form\ \(\({x, \ 
            y}\)\(.\)\)\)\)}]], "Message",
  CellTags->"Graphics::gpt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a coordinate specified in a \
two-dimensional graphics expression is not a list with two elements.\n\
\[FilledSmallSquare] Two-dimensional coordinate specifications are used in ",
  StyleBox["Text", "MR"],
  ", ",
  StyleBox["Point", "MR"],
  ", ",
  StyleBox["Polygon", "MR"],
  ", ",
  StyleBox["Line", "MR"],
  ", ",
  StyleBox["Disk", "MR"],
  ", ",
  StyleBox["Circle", "MR"],
  ", ",
  StyleBox["Rectangle", "MR"],
  ", ",
  StyleBox["Raster", "MR"],
  ", and ",
  StyleBox["RasterArray", "MR"],
  "."
}], "Notes",
  CellTags->"Graphics::gpt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics::gpt"],

Cell[TextData[{
  "An error occurs in this example because the argument in the ",
  StyleBox["Line", "MR"],
  " primitive is not a list of pairs."
}], "Text",
  CellTags->"Graphics::gpt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{1, 2, 3, 4}]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics::gpt"],

Cell[BoxData[
    \(Graphics::"gpt" \(\(:\)\(\ \)\) 
      "Coordinate \!\(1\) is not of the form {x, y}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::gpt"],

Cell[BoxData[
    \(Graphics::"gpt" \(\(:\)\(\ \)\) 
      "Coordinate \!\(2\) is not of the form {x, y}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::gpt"],

Cell[BoxData[
    \(Graphics::"gpt" \(\(:\)\(\ \)\) 
      "Coordinate \!\(3\) is not of the form {x, y}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::gpt"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Graphics :: \"gpt\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::gpt"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics::gpt"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in a ",
  StyleBox["Line", "MR"],
  " primitive."
}], "Text",
  CellTags->"Graphics::gpt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{{1, 2}, {3, 4}}]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Graphics::gpt"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Graphics::gpt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics::gptn", "ObjectNameWarningMessages",
  CellTags->"Graphics::gptn"],

Cell[BoxData[
    RowBox[{\(Graphics::"gptn"\), \(\(:\)\(\ \)\), "Coordinate", " ", 
      StyleBox["val",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ floating - 
        point\ \(\(number\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Graphics::gptn"],

Cell["\<\
\[FilledSmallSquare] Generated when non-numerical elements are \
encountered in two-dimensional coordinate specifications.
\[FilledSmallSquare] A coordinate specification in two dimensions is expected \
to be a pair of real numbers.\
\>", "Notes",
  CellTags->"Graphics::gptn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics::gptn"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Line", "MR"],
  " is not a list of pairs."
}], "Text",
  CellTags->"Graphics::gptn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{{{0, 0}, {2, 2}}, {5, 0}}]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics::gptn"],

Cell[BoxData[
    \(Graphics::"gptn" \(\(:\)\(\ \)\) 
      "Coordinate \!\({0, 0}\) in \!\({\(\({0, 0}\)\), \(\({2, 2}\)\)}\) is \
not a floating-point number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::gptn"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics::gptn"]
}, Open  ]],

Cell[TextData[{
  "This shows valid coordinate specifications in a ",
  StyleBox["Line", "MR"],
  " graphics primitive."
}], "Text",
  CellTags->"Graphics::gptn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{{0, 0}, {2, 2}, {5, 0}}]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Graphics::gptn"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Graphics::gptn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics::hue", "ObjectNameWarningMessages",
  CellTags->"Graphics::hue"],

Cell[BoxData[
    RowBox[{\(Graphics::"hue"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ of\ length\ 1\ or\ 3. \)\)}]], "Message",
  CellTags->"Graphics::hue"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Hue", "MR"],
  " is used with an unexpected number of arguments."
}], "Notes",
  CellTags->"Graphics::hue"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics::hue"],

Cell[TextData[{
  "An error occurs in this example because a ",
  StyleBox["Line", "MR"],
  " primitive is included in the arguments of ",
  StyleBox["Hue", "MR"],
  "."
}], "Text",
  CellTags->"Graphics::hue"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Hue[0.7, Line[{{1, 1}, {3, 2}}]], Hue[0], 
          Line[{{1, 3}, {4, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics::hue"],

Cell[BoxData[
    \(Graphics::"hue" \(\(:\)\(\ \)\) 
      "\!\(Hue[\(\(0.7`, \(\(Line[\(\({\(\({1, 1}\)\), \(\({3, 2}\)\)}\)\)]\)\
\)\)\)]\) is not of length 1 or 3."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics::hue"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics::hue"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Hue", "MR"],
  "."
}], "Text",
  CellTags->"Graphics::hue"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Hue[0.7], Line[{{1, 1}, {3, 2}}], Hue[0], 
          Line[{{1, 3}, {4, 1}}]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Graphics::hue"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Graphics::hue"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphicsArray::prim", "ObjectNameWarningMessages",
  CellTags->"GraphicsArray::prim"],

Cell[BoxData[
    RowBox[{\(GraphicsArray::"prim"\), \(\(:\)\(\ \)\), \(\(\(Argument\ to\ \
GraphicsArray\)\(,\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(,\)\(\ \)\(should\ be\ a\ vector\ or\ a\ matrix\ of\ \
graphics\ \(\(objects\)\(.\)\)\)\)}]], "Message",
  CellTags->"GraphicsArray::prim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["GraphicsArray", "MR"],
  " does not have the expected structure.\n\[FilledSmallSquare] The argument \
in ",
  StyleBox["GraphicsArray", "MR"],
  " is expected to be a list of graphics expressions or a regular array of \
graphics expressions."
}], "Notes",
  CellTags->"GraphicsArray::prim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"GraphicsArray::prim"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["GraphicsArray", "MR"],
  " is not a regular array."
}], "Text",
  CellTags->"GraphicsArray::prim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{{Graphics[Line[{{0, 0}, {1, 1}}]]}, 
          Graphics[Line[{{0, 1}, {1, 0}}]]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"GraphicsArray::prim"],

Cell[BoxData[
    RowBox[{\(GraphicsArray::"prim"\), \(\(:\)\(\ \)\), "\<\"Argument to \
GraphicsArray, \\!\\({\\(\\({\\*TagBox[\\(\[SkeletonIndicator] Graphics \
\[SkeletonIndicator]\\), False, Rule[Editable, False]]}\\)\\), \\*TagBox[\\(\
\[SkeletonIndicator] Graphics \[SkeletonIndicator]\\), False, Rule[Editable, \
False]]}\\), should be a vector or a matrix of graphics objects.\"\>"}]], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"GraphicsArray::prim"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"GraphicsArray::prim"]
}, Open  ]],

Cell[TextData[{
  "This shows a ",
  StyleBox["GraphicsArray", "MR"],
  " with a list of graphics expressions."
}], "Text",
  CellTags->"GraphicsArray::prim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{Graphics[Line[{{0, 0}, {1, 1}}]], 
          Graphics[Line[{{0, 1}, {1, 0}}]]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"GraphicsArray::prim"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"GraphicsArray::prim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ListPlay::lsamps", "ObjectNameWarningMessages",
  CellTags->"ListPlay::lsamps"],

Cell[BoxData[
    \(ListPlay::"lsamps" \(\(:\)\(\ \)\) \(The\ first\ argument\ to\ ListPlay\
\ must\ be\ a\ list\ of\ samples\ or\ a\ list\ of\ lists\ of\ \
\(\(samples\)\(.\)\)\)\)], "Message",
  CellTags->"ListPlay::lsamps"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ListPlay", "MR"],
  " is not a list of numbers or a list of lists of numbers."
}], "Notes",
  CellTags->"ListPlay::lsamps"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ListPlay::lsamps"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Null", "MR"],
  " is not a list."
}], "Text",
  CellTags->"ListPlay::lsamps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlay[Null]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ListPlay::lsamps"],

Cell[BoxData[
    \(ListPlay::"lsamps" \(\(:\)\(\ \)\) 
      "The first argument to ListPlay must be a list of samples or a list of \
lists of samples."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ListPlay::lsamps"],

Cell[BoxData[
    \(ListPlay[Null]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ListPlay::lsamps"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["ListPlay", "MR"],
  "."
}], "Text",
  CellTags->"ListPlay::lsamps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlay[Table[Sin[k], {k, 0, 100, 0.5}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ListPlay::lsamps"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ListPlay::lsamps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ListPlay::silent", "ObjectNameWarningMessages",
  CellTags->"ListPlay::silent"],

Cell[BoxData[
    RowBox[{\(ListPlay::"silent"\), \(\(:\)\(\ \)\), \(\(Sound\)\(\ \
\)\(in\)\(\ \)\(channel\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ \(\(silent\)\(.\)\)\)\)}]], "Message",
  CellTags->"ListPlay::silent"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when there is no variation in the numbers \
listed for the indicated channel in the first argument of ",
  StyleBox["ListPlay", "MR"],
  "."
}], "Notes",
  CellTags->"ListPlay::silent"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ListPlay::silent"],

Cell["\<\
A warning message is generated in this example because all of the \
specified sample values are the same.\
\>", "Text",
  CellTags->"ListPlay::silent"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlay[Table[Sin[1], {k, 0, 100, 0.5}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ListPlay::silent"],

Cell[BoxData[
    \(ListPlay::"silent" \(\(:\)\(\ \)\) 
      "Sound in channel \!\(1\) is silent."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ListPlay::silent"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ListPlay::silent"]
}, Open  ]],

Cell["\<\
This shows data that corresponds to a sound that is not \
silent.\
\>", "Text",
  CellTags->"ListPlay::silent"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlay[Table[Sin[k], {k, 0, 100, 0.5}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ListPlay::silent"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ListPlay::silent"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ListPlot::lpn", "ObjectNameWarningMessages",
  CellTags->"ListPlot::lpn"],

Cell[BoxData[
    RowBox[{\(ListPlot::"lpn"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ list\ of\ numbers\ or\ pairs\ of\ \
\(\(numbers\)\(.\)\)\)\)}]], "Message",
  CellTags->"ListPlot::lpn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ListPlot", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"ListPlot::lpn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ParametricPlot3D::ppfun", "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[BoxData[
    RowBox[{\(ParametricPlot3D::"ppfun"\), \(\(:\)\(\ \)\), \(\(Argument\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ list\ with\ three\ or\ four\ \
\(\(elements\)\(.\)\)\)\)}]], "Message",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ParametricPlot3D", "MR"],
  " is not a list or does not have the expected number of elements."
}], "Notes",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ParametricPlot3D::ppfun"],

Cell["\<\
An error occurs in this example because the first argument is a \
list with five elements.\
\>", "Text",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{Sin[t], Cos[t], t/10, t/10, Hue[t/25]}, {t, 0, 
        25}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[BoxData[
    \(ParametricPlot3D::"ppfun" \(\(:\)\(\ \)\) 
      "Argument \!\({\(\(Sin[t]\)\), \(\(Cos[t]\)\), t\/10, t\/10, \(\(Hue[\(\
\(t\/25\)\)]\)\)}\) is not a list with three or four elements."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[BoxData[
    \(ParametricPlot3D[{Sin[t], Cos[t], t\/10, t\/10, Hue[t\/25]}, {t, 0, 
        25}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ParametricPlot3D::ppfun"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ParametricPlot3D", "MR"],
  "."
}], "Text",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{Sin[t], Cos[t], t/10, Hue[t/25]}, {t, 0, 
        25}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ParametricPlot3D::ppfun"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ParametricPlot3D::pplr", "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    \(ParametricPlot3D::"pplr" \(\(:\)\(\ \)\) 
      "`1` is not a list starting with three real numbers at `2` = `3`."\)], \
"Message",
  CellLabel->"From In[45]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ParametricPlot3D", "MR"],
  " does not evaluate to a list with three real numbers at the indicated \
point.\n\[FilledSmallSquare] The first argument in ",
  StyleBox["ParametricPlot3D", "MR"],
  " is expected to evaluate to a list of three numbers that give coordinates \
for points in three dimensions."
}], "Notes",
  CellTags->"ParametricPlot3D::pplr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ParametricPlot3D::pplr"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["ParametricPlot3D", "MR"],
  " includes symbols that do not have numerical values for numerical values \
of the parameter."
}], "Text",
  CellTags->"ParametricPlot3D::pplr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{Cos[x], Sin[y], z/10}, {x, 0, 25}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    \(ParametricPlot3D::"pplr" \(\(:\)\(\ \)\) 
      "\!\({\(\(Cos[x]\)\), \(\(Sin[y]\)\), z\/10}\) is not a list starting \
with three real numbers at \!\(x\) = \!\(0.`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    \(ParametricPlot3D::"pplr" \(\(:\)\(\ \)\) 
      "\!\({\(\(Cos[x]\)\), \(\(Sin[y]\)\), z\/10}\) is not a list starting \
with three real numbers at \!\(x\) = \!\(0.33783783783783783`\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    \(ParametricPlot3D::"pplr" \(\(:\)\(\ \)\) 
      "\!\({\(\(Cos[x]\)\), \(\(Sin[y]\)\), z\/10}\) is not a list starting \
with three real numbers at \!\(x\) = \!\(0.6756756756756757`\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ParametricPlot3D :: \"pplr\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    \(ParametricPlot3D::"ppx" \(\(:\)\(\ \)\) 
      "Graphics3D object calculated in ParametricPlot3D is empty."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    \(ParametricPlot3D[{Cos[x], Sin[y], z\/10}, {x, 0, 25}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ParametricPlot3D::pplr"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ParametricPlot3D", "MR"],
  "."
}], "Text",
  CellTags->"ParametricPlot3D::pplr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{Cos[x], Sin[x], x/10}, {x, 0, 25}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ParametricPlot3D::pplr"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ParametricPlot3D::pplr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ParametricPlot3D::ppta", "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::ppta"],

Cell[BoxData[
    RowBox[{\(ParametricPlot3D::"ppta"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ \
option\ PlotPoints\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ Automatic, \ an\ integer\  >= \ 2, \ 
      or\ a\ list\ of\ two\ of\ these\ \(\(values\)\(.\)\)\)\)}]], "Message",
  CellTags->"ParametricPlot3D::ppta"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["ParametricPlot3D", "MR"],
  " is used to plot a surface and the value of the ",
  StyleBox["PlotPoints", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"ParametricPlot3D::ppta"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ParametricPlot3D::ppta"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["PlotPoints", "MR"],
  " option in ",
  StyleBox["ParametricPlot3D", "MR"],
  "."
}], "Text",
  CellTags->"ParametricPlot3D::ppta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{x, y, x\ y}, {x, 0, 1}, {y, 0, 1}, 
      PlotPoints -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ParametricPlot3D::ppta"],

Cell[BoxData[
    \(ParametricPlot3D::"ppta" \(\(:\)\(\ \)\) 
      "Value of option PlotPoints -> \!\(All\) is not Automatic, an integer \
>= 2, or a list of two of these values."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot3D::ppta"],

Cell[BoxData[
    \(ParametricPlot3D[{x, y, x\ y}, {x, 0, 1}, {y, 0, 1}, 
      PlotPoints \[Rule] All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ParametricPlot3D::ppta"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PlotPoints", "MR"],
  " option in ",
  StyleBox["ParametricPlot3D", "MR"],
  "."
}], "Text",
  CellTags->"ParametricPlot3D::ppta"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{x, y, x\ y}, {x, 0, 1}, {y, 0, 1}, 
      PlotPoints -> 4]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ParametricPlot3D::ppta"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ParametricPlot3D::ppta"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ParametricPlot3D::ppx", "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::ppx"],

Cell[BoxData[
    \(ParametricPlot3D::"ppx" \(\(:\)\(\ \)\) \(Graphics3D\ object\ \
calculated\ in\ ParametricPlot3D\ is\ \(\(empty\)\(.\)\)\)\)], "Message",
  CellTags->"ParametricPlot3D::ppx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the list of graphics elements \
generated by ",
  StyleBox["ParametricPlot3D", "MR"],
  " has no elements.\n\[FilledSmallSquare] This message will usually be \
preceded by other messages that indicate the origin of the problem."
}], "Notes",
  CellTags->"ParametricPlot3D::ppx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot::bend
Plot::bend\
\>", "ObjectNameWarningMessages",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"bend\"\>"}], \(\(:\)\(\ \)\), "MaxBend", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "greater", " ", "than", " ", "or", 
      " ", "equal", " ", "to", " ", "0."}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MaxBend", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["MaxBend", "MR"],
  " option."
}], "Text",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Floor[t], {t, 0, 8}, MaxBend -> All, PlotPoints -> 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[BoxData[
    \(Plot::"bend" \(\(:\)\(\ \)\) 
      "MaxBend \!\(All\) is not greater than or equal to 0."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[BoxData[
    \(Plot[Floor[t], {t, 0, 8}, MaxBend \[Rule] All, 
      PlotPoints \[Rule] 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["MaxBend", "MR"],
  " option in ",
  StyleBox["Plot", "MR"],
  "."
}], "Text",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Floor[t], {t, 0, 8}, MaxBend -> 60, PlotPoints -> 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot::plld
Plot::plld
Plot3D::plld
ContourPlot::plld
DensityPlot::plld
ParametricPlot3D::plld
Play::plld\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"plld\"\>"}], \(\(:\)\(\ \)\), "Endpoints", " ", 
        "for", " ", 
        StyleBox["var",
          "TI"], " ", "in", " ", 
        StyleBox["expr",
          "TI"], " ", "must", " ", "have", " ", "distinct", " ", "machine"}], 
      "-", \(precision\ numerical\ \(\(values\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell["\<\
\[FilledSmallSquare] Generated when the upper limit on the plotting \
variable is the same as the lower limit.\
\>", "Notes",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell["\<\
An error occurs in this example because the limits on the plotting \
variable are the same.\
\>", "Text",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Cos[x], {x, 0, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[BoxData[
    \(Plot::"plld" \(\(:\)\(\ \)\) 
      "Endpoints for \!\(x\) in \!\({x, 0, 0}\) must have distinct \
machine-precision numerical values."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
    "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],

Cell[BoxData[
    \(Plot[Cos[x], {x, 0, 0}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
    "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid limits on the plotting variable in ",
  StyleBox["Plot", "MR"],
  "."
}], "Text",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Cos[x], {x, 0, 2  Pi}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
    "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ParametricPlot::pptr", "ObjectNameWarningMessages",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(ParametricPlot::"pptr"\), ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "does", " ", "not", " ", "evaluate", " ", "to", " ", 
          "a", " ", "pair", " ", "of", " ", "real", " ", "numbers", " ", "at",
           " ", 
          StyleBox["var",
            "TI"]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"ParametricPlot::pptr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ParametricPlot", "MR"],
  " does not evaluate to a list with two real numbers at the indicated \
point."
}], "Notes",
  CellTags->"ParametricPlot::pptr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ParametricPlot::pptr"],

Cell["\<\
An error occurs in this example because the first argument \
evaluates to a number rather than to a list of two numbers.\
\>", "Text",
  CellTags->"ParametricPlot::pptr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[Cos[x], {x, 0, 2  Pi}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    \(ParametricPlot::"ppcom" \(\(:\)\(\ \)\) 
      "Function \!\(Cos[x]\) cannot be compiled; plotting will proceed with \
the uncompiled function."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    \(ParametricPlot::"pptr" \(\(:\)\(\ \)\) 
      "\!\(Cos[x]\) does not evaluate to a pair of real numbers at \!\(x\) = \
\!\(2.617993877991494`*^-7\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    \(ParametricPlot::"pptr" \(\(:\)\(\ \)\) 
      "\!\(Cos[x]\) does not evaluate to a pair of real numbers at \!\(x\) = \
\!\(0.25488992540742256`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    \(ParametricPlot::"pptr" \(\(:\)\(\ \)\) 
      "\!\(Cos[x]\) does not evaluate to a pair of real numbers at \!\(x\) = \
\!\(0.5328694051959509`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ParametricPlot :: \"pptr\"\) will be suppressed \
during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ParametricPlot::pptr"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ParametricPlot", "MR"],
  "."
}], "Text",
  CellTags->"ParametricPlot::pptr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[{Cos[x], x}, {x, 0, 2  Pi}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ParametricPlot::pptr"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ParametricPlot::pptr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot::ppts
ParametricPlot3D::ppts
Plot::ppts\
\>", "ObjectNameWarningMessages",
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"ppts\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
PlotPoints\)}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "an", " ", "integer"}], " ", ">=",
         " ", "2."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PlotPoints", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["PlotPoints", "MR"],
  " option."
}], "Text",
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Cos[x], {x, 0, 10}, PlotPoints -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[BoxData[
    \(Plot::"ppts" \(\(:\)\(\ \)\) 
      "Value of option PlotPoints -> \!\(All\) is not an integer >= 2."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],

Cell[BoxData[
    \(Plot[Cos[x], {x, 0, 10}, PlotPoints \[Rule] All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PlotPoints", "MR"],
  " option in ",
  StyleBox["Plot", "MR"],
  "."
}], "Text",
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Cos[x], {x, 0, 10}, PlotPoints -> 10]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Play::pfnum", "ObjectNameWarningMessages",
  CellTags->"Play::pfnum"],

Cell[BoxData[
    RowBox[{\(Play::"pfnum"\), \(\(:\)\(\ \)\), \(\(Function\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\((after\ normalization)\)\ never\ evaluates\ to\ a\ \
machine - size\ real\ \(\(number\)\(.\)\)\)\)}]], "Message",
  CellTags->"Play::pfnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Play", "MR"],
  " does not evaluate to a real number or to a list of real numbers.\n\
\[FilledSmallSquare] This message is normally seen only if the value of the \
",
  StyleBox["PlayRange", "MR"],
  " option is used."
}], "Notes",
  CellTags->"Play::pfnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Play::pfnum"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Play", "MR"],
  " includes a symbolic parameter that does not have a numerical value."
}], "Text",
  CellTags->"Play::pfnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Cos[b\ t], {t, 0, 1}, PlayRange -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Play::pfnum"],

Cell[BoxData[
    RowBox[{\(Play::"pfnum"\), \(\(:\)\(\ \)\), "\<\"Function \
\\!\\(\\*TagBox[\\(CompiledFunction[\\(\\(\\(\\({Play`Time2}\\)\\), \
\\(\\(Block[\\(\\(\\(\\({t = \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)}\\)\\), \\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)\
\\)\\)]\\)\\), \\\"-CompiledCode-\\\"\\)\\)]\\), False, Rule[Editable, \
False]]\\) (after normalization) never evaluates to a machine-size real \
number.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Play::pfnum"],

Cell[BoxData[
    \(Play[Cos[b\ t], {t, 0, 1}, PlayRange \[Rule] All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Play::pfnum"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Play", "MR"],
  "."
}], "Text",
  CellTags->"Play::pfnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{b = 440}, 
      Play[Cos[b\ t], {t, 0, 1}, PlayRange -> All]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Play::pfnum"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Play::pfnum"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Play::playr
ListPlay::playr\
\>", "ObjectNameWarningMessages",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"playr\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
PlayRange\)}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", 
          " ", "two", " ", "machine"}], 
        "-", \(size\ real\ \(\(numbers\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PlayRange", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[TextData[{
  "An error occurs in this example because an empty list is not a valid value \
for the ",
  StyleBox["PlayRange", "MR"],
  " option."
}], "Text",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sin[440  t], {t, 0, 1}, PlayRange -> {}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[BoxData[
    \(Play::"playr" \(\(:\)\(\ \)\) 
      "Value of option PlayRange -> \!\({}\) is not a list of two \
machine-size real numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ListPlay::playr", "Play::playr"}],

Cell[BoxData[
    \(Play[Sin[440\ t], {t, 0, 1}, PlayRange \[Rule] {}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ListPlay::playr", "Play::playr"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PlayRange", "MR"],
  " option in ",
  StyleBox["Play", "MR"],
  "."
}], "Text",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sin[440  t], {t, 0, 1}, PlayRange -> {0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ListPlay::playr", "Play::playr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Play::sample", "ObjectNameWarningMessages",
  CellTags->"Play::sample"],

Cell[BoxData[
    RowBox[{\(Play::"sample"\), \(\(:\)\(\ \)\), \(\(Sample\)\(\ \)\(length\)\
\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ machine - 
        size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  CellTags->"Play::sample"],

Cell["\<\
\[FilledSmallSquare] Generated when the number of samples is not a \
positive integer or is too large to be represented as a machine integer on \
your computer.
\[FilledSmallSquare] The number of samples is the product of the sample rate \
and the length of the interval.
\[FilledSmallSquare] Examples that might otherwise generate this message \
because of excessive sample length will often exhaust the memory of your \
computer while allocating memory to store the sample.\
\>", "Notes",
  CellTags->"Play::sample"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Play::sdep
ListPlay::sdep\
\>", "ObjectNameWarningMessages",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"sdep\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
SampleDepth\)}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "should", " ", "be", " ", "a", " ", "positive", " ", 
          "machine"}], "-", \(size\ \(\(integer\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["SampleDepth", "MR"],
  " option is not a positive integer or is too large to be represented as a \
machine integer on your computer."
}], "Notes",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["SampleDepth", "MR"],
  " option."
}], "Text",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sin[440  t], {t, 0, 1}, SampleDepth -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[BoxData[
    \(Play::"sdep" \(\(:\)\(\ \)\) 
      "Value of option SampleDepth -> \!\(All\) should be a positive \
machine-size integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ListPlay::sdep", "Play::sdep"}],

Cell[BoxData[
    \(Play[Sin[440\ t], {t, 0, 1}, SampleDepth \[Rule] All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ListPlay::sdep", "Play::sdep"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Play", "MR"],
  "."
}], "Text",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sin[440  t], {t, 0, 1}, SampleDepth -> 16]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ListPlay::sdep", "Play::sdep"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Play::srate
ListPlay::srate\
\>", "ObjectNameWarningMessages",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"srate\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
SampleRate\)}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "should", " ", "be", " ", "a", " ", "positive", " ", 
          "machine"}], 
        "-", \(size\ real\ \(\(number\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["SampleRate", "MR"],
  " option is not a positive integer or is too large to be represented as a \
machine integer on your computer."
}], "Notes",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["SampleRate", "MR"],
  " option."
}], "Text",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sin[440  t], {t, 0, 1}, SampleRate -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[BoxData[
    \(Play::"srate" \(\(:\)\(\ \)\) 
      "Value of option SampleRate -> \!\(All\) should be a positive \
machine-size real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ListPlay::srate", "Play::srate"}],

Cell[BoxData[
    \(Play[Sin[440\ t], {t, 0, 1}, SampleRate \[Rule] All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ListPlay::srate", "Play::srate"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["SampleRate", "MR"],
  " option in ",
  StyleBox["Play", "MR"],
  "."
}], "Text",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sin[440  t], {t, 0, 1}, SampleRate -> 8192]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ListPlay::srate", "Play::srate"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot3D::plnc", "ObjectNameWarningMessages",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Plot3D::"plnc"\), \(\(:\)\(\ \)\), 
        StyleBox["expr",
          "TI"], " ", 
        RowBox[{\(is\ neither\ a\ machine\), "-", 
          RowBox[{"size", " ", "real", " ", "number", " ", "at", " ", 
            StyleBox["vars",
              "TI"]}]}]}], "=", 
      RowBox[{
        StyleBox["vals",
          "TI"], " ", "nor", " ", "a", " ", "list", " ", "of", " ", "a", " ", 
        "real", " ", "number", " ", "and", " ", "a", " ", "valid", " ", 
        "color", " ", \(\(directive\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Plot3D::plnc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Plot3D", "MR"],
  " does not evaluate to an expression of the expected form at the indicated \
point."
}], "Notes",
  CellTags->"Plot3D::plnc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Plot3D::plnc"],

Cell[TextData[{
  "An error occus in this example because the first argument in ",
  StyleBox["Plot3D", "MR"],
  " includes a symbol that does not have a numerical value."
}], "Text",
  CellTags->"Plot3D::plnc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[b\ x\ y, {x, 0, 1}, {y, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(Plot3D::"plnc" \(\(:\)\(\ \)\) 
      "\!\(b\\ x\\ y\) is neither a machine-size real number at \!\({x, y}\)=\
\!\({0.`, 0.`}\) nor a list of a real number and a valid color \
directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(Plot3D::"plnc" \(\(:\)\(\ \)\) 
      "\!\(b\\ x\\ y\) is neither a machine-size real number at \!\({x, y}\)=\
\!\({0.07142857142857142`, 0.`}\) nor a list of a real number and a valid \
color directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(Plot3D::"plnc" \(\(:\)\(\ \)\) 
      "\!\(b\\ x\\ y\) is neither a machine-size real number at \!\({x, y}\)=\
\!\({0.14285714285714285`, 0.`}\) nor a list of a real number and a valid \
color directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot3D :: \"plnc\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(0.`\\ b\) at grid point xi = \!\(1\), yi = \!\(1\) \
is not a real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(0.`\\ b\) at grid point xi = \!\(1\), yi = \!\(2\) \
is not a real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(0.`\\ b\) at grid point xi = \!\(1\), yi = \!\(3\) \
is not a real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot3D :: \"gval\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Plot3D::plnc"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Plot3D", "MR"],
  "."
}], "Text",
  CellTags->"Plot3D::plnc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{b = 1}, Plot3D[b\ x\ y, {x, 0, 1}, {y, 0, 1}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Plot3D::plnc"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Plot3D::plnc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot3D::gval", "ObjectNameWarningMessages",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value `1` at grid point xi = `2`, yi = `3` is not a real \
number."\)], "Message",
  CellLabel->"From In[45]:=",
  CellTags->"Plot3D::gval"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is \
expected to be a real number.\
\>", "Notes",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Plot3D::gval"],

Cell[TextData[{
  "An error occus in this example because the first argument in ",
  StyleBox["Plot3D", "MR"],
  " includes a symbol that does not have a numerical value."
}], "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[b\ x\ y, {x, 0, 1}, {y, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"plnc" \(\(:\)\(\ \)\) 
      "\!\(b\\ x\\ y\) is neither a machine-size real number at \!\({x, y}\)=\
\!\({0.`, 0.`}\) nor a list of a real number and a valid color \
directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"plnc" \(\(:\)\(\ \)\) 
      "\!\(b\\ x\\ y\) is neither a machine-size real number at \!\({x, y}\)=\
\!\({0.07142857142857142`, 0.`}\) nor a list of a real number and a valid \
color directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"plnc" \(\(:\)\(\ \)\) 
      "\!\(b\\ x\\ y\) is neither a machine-size real number at \!\({x, y}\)=\
\!\({0.14285714285714285`, 0.`}\) nor a list of a real number and a valid \
color directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot3D :: \"plnc\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(0.`\\ b\) at grid point xi = \!\(1\), yi = \!\(1\) \
is not a real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(0.`\\ b\) at grid point xi = \!\(1\), yi = \!\(2\) \
is not a real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(0.`\\ b\) at grid point xi = \!\(1\), yi = \!\(3\) \
is not a real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot3D :: \"gval\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Plot3D::gval"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Plot3D", "MR"],
  "."
}], "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{b = 1}, Plot3D[b\ x\ y, {x, 0, 1}, {y, 0, 1}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Plot3D::gval"]
}, Open  ]],

Cell[TextData[{
  "An error occurs in this example because the first argument in a ",
  StyleBox["SurfaceGraphics", "MR"],
  " expression is expected to be an array of real numbers."
}], "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      SurfaceGraphics[{{Point[1], Point[2]}, {Point[3], 
            Point[4]}}]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(Point[1]\) at grid point xi = \!\(1\), yi = \!\(1\) \
is not a real number."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(Point[3]\) at grid point xi = \!\(1\), yi = \!\(2\) \
is not a real number."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(Plot3D::"gval" \(\(:\)\(\ \)\) 
      "Function value \!\(Point[2]\) at grid point xi = \!\(2\), yi = \!\(1\) \
is not a real number."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Plot3D :: \"gval\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Plot3D::gval"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SurfaceGraphics", "MR"],
  "."
}], "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[SurfaceGraphics[{{1, 2}, {3, 4}}]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Plot3D::gval"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Plot3D::gval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics3D::p3mat", "ObjectNameWarningMessages",
  CellTags->"Graphics3D::p3mat"],

Cell[BoxData[
    RowBox[{\(Graphics3D::"p3mat"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\
\ Plot3Matrix\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ 4\ x\ 4\ numerical\ \
\(\(matrix\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Graphics3D::p3mat"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Plot3Matrix", "MR"],
  " option is not ",
  StyleBox["Automatic", "MR"],
  " or a 4 by 4 matrix of real numbers that describes a perspective \
transformation."
}], "Notes",
  CellTags->"Graphics3D::p3mat"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Graphics3D::p3mat"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Plot3Matrix", "MR"],
  " option is not a square matrix."
}], "Text",
  CellTags->"Graphics3D::p3mat"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[Polygon[{{0, 0, 0}, {1, 0, 0}, {1, 1, 1}}], 
        Plot3Matrix -> {{50, 20, 20}, {10, 25, 20}, {0, 15, \(-50\)}, {0, 0, 
              10}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Graphics3D::p3mat"],

Cell[BoxData[
    \(Graphics3D::"p3mat" \(\(:\)\(\ \)\) 
      "Value of option Plot3Matrix -> \!\({\(\({50, 20, 20}\)\), \(\({10, 25, \
20}\)\), \(\({0, 15, \(\(-50\)\)}\)\), \(\({0, 0, 10}\)\)}\) is not a 4 x 4 \
numerical matrix."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Graphics3D::p3mat"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Graphics3D::p3mat"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Plot3Matrix", "MR"],
  " option."
}], "Text",
  CellTags->"Graphics3D::p3mat"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[Polygon[{{0, 0, 0}, {1, 0, 0}, {1, 1, 1}}], 
        Plot3Matrix -> {{50, 20, 20, 0}, {10, 25, 20, 0}, {0, 15, \(-50\), 
              0}, {0, 0, 10, 50}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Graphics3D::p3mat"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Graphics3D::p3mat"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
PlotRange::gtype
Show::gtype\
\>", "ObjectNameWarningMessages",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"gtype\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "type", " ", "of", 
        " ", \(\(graphics\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is not a \
recognized graphics expression.\n\[FilledSmallSquare] A graphics expression \
is an expression with a head of ",
  StyleBox["Graphics", "MR"],
  ", ",
  StyleBox["SurfaceGraphics", "MR"],
  ", ",
  StyleBox["Graphics3D", "MR"],
  ", ",
  StyleBox["ContourGraphics", "MR"],
  ", ",
  StyleBox["DensityGraphics", "MR"],
  ", ",
  StyleBox["GraphicsArray", "MR"],
  ", or ",
  StyleBox["Sound", "MR"],
  ".\n\[FilledSmallSquare] The head of the unrecognized expression is \
reported in the message."
}], "Notes",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Line", "MR"],
  " is a graphics primitive rather than a type of graphics."
}], "Text",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Line[{{0, 0}, {1, 1}, {2, 0}, {3, 2}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[BoxData[
    \(Show::"gtype" \(\(:\)\(\ \)\) 
      "\!\(Line\) is not a type of graphics."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[BoxData[
    \(Show[Line[{{0, 0}, {1, 1}, {2, 0}, {3, 2}}]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"PlotRange::gtype", "Show::gtype"}]
}, Open  ]],

Cell["This shows a valid graphics expression.", "Text",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{{0, 0}, {1, 1}, {2, 0}, {3, 2}}]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"PlotRange::gtype", "Show::gtype"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Raster::rsrec
RasterArray::rsrec\
\>", "ObjectNameWarningMessages",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"rsrec\"\>"}], \(\(:\)\(\ \)\), "Second", " ", 
      "argument", " ", 
      StyleBox["arg",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", " ", 
      "two", " ", \(\(coordinates\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Raster", "MR"],
  " is not a list with two elements, or if the elements are not valid \
coordinates for the corners of a rectangle.\n\[FilledSmallSquare] Coordinates \
can be specified using a pair of real numbers or using ",
  StyleBox["Scaled", "MR"],
  "."
}], "Notes",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Raster", "MR"],
  " is a list with only one element."
}], "Text",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Line[{{0, 0}, {5, 5}}], 
          Raster[{{1, 0, 1, 0}, {0, 0, 0.5, 1}}, {{1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[BoxData[
    \(Raster::"rsrec" \(\(:\)\(\ \)\) 
      "Second argument \!\({\({1, 1}\)}\) in \!\(Raster\) is not a list of \
two coordinates."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"RasterArray::rsrec", "Raster::rsrec"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"RasterArray::rsrec", "Raster::rsrec"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Raster", "MR"],
  "."
}], "Text",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Line[{{0, 0}, {5, 5}}], 
          Raster[{{1, 0, 1, 0}, {0, 0, 0.5, 1}}, {{1, 1}, {4, 
                4}}]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"RasterArray::rsrec", "Raster::rsrec"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Raster::rscd
RasterArray::rscd\
\>", "ObjectNameWarningMessages",
  CellTags->{"Raster::rscd", "RasterArray::rscd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"rscd\"\>"}], \(\(:\)\(\ \)\), "\<\"Color `1` is \
incompatible with the previous color.\"\>"}]], "Message",
  CellLabel->"From In[45]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"RasterArray::rscd", "Raster::rscd"}],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{"Raster::rscd", "RasterArray::rscd"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RasterArray::rscol", "ObjectNameWarningMessages",
  CellTags->"RasterArray::rscol"],

Cell[BoxData[
    \(RasterArray::"rscol" \(\(:\)\(\ \)\) 
      "Expression `1` at position `2` in first argument of `3` is not a valid \
color or gray-level directive."\)], "Message",
  CellLabel->"From In[46]:=",
  CellTags->"RasterArray::rscol"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"RasterArray::rscol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Raster::rsval", "ObjectNameWarningMessages",
  CellTags->"Raster::rsval"],

Cell[BoxData[
    \(Raster::"rsval" \(\(:\)\(\ \)\) 
      "Non-numerical value `1` found at position `2` in first argument of \
`3`."\)], "Message",
  CellLabel->"From In[46]:=",
  CellTags->"Raster::rsval"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Raster::rsval"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show::gcc", "ObjectNameWarningMessages",
  CellTags->"Show::gcc"],

Cell[BoxData[
    RowBox[{\(Show::"gcc"\), \(\(:\)\(\ \)\), \(\(Graphics\)\(\ \)\(of\)\(\ \
\)\(type\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ combined\ with\ other\ types\ of\ \
\(\(graphics\)\(.\)\)\)\)}]], "Message",
  CellTags->"Show::gcc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated graphics expression \
cannot be combined with other types of graphics expressions.\n\
\[FilledSmallSquare] The type of a graphics expression is determined by the \
head of the expression.\n\[FilledSmallSquare] Graphics expressions are \
combined when ",
  StyleBox["Show", "MR"],
  " is used with more than one argument.\n\[FilledSmallSquare] Expressions of \
type ",
  StyleBox["GraphicsArray", "MR"],
  " cannot be combined with other types of graphics."
}], "Notes",
  CellTags->"Show::gcc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Show::gcc"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["GraphicsArray", "MR"],
  " expressions cannot be combined with other types of graphics expressions."
}], "Text",
  CellTags->"Show::gcc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{Graphics[Line[{{0, 0}, {1, 3}}]], \n\t\tGraphics[
            Line[{{0, 2}, {2, 0}}]]}], \n\t
      Graphics[Line[{{0, 0}, {1, 4}}]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Show::gcc"],

Cell[BoxData[
    RowBox[{\(Show::"gcc"\), \(\(:\)\(\ \)\), "\<\"Graphics of type \
\\!\\(\\*TagBox[\\(\[SkeletonIndicator] GraphicsArray \
\[SkeletonIndicator]\\), False, Rule[Editable, False]]\\) cannot be combined \
with other types of graphics.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Show::gcc"],

Cell[BoxData[
    RowBox[{"Show", "[", 
      RowBox[{
        TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Show::gcc"]
}, Open  ]],

Cell[TextData[{
  "Additional graphics expressions can be included in the arguments of ",
  StyleBox["GraphicsArray", "MR"],
  "."
}], "Text",
  CellTags->"Show::gcc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{Graphics[Line[{{0, 0}, {1, 3}}]], \n\t\tGraphics[
            Line[{{0, 2}, {2, 0}}]], \n\t
          Graphics[Line[{{0, 0}, {1, 4}}]]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Show::gcc"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Show::gcc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show::gcomb", "ObjectNameWarningMessages",
  CellTags->"Show::gcomb"],

Cell[BoxData[
    RowBox[{\(Show::"gcomb"\), \(\(:\)\(\ \)\), \(\(An\)\(\ \)\(error\)\(\ \)\
\(was\)\(\ \)\(encountered\)\(\ \)\(in\)\(\ \)\(combining\)\(\ \)\(the\)\(\ \
\)\(graphics\)\(\ \)\(objects\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Show::gcomb"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Show", "MR"],
  " is used with more than one argument and at least one of the arguments is \
not a valid graphics expression."
}], "Notes",
  CellTags->"Show::gcomb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Show::gcomb"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Line", "MR"],
  " is a graphics primitive rather than a graphics expression."
}], "Text",
  CellTags->"Show::gcomb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Line[{{0, 1}, {5, 2}}], Line[{{0, 0}, {5, 3}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Show::gcomb"],

Cell[BoxData[
    \(Show::"gcomb" \(\(:\)\(\ \)\) 
      "An error was encountered in combining the graphics objects in \
\!\(Show[\(\(\(\(Line[\(\({\(\({0, 1}\)\), \(\({5, 2}\)\)}\)\)]\)\), \
\(\(Line[\(\({\(\({0, 0}\)\), \(\({5, 3}\)\)}\)\)]\)\)\)\)]\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Show::gcomb"],

Cell[BoxData[
    \(Show[Line[{{0, 1}, {5, 2}}], Line[{{0, 0}, {5, 3}}]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Show::gcomb"]
}, Open  ]],

Cell[TextData[{
  "This shows valid graphics expressions in ",
  StyleBox["Show", "MR"],
  "."
}], "Text",
  CellTags->"Show::gcomb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{{0, 1}, {5, 2}}]], 
      Graphics[Line[{{0, 0}, {5, 3}}]]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Show::gcomb"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Show::gcomb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show::gmed", "ObjectNameWarningMessages",
  CellTags->"Show::gmed"],

Cell[BoxData[
    \(Show::"gmed" \(\(:\)\(\ \)\) \(No\ graphics\ output\ medium\ \
\(\(specified\)\(.\)\)\)\)], "Message",
  CellTags->"Show::gmed"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when no valid medium is found for graphics \
output.\n\[FilledSmallSquare] Graphics output is normally sent to the stream \
specified in the value of ",
  StyleBox["$Display", "MR"],
  ".\n\[FilledSmallSquare] The output medium for plotting functions is taken \
by default from the value of ",
  StyleBox["$DisplayFunction", "MR"],
  ".\n\[FilledSmallSquare] When graphics are written using ",
  StyleBox["Display", "MR"],
  ", the first argument specifies the output medium.\n\[FilledSmallSquare] \
The values of ",
  StyleBox["$Display", "MR"],
  " and ",
  StyleBox["$DisplayFunction", "MR"],
  " are assigned during initialization and have different values on different \
types of computers.\n\[FilledSmallSquare] This message can be generated if \
the output medium is not specified correctly or if the file or stream cannot \
be opened for writing."
}], "Notes",
  CellTags->"Show::gmed"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Show::gmed"],

Cell["\<\
An error occurs in this example because an empty list is not a \
valid specification for an output medium.\
\>", "Text",
  CellTags->"Show::gmed"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display[{}, Graphics[Line[{{0, 0}, {1, 1}}]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Show::gmed"],

Cell[BoxData[
    \(Show::"gmed" \(\(:\)\(\ \)\) 
      "No graphics output medium specified."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Show::gmed"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Show::gmed"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show::shx", "ObjectNameWarningMessages",
  CellTags->"Show::shx"],

Cell[BoxData[
    \(Show::"shx" \(\(:\)\(\ \)\) \(No\ graphical\ objects\ to\ \(\(show\)\(.\
\)\)\)\)], "Message",
  CellTags->"Show::shx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Show", "MR"],
  " is used without specifying any graphics expressions to show."
}], "Notes",
  CellTags->"Show::shx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Show::shx"],

Cell[TextData[{
  "An error occurs in this example because the arguments in ",
  StyleBox["Show", "MR"],
  " do not include any graphics expressions."
}], "Text",
  CellTags->"Show::shx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[AspectRatio -> 0.3, Frame -> True]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Show::shx"],

Cell[BoxData[
    \(Show::"shx" \(\(:\)\(\ \)\) 
      "No graphical objects to show."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Show::shx"],

Cell[BoxData[
    \(Show[AspectRatio \[Rule] 0.3`, Frame \[Rule] True]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Show::shx"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Show", "MR"],
  "."
}], "Text",
  CellTags->"Show::shx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[Graphics[Line[{{0, 0}, {1, 1}, {2, 0}, {3, 3}}]], 
      AspectRatio -> 0.3, Frame -> True]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Show::shx"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Show::shx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sound::ssnf", "ObjectNameWarningMessages",
  CellTags->"Sound::ssnf"],

Cell[BoxData[
    RowBox[{\(Sound::"ssnf"\), ":", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], " ", "out", " ", "of", " ", 
        StyleBox["total",
          "TI"], " ", "sample", " ", "points", " ", "did", " ", "not", " ", 
        "evaluate", " ", "to", " ", "real", 
        " ", \(\(numbers\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Sound::ssnf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated number of points from a \
",
  StyleBox["Sound", "MR"],
  " expression are not real numbers."
}], "Notes",
  CellTags->"Sound::ssnf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Sound::ssnf"],

Cell[TextData[{
  "A warning message is generated in this example because not all of the \
values used in constructing the ",
  StyleBox["Sound", "MR"],
  " expression are real numbers."
}], "Text",
  CellTags->"Sound::ssnf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlay[Table[Sqrt[2  Sin[440  x] - 1], {x, 0, 1, 0.01}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Sound::ssnf"],

Cell[BoxData[
    \(Sound::"ssnf" \(\(:\)\(\ \)\) 
      "\!\(65\) out of \!\(101\) sample points did not evaluate to real \
numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sound::ssnf"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Sound::ssnf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sound::ssnm", "ObjectNameWarningMessages",
  CellTags->"Sound::ssnm"],

Cell[BoxData[
    \(Sound::"ssnm" \(\(:\)\(\ \)\) \(A\ good\ PlayRange\ could\ not\ be\ \
found\ since\ most\ of\ the\ samples\ are\ not\ evaluating\ to\ machine - 
        size\ real\ \(\(numbers\)\(.\)\)\)\)], "Message",
  CellTags->"Sound::ssnm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a function that is sampled to \
construct a ",
  StyleBox["Sound", "MR"],
  " expression does not evaluate to a real number at all of the sample \
points.\n\[FilledSmallSquare] This message can occur if the input includes \
symbolic parameters that do not have numerical values, or if the input \
evaluates to a complex number."
}], "Notes",
  CellTags->"Sound::ssnm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Sound::ssnm"],

Cell["\<\
A warning message is generated in this example because the argument \
function is a complex number at some of the sample points.\
\>", "Text",
  CellTags->"Sound::ssnm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Play[Sqrt[2  Sin[440  x] - 1], {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Sound::ssnm"],

Cell[BoxData[
    \(Sound::"ssnm" \(\(:\)\(\ \)\) 
      "A good PlayRange could not be found since most of the samples are not \
evaluating to machine-size real numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sound::ssnm"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Sound  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Sound::ssnm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SurfaceColor::shine", "ObjectNameWarningMessages",
  CellTags->"SurfaceColor::shine"],

Cell[BoxData[
    RowBox[{\(SurfaceColor::"shine"\), \(\(:\)\(\ \)\), "Shininess", " ", 
      "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "in", " ", "third", " ", "argument", " ", "of", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ real\ \
\(\(number\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SurfaceColor::shine"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["SurfaceColor", "MR"],
  " is not a positive real number."
}], "Notes",
  CellTags->"SurfaceColor::shine"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SurfaceColor::shine"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["SurfaceColor", "MR"],
  " is a ",
  StyleBox["GrayLevel", "MR"],
  " directive rather than a real number."
}], "Text",
  CellTags->"SurfaceColor::shine"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{SurfaceColor[RGBColor[1, 0, 0], GrayLevel[1], 
            GrayLevel[0.5]], 
          Polygon[{{0, 0, 0}, {1, 0, 0}, {0, 1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SurfaceColor::shine"],

Cell[BoxData[
    \(SurfaceColor::"shine" \(\(:\)\(\ \)\) 
      "Shininess specification \!\(GrayLevel[0.5`]\) in third argument of \
\!\(SurfaceColor[\(\(\(\(RGBColor[\(\(1, 0, 0\)\)]\)\), \(\(GrayLevel[1]\)\), \
\(\(GrayLevel[0.5`]\)\)\)\)]\) is not a positive real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SurfaceColor::shine"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SurfaceColor::shine"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid ",
  StyleBox["SurfaceColor", "MR"],
  " specification."
}], "Text",
  CellTags->"SurfaceColor::shine"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{SurfaceColor[RGBColor[1, 0, 0], GrayLevel[1], 0.5], 
          Polygon[{{0, 0, 0}, {1, 0, 0}, {0, 1, 1}}]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SurfaceColor::shine"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SurfaceColor::shine"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SurfaceColor::specl", "ObjectNameWarningMessages",
  CellTags->"SurfaceColor::specl"],

Cell[BoxData[
    RowBox[{\(SurfaceColor::"specl"\), \(\(:\)\(\ \)\), "Specularity", " ", 
      "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "in", " ", "second", " ", "argument", " ", "of", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ GrayLevel\ or\ RGBColor\ \
\(\(directive\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SurfaceColor::specl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["SurfaceColor", "MR"],
  " is not a valid color directive."
}], "Notes",
  CellTags->"SurfaceColor::specl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SurfaceColor::specl"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["SurfaceColor", "MR"],
  " is a number rather than a color directive."
}], "Text",
  CellTags->"SurfaceColor::specl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{SurfaceColor[RGBColor[1, 0, 0], 0.5], 
          Polygon[{{0, 0, 0}, {1, 0, 0}, {0, 1, 1}}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SurfaceColor::specl"],

Cell[BoxData[
    \(SurfaceColor::"specl" \(\(:\)\(\ \)\) 
      "Specularity specification \!\(0.5`\) in second argument of \
\!\(SurfaceColor[\(\(\(\(RGBColor[\(\(1, 0, 0\)\)]\)\), 0.5`\)\)]\) is not a \
valid GrayLevel or RGBColor directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SurfaceColor::specl"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SurfaceColor::specl"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SurfaceColor", "MR"],
  "."
}], "Text",
  CellTags->"SurfaceColor::specl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics3D[{SurfaceColor[RGBColor[1, 0, 0], GrayLevel[0.5]], 
          Polygon[{{0, 0, 0}, {1, 0, 0}, {0, 1, 1}}]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SurfaceColor::specl"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SurfaceColor::specl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SurfaceGraphics::pmsr
DensityGraphics::pmsr
ContourGraphics::pmsr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"pmsr\"\>"}], \(\(:\)\(\ \)\), "PlotRange", " ", 
      StyleBox["r1",
        "TI"], " ", "is", " ", "so", " ", "much", " ", "smaller", " ", "than",
       " ", "MeshRange", " ", 
      StyleBox["r2",
        "TI"], " ", "that", " ", "there", " ", "is", " ", "nothing", " ", 
      "left", " ", "to", " ", \(\(plot\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PlotRange", "MR"],
  " option does not include any points from the mesh specified by the ",
  StyleBox["MeshRange", "MR"],
  " option."
}], "Notes",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[TextData[{
  "An error occurs in this example because the range specified in the value \
of the ",
  StyleBox["PlotRange", "MR"],
  " option does not include any data points for these data and the given \
value of the ",
  StyleBox["MeshRange", "MR"],
  " option."
}], "Text",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      DensityGraphics[{{1, 3, 3, 1, 4}, {2, 5, 4, 3, 1}, {3, 4, 1, 4, 5}, {4, 
            3, 5, 2, 3}, {3, 1, 1, 5, 3}}, MeshRange -> {{0, 100}, {0, 100}}, 
        PlotRange -> {{0, 5}, {0, 5}, {0, 5}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[BoxData[
    \(DensityGraphics::"pmsr" \(\(:\)\(\ \)\) 
      "PlotRange \!\({\(\({0, 5}\)\), \(\({0, 5}\)\), \(\({0, 5}\)\)}\) is so \
much smaller than MeshRange \!\({\(\({0, 100}\)\), \(\({0, 100}\)\)}\) that \
there is nothing left to plot."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ContourGraphics::pmsr", "DensityGraphics::pmsr", "SurfaceGraphics::pmsr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "ContourGraphics::pmsr", "DensityGraphics::pmsr", "SurfaceGraphics::pmsr"}]
}, Open  ]],

Cell[TextData[{
  "This example shows valid values for the ",
  StyleBox["MeshRange", "MR"],
  " and ",
  StyleBox["PlotRange", "MR"],
  " options for these data."
}], "Text",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      DensityGraphics[{{1, 3, 3, 1, 4}, {2, 5, 4, 3, 1}, {3, 4, 1, 4, 5}, {4, 
            3, 5, 2, 3}, {3, 1, 1, 5, 3}}, MeshRange -> {{0, 100}, {0, 100}}, 
        PlotRange -> {{0, 50}, {0, 50}, {0, 5}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", "ContourGraphics::pmsr"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ContourGraphics::pmsr", "DensityGraphics::pmsr", "SurfaceGraphics::pmsr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SurfaceGraphics::shade", "ObjectNameWarningMessages",
  CellTags->"SurfaceGraphics::shade"],

Cell[BoxData[
    RowBox[{\(SurfaceGraphics::"shade"\), \(\(:\)\(\ \)\), \(\(Shading\)\(\ \
\)\(array\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ the\ same\ shape\ as\ the\ z - 
        value\ \(\(array\)\(.\)\)\)\)}]], "Message",
  CellTags->"SurfaceGraphics::shade"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["SurfaceGraphics", "MR"],
  " is not an array or is not compatible with the array given in the first \
argument.\n\[FilledSmallSquare] The first argument in ",
  StyleBox["SurfaceGraphics", "MR"],
  " gives an array of height values, and the second argument gives an array \
specifying how the surface should be shaded.\n\[FilledSmallSquare] If the \
array of height values has dimensions ",
  StyleBox["n1", "MR",
    FontSlant->"Italic"],
  " by ",
  StyleBox["n2", "MR",
    FontSlant->"Italic"],
  ", the shading array is expected to have dimensions ",
  StyleBox["n1", "MR",
    FontSlant->"Italic"],
  StyleBox["-1", "MR"],
  " by ",
  StyleBox["n2", "MR",
    FontSlant->"Italic"],
  StyleBox["-1", "MR"],
  "."
}], "Notes",
  CellTags->"SurfaceGraphics::shade"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SurfaceGraphics::shade"],

Cell[TextData[{
  "An error occurs in this example because the array of shading \
specifications in the second argument of ",
  StyleBox["SurfaceGraphics", "MR"],
  " does not have enough columns to shade all of the regions of the surface."
}], "Text",
  CellTags->"SurfaceGraphics::shade"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      SurfaceGraphics[{{2, 3, 2, 1, 1}, {5, 3, 2, 1, 0}, {3, 2, 2, 1, 
            4}}, {{RGBColor[1, 0, 0], RGBColor[0, 0, 1], 
            RGBColor[1, 1, 0]}, {RGBColor[0, 0, 1], RGBColor[1, 0, 0], 
            RGBColor[0, 0, 1]}}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SurfaceGraphics::shade"],

Cell[BoxData[
    \(SurfaceGraphics::"shade" \(\(:\)\(\ \)\) 
      "Shading array \!\({\(\({\(\(RGBColor[\(\(1, 0, 0\)\)]\)\), \
\(\(RGBColor[\(\(0, 0, 1\)\)]\)\), \(\(RGBColor[\(\(1, 1, 0\)\)]\)\)}\)\), \(\
\({\(\[LeftSkeleton] 1 \[RightSkeleton]\)}\)\)}\) is not the same shape as \
the z-value array."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SurfaceGraphics::shade"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SurfaceGraphics::shade"]
}, Open  ]],

Cell["\<\
This shows a valid shading array for this array of height values.\
\
\>", "Text",
  CellTags->"SurfaceGraphics::shade"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      SurfaceGraphics[{{2, 3, 2, 1, 1}, {5, 3, 2, 1, 0}, {3, 2, 2, 1, 
            4}}, {{RGBColor[1, 0, 0], RGBColor[0, 0, 1], RGBColor[1, 1, 0], 
            RGBColor[0, 0, 1]}, {RGBColor[0, 0, 1], RGBColor[1, 0, 0], 
            RGBColor[0, 0, 1], RGBColor[1, 0, 0]}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SurfaceGraphics::shade"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SurfaceGraphics::shade"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Text::textn", "ObjectNameWarningMessages",
  CellTags->"Text::textn"],

Cell[BoxData[
    RowBox[{\(Text::"textn"\), \(\(:\)\(\ \)\), \(\(Text\)\(\ \)\(offset\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ pair\ of\ \(\(numbers\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Text::textn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["Text", "MR"],
  " is not a list of two real numbers."
}], "Notes",
  CellTags->"Text::textn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Text::textn"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["Text", "MR"],
  " is an integer rather than a pair of numbers."
}], "Text",
  CellTags->"Text::textn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Line[{{0, 0}, {2, 2}}], 
          Text["\<abc\>", \ {1, \ 1}, \ 5]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Text::textn"],

Cell[BoxData[
    \(Text::"textn" \(\(:\)\(\ \)\) 
      "Text offset \!\(5\) is not a pair of numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Text::textn"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Text::textn"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Text", "MR"],
  "."
}], "Text",
  CellTags->"Text::textn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Line[{{0, 0}, {2, 2}}], 
          Text["\<abc\>", \ {1, \ 1}, \ {5, 0}]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Text::textn"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Text::textn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Text::textz", "ObjectNameWarningMessages",
  CellTags->"Text::textz"],

Cell[BoxData[
    \(Text::"textz" \(\(:\)\(\ \)\) \(Vector\ for\ text\ rotation\ cannot\ \
have\ value\ \(\({0, 0}\)\(.\)\)\)\)], "Message",
  CellTags->"Text::textz"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the fourth argument in ",
  StyleBox["Text", "MR"],
  " is ",
  StyleBox["{0,0}", "MR"],
  "."
}], "Notes",
  CellTags->"Text::textz"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Text::textz"],

Cell[TextData[{
  "An error occurs in this example because the text rotation specification in \
",
  StyleBox["Text", "MR"],
  " has an invalid value."
}], "Text",
  CellTags->"Text::textz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Line[{{0, 0}, {2, 2}}], 
          Text["\<abc\>", {1, 1}, {0, 1}, {0, 0}]}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Text::textz"],

Cell[BoxData[
    \(Text::"textz" \(\(:\)\(\ \)\) 
      "Vector for text rotation cannot have value {0,0}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Text::textz"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Text::textz"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Text", "MR"],
  "."
}], "Text",
  CellTags->"Text::textz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Line[{{0, 0}, {2, 2}}], 
          Text["\<abc\>", {1, 1}, {0, 1}, {0, 1}]}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Text::textz"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Text::textz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
AbsoluteThickness::thkn
Thickness::thkn\
\>", "ObjectNameWarningMessages",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"thkn\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "argument", " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", 
      " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Thickness", "MR"],
  " or ",
  StyleBox["AbsoluteThickness", "MR"],
  " is not a real number."
}], "Notes",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Thickness", "MR"],
  " is a list rather than a number."
}], "Text",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 1}, 
      FaceGrids -> {{{\(-1\), 0, 
              0}, {{0.5, {GrayLevel[0], Thickness[{0.02}]}}}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[BoxData[
    \(Thickness::"thkn" \(\(:\)\(\ \)\) 
      "The argument in \!\(Thickness[\(\({0.02`}\)\)]\) is not a number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[BoxData[
    \(Thickness::"thkn" \(\(:\)\(\ \)\) 
      "The argument in \!\(Thickness[\(\({0.02`}\)\)]\) is not a number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Thickness", "MR"],
  "."
}], "Text",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[x\ y, {x, 0, 1}, {y, 0, 1}, 
      FaceGrids -> {{{\(-1\), 0, 
              0}, {{0.5, {GrayLevel[0], Thickness[0.02]}}}}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ticks::ticks", "ObjectNameWarningMessages",
  CellTags->"Ticks::ticks"],

Cell[BoxData[
    RowBox[{\(Ticks::"ticks"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ tick\ \
\(\(specification\)\(.\)\)\)\)}]], "Message",
  CellTags->"Ticks::ticks"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Ticks", "MR"],
  " option is not ",
  StyleBox["None", "MR"],
  ", ",
  StyleBox["Automatic", "MR"],
  ", or a list describing the position, labels, and style for tick marks on \
each axis."
}], "Notes",
  CellTags->"Ticks::ticks"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Ticks::ticks"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["Ticks", "MR"],
  " option is a list with three elements and is expected in two dimensions to \
be a list with two elements."
}], "Text",
  CellTags->"Ticks::ticks"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  Pi}, 
      Ticks -> {{1, "\<A\>"}, {2, "\<B\>"}, {3, "\<C\>"}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Ticks::ticks"],

Cell[BoxData[
    \(Ticks::"ticks" \(\(:\)\(\ \)\) 
      "\!\({\(\({1, \"A\"}\)\), \(\({2, \"B\"}\)\), \(\({3, \"C\"}\)\)}\) is \
not a valid tick specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Ticks::ticks"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Ticks::ticks"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Ticks", "MR"],
  " option for a plot in two dimensions."
}], "Text",
  CellTags->"Ticks::ticks"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  Pi}, 
      Ticks -> {{{1, "\<A\>"}, {2, "\<B\>"}, {3, "\<C\>"}}, None}]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"Ticks::ticks"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Ticks::ticks"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ColorOutput::colpc
ToColor::colpc\
\>", "ObjectNameWarningMessages",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"colpc\"\>"}], \(\(:\)\(\ \)\), "Result", " ", 
        StyleBox["expr",
          "TI"], " ", "obtained", " ", "during", " ", "color", " ", 
        "conversion", " ", "by", " ", "applying", " ", "function", " ", 
        StyleBox["c1",
          "TI"], " ", "to", " ", "color", " ", 
        StyleBox["c2",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "GrayLevel"}], ",", 
      " ", "RGBColor", ",", 
      " ", \(or\ CMYKColor\ color\ \(\(directive\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when color conversion using the indicated \
function gives a result that is not a valid color directive.\n\
\[FilledSmallSquare] The result of applying the value of the ",
  StyleBox["ColorOutput", "MR"],
  " option to a valid color directive should be another valid color \
directive."
}], "Notes",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ColorOutput", "MR"],
  " function does not give a color directive when it is applied to another \
color directive."
}], "Text",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  Pi}, 
      ColorOutput -> \((RGBColor[1, 0, 0])\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[BoxData[
    \(ColorOutput::"colpc" \(\(:\)\(\ \)\) 
      "Result \!\(\(\(RGBColor[\(\(1, 0, 0\)\)]\)\)[\(\(GrayLevel[0.`]\)\)]\) \
obtained during color conversion by applying function \!\(RGBColor[\(\(1, 0, \
0\)\)]\) to color \!\(GrayLevel[0.`]\) is not a GrayLevel, RGBColor, or \
CMYKColor color directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["ColorOutput", "MR"],
  " option."
}], "Text",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  Pi}, 
      ColorOutput -> \((RGBColor[1, 0, 0] &)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ColorOutput::colpw
ToColor::colpw\
\>", "ObjectNameWarningMessages",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"colpw\"\>"}], \(\(:\)\(\ \)\), "Result", " ", 
      StyleBox["c2",
        "TI"], " ", "obtained", " ", "during", " ", "color", " ", 
      "conversion", " ", "by", " ", "applying", " ", "function", " ", 
      StyleBox["expr",
        "TI"], " ", "to", " ", "color", " ", 
      StyleBox["c1",
        "TI"], " ", "has", " ", "the", " ", "wrong", " ", "number", " ", "of",
       " ", "arguments", " ", "for", " ", "that", 
      " ", \(\(color\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when color conversion using the indicated \
function gives a result that is not a valid color directive.\n\
\[FilledSmallSquare] The result of applying the value of the ",
  StyleBox["ColorOutput", "MR"],
  " option to a valid color directive should be another valid color \
directive."
}], "Notes",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ColorOutput", "MR"],
  " gives an invalid color directive when it is applied to a ",
  StyleBox["GrayLevel", "MR"],
  " directive."
}], "Text",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  Pi}, 
      ColorOutput -> \((RGBColor @@ # &)\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[BoxData[
    \(ColorOutput::"colpw" \(\(:\)\(\ \)\) 
      "Result \!\(RGBColor[0.`]\) obtained during color conversion by \
applying function \!\(\(\(RGBColor @@ #1\)\) &\) to color \
\!\(GrayLevel[0.`]\) has the wrong number of arguments for that color."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["ColorOutput", "MR"],
  " option."
}], "Text",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Sin[x], {x, 0, 2  Pi}, 
      ColorOutput -> \((RGBColor[#[\([1]\)], 0, 1] &)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToColor::tocol", "ObjectNameWarningMessages",
  CellTags->"ToColor::tocol"],

Cell[BoxData[
    RowBox[{\(ToColor::"tocol"\), \(\(:\)\(\ \)\), \(\(First\)\(\ \
\)\(argument\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(in\ ToColor\ should\ be\ a\ valid\ color\ \
\(\(directive\)\(.\)\)\)\)}]], "Message",
  CellTags->"ToColor::tocol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ToColor", "MR"],
  " is not a valid color directive."
}], "Notes",
  CellTags->"ToColor::tocol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ToColor::tocol"],

Cell["\<\
An error occurs in this example because a number is not a valid \
color directive.\
\>", "Text",
  CellTags->"ToColor::tocol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToColor[1, RGBColor]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ToColor::tocol"],

Cell[BoxData[
    \(ToColor::"tocol" \(\(:\)\(\ \)\) 
      "First argument \!\(1\) in ToColor should be a valid color \
directive."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ToColor::tocol"],

Cell[BoxData[
    \(ToColor[1, RGBColor]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ToColor::tocol"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ToColor", "MR"],
  "."
}], "Text",
  CellTags->"ToColor::tocol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToColor[GrayLevel[1], RGBColor]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ToColor::tocol"],

Cell[BoxData[
    \(RGBColor[1.`, 1.`, 1.`]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ToColor::tocol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::colfun", "ObjectNameWarningMessages",
  CellTags->"General::colfun"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"colfun\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "ColorFunction", " ", 
        StyleBox["f",
          "TI"], " ", "does", " ", "not", " ", "produce", " ", "a", " ", 
        "valid", " ", "color", " ", "or", " ", "gray"}], "-", 
      RowBox[{
      "level", " ", "directive", " ", "when", " ", "applied", " ", "to", " ", 
        "element", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::colfun"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ColorFunction", "MR"],
  " option does not lead to a valid color or gray-level directive at the \
indicated point."
}], "Notes",
  CellTags->"General::colfun"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::colfun"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " does not give a valid color directive when it is used as the value of the \
",
  StyleBox["ColorFunction", "MR"],
  " option."
}], "Text",
  CellTags->"General::colfun"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      DensityGraphics[{{2, 3}, {3, 1}}, 
        ColorFunction \[Rule] None]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(None::"color" \(\(:\)\(\ \)\) 
      "\!\(None[0.5`]\) is not a valid color or gray-level \
specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(DensityGraphics::"colfun" \(\(:\)\(\ \)\) 
      "The ColorFunction \!\(None\) does not produce a valid color or \
gray-level directive when applied to element \!\({1, 1}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(None::"color" \(\(:\)\(\ \)\) 
      "\!\(None[1.`]\) is not a valid color or gray-level specification."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(DensityGraphics::"colfun" \(\(:\)\(\ \)\) 
      "The ColorFunction \!\(None\) does not produce a valid color or \
gray-level directive when applied to element \!\({1, 2}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(None::"color" \(\(:\)\(\ \)\) 
      "\!\(None[1.`]\) is not a valid color or gray-level specification."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(None :: \"color\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(DensityGraphics::"colfun" \(\(:\)\(\ \)\) 
      "The ColorFunction \!\(None\) does not produce a valid color or \
gray-level directive when applied to element \!\({2, 1}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(DensityGraphics :: \"colfun\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::colfun"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["ColorFunction", "MR"],
  " option."
}], "Text",
  CellTags->"General::colfun"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      DensityGraphics[{{2, 3}, {3, 1}}, 
        ColorFunction \[Rule] \((RGBColor[#, 0, 0] &)\)]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::colfun"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::colfun"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::colfun1", "ObjectNameWarningMessages",
  CellTags->"General::colfun1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"colfun1\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "ColorFunction", " ", 
      StyleBox["expr",
        "TI"], " ", "produces", " ", "a", " ", "color", " ", "incompatible", 
      " ", "with", " ", "the", " ", "previous", " ", "color", " ", "when", 
      " ", "applied", " ", "to", " ", "element", " ", 
      RowBox[{
        StyleBox["pt",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::colfun1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated value of the ",
  StyleBox["ColorFunction", "MR"],
  " option leads to color or gray-level directives that are not all of the \
same type."
}], "Notes",
  CellTags->"General::colfun1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::colfun1"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ColorFunction", "MR"],
  " option gives incompatible directives for different values of the \
argument."
}], "Text",
  CellTags->"General::colfun1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      DensityGraphics[{{1, 6, 2}, {2, 3, 4}}, 
        ColorFunction \[Rule] \((If[# < 0.5, RGBColor[2  #, 0, 0], 
                GrayLevel[1]] &)\)]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::colfun1"],

Cell[BoxData[
    \(DensityGraphics::"colfun1" \(\(:\)\(\ \)\) 
      "The ColorFunction \!\(\(\(If[\(\(\(\(#1 < 0.5`\)\), \
\(\(RGBColor[\(\(\(\(2\\ #1\)\), 0, 0\)\)]\)\), \(\(GrayLevel[1]\)\)\)\)]\)\) \
&\) produces a color incompatible with the previous color when applied to \
element \!\({1, 2}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun1"],

Cell[BoxData[
    \(DensityGraphics::"colfun1" \(\(:\)\(\ \)\) 
      "The ColorFunction \!\(\(\(If[\(\(\(\(#1 < 0.5`\)\), \
\(\(RGBColor[\(\(\(\(2\\ #1\)\), 0, 0\)\)]\)\), \(\(GrayLevel[1]\)\)\)\)]\)\) \
&\) produces a color incompatible with the previous color when applied to \
element \!\({2, 3}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::colfun1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::colfun1"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["ColorFunction", "MR"],
  " option."
}], "Text",
  CellTags->"General::colfun1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      DensityGraphics[{{1, 6, 2}, {2, 3, 4}}, 
        ColorFunction \[Rule] \((If[# < 0.5, RGBColor[2  #, 0, 0], 
                RGBColor[1, 1, 1]] &)\)]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::colfun1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::colfun1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RasterGraphics::argx", "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::argx"],

Cell[BoxData[
    \(RasterGraphics::"argx" \(\(:\)\(\ \)\) \(Graphics\ called\ with\ 0\ \
arguments; \ 1\ argument\ is\ \(\(expected\)\(.\)\)\)\)], "Message",
  CellTags->"RasterGraphics::argx"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RasterGraphics::argx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RasterGraphics::rrng", "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::rrng"],

Cell[BoxData[
    \(RasterGraphics::"rrng" \(\(:\)\(\ \)\) \(Value\ of\ option\ `1`\ is\ \
not\ All, \ Automatic, \ 
      or\ an\ appropriate\ range\ \(\(specification\)\(.\)\)\)\)], "Message",
  CellTags->"RasterGraphics::rrng"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RasterGraphics::rrng"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RasterGraphics::optx", "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::optx"],

Cell[BoxData[
    \(RasterGraphics::"optx" \(\(:\)\(\ \)\) \(Unknown\ option\ `1`\ in\ \
\(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"RasterGraphics::optx"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RasterGraphics::optx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RasterGraphics::nonopt", "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::nonopt"],

Cell[BoxData[
    \(RasterGraphics::"nonopt" \(\(:\)\(\ \)\) \(Options\ expected\ \
\((instead\ of\ `2`)\)\ beyond\ position\ 1\ in\ `1` . \ 
          An\ option\ must\ be\ a\ rule\ or\ a\ list\ of\ \
\(\(rules\)\(.\)\)\)\)], "Message",
  CellTags->"RasterGraphics::nonopt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RasterGraphics::nonopt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RasterGraphics::gmat", "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::gmat"],

Cell[BoxData[
    \(RasterGraphics::"gmat" \(\(:\)\(\ \)\) \(`1`\ is\ not\ a\ rectangular\ \
array\ larger\ than\ 2\ x\ 2. \)\)], "Message",
  CellTags->"RasterGraphics::gmat"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RasterGraphics::gmat"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RasterGraphics::zval", "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::zval"],

Cell[BoxData[
    \(RasterGraphics::"zval" \(\(:\)\(\ \)\) \(Non - 
        numerical\ value\ `1`\ found\ at\ position\ `2`\ in\ first\ \
\(\(argument\)\(.\)\)\)\)], "Message",
  CellTags->"RasterGraphics::zval"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RasterGraphics::zval"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{639, 673},
WindowMargins->{{Automatic, 11}, {13, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SurfaceColor::albedo"->{
    Cell[1826, 57, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SurfaceColor::albedo"],
    Cell[1922, 60, 404, 9, 37, "Message",
      CellTags->"SurfaceColor::albedo"],
    Cell[2329, 71, 1223, 49, 84, "Notes",
      CellTags->"SurfaceColor::albedo"],
    Cell[3577, 124, 70, 1, 38, "ExampleSection",
      CellTags->"SurfaceColor::albedo"],
    Cell[3650, 127, 292, 7, 40, "Text",
      CellTags->"SurfaceColor::albedo"],
    Cell[3967, 138, 202, 5, 42, "Input",
      CellTags->"SurfaceColor::albedo"],
    Cell[4172, 145, 299, 6, 53, "Message",
      CellTags->"SurfaceColor::albedo"],
    Cell[4474, 153, 192, 5, 21, "Output",
      CellTags->"SurfaceColor::albedo"]},
  "SurfaceGraphics::clip"->{
    Cell[4727, 165, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SurfaceGraphics::clip"],
    Cell[4825, 168, 334, 6, 37, "Message",
      CellTags->"SurfaceGraphics::clip"],
    Cell[5162, 176, 587, 16, 84, "Notes",
      CellTags->"SurfaceGraphics::clip"],
    Cell[5774, 196, 71, 1, 38, "ExampleSection",
      CellTags->"SurfaceGraphics::clip"],
    Cell[5848, 199, 343, 10, 40, "Text",
      CellTags->"SurfaceGraphics::clip"],
    Cell[6216, 213, 177, 4, 42, "Input",
      CellTags->"SurfaceGraphics::clip"],
    Cell[6396, 219, 260, 5, 53, "Message",
      CellTags->"SurfaceGraphics::clip"],
    Cell[6659, 226, 198, 5, 21, "Output",
      CellTags->"SurfaceGraphics::clip"]},
  "Graphics3D::ltcol"->{
    Cell[6918, 238, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics3D::ltcol"],
    Cell[7008, 241, 429, 10, 37, "Message",
      CellTags->"Graphics3D::ltcol"],
    Cell[7440, 253, 1496, 58, 116, "Notes",
      CellTags->"Graphics3D::ltcol"],
    Cell[8961, 315, 67, 1, 38, "ExampleSection",
      CellTags->"Graphics3D::ltcol"],
    Cell[9031, 318, 202, 5, 24, "Text",
      CellTags->"Graphics3D::ltcol"],
    Cell[9258, 327, 184, 4, 42, "Input",
      CellTags->"Graphics3D::ltcol"],
    Cell[9445, 333, 300, 6, 53, "Message",
      CellTags->"Graphics3D::ltcol"],
    Cell[9748, 341, 286, 6, 53, "Message",
      CellTags->"Graphics3D::ltcol"],
    Cell[10037, 349, 194, 5, 21, "Output",
      CellTags->"Graphics3D::ltcol"],
    Cell[10246, 357, 247, 8, 40, "Text",
      CellTags->"Graphics3D::ltcol"],
    Cell[10518, 369, 191, 4, 42, "Input",
      CellTags->"Graphics3D::ltcol"],
    Cell[10712, 375, 194, 5, 21, "Output",
      CellTags->"Graphics3D::ltcol"]},
  "Raster::rslim"->{
    Cell[10967, 387, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Raster::rslim"],
    Cell[11049, 390, 330, 8, 37, "Message",
      CellTags->"Raster::rslim"],
    Cell[11382, 400, 322, 8, 46, "Notes",
      CellTags->"Raster::rslim"],
    Cell[11729, 412, 63, 1, 38, "ExampleSection",
      CellTags->"Raster::rslim"],
    Cell[11795, 415, 237, 6, 40, "Text",
      CellTags->"Raster::rslim"],
    Cell[12057, 425, 250, 6, 58, "Input",
      CellTags->"Raster::rslim"],
    Cell[12310, 433, 223, 5, 37, "Message",
      CellTags->"Raster::rslim"],
    Cell[12536, 440, 183, 5, 21, "Output",
      CellTags->"Raster::rslim"],
    Cell[12734, 448, 85, 1, 24, "Text",
      CellTags->"Raster::rslim"],
    Cell[12844, 453, 250, 6, 58, "Input",
      CellTags->"Raster::rslim"],
    Cell[13097, 461, 183, 5, 21, "Output",
      CellTags->"Raster::rslim"]},
  "GraphicsArray::arrsp"->{
    Cell[13341, 473, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"GraphicsArray::arrsp"],
    Cell[13437, 476, 334, 6, 37, "Message",
      CellTags->"GraphicsArray::arrsp"],
    Cell[13774, 484, 251, 7, 40, "Notes",
      CellTags->"GraphicsArray::arrsp"],
    Cell[14050, 495, 70, 1, 38, "ExampleSection",
      CellTags->"GraphicsArray::arrsp"],
    Cell[14123, 498, 282, 7, 40, "Text",
      CellTags->"GraphicsArray::arrsp"],
    Cell[14430, 509, 275, 8, 58, "Input",
      CellTags->"GraphicsArray::arrsp"],
    Cell[14708, 519, 265, 5, 53, "Message",
      CellTags->"GraphicsArray::arrsp"],
    Cell[14976, 526, 195, 5, 21, "Output",
      CellTags->"GraphicsArray::arrsp"],
    Cell[15186, 534, 149, 5, 24, "Text",
      CellTags->"GraphicsArray::arrsp"],
    Cell[15360, 543, 270, 8, 58, "Input",
      CellTags->"GraphicsArray::arrsp"],
    Cell[15633, 553, 195, 5, 21, "Output",
      CellTags->"GraphicsArray::arrsp"]},
  "Contours::ctnl"->{
    Cell[15889, 565, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Contours::ctnl"],
    Cell[15973, 568, 294, 6, 37, "Message",
      CellTags->"Contours::ctnl"],
    Cell[16270, 576, 548, 17, 68, "Notes",
      CellTags->"Contours::ctnl"],
    Cell[16843, 597, 64, 1, 38, "ExampleSection",
      CellTags->"Contours::ctnl"],
    Cell[16910, 600, 172, 5, 24, "Text",
      CellTags->"Contours::ctnl"],
    Cell[17107, 609, 160, 4, 26, "Input",
      CellTags->"Contours::ctnl"],
    Cell[17270, 615, 224, 5, 37, "Message",
      CellTags->"Contours::ctnl"],
    Cell[17497, 622, 191, 5, 21, "Output",
      CellTags->"Contours::ctnl"],
    Cell[17703, 630, 138, 4, 24, "Text",
      CellTags->"Contours::ctnl"],
    Cell[17866, 638, 162, 4, 26, "Input",
      CellTags->"Contours::ctnl"],
    Cell[18031, 644, 191, 5, 21, "Output",
      CellTags->"Contours::ctnl"]},
  "General::nlist3"->{
    Cell[18283, 656, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nlist3"],
    Cell[18369, 659, 387, 11, 21, "Message",
      CellTags->"General::nlist3"],
    Cell[18759, 672, 342, 7, 62, "Notes",
      CellTags->"General::nlist3"],
    Cell[19126, 683, 65, 1, 38, "ExampleSection",
      CellTags->"General::nlist3"],
    Cell[19194, 686, 199, 5, 24, "Text",
      CellTags->"General::nlist3"],
    Cell[19418, 695, 150, 4, 26, "Input",
      CellTags->"General::nlist3"],
    Cell[19571, 701, 184, 4, 21, "Message",
      CellTags->"General::nlist3"],
    Cell[19758, 707, 192, 5, 21, "Output",
      CellTags->"General::nlist3"],
    Cell[19965, 715, 185, 6, 24, "Text",
      CellTags->"General::nlist3"],
    Cell[20175, 725, 158, 4, 26, "Input",
      CellTags->"General::nlist3"],
    Cell[20336, 731, 192, 5, 21, "Output",
      CellTags->"General::nlist3"]},
  "ParametricPlot3D::glims"->{
    Cell[20589, 743, 230, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[20822, 753, 534, 15, 37, "Message",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21359, 770, 244, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21628, 780, 144, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21775, 785, 222, 6, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22022, 795, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22231, 802, 310, 7, 37, "Message",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22544, 811, 207, 5, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22766, 819, 205, 7, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22996, 830, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[23205, 837, 271, 7, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}]},
  "ContourPlot::glims"->{
    Cell[20589, 743, 230, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[20822, 753, 534, 15, 37, "Message",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21359, 770, 244, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21628, 780, 144, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21775, 785, 222, 6, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22022, 795, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22231, 802, 310, 7, 37, "Message",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22544, 811, 207, 5, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22766, 819, 205, 7, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22996, 830, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[23205, 837, 271, 7, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}]},
  "DensityPlot::glims"->{
    Cell[20589, 743, 230, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[20822, 753, 534, 15, 37, "Message",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21359, 770, 244, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21628, 780, 144, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21775, 785, 222, 6, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22022, 795, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22231, 802, 310, 7, 37, "Message",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22544, 811, 207, 5, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22766, 819, 205, 7, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22996, 830, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[23205, 837, 271, 7, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}]},
  "Plot3D::glims"->{
    Cell[20589, 743, 230, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[20822, 753, 534, 15, 37, "Message",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21359, 770, 244, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21628, 780, 144, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[21775, 785, 222, 6, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22022, 795, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22231, 802, 310, 7, 37, "Message",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22544, 811, 207, 5, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}],
    Cell[22766, 819, 205, 7, 24, "Text",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[22996, 830, 206, 5, 26, "Input",
      CellTags->{
      "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
        "Plot3D::glims"}],
    Cell[23205, 837, 271, 7, 21, "Output",
      CellTags->{
      "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
        "Plot3D::glims"}]},
  "Graphics::realp"->{
    Cell[23537, 851, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics::realp"],
    Cell[23623, 854, 252, 6, 21, "Message",
      CellTags->"Graphics::realp"],
    Cell[23878, 862, 308, 7, 62, "Notes",
      CellTags->"Graphics::realp"],
    Cell[24211, 873, 65, 1, 38, "ExampleSection",
      CellTags->"Graphics::realp"],
    Cell[24279, 876, 240, 6, 40, "Text",
      CellTags->"Graphics::realp"],
    Cell[24544, 886, 144, 3, 26, "Input",
      CellTags->"Graphics::realp"],
    Cell[24691, 891, 212, 5, 37, "Message",
      CellTags->"Graphics::realp"],
    Cell[24906, 898, 185, 5, 21, "Output",
      CellTags->"Graphics::realp"]},
  "Graphics::realu"->{
    Cell[25152, 910, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics::realu"],
    Cell[25238, 913, 251, 6, 21, "Message",
      CellTags->"Graphics::realu"],
    Cell[25492, 921, 308, 7, 62, "Notes",
      CellTags->"Graphics::realu"],
    Cell[25825, 932, 65, 1, 38, "ExampleSection",
      CellTags->"Graphics::realu"],
    Cell[25893, 935, 230, 6, 40, "Text",
      CellTags->"Graphics::realu"],
    Cell[26148, 945, 134, 3, 26, "Input",
      CellTags->"Graphics::realu"],
    Cell[26285, 950, 209, 5, 37, "Message",
      CellTags->"Graphics::realu"],
    Cell[26497, 957, 185, 5, 21, "Output",
      CellTags->"Graphics::realu"]},
  "MeshStyle::mesh"->{
    Cell[26743, 969, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MeshStyle::mesh"],
    Cell[26829, 972, 251, 5, 37, "Message",
      CellTags->"MeshStyle::mesh"],
    Cell[27083, 979, 477, 10, 84, "Notes",
      CellTags->"MeshStyle::mesh"],
    Cell[27585, 993, 65, 1, 38, "ExampleSection",
      CellTags->"MeshStyle::mesh"],
    Cell[27653, 996, 274, 7, 40, "Text",
      CellTags->"MeshStyle::mesh"],
    Cell[27952, 1007, 171, 4, 42, "Input",
      CellTags->"MeshStyle::mesh"],
    Cell[28126, 1013, 236, 5, 37, "Message",
      CellTags->"MeshStyle::mesh"],
    Cell[28365, 1020, 192, 5, 21, "Output",
      CellTags->"MeshStyle::mesh"],
    Cell[28572, 1028, 140, 5, 24, "Text",
      CellTags->"MeshStyle::mesh"],
    Cell[28737, 1037, 173, 4, 42, "Input",
      CellTags->"MeshStyle::mesh"],
    Cell[28913, 1043, 192, 5, 21, "Output",
      CellTags->"MeshStyle::mesh"]},
  "PlotRange::prng"->{
    Cell[29166, 1055, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PlotRange::prng"],
    Cell[29252, 1058, 330, 7, 37, "Message",
      CellTags->"PlotRange::prng"],
    Cell[29585, 1067, 463, 13, 62, "Notes",
      CellTags->"PlotRange::prng"],
    Cell[30073, 1084, 65, 1, 38, "ExampleSection",
      CellTags->"PlotRange::prng"],
    Cell[30141, 1087, 146, 5, 24, "Text",
      CellTags->"PlotRange::prng"],
    Cell[30312, 1096, 131, 3, 26, "Input",
      CellTags->"PlotRange::prng"],
    Cell[30446, 1101, 247, 5, 53, "Message",
      CellTags->"PlotRange::prng"],
    Cell[30696, 1108, 185, 5, 21, "Output",
      CellTags->"PlotRange::prng"],
    Cell[30896, 1116, 140, 5, 24, "Text",
      CellTags->"PlotRange::prng"],
    Cell[31061, 1125, 136, 3, 26, "Input",
      CellTags->"PlotRange::prng"],
    Cell[31200, 1130, 185, 5, 21, "Output",
      CellTags->"PlotRange::prng"],
    Cell[31400, 1138, 240, 6, 40, "Text",
      CellTags->"PlotRange::prng"],
    Cell[31665, 1148, 167, 4, 26, "Input",
      CellTags->"PlotRange::prng"],
    Cell[31835, 1154, 281, 6, 53, "Message",
      CellTags->"PlotRange::prng"],
    Cell[32119, 1162, 192, 5, 21, "Output",
      CellTags->"PlotRange::prng"],
    Cell[32326, 1170, 205, 6, 24, "Text",
      CellTags->"PlotRange::prng"],
    Cell[32556, 1180, 175, 4, 42, "Input",
      CellTags->"PlotRange::prng"],
    Cell[32734, 1186, 192, 5, 21, "Output",
      CellTags->"PlotRange::prng"]},
  "ViewCenter::viewc"->{
    Cell[32987, 1198, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ViewCenter::viewc"],
    Cell[33077, 1201, 221, 4, 37, "Message",
      CellTags->"ViewCenter::viewc"],
    Cell[33301, 1207, 616, 14, 100, "Notes",
      CellTags->"ViewCenter::viewc"],
    Cell[33942, 1225, 67, 1, 38, "ExampleSection",
      CellTags->"ViewCenter::viewc"],
    Cell[34012, 1228, 232, 7, 40, "Text",
      CellTags->"ViewCenter::viewc"],
    Cell[34269, 1239, 252, 6, 58, "Input",
      CellTags->"ViewCenter::viewc"],
    Cell[34524, 1247, 229, 5, 37, "Message",
      CellTags->"ViewCenter::viewc"],
    Cell[34756, 1254, 258, 5, 53, "Message",
      CellTags->"ViewCenter::viewc"],
    Cell[35017, 1261, 189, 5, 21, "Output",
      CellTags->"ViewCenter::viewc"],
    Cell[35221, 1269, 228, 7, 24, "Text",
      CellTags->"ViewCenter::viewc"],
    Cell[35474, 1280, 269, 6, 58, "Input",
      CellTags->"ViewCenter::viewc"],
    Cell[35746, 1288, 189, 5, 21, "Output",
      CellTags->"ViewCenter::viewc"]},
  "ViewPoint::viewp"->{
    Cell[35996, 1300, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ViewPoint::viewp"],
    Cell[36084, 1303, 208, 4, 37, "Message",
      CellTags->"ViewPoint::viewp"],
    Cell[36295, 1309, 503, 11, 62, "Notes",
      CellTags->"ViewPoint::viewp"],
    Cell[36823, 1324, 66, 1, 38, "ExampleSection",
      CellTags->"ViewPoint::viewp"],
    Cell[36892, 1327, 164, 5, 24, "Text",
      CellTags->"ViewPoint::viewp"],
    Cell[37081, 1336, 201, 6, 42, "Input",
      CellTags->"ViewPoint::viewp"],
    Cell[37285, 1344, 217, 5, 37, "Message",
      CellTags->"ViewPoint::viewp"],
    Cell[37505, 1351, 257, 5, 53, "Message",
      CellTags->"ViewPoint::viewp"],
    Cell[37765, 1358, 188, 5, 21, "Output",
      CellTags->"ViewPoint::viewp"],
    Cell[37968, 1366, 139, 5, 24, "Text",
      CellTags->"ViewPoint::viewp"],
    Cell[38132, 1375, 203, 6, 42, "Input",
      CellTags->"ViewPoint::viewp"],
    Cell[38338, 1383, 188, 5, 21, "Output",
      CellTags->"ViewPoint::viewp"]},
  "SurfaceGraphics::noproj"->{
    Cell[38587, 1395, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[38740, 1401, 374, 8, 37, "Message",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[39117, 1411, 591, 10, 100, "Notes",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[39733, 1425, 97, 1, 38, "ExampleSection",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[39833, 1428, 209, 5, 24, "Text",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[40067, 1437, 190, 4, 26, "Input",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[40260, 1443, 248, 5, 37, "Message",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
    Cell[40511, 1450, 293, 5, 53, "Message",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
    Cell[40807, 1457, 224, 5, 21, "Output",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
    Cell[41046, 1465, 170, 5, 24, "Text",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[41241, 1474, 190, 4, 26, "Input",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[41434, 1480, 224, 5, 21, "Output",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}]},
  "Graphics3D::noproj"->{
    Cell[38587, 1395, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[38740, 1401, 374, 8, 37, "Message",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[39117, 1411, 591, 10, 100, "Notes",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[39733, 1425, 97, 1, 38, "ExampleSection",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[39833, 1428, 209, 5, 24, "Text",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[40067, 1437, 190, 4, 26, "Input",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[40260, 1443, 248, 5, 37, "Message",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
    Cell[40511, 1450, 293, 5, 53, "Message",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
    Cell[40807, 1457, 224, 5, 21, "Output",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
    Cell[41046, 1465, 170, 5, 24, "Text",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[41241, 1474, 190, 4, 26, "Input",
      CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
    Cell[41434, 1480, 224, 5, 21, "Output",
      CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}]},
  "Graphics3D::gsing"->{
    Cell[41719, 1492, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[41850, 1498, 273, 7, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[42126, 1507, 674, 14, 100, "Notes",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[42825, 1525, 86, 1, 38, "ExampleSection",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[42914, 1528, 227, 7, 24, "Text",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43166, 1539, 255, 6, 58, "Input",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43424, 1547, 207, 4, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43634, 1553, 207, 4, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43844, 1559, 207, 4, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44054, 1565, 250, 5, 37, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44307, 1572, 206, 5, 21, "Output",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44528, 1580, 260, 7, 40, "Text",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44813, 1591, 255, 6, 58, "Input",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[45071, 1599, 206, 5, 21, "Output",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}]},
  "Plot3D::gsing"->{
    Cell[41719, 1492, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[41850, 1498, 273, 7, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[42126, 1507, 674, 14, 100, "Notes",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[42825, 1525, 86, 1, 38, "ExampleSection",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[42914, 1528, 227, 7, 24, "Text",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43166, 1539, 255, 6, 58, "Input",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43424, 1547, 207, 4, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43634, 1553, 207, 4, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[43844, 1559, 207, 4, 21, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44054, 1565, 250, 5, 37, "Message",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44307, 1572, 206, 5, 21, "Output",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44528, 1580, 260, 7, 40, "Text",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[44813, 1591, 255, 6, 58, "Input",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
    Cell[45071, 1599, 206, 5, 21, "Output",
      CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}]},
  "PlotRegion::plotr"->{
    Cell[45338, 1611, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PlotRegion::plotr"],
    Cell[45428, 1614, 336, 6, 37, "Message",
      CellTags->"PlotRegion::plotr"],
    Cell[45767, 1622, 413, 9, 62, "Notes",
      CellTags->"PlotRegion::plotr"],
    Cell[46205, 1635, 67, 1, 38, "ExampleSection",
      CellTags->"PlotRegion::plotr"],
    Cell[46275, 1638, 359, 8, 56, "Text",
      CellTags->"PlotRegion::plotr"],
    Cell[46659, 1650, 271, 7, 58, "Input",
      CellTags->"PlotRegion::plotr"],
    Cell[46933, 1659, 295, 6, 53, "Message",
      CellTags->"PlotRegion::plotr"],
    Cell[47231, 1667, 187, 5, 21, "Output",
      CellTags->"PlotRegion::plotr"],
    Cell[47433, 1675, 141, 5, 24, "Text",
      CellTags->"PlotRegion::plotr"],
    Cell[47599, 1684, 271, 7, 58, "Input",
      CellTags->"PlotRegion::plotr"],
    Cell[47873, 1693, 187, 5, 21, "Output",
      CellTags->"PlotRegion::plotr"]},
  "ViewVertical::viewv"->{
    Cell[48121, 1705, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ViewVertical::viewv"],
    Cell[48215, 1708, 272, 5, 37, "Message",
      CellTags->"ViewVertical::viewv"],
    Cell[48490, 1715, 608, 14, 84, "Notes",
      CellTags->"ViewVertical::viewv"],
    Cell[49123, 1733, 69, 1, 38, "ExampleSection",
      CellTags->"ViewVertical::viewv"],
    Cell[49195, 1736, 348, 9, 40, "Text",
      CellTags->"ViewVertical::viewv"],
    Cell[49568, 1749, 274, 7, 58, "Input",
      CellTags->"ViewVertical::viewv"],
    Cell[49845, 1758, 264, 5, 53, "Message",
      CellTags->"ViewVertical::viewv"],
    Cell[50112, 1765, 260, 5, 53, "Message",
      CellTags->"ViewVertical::viewv"],
    Cell[50375, 1772, 191, 5, 21, "Output",
      CellTags->"ViewVertical::viewv"]},
  "AspectRatio::aspr"->{
    Cell[50627, 1784, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"AspectRatio::aspr"],
    Cell[50717, 1787, 299, 6, 37, "Message",
      CellTags->"AspectRatio::aspr"],
    Cell[51019, 1795, 198, 5, 24, "Notes",
      CellTags->"AspectRatio::aspr"],
    Cell[51242, 1804, 67, 1, 38, "ExampleSection",
      CellTags->"AspectRatio::aspr"],
    Cell[51312, 1807, 225, 6, 40, "Text",
      CellTags->"AspectRatio::aspr"],
    Cell[51562, 1817, 137, 3, 26, "Input",
      CellTags->"AspectRatio::aspr"],
    Cell[51702, 1822, 230, 5, 37, "Message",
      CellTags->"AspectRatio::aspr"],
    Cell[51935, 1829, 187, 5, 21, "Output",
      CellTags->"AspectRatio::aspr"]},
  "Axes::axes"->{
    Cell[52183, 1841, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Axes::axes"],
    Cell[52259, 1844, 208, 5, 21, "Message",
      CellTags->"Axes::axes"],
    Cell[52470, 1851, 447, 16, 46, "Notes",
      CellTags->"Axes::axes"],
    Cell[52942, 1871, 60, 1, 38, "ExampleSection",
      CellTags->"Axes::axes"],
    Cell[53005, 1874, 221, 6, 40, "Text",
      CellTags->"Axes::axes"],
    Cell[53251, 1884, 128, 3, 26, "Input",
      CellTags->"Axes::axes"],
    Cell[53382, 1889, 175, 4, 21, "Message",
      CellTags->"Axes::axes"],
    Cell[53560, 1895, 175, 4, 21, "Message",
      CellTags->"Axes::axes"],
    Cell[53738, 1901, 180, 5, 21, "Output",
      CellTags->"Axes::axes"],
    Cell[53933, 1909, 121, 4, 24, "Text",
      CellTags->"Axes::axes"],
    Cell[54079, 1917, 135, 3, 26, "Input",
      CellTags->"Axes::axes"],
    Cell[54217, 1922, 180, 5, 21, "Output",
      CellTags->"Axes::axes"]},
  "AxesEdge::axedg"->{
    Cell[54458, 1934, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"AxesEdge::axedg"],
    Cell[54544, 1937, 224, 5, 21, "Message",
      CellTags->"AxesEdge::axedg"],
    Cell[54771, 1944, 772, 26, 84, "Notes",
      CellTags->"AxesEdge::axedg"],
    Cell[55568, 1974, 65, 1, 38, "ExampleSection",
      CellTags->"AxesEdge::axedg"],
    Cell[55636, 1977, 257, 6, 40, "Text",
      CellTags->"AxesEdge::axedg"],
    Cell[55918, 1987, 163, 4, 26, "Input",
      CellTags->"AxesEdge::axedg"],
    Cell[56084, 1993, 190, 4, 21, "Message",
      CellTags->"AxesEdge::axedg"],
    Cell[56277, 1999, 190, 4, 21, "Message",
      CellTags->"AxesEdge::axedg"],
    Cell[56470, 2005, 192, 5, 21, "Output",
      CellTags->"AxesEdge::axedg"],
    Cell[56677, 2013, 139, 5, 24, "Text",
      CellTags->"AxesEdge::axedg"],
    Cell[56841, 2022, 163, 4, 26, "Input",
      CellTags->"AxesEdge::axedg"],
    Cell[57007, 2028, 192, 5, 21, "Output",
      CellTags->"AxesEdge::axedg"]},
  "ParametricPlot::pldiv"->{
    Cell[57260, 2040, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[57395, 2046, 506, 14, 37, "Message",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[57904, 2062, 220, 5, 24, "Notes",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58149, 2071, 88, 1, 38, "ExampleSection",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58240, 2074, 195, 6, 24, "Text",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58460, 2084, 165, 3, 26, "Input",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58628, 2089, 241, 5, 37, "Message",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58872, 2096, 181, 4, 21, "Output",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[59068, 2103, 167, 5, 24, "Text",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[59260, 2112, 181, 4, 26, "Input",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[59444, 2118, 208, 5, 21, "Output",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}]},
  "Plot::pldiv"->{
    Cell[57260, 2040, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[57395, 2046, 506, 14, 37, "Message",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[57904, 2062, 220, 5, 24, "Notes",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58149, 2071, 88, 1, 38, "ExampleSection",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58240, 2074, 195, 6, 24, "Text",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58460, 2084, 165, 3, 26, "Input",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58628, 2089, 241, 5, 37, "Message",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[58872, 2096, 181, 4, 21, "Output",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[59068, 2103, 167, 5, 24, "Text",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[59260, 2112, 181, 4, 26, "Input",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
    Cell[59444, 2118, 208, 5, 21, "Output",
      CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}]},
  "GridLines::grid"->{
    Cell[59713, 2130, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"GridLines::grid"],
    Cell[59799, 2133, 218, 5, 21, "Message",
      CellTags->"GridLines::grid"],
    Cell[60020, 2140, 1162, 34, 138, "Notes",
      CellTags->"GridLines::grid"],
    Cell[61207, 2178, 65, 1, 38, "ExampleSection",
      CellTags->"GridLines::grid"],
    Cell[61275, 2181, 274, 7, 40, "Text",
      CellTags->"GridLines::grid"],
    Cell[61574, 2192, 170, 4, 42, "Input",
      CellTags->"GridLines::grid"],
    Cell[61747, 2198, 235, 5, 37, "Message",
      CellTags->"GridLines::grid"],
    Cell[61985, 2205, 185, 5, 21, "Output",
      CellTags->"GridLines::grid"],
    Cell[62185, 2213, 171, 5, 24, "Text",
      CellTags->"GridLines::grid"],
    Cell[62381, 2222, 172, 4, 42, "Input",
      CellTags->"GridLines::grid"],
    Cell[62556, 2228, 185, 5, 21, "Output",
      CellTags->"GridLines::grid"]},
  "Circle::angle"->{
    Cell[62802, 2240, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Circle::angle"],
    Cell[62884, 2243, 316, 6, 37, "Message",
      CellTags->"Circle::angle"],
    Cell[63203, 2251, 236, 6, 40, "Notes",
      CellTags->"Circle::angle"],
    Cell[63464, 2261, 63, 1, 38, "ExampleSection",
      CellTags->"Circle::angle"],
    Cell[63530, 2264, 190, 5, 24, "Text",
      CellTags->"Circle::angle"],
    Cell[63745, 2273, 181, 5, 26, "Input",
      CellTags->"Circle::angle"],
    Cell[63929, 2280, 215, 5, 37, "Message",
      CellTags->"Circle::angle"],
    Cell[64147, 2287, 183, 5, 21, "Output",
      CellTags->"Circle::angle"],
    Cell[64345, 2295, 122, 5, 24, "Text",
      CellTags->"Circle::angle"],
    Cell[64492, 2304, 197, 5, 42, "Input",
      CellTags->"Circle::angle"],
    Cell[64692, 2311, 183, 5, 21, "Output",
      CellTags->"Circle::angle"]},
  "Disk::angle"->{
    Cell[64936, 2323, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Disk::angle"],
    Cell[65014, 2326, 312, 6, 37, "Message",
      CellTags->"Disk::angle"],
    Cell[65329, 2334, 232, 6, 40, "Notes",
      CellTags->"Disk::angle"],
    Cell[65586, 2344, 61, 1, 38, "ExampleSection",
      CellTags->"Disk::angle"],
    Cell[65650, 2347, 186, 5, 24, "Text",
      CellTags->"Disk::angle"],
    Cell[65861, 2356, 177, 5, 26, "Input",
      CellTags->"Disk::angle"],
    Cell[66041, 2363, 211, 5, 37, "Message",
      CellTags->"Disk::angle"],
    Cell[66255, 2370, 181, 5, 21, "Output",
      CellTags->"Disk::angle"],
    Cell[66451, 2378, 118, 5, 24, "Text",
      CellTags->"Disk::angle"],
    Cell[66594, 2387, 193, 5, 42, "Input",
      CellTags->"Disk::angle"],
    Cell[66790, 2394, 181, 5, 21, "Output",
      CellTags->"Disk::angle"]},
  "Circle::radius"->{
    Cell[67032, 2406, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Circle::radius"],
    Cell[67116, 2409, 264, 5, 37, "Message",
      CellTags->"Circle::radius"],
    Cell[67383, 2416, 190, 5, 24, "Notes",
      CellTags->"Circle::radius"],
    Cell[67598, 2425, 64, 1, 38, "ExampleSection",
      CellTags->"Circle::radius"],
    Cell[67665, 2428, 179, 5, 24, "Text",
      CellTags->"Circle::radius"],
    Cell[67869, 2437, 179, 5, 26, "Input",
      CellTags->"Circle::radius"],
    Cell[68051, 2444, 209, 5, 37, "Message",
      CellTags->"Circle::radius"],
    Cell[68263, 2451, 184, 5, 21, "Output",
      CellTags->"Circle::radius"],
    Cell[68462, 2459, 127, 5, 24, "Text",
      CellTags->"Circle::radius"],
    Cell[68614, 2468, 190, 5, 42, "Input",
      CellTags->"Circle::radius"],
    Cell[68807, 2475, 184, 5, 21, "Output",
      CellTags->"Circle::radius"]},
  "Disk::radius"->{
    Cell[69052, 2487, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Disk::radius"],
    Cell[69132, 2490, 260, 5, 21, "Message",
      CellTags->"Disk::radius"],
    Cell[69395, 2497, 186, 5, 24, "Notes",
      CellTags->"Disk::radius"],
    Cell[69606, 2506, 62, 1, 38, "ExampleSection",
      CellTags->"Disk::radius"],
    Cell[69671, 2509, 175, 5, 24, "Text",
      CellTags->"Disk::radius"],
    Cell[69871, 2518, 175, 5, 26, "Input",
      CellTags->"Disk::radius"],
    Cell[70049, 2525, 205, 5, 37, "Message",
      CellTags->"Disk::radius"],
    Cell[70257, 2532, 182, 5, 21, "Output",
      CellTags->"Disk::radius"],
    Cell[70454, 2540, 123, 5, 24, "Text",
      CellTags->"Disk::radius"],
    Cell[70602, 2549, 188, 5, 42, "Input",
      CellTags->"Disk::radius"],
    Cell[70793, 2556, 182, 5, 21, "Output",
      CellTags->"Disk::radius"]},
  "ColorOutput::colpn"->{
    Cell[71036, 2568, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[71171, 2574, 653, 16, 37, "Message",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[71827, 2592, 224, 5, 40, "Notes",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72076, 2601, 88, 1, 38, "ExampleSection",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72167, 2604, 268, 6, 40, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72460, 2614, 192, 4, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72655, 2620, 367, 6, 69, "Message",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73025, 2628, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73248, 2636, 166, 5, 24, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73439, 2645, 201, 4, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73643, 2651, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73866, 2659, 178, 5, 24, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74069, 2668, 159, 3, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74231, 2673, 397, 7, 69, "Message",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74631, 2682, 126, 3, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74772, 2688, 152, 5, 24, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74949, 2697, 168, 3, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[75120, 2702, 142, 3, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]},
  "ToColor::colpn"->{
    Cell[71036, 2568, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[71171, 2574, 653, 16, 37, "Message",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[71827, 2592, 224, 5, 40, "Notes",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72076, 2601, 88, 1, 38, "ExampleSection",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72167, 2604, 268, 6, 40, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72460, 2614, 192, 4, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[72655, 2620, 367, 6, 69, "Message",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73025, 2628, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73248, 2636, 166, 5, 24, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73439, 2645, 201, 4, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73643, 2651, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[73866, 2659, 178, 5, 24, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74069, 2668, 159, 3, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74231, 2673, 397, 7, 69, "Message",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74631, 2682, 126, 3, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74772, 2688, 152, 5, 24, "Text",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[74949, 2697, 168, 3, 26, "Input",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
    Cell[75120, 2702, 142, 3, 21, "Output",
      CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]},
  "ContourGraphics::ctpnt"->{
    Cell[75323, 2712, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[75423, 2715, 292, 5, 37, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[75718, 2722, 640, 13, 100, "Notes",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[76383, 2739, 72, 1, 38, "ExampleSection",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[76458, 2742, 217, 6, 40, "Text",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[76700, 2752, 268, 6, 90, "Input",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[76971, 2760, 281, 5, 53, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[77255, 2767, 281, 5, 53, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[77539, 2774, 281, 5, 53, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[77823, 2781, 241, 5, 37, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[78067, 2788, 192, 5, 21, "Output",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[78274, 2796, 277, 6, 40, "Text",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[78576, 2806, 141, 3, 26, "Input",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[78720, 2811, 260, 5, 53, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[78983, 2818, 281, 5, 53, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[79267, 2825, 281, 5, 53, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[79551, 2832, 281, 5, 53, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[79835, 2839, 241, 5, 37, "Message",
      CellTags->"ContourGraphics::ctpnt"],
    Cell[80079, 2846, 199, 5, 21, "Output",
      CellTags->"ContourGraphics::ctpnt"]},
  "ContourGraphics::ctsm"->{
    Cell[80339, 2858, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContourGraphics::ctsm"],
    Cell[80437, 2861, 258, 4, 37, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[80698, 2867, 927, 19, 144, "Notes",
      CellTags->"ContourGraphics::ctsm"],
    Cell[81650, 2890, 71, 1, 38, "ExampleSection",
      CellTags->"ContourGraphics::ctsm"],
    Cell[81724, 2893, 236, 6, 40, "Text",
      CellTags->"ContourGraphics::ctsm"],
    Cell[81985, 2903, 233, 5, 90, "Input",
      CellTags->"ContourGraphics::ctsm"],
    Cell[82221, 2910, 259, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[82483, 2917, 280, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[82766, 2924, 280, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[83049, 2931, 280, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[83332, 2938, 240, 5, 37, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[83575, 2945, 191, 5, 21, "Output",
      CellTags->"ContourGraphics::ctsm"],
    Cell[83781, 2953, 236, 6, 40, "Text",
      CellTags->"ContourGraphics::ctsm"],
    Cell[84042, 2963, 142, 3, 26, "Input",
      CellTags->"ContourGraphics::ctsm"],
    Cell[84187, 2968, 259, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[84449, 2975, 280, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[84732, 2982, 280, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[85015, 2989, 280, 5, 53, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[85298, 2996, 240, 5, 37, "Message",
      CellTags->"ContourGraphics::ctsm"],
    Cell[85541, 3003, 198, 5, 21, "Output",
      CellTags->"ContourGraphics::ctsm"]},
  "ContourGraphics::gmat"->{
    Cell[85800, 3015, 202, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[86005, 3023, 483, 13, 21, "Message",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[86491, 3038, 640, 17, 78, "Notes",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87156, 3059, 126, 2, 38, "ExampleSection",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87285, 3063, 260, 6, 24, "Text",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87570, 3073, 190, 4, 26, "Input",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87763, 3079, 277, 6, 37, "Message",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88043, 3087, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88311, 3096, 198, 6, 24, "Text",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88534, 3106, 194, 4, 26, "Input",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88731, 3112, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}]},
  "DensityGraphics::gmat"->{
    Cell[85800, 3015, 202, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[86005, 3023, 483, 13, 21, "Message",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[86491, 3038, 640, 17, 78, "Notes",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87156, 3059, 126, 2, 38, "ExampleSection",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87285, 3063, 260, 6, 24, "Text",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87570, 3073, 190, 4, 26, "Input",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87763, 3079, 277, 6, 37, "Message",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88043, 3087, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88311, 3096, 198, 6, 24, "Text",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88534, 3106, 194, 4, 26, "Input",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88731, 3112, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}]},
  "SurfaceGraphics::gmat"->{
    Cell[85800, 3015, 202, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[86005, 3023, 483, 13, 21, "Message",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[86491, 3038, 640, 17, 78, "Notes",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87156, 3059, 126, 2, 38, "ExampleSection",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87285, 3063, 260, 6, 24, "Text",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87570, 3073, 190, 4, 26, "Input",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[87763, 3079, 277, 6, 37, "Message",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88043, 3087, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88311, 3096, 198, 6, 24, "Text",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88534, 3106, 194, 4, 26, "Input",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}],
    Cell[88731, 3112, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::gmat", "DensityGraphics::gmat", 
        "SurfaceGraphics::gmat"}]},
  "ContourGraphics::meshr"->{
    Cell[89045, 3125, 213, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[89261, 3134, 563, 16, 37, "Message",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[89827, 3152, 792, 21, 100, "Notes",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[90644, 3177, 134, 3, 38, "ExampleSection",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[90781, 3182, 277, 7, 40, "Text",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91083, 3193, 304, 7, 90, "Input",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91390, 3202, 306, 7, 37, "Message",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91699, 3211, 261, 7, 21, "Output",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91975, 3221, 210, 7, 24, "Text",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[92210, 3232, 323, 8, 90, "Input",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[92536, 3242, 261, 7, 21, "Output",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}]},
  "DensityGraphics::meshr"->{
    Cell[89045, 3125, 213, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[89261, 3134, 563, 16, 37, "Message",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[89827, 3152, 792, 21, 100, "Notes",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[90644, 3177, 134, 3, 38, "ExampleSection",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[90781, 3182, 277, 7, 40, "Text",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91083, 3193, 304, 7, 90, "Input",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91390, 3202, 306, 7, 37, "Message",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91699, 3211, 261, 7, 21, "Output",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91975, 3221, 210, 7, 24, "Text",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[92210, 3232, 323, 8, 90, "Input",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[92536, 3242, 261, 7, 21, "Output",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}]},
  "SurfaceGraphics::meshr"->{
    Cell[89045, 3125, 213, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[89261, 3134, 563, 16, 37, "Message",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[89827, 3152, 792, 21, 100, "Notes",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[90644, 3177, 134, 3, 38, "ExampleSection",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[90781, 3182, 277, 7, 40, "Text",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91083, 3193, 304, 7, 90, "Input",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91390, 3202, 306, 7, 37, "Message",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91699, 3211, 261, 7, 21, "Output",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[91975, 3221, 210, 7, 24, "Text",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[92210, 3232, 323, 8, 90, "Input",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}],
    Cell[92536, 3242, 261, 7, 21, "Output",
      CellTags->{
      "ContourGraphics::meshr", "DensityGraphics::meshr", 
        "SurfaceGraphics::meshr"}]},
  "ContourPlot::pllim"->{
    Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93192, 3269, 547, 13, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93742, 3284, 284, 6, 24, "Notes",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94051, 3294, 199, 3, 38, "ExampleSection",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94253, 3299, 370, 8, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94648, 3311, 237, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94888, 3318, 333, 7, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95224, 3327, 238, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95477, 3335, 260, 7, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[95762, 3346, 245, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96010, 3353, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[96344, 3363, 339, 7, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96708, 3374, 280, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96991, 3381, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97330, 3390, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97669, 3399, 248, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97932, 3407, 368, 9, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98325, 3420, 297, 6, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98625, 3428, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}]},
  "DensityPlot::pllim"->{
    Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93192, 3269, 547, 13, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93742, 3284, 284, 6, 24, "Notes",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94051, 3294, 199, 3, 38, "ExampleSection",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94253, 3299, 370, 8, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94648, 3311, 237, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94888, 3318, 333, 7, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95224, 3327, 238, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95477, 3335, 260, 7, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[95762, 3346, 245, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96010, 3353, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[96344, 3363, 339, 7, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96708, 3374, 280, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96991, 3381, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97330, 3390, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97669, 3399, 248, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97932, 3407, 368, 9, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98325, 3420, 297, 6, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98625, 3428, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}]},
  "ParametricPlot::pllim"->{
    Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93192, 3269, 547, 13, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93742, 3284, 284, 6, 24, "Notes",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94051, 3294, 199, 3, 38, "ExampleSection",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94253, 3299, 370, 8, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94648, 3311, 237, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94888, 3318, 333, 7, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95224, 3327, 238, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95477, 3335, 260, 7, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[95762, 3346, 245, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96010, 3353, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[96344, 3363, 339, 7, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96708, 3374, 280, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96991, 3381, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97330, 3390, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97669, 3399, 248, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97932, 3407, 368, 9, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98325, 3420, 297, 6, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98625, 3428, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}]},
  "Plot3D::pllim"->{
    Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93192, 3269, 547, 13, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93742, 3284, 284, 6, 24, "Notes",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94051, 3294, 199, 3, 38, "ExampleSection",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94253, 3299, 370, 8, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94648, 3311, 237, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94888, 3318, 333, 7, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95224, 3327, 238, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95477, 3335, 260, 7, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[95762, 3346, 245, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96010, 3353, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[96344, 3363, 339, 7, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96708, 3374, 280, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96991, 3381, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97330, 3390, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97669, 3399, 248, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97932, 3407, 368, 9, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98325, 3420, 297, 6, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98625, 3428, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}]},
  "Plot::pllim"->{
    Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93192, 3269, 547, 13, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93742, 3284, 284, 6, 24, "Notes",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94051, 3294, 199, 3, 38, "ExampleSection",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94253, 3299, 370, 8, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94648, 3311, 237, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94888, 3318, 333, 7, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95224, 3327, 238, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95477, 3335, 260, 7, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[95762, 3346, 245, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96010, 3353, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[96344, 3363, 339, 7, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96708, 3374, 280, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96991, 3381, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97330, 3390, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97669, 3399, 248, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97932, 3407, 368, 9, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98325, 3420, 297, 6, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98625, 3428, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}]},
  "ParametricPlot3D::pllim"->{
    Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93192, 3269, 547, 13, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93742, 3284, 284, 6, 24, "Notes",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94051, 3294, 199, 3, 38, "ExampleSection",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94253, 3299, 370, 8, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94648, 3311, 237, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94888, 3318, 333, 7, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95224, 3327, 238, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95477, 3335, 260, 7, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[95762, 3346, 245, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96010, 3353, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[96344, 3363, 339, 7, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96708, 3374, 280, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96991, 3381, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97330, 3390, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97669, 3399, 248, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97932, 3407, 368, 9, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98325, 3420, 297, 6, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98625, 3428, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}]},
  "Play::pllim"->{
    Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93192, 3269, 547, 13, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[93742, 3284, 284, 6, 24, "Notes",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94051, 3294, 199, 3, 38, "ExampleSection",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94253, 3299, 370, 8, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94648, 3311, 237, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[94888, 3318, 333, 7, 21, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95224, 3327, 238, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[95477, 3335, 260, 7, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[95762, 3346, 245, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96010, 3353, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[96344, 3363, 339, 7, 40, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96708, 3374, 280, 5, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[96991, 3381, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97330, 3390, 336, 7, 37, "Message",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97669, 3399, 248, 5, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}],
    Cell[97932, 3407, 368, 9, 24, "Text",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98325, 3420, 297, 6, 26, "Input",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
        "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
        "Play::pllim"}],
    Cell[98625, 3428, 319, 7, 21, "Output",
      CellTags->{
      "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
        "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", 
        "Plot::pllim"}]},
  "Play::plx"->{
    Cell[99005, 3442, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Play::plx"],
    Cell[99079, 3445, 253, 6, 21, "Message",
      CellTags->"Play::plx"],
    Cell[99335, 3453, 176, 5, 24, "Notes",
      CellTags->"Play::plx"],
    Cell[99536, 3462, 59, 1, 38, "ExampleSection",
      CellTags->"Play::plx"],
    Cell[99598, 3465, 169, 5, 24, "Text",
      CellTags->"Play::plx"],
    Cell[99792, 3474, 101, 3, 26, "Input",
      CellTags->"Play::plx"],
    Cell[99896, 3479, 191, 5, 21, "Message",
      CellTags->"Play::plx"],
    Cell[100090, 3486, 102, 3, 21, "Output",
      CellTags->"Play::plx"],
    Cell[100207, 3492, 120, 5, 24, "Text",
      CellTags->"Play::plx"],
    Cell[100352, 3501, 110, 3, 26, "Input",
      CellTags->"Play::plx"],
    Cell[100465, 3506, 176, 5, 21, "Output",
      CellTags->"Play::plx"]},
  "ContourPlot::plnr"->{
    Cell[100702, 3518, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[100866, 3525, 627, 18, 21, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[101496, 3545, 882, 20, 116, "Notes",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102403, 3569, 104, 1, 38, "ExampleSection",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102510, 3572, 234, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102769, 3581, 156, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102928, 3586, 274, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103205, 3593, 272, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103480, 3600, 272, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103755, 3607, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104019, 3614, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104258, 3622, 204, 4, 24, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104487, 3630, 179, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104669, 3635, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104908, 3643, 294, 7, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105227, 3654, 182, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105412, 3659, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105676, 3666, 259, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105938, 3673, 258, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106199, 3680, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106463, 3687, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106702, 3695, 279, 7, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107006, 3706, 199, 4, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107208, 3712, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107447, 3720, 233, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107705, 3729, 160, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107868, 3734, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108136, 3741, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108404, 3748, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108672, 3755, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108936, 3762, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109175, 3770, 276, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109476, 3779, 161, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109640, 3784, 220, 4, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109875, 3791, 284, 6, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[110184, 3801, 174, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[110361, 3806, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]},
  "DensityPlot::plnr"->{
    Cell[100702, 3518, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[100866, 3525, 627, 18, 21, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[101496, 3545, 882, 20, 116, "Notes",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102403, 3569, 104, 1, 38, "ExampleSection",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102510, 3572, 234, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102769, 3581, 156, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102928, 3586, 274, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103205, 3593, 272, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103480, 3600, 272, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103755, 3607, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104019, 3614, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104258, 3622, 204, 4, 24, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104487, 3630, 179, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104669, 3635, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104908, 3643, 294, 7, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105227, 3654, 182, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105412, 3659, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105676, 3666, 259, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105938, 3673, 258, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106199, 3680, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106463, 3687, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106702, 3695, 279, 7, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107006, 3706, 199, 4, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107208, 3712, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107447, 3720, 233, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107705, 3729, 160, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107868, 3734, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108136, 3741, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108404, 3748, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108672, 3755, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108936, 3762, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109175, 3770, 276, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109476, 3779, 161, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109640, 3784, 220, 4, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109875, 3791, 284, 6, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[110184, 3801, 174, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[110361, 3806, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]},
  "Plot::plnr"->{
    Cell[100702, 3518, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[100866, 3525, 627, 18, 21, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[101496, 3545, 882, 20, 116, "Notes",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102403, 3569, 104, 1, 38, "ExampleSection",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102510, 3572, 234, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102769, 3581, 156, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[102928, 3586, 274, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103205, 3593, 272, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103480, 3600, 272, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[103755, 3607, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104019, 3614, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104258, 3622, 204, 4, 24, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104487, 3630, 179, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104669, 3635, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[104908, 3643, 294, 7, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105227, 3654, 182, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105412, 3659, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105676, 3666, 259, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[105938, 3673, 258, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106199, 3680, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106463, 3687, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[106702, 3695, 279, 7, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107006, 3706, 199, 4, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107208, 3712, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107447, 3720, 233, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107705, 3729, 160, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[107868, 3734, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108136, 3741, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108404, 3748, 265, 5, 23, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108672, 3755, 261, 5, 37, "Message",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[108936, 3762, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109175, 3770, 276, 5, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109476, 3779, 161, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109640, 3784, 220, 4, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[109875, 3791, 284, 6, 40, "Text",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[110184, 3801, 174, 3, 26, "Input",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
    Cell[110361, 3806, 224, 5, 21, "Output",
      CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]},
  "ContourPlot::pptt"->{
    Cell[110646, 3818, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[110814, 3825, 571, 16, 37, "Message",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[111388, 3843, 598, 15, 78, "Notes",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112011, 3862, 106, 1, 38, "ExampleSection",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112120, 3865, 300, 9, 40, "Text",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112445, 3878, 200, 4, 26, "Input",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112648, 3884, 283, 5, 37, "Message",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112934, 3891, 206, 4, 21, "Output",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113155, 3898, 226, 7, 24, "Text",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113406, 3909, 197, 4, 26, "Input",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113606, 3915, 233, 5, 21, "Output",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}]},
  "DensityPlot::pptt"->{
    Cell[110646, 3818, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[110814, 3825, 571, 16, 37, "Message",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[111388, 3843, 598, 15, 78, "Notes",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112011, 3862, 106, 1, 38, "ExampleSection",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112120, 3865, 300, 9, 40, "Text",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112445, 3878, 200, 4, 26, "Input",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112648, 3884, 283, 5, 37, "Message",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112934, 3891, 206, 4, 21, "Output",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113155, 3898, 226, 7, 24, "Text",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113406, 3909, 197, 4, 26, "Input",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113606, 3915, 233, 5, 21, "Output",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}]},
  "Plot3D::pptt"->{
    Cell[110646, 3818, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[110814, 3825, 571, 16, 37, "Message",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[111388, 3843, 598, 15, 78, "Notes",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112011, 3862, 106, 1, 38, "ExampleSection",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112120, 3865, 300, 9, 40, "Text",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112445, 3878, 200, 4, 26, "Input",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112648, 3884, 283, 5, 37, "Message",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[112934, 3891, 206, 4, 21, "Output",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113155, 3898, 226, 7, 24, "Text",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113406, 3909, 197, 4, 26, "Input",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
    Cell[113606, 3915, 233, 5, 21, "Output",
      CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}]},
  "ContourSmoothing::ctnsm"->{
    Cell[113900, 3927, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContourSmoothing::ctnsm"],
    Cell[114002, 3930, 317, 6, 37, "Message",
      CellTags->"ContourSmoothing::ctnsm"],
    Cell[114322, 3938, 209, 5, 24, "Notes",
      CellTags->"ContourSmoothing::ctnsm"],
    Cell[114556, 3947, 73, 1, 38, "ExampleSection",
      CellTags->"ContourSmoothing::ctnsm"],
    Cell[114632, 3950, 224, 7, 24, "Text",
      CellTags->"ContourSmoothing::ctnsm"],
    Cell[114881, 3961, 202, 4, 42, "Input",
      CellTags->"ContourSmoothing::ctnsm"],
    Cell[115086, 3967, 241, 5, 37, "Message",
      CellTags->"ContourSmoothing::ctnsm"],
    Cell[115330, 3974, 200, 5, 21, "Output",
      CellTags->"ContourSmoothing::ctnsm"]},
  "Dashing::dshn"->{
    Cell[115591, 3986, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[115730, 3992, 415, 11, 21, "Message",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[116148, 4005, 593, 13, 100, "Notes",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[116766, 4022, 90, 1, 38, "ExampleSection",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[116859, 4025, 314, 6, 40, "Text",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[117198, 4035, 288, 6, 42, "Input",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[117489, 4043, 221, 5, 21, "Message",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
    Cell[117713, 4050, 221, 5, 21, "Message",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
    Cell[117937, 4057, 217, 5, 21, "Output",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
    Cell[118169, 4065, 194, 5, 24, "Text",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[118388, 4074, 292, 6, 58, "Input",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[118683, 4082, 217, 5, 21, "Output",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}]},
  "AbsoluteDashing::dshn"->{
    Cell[115591, 3986, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[115730, 3992, 415, 11, 21, "Message",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[116148, 4005, 593, 13, 100, "Notes",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[116766, 4022, 90, 1, 38, "ExampleSection",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[116859, 4025, 314, 6, 40, "Text",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[117198, 4035, 288, 6, 42, "Input",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[117489, 4043, 221, 5, 21, "Message",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
    Cell[117713, 4050, 221, 5, 21, "Message",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
    Cell[117937, 4057, 217, 5, 21, "Output",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
    Cell[118169, 4065, 194, 5, 24, "Text",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[118388, 4074, 292, 6, 58, "Input",
      CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
    Cell[118683, 4082, 217, 5, 21, "Output",
      CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}]},
  "DefaultFont::dfont"->{
    Cell[118961, 4094, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DefaultFont::dfont"],
    Cell[119053, 4097, 214, 5, 37, "Message",
      CellTags->"DefaultFont::dfont"],
    Cell[119270, 4104, 618, 14, 84, "Notes",
      CellTags->"DefaultFont::dfont"],
    Cell[119913, 4122, 68, 1, 38, "ExampleSection",
      CellTags->"DefaultFont::dfont"],
    Cell[119984, 4125, 193, 5, 24, "Text",
      CellTags->"DefaultFont::dfont"],
    Cell[120202, 4134, 144, 3, 26, "Input",
      CellTags->"DefaultFont::dfont"],
    Cell[120349, 4139, 225, 5, 37, "Message",
      CellTags->"DefaultFont::dfont"],
    Cell[120577, 4146, 188, 5, 21, "Output",
      CellTags->"DefaultFont::dfont"],
    Cell[120780, 4154, 146, 5, 24, "Text",
      CellTags->"DefaultFont::dfont"],
    Cell[120951, 4163, 163, 4, 26, "Input",
      CellTags->"DefaultFont::dfont"],
    Cell[121117, 4169, 188, 5, 21, "Output",
      CellTags->"DefaultFont::dfont"]},
  "DefaultFont::font"->{
    Cell[121366, 4181, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DefaultFont::font"],
    Cell[121456, 4184, 322, 6, 37, "Message",
      CellTags->"DefaultFont::font"],
    Cell[121781, 4192, 197, 6, 24, "Notes",
      CellTags->"DefaultFont::font"]},
  "General::zval"->{
    Cell[122015, 4203, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::zval"],
    Cell[122097, 4206, 501, 14, 21, "Message",
      CellTags->"General::zval"],
    Cell[122601, 4222, 512, 12, 78, "Notes",
      CellTags->"General::zval"],
    Cell[123138, 4238, 63, 1, 38, "ExampleSection",
      CellTags->"General::zval"],
    Cell[123204, 4241, 193, 5, 24, "Text",
      CellTags->"General::zval"],
    Cell[123422, 4250, 142, 3, 26, "Input",
      CellTags->"General::zval"],
    Cell[123567, 4255, 233, 5, 37, "Message",
      CellTags->"General::zval"],
    Cell[123803, 4262, 190, 5, 21, "Output",
      CellTags->"General::zval"]},
  "Display::badargs"->{
    Cell[124054, 4274, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::badargs"],
    Cell[124142, 4277, 151, 4, 21, "Message",
      CellTags->"Display::badargs"],
    Cell[124296, 4283, 196, 6, 24, "Notes",
      CellTags->"Display::badargs"]},
  "Display::dispgif"->{
    Cell[124529, 4294, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::dispgif"],
    Cell[124617, 4297, 163, 3, 21, "Message",
      CellTags->"Display::dispgif"],
    Cell[124783, 4302, 324, 7, 62, "Notes",
      CellTags->"Display::dispgif"]},
  "Display::dopen"->{
    Cell[125144, 4314, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::dopen"],
    Cell[125228, 4317, 187, 4, 21, "Message",
      CellTags->"Display::dopen"],
    Cell[125418, 4323, 494, 9, 84, "Notes",
      CellTags->"Display::dopen"],
    Cell[125937, 4336, 64, 1, 38, "ExampleSection",
      CellTags->"Display::dopen"],
    Cell[126004, 4339, 262, 5, 40, "Text",
      CellTags->"Display::dopen"],
    Cell[126291, 4348, 149, 4, 26, "Input",
      CellTags->"Display::dopen"],
    Cell[126443, 4354, 184, 5, 21, "Output",
      CellTags->"Display::dopen"],
    Cell[126630, 4361, 204, 7, 21, "Message",
      CellTags->"Display::dopen"],
    Cell[126837, 4370, 171, 8, 19, "Output",
      CellTags->"Display::dopen"]},
  "Display::dwrite"->{
    Cell[127069, 4385, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::dwrite"],
    Cell[127155, 4388, 192, 4, 21, "Message",
      CellTags->"Display::dwrite"],
    Cell[127350, 4394, 409, 8, 68, "Notes",
      CellTags->"Display::dwrite"],
    Cell[127784, 4406, 65, 1, 38, "ExampleSection",
      CellTags->"Display::dwrite"],
    Cell[127852, 4409, 279, 6, 40, "Text",
      CellTags->"Display::dwrite"],
    Cell[128156, 4419, 150, 4, 26, "Input",
      CellTags->"Display::dwrite"],
    Cell[128309, 4425, 185, 5, 21, "Output",
      CellTags->"Display::dwrite"],
    Cell[128497, 4432, 209, 7, 21, "Message",
      CellTags->"Display::dwrite"],
    Cell[128709, 4441, 172, 8, 19, "Output",
      CellTags->"Display::dwrite"]},
  "Display::fname"->{
    Cell[128942, 4456, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::fname"],
    Cell[129026, 4459, 218, 4, 21, "Message",
      CellTags->"Display::fname"],
    Cell[129247, 4465, 428, 9, 68, "Notes",
      CellTags->"Display::fname"],
    Cell[129700, 4478, 64, 1, 38, "ExampleSection",
      CellTags->"Display::fname"],
    Cell[129767, 4481, 269, 6, 40, "Text",
      CellTags->"Display::fname"],
    Cell[130061, 4491, 143, 3, 26, "Input",
      CellTags->"Display::fname"],
    Cell[130207, 4496, 285, 5, 21, "Message",
      CellTags->"Display::fname"],
    Cell[130495, 4503, 95, 3, 21, "Output",
      CellTags->"Display::fname"]},
  "Display::gfile"->{
    Cell[130651, 4513, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::gfile"],
    Cell[130735, 4516, 205, 5, 21, "Message",
      CellTags->"Display::gfile"],
    Cell[130943, 4523, 289, 6, 46, "Notes",
      CellTags->"Display::gfile"],
    Cell[131257, 4533, 64, 1, 38, "ExampleSection",
      CellTags->"Display::gfile"],
    Cell[131324, 4536, 143, 4, 24, "Text",
      CellTags->"Display::gfile"],
    Cell[131492, 4544, 122, 3, 26, "Input",
      CellTags->"Display::gfile"],
    Cell[131617, 4549, 168, 4, 21, "Message",
      CellTags->"Display::gfile"],
    Cell[131788, 4555, 184, 5, 21, "Output",
      CellTags->"Display::gfile"]},
  "Display::image"->{
    Cell[132033, 4567, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[132201, 4574, 599, 16, 37, "Message",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[132803, 4592, 466, 12, 62, "Notes",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133294, 4608, 106, 1, 38, "ExampleSection",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133403, 4611, 273, 8, 40, "Text",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133701, 4623, 213, 4, 42, "Input",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133917, 4629, 287, 5, 37, "Message",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[134207, 4636, 226, 5, 21, "Output",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}]},
  "Export::image"->{
    Cell[132033, 4567, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[132201, 4574, 599, 16, 37, "Message",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[132803, 4592, 466, 12, 62, "Notes",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133294, 4608, 106, 1, 38, "ExampleSection",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133403, 4611, 273, 8, 40, "Text",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133701, 4623, 213, 4, 42, "Input",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133917, 4629, 287, 5, 37, "Message",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[134207, 4636, 226, 5, 21, "Output",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}]},
  "ExportString::image"->{
    Cell[132033, 4567, 165, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[132201, 4574, 599, 16, 37, "Message",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[132803, 4592, 466, 12, 62, "Notes",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133294, 4608, 106, 1, 38, "ExampleSection",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133403, 4611, 273, 8, 40, "Text",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133701, 4623, 213, 4, 42, "Input",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[133917, 4629, 287, 5, 37, "Message",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}],
    Cell[134207, 4636, 226, 5, 21, "Output",
      CellTags->{"Display::image", "Export::image", "ExportString::image"}]},
  "Display::noform"->{
    Cell[134494, 4648, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::noform"],
    Cell[134580, 4651, 429, 11, 37, "Message",
      CellTags->"Display::noform"],
    Cell[135012, 4664, 343, 10, 46, "Notes",
      CellTags->"Display::noform"],
    Cell[135380, 4678, 65, 1, 38, "ExampleSection",
      CellTags->"Display::noform"],
    Cell[135448, 4681, 272, 6, 40, "Text",
      CellTags->"Display::noform"],
    Cell[135745, 4691, 146, 3, 26, "Input",
      CellTags->"Display::noform"],
    Cell[135894, 4696, 317, 6, 53, "Message",
      CellTags->"Display::noform"],
    Cell[136214, 4704, 185, 5, 21, "Output",
      CellTags->"Display::noform"]},
  "Display::nolink"->{
    Cell[136460, 4716, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::nolink"],
    Cell[136546, 4719, 168, 3, 21, "Message",
      CellTags->"Display::nolink"],
    Cell[136717, 4724, 594, 14, 84, "Notes",
      CellTags->"Display::nolink"]},
  "Display::pserr"->{
    Cell[137348, 4743, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::pserr"],
    Cell[137432, 4746, 195, 6, 21, "Message",
      CellTags->"Display::pserr"],
    Cell[137630, 4754, 615, 11, 116, "Notes",
      CellTags->"Display::pserr"]},
  "Display::type"->{
    Cell[138282, 4770, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Display::type"],
    Cell[138364, 4773, 244, 5, 21, "Message",
      CellTags->"Display::type"],
    Cell[138611, 4780, 450, 12, 62, "Notes",
      CellTags->"Display::type"],
    Cell[139086, 4796, 63, 1, 38, "ExampleSection",
      CellTags->"Display::type"],
    Cell[139152, 4799, 214, 6, 40, "Text",
      CellTags->"Display::type"],
    Cell[139391, 4809, 111, 3, 26, "Input",
      CellTags->"Display::type"],
    Cell[139505, 4814, 197, 5, 21, "Message",
      CellTags->"Display::type"],
    Cell[139705, 4821, 88, 3, 21, "Output",
      CellTags->"Display::type"],
    Cell[139808, 4827, 248, 6, 40, "Text",
      CellTags->"Display::type"],
    Cell[140081, 4837, 133, 3, 26, "Input",
      CellTags->"Display::type"],
    Cell[140217, 4842, 183, 5, 21, "Output",
      CellTags->"Display::type"],
    Cell[140415, 4850, 61, 1, 24, "Text",
      CellTags->"Display::type"],
    Cell[140479, 4853, 109, 3, 26, "Input",
      CellTags->"Display::type"]},
  "FaceGrids::fglst"->{
    Cell[140637, 4862, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FaceGrids::fglst"],
    Cell[140725, 4865, 317, 7, 37, "Message",
      CellTags->"FaceGrids::fglst"],
    Cell[141045, 4874, 451, 13, 62, "Notes",
      CellTags->"FaceGrids::fglst"],
    Cell[141521, 4891, 66, 1, 38, "ExampleSection",
      CellTags->"FaceGrids::fglst"],
    Cell[141590, 4894, 223, 5, 40, "Text",
      CellTags->"FaceGrids::fglst"],
    Cell[141838, 4903, 179, 4, 58, "Input",
      CellTags->"FaceGrids::fglst"],
    Cell[142020, 4909, 248, 5, 53, "Message",
      CellTags->"FaceGrids::fglst"],
    Cell[142271, 4916, 193, 5, 21, "Output",
      CellTags->"FaceGrids::fglst"],
    Cell[142479, 4924, 142, 5, 24, "Text",
      CellTags->"FaceGrids::fglst"],
    Cell[142646, 4933, 180, 4, 58, "Input",
      CellTags->"FaceGrids::fglst"],
    Cell[142829, 4939, 193, 5, 21, "Output",
      CellTags->"FaceGrids::fglst"],
    Cell[143037, 4947, 175, 5, 24, "Text",
      CellTags->"FaceGrids::fglst"],
    Cell[143237, 4956, 229, 5, 58, "Input",
      CellTags->"FaceGrids::fglst"],
    Cell[143469, 4963, 193, 5, 21, "Output",
      CellTags->"FaceGrids::fglst"]},
  "FaceGrids::fgstl"->{
    Cell[143723, 4975, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FaceGrids::fgstl"],
    Cell[143811, 4978, 227, 5, 21, "Message",
      CellTags->"FaceGrids::fgstl"],
    Cell[144041, 4985, 441, 10, 62, "Notes",
      CellTags->"FaceGrids::fgstl"],
    Cell[144507, 4999, 66, 1, 38, "ExampleSection",
      CellTags->"FaceGrids::fgstl"],
    Cell[144576, 5002, 168, 4, 24, "Text",
      CellTags->"FaceGrids::fgstl"],
    Cell[144769, 5010, 227, 5, 42, "Input",
      CellTags->"FaceGrids::fgstl"],
    Cell[144999, 5017, 218, 5, 37, "Message",
      CellTags->"FaceGrids::fgstl"],
    Cell[145220, 5024, 193, 5, 21, "Output",
      CellTags->"FaceGrids::fgstl"],
    Cell[145428, 5032, 141, 5, 24, "Text",
      CellTags->"FaceGrids::fgstl"],
    Cell[145594, 5041, 229, 5, 42, "Input",
      CellTags->"FaceGrids::fgstl"],
    Cell[145826, 5048, 193, 5, 21, "Output",
      CellTags->"FaceGrids::fgstl"]},
  "FaceGrids::gface"->{
    Cell[146080, 5060, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FaceGrids::gface"],
    Cell[146168, 5063, 220, 5, 21, "Message",
      CellTags->"FaceGrids::gface"],
    Cell[146391, 5070, 804, 25, 100, "Notes",
      CellTags->"FaceGrids::gface"],
    Cell[147220, 5099, 66, 1, 38, "ExampleSection",
      CellTags->"FaceGrids::gface"],
    Cell[147289, 5102, 228, 6, 40, "Text",
      CellTags->"FaceGrids::gface"],
    Cell[147542, 5112, 176, 4, 42, "Input",
      CellTags->"FaceGrids::gface"],
    Cell[147721, 5118, 183, 4, 21, "Message",
      CellTags->"FaceGrids::gface"],
    Cell[147907, 5124, 182, 4, 21, "Message",
      CellTags->"FaceGrids::gface"],
    Cell[148092, 5130, 182, 4, 21, "Message",
      CellTags->"FaceGrids::gface"],
    Cell[148277, 5136, 229, 5, 37, "Message",
      CellTags->"FaceGrids::gface"],
    Cell[148509, 5143, 193, 5, 21, "Output",
      CellTags->"FaceGrids::gface"],
    Cell[148717, 5151, 141, 5, 24, "Text",
      CellTags->"FaceGrids::gface"],
    Cell[148883, 5160, 178, 4, 42, "Input",
      CellTags->"FaceGrids::gface"],
    Cell[149064, 5166, 193, 5, 21, "Output",
      CellTags->"FaceGrids::gface"]},
  "FontForm::ffsp"->{
    Cell[149318, 5178, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FontForm::ffsp"],
    Cell[149402, 5181, 206, 5, 37, "Message",
      CellTags->"FontForm::ffsp"],
    Cell[149611, 5188, 537, 18, 62, "Notes",
      CellTags->"FontForm::ffsp"],
    Cell[150173, 5210, 64, 1, 38, "ExampleSection",
      CellTags->"FontForm::ffsp"],
    Cell[150240, 5213, 129, 5, 24, "Text",
      CellTags->"FontForm::ffsp"],
    Cell[150394, 5222, 176, 5, 26, "Input",
      CellTags->"FontForm::ffsp"],
    Cell[150573, 5229, 184, 5, 21, "Output",
      CellTags->"FontForm::ffsp"]},
  "FrameLabel::fmlab"->{
    Cell[150818, 5241, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FrameLabel::fmlab"],
    Cell[150908, 5244, 314, 6, 37, "Message",
      CellTags->"FrameLabel::fmlab"],
    Cell[151225, 5252, 358, 9, 46, "Notes",
      CellTags->"FrameLabel::fmlab"],
    Cell[151608, 5265, 67, 1, 38, "ExampleSection",
      CellTags->"FrameLabel::fmlab"],
    Cell[151678, 5268, 200, 5, 24, "Text",
      CellTags->"FrameLabel::fmlab"],
    Cell[151903, 5277, 169, 4, 26, "Input",
      CellTags->"FrameLabel::fmlab"],
    Cell[152075, 5283, 252, 5, 53, "Message",
      CellTags->"FrameLabel::fmlab"],
    Cell[152330, 5290, 252, 5, 53, "Message",
      CellTags->"FrameLabel::fmlab"],
    Cell[152585, 5297, 187, 5, 21, "Output",
      CellTags->"FrameLabel::fmlab"],
    Cell[152787, 5305, 151, 5, 24, "Text",
      CellTags->"FrameLabel::fmlab"],
    Cell[152963, 5314, 175, 4, 42, "Input",
      CellTags->"FrameLabel::fmlab"],
    Cell[153141, 5320, 187, 5, 21, "Output",
      CellTags->"FrameLabel::fmlab"]},
  "General::lspec"->{
    Cell[153389, 5332, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::lspec"],
    Cell[153473, 5335, 464, 13, 21, "Message",
      CellTags->"General::lspec"],
    Cell[153940, 5350, 294, 6, 46, "Notes",
      CellTags->"General::lspec"],
    Cell[154259, 5360, 64, 1, 38, "ExampleSection",
      CellTags->"General::lspec"],
    Cell[154326, 5363, 177, 4, 40, "Text",
      CellTags->"General::lspec"],
    Cell[154528, 5371, 191, 5, 42, "Input",
      CellTags->"General::lspec"],
    Cell[154722, 5378, 213, 5, 37, "Message",
      CellTags->"General::lspec"],
    Cell[154938, 5385, 191, 5, 21, "Output",
      CellTags->"General::lspec"],
    Cell[155144, 5393, 101, 1, 24, "Text",
      CellTags->"General::lspec"],
    Cell[155270, 5398, 213, 5, 42, "Input",
      CellTags->"General::lspec"],
    Cell[155486, 5405, 191, 5, 21, "Output",
      CellTags->"General::lspec"]},
  "Graphics3D::ambnt"->{
    Cell[155738, 5417, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics3D::ambnt"],
    Cell[155828, 5420, 493, 13, 37, "Message",
      CellTags->"Graphics3D::ambnt"],
    Cell[156324, 5435, 199, 5, 24, "Notes",
      CellTags->"Graphics3D::ambnt"],
    Cell[156548, 5444, 67, 1, 38, "ExampleSection",
      CellTags->"Graphics3D::ambnt"],
    Cell[156618, 5447, 254, 6, 40, "Text",
      CellTags->"Graphics3D::ambnt"],
    Cell[156897, 5457, 187, 4, 42, "Input",
      CellTags->"Graphics3D::ambnt"],
    Cell[157087, 5463, 312, 6, 53, "Message",
      CellTags->"Graphics3D::ambnt"],
    Cell[157402, 5471, 194, 5, 21, "Output",
      CellTags->"Graphics3D::ambnt"],
    Cell[157611, 5479, 184, 7, 24, "Text",
      CellTags->"Graphics3D::ambnt"],
    Cell[157820, 5490, 166, 4, 26, "Input",
      CellTags->"Graphics3D::ambnt"],
    Cell[157989, 5496, 194, 5, 21, "Output",
      CellTags->"Graphics3D::ambnt"]},
  "General::color"->{
    Cell[158244, 5508, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::color"],
    Cell[158328, 5511, 450, 13, 21, "Message",
      CellTags->"General::color"],
    Cell[158781, 5526, 1542, 56, 100, "Notes",
      CellTags->"General::color"],
    Cell[160348, 5586, 64, 1, 38, "ExampleSection",
      CellTags->"General::color"],
    Cell[160415, 5589, 170, 5, 24, "Text",
      CellTags->"General::color"],
    Cell[160610, 5598, 212, 6, 42, "Input",
      CellTags->"General::color"],
    Cell[160825, 5606, 209, 5, 37, "Message",
      CellTags->"General::color"],
    Cell[161037, 5613, 186, 5, 21, "Output",
      CellTags->"General::color"],
    Cell[161238, 5621, 102, 1, 24, "Text",
      CellTags->"General::color"],
    Cell[161365, 5626, 218, 6, 42, "Input",
      CellTags->"General::color"],
    Cell[161586, 5634, 186, 5, 21, "Output",
      CellTags->"General::color"]},
  "General::gprim"->{
    Cell[161833, 5646, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::gprim"],
    Cell[161917, 5649, 346, 10, 37, "Message",
      CellTags->"General::gprim"],
    Cell[162266, 5661, 417, 9, 78, "Notes",
      CellTags->"General::gprim"],
    Cell[162708, 5674, 64, 1, 38, "ExampleSection",
      CellTags->"General::gprim"],
    Cell[162775, 5677, 150, 4, 24, "Text",
      CellTags->"General::gprim"],
    Cell[162950, 5685, 119, 3, 26, "Input",
      CellTags->"General::gprim"],
    Cell[163072, 5690, 222, 5, 37, "Message",
      CellTags->"General::gprim"],
    Cell[163297, 5697, 222, 5, 37, "Message",
      CellTags->"General::gprim"],
    Cell[163522, 5704, 222, 5, 37, "Message",
      CellTags->"General::gprim"],
    Cell[163747, 5711, 226, 5, 37, "Message",
      CellTags->"General::gprim"],
    Cell[163976, 5718, 184, 5, 21, "Output",
      CellTags->"General::gprim"],
    Cell[164175, 5726, 177, 7, 24, "Text",
      CellTags->"General::gprim"],
    Cell[164377, 5737, 125, 3, 26, "Input",
      CellTags->"General::gprim"],
    Cell[164505, 5742, 184, 5, 21, "Output",
      CellTags->"General::gprim"]},
  "General::pcolor"->{
    Cell[164750, 5754, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::pcolor"],
    Cell[164836, 5757, 272, 7, 21, "Message",
      CellTags->"General::pcolor"],
    Cell[165111, 5766, 857, 24, 116, "Notes",
      CellTags->"General::pcolor"],
    Cell[165993, 5794, 65, 1, 38, "ExampleSection",
      CellTags->"General::pcolor"],
    Cell[166061, 5797, 169, 4, 24, "Text",
      CellTags->"General::pcolor"],
    Cell[166255, 5805, 265, 6, 58, "Input",
      CellTags->"General::pcolor"],
    Cell[166523, 5813, 209, 5, 37, "Message",
      CellTags->"General::pcolor"],
    Cell[166735, 5820, 209, 5, 37, "Message",
      CellTags->"General::pcolor"],
    Cell[166947, 5827, 209, 5, 37, "Message",
      CellTags->"General::pcolor"],
    Cell[167159, 5834, 236, 5, 37, "Message",
      CellTags->"General::pcolor"],
    Cell[167398, 5841, 187, 5, 21, "Output",
      CellTags->"General::pcolor"],
    Cell[167600, 5849, 152, 5, 24, "Text",
      CellTags->"General::pcolor"],
    Cell[167777, 5858, 277, 6, 74, "Input",
      CellTags->"General::pcolor"],
    Cell[168057, 5866, 187, 5, 21, "Output",
      CellTags->"General::pcolor"]},
  "General::plln"->{
    Cell[168305, 5878, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::plln"],
    Cell[168387, 5881, 486, 14, 21, "Message",
      CellTags->"General::plln"],
    Cell[168876, 5897, 710, 20, 100, "Notes",
      CellTags->"General::plln"],
    Cell[169611, 5921, 63, 1, 38, "ExampleSection",
      CellTags->"General::plln"],
    Cell[169677, 5924, 186, 5, 24, "Text",
      CellTags->"General::plln"],
    Cell[169888, 5933, 121, 3, 26, "Input",
      CellTags->"General::plln"],
    Cell[170012, 5938, 225, 5, 37, "Message",
      CellTags->"General::plln"],
    Cell[170240, 5945, 125, 3, 21, "Output",
      CellTags->"General::plln"],
    Cell[170380, 5951, 134, 5, 24, "Text",
      CellTags->"General::plln"],
    Cell[170539, 5960, 113, 3, 26, "Input",
      CellTags->"General::plln"],
    Cell[170655, 5965, 183, 5, 21, "Output",
      CellTags->"General::plln"]},
  "General::rawvar"->{
    Cell[170899, 5977, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::rawvar"],
    Cell[170985, 5980, 511, 14, 37, "Message",
      CellTags->"General::rawvar"],
    Cell[171499, 5996, 195, 6, 24, "Notes",
      CellTags->"General::rawvar"]},
  "Graphics3D::lights"->{
    Cell[171731, 6007, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics3D::lights"],
    Cell[171823, 6010, 493, 13, 37, "Message",
      CellTags->"Graphics3D::lights"],
    Cell[172319, 6025, 500, 10, 78, "Notes",
      CellTags->"Graphics3D::lights"],
    Cell[172844, 6039, 68, 1, 38, "ExampleSection",
      CellTags->"Graphics3D::lights"],
    Cell[172915, 6042, 235, 5, 40, "Text",
      CellTags->"Graphics3D::lights"],
    Cell[173175, 6051, 188, 4, 42, "Input",
      CellTags->"Graphics3D::lights"],
    Cell[173366, 6057, 296, 6, 53, "Message",
      CellTags->"Graphics3D::lights"],
    Cell[173665, 6065, 195, 5, 21, "Output",
      CellTags->"Graphics3D::lights"],
    Cell[173875, 6073, 147, 5, 24, "Text",
      CellTags->"Graphics3D::lights"],
    Cell[174047, 6082, 190, 4, 42, "Input",
      CellTags->"Graphics3D::lights"],
    Cell[174240, 6088, 195, 5, 21, "Output",
      CellTags->"Graphics3D::lights"]},
  "Graphics3D::boxz"->{
    Cell[174496, 6100, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics3D::boxz"],
    Cell[174584, 6103, 169, 3, 21, "Message",
      CellTags->"Graphics3D::boxz"],
    Cell[174756, 6108, 470, 9, 84, "Notes",
      CellTags->"Graphics3D::boxz"]},
  "Graphics3D::gsort"->{
    Cell[175263, 6122, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics3D::gsort"],
    Cell[175353, 6125, 159, 3, 21, "Message",
      CellTags->"Graphics3D::gsort"],
    Cell[175515, 6130, 309, 6, 46, "Notes",
      CellTags->"Graphics3D::gsort"]},
  "Graphics3D::psvf"->{
    Cell[175861, 6141, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics3D::psvf"],
    Cell[175949, 6144, 515, 14, 37, "Message",
      CellTags->"Graphics3D::psvf"],
    Cell[176467, 6160, 422, 9, 84, "Notes",
      CellTags->"Graphics3D::psvf"]},
  "Graphics::gpt"->{
    Cell[176926, 6174, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics::gpt"],
    Cell[177008, 6177, 245, 5, 21, "Message",
      CellTags->"Graphics::gpt"],
    Cell[177256, 6184, 604, 23, 62, "Notes",
      CellTags->"Graphics::gpt"],
    Cell[177885, 6211, 63, 1, 38, "ExampleSection",
      CellTags->"Graphics::gpt"],
    Cell[177951, 6214, 187, 5, 24, "Text",
      CellTags->"Graphics::gpt"],
    Cell[178163, 6223, 120, 3, 26, "Input",
      CellTags->"Graphics::gpt"],
    Cell[178286, 6228, 179, 4, 21, "Message",
      CellTags->"Graphics::gpt"],
    Cell[178468, 6234, 179, 4, 21, "Message",
      CellTags->"Graphics::gpt"],
    Cell[178650, 6240, 179, 4, 21, "Message",
      CellTags->"Graphics::gpt"],
    Cell[178832, 6246, 223, 5, 37, "Message",
      CellTags->"Graphics::gpt"],
    Cell[179058, 6253, 183, 5, 21, "Output",
      CellTags->"Graphics::gpt"],
    Cell[179256, 6261, 136, 5, 24, "Text",
      CellTags->"Graphics::gpt"],
    Cell[179417, 6270, 124, 3, 26, "Input",
      CellTags->"Graphics::gpt"],
    Cell[179544, 6275, 183, 5, 21, "Output",
      CellTags->"Graphics::gpt"]},
  "Graphics::gptn"->{
    Cell[179788, 6287, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics::gptn"],
    Cell[179872, 6290, 346, 9, 21, "Message",
      CellTags->"Graphics::gptn"],
    Cell[180221, 6301, 287, 6, 46, "Notes",
      CellTags->"Graphics::gptn"],
    Cell[180533, 6311, 64, 1, 38, "ExampleSection",
      CellTags->"Graphics::gptn"],
    Cell[180600, 6314, 174, 5, 24, "Text",
      CellTags->"Graphics::gptn"],
    Cell[180799, 6323, 135, 3, 26, "Input",
      CellTags->"Graphics::gptn"],
    Cell[180937, 6328, 235, 5, 37, "Message",
      CellTags->"Graphics::gptn"],
    Cell[181175, 6335, 184, 5, 21, "Output",
      CellTags->"Graphics::gptn"],
    Cell[181374, 6343, 162, 5, 24, "Text",
      CellTags->"Graphics::gptn"],
    Cell[181561, 6352, 133, 3, 26, "Input",
      CellTags->"Graphics::gptn"],
    Cell[181697, 6357, 184, 5, 21, "Output",
      CellTags->"Graphics::gptn"]},
  "Graphics::hue"->{
    Cell[181942, 6369, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics::hue"],
    Cell[182024, 6372, 192, 4, 21, "Message",
      CellTags->"Graphics::hue"],
    Cell[182219, 6378, 177, 5, 24, "Notes",
      CellTags->"Graphics::hue"],
    Cell[182421, 6387, 63, 1, 38, "ExampleSection",
      CellTags->"Graphics::hue"],
    Cell[182487, 6390, 210, 7, 24, "Text",
      CellTags->"Graphics::hue"],
    Cell[182722, 6401, 186, 5, 42, "Input",
      CellTags->"Graphics::hue"],
    Cell[182911, 6408, 240, 5, 21, "Message",
      CellTags->"Graphics::hue"],
    Cell[183154, 6415, 183, 5, 21, "Output",
      CellTags->"Graphics::hue"],
    Cell[183352, 6423, 119, 5, 24, "Text",
      CellTags->"Graphics::hue"],
    Cell[183496, 6432, 186, 5, 42, "Input",
      CellTags->"Graphics::hue"],
    Cell[183685, 6439, 183, 5, 21, "Output",
      CellTags->"Graphics::hue"]},
  "GraphicsArray::prim"->{
    Cell[183929, 6451, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"GraphicsArray::prim"],
    Cell[184023, 6454, 306, 6, 37, "Message",
      CellTags->"GraphicsArray::prim"],
    Cell[184332, 6462, 376, 9, 62, "Notes",
      CellTags->"GraphicsArray::prim"],
    Cell[184733, 6475, 69, 1, 38, "ExampleSection",
      CellTags->"GraphicsArray::prim"],
    Cell[184805, 6478, 188, 5, 24, "Text",
      CellTags->"GraphicsArray::prim"],
    Cell[185018, 6487, 201, 5, 42, "Input",
      CellTags->"GraphicsArray::prim"],
    Cell[185222, 6494, 470, 8, 53, "Message",
      CellTags->"GraphicsArray::prim"],
    Cell[185695, 6504, 194, 5, 21, "Output",
      CellTags->"GraphicsArray::prim"],
    Cell[185904, 6512, 158, 5, 24, "Text",
      CellTags->"GraphicsArray::prim"],
    Cell[186087, 6521, 199, 5, 42, "Input",
      CellTags->"GraphicsArray::prim"],
    Cell[186289, 6528, 194, 5, 21, "Output",
      CellTags->"GraphicsArray::prim"]},
  "ListPlay::lsamps"->{
    Cell[186544, 6540, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ListPlay::lsamps"],
    Cell[186632, 6543, 226, 4, 37, "Message",
      CellTags->"ListPlay::lsamps"],
    Cell[186861, 6549, 215, 5, 24, "Notes",
      CellTags->"ListPlay::lsamps"],
    Cell[187101, 6558, 66, 1, 38, "ExampleSection",
      CellTags->"ListPlay::lsamps"],
    Cell[187170, 6561, 151, 5, 24, "Text",
      CellTags->"ListPlay::lsamps"],
    Cell[187346, 6570, 103, 3, 26, "Input",
      CellTags->"ListPlay::lsamps"],
    Cell[187452, 6575, 229, 5, 37, "Message",
      CellTags->"ListPlay::lsamps"],
    Cell[187684, 6582, 104, 3, 21, "Output",
      CellTags->"ListPlay::lsamps"],
    Cell[187803, 6588, 132, 5, 24, "Text",
      CellTags->"ListPlay::lsamps"],
    Cell[187960, 6597, 130, 3, 26, "Input",
      CellTags->"ListPlay::lsamps"],
    Cell[188093, 6602, 183, 5, 21, "Output",
      CellTags->"ListPlay::lsamps"]},
  "ListPlay::silent"->{
    Cell[188337, 6614, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ListPlay::silent"],
    Cell[188425, 6617, 242, 5, 21, "Message",
      CellTags->"ListPlay::silent"],
    Cell[188670, 6624, 235, 6, 40, "Notes",
      CellTags->"ListPlay::silent"],
    Cell[188930, 6634, 66, 1, 38, "ExampleSection",
      CellTags->"ListPlay::silent"],
    Cell[188999, 6637, 161, 4, 24, "Text",
      CellTags->"ListPlay::silent"],
    Cell[189185, 6645, 130, 3, 26, "Input",
      CellTags->"ListPlay::silent"],
    Cell[189318, 6650, 175, 4, 21, "Message",
      CellTags->"ListPlay::silent"],
    Cell[189496, 6656, 183, 5, 21, "Output",
      CellTags->"ListPlay::silent"],
    Cell[189694, 6664, 121, 4, 24, "Text",
      CellTags->"ListPlay::silent"],
    Cell[189840, 6672, 130, 3, 26, "Input",
      CellTags->"ListPlay::silent"],
    Cell[189973, 6677, 183, 5, 21, "Output",
      CellTags->"ListPlay::silent"]},
  "ListPlot::lpn"->{
    Cell[190217, 6689, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ListPlot::lpn"],
    Cell[190299, 6692, 229, 5, 21, "Message",
      CellTags->"ListPlot::lpn"],
    Cell[190531, 6699, 189, 5, 24, "Notes",
      CellTags->"ListPlot::lpn"]},
  "ParametricPlot3D::ppfun"->{
    Cell[190757, 6709, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[190859, 6712, 271, 6, 37, "Message",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[191133, 6720, 238, 5, 40, "Notes",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[191396, 6729, 73, 1, 38, "ExampleSection",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[191472, 6732, 153, 4, 24, "Text",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[191650, 6740, 174, 4, 42, "Input",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[191827, 6746, 290, 6, 72, "Message",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[192120, 6754, 178, 4, 36, "Output",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[192313, 6761, 146, 5, 24, "Text",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[192484, 6770, 168, 4, 26, "Input",
      CellTags->"ParametricPlot3D::ppfun"],
    Cell[192655, 6776, 195, 5, 21, "Output",
      CellTags->"ParametricPlot3D::ppfun"]},
  "ParametricPlot3D::pplr"->{
    Cell[192911, 6788, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[193011, 6791, 219, 5, 37, "Message",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[193233, 6798, 447, 9, 78, "Notes",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[193705, 6811, 72, 1, 38, "ExampleSection",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[193780, 6814, 268, 6, 40, "Text",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[194073, 6824, 147, 3, 26, "Input",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[194223, 6829, 270, 5, 51, "Message",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[194496, 6836, 289, 6, 68, "Message",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[194788, 6844, 288, 6, 68, "Message",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[195079, 6852, 241, 5, 37, "Message",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[195323, 6859, 211, 5, 37, "Message",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[195537, 6866, 149, 3, 34, "Output",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[195701, 6872, 145, 5, 24, "Text",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[195871, 6881, 147, 3, 26, "Input",
      CellTags->"ParametricPlot3D::pplr"],
    Cell[196021, 6886, 194, 5, 21, "Output",
      CellTags->"ParametricPlot3D::pplr"]},
  "ParametricPlot3D::ppta"->{
    Cell[196276, 6898, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[196376, 6901, 347, 6, 37, "Message",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[196726, 6909, 278, 7, 40, "Notes",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[197029, 6920, 72, 1, 38, "ExampleSection",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[197104, 6923, 265, 9, 40, "Text",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[197394, 6936, 173, 4, 26, "Input",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[197570, 6942, 262, 5, 53, "Message",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[197835, 6949, 179, 4, 21, "Output",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[198029, 6956, 197, 7, 24, "Text",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[198251, 6967, 171, 4, 26, "Input",
      CellTags->"ParametricPlot3D::ppta"],
    Cell[198425, 6973, 194, 5, 21, "Output",
      CellTags->"ParametricPlot3D::ppta"]},
  "ParametricPlot3D::ppx"->{
    Cell[198680, 6985, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ParametricPlot3D::ppx"],
    Cell[198778, 6988, 194, 3, 37, "Message",
      CellTags->"ParametricPlot3D::ppx"],
    Cell[198975, 6993, 333, 7, 46, "Notes",
      CellTags->"ParametricPlot3D::ppx"]},
  "ParametricPlot::bend"->{
    Cell[199345, 7005, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[199476, 7011, 407, 10, 21, "Message",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[199886, 7023, 213, 5, 24, "Notes",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200124, 7032, 86, 1, 38, "ExampleSection",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200213, 7035, 228, 7, 24, "Text",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200466, 7046, 167, 3, 26, "Input",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200636, 7051, 206, 4, 21, "Message",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200845, 7057, 185, 4, 21, "Output",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[201045, 7064, 196, 7, 24, "Text",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[201266, 7075, 166, 3, 26, "Input",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[201435, 7080, 206, 5, 21, "Output",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}]},
  "Plot::bend"->{
    Cell[199345, 7005, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[199476, 7011, 407, 10, 21, "Message",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[199886, 7023, 213, 5, 24, "Notes",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200124, 7032, 86, 1, 38, "ExampleSection",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200213, 7035, 228, 7, 24, "Text",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200466, 7046, 167, 3, 26, "Input",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200636, 7051, 206, 4, 21, "Message",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[200845, 7057, 185, 4, 21, "Output",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[201045, 7064, 196, 7, 24, "Text",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[201266, 7075, 166, 3, 26, "Input",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}],
    Cell[201435, 7080, 206, 5, 21, "Output",
      CellTags->{"ParametricPlot::bend", "Plot::bend"}]},
  "ParametricPlot::plld"->{
    Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202022, 7105, 633, 16, 37, "Message",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202658, 7123, 293, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202976, 7133, 192, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203171, 7138, 273, 6, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203469, 7148, 238, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203710, 7155, 357, 7, 37, "Message",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204070, 7164, 239, 5, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204324, 7172, 275, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204624, 7183, 242, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204869, 7190, 312, 7, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", 
        "Plot::plld"}]},
  "Plot::plld"->{
    Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202022, 7105, 633, 16, 37, "Message",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202658, 7123, 293, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202976, 7133, 192, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203171, 7138, 273, 6, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203469, 7148, 238, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203710, 7155, 357, 7, 37, "Message",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204070, 7164, 239, 5, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204324, 7172, 275, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204624, 7183, 242, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204869, 7190, 312, 7, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", 
        "Plot::plld"}]},
  "Plot3D::plld"->{
    Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202022, 7105, 633, 16, 37, "Message",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202658, 7123, 293, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202976, 7133, 192, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203171, 7138, 273, 6, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203469, 7148, 238, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203710, 7155, 357, 7, 37, "Message",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204070, 7164, 239, 5, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204324, 7172, 275, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204624, 7183, 242, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204869, 7190, 312, 7, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", 
        "Plot::plld"}]},
  "ContourPlot::plld"->{
    Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202022, 7105, 633, 16, 37, "Message",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202658, 7123, 293, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202976, 7133, 192, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203171, 7138, 273, 6, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203469, 7148, 238, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203710, 7155, 357, 7, 37, "Message",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204070, 7164, 239, 5, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204324, 7172, 275, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204624, 7183, 242, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204869, 7190, 312, 7, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", 
        "Plot::plld"}]},
  "DensityPlot::plld"->{
    Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202022, 7105, 633, 16, 37, "Message",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202658, 7123, 293, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202976, 7133, 192, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203171, 7138, 273, 6, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203469, 7148, 238, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203710, 7155, 357, 7, 37, "Message",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204070, 7164, 239, 5, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204324, 7172, 275, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204624, 7183, 242, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204869, 7190, 312, 7, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", 
        "Plot::plld"}]},
  "ParametricPlot3D::plld"->{
    Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202022, 7105, 633, 16, 37, "Message",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202658, 7123, 293, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202976, 7133, 192, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203171, 7138, 273, 6, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203469, 7148, 238, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203710, 7155, 357, 7, 37, "Message",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204070, 7164, 239, 5, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204324, 7172, 275, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204624, 7183, 242, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204869, 7190, 312, 7, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", 
        "Plot::plld"}]},
  "Play::plld"->{
    Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202022, 7105, 633, 16, 37, "Message",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202658, 7123, 293, 6, 24, "Notes",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[202976, 7133, 192, 3, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203171, 7138, 273, 6, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203469, 7148, 238, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[203710, 7155, 357, 7, 37, "Message",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204070, 7164, 239, 5, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
    Cell[204324, 7172, 275, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204624, 7183, 242, 5, 26, "Input",
      CellTags->{
      "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", 
        "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "Play::plld"}],
    Cell[204869, 7190, 312, 7, 21, "Output",
      CellTags->{
      "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
        "ParametricPlot::plld", "Play::plld", "Plot3D::plld", 
        "Plot::plld"}]},
  "ParametricPlot::pptr"->{
    Cell[205242, 7204, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ParametricPlot::pptr"],
    Cell[205338, 7207, 527, 15, 21, "Message",
      CellTags->"ParametricPlot::pptr"],
    Cell[205868, 7224, 245, 6, 40, "Notes",
      CellTags->"ParametricPlot::pptr"],
    Cell[206138, 7234, 70, 1, 38, "ExampleSection",
      CellTags->"ParametricPlot::pptr"],
    Cell[206211, 7237, 180, 4, 40, "Text",
      CellTags->"ParametricPlot::pptr"],
    Cell[206416, 7245, 130, 3, 26, "Input",
      CellTags->"ParametricPlot::pptr"],
    Cell[206549, 7250, 244, 5, 53, "Message",
      CellTags->"ParametricPlot::pptr"],
    Cell[206796, 7257, 249, 5, 37, "Message",
      CellTags->"ParametricPlot::pptr"],
    Cell[207048, 7264, 247, 5, 37, "Message",
      CellTags->"ParametricPlot::pptr"],
    Cell[207298, 7271, 246, 5, 37, "Message",
      CellTags->"ParametricPlot::pptr"],
    Cell[207547, 7278, 237, 5, 37, "Message",
      CellTags->"ParametricPlot::pptr"],
    Cell[207787, 7285, 190, 5, 21, "Output",
      CellTags->"ParametricPlot::pptr"],
    Cell[207992, 7293, 141, 5, 24, "Text",
      CellTags->"ParametricPlot::pptr"],
    Cell[208158, 7302, 135, 3, 26, "Input",
      CellTags->"ParametricPlot::pptr"],
    Cell[208296, 7307, 190, 5, 21, "Output",
      CellTags->"ParametricPlot::pptr"]},
  "ParametricPlot::ppts"->{
    Cell[208547, 7319, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[208727, 7326, 523, 15, 21, "Message",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209253, 7343, 242, 5, 24, "Notes",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209520, 7352, 112, 1, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209635, 7355, 257, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209917, 7366, 178, 3, 26, "Input",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210098, 7371, 245, 5, 21, "Message",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],
    Cell[210346, 7378, 184, 3, 21, "Output",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],
    Cell[210545, 7384, 225, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210795, 7395, 177, 3, 26, "Input",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210975, 7400, 232, 5, 21, "Output",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}]},
  "ParametricPlot3D::ppts"->{
    Cell[208547, 7319, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[208727, 7326, 523, 15, 21, "Message",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209253, 7343, 242, 5, 24, "Notes",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209520, 7352, 112, 1, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209635, 7355, 257, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209917, 7366, 178, 3, 26, "Input",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210098, 7371, 245, 5, 21, "Message",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],
    Cell[210346, 7378, 184, 3, 21, "Output",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],
    Cell[210545, 7384, 225, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210795, 7395, 177, 3, 26, "Input",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210975, 7400, 232, 5, 21, "Output",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}]},
  "Plot::ppts"->{
    Cell[208547, 7319, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[208727, 7326, 523, 15, 21, "Message",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209253, 7343, 242, 5, 24, "Notes",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209520, 7352, 112, 1, 38, "ExampleSection",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209635, 7355, 257, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[209917, 7366, 178, 3, 26, "Input",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210098, 7371, 245, 5, 21, "Message",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],
    Cell[210346, 7378, 184, 3, 21, "Output",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],
    Cell[210545, 7384, 225, 7, 24, "Text",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210795, 7395, 177, 3, 26, "Input",
      CellTags->{
      "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
    Cell[210975, 7400, 232, 5, 21, "Output",
      CellTags->{
      "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}]},
  "Play::pfnum"->{
    Cell[211268, 7412, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Play::pfnum"],
    Cell[211346, 7415, 277, 5, 37, "Message",
      CellTags->"Play::pfnum"],
    Cell[211626, 7422, 350, 9, 46, "Notes",
      CellTags->"Play::pfnum"],
    Cell[212001, 7435, 61, 1, 38, "ExampleSection",
      CellTags->"Play::pfnum"],
    Cell[212065, 7438, 221, 5, 40, "Text",
      CellTags->"Play::pfnum"],
    Cell[212311, 7447, 128, 3, 26, "Input",
      CellTags->"Play::pfnum"],
    Cell[212442, 7452, 512, 9, 69, "Message",
      CellTags->"Play::pfnum"],
    Cell[212957, 7463, 134, 3, 21, "Output",
      CellTags->"Play::pfnum"],
    Cell[213106, 7469, 122, 5, 24, "Text",
      CellTags->"Play::pfnum"],
    Cell[213253, 7478, 152, 4, 26, "Input",
      CellTags->"Play::pfnum"],
    Cell[213408, 7484, 178, 5, 21, "Output",
      CellTags->"Play::pfnum"]},
  "Play::playr"->{
    Cell[213647, 7496, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[213770, 7502, 560, 16, 37, "Message",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214333, 7520, 211, 5, 24, "Notes",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214569, 7529, 82, 1, 38, "ExampleSection",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214654, 7532, 210, 6, 24, "Text",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214889, 7542, 150, 3, 26, "Input",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[215042, 7547, 238, 5, 37, "Message",
      CellTags->{"ListPlay::playr", "Play::playr"}],
    Cell[215283, 7554, 156, 3, 21, "Output",
      CellTags->{"ListPlay::playr", "Play::playr"}],
    Cell[215454, 7560, 194, 7, 24, "Text",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[215673, 7571, 154, 3, 26, "Input",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[215830, 7576, 199, 5, 21, "Output",
      CellTags->{"ListPlay::playr", "Play::playr"}]},
  "ListPlay::playr"->{
    Cell[213647, 7496, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[213770, 7502, 560, 16, 37, "Message",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214333, 7520, 211, 5, 24, "Notes",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214569, 7529, 82, 1, 38, "ExampleSection",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214654, 7532, 210, 6, 24, "Text",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[214889, 7542, 150, 3, 26, "Input",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[215042, 7547, 238, 5, 37, "Message",
      CellTags->{"ListPlay::playr", "Play::playr"}],
    Cell[215283, 7554, 156, 3, 21, "Output",
      CellTags->{"ListPlay::playr", "Play::playr"}],
    Cell[215454, 7560, 194, 7, 24, "Text",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[215673, 7571, 154, 3, 26, "Input",
      CellTags->{"Play::playr", "ListPlay::playr"}],
    Cell[215830, 7576, 199, 5, 21, "Output",
      CellTags->{"ListPlay::playr", "Play::playr"}]},
  "Play::sample"->{
    Cell[216090, 7588, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Play::sample"],
    Cell[216170, 7591, 266, 6, 21, "Message",
      CellTags->"Play::sample"],
    Cell[216439, 7599, 528, 10, 100, "Notes",
      CellTags->"Play::sample"]},
  "Play::sdep"->{
    Cell[217004, 7614, 116, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[217123, 7620, 528, 15, 37, "Message",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[217654, 7637, 279, 6, 40, "Notes",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[217958, 7647, 80, 1, 38, "ExampleSection",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[218041, 7650, 226, 7, 24, "Text",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[218292, 7661, 151, 3, 26, "Input",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[218446, 7666, 233, 5, 37, "Message",
      CellTags->{"ListPlay::sdep", "Play::sdep"}],
    Cell[218682, 7673, 157, 3, 21, "Output",
      CellTags->{"ListPlay::sdep", "Play::sdep"}],
    Cell[218854, 7679, 141, 5, 24, "Text",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[219020, 7688, 150, 3, 26, "Input",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[219173, 7693, 197, 5, 21, "Output",
      CellTags->{"ListPlay::sdep", "Play::sdep"}]},
  "ListPlay::sdep"->{
    Cell[217004, 7614, 116, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[217123, 7620, 528, 15, 37, "Message",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[217654, 7637, 279, 6, 40, "Notes",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[217958, 7647, 80, 1, 38, "ExampleSection",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[218041, 7650, 226, 7, 24, "Text",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[218292, 7661, 151, 3, 26, "Input",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[218446, 7666, 233, 5, 37, "Message",
      CellTags->{"ListPlay::sdep", "Play::sdep"}],
    Cell[218682, 7673, 157, 3, 21, "Output",
      CellTags->{"ListPlay::sdep", "Play::sdep"}],
    Cell[218854, 7679, 141, 5, 24, "Text",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[219020, 7688, 150, 3, 26, "Input",
      CellTags->{"Play::sdep", "ListPlay::sdep"}],
    Cell[219173, 7693, 197, 5, 21, "Output",
      CellTags->{"ListPlay::sdep", "Play::sdep"}]},
  "Play::srate"->{
    Cell[219431, 7705, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[219554, 7711, 544, 16, 37, "Message",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220101, 7729, 280, 6, 40, "Notes",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220406, 7739, 82, 1, 38, "ExampleSection",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220491, 7742, 227, 7, 24, "Text",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220743, 7753, 152, 3, 26, "Input",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220898, 7758, 239, 5, 37, "Message",
      CellTags->{"ListPlay::srate", "Play::srate"}],
    Cell[221140, 7765, 158, 3, 21, "Output",
      CellTags->{"ListPlay::srate", "Play::srate"}],
    Cell[221313, 7771, 195, 7, 24, "Text",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[221533, 7782, 153, 3, 26, "Input",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[221689, 7787, 199, 5, 21, "Output",
      CellTags->{"ListPlay::srate", "Play::srate"}]},
  "ListPlay::srate"->{
    Cell[219431, 7705, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[219554, 7711, 544, 16, 37, "Message",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220101, 7729, 280, 6, 40, "Notes",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220406, 7739, 82, 1, 38, "ExampleSection",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220491, 7742, 227, 7, 24, "Text",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220743, 7753, 152, 3, 26, "Input",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[220898, 7758, 239, 5, 37, "Message",
      CellTags->{"ListPlay::srate", "Play::srate"}],
    Cell[221140, 7765, 158, 3, 21, "Output",
      CellTags->{"ListPlay::srate", "Play::srate"}],
    Cell[221313, 7771, 195, 7, 24, "Text",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[221533, 7782, 153, 3, 26, "Input",
      CellTags->{"Play::srate", "ListPlay::srate"}],
    Cell[221689, 7787, 199, 5, 21, "Output",
      CellTags->{"ListPlay::srate", "Play::srate"}]},
  "Plot3D::plnc"->{
    Cell[221949, 7799, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Plot3D::plnc"],
    Cell[222029, 7802, 644, 16, 37, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[222676, 7820, 235, 6, 40, "Notes",
      CellTags->"Plot3D::plnc"],
    Cell[222936, 7830, 62, 1, 38, "ExampleSection",
      CellTags->"Plot3D::plnc"],
    Cell[223001, 7833, 211, 5, 40, "Text",
      CellTags->"Plot3D::plnc"],
    Cell[223237, 7842, 122, 3, 26, "Input",
      CellTags->"Plot3D::plnc"],
    Cell[223362, 7847, 279, 6, 53, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[223644, 7855, 296, 6, 53, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[223943, 7863, 296, 6, 53, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[224242, 7871, 221, 5, 37, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[224466, 7878, 225, 5, 37, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[224694, 7885, 225, 5, 37, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[224922, 7892, 225, 5, 37, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[225150, 7899, 221, 5, 37, "Message",
      CellTags->"Plot3D::plnc"],
    Cell[225374, 7906, 189, 5, 21, "Output",
      CellTags->"Plot3D::plnc"],
    Cell[225578, 7914, 125, 5, 24, "Text",
      CellTags->"Plot3D::plnc"],
    Cell[225728, 7923, 137, 3, 26, "Input",
      CellTags->"Plot3D::plnc"],
    Cell[225868, 7928, 189, 5, 21, "Output",
      CellTags->"Plot3D::plnc"]},
  "Plot3D::gval"->{
    Cell[226118, 7940, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Plot3D::gval"],
    Cell[226198, 7943, 208, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[226409, 7950, 148, 4, 24, "Notes",
      CellTags->"Plot3D::gval"],
    Cell[226582, 7958, 62, 1, 38, "ExampleSection",
      CellTags->"Plot3D::gval"],
    Cell[226647, 7961, 211, 5, 40, "Text",
      CellTags->"Plot3D::gval"],
    Cell[226883, 7970, 122, 3, 26, "Input",
      CellTags->"Plot3D::gval"],
    Cell[227008, 7975, 279, 6, 53, "Message",
      CellTags->"Plot3D::gval"],
    Cell[227290, 7983, 296, 6, 53, "Message",
      CellTags->"Plot3D::gval"],
    Cell[227589, 7991, 296, 6, 53, "Message",
      CellTags->"Plot3D::gval"],
    Cell[227888, 7999, 221, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[228112, 8006, 225, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[228340, 8013, 225, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[228568, 8020, 225, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[228796, 8027, 221, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[229020, 8034, 189, 5, 21, "Output",
      CellTags->"Plot3D::gval"],
    Cell[229224, 8042, 125, 5, 24, "Text",
      CellTags->"Plot3D::gval"],
    Cell[229374, 8051, 137, 3, 26, "Input",
      CellTags->"Plot3D::gval"],
    Cell[229514, 8056, 189, 5, 21, "Output",
      CellTags->"Plot3D::gval"],
    Cell[229718, 8064, 222, 5, 40, "Text",
      CellTags->"Plot3D::gval"],
    Cell[229965, 8073, 172, 5, 26, "Input",
      CellTags->"Plot3D::gval"],
    Cell[230140, 8080, 226, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[230369, 8087, 226, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[230598, 8094, 226, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[230827, 8101, 221, 5, 37, "Message",
      CellTags->"Plot3D::gval"],
    Cell[231051, 8108, 189, 5, 21, "Output",
      CellTags->"Plot3D::gval"],
    Cell[231255, 8116, 134, 5, 24, "Text",
      CellTags->"Plot3D::gval"],
    Cell[231414, 8125, 124, 3, 26, "Input",
      CellTags->"Plot3D::gval"],
    Cell[231541, 8130, 189, 5, 21, "Output",
      CellTags->"Plot3D::gval"]},
  "Graphics3D::p3mat"->{
    Cell[231791, 8142, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Graphics3D::p3mat"],
    Cell[231881, 8145, 338, 8, 37, "Message",
      CellTags->"Graphics3D::p3mat"],
    Cell[232222, 8155, 292, 8, 40, "Notes",
      CellTags->"Graphics3D::p3mat"],
    Cell[232539, 8167, 67, 1, 38, "ExampleSection",
      CellTags->"Graphics3D::p3mat"],
    Cell[232609, 8170, 192, 5, 24, "Text",
      CellTags->"Graphics3D::p3mat"],
    Cell[232826, 8179, 256, 6, 58, "Input",
      CellTags->"Graphics3D::p3mat"],
    Cell[233085, 8187, 310, 6, 53, "Message",
      CellTags->"Graphics3D::p3mat"],
    Cell[233398, 8195, 189, 5, 21, "Output",
      CellTags->"Graphics3D::p3mat"],
    Cell[233602, 8203, 145, 5, 24, "Text",
      CellTags->"Graphics3D::p3mat"],
    Cell[233772, 8212, 269, 6, 58, "Input",
      CellTags->"Graphics3D::p3mat"],
    Cell[234044, 8220, 189, 5, 21, "Output",
      CellTags->"Graphics3D::p3mat"]},
  "PlotRange::gtype"->{
    Cell[234294, 8232, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[234419, 8238, 391, 11, 21, "Message",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[234813, 8251, 649, 20, 84, "Notes",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235487, 8275, 83, 1, 38, "ExampleSection",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235573, 8278, 209, 5, 24, "Text",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235807, 8287, 150, 3, 26, "Input",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235960, 8292, 189, 4, 21, "Message",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236152, 8298, 151, 3, 21, "Output",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236318, 8304, 104, 1, 24, "Text",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236447, 8309, 160, 3, 26, "Input",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236610, 8314, 203, 5, 21, "Output",
      CellTags->{"PlotRange::gtype", "Show::gtype"}]},
  "Show::gtype"->{
    Cell[234294, 8232, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[234419, 8238, 391, 11, 21, "Message",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[234813, 8251, 649, 20, 84, "Notes",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235487, 8275, 83, 1, 38, "ExampleSection",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235573, 8278, 209, 5, 24, "Text",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235807, 8287, 150, 3, 26, "Input",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[235960, 8292, 189, 4, 21, "Message",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236152, 8298, 151, 3, 21, "Output",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236318, 8304, 104, 1, 24, "Text",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236447, 8309, 160, 3, 26, "Input",
      CellTags->{"PlotRange::gtype", "Show::gtype"}],
    Cell[236610, 8314, 203, 5, 21, "Output",
      CellTags->{"PlotRange::gtype", "Show::gtype"}]},
  "Raster::rsrec"->{
    Cell[236874, 8326, 130, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[237007, 8332, 487, 13, 21, "Message",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[237497, 8347, 418, 9, 62, "Notes",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[237940, 8360, 87, 1, 38, "ExampleSection",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[238030, 8363, 215, 5, 24, "Text",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[238270, 8372, 218, 5, 42, "Input",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[238491, 8379, 244, 5, 37, "Message",
      CellTags->{"RasterArray::rsrec", "Raster::rsrec"}],
    Cell[238738, 8386, 207, 5, 21, "Output",
      CellTags->{"RasterArray::rsrec", "Raster::rsrec"}],
    Cell[238960, 8394, 150, 5, 24, "Text",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[239135, 8403, 243, 6, 42, "Input",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[239381, 8411, 207, 5, 21, "Output",
      CellTags->{"RasterArray::rsrec", "Raster::rsrec"}]},
  "RasterArray::rsrec"->{
    Cell[236874, 8326, 130, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[237007, 8332, 487, 13, 21, "Message",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[237497, 8347, 418, 9, 62, "Notes",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[237940, 8360, 87, 1, 38, "ExampleSection",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[238030, 8363, 215, 5, 24, "Text",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[238270, 8372, 218, 5, 42, "Input",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[238491, 8379, 244, 5, 37, "Message",
      CellTags->{"RasterArray::rsrec", "Raster::rsrec"}],
    Cell[238738, 8386, 207, 5, 21, "Output",
      CellTags->{"RasterArray::rsrec", "Raster::rsrec"}],
    Cell[238960, 8394, 150, 5, 24, "Text",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[239135, 8403, 243, 6, 42, "Input",
      CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
    Cell[239381, 8411, 207, 5, 21, "Output",
      CellTags->{"RasterArray::rsrec", "Raster::rsrec"}]},
  "Raster::rscd"->{
    Cell[239649, 8423, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Raster::rscd", "RasterArray::rscd"}],
    Cell[239778, 8429, 348, 10, 21, "Message",
      CellTags->{"RasterArray::rscd", "Raster::rscd"}],
    Cell[240129, 8441, 215, 6, 24, "Notes",
      CellTags->{"Raster::rscd", "RasterArray::rscd"}]},
  "RasterArray::rscd"->{
    Cell[239649, 8423, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Raster::rscd", "RasterArray::rscd"}],
    Cell[239778, 8429, 348, 10, 21, "Message",
      CellTags->{"RasterArray::rscd", "Raster::rscd"}],
    Cell[240129, 8441, 215, 6, 24, "Notes",
      CellTags->{"Raster::rscd", "RasterArray::rscd"}]},
  "RasterArray::rscol"->{
    Cell[240381, 8452, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RasterArray::rscol"],
    Cell[240473, 8455, 248, 5, 53, "Message",
      CellTags->"RasterArray::rscol"],
    Cell[240724, 8462, 198, 6, 24, "Notes",
      CellTags->"RasterArray::rscol"]},
  "Raster::rsval"->{
    Cell[240959, 8473, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Raster::rsval"],
    Cell[241041, 8476, 208, 5, 37, "Message",
      CellTags->"Raster::rsval"],
    Cell[241252, 8483, 193, 6, 24, "Notes",
      CellTags->"Raster::rsval"]},
  "Show::gcc"->{
    Cell[241482, 8494, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Show::gcc"],
    Cell[241556, 8497, 274, 6, 21, "Message",
      CellTags->"Show::gcc"],
    Cell[241833, 8505, 563, 12, 90, "Notes",
      CellTags->"Show::gcc"],
    Cell[242421, 8521, 59, 1, 38, "ExampleSection",
      CellTags->"Show::gcc"],
    Cell[242483, 8524, 211, 5, 40, "Text",
      CellTags->"Show::gcc"],
    Cell[242719, 8533, 242, 6, 58, "Input",
      CellTags->"Show::gcc"],
    Cell[242964, 8541, 322, 6, 37, "Message",
      CellTags->"Show::gcc"],
    Cell[243289, 8549, 370, 10, 21, "Output",
      CellTags->"Show::gcc"],
    Cell[243674, 8562, 167, 5, 24, "Text",
      CellTags->"Show::gcc"],
    Cell[243866, 8571, 246, 6, 58, "Input",
      CellTags->"Show::gcc"],
    Cell[244115, 8579, 184, 5, 21, "Output",
      CellTags->"Show::gcc"]},
  "Show::gcomb"->{
    Cell[244360, 8591, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Show::gcomb"],
    Cell[244438, 8594, 308, 6, 21, "Message",
      CellTags->"Show::gcomb"],
    Cell[244749, 8602, 236, 6, 40, "Notes",
      CellTags->"Show::gcomb"],
    Cell[245010, 8612, 61, 1, 38, "ExampleSection",
      CellTags->"Show::gcomb"],
    Cell[245074, 8615, 190, 5, 24, "Text",
      CellTags->"Show::gcomb"],
    Cell[245289, 8624, 136, 3, 26, "Input",
      CellTags->"Show::gcomb"],
    Cell[245428, 8629, 329, 7, 53, "Message",
      CellTags->"Show::gcomb"],
    Cell[245760, 8638, 137, 3, 21, "Output",
      CellTags->"Show::gcomb"],
    Cell[245912, 8644, 133, 5, 24, "Text",
      CellTags->"Show::gcomb"],
    Cell[246070, 8653, 163, 4, 42, "Input",
      CellTags->"Show::gcomb"],
    Cell[246236, 8659, 181, 5, 21, "Output",
      CellTags->"Show::gcomb"]},
  "Show::gmed"->{
    Cell[246478, 8671, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Show::gmed"],
    Cell[246554, 8674, 148, 3, 21, "Message",
      CellTags->"Show::gmed"],
    Cell[246705, 8679, 944, 20, 166, "Notes",
      CellTags->"Show::gmed"],
    Cell[247674, 8703, 60, 1, 38, "ExampleSection",
      CellTags->"Show::gmed"],
    Cell[247737, 8706, 156, 4, 24, "Text",
      CellTags->"Show::gmed"],
    Cell[247918, 8714, 128, 3, 26, "Input",
      CellTags->"Show::gmed"],
    Cell[248049, 8719, 164, 4, 21, "Message",
      CellTags->"Show::gmed"],
    Cell[248216, 8725, 180, 5, 21, "Output",
      CellTags->"Show::gmed"]},
  "Show::shx"->{
    Cell[248457, 8737, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Show::shx"],
    Cell[248531, 8740, 139, 3, 21, "Message",
      CellTags->"Show::shx"],
    Cell[248673, 8745, 187, 5, 24, "Notes",
      CellTags->"Show::shx"],
    Cell[248885, 8754, 59, 1, 38, "ExampleSection",
      CellTags->"Show::shx"],
    Cell[248947, 8757, 187, 5, 24, "Text",
      CellTags->"Show::shx"],
    Cell[249159, 8766, 121, 3, 26, "Input",
      CellTags->"Show::shx"],
    Cell[249283, 8771, 155, 4, 21, "Message",
      CellTags->"Show::shx"],
    Cell[249441, 8777, 133, 3, 21, "Output",
      CellTags->"Show::shx"],
    Cell[249589, 8783, 120, 5, 24, "Text",
      CellTags->"Show::shx"],
    Cell[249734, 8792, 178, 4, 42, "Input",
      CellTags->"Show::shx"],
    Cell[249915, 8798, 179, 5, 21, "Output",
      CellTags->"Show::shx"]},
  "Sound::ssnf"->{
    Cell[250155, 8810, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Sound::ssnf"],
    Cell[250233, 8813, 416, 11, 21, "Message",
      CellTags->"Sound::ssnf"],
    Cell[250652, 8826, 202, 6, 24, "Notes",
      CellTags->"Sound::ssnf"],
    Cell[250879, 8836, 61, 1, 38, "ExampleSection",
      CellTags->"Sound::ssnf"],
    Cell[250943, 8839, 225, 6, 40, "Text",
      CellTags->"Sound::ssnf"],
    Cell[251193, 8849, 142, 3, 26, "Input",
      CellTags->"Sound::ssnf"],
    Cell[251338, 8854, 205, 5, 37, "Message",
      CellTags->"Sound::ssnf"],
    Cell[251546, 8861, 178, 5, 21, "Output",
      CellTags->"Sound::ssnf"]},
  "Sound::ssnm"->{
    Cell[251785, 8873, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Sound::ssnm"],
    Cell[251863, 8876, 249, 4, 37, "Message",
      CellTags->"Sound::ssnm"],
    Cell[252115, 8882, 423, 9, 78, "Notes",
      CellTags->"Sound::ssnm"],
    Cell[252563, 8895, 61, 1, 38, "ExampleSection",
      CellTags->"Sound::ssnm"],
    Cell[252627, 8898, 179, 4, 40, "Text",
      CellTags->"Sound::ssnm"],
    Cell[252831, 8906, 125, 3, 26, "Input",
      CellTags->"Sound::ssnm"],
    Cell[252959, 8911, 242, 5, 37, "Message",
      CellTags->"Sound::ssnm"],
    Cell[253204, 8918, 178, 5, 21, "Output",
      CellTags->"Sound::ssnm"]},
  "SurfaceColor::shine"->{
    Cell[253443, 8930, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SurfaceColor::shine"],
    Cell[253537, 8933, 418, 10, 37, "Message",
      CellTags->"SurfaceColor::shine"],
    Cell[253958, 8945, 197, 5, 24, "Notes",
      CellTags->"SurfaceColor::shine"],
    Cell[254180, 8954, 69, 1, 38, "ExampleSection",
      CellTags->"SurfaceColor::shine"],
    Cell[254252, 8957, 249, 7, 40, "Text",
      CellTags->"SurfaceColor::shine"],
    Cell[254526, 8968, 248, 6, 58, "Input",
      CellTags->"SurfaceColor::shine"],
    Cell[254777, 8976, 356, 6, 69, "Message",
      CellTags->"SurfaceColor::shine"],
    Cell[255136, 8984, 191, 5, 21, "Output",
      CellTags->"SurfaceColor::shine"],
    Cell[255342, 8992, 141, 5, 24, "Text",
      CellTags->"SurfaceColor::shine"],
    Cell[255508, 9001, 224, 5, 58, "Input",
      CellTags->"SurfaceColor::shine"],
    Cell[255735, 9008, 191, 5, 21, "Output",
      CellTags->"SurfaceColor::shine"]},
  "SurfaceColor::specl"->{
    Cell[255987, 9020, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SurfaceColor::specl"],
    Cell[256081, 9023, 440, 10, 37, "Message",
      CellTags->"SurfaceColor::specl"],
    Cell[256524, 9035, 199, 5, 24, "Notes",
      CellTags->"SurfaceColor::specl"],
    Cell[256748, 9044, 69, 1, 38, "ExampleSection",
      CellTags->"SurfaceColor::specl"],
    Cell[256820, 9047, 213, 5, 40, "Text",
      CellTags->"SurfaceColor::specl"],
    Cell[257058, 9056, 210, 5, 42, "Input",
      CellTags->"SurfaceColor::specl"],
    Cell[257271, 9063, 324, 6, 69, "Message",
      CellTags->"SurfaceColor::specl"],
    Cell[257598, 9071, 191, 5, 21, "Output",
      CellTags->"SurfaceColor::specl"],
    Cell[257804, 9079, 138, 5, 24, "Text",
      CellTags->"SurfaceColor::specl"],
    Cell[257967, 9088, 221, 5, 42, "Input",
      CellTags->"SurfaceColor::specl"],
    Cell[258191, 9095, 191, 5, 21, "Output",
      CellTags->"SurfaceColor::specl"]},
  "SurfaceGraphics::pmsr"->{
    Cell[258443, 9107, 202, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[258648, 9115, 581, 14, 37, "Message",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259232, 9131, 327, 8, 40, "Notes",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259584, 9143, 126, 2, 38, "ExampleSection",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259713, 9147, 373, 10, 40, "Text",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[260111, 9161, 360, 7, 74, "Input",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[260474, 9170, 386, 7, 53, "Message",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}],
    Cell[260863, 9179, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}],
    Cell[261131, 9188, 267, 8, 24, "Text",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[261423, 9200, 362, 7, 74, "Input",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[261788, 9209, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}]},
  "DensityGraphics::pmsr"->{
    Cell[258443, 9107, 202, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[258648, 9115, 581, 14, 37, "Message",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259232, 9131, 327, 8, 40, "Notes",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259584, 9143, 126, 2, 38, "ExampleSection",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259713, 9147, 373, 10, 40, "Text",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[260111, 9161, 360, 7, 74, "Input",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[260474, 9170, 386, 7, 53, "Message",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}],
    Cell[260863, 9179, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}],
    Cell[261131, 9188, 267, 8, 24, "Text",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[261423, 9200, 362, 7, 74, "Input",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[261788, 9209, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}]},
  "ContourGraphics::pmsr"->{
    Cell[258443, 9107, 202, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[258648, 9115, 581, 14, 37, "Message",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259232, 9131, 327, 8, 40, "Notes",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259584, 9143, 126, 2, 38, "ExampleSection",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[259713, 9147, 373, 10, 40, "Text",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[260111, 9161, 360, 7, 74, "Input",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[260474, 9170, 386, 7, 53, "Message",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}],
    Cell[260863, 9179, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}],
    Cell[261131, 9188, 267, 8, 24, "Text",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[261423, 9200, 362, 7, 74, "Input",
      CellTags->{
      "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
        "ContourGraphics::pmsr"}],
    Cell[261788, 9209, 253, 6, 21, "Output",
      CellTags->{
      "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
        "SurfaceGraphics::pmsr"}]},
  "SurfaceGraphics::shade"->{
    Cell[262102, 9222, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SurfaceGraphics::shade"],
    Cell[262202, 9225, 293, 6, 37, "Message",
      CellTags->"SurfaceGraphics::shade"],
    Cell[262498, 9233, 861, 24, 116, "Notes",
      CellTags->"SurfaceGraphics::shade"],
    Cell[263384, 9261, 72, 1, 38, "ExampleSection",
      CellTags->"SurfaceGraphics::shade"],
    Cell[263459, 9264, 290, 6, 40, "Text",
      CellTags->"SurfaceGraphics::shade"],
    Cell[263774, 9274, 335, 7, 74, "Input",
      CellTags->"SurfaceGraphics::shade"],
    Cell[264112, 9283, 387, 7, 53, "Message",
      CellTags->"SurfaceGraphics::shade"],
    Cell[264502, 9292, 199, 5, 21, "Output",
      CellTags->"SurfaceGraphics::shade"],
    Cell[264716, 9300, 129, 4, 24, "Text",
      CellTags->"SurfaceGraphics::shade"],
    Cell[264870, 9308, 373, 7, 90, "Input",
      CellTags->"SurfaceGraphics::shade"],
    Cell[265246, 9317, 199, 5, 21, "Output",
      CellTags->"SurfaceGraphics::shade"]},
  "Text::textn"->{
    Cell[265506, 9329, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Text::textn"],
    Cell[265584, 9332, 239, 6, 21, "Message",
      CellTags->"Text::textn"],
    Cell[265826, 9340, 185, 5, 24, "Notes",
      CellTags->"Text::textn"],
    Cell[266036, 9349, 61, 1, 38, "ExampleSection",
      CellTags->"Text::textn"],
    Cell[266100, 9352, 198, 5, 24, "Text",
      CellTags->"Text::textn"],
    Cell[266323, 9361, 176, 5, 26, "Input",
      CellTags->"Text::textn"],
    Cell[266502, 9368, 175, 4, 21, "Message",
      CellTags->"Text::textn"],
    Cell[266680, 9374, 181, 5, 21, "Output",
      CellTags->"Text::textn"],
    Cell[266876, 9382, 122, 5, 24, "Text",
      CellTags->"Text::textn"],
    Cell[267023, 9391, 181, 5, 42, "Input",
      CellTags->"Text::textn"],
    Cell[267207, 9398, 181, 5, 21, "Output",
      CellTags->"Text::textn"]},
  "Text::textz"->{
    Cell[267449, 9410, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Text::textz"],
    Cell[267527, 9413, 167, 3, 21, "Message",
      CellTags->"Text::textz"],
    Cell[267697, 9418, 189, 7, 24, "Notes",
      CellTags->"Text::textz"],
    Cell[267911, 9429, 61, 1, 38, "ExampleSection",
      CellTags->"Text::textz"],
    Cell[267975, 9432, 190, 6, 24, "Text",
      CellTags->"Text::textz"],
    Cell[268190, 9442, 183, 5, 42, "Input",
      CellTags->"Text::textz"],
    Cell[268376, 9449, 179, 4, 21, "Message",
      CellTags->"Text::textz"],
    Cell[268558, 9455, 181, 5, 21, "Output",
      CellTags->"Text::textz"],
    Cell[268754, 9463, 122, 5, 24, "Text",
      CellTags->"Text::textz"],
    Cell[268901, 9472, 183, 5, 42, "Input",
      CellTags->"Text::textz"],
    Cell[269087, 9479, 181, 5, 21, "Output",
      CellTags->"Text::textz"]},
  "AbsoluteThickness::thkn"->{
    Cell[269329, 9491, 144, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[269476, 9497, 406, 11, 21, "Message",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[269885, 9510, 253, 7, 24, "Notes",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270163, 9521, 94, 1, 38, "ExampleSection",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270260, 9524, 217, 5, 24, "Text",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270502, 9533, 250, 5, 42, "Input",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270755, 9540, 234, 5, 21, "Message",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270992, 9547, 234, 5, 21, "Message",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271229, 9554, 221, 5, 21, "Output",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271465, 9562, 161, 5, 24, "Text",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271651, 9571, 248, 5, 42, "Input",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271902, 9578, 221, 5, 21, "Output",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}]},
  "Thickness::thkn"->{
    Cell[269329, 9491, 144, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[269476, 9497, 406, 11, 21, "Message",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[269885, 9510, 253, 7, 24, "Notes",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270163, 9521, 94, 1, 38, "ExampleSection",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270260, 9524, 217, 5, 24, "Text",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270502, 9533, 250, 5, 42, "Input",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270755, 9540, 234, 5, 21, "Message",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[270992, 9547, 234, 5, 21, "Message",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271229, 9554, 221, 5, 21, "Output",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271465, 9562, 161, 5, 24, "Text",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271651, 9571, 248, 5, 42, "Input",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
    Cell[271902, 9578, 221, 5, 21, "Output",
      CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}]},
  "Ticks::ticks"->{
    Cell[272184, 9590, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Ticks::ticks"],
    Cell[272264, 9593, 212, 5, 21, "Message",
      CellTags->"Ticks::ticks"],
    Cell[272479, 9600, 318, 10, 40, "Notes",
      CellTags->"Ticks::ticks"],
    Cell[272822, 9614, 62, 1, 38, "ExampleSection",
      CellTags->"Ticks::ticks"],
    Cell[272887, 9617, 255, 6, 40, "Text",
      CellTags->"Ticks::ticks"],
    Cell[273167, 9627, 172, 4, 26, "Input",
      CellTags->"Ticks::ticks"],
    Cell[273342, 9633, 235, 5, 21, "Message",
      CellTags->"Ticks::ticks"],
    Cell[273580, 9640, 182, 5, 21, "Output",
      CellTags->"Ticks::ticks"],
    Cell[273777, 9648, 163, 5, 24, "Text",
      CellTags->"Ticks::ticks"],
    Cell[273965, 9657, 182, 5, 42, "Input",
      CellTags->"Ticks::ticks"],
    Cell[274150, 9664, 182, 5, 21, "Output",
      CellTags->"Ticks::ticks"]},
  "ColorOutput::colpc"->{
    Cell[274393, 9676, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[274528, 9682, 713, 17, 53, "Message",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[275244, 9701, 403, 8, 62, "Notes",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[275672, 9713, 88, 1, 38, "ExampleSection",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[275763, 9716, 272, 6, 40, "Text",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276060, 9726, 185, 4, 26, "Input",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276248, 9732, 416, 7, 69, "Message",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276667, 9741, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276890, 9749, 166, 5, 24, "Text",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[277081, 9758, 187, 4, 26, "Input",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[277271, 9764, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}]},
  "ToColor::colpc"->{
    Cell[274393, 9676, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[274528, 9682, 713, 17, 53, "Message",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[275244, 9701, 403, 8, 62, "Notes",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[275672, 9713, 88, 1, 38, "ExampleSection",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[275763, 9716, 272, 6, 40, "Text",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276060, 9726, 185, 4, 26, "Input",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276248, 9732, 416, 7, 69, "Message",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276667, 9741, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[276890, 9749, 166, 5, 24, "Text",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[277081, 9758, 187, 4, 26, "Input",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
    Cell[277271, 9764, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpc", "ToColor::colpc"}]},
  "ColorOutput::colpw"->{
    Cell[277540, 9776, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[277675, 9782, 675, 16, 37, "Message",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[278353, 9800, 403, 8, 62, "Notes",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[278781, 9812, 88, 1, 38, "ExampleSection",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[278872, 9815, 288, 7, 40, "Text",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279185, 9826, 183, 4, 26, "Input",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279371, 9832, 361, 7, 69, "Message",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279735, 9841, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279958, 9849, 166, 5, 24, "Text",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[280149, 9858, 196, 4, 26, "Input",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[280348, 9864, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}]},
  "ToColor::colpw"->{
    Cell[277540, 9776, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[277675, 9782, 675, 16, 37, "Message",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[278353, 9800, 403, 8, 62, "Notes",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[278781, 9812, 88, 1, 38, "ExampleSection",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[278872, 9815, 288, 7, 40, "Text",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279185, 9826, 183, 4, 26, "Input",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279371, 9832, 361, 7, 69, "Message",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279735, 9841, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[279958, 9849, 166, 5, 24, "Text",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[280149, 9858, 196, 4, 26, "Input",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
    Cell[280348, 9864, 208, 5, 21, "Output",
      CellTags->{"ColorOutput::colpw", "ToColor::colpw"}]},
  "ToColor::tocol"->{
    Cell[280617, 9876, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToColor::tocol"],
    Cell[280701, 9879, 270, 6, 37, "Message",
      CellTags->"ToColor::tocol"],
    Cell[280974, 9887, 188, 5, 24, "Notes",
      CellTags->"ToColor::tocol"],
    Cell[281187, 9896, 64, 1, 38, "ExampleSection",
      CellTags->"ToColor::tocol"],
    Cell[281254, 9899, 136, 4, 24, "Text",
      CellTags->"ToColor::tocol"],
    Cell[281415, 9907, 107, 3, 26, "Input",
      CellTags->"ToColor::tocol"],
    Cell[281525, 9912, 206, 5, 37, "Message",
      CellTags->"ToColor::tocol"],
    Cell[281734, 9919, 108, 3, 21, "Output",
      CellTags->"ToColor::tocol"],
    Cell[281857, 9925, 128, 5, 24, "Text",
      CellTags->"ToColor::tocol"],
    Cell[282010, 9934, 118, 3, 26, "Input",
      CellTags->"ToColor::tocol"],
    Cell[282131, 9939, 111, 3, 21, "Output",
      CellTags->"ToColor::tocol"]},
  "General::colfun"->{
    Cell[282303, 9949, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::colfun"],
    Cell[282389, 9952, 642, 18, 37, "Message",
      CellTags->"General::colfun"],
    Cell[283034, 9972, 246, 6, 40, "Notes",
      CellTags->"General::colfun"],
    Cell[283305, 9982, 65, 1, 38, "ExampleSection",
      CellTags->"General::colfun"],
    Cell[283373, 9985, 261, 8, 40, "Text",
      CellTags->"General::colfun"],
    Cell[283659, 9997, 171, 5, 26, "Input",
      CellTags->"General::colfun"],
    Cell[283833, 10004, 202, 5, 21, "Message",
      CellTags->"General::colfun"],
    Cell[284038, 10011, 269, 5, 53, "Message",
      CellTags->"General::colfun"],
    Cell[284310, 10018, 201, 5, 21, "Message",
      CellTags->"General::colfun"],
    Cell[284514, 10025, 269, 5, 53, "Message",
      CellTags->"General::colfun"],
    Cell[284786, 10032, 201, 5, 21, "Message",
      CellTags->"General::colfun"],
    Cell[284990, 10039, 223, 5, 37, "Message",
      CellTags->"General::colfun"],
    Cell[285216, 10046, 269, 5, 53, "Message",
      CellTags->"General::colfun"],
    Cell[285488, 10053, 235, 5, 37, "Message",
      CellTags->"General::colfun"],
    Cell[285726, 10060, 192, 5, 21, "Output",
      CellTags->"General::colfun"],
    Cell[285933, 10068, 145, 5, 24, "Text",
      CellTags->"General::colfun"],
    Cell[286103, 10077, 192, 5, 42, "Input",
      CellTags->"General::colfun"],
    Cell[286298, 10084, 192, 5, 21, "Output",
      CellTags->"General::colfun"]},
  "General::colfun1"->{
    Cell[286551, 10096, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::colfun1"],
    Cell[286639, 10099, 565, 15, 37, "Message",
      CellTags->"General::colfun1"],
    Cell[287207, 10116, 253, 6, 40, "Notes",
      CellTags->"General::colfun1"],
    Cell[287485, 10126, 66, 1, 38, "ExampleSection",
      CellTags->"General::colfun1"],
    Cell[287554, 10129, 239, 6, 40, "Text",
      CellTags->"General::colfun1"],
    Cell[287818, 10139, 246, 6, 42, "Input",
      CellTags->"General::colfun1"],
    Cell[288067, 10147, 379, 7, 69, "Message",
      CellTags->"General::colfun1"],
    Cell[288449, 10156, 379, 7, 69, "Message",
      CellTags->"General::colfun1"],
    Cell[288831, 10165, 193, 5, 21, "Output",
      CellTags->"General::colfun1"],
    Cell[289039, 10173, 146, 5, 24, "Text",
      CellTags->"General::colfun1"],
    Cell[289210, 10182, 251, 6, 42, "Input",
      CellTags->"General::colfun1"],
    Cell[289464, 10190, 193, 5, 21, "Output",
      CellTags->"General::colfun1"]},
  "RasterGraphics::argx"->{
    Cell[289718, 10202, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RasterGraphics::argx"],
    Cell[289814, 10205, 194, 3, 37, "Message",
      CellTags->"RasterGraphics::argx"],
    Cell[290011, 10210, 131, 4, 24, "Notes",
      CellTags->"RasterGraphics::argx"]},
  "RasterGraphics::rrng"->{
    Cell[290179, 10219, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RasterGraphics::rrng"],
    Cell[290275, 10222, 230, 4, 37, "Message",
      CellTags->"RasterGraphics::rrng"],
    Cell[290508, 10228, 131, 4, 24, "Notes",
      CellTags->"RasterGraphics::rrng"]},
  "RasterGraphics::optx"->{
    Cell[290676, 10237, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RasterGraphics::optx"],
    Cell[290772, 10240, 158, 3, 21, "Message",
      CellTags->"RasterGraphics::optx"],
    Cell[290933, 10245, 131, 4, 24, "Notes",
      CellTags->"RasterGraphics::optx"]},
  "RasterGraphics::nonopt"->{
    Cell[291101, 10254, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RasterGraphics::nonopt"],
    Cell[291201, 10257, 275, 5, 37, "Message",
      CellTags->"RasterGraphics::nonopt"],
    Cell[291479, 10264, 133, 4, 24, "Notes",
      CellTags->"RasterGraphics::nonopt"]},
  "RasterGraphics::gmat"->{
    Cell[291649, 10273, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RasterGraphics::gmat"],
    Cell[291745, 10276, 176, 3, 21, "Message",
      CellTags->"RasterGraphics::gmat"],
    Cell[291924, 10281, 131, 4, 24, "Notes",
      CellTags->"RasterGraphics::gmat"]},
  "RasterGraphics::zval"->{
    Cell[292092, 10290, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RasterGraphics::zval"],
    Cell[292188, 10293, 212, 4, 37, "Message",
      CellTags->"RasterGraphics::zval"],
    Cell[292403, 10299, 131, 4, 24, "Notes",
      CellTags->"RasterGraphics::zval"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SurfaceColor::albedo", 293233, 10324},
  {"SurfaceGraphics::clip", 293949, 10341},
  {"Graphics3D::ltcol", 294672, 10358},
  {"Raster::rslim", 295683, 10383},
  {"GraphicsArray::arrsp", 296578, 10406},
  {"Contours::ctnl", 297545, 10429},
  {"General::nlist3", 298448, 10452},
  {"ParametricPlot3D::glims", 299370, 10475},
  {"ContourPlot::glims", 301246, 10520},
  {"DensityPlot::glims", 303122, 10565},
  {"Plot3D::glims", 304993, 10610},
  {"Graphics::realp", 306866, 10655},
  {"Graphics::realu", 307545, 10672},
  {"MeshStyle::mesh", 308224, 10689},
  {"PlotRange::prng", 309144, 10712},
  {"ViewCenter::viewc", 310626, 10749},
  {"ViewPoint::viewp", 311658, 10774},
  {"SurfaceGraphics::noproj", 312684, 10799},
  {"Graphics3D::noproj", 314079, 10824},
  {"Graphics3D::gsing", 315473, 10849},
  {"Plot3D::gsing", 316935, 10878},
  {"PlotRegion::plotr", 318401, 10907},
  {"ViewVertical::viewv", 319351, 10930},
  {"AspectRatio::aspr", 320158, 10949},
  {"Axes::axes", 320856, 10966},
  {"AxesEdge::axedg", 321802, 10991},
  {"ParametricPlot::pldiv", 322814, 11016},
  {"Plot::pldiv", 323989, 11039},
  {"GridLines::grid", 325168, 11062},
  {"Circle::angle", 326093, 11085},
  {"Disk::angle", 326991, 11108},
  {"Circle::radius", 327870, 11131},
  {"Disk::radius", 328780, 11154},
  {"ColorOutput::colpn", 329674, 11177},
  {"ToColor::colpn", 331568, 11214},
  {"ContourGraphics::ctpnt", 333470, 11251},
  {"ContourGraphics::ctsm", 335183, 11290},
  {"ContourGraphics::gmat", 336964, 11331},
  {"DensityGraphics::gmat", 338712, 11376},
  {"SurfaceGraphics::gmat", 340460, 11421},
  {"ContourGraphics::meshr", 342209, 11466},
  {"DensityGraphics::meshr", 343992, 11511},
  {"SurfaceGraphics::meshr", 345775, 11556},
  {"ContourPlot::pllim", 347554, 11601},
  {"DensityPlot::pllim", 351991, 11697},
  {"ParametricPlot::pllim", 356431, 11793},
  {"Plot3D::pllim", 360863, 11889},
  {"Plot::pllim", 365293, 11985},
  {"ParametricPlot3D::pllim", 369735, 12081},
  {"Play::pllim", 374165, 12177},
  {"Play::plx", 378593, 12273},
  {"ContourPlot::plnr", 379457, 12296},
  {"DensityPlot::plnr", 383944, 12371},
  {"Plot::plnr", 388424, 12446},
  {"ContourPlot::pptt", 392911, 12521},
  {"DensityPlot::pptt", 394303, 12544},
  {"Plot3D::pptt", 395690, 12567},
  {"ContourSmoothing::ctnsm", 397088, 12590},
  {"Dashing::dshn", 397845, 12607},
  {"AbsoluteDashing::dshn", 399172, 12632},
  {"DefaultFont::dfont", 400496, 12657},
  {"DefaultFont::font", 401467, 12680},
  {"General::zval", 401756, 12687},
  {"Display::badargs", 402438, 12704},
  {"Display::dispgif", 402727, 12711},
  {"Display::dopen", 403014, 12718},
  {"Display::dwrite", 403781, 12737},
  {"Display::fname", 404556, 12756},
  {"Display::gfile", 405241, 12773},
  {"Display::image", 405927, 12790},
  {"Export::image", 406952, 12807},
  {"ExportString::image", 407983, 12824},
  {"Display::noform", 409010, 12841},
  {"Display::nolink", 409707, 12858},
  {"Display::pserr", 409992, 12865},
  {"Display::type", 410274, 12872},
  {"FaceGrids::fglst", 411342, 12899},
  {"FaceGrids::fgstl", 412533, 12928},
  {"FaceGrids::gface", 413481, 12951},
  {"FontForm::ffsp", 414677, 12980},
  {"FrameLabel::fmlab", 415286, 12995},
  {"General::lspec", 416326, 13020},
  {"Graphics3D::ambnt", 417253, 13043},
  {"General::color", 418210, 13066},
  {"General::gprim", 419137, 13089},
  {"General::pcolor", 420305, 13118},
  {"General::plln", 421486, 13147},
  {"General::rawvar", 422402, 13170},
  {"Graphics3D::lights", 422691, 13177},
  {"Graphics3D::boxz", 423662, 13200},
  {"Graphics3D::gsort", 423952, 13207},
  {"Graphics3D::psvf", 424244, 13214},
  {"Graphics::gpt", 424531, 13221},
  {"Graphics::gptn", 425684, 13250},
  {"Graphics::hue", 426606, 13273},
  {"GraphicsArray::prim", 427523, 13296},
  {"ListPlay::lsamps", 428503, 13319},
  {"ListPlay::silent", 429450, 13342},
  {"ListPlot::lpn", 430394, 13365},
  {"ParametricPlot3D::ppfun", 430681, 13372},
  {"ParametricPlot3D::pplr", 431711, 13395},
  {"ParametricPlot3D::ppta", 433086, 13426},
  {"ParametricPlot3D::ppx", 434104, 13449},
  {"ParametricPlot::bend", 434412, 13456},
  {"Plot::bend", 435575, 13479},
  {"ParametricPlot::plld", 436748, 13502},
  {"Plot::plld", 439249, 13556},
  {"Plot3D::plld", 441752, 13610},
  {"ContourPlot::plld", 444260, 13664},
  {"DensityPlot::plld", 446768, 13718},
  {"ParametricPlot3D::plld", 449281, 13772},
  {"Play::plld", 451782, 13826},
  {"ParametricPlot::pptr", 454293, 13880},
  {"ParametricPlot::ppts", 455637, 13911},
  {"ParametricPlot3D::ppts", 457176, 13945},
  {"Plot::ppts", 458703, 13979},
  {"Play::pfnum", 460231, 14013},
  {"Play::playr", 461118, 14036},
  {"ListPlay::playr", 462242, 14059},
  {"Play::sample", 463363, 14082},
  {"Play::sdep", 463636, 14089},
  {"ListPlay::sdep", 464737, 14112},
  {"Play::srate", 465835, 14135},
  {"ListPlay::srate", 466959, 14158},
  {"Plot3D::plnc", 468080, 14181},
  {"Plot3D::gval", 469533, 14218},
  {"Graphics3D::p3mat", 471768, 14275},
  {"PlotRange::gtype", 472726, 14298},
  {"Show::gtype", 473858, 14321},
  {"Raster::rsrec", 474992, 14344},
  {"RasterArray::rsrec", 476174, 14367},
  {"Raster::rscd", 477350, 14390},
  {"RasterArray::rscd", 477699, 14397},
  {"RasterArray::rscol", 478049, 14404},
  {"Raster::rsval", 478341, 14411},
  {"Show::gcc", 478614, 14418},
  {"Show::gcomb", 479481, 14441},
  {"Show::gmed", 480367, 14464},
  {"Show::shx", 481018, 14481},
  {"Sound::ssnf", 481883, 14504},
  {"Sound::ssnm", 482543, 14521},
  {"SurfaceColor::shine", 483210, 14538},
  {"SurfaceColor::specl", 484194, 14561},
  {"SurfaceGraphics::pmsr", 485180, 14584},
  {"DensityGraphics::pmsr", 486939, 14629},
  {"ContourGraphics::pmsr", 488698, 14674},
  {"SurfaceGraphics::shade", 490458, 14719},
  {"Text::textn", 491468, 14742},
  {"Text::textz", 492355, 14765},
  {"AbsoluteThickness::thkn", 493254, 14788},
  {"Thickness::thkn", 494621, 14813},
  {"Ticks::ticks", 495985, 14838},
  {"ColorOutput::colpc", 496891, 14861},
  {"ToColor::colpc", 498080, 14884},
  {"ColorOutput::colpw", 499273, 14907},
  {"ToColor::colpw", 500462, 14930},
  {"ToColor::tocol", 501651, 14953},
  {"General::colfun", 502575, 14976},
  {"General::colfun1", 504098, 15013},
  {"RasterGraphics::argx", 505145, 15038},
  {"RasterGraphics::rrng", 505453, 15045},
  {"RasterGraphics::optx", 505761, 15052},
  {"RasterGraphics::nonopt", 506071, 15059},
  {"RasterGraphics::gmat", 506385, 15066},
  {"RasterGraphics::zval", 506693, 15073}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 25, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1826, 57, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SurfaceColor::albedo"],
Cell[1922, 60, 404, 9, 37, "Message",
  CellTags->"SurfaceColor::albedo"],
Cell[2329, 71, 1223, 49, 84, "Notes",
  CellTags->"SurfaceColor::albedo"],

Cell[CellGroupData[{
Cell[3577, 124, 70, 1, 38, "ExampleSection",
  CellTags->"SurfaceColor::albedo"],
Cell[3650, 127, 292, 7, 40, "Text",
  CellTags->"SurfaceColor::albedo"],

Cell[CellGroupData[{
Cell[3967, 138, 202, 5, 42, "Input",
  CellTags->"SurfaceColor::albedo"],
Cell[4172, 145, 299, 6, 53, "Message",
  CellTags->"SurfaceColor::albedo"],
Cell[4474, 153, 192, 5, 21, "Output",
  CellTags->"SurfaceColor::albedo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4727, 165, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SurfaceGraphics::clip"],
Cell[4825, 168, 334, 6, 37, "Message",
  CellTags->"SurfaceGraphics::clip"],
Cell[5162, 176, 587, 16, 84, "Notes",
  CellTags->"SurfaceGraphics::clip"],

Cell[CellGroupData[{
Cell[5774, 196, 71, 1, 38, "ExampleSection",
  CellTags->"SurfaceGraphics::clip"],
Cell[5848, 199, 343, 10, 40, "Text",
  CellTags->"SurfaceGraphics::clip"],

Cell[CellGroupData[{
Cell[6216, 213, 177, 4, 42, "Input",
  CellTags->"SurfaceGraphics::clip"],
Cell[6396, 219, 260, 5, 53, "Message",
  CellTags->"SurfaceGraphics::clip"],
Cell[6659, 226, 198, 5, 21, "Output",
  CellTags->"SurfaceGraphics::clip"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6918, 238, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics3D::ltcol"],
Cell[7008, 241, 429, 10, 37, "Message",
  CellTags->"Graphics3D::ltcol"],
Cell[7440, 253, 1496, 58, 116, "Notes",
  CellTags->"Graphics3D::ltcol"],

Cell[CellGroupData[{
Cell[8961, 315, 67, 1, 38, "ExampleSection",
  CellTags->"Graphics3D::ltcol"],
Cell[9031, 318, 202, 5, 24, "Text",
  CellTags->"Graphics3D::ltcol"],

Cell[CellGroupData[{
Cell[9258, 327, 184, 4, 42, "Input",
  CellTags->"Graphics3D::ltcol"],
Cell[9445, 333, 300, 6, 53, "Message",
  CellTags->"Graphics3D::ltcol"],
Cell[9748, 341, 286, 6, 53, "Message",
  CellTags->"Graphics3D::ltcol"],
Cell[10037, 349, 194, 5, 21, "Output",
  CellTags->"Graphics3D::ltcol"]
}, Open  ]],
Cell[10246, 357, 247, 8, 40, "Text",
  CellTags->"Graphics3D::ltcol"],

Cell[CellGroupData[{
Cell[10518, 369, 191, 4, 42, "Input",
  CellTags->"Graphics3D::ltcol"],
Cell[10712, 375, 194, 5, 21, "Output",
  CellTags->"Graphics3D::ltcol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10967, 387, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Raster::rslim"],
Cell[11049, 390, 330, 8, 37, "Message",
  CellTags->"Raster::rslim"],
Cell[11382, 400, 322, 8, 46, "Notes",
  CellTags->"Raster::rslim"],

Cell[CellGroupData[{
Cell[11729, 412, 63, 1, 38, "ExampleSection",
  CellTags->"Raster::rslim"],
Cell[11795, 415, 237, 6, 40, "Text",
  CellTags->"Raster::rslim"],

Cell[CellGroupData[{
Cell[12057, 425, 250, 6, 58, "Input",
  CellTags->"Raster::rslim"],
Cell[12310, 433, 223, 5, 37, "Message",
  CellTags->"Raster::rslim"],
Cell[12536, 440, 183, 5, 21, "Output",
  CellTags->"Raster::rslim"]
}, Open  ]],
Cell[12734, 448, 85, 1, 24, "Text",
  CellTags->"Raster::rslim"],

Cell[CellGroupData[{
Cell[12844, 453, 250, 6, 58, "Input",
  CellTags->"Raster::rslim"],
Cell[13097, 461, 183, 5, 21, "Output",
  CellTags->"Raster::rslim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13341, 473, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"GraphicsArray::arrsp"],
Cell[13437, 476, 334, 6, 37, "Message",
  CellTags->"GraphicsArray::arrsp"],
Cell[13774, 484, 251, 7, 40, "Notes",
  CellTags->"GraphicsArray::arrsp"],

Cell[CellGroupData[{
Cell[14050, 495, 70, 1, 38, "ExampleSection",
  CellTags->"GraphicsArray::arrsp"],
Cell[14123, 498, 282, 7, 40, "Text",
  CellTags->"GraphicsArray::arrsp"],

Cell[CellGroupData[{
Cell[14430, 509, 275, 8, 58, "Input",
  CellTags->"GraphicsArray::arrsp"],
Cell[14708, 519, 265, 5, 53, "Message",
  CellTags->"GraphicsArray::arrsp"],
Cell[14976, 526, 195, 5, 21, "Output",
  CellTags->"GraphicsArray::arrsp"]
}, Open  ]],
Cell[15186, 534, 149, 5, 24, "Text",
  CellTags->"GraphicsArray::arrsp"],

Cell[CellGroupData[{
Cell[15360, 543, 270, 8, 58, "Input",
  CellTags->"GraphicsArray::arrsp"],
Cell[15633, 553, 195, 5, 21, "Output",
  CellTags->"GraphicsArray::arrsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15889, 565, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Contours::ctnl"],
Cell[15973, 568, 294, 6, 37, "Message",
  CellTags->"Contours::ctnl"],
Cell[16270, 576, 548, 17, 68, "Notes",
  CellTags->"Contours::ctnl"],

Cell[CellGroupData[{
Cell[16843, 597, 64, 1, 38, "ExampleSection",
  CellTags->"Contours::ctnl"],
Cell[16910, 600, 172, 5, 24, "Text",
  CellTags->"Contours::ctnl"],

Cell[CellGroupData[{
Cell[17107, 609, 160, 4, 26, "Input",
  CellTags->"Contours::ctnl"],
Cell[17270, 615, 224, 5, 37, "Message",
  CellTags->"Contours::ctnl"],
Cell[17497, 622, 191, 5, 21, "Output",
  CellTags->"Contours::ctnl"]
}, Open  ]],
Cell[17703, 630, 138, 4, 24, "Text",
  CellTags->"Contours::ctnl"],

Cell[CellGroupData[{
Cell[17866, 638, 162, 4, 26, "Input",
  CellTags->"Contours::ctnl"],
Cell[18031, 644, 191, 5, 21, "Output",
  CellTags->"Contours::ctnl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18283, 656, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nlist3"],
Cell[18369, 659, 387, 11, 21, "Message",
  CellTags->"General::nlist3"],
Cell[18759, 672, 342, 7, 62, "Notes",
  CellTags->"General::nlist3"],

Cell[CellGroupData[{
Cell[19126, 683, 65, 1, 38, "ExampleSection",
  CellTags->"General::nlist3"],
Cell[19194, 686, 199, 5, 24, "Text",
  CellTags->"General::nlist3"],

Cell[CellGroupData[{
Cell[19418, 695, 150, 4, 26, "Input",
  CellTags->"General::nlist3"],
Cell[19571, 701, 184, 4, 21, "Message",
  CellTags->"General::nlist3"],
Cell[19758, 707, 192, 5, 21, "Output",
  CellTags->"General::nlist3"]
}, Open  ]],
Cell[19965, 715, 185, 6, 24, "Text",
  CellTags->"General::nlist3"],

Cell[CellGroupData[{
Cell[20175, 725, 158, 4, 26, "Input",
  CellTags->"General::nlist3"],
Cell[20336, 731, 192, 5, 21, "Output",
  CellTags->"General::nlist3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20589, 743, 230, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],
Cell[20822, 753, 534, 15, 37, "Message",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],
Cell[21359, 770, 244, 6, 24, "Notes",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[CellGroupData[{
Cell[21628, 780, 144, 3, 38, "ExampleSection",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],
Cell[21775, 785, 222, 6, 24, "Text",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[CellGroupData[{
Cell[22022, 795, 206, 5, 26, "Input",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],
Cell[22231, 802, 310, 7, 37, "Message",
  CellTags->{
  "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
    "Plot3D::glims"}],
Cell[22544, 811, 207, 5, 21, "Output",
  CellTags->{
  "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
    "Plot3D::glims"}]
}, Open  ]],
Cell[22766, 819, 205, 7, 24, "Text",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],

Cell[CellGroupData[{
Cell[22996, 830, 206, 5, 26, "Input",
  CellTags->{
  "ParametricPlot3D::glims", "ContourPlot::glims", "DensityPlot::glims", 
    "Plot3D::glims"}],
Cell[23205, 837, 271, 7, 21, "Output",
  CellTags->{
  "ContourPlot::glims", "DensityPlot::glims", "ParametricPlot3D::glims", 
    "Plot3D::glims"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23537, 851, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics::realp"],
Cell[23623, 854, 252, 6, 21, "Message",
  CellTags->"Graphics::realp"],
Cell[23878, 862, 308, 7, 62, "Notes",
  CellTags->"Graphics::realp"],

Cell[CellGroupData[{
Cell[24211, 873, 65, 1, 38, "ExampleSection",
  CellTags->"Graphics::realp"],
Cell[24279, 876, 240, 6, 40, "Text",
  CellTags->"Graphics::realp"],

Cell[CellGroupData[{
Cell[24544, 886, 144, 3, 26, "Input",
  CellTags->"Graphics::realp"],
Cell[24691, 891, 212, 5, 37, "Message",
  CellTags->"Graphics::realp"],
Cell[24906, 898, 185, 5, 21, "Output",
  CellTags->"Graphics::realp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25152, 910, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics::realu"],
Cell[25238, 913, 251, 6, 21, "Message",
  CellTags->"Graphics::realu"],
Cell[25492, 921, 308, 7, 62, "Notes",
  CellTags->"Graphics::realu"],

Cell[CellGroupData[{
Cell[25825, 932, 65, 1, 38, "ExampleSection",
  CellTags->"Graphics::realu"],
Cell[25893, 935, 230, 6, 40, "Text",
  CellTags->"Graphics::realu"],

Cell[CellGroupData[{
Cell[26148, 945, 134, 3, 26, "Input",
  CellTags->"Graphics::realu"],
Cell[26285, 950, 209, 5, 37, "Message",
  CellTags->"Graphics::realu"],
Cell[26497, 957, 185, 5, 21, "Output",
  CellTags->"Graphics::realu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26743, 969, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MeshStyle::mesh"],
Cell[26829, 972, 251, 5, 37, "Message",
  CellTags->"MeshStyle::mesh"],
Cell[27083, 979, 477, 10, 84, "Notes",
  CellTags->"MeshStyle::mesh"],

Cell[CellGroupData[{
Cell[27585, 993, 65, 1, 38, "ExampleSection",
  CellTags->"MeshStyle::mesh"],
Cell[27653, 996, 274, 7, 40, "Text",
  CellTags->"MeshStyle::mesh"],

Cell[CellGroupData[{
Cell[27952, 1007, 171, 4, 42, "Input",
  CellTags->"MeshStyle::mesh"],
Cell[28126, 1013, 236, 5, 37, "Message",
  CellTags->"MeshStyle::mesh"],
Cell[28365, 1020, 192, 5, 21, "Output",
  CellTags->"MeshStyle::mesh"]
}, Open  ]],
Cell[28572, 1028, 140, 5, 24, "Text",
  CellTags->"MeshStyle::mesh"],

Cell[CellGroupData[{
Cell[28737, 1037, 173, 4, 42, "Input",
  CellTags->"MeshStyle::mesh"],
Cell[28913, 1043, 192, 5, 21, "Output",
  CellTags->"MeshStyle::mesh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29166, 1055, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PlotRange::prng"],
Cell[29252, 1058, 330, 7, 37, "Message",
  CellTags->"PlotRange::prng"],
Cell[29585, 1067, 463, 13, 62, "Notes",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{
Cell[30073, 1084, 65, 1, 38, "ExampleSection",
  CellTags->"PlotRange::prng"],
Cell[30141, 1087, 146, 5, 24, "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{
Cell[30312, 1096, 131, 3, 26, "Input",
  CellTags->"PlotRange::prng"],
Cell[30446, 1101, 247, 5, 53, "Message",
  CellTags->"PlotRange::prng"],
Cell[30696, 1108, 185, 5, 21, "Output",
  CellTags->"PlotRange::prng"]
}, Open  ]],
Cell[30896, 1116, 140, 5, 24, "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{
Cell[31061, 1125, 136, 3, 26, "Input",
  CellTags->"PlotRange::prng"],
Cell[31200, 1130, 185, 5, 21, "Output",
  CellTags->"PlotRange::prng"]
}, Open  ]],
Cell[31400, 1138, 240, 6, 40, "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{
Cell[31665, 1148, 167, 4, 26, "Input",
  CellTags->"PlotRange::prng"],
Cell[31835, 1154, 281, 6, 53, "Message",
  CellTags->"PlotRange::prng"],
Cell[32119, 1162, 192, 5, 21, "Output",
  CellTags->"PlotRange::prng"]
}, Open  ]],
Cell[32326, 1170, 205, 6, 24, "Text",
  CellTags->"PlotRange::prng"],

Cell[CellGroupData[{
Cell[32556, 1180, 175, 4, 42, "Input",
  CellTags->"PlotRange::prng"],
Cell[32734, 1186, 192, 5, 21, "Output",
  CellTags->"PlotRange::prng"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32987, 1198, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ViewCenter::viewc"],
Cell[33077, 1201, 221, 4, 37, "Message",
  CellTags->"ViewCenter::viewc"],
Cell[33301, 1207, 616, 14, 100, "Notes",
  CellTags->"ViewCenter::viewc"],

Cell[CellGroupData[{
Cell[33942, 1225, 67, 1, 38, "ExampleSection",
  CellTags->"ViewCenter::viewc"],
Cell[34012, 1228, 232, 7, 40, "Text",
  CellTags->"ViewCenter::viewc"],

Cell[CellGroupData[{
Cell[34269, 1239, 252, 6, 58, "Input",
  CellTags->"ViewCenter::viewc"],
Cell[34524, 1247, 229, 5, 37, "Message",
  CellTags->"ViewCenter::viewc"],
Cell[34756, 1254, 258, 5, 53, "Message",
  CellTags->"ViewCenter::viewc"],
Cell[35017, 1261, 189, 5, 21, "Output",
  CellTags->"ViewCenter::viewc"]
}, Open  ]],
Cell[35221, 1269, 228, 7, 24, "Text",
  CellTags->"ViewCenter::viewc"],

Cell[CellGroupData[{
Cell[35474, 1280, 269, 6, 58, "Input",
  CellTags->"ViewCenter::viewc"],
Cell[35746, 1288, 189, 5, 21, "Output",
  CellTags->"ViewCenter::viewc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35996, 1300, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ViewPoint::viewp"],
Cell[36084, 1303, 208, 4, 37, "Message",
  CellTags->"ViewPoint::viewp"],
Cell[36295, 1309, 503, 11, 62, "Notes",
  CellTags->"ViewPoint::viewp"],

Cell[CellGroupData[{
Cell[36823, 1324, 66, 1, 38, "ExampleSection",
  CellTags->"ViewPoint::viewp"],
Cell[36892, 1327, 164, 5, 24, "Text",
  CellTags->"ViewPoint::viewp"],

Cell[CellGroupData[{
Cell[37081, 1336, 201, 6, 42, "Input",
  CellTags->"ViewPoint::viewp"],
Cell[37285, 1344, 217, 5, 37, "Message",
  CellTags->"ViewPoint::viewp"],
Cell[37505, 1351, 257, 5, 53, "Message",
  CellTags->"ViewPoint::viewp"],
Cell[37765, 1358, 188, 5, 21, "Output",
  CellTags->"ViewPoint::viewp"]
}, Open  ]],
Cell[37968, 1366, 139, 5, 24, "Text",
  CellTags->"ViewPoint::viewp"],

Cell[CellGroupData[{
Cell[38132, 1375, 203, 6, 42, "Input",
  CellTags->"ViewPoint::viewp"],
Cell[38338, 1383, 188, 5, 21, "Output",
  CellTags->"ViewPoint::viewp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38587, 1395, 150, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
Cell[38740, 1401, 374, 8, 37, "Message",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
Cell[39117, 1411, 591, 10, 100, "Notes",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[CellGroupData[{
Cell[39733, 1425, 97, 1, 38, "ExampleSection",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
Cell[39833, 1428, 209, 5, 24, "Text",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[CellGroupData[{
Cell[40067, 1437, 190, 4, 26, "Input",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
Cell[40260, 1443, 248, 5, 37, "Message",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
Cell[40511, 1450, 293, 5, 53, "Message",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}],
Cell[40807, 1457, 224, 5, 21, "Output",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}]
}, Open  ]],
Cell[41046, 1465, 170, 5, 24, "Text",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],

Cell[CellGroupData[{
Cell[41241, 1474, 190, 4, 26, "Input",
  CellTags->{"SurfaceGraphics::noproj", "Graphics3D::noproj"}],
Cell[41434, 1480, 224, 5, 21, "Output",
  CellTags->{"Graphics3D::noproj", "SurfaceGraphics::noproj"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[41719, 1492, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[41850, 1498, 273, 7, 21, "Message",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[42126, 1507, 674, 14, 100, "Notes",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[CellGroupData[{
Cell[42825, 1525, 86, 1, 38, "ExampleSection",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[42914, 1528, 227, 7, 24, "Text",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[CellGroupData[{
Cell[43166, 1539, 255, 6, 58, "Input",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[43424, 1547, 207, 4, 21, "Message",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[43634, 1553, 207, 4, 21, "Message",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[43844, 1559, 207, 4, 21, "Message",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[44054, 1565, 250, 5, 37, "Message",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[44307, 1572, 206, 5, 21, "Output",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}]
}, Open  ]],
Cell[44528, 1580, 260, 7, 40, "Text",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],

Cell[CellGroupData[{
Cell[44813, 1591, 255, 6, 58, "Input",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}],
Cell[45071, 1599, 206, 5, 21, "Output",
  CellTags->{"Graphics3D::gsing", "Plot3D::gsing"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45338, 1611, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PlotRegion::plotr"],
Cell[45428, 1614, 336, 6, 37, "Message",
  CellTags->"PlotRegion::plotr"],
Cell[45767, 1622, 413, 9, 62, "Notes",
  CellTags->"PlotRegion::plotr"],

Cell[CellGroupData[{
Cell[46205, 1635, 67, 1, 38, "ExampleSection",
  CellTags->"PlotRegion::plotr"],
Cell[46275, 1638, 359, 8, 56, "Text",
  CellTags->"PlotRegion::plotr"],

Cell[CellGroupData[{
Cell[46659, 1650, 271, 7, 58, "Input",
  CellTags->"PlotRegion::plotr"],
Cell[46933, 1659, 295, 6, 53, "Message",
  CellTags->"PlotRegion::plotr"],
Cell[47231, 1667, 187, 5, 21, "Output",
  CellTags->"PlotRegion::plotr"]
}, Open  ]],
Cell[47433, 1675, 141, 5, 24, "Text",
  CellTags->"PlotRegion::plotr"],

Cell[CellGroupData[{
Cell[47599, 1684, 271, 7, 58, "Input",
  CellTags->"PlotRegion::plotr"],
Cell[47873, 1693, 187, 5, 21, "Output",
  CellTags->"PlotRegion::plotr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[48121, 1705, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ViewVertical::viewv"],
Cell[48215, 1708, 272, 5, 37, "Message",
  CellTags->"ViewVertical::viewv"],
Cell[48490, 1715, 608, 14, 84, "Notes",
  CellTags->"ViewVertical::viewv"],

Cell[CellGroupData[{
Cell[49123, 1733, 69, 1, 38, "ExampleSection",
  CellTags->"ViewVertical::viewv"],
Cell[49195, 1736, 348, 9, 40, "Text",
  CellTags->"ViewVertical::viewv"],

Cell[CellGroupData[{
Cell[49568, 1749, 274, 7, 58, "Input",
  CellTags->"ViewVertical::viewv"],
Cell[49845, 1758, 264, 5, 53, "Message",
  CellTags->"ViewVertical::viewv"],
Cell[50112, 1765, 260, 5, 53, "Message",
  CellTags->"ViewVertical::viewv"],
Cell[50375, 1772, 191, 5, 21, "Output",
  CellTags->"ViewVertical::viewv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50627, 1784, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"AspectRatio::aspr"],
Cell[50717, 1787, 299, 6, 37, "Message",
  CellTags->"AspectRatio::aspr"],
Cell[51019, 1795, 198, 5, 24, "Notes",
  CellTags->"AspectRatio::aspr"],

Cell[CellGroupData[{
Cell[51242, 1804, 67, 1, 38, "ExampleSection",
  CellTags->"AspectRatio::aspr"],
Cell[51312, 1807, 225, 6, 40, "Text",
  CellTags->"AspectRatio::aspr"],

Cell[CellGroupData[{
Cell[51562, 1817, 137, 3, 26, "Input",
  CellTags->"AspectRatio::aspr"],
Cell[51702, 1822, 230, 5, 37, "Message",
  CellTags->"AspectRatio::aspr"],
Cell[51935, 1829, 187, 5, 21, "Output",
  CellTags->"AspectRatio::aspr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52183, 1841, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Axes::axes"],
Cell[52259, 1844, 208, 5, 21, "Message",
  CellTags->"Axes::axes"],
Cell[52470, 1851, 447, 16, 46, "Notes",
  CellTags->"Axes::axes"],

Cell[CellGroupData[{
Cell[52942, 1871, 60, 1, 38, "ExampleSection",
  CellTags->"Axes::axes"],
Cell[53005, 1874, 221, 6, 40, "Text",
  CellTags->"Axes::axes"],

Cell[CellGroupData[{
Cell[53251, 1884, 128, 3, 26, "Input",
  CellTags->"Axes::axes"],
Cell[53382, 1889, 175, 4, 21, "Message",
  CellTags->"Axes::axes"],
Cell[53560, 1895, 175, 4, 21, "Message",
  CellTags->"Axes::axes"],
Cell[53738, 1901, 180, 5, 21, "Output",
  CellTags->"Axes::axes"]
}, Open  ]],
Cell[53933, 1909, 121, 4, 24, "Text",
  CellTags->"Axes::axes"],

Cell[CellGroupData[{
Cell[54079, 1917, 135, 3, 26, "Input",
  CellTags->"Axes::axes"],
Cell[54217, 1922, 180, 5, 21, "Output",
  CellTags->"Axes::axes"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[54458, 1934, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"AxesEdge::axedg"],
Cell[54544, 1937, 224, 5, 21, "Message",
  CellTags->"AxesEdge::axedg"],
Cell[54771, 1944, 772, 26, 84, "Notes",
  CellTags->"AxesEdge::axedg"],

Cell[CellGroupData[{
Cell[55568, 1974, 65, 1, 38, "ExampleSection",
  CellTags->"AxesEdge::axedg"],
Cell[55636, 1977, 257, 6, 40, "Text",
  CellTags->"AxesEdge::axedg"],

Cell[CellGroupData[{
Cell[55918, 1987, 163, 4, 26, "Input",
  CellTags->"AxesEdge::axedg"],
Cell[56084, 1993, 190, 4, 21, "Message",
  CellTags->"AxesEdge::axedg"],
Cell[56277, 1999, 190, 4, 21, "Message",
  CellTags->"AxesEdge::axedg"],
Cell[56470, 2005, 192, 5, 21, "Output",
  CellTags->"AxesEdge::axedg"]
}, Open  ]],
Cell[56677, 2013, 139, 5, 24, "Text",
  CellTags->"AxesEdge::axedg"],

Cell[CellGroupData[{
Cell[56841, 2022, 163, 4, 26, "Input",
  CellTags->"AxesEdge::axedg"],
Cell[57007, 2028, 192, 5, 21, "Output",
  CellTags->"AxesEdge::axedg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[57260, 2040, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
Cell[57395, 2046, 506, 14, 37, "Message",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
Cell[57904, 2062, 220, 5, 24, "Notes",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[CellGroupData[{
Cell[58149, 2071, 88, 1, 38, "ExampleSection",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
Cell[58240, 2074, 195, 6, 24, "Text",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[CellGroupData[{
Cell[58460, 2084, 165, 3, 26, "Input",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
Cell[58628, 2089, 241, 5, 37, "Message",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
Cell[58872, 2096, 181, 4, 21, "Output",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}]
}, Open  ]],
Cell[59068, 2103, 167, 5, 24, "Text",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],

Cell[CellGroupData[{
Cell[59260, 2112, 181, 4, 26, "Input",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}],
Cell[59444, 2118, 208, 5, 21, "Output",
  CellTags->{"ParametricPlot::pldiv", "Plot::pldiv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59713, 2130, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"GridLines::grid"],
Cell[59799, 2133, 218, 5, 21, "Message",
  CellTags->"GridLines::grid"],
Cell[60020, 2140, 1162, 34, 138, "Notes",
  CellTags->"GridLines::grid"],

Cell[CellGroupData[{
Cell[61207, 2178, 65, 1, 38, "ExampleSection",
  CellTags->"GridLines::grid"],
Cell[61275, 2181, 274, 7, 40, "Text",
  CellTags->"GridLines::grid"],

Cell[CellGroupData[{
Cell[61574, 2192, 170, 4, 42, "Input",
  CellTags->"GridLines::grid"],
Cell[61747, 2198, 235, 5, 37, "Message",
  CellTags->"GridLines::grid"],
Cell[61985, 2205, 185, 5, 21, "Output",
  CellTags->"GridLines::grid"]
}, Open  ]],
Cell[62185, 2213, 171, 5, 24, "Text",
  CellTags->"GridLines::grid"],

Cell[CellGroupData[{
Cell[62381, 2222, 172, 4, 42, "Input",
  CellTags->"GridLines::grid"],
Cell[62556, 2228, 185, 5, 21, "Output",
  CellTags->"GridLines::grid"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62802, 2240, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Circle::angle"],
Cell[62884, 2243, 316, 6, 37, "Message",
  CellTags->"Circle::angle"],
Cell[63203, 2251, 236, 6, 40, "Notes",
  CellTags->"Circle::angle"],

Cell[CellGroupData[{
Cell[63464, 2261, 63, 1, 38, "ExampleSection",
  CellTags->"Circle::angle"],
Cell[63530, 2264, 190, 5, 24, "Text",
  CellTags->"Circle::angle"],

Cell[CellGroupData[{
Cell[63745, 2273, 181, 5, 26, "Input",
  CellTags->"Circle::angle"],
Cell[63929, 2280, 215, 5, 37, "Message",
  CellTags->"Circle::angle"],
Cell[64147, 2287, 183, 5, 21, "Output",
  CellTags->"Circle::angle"]
}, Open  ]],
Cell[64345, 2295, 122, 5, 24, "Text",
  CellTags->"Circle::angle"],

Cell[CellGroupData[{
Cell[64492, 2304, 197, 5, 42, "Input",
  CellTags->"Circle::angle"],
Cell[64692, 2311, 183, 5, 21, "Output",
  CellTags->"Circle::angle"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[64936, 2323, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Disk::angle"],
Cell[65014, 2326, 312, 6, 37, "Message",
  CellTags->"Disk::angle"],
Cell[65329, 2334, 232, 6, 40, "Notes",
  CellTags->"Disk::angle"],

Cell[CellGroupData[{
Cell[65586, 2344, 61, 1, 38, "ExampleSection",
  CellTags->"Disk::angle"],
Cell[65650, 2347, 186, 5, 24, "Text",
  CellTags->"Disk::angle"],

Cell[CellGroupData[{
Cell[65861, 2356, 177, 5, 26, "Input",
  CellTags->"Disk::angle"],
Cell[66041, 2363, 211, 5, 37, "Message",
  CellTags->"Disk::angle"],
Cell[66255, 2370, 181, 5, 21, "Output",
  CellTags->"Disk::angle"]
}, Open  ]],
Cell[66451, 2378, 118, 5, 24, "Text",
  CellTags->"Disk::angle"],

Cell[CellGroupData[{
Cell[66594, 2387, 193, 5, 42, "Input",
  CellTags->"Disk::angle"],
Cell[66790, 2394, 181, 5, 21, "Output",
  CellTags->"Disk::angle"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67032, 2406, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Circle::radius"],
Cell[67116, 2409, 264, 5, 37, "Message",
  CellTags->"Circle::radius"],
Cell[67383, 2416, 190, 5, 24, "Notes",
  CellTags->"Circle::radius"],

Cell[CellGroupData[{
Cell[67598, 2425, 64, 1, 38, "ExampleSection",
  CellTags->"Circle::radius"],
Cell[67665, 2428, 179, 5, 24, "Text",
  CellTags->"Circle::radius"],

Cell[CellGroupData[{
Cell[67869, 2437, 179, 5, 26, "Input",
  CellTags->"Circle::radius"],
Cell[68051, 2444, 209, 5, 37, "Message",
  CellTags->"Circle::radius"],
Cell[68263, 2451, 184, 5, 21, "Output",
  CellTags->"Circle::radius"]
}, Open  ]],
Cell[68462, 2459, 127, 5, 24, "Text",
  CellTags->"Circle::radius"],

Cell[CellGroupData[{
Cell[68614, 2468, 190, 5, 42, "Input",
  CellTags->"Circle::radius"],
Cell[68807, 2475, 184, 5, 21, "Output",
  CellTags->"Circle::radius"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69052, 2487, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Disk::radius"],
Cell[69132, 2490, 260, 5, 21, "Message",
  CellTags->"Disk::radius"],
Cell[69395, 2497, 186, 5, 24, "Notes",
  CellTags->"Disk::radius"],

Cell[CellGroupData[{
Cell[69606, 2506, 62, 1, 38, "ExampleSection",
  CellTags->"Disk::radius"],
Cell[69671, 2509, 175, 5, 24, "Text",
  CellTags->"Disk::radius"],

Cell[CellGroupData[{
Cell[69871, 2518, 175, 5, 26, "Input",
  CellTags->"Disk::radius"],
Cell[70049, 2525, 205, 5, 37, "Message",
  CellTags->"Disk::radius"],
Cell[70257, 2532, 182, 5, 21, "Output",
  CellTags->"Disk::radius"]
}, Open  ]],
Cell[70454, 2540, 123, 5, 24, "Text",
  CellTags->"Disk::radius"],

Cell[CellGroupData[{
Cell[70602, 2549, 188, 5, 42, "Input",
  CellTags->"Disk::radius"],
Cell[70793, 2556, 182, 5, 21, "Output",
  CellTags->"Disk::radius"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71036, 2568, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[71171, 2574, 653, 16, 37, "Message",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[71827, 2592, 224, 5, 40, "Notes",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{
Cell[72076, 2601, 88, 1, 38, "ExampleSection",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[72167, 2604, 268, 6, 40, "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{
Cell[72460, 2614, 192, 4, 26, "Input",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[72655, 2620, 367, 6, 69, "Message",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[73025, 2628, 208, 5, 21, "Output",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]],
Cell[73248, 2636, 166, 5, 24, "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{
Cell[73439, 2645, 201, 4, 26, "Input",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[73643, 2651, 208, 5, 21, "Output",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]],
Cell[73866, 2659, 178, 5, 24, "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{
Cell[74069, 2668, 159, 3, 26, "Input",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[74231, 2673, 397, 7, 69, "Message",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[74631, 2682, 126, 3, 21, "Output",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]],
Cell[74772, 2688, 152, 5, 24, "Text",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],

Cell[CellGroupData[{
Cell[74949, 2697, 168, 3, 26, "Input",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}],
Cell[75120, 2702, 142, 3, 21, "Output",
  CellTags->{"ColorOutput::colpn", "ToColor::colpn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[75323, 2712, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContourGraphics::ctpnt"],
Cell[75423, 2715, 292, 5, 37, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[75718, 2722, 640, 13, 100, "Notes",
  CellTags->"ContourGraphics::ctpnt"],

Cell[CellGroupData[{
Cell[76383, 2739, 72, 1, 38, "ExampleSection",
  CellTags->"ContourGraphics::ctpnt"],
Cell[76458, 2742, 217, 6, 40, "Text",
  CellTags->"ContourGraphics::ctpnt"],

Cell[CellGroupData[{
Cell[76700, 2752, 268, 6, 90, "Input",
  CellTags->"ContourGraphics::ctpnt"],
Cell[76971, 2760, 281, 5, 53, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[77255, 2767, 281, 5, 53, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[77539, 2774, 281, 5, 53, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[77823, 2781, 241, 5, 37, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[78067, 2788, 192, 5, 21, "Output",
  CellTags->"ContourGraphics::ctpnt"]
}, Open  ]],
Cell[78274, 2796, 277, 6, 40, "Text",
  CellTags->"ContourGraphics::ctpnt"],

Cell[CellGroupData[{
Cell[78576, 2806, 141, 3, 26, "Input",
  CellTags->"ContourGraphics::ctpnt"],
Cell[78720, 2811, 260, 5, 53, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[78983, 2818, 281, 5, 53, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[79267, 2825, 281, 5, 53, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[79551, 2832, 281, 5, 53, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[79835, 2839, 241, 5, 37, "Message",
  CellTags->"ContourGraphics::ctpnt"],
Cell[80079, 2846, 199, 5, 21, "Output",
  CellTags->"ContourGraphics::ctpnt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[80339, 2858, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContourGraphics::ctsm"],
Cell[80437, 2861, 258, 4, 37, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[80698, 2867, 927, 19, 144, "Notes",
  CellTags->"ContourGraphics::ctsm"],

Cell[CellGroupData[{
Cell[81650, 2890, 71, 1, 38, "ExampleSection",
  CellTags->"ContourGraphics::ctsm"],
Cell[81724, 2893, 236, 6, 40, "Text",
  CellTags->"ContourGraphics::ctsm"],

Cell[CellGroupData[{
Cell[81985, 2903, 233, 5, 90, "Input",
  CellTags->"ContourGraphics::ctsm"],
Cell[82221, 2910, 259, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[82483, 2917, 280, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[82766, 2924, 280, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[83049, 2931, 280, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[83332, 2938, 240, 5, 37, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[83575, 2945, 191, 5, 21, "Output",
  CellTags->"ContourGraphics::ctsm"]
}, Open  ]],
Cell[83781, 2953, 236, 6, 40, "Text",
  CellTags->"ContourGraphics::ctsm"],

Cell[CellGroupData[{
Cell[84042, 2963, 142, 3, 26, "Input",
  CellTags->"ContourGraphics::ctsm"],
Cell[84187, 2968, 259, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[84449, 2975, 280, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[84732, 2982, 280, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[85015, 2989, 280, 5, 53, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[85298, 2996, 240, 5, 37, "Message",
  CellTags->"ContourGraphics::ctsm"],
Cell[85541, 3003, 198, 5, 21, "Output",
  CellTags->"ContourGraphics::ctsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[85800, 3015, 202, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],
Cell[86005, 3023, 483, 13, 21, "Message",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],
Cell[86491, 3038, 640, 17, 78, "Notes",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],

Cell[CellGroupData[{
Cell[87156, 3059, 126, 2, 38, "ExampleSection",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],
Cell[87285, 3063, 260, 6, 24, "Text",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],

Cell[CellGroupData[{
Cell[87570, 3073, 190, 4, 26, "Input",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],
Cell[87763, 3079, 277, 6, 37, "Message",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],
Cell[88043, 3087, 253, 6, 21, "Output",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}]
}, Open  ]],
Cell[88311, 3096, 198, 6, 24, "Text",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],

Cell[CellGroupData[{
Cell[88534, 3106, 194, 4, 26, "Input",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", 
    "SurfaceGraphics::gmat"}],
Cell[88731, 3112, 253, 6, 21, "Output",
  CellTags->{
  "ContourGraphics::gmat", "DensityGraphics::gmat", "SurfaceGraphics::gmat"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[89045, 3125, 213, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],
Cell[89261, 3134, 563, 16, 37, "Message",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],
Cell[89827, 3152, 792, 21, 100, "Notes",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[CellGroupData[{
Cell[90644, 3177, 134, 3, 38, "ExampleSection",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],
Cell[90781, 3182, 277, 7, 40, "Text",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[CellGroupData[{
Cell[91083, 3193, 304, 7, 90, "Input",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],
Cell[91390, 3202, 306, 7, 37, "Message",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],
Cell[91699, 3211, 261, 7, 21, "Output",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}]
}, Open  ]],
Cell[91975, 3221, 210, 7, 24, "Text",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],

Cell[CellGroupData[{
Cell[92210, 3232, 323, 8, 90, "Input",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}],
Cell[92536, 3242, 261, 7, 21, "Output",
  CellTags->{
  "ContourGraphics::meshr", "DensityGraphics::meshr", 
    "SurfaceGraphics::meshr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[92858, 3256, 331, 11, 151, "ObjectNameWarningMessages",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],
Cell[93192, 3269, 547, 13, 21, "Message",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],
Cell[93742, 3284, 284, 6, 24, "Notes",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],

Cell[CellGroupData[{
Cell[94051, 3294, 199, 3, 38, "ExampleSection",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],
Cell[94253, 3299, 370, 8, 40, "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],

Cell[CellGroupData[{
Cell[94648, 3311, 237, 5, 26, "Input",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],
Cell[94888, 3318, 333, 7, 21, "Message",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}],
Cell[95224, 3327, 238, 5, 21, "Output",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]],
Cell[95477, 3335, 260, 7, 24, "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],

Cell[CellGroupData[{
Cell[95762, 3346, 245, 5, 26, "Input",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],
Cell[96010, 3353, 319, 7, 21, "Output",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]],
Cell[96344, 3363, 339, 7, 40, "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],

Cell[CellGroupData[{
Cell[96708, 3374, 280, 5, 26, "Input",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],
Cell[96991, 3381, 336, 7, 37, "Message",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}],
Cell[97330, 3390, 336, 7, 37, "Message",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}],
Cell[97669, 3399, 248, 5, 21, "Output",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]],
Cell[97932, 3407, 368, 9, 24, "Text",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],

Cell[CellGroupData[{
Cell[98325, 3420, 297, 6, 26, "Input",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
    "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
    "Play::pllim"}],
Cell[98625, 3428, 319, 7, 21, "Output",
  CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot3D::pllim", 
    "ParametricPlot::pllim", "Play::pllim", "Plot3D::pllim", "Plot::pllim"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[99005, 3442, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Play::plx"],
Cell[99079, 3445, 253, 6, 21, "Message",
  CellTags->"Play::plx"],
Cell[99335, 3453, 176, 5, 24, "Notes",
  CellTags->"Play::plx"],

Cell[CellGroupData[{
Cell[99536, 3462, 59, 1, 38, "ExampleSection",
  CellTags->"Play::plx"],
Cell[99598, 3465, 169, 5, 24, "Text",
  CellTags->"Play::plx"],

Cell[CellGroupData[{
Cell[99792, 3474, 101, 3, 26, "Input",
  CellTags->"Play::plx"],
Cell[99896, 3479, 191, 5, 21, "Message",
  CellTags->"Play::plx"],
Cell[100090, 3486, 102, 3, 21, "Output",
  CellTags->"Play::plx"]
}, Open  ]],
Cell[100207, 3492, 120, 5, 24, "Text",
  CellTags->"Play::plx"],

Cell[CellGroupData[{
Cell[100352, 3501, 110, 3, 26, "Input",
  CellTags->"Play::plx"],
Cell[100465, 3506, 176, 5, 21, "Output",
  CellTags->"Play::plx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[100702, 3518, 161, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[100866, 3525, 627, 18, 21, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[101496, 3545, 882, 20, 116, "Notes",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[102403, 3569, 104, 1, 38, "ExampleSection",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[102510, 3572, 234, 5, 40, "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[102769, 3581, 156, 3, 26, "Input",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[102928, 3586, 274, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[103205, 3593, 272, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[103480, 3600, 272, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[103755, 3607, 261, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[104019, 3614, 224, 5, 21, "Output",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],
Cell[104258, 3622, 204, 4, 24, "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[104487, 3630, 179, 3, 26, "Input",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[104669, 3635, 224, 5, 21, "Output",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],
Cell[104908, 3643, 294, 7, 40, "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[105227, 3654, 182, 3, 26, "Input",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[105412, 3659, 261, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[105676, 3666, 259, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[105938, 3673, 258, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[106199, 3680, 261, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[106463, 3687, 224, 5, 21, "Output",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],
Cell[106702, 3695, 279, 7, 40, "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[107006, 3706, 199, 4, 26, "Input",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[107208, 3712, 224, 5, 21, "Output",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],
Cell[107447, 3720, 233, 5, 40, "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[107705, 3729, 160, 3, 26, "Input",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[107868, 3734, 265, 5, 23, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[108136, 3741, 265, 5, 23, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[108404, 3748, 265, 5, 23, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[108672, 3755, 261, 5, 37, "Message",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[108936, 3762, 224, 5, 21, "Output",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],
Cell[109175, 3770, 276, 5, 40, "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[109476, 3779, 161, 3, 26, "Input",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[109640, 3784, 220, 4, 21, "Output",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]],
Cell[109875, 3791, 284, 6, 40, "Text",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],

Cell[CellGroupData[{
Cell[110184, 3801, 174, 3, 26, "Input",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}],
Cell[110361, 3806, 224, 5, 21, "Output",
  CellTags->{"ContourPlot::plnr", "DensityPlot::plnr", "Plot::plnr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[110646, 3818, 165, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
Cell[110814, 3825, 571, 16, 37, "Message",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
Cell[111388, 3843, 598, 15, 78, "Notes",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[CellGroupData[{
Cell[112011, 3862, 106, 1, 38, "ExampleSection",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
Cell[112120, 3865, 300, 9, 40, "Text",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[CellGroupData[{
Cell[112445, 3878, 200, 4, 26, "Input",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
Cell[112648, 3884, 283, 5, 37, "Message",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
Cell[112934, 3891, 206, 4, 21, "Output",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}]
}, Open  ]],
Cell[113155, 3898, 226, 7, 24, "Text",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],

Cell[CellGroupData[{
Cell[113406, 3909, 197, 4, 26, "Input",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}],
Cell[113606, 3915, 233, 5, 21, "Output",
  CellTags->{"ContourPlot::pptt", "DensityPlot::pptt", "Plot3D::pptt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[113900, 3927, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContourSmoothing::ctnsm"],
Cell[114002, 3930, 317, 6, 37, "Message",
  CellTags->"ContourSmoothing::ctnsm"],
Cell[114322, 3938, 209, 5, 24, "Notes",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[CellGroupData[{
Cell[114556, 3947, 73, 1, 38, "ExampleSection",
  CellTags->"ContourSmoothing::ctnsm"],
Cell[114632, 3950, 224, 7, 24, "Text",
  CellTags->"ContourSmoothing::ctnsm"],

Cell[CellGroupData[{
Cell[114881, 3961, 202, 4, 42, "Input",
  CellTags->"ContourSmoothing::ctnsm"],
Cell[115086, 3967, 241, 5, 37, "Message",
  CellTags->"ContourSmoothing::ctnsm"],
Cell[115330, 3974, 200, 5, 21, "Output",
  CellTags->"ContourSmoothing::ctnsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[115591, 3986, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
Cell[115730, 3992, 415, 11, 21, "Message",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
Cell[116148, 4005, 593, 13, 100, "Notes",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[CellGroupData[{
Cell[116766, 4022, 90, 1, 38, "ExampleSection",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
Cell[116859, 4025, 314, 6, 40, "Text",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[CellGroupData[{
Cell[117198, 4035, 288, 6, 42, "Input",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
Cell[117489, 4043, 221, 5, 21, "Message",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
Cell[117713, 4050, 221, 5, 21, "Message",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}],
Cell[117937, 4057, 217, 5, 21, "Output",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}]
}, Open  ]],
Cell[118169, 4065, 194, 5, 24, "Text",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],

Cell[CellGroupData[{
Cell[118388, 4074, 292, 6, 58, "Input",
  CellTags->{"Dashing::dshn", "AbsoluteDashing::dshn"}],
Cell[118683, 4082, 217, 5, 21, "Output",
  CellTags->{"AbsoluteDashing::dshn", "Dashing::dshn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[118961, 4094, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DefaultFont::dfont"],
Cell[119053, 4097, 214, 5, 37, "Message",
  CellTags->"DefaultFont::dfont"],
Cell[119270, 4104, 618, 14, 84, "Notes",
  CellTags->"DefaultFont::dfont"],

Cell[CellGroupData[{
Cell[119913, 4122, 68, 1, 38, "ExampleSection",
  CellTags->"DefaultFont::dfont"],
Cell[119984, 4125, 193, 5, 24, "Text",
  CellTags->"DefaultFont::dfont"],

Cell[CellGroupData[{
Cell[120202, 4134, 144, 3, 26, "Input",
  CellTags->"DefaultFont::dfont"],
Cell[120349, 4139, 225, 5, 37, "Message",
  CellTags->"DefaultFont::dfont"],
Cell[120577, 4146, 188, 5, 21, "Output",
  CellTags->"DefaultFont::dfont"]
}, Open  ]],
Cell[120780, 4154, 146, 5, 24, "Text",
  CellTags->"DefaultFont::dfont"],

Cell[CellGroupData[{
Cell[120951, 4163, 163, 4, 26, "Input",
  CellTags->"DefaultFont::dfont"],
Cell[121117, 4169, 188, 5, 21, "Output",
  CellTags->"DefaultFont::dfont"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[121366, 4181, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DefaultFont::font"],
Cell[121456, 4184, 322, 6, 37, "Message",
  CellTags->"DefaultFont::font"],
Cell[121781, 4192, 197, 6, 24, "Notes",
  CellTags->"DefaultFont::font"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122015, 4203, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::zval"],
Cell[122097, 4206, 501, 14, 21, "Message",
  CellTags->"General::zval"],
Cell[122601, 4222, 512, 12, 78, "Notes",
  CellTags->"General::zval"],

Cell[CellGroupData[{
Cell[123138, 4238, 63, 1, 38, "ExampleSection",
  CellTags->"General::zval"],
Cell[123204, 4241, 193, 5, 24, "Text",
  CellTags->"General::zval"],

Cell[CellGroupData[{
Cell[123422, 4250, 142, 3, 26, "Input",
  CellTags->"General::zval"],
Cell[123567, 4255, 233, 5, 37, "Message",
  CellTags->"General::zval"],
Cell[123803, 4262, 190, 5, 21, "Output",
  CellTags->"General::zval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[124054, 4274, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::badargs"],
Cell[124142, 4277, 151, 4, 21, "Message",
  CellTags->"Display::badargs"],
Cell[124296, 4283, 196, 6, 24, "Notes",
  CellTags->"Display::badargs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124529, 4294, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::dispgif"],
Cell[124617, 4297, 163, 3, 21, "Message",
  CellTags->"Display::dispgif"],
Cell[124783, 4302, 324, 7, 62, "Notes",
  CellTags->"Display::dispgif"]
}, Open  ]],

Cell[CellGroupData[{
Cell[125144, 4314, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::dopen"],
Cell[125228, 4317, 187, 4, 21, "Message",
  CellTags->"Display::dopen"],
Cell[125418, 4323, 494, 9, 84, "Notes",
  CellTags->"Display::dopen"],

Cell[CellGroupData[{
Cell[125937, 4336, 64, 1, 38, "ExampleSection",
  CellTags->"Display::dopen"],
Cell[126004, 4339, 262, 5, 40, "Text",
  CellTags->"Display::dopen"],

Cell[CellGroupData[{
Cell[126291, 4348, 149, 4, 26, "Input",
  CellTags->"Display::dopen"],
Cell[126443, 4354, 184, 5, 21, "Output",
  CellTags->"Display::dopen"],
Cell[126630, 4361, 204, 7, 21, "Message",
  CellTags->"Display::dopen"],
Cell[126837, 4370, 171, 8, 19, "Output",
  CellTags->"Display::dopen"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[127069, 4385, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::dwrite"],
Cell[127155, 4388, 192, 4, 21, "Message",
  CellTags->"Display::dwrite"],
Cell[127350, 4394, 409, 8, 68, "Notes",
  CellTags->"Display::dwrite"],

Cell[CellGroupData[{
Cell[127784, 4406, 65, 1, 38, "ExampleSection",
  CellTags->"Display::dwrite"],
Cell[127852, 4409, 279, 6, 40, "Text",
  CellTags->"Display::dwrite"],

Cell[CellGroupData[{
Cell[128156, 4419, 150, 4, 26, "Input",
  CellTags->"Display::dwrite"],
Cell[128309, 4425, 185, 5, 21, "Output",
  CellTags->"Display::dwrite"],
Cell[128497, 4432, 209, 7, 21, "Message",
  CellTags->"Display::dwrite"],
Cell[128709, 4441, 172, 8, 19, "Output",
  CellTags->"Display::dwrite"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[128942, 4456, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::fname"],
Cell[129026, 4459, 218, 4, 21, "Message",
  CellTags->"Display::fname"],
Cell[129247, 4465, 428, 9, 68, "Notes",
  CellTags->"Display::fname"],

Cell[CellGroupData[{
Cell[129700, 4478, 64, 1, 38, "ExampleSection",
  CellTags->"Display::fname"],
Cell[129767, 4481, 269, 6, 40, "Text",
  CellTags->"Display::fname"],

Cell[CellGroupData[{
Cell[130061, 4491, 143, 3, 26, "Input",
  CellTags->"Display::fname"],
Cell[130207, 4496, 285, 5, 21, "Message",
  CellTags->"Display::fname"],
Cell[130495, 4503, 95, 3, 21, "Output",
  CellTags->"Display::fname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[130651, 4513, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::gfile"],
Cell[130735, 4516, 205, 5, 21, "Message",
  CellTags->"Display::gfile"],
Cell[130943, 4523, 289, 6, 46, "Notes",
  CellTags->"Display::gfile"],

Cell[CellGroupData[{
Cell[131257, 4533, 64, 1, 38, "ExampleSection",
  CellTags->"Display::gfile"],
Cell[131324, 4536, 143, 4, 24, "Text",
  CellTags->"Display::gfile"],

Cell[CellGroupData[{
Cell[131492, 4544, 122, 3, 26, "Input",
  CellTags->"Display::gfile"],
Cell[131617, 4549, 168, 4, 21, "Message",
  CellTags->"Display::gfile"],
Cell[131788, 4555, 184, 5, 21, "Output",
  CellTags->"Display::gfile"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[132033, 4567, 165, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],
Cell[132201, 4574, 599, 16, 37, "Message",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],
Cell[132803, 4592, 466, 12, 62, "Notes",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[CellGroupData[{
Cell[133294, 4608, 106, 1, 38, "ExampleSection",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],
Cell[133403, 4611, 273, 8, 40, "Text",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],

Cell[CellGroupData[{
Cell[133701, 4623, 213, 4, 42, "Input",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],
Cell[133917, 4629, 287, 5, 37, "Message",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}],
Cell[134207, 4636, 226, 5, 21, "Output",
  CellTags->{"Display::image", "Export::image", "ExportString::image"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[134494, 4648, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::noform"],
Cell[134580, 4651, 429, 11, 37, "Message",
  CellTags->"Display::noform"],
Cell[135012, 4664, 343, 10, 46, "Notes",
  CellTags->"Display::noform"],

Cell[CellGroupData[{
Cell[135380, 4678, 65, 1, 38, "ExampleSection",
  CellTags->"Display::noform"],
Cell[135448, 4681, 272, 6, 40, "Text",
  CellTags->"Display::noform"],

Cell[CellGroupData[{
Cell[135745, 4691, 146, 3, 26, "Input",
  CellTags->"Display::noform"],
Cell[135894, 4696, 317, 6, 53, "Message",
  CellTags->"Display::noform"],
Cell[136214, 4704, 185, 5, 21, "Output",
  CellTags->"Display::noform"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[136460, 4716, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::nolink"],
Cell[136546, 4719, 168, 3, 21, "Message",
  CellTags->"Display::nolink"],
Cell[136717, 4724, 594, 14, 84, "Notes",
  CellTags->"Display::nolink"]
}, Open  ]],

Cell[CellGroupData[{
Cell[137348, 4743, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::pserr"],
Cell[137432, 4746, 195, 6, 21, "Message",
  CellTags->"Display::pserr"],
Cell[137630, 4754, 615, 11, 116, "Notes",
  CellTags->"Display::pserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138282, 4770, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Display::type"],
Cell[138364, 4773, 244, 5, 21, "Message",
  CellTags->"Display::type"],
Cell[138611, 4780, 450, 12, 62, "Notes",
  CellTags->"Display::type"],

Cell[CellGroupData[{
Cell[139086, 4796, 63, 1, 38, "ExampleSection",
  CellTags->"Display::type"],
Cell[139152, 4799, 214, 6, 40, "Text",
  CellTags->"Display::type"],

Cell[CellGroupData[{
Cell[139391, 4809, 111, 3, 26, "Input",
  CellTags->"Display::type"],
Cell[139505, 4814, 197, 5, 21, "Message",
  CellTags->"Display::type"],
Cell[139705, 4821, 88, 3, 21, "Output",
  CellTags->"Display::type"]
}, Open  ]],
Cell[139808, 4827, 248, 6, 40, "Text",
  CellTags->"Display::type"],

Cell[CellGroupData[{
Cell[140081, 4837, 133, 3, 26, "Input",
  CellTags->"Display::type"],
Cell[140217, 4842, 183, 5, 21, "Output",
  CellTags->"Display::type"]
}, Open  ]],
Cell[140415, 4850, 61, 1, 24, "Text",
  CellTags->"Display::type"],
Cell[140479, 4853, 109, 3, 26, "Input",
  CellTags->"Display::type"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[140637, 4862, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FaceGrids::fglst"],
Cell[140725, 4865, 317, 7, 37, "Message",
  CellTags->"FaceGrids::fglst"],
Cell[141045, 4874, 451, 13, 62, "Notes",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{
Cell[141521, 4891, 66, 1, 38, "ExampleSection",
  CellTags->"FaceGrids::fglst"],
Cell[141590, 4894, 223, 5, 40, "Text",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{
Cell[141838, 4903, 179, 4, 58, "Input",
  CellTags->"FaceGrids::fglst"],
Cell[142020, 4909, 248, 5, 53, "Message",
  CellTags->"FaceGrids::fglst"],
Cell[142271, 4916, 193, 5, 21, "Output",
  CellTags->"FaceGrids::fglst"]
}, Open  ]],
Cell[142479, 4924, 142, 5, 24, "Text",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{
Cell[142646, 4933, 180, 4, 58, "Input",
  CellTags->"FaceGrids::fglst"],
Cell[142829, 4939, 193, 5, 21, "Output",
  CellTags->"FaceGrids::fglst"]
}, Open  ]],
Cell[143037, 4947, 175, 5, 24, "Text",
  CellTags->"FaceGrids::fglst"],

Cell[CellGroupData[{
Cell[143237, 4956, 229, 5, 58, "Input",
  CellTags->"FaceGrids::fglst"],
Cell[143469, 4963, 193, 5, 21, "Output",
  CellTags->"FaceGrids::fglst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[143723, 4975, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FaceGrids::fgstl"],
Cell[143811, 4978, 227, 5, 21, "Message",
  CellTags->"FaceGrids::fgstl"],
Cell[144041, 4985, 441, 10, 62, "Notes",
  CellTags->"FaceGrids::fgstl"],

Cell[CellGroupData[{
Cell[144507, 4999, 66, 1, 38, "ExampleSection",
  CellTags->"FaceGrids::fgstl"],
Cell[144576, 5002, 168, 4, 24, "Text",
  CellTags->"FaceGrids::fgstl"],

Cell[CellGroupData[{
Cell[144769, 5010, 227, 5, 42, "Input",
  CellTags->"FaceGrids::fgstl"],
Cell[144999, 5017, 218, 5, 37, "Message",
  CellTags->"FaceGrids::fgstl"],
Cell[145220, 5024, 193, 5, 21, "Output",
  CellTags->"FaceGrids::fgstl"]
}, Open  ]],
Cell[145428, 5032, 141, 5, 24, "Text",
  CellTags->"FaceGrids::fgstl"],

Cell[CellGroupData[{
Cell[145594, 5041, 229, 5, 42, "Input",
  CellTags->"FaceGrids::fgstl"],
Cell[145826, 5048, 193, 5, 21, "Output",
  CellTags->"FaceGrids::fgstl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[146080, 5060, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FaceGrids::gface"],
Cell[146168, 5063, 220, 5, 21, "Message",
  CellTags->"FaceGrids::gface"],
Cell[146391, 5070, 804, 25, 100, "Notes",
  CellTags->"FaceGrids::gface"],

Cell[CellGroupData[{
Cell[147220, 5099, 66, 1, 38, "ExampleSection",
  CellTags->"FaceGrids::gface"],
Cell[147289, 5102, 228, 6, 40, "Text",
  CellTags->"FaceGrids::gface"],

Cell[CellGroupData[{
Cell[147542, 5112, 176, 4, 42, "Input",
  CellTags->"FaceGrids::gface"],
Cell[147721, 5118, 183, 4, 21, "Message",
  CellTags->"FaceGrids::gface"],
Cell[147907, 5124, 182, 4, 21, "Message",
  CellTags->"FaceGrids::gface"],
Cell[148092, 5130, 182, 4, 21, "Message",
  CellTags->"FaceGrids::gface"],
Cell[148277, 5136, 229, 5, 37, "Message",
  CellTags->"FaceGrids::gface"],
Cell[148509, 5143, 193, 5, 21, "Output",
  CellTags->"FaceGrids::gface"]
}, Open  ]],
Cell[148717, 5151, 141, 5, 24, "Text",
  CellTags->"FaceGrids::gface"],

Cell[CellGroupData[{
Cell[148883, 5160, 178, 4, 42, "Input",
  CellTags->"FaceGrids::gface"],
Cell[149064, 5166, 193, 5, 21, "Output",
  CellTags->"FaceGrids::gface"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[149318, 5178, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FontForm::ffsp"],
Cell[149402, 5181, 206, 5, 37, "Message",
  CellTags->"FontForm::ffsp"],
Cell[149611, 5188, 537, 18, 62, "Notes",
  CellTags->"FontForm::ffsp"],

Cell[CellGroupData[{
Cell[150173, 5210, 64, 1, 38, "ExampleSection",
  CellTags->"FontForm::ffsp"],
Cell[150240, 5213, 129, 5, 24, "Text",
  CellTags->"FontForm::ffsp"],

Cell[CellGroupData[{
Cell[150394, 5222, 176, 5, 26, "Input",
  CellTags->"FontForm::ffsp"],
Cell[150573, 5229, 184, 5, 21, "Output",
  CellTags->"FontForm::ffsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[150818, 5241, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FrameLabel::fmlab"],
Cell[150908, 5244, 314, 6, 37, "Message",
  CellTags->"FrameLabel::fmlab"],
Cell[151225, 5252, 358, 9, 46, "Notes",
  CellTags->"FrameLabel::fmlab"],

Cell[CellGroupData[{
Cell[151608, 5265, 67, 1, 38, "ExampleSection",
  CellTags->"FrameLabel::fmlab"],
Cell[151678, 5268, 200, 5, 24, "Text",
  CellTags->"FrameLabel::fmlab"],

Cell[CellGroupData[{
Cell[151903, 5277, 169, 4, 26, "Input",
  CellTags->"FrameLabel::fmlab"],
Cell[152075, 5283, 252, 5, 53, "Message",
  CellTags->"FrameLabel::fmlab"],
Cell[152330, 5290, 252, 5, 53, "Message",
  CellTags->"FrameLabel::fmlab"],
Cell[152585, 5297, 187, 5, 21, "Output",
  CellTags->"FrameLabel::fmlab"]
}, Open  ]],
Cell[152787, 5305, 151, 5, 24, "Text",
  CellTags->"FrameLabel::fmlab"],

Cell[CellGroupData[{
Cell[152963, 5314, 175, 4, 42, "Input",
  CellTags->"FrameLabel::fmlab"],
Cell[153141, 5320, 187, 5, 21, "Output",
  CellTags->"FrameLabel::fmlab"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[153389, 5332, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::lspec"],
Cell[153473, 5335, 464, 13, 21, "Message",
  CellTags->"General::lspec"],
Cell[153940, 5350, 294, 6, 46, "Notes",
  CellTags->"General::lspec"],

Cell[CellGroupData[{
Cell[154259, 5360, 64, 1, 38, "ExampleSection",
  CellTags->"General::lspec"],
Cell[154326, 5363, 177, 4, 40, "Text",
  CellTags->"General::lspec"],

Cell[CellGroupData[{
Cell[154528, 5371, 191, 5, 42, "Input",
  CellTags->"General::lspec"],
Cell[154722, 5378, 213, 5, 37, "Message",
  CellTags->"General::lspec"],
Cell[154938, 5385, 191, 5, 21, "Output",
  CellTags->"General::lspec"]
}, Open  ]],
Cell[155144, 5393, 101, 1, 24, "Text",
  CellTags->"General::lspec"],

Cell[CellGroupData[{
Cell[155270, 5398, 213, 5, 42, "Input",
  CellTags->"General::lspec"],
Cell[155486, 5405, 191, 5, 21, "Output",
  CellTags->"General::lspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[155738, 5417, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics3D::ambnt"],
Cell[155828, 5420, 493, 13, 37, "Message",
  CellTags->"Graphics3D::ambnt"],
Cell[156324, 5435, 199, 5, 24, "Notes",
  CellTags->"Graphics3D::ambnt"],

Cell[CellGroupData[{
Cell[156548, 5444, 67, 1, 38, "ExampleSection",
  CellTags->"Graphics3D::ambnt"],
Cell[156618, 5447, 254, 6, 40, "Text",
  CellTags->"Graphics3D::ambnt"],

Cell[CellGroupData[{
Cell[156897, 5457, 187, 4, 42, "Input",
  CellTags->"Graphics3D::ambnt"],
Cell[157087, 5463, 312, 6, 53, "Message",
  CellTags->"Graphics3D::ambnt"],
Cell[157402, 5471, 194, 5, 21, "Output",
  CellTags->"Graphics3D::ambnt"]
}, Open  ]],
Cell[157611, 5479, 184, 7, 24, "Text",
  CellTags->"Graphics3D::ambnt"],

Cell[CellGroupData[{
Cell[157820, 5490, 166, 4, 26, "Input",
  CellTags->"Graphics3D::ambnt"],
Cell[157989, 5496, 194, 5, 21, "Output",
  CellTags->"Graphics3D::ambnt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[158244, 5508, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::color"],
Cell[158328, 5511, 450, 13, 21, "Message",
  CellTags->"General::color"],
Cell[158781, 5526, 1542, 56, 100, "Notes",
  CellTags->"General::color"],

Cell[CellGroupData[{
Cell[160348, 5586, 64, 1, 38, "ExampleSection",
  CellTags->"General::color"],
Cell[160415, 5589, 170, 5, 24, "Text",
  CellTags->"General::color"],

Cell[CellGroupData[{
Cell[160610, 5598, 212, 6, 42, "Input",
  CellTags->"General::color"],
Cell[160825, 5606, 209, 5, 37, "Message",
  CellTags->"General::color"],
Cell[161037, 5613, 186, 5, 21, "Output",
  CellTags->"General::color"]
}, Open  ]],
Cell[161238, 5621, 102, 1, 24, "Text",
  CellTags->"General::color"],

Cell[CellGroupData[{
Cell[161365, 5626, 218, 6, 42, "Input",
  CellTags->"General::color"],
Cell[161586, 5634, 186, 5, 21, "Output",
  CellTags->"General::color"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[161833, 5646, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::gprim"],
Cell[161917, 5649, 346, 10, 37, "Message",
  CellTags->"General::gprim"],
Cell[162266, 5661, 417, 9, 78, "Notes",
  CellTags->"General::gprim"],

Cell[CellGroupData[{
Cell[162708, 5674, 64, 1, 38, "ExampleSection",
  CellTags->"General::gprim"],
Cell[162775, 5677, 150, 4, 24, "Text",
  CellTags->"General::gprim"],

Cell[CellGroupData[{
Cell[162950, 5685, 119, 3, 26, "Input",
  CellTags->"General::gprim"],
Cell[163072, 5690, 222, 5, 37, "Message",
  CellTags->"General::gprim"],
Cell[163297, 5697, 222, 5, 37, "Message",
  CellTags->"General::gprim"],
Cell[163522, 5704, 222, 5, 37, "Message",
  CellTags->"General::gprim"],
Cell[163747, 5711, 226, 5, 37, "Message",
  CellTags->"General::gprim"],
Cell[163976, 5718, 184, 5, 21, "Output",
  CellTags->"General::gprim"]
}, Open  ]],
Cell[164175, 5726, 177, 7, 24, "Text",
  CellTags->"General::gprim"],

Cell[CellGroupData[{
Cell[164377, 5737, 125, 3, 26, "Input",
  CellTags->"General::gprim"],
Cell[164505, 5742, 184, 5, 21, "Output",
  CellTags->"General::gprim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[164750, 5754, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::pcolor"],
Cell[164836, 5757, 272, 7, 21, "Message",
  CellTags->"General::pcolor"],
Cell[165111, 5766, 857, 24, 116, "Notes",
  CellTags->"General::pcolor"],

Cell[CellGroupData[{
Cell[165993, 5794, 65, 1, 38, "ExampleSection",
  CellTags->"General::pcolor"],
Cell[166061, 5797, 169, 4, 24, "Text",
  CellTags->"General::pcolor"],

Cell[CellGroupData[{
Cell[166255, 5805, 265, 6, 58, "Input",
  CellTags->"General::pcolor"],
Cell[166523, 5813, 209, 5, 37, "Message",
  CellTags->"General::pcolor"],
Cell[166735, 5820, 209, 5, 37, "Message",
  CellTags->"General::pcolor"],
Cell[166947, 5827, 209, 5, 37, "Message",
  CellTags->"General::pcolor"],
Cell[167159, 5834, 236, 5, 37, "Message",
  CellTags->"General::pcolor"],
Cell[167398, 5841, 187, 5, 21, "Output",
  CellTags->"General::pcolor"]
}, Open  ]],
Cell[167600, 5849, 152, 5, 24, "Text",
  CellTags->"General::pcolor"],

Cell[CellGroupData[{
Cell[167777, 5858, 277, 6, 74, "Input",
  CellTags->"General::pcolor"],
Cell[168057, 5866, 187, 5, 21, "Output",
  CellTags->"General::pcolor"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[168305, 5878, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::plln"],
Cell[168387, 5881, 486, 14, 21, "Message",
  CellTags->"General::plln"],
Cell[168876, 5897, 710, 20, 100, "Notes",
  CellTags->"General::plln"],

Cell[CellGroupData[{
Cell[169611, 5921, 63, 1, 38, "ExampleSection",
  CellTags->"General::plln"],
Cell[169677, 5924, 186, 5, 24, "Text",
  CellTags->"General::plln"],

Cell[CellGroupData[{
Cell[169888, 5933, 121, 3, 26, "Input",
  CellTags->"General::plln"],
Cell[170012, 5938, 225, 5, 37, "Message",
  CellTags->"General::plln"],
Cell[170240, 5945, 125, 3, 21, "Output",
  CellTags->"General::plln"]
}, Open  ]],
Cell[170380, 5951, 134, 5, 24, "Text",
  CellTags->"General::plln"],

Cell[CellGroupData[{
Cell[170539, 5960, 113, 3, 26, "Input",
  CellTags->"General::plln"],
Cell[170655, 5965, 183, 5, 21, "Output",
  CellTags->"General::plln"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[170899, 5977, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::rawvar"],
Cell[170985, 5980, 511, 14, 37, "Message",
  CellTags->"General::rawvar"],
Cell[171499, 5996, 195, 6, 24, "Notes",
  CellTags->"General::rawvar"]
}, Open  ]],

Cell[CellGroupData[{
Cell[171731, 6007, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics3D::lights"],
Cell[171823, 6010, 493, 13, 37, "Message",
  CellTags->"Graphics3D::lights"],
Cell[172319, 6025, 500, 10, 78, "Notes",
  CellTags->"Graphics3D::lights"],

Cell[CellGroupData[{
Cell[172844, 6039, 68, 1, 38, "ExampleSection",
  CellTags->"Graphics3D::lights"],
Cell[172915, 6042, 235, 5, 40, "Text",
  CellTags->"Graphics3D::lights"],

Cell[CellGroupData[{
Cell[173175, 6051, 188, 4, 42, "Input",
  CellTags->"Graphics3D::lights"],
Cell[173366, 6057, 296, 6, 53, "Message",
  CellTags->"Graphics3D::lights"],
Cell[173665, 6065, 195, 5, 21, "Output",
  CellTags->"Graphics3D::lights"]
}, Open  ]],
Cell[173875, 6073, 147, 5, 24, "Text",
  CellTags->"Graphics3D::lights"],

Cell[CellGroupData[{
Cell[174047, 6082, 190, 4, 42, "Input",
  CellTags->"Graphics3D::lights"],
Cell[174240, 6088, 195, 5, 21, "Output",
  CellTags->"Graphics3D::lights"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[174496, 6100, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics3D::boxz"],
Cell[174584, 6103, 169, 3, 21, "Message",
  CellTags->"Graphics3D::boxz"],
Cell[174756, 6108, 470, 9, 84, "Notes",
  CellTags->"Graphics3D::boxz"]
}, Open  ]],

Cell[CellGroupData[{
Cell[175263, 6122, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics3D::gsort"],
Cell[175353, 6125, 159, 3, 21, "Message",
  CellTags->"Graphics3D::gsort"],
Cell[175515, 6130, 309, 6, 46, "Notes",
  CellTags->"Graphics3D::gsort"]
}, Open  ]],

Cell[CellGroupData[{
Cell[175861, 6141, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics3D::psvf"],
Cell[175949, 6144, 515, 14, 37, "Message",
  CellTags->"Graphics3D::psvf"],
Cell[176467, 6160, 422, 9, 84, "Notes",
  CellTags->"Graphics3D::psvf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[176926, 6174, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics::gpt"],
Cell[177008, 6177, 245, 5, 21, "Message",
  CellTags->"Graphics::gpt"],
Cell[177256, 6184, 604, 23, 62, "Notes",
  CellTags->"Graphics::gpt"],

Cell[CellGroupData[{
Cell[177885, 6211, 63, 1, 38, "ExampleSection",
  CellTags->"Graphics::gpt"],
Cell[177951, 6214, 187, 5, 24, "Text",
  CellTags->"Graphics::gpt"],

Cell[CellGroupData[{
Cell[178163, 6223, 120, 3, 26, "Input",
  CellTags->"Graphics::gpt"],
Cell[178286, 6228, 179, 4, 21, "Message",
  CellTags->"Graphics::gpt"],
Cell[178468, 6234, 179, 4, 21, "Message",
  CellTags->"Graphics::gpt"],
Cell[178650, 6240, 179, 4, 21, "Message",
  CellTags->"Graphics::gpt"],
Cell[178832, 6246, 223, 5, 37, "Message",
  CellTags->"Graphics::gpt"],
Cell[179058, 6253, 183, 5, 21, "Output",
  CellTags->"Graphics::gpt"]
}, Open  ]],
Cell[179256, 6261, 136, 5, 24, "Text",
  CellTags->"Graphics::gpt"],

Cell[CellGroupData[{
Cell[179417, 6270, 124, 3, 26, "Input",
  CellTags->"Graphics::gpt"],
Cell[179544, 6275, 183, 5, 21, "Output",
  CellTags->"Graphics::gpt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[179788, 6287, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics::gptn"],
Cell[179872, 6290, 346, 9, 21, "Message",
  CellTags->"Graphics::gptn"],
Cell[180221, 6301, 287, 6, 46, "Notes",
  CellTags->"Graphics::gptn"],

Cell[CellGroupData[{
Cell[180533, 6311, 64, 1, 38, "ExampleSection",
  CellTags->"Graphics::gptn"],
Cell[180600, 6314, 174, 5, 24, "Text",
  CellTags->"Graphics::gptn"],

Cell[CellGroupData[{
Cell[180799, 6323, 135, 3, 26, "Input",
  CellTags->"Graphics::gptn"],
Cell[180937, 6328, 235, 5, 37, "Message",
  CellTags->"Graphics::gptn"],
Cell[181175, 6335, 184, 5, 21, "Output",
  CellTags->"Graphics::gptn"]
}, Open  ]],
Cell[181374, 6343, 162, 5, 24, "Text",
  CellTags->"Graphics::gptn"],

Cell[CellGroupData[{
Cell[181561, 6352, 133, 3, 26, "Input",
  CellTags->"Graphics::gptn"],
Cell[181697, 6357, 184, 5, 21, "Output",
  CellTags->"Graphics::gptn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[181942, 6369, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics::hue"],
Cell[182024, 6372, 192, 4, 21, "Message",
  CellTags->"Graphics::hue"],
Cell[182219, 6378, 177, 5, 24, "Notes",
  CellTags->"Graphics::hue"],

Cell[CellGroupData[{
Cell[182421, 6387, 63, 1, 38, "ExampleSection",
  CellTags->"Graphics::hue"],
Cell[182487, 6390, 210, 7, 24, "Text",
  CellTags->"Graphics::hue"],

Cell[CellGroupData[{
Cell[182722, 6401, 186, 5, 42, "Input",
  CellTags->"Graphics::hue"],
Cell[182911, 6408, 240, 5, 21, "Message",
  CellTags->"Graphics::hue"],
Cell[183154, 6415, 183, 5, 21, "Output",
  CellTags->"Graphics::hue"]
}, Open  ]],
Cell[183352, 6423, 119, 5, 24, "Text",
  CellTags->"Graphics::hue"],

Cell[CellGroupData[{
Cell[183496, 6432, 186, 5, 42, "Input",
  CellTags->"Graphics::hue"],
Cell[183685, 6439, 183, 5, 21, "Output",
  CellTags->"Graphics::hue"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[183929, 6451, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"GraphicsArray::prim"],
Cell[184023, 6454, 306, 6, 37, "Message",
  CellTags->"GraphicsArray::prim"],
Cell[184332, 6462, 376, 9, 62, "Notes",
  CellTags->"GraphicsArray::prim"],

Cell[CellGroupData[{
Cell[184733, 6475, 69, 1, 38, "ExampleSection",
  CellTags->"GraphicsArray::prim"],
Cell[184805, 6478, 188, 5, 24, "Text",
  CellTags->"GraphicsArray::prim"],

Cell[CellGroupData[{
Cell[185018, 6487, 201, 5, 42, "Input",
  CellTags->"GraphicsArray::prim"],
Cell[185222, 6494, 470, 8, 53, "Message",
  CellTags->"GraphicsArray::prim"],
Cell[185695, 6504, 194, 5, 21, "Output",
  CellTags->"GraphicsArray::prim"]
}, Open  ]],
Cell[185904, 6512, 158, 5, 24, "Text",
  CellTags->"GraphicsArray::prim"],

Cell[CellGroupData[{
Cell[186087, 6521, 199, 5, 42, "Input",
  CellTags->"GraphicsArray::prim"],
Cell[186289, 6528, 194, 5, 21, "Output",
  CellTags->"GraphicsArray::prim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[186544, 6540, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ListPlay::lsamps"],
Cell[186632, 6543, 226, 4, 37, "Message",
  CellTags->"ListPlay::lsamps"],
Cell[186861, 6549, 215, 5, 24, "Notes",
  CellTags->"ListPlay::lsamps"],

Cell[CellGroupData[{
Cell[187101, 6558, 66, 1, 38, "ExampleSection",
  CellTags->"ListPlay::lsamps"],
Cell[187170, 6561, 151, 5, 24, "Text",
  CellTags->"ListPlay::lsamps"],

Cell[CellGroupData[{
Cell[187346, 6570, 103, 3, 26, "Input",
  CellTags->"ListPlay::lsamps"],
Cell[187452, 6575, 229, 5, 37, "Message",
  CellTags->"ListPlay::lsamps"],
Cell[187684, 6582, 104, 3, 21, "Output",
  CellTags->"ListPlay::lsamps"]
}, Open  ]],
Cell[187803, 6588, 132, 5, 24, "Text",
  CellTags->"ListPlay::lsamps"],

Cell[CellGroupData[{
Cell[187960, 6597, 130, 3, 26, "Input",
  CellTags->"ListPlay::lsamps"],
Cell[188093, 6602, 183, 5, 21, "Output",
  CellTags->"ListPlay::lsamps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[188337, 6614, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ListPlay::silent"],
Cell[188425, 6617, 242, 5, 21, "Message",
  CellTags->"ListPlay::silent"],
Cell[188670, 6624, 235, 6, 40, "Notes",
  CellTags->"ListPlay::silent"],

Cell[CellGroupData[{
Cell[188930, 6634, 66, 1, 38, "ExampleSection",
  CellTags->"ListPlay::silent"],
Cell[188999, 6637, 161, 4, 24, "Text",
  CellTags->"ListPlay::silent"],

Cell[CellGroupData[{
Cell[189185, 6645, 130, 3, 26, "Input",
  CellTags->"ListPlay::silent"],
Cell[189318, 6650, 175, 4, 21, "Message",
  CellTags->"ListPlay::silent"],
Cell[189496, 6656, 183, 5, 21, "Output",
  CellTags->"ListPlay::silent"]
}, Open  ]],
Cell[189694, 6664, 121, 4, 24, "Text",
  CellTags->"ListPlay::silent"],

Cell[CellGroupData[{
Cell[189840, 6672, 130, 3, 26, "Input",
  CellTags->"ListPlay::silent"],
Cell[189973, 6677, 183, 5, 21, "Output",
  CellTags->"ListPlay::silent"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[190217, 6689, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ListPlot::lpn"],
Cell[190299, 6692, 229, 5, 21, "Message",
  CellTags->"ListPlot::lpn"],
Cell[190531, 6699, 189, 5, 24, "Notes",
  CellTags->"ListPlot::lpn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[190757, 6709, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::ppfun"],
Cell[190859, 6712, 271, 6, 37, "Message",
  CellTags->"ParametricPlot3D::ppfun"],
Cell[191133, 6720, 238, 5, 40, "Notes",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[CellGroupData[{
Cell[191396, 6729, 73, 1, 38, "ExampleSection",
  CellTags->"ParametricPlot3D::ppfun"],
Cell[191472, 6732, 153, 4, 24, "Text",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[CellGroupData[{
Cell[191650, 6740, 174, 4, 42, "Input",
  CellTags->"ParametricPlot3D::ppfun"],
Cell[191827, 6746, 290, 6, 72, "Message",
  CellTags->"ParametricPlot3D::ppfun"],
Cell[192120, 6754, 178, 4, 36, "Output",
  CellTags->"ParametricPlot3D::ppfun"]
}, Open  ]],
Cell[192313, 6761, 146, 5, 24, "Text",
  CellTags->"ParametricPlot3D::ppfun"],

Cell[CellGroupData[{
Cell[192484, 6770, 168, 4, 26, "Input",
  CellTags->"ParametricPlot3D::ppfun"],
Cell[192655, 6776, 195, 5, 21, "Output",
  CellTags->"ParametricPlot3D::ppfun"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[192911, 6788, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::pplr"],
Cell[193011, 6791, 219, 5, 37, "Message",
  CellTags->"ParametricPlot3D::pplr"],
Cell[193233, 6798, 447, 9, 78, "Notes",
  CellTags->"ParametricPlot3D::pplr"],

Cell[CellGroupData[{
Cell[193705, 6811, 72, 1, 38, "ExampleSection",
  CellTags->"ParametricPlot3D::pplr"],
Cell[193780, 6814, 268, 6, 40, "Text",
  CellTags->"ParametricPlot3D::pplr"],

Cell[CellGroupData[{
Cell[194073, 6824, 147, 3, 26, "Input",
  CellTags->"ParametricPlot3D::pplr"],
Cell[194223, 6829, 270, 5, 51, "Message",
  CellTags->"ParametricPlot3D::pplr"],
Cell[194496, 6836, 289, 6, 68, "Message",
  CellTags->"ParametricPlot3D::pplr"],
Cell[194788, 6844, 288, 6, 68, "Message",
  CellTags->"ParametricPlot3D::pplr"],
Cell[195079, 6852, 241, 5, 37, "Message",
  CellTags->"ParametricPlot3D::pplr"],
Cell[195323, 6859, 211, 5, 37, "Message",
  CellTags->"ParametricPlot3D::pplr"],
Cell[195537, 6866, 149, 3, 34, "Output",
  CellTags->"ParametricPlot3D::pplr"]
}, Open  ]],
Cell[195701, 6872, 145, 5, 24, "Text",
  CellTags->"ParametricPlot3D::pplr"],

Cell[CellGroupData[{
Cell[195871, 6881, 147, 3, 26, "Input",
  CellTags->"ParametricPlot3D::pplr"],
Cell[196021, 6886, 194, 5, 21, "Output",
  CellTags->"ParametricPlot3D::pplr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[196276, 6898, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::ppta"],
Cell[196376, 6901, 347, 6, 37, "Message",
  CellTags->"ParametricPlot3D::ppta"],
Cell[196726, 6909, 278, 7, 40, "Notes",
  CellTags->"ParametricPlot3D::ppta"],

Cell[CellGroupData[{
Cell[197029, 6920, 72, 1, 38, "ExampleSection",
  CellTags->"ParametricPlot3D::ppta"],
Cell[197104, 6923, 265, 9, 40, "Text",
  CellTags->"ParametricPlot3D::ppta"],

Cell[CellGroupData[{
Cell[197394, 6936, 173, 4, 26, "Input",
  CellTags->"ParametricPlot3D::ppta"],
Cell[197570, 6942, 262, 5, 53, "Message",
  CellTags->"ParametricPlot3D::ppta"],
Cell[197835, 6949, 179, 4, 21, "Output",
  CellTags->"ParametricPlot3D::ppta"]
}, Open  ]],
Cell[198029, 6956, 197, 7, 24, "Text",
  CellTags->"ParametricPlot3D::ppta"],

Cell[CellGroupData[{
Cell[198251, 6967, 171, 4, 26, "Input",
  CellTags->"ParametricPlot3D::ppta"],
Cell[198425, 6973, 194, 5, 21, "Output",
  CellTags->"ParametricPlot3D::ppta"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[198680, 6985, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ParametricPlot3D::ppx"],
Cell[198778, 6988, 194, 3, 37, "Message",
  CellTags->"ParametricPlot3D::ppx"],
Cell[198975, 6993, 333, 7, 46, "Notes",
  CellTags->"ParametricPlot3D::ppx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[199345, 7005, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],
Cell[199476, 7011, 407, 10, 21, "Message",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],
Cell[199886, 7023, 213, 5, 24, "Notes",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[CellGroupData[{
Cell[200124, 7032, 86, 1, 38, "ExampleSection",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],
Cell[200213, 7035, 228, 7, 24, "Text",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[CellGroupData[{
Cell[200466, 7046, 167, 3, 26, "Input",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],
Cell[200636, 7051, 206, 4, 21, "Message",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],
Cell[200845, 7057, 185, 4, 21, "Output",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}]
}, Open  ]],
Cell[201045, 7064, 196, 7, 24, "Text",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],

Cell[CellGroupData[{
Cell[201266, 7075, 166, 3, 26, "Input",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}],
Cell[201435, 7080, 206, 5, 21, "Output",
  CellTags->{"ParametricPlot::bend", "Plot::bend"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[201702, 7092, 317, 11, 151, "ObjectNameWarningMessages",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],
Cell[202022, 7105, 633, 16, 37, "Message",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],
Cell[202658, 7123, 293, 6, 24, "Notes",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[CellGroupData[{
Cell[202976, 7133, 192, 3, 38, "ExampleSection",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],
Cell[203171, 7138, 273, 6, 24, "Text",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[CellGroupData[{
Cell[203469, 7148, 238, 5, 26, "Input",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],
Cell[203710, 7155, 357, 7, 37, "Message",
  CellTags->{
  "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
    "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}],
Cell[204070, 7164, 239, 5, 21, "Output",
  CellTags->{
  "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
    "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}]
}, Open  ]],
Cell[204324, 7172, 275, 7, 24, "Text",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],

Cell[CellGroupData[{
Cell[204624, 7183, 242, 5, 26, "Input",
  CellTags->{
  "ParametricPlot::plld", "Plot::plld", "Plot3D::plld", "ContourPlot::plld", 
    "DensityPlot::plld", "ParametricPlot3D::plld", "Play::plld"}],
Cell[204869, 7190, 312, 7, 21, "Output",
  CellTags->{
  "ContourPlot::plld", "DensityPlot::plld", "ParametricPlot3D::plld", 
    "ParametricPlot::plld", "Play::plld", "Plot3D::plld", "Plot::plld"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[205242, 7204, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ParametricPlot::pptr"],
Cell[205338, 7207, 527, 15, 21, "Message",
  CellTags->"ParametricPlot::pptr"],
Cell[205868, 7224, 245, 6, 40, "Notes",
  CellTags->"ParametricPlot::pptr"],

Cell[CellGroupData[{
Cell[206138, 7234, 70, 1, 38, "ExampleSection",
  CellTags->"ParametricPlot::pptr"],
Cell[206211, 7237, 180, 4, 40, "Text",
  CellTags->"ParametricPlot::pptr"],

Cell[CellGroupData[{
Cell[206416, 7245, 130, 3, 26, "Input",
  CellTags->"ParametricPlot::pptr"],
Cell[206549, 7250, 244, 5, 53, "Message",
  CellTags->"ParametricPlot::pptr"],
Cell[206796, 7257, 249, 5, 37, "Message",
  CellTags->"ParametricPlot::pptr"],
Cell[207048, 7264, 247, 5, 37, "Message",
  CellTags->"ParametricPlot::pptr"],
Cell[207298, 7271, 246, 5, 37, "Message",
  CellTags->"ParametricPlot::pptr"],
Cell[207547, 7278, 237, 5, 37, "Message",
  CellTags->"ParametricPlot::pptr"],
Cell[207787, 7285, 190, 5, 21, "Output",
  CellTags->"ParametricPlot::pptr"]
}, Open  ]],
Cell[207992, 7293, 141, 5, 24, "Text",
  CellTags->"ParametricPlot::pptr"],

Cell[CellGroupData[{
Cell[208158, 7302, 135, 3, 26, "Input",
  CellTags->"ParametricPlot::pptr"],
Cell[208296, 7307, 190, 5, 21, "Output",
  CellTags->"ParametricPlot::pptr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[208547, 7319, 177, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
Cell[208727, 7326, 523, 15, 21, "Message",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
Cell[209253, 7343, 242, 5, 24, "Notes",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[CellGroupData[{
Cell[209520, 7352, 112, 1, 38, "ExampleSection",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
Cell[209635, 7355, 257, 7, 24, "Text",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[CellGroupData[{
Cell[209917, 7366, 178, 3, 26, "Input",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
Cell[210098, 7371, 245, 5, 21, "Message",
  CellTags->{
  "ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}],
Cell[210346, 7378, 184, 3, 21, "Output",
  CellTags->{"ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}]
}, Open  ]],
Cell[210545, 7384, 225, 7, 24, "Text",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],

Cell[CellGroupData[{
Cell[210795, 7395, 177, 3, 26, "Input",
  CellTags->{
  "ParametricPlot::ppts", "ParametricPlot3D::ppts", "Plot::ppts"}],
Cell[210975, 7400, 232, 5, 21, "Output",
  CellTags->{"ParametricPlot3D::ppts", "ParametricPlot::ppts", "Plot::ppts"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[211268, 7412, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Play::pfnum"],
Cell[211346, 7415, 277, 5, 37, "Message",
  CellTags->"Play::pfnum"],
Cell[211626, 7422, 350, 9, 46, "Notes",
  CellTags->"Play::pfnum"],

Cell[CellGroupData[{
Cell[212001, 7435, 61, 1, 38, "ExampleSection",
  CellTags->"Play::pfnum"],
Cell[212065, 7438, 221, 5, 40, "Text",
  CellTags->"Play::pfnum"],

Cell[CellGroupData[{
Cell[212311, 7447, 128, 3, 26, "Input",
  CellTags->"Play::pfnum"],
Cell[212442, 7452, 512, 9, 69, "Message",
  CellTags->"Play::pfnum"],
Cell[212957, 7463, 134, 3, 21, "Output",
  CellTags->"Play::pfnum"]
}, Open  ]],
Cell[213106, 7469, 122, 5, 24, "Text",
  CellTags->"Play::pfnum"],

Cell[CellGroupData[{
Cell[213253, 7478, 152, 4, 26, "Input",
  CellTags->"Play::pfnum"],
Cell[213408, 7484, 178, 5, 21, "Output",
  CellTags->"Play::pfnum"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[213647, 7496, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Play::playr", "ListPlay::playr"}],
Cell[213770, 7502, 560, 16, 37, "Message",
  CellTags->{"Play::playr", "ListPlay::playr"}],
Cell[214333, 7520, 211, 5, 24, "Notes",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[CellGroupData[{
Cell[214569, 7529, 82, 1, 38, "ExampleSection",
  CellTags->{"Play::playr", "ListPlay::playr"}],
Cell[214654, 7532, 210, 6, 24, "Text",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[CellGroupData[{
Cell[214889, 7542, 150, 3, 26, "Input",
  CellTags->{"Play::playr", "ListPlay::playr"}],
Cell[215042, 7547, 238, 5, 37, "Message",
  CellTags->{"ListPlay::playr", "Play::playr"}],
Cell[215283, 7554, 156, 3, 21, "Output",
  CellTags->{"ListPlay::playr", "Play::playr"}]
}, Open  ]],
Cell[215454, 7560, 194, 7, 24, "Text",
  CellTags->{"Play::playr", "ListPlay::playr"}],

Cell[CellGroupData[{
Cell[215673, 7571, 154, 3, 26, "Input",
  CellTags->{"Play::playr", "ListPlay::playr"}],
Cell[215830, 7576, 199, 5, 21, "Output",
  CellTags->{"ListPlay::playr", "Play::playr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[216090, 7588, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Play::sample"],
Cell[216170, 7591, 266, 6, 21, "Message",
  CellTags->"Play::sample"],
Cell[216439, 7599, 528, 10, 100, "Notes",
  CellTags->"Play::sample"]
}, Open  ]],

Cell[CellGroupData[{
Cell[217004, 7614, 116, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],
Cell[217123, 7620, 528, 15, 37, "Message",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],
Cell[217654, 7637, 279, 6, 40, "Notes",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[CellGroupData[{
Cell[217958, 7647, 80, 1, 38, "ExampleSection",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],
Cell[218041, 7650, 226, 7, 24, "Text",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[CellGroupData[{
Cell[218292, 7661, 151, 3, 26, "Input",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],
Cell[218446, 7666, 233, 5, 37, "Message",
  CellTags->{"ListPlay::sdep", "Play::sdep"}],
Cell[218682, 7673, 157, 3, 21, "Output",
  CellTags->{"ListPlay::sdep", "Play::sdep"}]
}, Open  ]],
Cell[218854, 7679, 141, 5, 24, "Text",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],

Cell[CellGroupData[{
Cell[219020, 7688, 150, 3, 26, "Input",
  CellTags->{"Play::sdep", "ListPlay::sdep"}],
Cell[219173, 7693, 197, 5, 21, "Output",
  CellTags->{"ListPlay::sdep", "Play::sdep"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[219431, 7705, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Play::srate", "ListPlay::srate"}],
Cell[219554, 7711, 544, 16, 37, "Message",
  CellTags->{"Play::srate", "ListPlay::srate"}],
Cell[220101, 7729, 280, 6, 40, "Notes",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[CellGroupData[{
Cell[220406, 7739, 82, 1, 38, "ExampleSection",
  CellTags->{"Play::srate", "ListPlay::srate"}],
Cell[220491, 7742, 227, 7, 24, "Text",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[CellGroupData[{
Cell[220743, 7753, 152, 3, 26, "Input",
  CellTags->{"Play::srate", "ListPlay::srate"}],
Cell[220898, 7758, 239, 5, 37, "Message",
  CellTags->{"ListPlay::srate", "Play::srate"}],
Cell[221140, 7765, 158, 3, 21, "Output",
  CellTags->{"ListPlay::srate", "Play::srate"}]
}, Open  ]],
Cell[221313, 7771, 195, 7, 24, "Text",
  CellTags->{"Play::srate", "ListPlay::srate"}],

Cell[CellGroupData[{
Cell[221533, 7782, 153, 3, 26, "Input",
  CellTags->{"Play::srate", "ListPlay::srate"}],
Cell[221689, 7787, 199, 5, 21, "Output",
  CellTags->{"ListPlay::srate", "Play::srate"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[221949, 7799, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Plot3D::plnc"],
Cell[222029, 7802, 644, 16, 37, "Message",
  CellTags->"Plot3D::plnc"],
Cell[222676, 7820, 235, 6, 40, "Notes",
  CellTags->"Plot3D::plnc"],

Cell[CellGroupData[{
Cell[222936, 7830, 62, 1, 38, "ExampleSection",
  CellTags->"Plot3D::plnc"],
Cell[223001, 7833, 211, 5, 40, "Text",
  CellTags->"Plot3D::plnc"],

Cell[CellGroupData[{
Cell[223237, 7842, 122, 3, 26, "Input",
  CellTags->"Plot3D::plnc"],
Cell[223362, 7847, 279, 6, 53, "Message",
  CellTags->"Plot3D::plnc"],
Cell[223644, 7855, 296, 6, 53, "Message",
  CellTags->"Plot3D::plnc"],
Cell[223943, 7863, 296, 6, 53, "Message",
  CellTags->"Plot3D::plnc"],
Cell[224242, 7871, 221, 5, 37, "Message",
  CellTags->"Plot3D::plnc"],
Cell[224466, 7878, 225, 5, 37, "Message",
  CellTags->"Plot3D::plnc"],
Cell[224694, 7885, 225, 5, 37, "Message",
  CellTags->"Plot3D::plnc"],
Cell[224922, 7892, 225, 5, 37, "Message",
  CellTags->"Plot3D::plnc"],
Cell[225150, 7899, 221, 5, 37, "Message",
  CellTags->"Plot3D::plnc"],
Cell[225374, 7906, 189, 5, 21, "Output",
  CellTags->"Plot3D::plnc"]
}, Open  ]],
Cell[225578, 7914, 125, 5, 24, "Text",
  CellTags->"Plot3D::plnc"],

Cell[CellGroupData[{
Cell[225728, 7923, 137, 3, 26, "Input",
  CellTags->"Plot3D::plnc"],
Cell[225868, 7928, 189, 5, 21, "Output",
  CellTags->"Plot3D::plnc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[226118, 7940, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Plot3D::gval"],
Cell[226198, 7943, 208, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[226409, 7950, 148, 4, 24, "Notes",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{
Cell[226582, 7958, 62, 1, 38, "ExampleSection",
  CellTags->"Plot3D::gval"],
Cell[226647, 7961, 211, 5, 40, "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{
Cell[226883, 7970, 122, 3, 26, "Input",
  CellTags->"Plot3D::gval"],
Cell[227008, 7975, 279, 6, 53, "Message",
  CellTags->"Plot3D::gval"],
Cell[227290, 7983, 296, 6, 53, "Message",
  CellTags->"Plot3D::gval"],
Cell[227589, 7991, 296, 6, 53, "Message",
  CellTags->"Plot3D::gval"],
Cell[227888, 7999, 221, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[228112, 8006, 225, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[228340, 8013, 225, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[228568, 8020, 225, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[228796, 8027, 221, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[229020, 8034, 189, 5, 21, "Output",
  CellTags->"Plot3D::gval"]
}, Open  ]],
Cell[229224, 8042, 125, 5, 24, "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{
Cell[229374, 8051, 137, 3, 26, "Input",
  CellTags->"Plot3D::gval"],
Cell[229514, 8056, 189, 5, 21, "Output",
  CellTags->"Plot3D::gval"]
}, Open  ]],
Cell[229718, 8064, 222, 5, 40, "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{
Cell[229965, 8073, 172, 5, 26, "Input",
  CellTags->"Plot3D::gval"],
Cell[230140, 8080, 226, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[230369, 8087, 226, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[230598, 8094, 226, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[230827, 8101, 221, 5, 37, "Message",
  CellTags->"Plot3D::gval"],
Cell[231051, 8108, 189, 5, 21, "Output",
  CellTags->"Plot3D::gval"]
}, Open  ]],
Cell[231255, 8116, 134, 5, 24, "Text",
  CellTags->"Plot3D::gval"],

Cell[CellGroupData[{
Cell[231414, 8125, 124, 3, 26, "Input",
  CellTags->"Plot3D::gval"],
Cell[231541, 8130, 189, 5, 21, "Output",
  CellTags->"Plot3D::gval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[231791, 8142, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Graphics3D::p3mat"],
Cell[231881, 8145, 338, 8, 37, "Message",
  CellTags->"Graphics3D::p3mat"],
Cell[232222, 8155, 292, 8, 40, "Notes",
  CellTags->"Graphics3D::p3mat"],

Cell[CellGroupData[{
Cell[232539, 8167, 67, 1, 38, "ExampleSection",
  CellTags->"Graphics3D::p3mat"],
Cell[232609, 8170, 192, 5, 24, "Text",
  CellTags->"Graphics3D::p3mat"],

Cell[CellGroupData[{
Cell[232826, 8179, 256, 6, 58, "Input",
  CellTags->"Graphics3D::p3mat"],
Cell[233085, 8187, 310, 6, 53, "Message",
  CellTags->"Graphics3D::p3mat"],
Cell[233398, 8195, 189, 5, 21, "Output",
  CellTags->"Graphics3D::p3mat"]
}, Open  ]],
Cell[233602, 8203, 145, 5, 24, "Text",
  CellTags->"Graphics3D::p3mat"],

Cell[CellGroupData[{
Cell[233772, 8212, 269, 6, 58, "Input",
  CellTags->"Graphics3D::p3mat"],
Cell[234044, 8220, 189, 5, 21, "Output",
  CellTags->"Graphics3D::p3mat"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[234294, 8232, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],
Cell[234419, 8238, 391, 11, 21, "Message",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],
Cell[234813, 8251, 649, 20, 84, "Notes",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[CellGroupData[{
Cell[235487, 8275, 83, 1, 38, "ExampleSection",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],
Cell[235573, 8278, 209, 5, 24, "Text",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[CellGroupData[{
Cell[235807, 8287, 150, 3, 26, "Input",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],
Cell[235960, 8292, 189, 4, 21, "Message",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],
Cell[236152, 8298, 151, 3, 21, "Output",
  CellTags->{"PlotRange::gtype", "Show::gtype"}]
}, Open  ]],
Cell[236318, 8304, 104, 1, 24, "Text",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],

Cell[CellGroupData[{
Cell[236447, 8309, 160, 3, 26, "Input",
  CellTags->{"PlotRange::gtype", "Show::gtype"}],
Cell[236610, 8314, 203, 5, 21, "Output",
  CellTags->{"PlotRange::gtype", "Show::gtype"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[236874, 8326, 130, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
Cell[237007, 8332, 487, 13, 21, "Message",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
Cell[237497, 8347, 418, 9, 62, "Notes",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[CellGroupData[{
Cell[237940, 8360, 87, 1, 38, "ExampleSection",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
Cell[238030, 8363, 215, 5, 24, "Text",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[CellGroupData[{
Cell[238270, 8372, 218, 5, 42, "Input",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
Cell[238491, 8379, 244, 5, 37, "Message",
  CellTags->{"RasterArray::rsrec", "Raster::rsrec"}],
Cell[238738, 8386, 207, 5, 21, "Output",
  CellTags->{"RasterArray::rsrec", "Raster::rsrec"}]
}, Open  ]],
Cell[238960, 8394, 150, 5, 24, "Text",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],

Cell[CellGroupData[{
Cell[239135, 8403, 243, 6, 42, "Input",
  CellTags->{"Raster::rsrec", "RasterArray::rsrec"}],
Cell[239381, 8411, 207, 5, 21, "Output",
  CellTags->{"RasterArray::rsrec", "Raster::rsrec"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[239649, 8423, 126, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Raster::rscd", "RasterArray::rscd"}],
Cell[239778, 8429, 348, 10, 21, "Message",
  CellTags->{"RasterArray::rscd", "Raster::rscd"}],
Cell[240129, 8441, 215, 6, 24, "Notes",
  CellTags->{"Raster::rscd", "RasterArray::rscd"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[240381, 8452, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RasterArray::rscol"],
Cell[240473, 8455, 248, 5, 53, "Message",
  CellTags->"RasterArray::rscol"],
Cell[240724, 8462, 198, 6, 24, "Notes",
  CellTags->"RasterArray::rscol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[240959, 8473, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Raster::rsval"],
Cell[241041, 8476, 208, 5, 37, "Message",
  CellTags->"Raster::rsval"],
Cell[241252, 8483, 193, 6, 24, "Notes",
  CellTags->"Raster::rsval"]
}, Open  ]],

Cell[CellGroupData[{
Cell[241482, 8494, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Show::gcc"],
Cell[241556, 8497, 274, 6, 21, "Message",
  CellTags->"Show::gcc"],
Cell[241833, 8505, 563, 12, 90, "Notes",
  CellTags->"Show::gcc"],

Cell[CellGroupData[{
Cell[242421, 8521, 59, 1, 38, "ExampleSection",
  CellTags->"Show::gcc"],
Cell[242483, 8524, 211, 5, 40, "Text",
  CellTags->"Show::gcc"],

Cell[CellGroupData[{
Cell[242719, 8533, 242, 6, 58, "Input",
  CellTags->"Show::gcc"],
Cell[242964, 8541, 322, 6, 37, "Message",
  CellTags->"Show::gcc"],
Cell[243289, 8549, 370, 10, 21, "Output",
  CellTags->"Show::gcc"]
}, Open  ]],
Cell[243674, 8562, 167, 5, 24, "Text",
  CellTags->"Show::gcc"],

Cell[CellGroupData[{
Cell[243866, 8571, 246, 6, 58, "Input",
  CellTags->"Show::gcc"],
Cell[244115, 8579, 184, 5, 21, "Output",
  CellTags->"Show::gcc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[244360, 8591, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Show::gcomb"],
Cell[244438, 8594, 308, 6, 21, "Message",
  CellTags->"Show::gcomb"],
Cell[244749, 8602, 236, 6, 40, "Notes",
  CellTags->"Show::gcomb"],

Cell[CellGroupData[{
Cell[245010, 8612, 61, 1, 38, "ExampleSection",
  CellTags->"Show::gcomb"],
Cell[245074, 8615, 190, 5, 24, "Text",
  CellTags->"Show::gcomb"],

Cell[CellGroupData[{
Cell[245289, 8624, 136, 3, 26, "Input",
  CellTags->"Show::gcomb"],
Cell[245428, 8629, 329, 7, 53, "Message",
  CellTags->"Show::gcomb"],
Cell[245760, 8638, 137, 3, 21, "Output",
  CellTags->"Show::gcomb"]
}, Open  ]],
Cell[245912, 8644, 133, 5, 24, "Text",
  CellTags->"Show::gcomb"],

Cell[CellGroupData[{
Cell[246070, 8653, 163, 4, 42, "Input",
  CellTags->"Show::gcomb"],
Cell[246236, 8659, 181, 5, 21, "Output",
  CellTags->"Show::gcomb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[246478, 8671, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Show::gmed"],
Cell[246554, 8674, 148, 3, 21, "Message",
  CellTags->"Show::gmed"],
Cell[246705, 8679, 944, 20, 166, "Notes",
  CellTags->"Show::gmed"],

Cell[CellGroupData[{
Cell[247674, 8703, 60, 1, 38, "ExampleSection",
  CellTags->"Show::gmed"],
Cell[247737, 8706, 156, 4, 24, "Text",
  CellTags->"Show::gmed"],

Cell[CellGroupData[{
Cell[247918, 8714, 128, 3, 26, "Input",
  CellTags->"Show::gmed"],
Cell[248049, 8719, 164, 4, 21, "Message",
  CellTags->"Show::gmed"],
Cell[248216, 8725, 180, 5, 21, "Output",
  CellTags->"Show::gmed"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[248457, 8737, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Show::shx"],
Cell[248531, 8740, 139, 3, 21, "Message",
  CellTags->"Show::shx"],
Cell[248673, 8745, 187, 5, 24, "Notes",
  CellTags->"Show::shx"],

Cell[CellGroupData[{
Cell[248885, 8754, 59, 1, 38, "ExampleSection",
  CellTags->"Show::shx"],
Cell[248947, 8757, 187, 5, 24, "Text",
  CellTags->"Show::shx"],

Cell[CellGroupData[{
Cell[249159, 8766, 121, 3, 26, "Input",
  CellTags->"Show::shx"],
Cell[249283, 8771, 155, 4, 21, "Message",
  CellTags->"Show::shx"],
Cell[249441, 8777, 133, 3, 21, "Output",
  CellTags->"Show::shx"]
}, Open  ]],
Cell[249589, 8783, 120, 5, 24, "Text",
  CellTags->"Show::shx"],

Cell[CellGroupData[{
Cell[249734, 8792, 178, 4, 42, "Input",
  CellTags->"Show::shx"],
Cell[249915, 8798, 179, 5, 21, "Output",
  CellTags->"Show::shx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[250155, 8810, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Sound::ssnf"],
Cell[250233, 8813, 416, 11, 21, "Message",
  CellTags->"Sound::ssnf"],
Cell[250652, 8826, 202, 6, 24, "Notes",
  CellTags->"Sound::ssnf"],

Cell[CellGroupData[{
Cell[250879, 8836, 61, 1, 38, "ExampleSection",
  CellTags->"Sound::ssnf"],
Cell[250943, 8839, 225, 6, 40, "Text",
  CellTags->"Sound::ssnf"],

Cell[CellGroupData[{
Cell[251193, 8849, 142, 3, 26, "Input",
  CellTags->"Sound::ssnf"],
Cell[251338, 8854, 205, 5, 37, "Message",
  CellTags->"Sound::ssnf"],
Cell[251546, 8861, 178, 5, 21, "Output",
  CellTags->"Sound::ssnf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[251785, 8873, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Sound::ssnm"],
Cell[251863, 8876, 249, 4, 37, "Message",
  CellTags->"Sound::ssnm"],
Cell[252115, 8882, 423, 9, 78, "Notes",
  CellTags->"Sound::ssnm"],

Cell[CellGroupData[{
Cell[252563, 8895, 61, 1, 38, "ExampleSection",
  CellTags->"Sound::ssnm"],
Cell[252627, 8898, 179, 4, 40, "Text",
  CellTags->"Sound::ssnm"],

Cell[CellGroupData[{
Cell[252831, 8906, 125, 3, 26, "Input",
  CellTags->"Sound::ssnm"],
Cell[252959, 8911, 242, 5, 37, "Message",
  CellTags->"Sound::ssnm"],
Cell[253204, 8918, 178, 5, 21, "Output",
  CellTags->"Sound::ssnm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[253443, 8930, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SurfaceColor::shine"],
Cell[253537, 8933, 418, 10, 37, "Message",
  CellTags->"SurfaceColor::shine"],
Cell[253958, 8945, 197, 5, 24, "Notes",
  CellTags->"SurfaceColor::shine"],

Cell[CellGroupData[{
Cell[254180, 8954, 69, 1, 38, "ExampleSection",
  CellTags->"SurfaceColor::shine"],
Cell[254252, 8957, 249, 7, 40, "Text",
  CellTags->"SurfaceColor::shine"],

Cell[CellGroupData[{
Cell[254526, 8968, 248, 6, 58, "Input",
  CellTags->"SurfaceColor::shine"],
Cell[254777, 8976, 356, 6, 69, "Message",
  CellTags->"SurfaceColor::shine"],
Cell[255136, 8984, 191, 5, 21, "Output",
  CellTags->"SurfaceColor::shine"]
}, Open  ]],
Cell[255342, 8992, 141, 5, 24, "Text",
  CellTags->"SurfaceColor::shine"],

Cell[CellGroupData[{
Cell[255508, 9001, 224, 5, 58, "Input",
  CellTags->"SurfaceColor::shine"],
Cell[255735, 9008, 191, 5, 21, "Output",
  CellTags->"SurfaceColor::shine"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[255987, 9020, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SurfaceColor::specl"],
Cell[256081, 9023, 440, 10, 37, "Message",
  CellTags->"SurfaceColor::specl"],
Cell[256524, 9035, 199, 5, 24, "Notes",
  CellTags->"SurfaceColor::specl"],

Cell[CellGroupData[{
Cell[256748, 9044, 69, 1, 38, "ExampleSection",
  CellTags->"SurfaceColor::specl"],
Cell[256820, 9047, 213, 5, 40, "Text",
  CellTags->"SurfaceColor::specl"],

Cell[CellGroupData[{
Cell[257058, 9056, 210, 5, 42, "Input",
  CellTags->"SurfaceColor::specl"],
Cell[257271, 9063, 324, 6, 69, "Message",
  CellTags->"SurfaceColor::specl"],
Cell[257598, 9071, 191, 5, 21, "Output",
  CellTags->"SurfaceColor::specl"]
}, Open  ]],
Cell[257804, 9079, 138, 5, 24, "Text",
  CellTags->"SurfaceColor::specl"],

Cell[CellGroupData[{
Cell[257967, 9088, 221, 5, 42, "Input",
  CellTags->"SurfaceColor::specl"],
Cell[258191, 9095, 191, 5, 21, "Output",
  CellTags->"SurfaceColor::specl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[258443, 9107, 202, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],
Cell[258648, 9115, 581, 14, 37, "Message",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],
Cell[259232, 9131, 327, 8, 40, "Notes",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],

Cell[CellGroupData[{
Cell[259584, 9143, 126, 2, 38, "ExampleSection",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],
Cell[259713, 9147, 373, 10, 40, "Text",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],

Cell[CellGroupData[{
Cell[260111, 9161, 360, 7, 74, "Input",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],
Cell[260474, 9170, 386, 7, 53, "Message",
  CellTags->{
  "ContourGraphics::pmsr", "DensityGraphics::pmsr", 
    "SurfaceGraphics::pmsr"}],
Cell[260863, 9179, 253, 6, 21, "Output",
  CellTags->{
  "ContourGraphics::pmsr", "DensityGraphics::pmsr", "SurfaceGraphics::pmsr"}]
}, Open  ]],
Cell[261131, 9188, 267, 8, 24, "Text",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],

Cell[CellGroupData[{
Cell[261423, 9200, 362, 7, 74, "Input",
  CellTags->{
  "SurfaceGraphics::pmsr", "DensityGraphics::pmsr", 
    "ContourGraphics::pmsr"}],
Cell[261788, 9209, 253, 6, 21, "Output",
  CellTags->{
  "ContourGraphics::pmsr", "DensityGraphics::pmsr", "SurfaceGraphics::pmsr"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[262102, 9222, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SurfaceGraphics::shade"],
Cell[262202, 9225, 293, 6, 37, "Message",
  CellTags->"SurfaceGraphics::shade"],
Cell[262498, 9233, 861, 24, 116, "Notes",
  CellTags->"SurfaceGraphics::shade"],

Cell[CellGroupData[{
Cell[263384, 9261, 72, 1, 38, "ExampleSection",
  CellTags->"SurfaceGraphics::shade"],
Cell[263459, 9264, 290, 6, 40, "Text",
  CellTags->"SurfaceGraphics::shade"],

Cell[CellGroupData[{
Cell[263774, 9274, 335, 7, 74, "Input",
  CellTags->"SurfaceGraphics::shade"],
Cell[264112, 9283, 387, 7, 53, "Message",
  CellTags->"SurfaceGraphics::shade"],
Cell[264502, 9292, 199, 5, 21, "Output",
  CellTags->"SurfaceGraphics::shade"]
}, Open  ]],
Cell[264716, 9300, 129, 4, 24, "Text",
  CellTags->"SurfaceGraphics::shade"],

Cell[CellGroupData[{
Cell[264870, 9308, 373, 7, 90, "Input",
  CellTags->"SurfaceGraphics::shade"],
Cell[265246, 9317, 199, 5, 21, "Output",
  CellTags->"SurfaceGraphics::shade"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[265506, 9329, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Text::textn"],
Cell[265584, 9332, 239, 6, 21, "Message",
  CellTags->"Text::textn"],
Cell[265826, 9340, 185, 5, 24, "Notes",
  CellTags->"Text::textn"],

Cell[CellGroupData[{
Cell[266036, 9349, 61, 1, 38, "ExampleSection",
  CellTags->"Text::textn"],
Cell[266100, 9352, 198, 5, 24, "Text",
  CellTags->"Text::textn"],

Cell[CellGroupData[{
Cell[266323, 9361, 176, 5, 26, "Input",
  CellTags->"Text::textn"],
Cell[266502, 9368, 175, 4, 21, "Message",
  CellTags->"Text::textn"],
Cell[266680, 9374, 181, 5, 21, "Output",
  CellTags->"Text::textn"]
}, Open  ]],
Cell[266876, 9382, 122, 5, 24, "Text",
  CellTags->"Text::textn"],

Cell[CellGroupData[{
Cell[267023, 9391, 181, 5, 42, "Input",
  CellTags->"Text::textn"],
Cell[267207, 9398, 181, 5, 21, "Output",
  CellTags->"Text::textn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[267449, 9410, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Text::textz"],
Cell[267527, 9413, 167, 3, 21, "Message",
  CellTags->"Text::textz"],
Cell[267697, 9418, 189, 7, 24, "Notes",
  CellTags->"Text::textz"],

Cell[CellGroupData[{
Cell[267911, 9429, 61, 1, 38, "ExampleSection",
  CellTags->"Text::textz"],
Cell[267975, 9432, 190, 6, 24, "Text",
  CellTags->"Text::textz"],

Cell[CellGroupData[{
Cell[268190, 9442, 183, 5, 42, "Input",
  CellTags->"Text::textz"],
Cell[268376, 9449, 179, 4, 21, "Message",
  CellTags->"Text::textz"],
Cell[268558, 9455, 181, 5, 21, "Output",
  CellTags->"Text::textz"]
}, Open  ]],
Cell[268754, 9463, 122, 5, 24, "Text",
  CellTags->"Text::textz"],

Cell[CellGroupData[{
Cell[268901, 9472, 183, 5, 42, "Input",
  CellTags->"Text::textz"],
Cell[269087, 9479, 181, 5, 21, "Output",
  CellTags->"Text::textz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[269329, 9491, 144, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
Cell[269476, 9497, 406, 11, 21, "Message",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
Cell[269885, 9510, 253, 7, 24, "Notes",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[CellGroupData[{
Cell[270163, 9521, 94, 1, 38, "ExampleSection",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
Cell[270260, 9524, 217, 5, 24, "Text",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[CellGroupData[{
Cell[270502, 9533, 250, 5, 42, "Input",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
Cell[270755, 9540, 234, 5, 21, "Message",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
Cell[270992, 9547, 234, 5, 21, "Message",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
Cell[271229, 9554, 221, 5, 21, "Output",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}]
}, Open  ]],
Cell[271465, 9562, 161, 5, 24, "Text",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],

Cell[CellGroupData[{
Cell[271651, 9571, 248, 5, 42, "Input",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}],
Cell[271902, 9578, 221, 5, 21, "Output",
  CellTags->{"AbsoluteThickness::thkn", "Thickness::thkn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[272184, 9590, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Ticks::ticks"],
Cell[272264, 9593, 212, 5, 21, "Message",
  CellTags->"Ticks::ticks"],
Cell[272479, 9600, 318, 10, 40, "Notes",
  CellTags->"Ticks::ticks"],

Cell[CellGroupData[{
Cell[272822, 9614, 62, 1, 38, "ExampleSection",
  CellTags->"Ticks::ticks"],
Cell[272887, 9617, 255, 6, 40, "Text",
  CellTags->"Ticks::ticks"],

Cell[CellGroupData[{
Cell[273167, 9627, 172, 4, 26, "Input",
  CellTags->"Ticks::ticks"],
Cell[273342, 9633, 235, 5, 21, "Message",
  CellTags->"Ticks::ticks"],
Cell[273580, 9640, 182, 5, 21, "Output",
  CellTags->"Ticks::ticks"]
}, Open  ]],
Cell[273777, 9648, 163, 5, 24, "Text",
  CellTags->"Ticks::ticks"],

Cell[CellGroupData[{
Cell[273965, 9657, 182, 5, 42, "Input",
  CellTags->"Ticks::ticks"],
Cell[274150, 9664, 182, 5, 21, "Output",
  CellTags->"Ticks::ticks"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[274393, 9676, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
Cell[274528, 9682, 713, 17, 53, "Message",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
Cell[275244, 9701, 403, 8, 62, "Notes",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[CellGroupData[{
Cell[275672, 9713, 88, 1, 38, "ExampleSection",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
Cell[275763, 9716, 272, 6, 40, "Text",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[CellGroupData[{
Cell[276060, 9726, 185, 4, 26, "Input",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
Cell[276248, 9732, 416, 7, 69, "Message",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
Cell[276667, 9741, 208, 5, 21, "Output",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}]
}, Open  ]],
Cell[276890, 9749, 166, 5, 24, "Text",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],

Cell[CellGroupData[{
Cell[277081, 9758, 187, 4, 26, "Input",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}],
Cell[277271, 9764, 208, 5, 21, "Output",
  CellTags->{"ColorOutput::colpc", "ToColor::colpc"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[277540, 9776, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
Cell[277675, 9782, 675, 16, 37, "Message",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
Cell[278353, 9800, 403, 8, 62, "Notes",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[CellGroupData[{
Cell[278781, 9812, 88, 1, 38, "ExampleSection",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
Cell[278872, 9815, 288, 7, 40, "Text",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[CellGroupData[{
Cell[279185, 9826, 183, 4, 26, "Input",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
Cell[279371, 9832, 361, 7, 69, "Message",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
Cell[279735, 9841, 208, 5, 21, "Output",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}]
}, Open  ]],
Cell[279958, 9849, 166, 5, 24, "Text",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],

Cell[CellGroupData[{
Cell[280149, 9858, 196, 4, 26, "Input",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}],
Cell[280348, 9864, 208, 5, 21, "Output",
  CellTags->{"ColorOutput::colpw", "ToColor::colpw"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[280617, 9876, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToColor::tocol"],
Cell[280701, 9879, 270, 6, 37, "Message",
  CellTags->"ToColor::tocol"],
Cell[280974, 9887, 188, 5, 24, "Notes",
  CellTags->"ToColor::tocol"],

Cell[CellGroupData[{
Cell[281187, 9896, 64, 1, 38, "ExampleSection",
  CellTags->"ToColor::tocol"],
Cell[281254, 9899, 136, 4, 24, "Text",
  CellTags->"ToColor::tocol"],

Cell[CellGroupData[{
Cell[281415, 9907, 107, 3, 26, "Input",
  CellTags->"ToColor::tocol"],
Cell[281525, 9912, 206, 5, 37, "Message",
  CellTags->"ToColor::tocol"],
Cell[281734, 9919, 108, 3, 21, "Output",
  CellTags->"ToColor::tocol"]
}, Open  ]],
Cell[281857, 9925, 128, 5, 24, "Text",
  CellTags->"ToColor::tocol"],

Cell[CellGroupData[{
Cell[282010, 9934, 118, 3, 26, "Input",
  CellTags->"ToColor::tocol"],
Cell[282131, 9939, 111, 3, 21, "Output",
  CellTags->"ToColor::tocol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[282303, 9949, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::colfun"],
Cell[282389, 9952, 642, 18, 37, "Message",
  CellTags->"General::colfun"],
Cell[283034, 9972, 246, 6, 40, "Notes",
  CellTags->"General::colfun"],

Cell[CellGroupData[{
Cell[283305, 9982, 65, 1, 38, "ExampleSection",
  CellTags->"General::colfun"],
Cell[283373, 9985, 261, 8, 40, "Text",
  CellTags->"General::colfun"],

Cell[CellGroupData[{
Cell[283659, 9997, 171, 5, 26, "Input",
  CellTags->"General::colfun"],
Cell[283833, 10004, 202, 5, 21, "Message",
  CellTags->"General::colfun"],
Cell[284038, 10011, 269, 5, 53, "Message",
  CellTags->"General::colfun"],
Cell[284310, 10018, 201, 5, 21, "Message",
  CellTags->"General::colfun"],
Cell[284514, 10025, 269, 5, 53, "Message",
  CellTags->"General::colfun"],
Cell[284786, 10032, 201, 5, 21, "Message",
  CellTags->"General::colfun"],
Cell[284990, 10039, 223, 5, 37, "Message",
  CellTags->"General::colfun"],
Cell[285216, 10046, 269, 5, 53, "Message",
  CellTags->"General::colfun"],
Cell[285488, 10053, 235, 5, 37, "Message",
  CellTags->"General::colfun"],
Cell[285726, 10060, 192, 5, 21, "Output",
  CellTags->"General::colfun"]
}, Open  ]],
Cell[285933, 10068, 145, 5, 24, "Text",
  CellTags->"General::colfun"],

Cell[CellGroupData[{
Cell[286103, 10077, 192, 5, 42, "Input",
  CellTags->"General::colfun"],
Cell[286298, 10084, 192, 5, 21, "Output",
  CellTags->"General::colfun"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[286551, 10096, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::colfun1"],
Cell[286639, 10099, 565, 15, 37, "Message",
  CellTags->"General::colfun1"],
Cell[287207, 10116, 253, 6, 40, "Notes",
  CellTags->"General::colfun1"],

Cell[CellGroupData[{
Cell[287485, 10126, 66, 1, 38, "ExampleSection",
  CellTags->"General::colfun1"],
Cell[287554, 10129, 239, 6, 40, "Text",
  CellTags->"General::colfun1"],

Cell[CellGroupData[{
Cell[287818, 10139, 246, 6, 42, "Input",
  CellTags->"General::colfun1"],
Cell[288067, 10147, 379, 7, 69, "Message",
  CellTags->"General::colfun1"],
Cell[288449, 10156, 379, 7, 69, "Message",
  CellTags->"General::colfun1"],
Cell[288831, 10165, 193, 5, 21, "Output",
  CellTags->"General::colfun1"]
}, Open  ]],
Cell[289039, 10173, 146, 5, 24, "Text",
  CellTags->"General::colfun1"],

Cell[CellGroupData[{
Cell[289210, 10182, 251, 6, 42, "Input",
  CellTags->"General::colfun1"],
Cell[289464, 10190, 193, 5, 21, "Output",
  CellTags->"General::colfun1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[289718, 10202, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::argx"],
Cell[289814, 10205, 194, 3, 37, "Message",
  CellTags->"RasterGraphics::argx"],
Cell[290011, 10210, 131, 4, 24, "Notes",
  CellTags->"RasterGraphics::argx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[290179, 10219, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::rrng"],
Cell[290275, 10222, 230, 4, 37, "Message",
  CellTags->"RasterGraphics::rrng"],
Cell[290508, 10228, 131, 4, 24, "Notes",
  CellTags->"RasterGraphics::rrng"]
}, Open  ]],

Cell[CellGroupData[{
Cell[290676, 10237, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::optx"],
Cell[290772, 10240, 158, 3, 21, "Message",
  CellTags->"RasterGraphics::optx"],
Cell[290933, 10245, 131, 4, 24, "Notes",
  CellTags->"RasterGraphics::optx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[291101, 10254, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::nonopt"],
Cell[291201, 10257, 275, 5, 37, "Message",
  CellTags->"RasterGraphics::nonopt"],
Cell[291479, 10264, 133, 4, 24, "Notes",
  CellTags->"RasterGraphics::nonopt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[291649, 10273, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::gmat"],
Cell[291745, 10276, 176, 3, 21, "Message",
  CellTags->"RasterGraphics::gmat"],
Cell[291924, 10281, 131, 4, 24, "Notes",
  CellTags->"RasterGraphics::gmat"]
}, Open  ]],

Cell[CellGroupData[{
Cell[292092, 10290, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RasterGraphics::zval"],
Cell[292188, 10293, 212, 4, 37, "Message",
  CellTags->"RasterGraphics::zval"],
Cell[292403, 10299, 131, 4, 24, "Notes",
  CellTags->"RasterGraphics::zval"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

